﻿USE sofia;
DROP TABLE IF EXISTS sofia.sansin_vpl;
CREATE TABLE sansin_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sansin_vpl WRITE;
INSERT INTO sansin_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ඉබ්‍රාහීමඃ සන්තානෝ දායූද් තස්‍ය සන්තානෝ යීශුඛ්‍රීෂ්ටස්තස්‍ය පූර්ව්වපුරුෂවංශශ්‍රේණී| ");
INSERT INTO sansin_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ඉබ්‍රාහීමඃ පුත්‍ර ඉස්හාක් තස්‍ය පුත්‍රෝ යාකූබ් තස්‍ය පුත්‍රෝ යිහූදාස්තස්‍ය භ්‍රාතරශ්ච| ");
INSERT INTO sansin_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","තස්මාද් යිහූදාතස්තාමරෝ ගර්භේ පේරස්සේරහෞ ජඥාතේ, තස්‍ය පේරසඃ පුත්‍රෝ හිෂ්‍රෝණ් තස්‍ය පුත්‍රෝ (අ)රාම්| ");
INSERT INTO sansin_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","තස්‍ය පුත්‍රෝ (අ)ම්මීනාදබ් තස්‍ය පුත්‍රෝ නහශෝන් තස්‍ය පුත්‍රඃ සල්මෝන්| ");
INSERT INTO sansin_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","තස්මාද් රාහබෝ ගර්භේ බෝයම් ජඥේ, තස්මාද් රූතෝ ගර්භේ ඕබේද් ජඥේ, තස්‍ය පුත්‍රෝ යිශයඃ| ");
INSERT INTO sansin_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","තස්‍ය පුත්‍රෝ දායූද් රාජඃ තස්මාද් මෘතෝරියස්‍ය ජායායාං සුලේමාන් ජඥේ| ");
INSERT INTO sansin_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","තස්‍ය පුත්‍රෝ රිහබියාම්, තස්‍ය පුත්‍රෝ(අ)බියඃ, තස්‍ය පුත්‍ර ආසා:| ");
INSERT INTO sansin_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","තස්‍ය සුතෝ යිහෝශාඵට් තස්‍ය සුතෝ යිහෝරාම තස්‍ය සුත උෂියඃ| ");
INSERT INTO sansin_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","තස්‍ය සුතෝ යෝථම් තස්‍ය සුත ආහම් තස්‍ය සුතෝ හිෂ්කියඃ| ");
INSERT INTO sansin_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","තස්‍ය සුතෝ මිනශිඃ, තස්‍ය සුත ආමෝන් තස්‍ය සුතෝ යෝශියඃ| ");
INSERT INTO sansin_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","බාබිල්නගරේ ප්‍රවසනාත් පූර්ව්වං ස යෝශියෝ යිඛනියං තස්‍ය භ්‍රාතෘංශ්ච ජනයාමාස| ");
INSERT INTO sansin_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","තතෝ බාබිලි ප්‍රවසනකාලේ යිඛනියඃ ශල්තීයේලං ජනයාමාස, තස්‍ය සුතඃ සිරුබ්බාවිල්| ");
INSERT INTO sansin_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","තස්‍ය සුතෝ (අ)බෝහුද් තස්‍ය සුත ඉලීයාකීම් තස්‍ය සුතෝ(අ)සෝර්| ");
INSERT INTO sansin_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","අසෝරඃ සුතඃ සාදෝක් තස්‍ය සුත ආඛීම් තස්‍ය සුත ඉලීහූද්| ");
INSERT INTO sansin_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","තස්‍ය සුත ඉලියාසර් තස්‍ය සුතෝ මත්තන්| ");
INSERT INTO sansin_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","තස්‍ය සුතෝ යාකූබ් තස්‍ය සුතෝ යූෂඵ් තස්‍ය ජායා මරියම්; තස්‍ය ගර්භේ යීශුරජනි, තමේව ඛ්‍රීෂ්ටම් (අර්ථාද් අභිෂික්තං) වදන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ඉත්ථම් ඉබ්‍රාහීමෝ දායූදං යාවත් සාකල්‍යේන චතුර්දශපුරුෂාඃ; ආ දායූදඃ කාලාද් බාබිලි ප්‍රවසනකාලං යාවත් චතුර්දශපුරුෂා භවන්ති| බාබිලි ප්‍රවාසනකාලාත් ඛ්‍රීෂ්ටස්‍ය කාලං යාවත් චතුර්දශපුරුෂා භවන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","යීශුඛ්‍රීෂ්ටස්‍ය ජන්ම කථ්ථතේ| මරියම් නාමිකා කන්‍යා යූෂඵේ වාග්දත්තාසීත්, තදා තයෝඃ සඞ්ගමාත් ප්‍රාක් සා කන්‍යා  පවිත්‍රේණාත්මනා ගර්භවතී බභූව| ");
INSERT INTO sansin_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","තත්‍ර තස්‍යාඃ පති ර‍්‍යූෂඵ් සෞජන්‍යාත් තස්‍යාඃ කලඞ්ගං ප්‍රකාශයිතුම් අනිච්ඡන් ගෝපනේනේ තාං පාරිත්‍යක්තුං මනශ්චක්‍රේ| ");
INSERT INTO sansin_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ස තථෛව භාවයති, තදානීං පරමේශ්වරස්‍ය දූතඃ ස්වප්නේ තං දර්ශනං දත්ත්වා ව්‍යාජහාර, හේ දායූදඃ සන්තාන යූෂඵ් ත්වං නිජාං ජායාං මරියමම් ආදාතුං මා භෛෂීඃ| ");
INSERT INTO sansin_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","යතස්තස්‍යා ගර්භඃ පවිත්‍රාදාත්මනෝ(අ)භවත්, සා ච පුත්‍රං ප්‍රසවිෂ්‍යතේ, තදා ත්වං තස්‍ය නාම යීශුම් (අර්ථාත් ත්‍රාතාරං) කරීෂ්‍යසේ, යස්මාත් ස නිජමනුජාන් තේෂාං කලුෂේභ්‍ය උද්ධරිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ඉත්ථං සති, පශ්‍ය ගර්භවතී කන්‍යා තනයං ප්‍රසවිෂ්‍යතේ| ඉම්මානූයේල් තදීයඤ්ච නාමධේයං භවිෂ්‍යති|| ඉම්මානූයේල් අස්මාකං සඞ්ගීශ්වරඉත්‍යර්ථඃ| ");
INSERT INTO sansin_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","ඉති යද් වචනං පුර්ව්වං භවිෂ්‍යද්වක්ත්‍රා ඊශ්වරඃ කථායාමාස, තත් තදානීං සිද්ධමභවත්| ");
INSERT INTO sansin_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","අනන්තරං යූෂඵ් නිද්‍රාතෝ ජාගරිත උත්ථාය පරමේශ්වරීයදූතස්‍ය නිදේශානුසාරේණ නිජාං ජායාං ජග්‍රාහ, ");
INSERT INTO sansin_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","කින්තු යාවත් සා නිජං ප්‍රථමසුතං අ සුෂුවේ, තාවත් තාං නෝපාගච්ඡත්, තතඃ සුතස්‍ය නාම යීශුං චක්‍රේ| ");
INSERT INTO sansin_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","අනන්තරං හේරෝද් සංඥකේ රාඥි රාජ්‍යං ශාසති යිහූදීයදේශස්‍ය බෛත්ලේහමි නගරේ යීශෞ ජාතවති ච, කතිපයා ජ්‍යෝතිර්ව්වුදඃ පූර්ව්වස්‍යා දිශෝ යිරූශාලම්නගරං සමේත්‍ය කථයමාසුඃ, ");
INSERT INTO sansin_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","යෝ යිහූදීයානාං රාජා ජාතවාන්, ස කුත්‍රාස්තේ? වයං පූර්ව්වස්‍යාං දිශි තිෂ්ඨන්තස්තදීයාං තාරකාම් අපශ්‍යාම තස්මාත් තං ප්‍රණන්තුම් අाගමාම| ");
INSERT INTO sansin_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","තදා හේරෝද් රාජා කථාමේතාං නිශම්‍ය යිරූශාලම්නගරස්ථිතෛඃ සර්ව්වමානවෛඃ සාර්ද්ධම් උද්විජ්‍ය ");
INSERT INTO sansin_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","සර්ව්වාන් ප්‍රධානයාජකාන් අධ්‍යාපකාංශ්ච සමාහූයානීය පප්‍රච්ඡ, ඛ්‍රීෂ්ටඃ කුත්‍ර ජනිෂ්‍යතේ? ");
INSERT INTO sansin_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","තදා තේ කථයාමාසුඃ, යිහූදීයදේශස්‍ය බෛත්ලේහමි නගරේ, යතෝ භවිෂ්‍යද්වාදිනා ඉත්ථං ලිඛිතමාස්තේ, ");
INSERT INTO sansin_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","සර්ව්වාභ්‍යෝ රාජධානීභ්‍යෝ යිහූදීයස්‍ය නීවෘතඃ| හේ යීහූදීයදේශස්‍යේ බෛත්ලේහම් ත්වං න චාවරා| ඉස්‍රායේලීයලෝකාන් මේ යතෝ යඃ පාලයිෂ්‍යති| තාදෘගේකෝ මහාරාජස්ත්වන්මධ්‍ය උද්භවිෂ්‍යතී|| ");
INSERT INTO sansin_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","තදානීං හේරෝද් රාජා තාන් ජ්‍යෝතිර්ව්විදෝ ගෝපනම් ආහූය සා තාරකා කදා දෘෂ්ටාභවත් , තද් විනිශ්චයාමාස| ");
INSERT INTO sansin_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","අපරං තාන් බෛත්ලේහමං ප්‍රහීත්‍ය ගදිතවාන්, යූයං යාත, යත්නාත් තං ශිශුම් අන්විෂ්‍ය තදුද්දේශේ ප්‍රාප්තේ මහ්‍යං වාර්ත්තාං දාස්‍යථ, තතෝ මයාපි ගත්වා ස ප්‍රණංස්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","තදානීං රාඥ ඒතාදෘශීම් ආඥාං ප්‍රාප්‍ය තේ ප්‍රතස්ථිරේ, තතඃ පූර්ව්වර්ස්‍යාං දිශි ස්ථිතෛස්තෛ ර‍්‍යා තාරකා දෘෂ්ටා සා තාරකා තේෂාමග්‍රේ ගත්වා යත්‍ර ස්ථානේ ශිශූරාස්තේ, තස්‍ය ස්ථානස්‍යෝපරි ස්ථගිතා තස්‍යෞ| ");
INSERT INTO sansin_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","තද් දෘෂ්ට්වා තේ මහානන්දිතා බභූවුඃ, ");
INSERT INTO sansin_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","තතෝ ගේහමධ්‍ය ප්‍රවිශ්‍ය තස්‍ය මාත්‍රා මරියමා සාද්ධං තං ශිශුං නිරීක්‍ෂය දණ්ඩවද් භූත්වා ප්‍රණේමුඃ, අපරං ස්වේෂාං ඝනසම්පත්තිං මෝචයිත්වා සුවර්ණං කුන්දුරුං ගන්ධරමඤ්ච තස්මෛ දර්ශනීයං දත්තවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","පශ්චාද් හේරෝද් රාජස්‍ය සමීපං පුනරපි ගන්තුං ස්වප්න ඊශ්වරේණ නිෂිද්ධාඃ සන්තෝ (අ)න්‍යේන පථා තේ නිජදේශං ප්‍රති ප්‍රතස්ථිරේ| ");
INSERT INTO sansin_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","අනන්තරං තේෂු ගතවත්මු පරමේශ්වරස්‍ය දූතෝ යූෂඵේ ස්වප්නේ දර්ශනං දත්වා ජගාද, ත්වම් උත්ථාය ශිශුං තන්මාතරඤ්ච ගෘහීත්වා මිසර්දේශං පලායස්ව, අපරං යාවදහං තුභ්‍යං වාර්ත්තාං න කථයිෂ්‍යාමි, තාවත් තත්‍රෛව නිවස, යතෝ රාජා හේරෝද් ශිශුං නාශයිතුං මෘගයිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","තදානීං යූෂඵ් උත්ථාය රජන්‍යාං ශිශුං තන්මාතරඤ්ච ගෘහීත්වා මිසර්දේශං ප්‍රති ප්‍රතස්ථේ, ");
INSERT INTO sansin_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ගත්වා ච හේරෝදෝ නෘපතේ ර්මරණපර‍්‍ය්‍යන්තං තත්‍ර දේශේ න්‍යුවාස, තේන මිසර්දේශාදහං පුත්‍රං ස්වකීයං සමුපාහූයම්| යදේතද්වචනම් ඊශ්වරේණ භවිෂ්‍යද්වාදිනා කථිතං තත් සඵලමභූත්| ");
INSERT INTO sansin_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","අනන්තරං හේරෝද් ජ්‍යෝතිර්විද්භිරාත්මානං ප්‍රවඤ්චිතං විඥාය භෘශං චුකෝප; අපරං ජ්‍යෝතිර්ව්විද්භ්‍යස්තේන විනිශ්චිතං යද් දිනං තද්දිනාද් ගණයිත්වා ද්විතීයවත්සරං ප්‍රවිෂ්ටා යාවන්තෝ බාලකා අස්මින් බෛත්ලේහම්නගරේ තත්සීමමධ්‍යේ චාසන්, ලෝකාන් ප්‍රහිත්‍ය තාන් සර්ව්වාන් ඝාතයාමාස| ");
INSERT INTO sansin_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","අතඃ අනේකස්‍ය විලාපස්‍ය නිනාද: ක්‍රන්දනස්‍ය ච| ශෝකේන කෘතශබ්දශ්ච රාමායාං සංනිශම්‍යතේ| ස්වබාලගණහේතෝර්වෛ රාහේල් නාරී තු රෝදිනී| න මන්‍යතේ ප්‍රබෝධන්තු යතස්තේ නෛව මන්ති හි|| ");
INSERT INTO sansin_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","යදේතද් වචනං යිරීමියනාමකභවිෂ්‍යද්වාදිනා කථිතං තත් තදානීං සඵලම් අභූත්| ");
INSERT INTO sansin_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","තදනන්තරං හේරේදි රාජනි මෘතේ පරමේශ්වරස්‍ය දූතෝ මිසර්දේශේ ස්වප්නේ දර්ශනං දත්ත්වා යූෂඵේ කථිතවාන් ");
INSERT INTO sansin_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ත්වම් උත්ථාය ශිශුං තන්මාතරඤ්ච ගෘහීත්වා පුනරපීස්‍රායේලෝ දේශං යාහී, යේ ජනාඃ ශිශුං නාශයිතුම් අමෘගයන්ත, තේ මෘතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","තදානීං ස උත්ථාය ශිශුං තන්මාතරඤ්ච ගෘහ්ලන් ඉස්‍රායේල්දේශම් ආජගාම| ");
INSERT INTO sansin_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","කින්තු යිහූදීයදේශේ අර්ඛිලායනාම රාජකුමාරෝ නිජපිතු ර්හේරෝදඃ පදං ප්‍රාප්‍ය රාජත්වං කරෝතීති නිශම්‍ය තත් ස්ථානං යාතුං ශඞ්කිතවාන්, පශ්චාත් ස්වප්න ඊශ්වරාත් ප්‍රබෝධං ප්‍රාප්‍ය ගාලීල්දේශස්‍ය ප්‍රදේශෛකං ප්‍රස්ථාය නාසරන්නාම නගරං ගත්වා තත්‍ර න්‍යුෂිතවාන්, ");
INSERT INTO sansin_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","තේන තං නාසරතීයං කථයිෂ්‍යන්ති, යදේතද්වාක්‍යං භවිෂ්‍යද්වාදිභිරුක්ත්තං තත් සඵලමභවත්| ");
INSERT INTO sansin_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","තදානෝං යෝහ්න්නාමා මජ්ජයිතා යිහූදීයදේශස්‍ය ප්‍රාන්තරම් උපස්ථාය ප්‍රචාරයන් කථයාමාස, ");
INSERT INTO sansin_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","මනාංසි පරාවර්ත්තයත, ස්වර්ගීයරාජත්වං සමීපමාගතම්| ");
INSERT INTO sansin_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","පරමේශස්‍ය පන්ථානං පරිෂ්කුරුත සර්ව්වතඃ| තස්‍ය රාජපථාංශ්චෛව සමීකුරුත සර්ව්වථා| ඉත්‍යේතත් ප්‍රාන්තරේ වාක්‍යං වදතඃ කස්‍යචිද් රවඃ|| ");
INSERT INTO sansin_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ඒතද්වචනං යිශයියභවිෂ්‍යද්වාදිනා යෝහනමුද්දිශ්‍ය භාෂිතම්| යෝහනෝ වසනං මහාඞ්ගරෝමජං තස්‍ය කටෞ චර්ම්මකටිබන්ධනං; ස ච ශූකකීටාන් මධු ච භුක්තවාන්| ");
INSERT INTO sansin_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","තදානීං යිරූශාලම්නගරනිවාසිනඃ සර්ව්වේ යිහූදිදේශීයා යර්ද්දන්තටින්‍යා උභයතටස්ථාශ්ච මානවා බහිරාගත්‍ය තස්‍ය සමීපේ ");
INSERT INTO sansin_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ස්වීයං ස්වීයං දුරිතම් අඞ්ගීකෘත්‍ය තස්‍යාං යර්ද්දනි තේන මජ්ජිතා බභූවුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","අපරං බහූන් ඵිරූශිනඃ සිදූකිනශ්ච මනුජාන් මංක්තුං ස්වසමීපම් ආගච්ඡ්තෝ විලෝක්‍ය ස තාන් අභිදධෞ, රේ රේ භුජගවංශා ආගාමීනඃ කෝපාත් පලායිතුං යුෂ්මාන් කශ්චේතිතවාන්? ");
INSERT INTO sansin_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","මනඃපරාවර්ත්තනස්‍ය සමුචිතං ඵලං ඵලත| ");
INSERT INTO sansin_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","කින්ත්වස්මාකං තාත ඉබ්‍රාහීම් අස්තීති ස්වේෂු මනඃසු චීන්තයන්තෝ මා ව්‍යාහරත| යතෝ යුෂ්මාන් අහං වදාමි, ඊශ්වර ඒතේභ්‍යඃ පාෂාණේභ්‍ය ඉබ්‍රාහීමඃ සන්තානාන් උත්පාදයිතුං ශක්නෝති| ");
INSERT INTO sansin_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","අපරං පාදපානාං මූලේ කුඨාර ඉදානීමපි ලගන් ආස්තේ, තස්මාද් යස්මින් පාදපේ උත්තමං ඵලං න භවති, ස කෘත්තෝ මධ්‍යේ(අ)ග්නිං නික්‍ෂේප්ස්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","අපරම් අහං මනඃපරාවර්ත්තනසූචකේන මජ්ජනේන යුෂ්මාන් මජ්ජයාමීති සත්‍යං, කින්තු මම පශ්චාද් ය ආගච්ඡති, ස මත්තෝපි මහාන්, අහං තදීයෝපානහෞ වෝඪුමපි නහි යෝග්‍යෝස්මි, ස යුෂ්මාන් වහ්නිරූපේ පවිත්‍ර ආත්මනි සංමජ්ජයිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","තස්‍ය කාරේ සූර්ප ආස්තේ, ස ස්වීයශස්‍යානි සම්‍යක් ප්‍රස්ඵෝට්‍ය නිජාන් සකලගෝධූමාන් සංගෘහ්‍ය භාණ්ඩාගාරේ ස්ථාපයිෂ්‍යති, කිංන්තු සර්ව්වාණි වුෂාණ්‍යනිර්ව්වාණවහ්නිනා දාහයිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","අනන්තරං යීශු ර‍්‍යෝහනා මජ්ජිතෝ භවිතුං ගාලීල්ප්‍රදේශාද් යර්ද්දනි තස්‍ය සමීපම් ආජගාම| ");
INSERT INTO sansin_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","කින්තු යෝහන් තං නිෂිධ්‍ය බභාෂේ, ත්වං කිං මම සමීපම් ආගච්ඡසි? වරං ත්වයා මජ්ජනං මම ප්‍රයෝජනම් ආස්තේ| ");
INSERT INTO sansin_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","තදානීං යීශුඃ ප්‍රත්‍යවෝචත්; ඊදානීම් අනුමන්‍යස්ව, යත ඉත්ථං සර්ව්වධර්ම්මසාධනම් අස්මාකං කර්ත්තව්‍යං, තතඃ සෝ(අ)න්වමන්‍යත| ");
INSERT INTO sansin_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","අනන්තරං යීශුරම්මසි මජ්ජිතුඃ සන් තත්ක්‍ෂණාත් තෝයමධ්‍යාද් උත්ථාය ජගාම, තදා ජීමූතද්වාරේ මුක්තේ ජාතේ, ස ඊශ්වරස්‍යාත්මානං කපෝතවද් අවරුහ්‍ය ස්වෝපර‍්‍ය්‍යාගච්ඡන්තං වීක්‍ෂාඤ්චක්‍රේ| ");
INSERT INTO sansin_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","අපරම් ඒෂ මම ප්‍රියඃ පුත්‍ර ඒතස්මින්නේව මම මහාසන්තෝෂ ඒතාදෘශී ව්‍යෝමජා වාග් බභූව| ");
INSERT INTO sansin_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","තතඃ පරං යීශුඃ ප්‍රතාරකේණ පරීක්‍ෂිතෝ භවිතුම් ආත්මනා ප්‍රාන්තරම් ආකෘෂ්ටඃ ");
INSERT INTO sansin_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","සන් චත්වාරිංශදහෝරාත්‍රාන් අනාහාරස්තිෂ්ඨන් ක්‍ෂුධිතෝ බභූව| ");
INSERT INTO sansin_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","තදානීං පරීක්‍ෂිතා තත්සමීපම් ආගත්‍ය ව්‍යාහෘතවාන්, යදි ත්වමීශ්වරාත්මජෝ භවේස්තර්හ්‍යාඥයා පාෂාණානේතාන් පූපාන් විධේහි| ");
INSERT INTO sansin_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","තතඃ ස ප්‍රත්‍යබ්‍රවීත්, ඉත්ථං ලිඛිතමාස්තේ, \"මනුජඃ කේවලපූපේන න ජීවිෂ්‍යති, කින්ත්වීශ්වරස්‍ය වදනාද් යානි යානි වචාංසි නිඃසරන්ති තෛරේව ජීවිෂ්‍යති| \" ");
INSERT INTO sansin_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","තදා ප්‍රතාරකස්තං පුණ්‍යනගරං නීත්වා මන්දිරස්‍ය චූඩෝපරි නිධාය ගදිතවාන්, ");
INSERT INTO sansin_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ත්වං යදිශ්වරස්‍ය තනයෝ භවේස්තර්හීතෝ(අ)ධඃ පත, යත ඉත්ථං ලිඛිතමාස්තේ, ආදේක්‍ෂ්‍යති නිජාන් දූතාන් රක්‍ෂිතුං ත්වාං පරමේශ්වරඃ| යථා සර්ව්වේෂු මාර්ගේෂු ත්වදීයචරණද්වයේ| න ලගේත් ප්‍රස්තරාඝාතස්ත්වාං ඝරිෂ්‍යන්ති තේ කරෛඃ|| ");
INSERT INTO sansin_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","තදානීං යීශුස්තස්මෛ කථිතවාන් ඒතදපි ලිඛිතමාස්තේ, \"ත්වං නිජප්‍රභුං පරමේශ්වරං මා පරීක්‍ෂස්ව| \" ");
INSERT INTO sansin_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","අනන්තරං ප්‍රතාරකඃ පුනරපි තම් අත්‍යුඤ්චධරාධරෝපරි නීත්වා ජගතඃ සකලරාජ්‍යානි තදෛශ්වර‍්‍ය්‍යාණි ච දර්ශයාශ්චකාර කථයාඤ්චකාර ච, ");
INSERT INTO sansin_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","යදි ත්වං දණ්ඩවද් භවන් මාං ප්‍රණමේස්තර්හ්‍යහම් ඒතානි තුභ්‍යං ප්‍රදාස්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","තදානීං යීශුස්තමවෝචත්, දූරීභව ප්‍රතාරක, ලිඛිතමිදම් ආස්තේ, \"ත්වයා නිජඃ ප්‍රභුඃ පරමේශ්වරඃ ප්‍රණම්‍යඃ කේවලඃ ස සේව්‍යශ්ච| \" ");
INSERT INTO sansin_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","තතඃ ප්‍රතාරකේණ ස පර‍්‍ය්‍යත්‍යාජි, තදා ස්වර්ගීයදූතෛරාගත්‍ය ස සිෂේවේ| ");
INSERT INTO sansin_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","තදනන්තරං යෝහන් කාරායාං බබන්ධේ, තද්වාර්ත්තාං නිශම්‍ය යීශුනා ගාලීල් ප්‍රාස්ථීයත| ");
INSERT INTO sansin_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","තතඃ පරං ස නාසරන්නගරං විහාය ජලඝේස්තටේ සිබූලූන්නප්තාලී ඒතයෝරුවභයෝඃ ප්‍රදේශයෝඃ සීම්නෝර්මධ්‍යවර්ත්තී ය: කඵර්නාහූම් තන්නගරම් ඉත්වා න්‍යවසත්| ");
INSERT INTO sansin_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","තස්මාත්, අන්‍යාදේශීයගාලීලි යර්ද්දන්පාරේ(අ)බ්ධිරෝධසි| නප්තාලිසිබූලූන්දේශෞ යත්‍ර ස්ථානේ ස්ථිතෞ පුරා| ");
INSERT INTO sansin_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","තත්‍රත්‍යා මනුජා යේ යේ පර‍්‍ය්‍යභ්‍රාම්‍යන් තමිස්‍රකේ| තෛර්ජනෛර්බෘහදාලෝකඃ පරිදර්ශිෂ්‍යතේ තදා| අවසන් යේ ජනා දේශේ මෘත්‍යුච්ඡායාස්වරූපකේ| තේෂාමුපරි ලෝකානාමාලෝකඃ සංප්‍රකාශිතඃ|| ");
INSERT INTO sansin_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","යදේතද්වචනං යිශයියභවිෂ්‍යද්වාදිනා ප්‍රෝක්තං, තත් තදා සඵලම් අභූත්| ");
INSERT INTO sansin_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","අනන්තරං යීශුඃ සුසංවාදං ප්‍රචාරයන් ඒතාං කථාං කථයිතුම් ආරේභේ, මනාංසි පරාවර්ත්තයත, ස්වර්ගීයරාජත්වං සවිධමභවත්| ");
INSERT INTO sansin_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","තතඃ පරං යීශු ර්ගාලීලෝ ජලධේස්තටේන ගච්ඡන් ගච්ඡන් ආන්ද්‍රියස්තස්‍ය භ්‍රාතා ශිමෝන් අර්ථතෝ යං පිතරං වදන්ති ඒතාවුභෞ ජලඝෞ ජාලං ක්‍ෂිපන්තෞ දදර්ශ, යතස්තෞ මීනධාරිණාවාස්තාම්| ");
INSERT INTO sansin_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","තදා ස තාවාහූය ව්‍යාජහාර, යුවාං මම පශ්චාද් ආගච්ඡතං, යුවාමහං මනුජධාරිණෞ කරිෂ්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","තේනෛව තෞ ජාලං විහාය තස්‍ය පශ්චාත් ආගච්ඡතාම්| ");
INSERT INTO sansin_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","අනන්තරං තස්මාත් ස්ථානාත් ව්‍රජන් ව්‍රජන් සිවදියස්‍ය සුතෞ යාකූබ් යෝහන්නාමානෞ ද්වෞ සහජෞ තාතේන සාර්ද්ධං නෞකෝපරි ජාලස්‍ය ජීර්ණෝද්ධාරං කුර්ව්වන්තෞ වීක්‍ෂ්‍ය තාවාහූතවාන්| ");
INSERT INTO sansin_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","තත්ක්‍ෂණාත් තෞ නාවං ස්වතාතඤ්ච විහාය තස්‍ය පශ්චාද්ගාමිනෞ බභූවතුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","අනන්තරං භජනභවනේ සමුපදිශන් රාජ්‍යස්‍ය සුසංවාදං ප්‍රචාරයන් මනුජානාං සර්ව්වප්‍රකාරාන් රෝගාන් සර්ව්වප්‍රකාරපීඩාශ්ච ශමයන් යීශුඃ කෘත්ස්නං ගාලීල්දේශං භ්‍රමිතුම් ආරභත| ");
INSERT INTO sansin_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","තේන කෘත්ස්නසුරියාදේශස්‍ය මධ්‍යං තස්‍ය යශෝ ව්‍යාප්නෝත්, අපරං භූතග්‍රස්තා අපස්මාරර්ගීණඃ පක්‍ෂාධාතිප්‍රභෘතයශ්ච යාවන්තෝ මනුජා නානාවිධව්‍යාධිභිඃ ක්ලිෂ්ටා ආසන්, තේෂු සර්ව්වේෂු තස්‍ය සමීපම් ආනීතේෂු ස තාන් ස්වස්ථාන් චකාර| ");
INSERT INTO sansin_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ඒතේන ගාලීල්-දිකාපනි-යිරූශාලම්-යිහූදීයදේශේභ්‍යෝ යර්ද්දනඃ පාරාඤ්ච බහවෝ මනුජාස්තස්‍ය පශ්චාද් ආගච්ඡන්| ");
INSERT INTO sansin_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","අනන්තරං ස ජනනිවහං නිරීක්‍ෂ්‍ය භූධරෝපරි ව්‍රජිත්වා සමුපවිවේශ| ");
INSERT INTO sansin_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","තදානීං ශිෂ්‍යේෂු තස්‍ය සමීපමාගතේෂු තේන තේභ්‍ය ඒෂා කථා කථ්‍යාඤ්චක්‍රේ| ");
INSERT INTO sansin_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","අභිමානහීනා ජනා ධන්‍යාඃ, යතස්තේ ස්වර්ගීයරාජ්‍යම් අධිකරිෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ඛිද්‍යමානා මනුජා ධන්‍යාඃ, යස්මාත් තේ සාන්ත්වනාං ප්‍රාප්සන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","නම්‍රා මානවාශ්ච ධන්‍යාඃ, යස්මාත් තේ මේදිනීම් අධිකරිෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ධර්ම්මාය බුභුක්‍ෂිතාඃ තෘෂාර්ත්තාශ්ච මනුජා ධන්‍යාඃ, යස්මාත් තේ පරිතර්ප්ස්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","කෘපාලවෝ මානවා ධන්‍යාඃ, යස්මාත් තේ කෘපාං ප්‍රාප්ස්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","නිර්ම්මලහෘදයා මනුජාශ්ච ධන්‍යාඃ, යස්මාත් ත ඊශ්චරං ද්‍රක්‍ෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","මේලයිතාරෝ මානවා ධන්‍යාඃ, යස්මාත් ත ඊශ්චරස්‍ය සන්තානත්වේන විඛ්‍යාස්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ධර්ම්මකාරණාත් තාඩිතා මනුජා ධන්‍යා, යස්මාත් ස්වර්ගීයරාජ්‍යේ තේෂාමධිකරෝ විද්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","යදා මනුජා මම නාමකෘතේ යුෂ්මාන් නින්දන්ති තාඩයන්ති මෘෂා නානාදුර්ව්වාක්‍යානි වදන්ති ච, තදා යුයං ධන්‍යාඃ| ");
INSERT INTO sansin_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","තදා ආනන්දත, තථා භෘශං හ්ලාදධ්වඤ්ච, යතඃ ස්වර්ගේ භූයාංසි ඵලානි ලප්ස්‍යධ්වේ; තේ යුෂ්මාකං පුරාතනාන් භවිෂ්‍යද්වාදිනෝ(අ)පි තාදෘග් අතාඩයන්| ");
INSERT INTO sansin_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","යුයං මේදින්‍යාං ලවණරූපාඃ, කින්තු යදි ලවණස්‍ය ලවණත්වම් අපයාති, තර්හි තත් කේන ප්‍රකාරේණ ස්වාදුයුක්තං භවිෂ්‍යති? තත් කස්‍යාපි කාර‍්‍ය්‍යස්‍යායෝග්‍යත්වාත් කේවලං බහිඃ ප්‍රක්‍ෂේප්තුං නරාණාං පදතලේන දලයිතුඤ්ච යෝග්‍යං භවති| ");
INSERT INTO sansin_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","යූයං ජගති දීප්තිරූපාඃ, භූධරෝපරි ස්ථිතං නගරං ගුප්තං භවිතුං නහි ශක්‍ෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","අපරං මනුජාඃ ප්‍රදීපාන් ප්‍රජ්වාල්‍ය ද්‍රෝණාධෝ න ස්ථාපයන්ති, කින්තු දීපාධාරෝපර‍්‍ය්‍යේව ස්ථාපයන්ති, තේන තේ දීපා ගේහස්ථිතාන් සකලාන් ප්‍රකාශයන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","යේන මානවා යුෂ්මාකං සත්කර්ම්මාණි විලෝක්‍ය යුෂ්මාකං ස්වර්ගස්ථං පිතරං ධන්‍යං වදන්ති, තේෂාං සමක්‍ෂං යුෂ්මාකං දීප්තිස්තාදෘක් ප්‍රකාශතාම්| ");
INSERT INTO sansin_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","අහං ව්‍යවස්ථාං භවිෂ්‍යද්වාක්‍යඤ්ච ලෝප්තුම් ආගතවාන්, ඉත්ථං මානුභවත, තේ ද්වේ ලෝප්තුං නාගතවාන්, කින්තු සඵලේ කර්ත්තුම් ආගතෝස්මි| ");
INSERT INTO sansin_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","අපරං යුෂ්මාන් අහං තථ්‍යං වදාමි යාවත් ව්‍යෝමමේදින්‍යෝ ර්ධ්වංසෝ න භවිෂ්‍යති, තාවත් සර්ව්වස්මින් සඵලේ න ජාතේ ව්‍යවස්ථායා ඒකා මාත්‍රා බින්දුරේකෝපි වා න ලෝප්ස්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","තස්මාත් යෝ ජන ඒතාසාම් ආඥානාම් අතික්‍ෂුද්‍රාම් ඒකාඥාමපී ලංඝතේ මනුජාංඤ්ච තථෛව ශික්‍ෂයති, ස ස්වර්ගීයරාජ්‍යේ සර්ව්වේභ්‍යඃ ක්‍ෂුද්‍රත්වේන විඛ්‍යාස්‍යතේ, කින්තු යෝ ජනස්තාං පාලයති, තථෛව ශික්‍ෂයති ච, ස ස්වර්ගීයරාජ්‍යේ ප්‍රධානත්වේන විඛ්‍යාස්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","අපරං යුෂ්මාන් අහං වදාමි, අධ්‍යාපකඵිරූශිමානවානාං ධර්ම්මානුෂ්ඨානාත් යුෂ්මාකං ධර්ම්මානුෂ්ඨානේ නෝත්තමේ ජාතේ යූයම් ඊශ්වරීයරාජ්‍යං ප්‍රවේෂ්ටුං න ශක්‍ෂ්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","අපරඤ්ච ත්වං නරං මා වධීඃ, යස්මාත් යෝ නරං හන්ති, ස විචාරසභායාං දණ්ඩාර්හෝ භවිෂ්‍යති, පූර්ව්වකාලීනජනේභ්‍ය ඉති කථිතමාසීත්, යුෂ්මාභිරශ්‍රාවි| ");
INSERT INTO sansin_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","කින්ත්වහං යුෂ්මාන් වදාමි, යඃ කශ්චිත් කාරණං විනා නිජභ්‍රාත්‍රේ කුප්‍යති, ස විචාරසභායාං දණ්ඩාර්හෝ භවිෂ්‍යති; යඃ කශ්චිච්ච ස්වීයසහජං නිර්බ්බෝධං වදති, ස මහාසභායාං දණ්ඩාර්හෝ භවිෂ්‍යති; පුනශ්ච ත්වං මූඪ ඉති වාක්‍යං යදි කශ්චිත් ස්වීයභ්‍රාතරං වක්ති, තර්හි නරකාග්නෞ ස දණ්ඩාර්හෝ භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","අතෝ වේද්‍යාඃ සමීපං නිජනෛවේද්‍යේ සමානීතේ(අ)පි නිජභ්‍රාතරං ප්‍රති කස්මාච්චිත් කාරණාත් ත්වං යදි දෝෂී විද්‍යසේ, තදානීං තව තස්‍ය ස්මෘති ර්ජායතේ ච, ");
INSERT INTO sansin_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","තර්හි තස්‍යා වේද්‍යාඃ සමීපේ නිජනෛවෛද්‍යං නිධාය තදෛව ගත්වා පූර්ව්වං තේන සාර්ද්ධං මිල, පශ්චාත් ආගත්‍ය නිජනෛවේද්‍යං නිවේදය| ");
INSERT INTO sansin_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","අන්‍යඤ්ච යාවත් විවාදිනා සාර්ද්ධං වර්ත්මනි තිෂ්ඨසි, තාවත් තේන සාර්ද්ධං මේලනං කුරු; නෝ චේත් විවාදී විචාරයිතුඃ සමීපේ ත්වාං සමර්පයති විචාරයිතා ච රක්‍ෂිණඃ සන්නිධෞ සමර්පයති තදා ත්වං කාරායාං බධ්‍යේථාඃ| ");
INSERT INTO sansin_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","තර්හි ත්වාමහං තථ්ථං බ්‍රවීමි, ශේෂකපර්දකේ(අ)පි න පරිශෝධිතේ තස්මාත් ස්ථානාත් කදාපි බහිරාගන්තුං න ශක්‍ෂ්‍යසි| ");
INSERT INTO sansin_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","අපරං ත්වං මා ව්‍යභිචර, යදේතද් වචනං පූර්ව්වකාලීනලෝකේභ්‍යඃ කථිතමාසීත්, තද් යූයං ශ්‍රුතවන්තඃ; ");
INSERT INTO sansin_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","කින්ත්වහං යුෂ්මාන් වදාමි, යදි කශ්චිත් කාමතඃ කාඤ්චන යෝෂිතං පශ්‍යති, තර්හි ස මනසා තදෛව ව්‍යභිචරිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","තස්මාත් තව දක්‍ෂිණං නේත්‍රං යදි ත්වාං බාධතේ, තර්හි තන්නේත්‍රම් උත්පාට්‍ය දූරේ නික්‍ෂිප, යස්මාත් තව සර්ව්වවපුෂෝ නරකේ නික්‍ෂේපාත් තවෛකාඞ්ගස්‍ය නාශෝ වරං| ");
INSERT INTO sansin_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","යද්වා තව දක්‍ෂිණඃ කරෝ යදි ත්වාං බාධතේ, තර්හි තං කරං ඡිත්ත්වා දූරේ නික්‍ෂිප, යතඃ සර්ව්වවපුෂෝ නරකේ නික්‍ෂේපාත් ඒකාඞ්ගස්‍ය නාශෝ වරං| ");
INSERT INTO sansin_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","උක්තමාස්තේ, යදි කශ්චින් නිජජායාං පරිත්‍යක්ත්තුම් ඉච්ඡති, තර්හි ස තස්‍යෛ ත්‍යාගපත්‍රං දදාතු| ");
INSERT INTO sansin_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","කින්ත්වහං යුෂ්මාන් ව්‍යාහරාමි, ව්‍යභිචාරදෝෂේ න ජාතේ යදි කශ්චින් නිජජායාං පරිත්‍යජති, තර්හි ස තාං ව්‍යභිචාරයති; යශ්ච තාං ත්‍යක්තාං ස්ත්‍රියං විවහති, සෝපි ව්‍යභිචරති| ");
INSERT INTO sansin_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","පුනශ්ච ත්වං මෘෂා ශපථම් න කුර්ව්වන් ඊශ්චරාය නිජශපථං පාලය, පූර්ව්වකාලීනලෝකේභ්‍යෝ යෛෂා කථා කථිතා, තාමපි යූයං ශ්‍රුතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","කින්ත්වහං යුෂ්මාන් වදාමි, කමපි ශපථං මා කාර්ෂ්ට, අර්ථතඃ ස්වර්ගනාම්නා න, යතඃ ස ඊශ්වරස්‍ය සිංහාසනං; ");
INSERT INTO sansin_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","පෘථිව්‍යා නාම්නාපි න, යතඃ සා තස්‍ය පාදපීඨං; යිරූශාලමෝ නාම්නාපි න, යතඃ සා මහාරාජස්‍ය පුරී; ");
INSERT INTO sansin_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","නිජශිරෝනාම්නාපි න, යස්මාත් තස්‍යෛකං කචමපි සිතම් අසිතං වා කර්ත්තුං ත්වයා න ශක්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","අපරං යූයං සංලාපසමයේ කේවලං භවතීති න භවතීති ච වදත යත ඉතෝ(අ)ධිකං යත් තත් පාපාත්මනෝ ජායතේ| ");
INSERT INTO sansin_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","අපරං ලෝචනස්‍ය විනිමයේන ලෝචනං දන්තස්‍ය විනිමයේන දන්තඃ පූර්ව්වක්තමිදං වචනඤ්ච යුෂ්මාභිරශ්‍රූයත| ");
INSERT INTO sansin_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","කින්ත්වහං යුෂ්මාන් වදාමි යූයං හිංසකං නරං මා ව්‍යාඝාතයත| කින්තු කේනචිත් තව දක්‍ෂිණකපෝලේ චපේටාඝාතේ කෘතේ තං ප්‍රති වාමං කපෝලඤ්ච ව්‍යාඝෝටය| ");
INSERT INTO sansin_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","අපරං කේනචිත් ත්වයා සාර්ධ්දං විවාදං කෘත්වා තව පරිධේයවසනේ ජිඝෘතිතේ තස්මායුත්තරීයවසනමපි දේහි| ");
INSERT INTO sansin_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","යදි කශ්චිත් ත්වාං ක්‍රෝශමේකං නයනාර්ථං අන්‍යායතෝ ධරති, තදා තේන සාර්ධ්දං ක්‍රෝශද්වයං යාහි| ");
INSERT INTO sansin_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","යශ්ච මානවස්ත්වාං යාචතේ, තස්මෛ දේහි, යදි කශ්චිත් තුභ්‍යං ධාරයිතුම් ඉච්ඡති, තර්හි තං ප්‍රති පරාංමුඛෝ මා භූඃ| ");
INSERT INTO sansin_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","නිජසමීපවසිනි ප්‍රේම කුරු, කින්තු ශත්‍රුං ප්‍රති ද්වේෂං කුරු, යදේතත් පුරෝක්තං වචනං ඒතදපි යූයං ශ්‍රුතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","කින්ත්වහං යුෂ්මාන් වදාමි, යූයං රිපුව්වපි ප්‍රේම කුරුත, යේ ච යුෂ්මාන් ශපන්තේ, තාන, ආශිෂං වදත, යේ ච යුෂ්මාන් ඍृතීයන්තේ, තේෂාං මඞ්ගලං කුරුත, යේ ච යුෂ්මාන් නින්දන්ති, තාඩයන්ති ච, තේෂාං කෘතේ ප්‍රාර්ථයධ්වං| ");
INSERT INTO sansin_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","තත්‍ර යඃ සතාමසතාඤ්චෝපරි ප්‍රභාකරම් උදායයති, තථා ධාර්ම්මිකානාමධාර්ම්මිකානාඤ්චෝපරි නීරං වර්ෂයති තාදෘශෝ යෝ යුෂ්මාකං ස්වර්ගස්ථඃ පිතා, යූයං තස්‍යෛව සන්තානා භවිෂ්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","යේ යුෂ්මාසු ප්‍රේම කුර්ව්වන්ති, යූයං යදි කේවලං තේව්වේව ප්‍රේම කුරුථ, තර්හි යුෂ්මාකං කිං ඵලං භවිෂ්‍යති? චණ්ඩාලා අපි තාදෘශං කිං න කුර්ව්වන්ති? ");
INSERT INTO sansin_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","අපරං යූයං යදි කේවලං ස්වීයභ්‍රාතෘත්වේන නමත, තර්හි කිං මහත් කර්ම්ම කුරුථ? චණ්ඩාලා අපි තාදෘශං කිං න කුර්ව්වන්ති? ");
INSERT INTO sansin_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","තස්මාත් යුෂ්මාකං ස්වර්ගස්ථඃ පිතා යථා පූර්ණෝ භවති, යූයමපි තාදෘශා භවත| ");
INSERT INTO sansin_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","සාවධානා භවත, මනුජාන් දර්ශයිතුං තේෂාං ගෝචරේ ධර්ම්මකර්ම්ම මා කුරුත, තථා කෘතේ යුෂ්මාකං ස්වර්ගස්ථපිතුඃ සකාශාත් කිඤ්චන ඵලං න ප්‍රාප්ස්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","ත්වං යදා දදාසි තදා කපටිනෝ ජනා යථා මනුජේභ්‍යඃ ප්‍රශංසාං ප්‍රාප්තුං භජනභවනේ රාජමාර්ගේ ච තූරීං වාදයන්ති, තථා මා කුරිु, අහං තුභ්‍යං යථාර්ථං කථයාමි, තේ ස්වකායං ඵලම් අලභන්ත| ");
INSERT INTO sansin_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","කින්තු ත්වං යදා දදාසි, තදා නිජදක්‍ෂිණකරෝ යත් කරෝති, තද් වාමකරං මා ඥාපය| ");
INSERT INTO sansin_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","තේන තව දානං ගුප්තං භවිෂ්‍යති යස්තු තව පිතා ගුප්තදර්ශී, ස ප්‍රකාශ්‍ය තුභ්‍යං ඵලං දාස්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","අපරං යදා ප්‍රාර්ථයසේ, තදා කපටිනඉව මා කුරු, යස්මාත් තේ භජනභවනේ රාජමාර්ගස්‍ය කෝණේ තිෂ්ඨන්තෝ ලෝකාන් දර්ශයන්තඃ ප්‍රාර්ථයිතුං ප්‍රීයන්තේ; අහං යුෂ්මාන් තථ්‍යං වදාමි, තේ ස්වකීයඵලං ප්‍රාප්නුවන්| ");
INSERT INTO sansin_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","තස්මාත් ප්‍රාර්ථනාකාලේ අන්තරාගාරං ප්‍රවිශ්‍ය ද්වාරං රුද්ව්වා ගුප්තං පශ්‍යතස්තව පිතුඃ සමීපේ ප්‍රාර්ථයස්ව; තේන තව යඃ පිතා ගුප්තදර්ශී, ස ප්‍රකාශ්‍ය තුභ්‍යං ඵලං දාස්‍යතිl ");
INSERT INTO sansin_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","අපරං ප්‍රාර්ථනාකාලේ දේවපූජකාඉව මුධා පුනරුක්තිං මා කුරු, යස්මාත් තේ බෝධන්තේ, බහුවාරං කථායාං කථිතායාං තේෂාං ප්‍රාර්ථනා ග්‍රාහිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","යූයං තේෂාමිව මා කුරුත, යස්මාත් යුෂ්මාකං යද් යත් ප්‍රයෝජනං යාචනාතඃ ප්‍රාගේව යුෂ්මාකං පිතා තත් ජානාති| ");
INSERT INTO sansin_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","අතඒව යූයම ඊදෘක් ප්‍රාර්ථයධ්වං, හේ අස්මාකං ස්වර්ගස්ථපිතඃ, තව නාම පූජ්‍යං භවතු| ");
INSERT INTO sansin_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","තව රාජත්වං භවතු; තවේච්ඡා ස්වර්ගේ යථා තථෛව මේදින්‍යාමපි සඵලා භවතු| ");
INSERT INTO sansin_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","අස්මාකං ප්‍රයෝජනීයම් ආහාරම් අද්‍ය දේහි| ");
INSERT INTO sansin_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","වයං යථා නිජාපරාධිනඃ ක්‍ෂමාමහේ, තථෛවාස්මාකම් අපරාධාන් ක්‍ෂමස්ව| ");
INSERT INTO sansin_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","අස්මාන් පරීක්‍ෂාං මානය, කින්තු පාපාත්මනෝ රක්‍ෂ; රාජත්වං ගෞරවං පරාක්‍රමඃ ඒතේ සර්ව්වේ සර්ව්වදා තව; තථාස්තු| ");
INSERT INTO sansin_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","යදි යූයම් අන්‍යේෂාම් අපරාධාන් ක්‍ෂමධ්වේ තර්හි යුෂ්මාකං ස්වර්ගස්ථපිතාපි යුෂ්මාන් ක්‍ෂමිෂ්‍යතේ; ");
INSERT INTO sansin_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","කින්තු යදි යූයම් අන්‍යේෂාම් අපරාධාන් න ක්‍ෂමධ්වේ, තර්හි යුෂ්මාකං ජනකෝපි යුෂ්මාකම් අපරාධාන් න ක්‍ෂමිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","අපරම් උපවාසකාලේ කපටිනෝ ජනා මානුෂාන් උපවාසං ඥාපයිතුං ස්වේෂාං වදනානි ම්ලානානි කුර්ව්වන්ති, යූයං තඉව විෂණවදනා මා භවත; අහං යුෂ්මාන් තථ්‍යං වදාමි තේ ස්වකීයඵලම් අලභන්ත| ");
INSERT INTO sansin_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","යදා ත්වම් උපවසසි, තදා යථා ලෝකෛස්ත්වං උපවාසීව න දෘශ්‍යසේ, කින්තු තව යෝ(අ)ගෝචරඃ පිතා තේනෛව දෘශ්‍යසේ, තත්කෘතේ නිජශිරසි තෛලං මර්ද්දය වදනඤ්ච ප්‍රක්‍ෂාලය; ");
INSERT INTO sansin_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","තේන තව යඃ පිතා ගුප්තදර්ශී ස ප්‍රකාශ්‍ය තුභ්‍යං ඵලං දාස්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","අපරං යත්‍ර ස්ථානේ කීටාඃ කලඞ්කාශ්ච ක්‍ෂයං නයන්ති, චෞරාශ්ච සන්ධිං කර්ත්තයිත්වා චෝරයිතුං ශක්නුවන්ති, තාදෘශ්‍යාං මේදින්‍යාං ස්වාර්ථං ධනං මා සංචිනුත| ");
INSERT INTO sansin_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","කින්තු යත්‍ර ස්ථානේ කීටාඃ කලඞ්කාශ්ච ක්‍ෂයං න නයන්ති, චෞරාශ්ච සන්ධිං කර්ත්තයිත්වා චෝරයිතුං න ශක්නුවන්ති, තාදෘශේ ස්වර්ගේ ධනං සඤ්චිනුත| ");
INSERT INTO sansin_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","යස්මාත් යත්‍ර ස්ථානේ යුෂ්මාංක ධනං තත්‍රෛව ඛානේ යුෂ්මාකං මනාංසි| ");
INSERT INTO sansin_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","ලෝචනං දේහස්‍ය ප්‍රදීපකං, තස්මාත් යදි තව ලෝචනං ප්‍රසන්නං භවති, තර්හි තව කෘත්ස්නං වපු ර්දීප්තියුක්තං භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","කින්තු ලෝචනේ(අ)ප්‍රසන්නේ තව කෘත්ස්නං වපුඃ තමිස්‍රයුක්තං භවිෂ්‍යති| අතඒව යා දීප්තිස්ත්වයි විද්‍යතේ, සා යදි තමිස්‍රයුක්තා භවති, තර්හි තත් තමිස්‍රං කියන් මහත්| ");
INSERT INTO sansin_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","කෝපි මනුජෝ ද්වෞ ප්‍රභූ සේවිතුං න ශක්නෝති, යස්මාද් ඒකං සංමන්‍ය තදන්‍යං න සම්මන්‍යතේ, යද්වා ඒකත්‍ර මනෝ නිධාය තදන්‍යම් අවමන්‍යතේ; තථා යූයමපීශ්වරං ලක්‍ෂ්මීඤ්චේත්‍යුභේ සේවිතුං න ශක්නුථ| ");
INSERT INTO sansin_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","අපරම් අහං යුෂ්මභ්‍යං තථ්‍යං කථයාමි, කිං භක්‍ෂිෂ්‍යාමඃ? කිං පාස්‍යාමඃ? ඉති ප්‍රාණධාරණාය මා චින්තයත; කිං පරිධාස්‍යාමඃ? ඉති කායරක්‍ෂණාය න චින්තයත; භක්‍ෂ්‍යාත් ප්‍රාණා වසනාඤ්ච වපූංෂි කිං ශ්‍රේෂ්ඨාණි න හි? ");
INSERT INTO sansin_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","විහායසෝ විහඞ්ගමාන් විලෝකයත; තෛ ර්නෝප්‍යතේ න කෘත්‍යතේ භාණ්ඩාගාරේ න සඤ්චීයතේ(අ)පි; තථාපි යුෂ්මාකං ස්වර්ගස්ථඃ පිතා තේභ්‍ය ආහාරං විතරති| ");
INSERT INTO sansin_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","යූයං තේභ්‍යඃ කිං ශ්‍රේෂ්ඨා න භවථ? යුෂ්මාකං කශ්චිත් මනුජඃ චින්තයන් නිජායුෂඃ ක්‍ෂණමපි වර්ද්ධයිතුං ශක්නෝති? ");
INSERT INTO sansin_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","අපරං වසනාය කුතශ්චින්තයත? ක්‍ෂේත්‍රෝත්පන්නානි පුෂ්පාණි කථං වර්ද්ධන්තේ තදාලෝචයත| තානි තන්තූන් නෝත්පාදයන්ති කිමපි කාර‍්‍ය්‍යං න කුර්ව්වන්ති; ");
INSERT INTO sansin_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","තථාප්‍යහං යුෂ්මාන් වදාමි, සුලේමාන් තාදෘග් ඓශ්වර‍්‍ය්‍යවානපි තත්පුෂ්පමිව විභූෂිතෝ නාසීත්| ");
INSERT INTO sansin_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","තස්මාත් ක්‍ෂද්‍ය විද්‍යමානං ශ්චඃ චුල්ල්‍යාං නික්‍ෂේප්ස්‍යතේ තාදෘශං යත් ක්‍ෂේත්‍රස්ථිතං කුසුමං තත් යදීශ්චර ඉත්ථං බිභූෂයති, තර්හි හේ ස්තෝකප්‍රත්‍යයිනෝ යුෂ්මාන් කිං න පරිධාපයිෂ්‍යති? ");
INSERT INTO sansin_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","තස්මාත් අස්මාභිඃ කිමත්ස්‍යතේ? කිඤ්ච පායිෂ්‍යතේ? කිං වා පරිධායිෂ්‍යතේ, ඉති න චින්තයත| ");
INSERT INTO sansin_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","යස්මාත් දේවාර්ච්චකා අපීති චේෂ්ටන්තේ; ඒතේෂු ද්‍රව්‍යේෂු ප්‍රයෝජනමස්තීති යුෂ්මාකං ස්වර්ගස්ථඃ පිතා ජානාති| ");
INSERT INTO sansin_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","අතඒව ප්‍රථමත ඊශ්වරීයරාජ්‍යං ධර්ම්මඤ්ච චේෂ්ටධ්වං, තත ඒතානි වස්තූනි යුෂ්මභ්‍යං ප්‍රදායිෂ්‍යන්තේ| ");
INSERT INTO sansin_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","ශ්වඃ කෘතේ මා චින්තයත, ශ්වඒව ස්වයං ස්වමුද්දිශ්‍ය චින්තයිෂ්‍යති; අද්‍යතනී යා චින්තා සාද්‍යකෘතේ ප්‍රචුරතරා| ");
INSERT INTO sansin_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","යථා යූයං දෝෂීකෘතා න භවථ, තත්කෘතේ(අ)න්‍යං දෝෂිණං මා කුරුත| ");
INSERT INTO sansin_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","යතෝ යාදෘශේන දෝෂේණ යූයං පරාන් දෝෂිණඃ කුරුථ, තාදෘශේන දෝෂේණ යූයමපි දෝෂීකෘතා භවිෂ්‍යථ, අන්‍යඤ්ච යේන පරිමාණේන යුෂ්මාභිඃ පරිමීයතේ, තේනෛව පරිමාණේන යුෂ්මත්කෘතේ පරිමායිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","අපරඤ්ච නිජනයනේ යා නාසා විද්‍යතේ, තාම් අනාලෝච්‍ය තව සහජස්‍ය ලෝචනේ යත් තෘණම් ආස්තේ, තදේව කුතෝ වීක්‍ෂසේ? ");
INSERT INTO sansin_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","තව නිජලෝචනේ නාසායාං විද්‍යමානායාං, හේ භ්‍රාතඃ, තව නයනාත් තෘණං බහිෂ්‍යර්තුං අනුජානීහි, කථාමේතාං නිජසහජාය කථං කථයිතුං ශක්නෝෂි? ");
INSERT INTO sansin_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","හේ කපටින්, ආදෞ නිජනයනාත් නාසාං බහිෂ්කුරු තතෝ නිජදෘෂ්ටෞ සුප්‍රසන්නායාං තව භ්‍රාතෘ ර්ලෝචනාත් තෘණං බහිෂ්කර්තුං ශක්‍ෂ්‍යසි| ");
INSERT INTO sansin_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","අන්‍යඤ්ච සාරමේයේභ්‍යඃ පවිත්‍රවස්තූනි මා විතරත, වරාහාණාං සමක්‍ෂඤ්ච මුක්තා මා නික්‍ෂිපත; නික්‍ෂේපණාත් තේ තාඃ සර්ව්වාඃ පදෛ ර්දලයිෂ්‍යන්ති, පරාවෘත්‍ය යුෂ්මානපි විදාරයිෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","යාචධ්වං තතෝ යුෂ්මභ්‍යං දායිෂ්‍යතේ; මෘගයධ්වං තත උද්දේශං ලප්ස්‍යධ්වේ; ද්වාරම් ආහත, තතෝ යුෂ්මත්කෘතේ මුක්තං භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","යස්මාද් යේන යාච්‍යතේ, තේන ලභ්‍යතේ; යේන මෘග්‍යතේ තේනෝද්දේශඃ ප්‍රාප්‍යතේ; යේන ච ද්වාරම් ආහන්‍යතේ, තත්කෘතේ ද්වාරං මෝච්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","ආත්මජේන පූපේ ප්‍රාර්ථිතේ තස්මෛ පාෂාණං විශ්‍රාණයති, ");
INSERT INTO sansin_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","මීනේ යාචිතේ ච තස්මෛ භුජගං විතරති, ඒතාදෘශඃ පිතා යුෂ්මාකං මධ්‍යේ ක ආස්තේ? ");
INSERT INTO sansin_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","තස්මාද් යූයම් අභද්‍රාඃ සන්තෝ(අ)පි යදි නිජබාලකේභ්‍ය උත්තමං ද්‍රව්‍යං දාතුං ජානීථ, තර්හි යුෂ්මාකං ස්වර්ගස්ථඃ පිතා ස්වීයයාචකේභ්‍යඃ කිමුත්තමානි වස්තූනි න දාස්‍යති? ");
INSERT INTO sansin_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","යූෂ්මාන් ප්‍රතීතරේෂාං යාදෘශෝ ව්‍යවහාරෝ යුෂ්මාකං ප්‍රියඃ, යූයං තාන් ප්‍රති තාදෘශානේව ව්‍යවහාරාන් විධත්ත; යස්මාද් ව්‍යවස්ථාභවිෂ්‍යද්වාදිනාං වචනානාම් ඉති සාරම්| ");
INSERT INTO sansin_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","සඞ්කීර්ණද්වාරේණ ප්‍රවිශත; යතෝ නරකගමනාය යද් ද්වාරං තද් විස්තීර්ණං යච්ච වර්ත්ම තද් බෘහත් තේන බහවඃ ප්‍රවිශන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","අපරං ස්වර්ගගමනාය යද් ද්වාරං තත් කීදෘක් සංකීර්ණං| යච්ච වර්ත්ම තත් කීදෘග් දුර්ගමම්| තදුද්දේෂ්ටාරඃ කියන්තෝ(අ)ල්පාඃ| ");
INSERT INTO sansin_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","අපරඤ්ච යේ ජනා මේෂවේශේන යුෂ්මාකං සමීපම් ආගච්ඡන්ති, කින්ත්වන්තර්දුරන්තා වෘකා ඒතාදෘශේභ්‍යෝ භවිෂ්‍යද්වාදිභ්‍යඃ සාවධානා භවත, යූයං ඵලේන තාන් පරිචේතුං ශක්නුථ| ");
INSERT INTO sansin_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","මනුජාඃ කිං කණ්ටකිනෝ වෘක්‍ෂාද් ද්‍රාක්‍ෂාඵලානි ශෘගාලකෝලිතශ්ච උඩුම්බරඵලානි ශාතයන්ති? ");
INSERT INTO sansin_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","තද්වද් උත්තම ඒව පාදප උත්තමඵලානි ජනයති, අධමපාදපඒවාධමඵලානි ජනයති| ");
INSERT INTO sansin_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","කින්තූත්තමපාදපඃ කදාප්‍යධමඵලානි ජනයිතුං න ශක්නෝති, තථාධමෝපි පාදප උත්තමඵලානි ජනයිතුං න ශක්නෝති| ");
INSERT INTO sansin_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","අපරං යේ යේ පාදපා අධමඵලානි ජනයන්ති, තේ කෘත්තා වහ්නෞ ක්‍ෂිප්‍යන්තේ| ");
INSERT INTO sansin_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","අතඒව යූයං ඵලේන තාන් පරිචේෂ්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","යේ ජනා මාං ප්‍රභුං වදන්ති, තේ සර්ව්වේ ස්වර්ගරාජ්‍යං ප්‍රවේක්‍ෂ්‍යන්ති තන්න, කින්තු යෝ මානවෝ මම ස්වර්ගස්ථස්‍ය පිතුරිෂ්ටං කර්ම්ම කරෝති ස ඒව ප්‍රවේක්‍ෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","තද් දිනේ බහවෝ මාං වදිෂ්‍යන්ති, හේ ප්‍රභෝ හේ ප්‍රභෝ, තව නාම්නා කිමස්මාමි ර්භවිෂ්‍යද්වාක්‍යං න ව්‍යාහෘතං? තව නාම්නා භූතාඃ කිං න ත්‍යාජිතාඃ? තව නාම්නා කිං නානාද්භුතානි කර්ම්මාණි න කෘතානි? ");
INSERT INTO sansin_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","තදාහං වදිෂ්‍යාමි, හේ කුකර්ම්මකාරිණෝ යුෂ්මාන් අහං න වේද්මි, යූයං මත්සමීපාද් දූරීභවත| ");
INSERT INTO sansin_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","යඃ කශ්චිත් මමෛතාඃ කථාඃ ශ්‍රුත්වා පාලයති, ස පාෂාණෝපරි ගෘහනිර්ම්මාත්‍රා ඥානිනා සහ මයෝපමීයතේ| ");
INSERT INTO sansin_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","යතෝ වෘෂ්ටෞ සත්‍යාම් ආප්ලාව ආගතේ වායෞ වාතේ ච තේෂු තද්ගේහං ලග්නේෂු පාෂාණෝපරි තස්‍ය භිත්තේස්තන්න පතතිl ");
INSERT INTO sansin_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","කින්තු යඃ කශ්චිත් මමෛතාඃ කථාඃ ශ්‍රුත්වා න පාලයති ස සෛකතේ ගේහනිර්ම්මාත්‍රා (අ)ඥානිනා උපමීයතේ| ");
INSERT INTO sansin_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","යතෝ ජලවෘෂ්ටෞ සත්‍යාම් ආප්ලාව ආගතේ පවනේ වාතේ ච තෛ ර්ගෘහේ සමාඝාතේ තත් පතති තත්පතනං මහද් භවති| ");
INSERT INTO sansin_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","යීශුනෛතේෂු වාක්‍යේෂු සමාපිතේෂු මානවාස්තදීයෝපදේශම් ආශ්චර‍්‍ය්‍යං මේනිරේ| ");
INSERT INTO sansin_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","යස්මාත් ස උපාධ්‍යායා ඉව තාන් නෝපදිදේශ කින්තු සමර්ථපුරුෂඉව සමුපදිදේශ| ");
INSERT INTO sansin_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","යදා ස පර්ව්වතාද් අවාරෝහත් තදා බහවෝ මානවාස්තත්පශ්චාද් වව්‍රජුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ඒකඃ කුෂ්ඨවාන් ආගත්‍ය තං ප්‍රණම්‍ය බභාෂේ, හේ ප්‍රභෝ, යදි භවාන් සංමන්‍යතේ, තර්හි මාං නිරාමයං කර්ත්තුං ශක්නෝති| ");
INSERT INTO sansin_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","තතෝ යීශුඃ කරං ප්‍රසාර‍්‍ය්‍ය තස්‍යාඞ්ගං ස්පෘශන් ව්‍යාජහාර, සම්මන්‍යේ(අ)හං ත්වං නිරාමයෝ භව; තේන ස තත්ක්‍ෂණාත් කුෂ්ඨේනාමෝචි| ");
INSERT INTO sansin_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","තතෝ යීශුස්තං ජගාද, අවධේහි කථාමේතාං කශ්චිදපි මා බ්‍රූහි, කින්තු යාජකස්‍ය සන්නිධිං ගත්වා ස්වාත්මානං දර්ශය මනුජේභ්‍යෝ නිජනිරාමයත්වං ප්‍රමාණයිතුං මූසානිරූපිතං ද්‍රව්‍යම් උත්සෘජ ච| ");
INSERT INTO sansin_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","තදනන්තරං යීශුනා කඵර්නාහූම්නාමනි නගරේ ප්‍රවිෂ්ටේ කශ්චිත් ශතසේනාපතිස්තත්සමීපම් ආගත්‍ය විනීය බභාෂේ, ");
INSERT INTO sansin_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","හේ ප්‍රභෝ, මදීය ඒකෝ දාසඃ පක්‍ෂාඝාතව්‍යාධිනා භෘශං ව්‍යථිතඃ, සතු ශයනීය ආස්තේ| ");
INSERT INTO sansin_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","තදානීං යීශුස්තස්මෛ කථිතවාන්, අහං ගත්වා තං නිරාමයං කරිෂ්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","තතඃ ස ශතසේනාපතිඃ ප්‍රත්‍යවදත්, හේ ප්‍රභෝ, භවාන් යත් මම ගේහමධ්‍යං යාති තද්‍යෝග්‍යභාජනං නාහමස්මි; වාඞ්මාත්‍රම් ආදිශතු, තේනෛව මම දාසෝ නිරාමයෝ භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","යතෝ මයි පරනිධ්නේ(අ)පි මම නිදේශවශ්‍යාඃ කති කති සේනාඃ සන්ති, තත ඒකස්මින් යාහීත්‍යුක්තේ ස යාති, තදන්‍යස්මින් ඒහීත්‍යුක්තේ ස ආයාති, තථා මම නිජදාසේ කර්ම්මෛතත් කුර්ව්විත්‍යුක්තේ ස තත් කරෝති| ");
INSERT INTO sansin_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","තදානීං යීශුස්තස්‍යෛතත් වචෝ නිශම්‍ය විස්මයාපන්නෝ(අ)භූත්; නිජපශ්චාද්ගාමිනෝ මානවාන් අවෝච්ච, යුෂ්මාන් තථ්‍යං වච්මි, ඉස්‍රායේලීයලෝකානාං මධ්‍යේ(අ)පි නෛතාදෘශෝ විශ්වාසෝ මයා ප්‍රාප්තඃ| ");
INSERT INTO sansin_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","අන්‍යච්චාහං යුෂ්මාන් වදාමි, බහවඃ පූර්ව්වස්‍යාඃ පශ්චිමායාශ්ච දිශ ආගත්‍ය ඉබ්‍රාහීමා ඉස්හාකා යාකූබා ච සාකම් මිලිත්වා සමුපවේක්‍ෂ්‍යන්ති; ");
INSERT INTO sansin_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","කින්තු යත්‍ර ස්ථානේ රෝදනදන්තඝර්ෂණේ භවතස්තස්මින් බහිර්භූතතමිස්‍රේ රාජ්‍යස්‍ය සන්තානා නික්‍ෂේස්‍යන්තේ| ");
INSERT INTO sansin_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","තතඃ පරං යීශුස්තං ශතසේනාපතිං ජගාද, යාහි, තව ප්‍රතීත්‍යනුසාරතෝ මඞ්ගලං භූයාත්; තදා තස්මින්නේව දණ්ඩේ තදීයදාසෝ නිරාමයෝ බභූව| ");
INSERT INTO sansin_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","අනන්තරං යීශුඃ පිතරස්‍ය ගේහමුපස්ථාය ජ්වරේණ පීඩිතාං ශයනීයස්ථිතාං තස්‍ය ශ්වශ්‍රූං වීක්‍ෂාඤ්චක්‍රේ| ");
INSERT INTO sansin_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","තතස්තේන තස්‍යාඃ කරස්‍ය ස්පෘෂ්ටතවාත් ජ්වරස්තාං තත්‍යාජ, තදා සා සමුත්ථාය තාන් සිෂේවේ| ");
INSERT INTO sansin_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","අනන්තරං සන්ධ්‍යායාං සත්‍යාං බහුශෝ භූතග්‍රස්තමනුජාන් තස්‍ය සමීපම් ආනින්‍යුඃ ස ච වාක්‍යේන භූතාන් ත්‍යාජයාමාස, සර්ව්වප්‍රකාරපීඩිතජනාංශ්ච නිරාමයාන් චකාර; ");
INSERT INTO sansin_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","තස්මාත්, සර්ව්වා දුර්බ්බලතාස්මාකං තේනෛව පරිධාරිතා| අස්මාකං සකලං ව්‍යාධිං සඒව සංගෘහීතවාන්| යදේතද්වචනං යිශයියභවිෂ්‍යද්වාදිනෝක්තමාසීත්, තත්තදා සඵලමභවත්| ");
INSERT INTO sansin_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","අනන්තරං යීශුශ්චතුර්දික්‍ෂු ජනනිවහං විලෝක්‍ය තටින්‍යාඃ පාරං යාතුං ශිෂ්‍යාන් ආදිදේශ| ");
INSERT INTO sansin_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","තදානීම් ඒක උපාධ්‍යාය ආගත්‍ය කථිතවාන්, හේ ගුරෝ, භවාන් යත්‍ර යාස්‍යති තත්‍රාහමපි භවතඃ පශ්චාද් යාස්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","තතෝ යීශු ර්ජගාද, ක්‍රෝෂ්ටුඃ ස්ථාතුං ස්ථානං විද්‍යතේ, විහායසෝ විහඞ්ගමානාං නීඩානි ච සන්ති; කින්තු මනුෂ්‍යපුත්‍රස්‍ය ශිරඃ ස්ථාපයිතුං ස්ථානං න විද්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","අනන්තරම් අපර ඒකඃ ශිෂ්‍යස්තං බභාෂේ, හේ ප්‍රභෝ, ප්‍රථමතෝ මම පිතරං ශ්මශානේ නිධාතුං ගමනාර්ථං මාම් අනුමන්‍යස්ව| ");
INSERT INTO sansin_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","තතෝ යීශුරුක්තවාන් මෘතා මෘතාන් ශ්මශානේ නිදධතු, ත්වං මම පශ්චාද් ආගච්ඡ| ");
INSERT INTO sansin_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","අනන්තරං තස්මින් නාවමාරූඪේ තස්‍ය ශිෂ්‍යාස්තත්පශ්චාත් ජග්මුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","පශ්චාත් සාගරස්‍ය මධ්‍යං තේෂු ගතේෂු තාදෘශඃ ප්‍රබලෝ ඣඤ්භ්ශනිල උදතිෂ්ඨත්, යේන මහාතරඞ්ග උත්ථාය තරණිං ඡාදිතවාන්, කින්තු ස නිද්‍රිත ආසීත්| ");
INSERT INTO sansin_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","තදා ශිෂ්‍යා ආගත්‍ය තස්‍ය නිද්‍රාභඞ්ගං කෘත්වා කථයාමාසුඃ, හේ ප්‍රභෝ, වයං ම්‍රියාමහේ, භවාන් අස්මාකං ප්‍රාණාන් රක්‍ෂතු| ");
INSERT INTO sansin_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","තදා ස තාන් උක්තවාන්, හේ අල්පවිශ්වාසිනෝ යූයං කුතෝ විභීථ? තතඃ ස උත්ථාය වාතං සාගරඤ්ච තර්ජයාමාස, තතෝ නිර්ව්වාතමභවත්| ");
INSERT INTO sansin_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","අපරං මනුජා විස්මයං විලෝක්‍ය කථයාමාසුඃ, අහෝ වාතසරිත්පතී අස්‍ය කිමාඥාග්‍රාහිණෞ? කීදෘශෝ(අ)යං මානවඃ| ");
INSERT INTO sansin_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","අනන්තරං ස පාරං ගත්වා ගිදේරීයදේශම් උපස්ථිතවාන්; තදා ද්වෞ භූතග්‍රස්තමනුජෞ ශ්මශානස්ථානාද් බහි ර්භූත්වා තං සාක්‍ෂාත් කෘතවන්තෞ, තාවේතාදෘශෞ ප්‍රචණ්ඩාවාස්තාං යත් තේන ස්ථානේන කෝපි යාතුං නාශක්නෝත්| ");
INSERT INTO sansin_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","තාවුචෛඃ කථයාමාසතුඃ, හේ ඊශ්වරස්‍ය සූනෝ යීශෝ, ත්වයා සාකම් ආවයෝඃ කඃ සම්බන්ධඃ? නිරූපිතකාලාත් ප්‍රාගේව කිමාවාභ්‍යාං යාතනාං දාතුම් අත්‍රාගතෝසි? ");
INSERT INTO sansin_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","තදානීං තාභ්‍යාං කිඤ්චිද් දූරේ වරාහාණාම් ඒකෝ මහාව්‍රජෝ(අ)චරත්| ");
INSERT INTO sansin_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","තතෝ භූතෞ තෞ තස්‍යාන්තිකේ විනීය කථයාමාසතුඃ, යද්‍යාවාං ත්‍යාජයසි, තර්හි වරාහාණාං මධ්‍යේව්‍රජම් ආවාං ප්‍රේරය| ");
INSERT INTO sansin_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","තදා යීශුරවදත් යාතං, අනන්තරං තෞ යදා මනුජෞ විහාය වරාහාන් ආශ්‍රිතවන්තෞ, තදා තේ සර්ව්වේ වරාහා උච්චස්ථානාත් මහාජවේන ධාවන්තඃ සාගරීයතෝයේ මජ්ජන්තෝ මම්‍රුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","තතෝ වරාහරක්‍ෂකාඃ පලායමානා මධ්‍යේනගරං තෞ භූතග්‍රස්තෞ ප්‍රති යද්‍යද් අඝටත, තාඃ සර්ව්වවාර්ත්තා අවදන්| ");
INSERT INTO sansin_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","තතෝ නාගරිකාඃ සර්ව්වේ මනුජා යීශුං සාක්‍ෂාත් කර්ත්තුං බහිරායාතාඃ තඤ්ච විලෝක්‍ය ප්‍රාර්ථයාඤ්චක්‍රිරේ භවාන් අස්මාකං සීමාතෝ යාතු| ");
INSERT INTO sansin_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","අනන්තරං යීශු ර්නෞකාමාරුහ්‍ය පුනඃ පාරමාගත්‍ය නිජග්‍රාමම් ආයයෞ| ");
INSERT INTO sansin_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","තතඃ කතිපයා ජනා ඒකං පක්‍ෂාඝාතිනං ස්වට්ටෝපරි ශායයිත්වා තත්සමීපම් ආනයන්; තතෝ යීශුස්තේෂාං ප්‍රතීතිං විඥාය තං පක්‍ෂාඝාතිනං ජගාද, හේ පුත්‍ර, සුස්ථිරෝ භව, තව කලුෂස්‍ය මර්ෂණං ජාතම්| ");
INSERT INTO sansin_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","තාං කථාං නිශම්‍ය කියන්ත උපාධ්‍යායා මනඃසු චින්තිතවන්ත ඒෂ මනුජ ඊශ්වරං නින්දති| ");
INSERT INTO sansin_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","තතඃ ස තේෂාම් ඒතාදෘශීං චින්තාං විඥාය කථිතවාන්, යූයං මනඃසු කෘත ඒතාදෘශීං කුචින්තාං කුරුථ? ");
INSERT INTO sansin_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","තව පාපමර්ෂණං ජාතං, යද්වා ත්වමුත්ථාය ගච්ඡ, ද්වයෝරනයෝ ර්වාක්‍යයෝඃ කිං වාක්‍යං වක්තුං සුගමං? ");
INSERT INTO sansin_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","කින්තු මේදින්‍යාං කලුෂං ක්‍ෂමිතුං මනුජසුතස්‍ය සාමර්ථ්‍යමස්තීති යූයං යථා ජානීථ, තදර්ථං ස තං පක්‍ෂාඝාතිනං ගදිතවාන්, උත්තිෂ්ඨ, නිජශයනීයං ආදාය ගේහං ගච්ඡ| ");
INSERT INTO sansin_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","තතඃ ස තත්ක්‍ෂණාද් උත්ථාය නිජගේහං ප්‍රස්ථිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","මානවා ඉත්ථං විලෝක්‍ය විස්මයං මේනිරේ, ඊශ්වරේණ මානවාය සාමර්ථ්‍යම් ඊදෘශං දත්තං ඉති කාරණාත් තං ධන්‍යං බභාෂිරේ ච| ");
INSERT INTO sansin_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","අනන්තරං යීශුස්තත්ස්ථානාද් ගච්ඡන් ගච්ඡන් කරසංග්‍රහස්ථානේ සමුපවිෂ්ටං මථිනාමානම් ඒකං මනුජං විලෝක්‍ය තං බභාෂේ, මම පශ්චාද් ආගච්ඡ, තතඃ ස උත්ථාය තස්‍ය පශ්චාද් වව්‍රාජ| ");
INSERT INTO sansin_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","තතඃ පරං යීශෞ ගෘහේ භෝක්තුම් උපවිෂ්ටේ බහවඃ කරසංග්‍රාහිණඃ කලුෂිණශ්ච මානවා ආගත්‍ය තේන සාකං තස්‍ය ශිෂ්‍යෛශ්ච සාකම් උපවිවිශුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ඵිරූශිනස්තද් දෘෂ්ට්වා තස්‍ය ශිෂ්‍යාන් බභාෂිරේ, යුෂ්මාකං ගුරුඃ කිං නිමිත්තං කරසංග්‍රාහිභිඃ කලුෂිභිශ්ච සාකං භුංක්තේ? ");
INSERT INTO sansin_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","යීශුස්තත් ශ්‍රුත්වා තාන් ප්‍රත්‍යවදත්, නිරාමයලෝකානාං චිකිත්සකේන ප්‍රයෝජනං නාස්ති, කින්තු සාමයලෝකානාං ප්‍රයෝජනමාස්තේ| ");
INSERT INTO sansin_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","අතෝ යූයං යාත්වා වචනස්‍යාස්‍යාර්ථං ශික්‍ෂධ්වම්, දයායාං මේ යථා ප්‍රීති ර්න තථා යඥකර්ම්මණි| යතෝ(අ)හං ධාර්ම්මිකාන් ආහ්වාතුං නාගතෝ(අ)ස්මි කින්තු මනඃ පරිවර්ත්තයිතුං පාපින ආහ්වාතුම් ආගතෝ(අ)ස්මි| ");
INSERT INTO sansin_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","අනන්තරං යෝහනඃ ශිෂ්‍යාස්තස්‍ය සමීපම් ආගත්‍ය කථයාමාසුඃ, ඵිරූශිනෝ වයඤ්ච පුනඃ පුනරුපවසාමඃ, කින්තු තව ශිෂ්‍යා නෝපවසන්ති, කුතඃ? ");
INSERT INTO sansin_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","තදා යීශුස්තාන් අවෝචත් යාවත් සඛීනාං සංඞ්ගේ කන්‍යායා වරස්තිෂ්ඨති, තාවත් කිං තේ විලාපං කර්ත්තුං ශක්ලුවන්ති? කින්තු යදා තේෂාං සංඞ්ගාද් වරං නයන්ති, තාදෘශඃ සමය ආගමිෂ්‍යති, තදා තේ උපවත්ස්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","පුරාතනවසනේ කෝපි නවීනවස්ත්‍රං න යෝජයති, යස්මාත් තේන යෝජිතේන පුරාතනවසනං ඡිනත්ති තච්ඡිද්‍රඤ්ච බහුකුත්සිතං දෘශ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","අන්‍යඤ්ච පුරාතනකුත්වාං කෝපි නවානගෝස්තනීරසං න නිදධාති, යස්මාත් තථා කෘතේ කුතූ ර්විදීර‍්‍ය්‍යතේ තේන ගෝස්තනීරසඃ පතති කුතූශ්ච නශ්‍යති; තස්මාත් නවීනායාං කුත්වාං නවීනෝ ගෝස්තනීරසඃ ස්ථාප්‍යතේ, තේන ද්වයෝරවනං භවති| ");
INSERT INTO sansin_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","අපරං තේනෛතත්කථාකථනකාලේ ඒකෝ(අ)ධිපතිස්තං ප්‍රණම්‍ය බභාෂේ, මම දුහිතා ප්‍රායේණෛතාවත්කාලේ මෘතා, තස්මාද් භවානාගත්‍ය තස්‍යා ගාත්‍රේ හස්තමර්පයතු, තේන සා ජීවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","තදානීං යීශුඃ ශිෂ්‍යෛඃ සාකම් උත්ථාය තස්‍ය පශ්චාද් වව්‍රාජ| ");
INSERT INTO sansin_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ඉත්‍යනන්තරේ ද්වාදශවත්සරාන් යාවත් ප්‍රදරාමයේන ශීර්ණෛකා නාරී තස්‍ය පශ්චාද් ආගත්‍ය තස්‍ය වසනස්‍ය ග්‍රන්ථිං පස්පර්ශ; ");
INSERT INTO sansin_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","යස්මාත් මයා කේවලං තස්‍ය වසනං ස්පෘෂ්ට්වා ස්වාස්ථ්‍යං ප්‍රාප්ස්‍යතේ, සා නාරීති මනසි නිශ්චිතවතී| ");
INSERT INTO sansin_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","තතෝ යීශුර්වදනං පරාවර්ත්ත්‍ය තාං ජගාද, හේ කන්‍යේ, ත්වං සුස්ථිරා භව, තව විශ්වාසස්ත්වාං ස්වස්ථාමකාර්ෂීත්| ඒතද්වාක්‍යේ ගදිතඒව සා යෝෂිත් ස්වස්ථාභූත්| ");
INSERT INTO sansin_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","අපරං යීශුස්තස්‍යාධ්‍යක්‍ෂස්‍ය ගේහං ගත්වා වාදකප්‍රභෘතීන් බහූන් ලෝකාන් ශබ්දායමානාන් විලෝක්‍ය තාන් අවදත්, ");
INSERT INTO sansin_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","පන්ථානං ත්‍යජ, කන්‍යේයං නාම්‍රියත නිද්‍රිතාස්තේ; කථාමේතාං ශ්‍රුත්වා තේ තමුපජහසුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","කින්තු සර්ව්වේෂු බහිෂ්කෘතේෂු සෝ(අ)භ්‍යන්තරං ගත්වා කන්‍යායාඃ කරං ධෘතවාන්, තේන සෝදතිෂ්ඨත්; ");
INSERT INTO sansin_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","තතස්තත්කර්ම්මණෝ යශඃ කෘත්ස්නං තං දේශං ව්‍යාප්තවත්| ");
INSERT INTO sansin_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","තතඃ පරං යීශුස්තස්මාත් ස්ථානාද් යාත්‍රාං චකාර; තදා හේ දායූදඃ සන්තාන, අස්මාන් දයස්ව, ඉති වදන්තෞ ද්වෞ ජනාවන්ධෞ ප්‍රෝචෛරාහූයන්තෞ තත්පශ්චාද් වව්‍රජතුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","තතෝ යීශෞ ගේහමධ්‍යං ප්‍රවිෂ්ටං තාවපි තස්‍ය සමීපම් උපස්ථිතවන්තෞ, තදානීං ස තෞ පෘෂ්ටවාන් කර්ම්මෛතත් කර්ත්තුං මම සාමර්ථ්‍යම් ආස්තේ, යුවාං කිමිති ප්‍රතීථඃ? තදා තෞ ප්‍රත්‍යූචතුඃ, සත්‍යං ප්‍රභෝ| ");
INSERT INTO sansin_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","තදානීං ස තයෝ ර්ලෝචනානි ස්පෘශන් බභාෂේ, යුවයෝඃ ප්‍රතීත්‍යනුසාරාද් යුවයෝ ර්මඞ්ගලං භූයාත්| තේන තත්ක්‍ෂණාත් තයෝ ර්නේත්‍රාණි ප්‍රසන්නාන්‍යභවන්, ");
INSERT INTO sansin_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","පශ්චාද් යීශුස්තෞ දෘඪමාඥාප්‍ය ජගාද, අවධත්තම් ඒතාං කථාං කෝපි මනුජෝ ම ජානීයාත්| ");
INSERT INTO sansin_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","කින්තු තෞ ප්‍රස්ථාය තස්මින් කෘත්ස්නේ දේශේ තස්‍ය කීර්ත්තිං ප්‍රකාශයාමාසතුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","අපරං තෞ බහිර‍්‍යාත ඒතස්මින්නන්තරේ මනුජා ඒකං භූතග්‍රස්තමූකං තස්‍ය සමීපම් ආනීතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","තේන භූතේ ත්‍යාජිතේ ස මූකඃ කථාං කථයිතුං ප්‍රාරභත, තේන ජනා විස්මයං විඥාය කථයාමාසුඃ, ඉස්‍රායේලෝ වංශේ කදාපි නේදෘගදෘශ්‍යත; ");
INSERT INTO sansin_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","කින්තු ඵිරූශිනඃ කථයාඤ්චක්‍රුඃ භූතාධිපතිනා ස භූතාන් ත්‍යාජයති| ");
INSERT INTO sansin_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","තතඃ පරං යීශුස්තේෂාං භජනභවන උපදිශන් රාජ්‍යස්‍ය සුසංවාදං ප්‍රචාරයන් ලෝකානාං යස්‍ය ය ආමයෝ යා ච පීඩාසීත්, තාන් ශමයන් ශමයංශ්ච සර්ව්වාණි නගරාණි ග්‍රාමාංශ්ච බභ්‍රාම| ");
INSERT INTO sansin_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","අන්‍යඤ්ච මනුජාන් ව්‍යාකුලාන් අරක්‍ෂකමේෂානිව ච ත්‍යක්තාන් නිරීක්‍ෂ්‍ය තේෂු කාරුණිකඃ සන් ශිෂ්‍යාන් අවදත්, ");
INSERT INTO sansin_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ශස්‍යානි ප්‍රචුරාණි සන්ති, කින්තු ඡේත්තාරඃ ස්තෝකාඃ| ");
INSERT INTO sansin_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ක්‍ෂේත්‍රං ප්‍රත්‍යපරාන් ඡේදකාන් ප්‍රහේතුං ශස්‍යස්වාමිනං ප්‍රාර්ථයධ්වම්| ");
INSERT INTO sansin_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","අනන්තරං යීශු ර්ද්වාදශශිෂ්‍යාන් ආහූයාමේධ්‍යභූතාන් ත්‍යාජයිතුං සර්ව්වප්‍රකාරරෝගාන් පීඩාශ්ච ශමයිතුං තේභ්‍යඃ සාමර්ථ්‍යමදාත්| ");
INSERT INTO sansin_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","තේෂාං ද්වාදශප්‍රේෂ්‍යාණාං නාමාන්‍යේතානි| ප්‍රථමං ශිමෝන් යං පිතරං වදන්ති, තතඃ පරං තස්‍ය සහජ ආන්ද්‍රියඃ, සිවදියස්‍ය පුත්‍රෝ යාකූබ් ");
INSERT INTO sansin_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","තස්‍ය සහජෝ යෝහන්; ඵිලිප් බර්ථලමය් ථෝමාඃ කරසංග්‍රාහී මථිඃ, ආල්ඵේයපුත්‍රෝ යාකූබ්, ");
INSERT INTO sansin_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","කිනානීයඃ ශිමෝන්, ය ඊෂ්කරියෝතීයයිහූදාඃ ඛ්‍රීෂ්ටං පරකරේ(අ)ර්පයත්| ");
INSERT INTO sansin_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ඒතාන් ද්වාදශශිෂ්‍යාන් යීශුඃ ප්‍රේෂයන් ඉත්‍යාඥාපයත්, යූයම් අන්‍යදේශීයානාං පදවීං ශේමිරෝණීයානාං කිමපි නගරඤ්ච න ප්‍රවිශ්‍යේ ");
INSERT INTO sansin_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ඉස්‍රායේල්ගෝත්‍රස්‍ය හාරිතා යේ යේ මේෂාස්තේෂාමේව සමීපං යාත| ");
INSERT INTO sansin_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","ගත්වා ගත්වා ස්වර්ගස්‍ය රාජත්වං සවිධමභවත්, ඒතාං කථාං ප්‍රචාරයත| ");
INSERT INTO sansin_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ආමයග්‍රස්තාන් ස්වස්ථාන් කුරුත, කුෂ්ඨිනඃ පරිෂ්කුරුත, මෘතලෝකාන් ජීවයත, භූතාන් ත්‍යාජයත, විනා මූල්‍යං යූයම් අලභධ්වං විනෛව මූල්‍යං විශ්‍රාණයත| ");
INSERT INTO sansin_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","කින්තු ස්වේෂාං කටිබන්ධේෂු ස්වර්ණරූප්‍යතාම්‍රාණාං කිමපි න ගෘහ්ලීත| ");
INSERT INTO sansin_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","අන්‍යච්ච යාත්‍රායෛ චේලසම්පුටං වා ද්විතීයවසනං වා පාදුකේ වා යෂ්ටිඃ, ඒතාන් මා ගෘහ්ලීත, යතඃ කාර‍්‍ය්‍යකෘත් භර්ත්තුං යෝග්‍යෝ භවති| ");
INSERT INTO sansin_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","අපරං යූයං යත් පුරං යඤ්ච ග්‍රාමං ප්‍රවිශථ, තත්‍ර යෝ ජනෝ යෝග්‍යපාත්‍රං තමවගත්‍ය යානකාලං යාවත් තත්‍ර තිෂ්ඨත| ");
INSERT INTO sansin_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","යදා යූයං තද්ගේහං ප්‍රවිශථ, තදා තමාශිෂං වදත| ");
INSERT INTO sansin_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","යදි ස යෝග්‍යපාත්‍රං භවති, තර්හි තත්කල්‍යාණං තස්මෛ භවිෂ්‍යති, නෝචේත් සාශීර‍්‍යුෂ්මභ්‍යමේව භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","කින්තු යේ ජනා යුෂ්මාකමාතිථ්‍යං න විදධති යුෂ්මාකං කථාඤ්ච න ශෘණ්වන්ති තේෂාං ගේහාත් පුරාද්වා ප්‍රස්ථානකාලේ ස්වපදූලීඃ පාතයත| ");
INSERT INTO sansin_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","යුෂ්මානහං තථ්‍යං වච්මි විචාරදිනේ තත්පුරස්‍ය දශාතඃ සිදෝමමෝරාපුරයෝර්දශා සහ්‍යතරා භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","පශ්‍යත, වෘකයූථමධ්‍යේ මේෂඃ යථාවිස්තථා යුෂ්මාන ප්‍රහිණෝමි, තස්මාද් යූයම් අහිරිව සතර්කාඃ කපෝතාඉවාහිංසකා භවත| ");
INSERT INTO sansin_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","නෘභ්‍යඃ සාවධානා භවත; යතස්තෛ ර‍්‍යූයං රාජසංසදි සමර්පිෂ්‍යධ්වේ තේෂාං භජනගේහේ ප්‍රහාරිෂ්‍යධ්වේ| ");
INSERT INTO sansin_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","යූයං මන්නාමහේතෝඃ ශාස්තෘණාං රාඥාඤ්ච සමක්‍ෂං තානන්‍යදේශිනශ්චාධි සාක්‍ෂිත්වාර්ථමානේෂ්‍යධ්වේ| ");
INSERT INTO sansin_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","කින්ත්විත්ථං සමර්පිතා යූයං කථං කිමුත්තරං වක්‍ෂ්‍යථ තත්‍ර මා චින්තයත, යතස්තදා යුෂ්මාභි ර‍්‍යද් වක්තව්‍යං තත් තද්දණ්ඩේ යුෂ්මන්මනඃ සු සමුපස්ථාස්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","යස්මාත් තදා යෝ වක්‍ෂ්‍යති ස න යූයං කින්තු යුෂ්මාකමන්තරස්ථඃ පිත්‍රාත්මා| ");
INSERT INTO sansin_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","සහජඃ සහජං තාතඃ සුතඤ්ච මෘතෞ සමර්පයිෂ්‍යති, අපත්‍යාගි ස්වස්වපිත්‍රෝे ර්විපක්‍ෂීභූය තෞ ඝාතයිෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","මන්නමහේතෝඃ සර්ව්වේ ජනා යුෂ්මාන් ඍृතීයිෂ්‍යන්තේ, කින්තු යඃ ශේෂං යාවද් ධෛර‍්‍ය්‍යං ඝෘත්වා ස්ථාස්‍යති, ස ත්‍රායිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","තෛ ර‍්‍යදා යූයමේකපුරේ තාඩිෂ්‍යධ්වේ, තදා යූයමන්‍යපුරං පලායධ්වං යුෂ්මානහං තථ්‍යං වච්මි යාවන්මනුජසුතෝ නෛති තාවද් ඉස්‍රායේල්දේශීයසර්ව්වනගරභ්‍රමණං සමාපයිතුං න ශක්‍ෂ්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","ගුරෝඃ ශිෂ්‍යෝ න මහාන්, ප්‍රභෝර්දාසෝ න මහාන්| ");
INSERT INTO sansin_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","යදි ශිෂ්‍යෝ නිජගුරෝ ර්දාසශ්ච ස්වප්‍රභෝඃ සමානෝ භවති තර්හි තද් යථේෂ්ටං| චේත්තෛර්ගෘහපතිර්භූතරාජ උච්‍යතේ, තර්හි පරිවාරාඃ කිං තථා න වක්‍ෂ්‍යන්තේ? ");
INSERT INTO sansin_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","කින්තු තේභ්‍යෝ යූයං මා බිභීත, යතෝ යන්න ප්‍රකාශිෂ්‍යතේ, තාදෘක් ඡාදිතං කිමපි නාස්ති, යච්ච න ව්‍යඤ්චිෂ්‍යතේ, තාදෘග් ගුප්තං කිමපි නාස්ති| ");
INSERT INTO sansin_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","යදහං යුෂ්මාන් තමසි වච්මි තද් යුෂ්මාභිර්දීප්තෞ කථ්‍යතාං; කර්ණාභ්‍යාං යත් ශ්‍රූයතේ තද් ගේහෝපරි ප්‍රචාර‍්‍ය්‍යතාං| ");
INSERT INTO sansin_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","යේ කායං හන්තුං ශක්නුවන්ති නාත්මානං, තේභ්‍යෝ මා භෛෂ්ට; යඃ කායාත්මානෞ නිරයේ නාශයිතුං, ශක්නෝති, තතෝ බිභීත| ");
INSERT INTO sansin_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ද්වෞ චටකෞ කිමේකතාම්‍රමුද්‍රයා න වික්‍රීයේතේ? තථාපි යුෂ්මත්තාතානුමතිං විනා තේෂාමේකෝපි භුවි න පතති| ");
INSERT INTO sansin_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","යුෂ්මච්ඡිරසාං සර්ව්වකචා ගණිතාංඃ සන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","අතෝ මා බිභීත, යූයං බහුචටකේභ්‍යෝ බහුමූල්‍යාඃ| ");
INSERT INTO sansin_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","යෝ මනුජසාක්‍ෂාන්මාමඞ්ගීකුරුතේ තමහං ස්වර්ගස්ථතාතසාක්‍ෂාදඞ්ගීකරිෂ්‍යේ| ");
INSERT INTO sansin_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","පෘථ්ව්‍යාමහං ශාන්තිං දාතුමාගතඉති මානුභවත, ශාන්තිං දාතුං න කින්ත්වසිං| ");
INSERT INTO sansin_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","පිතෘමාතෘශ්චශ්‍රූභිඃ සාකං සුතසුතාබධූ ර්විරෝධයිතුඤ්චාගතේाස්මි| ");
INSERT INTO sansin_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","තතඃ ස්වස්වපරිවාරඒව නෘශත්‍රු ර්භවිතා| ");
INSERT INTO sansin_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","යඃ පිතරි මාතරි වා මත්තෝධිකං ප්‍රීයතේ, ස න මදර්හඃ; ");
INSERT INTO sansin_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","යශ්ච සුතේ සුතායාං වා මත්තෝධිකං ප්‍රීයතේ, සේाපි න මදර්හඃ| ");
INSERT INTO sansin_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","යඃ ස්වක්‍රුශං ගෘහ්ලන් මත්පශ්චාන්නෛති, සේाපි න මදර්හඃ| ");
INSERT INTO sansin_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","යඃ ස්වප්‍රාණානවති, ස තාන් හාරයිෂ්‍යතේ, යස්තු මත්කෘතේ ස්වප්‍රාණාන් හාරයති, ස තානවති| ");
INSERT INTO sansin_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","යෝ යුෂ්මාකමාතිථ්‍යං විදධාති, ස මමාතිථ්‍යං විදධාති, යශ්ච මමාතිථ්‍යං විදධාති, ස මත්ප්‍රේරකස්‍යාතිථ්‍යං විදධාති| ");
INSERT INTO sansin_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","යෝ භවිෂ්‍යද්වාදීති ඥාත්වා තස්‍යාතිථ්‍යං විධත්තේ, ස භවිෂ්‍යද්වාදිනඃ ඵලං ලප්ස්‍යතේ, යශ්ච ධාර්ම්මික ඉති විදිත්වා තස්‍යාතිථ්‍යං විධත්තේ ස ධාර්ම්මිකමානවස්‍ය ඵලං ප්‍රාප්ස්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","යශ්ච කශ්චිත් ඒතේෂාං ක්‍ෂුද්‍රනරාණාම් යං කඤ්චනෛකං ශිෂ්‍ය ඉති විදිත්වා කංසෛකං ශීතලසලිලං තස්මෛ දත්තේ, යුෂ්මානහං තථ්‍යං වදාමි, ස කේනාපි ප්‍රකාරේණ ඵලේන න වඤ්චිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ඉත්ථං යීශුඃ ස්වද්වාදශශිෂ්‍යාණාමාඥාපනං සමාප්‍ය පුරේ පුර උපදේෂ්ටුං සුසංවාදං ප්‍රචාරයිතුං තත්ස්ථානාත් ප්‍රතස්ථේ| ");
INSERT INTO sansin_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","අනන්තරං යෝහන් කාරායාං තිෂ්ඨන් ඛ්‍රිෂ්ටස්‍ය කර්ම්මණාං වාර්ත්තං ප්‍රාප්‍ය යස්‍යාගමනවාර්ත්තාසීත් සඒව කිං ත්වං? වා වයමන්‍යම් අපේක්‍ෂිෂ්‍යාමහේ? ");
INSERT INTO sansin_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ඒතත් ප්‍රෂ්ටුං නිජෞ ද්වෞ ශිෂ්‍යෞ ප්‍රාහිණෝත්| ");
INSERT INTO sansin_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","යීශුඃ ප්‍රත්‍යවෝචත්, අන්ධා නේත්‍රාණි ලභන්තේ, ඛඤ්චා ගච්ඡන්ති, කුෂ්ඨිනඃ ස්වස්ථා භවන්ති, බධිරාඃ ශෘණ්වන්ති, මෘතා ජීවන්ත උත්තිෂ්ඨන්ති, දරිද්‍රාණාං සමීපේ සුසංවාදඃ ප්‍රචාර‍්‍ය්‍යත, ");
INSERT INTO sansin_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ඒතානි යද්‍යද් යුවාං ශෘණුථඃ පශ්‍යථශ්ච ගත්වා තද්වාර්ත්තාං යෝහනං ගදතං| ");
INSERT INTO sansin_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","යස්‍යාහං න විඝ්නීභවාමි, සඒව ධන්‍යඃ| ");
INSERT INTO sansin_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","අනන්තරං තයෝඃ ප්‍රස්ථිතයෝ ර‍්‍යීශු ර‍්‍යෝහනම් උද්දිශ්‍ය ජනාන් ජගාද, යූයං කිං ද්‍රෂ්ටුං වහිර්මධ්‍යේප්‍රාන්තරම් අගච්ඡත? කිං වාතේන කම්පිතං නලං? ");
INSERT INTO sansin_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","වා කිං වීක්‍ෂිතුං වහිර්ගතවන්තඃ? කිං පරිහිතසූක්‍ෂ්මවසනං මනුජමේකං? පශ්‍යත, යේ සූක්‍ෂ්මවසනානි පරිදධති, තේ රාජධාන්‍යාං තිෂ්ඨන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","තර්හි යූයං කිං ද්‍රෂ්ටුං බහිරගමත, කිමේකං භවිෂ්‍යද්වාදිනං? තදේව සත්‍යං| යුෂ්මානහං වදාමි, ස භවිෂ්‍යද්වාදිනෝපි මහාන්; ");
INSERT INTO sansin_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","යතඃ, පශ්‍ය ස්වකීයදූතෝයං ත්වදග්‍රේ ප්‍රේෂ්‍යතේ මයා| ස ගත්වා තව පන්ථානං ස්මයක් පරිෂ්කරිෂ්‍යති|| ඒතද්වචනං යමධි ලිඛිතමාස්තේ සෝ(අ)යං යෝහන්| ");
INSERT INTO sansin_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","අපරං යුෂ්මානහං තථ්‍යං බ්‍රවීමි, මජ්ජයිතු ර‍්‍යෝහනඃ ශ්‍රේෂ්ඨඃ කෝපි නාරීතෝ නාජායත; තථාපි ස්වර්ගරාජ්‍යමධ්‍යේ සර්ව්වේභ්‍යෝ යඃ ක්‍ෂුද්‍රඃ ස යෝහනඃ ශ්‍රේෂ්ඨඃ| ");
INSERT INTO sansin_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","අපරඤ්ච ආ යෝහනෝ(අ)ද්‍ය යාවත් ස්වර්ගරාජ්‍යං බලාදාක්‍රාන්තං භවති ආක්‍රමිනශ්ච ජනා බලේන තදධිකුර්ව්වන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","යතෝ යෝහනං යාවත් සර්ව්වභවිෂ්‍යද්වාදිභි ර්ව්‍යවස්ථයා ච උපදේශඃ ප්‍රාකාශ්‍යත| ");
INSERT INTO sansin_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","යදි යූයමිදං වාක්‍යං ග්‍රහීතුං ශක්නුථ, තර්හි ශ්‍රේයඃ, යස්‍යාගමනස්‍ය වචනමාස්තේ සෝ(අ)යම් ඒලියඃ| ");
INSERT INTO sansin_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","යස්‍ය ශ්‍රෝතුං කර්ණෞ ස්තඃ ස ශෘණෝතු| ");
INSERT INTO sansin_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","ඒතේ විද්‍යමානජනාඃ කෛ ර්මයෝපමීයන්තේ? යේ බාලකා හට්ට උපවිශ්‍ය ස්වං ස්වං බන්ධුමාහූය වදන්ති, ");
INSERT INTO sansin_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","වයං යුෂ්මාකං සමීපේ වංශීරවාදයාම, කින්තු යූයං නානෘත්‍යත; යුෂ්මාකං සමීපේ ච වයමරෝදිම, කින්තු යූයං න ව්‍යලපත, තාදෘශෛ ර්බාලකෛස්ත උපමායිෂ්‍යන්තේ| ");
INSERT INTO sansin_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","යතෝ යෝහන් ආගත්‍ය න භුක්තවාන් න පීතවාංශ්ච, තේන ලෝකා වදන්ති, ස භූතග්‍රස්ත ඉති| ");
INSERT INTO sansin_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","මනුජසුත ආගත්‍ය භුක්තවාන් පීතවාංශ්ච, තේන ලෝකා වදන්ති, පශ්‍යත ඒෂ භෝක්තා මද්‍යපාතා චණ්ඩාලපාපිනාං බන්ධශ්ච, කින්තු ඥානිනෝ ඥානව්‍යවහාරං නිර්දෝෂං ජානන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ස යත්‍ර යත්‍ර පුරේ බහ්වාශ්චර‍්‍ය්‍යං කර්ම්ම කෘතවාන්, තන්නිවාසිනාං මනඃපරාවෘත්ත්‍යභාවාත් තානි නගරාණි ප්‍රති හන්තේත්‍යුක්තා කථිතවාන්, ");
INSERT INTO sansin_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","හා කෝරාසීන්, හා බෛත්සෛදේ, යුෂ්මන්මධ්‍යේ යද්‍යදාශ්චර‍්‍ය්‍යං කර්ම්ම කෘතං යදි තත් සෝරසීදෝන්නගර අකාරිෂ්‍යත, තර්හි පූර්ව්වමේව තන්නිවාසිනඃ ශාණවසනේ භස්මනි චෝපවිශන්තෝ මනාංසි පරාවර්ත්තිෂ්‍යන්ත| ");
INSERT INTO sansin_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","තස්මාදහං යුෂ්මාන් වදාමි, විචාරදිනේ යුෂ්මාකං දශාතඃ සෝරසීදෝනෝ ර්දශා සහ්‍යතරා භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","අපරඤ්ච බත කඵර්නාහූම්, ත්වං ස්වර්ගං යාවදුන්නතෝසි, කින්තු නරකේ නික්‍ෂේප්ස්‍යසේ, යස්මාත් ත්වයි යාන්‍යාශ්චර‍්‍ය්‍යාණි කර්ම්මණ්‍යකාරිෂත, යදි තානි සිදෝම්නගර අකාරිෂ්‍යන්ත, තර්හි තදද්‍ය යාවදස්ථාස්‍යත්| ");
INSERT INTO sansin_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","කින්ත්වහං යුෂ්මාන් වදාමි, විචාරදිනේ තව දණ්ඩතඃ සිදෝමෝ දණ්ඩෝ සහ්‍යතරෝ භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ඒතස්මින්නේව සමයේ යීශුඃ පුනරුවාච, හේ ස්වර්ගපෘථිව්‍යෝරේකාධිපතේ පිතස්ත්වං ඥානවතෝ විදුෂශ්ච ලෝකාන් ප්‍රත්‍යේතානි න ප්‍රකාශ්‍ය බාලකාන් ප්‍රති ප්‍රකාශිතවාන්, ඉති හේතෝස්ත්වාං ධන්‍යං වදාමි| ");
INSERT INTO sansin_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","හේ පිතඃ, ඉත්ථං භවේත් යත ඉදං ත්වදෘෂ්ටාවුත්තමං| ");
INSERT INTO sansin_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","පිත්‍රා මයි සර්ව්වාණි සමර්පිතානි, පිතරං විනා කෝපි පුත්‍රං න ජානාති, යාන් ප්‍රති පුත්‍රේණ පිතා ප්‍රකාශ්‍යතේ තාන් විනා පුත්‍රාද් අන්‍යඃ කෝපි පිතරං න ජානාති| ");
INSERT INTO sansin_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","හේ පරිශ්‍රාන්තා භාරාක්‍රාන්තාශ්ච ලෝකා යූයං මත්සන්නිධිම් ආගච්ඡත, අහං යුෂ්මාන් විශ්‍රමයිෂ්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","අහං ක්‍ෂමණශීලෝ නම්‍රමනාශ්ච, තස්මාත් මම යුගං ස්වේෂාමුපරි ධාරයත මත්තඃ ශික්‍ෂධ්වඤ්ච, තේන යූයං ස්වේ ස්වේ මනසි විශ්‍රාමං ලප්ස්‍යධ්බේ| ");
INSERT INTO sansin_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","යතෝ මම යුගම් අනායාසං මම භාරශ්ච ලඝුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","අනන්තරං යීශු ර්විශ්‍රාමවාරේ ශ්ස්‍යමධ්‍යේන ගච්ඡති, තදා තච්ඡිෂ්‍යා බුභුක්‍ෂිතාඃ සන්තඃ ශ්ස්‍යමඤ්ජරීශ්ඡත්වා ඡිත්වා ඛාදිතුමාරභන්ත| ");
INSERT INTO sansin_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","තද් විලෝක්‍ය ඵිරූශිනෝ යීශුං ජගදුඃ, පශ්‍ය විශ්‍රාමවාරේ යත් කර්ම්මාකර්ත්තව්‍යං තදේව තව ශිෂ්‍යාඃ කුර්ව්වන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ස තාන් ප්‍රත්‍යාවදත, දායූද් තත්සඞ්ගිනශ්ච බුභුක්‍ෂිතාඃ සන්තෝ යත් කර්ම්මාකුර්ව්වන් තත් කිං යුෂ්මාභි ර්නාපාඨි? ");
INSERT INTO sansin_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","යේ දර්ශනීයාඃ පූපාඃ යාජකාන් විනා තස්‍ය තත්සඞ්ගිමනුජානාඤ්චාභෝජනීයාස්ත ඊශ්වරාවාසං ප්‍රවිෂ්ටේන තේන භුක්තාඃ| ");
INSERT INTO sansin_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","අන්‍යච්ච විශ්‍රාමවාරේ මධ්‍යේමන්දිරං විශ්‍රාමවාරීයං නියමං ලඞ්වන්තෝපි යාජකා නිර්දෝෂා භවන්ති, ශාස්ත්‍රමධ්‍යේ කිමිදමපි යුෂ්මාභි ර්න පඨිතං? ");
INSERT INTO sansin_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","යුෂ්මානහං වදාමි, අත්‍ර ස්ථානේ මන්දිරාදපි ගරීයාන් ඒක ආස්තේ| ");
INSERT INTO sansin_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","කින්තු දයායාං මේ යථා ප්‍රීති ර්න තථා යඥකර්ම්මණි| ඒතද්වචනස්‍යාර්ථං යදි යුයම් අඥාසිෂ්ට තර්හි නිර්දෝෂාන් දෝෂිණෝ නාකාර්ෂ්ට| ");
INSERT INTO sansin_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","අන්‍යච්ච මනුජසුතෝ විශ්‍රාමවාරස්‍යාපි පතිරාස්තේ| ");
INSERT INTO sansin_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","අනන්තරං ස තත්ස්ථානාත් ප්‍රස්ථාය තේෂාං භජනභවනං ප්‍රවිෂ්ටවාන්, තදානීම් ඒකඃ ශුෂ්කකරාමයවාන් උපස්ථිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","තතෝ යීශුම් අපවදිතුං මානුෂාඃ පප්‍රච්ඡුඃ, විශ්‍රාමවාරේ නිරාමයත්වං කරණීයං න වා? ");
INSERT INTO sansin_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","තේන ස ප්‍රත්‍යුවාච, විශ්‍රාමවාරේ යදි කස්‍යචිද් අවි ර්ගර්ත්තේ පතති, තර්හි යස්තං ඝෘත්වා න තෝලයති, ඒතාදෘශෝ මනුජෝ යුෂ්මාකං මධ්‍යේ ක ආස්තේ? ");
INSERT INTO sansin_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","අවේ ර්මානවඃ කිං නහි ශ්‍රේයාන්? අතෝ විශ්‍රාමවාරේ හිතකර්ම්ම කර්ත්තව්‍යං| ");
INSERT INTO sansin_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","අනන්තරං ස තං මානවං ගදිතවාන්, කරං ප්‍රසාරය; තේන කරේ ප්‍රසාරිතේ සෝන්‍යකරවත් ස්වස්ථෝ(අ)භවත්| ");
INSERT INTO sansin_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","තදා ඵිරූශිනෝ බහිර්භූය කථං තං හනිෂ්‍යාම ඉති කුමන්ත්‍රණාං තත්ප්‍රාතිකූල්‍යේන චක්‍රුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","තතෝ යීශුස්තද් විදිත්වා ස්ථනාන්තරං ගතවාන්; අන්‍යේෂු බහුනරේෂු තත්පශ්චාද් ගතේෂු තාන් ස නිරාමයාන් කෘත්වා ඉත්‍යාඥාපයත්, ");
INSERT INTO sansin_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","යූයං මාං න පරිචායයත| ");
INSERT INTO sansin_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","තස්මාත් මම ප්‍රීයෝ මනෝනීතෝ මනසස්තුෂ්ටිකාරකඃ| මදීයඃ සේවකෝ යස්තු විද්‍යතේ තං සමීක්‍ෂතාං| තස්‍යෝපරි ස්වකීයාත්මා මයා සංස්ථාපයිෂ්‍යතේ| තේනාන්‍යදේශජාතේෂු ව්‍යවස්ථා සංප්‍රකාශ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","කේනාපි න විරෝධං ස විවාදඤ්ච කරිෂ්‍යති| න ච රාජපථේ තේන වචනං ශ්‍රාවයිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ව්‍යවස්ථා චලිතා යාවත් නහි තේන කරිෂ්‍යතේ| තාවත් නලෝ විදීර්ණෝ(අ)පි භංක්‍ෂ්‍යතේ නහි තේන ච| තථා සධූමවර්ත්තිඤ්ච න ස නිර්ව්වාපයිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ප්‍රත්‍යාශාඤ්ච කරිෂ්‍යන්ති තන්නාම්නි භින්නදේශජාඃ| ");
INSERT INTO sansin_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","යාන්‍යේතානි වචනානි යිශයියභවිෂ්‍යද්වාදිනා ප්‍රෝක්තාන්‍යාසන්, තානි සඵලාන්‍යභවන්| ");
INSERT INTO sansin_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","අනන්තරං ලෝකෛ ස්තත්සමීපම් ආනීතෝ භූතග්‍රස්තාන්ධමූකෛකමනුජස්තේන ස්වස්ථීකෘතඃ, තතඃ සෝ(අ)න්ධෝ මූකෝ ද්‍රෂ්ටුං වක්තුඤ්චාරබ්ධවාන්| ");
INSERT INTO sansin_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","අනේන සර්ව්වේ විස්මිතාඃ කථයාඤ්චක්‍රුඃ, ඒෂඃ කිං දායූදඃ සන්තානෝ නහි? ");
INSERT INTO sansin_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","කින්තු ඵිරූශිනස්තත් ශ්‍රුත්වා ගදිතවන්තඃ, බාල්සිබූබ්නාම්නෝ භූතරාජස්‍ය සාහාය්‍යං විනා නායං භූතාන් ත්‍යාජයති| ");
INSERT INTO sansin_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","තදානීං යීශුස්තේෂාම් ඉති මානසං විඥාය තාන් අවදත් කිඤ්චන රාජ්‍යං යදි ස්වවිපක්‍ෂාද් භිද්‍යතේ, තර්හි තත් උච්ඡිද්‍යතේ; යච්ච කිඤ්චන නගරං වා ගෘහං ස්වවිපක්‍ෂාද් විභිද්‍යතේ, තත් ස්ථාතුං න ශක්නෝති| ");
INSERT INTO sansin_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","තද්වත් ශයතානෝ යදි ශයතානං බහිඃ කෘත්වා ස්වවිපක්‍ෂාත් පෘථක් පෘථක් භවති, තර්හි තස්‍ය රාජ්‍යං කේන ප්‍රකාරේණ ස්ථාස්‍යති? ");
INSERT INTO sansin_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","අහඤ්ච යදි බාල්සිබූබා භූතාන් ත්‍යාජයාමි, තර්හි යුෂ්මාකං සන්තානාඃ කේන භූතාන් ත්‍යාජයන්ති? තස්මාද් යුෂ්මාකම් ඒතද්විචාරයිතාරස්ත ඒව භවිෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","කින්තවහං යදීශ්වරාත්මනා භූතාන් ත්‍යාජයාමි, තර්හීශ්වරස්‍ය රාජ්‍යං යුෂ්මාකං සන්නිධිමාගතවත්| ");
INSERT INTO sansin_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","අන්‍යඤ්ච කෝපි බලවන්ත ජනං ප්‍රථමතෝ න බද්ව්වා කේන ප්‍රකාරේණ තස්‍ය ගෘහං ප්‍රවිශ්‍ය තද්ද්‍රව්‍යාදි ලෝඨයිතුං ශක්නෝති? කින්තු තත් කෘත්වා තදීයගෘස්‍ය ද්‍රව්‍යාදි ලෝඨයිතුං ශක්නෝති| ");
INSERT INTO sansin_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","යඃ කශ්චිත් මම ස්වපක්‍ෂීයෝ නහි ස විපක්‍ෂීය ආස්තේ, යශ්ච මයා සාකං න සංගෘහ්ලාති, ස විකිරති| ");
INSERT INTO sansin_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","අතඒව යුෂ්මානහං වදාමි, මනුජානාං සර්ව්වප්‍රකාරපාපානාං නින්දායාශ්ච මර්ෂණං භවිතුං ශක්නෝති, කින්තු පවිත්‍රස්‍යාත්මනෝ විරුද්ධනින්දායා මර්ෂණං භවිතුං න ශක්නෝති| ");
INSERT INTO sansin_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","යෝ මනුජසුතස්‍ය විරුද්ධාං කථාං කථයති, තස්‍යාපරාධස්‍ය ක්‍ෂමා භවිතුං ශක්නෝති, කින්තු යඃ කශ්චිත් පවිත්‍රස්‍යාත්මනෝ විරුද්ධාං කථාං කථයති නේහලෝකේ න ප්‍රේත්‍ය තස්‍යාපරාධස්‍ය ක්‍ෂමා භවිතුං ශක්නෝති| ");
INSERT INTO sansin_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","පාදපං යදි භද්‍රං වදථ, තර්හි තස්‍ය ඵලමපි සාධු වක්තව්‍යං, යදි ච පාදපං අසාධුං වදථ, තර්හි තස්‍ය ඵලමප්‍යසාධු වක්තව්‍යං; යතඃ ස්වීයස්වීයඵලේන පාදපඃ පරිචීයතේ| ");
INSERT INTO sansin_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","රේ භුජගවංශා යූයමසාධවඃ සන්තඃ කථං සාධු වාක්‍යං වක්තුං ශක්‍ෂ්‍යථ? යස්මාද් අන්තඃකරණස්‍ය පූර්ණභාවානුසාරාද් වදනාද් වචෝ නිර්ගච්ඡති| ");
INSERT INTO sansin_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","තේන සාධුර්මානවෝ(අ)න්තඃකරණරූපාත් සාධුභාණ්ඩාගාරාත් සාධු ද්‍රව්‍යං නිර්ගමයති, අසාධුර්මානුෂස්ත්වසාධුභාණ්ඩාගාරාද් අසාධුවස්තූනි නිර්ගමයති| ");
INSERT INTO sansin_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","කින්ත්වහං යුෂ්මාන් වදාමි, මනුජා යාවන්ත්‍යාලස්‍යවචාංසි වදන්ති, විචාරදිනේ තදුත්තරමවශ්‍යං දාතව්‍යං, ");
INSERT INTO sansin_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","යතස්ත්වං ස්වීයවචෝභි ර්නිරපරාධඃ ස්වීයවචෝභිශ්ච සාපරාධෝ ගණිෂ්‍යසේ| ");
INSERT INTO sansin_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","තදානීං කතිපයා උපාධ්‍යායාඃ ඵිරූශිනශ්ච ජගදුඃ, හේ ගුරෝ වයං භවත්තඃ කිඤ්චන ලක්‍ෂ්ම දිදෘක්‍ෂාමඃ| ");
INSERT INTO sansin_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","තදා ස ප්‍රත්‍යුක්තවාන්, දුෂ්ටෝ ව්‍යභිචාරී ච වංශෝ ලක්‍ෂ්ම මෘගයතේ, කින්තු භවිෂ්‍යද්වාදිනෝ යූනසෝ ලක්‍ෂ්ම විහායාන්‍යත් කිමපි ලක්‍ෂ්ම තේ න ප්‍රදර්ශයිෂ්‍යන්තේ| ");
INSERT INTO sansin_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","යතෝ යූනම් යථා ත්‍ර‍්‍යහෝරාත්‍රං බෘහන්මීනස්‍ය කුක්‍ෂාවාසීත්, තථා මනුජපුත්‍රෝපි ත්‍ර‍්‍යහෝරාත්‍රං මේදින්‍යා මධ්‍යේ ස්ථාස්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","අපරං නීනිවීයා මානවා විචාරදින ඒතද්වංශීයානාං ප්‍රතිකූලම් උත්ථාය තාන් දෝෂිණඃ කරිෂ්‍යන්ති, යස්මාත්තේ යූනස උපදේශාත් මනාංසි පරාවර්ත්තයාඤ්චක්‍රිරේ, කින්ත්වත්‍ර යූනසෝපි ගුරුතර ඒක ආස්තේ| ");
INSERT INTO sansin_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","පුනශ්ච දක්‍ෂිණදේශීයා රාඥී විචාරදින ඒතද්වංශීයානාං ප්‍රතිකූලමුත්ථාය තාන් දෝෂිණඃ කරිෂ්‍යති යතඃ සා රාඥී සුලේමනෝ විද්‍යායාඃ කථාං ශ්‍රෝතුං මේදින්‍යාඃ සීම්න ආගච්ඡත්, කින්තු සුලේමනෝපි ගුරුතර ඒකෝ ජනෝ(අ)ත්‍ර ආස්තේ| ");
INSERT INTO sansin_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","අපරං මනුජාද් බහිර්ගතෝ (අ)පවිත්‍රභූතඃ ශුෂ්කස්ථානේන ගත්වා විශ්‍රාමං ගවේෂයති, කින්තු තදලභමානඃ ස වක්ති, යස්මා; නිකේතනාද් ආගමං, තදේව වේශ්ම පකාවෘත්‍ය යාමි| ");
INSERT INTO sansin_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","පශ්චාත් ස තත් ස්ථානම් උපස්ථාය තත් ශූන්‍යං මාර්ජ්ජිතං ශෝභිතඤ්ච විලෝක්‍ය ව්‍රජන් ස්වතෝපි දුෂ්ටතරාන් අන්‍යසප්තභූතාන් සඞ්ගිනඃ කරෝති| ");
INSERT INTO sansin_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","තතස්තේ තත් ස්ථානං ප්‍රවිශ්‍ය නිවසන්ති, තේන තස්‍ය මනුජස්‍ය ශේෂදශා පූර්ව්වදශාතෝතීවාශුභා භවති, ඒතේෂාං දුෂ්ටවංශ්‍යානාමපි තථෛව ඝටිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","මානවේභ්‍ය ඒතාසාං කථනාං කථනකාලේ තස්‍ය මාතා සහජාශ්ච තේන සාකං කාඤ්චිත් කථාං කථයිතුං වාඤ්ඡන්තෝ බහිරේව ස්ථිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","තතඃ කශ්චිත් තස්මෛ කථිතවාන්, පශ්‍ය තව ජනනී සහජාශ්ච ත්වයා සාකං කාඤ්චන කථාං කථයිතුං කාමයමානා බහිස්තිෂ්ඨන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","කින්තු ස තං ප්‍රත්‍යවදත්, මම කා ජනනී? කේ වා මම සහජාඃ? ");
INSERT INTO sansin_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","පශ්චාත් ශිෂ්‍යාන් ප්‍රති කරං ප්‍රසාර‍්‍ය්‍ය කථිතවාන්, පශ්‍ය මම ජනනී මම සහජාශ්චෛතේ; ");
INSERT INTO sansin_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","යඃ කශ්චිත් මම ස්වර්ගස්ථස්‍ය පිතුරිෂ්ටං කර්ම්ම කුරුතේ, සඒව මම භ්‍රාතා භගිනී ජනනී ච| ");
INSERT INTO sansin_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","අපරඤ්ච තස්මින් දිනේ යීශුඃ සද්මනෝ ගත්වා සරිත්පතේ රෝධසි සමුපවිවේශ| ");
INSERT INTO sansin_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","තත්‍ර තත්සන්නිධෞ බහුජනානාං නිවහෝපස්ථිතේඃ ස තරණිමාරුහ්‍ය සමුපාවිශත්, තේන මානවා රෝධසි ස්ථිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","තදානීං ස දෘෂ්ටාන්තෛස්තාන් ඉත්ථං බහුශ උපදිෂ්ටවාන්| පශ්‍යත, කශ්චිත් කෘෂීවලෝ බීජානි වප්තුං බහිර්ජගාම, ");
INSERT INTO sansin_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","තස්‍ය වපනකාලේ කතිපයබීජේෂු මාර්ගපාර්ශ්වේ පතිතේෂු විහගාස්තානි භක්‍ෂිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","අපරං කතිපයබීජේෂු ස්තෝකමෘද්‍යුක්තපාෂාණේ පතිතේෂු මෘදල්පත්වාත් තත්ක්‍ෂණාත් තාන්‍යඞ්කුරිතානි, ");
INSERT INTO sansin_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","කින්තු රවාවුදිතේ දග්ධානි තේෂාං මූලාප්‍රවිෂ්ටත්වාත් ශුෂ්කතාං ගතානි ච| ");
INSERT INTO sansin_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","අපරං කතිපයබීජේෂු කණ්ටකානාං මධ්‍යේ පතිතේෂු කණ්ටකාන්‍යේධිත්වා තානි ජග්‍රසුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","අපරඤ්ච කතිපයබීජානි උර්ව්වරායාං පතිතානි; තේෂාං මධ්‍යේ කානිචිත් ශතගුණානි කානිචිත් ෂෂ්ටිගුණානි කානිචිත් ත්‍රිංශගුංණානි ඵලානි ඵලිතවන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ශ්‍රෝතුං යස්‍ය ශ්‍රුතී ආසාතේ ස ශෘණුයාත්| ");
INSERT INTO sansin_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","අනන්තරං ශිෂ්‍යෛරාගත්‍ය සෝ(අ)පෘච්ඡ්‍යත, භවතා තේභ්‍යඃ කුතෝ දෘෂ්ටාන්තකථා කථ්‍යතේ? ");
INSERT INTO sansin_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","තතඃ ස ප්‍රත්‍යවදත්, ස්වර්ගරාජ්‍යස්‍ය නිගූඪාං කථාං වේදිතුං යුෂ්මභ්‍යං සාමර්ථ්‍යමදායි, කින්තු තේභ්‍යෝ නාදායි| ");
INSERT INTO sansin_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","යස්මාද් යස්‍යාන්තිකේ වර්ද්ධතේ, තස්මායේව දායිෂ්‍යතේ, තස්මාත් තස්‍ය බාහුල්‍යං භවිෂ්‍යති, කින්තු යස්‍යාන්තිකේ න වර්ද්ධතේ, තස්‍ය යත් කිඤ්චනාස්තේ, තදපි තස්මාද් ආදායිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","තේ පශ්‍යන්තෝපි න පශ්‍යන්ති, ශෘණ්වන්තෝපි න ශෘණ්වන්ති, බුධ්‍යමානා අපි න බුධ්‍යන්තේ ච, තස්මාත් තේභ්‍යෝ දෘෂ්ටාන්තකථා කථ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","යථා කර්ණෛඃ ශ්‍රෝෂ්‍යථ යූයං වෛ කින්තු යූයං න භෝත්ස්‍යථ| නේත්‍රෛර්ද්‍රක්‍ෂ්‍යථ යූයඤ්ච පරිඥාතුං න ශක්‍ෂ්‍යථ| තේ මානුෂා යථා නෛව පරිපශ්‍යන්ති ලෝචනෛඃ| කර්ණෛ ර‍්‍යථා න ශෘණ්වන්ති න බුධ්‍යන්තේ ච මානසෛඃ| ව්‍යාවර්ත්තිතේෂු චිත්තේෂු කාලේ කුත්‍රාපි තෛර්ජනෛඃ| මත්තස්තේ මනුජාඃ ස්වස්ථා යථා නෛව භවන්ති ච| තථා තේෂාං මනුෂ්‍යාණාං ක්‍රියන්තේ ස්ථූලබුද්ධයඃ| බධිරීභූතකර්ණාශ්ච ජාතාශ්ච මුද්‍රිතා දෘශඃ| ");
INSERT INTO sansin_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","යදේතානි වචනානි යිශයියභවිෂ්‍යද්වාදිනා ප්‍රෝක්තානි තේෂු තානි ඵලන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","කින්තු යුෂ්මාකං නයනානි ධන්‍යානි, යස්මාත් තානි වීක්‍ෂන්තේ; ධන්‍යාශ්ච යුෂ්මාකං ශබ්දග්‍රහාඃ, යස්මාත් තෛරාකර්ණ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","මයා යූයං තථ්‍යං වචාමි යුෂ්මාභි ර‍්‍යද්‍යද් වීක්‍ෂ්‍යතේ, තද් බහවෝ භවිෂ්‍යද්වාදිනෝ ධාර්ම්මිකාශ්ච මානවා දිදෘක්‍ෂන්තෝපි ද්‍රෂ්ටුං නාලභන්ත, පුනශ්ච යූයං යද්‍යත් ශෘණුථ, තත් තේ ශුශ්‍රූෂමාණා අපි ශ්‍රෝතුං නාලභන්ත| ");
INSERT INTO sansin_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","කෘෂීවලීයදෘෂ්ටාන්තස්‍යාර්ථං ශෘණුත| ");
INSERT INTO sansin_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","මාර්ගපාර්ශ්වේ බීජාන්‍යුප්තානි තස්‍යාර්ථ ඒෂඃ, යදා කශ්චිත් රාජ්‍යස්‍ය කථාං නිශම්‍ය න බුධ්‍යතේ, තදා පාපාත්මාගත්‍ය තදීයමනස උප්තාං කථාං හරන් නයති| ");
INSERT INTO sansin_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","අපරං පාෂාණස්ථලේ බීජාන්‍යුප්තානි තස්‍යාර්ථ ඒෂඃ; කශ්චිත් කථාං ශ්‍රුත්වෛව හර්ෂචිත්තේන ගෘහ්ලාති, ");
INSERT INTO sansin_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","කින්තු තස්‍ය මනසි මූලාප්‍රවිෂ්ටත්වාත් ස කිඤ්චිත්කාලමාත්‍රං ස්ථිරස්තිෂ්ඨති; පශ්චාත තත්කථාකාරණාත් කෝපි ක්ලේස්තාඩනා වා චේත් ජායතේ, තර්හි ස තත්ක්‍ෂණාද් විඝ්නමේති| ");
INSERT INTO sansin_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","අපරං කණ්ටකානාං මධ්‍යේ බීජාන්‍යුප්තානි තදර්ථ ඒෂඃ; කේනචිත් කථායාං ශ්‍රුතායාං සාංසාරිකචින්තාභි ර්භ්‍රාන්තිභිශ්ච සා ග්‍රස්‍යතේ, තේන සා මා විඵලා භවති| ");
INSERT INTO sansin_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","අපරම් උර්ව්වරායාං බීජාන්‍යුප්තානි තදර්ථ ඒෂඃ; යේ තාං කථාං ශ්‍රුත්වා වුධ්‍යන්තේ, තේ ඵලිතාඃ සන්තඃ කේචිත් ශතගුණානි කේචිත ෂෂ්ටිගුණානි කේචිච්ච ත්‍රිංශද්ගුණානි ඵලානි ජනයන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","අනන්තරං සෝපරාමේකාං දෘෂ්ටාන්තකථාමුපස්ථාප්‍ය තේභ්‍යඃ කථයාමාස; ස්වර්ගීයරාජ්‍යං තාදෘශේන කේනචිද් ගෘහස්ථේනෝපමීයතේ, යේන ස්වීයක්‍ෂේත්‍රේ ප්‍රශස්තබීජාන්‍යෞප්‍යන්ත| ");
INSERT INTO sansin_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","කින්තු ක්‍ෂණදායාං සකලලෝකේෂු සුප්තේෂු තස්‍ය රිපුරාගත්‍ය තේෂාං ගෝධූමබීජානාං මධ්‍යේ වන්‍යයවමබීජාන්‍යුප්ත්වා වව්‍රාජ| ");
INSERT INTO sansin_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","තතෝ යදා බීජේභ්‍යෝ(අ)ඞ්කරා ජායමානාඃ කණිශානි ඝෘතවන්තඃ; තදා වන්‍යයවසාන්‍යපි දෘශ්‍යමානාන්‍යභවන්| ");
INSERT INTO sansin_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","තතෝ ගෘහස්ථස්‍ය දාසේයා ආගම්‍ය තස්මෛ කථයාඤ්චක්‍රුඃ, හේ මහේච්ඡ, භවතා කිං ක්‍ෂේත්‍රේ භද්‍රබීජානි නෞප්‍යන්ත? තථාත්වේ වන්‍යයවසානි කෘත ආයන්? ");
INSERT INTO sansin_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","තදානීං තේන තේ ප්‍රතිගදිතාඃ, කේනචිත් රිපුණා කර්ම්මදමකාරි| දාසේයාඃ කථයාමාසුඃ, වයං ගත්වා තාන්‍යුත්පාය්‍ය ක්‍ෂිපාමෝ භවතඃ කීදෘශීච්ඡා ජායතේ? ");
INSERT INTO sansin_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","තේනාවාදි, නහි, ශඞ්කේ(අ)හං වන්‍යයවසෝත්පාටනකාලේ යුෂ්මාභිස්තෛඃ සාකං ගෝධූමා අප්‍යුත්පාටිෂ්‍යන්තේ| ");
INSERT INTO sansin_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","අතඃ ශ්ස්‍යකර්ත්තනකාලං යාවද් උභයාන්‍යපි සහ වර්ද්ධන්තාං, පශ්චාත් කර්ත්තනකාලේ කර්ත්තකාන් වක්‍ෂ්‍යාමි, යූයමාදෞ වන්‍යයවසානි සංගෘහ්‍ය දාහයිතුං වීටිකා බද්ව්වා ස්ථාපයත; කින්තු සර්ව්වේ ගෝධූමා යුෂ්මාභි ර්භාණ්ඩාගාරං නීත්වා ස්ථාප්‍යන්තාම්| ");
INSERT INTO sansin_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","අනන්තරං සෝපරාමේකාං දෘෂ්ටාන්තකථාමුත්ථාප්‍ය තේභ්‍යඃ කථිතවාන් කශ්චින්මනුජඃ සර්ෂපබීජමේකං නීත්වා ස්වක්‍ෂේත්‍ර උවාප| ");
INSERT INTO sansin_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","සර්ෂපබීජං සර්ව්වස්මාද් බීජාත් ක්‍ෂුද්‍රමපි සදඞ්කුරිතං සර්ව්වස්මාත් ශාකාත් බෘහද් භවති; ස තාදෘශස්තරු ර්භවති, යස්‍ය ශාඛාසු නභසඃ ඛගා ආගත්‍ය නිවසන්ති; ස්වර්ගීයරාජ්‍යං තාදෘශස්‍ය සර්ෂපෛකස්‍ය සමම්| ");
INSERT INTO sansin_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","පුනරපි ස උපමාකථාමේකාං තේභ්‍යඃ කථයාඤ්චකාර; කාචන යෝෂිත් යත් කිණ්වමාදාය ද්‍රෝණත්‍රයමිතගෝධූමචූර්ණානාං මධ්‍යේ සර්ව්වේෂාං මිශ්‍රීභවනපර‍්‍ය්‍යන්තං සමාච්ඡාද්‍ය නිධත්තවතී, තත්කිණ්වමිව ස්වර්ගරාජ්‍යං| ");
INSERT INTO sansin_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ඉත්ථං යීශු ර්මනුජනිවහානාං සන්නිධාවුපමාකථාභිරේතාන්‍යාඛ්‍යානානි කථිතවාන් උපමාං විනා තේභ්‍යඃ කිමපි කථාං නාකථයත්| ");
INSERT INTO sansin_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ඒතේන දෘෂ්ටාන්තීයේන වාක්‍යේන ව්‍යාදාය වදනං නිජං| අහං ප්‍රකාශයිෂ්‍යාමි ගුප්තවාක්‍යං පුරාභවං| යදේතද්වචනං භවිෂ්‍යද්වාදිනා ප්‍රෝක්තමාසීත්, තත් සිද්ධමභවත්| ");
INSERT INTO sansin_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","සර්ව්වාන් මනුජාන් විසෘජ්‍ය යීශෞ ගෘහං ප්‍රවිෂ්ටේ තච්ඡිෂ්‍යා ආගත්‍ය යීශවේ කථිතවන්තඃ, ක්‍ෂේත්‍රස්‍ය වන්‍යයවසීයදෘෂ්ටාන්තකථාම් භවාන අස්මාන් ස්පෂ්ටීකෘත්‍ය වදතු| ");
INSERT INTO sansin_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","තතඃ ස ප්‍රත්‍යුවාච, යේන භද්‍රබීජාන්‍යුප්‍යන්තේ ස මනුජපුත්‍රඃ, ");
INSERT INTO sansin_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ක්‍ෂේත්‍රං ජගත්, භද්‍රබීජානී රාජ්‍යස්‍ය සන්තානාඃ, ");
INSERT INTO sansin_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","වන්‍යයවසානි පාපාත්මනඃ සන්තානාඃ| යේන රිපුණා තාන්‍යුප්තානි ස ශයතානඃ, කර්ත්තනසමයශ්ච ජගතඃ ශේෂඃ, කර්ත්තකාඃ ස්වර්ගීයදූතාඃ| ");
INSERT INTO sansin_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","යථා වන්‍යයවසානි සංගෘහ්‍ය දාහ්‍යන්තේ, තථා ජගතඃ ශේෂේ භවිෂ්‍යති; ");
INSERT INTO sansin_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","අර්ථාත් මනුජසුතඃ ස්වාංයදූතාන් ප්‍රේෂයිෂ්‍යති, තේන තේ ච තස්‍ය රාජ්‍යාත් සර්ව්වාන් විඝ්නකාරිණෝ(අ)ධාර්ම්මිකලෝකාංශ්ච සංගෘහ්‍ය ");
INSERT INTO sansin_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","යත්‍ර රෝදනං දන්තඝර්ෂණඤ්ච භවති, තත්‍රාග්නිකුණ්ඩේ නික්‍ෂේප්ස්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","තදානීං ධාර්ම්මිකලෝකාඃ ස්වේෂාං පිතූ රාජ්‍යේ භාස්කරඉව තේජස්විනෝ භවිෂ්‍යන්ති| ශ්‍රෝතුං යස්‍ය ශ්‍රුතී ආසාතේ, ම ශෘණුයාත්| ");
INSERT INTO sansin_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","අපරඤ්ච ක්‍ෂේත්‍රමධ්‍යේ නිධිං පශ්‍යන් යෝ ගෝපයති, තතඃ පරං සානන්දෝ ගත්වා ස්වීයසර්ව්වස්වං වික්‍රීය ත්තක්‍ෂේත්‍රං ක්‍රීණාති, ස ඉව ස්වර්ගරාජ්‍යං| ");
INSERT INTO sansin_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","අන්‍යඤ්ච යෝ වණික් උත්තමාං මුක්තාං ගවේෂයන් ");
INSERT INTO sansin_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","මහාර්ඝාං මුක්තාං විලෝක්‍ය නිජසර්ව්වස්වං වික්‍රීය තාං ක්‍රීණාති, ස ඉව ස්වර්ගරාජ්‍යං| ");
INSERT INTO sansin_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","පුනශ්ච සමුද්‍රෝ නික්‍ෂිප්තඃ සර්ව්වප්‍රකාරමීනසංග්‍රාහ්‍යානායඉව ස්වර්ගරාජ්‍යං| ");
INSERT INTO sansin_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","තස්මින් ආනායේ පූර්ණේ ජනා යථා රෝධස්‍යුත්තෝල්‍ය සමුපවිශ්‍ය ප්‍රශස්තමීනාන් සංග්‍රහ්‍ය භාජනේෂු නිදධතේ, කුත්සිතාන් නික්‍ෂිපන්ති; ");
INSERT INTO sansin_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","තථෛව ජගතඃ ශේෂේ භවිෂ්‍යති, ඵලතඃ ස්වර්ගීයදූතා ආගත්‍ය පුණ්‍යවජ්ජනානාං මධ්‍යාත් පාපිනඃ පෘථක් කෘත්වා වහ්නිකුණ්ඩේ නික්‍ෂේප්ස්‍යන්ති, ");
INSERT INTO sansin_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","තත්‍ර රෝදනං දන්තෛ ර්දන්තඝර්ෂණඤ්ච භවිෂ්‍යතඃ| ");
INSERT INTO sansin_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","යීශුනා තේ පෘෂ්ටා යුෂ්මාභිඃ කිමේතාන්‍යාඛ්‍යානාන්‍යබුධ්‍යන්ත? තදා තේ ප්‍රත්‍යවදන්, සත්‍යං ප්‍රභෝ| ");
INSERT INTO sansin_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","තදානීං ස කථිතවාන්, නිජභාණ්ඩාගාරාත් නවීනපුරාතනානි වස්තූනි නිර්ගමයති යෝ ගෘහස්ථඃ ස ඉව ස්වර්ගරාජ්‍යමධි ශික්‍ෂිතාඃ ස්වර්ව උපදේෂ්ටාරඃ| ");
INSERT INTO sansin_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","අනන්තරං යීශුරේතාඃ සර්ව්වා දෘෂ්ටාන්තකථාඃ සමාප්‍ය තස්මාත් ස්ථානාත් ප්‍රතස්ථේ| අපරං ස්වදේශමාගත්‍ය ජනාන් භජනභවන උපදිෂ්ටවාන්; ");
INSERT INTO sansin_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","තේ විස්මයං ගත්වා කථිතවන්ත ඒතස්‍යෛතාදෘශං ඥානම් ආශ්චර‍්‍ය්‍යං කර්ම්ම ච කස්මාද් අජායත? ");
INSERT INTO sansin_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","කිමයං සූත්‍රධාරස්‍ය පුත්‍රෝ නහි? ඒතස්‍ය මාතු ර්නාම ච කිං මරියම් නහි? යාකුබ්-යූෂඵ්-ශිමෝන්-යිහූදාශ්ච කිමේතස්‍ය භ්‍රාතරෝ නහි? ");
INSERT INTO sansin_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ඒතස්‍ය භගින්‍යශ්ච කිමස්මාකං මධ්‍යේ න සන්ති? තර්හි කස්මාදයමේතානි ලබ්ධවාන්? ඉත්ථං ස තේෂාං විඝ්නරූපෝ බභූව; ");
INSERT INTO sansin_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","තතෝ යීශුනා නිගදිතං ස්වදේශීයජනානාං මධ්‍යං විනා භවිෂ්‍යද්වාදී කුත්‍රාප්‍යන්‍යත්‍ර නාසම්මාන්‍යෝ භවතී| ");
INSERT INTO sansin_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","තේෂාමවිශ්වාසහේතෝඃ ස තත්‍ර ස්ථානේ බහ්වාශ්චර‍්‍ය්‍යකර්ම්මාණි න කෘතවාන්| ");
INSERT INTO sansin_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","තදානීං රාජා හේරෝද් යීශෝ ර‍්‍යශඃ ශ්‍රුත්වා නිජදාසේයාන් ජගාද්, ");
INSERT INTO sansin_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ඒෂ මජ්ජයිතා යෝහන්, ප්‍රමිතේභයස්තස්‍යෝත්ථානාත් තේනේත්ථමද්භුතං කර්ම්ම ප්‍රකාශ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","පුරා හේරෝද් නිජභ්‍රාතු: ඵිලිපෝ ජායායා හේරෝදීයායා අනුරෝධාද් යෝහනං ධාරයිත්වා බද්ධා කාරායාං ස්ථාපිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","යතෝ යෝහන් උක්තවාන්, ඒත්සයාඃ සංග්‍රහෝ භවතෝ නෝචිතඃ| ");
INSERT INTO sansin_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","තස්මාත් නෘපතිස්තං හන්තුමිච්ඡන්නපි ලෝකේභ්‍යෝ විභයාඤ්චකාර; යතඃ සර්ව්වේ යෝහනං භවිෂ්‍යද්වාදිනං මේනිරේ| ");
INSERT INTO sansin_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","කින්තු හේරෝදෝ ජන්මාහීයමහ උපස්ථිතේ හේරෝදීයායා දුහිතා තේෂාං සමක්‍ෂං නෘතිත්වා හේරෝදමප්‍රීණ්‍යත්| ");
INSERT INTO sansin_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","තස්මාත් භූපතිඃ ශපථං කුර්ව්වන් ඉති ප්‍රත්‍යඥාසීත්, ත්වයා යද් යාච්‍යතේ, තදේවාහං දාස්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","සා කුමාරී ස්වීයමාතුඃ ශික්‍ෂාං ලබ්ධා බභාෂේ, මජ්ජයිතුර‍්‍යෝහන උත්තමාඞ්ගං භාජනේ සමානීය මහ්‍යං විශ්‍රාණය| ");
INSERT INTO sansin_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","තතෝ රාජා ශුශෝච, කින්තු භෝජනායෝපවිශතාං සඞ්ගිනාං ස්වකෘතශපථස්‍ය චානුරෝධාත් තත් ප්‍රදාතුම ආදිදේශ| ");
INSERT INTO sansin_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","පශ්චාත් කාරාං ප්‍රති නරං ප්‍රහිත්‍ය යෝහන උත්තමාඞ්ගං ඡිත්ත්වා ");
INSERT INTO sansin_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","තත් භාජන ආනාය්‍ය තස්‍යෛ කුමාර‍්‍ය්‍යෛ ව්‍යශ්‍රාණයත්, තතඃ සා ස්වජනන්‍යාඃ සමීපං තන්නිනාය| ");
INSERT INTO sansin_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","පශ්චාත් යෝහනඃ ශිෂ්‍යා ආගත්‍ය කායං නීත්වා ශ්මශානේ ස්ථාපයාමාසුස්තතෝ යීශෝඃ සන්නිධිං ව්‍රජිත්වා තද්වාර්ත්තාං බභාෂිරේ| ");
INSERT INTO sansin_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","අනන්තරං යීශුරිති නිශභ්‍ය නාවා නිර්ජනස්ථානම් ඒකාකී ගතවාන්, පශ්චාත් මානවාස්තත් ශ්‍රුත්වා නානානගරේභ්‍ය ආගත්‍ය පදෛස්තත්පශ්චාද් ඊයුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","තදානීං යීශු ර්බහිරාගත්‍ය මහාන්තං ජනනිවහං නිරීක්‍ෂ්‍ය තේෂු කාරුණිකඃ මන් තේෂාං පීඩිතජනාන් නිරාමයාන් චකාර| ");
INSERT INTO sansin_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","තතඃ පරං සන්ධ්‍යායාං ශිෂ්‍යාස්තදන්තිකමාගත්‍ය කථයාඤ්චක්‍රුඃ, ඉදං නිර්ජනස්ථානං වේලාප්‍යවසන්නා; තස්මාත් මනුජාන් ස්වස්වග්‍රාමං ගන්තුං ස්වාර්ථං භක්‍ෂ්‍යාණි ක්‍රේතුඤ්ච භවාන් තාන් විසෘජතු| ");
INSERT INTO sansin_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","කින්තු යීශුස්තානවාදීත්, තේෂාං ගමනේ ප්‍රයෝජනං නාස්ති, යූයමේව තාන් භෝජයත| ");
INSERT INTO sansin_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","තදා තේ ප්‍රත්‍යවදන්, අස්මාකමත්‍ර පූපපඤ්චකං මීනද්වයඤ්චාස්තේ| ");
INSERT INTO sansin_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","තදානීං තේනෝක්තං තානි මදන්තිකමානයත| ");
INSERT INTO sansin_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","අනන්තරං ස මනුජාන් යවසෝපර‍්‍ය්‍යුපවේෂ්ටුම් ආඥාපයාමාස; අපර තත් පූපපඤ්චකං මීනද්වයඤ්ච ගෘහ්ලන් ස්වර්ගං ප්‍රති නිරීක්‍ෂ්‍යේශ්වරීයගුණාන් අනූද්‍ය භංක්ත්වා ශිෂ්‍යේභ්‍යෝ දත්තවාන්, ශිෂ්‍යාශ්ච ලෝකේභ්‍යෝ දදුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","තතඃ සර්ව්වේ භුක්ත්වා පරිතෘප්තවන්තඃ, තතස්තදවශිෂ්ටභක්‍ෂ්‍යෛඃ පූර්ණාන් ද්වාදශඩලකාන් ගෘහීතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","තේ භෝක්තාරඃ ස්ත්‍රීර්බාලකාංශ්ච විහාය ප්‍රායේණ පඤ්ච සහස්‍රාණි පුමාංස ආසන්| ");
INSERT INTO sansin_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","තදනන්තරං යීශු ර්ලෝකානාං විසර්ජනකාලේ ශිෂ්‍යාන් තරණිමාරෝඪුං ස්වාග්‍රේ පාරං යාතුඤ්ච ගාඪමාදිෂ්ටවාන්| ");
INSERT INTO sansin_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","තතෝ ලෝකේෂු විසෘෂ්ටේෂු ස විවික්තේ ප්‍රාර්ථයිතුං ගිරිමේකං ගත්වා සන්ධ්‍යාං යාවත් තත්‍රෛකාකී ස්ථිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","කින්තු තදානීං සම්මුඛවාතත්වාත් සරිත්පතේ ර්මධ්‍යේ තරඞ්ගෛස්තරණිර්දෝලායමානාභවත්| ");
INSERT INTO sansin_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","තදා ස යාමින්‍යාශ්චතුර්ථප්‍රහරේ පද්භ්‍යාං ව්‍රජන් තේෂාමන්තිකං ගතවාන්| ");
INSERT INTO sansin_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","කින්තු ශිෂ්‍යාස්තං සාගරෝපරි ව්‍රජන්තං විලෝක්‍ය සමුද්විග්නා ජගදුඃ, ඒෂ භූත ඉති ශඞ්කමානා උච්චෛඃ ශබ්දායාඤ්චක්‍රිරේ ච| ");
INSERT INTO sansin_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","තදෛව යීශුස්තානවදත්, සුස්ථිරා භවත, මා භෛෂ්ට, ඒෂෝ(අ)හම්| ");
INSERT INTO sansin_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","තතඃ පිතර ඉත්‍යුක්තවාන්, හේ ප්‍රභෝ, යදි භවානේව, තර්හි මාං භවත්සමීපං යාතුමාඥාපයතු| ");
INSERT INTO sansin_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","තතඃ තේනාදිෂ්ටඃ පිතරස්තරණිතෝ(අ)වරුහ්‍ය යීශේाරන්තිකං ප්‍රාප්තුං තෝයෝපරි වව්‍රාජ| ");
INSERT INTO sansin_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","කින්තු ප්‍රචණ්ඩං පවනං විලෝක්‍ය භයාත් තෝයේ මංක්තුම් ආරේභේ, තස්මාද් උච්චෛඃ ශබ්දායමානඃ කථිතවාන්, හේ ප්‍රභෝ, මාමවතු| ");
INSERT INTO sansin_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","යීශුස්තත්ක්‍ෂණාත් කරං ප්‍රසාර‍්‍ය්‍ය තං ධරන් උක්තවාන්, හ ස්තෝකප්‍රත්‍යයින් ත්වං කුතඃ සමශේථාඃ? ");
INSERT INTO sansin_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","අනන්තරං තයෝස්තරණිමාරූඪයෝඃ පවනෝ නිවවෘතේ| ");
INSERT INTO sansin_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","තදානීං යේ තරණ්‍යාමාසන්, ත ආගත්‍ය තං ප්‍රණභ්‍ය කථිතවන්තඃ, යථාර්ථස්ත්වමේවේශ්වරසුතඃ| ");
INSERT INTO sansin_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","අනන්තරං පාරං ප්‍රාප්‍ය තේ ගිනේෂරන්නාමකං නගරමුපතස්ථුඃ, ");
INSERT INTO sansin_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","තදා තත්‍රත්‍යා ජනා යීශුං පරිචීය තද්දේශ්ස්‍ය චතුර්දිශෝ වාර්ත්තාං ප්‍රහිත්‍ය යත්‍ර යාවන්තඃ පීඩිතා ආසන්, තාවතඒව තදන්තිකමානයාමාසුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","අපරං තදීයවසනස්‍ය ග්‍රන්ථිමාත්‍රං ස්ප්‍රෂ්ටුං විනීය යාවන්තෝ ජනාස්තත් ස්පර්ශං චක්‍රිරේ, තේ සර්ව්වඒව නිරාමයා බභූවුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","අපරං යිරූශාලම්නගරීයාඃ කතිපයා අධ්‍යාපකාඃ ඵිරූශිනශ්ච යීශෝඃ සමීපමාගත්‍ය කථයාමාසුඃ, ");
INSERT INTO sansin_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","තව ශිෂ්‍යාඃ කිමර්ථම් අප්‍රක්‍ෂාලිතකරෛ ර්භක්‍ෂිත්වා පරම්පරාගතං ප්‍රාචීනානාං ව්‍යවහාරං ලඞ්වන්තේ? ");
INSERT INTO sansin_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","තතෝ යීශුඃ ප්‍රත්‍යුවාච, යූයං පරම්පරාගතාචාරේණ කුත ඊශ්වරාඥාං ලඞ්වධ්වේ| ");
INSERT INTO sansin_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ඊශ්වර ඉත්‍යාඥාපයත්, ත්වං නිජපිතරෞ සංමන්‍යේථාඃ, යේන ච නිජපිතරෞ නින්ද්‍යේතේ, ස නිශ්චිතං ම්‍රියේත; ");
INSERT INTO sansin_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","කින්තු යූයං වදථ, යඃ ස්වජනකං ස්වජනනීං වා වාක්‍යමිදං වදති, යුවාං මත්තෝ යල්ලභේථේ, තත් න්‍යවිද්‍යත, ");
INSERT INTO sansin_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ස නිජපිතරෞ පුන ර්න සංමංස්‍යතේ| ඉත්ථං යූයං පරම්පරාගතේන ස්වේෂාමාචාරේණේශ්වරීයාඥාං ලුම්පථ| ");
INSERT INTO sansin_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","රේ කපටිනඃ සර්ව්වේ යිශයියෝ යුෂ්මානධි භවිෂ්‍යද්වචනාන්‍යේතානි සම්‍යග් උක්තවාන්| ");
INSERT INTO sansin_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","වදනෛ ර්මනුජා ඒතේ සමායාන්ති මදන්තිකං| තථාධරෛ ර්මදීයඤ්ච මානං කුර්ව්වන්ති තේ නරාඃ| ");
INSERT INTO sansin_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","කින්තු තේෂාං මනෝ මත්තෝ විදූරඒව තිෂ්ඨති| ශික්‍ෂයන්තෝ විධීන් න්‍රාඥා භජන්තේ මාං මුධෛව තේ| ");
INSERT INTO sansin_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","තතෝ යීශු ර්ලෝකාන් ආහූය ප්‍රෝක්තවාන්, යූයං ශ්‍රුත්වා බුධ්‍යධ්බං| ");
INSERT INTO sansin_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","යන්මුඛං ප්‍රවිශති, තත් මනුජම් අමේධ්‍යං න කරෝති, කින්තු යදාස්‍යාත් නිර්ගච්ඡති, තදේව මානුෂමමේධ්‍යී කරෝතී| ");
INSERT INTO sansin_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","තදානීං ශිෂ්‍යා ආගත්‍ය තස්මෛ කථයාඤ්චක්‍රුඃ, ඒතාං කථාං ශ්‍රුත්වා ඵිරූශිනෝ ව්‍යරජ්‍යන්ත, තත් කිං භවතා ඥායතේ? ");
INSERT INTO sansin_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ස ප්‍රත්‍යවදත්, මම ස්වර්ගස්ථඃ පිතා යං කඤ්චිදඞ්කුරං නාරෝපයත්, ස උත්පාව්ද්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","තේ තිෂ්ඨන්තු, තේ අන්ධමනුජානාම් අන්ධමාර්ගදර්ශකා ඒව; යද්‍යන්ධෝ(අ)න්ධං පන්ථානං දර්ශයති, තර්හ්‍යුභෞ ගර්ත්තේ පතතඃ| ");
INSERT INTO sansin_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","තදා පිතරස්තං ප්‍රත්‍යවදත්, දෘෂ්ටාන්තමිමමස්මාන් බෝධයතු| ");
INSERT INTO sansin_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","යීශුනා ප්‍රෝක්තං, යූයමද්‍ය යාවත් කිමබෝධාඃ ස්ථ? ");
INSERT INTO sansin_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","කථාමිමාං කිං න බුධ්‍යධ්බේ ? යදාස්‍යං ප්‍රේවිශති, තද් උදරේ පතන් බහිර්නිර‍්‍යාති, ");
INSERT INTO sansin_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","කින්ත්වාස්‍යාද් යන්නිර‍්‍යාති, තද් අන්තඃකරණාත් නිර‍්‍යාතත්වාත් මනුජමමේධ්‍යං කරෝති| ");
INSERT INTO sansin_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","යතෝ(අ)න්තඃකරණාත් කුචින්තා බධඃ පාරදාරිකතා වේශ්‍යාගමනං චෛර‍්‍ය්‍යං මිථ්‍යාසාක්‍ෂ්‍යම් ඊශ්වරනින්දා චෛතානි සර්ව්වාණි නිර‍්‍ය්‍යාන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ඒතානි මනුෂ්‍යමපවිත්‍රී කුර්ව්වන්ති කින්ත්වප්‍රක්‍ෂාලිතකරේණ භෝජනං මනුජමමේධ්‍යං න කරෝති| ");
INSERT INTO sansin_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","අනන්තරං යීශුස්තස්මාත් ස්ථානාත් ප්‍රස්ථාය සෝරසීදෝන්නගරයෝඃ සීමාමුපතස්‍යෞ| ");
INSERT INTO sansin_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","තදා තත්සීමාතඃ කාචිත් කිනානීයා යෝෂිද් ආගත්‍ය තමුච්චෛරුවාච, හේ ප්‍රභෝ දායූදඃ සන්තාන, මමෛකා දුහිතාස්තේ සා භූතග්‍රස්තා සතී මහාක්ලේශං ප්‍රාප්නෝති මම දයස්ව| ");
INSERT INTO sansin_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","කින්තු යීශුස්තාං කිමපි නෝක්තවාන්, තතඃ ශිෂ්‍යා ආගත්‍ය තං නිවේදයාමාසුඃ, ඒෂා යෝෂිද් අස්මාකං පශ්චාද් උච්චෛරාහූයාගච්ඡති, ඒනාං විසෘජතු| ");
INSERT INTO sansin_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","තදා ස ප්‍රත්‍යවදත්, ඉස්‍රායේල්ගෝත්‍රස්‍ය හාරිතමේෂාන් විනා කස්‍යාප්‍යන්‍යස්‍ය සමීපං නාහං ප්‍රේෂිතෝස්මි| ");
INSERT INTO sansin_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","තතඃ සා නාරීසමාගත්‍ය තං ප්‍රණම්‍ය ජගාද, හේ ප්‍රභෝ මාමුපකුරු| ");
INSERT INTO sansin_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ස උක්තවාන්, බාලකානාං භක්‍ෂ්‍යමාදාය සාරමේයේභ්‍යෝ දානං නෝචිතං| ");
INSERT INTO sansin_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","තදා සා බභාෂේ, හේ ප්‍රභෝ, තත් සත්‍යං, තථාපි ප්‍රභෝ ර්භඤ්චාද් යදුච්ඡිෂ්ටං පතති, තත් සාරමේයාඃ ඛාදන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","තතෝ යීශුඃ ප්‍රත්‍යවදත්, හේ යෝෂිත්, තව විශ්වාසෝ මහාන් තස්මාත් තව මනෝභිලෂිතං සිද්‍ය්‍යතු, තේන තස්‍යාඃ කන්‍යා තස්මින්නේව දණ්ඩේ නිරාමයාභවත්| ");
INSERT INTO sansin_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","අනන්තරං යීශස්තස්මාත් ස්ථානාත් ප්‍රස්ථාය ගාලීල්සාගරස්‍ය සන්නිධිමාගත්‍ය ධරාධරමාරුහ්‍ය තත්‍රෝපවිවේශ| ");
INSERT INTO sansin_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","පශ්චාත් ජනනිවහෝ බහූන් ඛඤ්චාන්ධමූකශුෂ්කකරමානුෂාන් ආදාය යීශෝඃ සමීපමාගත්‍ය තච්චරණාන්තිකේ ස්ථාපයාමාසුඃ, තතඃ සා තාන් නිරාමයාන් අකරෝත්| ");
INSERT INTO sansin_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ඉත්ථං මූකා වාක්‍යං වදන්ති, ශුෂ්කකරාඃ ස්වාස්ථ්‍යමායාන්ති, පඞ්ගවෝ ගච්ඡන්ති, අන්ධා වීක්‍ෂන්තේ, ඉති විලෝක්‍ය ලෝකා විස්මයං මන්‍යමානා ඉස්‍රායේල ඊශ්වරං ධන්‍යං බභාෂිරේ| ");
INSERT INTO sansin_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","තදානීං යීශුඃ ස්වශිෂ්‍යාන් ආහූය ගදිතවාන්, ඒතජ්ජනනිවහේෂු මම දයා ජායතේ, ඒතේ දිනත්‍රයං මයා සාකං සන්ති, ඒෂාං භක්‍ෂ්‍යවස්තු ච කඤ්චිදපි නාස්ති, තස්මාදහමේතානකෘතාහාරාන් න විස්‍රක්‍ෂ්‍යාමි, තථාත්වේ වර්ත්මමධ්‍යේ ක්ලාම්‍යේෂුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","තදා ශිෂ්‍යා ඌචුඃ, ඒතස්මින් ප්‍රාන්තරමධ්‍ය ඒතාවතෝ මර්ත්‍යාන් තර්පයිතුං වයං කුත්‍ර පූපාන් ප්‍රාප්ස්‍යාමඃ? ");
INSERT INTO sansin_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","යීශුරපෘච්ඡත්, යුෂ්මාකං නිකටේ කති පූපා ආසතේ? ත ඌචුඃ, සප්තපූපා අල්පාඃ ක්‍ෂුද්‍රමීනාශ්ච සන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","තදානීං ස ලෝකනිවහං භූමාවුපවේෂ්ටුම් ආදිශ්‍ය ");
INSERT INTO sansin_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","තාන් සප්තපූපාන් මීනාංශ්ච ගෘහ්ලන් ඊශ්වරීයගුණාන් අනූද්‍ය භංක්ත්වා ශිෂ්‍යේභ්‍යෝ දදෞ, ශිෂ්‍යා ලෝකේභ්‍යෝ දදුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","තතඃ සර්ව්වේ භුක්ත්වා තෘප්තවන්තඃ; තදවශිෂ්ටභක්‍ෂ්‍යේණ සප්තඩලකාන් පරිපූර‍්‍ය්‍ය සංජගෘහුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","තේ භෝක්තාරෝ යෝෂිතෝ බාලකාංශ්ච විහාය ප්‍රායේණ චතුඃසහස්‍රාණි පුරුෂා ආසන්| ");
INSERT INTO sansin_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","තතඃ පරං ස ජනනිවහං විසෘජ්‍ය තරිමාරුහ්‍ය මග්දලාප්‍රදේශං ගතවාන්| ");
INSERT INTO sansin_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","තදානීං ඵිරූශිනඃ සිදූකිනශ්චාගත්‍ය තං පරීක්‍ෂිතුං නභමීයං කිඤ්චන ලක්‍ෂ්ම දර්ශයිතුං තස්මෛ නිවේදයාමාසුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","තතඃ ස උක්තවාන්, සන්ධ්‍යායාං නභසෝ රක්තත්වාද් යූයං වදථ, ශ්වෝ නිර්ම්මලං දිනං භවිෂ්‍යති; ");
INSERT INTO sansin_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ප්‍රාතඃකාලේ ච නභසෝ රක්තත්වාත් මලිනත්වාඤ්ච වදථ, ඣඤ්භ්ශද්‍ය භවිෂ්‍යති| හේ කපටිනෝ යදි යූයම් අන්තරීක්‍ෂස්‍ය ලක්‍ෂ්ම බෝද්ධුං ශක්නුථ, තර්හි කාලස්‍යෛතස්‍ය ලක්‍ෂ්ම කථං බෝද්ධුං න ශක්නුථ? ");
INSERT INTO sansin_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ඒතත්කාලස්‍ය දුෂ්ටෝ ව්‍යභිචාරී ච වංශෝ ලක්‍ෂ්ම ගවේෂයති, කින්තු යූනසෝ භවිෂ්‍යද්වාදිනෝ ලක්‍ෂ්ම විනාන්‍යත් කිමපි ලක්‍ෂ්ම තාන් න දර්ශයිය්‍යතේ| තදානීං ස තාන් විහාය ප්‍රතස්ථේ| ");
INSERT INTO sansin_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","අනන්තරමන්‍යපාරගමනකාලේ තස්‍ය ශිෂ්‍යාඃ පූපමානේතුං විස්මෘතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","යීශුස්තානවාදීත්, යූයං ඵිරූශිනාං සිදූකිනාඤ්ච කිණ්වං ප්‍රති සාවධානාඃ සතර්කාශ්ච භවත| ");
INSERT INTO sansin_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","තේන තේ පරස්පරං විවිච්‍ය කථයිතුමාරේභිරේ, වයං පූපානානේතුං විස්මෘතවන්ත ඒතත්කාරණාද් ඉති කථයති| ");
INSERT INTO sansin_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","කින්තු යීශුස්තද්විඥාය තානවෝචත්, හේ ස්තෝකවිශ්වාසිනෝ යූයං පූපානානයනමධි කුතඃ පරස්පරමේතද් විවිංක්‍ය? ");
INSERT INTO sansin_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","යුෂ්මාභිඃ කිමද්‍යාපි න ඥායතේ? පඤ්චභිඃ පූපෛඃ පඤ්චසහස්‍රපුරුෂේෂු භෝජිතේෂු භක්‍ෂ්‍යෝච්ඡිෂ්ටපූර්ණාන් කති ඩලකාන් සමගෘහ්ලීතං; ");
INSERT INTO sansin_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","තථා සප්තභිඃ පූපෛශ්චතුඃසහස්‍රපුරුෂේෂු භේජිතේෂු කති ඩලකාන් සමගෘහ්ලීත, තත් කිං යුෂ්මාභිර්න ස්මර‍්‍ය්‍යතේ? ");
INSERT INTO sansin_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","තස්මාත් ඵිරූශිනාං සිදූකිනාඤ්ච කිණ්වං ප්‍රති සාවධානාස්තිෂ්ඨත, කථාමිමාම් අහං පූපානධි නාකථයං, ඒතද් යූයං කුතෝ න බුධ්‍යධ්වේ? ");
INSERT INTO sansin_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","තදානීං පූපකිණ්වං ප්‍රති සාවධානාස්තිෂ්ඨතේති නෝක්ත්වා ඵිරූශිනාං සිදූකිනාඤ්ච උපදේශං ප්‍රති සාවධානාස්තිෂ්ඨතේති කථිතවාන්, ඉති තෛරබෝධි| ");
INSERT INTO sansin_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","අපරඤ්ච යීශුඃ කෛසරියා-ඵිලිපිප්‍රදේශමාගත්‍ය ශිෂ්‍යාන් අපෘච්ඡත්, යෝ(අ)හං මනුජසුතඃ සෝ(අ)හං කඃ? ලෝකෛරහං කිමුච්‍යේ? ");
INSERT INTO sansin_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","තදානීං තේ කථිතවන්තඃ, කේචිද් වදන්ති ත්වං මජ්ජයිතා යෝහන්, කේචිද්වදන්ති, ත්වම් ඒලියඃ, කේචිච්ච වදන්ති, ත්වං යිරිමියෝ වා කශ්චිද් භවිෂ්‍යද්වාදීති| ");
INSERT INTO sansin_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","පශ්චාත් ස තාන් පප්‍රච්ඡ, යූයං මාං කං වදථ? තතඃ ශිමෝන් පිතර උවාච, ");
INSERT INTO sansin_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ත්වමමරේශ්වරස්‍යාභිෂික්තපුත්‍රඃ| ");
INSERT INTO sansin_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","තතෝ යීශුඃ කථිතවාන්, හේ යූනසඃ පුත්‍ර ශිමෝන් ත්වං ධන්‍යඃ; යතඃ කෝපි අනුජස්ත්වය්‍යේතජ්ඥානං නෝදපාදයත්, කින්තු මම ස්වර්ගස්‍යඃ පිතෝදපාදයත්| ");
INSERT INTO sansin_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","අතෝ(අ)හං ත්වාං වදාමි, ත්වං පිතරඃ (ප්‍රස්තරඃ) අහඤ්ච තස්‍ය ප්‍රස්තරස්‍යෝපරි ස්වමණ්ඩලීං නිර්ම්මාස්‍යාමි, තේන නිරයෝ බලාත් තාං පරාජේතුං න ශක්‍ෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","අහං තුභ්‍යං ස්වර්ගීයරාජ්‍යස්‍ය කුඤ්ජිකාං දාස්‍යාමි, තේන යත් කිඤ්චන ත්වං පෘථිව්‍යාං භංත්ස්‍යසි තත්ස්වර්ගේ භංත්ස්‍යතේ, යච්ච කිඤ්චන මහ්‍යාං මෝක්‍ෂ්‍යසි තත් ස්වර්ගේ මෝක්‍ෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","පශ්චාත් ස ශිෂ්‍යානාදිශත්, අහමභිෂික්තෝ යීශුරිති කථාං කස්මෛචිදපි යූයං මා කථයත| ");
INSERT INTO sansin_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","අන්‍යඤ්ච යිරූශාලම්නගරං ගත්වා ප්‍රාචීනලෝකේභ්‍යඃ ප්‍රධානයාජකේභ්‍ය උපාධ්‍යායේභ්‍යශ්ච බහුදුඃඛභෝගස්තෛ ර්හතත්වං තෘතීයදිනේ පුනරුත්ථානඤ්ච මමාවශ්‍යකම් ඒතාඃ කථා යීශුස්තත්කාලමාරභ්‍ය ශිෂ්‍යාන් ඥාපයිතුම් ආරබ්ධවාන්| ");
INSERT INTO sansin_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","තදානීං පිතරස්තස්‍ය කරං ඝෘත්වා තර්ජයිත්වා කථයිතුමාරබ්ධවාන්, හේ ප්‍රභෝ, තත් ත්වත්තෝ දූරං යාතු, ත්වාං ප්‍රති කදාපි න ඝටිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","කින්තු ස වදනං පරාවර්ත්‍ය පිතරං ජගාද, හේ විඝ්නකාරින්, මත්සම්මුඛාද් දූරීභව, ත්වං මාං බාධසේ, ඊශ්වරීයකාර‍්‍ය්‍යාත් මානුෂීයකාර‍්‍ය්‍යං තුභ්‍යං රෝචතේ| ");
INSERT INTO sansin_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","අනන්තරං යීශුඃ ස්වීයශිෂ්‍යාන් උක්තවාන් යඃ කශ්චිත් මම පශ්චාද්ගාමී භවිතුම් ඉච්ඡති, ස ස්වං දාම්‍යතු, තථා ස්වක්‍රුශං ගෘහ්ලන් මත්පශ්චාදායාතු| ");
INSERT INTO sansin_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","යතෝ යඃ ප්‍රාණාන් රක්‍ෂිතුමිච්ඡති, ස තාන් හාරයිෂ්‍යති, කින්තු යෝ මදර්ථං නිජප්‍රාණාන් හාරයති, ස තාන් ප්‍රාප්ස්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","මානුෂෝ යදි සර්ව්වං ජගත් ලභතේ නිජප්‍රණාන් හාරයති, තර්හි තස්‍ය කෝ ලාභඃ? මනුජෝ නිජප්‍රාණානාං විනිමයේන වා කිං දාතුං ශක්නෝති? ");
INSERT INTO sansin_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","මනුජසුතඃ ස්වදූතෛඃ සාකං පිතුඃ ප්‍රභාවේණාගමිෂ්‍යති; තදා ප්‍රතිමනුජං ස්වස්වකර්ම්මානුසාරාත් ඵලං දාස්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","අහං යුෂ්මාන් තථ්‍යං වච්මි, සරාජ්‍යං මනුජසුතම් ආගතං න පශ්‍යන්තෝ මෘත්‍යුං න ස්වාදිෂ්‍යන්ති, ඒතාදෘශාඃ කතිපයජනා අත්‍රාපි දණ්ඩායමානාඃ සන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","අනන්තරං ෂඩ්දිනේභ්‍යඃ පරං යීශුඃ පිතරං යාකූබං තත්සහජං යෝහනඤ්ච ගෘහ්ලන් උච්චාද්‍රේ ර්විවික්තස්ථානම් ආගත්‍ය තේෂාං සමක්‍ෂං රූපමන්‍යත් දධාර| ");
INSERT INTO sansin_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","තේන තදාස්‍යං තේජස්වි, තදාභරණම් ආලෝකවත් පාණ්ඩරමභවත්| ");
INSERT INTO sansin_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","අන්‍යච්ච තේන සාකං සංලපන්තෞ මූසා ඒලියශ්ච තේභ්‍යෝ දර්ශනං දදතුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","තදානීං පිතරෝ යීශුං ජගාද, හේ ප්‍රභෝ ස්ථිතිරත්‍රාස්මාකං ශුභා, යදි භවතානුමන්‍යතේ, තර්හි භවදර්ථමේකං මූසාර්ථමේකම් ඒලියාර්ථඤ්චෛකම් ඉති ත්‍රීණි දූෂ්‍යාණි නිර්ම්මම| ");
INSERT INTO sansin_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ඒතත්කථනකාල ඒක උජ්ජවලඃ පයෝදස්තේෂාමුපරි ඡායාං කෘතවාන්, වාරිදාද් ඒෂා නභසීයා වාග් බභූව, මමායං ප්‍රියඃ පුත්‍රඃ, අස්මින් මම මහාසන්තෝෂ ඒතස්‍ය වාක්‍යං යූයං නිශාමයත| ");
INSERT INTO sansin_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","කින්තු වාචමේතාං ශෘණ්වන්තඒව ශිෂ්‍යා මෘශං ශඞ්කමානා න්‍යුබ්ජා න්‍යපතන්| ");
INSERT INTO sansin_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","තදා යීශුරාගත්‍ය තේෂාං ගාත්‍රාණි ස්පෘශන් උවාච, උත්තිෂ්ඨත, මා භෛෂ්ට| ");
INSERT INTO sansin_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","තදානීං නේත්‍රාණ්‍යුන්මීල්‍ය යීශුං විනා කමපි න දදෘශුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","තතඃ පරම් අද්‍රේරවරෝහණකාලේ යීශුස්තාන් ඉත්‍යාදිදේශ, මනුජසුතස්‍ය මෘතානාං මධ්‍යාදුත්ථානං යාවන්න ජායතේ, තාවත් යුෂ්මාභිරේතද්දර්ශනං කස්මෛචිදපි න කථයිතව්‍යං| ");
INSERT INTO sansin_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","තදා ශිෂ්‍යාස්තං පප්‍රච්ඡුඃ, ප්‍රථමම් ඒලිය ආයාස්‍යතීති කුත උපාධ්‍යායෛරුච්‍යතේ? ");
INSERT INTO sansin_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","තතෝ යීශුඃ ප්‍රත්‍යවාදීත්, ඒලියඃ ප්‍රාගේත්‍ය සර්ව්වාණි සාධයිෂ්‍යතීති සත්‍යං, ");
INSERT INTO sansin_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","කින්ත්වහං යුෂ්මාන් වච්මි, ඒලිය ඒත්‍ය ගතඃ, තේ තමපරිචිත්‍ය තස්මින් යථේච්ඡං ව්‍යවජහුඃ; මනුජසුතේනාපි තේෂාමන්තිකේ තාදෘග් දුඃඛං භෝක්තව්‍යං| ");
INSERT INTO sansin_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","තදානීං ස මජ්ජයිතාරං යෝහනමධි කථාමේතාං ව්‍යාහෘතවාන්, ඉත්ථං තච්ඡිෂ්‍යා බුබුධිරේ| ");
INSERT INTO sansin_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","පශ්චාත් තේෂු ජනනිවහස්‍යාන්තිකමාගතේෂු කශ්චිත් මනුජස්තදන්තිකමේත්‍ය ජානූනී පාතයිත්වා කථිතවාන්, ");
INSERT INTO sansin_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","හේ ප්‍රභෝ, මත්පුත්‍රං ප්‍රති කෘපාං විදධාතු, සෝපස්මාරාමයේන භෘශං ව්‍යථිතඃ සන් පුනඃ පුන ර්වහ්නෞ මුහු ර්ජලමධ්‍යේ පතති| ");
INSERT INTO sansin_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","තස්මාද් භවතඃ ශිෂ්‍යාණාං සමීපේ තමානයං කින්තු තේ තං ස්වාස්ථං කර්ත්තුං න ශක්තාඃ| ");
INSERT INTO sansin_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","තදා යීශුඃ කථිතවාන් රේ අවිශ්වාසිනඃ, රේ විපථගාමිනඃ, පුනඃ කතිකාලාන් අහං යුෂ්මාකං සන්නිධෞ ස්ථාස්‍යාමි? කතිකාලාන් වා යුෂ්මාන් සහිෂ්‍යේ? තමත්‍ර මමාන්තිකමානයත| ");
INSERT INTO sansin_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","පශ්චාද් යීශුනා තර්ජතඒව ස භූතස්තං විහාය ගතවාන්, තද්දණ්ඩඒව ස බාලකෝ නිරාමයෝ(අ)භූත්| ");
INSERT INTO sansin_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","තතඃ ශිෂ්‍යා ගුප්තං යීශුමුපාගත්‍ය බභාෂිරේ, කුතෝ වයං තං භූතං ත්‍යාජයිතුං න ශක්තාඃ? ");
INSERT INTO sansin_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","යීශුනා තේ ප්‍රෝක්තාඃ, යුෂ්මාකමප්‍රත්‍යයාත්; ");
INSERT INTO sansin_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","යුෂ්මානහං තථ්‍යං වච්මි යදි යුෂ්මාකං සර්ෂපෛකමාත්‍රෝපි විශ්වාසෝ ජායතේ, තර්හි යුෂ්මාභිරස්මින් ශෛලේ ත්වමිතඃ ස්ථානාත් තත් ස්ථානං යාහීති බ්‍රූතේ ස තදෛව චලිෂ්‍යති, යුෂ්මාකං කිමප්‍යසාධ්‍යඤ්ච කර්ම්ම න ස්ථාස්‍යාති| කින්තු ප්‍රාර්ථනෝපවාසෞ විනෛතාදෘශෝ භූතෝ න ත්‍යාජ්‍යේත| ");
INSERT INTO sansin_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","අපරං තේෂාං ගාලීල්ප්‍රදේශේ භ්‍රමණකාලේ යීශුනා තේ ගදිතාඃ, මනුජසුතෝ ජනානාං කරේෂු සමර්පයිෂ්‍යතේ තෛ ර්හනිෂ්‍යතේ ච, ");
INSERT INTO sansin_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","කින්තු තෘතීයේ(අ)හි्න ම උත්ථාපිෂ්‍යතේ, තේන තේ භෘශං දුඃඛිතා බභූවඃ| ");
INSERT INTO sansin_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","තදනන්තරං තේෂු කඵර්නාහූම්නගරමාගතේෂු කරසංග්‍රාහිණඃ පිතරාන්තිකමාගත්‍ය පප්‍රච්ඡුඃ, යුෂ්මාකං ගුරුඃ කිං මන්දිරාර්ථං කරං න දදාති? තතඃ පිතරඃ කථිතවාන් දදාති| ");
INSERT INTO sansin_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","තතස්තස්මින් ගෘහමධ්‍යමාගතේ තස්‍ය කථාකථනාත් පූර්ව්වමේව යීශුරුවාච, හේ ශිමෝන්, මේදින්‍යා රාජානඃ ස්වස්වාපත්‍යේභ්‍යඃ කිං විදේශිභ්‍යඃ කේභ්‍යඃ කරං ගෘහ්ලන්ති? අත්‍ර ත්වං කිං බුධ්‍යසේ? තතඃ පිතර උක්තවාන්, විදේශිභ්‍යඃ| ");
INSERT INTO sansin_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","තදා යීශුරුක්තවාන්, තර්හි සන්තානා මුක්තාඃ සන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","තථාපි යථාස්මාභිස්තේෂාමන්තරායෝ න ජන්‍යතේ, තත්කෘතේ ජලධේස්තීරං ගත්වා වඩිශං ක්‍ෂිප, තේනාදෞ යෝ මීන උත්ථාස්‍යති, තං ඝෘත්වා තන්මුඛේ මෝචිතේ තෝලකෛකං රූප්‍යං ප්‍රාප්ස්‍යසි, තද් ගෘහීත්වා තව මම ච කෘතේ තේභ්‍යෝ දේහි| ");
INSERT INTO sansin_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","තදානීං ශිෂ්‍යා යීශෝඃ සමීපමාගත්‍ය පෘෂ්ටවන්තඃ ස්වර්ගරාජ්‍යේ කඃ ශ්‍රේෂ්ඨඃ? ");
INSERT INTO sansin_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","තතෝ යීශුඃ ක්‍ෂුද්‍රමේකං බාලකං ස්වසමීපමානීය තේෂාං මධ්‍යේ නිධාය ජගාද, ");
INSERT INTO sansin_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","යුෂ්මානහං සත්‍යං බ්‍රවීමි, යූයං මනෝවිනිමයේන ක්‍ෂුද්‍රබාලවත් න සන්තඃ ස්වර්ගරාජ්‍යං ප්‍රවේෂ්ටුං න ශක්නුථ| ");
INSERT INTO sansin_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","යඃ කශ්චිද් ඒතස්‍ය ක්‍ෂුද්‍රබාලකස්‍ය සමමාත්මානං නම්‍රීකරෝති, සඒව ස්වර්ගරාජයේ ශ්‍රේෂ්ඨඃ| ");
INSERT INTO sansin_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","යඃ කශ්චිද් ඒතාදෘශං ක්‍ෂුද්‍රබාලකමේකං මම නාම්නි ගෘහ්ලාති, ස මාමේව ගෘහ්ලාති| ");
INSERT INTO sansin_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","කින්තු යෝ ජනෝ මයි කෘතවිශ්වාසානාමේතේෂාං ක්‍ෂුද්‍රප්‍රාණිනාම් ඒකස්‍යාපි විධ්නිං ජනයති, කණ්ඨබද්ධපේෂණීකස්‍ය තස්‍ය සාගරාගාධජලේ මජ්ජනං ශ්‍රේයඃ| ");
INSERT INTO sansin_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","විඝ්නාත් ජගතඃ සන්තාපෝ භවිෂ්‍යති, විඝ්නෝ(අ)වශ්‍යං ජනයිෂ්‍යතේ, කින්තු යේන මනුජේන විඝ්නෝ ජනිෂ්‍යතේ තස්‍යෛව සන්තාපෝ භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","තස්මාත් තව කරශ්චරණෝ වා යදි ත්වාං බාධතේ, තර්හි තං ඡිත්ත්වා නික්‍ෂිප, ද්විකරස්‍ය ද්විපදස්‍ය වා තවානප්තවහ්නෞ නික්‍ෂේපාත්, ඛඤ්ජස්‍ය වා ඡින්නහස්තස්‍ය තව ජීවනේ ප්‍රවේශෝ වරං| ");
INSERT INTO sansin_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","අපරං තව නේත්‍රං යදි ත්වාං බාධතේ, තර්හි තදප්‍යුත්පාව්‍ය නික්‍ෂිප, ද්විනේත්‍රස්‍ය නරකාග්නෞ නික්‍ෂේපාත් කාණස්‍ය තව ජීවනේ ප්‍රවේශෝ වරං| ");
INSERT INTO sansin_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","තස්මාදවධද්ධං, ඒතේෂාං ක්‍ෂුද්‍රප්‍රාණිනාම් ඒකමපි මා තුච්ඡීකුරුත, ");
INSERT INTO sansin_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","යතෝ යුෂ්මානහං තථ්‍යං බ්‍රවීමි, ස්වර්ගේ තේෂාං දූතා මම ස්වර්ගස්ථස්‍ය පිතුරාස්‍යං නිත්‍යං පශ්‍යන්ති| ඒවං යේ යේ හාරිතාස්තාන් රක්‍ෂිතුං මනුජපුත්‍ර ආගච්ඡත්| ");
INSERT INTO sansin_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","යූයමත්‍ර කිං විවිංග්ඝ්වේ? කස්‍යචිද් යදි ශතං මේෂාඃ සන්ති, තේෂාමේකෝ හාර‍්‍ය්‍යතේ ච, තර්හි ස ඒකෝනශතං මේෂාන් විහාය පර්ව්වතං ගත්වා තං හාරිතමේකං කිං න මෘගයතේ? ");
INSERT INTO sansin_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","යදි ච කදාචිත් තන්මේෂෝද්දේශං ලමතේ, තර්හි යුෂ්මානහං සත්‍යං කථයාමි, සෝ(අ)විපථගාමිභ්‍ය ඒකෝනශතමේෂේභ්‍යෝපි තදේකහේතෝරධිකම් ආහ්ලාදතේ| ");
INSERT INTO sansin_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","තද්වද් ඒතේෂාං ක්‍ෂුද්‍රප්‍රාඒिනාම් ඒකෝපි නශ්‍යතීති යුෂ්මාකං ස්වර්ගස්ථපිතු ර්නාභිමතම්| ");
INSERT INTO sansin_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","යද්‍යපි තව භ්‍රාතා ත්වයි කිමප්‍යපරාධ්‍යති, තර්හි ගත්වා යුවයෝර්ද්වයෝඃ ස්ථිතයෝස්තස්‍යාපරාධං තං ඥාපය| තත්‍ර ස යදි තව වාක්‍යං ශෘණෝති, තර්හි ත්වං ස්වභ්‍රාතරං ප්‍රාප්තවාන්, ");
INSERT INTO sansin_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","කින්තු යදි න ශෘණෝති, තර්හි ද්වාභ්‍යාං ත්‍රිභි ර්වා සාක්‍ෂීභිඃ සර්ව්වං වාක්‍යං යථා නිශ්චිතං ජායතේ, තදර්ථම් ඒකං ද්වෞ වා සාක්‍ෂිණෞ ගෘහීත්වා යාහි| ");
INSERT INTO sansin_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","තේන ස යදි තයෝ ර්වාක්‍යං න මාන්‍යතේ, තර්හි සමාජං තජ්ඥාපය, කින්තු යදි සමාජස්‍යාපි වාක්‍යං න මාන්‍යතේ,තර්හි ස තව සමීපේ දේවපූජකඉව චණ්ඩාලඉව ච භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","අහං යුෂ්මාන් සත්‍යං වදාමි, යුෂ්මාභිඃ පෘථිව්‍යාං යද් බධ්‍යතේ තත් ස්වර්ගේ භංත්ස්‍යතේ; මේදින්‍යාං යත් භෝච්‍යතේ, ස්වර්ගේ(අ)පි තත් මෝක්‍ෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","පුනරහං යුෂ්මාන් වදාමි, මේදින්‍යාං යුෂ්මාකං යදි ද්වාවේකවාක්‍යීභූය කිඤ්චිත් ප්‍රාර්ථයේතේ, තර්හි මම ස්වර්ගස්ථපිත්‍රා තත් තයෝඃ කෘතේ සම්පන්නං භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","යතෝ යත්‍ර ද්වෞ ත්‍රයෝ වා මම නාන්නි මිලන්ති, තත්‍රෛවාහං තේෂාං මධ්‍යේ(අ)ස්මි| ");
INSERT INTO sansin_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","තදානීං පිතරස්තත්සමීපමාගත්‍ය කථිතවාන් හේ ප්‍රභෝ, මම භ්‍රාතා මම යද්‍යපරාධ්‍යති, තර්හි තං කතිකෘත්වඃ ක්‍ෂමිෂ්‍යේ? ");
INSERT INTO sansin_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","කිං සප්තකෘත්වඃ? යීශුස්තං ජගාද, ත්වාං කේවලං සප්තකෘත්වෝ යාවත් න වදාමි, කින්තු සප්තත්‍යා ගුණිතං සප්තකෘත්වෝ යාවත්| ");
INSERT INTO sansin_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","අපරං නිජදාසෛඃ සහ ජිගණයිෂුඃ කශ්චිද් රාජේව ස්වර්ගරාජයං| ");
INSERT INTO sansin_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ආරබ්ධේ තස්මින් ගණනේ සාර්ද්ධසහස්‍රමුද්‍රාපූරිතානාං දශසහස්‍රපුටකානාම් ඒකෝ(අ)ඝමර්ණස්තත්සමක්‍ෂමානායි| ");
INSERT INTO sansin_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","තස්‍ය පරිශෝධනාය ද්‍රව්‍යාභාවාත් පරිශෝධනාර්ථං ස තදීයභාර‍්‍ය්‍යාපුත්‍රාදිසර්ව්වස්වඤ්ච වික්‍රීයතාමිති තත්ප්‍රභුරාදිදේශ| ");
INSERT INTO sansin_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","තේන ස දාසස්තස්‍ය පාදයෝඃ පතන් ප්‍රණම්‍ය කථිතවාන් , හේ ප්‍රභෝ භවතා ඝෛර‍්‍ය්‍යේ කෘතේ මයා සර්ව්වං පරිශෝධිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","තදානීං දාසස්‍ය ප්‍රභුඃ සකරුණඃ සන් සකලර්ණං ක්‍ෂමිත්වා තං තත්‍යාජ| ");
INSERT INTO sansin_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","කින්තු තස්මින් දාසේ බහි ර‍්‍යාතේ, තස්‍ය ශතං මුද්‍රාචතුර්ථාංශාන් යෝ ධාරයති, තං සහදාසං දෘෂ්ද්වා තස්‍ය කණ්ඨං නිෂ්පීඩ්‍ය ගදිතවාන්, මම යත් ප්‍රාප්‍යං තත් පරිශෝධය| ");
INSERT INTO sansin_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","තදා තස්‍ය සහදාසස්තත්පාදයෝඃ පතිත්වා විනීය බභාෂේ, ත්වයා ධෛර‍්‍ය්‍යේ කෘතේ මයා සර්ව්වං පරිශෝධිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","තථාපි ස තත් නාඞගීකෘත්‍ය යාවත් සර්ව්වමෘණං න පරිශෝධිතවාන් තාවත් තං කාරායාං ස්ථාපයාමාස| ");
INSERT INTO sansin_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","තදා තස්‍ය සහදාසාස්තස්‍යෛතාදෘග් ආචරණං විලෝක්‍ය ප්‍රභෝඃ සමීපං ගත්වා සර්ව්වං වෘත්තාන්තං නිවේදයාමාසුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","තදා තස්‍ය ප්‍රභුස්තමාහූය ජගාද, රේ දුෂ්ට දාස, ත්වයා මත්සන්නිධෞ ප්‍රාර්ථිතේ මයා තව සර්ව්වමෘණං ත්‍යක්තං; ");
INSERT INTO sansin_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","යථා චාහං ත්වයි කරුණාං කෘතවාන්, තථෛව ත්වත්සහදාසේ කරුණාකරණං කිං තව නෝචිතං? ");
INSERT INTO sansin_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ඉති කථයිත්වා තස්‍ය ප්‍රභුඃ ක්‍රුද්ධ්‍යන් නිජප්‍රාප්‍යං යාවත් ස න පරිශෝධිතවාන්, තාවත් ප්‍රහාරකානාං කරේෂු තං සමර්පිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","යදි යූයං ස්වාන්තඃකරණෛඃ ස්වස්වසහජානාම් අපරාධාන් න ක්‍ෂමධ්වේ, තර්හි මම ස්වර්ගස්‍යඃ පිතාපි යුෂ්මාන් ප්‍රතීත්ථං කරිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","අනන්තරම් ඒතාසු කථාසු සමාප්තාසු යීශු ර්ගාලීලප්‍රදේශාත් ප්‍රස්ථාය යර්දන්තීරස්ථං යිහූදාප්‍රදේශං ප්‍රාප්තඃ| ");
INSERT INTO sansin_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","තදා තත්පශ්චාත් ජනනිවහේ ගතේ ස තත්‍ර තාන් නිරාමයාන් අකරෝත්| ");
INSERT INTO sansin_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","තදනන්තරං ඵිරූශිනස්තත්සමීපමාගත්‍ය පාරීක්‍ෂිතුං තං පප්‍රච්ඡුඃ, කස්මාදපි කාරණාත් නරේණ ස්වජායා පරිත්‍යාජ්‍යා න වා? ");
INSERT INTO sansin_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ස ප්‍රත්‍යුවාච, ප්‍රථමම් ඊශ්වරෝ නරත්වේන නාරීත්වේන ච මනුජාන් සසර්ජ, තස්මාත් කථිතවාන්, ");
INSERT INTO sansin_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","මානුෂඃ ස්වපිතරෞ පරිත්‍යජ්‍ය ස්වපත්න්‍යාම් ආසක්‍ෂ්‍යතේ, තෞ ද්වෞ ජනාවේකාඞ්ගෞ භවිෂ්‍යතඃ, කිමේතද් යුෂ්මාභි ර්න පඨිතම්? ");
INSERT INTO sansin_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","අතස්තෞ පුන ර්න ද්වෞ තයෝරේකාඞ්ගත්වං ජාතං, ඊශ්වරේණ යච්ච සමයුජ්‍යත, මනුජෝ න තද් භින්ද්‍යාත්| ");
INSERT INTO sansin_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","තදානීං තේ තං ප්‍රත්‍යවදන්, තථාත්වේ ත්‍යාජ්‍යපත්‍රං දත්ත්වා ස්වාං ස්වාං ජායාං ත්‍යක්තුං ව්‍යවස්ථාං මූසාඃ කථං ලිලේඛ? ");
INSERT INTO sansin_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","තතඃ ස කථිතවාන්, යුෂ්මාකං මනසාං කාඨින්‍යාද් යුෂ්මාන් ස්වාං ස්වාං ජායාං ත්‍යක්තුම් අන්වමන්‍යත කින්තු ප්‍රථමාද් ඒෂෝ විධිර්නාසීත්| ");
INSERT INTO sansin_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","අතෝ යුෂ්මානහං වදාමි, ව්‍යභිචාරං විනා යෝ නිජජායාං ත්‍යජේත් අන්‍යාඤ්ච විවහේත්, ස පරදාරාන් ගච්ඡති; යශ්ච ත්‍යක්තාං නාරීං විවහති සෝපි පරදාරේෂු රමතේ| ");
INSERT INTO sansin_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","තදා තස්‍ය ශිෂ්‍යාස්තං බභාෂිරේ, යදි ස්වජායයා සාකං පුංස ඒතාදෘක් සම්බන්ධෝ ජායතේ, තර්හි විවහනමේව න භද්‍රං| ");
INSERT INTO sansin_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","තතඃ ස උක්තවාන්, යේභ්‍යස්තත්සාමර්ථ්‍යං ආදායි, තාන් විනාන්‍යඃ කෝපි මනුජ ඒතන්මතං ග්‍රහීතුං න ශක්නෝති| ");
INSERT INTO sansin_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","කතිපයා ජනනක්ලීබඃ කතිපයා නරකෘතක්ලීබඃ ස්වර්ගරාජ්‍යාය කතිපයාඃ ස්වකෘතක්ලීබාශ්ච සන්ති, යේ ග්‍රහීතුං ශක්නුවන්ති තේ ගෘහ්ලන්තු| ");
INSERT INTO sansin_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","අපරම් යථා ස ශිශූනාං ගාත්‍රේෂු හස්තං දත්වා ප්‍රාර්ථයතේ, තදර්ථං තත්සමීංපං ශිශව ආනීයන්ත, තත ආනයිතෘන් ශිෂ්‍යාස්තිරස්කෘතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","කින්තු යීශුරුවාච, ශිශවෝ මදන්තිකම් ආගච්ඡන්තු, තාන් මා වාරයත, ඒතාදෘශාං ශිශූනාමේව ස්වර්ගරාජ්‍යං| ");
INSERT INTO sansin_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","තතඃ ස තේෂාං ගාත්‍රේෂු හස්තං දත්වා තස්මාත් ස්ථානාත් ප්‍රතස්ථේ| ");
INSERT INTO sansin_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","අපරම් ඒක ආගත්‍ය තං පප්‍රච්ඡ, හේ පරමගුරෝ, අනන්තායුඃ ප්‍රාප්තුං මයා කිං කිං සත්කර්ම්ම කර්ත්තව්‍යං? ");
INSERT INTO sansin_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","තතඃ ස උවාච, මාං පරමං කුතෝ වදසි? විනේශ්චරං න කෝපි පරමඃ, කින්තු යද්‍යනන්තායුඃ ප්‍රාප්තුං වාඤ්ඡසි, තර්හ්‍යාඥාඃ පාලය| ");
INSERT INTO sansin_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","තදා ස පෘෂ්ටවාන්, කාඃ කා ආඥාඃ? තතෝ යීශුඃ කථිතවාන්, නරං මා හන්‍යාඃ, පරදාරාන් මා ගච්ඡේඃ, මා චෝරයේඃ, මෘෂාසාක්‍ෂ්‍යං මා දද්‍යාඃ, ");
INSERT INTO sansin_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","නිජපිතරෞ සංමන්‍යස්ව, ස්වසමීපවාසිනි ස්වවත් ප්‍රේම කුරු| ");
INSERT INTO sansin_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ස යුවා කථිතවාන්, ආ බාල්‍යාද් ඒතාඃ පාලයාමි, ඉදානීං කිං න්‍යූනමාස්තේ? ");
INSERT INTO sansin_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","තතෝ යීශුරවදත්, යදි සිද්ධෝ භවිතුං වාඤ්ඡසි, තර්හි ගත්වා නිජසර්ව්වස්වං වික්‍රීය දරිද්‍රේභ්‍යෝ විතර, තතඃ ස්වර්ගේ විත්තං ලප්ස්‍යසේ; ආගච්ඡ, මත්පශ්චාද්වර්ත්තී ච භව| ");
INSERT INTO sansin_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ඒතාං වාචං ශ්‍රුත්වා ස යුවා ස්වීයබහුසම්පත්තේ ර්විෂණඃ සන් චලිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","තදා යීශුඃ ස්වශිෂ්‍යාන් අවදත්, ධනිනාං ස්වර්ගරාජ්‍යප්‍රවේශෝ මහාදුෂ්කර ඉති යුෂ්මානහං තථ්‍යං වදාමි| ");
INSERT INTO sansin_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","පුනරපි යුෂ්මානහං වදාමි, ධනිනාං ස්වර්ගරාජ්‍යප්‍රවේශාත් සූචීඡිද්‍රේණ මහාඞ්ගගමනං සුකරං| ");
INSERT INTO sansin_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ඉති වාක්‍යං නිශම්‍ය ශිෂ්‍යා අතිචමත්කෘත්‍ය කථයාමාසුඃ; තර්හි කස්‍ය පරිත්‍රාණං භවිතුං ශක්නෝති? ");
INSERT INTO sansin_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","තදා ස තාන් දෘෂ්ද්වා කථයාමාස, තත් මානුෂාණාමශක්‍යං භවති, කින්ත්වීශ්වරස්‍ය සර්ව්වං ශක්‍යම්| ");
INSERT INTO sansin_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","තදා පිතරස්තං ගදිතවාන්, පශ්‍ය, වයං සර්ව්වං පරිත්‍යජ්‍ය භවතඃ පශ්චාද්වර්ත්තිනෝ (අ)භවාම; වයං කිං ප්‍රාප්ස්‍යාමඃ? ");
INSERT INTO sansin_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","තතෝ යීශුඃ කථිතවාන්, යුෂ්මානහං තථ්‍යං වදාමි, යූයං මම පශ්චාද්වර්ත්තිනෝ ජාතා ඉති කාරණාත් නවීනසෘෂ්ටිකාලේ යදා මනුජසුතඃ ස්වීයෛශ්චර‍්‍ය්‍යසිංහාසන උපවේක්‍ෂ්‍යති, තදා යූයමපි ද්වාදශසිංහාසනේෂූපවිශ්‍ය ඉස්‍රායේලීයද්වාදශවංශානාං විචාරං කරිෂ්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","අන්‍යච්ච යඃ කශ්චිත් මම නාමකාරණාත් ගෘහං වා භ්‍රාතරං වා භගිනීං වා පිතරං වා මාතරං වා ජායාං වා බාලකං වා භූමිං පරිත්‍යජති, ස තේෂාං ශතගුණං ලප්ස්‍යතේ, අනන්තායුමෝ(අ)ධිකාරිත්වඤ්ච ප්‍රාප්ස්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","කින්තු අග්‍රීයා අනේකේ ජනාඃ පශ්චාත්, පශ්චාතීයාශ්චානේකේ ලෝකා අග්‍රේ භවිෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","ස්වර්ගරාජ්‍යම් ඒතාදෘශා කේනචිද් ගෘහස්‍යේන සමං, යෝ(අ)තිප්‍රභාතේ නිජද්‍රාක්‍ෂාක්‍ෂේත්‍රේ කෘෂකාන් නියෝක්තුං ගතවාන්| ");
INSERT INTO sansin_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","පශ්චාත් තෛඃ සාකං දිනෛකභෘතිං මුද්‍රාචතුර්ථාංශං නිරූප්‍ය තාන් ද්‍රාක්‍ෂාක්‍ෂේත්‍රං ප්‍රේරයාමාස| ");
INSERT INTO sansin_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","අනන්තරං ප්‍රහරෛකවේලායාං ගත්වා හට්ටේ කතිපයාන් නිෂ්කර්ම්මකාන් විලෝක්‍ය තානවදත්, ");
INSERT INTO sansin_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","යූයමපි මම ද්‍රාක්‍ෂාක්‍ෂේත්‍රං යාත, යුෂ්මභ්‍යමහං යෝග්‍යභෘතිං දාස්‍යාමි, තතස්තේ වව්‍රජුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","පුනශ්ච ස ද්විතීයතෘතීයයෝඃ ප්‍රහරයෝ ර්බහි ර්ගත්වා තථෛව කෘතවාන්| ");
INSERT INTO sansin_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","තතෝ දණ්ඩද්වයාවශිෂ්ටායාං වේලායාං බහි ර්ගත්වාපරාන් කතිපයජනාන් නිෂ්කර්ම්මකාන් විලෝක්‍ය පෘෂ්ටවාන්, යූයං කිමර්ථම් අත්‍ර සර්ව්වං දිනං නිෂ්කර්ම්මාණස්තිෂ්ඨථ? ");
INSERT INTO sansin_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","තේ ප්‍රත්‍යවදන්, අස්මාන් න කෝපි කර්මමණි නියුංක්තේ| තදානීං ස කථිතවාන්, යූයමපි මම ද්‍රාක්‍ෂාක්‍ෂේත්‍රං යාත, තේන යෝග්‍යාං භෘතිං ලප්ස්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","තදනන්තරං සන්ධ්‍යායාං සත්‍යාං සඒව ද්‍රාක්‍ෂාක්‍ෂේත්‍රපතිරධ්‍යක්‍ෂං ගදිවාන්, කෘෂකාන් ආහූය ශේෂජනමාරභ්‍ය ප්‍රථමං යාවත් තේභ්‍යෝ භෘතිං දේහි| ");
INSERT INTO sansin_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","තේන යේ දණ්ඩද්වයාවස්ථිතේ සමායාතාස්තේෂාම් ඒකෛකෝ ජනෝ මුද්‍රාචතුර්ථාංශං ප්‍රාප්නෝත්| ");
INSERT INTO sansin_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","තදානීං ප්‍රථමනියුක්තා ජනා ආගත්‍යානුමිතවන්තෝ වයමධිකං ප්‍රප්ස්‍යාමඃ, කින්තු තෛරපි මුද්‍රාචතුර්ථාංශෝ(අ)ලාභි| ");
INSERT INTO sansin_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","තතස්තේ තං ගෘහීත්වා තේන ක්‍ෂේත්‍රපතිනා සාකං වාග්‍යුද්ධං කුර්ව්වන්තඃ කථයාමාසුඃ, ");
INSERT INTO sansin_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","වයං කෘත්ස්නං දිනං තාපක්ලේශෞ සෝඪවන්තඃ, කින්තු පශ්චාතායා සේ ජනා දණ්ඩද්වයමාත්‍රං පරිශ්‍රාන්තවන්තස්තේ(අ)ස්මාභිඃ සමානාංශාඃ කෘතාඃ| ");
INSERT INTO sansin_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","තතඃ ස තේෂාමේකං ප්‍රත්‍යුවාච, හේ වත්ස, මයා ත්වාං ප්‍රති කෝප්‍යන්‍යායෝ න කෘතඃ කිං ත්වයා මත්සමක්‍ෂං මුද්‍රාචතුර්ථාංශෝ නාඞ්ගීකෘතඃ? ");
INSERT INTO sansin_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","තස්මාත් තව යත් ප්‍රාප්‍යං තදාදාය යාහි, තුභ්‍යං යති, පශ්චාතීයනියුක්තලෝකායාපි තති දාතුමිච්ඡාමි| ");
INSERT INTO sansin_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ස්වේච්ඡයා නිජද්‍රව්‍යව්‍යවහරණං කිං මයා න කර්ත්තව්‍යං? මම දාතෘත්වාත් ත්වයා කිම් ඊර්ෂ්‍යාදෘෂ්ටිඃ ක්‍රියතේ? ");
INSERT INTO sansin_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","ඉත්ථම් අග්‍රීයලෝකාඃ පශ්චතීයා භවිෂ්‍යන්ති, පශ්චාතීයජනාශ්චග්‍රීයා භවිෂ්‍යන්ති, අහූතා බහවඃ කින්ත්වල්පේ මනෝභිලෂිතාඃ| ");
INSERT INTO sansin_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","තදනන්තරං යීශු ර‍්‍යිරූශාලම්නගරං ගච්ඡන් මාර්ගමධ්‍යේ ශිෂ්‍යාන් ඒකාන්තේ වභාෂේ, ");
INSERT INTO sansin_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","පශ්‍ය වයං යිරූශාලම්නගරං යාමඃ, තත්‍ර ප්‍රධානයාජකාධ්‍යාපකානාං කරේෂු මනුෂ්‍යපුත්‍රඃ සමර්පිෂ්‍යතේ; ");
INSERT INTO sansin_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","තේ ච තං හන්තුමාඥාප්‍ය තිරස්කෘත්‍ය වේත්‍රේණ ප්‍රහර්ත්තුං ක්‍රුශේ ධාතයිතුඤ්චාන්‍යදේශීයානාං කරේෂු සමර්පයිෂ්‍යන්ති, කින්තු ස තෘතීයදිවසේ ශ්මශානාද් උත්ථාපිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","තදානීං සිවදීයස්‍ය නාරී ස්වපුත්‍රාවාදාය යීශෝඃ සමීපම් ඒත්‍ය ප්‍රණම්‍ය කඤ්චනානුග්‍රහං තං යයාචේ| ");
INSERT INTO sansin_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","තදා යීශුස්තාං ප්‍රෝක්තවාන්, ත්වං කිං යාචසේ? තතඃ සා බභාෂේ, භවතෝ රාජත්වේ මමානයෝඃ සුතයෝරේකං භවද්දක්‍ෂිණපාර්ශ්වේ ද්විතීයං වාමපාර්ශ්ව උපවේෂ්ටුම් ආඥාපයතු| ");
INSERT INTO sansin_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","යීශුඃ ප්‍රත්‍යුවාච, යුවාභ්‍යාං යද් යාච්‍යතේ, තන්න බුධ්‍යතේ, අහං යේන කංසේන පාස්‍යාමි යුවාභ්‍යාං කිං තේන පාතුං ශක්‍යතේ? අහඤ්ච යේන මජ්ජේනේන මජ්ජිෂ්‍යේ, යුවාභ්‍යාං කිං තේන මජ්ජයිතුං ශක්‍යතේ? තේ ජගදුඃ ශක්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","තදා ස උක්තවාන්, යුවාං මම කංසේනාවශ්‍යං පාස්‍යථඃ, මම මජ්ජනේන ච යුවාමපි මජ්ජිෂ්‍යේථේ, කින්තු යේෂාං කෘතේ මත්තාතේන නිරූපිතම් ඉදං තාන් විහායාන්‍යං කමපි මද්දක්‍ෂිණපාර්ශ්වේ වාමපාර්ශ්වේ ච සමුපවේශයිතුං මමාධිකාරෝ නාස්ති| ");
INSERT INTO sansin_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ඒතාං කථාං ශ්‍රුත්වාන්‍යේ දශශිෂ්‍යාස්තෞ භ්‍රාතරෞ ප්‍රති චුකුපුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","කින්තු යීශුඃ ස්වසමීපං තානාහූය ජගාද, අන්‍යදේශීයලෝකානාං නරපතයස්තාන් අධිකුර්ව්වන්ති, යේ තු මහාන්තස්තේ තාන් ශාසති, ඉති යූයං ජානීථ| ");
INSERT INTO sansin_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","කින්තු යුෂ්මාකං මධ්‍යේ න තථා භවේත්, යුෂ්මාකං යඃ කශ්චිත් මහාන් බුභූෂති, ස යුෂ්මාන් සේවේත; ");
INSERT INTO sansin_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","යශ්ච යුෂ්මාකං මධ්‍යේ මුඛ්‍යෝ බුභූෂති, ස යුෂ්මාකං දාසෝ භවේත්| ");
INSERT INTO sansin_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ඉත්ථං මනුජපුත්‍රඃ සේව්‍යෝ භවිතුං නහි, කින්තු සේවිතුං බහූනාං පරිත්‍රාණමූල්‍යාර්ථං ස්වප්‍රාණාන් දාතුඤ්චාගතඃ| ");
INSERT INTO sansin_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","අනන්තරං යිරීහෝනගරාත් තේෂාං බහිර්ගමනසමයේ තස්‍ය පශ්චාද් බහවෝ ලෝකා වව්‍රජුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","අපරං වර්ත්මපාර්ශ්ව උපවිශන්තෞ ද්වාවන්ධෞ තේන මාර්ගේණ යීශෝ ර්ගමනං නිශම්‍ය ප්‍රෝච්චෛඃ කථයාමාසතුඃ, හේ ප්‍රභෝ දායූදඃ සන්තාන, ආවයෝ ර්දයාං විධේහි| ");
INSERT INTO sansin_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","තතෝ ලෝකාඃ සර්ව්වේ තුෂ්ණීම්භවතමිත්‍යුක්ත්වා තෞ තර්ජයාමාසුඃ; තථාපි තෞ පුනරුච්චෛඃ කථයාමාසතුඃ හේ ප්‍රභෝ දායූදඃ සන්තාන, ආවාං දයස්ව| ");
INSERT INTO sansin_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","තදානීං යීශුඃ ස්ථගිතඃ සන් තාවාහූය භාෂිතවාන්, යුවයෝඃ කෘතේ මයා කිං කර්ත්තර්ව්‍යං? යුවාං කිං කාමයේථේ? ");
INSERT INTO sansin_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","තදා තාවුක්තවන්තෞ, ප්‍රභෝ නේත්‍රාණි නෞ ප්‍රසන්නානි භවේයුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","තදානීං යීශුස්තෞ ප්‍රති ප්‍රමන්නඃ සන් තයෝ ර්නේත්‍රාණි පස්පර්ශ, තේනෛව තෞ සුවීක්‍ෂාඤ්චක්‍රාතේ තත්පශ්චාත් ජග්මුතුශ්ච| ");
INSERT INTO sansin_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","අනන්තරං තේෂු යිරූශාලම්නගරස්‍ය සමීපවේර්ත්තිනෝ ජෛතුනනාමකධරාධරස්‍ය සමීපස්ථ්තිං බෛත්ඵගිග්‍රාමම් ආගතේෂු, යීශුඃ ශිෂ්‍යද්වයං ප්‍රේෂයන් ජගාද, ");
INSERT INTO sansin_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","යුවාං සම්මුඛස්ථග්‍රාමං ගත්වා බද්ධාං යාං සවත්සාං ගර්ද්දභීං හඨාත් ප්‍රාප්ස්‍යථඃ, තාං මෝචයිත්වා මදන්තිකම් ආනයතං| ");
INSERT INTO sansin_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","තත්‍ර යදි කශ්චිත් කිඤ්චිද් වක්‍ෂ්‍යති, තර්හි වදිෂ්‍යථඃ, ඒතස්‍යාං ප්‍රභෝඃ ප්‍රයෝජනමාස්තේ, තේන ස තත්ක්‍ෂණාත් ප්‍රහේෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","සීයෝනඃ කන්‍යකාං යූයං භාෂධ්වමිති භාරතීං| පශ්‍ය තේ නම්‍රශීලඃ සන් නෘප ආරුහ්‍ය ගර්දභීං| අර්ථාදාරුහ්‍ය තද්වත්සමායාස්‍යති ත්වදන්තිකං| ");
INSERT INTO sansin_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","භවිෂ්‍යද්වාදිනෝක්තං වචනමිදං තදා සඵලමභූත්| ");
INSERT INTO sansin_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","අනන්තරං තෞ ශ්ෂ්‍යිौ යීශෝ ර‍්‍යථානිදේශං තං ග්‍රාමං ගත්වා ");
INSERT INTO sansin_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ගර්දභීං තද්වත්සඤ්ච සමානීතවන්තෞ, පශ්චාත් තදුපරි ස්වීයවසනානී පාතයිත්වා තමාරෝහයාමාසතුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","තතෝ බහවෝ ලෝකා නිජවසනානි පථි ප්‍රසාරයිතුමාරේභිරේ, කතිපයා ජනාශ්ච පාදපපර්ණාදිකං ඡිත්වා පථි විස්තාරයාමාසුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","අග්‍රගාමිනඃ පශ්චාද්ගාමිනශ්ච මනුජා උච්චෛර්ජය ජය දායූදඃ සන්තානේති ජගදුඃ පරමේශ්වරස්‍ය නාම්නා ය ආයාති ස ධන්‍යඃ, සර්ව්වෝපරිස්ථස්වර්ගේපි ජයති| ");
INSERT INTO sansin_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ඉත්ථං තස්මින් යිරූශාලමං ප්‍රවිෂ්ටේ කෝ(අ)යමිති කථනාත් කෘත්ස්නං නගරං චඤ්චලමභවත්| ");
INSERT INTO sansin_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","තත්‍ර ලෝකෝඃ කථයාමාසුඃ, ඒෂ ගාලීල්ප්‍රදේශීය-නාසරතීය-භවිෂ්‍යද්වාදී යීශුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","අනන්තරං යීශුරීශ්වරස්‍ය මන්දිරං ප්‍රවිශ්‍ය තන්මධ්‍යාත් ක්‍රයවික්‍රයිණෝ වහිශ්චකාර; වණිජාං මුද්‍රාසනානී කපෝතවික්‍රයිණාඤ්චසනානී ච න්‍යුව්ජයාමාස| ");
INSERT INTO sansin_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","අපරං තානුවාච, ඒෂා ලිපිරාස්තේ, \"මම ගෘහං ප්‍රාර්ථනාගෘහමිති විඛ්‍යාස්‍යති\", කින්තු යූයං තද් දස්‍යූනාං ගහ්වරං කෘතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","තදනන්තරම් අන්ධඛඤ්චලෝකාස්තස්‍ය සමීපමාගතාඃ, ස තාන් නිරාමයාන් කෘතවාන්| ");
INSERT INTO sansin_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","යදා ප්‍රධානයාජකා අධ්‍යාපකාශ්ච තේන කෘතාන්‍යේතානි චිත්‍රකර්ම්මාණි දදෘශුඃ, ජය ජය දායූදඃ සන්තාන, මන්දිරේ බාලකානාම් ඒතාදෘශම් උච්චධ්වනිං ශුශ්‍රුවුශ්ච, තදා මහාක්‍රුද්ධා බභූවඃ, ");
INSERT INTO sansin_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","තං පප්‍රච්ඡුශ්ච, ඉමේ යද් වදන්ති, තත් කිං ත්වං ශෘණෝෂි? තතෝ යීශුස්තාන් අවෝචත්, සත්‍යම්; ස්තන්‍යපායිශිශූනාඤ්ච බාලකානාඤ්ච වක්ත්‍රතඃ| ස්වකීයං මහිමානං ත්වං සංප්‍රකාශයසි ස්වයං| ඒතද්වාක්‍යං යූයං කිං නාපඨත? ");
INSERT INTO sansin_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","තතස්තාන් විහාය ස නගරාද් බෛථනියාග්‍රාමං ගත්වා තත්‍ර රජනීං යාපයාමාස| ");
INSERT INTO sansin_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","අනන්තරං ප්‍රභාතේ සති යීශුඃ පුනරපි නගරමාගච්ඡන් ක්‍ෂුධාර්ත්තෝ බභූව| ");
INSERT INTO sansin_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","තතෝ මාර්ගපාර්ශ්ව උඩුම්බරවෘක්‍ෂමේකං විලෝක්‍ය තත්සමීපං ගත්වා පත්‍රාණි විනා කිමපි න ප්‍රාප්‍ය තං පාදපං ප්‍රෝවාච, අද්‍යාරභ්‍ය කදාපි ත්වයි ඵලං න භවතු; තේන තත්ක්‍ෂණාත් ස උඩුම්බරමාහීරුහඃ ශුෂ්කතාං ගතඃ| ");
INSERT INTO sansin_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","තද් දෘෂ්ට්වා ශිෂ්‍යා ආශ්චර‍්‍ය්‍යං විඥාය කථයාමාසුඃ, ආඃ, උඩුම්වරපාදපෝ(අ)තිතූර්ණං ශුෂ්කෝ(අ)භවත්| ");
INSERT INTO sansin_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","තතෝ යීශුස්තානුවාච, යුෂ්මානහං සත්‍යං වදාමි, යදි යූයමසන්දිග්ධාඃ ප්‍රතීථ, තර්හි යූයමපි කේවලෝඩුම්වරපාදපං ප්‍රතීත්ථං කර්ත්තුං ශක්‍ෂ්‍යථ, තන්න, ත්වං චලිත්වා සාගරේ පතේති වාක්‍යං යුෂ්මාභිරස්මින ශෛලේ ප්‍රෝක්තේපි තදෛව තද් ඝටිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","තථා විශ්වස්‍ය ප්‍රාර්ථ්‍ය යුෂ්මාභි ර‍්‍යද් යාචිෂ්‍යතේ, තදේව ප්‍රාප්ස්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","අනන්තරං මන්දිරං ප්‍රවිශ්‍යෝපදේශනසමයේ තත්සමීපං ප්‍රධානයාජකාඃ ප්‍රාචීනලෝකාශ්චාගත්‍ය පප්‍රච්ඡුඃ, ත්වයා කේන සාමර්ථ්‍යනෛතානි කර්ම්මාණි ක්‍රියන්තේ? කේන වා තුභ්‍යමේතානි සාමර්ථ්‍යානි දත්තානි? ");
INSERT INTO sansin_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","තතෝ යීශුඃ ප්‍රත්‍යවදත්, අහමපි යුෂ්මාන් වාචමේකාං පෘච්ඡාමි, යදි යූයං තදුත්තරං දාතුං ශක්‍ෂ්‍යථ, තදා කේන සාමර්ථ්‍යේන කර්ම්මාණ්‍යේතානි කරෝමි, තදහං යුෂ්මාන් වක්‍ෂ්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","යෝහනෝ මජ්ජනං කස්‍යාඥයාභවත්? කිමීශ්වරස්‍ය මනුෂ්‍යස්‍ය වා? තතස්තේ පරස්පරං විවිච්‍ය කථයාමාසුඃ, යදීශ්වරස්‍යේති වදාමස්තර්හි යූයං තං කුතෝ න ප්‍රත්‍යෛත? වාචමේතාං වක්‍ෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","මනුෂ්‍යස්‍යේති වක්තුමපි ලෝකේභ්‍යෝ බිභීමඃ, යතඃ සර්ව්වෛරපි යෝහන් භවිෂ්‍යද්වාදීති ඥායතේ| ");
INSERT INTO sansin_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","තස්මාත් තේ යීශුං ප්‍රත්‍යවදන්, තද් වයං න විද්මඃ| තදා ස තානුක්තවාන්, තර්හි කේන සාමරථ්‍යේන කර්ම්මාණ්‍යේතාන්‍යහං කරෝමි, තදප්‍යහං යුෂ්මාන් න වක්‍ෂ්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","කස්‍යචිජ්ජනස්‍ය ද්වෞ සුතාවාස්තාං ස ඒකස්‍ය සුතස්‍ය සමීපං ගත්වා ජගාද, හේ සුත, ත්වමද්‍ය මම ද්‍රාක්‍ෂාක්‍ෂේත්‍රේ කර්ම්ම කර්තුං ව්‍රජ| ");
INSERT INTO sansin_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","තතඃ ස උක්තවාන්, න යාස්‍යාමි, කින්තු ශේෂේ(අ)නුතප්‍ය ජගාම| ");
INSERT INTO sansin_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","අනන්තරං සෝන්‍යසුතස්‍ය සමීපං ගත්වා තථෛව කථ්තිවාන්; තතඃ ස ප්‍රත්‍යුවාච, මහේච්ඡ යාමි, කින්තු න ගතඃ| ");
INSERT INTO sansin_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","ඒතයෝඃ පුත්‍රයෝ ර්මධ්‍යේ පිතුරභිමතං කේන පාලිතං? යුෂ්මාභිඃ කිං බුධ්‍යතේ? තතස්තේ ප්‍රත්‍යූචුඃ, ප්‍රථමේන පුुත්‍රේණ| තදානීං යීශුස්තානුවාච, අහං යුෂ්මාන් තථ්‍යං වදාමි, චණ්ඩාලා ගණිකාශ්ච යුෂ්මාකමග්‍රත ඊශ්වරස්‍ය රාජ්‍යං ප්‍රවිශන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","යතෝ යුෂ්මාකං සමීපං යෝහනි ධර්ම්මපථේනාගතේ යූයං තං න ප්‍රතීථ, කින්තු චණ්ඩාලා ගණිකාශ්ච තං ප්‍රත්‍යායන්, තද් විලෝක්‍යාපි යූයං ප්‍රත්‍යේතුං නාඛිද්‍යධ්වං| ");
INSERT INTO sansin_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","අපරමේකං දෘෂ්ටාන්තං ශෘණුත, කශ්චිද් ගෘහස්ථඃ ක්‍ෂේත්‍රේ ද්‍රාක්‍ෂාලතා රෝපයිත්වා තච්චතුර්දික්‍ෂු වාරණීං විධාය තන්මධ්‍යේ ද්‍රාක්‍ෂායන්ත්‍රං ස්ථාපිතවාන්, මාඤ්චඤ්ච නිර්ම්මිතවාන්, තතඃ කෘෂකේෂු තත් ක්‍ෂේත්‍රං සමර්ප්‍ය ස්වයං දූරදේශං ජගාම| ");
INSERT INTO sansin_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","තදනන්තරං ඵලසමය උපස්ථිතේ ස ඵලානි ප්‍රාප්තුං කෘෂීවලානාං සමීපං නිජදාසාන් ප්‍රේෂයාමාස| ");
INSERT INTO sansin_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","කින්තු කෘෂීවලාස්තස්‍ය තාන් දාසේයාන් ධෘත්වා කඤ්චන ප්‍රහෘතවන්තඃ, කඤ්චන පාෂාණෛරාහතවන්තඃ, කඤ්චන ච හතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","පුනරපි ස ප්‍රභුඃ ප්‍රථමතෝ(අ)ධිකදාසේයාන් ප්‍රේෂයාමාස, කින්තු තේ තාන් ප්‍රත්‍යපි තථෛව චක්‍රුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","අනන්තරං මම සුතේ ගතේ තං සමාදරිෂ්‍යන්තේ, ඉත්‍යුක්ත්වා ශේෂේ ස නිජසුතං තේෂාං සන්නිධිං ප්‍රේෂයාමාස| ");
INSERT INTO sansin_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","කින්තු තේ කෘෂීවලාඃ සුතං වීක්‍ෂ්‍ය පරස්පරම් ඉති මන්ත්‍රයිතුම් ආරේභිරේ, අයමුත්තරාධිකාරී වයමේනං නිහත්‍යාස්‍යාධිකාරං ස්වවශීකරිෂ්‍යාමඃ| ");
INSERT INTO sansin_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","පශ්චාත් තේ තං ධෘත්වා ද්‍රාක්‍ෂාක්‍ෂේත්‍රාද් බහිඃ පාතයිත්වාබධිෂුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","යදා ස ද්‍රාක්‍ෂාක්‍ෂේත්‍රපතිරාගමිෂ්‍යති, තදා තාන් කෘෂීවලාන් කිං කරිෂ්‍යති? ");
INSERT INTO sansin_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","තතස්තේ ප්‍රත්‍යවදන්, තාන් කලුෂිණෝ දාරුණයාතනාභිරාහනිෂ්‍යති, යේ ච සමයානුක්‍රමාත් ඵලානි දාස්‍යන්ති, තාදෘශේෂු කෘෂීවලේෂු ක්‍ෂේත්‍රං සමර්පයිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","තදා යීශුනා තේ ගදිතාඃ, ග්‍රහණං න කෘතං යස්‍ය පාෂාණස්‍ය නිචායකෛඃ| ප්‍රධානප්‍රස්තරඃ කෝණේ සඒව සංභවිෂ්‍යති| ඒතත් පරේශිතුඃ කර්ම්මාස්මදෘෂ්ටාවද්භුතං භවේත්| ධර්ම්මග්‍රන්ථේ ලිඛිතමේතද්වචනං යුෂ්මාභිඃ කිං නාපාඨි? ");
INSERT INTO sansin_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","තස්මාදහං යුෂ්මාන් වදාමි, යුෂ්මත්ත ඊශ්වරීයරාජ්‍යමපනීය ඵලෝත්පාදයිත්‍රන්‍යජාතයේ දායිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","යෝ ජන ඒතත්පාෂාණෝපරි පතිෂ්‍යති, තං ස භංක්‍ෂ්‍යතේ, කින්ත්වයං පාෂාණෝ යස්‍යෝපරි පතිෂ්‍යති, තං ස ධූලිවත් චූර්ණීකරිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","තදානීං ප්‍රාධනයාජකාඃ ඵිරූශිනශ්ච තස්‍යේමාං දෘෂ්ටාන්තකථාං ශ්‍රුත්වා සෝ(අ)ස්මානුද්දිශ්‍ය කථිතවාන්, ඉති විඥාය තං ධර්ත්තුං චේෂ්ටිතවන්තඃ; ");
INSERT INTO sansin_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","කින්තු ලෝකේභ්‍යෝ බිභ්‍යුඃ, යතෝ ලෝකෛඃ ස භවිෂ්‍යද්වාදීත්‍යඥායි| ");
INSERT INTO sansin_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","අනන්තරං යීශුඃ පුනරපි දෘෂ්ටාන්තේන තාන් අවාදීත්, ");
INSERT INTO sansin_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","ස්වර්ගීයරාජ්‍යම් ඒතාදෘශස්‍ය නෘපතේඃ සමං, යෝ නිජ පුත්‍රං විවාහයන් සර්ව්වාන් නිමන්ත්‍රිතාන් ආනේතුං දාසේයාන් ප්‍රහිතවාන්, ");
INSERT INTO sansin_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","කින්තු තේ සමාගන්තුං නේෂ්ටවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","තතෝ රාජා පුනරපි දාසානන්‍යාන් ඉත්‍යුක්ත්වා ප්‍රේෂයාමාස, නිමන්ත්‍රිතාන් වදත, පශ්‍යත, මම භේජ්‍යමාසාදිතමාස්තේ, නිජව්ටෂාදිපුෂ්ටජන්තූන් මාරයිත්වා සර්ව්වං ඛාද්‍යද්‍රව්‍යමාසාදිතවාන්, යූයං විවාහමාගච්ඡත| ");
INSERT INTO sansin_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","තථපි තේ තුච්ඡීකෘත්‍ය කේචිත් නිජක්‍ෂේත්‍රං කේචිද් වාණිජ්‍යං ප්‍රති ස්වස්වමාර්ගේණ චලිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","අන්‍යේ ලෝකාස්තස්‍ය දාසේයාන් ධෘත්වා දෞරාත්ම්‍යං ව්‍යවහෘත්‍ය තානවධිෂුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","අනන්තරං ස නෘපතිස්තාං වාර්ත්තාං ශ්‍රුත්වා ක්‍රුධ්‍යන් සෛන්‍යානි ප්‍රහිත්‍ය තාන් ඝාතකාන් හත්වා තේෂාං නගරං දාහයාමාස| ");
INSERT INTO sansin_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","තතඃ ස නිජදාසේයාන් බභාෂේ, විවාහීයං භෝජ්‍යමාසාදිතමාස්තේ, කින්තු නිමන්ත්‍රිතා ජනා අයෝග්‍යාඃ| ");
INSERT INTO sansin_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","තස්මාද් යූයං රාජමාර්ගං ගත්වා යාවතෝ මනුජාන් පශ්‍යත, තාවතඒව විවාහීයභෝජ්‍යාය නිමන්ත්‍රයත| ");
INSERT INTO sansin_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","තදා තේ දාසේයා රාජමාර්ගං ගත්වා භද්‍රාන් අභද්‍රාන් වා යාවතෝ ජනාන් දදෘශුඃ, තාවතඒව සංගෘහ්‍යානයන්; තතෝ(අ)භ්‍යාගතමනුජෛ ර්විවාහගෘහම් අපූර‍්‍ය්‍යත| ");
INSERT INTO sansin_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","තදානීං ස රාජා සර්ව්වානභ්‍යාගතාන් ද්‍රෂ්ටුම් අභ්‍යන්තරමාගතවාන්; තදා තත්‍ර විවාහීයවසනහීනමේකං ජනං වීක්‍ෂ්‍ය තං ජගාද්, ");
INSERT INTO sansin_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","හේ මිත්‍ර,ත්වං විවාහීයවසනං විනා කථමත්‍ර ප්‍රවිෂ්ටවාන්? තේන ස නිරුත්තරෝ බභූව| ");
INSERT INTO sansin_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","තදා රාජා නිජානුචරාන් අවදත්, ඒතස්‍ය කරචරණාන් බද්ධා යත්‍ර රෝදනං දන්තෛර්දන්තඝර්ෂණඤ්ච භවති, තත්‍ර වහිර්භූතතමිස්‍රේ තං නික්‍ෂිපත| ");
INSERT INTO sansin_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","ඉත්ථං බහව ආහූතා අල්පේ මනෝභිමතාඃ| ");
INSERT INTO sansin_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","අනන්තරං ඵිරූශිනඃ ප්‍රගත්‍ය යථා සංලාපේන තම් උන්මාථේ පාතයේයුස්තථා මන්ත්‍රයිත්වා ");
INSERT INTO sansin_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","හේරෝදීයමනුජෛඃ සාකං නිජශිෂ්‍යගණේන තං ප්‍රති කථයාමාසුඃ, හේ ගුරෝ, භවාන් සත්‍යඃ සත්‍යමීශ්වරීයමාර්ගමුපදිශති, කමපි මානුෂං නානුරුධ්‍යතේ, කමපි නාපේක්‍ෂතේ ච, තද් වයං ජානීමඃ| ");
INSERT INTO sansin_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","අතඃ කෛසරභූපාය කරෝ(අ)ස්මාකං දාතව්‍යෝ න වා? අත්‍ර භවතා කිං බුධ්‍යතේ? තද් අස්මාන් වදතු| ");
INSERT INTO sansin_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","තතෝ යීශුස්තේෂාං ඛලතාං විඥාය කථිතවාන්, රේ කපටිනඃ යුයං කුතෝ මාං පරික්‍ෂධ්වේ? ");
INSERT INTO sansin_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","තත්කරදානස්‍ය මුද්‍රාං මාං දර්ශයත| තදානීං තෛස්තස්‍ය සමීපං මුද්‍රාචතුර්ථභාග ආනීතේ ");
INSERT INTO sansin_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ස තාන් පප්‍රච්ඡ, අත්‍ර කස්‍යේයං මූර්ත්ති ර්නාම චාස්තේ? තේ ජගදුඃ, කෛසරභූපස්‍ය| ");
INSERT INTO sansin_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","තතඃ ස උක්තවාන, කෛසරස්‍ය යත් තත් කෛසරාය දත්ත, ඊශ්වරස්‍ය යත් තද් ඊශ්වරාය දත්ත| ");
INSERT INTO sansin_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ඉති වාක්‍යං නිශම්‍ය තේ විස්මයං විඥාය තං විහාය චලිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","තස්මින්නහනි සිදූකිනෝ(අ)ර්ථාත් ශ්මශානාත් නෝත්ථාස්‍යන්තීති වාක්‍යං යේ වදන්ති, තේ යීශේाරන්තිකම් ආගත්‍ය පප්‍රච්ඡුඃ, ");
INSERT INTO sansin_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","හේ ගුරෝ, කශ්චින්මනුජශ්චේත් නිඃසන්තානඃ සන් ප්‍රාණාන් ත්‍යජති, තර්හි තස්‍ය භ්‍රාතා තස්‍ය ජායාං ව්‍යුහ්‍ය භ්‍රාතුඃ සන්තානම් උත්පාදයිෂ්‍යතීති මූසා ආදිෂ්ටවාන්| ");
INSERT INTO sansin_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","කින්ත්වස්මාකමත්‍ර කේ(අ)පි ජනාඃ සප්තසහෝදරා ආසන්, තේෂාං ජ්‍යේෂ්ඨ ඒකාං කන්‍යාං ව්‍යවහාත්, අපරං ප්‍රාණත්‍යාගකාලේ ස්වයං නිඃසන්තානඃ සන් තාං ස්ත්‍රියං ස්වභ්‍රාතරි සමර්පිතවාන්, ");
INSERT INTO sansin_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","තතෝ ද්විතීයාදිසප්තමාන්තාශ්ච තථෛව චක්‍රුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ශේෂේ සාපී නාරී මමාර| ");
INSERT INTO sansin_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","මෘතානාම් උත්ථානසමයේ තේෂාං සප්තානාං මධ්‍යේ සා නාරී කස්‍ය භාර‍්‍ය්‍යා භවිෂ්‍යති? යස්මාත් සර්ව්වඒව තාං ව්‍යවහන්| ");
INSERT INTO sansin_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","තතෝ යීශුඃ ප්‍රත්‍යවාදීත්, යූයං ධර්ම්මපුස්තකම් ඊශ්වරීයාං ශක්තිඤ්ච න විඥාය භ්‍රාන්තිමන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","උත්ථානප්‍රාප්තා ලෝකා න විවහන්ති, න ච වාචා දීයන්තේ, කින්ත්වීශ්වරස්‍ය ස්වර්ගස්ථදූතානාං සදෘශා භවන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","අපරං මෘතානාමුත්ථානමධි යුෂ්මාන් ප්‍රතීයමීශ්වරෝක්තිඃ, ");
INSERT INTO sansin_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","\"අහමිබ්‍රාහීම ඊශ්වර ඉස්හාක ඊශ්වරෝ යාකූබ ඊශ්වර\" ඉති කිං යුෂ්මාභි ර්නාපාඨි? කින්ත්වීශ්වරෝ ජීවතාම් ඊශ්වර:, ස මෘතානාමීශ්වරෝ නහි| ");
INSERT INTO sansin_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ඉති ශ්‍රුත්වා සර්ව්වේ ලෝකාස්තස්‍යෝපදේශාද් විස්මයං ගතාඃ| ");
INSERT INTO sansin_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","අනන්තරං සිදූකිනාම් නිරුත්තරත්වවාර්තාං නිශම්‍ය ඵිරූශින ඒකත්‍ර මිලිතවන්තඃ, ");
INSERT INTO sansin_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","තේෂාමේකෝ ව්‍යවස්ථාපකෝ යීශුං පරීක්‍ෂිතුං පපච්ඡ, ");
INSERT INTO sansin_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","හේ ගුරෝ ව්‍යවස්ථාශාස්ත්‍රමධ්‍යේ කාඥා ශ්‍රේෂ්ඨා? ");
INSERT INTO sansin_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","තතෝ යීශුරුවාච, ත්වං සර්ව්වාන්තඃකරණෛඃ සර්ව්වප්‍රාණෛඃ සර්ව්වචිත්තෛශ්ච සාකං ප්‍රභෞ පරමේශ්වරේ ප්‍රීයස්ව, ");
INSERT INTO sansin_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ඒෂා ප්‍රථමමහාඥා| තස්‍යාඃ සදෘශී ද්විතීයාඥෛෂා, ");
INSERT INTO sansin_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","තව සමීපවාසිනි ස්වාත්මනීව ප්‍රේම කුරු| ");
INSERT INTO sansin_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","අනයෝ ර්ද්වයෝරාඥයෝඃ කෘත්ස්නව්‍යවස්ථායා භවිෂ්‍යද්වක්තෘග්‍රන්ථස්‍ය ච භාරස්තිෂ්ඨති| ");
INSERT INTO sansin_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","අනන්තරං ඵිරූශිනාම් ඒකත්‍ර ස්ථිතිකාලේ යීශුස්තාන් පප්‍රච්ඡ, ");
INSERT INTO sansin_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","ඛ්‍රීෂ්ටමධි යුෂ්මාකං කීදෘග්බෝධෝ ජායතේ? ස කස්‍ය සන්තානඃ? තතස්තේ ප්‍රත්‍යවදන්, දායූදඃ සන්තානඃ| ");
INSERT INTO sansin_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","තදා ස උක්තවාන්, තර්හි දායූද් කථම් ආත්මාධිෂ්ඨානේන තං ප්‍රභුං වදති ? ");
INSERT INTO sansin_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","යථා මම ප්‍රභුමිදං වාක්‍යමවදත් පරමේශ්වරඃ| තවාරීන් පාදපීඨං තේ යාවන්නහි කරෝම්‍යහං| තාවත් කාලං මදීයේ ත්වං දක්‍ෂපාර්ශ්ව උපාවිශ| අතෝ යදි දායූද් තං ප්‍රභුං වදති, ර්තිහ ස කථං තස්‍ය සන්තානෝ භවති? ");
INSERT INTO sansin_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","තදානීං තේෂාං කෝපි තද්වාක්‍යස්‍ය කිමප්‍යුත්තරං දාතුං නාශක්නෝත්; ");
INSERT INTO sansin_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","තද්දිනමාරභ්‍ය තං කිමපි වාක්‍යං ප්‍රෂ්ටුං කස්‍යාපි සාහසෝ නාභවත්| ");
INSERT INTO sansin_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","අනන්තරං යීශු ර්ජනනිවහං ශිෂ්‍යාංශ්චාවදත්, ");
INSERT INTO sansin_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","අධ්‍යාපකාඃ ඵිරූශිනශ්ච මූසාසනේ උපවිශන්ති, ");
INSERT INTO sansin_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","අතස්තේ යුෂ්මාන් යද්‍යත් මන්තුම් ආඥාපයන්ති, තත් මන්‍යධ්වං පාලයධ්වඤ්ච, කින්තු තේෂාං කර්ම්මානුරූපං කර්ම්ම න කුරුධ්වං; යතස්තේෂාං වාක්‍යමාත්‍රං සාරං කාර‍්‍ය්‍යේ කිමපි නාස්ති| ");
INSERT INTO sansin_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","තේ දුර්ව්වහාන් ගුරුතරාන් භාරාන් බද්ව්වා මනුෂ්‍යාණාං ස්කන්ධේපරි සමර්පයන්ති, කින්තු ස්වයමඞ්ගුල්‍යෛකයාපි න චාලයන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","කේවලං ලෝකදර්ශනාය සර්ව්වකර්ම්මාණි කුර්ව්වන්ති; ඵලතඃ පට්ටබන්ධාන් ප්‍රසාර‍්‍ය්‍ය ධාරයන්ති, ස්වවස්ත්‍රේෂු ච දීර්ඝග්‍රන්ථීන් ධාරයන්ති; ");
INSERT INTO sansin_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","භෝජනභවන උච්චස්ථානං, භජනභවනේ ප්‍රධානමාසනං, ");
INSERT INTO sansin_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","හට්ඨේ නමස්කාරං ගුරුරිති සම්බෝධනඤ්චෛතානි සර්ව්වාණි වාඤ්ඡන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","කින්තු යූයං ගුරව ඉති සම්බෝධනීයා මා භවත, යතෝ යුෂ්මාකම් ඒකඃ ඛ්‍රීෂ්ටඒව ගුරු ");
INSERT INTO sansin_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ර‍්‍යූයං සර්ව්වේ මිථෝ භ්‍රාතරශ්ච| පුනඃ පෘථිව්‍යාං කමපි පිතේති මා සම්බුධ්‍යධ්වං, යතෝ යුෂ්මාකමේකඃ ස්වර්ගස්ථඒව පිතා| ");
INSERT INTO sansin_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","යූයං නායකේති සම්භාෂිතා මා භවත, යතෝ යුෂ්මාකමේකඃ ඛ්‍රීෂ්ටඒව නායකඃ| ");
INSERT INTO sansin_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","අපරං යුෂ්මාකං මධ්‍යේ යඃ පුමාන් ශ්‍රේෂ්ඨඃ ස යුෂ්මාන් සේවිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","යතෝ යඃ ස්වමුන්නමති, ස නතඃ කරිෂ්‍යතේ; කින්තු යඃ කශ්චිත් ස්වමවනතං කරෝති, ස උන්නතඃ කරිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","හන්ත කපටින උපාධ්‍යායාඃ ඵිරූශිනශ්ච, යූයං මනුජානාං සමක්‍ෂං ස්වර්ගද්වාරං රුන්ධ, යූයං ස්වයං තේන න ප්‍රවිශථ, ප්‍රවිවික්‍ෂූනපි වාරයථ| වත කපටින උපාධ්‍යායාඃ ඵිරූශිනශ්ච යූයං ඡලාද් දීර්ඝං ප්‍රාර්ථ්‍ය විධවානාං සර්ව්වස්වං ග්‍රසථ, යුෂ්මාකං ඝෝරතරදණ්ඩෝ භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","හන්ත කපටින උපාධ්‍යායාඃ ඵිරූශිනශ්ච, යූයමේකං ස්වධර්ම්මාවලම්බිනං කර්ත්තුං සාගරං භූමණ්ඩලඤ්ච ප්‍රදක්‍ෂිණීකුරුථ, ");
INSERT INTO sansin_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","කඤ්චන ප්‍රාප්‍ය ස්වතෝ ද්විගුණනරකභාජනං තං කුරුථ| ");
INSERT INTO sansin_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","වත අන්ධපථදර්ශකාඃ සර්ව්වේ, යූයං වදථ, මන්දිරස්‍ය ශපථකරණාත් කිමපි න දේයං; කින්තු මන්දිරස්ථසුවර්ණස්‍ය ශපථකරණාද් දේයං| ");
INSERT INTO sansin_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","හේ මූඪා හේ අන්ධාඃ සුවර්ණං තත්සුවර්ණපාවකමන්දිරම් ඒතයෝරුභයෝ ර්මධ්‍යේ කිං ශ්‍රේයඃ? ");
INSERT INTO sansin_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","අන්‍යච්ච වදථ, යඥවේද්‍යාඃ ශපථකරණාත් කිමපි න දේයං, කින්තු තදුපරිස්ථිතස්‍ය නෛවේද්‍යස්‍ය ශපථකරණාද් දේයං| ");
INSERT INTO sansin_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","හේ මූඪා හේ අන්ධාඃ, නෛවේද්‍යං තන්නෛවේද්‍යපාවකවේදිරේතයෝරුභයෝ ර්මධ්‍යේ කිං ශ්‍රේයඃ? ");
INSERT INTO sansin_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","අතඃ කේනචිද් යඥවේද්‍යාඃ ශපථේ කෘතේ තදුපරිස්ථස්‍ය සර්ව්වස්‍ය ශපථඃ ක්‍රියතේ| ");
INSERT INTO sansin_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","කේනචිත් මන්දිරස්‍ය ශපථේ කෘතේ මන්දිරතන්නිවාසිනෝඃ ශපථඃ ක්‍රියතේ| ");
INSERT INTO sansin_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","කේනචිත් ස්වර්ගස්‍ය ශපථේ කෘතේ ඊශ්වරීයසිංහාසනතදුපර‍්‍ය්‍යුපවිෂ්ටයෝඃ ශපථඃ ක්‍රියතේ| ");
INSERT INTO sansin_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","හන්ත කපටින උපාධ්‍යායාඃ ඵිරූශිනශ්ච, යූයං පෝදිනායාඃ සිතච්ඡත්‍රායා ජීරකස්‍ය ච දශමාංශාන් දත්ථ, කින්තු ව්‍යවස්ථායා ගුරුතරාන් න්‍යායදයාවිශ්වාසාන් පරිත්‍යජථ; ඉමේ යුෂ්මාභිරාචරණීයා අමී ච න ලංඝනීයාඃ| ");
INSERT INTO sansin_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","හේ අන්ධපථදර්ශකා යූයං මශකාන් අපසාරයථ, කින්තු මහාඞ්ගාන් ග්‍රසථ| ");
INSERT INTO sansin_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","හන්ත කපටින උපාධ්‍යායාඃ ඵිරූශිනශ්ච, යූයං පානපාත්‍රාණාං භෝජනපාත්‍රාණාඤ්ච බහිඃ පරිෂ්කුරුථ; කින්තු තදභ්‍යන්තරං දුරාත්මතයා කලුෂේණ ච පරිපූර්ණමාස්තේ| ");
INSERT INTO sansin_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","හේ අන්ධාඃ ඵිරූශිලෝකා ආදෞ පානපාත්‍රාණාං භෝජනපාත්‍රාණාඤ්චාභ්‍යන්තරං පරිෂ්කුරුත, තේන තේෂාං බහිරපි පරිෂ්කාරිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","හන්ත කපටින උපාධ්‍යායාඃ ඵිරූශිනශ්ච, යූයං ශුක්ලීකෘතශ්මශානස්වරූපා භවථ, යථා ශ්මශානභවනස්‍ය බහිශ්චාරු, කින්ත්වභ්‍යන්තරං මෘතලෝකානාං කීකශෛඃ සර්ව්වප්‍රකාරමලේන ච පරිපූර්ණම්; ");
INSERT INTO sansin_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","තථෛව යූයමපි ලෝකානාං සමක්‍ෂං බහිර්ධාර්ම්මිකාඃ කින්ත්වන්තඃකරණේෂු කේවලකාපට්‍යාධර්ම්මාභ්‍යාං පරිපූර්ණාඃ| ");
INSERT INTO sansin_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","හා හා කපටින උපාධ්‍යායාඃ ඵිරූශිනශ්ච, යූයං භවිෂ්‍යද්වාදිනාං ශ්මශානගේහං නිර්ම්මාථ, සාධූනාං ශ්මශානනිකේතනං ශෝභයථ ");
INSERT INTO sansin_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","වදථ ච යදි වයං ස්වේෂාං පූර්ව්වපුරුෂාණාං කාල අස්ථාස්‍යාම, තර්හි භවිෂ්‍යද්වාදිනාං ශෝණිතපාතනේ තේෂාං සහභාගිනෝ නාභවිෂ්‍යාම| ");
INSERT INTO sansin_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","අතෝ යූයං භවිෂ්‍යද්වාදිඝාතකානාං සන්තානා ඉති ස්වයමේව ස්වේෂාං සාක්‍ෂ්‍යං දත්ථ| ");
INSERT INTO sansin_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","අතෝ යූයං නිජපූර්ව්වපුරුෂාණාං පරිමාණපාත්‍රං පරිපූරයත| ");
INSERT INTO sansin_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","රේ භුජගාඃ කෘෂ්ණභුජගවංශාඃ, යූයං කථං නරකදණ්ඩාද් රක්‍ෂිෂ්‍යධ්වේ| ");
INSERT INTO sansin_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","පශ්‍යත, යුෂ්මාකමන්තිකම් අහං භවිෂ්‍යද්වාදිනෝ බුද්ධිමත උපාධ්‍යායාංශ්ච ප්‍රේෂයිෂ්‍යාමි, කින්තු තේෂාං කතිපයා යුෂ්මාභි ර්ඝානිෂ්‍යන්තේ, ක්‍රුශේ ච ඝානිෂ්‍යන්තේ, කේචිද් භජනභවනේ කෂාභිරාඝානිෂ්‍යන්තේ, නගරේ නගරේ තාඩිෂ්‍යන්තේ ච; ");
INSERT INTO sansin_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","තේන සත්පුරුෂස්‍ය හාබිලෝ රක්තපාතමාරභ්‍ය බේරිඛියඃ පුත්‍රං යං සිඛරියං යූයං මන්දිරයඥවේද්‍යෝ ර්මධ්‍යේ හතවන්තඃ, තදීයශෝණිතපාතං යාවද් අස්මින් දේශේ යාවතාං සාධුපුරුෂාණාං ශෝණිතපාතෝ (අ)භවත් තත් සර්ව්වේෂාමාගසාං දණ්ඩා යුෂ්මාසු වර්ත්තිෂ්‍යන්තේ| ");
INSERT INTO sansin_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","අහං යුෂ්මාන්ත තථ්‍යං වදාමි, විද්‍යමානේ(අ)ස්මින් පුරුෂේ සර්ව්වේ වර්ත්තිෂ්‍යන්තේ| ");
INSERT INTO sansin_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","හේ යිරූශාලම් හේ යිරූශාලම් නගරි ත්වං භවිෂ්‍යද්වාදිනෝ හතවතී, තව සමීපං ප්‍රේරිතාංශ්ච පාෂාණෛරාහතවතී, යථා කුක්කුටී ශාවකාන් පක්‍ෂාධඃ සංගෘහ්ලාති, තථා තව සන්තානාන් සංග්‍රහීතුං අහං බහුවාරම් ඓච්ඡං; කින්තු ත්වං න සමමන්‍යථාඃ| ");
INSERT INTO sansin_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","පශ්‍යත යෂ්මාකං වාසස්ථානම් උච්ඡින්නං ත්‍යක්‍ෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","අහං යුෂ්මාන් තථ්‍යං වදාමි, යඃ පරමේශ්වරස්‍ය නාම්නාගච්ඡති, ස ධන්‍ය ඉති වාණීං යාවන්න වදිෂ්‍යථ, තාවත් මාං පුන ර්න ද්‍රක්‍ෂ්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","අනන්තරං යීශු ර‍්‍යදා මන්දිරාද් බහි ර්ගච්ඡති, තදානීං ශිෂ්‍යාස්තං මන්දිරනිර්ම්මාණං දර්ශයිතුමාගතාඃ| ");
INSERT INTO sansin_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","තතෝ යීශුස්තානුවාච, යූයං කිමේතානි න පශ්‍යථ? යුෂ්මානහං සත්‍යං වදාමි, ඒතන්නිචයනස්‍ය පාෂාණෛකමප්‍යන්‍යපාෂාණේाපරි න ස්ථාස්‍යති සර්ව්වාණි භූමිසාත් කාරිෂ්‍යන්තේ| ");
INSERT INTO sansin_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","අනන්තරං තස්මින් ජෛතුනපර්ව්වතෝපරි සමුපවිෂ්ටේ ශිෂ්‍යාස්තස්‍ය සමීපමාගත්‍ය ගුප්තං පප්‍රච්ඡුඃ, ඒතා ඝටනාඃ කදා භවිෂ්‍යන්ති? භවත ආගමනස්‍ය යුගාන්තස්‍ය ච කිං ලක්‍ෂ්ම? තදස්මාන් වදතු| ");
INSERT INTO sansin_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","තදානීං යීශුස්තානවෝචත්, අවධද්ව්වං, කෝපි යුෂ්මාන් න භ්‍රමයේත්| ");
INSERT INTO sansin_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","බහවෝ මම නාම ගෘහ්ලන්ත ආගමිෂ්‍යන්ති, ඛ්‍රීෂ්ටෝ(අ)හමේවේති වාචං වදන්තෝ බහූන් භ්‍රමයිෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","යූයඤ්ච සංග්‍රාමස්‍ය රණස්‍ය චාඩම්බරං ශ්‍රෝෂ්‍යථ, අවධද්ව්වං තේන චඤ්චලා මා භවත, ඒතාන්‍යවශ්‍යං ඝටිෂ්‍යන්තේ, කින්තු තදා යුගාන්තෝ නහි| ");
INSERT INTO sansin_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","අපරං දේශස්‍ය විපක්‍ෂෝ දේශෝ රාජ්‍යස්‍ය විපක්‍ෂෝ රාජ්‍යං භවිෂ්‍යති, ස්ථානේ ස්ථානේ ච දුර්භික්‍ෂං මහාමාරී භූකම්පශ්ච භවිෂ්‍යන්ති, ");
INSERT INTO sansin_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ඒතානි දුඃඛෝපක්‍රමාඃ| ");
INSERT INTO sansin_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","තදානීං ලෝකා දුඃඛං භෝජයිතුං යුෂ්මාන් පරකරේෂු සමර්පයිෂ්‍යන්ති හනිෂ්‍යන්ති ච, තථා මම නාමකාරණාද් යූයං සර්ව්වදේශීයමනුජානාං සමීපේ ඝෘණාර්හා භවිෂ්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","බහුෂු විඝ්නං ප්‍රාප්තවත්සු පරස්පරම් ඍृතීයාං කෘතවත්සු ච ඒකෝ(අ)පරං පරකරේෂු සමර්පයිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","තථා බහවෝ මෘෂාභවිෂ්‍යද්වාදින උපස්ථාය බහූන් භ්‍රමයිෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","දුෂ්කර්ම්මණාං බාහුල්‍යාඤ්ච බහූනාං ප්‍රේම ශීතලං භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","කින්තු යඃ කශ්චිත් ශේෂං යාවද් ධෛර‍්‍ය්‍යමාශ්‍රයතේ, සඒව පරිත්‍රායිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","අපරං සර්ව්වදේශීයලෝකාන් ප්‍රතිමාක්‍ෂී භවිතුං රාජස්‍ය ශුභසමාචාරඃ සර්ව්වජගති ප්‍රචාරිෂ්‍යතේ, ඒතාදෘශි සති යුගාන්ත උපස්ථාස්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","අතෝ යත් සර්ව්වනාශකෘද්ඝෘණාර්හං වස්තු දානියේල්භවිෂ්‍යද්වදිනා ප්‍රෝක්තං තද් යදා පුණ්‍යස්ථානේ ස්ථාපිතං ද්‍රක්‍ෂ්‍යථ, (යඃ පඨති, ස බුධ්‍යතාං) ");
INSERT INTO sansin_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","තදානීං යේ යිහූදීයදේශේ තිෂ්ඨන්ති, තේ පර්ව්වතේෂු පලායන්තාං| ");
INSERT INTO sansin_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","යඃ කශ්චිද් ගෘහපෘෂ්ඨේ තිෂ්ඨති, ස ගෘහාත් කිමපි වස්ත්වානේතුම් අධේा නාවරෝහේත්| ");
INSERT INTO sansin_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","යශ්ච ක්‍ෂේත්‍රේ තිෂ්ඨති, සෝපි වස්ත්‍රමානේතුං පරාවෘත්‍ය න යායාත්| ");
INSERT INTO sansin_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","තදානීං ගර්භිණීස්තන්‍යපායයිත්‍රීණාං දුර්ගති ර්භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","අතෝ යෂ්මාකං පලායනං ශීතකාලේ විශ්‍රාමවාරේ වා යන්න භවේත්, තදර්ථං ප්‍රාර්ථයධ්වම්| ");
INSERT INTO sansin_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ආ ජගදාරම්භාද් ඒතත්කාලපර‍්‍ය්‍යනන්තං යාදෘශඃ කදාපි නාභවත් න ච භවිෂ්‍යති තාදෘශෝ මහාක්ලේශස්තදානීම් උපස්ථාස්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","තස්‍ය ක්ලේශස්‍ය සමයෝ යදි හ්ස්වෝ න ක්‍රියේත, තර්හි කස්‍යාපි ප්‍රාණිනෝ රක්‍ෂණං භවිතුං න ශක්නුයාත්, කින්තු මනෝනීතමනුජානාං කෘතේ ස කාලෝ හ්ස්වීකරිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","අපරඤ්ච පශ්‍යත, ඛ්‍රීෂ්ටෝ(අ)ත්‍ර විද්‍යතේ, වා තත්‍ර විද්‍යතේ, තදානීං යදී කශ්චිද් යුෂ්මාන ඉති වාක්‍යං වදති, තථාපි තත් න ප්‍රතීත්| ");
INSERT INTO sansin_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","යතෝ භාක්තඛ්‍රීෂ්ටා භාක්තභවිෂ්‍යද්වාදිනශ්ච උපස්ථාය යානි මහන්ති ලක්‍ෂ්මාණි චිත්‍රකර්ම්මාණි ච ප්‍රකාශයිෂ්‍යන්ති, තෛ ර‍්‍යදි සම්භවේත් තර්හි මනෝනීතමානවා අපි භ්‍රාමිෂ්‍යන්තේ| ");
INSERT INTO sansin_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","පශ්‍යත, ඝටනාතඃ පූර්ව්වං යුෂ්මාන් වාර්ත්තාම් අවාදිෂම්| ");
INSERT INTO sansin_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","අතඃ පශ්‍යත, ස ප්‍රාන්තරේ විද්‍යත ඉති වාක්‍යේ කේනචිත් කථිතේපි බහි ර්මා ගච්ඡත, වා පශ්‍යත, සෝන්තඃපුරේ විද්‍යතේ, ඒතද්වාක්‍ය උක්තේපි මා ප්‍රතීත| ");
INSERT INTO sansin_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","යතෝ යථා විද්‍යුත් පූර්ව්වදිශෝ නිර්ගත්‍ය පශ්චිමදිශං යාවත් ප්‍රකාශතේ, තථා මානුෂපුත්‍රස්‍යාප්‍යාගමනං භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","යත්‍ර ශවස්තිෂ්ඨති, තත්‍රේව ගෘධ්‍රා මිලන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","අපරං තස්‍ය ක්ලේශසමයස්‍යාව්‍යවහිතපරත්‍ර සූර‍්‍ය්‍යස්‍ය තේජෝ ලෝප්ස්‍යතේ, චන්ද්‍රමා ජ්‍යෝස්නාං න කරිෂ්‍යති, නභසෝ නක්‍ෂත්‍රාණි පතිෂ්‍යන්ති, ගගණීයා ග්‍රහාශ්ච විචලිෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","තදානීම් ආකාශමධ්‍යේ මනුජසුතස්‍ය ලක්‍ෂ්ම දර්ශිෂ්‍යතේ, තතෝ නිජපරාක්‍රමේණ මහාතේජසා ච මේඝාරූඪං මනුජසුතං නභසාගච්ඡන්තං විලෝක්‍ය පෘථිව්‍යාඃ සර්ව්වවංශීයා විලපිෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","තදානීං ස මහාශබ්දායමානතූර‍්‍ය්‍යා වාදකාන් නිජදූතාන් ප්‍රහේෂ්‍යති, තේ ව්‍යෝම්න ඒකසීමාතෝ(අ)පරසීමාං යාවත් චතුර්දිශස්තස්‍ය මනෝනීතජනාන් ආනීය මේලයිෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","උඩුම්බරපාදපස්‍ය දෘෂ්ටාන්තං ශික්‍ෂධ්වං; යදා තස්‍ය නවීනාඃ ශාඛා ජායන්තේ, පල්ලවාදිශ්ච නිර්ගච්ඡති, තදා නිදාඝකාලඃ සවිධෝ භවතීති යූයං ජානීථ; ");
INSERT INTO sansin_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","තද්වද් ඒතා ඝටනා දෘෂ්ට්වා ස සමයෝ ද්වාර උපාස්ථාද් ඉති ජානීත| ");
INSERT INTO sansin_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","යුෂ්මානහං තථ්‍යං වදාමි, ඉදානීන්තනජනානාං ගමනාත් පූර්ව්වමේව තානි සර්ව්වාණි ඝටිෂ්‍යන්තේ| ");
INSERT INTO sansin_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","නභෝමේදින්‍යෝ ර්ලුප්තයෝරපි මම වාක් කදාපි න ලෝප්ස්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","අපරං මම තාතං විනා මානුෂඃ ස්වර්ගස්ථෝ දූතෝ වා කෝපි තද්දිනං තද්දණ්ඩඤ්ච න ඥාපයති| ");
INSERT INTO sansin_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","අපරං නෝහේ විද්‍යමානේ යාදෘශමභවත් තාදෘශං මනුජසුතස්‍යාගමනකාලේපි භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ඵලතෝ ජලාප්ලාවනාත් පූර්ව්වං යද්දිනං යාවත් නෝහඃ පෝතං නාරෝහත්, තාවත්කාලං යථා මනුෂ්‍යා භෝජනේ පානේ විවහනේ විවාහනේ ච ප්‍රවෘත්තා ආසන්; ");
INSERT INTO sansin_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","අපරම් ආප්ලාවිතෝයමාගත්‍ය යාවත් සකලමනුජාන් ප්ලාවයිත්වා නානයත්, තාවත් තේ යථා න විදාමාසුඃ, තථා මනුජසුතාගමනේපි භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","තදා ක්‍ෂේත්‍රස්ථිතයෝර්ද්වයෝරේකෝ ධාරිෂ්‍යතේ, අපරස්ත්‍යාජිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","තථා පේෂණ්‍යා පිංෂත්‍යෝරුභයෝ ර‍්‍යෝෂිතෝරේකා ධාරිෂ්‍යතේ(අ)පරා ත්‍යාජිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","යුෂ්මාකං ප්‍රභුඃ කස්මින් දණ්ඩ ආගමිෂ්‍යති, තද් යුෂ්මාභි ර්නාවගම්‍යතේ, තස්මාත් ජාග්‍රතඃ සන්තස්තිෂ්ඨත| ");
INSERT INTO sansin_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","කුත්‍ර යාමේ ස්තේන ආගමිෂ්‍යතීති චේද් ගෘහස්ථෝ ඥාතුම් අශක්‍ෂ්‍යත්, තර්හි ජාගරිත්වා තං සන්ධිං කර්ත්තිතුම් අවාරයිෂ්‍යත් තද් ජානීත| ");
INSERT INTO sansin_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","යුෂ්මාභිරවධීයතාං, යතෝ යුෂ්මාභි ර‍්‍යත්‍ර න බුධ්‍යතේ, තත්‍රෛව දණ්ඩේ මනුජසුත ආයාස්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","ප්‍රභු ර්නිජපරිවාරාන් යථාකාලං භෝජයිතුං යං දාසම් අධ්‍යක්‍ෂීකෘත්‍ය ස්ථාපයති, තාදෘශෝ විශ්වාස්‍යෝ ධීමාන් දාසඃ කඃ? ");
INSERT INTO sansin_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ප්‍රභුරාගත්‍ය යං දාසං තථාචරන්තං වීක්‍ෂතේ, සඒව ධන්‍යඃ| ");
INSERT INTO sansin_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","යුෂ්මානහං සත්‍යං වදාමි, ස තං නිජසර්ව්වස්වස්‍යාධිපං කරිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","කින්තු ප්‍රභුරාගන්තුං විලම්බත ඉති මනසි චින්තයිත්වා යෝ දුෂ්ටෝ දාසෝ ");
INSERT INTO sansin_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","(අ)පරදාසාන් ප්‍රහර්ත්තුං මත්තානාං සඞ්ගේ භෝක්තුං පාතුඤ්ච ප්‍රවර්ත්තතේ, ");
INSERT INTO sansin_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ස දාසෝ යදා නාපේක්‍ෂතේ, යඤ්ච දණ්ඩං න ජානාති, තත්කාලඒව තත්ප්‍රභුරුපස්ථාස්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","තදා තං දණ්ඩයිත්වා යත්‍ර ස්ථානේ රෝදනං දන්තඝර්ෂණඤ්චාසාතේ, තත්‍ර කපටිභිඃ සාකං තද්දශාං නිරූපයිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","යා දශ කන්‍යාඃ ප්‍රදීපාන් ගෘහ්ලත්‍යෝ වරං සාක්‍ෂාත් කර්ත්තුං බහිරිතාඃ, තාභිස්තදා ස්වර්ගීයරාජ්‍යස්‍ය සාදෘශ්‍යං භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","තාසාං කන්‍යානාං මධ්‍යේ පඤ්ච සුධියඃ පඤ්ච දුර්ධිය ආසන්| ");
INSERT INTO sansin_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","යා දුර්ධියස්තාඃ ප්‍රදීපාන් සඞ්ගේ ගෘහීත්වා තෛලං න ජගෘහුඃ, ");
INSERT INTO sansin_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","කින්තු සුධියඃ ප්‍රදීපාන් පාත්‍රේණ තෛලඤ්ච ජගෘහුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","අනන්තරං වරේ විලම්බිතේ තාඃ සර්ව්වා නිද්‍රාවිෂ්ටා නිද්‍රාං ජග්මුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","අනන්තරම් අර්ද්ධරාත්‍රේ පශ්‍යත වර ආගච්ඡති, තං සාක්‍ෂාත් කර්ත්තුං බහිර‍්‍යාතේති ජනරවාත් ");
INSERT INTO sansin_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","තාඃ සර්ව්වාඃ කන්‍යා උත්ථාය ප්‍රදීපාන් ආසාදයිතුං ආරභන්ත| ");
INSERT INTO sansin_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","තතෝ දුර්ධියඃ සුධිය ඌචුඃ, කිඤ්චිත් තෛලං දත්ත, ප්‍රදීපා අස්මාකං නිර්ව්වාණාඃ| ");
INSERT INTO sansin_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","කින්තු සුධියඃ ප්‍රත්‍යවදන්, දත්තේ යුෂ්මානස්මාංශ්ච ප්‍රති තෛලං න්‍යූනීභවේත්, තස්මාද් වික්‍රේතෘණාං සමීපං ගත්වා ස්වාර්ථං තෛලං ක්‍රීණීත| ");
INSERT INTO sansin_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","තදා තාසු ක්‍රේතුං ගතාසු වර ආජගාම, තතෝ යාඃ සජ්ජිතා ආසන්, තාස්තේන සාකං විවාහීයං වේශ්ම ප්‍රවිවිශුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","අනන්තරං ද්වාරේ රුද්ධේ අපරාඃ කන්‍යා ආගත්‍ය ජගදුඃ, හේ ප්‍රභෝ, හේ ප්‍රභෝ, අස්මාන් ප්‍රති ද්වාරං මෝචය| ");
INSERT INTO sansin_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","කින්තු ස උක්තවාන්, තථ්‍යං වදාමි, යුෂ්මානහං න වේද්මි| ");
INSERT INTO sansin_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","අතෝ ජාග්‍රතඃ සන්තස්තිෂ්ඨත, මනුජසුතඃ කස්මින් දිනේ කස්මින් දණ්ඩේ වාගමිෂ්‍යති, තද් යුෂ්මාභි ර්න ඥායතේ| ");
INSERT INTO sansin_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","අපරං ස ඒතාදෘශඃ කස්‍යචිත් පුංසස්තුල්‍යඃ, යෝ දූරදේශං ප්‍රති යාත්‍රාකාලේ නිජදාසාන් ආහූය තේෂාං ස්වස්වසාමර්ථ්‍යානුරූපම් ");
INSERT INTO sansin_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ඒකස්මින් මුද්‍රාණාං පඤ්ච පෝටලිකාඃ අන්‍යස්මිංශ්ච ද්වේ පෝටලිකේ අපරස්මිංශ්ච පෝටලිකෛකාම් ඉත්ථං ප්‍රතිජනං සමර්ප්‍ය ස්වයං ප්‍රවාසං ගතවාන්| ");
INSERT INTO sansin_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","අනන්තරං යෝ දාසඃ පඤ්ච පෝටලිකාඃ ලබ්ධවාන්, ස ගත්වා වාණිජ්‍යං විධාය තා ද්විගුණීචකාර| ");
INSERT INTO sansin_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","යශ්ච දාසෝ ද්වේ පෝටලිකේ අලභත, සෝපි තා මුද්‍රා ද්විගුණීචකාර| ");
INSERT INTO sansin_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","කින්තු යෝ දාස ඒකාං පෝටලිකාං ලබ්ධවාන්, ස ගත්වා භූමිං ඛනිත්වා තන්මධ්‍යේ නිජප්‍රභෝස්තා මුද්‍රා ගෝපයාඤ්චකාර| ");
INSERT INTO sansin_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","තදනන්තරං බහුතිථේ කාලේ ගතේ තේෂාං දාසානාං ප්‍රභුරාගත්‍ය තෛර්දාසෛඃ සමං ගණයාඤ්චකාර| ");
INSERT INTO sansin_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","තදානීං යඃ පඤ්ච පෝටලිකාඃ ප්‍රාප්තවාන් ස තා ද්විගුණීකෘතමුද්‍රා ආනීය ජගාද; හේ ප්‍රභෝ, භවතා මයි පඤ්ච පෝටලිකාඃ සමර්පිතාඃ, පශ්‍යතු, තා මයා ද්විගුණීකෘතාඃ| ");
INSERT INTO sansin_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","තදානීං තස්‍ය ප්‍රභුස්තමුවාච, හේ උත්තම විශ්වාස්‍ය දාස, ත්වං ධන්‍යෝසි, ස්තෝකේන විශ්වාස්‍යෝ ජාතඃ, තස්මාත් ත්වාං බහුවිත්තාධිපං කරෝමි, ත්වං ස්වප්‍රභෝඃ සුඛස්‍ය භාගී භව| ");
INSERT INTO sansin_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","තතෝ යේන ද්වේ පෝටලිකේ ලබ්ධේ සෝප්‍යාගත්‍ය ජගාද, හේ ප්‍රභෝ, භවතා මයි ද්වේ පෝටලිකේ සමර්පිතේ, පශ්‍යතු තේ මයා ද්විගුණීකෘතේ| ");
INSERT INTO sansin_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","තේන තස්‍ය ප්‍රභුස්තමවෝචත්, හේ උත්තම විශ්වාස්‍ය දාස, ත්වං ධන්‍යෝසි, ස්තෝකේන විශ්වාස්‍යෝ ජාතඃ, තස්මාත් ත්වාං බහුද්‍රවිණාධිපං කරෝමි, ත්වං නිජප්‍රභෝඃ සුඛස්‍ය භාගී භව| ");
INSERT INTO sansin_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","අනන්තරං ය ඒකාං පෝටලිකාං ලබ්ධවාන්, ස ඒත්‍ය කථිතවාන්, හේ ප්‍රභෝ, ත්වාං කඨිනනරං ඥාතවාන්, ත්වයා යත්‍ර නෝප්තං, තත්‍රෛව කෘත්‍යතේ, යත්‍ර ච න කීර්ණං, තත්‍රෛව සංගෘහ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","අතෝහං සශඞ්කඃ සන් ගත්වා තව මුද්‍රා භූමධ්‍යේ සංගෝප්‍ය ස්ථාපිතවාන්, පශ්‍ය, තව යත් තදේව ගෘහාණ| ");
INSERT INTO sansin_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","තදා තස්‍ය ප්‍රභුඃ ප්‍රත්‍යවදත් රේ දුෂ්ටාලස දාස, යත්‍රාහං න වපාමි, තත්‍ර ඡිනද්මි, යත්‍ර ච න කිරාමි, තත්‍රේව සංගෘහ්ලාමීති චේදජානාස්තර්හි ");
INSERT INTO sansin_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","වණික්‍ෂු මම විත්තාර්පණං තවෝචිතමාසීත්, යේනාහමාගත්‍ය වෘද්ව්‍යා සාකං මූලමුද්‍රාඃ ප්‍රාප්ස්‍යම්| ");
INSERT INTO sansin_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","අතෝස්මාත් තාං පෝටලිකාම් ආදාය යස්‍ය දශ පෝටලිකාඃ සන්ති තස්මින්නර්පයත| ");
INSERT INTO sansin_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","යේන වර්ද්ව්‍යතේ තස්මින්නෛවාර්පිෂ්‍යතේ, තස්‍යෛව ච බාහුල්‍යං භවිෂ්‍යති, කින්තු යේන න වර්ද්ව්‍යතේ, තස්‍යාන්තිකේ යත් කිඤ්චන තිෂ්ඨති, තදපි පුනර්නේෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","අපරං යූයං තමකර්ම්මණ්‍යං දාසං නීත්වා යත්‍ර ස්ථානේ ක්‍රන්දනං දන්තඝර්ෂණඤ්ච විද්‍යේතේ, තස්මින් බහිර්භූතතමසි නික්‍ෂිපත| ");
INSERT INTO sansin_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","යදා මනුජසුතඃ පවිත්‍රදූතාන් සඞ්ගිනඃ කෘත්වා නිජප්‍රභාවේනාගත්‍ය නිජතේජෝමයේ සිංහාසනේ නිවේක්‍ෂ්‍යති, ");
INSERT INTO sansin_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","තදා තත්සම්මුඛේ සර්ව්වජාතීයා ජනා සංමේලිෂ්‍යන්ති| තතෝ මේෂපාලකෝ යථා ඡාගේභ්‍යෝ(අ)වීන් පෘථක් කරෝති තථා සෝප්‍යේකස්මාදන්‍යම් ඉත්ථං තාන් පෘථක කෘත්වාවීන් ");
INSERT INTO sansin_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","දක්‍ෂිණේ ඡාගාංශ්ච වාමේ ස්ථාපයිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","තතඃ පරං රාජා දක්‍ෂිණස්ථිතාන් මානවාන් වදිෂ්‍යති, ආගච්ඡත මත්තාතස්‍යානුග්‍රහභාජනානි, යුෂ්මත්කෘත ආ ජගදාරම්භත් යද් රාජ්‍යම් ආසාදිතං තදධිකුරුත| ");
INSERT INTO sansin_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","යතෝ බුභුක්‍ෂිතාය මහ්‍යං භෝජ්‍යම් අදත්ත, පිපාසිතාය පේයමදත්ත, විදේශිනං මාං ස්වස්ථානමනයත, ");
INSERT INTO sansin_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","වස්ත්‍රහීනං මාං වසනං පර‍්‍ය්‍යධාපයත, පීඩීතං මාං ද්‍රෂ්ටුමාගච්ඡත, කාරාස්ථඤ්ච මාං වීක්‍ෂිතුම ආගච්ඡත| ");
INSERT INTO sansin_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","තදා ධාර්ම්මිකාඃ ප්‍රතිවදිෂ්‍යන්ති, හේ ප්‍රභෝ, කදා ත්වාං ක්‍ෂුධිතං වීක්‍ෂ්‍ය වයමභෝජයාම? වා පිපාසිතං වීක්‍ෂ්‍ය අපායයාම? ");
INSERT INTO sansin_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","කදා වා ත්වාං විදේශිනං විලෝක්‍ය ස්වස්ථානමනයාම? කදා වා ත්වාං නග්නං වීක්‍ෂ්‍ය වසනං පර‍්‍ය්‍යධාපයාම? ");
INSERT INTO sansin_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","කදා වා ත්වාං පීඩිතං කාරාස්ථඤ්ච වීක්‍ෂ්‍ය ත්වදන්තිකමගච්ඡාම? ");
INSERT INTO sansin_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","තදානීං රාජා තාන් ප්‍රතිවදිෂ්‍යති, යුෂ්මානහං සත්‍යං වදාමි, මමෛතේෂාං භ්‍රාතෘණාං මධ්‍යේ කඤ්චනෛකං ක්‍ෂුද්‍රතමං ප්‍රති යද් අකුරුත, තන්මාං ප්‍රත්‍යකුරුත| ");
INSERT INTO sansin_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","පශ්චාත් ස වාමස්ථිතාන් ජනාන් වදිෂ්‍යති, රේ ශාපග්‍රස්තාඃ සර්ව්වේ, ශෛතානේ තස්‍ය දූතේභ්‍යශ්ච යෝ(අ)නන්තවහ්නිරාසාදිත ආස්තේ, යූයං මදන්තිකාත් තමග්නිං ගච්ඡත| ");
INSERT INTO sansin_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","යතෝ ක්‍ෂුධිතාය මහ්‍යමාහාරං නාදත්ත, පිපාසිතාය මහ්‍යං පේයං නාදත්ත, ");
INSERT INTO sansin_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","විදේශිනං මාං ස්වස්ථානං නානයත, වසනහීනං මාං වසනං න පර‍්‍ය්‍යධාපයත, පීඩිතං කාරාස්ථඤ්ච මාං වීක්‍ෂිතුං නාගච්ඡත| ");
INSERT INTO sansin_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","තදා තේ ප්‍රතිවදිෂ්‍යන්ති, හේ ප්‍රභෝ, කදා ත්වාං ක්‍ෂුධිතං වා පිපාසිතං වා විදේශිනං වා නග්නං වා පීඩිතං වා කාරාස්ථං වීක්‍ෂ්‍ය ත්වාං නාසේවාමහි? ");
INSERT INTO sansin_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","තදා ස තාන් වදිෂ්‍යති, තථ්‍යමහං යුෂ්මාන් බ්‍රවීමි, යුෂ්මාභිරේෂාං කඤ්චන ක්‍ෂෝදිෂ්ඨං ප්‍රති යන්නාකාරි, තන්මාං ප්‍රත්‍යේව නාකාරි| ");
INSERT INTO sansin_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","පශ්චාදම්‍යනන්තශාස්තිං කින්තු ධාර්ම්මිකා අනන්තායුෂං භෝක්තුං යාස්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","යීශුරේතාන් ප්‍රස්තාවාන් සමාප්‍ය ශිෂ්‍යානූචේ, ");
INSERT INTO sansin_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","යුෂ්මාභි ර්ඥාතං දිනද්වයාත් පරං නිස්තාරමහ උපස්ථාස්‍යති, තත්‍ර මනුජසුතඃ ක්‍රුශේන හන්තුං පරකරේෂු සමර්පිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","තතඃ පරං ප්‍රධානයාජකාධ්‍යාපකප්‍රාඤ්චඃ කියඵානාම්නෝ මහායාජකස්‍යාට්ටාලිකායාං මිලිත්වා ");
INSERT INTO sansin_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","කේනෝපායේන යීශුං ධෘත්වා හන්තුං ශක්නුයුරිති මන්ත්‍රයාඤ්චක්‍රුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","කින්තු තෛරුක්තං මහකාලේ න ධර්ත්තව්‍යඃ, ධෘතේ ප්‍රජානාං කලහේන භවිතුං ශක්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","තතෝ බෛථනියාපුරේ ශිමෝනාඛ්‍යස්‍ය කුෂ්ඨිනෝ වේශ්මනි යීශෞ තිෂ්ඨති ");
INSERT INTO sansin_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","කාචන යෝෂා ශ්වේතෝපලභාජනේන මහාර්ඝ්‍යං සුගන්ධි තෛලමානීය භෝජනායෝපවිශතස්තස්‍ය ශිරෝභ්‍යෂේචත්| ");
INSERT INTO sansin_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","කින්තු තදාලෝක්‍ය තච්ඡිෂ්‍යෛඃ කුපිතෛරුක්තං, කුත ඉත්ථමපව්‍යයතේ? ");
INSERT INTO sansin_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","චේදිදං ව්‍යක්‍රේෂ්‍යත, තර්හි භූරිමූල්‍යං ප්‍රාප්‍ය දරිද්‍රේභ්‍යෝ ව්‍යතාරිෂ්‍යත| ");
INSERT INTO sansin_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","යීශුනා තදවගත්‍ය තේ සමුදිතාඃ, යෝෂාමේනාං කුතෝ දුඃඛිනීං කුරුථ, සා මාං ප්‍රති සාධු කර්ම්මාකාර්ෂීත්| ");
INSERT INTO sansin_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","යුෂ්මාකමං සමීපේ දරිද්‍රාඃ සතතමේවාසතේ, කින්තු යුෂ්මාකමන්තිකේහං නාසේ සතතං| ");
INSERT INTO sansin_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","සා මම කායෝපරි සුගන්ධිතෛලං සික්ත්වා මම ශ්මශානදානකර්ම්මාකාර්ෂීත්| ");
INSERT INTO sansin_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","අතෝහං යුෂ්මාන් තථ්‍යං වදාමි සර්ව්වස්මින් ජගති යත්‍ර යත්‍රෛෂ සුසමාචාරඃ ප්‍රචාරිෂ්‍යතේ, තත්‍ර තත්‍රෛතස්‍යා නාර‍්‍ය්‍යාඃ ස්මරණාර්ථම් කර්ම්මේදං ප්‍රචාරිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","තතෝ ද්වාදශශිෂ්‍යාණාම් ඊෂ්කරියෝතීයයිහූදානාමක ඒකඃ ශිෂ්‍යඃ ප්‍රධානයාජකානාමන්තිකං ගත්වා කථිතවාන්, ");
INSERT INTO sansin_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","යදි යුෂ්මාකං කරේෂු යීශුං සමර්පයාමි, තර්හි කිං දාස්‍යථ? තදානීං තේ තස්මෛ ත්‍රිංශන්මුද්‍රා දාතුං ස්ථිරීකෘතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ස තදාරභ්‍ය තං පරකරේෂු සමර්පයිතුං සුයෝගං චේෂ්ටිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","අනන්තරං කිණ්වශූන්‍යපූපපර්ව්වණඃ ප්‍රථමේහ්නි ශිෂ්‍යා යීශුම් උපගත්‍ය පප්‍රච්ඡුඃ භවත්කෘතේ කුත්‍ර වයං නිස්තාරමහභෝජ්‍යම් ආයෝජයිෂ්‍යාමඃ? භවතඃ කේච්ඡා? ");
INSERT INTO sansin_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","තදා ස ගදිතවාන්, මධ්‍යේනගරමමුකපුංසඃ සමීපං ව්‍රජිත්වා වදත, ගුරු ර්ගදිතවාන්, මත්කාලඃ සවිධඃ, සහ ශිෂ්‍යෛස්ත්වදාලයේ නිස්තාරමහභෝජ්‍යං භෝක්‍ෂ්‍යේ| ");
INSERT INTO sansin_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","තදා ශිෂ්‍යා යීශෝස්තාදෘශනිදේශානුරූපකර්ම්ම විධාය තත්‍ර නිස්තාරමහභෝජ්‍යමාසාදයාමාසුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","තතඃ සන්ධ්‍යායාං සත්‍යාං ද්වාදශභිඃ ශිෂ්‍යෛඃ සාකං ස න්‍යවිශත්| ");
INSERT INTO sansin_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","අපරං භුඤ්ජාන උක්තවාන් යුෂ්මාන් තථ්‍යං වදාමි, යුෂ්මාකමේකෝ මාං පරකරේෂු සමර්පයිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","තදා තේ(අ)තීව දුඃඛිතා ඒකෛකශෝ වක්තුමාරේභිරේ, හේ ප්‍රභෝ, ස කිමහං? ");
INSERT INTO sansin_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","තතඃ ස ජගාද, මයා සාකං යෝ ජනෝ භෝජනපාත්‍රේ කරං සංක්‍ෂිපති, ස ඒව මාං පරකරේෂු සමර්පයිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","මනුජසුතමධි යාදෘශං ලිඛිතමාස්තේ, තදනුරූපා තද්ගති ර්භවිෂ්‍යති; කින්තු යේන පුංසා ස පරකරේෂු සමර්පයිෂ්‍යතේ, හා හා චේත් ස නාජනිෂ්‍යත, තදා තස්‍ය ක්‍ෂේමමභවිෂ්‍යත්| ");
INSERT INTO sansin_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","තදා යිහූදානාමා යෝ ජනස්තං පරකරේෂු සමර්පයිෂ්‍යති, ස උක්තවාන්, හේ ගුරෝ, ස කිමහං? තතඃ ස ප්‍රත්‍යුක්තවාන්, ත්වයා සත්‍යං ගදිතම්| ");
INSERT INTO sansin_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","අනන්තරං තේෂාමශනකාලේ යීශුඃ පූපමාදායේශ්වරීයගුණානනූද්‍ය භංක්ත්වා ශිෂ්‍යේභ්‍යඃ ප්‍රදාය ජගාද, මද්වපුඃස්වරූපමිමං ගෘහීත්වා ඛාදත| ");
INSERT INTO sansin_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","පශ්චාත් ස කංසං ගෘහ්ලන් ඊශ්වරීයගුණානනූද්‍ය තේභ්‍යඃ ප්‍රදාය කථිතවාන්, සර්ව්වෛ ර‍්‍යුෂ්මාභිරනේන පාතව්‍යං, ");
INSERT INTO sansin_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","යස්මාදනේකේෂාං පාපමර්ෂණාය පාතිතං යන්මන්නූත්නනියමරූපශෝණිතං තදේතත්| ");
INSERT INTO sansin_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","අපරමහං නූත්නගෝස්තනීරසං න පාස්‍යාමි, තාවත් ගෝස්තනීඵලරසං පුනඃ කදාපි න පාස්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","පශ්චාත් තේ ගීතමේකං සංගීය ජෛතුනාඛ්‍යගිරිං ගතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","තදානීං යීශුස්තානවෝචත්, අස්‍යාං රජන්‍යාමහං යුෂ්මාකං සර්ව්වේෂාං විඝ්නරූපෝ භවිෂ්‍යාමි, යතෝ ලිඛිතමාස්තේ, \"මේෂාණාං රක්‍ෂකෝ යස්තං ප්‍රහරිෂ්‍යාම්‍යහං තතඃ| මේෂාණාං නිවහෝ නූනං ප්‍රවිකීර්ණෝ භවිෂ්‍යති\"|| ");
INSERT INTO sansin_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","කින්තු ශ්මශානාත් සමුත්ථාය යුෂ්මාකමග්‍රේ(අ)හං ගාලීලං ගමිෂ්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","පිතරස්තං ප්‍රෝවාච, භවාංශ්චේත් සර්ව්වේෂාං විඝ්නරූපෝ භවති, තථාපි මම න භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","තතෝ යීශුනා ස උක්තඃ, තුභ්‍යමහං තථ්‍යං කථයාමි, යාමින්‍යාමස්‍යාං චරණායුධස්‍ය රවාත් පූර්ව්වං ත්වං මාං ත්‍රි ර්නාඞ්ගීකරිෂ්‍යසි| ");
INSERT INTO sansin_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","තතඃ පිතර උදිතවාන්, යද්‍යපි ත්වයා සමං මර්ත්තව්‍යං, තථාපි කදාපි ත්වාං න නාඞ්ගීකරිෂ්‍යාමි; තථෛව සර්ව්වේ ශිෂ්‍යාශ්චෝචුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","අනන්තරං යීශුඃ ශිෂ්‍යෛඃ සාකං ගේත්ශිමානීනාමකං ස්ථානං ප්‍රස්ථාය තේභ්‍යඃ කථිතවාන්, අදඃ ස්ථානං ගත්වා යාවදහං ප්‍රාර්ථයිෂ්‍යේ තාවද් යූයමත්‍රෝපවිශත| ");
INSERT INTO sansin_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","පශ්චාත් ස පිතරං සිවදියසුතෞ ච සඞ්ගිනඃ කෘත්වා ගතවාන්, ශෝකාකුලෝ(අ)තීව ව්‍යථිතශ්ච බභූව| ");
INSERT INTO sansin_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","තානවාදීච්ච මෘතියාතනේව මත්ප්‍රාණානාං යාතනා ජායතේ, යූයමත්‍ර මයා සාර්ද්ධං ජාගෘත| ");
INSERT INTO sansin_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","තතඃ ස කිඤ්චිද්දූරං ගත්වාධෝමුඛඃ පතන් ප්‍රාර්ථයාඤ්චක්‍රේ, හේ මත්පිතර‍්‍යදි භවිතුං ශක්නෝති, තර්හි කංසෝ(අ)යං මත්තෝ දූරං යාතු; කින්තු මදිච්ඡාවත් න භවතු, ත්වදිච්ඡාවද් භවතු| ");
INSERT INTO sansin_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","තතඃ ස ශිෂ්‍යානුපේත්‍ය තාන් නිද්‍රතෝ නිරීක්‍ෂ්‍ය පිතරාය කථයාමාස, යූයං මයා සාකං දණ්ඩමේකමපි ජාගරිතුං නාශන්කුත? ");
INSERT INTO sansin_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","පරීක්‍ෂායාං න පතිතුං ජාගෘත ප්‍රාර්ථයධ්වඤ්ච; ආත්මා සමුද්‍යතෝස්ති, කින්තු වපු ර්දුර්බ්බලං| ");
INSERT INTO sansin_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ස ද්විතීයවාරං ප්‍රාර්ථයාඤ්චක්‍රේ, හේ මත්තාත, න පීතේ යදි කංසමිදං මත්තෝ දූරං යාතුං න ශක්නෝති, තර්හි ත්වදිච්ඡාවද් භවතු| ");
INSERT INTO sansin_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ස පුනරේත්‍ය තාන් නිද්‍රතෝ දදර්ශ, යතස්තේෂාං නේත්‍රාණි නිද්‍රයා පූර්ණාන්‍යාසන්| ");
INSERT INTO sansin_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","පශ්චාත් ස තාන් විහාය ව්‍රජිත්වා තෘතීයවාරං පූර්ව්වවත් කථයන් ප්‍රාර්ථිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","තතඃ ශිෂ්‍යානුපාගත්‍ය ගදිතවාන්, සාම්ප්‍රතං ශයානාඃ කිං විශ්‍රාම්‍යථ? පශ්‍යත, සමය උපාස්ථාත්, මනුජසුතඃ පාපිනාං කරේෂු සමර්ප්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","උත්තිෂ්ඨත, වයං යාමඃ, යෝ මාං පරකරේෂු මසර්පයිෂ්‍යති, පශ්‍යත, ස සමීපමායාති| ");
INSERT INTO sansin_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ඒතත්කථාකථනකාලේ ද්වාදශශිෂ්‍යාණාමේකෝ යිහූදානාමකෝ මුඛ්‍යයාජකලෝකප්‍රාචීනෛඃ ප්‍රහිතාන් අසිධාරියෂ්ටිධාරිණෝ මනුජාන් ගෘහීත්වා තත්සමීපමුපතස්ථෞ| ");
INSERT INTO sansin_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","අසෞ පරකරේෂ්වර්පයිතා පූර්ව්වං තාන් ඉත්ථං සඞ්කේතයාමාස, යමහං චුම්බිෂ්‍යේ, සෝ(අ)සෞ මනුජඃ,සඒව යුෂ්මාභි ර්ධාර‍්‍ය්‍යතාං| ");
INSERT INTO sansin_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","තදා ස සපදි යීශුමුපාගත්‍ය හේ ගුරෝ, ප්‍රණමාමීත්‍යුක්ත්වා තං චුචුම්බේ| ");
INSERT INTO sansin_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","තදා යීශුස්තමුවාච, හේ මිත්‍රං කිමර්ථමාගතෝසි? තදා තෛරාගත්‍ය යීශුරාක්‍රම්‍ය දඝ්‍රේ| ");
INSERT INTO sansin_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","තතෝ යීශෝඃ සඞ්ගිනාමේකඃ කරං ප්‍රසාර‍්‍ය්‍ය කෝෂාදසිං බහිෂ්කෘත්‍ය මහායාජකස්‍ය දාසමේකමාහත්‍ය තස්‍ය කර්ණං චිච්ඡේද| ");
INSERT INTO sansin_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","තතෝ යීශුස්තං ජගාද, ඛඩ්ගං ස්වස්ථානේे නිධේහි යතෝ යේ යේ ජනා අසිං ධාරයන්ති, තඒවාසිනා විනශ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","අපරං පිතා යථා මදන්තිකං ස්වර්ගීයදූතානාං ද්වාදශවාහිනීතෝ(අ)ධිකං ප්‍රහිණුයාත් මයා තමුද්දිශ්‍යේදානීමේව තථා ප්‍රාර්ථයිතුං න ශක්‍යතේ, ත්වයා කිමිත්ථං ඥායතේ? ");
INSERT INTO sansin_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","තථා සතීත්ථං ඝටිෂ්‍යතේ ධර්ම්මපුස්තකස්‍ය යදිදං වාක්‍යං තත් කථං සිධ්‍යේත්? ");
INSERT INTO sansin_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","තදානීං යීශු ර්ජනනිවහං ජගාද, යූයං ඛඩ්ගයෂ්ටීන් ආදාය මාං කිං චෞරං ධර්ත්තුමායාතාඃ? අහං ප්‍රත්‍යහං යුෂ්මාභිඃ සාකමුපවිශ්‍ය සමුපාදිශං, තදා මාං නාධරත; ");
INSERT INTO sansin_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","කින්තු භවිෂ්‍යද්වාදිනාං වාක්‍යානාං සංසිද්ධයේ සර්ව්වමේතදභූත්| තදා සර්ව්වේ ශිෂ්‍යාස්තං විහාය පලායන්ත| ");
INSERT INTO sansin_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","අනන්තරං තේ මනුජා යීශුං ධෘත්වා යත්‍රාධ්‍යාපකප්‍රාඤ්චඃ පරිෂදං කුර්ව්වන්ත උපාවිශන් තත්‍ර කියඵානාाමකමහායාජකස්‍යාන්තිකං නින්‍යුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","කින්තු ශේෂේ කිං භවිෂ්‍යතීති වේත්තුං පිතරෝ දූරේ තත්පශ්චාද් ව්‍රජිත්වා මහායාජකස්‍යාට්ටාලිකාං ප්‍රවිශ්‍ය දාසෛඃ සහිත උපාවිශත්| ");
INSERT INTO sansin_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","තදානීං ප්‍රධානයාජකප්‍රාචීනමන්ත්‍රිණඃ සර්ව්වේ යීශුං හන්තුං මෘෂාසාක්‍ෂ්‍යම් අලිප්සන්ත, ");
INSERT INTO sansin_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","කින්තු න ලේභිරේ| අනේකේෂු මෘෂාසාක්‍ෂිෂ්වාගතේෂ්වපි තන්න ප්‍රාපුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ශේෂේ ද්වෞ මෘෂාසාක්‍ෂිණාවාගත්‍ය ජගදතුඃ, පුමානයමකථයත්, අහමීශ්වරමන්දිරං භංක්ත්වා දිනත්‍රයමධ්‍යේ තන්නිර්ම්මාතුං ශක්නෝමි| ");
INSERT INTO sansin_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","තදා මහායාජක උත්ථාය යීශුම් අවාදීත්| ත්වං කිමපි න ප්‍රතිවදසි? ත්වාමධි කිමේතේ සාක්‍ෂ්‍යං වදන්ති? ");
INSERT INTO sansin_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","කින්තු යීශු ර්මෞනීභූය තස්‍යෞ| තතෝ මහායාජක උක්තවාන්, ත්වාම් අමරේශ්වරනාම්නා ශපයාමි, ත්වමීශ්වරස්‍ය පුත්‍රෝ(අ)භිෂික්තෝ භවසි නවේති වද| ");
INSERT INTO sansin_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","යීශුඃ ප්‍රත්‍යවදත්, ත්වං සත්‍යමුක්තවාන්; අහං යුෂ්මාන් තථ්‍යං වදාමි, ඉතඃපරං මනුජසුතං සර්ව්වශක්තිමතෝ දක්‍ෂිණපාර්ශ්වේ ස්ථාතුං ගගණස්ථං ජලධරානාරුහ්‍යායාන්තං වීක්‍ෂධ්වේ| ");
INSERT INTO sansin_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","තදා මහායාජකෝ නිජවසනං ඡිත්ත්වා ජගාද, ඒෂ ඊශ්වරං නින්දිතවාන්, අස්මාකමපරසාක්‍ෂ්‍යේණ කිං ප්‍රයෝජනං? පශ්‍යත, යූයමේවාස්‍යාස්‍යාද් ඊශ්වරනින්දාං ශ්‍රුතවන්තඃ, ");
INSERT INTO sansin_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","යුෂ්මාභිඃ කිං විවිච්‍යතේ? තේ ප්‍රත්‍යූචුඃ, වධාර්හෝ(අ)යං| ");
INSERT INTO sansin_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","තතෝ ලෝකෛස්තදාස්‍යේ නිෂ්ඨීවිතං කේචිත් ප්‍රතලමාහත්‍ය කේචිච්ච චපේටමාහත්‍ය බභාෂිරේ, ");
INSERT INTO sansin_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","හේ ඛ්‍රීෂ්ට ත්වාං කශ්චපේටමාහතවාන්? ඉති ගණයිත්වා වදාස්මාන්| ");
INSERT INTO sansin_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","පිතරෝ බහිරඞ්ගන උපවිශති, තදානීමේකා දාසී තමුපාගත්‍ය බභාෂේ, ත්වං ගාලීලීයයීශෝඃ සහචරඒකඃ| ");
INSERT INTO sansin_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","කින්තු ස සර්ව්වේෂාං සමක්‍ෂම් අනඞ්ගීකෘත්‍යාවාදීත්, ත්වයා යදුච්‍යතේ, තදර්ථමහං න වේද්මි| ");
INSERT INTO sansin_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","තදා තස්මින් බහිර්ද්වාරං ගතේ (අ)න්‍යා දාසී තං නිරීක්‍ෂ්‍ය තත්‍රත්‍යජනානවදත්, අයමපි නාසරතීයයීශුනා සාර්ද්ධම් ආසීත්| ");
INSERT INTO sansin_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","තතඃ ස ශපථේන පුනරනඞ්ගීකෘත්‍ය කථිතවාන්, තං නරං න පරිචිනෝමි| ");
INSERT INTO sansin_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ක්‍ෂණාත් පරං තිෂ්ඨන්තෝ ජනා ඒත්‍ය පිතරම් අවදන්, ත්වමවශ්‍යං තේෂාමේක ඉති ත්වදුච්චාරණමේව ද්‍යෝතයති| ");
INSERT INTO sansin_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","කින්තු සෝ(අ)භිශප්‍ය කථිතවාන්, තං ජනං නාහං පරිචිනෝමි, තදා සපදි කුක්කුටෝ රුරාව| ");
INSERT INTO sansin_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","කුක්කුටරවාත් ප්‍රාක් ත්වං මාං ත්‍රිරපාහ්නෝෂ්‍යසේ, යෛෂා වාග් යීශුනාවාදි තාං පිතරඃ සංස්මෘත්‍ය බහිරිත්වා ඛේදාද් භෘශං චක්‍රන්ද| ");
INSERT INTO sansin_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ප්‍රභාතේ ජාතේ ප්‍රධානයාජකලෝකප්‍රාචීනා යීශුං හන්තුං තත්ප්‍රතිකූලං මන්ත්‍රයිත්වා ");
INSERT INTO sansin_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","තං බද්ව්වා නීත්වා පන්තීයපීලාතාඛ්‍යාධිපේ සමර්පයාමාසුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","තතෝ යීශෝඃ පරකරේව්වර්පයිතා යිහූදාස්තත්ප්‍රාණාදණ්ඩාඥාං විදිත්වා සන්තප්තමනාඃ ප්‍රධානයාජකලෝකප්‍රාචීනානාං සමක්‍ෂං තාස්ත්‍රීංශන්මුද්‍රාඃ ප්‍රතිදායාවාදීත්, ");
INSERT INTO sansin_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ඒතන්නිරාගෝනරප්‍රාණපරකරාර්පණාත් කලුෂං කෘතවානහං| තදා ත උදිතවන්තඃ, තේනාස්මාකං කිං? ත්වයා තද් බුධ්‍යතාම්| ");
INSERT INTO sansin_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","තතෝ යිහූදා මන්දිරමධ්‍යේ තා මුද්‍රා නික්‍ෂිප්‍ය ප්‍රස්ථිතවාන් ඉත්වා ච ස්වයමාත්මානමුද්බබන්ධ| ");
INSERT INTO sansin_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","පශ්චාත් ප්‍රධානයාජකාස්තා මුද්‍රා ආදාය කථිතවන්තඃ, ඒතා මුද්‍රාඃ ශෝණිතමූල්‍යං තස්මාද් භාණ්ඩාගාරේ න නිධාතව්‍යාඃ| ");
INSERT INTO sansin_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","අනන්තරං තේ මන්ත්‍රයිත්වා විදේශිනාං ශ්මශානස්ථානාය තාභිඃ කුලාලස්‍ය ක්‍ෂේත්‍රමක්‍රීණන්| ");
INSERT INTO sansin_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","අතෝ(අ)ද්‍යාපි තත්ස්ථානං රක්තක්‍ෂේත්‍රං වදන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ඉත්ථං සති ඉස්‍රායේලීයසන්තානෛ ර‍්‍යස්‍ය මූල්‍යං නිරුපිතං, තස්‍ය ත්‍රිංශන්මුද්‍රාමානං මූල්‍යං ");
INSERT INTO sansin_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","මාං ප්‍රති පරමේශ්වරස්‍යාදේශාත් තේභ්‍ය ආදීයත, තේන ච කුලාලස්‍ය ක්‍ෂේත්‍රං ක්‍රීතමිති යද්වචනං යිරිමියභවිෂ්‍යද්වාදිනා ප්‍රෝක්තං තත් තදාසිධ්‍යත්| ");
INSERT INTO sansin_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","අනන්තරං යීශෞ තදධිපතේඃ සම්මුඛ උපතිෂ්ඨති ස තං පප්‍රච්ඡ, ත්වං කිං යිහූදීයානාං රාජා? තදා යීශුස්තමවදත්, ත්වං සත්‍යමුක්තවාන්| ");
INSERT INTO sansin_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","කින්තු ප්‍රධානයාජකප්‍රාචීනෛරභියුක්තේන තේන කිමපි න ප්‍රත්‍යවාදි| ");
INSERT INTO sansin_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","තතඃ පීලාතේන ස උදිතඃ, ඉමේ ත්වත්ප්‍රතිකූලතඃ කති කති සාක්‍ෂ්‍යං දදති, තත් ත්වං න ශෘණෝෂි? ");
INSERT INTO sansin_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","තථාපි ස තේෂාමේකස්‍යාපි වචස උත්තරං නෝදිතවාන්; තේන සෝ(අ)ධිපති ර්මහාචිත්‍රං විදාමාස| ");
INSERT INTO sansin_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","අන්‍යච්ච තන්මහකාලේ(අ)ධිපතේරේතාදෘශී රාතිරාසීත්, ප්‍රජා යං කඤ්චන බන්ධිනං යාචන්තේ, තමේව ස මෝචයතීති| ");
INSERT INTO sansin_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","තදානීං බරබ්බානාමා කශ්චිත් ඛ්‍යාතබන්ධ්‍යාසීත්| ");
INSERT INTO sansin_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","තතඃ පීලාතස්තත්‍ර මිලිතාන් ලෝකාන් අපෘච්ඡත්, ඒෂ බරබ්බා බන්ධී ඛ්‍රීෂ්ටවිඛ්‍යාතෝ යීශුශ්චෛතයෝඃ කං මෝචයිෂ්‍යාමි? යුෂ්මාකං කිමීප්සිතං? ");
INSERT INTO sansin_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","තෛරීර්ෂ්‍යයා ස සමර්පිත ඉති ස ඥාතවාන්| ");
INSERT INTO sansin_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","අපරං විචාරාසනෝපවේශනකාලේ පීලාතස්‍ය පත්නී භෘත්‍යං ප්‍රහිත්‍ය තස්මෛ කථයාමාස, තං ධාර්ම්මිකමනුජං ප්‍රති ත්වයා කිමපි න කර්ත්තව්‍යං; යස්මාත් තත්කෘතේ(අ)ද්‍යාහං ස්වප්නේ ප්‍රභූතකෂ්ටමලභේ| ");
INSERT INTO sansin_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","අනන්තරං ප්‍රධානයාජකප්‍රාචීනා බරබ්බාං යාචිත්වාදාතුං යීශුඤ්ච හන්තුං සකලලෝකාන් ප්‍රාවර්ත්තයන්| ");
INSERT INTO sansin_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","තතෝ(අ)ධිපතිස්තාන් පෘෂ්ටවාන්, ඒතයෝඃ කමහං මෝචයිෂ්‍යාමි? යුෂ්මාකං කේච්ඡා? තේ ප්‍රෝචු ර්බරබ්බාං| ");
INSERT INTO sansin_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","තදා පීලාතඃ පප්‍රච්ඡ, තර්හි යං ඛ්‍රීෂ්ටං වදන්ති, තං යීශුං කිං කරිෂ්‍යාමි? සර්ව්වේ කථයාමාසුඃ, ස ක්‍රුශේන විධ්‍යතාං| ");
INSERT INTO sansin_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","තතෝ(අ)ධිපතිරවාදීත්, කුතඃ? කිං තේනාපරාද්ධං? කින්තු තේ පුනරුචෛ ර්ජගදුඃ, ස ක්‍රුශේන විධ්‍යතාං| ");
INSERT INTO sansin_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","තදා නිජවාක්‍යමග්‍රාහ්‍යමභූත්, කලහශ්චාප්‍යභූත්, පීලාත ඉති විලෝක්‍ය ලෝකානාං සමක්‍ෂං තෝයමාදාය කරෞ ප්‍රක්‍ෂාල්‍යාවෝචත්, ඒතස්‍ය ධාර්ම්මිකමනුෂ්‍යස්‍ය ශෝණිතපාතේ නිර්දෝෂෝ(අ)හං, යුෂ්මාභිරේව තද් බුධ්‍යතාං| ");
INSERT INTO sansin_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","තදා සර්ව්වාඃ ප්‍රජාඃ ප්‍රත්‍යවෝචන්, තස්‍ය ශෝණිතපාතාපරාධෝ(අ)ස්මාකම් අස්මත්සන්තානානාඤ්චෝපරි භවතු| ");
INSERT INTO sansin_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","තතඃ ස තේෂාං සමීපේ බරබ්බාං මෝචයාමාස යීශුන්තු කෂාභිරාහත්‍ය ක්‍රුශේන වේධිතුං සමර්පයාමාස| ");
INSERT INTO sansin_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","අනන්තරම් අධිපතේඃ සේනා අධිපතේ ර්ගෘහං යීශුමානීය තස්‍ය සමීපේ සේනාසමූහං සංජගෘහුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","තතස්තේ තස්‍ය වසනං මෝචයිත්වා කෘෂ්ණලෝහිතවර්ණවසනං පරිධාපයාමාසුඃ ");
INSERT INTO sansin_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","කණ්ටකානාං මුකුටං නිර්ම්මාය තච්ඡිරසි දදුඃ, තස්‍ය දක්‍ෂිණකරේ වේත්‍රමේකං දත්ත්වා තස්‍ය සම්මුඛේ ජානූනි පාතයිත්වා, හේ යිහූදීයානාං රාජන්, තුභ්‍යං නම ඉත්‍යුක්ත්වා තං තිරශ්චක්‍රුඃ, ");
INSERT INTO sansin_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","තතස්තස්‍ය ගාත්‍රේ නිෂ්ඨීවං දත්වා තේන වේත්‍රේණ ශිර ආජඝ්නුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ඉත්ථං තං තිරස්කෘත්‍ය තද් වසනං මෝචයිත්වා පුනර්නිජවසනං පරිධාපයාඤ්චක්‍රුඃ, තං ක්‍රුශේන වේධිතුං නීතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","පශ්චාත්තේ බහිර්භූය කුරීණීයං ශිමෝන්නාමකමේකං විලෝක්‍ය ක්‍රුශං වෝඪුං තමාදදිරේ| ");
INSERT INTO sansin_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","අනන්තරං ගුල්ගල්තාම් අර්ථාත් ශිරස්කපාලනාමකස්ථානමු පස්ථාය තේ යීශවේ පිත්තමිශ්‍රිතාම්ලරසං පාතුං දදුඃ, ");
INSERT INTO sansin_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","කින්තු ස තමාස්වාද්‍ය න පපෞ| ");
INSERT INTO sansin_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","තදානීං තේ තං ක්‍රුශේන සංවිධ්‍ය තස්‍ය වසනානි ගුටිකාපාතේන විභජ්‍ය ජගෘහුඃ, තස්මාත්, විභජන්තේ(අ)ධරීයං මේ තේ මනුෂ්‍යාඃ පරස්පරං| මදුත්තරීයවස්ත්‍රාර්ථං ගුටිකාං පාතයන්ති ච|| යදේතද්වචනං භවිෂ්‍යද්වාදිභිරුක්තමාසීත්, තදා තද් අසිධ්‍යත්, ");
INSERT INTO sansin_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","පශ්චාත් තේ තත්‍රෝපවිශ්‍ය තද්‍රක්‍ෂණකර්ව්වණි නියුක්තාස්තස්ථුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","අපරම් ඒෂ යිහූදීයානාං රාජා යීශුරිත්‍යපවාදලිපිපත්‍රං තච්ඡිරස ඌර්ද්ව්වේ යෝජයාමාසුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","තතස්තස්‍ය වාමේ දක්‍ෂිණේ ච ද්වෞ චෛරෞ තේන සාකං ක්‍රුශේන විවිධුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","තදා පාන්ථා නිජශිරෝ ලාඩයිත්වා තං නින්දන්තෝ ජගදුඃ, ");
INSERT INTO sansin_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","හේ ඊශ්වරමන්දිරභඤ්ජක දිනත්‍රයේ තන්නිර්ම්මාතඃ ස්වං රක්‍ෂ, චේත්ත්වමීශ්වරසුතස්තර්හි ක්‍රුශාදවරෝහ| ");
INSERT INTO sansin_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ප්‍රධානයාජකාධ්‍යාපකප්‍රාචීනාශ්ච තථා තිරස්කෘත්‍ය ජගදුඃ, ");
INSERT INTO sansin_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","සෝ(අ)න්‍යජනානාවත්, කින්තු ස්වමවිතුං න ශක්නෝති| යදීස්‍රායේලෝ රාජා භවේත්, තර්හීදානීමේව ක්‍රුශාදවරෝහතු, තේන තං වයං ප්‍රත්‍යේෂ්‍යාමඃ| ");
INSERT INTO sansin_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ස ඊශ්වරේ ප්‍රත්‍යාශාමකරෝත්, යදීශ්වරස්තස්මින් සන්තුෂ්ටස්තර්හීදානීමේව තමවේත්, යතඃ ස උක්තවාන් අහමීශ්වරසුතඃ| ");
INSERT INTO sansin_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","යෞ ස්තේනෞ සාකං තේන ක්‍රුශේන විද්ධෞ තෞ තද්වදේව තං නිනින්දතුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","තදා ද්විතීයයාමාත් තෘතීයයාමං යාවත් සර්ව්වදේශේ තමිරං බභූව, ");
INSERT INTO sansin_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","තෘතීයයාමේ \"ඒලී ඒලී ලාමා ශිවක්තනී\", අර්ථාත් මදීශ්වර මදීශ්වර කුතෝ මාමත්‍යාක්‍ෂීඃ? යීශුරුච්චෛරිති ජගාද| ");
INSERT INTO sansin_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","තදා තත්‍ර ස්ථිතාඃ කේචිත් තත් ශ්‍රුත්වා බභාෂිරේ, අයම් ඒලියමාහූයති| ");
INSERT INTO sansin_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","තේෂාං මධ්‍යාද් ඒකඃ ශීඝ්‍රං ගත්වා ස්පඤ්ජං ගෘහීත්වා තත්‍රාම්ලරසං දත්ත්වා නලේන පාතුං තස්මෛ දදෞ| ");
INSERT INTO sansin_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ඉතරේ(අ)කථයන් තිෂ්ඨත, තං රක්‍ෂිතුම් ඒලිය ආයාති නවේති පශ්‍යාමඃ| ");
INSERT INTO sansin_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","යීශුඃ පුනරුචෛරාහූය ප්‍රාණාන් ජහෞ| ");
INSERT INTO sansin_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","තතෝ මන්දිරස්‍ය විච්ඡේදවසනම් ඌර්ද්ව්වාදධෝ යාවත් ඡිද්‍යමානං ද්විධාභවත්, ");
INSERT INTO sansin_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","භූමිශ්චකම්පේ භූධරෝව්‍යදීර‍්‍ය්‍යත ච| ශ්මශානේ මුක්තේ භූරිපුණ්‍යවතාං සුප්තදේහා උදතිෂ්ඨන්, ");
INSERT INTO sansin_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ශ්මශානාද් වහිර්භූය තදුත්ථානාත් පරං පුණ්‍යපුරං ගත්වා බහුජනාන් දර්ශයාමාසුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","යීශුරක්‍ෂණාය නියුක්තඃ ශතසේනාපතිස්තත්සඞ්ගිනශ්ච තාදෘශීං භූකම්පාදිඝටනාං දෘෂ්ට්වා භීතා අවදන්, ඒෂ ඊශ්වරපුත්‍රෝ භවති| ");
INSERT INTO sansin_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","යා බහුයෝෂිතෝ යීශුං සේවමානා ගාලීලස්තත්පශ්චාදාගතාස්තාසාං මධ්‍යේ ");
INSERT INTO sansin_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","මග්දලීනී මරියම් යාකූබ්‍යෝශ්‍යෝ ර්මාතා යා මරියම් සිබදියපුත්‍රයෝ ර්මාතා ච යෝෂිත ඒතා දූරේ තිෂ්ඨන්ත්‍යෝ දදෘශුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","සන්ධ්‍යායාං සත්‍යම් අරිමථියානගරස්‍ය යූෂඵ්නාමා ධනී මනුජෝ යීශෝඃ ශිෂ්‍යත්වාත් ");
INSERT INTO sansin_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","පීලාතස්‍ය සමීපං ගත්වා යීශෝඃ කායං යයාචේ, තේන පීලාතඃ කායං දාතුම් ආදිදේශ| ");
INSERT INTO sansin_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","යූෂඵ් තත්කායං නීත්වා ශුචිවස්ත්‍රේණාච්ඡාද්‍ය ");
INSERT INTO sansin_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ස්වාර්ථං ශෛලේ යත් ශ්මශානං චඛාන, තන්මධ්‍යේ තත්කායං නිධාය තස්‍ය ද්වාරි වෘහත්පාෂාණං දදෞ| ");
INSERT INTO sansin_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","කින්තු මග්දලීනී මරියම් අන්‍යමරියම් ඒතේ ස්ත්‍රියෞ තත්‍ර ශ්මශානසම්මුඛ උපවිවිශතුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","තදනන්තරං නිස්තාරෝත්සවස්‍යායෝජනදිනාත් පරේ(අ)හනි ප්‍රධානයාජකාඃ ඵිරූශිනශ්ච මිලිත්වා පීලාතමුපාගත්‍යාකථයන්, ");
INSERT INTO sansin_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","හේ මහේච්ඡ ස ප්‍රතාරකෝ ජීවන අකථයත්, දිනත්‍රයාත් පරං ශ්මශානාදුත්ථාස්‍යාමි තද්වාක්‍යං ස්මරාමෝ වයං; ");
INSERT INTO sansin_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","තස්මාත් තෘතීයදිනං යාවත් තත් ශ්මශානං රක්‍ෂිතුමාදිශතු, නෝචේත් තච්ඡිෂ්‍යා යාමින්‍යාමාගත්‍ය තං හෘත්වා ලෝකාන් වදිෂ්‍යන්ති, ස ශ්මශානාදුදතිෂ්ඨත්, තථා සති ප්‍රථමභ්‍රාන්තේඃ ශේෂීයභ්‍රාන්ති ර්මහතී භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","තදා පීලාත අවාදීත්, යුෂ්මාකං සමීපේ රක්‍ෂිගණ ආස්තේ, යූයං ගත්වා යථා සාධ්‍යං රක්‍ෂයත| ");
INSERT INTO sansin_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","තතස්තේ ගත්වා තද්දූाරපාෂාණං මුද්‍රාඞ්කිතං කෘත්වා රක්‍ෂිගණං නියෝජ්‍ය ශ්මශානං රක්‍ෂයාමාසුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","තතඃ පරං විශ්‍රාමවාරස්‍ය ශේෂේ සප්තාහප්‍රථමදිනස්‍ය ප්‍රභෝතේ ජාතේ මග්දලීනී මරියම් අන්‍යමරියම් ච ශ්මශානං ද්‍රෂ්ටුමාගතා| ");
INSERT INTO sansin_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","තදා මහාන් භූකම්පෝ(අ)භවත්; පරමේශ්වරීයදූතඃ ස්වර්ගාදවරුහ්‍ය ශ්මශානද්වාරාත් පාෂාණමපසාර‍්‍ය්‍ය තදුපර‍්‍ය්‍යුපවිවේශ| ");
INSERT INTO sansin_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","තද්වදනං විද්‍යුද්වත් තේජෝමයං වසනං හිමශුභ්‍රඤ්ච| ");
INSERT INTO sansin_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","තදානීං රක්‍ෂිණස්තද්භයාත් කම්පිතා මෘතවද් බභූවඃ| ");
INSERT INTO sansin_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ස දූතෝ යෝෂිතෝ ජගාද, යූයං මා භෛෂ්ට, ක්‍රුශහතයීශුං මෘගයධ්වේ තදහං වේද්මි| ");
INSERT INTO sansin_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","සෝ(අ)ත්‍ර නාස්ති, යථාවදත් තථෝත්ථිතවාන්; ඒතත් ප්‍රභෝඃ ශයනස්ථානං පශ්‍යත| ");
INSERT INTO sansin_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","තූර්ණං ගත්වා තච්ඡිෂ්‍යාන් ඉති වදත, ස ශ්මශානාද් උදතිෂ්ඨත්, යුෂ්මාකමග්‍රේ ගාලීලං යාස්‍යති යූයං තත්‍ර තං වීක්‍ෂිෂ්‍යධ්වේ, පශ්‍යතාහං වාර්ත්තාමිමාං යුෂ්මානවාදිෂං| ");
INSERT INTO sansin_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","තතස්තා භයාත් මහානන්දාඤ්ච ශ්මශානාත් තූර්ණං බහිර්භූය තච්ඡිෂ්‍යාන් වාර්ත්තාං වක්තුං ධාවිතවත්‍යඃ| කින්තු ශිෂ්‍යාන් වාර්ත්තාං වක්තුං යාන්ති, තදා යීශු ර්දර්ශනං දත්ත්වා තා ජගාද, ");
INSERT INTO sansin_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","යුෂ්මාකං කල්‍යාණං භූයාත්, තතස්තා ආගත්‍ය තත්පාදයෝඃ පතිත්වා ප්‍රණේමුඃ| ");
INSERT INTO sansin_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","යීශුස්තා අවාදීත්, මා බිභීත, යූයං ගත්වා මම භ්‍රාතෘන් ගාලීලං යාතුං වදත, තත්‍ර තේ මාං ද්‍රක්‍ෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","ස්ත්‍රියෝ ගච්ඡන්ති, තදා රක්‍ෂිණාං කේචිත් පුරං ගත්වා යද්‍යද් ඝටිතං තත්සර්ව්වං ප්‍රධානයාජකාන් ඥාපිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","තේ ප්‍රාචීනෛඃ සමං සංසදං කෘත්වා මන්ත්‍රයන්තෝ බහුමුද්‍රාඃ සේනාභ්‍යෝ දත්ත්වාවදන්, ");
INSERT INTO sansin_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","අස්මාසු නිද්‍රිතේෂු තච්ඡිෂ්‍යා යාමින්‍යාමාගත්‍ය තං හෘත්වානයන්, ඉති යූයං ප්‍රචාරයත| ");
INSERT INTO sansin_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","යද්‍යේතදධිපතේඃ ශ්‍රෝත්‍රගෝචරීභවේත්, තර්හි තං බෝධයිත්වා යුෂ්මානවිෂ්‍යාමඃ| ");
INSERT INTO sansin_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","තතස්තේ මුද්‍රා ගෘහීත්වා ශික්‍ෂානුරූපං කර්ම්ම චක්‍රුඃ, යිහූදීයානාං මධ්‍යේ තස්‍යාද්‍යාපි කිංවදන්තී විද්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ඒකාදශ ශිෂ්‍යා යීශුනිරූපිතාගාලීලස්‍යාද්‍රිං ගත්වා ");
INSERT INTO sansin_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","තත්‍ර තං සංවීක්‍ෂ්‍ය ප්‍රණේමුඃ, කින්තු කේචිත් සන්දිග්ධවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","යීශුස්තේෂාං සමීපමාගත්‍ය ව්‍යාහෘතවාන්, ස්වර්ගමේදින්‍යෝඃ සර්ව්වාධිපතිත්වභාරෝ මය්‍යර්පිත ආස්තේ| ");
INSERT INTO sansin_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","අතෝ යූයං ප්‍රයාය සර්ව්වදේශීයාන් ශිෂ්‍යාන් කෘත්වා පිතුඃ පුත්‍රස්‍ය පවිත්‍රස්‍යාත්මනශ්ච නාම්නා තානවගාහයත; අහං යුෂ්මාන් යද්‍යදාදිශං තදපි පාලයිතුං තානුපාදිශත| ");
INSERT INTO sansin_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","පශ්‍යත, ජගදන්තං යාවත් සදාහං යුෂ්මාභිඃ සාකං තිෂ්ඨාමි| ඉති|");
INSERT INTO sansin_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ඊශ්වරපුත්‍රස්‍ය යීශුඛ්‍රීෂ්ටස්‍ය සුසංවාදාරම්භඃ| ");
INSERT INTO sansin_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","භවිෂ්‍යද්වාදිනාං ග්‍රන්ථේෂු ලිපිරිත්ථමාස්තේ, පශ්‍ය ස්වකීයදූතන්තු තවාග්‍රේ ප්‍රේෂයාම්‍යහම්| ගත්වා ත්වදීයපන්ථානං ස හි පරිෂ්කරිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","\"පරමේශස්‍ය පන්ථානං පරිෂ්කුරුත සර්ව්වතඃ| තස්‍ය රාජපථඤ්චෛව සමානං කුරුතාධුනා| \" ඉත්‍යේතත් ප්‍රාන්තරේ වාක්‍යං වදතඃ කස්‍යචිද්‍රවඃ|| ");
INSERT INTO sansin_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","සඒව යෝහන් ප්‍රාන්තරේ මජ්ජිතවාන් තථා පාපමාර්ජනනිමිත්තං මනෝව්‍යාවර්ත්තකමජ්ජනස්‍ය කථාඤ්ච ප්‍රචාරිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","තතෝ යිහූදාදේශයිරූශාලම්නගරනිවාසිනඃ සර්ව්වේ ලෝකා බහි ර්භූත්වා තස්‍ය සමීපමාගත්‍ය ස්වානි ස්වානි පාපාන්‍යඞ්ගීකෘත්‍ය යර්ද්දනනද්‍යාං තේන මජ්ජිතා බභූවුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","අස්‍ය යෝහනඃ පරිධේයානි ක්‍රමේලකලෝමජානි, තස්‍ය කටිබන්ධනං චර්ම්මජාතම්, තස්‍ය භක්‍ෂ්‍යාණි ච ශූකකීටා වන්‍යමධූනි චාසන්| ");
INSERT INTO sansin_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ස ප්‍රචාරයන් කථයාඤ්චක්‍රේ, අහං නම්‍රීභූය යස්‍ය පාදුකාබන්ධනං මෝචයිතුමපි න යෝග්‍යෝස්මි, තාදෘශෝ මත්තෝ ගුරුතර ඒකඃ පුරුෂෝ මත්පශ්චාදාගච්ඡති| ");
INSERT INTO sansin_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","අහං යුෂ්මාන් ජලේ මජ්ජිතවාන් කින්තු ස පවිත්‍ර ආත්මානි සංමජ්ජයිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","අපරඤ්ච තස්මින්නේව කාලේ ගාලීල්ප්‍රදේශස්‍ය නාසරද්ග්‍රාමාද් යීශුරාගත්‍ය යෝහනා යර්ද්දනනද්‍යාං මජ්ජිතෝ(අ)භූත්| ");
INSERT INTO sansin_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ස ජලාදුත්ථිතමාත්‍රෝ මේඝද්වාරං මුක්තං කපෝතවත් ස්වස්‍යෝපරි අවරෝහන්තමාත්මානඤ්ච දෘෂ්ටවාන්| ");
INSERT INTO sansin_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ත්වං මම ප්‍රියඃ පුත්‍රස්ත්වය්‍යේව මමමහාසන්තෝෂ ඉයමාකාශීයා වාණී බභූව| ");
INSERT INTO sansin_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","තස්මින් කාලේ ආත්මා තං ප්‍රාන්තරමධ්‍යං නිනාය| ");
INSERT INTO sansin_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","අථ ස චත්වාරිංශද්දිනානි තස්මින් ස්ථානේ වන්‍යපශුභිඃ සහ තිෂ්ඨන් ශෛතානා පරීක්‍ෂිතඃ; පශ්චාත් ස්වර්ගීයදූතාස්තං සිෂේවිරේ| ");
INSERT INTO sansin_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","අනන්තරං යෝහනි බන්ධනාලයේ බද්ධේ සති යීශු ර්ගාලීල්ප්‍රදේශමාගත්‍ය ඊශ්වරරාජ්‍යස්‍ය සුසංවාදං ප්‍රචාරයන් කථයාමාස, ");
INSERT INTO sansin_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","කාලඃ සම්පූර්ණ ඊශ්වරරාජ්‍යඤ්ච සමීපමාගතං; අතෝහේතෝ ර‍්‍යූයං මනාංසි ව්‍යාවර්ත්තයධ්වං සුසංවාදේ ච විශ්වාසිත| ");
INSERT INTO sansin_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","තදනන්තරං ස ගාලීලීයසමුද්‍රස්‍ය තීරේ ගච්ඡන් ශිමෝන් තස්‍ය භ්‍රාතා අන්ද්‍රියනාමා ච ඉමෞ ද්වෞ ජනෞ මත්ස්‍යධාරිණෞ සාගරමධ්‍යේ ජාලං ප්‍රක්‍ෂිපන්තෞ දෘෂ්ට්වා තාවවදත්, ");
INSERT INTO sansin_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","යුවාං මම පශ්චාදාගච්ඡතං, යුවාමහං මනුෂ්‍යධාරිණෞ කරිෂ්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","තතස්තෞ තත්ක්‍ෂණමේව ජාලානි පරිත්‍යජ්‍ය තස්‍ය පශ්චාත් ජග්මතුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","තතඃ පරං තත්ස්ථානාත් කිඤ්චිද් දූරං ගත්වා ස සිවදීපුත්‍රයාකූබ් තද්භ්‍රාතෘයෝහන් ච ඉමෞ නෞකායාං ජාලානාං ජීර්ණමුද්ධාරයන්තෞ දෘෂ්ට්වා තාවාහූයත්| ");
INSERT INTO sansin_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","තතස්තෞ නෞකායාං වේතනභුග්භිඃ සහිතං ස්වපිතරං විහාය තත්පශ්චාදීයතුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","තතඃ පරං කඵර්නාහූම්නාමකං නගරමුපස්ථාය ස විශ්‍රාමදිවසේ භජනග්‍රහං ප්‍රවිශ්‍ය සමුපදිදේශ| ");
INSERT INTO sansin_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","තස්‍යෝපදේශාල්ලෝකා ආශ්චර‍්‍ය්‍යං මේනිරේ යතඃ සෝධ්‍යාපකාඉව නෝපදිශන් ප්‍රභාවවානිව ප්‍රෝපදිදේශ| ");
INSERT INTO sansin_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","අපරඤ්ච තස්මින් භජනගෘහේ අපවිත්‍රභූතේන ග්‍රස්ත ඒකෝ මානුෂ ආසීත්| ස චීත්ශබ්දං කෘත්වා කථයාඤ්චකේ ");
INSERT INTO sansin_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","භෝ නාසරතීය යීශෝ ත්වමස්මාන් ත්‍යජ, ත්වයා සහාස්මාකං කඃ සම්බන්ධඃ? ත්වං කිමස්මාන් නාශයිතුං සමාගතඃ? ත්වමීශ්වරස්‍ය පවිත්‍රලෝක ඉත්‍යහං ජානාමි| ");
INSERT INTO sansin_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","තදා යීශුස්තං තර්ජයිත්වා ජගාද තූෂ්ණීං භව ඉතෝ බහිර්භව ච| ");
INSERT INTO sansin_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","තතඃ සෝ(අ)පවිත්‍රභූතස්තං සම්පීඩ්‍ය අත්‍යුචෛශ්චීත්කෘත්‍ය නිර්ජගාම| ");
INSERT INTO sansin_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","තේනෛව සර්ව්වේ චමත්කෘත්‍ය පරස්පරං කථයාඤ්චක්‍රිරේ, අහෝ කිමිදං? කීදෘශෝ(අ)යං නව්‍ය උපදේශඃ? අනේන ප්‍රභාවේනාපවිත්‍රභූතේෂ්වාඥාපිතේෂු තේ තදාඥානුවර්ත්තිනෝ භවන්ති| ");
INSERT INTO sansin_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","තදා තස්‍ය යශෝ ගාලීලශ්චතුර්දික්ස්ථසර්ව්වදේශාන් ව්‍යාප්නෝත්| ");
INSERT INTO sansin_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","අපරඤ්ච තේ භජනගෘහාද් බහි ර්භූත්වා යාකූබ්‍යෝහන්භ්‍යාං සහ ශිමෝන ආන්ද්‍රියස්‍ය ච නිවේශනං ප්‍රවිවිශුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","තදා පිතරස්‍ය ශ්වශ්‍රූර්ජ්වරපීඩිතා ශය්‍යායාමාස්ත ඉති තේ තං ඣටිති විඥාපයාඤ්චක්‍රුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","තතඃ ස ආගත්‍ය තස්‍යා හස්තං ධෘත්වා තාමුදස්ථාපයත්; තදෛව තාං ජ්වරෝ(අ)ත්‍යාක්‍ෂීත් තතඃ පරං සා තාන් සිෂේවේ| ");
INSERT INTO sansin_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","අථාස්තං ගතේ රවෞ සන්ධ්‍යාකාලේ සති ලෝකාස්තත්සමීපං සර්ව්වාන් රෝගිණෝ භූතධෘතාංශ්ච සමානින්‍යුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","සර්ව්වේ නාගරිකා ලෝකා ද්වාරි සංමිලිතාශ්ච| ");
INSERT INTO sansin_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","තතඃ ස නානාවිධරෝගිණෝ බහූන් මනුජානරෝගිණශ්චකාර තථා බහූන් භූතාන් ත්‍යාජයාඤ්චකාර තාන් භූතාන් කිමපි වාක්‍යං වක්තුං නිෂිෂේධ ච යතෝහේතෝස්තේ තමජානන්| ");
INSERT INTO sansin_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","අපරඤ්ච සෝ(අ)තිප්‍රත්‍යූෂේ වස්තුතස්තු රාත්‍රිශේෂේ සමුත්ථාය බහිර්භූය නිර්ජනං ස්ථානං ගත්වා තත්‍ර ප්‍රාර්ථයාඤ්චක්‍රේ| ");
INSERT INTO sansin_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","අනන්තරං ශිමෝන් තත්සඞ්ගිනශ්ච තස්‍ය පශ්චාද් ගතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","තදුද්දේශං ප්‍රාප්‍ය තමවදන් සර්ව්වේ ලෝකාස්ත්වාං මෘගයන්තේ| ");
INSERT INTO sansin_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","තදා සෝ(අ)කථයත් ආගච්ඡත වයං සමීපස්ථානි නගරාණි යාමඃ, යතෝ(අ)හං තත්‍ර කථාං ප්‍රචාරයිතුං බහිරාගමම්| ");
INSERT INTO sansin_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","අථ ස තේෂාං ගාලීල්ප්‍රදේශස්‍ය සර්ව්වේෂු භජනගෘහේෂු කථාඃ ප්‍රචාරයාඤ්චක්‍රේ භූතානත්‍යාජයඤ්ච| ");
INSERT INTO sansin_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","අනන්තරමේකඃ කුෂ්ඨී සමාගත්‍ය තත්සම්මුඛේ ජානුපාතං විනයඤ්ච කෘත්වා කථිතවාන් යදි භවාන් ඉච්ඡති තර්හි මාං පරිෂ්කර්ත්තුං ශක්නෝති| ");
INSERT INTO sansin_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","තතඃ කෘපාලු ර‍්‍යීශුඃ කරෞ ප්‍රසාර‍්‍ය්‍ය තං ස්පෂ්ට්වා කථයාමාස ");
INSERT INTO sansin_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","මමේච්ඡා විද්‍යතේ ත්වං පරිෂ්කෘතෝ භව| ඒතත්කථායාඃ කථනමාත්‍රාත් ස කුෂ්ඨී රෝගාන්මුක්තඃ පරිෂ්කෘතෝ(අ)භවත්| ");
INSERT INTO sansin_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","තදා ස තං විසෘජන් ගාඪමාදිශ්‍ය ජගාද ");
INSERT INTO sansin_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","සාවධානෝ භව කථාමිමාං කමපි මා වද; ස්වාත්මානං යාජකං දර්ශය, ලෝකේභ්‍යඃ ස්වපරිෂ්කෘතේඃ ප්‍රමාණදානාය මූසානිර්ණීතං යද්දානං තදුත්සෘජස්ව ච| ");
INSERT INTO sansin_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","කින්තු ස ගත්වා තත් කර්ම්ම ඉත්ථං විස්තාර‍්‍ය්‍ය ප්‍රචාරයිතුං ප්‍රාරේභේ තේනෛව යීශුඃ පුනඃ සප්‍රකාශං නගරං ප්‍රවේෂ්ටුං නාශක්නෝත් තතෝහේතෝර්බහිඃ කානනස්ථානේ තස්‍යෞ; තථාපි චතුර්ද්දිග්භ්‍යෝ ලෝකාස්තස්‍ය සමීපමායයුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","තදනන්තරං යීශෛ කතිපයදිනානි විලම්බ්‍ය පුනඃ කඵර්නාහූම්නගරං ප්‍රවිෂ්ටේ ස ගෘහ ආස්ත ඉති කිංවදන්ත්‍යා තත්ක්‍ෂණං තත්සමීපං බහවෝ ලෝකා ආගත්‍ය සමුපතස්ථුඃ, ");
INSERT INTO sansin_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","තස්මාද් ගෘහමධ්‍යේ සර්ව්වේෂාං කෘතේ ස්ථානං නාභවද් ද්වාරස්‍ය චතුර්දික්‍ෂ්වපි නාභවත්, තත්කාලේ ස තාන් ප්‍රති කථාං ප්‍රචාරයාඤ්චක්‍රේ| ");
INSERT INTO sansin_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","තතඃ පරං ලෝකාශ්චතුර්භි ර්මානවෛරේකං පක්‍ෂාඝාතිනං වාහයිත්වා තත්සමීපම් ආනින්‍යුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","කින්තු ජනානාං බහුත්වාත් තං යීශෝඃ සම්මුඛමානේතුං න ශක්නුවන්තෝ යස්මින් ස්ථානේ ස ආස්තේ තදුපරිගෘහපෘෂ්ඨං ඛනිත්වා ඡිද්‍රං කෘත්වා තේන මාර්ගේණ සශය්‍යං පක්‍ෂාඝාතිනම් අවරෝහයාමාසුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","තතෝ යීශුස්තේෂාං විශ්වාසං දෘෂ්ට්වා තං පක්‍ෂාඝාතිනං බභාෂේ හේ වත්ස තව පාපානාං මාර්ජනං භවතු| ");
INSERT INTO sansin_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","තදා කියන්තෝ(අ)ධ්‍යාපකාස්තත්‍රෝපවිශන්තෝ මනෝභි ර්විතර්කයාඤ්චක්‍රුඃ, ඒෂ මනුෂ්‍ය ඒතාදෘශීමීශ්වරනින්දාං කථාං කුතඃ කථයති? ");
INSERT INTO sansin_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","ඊශ්වරං විනා පාපානි මාර්ෂ්ටුං කස්‍ය සාමර්ථ්‍යම් ආස්තේ? ");
INSERT INTO sansin_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ඉත්ථං තේ විතර්කයන්ති යීශුස්තත්ක්‍ෂණං මනසා තද් බුද්ව්වා තානවදද් යූයමන්තඃකරණෛඃ කුත ඒතානි විතර්කයථ? ");
INSERT INTO sansin_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","තදනන්තරං යීශුස්තත්ස්ථානාත් පුනඃ සමුද්‍රතටං යයෞ; ලෝකනිවහේ තත්සමීපමාගතේ ස තාන් සමුපදිදේශ| ");
INSERT INTO sansin_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","කින්තු පෘථිව්‍යාං පාපානි මාර්ෂ්ටුං මනුෂ්‍යපුත්‍රස්‍ය සාමර්ථ්‍යමස්ති, ඒතද් යුෂ්මාන් ඥාපයිතුං (ස තස්මෛ පක්‍ෂාඝාතිනේ කථයාමාස) ");
INSERT INTO sansin_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","උත්තිෂ්ඨ තව ශය්‍යාං ගෘහීත්වා ස්වගෘහං යාහි, අහං ත්වාමිදම් ආඥාපයාමි| ");
INSERT INTO sansin_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","තතඃ ස තත්ක්‍ෂණම් උත්ථාය ශය්‍යාං ගෘහීත්වා සර්ව්වේෂාං සාක්‍ෂාත් ජගාම; සර්ව්වේ විස්මිතා ඒතාදෘශං කර්ම්ම වයම් කදාපි නාපශ්‍යාම, ඉමාං කථාං කථයිත්වේශ්වරං ධන්‍යමබ්‍රුවන්| ");
INSERT INTO sansin_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","තදනන්තරං යීශුස්තත්ස්ථානාත් පුනඃ සමුද්‍රතටං යයෞ; ලෝකනිවහේ තත්සමීපමාගතේ ස තාන් සමුපදිදේශ| ");
INSERT INTO sansin_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","අථ ගච්ඡන් කරසඤ්චයගෘහ උපවිෂ්ටම් ආල්ඵීයපුත්‍රං ලේවිං දෘෂ්ට්වා තමාහූය කථිතවාන් මත්පශ්චාත් ත්වාමාමච්ඡ තතඃ ස උත්ථාය තත්පශ්චාද් යයෞ| ");
INSERT INTO sansin_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","අනන්තරං යීශෞ තස්‍ය ගෘහේ භෝක්තුම් උපවිෂ්ටේ බහවඃ කරමඤ්චායිනඃ පාපිනශ්ච තේන තච්ඡිෂ්‍යෛශ්ච සහෝපවිවිශුඃ, යතෝ බහවස්තත්පශ්චාදාජග්මුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","තදා ස කරමඤ්චායිභිඃ පාපිභිශ්ච සහ ඛාදති, තද් දෘෂ්ට්වාධ්‍යාපකාඃ ඵිරූශිනශ්ච තස්‍ය ශිෂ්‍යානූචුඃ කරමඤ්චායිභිඃ පාපිභිශ්ච සහායං කුතෝ භුංක්තේ පිවති ච? ");
INSERT INTO sansin_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","තද්වාක්‍යං ශ්‍රුත්වා යීශුඃ ප්‍රත්‍යුවාච,අරෝගිලෝකානාං චිකිත්සකේන ප්‍රයෝජනං නාස්ති, කින්තු රෝගිණාමේව; අහං ධාර්ම්මිකානාහ්වාතුං නාගතඃ කින්තු මනෝ ව්‍යාවර්ත්තයිතුං පාපින ඒව| ");
INSERT INTO sansin_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","තතඃ පරං යෝහනඃ ඵිරූශිනාඤ්චෝපවාසාචාරිශිෂ්‍යා යීශෝඃ සමීපම් ආගත්‍ය කථයාමාසුඃ, යෝහනඃ ඵිරූශිනාඤ්ච ශිෂ්‍යා උපවසන්ති කින්තු භවතඃ ශිෂ්‍යා නෝපවසන්ති කිං කාරණමස්‍ය? ");
INSERT INTO sansin_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","තදා යීශුස්තාන් බභාෂේ යාවත් කාලං සඛිභිඃ සහ කන්‍යායා වරස්තිෂ්ඨති තාවත්කාලං තේ කිමුපවස්තුං ශක්නුවන්ති? යාවත්කාලං වරස්තෛඃ සහ තිෂ්ඨති තාවත්කාලං ත උපවස්තුං න ශක්නුවන්ති| ");
INSERT INTO sansin_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","යස්මින් කාලේ තේභ්‍යඃ සකාශාද් වරෝ නේෂ්‍යතේ ස කාල ආගච්ඡති, තස්මින් කාලේ තේ ජනා උපවත්ස්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","කෝපි ජනඃ පුරාතනවස්ත්‍රේ නූතනවස්ත්‍රං න සීව්‍යති, යතෝ නූතනවස්ත්‍රේණ සහ සේවනේ කෘතේ ජීර්ණං වස්ත්‍රං ඡිද්‍යතේ තස්මාත් පුන ර්මහත් ඡිද්‍රං ජායතේ| ");
INSERT INTO sansin_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","කෝපි ජනඃ පුරාතනකුතූෂු නූතනං ද්‍රාක්‍ෂාරසං න ස්ථාපයති, යතෝ නූතනද්‍රාක්‍ෂාරසස්‍ය තේජසා තාඃ කුත්වෝ විදීර‍්‍ය්‍යන්තේ තතෝ ද්‍රාක්‍ෂාරසශ්ච පතති කුත්වශ්ච නශ්‍යන්ති, අතඒව නූතනද්‍රාක්‍ෂාරසෝ නූතනකුතූෂු ස්ථාපනීයඃ| ");
INSERT INTO sansin_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","තදනන්තරං යීශු ර‍්‍යදා විශ්‍රාමවාරේ ශස්‍යක්‍ෂේත්‍රේණ ගච්ඡති තදා තස්‍ය ශිෂ්‍යා ගච්ඡන්තඃ ශස්‍යමඤ්ජරීශ්ඡේත්තුං ප්‍රවෘත්තාඃ| ");
INSERT INTO sansin_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","අතඃ ඵිරූශිනෝ යීශවේ කථයාමාසුඃ පශ්‍යතු විශ්‍රාමවාසරේ යත් කර්ම්ම න කර්ත්තව්‍යං තද් ඉමේ කුතඃ කුර්ව්වන්ති? ");
INSERT INTO sansin_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","තදා ස තේභ්‍යෝ(අ)කථයත් දායූද් තත්සංඞ්ගිනශ්ච භක්‍ෂ්‍යාභාවාත් ක්‍ෂුධිතාඃ සන්තෝ යත් කර්ම්ම කෘතවන්තස්තත් කිං යුෂ්මාභි ර්න පඨිතම්? ");
INSERT INTO sansin_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","අබියාථර්නාමකේ මහායාජකතාං කුර්ව්වති ස කථමීශ්වරස්‍යාවාසං ප්‍රවිශ්‍ය යේ දර්ශනීයපූපා යාජකාන් විනාන්‍යස්‍ය කස්‍යාපි න භක්‍ෂ්‍යාස්තානේව බුභුජේ සඞ්ගිලෝකේභ්‍යෝ(අ)පි දදෞ| ");
INSERT INTO sansin_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","සෝ(අ)පරමපි ජගාද, විශ්‍රාමවාරෝ මනුෂ්‍යාර්ථමේව නිරූපිතෝ(අ)ස්ති කින්තු මනුෂ්‍යෝ විශ්‍රාමවාරාර්ථං නෛව| ");
INSERT INTO sansin_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","මනුෂ්‍යපුත්‍රෝ විශ්‍රාමවාරස්‍යාපි ප්‍රභුරාස්තේ| ");
INSERT INTO sansin_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","අනන්තරං යීශුඃ පුන ර්භජනගෘහං ප්‍රවිෂ්ටස්තස්මින් ස්ථානේ ශුෂ්කහස්ත ඒකෝ මානව ආසීත්| ");
INSERT INTO sansin_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ස විශ්‍රාමවාරේ තමරෝගිණං කරිෂ්‍යති නවේත්‍යත්‍ර බහවස්තම් අපවදිතුං ඡිද්‍රමපේක්‍ෂිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","තදා ස තං ශුෂ්කහස්තං මනුෂ්‍යං ජගාද මධ්‍යස්ථානේ ත්වමුත්තිෂ්ඨ| ");
INSERT INTO sansin_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","තතඃ පරං ස තාන් පප්‍රච්ඡ විශ්‍රාමවාරේ හිතමහිතං තථා හි ප්‍රාණරක්‍ෂා වා ප්‍රාණනාශ ඒෂාං මධ්‍යේ කිං කරණීයං ? කින්තු තේ නිඃශබ්දාස්තස්ථුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","තදා ස තේෂාමන්තඃකරණානාං කාඨින්‍යාද්ධේතෝ ර්දුඃඛිතඃ ක්‍රෝධාත් චර්තුिදශෝ දෘෂ්ටවාන් තං මානුෂං ගදිතවාන් තං හස්තං විස්තාරය, තතස්තේන හස්තේ විස්තෘතේ තද්ධස්තෝ(අ)න්‍යහස්තවද් අරෝගෝ ජාතඃ| ");
INSERT INTO sansin_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","අථ ඵිරූශිනඃ ප්‍රස්ථාය තං නාශයිතුං හේරෝදීයෛඃ සහ මන්ත්‍රයිතුමාරේභිරේ| ");
INSERT INTO sansin_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","අතඒව යීශුස්තත්ස්ථානං පරිත්‍යජ්‍ය ශිෂ්‍යෛඃ සහ පුනඃ සාගරසමීපං ගතඃ; ");
INSERT INTO sansin_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","තතෝ ගාලීල්‍යිහූදා-යිරූශාලම්-ඉදෝම්-යර්දන්නදීපාරස්ථානේභ්‍යෝ ලෝකසමූහස්තස්‍ය පශ්චාද් ගතඃ; තදන්‍යඃ සෝරසීදනෝඃ සමීපවාසිලෝකසමූහශ්ච තස්‍ය මහාකර්ම්මණාං වාර්ත්තං ශ්‍රුත්වා තස්‍ය සන්නිධිමාගතඃ| ");
INSERT INTO sansin_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","තදා ලෝකසමූහශ්චේත් තස්‍යෝපරි පතති ඉත්‍යාශඞ්ක්‍ය ස නාවමේකාං නිකටේ ස්ථාපයිතුං ශිෂ්‍යානාදිෂ්ටවාන්| ");
INSERT INTO sansin_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","යතෝ(අ)නේකමනුෂ්‍යාණාමාරෝග්‍යකරණාද් ව්‍යාධිග්‍රස්තාඃ සර්ව්වේ තං ස්ප්‍රෂ්ටුං පරස්පරං බලේන යත්නවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","අපරඤ්ච අපවිත්‍රභූතාස්තං දෘෂ්ට්වා තච්චරණයෝඃ පතිත්වා ප්‍රෝචෛඃ ප්‍රෝචුඃ, ත්වමීශ්වරස්‍ය පුත්‍රඃ| ");
INSERT INTO sansin_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","කින්තු ස තාන් දෘඪම් ආඥාප්‍ය ස්වං පරිචායිතුං නිෂිද්ධවාන්| ");
INSERT INTO sansin_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","අනන්තරං ස පර්ව්වතමාරුහ්‍ය යං යං ප්‍රතිච්ඡා තං තමාහූතවාන් තතස්තේ තත්සමීපමාගතාඃ| ");
INSERT INTO sansin_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","තදා ස ද්වාදශජනාන් ස්වේන සහ ස්ථාතුං සුසංවාදප්‍රචාරාය ප්‍රේරිතා භවිතුං ");
INSERT INTO sansin_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","සර්ව්වප්‍රකාරව්‍යාධීනාං ශමනකරණාය ප්‍රභාවං ප්‍රාප්තුං භූතාන් ත්‍යාජයිතුඤ්ච නියුක්තවාන්| ");
INSERT INTO sansin_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","තේෂාං නාමානීමානි, ශිමෝන් සිවදිපුත්‍රෝ ");
INSERT INTO sansin_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","යාකූබ් තස්‍ය භ්‍රාතා යෝහන් ච ආන්ද්‍රියඃ ඵිලිපෝ බර්ථලමයඃ, ");
INSERT INTO sansin_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","මථී ථෝමා ච ආල්ඵීයපුත්‍රෝ යාකූබ් ථද්දීයඃ කිනානීයඃ ශිමෝන් යස්තං පරහස්තේෂ්වර්පයිෂ්‍යති ස ඊෂ්කරියෝතීයයිහූදාශ්ච| ");
INSERT INTO sansin_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ස ශිමෝනේ පිතර ඉත්‍යුපනාම දදෞ යාකූබ්‍යෝහන්භ්‍යාං ච බිනේරිගිශ් අර්ථතෝ මේඝනාදපුත්‍රාවිත්‍යුපනාම දදෞ| ");
INSERT INTO sansin_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","අනන්තරං තේ නිවේශනං ගතාඃ, කින්තු තත්‍රාපි පුනර්මහාන් ජනසමාගමෝ (අ)භවත් තස්මාත්තේ භෝක්තුමප්‍යවකාශං න ප්‍රාප්තාඃ| ");
INSERT INTO sansin_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","තතස්තස්‍ය සුහෘල්ලෝකා ඉමාං වාර්ත්තාං ප්‍රාප්‍ය ස හතඥානෝභූද් ඉති කථාං කථයිත්වා තං ධෘත්වානේතුං ගතාඃ| ");
INSERT INTO sansin_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","අපරඤ්ච යිරූශාලම ආගතා යේ යේ(අ)ධ්‍යාපකාස්තේ ජගදුරයං පුරුෂෝ භූතපත්‍යාබිෂ්ටස්තේන භූතපතිනා භූතාන් ත්‍යාජයති| ");
INSERT INTO sansin_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","තතස්තානාහූය යීශු ර්දෘෂ්ටාන්තෛඃ කථාං කථිතවාන් ශෛතාන් කථං ශෛතානං ත්‍යාජයිතුං ශක්නෝති? ");
INSERT INTO sansin_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","කිඤ්චන රාජ්‍යං යදි ස්වවිරෝධේන පෘථග් භවති තර්හි තද් රාජ්‍යං ස්ථිරං ස්ථාතුං න ශක්නෝති| ");
INSERT INTO sansin_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","තථා කස්‍යාපි පරිවාරෝ යදි පරස්පරං විරෝධී භවති තර්හි සෝපි පරිවාරඃ ස්ථිරං ස්ථාතුං න ශක්නෝති| ");
INSERT INTO sansin_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","තද්වත් ශෛතාන් යදි ස්වවිපක්‍ෂතයා උත්තිෂ්ඨන් භින්නෝ භවති තර්හි සෝපි ස්ථිරං ස්ථාතුං න ශක්නෝති කින්තූච්ඡින්නෝ භවති| ");
INSERT INTO sansin_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","අපරඤ්ච ප්‍රබලං ජනං ප්‍රථමං න බද්ධා කෝපි තස්‍ය ගෘහං ප්‍රවිශ්‍ය ද්‍රව්‍යාණි ලුණ්ඨයිතුං න ශක්නෝති, තං බද්ව්වෛව තස්‍ය ගෘහස්‍ය ද්‍රව්‍යාණි ලුණ්ඨයිතුං ශක්නෝති| ");
INSERT INTO sansin_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","අතෝහේතෝ ර‍්‍යුෂ්මභ්‍යමහං සත්‍යං කථයාමි මනුෂ්‍යාණාං සන්තානා යානි යානි පාපානීශ්වරනින්දාඤ්ච කුර්ව්වන්ති තේෂාං තත්සර්ව්වේෂාමපරාධානාං ක්‍ෂමා භවිතුං ශක්නෝති, ");
INSERT INTO sansin_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","කින්තු යඃ කශ්චිත් පවිත්‍රමාත්මානං නින්දති තස්‍යාපරාධස්‍ය ක්‍ෂමා කදාපි න භවිෂ්‍යති සෝනන්තදණ්ඩස්‍යාර්හෝ භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","තස්‍යාපවිත්‍රභූතෝ(අ)ස්ති තේෂාමේතත්කථාහේතෝඃ ස ඉත්ථං කථිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","අථ තස්‍ය මාතා භ්‍රාතෘගණශ්චාගත්‍ය බහිස්තිෂ්ඨනතෝ ලෝකාන් ප්‍රේෂ්‍ය තමාහූතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","තතස්තත්සන්නිධෞ සමුපවිෂ්ටා ලෝකාස්තං බභාෂිරේ පශ්‍ය බහිස්තව මාතා භ්‍රාතරශ්ච ත්වාම් අන්විච්ඡන්ති| ");
INSERT INTO sansin_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","තදා ස තාන් ප්‍රත්‍යුවාච මම මාතා කා භ්‍රාතරෝ වා කේ? තතඃ පරං ස ස්වමීපෝපවිෂ්ටාන් ශිෂ්‍යාන් ප්‍රති අවලෝකනං කෘත්වා කථයාමාස ");
INSERT INTO sansin_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","පශ්‍යතෛතේ මම මාතා භ්‍රාතරශ්ච| ");
INSERT INTO sansin_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","යඃ කශ්චිද් ඊශ්වරස්‍යේෂ්ටාං ක්‍රියාං කරෝති ස ඒව මම භ්‍රාතා භගිනී මාතා ච| ");
INSERT INTO sansin_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","අනන්තරං ස සමුද්‍රතටේ පුනරුපදේෂ්ටුං ප්‍රාරේභේ, තතස්තත්‍ර බහුජනානාං සමාගමාත් ස සාගරෝපරි නෞකාමාරුහ්‍ය සමුපවිෂ්ටඃ; සර්ව්වේ ලෝකාඃ සමුද්‍රකූලේ තස්ථුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","තදා ස දෘෂ්ටාන්තකථාභි ර්බහූපදිෂ්ටවාන් උපදිශංශ්ච කථිතවාන්, ");
INSERT INTO sansin_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","අවධානං කුරුත, ඒකෝ බීජවප්තා බීජානි වප්තුං ගතඃ; ");
INSERT INTO sansin_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","වපනකාලේ කියන්ති බීජානි මාර්ගපාශ්වේ පතිතානි, තත ආකාශීයපක්‍ෂිණ ඒත්‍ය තානි චඛාදුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","කියන්ති බීජානි ස්වල්පමෘත්තිකාවත්පාෂාණභූමෞ පතිතානි තානි මෘදෝල්පත්වාත් ශීඝ්‍රමඞ්කුරිතානි; ");
INSERT INTO sansin_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","කින්තූදිතේ සූර‍්‍ය්‍යේ දග්ධානි තථා මූලානෝ නාධෝගතත්වාත් ශුෂ්කාණි ච| ");
INSERT INTO sansin_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","කියන්ති බීජානි කණ්ටකිවනමධ්‍යේ පතිතානි තතඃ කණ්ටකානි සංවෘද්ව්‍ය තානි ජග්‍රසුස්තානි න ච ඵලිතානි| ");
INSERT INTO sansin_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","තථා කියන්ති බීජාන්‍යුත්තමභූමෞ පතිතානි තානි සංවෘද්ව්‍ය ඵලාන්‍යුත්පාදිතානි කියන්ති බීජානි ත්‍රිංශද්ගුණානි කියන්ති ෂෂ්ටිගුණානි කියන්ති ශතගුණානි ඵලානි ඵලිතවන්ති| ");
INSERT INTO sansin_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","අථ ස තානවදත් යස්‍ය ශ්‍රෝතුං කර්ණෞ ස්තඃ ස ශෘණෝතු| ");
INSERT INTO sansin_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","තදනන්තරං නිර්ජනසමයේ තත්සඞ්ගිනෝ ද්වාදශශිෂ්‍යාශ්ච තං තද්දෘෂ්ටාන්තවාක්‍යස්‍යාර්ථං පප්‍රච්ඡුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","තදා ස තානුදිතවාන් ඊශ්වරරාජ්‍යස්‍ය නිගූඪවාක්‍යං බෝද්ධුං යුෂ්මාකමධිකාරෝ(අ)ස්ති; ");
INSERT INTO sansin_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","කින්තු යේ වහිර්භූතාඃ \"තේ පශ්‍යන්තඃ පශ්‍යන්ති කින්තු න ජානන්ති, ශෘණ්වන්තඃ ශෘණ්වන්ති කින්තු න බුධ්‍යන්තේ, චේත්තෛ ර්මනඃසු කදාපි පරිවර්ත්තිතේෂු තේෂාං පාපාන්‍යමෝචයිෂ්‍යන්ත,\" අතෝහේතෝස්තාන් ප්‍රති දෘෂ්ටාන්තෛරේව තානි මයා කථිතානි| ");
INSERT INTO sansin_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","අථ ස කථිතවාන් යූයං කිමේතද් දෘෂ්ටාන්තවාක්‍යං න බුධ්‍යධ්වේ? තර්හි කථං සර්ව්වාන් දෘෂ්ටාන්තාන භෝත්ස්‍යධ්වේ? ");
INSERT INTO sansin_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","බීජවප්තා වාක්‍යරූපාණි බීජානි වපති; ");
INSERT INTO sansin_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","තත්‍ර යේ යේ ලෝකා වාක්‍යං ශෘණ්වන්ති, කින්තු ශ්‍රුතමාත්‍රාත් ශෛතාන් ශීඝ්‍රමාගත්‍ය තේෂාං මනඃසූප්තානි තානි වාක්‍යරූපාණි බීජාන්‍යපනයති තඒව උප්තබීජමාර්ගපාර්ශ්වේස්වරූපාඃ| ");
INSERT INTO sansin_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","යේ ජනා වාක්‍යං ශ්‍රුත්වා සහසා පරමානන්දේන ගෘහ්ලන්ති, කින්තු හෘදි ස්ථෛර‍්‍ය්‍යාභාවාත් කිඤ්චිත් කාලමාත්‍රං තිෂ්ඨන්ති තත්පශ්චාත් තද්වාක්‍යහේතෝඃ ");
INSERT INTO sansin_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","කුත්‍රචිත් ක්ලේශේ උපද්‍රවේ වා සමුපස්ථිතේ තදෛව විඝ්නං ප්‍රාප්නුවන්ති තඒව උප්තබීජපාෂාණභූමිස්වරූපාඃ| ");
INSERT INTO sansin_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","යේ ජනාඃ කථාං ශෘණ්වන්ති කින්තු සාංසාරිකී චින්තා ධනභ්‍රාන්ති ර්විෂයලෝභශ්ච ඒතේ සර්ව්වේ උපස්ථාය තාං කථාං ග්‍රසන්ති තතඃ මා විඵලා භවති ");
INSERT INTO sansin_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","තඒව උප්තබීජසකණ්ටකභූමිස්වරූපාඃ| ");
INSERT INTO sansin_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","යේ ජනා වාක්‍යං ශ්‍රුත්වා ගෘහ්ලන්ති තේෂාං කස්‍ය වා ත්‍රිංශද්ගුණානි කස්‍ය වා ෂෂ්ටිගුණානි කස්‍ය වා ශතගුණානි ඵලානි භවන්ති තඒව උප්තබීජෝර්ව්වරභූමිස්වරූපාඃ| ");
INSERT INTO sansin_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","තදා සෝ(අ)පරමපි කථිතවාන් කෝපි ජනෝ දීපාධාරං පරිත්‍යජ්‍ය ද්‍රෝණස්‍යාධඃ ඛට්වායා අධේ වා ස්ථාපයිතුං දීපමානයති කිං? ");
INSERT INTO sansin_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","අතෝහේතෝ ර‍්‍යන්න ප්‍රකාශයිෂ්‍යතේ තාදෘග් ලුක්කායිතං කිමපි වස්තු නාස්ති; යද් ව්‍යක්තං න භවිෂ්‍යති තාදෘශං ගුප්තං කිමපි වස්තු නාස්ති| ");
INSERT INTO sansin_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","යස්‍ය ශ්‍රෝතුං කර්ණෞ ස්තඃ ස ශෘණෝතු| ");
INSERT INTO sansin_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","අපරමපි කථිතවාන් යූයං යද් යද් වාක්‍යං ශෘණුථ තත්‍ර සාවධානා භවත, යතෝ යූයං යේන පරිමාණේන පරිමාථ තේනෛව පරිමාණේන යුෂ්මදර්ථමපි පරිමාස්‍යතේ; ශ්‍රෝතාරෝ යූයං යුෂ්මභ්‍යමධිකං දාස්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","යස්‍යාශ්‍රයේ වර්ද්ධතේ තස්මෛ අපරමපි දාස්‍යතේ, කින්තු යස්‍යාශ්‍රයේ න වර්ද්ධතේ තස්‍ය යත් කිඤ්චිදස්ති තදපි තස්මාන් නේෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","අනන්තරං ස කථිතවාන් ඒකෝ ලෝකඃ ක්‍ෂේත්‍රේ බීජාන්‍යුප්ත්වා ");
INSERT INTO sansin_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ජාගරණනිද්‍රාභ්‍යාං දිවානිශං ගමයති, පරන්තු තද්වීජං තස්‍යාඥාතරූපේණාඞ්කුරයති වර්ද්ධතේ ච; ");
INSERT INTO sansin_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","යතෝහේතෝඃ ප්‍රථමතඃ පත්‍රාණි තතඃ පරං කණිශානි තත්පශ්චාත් කණිශපූර්ණානි ශස්‍යානි භූමිඃ ස්වයමුත්පාදයති; ");
INSERT INTO sansin_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","කින්තු ඵලේෂු පක්කේෂු ශස්‍යච්ඡේදනකාලං ඥාත්වා ස තත්ක්‍ෂණං ශස්‍යානි ඡිනත්ති, අනේන තුල්‍යමීශ්වරරාජ්‍යං| ");
INSERT INTO sansin_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","පුනඃ සෝ(අ)කථයද් ඊශ්වරරාජ්‍යං කේන සමං? කේන වස්තුනා සහ වා තදුපමාස්‍යාමි? ");
INSERT INTO sansin_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","තත් සර්ෂපෛකේන තුල්‍යං යතෝ මෘදි වපනකාලේ සර්ෂපබීජං සර්ව්වපෘථිවීස්ථබීජාත් ක්‍ෂුද්‍රං ");
INSERT INTO sansin_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","කින්තු වපනාත් පරම් අඞ්කුරයිත්වා සර්ව්වශාකාද් බෘහද් භවති, තස්‍ය බෘහත්‍යඃ ශාඛාශ්ච ජායන්තේ තතස්තච්ඡායාං පක්‍ෂිණ ආශ්‍රයන්තේ| ");
INSERT INTO sansin_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ඉත්ථං තේෂාං බෝධානුරූපං සෝ(අ)නේකදෘෂ්ටාන්තෛස්තානුපදිෂ්ටවාන්, ");
INSERT INTO sansin_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","දෘෂ්ටාන්තං විනා කාමපි කථාං තේභ්‍යෝ න කථිතවාන් පශ්චාන් නිර්ජනේ ස ශිෂ්‍යාන් සර්ව්වදෘෂ්ටාන්තාර්ථං බෝධිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","තද්දිනස්‍ය සන්ධ්‍යායාං ස තේභ්‍යෝ(අ)කථයද් ආගච්ඡත වයං පාරං යාම| ");
INSERT INTO sansin_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","තදා තේ ලෝකාන් විසෘජ්‍ය තමවිලම්බං ගෘහීත්වා නෞකයා ප්‍රතස්ථිරේ; අපරා අපි නාවස්තයා සහ ස්ථිතාඃ| ");
INSERT INTO sansin_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","තතඃ පරං මහාඣඤ්භ්ශගමාත් නෞ ර්දෝලායමානා තරඞ්ගේණ ජලෛඃ පූර්ණාභවච්ච| ");
INSERT INTO sansin_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","තදා ස නෞකාචශ්චාද්භාගේ උපධානේ ශිරෝ නිධාය නිද්‍රිත ආසීත් තතස්තේ තං ජාගරයිත්වා ජගදුඃ, හේ ප්‍රභෝ, අස්මාකං ප්‍රාණා යාන්ති කිමත්‍ර භවතශ්චින්තා නාස්ති? ");
INSERT INTO sansin_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","තදා ස උත්ථාය වායුං තර්ජිතවාන් සමුද්‍රඤ්චෝක්තවාන් ශාන්තඃ සුස්ථිරශ්ච භව; තතෝ වායෞ නිවෘත්තේ(අ)බ්ධිර්නිස්තරඞ්ගෝභූත්| ");
INSERT INTO sansin_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","තදා ස තානුවාච යූයං කුත ඒතාදෘක්ශඞ්කාකුලා භවත? කිං වෝ විශ්වාසෝ නාස්ති? ");
INSERT INTO sansin_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","තස්මාත්තේ(අ)තීවභීතාඃ පරස්පරං වක්තුමාරේභිරේ, අහෝ වායුඃ සින්ධුශ්චාස්‍ය නිදේශග්‍රාහිණෞ කීදෘගයං මනුජඃ| ");
INSERT INTO sansin_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","අථ තූ සින්ධුපාරං ගත්වා ගිදේරීයප්‍රදේශ උපතස්ථුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","නෞකාතෝ නිර්ගතමාත්‍රාද් අපවිත්‍රභූතග්‍රස්ත ඒකඃ ශ්මශානාදේත්‍ය තං සාක්‍ෂාච් චකාර| ");
INSERT INTO sansin_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ස ශ්මශානේ(අ)වාත්සීත් කෝපි තං ශෘඞ්ඛලේන බද්ව්වා ස්ථාපයිතුං නාශක්නෝත්| ");
INSERT INTO sansin_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ජනෛර්වාරං නිගඩෛඃ ශෘඞ්ඛලෛශ්ච ස බද්ධෝපි ශෘඞ්ඛලාන්‍යාකෘෂ්‍ය මෝචිතවාන් නිගඩානි ච භංක්ත්වා ඛණ්ඩං ඛණ්ඩං කෘතවාන් කෝපි තං වශීකර්ත්තුං න ශශක| ");
INSERT INTO sansin_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","දිවානිශං සදා පර්ව්වතං ශ්මශානඤ්ච භ්‍රමිත්වා චීත්ශබ්දං කෘතවාන් ග්‍රාවභිශ්ච ස්වයං ස්වං කෘතවාන්| ");
INSERT INTO sansin_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ස යීශුං දූරාත් පශ්‍යන්නේව ධාවන් තං ප්‍රණනාම උචෛරුවංශ්චෝවාච, ");
INSERT INTO sansin_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","හේ සර්ව්වෝපරිස්ථේශ්වරපුත්‍ර යීශෝ භවතා සහ මේ කඃ සම්බන්ධඃ? අහං ත්වාමීශ්වරේණ ශාපයේ මාං මා යාතය| ");
INSERT INTO sansin_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","යතෝ යීශුස්තං කථිතවාන් රේ අපවිත්‍රභූත, අස්මාන්නරාද් බහිර්නිර්ගච්ඡ| ");
INSERT INTO sansin_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","අථ ස තං පෘෂ්ටවාන් කින්තේ නාම? තේන ප්‍රත්‍යුක්තං වයමනේකේ (අ)ස්මස්තතෝ(අ)ස්මන්නාම බාහිනී| ");
INSERT INTO sansin_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","තතෝස්මාන් දේශාන්න ප්‍රේෂයේති තේ තං ප්‍රාර්ථයන්ත| ");
INSERT INTO sansin_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","තදානීං පර්ව්වතං නිකෂා බෘහන් වරාහව්‍රජශ්චරන්නාසීත්| ");
INSERT INTO sansin_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","තස්මාද් භූතා විනයේන ජගදුඃ, අමුං වරාහව්‍රජම් ආශ්‍රයිතුම් අස්මාන් ප්‍රහිණු| ");
INSERT INTO sansin_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","යීශුනානුඥාතාස්තේ(අ)පවිත්‍රභූතා බහිර්නිර‍්‍යාය වරාහව්‍රජං ප්‍රාවිශන් තතඃ සර්ව්වේ වරාහා වස්තුතස්තු ප්‍රායෝද්විසහස්‍රසංඞ්ඛ්‍යකාඃ කටකේන මහාජවාද් ධාවන්තඃ සින්ධෞ ප්‍රාණාන් ජහුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","තස්මාද් වරාහපාලකාඃ පලායමානාඃ පුරේ ග්‍රාමේ ච තද්වාර්ත්තං කථයාඤ්චක්‍රුඃ| තදා ලෝකා ඝටිතං තත්කාර‍්‍ය්‍යං ද්‍රෂ්ටුං බහිර්ජග්මුඃ ");
INSERT INTO sansin_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","යීශෝඃ සන්නිධිං ගත්වා තං භූතග්‍රස්තම් අර්ථාද් බාහිනීභූතග්‍රස්තං නරං සවස්ත්‍රං සචේතනං සමුපවිෂ්ටඤ්ච දෘृෂ්ට්වා බිභ්‍යුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","තතෝ දෘෂ්ටතත්කාර‍්‍ය්‍යලෝකාස්තස්‍ය භූතග්‍රස්තනරස්‍ය වරාහව්‍රජස්‍යාපි තාං ධටනාං වර්ණයාමාසුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","තතස්තේ ස්වසීමාතෝ බහිර්ගන්තුං යීශුං විනේතුමාරේභිරේ| ");
INSERT INTO sansin_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","අථ තස්‍ය නෞකාරෝහණකාලේ ස භූතමුක්තෝ නා යීශුනා සහ ස්ථාතුං ප්‍රාර්ථයතේ; ");
INSERT INTO sansin_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","කින්තු ස තමනනුමත්‍ය කථිතවාන් ත්වං නිජාත්මීයානාං සමීපං ගෘහඤ්ච ගච්ඡ ප්‍රභුස්ත්වයි කෘපාං කෘත්වා යානි කර්ම්මාණි කෘතවාන් තානි තාන් ඥාපය| ");
INSERT INTO sansin_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","අතඃ ස ප්‍රස්ථාය යීශුනා කෘතං තත්සර්ව්වාශ්චර‍්‍ය්‍යං කර්ම්ම දිකාපලිදේශේ ප්‍රචාරයිතුං ප්‍රාරබ්ධවාන් තතඃ සර්ව්වේ ලෝකා ආශ්චර‍්‍ය්‍යං මේනිරේ| ");
INSERT INTO sansin_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","අනන්තරං යීශෞ නාවා පුනරන්‍යපාර උත්තීර්ණේ සින්ධුතටේ ච තිෂ්ඨති සති තත්සමීපේ බහුලෝකානාං සමාගමෝ(අ)භූත්| ");
INSERT INTO sansin_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","අපරං යායීර් නාම්නා කශ්චිද් භජනගෘහස්‍යාධිප ආගත්‍ය තං දෘෂ්ට්වෛව චරණයෝඃ පතිත්වා බහු නිවේද්‍ය කථිතවාන්; ");
INSERT INTO sansin_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","මම කන්‍යා මෘතප්‍රායාභූද් අතෝ භවානේත්‍ය තදාරෝග්‍යාය තස්‍යා ගාත්‍රේ හස්තම් අර්පයතු තේනෛව සා ජීවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","තදා යීශුස්තේන සහ චලිතඃ කින්තු තත්පශ්චාද් බහුලෝකාශ්චලිත්වා තාද්ගාත්‍රේ පතිතාඃ| ");
INSERT INTO sansin_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","අථ ද්වාදශවර්ෂාණි ප්‍රදරරෝගේණ ");
INSERT INTO sansin_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ශීර්ණා චිකිත්සකානාං නානාචිකිත්සාභිශ්ච දුඃඛං භුක්තවතී ච සර්ව්වස්වං ව්‍යයිත්වාපි නාරෝග්‍යං ප්‍රාප්තා ච පුනරපි පීඩිතාසීච්ච ");
INSERT INTO sansin_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","යා ස්ත්‍රී සා යීශෝ ර්වාර්ත්තාං ප්‍රාප්‍ය මනසාකථයත් යද්‍යහං තස්‍ය වස්ත්‍රමාත්‍ර ස්ප්‍රෂ්ටුං ලභේයං තදා රෝගහීනා භවිෂ්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","අතෝහේතෝඃ සා ලෝකාරණ්‍යමධ්‍යේ තත්පශ්චාදාගත්‍ය තස්‍ය වස්ත්‍රං පස්පර්ශ| ");
INSERT INTO sansin_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","තේනෛව තත්ක්‍ෂණං තස්‍යා රක්තස්‍රෝතඃ ශුෂ්කං ස්වයං තස්මාද් රෝගාන්මුක්තා ඉත්‍යපි දේහේ(අ)නුභූතා| ");
INSERT INTO sansin_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","අථ ස්වස්මාත් ශක්ති ර්නිර්ගතා යීශුරේතන්මනසා ඥාත්වා ලෝකනිවහං ප්‍රති මුඛං ව්‍යාවෘත්‍ය පෘෂ්ටවාන් කේන මද්වස්ත්‍රං ස්පෘෂ්ටං? ");
INSERT INTO sansin_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","තතස්තස්‍ය ශිෂ්‍යා ඌචුඃ භවතෝ වපුෂි ලෝකාඃ සංඝර්ෂන්ති තද් දෘෂ්ට්වා කේන මද්වස්ත්‍රං ස්පෘෂ්ටමිති කුතඃ කථයති? ");
INSERT INTO sansin_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","කින්තු කේන තත් කර්ම්ම කෘතං තද් ද්‍රෂ්ටුං යීශුශ්චතුර්දිශෝ දෘෂ්ටවාන්| ");
INSERT INTO sansin_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","තතඃ සා ස්ත්‍රී භීතා කම්පිතා ච සතී ස්වස්‍යා රුක්ප්‍රතික්‍රියා ජාතේති ඥාත්වාගත්‍ය තත්සම්මුඛේ පතිත්වා සර්ව්වවෘත්තාන්තං සත්‍යං තස්මෛ කථයාමාස| ");
INSERT INTO sansin_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","තදානීං යීශුස්තාං ගදිතවාන්, හේ කන්‍යේ තව ප්‍රතීතිස්ත්වාම් අරෝගාමකරෝත් ත්වං ක්‍ෂේමේණ ව්‍රජ ස්වරෝගාන්මුක්තා ච තිෂ්ඨ| ");
INSERT INTO sansin_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ඉතිවාක්‍යවදනකාලේ භජනගෘහාධිපස්‍ය නිවේශනාල් ලෝකා ඒත්‍යාධිපං බභාෂිරේ තව කන්‍යා මෘතා තස්මාද් ගුරුං පුනඃ කුතඃ ක්ලිශ්නාසි? ");
INSERT INTO sansin_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","කින්තු යීශුස්තද් වාක්‍යං ශ්‍රුත්වෛව භජනගෘහාධිපං ගදිතවාන් මා භෛෂීඃ කේවලං විශ්වාසිහි| ");
INSERT INTO sansin_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","අථ පිතරෝ යාකූබ් තද්භ්‍රාතා යෝහන් ච ඒතාන් විනා කමපි ස්වපශ්චාද් යාතුං නාන්වමන්‍යත| ");
INSERT INTO sansin_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","තස්‍ය භජනගෘහාධිපස්‍ය නිවේශනසමීපම් ආගත්‍ය කලහං බහුරෝදනං විලාපඤ්ච කුර්ව්වතෝ ලෝකාන් දදර්ශ| ");
INSERT INTO sansin_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","තස්මාන් නිවේශනං ප්‍රවිශ්‍ය ප්‍රෝක්තවාන් යූයං කුත ඉත්ථං කලහං රෝදනඤ්ච කුරුථ? කන්‍යා න මෘතා නිද්‍රාති| ");
INSERT INTO sansin_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","තස්මාත්තේ තමුපජහසුඃ කින්තු යීශුඃ සර්ව්වාන බහිෂ්කෘත්‍ය කන්‍යායාඃ පිතරෞ ස්වසඞ්ගිනශ්ච ගෘහීත්වා යත්‍ර කන්‍යාසීත් තත් ස්ථානං ප්‍රවිෂ්ටවාන්| ");
INSERT INTO sansin_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","අථ ස තස්‍යාඃ කන්‍යායා හස්තෞ ධෘත්වා තාං බභාෂේ ටාලීථා කූමී, අර්ථතෝ හේ කන්‍යේ ත්වමුත්තිෂ්ඨ ඉත්‍යාඥාපයාමි| ");
INSERT INTO sansin_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","තුනෛව තත්ක්‍ෂණං සා ද්වාදශවර්ෂවයස්කා කන්‍යා පෝත්ථාය චලිතුමාරේභේ, ඉතඃ සර්ව්වේ මහාවිස්මයං ගතාඃ| ");
INSERT INTO sansin_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","තත ඒතස්‍යෛ කිඤ්චිත් ඛාද්‍යං දත්තේති කථයිත්වා ඒතත්කර්ම්ම කමපි න ඥාපයතේති දෘඪමාදිෂ්ටවාන්| ");
INSERT INTO sansin_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","අනන්තරං ස තත්ස්ථානාත් ප්‍රස්ථාය ස්වප්‍රදේශමාගතඃ ශිෂ්‍යාශ්ච තත්පශ්චාද් ගතාඃ| ");
INSERT INTO sansin_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","අථ විශ්‍රාමවාරේ සති ස භජනගෘහේ උපදේෂ්ටුමාරබ්ධවාන් තතෝ(අ)නේකේ ලෝකාස්තත්කථාං ශ්‍රුත්වා විස්මිත්‍ය ජගදුඃ, අස්‍ය මනුජස්‍ය ඊදෘශී ආශ්චර‍්‍ය්‍යක්‍රියා කස්මාජ් ජාතා? තථා ස්වකරාභ්‍යාම් ඉත්ථමද්භුතං කර්ම්ම කර්ත්තාुම් ඒතස්මෛ කථං ඥානං දත්තම්? ");
INSERT INTO sansin_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","කිමයං මරියමඃ පුත්‍රස්තඥා නෝ? කිමයං යාකූබ්-යෝසි-යිහුදා-ශිමෝනාං භ්‍රාතා නෝ? අස්‍ය භගින්‍යඃ කිමිහාස්මාභිඃ සහ නෝ? ඉත්ථං තේ තදර්ථේ ප්‍රත්‍යූහං ගතාඃ| ");
INSERT INTO sansin_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","තදා යීශුස්තේභ්‍යෝ(අ)කථයත් ස්වදේශං ස්වකුටුම්බාන් ස්වපරිජනාංශ්ච විනා කුත්‍රාපි භවිෂ්‍යද්වාදී අසත්කෘතෝ න භවති| ");
INSERT INTO sansin_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","අපරඤ්ච තේෂාමප්‍රත්‍යයාත් ස විස්මිතඃ කියතාං රෝගිණාං වපුඃෂු හස්තම් අර්පයිත්වා කේවලං තේෂාමාරෝග්‍යකරණාද් අන්‍යත් කිමපි චිත්‍රකාර‍්‍ය්‍යං කර්ත්තාං න ශක්තඃ| ");
INSERT INTO sansin_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","අථ ස චතුර්දික්ස්ථ ග්‍රාමාන් භ්‍රමිත්වා උපදිෂ්ටවාන් ");
INSERT INTO sansin_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ද්වාදශශිෂ්‍යාන් ආහූය අමේධ්‍යභූතාන් වශීකර්ත්තාං ශක්තිං දත්ත්වා තේෂාං ද්වෞ ද්වෞ ජනෝ ප්‍රේෂිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","පුනරිත්‍යාදිශද් යූයම් ඒකෛකාං යෂ්ටිං විනා වස්ත්‍රසංපුටඃ පූපඃ කටිබන්ධේ තාම්‍රඛණ්ඩඤ්ච ඒෂාං කිමපි මා ග්‍රහ්ලීත, ");
INSERT INTO sansin_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","මාර්ගයාත්‍රායෛ පාදේෂූපානහෞ දත්ත්වා ද්වේ උත්තරීයේ මා පරිධද්ව්වං| ");
INSERT INTO sansin_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","අපරමප්‍යුක්තං තේන යූයං යස්‍යාං පුර‍්‍ය්‍යාං යස්‍ය නිවේශනං ප්‍රවේක්‍ෂ්‍යථ තාං පුරීං යාවන්න ත්‍යක්‍ෂ්‍යථ තාවත් තන්නිවේශනේ ස්ථාස්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","තත්‍ර යදි කේපි යුෂ්මාකමාතිථ්‍යං න විදධති යුෂ්මාකං කථාශ්ච න ශෘණ්වන්ති තර්හි තත්ස්ථානාත් ප්‍රස්ථානසමයේ තේෂාං විරුද්ධං සාක්‍ෂ්‍යං දාතුං ස්වපාදානාස්ඵාල්‍ය රජඃ සම්පාතයත; අහං යුෂ්මාන් යථාර්ථං වච්මි විචාරදිනේ තන්නගරස්‍යාවස්ථාතඃ සිදෝමාමෝරයෝ ර්නගරයෝරවස්ථා සහ්‍යතරා භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","අථ තේ ගත්වා ලෝකානාං මනඃපරාවර්ත්තනීඃ කථා ප්‍රචාරිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ඒවමනේකාන් භූතාංශ්ච ත්‍යාජිතවන්තස්තථා තෛලේන මර්ද්දයිත්වා බහූන් ජනානරෝගානකාර්ෂුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ඉත්ථං තස්‍ය සුඛ්‍යාතිශ්චතුර්දිශෝ ව්‍යාප්තා තදා හේරෝද් රාජා තන්නිශම්‍ය කථිතවාන්, යෝහන් මජ්ජකඃ ශ්මශානාද් උත්ථිත අතෝහේතෝස්තේන සර්ව්වා ඒතා අද්භුතක්‍රියාඃ ප්‍රකාශන්තේ| ");
INSERT INTO sansin_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","අන්‍යේ(අ)කථයන් අයම් ඒලියඃ, කේපි කථිතවන්ත ඒෂ භවිෂ්‍යද්වාදී යද්වා භවිෂ්‍යද්වාදිනාං සදෘශ ඒකෝයම්| ");
INSERT INTO sansin_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","කින්තු හේරෝද් ඉත්‍යාකර්ණ්‍ය භාෂිතවාන් යස්‍යාහං ශිරශ්ඡින්නවාන් ස ඒව යෝහනයං ස ශ්මශානාදුදතිෂ්ඨත්| ");
INSERT INTO sansin_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","පූර්ව්වං ස්වභ්‍රාතුඃ ඵිලිපස්‍ය පත්න්‍යා උද්වාහං කෘතවන්තං හේරෝදං යෝහනවාදීත් ස්වභාතෘවධූ ර්න විවාහ්‍යා| ");
INSERT INTO sansin_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","අතඃ කාරණාත් හේරෝද් ලෝකං ප්‍රහිත්‍ය යෝහනං ධෘත්වා බන්ධනාලයේ බද්ධවාන්| ");
INSERT INTO sansin_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","හේරෝදියා තස්මෛ යෝහනේ ප්‍රකුප්‍ය තං හන්තුම් ඓච්ඡත් කින්තු න ශක්තා, ");
INSERT INTO sansin_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","යස්මාද් හේරෝද් තං ධාර්ම්මිකං සත්පුරුෂඤ්ච ඥාත්වා සම්මන්‍ය රක්‍ෂිතවාන්; තත්කථාං ශ්‍රුත්වා තදනුසාරේණ බහූනි කර්ම්මාණි කෘතවාන් හෘෂ්ටමනාස්තදුපදේශං ශ්‍රුතවාංශ්ච| ");
INSERT INTO sansin_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","කින්තු හේරෝද් යදා ස්වජන්මදිනේ ප්‍රධානලෝකේභ්‍යඃ සේනානීභ්‍යශ්ච ගාලීල්ප්‍රදේශීයශ්‍රේෂ්ඨලෝකේභ්‍යශ්ච රාත්‍රෞ භෝජ්‍යමේකං කෘතවාන් ");
INSERT INTO sansin_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","තස්මින් ශුභදිනේ හේරෝදියායාඃ කන්‍යා සමේත්‍ය තේෂාං සමක්‍ෂං සංනෘත්‍ය හේරෝදස්තේන සහෝපවිෂ්ටානාඤ්ච තෝෂමජීජනත් තතා නෘපඃ කන්‍යාමාහ ස්ම මත්තෝ යද් යාචසේ තදේව තුභ්‍යං දාස්‍යේ| ");
INSERT INTO sansin_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ශපථං කෘත්වාකථයත් චේද් රාජ්‍යාර්ද්ධමපි යාචසේ තදපි තුභ්‍යං දාස්‍යේ| ");
INSERT INTO sansin_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","තතඃ සා බහි ර්ගත්වා ස්වමාතරං පප්‍රච්ඡ කිමහං යාචිෂ්‍යේ? තදා සාකථයත් යෝහනෝ මජ්ජකස්‍ය ශිරඃ| ");
INSERT INTO sansin_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","අථ තූර්ණං භූපසමීපම් ඒත්‍ය යාචමානාවදත් ක්‍ෂණේස්මින් යෝහනෝ මජ්ජකස්‍ය ශිරඃ පාත්‍රේ නිධාය දේහි, ඒතද් යාචේ(අ)හං| ");
INSERT INTO sansin_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","තස්මාත් භූපෝ(අ)තිදුඃඛිතඃ, තථාපි ස්වශපථස්‍ය සහභෝජිනාඤ්චානුරෝධාත් තදනඞ්ගීකර්ත්තුං න ශක්තඃ| ");
INSERT INTO sansin_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","තත්ක්‍ෂණං රාජා ඝාතකං ප්‍රේෂ්‍ය තස්‍ය ශිර ආනේතුමාදිෂ්ටවාන්| ");
INSERT INTO sansin_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","තතඃ ස කාරාගාරං ගත්වා තච්ඡිරශ්ඡිත්වා පාත්‍රේ නිධායානීය තස්‍යෛ කන්‍යායෛ දත්තවාන් කන්‍යා ච ස්වමාත්‍රේ දදෞ| ");
INSERT INTO sansin_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","අනනතරං යෝහනඃ ශිෂ්‍යාස්තද්වාර්ත්තාං ප්‍රාප්‍යාගත්‍ය තස්‍ය කුණපං ශ්මශානේ(අ)ස්ථාපයන්| ");
INSERT INTO sansin_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","අථ ප්‍රේෂිතා යීශෝඃ සන්නිධෞ මිලිතා යද් යච් චක්‍රුඃ ශික්‍ෂයාමාසුශ්ච තත්සර්ව්වවාර්ත්තාස්තස්මෛ කථිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ස තානුවාච යූයං විජනස්ථානං ගත්වා විශ්‍රාම්‍යත යතස්තත්සන්නිධෞ බහුලෝකානාං සමාගමාත් තේ භෝක්තුං නාවකාශං ප්‍රාප්තාඃ| ");
INSERT INTO sansin_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","තතස්තේ නාවා විජනස්ථානං ගුප්තං ගග්මුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","තතෝ ලෝකනිවහස්තේෂාං ස්ථානාන්තරයානං දදර්ශ, අනේකේ තං පරිචිත්‍ය නානාපුරේභ්‍යඃ පදෛර්ව්‍රජිත්වා ජවේන තෛෂාමග්‍රේ යීශෝඃ සමීප උපතස්ථුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","තදා යීශු ර්නාවෝ බහිර්ගත්‍ය ලෝකාරණ්‍යානීං දෘෂ්ට්වා තේෂු කරුණාං කෘතවාන් යතස්තේ(අ)රක්‍ෂකමේෂා ඉවාසන් තදා ස තාන නානාප්‍රසඞ්ගාන් උපදිෂ්ටවාන්| ");
INSERT INTO sansin_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","අථ දිවාන්තේ සති ශිෂ්‍යා ඒත්‍ය යීශුමූචිරේ, ඉදං විජනස්ථානං දිනඤ්චාවසන්නං| ");
INSERT INTO sansin_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ලෝකානාං කිමපි ඛාද්‍යං නාස්ති, අතශ්චතුර්දික්‍ෂු ග්‍රාමාන් ගන්තුං භෝජ්‍යද්‍රව්‍යාණි ක්‍රේතුඤ්ච භවාන් තාන් විසෘජතු| ");
INSERT INTO sansin_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","තදා ස තානුවාච යූයමේව තාන් භෝජයත; තතස්තේ ජගදු ර්වයං ගත්වා ද්විශතසංඛ්‍යකෛ ර්මුද්‍රාපාදෛඃ පූපාන් ක්‍රීත්වා කිං තාන් භෝජයිෂ්‍යාමඃ? ");
INSERT INTO sansin_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","තදා ස තාන් පෘෂ්ඨවාන් යුෂ්මාකං සන්නිධෞ කති පූපා ආසතේ? ගත්වා පශ්‍යත; තතස්තේ දෘෂ්ට්වා තමවදන් පඤ්ච පූපා ද්වෞ මත්ස්‍යෞ ච සන්ති| ");
INSERT INTO sansin_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","තදා ස ලෝකාන් ශස්පෝපරි පංක්තිභිරුපවේශයිතුම් ආදිෂ්ටවාන්, ");
INSERT INTO sansin_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","තතස්තේ ශතං ශතං ජනාඃ පඤ්චාශත් පඤ්චාශජ්ජනාශ්ච පංක්තිභි ර්භුවි සමුපවිවිශුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","අථ ස තාන් පඤ්චපූපාන් මත්ස්‍යද්වයඤ්ච ධෘත්වා ස්වර්ගං පශ්‍යන් ඊශ්වරගුණාන් අන්වකීර්ත්තයත් තාන් පූපාන් භංක්ත්වා ලෝකේභ්‍යඃ පරිවේෂයිතුං ශිෂ්‍යේභ්‍යෝ දත්තවාන් ද්වා මත්ස්‍යෞ ච විභජ්‍ය සර්ව්වේභ්‍යෝ දත්තවාන්| ");
INSERT INTO sansin_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","තතඃ සර්ව්වේ භුක්ත්වාතෘප්‍යන්| ");
INSERT INTO sansin_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","අනන්තරං ශිෂ්‍යා අවශිෂ්ටෛඃ පූපෛ ර්මත්ස්‍යෛශ්ච පූර්ණාන් ද්වදශ ඩල්ලකාන් ජගෘහුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","තේ භෝක්තාරඃ ප්‍රායඃ පඤ්ච සහස්‍රාණි පුරුෂා ආසන්| ");
INSERT INTO sansin_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","අථ ස ලෝකාන් විසෘජන්නේව නාවමාරෝඪුං ස්වස්මාදග්‍රේ පාරේ බෛත්සෛදාපුරං යාතුඤ්ච ශ්ෂ්‍යිाන් වාඪමාදිෂ්ටවාන්| ");
INSERT INTO sansin_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","තදා ස සර්ව්වාන් විසෘජ්‍ය ප්‍රාර්ථයිතුං පර්ව්වතං ගතඃ| ");
INSERT INTO sansin_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","තතඃ සන්ධ්‍යායාං සත්‍යාං නෞඃ සින්ධුමධ්‍ය උපස්ථිතා කින්තු ස ඒකාකී ස්ථලේ ස්ථිතඃ| ");
INSERT INTO sansin_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","අථ සම්මුඛවාතවහනාත් ශිෂ්‍යා නාවං වාහයිත්වා පරිශ්‍රාන්තා ඉති ඥාත්වා ස නිශාචතුර්ථයාමේ සින්ධූපරි පද්භ්‍යාං ව්‍රජන් තේෂාං සමීපමේත්‍ය තේෂාමග්‍රේ යාතුම් උද්‍යතඃ| ");
INSERT INTO sansin_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","කින්තු ශිෂ්‍යාඃ සින්ධූපරි තං ව්‍රජන්තං දෘෂ්ට්වා භූතමනුමාය රුරුවුඃ, ");
INSERT INTO sansin_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","යතඃ සර්ව්වේ තං දෘෂ්ට්වා ව්‍යාකුලිතාඃ| අතඒව යීශුස්තත්ක්‍ෂණං තෛඃ සහාලප්‍ය කථිතවාන්, සුස්ථිරා භූත, අයමහං මා භෛෂ්ට| ");
INSERT INTO sansin_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","අථ නෞකාමාරුහ්‍ය තස්මින් තේෂාං සන්නිධිං ගතේ වාතෝ නිවෘත්තඃ; තස්මාත්තේ මනඃසු විස්මිතා ආශ්චර‍්‍ය්‍යං මේනිරේ| ");
INSERT INTO sansin_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","යතස්තේ මනසාං කාඨින්‍යාත් තත් පූපීයම් ආශ්චර‍්‍ය්‍යං කර්ම්ම න විවික්තවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","අථ තේ පාරං ගත්වා ගිනේෂරත්ප්‍රදේශමේත්‍ය තට උපස්ථිතාඃ| ");
INSERT INTO sansin_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","තේෂු නෞකාතෝ බහිර්ගතේෂු තත්ප්‍රදේශීයා ලෝකාස්තං පරිචිත්‍ය ");
INSERT INTO sansin_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","චතුර්දික්‍ෂු ධාවන්තෝ යත්‍ර යත්‍ර රෝගිණෝ නරා ආසන් තාන් සර්ව්වාන ඛට්වෝපරි නිධාය යත්‍ර කුත්‍රචිත් තද්වාර්ත්තාං ප්‍රාපුඃ තත් ස්ථානම් ආනේතුම් ආරේභිරේ| ");
INSERT INTO sansin_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","තථා යත්‍ර යත්‍ර ග්‍රාමේ යත්‍ර යත්‍ර පුරේ යත්‍ර යත්‍ර පල්ල්‍යාඤ්ච තේන ප්‍රවේශඃ කෘතස්තද්වර්ත්මමධ්‍යේ ලෝකාඃ පීඩිතාන් ස්ථාපයිත්වා තස්‍ය චේලග්‍රන්ථිමාත්‍රං ස්ප්‍රෂ්ටුම් තේෂාමර්ථේ තදනුඥාං ප්‍රාර්ථයන්තඃ යාවන්තෝ ලෝකාඃ පස්පෘශුස්තාවන්ත ඒව ගදාන්මුක්තාඃ| ");
INSERT INTO sansin_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","අනන්තරං යිරූශාලම ආගතාඃ ඵිරූශිනෝ(අ)ධ්‍යාපකාශ්ච යීශෝඃ සමීපම් ආගතාඃ| ");
INSERT INTO sansin_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","තේ තස්‍ය කියතඃ ශිෂ්‍යාන් අශුචිකරෛරර්ථාද අප්‍රක්‍ෂාලිතහස්තෛ ර්භුඤ්ජතෝ දෘෂ්ට්වා තානදූෂයන්| ");
INSERT INTO sansin_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","යතඃ ඵිරූශිනඃ සර්ව්වයිහූදීයාශ්ච ප්‍රාචාං පරම්පරාගතවාක්‍යං සම්මන්‍ය ප්‍රතලේන හස්තාන් අප්‍රක්‍ෂාල්‍ය න භුඤ්ජතේ| ");
INSERT INTO sansin_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ආපනාදාගත්‍ය මජ්ජනං විනා න ඛාදන්ති; තථා පානපාත්‍රාණාං ජලපාත්‍රාණාං පිත්තලපාත්‍රාණාම් ආසනානාඤ්ච ජලේ මජ්ජනම් ඉත්‍යාදයෝන්‍යේපි බහවස්තේෂාමාචාරාඃ සන්ති| ");
INSERT INTO sansin_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","තේ ඵිරූශිනෝ(අ)ධ්‍යාපකාශ්ච යීශුං පප්‍රච්ඡුඃ, තව ශිෂ්‍යාඃ ප්‍රාචාං පරම්පරාගතවාක්‍යානුසාරේණ නාචරන්තෝ(අ)ප්‍රක්‍ෂාලිතකරෛඃ කුතෝ භුජංතේ? ");
INSERT INTO sansin_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","තතඃ ස ප්‍රත්‍යුවාච කපටිනෝ යුෂ්මාන් උද්දිශ්‍ය යිශයියභවිෂ්‍යද්වාදී යුක්තමවාදීත්| යථා ස්වකීයෛරධරෛරේතේ සම්මන්‍යනතේ සදෛව මාං| කින්තු මත්තෝ විප්‍රකර්ෂේ සන්ති තේෂාං මනාංසි ච| ");
INSERT INTO sansin_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ශික්‍ෂයන්තෝ බිධීන් න්නාඥා භජන්තේ මාං මුධෛව තේ| ");
INSERT INTO sansin_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","යූයං ජලපාත්‍රපානපාත්‍රාදීනි මජ්ජයන්තෝ මනුජපරම්පරාගතවාක්‍යං රක්‍ෂථ කින්තු ඊශ්වරාඥාං ලංඝධ්වේ; අපරා ඊදෘශ්‍යෝනේකාඃ ක්‍රියා අපි කුරුධ්වේ| ");
INSERT INTO sansin_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","අන්‍යඤ්චාකථයත් යූයං ස්වපරම්පරාගතවාක්‍යස්‍ය රක්‍ෂාර්ථං ස්පෂ්ටරූපේණ ඊශ්වරාඥාං ලෝපයථ| ");
INSERT INTO sansin_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","යතෝ මූසාද්වාරා ප්‍රෝක්තමස්ති ස්වපිතරෞ සම්මන්‍යධ්වං යස්තු මාතරං පිතරං වා දුර්ව්වාක්‍යං වක්ති ස නිතාන්තං හන්‍යතාං| ");
INSERT INTO sansin_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","කින්තු මදීයේන යේන ද්‍රව්‍යේණ තවෝපකාරෝභවත් තත් කර්බ්බාණමර්ථාද් ඊශ්වරාය නිවේදිතම් ඉදං වාක්‍යං යදි කෝපි පිතරං මාතරං වා වක්ති ");
INSERT INTO sansin_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","තර්හි යූයං මාතුඃ පිතු ර්වෝපකාරං කර්ත්තාං තං වාරයථ| ");
INSERT INTO sansin_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ඉත්ථං ස්වප්‍රචාරිතපරම්පරාගතවාක්‍යේන යූයම් ඊශ්වරාඥාං මුධා විධද්ව්වේ, ඊදෘශාන්‍යන්‍යාන්‍යනේකානි කර්ම්මාණි කුරුධ්වේ| ");
INSERT INTO sansin_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","අථ ස ලෝකානාහූය බභාෂේ යූයං සර්ව්වේ මද්වාක්‍යං ශෘණුත බුධ්‍යධ්වඤ්ච| ");
INSERT INTO sansin_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","බාහ්‍යාදන්තරං ප්‍රවිශ්‍ය නරමමේධ්‍යං කර්ත්තාං ශක්නෝති ඊදෘශං කිමපි වස්තු නාස්ති, වරම් අන්තරාද් බහිර්ගතං යද්වස්තු තන්මනුජම් අමේධ්‍යං කරෝති| ");
INSERT INTO sansin_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","යස්‍ය ශ්‍රෝතුං ශ්‍රෝත්‍රේ ස්තඃ ස ශෘණෝතු| ");
INSERT INTO sansin_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","තතඃ ස ලෝකාන් හිත්වා ගෘහමධ්‍යං ප්‍රවිෂ්ටස්තදා ශිෂ්‍යාස්තදෘෂ්ටාන්තවාක්‍යාර්ථං පප්‍රච්ඡුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","තස්මාත් ස තාන් ජගාද යූයමපි කිමේතාදෘගබෝධාඃ? කිමපි ද්‍රව්‍යං බාහ්‍යාදන්තරං ප්‍රවිශ්‍ය නරමමේධ්‍යං කර්ත්තාං න ශක්නෝති කථාමිමාං කිං න බුධ්‍යධ්වේ? ");
INSERT INTO sansin_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","තත් තදන්තර්න ප්‍රවිශති කින්තු කුක්‍ෂිමධ්‍යං ප්‍රවිශති ශේෂේ සර්ව්වභුක්තවස්තුග්‍රාහිණි බහිර්දේශේ නිර‍්‍යාති| ");
INSERT INTO sansin_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","අපරමප්‍යවාදීද් යන්නරාන්නිරේති තදේව නරමමේධ්‍යං කරෝති| ");
INSERT INTO sansin_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","යතෝ(අ)න්තරාද් අර්ථාන් මානවානාං මනෝභ්‍යඃ කුචින්තා පරස්ත්‍රීවේශ්‍යාගමනං ");
INSERT INTO sansin_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","නරවධශ්චෞර‍්‍ය්‍යං ලෝභෝ දුෂ්ටතා ප්‍රවඤ්චනා කාමුකතා කුදෘෂ්ටිරීශ්වරනින්දා ගර්ව්වස්තම ඉත්‍යාදීනි නිර්ගච්ඡන්ති| ");
INSERT INTO sansin_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ඒතානි සර්ව්වාණි දුරිතාන්‍යන්තරාදේත්‍ය නරමමේධ්‍යං කුර්ව්වන්ති| ");
INSERT INTO sansin_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","අථ ස උත්ථාය තත්ස්ථානාත් සෝරසීදෝන්පුරප්‍රදේශං ජගාම තත්‍ර කිමපි නිවේශනං ප්‍රවිශ්‍ය සර්ව්වෛරඥාතඃ ස්ථාතුං මතිඤ්චක්‍රේ කින්තු ගුප්තඃ ස්ථාතුං න ශශාක| ");
INSERT INTO sansin_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","යතඃ සුරඵෛනිකීදේශීයයූනානීවංශෝද්භවස්ත්‍රියාඃ කන්‍යා භූතග්‍රස්තාසීත්| සා ස්ත්‍රී තද්වාර්ත්තාං ප්‍රාප්‍ය තත්සමීපමාගත්‍ය තච්චරණයෝඃ පතිත්වා ");
INSERT INTO sansin_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ස්වකන්‍යාතෝ භූතං නිරාකර්ත්තාං තස්මින් විනයං කෘතවතී| ");
INSERT INTO sansin_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","කින්තු යීශුස්තාමවදත් ප්‍රථමං බාලකාස්තෘප්‍යන්තු යතෝ බාලකානාං ඛාද්‍යං ගෘහීත්වා කුක්කුරේභ්‍යෝ නික්‍ෂේපෝ(අ)නුචිතඃ| ");
INSERT INTO sansin_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","තදා සා ස්ත්‍රී තමවාදීත් භෝඃ ප්‍රභෝ තත් සත්‍යං තථාපි මඤ්චාධඃස්ථාඃ කුක්කුරා බාලානාං කරපතිතානි ඛාද්‍යඛණ්ඩානි ඛාදන්ති| ");
INSERT INTO sansin_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","තතඃ සෝ(අ)කථයද් ඒතත්කථාහේතෝඃ සකුශලා යාහි තව කන්‍යාං ත්‍යක්ත්වා භූතෝ ගතඃ| ");
INSERT INTO sansin_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","අථ සා ස්ත්‍රී ගෘහං ගත්වා කන්‍යාං භූතත්‍යක්තාං ශය්‍යාස්ථිතාං දදර්ශ| ");
INSERT INTO sansin_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","පුනශ්ච ස සෝරසීදෝන්පුරප්‍රදේශාත් ප්‍රස්ථාය දිකාපලිදේශස්‍ය ප්‍රාන්තරභාගේන ගාලීල්ජලධේඃ සමීපං ගතවාන්| ");
INSERT INTO sansin_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","තදා ලෝකෛරේකං බධිරං කද්වදඤ්ච නරං තන්නිකටමානීය තස්‍ය ගාත්‍රේ හස්තමර්පයිතුං විනයඃ කෘතඃ| ");
INSERT INTO sansin_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","තතෝ යීශු ර්ලෝකාරණ්‍යාත් තං නිර්ජනමානීය තස්‍ය කර්ණයෝඞ්ගුලී ර්දදෞ නිෂ්ඨීවං දත්ත්වා ච තජ්ජිහ්වාං පස්පර්ශ| ");
INSERT INTO sansin_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","අනන්තරං ස්වර්ගං නිරීක්‍ෂ්‍ය දීර්ඝං නිශ්වස්‍ය තමවදත් ඉතඵතඃ අර්ථාන් මුක්තෝ භූයාත්| ");
INSERT INTO sansin_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","තතස්තත්ක්‍ෂණං තස්‍ය කර්ණෞ මුක්තෞ ජිහ්වායාශ්ච ජාඩ්‍යාපගමාත් ස සුස්පෂ්ටවාක්‍යමකථයත්| ");
INSERT INTO sansin_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","අථ ස තාන් වාඪමිත්‍යාදිදේශ යූයමිමාං කථාං කස්මෛචිදපි මා කථයත, කින්තු ස යති න්‍යෂේධත් තේ තති බාහුල්‍යේන ප්‍රාචාරයන්; ");
INSERT INTO sansin_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","තේ(අ)තිචමත්කෘත්‍ය පරස්පරං කථයාමාසුඃ ස බධිරාය ශ්‍රවණශක්තිං මූකාය ච කථනශක්තිං දත්ත්වා සර්ව්වං කර්ම්මෝත්තමරූපේණ චකාර| ");
INSERT INTO sansin_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","තදා තත්සමීපං බහවෝ ලෝකා ආයාතා අතස්තේෂාං භෝජ්‍යද්‍රව්‍යාභාවාද් යීශුඃ ශිෂ්‍යානාහූය ජගාද,| ");
INSERT INTO sansin_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","ලෝකනිවහේ මම කෘපා ජායතේ තේ දිනත්‍රයං මයා සාර්ද්ධං සන්ති තේෂාං භෝජ්‍යං කිමපි නාස්ති| ");
INSERT INTO sansin_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","තේෂාං මධ්‍යේ(අ)නේකේ දූරාද් ආගතාඃ, අභුක්තේෂු තේෂු මයා ස්වගෘහමභිප්‍රහිතේෂු තේ පථි ක්ලමිෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ශිෂ්‍යා අවාදිෂුඃ, ඒතාවතෝ ලෝකාන් තර්පයිතුම් අත්‍ර ප්‍රන්තරේ පූපාන් ප්‍රාප්තුං කේන ශක්‍යතේ? ");
INSERT INTO sansin_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","තතඃ ස තාන් පප්‍රච්ඡ යුෂ්මාකං කති පූපාඃ සන්ති? තේ(අ)කථයන් සප්ත| ");
INSERT INTO sansin_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","තතඃ ස තාල්ලෝකාන් භුවි සමුපවේෂ්ටුම් ආදිශ්‍ය තාන් සප්ත පූපාන් ධෘත්වා ඊශ්වරගුණාන් අනුකීර්ත්තයාමාස, භංක්ත්වා පරිවේෂයිතුං ශිෂ්‍යාන් ප්‍රති දදෞ, තතස්තේ ලෝකේභ්‍යඃ පරිවේෂයාමාසුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","තථා තේෂාං සමීපේ යේ ක්‍ෂුද්‍රමත්ස්‍යා ආසන් තානප්‍යාදාය ඊශ්වරගුණාන් සංකීර්ත්‍ය පරිවේෂයිතුම් ආදිෂ්ටවාන්| ");
INSERT INTO sansin_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","තතෝ ලෝකා භුක්ත්වා තෘප්තිං ගතා අවශිෂ්ටඛාද්‍යෛඃ පූර්ණාඃ සප්තඩල්ලකා ගෘහීතාශ්ච| ");
INSERT INTO sansin_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ඒතේ භෝක්තාරඃ ප්‍රායශ්චතුඃ සහස්‍රපුරුෂා ආසන් තතඃ ස තාන් විසසර්ජ| ");
INSERT INTO sansin_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","අථ ස ශිෂ්‍යඃ සහ නාවමාරුහ්‍ය දල්මානූථාසීමාමාගතඃ| ");
INSERT INTO sansin_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","තතඃ පරං ඵිරූශින ආගත්‍ය තේන සහ විවදමානාස්තස්‍ය පරීක්‍ෂාර්ථම් ආකාශීයචිහ්නං ද්‍රෂ්ටුං යාචිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","තදා සෝ(අ)න්තර්දීර්ඝං නිශ්වස්‍යාකථයත්, ඒතේ විද්‍යමානනරාඃ කුතශ්චින්හං මෘගයන්තේ? යුෂ්මානහං යථාර්ථං බ්‍රවීමි ලෝකානේතාන් කිමපි චිහ්නං න දර්ශයිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","අථ තාන් හිත්වා පුන ර්නාවම් ආරුහ්‍ය පාරමගාත්| ");
INSERT INTO sansin_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ඒතර්හි ශිෂ්‍යෛඃ පූපේෂු විස්මෘතේෂු නාවි තේෂාං සන්නිධෞ පූප ඒකඒව ස්ථිතඃ| ");
INSERT INTO sansin_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","තදානීං යීශුස්තාන් ආදිෂ්ටවාන් ඵිරූශිනාං හේරෝදශ්ච කිණ්වං ප්‍රති සතර්කාඃ සාවධානාශ්ච භවත| ");
INSERT INTO sansin_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","තතස්තේ(අ)න්‍යෝන්‍යං විවේචනං කර්තුම් ආරේභිරේ, අස්මාකං සන්නිධෞ පූපෝ නාස්තීති හේතෝරිදං කථයති| ");
INSERT INTO sansin_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","තද් බුද්ව්වා යීශුස්තේභ්‍යෝ(අ)කථයත් යුෂ්මාකං ස්ථානේ පූපාභාවාත් කුත ඉත්ථං විතර්කයථ? යූයං කිමද්‍යාපි කිමපි න ජානීථ? බෝද්ධුඤ්ච න ශක්නුථ? යාවදද්‍ය කිං යුෂ්මාකං මනාංසි කඨිනානි සන්ති? ");
INSERT INTO sansin_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","සත්සු නේත්‍රේෂු කිං න පශ්‍යථ? සත්සු කර්ණේෂු කිං න ශෘණුථ? න ස්මරථ ච? ");
INSERT INTO sansin_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","යදාහං පඤ්චපූපාන් පඤ්චසහස්‍රාණාං පුරුෂාණාං මධ්‍යේ භංක්ත්වා දත්තවාන් තදානීං යූයම් අවශිෂ්ටපූපෛඃ පූර්ණාන් කති ඩල්ලකාන් ගෘහීතවන්තඃ? තේ(අ)කථයන් ද්වාදශඩල්ලකාන්| ");
INSERT INTO sansin_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","අපරඤ්ච යදා චතුඃසහස්‍රාණාං පුරුෂාණාං මධ්‍යේ පූපාන් භංක්ත්වාදදාං තදා යූයම් අතිරික්තපූපානාං කති ඩල්ලකාන් ගෘහීතවන්තඃ? තේ කථයාමාසුඃ සප්තඩල්ලකාන්| ");
INSERT INTO sansin_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","තදා ස කථිතවාන් තර්හි යූයම් අධුනාපි කුතෝ බෝද්ව්වුං න ශක්නුථ? ");
INSERT INTO sansin_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","අනන්තරං තස්මින් බෛත්සෛදානගරේ ප්‍රාප්තේ ලෝකා අන්ධමේකං නරං තත්සමීපමානීය තං ස්ප්‍රෂ්ටුං තං ප්‍රාර්ථයාඤ්චක්‍රිරේ| ");
INSERT INTO sansin_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","තදා තස්‍යාන්ධස්‍ය කරෞ ගෘහීත්වා නගරාද් බහිර්දේශං තං නීතවාන්; තන්නේත්‍රේ නිෂ්ඨීවං දත්ත්වා තද්ගාත්‍රේ හස්තාවර්පයිත්වා තං පප්‍රච්ඡ, කිමපි පශ්‍යසි? ");
INSERT INTO sansin_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ස නේත්‍රේ උන්මීල්‍ය ජගාද, වෘක්‍ෂවත් මනුජාන් ගච්ඡතෝ නිරීක්‍ෂේ| ");
INSERT INTO sansin_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","තතෝ යීශුඃ පුනස්තස්‍ය නයනයෝ ර්හස්තාවර්පයිත්වා තස්‍ය නේත්‍රේ උන්මීලයාමාස; තස්මාත් ස ස්වස්ථෝ භූත්වා ස්පෂ්ටරූපං සර්ව්වලෝකාන් දදර්ශ| ");
INSERT INTO sansin_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","තතඃ පරං ත්වං ග්‍රාමං මා ගච්ඡ ග්‍රාමස්ථං කමපි ච කිමප්‍යනුක්ත්වා නිජගෘහං යාහීත්‍යාදිශ්‍ය යීශුස්තං නිජගෘහං ප්‍රහිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","අනන්තරං ශිෂ්‍යෛඃ සහිතෝ යීශුඃ කෛසරීයාඵිලිපිපුරං ජගාම, පථි ගච්ඡන් තානපෘච්ඡත් කෝ(අ)හම් අත්‍ර ලෝකාඃ කිං වදන්ති? ");
INSERT INTO sansin_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","තේ ප්‍රත්‍යූචුඃ ත්වාං යෝහනං මජ්ජකං වදන්ති කින්තු කේපි කේපි ඒලියං වදන්ති; අපරේ කේපි කේපි භවිෂ්‍යද්වාදිනාම් ඒකෝ ජන ඉති වදන්ති| ");
INSERT INTO sansin_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","අථ ස තානපෘච්ඡත් කින්තු කෝහම්? ඉත්‍යත්‍ර යූයං කිං වදථ? තදා පිතරඃ ප්‍රත්‍යවදත් භවාන් අභිෂික්තස්ත්‍රාතා| ");
INSERT INTO sansin_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","තතඃ ස තාන් ගාඪමාදිශද් යූයං මම කථා කස්මෛචිදපි මා කථයත| ");
INSERT INTO sansin_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","මනුෂ්‍යපුත්‍රේණාවශ්‍යං බහවෝ යාතනා භෝක්තව්‍යාඃ ප්‍රාචීනලෝකෛඃ ප්‍රධානයාජකෛරධ්‍යාපකෛශ්ච ස නින්දිතඃ සන් ඝාතයිෂ්‍යතේ තෘතීයදිනේ උත්ථාස්‍යති ච, යීශුඃ ශිෂ්‍යානුපදේෂ්ටුමාරභ්‍ය කථාමිමාං ස්පෂ්ටමාචෂ්ට| ");
INSERT INTO sansin_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","තස්මාත් පිතරස්තස්‍ය හස්තෞ ධෘත්වා තං තර්ජ්ජිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","කින්තු ස මුඛං පරාවර්ත්‍ය ශිෂ්‍යගණං නිරීක්‍ෂ්‍ය පිතරං තර්ජයිත්වාවාදීද් දූරීභව විඝ්නකාරින් ඊශ්වරීයකාර‍්‍ය්‍යාදපි මනුෂ්‍යකාර‍්‍ය්‍යං තුභ්‍යං රෝචතතරාං| ");
INSERT INTO sansin_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","අථ ස ලෝකාන් ශිෂ්‍යාංශ්චාහූය ජගාද යඃ කශ්චින් මාමනුගන්තුම් ඉච්ඡති ස ආත්මානං දාම්‍යතු, ස්වක්‍රුශං ගෘහීත්වා මත්පශ්චාද් ආයාතු| ");
INSERT INTO sansin_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","යතෝ යඃ කශ්චිත් ස්වප්‍රාණං රක්‍ෂිතුමිච්ඡති ස තං හාරයිෂ්‍යති, කින්තු යඃ කශ්චින් මදර්ථං සුසංවාදාර්ථඤ්ච ප්‍රාණං හාරයති ස තං රක්‍ෂිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","අපරඤ්ච මනුජඃ සර්ව්වං ජගත් ප්‍රාප්‍ය යදි ස්වප්‍රාණං හාරයති තර්හි තස්‍ය කෝ ලාභඃ? ");
INSERT INTO sansin_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","නරඃ ස්වප්‍රාණවිනිමයේන කිං දාතුං ශක්නෝති? ");
INSERT INTO sansin_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ඒතේෂාං ව්‍යභිචාරිණාං පාපිනාඤ්ච ලෝකානාං සාක්‍ෂාද් යදි කෝපි මාං මත්කථාඤ්ච ලජ්ජාස්පදං ජානාති තර්හි මනුජපුත්‍රෝ යදා ධර්ම්මදූතෛඃ සහ පිතුඃ ප්‍රභාවේණාගමිෂ්‍යති තදා සෝපි තං ලජ්ජාස්පදං ඥාස්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","අථ ස තානවාදීත් යුෂ්මභ්‍යමහං යථාර්ථං කථයාමි, ඊශ්වරරාජ්‍යං පරාක්‍රමේණෝපස්ථිතං න දෘෂ්ට්වා මෘත්‍යුං නාස්වාදිෂ්‍යන්තේ, අත්‍ර දණ්ඩායමානානාං මධ්‍යේපි තාදෘශා ලෝකාඃ සන්ති| ");
INSERT INTO sansin_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","අථ ෂඩ්දිනේභ්‍යඃ පරං යීශුඃ පිතරං යාකූබං යෝහනඤ්ච ගෘහීත්වා ගිරේරුච්චස්‍ය නිර්ජනස්ථානං ගත්වා තේෂාං ප්‍රත්‍යක්‍ෂේ මූර්ත්‍යන්තරං දධාර| ");
INSERT INTO sansin_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","තතස්තස්‍ය පරිධේයම් ඊදෘශම් උජ්ජ්වලහිමපාණඩරං ජාතං යද් ජගති කෝපි රජකෝ න තාදෘක් පාණඩරං කර්ත්තාං ශක්නෝති| ");
INSERT INTO sansin_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","අපරඤ්ච ඒලියෝ මූසාශ්ච තේභ්‍යෝ දර්ශනං දත්ත්වා යීශුනා සහ කථනං කර්ත්තුමාරේභාතේ| ");
INSERT INTO sansin_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","තදා පිතරෝ යීශුමවාදීත් හේ ගුරෝ(අ)ස්මාකමත්‍ර ස්ථිතිරුත්තමා, තතඒව වයං ත්වත්කෘතේ ඒකාං මූසාකෘතේ ඒකාම් ඒලියකෘතේ චෛකාං, ඒතාස්තිස්‍රඃ කුටී ර්නිර්ම්මාම| ");
INSERT INTO sansin_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","කින්තු ස යදුක්තවාන් තත් ස්වයං න බුබුධේ තතඃ සර්ව්වේ බිභයාඤ්චක්‍රුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ඒතර්හි පයෝදස්තාන් ඡාදයාමාස, මමයාං ප්‍රියඃ පුත්‍රඃ කථාසු තස්‍ය මනාංසි නිවේශයතේති නභෝවාණී තන්මේද්‍යාන්නිර‍්‍යයෞ| ");
INSERT INTO sansin_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","අථ හඨාත්තේ චතුර්දිශෝ දෘෂ්ට්වා යීශුං විනා ස්වෛඃ සහිතං කමපි න දදෘශුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","තතඃ පරං ගිරේරවරෝහණකාලේ ස තාන් ගාඪම් දූත්‍යාදිදේශ යාවන්නරසූනෝඃ ශ්මශානාදුත්ථානං න භවති, තාවත් දර්ශනස්‍යාස්‍ය වාර්ත්තා යුෂ්මාභිඃ කස්මෛචිදපි න වක්තව්‍යා| ");
INSERT INTO sansin_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","තදා ශ්මශානාදුත්ථානස්‍ය කෝභිප්‍රාය ඉති විචාර‍්‍ය්‍ය තේ තද්වාක්‍යං ස්වේෂු ගෝපායාඤ්චක්‍රිරේ| ");
INSERT INTO sansin_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","අථ තේ යීශුං පප්‍රච්ඡුඃ ප්‍රථමත ඒලියේනාගන්තව්‍යම් ඉති වාක්‍යං කුත උපාධ්‍යායා ආහුඃ? ");
INSERT INTO sansin_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","තදා ස ප්‍රත්‍යුවාච , ඒලියඃ ප්‍රථමමේත්‍ය සර්ව්වකාර‍්‍ය්‍යාණි සාධයිෂ්‍යති; නරපුත්‍රේ ච ලිපි ර‍්‍යථාස්තේ තථෛව සෝපි බහුදුඃඛං ප්‍රාප්‍යාවඥාස්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","කින්ත්වහං යුෂ්මාන් වදාමි , ඒලියාර්ථේ ලිපි ර‍්‍යථාස්තේ තථෛව ස ඒත්‍ය යයෞ, ලෝකා: ස්වේච්ඡානුරූපං තමභිව්‍යවහරන්ති ස්ම| ");
INSERT INTO sansin_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","අනන්තරං ස ශිෂ්‍යසමීපමේත්‍ය තේෂාං චතුඃපාර්ශ්වේ තෛඃ සහ බහුජනාන් විවදමානාන් අධ්‍යාපකාංශ්ච දෘෂ්ටවාන්; ");
INSERT INTO sansin_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","කින්තු සර්ව්වලෝකාස්තං දෘෂ්ට්වෛව චමත්කෘත්‍ය තදාසන්නං ධාවන්තස්තං ප්‍රණේමුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","තදා යීශුරධ්‍යාපකානප්‍රාක්‍ෂීද් ඒතෛඃ සහ යූයං කිං විවදධ්වේ? ");
INSERT INTO sansin_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","තතෝ ලෝකානාං කශ්චිදේකඃ ප්‍රත්‍යවාදීත් හේ ගුරෝ මම සූනුං මූකං භූතධෘතඤ්ච භවදාසන්නම් ආනයං| ");
INSERT INTO sansin_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","යදාසෞ භූතස්තමාක්‍රමතේ තදෛව පාතසති තථා ස ඵේණායතේ, දන්තෛර්දන්තාන් ඝර්ෂති ක්‍ෂීණෝ භවති ච; තතෝ හේතෝස්තං භූතං ත්‍යාජයිතුං භවච්ඡිෂ්‍යාන් නිවේදිතවාන් කින්තු තේ න ශේකුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","තදා ස තමවාදීත්, රේ අවිශ්වාසිනඃ සන්තානා යුෂ්මාභිඃ සහ කති කාලානහං ස්ථාස්‍යාමි? අපරාන් කති කාලාන් වා ව ආචාරාන් සහිෂ්‍යේ? තං මදාසන්නමානයත| ");
INSERT INTO sansin_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","තතස්තත්සන්නිධිං ස ආනීයත කින්තු තං දෘෂ්ට්වෛව භූතෝ බාලකං ධෘතවාන්; ස ච භූමෞ පතිත්වා ඵේණායමානෝ ලුලෝඨ| ");
INSERT INTO sansin_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","තදා ස තත්පිතරං පප්‍රච්ඡ, අස්‍යේදෘශී දශා කති දිනානි භූතා? තතඃ සෝවාදීත් බාල්‍යකාලාත්| ");
INSERT INTO sansin_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","භූතෝයං තං නාශයිතුං බහුවාරාන් වහ්නෞ ජලේ ච න්‍යක්‍ෂිපත් කින්තු යදි භවාන කිමපි කර්ත්තාං ශක්නෝති තර්හි දයාං කෘත්වාස්මාන් උපකරෝතු| ");
INSERT INTO sansin_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","තදා යීශුස්තමවදත් යදි ප්‍රත්‍යේතුං ශක්නෝෂි තර්හි ප්‍රත්‍යයිනේ ජනාය සර්ව්වං සාධ්‍යම්| ");
INSERT INTO sansin_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","තතස්තත්ක්‍ෂණං තද්බාලකස්‍ය පිතා ප්‍රෝච්චෛ රූවන් සාශ්‍රුනේත්‍රඃ ප්‍රෝවාච, ප්‍රභෝ ප්‍රත්‍යේමි මමාප්‍රත්‍යයං ප්‍රතිකුරු| ");
INSERT INTO sansin_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","අථ යීශු ර්ලෝකසඞ්ඝං ධාවිත්වායාන්තං දෘෂ්ට්වා තමපූතභූතං තර්ජයිත්වා ජගාද, රේ බධිර මූක භූත ත්වමේතස්මාද් බහිර්භව පුනඃ කදාපි මාශ්‍රයෛනං ත්වාමහම් ඉත්‍යාදිශාමි| ");
INSERT INTO sansin_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","තදා ස භූතශ්චීත්ශබ්දං කෘත්වා තමාපීඩ්‍ය බහිර්ජජාම, තතෝ බාලකෝ මෘතකල්පෝ බභූව තස්මාදයං මෘතඉත්‍යනේකේ කථයාමාසුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","කින්තු කරං ධෘත්වා යීශුනෝත්ථාපිතඃ ස උත්තස්ථෞ| ");
INSERT INTO sansin_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","අථ යීශෞ ගෘහං ප්‍රවිෂ්ටේ ශිෂ්‍යා ගුප්තං තං පප්‍රච්ඡුඃ, වයමේනං භූතං ත්‍යාජයිතුං කුතෝ න ශක්තාඃ? ");
INSERT INTO sansin_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ස උවාච, ප්‍රාර්ථනෝපවාසෞ විනා කේනාප්‍යන්‍යේන කර්ම්මණා භූතමීදෘශං ත්‍යාජයිතුං න ශක්‍යං| ");
INSERT INTO sansin_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","අනන්තරං ස තත්ස්ථානාදිත්වා ගාලීල්මධ්‍යේන යයෞ, කින්තු තත් කෝපි ජානීයාදිති ස නෛච්ඡත්| ");
INSERT INTO sansin_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","අපරඤ්ච ස ශිෂ්‍යානුපදිශන් බභාෂේ, නරපුත්‍රෝ නරහස්තේෂු සමර්පයිෂ්‍යතේ තේ ච තං හනිෂ්‍යන්ති තෛස්තස්මින් හතේ තෘතීයදිනේ ස උත්ථාස්‍යතීති| ");
INSERT INTO sansin_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","කින්තු තත්කථාං තේ නාබුධ්‍යන්ත ප්‍රෂ්ටුඤ්ච බිභ්‍යඃ| ");
INSERT INTO sansin_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","අථ යීශුඃ කඵර්නාහූම්පුරමාගත්‍ය මධ්‍යේගෘහඤ්චේත්‍ය තානපෘච්ඡද් වර්ත්මමධ්‍යේ යූයමන්‍යෝන්‍යං කිං විවදධ්වේ ස්ම? ");
INSERT INTO sansin_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","කින්තු තේ නිරුත්තරාස්තස්ථු ර‍්‍යස්මාත්තේෂාං කෝ මුඛ්‍ය ඉති වර්ත්මානි තේ(අ)න්‍යෝන්‍යං ව්‍යවදන්ත| ");
INSERT INTO sansin_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","තතඃ ස උපවිශ්‍ය ද්වාදශශිෂ්‍යාන් ආහූය බභාෂේ යඃ කශ්චිත් මුඛ්‍යෝ භවිතුමිච්ඡති ස සර්ව්වේභ්‍යෝ ගෞණඃ සර්ව්වේෂාං සේවකශ්ච භවතු| ");
INSERT INTO sansin_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","තදා ස බාලකමේකං ගෘහීත්වා මධ්‍යේ සමුපාවේශයත් තතස්තං ක්‍රෝඩේ කෘත්වා තානවාදාත් ");
INSERT INTO sansin_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","යඃ කශ්චිදීදෘශස්‍ය කස්‍යාපි බාලස්‍යාතිථ්‍යං කරෝති ස මමාතිථ්‍යං කරෝති; යඃ කශ්චින්මමාතිථ්‍යං කරෝති ස කේවලම් මමාතිථ්‍යං කරෝති තන්න මත්ප්‍රේරකස්‍යාප්‍යාතිථ්‍යං කරෝති| ");
INSERT INTO sansin_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","අථ යෝහන් තමබ්‍රවීත් හේ ගුරෝ, අස්මාකමනනුගාමිනම් ඒකං ත්වාන්නාම්නා භූතාන් ත්‍යාජයන්තං වයං දෘෂ්ටවන්තඃ, අස්මාකමපශ්චාද්ගාමිත්වාච්ච තං න්‍යෂේධාම| ");
INSERT INTO sansin_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","කින්තු යීශුරවදත් තං මා නිෂේධත්, යතෝ යඃ කශ්චින් මන්නාම්නා චිත්‍රං කර්ම්ම කරෝති ස සහසා මාං නින්දිතුං න ශක්නෝති| ");
INSERT INTO sansin_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","තථා යඃ කශ්චිද් යුෂ්මාකං විපක්‍ෂතාං න කරෝති ස යුෂ්මාකමේව සපක්‍ෂඃ| ");
INSERT INTO sansin_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","යඃ කශ්චිද් යුෂ්මාන් ඛ්‍රීෂ්ටශිෂ්‍යාන් ඥාත්වා මන්නාම්නා කංසෛකේන පානීයං පාතුං දදාති, යුෂ්මානහං යථාර්ථං වච්මි, ස ඵලේන වඤ්චිතෝ න භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","කින්තු යදි කශ්චින් මයි විශ්වාසිනාමේෂාං ක්‍ෂුද්‍රප්‍රාණිනාම් ඒකස්‍යාපි විඝ්නං ජනයති, තර්හි තස්‍යෛතත්කර්ම්ම කරණාත් කණ්ඨබද්ධපේෂණීකස්‍ය තස්‍ය සාගරාගාධජල මජ්ජනං භද්‍රං| ");
INSERT INTO sansin_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","අතඃ ස්වකරෝ යදි ත්වාං බාධතේ තර්හි තං ඡින්ධි; ");
INSERT INTO sansin_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","යස්මාත් යත්‍ර කීටා න ම්‍රියන්තේ වහ්නිශ්ච න නිර්ව්වාති, තස්මින් අනිර්ව්වාණානලනරකේ කරද්වයවස්තව ගමනාත් කරහීනස්‍ය ස්වර්ගප්‍රවේශස්තව ක්‍ෂේමං| ");
INSERT INTO sansin_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","යදි තව පාදෝ විඝ්නං ජනයති තර්හි තං ඡින්ධි, ");
INSERT INTO sansin_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","යතෝ යත්‍ර කීටා න ම්‍රියන්තේ වහ්නිශ්ච න නිර්ව්වාති, තස්මින් (අ)නිර්ව්වාණවහ්නෞ නරකේ ද්විපාදවතස්තව නික්‍ෂේපාත් පාදහීනස්‍ය ස්වර්ගප්‍රවේශස්තව ක්‍ෂේමං| ");
INSERT INTO sansin_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","ස්වනේත්‍රං යදි ත්වාං බාධතේ තර්හි තදප්‍යුත්පාටය, යතෝ යත්‍ර කීටා න ම්‍රියන්තේ වහ්නිශ්ච න නිර්ව්වාති, ");
INSERT INTO sansin_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","තස්මින (අ)නිර්ව්වාණවහ්නෞ නරකේ ද්විනේත්‍රස්‍ය තව නික්‍ෂේපාද් ඒකනේත්‍රවත ඊශ්වරරාජ්‍යේ ප්‍රවේශස්තව ක්‍ෂේමං| ");
INSERT INTO sansin_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","යථා සර්ව්වෝ බලි ර්ලවණාක්තඃ ක්‍රියතේ තථා සර්ව්වෝ ජනෝ වහ්නිරූපේණ ලවණාක්තඃ කාරිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","ලවණං භද්‍රං කින්තු යදි ලවණේ ස්වාදුතා න තිෂ්ඨති, තර්හි කථම් ආස්වාද්‍යුක්තං කරිෂ්‍යථ? යූයං ලවණයුක්තා භවත පරස්පරං ප්‍රේම කුරුත| ");
INSERT INTO sansin_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","අනන්තරං ස තත්ස්ථානාත් ප්‍රස්ථාය යර්ද්දනනද්‍යාඃ පාරේ යිහූදාප්‍රදේශ උපස්ථිතවාන්, තත්‍ර තදන්තිකේ ලෝකානාං සමාගමේ ජාතේ ස නිජරීත්‍යනුසාරේණ පුනස්තාන් උපදිදේශ| ");
INSERT INTO sansin_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","තදා ඵිරූශිනස්තත්සමීපම් ඒත්‍ය තං පරීක්‍ෂිතුං පප්‍රච්ඡඃ ස්වජායා මනුජානාං ත්‍යජ්‍යා න වේති? ");
INSERT INTO sansin_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","තතඃ ස ප්‍රත්‍යවාදීත්, අත්‍ර කාර‍්‍ය්‍යේ මූසා යුෂ්මාන් ප්‍රති කිමාඥාපයත්? ");
INSERT INTO sansin_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ත ඌචුඃ ත්‍යාගපත්‍රං ලේඛිතුං ස්වපත්නීං ත්‍යක්තුඤ්ච මූසා(අ)නුමන්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","තදා යීශුඃ ප්‍රත්‍යුවාච, යුෂ්මාකං මනසාං කාඨින්‍යාද්ධේතෝ ර්මූසා නිදේශමිමම් අලිඛත්| ");
INSERT INTO sansin_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","කින්තු සෘෂ්ටේරාදෞ ඊශ්වරෝ නරාන් පුංරූපේණ ස්ත්‍රීරූපේණ ච සසර්ජ| ");
INSERT INTO sansin_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","\"තතඃ කාරණාත් පුමාන් පිතරං මාතරඤ්ච ත්‍යක්ත්වා ස්වජායායාම් ආසක්තෝ භවිෂ්‍යති, ");
INSERT INTO sansin_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","තෞ ද්වාව් ඒකාඞ්ගෞ භවිෂ්‍යතඃ| \" තස්මාත් තත්කාලමාරභ්‍ය තෞ න ද්වාව් ඒකාඞ්ගෞ| ");
INSERT INTO sansin_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","අතඃ කාරණාද් ඊශ්වරෝ යදයෝජයත් කෝපි නරස්තන්න වියේජයේත්| ");
INSERT INTO sansin_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","අථ යීශු ර්ගෘහං ප්‍රවිෂ්ටස්තදා ශිෂ්‍යාඃ පුනස්තත්කථාං තං පප්‍රච්ඡුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","තතඃ සෝවදත් කශ්චිද් යදි ස්වභාර‍්‍ය්‍යාං ත්‍යක්තවාන්‍යාම් උද්වහති තර්හි ස ස්වභාර‍්‍ය්‍යායාඃ ප්‍රාතිකූල්‍යේන ව්‍යභිචාරී භවති| ");
INSERT INTO sansin_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","කාචින්නාරී යදි ස්වපතිං හිත්වාන්‍යපුංසා විවාහිතා භවති තර්හි සාපි ව්‍යභිචාරිණී භවති| ");
INSERT INTO sansin_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","අථ ස යථා ශිශූන් ස්පෘශේත්, තදර්ථං ලෝකෛස්තදන්තිකං ශිශව ආනීයන්ත, කින්තු ශිෂ්‍යාස්තානානීතවතස්තර්ජයාමාසුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","යීශුස්තද් දෘෂ්ට්වා ක්‍රුධ්‍යන් ජගාද, මන්නිකටම් ආගන්තුං ශිශූන් මා වාරයත, යත ඒතාදෘශා ඊශ්වරරාජ්‍යාධිකාරිණඃ| ");
INSERT INTO sansin_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","යුෂ්මානහං යථාර්ථං වච්මි, යඃ කශ්චිත් ශිශුවද් භූත්වා රාජ්‍යමීශ්වරස්‍ය න ගෘහ්ලීයාත් ස කදාපි තද්‍රාජ්‍යං ප්‍රවේෂ්ටුං න ශක්නෝති| ");
INSERT INTO sansin_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","අනනතරං ස ශිශූනඞ්කේ නිධාය තේෂාං ගාත්‍රේෂු හස්තෞ දත්ත්වාශිෂං බභාෂේ| ");
INSERT INTO sansin_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","අථ ස වර්ත්මනා යාති, ඒතර්හි ජන ඒකෝ ධාවන් ආගත්‍ය තත්සම්මුඛේ ජානුනී පාතයිත්වා පෘෂ්ටවාන්, භෝඃ පරමගුරෝ, අනන්තායුඃ ප්‍රාප්තයේ මයා කිං කර්ත්තව්‍යං? ");
INSERT INTO sansin_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","තදා යීශුරුවාච, මාං පරමං කුතෝ වදසි? විනේශ්වරං කෝපි පරමෝ න භවති| ");
INSERT INTO sansin_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","පරස්ත්‍රීං නාභිගච්ඡ; නරං මා ඝාතය; ස්තේයං මා කුරු; මෘෂාසාක්‍ෂ්‍යං මා දේහි; හිංසාඤ්ච මා කුරු; පිතරෞ සම්මන්‍යස්ව; නිදේශා ඒතේ ත්වයා ඥාතාඃ| ");
INSERT INTO sansin_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","තතස්තන ප්‍රත්‍යුක්තං, හේ ගුරෝ බාල්‍යකාලාදහං සර්ව්වානේතාන් ආචරාමි| ");
INSERT INTO sansin_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","තදා යීශුස්තං විලෝක්‍ය ස්නේහේන බභාෂේ, තවෛකස්‍යාභාව ආස්තේ; ත්වං ගත්වා සර්ව්වස්වං වික්‍රීය දරිද්‍රේභ්‍යෝ විශ්‍රාණය, තතඃ ස්වර්ගේ ධනං ප්‍රාප්ස්‍යසි; තතඃ පරම් ඒත්‍ය ක්‍රුශං වහන් මදනුවර්ත්තී භව| ");
INSERT INTO sansin_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","කින්තු තස්‍ය බහුසම්පද්විද්‍යමානත්වාත් ස ඉමාං කථාමාකර්ණ්‍ය විෂණෝ දුඃඛිතශ්ච සන් ජගාම| ");
INSERT INTO sansin_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","අථ යීශුශ්චතුර්දිශෝ නිරීක්‍ෂ්‍ය ශිෂ්‍යාන් අවාදීත්, ධනිලෝකානාම් ඊශ්වරරාජ්‍යප්‍රවේශඃ කීදෘග් දුෂ්කරඃ| ");
INSERT INTO sansin_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","තස්‍ය කථාතඃ ශිෂ්‍යාශ්චමච්චක්‍රුඃ, කින්තු ස පුනරවදත්, හේ බාලකා යේ ධනේ විශ්වසන්ති තේෂාම් ඊශ්වරරාජ්‍යප්‍රවේශඃ කීදෘග් දුෂ්කරඃ| ");
INSERT INTO sansin_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ඊශ්වරරාජ්‍යේ ධනිනාං ප්‍රවේශාත් සූචිරන්ධ්‍රේණ මහාඞ්ගස්‍ය ගමනාගමනං සුකරං| ");
INSERT INTO sansin_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","තදා ශිෂ්‍යා අතීව විස්මිතාඃ පරස්පරං ප්‍රෝචුඃ, තර්හි කඃ පරිත්‍රාණං ප්‍රාප්තුං ශක්නෝති? ");
INSERT INTO sansin_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","තතෝ යීශුස්තාන් විලෝක්‍ය බභාෂේ, තන් නරස්‍යාසාධ්‍යං කින්තු නේශ්වරස්‍ය, යතෝ හේතෝරීශ්වරස්‍ය සර්ව්වං සාධ්‍යම්| ");
INSERT INTO sansin_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","තදා පිතර උවාච, පශ්‍ය වයං සර්ව්වං පරිත්‍යජ්‍ය භවතෝනුගාමිනෝ ජාතාඃ| ");
INSERT INTO sansin_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","තතෝ යීශුඃ ප්‍රත්‍යවදත්, යුෂ්මානහං යථාර්ථං වදාමි, මදර්ථං සුසංවාදාර්ථං වා යෝ ජනඃ සදනං භ්‍රාතරං භගිනීං පිතරං මාතරං ජායාං සන්තානාන් භූමි වා ත්‍යක්ත්වා ");
INSERT INTO sansin_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ගෘහභ්‍රාතෘභගිනීපිතෘමාතෘපත්නීසන්තානභූමීනාමිහ ශතගුණාන් ප්‍රේත්‍යානන්තායුශ්ච න ප්‍රාප්නෝති තාදෘශඃ කෝපි නාස්ති| ");
INSERT INTO sansin_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","කින්ත්වග්‍රීයා අනේකේ ලෝකාඃ ශේෂාඃ, ශේෂීයා අනේකේ ලෝකාශ්චාග්‍රා භවිෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","අථ යිරූශාලම්‍යානකාලේ යීශුස්තේෂාම් අග්‍රගාමී බභූව, තස්මාත්තේ චිත්‍රං ඥාත්වා පශ්චාද්ගාමිනෝ භූත්වා බිභ්‍යුඃ| තදා ස පුන ර්ද්වාදශශිෂ්‍යාන් ගෘහීත්වා ස්වීයං යද්‍යද් ඝටිෂ්‍යතේ තත්තත් තේභ්‍යඃ කථයිතුං ප්‍රාරේභේ; ");
INSERT INTO sansin_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","පශ්‍යත වයං යිරූශාලම්පුරං යාමඃ, තත්‍ර මනුෂ්‍යපුත්‍රඃ ප්‍රධානයාජකානාම් උපාධ්‍යායානාඤ්ච කරේෂු සමර්පයිෂ්‍යතේ; තේ ච වධදණ්ඩාඥාං දාපයිත්වා පරදේශීයානාං කරේෂු තං සමර්පයිෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","තේ තමුපහස්‍ය කශයා ප්‍රහෘත්‍ය තද්වපුෂි නිෂ්ඨීවං නික්‍ෂිප්‍ය තං හනිෂ්‍යන්ති, තතඃ ස තෘතීයදිනේ ප්‍රෝත්ථාස්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","තතඃ සිවදේඃ පුත්‍රෞ යාකූබ්‍යෝහනෞ තදන්තිකම් ඒත්‍ය ප්‍රෝචතුඃ, හේ ගුරෝ යද් ආවාභ්‍යාං යාචිෂ්‍යතේ තදස්මදර්ථං භවාන් කරෝතු නිවේදනමිදමාවයෝඃ| ");
INSERT INTO sansin_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","තතඃ ස කථිතවාන්, යුවාං කිමිච්ඡථඃ? කිං මයා යුෂ්මදර්ථං කරණීයං? ");
INSERT INTO sansin_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","තදා තෞ ප්‍රෝචතුඃ, ආවයෝරේකං දක්‍ෂිණපාර්ශ්වේ වාමපාර්ශ්වේ චෛකං තවෛශ්වර‍්‍ය්‍යපදේ සමුපවේෂ්ටුම් ආඥාපය| ");
INSERT INTO sansin_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","කින්තු යීශුඃ ප්‍රත්‍යුවාච යුවාමඥාත්වේදං ප්‍රාර්ථයේථේ, යේන කංසේනාහං පාස්‍යාමි තේන යුවාභ්‍යාං කිං පාතුං ශක්‍ෂ්‍යතේ? යස්මින් මජ්ජනේනාහං මජ්ජිෂ්‍යේ තන්මජ්ජනේ මජ්ජයිතුං කිං යුවාභ්‍යාං ශක්‍ෂ්‍යතේ? තෞ ප්‍රත්‍යූචතුඃ ශක්‍ෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","තදා යීශුරවදත් යේන කංසේනාහං පාස්‍යාමි තේනාවශ්‍යං යුවාමපි පාස්‍යථඃ, යේන මජ්ජනේන චාහං මජ්ජිය්‍යේ තත්‍ර යුවාමපි මජ්ජිෂ්‍යේථේ| ");
INSERT INTO sansin_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","කින්තු යේෂාමර්ථම් ඉදං නිරූපිතං, තාන් විහායාන්‍යං කමපි මම දක්‍ෂිණපාර්ශ්වේ වාමපාර්ශ්වේ වා සමුපවේශයිතුං මමාධිකාරෝ නාස්ති| ");
INSERT INTO sansin_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","අථාන්‍යදශශිෂ්‍යා ඉමාං කථාං ශ්‍රුත්වා යාකූබ්‍යෝහන්භ්‍යාං චුකුපුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","කින්තු යීශුස්තාන් සමාහූය බභාෂේ, අන්‍යදේශීයානාං රාජත්වං යේ කුර්ව්වන්ති තේ තේෂාමේව ප්‍රභුත්වං කුර්ව්වන්ති, තථා යේ මහාලෝකාස්තේ තේෂාම් අධිපතිත්වං කුර්ව්වන්තීති යූයං ජානීථ| ");
INSERT INTO sansin_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","කින්තු යුෂ්මාකං මධ්‍යේ න තථා භවිෂ්‍යති, යුෂ්මාකං මධ්‍යේ යඃ ප්‍රාධාන්‍යං වාඤ්ඡති ස යුෂ්මාකං සේවකෝ භවිෂ්‍යති, ");
INSERT INTO sansin_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","යුෂ්මාකං යෝ මහාන් භවිතුමිච්ඡති ස සර්ව්වේෂාං කිඞ්කරෝ භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","යතෝ මනුෂ්‍යපුත්‍රඃ සේව්‍යෝ භවිතුං නාගතඃ සේවාං කර්ත්තාං තථානේකේෂාං පරිත්‍රාණස්‍ය මූල්‍යරූපස්වප්‍රාණං දාතුඤ්චාගතඃ| ");
INSERT INTO sansin_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","අථ තේ යිරීහෝනගරං ප්‍රාප්තාස්තස්මාත් ශිෂ්‍යෛ ර්ලෝකෛශ්ච සහ යීශෝ ර්ගමනකාලේ ටීමයස්‍ය පුත්‍රෝ බර්ටීමයනාමා අන්ධස්තන්මාර්ගපාර්ශ්වේ භික්‍ෂාර්ථම් උපවිෂ්ටඃ| ");
INSERT INTO sansin_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ස නාසරතීයස්‍ය යීශෝරාගමනවාර්ත්තාං ප්‍රාප්‍ය ප්‍රෝචෛ ර්වක්තුමාරේභේ, හේ යීශෝ දායූදඃ සන්තාන මාං දයස්ව| ");
INSERT INTO sansin_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","තතෝනේකේ ලෝකා මෞනීභවේති තං තර්ජයාමාසුඃ, කින්තු ස පුනරධිකමුච්චෛ ර්ජගාද, හේ යීශෝ දායූදඃ සන්තාන මාං දයස්ව| ");
INSERT INTO sansin_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","තදා යීශුඃ ස්ථිත්වා තමාහ්වාතුං සමාදිදේශ, තතෝ ලෝකාස්තමන්ධමාහූය බභාෂිරේ, හේ නර, ස්ථිරෝ භව, උත්තිෂ්ඨ, ස ත්වාමාහ්වයති| ");
INSERT INTO sansin_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","තදා ස උත්තරීයවස්ත්‍රං නික්‍ෂිප්‍ය ප්‍රෝත්ථාය යීශෝඃ සමීපං ගතඃ| ");
INSERT INTO sansin_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","තතෝ යීශුස්තමවදත් ත්වයා කිං ප්‍රාර්ථ්‍යතේ? තුභ්‍යමහං කිං කරිෂ්‍යාමී? තදා සෝන්ධස්තමුවාච, හේ ගුරෝ මදීයා දෘෂ්ටිර්භවේත්| ");
INSERT INTO sansin_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","තතෝ යීශුස්තමුවාච යාහි තව විශ්වාසස්ත්වාං ස්වස්ථමකාර්ෂීත්, තස්මාත් තත්ක්‍ෂණං ස දෘෂ්ටිං ප්‍රාප්‍ය පථා යීශෝඃ පශ්චාද් යයෞ| ");
INSERT INTO sansin_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","අනන්තරං තේෂු යිරූශාලමඃ සමීපස්ථයෝ ර්බෛත්ඵගීබෛථනීයපුරයෝරන්තිකස්ථං ජෛතුනනාමාද්‍රිමාගතේෂු යීශුඃ ප්‍රේෂණකාලේ ද්වෞ ශිෂ්‍යාවිදං වාක්‍යං ජගාද, ");
INSERT INTO sansin_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","යුවාමමුං සම්මුඛස්ථං ග්‍රාමං යාතං, තත්‍ර ප්‍රවිශ්‍ය යෝ නරං නාවහත් තං ගර්ද්දභශාවකං ද්‍රක්‍ෂ්‍යථස්තං මෝචයිත්වානයතං| ");
INSERT INTO sansin_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","කින්තු යුවාං කර්ම්මේදං කුතඃ කුරුථඃ? කථාමිමාං යදි කෝපි පෘච්ඡති තර්හි ප්‍රභෝරත්‍ර ප්‍රයෝජනමස්තීති කථිතේ ස ශීඝ්‍රං තමත්‍ර ප්‍රේෂයිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","තතස්තෞ ගත්වා ද්විමාර්ගමේලනේ කස්‍යචිද් ද්වාරස්‍ය පාර්ශ්වේ තං ගර්ද්දභශාවකං ප්‍රාප්‍ය මෝචයතඃ, ");
INSERT INTO sansin_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ඒතර්හි තත්‍රෝපස්ථිතලෝකානාං කශ්චිද් අපෘච්ඡත්, ගර්ද්දභශිශුං කුතෝ මෝචයථඃ? ");
INSERT INTO sansin_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","තදා යීශෝරාඥානුසාරේණ තේභ්‍යඃ ප්‍රත්‍යුදිතේ තත්ක්‍ෂණං තමාදාතුං තේ(අ)නුජඥුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","අථ තෞ යීශෝඃ සන්නිධිං ගර්ද්දභශිශුම් ආනීය තදුපරි ස්වවස්ත්‍රාණි පාතයාමාසතුඃ; තතඃ ස තදුපරි සමුපවිෂ්ටඃ| ");
INSERT INTO sansin_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","තදානේකේ පථි ස්වවාසාංසි පාතයාමාසුඃ, පරෛශ්ච තරුශාඛාශ්ඡිතවා මාර්ගේ විකීර්ණාඃ| ");
INSERT INTO sansin_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","අපරඤ්ච පශ්චාද්ගාමිනෝ(අ)ග්‍රගාමිනශ්ච සර්ව්වේ ජනා උචෛඃස්වරේණ වක්තුමාරේභිරේ, ජය ජය යඃ පරමේශ්වරස්‍ය නාම්නාගච්ඡති ස ධන්‍ය ඉති| ");
INSERT INTO sansin_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","තථාස්මාකමං පූර්ව්වපුරුෂස්‍ය දායූදෝ යද්‍රාජ්‍යං පරමේශ්වරනාම්නායාති තදපි ධන්‍යං, සර්ව්වස්මාදුච්ඡ්‍රායේ ස්වර්ගේ ඊශ්වරස්‍ය ජයෝ භවේත්| ");
INSERT INTO sansin_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ඉත්ථං යීශු ර‍්‍යිරූශාලමි මන්දිරං ප්‍රවිශ්‍ය චතුර්දික්ස්ථානි සර්ව්වාණි වස්තූනි දෘෂ්ටවාන්; අථ සායංකාල උපස්ථිතේ ද්වාදශශිෂ්‍යසහිතෝ බෛථනියං ජගාම| ");
INSERT INTO sansin_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","අපරේහනි බෛථනියාද් ආගමනසමයේ ක්‍ෂුධාර්ත්තෝ බභූව| ");
INSERT INTO sansin_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","තතෝ දූරේ සපත්‍රමුඩුම්බරපාදපං විලෝක්‍ය තත්‍ර කිඤ්චිත් ඵලං ප්‍රාප්තුං තස්‍ය සන්නිකෘෂ්ටං යයෞ, තදානීං ඵලපාතනස්‍ය සමයෝ නාගච්ඡති| තතස්තත්‍රෝපස්ථිතඃ පත්‍රාණි විනා කිමප්‍යපරං න ප්‍රාප්‍ය ස කථිතවාන්, ");
INSERT INTO sansin_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","අද්‍යාරභ්‍ය කෝපි මානවස්ත්වත්තඃ ඵලං න භුඤ්ජීත; ඉමාං කථාං තස්‍ය ශිෂ්‍යාඃ ශුශ්‍රුවුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","තදනන්තරං තේෂු යිරූශාලමමායාතේෂු යීශු ර්මන්දිරං ගත්වා තත්‍රස්ථානාං බණිජාං මුද්‍රාසනානි පාරාවතවික්‍රේතෘණාම් ආසනානි ච න්‍යුබ්ජයාඤ්චකාර සර්ව්වාන් ක්‍රේතෘන් වික්‍රේතෘංශ්ච බහිශ්චකාර| ");
INSERT INTO sansin_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","අපරං මන්දිරමධ්‍යේන කිමපි පාත්‍රං වෝඪුං සර්ව්වජනං නිවාරයාමාස| ");
INSERT INTO sansin_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ලෝකානුපදිශන් ජගාද, මම ගෘහං සර්ව්වජාතීයානාං ප්‍රාර්ථනාගෘහම් ඉති නාම්නා ප්‍රථිතං භවිෂ්‍යති ඒතත් කිං ශාස්ත්‍රේ ලිඛිතං නාස්ති? කින්තු යූයං තදේව චෝරාණාං ගහ්වරං කුරුථ| ");
INSERT INTO sansin_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ඉමාං වාණීං ශ්‍රුත්වාධ්‍යාපකාඃ ප්‍රධානයාජකාශ්ච තං යථා නාශයිතුං ශක්නුවන්ති තථෝेපායං මෘගයාමාසුඃ, කින්තු තස්‍යෝපදේශාත් සර්ව්වේ ලෝකා විස්මයං ගතා අතස්තේ තස්මාද් බිභ්‍යුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","අථ සායංසමය උපස්ථිතේ යීශුර්නගරාද් බහිර්වව්‍රාජ| ");
INSERT INTO sansin_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","අනන්තරං ප්‍රාතඃකාලේ තේ තේන මාර්ගේණ ගච්ඡන්තස්තමුඩුම්බරමහීරුහං සමූලං ශුෂ්කං දදෘශුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","තතඃ පිතරඃ පූර්ව්වවාක්‍යං ස්මරන් යීශුං බභාෂං, හේ ගුරෝ පශ්‍යතු ය උඩුම්බරවිටපී භවතා ශප්තඃ ස ශුෂ්කෝ බභූව| ");
INSERT INTO sansin_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","තතෝ යීශුඃ ප්‍රත්‍යවාදීත්, යූයමීශ්වරේ විශ්වසිත| ");
INSERT INTO sansin_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","යුෂ්මානහං යථාර්ථං වදාමි කෝපි යද්‍යේතද්ගිරිං වදති, ත්වමුත්ථාය ගත්වා ජලධෞ පත, ප්‍රෝක්තමිදං වාක්‍යමවශ්‍යං ඝටිෂ්‍යතේ, මනසා කිමපි න සන්දිහ්‍ය චේදිදං විශ්වසේත් තර්හි තස්‍ය වාක්‍යානුසාරේණ තද් ඝටිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","අතෝ හේතෝරහං යුෂ්මාන් වච්මි, ප්‍රාර්ථනාකාලේ යද්‍යදාකාංක්‍ෂිෂ්‍යධ්වේ තත්තදවශ්‍යං ප්‍රාප්ස්‍යථ, ඉත්ථං විශ්වසිත, තතඃ ප්‍රාප්ස්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","අපරඤ්ච යුෂ්මාසු ප්‍රාර්ථයිතුං සමුත්ථිතේෂු යදි කෝපි යුෂ්මාකම් අපරාධී තිෂ්ඨති, තර්හි තං ක්‍ෂමධ්වං, තථා කෘතේ යුෂ්මාකං ස්වර්ගස්ථඃ පිතාපි යුෂ්මාකමාගාංමි ක්‍ෂමිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","කින්තු යදි න ක්‍ෂමධ්වේ තර්හි වඃ ස්වර්ගස්ථඃ පිතාපි යුෂ්මාකමාගාංසි න ක්‍ෂමිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","අනන්තරං තේ පුන ර‍්‍යිරූශාලමං ප්‍රවිවිශුඃ, යීශු ර‍්‍යදා මධ්‍යේමන්දිරම් ඉතස්තතෝ ගච්ඡති, තදානීං ප්‍රධානයාජකා උපාධ්‍යායාඃ ප්‍රාඤ්චශ්ච තදන්තිකමේත්‍ය කථාමිමාං පප්‍රච්ඡුඃ, ");
INSERT INTO sansin_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ත්වං කේනාදේශේන කර්ම්මාණ්‍යේතානි කරෝෂි? තථෛතානි කර්ම්මාණි කර්ත්තාං කේනාදිෂ්ටෝසි? ");
INSERT INTO sansin_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","තතෝ යීශුඃ ප්‍රතිගදිතවාන් අහමපි යුෂ්මාන් ඒකකථාං පෘච්ඡාමි, යදි යූයං තස්‍යා උත්තරං කුරුථ, තර්හි කයාඥයාහං කර්ම්මාණ්‍යේතානි කරෝමි තද් යුෂ්මභ්‍යං කථයිෂ්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","යෝහනෝ මජ්ජනම් ඊශ්වරාත් ජාතං කිං මානවාත්? තන්මහ්‍යං කථයත| ");
INSERT INTO sansin_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","තේ පරස්පරං විවේක්තුං ප්‍රාරේභිරේ, තද් ඊශ්වරාද් බභූවේති චේද් වදාමස්තර්හි කුතස්තං න ප්‍රත්‍යෛත? කථමේතාං කථයිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","මානවාද් අභවදිති චේද් වදාමස්තර්හි ලෝකේභ්‍යෝ භයමස්ති යතෝ හේතෝඃ සර්ව්වේ යෝහනං සත්‍යං භවිෂ්‍යද්වාදිනං මන්‍යන්තේ| ");
INSERT INTO sansin_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","අතඒව තේ යීශුං ප්‍රත්‍යවාදිෂු ර්වයං තද් වක්තුං න ශක්නුමඃ| යීශුරුවාච, තර්හි යේනාදේශේන කර්ම්මාණ්‍යේතානි කරෝමි, අහමපි යුෂ්මභ්‍යං තන්න කථයිෂ්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","අනන්තරං යීශු ර්දෘෂ්ටාන්තේන තේභ්‍යඃ කථයිතුමාරේභේ, කශ්චිදේකෝ ද්‍රාක්‍ෂාක්‍ෂේත්‍රං විධාය තච්චතුර්දික්‍ෂු වාරණීං කෘත්වා තන්මධ්‍යේ ද්‍රාක්‍ෂාපේෂණකුණ්ඩම් අඛනත්, තථා තස්‍ය ගඩමපි නිර්ම්මිතවාන් තතස්තත්ක්‍ෂේත්‍රං කෘෂීවලේෂු සමර්ප්‍ය දූරදේශං ජගාම| ");
INSERT INTO sansin_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","තදනන්තරං ඵලකාලේ කෘෂීවලේභ්‍යෝ ද්‍රාක්‍ෂාක්‍ෂේත්‍රඵලානි ප්‍රාප්තුං තේෂාං සවිධේ භෘත්‍යම් ඒකං ප්‍රාහිණෝත්| ");
INSERT INTO sansin_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","කින්තු කෘෂීවලාස්තං ධෘත්වා ප්‍රහෘත්‍ය රික්තහස්තං විසසෘජුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","තතඃ ස පුනරන්‍යමේකං භෘත්‍යං ප්‍රෂයාමාස, කින්තු තේ කෘෂීවලාඃ පාෂාණාඝාතෛස්තස්‍ය ශිරෝ භඞ්ක්ත්වා සාපමානං තං ව්‍යසර්ජන්| ");
INSERT INTO sansin_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","තතඃ පරං සෝපරං දාසං ප්‍රාහිණෝත් තදා තේ තං ජඝ්නුඃ, ඒවම් අනේකේෂාං කස්‍යචිත් ප්‍රහාරඃ කස්‍යචිද් වධශ්ච තෛඃ කෘතඃ| ");
INSERT INTO sansin_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","තතඃ පරං මයා ස්වපුත්‍රේ ප්‍රහිතේ තේ තමවශ්‍යං සම්මංස්‍යන්තේ, ඉත්‍යුක්ත්වාවශේෂේ තේෂාං සන්නිධෞ නිජප්‍රියම් අද්විතීයං පුත්‍රං ප්‍රේෂයාමාස| ");
INSERT INTO sansin_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","කින්තු කෘෂීවලාඃ පරස්පරං ජගදුඃ, ඒෂ උත්තරාධිකාරී, ආගච්ඡත වයමේනං හන්මස්තථා කෘතේ (අ)ධිකාරෝයම් අස්මාකං භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","තතස්තං ධෘත්වා හත්වා ද්‍රාක්‍ෂාක්‍ෂේත්‍රාද් බහිඃ ප්‍රාක්‍ෂිපන්| ");
INSERT INTO sansin_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","අනේනාසෞ ද්‍රාක්‍ෂාක්‍ෂේත්‍රපතිඃ කිං කරිෂ්‍යති? ස ඒත්‍ය තාන් කෘෂීවලාන් සංහත්‍ය තත්ක්‍ෂේත්‍රම් අන්‍යේෂු කෘෂීවලේෂු සමර්පයිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","අපරඤ්ච, \"ස්ථපතයඃ කරිෂ්‍යන්ති ග්‍රාවාණං යන්තු තුච්ඡකං| ප්‍රාධානප්‍රස්තරඃ කෝණේ ස ඒව සංභවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ඒතත් කර්ම්ම පරේශස්‍යාංද්භුතං නෝ දෘෂ්ටිතෝ භවේත්|| \" ඉමාං ශාස්ත්‍රීයාං ලිපිං යූයං කිං නාපාඨිෂ්ට? ");
INSERT INTO sansin_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","තදානීං ස තානුද්දිශ්‍ය තාං දෘෂ්ටාන්තකථාං කථිතවාන්, ත ඉත්ථං බුද්ව්වා තං ධර්ත්තාමුද්‍යතාඃ, කින්තු ලෝකේභ්‍යෝ බිභ්‍යුඃ, තදනන්තරං තේ තං විහාය වව්‍රජුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","අපරඤ්ච තේ තස්‍ය වාක්‍යදෝෂං ධර්ත්තාං කතිපයාන් ඵිරූශිනෝ හේරෝදීයාංශ්ච ලෝකාන් තදන්තිකං ප්‍රේෂයාමාසුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ත ආගත්‍ය තමවදන්, හේ ගුරෝ භවාන් තථ්‍යභාෂී කස්‍යාප්‍යනුරෝධං න මන්‍යතේ, පක්‍ෂපාතඤ්ච න කරෝති, යථාර්ථත ඊශ්වරීයං මාර්ගං දර්ශයති වයමේතත් ප්‍රජානීමඃ, කෛසරාය කරෝ දේයෝ න වාං? වයං දාස්‍යාමෝ න වා? ");
INSERT INTO sansin_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","කින්තු ස තේෂාං කපටං ඥාත්වා ජගාද, කුතෝ මාං පරීක්‍ෂධ්වේ? ඒකං මුද්‍රාපාදං සමානීය මාං දර්ශයත| ");
INSERT INTO sansin_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","තදා තෛරේකස්මින් මුද්‍රාපාදේ සමානීතේ ස තාන් පප්‍රච්ඡ, අත්‍ර ලිඛිතං නාම මූර්ත්ති ර්වා කස්‍ය? තේ ප්‍රත්‍යූචුඃ, කෛසරස්‍ය| ");
INSERT INTO sansin_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","තදා යීශුරවදත් තර්හි කෛසරස්‍ය ද්‍රව්‍යාණි කෛසරාය දත්ත, ඊශ්වරස්‍ය ද්‍රව්‍යාණි තු ඊශ්වරාය දත්ත; තතස්තේ විස්මයං මේනිරේ| ");
INSERT INTO sansin_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","අථ මෘතානාමුත්ථානං යේ න මන්‍යන්තේ තේ සිදූකිනෝ යීශෝඃ සමීපමාගත්‍ය තං පප්‍රච්ඡුඃ; ");
INSERT INTO sansin_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","හේ ගුරෝ කශ්චිජ්ජනෝ යදි නිඃසන්තතිඃ සන් භාර‍්‍ය්‍යායාං සත්‍යාං ම්‍රියතේ තර්හි තස්‍ය භ්‍රාතා තස්‍ය භාර‍්‍ය්‍යාං ගෘහීත්වා භ්‍රාතු ර්වංශෝත්පත්තිං කරිෂ්‍යති, ව්‍යවස්ථාමිමාං මූසා අස්මාන් ප්‍රති ව්‍යලිඛත්| ");
INSERT INTO sansin_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","කින්තු කේචිත් සප්ත භ්‍රාතර ආසන්, තතස්තේෂාං ජ්‍යේෂ්ඨභ්‍රාතා විවහ්‍ය නිඃසන්තතිඃ සන් අම්‍රියත| ");
INSERT INTO sansin_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","තතෝ ද්විතීයෝ භ්‍රාතා තාං ස්ත්‍රියමගෘහණත් කින්තු සෝපි නිඃසන්තතිඃ සන් අම්‍රියත; අථ තෘතීයෝපි භ්‍රාතා තාදෘශෝභවත්| ");
INSERT INTO sansin_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ඉත්ථං සප්තෛව භ්‍රාතරස්තාං ස්ත්‍රියං ගෘහීත්වා නිඃසන්තානාඃ සන්තෝ(අ)ම්‍රියන්ත, සර්ව්වශේෂේ සාපි ස්ත්‍රී ම්‍රියතේ ස්ම| ");
INSERT INTO sansin_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","අථ මෘතානාමුත්ථානකාලේ යදා ත උත්ථාස්‍යන්ති තදා තේෂාං කස්‍ය භාර‍්‍ය්‍යා සා භවිෂ්‍යති? යතස්තේ සප්තෛව තාං ව්‍යවහන්| ");
INSERT INTO sansin_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","තතෝ යීශුඃ ප්‍රත්‍යුවාච ශාස්ත්‍රම් ඊශ්වරශක්තිඤ්ච යූයමඥාත්වා කිමභ්‍රාම්‍යත න? ");
INSERT INTO sansin_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","මෘතලෝකානාමුත්ථානං සති තේ න විවහන්ති වාග්දත්තා අපි න භවන්ති, කින්තු ස්වර්ගීයදූතානාං සදෘශා භවන්ති| ");
INSERT INTO sansin_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","පුනශ්ච \"අහම් ඉබ්‍රාහීම ඊශ්වර ඉස්හාක ඊශ්වරෝ යාකූබශ්චේශ්වරඃ\" යාමිමාං කථාං ස්තම්බමධ්‍යේ තිෂ්ඨන් ඊශ්වරෝ මූසාමවාදීත් මෘතානාමුත්ථානාර්ථේ සා කථා මූසාලිඛිතේ පුස්තකේ කිං යුෂ්මාභි ර්නාපාඨි? ");
INSERT INTO sansin_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ඊශ්වරෝ ජීවතාං ප්‍රභුඃ කින්තු මෘතානාං ප්‍රභු ර්න භවති, තස්මාද්ධේතෝ ර‍්‍යූයං මහාභ්‍රමේණ තිෂ්ඨථ| ");
INSERT INTO sansin_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ඒතර්හි ඒකෝධ්‍යාපක ඒත්‍ය තේෂාමිත්ථං විචාරං ශුශ්‍රාව; යීශුස්තේෂාං වාක්‍යස්‍ය සදුත්තරං දත්තවාන් ඉති බුද්ව්වා තං පෘෂ්ටවාන් සර්ව්වාසාම් ආඥානාං කා ශ්‍රේෂ්ඨා? තතෝ යීශුඃ ප්‍රත්‍යුවාච, ");
INSERT INTO sansin_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","\"හේ ඉස්‍රායේල්ලෝකා අවධත්ත, අස්මාකං ප්‍රභුඃ පරමේශ්වර ඒක ඒව, ");
INSERT INTO sansin_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","යූයං සර්ව්වන්තඃකරණෛඃ සර්ව්වප්‍රාණෛඃ සර්ව්වචිත්තෛඃ සර්ව්වශක්තිභිශ්ච තස්මින් ප්‍රභෞ පරමේශ්වරේ ප්‍රීයධ්වං,\" ඉත්‍යාඥා ශ්‍රේෂ්ඨා| ");
INSERT INTO sansin_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","තථා \"ස්වප්‍රතිවාසිනි ස්වවත් ප්‍රේම කුරුධ්වං,\" ඒෂා යා ද්විතීයාඥා සා තාදෘශී; ඒතාභ්‍යාං ද්වාභ්‍යාම් ආඥාභ්‍යාම් අන්‍යා කාප්‍යාඥා ශ්‍රේෂ්ඨා නාස්ති| ");
INSERT INTO sansin_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","තදා සෝධ්‍යාපකස්තමවදත්, හේ ගුරෝ සත්‍යං භවාන් යථාර්ථං ප්‍රෝක්තවාන් යත ඒකස්මාද් ඊශ්වරාද් අන්‍යෝ ද්විතීය ඊශ්වරෝ නාස්ති; ");
INSERT INTO sansin_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","අපරං සර්ව්වාන්තඃකරණෛඃ සර්ව්වප්‍රාණෛඃ සර්ව්වචිත්තෛඃ සර්ව්වශක්තිභිශ්ච ඊශ්වරේ ප්‍රේමකරණං තථා ස්වමීපවාසිනි ස්වවත් ප්‍රේමකරණඤ්ච සර්ව්වේභ්‍යෝ හෝමබලිදානාදිභ්‍යඃ ශ්‍රෂ්ඨං භවති| ");
INSERT INTO sansin_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","තතෝ යීශුඃ සුබුද්ධේරිව තස්‍යේදම් උත්තරං ශ්‍රුත්වා තං භාෂිතවාන් ත්වමීශ්වරස්‍ය රාජ්‍යාන්න දූරෝසි| ඉතඃ පරං තේන සහ කස්‍යාපි වාක්‍යස්‍ය විචාරං කර්ත්තාං කස්‍යාපි ප්‍රගල්භතා න ජාතා| ");
INSERT INTO sansin_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","අනන්තරං මධ්‍යේමන්දිරම් උපදිශන් යීශුරිමං ප්‍රශ්නං චකාර, අධ්‍යාපකා අභිෂික්තං (තාරකං) කුතෝ දායූදඃ සන්තානං වදන්ති? ");
INSERT INTO sansin_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ස්වයං දායූද් පවිත්‍රස්‍යාත්මන ආවේශේනේදං කථයාමාස| යථා| \"මම ප්‍රභුමිදං වාක්‍යවදත් පරමේශ්වරඃ| තව ශත්‍රූනහං යාවත් පාදපීඨං කරෝමි න| තාවත් කාලං මදීයේ ත්වං දක්‍ෂපාර්ශ්ව් උපාවිශ| \" ");
INSERT INTO sansin_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","යදි දායූද් තං ප්‍රභූං වදති තර්හි කථං ස තස්‍ය සන්තානෝ භවිතුමර්හති? ඉතරේ ලෝකාස්තත්කථාං ශ්‍රුත්වානනන්දුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","තදානීං ස තානුපදිශ්‍ය කථිතවාන් යේ නරා දීර්ඝපරිධේයානි හට්ටේ විපනෞ ච ");
INSERT INTO sansin_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ලෝකකෘතනමස්කාරාන් භජනගෘහේ ප්‍රධානාසනානි භෝජනකාලේ ප්‍රධානස්ථානානි ච කාඞ්ක්‍ෂන්තේ; ");
INSERT INTO sansin_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","විධවානාං සර්ව්වස්වං ග්‍රසිත්වා ඡලාද් දීර්ඝකාලං ප්‍රාර්ථයන්තේ තේභ්‍ය උපාධ්‍යායේභ්‍යඃ සාවධානා භවත; තේ(අ)ධිකතරාන් දණ්ඩාන් ප්‍රාප්ස්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","තදනන්තරං ලෝකා භාණ්ඩාගාරේ මුද්‍රා යථා නික්‍ෂිපන්ති භාණ්ඩාගාරස්‍ය සම්මුඛේ සමුපවිශ්‍ය යීශුස්තදවලුලෝක; තදානීං බහවෝ ධනිනස්තස්‍ය මධ්‍යේ බහූනි ධනානි නිරක්‍ෂිපන්| ");
INSERT INTO sansin_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","පශ්චාද් ඒකා දරිද්‍රා විධවා සමාගත්‍ය ද්විපණමූල්‍යාං මුද්‍රෛකාං තත්‍ර නිරක්‍ෂිපත්| ");
INSERT INTO sansin_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","තදා යීශුඃ ශිෂ්‍යාන් ආහූය කථිතවාන් යුෂ්මානහං යථාර්ථං වදාමි යේ යේ භාණ්ඩාගාරේ(අ)ස්මින ධනානි නිඃක්‍ෂිපන්ති ස්ම තේභ්‍යඃ සර්ව්වේභ්‍ය ඉයං විධවා දරිද්‍රාධිකම් නිඃක්‍ෂිපති ස්ම| ");
INSERT INTO sansin_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","යතස්තේ ප්‍රභූතධනස්‍ය කිඤ්චිත් නිරක්‍ෂිපන් කින්තු දීනේයං ස්වදිනයාපනයෝග්‍යං කිඤ්චිදපි න ස්ථාපයිත්වා සර්ව්වස්වං නිරක්‍ෂිපත්| ");
INSERT INTO sansin_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","අනන්තරං මන්දිරාද් බහිර්ගමනකාලේ තස්‍ය ශිෂ්‍යාණාමේකස්තං ව්‍යාහෘතවාන් හේ ගුරෝ පශ්‍යතු කීදෘශාඃ පාෂාණාඃ කීදෘක් ච නිචයනං| ");
INSERT INTO sansin_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","තදා යීශුස්තම් අවදත් ත්වං කිමේතද් බෘහන්නිචයනං පශ්‍යසි? අස්‍යෛකපාෂාණෝපි ද්විතීයපාෂාණෝපරි න ස්ථාස්‍යති සර්ව්වේ (අ)ධඃක්‍ෂේප්ස්‍යන්තේ| ");
INSERT INTO sansin_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","අථ යස්මින් කාලේ ජෛතුන්ගිරෞ මන්දිරස්‍ය සම්මුඛේ ස සමුපවිෂ්ටස්තස්මින් කාලේ පිතරෝ යාකූබ් යෝහන් ආන්ද්‍රියශ්චෛතේ තං රහසි පප්‍රච්ඡුඃ, ");
INSERT INTO sansin_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","ඒතා ඝටනාඃ කදා භවිෂ්‍යන්ති? තථෛතත්සර්ව්වාසාං සිද්ධ්‍යුපක්‍රමස්‍ය වා කිං චිහ්නං? තදස්මභ්‍යං කථයතු භවාන්| ");
INSERT INTO sansin_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","තතෝ යාශුස්තාන් වක්තුමාරේභේ, කෝපි යථා යුෂ්මාන් න භ්‍රාමයති තථාත්‍ර යූයං සාවධානා භවත| ");
INSERT INTO sansin_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","යතඃ ඛ්‍රීෂ්ටෝහමිති කථයිත්වා මම නාම්නානේකේ සමාගත්‍ය ලෝකානාං භ්‍රමං ජනයිෂ්‍යන්ති; ");
INSERT INTO sansin_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","කින්තු යූයං රණස්‍ය වාර්ත්තාං රණාඩම්බරඤ්ච ශ්‍රුත්වා මා ව්‍යාකුලා භවත, ඝටනා ඒතා අවශ්‍යම්මාවින්‍යඃ; කින්ත්වාපාතතෝ න යුගාන්තෝ භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","දේශස්‍ය විපක්‍ෂතයා දේශෝ රාජ්‍යස්‍ය විපක්‍ෂතයා ච රාජ්‍යමුත්ථාස්‍යති, තථා ස්ථානේ ස්ථානේ භූමිකම්පෝ දුර්භික්‍ෂං මහාක්ලේශාශ්ච සමුපස්ථාස්‍යන්ති, සර්ව්ව ඒතේ දුඃඛස්‍යාරම්භාඃ| ");
INSERT INTO sansin_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","කින්තු යූයම් ආත්මාර්ථේ සාවධානාස්තිෂ්ඨත, යතෝ ලෝකා රාජසභායාං යුෂ්මාන් සමර්පයිෂ්‍යන්ති, තථා භජනගෘහේ ප්‍රහරිෂ්‍යන්ති; යූයං මදර්ථේ දේශාධිපාන් භූපාංශ්ච ප්‍රති සාක්‍ෂ්‍යදානාය තේෂාං සම්මුඛේ උපස්ථාපයිෂ්‍යධ්වේ| ");
INSERT INTO sansin_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ශේෂීභවනාත් පූර්ව්වං සර්ව්වාන් දේශීයාන් ප්‍රති සුසංවාදඃ ප්‍රචාරයිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","කින්තු යදා තේ යුෂ්මාන් ධෘත්වා සමර්පයිෂ්‍යන්ති තදා යූයං යද්‍යද් උත්තරං දාස්‍යථ, තදග්‍ර තස්‍ය විවේචනං මා කුරුත තදර්ථං කිඤ්චිදපි මා චින්තයත ච, තදානීං යුෂ්මාකං මනඃසු යද්‍යද් වාක්‍යම් උපස්ථාපයිෂ්‍යතේ තදේව වදිෂ්‍යථ, යතෝ යූයං න තද්වක්තාරඃ කින්තු පවිත්‍ර ආත්මා තස්‍ය වක්තා| ");
INSERT INTO sansin_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","තදා භ්‍රාතා භ්‍රාතරං පිතා පුත්‍රං ඝාතනාර්ථං පරහස්තේෂු සමර්පයිෂ්‍යතේ, තථා පත්‍යානි මාතාපිත්‍රෝ ර්විපක්‍ෂතයා තෞ ඝාතයිෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","මම නාමහේතෝඃ සර්ව්වේෂාං සවිධේ යූයං ජුගුප්සිතා භවිෂ්‍යථ, කින්තු යඃ කශ්චිත් ශේෂපර‍්‍ය්‍යන්තං ධෛර‍්‍ය්‍යම් ආලම්බිෂ්‍යතේ සඒව පරිත්‍රාස්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","දානියේල්භවිෂ්‍යද්වාදිනා ප්‍රෝක්තං සර්ව්වනාශි ජුගුප්සිතඤ්ච වස්තු යදා ත්වයෝග්‍යස්ථානේ විද්‍යමානං ද්‍රක්‍ෂථ (යෝ ජනඃ පඨති ස බුධ්‍යතාං) තදා යේ යිහූදීයදේශේ තිෂ්ඨන්ති තේ මහීධ්‍රං ප්‍රති පලායන්තාං; ");
INSERT INTO sansin_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","තථා යෝ නරෝ ගෘහෝපරි තිෂ්ඨති ස ගෘහමධ්‍යං නාවරෝහතු, තථා කිමපි වස්තු ග්‍රහීතුං මධ්‍යේගෘහං න ප්‍රවිශතු; ");
INSERT INTO sansin_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","තථා ච යෝ නරඃ ක්‍ෂේත්‍රේ තිෂ්ඨති සෝපි ස්වවස්ත්‍රං ග්‍රහීතුං පරාවෘත්‍ය න ව්‍රජතු| ");
INSERT INTO sansin_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","තදානීං ගර්බ්භවතීනාං ස්තන්‍යදාත්‍රීණාඤ්ච යෝෂිතාං දුර්ගති ර්භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","යුෂ්මාකං පලායනං ශීතකාලේ යථා න භවති තදර්ථං ප්‍රාර්ථයධ්වං| ");
INSERT INTO sansin_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","යතස්තදා යාදෘශී දුර්ඝටනා ඝටිෂ්‍යතේ තාදෘශී දුර්ඝටනා ඊශ්වරසෘෂ්ටේඃ ප්‍රථමමාරභ්‍යාද්‍ය යාවත් කදාපි න ජාතා න ජනිෂ්‍යතේ ච| ");
INSERT INTO sansin_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","අපරඤ්ච පරමේශ්වරෝ යදි තස්‍ය සමයස්‍ය සංක්‍ෂේපං න කරෝති තර්හි කස්‍යාපි ප්‍රාණභෘතෝ රක්‍ෂා භවිතුං න ශක්‍ෂ්‍යති, කින්තු යාන් ජනාන් මනෝනීතාන් අකරෝත් තේෂාං ස්වමනෝනීතානාං හේතෝඃ ස තදනේහසං සංක්‍ෂේප්ස්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","අන්‍යච්ච පශ්‍යත ඛ්‍රීෂ්ටෝත්‍ර ස්ථානේ වා තත්‍ර ස්ථානේ විද්‍යතේ, තස්මින්කාලේ යදි කශ්චිද් යුෂ්මාන් ඒතාදෘශං වාක්‍යං ව්‍යාහරති, තර්හි තස්මින් වාක්‍යේ භෛව විශ්වසිත| ");
INSERT INTO sansin_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","යතෝනේකේ මිථ්‍යාඛ්‍රීෂ්ටා මිථ්‍යාභවිෂ්‍යද්වාදිනශ්ච සමුපස්ථාය බහූනි චිහ්නාන්‍යද්භුතානි කර්ම්මාණි ච දර්ශයිෂ්‍යන්ති; තථා යදි සම්භවති තර්හි මනෝනීතලෝකානාමපි මිථ්‍යාමතිං ජනයිෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","පශ්‍යත ඝටනාතඃ පූර්ව්වං සර්ව්වකාර‍්‍ය්‍යස්‍ය වාර්ත්තාං යුෂ්මභ්‍යමදාම්, යූයං සාවධානාස්තිෂ්ඨත| ");
INSERT INTO sansin_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","අපරඤ්ච තස්‍ය ක්ලේශකාලස්‍යාව්‍යවහිතේ පරකාලේ භාස්කරඃ සාන්ධකාරෝ භවිෂ්‍යති තථෛව චන්ද්‍රශ්චන්ද්‍රිකාං න දාස්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","නභඃස්ථානි නක්‍ෂත්‍රාණි පතිෂ්‍යන්ති, ව්‍යෝමමණ්ඩලස්ථා ග්‍රහාශ්ච විචලිෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","තදානීං මහාපරාක්‍රමේණ මහෛශ්වර‍්‍ය්‍යේණ ච මේඝමාරුහ්‍ය සමායාන්තං මානවසුතං මානවාඃ සමීක්‍ෂිෂ්‍යන්තේ| ");
INSERT INTO sansin_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","අන්‍යච්ච ස නිජදූතාන් ප්‍රහිත්‍ය නභෝභූම්‍යෝඃ සීමාං යාවද් ජගතශ්චතුර්දිග්භ්‍යඃ ස්වමනෝනීතලෝකාන් සංග්‍රහීෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","උඩුම්බරතරෝ ර්දෘෂ්ටාන්තං ශික්‍ෂධ්වං යදෝඩුම්බරස්‍ය තරෝ ර්නවීනාඃ ශාඛා ජායන්තේ පල්ලවාදීනි ච ර්නිගච්ඡන්ති, තදා නිදාඝකාලඃ සවිධෝ භවතීති යූයං ඥාතුං ශක්නුථ| ");
INSERT INTO sansin_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","තද්වද් ඒතා ඝටනා දෘෂ්ට්වා ස කාලෝ ද්වාර‍්‍ය්‍යුපස්ථිත ඉති ජානීත| ");
INSERT INTO sansin_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","යුෂ්මානහං යථාර්ථං වදාමි, ආධුනිකලෝකානාං ගමනාත් පූර්ව්වං තානි සර්ව්වාණි ඝටිෂ්‍යන්තේ| ");
INSERT INTO sansin_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ද්‍යාවාපෘථිව්‍යෝ ර්විචලිතයෝඃ සත්‍යෝ ර්මදීයා වාණී න විචලිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","අපරඤ්ච ස්වර්ගස්ථදූතගණෝ වා පුත්‍රෝ වා තාතාදන්‍යඃ කෝපි තං දිවසං තං දණ්ඩං වා න ඥාපයති| ");
INSERT INTO sansin_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","අතඃ ස සමයඃ කදා භවිෂ්‍යති, ඒතජ්ඥානාභාවාද් යූයං සාවධානාස්තිෂ්ඨත, සතර්කාශ්ච භූත්වා ප්‍රාර්ථයධ්වං; ");
INSERT INTO sansin_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","යද්වත් කශ්චිත් පුමාන් ස්වනිවේශනාද් දූරදේශං ප්‍රති යාත්‍රාකරණකාලේ දාසේෂු ස්වකාර‍්‍ය්‍යස්‍ය භාරමර්පයිත්වා සර්ව්වාන් ස්වේ ස්වේ කර්ම්මණි නියෝජයති; අපරං දෞවාරිකං ජාගරිතුං සමාදිශ්‍ය යාති, තද්වන් නරපුත්‍රඃ| ");
INSERT INTO sansin_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","ගෘහපතිඃ සායංකාලේ නිශීථේ වා තෘතීයයාමේ වා ප්‍රාතඃකාලේ වා කදාගමිෂ්‍යති තද් යූයං න ජානීථ; ");
INSERT INTO sansin_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ස හඨාදාගත්‍ය යථා යුෂ්මාන් නිද්‍රිතාන් න පශ්‍යති, තදර්ථං ජාගරිතාස්තිෂ්ඨත| ");
INSERT INTO sansin_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","යුෂ්මානහං යද් වදාමි තදේව සර්ව්වාන් වදාමි, ජාගරිතාස්තිෂ්ඨතේති| ");
INSERT INTO sansin_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","තදා නිස්තාරෝත්සවකිණ්වහීනපූපෝත්සවයෝරාරම්භස්‍ය දිනද්වයේ (අ)වශිෂ්ටේ ප්‍රධානයාජකා අධ්‍යාපකාශ්ච කේනාපි ඡලේන යීශුං ධර්ත්තාං හන්තුඤ්ච මෘගයාඤ්චක්‍රිරේ; ");
INSERT INTO sansin_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","කින්තු ලෝකානාං කලහභයාදූචිරේ, නචෝත්සවකාල උචිතමේතදිති| ");
INSERT INTO sansin_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","අනන්තරං බෛථනියාපුुරේ ශිමෝනකුෂ්ඨිනෝ ගෘහේ යෝශෞ භෝත්කුමුපවිෂ්ටේ සති කාචිද් යෝෂිත් පාණ්ඩරපාෂාණස්‍ය සම්පුටකේන මහාර්ඝ්‍යෝත්තමතෛලම් ආනීය සම්පුටකං භංක්ත්වා තස්‍යෝත්තමාඞ්ගේ තෛලධාරාං පාතයාඤ්චක්‍රේ| ");
INSERT INTO sansin_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","තස්මාත් කේචිත් ස්වාන්තේ කුප්‍යන්තඃ කථිතවංන්තඃ කුතෝයං තෛලාපව්‍යයඃ? ");
INSERT INTO sansin_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","යද්‍යේතත් තෛල ව්‍යක්‍රේෂ්‍යත තර්හි මුද්‍රාපාදශතත්‍රයාදප්‍යධිකං තස්‍ය ප්‍රාප්තමූල්‍යං දරිද්‍රලෝකේභ්‍යෝ දාතුමශක්‍ෂ්‍යත, කථාමේතාං කථයිත්වා තයා යෝෂිතා සාකං වාචායුහ්‍යන්| ");
INSERT INTO sansin_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","කින්තු යීශුරුවාච, කුත ඒතස්‍යෛ කෘච්ඡ්‍රං දදාසි? මහ්‍යමියං කර්ම්මෝත්තමං කෘතවතී| ");
INSERT INTO sansin_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","දරිද්‍රාඃ සර්ව්වදා යුෂ්මාභිඃ සහ තිෂ්ඨන්ති, තස්මාද් යූයං යදේච්ඡථ තදෛව තානුපකර්ත්තාං ශක්නුථ, කින්ත්වහං යුභාභිඃ සහ නිරන්තරං න තිෂ්ඨාමි| ");
INSERT INTO sansin_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","අස්‍යා යථාසාධ්‍යං තථෛවාකරෝදියං, ශ්මශානයාපනාත් පූර්ව්වං සමේත්‍ය මද්වපුෂි තෛලම් අමර්ද්දයත්| ");
INSERT INTO sansin_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","අහං යුෂ්මභ්‍යං යථාර්ථං කථයාමි, ජගතාං මධ්‍යේ යත්‍ර යත්‍ර සුසංවාදෝයං ප්‍රචාරයිෂ්‍යතේ තත්‍ර තත්‍ර යෝෂිත ඒතස්‍යාඃ ස්මරණාර්ථං තත්කෘතකර්ම්මෛතත් ප්‍රචාරයිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","තතඃ පරං ද්වාදශානාං ශිෂ්‍යාණාමේක ඊෂ්කරියෝතීයයිහූදාඛ්‍යෝ යීශුං පරකරේෂු සමර්පයිතුං ප්‍රධානයාජකානාං සමීපමියාය| ");
INSERT INTO sansin_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","තේ තස්‍ය වාක්‍යං සමාකර්ණ්‍ය සන්තුෂ්ටාඃ සන්තස්තස්මෛ මුද්‍රා දාතුං ප්‍රත්‍යජානත; තස්මාත් ස තං තේෂාං කරේෂු සමර්පණායෝපායං මෘගයාමාස| ");
INSERT INTO sansin_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","අනන්තරං කිණ්වශූන්‍යපූපෝත්සවස්‍ය ප්‍රථමේ(අ)හනි නිස්තාරෝත්මවාර්ථං මේෂමාරණාසමයේ ශිෂ්‍යාස්තං පප්‍රච්ඡඃ කුත්‍ර ගත්වා වයං නිස්තාරෝත්සවස්‍ය භෝජ්‍යමාසාදයිෂ්‍යාමඃ? කිමිච්ඡති භවාන්? ");
INSERT INTO sansin_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","තදානීං ස තේෂාං ද්වයං ප්‍රේරයන් බභාෂේ යුවයෝඃ පුරමධ්‍යං ගතයෝඃ සතෝ ර‍්‍යෝ ජනඃ සජලකුම්භං වහන් යුවාං සාක්‍ෂාත් කරිෂ්‍යති තස්‍යෛව පශ්චාද් යාතං; ");
INSERT INTO sansin_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ස යත් සදනං ප්‍රවේක්‍ෂ්‍යති තද්භවනපතිං වදතං, ගුරුරාහ යත්‍ර සශිෂ්‍යෝහං නිස්තාරෝත්සවීයං භෝජනං කරිෂ්‍යාමි, සා භෝජනශාලා කුත්‍රාස්ති? ");
INSERT INTO sansin_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","තතඃ ස පරිෂ්කෘතාං සුසජ්ජිතාං බෘහතීචඤ්ච යාං ශාලාං දර්ශයිෂ්‍යති තස්‍යාමස්මදර්ථං භෝජ්‍යද්‍රව්‍යාණ්‍යාසාදයතං| ");
INSERT INTO sansin_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","තතඃ ශිෂ්‍යෞ ප්‍රස්ථාය පුරං ප්‍රවිශ්‍ය ස යථෝක්තවාන් තථෛව ප්‍රාප්‍ය නිස්තාරෝත්සවස්‍ය භෝජ්‍යද්‍රව්‍යාණි සමාසාදයේතාම්| ");
INSERT INTO sansin_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","අනන්තරං යීශුඃ සායංකාලේ ද්වාදශභිඃ ශිෂ්‍යෛඃ සාර්ද්ධං ජගාම; ");
INSERT INTO sansin_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","සර්ව්වේෂු භෝජනාය ප්‍රෝපවිෂ්ටේෂු ස තානුදිතවාන් යුෂ්මානහං යථාර්ථං ව්‍යාහරාමි, අත්‍ර යුෂ්මාකමේකෝ ජනෝ යෝ මයා සහ භුංක්තේ මාං පරකේරේෂු සමර්පයිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","තදානීං තේ දුඃඛිතාඃ සන්ත ඒකෛකශස්තං ප්‍රෂ්ටුමාරබ්ධවන්තඃ ස කිමහං? පශ්චාද් අන්‍ය ඒකෝභිදධේ ස කිමහං? ");
INSERT INTO sansin_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","තතඃ ස ප්‍රත්‍යවදද් ඒතේෂාං ද්වාදශානාං යෝ ජනෝ මයා සමං භෝජනාපාත්‍රේ පාණිං මජ්ජයිෂ්‍යති ස ඒව| ");
INSERT INTO sansin_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","මනුජතනයමධි යාදෘශං ලිඛිතමාස්තේ තදනුරූපා ගතිස්තස්‍ය භවිෂ්‍යති, කින්තු යෝ ජනෝ මානවසුතං සමර්පයිෂ්‍යතේ හන්ත තස්‍ය ජන්මාභාවේ සති භද්‍රමභවිෂ්‍යත්| ");
INSERT INTO sansin_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","අපරඤ්ච තේෂාං භෝජනසමයේ යීශුඃ පූපං ගෘහීත්වේශ්වරගුණාන් අනුකීර්ත්‍ය භඞ්ක්ත්වා තේභ්‍යෝ දත්ත්වා බභාෂේ, ඒතද් ගෘහීත්වා භුඤ්ජීධ්වම් ඒතන්මම විග්‍රහරූපං| ");
INSERT INTO sansin_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","අනන්තරං ස කංසං ගෘහීත්වේශ්වරස්‍ය ගුණාන් කීර්ත්තයිත්වා තේභ්‍යෝ දදෞ, තතස්තේ සර්ව්වේ පපුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","අපරං ස තානවාදීද් බහූනාං නිමිත්තං පාතිතං මම නවීනනියමරූපං ශෝණිතමේතත්| ");
INSERT INTO sansin_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","යුෂ්මානහං යථාර්ථං වදාමි, ඊශ්වරස්‍ය රාජ්‍යේ යාවත් සද්‍යෝජාතං ද්‍රාක්‍ෂාරසං න පාස්‍යාමි,තාවදහං ද්‍රාක්‍ෂාඵලරසං පුන ර්න පාස්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","තදනන්තරං තේ ගීතමේකං සංගීය බහි ර්ජෛතුනං ශිඛරිණං යයුඃ ");
INSERT INTO sansin_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","අථ යීශුස්තානුවාච නිශායාමස්‍යාං මයි යුෂ්මාකං සර්ව්වේෂාං ප්‍රත්‍යූහෝ භවිෂ්‍යති යතෝ ලිඛිතමාස්තේ යථා, මේෂාණාං රක්‍ෂකඤ්චාහං ප්‍රහරිෂ්‍යාමි වෛ තතඃ| මේෂාණාං නිවහෝ නූනං ප්‍රවිකීර්ණෝ භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","කන්තු මදුත්ථානේ ජාතේ යුෂ්මාකමග්‍රේ(අ)හං ගාලීලං ව්‍රජිෂ්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","තදා පිතරඃ ප්‍රතිබභාෂේ, යද්‍යපි සර්ව්වේෂාං ප්‍රත්‍යූහෝ භවති තථාපි මම නෛව භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","තතෝ යීශුරුක්තාවාන් අහං තුභ්‍යං තථ්‍යං කථයාමි, ක්‍ෂණාදායාමද්‍ය කුක්කුටස්‍ය ද්විතීයවාරරවණාත් පූර්ව්වං ත්වං වාරත්‍රයං මාමපහ්නෝෂ්‍යසේ| ");
INSERT INTO sansin_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","කින්තු ස ගාඪං ව්‍යාහරද් යද්‍යපි ත්වයා සාර්ද්ධං මම ප්‍රාණෝ යාති තථාපි කථමපි ත්වාං නාපහ්නෝෂ්‍යේ; සර්ව්වේ(අ)පීතරේ තථෛව බභාෂිරේ| ");
INSERT INTO sansin_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","අපරඤ්ච තේෂු ගේත්ශිමානීනාමකං ස්ථාන ගතේෂු ස ශිෂ්‍යාන් ජගාද, යාවදහං ප්‍රාර්ථයේ තාවදත්‍ර ස්ථානේ යූයං සමුපවිශත| ");
INSERT INTO sansin_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","අථ ස පිතරං යාකූබං යෝහනඤ්ච ගෘහීත්වා වව්‍රාජ; අත්‍යන්තං ත්‍රාසිතෝ ව්‍යාකුලිතශ්ච තේභ්‍යඃ කථයාමාස, ");
INSERT INTO sansin_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","නිධනකාලවත් ප්‍රාණෝ මේ(අ)තීව දඃඛමේති, යූයං ජාග්‍රතෝත්‍ර ස්ථානේ තිෂ්ඨත| ");
INSERT INTO sansin_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","තතඃ ස කිඤ්චිද්දූරං ගත්වා භූමාවධෝමුඛඃ පතිත්වා ප්‍රාර්ථිතවානේතත්, යදි භවිතුං ශක්‍යං තර්හි දුඃඛසමයෝයං මත්තෝ දූරීභවතු| ");
INSERT INTO sansin_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","අපරමුදිතවාන් හේ පිත ර්හේ පිතඃ සර්ව්වේං ත්වයා සාධ්‍යං, තතෝ හේතෝරිමං කංසං මත්තෝ දූරීකුරු, කින්තු තන් මමේච්ඡාතෝ න තවේච්ඡාතෝ භවතු| ");
INSERT INTO sansin_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","තතඃ පරං ස ඒත්‍ය තාන් නිද්‍රිතාන් නිරීක්‍ෂ්‍ය පිතරං ප්‍රෝවාච, ශිමෝන් ත්වං කිං නිද්‍රාසි? ඝටිකාමේකාම් අපි ජාගරිතුං න ශක්නෝෂි? ");
INSERT INTO sansin_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","පරීක්‍ෂායාං යථා න පතථ තදර්ථං සචේතනාඃ සන්තඃ ප්‍රාර්ථයධ්වං; මන උද්‍යුක්තමිති සත්‍යං කින්තු වපුරශක්තිකං| ");
INSERT INTO sansin_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","අථ ස පුනර්ව්‍රජිත්වා පූර්ව්වවත් ප්‍රාර්ථයාඤ්චක්‍රේ| ");
INSERT INTO sansin_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","පරාවෘත්‍යාගත්‍ය පුනරපි තාන් නිද්‍රිතාන් දදර්ශ තදා තේෂාං ලෝචනානි නිද්‍රයා පූර්ණානි, තස්මාත්තස්මෛ කා කථා කථයිතව්‍යා ත ඒතද් බෝද්ධුං න ශේකුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","තතඃපරං තෘතීයවාරං ආගත්‍ය තේභ්‍යෝ (අ)කථයද් ඉදානීමපි ශයිත්වා විශ්‍රාම්‍යථ? යථේෂ්ටං ජාතං, සමයශ්චෝපස්ථිතඃ පශ්‍යත මානවතනයඃ පාපිලෝකානාං පාණිෂු සමර්ප්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","උත්තිෂ්ඨත, වයං ව්‍රජාමෝ යෝ ජනෝ මාං පරපාණිෂු සමර්පයිෂ්‍යතේ පශ්‍යත ස සමීපමායාතඃ| ");
INSERT INTO sansin_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ඉමාං කථාං කථයති ස, ඒතර්හිද්වාදශානාමේකෝ යිහූදා නාමා ශිෂ්‍යඃ ප්‍රධානයාජකානාම් උපාධ්‍යායානාං ප්‍රාචීනලෝකානාඤ්ච සන්නිධේඃ ඛඞ්ගලගුඩධාරිණෝ බහුලෝකාන් ගෘහීත්වා තස්‍ය සමීප උපස්ථිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","අපරඤ්චාසෞ පරපාණිෂු සමර්පයිතා පූර්ව්වමිති සඞ්කේතං කෘතවාන් යමහං චුම්බිෂ්‍යාමි ස ඒවාසෞ තමේව ධෘත්වා සාවධානං නයත| ");
INSERT INTO sansin_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","අතෝ හේතෝඃ ස ආගත්‍යෛව යෝශෝඃ සවිධං ගත්වා හේ ගුරෝ හේ ගුරෝ, ඉත්‍යුක්ත්වා තං චුචුම්බ| ");
INSERT INTO sansin_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","තදා තේ තදුපරි පාණීනර්පයිත්වා තං දධ්නුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","තතස්තස්‍ය පාර්ශ්වස්ථානාං ලෝකානාමේකඃ ඛඞ්ගං නිෂ්කෝෂයන් මහායාජකස්‍ය දාසමේකං ප්‍රහෘත්‍ය තස්‍ය කර්ණං චිච්ඡේද| ");
INSERT INTO sansin_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","පශ්චාද් යීශුස්තාන් ව්‍යාජහාර ඛඞ්ගාන් ලගුඩාංශ්ච ගෘහීත්වා මාං කිං චෞරං ධර්ත්තාං සමායාතාඃ? ");
INSERT INTO sansin_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","මධ්‍යේමන්දිරං සමුපදිශන් ප්‍රත්‍යහං යුෂ්මාභිඃ සහ ස්ථිතවානතහං, තස්මින් කාලේ යූයං මාං නාදීධරත, කින්ත්වනේන ශාස්ත්‍රීයං වචනං සේධනීයං| ");
INSERT INTO sansin_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","තදා සර්ව්වේ ශිෂ්‍යාස්තං පරිත්‍යජ්‍ය පලායාඤ්චක්‍රිරේ| ");
INSERT INTO sansin_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","අථෛකෝ යුවා මානවෝ නග්නකායේ වස්ත්‍රමේකං නිධාය තස්‍ය පශ්චාද් ව්‍රජන් යුවලෝකෛ ර්ධෘතෝ ");
INSERT INTO sansin_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","වස්ත්‍රං විහාය නග්නඃ පලායාඤ්චක්‍රේ| ");
INSERT INTO sansin_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","අපරඤ්ච යස්මින් ස්ථානේ ප්‍රධානයාජකා උපාධ්‍යායාඃ ප්‍රාචීනලෝකාශ්ච මහායාජකේන සහ සදසි ස්ථිතාස්තස්මින් ස්ථානේ මහායාජකස්‍ය සමීපං යීශුං නින්‍යුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","පිතරෝ දූරේ තත්පශ්චාද් ඉත්වා මහායාජකස්‍යාට්ටාලිකාං ප්‍රවිශ්‍ය කිඞ්කරෛඃ සහෝපවිශ්‍ය වහ්නිතාපං ජග්‍රාහ| ");
INSERT INTO sansin_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","තදානීං ප්‍රධානයාජකා මන්ත්‍රිණශ්ච යීශුං ඝාතයිතුං තත්ප්‍රාතිකූල්‍යේන සාක්‍ෂිණෝ මෘගයාඤ්චක්‍රිරේ, කින්තු න ප්‍රාප්තාඃ| ");
INSERT INTO sansin_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","අනේකෛස්තද්විරුද්ධං මෘෂාසාක්‍ෂ්‍යේ දත්තේපි තේෂාං වාක්‍යානි න සමගච්ඡන්ත| ");
INSERT INTO sansin_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","සර්ව්වශේෂේ කියන්ත උත්ථාය තස්‍ය ප්‍රාතිකූල්‍යේන මෘෂාසාක්‍ෂ්‍යං දත්ත්වා කථයාමාසුඃ, ");
INSERT INTO sansin_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","ඉදං කරකෘතමන්දිරං විනාශ්‍ය දිනත්‍රයමධ්‍යේ පුනරපරම් අකරකෘතං මන්දිරං නිර්ම්මාස්‍යාමි, ඉති වාක්‍යම් අස්‍ය මුඛාත් ශ්‍රුතමස්මාභිරිති| ");
INSERT INTO sansin_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","කින්තු තත්‍රාපි තේෂාං සාක්‍ෂ්‍යකථා න සඞ්ගාතාඃ| ");
INSERT INTO sansin_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","අථ මහායාජකෝ මධ්‍යේසභම් උත්ථාය යීශුං ව්‍යාජහාර, ඒතේ ජනාස්ත්වයි යත් සාක්‍ෂ්‍යමදුඃ ත්වමේතස්‍ය කිමප්‍යුත්තරං කිං න දාස්‍යසි? ");
INSERT INTO sansin_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","කින්තු ස කිමප්‍යුත්තරං න දත්වා මෞනීභූය තස්‍යෞ; තතෝ මහායාජකඃ පුනරපි තං පෘෂ්ටාවාන් ත්වං සච්චිදානන්දස්‍ය තනයෝ (අ)භිෂික්තස්ත්‍රතා? ");
INSERT INTO sansin_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","තදා යීශුස්තං ප්‍රෝවාච භවාම්‍යහම් යූයඤ්ච සර්ව්වශක්තිමතෝ දක්‍ෂීණපාර්ශ්වේ සමුපවිශන්තං මේඝ මාරුහ්‍ය සමායාන්තඤ්ච මනුෂ්‍යපුත්‍රං සන්ද්‍රක්‍ෂ්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","තදා මහායාජකඃ ස්වං වමනං ඡිත්වා ව්‍යාවහරත් ");
INSERT INTO sansin_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","කිමස්මාකං සාක්‍ෂිභිඃ ප්‍රයෝජනම්? ඊශ්වරනින්දාවාක්‍යං යුෂ්මාභිරශ්‍රාවි කිං විචාරයථ? තදානීං සර්ව්වේ ජගදුරයං නිධනදණ්ඩමර්හති| ");
INSERT INTO sansin_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","තතඃ කශ්චිත් කශ්චිත් තද්වපුෂි නිෂ්ඨීවං නිචික්‍ෂේප තථා තන්මුඛමාච්ඡාද්‍ය චපේටේන හත්වා ගදිතවාන් ගණයිත්වා වද, අනුචරාශ්ච චපේටෛස්තමාජඝ්නුඃ ");
INSERT INTO sansin_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","තතඃ පරං පිතරේ(අ)ට්ටාලිකාධඃකෝෂ්ඨේ තිෂ්ඨති මහායාජකස්‍යෛකා දාසී සමේත්‍ය ");
INSERT INTO sansin_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","තං විහ්නිතාපං ගෘහ්ලන්තං විලෝක්‍ය තං සුනිරීක්‍ෂ්‍ය බභාෂේ ත්වමපි නාසරතීයයීශෝඃ සඞ්ගිනාම් ඒකෝ ජන ආසීඃ| ");
INSERT INTO sansin_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","කින්තු සෝපහ්නුත්‍ය ජගාද තමහං න වද්මි ත්වං යත් කථයමි තදප්‍යහං න බුද්ධ්‍යේ| තදානීං පිතරේ චත්වරං ගතවති කුेක්කුටෝ රුරාව| ");
INSERT INTO sansin_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","අථාන්‍යා දාසී පිතරං දෘෂ්ට්වා සමීපස්ථාන් ජනාන් ජගාද අයං තේෂාමේකෝ ජනඃ| ");
INSERT INTO sansin_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","තතඃ ස ද්විතීයවාරම් අපහ්නුතවාන් පශ්චාත් තත්‍රස්ථා ලෝකාඃ පිතරං ප්‍රෝචුස්ත්වමවශ්‍යං තේෂාමේකෝ ජනඃ යතස්ත්වං ගාලීලීයෝ නර ඉති තවෝච්චාරණං ප්‍රකාශයති| ");
INSERT INTO sansin_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","තදා ස ශපථාභිශාපෞ කෘත්වා ප්‍රෝවාච යූයං කථාං කථයථ තං නරං න ජානේ(අ)හං| ");
INSERT INTO sansin_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","තදානීං ද්විතීයවාරං කුක්කුටෝ (අ)රාවීත්| කුක්කුටස්‍ය ද්විතීයරවාත් පූර්ව්වං ත්වං මාං වාරත්‍රයම් අපහ්නෝෂ්‍යසි, ඉති යද්වාක්‍යං යීශුනා සමුදිතං තත් තදා සංස්මෘත්‍ය පිතරෝ රෝදිතුම් ආරභත| ");
INSERT INTO sansin_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","අථ ප්‍රභාතේ සති ප්‍රධානයාජකාඃ ප්‍රාඤ්ච උපාධ්‍යායාඃ සර්ව්වේ මන්ත්‍රිණශ්ච සභාං කෘත්වා යීශුृං බන්ධයිත්ව පීලාතාඛ්‍යස්‍ය දේශාධිපතේඃ සවිධං නීත්වා සමර්පයාමාසුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","තදා පීලාතස්තං පෘෂ්ටවාන් ත්වං කිං යිහූදීයලෝකානාං රාජා? තතඃ ස ප්‍රත්‍යුක්තවාන් සත්‍යං වදසි| ");
INSERT INTO sansin_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","අපරං ප්‍රධානයාජකාස්තස්‍ය බහුෂු වාක්‍යේෂු දෝෂමාරෝපයාඤ්චක්‍රුඃ කින්තු ස කිමපි න ප්‍රත්‍යුවාච| ");
INSERT INTO sansin_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","තදානීං පීලාතස්තං පුනඃ පප්‍රච්ඡ ත්වං කිං නෝත්තරයසි? පශ්‍යෛතේ ත්වද්විරුද්ධං කතිෂු සාධ්‍යේෂු සාක්‍ෂං දදති| ");
INSERT INTO sansin_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","කන්තු යීශුස්තදාපි නෝත්තරං දදෞ තතඃ පීලාත ආශ්චර‍්‍ය්‍යං ජගාම| ");
INSERT INTO sansin_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","අපරඤ්ච කාරාබද්ධේ කස්තිංශ්චිත් ජනේ තන්මහෝත්සවකාලේ ලෝකෛ ර‍්‍යාචිතේ දේශාධිපතිස්තං මෝචයති| ");
INSERT INTO sansin_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","යේ ච පූර්ව්වමුපප්ලවමකාර්ෂුරුපප්ලවේ වධමපි කෘතවන්තස්තේෂාං මධ්‍යේ තදානෝං බරබ්බානාමක ඒකෝ බද්ධ ආසීත්| ");
INSERT INTO sansin_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","අතෝ හේතෝඃ පූර්ව්වාපරීයාං රීතිකථාං කථයිත්වා ලෝකා උච්චෛරුවන්තඃ පීලාතස්‍ය සමක්‍ෂං නිවේදයාමාසුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","තදා පීලාතස්තානාචඛ්‍යෞ තර්හි කිං යිහූදීයානාං රාජානං මෝචයිෂ්‍යාමි? යුෂ්මාභිඃ කිමිෂ්‍යතේ? ");
INSERT INTO sansin_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","යතඃ ප්‍රධානයාජකා ඊර්ෂ්‍යාත ඒව යීශුං සමාර්පයන්නිති ස විවේද| ");
INSERT INTO sansin_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","කින්තු යථා බරබ්බාං මෝචයති තථා ප්‍රාර්ථයිතුං ප්‍රධානයාජකා ලෝකාන් ප්‍රවර්ත්තයාමාසුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","අථ පීලාතඃ පුනඃ පෘෂ්ටවාන් තර්හි යං යිහූදීයානාං රාජේති වදථ තස්‍ය කිං කරිෂ්‍යාමි යුෂ්මාභිඃ කිමිෂ්‍යතේ? ");
INSERT INTO sansin_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","තදා තේ පුනරපි ප්‍රෝච්චෛඃ ප්‍රෝචුස්තං ක්‍රුශේ වේධය| ");
INSERT INTO sansin_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","තස්මාත් පීලාතඃ කථිතවාන් කුතඃ? ස කිං කුකර්ම්ම කෘතවාන්? කින්තු තේ පුනශ්ච රුවන්තෝ ව්‍යාජහ්‍රුස්තං ක්‍රුශේ වේධය| ");
INSERT INTO sansin_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","තදා පීලාතඃ සර්ව්වාල්ලෝකාන් තෝෂයිතුමිච්ඡන් බරබ්බාං මෝචයිත්වා යීශුං කශාභිඃ ප්‍රහෘත්‍ය ක්‍රුශේ වේද්ධුං තං සමර්පයාම්බභූව| ");
INSERT INTO sansin_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","අනන්තරං සෛන්‍යගණෝ(අ)ට්ටාලිකාම් අර්ථාද් අධිපතේ ර්ගෘහං යීශුං නීත්වා සේනානිවහං සමාහුයත්| ");
INSERT INTO sansin_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","පශ්චාත් තේ තං ධූමලවර්ණවස්ත්‍රං පරිධාප්‍ය කණ්ටකමුකුටං රචයිත්වා ශිරසි සමාරෝප්‍ය ");
INSERT INTO sansin_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","හේ යිහූදීයානාං රාජන් නමස්කාර ඉත්‍යුක්ත්වා තං නමස්කර්ත්තාමාරේභිරේ| ");
INSERT INTO sansin_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","තස්‍යෝත්තමාඞ්ගේ වේත්‍රාඝාතං චක්‍රුස්තද්ගාත්‍රේ නිෂ්ඨීවඤ්ච නිචික්‍ෂිපුඃ, තථා තස්‍ය සම්මුඛේ ජානුපාතං ප්‍රණෝමුඃ ");
INSERT INTO sansin_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ඉත්ථමුපහස්‍ය ධූම්‍රවර්ණවස්ත්‍රම් උත්තාර‍්‍ය්‍ය තස්‍ය වස්ත්‍රං තං පර‍්‍ය්‍යධාපයන් ක්‍රුශේ වේද්ධුං බහිර්නින්‍යුශ්ච| ");
INSERT INTO sansin_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","තතඃ පරං සේකන්දරස්‍ය රුඵස්‍ය ච පිතා ශිමෝන්නාමා කුරීණීයලෝක ඒකඃ කුතශ්චිද් ග්‍රාමාදේත්‍ය පථි යාති තං තේ යීශෝඃ ක්‍රුශං වෝඪුං බලාද් දධ්නුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","අථ ගුල්ගල්තා අර්ථාත් ශිරඃකපාලනාමකං ස්ථානං යීශුමානීය ");
INSERT INTO sansin_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","තේ ගන්ධරසමිශ්‍රිතං ද්‍රාක්‍ෂාරසං පාතුං තස්මෛ දදුඃ කින්තු ස න ජග්‍රාහ| ");
INSERT INTO sansin_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","තස්මින් ක්‍රුශේ විද්ධේ සති තේෂාමේකෛකශඃ කිං ප්‍රාප්ස්‍යතීති නිර්ණයාය ");
INSERT INTO sansin_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","තස්‍ය පරිධේයානාං විභාගාර්ථං ගුටිකාපාතං චක්‍රුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","අපරම් ඒෂ යිහූදීයානාං රාජේති ලිඛිතං දෝෂපත්‍රං තස්‍ය ශිරඌර්ද්ව්වම් ආරෝපයාඤ්චක්‍රුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","තස්‍ය වාමදක්‍ෂිණයෝ ර්ද්වෞ චෞරෞ ක්‍රුශයෝ ර්විවිධාතේ| ");
INSERT INTO sansin_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","තේනෛව \"අපරාධිජනෛඃ සාර්ද්ධං ස ගණිතෝ භවිෂ්‍යති,\" ඉති ශාස්ත්‍රෝක්තං වචනං සිද්ධමභූත| ");
INSERT INTO sansin_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","අනන්තරං මාර්ගේ යේ යේ ලෝකා ගමනාගමනේ චක්‍රුස්තේ සර්ව්ව ඒව ශිරාංස්‍යාන්දෝල්‍ය නින්දන්තෝ ජගදුඃ, රේ මන්දිරනාශක රේ දිනත්‍රයමධ්‍යේ තන්නිර්ම්මායක, ");
INSERT INTO sansin_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","අධුනාත්මානම් අවිත්වා ක්‍රුශාදවරෝහ| ");
INSERT INTO sansin_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","කිඤ්ච ප්‍රධානයාජකා අධ්‍යාපකාශ්ච තද්වත් තිරස්කෘත්‍ය පරස්පරං චචක්‍ෂිරේ ඒෂ පරානාවත් කින්තු ස්වමවිතුං න ශක්නෝති| ");
INSERT INTO sansin_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","යදීස්‍රායේලෝ රාජාභිෂික්තස්ත්‍රාතා භවති තර්හ්‍යධුනෛන ක්‍රුශාදවරෝහතු වයං තද් දෘෂ්ට්වා විශ්වසිෂ්‍යාමඃ; කිඤ්ච යෞ ලෝකෞ තේන සාර්ද්ධං ක්‍රුශේ (අ)විධ්‍යේතාං තාවපි තං නිර්භර්ත්සයාමාසතුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","අථ ද්විතීයයාමාත් තෘතීයයාමං යාවත් සර්ව්වෝ දේශඃ සාන්ධකාරෝභූත්| ");
INSERT INTO sansin_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","තතස්තෘතීයප්‍රහරේ යීශුරුච්චෛරවදත් ඒලී ඒලී ලාමා ශිවක්තනී අර්ථාද් \"හේ මදීශ මදීශ ත්වං පර‍්‍ය්‍යත්‍යාක්‍ෂීඃ කුතෝ හි මාං?\" ");
INSERT INTO sansin_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","තදා සමීපස්ථලෝකානාං කේචිත් තද්වාක්‍යං නිශම්‍යාචඛ්‍යුඃ පශ්‍යෛෂ ඒලියම් ආහූයති| ");
INSERT INTO sansin_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","තත ඒකෝ ජනෝ ධාවිත්වාගත්‍ය ස්පඤ්ජේ (අ)ම්ලරසං පූරයිත්වා තං නඩාග්‍රේ නිධාය පාතුං තස්මෛ දත්ත්වාවදත් තිෂ්ඨ ඒලිය ඒනමවරෝහයිතුම් ඒති න වේති පශ්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","අථ යීශුරුච්චෛඃ සමාහූය ප්‍රාණාන් ජහෞ| ");
INSERT INTO sansin_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","තදා මන්දිරස්‍ය ජවනිකෝර්ද්ව්වාදධඃර‍්‍ය්‍යන්තා විදීර්ණා ද්විඛණ්ඩාභූත්| ");
INSERT INTO sansin_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","කිඤ්ච ඉත්ථමුච්චෛරාහූය ප්‍රාණාන් ත්‍යජන්තං තං දෘෂ්ද්වා තද්‍රක්‍ෂණාය නියුක්තෝ යඃ සේනාපතිරාසීත් සෝවදත් නරෝයම් ඊශ්වරපුත්‍ර ඉති සත්‍යම්| ");
INSERT INTO sansin_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","තදානීං මග්දලීනී මරිසම් කනිෂ්ඨයාකූබෝ යෝසේශ්ච මාතාන්‍යමරියම් ශාලෝමී ච යාඃ ස්ත්‍රියෝ ");
INSERT INTO sansin_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","ගාලීල්ප්‍රදේශේ යීශුං සේවිත්වා තදනුගාමින්‍යෝ ජාතා ඉමාස්තදන්‍යාශ්ච යා අනේකා නාර‍්‍යෝ යීශුනා සාර්ද්ධං යිරූශාලමමායාතාස්තාශ්ච දූරාත් තානි දදෘශුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","අථාසාදනදිනස්‍යාර්ථාද් විශ්‍රාමවාරාත් පූර්ව්වදිනස්‍ය සායංකාල ආගත ");
INSERT INTO sansin_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ඊශ්වරරාජ්‍යාපේක්‍ෂ්‍යරිමථීයයූෂඵනාමා මාන්‍යමන්ත්‍රී සමේත්‍ය පීලාතසවිධං නිර්භයෝ ගත්වා යීශෝර්දේහං යයාචේ| ");
INSERT INTO sansin_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","කින්තු ස ඉදානීං මෘතඃ පීලාත ඉත්‍යසම්භවං මත්වා ශතසේනාපතිමාහූය ස කදා මෘත ඉති පප්‍රච්ඡ| ");
INSERT INTO sansin_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ශතසේමනාපතිමුඛාත් තජ්ඥාත්වා යූෂඵේ යීශෝර්දේහං දදෞ| ");
INSERT INTO sansin_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","පශ්චාත් ස සූක්‍ෂ්මං වාසඃ ක්‍රීත්වා යීශෝඃ කායමවරෝහ්‍ය තේන වාසසා වේෂ්ටායිත්වා ගිරෞ ඛාතශ්මශානේ ස්ථාපිතවාන් පාෂාණං ලෝඨයිත්වා ද්වාරි නිදධේ| ");
INSERT INTO sansin_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","කින්තු යත්‍ර සෝස්ථාප්‍යත තත මග්දලීනී මරියම් යෝසිමාතෘමරියම් ච දදෘශතෘඃ| ");
INSERT INTO sansin_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","අථ විශ්‍රාමවාරේ ගතේ මග්දලීනී මරියම් යාකූබමාතා මරියම් ශාලෝමී චේමාස්තං මර්ද්දයිතුං සුගන්ධිද්‍රව්‍යාණි ක්‍රීත්වා ");
INSERT INTO sansin_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","සප්තාහප්‍රථමදිනේ(අ)තිප්‍රත්‍යූෂේ සූර‍්‍ය්‍යෝදයකාලේ ශ්මශානමුපගතාඃ| ");
INSERT INTO sansin_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","කින්තු ශ්මශානද්වාරපාෂාණෝ(අ)තිබෘහන් තං කෝ(අ)පසාරයිෂ්‍යතීති තාඃ පරස්පරං ගදන්ති! ");
INSERT INTO sansin_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ඒතර්හි නිරීක්‍ෂ්‍ය පාෂාණෝ ද්වාරෝ (අ)පසාරිත ඉති දදෘශුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","පශ්චාත්තාඃ ශ්මශානං ප්‍රවිශ්‍ය ශුක්ලවර්ණදීර්ඝපරිච්ඡදාවෘතමේකං යුවානං ශ්මශානදක්‍ෂිණපාර්ශ්ව උපවිෂ්ටං දෘෂ්ට්වා චමච්චක්‍රුඃ| ");
INSERT INTO sansin_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","සෝ(අ)වදත්, මාභෛෂ්ට යූයං ක්‍රුශේ හතං නාසරතීයයීශුං ගවේෂයථ සෝත්‍ර නාස්ති ශ්මශානාදුදස්ථාත්; තෛ ර‍්‍යත්‍ර ස ස්ථාපිතඃ ස්ථානං තදිදං පශ්‍යත| ");
INSERT INTO sansin_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","කින්තු තේන යථෝක්තං තථා යුෂ්මාකමග්‍රේ ගාලීලං යාස්‍යතේ තත්‍ර ස යුෂ්මාන් සාක්‍ෂාත් කරිෂ්‍යතේ යූයං ගත්වා තස්‍ය ශිෂ්‍යේභ්‍යඃ පිතරාය ච වාර්ත්තාමිමාං කථයත| ");
INSERT INTO sansin_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","තාඃ කම්පිතා විස්තිතාශ්ච තූර්ණං ශ්මශානාද් බහිර්ගත්වා පලායන්ත භයාත් කමපි කිමපි නාවදංශ්ච| ");
INSERT INTO sansin_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","අපරං යීශුඃ සප්තාහප්‍රථමදිනේ ප්‍රත්‍යූෂේ ශ්මශානාදුත්ථාය යස්‍යාඃ සප්තභූතාස්ත්‍යාජිතාස්තස්‍යෛ මග්දලීනීමරියමේ ප්‍රථමං දර්ශනං දදෞ| ");
INSERT INTO sansin_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","තතඃ සා ගත්වා ශෝකරෝදනකෘද්භ්‍යෝ(අ)නුගතලෝකේභ්‍යස්තාං වාර්ත්තාං කථයාමාස| ");
INSERT INTO sansin_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","කින්තු යීශුඃ පුනර්ජීවන් තස්‍යෛ දර්ශනං දත්තවානිති ශ්‍රුත්වා තේ න ප්‍රත්‍යයන්| ");
INSERT INTO sansin_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","පශ්චාත් තේෂාං ද්වායෝ ර්ග්‍රාමයානකාලේ යීශුරන්‍යවේශං ධෘත්වා තාභ්‍යාං දර්ශන දදෞ! ");
INSERT INTO sansin_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","තාවපි ගත්වාන්‍යශිෂ්‍යේභ්‍යස්තාං කථාං කථයාඤ්චක්‍රතුඃ කින්තු තයෝඃ කථාමපි තේ න ප්‍රත්‍යයන්| ");
INSERT INTO sansin_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ශේෂත ඒකාදශශිෂ්‍යේෂු භෝජනෝපවිෂ්ටේෂු යීශුස්තේභ්‍යෝ දර්ශනං දදෞ තථෝත්ථානාත් පරං තද්දර්ශනප්‍රාප්තලෝකානාං කථායාමවිශ්වාසකරණාත් තේෂාමවිශ්වාසමනඃකාඨින්‍යාභ්‍යාං හේතුභ්‍යාං ස තාංස්තර්ජිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","අථ තානාචඛ්‍යෞ යූයං සර්ව්වජගද් ගත්වා සර්ව්වජනාන් ප්‍රති සුසංවාදං ප්‍රචාරයත| ");
INSERT INTO sansin_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","තත්‍ර යඃ කශ්චිද් විශ්වස්‍ය මජ්ජිතෝ භවේත් ස පරිත්‍රාස්‍යතේ කින්තු යෝ න විශ්වසිෂ්‍යති ස දණ්ඩයිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","කිඤ්ච යේ ප්‍රත්‍යේෂ්‍යන්ති තෛරීදෘග් ආශ්චර‍්‍ය්‍යං කර්ම්ම ප්‍රකාශයිෂ්‍යතේ තේ මන්නාම්නා භූතාන් ත්‍යාජයිෂ්‍යන්ති භාෂා අන්‍යාශ්ච වදිෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","අපරං තෛඃ සර්පේෂු ධෘතේෂු ප්‍රාණනාශකවස්තුනි පීතේ ච තේෂාං කාපි ක්‍ෂති ර්න භවිෂ්‍යති; රෝගිණාං ගාත්‍රේෂු කරාර්පිතේ තේ(අ)රෝගා භවිෂ්‍යන්ති ච| ");
INSERT INTO sansin_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","අථ ප්‍රභුස්තානිත්‍යාදිශ්‍ය ස්වර්ගං නීතඃ සන් පරමේශ්වරස්‍ය දක්‍ෂිණ උපවිවේශ| ");
INSERT INTO sansin_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","තතස්තේ ප්‍රස්ථාය සර්ව්වත්‍ර සුසංවාදීයකථාං ප්‍රචාරයිතුමාරේභිරේ ප්‍රභුස්තු තේෂාං සහායඃ සන් ප්‍රකාශිතාශ්චර‍්‍ය්‍යක්‍රියාභිස්තාං කථාං ප්‍රමාණවතීං චකාර| ඉති|");
INSERT INTO sansin_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","ප්‍රථමතෝ යේ සාක්‍ෂිණෝ වාක්‍යප්‍රචාරකාශ්චාසන් තේ(අ)ස්මාකං මධ්‍යේ යද්‍යත් සප්‍රමාණං වාක්‍යමර්පයන්ති ස්ම ");
INSERT INTO sansin_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","තදනුසාරතෝ(අ)න්‍යේපි බහවස්තද්වෘත්තාන්තං රචයිතුං ප්‍රවෘත්තාඃ| ");
INSERT INTO sansin_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","අතඒව හේ මහාමහිමථියඵිල් ත්වං යා යාඃ කථා අශික්‍ෂ්‍යථාස්තාසාං දෘඪප්‍රමාණානි යථා ප්‍රාප්නෝෂි ");
INSERT INTO sansin_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","තදර්ථං ප්‍රථමමාරභ්‍ය තානි සර්ව්වාණි ඥාත්වාහමපි අනුක්‍රමාත් සර්ව්වවෘත්තාන්තාන් තුභ්‍යං ලේඛිතුං මතිමකාර්ෂම්| ");
INSERT INTO sansin_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","යිහූදාදේශීයහේරෝද්නාමකේ රාජත්වං කුර්ව්වති අබීයයාජකස්‍ය පර‍්‍ය්‍යායාධිකාරී සිඛරියනාමක ඒකෝ යාජකෝ හාරෝණවංශෝද්භවා ඉලීශේවාඛ්‍යා ");
INSERT INTO sansin_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","තස්‍ය ජායා ද්වාවිමෞ නිර්දෝෂෞ ප්‍රභෝඃ සර්ව්වාඥා ව්‍යවස්ථාශ්ච සංමන්‍ය ඊශ්වරදෘෂ්ටෞ ධාර්ම්මිකාවාස්තාම්| ");
INSERT INTO sansin_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","තයෝඃ සන්තාන ඒකෝපි නාසීත්, යත ඉලීශේවා බන්ධ්‍යා තෞ ද්වාවේව වෘද්ධාවභවතාම්| ");
INSERT INTO sansin_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","යදා ස්වපර‍්‍ය්‍යානුක්‍රමේණ සිඛරිය ඊශ්වාස්‍ය සමක්‍ෂං යාජකීයං කර්ම්ම කරෝති ");
INSERT INTO sansin_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","තදා යඥස්‍ය දිනපරිපාය්‍යා පරමේශ්වරස්‍ය මන්දිරේ ප්‍රවේශකාලේ ධූපජ්වාලනං කර්ම්ම තස්‍ය කරණීයමාසීත්| ");
INSERT INTO sansin_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","තද්ධූපජ්වාලනකාලේ ලෝකනිවහේ ප්‍රාර්ථනාං කර්තුං බහිස්තිෂ්ඨති ");
INSERT INTO sansin_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","සති සිඛරියෝ යස්‍යාං වේද්‍යාං ධූපං ජ්වාලයති තද්දක්‍ෂිණපාර්ශ්වේ පරමේශ්වරස්‍ය දූත ඒක උපස්ථිතෝ දර්ශනං දදෞ| ");
INSERT INTO sansin_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","තං දෘෂ්ට්වා සිඛරිය උද්විවිජේ ශශඞ්කේ ච| ");
INSERT INTO sansin_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","තදා ස දූතස්තං බභාෂේ හේ සිඛරිය මා භෛස්තව ප්‍රාර්ථනා ග්‍රාහ්‍යා ජාතා තව භාර‍්‍ය්‍යා ඉලීශේවා පුත්‍රං ප්‍රසෝෂ්‍යතේ තස්‍ය නාම යෝेහන් ඉති කරිෂ්‍යසි| ");
INSERT INTO sansin_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","කිඤ්ච ත්වං සානන්දඃ සහර්ෂශ්ච භවිෂ්‍යසි තස්‍ය ජන්මනි බහව ආනන්දිෂ්‍යන්ති ච| ");
INSERT INTO sansin_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","යතෝ හේතෝඃ ස පරමේශ්වරස්‍ය ගෝචරේ මහාන් භවිෂ්‍යති තථා ද්‍රාක්‍ෂාරසං සුරාං වා කිමපි න පාස්‍යති, අපරං ජන්මාරභ්‍ය පවිත්‍රේණාත්මනා පරිපූර්ණඃ ");
INSERT INTO sansin_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","සන් ඉස්‍රායේල්වංශීයාන් අනේකාන් ප්‍රභෝඃ පරමේශ්වරස්‍ය මාර්ගමානේෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","සන්තානාන් ප්‍රති පිතෘණාං මනාංසි ධර්ම්මඥානං ප්‍රත්‍යනාඥාග්‍රාහිණශ්ච පරාවර්ත්තයිතුං, ප්‍රභෝඃ පරමේශ්වරස්‍ය සේවාර්ථම් ඒකාං සජ්ජිතජාතිං විධාතුඤ්ච ස ඒලියරූපාත්මශක්තිප්‍රාප්තස්තස්‍යාග්‍රේ ගමිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","තදා සිඛරියෝ දූතමවාදීත් කථමේතද් වේත්ස්‍යාමි? යතෝහං වෘද්ධෝ මම භාර‍්‍ය්‍යා ච වෘද්ධා| ");
INSERT INTO sansin_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","තතෝ දූතඃ ප්‍රත්‍යුවාච පශ්‍යේශ්වරස්‍ය සාක්‍ෂාද්වර්ත්තී ජිබ්‍රායේල්නාමා දූතෝහං ත්වයා සහ කථාං ගදිතුං තුභ්‍යමිමාං ශුභවාර්ත්තාං දාතුඤ්ච ප්‍රේෂිතඃ| ");
INSERT INTO sansin_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","කින්තු මදීයං වාක්‍යං කාලේ ඵලිෂ්‍යති තත් ත්වයා න ප්‍රතීතම් අතඃ කාරණාද් යාවදේව තානි න සේත්ස්‍යන්ති තාවත් ත්වං වක්තුංමශක්තෝ මූකෝ භව| ");
INSERT INTO sansin_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","තදානීං යේ යේ ලෝකාඃ සිඛරියමපෛක්‍ෂන්ත තේ මධ්‍යේමන්දිරං තස්‍ය බහුවිලම්බාද් ආශ්චර‍්‍ය්‍යං මේනිරේ| ");
INSERT INTO sansin_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ස බහිරාගතෝ යදා කිමපි වාක්‍යං වක්තුමශක්තඃ සඞ්කේතං කෘත්වා නිඃශබ්දස්තස්‍යෞ තදා මධ්‍යේමන්දිරං කස්‍යචිද් දර්ශනං තේන ප්‍රාප්තම් ඉති සර්ව්වේ බුබුධිරේ| ");
INSERT INTO sansin_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","අනන්තරං තස්‍ය සේවනපර‍්‍ය්‍යායේ සම්පූර්ණේ සති ස නිජගේහං ජගාම| ");
INSERT INTO sansin_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","කතිපයදිනේෂු ගතේෂු තස්‍ය භාර‍්‍ය්‍යා ඉලීශේවා ගර්බ්භවතී බභූව ");
INSERT INTO sansin_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","පශ්චාත් සා පඤ්චමාසාන් සංගෝප්‍යාකථයත් ලෝකානාං සමක්‍ෂං මමාපමානං ඛණ්ඩයිතුං පරමේශ්වරෝ මයි දෘෂ්ටිං පාතයිත්වා කර්ම්මේදෘශං කෘතවාන්| ");
INSERT INTO sansin_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","අපරඤ්ච තස්‍යා ගර්බ්භස්‍ය ෂෂ්ඨේ මාසේ ජාතේ ගාලීල්ප්‍රදේශීයනාසරත්පුරේ ");
INSERT INTO sansin_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","දායූදෝ වංශීයාය යූෂඵ්නාම්නේ පුරුෂාය යා මරියම්නාමකුමාරී වාග්දත්තාසීත් තස්‍යාඃ සමීපං ජිබ්‍රායේල් දූත ඊශ්වරේණ ප්‍රහිතඃ| ");
INSERT INTO sansin_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ස ගත්වා ජගාද හේ ඊශ්වරානුගෘහීතකන්‍යේ තව ශුභං භූයාත් ප්‍රභුඃ පරමේශ්වරස්තව සහායෝස්ති නාරීණාං මධ්‍යේ ත්වමේව ධන්‍යා| ");
INSERT INTO sansin_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","තදානීං සා තං දෘෂ්ට්වා තස්‍ය වාක්‍යත උද්විජ්‍ය කීදෘශං භාෂණමිදම් ඉති මනසා චින්තයාමාස| ");
INSERT INTO sansin_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","තතෝ දූතෝ(අ)වදත් හේ මරියම් භයං මාකාර්ෂීඃ, ත්වයි පරමේශ්වරස්‍යානුග්‍රහෝස්ති| ");
INSERT INTO sansin_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","පශ්‍ය ත්වං ගර්බ්භං ධෘත්වා පුත්‍රං ප්‍රසෝෂ්‍යසේ තස්‍ය නාම යීශුරිති කරිෂ්‍යසි| ");
INSERT INTO sansin_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ස මහාන් භවිෂ්‍යති තථා සර්ව්වේභ්‍යඃ ශ්‍රේෂ්ඨස්‍ය පුත්‍ර ඉති ඛ්‍යාස්‍යති; අපරං ප්‍රභුඃ පරමේශ්වරස්තස්‍ය පිතුර්දායූදඃ සිංහාසනං තස්මෛ දාස්‍යති; ");
INSERT INTO sansin_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","තථා ස යාකූබෝ වංශෝපරි සර්ව්වදා රාජත්වං කරිෂ්‍යති, තස්‍ය රාජත්වස්‍යාන්තෝ න භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","තදා මරියම් තං දූතං බභාෂේ නාහං පුරුෂසඞ්ගං කරෝමි තර්හි කථමේතත් සම්භවිෂ්‍යති? ");
INSERT INTO sansin_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","තතෝ දූතෝ(අ)කථයත් පවිත්‍ර ආත්මා ත්වාමාශ්‍රායිෂ්‍යති තථා සර්ව්වශ්‍රේෂ්ඨස්‍ය ශක්තිස්තවෝපරි ඡායාං කරිෂ්‍යති තතෝ හේතෝස්තව ගර්බ්භාද් යඃ පවිත්‍රබාලකෝ ජනිෂ්‍යතේ ස ඊශ්වරපුත්‍ර ඉති ඛ්‍යාතිං ප්‍රාප්ස්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","අපරඤ්ච පශ්‍ය තව ඥාතිරිලීශේවා යාං සර්ව්වේ බන්ධ්‍යාමවදන් ඉදානීං සා වාර්ද්ධක්‍යේ සන්තානමේකං ගර්බ්භේ(අ)ධාරයත් තස්‍ය ෂෂ්ඨමාසෝභූත්| ");
INSERT INTO sansin_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","කිමපි කර්ම්ම නාසාධ්‍යම් ඊශ්වරස්‍ය| ");
INSERT INTO sansin_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","තදා මරියම් ජගාද, පශ්‍ය ප්‍රභේරහං දාසී මහ්‍යං තව වාක්‍යානුසාරේණ සර්ව්වමේතද් ඝටතාම්; අනනතරං දූතස්තස්‍යාඃ සමීපාත් ප්‍රතස්ථේ| ");
INSERT INTO sansin_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","අථ කතිපයදිනාත් පරං මරියම් තස්මාත් පර්ව්වතමයප්‍රදේශීයයිහූදායා නගරමේකං ශීඝ්‍රං ගත්වා ");
INSERT INTO sansin_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","සිඛරියයාජකස්‍ය ගෘහං ප්‍රවිශ්‍ය තස්‍ය ජායාම් ඉලීශේවාං සම්බෝධ්‍යාවදත්| ");
INSERT INTO sansin_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","තතෝ මරියමඃ සම්බෝධනවාක්‍යේ ඉලීශේවායාඃ කර්ණයෝඃ ප්‍රවිෂ්ටමාත්‍රේ සති තස්‍යා ගර්බ්භස්ථබාලකෝ නනර්ත්ත| තත ඉලීශේවා පවිත්‍රේණාත්මනා පරිපූර්ණා සතී ");
INSERT INTO sansin_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ප්‍රෝච්චෛර්ගදිතුමාරේභේ, යෝෂිතාං මධ්‍යේ ත්වමේව ධන්‍යා, තව ගර්බ්භස්ථඃ ශිශුශ්ච ධන්‍යඃ| ");
INSERT INTO sansin_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ත්වං ප්‍රභෝර්මාතා, මම නිවේශනේ ත්වයා චරණාවර්පිතෞ, මමාද්‍ය සෞභාග්‍යමේතත්| ");
INSERT INTO sansin_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","පශ්‍ය තව වාක්‍යේ මම කර්ණයෝඃ ප්‍රවිෂ්ටමාත්‍රේ සති මමෝදරස්ථඃ ශිශුරානන්දාන් නනර්ත්ත| ");
INSERT INTO sansin_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","යා ස්ත්‍රී ව්‍යශ්වසීත් සා ධන්‍යා, යතෝ හේතෝස්තාං ප්‍රති පරමේශ්වරෝක්තං වාක්‍යං සර්ව්වං සිද්ධං භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","තදානීං මරියම් ජගාද| ධන්‍යවාදං පරේශස්‍ය කරෝති මාමකං මනඃ| ");
INSERT INTO sansin_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","මමාත්මා තාරකේශේ ච සමුල්ලාසං ප්‍රගච්ඡති| ");
INSERT INTO sansin_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","අකරෝත් ස ප්‍රභු ර්දුෂ්ටිං ස්වදාස්‍යා දුර්ගතිං ප්‍රති| පශ්‍යාද්‍යාරභ්‍ය මාං ධන්‍යාං වක්‍ෂ්‍යන්ති පුරුෂාඃ සදා| ");
INSERT INTO sansin_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","යඃ සර්ව්වශක්තිමාන් යස්‍ය නාමාපි ච පවිත්‍රකං| ස ඒව සුමහත්කර්ම්ම කෘතවාන් මන්නිමිත්තකං| ");
INSERT INTO sansin_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","යේ බිභ්‍යති ජනාස්තස්මාත් තේෂාං සන්තානපංක්තිෂු| අනුකම්පා තදීයා ච සර්ව්වදෛව සුතිෂ්ඨති| ");
INSERT INTO sansin_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ස්වබාහුබලතස්තේන ප්‍රාකාශ්‍යත පරාක්‍රමඃ| මනඃකුමන්ත්‍රණාසාර්ද්ධං විකීර‍්‍ය්‍යන්තේ(අ)භිමානිනඃ| ");
INSERT INTO sansin_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","සිංහාසනගතාල්ලෝකාන් බලිනශ්චාවරෝහ්‍ය සඃ| පදේෂූච්චේෂු ලෝකාංස්තු ක්‍ෂුද්‍රාන් සංස්ථාපයත්‍යපි| ");
INSERT INTO sansin_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ක්‍ෂුධිතාන් මානවාන් ද්‍රව්‍යෛරුත්තමෛඃ පරිතර්ප්‍ය සඃ| සකලාන් ධනිනෝ ලෝකාන් විසෘජේද් රික්තහස්තකාන්| ");
INSERT INTO sansin_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ඉබ්‍රාහීමි ච තද්වංශේ යා දයාස්ති සදෛව තාං| ස්මෘත්වා පුරා පිතෘණාං නෝ යථා සාක්‍ෂාත් ප්‍රතිශ්‍රුතං| ");
INSERT INTO sansin_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ඉස්‍රායේල්සේවකස්තේන තථෝපක්‍රියතේ ස්වයං|| ");
INSERT INTO sansin_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","අනන්තරං මරියම් ප්‍රායේණ මාසත්‍රයම් ඉලීශේවයා සහෝෂිත්වා ව්‍යාඝුය්‍ය නිජනිවේශනං යයෞ| ");
INSERT INTO sansin_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","තදනන්තරම් ඉලීශේවායාඃ ප්‍රසවකාල උපස්ථිතේ සති සා පුත්‍රං ප්‍රාසෝෂ්ට| ");
INSERT INTO sansin_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","තතඃ පරමේශ්වරස්තස්‍යාං මහානුග්‍රහං කෘතවාන් ඒතත් ශ්‍රුත්වා සමීපවාසිනඃ කුටුම්බාශ්චාගත්‍ය තයා සහ මුමුදිරේ| ");
INSERT INTO sansin_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","තථාෂ්ටමේ දිනේ තේ බාලකස්‍ය ත්වචං ඡේත්තුම් ඒත්‍ය තස්‍ය පිතෘනාමානුරූපං තන්නාම සිඛරිය ඉති කර්ත්තුමීෂුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","කින්තු තස්‍ය මාතාකථයත් තන්න, නාමාස්‍ය යෝහන් ඉති කර්ත්තව්‍යම්| ");
INSERT INTO sansin_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","තදා තේ ව්‍යාහරන් තව වංශමධ්‍යේ නාමේදෘශං කස්‍යාපි නාස්ති| ");
INSERT INTO sansin_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","තතඃ පරං තස්‍ය පිතරං සිඛරියං ප්‍රති සඞ්කේත්‍ය පප්‍රච්ඡුඃ ශිශෝඃ කිං නාම කාරිෂ්‍යතේ? ");
INSERT INTO sansin_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","තතඃ ස ඵලකමේකං යාචිත්වා ලිලේඛ තස්‍ය නාම යෝහන් භවිෂ්‍යති| තස්මාත් සර්ව්වේ ආශ්චර‍්‍ය්‍යං මේනිරේ| ");
INSERT INTO sansin_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","තත්ක්‍ෂණං සිඛරියස්‍ය ජිහ්වාජාඩ්‍යේ(අ)පගතේ ස මුඛං ව්‍යාදාය ස්පෂ්ටවර්ණමුච්චාර‍්‍ය්‍ය ඊශ්වරස්‍ය ගුණානුවාදං චකාර| ");
INSERT INTO sansin_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","තස්මාච්චතුර්දික්ස්ථාඃ සමීපවාසිලෝකා භීතා ඒවමේතාඃ සර්ව්වාඃ කථා යිහූදායාඃ පර්ව්වතමයප්‍රදේශස්‍ය සර්ව්වත්‍ර ප්‍රචාරිතාඃ| ");
INSERT INTO sansin_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","තස්මාත් ශ්‍රෝතාරෝ මනඃසු ස්ථාපයිත්වා කථයාම්බභූවුඃ කීදෘශෝයං බාලෝ භවිෂ්‍යති? අථ පරමේශ්වරස්තස්‍ය සහායෝභූත්| ");
INSERT INTO sansin_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","තදා යෝහනඃ පිතා සිඛරියඃ පවිත්‍රේණාත්මනා පරිපූර්ණඃ සන් ඒතාදෘශං භවිෂ්‍යද්වාක්‍යං කථයාමාස| ");
INSERT INTO sansin_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","ඉස්‍රායේලඃ ප්‍රභු ර‍්‍යස්තු ස ධන්‍යඃ පරමේශ්වරඃ| අනුගෘහ්‍ය නිජාල්ලෝකාන් ස ඒව පරිමෝචයේත්| ");
INSERT INTO sansin_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","විපක්‍ෂජනහස්තේභ්‍යෝ යථා මෝච්‍යාමහේ වයං| යාවජ්ජීවඤ්ච ධර්ම්මේණ සාරල්‍යේන ච නිර්භයාඃ| ");
INSERT INTO sansin_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","සේවාමහෛ තමේවෛකම් ඒතත්කාරණමේව ච| ස්වකීයං සුපවිත්‍රඤ්ච සංස්මෘත්‍ය නියමං සදා| ");
INSERT INTO sansin_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","කෘපයා පුරුෂාන් පූර්ව්වාන් නිකෂාර්ථාත්තු නඃ පිතුඃ| ඉබ්‍රාහීමඃ සමීපේ යං ශපථං කෘතවාන් පුරා| ");
INSERT INTO sansin_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","තමේව සඵලං කර්ත්තං තථා ශත්‍රුගණස්‍ය ච| ඍृතීයාකාරිණශ්චෛව කරේභ්‍යෝ රක්‍ෂණාය නඃ| ");
INSERT INTO sansin_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","සෘෂ්ටේඃ ප්‍රථමතඃ ස්වීයෛඃ පවිත්‍රෛ ර්භාවිවාදිභිඃ| ");
INSERT INTO sansin_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","යථෝක්තවාන් තථා ස්වස්‍ය දායූදඃ සේවකස්‍ය තු| ");
INSERT INTO sansin_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","වංශේ ත්‍රාතාරමේකං ස සමුත්පාදිතවාන් ස්වයම්| ");
INSERT INTO sansin_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","අතෝ හේ බාලක ත්වන්තු සර්ව්වේභ්‍යඃ ශ්‍රේෂ්ඨ ඒව යඃ| තස්‍යෛව භාවිවාදීති ප්‍රවිඛ්‍යාතෝ භවිෂ්‍යසි| අස්මාකං චරණාන් ක්‍ෂේමේ මාර්ගේ චාලයිතුං සදා| ඒවං ධ්වාන්තේ(අ)ර්ථතෝ මෘත්‍යෝශ්ඡායායාං යේ තු මානවාඃ| ");
INSERT INTO sansin_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","උපවිෂ්ටාස්තු තානේව ප්‍රකාශයිතුමේව හි| කෘත්වා මහානුකම්පාං හි යාමේව පරමේශ්වරඃ| ");
INSERT INTO sansin_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ඌර්ද්ව්වාත් සූර‍්‍ය්‍යමුදාය්‍යෛවාස්මභ්‍යං ප්‍රාදාත්තු දර්ශනං| තයානුකම්පයා ස්වස්‍ය ලෝකානාං පාපමෝචනේ| ");
INSERT INTO sansin_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","පරිත්‍රාණස්‍ය තේභ්‍යෝ හි ඥානවිශ්‍රාණනාය ච| ප්‍රභෝ ර්මාර්ගං පරිෂ්කර්ත්තුං තස්‍යාග්‍රායී භවිෂ්‍යසි|| ");
INSERT INTO sansin_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","අථ බාලකඃ ශරීරේණ බුද්ධ්‍යා ච වර්ද්ධිතුමාරේභේ; අපරඤ්ච ස ඉස්‍රායේලෝ වංශීයලෝකානාං සමීපේ යාවන්න ප්‍රකටීභූතස්තාස්තාවත් ප්‍රාන්තරේ න්‍යවසත්| ");
INSERT INTO sansin_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","අපරඤ්ච තස්මින් කාලේ රාජ්‍යස්‍ය සර්ව්වේෂාං ලෝකානාං නාමානි ලේඛයිතුම් අගස්තකෛසර ආඥාපයාමාස| ");
INSERT INTO sansin_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","තදනුසාරේණ කුරීණියනාමනි සුරියාදේශස්‍ය ශාසකේ සති නාමලේඛනං ප්‍රාරේභේ| ");
INSERT INTO sansin_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","අතෝ හේතෝ ර්නාම ලේඛිතුං සර්ව්වේ ජනාඃ ස්වීයං ස්වීයං නගරං ජග්මුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","තදානීං යූෂඵ් නාම ලේඛිතුං වාග්දත්තයා ස්වභාර‍්‍ය්‍යයා ගර්බ්භවත්‍යා මරියමා සහ ස්වයං දායූදඃ සජාතිවංශ ඉති කාරණාද් ගාලීල්ප්‍රදේශස්‍ය නාසරත්නගරාද් ");
INSERT INTO sansin_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","යිහූදාප්‍රදේශස්‍ය බෛත්ලේහමාඛ්‍යං දායූද්නගරං ජගාම| ");
INSERT INTO sansin_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","අන්‍යච්ච තත්‍ර ස්ථානේ තයෝස්තිෂ්ඨතෝඃ සතෝ ර්මරියමඃ ප්‍රසූතිකාල උපස්ථිතේ ");
INSERT INTO sansin_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","සා තං ප්‍රථමසුතං ප්‍රාසෝෂ්ට කින්තු තස්මින් වාසගෘහේ ස්ථානාභාවාද් බාලකං වස්ත්‍රේණ වේෂ්ටයිත්වා ගෝශාලායාං ස්ථාපයාමාස| ");
INSERT INTO sansin_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","අනන්තරං යේ කියන්තෝ මේෂපාලකාඃ ස්වමේෂව්‍රජරක්‍ෂායෛ තත්ප්‍රදේශේ ස්ථිත්වා රජන්‍යාං ප්‍රාන්තරේ ප්‍රහරිණඃ කර්ම්ම කුර්ව්වන්ති, ");
INSERT INTO sansin_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","තේෂාං සමීපං පරමේශ්වරස්‍ය දූත ආගත්‍යෝපතස්ථෞ; තදා චතුෂ්පාර්ශ්වේ පරමේශ්වරස්‍ය තේජසඃ ප්‍රකාශිතත්වාත් තේ(අ)තිශශඞ්කිරේ| ");
INSERT INTO sansin_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","තදා ස දූත උවාච මා භෛෂ්ට පශ්‍යතාද්‍ය දායූදඃ පුරේ යුෂ්මන්නිමිත්තං ත්‍රාතා ප්‍රභුඃ ඛ්‍රීෂ්ටෝ(අ)ජනිෂ්ට, ");
INSERT INTO sansin_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","සර්ව්වේෂාං ලෝකානාං මහානන්දජනකම් ඉමං මඞ්ගලවෘත්තාන්තං යුෂ්මාන් ඥාපයාමි| ");
INSERT INTO sansin_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","යූයං (තත්ස්ථානං ගත්වා) වස්ත්‍රවේෂ්ටිතං තං බාලකං ගෝශාලායාං ශයනං ද්‍රක්‍ෂ්‍යථ යුෂ්මාන් ප්‍රතීදං චිහ්නං භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","දූත ඉමාං කථාං කථිතවති තත්‍රාකස්මාත් ස්වර්ගීයාඃ පෘතනා ආගත්‍ය කථාම් ඉමාං කථයිත්වේශ්වරස්‍ය ගුණානන්වවාදිෂුඃ, යථා, ");
INSERT INTO sansin_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","සර්ව්වෝර්ද්ව්වස්ථෛරීශ්වරස්‍ය මහිමා සම්ප්‍රකාශ්‍යතාං| ශාන්තිර්භූයාත් පෘථිව්‍යාස්තු සන්තෝෂශ්ච නරාන් ප්‍රති|| ");
INSERT INTO sansin_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","තතඃ පරං තේෂාං සන්නිධේ ර්දූතගණේ ස්වර්ගං ගතේ මේෂපාලකාඃ පරස්පරම් අවේචන් ආගච්ඡත ප්‍රභුඃ පරමේශ්වරෝ යාං ඝටනාං ඥාපිතවාන් තස්‍යා යාථර‍්‍යං ඥාතුං වයමධුනා බෛත්ලේහම්පුරං යාමඃ| ");
INSERT INTO sansin_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","පශ්චාත් තේ තූර්ණං ව්‍රජිත්වා මරියමං යූෂඵං ගෝශාලායාං ශයනං බාලකඤ්ච දදෘශුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ඉත්ථං දෘෂ්ට්වා බාලකස්‍යාර්ථේ ප්‍රෝක්තාං සර්ව්වකථාං තේ ප්‍රාචාරයාඤ්චක්‍රුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","තතෝ යේ ලෝකා මේෂරක්‍ෂකාණාං වදනේභ්‍යස්තාං වාර්ත්තාං ශුශ්‍රුවුස්තේ මහාශ්චර‍්‍ය්‍යං මේනිරේ| ");
INSERT INTO sansin_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","කින්තු මරියම් ඒතත්සර්ව්වඝටනානාං තාත්පර‍්‍ය්‍යං විවිච්‍ය මනසි ස්ථාපයාමාස| ");
INSERT INTO sansin_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","තත්පශ්චාද් දූතවිඥප්තානුරූපං ශ්‍රුත්වා දෘෂ්ට්වා ච මේෂපාලකා ඊශ්වරස්‍ය ගුණානුවාදං ධන්‍යවාදඤ්ච කුර්ව්වාණාඃ පරාවෘත්‍ය යයුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","අථ බාලකස්‍ය ත්වක්ඡේදනකාලේ(අ)ෂ්ටමදිවසේ සමුපස්ථිතේ තස්‍ය ගර්බ්භස්ථිතේඃ පුර්ව්වං ස්වර්ගීයදූතෝ යථාඥාපයත් තදනුරූපං තේ තන්නාමධේයං යීශුරිති චක්‍රිරේ| ");
INSERT INTO sansin_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","තතඃ පරං මූසාලිඛිතව්‍යවස්ථායා අනුසාරේණ මරියමඃ ශුචිත්වකාල උපස්ථිතේ, ");
INSERT INTO sansin_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","\"ප්‍රථමජඃ සර්ව්වඃ පුරුෂසන්තානඃ පරමේශ්වරේ සමර්ප්‍යතාං,\" ඉති පරමේශ්වරස්‍ය ව්‍යවස්ථයා ");
INSERT INTO sansin_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","යීශුං පරමේශ්වරේ සමර්පයිතුම් ශාස්ත්‍රීයවිධ්‍යුක්තං කපෝතද්වයං පාරාවතශාවකද්වයං වා බලිං දාතුං තේ තං ගෘහීත්වා යිරූශාලමම් ආයයුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","යිරූශාලම්පුරනිවාසී ශිමියෝන්නාමා ධාර්ම්මික ඒක ආසීත් ස ඉස්‍රායේලඃ සාන්ත්වනාමපේක්‍ෂ්‍ය තස්ථෞ කිඤ්ච පවිත්‍ර ආත්මා තස්මින්නාවිර්භූතඃ| ");
INSERT INTO sansin_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","අපරං ප්‍රභුණා පරමේශ්වරේණාභිෂික්තේ ත්‍රාතරි ත්වයා න දෘෂ්ටේ ත්වං න මරිෂ්‍යසීති වාක්‍යං පවිත්‍රේණ ආත්මනා තස්ම ප්‍රාකථ්‍යත| ");
INSERT INTO sansin_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","අපරඤ්ච යදා යීශෝඃ පිතා මාතා ච තදර්ථං ව්‍යවස්ථානුරූපං කර්ම්ම කර්ත්තුං තං මන්දිරම් ආනින්‍යතුස්තදා ");
INSERT INTO sansin_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ශිමියෝන් ආත්මන ආකර්ෂණේන මන්දිරමාගත්‍ය තං ක්‍රෝඩේ නිධාය ඊශ්වරස්‍ය ධන්‍යවාදං කෘත්වා කථයාමාස, යථා, ");
INSERT INTO sansin_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","හේ ප්‍රභෝ තව දාසෝයං නිජවාක්‍යානුසාරතඃ| ඉදානීන්තු සකල්‍යාණෝ භවතා සංවිසෘජ්‍යතාම්| ");
INSERT INTO sansin_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","යතඃ සකලදේශස්‍ය දීප්තයේ දීප්තිරූපකං| ");
INSERT INTO sansin_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ඉස්‍රායේලීයලෝකස්‍ය මහාගෞරවරූපකං| ");
INSERT INTO sansin_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","යං ත්‍රායකං ජනානාන්තු සම්මුඛේ ත්වමජීජනඃ| සඒව විද්‍යතේ(අ)ස්මාකං ධ්‍රවං නයනනගෝචරේ|| ");
INSERT INTO sansin_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","තදානීං තේනෝක්තා ඒතාඃ සකලාඃ කථාඃ ශ්‍රුත්වා තස්‍ය මාතා යූෂඵ් ච විස්මයං මේනාතේ| ");
INSERT INTO sansin_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","තතඃ පරං ශිමියෝන් තේභ්‍ය ආශිෂං දත්ත්වා තන්මාතරං මරියමම් උවාච, පශ්‍ය ඉස්‍රායේලෝ වංශමධ්‍යේ බහූනාං පාතනායෝත්ථාපනාය ච තථා විරෝධපාත්‍රං භවිතුං, බහූනාං ගුප්තමනෝගතානාං ප්‍රකටීකරණාය බාලකෝයං නියුක්තෝස්ති| ");
INSERT INTO sansin_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","තස්මාත් තවාපි ප්‍රාණාඃ ශූලේන ව්‍යත්ස්‍යන්තේ| ");
INSERT INTO sansin_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","අපරඤ්ච ආශේරස්‍ය වංශීයඵිනූයේලෝ දුහිතා හන්නාඛ්‍යා අතිජරතී භවිෂ්‍යද්වාදින්‍යේකා යා විවාහාත් පරං සප්ත වත්සරාන් පත්‍යා සහ න්‍යවසත් තතෝ විධවා භූත්වා චතුරශීතිවර්ෂවයඃපර‍්‍ය්‍යනතං ");
INSERT INTO sansin_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","මන්දිරේ ස්ථිත්වා ප්‍රාර්ථනෝපවාසෛර්දිවානිශම් ඊශ්වරම් අසේවත සාපි ස්ත්‍රී තස්මින් සමයේ මන්දිරමාගත්‍ය ");
INSERT INTO sansin_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","පරමේශ්වරස්‍ය ධන්‍යවාදං චකාර, යිරූශාලම්පුරවාසිනෝ යාවන්තෝ ලෝකා මුක්තිමපේක්‍ෂ්‍ය ස්ථිතාස්තාන් යීශෝර්වෘත්තාන්තං ඥාපයාමාස| ");
INSERT INTO sansin_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ඉත්ථං පරමේශ්වරස්‍ය ව්‍යවස්ථානුසාරේණ සර්ව්වේෂු කර්ම්මසු කෘතේෂු තෞ පුනශ්ච ගාලීලෝ නාසරත්නාමකං නිජනගරං ප්‍රතස්ථාතේ| ");
INSERT INTO sansin_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","තත්පශ්චාද් බාලකඃ ශරීරේණ වෘද්ධිමේත්‍ය ඥානේන පරිපූර්ණ ආත්මනා ශක්තිමාංශ්ච භවිතුමාරේභේ තථා තස්මින් ඊශ්වරානුග්‍රහෝ බභූව| ");
INSERT INTO sansin_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","තස්‍ය පිතා මාතා ච ප්‍රතිවර්ෂං නිස්තාරෝත්සවසමයේ යිරූශාලමම් අගච්ඡතාම්| ");
INSERT INTO sansin_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","අපරඤ්ච යීශෞ ද්වාදශවර්ෂවයස්කේ සති තෞ පර්ව්වසමයස්‍ය රීත්‍යනුසාරේණ යිරූශාලමං ගත්වා ");
INSERT INTO sansin_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","පාර්ව්වණං සම්පාද්‍ය පුනරපි ව්‍යාඝුය්‍ය යාතඃ කින්තු යීශුර්බාලකෝ යිරූශාලමි තිෂ්ඨති| යූෂඵ් තන්මාතා ච තද් අවිදිත්වා ");
INSERT INTO sansin_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ස සඞ්ගිභිඃ සහ විද්‍යත ඒතච්ච බුද්ව්වා දිනෛකගම්‍යමාර්ගං ජග්මතුඃ| කින්තු ශේෂේ ඥාතිබන්ධූනාං සමීපේ මෘගයිත්වා තදුද්දේेශමප්‍රාප්‍ය ");
INSERT INTO sansin_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","තෞ පුනරපි යිරූශාලමම් පරාවෘත්‍යාගත්‍ය තං මෘගයාඤ්චක්‍රතුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","අථ දිනත්‍රයාත් පරං පණ්ඩිතානාං මධ්‍යේ තේෂාං කථාඃ ශෘණ්වන් තත්ත්වං පෘච්ඡංශ්ච මන්දිරේ සමුපවිෂ්ටඃ ස තාභ්‍යාං දෘෂ්ටඃ| ");
INSERT INTO sansin_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","තදා තස්‍ය බුද්ධ්‍යා ප්‍රත්‍යුත්තරෛශ්ච සර්ව්වේ ශ්‍රෝතාරෝ විස්මයමාපද්‍යන්තේ| ");
INSERT INTO sansin_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","තාදෘශං දෘෂ්ට්වා තස්‍ය ජනකෝ ජනනී ච චමච්චක්‍රතුඃ කිඤ්ච තස්‍ය මාතා තමවදත්, හේ පුත්‍ර, කථමාවාං ප්‍රතීත්ථං සමාචරස්ත්වම්? පශ්‍ය තව පිතාහඤ්ච ශෝකාකුලෞ සන්තෞ ත්වාමන්විච්ඡාවඃ ස්ම| ");
INSERT INTO sansin_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","තතඃ සෝවදත් කුතෝ මාම් අන්වෛච්ඡතං? පිතුර්ගෘහේ මයා ස්ථාතව්‍යම් ඒතත් කිං යුවාභ්‍යාං න ඥායතේ? ");
INSERT INTO sansin_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","කින්තු තෞ තස්‍යෛතද්වාක්‍යස්‍ය තාත්පර‍්‍ය්‍යං බෝද්ධුං නාශක්නුතාං| ");
INSERT INTO sansin_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","තතඃ පරං ස තාභ්‍යාං සහ නාසරතං ගත්වා තයෝර්වශීභූතස්තස්ථෞ කින්තු සර්ව්වා ඒතාඃ කථාස්තස්‍ය මාතා මනසි ස්ථාපයාමාස| ");
INSERT INTO sansin_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","අථ යීශෝ ර්බුද්ධිඃ ශරීරඤ්ච තථා තස්මින් ඊශ්වරස්‍ය මානවානාඤ්චානුග්‍රහෝ වර්ද්ධිතුම් ආරේභේ| ");
INSERT INTO sansin_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","අනන්තරං තිබිරියකෛසරස්‍ය රාජත්වස්‍ය පඤ්චදශේ වත්සරේ සති යදා පන්තීයපීලාතෝ යිහූදාදේශාධිපති ර්හේරෝද් තු ගාලීල්ප්‍රදේශස්‍ය රාජා ඵිලිපනාමා තස්‍ය භ්‍රාතා තු යිතූරියායාස්ත්‍රාඛෝනීතියාප්‍රදේශස්‍ය ච රාජාසීත් ලුෂානීයනාමා අවිලීනීදේශස්‍ය රාජාසීත් ");
INSERT INTO sansin_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","හානන් කියඵාශ්චේමෞ ප්‍රධානයාජාකාවාස්තාං තදානීං සිඛරියස්‍ය පුත්‍රාය යෝහනේ මධ්‍යේප්‍රාන්තරම් ඊශ්වරස්‍ය වාක්‍යේ ප්‍රකාශිතේ සති ");
INSERT INTO sansin_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ස යර්ද්දන උභයතටප්‍රදේශාන් සමේත්‍ය පාපමෝචනාර්ථං මනඃපරාවර්ත්තනස්‍ය චිහ්නරූපං යන්මජ්ජනං තදීයාඃ කථාඃ සර්ව්වත්‍ර ප්‍රචාරයිතුමාරේභේ| ");
INSERT INTO sansin_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","යිශයියභවිෂ්‍යද්වක්තෘග්‍රන්ථේ යාදෘශී ලිපිරාස්තේ යථා, පරමේශස්‍ය පන්ථානං පරිෂ්කුරුත සර්ව්වතඃ| තස්‍ය රාජපථඤ්චෛව සමානං කුරුතාධුනා| ");
INSERT INTO sansin_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","කාරිෂ්‍යන්තේ සමුච්ඡ්‍රායාඃ සකලා නිම්නභූමයඃ| කාරිෂ්‍යන්තේ නතාඃ සර්ව්වේ පර්ව්වතාශ්චෝපපර්ව්වතාඃ| කාරිෂ්‍යන්තේ ච යා වක්‍රාස්තාඃ සර්ව්වාඃ සරලා භුවඃ| කාරිෂ්‍යන්තේ සමානාස්තා යා උච්චනීචභූමයඃ| ");
INSERT INTO sansin_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ඊශ්වරේණ කෘතං ත්‍රාණං ද්‍රක්‍ෂ්‍යන්ති සර්ව්වමානවාඃ| ඉත්‍යේතත් ප්‍රාන්තරේ වාක්‍යං වදතඃ කස්‍යචිද් රවඃ|| ");
INSERT INTO sansin_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","යේ යේ ලෝකා මජ්ජනාර්ථං බහිරායයුස්තාන් සෝවදත් රේ රේ සර්පවංශා ආගාමිනඃ කෝපාත් පලායිතුං යුෂ්මාන් කශ්චේතයාමාස? ");
INSERT INTO sansin_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","තස්මාද් ඉබ්‍රාහීම් අස්මාකං පිතා කථාමීදෘශීං මනෝභි ර්න කථයිත්වා යූයං මනඃපරිවර්ත්තනයෝග්‍යං ඵලං ඵලත; යුෂ්මානහං යථාර්ථං වදාමි පාෂාණේභ්‍ය ඒතේභ්‍ය ඊශ්වර ඉබ්‍රාහීමඃ සන්තානෝත්පාදනේ සමර්ථඃ| ");
INSERT INTO sansin_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","අපරඤ්ච තරුමූලේ(අ)ධුනාපි පරශුඃ සංලග්නෝස්ති යස්තරුරුත්තමං ඵලං න ඵලති ස ඡිද්‍යතේ(අ)ග්නෞ නික්‍ෂිප්‍යතේ ච| ");
INSERT INTO sansin_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","තදානීං ලෝකාස්තං පප්‍රච්ඡුස්තර්හි කිං කර්ත්තව්‍යමස්මාභිඃ? ");
INSERT INTO sansin_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","තතඃ සෝවාදීත් යස්‍ය ද්වේ වසනේ විද්‍යේතේ ස වස්ත්‍රහීනායෛකං විතරතු කිංඤ්ච යස්‍ය ඛාද්‍යද්‍රව්‍යං විද්‍යතේ සෝපි තථෛව කරෝතු| ");
INSERT INTO sansin_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","තතඃ පරං කරසඤ්චායිනෝ මජ්ජනාර්ථම් ආගත්‍ය පප්‍රච්ඡුඃ හේ ගුරෝ කිං කර්ත්තව්‍යමස්මාභිඃ? ");
INSERT INTO sansin_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","තතඃ සෝකථයත් නිරූපිතාදධිකං න ගෘහ්ලිත| ");
INSERT INTO sansin_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","අනන්තරං සේනාගණ ඒත්‍ය පප්‍රච්ඡ කිමස්මාභි ර්වා කර්ත්තව්‍යම්? තතඃ සෝභිදධේ කස්‍ය කාමපි හානිං මා කාර්ෂ්ට තථා මෘෂාපවාදං මා කුරුත නිජවේතනේන ච සන්තුෂ්‍ය තිෂ්ඨත| ");
INSERT INTO sansin_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","අපරඤ්ච ලෝකා අපේක්‍ෂයා ස්ථිත්වා සර්ව්වේපීති මනෝභි ර්විතර්කයාඤ්චක්‍රුඃ, යෝහනයම් අභිෂික්තස්ත්‍රාතා න වේති? ");
INSERT INTO sansin_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","තදා යෝහන් සර්ව්වාන් ව්‍යාජහාර, ජලේ(අ)හං යුෂ්මාන් මජ්ජයාමි සත්‍යං කින්තු යස්‍ය පාදුකාබන්ධනං මෝචයිතුමපි න යෝග්‍යෝස්මි තාදෘශ ඒකෝ මත්තෝ ගුරුතරඃ පුමාන් ඒති, ස යුෂ්මාන් වහ්නිරූපේ පවිත්‍ර ආත්මනි මජ්ජයිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","අපරඤ්ච තස්‍ය හස්තේ ශූර්ප ආස්තේ ස ස්වශස්‍යානි ශුද්ධරූපං ප්‍රස්ඵෝට්‍ය ගෝධූමාන් සර්ව්වාන් භාණ්ඩාගාරේ සංග්‍රහීෂ්‍යති කින්තු බූෂාණි සර්ව්වාණ්‍යනිර්ව්වාණවහ්නිනා දාහයිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","යෝහන් උපදේශේනේත්ථං නානාකථා ලෝකානාං සමක්‍ෂං ප්‍රචාරයාමාස| ");
INSERT INTO sansin_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","අපරඤ්ච හේරෝද් රාජා ඵිලිප්නාම්නඃ සහෝදරස්‍ය භාර‍්‍ය්‍යාං හේරෝදියාමධි තථාන්‍යානි යානි යානි කුකර්ම්මාණි කෘතවාන් තදධි ච ");
INSERT INTO sansin_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","යෝහනා තිරස්කෘතෝ භූත්වා කාරාගාරේ තස්‍ය බන්ධනාද් අපරමපි කුකර්ම්ම චකාර| ");
INSERT INTO sansin_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ඉතඃ පූර්ව්වං යස්මින් සමයේ සර්ව්වේ යෝහනා මජ්ජිතාස්තදානීං යීශුරප්‍යාගත්‍ය මජ්ජිතඃ| ");
INSERT INTO sansin_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","තදනන්තරං තේන ප්‍රාර්ථිතේ මේඝද්වාරං මුක්තං තස්මාච්ච පවිත්‍ර ආත්මා මූර්ත්තිමාන් භූත්වා කපෝතවත් තදුපර‍්‍ය්‍යවරුරෝහ; තදා ත්වං මම ප්‍රියඃ පුත්‍රස්ත්වයි මම පරමඃ සන්තෝෂ ඉත්‍යාකාශවාණී බභූව| ");
INSERT INTO sansin_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","තදානීං යීශුඃ ප්‍රායේණ ත්‍රිංශද්වර්ෂවයස්ක ආසීත්| ලෞකිකඥානේ තු ස යූෂඵඃ පුත්‍රඃ, ");
INSERT INTO sansin_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","යූෂඵ් ඒලේඃ පුත්‍රඃ, ඒලිර්මත්තතඃ පුත්‍රඃ, මත්තත් ලේවේඃ පුත්‍රඃ, ලේවි ර්මල්කේඃ පුත්‍රඃ, මල්කිර‍්‍යාන්නස්‍ය පුත්‍රඃ; යාන්නෝ යූෂඵඃ පුත්‍රඃ| ");
INSERT INTO sansin_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","යූෂඵ් මත්තථියස්‍ය පුත්‍රඃ, මත්තථිය ආමෝසඃ පුත්‍රඃ, ආමෝස් නහූමඃ පුත්‍රඃ, නහූම් ඉෂ්ලේඃ පුත්‍රඃ ඉෂ්ලිර්නගේඃ පුත්‍රඃ| ");
INSERT INTO sansin_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","නගිර්මාටඃ පුත්‍රඃ, මාට් මත්තථියස්‍ය පුත්‍රඃ, මත්තථියඃ ශිමියේඃ පුත්‍රඃ, ශිමියිර‍්‍යූෂඵඃ පුත්‍රඃ, යූෂඵ් යිහූදාඃ පුත්‍රඃ| ");
INSERT INTO sansin_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","යිහූදා යෝහානාඃ පුත්‍රඃ, යෝහානා රීෂාඃ පුත්‍රඃ, රීෂාඃ සිරුබ්බාබිලඃ පුත්‍රඃ, සිරුබ්බාබිල් ශල්තීයේලඃ පුත්‍රඃ, ශල්තීයේල් නේරේඃ පුත්‍රඃ| ");
INSERT INTO sansin_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","නේරිර්මල්කේඃ පුත්‍රඃ, මල්කිඃ අද්‍යඃ පුත්‍රඃ, අද්දී කෝෂමඃ පුත්‍රඃ, කෝෂම් ඉල්මෝදදඃ පුත්‍රඃ, ඉල්මෝදද් ඒරඃ පුත්‍රඃ| ");
INSERT INTO sansin_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ඒර් යෝශේඃ පුත්‍රඃ, යෝශිඃ ඉලීයේෂරඃ පුත්‍රඃ, ඉලීයේෂර් යෝරීමඃ පුත්‍රඃ, යෝරීම් මත්තතඃ පුත්‍රඃ, මත්තත ලේවේඃ පුත්‍රඃ| ");
INSERT INTO sansin_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ලේවිඃ ශිමියෝනඃ පුත්‍රඃ, ශිමියෝන් යිහූදාඃ පුත්‍රඃ, යිහූදා යූෂුඵඃ පුත්‍රඃ, යූෂුඵ් යෝනනඃ පුත්‍රඃ, යානන් ඉලීයාකීමඃ පුත්‍රඃ| ");
INSERT INTO sansin_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ඉලියාකීම්ඃ මිලේයාඃ පුත්‍රඃ, මිලේයා මෛනනඃ පුත්‍රඃ, මෛනන් මත්තත්තස්‍ය පුත්‍රඃ, මත්තත්තෝ නාථනඃ පුත්‍රඃ, නාථන් දායූදඃ පුත්‍රඃ| ");
INSERT INTO sansin_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","දායූද් යිශයඃ පුත්‍රඃ, යිශය ඕබේදඃ පුත්‍ර, ඕබේද් බෝයසඃ පුත්‍රඃ, බෝයස් සල්මෝනඃ පුත්‍රඃ, සල්මෝන් නහශෝනඃ පුත්‍රඃ| ");
INSERT INTO sansin_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","නහශෝන් අම්මීනාදබඃ පුත්‍රඃ, අම්මීනාදබ් අරාමඃ පුත්‍රඃ, අරාම් හිෂ්‍රෝණඃ පුත්‍රඃ, හිෂ්‍රෝණ් පේරසඃ පුත්‍රඃ, පේරස් යිහූදාඃ පුත්‍රඃ| ");
INSERT INTO sansin_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","යිහූදා යාකූබඃ පුත්‍රඃ, යාකූබ් ඉස්හාකඃ පුත්‍රඃ, ඉස්හාක් ඉබ්‍රාහීමඃ පුත්‍රඃ, ඉබ්‍රාහීම් තේරහඃ පුත්‍රඃ, තේරහ් නාහෝරඃ පුත්‍රඃ| ");
INSERT INTO sansin_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","නාහෝර් සිරුගඃ පුත්‍රඃ, සිරුග් රිය්වඃ පුත්‍රඃ, රියූඃ පේලගඃ පුත්‍රඃ, පේලග් ඒවරඃ පුත්‍රඃ, ඒවර් ශේලහඃ පුත්‍රඃ| ");
INSERT INTO sansin_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ශේලහ් කෛනනඃ පුත්‍රඃ, කෛනන් අර්ඵක්‍ෂදඃ පුත්‍රඃ, අර්ඵක්‍ෂද් ශාමඃ පුත්‍රඃ, ශාම් නෝහඃ පුත්‍රඃ, නෝහෝ ලේමකඃ පුත්‍රඃ| ");
INSERT INTO sansin_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ලේමක් මිථූශේලහඃ පුත්‍රඃ, මිථූශේලහ් හනෝකඃ පුත්‍රඃ, හනෝක් යේරදඃ පුත්‍රඃ, යේරද් මහලලේලඃ පුත්‍රඃ, මහලලේල් කෛනනඃ පුත්‍රඃ| ");
INSERT INTO sansin_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","කෛනන් ඉනෝශඃ පුත්‍රඃ, ඉනෝශ් ශේතඃ පුත්‍රඃ, ශේත් ආදමඃ පුත්‍ර, ආදම් ඊශ්වරස්‍ය පුත්‍රඃ| ");
INSERT INTO sansin_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","තතඃ පරං යීශුඃ පවිත්‍රේණාත්මනා පූර්ණඃ සන් යර්ද්දනනද්‍යාඃ පරාවෘත්‍යාත්මනා ප්‍රාන්තරං නීතඃ සන් චත්වාරිංශද්දිනානි යාවත් ශෛතානා පරීක්‍ෂිතෝ(අ)භූත්, ");
INSERT INTO sansin_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","කිඤ්ච තානි සර්ව්වදිනානි භෝජනං විනා ස්ථිතත්වාත් කාලේ පූර්ණේ ස ක්‍ෂුධිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","තතඃ ශෛතානාගත්‍ය තමවදත් ත්වං චේදීශ්වරස්‍ය පුත්‍රස්තර්හි ප්‍රස්තරානේතාන් ආඥයා පූපාන් කුරු| ");
INSERT INTO sansin_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","තදා යීශුරුවාච, ලිපිරීදෘශී විද්‍යතේ මනුජඃ කේවලේන පූපේන න ජීවති කින්ත්වීශ්වරස්‍ය සර්ව්වාභිරාඥාභි ර්ජීවති| ");
INSERT INTO sansin_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","තදා ශෛතාන් තමුච්චං පර්ව්වතං නීත්වා නිමිෂෛකමධ්‍යේ ජගතඃ සර්ව්වරාජ්‍යානි දර්ශිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","පශ්චාත් තමවාදීත් සර්ව්වම් ඒතද් විභවං ප්‍රතාපඤ්ච තුභ්‍යං දාස්‍යාමි තන් මයි සමර්පිතමාස්තේ යං ප්‍රති මමේච්ඡා ජායතේ තස්මෛ දාතුං ශක්නෝමි, ");
INSERT INTO sansin_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ත්වං චේන්මාං භජසේ තර්හි සර්ව්වමේතත් තවෛව භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","තදා යීශුස්තං ප්‍රත්‍යුක්තවාන් දූරී භව ශෛතාන් ලිපිරාස්තේ, නිජං ප්‍රභුං පරමේශ්වරං භජස්ව කේවලං තමේව සේවස්ව ච| ");
INSERT INTO sansin_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","අථ ශෛතාන් තං යිරූශාලමං නීත්වා මන්දිරස්‍ය චූඩායා උපරි සමුපවේශ්‍ය ජගාද ත්වං චේදීශ්වරස්‍ය පුත්‍රස්තර්හි ස්ථානාදිතෝ ලම්ඵිත්වාධඃ ");
INSERT INTO sansin_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","පත යතෝ ලිපිරාස්තේ, ආඥාපයිෂ්‍යති ස්වීයාන් දූතාන් ස පරමේශ්වරඃ| ");
INSERT INTO sansin_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","රක්‍ෂිතුං සර්ව්වමාර්ගේ ත්වාං තේන ත්වච්චරණේ යථා| න ලගේත් ප්‍රස්තරාඝාතස්ත්වාං ධරිෂ්‍යන්ති තේ තථා| ");
INSERT INTO sansin_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","තදා යීශුනා ප්‍රත්‍යුක්තම් ඉදමප්‍යුක්තමස්ති ත්වං ස්වප්‍රභුං පරේශං මා පරීක්‍ෂස්ව| ");
INSERT INTO sansin_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","පශ්චාත් ශෛතාන් සර්ව්වපරීක්‍ෂාං සමාප්‍ය ක්‍ෂණාත්තං ත්‍යක්ත්වා යයෞ| ");
INSERT INTO sansin_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","තදා යීශුරාත්මප්‍රභාවාත් පුනර්ගාලීල්ප්‍රදේශං ගතස්තදා තත්සුඛ්‍යාතිශ්චතුර්දිශං ව්‍යානශේ| ");
INSERT INTO sansin_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ස තේෂාං භජනගෘහේෂු උපදිශ්‍ය සර්ව්වෛඃ ප්‍රශංසිතෝ බභූව| ");
INSERT INTO sansin_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","අථ ස ස්වපාලනස්ථානං නාසරත්පුරමේත්‍ය විශ්‍රාමවාරේ ස්වාචාරාද් භජනගේහං ප්‍රවිශ්‍ය පඨිතුමුත්තස්ථෞ| ");
INSERT INTO sansin_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","තතෝ යිශයියභවිෂ්‍යද්වාදිනඃ පුස්තකේ තස්‍ය කරදත්තේ සති ස තත් පුස්තකං විස්තාර‍්‍ය්‍ය යත්‍ර වක්‍ෂ්‍යමාණානි වචනානි සන්ති තත් ස්ථානං ප්‍රාප්‍ය පපාඨ| ");
INSERT INTO sansin_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","ආත්මා තු පරමේශස්‍ය මදීයෝපරි විද්‍යතේ| දරිද්‍රේෂු සුසංවාදං වක්තුං මාං සෝභිෂික්තවාන්| භග්නාන්තඃ කරණාල්ලෝකාන් සුස්වස්ථාන් කර්ත්තුමේව ච| බන්දීකෘතේෂු ලෝකේෂු මුක්තේ ර්ඝෝෂයිතුං වචඃ| නේත්‍රාණි දාතුමන්ධේභ්‍යස්ත්‍රාතුං බද්ධජනානපි| ");
INSERT INTO sansin_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","පරේශානුග්‍රහේ කාලං ප්‍රචාරයිතුමේව ච| සර්ව්වෛතත්කරණාර්ථාය මාමේව ප්‍රහිණෝති සඃ|| ");
INSERT INTO sansin_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","තතඃ පුස්තකං බද්ව්වා පරිචාරකස්‍ය හස්තේ සමර්ප්‍ය චාසනේ සමුපවිෂ්ටඃ, තතෝ භජනගෘහේ යාවන්තෝ ලෝකා ආසන් තේ සර්ව්වේ(අ)නන්‍යදෘෂ්ට්‍යා තං විලුලෝකිරේ| ");
INSERT INTO sansin_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","අනන්තරම් අද්‍යෛතානි සර්ව්වාණි ලිඛිතවචනානි යුෂ්මාකං මධ්‍යේ සිද්ධානි ස ඉමාං කථාං තේභ්‍යඃ කථයිතුමාරේභේ| ");
INSERT INTO sansin_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","තතඃ සර්ව්වේ තස්මින් අන්වරජ්‍යන්ත, කිඤ්ච තස්‍ය මුඛාන්නිර්ගතාභිරනුග්‍රහස්‍ය කථාභිශ්චමත්කෘත්‍ය කථයාමාසුඃ කිමයං යූෂඵඃ පුත්‍රෝ න? ");
INSERT INTO sansin_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","තදා සෝ(අ)වාදීද් හේ චිකිත්සක ස්වමේව ස්වස්ථං කුරු කඵර්නාහූමි යද්‍යත් කෘතවාන් තදශ්‍රෞෂ්ම තාඃ සර්වාඃ ක්‍රියා අත්‍ර ස්වදේශේ කුරු කථාමේතාං යූයමේවාවශ්‍යං මාං වදිෂ්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","පුනඃ සෝවාදීද් යුෂ්මානහං යථාර්ථං වදාමි, කෝපි භවිෂ්‍යද්වාදී ස්වදේශේ සත්කාරං න ප්‍රාප්නෝති| ");
INSERT INTO sansin_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","අපරඤ්ච යථාර්ථං වච්මි, ඒලියස්‍ය ජීවනකාලේ යදා සාර්ද්ධත්‍රිතයවර්ෂාණි යාවත් ජලදප්‍රතිබන්ධාත් සර්ව්වස්මින් දේශේ මහාදුර්භික්‍ෂම් අජනිෂ්ට තදානීම් ඉස්‍රායේලෝ දේශස්‍ය මධ්‍යේ බහ්ව්‍යෝ විධවා ආසන්, ");
INSERT INTO sansin_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","කින්තු සීදෝන්ප්‍රදේශීයසාරිඵත්පුරනිවාසිනීම් ඒකාං විධවාං විනා කස්‍යාශ්චිදපි සමීපේ ඒලියඃ ප්‍රේරිතෝ නාභූත්| ");
INSERT INTO sansin_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","අපරඤ්ච ඉලීශායභවිෂ්‍යද්වාදිවිද්‍යමානතාකාලේ ඉස්‍රායේල්දේශේ බහවඃ කුෂ්ඨින ආසන් කින්තු සුරීයදේශීයං නාමාන්කුෂ්ඨිනං විනා කෝප්‍යන්‍යඃ පරිෂ්කෘතෝ නාභූත්| ");
INSERT INTO sansin_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ඉමාං කථාං ශ්‍රුත්වා භජනගේහස්ථිතා ලෝකාඃ සක්‍රෝධම් උත්ථාය ");
INSERT INTO sansin_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","නගරාත්තං බහිෂ්කෘත්‍ය යස්‍ය ශිඛරිණ උපරි තේෂාං නගරං ස්ථාපිතමාස්තේ තස්මාන්නික්‍ෂේප්තුං තස්‍ය ශිඛරං තං නින්‍යුඃ ");
INSERT INTO sansin_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","කින්තු ස තේෂාං මධ්‍යාදපසෘත්‍ය ස්ථානාන්තරං ජගාම| ");
INSERT INTO sansin_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","තතඃ පරං යීශුර්ගාලීල්ප්‍රදේශීයකඵර්නාහූම්නගර උපස්ථාය විශ්‍රාමවාරේ ලෝකානුපදේෂ්ටුම් ආරබ්ධවාන්| ");
INSERT INTO sansin_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","තදුපදේශාත් සර්ව්වේ චමච්චක්‍රු ර‍්‍යතස්තස්‍ය කථා ගුරුතරා ආසන්| ");
INSERT INTO sansin_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","තදානීං තද්භජනගේහස්ථිතෝ(අ)මේධ්‍යභූතග්‍රස්ත ඒකෝ ජන උච්චෛඃ කථයාමාස, ");
INSERT INTO sansin_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","හේ නාසරතීයයීශෝ(අ)ස්මාන් ත්‍යජ, ත්වයා සහාස්මාකං කඃ සම්බන්ධඃ? කිමස්මාන් විනාශයිතුමායාසි? ත්වමීශ්වරස්‍ය පවිත්‍රෝ ජන ඒතදහං ජානාමි| ");
INSERT INTO sansin_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","තදා යීශුස්තං තර්ජයිත්වාවදත් මෞනී භව ඉතෝ බහිර්භව; තතඃ සෝමේධ්‍යභූතස්තං මධ්‍යස්ථානේ පාතයිත්වා කිඤ්චිදප්‍යහිංසිත්වා තස්මාද් බහිර්ගතවාන්| ");
INSERT INTO sansin_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","තතඃ සර්ව්වේ ලෝකාශ්චමත්කෘත්‍ය පරස්පරං වක්තුමාරේභිරේ කෝයං චමත්කාරඃ| ඒෂ ප්‍රභාවේණ පරාක්‍රමේණ චාමේධ්‍යභූතාන් ආඥාපයති තේනෛව තේ බහිර්ගච්ඡන්ති| ");
INSERT INTO sansin_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","අනන්තරං චතුර්දික්ස්ථදේශාන් තස්‍ය සුඛ්‍යාතිර්ව්‍යාප්නෝත්| ");
INSERT INTO sansin_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","තදනන්තරං ස භජනගේහාද් බහිරාගත්‍ය ශිමෝනෝ නිවේශනං ප්‍රවිවේශ තදා තස්‍ය ශ්වශ්‍රූර්ජ්වරේණාත්‍යන්තං පීඩිතාසීත් ශිෂ්‍යාස්තදර්ථං තස්මින් විනයං චක්‍රුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","තතඃ ස තස්‍යාඃ සමීපේ ස්ථිත්වා ජ්වරං තර්ජයාමාස තේනෛව තාං ජ්වරෝ(අ)ත්‍යාක්‍ෂීත් තතඃ සා තත්ක්‍ෂණම් උත්ථාය තාන් සිෂේවේ| ");
INSERT INTO sansin_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","අථ සූර‍්‍ය්‍යාස්තකාලේ ස්වේෂාං යේ යේ ජනා නානාරෝගෛඃ පීඩිතා ආසන් ලෝකාස්තාන් යීශෝඃ සමීපම් ආනින්‍යුඃ, තදා ස ඒකෛකස්‍ය ගාත්‍රේ කරමර්පයිත්වා තානරෝගාන් චකාර| ");
INSERT INTO sansin_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","තතෝ භූතා බහුභ්‍යෝ නිර්ගත්‍ය චීත්ශබ්දං කෘත්වා ච බභාෂිරේ ත්වමීශ්වරස්‍ය පුත්‍රෝ(අ)භිෂික්තත්‍රාතා; කින්තු සෝභිෂික්තත්‍රාතේති තේ විවිදුරේතස්මාත් කාරණාත් තාන් තර්ජයිත්වා තද්වක්තුං නිෂිෂේධ| ");
INSERT INTO sansin_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","අපරඤ්ච ප්‍රභාතේ සති ස විජනස්ථානං ප්‍රතස්ථේ පශ්චාත් ජනාස්තමන්විච්ඡන්තස්තන්නිකටං ගත්වා ස්ථානාන්තරගමනාර්ථං තමන්වරුන්ධන්| ");
INSERT INTO sansin_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","කින්තු ස තාන් ජගාද, ඊශ්වරීයරාජ්‍යස්‍ය සුසංවාදං ප්‍රචාරයිතුම් අන්‍යානි පුරාණ්‍යපි මයා යාතව්‍යානි යතස්තදර්ථමේව ප්‍රේරිතෝහං| ");
INSERT INTO sansin_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","අථ ගාලීලෝ භජනගේහේෂු ස උපදිදේශ| ");
INSERT INTO sansin_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","අනන්තරං යීශුරේකදා ගිනේෂරථ්දස්‍ය තීර උත්තිෂ්ඨති, තදා ලෝකා ඊශ්වරීයකථාං ශ්‍රෝතුං තදුපරි ප්‍රපතිතාඃ| ");
INSERT INTO sansin_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","තදානීං ස හ්දස්‍ය තීරසමීපේ නෞද්වයං දදර්ශ කිඤ්ච මත්ස්‍යෝපජීවිනෝ නාවං විහාය ජාලං ප්‍රක්‍ෂාලයන්ති| ");
INSERT INTO sansin_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","තතස්තයෝර්ද්වයෝ ර්මධ්‍යේ ශිමෝනෝ නාවමාරුහ්‍ය තීරාත් කිඤ්චිද්දූරං යාතුං තස්මින් විනයං කෘත්වා නෞකායාමුපවිශ්‍ය ලෝකාන් ප්‍රෝපදිෂ්ටවාන්| ");
INSERT INTO sansin_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","පශ්චාත් තං ප්‍රස්තාවං සමාප්‍ය ස ශිමෝනං ව්‍යාජහාර, ගභීරං ජලං ගත්වා මත්ස්‍යාන් ධර්ත්තුං ජාලං නික්‍ෂිප| ");
INSERT INTO sansin_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","තතඃ ශිමෝන බභාෂේ, හේ ගුරෝ යද්‍යපි වයං කෘත්ස්නාං යාමිනීං පරිශ්‍රම්‍ය මත්ස්‍යෛකමපි න ප්‍රාප්තාස්තථාපි භවතෝ නිදේශතෝ ජාලං ක්‍ෂිපාමඃ| ");
INSERT INTO sansin_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","අථ ජාලේ ක්‍ෂිප්තේ බහුමත්ස්‍යපතනාද් ආනායඃ ප්‍රච්ඡින්නඃ| ");
INSERT INTO sansin_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","තස්මාද් උපකර්ත්තුම් අන්‍යනෞස්ථාන් සඞ්ගින ආයාතුම් ඉඞ්ගිතේන සමාහ්වයන් තතස්ත ආගත්‍ය මත්ස්‍යෛ ර්නෞද්වයං ප්‍රපූරයාමාසු ර‍්‍යෛ ර්නෞද්වයං ප්‍රමග්නම්| ");
INSERT INTO sansin_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","තදා ශිමෝන්පිතරස්තද් විලෝක්‍ය යීශෝශ්චරණයෝඃ පතිත්වා, හේ ප්‍රභෝහං පාපී නරෝ මම නිකටාද් භවාන් යාතු, ඉති කථිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","යතෝ ජාලේ පතිතානාං මත්ස්‍යානාං යූථාත් ශිමෝන් තත්සඞ්ගිනශ්ච චමත්කෘතවන්තඃ; ශිමෝනඃ සහකාරිණෞ සිවදේඃ පුත්‍රෞ යාකූබ් යෝහන් චේමෞ තාදෘශෞ බභූවතුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","තදා යීශුඃ ශිමෝනං ජගාද මා භෛෂීරද්‍යාරභ්‍ය ත්වං මනුෂ්‍යධරෝ භවිෂ්‍යසි| ");
INSERT INTO sansin_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","අනන්තරං සර්ව්වාසු නෞසු තීරම් ආනීතාසු තේ සර්ව්වාන් පරිත්‍යජ්‍ය තස්‍ය පශ්චාද්ගාමිනෝ බභූවුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","තතඃ පරං යීශෞ කස්මිංශ්චිත් පුරේ තිෂ්ඨති ජන ඒකඃ සර්ව්වාඞ්ගකුෂ්ඨස්තං විලෝක්‍ය තස්‍ය සමීපේ න්‍යුබ්ජඃ පතිත්වා සවිනයං වක්තුමාරේභේ, හේ ප්‍රභෝ යදි භවානිච්ඡති තර්හි මාං පරිෂ්කර්ත්තුං ශක්නෝති| ");
INSERT INTO sansin_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","තදානීං ස පාණිං ප්‍රසාර‍්‍ය්‍ය තදඞ්ගං ස්පෘශන් බභාෂේ ත්වං පරිෂ්ක්‍රියස්වේති මමේච්ඡාස්ති තතස්තත්ක්‍ෂණං ස කුෂ්ඨාත් මුක්තඃ| ");
INSERT INTO sansin_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","පශ්චාත් ස තමාඥාපයාමාස කථාමිමාං කස්මෛචිද් අකථයිත්වා යාජකස්‍ය සමීපඤ්ච ගත්වා ස්වං දර්ශය, ලෝකේභ්‍යෝ නිජපරිෂ්කෘතත්වස්‍ය ප්‍රමාණදානාය මූසාඥානුසාරේණ ද්‍රව්‍යමුත්මෘජස්ව ච| ");
INSERT INTO sansin_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","තථාපි යීශෝඃ සුඛ්‍යාති ර්බහු ව්‍යාප්තුමාරේභේ කිඤ්ච තස්‍ය කථාං ශ්‍රෝතුං ස්වීයරෝගේභ්‍යෝ මෝක්තුඤ්ච ලෝකා ආජග්මුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","අථ ස ප්‍රාන්තරං ගත්වා ප්‍රාර්ථයාඤ්චක්‍රේ| ");
INSERT INTO sansin_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","අපරඤ්ච ඒකදා යීශුරුපදිශති, ඒතර්හි ගාලීල්‍යිහූදාප්‍රදේශයෝඃ සර්ව්වනගරේභ්‍යෝ යිරූශාලමශ්ච කියන්තඃ ඵිරූශිලෝකා ව්‍යවස්ථාපකාශ්ච සමාගත්‍ය තදන්තිකේ සමුපවිවිශුඃ, තස්මින් කාලේ ලෝකානාමාරෝග්‍යකාරණාත් ප්‍රභෝඃ ප්‍රභාවඃ ප්‍රචකාශේ| ");
INSERT INTO sansin_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","පශ්චාත් කියන්තෝ ලෝකා ඒකං පක්‍ෂාඝාතිනං ඛට්වායාං නිධාය යීශෝඃ සමීපමානේතුං සම්මුඛේ ස්ථාපයිතුඤ්ච ව්‍යාප්‍රියන්ත| ");
INSERT INTO sansin_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","කින්තු බහුජනනිවහසම්වාධාත් න ශක්නුවන්තෝ ගෘහෝපරි ගත්වා ගෘහපෘෂ්ඨං ඛනිත්වා තං පක්‍ෂාඝාතිනං සඛට්වං ගෘහමධ්‍යේ යීශෝඃ සම්මුඛේ (අ)වරෝහයාමාසුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","තදා යීශුස්තේෂාම් ඊදෘශං විශ්වාසං විලෝක්‍ය තං පක්‍ෂාඝාතිනං ව්‍යාජහාර, හේ මානව තව පාපමක්‍ෂම්‍යත| ");
INSERT INTO sansin_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","තස්මාද් අධ්‍යාපකාඃ ඵිරූශිනශ්ච චිත්තෛරිත්ථං ප්‍රචින්තිතවන්තඃ, ඒෂ ජන ඊශ්වරං නින්දති කෝයං? කේවලමීශ්වරං විනා පාපං ක්‍ෂන්තුං කඃ ශක්නෝති? ");
INSERT INTO sansin_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","තදා යීශුස්තේෂාම් ඉත්ථං චින්තනං විදිත්වා තේභ්‍යෝකථයද් යූයං මනෝභිඃ කුතෝ විතර්කයථ? ");
INSERT INTO sansin_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","තව පාපක්‍ෂමා ජාතා යද්වා ත්වමුත්ථාය ව්‍රජ ඒතයෝ ර්මධ්‍යේ කා කථා සුකථ්‍යා? ");
INSERT INTO sansin_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","කින්තු පෘථිව්‍යාං පාපං ක්‍ෂන්තුං මානවසුතස්‍ය සාමර්ථ්‍යමස්තීති යථා යූයං ඥාතුං ශක්නුථ තදර්ථං (ස තං පක්‍ෂාඝාතිනං ජගාද) උත්තිෂ්ඨ ස්වශය්‍යාං ගෘහීත්වා ගෘහං යාහීති ත්වාමාදිශාමි| ");
INSERT INTO sansin_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","තස්මාත් ස තත්ක්‍ෂණම් උත්ථාය සර්ව්වේෂාං සාක්‍ෂාත් නිජශයනීයං ගෘහීත්වා ඊශ්වරං ධන්‍යං වදන් නිජනිවේශනං යයෞ| ");
INSERT INTO sansin_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","තස්මාත් සර්ව්වේ විස්මය ප්‍රාප්තා මනඃසු භීතාශ්ච වයමද්‍යාසම්භවකාර‍්‍ය්‍යාණ්‍යදර්ශාම ඉත්‍යුක්ත්වා පරමේශ්වරං ධන්‍යං ප්‍රෝදිතාඃ| ");
INSERT INTO sansin_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","තතඃ පරං බහිර්ගච්ඡන් කරසඤ්චයස්ථානේ ලේවිනාමානං කරසඤ්චායකං දෘෂ්ට්වා යීශුස්තමභිදධේ මම පශ්චාදේහි| ");
INSERT INTO sansin_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","තස්මාත් ස තත්ක්‍ෂණාත් සර්ව්වං පරිත්‍යජ්‍ය තස්‍ය පශ්චාදියාය| ");
INSERT INTO sansin_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","අනන්තරං ලේවි ර්නිජගෘහේ තදර්ථං මහාභෝජ්‍යං චකාර, තදා තෛඃ සහානේකේ කරසඤ්චායිනස්තදන්‍යලෝකාශ්ච භෝක්තුමුපවිවිශුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","තස්මාත් කාරණාත් චණ්ඩාලානාං පාපිලෝකානාඤ්ච සඞ්ගේ යූයං කුතෝ භංග්ධ්වේ පිවථ චේති කථාං කථයිත්වා ඵිරූශිනෝ(අ)ධ්‍යාපකාශ්ච තස්‍ය ශිෂ්‍යෛඃ සහ වාග්‍යුද්ධං කර්ත්තුමාරේභිරේ| ");
INSERT INTO sansin_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","තස්මාද් යීශුස්තාන් ප්‍රත්‍යවෝචද් අරෝගලෝකානාං චිකිත්සකේන ප්‍රයෝජනං නාස්ති කින්තු සරෝගාණාමේව| ");
INSERT INTO sansin_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","අහං ධාර්ම්මිකාන් ආහ්වාතුං නාගතෝස්මි කින්තු මනඃ පරාවර්ත්තයිතුං පාපින ඒව| ");
INSERT INTO sansin_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","තතස්තේ ප්‍රෝචුඃ, යෝහනඃ ඵිරූශිනාඤ්ච ශිෂ්‍යා වාරංවාරම් උපවසන්ති ප්‍රාර්ථයන්තේ ච කින්තු තව ශිෂ්‍යාඃ කුතෝ භුඤ්ජතේ පිවන්ති ච? ");
INSERT INTO sansin_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","තදා ස තානාචඛ්‍යෞ වරේ සඞ්ගේ තිෂ්ඨති වරස්‍ය සඛිගණං කිමුපවාසයිතුං ශක්නුථ? ");
INSERT INTO sansin_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","කින්තු යදා තේෂාං නිකටාද් වරෝ නේෂ්‍යතේ තදා තේ සමුපවත්ස්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","සෝපරමපි දෘෂ්ටාන්තං කථයාම්බභූව පුරාතනවස්ත්‍රේ කෝපි නුතනවස්ත්‍රං න සීව්‍යති යතස්තේන සේවනේන ජීර්ණවස්ත්‍රං ඡිද්‍යතේ, නූතනපුරාතනවස්ත්‍රයෝ ර්මේලඤ්ච න භවති| ");
INSERT INTO sansin_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","පුරාතන්‍යාං කුත්වාං කෝපි නුතනං ද්‍රාක්‍ෂාරසං න නිදධාති, යතෝ නවීනද්‍රාක්‍ෂාරසස්‍ය තේජසා පුරාතනී කුතූ ර්විදීර‍්‍ය්‍යතේ තතෝ ද්‍රාක්‍ෂාරසඃ පතති කුතූශ්ච නශ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","තතෝ හේතෝ ර්නූතන්‍යාං කුත්වාං නවීනද්‍රාක්‍ෂාරසඃ නිධාතව්‍යස්තේනෝභයස්‍ය රක්‍ෂා භවති| ");
INSERT INTO sansin_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","අපරඤ්ච පුරාතනං ද්‍රාක්‍ෂාරසං පීත්වා කෝපි නූතනං න වාඤ්ඡති, යතඃ ස වක්ති නූතනාත් පුරාතනම් ප්‍රශස්තම්| ");
INSERT INTO sansin_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","අචරඤ්ච පර්ව්වණෝ ද්විතීයදිනාත් පරං ප්‍රථමවිශ්‍රාමවාරේ ශස්‍යක්‍ෂේත්‍රේණ යීශෝර්ගමනකාලේ තස්‍ය ශිෂ්‍යාඃ කණිශං ඡිත්ත්වා කරේෂු මර්ද්දයිත්වා ඛාදිතුමාරේභිරේ| ");
INSERT INTO sansin_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","තස්මාත් කියන්තඃ ඵිරූශිනස්තානවදන් විශ්‍රාමවාරේ යත් කර්ම්ම න කර්ත්තව්‍යං තත් කුතඃ කුරුථ? ");
INSERT INTO sansin_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","යීශුඃ ප්‍රත්‍යුවාච දායූද් තස්‍ය සඞ්ගිනශ්ච ක්‍ෂුධාර්ත්තාඃ කිං චක්‍රුඃ ස කථම් ඊශ්වරස්‍ය මන්දිරං ප්‍රවිශ්‍ය ");
INSERT INTO sansin_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","යේ දර්ශනීයාඃ පූපා යාජකාන් විනාන්‍යස්‍ය කස්‍යාප්‍යභෝජනීයාස්තානානීය ස්වයං බුභජේ සඞ්ගිභ්‍යෝපි දදෞ තත් කිං යුෂ්මාභිඃ කදාපි නාපාඨි? ");
INSERT INTO sansin_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","පශ්චාත් ස තානවදත් මනුජසුතෝ විශ්‍රාමවාරස්‍යාපි ප්‍රභු ර්භවති| ");
INSERT INTO sansin_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","අනන්තරම් අන්‍යවිශ්‍රාමවාරේ ස භජනගේහං ප්‍රවිශ්‍ය සමුපදිශති| තදා තත්ස්ථානේ ශුෂ්කදක්‍ෂිණකර ඒකඃ පුමාන් උපතස්ථිවාන්| ");
INSERT INTO sansin_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","තස්මාද් අධ්‍යාපකාඃ ඵිරූශිනශ්ච තස්මින් දෝෂමාරෝපයිතුං ස විශ්‍රාමවාරේ තස්‍ය ස්වාස්ථ්‍යං කරෝති නවේති ප්‍රතීක්‍ෂිතුමාරේභිරේ| ");
INSERT INTO sansin_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","තදා යීශුස්තේෂාං චින්තාං විදිත්වා තං ශුෂ්කකරං පුමාංසං ප්‍රෝවාච, ත්වමුත්ථාය මධ්‍යස්ථානේ තිෂ්ඨ| ");
INSERT INTO sansin_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","තස්මාත් තස්මින් උත්ථිතවති යීශුස්තාන් ව්‍යාජහාර, යුෂ්මාන් ඉමාං කථාං පෘච්ඡාමි, විශ්‍රාමවාරේ හිතම් අහිතං වා, ප්‍රාණරක්‍ෂණං ප්‍රාණනාශනං වා, ඒතේෂාං කිං කර්ම්මකරණීයම්? ");
INSERT INTO sansin_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","පශ්චාත් චතුර්දික්‍ෂු සර්ව්වාන් විලෝක්‍ය තං මානවං බභාෂේ, නිජකරං ප්‍රසාරය; තතස්තේන තථා කෘත ඉතරකරවත් තස්‍ය හස්තඃ ස්වස්ථෝභවත්| ");
INSERT INTO sansin_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","තස්මාත් තේ ප්‍රචණ්ඩකෝපාන්විතා යීශුං කිං කරිෂ්‍යන්තීති පරස්පරං ප්‍රමන්ත්‍රිතාඃ| ");
INSERT INTO sansin_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","තතඃ පරං ස පර්ව්වතමාරුහ්‍යේශ්වරමුද්දිශ්‍ය ප්‍රාර්ථයමානඃ කෘත්ස්නාං රාත්‍රිං යාපිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","අථ දිනේ සති ස සර්ව්වාන් ශිෂ්‍යාන් ආහූතවාන් තේෂාං මධ්‍යේ ");
INSERT INTO sansin_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","පිතරනාම්නා ඛ්‍යාතඃ ශිමෝන් තස්‍ය භ්‍රාතා ආන්ද්‍රියශ්ච යාකූබ් යෝහන් ච ඵිලිප් බර්ථලමයශ්ච ");
INSERT INTO sansin_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","මථිඃ ථෝමා ආල්ඵීයස්‍ය පුත්‍රෝ යාකූබ් ජ්වලන්තනාම්නා ඛ්‍යාතඃ ශිමෝන් ");
INSERT INTO sansin_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ච යාකූබෝ භ්‍රාතා යිහූදාශ්ච තං යඃ පරකරේෂු සමර්පයිෂ්‍යති ස ඊෂ්කරීයෝතීයයිහූදාශ්චෛතාන් ද්වාදශ ජනාන් මනෝනීතාන් කෘත්වා ස ජග්‍රාහ තථා ප්‍රේරිත ඉති තේෂාං නාම චකාර| ");
INSERT INTO sansin_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","තතඃ පරං ස තෛඃ සහ පර්ව්වතාදවරුහ්‍ය උපත්‍යකායාං තස්ථෞ තතස්තස්‍ය ශිෂ්‍යසඞ්ඝෝ යිහූදාදේශාද් යිරූශාලමශ්ච සෝරඃ සීදෝනශ්ච ජලධේ රෝධසෝ ජනනිහාශ්ච ඒත්‍ය තස්‍ය කථාශ්‍රවණාර්ථං රෝගමුක්ත්‍යර්ථඤ්ච තස්‍ය සමීපේ තස්ථුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","අමේධ්‍යභූතග්‍රස්තාශ්ච තන්නිකටමාගත්‍ය ස්වාස්ථ්‍යං ප්‍රාපුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","සර්ව්වේෂාං ස්වාස්ථ්‍යකරණප්‍රභාවස්‍ය ප්‍රකාශිතත්වාත් සර්ව්වේ ලෝකා ඒත්‍ය තං ස්ප්‍රෂ්ටුං යේතිරේ| ");
INSERT INTO sansin_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","පශ්චාත් ස ශිෂ්‍යාන් ප්‍රති දෘෂ්ටිං කුත්වා ජගාද, හේ දරිද්‍රා යූයං ධන්‍යා යත ඊශ්වරීයේ රාජ්‍යේ වෝ(අ)ධිකාරෝස්ති| ");
INSERT INTO sansin_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","හේ අධුනා ක්‍ෂුධිතලෝකා යූයං ධන්‍යා යතෝ යූයං තර්ප්ස්‍යථ; හේ ඉහ රෝදිනෝ ජනා යූයං ධන්‍යා යතෝ යූයං හසිෂ්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","යදා ලෝකා මනුෂ්‍යසූනෝ ර්නාමහේතෝ ර‍්‍යුෂ්මාන් ඍृතීයිෂ්‍යන්තේ පෘථක් කෘත්වා නින්දිෂ්‍යන්ති, අධමානිව යුෂ්මාන් ස්වසමීපාද් දූරීකරිෂ්‍යන්ති ච තදා යූයං ධන්‍යාඃ| ");
INSERT INTO sansin_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ස්වර්ගේ යුෂ්මාකං යථේෂ්ටං ඵලං භවිෂ්‍යති, ඒතදර්ථං තස්මින් දිනේ ප්‍රෝල්ලසත ආනන්දේන නෘත්‍යත ච, තේෂාං පූර්ව්වපුරුෂාශ්ච භවිෂ්‍යද්වාදිනඃ ප්‍රති තථෛව ව්‍යවාහරන්| ");
INSERT INTO sansin_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","කින්තු හා හා ධනවන්තෝ යූයං සුඛං ප්‍රාප්නුත| හන්ත පරිතෘප්තා යූයං ක්‍ෂුධිතා භවිෂ්‍යථ; ");
INSERT INTO sansin_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ඉහ හසන්තෝ යූයං වත යුෂ්මාභිඃ ශෝචිතව්‍යං රෝදිතව්‍යඤ්ච| ");
INSERT INTO sansin_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","සර්ව්වෛලාකෛ ර‍්‍යුෂ්මාකං සුඛ්‍යාතෞ කෘතායාං යුෂ්මාකං දුර්ගති ර්භවිෂ්‍යති යුෂ්මාකං පූර්ව්වපුරුෂා මෘෂාභවිෂ්‍යද්වාදිනඃ ප්‍රති තද්වත් කෘතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","හේ ශ්‍රෝතාරෝ යුෂ්මභ්‍යමහං කථයාමි, යූයං ශත්‍රුෂු ප්‍රීයධ්වං යේ ච යුෂ්මාන් ද්විෂන්ති තේෂාමපි හිතං කුරුත| ");
INSERT INTO sansin_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","යේ ච යුෂ්මාන් ශපන්ති තේභ්‍ය ආශිෂං දත්ත යේ ච යුෂ්මාන් අවමන්‍යන්තේ තේෂාං මඞ්ගලං ප්‍රාර්ථයධ්වං| ");
INSERT INTO sansin_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","යදි කශ්චිත් තව කපෝලේ චපේටාඝාතං කරෝති තර්හි තං ප්‍රති කපෝලම් අන්‍යං පරාවර්ත්ත්‍ය සම්මුඛීකුරු පුනශ්ච යදි කශ්චිත් තව ගාත්‍රීයවස්ත්‍රං හරති තර්හි තං පරිධේයවස්ත්‍රම් අපි ග්‍රහීතුං මා වාරය| ");
INSERT INTO sansin_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","යස්ත්වාං යාචතේ තස්මෛ දේහි, යශ්ච තව සම්පත්තිං හරති තං මා යාචස්ව| ");
INSERT INTO sansin_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","පරේභ්‍යඃ ස්වාන් ප්‍රති යථාචරණම් අපේක්‍ෂධ්වේ පරාන් ප්‍රති යූයමපි තථාචරත| ");
INSERT INTO sansin_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","යේ ජනා යුෂ්මාසු ප්‍රීයන්තේ කේවලං තේෂු ප්‍රීයමාණේෂු යුෂ්මාකං කිං ඵලං? පාපිලෝකා අපි ස්වේෂු ප්‍රීයමාණේෂු ප්‍රීයන්තේ| ");
INSERT INTO sansin_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","යදි හිතකාරිණ ඒව හිතං කුරුථ තර්හි යුෂ්මාකං කිං ඵලං? පාපිලෝකා අපි තථා කුර්ව්වන්ති| ");
INSERT INTO sansin_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","යේභ්‍ය ඍණපරිශෝධස්‍ය ප්‍රාප්තිප්‍රත්‍යාශාස්තේ කේවලං තේෂු ඍණේ සමර්පිතේ යුෂ්මාකං කිං ඵලං? පුනඃ ප්‍රාප්ත්‍යාශයා පාපීලෝකා අපි පාපිජනේෂු ඍණම් අර්පයන්ති| ");
INSERT INTO sansin_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","අතෝ යූයං රිපුෂ්වපි ප්‍රීයධ්වං, පරහිතං කුරුත ච; පුනඃ ප්‍රාප්ත්‍යාශාං ත්‍යක්ත්වා ඍණමර්පයත, තථා කෘතේ යුෂ්මාකං මහාඵලං භවිෂ්‍යති, යූයඤ්ච සර්ව්වප්‍රධානස්‍ය සන්තානා ඉති ඛ්‍යාතිං ප්‍රාප්ස්‍යථ, යතෝ යුෂ්මාකං පිතා කෘතඝ්නානාං දුර්ව්ටත්තානාඤ්ච හිතමාචරති| ");
INSERT INTO sansin_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","අත ඒව ස යථා දයාලු ර‍්‍යූයමපි තාදෘශා දයාලවෝ භවත| ");
INSERT INTO sansin_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","අපරඤ්ච පරාන් දෝෂිණෝ මා කුරුත තස්මාද් යූයං දෝෂීකෘතා න භවිෂ්‍යථ; අදණ්ඩ්‍යාන් මා දණ්ඩයත තස්මාද් යූයමපි දණ්ඩං න ප්‍රාප්ස්‍යථ; පරේෂාං දෝෂාන් ක්‍ෂමධ්වං තස්මාද් යුෂ්මාකමපි දෝෂාඃ ක්‍ෂමිෂ්‍යන්තේ| ");
INSERT INTO sansin_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","දානානිදත්ත තස්මාද් යූයං දානානි ප්‍රාප්ස්‍යථ, වරඤ්ච ලෝකාඃ පරිමාණපාත්‍රං ප්‍රදලය්‍ය සඤ්චාල්‍ය ප්‍රෝඤ්චාල්‍ය පරිපූර‍්‍ය්‍ය යුෂ්මාකං ක්‍රෝඩේෂු සමර්පයිෂ්‍යන්ති; යූයං යේන පරිමාණේන පරිමාථ තේනෛව පරිමාණේන යුෂ්මත්කෘතේ පරිමාස්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","අථ ස තේභ්‍යෝ දෘෂ්ටාන්තකථාමකථයත්, අන්ධෝ ජනඃ කිමන්ධං පන්ථානං දර්ශයිතුං ශක්නෝති? තස්මාද් උභාවපි කිං ගර්ත්තේ න පතිෂ්‍යතඃ? ");
INSERT INTO sansin_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ගුරෝඃ ශිෂ්‍යෝ න ශ්‍රේෂ්ඨඃ කින්තු ශිෂ්‍යේ සිද්ධේ සති ස ගුරුතුල්‍යෝ භවිතුං ශක්නෝති| ");
INSERT INTO sansin_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","අපරඤ්ච ත්වං ස්වචක්‍ෂුुෂි නාසාම් අදෘෂ්ට්වා තව භ්‍රාතුශ්චක්‍ෂුෂි යත්තෘණමස්ති තදේව කුතඃ පශ්‍යමි? ");
INSERT INTO sansin_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","ස්වචක්‍ෂුෂි යා නාසා විද්‍යතේ තාම් අඥාත්වා, භ්‍රාතස්තව නේත්‍රාත් තෘණං බහිඃ කරෝමීති වාක්‍යං භ්‍රාතරං කථං වක්තුං ශක්නෝෂි? හේ කපටින් පූර්ව්වං ස්වනයනාත් නාසාං බහිඃ කුරු තතෝ භ්‍රාතුශ්චක්‍ෂුෂස්තෘණං බහිඃ කර්ත්තුං සුදෘෂ්ටිං ප්‍රාප්ස්‍යසි| ");
INSERT INTO sansin_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","අන්‍යඤ්ච උත්තමස්තරුඃ කදාපි ඵලමනුත්තමං න ඵලති, අනුත්තමතරුශ්ච ඵලමුත්තමං න ඵලති කාරණාදතඃ ඵලෛස්තරවෝ ඥායන්තේ| ");
INSERT INTO sansin_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","කණ්ටකිපාදපාත් කෝපි උඩුම්බරඵලානි න පාතයති තථා ශෘගාලකෝලිවෘක්‍ෂාදපි කෝපි ද්‍රාක්‍ෂාඵලං න පාතයති| ");
INSERT INTO sansin_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","තද්වත් සාධුලෝකෝ(අ)න්තඃකරණරූපාත් සුභාණ්ඩාගාරාද් උත්තමානි ද්‍රව්‍යාණි බහිඃ කරෝති, දුෂ්ටෝ ලෝකශ්චාන්තඃකරණරූපාත් කුභාණ්ඩාගාරාත් කුත්සිතානි ද්‍රව්‍යාණි නිර්ගමයති යතෝ(අ)න්තඃකරණානාං පූර්ණභාවානුරූපාණි වචාංසි මුඛාන්නිර්ගච්ඡන්ති| ");
INSERT INTO sansin_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","අපරඤ්ච මමාඥානුරූපං නාචරිත්වා කුතෝ මාං ප්‍රභෝ ප්‍රභෝ ඉති වදථ? ");
INSERT INTO sansin_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","යඃ කශ්චින් මම නිකටම් ආගත්‍ය මම කථා නිශම්‍ය තදනුරූපං කර්ම්ම කරෝති ස කස්‍ය සදෘශෝ භවති තදහං යුෂ්මාන් ඥාाපයාමි| ");
INSERT INTO sansin_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","යෝ ජනෝ ගභීරං ඛනිත්වා පාෂාණස්ථලේ භිත්තිං නිර්ම්මාය ස්වගෘහං රචයති තේන සහ තස්‍යෝපමා භවති; යත ආප්ලාවිජලමේත්‍ය තස්‍ය මූලේ වේගේන වහදපි තද්ගේහං ලාඩයිතුං න ශක්නෝති යතස්තස්‍ය භිත්තිඃ පාෂාණෝපරි තිෂ්ඨති| ");
INSERT INTO sansin_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","කින්තු යඃ කශ්චින් මම කථාඃ ශ්‍රුත්වා තදනුරූපං නාචරති ස භිත්තිං විනා මෘृදුපරි ගෘහනිර්ම්මාත්‍රා සමානෝ භවති; යත ආප්ලාවිජලමාගත්‍ය වේගේන යදා වහති තදා තද්ගෘහං පතති තස්‍ය මහත් පතනං ජායතේ| ");
INSERT INTO sansin_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","තතඃ පරං ස ලෝකානාං කර්ණගෝචරේ තාන් සර්ව්වාන් උපදේශාන් සමාප්‍ය යදා කඵර්නාහූම්පුරං ප්‍රවිශති ");
INSERT INTO sansin_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","තදා ශතසේනාපතේඃ ප්‍රියදාස ඒකෝ මෘතකල්පඃ පීඩිත ආසීත්| ");
INSERT INTO sansin_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","අතඃ සේනාපති ර‍්‍යීශෝ ර්වාර්ත්තාං නිශම්‍ය දාසස්‍යාරෝග්‍යකරණාය තස්‍යාගමනාර්ථං විනයකරණාය යිහූදීයාන් කියතඃ ප්‍රාචඃ ප්‍රේෂයාමාස| ");
INSERT INTO sansin_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","තේ යීශෝරන්තිකං ගත්වා විනයාතිශයං වක්තුමාරේභිරේ, ස සේනාපති ර්භවතෝනුග්‍රහං ප්‍රාප්තුම් අර්හති| ");
INSERT INTO sansin_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","යතඃ සෝස්මජ්ජාතීයේෂු ලෝකේෂු ප්‍රීයතේ තථාස්මත්කෘතේ භජනගේහං නිර්ම්මිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","තස්මාද් යීශුස්තෛඃ සහ ගත්වා නිවේශනස්‍ය සමීපං ප්‍රාප, තදා ස ශතසේනාපති ර්වක්‍ෂ්‍යමාණවාක්‍යං තං වක්තුං බන්ධූන් ප්‍රාහිණෝත්| හේ ප්‍රභෝ ස්වයං ශ්‍රමෝ න කර්ත්තව්‍යෝ යද් භවතා මද්ගේහමධ්‍යේ පාදාර්පණං ක්‍රියේත තදප්‍යහං නාර්හාමි, ");
INSERT INTO sansin_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","කිඤ්චාහං භවත්සමීපං යාතුමපි නාත්මානං යෝග්‍යං බුද්ධවාන්, තතෝ භවාන් වාක්‍යමාත්‍රං වදතු තේනෛව මම දාසඃ ස්වස්ථෝ භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","යස්මාද් අහං පරාධීනෝපි මමාධීනා යාඃ සේනාඃ සන්ති තාසාම් ඒකජනං ප්‍රති යාහීති මයා ප්‍රෝක්තේ ස යාති; තදන්‍යං ප්‍රති ආයාහීති ප්‍රෝක්තේ ස ආයාති; තථා නිජදාසං ප්‍රති ඒතත් කුර්ව්විති ප්‍රෝක්තේ ස තදේව කරෝති| ");
INSERT INTO sansin_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","යීශුරිදං වාක්‍යං ශ්‍රුත්වා විස්මයං යයෞ, මුඛං පරාවර්ත්‍ය පශ්චාද්වර්ත්තිනෝ ලෝකාන් බභාෂේ ච, යුෂ්මානහං වදාමි ඉස්‍රායේලෝ වංශමධ්‍යේපි විශ්වාසමීදෘශං න ප්‍රාප්නවං| ");
INSERT INTO sansin_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","තතස්තේ ප්‍රේෂිතා ගෘහං ගත්වා තං පීඩිතං දාසං ස්වස්ථං දදෘශුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","පරේ(අ)හනි ස නායීනාඛ්‍යං නගරං ජගාම තස්‍යානේකේ ශිෂ්‍යා අන්‍යේ ච ලෝකාස්තේන සාර්ද්ධං යයුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","තේෂු තන්නගරස්‍ය ද්වාරසන්නිධිං ප්‍රාප්තේෂු කියන්තෝ ලෝකා ඒකං මෘතමනුජං වහන්තෝ නගරස්‍ය බහිර‍්‍යාන්ති, ස තන්මාතුරේකපුත්‍රස්තන්මාතා ච විධවා; තයා සාර්ද්ධං තන්නගරීයා බහවෝ ලෝකා ආසන්| ");
INSERT INTO sansin_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ප්‍රභුස්තාං විලෝක්‍ය සානුකම්පඃ කථයාමාස, මා රෝදීඃ| ස සමීපමිත්වා ඛට්වාං පස්පර්ශ තස්මාද් වාහකාඃ ස්ථගිතාස්තම්‍යුඃ; ");
INSERT INTO sansin_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","තදා ස උවාච හේ යුවමනුෂ්‍ය ත්වමුත්තිෂ්ඨ, ත්වාමහම් ආඥාපයාමි| ");
INSERT INTO sansin_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","තස්මාත් ස මෘතෝ ජනස්තත්ක්‍ෂණමුත්ථාය කථාං ප්‍රකථිතඃ; තතෝ යීශුස්තස්‍ය මාතරි තං සමර්පයාමාස| ");
INSERT INTO sansin_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","තස්මාත් සර්ව්වේ ලෝකාඃ ශශඞ්කිරේ; ඒකෝ මහාභවිෂ්‍යද්වාදී මධ්‍යේ(අ)ස්මාකම් සමුදෛත්, ඊශ්වරශ්ච ස්වලෝකානන්වගෘහ්ලාත් කථාමිමාං කථයිත්වා ඊශ්වරං ධන්‍යං ජගදුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","තතඃ පරං සමස්තං යිහූදාදේශං තස්‍ය චතුර්දික්ස්ථදේශඤ්ච තස්‍යෛතත්කීර්ත්ති ර්ව්‍යානශේ| ");
INSERT INTO sansin_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","තතඃ පරං යෝහනඃ ශිෂ්‍යේෂු තං තද්වෘත්තාන්තං ඥාපිතවත්සු ");
INSERT INTO sansin_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ස ස්වශිෂ්‍යාණාං ද්වෞ ජනාවාහූය යීශුං ප්‍රති වක්‍ෂ්‍යමාණං වාක්‍යං වක්තුං ප්‍රේෂයාමාස, යස්‍යාගමනම් අපේක්‍ෂ්‍ය තිෂ්ඨාමෝ වයං කිං ස ඒව ජනස්ත්වං? කිං වයමන්‍යමපේක්‍ෂ්‍ය ස්ථාස්‍යාමඃ? ");
INSERT INTO sansin_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","පශ්චාත්තෞ මානවෞ ගත්වා කථයාමාසතුඃ, යස්‍යාගමනම් අපේක්‍ෂ්‍ය තිෂ්ඨාමෝ වයං, කිං සඒව ජනස්ත්වං? කිං වයමන්‍යමපේක්‍ෂ්‍ය ස්ථාස්‍යාමඃ? කථාමිමාං තුභ්‍යං කථයිතුං යෝහන් මජ්ජක ආවාං ප්‍රේෂිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","තස්මින් දණ්ඩේ යීශූරෝගිණෝ මහාව්‍යාධිමතෝ දුෂ්ටභූතග්‍රස්තාංශ්ච බහූන් ස්වස්ථාන් කෘත්වා, අනේකාන්ධේභ්‍යශ්චක්‍ෂුංෂි දත්ත්වා ප්‍රත්‍යුවාච, ");
INSERT INTO sansin_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","යුවාං ව්‍රජතම් අන්ධා නේත්‍රාණි ඛඤ්ජාශ්චරණානි ච ප්‍රාප්නුවන්ති, කුෂ්ඨිනඃ පරිෂ්ක්‍රියන්තේ, බධිරාඃ ශ්‍රවණානි මෘතාශ්ච ජීවනානි ප්‍රාප්නුවන්ති, දරිද්‍රාණාං සමීපේෂු සුසංවාදඃ ප්‍රචාර‍්‍ය්‍යතේ, යං ප්‍රති විඝ්නස්වරූපෝහං න භවාමි ස ධන්‍යඃ, ");
INSERT INTO sansin_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ඒතානි යානි පශ්‍යථඃ ශෘණුථශ්ච තානි යෝහනං ඥාපයතම්| ");
INSERT INTO sansin_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","තයෝ ර්දූතයෝ ර්ගතයෝඃ සතෝ ර‍්‍යෝහනි ස ලෝකාන් වක්තුමුපචක්‍රමේ, යූයං මධ්‍යේප්‍රාන්තරං කිං ද්‍රෂ්ටුං නිරගමත? කිං වායුනා කම්පිතං නඩං? ");
INSERT INTO sansin_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","යූයං කිං ද්‍රෂ්ටුං නිරගමත? කිං සූක්‍ෂ්මවස්ත්‍රපරිධායිනං කමපි නරං? කින්තු යේ සූක්‍ෂ්මමෘදුවස්ත්‍රාණි පරිදධති සූත්තමානි ද්‍රව්‍යාණි භුඤ්ජතේ ච තේ රාජධානීෂු තිෂ්ඨන්ති| ");
INSERT INTO sansin_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","තර්හි යූයං කිං ද්‍රෂ්ටුං නිරගමත? කිමේකං භවිෂ්‍යද්වාදිනං? තදේව සත්‍යං කින්තු ස පුමාන් භවිෂ්‍යද්වාදිනෝපි ශ්‍රේෂ්ඨ ඉත්‍යහං යුෂ්මාන් වදාමි; ");
INSERT INTO sansin_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","පශ්‍ය ස්වකීයදූතන්තු තවාග්‍ර ප්‍රේෂයාම්‍යහං| ගත්වා ත්වදීයමාර්ගන්තු ස හි පරිෂ්කරිෂ්‍යති| යදර්ථේ ලිපිරියම් ආස්තේ ස ඒව යෝහන්| ");
INSERT INTO sansin_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","අතෝ යුෂ්මානහං වදාමි ස්ත්‍රියා ගර්බ්භජාතානාං භවිෂ්‍යද්වාදිනාං මධ්‍යේ යෝහනෝ මජ්ජකාත් ශ්‍රේෂ්ඨඃ කෝපි නාස්ති, තත්‍රාපි ඊශ්වරස්‍ය රාජ්‍යේ යඃ සර්ව්වස්මාත් ක්‍ෂුද්‍රඃ ස යෝහනෝපි ශ්‍රේෂ්ඨඃ| ");
INSERT INTO sansin_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","අපරඤ්ච සර්ව්වේ ලෝකාඃ කරමඤ්චායිනශ්ච තස්‍ය වාක්‍යානි ශ්‍රුත්වා යෝහනා මජ්ජනේන මජ්ජිතාඃ පරමේශ්වරං නිර්දෝෂං මේනිරේ| ");
INSERT INTO sansin_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","කින්තු ඵිරූශිනෝ ව්‍යවස්ථාපකාශ්ච තේන න මජ්ජිතාඃ ස්වාන් ප්‍රතීශ්වරස්‍යෝපදේශං නිෂ්ඵලම් අකුර්ව්වන්| ");
INSERT INTO sansin_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","අථ ප්‍රභුඃ කථයාමාස, ඉදානීන්තනජනාන් කේනෝපමාමි? තේ කස්‍ය සදෘශාඃ? ");
INSERT INTO sansin_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","යේ බාලකා විපණ්‍යාම් උපවිශ්‍ය පරස්පරම් ආහූය වාක්‍යමිදං වදන්ති, වයං යුෂ්මාකං නිකටේ වංශීරවාදිෂ්ම, කින්තු යූයං නානර්ත්තිෂ්ට, වයං යුෂ්මාකං නිකට අරෝදිෂ්ම, කින්තු යුයං න ව්‍යලපිෂ්ට, බාලකෛරේතාදෘශෛස්තේෂාම් උපමා භවති| ");
INSERT INTO sansin_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","යතෝ යෝහන් මජ්ජක ආගත්‍ය පූපං නාඛාදත් ද්‍රාක්‍ෂාරසඤ්ච නාපිවත් තස්මාද් යූයං වදථ, භූතග්‍රස්තෝයම්| ");
INSERT INTO sansin_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","තතඃ පරං මානවසුත ආගත්‍යාඛාදදපිවඤ්ච තස්මාද් යූයං වදථ, ඛාදකඃ සුරාපශ්චාණ්ඩාලපාපිනාං බන්ධුරේකෝ ජනෝ දෘශ්‍යතාම්| ");
INSERT INTO sansin_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","කින්තු ඥානිනෝ ඥානං නිර්දෝෂං විදුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","පශ්චාදේකඃ ඵිරූශී යීශුං භෝජනාය න්‍යමන්ත්‍රයත් තතඃ ස තස්‍ය ගෘහං ගත්වා භෝක්තුමුපවිෂ්ටඃ| ");
INSERT INTO sansin_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ඒතර්හි තත්ඵිරූශිනෝ ගෘහේ යීශු ර්භේක්තුම් උපාවේක්‍ෂීත් තච්ඡ්‍රුත්වා තන්නගරවාසිනී කාපි දුෂ්ටා නාරී පාණ්ඩරප්‍රස්තරස්‍ය සම්පුටකේ සුගන්ධිතෛලම් ආනීය ");
INSERT INTO sansin_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","තස්‍ය පශ්චාත් පාදයෝඃ සන්නිධෞ තස්‍යෞ රුදතී ච නේත්‍රාම්බුභිස්තස්‍ය චරණෞ ප්‍රක්‍ෂාල්‍ය නිජකචෛරමාර්ක්‍ෂීත්, තතස්තස්‍ය චරණෞ චුම්බිත්වා තේන සුගන්ධිතෛලේන මමර්ද| ");
INSERT INTO sansin_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","තස්මාත් ස නිමන්ත්‍රයිතා ඵිරූශී මනසා චින්තයාමාස, යද්‍යයං භවිෂ්‍යද්වාදී භවේත් තර්හි ඒනං ස්පෘශති යා ස්ත්‍රී සා කා කීදෘශී චේති ඥාතුං ශක්නුයාත් යතඃ සා දුෂ්ටා| ");
INSERT INTO sansin_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","තදා යාශුස්තං ජගාද, හේ ශිමෝන් ත්වාං ප්‍රති මම කිඤ්චිද් වක්තව්‍යමස්ති; තස්මාත් ස බභාෂේ, හේ ගුරෝ තද් වදතු| ");
INSERT INTO sansin_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ඒකෝත්තමර්ණස්‍ය ද්වාවධමර්ණාවාස්තාං, තයෝරේකඃ පඤ්චශතානි මුද්‍රාපාදාන් අපරශ්ච පඤ්චාශත් මුද්‍රාපාදාන් ධාරයාමාස| ");
INSERT INTO sansin_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","තදනන්තරං තයෝඃ ශෝධ්‍යාභාවාත් ස උත්තමර්ණස්තයෝ රෘණේ චක්‍ෂමේ; තස්මාත් තයෝර්ද්වයෝඃ කස්තස්මින් ප්‍රේෂ්‍යතේ බහු? තද් බ්‍රූහි| ");
INSERT INTO sansin_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ශිමෝන් ප්‍රත්‍යුවාච, මයා බුධ්‍යතේ යස්‍යාධිකම් ඍණං චක්‍ෂමේ ස ඉති; තතෝ යීශුස්තං ව්‍යාජහාර, ත්වං යථාර්ථං ව්‍යචාරයඃ| ");
INSERT INTO sansin_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","අථ තාං නාරීං ප්‍රති ව්‍යාඝුඨ්‍ය ශිමෝනමවෝචත්, ස්ත්‍රීමිමාං පශ්‍යසි? තව ගෘහේ මය්‍යාගතේ ත්වං පාදප්‍රක්‍ෂාලනාර්ථං ජලං නාදාඃ කින්තු යෝෂිදේෂා නයනජලෛ ර්මම පාදෞ ප්‍රක්‍ෂාල්‍ය කේශෛරමාර්ක්‍ෂීත්| ");
INSERT INTO sansin_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ත්වං මාං නාචුම්බීඃ කින්තු යෝෂිදේෂා ස්වීයාගමනාදාරභ්‍ය මදීයපාදෞ චුම්බිතුං න ව්‍යරංස්ත| ");
INSERT INTO sansin_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ත්වඤ්ච මදීයෝත්තමාඞ්ගේ කිඤ්චිදපි තෛලං නාමර්දීඃ කින්තු යෝෂිදේෂා මම චරණෞ සුගන්ධිතෛලේනාමර්ද්දීත්| ");
INSERT INTO sansin_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","අතස්ත්වාං ව්‍යාහරාමි, ඒතස්‍යා බහු පාපමක්‍ෂම්‍යත තතෝ බහු ප්‍රීයතේ කින්තු යස්‍යාල්පපාපං ක්‍ෂම්‍යතේ සෝල්පං ප්‍රීයතේ| ");
INSERT INTO sansin_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","තතඃ පරං ස තාං බභාෂේ, ත්වදීයං පාපමක්‍ෂම්‍යත| ");
INSERT INTO sansin_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","තදා තේන සාර්ද්ධං යේ භෝක්තුම් උපවිවිශුස්තේ පරස්පරං වක්තුමාරේභිරේ, අයං පාපං ක්‍ෂමතේ ක ඒෂඃ? ");
INSERT INTO sansin_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","කින්තු ස තාං නාරීං ජගාද, තව විශ්වාසස්ත්වාං පර‍්‍ය්‍යත්‍රාස්ත ත්වං ක්‍ෂේමේණ ව්‍රජ| ");
INSERT INTO sansin_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","අපරඤ්ච යීශු ර්ද්වාදශභිඃ ශිෂ්‍යෛඃ සාර්ද්ධං නානානගරේෂු නානාග්‍රාමේෂු ච ගච්ඡන් ඉශ්වරීයරාජත්වස්‍ය සුසංවාදං ප්‍රචාරයිතුං ප්‍රාරේභේ| ");
INSERT INTO sansin_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","තදා යස්‍යාඃ සප්ත භූතා නිරගච්ඡන් සා මග්දලීනීති විඛ්‍යාතා මරියම් හේරෝද්‍රාජස්‍ය ගෘහාධිපතේඃ හෝෂේ ර්භාර‍්‍ය්‍යා යෝහනා ශූශානා ");
INSERT INTO sansin_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ප්‍රභෘතයෝ යා බහ්ව්‍යඃ ස්ත්‍රියඃ දුෂ්ටභූතේභ්‍යෝ රෝගේභ්‍යශ්ච මුක්තාඃ සත්‍යෝ නිජවිභූතී ර්ව්‍යයිත්වා තමසේවන්ත, තාඃ සර්ව්වාස්තේන සාර්ද්ධම් ආසන්| ");
INSERT INTO sansin_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","අනන්තරං නානානගරේභ්‍යෝ බහවෝ ලෝකා ආගත්‍ය තස්‍ය සමීපේ(අ)මිලන්, තදා ස තේභ්‍ය ඒකාං දෘෂ්ටාන්තකථාං කථයාමාස| ඒකඃ කෘෂීබලෝ බීජානි වප්තුං බහිර්ජගාම, ");
INSERT INTO sansin_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","තතෝ වපනකාලේ කතිපයානි බීජානි මාර්ගපාර්ශ්වේ පේතුඃ, තතස්තානි පදතලෛ ර්දලිතානි පක්‍ෂිභි ර්භක්‍ෂිතානි ච| ");
INSERT INTO sansin_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","කතිපයානි බීජානි පාෂාණස්ථලේ පතිතානි යද්‍යපි තාන්‍යඞ්කුරිතානි තථාපි රසාභාවාත් ශුශුෂුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","කතිපයානි බීජානි කණ්ටකිවනමධ්‍යේ පතිතානි තතඃ කණ්ටකිවනානි සංවෘද්ධ්‍ය තානි ජග්‍රසුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","තදන්‍යානි කතිපයබීජානි ච භූම්‍යාමුත්තමායාං පේතුස්තතස්තාන්‍යඞ්කුරයිත්වා ශතගුණානි ඵලානි ඵේලුඃ| ස ඉමා කථාං කථයිත්වා ප්‍රෝච්චෛඃ ප්‍රෝවාච, යස්‍ය ශ්‍රෝතුං ශ්‍රෝත්‍රේ ස්තඃ ස ශෘණෝතු| ");
INSERT INTO sansin_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","තතඃ පරං ශිෂ්‍යාස්තං පප්‍රච්ඡුරස්‍ය දෘෂ්ටාන්තස්‍ය කිං තාත්පර‍්‍ය්‍යං? ");
INSERT INTO sansin_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","තතඃ ස ව්‍යාජහාර, ඊශ්වරීයරාජ්‍යස්‍ය ගුහ්‍යානි ඥාතුං යුෂ්මභ්‍යමධිකාරෝ දීයතේ කින්ත්වන්‍යේ යථා දෘෂ්ට්වාපි න පශ්‍යන්ති ශ්‍රුත්වාපි ම බුධ්‍යන්තේ ච තදර්ථං තේෂාං පුරස්තාත් තාඃ සර්ව්වාඃ කථා දෘෂ්ටාන්තේන කථ්‍යන්තේ| ");
INSERT INTO sansin_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","දෘෂ්ටාන්තස්‍යාස්‍යාභිප්‍රායඃ, ඊශ්වරීයකථා බීජස්වරූපා| ");
INSERT INTO sansin_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","යේ කථාමාත්‍රං ශෘණ්වන්ති කින්තු පශ්චාද් විශ්වස්‍ය යථා පරිත්‍රාණං න ප්‍රාප්නුවන්ති තදාශයේන ශෛතානේත්‍ය හෘදයාතෘ තාං කථාම් අපහරති ත ඒව මාර්ගපාර්ශ්වස්ථභූමිස්වරූපාඃ| ");
INSERT INTO sansin_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","යේ කථං ශ්‍රුත්වා සානන්දං ගෘහ්ලන්ති කින්ත්වබද්ධමූලත්වාත් ස්වල්පකාලමාත්‍රං ප්‍රතීත්‍ය පරීක්‍ෂාකාලේ භ්‍රශ්‍යන්ති තඒව පාෂාණභූමිස්වරූපාඃ| ");
INSERT INTO sansin_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","යේ කථාං ශ්‍රුත්වා යාන්ති විෂයචින්තායාං ධනලෝභේන ඒेහිකසුඛේ ච මජ්ජන්ත උපයුක්තඵලානි න ඵලන්ති ත ඒවෝප්තබීජකණ්ටකිභූස්වරූපාඃ| ");
INSERT INTO sansin_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","කින්තු යේ ශ්‍රුත්වා සරලෛඃ ශුද්ධෛශ්චාන්තඃකරණෛඃ කථාං ගෘහ්ලන්ති ධෛර‍්‍ය්‍යම් අවලම්බ්‍ය ඵලාන්‍යුත්පාදයන්ති ච ත ඒවෝත්තමමෘත්ස්වරූපාඃ| ");
INSERT INTO sansin_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","අපරඤ්ච ප්‍රදීපං ප්‍රජ්වාල්‍ය කෝපි පාත්‍රේණ නාච්ඡාදයති තථා ඛට්වාධෝපි න ස්ථාපයති, කින්තු දීපාධාරෝපර‍්‍ය්‍යේව ස්ථාපයති, තස්මාත් ප්‍රවේශකා දීප්තිං පශ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","යන්න ප්‍රකාශයිෂ්‍යතේ තාදෘග් අප්‍රකාශිතං වස්තු කිමපි නාස්ති යච්ච න සුව්‍යක්තං ප්‍රචාරයිෂ්‍යතේ තාදෘග් ගෘප්තං වස්තු කිමපි නාස්ති| ");
INSERT INTO sansin_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","අතෝ යූයං කේන ප්‍රකාරේණ ශෘණුථ තත්‍ර සාවධානා භවත, යස්‍ය සමීපේ බර්ද්ධතේ තස්මෛ පුනර්දාස්‍යතේ කින්තු යස්‍යාශ්‍රයේ න බර්ද්ධතේ තස්‍ය යද්‍යදස්ති තදපි තස්මාත් නේෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","අපරඤ්ච යීශෝ ර්මාතා භ්‍රාතරශ්ච තස්‍ය සමීපං ජිගමිෂවඃ ");
INSERT INTO sansin_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","කින්තු ජනතාසම්බාධාත් තත්සන්නිධිං ප්‍රාප්තුං න ශේකුඃ| තත්පශ්චාත් තව මාතා භ්‍රාතරශ්ච ත්වාං සාක්‍ෂාත් චිකීර්ෂන්තෝ බහිස්තිෂ්ඨනතීති වාර්ත්තායාං තස්මෛ කථිතායාං ");
INSERT INTO sansin_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ස ප්‍රත්‍යුවාච; යේ ජනා ඊශ්වරස්‍ය කථාං ශ්‍රුත්වා තදනුරූපමාචරන්ති තඒව මම මාතා භ්‍රාතරශ්ච| ");
INSERT INTO sansin_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","අනන්තරං ඒකදා යීශුඃ ශිෂ්‍යෛඃ සාර්ද්ධං නාවමාරුහ්‍ය ජගාද, ආයාත වයං හ්‍රදස්‍ය පාරං යාමඃ, තතස්තේ ජග්මුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","තේෂු නෞකාං වාහයත්සු ස නිදද්‍රෞ; ");
INSERT INTO sansin_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","අථාකස්මාත් ප්‍රබලඣඤ්භ්ශගමාද් හ්‍රදේ නෞකායාං තරඞ්ගෛරාච්ඡන්නායාං විපත් තාන් ජග්‍රාස| තස්මාද් යීශෝරන්තිකං ගත්වා හේ ගුරෝ හේ ගුරෝ ප්‍රාණා නෝ යාන්තීති ගදිත්වා තං ජාගරයාම්බභූවුඃ| තදා ස උත්ථාය වායුං තරඞ්ගාංශ්ච තර්ජයාමාස තස්මාදුභෞ නිවෘත්‍ය ස්ථිරෞ බභූවතුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ස තාන් බභාෂේ යුෂ්මාකං විශ්වාසඃ ක? තස්මාත්තේ භීතා විස්මිතාශ්ච පරස්පරං ජගදුඃ, අහෝ කීදෘගයං මනුජඃ පවනං පානීයඤ්චාදිශති තදුභයං තදාදේශං වහති| ");
INSERT INTO sansin_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","තතඃ පරං ගාලීල්ප්‍රදේශස්‍ය සම්මුඛස්ථගිදේරීයප්‍රදේශේ නෞකායාං ලගන්ත්‍යාං තටේ(අ)වරෝහමාවාද් ");
INSERT INTO sansin_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","බහුතිථකාලං භූතග්‍රස්ත ඒකෝ මානුෂඃ පුරාදාගත්‍ය තං සාක්‍ෂාච්චකාර| ස මනුෂෝ වාසෝ න පරිදධත් ගෘහේ ච න වසන් කේවලං ශ්මශානම් අධ්‍යුවාස| ");
INSERT INTO sansin_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ස යීශුං දෘෂ්ට්වෛව චීච්ඡබ්දං චකාර තස්‍ය සම්මුඛේ පතිත්වා ප්‍රෝච්චෛර්ජගාද ච, හේ සර්ව්වප්‍රධානේශ්වරස්‍ය පුත්‍ර, මයා සහ තව කඃ සම්බන්ධඃ? ත්වයි විනයං කරෝමි මාං මා යාතය| ");
INSERT INTO sansin_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","යතඃ ස තං මානුෂං ත්‍යක්ත්වා යාතුම් අමේධ්‍යභූතම් ආදිදේශ; ස භූතස්තං මානුෂම් අසකෘද් දධාර තස්මාල්ලෝකාඃ ශෘඞ්ඛලේන නිගඩේන ච බබන්ධුඃ; ස තද් භංක්ත්වා භූතවශත්වාත් මධ්‍යේප්‍රාන්තරං යයෞ| ");
INSERT INTO sansin_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","අනන්තරං යීශුස්තං පප්‍රච්ඡ තව කින්නාම? ස උවාච, මම නාම බාහිනෝ යතෝ බහවෝ භූතාස්තමාශිශ්‍රියුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","අථ භූතා විනයේන ජගදුඃ, ගභීරං ගර්ත්තං ගන්තුං මාඥාපයාස්මාන්| ");
INSERT INTO sansin_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","තදා පර්ව්වතෝපරි වරාහව්‍රජශ්චරති තස්මාද් භූතා විනයේන ප්‍රෝචුඃ, අමුං වරාහව්‍රජම් ආශ්‍රයිතුම් අස්මාන් අනුජානීහි; තතඃ සෝනුජඥෞ| ");
INSERT INTO sansin_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","තතඃ පරං භූතාස්තං මානුෂං විහාය වරාහව්‍රජම් ආශිශ්‍රියුඃ වරාහව්‍රජාශ්ච තත්ක්‍ෂණාත් කටකේන ධාවන්තෝ හ්‍රදේ ප්‍රාණාන් විජෘහුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","තද් දෘෂ්ට්වා ශූකරරක්‍ෂකාඃ පලායමානා නගරං ග්‍රාමඤ්ච ගත්වා තත්සර්ව්වවෘත්තාන්තං කථයාමාසුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","තතඃ කිං වෘත්තම් ඒතද්දර්ශනාර්ථං ලෝකා නිර්ගත්‍ය යීශෝඃ සමීපං යයුඃ, තං මානුෂං ත්‍යක්තභූතං පරිහිතවස්ත්‍රං ස්වස්ථමානුෂවද් යීශෝශ්චරණසන්නිධෞ සූපවිශන්තං විලෝක්‍ය බිභ්‍යුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","යේ ලෝකාස්තස්‍ය භූතග්‍රස්තස්‍ය ස්වාස්ථ්‍යකරණං දදෘශුස්තේ තේභ්‍යඃ සර්ව්වවෘත්තාන්තං කථයාමාසුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","තදනන්තරං තස්‍ය ගිදේරීයප්‍රදේශස්‍ය චතුර්දික්ස්ථා බහවෝ ජනා අතිත්‍රස්තා විනයේන තං ජගදුඃ, භවාන් අස්මාකං නිකටාද් ව්‍රජතු තස්මාත් ස නාවමාරුහ්‍ය තතෝ ව්‍යාඝුට්‍ය ජගාම| ");
INSERT INTO sansin_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","තදානීං ත්‍යක්තභූතමනුජස්තේන සහ ස්ථාතුං ප්‍රාර්ථයාඤ්චක්‍රේ ");
INSERT INTO sansin_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","කින්තු තදර්ථම් ඊශ්වරඃ කීදෘඞ්මහාකර්ම්ම කෘතවාන් ඉති නිවේශනං ගත්වා විඥාපය, යීශුඃ කථාමේතාං කථයිත්වා තං විසසර්ජ| තතඃ ස ව්‍රජිත්වා යීශුස්තදර්ථං යන්මහාකර්ම්ම චකාර තත් පුරස්‍ය සර්ව්වත්‍ර ප්‍රකාශයිතුං ප්‍රාරේභේ| ");
INSERT INTO sansin_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","අථ යීශෞ පරාවෘත්‍යාගතේ ලෝකාස්තං ආදරේණ ජගෘහු ර‍්‍යස්මාත්තේ සර්ව්වේ තමපේක්‍ෂාඤ්චක්‍රිරේ| ");
INSERT INTO sansin_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","තදනන්තරං යායීර්නාම්නෝ භජනගේහස්‍යෛකෝධිප ආගත්‍ය යීශෝශ්චරණයෝඃ පතිත්වා ස්වනිවේශනාගමනාර්ථං තස්මින් විනයං චකාර, ");
INSERT INTO sansin_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","යතස්තස්‍ය ද්වාදශවර්ෂවයස්කා කන්‍යෛකාසීත් සා මෘතකල්පාභවත්| තතස්තස්‍ය ගමනකාලේ මාර්ගේ ලෝකානාං මහාන් සමාගමෝ බභූව| ");
INSERT INTO sansin_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ද්වාදශවර්ෂාණි ප්‍රදරරෝගග්‍රස්තා නානා වෛද්‍යෛශ්චිකිත්සිතා සර්ව්වස්වං ව්‍යයිත්වාපි ස්වාස්ථ්‍යං න ප්‍රාප්තා යා යෝෂිත් සා යීශෝඃ පශ්චාදාගත්‍ය තස්‍ය වස්ත්‍රග්‍රන්ථිං පස්පර්ශ| ");
INSERT INTO sansin_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","තස්මාත් තත්ක්‍ෂණාත් තස්‍යා රක්තස්‍රාවෝ රුද්ධඃ| ");
INSERT INTO sansin_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","තදානීං යීශුරවදත් කේනාහං ස්පෘෂ්ටඃ? තතෝ(අ)නේකෛරනඞ්ගීකෘතේ පිතරස්තස්‍ය සඞ්ගිනශ්චාවදන්, හේ ගුරෝ ලෝකා නිකටස්ථාඃ සන්තස්තව දේහේ ඝර්ෂයන්ති, තථාපි කේනාහං ස්පෘෂ්ටඉති භවාන් කුතඃ පෘච්ඡති? ");
INSERT INTO sansin_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","යීශුඃ කථයාමාස, කේනාප්‍යහං ස්පෘෂ්ටෝ, යතෝ මත්තඃ ශක්ති ර්නිර්ගතේති මයා නිශ්චිතමඥායි| ");
INSERT INTO sansin_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","තදා සා නාරී ස්වයං න ගුප්තේති විදිත්වා කම්පමානා සතී තස්‍ය සම්මුඛේ පපාත; යේන නිමිත්තේන තං පස්පර්ශ ස්පර්ශමාත්‍රාච්ච යේන ප්‍රකාරේණ ස්වස්ථාභවත් තත් සර්ව්වං තස්‍ය සාක්‍ෂාදාචඛ්‍යෞ| ");
INSERT INTO sansin_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","තතඃ ස තාං ජගාද හේ කන්‍යේ සුස්ථිරා භව, තව විශ්වාසස්ත්වාං ස්වස්ථාම් අකාර්ෂීත් ත්වං ක්‍ෂේමේණ යාහි| ");
INSERT INTO sansin_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","යීශෝරේතද්වාක්‍යවදනකාලේ තස්‍යාධිපතේ ර්නිවේශනාත් කශ්චිල්ලෝක ආගත්‍ය තං බභාෂේ, තව කන්‍යා මෘතා ගුරුං මා ක්ලිශාන| ");
INSERT INTO sansin_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","කින්තු යීශුස්තදාකර්ණ්‍යාධිපතිං ව්‍යාජහාර, මා භෛෂීඃ කේවලං විශ්වසිහි තස්මාත් සා ජීවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","අථ තස්‍ය නිවේශනේ ප්‍රාප්තේ ස පිතරං යෝහනං යාකූබඤ්ච කන්‍යායා මාතරං පිතරඤ්ච විනා, අන්‍යං කඤ්චන ප්‍රවේෂ්ටුං වාරයාමාස| ");
INSERT INTO sansin_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","අපරඤ්ච යේ රුදන්ති විලපන්ති ච තාන් සර්ව්වාන් ජනාන් උවාච, යූයං මා රෝදිෂ්ට කන්‍යා න මෘතා නිද්‍රාති| ");
INSERT INTO sansin_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","කින්තු සා නිශ්චිතං මෘතේති ඥාත්වා තේ තමුපජහසුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","පශ්චාත් ස සර්ව්වාන් බහිඃ කෘත්වා කන්‍යායාඃ කරෞ ධෘත්වාජුහුවේ, හේ කන්‍යේ ත්වමුත්තිෂ්ඨ, ");
INSERT INTO sansin_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","තස්මාත් තස්‍යාඃ ප්‍රාණේෂු පුනරාගතේෂු සා තත්ක්‍ෂණාද් උත්තස්‍යෞ| තදානීං තස්‍යෛ කිඤ්චිද් භක්‍ෂ්‍යං දාතුම් ආදිදේශ| ");
INSERT INTO sansin_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","තතස්තස්‍යාඃ පිතරෞ විස්මයං ගතෞ කින්තු ස තාවාදිදේශ ඝටනායා ඒතස්‍යාඃ කථාං කස්මෛචිදපි මා කථයතං| ");
INSERT INTO sansin_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","තතඃ පරං ස ද්වාදශශිෂ්‍යානාහූය භූතාන් ත්‍යාජයිතුං රෝගාන් ප්‍රතිකර්ත්තුඤ්ච තේභ්‍යඃ ශක්තිමාධිපත්‍යඤ්ච දදෞ| ");
INSERT INTO sansin_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","අපරඤ්ච ඊශ්වරීයරාජ්‍යස්‍ය සුසංවාදං ප්‍රකාශයිතුම් රෝගිණාමාරෝග්‍යං කර්ත්තුඤ්ච ප්‍රේරණකාලේ තාන් ජගාද| ");
INSERT INTO sansin_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","යාත්‍රාර්ථං යෂ්ටි ර්වස්ත්‍රපුටකං භක්‍ෂ්‍යං මුද්‍රා ද්විතීයවස්ත්‍රම්, ඒෂාං කිමපි මා ගෘහ්ලීත| ");
INSERT INTO sansin_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","යූයඤ්ච යන්නිවේශනං ප්‍රවිශථ නගරත්‍යාගපර‍්‍ය්‍යනතං තන්නිවේශනේ තිෂ්ඨත| ");
INSERT INTO sansin_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","තත්‍ර යදි කස්‍යචිත් පුරස්‍ය ලෝකා යුෂ්මාකමාතිථ්‍යං න කුර්ව්වන්ති තර්හි තස්මාන්නගරාද් ගමනකාලේ තේෂාං විරුද්ධං සාක්‍ෂ්‍යාර්ථං යුෂ්මාකං පදධූලීඃ සම්පාතයත| ");
INSERT INTO sansin_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","අථ තේ ප්‍රස්ථාය සර්ව්වත්‍ර සුසංවාදං ප්‍රචාරයිතුං පීඩිතාන් ස්වස්ථාන් කර්ත්තුඤ්ච ග්‍රාමේෂු භ්‍රමිතුං ප්‍රාරේභිරේ| ");
INSERT INTO sansin_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ඒතර්හි හේරෝද් රාජා යීශෝඃ සර්ව්වකර්ම්මණාං වාර්ත්තාං ශ්‍රුත්වා භෘශමුද්විවිජේ ");
INSERT INTO sansin_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","යතඃ කේචිදූචුර‍්‍යෝහන් ශ්මශානාදුදතිෂ්ඨත්| කේචිදූචුඃ, ඒලියෝ දර්ශනං දත්තවාන්; ඒවමන්‍යලෝකා ඌචුඃ පූර්ව්වීයඃ කශ්චිද් භවිෂ්‍යද්වාදී සමුත්ථිතඃ| ");
INSERT INTO sansin_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","කින්තු හේරෝදුවාච යෝහනඃ ශිරෝ(අ)හමඡිනදම් ඉදානීං යස්‍යේදෘක්කර්ම්මණාං වාර්ත්තාං ප්‍රාප්නෝමි ස කඃ? අථ ස තං ද්‍රෂ්ටුම් ඓච්ඡත්| ");
INSERT INTO sansin_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","අනන්තරං ප්‍රේරිතාඃ ප්‍රත්‍යාගත්‍ය යානි යානි කර්ම්මාණි චක්‍රුස්තානි යීශවේ කථයාමාසුඃ තතඃ ස තාන් බෛත්සෛදානාමකනගරස්‍ය විජනං ස්ථානං නීත්වා ගුප්තං ජගාම| ");
INSERT INTO sansin_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","පශ්චාල් ලෝකාස්තද් විදිත්වා තස්‍ය පශ්චාද් යයුඃ; තතඃ ස තාන් නයන් ඊශ්වරීයරාජ්‍යස්‍ය ප්‍රසඞ්ගමුක්තවාන්, යේෂාං චිකිත්සයා ප්‍රයෝජනම් ආසීත් තාන් ස්වස්ථාන් චකාර ච| ");
INSERT INTO sansin_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","අපරඤ්ච දිවාවසන්නේ සති ද්වාදශශිෂ්‍යා යීශෝරන්තිකම් ඒත්‍ය කථයාමාසුඃ, වයමත්‍ර ප්‍රාන්තරස්ථානේ තිෂ්ඨාමඃ, තතෝ නගරාණි ග්‍රාමාණි ගත්වා වාසස්ථානානි ප්‍රාප්‍ය භක්‍ෂ්‍යද්‍රව්‍යාණි ක්‍රේතුං ජනනිවහං භවාන් විසෘජතු| ");
INSERT INTO sansin_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","තදා ස උවාච, යූයමේව තාන් භේජයධ්වං; තතස්තේ ප්‍රෝචුරස්මාකං නිකටේ කේවලං පඤ්ච පූපා ද්වෞ මත්ස්‍යෞ ච විද්‍යන්තේ, අතඒව ස්ථානාන්තරම් ඉත්වා නිමිත්තමේතේෂාං භක්‍ෂ්‍යද්‍රව්‍යේෂු න ක්‍රීතේෂු න භවති| ");
INSERT INTO sansin_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","තත්‍ර ප්‍රායේණ පඤ්චසහස්‍රාණි පුරුෂා ආසන්| ");
INSERT INTO sansin_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","තදා ස ශිෂ්‍යාන් ජගාද පඤ්චාශත් පඤ්චාශජ්ජනෛඃ පංක්තීකෘත්‍ය තානුපවේශයත, තස්මාත් තේ තදනුසාරේණ සර්ව්වලෝකානුපවේශයාපාසුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","තතඃ ස තාන් පඤ්ච පූපාන් මීනද්වයඤ්ච ගෘහීත්වා ස්වර්ගං විලෝක්‍යේශ්වරගුණාන් කීර්ත්තයාඤ්චක්‍රේ භඞ්ක්තා ච ලෝකේභ්‍යඃ පරිවේෂණාර්ථං ශිෂ්‍යේෂු සමර්පයාම්බභූව| ");
INSERT INTO sansin_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","තතඃ සර්ව්වේ භුක්ත්වා තෘප්තිං ගතා අවශිෂ්ටානාඤ්ච ද්වාදශ ඩල්ලකාන් සංජගෘහුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","අථෛකදා නිර්ජනේ ශිෂ්‍යෛඃ සහ ප්‍රාර්ථනාකාලේ තාන් පප්‍රච්ඡ, ලෝකා මාං කං වදන්ති? ");
INSERT INTO sansin_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","තතස්තේ ප්‍රාචුඃ, ත්වාං යෝහන්මජ්ජකං වදන්ති; කේචිත් ත්වාම් ඒලියං වදන්ති, පූර්ව්වකාලිකඃ කශ්චිද් භවිෂ්‍යද්වාදී ශ්මශානාද් උදතිෂ්ඨද් ඉත්‍යපි කේචිද් වදන්ති| ");
INSERT INTO sansin_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","තදා ස උවාච, යූයං මාං කං වදථ? තතඃ පිතර උක්තවාන් ත්වම් ඊශ්වරාභිෂික්තඃ පුරුෂඃ| ");
INSERT INTO sansin_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","තදා ස තාන් දෘඪමාදිදේශ, කථාමේතාං කස්මෛචිදපි මා කථයත| ");
INSERT INTO sansin_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ස පුනරුවාච, මනුෂ්‍යපුත්‍රේණ වහුයාතනා භෝක්තව්‍යාඃ ප්‍රාචීනලෝකෛඃ ප්‍රධානයාජකෛරධ්‍යාපකෛශ්ච සෝවඥාය හන්තව්‍යඃ කින්තු තෘතීයදිවසේ ශ්මශානාත් තේනෝත්ථාතව්‍යම්| ");
INSERT INTO sansin_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","අපරං ස සර්ව්වානුවාච, කශ්චිද් යදි මම පශ්චාද් ගන්තුං වාඤ්ඡති තර්හි ස ස්වං දාම්‍යතු, දිනේ දිනේ ක්‍රුශං ගෘහීත්වා ච මම පශ්චාදාගච්ඡතු| ");
INSERT INTO sansin_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","යතෝ යඃ කශ්චිත් ස්වප්‍රාණාන් රිරක්‍ෂිෂති ස තාන් හාරයිෂ්‍යති, යඃ කශ්චින් මදර්ථං ප්‍රාණාන් හාරයිෂ්‍යති ස තාන් රක්‍ෂිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","කශ්චිද් යදි සර්ව්වං ජගත් ප්‍රාප්නෝති කින්තු ස්වප්‍රාණාන් හාරයති ස්වයං විනශ්‍යති ච තර්හි තස්‍ය කෝ ලාභඃ? ");
INSERT INTO sansin_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","පුන ර‍්‍යඃ කශ්චින් මාං මම වාක්‍යං වා ලජ්ජාස්පදං ජානාති මනුෂ්‍යපුත්‍රෝ යදා ස්වස්‍ය පිතුශ්ච පවිත්‍රාණාං දූතානාඤ්ච තේජෝභිඃ පරිවේෂ්ටිත ආගමිෂ්‍යති තදා සෝපි තං ලජ්ජාස්පදං ඥාස්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","කින්තු යුෂ්මානහං යථාර්ථං වදාමි, ඊශ්වරීයරාජත්වං න දෘෂ්ටවා මෘත්‍යුං නාස්වාදිෂ්‍යන්තේ, ඒතාදෘශාඃ කියන්තෝ ලෝකා අත්‍ර ස්ථනේ(අ)පි දණ්ඩායමානාඃ සන්ති| ");
INSERT INTO sansin_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ඒතදාඛ්‍යානකථනාත් පරං ප්‍රායේණාෂ්ටසු දිනේෂු ගතේෂු ස පිතරං යෝහනං යාකූබඤ්ච ගෘහීත්වා ප්‍රාර්ථයිතුං පර්ව්වතමේකං සමාරුරෝහ| ");
INSERT INTO sansin_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","අථ තස්‍ය ප්‍රාර්ථනකාලේ තස්‍ය මුඛාකෘතිරන්‍යරූපා ජාතා, තදීයං වස්ත්‍රමුජ්ජ්වලශුක්ලං ජාතං| ");
INSERT INTO sansin_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","අපරඤ්ච මූසා ඒලියශ්චෝභෞ තේජස්විනෞ දෘෂ්ටෞ ");
INSERT INTO sansin_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","තෞ තේන යිරූශාලම්පුරේ යෝ මෘත්‍යුඃ සාධිෂ්‍යතේ තදීයාං කථාං තේන සාර්ද්ධං කථයිතුම් ආරේභාතේ| ");
INSERT INTO sansin_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","තදා පිතරාදයඃ ස්වස්‍ය සඞ්ගිනෝ නිද්‍රයාකෘෂ්ටා ආසන් කින්තු ජාගරිත්වා තස්‍ය තේජස්තේන සාර්ද්ධම් උත්තිෂ්ඨන්තෞ ජනෞ ච දදෘශුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","අථ තයෝරුභයෝ ර්ගමනකාලේ පිතරෝ යීශුං බභාෂේ, හේ ගුරෝ(අ)ස්මාකං ස්ථානේ(අ)ස්මින් ස්ථිතිඃ ශුභා, තත ඒකා ත්වදර්ථා, ඒකා මූසාර්ථා, ඒකා ඒලියාර්ථා, ඉති තිස්‍රඃ කුට්‍යෝස්මාභි ර්නිර්ම්මීයන්තාං, ඉමාං කථාං ස න විවිච්‍ය කථයාමාස| ");
INSERT INTO sansin_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","අපරඤ්ච තද්වාක්‍යවදනකාලේ පයෝද ඒක ආගත්‍ය තේෂාමුපරි ඡායාං චකාර, තතස්තන්මධ්‍යේ තයෝඃ ප්‍රවේශාත් තේ ශශඞ්කිරේ| ");
INSERT INTO sansin_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","තදා තස්මාත් පයෝදාද් ඉයමාකාශීයා වාණී නිර්ජගාම, මමායං ප්‍රියඃ පුත්‍ර ඒතස්‍ය කථායාං මනෝ නිධත්ත| ");
INSERT INTO sansin_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ඉති ශබ්දේ ජාතේ තේ යීශුමේකාකිනං දදෘශුඃ කින්තු තේ තදානීං තස්‍ය දර්ශනස්‍ය වාචමේකාමපි නෝක්ත්වා මනඃසු ස්ථාපයාමාසුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","පරේ(අ)හනි තේෂු තස්මාච්ඡෛලාද් අවරූඪේෂු තං සාක්‍ෂාත් කර්ත්තුං බහවෝ ලෝකා ආජග්මුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","තේෂාං මධ්‍යාද් ඒකෝ ජන උච්චෛරුවාච, හේ ගුරෝ අහං විනයං කරෝමි මම පුත්‍රං ප්‍රති කෘපාදෘෂ්ටිං කරෝතු, මම ස ඒවෛකඃ පුත්‍රඃ| ");
INSERT INTO sansin_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","භූතේන ධෘතඃ සන් සං ප්‍රසභං චීච්ඡබ්දං කරෝති තන්මුඛාත් ඵේණා නිර්ගච්ඡන්ති ච, භූත ඉත්ථං විදාර‍්‍ය්‍ය ක්ලිෂ්ට්වා ප්‍රායශස්තං න ත්‍යජති| ");
INSERT INTO sansin_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","තස්මාත් තං භූතං ත්‍යාජයිතුං තව ශිෂ්‍යසමීපේ න්‍යවේදයං කින්තු තේ න ශේකුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","තදා යීශුරවාදීත්, රේ ආවිශ්වාසින් විපථගාමින් වංශ කතිකාලාන් යුෂ්මාභිඃ සහ ස්ථාස්‍යාම්‍යහං යුෂ්මාකම් ආචරණානි ච සහිෂ්‍යේ? තව පුත්‍රමිහානය| ");
INSERT INTO sansin_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","තතස්තස්මින්නාගතමාත්‍රේ භූතස්තං භූමෞ පාතයිත්වා විදදාර; තදා යීශුස්තමමේධ්‍යං භූතං තර්ජයිත්වා බාලකං ස්වස්ථං කෘත්වා තස්‍ය පිතරි සමර්පයාමාස| ");
INSERT INTO sansin_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ඊශ්වරස්‍ය මහාශක්තිම් ඉමාං විලෝක්‍ය සර්ව්වේ චමච්චක්‍රුඃ; ඉත්ථං යීශෝඃ සර්ව්වාභිඃ ක්‍රියාභිඃ සර්ව්වෛර්ලෝකෛරාශ්චර‍්‍ය්‍යේ මන්‍යමානේ සති ස ශිෂ්‍යාන් බභාෂේ, ");
INSERT INTO sansin_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","කථේයං යුෂ්මාකං කර්ණේෂු ප්‍රවිශතු, මනුෂ්‍යපුත්‍රෝ මනුෂ්‍යාණාං කරේෂු සමර්පයිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","කින්තු තේ තාං කථාං න බුබුධිරේ, ස්පෂ්ටත්වාභාවාත් තස්‍යා අභිප්‍රායස්තේෂාං බෝධගම්‍යෝ න බභූව; තස්‍යා ආශයඃ ක ඉත්‍යපි තේ භයාත් ප්‍රෂ්ටුං න ශේකුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","තදනන්තරං තේෂාං මධ්‍යේ කඃ ශ්‍රේෂ්ඨඃ කථාමේතාං ගෘහීත්වා තේ මිථෝ විවාදං චක්‍රුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","තතෝ යීශුස්තේෂාං මනෝභිප්‍රායං විදිත්වා බාලකමේකං ගෘහීත්වා ස්වස්‍ය නිකටේ ස්ථාපයිත්වා තාන් ජගාද, ");
INSERT INTO sansin_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","යෝ ජනෝ මම නාම්නාස්‍ය බාලාස්‍යාතිථ්‍යං විදධාති ස මමාතිථ්‍යං විදධාති, යශ්ච මමාතිථ්‍යං විදධාති ස මම ප්‍රේරකස්‍යාතිථ්‍යං විදධාති, යුෂ්මාකං මධ්‍යේයඃ ස්වං සර්ව්වස්මාත් ක්‍ෂුද්‍රං ජානීතේ ස ඒව ශ්‍රේෂ්ඨෝ භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","අපරඤ්ච යෝහන් ව්‍යාජහාර හේ ප්‍රභේा තව නාම්නා භූතාන් ත්‍යාජයන්තං මානුෂම් ඒකං දෘෂ්ටවන්තෝ වයං, කින්ත්වස්මාකම් අපශ්චාද් ගාමිත්වාත් තං න්‍යෂේධාම්| තදානීං යීශුරුවාච, ");
INSERT INTO sansin_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","තං මා නිෂේධත, යතෝ යෝ ජනෝස්මාකං න විපක්‍ෂඃ ස ඒවාස්මාකං සපක්‍ෂෝ භවති| ");
INSERT INTO sansin_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","අනන්තරං තස්‍යාරෝහණසමය උපස්ථිතේ ස ස්ථිරචේතා යිරූශාලමං ප්‍රති යාත්‍රාං කර්ත්තුං නිශ්චිත්‍යාග්‍රේ දූතාන් ප්‍රේෂයාමාස| ");
INSERT INTO sansin_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","තස්මාත් තේ ගත්වා තස්‍ය ප්‍රයෝජනීයද්‍රව්‍යාණි සංග්‍රහීතුං ශෝමිරෝණීයානාං ග්‍රාමං ප්‍රවිවිශුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","කින්තු ස යිරූශාලමං නගරං යාති තතෝ හේතෝ ර්ලෝකාස්තස්‍යාතිථ්‍යං න චක්‍රුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","අතඒව යාකූබ්‍යෝහනෞ තස්‍ය ශිෂ්‍යෞ තද් දෘෂ්ට්වා ජගදතුඃ, හේ ප්‍රභෝ ඒලියෝ යථා චකාර තථා වයමපි කිං ගගණාද් ආගන්තුම් ඒතාන් භස්මීකර්ත්තුඤ්ච වහ්නිමාඥාපයාමඃ? භවාන් කිමිච්ඡති? ");
INSERT INTO sansin_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","කින්තු ස මුඛං පරාවර්ත්‍ය තාන් තර්ජයිත්වා ගදිතවාන් යුෂ්මාකං මනෝභාවඃ කඃ, ඉති යූයං න ජානීථ| ");
INSERT INTO sansin_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","මනුජසුතෝ මනුජානාං ප්‍රාණාන් නාශයිතුං නාගච්ඡත්, කින්තු රක්‍ෂිතුම් ආගච්ඡත්| පශ්චාද් ඉතරග්‍රාමං තේ යයුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","තදනන්තරං පථි ගමනකාලේ ජන ඒකස්තං බභාෂේ, හේ ප්‍රභෝ භවාන් යත්‍ර යාති භවතා සහාහමපි තත්‍ර යාස්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","තදානීං යීශුස්තමුවාච, ගෝමායූනාං ගර්ත්තා ආසතේ, විහායසීයවිහගාाනාං නීඩානි ච සන්ති, කින්තු මානවතනයස්‍ය ශිරඃ ස්ථාපයිතුං ස්ථානං නාස්ති| ");
INSERT INTO sansin_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","තතඃ පරං ස ඉතරජනං ජගාද, ත්වං මම පශ්චාද් ඒහි; තතඃ ස උවාච, හේ ප්‍රභෝ පූර්ව්වං පිතරං ශ්මශානේ ස්ථාපයිතුං මාමාදිශතු| ");
INSERT INTO sansin_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","තදා යීශුරුවාච, මෘතා මෘතාන් ශ්මශානේ ස්ථාපයන්තු කින්තු ත්වං ගත්වේශ්වරීයරාජ්‍යස්‍ය කථාං ප්‍රචාරය| ");
INSERT INTO sansin_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","තතෝන්‍යඃ කථයාමාස, හේ ප්‍රභෝ මයාපි භවතඃ පශ්චාද් ගංස්‍යතේ, කින්තු පූර්ව්වං මම නිවේශනස්‍ය පරිජනානාම් අනුමතිං ග්‍රහීතුම් අහමාදිශ්‍යෛ භවතා| ");
INSERT INTO sansin_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","තදානීං යීශුස්තං ප්‍රෝක්තවාන්, යෝ ජනෝ ලාඞ්ගලේ කරමර්පයිත්වා පශ්චාත් පශ්‍යති ස ඊශ්වරීයරාජ්‍යං නාර්හති| ");
INSERT INTO sansin_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","තතඃ පරං ප්‍රභුරපරාන් සප්තතිශිෂ්‍යාන් නියුජ්‍ය ස්වයං යානි නගරාණි යානි ස්ථානානි ච ගමිෂ්‍යති තානි නගරාණි තානි ස්ථානානි ච ප්‍රති ද්වෞ ද්වෞ ජනෞ ප්‍රහිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","තේභ්‍යඃ කථයාමාස ච ශස්‍යානි බහූනීති සත්‍යං කින්තු ඡේදකා අල්පේ; තස්මාද්ධේතෝඃ ශස්‍යක්‍ෂේත්‍රේ ඡේදකාන් අපරානපි ප්‍රේෂයිතුං ක්‍ෂේත්‍රස්වාමිනං ප්‍රාර්ථයධ්වං| ");
INSERT INTO sansin_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","යූයං යාත, පශ්‍යත, වෘකාණාං මධ්‍යේ මේෂශාවකානිව යුෂ්මාන් ප්‍රහිණෝමි| ");
INSERT INTO sansin_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","යූයං ක්‍ෂුද්‍රං මහද් වා වසනසම්පුටකං පාදුකාශ්ච මා ගෘහ්ලීත, මාර්ගමධ්‍යේ කමපි මා නමත ච| ");
INSERT INTO sansin_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","අපරඤ්ච යූයං යද් යත් නිවේශනං ප්‍රවිශථ තත්‍ර නිවේශනස්‍යාස්‍ය මඞ්ගලං භූයාදිති වාක්‍යං ප්‍රථමං වදත| ");
INSERT INTO sansin_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","තස්මාත් තස්මින් නිවේශනේ යදි මඞ්ගලපාත්‍රං ස්ථාස්‍යති තර්හි තන්මඞ්ගලං තස්‍ය භවිෂ්‍යති, නෝචේත් යුෂ්මාන් ප්‍රති පරාවර්ත්තිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","අපරඤ්ච තේ යත්කිඤ්චිද් දාස්‍යන්ති තදේව භුක්ත්වා පීත්වා තස්මින්නිවේශනේ ස්ථාස්‍යථ; යතඃ කර්ම්මකාරී ජනෝ භෘතිම් අර්හති; ගෘහාද් ගෘහං මා යාස්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","අන්‍යච්ච යුෂ්මාසු කිමපි නගරං ප්‍රවිෂ්ටේෂු ලෝකා යදි යුෂ්මාකම් ආතිථ්‍යං කරිෂ්‍යන්ති, තර්හි යත් ඛාද්‍යම් උපස්ථාස්‍යන්ති තදේව ඛාදිෂ්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","තන්නගරස්ථාන් රෝගිණඃ ස්වස්ථාන් කරිෂ්‍යථ, ඊශ්වරීයං රාජ්‍යං යුෂ්මාකම් අන්තිකම් ආගමත් කථාමේතාඤ්ච ප්‍රචාරයිෂ්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","කින්තු කිමපි පුරං යුෂ්මාසු ප්‍රවිෂ්ටේෂු ලෝකා යදි යුෂ්මාකම් ආතිථ්‍යං න කරිෂ්‍යන්ති, තර්හි තස්‍ය නගරස්‍ය පන්ථානං ගත්වා කථාමේතාං වදිෂ්‍යථ, ");
INSERT INTO sansin_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","යුෂ්මාකං නගරීයා යා ධූල්‍යෝ(අ)ස්මාසු සමලගන් තා අපි යුෂ්මාකං ප්‍රාතිකූල්‍යේන සාක්‍ෂ්‍යාර්ථං සම්පාතයාමඃ; තථාපීශ්වරරාජ්‍යං යුෂ්මාකං සමීපම් ආගතම් ඉති නිශ්චිතං ජානීත| ");
INSERT INTO sansin_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","අහං යුෂ්මභ්‍යං යථාර්ථං කථයාමි, විචාරදිනේ තස්‍ය නගරස්‍ය දශාතඃ සිදෝමෝ දශා සහ්‍යා භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","හා හා කෝරාසීන් නගර, හා හා බෛත්සෛදානගර යුවයෝර්මධ්‍යේ යාදෘශානි ආශ්චර‍්‍ය්‍යාණි කර්ම්මාණ්‍යක්‍රියන්ත, තානි කර්ම්මාණි යදි සෝරසීදෝනෝ ර්නගරයෝරකාරිෂ්‍යන්ත, තදා ඉතෝ බහුදිනපූර්ව්වං තන්නිවාසිනඃ ශණවස්ත්‍රාණි පරිධාය ගාත්‍රේෂු භස්ම විලිප්‍ය සමුපවිශ්‍ය සමඛේත්ස්‍යන්ත| ");
INSERT INTO sansin_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","අතෝ විචාරදිවසේ යුෂ්මාකං දශාතඃ සෝරසීදෝන්නිවාසිනාං දශා සහ්‍යා භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","හේ කඵර්නාහූම්, ත්වං ස්වර්ගං යාවද් උන්නතා කින්තු නරකං යාවත් න්‍යග්භවිෂ්‍යසි| ");
INSERT INTO sansin_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","යෝ ජනෝ යුෂ්මාකං වාක්‍යං ගෘහ්ලාති ස මමෛව වාක්‍යං ගෘහ්ලාති; කිඤ්ච යෝ ජනෝ යුෂ්මාකම් අවඥාං කරෝති ස මමෛවාවඥාං කරෝති; යෝ ජනෝ මමාවඥාං කරෝති ච ස මත්ප්‍රේරකස්‍යෛවාවඥාං කරෝති| ");
INSERT INTO sansin_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","අථ තේ සප්තතිශිෂ්‍යා ආනන්දේන ප්‍රත්‍යාගත්‍ය කථයාමාසුඃ, හේ ප්‍රභෝ භවතෝ නාම්නා භූතා අප්‍යස්මාකං වශීභවන්ති| ");
INSERT INTO sansin_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","තදානීං ස තාන් ජගාද, විද්‍යුතමිව ස්වර්ගාත් පතන්තං ශෛතානම් අදර්ශම්| ");
INSERT INTO sansin_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","පශ්‍යත සර්පාන් වෘශ්චිකාන් රිපෝඃ සර්ව්වපරාක්‍රමාංශ්ච පදතලෛ ර්දලයිතුං යුෂ්මභ්‍යං ශක්තිං දදාමි තස්මාද් යුෂ්මාකං කාපි හානි ර්න භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","භූතා යුෂ්මාකං වශීභවන්ති, ඒතන්නිමිත්තත් මා සමුල්ලසත, ස්වර්ගේ යුෂ්මාකං නාමානි ලිඛිතානි සන්තීති නිමිත්තං සමුල්ලසත| ");
INSERT INTO sansin_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","තද්ඝටිකායාං යීශු ර්මනසි ජාතාහ්ලාදඃ කථයාමාස හේ ස්වර්ගපෘථිව්‍යෝරේකාධිපතේ පිතස්ත්වං ඥානවතාං විදුෂාඤ්ච ලෝකානාං පුරස්තාත් සර්ව්වමේතද් අප්‍රකාශ්‍ය බාලකානාං පුරස්තාත් ප්‍රාකාශය ඒතස්මාද්ධේතෝස්ත්වාං ධන්‍යං වදාමි, හේ පිතරිත්ථං භවතු යද් ඒතදේව තව ගෝචර උත්තමම්| ");
INSERT INTO sansin_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","පිත්‍රා සර්ව්වාණි මයි සමර්පිතානි පිතරං විනා කෝපි පුත්‍රං න ජානාති කිඤ්ච පුත්‍රං විනා යස්මෛ ජනාය පුත්‍රස්තං ප්‍රකාශිතවාන් තඤ්ච විනා කෝපි පිතරං න ජානාති| ");
INSERT INTO sansin_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","තපඃ පරං ස ශිෂ්‍යාන් ප්‍රති පරාවෘත්‍ය ගුප්තං ජගාද, යූයමේතානි සර්ව්වාණි පශ්‍යථ තතෝ යුෂ්මාකං චක්‍ෂූංෂි ධන්‍යානි| ");
INSERT INTO sansin_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","යුෂ්මානහං වදාමි, යූයං යානි සර්ව්වාණි පශ්‍යථ තානි බහවෝ භවිෂ්‍යද්වාදිනෝ භූපතයශ්ච ද්‍රෂ්ටුමිච්ඡන්තෝපි ද්‍රෂ්ටුං න ප්‍රාප්නුවන්, යුෂ්මාභි ර‍්‍යා යාඃ කථාශ්ච ශ්‍රූයන්තේ තාඃ ශ්‍රෝතුමිච්ඡන්තෝපි ශ්‍රෝතුං නාලභන්ත| ");
INSERT INTO sansin_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","අනන්තරම් ඒකෝ ව්‍යවස්ථාපක උත්ථාය තං පරීක්‍ෂිතුං පප්‍රච්ඡ, හේ උපදේශක අනන්තායුෂඃ ප්‍රාප්තයේ මයා කිං කරණීයං? ");
INSERT INTO sansin_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","යීශුඃ ප්‍රත්‍යුවාච, අත්‍රාර්ථේ ව්‍යවස්ථායාං කිං ලිඛිතමස්ති? ත්වං කීදෘක් පඨසි? ");
INSERT INTO sansin_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","තතඃ සෝවදත්, ත්වං සර්ව්වාන්තඃකරණෛඃ සර්ව්වප්‍රාණෛඃ සර්ව්වශක්තිභිඃ සර්ව්වචිත්තෛශ්ච ප්‍රභෞ පරමේශ්වරේ ප්‍රේම කුරු, සමීපවාසිනි ස්වවත් ප්‍රේම කුරු ච| ");
INSERT INTO sansin_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","තදා ස කථයාමාස, ත්වං යථාර්ථං ප්‍රත්‍යවෝචඃ, ඉත්ථම් ආචර තේනෛව ජීවිෂ්‍යසි| ");
INSERT INTO sansin_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","කින්තු ස ජනඃ ස්වං නිර්ද්දෝෂං ඥාපයිතුං යීශුං පප්‍රච්ඡ, මම සමීපවාසී කඃ? තතෝ යීශුඃ ප්‍රත්‍යුවාච, ");
INSERT INTO sansin_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ඒකෝ ජනෝ යිරූශාලම්පුරාද් යිරීහෝපුරං යාති, ඒතර්හි දස්‍යූනාං කරේෂු පතිතේ තේ තස්‍ය වස්ත්‍රාදිකං හෘතවන්තඃ තමාහත්‍ය මෘතප්‍රායං කෘත්වා ත්‍යක්ත්වා යයුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","අකස්මාද් ඒකෝ යාජකස්තේන මාර්ගේණ ගච්ඡන් තං දෘෂ්ට්වා මාර්ගාන්‍යපාර්ශ්වේන ජගාම| ");
INSERT INTO sansin_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ඉත්ථම් ඒකෝ ලේවීයස්තත්ස්ථානං ප්‍රාප්‍ය තස්‍යාන්තිකං ගත්වා තං විලෝක්‍යාන්‍යේන පාර්ශ්වේන ජගාම| ");
INSERT INTO sansin_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","කින්ත්වේකඃ ශෝමිරෝණීයෝ ගච්ඡන් තත්ස්ථානං ප්‍රාප්‍ය තං දෘෂ්ට්වාදයත| ");
INSERT INTO sansin_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","තස්‍යාන්තිකං ගත්වා තස්‍ය ක්‍ෂතේෂු තෛලං ද්‍රාක්‍ෂාරසඤ්ච ප්‍රක්‍ෂිප්‍ය ක්‍ෂතානි බද්ධ්වා නිජවාහනෝපරි තමුපවේශ්‍ය ප්‍රවාසීයගෘහම් ආනීය තං සිෂේවේ| ");
INSERT INTO sansin_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","පරස්මින් දිවසේ නිජගමනකාලේ ද්වෞ මුද්‍රාපාදෞ තද්ගෘහස්වාමිනේ දත්ත්වාවදත් ජනමේනං සේවස්ව තත්‍ර යෝ(අ)ධිකෝ ව්‍යයෝ භවිෂ්‍යති තමහං පුනරාගමනකාලේ පරිශෝත්ස්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","ඒෂාං ත්‍රයාණාං මධ්‍යේ තස්‍ය දස්‍යුහස්තපතිතස්‍ය ජනස්‍ය සමීපවාසී කඃ? ත්වයා කිං බුධ්‍යතේ? ");
INSERT INTO sansin_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","තතඃ ස ව්‍යවස්ථාපකඃ කථයාමාස යස්තස්මින් දයාං චකාර| තදා යීශුඃ කථයාමාස ත්වමපි ගත්වා තථාචර| ");
INSERT INTO sansin_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","තතඃ පරං තේ ගච්ඡන්ත ඒකං ග්‍රාමං ප්‍රවිවිශුඃ; තදා මර්ථානාමා ස්ත්‍රී ස්වගෘහේ තස්‍යාතිථ්‍යං චකාර| ");
INSERT INTO sansin_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","තස්මාත් මරියම් නාමධේයා තස්‍යා භගිනී යීශෝඃ පදසමීප උවවිශ්‍ය තස්‍යෝපදේශකථාං ශ්‍රෝතුමාරේභේ| ");
INSERT INTO sansin_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","කින්තු මර්ථා නානාපරිචර‍්‍ය්‍යායාං ව්‍යග්‍රා බභූව තස්මාද්ධේතෝස්තස්‍ය සමීපමාගත්‍ය බභාෂේ; හේ ප්‍රභෝ මම භගිනී කේවලං මමෝපරි සර්ව්වකර්ම්මණාං භාරම් අර්පිතවතී තත්‍ර භවතා කිඤ්චිදපි න මනෝ නිධීයතේ කිම්? මම සාහාය්‍යං කර්ත්තුං භවාන් තාමාදිශතු| ");
INSERT INTO sansin_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","තතෝ යීශුඃ ප්‍රත්‍යුවාච හේ මර්ථේ හේ මර්ථේ, ත්වං නානාකාර‍්‍ය්‍යේෂු චින්තිතවතී ව්‍යග්‍රා චාසි, ");
INSERT INTO sansin_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","කින්තු ප්‍රයෝජනීයම් ඒකමාත්‍රම් ආස්තේ| අපරඤ්ච යමුත්තමං භාගං කෝපි හර්ත්තුං න ශක්නෝති සඒව මරියමා වෘතඃ| ");
INSERT INTO sansin_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","අනන්තරං ස කස්මිංශ්චිත් ස්ථානේ ප්‍රාර්ථයත තත්සමාප්තෞ සත්‍යාං තස්‍යෛකඃ ශිෂ්‍යස්තං ජගාද හේ ප්‍රභෝ යෝහන් යථා ස්වශිෂ්‍යාන් ප්‍රාර්ථයිතුම් උපදිෂ්ටවාන් තථා භවානප්‍යස්මාන් උපදිශතු| ");
INSERT INTO sansin_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","තස්මාත් ස කථයාමාස, ප්‍රාර්ථනකාලේ යූයම් ඉත්ථං කථයධ්වං, හේ අස්මාකං ස්වර්ගස්ථපිතස්තව නාම පූජ්‍යං භවතු; තව රාජත්වං භවතු; ස්වර්ගේ යථා තථා පෘථිව්‍යාමපි තවේච්ඡයා සර්ව්වං භවතු| ");
INSERT INTO sansin_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ප්‍රත්‍යහම් අස්මාකං ප්‍රයෝජනීයං භෝජ්‍යං දේහි| ");
INSERT INTO sansin_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","යථා වයං සර්ව්වාන් අපරාධිනඃ ක්‍ෂමාමහේ තථා ත්වමපි පාපාන්‍යස්මාකං ක්‍ෂමස්ව| අස්මාන් පරීක්‍ෂාං මානය කින්තු පාපාත්මනෝ රක්‍ෂ| ");
INSERT INTO sansin_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","පශ්චාත් සෝපරමපි කථිතවාන් යදි යුෂ්මාකං කස්‍යචිද් බන්ධුස්තිෂ්ඨති නිශීථේ ච තස්‍ය සමීපං ස ගත්වා වදති, ");
INSERT INTO sansin_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","හේ බන්ධෝ පථික ඒකෝ බන්ධු ර්මම නිවේශනම් ආයාතඃ කින්තු තස්‍යාතිථ්‍යං කර්ත්තුං මමාන්තිකේ කිමපි නාස්ති, අතඒව පූපත්‍රයං මහ්‍යම් ඍණං දේහි; ");
INSERT INTO sansin_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","තදා ස යදි ගෘහමධ්‍යාත් ප්‍රතිවදති මාං මා ක්ලිශාන, ඉදානීං ද්වාරං රුද්ධං ශයනේ මයා සහ බාලකාශ්ච තිෂ්ඨන්ති තුභ්‍යං දාතුම් උත්ථාතුං න ශක්නෝමි, ");
INSERT INTO sansin_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","තර්හි යුෂ්මානහං වදාමි, ස යදි මිත්‍රතයා තස්මෛ කිමපි දාතුං නෝත්තිෂ්ඨති තථාපි වාරං වාරං ප්‍රාර්ථනාත උත්ථාපිතඃ සන් යස්මින් තස්‍ය ප්‍රයෝජනං තදේව දාස්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","අතඃ කාරණාත් කථයාමි, යාචධ්වං තතෝ යුෂ්මභ්‍යං දාස්‍යතේ, මෘගයධ්වං තත උද්දේශං ප්‍රාප්ස්‍යථ, ද්වාරම් ආහත තතෝ යුෂ්මභ්‍යං ද්වාරං මෝක්‍ෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","යෝ යාචතේ ස ප්‍රාප්නෝති, යෝ මෘගයතේ ස ඒවෝද්දේශං ප්‍රාප්නෝති, යෝ ද්වාරම් ආහන්ති තදර්ථං ද්වාරං මෝච්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","පුත්‍රේණ පූපේ යාචිතේ තස්මෛ පාෂාණං දදාති වා මත්ස්‍යේ යාචිතේ තස්මෛ සර්පං දදාති ");
INSERT INTO sansin_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","වා අණ්ඩේ යාචිතේ තස්මෛ වෘශ්චිකං දදාති යුෂ්මාකං මධ්‍යේ ක ඒතාදෘශඃ පිතාස්තේ? ");
INSERT INTO sansin_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","තස්මාදේව යූයමභද්‍රා අපි යදි ස්වස්වබාලකේභ්‍ය උත්තමානි ද්‍රව්‍යාණි දාතුං ජානීථ තර්හ්‍යස්මාකං ස්වර්ගස්ථඃ පිතා නිජයාචකේභ්‍යඃ කිං පවිත්‍රම් ආත්මානං න දාස්‍යති? ");
INSERT INTO sansin_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","අනන්තරං යීශුනා කස්මාච්චිද් ඒකස්මින් මූකභූතේ ත්‍යාජිතේ සති ස භූතත්‍යක්තෝ මානුෂෝ වාක්‍යං වක්තුම් ආරේභේ; තතෝ ලෝකාඃ සකලා ආශ්චර‍්‍ය්‍යං මේනිරේ| ");
INSERT INTO sansin_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","කින්තු තේෂාං කේචිදූචු ර්ජනෝයං බාලසිබූබා අර්ථාද් භූතරාජේන භූතාන් ත්‍යාජයති| ");
INSERT INTO sansin_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","තං පරීක්‍ෂිතුං කේචිද් ආකාශීයම් ඒකං චිහ්නං දර්ශයිතුං තං ප්‍රාර්ථයාඤ්චක්‍රිරේ| ");
INSERT INTO sansin_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","තදා ස තේෂාං මනඃකල්පනාං ඥාත්වා කථයාමාස, කස්‍යචිද් රාජ්‍යස්‍ය ලෝකා යදි පරස්පරං විරුන්ධන්ති තර්හි තද් රාජ්‍යම් නශ්‍යති; කේචිද් ගෘහස්ථා යදි පරස්පරං විරුන්ධන්ති තර්හි තේපි නශ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","තථෛව ශෛතානපි ස්වලෝකාන් යදි විරුණද්ධි තදා තස්‍ය රාජ්‍යං කථං ස්ථාස්‍යති? බාලසිබූබාහං භූතාන් ත්‍යාජයාමි යූයමිති වදථ| ");
INSERT INTO sansin_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","යද්‍යහං බාලසිබූබා භූතාන් ත්‍යාජයාමි තර්හි යුෂ්මාකං සන්තානාඃ කේන ත්‍යාජයන්ති? තස්මාත් තඒව කථායා ඒතස්‍යා විචාරයිතාරෝ භවිෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","කින්තු යද්‍යහම් ඊශ්වරස්‍ය පරාක්‍රමේණ භූතාන් ත්‍යාජයාමි තර්හි යුෂ්මාකං නිකටම් ඊශ්වරස්‍ය රාජ්‍යමවශ්‍යම් උපතිෂ්ඨති| ");
INSERT INTO sansin_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","බලවාන් පුමාන් සුසජ්ජමානෝ යතිකාලං නිජාට්ටාලිකාං රක්‍ෂති තතිකාලං තස්‍ය ද්‍රව්‍යං නිරුපද්‍රවං තිෂ්ඨති| ");
INSERT INTO sansin_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","කින්තු තස්මාද් අධිකබලඃ කශ්චිදාගත්‍ය යදි තං ජයති තර්හි යේෂු ශස්ත්‍රාස්ත්‍රේෂු තස්‍ය විශ්වාස ආසීත් තානි සර්ව්වාණි හෘත්වා තස්‍ය ද්‍රව්‍යාණි ගෘහ්ලාති| ");
INSERT INTO sansin_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","අතඃ කාරණාද් යෝ මම සපක්‍ෂෝ න ස විපක්‍ෂඃ, යෝ මයා සහ න සංගෘහ්ලාති ස විකිරති| ");
INSERT INTO sansin_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","අපරඤ්ච අමේධ්‍යභූතෝ මානුෂස්‍යාන්තර්නිර්ගත්‍ය ශුෂ්කස්ථානේ භ්‍රාන්ත්වා විශ්‍රාමං මෘගයතේ කින්තු න ප්‍රාප්‍ය වදති මම යස්මාද් ගෘහාද් ආගතෝහං පුනස්තද් ගෘහං පරාවෘත්‍ය යාමි| ");
INSERT INTO sansin_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","තතෝ ගත්වා තද් ගෘහං මාර්ජිතං ශෝභිතඤ්ච දෘෂ්ට්වා ");
INSERT INTO sansin_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","තත්ක්‍ෂණම් අපගත්‍ය ස්වස්මාදපි දුර්ම්මතීන් අපරාන් සප්තභූතාන් සහානයති තේ ච තද්ගෘහං පවිශ්‍ය නිවසන්ති| තස්මාත් තස්‍ය මනුෂ්‍යස්‍ය ප්‍රථමදශාතඃ ශේෂදශා දුඃඛතරා භවති| ");
INSERT INTO sansin_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","අස්‍යාඃ කථායාඃ කථනකාලේ ජනතාමධ්‍යස්ථා කාචින්නාරී තමුච්චෛඃස්වරං ප්‍රෝවාච, යා යෝෂිත් ත්වාං ගර්බ්භේ(අ)ධාරයත් ස්තන්‍යමපායයච්ච සෛව ධන්‍යා| ");
INSERT INTO sansin_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","කින්තු සෝකථයත් යේ පරමේශ්වරස්‍ය කථාං ශ්‍රුත්වා තදනුරූපම් ආචරන්ති තඒව ධන්‍යාඃ| ");
INSERT INTO sansin_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","තතඃ පරං තස්‍යාන්තිකේ බහුලෝකානාං සමාගමේ ජාතේ ස වක්තුමාරේභේ, ආධුනිකා දුෂ්ටලෝකාශ්චිහ්නං ද්‍රෂ්ටුමිච්ඡන්ති කින්තු යූනස්භවිෂ්‍යද්වාදිනශ්චිහ්නං විනාන්‍යත් කිඤ්චිච්චිහ්නං තාන් න දර්ශයිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","යූනස් තු යථා නීනිවීයලෝකානාං සමීපේ චිහ්නරූපෝභවත් තථා විද්‍යමානලෝකානාම් ඒෂාං සමීපේ මනුෂ්‍යපුත්‍රෝපි චිහ්නරූපෝ භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","විචාරසමයේ ඉදානීන්තනලෝකානාං ප්‍රාතිකූල්‍යේන දක්‍ෂිණදේශීයා රාඥී ප්‍රෝත්ථාය තාන් දෝෂිණඃ කරිෂ්‍යති, යතඃ සා රාඥී සුලේමාන උපදේශකථාං ශ්‍රෝතුං පෘථිව්‍යාඃ සීමාත ආගච්ඡත් කින්තු පශ්‍යත සුලේමානෝපි ගුරුතර ඒකෝ ජනෝ(අ)ස්මින් ස්ථානේ විද්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","අපරඤ්ච විචාරසමයේ නීනිවීයලෝකා අපි වර්ත්තමානකාලිකානාං ලෝකානාං වෛපරීත්‍යේන ප්‍රෝත්ථාය තාන් දෝෂිණඃ කරිෂ්‍යන්ති, යතෝ හේතෝස්තේ යූනසෝ වාක්‍යාත් චිත්තානි පරිවර්ත්තයාමාසුඃ කින්තු පශ්‍යත යූනසෝතිගුරුතර ඒකෝ ජනෝ(අ)ස්මින් ස්ථානේ විද්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","ප්‍රදීපං ප්‍රජ්වාල්‍ය ද්‍රෝණස්‍යාධඃ කුත්‍රාපි ගුප්තස්ථානේ වා කෝපි න ස්ථාපයති කින්තු ගෘහප්‍රවේශිභ්‍යෝ දීප්තිං දාතං දීපාධාරෝපර‍්‍ය්‍යේව ස්ථාපයති| ");
INSERT INTO sansin_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","දේහස්‍ය ප්‍රදීපශ්චක්‍ෂුස්තස්මාදේව චක්‍ෂු ර‍්‍යදි ප්‍රසන්නං භවති තර්හි තව සර්ව්වශරීරං දීප්තිමද් භවිෂ්‍යති කින්තු චක්‍ෂු ර‍්‍යදි මලීමසං තිෂ්ඨති තර්හි සර්ව්වශරීරං සාන්ධකාරං ස්ථාස්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","අස්මාත් කාරණාත් තවාන්තඃස්ථං ජ්‍යෝති ර‍්‍යථාන්ධකාරමයං න භවති තදර්ථේ සාවධානෝ භව| ");
INSERT INTO sansin_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","යතඃ ශරීරස්‍ය කුත්‍රාප්‍යංශේ සාන්ධකාරේ න ජාතේ සර්ව්වං යදි දීප්තිමත් තිෂ්ඨති තර්හි තුභ්‍යං දීප්තිදායිප්‍රෝජ්ජ්වලන් ප්‍රදීප ඉව තව සවර්වශරීරං දීප්තිමද් භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ඒතත්කථායාඃ කථනකාලේ ඵිරුශ්‍යේකෝ භේජනාය තං නිමන්ත්‍රයාමාස, තතඃ ස ගත්වා භෝක්තුම් උපවිවේශ| ");
INSERT INTO sansin_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","කින්තු භෝජනාත් පූර්ව්වං නාමාඞ්ක්‍ෂීත් ඒතද් දෘෂ්ට්වා ස ඵිරුශ්‍යාශ්චර‍්‍ය්‍යං මේනේ| ");
INSERT INTO sansin_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","තදා ප්‍රභුස්තං ප්‍රෝවාච යූයං ඵිරූශිලෝකාඃ පානපාත්‍රාණාං භෝජනපාත්‍රාණාඤ්ච බහිඃ පරිෂ්කුරුථ කින්තු යුෂ්මාකමන්ත ර්දෞරාත්ම්‍යෛ ර්දුෂ්ක්‍රියාභිශ්ච පරිපූර්ණං තිෂ්ඨති| ");
INSERT INTO sansin_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","හේ සර්ව්වේ නිර්බෝධා යෝ බහිඃ සසර්ජ ස ඒව කිමන්ත ර්න සසර්ජ? ");
INSERT INTO sansin_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","තත ඒව යුෂ්මාභිරන්තඃකරණං (ඊශ්වරාය) නිවේද්‍යතාං තස්මින් කෘතේ යුෂ්මාකං සර්ව්වාණි ශුචිතාං යාස්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","කින්තු හන්ත ඵිරූශිගණා යූයං න්‍යායම් ඊශ්වරේ ප්‍රේම ච පරිත්‍යජ්‍ය පෝදිනායා අරුදාදීනාං සර්ව්වේෂාං ශාකානාඤ්ච දශමාංශාන් දත්ථ කින්තු ප්‍රථමං පාලයිත්වා ශේෂස්‍යාලඞ්ඝනං යුෂ්මාකම් උචිතමාසීත්| ");
INSERT INTO sansin_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","හා හා ඵිරූශිනෝ යූයං භජනගේහේ ප්‍රෝච්චාසනේ ආපණේෂු ච නමස්කාරේෂු ප්‍රීයධ්වේ| ");
INSERT INTO sansin_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","වත කපටිනෝ(අ)ධ්‍යාපකාඃ ඵිරූශිනශ්ච ලෝකායත් ශ්මශානම් අනුපලභ්‍ය තදුපරි ගච්ඡන්ති යූයම් තාදෘගප්‍රකාශිතශ්මශානවාද් භවථ| ");
INSERT INTO sansin_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","තදානීං ව්‍යවස්ථාපකානාම් ඒකා යීශුමවදත්, හේ උපදේශක වාක්‍යේනේදෘශේනාස්මාස්වපි දෝෂම් ආරෝපයසි| ");
INSERT INTO sansin_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","තතඃ ස උවාච, හා හා ව්‍යවස්ථාපකා යූයම් මානුෂාණාම් උපරි දුඃසහ්‍යාන් භාරාන් න්‍යස්‍යථ කින්තු ස්වයම් ඒකාඞ්ගුुල්‍යාපි තාන් භාරාන් න ස්පෘශථ| ");
INSERT INTO sansin_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","හන්ත යුෂ්මාකං පූර්ව්වපුරුෂා යාන් භවිෂ්‍යද්වාදිනෝ(අ)වධිෂුස්තේෂාං ශ්මශානානි යූයං නිර්ම්මාථ| ");
INSERT INTO sansin_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","තේනෛව යූයං ස්වපූර්ව්වපුරුෂාණාං කර්ම්මාණි සංමන්‍යධ්වේ තදේව සප්‍රමාණං කුරුථ ච, යතස්තේ තානවධිෂුඃ යූයං තේෂාං ශ්මශානානි නිර්ම්මාථ| ");
INSERT INTO sansin_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","අතඒව ඊශ්වරස්‍ය ශාස්ත්‍රේ ප්‍රෝක්තමස්ති තේෂාමන්තිකේ භවිෂ්‍යද්වාදිනඃ ප්‍රේරිතාංශ්ච ප්‍රේෂයිෂ්‍යාමි තතස්තේ තේෂාං කාංශ්චන හනිෂ්‍යන්ති කාංශ්චන තාඩශ්ෂ්‍යින්ති| ");
INSERT INTO sansin_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ඒතස්මාත් කාරණාත් හාබිලඃ ශෝණිතපාතමාරභ්‍ය මන්දිරයඥවේද්‍යෝ ර්මධ්‍යේ හතස්‍ය සිඛරියස්‍ය රක්තපාතපර‍්‍ය්‍යන්තං ");
INSERT INTO sansin_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ජගතඃ සෘෂ්ටිමාරභ්‍ය පෘථිව්‍යාං භවිෂ්‍යද්වාදිනාං යතිරක්තපාතා ජාතාස්තතීනාම් අපරාධදණ්ඩා ඒෂාං වර්ත්තමානලෝකානාං භවිෂ්‍යන්ති, යුෂ්මානහං නිශ්චිතං වදාමි සර්ව්වේ දණ්ඩා වංශස්‍යාස්‍ය භවිෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","හා හා ව්‍යවස්ථපකා යූයං ඥානස්‍ය කුඤ්චිකාං හෘත්වා ස්වයං න ප්‍රවිෂ්ටා යේ ප්‍රවේෂ්ටුඤ්ච ප්‍රයාසිනස්තානපි ප්‍රවේෂ්ටුං වාරිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ඉත්ථං කථාකථනාද් අධ්‍යාපකාඃ ඵිරූශිනශ්ච සතර්කාඃ ");
INSERT INTO sansin_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","සන්තස්තමපවදිතුං තස්‍ය කථායා දෝෂං ධර්ත්තමිච්ඡන්තෝ නානාඛ්‍යානකථනාය තං ප්‍රවර්ත්තයිතුං කෝපයිතුඤ්ච ප්‍රාරේභිරේ| ");
INSERT INTO sansin_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","තදානීං ලෝකාඃ සහස්‍රං සහස්‍රම් ආගත්‍ය සමුපස්ථිතාස්තත ඒකෛකෝ (අ)න්‍යේෂාමුපරි පතිතුම් උපචක්‍රමේ; තදා යීශුඃ ශිෂ්‍යාන් බභාෂේ, යූයං ඵිරූශිනාං කිණ්වරූපකාපට්‍යේ විශේෂේණ සාවධානාස්තිෂ්ඨත| ");
INSERT INTO sansin_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","යතෝ යන්න ප්‍රකාශයිෂ්‍යතේ තදාච්ඡන්නං වස්තු කිමපි නාස්ති; තථා යන්න ඥාස්‍යතේ තද් ගුප්තං වස්තු කිමපි නාස්ති| ");
INSERT INTO sansin_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","අන්ධකාරේ තිෂ්ඨනතෝ යාඃ කථා අකථයත තාඃ සර්ව්වාඃ කථා දීප්තෞ ශ්‍රෝෂ්‍යන්තේ නිර්ජනේ කර්ණේ ච යදකථයත ගෘහපෘෂ්ඨාත් තත් ප්‍රචාරයිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","හේ බන්ධවෝ යුෂ්මානහං වදාමි, යේ ශරීරස්‍ය නාශං විනා කිමප්‍යපරං කර්ත්තුං න ශක්‍රුවන්ති තේභ්‍යෝ මා භෛෂ්ට| ");
INSERT INTO sansin_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","තර්හි කස්මාද් භේතව්‍යම් ඉත්‍යහං වදාමි, යඃ ශරීරං නාශයිත්වා නරකං නික්‍ෂේප්තුං ශක්නෝති තස්මාදේව භයං කුරුත, පුනරපි වදාමි තස්මාදේව භයං කුරුත| ");
INSERT INTO sansin_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","පඤ්ච චටකපක්‍ෂිණඃ කිං ද්වාභ්‍යාං තාම්‍රඛණ්ඩාභ්‍යාං න වික්‍රීයන්තේ? තථාපීශ්වරස්තේෂාම් ඒකමපි න විස්මරති| ");
INSERT INTO sansin_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","යුෂ්මාකං ශිරඃකේශා අපි ගණිතාඃ සන්ති තස්මාත් මා විභීත බහුචටකපක්‍ෂිභ්‍යෝපි යූයං බහුමූල්‍යාඃ| ");
INSERT INTO sansin_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","අපරං යුෂ්මභ්‍යං කථයාමි යඃ කශ්චින් මානුෂාණාං සාක්‍ෂාන් මාං ස්වීකරෝති මනුෂ්‍යපුත්‍ර ඊශ්වරදූතානාං සාක්‍ෂාත් තං ස්වීකරිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","කින්තු යඃ කශ්චින්මානුෂාණාං සාක්‍ෂාන්මාම් අස්වීකරෝති තම් ඊශ්වරස්‍ය දූතානාං සාක්‍ෂාද් අහම් අස්වීකරිෂ්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","අන්‍යච්ච යඃ කශ්චින් මනුජසුතස්‍ය නින්දාභාවේන කාඤ්චිත් කථාං කථයති තස්‍ය තත්පාපස්‍ය මෝචනං භවිෂ්‍යති කින්තු යදි කශ්චිත් පවිත්‍රම් ආත්මානං නින්දති තර්හි තස්‍ය තත්පාපස්‍ය මෝචනං න භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","යදා ලෝකා යුෂ්මාන් භජනගේහං විචාරකර්තෘරාජ්‍යකර්තෘණාං සම්මුඛඤ්ච නේෂ්‍යන්ති තදා කේන ප්‍රකාරේණ කිමුත්තරං වදිෂ්‍යථ කිං කථයිෂ්‍යථ චේත්‍යත්‍ර මා චින්තයත; ");
INSERT INTO sansin_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","යතෝ යුෂ්මාභිර‍්‍යද් යද් වක්තව්‍යං තත් තස්මින් සමයඒව පවිත්‍ර ආත්මා යුෂ්මාන් ශික්‍ෂයිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","තතඃ පරං ජනතාමධ්‍යස්ථඃ කශ්චිජ්ජනස්තං ජගාද හේ ගුරෝ මයා සහ පෛතෘකං ධනං විභක්තුං මම භ්‍රාතරමාඥාපයතු භවාන්| ");
INSERT INTO sansin_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","කින්තු ස තමවදත් හේ මනුෂ්‍ය යුවයෝ ර්විචාරං විභාගඤ්ච කර්ත්තුං මාං කෝ නියුක්තවාන්? ");
INSERT INTO sansin_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","අනන්තරං ස ලෝකානවදත් ලෝභේ සාවධානාඃ සතර්කාශ්ච තිෂ්ඨත, යතෝ බහුසම්පත්තිප්‍රාප්ත්‍යා මනුෂ්‍යස්‍යායු ර්න භවති| ");
INSERT INTO sansin_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","පශ්චාද් දෘෂ්ටාන්තකථාමුත්ථාප්‍ය කථයාමාස, ඒකස්‍ය ධනිනෝ භූමෞ බහූනි ශස්‍යානි ජාතානි| ");
INSERT INTO sansin_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","තතඃ ස මනසා චින්තයිත්වා කථයාම්බභූව මමෛතානි සමුත්පන්නානි ද්‍රව්‍යාණි ස්ථාපයිතුං ස්ථානං නාස්ති කිං කරිෂ්‍යාමි? ");
INSERT INTO sansin_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","තතෝවදද් ඉත්ථං කරිෂ්‍යාමි, මම සර්ව්වභාණ්ඩාගාරාණි භඞ්ක්ත්වා බෘහද්භාණ්ඩාගාරාණි නිර්ම්මාය තන්මධ්‍යේ සර්ව්වඵලානි ද්‍රව්‍යාණි ච ස්ථාපයිෂ්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","අපරං නිජමනෝ වදිෂ්‍යාමි, හේ මනෝ බහුවත්සරාර්ථං නානාද්‍රව්‍යාණි සඤ්චිතානි සන්ති විශ්‍රාමං කුරු භුක්ත්වා පීත්වා කෞතුකඤ්ච කුරු| කින්ත්වීශ්වරස්තම් අවදත්, ");
INSERT INTO sansin_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","රේ නිර්බෝධ අද්‍ය රාත්‍රෞ තව ප්‍රාණාස්ත්වත්තෝ නේෂ්‍යන්තේ තත ඒතානි යානි ද්‍රව්‍යාණි ත්වයාසාදිතානි තානි කස්‍ය භවිෂ්‍යන්ති? ");
INSERT INTO sansin_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","අතඒව යඃ කශ්චිද් ඊශ්වරස්‍ය සමීපේ ධනසඤ්චයමකෘත්වා කේවලං ස්වනිකටේ සඤ්චයං කරෝති සෝපි තාදෘශඃ| ");
INSERT INTO sansin_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","අථ ස ශිෂ්‍යේභ්‍යඃ කථයාමාස, යුෂ්මානහං වදාමි, කිං ඛාදිෂ්‍යාමඃ? කිං පරිධාස්‍යාමඃ? ඉත්‍යුක්ත්වා ජීවනස්‍ය ශරීරස්‍ය චාර්ථං චින්තාං මා කාර්ෂ්ට| ");
INSERT INTO sansin_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","භක්‍ෂ්‍යාජ්ජීවනං භූෂණාච්ඡරීරඤ්ච ශ්‍රේෂ්ඨං භවති| ");
INSERT INTO sansin_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","කාකපක්‍ෂිණාං කාර‍්‍ය්‍යං විචාරයත, තේ න වපන්ති ශස්‍යානි ච න ඡින්දන්ති, තේෂාං භාණ්ඩාගාරාණි න සන්ති කෝෂාශ්ච න සන්ති, තථාපීශ්වරස්තේභ්‍යෝ භක්‍ෂ්‍යාණි දදාති, යූයං පක්‍ෂිභ්‍යඃ ශ්‍රේෂ්ඨතරා න කිං? ");
INSERT INTO sansin_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","අපරඤ්ච භාවයිත්වා නිජායුෂඃ ක්‍ෂණමාත්‍රං වර්ද්ධයිතුං ශක්නෝති, ඒතාදෘශෝ ලාකෝ යුෂ්මාකං මධ්‍යේ කෝස්ති? ");
INSERT INTO sansin_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","අතඒව ක්‍ෂුද්‍රං කාර‍්‍ය්‍යං සාධයිතුම් අසමර්ථා යූයම් අන්‍යස්මින් කාර‍්‍ය්‍යේ කුතෝ භාවයථ? ");
INSERT INTO sansin_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","අන්‍යච්ච කාම්පිලපුෂ්පං කථං වර්ද්ධතේ තදාපි විචාරයත, තත් කඤ්චන ශ්‍රමං න කරෝති තන්තූංශ්ච න ජනයති කින්තු යුෂ්මභ්‍යං යථාර්ථං කථයාමි සුලේමාන් බහ්වෛශ්වර‍්‍ය්‍යාන්විතෝපි පුෂ්පස්‍යාස්‍ය සදෘශෝ විභූෂිතෝ නාසීත්| ");
INSERT INTO sansin_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","අද්‍ය ක්‍ෂේත්‍රේ වර්ත්තමානං ශ්වශ්චූල්ල්‍යාං ක්‍ෂේප්ස්‍යමානං යත් තෘණං, තස්මෛ යදීශ්වර ඉත්ථං භූෂයති තර්හි හේ අල්පප්‍රත්‍යයිනෝ යුෂ්මාන කිං න පරිධාපයිෂ්‍යති? ");
INSERT INTO sansin_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","අතඒව කිං ඛාදිෂ්‍යාමඃ? කිං පරිධාස්‍යාමඃ? ඒතදර්ථං මා චේෂ්ටධ්වං මා සංදිග්ධ්වඤ්ච| ");
INSERT INTO sansin_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ජගතෝ දේවාර්ච්චකා ඒතානි සර්ව්වාණි චේෂ්ටනතේ; ඒෂු වස්තුෂු යුෂ්මාකං ප්‍රයෝජනමාස්තේ ඉති යුෂ්මාකං පිතා ජානාති| ");
INSERT INTO sansin_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","අතඒවේශ්වරස්‍ය රාජ්‍යාර්ථං සචේෂ්ටා භවත තථා කෘතේ සර්ව්වාණ්‍යේතානි ද්‍රව්‍යාණි යුෂ්මභ්‍යං ප්‍රදායිෂ්‍යන්තේ| ");
INSERT INTO sansin_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","හේ ක්‍ෂුද්‍රමේෂව්‍රජ යූයං මා භෛෂ්ට යුෂ්මභ්‍යං රාජ්‍යං දාතුං යුෂ්මාකං පිතුඃ සම්මතිරස්ති| ");
INSERT INTO sansin_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","අතඒව යුෂ්මාකං යා යා සම්පත්තිරස්ති තාං තාං වික්‍රීය විතරත, යත් ස්ථානං චෞරා නාගච්ඡන්ති, කීටාශ්ච න ක්‍ෂායයන්ති තාදෘශේ ස්වර්ගේ නිජාර්ථම් අජරේ සම්පුටකේ (අ)ක්‍ෂයං ධනං සඤ්චිනුත ච; ");
INSERT INTO sansin_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","යතෝ යත්‍ර යුෂ්මාකං ධනං වර්ත්තතේ තත්‍රේව යුෂ්මාකං මනඃ| ");
INSERT INTO sansin_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","අපරඤ්ච යූයං ප්‍රදීපං ජ්වාලයිත්වා බද්ධකටයස්තිෂ්ඨත; ");
INSERT INTO sansin_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ප්‍රභු ර්විවාහාදාගත්‍ය යදෛව ද්වාරමාහන්ති තදෛව ද්වාරං මෝචයිතුං යථා භෘත්‍යා අපේක්‍ෂ්‍ය තිෂ්ඨන්ති තථා යූයමපි තිෂ්ඨත| ");
INSERT INTO sansin_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","යතඃ ප්‍රභුරාගත්‍ය යාන් දාසාන් සචේතනාන් තිෂ්ඨතෝ ද්‍රක්‍ෂ්‍යති තඒව ධන්‍යාඃ; අහං යුෂ්මාන් යථාර්ථං වදාමි ප්‍රභුස්තාන් භෝජනාර්ථම් උපවේශ්‍ය ස්වයං බද්ධකටිඃ සමීපමේත්‍ය පරිවේෂයිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","යදි ද්විතීයේ තෘතීයේ වා ප්‍රහරේ සමාගත්‍ය තථෛව පශ්‍යති, තර්හි තඒව දාසා ධන්‍යාඃ| ");
INSERT INTO sansin_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","අපරඤ්ච කස්මින් ක්‍ෂණේ චෞරා ආගමිෂ්‍යන්ති ඉති යදි ගෘහපති ර්ඥාතුං ශක්නෝති තදාවශ්‍යං ජාග්‍රන් නිජගෘහේ සන්ධිං කර්ත්තයිතුං වාරයති යූයමේතද් විත්ත| ");
INSERT INTO sansin_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","අතඒව යූයමපි සජ්ජමානාස්තිෂ්ඨත යතෝ යස්මින් ක්‍ෂණේ තං නාප්‍රේක්‍ෂධ්වේ තස්මින්නේව ක්‍ෂණේ මනුෂ්‍යපුත්‍ර ආගමිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","තදා පිතරඃ පප්‍රච්ඡ, හේ ප්‍රභෝ භවාන් කිමස්මාන් උද්දිශ්‍ය කිං සර්ව්වාන් උද්දිශ්‍ය දෘෂ්ටාන්තකථාමිමාං වදති? ");
INSERT INTO sansin_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","තතඃ ප්‍රභුඃ ප්‍රෝවාච, ප්‍රභුඃ සමුචිතකාලේ නිජපරිවාරාර්ථං භෝජ්‍යපරිවේෂණාය යං තත්පදේ නියෝක්‍ෂ්‍යති තාදෘශෝ විශ්වාස්‍යෝ බෝද්ධා කර්ම්මාධීශඃ කෝස්ති? ");
INSERT INTO sansin_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ප්‍රභුරාගත්‍ය යම් ඒතාදෘශේ කර්ම්මණි ප්‍රවෘත්තං ද්‍රක්‍ෂ්‍යති සඒව දාසෝ ධන්‍යඃ| ");
INSERT INTO sansin_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","අහං යුෂ්මාන් යථාර්ථං වදාමි ස තං නිජසර්ව්වස්වස්‍යාධිපතිං කරිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","කින්තු ප්‍රභුර්විලම්බේනාගමිෂ්‍යති, ඉති විචින්ත්‍ය ස දාසෝ යදි තදන්‍යදාසීදාසාන් ප්‍රහර්ත්තුම් භෝක්තුං පාතුං මදිතුඤ්ච ප්‍රාරභතේ, ");
INSERT INTO sansin_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","තර්හි යදා ප්‍රභුං නාපේක්‍ෂිෂ්‍යතේ යස්මින් ක්‍ෂණේ සෝ(අ)චේතනශ්ච ස්ථාස්‍යති තස්මින්නේව ක්‍ෂණේ තස්‍ය ප්‍රභුරාගත්‍ය තං පදභ්‍රෂ්ටං කෘත්වා විශ්වාසහීනෛඃ සහ තස්‍ය අංශං නිරූපයිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","යෝ දාසඃ ප්‍රභේाරාඥාං ඥාත්වාපි සජ්ජිතෝ න තිෂ්ඨති තදාඥානුසාරේණ ච කාර‍්‍ය්‍යං න කරෝති සෝනේකාන් ප්‍රහාරාන් ප්‍රාප්ස්‍යති; ");
INSERT INTO sansin_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","කින්තු යෝ ජනෝ(අ)ඥාත්වා ප්‍රහාරාර්හං කර්ම්ම කරෝති සෝල්පප්‍රහාරාන් ප්‍රාප්ස්‍යති| යතෝ යස්මෛ බාහුල්‍යේන දත්තං තස්මාදේව බාහුල්‍යේන ග්‍රහීෂ්‍යතේ, මානුෂා යස්‍ය නිකටේ බහු සමර්පයන්ති තස්මාද් බහු යාචන්තේ| ");
INSERT INTO sansin_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","අහං පෘථිව්‍යාම් අනෛක්‍යරූපං වහ්නි නික්‍ෂේප්තුම් ආගතෝස්මි, ස චේද් ඉදානීමේව ප්‍රජ්වලති තත්‍ර මම කා චින්තා? ");
INSERT INTO sansin_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","කින්තු යේන මජ්ජනේනාහං මග්නෝ භවිෂ්‍යාමි යාවත්කාලං තස්‍ය සිද්ධි ර්න භවිෂ්‍යති තාවදහං කතිකෂ්ටං ප්‍රාප්ස්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","මේලනං කර්ත්තුං ජගද් ආගතෝස්මි යූයං කිමිත්ථං බෝධධ්වේ? යුෂ්මාන් වදාමි න තථා, කින්ත්වහං මේලනාභාවං කර්ත්තුංම් ආගතෝස්මි| ");
INSERT INTO sansin_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","යස්මාදේතත්කාලමාරභ්‍ය ඒකත්‍රස්ථපරිජනානාං මධ්‍යේ පඤ්චජනාඃ පෘථග් භූත්වා ත්‍රයෝ ජනා ද්වයෝර්ජනයෝඃ ප්‍රතිකූලා ද්වෞ ජනෞ ච ත්‍රයාණාං ජනානාං ප්‍රතිකූලෞ භවිෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","පිතා පුත්‍රස්‍ය විපක්‍ෂඃ පුත්‍රශ්ච පිතු ර්විපක්‍ෂෝ භවිෂ්‍යති මාතා කන්‍යායා විපක්‍ෂා කන්‍යා ච මාතු ර්විපක්‍ෂා භවිෂ්‍යති, තථා ශ්වශ්‍රූර්බධ්වා විපක්‍ෂා බධූශ්ච ශ්වශ්‍ර්වා විපක්‍ෂා භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ස ලෝකේභ්‍යෝපරමපි කථයාමාස, පශ්චිමදිශි මේඝෝද්ගමං දෘෂ්ට්වා යූයං හඨාද් වදථ වෘෂ්ටි ර්භවිෂ්‍යති තතස්තථෛව ජායතේ| ");
INSERT INTO sansin_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","අපරං දක්‍ෂිණතෝ වායෞ වාති සති වදථ නිදාඝෝ භවිෂ්‍යති තතඃ සෝපි ජායතේ| ");
INSERT INTO sansin_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","රේ රේ කපටින ආකාශස්‍ය භූම්‍යාශ්ච ලක්‍ෂණං බෝද්ධුං ශක්නුථ, ");
INSERT INTO sansin_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","කින්තු කාලස්‍යාස්‍ය ලක්‍ෂණං කුතෝ බෝද්ධුං න ශක්නුථ? යූයඤ්ච ස්වයං කුතෝ න න්‍යාෂ්‍යං විචාරයථ? ");
INSERT INTO sansin_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","අපරඤ්ච විවාදිනා සාර්ද්ධං විචාරයිතුඃ සමීපං ගච්ඡන් පථි තස්මාදුද්ධාරං ප්‍රාප්තුං යතස්ව නෝචේත් ස ත්වාං ධෘත්වා විචාරයිතුඃ සමීපං නයති| විචාරයිතා යදි ත්වාං ප්‍රහර්ත්තුඃ සමීපං සමර්පයති ප්‍රහර්ත්තා ත්වාං කාරායාං බධ්නාති ");
INSERT INTO sansin_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","තර්හි ත්වාමහං වදාමි ත්වයා නිඃශේෂං කපර්දකේෂු න පරිශෝධිතේෂු ත්වං තතෝ මුක්තිං ප්‍රාප්තුං න ශක්‍ෂ්‍යසි| ");
INSERT INTO sansin_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","අපරඤ්ච පීලාතෝ යේෂාං ගාලීලීයානාං රක්තානි බලීනාං රක්තෛඃ සහාමිශ්‍රයත් තේෂාං ගාලීලීයානාං වෘත්තාන්තං කතිපයජනා උපස්ථාප්‍ය යීශවේ කථයාමාසුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","තතඃ ස ප්‍රත්‍යුවාච තේෂාං ලෝකානාම් ඒතාදෘශී දුර්ගති ර්ඝටිතා තත්කාරණාද් යූයං කිමන්‍යේභ්‍යෝ ගාලීලීයේභ්‍යෝප්‍යධිකපාපිනස්තාන් බෝධධ්වේ? ");
INSERT INTO sansin_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","යුෂ්මානහං වදාමි තථා න කින්තු මනඃසු න පරාවර්ත්තිතේෂු යූයමපි තථා නංක්‍ෂ්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","අපරඤ්ච ශීලෝහනාම්න උච්චගෘහස්‍ය පතනාද් යේ(අ)ෂ්ටාදශජනා මෘතාස්තේ යිරූශාලමි නිවාසිසර්ව්වලෝකේභ්‍යෝ(අ)ධිකාපරාධිනඃ කිං යූයමිත්‍යං බෝධධ්වේ? ");
INSERT INTO sansin_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","යුෂ්මානහං වදාමි තථා න කින්තු මනඃසු න පරිවර්ත්තිතේෂු යූයමපි තථා නංක්‍ෂ්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","අනන්තරං ස ඉමාං දෘෂ්ටාන්තකථාමකථයද් ඒකෝ ජනෝ ද්‍රාක්‍ෂාක්‍ෂේත්‍රමධ්‍ය ඒකමුඩුම්බරවෘක්‍ෂං රෝපිතවාන්| පශ්චාත් ස ආගත්‍ය තස්මින් ඵලානි ගවේෂයාමාස, ");
INSERT INTO sansin_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","කින්තු ඵලාප්‍රාප්තේඃ කාරණාද් උද්‍යානකාරං භෘත්‍යං ජගාද, පශ්‍ය වත්සරත්‍රයං යාවදාගත්‍ය ඒතස්මින්නුඩුම්බරතරෞ ක්‍ෂලාන්‍යන්විච්ඡාමි, කින්තු නෛකමපි ප්‍රප්නෝමි තරුරයං කුතෝ වෘථා ස්ථානං ව්‍යාප්‍ය තිෂ්ඨති? ඒනං ඡින්ධි| ");
INSERT INTO sansin_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","තතෝ භෘත්‍යඃ ප්‍රත්‍යුවාච, හේ ප්‍රභෝ පුනර්වර්ෂමේකං ස්ථාතුම් ආදිශ; ඒතස්‍ය මූලස්‍ය චතුර්දික්‍ෂු ඛනිත්වාහම් ආලවාලං ස්ථාපයාමි| ");
INSERT INTO sansin_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","තතඃ ඵලිතුං ශක්නෝති යදි න ඵලති තර්හි පශ්චාත් ඡේත්ස්‍යසි| ");
INSERT INTO sansin_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","අථ විශ්‍රාමවාරේ භජනගේහේ යීශුරුපදිශති ");
INSERT INTO sansin_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","තස්මිත් සමයේ භූතග්‍රස්තත්වාත් කුබ්ජීභූයාෂ්ටාදශවර්ෂාණි යාවත් කේනාප්‍යුපායේන ඍජු ර්භවිතුං න ශක්නෝති යා දුර්බ්බලා ස්ත්‍රී, ");
INSERT INTO sansin_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","තාං තත්‍රෝපස්ථිතාං විලෝක්‍ය යීශුස්තාමාහූය කථිතවාන් හේ නාරි තව දෞර්බ්බල්‍යාත් ත්වං මුක්තා භව| ");
INSERT INTO sansin_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","තතඃ පරං තස්‍යා ගාත්‍රේ හස්තාර්පණමාත්‍රාත් සා ඍජුර්භූත්වේශ්වරස්‍ය ධන්‍යවාදං කර්ත්තුමාරේභේ| ");
INSERT INTO sansin_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","කින්තු විශ්‍රාමවාරේ යීශුනා තස්‍යාඃ ස්වාස්ථ්‍යකරණාද් භජනගේහස්‍යාධිපතිඃ ප්‍රකුප්‍ය ලෝකාන් උවාච, ෂට්සු දිනේෂු ලෝකෛඃ කර්ම්ම කර්ත්තව්‍යං තස්මාද්ධේතෝඃ ස්වාස්ථ්‍යාර්ථං තේෂු දිනේෂු ආගච්ඡත, විශ්‍රාමවාරේ මාගච්ඡත| ");
INSERT INTO sansin_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","තදා පභුඃ ප්‍රත්‍යුවාච රේ කපටිනෝ යුෂ්මාකම් ඒකෛකෝ ජනෝ විශ්‍රාමවාරේ ස්වීයං ස්වීයං වෘෂභං ගර්දභං වා බන්ධනාන්මෝචයිත්වා ජලං පායයිතුං කිං න නයති? ");
INSERT INTO sansin_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","තර්හ්‍යාෂ්ටාදශවත්සරාන් යාවත් ශෛතානා බද්ධා ඉබ්‍රාහීමඃ සන්තතිරියං නාරී කිං විශ්‍රාමවාරේ න මෝචයිතව්‍යා? ");
INSERT INTO sansin_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ඒෂු වාක්‍යේෂු කථිතේෂු තස්‍ය විපක්‍ෂාඃ සලජ්ජා ජාතාඃ කින්තු තේන කෘතසර්ව්වමහාකර්ම්මකාරණාත් ලෝකනිවහඃ සානන්දෝ(අ)භවත්| ");
INSERT INTO sansin_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","අනන්තරං සෝවදද් ඊශ්වරස්‍ය රාජ්‍යං කස්‍ය සදෘශං? කේන තදුපමාස්‍යාමි? ");
INSERT INTO sansin_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","යත් සර්ෂපබීජං ගෘහීත්වා කශ්චිජ්ජන උද්‍යාන උප්තවාන් තද් බීජමඞ්කුරිතං සත් මහාවෘක්‍ෂෝ(අ)ජායත, තතස්තස්‍ය ශාඛාසු විහායසීයවිහගා ආගත්‍ය න්‍යූෂුඃ, තද්‍රාජ්‍යං තාදෘශේන සර්ෂපබීජේන තුල්‍යං| ");
INSERT INTO sansin_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","පුනඃ කථයාමාස, ඊශ්වරස්‍ය රාජ්‍යං කස්‍ය සදෘශං වදිෂ්‍යාමි? යත් කිණ්වං කාචිත් ස්ත්‍රී ගෘහීත්වා ද්‍රෝණත්‍රයපරිමිතගෝධූමචූර්ණේෂු ස්ථාපයාමාස, ");
INSERT INTO sansin_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","තතඃ ක්‍රමේණ තත් සර්ව්වගෝධූමචූර්ණං ව්‍යාප්නෝති, තස්‍ය කිණ්වස්‍ය තුල්‍යම් ඊශ්වරස්‍ය රාජ්‍යං| ");
INSERT INTO sansin_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","තතඃ ස යිරූශාලම්නගරං ප්‍රති යාත්‍රාං කෘත්වා නගරේ නගරේ ග්‍රාමේ ග්‍රාමේ සමුපදිශන් ජගාම| ");
INSERT INTO sansin_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","තදා කශ්චිජ්ජනස්තං පප්‍රච්ඡ, හේ ප්‍රභෝ කිං කේවලම් අල්පේ ලෝකාඃ පරිත්‍රාස්‍යන්තේ? ");
INSERT INTO sansin_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","තතඃ ස ලෝකාන් උවාච, සංකීර්ණද්වාරේණ ප්‍රවේෂ්ටුං යතඝ්වං, යතෝහං යුෂ්මාන් වදාමි, බහවඃ ප්‍රවේෂ්ටුං චේෂ්ටිෂ්‍යන්තේ කින්තු න ශක්‍ෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ගෘහපතිනෝත්ථාය ද්වාරේ රුද්ධේ සති යදි යූයං බහිඃ ස්ථිත්වා ද්වාරමාහත්‍ය වදථ, හේ ප්‍රභෝ හේ ප්‍රභෝ අස්මත්කාරණාද් ද්වාරං මෝචයතු, තතඃ ස ඉති ප්‍රතිවක්‍ෂ්‍යති, යූයං කුත්‍රත්‍යා ලෝකා ඉත්‍යහං න ජානාමි| ");
INSERT INTO sansin_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","තදා යූයං වදිෂ්‍යථ, තව සාක්‍ෂාද් වයං භේाජනං පානඤ්ච කෘතවන්තඃ, ත්වඤ්චාස්මාකං නගරස්‍ය පථි සමුපදිෂ්ටවාන්| ");
INSERT INTO sansin_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","කින්තු ස වක්‍ෂ්‍යති, යුෂ්මානහං වදාමි, යූයං කුත්‍රත්‍යා ලෝකා ඉත්‍යහං න ජානාමි; හේ දුරාචාරිණෝ යූයං මත්තෝ දූරීභවත| ");
INSERT INTO sansin_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","තදා ඉබ්‍රාහීමං ඉස්හාකං යාකූබඤ්ච සර්ව්වභවිෂ්‍යද්වාදිනශ්ච ඊශ්වරස්‍ය රාජ්‍යං ප්‍රාප්තාන් ස්වාංශ්ච බහිෂ්කෘතාන් දෘෂ්ට්වා යූයං රෝදනං දන්තෛර්දන්තඝර්ෂණඤ්ච කරිෂ්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","අපරඤ්ච පූර්ව්වපශ්චිමදක්‍ෂිණෝත්තරදිග්භ්‍යෝ ලෝකා ආගත්‍ය ඊශ්වරස්‍ය රාජ්‍යේ නිවත්ස්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","පශ්‍යතේත්ථං ශේෂීයා ලෝකා අග්‍රා භවිෂ්‍යන්ති, අග්‍රීයා ලෝකාශ්ච ශේෂා භවිෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","අපරඤ්ච තස්මින් දිනේ කියන්තඃ ඵිරූශින ආගත්‍ය යීශුං ප්‍රෝචුඃ, බහිර්ගච්ඡ, ස්ථානාදස්මාත් ප්‍රස්ථානං කුරු, හේරෝද් ත්වාං ජිඝාංසති| ");
INSERT INTO sansin_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","තතඃ ස ප්‍රත්‍යවෝචත් පශ්‍යතාද්‍ය ශ්වශ්ච භූතාන් විහාප්‍ය රෝගිණෝ(අ)රෝගිණඃ කෘත්වා තෘතීයේහ්නි සේත්ස්‍යාමි, කථාමේතාං යූයමිත්වා තං භූරිමායං වදත| ");
INSERT INTO sansin_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","තත්‍රාප්‍යද්‍ය ශ්වඃ පරශ්වශ්ච මයා ගමනාගමනේ කර්ත්තව්‍යේ, යතෝ හේතෝ ර‍්‍යිරූශාලමෝ බහිඃ කුත්‍රාපි කෝපි භවිෂ්‍යද්වාදී න ඝානිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","හේ යිරූශාලම් හේ යිරූශාලම් ත්වං භවිෂ්‍යද්වාදිනෝ හංසි තවාන්තිකේ ප්‍රේරිතාන් ප්‍රස්තරෛර්මාරයසි ච, යථා කුක්කුටී නිජපක්‍ෂාධඃ ස්වශාවකාන් සංගෘහ්ලාති, තථාහමපි තව ශිශූන් සංග්‍රහීතුං කතිවාරාන් ඓච්ඡං කින්තු ත්වං නෛච්ඡඃ| ");
INSERT INTO sansin_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","පශ්‍යත යුෂ්මාකං වාසස්ථානානි ප්‍රෝච්ඡිද්‍යමානානි පරිත්‍යක්තානි ච භවිෂ්‍යන්ති; යුෂ්මානහං යථාර්ථං වදාමි, යඃ ප්‍රභෝ ර්නාම්නාගච්ඡති ස ධන්‍ය ඉති වාචං යාවත්කාලං න වදිෂ්‍යථ, තාවත්කාලං යූයං මාං න ද්‍රක්‍ෂ්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","අනන්තරං විශ්‍රාමවාරේ යීශෞ ප්‍රධානස්‍ය ඵිරූශිනෝ ගෘහේ භෝක්තුං ගතවති තේ තං වීක්‍ෂිතුම් ආරේභිරේ| ");
INSERT INTO sansin_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","තදා ජලෝදරී තස්‍ය සම්මුඛේ ස්ථිතඃ| ");
INSERT INTO sansin_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","තතඃ ස ව්‍යවස්ථාපකාන් ඵිරූශිනශ්ච පප්‍රච්ඡ, විශ්‍රාමවාරේ ස්වාස්ථ්‍යං කර්ත්තව්‍යං න වා? තතස්තේ කිමපි න ප්‍රත්‍යූචුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","තදා ස තං රෝගිණං ස්වස්ථං කෘත්වා විසසර්ජ; ");
INSERT INTO sansin_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","තානුවාච ච යුෂ්මාකං කස්‍යචිද් ගර්ද්දභෝ වෘෂභෝ වා චේද් ගර්ත්තේ පතති තර්හි විශ්‍රාමවාරේ තත්ක්‍ෂණං ස කිං තං නෝත්ථාපයිෂ්‍යති? ");
INSERT INTO sansin_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","තතස්තේ කථායා ඒතස්‍යාඃ කිමපි ප්‍රතිවක්තුං න ශේකුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","අපරඤ්ච ප්‍රධානස්ථානමනෝනීතත්වකරණං විලෝක්‍ය ස නිමන්ත්‍රිතාන් ඒතදුපදේශකථාං ජගාද, ");
INSERT INTO sansin_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","ත්වං විවාහාදිභෝජ්‍යේෂු නිමන්ත්‍රිතඃ සන් ප්‍රධානස්ථානේ මෝපාවේක්‍ෂීඃ| ත්වත්තෝ ගෞරවාන්විතනිමන්ත්‍රිතජන ආයාතේ ");
INSERT INTO sansin_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","නිමන්ත්‍රයිතාගත්‍ය මනුෂ්‍යායෛතස්මෛ ස්ථානං දේහීති වාක්‍යං චේද් වක්‍ෂ්‍යති තර්හි ත්වං සඞ්කුචිතෝ භූත්වා ස්ථාන ඉතරස්මින් උපවේෂ්ටුම් උද්‍යංස්‍යසි| ");
INSERT INTO sansin_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","අස්මාත් කාරණාදේව ත්වං නිමන්ත්‍රිතෝ ගත්වා(අ)ප්‍රධානස්ථාන උපවිශ, තතෝ නිමන්ත්‍රයිතාගත්‍ය වදිෂ්‍යති, හේ බන්ධෝ ප්‍රෝච්චස්ථානං ගත්වෝපවිශ, තථා සති භෝජනෝපවිෂ්ටානාං සකලානාං සාක්‍ෂාත් ත්වං මාන්‍යෝ භවිෂ්‍යසි| ");
INSERT INTO sansin_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","යඃ කශ්චිත් ස්වමුන්නමයති ස නමයිෂ්‍යතේ, කින්තු යඃ කශ්චිත් ස්වං නමයති ස උන්නමයිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","තදා ස නිමන්ත්‍රයිතාරං ජනමපි ජගාද, මධ්‍යාහ්නේ රාත්‍රෞ වා භෝජ්‍යේ කෘතේ නිජබන්ධුගණෝ වා භ්‍රාතෘृගණෝ වා ඥාතිගණෝ වා ධනිගණෝ වා සමීපවාසිගණෝ වා ඒතාන් න නිමන්ත්‍රය, තථා කෘතේ චේත් තේ ත්වාං නිමන්ත්‍රයිෂ්‍යන්ති, තර්හි පරිශෝධෝ භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","කින්තු යදා භේජ්‍යං කරෝෂි තදා දරිද්‍රශුෂ්කකරඛඤ්ජාන්ධාන් නිමන්ත්‍රය, ");
INSERT INTO sansin_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","තත ආශිෂං ලප්ස්‍යසේ, තේෂු පරිශෝධං කර්ත්තුමශක්නුවත්සු ශ්මශානාද්ධාර්ම්මිකානාමුත්ථානකාලේ ත්වං ඵලාං ලප්ස්‍යසේ| ");
INSERT INTO sansin_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","අනන්තරං තාං කථාං නිශම්‍ය භෝජනෝපවිෂ්ටඃ කශ්චිත් කථයාමාස, යෝ ජන ඊශ්වරස්‍ය රාජ්‍යේ භෝක්තුං ලප්ස්‍යතේ සඒව ධන්‍යඃ| ");
INSERT INTO sansin_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","තතඃ ස උවාච, කශ්චිත් ජනෝ රාත්‍රෞ භේाජ්‍යං කෘත්වා බහූන් නිමන්ත්‍රයාමාස| ");
INSERT INTO sansin_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","තතෝ භෝජනසමයේ නිමන්ත්‍රිතලෝකාන් ආහ්වාතුං දාසද්වාරා කථයාමාස, ඛද්‍යද්‍රව්‍යාණි සර්ව්වාණි සමාසාදිතානි සන්ති, යූයමාගච්ඡත| ");
INSERT INTO sansin_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","කින්තු තේ සර්ව්ව ඒකෛකං ඡලං කෘත්වා ක්‍ෂමාං ප්‍රාර්ථයාඤ්චක්‍රිරේ| ප්‍රථමෝ ජනඃ කථයාමාස, ක්‍ෂේත්‍රමේකං ක්‍රීතවානහං තදේව ද්‍රෂ්ටුං මයා ගන්තව්‍යම්, අතඒව මාං ක්‍ෂන්තුං තං නිවේදය| ");
INSERT INTO sansin_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","අන්‍යෝ ජනඃ කථයාමාස, දශවෘෂානහං ක්‍රීතවාන් තාන් පරීක්‍ෂිතුං යාමි තස්මාදේව මාං ක්‍ෂන්තුං තං නිවේදය| ");
INSERT INTO sansin_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","අපරඃ කථයාමාස, ව්‍යූඪවානහං තස්මාත් කාරණාද් යාතුං න ශක්නෝමි| ");
INSERT INTO sansin_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","පශ්චාත් ස දාසෝ ගත්වා නිජප්‍රභෝඃ සාක්‍ෂාත් සර්ව්වවෘත්තාන්තං නිවේදයාමාස, තතෝසෞ ගෘහපතිඃ කුපිත්වා ස්වදාසං ව්‍යාජහාර, ත්වං සත්වරං නගරස්‍ය සන්නිවේශාන් මාර්ගාංශ්ච ගත්වා දරිද්‍රශුෂ්කකරඛඤ්ජාන්ධාන් අත්‍රානය| ");
INSERT INTO sansin_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","තතෝ දාසෝ(අ)වදත්, හේ ප්‍රභෝ භවත ආඥානුසාරේණාක්‍රියත තථාපි ස්ථානමස්ති| ");
INSERT INTO sansin_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","තදා ප්‍රභුඃ පුන ර්දාසායාකථයත්, රාජපථාන් වෘක්‍ෂමූලානි ච යාත්වා මදීයගෘහපූරණාර්ථං ලෝකානාගන්තුං ප්‍රවර්ත්තය| ");
INSERT INTO sansin_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","අහං යුෂ්මභ්‍යං කථයාමි, පූර්ව්වනිමන්ත්‍රිතානමේකෝපි මමාස්‍ය රාත්‍රිභෝජ්‍යස්‍යාස්වාදං න ප්‍රාප්ස්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","අනන්තරං බහුෂු ලෝකේෂු යීශෝඃ පශ්චාද් ව්‍රජිතේෂු සත්සු ස ව්‍යාඝුට්‍ය තේභ්‍යඃ කථයාමාස, ");
INSERT INTO sansin_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","යඃ කශ්චින් මම සමීපම් ආගත්‍ය ස්වස්‍ය මාතා පිතා පත්නී සන්තානා භ්‍රාතරෝ භගිම්‍යෝ නිජප්‍රාණාශ්ච, ඒතේභ්‍යඃ සර්ව්වේභ්‍යෝ මය්‍යධිකං ප්‍රේම න කරෝති, ස මම ශිෂ්‍යෝ භවිතුං න ශක්‍ෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","යඃ කශ්චිත් ස්වීයං ක්‍රුශං වහන් මම පශ්චාන්න ගච්ඡති, සෝපි මම ශිෂ්‍යෝ භවිතුං න ශක්‍ෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","දුර්ගනිර්ම්මාණේ කතිව්‍යයෝ භවිෂ්‍යති, තථා තස්‍ය සමාප්තිකරණාර්ථං සම්පත්තිරස්ති න වා, ප්‍රථමමුපවිශ්‍ය ඒතන්න ගණයති, යුෂ්මාකං මධ්‍ය ඒතාදෘශඃ කෝස්ති? ");
INSERT INTO sansin_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","නෝචේද් භිත්තිං කෘත්වා ශේෂේ යදි සමාපයිතුං න ශක්‍ෂ්‍යති, ");
INSERT INTO sansin_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","තර්හි මානුෂෝයං නිචේතුම් ආරභත සමාපයිතුං නාශක්නෝත්, ඉති ව්‍යාහෘත්‍ය සර්ව්වේ තමුපහසිෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","අපරඤ්ච භින්නභූපතිනා සහ යුද්ධං කර්ත්තුම් උද්‍යම්‍ය දශසහස්‍රාණි සෛන්‍යානි ගෘහීත්වා විංශතිසහස්‍රේඃ සෛන්‍යෛඃ සහිතස්‍ය සමීපවාසිනඃ සම්මුඛං යාතුං ශක්‍ෂ්‍යාමි න වේති ප්‍රථමං උපවිශ්‍ය න විචාරයති ඒතාදෘශෝ භූමිපතිඃ කඃ? ");
INSERT INTO sansin_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","යදි න ශක්නෝති තර්හි රිපාවතිදූරේ තිෂ්ඨති සති නිජදූතං ප්‍රේෂ්‍ය සන්ධිං කර්ත්තුං ප්‍රාර්ථයේත| ");
INSERT INTO sansin_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","තද්වද් යුෂ්මාකං මධ්‍යේ යඃ කශ්චින් මදර්ථං සර්ව්වස්වං හාතුං න ශක්නෝති ස මම ශිෂ්‍යෝ භවිතුං න ශක්‍ෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","ලවණම් උත්තමම් ඉති සත්‍යං, කින්තු යදි ලවණස්‍ය ලවණත්වම් අපගච්ඡති තර්හි තත් කථං ස්වාදුයුක්තං භවිෂ්‍යති? ");
INSERT INTO sansin_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","තද භූම්‍යර්ථම් ආලවාලරාශ්‍යර්ථමපි භද්‍රං න භවති; ලෝකාස්තද් බහිඃ ක්‍ෂිපන්ති| යස්‍ය ශ්‍රෝතුං ශ්‍රෝත්‍රේ ස්තඃ ස ශෘණෝතු| ");
INSERT INTO sansin_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","තදා කරසඤ්චායිනඃ පාපිනශ්ච ලෝකා උපදේශ්කථාං ශ්‍රෝතුං යීශෝඃ සමීපම් ආගච්ඡන්| ");
INSERT INTO sansin_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","තතඃ ඵිරූශින උපාධ්‍යායාශ්ච විවදමානාඃ කථයාමාසුඃ ඒෂ මානුෂඃ පාපිභිඃ සහ ප්‍රණයං කෘත්වා තෛඃ සාර්ද්ධං භුංක්තේ| ");
INSERT INTO sansin_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","තදා ස තේභ්‍ය ඉමාං දෘෂ්ටාන්තකථාං කථිතවාන්, ");
INSERT INTO sansin_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","කස්‍යචිත් ශතමේෂේෂු තිෂ්ඨත්මු තේෂාමේකං ස යදි හාරයති තර්හි මධ්‍යේප්‍රාන්තරම් ඒකෝනශතමේෂාන් විහාය හාරිතමේෂස්‍ය උද්දේශප්‍රාප්තිපර‍්‍ය්‍යනතං න ගවේෂයති, ඒතාදෘශෝ ලෝකෝ යුෂ්මාකං මධ්‍යේ ක ආස්තේ? ");
INSERT INTO sansin_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","තස්‍යෝද්දේශං ප්‍රාප්‍ය හෘෂ්ටමනාස්තං ස්කන්ධේ නිධාය ස්වස්ථානම් ආනීය බන්ධුබාන්ධවසමීපවාසින ආහූය වක්ති, ");
INSERT INTO sansin_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","හාරිතං මේෂං ප්‍රාප්තෝහම් අතෝ හේතෝ ර්මයා සාර්ද්ධම් ආනන්දත| ");
INSERT INTO sansin_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","තද්වදහං යුෂ්මාන් වදාමි, යේෂාං මනඃපරාවර්ත්තනස්‍ය ප්‍රයෝජනං නාස්ති, තාදෘශෛකෝනශතධාර්ම්මිකකාරණාද් ය ආනන්දස්තස්මාද් ඒකස්‍ය මනඃපරිවර්ත්තිනඃ පාපිනඃ කාරණාත් ස්වර්ගේ (අ)ධිකානන්දෝ ජායතේ| ");
INSERT INTO sansin_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","අපරඤ්ච දශානාං රූප්‍යඛණ්ඩානාම් ඒකඛණ්ඩේ හාරිතේ ප්‍රදීපං ප්‍රජ්වාල්‍ය ගෘහං සම්මාර්ජ්‍ය තස්‍ය ප්‍රාප්තිං යාවද් යත්නේන න ගවේෂයති, ඒතාදෘශී යෝෂිත් කාස්තේ? ");
INSERT INTO sansin_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ප්‍රාප්තේ සති බන්ධුබාන්ධවසමීපවාසිනීරාහූය කථයති, හාරිතං රූප්‍යඛණ්ඩං ප්‍රාප්තාහං තස්මාදේව මයා සාර්ද්ධම් ආනන්දත| ");
INSERT INTO sansin_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","තද්වදහං යුෂ්මාන් ව්‍යාහරාමි, ඒකේන පාපිනා මනසි පරිවර්ත්තිතේ, ඊශ්වරස්‍ය දූතානාං මධ්‍යේප්‍යානන්දෝ ජායතේ| ");
INSERT INTO sansin_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","අපරඤ්ච ස කථයාමාස, කස්‍යචිද් ද්වෞ පුත්‍රාවාස්තාං, ");
INSERT INTO sansin_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","තයෝඃ කනිෂ්ඨඃ පුත්‍රඃ පිත්‍රේ කථයාමාස, හේ පිතස්තව සම්පත්ත්‍යා යමංශං ප්‍රාප්ස්‍යාම්‍යහං විභජ්‍ය තං දේහි, තතඃ පිතා නිජාං සම්පත්තිං විභජ්‍ය තාභ්‍යාං දදෞ| ");
INSERT INTO sansin_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","කතිපයාත් කාලාත් පරං ස කනිෂ්ඨපුත්‍රඃ සමස්තං ධනං සංගෘහ්‍ය දූරදේශං ගත්වා දුෂ්ටාචරණේන සර්ව්වාං සම්පත්තිං නාශයාමාස| ");
INSERT INTO sansin_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","තස්‍ය සර්ව්වධනේ ව්‍යයං ගතේ තද්දේශේ මහාදුර්භික්‍ෂං බභූව, තතස්තස්‍ය දෛන්‍යදශා භවිතුම් ආරේභේ| ");
INSERT INTO sansin_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","තතඃ පරං ස ගත්වා තද්දේශීයං ගෘහස්ථමේකම් ආශ්‍රයත; තතඃ සතං ශූකරව්‍රජං චාරයිතුං ප්‍රාන්තරං ප්‍රේෂයාමාස| ");
INSERT INTO sansin_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","කේනාපි තස්මෛ භක්‍ෂ්‍යාදානාත් ස ශූකරඵලවල්කලේන පිචිණ්ඩපූරණාං වවාඤ්ඡ| ");
INSERT INTO sansin_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ශේෂේ ස මනසි චේතනාං ප්‍රාප්‍ය කථයාමාස, හා මම පිතුඃ සමීපේ කති කති වේතනභුජෝ දාසා යථේෂ්ටං තතෝධිකඤ්ච භක්‍ෂ්‍යං ප්‍රාප්නුවන්ති කින්ත්වහං ක්‍ෂුධා මුමූර්ෂුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","අහමුත්ථාය පිතුඃ සමීපං ගත්වා කථාමේතාං වදිෂ්‍යාමි, හේ පිතර් ඊශ්වරස්‍ය තව ච විරුද්ධං පාපමකරවම් ");
INSERT INTO sansin_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","තව පුත්‍රඉති විඛ්‍යාතෝ භවිතුං න යෝග්‍යෝස්මි ච, මාං තව වෛතනිකං දාසං කෘත්වා ස්ථාපය| ");
INSERT INTO sansin_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","පශ්චාත් ස උත්ථාය පිතුඃ සමීපං ජගාම; තතස්තස්‍ය පිතාතිදූරේ තං නිරීක්‍ෂ්‍ය දයාඤ්චක්‍රේ, ධාවිත්වා තස්‍ය කණ්ඨං ගෘහීත්වා තං චුචුම්බ ච| ");
INSERT INTO sansin_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","තදා පුත්‍ර උවාච, හේ පිතර් ඊශ්වරස්‍ය තව ච විරුද්ධං පාපමකරවං, තව පුත්‍රඉති විඛ්‍යාතෝ භවිතුං න යෝග්‍යෝස්මි ච| ");
INSERT INTO sansin_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","කින්තු තස්‍ය පිතා නිජදාසාන් ආදිදේශ, සර්ව්වෝත්තමවස්ත්‍රාණ්‍යානීය පරිධාපයතෛනං හස්තේ චාඞ්ගුරීයකම් අර්පයත පාදයෝශ්චෝපානහෞ සමර්පයත; ");
INSERT INTO sansin_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","පුෂ්ටං ගෝවත්සම් ආනීය මාරයත ච තං භුක්ත්වා වයම් ආනන්දාම| ");
INSERT INTO sansin_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","යතෝ මම පුත්‍රෝයම් අම්‍රියත පුනරජීවීද් හාරිතශ්ච ලබ්ධෝභූත් තතස්ත ආනන්දිතුම් ආරේභිරේ| ");
INSERT INTO sansin_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","තත්කාලේ තස්‍ය ජ්‍යේෂ්ඨඃ පුත්‍රඃ ක්‍ෂේත්‍ර ආසීත්| අථ ස නිවේශනස්‍ය නිකටං ආගච්ඡන් නෘත්‍යානාං වාද්‍යානාඤ්ච ශබ්දං ශ්‍රුත්වා ");
INSERT INTO sansin_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","දාසානාම් ඒකම් ආහූය පප්‍රච්ඡ, කිං කාරණමස්‍ය? ");
INSERT INTO sansin_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","තතඃ සෝවාදීත්, තව භ්‍රාතාගමත්, තව තාතශ්ච තං සුශරීරං ප්‍රාප්‍ය පුෂ්ටං ගෝවත්සං මාරිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","තතඃ ස ප්‍රකුප්‍ය නිවේශනාන්තඃ ප්‍රවේෂ්ටුං න සම්මේනේ; තතස්තස්‍ය පිතා බහිරාගත්‍ය තං සාධයාමාස| ");
INSERT INTO sansin_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","තතඃ ස පිතරං ප්‍රත්‍යුවාච, පශ්‍ය තව කාඤ්චිදප්‍යාඥාං න විලංඝ්‍ය බහූන් වත්සරාන් අහං ත්වාං සේවේ තථාපි මිත්‍රෛඃ සාර්ද්ධම් උත්සවං කර්ත්තුං කදාපි ඡාගමේකමපි මහ්‍යං නාදදාඃ; ");
INSERT INTO sansin_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","කින්තු තව යඃ පුත්‍රෝ වේශ්‍යාගමනාදිභිස්තව සම්පත්තිම් අපව්‍යයිතවාන් තස්මින්නාගතමාත්‍රේ තස්‍යෛව නිමිත්තං පුෂ්ටං ගෝවත්සං මාරිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","තදා තස්‍ය පිතාවෝචත්, හේ පුත්‍ර ත්වං සර්ව්වදා මයා සහාසි තස්මාන් මම යද්‍යදාස්තේ තත්සර්ව්වං තව| ");
INSERT INTO sansin_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","කින්තු තවායං භ්‍රාතා මෘතඃ පුනරජීවීද් හාරිතශ්ච භූත්වා ප්‍රාප්තෝභූත්, ඒතස්මාත් කාරණාද් උත්සවානන්දෞ කර්ත්තුම් උචිතමස්මාකම්| ");
INSERT INTO sansin_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","අපරඤ්ච යීශුඃ ශිෂ්‍යේභ්‍යෝන්‍යාමේකාං කථාං කථයාමාස කස්‍යචිද් ධනවතෝ මනුෂ්‍යස්‍ය ගෘහකාර‍්‍ය්‍යාධීශේ සම්පත්තේරපව්‍යයේ(අ)පවාදිතේ සති ");
INSERT INTO sansin_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","තස්‍ය ප්‍රභුස්තම් ආහූය ජගාද, ත්වයි යාමිමාං කථාං ශෘණෝමි සා කීදෘශී? ත්වං ගෘහකාර‍්‍ය්‍යාධීශකර්ම්මණෝ ගණනාං දර්ශය ගෘහකාර‍්‍ය්‍යාධීශපදේ ත්වං න ස්ථාස්‍යසි| ");
INSERT INTO sansin_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","තදා ස ගෘහකාර‍්‍ය්‍යාධීශෝ මනසා චින්තයාමාස, ප්‍රභු ර‍්‍යදි මාං ගෘහකාර‍්‍ය්‍යාධීශපදාද් භ්‍රංශයති තර්හි කිං කරිෂ්‍යේ(අ)හං? මෘදං ඛනිතුං මම ශක්ති ර්නාස්ති භික්‍ෂිතුඤ්ච ලජ්ජිෂ්‍යේ(අ)හං| ");
INSERT INTO sansin_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","අතඒව මයි ගෘහකාර‍්‍ය්‍යාධීශපදාත් ච්‍යුතේ සති යථා ලෝකා මහ්‍යම් ආශ්‍රයං දාස්‍යන්ති තදර්ථං යත්කර්ම්ම මයා කරණීයං තන් නිර්ණීයතේ| ");
INSERT INTO sansin_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","පශ්චාත් ස ස්වප්‍රභෝරේකෛකම් අධමර්ණම් ආහූය ප්‍රථමං පප්‍රච්ඡ, ත්වත්තෝ මේ ප්‍රභුණා කති ප්‍රාප්‍යම්? ");
INSERT INTO sansin_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","තතඃ ස උවාච, ඒකශතාඪකතෛලානි; තදා ගෘහකාර‍්‍ය්‍යාධීශඃ ප්‍රෝවාච, තව පත්‍රමානීය ශීඝ්‍රමුපවිශ්‍ය තත්‍ර පඤ්චාශතං ලිඛ| ");
INSERT INTO sansin_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","පශ්චාදන්‍යමේකං පප්‍රච්ඡ, ත්වත්තෝ මේ ප්‍රභුණා කති ප්‍රාප්‍යම්? තතඃ සෝවාදීද් ඒකශතාඪකගෝධූමාඃ; තදා ස කථයාමාස, තව පත්‍රමානීය අශීතිං ලිඛ| ");
INSERT INTO sansin_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","තේනෛව ප්‍රභුස්තමයථාර්ථකෘතම් අධීශං තද්බුද්ධිනෛපුණ්‍යාත් ප්‍රශශංස; ඉත්ථං දීප්තිරූපසන්තානේභ්‍ය ඒතත්සංසාරස්‍ය සන්තානා වර්ත්තමානකාලේ(අ)ධිකබුද්ධිමන්තෝ භවන්ති| ");
INSERT INTO sansin_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","අතෝ වදාමි යූයමප්‍යයථාර්ථේන ධනේන මිත්‍රාණි ලභධ්වං තතෝ යුෂ්මාසු පදභ්‍රෂ්ටේෂ්වපි තානි චිරකාලම් ආශ්‍රයං දාස්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","යඃ කශ්චිත් ක්‍ෂුද්‍රේ කාර‍්‍ය්‍යේ විශ්වාස්‍යෝ භවති ස මහති කාර‍්‍ය්‍යේපි විශ්වාස්‍යෝ භවති, කින්තු යඃ කශ්චිත් ක්‍ෂුද්‍රේ කාර‍්‍ය්‍යේ(අ)විශ්වාස්‍යෝ භවති ස මහති කාර‍්‍ය්‍යේප්‍යවිශ්වාස්‍යෝ භවති| ");
INSERT INTO sansin_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","අතඒව අයථාර්ථේන ධනේන යදි යූයමවිශ්වාස්‍යා ජාතාස්තර්හි සත්‍යං ධනං යුෂ්මාකං කරේෂු කඃ සමර්පයිෂ්‍යති? ");
INSERT INTO sansin_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","යදි ච පරධනේන යූයම් අවිශ්වාස්‍යා භවථ තර්හි යුෂ්මාකං ස්වකීයධනං යුෂ්මභ්‍යං කෝ දාස්‍යති? ");
INSERT INTO sansin_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","කෝපි දාස උභෞ ප්‍රභූ සේවිතුං න ශක්නෝති, යත ඒකස්මින් ප්‍රීයමාණෝ(අ)න්‍යස්මින්නප්‍රීයතේ යද්වා ඒකං ජනං සමාදෘත්‍ය තදන්‍යං තුච්ඡීකරෝති තද්වද් යූයමපි ධනේශ්වරෞ සේවිතුං න ශක්නුථ| ");
INSERT INTO sansin_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","තදෛතාඃ සර්ව්වාඃ කථාඃ ශ්‍රුත්වා ලෝභිඵිරූශිනස්තමුපජහසුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","තතඃ ස උවාච, යූයං මනුෂ්‍යාණාං නිකටේ ස්වාන් නිර්දෝෂාන් දර්ශයථ කින්තු යුෂ්මාකම් අන්තඃකරණානීශ්වරෝ ජානාති, යත් මනුෂ්‍යාණාම් අති ප්‍රශංස්‍යං තද් ඊශ්වරස්‍ය ඝෘණ්‍යං| ");
INSERT INTO sansin_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","යෝහන ආගමනපර‍්‍ය්‍යනතං යුෂ්මාකං සමීපේ ව්‍යවස්ථාභවිෂ්‍යද්වාදිනාං ලේඛනානි චාසන් තතඃ ප්‍රභෘති ඊශ්වරරාජ්‍යස්‍ය සුසංවාදඃ ප්‍රචරති, ඒකෛකෝ ලෝකස්තන්මධ්‍යං යත්නේන ප්‍රවිශති ච| ");
INSERT INTO sansin_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","වරං නභසඃ පෘථිව්‍යාශ්ච ලෝපෝ භවිෂ්‍යති තථාපි ව්‍යවස්ථායා ඒකබින්දෝරපි ලෝපෝ න භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","යඃ කශ්චිත් ස්වීයාං භාර‍්‍ය්‍යාං විහාය ස්ත්‍රියමන්‍යාං විවහති ස පරදාරාන් ගච්ඡති, යශ්ච තා ත්‍යක්තාං නාරීං විවහති සෝපි පරදාරාන ගච්ඡති| ");
INSERT INTO sansin_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ඒකෝ ධනී මනුෂ්‍යඃ ශුක්ලානි සූක්‍ෂ්මාණි වස්ත්‍රාණි පර‍්‍ය්‍යදධාත් ප්‍රතිදිනං පරිතෝෂරූපේණාභුංක්තාපිවච්ච| ");
INSERT INTO sansin_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","සර්ව්වාඞ්ගේ ක්‍ෂතයුක්ත ඉලියාසරනාමා කශ්චිද් දරිද්‍රස්තස්‍ය ධනවතෝ භෝජනපාත්‍රාත් පතිතම් උච්ඡිෂ්ටං භෝක්තුං වාඤ්ඡන් තස්‍ය ද්වාරේ පතිත්වාතිෂ්ඨත්; ");
INSERT INTO sansin_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","අථ ශ්වාන ආගත්‍ය තස්‍ය ක්‍ෂතාන්‍යලිහන්| ");
INSERT INTO sansin_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","කියත්කාලාත්පරං ස දරිද්‍රඃ ප්‍රාණාන් ජහෞ; තතඃ ස්වර්ගීයදූතාස්තං නීත්වා ඉබ්‍රාහීමඃ ක්‍රෝඩ උපවේශයාමාසුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","පශ්චාත් ස ධනවානපි මමාර, තං ශ්මශානේ ස්ථාපයාමාසුශ්ච; කින්තු පරලෝකේ ස වේදනාකුලඃ සන් ඌර්ද්ධ්වාං නිරීක්‍ෂ්‍ය බහුදූරාද් ඉබ්‍රාහීමං තත්ක්‍රෝඩ ඉලියාසරඤ්ච විලෝක්‍ය රුවන්නුවාච; ");
INSERT INTO sansin_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","හේ පිතර් ඉබ්‍රාහීම් අනුගෘහ්‍ය අඞ්ගුල්‍යග්‍රභාගං ජලේ මජ්ජයිත්වා මම ජිහ්වාං ශීතලාං කර්ත්තුම් ඉලියාසරං ප්‍රේරය, යතෝ වහ්නිශිඛාතෝහං ව්‍යථිතෝස්මි| ");
INSERT INTO sansin_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","තදා ඉබ්‍රාහීම් බභාෂේ, හේ පුත්‍ර ත්වං ජීවන් සම්පදං ප්‍රාප්තවාන් ඉලියාසරස්තු විපදං ප්‍රාප්තවාන් ඒතත් ස්මර, කින්තු සම්ප්‍රති තස්‍ය සුඛං තව ච දුඃඛං භවති| ");
INSERT INTO sansin_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","අපරමපි යුෂ්මාකම් අස්මාකඤ්ච ස්ථානයෝ ර්මධ්‍යේ මහද්විච්ඡේදෝ(අ)ස්ති තත ඒතත්ස්ථානස්‍ය ලෝකාස්තත් ස්ථානං යාතුං යද්වා තත්ස්ථානස්‍ය ලෝකා ඒතත් ස්ථානමායාතුං න ශක්නුවන්ති| ");
INSERT INTO sansin_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","තදා ස උක්තවාන්, හේ පිතස්තර්හි ත්වාං නිවේදයාමි මම පිතු ර්ගේහේ යේ මම පඤ්ච භ්‍රාතරඃ සන්ති ");
INSERT INTO sansin_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","තේ යථෛතද් යාතනාස්ථානං නායාස්‍යන්ති තථා මන්ත්‍රණාං දාතුං තේෂාං සමීපම් ඉලියාසරං ප්‍රේරය| ");
INSERT INTO sansin_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","තත ඉබ්‍රාහීම් උවාච, මූසාභවිෂ්‍යද්වාදිනාඤ්ච පුස්තකානි තේෂාං නිකටේ සන්ති තේ තද්වචනානි මන්‍යන්තාං| ");
INSERT INTO sansin_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","තදා ස නිවේදයාමාස, හේ පිතර් ඉබ්‍රාහීම් න තථා, කින්තු යදි මෘතලෝකානාං කශ්චිත් තේෂාං සමීපං යාති තර්හි තේ මනාංසි ව්‍යාඝෝටයිෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","තත ඉබ්‍රාහීම් ජගාද, තේ යදි මූසාභවිෂ්‍යද්වාදිනාඤ්ච වචනානි න මන්‍යන්තේ තර්හි මෘතලෝකානාං කස්මිංශ්චිද් උත්ථිතේපි තේ තස්‍ය මන්ත්‍රණාං න මංස්‍යන්තේ| ");
INSERT INTO sansin_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ඉතඃ පරං යීශුඃ ශිෂ්‍යාන් උවාච, විඝ්නෛරවශ්‍යම් ආගන්තව්‍යං කින්තු විඝ්නා යේන ඝටිෂ්‍යන්තේ තස්‍ය දුර්ගති ර්භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ඒතේෂාං ක්‍ෂුද්‍රප්‍රාණිනාම් ඒකස්‍යාපි විඝ්නජනනාත් කණ්ඨබද්ධපේෂණීකස්‍ය තස්‍ය සාගරාගාධජලේ මජ්ජනං භද්‍රං| ");
INSERT INTO sansin_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","යූයං ස්වේෂු සාවධානාස්තිෂ්ඨත; තව භ්‍රාතා යදි තව කිඤ්චිද් අපරාධ්‍යති තර්හි තං තර්ජය, තේන යදි මනඃ පරිවර්ත්තයති තර්හි තං ක්‍ෂමස්ව| ");
INSERT INTO sansin_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","පුනරේකදිනමධ්‍යේ යදි ස තව සප්තකෘත්වෝ(අ)පරාධ්‍යති කින්තු සප්තකෘත්ව ආගත්‍ය මනඃ පරිවර්ත්‍ය මයාපරාද්ධම් ඉති වදති තර්හි තං ක්‍ෂමස්ව| ");
INSERT INTO sansin_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","තදා ප්‍රේරිතාඃ ප්‍රභුම් අවදන් අස්මාකං විශ්වාසං වර්ද්ධය| ");
INSERT INTO sansin_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ප්‍රභුරුවාච, යදි යුෂ්මාකං සර්ෂපෛකප්‍රමාණෝ විශ්වාසෝස්ති තර්හි ත්වං සමූලමුත්පාටිතෝ භූත්වා සමුද්‍රේ රෝපිතෝ භව කථායාම් ඒතස්‍යාම් ඒතදුඩුම්බරාය කථිතායාං ස යුෂ්මාකමාඥාවහෝ භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","අපරං ස්වදාසේ හලං වාහයිත්වා වා පශූන් චාරයිත්වා ක්‍ෂේත්‍රාද් ආගතේ සති තං වදති, ඒහි භෝක්තුමුපවිශ, යුෂ්මාකම් ඒතාදෘශඃ කෝස්ති? ");
INSERT INTO sansin_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","වරඤ්ච පූර්ව්වං මම ඛාද්‍යමාසාද්‍ය යාවද් භුඤ්ජේ පිවාමි ච තාවද් බද්ධකටිඃ පරිචර පශ්චාත් ත්වමපි භෝක්‍ෂ්‍යසේ පාස්‍යසි ච කථාමීදෘශීං කිං න වක්‍ෂ්‍යති? ");
INSERT INTO sansin_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","තේන දාසේන ප්‍රභෝරාඥානුරූපේ කර්ම්මණි කෘතේ ප්‍රභුඃ කිං තස්මින් බාධිතෝ ජාතඃ? නේත්ථං බුධ්‍යතේ මයා| ");
INSERT INTO sansin_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ඉත්ථං නිරූපිතේෂු සර්ව්වකර්ම්මසු කෘතේෂු සත්මු යූයමපීදං වාක්‍යං වදථ, වයම් අනුපකාරිණෝ දාසා අස්මාභිර‍්‍යද්‍යත්කර්ත්තව්‍යං තන්මාත්‍රමේව කෘතං| ");
INSERT INTO sansin_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ස යිරූශාලමි යාත්‍රාං කුර්ව්වන් ශෝමිරෝණ්ගාලීල්ප්‍රදේශමධ්‍යේන ගච්ඡති, ");
INSERT INTO sansin_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ඒතර්හි කුත්‍රචිද් ග්‍රාමේ ප්‍රවේශමාත්‍රේ දශකුෂ්ඨිනස්තං සාක්‍ෂාත් කෘත්වා ");
INSERT INTO sansin_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","දූරේ තිෂ්ඨනත උච්චෛ ර්වක්තුමාරේභිරේ, හේ ප්‍රභෝ යීශෝ දයස්වාස්මාන්| ");
INSERT INTO sansin_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","තතඃ ස තාන් දෘෂ්ට්වා ජගාද, යූයං යාජකානාං සමීපේ ස්වාන් දර්ශයත, තතස්තේ ගච්ඡන්තෝ රෝගාත් පරිෂ්කෘතාඃ| ");
INSERT INTO sansin_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","තදා තේෂාමේකඃ ස්වං ස්වස්ථං දෘෂ්ට්වා ප්‍රෝච්චෛරීශ්වරං ධන්‍යං වදන් ව්‍යාඝුට්‍යායාතෝ යීශෝ ර්ගුණානනුවදන් තච්චරණාධෝභූමෞ පපාත; ");
INSERT INTO sansin_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ස චාසීත් ශෝමිරෝණී| ");
INSERT INTO sansin_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","තදා යීශුරවදත්, දශජනාඃ කිං න පරිෂ්කෘතාඃ? තහ්‍යන්‍යේ නවජනාඃ කුත්‍ර? ");
INSERT INTO sansin_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ඊශ්වරං ධන්‍යං වදන්තම් ඒනං විදේශිනං විනා කෝප්‍යන්‍යෝ න ප්‍රාප්‍යත| ");
INSERT INTO sansin_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","තදා ස තමුවාච, ත්වමුත්ථාය යාහි විශ්වාසස්තේ ත්වාං ස්වස්ථං කෘතවාන්| ");
INSERT INTO sansin_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","අථ කදේශ්වරස්‍ය රාජත්වං භවිෂ්‍යතීති ඵිරූශිභිඃ පෘෂ්ටේ ස ප්‍රත්‍යුවාච, ඊශ්වරස්‍ය රාජත්වම් ඓශ්වර‍්‍ය්‍යදර්ශනේන න භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","අත ඒතස්මින් පශ්‍ය තස්මින් වා පශ්‍ය, ඉති වාක්‍යං ලෝකා වක්තුං න ශක්‍ෂ්‍යන්ති, ඊශ්වරස්‍ය රාජත්වං යුෂ්මාකම් අන්තරේවාස්තේ| ");
INSERT INTO sansin_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","තතඃ ස ශිෂ්‍යාන් ජගාද, යදා යුෂ්මාභි ර්මනුජසුතස්‍ය දිනමේකං ද්‍රෂ්ටුම් වාඤ්ඡිෂ්‍යතේ කින්තු න දර්ශිෂ්‍යතේ, ඊදෘක්කාල ආයාති| ");
INSERT INTO sansin_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","තදාත්‍ර පශ්‍ය වා තත්‍ර පශ්‍යේති වාක්‍යං ලෝකා වක්‍ෂ්‍යන්ති, කින්තු තේෂාං පශ්චාත් මා යාත, මානුගච්ඡත ච| ");
INSERT INTO sansin_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","යතස්තඩිද් යථාකාශෛකදිශ්‍යුදිය තදන්‍යාමපි දිශං ව්‍යාප්‍ය ප්‍රකාශතේ තද්වත් නිජදිනේ මනුජසූනුඃ ප්‍රකාශිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","කින්තු තත්පූර්ව්වං තේනානේකානි දුඃඛානි භෝක්තව්‍යාන්‍යේතද්වර්ත්තමානලෝකෛශ්ච සෝ(අ)වඥාතව්‍යඃ| ");
INSERT INTO sansin_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","නෝහස්‍ය විද්‍යමානකාලේ යථාභවත් මනුෂ්‍යසූනෝඃ කාලේපි තථා භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","යාවත්කාලං නෝහෝ මහාපෝතං නාරෝහද් ආප්ලාවිවාර‍්‍ය්‍යේත්‍ය සර්ව්වං නානාශයච්ච තාවත්කාලං යථා ලෝකා අභුඤ්ජතාපිවන් ව්‍යවහන් ව්‍යවාහයංශ්ච; ");
INSERT INTO sansin_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ඉත්ථං ලෝටෝ වර්ත්තමානකාලේපි යථා ලෝකා භෝජනපානක්‍රයවික්‍රයරෝපණගෘහනිර්ම්මාණකර්ම්මසු ප්‍රාවර්ත්තන්ත, ");
INSERT INTO sansin_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","කින්තු යදා ලෝට් සිදෝමෝ නිර්ජගාම තදා නභසඃ සගන්ධකාග්නිවෘෂ්ටි ර්භූත්වා සර්ව්වං ව්‍යනාශයත් ");
INSERT INTO sansin_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","තද්වන් මානවපුත්‍රප්‍රකාශදිනේපි භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","තදා යදි කශ්චිද් ගෘහෝපරි තිෂ්ඨති තර්හි ස ගෘහමධ්‍යාත් කිමපි ද්‍රව්‍යමානේතුම් අවරුහ්‍ය නෛතු; යශ්ච ක්‍ෂේත්‍රේ තිෂ්ඨති සෝපි ව්‍යාඝුට්‍ය නායාතු| ");
INSERT INTO sansin_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","ලෝටඃ පත්නීං ස්මරත| ");
INSERT INTO sansin_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","යඃ ප්‍රාණාන් රක්‍ෂිතුං චේෂ්ටිෂ්‍යතේ ස ප්‍රාණාන් හාරයිෂ්‍යති යස්තු ප්‍රාණාන් හාරයිෂ්‍යති සඒව ප්‍රාණාන් රක්‍ෂිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","යුෂ්මානහං වච්මි තස්‍යාං රාත්‍රෞ ශය්‍යෛකගතයෝ ර්ලෝකයෝරේකෝ ධාරිෂ්‍යතේ පරස්ත්‍යක්‍ෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ස්ත්‍රියෞ යුගපත් පේෂණීං ව්‍යාවර්ත්තයිෂ්‍යතස්තයෝරේකා ධාරිෂ්‍යතේ පරාත්‍යක්‍ෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","පුරුෂෞ ක්‍ෂේත්‍රේ ස්ථාස්‍යතස්තයෝරේකෝ ධාරිෂ්‍යතේ පරස්ත්‍යක්‍ෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","තදා තේ පප්‍රච්ඡුඃ, හේ ප්‍රභෝ කුත්‍රේත්ථං භවිෂ්‍යති? තතඃ ස උවාච, යත්‍ර ශවස්තිෂ්ඨති තත්‍ර ගෘධ්‍රා මිලන්ති| ");
INSERT INTO sansin_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","අපරඤ්ච ලෝකෛරක්ලාන්තෛ ර්නිරන්තරං ප්‍රාර්ථයිතව්‍යම් ඉත්‍යාශයේන යීශුනා දෘෂ්ටාන්ත ඒකඃ කථිතඃ| ");
INSERT INTO sansin_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","කුත්‍රචින්නගරේ කශ්චිත් ප්‍රාඩ්විවාක ආසීත් ස ඊශ්වරාන්නාබිභේත් මානුෂාංශ්ච නාමන්‍යත| ");
INSERT INTO sansin_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","අථ තත්පුරවාසිනී කාචිද්විධවා තත්සමීපමේත්‍ය විවාදිනා සහ මම විවාදං පරිෂ්කුර්ව්විති නිවේදයාමාස| ");
INSERT INTO sansin_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","තතඃ ස ප්‍රාඩ්විවාකඃ කියද්දිනානි න තදඞ්ගීකෘතවාන් පශ්චාච්චිත්තේ චින්තයාමාස, යද්‍යපීශ්වරාන්න බිභේමි මනුෂ්‍යානපි න මන්‍යේ ");
INSERT INTO sansin_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","තථාප්‍යේෂා විධවා මාං ක්ලිශ්නාති තස්මාදස්‍යා විවාදං පරිෂ්කරිෂ්‍යාමි නෝචේත් සා සදාගත්‍ය මාං ව්‍යග්‍රං කරිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","පශ්චාත් ප්‍රභුරවදද් අසාවන්‍යායප්‍රාඩ්විවාකෝ යදාහ තත්‍ර මනෝ නිධධ්වං| ");
INSERT INTO sansin_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ඊශ්වරස්‍ය යේ (අ)භිරුචිතලෝකා දිවානිශං ප්‍රාර්ථයන්තේ ස බහුදිනානි විලම්බ්‍යාපි තේෂාං විවාදාන් කිං න පරිෂ්කරිෂ්‍යති? ");
INSERT INTO sansin_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","යුෂ්මානහං වදාමි ත්වරයා පරිෂ්කරිෂ්‍යති, කින්තු යදා මනුෂ්‍යපුත්‍ර ආගමිෂ්‍යති තදා පෘථිව්‍යාං කිමීදෘශං විශ්වාසං ප්‍රාප්ස්‍යති? ");
INSERT INTO sansin_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","යේ ස්වාන් ධාර්ම්මිකාන් ඥාත්වා පරාන් තුච්ඡීකුර්ව්වන්ති ඒතාදෘග්භ්‍යඃ, කියද්භ්‍ය ඉමං දෘෂ්ටාන්තං කථයාමාස| ");
INSERT INTO sansin_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","ඒකඃ ඵිරූශ්‍යපරඃ කරසඤ්චායී ද්වාවිමෞ ප්‍රාර්ථයිතුං මන්දිරං ගතෞ| ");
INSERT INTO sansin_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","තතෝ(අ)සෞ ඵිරූශ්‍යේකපාර්ශ්වේ තිෂ්ඨන් හේ ඊශ්වර අහමන්‍යලෝකවත් ලෝඨයිතාන්‍යායී පාරදාරිකශ්ච න භවාමි අස්‍ය කරසඤ්චායිනස්තුල්‍යශ්ච න, තස්මාත්ත්වාං ධන්‍යං වදාමි| ");
INSERT INTO sansin_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","සප්තසු දිනේෂු දිනද්වයමුපවසාමි සර්ව්වසම්පත්තේ ර්දශමාංශං දදාමි ච, ඒතත්කථාං කථයන් ප්‍රාර්ථයාමාස| ");
INSERT INTO sansin_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","කින්තු ස කරසඤ්චායි දූරේ තිෂ්ඨන් ස්වර්ගං ද්‍රෂ්ටුං නේච්ඡන් වක්‍ෂසි කරාඝාතං කුර්ව්වන් හේ ඊශ්වර පාපිෂ්ඨං මාං දයස්ව, ඉත්ථං ප්‍රාර්ථයාමාස| ");
INSERT INTO sansin_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","යුෂ්මානහං වදාමි, තයෝර්ද්වයෝ ර්මධ්‍යේ කේවලඃ කරසඤ්චායී පුණ්‍යවත්ත්වේන ගණිතෝ නිජගෘහං ජගාම, යතෝ යඃ කශ්චිත් ස්වමුන්නමයති ස නාමයිෂ්‍යතේ කින්තු යඃ කශ්චිත් ස්වං නමයති ස උන්නමයිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","අථ ශිශූනාං ගාත්‍රස්පර්ශාර්ථං ලෝකාස්තාන් තස්‍ය සමීපමානින්‍යුඃ ශිෂ්‍යාස්තද් දෘෂ්ට්වානේතෘන් තර්ජයාමාසුඃ, ");
INSERT INTO sansin_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","කින්තු යීශුස්තානාහූය ජගාද, මන්නිකටම් ආගන්තුං ශිශූන් අනුජානීධ්වං තාංශ්ච මා වාරයත; යත ඊශ්වරරාජ්‍යාධිකාරිණ ඒෂාං සදෘශාඃ| ");
INSERT INTO sansin_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","අහං යුෂ්මාන් යථාර්ථං වදාමි, යෝ ජනඃ ශිශෝඃ සදෘශෝ භූත්වා ඊශ්වරරාජ්‍යං න ගෘහ්ලාති ස කේනාපි ප්‍රකාරේණ තත් ප්‍රවේෂ්ටුං න ශක්නෝති| ");
INSERT INTO sansin_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","අපරම් ඒකෝධිපතිස්තං පප්‍රච්ඡ, හේ පරමගුරෝ, අනන්තායුෂඃ ප්‍රාප්තයේ මයා කිං කර්ත්තව්‍යං? ");
INSERT INTO sansin_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","යීශුරුවාච, මාං කුතඃ පරමං වදසි? ඊශ්වරං විනා කෝපි පරමෝ න භවති| ");
INSERT INTO sansin_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","පරදාරාන් මා ගච්ඡ, නරං මා ජහි, මා චෝරය, මිථ්‍යාසාක්‍ෂ්‍යං මා දේහි, මාතරං පිතරඤ්ච සංමන්‍යස්ව, ඒතා යා ආඥාඃ සන්ති තාස්ත්වං ජානාසි| ");
INSERT INTO sansin_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","තදා ස උවාච, බාල්‍යකාලාත් සර්ව්වා ඒතා ආචරාමි| ");
INSERT INTO sansin_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ඉති කථාං ශ්‍රුත්වා යීශුස්තමවදත්, තථාපි තවෛකං කර්ම්ම න්‍යූනමාස්තේ, නිජං සර්ව්වස්වං වික්‍රීය දරිද්‍රේභ්‍යෝ විතර, තස්මාත් ස්වර්ගේ ධනං ප්‍රාප්ස්‍යසි; තත ආගත්‍ය මමානුගාමී භව| ");
INSERT INTO sansin_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","කින්ත්වේතාං කථාං ශ්‍රුත්වා සෝධිපතිඃ ශුශෝච, යතස්තස්‍ය බහුධනමාසීත්| ");
INSERT INTO sansin_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","තදා යීශුස්තමතිශෝකාන්විතං දෘෂ්ට්වා ජගාද, ධනවතාම් ඊශ්වරරාජ්‍යප්‍රවේශඃ කීදෘග් දුෂ්කරඃ| ");
INSERT INTO sansin_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ඊශ්වරරාජ්‍යේ ධනිනඃ ප්‍රවේශාත් සූචේශ්ඡිද්‍රේණ මහාඞ්ගස්‍ය ගමනාගමනේ සුකරේ| ");
INSERT INTO sansin_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ශ්‍රෝතාරඃ පප්‍රච්ඡුස්තර්හි කේන පරිත්‍රාණං ප්‍රාප්ස්‍යතේ? ");
INSERT INTO sansin_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ස උක්තවාන්, යන් මානුෂේණාශක්‍යං තද් ඊශ්වරේණ ශක්‍යං| ");
INSERT INTO sansin_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","තදා පිතර උවාච, පශ්‍ය වයං සර්ව්වස්වං පරිත්‍යජ්‍ය තව පශ්චාද්ගාමිනෝ(අ)භවාම| ");
INSERT INTO sansin_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","තතඃ ස උවාච, යුෂ්මානහං යථාර්ථං වදාමි, ඊශ්වරරාජ්‍යාර්ථං ගෘහං පිතරෞ භ්‍රාතෘගණං ජායාං සන්තානාංශ්ච ත්‍යක්තවා ");
INSERT INTO sansin_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ඉහ කාලේ තතෝ(අ)ධිකං පරකාලේ (අ)නන්තායුශ්ච න ප්‍රාප්ස්‍යති ලෝක ඊදෘශඃ කෝපි නාස්ති| ");
INSERT INTO sansin_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","අනන්තරං ස ද්වාදශශිෂ්‍යානාහූය බභාෂේ, පශ්‍යත වයං යිරූශාලම්නගරං යාමඃ, තස්මාත් මනුෂ්‍යපුත්‍රේ භවිෂ්‍යද්වාදිභිරුක්තං යදස්ති තදනුරූපං තං ප්‍රති ඝටිෂ්‍යතේ; ");
INSERT INTO sansin_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","වස්තුතස්තු සෝ(අ)න්‍යදේශීයානාං හස්තේෂු සමර්පයිෂ්‍යතේ, තේ තමුපහසිෂ්‍යන්ති, අන්‍යායමාචරිෂ්‍යන්ති තද්වපුෂි නිෂ්ඨීවං නික්‍ෂේප්ස්‍යන්ති, කශාභිඃ ප්‍රහෘත්‍ය තං හනිෂ්‍යන්ති ච, ");
INSERT INTO sansin_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","කින්තු තෘතීයදිනේ ස ශ්මශානාද් උත්ථාස්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ඒතස්‍යාඃ කථායා අභිප්‍රායං කිඤ්චිදපි තේ බෝද්ධුං න ශේකුඃ තේෂාං නිකටේ(අ)ස්පෂ්ටතවාත් තස්‍යෛතාසාං කථානාම් ආශයං තේ ඥාතුං න ශේකුශ්ච| ");
INSERT INTO sansin_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","අථ තස්මින් යිරීහෝඃ පුරස්‍යාන්තිකං ප්‍රාප්තේ කශ්චිදන්ධඃ පථඃ පාර්ශ්ව උපවිශ්‍ය භික්‍ෂාම් අකරෝත් ");
INSERT INTO sansin_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ස ලෝකසමූහස්‍ය ගමනශබ්දං ශ්‍රුත්වා තත්කාරණං පෘෂ්ටවාන්| ");
INSERT INTO sansin_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","නාසරතීයයීශුර‍්‍යාතීති ලෝකෛරුක්තේ ස උච්චෛර්වක්තුමාරේභේ, ");
INSERT INTO sansin_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","හේ දායූදඃ සන්තාන යීශෝ මාං දයස්ව| ");
INSERT INTO sansin_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","තතෝග්‍රගාමිනස්තං මෞනී තිෂ්ඨේති තර්ජයාමාසුඃ කින්තු ස පුනාරුවන් උවාච, හේ දායූදඃ සන්තාන මාං දයස්ව| ");
INSERT INTO sansin_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","තදා යීශුඃ ස්ථගිතෝ භූත්වා ස්වාන්තිකේ තමානේතුම් ආදිදේශ| ");
INSERT INTO sansin_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","තතඃ ස තස්‍යාන්තිකම් ආගමත්, තදා ස තං පප්‍රච්ඡ, ත්වං කිමිච්ඡසි? ත්වදර්ථමහං කිං කරිෂ්‍යාමි? ස උක්තවාන්, හේ ප්‍රභෝ(අ)හං ද්‍රෂ්ටුං ලභෛ| ");
INSERT INTO sansin_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","තදා යීශුරුවාච, දෘෂ්ටිශක්තිං ගෘහාණ තව ප්‍රත්‍යයස්ත්වාං ස්වස්ථං කෘතවාන්| ");
INSERT INTO sansin_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","තතස්තත්ක්‍ෂණාත් තස්‍ය චක්‍ෂුෂී ප්‍රසන්නේ; තස්මාත් ස ඊශ්වරං ධන්‍යං වදන් තත්පශ්චාද් යයෞ, තදාලෝක්‍ය සර්ව්වේ ලෝකා ඊශ්වරං ප්‍රශංසිතුම් ආරේභිරේ| ");
INSERT INTO sansin_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","යදා යීශු ර‍්‍යිරීහෝපුරං ප්‍රවිශ්‍ය තන්මධ්‍යේන ගච්ඡංස්තදා ");
INSERT INTO sansin_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","සක්කේයනාමා කරසඤ්චායිනාං ප්‍රධානෝ ධනවානේකෝ ");
INSERT INTO sansin_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","යීශුඃ කීදෘගිති ද්‍රෂ්ටුං චේෂ්ටිතවාන් කින්තු ඛර්ව්වත්වාල්ලෝකසංඝමධ්‍යේ තද්දර්ශනමප්‍රාප්‍ය ");
INSERT INTO sansin_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","යේන පථා ස යාස්‍යති තත්පථේ(අ)ග්‍රේ ධාවිත්වා තං ද්‍රෂ්ටුම් උඩුම්බරතරුමාරුරෝහ| ");
INSERT INTO sansin_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","පශ්චාද් යීශුස්තත්ස්ථානම් ඉත්වා ඌර්ද්ධ්වං විලෝක්‍ය තං දෘෂ්ට්වාවාදීත්, හේ සක්කේය ත්වං ශීඝ්‍රමවරෝහ මයාද්‍ය ත්වද්ගේහේ වස්තව්‍යං| ");
INSERT INTO sansin_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","තතඃ ස ශීඝ්‍රමවරුහ්‍ය සාහ්ලාදං තං ජග්‍රාහ| ");
INSERT INTO sansin_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","තද් දෘෂ්ට්වා සර්ව්වේ විවදමානා වක්තුමාරේභිරේ, සෝතිථිත්වේන දුෂ්ටලෝකගෘහං ගච්ඡති| ");
INSERT INTO sansin_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","කින්තු සක්කේයෝ දණ්ඩායමානෝ වක්තුමාරේභේ, හේ ප්‍රභෝ පශ්‍ය මම යා සම්පත්තිරස්ති තදර්ද්ධං දරිද්‍රේභ්‍යෝ දදේ, අපරම් අන්‍යායං කෘත්වා කස්මාදපි යදි කදාපි කිඤ්චිත් මයා ගෘහීතං තර්හි තච්චතුර්ගුණං දදාමි| ");
INSERT INTO sansin_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","තදා යීශුස්තමුක්තවාන් අයමපි ඉබ්‍රාහීමඃ සන්තානෝ(අ)තඃ කාරණාද් අද්‍යාස්‍ය ගෘහේ ත්‍රාණමුපස්ථිතං| ");
INSERT INTO sansin_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","යද් හාරිතං තත් මෘගයිතුං රක්‍ෂිතුඤ්ච මනුෂ්‍යපුත්‍ර ආගතවාන්| ");
INSERT INTO sansin_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","අථ ස යිරූශාලමඃ සමීප උපාතිෂ්ඨද් ඊශ්වරරාජත්වස්‍යානුෂ්ඨානං තදෛව භවිෂ්‍යතීති ලෝකෛරන්වභූයත, තස්මාත් ස ශ්‍රෝතෘභ්‍යඃ පුනර්දෘෂ්ටාන්තකථාම් උත්ථාප්‍ය කථයාමාස| ");
INSERT INTO sansin_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","කෝපි මහාල්ලෝකෝ නිජාර්ථං රාජත්වපදං ගෘහීත්වා පුනරාගන්තුං දූරදේශං ජගාම| ");
INSERT INTO sansin_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","යාත්‍රාකාලේ නිජාන් දශදාසාන් ආහූය දශස්වර්ණමුද්‍රා දත්ත්වා මමාගමනපර‍්‍ය්‍යන්තං වාණිජ්‍යං කුරුතේත්‍යාදිදේශ| ");
INSERT INTO sansin_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","කින්තු තස්‍ය ප්‍රජාස්තමවඥාය මනුෂ්‍යමේනම් අස්මාකමුපරි රාජත්වං න කාරයිව්‍යාම ඉමාං වාර්ත්තාං තන්නිකටේ ප්‍රේරයාමාසුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","අථ ස රාජත්වපදං ප්‍රාප්‍යාගතවාන් ඒකෛකෝ ජනෝ බාණිජ්‍යේන කිං ලබ්ධවාන් ඉති ඥාතුං යේෂු දාසේෂු මුද්‍රා අර්පයත් තාන් ආහූයානේතුම් ආදිදේශ| ");
INSERT INTO sansin_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","තදා ප්‍රථම ආගත්‍ය කථිතවාන්, හේ ප්‍රභෝ තව තයෛකයා මුද්‍රයා දශමුද්‍රා ලබ්ධාඃ| ");
INSERT INTO sansin_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","තතඃ ස උවාච ත්වමුත්තමෝ දාසඃ ස්වල්පේන විශ්වාස්‍යෝ ජාත ඉතඃ කාරණාත් ත්වං දශනගරාණාම් අධිපෝ භව| ");
INSERT INTO sansin_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","ද්විතීය ආගත්‍ය කථිතවාන්, හේ ප්‍රභෝ තවෛකයා මුද්‍රයා පඤ්චමුද්‍රා ලබ්ධාඃ| ");
INSERT INTO sansin_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","තතඃ ස උවාච, ත්වං පඤ්චානාං නගරාණාමධිපති ර්භව| ");
INSERT INTO sansin_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","තතෝන්‍ය ආගත්‍ය කථයාමාස, හේ ප්‍රභෝ පශ්‍ය තව යා මුද්‍රා අහං වස්ත්‍රේ බද්ධ්වාස්ථාපයං සේයං| ");
INSERT INTO sansin_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ත්වං කෘපණෝ යන්නාස්ථාපයස්තදපි ගෘහ්ලාසි, යන්නාවපස්තදේව ච ඡිනත්සි තතෝහං ත්වත්තෝ භීතඃ| ");
INSERT INTO sansin_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","තදා ස ජගාද, රේ දුෂ්ටදාස තව වාක්‍යේන ත්වාං දෝෂිණං කරිෂ්‍යාමි, යදහං නාස්ථාපයං තදේව ගෘහ්ලාමි, යදහං නාවපඤ්ච තදේව ඡිනද්මි, ඒතාදෘශඃ කෘපණෝහමිති යදි ත්වං ජානාසි, ");
INSERT INTO sansin_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","තර්හි මම මුද්‍රා බණිජාං නිකටේ කුතෝ නාස්ථාපයඃ? තයා කෘතේ(අ)හම් ආගත්‍ය කුසීදේන සාර්ද්ධං නිජමුද්‍රා අප්‍රාප්ස්‍යම්| ");
INSERT INTO sansin_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","පශ්චාත් ස සමීපස්ථාන් ජනාන් ආඥාපයත් අස්මාත් මුද්‍රා ආනීය යස්‍ය දශමුද්‍රාඃ සන්ති තස්මෛ දත්ත| ");
INSERT INTO sansin_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","තේ ප්‍රෝචුඃ ප්‍රභෝ(අ)ස්‍ය දශමුද්‍රාඃ සන්ති| ");
INSERT INTO sansin_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","යුෂ්මානහං වදාමි යස්‍යාශ්‍රයේ වද්ධතේ (අ)ධිකං තස්මෛ දායිෂ්‍යතේ, කින්තු යස්‍යාශ්‍රයේ න වර්ද්ධතේ තස්‍ය යද්‍යදස්ති තදපි තස්මාන් නායිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","කින්තු මමාධිපතිත්වස්‍ය වශත්වේ ස්ථාතුම් අසම්මන්‍යමානා යේ මම රිපවස්තානානීය මම සමක්‍ෂං සංහරත| ");
INSERT INTO sansin_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ඉත්‍යුපදේශකථාං කථයිත්වා සෝග්‍රගඃ සන් යිරූශාලමපුරං යයෞ| ");
INSERT INTO sansin_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","තතෝ බෛත්ඵගීබෛථනීයාග්‍රාමයෝඃ සමීපේ ජෛතුනාද්‍රේරන්තිකම් ඉත්වා ශිෂ්‍යද්වයම් ඉත්‍යුක්ත්වා ප්‍රේෂයාමාස, ");
INSERT INTO sansin_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","යුවාමමුං සම්මුඛස්ථග්‍රාමං ප්‍රවිශ්‍යෛව යං කෝපි මානුෂඃ කදාපි නාරෝහත් තං ගර්ද්දභශාවකං බද්ධං ද්‍රක්‍ෂ්‍යථස්තං මෝචයිත්වානයතං| ");
INSERT INTO sansin_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","තත්‍ර කුතෝ මෝචයථඃ? ඉති චේත් කෝපි වක්‍ෂ්‍යති තර්හි වක්‍ෂ්‍යථඃ ප්‍රභේाරත්‍ර ප්‍රයෝජනම් ආස්තේ| ");
INSERT INTO sansin_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","තදා තෞ ප්‍රරිතෞ ගත්වා තත්කථාाනුසාරේණ සර්ව්වං ප්‍රාප්තෞ| ");
INSERT INTO sansin_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ගර්දභශාවකමෝචනකාලේ තත්වාමින ඌචුඃ, ගර්දභශාවකං කුතෝ මෝචයථඃ? ");
INSERT INTO sansin_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","තාවූචතුඃ ප්‍රභෝරත්‍ර ප්‍රයෝජනම් ආස්තේ| ");
INSERT INTO sansin_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","පශ්චාත් තෞ තං ගර්දභශාවකං යීශෝරන්තිකමානීය තත්පෘෂ්ඨේ නිජවසනානි පාතයිත්වා තදුපරි යීශුමාරෝහයාමාසතුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","අථ යාත්‍රාකාලේ ලෝකාඃ පථි ස්වවස්ත්‍රාණි පාතයිතුම් ආරේභිරේ| ");
INSERT INTO sansin_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","අපරං ජෛතුනාද්‍රේරුපත්‍යකාම් ඉත්වා ශිෂ්‍යසංඝඃ පූර්ව්වදෘෂ්ටානි මහාකර්ම්මාණි ස්මෘත්වා, ");
INSERT INTO sansin_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","යෝ රාජා ප්‍රභෝ ර්නාම්නායාති ස ධන්‍යඃ ස්වර්ගේ කුශලං සර්ව්වෝච්චේ ජයධ්වනි ර්භවතු, කථාමේතාං කථයිත්වා සානන්දම් උචෛරීශ්වරං ධන්‍යං වක්තුමාරේභේ| ");
INSERT INTO sansin_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","තදා ලෝකාරණ්‍යමධ්‍යස්ථාඃ කියන්තඃ ඵිරූශිනස්තත් ශ්‍රුත්වා යීශුං ප්‍රෝචුඃ, හේ උපදේශක ස්වශිෂ්‍යාන් තර්ජය| ");
INSERT INTO sansin_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ස උවාච, යුෂ්මානහං වදාමි යද්‍යමී නීරවාස්තිෂ්ඨන්ති තර්හි පාෂාණා උචෛඃ කථාඃ කථයිෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","පශ්චාත් තත්පුරාන්තිකමේත්‍ය තදවලෝක්‍ය සාශ්‍රුපාතං ජගාද, ");
INSERT INTO sansin_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","හා හා චේත් ත්වමග්‍රේ(අ)ඥාස්‍යථාඃ, තවාස්මින්නේව දිනේ වා යදි ස්වමඞ්ගලම් උපාලප්ස්‍යථාඃ, තර්හ්‍යුත්තමම් අභවිෂ්‍යත්, කින්තු ක්‍ෂණේස්මින් තත්තව දෘෂ්ටේරගෝචරම් භවති| ");
INSERT INTO sansin_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ත්වං ස්වත්‍රාණකාලේ න මනෝ න්‍යධත්ථා ඉති හේතෝ ර‍්‍යත්කාලේ තව රිපවස්ත්වාං චතුර්දික්‍ෂු ප්‍රාචීරේණ වේෂ්ටයිත්වා රෝත්ස්‍යන්ති ");
INSERT INTO sansin_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","බාලකෛඃ සාර්ද්ධං භූමිසාත් කරිෂ්‍යන්ති ච ත්වන්මධ්‍යේ පාෂාණෛකෝපි පාෂාණෝපරි න ස්ථාස්‍යති ච, කාල ඊදෘශ උපස්ථාස්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","අථ මධ්‍යේමන්දිරං ප්‍රවිශ්‍ය තත්‍රත්‍යාන් ක්‍රයිවික්‍රයිණෝ බහිෂ්කුර්ව්වන් ");
INSERT INTO sansin_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","අවදත් මද්ගෘහං ප්‍රාර්ථනාගෘහමිති ලිපිරාස්තේ කින්තු යූයං තදේව චෛරාණාං ගහ්වරං කුරුථ| ");
INSERT INTO sansin_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","පශ්චාත් ස ප්‍රත්‍යහං මධ්‍යේමන්දිරම් උපදිදේශ; තතඃ ප්‍රධානයාජකා අධ්‍යාපකාඃ ප්‍රාචීනාශ්ච තං නාශයිතුං චිචේෂ්ටිරේ; ");
INSERT INTO sansin_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","කින්තු තදුපදේශේ සර්ව්වේ ලෝකා නිවිෂ්ටචිත්තාඃ ස්ථිතාස්තස්මාත් තේ තත්කර්ත්තුං නාවකාශං ප්‍රාපුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","අථෛකදා යීශු ර්මනිදරේ සුසංවාදං ප්‍රචාරයන් ලෝකානුපදිශති, ඒතර්හි ප්‍රධානයාජකා අධ්‍යාපකාඃ ප්‍රාඤ්චශ්ච තන්නිකටමාගත්‍ය පප්‍රච්ඡුඃ ");
INSERT INTO sansin_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","කයාඥයා ත්වං කර්ම්මාණ්‍යේතානි කරෝෂි? කෝ වා ත්වාමාඥාපයත්? තදස්මාන් වද| ");
INSERT INTO sansin_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ස ප්‍රත්‍යුවාච, තර්හි යුෂ්මානපි කථාමේකාං පෘච්ඡාමි තස්‍යෝත්තරං වදත| ");
INSERT INTO sansin_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","යෝහනෝ මජ්ජනම් ඊශ්වරස්‍ය මානුෂාණාං වාඥාතෝ ජාතං? ");
INSERT INTO sansin_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","තතස්තේ මිථෝ විවිච්‍ය ජගදුඃ, යදීශ්වරස්‍ය වදාමස්තර්හි තං කුතෝ න ප්‍රත්‍යෛත ස ඉති වක්‍ෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","යදි මනුෂ්‍යස්‍යේති වදාමස්තර්හි සර්ව්වේ ලෝකා අස්මාන් පාෂාණෛ ර්හනිෂ්‍යන්ති යතෝ යෝහන් භවිෂ්‍යද්වාදීති සර්ව්වේ දෘඪං ජානන්ති| ");
INSERT INTO sansin_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","අතඒව තේ ප්‍රත්‍යූචුඃ කස්‍යාඥයා ජාතම් ඉති වක්තුං න ශක්නුමඃ| ");
INSERT INTO sansin_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","තදා යීශුරවදත් තර්හි කයාඥයා කර්ම්මාණ්‍යේතාති කරෝමීති ච යුෂ්මාන් න වක්‍ෂ්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","අථ ලෝකානාං සාක්‍ෂාත් ස ඉමාං දෘෂ්ටාන්තකථාං වක්තුමාරේභේ, කශ්චිද් ද්‍රාක්‍ෂාක්‍ෂේත්‍රං කෘත්වා තත් ක්‍ෂේත්‍රං කෘෂීවලානාං හස්තේෂු සමර්ප්‍ය බහුකාලාර්ථං දූරදේශං ජගාම| ");
INSERT INTO sansin_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","අථ ඵලකාලේ ඵලානි ග්‍රහීතු කෘෂීවලානාං සමීපේ දාසං ප්‍රාහිණෝත් කින්තු කෘෂීවලාස්තං ප්‍රහෘත්‍ය රික්තහස්තං විසසර්ජුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","තතඃ සෝධිපතිඃ පුනරන්‍යං දාසං ප්‍රේෂයාමාස, තේ තමපි ප්‍රහෘත්‍ය කුව්‍යවහෘත්‍ය රික්තහස්තං විසසෘජුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","තතඃ ස තෘතීයවාරම් අන්‍යං ප්‍රාහිණෝත් තේ තමපි ක්‍ෂතාඞ්ගං කෘත්වා බහි ර්නිචික්‍ෂිපුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","තදා ක්‍ෂේත්‍රපති ර්විචාරයාමාස, මමේදානීං කිං කර්ත්තව්‍යං? මම ප්‍රියේ පුත්‍රේ ප්‍රහිතේ තේ තමවශ්‍යං දෘෂ්ට්වා සමාදරිෂ්‍යන්තේ| ");
INSERT INTO sansin_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","කින්තු කෘෂීවලාස්තං නිරීක්‍ෂ්‍ය පරස්පරං විවිච්‍ය ප්‍රෝචුඃ, අයමුත්තරාධිකාරී ආගච්ඡතෛනං හන්මස්තතෝධිකාරෝස්මාකං භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","තතස්තේ තං ක්‍ෂේත්‍රාද් බහි ර්නිපාත්‍ය ජඝ්නුස්තස්මාත් ස ක්‍ෂේත්‍රපතිස්තාන් ප්‍රති කිං කරිෂ්‍යති? ");
INSERT INTO sansin_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ස ආගත්‍ය තාන් කෘෂීවලාන් හත්වා පරේෂාං හස්තේෂු තත්ක්‍ෂේත්‍රං සමර්පයිෂ්‍යති; ඉති කථාං ශ්‍රුත්වා තේ (අ)වදන් ඒතාදෘශී ඝටනා න භවතු| ");
INSERT INTO sansin_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","කින්තු යීශුස්තානවලෝක්‍ය ජගාද, තර්හි, ස්ථපතයඃ කරිෂ්‍යන්ති ග්‍රාවාණං යන්තු තුච්ඡකං| ප්‍රධානප්‍රස්තරඃ කෝණේ ස ඒව හි භවිෂ්‍යති| ඒතස්‍ය ශාස්ත්‍රීයවචනස්‍ය කිං තාත්පර‍්‍ය්‍යං? ");
INSERT INTO sansin_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","අපරං තත්පාෂාණෝපරි යඃ පතිෂ්‍යති ස භංක්‍ෂ්‍යතේ කින්තු යස්‍යෝපරි ස පාෂාණඃ පතිෂ්‍යති ස තේන ධූලිවච් චූර්ණීභවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","සෝස්මාකං විරුද්ධං දෘෂ්ටාන්තමිමං කථිතවාන් ඉති ඥාත්වා ප්‍රධානයාජකා අධ්‍යාපකාශ්ච තදෛව තං ධර්තුං වවාඤ්ඡුඃ කින්තු ලෝකේභ්‍යෝ බිභ්‍යුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","අතඒව තං ප්‍රති සතර්කාඃ සන්තඃ කථං තද්වාක්‍යදෝෂං ධෘත්වා තං දේශාධිපස්‍ය සාධුවේශධාරිණශ්චරාන් තස්‍ය සමීපේ ප්‍රේෂයාමාසුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","තදා තේ තං පප්‍රච්ඡුඃ, හේ උපදේශක භවාන් යථාර්ථං කථයන් උපදිශති, කමප්‍යනපේක්‍ෂ්‍ය සත්‍යත්වේනෛශ්වරං මාර්ගමුපදිශති, වයමේතජ්ජානීමඃ| ");
INSERT INTO sansin_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","කෛසරරාජාය කරෝස්මාභි ර්දේයෝ න වා? ");
INSERT INTO sansin_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ස තේෂාං වඤ්චනං ඥාත්වාවදත් කුතෝ මාං පරීක්‍ෂධ්වේ? මාං මුද්‍රාමේකං දර්ශයත| ");
INSERT INTO sansin_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","ඉහ ලිඛිතා මූර්තිරියං නාම ච කස්‍ය? තේ(අ)වදන් කෛසරස්‍ය| ");
INSERT INTO sansin_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","තදා ස උවාච, තර්හි කෛසරස්‍ය ද්‍රව්‍යං කෛසරාය දත්ත; ඊශ්වරස්‍ය තු ද්‍රව්‍යමීශ්වරාය දත්ත| ");
INSERT INTO sansin_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","තස්මාල්ලෝකානාං සාක්‍ෂාත් තත්කථායාඃ කමපි දෝෂං ධර්තුමප්‍රාප්‍ය තේ තස්‍යෝත්තරාද් ආශ්චර‍්‍ය්‍යං මන්‍යමානා මෞනිනස්තස්ථුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","අපරඤ්ච ශ්මශානාදුත්ථානානඞ්ගීකාරිණාං සිදූකිනාං කියන්තෝ ජනා ආගත්‍ය තං පප්‍රච්ඡුඃ, ");
INSERT INTO sansin_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","හේ උපදේශක ශාස්ත්‍රේ මූසා අස්මාන් ප්‍රතීති ලිලේඛ යස්‍ය භ්‍රාතා භාර‍්‍ය්‍යායාං සත්‍යාං නිඃසන්තානෝ ම්‍රියතේ ස තජ්ජායාං විවහ්‍ය තද්වංශම් උත්පාදයිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","තථාච කේචිත් සප්ත භ්‍රාතර ආසන් තේෂාං ජ්‍යේෂ්ඨෝ භ්‍රාතා විවහ්‍ය නිරපත්‍යඃ ප්‍රාණාන් ජහෞ| ");
INSERT INTO sansin_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","අථ ද්විතීයස්තස්‍ය ජායාං විවහ්‍ය නිරපත්‍යඃ සන් මමාර| තෘතීයශ්ච තාමේව ව්‍යුවාහ; ");
INSERT INTO sansin_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ඉත්ථං සප්ත භ්‍රාතරස්තාමේව විවහ්‍ය නිරපත්‍යාඃ සන්තෝ මම්‍රුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ශේෂේ සා ස්ත්‍රී ච මමාර| ");
INSERT INTO sansin_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","අතඒව ශ්මශානාදුත්ථානකාලේ තේෂාං සප්තජනානාං කස්‍ය සා භාර‍්‍ය්‍යා භවිෂ්‍යති? යතඃ සා තේෂාං සප්තානාමේව භාර‍්‍ය්‍යාසීත්| ");
INSERT INTO sansin_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","තදා යීශුඃ ප්‍රත්‍යුවාච, ඒතස්‍ය ජගතෝ ලෝකා විවහන්ති වාග්දත්තාශ්ච භවන්ති ");
INSERT INTO sansin_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","කින්තු යේ තජ්ජගත්ප්‍රාප්තියෝග්‍යත්වේන ගණිතාං භවිෂ්‍යන්ති ශ්මශානාච්චෝත්ථාස්‍යන්ති තේ න විවහන්ති වාග්දත්තාශ්ච න භවන්ති, ");
INSERT INTO sansin_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","තේ පුන ර්න ම්‍රියන්තේ කින්තු ශ්මශානාදුත්ථාපිතාඃ සන්ත ඊශ්වරස්‍ය සන්තානාඃ ස්වර්ගීයදූතානාං සදෘශාශ්ච භවන්ති| ");
INSERT INTO sansin_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","අධිකන්තු මූසාඃ ස්තම්බෝපාඛ්‍යානේ පරමේශ්වර ඊබ්‍රාහීම ඊශ්වර ඉස්හාක ඊශ්වරෝ යාකූබශ්චේශ්වර ඉත්‍යුක්ත්වා මෘතානාං ශ්මශානාද් උත්ථානස්‍ය ප්‍රමාණං ලිලේඛ| ");
INSERT INTO sansin_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","අතඒව ය ඊශ්වරඃ ස මෘතානාං ප්‍රභු ර්න කින්තු ජීවතාමේව ප්‍රභුඃ, තන්නිකටේ සර්ව්වේ ජීවන්තඃ සන්ති| ");
INSERT INTO sansin_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ඉති ශ්‍රුත්වා කියන්තෝධ්‍යාපකා ඌචුඃ, හේ උපදේශක භවාන් භද්‍රං ප්‍රත්‍යුක්තවාන්| ");
INSERT INTO sansin_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ඉතඃ පරං තං කිමපි ප්‍රෂ්ටං තේෂාං ප්‍රගල්භතා නාභූත්| ");
INSERT INTO sansin_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","පශ්චාත් ස තාන් උවාච, යඃ ඛ්‍රීෂ්ටඃ ස දායූදඃ සන්තාන ඒතාං කථාං ලෝකාඃ කථං කථයන්ති? ");
INSERT INTO sansin_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","යතඃ මම ප්‍රභුමිදං වාක්‍යමවදත් පරමේශ්වරඃ| තව ශත්‍රූනහං යාවත් පාදපීඨං කරෝමි න| තාවත් කාලං මදීයේ ත්වං දක්‍ෂපාර්ශ්ව උපාවිශ| ");
INSERT INTO sansin_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ඉති කථාං දායූද් ස්වයං ගීතග්‍රන්ථේ(අ)වදත්| ");
INSERT INTO sansin_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","අතඒව යදි දායූද් තං ප්‍රභුං වදති, තර්හි ස කථං තස්‍ය සන්තානෝ භවති? ");
INSERT INTO sansin_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","පශ්චාද් යීශුඃ සර්ව්වජනානාං කර්ණගෝචරේ ශිෂ්‍යානුවාච, ");
INSERT INTO sansin_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","යේ(අ)ධ්‍යාපකා දීර්ඝපරිච්ඡදං පරිධාය භ්‍රමන්ති, හට්ටාපණයෝ ර්නමස්කාරේ භජනගේහස්‍ය ප්‍රෝච්චාසනේ භෝජනගෘහස්‍ය ප්‍රධානස්ථානේ ච ප්‍රීයන්තේ ");
INSERT INTO sansin_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","විධවානාං සර්ව්වස්වං ග්‍රසිත්වා ඡලේන දීර්ඝකාලං ප්‍රාර්ථයන්තේ ච තේෂු සාවධානා භවත, තේෂාමුග්‍රදණ්ඩෝ භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","අථ ධනිලෝකා භාණ්ඩාගාරේ ධනං නික්‍ෂිපන්ති ස තදේව පශ්‍යති, ");
INSERT INTO sansin_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ඒතර්හි කාචිද්දීනා විධවා පණද්වයං නික්‍ෂිපති තද් දදර්ශ| ");
INSERT INTO sansin_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","තතෝ යීශුරුවාච යුෂ්මානහං යථාර්ථං වදාමි, දරිද්‍රේයං විධවා සර්ව්වේභ්‍යෝධිකං න්‍යක්‍ෂේප්සීත්, ");
INSERT INTO sansin_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","යතෝන්‍යේ ස්වප්‍රාජ්‍යධනේභ්‍ය ඊශ්වරාය කිඤ්චිත් න්‍යක්‍ෂේප්සුඃ, කින්තු දරිද්‍රේයං විධවා දිනයාපනාර්ථං ස්වස්‍ය යත් කිඤ්චිත් ස්ථිතං තත් සර්ව්වං න්‍යක්‍ෂේප්සීත්| ");
INSERT INTO sansin_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","අපරඤ්ච උත්තමප්‍රස්තරෛරුත්සෘෂ්ටව්‍යෛශ්ච මන්දිරං සුශෝභතේතරාං කෛශ්චිදිත්‍යුක්තේ ස ප්‍රත්‍යුවාච ");
INSERT INTO sansin_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","යූයං යදිදං නිචයනං පශ්‍යථ, අස්‍ය පාෂාණෛකෝප්‍යන්‍යපාෂාණෝපරි න ස්ථාස්‍යති, සර්ව්වේ භූසාද්භවිෂ්‍යන්ති කාලෝයමායාති| ");
INSERT INTO sansin_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","තදා තේ පප්‍රච්ඡුඃ, හේ ගුරෝ ඝටනේදෘශී කදා භවිෂ්‍යති? ඝටනායා ඒතස්‍යසශ්චිහ්නං වා කිං භවිෂ්‍යති? ");
INSERT INTO sansin_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","තදා ස ජගාද, සාවධානා භවත යථා යුෂ්මාකං භ්‍රමං කෝපි න ජනයති, ඛීෂ්ටෝහමිත්‍යුක්ත්වා මම නාම්‍රා බහව උපස්ථාස්‍යන්ති ස කාලඃ ප්‍රායේණෝපස්ථිතඃ, තේෂාං පශ්චාන්මා ගච්ඡත| ");
INSERT INTO sansin_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","යුද්ධස්‍යෝපප්ලවස්‍ය ච වාර්ත්තාං ශ්‍රුත්වා මා ශඞ්කධ්වං, යතඃ ප්‍රථමම් ඒතා ඝටනා අවශ්‍යං භවිෂ්‍යන්ති කින්තු නාපාතේ යුගාන්තෝ භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","අපරඤ්ච කථයාමාස, තදා දේශස්‍ය විපක්‍ෂත්වේන දේශෝ රාජ්‍යස්‍ය විපක්‍ෂත්වේන රාජ්‍යම් උත්ථාස්‍යති, ");
INSERT INTO sansin_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","නානාස්ථානේෂු මහාභූකම්පෝ දුර්භික්‍ෂං මාරී ච භවිෂ්‍යන්ති, තථා ව්‍යෝමමණ්ඩලස්‍ය භයඞ්කරදර්ශනාන්‍යශ්චර‍්‍ය්‍යලක්‍ෂණානි ච ප්‍රකාශයිෂ්‍යන්තේ| ");
INSERT INTO sansin_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","කින්තු සර්ව්වාසාමේතාසාං ඝටනානාං පූර්ව්වං ලෝකා යුෂ්මාන් ධෘත්වා තාඩයිෂ්‍යන්ති, භජනාලයේ කාරායාඤ්ච සමර්පයිෂ්‍යන්ති මම නාමකාරණාද් යුෂ්මාන් භූපානාං ශාසකානාඤ්ච සම්මුඛං නේෂ්‍යන්ති ච| ");
INSERT INTO sansin_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","සාක්‍ෂ්‍යාර්ථම් ඒතානි යුෂ්මාන් ප්‍රති ඝටිෂ්‍යන්තේ| ");
INSERT INTO sansin_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","තදා කිමුත්තරං වක්තව්‍යම් ඒතත් න චින්තයිෂ්‍යාම ඉති මනඃසු නිශ්චිතනුත| ");
INSERT INTO sansin_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","විපක්‍ෂා යස්මාත් කිමප්‍යුත්තරම් ආපත්තිඤ්ච කර්ත්තුං න ශක්‍ෂ්‍යන්ති තාදෘශං වාක්පටුත්වං ඥානඤ්ච යුෂ්මභ්‍යං දාස්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","කිඤ්ච යූයං පිත්‍රා මාත්‍රා භ්‍රාත්‍රා බන්ධුනා ඥාත්‍යා කුටුම්බේන ච පරකරේෂු සමර්පයිෂ්‍යධ්වේ; තතස්තේ යුෂ්මාකං කඤ්චන කඤ්චන ඝාතයිෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","මම නාම්නඃ කාරණාත් සර්ව්වෛ ර්මනුෂ්‍යෛ ර‍්‍යූයම් ඍතීයිෂ්‍යධ්වේ| ");
INSERT INTO sansin_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","කින්තු යුෂ්මාකං ශිරඃකේශෛකෝපි න විනංක්‍ෂ්‍යති, ");
INSERT INTO sansin_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","තස්මාදේව ධෛර‍්‍ය්‍යමවලම්බ්‍ය ස්වස්වප්‍රාණාන් රක්‍ෂත| ");
INSERT INTO sansin_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","අපරඤ්ච යිරූශාලම්පුරං සෛන්‍යවේෂ්ටිතං විලෝක්‍ය තස්‍යෝච්ඡින්නතායාඃ සමයඃ සමීප ඉත්‍යවගමිෂ්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","තදා යිහූදාදේශස්ථා ලෝකාඃ පර්ව්වතං පලායන්තාං, යේ ච නගරේ තිෂ්ඨන්ති තේ දේශාන්තරං පලායන්තා, යේ ච ග්‍රාමේ තිෂ්ඨන්ති තේ නගරං න ප්‍රවිශන්තු, ");
INSERT INTO sansin_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","යතස්තදා සමුචිතදණ්ඩනාය ධර්ම්මපුස්තකේ යානි සර්ව්වාණි ලිඛිතානි තානි සඵලානි භවිෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","කින්තු යා යාස්තදා ගර්භවත්‍යඃ ස්තන්‍යදාව්‍යශ්ච තාමාං දුර්ගති ර්භවිෂ්‍යති, යත ඒතාල්ලෝකාන් ප්‍රති කෝපෝ දේශේ ච විෂමදුර්ගති ර්ඝටිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","වස්තුතස්තු තේ ඛඞ්ගධාරපරිව්වඞ්ගං ලප්ස්‍යන්තේ බද්ධාඃ සන්තඃ සර්ව්වදේශේෂු නායිෂ්‍යන්තේ ච කිඤ්චාන්‍යදේශීයානාං සමයෝපස්ථිතිපර‍්‍ය්‍යන්තං යිරූශාලම්පුරං තෛඃ පදතලෛ ර්දලයිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","සූර‍්‍ය්‍යචන්ද්‍රනක්‍ෂත්‍රේෂු ලක්‍ෂණාදි භවිෂ්‍යන්ති, භුවි සර්ව්වදේශීයානාං දුඃඛං චින්තා ච සින්ධෞ වීචීනාං තර්ජනං ගර්ජනඤ්ච භවිෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","භූභෞ භාවිඝටනාං චින්තයිත්වා මනුජා භියාමෘතකල්පා භවිෂ්‍යන්ති, යතෝ ව්‍යෝමමණ්ඩලේ තේජස්විනෝ දෝලායමානා භවිෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","තදා පරාක්‍රමේණා මහාතේජසා ච මේඝාරූඪං මනුෂ්‍යපුත්‍රම් ආයාන්තං ද්‍රක්‍ෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","කින්ත්වේතාසාං ඝටනානාමාරම්භේ සති යූයං මස්තකාන්‍යුත්තෝල්‍ය ඌර්දධ්වං ද්‍රක්‍ෂ්‍යථ, යතෝ යුෂ්මාකං මුක්තේඃ කාලඃ සවිධෝ භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","තතස්තේනෛතදෘෂ්ටාන්තකථා කථිතා, පශ්‍යත උඩුම්බරාදිවෘක්‍ෂාණාං ");
INSERT INTO sansin_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","නවීනපත්‍රාණි ජාතානීති දෘෂ්ට්වා නිදාවකාල උපස්ථිත ඉති යථා යූයං ඥාතුං ශක්නුථ, ");
INSERT INTO sansin_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","තථා සර්ව්වාසාමාසාං ඝටනානාම් ආරම්භේ දෘෂ්ටේ සතීශ්වරස්‍ය රාජත්වං නිකටම් ඉත්‍යපි ඥාස්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","යුෂ්මානහං යථාර්ථං වදාමි, විද්‍යමානලෝකානාමේෂාං ගමනාත් පූර්ව්වම් ඒතානි ඝටිෂ්‍යන්තේ| ");
INSERT INTO sansin_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","නභෝභුවෝර්ලෝපෝ භවිෂ්‍යති මම වාක් තු කදාපි ලුප්තා න භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","අතඒව විෂමාශනේන පානේන ච සාංමාරිකචින්තාභිශ්ච යුෂ්මාකං චිත්තේෂු මත්තේෂු තද්දිනම් අකස්මාද් යුෂ්මාන් ප්‍රති යථා නෝපතිෂ්ඨති තදර්ථං ස්වේෂු සාවධානාස්තිෂ්ඨත| ");
INSERT INTO sansin_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","පෘථිවීස්ථසර්ව්වලෝකාන් ප්‍රති තද්දිනම් උන්මාථ ඉව උපස්ථාස්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","යථා යූයම් ඒතද්භාවිඝටනා උත්තර්ත්තුං මනුජසුතස්‍ය සම්මුඛේ සංස්ථාතුඤ්ච යෝග්‍යා භවථ කාරණාදස්මාත් සාවධානාඃ සන්තෝ නිරන්තරං ප්‍රාර්ථයධ්වං| ");
INSERT INTO sansin_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","අපරඤ්ච ස දිවා මන්දිර උපදිශ්‍ය රාචෛ ජෛතුනාද්‍රිං ගත්වාතිෂ්ඨත්| ");
INSERT INTO sansin_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","තතඃ ප්‍රත්‍යූෂේ ලාකාස්තත්කථාං ශ්‍රෝතුං මන්දිරේ තදන්තිකම් ආගච්ඡන්| ");
INSERT INTO sansin_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","අපරඤ්ච කිණ්වශූන්‍යපූපෝත්සවස්‍ය කාල උපස්ථිතේ ");
INSERT INTO sansin_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ප්‍රධානයාජකා අධ්‍යායකාශ්ච යථා තං හන්තුං ශක්නුවන්ති තථෝපායාම් අචේෂ්ටන්ත කින්තු ලෝකේභ්‍යෝ බිභ්‍යුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ඒතස්තින් සමයේ ද්වාදශශිෂ්‍යේෂු ගණිත ඊෂ්කරියෝතීයරූඪිමාන් යෝ යිහූදාස්තස්‍යාන්තඃකරණං ශෛතානාශ්‍රිතත්වාත් ");
INSERT INTO sansin_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ස ගත්වා යථා යීශුං තේෂාං කරේෂු සමර්පයිතුං ශක්නෝති තථා මන්ත්‍රණාං ප්‍රධානයාජකෛඃ සේනාපතිභිශ්ච සහ චකාර| ");
INSERT INTO sansin_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","තේන තේ තුෂ්ටාස්තස්මෛ මුද්‍රාං දාතුං පණං චක්‍රුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","තතඃ සෝඞ්ගීකෘත්‍ය යථා ලෝකානාමගෝචරේ තං පරකරේෂු සමර්පයිතුං ශක්නෝති තථාවකාශං චේෂ්ටිතුමාරේභේ| ");
INSERT INTO sansin_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","අථ කිණ්වශූන්‍යපූපෝත්මවදිනේ, අර්ථාත් යස්මින් දිනේ නිස්තාරෝත්සවස්‍ය මේෂෝ හන්තව්‍යස්තස්මින් දිනේ ");
INSERT INTO sansin_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","යීශුඃ පිතරං යෝහනඤ්චාහූය ජගාද, යුවාං ගත්වාස්මාකං භෝජනාර්ථං නිස්තාරෝත්සවස්‍ය ද්‍රව්‍යාණ්‍යාසාදයතං| ");
INSERT INTO sansin_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","තදා තෞ පප්‍රච්ඡතුඃ කුචාසාදයාවෝ භවතඃ කේච්ඡා? ");
INSERT INTO sansin_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","තදා සෝවාදීත්, නගරේ ප්‍රවිෂ්ටේ කශ්චිජ්ජලකුම්භමාදාය යුවාං සාක්‍ෂාත් කරිෂ්‍යති ස යන්නිවේශනං ප්‍රවිශති යුවාමපි තන්නිවේශනං තත්පශ්චාදිත්වා නිවේශනපතිම් ඉති වාක්‍යං වදතං, ");
INSERT INTO sansin_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","යත්‍රාහං නිස්තාරෝත්සවස්‍ය භෝජ්‍යං ශිෂ්‍යෛඃ සාර්ද්ධං භෝක්තුං ශක්නෝමි සාතිථිශාලාा කුත්‍ර? කථාමිමාං ප්‍රභුස්ත්වාං පෘච්ඡති| ");
INSERT INTO sansin_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","තතඃ ස ජනෝ ද්විතීයප්‍රකෝෂ්ඨීයම් ඒකං ශස්තං කෝෂ්ඨං දර්ශයිෂ්‍යති තත්‍ර භෝජ්‍යමාසාදයතං| ");
INSERT INTO sansin_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","තතස්තෞ ගත්වා තද්වාක්‍යානුසාරේණ සර්ව්වං දෘෂ්ද්වා තත්‍ර නිස්තාරෝත්සවීයං භෝජ්‍යමාසාදයාමාසතුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","අථ කාල උපස්ථිතේ යීශු ර්ද්වාදශභිඃ ප්‍රේරිතෛඃ සහ භෝක්තුමුපවිශ්‍ය කථිතවාන් ");
INSERT INTO sansin_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","මම දුඃඛභෝගාත් පූර්ව්වං යුභාභිඃ සහ නිස්තාරෝත්සවස්‍යෛතස්‍ය භෝජ්‍යං භෝක්තුං මයාතිවාඤ්ඡා කෘතා| ");
INSERT INTO sansin_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","යුෂ්මාන් වදාමි, යාවත්කාලම් ඊශ්වරරාජ්‍යේ භෝජනං න කරිෂ්‍යේ තාවත්කාලම් ඉදං න භෝක්‍ෂ්‍යේ| ");
INSERT INTO sansin_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","තදා ස පානපාත්‍රමාදාය ඊශ්වරස්‍ය ගුණාන් කීර්ත්තයිත්වා තේභ්‍යෝ දත්වාවදත්, ඉදං ගෘහ්ලීත යූයං විභජ්‍ය පිවත| ");
INSERT INTO sansin_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","යුෂ්මාන් වදාමි යාවත්කාලම් ඊශ්වරරාජත්වස්‍ය සංස්ථාපනං න භවති තාවද් ද්‍රාක්‍ෂාඵලරසං න පාස්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","තතඃ පූපං ගෘහීත්වා ඊශ්වරගුණාන් කීර්ත්තයිත්වා භඞ්ක්තා තේභ්‍යෝ දත්වාවදත්, යුෂ්මදර්ථං සමර්පිතං යන්මම වපුස්තදිදං, ඒතත් කර්ම්ම මම ස්මරණාර්ථං කුරුධ්වං| ");
INSERT INTO sansin_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","අථ භෝජනාන්තේ තාදෘශං පාත්‍රං ගෘහීත්වාවදත්, යුෂ්මත්කෘතේ පාතිතං යන්මම රක්තං තේන නිර්ණීතනවනියමරූපං පානපාත්‍රමිදං| ");
INSERT INTO sansin_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","පශ්‍යත යෝ මාං පරකරේෂු සමර්පයිෂ්‍යති ස මයා සහ භෝජනාසන උපවිශති| ");
INSERT INTO sansin_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","යථා නිරූපිතමාස්තේ තදනුසාරේණා මනුෂ්‍යපුुත්‍රස්‍ය ගති ර්භවිෂ්‍යති කින්තු යස්තං පරකරේෂු සමර්පයිෂ්‍යති තස්‍ය සන්තාපෝ භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","තදා තේෂාං කෝ ජන ඒතත් කර්ම්ම කරිෂ්‍යති තත් තේ පරස්පරං ප්‍රෂ්ටුමාරේභිරේ| ");
INSERT INTO sansin_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","අපරං තේෂාං කෝ ජනඃ ශ්‍රේෂ්ඨත්වේන ගණයිෂ්‍යතේ, අත්‍රාර්ථේ තේෂාං විවාදෝභවත්| ");
INSERT INTO sansin_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","අස්මාත් කාරණාත් සෝවදත්, අන්‍යදේශීයානාං රාජානඃ ප්‍රජානාමුපරි ප්‍රභුත්වං කුර්ව්වන්ති දාරුණශාසනං කෘත්වාපි තේ භූපතිත්වේන විඛ්‍යාතා භවන්ති ච| ");
INSERT INTO sansin_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","කින්තු යුෂ්මාකං තථා න භවිෂ්‍යති, යෝ යුෂ්මාකං ශ්‍රේෂ්ඨෝ භවිෂ්‍යති ස කනිෂ්ඨවද් භවතු, යශ්ච මුඛ්‍යෝ භවිෂ්‍යති ස සේවකවද්භවතු| ");
INSERT INTO sansin_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","භෝජනෝපවිෂ්ටපරිචාරකයෝඃ කඃ ශ්‍රේෂ්ඨඃ? යෝ භෝජනායෝපවිශති ස කිං ශ්‍රේෂ්ඨෝ න භවති? කින්තු යුෂ්මාකං මධ්‍යේ(අ)හං පරිචාරකඉවාස්මි| ");
INSERT INTO sansin_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","අපරඤ්ච යුයං මම පරීක්‍ෂාකාලේ ප්‍රථමමාරභ්‍ය මයා සහ ස්ථිතා ");
INSERT INTO sansin_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ඒතත්කාරණාත් පිත්‍රා යථා මදර්ථං රාජ්‍යමේකං නිරූපිතං තථාහමපි යුෂ්මදර්ථං රාජ්‍යං නිරූපයාමි| ");
INSERT INTO sansin_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","තස්මාන් මම රාජ්‍යේ භෝජනාසනේ ච භෝජනපානේ කරිෂ්‍යධ්වේ සිංහාසනේෂූපවිශ්‍ය චේස්‍රායේලීයානාං ද්වාදශවංශානාං විචාරං කරිෂ්‍යධ්වේ| ");
INSERT INTO sansin_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","අපරං ප්‍රභුරුවාච, හේ ශිමෝන් පශ්‍ය තිතඋනා ධාන්‍යානීව යුෂ්මාන් ශෛතාන් චාලයිතුම් ඓච්ඡත්, ");
INSERT INTO sansin_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","කින්තු තව විශ්වාසස්‍ය ලෝපෝ යථා න භවති ඒතත් ත්වදර්ථං ප්‍රාර්ථිතං මයා, ත්වන්මනසි පරිවර්ත්තිතේ ච භ්‍රාතෘණාං මනාංසි ස්ථිරීකුරු| ");
INSERT INTO sansin_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","තදා සෝවදත්, හේ ප්‍රභෝහං ත්වයා සාර්ද්ධං කාරාං මෘතිඤ්ච යාතුං මජ්ජිතෝස්මි| ");
INSERT INTO sansin_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","තතඃ ස උවාච, හේ පිතර ත්වාං වදාමි, අද්‍ය කුක්කුටරවාත් පූර්ව්වං ත්වං මත්පරිචයං වාරත්‍රයම් අපහ්වෝෂ්‍යසේ| ");
INSERT INTO sansin_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","අපරං ස පප්‍රච්ඡ, යදා මුද්‍රාසම්පුටං ඛාද්‍යපාත්‍රං පාදුකාඤ්ච විනා යුෂ්මාන් ප්‍රාහිණවං තදා යුෂ්මාකං කස්‍යාපි න්‍යූනතාසීත්? තේ ප්‍රෝචුඃ කස්‍යාපි න| ");
INSERT INTO sansin_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","තදා සෝවදත් කින්ත්විදානීං මුද්‍රාසම්පුටං ඛාද්‍යපාත්‍රං වා යස්‍යාස්ති තේන තද්ග්‍රහීතව්‍යං, යස්‍ය ච කෘපාණෝे නාස්ති තේන ස්වවස්ත්‍රං වික්‍රීය ස ක්‍රේතව්‍යඃ| ");
INSERT INTO sansin_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","යතෝ යුෂ්මානහං වදාමි, අපරාධිජනෛඃ සාර්ද්ධං ගණිතඃ ස භවිෂ්‍යති| ඉදං යච්ඡාස්ත්‍රීයං වචනං ලිඛිතමස්ති තන්මයි ඵලිෂ්‍යති යතෝ මම සම්බන්ධීයං සර්ව්වං සේත්ස්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","තදා තේ ප්‍රෝචුඃ ප්‍රභෝ පශ්‍ය ඉමෞ කෘපාණෞ| තතඃ සෝවදද් ඒතෞ යථේෂ්ටෞ| ");
INSERT INTO sansin_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","අථ ස තස්මාද්වහි ර්ගත්වා ස්වාචාරානුසාරේණ ජෛතුනනාමාද්‍රිං ජගාම ශිෂ්‍යාශ්ච තත්පශ්චාද් යයුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","තත්‍රෝපස්ථාය ස තානුවාච, යථා පරීක්‍ෂායාං න පතථ තදර්ථං ප්‍රාර්ථයධ්වං| ");
INSERT INTO sansin_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","පශ්චාත් ස තස්මාද් ඒකශරක්‍ෂේපාද් බහි ර්ගත්වා ජානුනී පාතයිත්වා ඒතත් ප්‍රාර්ථයාඤ්චක්‍රේ, ");
INSERT INTO sansin_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","හේ පිත ර‍්‍යදි භවාන් සම්මන්‍යතේ තර්හි කංසමේනං මමාන්තිකාද් දූරය කින්තු මදිච්ඡානුරූපං න ත්වදිච්ඡානුරූපං භවතු| ");
INSERT INTO sansin_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","තදා තස්මෛ ශක්තිං දාතුං ස්වර්ගීයදූතෝ දර්ශනං දදෞ| ");
INSERT INTO sansin_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","පශ්චාත් සෝත්‍යන්තං යාතනයා ව්‍යාකුලෝ භූත්වා පුනර්දෘඪං ප්‍රාර්ථයාඤ්චක්‍රේ, තස්මාද් බෘහච්ඡෝණිතබින්දව ඉව තස්‍ය ස්වේදබින්දවඃ පෘථිව්‍යාං පතිතුමාරේභිරේ| ");
INSERT INTO sansin_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","අථ ප්‍රාර්ථනාත උත්ථාය ශිෂ්‍යාණාං සමීපමේත්‍ය තාන් මනෝදුඃඛිනෝ නිද්‍රිතාන් දෘෂ්ට්වාවදත් ");
INSERT INTO sansin_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","කුතෝ නිද්‍රාථ? පරීක්‍ෂායාම් අපතනාර්ථං ප්‍රර්ථයධ්වං| ");
INSERT INTO sansin_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ඒතත්කථායාඃ කථනකාලේ ද්වාදශශිෂ්‍යාණාං මධ්‍යේ ගණිතෝ යිහූදානාමා ජනතාසහිතස්තේෂාම් අග්‍රේ චලිත්වා යීශෝශ්චුම්බනාර්ථං තදන්තිකම් ආයයෞ| ");
INSERT INTO sansin_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","තදා යීශුරුවාච, හේ යිහූදා කිං චුම්බනේන මනුෂ්‍යපුත්‍රං පරකරේෂු සමර්පයසි? ");
INSERT INTO sansin_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","තදා යද්‍යද් ඝටිෂ්‍යතේ තදනුමාය සඞ්ගිභිරුක්තං, හේ ප්‍රභෝ වයං කි ඛඞ්ගේන ඝාතයිෂ්‍යාමඃ? ");
INSERT INTO sansin_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","තත ඒකඃ කරවාලේනාහත්‍ය ප්‍රධානයාජකස්‍ය දාසස්‍ය දක්‍ෂිණං කර්ණං චිච්ඡේද| ");
INSERT INTO sansin_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","අධූනා නිවර්ත්තස්ව ඉත්‍යුක්ත්වා යීශුස්තස්‍ය ශ්‍රුතිං ස්පෘෂ්ට්වා ස්වස්‍යං චකාර| ");
INSERT INTO sansin_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","පශ්චාද් යීශුඃ සමීපස්ථාන් ප්‍රධානයාජකාන් මන්දිරස්‍ය සේනාපතීන් ප්‍රාචීනාංශ්ච ජගාද, යූයං කෘපාණාන් යෂ්ටීංශ්ච ගෘහීත්වා මාං කිං චෝරං ධර්ත්තුමායාතාඃ? ");
INSERT INTO sansin_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","යදාහං යුෂ්මාභිඃ සහ ප්‍රතිදිනං මන්දිරේ(අ)තිෂ්ඨං තදා මාං ධර්ත්තං න ප්‍රවෘත්තාඃ, කින්ත්විදානීං යුෂ්මාකං සමයෝන්ධකාරස්‍ය චාධිපත්‍යමස්ති| ");
INSERT INTO sansin_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","අථ තේ තං ධෘත්වා මහායාජකස්‍ය නිවේශනං නින්‍යුඃ| තතඃ පිතරෝ දූරේ දූරේ පශ්චාදිත්වා ");
INSERT INTO sansin_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","බෘහත්කෝෂ්ඨස්‍ය මධ්‍යේ යත්‍රාග්නිං ජ්වාලයිත්වා ලෝකාඃ සමේත්‍යෝපවිෂ්ටාස්තත්‍ර තෛඃ සාර්ද්ධම් උපවිවේශ| ");
INSERT INTO sansin_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","අථ වහ්නිසන්නිධෞ සමුපවේශකාලේ කාචිද්දාසී මනෝ නිවිශ්‍ය තං නිරීක්‍ෂ්‍යාවදත් පුමානයං තස්‍ය සඞ්ගේ(අ)ස්ථාත්| ");
INSERT INTO sansin_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","කින්තු ස තද් අපහ්නුත්‍යාවාදීත් හේ නාරි තමහං න පරිචිනෝමි| ");
INSERT INTO sansin_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ක්‍ෂණාන්තරේ(අ)න්‍යජනස්තං දෘෂ්ට්වාබ්‍රවීත් ත්වමපි තේෂාං නිකරස්‍යෛකජනෝසි| පිතරඃ ප්‍රත්‍යුවාච හේ නර නාහමස්මි| ");
INSERT INTO sansin_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","තතඃ සාර්ද්ධදණ්ඩද්වයාත් පරං පුනරන්‍යෝ ජනෝ නිශ්චිත්‍ය බභාෂේ, ඒෂ තස්‍ය සඞ්ගීති සත්‍යං යතෝයං ගාලීලීයෝ ලෝකඃ| ");
INSERT INTO sansin_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","තදා පිතර උවාච හේ නර ත්වං යද් වදමි තදහං බෝද්ධුං න ශක්නෝමි, ඉති වාක්‍යේ කථිතමාත්‍රේ කුක්කුටෝ රුරාව| ");
INSERT INTO sansin_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","තදා ප්‍රභුණා ව්‍යාධුට්‍ය පිතරේ නිරීක්‍ෂිතේ කෘකවාකුරවාත් පූර්ව්වං මාං ත්‍රිරපහ්නෝෂ්‍යසේ ඉති පූර්ව්වෝක්තං තස්‍ය වාක්‍යං පිතරඃ ස්මෘත්වා ");
INSERT INTO sansin_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","බහිර්ගත්වා මහාඛේදේන චක්‍රන්ද| ");
INSERT INTO sansin_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","තදා යෛ ර‍්‍යීශුර්ධෘතස්තේ තමුපහස්‍ය ප්‍රහර්ත්තුමාරේභිරේ| ");
INSERT INTO sansin_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","වස්ත්‍රේණ තස්‍ය දෘශෞ බද්ධ්වා කපෝලේ චපේටාඝාතං කෘත්වා පප්‍රච්ඡුඃ, කස්තේ කපෝලේ චපේටාඝාතං කෘතවාන? ගණයිත්වා තද් වද| ");
INSERT INTO sansin_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","තදන්‍යත් තද්විරුද්ධං බහුනින්දාවාක්‍යං වක්තුමාරේභිරේ| ");
INSERT INTO sansin_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","අථ ප්‍රභාතේ සති ලෝකප්‍රාඤ්චඃ ප්‍රධානයාජකා අධ්‍යාපකාශ්ච සභාං කෘත්වා මධ්‍යේසභං යීශුමානීය පප්‍රච්ඡුඃ, ත්වම් අභිෂිකතෝසි න වාස්මාන් වද| ");
INSERT INTO sansin_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ස ප්‍රත්‍යුවාච, මයා තස්මින්නුක්තේ(අ)පි යූයං න විශ්වසිෂ්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","කස්මිංශ්චිද්වාක්‍යේ යුෂ්මාන් පෘෂ්ටේ(අ)පි මාං න තදුත්තරං වක්‍ෂ්‍යථ න මාං ත්‍යක්‍ෂ්‍යථ ච| ");
INSERT INTO sansin_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","කින්ත්විතඃ පරං මනුජසුතඃ සර්ව්වශක්තිමත ඊශ්වරස්‍ය දක්‍ෂිණේ පාර්ශ්වේ සමුපවේක්‍ෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","තතස්තේ පප්‍රච්ඡුඃ, ර්තිහ ත්වමීශ්වරස්‍ය පුත්‍රඃ? ස කථයාමාස, යූයං යථාර්ථං වදථ ස ඒවාහං| ");
INSERT INTO sansin_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","තදා තේ සර්ව්වේ කථයාමාසුඃ, ර්තිහ සාක්‍ෂ්‍යේ(අ)න්සස්මින් අස්මාකං කිං ප්‍රයෝජනං? අස්‍ය ස්වමුඛාදේව සාක්‍ෂ්‍යං ප්‍රාප්තම්| ");
INSERT INTO sansin_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","තතඃ සභාස්ථාඃ සර්ව්වලෝකා උත්ථාය තං පීලාතසම්මුඛං නීත්වාප්‍රෝද්‍ය වක්තුමාරේභිරේ, ");
INSERT INTO sansin_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ස්වමභිෂික්තං රාජානං වදන්තං කෛමරරාජාය කරදානං නිෂේධන්තං රාජ්‍යවිපර‍්‍ය්‍යයං කුර්ත්තුං ප්‍රවර්ත්තමානම් ඒන ප්‍රාප්තා වයං| ");
INSERT INTO sansin_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","තදා පීලාතස්තං පෘෂ්ටවාන් ත්වං කිං යිහූදීයානාං රාජා? ස ප්‍රත්‍යුවාච ත්වං සත්‍යමුක්තවාන්| ");
INSERT INTO sansin_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","තදා පීලාතඃ ප්‍රධානයාජකාදිලෝකාන් ජගාද්, අහමේතස්‍ය කමප්‍යපරාධං නාප්තවාන්| ");
INSERT INTO sansin_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","තතස්තේ පුනඃ සාහමිනෝ භූත්වාවදන්, ඒෂ ගාලීල ඒතත්ස්ථානපර‍්‍ය්‍යන්තේ සර්ව්වස්මින් යිහූදාදේශේ සර්ව්වාල්ලෝකානුපදිශ්‍ය කුප්‍රවෘත්තිං ග්‍රාහීතවාන්| ");
INSERT INTO sansin_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","තදා පීලාතෝ ගාලීලප්‍රදේශස්‍ය නාම ශ්‍රුත්වා පප්‍රච්ඡ, කිමයං ගාලීලීයෝ ලෝකඃ? ");
INSERT INTO sansin_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","තතඃ ස ගාලීල්ප්‍රදේශීයහේරෝද්‍රාජස්‍ය තදා ස්ථිතේස්තස්‍ය සමීපේ යීශුං ප්‍රේෂයාමාස| ");
INSERT INTO sansin_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","තදා හේරෝද් යීශුං විලෝක්‍ය සන්තුතෝෂ, යතඃ ස තස්‍ය බහුවෘත්තාන්තශ්‍රවණාත් තස්‍ය කිඤි्චදාශ්චර‍්‍ය්‍යකර්ම්ම පශ්‍යති ඉත්‍යාශාං කෘත්වා බහුකාලමාරභ්‍ය තං ද්‍රෂ්ටුං ප්‍රයාසං කෘතවාන්| ");
INSERT INTO sansin_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","තස්මාත් තං බහුකථාඃ පප්‍රච්ඡ කින්තු ස තස්‍ය කස්‍යාපි වාක්‍යස්‍ය ප්‍රත්‍යුත්තරං නෝවාච| ");
INSERT INTO sansin_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","අථ ප්‍රධානයාජකා අධ්‍යාපකාශ්ච ප්‍රෝත්තිෂ්ඨන්තඃ සාහසේන තමපවදිතුං ප්‍රාරේභිරේ| ");
INSERT INTO sansin_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","හේරෝද් තස්‍ය සේනාගණශ්ච තමවඥාය උපහාසත්වේන රාජවස්ත්‍රං පරිධාප්‍ය පුනඃ පීලාතං ප්‍රති තං ප්‍රාහිණෝත්| ");
INSERT INTO sansin_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","පූර්ව්වං හේරෝද්පීලාතයෝඃ පරස්පරං වෛරභාව ආසීත් කින්තු තද්දිනේ ද්වයෝ ර්මේලනං ජාතම්| ");
INSERT INTO sansin_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","පශ්චාත් පීලාතඃ ප්‍රධානයාජකාන් ශාසකාන් ලෝකාංශ්ච යුගපදාහූය බභාෂේ, ");
INSERT INTO sansin_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","රාජ්‍යවිපර‍්‍ය්‍යයකාරකෝයම් ඉත්‍යුක්ත්වා මනුෂ්‍යමේනං මම නිකටමානෛෂ්ට කින්තු පශ්‍යත යුෂ්මාකං සමක්‍ෂම් අස්‍ය විචාරං කෘත්වාපි ප්‍රෝක්තාපවාදානුරූපේණාස්‍ය කෝප්‍යපරාධඃ සප්‍රමාණෝ න ජාතඃ, ");
INSERT INTO sansin_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","යූයඤ්ච හේරෝදඃ සන්නිධෞ ප්‍රේෂිතා මයා තත්‍රාස්‍ය කෝප්‍යපරාධස්තේනාපි න ප්‍රාප්තඃ| පශ්‍යතානේන වධහේेතුකං කිමපි නාපරාද්ධං| ");
INSERT INTO sansin_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","තස්මාදේනං තාඩයිත්වා විහාස්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","තත්‍රෝත්සවේ තේෂාමේකෝ මෝචයිතව්‍යඃ| ");
INSERT INTO sansin_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ඉති හේතෝස්තේ ප්‍රෝච්චෛරේකදා ප්‍රෝචුඃ, ඒනං දූරීකෘත්‍ය බරබ්බානාමානං මෝචය| ");
INSERT INTO sansin_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","ස බරබ්බා නගර උපප්ලවවධාපරාධාභ්‍යාං කාරායාං බද්ධ ආසීත්| ");
INSERT INTO sansin_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","කින්තු පීලාතෝ යීශුං මෝචයිතුං වාඤ්ඡන් පුනස්තානුවාච| ");
INSERT INTO sansin_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","තථාප්‍යේනං ක්‍රුශේ ව්‍යධ ක්‍රුශේ ව්‍යධේති වදන්තස්තේ රුරුවුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","තතඃ ස තෘතීයවාරං ජගාද කුතඃ? ස කිං කර්ම්ම කෘතවාන්? නාහමස්‍ය කමපි වධාපරාධං ප්‍රාප්තඃ කේවලං තාඩයිත්වාමුං ත්‍යජාමි| ");
INSERT INTO sansin_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","තථාපි තේ පුනරේනං ක්‍රුශේ ව්‍යධ ඉත්‍යුක්ත්වා ප්‍රෝච්චෛර්දෘඪං ප්‍රාර්ථයාඤ්චක්‍රිරේ; ");
INSERT INTO sansin_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","තතඃ ප්‍රධානයාජකාදීනාං කලරවේ ප්‍රබලේ සති තේෂාං ප්‍රාර්ථනාරූපං කර්ත්තුං පීලාත ආදිදේශ| ");
INSERT INTO sansin_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","රාජද්‍රෝහවධයෝරපරාධේන කාරාස්ථං යං ජනං තේ යයාචිරේ තං මෝචයිත්වා යීශුං තේෂාමිච්ඡායාං සමාර්පයත්| ");
INSERT INTO sansin_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","අථ තේ යීශුං ගෘහීත්වා යාන්ති, ඒතර්හි ග්‍රාමාදාගතං ශිමෝනනාමානං කුරීණීයං ජනං ධෘත්වා යීශෝඃ පශ්චාන්නේතුං තස්‍ය ස්කන්ධේ ක්‍රුශමර්පයාමාසුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","තතෝ ලෝाකාරණ්‍යමධ්‍යේ බහුස්ත්‍රියෝ රුදත්‍යෝ විලපන්ත්‍යශ්ච යීශෝඃ පශ්චාද් යයුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","කින්තු ස ව්‍යාඝුට්‍ය තා උවාච, හේ යිරූශාලමෝ නාර‍්‍ය්‍යෝ යුයං මදර්ථං න රුදිත්වා ස්වාර්ථං ස්වාපත්‍යාර්ථඤ්ච රුදිති; ");
INSERT INTO sansin_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","පශ්‍යත යඃ කදාපි ගර්භවත්‍යෝ නාභවන් ස්තන්‍යඤ්ච නාපායයන් තාදෘශී ර්වන්ධ්‍යා යදා ධන්‍යා වක්‍ෂ්‍යන්ති ස කාල ආයාති| ");
INSERT INTO sansin_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","තදා හේ ශෛලා අස්මාකමුපරි පතත, හේ උපශෛලා අස්මානාච්ඡාදයත කථාමීදෘශීං ලෝකා වක්‍ෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","යතඃ සතේජසි ශාඛිනි චේදේතද් ඝටතේ තර්හි ශුෂ්කශාඛිනි කිං න ඝටිෂ්‍යතේ? ");
INSERT INTO sansin_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","තදා තේ හන්තුං ද්වාවපරාධිනෞ තේන සාර්ද්ධං නින්‍යුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","අපරං ශිරඃකපාලනාමකස්ථානං ප්‍රාප්‍ය තං ක්‍රුශේ විවිධුඃ; තද්ද්වයෝරපරාධිනෝරේකං තස්‍ය දක්‍ෂිණෝ තදන්‍යං වාමේ ක්‍රුශේ විවිධුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","තදා යීශුරකථයත්, හේ පිතරේතාන් ක්‍ෂමස්ව යත ඒතේ යත් කර්ම්ම කුර්ව්වන්ති තන් න විදුඃ; පශ්චාත්තේ ගුටිකාපාතං කෘත්වා තස්‍ය වස්ත්‍රාණි විභජ්‍ය ජගෘහුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","තත්‍ර ලෝකසංඝස්තිෂ්ඨන් දදර්ශ; තේ තේෂාං ශාසකාශ්ච තමුපහස්‍ය ජගදුඃ, ඒෂ ඉතරාන් රක්‍ෂිතවාන් යදීශ්වරේණාභිරුචිතෝ (අ)භිෂික්තස්ත්‍රාතා භවති තර්හි ස්වමධුනා රක්‍ෂතු| ");
INSERT INTO sansin_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","තදන්‍යඃ සේනාගණා ඒත්‍ය තස්මෛ අම්ලරසං දත්වා පරිහස්‍ය ප්‍රෝවාච, ");
INSERT INTO sansin_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","චේත්ත්වං යිහූදීයානාං රාජාසි තර්හි ස්වං රක්‍ෂ| ");
INSERT INTO sansin_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","යිහූදීයානාං රාජේති වාක්‍යං යූනානීයරෝමීයේබ්‍රීයාක්‍ෂරෛ ර්ලිඛිතං තච්ඡිරස ඌර්ද්ධ්වේ(අ)ස්ථාප්‍යත| ");
INSERT INTO sansin_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","තදෝභයපාර්ශ්වයෝ ර්විද්ධෞ යාවපරාධිනෞ තයෝරේකස්තං විනින්ද්‍ය බභාෂේ, චේත්ත්වම් අභිෂික්තෝසි තර්හි ස්වමාවාඤ්ච රක්‍ෂ| ");
INSERT INTO sansin_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","කින්ත්වන්‍යස්තං තර්ජයිත්වාවදත්, ඊශ්වරාත්තව කිඤ්චිදපි භයං නාස්ති කිං? ත්වමපි සමානදණ්ඩෝසි, ");
INSERT INTO sansin_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","යෝග්‍යපාත්‍රේ ආවාං ස්වස්වකර්ම්මණාං සමුචිතඵලං ප්‍රාප්නුවඃ කින්ත්වනේන කිමපි නාපරාද්ධං| ");
INSERT INTO sansin_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","අථ ස යීශුං ජගාද හේ ප්‍රභේ භවාන් ස්වරාජ්‍යප්‍රවේශකාලේ මාං ස්මරතු| ");
INSERT INTO sansin_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","තදා යීශුඃ කථිතවාන් ත්වාං යථාර්ථං වදාමි ත්වමද්‍යෛව මයා සාර්ද්ධං පරලෝකස්‍ය සුඛස්ථානං ප්‍රාප්ස්‍යසි| ");
INSERT INTO sansin_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","අපරඤ්ච ද්විතීයයාමාත් තෘතීයයාමපර‍්‍ය්‍යන්තං රවේස්තේජසෝන්තර්හිතත්වාත් සර්ව්වදේශෝ(අ)න්ධකාරේණාවෘතෝ ");
INSERT INTO sansin_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","මන්දිරස්‍ය යවනිකා ච ඡිද්‍යමානා ද්විධා බභූව| ");
INSERT INTO sansin_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","තතෝ යීශුරුච්චෛරුවාච, හේ පිත ර්මමාත්මානං තව කරේ සමර්පයේ, ඉත්‍යුක්ත්වා ස ප්‍රාණාන් ජහෞ| ");
INSERT INTO sansin_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","තදෛතා ඝටනා දෘෂ්ට්වා ශතසේනාපතිරීශ්වරං ධන්‍යමුක්ත්වා කථිතවාන් අයං නිතාන්තං සාධුමනුෂ්‍ය ආසීත්| ");
INSERT INTO sansin_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","අථ යාවන්තෝ ලෝකා ද්‍රෂ්ටුම් ආගතාස්තේ තා ඝටනා දෘෂ්ට්වා වක්‍ෂඃසු කරාඝාතං කෘත්වා ව්‍යාචුට්‍ය ගතාඃ| ");
INSERT INTO sansin_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","යීශෝ ර්ඥාතයෝ යා යා යෝෂිතශ්ච ගාලීලස්තේන සාර්ද්ධමායාතාස්තා අපි දූරේ ස්ථිත්වා තත් සර්ව්වං දදෘශුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","තදා යිහූදීයානාං මන්ත්‍රණාං ක්‍රියාඤ්චාසම්මන්‍යමාන ඊශ්වරස්‍ය රාජත්වම් අපේක්‍ෂමාණෝ ");
INSERT INTO sansin_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","යිහූදිදේශීයෝ (අ)රිමථීයනගරීයෝ යූෂඵ්නාමා මන්ත්‍රී භද්‍රෝ ධාර්ම්මිකශ්ච පුමාන් ");
INSERT INTO sansin_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","පීලාතාන්තිකං ගත්වා යීශෝ ර්දේහං යයාචේ| ");
INSERT INTO sansin_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","පශ්චාද් වපුරවරෝහ්‍ය වාසසා සංවේෂ්ට්‍ය යත්‍ර කෝපි මානුෂෝ නාස්ථාප්‍යත තස්මින් ශෛලේ ස්වාතේ ශ්මශානේ තදස්ථාපයත්| ");
INSERT INTO sansin_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","තද්දිනමායෝජනීයං දිනං විශ්‍රාමවාරශ්ච සමීපඃ| ");
INSERT INTO sansin_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","අපරං යීශුනා සාර්ද්ධං ගාලීල ආගතා යෝෂිතඃ පශ්චාදිත්වා ශ්මශානේ තත්‍ර යථා වපුඃ ස්ථාපිතං තච්ච දෘෂ්ට්වා ");
INSERT INTO sansin_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ව්‍යාඝුට්‍ය සුගන්ධිද්‍රව්‍යතෛලානි කෘත්වා විධිවද් විශ්‍රාමවාරේ විශ්‍රාමං චක්‍රුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","අථ සප්තාහප්‍රථමදිනේ(අ)තිප්‍රත්‍යූෂේ තා යෝෂිතඃ සම්පාදිතං සුගන්ධිද්‍රව්‍යං ගෘහීත්වා තදන්‍යාභිඃ කියතීභිඃ ස්ත්‍රීභිඃ සහ ශ්මශානං යයුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","කින්තු ශ්මශානද්වාරාත් පාෂාණමපසාරිතං දෘෂ්ට්වා ");
INSERT INTO sansin_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","තාඃ ප්‍රවිශ්‍ය ප්‍රභෝ ර්දේහමප්‍රාප්‍ය ");
INSERT INTO sansin_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ව්‍යාකුලා භවන්ති ඒතර්හි තේජෝමයවස්ත්‍රාන්විතෞ ද්වෞ පුරුෂෞ තාසාං සමීපේ සමුපස්ථිතෞ ");
INSERT INTO sansin_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","තස්මාත්තාඃ ශඞ්කායුක්තා භූමාවධෝමුඛ්‍යස්‍යස්ථුඃ| තදා තෞ තා ඌචතු ර්මෘතානාං මධ්‍යේ ජීවන්තං කුතෝ මෘගයථ? ");
INSERT INTO sansin_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","සෝත්‍ර නාස්ති ස උදස්ථාත්| ");
INSERT INTO sansin_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","පාපිනාං කරේෂු සමර්පිතේන ක්‍රුශේ හතේන ච මනුෂ්‍යපුත්‍රේණ තෘතීයදිවසේ ශ්මශානාදුත්ථාතව්‍යම් ඉති කථාං ස ගලීලි තිෂ්ඨන් යුෂ්මභ්‍යං කථිතවාන් තාං ස්මරත| ");
INSERT INTO sansin_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","තදා තස්‍ය සා කථා තාසාං මනඃසු ජාතා| ");
INSERT INTO sansin_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","අනන්තරං ශ්මශානාද් ගත්වා තා ඒකාදශශිෂ්‍යාදිභ්‍යඃ සර්ව්වේභ්‍යස්තාං වාර්ත්තාං කථයාමාසුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","මග්දලීනීමරියම්, යෝහනා, යාකූබෝ මාතා මරියම් තදන්‍යාඃ සඞ්ගින්‍යෝ යෝෂිතශ්ච ප්‍රේරිතේභ්‍ය ඒතාඃ සර්ව්වා වාර්ත්තාඃ කථයාමාසුඃ ");
INSERT INTO sansin_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","කින්තු තාසාං කථාම් අනර්ථකාඛ්‍යානමාත්‍රං බුද්ධ්වා කෝපි න ප්‍රත්‍යෛත්| ");
INSERT INTO sansin_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","තදා පිතර උත්ථාය ශ්මශානාන්තිකං දධාව, තත්‍ර ච ප්‍රහ්වෝ භූත්වා පාර්ශ්වෛකස්ථාපිතං කේවලං වස්ත්‍රං දදර්ශ; තස්මාදාශ්චර‍්‍ය්‍යං මන්‍යමානෝ යදඝටත තන්මනසි විචාරයන් ප්‍රතස්ථේ| ");
INSERT INTO sansin_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","තස්මින්නේව දිනේ ද්වෞ ශිය්‍යෞ යිරූශාලමශ්චතුෂ්ක්‍රෝශාන්තරිතම් ඉම්මායුග්‍රාමං ගච්ඡන්තෞ ");
INSERT INTO sansin_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","තාසාං ඝටනානාං කථාමකථයතාං ");
INSERT INTO sansin_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","තයෝරාලාපවිචාරයෝඃ කාලේ යීශුරාගත්‍ය තාභ්‍යාං සහ ජගාම ");
INSERT INTO sansin_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","කින්තු යථා තෞ තං න පරිචිනුතස්තදර්ථං තයෝ ර්දෘෂ්ටිඃ සංරුද්ධා| ");
INSERT INTO sansin_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ස තෞ පෘෂ්ටවාන් යුවාං විෂණ්ණෞ කිං විචාරයන්තෞ ගච්ඡථඃ? ");
INSERT INTO sansin_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","තතස්තයෝඃ ක්ලියපානාමා ප්‍රත්‍යුවාච යිරූශාලමපුරේ(අ)ධුනා යාන්‍යඝටන්ත ත්වං කේවලවිදේශී කිං තද්වෘත්තාන්තං න ජානාසි? ");
INSERT INTO sansin_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ස පප්‍රච්ඡ කා ඝටනාඃ? තදා තෞ වක්තුමාරේභාතේ යීශුනාමා යෝ නාසරතීයෝ භවිෂ්‍යද්වාදී ඊශ්වරස්‍ය මානුෂාණාඤ්ච සාක්‍ෂාත් වාක්‍යේ කර්ම්මණි ච ශක්තිමානාසීත් ");
INSERT INTO sansin_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","තම් අස්මාකං ප්‍රධානයාජකා විචාරකාශ්ච කේනාපි ප්‍රකාරේණ ක්‍රුශේ විද්ධ්වා තස්‍ය ප්‍රාණානනාශයන් තදීයා ඝටනාඃ; ");
INSERT INTO sansin_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","කින්තු ය ඉස්‍රායේලීයලෝකාන් උද්ධාරයිෂ්‍යති ස ඒවායම් ඉත්‍යාශාස්මාභිඃ කෘතා| තද්‍යථා තථාස්තු තස්‍යා ඝටනායා අද්‍ය දිනත්‍රයං ගතං| ");
INSERT INTO sansin_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","අධිකන්ත්වස්මාකං සඞ්ගිනීනාං කියත්ස්ත්‍රීණාං මුඛේභ්‍යෝ(අ)සම්භවවාක්‍යමිදං ශ්‍රුතං; ");
INSERT INTO sansin_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","තාඃ ප්‍රත්‍යූෂේ ශ්මශානං ගත්වා තත්‍ර තස්‍ය දේහම් අප්‍රාප්‍ය ව්‍යාඝුට්‍යේත්වා ප්‍රෝක්තවත්‍යඃ ස්වර්ගීසදූතෞ දෘෂ්ටාවස්මාභිස්තෞ චාවාදිෂ්ටාං ස ජීවිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","තතෝස්මාකං කෛශ්චිත් ශ්මශානමගම්‍යත තේ(අ)පි ස්ත්‍රීණාං වාක්‍යානුරූපං දෘෂ්ටවන්තඃ කින්තු තං නාපශ්‍යන්| ");
INSERT INTO sansin_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","තදා ස තාවුවාච, හේ අබෝධෞ හේ භවිෂ්‍යද්වාදිභිරුක්තවාක්‍යං ප්‍රත්‍යේතුං විලම්බමානෞ; ");
INSERT INTO sansin_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ඒතත්සර්ව්වදුඃඛං භුක්ත්වා ස්වභූතිප්‍රාප්තිඃ කිං ඛ්‍රීෂ්ටස්‍ය න න්‍යාය්‍යා? ");
INSERT INTO sansin_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","තතඃ ස මූසාග්‍රන්ථමාරභ්‍ය සර්ව්වභවිෂ්‍යද්වාදිනාං සර්ව්වශාස්ත්‍රේ ස්වස්මින් ලිඛිතාඛ්‍යානාභිප්‍රායං බෝධයාමාස| ");
INSERT INTO sansin_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","අථ ගම්‍යග්‍රාමාභ්‍යර්ණං ප්‍රාප්‍ය තේනාග්‍රේ ගමනලක්‍ෂණේ දර්ශිතේ ");
INSERT INTO sansin_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","තෞ සාධයිත්වාවදතාං සහාවාභ්‍යාං තිෂ්ඨ දිනේ ගතේ සති රාත්‍රිරභූත්; තතඃ ස තාභ්‍යාං සාර්ද්ධං ස්ථාතුං ගෘහං යයෞ| ");
INSERT INTO sansin_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","පශ්චාද්භෝජනෝපවේශකාලේ ස පූපං ගෘහීත්වා ඊශ්වරගුණාන් ජගාද තඤ්ච භංක්ත්වා තාභ්‍යාං දදෞ| ");
INSERT INTO sansin_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","තදා තයෝ ර්දෘෂ්ටෞ ප්‍රසන්නායාං තං ප්‍රත්‍යභිඥතුඃ කින්තු ස තයෝඃ සාක්‍ෂාදන්තර්දධේ| ");
INSERT INTO sansin_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","තතස්තෞ මිථෝභිධාතුම් ආරබ්ධවන්තෞ ගමනකාලේ යදා කථාමකථයත් ශාස්ත්‍රාර්ථඤ්චබෝධයත් තදාවයෝ ර්බුද්ධිඃ කිං න ප්‍රාජ්වලත්? ");
INSERT INTO sansin_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","තෞ තත්ක්‍ෂණාදුත්ථාය යිරූශාලමපුරං ප්‍රත්‍යායයතුඃ, තත්ස්ථානේ ශිෂ්‍යාණාම් ඒකාදශානාං සඞ්ගිනාඤ්ච දර්ශනං ජාතං| ");
INSERT INTO sansin_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","තේ ප්‍රෝචුඃ ප්‍රභුරුදතිෂ්ඨද් ඉති සත්‍යං ශිමෝනේ දර්ශනමදාච්ච| ");
INSERT INTO sansin_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","තතඃ පථඃ සර්ව්වඝටනායාඃ පූපභඤ්ජනේන තත්පරිචයස්‍ය ච සර්ව්වවෘත්තාන්තං තෞ වක්තුමාරේභාතේ| ");
INSERT INTO sansin_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ඉත්ථං තේ පරස්පරං වදන්ති තත්කාලේ යීශුඃ ස්වයං තේෂාං මධ්‍ය ප්‍රෝත්ථය යුෂ්මාකං කල්‍යාණං භූයාද් ඉත්‍යුවාච, ");
INSERT INTO sansin_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","කින්තු භූතං පශ්‍යාම ඉත්‍යනුමාය තේ සමුද්විවිජිරේ ත්‍රේෂුශ්ච| ");
INSERT INTO sansin_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","ස උවාච, කුතෝ දුඃඛිතා භවථ? යුෂ්මාකං මනඃසු සන්දේහ උදේති ච කුතඃ? ");
INSERT INTO sansin_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ඒෂෝහං, මම කරෞ පශ්‍යත වරං ස්පෘෂ්ට්වා පශ්‍යත, මම යාදෘශානි පශ්‍යථ තාදෘශානි භූතස්‍ය මාංසාස්ථීනි න සන්ති| ");
INSERT INTO sansin_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ඉත්‍යුක්ත්වා ස හස්තපාදාන් දර්ශයාමාස| ");
INSERT INTO sansin_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","තේ(අ)සම්භවං ඥාත්වා සානන්දා න ප්‍රත්‍යයන්| තතඃ ස තාන් පප්‍රච්ඡ, අත්‍ර යුෂ්මාකං සමීපේ ඛාද්‍යං කිඤ්චිදස්ති? ");
INSERT INTO sansin_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","තතස්තේ කියද්දග්ධමත්ස්‍යං මධු ච දදුඃ ");
INSERT INTO sansin_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ස තදාදාය තේෂාං සාක්‍ෂාද් බුභුජේ ");
INSERT INTO sansin_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","කථයාමාස ච මූසාව්‍යවස්ථායාං භවිෂ්‍යද්වාදිනාං ග්‍රන්ථේෂු ගීතපුස්තකේ ච මයි යානි සර්ව්වාණි වචනානි ලිඛිතානි තදනුරූපාණි ඝටිෂ්‍යන්තේ යුෂ්මාභිඃ සාර්ද්ධං ස්ථිත්වාහං යදේතද්වාක්‍යම් අවදං තදිදානීං ප්‍රත්‍යක්‍ෂමභූත්| ");
INSERT INTO sansin_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","අථ තේභ්‍යඃ ශාස්ත්‍රබෝධාධිකාරං දත්වාවදත්, ");
INSERT INTO sansin_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ඛ්‍රීෂ්ටේනේත්ථං මෘතියාතනා භෝක්තව්‍යා තෘතීයදිනේ ච ශ්මශානාදුත්ථාතව්‍යඤ්චේති ලිපිරස්ති; ");
INSERT INTO sansin_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","තන්නාම්නා යිරූශාලමමාරභ්‍ය සර්ව්වදේශේ මනඃපරාවර්ත්තනස්‍ය පාපමෝචනස්‍ය ච සුසංවාදඃ ප්‍රචාරයිතව්‍යඃ, ");
INSERT INTO sansin_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ඒෂු සර්ව්වේෂු යූයං සාක්‍ෂිණඃ| ");
INSERT INTO sansin_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","අපරඤ්ච පශ්‍යත පිත්‍රා යත් ප්‍රතිඥාතං තත් ප්‍රේෂයිෂ්‍යාමි, අතඒව යාවත්කාලං යූයං ස්වර්ගීයාං ශක්තිං න ප්‍රාප්ස්‍යථ තාවත්කාලං යිරූශාලම්නගරේ තිෂ්ඨත| ");
INSERT INTO sansin_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","අථ ස තාන් බෛථනීයාපර‍්‍ය්‍යන්තං නීත්වා හස්තාවුත්තෝල්‍ය ආශිෂ වක්තුමාරේභේ ");
INSERT INTO sansin_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ආශිෂං වදන්නේව ච තේභ්‍යඃ පෘථග් භූත්වා ස්වර්ගාය නීතෝ(අ)භවත්| ");
INSERT INTO sansin_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","තදා තේ තං භජමානා මහානන්දේන යිරූශාලමං ප්‍රත්‍යාජග්මුඃ| ");
INSERT INTO sansin_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","තතෝ නිරන්තරං මන්දිරේ තිෂ්ඨන්ත ඊශ්වරස්‍ය ප්‍රශංසාං ධන්‍යවාදඤ්ච කර්ත්තම් ආරේභිරේ| ඉති||");
INSERT INTO sansin_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ආදෞ වාද ආසීත් ස ච වාද ඊශ්වරේණ සාර්ධමාසීත් ස වාදඃ ස්වයමීශ්වර ඒව| ");
INSERT INTO sansin_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ස ආදාවීශ්වරේණ සහාසීත්| ");
INSERT INTO sansin_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","තේන සර්ව්වං වස්තු සසෘජේ සර්ව්වේෂු සෘෂ්ටවස්තුෂු කිමපි වස්තු තේනාසෘෂ්ටං නාස්ති| ");
INSERT INTO sansin_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ස ජීවනස්‍යාකාරඃ, තච්ච ජීවනං මනුෂ්‍යාණාං ජ්‍යෝතිඃ ");
INSERT INTO sansin_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","තජ්ජ්‍යෝතිරන්ධකාරේ ප්‍රචකාශේ කින්ත්වන්ධකාරස්තන්න ජග්‍රාහ| ");
INSERT INTO sansin_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","යෝහන් නාමක ඒකෝ මනුජ ඊශ්වරේණ ප්‍රේෂයාඤ්චක්‍රේ| ");
INSERT INTO sansin_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","තද්වාරා යථා සර්ව්වේ විශ්වසන්ති තදර්ථං ස තජ්ජ්‍යෝතිෂි ප්‍රමාණං දාතුං සාක්‍ෂිස්වරූපෝ භූත්වාගමත්, ");
INSERT INTO sansin_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ස ස්වයං තජ්ජ්‍යෝති ර්න කින්තු තජ්ජ්‍යෝතිෂි ප්‍රමාණං දාතුමාගමත්| ");
INSERT INTO sansin_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ජගත්‍යාගත්‍ය යඃ සර්ව්වමනුජේභ්‍යෝ දීප්තිං දදාති තදේව සත්‍යජ්‍යෝතිඃ| ");
INSERT INTO sansin_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ස යජ්ජගදසෘජත් තන්මද්‍ය ඒව ස ආසීත් කින්තු ජගතෝ ලෝකාස්තං නාජානන්| ");
INSERT INTO sansin_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","නිජාධිකාරං ස ආගච්ඡත් කින්තු ප්‍රජාස්තං නාගෘහ්ලන්| ");
INSERT INTO sansin_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","තථාපි යේ යේ තමගෘහ්ලන් අර්ථාත් තස්‍ය නාම්නි ව්‍යශ්වසන් තේභ්‍ය ඊශ්වරස්‍ය පුත්‍රා භවිතුම් අධිකාරම් අදදාත්| ");
INSERT INTO sansin_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","තේෂාං ජනිඃ ශෝණිතාන්න ශාරීරිකාභිලාෂාන්න මානවානාමිච්ඡාතෝ න කින්ත්වීශ්වරාදභවත්| ");
INSERT INTO sansin_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","ස වාදෝ මනුෂ්‍යරූපේණාවතීර‍්‍ය්‍ය සත්‍යතානුග්‍රහාභ්‍යාං පරිපූර්ණඃ සන් සාර්ධම් අස්මාභි ර්න්‍යවසත් තතඃ පිතුරද්විතීයපුත්‍රස්‍ය යෝග්‍යෝ යෝ මහිමා තං මහිමානං තස්‍යාපශ්‍යාම| ");
INSERT INTO sansin_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","තතෝ යෝහනපි ප්‍රචාර‍්‍ය්‍ය සාක්‍ෂ්‍යමිදං දත්තවාන් යෝ මම පශ්චාද් ආගමිෂ්‍යති ස මත්තෝ ගුරුතරඃ; යතෝ මත්පූර්ව්වං ස විද්‍යමාන ආසීත්; යදර්ථම් අහං සාක්‍ෂ්‍යමිදම් අදාං ස ඒෂඃ| ");
INSERT INTO sansin_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","අපරඤ්ච තස්‍ය පූර්ණතායා වයං සර්ව්වේ ක්‍රමශඃ ක්‍රමශෝනුග්‍රහං ප්‍රාප්තාඃ| ");
INSERT INTO sansin_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","මූසාද්වාරා ව්‍යවස්ථා දත්තා කින්ත්වනුග්‍රහඃ සත්‍යත්වඤ්ච යීශුඛ්‍රීෂ්ටද්වාරා සමුපාතිෂ්ඨතාං| ");
INSERT INTO sansin_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","කෝපි මනුජ ඊශ්වරං කදාපි නාපශ්‍යත් කින්තු පිතුඃ ක්‍රෝඩස්ථෝ(අ)ද්විතීයඃ පුත්‍රස්තං ප්‍රකාශයත්| ");
INSERT INTO sansin_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","ත්වං කඃ? ඉති වාක්‍යං ප්‍රේෂ්ටුං යදා යිහූදීයලෝකා යාජකාන් ලේවිලෝකාංශ්ච යිරූශාලමෝ යෝහනඃ සමීපේ ප්‍රේෂයාමාසුඃ, ");
INSERT INTO sansin_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","තදා ස ස්වීකෘතවාන් නාපහ්නූතවාන් නාහම් අභිෂික්ත ඉත්‍යඞ්ගීකෘතවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","තදා තේ(අ)පෘච්ඡන් තර්හි කෝ භවාන්? කිං ඒලියඃ? සෝවදත් න; තතස්තේ(අ)පෘච්ඡන් තර්හි භවාන් ස භවිෂ්‍යද්වාදී? සෝවදත් නාහං සඃ| ");
INSERT INTO sansin_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","තදා තේ(අ)පෘච්ඡන් තර්හි භවාන් කඃ? වයං ගත්වා ප්‍රේරකාන් ත්වයි කිං වක්‍ෂ්‍යාමඃ? ස්වස්මින් කිං වදසි? ");
INSERT INTO sansin_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","තදා සෝවදත්| පරමේශස්‍ය පන්ථානං පරිෂ්කුරුත සර්ව්වතඃ| ඉතීදං ප්‍රාන්තරේ වාක්‍යං වදතඃ කස්‍යචිද්‍රවඃ| කථාමිමාං යස්මින් යිශයියෝ භවිෂ්‍යද්වාදී ලිඛිතවාන් සෝහම්| ");
INSERT INTO sansin_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","යේ ප්‍රේෂිතාස්තේ ඵිරූශිලෝකාඃ| ");
INSERT INTO sansin_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","තදා තේ(අ)පෘච්ඡන් යදි නාභිෂික්තෝසි ඒලියෝසි න ස භවිෂ්‍යද්වාද්‍යපි නාසි ච, තර්හි ලෝකාන් මජ්ජයසි කුතඃ? ");
INSERT INTO sansin_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","තතෝ යෝහන් ප්‍රත්‍යවෝචත්, තෝයේ(අ)හං මජ්ජයාමීති සත්‍යං කින්තු යං යූයං න ජානීථ තාදෘශ ඒකෝ ජනෝ යුෂ්මාකං මධ්‍ය උපතිෂ්ඨති| ");
INSERT INTO sansin_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ස මත්පශ්චාද් ආගතෝපි මත්පූර්ව්වං වර්ත්තමාන ආසීත් තස්‍ය පාදුකාබන්ධනං මෝචයිතුමපි නාහං යෝග්‍යෝස්මි| ");
INSERT INTO sansin_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","යර්ද්දනනද්‍යාඃ පාරස්ථබෛථබාරායාං යස්මින්ස්ථානේ යෝහනමජ්ජයත් තස්මින ස්ථානේ සර්ව්වමේතද් අඝටත| ");
INSERT INTO sansin_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","පරේ(අ)හනි යෝහන් ස්වනිකටමාගච්ඡන්තං යිශුං විලෝක්‍ය ප්‍රාවෝචත් ජගතඃ පාපමෝචකම් ඊශ්වරස්‍ය මේෂශාවකං පශ්‍යත| ");
INSERT INTO sansin_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","යෝ මම පශ්චාදාගමිෂ්‍යති ස මත්තෝ ගුරුතරඃ, යතෝ හේතෝර්මත්පූර්ව්වං සෝ(අ)වර්ත්තත යස්මින්නහං කථාමිමාං කථිතවාන් ස ඒවායං| ");
INSERT INTO sansin_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","අපරං නාහමේනං ප්‍රත්‍යභිඥාතවාන් කින්තු ඉස්‍රායේල්ලෝකා ඒනං යථා පරිචින්වන්ති තදභිප්‍රායේණාහං ජලේ මජ්ජයිතුමාගච්ඡම්| ");
INSERT INTO sansin_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","පුනශ්ච යෝහනපරමේකං ප්‍රමාණං දත්වා කථිතවාන් විහායසඃ කපෝතවද් අවතරන්තමාත්මානම් අස්‍යෝපර‍්‍ය්‍යවතිෂ්ඨන්තං ච දෘෂ්ටවානහම්| ");
INSERT INTO sansin_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","නාහමේනං ප්‍රත්‍යභිඥාතවාන් ඉති සත්‍යං කින්තු යෝ ජලේ මජ්ජයිතුං මාං ප්‍රෛරයත් ස ඒවේමාං කථාමකථයත් යස්‍යෝපර‍්‍ය්‍යාත්මානම් අවතරන්තම් අවතිෂ්ඨන්තඤ්ච ද්‍රක්‍ෂයසි සඒව පවිත්‍රේ ආත්මනි මජ්ජයිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","අවස්තන්නිරීක්‍ෂ්‍යායම් ඊශ්වරස්‍ය තනය ඉති ප්‍රමාණං දදාමි| ");
INSERT INTO sansin_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","පරේ(අ)හනි යෝහන් ද්වාභ්‍යාං ශිෂ්‍යාභ්‍යාං සාර්ද්ධේං තිෂ්ඨන් ");
INSERT INTO sansin_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","යිශුං ගච්ඡන්තං විලෝක්‍ය ගදිතවාන්, ඊශ්වරස්‍ය මේෂශාවකං පශ්‍යතං| ");
INSERT INTO sansin_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ඉමාං කථාං ශ්‍රුත්වා ද්වෞ ශිෂ්‍යෞ යීශෝඃ පශ්චාද් ඊයතුඃ| ");
INSERT INTO sansin_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","තතෝ යීශුඃ පරාවෘත්‍ය තෞ පශ්චාද් ආගච්ඡන්තෞ දෘෂ්ට්වා පෘෂ්ටවාන් යුවාං කිං ගවේශයථඃ? තාවපෘච්ඡතාං හේ රබ්බි අර්ථාත් හේ ගුරෝ භවාන් කුත්‍ර තිෂ්ඨති? ");
INSERT INTO sansin_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","තතඃ සෝවාදිත් ඒත්‍ය පශ්‍යතං| තතෝ දිවසස්‍ය තෘතීයප්‍රහරස්‍ය ගතත්වාත් තෞ තද්දිනං තස්‍ය සඞ්ගේ(අ)ස්ථාතාං| ");
INSERT INTO sansin_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","යෞ ද්වෞ යෝහනෝ වාක්‍යං ශ්‍රුත්වා යිශෝඃ පශ්චාද් ආගමතාං තයෝඃ ශිමෝන්පිතරස්‍ය භ්‍රාතා ආන්ද්‍රියඃ ");
INSERT INTO sansin_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ස ඉත්වා ප්‍රථමං නිජසෝදරං ශිමෝනං සාක්‍ෂාත්ප්‍රාප්‍ය කථිතවාන් වයං ඛ්‍රීෂ්ටම් අර්ථාත් අභිෂික්තපුරුෂං සාක්‍ෂාත්කෘතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","පශ්චාත් ස තං යිශෝඃ සමීපම් ආනයත්| තදා යීශුස්තං දෘෂ්ට්වාවදත් ත්වං යූනසඃ පුත්‍රඃ ශිමෝන් කින්තු ත්වන්නාමධේයං කෛඵාඃ වා පිතරඃ අර්ථාත් ප්‍රස්තරෝ භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","පරේ(අ)හනි යීශෞ ගාලීලං ගන්තුං නිශ්චිතචේතසි සති ඵිලිපනාමානං ජනං සාක්‍ෂාත්ප්‍රාප්‍යාවෝචත් මම පශ්චාද් ආගච්ඡ| ");
INSERT INTO sansin_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","බෛත්සෛදානාම්නි යස්මින් ග්‍රාමේ පිතරාන්ද්‍රියයෝර්වාස ආසීත් තස්මින් ග්‍රාමේ තස්‍ය ඵිලිපස්‍ය වසතිරාසීත්| ");
INSERT INTO sansin_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","පශ්චාත් ඵිලිපෝ නිථනේලං සාක්‍ෂාත්ප්‍රාප්‍යාවදත් මූසා ව්‍යවස්ථා ග්‍රන්ථේ භවිෂ්‍යද්වාදිනාං ග්‍රන්ථේෂු ච යස්‍යාඛ්‍යානං ලිඛිතමාස්තේ තං යූෂඵඃ පුත්‍රං නාසරතීයං යීශුං සාක්‍ෂාද් අකාර්ෂ්ම වයං| ");
INSERT INTO sansin_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","තදා නිථනේල් කථිතවාන් නාසරන්නගරාත කිං කශ්චිදුත්තම උත්පන්තුං ශක්නෝති? තතඃ ඵිලිපෝ (අ)වෝචත් ඒත්‍ය පශ්‍ය| ");
INSERT INTO sansin_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","අපරඤ්ච යීශුඃ ස්වස්‍ය සමීපං තම් ආගච්ඡන්තං දෘෂ්ට්වා ව්‍යාහෘතවාන්, පශ්‍යායං නිෂ්කපටඃ සත්‍ය ඉස්‍රායේල්ලෝකඃ| ");
INSERT INTO sansin_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","තතඃ සෝවදද්, භවාන් මාං කථං ප්‍රත්‍යභිජානාති? යීශුරවාදීත් ඵිලිපස්‍ය ආහ්වානාත් පූර්ව්වං යදා ත්වමුඩුම්බරස්‍ය තරෝර්මූලේ(අ)ස්ථාස්තදා ත්වාමදර්ශම්| ");
INSERT INTO sansin_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","නිථනේල් අචකථත්, හේ ගුරෝ භවාන් නිතාන්තම් ඊශ්වරස්‍ය පුත්‍රෝසි, භවාන් ඉස්‍රායේල්වංශස්‍ය රාජා| ");
INSERT INTO sansin_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","තතෝ යීශු ර්ව්‍යාහරත්, ත්වාමුඩුම්බරස්‍ය පාදපස්‍ය මූලේ දෘෂ්ටවානාහං මමෛතස්මාද්වාක්‍යාත් කිං ත්වං ව්‍යශ්වසීඃ? ඒතස්මාදප්‍යාශ්චර‍්‍ය්‍යාණි කාර‍්‍ය්‍යාණි ද්‍රක්‍ෂ්‍යසි| ");
INSERT INTO sansin_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","අන්‍යච්චාවාදීද් යුෂ්මානහං යථාර්ථං වදාමි, ඉතඃ පරං මෝචිතේ මේඝද්වාරේ තස්මාන්මනුජසූනුනා ඊශ්වරස්‍ය දූතගණම් අවරෝහන්තමාරෝහන්තඤ්ච ද්‍රක්‍ෂ්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","අනන්තරං ත්‍රුතීයදිවසේ ගාලීල් ප්‍රදේශියේ කාන්නානාම්නි නගරේ විවාහ ආසීත් තත්‍ර ච යීශෝර්මාතා තිෂ්ඨත්| ");
INSERT INTO sansin_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","තස්මෛ විවාහාය යීශුස්තස්‍ය ශිෂ්‍යාශ්ච නිමන්ත්‍රිතා ආසන්| ");
INSERT INTO sansin_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","තදනන්තරං ද්‍රාක්‍ෂාරසස්‍ය න්‍යූනත්වාද් යීශෝර්මාතා තමවදත් ඒතේෂාං ද්‍රාක්‍ෂාරසෝ නාස්ති| ");
INSERT INTO sansin_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","තදා ස තාමවෝචත් හේ නාරි මයා සහ තව කිං කාර‍්‍ය්‍යං? මම සමය ඉදානීං නෝපතිෂ්ඨති| ");
INSERT INTO sansin_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","තතස්තස්‍ය මාතා දාසානවෝචද් අයං යද් වදති තදේව කුරුත| ");
INSERT INTO sansin_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","තස්මින් ස්ථානේ යිහූදීයානාං ශුචිත්වකරණව්‍යවහාරානුසාරේණාඪකෛකජලධරාණි පාෂාණමයානි ෂඩ්වෘහත්පාත්‍රාණිආසන්| ");
INSERT INTO sansin_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","තදා යීශුස්තාන් සර්ව්වකලශාන් ජලෛඃ පූරයිතුං තානාඥාපයත්, තතස්තේ සර්ව්වාන් කුම්භානාකර්ණං ජලෛඃ පර‍්‍ය්‍යපූරයන්| ");
INSERT INTO sansin_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","අථ තේභ්‍යඃ කිඤ්චිදුත්තාර‍්‍ය්‍ය භෝජ්‍යාධිපාතේඃසමීපං නේතුං ස තානාදිශත්, තේ තදනයන්| ");
INSERT INTO sansin_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","අපරඤ්ච තජ්ජලං කථං ද්‍රාක්‍ෂාරසෝ(අ)භවත් තජ්ජලවාහකාදාසා ඥාතුං ශක්තාඃ කින්තු තද්භෝජ්‍යාධිපෝ ඥාතුං නාශක්නෝත් තදවලිහ්‍ය වරං සංම්බෝද්‍යාවදත, ");
INSERT INTO sansin_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ලෝකාඃ ප්‍රථමං උත්තමද්‍රාක්‍ෂාරසං දදති තෂු යථේෂ්ටං පිතවත්සු තස්මා කිඤ්චිදනුත්තමඤ්ච දදති කින්තු ත්වමිදානීං යාවත් උත්තමද්‍රාක්‍ෂාරසං ස්ථාපයසි| ");
INSERT INTO sansin_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ඉත්ථං යීශුර්ගාලීලප්‍රදේශේ ආශ්චර‍්‍ය්‍යකාර්ම්ම ප්‍රාරම්භ නිජමහිමානං ප්‍රාකාශයත් තතඃ ශිෂ්‍යාස්තස්මින් ව්‍යශ්වසන්| ");
INSERT INTO sansin_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","තතඃ පරම් ස නිජමාත්‍රුභ්‍රාත්‍රුස්ශිෂ්‍යෛඃ සාර්ද්ධ්ං කඵර්නාහූමම් ආගමත් කින්තු තත්‍ර බහූදිනානි ආතිෂ්ඨත්| ");
INSERT INTO sansin_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","තදනන්තරං යිහූදියානාං නිස්තාරෝත්සවේ නිකටමාගතේ යීශු ර‍්‍යිරූශාලම් නගරම් ආගච්ඡත්| ");
INSERT INTO sansin_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","තතෝ මන්දිරස්‍ය මධ්‍යේ ගෝමේෂපාරාවතවික්‍රයිණෝ වාණිජක්‍ෂ්චෝපවිෂ්ටාන් විලෝක්‍ය ");
INSERT INTO sansin_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","රජ්ජුභිඃ කශාං නිර්ම්මාය සර්ව්වගෝමේෂාදිභිඃ සාර්ද්ධං තාන් මන්දිරාද් දූරීකෘතවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","වණිජාං මුද්‍රාදි විකීර‍්‍ය්‍ය ආසනානි න්‍යූබ්ජීකෘත්‍ය පාරාවතවික්‍රයිභ්‍යෝ(අ)කථයද් අස්මාත් ස්ථානාත් සර්වාණ්‍යේතානි නයත, මම පිතුගෘහං වාණිජ්‍යගෘහං මා කාර්ෂ්ට| ");
INSERT INTO sansin_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","තස්මාත් තන්මන්දිරාර්ථ උද්‍යෝගෝ යස්තු ස ග්‍රසතීව මාම්| ඉමාං ශාස්ත්‍රීයලිපිං ශිෂ්‍යාඃසමස්මරන්| ");
INSERT INTO sansin_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","තතඃ පරම් යිහූදීයලෝකා යීෂිමවදන් තවමිදෘශකර්ම්මකරණාත් කිං චිහ්නමස්මාන් දර්ශයසි? ");
INSERT INTO sansin_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","තතෝ යීශුස්තානවෝචද් යුෂ්මාභිරේ තස්මින් මන්දිරේ නාශිතේ දිනත්‍රයමධ්‍යේ(අ)හං තද් උත්ථාපයිෂ්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","තදා යිහූදියා ව්‍යාහාර්ෂුඃ, ඒතස්‍ය මන්දිරස නිර්ම්මාණේන ෂට්චත්වාරිංශද් වත්සරා ගතාඃ, ත්වං කිං දිනත්‍රයමධ්‍යේ තද් උත්ථාපයිෂ්‍යසි? ");
INSERT INTO sansin_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","කින්තු ස නිජදේහරූපමන්දිරේ කථාමිමාං කථිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ස යදේතාදෘශං ගදිතවාන් තච්ඡිෂ්‍යාඃ ශ්මශානාත් තදීයෝත්ථානේ සති ස්මෘත්වා ධර්ම්මග්‍රන්ථේ යීශුනෝක්තකථායාං ච ව්‍යශ්වසිෂුඃ| ");
INSERT INTO sansin_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","අනන්තරං නිස්තාරෝත්සවස්‍ය භෝජ්‍යසමයේ යිරූශාලම් නගරේ තත්ක්‍රුතාශ්චර‍්‍ය්‍යකර්ම්මාණි විලෝක්‍ය බහුභිස්තස්‍ය නාමනි විශ්වසිතං| ");
INSERT INTO sansin_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","කින්තු ස තේෂාං කරේෂු ස්වං න සමර්පයත්, යතඃ ස සර්ව්වානවෛත්| ");
INSERT INTO sansin_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ස මානවේෂු කස්‍යචිත් ප්‍රමාණං නාපේක්‍ෂත යතෝ මනුජානාං මධ්‍යේ යද්‍යදස්ති තත්තත් සෝජානාත්| ");
INSERT INTO sansin_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","නිකදිමනාමා යිහූදීයානාම් අධිපතිඃ ඵිරූශී ක්‍ෂණදායාං ");
INSERT INTO sansin_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","යීශෞරභ්‍යර්ණම් ආව්‍රජ්‍ය ව්‍යාහාර්ෂීත්, හේ ගුරෝ භවාන් ඊශ්වරාද් ආගත් ඒක උපදේෂ්ටා, ඒතද් අස්මාභිර්ඥායතේ; යතෝ භවතා යාන්‍යාශ්චර‍්‍ය්‍යකර්ම්මාණි ක්‍රියන්තේ පරමේශ්වරස්‍ය සාහාය්‍යං විනා කේනාපි තත්තත්කර්ම්මාණි කර්ත්තුං න ශක්‍යන්තේ| ");
INSERT INTO sansin_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","තදා යීශුරුත්තරං දත්තවාන් තවාහං යථාර්ථතරං ව්‍යාහරාමි පුනර්ජන්මනි න සති කෝපි මානව ඊශ්වරස්‍ය රාජ්‍යං ද්‍රෂ්ටුං න ශක්නෝති| ");
INSERT INTO sansin_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","තතෝ නිකදීමඃ ප්‍රත්‍යවෝචත් මනුජෝ වෘද්ධෝ භූත්වා කථං ජනිෂ්‍යතේ? ස කිං පුන ර්මාතෘර්ජඨරං ප්‍රවිශ්‍ය ජනිතුං ශක්නෝති? ");
INSERT INTO sansin_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","යීශුරවාදීද් යථාර්ථතරම් අහං කථයාමි මනුජේ තෝයාත්මභ්‍යාං පුන ර්න ජාතේ ස ඊශ්වරස්‍ය රාජ්‍යං ප්‍රවේෂ්ටුං න ශක්නෝති| ");
INSERT INTO sansin_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","මාංසාද් යත් ජායතේ තන් මාංසමේව තථාත්මනෝ යෝ ජායතේ ස ආත්මෛව| ");
INSERT INTO sansin_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","යුෂ්මාභිඃ පුන ර්ජනිතව්‍යං මමෛතස්‍යාං කථායාම් ආශ්චර‍්‍යං මා මංස්ථාඃ| ");
INSERT INTO sansin_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","සදාගතිර‍්‍යාං දිශමිච්ඡති තස්‍යාමේව දිශි වාති, ත්වං තස්‍ය ස්වනං ශුණෝෂි කින්තු ස කුත ආයාති කුත්‍ර යාති වා කිමපි න ජානාසි තද්වාද් ආත්මනඃ සකාශාත් සර්ව්වේෂාං මනුජානාං ජන්ම භවති| ");
INSERT INTO sansin_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","තදා නිකදීමඃ පෘෂ්ටවාන් ඒතත් කථං භවිතුං ශක්නෝති? ");
INSERT INTO sansin_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","යීශුඃ ප්‍රත්‍යක්තවාන් ත්වමිස්‍රායේලෝ ගුරුර්භූත්වාපි කිමේතාං කථාං න වේත්සි? ");
INSERT INTO sansin_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","තුභ්‍යං යථාර්ථං කථයාමි, වයං යද් විද්මස්තද් වච්මඃ යංච්ච පශ්‍යාමස්තස්‍යෛව සාක්‍ෂ්‍යං දද්මඃ කින්තු යුෂ්මාභිරස්මාකං සාක්‍ෂිත්වං න ගෘහ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ඒතස්‍ය සංසාරස්‍ය කථායාං කථිතායාං යදි යූයං න විශ්වසිථ තර්හි ස්වර්ගීයායාං කථායාං කථං විශ්වසිෂ්‍යථ? ");
INSERT INTO sansin_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","යඃ ස්වර්ගේ(අ)ස්ති යං ච ස්වර්ගාද් අවාරෝහත් තං මානවතනයං විනා කෝපි ස්වර්ගං නාරෝහත්| ");
INSERT INTO sansin_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","අපරඤ්ච මූසා යථා ප්‍රාන්තරේ සර්පං ප්‍රෝත්ථාපිතවාන් මනුෂ්‍යපුත්‍රෝ(අ)පි තථෛවෝත්ථාපිතව්‍යඃ; ");
INSERT INTO sansin_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","තස්මාද් යඃ කශ්චිත් තස්මින් විශ්වසිෂ්‍යති සෝ(අ)විනාශ්‍යඃ සන් අනන්තායුඃ ප්‍රාප්ස්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ඊශ්වර ඉත්ථං ජගදදයත යත් ස්වමද්විතීයං තනයං ප්‍රාදදාත් තතෝ යඃ කශ්චිත් තස්මින් විශ්වසිෂ්‍යති සෝ(අ)විනාශ්‍යඃ සන් අනන්තායුඃ ප්‍රාප්ස්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ඊශ්වරෝ ජගතෝ ලෝකාන් දණ්ඩයිතුං ස්වපුත්‍රං න ප්‍රේෂ්‍ය තාන් පරිත්‍රාතුං ප්‍රේෂිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","අතඒව යඃ කශ්චිත් තස්මින් විශ්වසිති ස දණ්ඩාර්හෝ න භවති කින්තු යඃ කශ්චිත් තස්මින් න විශ්වසිති ස ඉදානීමේව දණ්ඩාර්හෝ භවති,යතඃ ස ඊශ්වරස්‍යාද්විතීයපුත්‍රස්‍ය නාමනි ප්‍රත්‍යයං න කරෝති| ");
INSERT INTO sansin_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","ජගතෝ මධ්‍යේ ජ්‍යෝතිඃ ප්‍රාකාශත කින්තු මනුෂ්‍යාණාං කර්ම්මණාං දෘෂ්ටත්වාත් තේ ජ්‍යෝතිෂෝපි තිමිරේ ප්‍රීයන්තේ ඒතදේව දණ්ඩස්‍ය කාරණාං භවති| ");
INSERT INTO sansin_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","යඃ කුකර්ම්ම කරෝති තස්‍යාචාරස්‍ය දෘෂ්ටත්වාත් ස ජ්‍යෝතිරෲතීයිත්වා තන්නිකටං නායාති; ");
INSERT INTO sansin_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","කින්තු යඃ සත්කර්ම්ම කරෝති තස්‍ය සර්ව්වාණි කර්ම්මාණීශ්වරේණ කෘතානීති සථා ප්‍රකාශතේ තදභිප්‍රායේණ ස ජ්‍යෝතිෂඃ සන්නිධිම් ආයාති| ");
INSERT INTO sansin_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","තතඃ පරම් යීශුඃ ශිෂ්‍යෛඃ සාර්ද්ධං යිහූදීයදේශං ගත්වා තත්‍ර ස්ථිත්වා මජ්ජයිතුම් ආරභත| ");
INSERT INTO sansin_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","තදා ශාලම් නගරස්‍ය සමීපස්ථායිනි ඓනන් ග්‍රාමේ බහුතරතෝයස්ථිතේස්තත්‍ර යෝහන් අමජ්ජයත් තථා ච ලෝකා ආගත්‍ය තේන මජ්ජිතා අභවන්| ");
INSERT INTO sansin_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","තදා යෝහන් කාරායාං න බද්ධඃ| ");
INSERT INTO sansin_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","අපරඤ්ච ශාචකර්ම්මණි යෝහානඃ ශිෂ්‍යෛඃ සහ යිහූදීයලෝකානාං විවාදේ ජාතේ, තේ යෝහනඃ සංන්නිධිං ගත්වාකථයන්, ");
INSERT INTO sansin_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","හේ ගුරෝ යර්ද්දනනද්‍යාඃ පාරේ භවතා සාර්ද්ධං ය ආසීත් යස්මිංශ්ච භවාන් සාක්‍ෂ්‍යං ප්‍රදදාත් පශ්‍යතු සෝපි මජ්ජයති සර්ව්වේ තස්‍ය සමීපං යාන්ති ච| ");
INSERT INTO sansin_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","තදා යෝහන් ප්‍රත්‍යවෝචද් ඊශ්වරේණ න දත්තේ කෝපි මනුජඃ කිමපි ප්‍රාප්තුං න ශක්නෝති| ");
INSERT INTO sansin_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","අහං අභිෂික්තෝ න භවාමි කින්තු තදග්‍රේ ප්‍රේෂිතෝස්මි යාමිමාං කථාං කථිතවානාහං තත්‍ර යූයං සර්ව්වේ සාක්‍ෂිණඃ ස්ථ| ");
INSERT INTO sansin_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","යෝ ජනඃ කන්‍යාං ලභතේ ස ඒව වරඃ කින්තු වරස්‍ය සන්නිධෞ දණ්ඩායමානං තස්‍ය යන්මිත්‍රං තේන වරස්‍ය ශබ්දේ ශ්‍රුතේ(අ)තීවාහ්ලාද්‍යතේ මමාපි තද්වද් ආනන්දසිද්ධිර්ජාතා| ");
INSERT INTO sansin_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","තේන ක්‍රමශෝ වර්ද්ධිතව්‍යං කින්තු මයා හ්සිතව්‍යං| ");
INSERT INTO sansin_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ය ඌර්ධ්වාදාගච්ඡත් ස සර්ව්වේෂාං මුඛ්‍යෝ යශ්ච සංසාරාද් උදපද්‍යත ස සාංසාරිකඃ සංසාරීයාං කථාඤ්ච කථයති යස්තු ස්වර්ගාදාගච්ඡත් ස සර්ව්වේෂාං මුඛ්‍යඃ| ");
INSERT INTO sansin_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ස යදපශ්‍යදශෘණෝච්ච තස්මින්නේව සාක්‍ෂ්‍යං දදාති තථාපි ප්‍රායශඃ කශ්චිත් තස්‍ය සාක්‍ෂ්‍යං න ගෘහ්ලාති; ");
INSERT INTO sansin_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","කින්තු යෝ ගෘහ්ලාති ස ඊශ්වරස්‍ය සත්‍යවාදිත්වං මුද්‍රාඞ්ගිතං කරෝති| ");
INSERT INTO sansin_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ඊශ්වරේණ යඃ ප්‍රේරිතඃ සඒව ඊශ්වරීයකථාං කථයති යත ඊශ්වර ආත්මානං තස්මෛ අපරිමිතම් අදදාත්| ");
INSERT INTO sansin_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","පිතා පුත්‍රේ ස්නේහං කෘත්වා තස්‍ය හස්තේ සර්ව්වාණි සමර්පිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","යඃ කශ්චිත් පුත්‍රේ විශ්වසිති ස ඒවානන්තම් පරමායුඃ ප්‍රාප්නෝති කින්තු යඃ කශ්චිත් පුත්‍රේ න විශ්වසිති ස පරමායුෂෝ දර්ශනං න ප්‍රාප්නෝති කින්ත්වීශ්වරස්‍ය කෝපභාජනං භූත්වා තිෂ්ඨති| ");
INSERT INTO sansin_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","යීශුඃ ස්වයං නාමජ්ජයත් කේවලං තස්‍ය ශිෂ්‍යා අමජ්ජයත් කින්තු යෝහනෝ(අ)ධිකශිෂ්‍යාන් ස කරෝති මජ්ජයති ච, ");
INSERT INTO sansin_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ඵිරූශින ඉමාං වාර්ත්තාමශෘණ්වන් ඉති ප්‍රභුරවගත්‍ය ");
INSERT INTO sansin_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","යිහූදීයදේශං විහාය පුන ර්ගාලීලම් ආගත්| ");
INSERT INTO sansin_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","තතඃ ශෝමිරෝණප්‍රදේශස්‍ය මද්‍යේන තේන ගන්තව්‍යේ සති ");
INSERT INTO sansin_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","යාකූබ් නිජපුත්‍රාය යූෂඵේ යාං භූමිම් අදදාත් තත්සමීපස්ථායි ශෝමිරෝණප්‍රදේශස්‍ය සුඛාර් නාම්නා විඛ්‍යාතස්‍ය නගරස්‍ය සන්නිධාවුපාස්ථාත්| ");
INSERT INTO sansin_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","තත්‍ර යාකූබඃ ප්‍රහිරාසීත්; තදා ද්විතීයයාමවේලායාං ජාතායාං ස මාර්ගේ ශ්‍රමාපන්නස්තස්‍ය ප්‍රහේඃ පාර්ශ්වේ උපාවිශත්| ");
INSERT INTO sansin_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ඒතර්හි කාචිත් ශෝමිරෝණීයා යෝෂිත් තෝයෝත්තෝලනාර්ථම් තත්‍රාගමත් ");
INSERT INTO sansin_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","තදා ශිෂ්‍යාඃ ඛාද්‍යද්‍රව්‍යාණි ක්‍රේතුං නගරම් අගච්ඡන්| ");
INSERT INTO sansin_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","යීශුඃ ශෝමිරෝණීයාං තාං යෝෂිතම් ව්‍යාහාර්ෂීත් මහ්‍යං කිඤ්චිත් පානීයං පාතුං දේහි| කින්තු ශෝමිරෝණීයෛඃ සාකං යිහූදීයලෝකා න ව්‍යවාහරන් තස්මාද්ධේතෝඃ සාකථයත් ශෝමිරෝණීයා යෝෂිතදහං ත්වං යිහූදීයෝසි කථං මත්තඃ පානීයං පාතුම් ඉච්ඡසි? ");
INSERT INTO sansin_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","තතෝ යීශුරවදද් ඊශ්වරස්‍ය යද්දානං තත්කීදෘක් පානීයං පාතුං මහ්‍යං දේහි ය ඉත්ථං ත්වාං යාචතේ ස වා ක ඉති චේදඥාස්‍යථාස්තර්හි තමයාචිෂ්‍යථාඃ ස ච තුභ්‍යමමෘතං තෝයමදාස්‍යත්| ");
INSERT INTO sansin_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","තදා සා සීමන්තිනී භාෂිතවති, හේ මහේච්ඡ ප්‍රහිර්ගම්භීරෝ භවතෝ නීරෝත්තෝලනපාත්‍රං නාස්තී ච තස්මාත් තදමෘතං කීලාලං කුතඃ ප්‍රාප්ස්‍යසි? ");
INSERT INTO sansin_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","යෝස්මභ්‍යම් ඉමමන්ධූං දදෞ, යස්‍ය ච පරිජනා ගෝමේෂාදයශ්ච සර්ව්වේ(අ)ස්‍ය ප්‍රහේඃ පානීයං පපුරේතාදෘශෝ යෝස්මාකං පූර්ව්වපුරුෂෝ යාකූබ් තස්මාදපි භවාන් මහාන් කිං? ");
INSERT INTO sansin_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","තතෝ යීශුරකථයද් ඉදං පානීයං සඃ පිවති ස පුනස්තෘෂාර්ත්තෝ භවිෂ්‍යති, ");
INSERT INTO sansin_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","කින්තු මයා දත්තං පානීයං යඃ පිවති ස පුනඃ කදාපි තෘෂාර්ත්තෝ න භවිෂ්‍යති| මයා දත්තම් ඉදං තෝයං තස්‍යාන්තඃ ප්‍රස්‍රවණරූපං භූත්වා අනන්තායුර‍්‍යාවත් ස්‍රෝෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","තදා සා වනිතාකථයත් හේ මහේච්ඡ තර්හි මම පුනඃ පීපාසා යථා න ජායතේ තෝයෝත්තෝලනාය යථාත්‍රාගමනං න භවති ච තදර්ථං මහ්‍යං තත්තෝයං දේහී| ");
INSERT INTO sansin_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","තතෝ යීශූරවදද්‍යාහි තව පතිමාහූය ස්ථානේ(අ)ත්‍රාගච්ඡ| ");
INSERT INTO sansin_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","සා වාමාවදත් මම පතිර්නාස්ති| යීශුරවදත් මම පතිර්නාස්තීති වාක්‍යං භද්‍රමවෝචඃ| ");
INSERT INTO sansin_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","යතස්තව පඤ්ච පතයෝභවන් අධුනා තු ත්වයා සාර්ද්ධං යස්තිෂ්ඨති ස තව භර්ත්තා න වාක්‍යමිදං සත්‍යමවාදිඃ| ");
INSERT INTO sansin_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","තදා සා මහිලා ගදිතවති හේ මහේච්ඡ භවාන් ඒකෝ භවිෂ්‍යද්වාදීති බුද්ධං මයා| ");
INSERT INTO sansin_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","අස්මාකං පිතෘලෝකා ඒතස්මින් ශිලෝච්චයේ(අ)භජන්ත, කින්තු භවද්භිරුච්‍යතේ යිරූශාලම් නගරේ භජනයෝග්‍යං ස්ථානමාස්තේ| ");
INSERT INTO sansin_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","යීශුරවෝචත් හේ යෝෂිත් මම වාක්‍යේ විශ්වසිහි යදා යූයං කේවලශෛලේ(අ)ස්මින් වා යිරූශාලම් නගරේ පිතුර්භජනං න කරිෂ්‍යධ්වේ කාල ඒතාදෘශ ආයාති| ");
INSERT INTO sansin_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","යූයං යං භජධ්වේ තං න ජානීථ, කින්තු වයං යං භජාමහේ තං ජානීමහේ, යතෝ යිහූදීයලෝකානාං මධ්‍යාත් පරිත්‍රාණං ජායතේ| ");
INSERT INTO sansin_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","කින්තු යදා සත්‍යභක්තා ආත්මනා සත්‍යරූපේණ ච පිතුර්භජනං කරිෂ්‍යන්තේ සමය ඒතාදෘශ ආයාති, වරම් ඉදානීමපි විද්‍යතේ ; යත ඒතාදෘශෝ භත්කාන් පිතා චේෂ්ටතේ| ");
INSERT INTO sansin_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ඊශ්වර ආත්මා; තතස්තස්‍ය යේ භක්තාස්තෛඃ ස ආත්මනා සත්‍යරූපේණ ච භජනීයඃ| ");
INSERT INTO sansin_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","තදා සා මහිලාවාදීත් ඛ්‍රීෂ්ටනාම්නා විඛ්‍යාතෝ(අ)භිෂික්තඃ පුරුෂ ආගමිෂ්‍යතීති ජානාමි ස ච සර්ව්වාඃ කථා අස්මාන් ඥාපයිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","තතෝ යීශුරවදත් ත්වයා සාර්ද්ධං කථනං කරෝමි යෝ(අ)හම් අහමේව ස පුරුෂඃ| ");
INSERT INTO sansin_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ඒතස්මින් සමයේ ශිෂ්‍යා ආගත්‍ය තථා ස්ත්‍රියා සාර්ද්ධං තස්‍ය කථෝපකථනේ මහාශ්චර‍්‍ය්‍යම් අමන්‍යන්ත තථාපි භවාන් කිමිච්ඡති? යද්වා කිමර්ථම් ඒතයා සාර්ද්ධං කථාං කථයති? ඉති කෝපි නාපෘච්ඡත්| ");
INSERT INTO sansin_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","තතඃ පරං සා නාරී කලශං ස්ථාපයිත්වා නගරමධ්‍යං ගත්වා ලෝකේභ්‍යෝකථායද් ");
INSERT INTO sansin_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","අහං යද්‍යත් කර්ම්මාකරවං තත්සර්ව්වං මහ්‍යමකථයද් ඒතාදෘශං මානවමේකම් ආගත්‍ය පශ්‍යත රු කිම් අභිෂික්තෝ න භවති ? ");
INSERT INTO sansin_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","තතස්තේ නගරාද් බහිරාගත්‍ය තාතස්‍ය සමීපම් ආයන්| ");
INSERT INTO sansin_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ඒතර්හි ශිෂ්‍යාඃ සාධයිත්වා තං ව්‍යාහාර්ෂුඃ හේ ගුරෝ භවාන් කිඤ්චිද් භූක්තාං| ");
INSERT INTO sansin_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","තතඃ සෝවදද් යුෂ්මාභිර‍්‍යන්න ඥායතේ තාදෘශං භක්‍ෂ්‍යං මමාස්තේ| ");
INSERT INTO sansin_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","තදා ශිෂ්‍යාඃ පරස්පරං ප්‍රෂ්ටුම් ආරම්භන්ත, කිමස්මෛ කෝපි කිමපි භක්‍ෂ්‍යමානීය දත්තවාන්? ");
INSERT INTO sansin_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","යීශුරවෝචත් මත්ප්‍රේරකස්‍යාභිමතානුරූපකරණං තස්‍යෛව කර්ම්මසිද්ධිකාරණඤ්ච මම භක්‍ෂ්‍යං| ");
INSERT INTO sansin_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","මාසචතුෂ්ටයේ ජාතේ ශස්‍යකර්ත්තනසමයෝ භවිෂ්‍යතීති වාක්‍යං යුෂ්මාභිඃ කිං නෝද්‍යතේ? කින්ත්වහං වදාමි, ශිර උත්තෝල්‍ය ක්‍ෂේත්‍රාණි ප්‍රති නිරීක්‍ෂ්‍ය පශ්‍යත, ඉදානීං කර්ත්තනයෝග්‍යානි ශුක්ලවර්ණාන්‍යභවන්| ");
INSERT INTO sansin_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","යශ්ඡිනත්ති ස වේතනං ලභතේ අනන්තායුඃස්වරූපං ශස්‍යං ස ගෘහ්ලාති ච, තේනෛව වප්තා ඡේත්තා ච යුගපද් ආනන්දතඃ| ");
INSERT INTO sansin_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ඉත්ථං සති වපත්‍යේකශ්ඡිනත්‍යන්‍ය ඉති වචනං සිද්ධ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","යත්‍ර යූයං න පර‍්‍ය්‍යශ්‍රාම්‍යත තාදෘශං ශස්‍යං ඡේත්තුං යුෂ්මාන් ප්‍රෛරයම් අන්‍යේ ජනාඃපර‍්‍ය්‍යශ්‍රාම්‍යන් යූයං තේෂාං ශ්‍රගස්‍ය ඵලම් අලභධ්වම්| ");
INSERT INTO sansin_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","යස්මින් කාලේ යද්‍යත් කර්ම්මාකාර්ෂං තත්සර්ව්වං ස මහ්‍යම් අකථයත් තස්‍යා වනිතායා ඉදං සාක්‍ෂ්‍යවාක්‍යං ශ්‍රුත්වා තන්නගරනිවාසිනෝ බහවඃ ශෝමිරෝණීයලෝකා ව්‍යශ්වසන්| ");
INSERT INTO sansin_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","තථා ච තස්‍යාන්තිකේ සමුපස්ථාය ස්වේෂාං සන්නිධෞ කතිචිද් දිනානි ස්ථාතුං තස්මින් විනයම් අකුර්ව්වාන තස්මාත් ස දිනද්වයං තත්ස්ථානේ න්‍යවෂ්ටත් ");
INSERT INTO sansin_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","තතස්තස්‍යෝපදේශේන බහවෝ(අ)පරේ විශ්වස්‍ය ");
INSERT INTO sansin_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","තාං යෝෂාමවදන් කේවලං තව වාක්‍යේන ප්‍රතීම ඉති න, කින්තු ස ජගතෝ(අ)භිෂික්තස්ත්‍රාතේති තස්‍ය කථාං ශ්‍රුත්වා වයං ස්වයමේවාඥාසමහි| ");
INSERT INTO sansin_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","ස්වදේශේ භවිෂ්‍යද්වක්තුඃ සත්කාරෝ නාස්තීති යද්‍යපි යීශුඃ ප්‍රමාණං දත්වාකථයත් ");
INSERT INTO sansin_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","තථාපි දිවසද්වයාත් පරං ස තස්මාත් ස්ථානාද් ගාලීලං ගතවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","අනන්තරං යේ ගාලීලී ලියලෝකා උත්සවේ ගතා උත්සවසමයේ යිරූශලම් නගරේ තස්‍ය සර්ව්වාඃ ක්‍රියා අපශ්‍යන් තේ ගාලීලම් ආගතං තම් ආගෘහ්ලන්| ");
INSERT INTO sansin_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","තතඃ පරම් යීශු ර‍්‍යස්මින් කාන්නානගරේ ජලං ද්‍රාක්‍ෂාරසම් ආකරෝත් තත් ස්ථානං පුනරගාත්| තස්මින්නේව සමයේ කස්‍යචිද් රාජසභාස්තාරස්‍ය පුත්‍රඃ කඵර්නාහූමපුරී රෝගග්‍රස්ත ආසීත්| ");
INSERT INTO sansin_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ස යේහූදීයදේශාද් යීශෝ ර්ගාලීලාගමනවාර්ත්තාං නිශම්‍ය තස්‍ය සමීපං ගත්වා ප්‍රාර්ථ්‍ය ව්‍යාහෘතවාන් මම පුත්‍රස්‍ය ප්‍රායේණ කාල ආසන්නඃ භවාන් ආගත්‍ය තං ස්වස්ථං කරෝතු| ");
INSERT INTO sansin_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","තදා යීශුරකථයද් ආශ්චර‍්‍ය්‍යං කර්ම්ම චිත්‍රං චිහ්නං ච න දෘෂ්ටා යූයං න ප්‍රත්‍යේෂ්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","තතඃ ස සභාසදවදත් හේ මහේච්ඡ මම පුත්‍රේ න මෘතේ භවානාගච්ඡතු| ");
INSERT INTO sansin_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","යීශුස්තමවදද් ගච්ඡ තව පුත්‍රෝ(අ)ජීවීත් තදා යීශුනෝක්තවාක්‍යේ ස විශ්වස්‍ය ගතවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ගමනකාලේ මාර්ගමධ්‍යේ දාසාස්තං සාක්‍ෂාත්ප්‍රාප්‍යාවදන් භවතඃ පුත්‍රෝ(අ)ජීවීත්| ");
INSERT INTO sansin_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","තතඃ කං කාලමාරභ්‍ය රෝගප්‍රතීකාරාරම්භෝ ජාතා ඉති පෘෂ්ටේ තෛරුක්තං හ්‍යඃ සාර්ද්ධදණ්ඩද්වයාධිකද්විතීයයාමේ තස්‍ය ජ්වරත්‍යාගෝ(අ)භවත්| ");
INSERT INTO sansin_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","තදා යීශුස්තස්මින් ක්‍ෂණේ ප්‍රෝක්තවාන් තව පුත්‍රෝ(අ)ජීවීත් පිතා තද්බුද්ධ්වා සපරිවාරෝ ව්‍යශ්වසීත්| ");
INSERT INTO sansin_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","යිහූදීයදේශාද් ආගත්‍ය ගාලීලි යීශුරේතද් ද්විතීයම් ආශ්චර‍්‍ය්‍යකර්ම්මාකරෝත්| ");
INSERT INTO sansin_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","තතඃ පරං යිහූදීයානාම් උත්සව උපස්ථිතේ යීශු ර‍්‍යිරූශාලමං ගතවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","තස්මින්නගරේ මේෂනාම්නෝ ද්වාරස්‍ය සමීපේ ඉබ්‍රීයභාෂයා බෛථේස්දා නාම්නා පිෂ්කරිණී පඤ්චඝට්ටයුක්තාසීත්| ");
INSERT INTO sansin_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","තස්‍යාස්තේෂු ඝට්ටේෂු කිලාලකම්පනම් අපේක්‍ෂ්‍ය අන්ධඛඤ්චශුෂ්කාඞ්ගාදයෝ බහවෝ රෝගිණඃ පතන්තස්තිෂ්ඨන්ති ස්ම| ");
INSERT INTO sansin_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","යතෝ විශේෂකාලේ තස්‍ය සරසෝ වාරි ස්වර්ගීයදූත ඒත්‍යාකම්පයත් තත්කීලාලකම්පනාත් පරං යඃ කශ්චිද් රෝගී ප්‍රථමං පානීයමවාරෝහත් ස ඒව තත්ක්‍ෂණාද් රෝගමුක්තෝ(අ)භවත්| ");
INSERT INTO sansin_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","තදාෂ්ටාත්‍රිංශද්වර්ෂාණි යාවද් රෝගග්‍රස්ත ඒකජනස්තස්මින් ස්ථානේ ස්ථිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","යීශුස්තං ශයිතං දෘෂ්ට්වා බහුකාලිකරෝගීති ඥාත්වා ව්‍යාහෘතවාන් ත්වං කිං ස්වස්ථෝ බුභූෂසි? ");
INSERT INTO sansin_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","තතෝ රෝගී කථිතවාන් හේ මහේච්ඡ යදා කීලාලං කම්පතේ තදා මාං පුෂ්කරිණීම් අවරෝහයිතුං මම කෝපි නාස්ති, තස්මාන් මම ගමනකාලේ කශ්චිදන්‍යෝ(අ)ග්‍රෝ ගත්වා අවරෝහති| ");
INSERT INTO sansin_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","තදා යීශුරකථයද් උත්තිෂ්ඨ, තව ශය්‍යාමුත්තෝල්‍ය ගෘහීත්වා යාහි| ");
INSERT INTO sansin_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","ස තත්ක්‍ෂණාත් ස්වස්ථෝ භූත්වා ශය්‍යාමුත්තෝල්‍යාදාය ගතවාන් කින්තු තද්දිනං විශ්‍රාමවාරඃ| ");
INSERT INTO sansin_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","තස්මාද් යිහූදීයාඃ ස්වස්ථං නරං ව්‍යාහරන් අද්‍ය විශ්‍රාමවාරේ ශයනීයමාදාය න යාතව්‍යම්| ");
INSERT INTO sansin_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","තතඃ ස ප්‍රත්‍යවෝචද් යෝ මාං ස්වස්ථම් අකාර්ෂීත් ශයනීයම් උත්තෝල්‍යාදාය යාතුං මාං ස ඒවාදිශත්| ");
INSERT INTO sansin_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","තදා තේ(අ)පෘච්ඡන් ශයනීයම් උත්තෝල්‍යාදාය යාතුං ය ආඥාපයත් ස කඃ? ");
INSERT INTO sansin_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","කින්තු ස ක ඉති ස්වස්ථීභූතෝ නාජානාද් යතස්තස්මින් ස්ථානේ ජනතාසත්ත්වාද් යීශුඃ ස්ථානාන්තරම් ආගමත්| ");
INSERT INTO sansin_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","තතඃ පරං යේශු ර්මන්දිරේ තං නරං සාක්‍ෂාත්ප්‍රාප්‍යාකථයත් පශ්‍යේදානීම් අනාමයෝ ජාතෝසි යථාධිකා දුර්දශා න ඝටතේ තද්ධේතෝඃ පාපං කර්ම්ම පුනර්මාකාර්ෂීඃ| ");
INSERT INTO sansin_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","තතඃ ස ගත්වා යිහූදීයාන් අවදද් යීශු ර්මාම් අරෝගිණම් අකාර්ෂීත්| ");
INSERT INTO sansin_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","තතෝ යීශු ර්විශ්‍රාමවාරේ කර්ම්මේදෘශං කෘතවාන් ඉති හේතෝ ර‍්‍යිහූදීයාස්තං තාඩයිත්වා හන්තුම් අචේෂ්ටන්ත| ");
INSERT INTO sansin_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","යීශුස්තානාඛ්‍යත් මම පිතා යත් කාර‍්‍ය්‍යං කරෝති තදනුරූපම් අහමපි කරෝති| ");
INSERT INTO sansin_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","තතෝ යිහූදීයාස්තං හන්තුං පුනරයතන්ත යතෝ විශ්‍රාමවාරං නාමන්‍යත තදේව කේවලං න අධිකන්තු ඊශ්වරං ස්වපිතරං ප්‍රෝච්‍ය ස්වමපීශ්වරතුල්‍යං කෘතවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","පශ්චාද් යීශුරවදද් යුෂ්මානහං යථාර්ථතරං වදාමි පුත්‍රඃ පිතරං යද්‍යත් කර්ම්ම කුර්ව්වන්තං පශ්‍යති තදතිරික්තං ස්වේච්ඡාතඃ කිමපි කර්ම්ම කර්ත්තුං න ශක්නෝති| පිතා යත් කරෝති පුත්‍රෝපි තදේව කරෝති| ");
INSERT INTO sansin_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","පිතා පුත්‍රේ ස්නේහං කරෝති තස්මාත් ස්වයං යද්‍යත් කර්ම්ම කරෝති තත්සර්ව්වං පුත්‍රං දර්ශයති ; යථා ච යුෂ්මාකං ආශ්චර‍්‍ය්‍යඥානං ජනිෂ්‍යතේ තදර්ථම් ඉතෝපි මහාකර්ම්ම තං දර්ශයිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","වස්තුතස්තු පිතා යථා ප්‍රමිතාන් උත්ථාප්‍ය සජිවාන් කරෝති තද්වත් පුත්‍රෝපි යං යං ඉච්ඡති තං තං සජීවං කරෝති| ");
INSERT INTO sansin_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","සර්ව්වේ පිතරං යථා සත්කුර්ව්වන්ති තථා පුත්‍රමපි සත්කාරයිතුං පිතා ස්වයං කස්‍යාපි විචාරමකෘත්වා සර්ව්වවිචාරාණාං භාරං පුත්‍රේ සමර්පිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","යඃ පුත්‍රං සත් කරෝති ස තස්‍ය ප්‍රේරකමපි සත් කරෝති| ");
INSERT INTO sansin_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","යුෂ්මානාහං යථාර්ථතරං වදාමි යෝ ජනෝ මම වාක්‍යං ශ්‍රුත්වා මත්ප්‍රේරකේ විශ්වසිති සෝනන්තායුඃ ප්‍රාප්නෝති කදාපි දණ්ඩබාජනං න භවති නිධනාදුත්ථාය පරමායුඃ ප්‍රාප්නෝති| ");
INSERT INTO sansin_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","අහං යුෂ්මානතියථාර්ථං වදාමි යදා මෘතා ඊශ්වරපුත්‍රස්‍ය නිනාදං ශ්‍රෝෂ්‍යන්ති යේ ච ශ්‍රෝෂ්‍යන්ති තේ සජීවා භවිෂ්‍යන්ති සමය ඒතාදෘශ ආයාති වරම් ඉදානීමප්‍යුපතිෂ්ඨති| ");
INSERT INTO sansin_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","පිතා යථා ස්වයඤ්ජීවී තථා පුත්‍රාය ස්වයඤ්ජීවිත්වාධිකාරං දත්තවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ස මනුෂ්‍යපුත්‍රඃ ඒතස්මාත් කාරණාත් පිතා දණ්ඩකරණාධිකාරමපි තස්මින් සමර්පිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","ඒතදර්ථේ යූයම් ආශ්චර‍්‍ය්‍යං න මන්‍යධ්වං යතෝ යස්මින් සමයේ තස්‍ය නිනාදං ශ්‍රුත්වා ශ්මශානස්ථාඃ සර්ව්වේ බහිරාගමිෂ්‍යන්ති සමය ඒතාදෘශ උපස්ථාස්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","තස්මාද් යේ සත්කර්ම්මාණි කෘතවන්තස්ත උත්ථාය ආයුඃ ප්‍රාප්ස්‍යන්ති යේ ච කුකර්මාණි කෘතවන්තස්ත උත්ථාය දණ්ඩං ප්‍රාප්ස්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","අහං ස්වයං කිමපි කර්ත්තුං න ශක්නෝමි යථා ශුණෝමි තථා විචාරයාමි මම විචාරඤ්ච න්‍යාය්‍යඃ යතෝහං ස්වීයාභීෂ්ටං නේහිත්වා මත්ප්‍රේරයිතුඃ පිතුරිෂ්ටම් ඊහේ| ");
INSERT INTO sansin_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","යදි ස්වස්මින් ස්වයං සාක්‍ෂ්‍යං දදාමි තර්හි තත්සාක්‍ෂ්‍යම් ආග්‍රාහ්‍යං භවති ; ");
INSERT INTO sansin_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","කින්තු මදර්ථේ(අ)පරෝ ජනඃ සාක්‍ෂ්‍යං දදාති මදර්ථේ තස්‍ය යත් සාක්‍ෂ්‍යං තත් සත්‍යම් ඒතදප්‍යහං ජානාමි| ");
INSERT INTO sansin_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","යුෂ්මාභි ර‍්‍යෝහනං ප්‍රති ලෝකේෂු ප්‍රේරිතේෂු ස සත්‍යකථායාං සාක්‍ෂ්‍යමදදාත්| ");
INSERT INTO sansin_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","මානුෂාදහං සාක්‍ෂ්‍යං නෝපේක්‍ෂේ තථාපි යූයං යථා පරිත්‍රයධ්වේ තදර්ථම් ඉදං වාක්‍යං වදාමි| ");
INSERT INTO sansin_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","යෝහන් දේදීප්‍යමානෝ දීප ඉව තේජස්වී ස්ථිතවාන් යූයම් අල්පකාලං තස්‍ය දීප්ත්‍යානන්දිතුං සමමන්‍යධ්වං| ");
INSERT INTO sansin_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","කින්තු තත්ප්‍රමාණාදපි මම ගුරුතරං ප්‍රමාණං විද්‍යතේ පිතා මාං ප්‍රේෂ්‍ය යද්‍යත් කර්ම්ම සමාපයිතුං ශක්ත්තිමදදාත් මයා කෘතං තත්තත් කර්ම්ම මදර්ථේ ප්‍රමාණං දදාති| ");
INSERT INTO sansin_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","යඃ පිතා මාං ප්‍රේරිතවාන් මෝපි මදර්ථේ ප්‍රමාණං දදාති| තස්‍ය වාක්‍යං යුෂ්මාභිඃ කදාපි න ශ්‍රුතං තස්‍ය රූපඤ්ච න දෘෂ්ටං ");
INSERT INTO sansin_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","තස්‍ය වාක්‍යඤ්ච යුෂ්මාකම් අන්තඃ කදාපි ස්ථානං නාප්නෝති යතඃ ස යං ප්‍රේෂිතවාන් යූයං තස්මින් න විශ්වසිථ| ");
INSERT INTO sansin_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","ධර්ම්මපුස්තකානි යූයම් ආලෝචයධ්වං තෛ ර්වාක්‍යෛරනන්තායුඃ ප්‍රාප්ස්‍යාම ඉති යූයං බුධ්‍යධ්වේ තද්ධර්ම්මපුස්තකානි මදර්ථේ ප්‍රමාණං දදති| ");
INSERT INTO sansin_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","තථාපි යූයං පරමායුඃප්‍රාප්තයේ මම සංනිධිම් න ජිගමිෂථ| ");
INSERT INTO sansin_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","අහං මානුෂේභ්‍යඃ සත්කාරං න ගෘහ්ලාමි| ");
INSERT INTO sansin_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","අහං යුෂ්මාන් ජානාමි; යුෂ්මාකමන්තර ඊශ්වරප්‍රේම නාස්ති| ");
INSERT INTO sansin_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","අහං නිජපිතු ර්නාම්නාගතෝස්මි තථාපි මාං න ගෘහ්ලීථ කින්තු කශ්චිද් යදි ස්වනාම්නා සමාගමිෂ්‍යති තර්හි තං ග්‍රහීෂ්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","යූයම් ඊශ්වරාත් සත්කාරං න චිෂ්ටත්වා කේවලං පරස්පරං සත්කාරම් චේද් ආදධ්ව්වේ තර්හි කථං විශ්වසිතුං ශක්නුථ? ");
INSERT INTO sansin_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","පුතුඃ සමීපේ(අ)හං යුෂ්මාන් අපවදිෂ්‍යාමීති මා චින්තයත යස්මින් , යස්මින් යුෂ්මාකං විශ්වසඃ සඒව මූසා යුෂ්මාන් අපවදති| ");
INSERT INTO sansin_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","යදි යූයං තස්මින් ව්‍යශ්වසිෂ්‍යත තර්හි මය්‍යපි ව්‍යශ්වසිෂ්‍යත, යත් ස මයි ලිඛිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","තතෝ යදි තේන ලිඛිතවානි න ප්‍රතිථ තර්හි මම වාක්‍යානි කථං ප්‍රත්‍යේෂ්‍යථ? ");
INSERT INTO sansin_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","තතඃ පරං යීශු ර්ගාලීල් ප්‍රදේශීයස්‍ය තිවිරියානාම්නඃ සින්ධෝඃ පාරං ගතවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","තතෝ ව්‍යාධිමල්ලෝකස්වාස්ථ්‍යකරණරූපාණි තස්‍යාශ්චර‍්‍ය්‍යාණි කර්ම්මාණි දෘෂ්ට්වා බහවෝ ජනාස්තත්පශ්චාද් අගච්ඡන්| ");
INSERT INTO sansin_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","තතෝ යීශුඃ පර්ව්වතමාරුහ්‍ය තත්‍ර ශිෂ්‍යෛඃ සාකම්| ");
INSERT INTO sansin_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","තස්මින් සමය නිස්තාරෝත්සවනාම්නි යිහූදීයානාම උත්සව උපස්ථිතේ ");
INSERT INTO sansin_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","යීශු ර්නේත්‍රේ උත්තෝල්‍ය බහුලෝකාන් ස්වසමීපාගතාන් විලෝක්‍ය ඵිලිපං පෘෂ්ටවාන් ඒතේෂාං භෝජනාය භෝජද්‍රව්‍යාණි වයං කුත්‍ර ක්‍රේතුං ශක්‍රුමඃ? ");
INSERT INTO sansin_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","වාක්‍යමිදං තස්‍ය පරීක්‍ෂාර්ථම් අවාදීත් කින්තු යත් කරිෂ්‍යති තත් ස්වයම් අජානාත්| ");
INSERT INTO sansin_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ඵිලිපඃ ප්‍රත්‍යවෝචත් ඒතේෂාම් ඒකෛකෝ යද්‍යල්පම් අල්පං ප්‍රාප්නෝති තර්හි මුද්‍රාපාදද්විශතේන ක්‍රීතපූපා අපි න්‍යූනා භවිෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ශිමෝන් පිතරස්‍ය භ්‍රාතා ආන්ද්‍රියාඛ්‍යඃ ශිෂ්‍යාණාමේකෝ ව්‍යාහෘතවාන් ");
INSERT INTO sansin_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","අත්‍ර කස්‍යචිද් බාලකස්‍ය සමීපේ පඤ්ච යාවපූපාඃ ක්‍ෂුද්‍රමත්ස්‍යද්වයඤ්ච සන්ති කින්තු ලෝකානාං ඒතාවාතාං මධ්‍යේ තෛඃ කිං භවිෂ්‍යති? ");
INSERT INTO sansin_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","පශ්චාද් යීශුරවදත් ලෝකානුපවේශයත තත්‍ර බහුයවසසත්ත්වාත් පඤ්චසහස්ත්‍රේභ්‍යෝ න්‍යූනා අධිකා වා පුරුෂා භූම්‍යාම් උපාවිශන්| ");
INSERT INTO sansin_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","තතෝ යීශුස්තාන් පූපානාදාය ඊශ්වරස්‍ය ගුණාන් කීර්ත්තයිත්වා ශිෂ්‍යේෂු සමාර්පයත් තතස්තේ තේභ්‍ය උපවිෂ්ටලෝකේභ්‍යඃ පූපාන් යථේෂ්ටමත්ස්‍යඤ්ච ප්‍රාදුඃ| ");
INSERT INTO sansin_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","තේෂු තෘප්තේෂු ස තානවෝචද් ඒතේෂාං කිඤ්චිදපි යථා නාපචීයතේ තථා සර්ව්වාණ්‍යවශිෂ්ටානි සංගෘහ්ලීත| ");
INSERT INTO sansin_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","තතඃ සර්ව්වේෂාං භෝජනාත් පරං තේ තේෂාං පඤ්චානාං යාවපූපානාං අවශිෂ්ටාන්‍යඛිලානි සංගෘහ්‍ය ද්වාදශඩල්ලකාන් අපූරයන්| ");
INSERT INTO sansin_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","අපරං යීශෝරේතාදෘශීම් ආශ්චර‍්‍ය්‍යක්‍රියාං දෘෂ්ට්වා ලෝකා මිථෝ වක්තුමාරේභිරේ ජගති යස්‍යාගමනං භවිෂ්‍යති ස ඒවායම් අවශ්‍යං භවිෂ්‍යද්වක්ත්තා| ");
INSERT INTO sansin_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","අතඒව ලෝකා ආගත්‍ය තමාක්‍රම්‍ය රාජානං කරිෂ්‍යන්ති යීශුස්තේෂාම් ඊදෘශං මානසං විඥාය පුනශ්ච පර්ව්වතම් ඒකාකී ගතවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","සායංකාල උපස්ථිතේ ශිෂ්‍යා ජලධිතටං ව්‍රජිත්වා නාවමාරුහ්‍ය නගරදිශි සින්ධෞ වාහයිත්වාගමන්| ");
INSERT INTO sansin_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","තස්මින් සමයේ තිමිර උපාතිෂ්ඨත් කින්තු යීෂුස්තේෂාං සමීපං නාගච්ඡත්| ");
INSERT INTO sansin_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","තදා ප්‍රබලපවනවහනාත් සාගරේ මහාතරඞ්ගෝ භවිතුම් ආරේභේ| ");
INSERT INTO sansin_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","තතස්තේ වාහයිත්වා ද්විත්‍රාන් ක්‍රෝශාන් ගතාඃ පශ්චාද් යීශුං ජලධේරුපරි පද්භ්‍යාං ව්‍රජන්තං නෞකාන්තිකම් ආගච්ඡන්තං විලෝක්‍ය ත්‍රාසයුක්තා අභවන් ");
INSERT INTO sansin_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","කින්තු ස තානුක්ත්තවාන් අයමහං මා භෛෂ්ට| ");
INSERT INTO sansin_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","තදා තේ තං ස්වෛරං නාවි ගෘහීතවන්තඃ තදා තත්ක්‍ෂණාද් උද්දිෂ්ටස්ථානේ නෞරුපාස්ථාත්| ");
INSERT INTO sansin_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","යයා නාවා ශිෂ්‍යා අගච්ඡන් තදන්‍යා කාපි නෞකා තස්මින් ස්ථානේ නාසීත් තතෝ යීශුඃ ශිෂ්‍යෛඃ සාකං නාගමත් කේවලාඃ ශිෂ්‍යා අගමන් ඒතත් පාරස්ථා ලෝකා ඥාතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","කින්තු තතඃ පරං ප්‍රභු ර‍්‍යත්‍ර ඊශ්වරස්‍ය ගුණාන් අනුකීර්ත්ත්‍ය ලෝකාන් පූපාන් අභෝජයත් තත්ස්ථානස්‍ය සමීපස්ථතිවිරියායා අපරාස්තරණය ආගමන්| ");
INSERT INTO sansin_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","යීශුස්තත්‍ර නාස්ති ශිෂ්‍යා අපි තත්‍ර නා සන්ති ලෝකා ඉති විඥාය යීශුං ගවේෂයිතුං තරණිභිඃ කඵර්නාහූම් පුරං ගතාඃ| ");
INSERT INTO sansin_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","තතස්තේ සරිත්පතේඃ පාරේ තං සාක්‍ෂාත් ප්‍රාප්‍ය ප්‍රාවෝචන් හේ ගුරෝ භවාන් අත්‍ර ස්ථානේ කදාගමත්? ");
INSERT INTO sansin_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","තදා යීශුස්තාන් ප්‍රත්‍යවාදීද් යුෂ්මානහං යථාර්ථතරං වදාමි ආශ්චර‍්‍ය්‍යකර්ම්මදර්ශනාද්ධේතෝ ර්න කින්තු පූපභෝජනාත් තේන තෘප්තත්වාඤ්ච මාං ගවේෂයථ| ");
INSERT INTO sansin_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ක්‍ෂයණීයභක්‍ෂ්‍යාර්ථං මා ශ්‍රාමිෂ්ට කින්ත්වන්තායුර්භක්‍ෂ්‍යාර්ථං ශ්‍රාම්‍යත, තස්මාත් තාදෘශං භක්‍ෂ්‍යං මනුජපුත්‍රෝ යුෂ්මාභ්‍යං දාස්‍යති; තස්මින් තාත ඊශ්වරඃ ප්‍රමාණං ප්‍රාදාත්| ");
INSERT INTO sansin_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","තදා තේ(අ)පෘච්ඡන් ඊශ්වරාභිමතං කර්ම්ම කර්ත්තුම් අස්මාභිඃ කිං කර්ත්තව්‍යං? ");
INSERT INTO sansin_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","තතෝ යීශුරවදද් ඊශ්වරෝ යං ප්‍රෛරයත් තස්මින් විශ්වසනම් ඊශ්වරාභිමතං කර්ම්ම| ");
INSERT INTO sansin_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","තදා තේ ව්‍යාහරන් භවතා කිං ලක්‍ෂණං දර්ශිතං යද්දෘෂ්ට්වා භවති විශ්වසිෂ්‍යාමඃ? ත්වයා කිං කර්ම්ම කෘතං? ");
INSERT INTO sansin_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","අස්මාකං පූර්ව්වපුරුෂා මහාප්‍රාන්තරේ මාන්නාං භෝක්ත්තුං ප්‍රාපුඃ යථා ලිපිරාස්තේ| ස්වර්ගීයාණි තු භක්‍ෂ්‍යාණි ප්‍රදදෞ පරමේශ්වරඃ| ");
INSERT INTO sansin_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","තදා යීශුරවදද් අහං යුෂ්මානතියථාර්ථං වදාමි මූසා යුෂ්මාභ්‍යං ස්වර්ගීයං භක්‍ෂ්‍යං නාදාත් කින්තු මම පිතා යුෂ්මාභ්‍යං ස්වර්ගීයං පරමං භක්‍ෂ්‍යං දදාති| ");
INSERT INTO sansin_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","යඃ ස්වර්ගාදවරුහ්‍ය ජගතේ ජීවනං දදාති ස ඊශ්වරදත්තභක්‍ෂ්‍යරූපඃ| ");
INSERT INTO sansin_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","තදා තේ ප්‍රාවෝචන් හේ ප්‍රභෝ භක්‍ෂ්‍යමිදං නිත්‍යමස්මභ්‍යං දදාතු| ");
INSERT INTO sansin_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","යීශුරවදද් අහමේව ජීවනරූපං භක්‍ෂ්‍යං යෝ ජනෝ මම සන්නිධිම් ආගච්ඡති ස ජාතු ක්‍ෂුධාර්ත්තෝ න භවිෂ්‍යති, තථා යෝ ජනෝ මාං ප්‍රත්‍යේති ස ජාතු තෘෂාර්ත්තෝ න භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","මාං දෘෂ්ට්වාපි යූයං න විශ්වසිථ යුෂ්මානහම් ඉත්‍යවෝචං| ");
INSERT INTO sansin_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","පිතා මහ්‍යං යාවතෝ ලෝකානදදාත් තේ සර්ව්ව ඒව මමාන්තිකම් ආගමිෂ්‍යන්ති යඃ කශ්චිච්ච මම සන්නිධිම් ආයාස්‍යති තං කේනාපි ප්‍රකාරේණ න දූරීකරිෂ්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","නිජාභිමතං සාධයිතුං න හි කින්තු ප්‍රේරයිතුරභිමතං සාධයිතුං ස්වර්ගාද් ආගතෝස්මි| ");
INSERT INTO sansin_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ස යාන් යාන් ලෝකාන් මහ්‍යමදදාත් තේෂාමේකමපි න හාරයිත්වා ශේෂදිනේ සර්ව්වානහම් උත්ථාපයාමි ඉදං මත්ප්‍රේරයිතුඃ පිතුරභිමතං| ");
INSERT INTO sansin_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","යඃ කශ්චින් මානවසුතං විලෝක්‍ය විශ්වසිති ස ශේෂදිනේ මයෝත්ථාපිතඃ සන් අනන්තායුඃ ප්‍රාප්ස්‍යති ඉති මත්ප්‍රේරකස්‍යාභිමතං| ");
INSERT INTO sansin_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","තදා ස්වර්ගාද් යද් භක්‍ෂ්‍යම් අවාරෝහත් තද් භක්‍ෂ්‍යම් අහමේව යිහූදීයලෝකාස්තස්‍යෛතද් වාක්‍යේ විවදමානා වක්ත්තුමාරේභිරේ ");
INSERT INTO sansin_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","යූෂඵඃ පුත්‍රෝ යීශු ර‍්‍යස්‍ය මාතාපිතරෞ වයං ජානීම ඒෂ කිං සඒව න? තර්හි ස්වර්ගාද් අවාරෝහම් ඉති වාක්‍යං කථං වක්ත්ති? ");
INSERT INTO sansin_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","තදා යීශුස්තාන් ප්‍රත්‍යවදත් පරස්පරං මා විවදධ්වං ");
INSERT INTO sansin_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","මත්ප්‍රේරකේණ පිත්‍රා නාකෘෂ්ටඃ කෝපි ජනෝ මමාන්තිකම් ආයාතුං න ශක්නෝති කින්ත්වාගතං ජනං චරමේ(අ)හ්නි ප්‍රෝත්ථාපයිෂ්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","තේ සර්ව්ව ඊශ්වරේණ ශික්‍ෂිතා භවිෂ්‍යන්ති භවිෂ්‍යද්වාදිනාං ග්‍රන්ථේෂු ලිපිරිත්ථමාස්තේ අතෝ යඃ කශ්චිත් පිතුඃ සකාශාත් ශ්‍රුත්වා ශික්‍ෂතේ ස ඒව මම සමීපම් ආගමිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ය ඊශ්වරාද් අජායත තං විනා කෝපි මනුෂ්‍යෝ ජනකං නාදර්ශත් කේවලඃ සඒව තාතම් අද්‍රාක්‍ෂීත්| ");
INSERT INTO sansin_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","අහං යුෂ්මාන් යථාර්ථතරං වදාමි යෝ ජනෝ මයි විශ්වාසං කරෝති සෝනන්තායුඃ ප්‍රාප්නෝති| ");
INSERT INTO sansin_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","අහමේව තජ්ජීවනභක්‍ෂ්‍යං| ");
INSERT INTO sansin_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","යුෂ්මාකං පූර්ව්වපුරුෂා මහාප්‍රාන්තරේ මන්නාභක්‍ෂ්‍යං භූක්ත්තාපි මෘතාඃ ");
INSERT INTO sansin_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","කින්තු යද්භක්‍ෂ්‍යං ස්වර්ගාදාගච්ඡත් තද් යදි කශ්චිද් භුඞ්ක්ත්තේ තර්හි ස න ම්‍රියතේ| ");
INSERT INTO sansin_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","යජ්ජීවනභක්‍ෂ්‍යං ස්වර්ගාදාගච්ඡත් සෝහමේව ඉදං භක්‍ෂ්‍යං යෝ ජනෝ භුඞ්ක්ත්තේ ස නිත්‍යජීවී භවිෂ්‍යති| පුනශ්ච ජගතෝ ජීවනාර්ථමහං යත් ස්වකීයපිශිතං දාස්‍යාමි තදේව මයා විතරිතං භක්‍ෂ්‍යම්| ");
INSERT INTO sansin_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","තස්මාද් යිහූදීයාඃ පරස්පරං විවදමානා වක්ත්තුමාරේභිරේ ඒෂ භෝජනාර්ථං ස්වීයං පලලං කථම් අස්මභ්‍යං දාස්‍යති? ");
INSERT INTO sansin_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","තදා යීශුස්තාන් ආවෝචද් යුෂ්මානහං යථාර්ථතරං වදාමි මනුෂ්‍යපුත්‍රස්‍යාමිෂේ යුෂ්මාභි ර්න භුක්ත්තේ තස්‍ය රුධිරේ ච න පීතේ ජීවනේන සාර්ද්ධං යුෂ්මාකං සම්බන්ධෝ නාස්ති| ");
INSERT INTO sansin_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","යෝ මමාමිෂං ස්වාදති මම සුධිරඤ්ච පිවති සෝනන්තායුඃ ප්‍රාප්නෝති තතඃ ශේෂේ(අ)හ්නි තමහම් උත්ථාපයිෂ්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","යතෝ මදීයමාමිෂං පරමං භක්‍ෂ්‍යං තථා මදීයං ශෝණිතං පරමං පේයං| ");
INSERT INTO sansin_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","යෝ ජනෝ මදීයං පලලං ස්වාදති මදීයං රුධිරඤ්ච පිවති ස මයි වසති තස්මින්නහඤ්ච වසාමි| ");
INSERT INTO sansin_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","මත්ප්‍රේරයිත්‍රා ජීවතා තාතේන යථාහං ජීවාමි තද්වද් යඃ කශ්චින් මාමත්ති සෝපි මයා ජීවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","යද්භක්‍ෂ්‍යං ස්වර්ගාදාගච්ඡත් තදිදං යන්මාන්නාං ස්වාදිත්වා යුෂ්මාකං පිතරෝ(අ)ම්‍රියන්ත තාදෘශම් ඉදං භක්‍ෂ්‍යං න භවති ඉදං භක්‍ෂ්‍යං යෝ භක්‍ෂති ස නිත්‍යං ජීවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","යදා කඵර්නාහූම් පුර‍්‍ය්‍යාං භජනගේහේ උපාදිශත් තදා කථා ඒතා අකථයත්| ");
INSERT INTO sansin_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","තදේත්ථං ශ්‍රුත්වා තස්‍ය ශිෂ්‍යාණාම් අනේකේ පරස්පරම් අකථයන් ඉදං ගාඪං වාක්‍යං වාක්‍යමීදෘශං කඃ ශ්‍රෝතුං ශක්‍රුයාත්? ");
INSERT INTO sansin_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","කින්තු යීශුඃ ශිෂ්‍යාණාම් ඉත්ථං විවාදං ස්වචිත්තේ විඥාය කථිතවාන් ඉදං වාක්‍යං කිං යුෂ්මාකං විඝ්නං ජනයති? ");
INSERT INTO sansin_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","යදි මනුජසුතං පූර්ව්වවාසස්ථානම් ඌර්ද්ව්වං ගච්ඡන්තං පශ්‍යථ තර්හි කිං භවිෂ්‍යති? ");
INSERT INTO sansin_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","ආත්මෛව ජීවනදායකඃ වපු ර්නිෂ්ඵලං යුෂ්මභ්‍යමහං යානි වචාංසි කථයාමි තාන්‍යාත්මා ජීවනඤ්ච| ");
INSERT INTO sansin_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","කින්තු යුෂ්මාකං මධ්‍යේ කේචන අවිශ්වාසිනඃ සන්ති කේ කේ න විශ්වසන්ති කෝ වා තං පරකරේෂු සමර්පයිෂ්‍යති තාන් යීශුරාප්‍රථමාද් වේත්ති| ");
INSERT INTO sansin_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","අපරමපි කථිතවාන් අස්මාත් කාරණාද් අකථයං පිතුඃ සකාශාත් ශක්ත්තිමප්‍රාප්‍ය කෝපි මමාන්තිකම් ආගන්තුං න ශක්නෝති| ");
INSERT INTO sansin_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","තත්කාලේ(අ)නේකේ ශිෂ්‍යා ව්‍යාඝුට්‍ය තේන සාර්ද්ධං පුන ර්නාගච්ඡන්| ");
INSERT INTO sansin_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","තදා යීශු ර්ද්වාදශශිෂ්‍යාන් උක්ත්තවාන් යූයමපි කිං යාස්‍යථ? ");
INSERT INTO sansin_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","තතඃ ශිමෝන් පිතරඃ ප්‍රත්‍යවෝචත් හේ ප්‍රභෝ කස්‍යාභ්‍යර්ණං ගමිෂ්‍යාමඃ? ");
INSERT INTO sansin_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","අනන්තජීවනදායින්‍යෝ යාඃ කථාස්තාස්තවෛව| භවාන් අමරේශ්වරස්‍යාභිෂික්ත්තපුත්‍ර ඉති විශ්වස්‍ය නිශ්චිතං ජානීමඃ| ");
INSERT INTO sansin_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","තදා යීශුරවදත් කිමහං යුෂ්මාකං ද්වාදශජනාන් මනෝනීතාන් න කෘතවාන්? කින්තු යුෂ්මාකං මධ්‍යේපි කශ්චිදේකෝ විඝ්නකාරී විද්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ඉමාං කථං ස ශිමෝනඃ පුත්‍රම් ඊෂ්කරීයෝතීයං යිහූදාම් උද්දිශ්‍ය කථිතවාන් යතෝ ද්වාදශානාං මධ්‍යේ ගණිතඃ ස තං පරකරේෂු සමර්පයිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","තතඃ පරං යිහූදීයලෝකාස්තං හන්තුං සමෛහන්ත තස්මාද් යීශු ර‍්‍යිහූදාප්‍රදේශේ පර‍්‍ය්‍යටිතුං නේච්ඡන් ගාලීල් ප්‍රදේශේ පර‍්‍ය්‍යටිතුං ප්‍රාරභත| ");
INSERT INTO sansin_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","කින්තු තස්මින් සමයේ යිහූදීයානාං දූෂ්‍යවාසනාමෝත්සව උපස්ථිතේ ");
INSERT INTO sansin_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","තස්‍ය භ්‍රාතරස්තම් අවදන් යානි කර්ම්මාණි ත්වයා ක්‍රියන්තේ තානි යථා තව ශිෂ්‍යාඃ පශ්‍යන්ති තදර්ථං ත්වමිතඃ ස්ථානාද් යිහූදීයදේශං ව්‍රජ| ");
INSERT INTO sansin_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","යඃ කශ්චිත් ස්වයං ප්‍රචිකාශිෂති ස කදාපි ගුප්තං කර්ම්ම න කරෝති යදීදෘශං කර්ම්ම කරෝෂි තර්හි ජගති නිජං පරිචායය| ");
INSERT INTO sansin_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","යතස්තස්‍ය භ්‍රාතරෝපි තං න විශ්වසන්ති| ");
INSERT INTO sansin_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","තදා යීශුස්තාන් අවෝචත් මම සමය ඉදානීං නෝපතිෂ්ඨති කින්තු යුෂ්මාකං සමයඃ සතතම් උපතිෂ්ඨති| ");
INSERT INTO sansin_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","ජගතෝ ලෝකා යුෂ්මාන් ඍතීයිතුං න ශක්‍රුවන්ති කින්තු මාමේව ඍතීයන්තේ යතස්තේෂාං කර්මාණි දුෂ්ටානි තත්‍ර සාක්‍ෂ්‍යමිදම් අහං දදාමි| ");
INSERT INTO sansin_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","අතඒව යූයම් උත්සවේ(අ)ස්මින් යාත නාහම් ඉදානීම් අස්මින්නුත්සවේ යාමි යතෝ මම සමය ඉදානීං න සම්පූර්ණඃ| ");
INSERT INTO sansin_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ඉති වාක්‍යම් උක්ත්ත්වා ස ගාලීලි ස්ථිතවාන් ");
INSERT INTO sansin_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","කින්තු තස්‍ය භ්‍රාතෘෂු තත්‍ර ප්‍රස්ථිතේෂු සත්සු සෝ(අ)ප්‍රකට උත්සවම් අගච්ඡත්| ");
INSERT INTO sansin_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","අනන්තරම් උත්සවම් උපස්ථිතා යිහූදීයාස්තං මෘගයිත්වාපෘච්ඡන් ස කුත්‍ර? ");
INSERT INTO sansin_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","තතෝ ලෝකානාං මධ්‍යේ තස්මින් නානාවිධා විවාදා භවිතුම් ආරබ්ධවන්තඃ| කේචිද් අවෝචන් ස උත්තමඃ පුරුෂඃ කේචිද් අවෝචන් න තථා වරං ලෝකානාං භ්‍රමං ජනයති| ");
INSERT INTO sansin_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","කින්තු යිහූදීයානාං භයාත් කෝපි තස්‍ය පක්‍ෂේ ස්පෂ්ටං නාකථයත්| ");
INSERT INTO sansin_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","තතඃ පරම් උත්සවස්‍ය මධ්‍යසමයේ යීශු ර්මන්දිරං ගත්වා සමුපදිශති ස්ම| ");
INSERT INTO sansin_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","තතෝ යිහූදීයා ලෝකා ආශ්චර‍්‍ය්‍යං ඥාත්වාකථයන් ඒෂා මානුෂෝ නාධීත්‍යා කථම් ඒතාදෘශෝ විද්වානභූත්? ");
INSERT INTO sansin_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","තදා යීශුඃ ප්‍රත්‍යවෝචද් උපදේශෝයං න මම කින්තු යෝ මාං ප්‍රේෂිතවාන් තස්‍ය| ");
INSERT INTO sansin_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","යෝ ජනෝ නිදේශං තස්‍ය ග්‍රහීෂ්‍යති මමෝපදේශෝ මත්තෝ භවති කිම් ඊශ්වරාද් භවති ස ගනස්තජ්ඥාතුං ශක්‍ෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","යෝ ජනඃ ස්වතඃ කථයති ස ස්වීයං ගෞරවම් ඊහතේ කින්තු යඃ ප්‍රේරයිතු ර්ගෞරවම් ඊහතේ ස සත්‍යවාදී තස්මින් කෝප්‍යධර්ම්මෝ නාස්ති| ");
INSERT INTO sansin_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","මූසා යුෂ්මභ්‍යං ව්‍යවස්ථාග්‍රන්ථං කිං නාදදාත්? කින්තු යුෂ්මාකං කෝපි තාං ව්‍යවස්ථාං න සමාචරති| මාං හන්තුං කුතෝ යතධ්වේ? ");
INSERT INTO sansin_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","තදා ලෝකා අවදන් ත්වං භූතග්‍රස්තස්ත්වාං හන්තුං කෝ යතතේ? ");
INSERT INTO sansin_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","තතෝ යීශුරවෝචද් ඒකං කර්ම්ම මයාකාරි තස්මාද් යූයං සර්ව්ව මහාශ්චර‍්‍ය්‍යං මන්‍යධ්වේ| ");
INSERT INTO sansin_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","මූසා යුෂ්මභ්‍යං ත්වක්ඡේදවිධිං ප්‍රදදෞ ස මූසාතෝ න ජාතඃ කින්තු පිතෘපුරුෂේභ්‍යෝ ජාතඃ තේන විශ්‍රාමවාරේ(අ)පි මානුෂාණාං ත්වක්ඡේදං කුරුථ| ");
INSERT INTO sansin_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","අතඒව විශ්‍රාමවාරේ මනුෂ්‍යාණාං ත්වක්ඡේදේ කෘතේ යදි මූසාව්‍යවස්ථාමඞ්ගනං න භවති තර්හි මයා විශ්‍රාමවාරේ මානුෂඃ සම්පූර්ණරූපේණ ස්වස්ථෝ(අ)කාරි තත්කාරණාද් යූයං කිං මහ්‍යං කුප්‍යථ? ");
INSERT INTO sansin_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","සපක්‍ෂපාතං විචාරමකෘත්වා න්‍යාය්‍යං විචාරං කුරුත| ");
INSERT INTO sansin_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","තදා යිරූශාලම් නිවාසිනඃ කතිපයජනා අකථයන් ඉමේ යං හන්තුං චේෂ්ටන්තේ ස ඒවායං කිං න? ");
INSERT INTO sansin_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","කින්තු පශ්‍යත නිර්භයඃ සන් කථාං කථයති තථාපි කිමපි අ වදන්ත්‍යේතේ අයමේවාභිෂික්ත්තෝ භවතීති නිශ්චිතං කිමධිපතයෝ ජානන්ති? ");
INSERT INTO sansin_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","මනුජෝයං කස්මාදාගමද් ඉති වයං ජානෝමඃ කින්ත්වභිෂික්ත්ත ආගතේ ස කස්මාදාගතවාන් ඉති කෝපි ඥාතුං න ශක්‍ෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","තදා යීශු ර්මධ්‍යේමන්දිරම් උපදිශන් උච්චෛඃකාරම් උක්ත්තවාන් යූයං කිං මාං ජානීථ? කස්මාච්චාගතෝස්මි තදපි කිං ජානීථ? නාහං ස්වත ආගතෝස්මි කින්තු යඃ සත්‍යවාදී සඒව මාං ප්‍රේෂිතවාන් යූයං තං න ජානීථ| ");
INSERT INTO sansin_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","තමහං ජානේ තේනාහං ප්‍රේරිත අගතෝස්මි| ");
INSERT INTO sansin_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","තස්මාද් යිහූදීයාස්තං ධර්ත්තුම් උද්‍යතාස්තථාපි කෝපි තස්‍ය ගාත්‍රේ හස්තං නාර්පයද් යතෝ හේතෝස්තදා තස්‍ය සමයෝ නෝපතිෂ්ඨති| ");
INSERT INTO sansin_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","කින්තු බහවෝ ලෝකාස්තස්මින් විශ්වස්‍ය කථිතවාන්තෝ(අ)භිෂික්ත්තපුරුෂ ආගත්‍ය මානුෂස්‍යාස්‍ය ක්‍රියාභ්‍යඃ කිම් අධිකා ආශ්චර‍්‍ය්‍යාඃ ක්‍රියාඃ කරිෂ්‍යති? ");
INSERT INTO sansin_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","තතඃ පරං ලෝකාස්තස්මින් ඉත්ථං විවදන්තේ ඵිරූශිනඃ ප්‍රධානයාජකාඤ්චේති ශ්‍රුතවන්තස්තං ධෘත්වා නේතුං පදාතිගණං ප්‍රේෂයාමාසුඃ| ");
INSERT INTO sansin_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","තතෝ යීශුරවදද් අහම් අල්පදිනානි යුෂ්මාභිඃ සාර්ද්ධං ස්ථිත්වා මත්ප්‍රේරයිතුඃ සමීපං යාස්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","මාං මෘගයිෂ්‍යධ්වේ කින්තූද්දේශං න ලප්ස්‍යධ්වේ රත්‍ර ස්ථාස්‍යාමි තත්‍ර යූයං ගන්තුං න ශක්‍ෂ්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","තදා යිහූදීයාඃ පරස්පරං වක්ත්තුමාරේභිරේ අස්‍යෝද්දේශං න ප්‍රාප්ස්‍යාම ඒතාදෘශං කිං ස්ථානං යාස්‍යති? භින්නදේශේ විකීර්ණානාං යිහූදීයානාං සන්නිධිම් ඒෂ ගත්වා තාන් උපදේක්‍ෂ්‍යති කිං? ");
INSERT INTO sansin_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","නෝ චේත් මාං ගවේෂයිෂ්‍යථ කින්තූද්දේශං න ප්‍රාප්ස්‍යථ ඒෂ කෝදෘශං වාක්‍යමිදං වදති? ");
INSERT INTO sansin_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","අනන්තරම් උත්සවස්‍ය චරමේ(අ)හනි අර්ථාත් ප්‍රධානදිනේ යීශුරුත්තිෂ්ඨන් උච්චෛඃකාරම් ආහ්වයන් උදිතවාන් යදි කශ්චිත් තෘෂාර්ත්තෝ භවති තර්හි මමාන්තිකම් ආගත්‍ය පිවතු| ");
INSERT INTO sansin_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","යඃ කශ්චින්මයි විශ්වසිති ධර්ම්මග්‍රන්ථස්‍ය වචනානුසාරේණ තස්‍යාභ්‍යන්තරතෝ(අ)මෘතතෝයස්‍ය ස්‍රෝතාංසි නිර්ගමිෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","යේ තස්මින් විශ්වසන්ති ත ආත්මානං ප්‍රාප්ස්‍යන්තීත්‍යර්ථේ ස ඉදං වාක්‍යං ව්‍යාහෘතවාන් ඒතත්කාලං යාවද් යීශු ර්විභවං න ප්‍රාප්තස්තස්මාත් පවිත්‍ර ආත්මා නාදීයත| ");
INSERT INTO sansin_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ඒතාං වාණීං ශ්‍රුත්වා බහවෝ ලෝකා අවදන් අයමේව නිශ්චිතං ස භවිෂ්‍යද්වාදී| ");
INSERT INTO sansin_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","කේචිද් අකථයන් ඒෂඒව සෝභිෂික්ත්තඃ කින්තු කේචිද් අවදන් සෝභිෂික්ත්තඃ කිං ගාලීල් ප්‍රදේශේ ජනිෂ්‍යතේ? ");
INSERT INTO sansin_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","සෝභිෂික්ත්තෝ දායූදෝ වංශේ දායූදෝ ජන්මස්ථානේ බෛත්ලේහමි පත්තනේ ජනිෂ්‍යතේ ධර්ම්මග්‍රන්ථේ කිමිත්ථං ලිඛිතං නාස්ති? ");
INSERT INTO sansin_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ඉත්ථං තස්මින් ලෝකානාං භින්නවාක්‍යතා ජාතා| ");
INSERT INTO sansin_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","කතිපයලෝකාස්තං ධර්ත්තුම් ඓච්ඡන් තථාපි තද්වපුෂි කෝපි හස්තං නාර්පයත්| ");
INSERT INTO sansin_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","අනන්තරං පාදාතිගණේ ප්‍රධානයාජකානාං ඵිරූශිනාඤ්ච සමීපමාගතවති තේ තාන් අපෘච්ඡන් කුතෝ හේතෝස්තං නානයත? ");
INSERT INTO sansin_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","තදා පදාතයඃ ප්‍රත්‍යවදන් ස මානව ඉව කෝපි කදාපි නෝපාදිශත්| ");
INSERT INTO sansin_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","තතඃ ඵිරූශිනඃ ප්‍රාවෝචන් යූයමපි කිමභ්‍රාමිෂ්ට? ");
INSERT INTO sansin_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","අධිපතීනාං ඵිරූශිනාඤ්ච කෝපි කිං තස්මින් ව්‍යශ්වසීත්? ");
INSERT INTO sansin_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","යේ ශාස්ත්‍රං න ජානන්ති ත ඉමේ(අ)ධමලෝකාඒව ශාපග්‍රස්තාඃ| ");
INSERT INTO sansin_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","තදා නිකදීමනාමා තේෂාමේකෝ යඃ ක්‍ෂණදායාං යීශෝඃ සන්නිධිම් අගාත් ස උක්ත්තවාන් ");
INSERT INTO sansin_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","තස්‍ය වාක්‍යේ න ශ්‍රුතේ කර්ම්මණි ච න විදිතේ (අ)ස්මාකං ව්‍යවස්ථා කිං කඤ්චන මනුජං දෝෂීකරෝති? ");
INSERT INTO sansin_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","තතස්තේ ව්‍යාහරන් ත්වමපි කිං ගාලීලීයලෝකඃ? විවිච්‍ය පශ්‍ය ගලීලි කෝපි භවිෂ්‍යද්වාදී නෝත්පද්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","තතඃ පරං සර්ව්වේ ස්වං ස්වං ගෘහං ගතාඃ කින්තු යීශු ර්ජෛතුනනාමානං ශිලෝච්චයං ගතවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ප්‍රත්‍යූෂේ යීශුඃ පනර්මන්දිරම් ආගච්ඡත් ");
INSERT INTO sansin_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","තතඃ සර්ව්වේෂු ලෝකේෂු තස්‍ය සමීප ආගතේෂු ස උපවිශ්‍ය තාන් උපදේෂ්ටුම් ආරභත| ");
INSERT INTO sansin_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","තදා අධ්‍යාපකාඃ ඵිරූශිනඤ්ච ව්‍යභිචාරකර්ම්මණි ධෘතං ස්ත්‍රියමේකාම් ආනිය සර්ව්වේෂාං මධ්‍යේ ස්ථාපයිත්වා ව්‍යාහරන් ");
INSERT INTO sansin_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","හේ ගුරෝ යෝෂිතම් ඉමාං ව්‍යභිචාරකර්ම්ම කුර්ව්වාණාං ලෝකා ධෘතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ඒතාදෘශලෝකාඃ පාෂාණාඝාතේන හන්තව්‍යා ඉති විධිර්මූසාව්‍යවස්ථාග්‍රන්ථේ ලිඛිතෝස්ති කින්තු භවාන් කිමාදිශති? ");
INSERT INTO sansin_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","තේ තමපවදිතුං පරීක්‍ෂාභිප්‍රායේණ වාක්‍යමිදම් අපෘච්ඡන් කින්තු ස ප්‍රහ්වීභූය භූමාවඞ්ගල්‍යා ලේඛිතුම් ආරභත| ");
INSERT INTO sansin_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","තතස්තෛඃ පුනඃ පුනඃ පෘෂ්ට උත්ථාය කථිතවාන් යුෂ්මාකං මධ්‍යේ යෝ ජනෝ නිරපරාධී සඒව ප්‍රථමම් ඒනාං පාෂාණේනාහන්තු| ");
INSERT INTO sansin_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","පශ්චාත් ස පුනශ්ච ප්‍රහ්වීභූය භූමෞ ලේඛිතුම් ආරභත| ");
INSERT INTO sansin_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","තාං කථං ශ්‍රුත්වා තේ ස්වස්වමනසි ප්‍රබෝධං ප්‍රාප්‍ය ජ්‍යේෂ්ඨානුක්‍රමං ඒකෛකශඃ සර්ව්වේ බහිරගච්ඡන් තතෝ යීශුරේකාකී තයක්ත්තෝභවත් මධ්‍යස්ථානේ දණ්ඩායමානා සා යෝෂා ච ස්ථිතා| ");
INSERT INTO sansin_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","තත්පශ්චාද් යීශුරුත්ථාය තාං වනිතාං විනා කමප්‍යපරං න විලෝක්‍ය පෘෂ්ටවාන් හේ වාමේ තවාපවාදකාඃ කුත්‍ර? කෝපි ත්වාං කිං න දණ්ඩයති? ");
INSERT INTO sansin_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","සාවදත් හේ මහේච්ඡ කෝපි න තදා යීශුරවෝචත් නාහමපි දණ්ඩයාමි යාහි පුනඃ පාපං මාකාර්ෂීඃ| ");
INSERT INTO sansin_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","තතෝ යීශුඃ පුනරපි ලෝකේභ්‍ය ඉත්ථං කථයිතුම් ආරභත ජගතෝහං ජ්‍යෝතිඃස්වරූපෝ යඃ කශ්චින් මත්පශ්චාද ගච්ඡති ස තිමිරේ න භ්‍රමිත්වා ජීවනරූපාං දීප්තිං ප්‍රාප්ස්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","තතඃ ඵිරූශිනෝ(අ)වාදිෂුස්ත්වං ස්වාර්ථේ ස්වයං සාක්‍ෂ්‍යං දදාසි තස්මාත් තව සාක්‍ෂ්‍යං ග්‍රාහ්‍යං න භවති| ");
INSERT INTO sansin_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","තදා යීශුඃ ප්‍රත්‍යුදිතවාන් යද්‍යපි ස්වාර්ථේ(අ)හං ස්වයං සාක්‍ෂ්‍යං දදාමි තථාපි මත් සාක්‍ෂ්‍යං ග්‍රාහ්‍යං යස්මාද් අහං කුත ආගතෝස්මි ක්ව යාමි ච තදහං ජානාමි කින්තු කුත ආගතෝස්මි කුත්‍ර ගච්ඡාමි ච තද් යූයං න ජානීථ| ");
INSERT INTO sansin_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","යූයං ලෞකිකං විචාරයථ නාහං කිමපි විචාරයාමි| ");
INSERT INTO sansin_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","කින්තු යදි විචාරයාමි තර්හි මම විචාරෝ ග්‍රහීතව්‍යෝ යතෝහම් ඒකාකී නාස්මි ප්‍රේරයිතා පිතා මයා සහ විද්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","ද්වයෝ ර්ජනයෝඃ සාක්‍ෂ්‍යං ග්‍රහණීයං භවතීති යුෂ්මාකං ව්‍යවස්ථාග්‍රන්ථේ ලිඛිතමස්ති| ");
INSERT INTO sansin_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","අහං ස්වාර්ථේ ස්වයං සාක්‍ෂිත්වං දදාමි යශ්ච මම තාතෝ මාං ප්‍රේරිතවාන් සෝපි මදර්ථේ සාක්‍ෂ්‍යං දදාති| ");
INSERT INTO sansin_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","තදා තේ(අ)පෘච්ඡන් තව තාතඃ කුත්‍ර? තතෝ යීශුඃ ප්‍රත්‍යවාදීද් යූයං මාං න ජානීථ මත්පිතරඤ්ච න ජානීථ යදි මාම් අක්‍ෂාස්‍යත තර්හි මම තාතමප්‍යක්‍ෂාස්‍යත| ");
INSERT INTO sansin_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","යීශු ර්මන්දිර උපදිශ්‍ය භණ්ඩාගාරේ කථා ඒතා අකථයත් තථාපි තං ප්‍රති කෝපි කරං නෝදතෝලයත්| ");
INSERT INTO sansin_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","තතඃ පරං යීශුඃ පුනරුදිතවාන් අධුනාහං ගච්ඡාමි යූයං මාං ගවේෂයිෂ්‍යථ කින්තු නිජෛඃ පාපෛ ර්මරිෂ්‍යථ යත් ස්ථානම් අහං යාස්‍යාමි තත් ස්ථානම් යූයං යාතුං න ශක්‍ෂ්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","තදා යිහූදීයාඃ ප්‍රාවෝචන් කිමයම් ආත්මඝාතං කරිෂ්‍යති? යතෝ යත් ස්ථානම් අහං යාස්‍යාමි තත් ස්ථානම් යූයං යාතුං න ශක්‍ෂ්‍යථ ඉති වාක්‍යං බ්‍රවීති| ");
INSERT INTO sansin_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","තතෝ යීශුස්තේභ්‍යඃ කථිතවාන් යූයම් අධඃස්ථානීයා ලෝකා අහම් ඌර්ද්ව්වස්ථානීයඃ යූයම් ඒතජ්ජගත්සම්බන්ධීයා අහම් ඒතජ්ජගත්සම්බන්ධීයෝ න| ");
INSERT INTO sansin_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","තස්මාත් කථිතවාන් යූයං නිජෛඃ පාපෛ ර්මරිෂ්‍යථ යතෝහං ස පුමාන් ඉති යදි න විශ්වසිථ තර්හි නිජෛඃ පාපෛ ර්මරිෂ්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","තදා තේ (අ)පෘච්ඡන් කස්ත්වං? තතෝ යීශුඃ කථිතවාන් යුෂ්මාකං සන්නිධෞ යස්‍ය ප්‍රස්තාවම් ආ ප්‍රථමාත් කරෝමි සඒව පුරුෂෝහං| ");
INSERT INTO sansin_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","යුෂ්මාසු මයා බහුවාක්‍යං වක්ත්තව්‍යං විචාරයිතව්‍යඤ්ච කින්තු මත්ප්‍රේරයිතා සත්‍යවාදී තස්‍ය සමීපේ යදහං ශ්‍රුතවාන් තදේව ජගතේ කථයාමි| ");
INSERT INTO sansin_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","කින්තු ස ජනකේ වාක්‍යමිදං ප්‍රෝක්ත්තවාන් ඉති තේ නාබුධ්‍යන්ත| ");
INSERT INTO sansin_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","තතෝ යීශුරකථයද් යදා මනුෂ්‍යපුත්‍රම් ඌර්ද්ව්ව උත්ථාපයිෂ්‍යථ තදාහං ස පුමාන් කේවලඃ ස්වයං කිමපි කර්ම්ම න කරෝමි කින්තු තාතෝ යථා ශික්‍ෂයති තදනුසාරේණ වාක්‍යමිදං වදාමීති ච යූයං ඥාතුං ශක්‍ෂ්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","මත්ප්‍රේරයිතා පිතා මාම් ඒකාකිනං න ත්‍යජති ස මයා සාර්ද්ධං තිෂ්ඨති යතෝහං තදභිමතං කර්ම්ම සදා කරෝමි| ");
INSERT INTO sansin_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","තදා තස්‍යෛතානි වාක්‍යානි ශ්‍රුත්වා බහුවස්තාස්මින් ව්‍යශ්වසන්| ");
INSERT INTO sansin_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","යේ යිහූදීයා ව්‍යශ්වසන් යීශුස්තේභ්‍යෝ(අ)කථයත් ");
INSERT INTO sansin_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","මම වාක්‍යේ යදි යූයම් ආස්ථාං කුරුථ තර්හි මම ශිෂ්‍යා භූත්වා සත්‍යත්වං ඥාස්‍යථ තතඃ සත්‍යතයා යුෂ්මාකං මෝක්‍ෂෝ භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","තදා තේ ප්‍රත්‍යවාදිෂුඃ වයම් ඉබ්‍රාහීමෝ වංශඃ කදාපි කස්‍යාපි දාසා න ජාතාස්තර්හි යුෂ්මාකං මුක්ත්ති ර්භවිෂ්‍යතීති වාක්‍යං කථං බ්‍රවීෂි? ");
INSERT INTO sansin_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","තදා යීශුඃ ප්‍රත්‍යවදද් යුෂ්මානහං යථාර්ථතරං වදාමි යඃ පාපං කරෝති ස පාපස්‍ය දාසඃ| ");
INSERT INTO sansin_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","දාසශ්ච නිරන්තරං නිවේශනේ න තිෂ්ඨති කින්තු පුත්‍රෝ නිරන්තරං තිෂ්ඨති| ");
INSERT INTO sansin_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","අතඃ පුත්‍රෝ යදි යුෂ්මාන් මෝචයති තර්හි නිතාන්තමේව මුක්ත්තා භවිෂ්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","යුයම් ඉබ්‍රාහීමෝ වංශ ඉත්‍යහං ජානාමි කින්තු මම කථා යුෂ්මාකම් අන්තඃකරණේෂු ස්ථානං න ප්‍රාප්නුවන්ති තස්මාද්ධේතෝ ර්මාං හන්තුම් ඊහධ්වේ| ");
INSERT INTO sansin_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","අහං ස්වපිතුඃ සමීපේ යදපශ්‍යං තදේව කථයාමි තථා යූයමපි ස්වපිතුඃ සමීපේ යදපශ්‍යත තදේව කුරුධ්වේ| ");
INSERT INTO sansin_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","තදා තේ ප්‍රත්‍යවෝචන් ඉබ්‍රාහීම් අස්මාකං පිතා තතෝ යීශුරකථයද් යදි යූයම් ඉබ්‍රාහීමඃ සන්තානා අභවිෂ්‍යත තර්හි ඉබ්‍රාහීම ආචාරණවද් ආචරිෂ්‍යත| ");
INSERT INTO sansin_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ඊශ්වරස්‍ය මුඛාත් සත්‍යං වාක්‍යං ශ්‍රුත්වා යුෂ්මාන් ඥාපයාමි යෝහං තං මාං හන්තුං චේෂ්ටධ්වේ ඉබ්‍රාහීම් ඒතාදෘශං කර්ම්ම න චකාර| ");
INSERT INTO sansin_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","යූයං ස්වස්වපිතුඃ කර්ම්මාණි කුරුථ තදා තෛරුක්ත්තං න වයං ජාරජාතා අස්මාකම් ඒකඒව පිතාස්ති ස ඒවේශ්වරඃ ");
INSERT INTO sansin_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","තතෝ යීශුනා කථිතම් ඊශ්වරෝ යදි යුෂ්මාකං තාතෝභවිෂ්‍යත් තර්හි යූයං මයි ප්‍රේමාකරිෂ්‍යත යතෝහම් ඊශ්වරාන්නිර්ගත්‍යාගතෝස්මි ස්වතෝ නාගතෝහං ස මාං ප්‍රාහිණෝත්| ");
INSERT INTO sansin_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","යූයං මම වාක්‍යමිදං න බුධ්‍යධ්වේ කුතඃ? යතෝ යූයං මමෝපදේශං සෝඪුං න ශක්නුථ| ");
INSERT INTO sansin_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","යූයං ශෛතාන් පිතුඃ සන්තානා ඒතස්මාද් යුෂ්මාකං පිතුරභිලාෂං පූරයථ ස ආ ප්‍රථමාත් නරඝාතී තදන්තඃ සත්‍යත්වස්‍ය ලේශෝපි නාස්ති කාරණාදතඃ ස සත්‍යතායාං නාතිෂ්ඨත් ස යදා මෘෂා කථයති තදා නිජස්වභාවානුසාරේණෛව කථයති යතෝ ස මෘෂාභාෂී මෘෂෝත්පාදකශ්ච| ");
INSERT INTO sansin_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","අහං තථ්‍යවාක්‍යං වදාමි කාරණාදස්මාද් යූයං මාං න ප්‍රතීථ| ");
INSERT INTO sansin_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","මයි පාපමස්තීති ප්‍රමාණං යුෂ්මාකං කෝ දාතුං ශක්නෝති? යද්‍යහං තථ්‍යවාක්‍යං වදාමි තර්හි කුතෝ මාං න ප්‍රතිථ? ");
INSERT INTO sansin_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","යඃ කශ්චන ඊශ්වරීයෝ ලෝකඃ ස ඊශ්වරීයකථායාං මනෝ නිධත්තේ යූයම් ඊශ්වරීයලෝකා න භවථ තන්නිදානාත් තත්‍ර න මනාංසි නිධද්වේ| ");
INSERT INTO sansin_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","තදා යිහූදීයාඃ ප්‍රත්‍යවාදිෂුඃ ත්වමේකඃ ශෝමිරෝණීයෝ භූතග්‍රස්තශ්ච වයං කිමිදං භද්‍රං නාවාදිෂ්ම? ");
INSERT INTO sansin_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","තතෝ යීශුඃ ප්‍රත්‍යවාදීත් නාහං භූතග්‍රස්තඃ කින්තු නිජතාතං සම්මන්‍යේ තස්මාද් යූයං මාම් අපමන්‍යධ්වේ| ");
INSERT INTO sansin_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","අහං ස්වසුඛ්‍යාතිං න චේෂ්ටේ කින්තු චේෂ්ටිතා විචාරයිතා චාපර ඒක ආස්තේ| ");
INSERT INTO sansin_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","අහං යුෂ්මභ්‍යම් අතීව යථාර්ථං කථයාමි යෝ නරෝ මදීයං වාචං මන්‍යතේ ස කදාචන නිධනං න ද්‍රක්‍ෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","යිහූදීයාස්තමවදන් ත්වං භූතග්‍රස්ත ඉතීදානීම් අවෛෂ්ම| ඉබ්‍රාහීම් භවිෂ්‍යද්වාදිනඤ්ච සර්ව්වේ මෘතාඃ කින්තු ත්වං භාෂසේ යෝ නරෝ මම භාරතීං ගෘහ්ලාති ස ජාතු නිධානාස්වාදං න ලප්ස්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","තර්හි ත්වං කිම් අස්මාකං පූර්ව්වපුරුෂාද් ඉබ්‍රාහීමෝපි මහාන්? යස්මාත් සෝපි මෘතඃ භවිෂ්‍යද්වාදිනෝපි මෘතාඃ ත්වං ස්වං කං පුමාංසං මනුෂේ? ");
INSERT INTO sansin_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","යීශුඃ ප්‍රත්‍යවෝචද් යද්‍යහං ස්වං ස්වයං සම්මන්‍යේ තර්හි මම තත් සම්මනනං කිමපි න කින්තු මම තාතෝ යං යූයං ස්වීයම් ඊශ්වරං භාෂධ්වේ සඒව මාං සම්මනුතේ| ");
INSERT INTO sansin_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","යූයං තං නාවගච්ඡථ කින්ත්වහං තමවගච්ඡාමි තං නාවගච්ඡාමීති වාක්‍යං යදි වදාමි තර්හි යූයමිව මෘෂාභාෂී භවාමි කින්ත්වහං තමවගච්ඡාමි තදාක්‍ෂාමපි ගෘහ්ලාමි| ");
INSERT INTO sansin_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","යුෂ්මාකං පූර්ව්වපුරුෂ ඉබ්‍රාහීම් මම සමයං ද්‍රෂ්ටුම් අතීවාවාඤ්ඡත් තන්නිරීක්‍ෂ්‍යානන්දච්ච| ");
INSERT INTO sansin_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","තදා යිහූදීයා අපෘච්ඡන් තව වයඃ පඤ්චාශද්වත්සරා න ත්වං කිම් ඉබ්‍රාහීමම් අද්‍රාක්‍ෂීඃ? ");
INSERT INTO sansin_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","යීශුඃ ප්‍රත්‍යවාදීද් යුෂ්මානහං යථාර්ථතරං වදාමි ඉබ්‍රාහීමෝ ජන්මනඃ පූර්ව්වකාලමාරභ්‍යාහං විද්‍යේ| ");
INSERT INTO sansin_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","තදා තේ පාෂාණාන් උත්තෝල්‍ය තමාහන්තුම් උදයච්ඡන් කින්තු යීශු ර්ගුප්තෝ මන්තිරාද් බහිර්ගත්‍ය තේෂාං මධ්‍යේන ප්‍රස්ථිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","තතඃ පරං යීශුර්ගච්ඡන් මාර්ගමධ්‍යේ ජන්මාන්ධං නරම් අපශ්‍යත්| ");
INSERT INTO sansin_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","තතඃ ශිෂ්‍යාස්තම් අපෘච්ඡන් හේ ගුරෝ නරෝයං ස්වපාපේන වා ස්වපිත්‍රාඃ පාපේනාන්ධෝ(අ)ජායත? ");
INSERT INTO sansin_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","තතඃ ස ප්‍රත්‍යුදිතවාන් ඒතස්‍ය වාස්‍ය පිත්‍රෝඃ පාපාද් ඒතාදෘශෝභූද ඉති නහි කින්ත්වනේන යථේශ්වරස්‍ය කර්ම්ම ප්‍රකාශ්‍යතේ තද්ධේතෝරේව| ");
INSERT INTO sansin_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","දිනේ තිෂ්ඨති මත්ප්‍රේරයිතුඃ කර්ම්ම මයා කර්ත්තව්‍යං යදා කිමපි කර්ම්ම න ක්‍රියතේ තාදෘශී නිශාගච්ඡති| ");
INSERT INTO sansin_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","අහං යාවත්කාලං ජගති තිෂ්ඨාමි තාවත්කාලං ජගතෝ ජ්‍යෝතිඃස්වරූපෝස්මි| ");
INSERT INTO sansin_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ඉත්‍යුක්ත්තා භූමෞ නිෂ්ඨීවං නික්‍ෂිප්‍ය තේන පඞ්කං කෘතවාන් ");
INSERT INTO sansin_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","පශ්චාත් තත්පඞ්කේන තස්‍යාන්ධස්‍ය නේත්‍රේ ප්‍රලිප්‍ය තමිත්‍යාදිශත් ගත්වා ශිලෝහේ (අ)ර්ථාත් ප්‍රේරිතනාම්නි සරසි ස්නාහි| තතෝන්ධෝ ගත්වා තත්‍රාස්නාත් තතඃ ප්‍රන්නචක්‍ෂු ර්භූත්වා ව්‍යාඝුට්‍යාගාත්| ");
INSERT INTO sansin_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","අපරඤ්ච සමීපවාසිනෝ ලෝකා යේ ච තං පූර්ව්වමන්ධම් අපශ්‍යන් තේ බක්ත්තුම් ආරභන්ත යෝන්ධලෝකෝ වර්ත්මන්‍යුපවිශ්‍යාභික්‍ෂත ස ඒවායං ජනඃ කිං න භවති? ");
INSERT INTO sansin_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","කේචිදවදන් ස ඒව කේචිදවෝචන් තාදෘශෝ භවති කින්තු ස ස්වයමබ්‍රවීත් ස ඒවාහං භවාමි| ");
INSERT INTO sansin_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","අතඒව තේ (අ)පෘච්ඡන් ත්වං කථං දෘෂ්ටිං පාප්තවාන්? ");
INSERT INTO sansin_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","තතඃ සෝවදද් යීශනාමක ඒකෝ ජනෝ මම නයනේ පඞ්කේන ප්‍රලිප්‍ය ඉත්‍යාඥාපයත් ශිලෝහකාසාරං ගත්වා තත්‍ර ස්නාහි| තතස්තත්‍ර ගත්වා මයි ස්නාතේ දෘෂ්ටිමහං ලබ්ධවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","තදා තේ (අ)වදන් ස පුමාන් කුත්‍ර? තේනෝක්ත්තං නාහං ජානාමි| ");
INSERT INTO sansin_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","අපරං තස්මින් පූර්ව්වාන්ධේ ජනේ ඵිරූශිනාං නිකටම් ආනීතේ සති ඵිරූශිනෝපි තමපෘච්ඡන් කථං දෘෂ්ටිං ප්‍රාප්තෝසි? ");
INSERT INTO sansin_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","තතඃ ස කථිතවාන් ස පඞ්කේන මම නේත්‍රේ (අ)ලිම්පත් පශ්චාද් ස්නාත්වා දෘෂ්ටිමලභේ| ");
INSERT INTO sansin_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","කින්තු යීශු ර්විශ්‍රාමවාරේ කර්ද්දමං කෘත්වා තස්‍ය නයනේ ප්‍රසන්නේ(අ)කරෝද් ඉතිකාරණාත් කතිපයඵිරූශිනෝ(අ)වදන් ");
INSERT INTO sansin_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ස පුමාන් ඊශ්වරාන්න යතඃ ස විශ්‍රාමවාරං න මන්‍යතේ| තතෝන්‍යේ කේචිත් ප්‍රත්‍යවදන් පාපී පුමාන් කිම් ඒතාදෘශම් ආශ්චර‍්‍ය්‍යං කර්ම්ම කර්ත්තුං ශක්නෝති? ");
INSERT INTO sansin_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ඉත්ථං තේෂාං පරස්පරං භින්නවාක්‍යත්වම් අභවත්| පශ්චාත් තේ පුනරපි තං පූර්ව්වාන්ධං මානුෂම් අප්‍රාක්‍ෂුඃ යෝ ජනස්තව චක්‍ෂුෂී ප්‍රසන්නේ කෘතවාන් තස්මින් ත්වං කිං වදසි? ස උක්ත්තවාන් ස භවිශද්වාදී| ");
INSERT INTO sansin_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","ස දෘෂ්ටිම් ආප්තවාන් ඉති යිහූදීයාස්තස්‍ය දෘෂ්ටිං ප්‍රාප්තස්‍ය ජනස්‍ය පිත්‍රෝ ර්මුඛාද් අශ්‍රුත්වා න ප්‍රත්‍යයන්| ");
INSERT INTO sansin_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","අතඒව තේ තාවපෘච්ඡන් යුවයෝ ර‍්‍යං පුත්‍රං ජන්මාන්ධං වදථඃ ස කිමයං? තර්හීදානීං කථං ද්‍රෂ්ටුං ශක්නෝති? ");
INSERT INTO sansin_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","තතස්තස්‍ය පිතරෞ ප්‍රත්‍යවෝචතාම් අයම් ආවයෝඃ පුත්‍ර ආ ජනේරන්ධශ්ච තදප්‍යාවාං ජානීවඃ ");
INSERT INTO sansin_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","කින්ත්වධුනා කථං දෘෂ්ටිං ප්‍රාප්තවාන් තදාවාං න් ජානීවඃ කෝස්‍ය චක්‍ෂුෂී ප්‍රසන්නේ කෘතවාන් තදපි න ජානීව ඒෂ වයඃප්‍රාප්ත ඒනං පෘච්ඡත ස්වකථාං ස්වයං වක්‍ෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","යිහූදීයානාං භයාත් තස්‍ය පිතරෞ වාක්‍යමිදම් අවදතාං යතඃ කෝපි මනුෂ්‍යෝ යදි යීශුම් අභිෂික්තං වදති තර්හි ස භජනගෘහාද් දූරීකාරිෂ්‍යතේ යිහූදීයා ඉති මන්ත්‍රණාම් අකුර්ව්වන් ");
INSERT INTO sansin_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","අතස්තස්‍ය පිතරෞ ව්‍යාහරතාම් ඒෂ වයඃප්‍රාප්ත ඒනං පෘච්ඡත| ");
INSERT INTO sansin_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","තදා තේ පුනශ්ච තං පූර්ව්වාන්ධම් ආහූය ව්‍යාහරන් ඊශ්වරස්‍ය ගුණාන් වද ඒෂ මනුෂ්‍යඃ පාපීති වයං ජානීමඃ| ");
INSERT INTO sansin_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","තදා ස උක්ත්තවාන් ස පාපී න වේති නාහං ජානේ පූර්වාමන්ධ ආසමහම් අධුනා පශ්‍යාමීති මාත්‍රං ජානාමි| ");
INSERT INTO sansin_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","තේ පුනරපෘච්ඡන් ස ත්වාං ප්‍රති කිමකරෝත්? කථං නේත්‍රේ ප්‍රසන්නේ (අ)කරෝත්? ");
INSERT INTO sansin_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","තතඃ සෝවාදීද් ඒකකෘත්වෝකථයං යූයං න ශෘණුථ තර්හි කුතඃ පුනඃ ශ්‍රෝතුම් ඉච්ඡථ? යූයමපි කිං තස්‍ය ශිෂ්‍යා භවිතුම් ඉච්ඡථ? ");
INSERT INTO sansin_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","තදා තේ තං තිරස්කෘත්‍ය ව්‍යාහරන් ත්වං තස්‍ය ශිෂ්‍යෝ වයං මූසාඃ ශිෂ්‍යාඃ| ");
INSERT INTO sansin_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","මූසාවක්ත්‍රේණේශ්වරෝ ජගාද තජ්ජානීමඃ කින්ත්වේෂ කුත්‍රත්‍යලෝක ඉති න ජානීමඃ| ");
INSERT INTO sansin_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","සෝවදද් ඒෂ මම ලෝචනේ ප්‍රසන්නේ (අ)කරෝත් තථාපි කුත්‍රත්‍යලෝක ඉති යූයං න ජානීථ ඒතද් ආශ්චර‍්‍ය්‍යං භවති| ");
INSERT INTO sansin_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ඊශ්වරඃ පාපිනාං කථාං න ශෘණෝති කින්තු යෝ ජනස්තස්මින් භක්තිං කෘත්වා තදිෂ්ටක්‍රියාං කරෝති තස්‍යෛව කථාං ශෘණෝති ඒතද් වයං ජානීමඃ| ");
INSERT INTO sansin_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","කෝපි මනුෂ්‍යෝ ජන්මාන්ධාය චක්‍ෂුෂී අදදාත් ජගදාරම්භාද් ඒතාදෘශීං කථාං කෝපි කදාපි නාශෘණෝත්| ");
INSERT INTO sansin_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","අස්මාද් ඒෂ මනුෂ්‍යෝ යදීශ්වරාන්නාජායත තර්හි කිඤ්චිදපීදෘශං කර්ම්ම කර්ත්තුං නාශක්නෝත්| ");
INSERT INTO sansin_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","තේ ව්‍යාහරන් ත්වං පාපාද් අජායථාඃ කිමස්මාන් ත්වං ශික්‍ෂයසි? පශ්චාත්තේ තං බහිරකුර්ව්වන්| ");
INSERT INTO sansin_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","තදනන්තරං යිහූදීයෛඃ ස බහිරක්‍රියත යීශුරිති වාර්ත්තාං ශ්‍රුත්වා තං සාක්‍ෂාත් ප්‍රාප්‍ය පෘෂ්ටවාන් ඊශ්වරස්‍ය පුත්‍රේ ත්වං විශ්වසිෂි? ");
INSERT INTO sansin_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","තදා ස ප්‍රත්‍යවෝචත් හේ ප්‍රභෝ ස කෝ යත් තස්මින්නහං විශ්වසිමි? ");
INSERT INTO sansin_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","තතෝ යීශුඃ කථිතවාන් ත්වං තං දෘෂ්ටවාන් ත්වයා සාකං යඃ කථං කථයති සඒව සඃ| ");
INSERT INTO sansin_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","තදා හේ ප්‍රභෝ විශ්වසිමීත්‍යුක්ත්වා ස තං ප්‍රණාමත්| ");
INSERT INTO sansin_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","පශ්චාද් යීශුඃ කථිතවාන් නයනහීනා නයනානි ප්‍රාප්නුවන්ති නයනවන්තශ්චාන්ධා භවන්තීත්‍යභිප්‍රායේණ ජගදාහම් ආගච්ඡම්| ");
INSERT INTO sansin_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ඒතත් ශ්‍රුත්වා නිකටස්ථාඃ කතිපයාඃ ඵිරූශිනෝ ව්‍යාහරන් වයමපි කිමන්ධාඃ? ");
INSERT INTO sansin_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","තදා යීශුරවාදීද් යද්‍යන්ධා අභවත තර්හි පාපානි නාතිෂ්ඨන් කින්තු පශ්‍යාමීති වාක්‍යවදනාද් යුෂ්මාකං පාපානි තිෂ්ඨන්ති| ");
INSERT INTO sansin_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","අහං යුෂ්මානතියථාර්ථං වදාමි, යෝ ජනෝ ද්වාරේණ න ප්‍රවිශ්‍ය කේනාප්‍යන්‍යේන මේෂගෘහං ප්‍රවිශති ස ඒව ස්තේනෝ දස්‍යුශ්ච| ");
INSERT INTO sansin_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","යෝ ද්වාරේණ ප්‍රවිශති ස ඒව මේෂපාලකඃ| ");
INSERT INTO sansin_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","දෞවාරිකස්තස්මෛ ද්වාරං මෝචයති මේෂගණශ්ච තස්‍ය වාක්‍යං ශෘණෝති ස නිජාන් මේෂාන් ස්වස්වනාම්නාහූය බහිඃ කෘත්වා නයති| ");
INSERT INTO sansin_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","තථා නිජාන් මේෂාන් බහිඃ කෘත්වා ස්වයං තේෂාම් අග්‍රේ ගච්ඡති, තතෝ මේෂාස්තස්‍ය ශබ්දං බුධ්‍යන්තේ, තස්මාත් තස්‍ය පශ්චාද් ව්‍රජන්ති| ");
INSERT INTO sansin_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","කින්තු පරස්‍ය ශබ්දං න බුධ්‍යන්තේ තස්මාත් තස්‍ය පශ්චාද් ව්‍රජිෂ්‍යන්ති වරං තස්‍ය සමීපාත් පලායිෂ්‍යන්තේ| ");
INSERT INTO sansin_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","යීශුස්තේභ්‍ය ඉමාං දෘෂ්ටාන්තකථාම් අකථයත් කින්තු තේන කථිතකථායාස්තාත්පර‍්‍ය්‍යං තේ නාබුධ්‍යන්ත| ");
INSERT INTO sansin_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","අතෝ යීශුඃ පුනරකථයත්, යුෂ්මානාහං යථාර්ථතරං ව්‍යාහරාමි, මේෂගෘහස්‍ය ද්වාරම් අහමේව| ");
INSERT INTO sansin_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","මයා න ප්‍රවිශ්‍ය ය ආගච්ඡන් තේ ස්තේනා දස්‍යවශ්ච කින්තු මේෂාස්තේෂාං කථා නාශෘණ්වන්| ");
INSERT INTO sansin_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","අහමේව ද්වාරස්වරූපඃ, මයා යඃ කශ්චිත ප්‍රවිශති ස රක්‍ෂාං ප්‍රාප්ස්‍යති තථා බහිරන්තශ්ච ගමනාගමනේ කෘත්වා චරණස්ථානං ප්‍රාප්ස්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","යෝ ජනස්තේනඃ ස කේවලං ස්තෛන්‍යබධවිනාශාන් කර්ත්තුමේව සමායාති කින්ත්වහම් ආයු ර්දාතුම් අර්ථාත් බාහූල්‍යේන තදේව දාතුම් ආගච්ඡම්| ");
INSERT INTO sansin_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","අහමේව සත්‍යමේෂපාලකෝ යස්තු සත්‍යෝ මේෂපාලකඃ ස මේෂාර්ථං ප්‍රාණත්‍යාගං කරෝති; ");
INSERT INTO sansin_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","කින්තු යෝ ජනෝ මේෂපාලකෝ න, අර්ථාද් යස්‍ය මේෂා නිජා න භවන්ති, ය ඒතාදෘශෝ වෛතනිකඃ ස වෘකම් ආගච්ඡන්තං දෘෂ්ට්වා මේජව්‍රජං විහාය පලායතේ, තස්මාද් වෘකස්තං ව්‍රජං ධෘත්වා විකිරති| ");
INSERT INTO sansin_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","වෛතනිකඃ පලායතේ යතඃ ස වේතනාර්ථී මේෂාර්ථං න චින්තයති| ");
INSERT INTO sansin_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","අහමේව සත්‍යෝ මේෂපාලකඃ, පිතා මාං යථා ජානාති, අහඤ්ච යථා පිතරං ජානාමි, ");
INSERT INTO sansin_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","තථා නිජාන් මේෂානපි ජානාමි, මේෂාශ්ච මාං ජානාන්ති, අහඤ්ච මේෂාර්ථං ප්‍රාණත්‍යාගං කරෝමි| ");
INSERT INTO sansin_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","අපරඤ්ච ඒතද් ගෘහීය මේෂේභ්‍යෝ භින්නා අපි මේෂා මම සන්ති තේ සකලා ආනයිතව්‍යාඃ; තේ මම ශබ්දං ශ්‍රෝෂ්‍යන්ති තත ඒකෝ ව්‍රජ ඒකෝ රක්‍ෂකෝ භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","ප්‍රාණානහං ත්‍යක්ත්වා පුනඃ ප්‍රාණාන් ග්‍රහීෂ්‍යාමි, තස්මාත් පිතා මයි ස්නේහං කරෝති| ");
INSERT INTO sansin_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","කශ්චිජ්ජනෝ මම ප්‍රාණාන් හන්තුං න ශක්නෝති කින්තු ස්වයං තාන් සමර්පයාමි තාන් සමර්පයිතුං පුනර්ග්‍රහීතුඤ්ච මම ශක්තිරාස්තේ භාරමිමං ස්වපිතුඃ සකාශාත් ප්‍රාප්තෝහම්| ");
INSERT INTO sansin_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","අස්මාදුපදේශාත් පුනශ්ච යිහූදීයානාං මධ්‍යේ භින්නවාක්‍යතා ජාතා| ");
INSERT INTO sansin_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","තතෝ බහවෝ ව්‍යාහරන් ඒෂ භූතග්‍රස්ත උන්මත්තශ්ච, කුත ඒතස්‍ය කථාං ශෘණුථ? ");
INSERT INTO sansin_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","කේචිද් අවදන් ඒතස්‍ය කථා භූතග්‍රස්තස්‍ය කථාවන්න භවන්ති, භූතඃ කිම් අන්ධාය චක්‍ෂුෂී දාතුං ශක්නෝති? ");
INSERT INTO sansin_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","ශීතකාලේ යිරූශාලමි මන්දිරෝත්සර්ගපර්ව්වණ්‍යුපස්ථිතේ ");
INSERT INTO sansin_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","යීශුඃ සුලේමානෝ නිඃසාරේණ ගමනාගමනේ කරෝති, ");
INSERT INTO sansin_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ඒතස්මින් සමයේ යිහූදීයාස්තං වේෂ්ටයිත්වා ව්‍යාහරන් කති කාලාන් අස්මාකං විචිකිත්සාං ස්ථාපයිෂ්‍යාමි? යද්‍යභිෂික්තෝ භවති තර්හි තත් ස්පෂ්ටං වද| ");
INSERT INTO sansin_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","තදා යීශුඃ ප්‍රත්‍යවදද් අහම් අචකථං කින්තු යූයං න ප්‍රතීථ, නිජපිතු ර්නාම්නා යාං යාං ක්‍රියාං කරෝමි සා ක්‍රියෛව මම සාක්‍ෂිස්වරූපා| ");
INSERT INTO sansin_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","කින්ත්වහං පූර්ව්වමකථයං යූයං මම මේෂා න භවථ, කාරණාදස්මාන් න විශ්වසිථ| ");
INSERT INTO sansin_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","මම මේෂා මම ශබ්දං ශෘණ්වන්ති තානහං ජානාමි තේ ච මම පශ්චාද් ගච්ඡන්ති| ");
INSERT INTO sansin_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","අහං තේභ්‍යෝ(අ)නන්තායු ර්දදාමි, තේ කදාපි න නංක්‍ෂ්‍යන්ති කෝපි මම කරාත් තාන් හර්ත්තුං න ශක්‍ෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","යෝ මම පිතා තාන් මහ්‍යං දත්තවාන් ස සර්ව්වස්මාත් මහාන්, කෝපි මම පිතුඃ කරාත් තාන් හර්ත්තුං න ශක්‍ෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","අහං පිතා ච ද්වයෝරේකත්වම්| ");
INSERT INTO sansin_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","තතෝ යිහූදීයාඃ පුනරපි තං හන්තුං පාෂාණාන් උදතෝලයන්| ");
INSERT INTO sansin_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","යීශුඃ කථිතවාන් පිතුඃ සකාශාද් බහූන්‍යුත්තමකර්ම්මාණි යුෂ්මාකං ප්‍රාකාශයං තේෂාං කස්‍ය කර්ම්මණඃ කාරණාන් මාං පාෂාණෛරාහන්තුම් උද්‍යතාඃ ස්ථ? ");
INSERT INTO sansin_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","යිහූදීයාඃ ප්‍රත්‍යවදන් ප්‍රශස්තකර්ම්මහේතෝ ර්න කින්තු ත්වං මානුෂඃ ස්වමීශ්වරම් උක්ත්වේශ්වරං නින්දසි කාරණාදස්මාත් ත්වාං පාෂාණෛර්හන්මඃ| ");
INSERT INTO sansin_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","තදා යීශුඃ ප්‍රත්‍යුක්තවාන් මයා කථිතං යූයම් ඊශ්වරා ඒතද්වචනං යුෂ්මාකං ශාස්ත්‍රේ ලිඛිතං නාස්ති කිං? ");
INSERT INTO sansin_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","තස්මාද් යේෂාම් උද්දේශේ ඊශ්වරස්‍ය කථා කථිතා තේ යදීශ්වරගණා උච්‍යන්තේ ධර්ම්මග්‍රන්ථස්‍යාප්‍යන්‍යථා භවිතුං න ශක්‍යං, ");
INSERT INTO sansin_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","තර්හ්‍යාහම් ඊශ්වරස්‍ය පුත්‍ර ඉති වාක්‍යස්‍ය කථනාත් යූයං පිත්‍රාභිෂික්තං ජගති ප්‍රේරිතඤ්ච පුමාංසං කථම් ඊශ්වරනින්දකං වාදය? ");
INSERT INTO sansin_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","යද්‍යහං පිතුඃ කර්ම්ම න කරෝමි තර්හි මාං න ප්‍රතීත; ");
INSERT INTO sansin_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","කින්තු යදි කරෝමි තර්හි මයි යුෂ්මාභිඃ ප්‍රත්‍යයේ න කෘතේ(අ)පි කාර‍්‍ය්‍යේ ප්‍රත්‍යයඃ ක්‍රියතාං, තතෝ මයි පිතාස්තීති පිතර‍්‍ය්‍යහම් අස්මීති ච ක්‍ෂාත්වා විශ්වසිෂ්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","තදා තේ පුනරපි තං ධර්ත්තුම් අචේෂ්ටන්ත කින්තු ස තේෂාං කරේභ්‍යෝ නිස්තීර‍්‍ය්‍ය ");
INSERT INTO sansin_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","පුන ර‍්‍යර්ද්දන් අද්‍යාස්තටේ යත්‍ර පුර්ව්වං යෝහන් අමජ්ජයත් තත්‍රාගත්‍ය න්‍යවසත්| ");
INSERT INTO sansin_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","තතෝ බහවෝ ලෝකාස්තත්සමීපම් ආගත්‍ය ව්‍යාහරන් යෝහන් කිමප්‍යාශ්චර‍්‍ය්‍යං කර්ම්ම නාකරෝත් කින්ත්වස්මින් මනුෂ්‍යේ යා යඃ කථා අකථයත් තාඃ සර්ව්වාඃ සත්‍යාඃ; ");
INSERT INTO sansin_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","තත්‍ර ච බහවෝ ලෝකාස්තස්මින් ව්‍යශ්වසන්| ");
INSERT INTO sansin_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","අනන්තරං මරියම් තස්‍යා භගිනී මර්ථා ච යස්මින් වෛථනීයාග්‍රාමේ වසතස්තස්මින් ග්‍රාමේ ඉලියාසර් නාමා පීඩිත ඒක ආසීත්| ");
INSERT INTO sansin_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","යා මරියම් ප්‍රභුං සුගන්ධිතේලෛන මර්ද්දයිත්වා ස්වකේශෛස්තස්‍ය චරණෞ සමමාර්ජත් තස්‍යා භ්‍රාතා ස ඉලියාසර් රෝගී| ");
INSERT INTO sansin_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","අපරඤ්ච හේ ප්‍රභෝ භවාන් යස්මින් ප්‍රීයතේ ස ඒව පීඩිතෝස්තීති කථාං කථයිත්වා තස්‍ය භගින්‍යෞ ප්‍රේෂිතවත්‍යෞ| ");
INSERT INTO sansin_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","තදා යීශුරිමාං වාර්ත්තාං ශ්‍රුත්වාකථයත පීඩේයං මරණාර්ථං න කින්ත්වීශ්වරස්‍ය මහිමාර්ථම් ඊශ්වරපුත්‍රස්‍ය මහිමප්‍රකාශාර්ථඤ්ච ජාතා| ");
INSERT INTO sansin_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","යීශු ර‍්‍යද්‍යපිමර්ථායාං තද්භගින්‍යාම් ඉලියාසරි චාප්‍රීයත, ");
INSERT INTO sansin_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","තථාපි ඉලියාසරඃ පීඩායාඃ කථං ශ්‍රුත්වා යත්‍ර ආසීත් තත්‍රෛව දිනද්වයමතිෂ්ඨත්| ");
INSERT INTO sansin_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","තතඃ පරම් ස ශිෂ්‍යානකථයද් වයං පුන ර‍්‍යිහූදීයප්‍රදේශං යාමඃ| ");
INSERT INTO sansin_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","තතස්තේ ප්‍රත්‍යවදන්, හේ ගුරෝ ස්වල්පදිනානි ගතානි යිහූදීයාස්ත්වාං පාෂාණෛ ර්හන්තුම් උද්‍යතාස්තථාපි කිං පුනස්තත්‍ර යාස්‍යසි? ");
INSERT INTO sansin_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","යීශුඃ ප්‍රත්‍යවදත්, ඒකස්මින් දිනේ කිං ද්වාදශඝටිකා න භවන්ති? කෝපි දිවා ගච්ඡන් න ස්ඛලති යතඃ ස ඒතජ්ජගතෝ දීප්තිං ප්‍රාප්නෝති| ");
INSERT INTO sansin_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","කින්තු රාත්‍රෞ ගච්ඡන් ස්ඛලති යතෝ හේතෝස්තත්‍ර දීප්ති ර්නාස්ති| ");
INSERT INTO sansin_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ඉමාං කථාං කථයිත්වා ස තානවදද්, අස්මාකං බන්ධුඃ ඉලියාසර් නිද්‍රිතෝභූද් ඉදානීං තං නිද්‍රාතෝ ජාගරයිතුං ගච්ඡාමි| ");
INSERT INTO sansin_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","යීශු ර්මෘතෞ කථාමිමාං කථිතවාන් කින්තු විශ්‍රාමාර්ථං නිද්‍රායාං කථිතවාන් ඉති ඥාත්වා ශිෂ්‍යා අකථයන්, ");
INSERT INTO sansin_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","හේ ගුරෝ ස යදි නිද්‍රාති තර්හි භද්‍රමේව| ");
INSERT INTO sansin_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","තදා යීශුඃ ස්පෂ්ටං තාන් ව්‍යාහරත්, ඉලියාසර් අම්‍රියත; ");
INSERT INTO sansin_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","කින්තු යූයං යථා ප්‍රතීථ තදර්ථමහං තත්‍ර න ස්ථිතවාන් ඉත්‍යස්මාද් යුෂ්මන්නිමිත්තම් ආහ්ලාදිතෝහං, තථාපි තස්‍ය සමීපේ යාම| ");
INSERT INTO sansin_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","තදා ථෝමා යං දිදුමං වදන්ති ස සඞ්ගිනඃ ශිෂ්‍යාන් අවදද් වයමපි ගත්වා තේන සාර්ද්ධං ම්‍රියාමහෛ| ");
INSERT INTO sansin_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","යීශුස්තත්‍රෝපස්ථාය ඉලියාසරඃ ශ්මශානේ ස්ථාපනාත් චත්වාරි දිනානි ගතානීති වාර්ත්තාං ශ්‍රුතවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","වෛථනීයා යිරූශාලමඃ සමීපස්ථා ක්‍රෝශෛකමාත්‍රාන්තරිතා; ");
INSERT INTO sansin_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","තස්මාද් බහවෝ යිහූදීයා මර්ථාං මරියමඤ්ච භ්‍යාතෘශෝකාපන්නාං සාන්ත්වයිතුං තයෝඃ සමීපම් ආගච්ඡන්| ");
INSERT INTO sansin_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","මර්ථා යීශෝරාගමනවාර්තාං ශ්‍රුත්වෛව තං සාක්‍ෂාද් අකරෝත් කින්තු මරියම් ගේහ උපවිශ්‍ය ස්ථිතා| ");
INSERT INTO sansin_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","තදා මර්ථා යීශුමවාදත්, හේ ප්‍රභෝ යදි භවාන් අත්‍රාස්ථාස්‍යත් තර්හි මම භ්‍රාතා නාමරිෂ්‍යත්| ");
INSERT INTO sansin_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","කින්ත්විදානීමපි යද් ඊශ්වරේ ප්‍රාර්ථයිෂ්‍යතේ ඊශ්වරස්තද් දාස්‍යතීති ජානේ(අ)හං| ");
INSERT INTO sansin_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","යීශුරවාදීත් තව භ්‍රාතා සමුත්ථාස්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","මර්ථා ව්‍යාහරත් ශේෂදිවසේ ස උත්ථානසමයේ ප්‍රෝත්ථාස්‍යතීති ජානේ(අ)හං| ");
INSERT INTO sansin_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","තදා යීශුඃ කථිතවාන් අහමේව උත්ථාපයිතා ජීවයිතා ච යඃ කශ්චන මයි විශ්වසිති ස මෘත්වාපි ජීවිෂ්‍යති; ");
INSERT INTO sansin_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","යඃ කශ්චන ච ජීවන් මයි විශ්වසිති ස කදාපි න මරිෂ්‍යති, අස්‍යාං කථායාං කිං විශ්වසිෂි? ");
INSERT INTO sansin_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","සාවදත් ප්‍රභෝ යස්‍යාවතරණාපේක්‍ෂාස්ති භවාන් සඒවාභිෂික්ත්ත ඊශ්වරපුත්‍ර ඉති විශ්වසිමි| ");
INSERT INTO sansin_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ඉති කථාං කථයිත්වා සා ගත්වා ස්වාං භගිනීං මරියමං ගුප්තමාහූය ව්‍යාහරත් ගුරුරුපතිෂ්ඨති ත්වාමාහූයති ච| ");
INSERT INTO sansin_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","කථාමිමාං ශ්‍රුත්වා සා තූර්ණම් උත්ථාය තස්‍ය සමීපම් අගච්ඡත්| ");
INSERT INTO sansin_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","යීශු ර්ග්‍රාමමධ්‍යං න ප්‍රවිශ්‍ය යත්‍ර මර්ථා තං සාක්‍ෂාද් අකරෝත් තත්‍ර ස්ථිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","යේ යිහූදීයා මරියමා සාකං ගෘහේ තිෂ්ඨන්තස්තාම් අසාන්ත්වයන තේ තාං ක්‍ෂිප්‍රම් උත්ථාය ගච්ඡන්තිං විලෝක්‍ය ව්‍යාහරන්, ස ශ්මශානේ රෝදිතුං යාති, ඉත්‍යුක්ත්වා තේ තස්‍යාඃ පශ්චාද් අගච්ඡන්| ");
INSERT INTO sansin_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","යත්‍ර යීශුරතිෂ්ඨත් තත්‍ර මරියම් උපස්ථාය තං දෘෂ්ට්වා තස්‍ය චරණයෝඃ පතිත්වා ව්‍යාහරත් හේ ප්‍රභෝ යදි භවාන් අත්‍රාස්ථාස්‍යත් තර්හි මම භ්‍රාතා නාමරිෂ්‍යත්| ");
INSERT INTO sansin_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","යීශුස්තාං තස්‍යාඃ සඞ්ගිනෝ යිහූදීයාංශ්ච රුදතෝ විලෝක්‍ය ශෝකාර්ත්තඃ සන් දීර්ඝං නිශ්වස්‍ය කථිතවාන් තං කුත්‍රාස්ථාපයත? ");
INSERT INTO sansin_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","තේ ව්‍යාහරන්, හේ ප්‍රභෝ භවාන් ආගත්‍ය පශ්‍යතු| ");
INSERT INTO sansin_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","යීශුනා ක්‍රන්දිතං| ");
INSERT INTO sansin_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","අතඒව යිහූදීයා අවදන්, පශ්‍යතායං තස්මින් කිදෘග් අප්‍රියත| ");
INSERT INTO sansin_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","තේෂාං කේචිද් අවදන් යෝන්ධාය චක්‍ෂුෂී දත්තවාන් ස කිම් අස්‍ය මෘත්‍යුං නිවාරයිතුං නාශක්නෝත්? ");
INSERT INTO sansin_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","තතෝ යීශුඃ පුනරන්තර්දීර්ඝං නිශ්වස්‍ය ශ්මශානාන්තිකම් අගච්ඡත්| තත් ශ්මශානම් ඒකං ගහ්වරං තන්මුඛේ පාෂාණ ඒක ආසීත්| ");
INSERT INTO sansin_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","තදා යීශුරවදද් ඒනං පාෂාණම් අපසාරයත, තතඃ ප්‍රමීතස්‍ය භගිනී මර්ථාවදත් ප්‍රභෝ, අධුනා තත්‍ර දුර්ගන්ධෝ ජාතඃ, යතෝද්‍ය චත්වාරි දිනානි ශ්මශානේ ස තිෂ්ඨති| ");
INSERT INTO sansin_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","තදා යීශුරවාදීත්, යදි විශ්වසිෂි තර්හීශ්වරස්‍ය මහිමප්‍රකාශං ද්‍රක්‍ෂ්‍යසි කථාමිමාං කිං තුභ්‍යං නාකථයං? ");
INSERT INTO sansin_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","තදා මෘතස්‍ය ශ්මශානාත් පාෂාණෝ(අ)පසාරිතේ යීශුරූර්ද්ව්වං පශ්‍යන් අකථයත්, හේ පිත ර්මම නේවේසනම් අශෘණෝඃ කාරණාදස්මාත් ත්වාං ධන්‍යං වදාමි| ");
INSERT INTO sansin_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ත්වං සතතං ශෘණෝෂි තදප්‍යහං ජානාමි, කින්තු ත්වං මාං යත් ප්‍රෛරයස්තද් යථාස්මින් ස්ථානේ ස්ථිතා ලෝකා විශ්වසන්ති තදර්ථම් ඉදං වාක්‍යං වදාමි| ");
INSERT INTO sansin_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ඉමාං කථාං කථයිත්වා ස ප්‍රෝච්චෛරාහ්වයත්, හේ ඉලියාසර් බහිරාගච්ඡ| ");
INSERT INTO sansin_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","තතඃ ස ප්‍රමීතඃ ශ්මශානවස්ත්‍රෛ ර්බද්ධහස්තපාදෝ ගාත්‍රමාර්ජනවාසසා බද්ධමුඛශ්ච බහිරාගච්ඡත්| යීශුරුදිතවාන් බන්ධනානි මෝචයිත්වා ත්‍යජතෛනං| ");
INSERT INTO sansin_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","මරියමඃ සමීපම් ආගතා යේ යිහූදීයලෝකාස්තදා යීශෝරේතත් කර්ම්මාපශ්‍යන් තේෂාං බහවෝ ව්‍යශ්වසන්, ");
INSERT INTO sansin_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","කින්තු කේචිදන්‍යේ ඵිරූශිනාං සමීපං ගත්වා යීශෝරේතස්‍ය කර්ම්මණෝ වාර්ත්තාම් අවදන්| ");
INSERT INTO sansin_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","තතඃ පරං ප්‍රධානයාජකාඃ ඵිරූශිනාශ්ච සභාං කෘත්වා ව්‍යාහරන් වයං කිං කුර්ම්මඃ? ඒෂ මානවෝ බහූන්‍යාශ්චර‍්‍ය්‍යකර්ම්මාණි කරෝති| ");
INSERT INTO sansin_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","යදීදෘශං කර්ම්ම කර්ත්තුං න වාරයාමස්තර්හි සර්ව්වේ ලෝකාස්තස්මින් විශ්වසිෂ්‍යන්ති රෝමිලෝකාශ්චාගත්‍යාස්මාකම් අනයා රාජධාන්‍යා සාර්ද්ධං රාජ්‍යම් ආඡේත්ස්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","තදා තේෂාං කියඵානාමා යස්තස්මින් වත්සරේ මහායාජකපදේ න්‍යයුජ්‍යත ස ප්‍රත්‍යවදද් යූයං කිමපි න ජානීථ; ");
INSERT INTO sansin_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","සමග්‍රදේශස්‍ය විනාශතෝපි සර්ව්වලෝකාර්ථම් ඒකස්‍ය ජනස්‍ය මරණම් අස්මාකං මඞ්ගලහේතුකම් ඒතස්‍ය විවේචනාමපි න කුරුථ| ");
INSERT INTO sansin_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","ඒතාං කථාං ස නිජබුද්ධ්‍යා ව්‍යාහරද් ඉති න, ");
INSERT INTO sansin_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","කින්තු යීශූස්තද්දේශීයානාං කාරණාත් ප්‍රාණාන් ත්‍යක්‍ෂ්‍යති, දිශි දිශි විකීර්ණාන් ඊශ්වරස්‍ය සන්තානාන් සංගෘහ්‍යෛකජාතිං කරිෂ්‍යති ච, තස්මින් වත්සරේ කියඵා මහායාජකත්වපදේ නියුක්තඃ සන් ඉදං භවිෂ්‍යද්වාක්‍යං කථිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","තද්දිනමාරභ්‍ය තේ කථං තං හන්තුං ශක්නුවන්තීති මන්ත්‍රණාං කර්ත්තුං ප්‍රාරේභිරේ| ");
INSERT INTO sansin_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","අතඒව යිහූදීයානාං මධ්‍යේ යීශුඃ සප්‍රකාශං ගමනාගමනේ අකෘත්වා තස්මාද් ගත්වා ප්‍රාන්තරස්‍ය සමීපස්ථායිප්‍රදේශස්‍යේඵ්‍රායිම් නාම්නි නගරේ ශිෂ්‍යෛඃ සාකං කාලං යාපයිතුං ප්‍රාරේභේ| ");
INSERT INTO sansin_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","අනන්තරං යිහූදීයානාං නිස්තාරෝත්සවේ නිකටවර්ත්තිනි සති තදුත්සවාත් පූර්ව්වං ස්වාන් ශුචීන් කර්ත්තුං බහවෝ ජනා ග්‍රාමේභ්‍යෝ යිරූශාලම් නගරම් ආගච්ඡන්, ");
INSERT INTO sansin_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","යීශෝරන්වේෂණං කෘත්වා මන්දිරේ දණ්ඩායමානාඃ සන්තඃ පරස්පරං ව්‍යාහරන්, යුෂ්මාකං කීදෘශෝ බෝධෝ ජායතේ? ස කිම් උත්සවේ(අ)ස්මින් අත්‍රාගමිෂ්‍යති? ");
INSERT INTO sansin_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","ස ච කුත්‍රාස්ති යද්‍යේතත් කශ්චිද් වේත්ති තර්හි දර්ශයතු ප්‍රධානයාජකාඃ ඵිරූශිනශ්ච තං ධර්ත්තුං පූර්ව්වම් ඉමාම් ආඥාං ප්‍රාචාරයන්| ");
INSERT INTO sansin_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","නිස්තාරෝත්සවාත් පූර්ව්වං දිනෂට්කේ ස්ථිතේ යීශු ර‍්‍යං ප්‍රමීතම් ඉලියාසරං ශ්මශානාද් උදස්ථාපරත් තස්‍ය නිවාසස්ථානං බෛථනියාග්‍රාමම් ආගච්ඡත්| ");
INSERT INTO sansin_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","තත්‍ර තදර්ථං රජන්‍යාං භෝජ්‍යේ කෘතේ මර්ථා පර‍්‍ය්‍යවේෂයද් ඉලියාසර් ච තස්‍ය සඞ්ගිභිඃ සාර්ද්ධං භෝජනාසන උපාවිශත්| ");
INSERT INTO sansin_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","තදා මරියම් අර්ද්ධසේටකං බහුමූල්‍යං ජටාමාංසීයං තෛලම් ආනීය යීශෝශ්චරණයෝ ර්මර්ද්දයිත්වා නිජකේශ ර්මාර්ෂ්ටුම් ආරභත; තදා තෛලස්‍ය පරිමලේන ගෘහම් ආමෝදිතම් අභවත්| ");
INSERT INTO sansin_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","යඃ ශිමෝනඃ පුත්‍ර රිෂ්කරියෝතීයෝ යිහූදානාමා යීශුං පරකරේෂු සමර්පයිෂ්‍යති ස ශිෂ්‍යස්තදා කථිතවාන්, ");
INSERT INTO sansin_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","ඒතත්තෛලං ත්‍රිභිඃ ශතෛ ර්මුද්‍රාපදෛ ර්වික්‍රීතං සද් දරිද්‍රේභ්‍යඃ කුතෝ නාදීයත? ");
INSERT INTO sansin_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ස දරිද්‍රලෝකාර්ථම් අචින්තයද් ඉති න, කින්තු ස චෞර ඒවං තන්නිකටේ මුද්‍රාසම්පුටකස්ථිත්‍යා තන්මධ්‍යේ යදතිෂ්ඨත් තදපාහරත් තස්මාත් කාරණාද් ඉමාං කථාමකථයත්| ");
INSERT INTO sansin_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","තදා යීශුරකථයද් ඒනාං මා වාරය සා මම ශ්මශානස්ථාපනදිනාර්ථං තදරක්‍ෂයත්| ");
INSERT INTO sansin_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","දරිද්‍රා යුෂ්මාකං සන්නිධෞ සර්ව්වදා තිෂ්ඨන්ති කින්ත්වහං සර්ව්වදා යුෂ්මාකං සන්නිධෞ න තිෂ්ඨාමි| ");
INSERT INTO sansin_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","තතඃ පරං යීශුස්තත්‍රාස්තීති වාර්ත්තාං ශ්‍රුත්වා බහවෝ යිහූදීයාස්තං ශ්මශානාදුත්ථාපිතම් ඉලියාසරඤ්ච ද්‍රෂ්ටුං තත් ස්ථානම් ආගච්ඡන| ");
INSERT INTO sansin_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","තදා ප්‍රධානයාජකාස්තම් ඉලියාසරමපි සංහර්ත්තුම් අමන්ත්‍රයන් ; ");
INSERT INTO sansin_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","යතස්තේන බහවෝ යිහූදීයා ගත්වා යීශෞ ව්‍යශ්වසන්| ");
INSERT INTO sansin_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","අනන්තරං යීශු ර‍්‍යිරූශාලම් නගරම් ආගච්ඡතීති වාර්ත්තාං ශ්‍රුත්වා පරේ(අ)හනි උත්සවාගතා බහවෝ ලෝකාඃ ");
INSERT INTO sansin_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ඛර්ජ්ජූරපත්‍රාද්‍යානීය තං සාක්‍ෂාත් කර්ත්තුං බහිරාගත්‍ය ජය ජයේති වාචං ප්‍රෝච්චෛ ර්වක්තුම් ආරභන්ත, ඉස්‍රායේලෝ යෝ රාජා පරමේශ්වරස්‍ය නාම්නාගච්ඡති ස ධන්‍යඃ| ");
INSERT INTO sansin_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","තදා \"හේ සියෝනඃ කන්‍යේ මා භෛෂීඃ පශ්‍යායං තව රාජා ගර්ද්දභශාවකම් ආරුහ්‍යාගච්ඡති\" ");
INSERT INTO sansin_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","ඉති ශාස්ත්‍රීයවචනානුසාරේණ යීශුරේකං යුවගර්ද්දභං ප්‍රාප්‍ය තදුපර‍්‍ය්‍යාරෝහත්| ");
INSERT INTO sansin_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","අස්‍යාඃ ඝටනායාස්තාත්පර‍්‍ය්‍යං ශිෂ්‍යාඃ ප්‍රථමං නාබුධ්‍යන්ත, කින්තු යීශෞ මහිමානං ප්‍රාප්තේ සති වාක්‍යමිදං තස්මින අකථ්‍යත ලෝකාශ්ච තම්ප්‍රතීත්ථම් අකුර්ව්වන් ඉති තේ ස්මෘතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","ස ඉලියාසරං ශ්මශානාද් ආගන්තුම් ආහ්වතවාන් ශ්මශානාඤ්ච උදස්ථාපයද් යේ යේ ලෝකාස්තත්කර්ම්‍ය සාක්‍ෂාද් අපශ්‍යන් තේ ප්‍රමාණං දාතුම් ආරභන්ත| ");
INSERT INTO sansin_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ස ඒතාදෘශම් අද්භුතං කර්ම්මකරෝත් තස්‍ය ජනශ්‍රුතේ ර්ලෝකාස්තං සාක්‍ෂාත් කර්ත්තුම් ආගච්ඡන්| ");
INSERT INTO sansin_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","තතඃ ඵිරූශිනඃ පරස්පරං වක්තුම් ආරභන්ත යුෂ්මාකං සර්ව්වාශ්චේෂ්ටා වෘථා ජාතාඃ, ඉති කිං යූයං න බුධ්‍යධ්වේ? පශ්‍යත සර්ව්වේ ලෝකාස්තස්‍ය පශ්චාද්වර්ත්තිනෝභවන්| ");
INSERT INTO sansin_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","භජනං කර්ත්තුම් උත්සවාගතානාං ලෝකානාං කතිපයා ජනා අන්‍යදේශීයා ආසන් , ");
INSERT INTO sansin_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","තේ ගාලීලීයබෛත්සෛදානිවාසිනඃ ඵිලිපස්‍ය සමීපම් ආගත්‍ය ව්‍යාහරන් හේ මහේච්ඡ වයං යීශුං ද්‍රෂ්ටුම් ඉච්ඡාමඃ| ");
INSERT INTO sansin_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","තතඃ ඵිලිපෝ ගත්වා ආන්ද්‍රියම් අවදත් පශ්චාද් ආන්ද්‍රියඵිලිපෞ යීශවේ වාර්ත්තාම් අකථයතාං| ");
INSERT INTO sansin_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","තදා යීශුඃ ප්‍රත්‍යුදිතවාන් මානවසුතස්‍ය මහිමප්‍රාප්තිසමය උපස්ථිතඃ| ");
INSERT INTO sansin_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","අහං යුෂ්මානතියථාර්ථං වදාමි, ධාන්‍යබීජං මෘත්තිකායාං පතිත්වා යදි න මෘයතේ තර්හ්‍යේකාකී තිෂ්ඨති කින්තු යදි මෘයතේ තර්හි බහුගුණං ඵලං ඵලති| ");
INSERT INTO sansin_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","යෝ ජනේा නිජප්‍රාණාන් ප්‍රියාන් ජානාති ස තාන් හාරයිෂ්‍යති කින්තු යේा ජන ඉහලෝකේ නිජප්‍රාණාන් අප්‍රියාන් ජානාති සේाනන්තායුඃ ප්‍රාප්තුං තාන් රක්‍ෂිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","කශ්චිද් යදි මම සේවකෝ භවිතුං වාඤ්ඡති තර්හි ස මම පශ්චාද්ගාමී භවතු, තස්මාද් අහං යත්‍ර තිෂ්ඨාමි මම සේවකේाපි තත්‍ර ස්ථාස්‍යති; යෝ ජනෝ මාං සේවතේ මම පිතාපි තං සම්මංස්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","සාම්ප්‍රතං මම ප්‍රාණා ව්‍යාකුලා භවන්ති, තස්මාද් හේ පිතර ඒතස්මාත් සමයාන් මාං රක්‍ෂ, ඉත්‍යහං කිං ප්‍රාර්ථයිෂ්‍යේ? කින්ත්වහම් ඒතත්සමයාර්ථම් අවතීර්ණවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","හේ පිත: ස්වනාම්නෝ මහිමානං ප්‍රකාශය; තනෛව ස්වනාම්නෝ මහිමානම් අහං ප්‍රාකාශයං පුනරපි ප්‍රකාශයිෂ්‍යාමි, ඒෂා ගගණීයා වාණී තස්මින් සමයේ(අ)ජායත| ");
INSERT INTO sansin_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","තච්ශ්‍රුත්වා සමීපස්ථලෝකානාං කේචිද් අවදන් මේඝෝ(අ)ගර්ජීත්, කේචිද් අවදන් ස්වර්ගීයදූතෝ(අ)නේන සහ කථාමචකථත්| ");
INSERT INTO sansin_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","තදා යීශුඃ ප්‍රත්‍යවාදීත්, මදර්ථං ශබ්දෝයං නාභූත් යුෂ්මදර්ථමේවාභූත්| ");
INSERT INTO sansin_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","අධුනා ජගතෝස්‍ය විචාර: සම්පත්ස්‍යතේ, අධුනාස්‍ය ජගත: පතී රාජ්‍යාත් ච්‍යෝෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","යද්‍යඊ පෘථිව්‍යා ඌර්ද්ව්වේ ප්‍රෝත්ථාපිතෝස්මි තර්හි සර්ව්වාන් මානවාන් ස්වසමීපම් ආකර්ෂිෂ්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","කථං තස්‍ය මෘති ර්භවිෂ්‍යති, ඒතද් බෝධයිතුං ස ඉමාං කථාම් අකථයත්| ");
INSERT INTO sansin_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","තදා ලෝකා අකථයන් සෝභිෂික්තඃ සර්ව්වදා තිෂ්ඨතීති ව්‍යවස්ථාග්‍රන්ථේ ශ්‍රුතම් අස්මාභිඃ, තර්හි මනුෂ්‍යපුත්‍රඃ ප්‍රෝත්ථාපිතෝ භවිෂ්‍යතීති වාක්‍යං කථං වදසි? මනුෂ්‍යපුත්‍රෝයං කඃ? ");
INSERT INTO sansin_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","තදා යීශුරකථායද් යුෂ්මාභිඃ සාර්ද්ධම් අල්පදිනානි ජ්‍යෝතිරාස්තේ, යථා යුෂ්මාන් අන්ධකාරෝ නාච්ඡාදයති තදර්ථං යාවත්කාලං යුෂ්මාභිඃ සාර්ද්ධං ජ්‍යෝතිස්තිෂ්ඨති තාවත්කාලං ගච්ඡත; යෝ ජනෝ(අ)න්ධකාරේ ගච්ඡති ස කුත්‍ර යාතීති න ජානාති| ");
INSERT INTO sansin_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","අතඒව යාවත්කාලං යුෂ්මාකං නිකටේ ජ්‍යෝතිරාස්තේ තාවත්කාලං ජ්‍යෝතීරූපසන්තානා භවිතුං ජ්‍යෝතිෂි විශ්වසිත; ඉමාං කථාං කථයිත්වා යීශුඃ ප්‍රස්ථාය තේභ්‍යඃ ස්වං ගුප්තවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","යද්‍යපි යීශුස්තේෂාං සමක්‍ෂම් ඒතාවදාශ්චර‍්‍ය්‍යකර්ම්මාණි කෘතවාන් තථාපි තේ තස්මින් න ව්‍යශ්වසන්| ");
INSERT INTO sansin_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","අතඒව කඃ ප්‍රත්‍යේති සුසංවාදං පරේශාස්මත් ප්‍රචාරිතං? ප්‍රකාශතේ පරේශස්‍ය හස්තඃ කස්‍ය ච සන්නිධෞ? යිශයියභවිෂ්‍යද්වාදිනා යදේතද් වාක්‍යමුක්තං තත් සඵලම් අභවත්| ");
INSERT INTO sansin_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","තේ ප්‍රත්‍යේතුං නාශන්කුවන් තස්මින් යිශයියභවිෂ්‍යද්වාදි පුනරවාදීද්, ");
INSERT INTO sansin_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","යදා, \"තේ නයනෛ ර්න පශ්‍යන්ති බුද්ධිභිශ්ච න බුධ්‍යන්තේ තෛ ර්මනඃසු පරිවර්ත්තිතේෂු ච තානහං යථා ස්වස්ථාන් න කරෝමි තථා ස තේෂාං ලෝචනාන්‍යන්ධානි කෘත්වා තේෂාමන්තඃකරණානි ගාඪානි කරිෂ්‍යති| \" ");
INSERT INTO sansin_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","යිශයියෝ යදා යීශෝ ර්මහිමානං විලෝක්‍ය තස්මින් කථාමකථයත් තදා භවිෂ්‍යද්වාක්‍යම් ඊදෘශං ප්‍රකාශයත්| ");
INSERT INTO sansin_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","තථාප්‍යධිපතිනාං බහවස්තස්මින් ප්‍රත්‍යායන්| කින්තු ඵිරූශිනස්තාන් භජනගෘහාද් දූරීකුර්ව්වන්තීති භයාත් තේ තං න ස්වීකෘතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","යත ඊශ්වරස්‍ය ප්‍රශංසාතෝ මානවානාං ප්‍රශංසායාං තේ(අ)ප්‍රියන්ත| ");
INSERT INTO sansin_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","තදා යීශුරුච්චෛඃකාරම් අකථයද් යෝ ජනෝ මයි විශ්වසිති ස කේවලේ මයි විශ්වසිතීති න, ස මත්ප්‍රේරකේ(අ)පි විශ්වසිති| ");
INSERT INTO sansin_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","යෝ ජනෝ මාං පශ්‍යති ස මත්ප්‍රේරකමපි පශ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","යෝ ජනෝ මාං ප්‍රත්‍යේති ස යථාන්ධකාරේ න තිෂ්ඨති තදර්ථම් අහං ජ්‍යෝතිඃස්වරූපෝ භූත්වා ජගත්‍යස්මින් අවතීර්ණවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","මම කථාං ශ්‍රුත්වා යදි කශ්චින් න විශ්වසිති තර්හි තමහං දෝෂිණං න කරෝමි, යතෝ හේතෝ ර්ජගතෝ ජනානාං දෝෂාන් නිශ්චිතාන් කර්ත්තුං නාගත්‍ය තාන් පරිචාතුම් ආගතෝස්මි| ");
INSERT INTO sansin_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","යඃ කශ්චින් මාං න ශ්‍රද්ධාය මම කථං න ගෘහ්ලාති, අන්‍යස්තං දෝෂිණං කරිෂ්‍යති වස්තුතස්තු යාං කථාමහම් අචකථං සා කථා චරමේ(අ)න්හි තං දෝෂිණං කරිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","යතෝ හේතෝරහං ස්වතඃ කිමපි න කථයාමි, කිං කිං මයා කථයිතව්‍යං කිං සමුපදේෂ්ටව්‍යඤ්ච ඉති මත්ප්‍රේරයිතා පිතා මාමාඥාපයත්| ");
INSERT INTO sansin_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","තස්‍ය සාඥා අනන්තායුරිත්‍යහං ජානාමි, අතඒවාහං යත් කථයාමි තත් පිතා යථාඥාපයත් තථෛව කථයාම්‍යහම්| ");
INSERT INTO sansin_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","නිස්තාරෝත්සවස්‍ය කිඤ්චිත්කාලාත් පූර්ව්වං පෘථිව්‍යාඃ පිතුඃ සමීපගමනස්‍ය සමයඃ සන්නිකර්ෂෝභූද් ඉති ඥාත්වා යීශුරාප්‍රථමාද් යේෂු ජගත්ප්‍රවාසිෂ්වාත්මීයලෝකේෂ ප්‍රේම කරෝති ස්ම තේෂු ශේෂං යාවත් ප්‍රේම කෘතවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","පිතා තස්‍ය හස්තේ සර්ව්වං සමර්පිතවාන් ස්වයම් ඊශ්වරස්‍ය සමීපාද් ආගච්ඡද් ඊශ්වරස්‍ය සමීපං යාස්‍යති ච, සර්ව්වාණ්‍යේතානි ඥාත්වා රජන්‍යාං භෝජනේ සම්පූර්ණේ සති, ");
INSERT INTO sansin_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","යදා ශෛතාන් තං පරහස්තේෂු සමර්පයිතුං ශිමෝනඃ පුත්‍රස්‍ය ඊෂ්කාරියෝතියස්‍ය යිහූදා අන්තඃකරණේ කුප්‍රවෘත්තිං සමාර්පයත්, ");
INSERT INTO sansin_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","තදා යීශු ර්භෝජනාසනාද් උත්ථාය ගාත්‍රවස්ත්‍රං මෝචයිත්වා ගාත්‍රමාර්ජනවස්ත්‍රං ගෘහීත්වා තේන ස්වකටිම් අබධ්නාත්, ");
INSERT INTO sansin_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","පශ්චාද් ඒකපාත්‍රේ ජලම් අභිෂිච්‍ය ශිෂ්‍යාණාං පාදාන් ප්‍රක්‍ෂාල්‍ය තේන කටිබද්ධගාත්‍රමාර්ජනවාසසා මාර්ෂ්ටුං ප්‍රාරභත| ");
INSERT INTO sansin_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","තතඃ ශිමෝන්පිතරස්‍ය සමීපමාගතේ ස උක්තවාන් හේ ප්‍රභෝ භවාන් කිං මම පාදෞ ප්‍රක්‍ෂාලයිෂ්‍යති? ");
INSERT INTO sansin_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","යීශුරුදිතවාන් අහං යත් කරෝමි තත් සම්ප්‍රති න ජානාසි කින්තු පශ්චාජ් ඥාස්‍යසි| ");
INSERT INTO sansin_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","තතඃ පිතරඃ කථිතවාන් භවාන් කදාපි මම පාදෞ න ප්‍රක්‍ෂාලයිෂ්‍යති| යීශුරකථයද් යදි ත්වාං න ප්‍රක්‍ෂාලයේ තර්හි මයි තව කෝප්‍යංශෝ නාස්ති| ");
INSERT INTO sansin_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","තදා ශිමෝන්පිතරඃ කථිතවාන් හේ ප්‍රභෝ තර්හි කේවලපාදෞ න, මම හස්තෞ ශිරශ්ච ප්‍රක්‍ෂාලයතු| ");
INSERT INTO sansin_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","තතෝ යීශුරවදද් යෝ ජනෝ ධෞතස්තස්‍ය සර්ව්වාඞ්ගපරිෂ්කෘතත්වාත් පාදෞ විනාන්‍යාඞ්ගස්‍ය ප්‍රක්‍ෂාලනාපේක්‍ෂා නාස්ති| යූයං පරිෂ්කෘතා ඉති සත්‍යං කින්තු න සර්ව්වේ, ");
INSERT INTO sansin_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","යතෝ යෝ ජනස්තං පරකරේෂු සමර්පයිෂ්‍යති තං ස ඥාතවාන; අතඒව යූයං සර්ව්වේ න පරිෂ්කෘතා ඉමාං කථාං කථිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ඉත්ථං යීශුස්තේෂාං පාදාන් ප්‍රක්‍ෂාල්‍ය වස්ත්‍රං පරිධායාසනේ සමුපවිශ්‍ය කථිතවාන් අහං යුෂ්මාන් ප්‍රති කිං කර්ම්මාකාර්ෂං ජානීථ? ");
INSERT INTO sansin_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","යූයං මාං ගුරුං ප්‍රභුඤ්ච වදථ තත් සත්‍යමේව වදථ යතෝහං සඒව භවාමි| ");
INSERT INTO sansin_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","යද්‍යහං ප්‍රභු ර්ගුරුශ්ච සන් යුෂ්මාකං පාදාන් ප්‍රක්‍ෂාලිතවාන් තර්හි යුෂ්මාකමපි පරස්පරං පාදප්‍රක්‍ෂාලනම් උචිතම්| ");
INSERT INTO sansin_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","අහං යුෂ්මාන් ප්‍රති යථා ව්‍යවාහරං යුෂ්මාන් තථා ව්‍යවහර්ත්තුම් ඒකං පන්ථානං දර්ශිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","අහං යුෂ්මානතියථාර්ථං වදාමි, ප්‍රභෝ ර්දාසෝ න මහාන් ප්‍රේරකාච්ච ප්‍රේරිතෝ න මහාන්| ");
INSERT INTO sansin_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ඉමාං කථාං විදිත්වා යදි තදනුසාරතඃ කර්ම්මාණි කුරුථ තර්හි යූයං ධන්‍යා භවිෂ්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","සර්ව්වේෂු යුෂ්මාසු කථාමිමාං කථයාමි ඉති න, යේ මම මනෝනීතාස්තානහං ජානාමි, කින්තු මම භක්‍ෂ්‍යාණි යෝ භුඞ්ක්තේ මත්ප්‍රාණප්‍රාතිකූල්‍යතඃ| උත්ථාපයති පාදස්‍ය මූලං ස ඒෂ මානවඃ| යදේතද් ධර්ම්මපුස්තකස්‍ය වචනං තදනුසාරේණාවශ්‍යං ඝටිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","අහං ස ජන ඉත්‍යත්‍ර යථා යුෂ්මාකං විශ්වාසෝ ජායතේ තදර්ථං ඒතාදෘශඝටනාත් පූර්ව්වම් අහමිදානීං යුෂ්මභ්‍යමකථයම්| ");
INSERT INTO sansin_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","අහං යුෂ්මානතීව යථාර්ථං වදාමි, මයා ප්‍රේරිතං ජනං යෝ ගෘහ්ලාති ස මාමේව ගෘහ්ලාති යශ්ච මාං ගෘහ්ලාති ස මත්ප්‍රේරකං ගෘහ්ලාති| ");
INSERT INTO sansin_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ඒතාං කථාං කථයිත්වා යීශු ර්දුඃඛී සන් ප්‍රමාණං දත්ත්වා කථිතවාන් අහං යුෂ්මානතියථාර්ථං වදාමි යුෂ්මාකම් ඒකෝ ජනෝ මාං පරකරේෂු සමර්පයිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","තතඃ ස කමුද්දිශ්‍ය කථාමේතාං කථිතවාන් ඉත්‍යත්‍ර සන්දිග්ධාඃ ශිෂ්‍යාඃ පරස්පරං මුඛමාලෝකයිතුං ප්‍රාරභන්ත| ");
INSERT INTO sansin_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","තස්මින් සමයේ යීශු ර‍්‍යස්මින් අප්‍රීයත ස ශිෂ්‍යස්තස්‍ය වක්‍ෂඃස්ථලම් අවාලම්බත| ");
INSERT INTO sansin_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ශිමෝන්පිතරස්තං සඞ්කේතේනාවදත්, අයං කමුද්දිශ්‍ය කථාමේතාම් කථයතීති පෘච්ඡ| ");
INSERT INTO sansin_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","තදා ස යීශෝ ර්වක්‍ෂඃස්ථලම් අවලම්බ්‍ය පෘෂ්ඨවාන්, හේ ප්‍රභෝ ස ජනඃ කඃ? ");
INSERT INTO sansin_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","තතෝ යීශුඃ ප්‍රත්‍යවදද් ඒකඛණ්ඩං පූපං මජ්ජයිත්වා යස්මෛ දාස්‍යාමි සඒව සඃ; පශ්චාත් පූපඛණ්ඩමේකං මජ්ජයිත්වා ශිමෝනඃ පුත්‍රාය ඊෂ්කරියෝතීයාය යිහූදෛ දත්තවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","තස්මින් දත්තේ සති ශෛතාන් තමාශ්‍රයත්; තදා යීශුස්තම් අවදත් ත්වං යත් කරිෂ්‍යසි තත් ක්‍ෂිප්‍රං කුරු| ");
INSERT INTO sansin_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","කින්තු ස යේනාශයේන තාං කථාමකථායත් තම් උපවිෂ්ටලෝකානාං කෝපි නාබුධ්‍යත; ");
INSERT INTO sansin_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","කින්තු යිහූදාඃ සමීපේ මුද්‍රාසම්පුටකස්ථිතේඃ කේචිද් ඉත්ථම් අබුධ්‍යන්ත පාර්ව්වණාසාදනාර්ථං කිමපි ද්‍රව්‍යං ක්‍රේතුං වා දරිද්‍රේභ්‍යඃ කිඤ්චිද් විතරිතුං කථිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","තදා පූපඛණ්ඩග්‍රහණාත් පරං ස තූර්ණං බහිරගච්ඡත්; රාත්‍රිශ්ච සමුපස්‍යිතා| ");
INSERT INTO sansin_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","යිහූදේ බහිර්ගතේ යීශුරකථයද් ඉදානීං මානවසුතස්‍ය මහිමා ප්‍රකාශතේ තේනේශ්වරස්‍යාපි මහිමා ප්‍රකාශතේ| ");
INSERT INTO sansin_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","යදි තේනේශ්වරස්‍ය මහිමා ප්‍රකාශතේ තර්හීශ්වරෝපි ස්වේන තස්‍ය මහිමානං ප්‍රකාශයිෂ්‍යති තූර්ණමේව ප්‍රකාශයිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","හේ වත්සා අහං යුෂ්මාභිඃ සාර්ද්ධං කිඤ්චිත්කාලමාත්‍රම් ආසේ, තතඃ පරං මාං මෘගයිෂ්‍යධ්වේ කින්ත්වහං යත්ස්ථානං යාමි තත්ස්ථානං යූයං ගන්තුං න ශක්‍ෂ්‍යථ, යාමිමාං කථාං යිහූදීයේභ්‍යඃ කථිතවාන් තථාධුනා යුෂ්මභ්‍යමපි කථයාමි| ");
INSERT INTO sansin_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","යූයං පරස්පරං ප්‍රීයධ්වම් අහං යුෂ්මාසු යථා ප්‍රීයේ යූයමපි පරස්පරම් තථෛව ප්‍රීයධ්වං, යුෂ්මාන් ඉමාං නවීනාම් ආඥාම් ආදිශාමි| ");
INSERT INTO sansin_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","තේනෛව යදි පරස්පරං ප්‍රීයධ්වේ තර්හි ලක්‍ෂණේනානේන යූයං මම ශිෂ්‍යා ඉති සර්ව්වේ ඥාතුං ශක්‍ෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ශිමෝනපිතරඃ පෘෂ්ඨවාන් හේ ප්‍රභෝ භවාන් කුත්‍ර යාස්‍යති? තතෝ යීශුඃ ප්‍රත්‍යවදත්, අහං යත්ස්ථානං යාමි තත්ස්ථානං සාම්ප්‍රතං මම පශ්චාද් ගන්තුං න ශක්නෝෂි කින්තු පශ්චාද් ගමිෂ්‍යසි| ");
INSERT INTO sansin_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","තදා පිතරඃ ප්‍රත්‍යුදිතවාන්, හේ ප්‍රභෝ සාම්ප්‍රතං කුතෝ හේතෝස්තව පශ්චාද් ගන්තුං න ශක්නෝමි? ත්වදර්ථං ප්‍රාණාන් දාතුං ශක්නෝමි| ");
INSERT INTO sansin_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","තතෝ යීශුඃ ප්‍රත්‍යුක්තවාන් මන්නිමිත්තං කිං ප්‍රාණාන් දාතුං ශක්නෝෂි? ත්වාමහං යථාර්ථං වදාමි, කුක්කුටරවණාත් පූර්ව්වං ත්වං ත්‍රි ර්මාම් අපහ්නෝෂ්‍යසේ| ");
INSERT INTO sansin_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","මනෝදුඃඛිනෝ මා භූත; ඊශ්වරේ විශ්වසිත මයි ච විශ්වසිත| ");
INSERT INTO sansin_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","මම පිතු ගෘහේ බහූනි වාසස්ථානි සන්ති නෝ චේත් පූර්ව්වං යුෂ්මාන් අඥාපයිෂ්‍යං යුෂ්මදර්ථං ස්ථානං සජ්ජයිතුං ගච්ඡාමි| ");
INSERT INTO sansin_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","යදි ගත්වාහං යුෂ්මන්නිමිත්තං ස්ථානං සජ්ජයාමි තර්හි පනරාගත්‍ය යුෂ්මාන් ස්වසමීපං නේෂ්‍යාමි, තතෝ යත්‍රාහං තිෂ්ඨාමි තත්‍ර යූයමපි ස්ථාස්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","අහං යත්ස්ථානං බ්‍රජාමි තත්ස්ථානං යූයං ජානීථ තස්‍ය පන්ථානමපි ජානීථ| ");
INSERT INTO sansin_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","තදා ථෝමා අවදත්, හේ ප්‍රභෝ භවාන් කුත්‍ර යාති තද්වයං න ජානීමඃ, තර්හි කථං පන්ථානං ඥාතුං ශක්නුමඃ? ");
INSERT INTO sansin_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","යීශුරකථයද් අහමේව සත්‍යජීවනරූපපථෝ මයා න ගන්තා කෝපි පිතුඃ සමීපං ගන්තුං න ශක්නෝති| ");
INSERT INTO sansin_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","යදි මාම් අඥාස්‍යත තර්හි මම පිතරමප්‍යඥාස්‍යත කින්ත්වධුනාතස්තං ජානීථ පශ්‍යථ ච| ");
INSERT INTO sansin_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","තදා ඵිලිපඃ කථිතවාන්, හේ ප්‍රභෝ පිතරං දර්ශය තස්මාදස්මාකං යථේෂ්ටං භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","තතෝ යීශුඃ ප්‍රත්‍යාවාදීත්, හේ ඵිලිප යුෂ්මාභිඃ සාර්ද්ධම් ඒතාවද්දිනානි ස්ථිතමපි මාං කිං න ප්‍රත්‍යභිජානාසි? යෝ ජනෝ මාම් අපශ්‍යත් ස පිතරමප්‍යපශ්‍යත් තර්හි පිතරම් අස්මාන් දර්ශයේති කථාං කථං කථයසි? ");
INSERT INTO sansin_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","අහං පිතරි තිෂ්ඨාමි පිතා මයි තිෂ්ඨතීති කිං ත්වං න ප්‍රත්‍යෂි? අහං යද්වාක්‍යං වදාමි තත් ස්වතෝ න වදාමි කින්තු යඃ පිතා මයි විරාජතේ ස ඒව සර්ව්වකර්ම්මාණි කරාති| ");
INSERT INTO sansin_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","අතඒව පිතර‍්‍ය්‍යහං තිෂ්ඨාමි පිතා ච මයි තිෂ්ඨති මමාස්‍යාං කථායාං ප්‍රත්‍යයං කුරුත, නෝ චේත් කර්ම්මහේතෝඃ ප්‍රත්‍යයං කුරුත| ");
INSERT INTO sansin_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","අහං යුෂ්මානතියථාර්ථං වදාමි, යෝ ජනෝ මයි විශ්වසිති සෝහමිව කර්ම්මාණි කරිෂ්‍යති වරං තතෝපි මහාකර්ම්මාණි කරිෂ්‍යති යතෝ හේතෝරහං පිතුඃ සමීපං ගච්ඡාමි| ");
INSERT INTO sansin_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","යථා පුත්‍රේණ පිතු ර්මහිමා ප්‍රකාශතේ තදර්ථං මම නාම ප්‍රෝච්‍ය යත් ප්‍රාර්ථයිෂ්‍යධ්වේ තත් සඵලං කරිෂ්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","යදි මම නාම්නා යත් කිඤ්චිද් යාචධ්වේ තර්හි තදහං සාධයිෂ්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","යදි මයි ප්‍රීයධ්වේ තර්හි මමාඥාඃ සමාචරත| ");
INSERT INTO sansin_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","තතෝ මයා පිතුඃ සමීපේ ප්‍රාර්ථිතේ පිතා නිරන්තරං යුෂ්මාභිඃ සාර්ද්ධං ස්ථාතුම් ඉතරමේකං සහායම් අර්ථාත් සත්‍යමයම් ආත්මානං යුෂ්මාකං නිකටං ප්‍රේෂයිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ඒතජ්ජගතෝ ලෝකාස්තං ග්‍රහීතුං න ශක්නුවන්ති යතස්තේ තං නාපශ්‍යන් නාජනංශ්ච කින්තු යූයං ජානීථ යතෝ හේතෝඃ ස යුෂ්මාකමන්ත ර්නිවසති යුෂ්මාකං මධ්‍යේ ස්ථාස්‍යති ච| ");
INSERT INTO sansin_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","අහං යුෂ්මාන් අනාථාන් කෘත්වා න යාස්‍යාමි පුනරපි යුෂ්මාකං සමීපම් ආගමිෂ්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","කියත්කාලරත් පරම් අස්‍ය ජගතෝ ලෝකා මාං පුන ර්න ද්‍රක්‍ෂ්‍යන්ති කින්තු යූයං ද්‍රක්‍ෂ්‍යථ;අහං ජීවිෂ්‍යාමි තස්මාත් කාරණාද් යූයමපි ජීවිෂ්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","පිතර‍්‍ය්‍යහමස්මි මයි ච යූයං ස්ථ, තථාහං යුෂ්මාස්වස්මි තදපි තදා ඥාස්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","යෝ ජනෝ මමාඥා ගෘහීත්වා තා ආචරති සඒව මයි ප්‍රීයතේ; යෝ ජනශ්ච මයි ප්‍රීයතේ සඒව මම පිතුඃ ප්‍රියපාත්‍රං භවිෂ්‍යති, තථාහමපි තස්මින් ප්‍රීත්වා තස්මෛ ස්වං ප්‍රකාශයිෂ්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","තදා ඊෂ්කරියෝතීයාද් අන්‍යෝ යිහූදාස්තමවදත්, හේ ප්‍රභෝ භවාන් ජගතෝ ලෝකානාං සන්නිධෞ ප්‍රකාශිතෝ න භූත්වාස්මාකං සන්නිධෞ කුතඃ ප්‍රකාශිතෝ භවිෂ්‍යති? ");
INSERT INTO sansin_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","තතෝ යීශුඃ ප්‍රත්‍යුදිතවාන්, යෝ ජනෝ මයි ප්‍රීයතේ ස මමාඥා අපි ගෘහ්ලාති, තේන මම පිතාපි තස්මින් ප්‍රේෂ්‍යතේ, ආවාඤ්ච තන්නිකටමාගත්‍ය තේන සහ නිවත්ස්‍යාවඃ| ");
INSERT INTO sansin_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","යෝ ජනෝ මයි න ප්‍රීයතේ ස මම කථා අපි න ගෘහ්ලාති පුනශ්ච යාමිමාං කථාං යූයං ශෘණුථ සා කථා කේවලස්‍ය මම න කින්තු මම ප්‍රේරකෝ යඃ පිතා තස්‍යාපි කථා| ");
INSERT INTO sansin_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","ඉදානීං යුෂ්මාකං නිකටේ විද්‍යමානෝහම් ඒතාඃ සකලාඃ කථාඃ කථයාමි| ");
INSERT INTO sansin_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","කින්ත්විතඃ පරං පිත්‍රා යඃ සහායෝ(අ)ර්ථාත් පවිත්‍ර ආත්මා මම නාම්නි ප්‍රේරයිෂ්‍යති ස සර්ව්වං ශික්‍ෂයිත්වා මයෝක්තාඃ සමස්තාඃ කථා යුෂ්මාන් ස්මාරයිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","අහං යුෂ්මාකං නිකටේ ශාන්තිං ස්ථාපයිත්වා යාමි, නිජාං ශාන්තිං යුෂ්මභ්‍යං දදාමි, ජගතෝ ලෝකා යථා දදාති තථාහං න දදාමි; යුෂ්මාකම් අන්තඃකරණානි දුඃඛිතානි භීතානි ච න භවන්තු| ");
INSERT INTO sansin_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","අහං ගත්වා පුනරපි යුෂ්මාකං සමීපම් ආගමිෂ්‍යාමි මයෝක්තං වාක්‍යමිදං යූයම් අශ්‍රෞෂ්ට; යදි මය්‍යප්‍රේෂ්‍යධ්වං තර්හ්‍යහං පිතුඃ සමීපං ගච්ඡාමි මමාස්‍යාං කථායාං යූයම් අහ්ලාදිෂ්‍යධ්වං යතෝ මම පිතා මත්තෝපි මහාන්| ");
INSERT INTO sansin_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","තස්‍යා ඝටනායාඃ සමයේ යථා යුෂ්මාකං ශ්‍රද්ධා ජායතේ තදර්ථම් අහං තස්‍යා ඝටනායාඃ පූර්ව්වම් ඉදානීං යුෂ්මාන් ඒතාං වාර්ත්තාං වදාමි| ");
INSERT INTO sansin_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ඉතඃ පරං යුෂ්මාභිඃ සහ මම බහව ආලාපා න භවිෂ්‍යන්ති යතඃ කාරණාද් ඒතස්‍ය ජගතඃ පතිරාගච්ඡති කින්තු මයා සහ තස්‍ය කෝපි සම්බන්ධෝ නාස්ති| ");
INSERT INTO sansin_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","අහං පිතරි ප්‍රේම කරෝමි තථා පිතු ර්විධිවත් කර්ම්මාණි කරෝමීති යේන ජගතෝ ලෝකා ජානන්ති තදර්ථම් උත්තිෂ්ඨත වයං ස්ථානාදස්මාද් ගච්ඡාම| ");
INSERT INTO sansin_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","අහං සත්‍යද්‍රාක්‍ෂාලතාස්වරූපෝ මම පිතා තූද්‍යානපරිචාරකස්වරූපඤ්ච| ");
INSERT INTO sansin_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","මම යාසු ශාඛාසු ඵලානි න භවන්ති තාඃ ස ඡිනත්ති තථා ඵලවත්‍යඃ ශාඛා යථාධිකඵලානි ඵලන්ති තදර්ථං තාඃ පරිෂ්කරෝති| ");
INSERT INTO sansin_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ඉදානීං මයෝක්තෝපදේශේන යූයං පරිෂ්කෘතාඃ| ");
INSERT INTO sansin_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","අතඃ කාරණාත් මයි තිෂ්ඨත තේනාහමපි යුෂ්මාසු තිෂ්ඨාමි, යතෝ හේතෝ ර්ද්‍රාක්‍ෂාලතායාම් අසංලග්නා ශාඛා යථා ඵලවතී භවිතුං න ශක්නෝති තථා යූයමපි මය්‍යතිෂ්ඨන්තඃ ඵලවන්තෝ භවිතුං න ශක්නුථ| ");
INSERT INTO sansin_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","අහං ද්‍රාක්‍ෂාලතාස්වරූපෝ යූයඤ්ච ශාඛාස්වරූපෝඃ; යෝ ජනෝ මයි තිෂ්ඨති යත්‍ර චාහං තිෂ්ඨාමි, ස ප්‍රචූරඵලෛඃ ඵලවාන් භවති, කින්තු මාං විනා යූයං කිමපි කර්ත්තුං න ශක්නුථ| ");
INSERT INTO sansin_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","යඃ කශ්චින් මයි න තිෂ්ඨති ස ශුෂ්කශාඛේව බහි ර්නික්‍ෂිප්‍යතේ ලෝකාශ්ච තා ආහෘත්‍ය වහ්නෞ නික්‍ෂිප්‍ය දාහයන්ති| ");
INSERT INTO sansin_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","යදි යූයං මයි තිෂ්ඨථ මම කථා ච යුෂ්මාසු තිෂ්ඨති තර්හි යද් වාඤ්ඡිත්වා යාචිෂ්‍යධ්වේ යුෂ්මාකං තදේව සඵලං භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","යදි යූයං ප්‍රචූරඵලවන්තෝ භවථ තර්හි තද්වාරා මම පිතු ර්මහිමා ප්‍රකාශිෂ්‍යතේ තථා යූයං මම ශිෂ්‍යා ඉති පරික්‍ෂායිෂ්‍යධ්වේ| ");
INSERT INTO sansin_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","පිතා යථා මයි ප්‍රීතවාන් අහමපි යුෂ්මාසු තථා ප්‍රීතවාන් අතෝ හේතෝ ර‍්‍යූයං නිරන්තරං මම ප්‍රේමපාත්‍රාණි භූත්වා තිෂ්ඨත| ");
INSERT INTO sansin_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","අහං යථා පිතුරාඥා ගෘහීත්වා තස්‍ය ප්‍රේමභාජනං තිෂ්ඨාමි තථෛව යූයමපි යදි මමාඥා ගුහ්ලීථ තර්හි මම ප්‍රේමභාජනානි ස්ථාස්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","යුෂ්මන්නිමිත්තං මම ය ආහ්ලාදඃ ස යථා චිරං තිෂ්ඨති යුෂ්මාකම් ආනන්දශ්ච යථා පූර‍්‍ය්‍යතේ තදර්ථං යුෂ්මභ්‍යම් ඒතාඃ කථා අත්‍රකථම්| ");
INSERT INTO sansin_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","අහං යුෂ්මාසු යථා ප්‍රීයේ යූයමපි පරස්පරං තථා ප්‍රීයධ්වම් ඒෂා මමාඥා| ");
INSERT INTO sansin_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","මිත්‍රාණාං කාරණාත් ස්වප්‍රාණදානපර‍්‍ය්‍යන්තං යත් ප්‍රේම තස්මාන් මහාප්‍රේම කස්‍යාපි නාස්ති| ");
INSERT INTO sansin_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","අහං යද්‍යද් ආදිශාමි තත්තදේව යදි යූයම් ආචරත තර්හි යූයමේව මම මිත්‍රාණි| ");
INSERT INTO sansin_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","අද්‍යාරභ්‍ය යුෂ්මාන් දාසාන් න වදිෂ්‍යාමි යත් ප්‍රභු ර‍්‍යත් කරෝති දාසස්තද් න ජානාති; කින්තු පිතුඃ සමීපේ යද්‍යද් අශෘණවං තත් සර්ව්වං යූෂ්මාන් අඥාපයම් තත්කාරණාද් යුෂ්මාන් මිත්‍රාණි ප්‍රෝක්තවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","යූයං මාං රෝචිතවන්ත ඉති න, කින්ත්වහමේව යුෂ්මාන් රෝචිතවාන් යූයං ගත්වා යථා ඵලාන්‍යුත්පාදයථ තානි ඵලානි චාක්‍ෂයාණි භවන්ති, තදර්ථං යුෂ්මාන් න්‍යජුනජං තස්මාන් මම නාම ප්‍රෝච්‍ය පිතරං යත් කිඤ්චිද් යාචිෂ්‍යධ්වේ තදේව ස යුෂ්මභ්‍යං දාස්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","යූයං පරස්පරං ප්‍රීයධ්වම් අහම් ඉත්‍යාඥාපයාමි| ");
INSERT INTO sansin_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","ජගතෝ ලෝකෛ ර‍්‍යුෂ්මාසු ඍතීයිතේෂු තේ පූර්ව්වං මාමේවාර්ත්තීයන්ත ඉති යූයං ජානීථ| ");
INSERT INTO sansin_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","යදි යූයං ජගතෝ ලෝකා අභවිෂ්‍යත තර්හි ජගතෝ ලෝකා යුෂ්මාන් ආත්මීයාන් බුද්ධ්වාප්‍රේෂ්‍යන්ත; කින්තු යූයං ජගතෝ ලෝකා න භවථ, අහං යුෂ්මාන් අස්මාජ්ජගතෝ(අ)රෝචයම් ඒතස්මාත් කාරණාජ්ජගතෝ ලෝකා යුෂ්මාන් ඍතීයන්තේ| ");
INSERT INTO sansin_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","දාසඃ ප්‍රභෝ ර්මහාන් න භවති මමෛතත් පූර්ව්වීයං වාක්‍යං ස්මරත; තේ යදි මාමේවාතාඩයන් තර්හි යුෂ්මානපි තාඩයිෂ්‍යන්ති, යදි මම වාක්‍යං ගෘහ්ලන්ති තර්හි යුෂ්මාකමපි වාක්‍යං ග්‍රහීෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","කින්තු තේ මම නාමකාරණාද් යුෂ්මාන් ප්‍රති තාදෘශං ව්‍යවහරිෂ්‍යන්ති යතෝ යෝ මාං ප්‍රේරිතවාන් තං තේ න ජානන්ති| ");
INSERT INTO sansin_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","තේෂාං සන්නිධිම් ආගත්‍ය යද්‍යහං නාකථයිෂ්‍යං තර්හි තේෂාං පාපං නාභවිෂ්‍යත් කින්ත්වධුනා තේෂාං පාපමාච්ඡාදයිතුම් උපායෝ නාස්ති| ");
INSERT INTO sansin_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","යෝ ජනෝ මාම් ඍතීයතේ ස මම පිතරමපි ඍතීයතේ| ");
INSERT INTO sansin_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","යාදෘශානි කර්ම්මාණි කේනාපි කදාපි නාක්‍රියන්ත තාදෘශානි කර්ම්මාණි යදි තේෂාං සාක්‍ෂාද් අහං නාකරිෂ්‍යං තර්හි තේෂාං පාපං නාභවිෂ්‍යත් කින්ත්වධුනා තේ දෘෂ්ට්වාපි මාං මම පිතරඤ්චාර්ත්තීයන්ත| ");
INSERT INTO sansin_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","තස්මාත් තේ(අ)කාරණං මාම් ඍතීයන්තේ යදේතද් වචනං තේෂාං ශාස්ත්‍රේ ලිඛිතමාස්තේ තත් සඵලම් අභවත්| ");
INSERT INTO sansin_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","කින්තු පිතු ර්නිර්ගතං යං සහායමර්ථාත් සත්‍යමයම් ආත්මානං පිතුඃ සමීපාද් යුෂ්මාකං සමීපේ ප්‍රේෂයිෂ්‍යාමි ස ආගත්‍ය මයි ප්‍රමාණං දාස්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","යූයං ප්‍රථමමාරභ්‍ය මයා සාර්ද්ධං තිෂ්ඨථ තස්මාද්ධේතෝ ර‍්‍යූයමපි ප්‍රමාණං දාස්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","යුෂ්මාකං යථා වාධා න ජායතේ තදර්ථං යුෂ්මාන් ඒතානි සර්ව්වවාක්‍යානි ව්‍යාහරං| ");
INSERT INTO sansin_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ලෝකා යුෂ්මාන් භජනගෘහේභ්‍යෝ දූරීකරිෂ්‍යන්ති තථා යස්මින් සමයේ යුෂ්මාන් හත්වා ඊශ්වරස්‍ය තුෂ්ටි ජනකං කර්ම්මාකුර්ම්ම ඉති මංස්‍යන්තේ ස සමය ආගච්ඡන්ති| ");
INSERT INTO sansin_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","තේ පිතරං මාඤ්ච න ජානන්ති, තස්මාද් යුෂ්මාන් ප්‍රතීදෘශම් ආචරිෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","අතෝ හේතාඃ සමයේ සමුපස්ථිතේ යථා මම කථා යුෂ්මාකං මනඃසුඃ සමුපතිෂ්ඨති තදර්ථං යුෂ්මාභ්‍යම් ඒතාං කථාං කථයාමි යුෂ්මාභිඃ සාර්ද්ධම් අහං තිෂ්ඨන් ප්‍රථමං තාං යුෂ්මභ්‍යං නාකථයං| ");
INSERT INTO sansin_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","සාම්ප්‍රතං ස්වස්‍ය ප්‍රේරයිතුඃ සමීපං ගච්ඡාමි තථාපි ත්වං ක්ක ගච්ඡසි කථාමේතාං යුෂ්මාකං කෝපි මාං න පෘච්ඡති| ");
INSERT INTO sansin_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","කින්තු මයෝක්තාභිරාභිඃ කථාභි ර‍්‍යූෂ්මාකම් අන්තඃකරණානි දුඃඛේන පූර්ණාන්‍යභවන්| ");
INSERT INTO sansin_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","තථාප්‍යහං යථාර්ථං කථයාමි මම ගමනං යුෂ්මාකං හිතාර්ථමේව, යතෝ හේතෝ ර්ගමනේ න කෘතේ සහායෝ යුෂ්මාකං සමීපං නාගමිෂ්‍යති කින්තු යදි ගච්ඡාමි තර්හි යුෂ්මාකං සමීපේ තං ප්‍රේෂයිෂ්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","තතඃ ස ආගත්‍ය පාපපුණ්‍යදණ්ඩේෂු ජගතෝ ලෝකානාං ප්‍රබෝධං ජනයිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","තේ මයි න විශ්වසන්ති තස්මාද්ධේතෝඃ පාපප්‍රබෝධං ජනයිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","යුෂ්මාකම් අදෘශ්‍යඃ සන්නහං පිතුඃ සමීපං ගච්ඡාමි තස්මාද් පුණ්‍යේ ප්‍රබෝධං ජනයිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ඒතජ්ජගතෝ(අ)ධිපති ර්දණ්ඩාඥාං ප්‍රාප්නෝති තස්මාද් දණ්ඩේ ප්‍රබෝධං ජනයිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","යුෂ්මභ්‍යං කථයිතුං මමානේකාඃ කථා ආසතේ, තාඃ කථා ඉදානීං යූයං සෝඪුං න ශක්නුථ; ");
INSERT INTO sansin_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","කින්තු සත්‍යමය ආත්මා යදා සමාගමිෂ්‍යති තදා සර්ව්වං සත්‍යං යුෂ්මාන් නේෂ්‍යති, ස ස්වතඃ කිමපි න වදිෂ්‍යති කින්තු යච්ඡ්‍රෝෂ්‍යති තදේව කථයිත්වා භාවිකාර‍්‍ය්‍යං යුෂ්මාන් ඥාපයිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","මම මහිමානං ප්‍රකාශයිෂ්‍යති යතෝ මදීයාං කථාං ගෘහීත්වා යුෂ්මාන් බෝධයිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","පිතු ර‍්‍යද්‍යද් ආස්තේ තත් සර්ව්වං මම තස්මාද් කාරණාද් අවාදිෂං ස මදීයාං කථාං ගෘහීත්වා යුෂ්මාන් බෝධයිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","කියත්කාලාත් පරං යූයං මාං ද්‍රෂ්ටුං න ලප්ස්‍යධ්වේ කින්තු කියත්කාලාත් පරං පුන ර්ද්‍රෂ්ටුං ලප්ස්‍යධ්වේ යතෝහං පිතුඃ සමීපං ගච්ඡාමි| ");
INSERT INTO sansin_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","තතඃ ශිෂ්‍යාණාං කියන්තෝ ජනාඃ පරස්පරං වදිතුම් ආරභන්ත, කියත්කාලාත් පරං මාං ද්‍රෂ්ටුං න ලප්ස්‍යධ්වේ කින්තු කියත්කාලාත් පරං පුන ර්ද්‍රෂ්ටුං ලප්ස්‍යධ්වේ යතෝහං පිතුඃ සමීපං ගච්ඡාමි, ඉති යද් වාක්‍යම් අයං වදති තත් කිං? ");
INSERT INTO sansin_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","තතඃ කියත්කාලාත් පරම් ඉති තස්‍ය වාක්‍යං කිං? තස්‍ය වාක්‍යස්‍යාභිප්‍රායං වයං බෝද්ධුං න ශක්නුමස්තෛරිති ");
INSERT INTO sansin_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","නිගදිතේ යීශුස්තේෂාං ප්‍රශ්නේච්ඡාං ඥාත්වා තේභ්‍යෝ(අ)කථයත් කියත්කාලාත් පරං මාං ද්‍රෂ්ටුං න ලප්ස්‍යධ්වේ, කින්තු කියත්කාලාත් පරං පූන ර්ද්‍රෂ්ටුං ලප්ස්‍යධ්වේ, යාමිමාං කථාමකථයං තස්‍යා අභිප්‍රායං කිං යූයං පරස්පරං මෘගයධ්වේ? ");
INSERT INTO sansin_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","යුෂ්මානහම් අතියථාර්ථං වදාමි යූයං ක්‍රන්දිෂ්‍යථ විලපිෂ්‍යථ ච, කින්තු ජගතෝ ලෝකා ආනන්දිෂ්‍යන්ති; යූයං ශෝකාකුලා භවිෂ්‍යථ කින්තු ශෝකාත් පරං ආනන්දයුක්තා භවිෂ්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","ප්‍රසවකාල උපස්ථිතේ නාරී යථා ප්‍රසවවේදනයා ව්‍යාකුලා භවති කින්තු පුත්‍රේ භූමිෂ්ඨේ සති මනුෂ්‍යෛකෝ ජන්මනා නරලෝකේ ප්‍රවිෂ්ට ඉත්‍යානන්දාත් තස්‍යාස්තත්සර්ව්වං දුඃඛං මනසි න තිෂ්ඨති, ");
INSERT INTO sansin_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","තථා යූයමපි සාම්ප්‍රතං ශෝකාකුලා භවථ කින්තු පුනරපි යුෂ්මභ්‍යං දර්ශනං දාස්‍යාමි තේන යුෂ්මාකම් අන්තඃකරණානි සානන්දානි භවිෂ්‍යන්ති, යුෂ්මාකං තම් ආනන්දඤ්ච කෝපි හර්ත්තුං න ශක්‍ෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","තස්මින් දිවසේ කාමපි කථාං මාං න ප්‍රක්‍ෂ්‍යථ| යුෂ්මානහම් අතියථාර්ථං වදාමි, මම නාම්නා යත් කිඤ්චිද් පිතරං යාචිෂ්‍යධ්වේ තදේව ස දාස්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","පූර්ව්වේ මම නාම්නා කිමපි නායාචධ්වං, යාචධ්වං තතඃ ප්‍රාප්ස්‍යථ තස්මාද් යුෂ්මාකං සම්පූර්ණානන්දෝ ජනිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","උපමාකථාභිඃ සර්ව්වාණ්‍යේතානි යුෂ්මාන් ඥාපිතවාන් කින්තු යස්මින් සමයේ උපමයා නෝක්ත්වා පිතුඃ කථාං ස්පෂ්ටං ඥාපයිෂ්‍යාමි සමය ඒතාදෘශ ආගච්ඡති| ");
INSERT INTO sansin_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","තදා මම නාම්නා ප්‍රාර්ථයිෂ්‍යධ්වේ (අ)හං යුෂ්මන්නිමිත්තං පිතරං විනේෂ්‍යේ කථාමිමාං න වදාමි; ");
INSERT INTO sansin_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","යතෝ යූයං මයි ප්‍රේම කුරුථ, තථාහම් ඊශ්වරස්‍ය සමීපාද් ආගතවාන් ඉත්‍යපි ප්‍රතීථ, තස්මාද් කාරණාත් කාරණාත් පිතා ස්වයං යුෂ්මාසු ප්‍රීයතේ| ");
INSERT INTO sansin_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","පිතුඃ සමීපාජ්ජජද් ආගතෝස්මි ජගත් පරිත්‍යජ්‍ය ච පුනරපි පිතුඃ සමීපං ගච්ඡාමි| ");
INSERT INTO sansin_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","තදා ශිෂ්‍යා අවදන්, හේ ප්‍රභෝ භවාන් උපමයා නෝක්ත්වාධුනා ස්පෂ්ටං වදති| ");
INSERT INTO sansin_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","භවාන් සර්ව්වඥඃ කේනචිත් පෘෂ්ටෝ භවිතුමපි භවතඃ ප්‍රයෝජනං නාස්තීත්‍යධුනාස්මාකං ස්ථිරඥානං ජාතං තස්මාද් භවාන් ඊශ්වරස්‍ය සමීපාද් ආගතවාන් ඉත්‍යත්‍ර වයං විශ්වසිමඃ| ");
INSERT INTO sansin_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","තතෝ යීශුඃ ප්‍රත්‍යවාදීද් ඉදානීං කිං යූයං විශ්වසිථ? ");
INSERT INTO sansin_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","පශ්‍යත සර්ව්වේ යූයං විකීර්ණාඃ සන්තෝ මාම් ඒකාකිනං පීරත්‍යජ්‍ය ස්වං ස්වං ස්ථානං ගමිෂ්‍යථ, ඒතාදෘශඃ සමය ආගච්ඡති වරං ප්‍රායේණෝපස්ථිතවාන්; තථාප්‍යහං නෛකාකී භවාමි යතඃ පිතා මයා සාර්ද්ධම් ආස්තේ| ");
INSERT INTO sansin_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","යථා මයා යුෂ්මාකං ශාන්ති ර්ජායතේ තදර්ථම් ඒතාඃ කථා යුෂ්මභ්‍යම් අචකථං; අස්මින් ජගති යුෂ්මාකං ක්ලේශෝ ඝටිෂ්‍යතේ කින්ත්වක්‍ෂෝභා භවත යතෝ මයා ජගජ්ජිතං| ");
INSERT INTO sansin_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","තතඃ පරං යීශුරේතාඃ කථාඃ කථයිත්වා ස්වර්ගං විලෝක්‍යෛතත් ප්‍රාර්ථයත්, හේ පිතඃ සමය උපස්ථිතවාන්; යථා තව පුත්‍රස්තව මහිමානං ප්‍රකාශයති තදර්ථං ත්වං නිජපුත්‍රස්‍ය මහිමානං ප්‍රකාශය| ");
INSERT INTO sansin_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ත්වං යෝල්ලෝකාන් තස්‍ය හස්තේ සමර්පිතවාන් ස යථා තේභ්‍යෝ(අ)නන්තායු ර්දදාති තදර්ථං ත්වං ප්‍රාණිමාත්‍රාණාම් අධිපතිත්වභාරං තස්මෛ දත්තවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","යස්ත්වම් අද්විතීයඃ සත්‍ය ඊශ්වරස්ත්වයා ප්‍රේරිතශ්ච යීශුඃ ඛ්‍රීෂ්ට ඒතයෝරුභයෝඃ පරිචයේ ප්‍රාප්තේ(අ)නන්තායු ර්භවති| ");
INSERT INTO sansin_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ත්වං යස්‍ය කර්ම්මණෝ භාරං මහ්‍යං දත්තවාන්, තත් සම්පන්නං කෘත්වා ජගත්‍යස්මින් තව මහිමානං ප්‍රාකාශයං| ");
INSERT INTO sansin_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","අතඒව හේ පිත ර්ජගත්‍යවිද්‍යමානේ ත්වයා සහ තිෂ්ඨතෝ මම යෝ මහිමාසීත් සම්ප්‍රති තව සමීපේ මාං තං මහිමානං ප්‍රාපය| ");
INSERT INTO sansin_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","අන්‍යච්ච ත්වම් ඒතජ්ජගතෝ යාල්ලෝකාන් මහ්‍යම් අදදා අහං තේභ්‍යස්තව නාම්නස්තත්ත්වඥානම් අදදාං, තේ තවෛවාසන්, ත්වං තාන් මහ්‍යමදදාඃ, තස්මාත්තේ තවෝපදේශම් අගෘහ්ලන්| ");
INSERT INTO sansin_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ත්වං මහ්‍යං යත් කිඤ්චිද් අදදාස්තත්සර්ව්වං ත්වත්තෝ ජායතේ ඉත්‍යධුනාජානන්| ");
INSERT INTO sansin_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","මහ්‍යං යමුපදේශම් අදදා අහමපි තේභ්‍යස්තමුපදේශම් අදදාං තේපි තමගෘහ්ලන් ත්වත්තෝහං නිර්ගත්‍ය ත්වයා ප්‍රේරිතෝභවම් අත්‍ර ච ව්‍යශ්වසන්| ");
INSERT INTO sansin_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","තේෂාමේව නිමිත්තං ප්‍රාර්ථයේ(අ)හං ජගතෝ ලෝකනිමිත්තං න ප්‍රාර්ථයේ කින්තු යාල්ලෝකාන් මහ්‍යම් අදදාස්තේෂාමේව නිමිත්තං ප්‍රාර්ථයේ(අ)හං යතස්තේ තවෛවාසතේ| ");
INSERT INTO sansin_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","යේ මම තේ තව යේ ච තව තේ මම තථා තෛ ර්මම මහිමා ප්‍රකාශ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","සාම්ප්‍රතම් අස්මින් ජගති මමාවස්ථිතේඃ ශේෂම් අභවත් අහං තව සමීපං ගච්ඡාමි කින්තු තේ ජගති ස්ථාස්‍යන්ති; හේ පවිත්‍ර පිතරාවයෝ ර‍්‍යථෛකත්වමාස්තේ තථා තේෂාමප්‍යේකත්වං භවති තදර්ථං යාල්ලෝකාන් මහ්‍යම් අදදාස්තාන් ස්වනාම්නා රක්‍ෂ| ");
INSERT INTO sansin_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","යාවන්ති දිනානි ජගත්‍යස්මින් තෛඃ සහාහමාසං තාවන්ති දිනානි තාන් තව නාම්නාහං රක්‍ෂිතවාන්; යාල්ලෝකාන් මහ්‍යම් අදදාස්තාන් සර්ව්වාන් අහමරක්‍ෂං, තේෂාං මධ්‍යේ කේවලං විනාශපාත්‍රං හාරිතං තේන ධර්ම්මපුස්තකස්‍ය වචනං ප්‍රත්‍යක්‍ෂං භවති| ");
INSERT INTO sansin_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","කින්ත්වධුනා තව සන්නිධිං ගච්ඡාමි මයා යථා තේෂාං සම්පූර්ණානන්දෝ භවති තදර්ථමහං ජගති තිෂ්ඨන් ඒතාඃ කථා අකථයම්| ");
INSERT INTO sansin_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","තවෝපදේශං තේභ්‍යෝ(අ)දදාං ජගතා සහ යථා මම සම්බන්ධෝ නාස්ති තථා ජජතා සහ තේෂාමපි සම්බන්ධාභාවාජ් ජගතෝ ලෝකාස්තාන් ඍතීයන්තේ| ");
INSERT INTO sansin_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ත්වං ජගතස්තාන් ගෘහාණේති න ප්‍රාර්ථයේ කින්ත්වශුභාද් රක්‍ෂේති ප්‍රාර්ථයේහම්| ");
INSERT INTO sansin_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","අහං යථා ජගත්සම්බන්ධීයෝ න භවාමි තථා තේපි ජගත්සම්බන්ධීයා න භවන්ති| ");
INSERT INTO sansin_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","තව සත්‍යකථයා තාන් පවිත්‍රීකුරු තව වාක්‍යමේව සත්‍යං| ");
INSERT INTO sansin_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ත්වං යථා මාං ජගති ප්‍රෛරයස්තථාහමපි තාන් ජගති ප්‍රෛරයං| ");
INSERT INTO sansin_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","තේෂාං හිතාර්ථං යථාහං ස්වං පවිත්‍රීකරෝමි තථා සත්‍යකථයා තේපි පවිත්‍රීභවන්තු| ");
INSERT INTO sansin_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","කේවලං ඒතේෂාමර්ථේ ප්‍රාර්ථයේ(අ)හම් ඉති න කින්ත්වේතේෂාමුපදේශේන යේ ජනා මයි විශ්වසිෂ්‍යන්ති තේෂාමප්‍යර්ථේ ප්‍රාර්ථේයේ(අ)හම්| ");
INSERT INTO sansin_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","හේ පිතස්තේෂාං සර්ව්වේෂාම් ඒකත්වං භවතු තව යථා මයි මම ච යථා ත්වය්‍යේකත්වං තථා තේෂාමප්‍යාවයෝරේකත්වං භවතු තේන ත්වං මාං ප්‍රේරිතවාන් ඉති ජගතෝ ලෝකාඃ ප්‍රතියන්තු| ");
INSERT INTO sansin_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","යථාවයෝරේකත්වං තථා තේෂාමප්‍යේකත්වං භවතු තේෂ්වහං මයි ච ත්වම් ඉත්ථං තේෂාං සම්පූර්ණමේකත්වං භවතු, ත්වං ප්‍රේරිතවාන් ත්වං මයි යථා ප්‍රීයසේ ච තථා තේෂ්වපි ප්‍රීතවාන් ඒතද්‍යථා ජගතෝ ලෝකා ජානන්ති ");
INSERT INTO sansin_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","තදර්ථං ත්වං යං මහිමානං මහ්‍යම් අදදාස්තං මහිමානම් අහමපි තේභ්‍යෝ දත්තවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","හේ පිත ර්ජගතෝ නිර්ම්මාණාත් පූර්ව්වං මයි ස්නේහං කෘත්වා යං මහිමානං දත්තවාන් මම තං මහිමානං යථා තේ පශ්‍යන්ති තදර්ථං යාල්ලෝකාන් මහ්‍යං දත්තවාන් අහං යත්‍ර තිෂ්ඨාමි තේපි යථා තත්‍ර තිෂ්ඨන්ති මමෛෂා වාඤ්ඡා| ");
INSERT INTO sansin_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","හේ යථාර්ථික පිත ර්ජගතෝ ලෝකෛස්ත්වය්‍යඥාතේපි ත්වාමහං ජානේ ත්වං මාං ප්‍රේරිතවාන් ඉතීමේ ශිෂ්‍යා ජානන්ති| ");
INSERT INTO sansin_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","යථාහං තේෂු තිෂ්ඨාමි තථා මයි යේන ප්‍රේම්නා ප්‍රේමාකරෝස්තත් තේෂු තිෂ්ඨති තදර්ථං තව නාමාහං තාන් ඥාපිතවාන් පුනරපි ඥාපයිෂ්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","තාඃ කථාඃ කථයිත්වා යීශුඃ ශිෂ්‍යානාදාය කිද්‍රෝන්නාමකං ස්‍රෝත උත්තීර‍්‍ය්‍ය ශිෂ්‍යෛඃ සහ තත්‍රත්‍යෝද්‍යානං ප්‍රාවිශත්| ");
INSERT INTO sansin_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","කින්තු විශ්වාසඝාතියිහූදාස්තත් ස්ථානං පරිචීයතේ යතෝ යීශුඃ ශිෂ්‍යෛඃ සාර්ද්ධං කදාචිත් තත් ස්ථානම් අගච්ඡත්| ");
INSERT INTO sansin_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","තදා ස යිහූදාඃ සෛන්‍යගණං ප්‍රධානයාජකානාං ඵිරූශිනාඤ්ච පදාතිගණඤ්ච ගෘහීත්වා ප්‍රදීපාන් උල්කාන් අස්ත්‍රාණි චාදාය තස්මින් ස්ථාන උපස්ථිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","ස්වං ප්‍රති යද් ඝටිෂ්‍යතේ තජ් ඥාත්වා යීශුරග්‍රේසරඃ සන් තානපෘච්ඡත් කං ගවේෂයථ? ");
INSERT INTO sansin_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","තේ ප්‍රත්‍යවදන්, නාසරතීයං යීශුං; තතෝ යීශුරවාදීද් අහමේව සඃ; තෛඃ සහ විශ්වාසඝාතී යිහූදාශ්චාතිෂ්ඨත්| ");
INSERT INTO sansin_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","තදාහමේව ස තස්‍යෛතාං කථාං ශ්‍රුත්වෛව තේ පශ්චාදේත්‍ය භූමෞ පතිතාඃ| ");
INSERT INTO sansin_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","තතෝ යීශුඃ පුනරපි පෘෂ්ඨවාන් කං ගවේෂයථ? තතස්තේ ප්‍රත්‍යවදන් නාසරතීයං යීශුං| ");
INSERT INTO sansin_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","තදා යීශුඃ ප්‍රත්‍යුදිතවාන් අහමේව ස ඉමාං කථාමචකථම්; යදි මාමන්විච්ඡථ තර්හීමාන් ගන්තුං මා වාරයත| ");
INSERT INTO sansin_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ඉත්ථං භූතේ මහ්‍යං යාල්ලෝකාන් අදදාස්තේෂාම් ඒකමපි නාහාරයම් ඉමාං යාං කථාං ස ස්වයමකථයත් සා කථා සඵලා ජාතා| ");
INSERT INTO sansin_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","තදා ශිමෝන්පිතරස්‍ය නිකටේ ඛඞ්ගල්ස්ථිතේඃ ස තං නිෂ්කෝෂං කෘත්වා මහායාජකස්‍ය මාල්ඛනාමානං දාසම් ආහත්‍ය තස්‍ය දක්‍ෂිණකර්ණං ඡින්නවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","තතෝ යීශුඃ පිතරම් අවදත්, ඛඞ්ගං කෝෂේ ස්ථාපය මම පිතා මහ්‍යං පාතුං යං කංසම් අදදාත් තේනාහං කිං න පාස්‍යාමි? ");
INSERT INTO sansin_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","තදා සෛන්‍යගණඃ සේනාපති ර‍්‍යිහූදීයානාං පදාතයශ්ච යීශුං ඝෘත්වා බද්ධ්වා හානන්නාම්නඃ කියඵාඃ ශ්වශුරස්‍ය සමීපං ප්‍රථමම් අනයන්| ");
INSERT INTO sansin_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ස කියඵාස්තස්මින් වත්සරේ මහායාජත්වපදේ නියුක්තඃ ");
INSERT INTO sansin_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","සන් සාධාරණලෝකානාං මඞ්ගලාර්ථම් ඒකජනස්‍ය මරණමුචිතම් ඉති යිහූදීයෛඃ සාර්ද්ධම් අමන්ත්‍රයත්| ");
INSERT INTO sansin_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","තදා ශිමෝන්පිතරෝ(අ)න්‍යෛකශිෂ්‍යශ්ච යීශෝඃ පශ්චාද් අගච්ඡතාං තස්‍යාන්‍යශිෂ්‍යස්‍ය මහායාජකේන පරිචිතත්වාත් ස යීශුනා සහ මහායාජකස්‍යාට්ටාලිකාං ප්‍රාවිශත්| ");
INSERT INTO sansin_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","කින්තු පිතරෝ බහිර්ද්වාරස්‍ය සමීපේ(අ)තිෂ්ඨද් අතඒව මහායාජකේන පරිචිතඃ ස ශිෂ්‍යඃ පුනර්බහිර්ගත්වා දෞවායිකායෛ කථයිත්වා පිතරම් අභ්‍යන්තරම් ආනයත්| ");
INSERT INTO sansin_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","තදා ස ද්වාරරක්‍ෂිකා පිතරම් අවදත් ත්වං කිං න තස්‍ය මානවස්‍ය ශිෂ්‍යඃ? තතඃ සෝවදද් අහං න භවාමි| ");
INSERT INTO sansin_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","තතඃ පරං යත්ස්ථානේ දාසාඃ පදාතයශ්ච ශීතහේතෝරඞ්ගාරෛ ර්වහ්නිං ප්‍රජ්වාල්‍ය තාපං සේවිතවන්තස්තත්ස්ථානේ පිතරස්තිෂ්ඨන් තෛඃ සහ වහ්නිතාපං සේවිතුම් ආරභත| ");
INSERT INTO sansin_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","තදා ශිෂ්‍යේෂූපදේශේ ච මහායාජකේන යීශුඃ පෘෂ්ටඃ ");
INSERT INTO sansin_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","සන් ප්‍රත්‍යුක්තවාන් සර්ව්වලෝකානාං සමක්‍ෂං කථාමකථයං ගුප්තං කාමපි කථාං න කථයිත්වා යත් ස්ථානං යිහූදීයාඃ සතතං ගච්ඡන්ති තත්‍ර භජනගේහේ මන්දිරේ චාශික්‍ෂයං| ");
INSERT INTO sansin_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","මත්තඃ කුතඃ පෘච්ඡසි? යේ ජනා මදුපදේශම් අශෘණ්වන් තානේව පෘච්ඡ යද්‍යද් අවදං තේ තත් ජානින්ත| ");
INSERT INTO sansin_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","තදේත්ථං ප්‍රත්‍යුදිතත්වාත් නිකටස්ථපදාති ර‍්‍යීශුං චපේටේනාහත්‍ය ව්‍යාහරත් මහායාජකම් ඒවං ප්‍රතිවදසි? ");
INSERT INTO sansin_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","තතෝ යීශුඃ ප්‍රතිගදිතවාන් යද්‍යයථාර්ථම් අචකථං තර්හි තස්‍යායථාර්ථස්‍ය ප්‍රමාණං දේහි, කින්තු යදි යථාර්ථං තර්හි කුතෝ හේතෝ ර්මාම් අතාඩයඃ? ");
INSERT INTO sansin_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","පූර්ව්වං හානන් සබන්ධනං තං කියඵාමහායාජකස්‍ය සමීපං ප්‍රෛෂයත්| ");
INSERT INTO sansin_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ශිමෝන්පිතරස්තිෂ්ඨන් වහ්නිතාපං සේවතේ, ඒතස්මින් සමයේ කියන්තස්තම් අපෘච්ඡන් ත්වං කිම් ඒතස්‍ය ජනස්‍ය ශිෂ්‍යෝ න? තතඃ සෝපහ්නුත්‍යාබ්‍රවීද් අහං න භවාමි| ");
INSERT INTO sansin_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","තදා මහායාජකස්‍ය යස්‍ය දාසස්‍ය පිතරඃ කර්ණමච්ඡිනත් තස්‍ය කුටුම්බඃ ප්‍රත්‍යුදිතවාන් උද්‍යානේ තේන සහ තිෂ්ඨන්තං ත්වාං කිං නාපශ්‍යං? ");
INSERT INTO sansin_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","කින්තු පිතරඃ පුනරපහ්නුත්‍ය කථිතවාන්; තදානීං කුක්කුටෝ(අ)රෞත්| ");
INSERT INTO sansin_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","තදනන්තරං ප්‍රත්‍යූෂේ තේ කියඵාගෘහාද් අධිපතේ ර්ගෘහං යීශුම් අනයන් කින්තු යස්මින් අශුචිත්වේ ජාතේ තෛ ර්නිස්තාරෝත්සවේ න භෝක්තව්‍යං, තස්‍ය භයාද් යිහූදීයාස්තද්ගෘහං නාවිශන්| ");
INSERT INTO sansin_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","අපරං පීලාතෝ බහිරාගත්‍ය තාන් පෘෂ්ඨවාන් ඒතස්‍ය මනුෂ්‍යස්‍ය කං දෝෂං වදථ? ");
INSERT INTO sansin_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","තදා තේ පේත්‍යවදන් දුෂ්කර්ම්මකාරිණි න සති භවතඃ සමීපේ නෛනං සමාර්පයිෂ්‍යාමඃ| ");
INSERT INTO sansin_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","තතඃ පීලාතෝ(අ)වදද් යූයමේනං ගෘහීත්වා ස්වේෂාං ව්‍යවස්ථයා විචාරයත| තදා යිහූදීයාඃ ප්‍රත්‍යවදන් කස්‍යාපි මනුෂ්‍යස්‍ය ප්‍රාණදණ්ඩං කර්ත්තුං නාස්මාකම් අධිකාරෝ(අ)ස්ති| ");
INSERT INTO sansin_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ඒවං සති යීශුඃ ස්වස්‍ය මෘත්‍යෞ යාං කථාං කථිතවාන් සා සඵලාභවත්| ");
INSERT INTO sansin_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","තදනන්තරං පීලාතඃ පුනරපි තද් රාජගෘහං ගත්වා යීශුමාහූය පෘෂ්ටවාන් ත්වං කිං යිහූදීයානාං රාජා? ");
INSERT INTO sansin_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","යීශුඃ ප්‍රත්‍යවදත් ත්වම් ඒතාං කථාං ස්වතඃ කථයසි කිමන්‍යඃ කශ්චින් මයි කථිතවාන්? ");
INSERT INTO sansin_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","පීලාතෝ(අ)වදද් අහං කිං යිහූදීයඃ? තව ස්වදේශීයා විශේෂතඃ ප්‍රධානයාජකා මම නිකටේ ත්වාං සමාර්පයන, ත්වං කිං කෘතවාන්? ");
INSERT INTO sansin_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","යීශුඃ ප්‍රත්‍යවදත් මම රාජ්‍යම් ඒතජ්ජගත්සම්බන්ධීයං න භවති යදි මම රාජ්‍යං ජගත්සම්බන්ධීයම් අභවිෂ්‍යත් තර්හි යිහූදීයානාං හස්තේෂු යථා සමර්පිතෝ නාභවං තදර්ථං මම සේවකා අයෝත්ස්‍යන් කින්තු මම රාජ්‍යම් ඓහිකං න| ");
INSERT INTO sansin_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","තදා පීලාතඃ කථිතවාන්, තර්හි ත්වං රාජා භවසි? යීශුඃ ප්‍රත්‍යුක්තවාන් ත්වං සත්‍යං කථයසි, රාජාහං භවාමි; සත්‍යතායාං සාක්‍ෂ්‍යං දාතුං ජනිං ගෘහීත්වා ජගත්‍යස්මින් අවතීර්ණවාන්, තස්මාත් සත්‍යධර්ම්මපක්‍ෂපාතිනෝ මම කථාං ශෘණ්වන්ති| ");
INSERT INTO sansin_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","තදා සත්‍යං කිං? ඒතාං කථාං පෂ්ට්වා පීලාතඃ පුනරපි බහිර්ගත්වා යිහූදීයාන් අභාෂත, අහං තස්‍ය කමප්‍යපරාධං න ප්‍රාප්නෝමි| ");
INSERT INTO sansin_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","නිස්තාරෝත්සවසමයේ යුෂ්මාභිරභිරුචිත ඒකෝ ජනෝ මයා මෝචයිතව්‍ය ඒෂා යුෂ්මාකං රීතිරස්ති, අතඒව යුෂ්මාකං නිකටේ යිහූදීයානාං රාජානං කිං මෝචයාමි, යුෂ්මාකම් ඉච්ඡා කා? ");
INSERT INTO sansin_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","තදා තේ සර්ව්වේ රුවන්තෝ ව්‍යාහරන් ඒනං මානුෂං නහි බරබ්බාං මෝචය| කින්තු ස බරබ්බා දස්‍යුරාසීත්| ");
INSERT INTO sansin_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","පීලාතෝ යීශුම් ආනීය කශයා ප්‍රාහාරයත්| ");
INSERT INTO sansin_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","පශ්චාත් සේනාගණඃ කණ්ටකනිර්ම්මිතං මුකුටං තස්‍ය මස්තකේ සමර්ප්‍ය වාර්ත්තාකීවර්ණං රාජපරිච්ඡදං පරිධාප්‍ය, ");
INSERT INTO sansin_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","හේ යිහූදීයානාං රාජන් නමස්කාර ඉත්‍යුක්ත්වා තං චපේටේනාහන්තුම් ආරභත| ");
INSERT INTO sansin_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","තදා පීලාතඃ පුනරපි බහිර්ගත්වා ලෝකාන් අවදත්, අස්‍ය කමප්‍යපරාධං න ලභේ(අ)හං, පශ්‍යත තද් යුෂ්මාන් ඥාපයිතුං යුෂ්මාකං සන්නිධෞ බහිරේනම් ආනයාමි| ");
INSERT INTO sansin_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","තතඃ පරං යීශුඃ කණ්ටකමුකුටවාන් වාර්ත්තාකීවර්ණවසනවාංශ්ච බහිරාගච්ඡත්| තතඃ පීලාත උක්තවාන් ඒනං මනුෂ්‍යං පශ්‍යත| ");
INSERT INTO sansin_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","තදා ප්‍රධානයාජකාඃ පදාතයශ්ච තං දෘෂ්ට්වා, ඒනං ක්‍රුශේ විධ, ඒනං ක්‍රුශේ විධ, ඉත්‍යුක්ත්වා රවිතුං ආරභන්ත| තතඃ පීලාතඃ කථිතවාන් යූයං ස්වයම් ඒනං නීත්වා ක්‍රුශේ විධත, අහම් ඒතස්‍ය කමප්‍යපරාධං න ප්‍රාප්තවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","යිහූදීයාඃ ප්‍රත්‍යවදන් අස්මාකං යා ව්‍යවස්ථාස්තේ තදනුසාරේණාස්‍ය ප්‍රාණහනනම් උචිතං යතෝයං ස්වම් ඊශ්වරස්‍ය පුත්‍රමවදත්| ");
INSERT INTO sansin_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","පීලාත ඉමාං කථාං ශ්‍රුත්වා මහාත්‍රාසයුක්තඃ ");
INSERT INTO sansin_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","සන් පුනරපි රාජගෘහ ආගත්‍ය යීශුං පෘෂ්ටවාන් ත්වං කුත්‍රත්‍යෝ ලෝකඃ? කින්තු යීශස්තස්‍ය කිමපි ප්‍රත්‍යුත්තරං නාවදත්| ");
INSERT INTO sansin_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","1॰ තතඃ පීලාත් කථිතවාන ත්වං කිං මයා සාර්ද්ධං න සංලපිෂ්‍යසි ? ත්වාං ක්‍රුශේ වේධිතුං වා මෝචයිතුං ශක්ති ර්මමාස්තේ ඉති කිං ත්වං න ජානාසි ? තදා යීශුඃ ප්‍රත්‍යවදද් ඊශ්වරේණාදŸाං මමෝපරි තව කිමප්‍යධිපතිත්වං න විද්‍යතේ, තථාපි යෝ ජනෝ මාං තව හස්තේ සමාර්පයත් තස්‍ය මහාපාතකං ජාතම්| ");
INSERT INTO sansin_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","තදා යීශුඃ ප්‍රත්‍යවදද් ඊශ්වරේණාදත්තං මමෝපරි තව කිමප්‍යධිපතිත්වං න විද්‍යතේ, තථාපි යෝ ජනෝ මාං තව හස්තේ සමාර්පයත් තස්‍ය මහාපාතකං ජාතම්| ");
INSERT INTO sansin_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","තදාරභ්‍ය පීලාතස්තං මෝචයිතුං චේෂ්ටිතවාන් කින්තු යිහූදීයා රුවන්තෝ ව්‍යාහරන් යදීමං මානවං ත්‍යජසි තර්හි ත්වං කෛසරස්‍ය මිත්‍රං න භවසි, යෝ ජනඃ ස්වං රාජානං වක්ති සඒව කෛමරස්‍ය විරුද්ධාං කථාං කථයති| ");
INSERT INTO sansin_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ඒතාං කථාං ශ්‍රුත්වා පීලාතෝ යීශුං බහිරානීය නිස්තාරෝත්සවස්‍ය ආසාදනදිනස්‍ය ද්විතීයප්‍රහරාත් පූර්ව්වං ප්‍රස්තරබන්ධනනාම්නි ස්ථානේ (අ)ර්ථාත් ඉබ්‍රීයභාෂයා යද් ගබ්බිථා කථ්‍යතේ තස්මින් ස්ථානේ විචාරාසන උපාවිශත්| ");
INSERT INTO sansin_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","අනන්තරං පීලාතෝ යිහූදීයාන් අවදත්, යුෂ්මාකං රාජානං පශ්‍යත| ");
INSERT INTO sansin_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","කින්තු ඒනං දූරීකුරු, ඒනං දූරීකුරු, ඒනං ක්‍රුශේ විධ, ඉති කථාං කථයිත්වා තේ රවිතුම් ආරභන්ත; තදා පීලාතඃ කථිතවාන් යුෂ්මාකං රාජානං කිං ක්‍රුශේ වේධිෂ්‍යාමි? ප්‍රධානයාජකා උත්තරම් අවදන් කෛසරං විනා කෝපි රාජාස්මාකං නාස්ති| ");
INSERT INTO sansin_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","තතඃ පීලාතෝ යීශුං ක්‍රුශේ වේධිතුං තේෂාං හස්තේෂු සමාර්පයත්, තතස්තේ තං ධෘත්වා නීතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","තතඃ පරං යීශුඃ ක්‍රුශං වහන් ශිරඃකපාලම් අර්ථාද් යද් ඉබ්‍රීයභාෂයා ගුල්ගල්තාං වදන්ති තස්මින් ස්ථාන උපස්ථිතඃ| ");
INSERT INTO sansin_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","තතස්තේ මධ්‍යස්ථානේ තං තස්‍යෝභයපාර්ශ්වේ ද්වාවපරෞ ක්‍රුශේ(අ)විධන්| ");
INSERT INTO sansin_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","අපරම් ඒෂ යිහූදීයානාං රාජා නාසරතීයයීශුඃ, ඉති විඥාපනං ලිඛිත්වා පීලාතස්තස්‍ය ක්‍රුශෝපරි සමයෝජයත්| ");
INSERT INTO sansin_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","සා ලිපිඃ ඉබ්‍රීයයූනානීයරෝමීයභාෂාභි ර්ලිඛිතා; යීශෝඃ ක්‍රුශවේධනස්ථානං නගරස්‍ය සමීපං, තස්මාද් බහවෝ යිහූදීයාස්තාං පඨිතුම් ආරභන්ත| ");
INSERT INTO sansin_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","යිහූදීයානාං ප්‍රධානයාජකාඃ පීලාතමිති න්‍යවේදයන් යිහූදීයානාං රාජේති වාක්‍යං න කින්තු ඒෂ ස්වං යිහූදීයානාං රාජානම් අවදද් ඉත්ථං ලිඛතු| ");
INSERT INTO sansin_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","තතඃ පීලාත උත්තරං දත්තවාන් යල්ලේඛනීයං තල්ලිඛිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ඉත්ථං සේනාගණෝ යීශුං ක්‍රුශේ විධිත්වා තස්‍ය පරිධේයවස්ත්‍රං චතුරෝ භාගාන් කෘත්වා ඒකෛකසේනා ඒකෛකභාගම් අගෘහ්ලත් තස්‍යෝත්තරීයවස්ත්‍රඤ්චාගෘහ්ලත්| කින්තූත්තරීයවස්ත්‍රං සූචිසේවනං විනා සර්ව්වම් ඌතං| ");
INSERT INTO sansin_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","තස්මාත්තේ ව්‍යාහරන් ඒතත් කඃ ප්‍රාප්ස්‍යති? තන්න ඛණ්ඩයිත්වා තත්‍ර ගුටිකාපාතං කරවාම| විභජන්තේ(අ)ධරීයං මේ වසනං තේ පරස්පරං| මමෝත්තරීයවස්ත්‍රාර්ථං ගුටිකාං පාතයන්ති ච| ඉති යද්වාක්‍යං ධර්ම්මපුස්තකේ ලිඛිතමාස්තේ තත් සේනාගණේනේත්ථං ව්‍යවහරණාත් සිද්ධමභවත්| ");
INSERT INTO sansin_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","තදානීං යීශෝ ර්මාතා මාතු ර්භගිනී ච යා ක්ලියපා භාර‍්‍ය්‍යා මරියම් මග්දලීනී මරියම් ච ඒතාස්තස්‍ය ක්‍රුශස්‍ය සන්නිධෞ සමතිෂ්ඨන්| ");
INSERT INTO sansin_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","තතෝ යීශුඃ ස්වමාතරං ප්‍රියතමශිෂ්‍යඤ්ච සමීපේ දණ්ඩායමානෞ විලෝක්‍ය මාතරම් අවදත්, හේ යෝෂිද් ඒනං තව පුත්‍රං පශ්‍ය, ");
INSERT INTO sansin_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ශිෂ්‍යන්ත්වවදත්, ඒනාං තව මාතරං පශ්‍ය| තතඃ ස ශිෂ්‍යස්තද්ඝටිකායාං තාං නිජගෘහං නීතවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","අනන්තරං සර්ව්වං කර්ම්මාධුනා සම්පන්නමභූත් යීශුරිති ඥාත්වා ධර්ම්මපුස්තකස්‍ය වචනං යථා සිද්ධං භවති තදර්ථම් අකථයත් මම පිපාසා ජාතා| ");
INSERT INTO sansin_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","තතස්තස්මින් ස්ථානේ අම්ලරසේන පූර්ණපාත්‍රස්ථිත්‍යා තේ ස්පඤ්ජමේකං තදම්ලරසේනාර්ද්‍රීකෘත්‍ය ඒසෝබ්නලේ තද් යෝජයිත්වා තස්‍ය මුඛස්‍ය සන්නිධාවස්ථාපයන්| ");
INSERT INTO sansin_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","තදා යීශුරම්ලරසං ගෘහීත්වා සර්ව්වං සිද්ධම් ඉති කථාං කථයිත්වා මස්තකං නමයන් ප්‍රාණාන් පර‍්‍ය්‍යත්‍යජත්| ");
INSERT INTO sansin_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","තද්විනම් ආසාදනදිනං තස්මාත් පරේ(අ)හනි විශ්‍රාමවාරේ දේහා යථා ක්‍රුශෝපරි න තිෂ්ඨන්ති, යතඃ ස විශ්‍රාමවාරෝ මහාදිනමාසීත්, තස්මාද් යිහූදීයාඃ පීලාතනිකටං ගත්වා තේෂාං පාදභඤ්ජනස්‍ය ස්ථානාන්තරනයනස්‍ය චානුමතිං ප්‍රාර්ථයන්ත| ");
INSERT INTO sansin_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","අතඃ සේනා ආගත්‍ය යීශුනා සහ ක්‍රුශේ හතයෝඃ ප්‍රථමද්විතීයචෝරයෝඃ පාදාන් අභඤ්ජන්; ");
INSERT INTO sansin_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","කින්තු යීශෝඃ සන්නිධිං ගත්වා ස මෘත ඉති දෘෂ්ට්වා තස්‍ය පාදෞ නාභඤ්ජන්| ");
INSERT INTO sansin_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","පශ්චාද් ඒකෝ යෝද්ධා ශූලාඝාතේන තස්‍ය කුක්‍ෂිම් අවිධත් තත්ක්‍ෂණාත් තස්මාද් රක්තං ජලඤ්ච නිරගච්ඡත්| ");
INSERT INTO sansin_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","යෝ ජනෝ(අ)ස්‍ය සාක්‍ෂ්‍යං දදාති ස ස්වයං දෘෂ්ටවාන් තස්‍යේදං සාක්‍ෂ්‍යං සත්‍යං තස්‍ය කථා යුෂ්මාකං විශ්වාසං ජනයිතුං යෝග්‍යා තත් ස ජානාති| ");
INSERT INTO sansin_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","තස්‍යෛකම් අස්ධ්‍යපි න භංක්‍ෂ්‍යතේ, ");
INSERT INTO sansin_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","තද්වද් අන්‍යශාස්ත්‍රේපි ලිඛ්‍යතේ, යථා, \"දෘෂ්ටිපාතං කරිෂ්‍යන්ති තේ(අ)විධන් යන්තු තම්ප්‍රති| \" ");
INSERT INTO sansin_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","අරිමථීයනගරස්‍ය යූෂඵ්නාමා ශිෂ්‍ය ඒක ආසීත් කින්තු යිහූදීයේභ්‍යෝ භයාත් ප්‍රකාශිතෝ න භවති; ස යීශෝ ර්දේහං නේතුං පීලාතස්‍යානුමතිං ප්‍රාර්ථයත, තතඃ පීලාතේනානුමතේ සති ස ගත්වා යීශෝ ර්දේහම් අනයත්| ");
INSERT INTO sansin_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","අපරං යෝ නිකදීමෝ රාත්‍රෞ යීශෝඃ සමීපම් අගච්ඡත් සෝපි ගන්ධරසේන මිශ්‍රිතං ප්‍රායේණ පඤ්චාශත්සේටකමගුරුං ගෘහීත්වාගච්ඡත්| ");
INSERT INTO sansin_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","තතස්තේ යිහූදීයානාං ශ්මශානේ ස්ථාපනරීත්‍යනුසාරේණ තත්සුගන්ධිද්‍රව්‍යේණ සහිතං තස්‍ය දේහං වස්ත්‍රේණාවේෂ්ටයන්| ");
INSERT INTO sansin_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","අපරඤ්ච යත්‍ර ස්ථානේ තං ක්‍රුශේ(අ)විධන් තස්‍ය නිකටස්ථෝද්‍යානේ යත්‍ර කිමපි මෘතදේහං කදාපි නාස්ථාප්‍යත තාදෘශම් ඒකං නූතනං ශ්මශානම් ආසීත්| ");
INSERT INTO sansin_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","යිහූදීයානාම් ආසාදනදිනාගමනාත් තේ තස්මින් සමීපස්ථශ්මශානේ යීශුම් අශායයන්| ");
INSERT INTO sansin_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","අනන්තරං සප්තාහස්‍ය ප්‍රථමදිනේ (අ)තිප්‍රත්‍යූෂේ (අ)න්ධකාරේ තිෂ්ඨති මග්දලීනී මරියම් තස්‍ය ශ්මශානස්‍ය නිකටං ගත්වා ශ්මශානස්‍ය මුඛාත් ප්‍රස්තරමපසාරිතම් අපශ්‍යත්| ");
INSERT INTO sansin_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","පශ්චාද් ධාවිත්වා ශිමෝන්පිතරාය යීශෝඃ ප්‍රියතමශිෂ්‍යාය චේදම් අකථයත්, ලෝකාඃ ශ්මශානාත් ප්‍රභුං නීත්වා කුත්‍රාස්ථාපයන් තද් වක්තුං න ශක්නෝමි| ");
INSERT INTO sansin_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","අතඃ පිතරඃ සෝන්‍යශිෂ්‍යශ්ච බර්හි ර්භුත්වා ශ්මශානස්ථානං ගන්තුම් ආරභේතාං| ");
INSERT INTO sansin_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","උභයෝර්ධාවතෝඃ සෝන්‍යශිෂ්‍යඃ පිතරං පශ්චාත් ත්‍යක්ත්වා පූර්ව්වං ශ්මශානස්ථාන උපස්ථිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","තදා ප්‍රහ්වීභූය ස්ථාපිතවස්ත්‍රාණි දෘෂ්ටවාන් කින්තු න ප්‍රාවිශත්| ");
INSERT INTO sansin_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","අපරං ශිමෝන්පිතර ආගත්‍ය ශ්මශානස්ථානං ප්‍රවිශ්‍ය ");
INSERT INTO sansin_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ස්ථාපිතවස්ත්‍රාණි මස්තකස්‍ය වස්ත්‍රඤ්ච පෘථක් ස්ථානාන්තරේ ස්ථාපිතං දෘෂ්ටවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","තතඃ ශ්මශානස්ථානං පූර්ව්වම් ආගතෝ යෝන්‍යශිෂ්‍යඃ සෝපි ප්‍රවිශ්‍ය තාදෘශං දෘෂ්ටා ව්‍යශ්වසීත්| ");
INSERT INTO sansin_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","යතඃ ශ්මශානාත් ස උත්ථාපයිතව්‍ය ඒතස්‍ය ධර්ම්මපුස්තකවචනස්‍ය භාවං තේ තදා වෝද්ධුං නාශන්කුවන්| ");
INSERT INTO sansin_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","අනන්තරං තෞ ද්වෞ ශිෂ්‍යෞ ස්වං ස්වං ගෘහං පරාවෘත්‍යාගච්ඡතාම්| ");
INSERT INTO sansin_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","තතඃ පරං මරියම් ශ්මශානද්වාරස්‍ය බහිඃ ස්ථිත්වා රෝදිතුම් ආරභත තතෝ රුදතී ප්‍රහ්වීභූය ශ්මශානං විලෝක්‍ය ");
INSERT INTO sansin_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","යීශෝඃ ශයනස්ථානස්‍ය ශිරඃස්ථානේ පදතලේ ච ද්වයෝ ර්දිශෝ ද්වෞ ස්වර්ගීයදූතාවුපවිෂ්ටෞ සමපශ්‍යත්| ");
INSERT INTO sansin_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","තෞ පෘෂ්ටවන්තෞ හේ නාරි කුතෝ රෝදිෂි? සාවදත් ලෝකා මම ප්‍රභුං නීත්වා කුත්‍රාස්ථාපයන් ඉති න ජානාමි| ");
INSERT INTO sansin_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ඉත්‍යුක්ත්වා මුඛං පරාවෘත්‍ය යීශුං දණ්ඩායමානම් අපශ්‍යත් කින්තු ස යීශුරිති සා ඥාතුං නාශක්නෝත්| ");
INSERT INTO sansin_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","තදා යීශුස්තාම් අපෘච්ඡත් හේ නාරි කුතෝ රෝදිෂි? කං වා මෘගයසේ? තතඃ සා තම් උද්‍යානසේවකං ඥාත්වා ව්‍යාහරත්, හේ මහේච්ඡ ත්වං යදීතඃ ස්ථානාත් තං නීතවාන් තර්හි කුත්‍රාස්ථාපයස්තද් වද තත්ස්ථානාත් තම් ආනයාමි| ");
INSERT INTO sansin_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","තදා යීශුස්තාම් අවදත් හේ මරියම්| තතඃ සා පරාවෘත්‍ය ප්‍රත්‍යවදත් හේ රබ්බූනී අර්ථාත් හේ ගුරෝ| ");
INSERT INTO sansin_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","තදා යීශුරවදත් මාං මා ධර, ඉදානීං පිතුඃ සමීපේ ඌර්ද්ධ්වගමනං න කරෝමි කින්තු යෝ මම යුෂ්මාකඤ්ච පිතා මම යුෂ්මාකඤ්චේශ්වරස්තස්‍ය නිකට ඌර්ද්ධ්වගමනං කර්ත්තුම් උද්‍යතෝස්මි, ඉමාං කථාං ත්වං ගත්වා මම භ්‍රාතෘගණං ඥාපය| ");
INSERT INTO sansin_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","තතෝ මග්දලීනීමරියම් තත්ක්‍ෂණාද් ගත්වා ප්‍රභුස්තස්‍යෛ දර්ශනං දත්ත්වා කථා ඒතා අකථයද් ඉති වාර්ත්තාං ශිෂ්‍යේභ්‍යෝ(අ)කථයත්| ");
INSERT INTO sansin_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","තතඃ පරං සප්තාහස්‍ය ප්‍රථමදිනස්‍ය සන්ධ්‍යාසමයේ ශිෂ්‍යා ඒකත්‍ර මිලිත්වා යිහූදීයේභ්‍යෝ භියා ද්වාරරුද්ධම් අකුර්ව්වන්, ඒතස්මින් කාලේ යීශුස්තේෂාං මධ්‍යස්ථානේ තිෂ්ඨන් අකථයද් යුෂ්මාකං කල්‍යාණං භූයාත්| ");
INSERT INTO sansin_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ඉත්‍යුක්ත්වා නිජහස්තං කුක්‍ෂිඤ්ච දර්ශිතවාන්, තතඃ ශිෂ්‍යාඃ ප්‍රභුං දෘෂ්ට්වා හෘෂ්ටා අභවන්| ");
INSERT INTO sansin_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","යීශුඃ පුනරවදද් යුෂ්මාකං කල්‍යාණං භූයාත් පිතා යථා මාං ප්‍රෛෂයත් තථාහමපි යුෂ්මාන් ප්‍රේෂයාමි| ");
INSERT INTO sansin_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ඉත්‍යුක්ත්වා ස තේෂාමුපරි දීර්ඝප්‍රශ්වාසං දත්ත්වා කථිතවාන් පවිත්‍රම් ආත්මානං ගෘහ්ලීත| ");
INSERT INTO sansin_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","යූයං යේෂාං පාපානි මෝචයිෂ්‍යථ තේ මෝචයිෂ්‍යන්තේ යේෂාඤ්ච පාපාති න මෝචයිෂ්‍යථ තේ න මෝචයිෂ්‍යන්තේ| ");
INSERT INTO sansin_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","ද්වාදශමධ්‍යේ ගණිතෝ යමජෝ ථෝමානාමා ශිෂ්‍යෝ යීශෝරාගමනකාලෛ තෛඃ සාර්ද්ධං නාසීත්| ");
INSERT INTO sansin_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","අතෝ වයං ප්‍රභූම් අපශ්‍යාමේති වාක්‍යේ(අ)න්‍යශිෂ්‍යෛරුක්තේ සෝවදත්, තස්‍ය හස්තයෝ ර්ලෞහකීලකානාං චිහ්නං න විලෝක්‍ය තච්චිහ්නම් අඞ්ගුල්‍යා න ස්පෘෂ්ට්වා තස්‍ය කුක්‍ෂෞ හස්තං නාරෝප්‍ය චාහං න විශ්වසිෂ්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","අපරම් අෂ්ටමේ(අ)හ්නි ගතේ සති ථෝමාසහිතඃ ශිෂ්‍යගණ ඒකත්‍ර මිලිත්වා ද්වාරං රුද්ධ්වාභ්‍යන්තර ආසීත්, ඒතර්හි යීශුස්තේෂාං මධ්‍යස්ථානේ තිෂ්ඨන් අකථයත්, යුෂ්මාකං කුශලං භූයාත්| ");
INSERT INTO sansin_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","පශ්චාත් ථාමෛ කථිතවාන් ත්වම් අඞ්ගුලීම් අත්‍රාර්පයිත්වා මම කරෞ පශ්‍ය කරං ප්‍රසාර‍්‍ය්‍ය මම කුක්‍ෂාවර්පය නාවිශ්වස්‍ය| ");
INSERT INTO sansin_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","තදා ථෝමා අවදත්, හේ මම ප්‍රභෝ හේ මදීශ්වර| ");
INSERT INTO sansin_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","යීශුරකථයත්, හේ ථෝමා මාං නිරීක්‍ෂ්‍ය විශ්වසිෂි යේ න දෘෂ්ට්වා විශ්වසන්ති තඒව ධන්‍යාඃ| ");
INSERT INTO sansin_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ඒතදන්‍යානි පුස්තකේ(අ)ස්මින් අලිඛිතානි බහූන්‍යාශ්චර‍්‍ය්‍යකර්ම්මාණි යීශුඃ ශිෂ්‍යාණාං පුරස්තාද් අකරෝත්| ");
INSERT INTO sansin_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","කින්තු යීශුරීශ්වරස්‍යාභිෂික්තඃ සුත ඒවේති යථා යූයං විශ්වසිථ විශ්වස්‍ය ච තස්‍ය නාම්නා පරමායුඃ ප්‍රාප්නුථ තදර්ථම් ඒතානි සර්ව්වාණ්‍යලිඛ්‍යන්ත| ");
INSERT INTO sansin_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","තතඃ පරං තිබිරියාජලධේස්තටේ යීශුඃ පුනරපි ශිෂ්‍යේභ්‍යෝ දර්ශනං දත්තවාන් දර්ශනස්‍යාඛ්‍යානමිදම්| ");
INSERT INTO sansin_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ශිමෝන්පිතරඃ යමජථෝමා ගාලීලීයකාන්නානගරනිවාසී නිථනේල් සිවදේඃ පුත්‍රාවන්‍යෞ ද්වෞ ශිෂ්‍යෞ චෛතේෂ්වේකත්‍ර මිලිතේෂු ශිමෝන්පිතරෝ(අ)කථයත් මත්ස්‍යාන් ධර්තුං යාමි| ");
INSERT INTO sansin_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","තතස්තේ ව්‍යාහරන් තර්හි වයමපි ත්වයා සාර්ද්ධං යාමඃ තදා තේ බහිර්ගතාඃ සන්තඃ ක්‍ෂිප්‍රං නාවම් ආරෝහන් කින්තු තස්‍යාං රජන්‍යාම් ඒකමපි න ප්‍රාප්නුවන්| ");
INSERT INTO sansin_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","ප්‍රභාතේ සති යීශුස්තටේ ස්ථිතවාන් කින්තු ස යීශුරිති ශිෂ්‍යා ඥාතුං නාශක්නුවන්| ");
INSERT INTO sansin_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","තදා යීශුරපෘච්ඡත්, හේ වත්සා සන්නිධෞ කිඤ්චිත් ඛාද්‍යද්‍රව්‍යම් ආස්තේ? තේ(අ)වදන් කිමපි නාස්ති| ");
INSERT INTO sansin_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","තදා සෝ(අ)වදත් නෞකායා දක්‍ෂිණපාර්ශ්වේ ජාලං නික්‍ෂිපත තතෝ ලප්ස්‍යධ්වේ, තස්මාත් තෛ ර්නික්‍ෂිප්තේ ජාලේ මත්ස්‍යා ඒතාවන්තෝ(අ)පතන් යේන තේ ජාලමාකෘෂ්‍ය නෝත්තෝලයිතුං ශක්තාඃ| ");
INSERT INTO sansin_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","තස්මාද් යීශෝඃ ප්‍රියතමශිෂ්‍යඃ පිතරායාකථයත් ඒෂ ප්‍රභු ර්භවේත්, ඒෂ ප්‍රභුරිති වාචං ශ්‍රුත්වෛව ශිමෝන් නග්නතාහේතෝ ර්මත්ස්‍යධාරිණ උත්තරීයවස්ත්‍රං පරිධාය හ්‍රදං ප්‍රත්‍යුදලම්ඵයත්| ");
INSERT INTO sansin_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","අපරේ ශිෂ්‍යා මත්ස්‍යෛඃ සාර්ද්ධං ජාලම් ආකර්ෂන්තඃ ක්‍ෂුද්‍රනෞකාං වාහයිත්වා කූලමානයන් තේ කූලාද් අතිදූරේ නාසන් ද්විශතහස්තේභ්‍යෝ දූර ආසන් ඉත්‍යනුමීයතේ| ");
INSERT INTO sansin_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","තීරං ප්‍රාප්තෛස්තෛස්තත්‍ර ප්‍රජ්වලිතාග්නිස්තදුපරි මත්ස්‍යාඃ පූපාශ්ච දෘෂ්ටාඃ| ");
INSERT INTO sansin_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","තතෝ යීශුරකථයද් යාන් මත්ස්‍යාන් අධරත තේෂාං කතිපයාන් ආනයත| ");
INSERT INTO sansin_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","අතඃ ශිමෝන්පිතරඃ පරාවෘත්‍ය ගත්වා බෘහද්භිස්ත්‍රිපඤ්චාශදධිකශතමත්ස්‍යෛඃ පරිපූර්ණං තජ්ජාලම් ආකෘෂ්‍යෝදතෝලයත් කින්ත්වේතාවද්භි ර්මත්ස්‍යෛරපි ජාලං නාඡිද්‍යත| ");
INSERT INTO sansin_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","අනන්තරං යීශුස්තාන් අවාදීත් යූයමාගත්‍ය භුංග්ධ්වං; තදා සඒව ප්‍රභුරිති ඥාතත්වාත් ත්වං කඃ? ඉති ප්‍රෂ්ටුං ශිෂ්‍යාණාං කස්‍යාපි ප්‍රගල්භතා නාභවත්| ");
INSERT INTO sansin_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","තතෝ යීශුරාගත්‍ය පූපාන් මත්ස්‍යාංශ්ච ගෘහීත්වා තේභ්‍යඃ පර‍්‍ය්‍යවේෂයත්| ");
INSERT INTO sansin_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ඉත්ථං ශ්මශානාදුත්ථානාත් පරං යීශුඃ ශිෂ්‍යේභ්‍යස්තෘතීයවාරං දර්ශනං දත්තවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","භෝජනේ සමාප්තේ සති යීශුඃ ශිමෝන්පිතරං පෘෂ්ටවාන්, හේ යූනසඃ පුත්‍ර ශිමෝන් ත්වං කිම් ඒතේභ්‍යෝධිකං මයි ප්‍රීයසේ? තතඃ ස උදිතවාන් සත්‍යං ප්‍රභෝ ත්වයි ප්‍රීයේ(අ)හං තද් භවාන් ජානාති; තදා යීශුරකථයත් තර්හි මම මේෂශාවකගණං පාලය| ");
INSERT INTO sansin_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","තතඃ ස ද්විතීයවාරං පෘෂ්ටවාන් හේ යූනසඃ පුත්‍ර ශිමෝන් ත්වං කිං මයි ප්‍රීයසේ? තතඃ ස උක්තවාන් සත්‍යං ප්‍රභෝ ත්වයි ප්‍රීයේ(අ)හං තද් භවාන් ජානාති; තදා යීශුරකථයත තර්හි මම මේෂගණං පාලය| ");
INSERT INTO sansin_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","පශ්චාත් ස තෘතීයවාරං පෘෂ්ටවාන්, හේ යූනසඃ පුත්‍ර ශිමෝන් ත්වං කිං මයි ප්‍රීයසේ? ඒතද්වාක්‍යං තෘතීයවාරං පෘෂ්ටවාන් තස්මාත් පිතරෝ දුඃඛිතෝ භූත්වා(අ)කථයත් හේ ප්‍රභෝ භවතඃ කිමප්‍යගෝචරං නාස්ති ත්වය්‍යහං ප්‍රීයේ තද් භවාන් ජානාති; තතෝ යීශුරවදත් තර්හි මම මේෂගණං පාලය| ");
INSERT INTO sansin_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","අහං තුභ්‍යං යථාර්ථං කථයාමි යෞවනකාලේ ස්වයං බද්ධකටි ර‍්‍යත්‍රේච්ඡා තත්‍ර යාතවාන් කින්ත්විතඃ පරං වෘද්ධේ වයසි හස්තං විස්තාරයිෂ්‍යසි, අන්‍යජනස්ත්වාං බද්ධ්වා යත්‍ර ගන්තුං තවේච්ඡා න භවති ත්වාං ධෘත්වා තත්‍ර නේෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ඵලතඃ කීදෘශේන මරණේන ස ඊශ්වරස්‍ය මහිමානං ප්‍රකාශයිෂ්‍යති තද් බෝධයිතුං ස ඉති වාක්‍යං ප්‍රෝක්තවාන්| ඉත්‍යුක්තේ සති ස තමවෝචත් මම පශ්චාද් ආගච්ඡ| ");
INSERT INTO sansin_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","යෝ ජනෝ රාත්‍රිකාලේ යීශෝ ර්වක්‍ෂෝ(අ)වලම්බ්‍ය, හේ ප්‍රභෝ කෝ භවන්තං පරකරේෂු සමර්පයිෂ්‍යතීති වාක්‍යං පෘෂ්ටවාන්, තං යීශෝඃ ප්‍රියතමශිෂ්‍යං පශ්චාද් ආගච්ඡන්තං ");
INSERT INTO sansin_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","පිතරෝ මුඛං පරාවර්ත්ත්‍ය විලෝක්‍ය යීශුං පෘෂ්ටවාන්, හේ ප්‍රභෝ ඒතස්‍ය මානවස්‍ය කීදෘශී ගති ර්භවිෂ්‍යති? ");
INSERT INTO sansin_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","ස ප්‍රත්‍යවදත්, මම පුනරාගමනපර‍්‍ය්‍යන්තං යදි තං ස්ථාපයිතුම් ඉච්ඡාමි තත්‍ර තව කිං? ත්වං මම පශ්චාද් ආගච්ඡ| ");
INSERT INTO sansin_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","තස්මාත් ස ශිෂ්‍යෝ න මරිෂ්‍යතීති භ්‍රාතෘගණමධ්‍යේ කිංවදන්තී ජාතා කින්තු ස න මරිෂ්‍යතීති වාක්‍යං යීශු ර්නාවදත් කේවලං මම පුනරාගමනපර‍්‍ය්‍යන්තං යදි තං ස්ථාපයිතුම් ඉච්ඡාමි තත්‍ර තව කිං? ඉති වාක්‍යම් උක්තවාන්| ");
INSERT INTO sansin_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","යෝ ජන ඒතානි සර්ව්වාණි ලිඛිතවාන් අත්‍ර සාක්‍ෂ්‍යඤ්ච දත්තවාන් සඒව ස ශිෂ්‍යඃ, තස්‍ය සාක්‍ෂ්‍යං ප්‍රමාණමිති වයං ජානීමඃ| ");
INSERT INTO sansin_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","යීශුරේතේභ්‍යෝ(අ)පරාණ්‍යපි බහූනි කර්ම්මාණි කෘතවාන් තානි සර්ව්වාණි යද්‍යේකෛකං කෘත්වා ලිඛ්‍යන්තේ තර්හි ග්‍රන්ථා ඒතාවන්තෝ භවන්ති තේෂාං ධාරණේ පෘථිව්‍යාං ස්ථානං න භවති| ඉති||");
INSERT INTO sansin_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","හේ ථියඵිල, යීශුඃ ස්වමනෝනීතාන් ප්‍රේරිතාන් පවිත්‍රේණාත්මනා සමාදිශ්‍ය යස්මින් දිනේ ස්වර්ගමාරෝහත් යාං යාං ක්‍රියාමකරෝත් යද්‍යද් උපාදිශච්ච තානි සර්ව්වාණි පූර්ව්වං මයා ලිඛිතානි| ");
INSERT INTO sansin_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ස ස්වනිධනදුඃඛභෝගාත් පරම් අනේකප්‍රත්‍යයක්‍ෂප්‍රමාණෞඃ ස්වං සජීවං දර්ශයිත්වා ");
INSERT INTO sansin_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","චත්වාරිංශද්දිනානි යාවත් තේභ්‍යඃ ප්‍රේරිතේභ්‍යෝ දර්ශනං දත්ත්වේශ්වරීයරාජ්‍යස්‍ය වර්ණනම අකරෝත්| ");
INSERT INTO sansin_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","අනන්තරං තේෂාං සභාං කෘත්වා ඉත්‍යාඥාපයත්, යූයං යිරූශාලමෝ(අ)න්‍යත්‍ර ගමනමකෘත්වා යස්තින් පිත්‍රාඞ්ගීකෘතේ මම වදනාත් කථා අශෘණුත තත්ප්‍රාප්තිම් අපේක්‍ෂ්‍ය තිෂ්ඨත| ");
INSERT INTO sansin_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","යෝහන් ජලේ මජ්ජිතාවාන් කින්ත්වල්පදිනමධ්‍යේ යූයං පවිත්‍ර ආත්මනි මජ්ජිතා භවිෂ්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","පශ්චාත් තේ සර්ව්වේ මිලිත්වා තම් අපෘච්ඡන් හේ ප්‍රභෝ භවාන් කිමිදානීං පුනරපි රාජ්‍යම් ඉස්‍රායේලීයලෝකානාං කරේෂු සමර්පයිෂ්‍යති? ");
INSERT INTO sansin_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","තතඃ සෝවදත් යාන් සර්ව්වාන් කාලාන් සමයාංශ්ච පිතා ස්වවශේ(අ)ස්ථාපයත් තාන් ඥාතෘං යුෂ්මාකම් අධිකාරෝ න ජායතේ| ");
INSERT INTO sansin_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","කින්තු යුෂ්මාසු පවිත්‍රස්‍යාත්මන ආවිර්භාවේ සති යූයං ශක්තිං ප්‍රාප්‍ය යිරූශාලමි සමස්තයිහූදාශෝමිරෝණදේශයෝඃ පෘථිව්‍යාඃ සීමාං යාවද් යාවන්තෝ දේශාස්තේෂු යර්ව්වේෂු ච මයි සාක්‍ෂ්‍යං දාස්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ඉති වාක්‍යමුක්ත්වා ස තේෂාං සමක්‍ෂං ස්වර්ගං නීතෝ(අ)භවත්, තතෝ මේඝමාරුහ්‍ය තේෂාං දෘෂ්ටේරගෝචරෝ(අ)භවත්| ");
INSERT INTO sansin_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","යස්මින් සමයේ තේ විහායසං ප්‍රත්‍යනන්‍යදෘෂ්ට්‍යා තස්‍ය තාදෘශම් ඌර්ද්ව්වගමනම් අපශ්‍යන් තස්මින්නේව සමයේ ශුක්ලවස්ත්‍රෞ ද්වෞ ජනෞ තේෂාං සන්නිධෞ දණ්ඩායමානෞ කථිතවන්තෞ, ");
INSERT INTO sansin_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","හේ ගාලීලීයලෝකා යූයං කිමර්ථං ගගණං ප්‍රති නිරීක්‍ෂ්‍ය දණ්ඩායමානාස්තිෂ්ඨථ? යුෂ්මාකං සමීපාත් ස්වර්ගං නීතෝ යෝ යීශුස්තං යූයං යථා ස්වර්ගම් ආරෝහන්තම් අදර්ශම් තථා ස පුනශ්චාගමිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","තතඃ පරං තේ ජෛතුනනාම්නඃ පර්ව්වතාද් විශ්‍රාමවාරස්‍ය පථඃ පරිමාණම් අර්ථාත් ප්‍රායේණාර්ද්ධක්‍රෝශං දුරස්ථං යිරූශාලම්නගරං පරාවෘත්‍යාගච්ඡන්| ");
INSERT INTO sansin_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","නගරං ප්‍රවිශ්‍ය පිතරෝ යාකූබ් යෝහන් ආන්ද්‍රියඃ ඵිලිපඃ ථෝමා බර්ථජමයෝ මථිරාල්ඵීයපුත්‍රෝ යාකූබ් උද්‍යෝගාी ශිමෝන් යාකූබෝ භ්‍රාතා යිහූදා ඒතේ සර්ව්වේ යත්‍ර ස්ථානේ ප්‍රවසන්ති තස්මින් උපරිතනප්‍රකෝෂ්ඨේ ප්‍රාවිශන්| ");
INSERT INTO sansin_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","පශ්චාද් ඉමේ කියත්‍යඃ ස්ත්‍රියශ්ච යීශෝ ර්මාතා මරියම් තස්‍ය භ්‍රාතරශ්චෛතේ සර්ව්ව ඒකචිත්තීභූත සතතං විනයේන විනයේන ප්‍රාර්ථයන්ත| ");
INSERT INTO sansin_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","තස්මින් සමයේ තත්‍ර ස්ථානේ සාකල්‍යේන විංශත්‍යධිකශතං ශිෂ්‍යා ආසන්| තතඃ පිතරස්තේෂාං මධ්‍යේ තිෂ්ඨන් උක්තවාන් ");
INSERT INTO sansin_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","හේ භ්‍රාතෘගණ යීශුධාරිණාං ලෝකානාං පථදර්ශකෝ යෝ යිහූදාස්තස්මින් දායූදා පවිත්‍ර ආත්මා යාං කථාං කථයාමාස තස්‍යාඃ ප්‍රත්‍යක්‍ෂීභවනස්‍යාවශ්‍යකත්වම් ආසීත්| ");
INSERT INTO sansin_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ස ජනෝ(අ)ස්මාකං මධ්‍යවර්ත්තී සන් අස්‍යාඃ සේවායා අංශම් අලභත| ");
INSERT INTO sansin_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","තදනන්තරං කුකර්ම්මණා ලබ්ධං යන්මූල්‍යං තේන ක්‍ෂේත්‍රමේකං ක්‍රීතම් අපරං තස්මින් අධෝමුඛේ භෘමෞ පතිතේ සති තස්‍යෝදරස්‍ය විදීර්ණත්වාත් සර්ව්වා නාඩ්‍යෝ නිරගච්ඡන්| ");
INSERT INTO sansin_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ඒතාං කථාං යිරූශාලම්නිවාසිනඃ සර්ව්වේ ලෝකා විදාන්ති; තේෂාං නිජභාෂයා තත්ක්‍ෂේත්‍රඤ්ච හකල්දාමා, අර්ථාත් රක්තක්‍ෂේත්‍රමිති විඛ්‍යාතමාස්තේ| ");
INSERT INTO sansin_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","අන්‍යච්ච, නිකේතනං තදීයන්තු ශුන්‍යමේව භවිෂ්‍යති| තස්‍ය දූෂ්‍යේ නිවාසාර්ථං කෝපි ස්ථාස්‍යති නෛව හි| අන්‍ය ඒව ජනස්තස්‍ය පදං සංප්‍රාප්ස්‍යති ධ්‍රුවං| ඉත්ථං ගීතපුස්තකේ ලිඛිතමාස්තේ| ");
INSERT INTO sansin_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","අතෝ යෝහනෝ මජ්ජනම් ආරභ්‍යාස්මාකං සමීපාත් ප්‍රභෝ ර‍්‍යීශෝඃ ස්වර්ගාරෝහණදිනං යාවත් සෝස්මාකං මධ්‍යේ යාවන්ති දිනානි යාපිතවාන් ");
INSERT INTO sansin_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","තාවන්ති දිනානි යේ මානවා අස්මාභිඃ සාර්ද්ධං තිෂ්ඨන්ති තේෂාම් ඒකේන ජනේනාස්මාභිඃ සාර්ද්ධං යීශෝරුත්ථානේ සාක්‍ෂිණා භවිතව්‍යං| ");
INSERT INTO sansin_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","අතෝ යස්‍ය රූඪි ර‍්‍යුෂ්ටෝ යං බර්ශබ්බේත්‍යුක්ත්වාහූයන්ති ස යූෂඵ් මතථිශ්ච ද්වාවේතෞ පෘථක් කෘත්වා ත ඊශ්වරස්‍ය සන්නිධෞ ප්‍රාර‍්‍ය්‍ය කථිතවන්තඃ, ");
INSERT INTO sansin_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","හේ සර්ව්වාන්තර‍්‍ය්‍යාමින් පරමේශ්වර, යිහූදාඃ සේවනප්‍රේරිතත්වපදච්‍යුතඃ ");
INSERT INTO sansin_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","සන් නිජස්ථානම් අගච්ඡත්, තත්පදං ලබ්ධුම් ඒනයෝ ර්ජනයෝ ර්මධ්‍යේ භවතා කෝ(අ)භිරුචිතස්තදස්මාන් දර්ශ්‍යතාං| ");
INSERT INTO sansin_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","තතෝ ගුටිකාපාටේ කෘතේ මතථිර්නිරචීයත තස්මාත් සෝන්‍යේෂාම් ඒකාදශානාං ප්‍රරිතානාං මධ්‍යේ ගණිතෝභවත්| ");
INSERT INTO sansin_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","අපරඤ්ච නිස්තාරෝත්සවාත් පරං පඤ්චාශත්තමේ දිනේ සමුපස්ථිතේ සති තේ සර්ව්වේ ඒකාචිත්තීභූය ස්ථාන ඒකස්මින් මිලිතා ආසන්| ");
INSERT INTO sansin_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ඒතස්මින්නේව සමයේ(අ)කස්මාද් ආකාශාත් ප්‍රචණ්ඩාත්‍යුග්‍රවායෝඃ ශබ්දවද් ඒකඃ ශබ්ද ආගත්‍ය යස්මින් ගෘහේ ත උපාවිශන් තද් ගෘහං සමස්තං ව්‍යාප්නෝත්| ");
INSERT INTO sansin_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","තතඃ පරං වහ්නිශිඛාස්වරූපා ජිහ්වාඃ ප්‍රත්‍යක්‍ෂීභූය විභක්තාඃ සත්‍යඃ ප්‍රතිජනෝර්ද්ධ්වේ ස්ථගිතා අභූවන්| ");
INSERT INTO sansin_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","තස්මාත් සර්ව්වේ පවිත්‍රේණාත්මනා පරිපූර්ණාඃ සන්ත ආත්මා යථා වාචිතවාන් තදනුසාරේණාන්‍යදේශීයානාං භාෂා උක්තවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","තස්මින් සමයේ පෘථිවීස්ථසර්ව්වදේශේභ්‍යෝ යිහූදීයමතාවලම්බිනෝ භක්තලෝකා යිරූශාලමි ප්‍රාවසන්; ");
INSERT INTO sansin_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","තස්‍යාඃ කථායාඃ කිංවදන්ත්‍යා ජාතත්වාත් සර්ව්වේ ලෝකා මිලිත්වා නිජනිජභාෂයා ශිෂ්‍යාණාං කථාකථනං ශ්‍රුත්වා සමුද්විග්නා අභවන්| ");
INSERT INTO sansin_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","සර්ව්වඒව විස්මයාපන්නා ආශ්චර‍්‍ය්‍යාන්විතාශ්ච සන්තඃ පරස්පරං උක්තවන්තඃ පශ්‍යත යේ කථාං කථයන්ති තේ සර්ව්වේ ගාලීලීයලෝකාඃ කිං න භවන්ති? ");
INSERT INTO sansin_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","තර්හි වයං ප්‍රත්‍යේකශඃ ස්වස්වජන්මදේශීයභාෂාභිඃ කථා ඒතේෂාං ශෘණුමඃ කිමිදං? ");
INSERT INTO sansin_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","පාර්ථී-මාදී-අරාම්නහරයිම්දේශනිවාසිමනෝ යිහූදා-කප්පදකියා-පන්ත-ආශියා- ");
INSERT INTO sansin_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ඵ්‍රුගියා-පම්ඵුලියා-මිසරනිවාසිනඃ කුරීණීනිකටවර්ත්තිලූබීයප්‍රදේශනිවාසිනෝ රෝමනගරාද් ආගතා යිහූදීයලෝකා යිහූදීයමතග්‍රාහිණඃ ක්‍රීතීයා අරාබීයාදයෝ ලෝකාශ්ච යේ වයම් ");
INSERT INTO sansin_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","අස්මාකං නිජනිජභාෂාභිරේතේෂාම් ඊශ්වරීයමහාකර්ම්මව්‍යාඛ්‍යානං ශෘණුමඃ| ");
INSERT INTO sansin_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ඉත්ථං තේ සර්ව්වඒව විස්මයාපන්නාඃ සන්දිග්ධචිත්තාඃ සන්තඃ පරස්පරමූචුඃ, අස්‍ය කෝ භාවඃ? ");
INSERT INTO sansin_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","අපරේ කේචිත් පරිහස්‍ය කථිතවන්ත ඒතේ නවීනද්‍රාක්‍ෂාරසේන මත්තා අභවන්| ");
INSERT INTO sansin_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","තදා පිතර ඒකාදශභි ර්ජනෛඃ සාකං තිෂ්ඨන් තාල්ලෝකාන් උච්චෛඃකාරම් අවදත්, හේ යිහූදීයා හේ යිරූශාලම්නිවාසිනඃ සර්ව්වේ, අවධානං කෘත්වා මදීයවාක්‍යං බුධ්‍යධ්වං| ");
INSERT INTO sansin_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ඉදානීම් ඒකයාමාද් අධිකා වේලා නාස්ති තස්මාද් යූයං යද් අනුමාථ මානවා ඉමේ මද්‍යපානේන මත්තාස්තන්න| ");
INSERT INTO sansin_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","කින්තු යෝයේල්භවිෂ්‍යද්වක්ත්‍රෛතද්වාක්‍යමුක්තං යථා, ");
INSERT INTO sansin_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","ඊශ්වරඃ කථයාමාස යුගාන්තසමයේ ත්වහම්| වර්ෂිෂ්‍යාමි ස්වමාත්මානං සර්ව්වප්‍රාණ්‍යුපරි ධ්‍රුවම්| භාවිවාක්‍යං වදිෂ්‍යන්ති කන්‍යාඃ පුත්‍රාශ්ච වස්තුතඃ| ප්‍රත්‍යාදේශඤ්ච ප්‍රාප්ස්‍යන්ති යුෂ්මාකං යුවමානවාඃ| තථා ප්‍රාචීනලෝකාස්තු ස්වප්නාන් ද්‍රක්‍ෂ්‍යන්ති නිශ්චිතං| ");
INSERT INTO sansin_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","වර්ෂිෂ්‍යාමි තදාත්මානං දාසදාසීජනෝපිරි| තේනෛව භාවිවාක්‍යං තේ වදිෂ්‍යන්ති හි සර්ව්වශඃ| ");
INSERT INTO sansin_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ඌර්ද්ධ්වස්ථේ ගගණේ චෛව නීචස්ථේ පෘථිවීතලේ| ශෝණිතානි බෘහද්භානූන් ඝනධූමාදිකානි ච| චිහ්නානි දර්ශයිෂ්‍යාමි මහාශ්චර‍්‍ය්‍යක්‍රියාස්තථා| ");
INSERT INTO sansin_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","මහාභයානකස්‍යෛව තද්දිනස්‍ය පරේශිතුඃ| පුරාගමාද් රවිඃ කෘෂ්ණෝ රක්තශ්චන්ද්‍රෝ භවිෂ්‍යතඃ| ");
INSERT INTO sansin_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","කින්තු යඃ පරමේශස්‍ය නාම්නි සම්ප්‍රාර්ථයිෂ්‍යතේ| සඒව මනුජෝ නූනං පරිත්‍රාතෝ භවිෂ්‍යති|| ");
INSERT INTO sansin_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","අතෝ හේ ඉස්‍රායේල්වංශීයලෝකාඃ සර්ව්වේ කථායාමේතස්‍යාම් මනෝ නිධද්ධ්වං නාසරතීයෝ යීශුරීශ්වරස්‍ය මනෝනීතඃ පුමාන් ඒතද් ඊශ්වරස්තත්කෘතෛරාශ්චර‍්‍ය්‍යාද්භුතකර්ම්මභි ර්ලක්‍ෂණෛශ්ච යුෂ්මාකං සාක්‍ෂාදේව ප්‍රතිපාදිතවාන් ඉති යූයං ජානීථ| ");
INSERT INTO sansin_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","තස්මින් යීශෞ ඊශ්වරස්‍ය පූර්ව්වනිශ්චිතමන්ත්‍රණානිරූපණානුසාරේණ මෘත්‍යෞ සමර්පිතේ සති යූයං තං ධෘත්වා දුෂ්ටලෝකානාං හස්තෛඃ ක්‍රුශේ විධිත්වාහත| ");
INSERT INTO sansin_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","කින්ත්වීශ්වරස්තං නිධනස්‍ය බන්ධනාන්මෝචයිත්වා උදස්ථාපයත් යතඃ ස මෘත්‍යුනා බද්ධස්තිෂ්ඨතීති න සම්භවති| ");
INSERT INTO sansin_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ඒතස්තින් දායූදපි කථිතවාන් යථා, සර්ව්වදා මම සාක්‍ෂාත්තං ස්ථාපය පරමේශ්වරං| ස්ථිතේ මද්දක්‍ෂිණේ තස්මින් ස්ඛලිෂ්‍යාමි ත්වහං නහි| ");
INSERT INTO sansin_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ආනන්දිෂ්‍යති තද්ධේතෝ ර්මාමකීනං මනස්තු වෛ| ආහ්ලාදිෂ්‍යති ජිහ්වාපි මදීයා තු තථෛව ච| ප්‍රත්‍යාශයා ශරීරන්තු මදීයං වෛශයිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","පරලෝකේ යතෝ හේතෝස්ත්වං මාං නෛව හි ත්‍යක්‍ෂ්‍යසි| ස්වකීයං පුණ්‍යවන්තං ත්වං ක්‍ෂයිතුං නෛව දාස්‍යසි| ඒවං ජීවනමාර්ගං ත්වං මාමේව දර්ශයිෂ්‍යසි| ");
INSERT INTO sansin_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","ස්වසම්මුඛේ ය ආනන්දෝ දක්‍ෂිණේ ස්වස්‍ය යත් සුඛං| අනන්තං තේන මාං පූර්ණං කරිෂ්‍යසි න සංශයඃ|| ");
INSERT INTO sansin_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","හේ භ්‍රාතරෝ(අ)ස්මාකං තස්‍ය පූර්ව්වපුරුෂස්‍ය දායූදඃ කථාං ස්පෂ්ටං කථයිතුං මාම් අනුමන්‍යධ්වං, ස ප්‍රාණාන් ත්‍යක්ත්වා ශ්මශානේ ස්ථාපිතෝභවද් අද්‍යාපි තත් ශ්මශානම් අස්මාකං සන්නිධෞ විද්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","ඵලතෝ ලෞකිකභාවේන දායූදෝ වංශේ ඛ්‍රීෂ්ටං ජන්ම ග්‍රාහයිත්වා තස්‍යෛව සිංහාසනේ සමුවේෂ්ටුං තමුත්ථාපයිෂ්‍යති පරමේශ්වරඃ ශපථං කුත්වා දායූදඃ සමීප ඉමම් අඞ්ගීකාරං කෘතවාන්, ");
INSERT INTO sansin_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ඉති ඥාත්වා දායූද් භවිෂ්‍යද්වාදී සන් භවිෂ්‍යත්කාලීයඥානේන ඛ්‍රීෂ්ටෝත්ථානේ කථාමිමාං කථයාමාස යථා තස්‍යාත්මා පරලෝකේ න ත්‍යක්‍ෂ්‍යතේ තස්‍ය ශරීරඤ්ච න ක්‍ෂේෂ්‍යති; ");
INSERT INTO sansin_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","අතඃ පරමේශ්වර ඒනං යීශුං ශ්මශානාද් උදස්ථාපයත් තත්‍ර වයං සර්ව්වේ සාක්‍ෂිණ ආස්මහේ| ");
INSERT INTO sansin_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ස ඊශ්වරස්‍ය දක්‍ෂිණකරේණෝන්නතිං ප්‍රාප්‍ය පවිත්‍ර ආත්මින පිතා යමඞ්ගීකාරං කෘතවාන් තස්‍ය ඵලං ප්‍රාප්‍ය යත් පශ්‍යථ ශෘණුථ ච තදවර්ෂත්| ");
INSERT INTO sansin_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","යතෝ දායූද් ස්වර්ගං නාරුරෝහ කින්තු ස්වයම් ඉමාං කථාම් අකථයද් යථා, මම ප්‍රභුමිදං වාක්‍යමවදත් පරමේශ්වරඃ| ");
INSERT INTO sansin_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","තව ශත්‍රූනහං යාවත් පාදපීඨං කරෝමි න| තාවත් කාලං මදීයේ ත්වං දක්‍ෂවාර්ශ්ව උපාවිශ| ");
INSERT INTO sansin_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","අතෝ යං යීශුං යූයං ක්‍රුශේ(අ)හත පරමේශ්වරස්තං ප්‍රභුත්වාභිෂික්තත්වපදේ න්‍යයුංක්තේති ඉස්‍රායේලීයා ලෝකා නිශ්චිතං ජානන්තු| ");
INSERT INTO sansin_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ඒතාදෘශීං කථාං ශ්‍රුත්වා තේෂාං හෘදයානාං විදීර්ණත්වාත් තේ පිතරාය තදන්‍යප්‍රේරිතේභ්‍යශ්ච කථිතවන්තඃ, හේ භ්‍රාතෘගණ වයං කිං කරිෂ්‍යාමඃ? ");
INSERT INTO sansin_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","තතඃ පිතරඃ ප්‍රත්‍යවදද් යූයං සර්ව්වේ ස්වං ස්වං මනඃ පරිවර්ත්තයධ්වං තථා පාපමෝචනාර්ථං යීශුඛ්‍රීෂ්ටස්‍ය නාම්නා මජ්ජිතාශ්ච භවත, තස්මාද් දානරූපං පරිත්‍රම් ආත්මානං ලප්ස්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","යතෝ යුෂ්මාකං යුෂ්මත්සන්තානානාඤ්ච දූරස්ථසර්ව්වලෝකානාඤ්ච නිමිත්තම් අර්ථාද් අස්මාකං ප්‍රභුඃ පරමේශ්වරෝ යාවතෝ ලාකාන් ආහ්වාස්‍යති තේෂාං සර්ව්වේෂාං නිමිත්තම් අයමඞ්ගීකාර ආස්තේ| ");
INSERT INTO sansin_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ඒතදන්‍යාභි ර්බහුකථාභිඃ ප්‍රමාණං දත්වාකථයත් ඒතේභ්‍යෝ විපථගාමිභ්‍යෝ වර්ත්තමානලෝකේභ්‍යඃ ස්වාන් රක්‍ෂත| ");
INSERT INTO sansin_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","තතඃ පරං යේ සානන්දාස්තාං කථාම් අගෘහ්ලන් තේ මජ්ජිතා අභවන්| තස්මින් දිවසේ ප්‍රායේණ ත්‍රීණි සහස්‍රාණි ලෝකාස්තේෂාං සපක්‍ෂාඃ සන්තඃ ");
INSERT INTO sansin_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ප්‍රේරිතානාම් උපදේශේ සඞ්ගතෞ පූපභඤ්ජනේ ප්‍රාර්ථනාසු ච මනඃසංයෝගං කෘත්වාතිෂ්ඨන්| ");
INSERT INTO sansin_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","ප්‍රේරිතෛ ර්නානාප්‍රකාරලක්‍ෂණේෂු මහාශ්චර‍්‍ය්‍යකර්මමසු ච දර්ශිතේෂු සර්ව්වලෝකානාං භයමුපස්ථිතං| ");
INSERT INTO sansin_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","විශ්වාසකාරිණඃ සර්ව්ව ච සහ තිෂ්ඨනතඃ| ස්වේෂාං සර්ව්වාඃ සම්පත්තීඃ සාධාරණ්‍යේන ස්ථාපයිත්වාභුඤ්ජත| ");
INSERT INTO sansin_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ඵලතෝ ගෘහාණි ද්‍රව්‍යාණි ච සර්ව්වාණි වික්‍රීය සර්ව්වේෂාං ස්වස්වප්‍රයෝජනානුසාරේණ විභජ්‍ය සර්ව්වේභ්‍යෝ(අ)දදන්| ");
INSERT INTO sansin_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","සර්ව්ව ඒකචිත්තීභූය දිනේ දිනේ මන්දිරේ සන්තිෂ්ඨමානා ගෘහේ ගෘහේ ච පූපානභඤ්ජන්ත ඊශ්වරස්‍ය ධන්‍යවාදං කුර්ව්වන්තෝ ලෝකෛඃ සමාදෘතාඃ පරමානන්දේන සරලාන්තඃකරණේන භෝජනං පානඤ්චකුර්ව්වන්| ");
INSERT INTO sansin_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","පරමේශ්වරෝ දිනේ දිනේ පරිත්‍රාණභාජනෛ ර්මණ්ඩලීම් අවර්ද්ධයත්| ");
INSERT INTO sansin_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","තෘතීයයාමවේලායාං සත්‍යාං ප්‍රාර්ථනායාඃ සමයේ පිතරයෝහනෞ සම්භූය මන්දිරං ගච්ඡතඃ| ");
INSERT INTO sansin_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","තස්මින්නේව සමයේ මන්දිරප්‍රවේශකානාං සමීපේ භික්‍ෂාරණාර්ථං යං ජන්මඛඤ්ජමානුෂං ලෝකා මන්දිරස්‍ය සුන්දරනාම්නි ද්වාරේ ප්‍රතිදිනම් අස්ථාපයන් තං වහන්තස්තද්වාරං ආනයන්| ");
INSERT INTO sansin_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","තදා පිතරයෝහනෞ මන්තිරං ප්‍රවේෂ්ටුම් උද්‍යතෞ විලෝක්‍ය ස ඛඤ්ජස්තෞ කිඤ්චිද් භික්‍ෂිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","තස්මාද් යෝහනා සහිතඃ පිතරස්තම් අනන්‍යදෘෂ්ට්‍යා නිරීක්‍ෂ්‍ය ප්‍රෝක්තවාන් ආවාං ප්‍රති දෘෂ්ටිං කුරු| ");
INSERT INTO sansin_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","තතඃ ස කිඤ්චිත් ප්‍රාප්ත්‍යාශයා තෞ ප්‍රති දෘෂ්ටිං කෘතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","තදා පිතරෝ ගදිතවාන් මම නිකටේ ස්වර්ණරූප්‍යාදි කිමපි නාස්ති කින්තු යදාස්තේ තද් දදාමි නාසරතීයස්‍ය යීශුඛ්‍රීෂ්ටස්‍ය නාම්නා ත්වමුත්ථාය ගමනාගමනේ කුරු| ");
INSERT INTO sansin_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","තතඃ පරං ස තස්‍ය දක්‍ෂිණකරං ධෘත්වා තම් උදතෝලයත්; තේන තත්ක්‍ෂණාත් තස්‍ය ජනස්‍ය පාදගුල්ඵයෝඃ සබලත්වාත් ස උල්ලම්ඵ්‍ය ප්‍රෝත්ථාය ගමනාගමනේ (අ)කරෝත්| ");
INSERT INTO sansin_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","තතෝ ගමනාගමනේ කුර්ව්වන් උල්ලම්ඵන් ඊශ්වරං ධන්‍යං වදන් තාභ්‍යාං සාර්ද්ධං මන්දිරං ප්‍රාවිශත්| ");
INSERT INTO sansin_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","තතඃ සර්ව්වේ ලෝකාස්තං ගමනාගමනේ කුර්ව්වන්තම් ඊශ්වරං ධන්‍යං වදන්තඤ්ච විලෝක්‍ය ");
INSERT INTO sansin_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","මන්දිරස්‍ය සුන්දරේ ද්වාරේ ය උපවිශ්‍ය භික්‍ෂිතවාන් සඒවායම් ඉති ඥාත්වා තං ප්‍රති තයා ඝටනයා චමත්කෘතා විස්මයාපන්නාශ්චාභවන්| ");
INSERT INTO sansin_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","යඃ ඛඤ්ජඃ ස්වස්ථෝභවත් තේන පිතරයෝහනෝඃ කරයෝර්ධ්ටතයෝඃ සතෝඃ සර්ව්වේ ලෝකා සන්නිධිම් ආගච්ඡන්| ");
INSERT INTO sansin_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","තද් දෘෂ්ට්වා පිතරස්තේභ්‍යෝ(අ)කථයත්, හේ ඉස්‍රායේලීයලෝකා යූයං කුතෝ (අ)නේනාශ්චර‍්‍ය්‍යං මන්‍යධ්වේ? ආවාං නිජශක්ත්‍යා යද්වා නිජපුණ්‍යේන ඛඤ්ජමනුෂ්‍යමේනං ගමිතවන්තාවිති චින්තයිත්වා ආවාං ප්‍රති කුතෝ(අ)නන්‍යදෘෂ්ටිං කුරුථ? ");
INSERT INTO sansin_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","යං යීශුං යූයං පරකරේෂු සමාර්පයත තතෝ යං පීලාතෝ මෝචයිතුම් ඒैච්ඡත් තථාපි යූයං තස්‍ය සාක්‍ෂාන් නාඞ්ගීකෘතවන්ත ඉබ්‍රාහීම ඉස්හාකෝ යාකූබශ්චේශ්වරෝ(අ)ර්ථාද් අස්මාකං පූර්ව්වපුරුෂාණාම් ඊශ්වරඃ ස්වපුත්‍රස්‍ය තස්‍ය යීශෝ ර්මහිමානං ප්‍රාකාශයත්| ");
INSERT INTO sansin_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","කින්තු යූයං තං පවිත්‍රං ධාර්ම්මිකං පුමාංසං නාඞ්ගීකෘත්‍ය හත්‍යාකාරිණමේකං ස්වේභ්‍යෝ දාතුම් අයාචධ්වං| ");
INSERT INTO sansin_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","පශ්චාත් තං ජීවනස්‍යාධිපතිම් අහත කින්ත්වීශ්වරඃ ශ්මශානාත් තම් උදස්ථාපයත තත්‍ර වයං සාක්‍ෂිණ ආස්මහේ| ");
INSERT INTO sansin_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ඉමං යං මානුෂං යූයං පශ්‍යථ පරිචිනුථ ච ස තස්‍ය නාම්නි විශ්වාසකරණාත් චලනශක්තිං ලබ්ධවාන් තස්මින් තස්‍ය යෝ විශ්වාසඃ ස තං යුෂ්මාකං සර්ව්වේෂාං සාක්‍ෂාත් සම්පූර්ණරූපේණ ස්වස්ථම් අකාර්ෂීත්| ");
INSERT INTO sansin_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","හේ භ්‍රාතරෝ යූයං යුෂ්මාකම් අධිපතයශ්ච අඥාත්වා කර්ම්මාණ්‍යේතානි කෘතවන්ත ඉදානීං මමෛෂ බෝධෝ ජායතේ| ");
INSERT INTO sansin_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","කින්ත්වීශ්වරඃ ඛ්‍රීෂ්ටස්‍ය දුඃඛභෝගේ භවිෂ්‍යද්වාදිනාං මුඛේභ්‍යෝ යාං යාං කථාං පූර්ව්වමකථයත් තාඃ කථා ඉත්ථං සිද්ධා අකරෝත්| ");
INSERT INTO sansin_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","අතඃ ස්වේෂාං පාපමෝචනාර්ථං ඛේදං කෘත්වා මනාංසි පරිවර්ත්තයධ්වං, තස්මාද් ඊශ්වරාත් සාන්ත්වනාප්‍රාප්තේඃ සමය උපස්ථාස්‍යති; ");
INSERT INTO sansin_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","පුනශ්ච පූර්ව්වකාලම් ආරභ්‍ය ප්‍රචාරිතෝ යෝ යීශුඛ්‍රීෂ්ටස්තම් ඊශ්වරෝ යුෂ්මාන් ප්‍රති ප්‍රේෂයිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","කින්තු ජගතඃ සෘෂ්ටිමාරභ්‍ය ඊශ්වරෝ නිජපවිත්‍රභවිෂ්‍යද්වාදිගණෝන යථා කථිතවාන් තදනුසාරේණ සර්ව්වේෂාං කාර‍්‍ය්‍යාණාං සිද්ධිපර‍්‍ය්‍යන්තං තේන ස්වර්ගේ වාසඃ කර්ත්තව්‍යඃ| ");
INSERT INTO sansin_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","යුෂ්මාකං ප්‍රභුඃ පරමේශ්වරෝ යුෂ්මාකං භ්‍රාතෘගණමධ්‍යාත් මත්සදෘශං භවිෂ්‍යද්වක්තාරම් උත්පාදයිෂ්‍යති, තතඃ ස යත් කිඤ්චිත් කථයිෂ්‍යති තත්‍ර යූයං මනාංසි නිධද්ධ්වං| ");
INSERT INTO sansin_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","කින්තු යඃ කශ්චිත් ප්‍රාණී තස්‍ය භවිෂ්‍යද්වාදිනඃ කථාං න ග්‍රහීෂ්‍යති ස නිජලෝකානාං මධ්‍යාද් උච්ඡේත්ස්‍යතේ,\" ඉමාං කථාම් අස්මාකං පූර්ව්වපුරුෂේභ්‍යඃ කේවලෝ මූසාඃ කථයාමාස ඉති නහි, ");
INSERT INTO sansin_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","ශිමූයේල්භවිෂ්‍යද්වාදිනම් ආරභ්‍ය යාවන්තෝ භවිෂ්‍යද්වාක්‍යම් අකථයන් තේ සර්ව්වඒව සමයස්‍යෛතස්‍ය කථාම් අකථයන්| ");
INSERT INTO sansin_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","යූයමපි තේෂාං භවිෂ්‍යද්වාදිනාං සන්තානාඃ, \"තව වංශෝද්භවපුංසා සර්ව්වදේශීයා ලෝකා ආශිෂං ප්‍රාප්තා භවිෂ්‍යන්ති\", ඉබ්‍රාහීමේ කථාමේතාං කථයිත්වා ඊශ්වරෝස්මාකං පූර්ව්වපුරුෂෛඃ සාර්ද්ධං යං නියමං ස්ථිරීකෘතවාන් තස්‍ය නියමස්‍යාධිකාරිණෝපි යූයං භවථ| ");
INSERT INTO sansin_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","අත ඊශ්වරෝ නිජපුත්‍රං යීශුම් උත්ථාප්‍ය යුෂ්මාකං සර්ව්වේෂාං ස්වස්වපාපාත් පරාවර්ත්ත්‍ය යුෂ්මභ්‍යම් ආශිෂං දාතුං ප්‍රථමතස්තං යුෂ්මාකං නිකටං ප්‍රේෂිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","යස්මින් සමයේ පිතරයෝහනෞ ලෝකාන් උපදිශතස්තස්මින් සමයේ යාජකා මන්දිරස්‍ය සේනාපතයඃ සිදූකීගණශ්ච ");
INSERT INTO sansin_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","තයෝර් උපදේශකරණේ ඛ්‍රීෂ්ටස්‍යෝත්ථානම් උපලක්‍ෂ්‍ය සර්ව්වේෂාං මෘතානාම් උත්ථානප්‍රස්තාවේ ච ව්‍යග්‍රාඃ සන්තස්තාවුපාගමන්| ");
INSERT INTO sansin_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","තෞ ධෘත්වා දිනාවසානකාරණාත් පරදිනපර‍්‍ය්‍යනන්තං රුද්ධ්වා ස්ථාපිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","තථාපි යේ ලෝකාස්තයෝරුපදේශම් අශෘණ්වන් තේෂාං ප්‍රායේණ පඤ්චසහස්‍රාණි ජනා ව්‍යශ්වසන්| ");
INSERT INTO sansin_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","පරේ(අ)හනි අධිපතයඃ ප්‍රාචීනා අධ්‍යාපකාශ්ච හානනනාමා මහායාජකඃ ");
INSERT INTO sansin_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","කියඵා යෝහන් සිකන්දර ඉත්‍යාදයෝ මහායාජකස්‍ය ඥාතයඃ සර්ව්වේ යිරූශාලම්නගරේ මිලිතාඃ| ");
INSERT INTO sansin_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","අනන්තරං ප්‍රේරිතෞ මධ්‍යේ ස්ථාපයිත්වාපෘච්ඡන් යුවාං කයා ශක්තයා වා කේන නාම්නා කර්ම්මාණ්‍යේතානි කුරුථඃ? ");
INSERT INTO sansin_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","තදා පිතරඃ පවිත්‍රේණාත්මනා පරිපූර්ණඃ සන් ප්‍රත්‍යවාදීත්, හේ ලෝකානාම් අධිපතිගණ හේ ඉස්‍රායේලීයප්‍රාචීනාඃ, ");
INSERT INTO sansin_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ඒතස්‍ය දුර්බ්බලමානුෂස්‍ය හිතං යත් කර්ම්මාක්‍රියත, අර්ථාත්, ස යේන ප්‍රකාරේණ ස්වස්ථෝභවත් තච්චේද් අද්‍යාවාං පෘච්ඡථ, ");
INSERT INTO sansin_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","තර්හි සර්ව්ව ඉස්‍රායේेලීයලෝකා යූයං ජානීත නාසරතීයෝ යෝ යීශුඛ්‍රීෂ්ටඃ ක්‍රුශේ යුෂ්මාභිරවිධ්‍යත යශ්චේශ්වරේණ ශ්මශානාද් උත්ථාපිතඃ, තස්‍ය නාම්නා ජනෝයං ස්වස්ථඃ සන් යුෂ්මාකං සම්මුඛේ ප්‍රෝත්තිෂ්ඨති| ");
INSERT INTO sansin_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","නිචේතෘභි ර‍්‍යුෂ්මාභිරයං යඃ ප්‍රස්තරෝ(අ)වඥාතෝ(අ)භවත් ස ප්‍රධානකෝණස්‍ය ප්‍රස්තරෝ(අ)භවත්| ");
INSERT INTO sansin_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","තද්භින්නාදපරාත් කස්මාදපි පරිත්‍රාණං භවිතුං න ශක්නෝති, යේන ත්‍රාණං ප්‍රාප්‍යේත භූමණ්ඩලස්‍යලෝකානාං මධ්‍යේ තාදෘශං කිමපි නාම නාස්ති| ");
INSERT INTO sansin_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","තදා පිතරයෝහනෝරේතාදෘශීම් අක්‍ෂේභතාං දෘෂ්ට්වා තාවවිද්වාංසෞ නීචලෝකාවිති බුද්ධ්වා ආශ්චර‍්‍ය්‍යම් අමන්‍යන්ත තෞ ච යීශෝඃ සඞ්ගිනෞ ජාතාවිති ඥාතුම් අශක්නුවන්| ");
INSERT INTO sansin_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","කින්තු තාභ්‍යාං සාර්ද්ධං තං ස්වස්ථමානුෂං තිෂ්ඨන්තං දෘෂ්ට්වා තේ කාමප්‍යපරාම් ආපත්තිං කර්ත්තං නාශක්නුන්| ");
INSERT INTO sansin_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","තදා තේ සභාතඃ ස්ථානාන්තරං ගන්තුං තාන් ආඥාප්‍ය ස්වයං පරස්පරම් ඉති මන්ත්‍රණාමකුර්ව්වන් ");
INSERT INTO sansin_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","තෞ මානවෞ ප්‍රති කිං කර්ත්තව්‍යං? තාවේකං ප්‍රසිද්ධම් ආශ්චර‍්‍ය්‍යං කර්ම්ම කෘතවන්තෞ තද් යිරූශාලම්නිවාසිනාං සර්ව්වේෂාං ලෝකානාං සමීපේ ප්‍රාකාශත තච්ච වයමපහ්නෝතුං න ශක්නුමඃ| ");
INSERT INTO sansin_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","කින්තු ලෝකානාං මධ්‍යම් ඒතද් යථා න ව්‍යාප්නෝති තදර්ථං තෞ භයං ප්‍රදර්ශ්‍ය තේන නාම්නා කමපි මනුෂ්‍යං නෝපදිශතම් ඉති දෘඪං නිෂේධාමඃ| ");
INSERT INTO sansin_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","තතස්තේ ප්‍රේරිතාවාහූය ඒතදාඥාපයන් ඉතඃ පරං යීශෝ ර්නාම්නා කදාපි කාමපි කථාං මා කථයතං කිමපි නෝපදිශඤ්ච| ");
INSERT INTO sansin_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","තතඃ පිතරයෝහනෞ ප්‍රත්‍යවදතාම් ඊශ්වරස්‍යාඥාග්‍රහණං වා යුෂ්මාකම් ආඥාග්‍රහණම් ඒතයෝ ර්මධ්‍යේ ඊශ්වරස්‍ය ගෝචරේ කිං විහිතං? යූයං තස්‍ය විවේචනාං කුරුත| ");
INSERT INTO sansin_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","වයං යද් අපශ්‍යාම යදශෘණුම ච තන්න ප්‍රචාරයිෂ්‍යාම ඒතත් කදාපි භවිතුං න ශක්නෝති| ");
INSERT INTO sansin_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","යදඝටත තද් දෘෂ්ටා සර්ව්වේ ලෝකා ඊශ්වරස්‍ය ගුණාන් අන්වවදන් තස්මාත් ලෝකභයාත් තෞ දණ්ඩයිතුං කමප්‍යුපායං න ප්‍රාප්‍ය තේ පුනරපි තර්ජයිත්වා තාවත්‍යජන්| ");
INSERT INTO sansin_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","යස්‍ය මානුෂස්‍යෛතත් ස්වාස්ථ්‍යකරණම් ආශ්චර‍්‍ය්‍යං කර්ම්මාක්‍රියත තස්‍ය වයශ්චත්වාරිංශද්වත්සරා ව්‍යතීතාඃ| ");
INSERT INTO sansin_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","තතඃ පරං තෞ විසෘෂ්ටෞ සන්තෞ ස්වසඞ්ගිනාං සන්නිධිං ගත්වා ප්‍රධානයාජකෛඃ ප්‍රාචීනලෝකෛශ්ච ප්‍රෝක්තාඃ සර්ව්වාඃ කථා ඥාපිතවන්තෞ| ");
INSERT INTO sansin_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","තච්ඡ්‍රුත්වා සර්ව්ව ඒකචිත්තීභූය ඊශ්වරමුද්දිශ්‍ය ප්‍රෝච්චෛරේතත් ප්‍රාර්ථයන්ත, හේ ප්‍රභෝ ගගණපෘථිවීපයෝධීනාං තේෂු ච යද්‍යද් ආස්තේ තේෂාං ස්‍රෂ්ටේශ්වරස්ත්වං| ");
INSERT INTO sansin_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ත්වං නිජසේවකේන දායූදා වාක්‍යමිදම් උවචිථ, මනුෂ්‍යා අන්‍යදේශීයාඃ කුර්ව්වන්ති කලහං කුතඃ| ලෝකාඃ සර්ව්වේ කිමර්ථං වා චින්තාං කුර්ව්වන්ති නිෂ්ඵලාං| ");
INSERT INTO sansin_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","පරමේශස්‍ය තේනෛවාභිෂික්තස්‍ය ජනස්‍ය ච| විරුද්ධමභිතිෂ්ඨන්ති පෘථිව්‍යාඃ පතයඃ කුතඃ|| ");
INSERT INTO sansin_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","ඵලතස්තව හස්තේන මන්ත්‍රණයා ච පූර්ව්ව යද්‍යත් ස්ථිරීකෘතං තද් යථා සිද්ධං භවති තදර්ථං ත්වං යම් අථිෂික්තවාන් ස ඒව පවිත්‍රෝ යීශුස්තස්‍ය ප්‍රාතිකූල්‍යේන හේරෝද් පන්තීයපීලාතෝ ");
INSERT INTO sansin_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","(අ)න්‍යදේශීයලෝකා ඉස්‍රායේල්ලෝකාශ්ච සර්ව්ව ඒතේ සභායාම් අතිෂ්ඨන්| ");
INSERT INTO sansin_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","හේ පරමේශ්වර අධුනා තේෂාං තර්ජනං ගර්ජනඤ්ච ශෘණු; ");
INSERT INTO sansin_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","තථා ස්වාස්ථ්‍යකරණකර්ම්මණා තව බාහුබලප්‍රකාශපූර්ව්වකං තව සේවකාන් නිර්භයේන තව වාක්‍යං ප්‍රචාරයිතුං තව පවිත්‍රපුත්‍රස්‍ය යීශෝ ර්නාම්නා ආශ්චර‍්‍ය්‍යාණ්‍යසම්භවානි ච කර්ම්මාණි කර්ත්තුඤ්චාඥාපය| ");
INSERT INTO sansin_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ඉත්ථං ප්‍රාර්ථනයා යත්‍ර ස්ථානේ තේ සභායාම් ආසන් තත් ස්ථානං ප්‍රාකම්පත; තතඃ සර්ව්වේ පවිත්‍රේණාත්මනා පරිපූර්ණාඃ සන්ත ඊශ්වරස්‍ය කථාම් අක්‍ෂෝභේණ ප්‍රාචාරයන්| ");
INSERT INTO sansin_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","අපරඤ්ච ප්‍රත්‍යයකාරිලෝකසමූහා ඒකමනස ඒකචිත්තීභූය ස්ථිතාඃ| තේෂාං කේපි නිජසම්පත්තිං ස්වීයාං නාජානන් කින්තු තේෂාං සර්ව්වාඃ සම්පත්ත්‍යඃ සාධාරණ්‍යේන ස්ථිතාඃ| ");
INSERT INTO sansin_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","අන්‍යච්ච ප්‍රේරිතා මහාශක්තිප්‍රකාශපූර්ව්වකං ප්‍රභෝ ර‍්‍යීශෝරුත්ථානේ සාක්‍ෂ්‍යම් අදදුඃ, තේෂු සර්ව්වේෂු මහානුග්‍රහෝ(අ)භවච්ච| ");
INSERT INTO sansin_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","තේෂාං මධ්‍යේ කස්‍යාපි ද්‍රව්‍යන්‍යූනතා නාභවද් යතස්තේෂාං ගෘහභූම්‍යාද්‍යා යාඃ සම්පත්තය ආසන් තා වික්‍රීය ");
INSERT INTO sansin_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","තන්මූල්‍යමානීය ප්‍රේරිතානාං චරණේෂු තෛඃ ස්ථාපිතං; තතඃ ප්‍රත්‍යේකශඃ ප්‍රයෝජනානුසාරේණ දත්තමභවත්| ");
INSERT INTO sansin_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","විශේෂතඃ කුප්‍රෝපද්වීපීයෝ යෝසිනාමකෝ ලේවිවංශජාත ඒකෝ ජනෝ භූම්‍යධිකාරී, යං ප්‍රේරිතා බර්ණබ්බා අර්ථාත් සාන්ත්වනාදායක ඉත්‍යුක්ත්වා සමාහූයන්, ");
INSERT INTO sansin_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ස ජනෝ නිජභූමිං වික්‍රීය තන්මූල්‍යමානීය ප්‍රේරිතානාං චරණේෂු ස්ථාපිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","තදා අනානියනාමක ඒකෝ ජනෝ යස්‍ය භාර‍්‍ය්‍යායා නාම සඵීරා ස ස්වාධිකාරං වික්‍රීය ");
INSERT INTO sansin_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ස්වභාර‍්‍ය්‍යාං ඥාපයිත්වා තන්මූල්‍යස්‍යෛකාංශං සඞ්ගෝප්‍ය ස්ථාපයිත්වා තදන්‍යාංශමාත්‍රමානීය ප්‍රේරිතානාං චරණේෂු සමර්පිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","තස්මාත් පිතරෝකථයත් හේ අනානිය භූමේ ර්මූල්‍යං කිඤ්චිත් සඞ්ගෝප්‍ය ස්ථාපයිතුං පවිත්‍රස්‍යාත්මනඃ සන්නිධෞ මෘෂාවාක්‍යං කථයිතුඤ්ච ශෛතාන් කුතස්තවාන්තඃකරණේ ප්‍රවෘත්තිමජනයත්? ");
INSERT INTO sansin_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","සා භූමි ර‍්‍යදා තව හස්තගතා තදා කිං තව ස්වීයා නාසීත්? තර්හි ස්වාන්තඃකරණේ කුත ඒතාදෘශී කුකල්පනා ත්වයා කෘතා? ත්වං කේවලමනුෂ්‍යස්‍ය නිකටේ මෘෂාවාක්‍යං නාවාදීඃ කින්ත්වීශ්වරස්‍ය නිකටේ(අ)පි| ");
INSERT INTO sansin_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ඒතාං කථාං ශ්‍රුත්වෛව සෝ(අ)නානියෝ භූමෞ පතන් ප්‍රාණාන් අත්‍යජත්, තද්වෘත්තාන්තං යාවන්තෝ ලෝකා අශෘණ්වන් තේෂාං සර්ව්වේෂාං මහාභයම් අජායත්| ");
INSERT INTO sansin_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","තදා යුවලෝකාස්තං වස්ත්‍රේණාච්ඡාද්‍ය බහි ර්නීත්වා ශ්මශානේ(අ)ස්ථාපයන්| ");
INSERT INTO sansin_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","තතඃ ප්‍රහරෛකානන්තරං කිං වෘත්තං තන්නාවගත්‍ය තස්‍ය භාර‍්‍ය්‍යාපි තත්‍ර සමුපස්ථිතා| ");
INSERT INTO sansin_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","තතඃ පිතරස්තාම් අපෘච්ඡත්, යුවාභ්‍යාම් ඒතාවන්මුද්‍රාභ්‍යෝ භූමි ර්වික්‍රීතා න වා? ඒතත්වං වද; තදා සා ප්‍රත්‍යවාදීත් සත්‍යම් ඒතාවද්භ්‍යෝ මුද්‍රාභ්‍ය ඒව| ");
INSERT INTO sansin_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","තතඃ පිතරෝකථයත් යුවාං කථං පරමේශ්වරස්‍යාත්මානං පරීක්‍ෂිතුම් ඒකමන්ත්‍රණාවභවතාං? පශ්‍ය යේ තව පතිං ශ්මශානේ ස්ථාපිතවන්තස්තේ ද්වාරස්‍ය සමීපේ සමුපතිෂ්ඨන්ති ත්වාමපි බහිර්නේෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","තතඃ සාපි තස්‍ය චරණසන්නිධෞ පතිත්වා ප්‍රාණාන් අත්‍යාක්‍ෂීත්| පශ්චාත් තේ යුවානෝ(අ)භ්‍යන්තරම් ආගත්‍ය තාමපි මෘතාං දෘෂ්ට්වා බහි ර්නීත්වා තස්‍යාඃ පත්‍යුඃ පාර්ශ්වේ ශ්මශානේ ස්ථාපිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","තස්මාත් මණ්ඩල්‍යාඃ සර්ව්වේ ලෝකා අන්‍යලෝකාශ්ච තාං වාර්ත්තාං ශ්‍රුත්වා සාධ්වසං ගතාඃ| ");
INSERT INTO sansin_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","තතඃ පරං ප්‍රේරිතානාං හස්තෛ ර්ලෝකානාං මධ්‍යේ බහ්වාශ්චර‍්‍ය්‍යාණ්‍යද්භුතානි කර්ම්මාණ්‍යක්‍රියන්ත; තදා ශිෂ්‍යාඃ සර්ව්ව ඒකචිත්තීභූය සුලේමානෝ (අ)ලින්දේ සම්භූයාසන්| ");
INSERT INTO sansin_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","තේෂාං සඞ්ඝාන්තර්ගෝ භවිතුං කෝපි ප්‍රගල්භතාං නාගමත් කින්තු ලෝකාස්තාන් සමාද්‍රියන්ත| ");
INSERT INTO sansin_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","ස්ත්‍රියඃ පුරුෂාශ්ච බහවෝ ලෝකා විශ්වාස්‍ය ප්‍රභුං ශරණමාපන්නාඃ| ");
INSERT INTO sansin_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","පිතරස්‍ය ගමනාගමනාභ්‍යාං කේනාපි ප්‍රකාරේණ තස්‍ය ඡායා කස්මිංශ්චිජ්ජනේ ලගිෂ්‍යතීත්‍යාශයා ලෝකා රෝගිණඃ ශිවිකයා ඛට්වයා චානීය පථි පථි ස්ථාපිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","චතුර්දික්ස්ථනගරේභ්‍යෝ බහවෝ ලෝකාඃ සම්භූය රෝගිණෝ(අ)පවිත්‍රභුතග්‍රස්තාංශ්ච යිරූශාලමම් ආනයන් තතඃ සර්ව්වේ ස්වස්ථා අක්‍රියන්ත| ");
INSERT INTO sansin_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","අනන්තරං මහායාජකඃ සිදූකිනාං මතග්‍රාහිණස්තේෂාං සහචරාශ්ච ");
INSERT INTO sansin_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","මහාක්‍රෝධාන්ත්විතාඃ සන්තඃ ප්‍රේරිතාන් ධෘත්වා නීචලෝකානාං කාරායාං බද්ධ්වා ස්ථාපිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","කින්තු රාත්‍රෞ පරමේශ්වරස්‍ය දූතඃ කාරායා ද්වාරං මෝචයිත්වා තාන් බහිරානීයාකථයත්, ");
INSERT INTO sansin_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","යූයං ගත්වා මන්දිරේ දණ්ඩායමානාඃ සන්තෝ ලෝකාන් ප්‍රතීමාං ජීවනදායිකාං සර්ව්වාං කථාං ප්‍රචාරයත| ");
INSERT INTO sansin_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ඉති ශ්‍රුත්වා තේ ප්‍රත්‍යූෂේ මන්දිර උපස්ථාය උපදිෂ්ටවන්තඃ| තදා සහචරගණේන සහිතෝ මහායාජක ආගත්‍ය මන්ත්‍රිගණම් ඉස්‍රායේල්වංශස්‍ය සර්ව්වාන් රාජසභාසදඃ සභාස්ථාන් කෘත්වා කාරායාස්තාන් ආපයිතුං පදාතිගණං ප්‍රේරිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","තතස්තේ ගත්වා කාරායාං තාන් අප්‍රාප්‍ය ප්‍රත්‍යාගත්‍ය ඉති වාර්ත්තාම් අවාදිෂුඃ, ");
INSERT INTO sansin_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","වයං තත්‍ර ගත්වා නිර්ව්විඝ්නං කාරායා ද්වාරං රුද්ධං රක්‍ෂකාංශ්ච ද්වාරස්‍ය බහිර්දණ්ඩායමානාන් අදර්ශාම ඒව කින්තු ද්වාරං මෝචයිත්වා තන්මධ්‍යේ කමපි ද්‍රෂ්ටුං න ප්‍රාප්තාඃ| ");
INSERT INTO sansin_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ඒතාං කථාං ශ්‍රුත්වා මහායාජකෝ මන්දිරස්‍ය සේනාපතිඃ ප්‍රධානයාජකාශ්ච, ඉත පරං කිමපරං භවිෂ්‍යතීති චින්තයිත්වා සන්දිග්ධචිත්තා අභවන්| ");
INSERT INTO sansin_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ඒතස්මින්නේව සමයේ කශ්චිත් ජන ආගත්‍ය වාර්ත්තාමේතාම් අවදත් පශ්‍යත යූයං යාන් මානවාන් කාරායාම් අස්ථාපයත තේ මන්දිරේ තිෂ්ඨන්තෝ ලෝකාන් උපදිශන්ති| ");
INSERT INTO sansin_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","තදා මන්දිරස්‍ය සේනාපතිඃ පදාතයශ්ච තත්‍ර ගත්වා චේල්ලෝකාඃ පාෂාණාන් නික්‍ෂිප්‍යාස්මාන් මාරයන්තීති භියා විනත්‍යාචාරං තාන් ආනයන්| ");
INSERT INTO sansin_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","තේ මහාසභායා මධ්‍යේ තාන් අස්ථාපයන් තතඃ පරං මහායාජකස්තාන් අපෘච්ඡත්, ");
INSERT INTO sansin_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","අනේන නාම්නා සමුපදේෂ්ටුං වයං කිං දෘඪං න න්‍යෂේධාම? තථාපි පශ්‍යත යූයං ස්වේෂාං තේනෝපදේශේනේ යිරූශාලමං පරිපූර්ණං කෘත්වා තස්‍ය ජනස්‍ය රක්තපාතජනිතාපරාධම් අස්මාන් ප්‍රත්‍යානේතුං චේෂ්ටධ්වේ| ");
INSERT INTO sansin_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","තතඃ පිතරෝන්‍යප්‍රේරිතාශ්ච ප්‍රත්‍යවදන් මානුෂස්‍යාඥාග්‍රහණාද් ඊශ්වරස්‍යාඥාග්‍රහණම් අස්මාකමුචිතම්| ");
INSERT INTO sansin_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","යං යීශුං යූයං ක්‍රුශේ වේධිත්වාහත තම් අස්මාකං පෛතෘක ඊශ්වර උත්ථාප්‍ය ");
INSERT INTO sansin_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ඉස්‍රායේල්වංශානාං මනඃපරිවර්ත්තනං පාපක්‍ෂමාඤ්ච කර්ත්තුං රාජානං පරිත්‍රාතාරඤ්ච කෘත්වා ස්වදක්‍ෂිණපාර්ශ්වේ තස්‍යාන්නතිම් අකරෝත්| ");
INSERT INTO sansin_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ඒතස්මින් වයමපි සාක්‍ෂිණ ආස්මහේ, තත් කේවලං නහි, ඊශ්වර ආඥාග්‍රාහිභ්‍යෝ යං පවිත්‍රම් ආත්මනං දත්තවාන් සෝපි සාක්‍ෂ්‍යස්ති| ");
INSERT INTO sansin_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","ඒතද්වාක්‍යේ ශ්‍රුතේ තේෂාං හෘදයානි විද්ධාන්‍යභවන් තතස්තේ තාන් හන්තුං මන්ත්‍රිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ඒතස්මින්නේව සමයේ තත්සභාස්ථානාං සර්ව්වලෝකානාං මධ්‍යේ සුඛ්‍යාතෝ ගමිලීයේල්නාමක ඒකෝ ජනෝ ව්‍යවස්ථාපකඃ ඵිරූශිලෝක උත්ථාය ප්‍රේරිතාන් ක්‍ෂණාර්ථං ස්ථානාන්තරං ගන්තුම් ආදිශ්‍ය කථිතවාන්, ");
INSERT INTO sansin_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","හේ ඉස්‍රායේල්වංශීයාඃ සර්ව්වේ යූයම් ඒතාන් මානුෂාන් ප්‍රති යත් කර්ත්තුම් උද්‍යතාස්තස්මින් සාවධානා භවත| ");
INSERT INTO sansin_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","ඉතඃ පූර්ව්වං ථූදානාමෛකෝ ජන උපස්ථාය ස්වං කමපි මහාපුරුෂම් අවදත්, තතඃ ප්‍රායේණ චතුඃශතලෝකාස්තස්‍ය මතග්‍රාහිණෝභවන් පශ්චාත් ස හතෝභවත් තස්‍යාඥාග්‍රාහිණෝ යාවන්තෝ ලෝකාස්තේ සර්ව්වේ විර්කීර්ණාඃ සන්තෝ (අ)කෘතකාර‍්‍ය්‍යා අභවන්| ");
INSERT INTO sansin_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","තස්මාජ්ජනාත් පරං නාමලේඛනසමයේ ගාලීලීයයිහූදානාමෛකෝ ජන උපස්ථාය බහූල්ලෝකාන් ස්වමතං ග්‍රාහීතවාන් තතඃ සෝපි ව්‍යනශ්‍යත් තස්‍යාඥාග්‍රාහිණෝ යාවන්තෝ ලෝකා ආසන් තේ සර්ව්වේ විකීර්ණා අභවන්| ");
INSERT INTO sansin_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","අධුනා වදාමි, යූයම් ඒතාන් මනුෂ්‍යාන් ප්‍රති කිමපි න කෘත්වා ක්‍ෂාන්තා භවත, යත ඒෂ සඞ්කල්ප ඒතත් කර්ම්ම ච යදි මනුෂ්‍යාදභවත් තර්හි විඵලං භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","යදීශ්වරාදභවත් තර්හි යූයං තස්‍යාන්‍යථා කර්ත්තුං න ශක්‍ෂ්‍යථ, වරම් ඊශ්වරරෝධකා භවිෂ්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","තදා තස්‍ය මන්ත්‍රණාං ස්වීකෘත්‍ය තේ ප්‍රේරිතාන් ආහූය ප්‍රහෘත්‍ය යීශෝ ර්නාම්නා කාමපි කථාං කථයිතුං නිෂිධ්‍ය ව්‍යසර්ජන්| ");
INSERT INTO sansin_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","කින්තු තස්‍ය නාමාර්ථං වයං ලජ්ජාභෝගස්‍ය යෝග්‍යත්වේන ගණිතා ඉත්‍යත්‍ර තේ සානන්දාඃ සන්තඃ සභාස්ථානාං සාක්‍ෂාද් අගච්ඡන්| ");
INSERT INTO sansin_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","තතඃ පරං ප්‍රතිදිනං මන්දිරේ ගෘහේ ගෘහේ චාවිශ්‍රාමම් උපදිශ්‍ය යීශුඛ්‍රීෂ්ටස්‍ය සුසංවාදං ප්‍රචාරිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","තස්මින් සමයේ ශිෂ්‍යාණාං බාහුල්‍යාත් ප්‍රාත්‍යහිකදානස්‍ය විශ්‍රාණනෛ ර්භින්නදේශීයානාං විධවාස්ත්‍රීගණ උපේක්‍ෂිතේ සති ඉබ්‍රීයලෝකෛඃ සහාන්‍යදේශීයානාං විවාද උපාතිෂ්ඨත්| ");
INSERT INTO sansin_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","තදා ද්වාදශප්‍රේරිතාඃ සර්ව්වාන් ශිෂ්‍යාන් සංගෘහ්‍යාකථයන් ඊශ්වරස්‍ය කථාප්‍රචාරං පරිත්‍යජ්‍ය භෝජනගවේෂණම් අස්මාකම් උචිතං නහි| ");
INSERT INTO sansin_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","අතෝ හේ භ්‍රාතෘගණ වයම් ඒතත්කර්ම්මණෝ භාරං යේභ්‍යෝ දාතුං ශක්නුම ඒතාදෘශාන් සුඛ්‍යාත්‍යාපන්නාන් පවිත්‍රේණාත්මනා ඥානේන ච පූර්ණාන් සප්ප්‍රජනාන් යූයං ස්වේෂාං මධ්‍යේ මනෝනීතාන් කුරුත, ");
INSERT INTO sansin_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","කින්තු වයං ප්‍රාර්ථනායාං කථාප්‍රචාරකර්ම්මණි ච නිත්‍යප්‍රවෘත්තාඃ ස්ථාස්‍යාමඃ| ");
INSERT INTO sansin_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ඒතස්‍යාං කථායාං සර්ව්වේ ලෝකාඃ සන්තුෂ්ටාඃ සන්තඃ ස්වේෂාං මධ්‍යාත් ස්තිඵානඃ ඵිලිපඃ ප්‍රඛරෝ නිකානෝර් තීමන් පර්ම්මිණා යිහූදිමතග්‍රාහී-ආන්තියඛියානගරීයෝ නිකලා ඒතාන් පරමභක්තාන් පවිත්‍රේණාත්මනා පරිපූර්ණාන් සප්ත ජනාන් ");
INSERT INTO sansin_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ප්‍රේරිතානාං සමක්‍ෂම් ආනයන්, තතස්තේ ප්‍රාර්ථනාං කෘත්වා තේෂාං ශිරඃසු හස්තාන් ආර්පයන්| ");
INSERT INTO sansin_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","අපරඤ්ච ඊශ්වරස්‍ය කථා දේශං ව්‍යාප්නෝත් විශේෂතෝ යිරූශාලමි නගරේ ශිෂ්‍යාණාං සංඛ්‍යා ප්‍රභූතරූපේණාවර්ද්ධත යාජකානාං මධ්‍යේපි බහවඃ ඛ්‍රීෂ්ටමතග්‍රාහිණෝ(අ)භවන්| ");
INSERT INTO sansin_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","ස්තිඵානෝे විශ්වාසේන පරාක්‍රමේණ ච පරිපූර්ණඃ සන් ලෝකානාං මධ්‍යේ බහුවිධම් අද්භුතම් ආශ්චර‍්‍ය්‍යං කර්ම්මාකරෝත්| ");
INSERT INTO sansin_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","තේන ලිබර්ත්තිනීයනාම්නා විඛ්‍යාතසඞ්ඝස්‍ය කතිපයජනාඃ කුරීණීයසිකන්දරීය-කිලිකීයාශීයාදේශීයාඃ කියන්තෝ ජනාශ්චෝත්ථාය ස්තිඵානේන සාර්ද්ධං ව්‍යවදන්ත| ");
INSERT INTO sansin_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","කින්තු ස්තිඵානෝ ඥානේන පවිත්‍රේණාත්මනා ච ඊදෘශීං කථාං කථිතවාන් යස්‍යාස්තේ ආපත්තිං කර්ත්තුං නාශක්නුවන්| ");
INSERT INTO sansin_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","පශ්චාත් තෛ ර්ලෝභිතාඃ කතිපයජනාඃ කථාමේනාම් අකථයන්, වයං තස්‍ය මුඛතෝ මූසා ඊශ්වරස්‍ය ච නින්දාවාක්‍යම් අශ්‍රෞෂ්ම| ");
INSERT INTO sansin_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","තේ ලෝකානාං ලෝකප්‍රාචීනානාම් අධ්‍යාපකානාඤ්ච ප්‍රවෘත්තිං ජනයිත්වා ස්තිඵානස්‍ය සන්නිධිම් ආගත්‍ය තං ධෘත්වා මහාසභාමධ්‍යම් ආනයන්| ");
INSERT INTO sansin_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","තදනන්තරං කතිපයජනේෂු මිථ්‍යාසාක්‍ෂිෂු සමානීතේෂු තේ(අ)කථයන් ඒෂ ජන ඒතත්පුණ්‍යස්ථානව්‍යවස්ථයෝ ර්නින්දාතඃ කදාපි න නිවර්ත්තතේ| ");
INSERT INTO sansin_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ඵලතෝ නාසරතීයයීශුඃ ස්ථානමේතද් උච්ඡින්නං කරිෂ්‍යති මූසාසමර්පිතම් අස්මාකං ව්‍යවහරණම් අන්‍යරූපං කරිෂ්‍යති තස්‍යෛතාදෘශීං කථාං වයම් අශෘණුම| ");
INSERT INTO sansin_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","තදා මහාසභාස්ථාඃ සර්ව්වේ තං ප්‍රති ස්ථිරාං දෘෂ්ටිං කෘත්වා ස්වර්ගදූතමුඛසදෘශං තස්‍ය මුඛම් අපශ්‍යන්| ");
INSERT INTO sansin_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","තතඃ පරං මහායාජකඃ පෘෂ්ටවාන්, ඒෂා කථාං කිං සත්‍යා? ");
INSERT INTO sansin_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","තතඃ ස ප්‍රත්‍යවදත්, හේ පිතරෝ හේ භ්‍රාතරඃ සර්ව්වේ ලාකා මනාංසි නිධද්ධ්වං| අස්මාකං පූර්ව්වපුරුෂ ඉබ්‍රාහීම් හාරණ්නගරේ වාසකරණාත් පූර්ව්වං යදා අරාම්-නහරයිමදේශේ ආසීත් තදා තේජෝමය ඊශ්වරෝ දර්ශනං දත්වා ");
INSERT INTO sansin_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","තමවදත් ත්වං ස්වදේශඥාතිමිත්‍රාණි පරිත්‍යජ්‍ය යං දේශමහං දර්ශයිෂ්‍යාමි තං දේශං ව්‍රජ| ");
INSERT INTO sansin_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","අතඃ ස කස්දීයදේශං විහාය හාරණ්නගරේ න්‍යවසත්, තදනන්තරං තස්‍ය පිතරි මෘතේ යත්‍ර දේශේ යූයං නිවසථ ස ඒනං දේශමාගච්ඡත්| ");
INSERT INTO sansin_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","කින්ත්වීශ්වරස්තස්මෛ කමප්‍යධිකාරම් අර්ථාද් ඒකපදපරිමිතාං භූමිමපි නාදදාත්; තදා තස්‍ය කෝපි සන්තානෝ නාසීත් තථාපි සන්තානෛඃ සාර්ද්ධම් ඒතස්‍ය දේශස්‍යාධිකාරී ත්වං භවිෂ්‍යසීති තම්ප්‍රත්‍යඞ්ගීකෘතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ඊශ්වර ඉත්ථම් අපරමපි කථිතවාන් තව සන්තානාඃ පරදේශේ නිවත්ස්‍යන්ති තතස්තද්දේශීයලෝකාශ්චතුඃශතවත්සරාන් යාවත් තාන් දාසත්වේ ස්ථාපයිත්වා තාන් ප්‍රති කුව්‍යවහාරං කරිෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","අපරම් ඊශ්වර ඒනාං කථාමපි කථිතවාන්, යේ ලෝකාස්තාන් දාසත්වේ ස්ථාපයිෂ්‍යන්ති තාල්ලෝකාන් අහං දණ්ඩයිෂ්‍යාමි, තතඃ පරං තේ බහිර්ගතාඃ සන්තෝ මාම් අත්‍ර ස්ථානේ සේවිෂ්‍යන්තේ| ");
INSERT INTO sansin_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","පශ්චාත් ස තස්මෛ ත්වක්ඡේදස්‍ය නියමං දත්තවාන්, අත ඉස්හාකනාම්නි ඉබ්‍රාහීම ඒකපුත්‍රේ ජාතේ, අෂ්ටමදිනේ තස්‍ය ත්වක්ඡේදම් අකරෝත්| තස්‍ය ඉස්හාකඃ පුත්‍රෝ යාකූබ්, තතස්තස්‍ය යාකූබෝ(අ)ස්මාකං ද්වාදශ පූර්ව්වපුරුෂා අජායන්ත| ");
INSERT INTO sansin_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","තේ පූර්ව්වපුරුෂා ඊර්ෂ්‍යයා පරිපූර්ණා මිසරදේශං ප්‍රේෂයිතුං යූෂඵං ව්‍යක්‍රීණන්| ");
INSERT INTO sansin_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","කින්ත්වීශ්වරස්තස්‍ය සහායෝ භූත්වා සර්ව්වස්‍යා දුර්ගතේ රක්‍ෂිත්වා තස්මෛ බුද්ධිං දත්ත්වා මිසරදේශස්‍ය රාඥඃ ඵිරෞණඃ ප්‍රියපාත්‍රං කෘතවාන් තතෝ රාජා මිසරදේශස්‍ය ස්වීයසර්ව්වපරිවාරස්‍ය ච ශාසනපදං තස්මෛ දත්තවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","තස්මින් සමයේ මිසර-කිනානදේශයෝ ර්දුර්භික්‍ෂහේතෝරතික්ලිෂ්ටත්වාත් නඃ පූර්ව්වපුරුෂා භක්‍ෂ්‍යද්‍රව්‍යං නාලභන්ත| ");
INSERT INTO sansin_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","කින්තු මිසරදේශේ ශස්‍යානි සන්ති, යාකූබ් ඉමාං වාර්ත්තාං ශ්‍රුත්වා ප්‍රථමම් අස්මාකං පූර්ව්වපුරුෂාන් මිසරං ප්‍රේෂිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","තතෝ ද්විතීයවාරගමනේ යූෂඵ් ස්වභ්‍රාතෘභිඃ පරිචිතෝ(අ)භවත්; යූෂඵෝ භ්‍රාතරඃ ඵිරෞණ් රාජේන පරිචිතා අභවන්| ");
INSERT INTO sansin_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","අනන්තරං යූෂඵ් භ්‍රාතෘගණං ප්‍රේෂ්‍ය නිජපිතරං යාකූබං නිජාන් පඤ්චාධිකසප්තතිසංඛ්‍යකාන් ඥාතිජනාංශ්ච සමාහූතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","තස්මාද් යාකූබ් මිසරදේශං ගත්වා ස්වයම් අස්මාකං පූර්ව්වපුරුෂාශ්ච තස්මින් ස්ථානේ(අ)ම්‍රියන්ත| ");
INSERT INTO sansin_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","තතස්තේ ශිඛිමං නීතා යත් ශ්මශානම් ඉබ්‍රාහීම් මුද්‍රාදත්වා ශිඛිමඃ පිතු ර්හමෝරඃ පුත්‍රේභ්‍යඃ ක්‍රීතවාන් තත්ශ්මශානේ ස්ථාපයාඤ්චක්‍රිරේ| ");
INSERT INTO sansin_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","තතඃ පරම් ඊශ්වර ඉබ්‍රාහීමඃ සන්නිධෞ ශපථං කෘත්වා යාං ප්‍රතිඥාං කෘතවාන් තස්‍යාඃ ප්‍රතිඥායාඃ ඵලනසමයේ නිකටේ සති ඉස්‍රායේල්ලෝකා සිමරදේශේ වර්ද්ධමානා බහුසංඛ්‍යා අභවන්| ");
INSERT INTO sansin_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ශේෂේ යූෂඵං යෝ න පරිචිනෝති තාදෘශ ඒකෝ නරපතිරුපස්ථාය ");
INSERT INTO sansin_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","අස්මාකං ඥාතිභිඃ සාර්ද්ධං ධූර්ත්තතාං විධාය පූර්ව්වපුරුෂාන් ප්‍රති කුව්‍යවහරණපූර්ව්වකං තේෂාං වංශනාශනාය තේෂාං නවජාතාන් ශිශූන් බහි ර්නිරක්‍ෂේපයත්| ");
INSERT INTO sansin_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","ඒතස්මින් සමයේ මූසා ජඥේ, ස තු පරමසුන්දරෝ(අ)භවත් තථා පිතෘගෘහේ මාසත්‍රයපර‍්‍ය්‍යන්තං පාලිතෝ(අ)භවත්| ");
INSERT INTO sansin_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","කින්තු තස්මින් බහිර්නික්‍ෂිප්තේ සති ඵිරෞණරාජස්‍ය කන්‍යා තම් උත්තෝල්‍ය නීත්වා දත්තකපුත්‍රං කෘත්වා පාලිතවතී| ");
INSERT INTO sansin_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","තස්මාත් ස මූසා මිසරදේශීයායාඃ සර්ව්වවිද්‍යායාඃ පාරදෘෂ්වා සන් වාක්‍යේ ක්‍රියායාඤ්ච ශක්තිමාන් අභවත්| ");
INSERT INTO sansin_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","ස සම්පූර්ණචත්වාරිංශද්වත්සරවයස්කෝ භූත්වා ඉස්‍රායේලීයවංශනිජභ්‍රාතෘන් සාක්‍ෂාත් කර්තුං මතිං චක්‍රේ| ");
INSERT INTO sansin_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","තේෂාං ජනමේකං හිංසිතං දෘෂ්ට්වා තස්‍ය සපක්‍ෂඃ සන් හිංසිතජනම් උපකෘත්‍ය මිසරීයජනං ජඝාන| ");
INSERT INTO sansin_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","තස්‍ය හස්තේනේශ්වරස්තාන් උද්ධරිෂ්‍යති තස්‍ය භ්‍රාතෘගණ ඉති ඥාස්‍යති ස ඉත්‍යනුමානං චකාර, කින්තු තේ න බුබුධිරේ| ");
INSERT INTO sansin_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","තත්පරේ (අ)හනි තේෂාම් උභයෝ ර්ජනයෝ ර්වාක්කලහ උපස්ථිතේ සති මූසාඃ සමීපං ගත්වා තයෝ ර්මේලනං කර්ත්තුං මතිං කෘත්වා කථයාමාස, හේ මහාශයෞ යුවාං භ්‍රාතරෞ පරස්පරම් අන්‍යායං කුතඃ කුරුථඃ? ");
INSERT INTO sansin_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","තතඃ සමීපවාසිනං ප්‍රති යෝ ජනෝ(අ)න්‍යායං චකාර ස තං දූරීකෘත්‍ය කථයාමාස, අස්මාකමුපරි ශාස්තෘත්වවිචාරයිතෘත්වපදයෝඃ කස්ත්වාං නියුක්තවාන්? ");
INSERT INTO sansin_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","හ්‍යෝ යථා මිසරීයං හතවාන් තථා කිං මාමපි හනිෂ්‍යසි? ");
INSERT INTO sansin_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","තදා මූසා ඒතාදෘශීං කථාං ශ්‍රුත්වා පලායනං චක්‍රේ, තතෝ මිදියනදේශං ගත්වා ප්‍රවාසී සන් තස්ථෞ, තතස්තත්‍ර ද්වෞ පුත්‍රෞ ජඥාතේ| ");
INSERT INTO sansin_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","අනන්තරං චත්වාරිංශද්වත්සරේෂු ගතේෂු සීනයපර්ව්වතස්‍ය ප්‍රාන්තරේ ප්‍රජ්වලිතස්තම්බස්‍ය වහ්නිශිඛායාං පරමේශ්වරදූතස්තස්මෛ දර්ශනං දදෞ| ");
INSERT INTO sansin_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","මූසාස්තස්මින් දර්ශනේ විස්මයං මත්වා විශේෂං ඥාතුං නිකටං ගච්ඡති, ");
INSERT INTO sansin_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","ඒතස්මින් සමයේ, අහං තව පූර්ව්වපුරුෂාණාම් ඊශ්වරෝ(අ)ර්ථාද් ඉබ්‍රාහීම ඊශ්වර ඉස්හාක ඊශ්වරෝ යාකූබ ඊශ්වරශ්ච, මූසාමුද්දිශ්‍ය පරමේශ්වරස්‍යෛතාදෘශී විහායසීයා වාණී බභූව, තතඃ ස කම්පාන්විතඃ සන් පුන ර්නිරීක්‍ෂිතුං ප්‍රගල්භෝ න බභූව| ");
INSERT INTO sansin_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","පරමේශ්වරස්තං ජගාද, තව පාදයෝඃ පාදුකේ මෝචය යත්‍ර තිෂ්ඨසි සා පවිත්‍රභූමිඃ| ");
INSERT INTO sansin_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","අහං මිසරදේශස්ථානාං නිජලෝකානාං දුර්ද්දශාං නිතාන්තම් අපශ්‍යං, තේෂාං කාතර‍්‍ය්‍යෝක්තිඤ්ච ශ්‍රුතවාන් තස්මාත් තාන් උද්ධර්ත්තුම් අවරුහ්‍යාගමම්; ඉදානීම් ආගච්ඡ මිසරදේශං ත්වාං ප්‍රේෂයාමි| ");
INSERT INTO sansin_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","කස්ත්වාං ශාස්තෘත්වවිචාරයිතෘත්වපදයෝ ර්නියුක්තවාන්, ඉති වාක්‍යමුක්ත්වා තෛ ර‍්‍යෝ මූසා අවඥාතස්තමේව ඊශ්වරඃ ස්තම්බමධ්‍යේ දර්ශනදාත්‍රා තේන දූතේන ශාස්තාරං මුක්තිදාතාරඤ්ච කෘත්වා ප්‍රේෂයාමාස| ");
INSERT INTO sansin_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","ස ච මිසරදේශේ සූඵ්නාම්නි සමුද්‍රේ ච පශ්චාත් චත්වාරිංශද්වත්සරාන් යාවත් මහාප්‍රාන්තරේ නානාප්‍රකාරාණ්‍යද්භුතානි කර්ම්මාණි ලක්‍ෂණානි ච දර්ශයිත්වා තාන් බහිඃ කෘත්වා සමානිනාය| ");
INSERT INTO sansin_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","ප්‍රභුඃ පරමේශ්වරෝ යුෂ්මාකං භ්‍රාතෘගණස්‍ය මධ්‍යේ මාදෘශම් ඒකං භවිෂ්‍යද්වක්තාරම් උත්පාදයිෂ්‍යති තස්‍ය කථායාං යූයං මනෝ නිධාස්‍යථ, යෝ ජන ඉස්‍රායේලඃ සන්තානේභ්‍ය ඒනාං කථාං කථයාමාස ස ඒෂ මූසාඃ| ");
INSERT INTO sansin_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","මහාප්‍රාන්තරස්ථමණ්ඩලීමධ්‍යේ(අ)පි ස ඒව සීනයපර්ව්වතෝපරි තේන සාර්ද්ධං සංලාපිනෝ දූතස්‍ය චාස්මත්පිතෘගණස්‍ය මධ්‍යස්ථඃ සන් අස්මභ්‍යං දාතව්‍යනි ජීවනදායකානි වාක්‍යානි ලේභේ| ");
INSERT INTO sansin_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","අස්මාකං පූර්ව්වපුරුෂාස්තම් අමාන්‍යං කත්වා ස්වේභ්‍යෝ දූරීකෘත්‍ය මිසරදේශං පරාවෘත්‍ය ගන්තුං මනෝභිරභිලෂ්‍ය හාරෝණං ජගදුඃ, ");
INSERT INTO sansin_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","අස්මාකම් අග්‍රේ(අ)ග්‍රේ ගන්තුुම් අස්මදර්ථං දේවගණං නිර්ම්මාහි යතෝ යෝ මූසා අස්මාන් මිසරදේශාද් බහිඃ කෘත්වානීතවාන් තස්‍ය කිං ජාතං තදස්මාභි ර්න ඥායතේ| ");
INSERT INTO sansin_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","තස්මින් සමයේ තේ ගෝවත්සාකෘතිං ප්‍රතිමාං නිර්ම්මාය තාමුද්දිශ්‍ය නෛවේද්‍යමුත්මෘජ්‍ය ස්වහස්තකෘතවස්තුනා ආනන්දිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","තස්මාද් ඊශ්වරස්තේෂාං ප්‍රති විමුඛඃ සන් ආකාශස්ථං ජ්‍යෝතිර්ගණං පූජයිතුං තේභ්‍යෝ(අ)නුමතිං දදෞ, යාදෘශං භවිෂ්‍යද්වාදිනාං ග්‍රන්ථේෂු ලිඛිතමාස්තේ, යථා, ඉස්‍රායේලීයවංශා රේ චත්වාරිංශත්සමාන් පුරා| මහති ප්‍රාන්තරේ සංස්ථා යූයන්තු යානි ච| බලිහෝමාදිකර්ම්මාණි කෘතවන්තස්තු තානි කිං| මාං සමුද්දිශ්‍ය යුෂ්මාභිඃ ප්‍රකෘතානීති නෛව ච| ");
INSERT INTO sansin_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","කින්තු වෝ මෝලකාඛ්‍යස්‍ය දේවස්‍ය දූෂ්‍යමේව ච| යුෂ්මාකං රිම්ඵනාඛ්‍යායා දේවතායාශ්ච තාරකා| ඒතයෝරුභයෝ ර්මූර්තී යුෂ්මාභිඃ පරිපූජිතේ| අතෝ යුෂ්මාංස්තු බාබේලඃ පාරං නේෂ්‍යාමි නිශ්චිතං| ");
INSERT INTO sansin_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","අපරඤ්ච යන්නිදර්ශනම් අපශ්‍යස්තදනුසාරේණ දූෂ්‍යං නිර්ම්මාහි යස්මින් ඊශ්වරෝ මූසාම් ඒතද්වාක්‍යං බභාෂේ තත් තස්‍ය නිරූපිතං සාක්‍ෂ්‍යස්වරූපං දූෂ්‍යම් අස්මාකං පූර්ව්වපුරුෂෛඃ සහ ප්‍රාන්තරේ තස්ථෞ| ");
INSERT INTO sansin_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","පශ්චාත් යිහෝශූයේන සහිතෛස්තේෂාං වංශජාතෛරස්මත්පූර්ව්වපුරුෂෛඃ ස්වේෂාං සම්මුඛාද් ඊශ්වරේණ දූරීකෘතානාම් අන්‍යදේශීයානාං දේශාධිකෘතිකාලේ සමානීතං තද් දූෂ්‍යං දායූදෝධිකාරං යාවත් තත්‍ර ස්ථාන ආසීත්| ");
INSERT INTO sansin_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ස දායූද් පරමේශ්වරස්‍යානුග්‍රහං ප්‍රාප්‍ය යාකූබ් ඊශ්වරාර්ථම් ඒකං දූෂ්‍යං නිර්ම්මාතුං වවාඤ්ඡ; ");
INSERT INTO sansin_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","කින්තු සුලේමාන් තදර්ථං මන්දිරම් ඒකං නිර්ම්මිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","තථාපි යඃ සර්ව්වෝපරිස්ථඃ ස කස්මිංශ්චිද් හස්තකෘතේ මන්දිරේ නිවසතීති නහි, භවිෂ්‍යද්වාදී කථාමේතාං කථයති, යථා, ");
INSERT INTO sansin_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","පරේශෝ වදති ස්වර්ගෝ රාජසිංහාසනං මම| මදීයං පාදපීඨඤ්ච පෘථිවී භවති ධ්‍රුවං| තර්හි යූයං කෘතේ මේ කිං ප්‍රනිර්ම්මාස්‍යථ මන්දිරං| විශ්‍රාමාය මදීයං වා ස්ථානං කිං විද්‍යතේ ත්විහ| ");
INSERT INTO sansin_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","සර්ව්වාණ්‍යේතානි වස්තූනි කිං මේ හස්තකෘතානි න|| ");
INSERT INTO sansin_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","හේ අනාඥාග්‍රාහකා අන්තඃකරණේ ශ්‍රවණේ චාපවිත්‍රලෝකාඃ යූයම් අනවරතං පවිත්‍රස්‍යාත්මනඃ ප්‍රාතිකූල්‍යම් ආචරථ, යුෂ්මාකං පූර්ව්වපුරුෂා යාදෘශා යූයමපි තාදෘශාඃ| ");
INSERT INTO sansin_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","යුෂ්මාකං පූර්ව්වපුරුෂාඃ කං භවිෂ්‍යද්වාදිනං නාතාඩයන්? යේ තස්‍ය ධාර්ම්මිකස්‍ය ජනස්‍යාගමනකථාං කථිතවන්තස්තාන් අඝ්නන් යූයම් අධූනා විශ්වාසඝාතිනෝ භූත්වා තං ධාර්ම්මිකං ජනම් අහත| ");
INSERT INTO sansin_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","යූයං ස්වර්ගීයදූතගණේන ව්‍යවස්ථාං ප්‍රාප්‍යාපි තාං නාචරථ| ");
INSERT INTO sansin_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ඉමාං කථාං ශ්‍රුත්වා තේ මනඃසු බිද්ධාඃ සන්තස්තං ප්‍රති දන්තඝර්ෂණම් අකුර්ව්වන්| ");
INSERT INTO sansin_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","කින්තු ස්තිඵානඃ පවිත්‍රේණාත්මනා පූර්ණෝ භූත්වා ගගණං ප්‍රති ස්ථිරදෘෂ්ටිං කෘත්වා ඊශ්වරස්‍ය දක්‍ෂිණේ දණ්ඩායමානං යීශුඤ්ච විලෝක්‍ය කථිතවාන්; ");
INSERT INTO sansin_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","පශ්‍ය,මේඝද්වාරං මුක්තම් ඊශ්වරස්‍ය දක්‍ෂිණේ ස්ථිතං මානවසුතඤ්ච පශ්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","තදා තේ ප්‍රෝච්චෛඃ ශබ්දං කෘත්වා කර්ණේෂ්වඞ්ගුලී ර්නිධාය ඒකචිත්තීභූය තම් ආක්‍රමන්| ");
INSERT INTO sansin_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","පශ්චාත් තං නගරාද් බහිඃ කෘත්වා ප්‍රස්තරෛරාඝ්නන් සාක්‍ෂිණෝ ලාකාඃ ශෞලනාම්නෝ යූනශ්චරණසන්නිධෞ නිජවස්ත්‍රාණි ස්ථාපිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","අනන්තරං හේ ප්‍රභෝ යීශේ මදීයමාත්මානං ගෘහාණ ස්තිඵානස්‍යේති ප්‍රාර්ථනවාක්‍යවදනසමයේ තේ තං ප්‍රස්තරෛරාඝ්නන්| ");
INSERT INTO sansin_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","තස්මාත් ස ජානුනී පාතයිත්වා ප්‍රෝච්චෛඃ ශබ්දං කෘත්වා, හේ ප්‍රභේ පාපමේතද් ඒතේෂු මා ස්ථාපය, ඉත්‍යුක්ත්වා මහානිද්‍රාං ප්‍රාප්නෝත්| ");
INSERT INTO sansin_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","තස්‍ය හත්‍යාකරණං ශෞලෝපි සමමන්‍යත| තස්මින් සමයේ යිරූශාලම්නගරස්ථාං මණ්ඩලීං ප්‍රති මහාතාඩනායාං ජාතායාං ප්‍රේරිතලෝකාන් හිත්වා සර්ව්වේ(අ)පරේ යිහූදාශෝමිරෝණදේශයෝ ර්නානාස්ථානේ විකීර්ණාඃ සන්තෝ ගතාඃ| ");
INSERT INTO sansin_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","අන්‍යච්ච භක්තලෝකාස්තං ස්තිඵානං ශ්මශානේ ස්ථාපයිත්වා බහු ව්‍යලපන්| ");
INSERT INTO sansin_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","කින්තු ශෞලෝ ගෘහේ ගෘහේ භ්‍රමිත්වා ස්ත්‍රියඃ පුරුෂාංශ්ච ධෘත්වා කාරායාං බද්ධ්වා මණ්ඩල්‍යා මහෝත්පාතං කෘතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","අන්‍යච්ච යේ විකීර්ණා අභවන් තේ සර්ව්වත්‍ර භ්‍රමිත්වා සුසංවාදං ප්‍රාචාරයන්| ");
INSERT INTO sansin_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","තදා ඵිලිපඃ ශෝමිරෝණ්නගරං ගත්වා ඛ්‍රීෂ්ටාඛ්‍යානං ප්‍රාචාරයත්; ");
INSERT INTO sansin_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","තතෝ(අ)ශුචි-භෘතග්‍රස්තලෝකේභ්‍යෝ භූතාශ්චීත්කෘත්‍යාගච්ඡන් තථා බහවඃ පක්‍ෂාඝාතිනඃ ඛඤ්ජා ලෝකාශ්ච ස්වස්ථා අභවන්| ");
INSERT INTO sansin_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","තස්මාත් ලාකා ඊදෘශං තස්‍යාශ්චර‍්‍ය්‍යං කර්ම්ම විලෝක්‍ය නිශම්‍ය ච සර්ව්ව ඒකචිත්තීභූය තේනෝක්තාඛ්‍යානේ මනාංසි න්‍යදධුඃ| ");
INSERT INTO sansin_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","තස්මින්නගරේ මහානන්දශ්චාභවත්| ");
INSERT INTO sansin_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","තතඃ පූර්ව්වං තස්මින්නගරේ ශිමෝන්නාමා කශ්චිජ්ජනෝ බහ්වී ර්මායාක්‍රියාඃ කෘත්වා ස්වං කඤ්චන මහාපුරුෂං ප්‍රෝච්‍ය ශෝමිරෝණීයානාං මෝහං ජනයාමාස| ");
INSERT INTO sansin_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","තස්මාත් ස මානුෂ ඊශ්වරස්‍ය මහාශක්තිස්වරූප ඉත්‍යුක්ත්වා බාලවෘද්ධවනිතාඃ සර්ව්වේ ලාකාස්තස්මින් මනාංසි න්‍යදධුඃ| ");
INSERT INTO sansin_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ස බහුකාලාන් මායාවික්‍රියයා සර්ව්වාන් අතීව මෝහයාඤ්චකාර, තස්මාත් තේ තං මේනිරේ| ");
INSERT INTO sansin_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","කින්ත්වීශ්වරස්‍ය රාජ්‍යස්‍ය යීශුඛ්‍රීෂ්ටස්‍ය නාම්නශ්චාඛ්‍යානප්‍රචාරිණඃ ඵිලිපස්‍ය කථායාං විශ්වස්‍ය තේෂාං ස්ත්‍රීපුරුෂෝභයලෝකා මජ්ජිතා අභවන්| ");
INSERT INTO sansin_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ශේෂේ ස ශිමෝනපි ස්වයං ප්‍රත්‍යෛත් තතෝ මජ්ජිතඃ සන් ඵිලිපේන කෘතාම් ආශ්චර‍්‍ය්‍යක්‍රියාං ලක්‍ෂණඤ්ච විලෝක්‍යාසම්භවං මන්‍යමානස්තේන සහ ස්ථිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ඉත්ථං ශෝමිරෝණ්දේශීයලෝකා ඊශ්වරස්‍ය කථාම් අගෘහ්ලන් ඉති වාර්ත්තාං යිරූශාලම්නගරස්ථප්‍රේරිතාඃ ප්‍රාප්‍ය පිතරං යෝහනඤ්ච තේෂාං නිකටේ ප්‍රේෂිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","තතස්තෞ තත් ස්ථානම් උපස්ථාය ලෝකා යථා පවිත්‍රම් ආත්මානං ප්‍රාප්නුවන්ති තදර්ථං ප්‍රාර්ථයේතාං| ");
INSERT INTO sansin_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","යතස්තේ පුරා කේවලප්‍රභුයීශෝ ර්නාම්නා මජ්ජිතමාත්‍රා අභවන්, න තු තේෂාං මධ්‍යේ කමපි ප්‍රති පවිත්‍රස්‍යාත්මන ආවිර්භාවෝ ජාතඃ| ");
INSERT INTO sansin_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","කින්තු ප්‍රේරිතාභ්‍යාං තේෂාං ගාත්‍රේෂු කරේෂ්වර්පිතේෂු සත්සු තේ පවිත්‍රම් ආත්මානම් ප්‍රාප්නුවන්| ");
INSERT INTO sansin_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","ඉත්ථං ලෝකානාං ගාත්‍රේෂු ප්‍රේරිතයෝඃ කරාර්පණේන තාන් පවිත්‍රම් ආත්මානං ප්‍රාප්තාන් දෘෂ්ට්වා ස ශිමෝන් තයෝඃ සමීපේ මුද්‍රා ආනීය කථිතවාන්; ");
INSERT INTO sansin_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","අහං යස්‍ය ගාත්‍රේ හස්තම් අර්පයිෂ්‍යාමි තස්‍යාපි යථේත්ථං පවිත්‍රාත්මප්‍රාප්ති ර්භවති තාදෘශීං ශක්තිං මහ්‍යං දත්තං| ");
INSERT INTO sansin_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","කින්තු පිතරස්තං ප්‍රත්‍යවදත් තව මුද්‍රාස්ත්වයා විනශ්‍යන්තු යත ඊශ්වරස්‍ය දානං මුද්‍රාභිඃ ක්‍රීයතේ ත්වමිත්ථං බුද්ධවාන්; ");
INSERT INTO sansin_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ඊශ්වරාය තාවන්තඃකරණං සරලං නහි, තස්මාද් අත්‍ර තවාංශෝ(අ)ධිකාරශ්ච කෝපි නාස්ති| ");
INSERT INTO sansin_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","අත ඒතත්පාපහේතෝඃ ඛේදාන්විතඃ සන් කේනාපි ප්‍රකාරේණ තව මනස ඒතස්‍යාඃ කුකල්පනායාඃ ක්‍ෂමා භවති, ඒතදර්ථම් ඊශ්වරේ ප්‍රාර්ථනාං කුරු; ");
INSERT INTO sansin_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","යතස්ත්වං තික්තපිත්තේ පාපස්‍ය බන්ධනේ ච යදසි තන්මයා බුද්ධම්| ");
INSERT INTO sansin_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","තදා ශිමෝන් අකථයත් තර්හි යුවාභ්‍යාමුදිතා කථා මයි යථා න ඵලති තදර්ථං යුවාං මන්නිමිත්තං ප්‍රභෞ ප්‍රාර්ථනාං කුරුතං| ");
INSERT INTO sansin_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","අනේන ප්‍රකාරේණ තෞ සාක්‍ෂ්‍යං දත්ත්වා ප්‍රභෝඃ කථාං ප්‍රචාරයන්තෞ ශෝමිරෝණීයානාම් අනේකග්‍රාමේෂු සුසංවාදඤ්ච ප්‍රචාරයන්තෞ යිරූශාලම්නගරං පරාවෘත්‍ය ගතෞ| ");
INSERT INTO sansin_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","තතඃ පරම් ඊශ්වරස්‍ය දූතඃ ඵිලිපම් ඉත්‍යාදිශත්, ත්වමුත්ථාය දක්‍ෂිණස්‍යාං දිශි යෝ මාර්ගෝ ප්‍රාන්තරස්‍ය මධ්‍යේන යිරූශාලමෝ (අ)සානගරං යාති තං මාර්ගං ගච්ඡ| ");
INSERT INTO sansin_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","තතඃ ස උත්ථාය ගතවාන්; තදා කන්දාකීනාම්නඃ කූශ්ලෝකානාං රාඥ්‍යාඃ සර්ව්වසම්පත්තේරධීශඃ කූශදේශීය ඒකඃ ෂණ්ඩෝ භජනාර්ථං යිරූශාලම්නගරම් ආගත්‍ය ");
INSERT INTO sansin_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","පුනරපි රථමාරුහ්‍ය යිශයියනාම්නෝ භවිෂ්‍යද්වාදිනෝ ග්‍රන්ථං පඨන් ප්‍රත්‍යාගච්ඡති| ");
INSERT INTO sansin_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ඒතස්මින් සමයේ ආත්මා ඵිලිපම් අවදත්, ත්වම් රථස්‍ය සමීපං ගත්වා තේන සාර්ද්ධං මිල| ");
INSERT INTO sansin_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","තස්මාත් ස ධාවන් තස්‍ය සන්නිධාවුපස්ථාය තේන පඨ්‍යමානං යිශයියථවිෂ්‍යද්වාදිනෝ වාක්‍යං ශ්‍රුත්වා පෘෂ්ටවාන් යත් පඨසි තත් කිං බුධ්‍යසේ? ");
INSERT INTO sansin_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","තතඃ ස කථිතවාන් කේනචින්න බෝධිතෝහං කථං බුධ්‍යේය? තතඃ ස ඵිලිපං රථමාරෝඪුං ස්වේන සාර්ද්ධම් උපවේෂ්ටුඤ්ච න්‍යවේදයත්| ");
INSERT INTO sansin_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ස ශාස්ත්‍රස්‍යේතද්වාක්‍යං පඨිතවාන් යථා, සමානීයත ඝාතාය ස යථා මේෂශාවකඃ| ලෝමච්ඡේදකසාක්‍ෂාච්ච මේෂශ්ච නීරවෝ යථා| ආබධ්‍ය වදනං ස්වීයං තථා ස සමතිෂ්ඨත| ");
INSERT INTO sansin_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","අන්‍යායේන විචාරේණ ස උච්ඡින්නෝ (අ)භවත් තදා| තත්කාලීනමනුෂ්‍යාන් කෝ ජනෝ වර්ණයිතුං ක්‍ෂමඃ| යතෝ ජීවන්නෘණාං දේශාත් ස උච්ඡින්නෝ (අ)භවත් ධ්‍රුවං| ");
INSERT INTO sansin_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","අනන්තරං ස ඵිලිපම් අවදත් නිවේදයාමි, භවිෂ්‍යද්වාදී යාමිමාං කථාං කථයාමාස ස කිං ස්වස්මින් වා කස්මිංශ්චිද් අන්‍යස්මින්? ");
INSERT INTO sansin_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","තතඃ ඵිලිපස්තත්ප්‍රකරණම් ආරභ්‍ය යීශෝරුපාඛ්‍යානං තස්‍යාග්‍රේ ප්‍රාස්තෞත්| ");
INSERT INTO sansin_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ඉත්ථං මාර්ගේණ ගච්ඡන්තෞ ජලාශයස්‍ය සමීප උපස්ථිතෞ; තදා ක්ලීබෝ(අ)වාදීත් පශ්‍යාත්‍ර ස්ථානේ ජලමාස්තේ මම මජ්ජනේ කා බාධා? ");
INSERT INTO sansin_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","තතඃ ඵිලිප උත්තරං ව්‍යාහරත් ස්වාන්තඃකරණේන සාකං යදි ප්‍රත්‍යේෂි තර්හි බාධා නාස්ති| තතඃ ස කථිතවාන් යීශුඛ්‍රීෂ්ට ඊශ්වරස්‍ය පුත්‍ර ඉත්‍යහං ප්‍රත්‍යේමි| ");
INSERT INTO sansin_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","තදා රථං ස්ථගිතං කර්ත්තුම් ආදිෂ්ටේ ඵිලිපක්ලීබෞ ද්වෞ ජලම් අවාරුහතාං; තදා ඵිලිපස්තම් මජ්ජයාමාස| ");
INSERT INTO sansin_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","තත්පශ්චාත් ජලමධ්‍යාද් උත්ථිතයෝඃ සතෝඃ පරමේශ්වරස්‍යාත්මා ඵිලිපං හෘත්වා නීතවාන්, තස්මාත් ක්ලීබඃ පුනස්තං න දෘෂ්ටවාන් තථාපි හෘෂ්ටචිත්තඃ සන් ස්වමාර්ගේණ ගතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ඵිලිපශ්චාස්දෝද්නගරම් උපස්ථාය තස්මාත් කෛසරියානගර උපස්ථිතිකාලපර‍්‍ය්‍යනතං සර්ව්වස්මින්නගරේ සුසංවාදං ප්‍රචාරයන් ගතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","තත්කාලපර‍්‍ය්‍යනතං ශෞලඃ ප්‍රභෝඃ ශිෂ්‍යාණාං ප්‍රාතිකූල්‍යේන තාඩනාබධයෝඃ කථාං නිඃසාරයන් මහායාජකස්‍ය සන්නිධිං ගත්වා ");
INSERT INTO sansin_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ස්ත්‍රියං පුරුෂඤ්ච තන්මතග්‍රාහිණං යං කඤ්චිත් පශ්‍යති තාන් ධෘත්වා බද්ධ්වා යිරූශාලමම් ආනයතීත්‍යාශයේන දම්මේෂක්නගරීයං ධර්ම්මසමාජාන් ප්‍රති පත්‍රං යාචිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","ගච්ඡන් තු දම්මේෂක්නගරනිකට උපස්ථිතවාන්; තතෝ(අ)කස්මාද් ආකාශාත් තස්‍ය චතුර්දික්‍ෂු තේජසඃ ප්‍රකාශනාත් ස භූමාවපතත්| ");
INSERT INTO sansin_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","පශ්චාත් හේ ශෞල හේ ශෞල කුතෝ මාං තාඩයසි? ස්වං ප්‍රති ප්‍රෝක්තම් ඒතං ශබ්දං ශ්‍රුත්වා ");
INSERT INTO sansin_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ස පෘෂ්ටවාන්, හේ ප්‍රභෝ භවාන් කඃ? තදා ප්‍රභුරකථයත් යං යීශුං ත්වං තාඩයසි ස ඒවාහං; කණ්ටකස්‍ය මුඛේ පදාඝාතකරණං තව කෂ්ටම්| ");
INSERT INTO sansin_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","තදා කම්පමානෝ විස්මයාපන්නශ්ච සෝවදත් හේ ප්‍රභෝ මයා කිං කර්ත්තව්‍යං? භවත ඉච්ඡා කා? තතඃ ප්‍රභුරාඥාපයද් උත්ථාය නගරං ගච්ඡ තත්‍ර ත්වයා යත් කර්ත්තව්‍යං තද් වදිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","තස්‍ය සඞ්ගිනෝ ලෝකා අපි තං ශබ්දං ශ්‍රුතවන්තඃ කින්තු කමපි න දෘෂ්ට්වා ස්තබ්ධාඃ සන්තඃ ස්ථිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","අනන්තරං ශෞලෝ භූමිත උත්ථාය චක්‍ෂුෂී උන්මීල්‍ය කමපි න දෘෂ්ටවාන්| තදා ලෝකාස්තස්‍ය හස්තෞ ධෘත්වා දම්මේෂක්නගරම් ආනයන්| ");
INSERT INTO sansin_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","තතඃ ස දිනත්‍රයං යාවද් අන්ධෝ භූත්වා න භුක්තවාන් පීතවාංශ්ච| ");
INSERT INTO sansin_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","තදනන්තරං ප්‍රභුස්තද්දම්මේෂක්නගරවාසින ඒකස්මෛ ශිෂ්‍යාය දර්ශනං දත්වා ආහූතවාන් හේ අනනිය| තතඃ ස ප්‍රත්‍යවාදීත්, හේ ප්‍රභෝ පශ්‍ය ශෘණෝමි| ");
INSERT INTO sansin_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","තදා ප්‍රභුස්තමාඥාපයත් ත්වමුත්ථාය සරලනාමානං මාර්ගං ගත්වා යිහූදානිවේශනේ තාර්ෂනගරීයං ශෞලනාමානං ජනං ගවේෂයන් පෘච්ඡ; ");
INSERT INTO sansin_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","පශ්‍ය ස ප්‍රාර්ථයතේ, තථා අනනියනාමක ඒකෝ ජනස්තස්‍ය සමීපම් ආගත්‍ය තස්‍ය ගාත්‍රේ හස්තාර්පණං කෘත්වා දෘෂ්ටිං දදාතීත්ථං ස්වප්නේ දෘෂ්ටවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","තස්මාද් අනනියඃ ප්‍රත්‍යවදත් හේ ප්‍රභෝ යිරූශාලමි පවිත්‍රලෝකාන් ප්‍රති සෝ(අ)නේකහිංසාං කෘතවාන්; ");
INSERT INTO sansin_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","අත්‍ර ස්ථානේ ච යේ ලෝකාස්තව නාම්නි ප්‍රාර්ථයන්ති තානපි බද්ධුං ස ප්‍රධානයාජකේභ්‍යඃ ශක්තිං ප්‍රාප්තවාන්, ඉමාං කථාම් අහම් අනේකේෂාං මුඛේභ්‍යඃ ශ්‍රුතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","කින්තු ප්‍රභුරකථයත්, යාහි භින්නදේශීයලෝකානාං භූපතීනාම් ඉස්‍රායේල්ලෝකානාඤ්ච නිකටේ මම නාම ප්‍රචාරයිතුං ස ජනෝ මම මනෝනීතපාත්‍රමාස්තේ| ");
INSERT INTO sansin_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","මම නාමනිමිත්තඤ්ච තේන කියාන් මහාන් ක්ලේශෝ භෝක්තව්‍ය ඒතත් තං දර්ශයිෂ්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","තතෝ (අ)නනියෝ ගත්වා ගෘහං ප්‍රවිශ්‍ය තස්‍ය ගාත්‍රේ හස්තාර්ප්‍රණං කෘත්වා කථිතවාන්, හේ භ්‍රාතඃ ශෞල ත්වං යථා දෘෂ්ටිං ප්‍රාප්නෝෂි පවිත්‍රේණාත්මනා පරිපූර්ණෝ භවසි ච, තදර්ථං තවාගමනකාලේ යඃ ප්‍රභුයීශුස්තුභ්‍යං දර්ශනම් අදදාත් ස මාං ප්‍රේෂිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ඉත්‍යුක්තමාත්‍රේ තස්‍ය චක්‍ෂුර්භ්‍යාම් මීනශල්කවද් වස්තුනි නිර්ගතේ තත්ක්‍ෂණාත් ස ප්‍රසන්නචක්‍ෂු ර්භූත්වා ප්‍රෝත්ථාය මජ්ජිතෝ(අ)භවත් භුක්ත්වා පීත්වා සබලෝභවච්ච| ");
INSERT INTO sansin_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","තතඃ පරං ශෞලඃ ශිෂ්‍යෛඃ සහ කතිපයදිවසාන් තස්මින් දම්මේෂකනගරේ ස්ථිත්වා(අ)විලම්බං ");
INSERT INTO sansin_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","සර්ව්වභජනභවනානි ගත්වා යීශුරීශ්වරස්‍ය පුත්‍ර ඉමාං කථාං ප්‍රාචාරයත්| ");
INSERT INTO sansin_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","තස්මාත් සර්ව්වේ ශ්‍රෝතාරශ්චමත්කෘත්‍ය කථිතවන්තෝ යෝ යිරූශාලම්නගර ඒතන්නාම්නා ප්‍රාර්ථයිතෘලෝකාන් විනාශිතවාන් ඒවම් ඒතාදෘශලෝකාන් බද්ධ්වා ප්‍රධානයාජකනිකටං නයතීත්‍යාශයා ඒතත්ස්ථානමප්‍යාගච්ඡත් සඒව කිමයං න භවති? ");
INSERT INTO sansin_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","කින්තු ශෞලඃ ක්‍රමශ උත්සාහවාන් භූත්වා යීශුරීශ්වරේණාභිෂික්තෝ ජන ඒතස්මින් ප්‍රමාණං දත්වා දම්මේෂක්-නිවාසියිහූදීයලෝකාන් නිරුත්තරාන් අකරෝත්| ");
INSERT INTO sansin_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ඉත්ථං බහුතිථේ කාලේ ගතේ යිහූදීයලෝකාස්තං හන්තුං මන්ත්‍රයාමාසුඃ ");
INSERT INTO sansin_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","කින්තු ශෞලස්තේෂාමේතස්‍යා මන්ත්‍රණායා වාර්ත්තාං ප්‍රාප්තවාන්| තේ තං හන්තුං තු දිවානිශං ගුප්තාඃ සන්තෝ නගරස්‍ය ද්වාරේ(අ)තිෂ්ඨන්; ");
INSERT INTO sansin_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","තස්මාත් ශිෂ්‍යාස්තං නීත්වා රාත්‍රෞ පිටකේ නිධාය ප්‍රාචීරේණාවාරෝහයන්| ");
INSERT INTO sansin_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","තතඃ පරං ශෞලෝ යිරූශාලමං ගත්වා ශිෂ්‍යගණේන සාර්ද්ධං ස්ථාතුම් ඓහත්, කින්තු සර්ව්වේ තස්මාදබිභයුඃ ස ශිෂ්‍ය ඉති ච න ප්‍රත්‍යයන්| ");
INSERT INTO sansin_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","ඒතස්මාද් බර්ණබ්බාස්තං ගෘහීත්වා ප්‍රේරිතානාං සමීපමානීය මාර්ගමධ්‍යේ ප්‍රභුඃ කථං තස්මෛ දර්ශනං දත්තවාන් යාඃ කථාශ්ච කථිතවාන් ස ච යථාක්‍ෂෝභඃ සන් දම්මේෂක්නගරේ යීශෝ ර්නාම ප්‍රාචාරයත් ඒතාන් සර්ව්වවෘත්තාන්තාන් තාන් ඥාපිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","තතඃ ශෞලස්තෛඃ සහ යිරූශාලමි කාලං යාපයන් නිර්භයං ප්‍රභෝ ර‍්‍යීශෝ ර්නාම ප්‍රාචාරයත්| ");
INSERT INTO sansin_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","තස්මාද් අන්‍යදේශීයලෝකෛඃ සාර්ද්ධං විවාදස්‍යෝපස්ථිතත්වාත් තේ තං හන්තුම් අචේෂ්ටන්ත| ");
INSERT INTO sansin_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","කින්තු භ්‍රාතෘගණස්තජ්ඥාත්වා තං කෛසරියානගරං නීත්වා තාර්ෂනගරං ප්‍රේෂිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ඉත්ථං සති යිහූදියාගාලීල්ශෝමිරෝණදේශීයාඃ සර්ව්වා මණ්ඩල්‍යෝ විශ්‍රාමං ප්‍රාප්තාස්තතස්තාසාං නිෂ්ඨාභවත් ප්‍රභෝ ර්භියා පවිත්‍රස්‍යාත්මනඃ සාන්ත්වනයා ච කාලං ක්‍ෂේපයිත්වා බහුසංඛ්‍යා අභවන්| ");
INSERT INTO sansin_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","තතඃ පරං පිතරඃ ස්ථානේ ස්ථානේ භ්‍රමිත්වා ශේෂේ ලෝද්නගරනිවාසිපවිත්‍රලෝකානාං සමීපේ ස්ථිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","තදා තත්‍ර පක්‍ෂාඝාතව්‍යාධිනාෂ්ටෞ වත්සරාන් ශය්‍යාගතම් ඓනේයනාමානං මනුෂ්‍යං සාක්‍ෂත් ප්‍රාප්‍ය තමවදත්, ");
INSERT INTO sansin_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","හේ ඓනේය යීශුඛ්‍රීෂ්ටස්ත්වාං ස්වස්ථම් අකාර්ෂීත්, ත්වමුත්ථාය ස්වශය්‍යාං නික්‍ෂිප, ඉත්‍යුක්තමාත්‍රේ ස උදතිෂ්ඨත්| ");
INSERT INTO sansin_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ඒතාදෘශං දෘෂ්ට්වා ලෝද්ශාරෝණනිවාසිනෝ ලෝකාඃ ප්‍රභුං ප්‍රති පරාවර්ත්තන්ත| ");
INSERT INTO sansin_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","අපරඤ්ච භික්‍ෂාදානාදිෂු නානක්‍රියාසු නිත්‍යං ප්‍රවෘත්තා යා යාඵෝනගරනිවාසිනී ටාබිථානාමා ශිෂ්‍යා යාං දර්ක්කාං අර්ථාද් හරිණීමයුක්ත්වා ආහ්වයන් සා නාරී ");
INSERT INTO sansin_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","තස්මින් සමයේ රුග්නා සතී ප්‍රාණාන් අත්‍යජත්, තතෝ ලෝකාස්තාං ප්‍රක්‍ෂාල්‍යෝපරිස්ථප්‍රකෝෂ්ඨේ ශායයිත්වාස්ථාපයන්| ");
INSERT INTO sansin_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","ලෝද්නගරං යාඵෝනගරස්‍ය සමීපස්ථං තස්මාත්තත්‍ර පිතර ආස්තේ, ඉති වාර්ත්තාං ශ්‍රුත්වා තූර්ණං තස්‍යාගමනාර්ථං තස්මින් විනයමුක්ත්වා ශිෂ්‍යගණෝ ද්වෞ මනුජෞ ප්‍රේෂිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","තස්මාත් පිතර උත්ථාය තාභ්‍යාං සාර්ද්ධම් ආගච්ඡත්, තත්‍ර තස්මින් උපස්ථිත උපරිස්ථප්‍රකෝෂ්ඨං සමානීතේ ච විධවාඃ ස්වාභිඃ සහ ස්ථිතිකාලේ දර්ක්කයා කෘතානි යාන්‍යුත්තරීයාණි පරිධේයානි ච තානි සර්ව්වාණි තං දර්ශයිත්වා රුදත්‍යශ්චතසෘෂු දික්‍ෂ්වතිෂ්ඨන්| ");
INSERT INTO sansin_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","කින්තු පිතරස්තාඃ සර්ව්වා බහිඃ කෘත්වා ජානුනී පාතයිත්වා ප්‍රාර්ථිතවාන්; පශ්චාත් ශවං ප්‍රති දෘෂ්ටිං කෘත්වා කථිතවාන්, හේ ටාබීථේ ත්වමුත්තිෂ්ඨ, ඉති වාක්‍ය උක්තේ සා ස්ත්‍රී චක්‍ෂුෂී ප්‍රෝන්මීල්‍ය පිතරම් අවලෝක්‍යෝත්ථායෝපාවිශත්| ");
INSERT INTO sansin_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","තතඃ පිතරස්තස්‍යාඃ කරෞ ධෘත්වා උත්තෝල්‍ය පවිත්‍රලෝකාන් විධවාශ්චාහූය තේෂාං නිකටේ සජීවාං තාං සමාර්පයත්| ");
INSERT INTO sansin_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ඒෂා කථා සමස්තයාඵෝනගරං ව්‍යාප්තා තස්මාද් අනේකේ ලෝකාඃ ප්‍රභෞ ව්‍යශ්වසන්| ");
INSERT INTO sansin_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","අපරඤ්ච පිතරස්තද්‍යාඵෝනගරීයස්‍ය කස්‍යචිත් ශිමෝන්නාම්නශ්චර්ම්මකාරස්‍ය ගෘහේ බහුදිනානි න්‍යවසත්| ");
INSERT INTO sansin_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","කෛසරියානගර ඉතාලියාඛ්‍යසෛන්‍යාන්තර්ගතඃ කර්ණීලියනාමා සේනාපතිරාසීත් ");
INSERT INTO sansin_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ස සපරිවාරෝ භක්ත ඊශ්වරපරායණශ්චාසීත්; ලෝකේභ්‍යෝ බහූනි දානාදීනි දත්වා නිරන්තරම් ඊශ්වරේ ප්‍රාර්ථයාඤ්චක්‍රේ| ");
INSERT INTO sansin_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ඒකදා තෘතීයප්‍රහරවේලායාං ස දෘෂ්ටවාන් ඊශ්වරස්‍යෛකෝ දූතඃ සප්‍රකාශං තත්සමීපම් ආගත්‍ය කථිතවාන්, හේ කර්ණීලිය| ");
INSERT INTO sansin_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","කින්තු ස තං දෘෂ්ට්වා භීතෝ(අ)කථයත්, හේ ප්‍රභෝ කිං? තදා තමවදත් තව ප්‍රාර්ථනා දානාදි ච සාක්‍ෂිස්වරූපං භූත්වේශ්වරස්‍ය ගෝචරමභවත්| ");
INSERT INTO sansin_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ඉදානීං යාඵෝනගරං ප්‍රති ලෝකාන් ප්‍රේෂ්‍ය සමුද්‍රතීරේ ශිමෝන්නාම්නශ්චර්ම්මකාරස්‍ය ගෘහේ ප්‍රවාසකාරී පිතරනාම්නා විඛ්‍යාතෝ යඃ ශිමෝන් තම් ආහ්වායය; ");
INSERT INTO sansin_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","තස්මාත් ත්වයා යද්‍යත් කර්ත්තව්‍යං තත්තත් ස වදිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ඉත්‍යුපදිශ්‍ය දූතේ ප්‍රස්ථිතේ සති කර්ණීලියඃ ස්වගෘහස්ථානාං දාසානාං ද්වෞ ජනෞ නිත්‍යං ස්වසඞ්ගිනාං සෛන්‍යානාම් ඒකාං භක්තසේනාඤ්චාහූය ");
INSERT INTO sansin_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","සකලමේතං වෘත්තාන්තං විඥාප්‍ය යාඵෝනගරං තාන් ප්‍රාහිණෝත්| ");
INSERT INTO sansin_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","පරස්මින් දිනේ තේ යාත්‍රාං කෘත්වා යදා නගරස්‍ය සමීප උපාතිෂ්ඨන්, තදා පිතරෝ ද්විතීයප්‍රහරවේලායාං ප්‍රාර්ථයිතුං ගෘහපෘෂ්ඨම් ආරෝහත්| ");
INSERT INTO sansin_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ඒතස්මින් සමයේ ක්‍ෂුධාර්ත්තඃ සන් කිඤ්චිද් භෝක්තුම් ඓච්ඡත් කින්තු තේෂාම් අන්නාසාදනසමයේ ස මූර්ච්ඡිතඃ සන්නපතත්| ");
INSERT INTO sansin_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","තතෝ මේඝද්වාරං මුක්තං චතුර්භිඃ කෝණෛ ර්ලම්බිතං බෘහද්වස්ත්‍රමිව කිඤ්චන භාජනම් ආකාශාත් පෘථිවීම් අවාරෝහතීති දෘෂ්ටවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","තන්මධ්‍යේ නානප්‍රකාරා ග්‍රාම්‍යවන්‍යපශවඃ ඛේචරෝරෝගාමිප්‍රභෘතයෝ ජන්තවශ්චාසන්| ");
INSERT INTO sansin_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","අනන්තරං හේ පිතර උත්ථාය හත්වා භුංක්‍ෂ්ව තම්ප්‍රතීයං ගගණීයා වාණී ජාතා| ");
INSERT INTO sansin_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","තදා පිතරඃ ප්‍රත්‍යවදත්, හේ ප්‍රභෝ ඊදෘශං මා භවතු, අහම් ඒතත් කාලං යාවත් නිෂිද්ධම් අශුචි වා ද්‍රව්‍යං කිඤ්චිදපි න භුක්තවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","තතඃ පුනරපි තාදෘශී විහයසීයා වාණී ජාතා යද් ඊශ්වරඃ ශුචි කෘතවාන් තත් ත්වං නිෂිද්ධං න ජානීහි| ");
INSERT INTO sansin_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ඉත්ථං ත්‍රිඃ සති තත් පාත්‍රං පුනරාකෘෂ්ටං ආකාශම් අගච්ඡත්| ");
INSERT INTO sansin_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","තතඃ පරං යද් දර්ශනං ප්‍රාප්තවාන් තස්‍ය කෝ භාව ඉත්‍යත්‍ර පිතරෝ මනසා සන්දේග්ධි, ඒතස්මින් සමයේ කර්ණීලියස්‍ය තේ ප්‍රේෂිතා මනුෂ්‍යා ද්වාරස්‍ය සන්නිධාවුපස්ථාය, ");
INSERT INTO sansin_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ශිමෝනෝ ගෘහමන්විච්ඡන්තඃ සම්පෘඡ්‍යාහූය කථිතවන්තඃ පිතරනාම්නා විඛ්‍යාතෝ යඃ ශිමෝන් ස කිමත්‍ර ප්‍රවසති? ");
INSERT INTO sansin_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","යදා පිතරස්තද්දර්ශනස්‍ය භාවං මනසාන්දෝලයති තදාත්මා තමවදත්, පශ්‍ය ත්‍රයෝ ජනාස්ත්වාං මෘගයන්තේ| ");
INSERT INTO sansin_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ත්වම් උත්ථායාවරුහ්‍ය නිඃසන්දේහං තෛඃ සහ ගච්ඡ මයෛව තේ ප්‍රේෂිතාඃ| ");
INSERT INTO sansin_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","තස්මාත් පිතරෝ(අ)වරුහ්‍ය කර්ණීලියප්‍රේරිතලෝකානාං නිකටමාගත්‍ය කථිතවාන් පශ්‍යත යූයං යං මෘගයධ්වේ ස ජනෝහං, යූයං කින්නිමිත්තම් ආගතාඃ? ");
INSERT INTO sansin_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","තතස්තේ ප්‍රත්‍යවදන් කර්ණීලියනාමා ශුද්ධසත්ත්ව ඊශ්වරපරායණෝ යිහූදීයදේශස්ථානාං සර්ව්වේෂාං සන්නිධෞ සුඛ්‍යාත්‍යාපන්න ඒකඃ සේනාපති ර්නිජගෘහං ත්වාමාහූය නේතුං ත්වත්තඃ කථා ශ්‍රෝතුඤ්ච පවිත්‍රදූතේන සමාදිෂ්ටඃ| ");
INSERT INTO sansin_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","තදා පිතරස්තානභ්‍යන්තරං නීත්වා තේෂාමාතිථ්‍යං කෘතවාන්, පරේ(අ)හනි තෛඃ සාර්ද්ධං යාත්‍රාමකරෝත්, යාඵෝනිවාසිනාං භ්‍රාතෘණාං කියන්තෝ ජනාශ්ච තේන සහ ගතාඃ| ");
INSERT INTO sansin_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","පරස්මින් දිවසේ කෛසරියානගරමධ්‍යප්‍රවේශසමයේ කර්ණීලියෝ ඥාතිබන්ධූන් ආහූයානීය තාන් අපේක්‍ෂ්‍ය ස්ථිතඃ| ");
INSERT INTO sansin_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","පිතරේ ගෘහ උපස්ථිතේ කර්ණීලියස්තං සාක්‍ෂාත්කෘත්‍ය චරණයෝඃ පතිත්වා ප්‍රාණමත්| ");
INSERT INTO sansin_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","පිතරස්තමුත්ථාප්‍ය කථිතවාන්, උත්තිෂ්ඨාහමපි මානුෂඃ| ");
INSERT INTO sansin_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","තදා කර්ණීලියේන සාකම් ආලපන් ගෘහං ප්‍රාවිශත් තන්මධ්‍යේ ච බහුලෝකානාං සමාගමං දෘෂ්ට්වා තාන් අවදත්, ");
INSERT INTO sansin_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","අන්‍යජාතීයලෝකෛඃ මහාලපනං වා තේෂාං ගෘහමධ්‍යේ ප්‍රවේශනං යිහූදීයානාං නිෂිද්ධම් අස්තීති යූයම් අවගච්ඡථ; කින්තු කමපි මානුෂම් අව්‍යවහාර‍්‍ය්‍යම් අශුචිං වා ඥාතුං මම නෝචිතම් ඉති පරමේශ්වරෝ මාං ඥාපිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ඉති හේතෝරාහ්වානශ්‍රවණමාත්‍රාත් කාඤ්චනාපත්තිම් අකෘත්වා යුෂ්මාකං සමීපම් ආගතෝස්මි; පෘච්ඡාමි යූයං කින්නිමිත්තං මාම් ආහූයත? ");
INSERT INTO sansin_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","තදා කර්ණීලියඃ කථිතවාන්, අද්‍ය චත්වාරි දිනානි ජාතානි ඒතාවද්වේලාං යාවද් අහම් අනාහාර ආසන් තතස්තෘතීයප්‍රහරේ සති ගෘහේ ප්‍රාර්ථනසමයේ තේජෝමයවස්ත්‍රභෘද් ඒකෝ ජනෝ මම සමක්‍ෂං තිෂ්ඨන් ඒතාං කථාම් අකථයත්, ");
INSERT INTO sansin_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","හේ කර්ණීලිය ත්වදීයා ප්‍රාර්ථනා ඊශ්වරස්‍ය කර්ණගෝචරීභූතා තව දානාදි ච සාක්‍ෂිස්වරූපං භූත්වා තස්‍ය දෘෂ්ටිගෝචරමභවත්| ");
INSERT INTO sansin_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","අතෝ යාඵෝනගරං ප්‍රති ලෝකාන් ප්‍රහිත්‍ය තත්‍ර සමුද්‍රතීරේ ශිමෝන්නාම්නඃ කස්‍යචිච්චර්ම්මකාරස්‍ය ගෘහේ ප්‍රවාසකාරී පිතරනාම්නා විඛ්‍යාතෝ යඃ ශිමෝන් තමාහූाයය; තතඃ ස ආගත්‍ය ත්වාම් උපදේක්‍ෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ඉති කාරණාත් තත්ක්‍ෂණාත් තව නිකටේ ලෝකාන් ප්‍රේෂිතවාන්, ත්වමාගතවාන් ඉති භද්‍රං කෘතවාන්| ඊශ්වරෝ යාන්‍යාඛ්‍යානානි කථයිතුම් ආදිශත් තානි ශ්‍රෝතුං වයං සර්ව්වේ සාම්ප්‍රතම් ඊශ්වරස්‍ය සාක්‍ෂාද් උපස්ථිතාඃ ස්මඃ| ");
INSERT INTO sansin_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","තදා පිතර ඉමාං කථාං කථයිතුම් ආරබ්ධවාන්, ඊශ්වරෝ මනුෂ්‍යාණාම් අපක්‍ෂපාතී සන් ");
INSERT INTO sansin_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","යස්‍ය කස්‍යචිද් දේශස්‍ය යෝ ලෝකාස්තස්මාද්භීත්වා සත්කර්ම්ම කරෝති ස තස්‍ය ග්‍රාහ්‍යෝ භවති, ඒතස්‍ය නිශ්චයම් උපලබ්ධවානහම්| ");
INSERT INTO sansin_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","සර්ව්වේෂාං ප්‍රභු ර‍්‍යෝ යීශුඛ්‍රීෂ්ටස්තේන ඊශ්වර ඉස්‍රායේල්වංශානාං නිකටේ සුසංවාදං ප්‍රේෂ්‍ය සම්මේලනස්‍ය යං සංවාදං ප්‍රාචාරයත් තං සංවාදං යූයං ශ්‍රුතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","යතෝ යෝහනා මජ්ජනේ ප්‍රචාරිතේ සති ස ගාලීලදේශමාරභ්‍ය සමස්තයිහූදීයදේශං ව්‍යාප්නෝත්; ");
INSERT INTO sansin_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ඵලත ඊශ්වරේණ පවිත්‍රේණාත්මනා ශක්ත්‍යා චාභිෂික්තෝ නාසරතීයයීශුඃ ස්ථානේ ස්ථානේ භ්‍රමන් සුක්‍රියාං කුර්ව්වන් ශෛතානා ක්ලිෂ්ටාන් සර්ව්වලෝකාන් ස්වස්ථාන් අකරෝත්, යත ඊශ්වරස්තස්‍ය සහාය ආසීත්; ");
INSERT INTO sansin_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","වයඤ්ච යිහූදීයදේශේ යිරූශාලම්නගරේ ච තේන කෘතානාං සර්ව්වේෂාං කර්ම්මණාං සාක්‍ෂිණෝ භවාමඃ| ලෝකාස්තං ක්‍රුශේ විද්ධ්වා හතවන්තඃ, ");
INSERT INTO sansin_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","කින්තු තෘතීයදිවසේ ඊශ්වරස්තමුත්ථාප්‍ය සප්‍රකාශම් අදර්ශයත්| ");
INSERT INTO sansin_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","සර්ව්වලෝකානාං නිකට ඉති න හි, කින්තු තස්මින් ශ්මශානාදුත්ථිතේ සති තේන සාර්ද්ධං භෝජනං පානඤ්ච කෘතවන්ත ඒතාදෘශා ඊශ්වරස්‍ය මනෝනීතාඃ සාක්‍ෂිණෝ යේ වයම් අස්මාකං නිකටේ තමදර්ශයත්| ");
INSERT INTO sansin_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ජීවිතමෘතෝභයලෝකානාං විචාරං කර්ත්තුම් ඊශ්වරෝ යං නියුක්තවාන් ස ඒව ස ජනඃ, ඉමාං කථාං ප්‍රචාරයිතුං තස්මින් ප්‍රමාණං දාතුඤ්ච සෝ(අ)ස්මාන් ආඥාපයත්| ");
INSERT INTO sansin_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","යස්තස්මින් විශ්වසිති ස තස්‍ය නාම්නා පාපාන්මුක්තෝ භවිෂ්‍යති තස්මින් සර්ව්වේ භවිෂ්‍යද්වාදිනෝපි ඒතාදෘශං සාක්‍ෂ්‍යං දදති| ");
INSERT INTO sansin_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","පිතරස්‍යෛතත්කථාකථනකාලේ සර්ව්වේෂාං ශ්‍රෝතෘණාමුපරි පවිත්‍ර ආත්මාවාරෝහත්| ");
INSERT INTO sansin_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","තතඃ පිතරේණ සාර්ද්ධම් ආගතාස්ත්වක්ඡේදිනෝ විශ්වාසිනෝ ලෝකා අන්‍යදේශීයේභ්‍යඃ පවිත්‍ර ආත්මනි දත්තේ සති ");
INSERT INTO sansin_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","තේ නානාජාතීයභාෂාභිඃ කථාං කථයන්ත ඊශ්වරං ප්‍රශංසන්ති, ඉති දෘෂ්ට්වා ශ්‍රුත්වා ච විස්මයම් ආපද්‍යන්ත| ");
INSERT INTO sansin_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","තදා පිතරඃ කථිතවාන්, වයමිව යේ පවිත්‍රම් ආත්මානං ප්‍රාප්තාස්තේෂාං ජලමජ්ජනං කිං කෝපි නිෂේද්ධුං ශක්නෝති? ");
INSERT INTO sansin_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","තතඃ ප්‍රභෝ ර්නාම්නා මජ්ජිතා භවතේති තානාඥාපයත්| අනන්තරං තේ ස්වෛඃ සාර්ද්ධං කතිපයදිනානි ස්ථාතුං ප්‍රාර්ථයන්ත| ");
INSERT INTO sansin_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ඉත්ථං භින්නදේශීයලෝකා අපීශ්වරස්‍ය වාක්‍යම් අගෘහ්ලන් ඉමාං වාර්ත්තාං යිහූදීයදේශස්ථප්‍රේරිතා භ්‍රාතෘගණශ්ච ශ්‍රුතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","තතඃ පිතරේ යිරූශාලම්නගරං ගතවති ත්වක්ඡේදිනෝ ලෝකාස්තේන සහ විවදමානා අවදන්, ");
INSERT INTO sansin_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ත්වම් අත්වක්ඡේදිලෝකානාං ගෘහං ගත්වා තෛඃ සාර්ද්ධං භුක්තවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","තතඃ පිතර ආදිතඃ ක්‍රමශස්තත්කාර‍්‍ය්‍යස්‍ය සර්ව්වවෘත්තාන්තමාඛ්‍යාතුම් ආරබ්ධවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","යාඵෝනගර ඒකදාහං ප්‍රාර්ථයමානෝ මූර්ච්ඡිතඃ සන් දර්ශනේන චතුර්ෂු කෝණේෂු ලම්බනමානං වෘහද්වස්ත්‍රමිව පාත්‍රමේකම් ආකාශදවරුහ්‍ය මන්නිකටම් ආගච්ඡද් අපශ්‍යම්| ");
INSERT INTO sansin_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","පශ්චාත් තද් අනන්‍යදෘෂ්ට්‍යා දෘෂ්ට්වා විවිච්‍ය තස්‍ය මධ්‍යේ නානාප්‍රකාරාන් ග්‍රාම්‍යවන්‍යපශූන් උරෝගාමිඛේචරාංශ්ච දෘෂ්ටවාන්; ");
INSERT INTO sansin_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","හේ පිතර ත්වමුත්ථාය ගත්වා භුංක්‍ෂ්ව මාං සම්බෝධ්‍ය කථයන්තං ශබ්දමේකං ශ්‍රුතවාංශ්ච| ");
INSERT INTO sansin_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","තතෝහං ප්‍රත්‍යවදං, හේ ප්‍රභෝ නේත්ථං භවතු, යතඃ කිඤ්චන නිෂිද්ධම් අශුචි ද්‍රව්‍යං වා මම මුඛමධ්‍යං කදාපි න ප්‍රාවිශත්| ");
INSERT INTO sansin_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","අපරම් ඊශ්වරෝ යත් ශුචි කෘතවාන් තන්නිෂිද්ධං න ජානීහි ද්වි ර්මාම්ප්‍රතීදෘශී විහායසීයා වාණී ජාතා| ");
INSERT INTO sansin_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","ත්‍රිරිත්ථං සති තත් සර්ව්වං පුනරාකාශම් ආකෘෂ්ටං| ");
INSERT INTO sansin_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","පශ්චාත් කෛසරියානගරාත් ත්‍රයෝ ජනා මන්නිකටං ප්‍රේෂිතා යත්‍ර නිවේශනේ ස්ථිතෝහං තස්මින් සමයේ තත්‍රෝපාතිෂ්ඨන්| ");
INSERT INTO sansin_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","තදා නිඃසන්දේහං තෛඃ සාර්ද්ධං යාතුම් ආත්මා මාමාදිෂ්ටවාන්; තතඃ පරං මයා සහෛතේෂු ෂඩ්භ්‍රාතෘෂු ගතේෂු වයං තස්‍ය මනුජස්‍ය ගෘහං ප්‍රාවිශාම| ");
INSERT INTO sansin_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","සෝස්මාකං නිකටේ කථාමේතාම් අකථයත් ඒකදා දූත ඒකඃ ප්‍රත්‍යක්‍ෂීභූය මම ගෘහමධ්‍යේ තිෂ්ටන් මාමිත්‍යාඥාපිතවාන්, යාඵෝනගරං ප්‍රති ලෝකාන් ප්‍රහිත්‍ය පිතරනාම්නා විඛ්‍යාතං ශිමෝනම් ආහූයය; ");
INSERT INTO sansin_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","තතස්තව ත්වදීයපරිවාරාණාඤ්ච යේන පරිත්‍රාණං භවිෂ්‍යති තත් ස උපදේක්‍ෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","අහං තාං කථාමුත්ථාප්‍ය කථිතවාන් තේන ප්‍රථමම් අස්මාකම් උපරි යථා පවිත්‍ර ආත්මාවරූඪවාන් තථා තේෂාමප්‍යුපරි සමවරූඪවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","තේන යෝහන් ජලේ මජ්ජිතවාන් ඉති සත්‍යං කින්තු යූයං පවිත්‍ර ආත්මනි මජ්ජිතා භවිෂ්‍යථ, ඉති යද්වාක්‍යං ප්‍රභුරුදිතවාන් තත් තදා මයා ස්මෘතම්| ");
INSERT INTO sansin_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","අතඃ ප්‍රභා යීශුඛ්‍රීෂ්ටේ ප්‍රත්‍යයකාරිණෝ යේ වයම් අස්මභ්‍යම් ඊශ්වරෝ යද් දත්තවාන් තත් තේභ්‍යෝ ලෝකේභ්‍යෝපි දත්තවාන් තතඃ කෝහං? කිමහම් ඊශ්වරං වාරයිතුං ශක්නෝමි? ");
INSERT INTO sansin_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","කථාමේතාං ශ්‍රුවා තේ ක්‍ෂාන්තා ඊශ්වරස්‍ය ගුණාන් අනුකීර්ත්ත්‍ය කථිතවන්තඃ, තර්හි පරමායුඃප්‍රාප්තිනිමිත්තම් ඊශ්වරෝන්‍යදේශීයලෝකේභ්‍යෝපි මනඃපරිවර්ත්තනරූපං දානම් අදාත්| ");
INSERT INTO sansin_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","ස්තිඵානං ප්‍රති උපද්‍රවේ ඝටිතේ යේ විකීර්ණා අභවන් තෛ ඵෛනීකීකුප්‍රාන්තියඛියාසු භ්‍රමිත්වා කේවලයිහූදීයලෝකාන් විනා කස්‍යාප්‍යන්‍යස්‍ය සමීප ඊශ්වරස්‍ය කථාං න ප්‍රාචාරයන්| ");
INSERT INTO sansin_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","අපරං තේෂාං කුප්‍රීයාඃ කුරීනීයාශ්ච කියන්තෝ ජනා ආන්තියඛියානගරං ගත්වා යූනානීයලෝකානාං සමීපේපි ප්‍රභෝර‍්‍යීශෝඃ කථාං ප්‍රාචාරයන්| ");
INSERT INTO sansin_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ප්‍රභෝඃ කරස්තේෂාං සහාය ආසීත් තස්මාද් අනේකේ ලෝකා විශ්වස්‍ය ප්‍රභුං ප්‍රති පරාවර්ත්තන්ත| ");
INSERT INTO sansin_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ඉති වාර්ත්තායාං යිරූශාලමස්ථමණ්ඩලීයලෝකානාං කර්ණගෝචරීභූතායාම් ආන්තියඛියානගරං ගන්තු තේ බර්ණබ්බාං ප්‍රෛරයන්| ");
INSERT INTO sansin_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","තතෝ බර්ණබ්බාස්තත්‍ර උපස්ථිතඃ සන් ඊශ්වරස්‍යානුග්‍රහස්‍ය ඵලං දෘෂ්ට්වා සානන්දෝ ජාතඃ, ");
INSERT INTO sansin_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ස ස්වයං සාධු ර්විශ්වාසේන පවිත්‍රේණාත්මනා ච පරිපූර්ණඃ සන් ගනෝනිෂ්ටයා ප්‍රභාවාස්ථාං කර්ත්තුං සර්ව්වාන් උපදිෂ්ටවාන් තේන ප්‍රභෝඃ ශිෂ්‍යා අනේකේ බභූවුඃ| ");
INSERT INTO sansin_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","ශේෂේ ශෞලං මෘගයිතුං බර්ණබ්බාස්තාර්ෂනගරං ප්‍රස්ථිතවාන්| තත්‍ර තස්‍යෝද්දේශං ප්‍රාප්‍ය තම් ආන්තියඛියානගරම් ආනයත්; ");
INSERT INTO sansin_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","තතස්තෞ මණ්ඩලීස්ථලෝකෛඃ සභාං කෘත්වා සංවත්සරමේකං යාවද් බහුලෝකාන් උපාදිශතාං; තස්මින් ආන්තියඛියානගරේ ශිෂ්‍යාඃ ප්‍රථමං ඛ්‍රීෂ්ටීයනාම්නා විඛ්‍යාතා අභවන්| ");
INSERT INTO sansin_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","තතඃ පරං භවිෂ්‍යද්වාදිගණේ යිරූශාලම ආන්තියඛියානගරම් ආගතේ සති ");
INSERT INTO sansin_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ආගාබනාමා තේෂාමේක උත්ථාය ආත්මනඃ ශික්‍ෂයා සර්ව්වදේශේ දුර්භික්‍ෂං භවිෂ්‍යතීති ඥාපිතවාන්; තතඃ ක්ලෞදියකෛසරස්‍යාධිකාරේ සති තත් ප්‍රත්‍යක්‍ෂම් අභවත්| ");
INSERT INTO sansin_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","තස්මාත් ශිෂ්‍යා ඒකෛකශඃ ස්වස්වශක්ත්‍යනුසාරතෝ යිහූදීයදේශනිවාසිනාං භ්‍රතෘණාං දිනයාපනාර්ථං ධනං ප්‍රේෂයිතුං නිශ්චිත්‍ය ");
INSERT INTO sansin_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","බර්ණබ්බාශෞලයෝ ර්ද්වාරා ප්‍රාචීනලෝකානාං සමීපං තත් ප්‍රේෂිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","තස්මින් සමයේ හේරෝද්‌රාජෝ මණ්ඩල්‍යාඃ කියජ්ජනේභ්‍යෝ දුඃඛං දාතුං ප්‍රාරභත්| ");
INSERT INTO sansin_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","විශේෂතෝ යෝහනඃ සෝදරං යාකූබං කරවාලාඝාතේන් හතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","තස්මාද් යිහූදීයාඃ සන්තුෂ්ටා අභවන් ඉති විඥාය ස පිතරමපි ධර්ත්තුං ගතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","තදා කිණ්වශූන්‍යපූපෝත්සවසමය උපාතිෂ්ටත්; අත උත්සවේ ගතේ සති ලෝකානාං සමක්‍ෂං තං බහිරානේය්‍යාමීති මනසි ස්ථිරීකෘත්‍ය ස තං ධාරයිත්වා රක්‍ෂ්ණාර්ථම් යේෂාම් ඒකෛකසංඝේ චත්වාරෝ ජනාඃ සන්ති තේෂාං චතුර්ණාං රක්‍ෂකසංඝානාං සමීපේ තං සමර්ප්‍ය කාරායාං ස්ථාපිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","කින්තුං පිතරස්‍ය කාරාස්ථිතිකාරණාත් මණ්ඩල්‍යා ලෝකා අවිශ්‍රාමම් ඊශ්වරස්‍ය සමීපේ ප්‍රාර්ථයන්ත| ");
INSERT INTO sansin_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","අනන්තරං හේරෝදි තං බහිරානායිතුං උද්‍යතේ සති තස්‍යාං රාත්‍රෞ පිතරෝ රක්‍ෂකද්වයමධ්‍යස්ථානේ ශෘඞ්ඛලද්වයේන බද්ධ්වඃ සන් නිද්‍රිත ආසීත්, දෞවාරිකාශ්ච කාරායාඃ සම්මුඛේ තිෂ්ඨනතෝ ද්වාරම් අරක්‍ෂිෂුඃ| ");
INSERT INTO sansin_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ඒතස්මින් සමයේ පරමේශ්වරස්‍ය දූතේ සමුපස්ථිතේ කාරා දීප්තිමතී ජාතා; තතඃ ස දූතඃ පිතරස්‍ය කුක්‍ෂාවාවාතං කෘත්වා තං ජාගරයිත්වා භාෂිතවාන් තූර්ණමුත්තිෂ්ඨ; තතස්තස්‍ය හස්තස්ථශෘඞ්ඛලද්වයං ගලත් පතිතං| ");
INSERT INTO sansin_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ස දූතස්තමවදත්, බද්ධකටිඃ සන් පාදයෝඃ පාදුකේ අර්පය; තේන තථා කෘතේ සති දූතස්තම් උක්තවාන් ගාත්‍රීයවස්ත්‍රං ගාත්‍රේ නිධාය මම පශ්චාද් ඒහි| ");
INSERT INTO sansin_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","තතඃ පිතරස්තස්‍ය පශ්චාද් ව්‍රජන බහිරගච්ඡත්, කින්තු දූතේන කර්ම්මෛතත් කෘතමිති සත්‍යමඥාත්වා ස්වප්නදර්ශනං ඥාතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ඉත්ථං තෞ ප්‍රථමාං ද්විතීයාඤ්ච කාරාං ලඞ්ඝිත්වා යේන ලෞහනිර්ම්මිතද්වාරේණ නගරං ගම්‍යතේ තත්සමීපං ප්‍රාප්නුතාං; තතස්තස්‍ය කවාටං ස්වයං මුක්තමභවත් තතස්තෞ තත්ස්ථානාද් බහි ර්භූත්වා මාර්ගෛකස්‍ය සීමාං යාවද් ගතෞ; තතෝ(අ)කස්මාත් ස දූතඃ පිතරං ත්‍යක්තවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","තදා ස චේතනාං ප්‍රාප්‍ය කථිතවාන් නිජදූතං ප්‍රහිත්‍ය පරමේශ්වරෝ හේරෝදෝ හස්තාද් යිහූදීයලෝකානාං සර්ව්වාශායාශ්ච මාං සමුද්ධෘතවාන් ඉත්‍යහං නිශ්චයං ඥාතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ස විවිච්‍ය මාර්කනාම්‍රා විඛ්‍යාතස්‍ය යෝහනෝ මාතු ර්මරියමෝ යස්මින් ගෘහේ බහවඃ සම්භූය ප්‍රාර්ථයන්ත තන්නිවේශනං ගතඃ| ");
INSERT INTO sansin_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","පිතරේණ බහිර්ද්වාර ආහතේ සති රෝදානාමා බාලිකා ද්‍රෂ්ටුං ගතා| ");
INSERT INTO sansin_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","තතඃ පිතරස්‍ය ස්වරං ශ්‍රුවා සා හර්ෂයුක්තා සතී ද්වාරං න මෝචයිත්වා පිතරෝ ද්වාරේ තිෂ්ඨතීති වාර්ත්තාං වක්තුම් අභ්‍යන්තරං ධාවිත්වා ගතවතී| ");
INSERT INTO sansin_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","තේ ප්‍රාවෝචන් ත්වමුන්මත්තා ජාතාසි කින්තු සා මුහුර්මුහුරුක්තවතී සත්‍යමේවෛතත්| ");
INSERT INTO sansin_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","තදා තේ කථිතවන්තස්තර්හි තස්‍ය දූතෝ භවේත්| ");
INSERT INTO sansin_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","පිතරෝ ද්වාරමාහතවාන් ඒතස්මින්නන්තරේ ද්වාරං මෝචයිත්වා පිතරං දෘෂ්ට්වා විස්මයං ප්‍රාප්තාඃ| ");
INSERT INTO sansin_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","තතඃ පිතරෝ නිඃශබ්දං ස්ථාතුං තාන් ප්‍රති හස්තේන සඞ්කේතං කෘත්වා පරමේශ්වරෝ යේන ප්‍රකාරේණ තං කාරායා උද්ධෘත්‍යානීතවාන් තස්‍ය වෘත්තාන්තං තානඥාපයත්, යූයං ගත්වා යාකුබං භ්‍රාතෘගණඤ්ච වාර්ත්තාමේතාං වදතේත්‍යුක්තා ස්ථානාන්තරං ප්‍රස්ථිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ප්‍රභාතේ සති පිතරඃ ක්ව ගත ඉත්‍යත්‍ර රක්‍ෂකාණාං මධ්‍යේ මහාන් කලහෝ ජාතඃ| ");
INSERT INTO sansin_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","හේරෝද් බහු මෘගයිත්වා තස්‍යෝද්දේශේ න ප්‍රාප්තේ සති රක්‍ෂකාන් සංපෘච්ඡ්‍ය තේෂාං ප්‍රාණාන් හන්තුම් ආදිෂ්ටවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","පශ්චාත් ස යිහූදීයප්‍රදේශාත් කෛසරියානගරං ගත්වා තත්‍රාවාතිෂ්ඨත්| ");
INSERT INTO sansin_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","සෝරසීදෝනදේශයෝ ර්ලෝකේභ්‍යෝ හේරෝදි යුයුත්සෞ සති තේ සර්ව්ව ඒකමන්ත්‍රණාඃ සන්තස්තස්‍ය සමීප උපස්ථාය ල්වාස්තනාමානං තස්‍ය වස්ත්‍රගෘහාධීශං සහායං කෘත්වා හේරෝදා සාර්ද්ධං සන්ධිං ප්‍රාර්ථයන්ත යතස්තස්‍ය රාඥෝ දේශේන තේෂාං දේශීයානාං භරණම් අභවත්ං ");
INSERT INTO sansin_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","අතඃ කුත්‍රචින් නිරුපිතදිනේ හේරෝද් රාජකීයං පරිච්ඡදං පරිධාය සිංහාසනේ සමුපවිශ්‍ය තාන් ප්‍රති කථාම් උක්තවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","තතෝ ලෝකා උච්චෛඃකාරං ප්‍රත්‍යවදන්, ඒෂ මනුජරවෝ න හි, ඊශ්වරීයරවඃ| ");
INSERT INTO sansin_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","තදා හේරෝද් ඊශ්වරස්‍ය සම්මානං නාකරෝත්; තස්මාද්ධේතෝඃ පරමේශ්වරස්‍ය දූතෝ හඨාත් තං ප්‍රාහරත් තේනෛව ස කීටෛඃ ක්‍ෂීණඃ සන් ප්‍රාණාන් අජහාත්| කින්ත්වීශ්වරස්‍ය කථා දේශං ව්‍යාප්‍ය ප්‍රබලාභවත්| තතඃ පරං බර්ණබ්බාශෞලෞ යස්‍ය කර්ම්මණෝ භාරං ප්‍රාප්නුතාං තාභ්‍යාං තස්මින් සම්පාදිතේ සති මාර්කනාම්නා විඛ්‍යාතෝ යෝ යෝහන් තං සඞ්ගිනං කෘත්වා යිරූශාලම්නගරාත් ප්‍රත්‍යාගතෞ| ");
INSERT INTO sansin_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","අපරඤ්ච බර්ණබ්බාඃ, ශිමෝන් යං නිග්‍රං වදන්ති, කුරීනීයලූකියෝ හේරෝදා රාඥා සහ කෘතවිද්‍යාाභ්‍යාසෝ මිනහේම්, ශෞලශ්චෛතේ යේ කියන්තෝ ජනා භවිෂ්‍යද්වාදින උපදේෂ්ටාරශ්චාන්තියඛියානගරස්ථමණ්ඩල්‍යාම් ආසන්, ");
INSERT INTO sansin_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","තේ යදෝපවාසං කෘත්වේශ්වරම් අසේවන්ත තස්මින් සමයේ පවිත්‍ර ආත්මා කථිතවාන් අහං යස්මින් කර්ම්මණි බර්ණබ්බාශෛලෞ නියුක්තවාන් තත්කර්ම්ම කර්ත්තුං තෞ පෘථක් කුරුත| ");
INSERT INTO sansin_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","තතස්තෛරුපවාසප්‍රාර්ථනයෝඃ කෘතයෝඃ සතෝස්තේ තයෝ ර්ගාත්‍රයෝ ර්හස්තාර්පණං කෘත්වා තෞ ව්‍යසෘජන්| ");
INSERT INTO sansin_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","තතඃ පරං තෞ පවිත්‍රේණාත්මනා ප්‍රේරිතෞ සන්තෞ සිලූකියානගරම් උපස්ථාය සමුද්‍රපථේන කුප්‍රෝපද්වීපම් අගච්ඡතාං| ");
INSERT INTO sansin_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","තතඃ සාලාමීනගරම් උපස්ථාය තත්‍ර යිහූදීයානාං භජනභවනානි ගත්වේශ්වරස්‍ය කථාං ප්‍රාචාරයතාං; යෝහනපි තත්සහචරෝ(අ)භවත්| ");
INSERT INTO sansin_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ඉත්ථං තේ තස්‍යෝපද්වීපස්‍ය සර්ව්වත්‍ර භ්‍රමන්තඃ පාඵනගරම් උපස්ථිතාඃ; තත්‍ර සුවිවේචකේන සර්ජියපෞලනාම්නා තද්දේශාධිපතිනා සහ භවිෂ්‍යද්වාදිනෝ වේශධාරී බර‍්‍යීශුනාමා යෝ මායාවී යිහූදී ආසීත් තං සාක්‍ෂාත් ප්‍රාප්තවතඃ| ");
INSERT INTO sansin_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","තද්දේශාධිප ඊශ්වරස්‍ය කථාං ශ්‍රෝතුං වාඤ්ඡන් පෞලබර්ණබ්බෞ න්‍යමන්ත්‍රයත්| ");
INSERT INTO sansin_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","කින්ත්විලුමා යං මායාවිනං වදන්ති ස දේශාධිපතිං ධර්ම්මමාර්ගාද් බහිර්භූතං කර්ත්තුම් අයතත| ");
INSERT INTO sansin_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","තස්මාත් ශෝලෝ(අ)ර්ථාත් පෞලඃ පවිත්‍රේණාත්මනා පරිපූර්ණඃ සන් තං මායාවිනං ප්‍රත්‍යනන්‍යදෘෂ්ටිං කෘත්වාකථයත්, ");
INSERT INTO sansin_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","හේ නරකින් ධර්ම්මද්වේෂින් කෞටිල්‍යදුෂ්කර්ම්මපරිපූර්ණ, ත්වං කිං ප්‍රභෝඃ සත්‍යපථස්‍ය විපර‍්‍ය්‍යයකරණාත් කදාපි න නිවර්ත්තිෂ්‍යසේ? ");
INSERT INTO sansin_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","අධුනා පරමේශ්වරස්තව සමුචිතං කරිෂ්‍යති තේන කතිපයදිනානි ත්වම් අන්ධඃ සන් සූර‍්‍ය්‍යමපි න ද්‍රක්‍ෂ්‍යසි| තත්ක්‍ෂණාද් රාත්‍රිවද් අන්ධකාරස්තස්‍ය දෘෂ්ටිම් ආච්ඡාදිතවාන්; තස්මාත් තස්‍ය හස්තං ධර්ත්තුං ස ලෝකමන්විච්ඡන් ඉතස්තතෝ භ්‍රමණං කෘතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ඒනාං ඝටනාං දෘෂ්ට්වා ස දේශාධිපතිඃ ප්‍රභූපදේශාද් විස්මිත්‍ය විශ්වාසං කෘතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","තදනන්තරං පෞලස්තත්සඞ්ගිනෞ ච පාඵනගරාත් ප්‍රෝතං චාලයිත්වා පම්ඵුලියාදේශස්‍ය පර්ගීනගරම් අගච්ඡන් කින්තු යෝහන් තයෝඃ සමීපාද් ඒත්‍ය යිරූශාලමං ප්‍රත්‍යාගච්ඡත්| ");
INSERT INTO sansin_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","පශ්චාත් තෞ පර්ගීතෝ යාත්‍රාං කෘත්වා පිසිදියාදේශස්‍ය ආන්තියඛියානගරම් උපස්ථාය විශ්‍රාමවාරේ භජනභවනං ප්‍රවිශ්‍ය සමුපාවිශතාං| ");
INSERT INTO sansin_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ව්‍යවස්ථාභවිෂ්‍යද්වාක්‍යයෝඃ පඨිතයෝඃ සතෝ ර්හේ භ්‍රාතරෞ ලෝකාන් ප්‍රති යුවයෝඃ කාචිද් උපදේශකථා යද්‍යස්ති තර්හි තාං වදතං තෞ ප්‍රති තස්‍ය භජනභවනස්‍යාධිපතයඃ කථාම් ඒතාං කථයිත්වා ප්‍රෛෂයන්| ");
INSERT INTO sansin_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","අතඃ පෞල උත්තිෂ්ඨන් හස්තේන සඞ්කේතං කුර්ව්වන් කථිතවාන් හේ ඉස්‍රායේලීයමනුෂ්‍යා ඊශ්වරපරායණාඃ සර්ව්වේ ලෝකා යූයම් අවධද්ධං| ");
INSERT INTO sansin_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ඒතේෂාමිස්‍රායේල්ලෝකානාම් ඊශ්වරෝ(අ)ස්මාකං පූර්ව්වපරුෂාන් මනෝනීතාන් කත්වා ගෘහීතවාන් තතෝ මිසරි දේශේ ප්‍රවසනකාලේ තේෂාමුන්නතිං කෘත්වා තස්මාත් ස්වීයබාහුබලේන තාන් බහිඃ කෘත්වා සමානයත්| ");
INSERT INTO sansin_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","චත්වාරිංශද්වත්සරාන් යාවච්ච මහාප්‍රාන්තරේ තේෂාං භරණං කෘත්වා ");
INSERT INTO sansin_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","කිනාන්දේශාන්තර්ව්වර්ත්තීණි සප්තරාජ්‍යානි නාශයිත්වා ගුටිකාපාතේන තේෂු සර්ව්වදේශේෂු තේභ්‍යෝ(අ)ධිකාරං දත්තවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","පඤ්චාශදධිකචතුඃශතේෂු වත්සරේෂු ගතේෂු ච ශිමූයේල්භවිෂ්‍යද්වාදිපර‍්‍ය්‍යන්තං තේෂාමුපරි විචාරයිතෘන් නියුක්තවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","තෛශ්ච රාඥි ප්‍රාර්ථිතේ, ඊශ්වරෝ බින්‍යාමීනෝ වංශජාතස්‍ය කීශඃ පුත්‍රං ශෞලං චත්වාරිංශද්වර්ෂපර‍්‍ය්‍යන්තං තේෂාමුපරි රාජානං කෘතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","පශ්චාත් තං පදච්‍යුතං කෘත්වා යෝ මදිෂ්ටක්‍රියාඃ සර්ව්වාඃ කරිෂ්‍යති තාදෘශං මම මනෝභිමතම් ඒකං ජනං යිශයඃ පුත්‍රං දායූදං ප්‍රාප්තවාන් ඉදං ප්‍රමාණං යස්මින් දායූදි ස දත්තවාන් තං දායූදං තේෂාමුපරි රාජත්වං කර්ත්තුම් උත්පාදිතවාන| ");
INSERT INTO sansin_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","තස්‍ය ස්වප්‍රතිශ්‍රුතස්‍ය වාක්‍යස්‍යානුසාරේණ ඉස්‍රායේල්ලෝකානාං නිමිත්තං තේෂාං මනුෂ්‍යාණාං වංශාද් ඊශ්වර ඒකං යීශුං (ත්‍රාතාරම්) උදපාදයත්| ");
INSERT INTO sansin_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","තස්‍ය ප්‍රකාශනාත් පූර්ව්වං යෝහන් ඉස්‍රායේල්ලෝකානාං සන්නිධෞ මනඃපරාවර්ත්තනරූපං මජ්ජනං ප්‍රාචාරයත්| ");
INSERT INTO sansin_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","යස්‍ය ච කර්ම්මණෝे භාරං ප්‍රප්තවාන් යෝහන් තන් නිෂ්පාදයන් ඒතාං කථාං කථිතවාන්, යූයං මාං කං ජනං ජානීථ? අහම් අභිෂික්තත්‍රාතා නහි, කින්තු පශ්‍යත යස්‍ය පාදයෝඃ පාදුකයෝ ර්බන්ධනේ මෝචයිතුමපි යෝග්‍යෝ න භවාමි තාදෘශ ඒකෝ ජනෝ මම පශ්චාද් උපතිෂ්ඨති| ");
INSERT INTO sansin_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","හේ ඉබ්‍රාහීමෝ වංශජාතා භ්‍රාතරෝ හේ ඊශ්වරභීතාඃ සර්ව්වලෝකා යුෂ්මාන් ප්‍රති පරිත්‍රාණස්‍ය කථෛෂා ප්‍රේරිතා| ");
INSERT INTO sansin_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","යිරූශාලම්නිවාසිනස්තේෂාම් අධිපතයශ්ච තස්‍ය යීශෝඃ පරිචයං න ප්‍රාප්‍ය ප්‍රතිවිශ්‍රාමවාරං පඨ්‍යමානානාං භවිෂ්‍යද්වාදිකථානාම් අභිප්‍රායම් අබුද්ධ්වා ච තස්‍ය වධේන තාඃ කථාඃ සඵලා අකුර්ව්වන්| ");
INSERT INTO sansin_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","ප්‍රාණහනනස්‍ය කමපි හේතුම් අප්‍රාප්‍යාපි පීලාතස්‍ය නිකටේ තස්‍ය වධං ප්‍රාර්ථයන්ත| ");
INSERT INTO sansin_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","තස්මින් යාඃ කථා ලිඛිතාඃ සන්ති තදනුසාරේණ කර්ම්ම සම්පාද්‍ය තං ක්‍රුශාද් අවතාර‍්‍ය්‍ය ශ්මශානේ ශායිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","කින්ත්වීශ්වරඃ ශ්මශානාත් තමුදස්ථාපයත්, ");
INSERT INTO sansin_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","පුනශ්ච ගාලීලප්‍රදේශාද් යිරූශාලමනගරං තේන සාර්ද්ධං යේ ලෝකා ආගච්ඡන් ස බහුදිනානි තේභ්‍යෝ දර්ශනං දත්තවාන්, අතස්ත ඉදානීං ලෝකාන් ප්‍රති තස්‍ය සාක්‍ෂිණඃ සන්ති| ");
INSERT INTO sansin_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","අස්මාකං පූර්ව්වපුරුෂාණාං සමක්‍ෂම් ඊශ්වරෝ යස්මින් ප්‍රතිඥාතවාන් යථා, ත්වං මේ පුත්‍රෝසි චාද්‍ය ත්වාං සමුත්ථාපිතවානහම්| ");
INSERT INTO sansin_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ඉදං යද්වචනං ද්විතීයගීතේ ලිඛිතමාස්තේ තද් යීශෝරුත්ථානේන තේෂාං සන්තානා යේ වයම් අස්මාකං සන්නිධෞ තේන ප්‍රත්‍යක්‍ෂී කෘතං, යුෂ්මාන් ඉමං සුසංවාදං ඥාපයාමි| ");
INSERT INTO sansin_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","පරමේශ්වරේණ ශ්මශානාද් උත්ථාපිතං තදීයං ශරීරං කදාපි න ක්‍ෂේෂ්‍යතේ, ඒතස්මින් ස ස්වයං කථිතවාන් යථා දායූදං ප්‍රති ප්‍රතිඥාතෝ යෝ වරස්තමහං තුභ්‍යං දාස්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","ඒතදන්‍යස්මින් ගීතේ(අ)පි කථිතවාන්| ස්වකීයං පුණ්‍යවන්තං ත්වං ක්‍ෂයිතුං න ච දාස්‍යසි| ");
INSERT INTO sansin_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","දායූදා ඊශ්වරාභිමතසේවායෛ නිජායුෂි ව්‍යයිතේ සති ස මහානිද්‍රාං ප්‍රාප්‍ය නිජෛඃ පූර්ව්වපුරුෂෛඃ සහ මිලිතඃ සන් අක්‍ෂීයත; ");
INSERT INTO sansin_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","කින්තු යමීශ්වරඃ ශ්මශානාද් උදස්ථාපයත් ස නාක්‍ෂීයත| ");
INSERT INTO sansin_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","අතෝ හේ භ්‍රාතරඃ, අනේන ජනේන පාපමෝචනං භවතීති යුෂ්මාන් ප්‍රති ප්‍රචාරිතම් ආස්තේ| ");
INSERT INTO sansin_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ඵලතෝ මූසාව්‍යවස්ථයා යූයං යේභ්‍යෝ දෝෂේභ්‍යෝ මුක්තා භවිතුං න ශක්‍ෂ්‍යථ තේභ්‍යඃ සර්ව්වදෝෂේභ්‍ය ඒතස්මින් ජනේ විශ්වාසිනඃ සර්ව්වේ මුක්තා භවිෂ්‍යන්තීති යුෂ්මාභි ර්ඥායතාං| ");
INSERT INTO sansin_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","අපරඤ්ච| අවඥාකාරිණෝ ලෝකාශ්චක්‍ෂුරුන්මීල්‍ය පශ්‍යත| තථෛවාසම්භවං ඥාත්වා ස්‍යාත යූයං විලජ්ජිතාඃ| යතෝ යුෂ්මාසු තිෂ්ඨත්සු කරිෂ්‍යේ කර්ම්ම තාදෘශං| යේනෛව තස්‍ය වෘත්තාන්තේ යුෂ්මභ්‍යං කථිතේ(අ)පි හි| යූයං න තන්තු වෘත්තාන්තං ප්‍රත්‍යේෂ්‍යථ කදාචන|| ");
INSERT INTO sansin_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","යේයං කථා භවිෂ්‍යද්වාදිනාං ග්‍රන්ථේෂු ලිඛිතාස්තේ සාවධානා භවත ස කථා යථා යුෂ්මාන් ප්‍රති න ඝටතේ| ");
INSERT INTO sansin_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","යිහූදීයභජනභවනාන් නිර්ගතයෝස්තයෝ ර්භින්නදේශීයෛ ර්වක්‍ෂ්‍යමාණා ප්‍රාර්ථනා කෘතා, ආගාමිනි විශ්‍රාමවාරේ(අ)පි කථේයම් අස්මාන් ප්‍රති ප්‍රචාරිතා භවත්විති| ");
INSERT INTO sansin_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","සභායා භඞ්ගේ සති බහවෝ යිහූදීයලෝකා යිහූදීයමතග්‍රාහිණෝ භක්තලෝකාශ්ච බර්ණබ්බාපෞලයෝඃ පශ්චාද් ආගච්ඡන්, තේන තෞ තෛඃ සහ නානාකථාඃ කථයිත්වේශ්වරානුග්‍රහාශ්‍රයේ ස්ථාතුං තාන් ප්‍රාවර්ත්තයතාං| ");
INSERT INTO sansin_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","පරවිශ්‍රාමවාරේ නගරස්‍ය ප්‍රායේණ සර්ව්වේ ලාකා ඊශ්වරීයාං කථාං ශ්‍රෝතුං මිලිතාඃ, ");
INSERT INTO sansin_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","කින්තු යිහූදීයලෝකා ජනනිවහං විලෝක්‍ය ඊර්ෂ්‍යයා පරිපූර්ණාඃ සන්තෝ විපරීතකථාකථනේනේශ්වරනින්දයා ච පෞලේනෝක්තාං කථාං ඛණ්ඩයිතුං චේෂ්ටිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","තතඃ පෞैලබර්ණබ්බාවක්‍ෂෝභෞ කථිතවන්තෞ ප්‍රථමං යුෂ්මාකං සන්නිධාවීශ්වරීයකථායාඃ ප්‍රචාරණම් උචිතමාසීත් කින්තුං තදග්‍රාහ්‍යත්වකරණේන යූයං ස්වාන් අනන්තායුෂෝ(අ)යෝග්‍යාන් දර්ශයථ, ඒතත්කාරණාද් වයම් අන්‍යදේශීයලෝකානාං සමීපං ගච්ඡාමඃ| ");
INSERT INTO sansin_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ප්‍රභුරස්මාන් ඉත්ථම් ආදිෂ්ටවාන් යථා, යාවච්ච ජගතඃ සීමාං ලෝකානාං ත්‍රාණකාරණාත්| මයාන්‍යදේශමධ්‍යේ ත්වං ස්ථාපිතෝ භූඃ ප්‍රදීපවත්|| ");
INSERT INTO sansin_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","තදා කථාමීදෘශීං ශ්‍රුත්වා භින්නදේශීයා ආහ්ලාදිතාඃ සන්තඃ ප්‍රභෝඃ කථාං ධන්‍යාං ධන්‍යාම් අවදන්, යාවන්තෝ ලෝකාශ්ච පරමායුඃ ප්‍රාප්තිනිමිත්තං නිරූපිතා ආසන් තේे ව්‍යශ්වසන්| ");
INSERT INTO sansin_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ඉත්ථං ප්‍රභෝඃ කථා සර්ව්වේදේශං ව්‍යාප්නෝත්| ");
INSERT INTO sansin_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","කින්තු යිහූදීයා නගරස්‍ය ප්‍රධානපුරුෂාන් සම්මාන්‍යාඃ කථිපයා භක්තා යෝෂිතශ්ච කුප්‍රවෘත්තිං ග්‍රාහයිත්වා පෞලබර්ණබ්බෞ තාඩයිත්වා තස්මාත් ප්‍රදේශාද් දූරීකෘතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","අතඃ කාරණාත් තෞ නිජපදධූලීස්තේෂාං ප්‍රාතිකූල්‍යේන පාතයිත්වේेකනියං නගරං ගතෞ| ");
INSERT INTO sansin_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","තතඃ ශිෂ්‍යගණ ආනන්දේන පවිත්‍රේණාත්මනා ච පරිපූර්ණෝභවත්| ");
INSERT INTO sansin_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","තෞ ද්වෞ ජනෞ යුගපද් ඉකනියනගරස්ථයිහූදීයානාං භජනභවනං ගත්වා යථා බහවෝ යිහූදීයා අන්‍යදේेශීයලෝකාශ්ච ව්‍යශ්වසන් තාදෘශීං කථාං කථිතවන්තෞ| ");
INSERT INTO sansin_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","කින්තු විශ්වාසහීනා යිහූදීයා අන්‍යදේශීයලෝකාන් කුප්‍රවෘත්තිං ග්‍රාහයිත්වා භ්‍රාතෘගණං ප්‍රති තේෂාං වෛරං ජනිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","අතඃ ස්වානුග්‍රහකථායාඃ ප්‍රමාණං දත්වා තයෝ ර්හස්තෛ ර්බහුලක්‍ෂණම් අද්භුතකර්ම්ම ච ප්‍රාකාශයද් යඃ ප්‍රභුස්තස්‍ය කථා අක්‍ෂෝභේන ප්‍රචාර‍්‍ය්‍ය තෞ තත්‍ර බහුදිනානි සමවාතිෂ්ඨේතාං| ");
INSERT INTO sansin_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","කින්තු කියන්තෝ ලෝකා යිහූදීයානාං සපක්‍ෂාඃ කියන්තෝ ලෝකාඃ ප්‍රේරිතානාං සපක්‍ෂා ජාතාඃ, අතෝ නාගරිකජනනිවහමධ්‍යේ භින්නවාක්‍යත්වම් අභවත්| ");
INSERT INTO sansin_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","අන්‍යදේශීයා යිහූදීයාස්තේෂාම් අධිපතයශ්ච දෞරාත්ම්‍යං කුත්වා තෞ ප්‍රස්තරෛරාහන්තුම් උද්‍යතාඃ| ");
INSERT INTO sansin_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","තෞ තද්වාර්ත්තාං ප්‍රාප්‍ය පලායිත්වා ලුකායනියාදේශස්‍යාන්තර්ව්වර්ත්තිලුස්ත්‍රාදර්බ්බෝ ");
INSERT INTO sansin_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","තත්සමීපස්ථදේශඤ්ච ගත්වා තත්‍ර සුසංවාදං ප්‍රචාරයතාං| ");
INSERT INTO sansin_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","තත්‍රෝභයපාදයෝශ්චලනශක්තිහීනෝ ජන්මාරභ්‍ය ඛඤ්ජඃ කදාපි ගමනං නාකරෝත් ඒතාදෘශ ඒකෝ මානුෂෝ ලුස්ත්‍රානගර උපවිශ්‍ය පෞලස්‍ය කථාං ශ්‍රුතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ඒතස්මින් සමයේ පෞලස්තම්ප්‍රති දෘෂ්ටිං කෘත්වා තස්‍ය ස්වාස්ථ්‍යේ විශ්වාසං විදිත්වා ප්‍රෝච්චෛඃ කථිතවාන් ");
INSERT INTO sansin_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","පද්භ්‍යාමුත්තිෂ්ඨන් ඍජු ර්භව| තතඃ ස උල්ලම්ඵං කෘත්වා ගමනාගමනේ කුතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","තදා ලෝකාඃ පෞලස්‍ය තත් කාර‍්‍ය්‍යං විලෝක්‍ය ලුකායනීයභාෂයා ප්‍රෝච්චෛඃ කථාමේතාං කථිතවන්තඃ, දේවා මනුෂ්‍යරූපං ධෘත්වාස්මාකං සමීපම් අවාරෝහන්| ");
INSERT INTO sansin_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","තේ බර්ණබ්බාං යූපිතරම් අවදන් පෞලශ්ච මුඛ්‍යෝ වක්තා තස්මාත් තං මර්කුරියම් අවදන්| ");
INSERT INTO sansin_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","තස්‍ය නගරස්‍ය සම්මුඛේ ස්ථාපිතස්‍ය යූපිතරවිග්‍රහස්‍ය යාජකෝ වෘෂාන් පුෂ්පමාලාශ්ච ද්වාරසමීපම් ආනීය ලෝකෛඃ සර්ද්ධං තාවුද්දිශ්‍ය සමුත්සෘජ්‍ය දාතුම් උද්‍යතඃ| ");
INSERT INTO sansin_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","තද්වාර්ත්තාං ශ්‍රුත්වා බර්ණබ්බාපෞලෞ ස්වීයවස්ත්‍රාණි ඡිත්වා ලෝකානාං මධ්‍යං වේගේන ප්‍රවිශ්‍ය ප්‍රෝච්චෛඃ කථිතවන්තෞ, ");
INSERT INTO sansin_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","හේ මහේච්ඡාඃ කුත ඒතාදෘශං කර්ම්ම කුරුථ? ආවාමපි යුෂ්මාදෘශෞ සුඛදුඃඛභෝගිනෞ මනුෂ්‍යෞ, යුයම් ඒතාඃ සර්ව්වා වෘථාකල්පනාඃ පරිත්‍යජ්‍ය යථා ගගණවසුන්ධරාජලනිධීනාං තන්මධ්‍යස්ථානාං සර්ව්වේෂාඤ්ච ස්‍රෂ්ටාරමමරම් ඊශ්වරං ප්‍රති පරාවර්ත්තධ්වේ තදර්ථම් ආවාං යුෂ්මාකං සන්නිධෞ සුසංවාදං ප්‍රචාරයාවඃ| ");
INSERT INTO sansin_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ස ඊශ්වරඃ පූර්ව්වකාලේ සර්ව්වදේශීයලෝකාන් ස්වස්වමාර්ගේ චලිතුමනුමතිං දත්තවාන්, ");
INSERT INTO sansin_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","තථාපි ආකාශාත් තෝයවර්ෂණේන නානාප්‍රකාරශස්‍යෝත්පත්‍යා ච යුෂ්මාකං හිතෛෂී සන් භක්‍ෂ්‍යෛරානනදේන ච යුෂ්මාකම් අන්තඃකරණානි තර්පයන් තානි දානානි නිජසාක්‍ෂිස්වරූපාණි ස්ථපිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","කින්තු තාදෘශායාං කථායාං කථිතායාමපි තයෝඃ සමීප උත්සර්ජනාත් ලෝකනිවහං ප්‍රායේණ නිවර්ත්තයිතුං නාශක්නුතාම්| ");
INSERT INTO sansin_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","ආන්තියඛියා-ඉකනියනගරාභ්‍යාං කතිපයයිහූදීයලෝකා ආගත්‍ය ලෝකාන් ප්‍රාවර්ත්තයන්ත තස්මාත් තෛ පෞලං ප්‍රස්තරෛරාඝ්නන් තේන ස මෘත ඉති විඥාය නගරස්‍ය බහිස්තම් ආකෘෂ්‍ය නීතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","කින්තු ශිෂ්‍යගණේ තස්‍ය චතුර්දිශි තිෂ්ඨති සති ස ස්වයම් උත්ථාය පුනරපි නගරමධ්‍යං ප්‍රාවිශත් තත්පරේ(අ)හනි බර්ණබ්බාසහිතෝ දර්බ්බීනගරං ගතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","තත්‍ර සුසංවාදං ප්‍රචාර‍්‍ය්‍ය බහුලෝකාන් ශිෂ්‍යාන් කෘත්වා තෞ ලුස්ත්‍රාම් ඉකනියම් ආන්තියඛියාඤ්ච පරාවෘත්‍ය ගතෞ| ");
INSERT INTO sansin_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","බහුදුඃඛානි භුක්ත්වාපීශ්වරරාජ්‍යං ප්‍රවේෂ්ටව්‍යම් ඉති කාරණාද් ධර්ම්මමාර්ගේ ස්ථාතුං විනයං කෘත්වා ශිෂ්‍යගණස්‍ය මනඃස්ථෛර‍්‍ය්‍යම් අකුරුතාං| ");
INSERT INTO sansin_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","මණ්ඩලීනාං ප්‍රාචීනවර්ගාන් නියුජ්‍ය ප්‍රාර්ථනෝපවාසෞ කෘත්වා යත්ප්‍රභෞ තේ ව්‍යශ්වසන් තස්‍ය හස්තේ තාන් සමර්ප්‍ය ");
INSERT INTO sansin_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","පිසිදියාමධ්‍යේන පාම්ඵුලියාදේශං ගතවන්තෞ| ");
INSERT INTO sansin_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","පශ්චාත් පර්ගානගරං ගත්වා සුසංවාදං ප්‍රචාර‍්‍ය්‍ය අත්තාලියානගරං ප්‍රස්ථිතවන්තෞ| ");
INSERT INTO sansin_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","තස්මාත් සමුද්‍රපථේන ගත්වා තාභ්‍යාං යත් කර්ම්ම සම්පන්නං තත්කර්ම්ම සාධයිතුං යන්නගරේ දයාලෝරීශ්වරස්‍ය හස්තේ සමර්පිතෞ ජාතෞ තද් ආන්තියඛියානගරං ගතවන්තා| ");
INSERT INTO sansin_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","තත්‍රෝපස්ථාය තන්නගරස්ථමණ්ඩලීං සංගෘහ්‍ය ස්වාභ්‍යාම ඊශ්වරෝ යද්‍යත් කර්ම්මකරෝත් තථා යේන ප්‍රකාරේණ භින්නදේශීයලෝකාන් ප්‍රති විශ්වාසරූපද්වාරම් අමෝචයද් ඒතාන් සර්ව්වවෘත්තාන්තාන් තාන් ඥාපිතවන්තෞ| ");
INSERT INTO sansin_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","තතස්තෞ ශිර‍්‍ය්‍යෛඃ සාර්ද්ධං තත්‍ර බහුදිනානි න්‍යවසතාම්| ");
INSERT INTO sansin_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","යිහූදාදේශාත් කියන්තෝ ජනා ආගත්‍ය භ්‍රාතෘගණමිත්ථං ශික්‍ෂිතවන්තෝ මූසාව්‍යවස්ථයා යදි යුෂ්මාකං ත්වක්ඡේදෝ න භවති තර්හි යූයං පරිත්‍රාණං ප්‍රාප්තුං න ශක්‍ෂ්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","පෞලබර්ණබ්බෞ තෛඃ සහ බහූන් විචාරාන් විවාදාංශ්ච කෘතවන්තෞ, තතෝ මණ්ඩලීයනෝකා ඒතස්‍යාඃ කථායාස්තත්ත්වං ඥාතුං යිරූශාලම්නගරස්ථාන් ප්‍රේරිතාන් ප්‍රාචීනාංශ්ච ප්‍රති පෞලබර්ණබ්බාප්‍රභෘතීන් කතිපයජනාන් ප්‍රේෂයිතුං නිශ්චයං කෘතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","තේ මණ්ඩල්‍යා ප්‍රේරිතාඃ සන්තඃ ඵෛණීකීශෝමිරෝන්දේශාභ්‍යාං ගත්වා භින්නදේශීයානාං මනඃපරිවර්ත්තනස්‍ය වාර්ත්තයා භ්‍රාතෘණාං පරමාහ්ලාදම් අජනයන්| ");
INSERT INTO sansin_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","යිරූශාලම්‍යුපස්ථාය ප්‍රේරිතගණේන ලෝකප්‍රාචීනගණේන සමාජේන ච සමුපගෘහීතාඃ සන්තඃ ස්වෛරීශ්වරෝ යානි කර්ම්මාණි කෘතවාන් තේෂාං සර්ව්වවෘත්තාන්තාන් තේෂාං සමක්‍ෂම් අකථයන්| ");
INSERT INTO sansin_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","කින්තු විශ්වාසිනඃ කියන්තඃ ඵිරූශිමතග්‍රාහිණෝ ලෝකා උත්ථාය කථාමේතාං කථිතවන්තෝ භින්නදේශීයානාං ත්වක්ඡේදං කර්ත්තුං මූසාව්‍යවස්ථාං පාලයිතුඤ්ච සමාදේෂ්ටව්‍යම්| ");
INSERT INTO sansin_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","තතඃ ප්‍රේරිතා ලෝකප්‍රාචීනාශ්ච තස්‍ය විවේචනාං කර්ත්තුං සභායාං ස්ථිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","බහුවිචාරේෂු ජාතෂු පිතර උත්ථාය කථිතවාන්, හේ භ්‍රාතරෝ යථා භින්නදේශීයලෝකා මම මුඛාත් සුසංවාදං ශ්‍රුත්වා විශ්වසන්ති තදර්ථං බහුදිනාත් පූර්ව්වම් ඊශ්වරෝස්මාකං මධ්‍යේ මාං වෘත්වා නියුක්තවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","අන්තර‍්‍ය්‍යාමීශ්වරෝ යථාස්මභ්‍යං තථා භින්නදේශීයේභ්‍යඃ පවිත්‍රමාත්මානං ප්‍රදාය විශ්වාසේන තේෂාම් අන්තඃකරණානි පවිත්‍රාණි කෘත්වා ");
INSERT INTO sansin_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","තේෂාම් අස්මාකඤ්ච මධ්‍යේ කිමපි විශේෂං න ස්ථාපයිත්වා තානධි ස්වයං ප්‍රමාණං දත්තවාන් ඉති යූයං ජානීථ| ");
INSERT INTO sansin_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","අතඒවාස්මාකං පූර්ව්වපුරුෂා වයඤ්ච ස්වයං යද්‍යුගස්‍ය භාරං සෝඪුං න ශක්තාඃ සම්ප්‍රති තං ශිෂ්‍යගණස්‍ය ස්කන්ධේෂු න්‍යසිතුං කුත ඊශ්වරස්‍ය පරීක්‍ෂාං කරිෂ්‍යථ? ");
INSERT INTO sansin_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","ප්‍රභෝ ර‍්‍යීශුඛ්‍රීෂ්ටස්‍යානුග්‍රහේණ තේ යථා වයමපි තථා පරිත්‍රාණං ප්‍රාප්තුම් ආශාං කුර්ම්මඃ| ");
INSERT INTO sansin_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","අනන්තරං බර්ණබ්බාපෞලාභ්‍යාම් ඊශ්වරෝ භින්නදේශීයානාං මධ්‍යේ යද්‍යද් ආශ්චර‍්‍ය්‍යම් අද්භුතඤ්ච කර්ම්ම කෘතවාන් තද්වෘත්තාන්තං තෞ ස්වමුඛාභ්‍යාම් අවර්ණයතාං සභාස්ථාඃ සර්ව්වේ නීරවාඃ සන්තඃ ශ්‍රුතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","තයෝඃ කථායාං සමාප්තායාං සත්‍යාං යාකූබ් කථයිතුම් ආරබ්ධවාන් ");
INSERT INTO sansin_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","හේ භ්‍රාතරෝ මම කථායාම් මනෝ නිධත්ත| ඊශ්වරඃ ස්වනාමාර්ථං භින්නදේශීයලෝකානාම් මධ්‍යාද් ඒකං ලෝකසංඝං ග්‍රහීතුං මතිං කෘත්වා යේන ප්‍රකාරේණ ප්‍රථමං තාන් ප්‍රති කෘපාවලේකනං කෘතවාන් තං ශිමෝන් වර්ණිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","භවිෂ්‍යද්වාදිභිරුක්තානි යානි වාක්‍යානි තෛඃ සාර්ද්ධම් ඒතස්‍යෛක්‍යං භවති යථා ලිඛිතමාස්තේ| ");
INSERT INTO sansin_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","සර්ව්වේෂාං කර්ම්මණාං යස්තු සාධකඃ පරමේශ්වරඃ| ස ඒවේදං වදේද්වාක්‍යං ශේෂාඃ සකලමානවාඃ| භින්නදේශීයලෝකාශ්ච යාවන්තෝ මම නාමතඃ| භවන්ති හි සුවිඛ්‍යාතාස්තේ යථා පරමේශිතුඃ| ");
INSERT INTO sansin_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","තත්වං සම්‍යක් සමීහන්තේ තන්නිමිත්තමහං කිල| පරාවෘත්‍ය සමාගත්‍ය දායූදඃ පතිතං පුනඃ| දූෂ්‍යමුත්ථාපයිෂ්‍යාමි තදීයං සර්ව්වවස්තු ච| පතිතං පුනරුථාප්‍ය සජ්ජයිෂ්‍යාමි සර්ව්වථා|| ");
INSERT INTO sansin_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ආ ප්‍රථමාද් ඊශ්වරඃ ස්වීයානි සර්ව්වකර්ම්මාණි ජානාති| ");
INSERT INTO sansin_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","අතඒව මම නිවේදනමිදං භින්නදේශීයලෝකානාං මධ්‍යේ යේ ජනා ඊශ්වරං ප්‍රති පරාවර්ත්තන්ත තේෂාමුපරි අන්‍යං කමපි භාරං න න්‍යස්‍ය ");
INSERT INTO sansin_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","දේවතාප්‍රසාදාශුචිභක්‍ෂ්‍යං ව්‍යභිචාරකර්ම්ම කණ්ඨසම්පීඩනමාරිතප්‍රාණිභක්‍ෂ්‍යං රක්තභක්‍ෂ්‍යඤ්ච ඒතානි පරිත්‍යක්තුං ලිඛාමඃ| ");
INSERT INTO sansin_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","යතඃ පූර්ව්වකාලතෝ මූසාව්‍යවස්ථාප්‍රචාරිණෝ ලෝකා නගරේ නගරේ සන්ති ප්‍රතිවිශ්‍රාමවාරඤ්ච භජනභවනේ තස්‍යාඃ පාඨෝ භවති| ");
INSERT INTO sansin_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","තතඃ පරං ප්‍රේරිතගණෝ ලෝකප්‍රාචීනගණඃ සර්ව්වා මණ්ඩලී ච ස්වේෂාං මධ්‍යේ බර්ශබ්බා නාම්නා විඛ්‍යාතෝ මනෝනීතෞ කෘත්වා පෞලබර්ණබ්බාභ්‍යාං සාර්ද්ධම් ආන්තියඛියානගරං ප්‍රති ප්‍රේෂණම් උචිතං බුද්ධ්වා තාභ්‍යාං පත්‍රං ප්‍රෛෂයන්| ");
INSERT INTO sansin_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","තස්මින් පත්‍රේ ලිඛිතමිංද, ආන්තියඛියා-සුරියා-කිලිකියාදේශස්ථභින්නදේශීයභ්‍රාතෘගණාය ප්‍රේරිතගණස්‍ය ලෝකප්‍රාචීනගණස්‍ය භ්‍රාතෘගණස්‍ය ච නමස්කාරඃ| ");
INSERT INTO sansin_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","විශේෂතෝ(අ)ස්මාකම් ආඥාම් අප්‍රාප්‍යාපි කියන්තෝ ජනා අස්මාකං මධ්‍යාද් ගත්වා ත්වක්ඡේදෝ මූසාව්‍යවස්ථා ච පාලයිතව්‍යාවිති යුෂ්මාන් ශික්‍ෂයිත්වා යුෂ්මාකං මනසාමස්ථෛර‍්‍ය්‍යං කෘත්වා යුෂ්මාන් සසන්දේහාන් අකුර්ව්වන් ඒතාං කථාං වයම් අශෘන්ම| ");
INSERT INTO sansin_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","තත්කාරණාද් වයම් ඒකමන්ත්‍රණාඃ සන්තඃ සභායාං ස්ථිත්වා ප්‍රභෝ ර‍්‍යීශුඛ්‍රීෂ්ටස්‍ය නාමනිමිත්තං මෘත්‍යුමුඛගතාභ්‍යාමස්මාකං ");
INSERT INTO sansin_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ප්‍රියබර්ණබ්බාපෞලාභ්‍යාං සාර්ද්ධං මනෝනීතලෝකානාං කේෂාඤ්චිද් යුෂ්මාකං සන්නිධෞ ප්‍රේෂණම් උචිතං බුද්ධවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","අතෝ යිහූදාසීලෞ යුෂ්මාන් ප්‍රති ප්‍රේෂිතවන්තඃ, ඒතයෝ ර්මුඛාභ්‍යාං සර්ව්වාං කථාං ඥාස්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","දේවතාප්‍රසාදභක්‍ෂ්‍යං රක්තභක්‍ෂ්‍යං ගලපීඩනමාරිතප්‍රාණිභක්‍ෂ්‍යං ව්‍යභිචාරකර්ම්ම චේමානි සර්ව්වාණි යුෂ්මාභිස්ත්‍යාජ්‍යානි; ඒතත්ප්‍රයෝජනීයාඥාව්‍යතිරේකේන යුෂ්මාකම් උපරි භාරමන්‍යං න න්‍යසිතුං පවිත්‍රස්‍යාත්මනෝ(අ)ස්මාකඤ්ච උචිතඥානම් අභවත්| ");
INSERT INTO sansin_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","අතඒව තේභ්‍යඃ සර්ව්වේභ්‍යඃ ස්වේෂු රක්‍ෂිතේෂු යූයං භද්‍රං කර්ම්ම කරිෂ්‍යථ| යුෂ්මාකං මඞ්ගලං භූයාත්| ");
INSERT INTO sansin_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","තේे විසෘෂ්ටාඃ සන්ත ආන්තියඛියානගර උපස්ථාය ලෝකනිවහං සංගෘහ්‍ය පත්‍රම් අදදන්| ");
INSERT INTO sansin_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","තතස්තේ තත්පත්‍රං පඨිත්වා සාන්ත්වනාං ප්‍රාප්‍ය සානන්දා අභවන්| ");
INSERT INTO sansin_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","යිහූදාසීලෞ ච ස්වයං ප්‍රචාරකෞ භූත්වා භ්‍රාතෘගණං නානෝපදිශ්‍ය තාන් සුස්ථිරාන් අකුරුතාම්| ");
INSERT INTO sansin_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ඉත්ථං තෞ තත්‍ර තෛඃ සාකං කතිපයදිනානි යාපයිත්වා පශ්චාත් ප්‍රේරිතානාං සමීපේ ප්‍රත්‍යාගමනාර්ථං තේෂාං සන්නිධේඃ කල්‍යාණේන විසෘෂ්ටාවභවතාං| ");
INSERT INTO sansin_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","කින්තු සීලස්තත්‍ර ස්ථාතුං වාඤ්ඡිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","අපරං පෞලබර්ණබ්බෞ බහවඃ ශිෂ්‍යාශ්ච ලෝකාන් උපදිශ්‍ය ප්‍රභෝඃ සුසංවාදං ප්‍රචාරයන්ත ආන්තියඛියායාං කාලං යාපිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","කතිපයදිනේෂු ගතේෂු පෞලෝ බර්ණබ්බාම් අවදත් ආගච්ඡාවාං යේෂු නගරේෂ්වීශ්වරස්‍ය සුසංවාදං ප්‍රචාරිතවන්තෞ තානි සර්ව්වනගරාණි පුනර්ගත්වා භ්‍රාතරඃ කීදෘශාඃ සන්තීති ද්‍රෂ්ටුං තාන් සාක්‍ෂාත් කුර්ව්වඃ| ");
INSERT INTO sansin_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","තේන මාර්කනාම්නා විඛ්‍යාතං යෝහනං සඞ්ගිනං කර්ත්තුං බර්ණබ්බා මතිමකරෝත්, ");
INSERT INTO sansin_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","කින්තු ස පූර්ව්වං තාභ්‍යාං සහ කාර‍්‍ය්‍යාර්ථං න ගත්වා පාම්ඵූලියාදේශේ තෞ ත්‍යක්තවාන් තත්කාරණාත් පෞලස්තං සඞ්ගිනං කර්ත්තුම් අනුචිතං ඥාතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ඉත්ථං තයෝරතිශයවිරෝධස්‍යෝපස්ථිතත්වාත් තෞ පරස්පරං පෘථගභවතාං තතෝ බර්ණබ්බා මාර්කං ගෘහීත්වා පෝතේන කුප්‍රෝපද්වීපං ගතවාන්; ");
INSERT INTO sansin_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","කින්තු පෞලඃ සීලං මනෝනීතං කෘත්වා භ්‍රාතෘභිරීශ්වරානුග්‍රහේ සමර්පිතඃ සන් ප්‍රස්ථාය ");
INSERT INTO sansin_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","සුරියාකිලිකියාදේශාභ්‍යාං මණ්ඩලීඃ ස්ථිරීකුර්ව්වන් අගච්ඡත්| ");
INSERT INTO sansin_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","පෞලෝ දර්බ්බීලුස්ත්‍රානගරයෝරුපස්ථිතෝභවත් තත්‍ර තීමථියනාමා ශිෂ්‍ය ඒක ආසීත්; ස විශ්වාසින්‍යා යිහූදීයායා යෝෂිතෝ ගර්බ්භජාතඃ කින්තු තස්‍ය පිතාන්‍යදේශීයලෝකඃ| ");
INSERT INTO sansin_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","ස ජනෝ ලුස්ත්‍රා-ඉකනියනගරස්ථානාං භ්‍රාතෘණාං සමීපේපි සුඛ්‍යාතිමාන් ආසීත්| ");
INSERT INTO sansin_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","පෞලස්තං ස්වසඞ්ගිනං කර්ත්තුං මතිං කෘත්වා තං ගෘහීත්වා තද්දේශනිවාසිනාං යිහූදීයානාම් අනුරෝධාත් තස්‍ය ත්වක්ඡේදං කෘතවාන් යතස්තස්‍ය පිතා භින්නදේශීයලෝක ඉති සර්ව්වෛරඥායත| ");
INSERT INTO sansin_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","තතඃ පරං තේ නගරේ නගරේ භ්‍රමිත්වා යිරූශාලමස්ථෛඃ ප්‍රේරිතෛ ර්ලෝකප්‍රාචීනෛශ්ච නිරූපිතං යද් ව්‍යවස්ථාපත්‍රං තදනුසාරේණාචරිතුං ලෝකේභ්‍යස්තද් දත්තවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","තේනෛව සර්ව්වේ ධර්ම්මසමාජාඃ ඛ්‍රීෂ්ටධර්ම්මේ සුස්ථිරාඃ සන්තඃ ප්‍රතිදිනං වර්ද්ධිතා අභවන්| ");
INSERT INTO sansin_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","තේෂු ඵ්‍රුගියාගාලාතියාදේශමධ්‍යේන ගතේෂු සත්සු පවිත්‍ර ආත්මා තාන් ආශියාදේශේ කථාං ප්‍රකාශයිතුං ප්‍රතිෂිද්ධවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","තථා මුසියාදේශ උපස්ථාය බිථුනියාං ගන්තුං තෛරුද්‍යෝගේ කෘතේ ආත්මා තාන් නාන්වමන්‍යත| ");
INSERT INTO sansin_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","තස්මාත් තේ මුසියාදේශං පරිත්‍යජ්‍ය ත්‍රෝයානගරං ගත්වා සමුපස්ථිතාඃ| ");
INSERT INTO sansin_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","රාත්‍රෞ පෞලඃ ස්වප්නේ දෘෂ්ටවාන් ඒකෝ මාකිදනියලෝකස්තිෂ්ඨන් විනයං කෘත්වා තස්මෛ කථයති, මාකිදනියාදේශම් ආගත්‍යාස්මාන් උපකුර්ව්විති| ");
INSERT INTO sansin_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","තස්‍යේත්ථං ස්වප්නදර්ශනාත් ප්‍රභුස්තද්දේශීයලෝකාන් ප්‍රති සුසංවාදං ප්‍රචාරයිතුම් අස්මාන් ආහූයතීති නිශ්චිතං බුද්ධ්වා වයං තූර්ණං මාකිදනියාදේශං ගන්තුම් උද්‍යෝගම් අකුර්ම්ම| ");
INSERT INTO sansin_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","තතඃ පරං වයං ත්‍රෝයානගරාද් ප්‍රස්ථාය ඍජුමාර්ගේණ සාමථ්‍රාකියෝපද්වීපේන ගත්වා පරේ(අ)හනි නියාපලිනගර උපස්ථිතාඃ| ");
INSERT INTO sansin_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","තස්මාද් ගත්වා මාකිදනියාන්තර්ව්වර්ත්ති රෝමීයවසතිස්ථානං යත් ඵිලිපීනාමප්‍රධානනගරං තත්‍රෝපස්ථාය කතිපයදිනානි තත්‍ර ස්ථිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","විශ්‍රාමවාරේ නගරාද් බහි ර්ගත්වා නදීතටේ යත්‍ර ප්‍රාර්ථනාචාර ආසීත් තත්‍රෝපවිශ්‍ය සමාගතා නාරීඃ ප්‍රති කථාං ප්‍රාචාරයාම| ");
INSERT INTO sansin_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","තතඃ ථුයාතීරානගරීයා ධූෂරාම්බරවික්‍රායිණී ලුදියානාමිකා යා ඊශ්වරසේවිකා යෝෂිත් ශ්‍රෝත්‍රීණාං මධ්‍ය ආසීත් තයා පෞලෝක්තවාක්‍යානි යද් ගෘහ්‍යන්තේ තදර්ථං ප්‍රභුස්තස්‍යා මනෝද්වාරං මුක්තවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","අතඃ සා යෝෂිත් සපරිවාරා මජ්ජිතා සතී විනයං කෘත්වා කථිතවතී, යුෂ්මාකං විචාරාද් යදි ප්‍රභෞ විශ්වාසිනී ජාතාහං තර්හි මම ගෘහම් ආගත්‍ය තිෂ්ඨත| ඉත්ථං සා යත්නේනාස්මාන් අස්ථාපයත්| ");
INSERT INTO sansin_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","යස්‍යා ගණනයා තදධිපතීනාං බහුධනෝපාර්ජනං ජාතං තාදෘශී ගණකභූතග්‍රස්තා කාචන දාසී ප්‍රාර්ථනාස්ථානගමනකාල ආගත්‍යාස්මාන් සාක්‍ෂාත් කෘතවතී| ");
INSERT INTO sansin_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","සාස්මාකං පෞලස්‍ය ච පශ්චාද් ඒත්‍ය ප්‍රෝච්චෛඃ කථාමිමාං කථිතවතී, මනුෂ්‍යා ඒතේ සර්ව්වෝපරිස්ථස්‍යේශ්වරස්‍ය සේවකාඃ සන්තෝ(අ)ස්මාන් ප්‍රති පරිත්‍රාණස්‍ය මාර්ගං ප්‍රකාශයන්ති| ");
INSERT INTO sansin_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","සා කන්‍යා බහුදිනානි තාදෘශම් අකරෝත් තස්මාත් පෞලෝ දුඃඛිතඃ සන් මුඛං පරාවර්ත්‍ය තං භූතමවදද්, අහං යීශුඛ්‍රීෂ්ටස්‍ය නාම්නා ත්වාමාඥාපයාමි ත්වමස්‍යා බහිර්ගච්ඡ; තේනෛව තත්ක්‍ෂණාත් ස භූතස්තස්‍යා බහිර්ගතඃ| ");
INSERT INTO sansin_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","තතඃ ස්වේෂාං ලාභස්‍ය ප්‍රත්‍යාශා විඵලා ජාතේති විලෝක්‍ය තස්‍යාඃ ප්‍රභවඃ පෞලං සීලඤ්ච ධෘත්වාකෘෂ්‍ය විචාරස්ථානේ(අ)ධිපතීනාං සමීපම් ආනයන්| ");
INSERT INTO sansin_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","තතඃ ශාසකානාං නිකටං නීත්වා රෝමිලෝකා වයම් අස්මාකං යද් ව්‍යවහරණං ග්‍රහීතුම් ආචරිතුඤ්ච නිෂිද්ධං, ");
INSERT INTO sansin_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ඉමේ යිහූදීයලෝකාඃ සන්තෝපි තදේව ශික්‍ෂයිත්වා නගරේ(අ)ස්මාකම් අතීව කලහං කුර්ව්වන්ති, ");
INSERT INTO sansin_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","ඉති කථිතේ සති ලෝකනිවහස්තයෝඃ ප්‍රාතිකූල්‍යේනෝදතිෂ්ඨත් තථා ශාසකාස්තයෝ ර්වස්ත්‍රාණි ඡිත්වා වේත්‍රාඝාතං කර්ත්තුම් ආඥාපයන්| ");
INSERT INTO sansin_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","අපරං තේ තෞ බහු ප්‍රහාර‍්‍ය්‍ය ත්වමේතෞ කාරාං නීත්වා සාවධානං රක්‍ෂයේති කාරාරක්‍ෂකම් ආදිශන්| ");
INSERT INTO sansin_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ඉත්ථම් ආඥාං ප්‍රාප්‍ය ස තාවභ්‍යන්තරස්ථකාරාං නීත්වා පාදේෂු පාදපාශීභි ර්බද්ධ්වා ස්ථාපිතාවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","අථ නිශීථසමයේ පෞලසීලාවීශ්වරමුද්දිශ්‍ය ප්‍රාථනාං ගානඤ්ච කෘතවන්තෞ, කාරාස්ථිතා ලෝකාශ්ච තදශෘණ්වන් ");
INSERT INTO sansin_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","තදාකස්මාත් මහාන් භූමිකම්පෝ(අ)භවත් තේන භිත්තිමූලේන සහ කාරා කම්පිතාභූත් තත්ක්‍ෂණාත් සර්ව්වාණි ද්වාරාණි මුක්තානි ජාතානි සර්ව්වේෂාං බන්ධනානි ච මුක්තානි| ");
INSERT INTO sansin_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","අතඒව කාරාරක්‍ෂකෝ නිද්‍රාතෝ ජාගරිත්වා කාරායා ද්වාරාණි මුක්තානි දෘෂ්ට්වා බන්දිලෝකාඃ පලායිතා ඉත්‍යනුමාය කෝෂාත් ඛඞ්ගං බහිඃ කෘත්වාත්මඝාතං කර්ත්තුම් උද්‍යතඃ| ");
INSERT INTO sansin_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","කින්තු පෞලඃ ප්‍රෝච්චෛස්තමාහූය කථිතවාන් පශ්‍ය වයං සර්ව්වේ(අ)ත්‍රාස්මහේ, ත්වං නිජප්‍රාණහිංසාං මාකාර්ෂීඃ| ");
INSERT INTO sansin_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","තදා ප්‍රදීපම් ආනේතුම් උක්ත්වා ස කම්පමානඃ සන් උල්ලම්ප්‍යාභ්‍යන්තරම් ආගත්‍ය පෞලසීලයෝඃ පාදේෂු පතිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","පශ්චාත් ස තෞ බහිරානීය පෘෂ්ටවාන් හේ මහේච්ඡෞ පරිත්‍රාණං ප්‍රාප්තුං මයා කිං කර්ත්තව්‍යං? ");
INSERT INTO sansin_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","පශ්චාත් තෞ ස්වගෘහමානීය තයෝඃ සම්මුඛේ ඛාද්‍යද්‍රව්‍යාණි ස්ථාපිතවාන් තථා ස ස්වයං තදීයාඃ සර්ව්වේ පරිවාරාශ්චේශ්වරේ විශ්වසන්තඃ සානන්දිතා අභවන්| ");
INSERT INTO sansin_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","තස්මෛ තස්‍ය ගෘහස්ථිතසර්ව්වලෝකේභ්‍යශ්ච ප්‍රභෝඃ කථාං කථිතවන්තෞ| ");
INSERT INTO sansin_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","තථා රාත්‍රේස්තස්මින්නේව දණ්ඩේ ස තෞ ගෘහීත්වා තයෝඃ ප්‍රහාරාණාං ක්‍ෂතානි ප්‍රක්‍ෂාලිතවාන් තතඃ ස ස්වයං තස්‍ය සර්ව්වේ පරිජනාශ්ච මජ්ජිතා අභවන්| ");
INSERT INTO sansin_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","පශ්චාත් තෞ ස්වගෘහමානීය තයෝඃ සම්මුඛේ ඛාද්‍යද්‍රව්‍යාණි ස්ථාපිතවාන් තථා ස ස්වයං තදීයාඃ සර්ව්වේ පරිවාරාශ්චේශ්වරේ විශ්වසන්තඃ සානන්දිතා අභවන්| ");
INSERT INTO sansin_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","දින උපස්ථිතේ තෞ ලෝකෞ මෝචයේති කථාං කථයිතුං ශාසකාඃ පදාතිගණං ප්‍රේෂිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","තතඃ කාරාරක්‍ෂකඃ පෞලාය තාං වාර්ත්තාං කථිතවාන් යුවාං ත්‍යාජයිතුං ශාසකා ලෝකාන ප්‍රේෂිතවන්ත ඉදානීං යුවාං බහි ර්භූත්වා කුශලේන ප්‍රතිෂ්ඨේතාං| ");
INSERT INTO sansin_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","කින්තු පෞලස්තාන් අවදත් රෝමිලෝකයෝරාවයෝඃ කමපි දෝෂම් න නිශ්චිත්‍ය සර්ව්වේෂාං සමක්‍ෂම් ආවාං කශයා තාඩයිත්වා කාරායාං බද්ධවන්ත ඉදානීං කිමාවාං ගුප්තං විස්ත්‍රක්‍ෂ්‍යන්ති? තන්න භවිෂ්‍යති, ස්වයමාගත්‍යාවාං බහිඃ කෘත්වා නයන්තු| ");
INSERT INTO sansin_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","තදා පදාතිභිඃ ශාසකේභ්‍ය ඒතද්වාර්ත්තායාං කථිතායාං තෞ රෝමිලෝකාවිති කථාං ශ්‍රුත්වා තේ භීතාඃ ");
INSERT INTO sansin_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","සන්තස්තයෝඃ සන්නිධිමාගත්‍ය විනයම් අකුර්ව්වන් අපරං බහිඃ කෘත්වා නගරාත් ප්‍රස්ථාතුං ප්‍රාර්ථිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","තතස්තෞ කාරායා නිර්ගත්‍ය ලුදියායා ගෘහං ගතවන්තෞ තත්‍ර භ්‍රාතෘගණං සාක්‍ෂාත්කෘත්‍ය තාන් සාන්ත්වයිත්වා තස්මාත් ස්ථානාත් ප්‍රස්ථිතෞ| ");
INSERT INTO sansin_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","පෞලසීලෞ ආම්ඵිපල්‍යාපල්ලෝනියානගරාභ්‍යාං ගත්වා යත්‍ර යිහූදීයානාං භජනභවනමේකම් ආස්තේ තත්‍ර ථිෂලනීකීනගර උපස්ථිතෞ| ");
INSERT INTO sansin_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","තදා පෞලඃ ස්වාචාරානුසාරේණ තේෂාං සමීපං ගත්වා විශ්‍රාමවාරත්‍රයේ තෛඃ සාර්ද්ධං ධර්ම්මපුස්තකීයකථායා විචාරං කෘතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ඵලතඃ ඛ්‍රීෂ්ටේන දුඃඛභෝගඃ කර්ත්තව්‍යඃ ශ්මශානදුත්ථානඤ්ච කර්ත්තව්‍යං යුෂ්මාකං සන්නිධෞ යස්‍ය යීශෝඃ ප්‍රස්තාවං කරෝමි ස ඊශ්වරේණාභිෂික්තඃ ස ඒතාඃ කථාඃ ප්‍රකාශ්‍ය ප්‍රමාණං දත්වා ස්ථිරීකෘතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","තස්මාත් තේෂාං කතිපයජනා අන්‍යදේශීයා බහවෝ භක්තලෝකා බහ්‍යඃ ප්‍රධානනාර‍්‍ය්‍යශ්ච විශ්වස්‍ය පෞලසීලයෝඃ පශ්චාද්ගාමිනෝ ජාතාඃ| ");
INSERT INTO sansin_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","කින්තු විශ්වාසහීනා යිහූදීයලෝකා ඊර්ෂ්‍යයා පරිපූර්ණාඃ සන්තෝ හටට්ස්‍ය කතිනයලම්පටලෝකාන් සඞ්ගිනඃ කෘත්වා ජනතයා නගරමධ්‍යේ මහාකලහං කෘත්වා යාසෝනෝ ගෘහම් ආක්‍රම්‍ය ප්‍රේරිතාන් ධෘත්වා ලෝකනිවහස්‍ය සමීපම් ආනේතුං චේෂ්ටිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","තේෂාමුද්දේශම් අප්‍රාප්‍ය ච යාසෝනං කතිපයාන් භ්‍රාතෘංශ්ච ධෘත්වා නගරාධිපතීනාං නිකටමානීය ප්‍රෝච්චෛඃ කථිතවන්තෝ යේ මනුෂ්‍යා ජගදුද්වාටිතවන්තස්තේ (අ)ත්‍රාප්‍යුපස්ථිතාඃ සන්ති, ");
INSERT INTO sansin_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ඒෂ යාසෝන් ආතිථ්‍යං කෘත්වා තාන් ගෘහීතවාන්| යීශුනාමක ඒකෝ රාජස්තීති කථයන්තස්තේ කෛසරස්‍යාඥාවිරුද්ධං කර්ම්ම කුර්ව්වති| ");
INSERT INTO sansin_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","තේෂාං කථාමිමාං ශ්‍රුත්වා ලෝකනිවහෝ නගරාධිපතයශ්ච සමුද්විග්නා අභවන්| ");
INSERT INTO sansin_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","තදා යාසෝනස්තදන්‍යේෂාඤ්ච ධනදණ්ඩං ගෘහීත්වා තාන් පරිත්‍යක්තවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","තතඃ පරං භ්‍රාතෘගණෝ රජන්‍යාං පෞලසීලෞ ශීඝ්‍රං බිරයානගරං ප්‍රේෂිතවාන් තෞ තත්‍රෝපස්ථාය යිහූදීයානාං භජනභවනං ගතවන්තෞ| ");
INSERT INTO sansin_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","තත්‍රස්ථා ලෝකාඃ ථිෂලනීකීස්ථලෝකේභ්‍යෝ මහාත්මාන ආසන් යත ඉත්ථං භවති න වේති ඥාතුං දිනේ දිනේ ධර්ම්මග්‍රන්ථස්‍යාලෝචනාං කෘත්වා ස්වෛරං කථාම් අගෘහ්ලන්| ");
INSERT INTO sansin_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","තස්මාද් අනේකේ යිහූදීයා අන්‍යදේශීයානාං මාන්‍යා ස්ත්‍රියඃ පුරුෂාශ්චානේකේ ව්‍යශ්වසන්| ");
INSERT INTO sansin_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","කින්තු බිරයානගරේ පෞලේනේශ්වරීයා කථා ප්‍රචාර‍්‍ය්‍යත ඉති ථිෂලනීකීස්ථා යිහූදීයා ඥාත්වා තත්ස්ථානමප්‍යාගත්‍ය ලෝකානාං කුප්‍රවෘත්තිම් අජනයන්| ");
INSERT INTO sansin_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","අතඒව තස්මාත් ස්ථානාත් සමුද්‍රේණ යාන්තීති දර්ශයිත්වා භ්‍රාතරඃ ක්‍ෂිප්‍රං පෞලං ප්‍රාහිණ්වන් කින්තු සීලතීමථියෞ තත්‍ර ස්ථිතවන්තෞ| ");
INSERT INTO sansin_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","තතඃ පරං පෞලස්‍ය මාර්ගදර්ශකාස්තම් ආථීනීනගර උපස්ථාපයන් පශ්චාද් යුවාං තූර්ණම් ඒතත් ස්ථානං ආගමිෂ්‍යථඃ සීලතීමථියෞ ප්‍රතීමාම් ආඥාං ප්‍රාප්‍ය තේ ප්‍රත්‍යාගතාඃ| ");
INSERT INTO sansin_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","පෞල ආථීනීනගරේ තාවපේක්‍ෂ්‍ය තිෂ්ඨන් තන්නගරං ප්‍රතිමාභිඃ පරිපූර්ණං දෘෂ්ට්වා සන්තප්තහෘදයෝ (අ)භවත්| ");
INSERT INTO sansin_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","තතඃ ස භජනභවනේ යාන් යිහූදීයාන් භක්තලෝකාංශ්ච හට්ටේ ච යාන් අපශ්‍යත් තෛඃ සහ ප්‍රතිදිනං විචාරිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","කින්ත්විපිකූරීයමතග්‍රහිණඃ ස්තෝයිකීයමතග්‍රාහිණශ්ච කියන්තෝ ජනාස්තේන සාර්ද්ධං ව්‍යවදන්ත| තත්‍ර කේචිද් අකථයන් ඒෂ වාචාලඃ කිං වක්තුම් ඉච්ඡති? අපරේ කේචිද් ඒෂ ජනඃ කේෂාඤ්චිද් විදේශීයදේවානාං ප්‍රචාරක ඉත්‍යනුමීයතේ යතඃ ස යීශුම් උත්ථිතිඤ්ච ප්‍රචාරයත්| ");
INSERT INTO sansin_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","තේ තම් අරේයපාගනාම විචාරස්ථානම් ආනීය ප්‍රාවෝචන් ඉදං යන්නවීනං මතං ත්වං ප්‍රාචීකශ ඉදං කීදෘශං ඒතද් අස්මාන් ශ්‍රාවය; ");
INSERT INTO sansin_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","යාමිමාම් අසම්භවකථාම් අස්මාකං කර්ණගෝචරීකෘතවාන් අස්‍යා භාවාර්ථඃ ක ඉති වයං ඥාතුම් ඉච්ඡාමඃ| ");
INSERT INTO sansin_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","තදාථීනීනිවාසිනස්තන්නගරප්‍රවාසිනශ්ච කේවලං කස්‍යාශ්චන නවීනකථායාඃ ශ්‍රවණේන ප්‍රචාරණේන ච කාලම් අයාපයන්| ");
INSERT INTO sansin_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","පෞලෝ(අ)රේයපාගස්‍ය මධ්‍යේ තිෂ්ඨන් ඒතාං කථාං ප්‍රචාරිතවාන්, හේ ආථීනීයලෝකා යූයං සර්ව්වථා දේවපූජායාම් ආසක්තා ඉත්‍යහ ප්‍රත්‍යක්‍ෂං පශ්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","යතඃ පර‍්‍ය්‍යටනකාලේ යුෂ්මාකං පූජනීයානි පශ්‍යන් ‘අවිඥාතේශ්වරාය` ඒතල්ලිපියුක්තාං යඥවේදීමේකාං දෘෂ්ටවාන්; අතෝ න විදිත්වා යං පූජයධ්වේ තස්‍යෛව තත්වං යුෂ්මාන් ප්‍රති ප්‍රචාරයාමි| ");
INSERT INTO sansin_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ජගතෝ ජගත්ස්ථානාං සර්ව්වවස්තූනාඤ්ච ස්‍රෂ්ටා ය ඊශ්වරඃ ස ස්වර්ගපෘථිව්‍යෝරේකාධිපතිඃ සන් කරනිර්ම්මිතමන්දිරේෂු න නිවසති; ");
INSERT INTO sansin_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ස ඒව සර්ව්වේභ්‍යෝ ජීවනං ප්‍රාණාන් සර්ව්වසාමග්‍රීශ්ච ප්‍රදදාති; අතඒව ස කස්‍යාශ්චිත් සාමග්‍ය්‍රා අභාවහේතෝ ර්මනුෂ්‍යාණාං හස්තෛඃ සේවිතෝ භවතීති න| ");
INSERT INTO sansin_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ස භූමණ්ඩලේ නිවාසාර්ථම් ඒකස්මාත් ශෝණිතාත් සර්ව්වාන් මනුෂ්‍යාන් සෘෂ්ට්වා තේෂාං පූර්ව්වනිරූපිතසමයං වසතිසීමාඤ්ච නිරචිනෝත්; ");
INSERT INTO sansin_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","තස්මාත් ලෝකෛඃ කේනාපි ප්‍රකාරේණ මෘගයිත්වා පරමේශ්වරස්‍ය තත්වං ප්‍රාප්තුං තස්‍ය ගවේෂණං කරණීයම්| ");
INSERT INTO sansin_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","කින්තු සෝ(අ)ස්මාකං කස්මාච්චිදපි දූරේ තිෂ්ඨතීති නහි, වයං තේන නිශ්වසනප්‍රශ්වසනගමනාගමනප්‍රාණධාරණානි කුර්ම්මඃ, පුुනශ්ච යුෂ්මාකමේව කතිපයාඃ කවයඃ කථයන්ති ‘තස්‍ය වංශා වයං ස්මෝ හි` ඉති| ");
INSERT INTO sansin_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","අතඒව යදි වයම් ඊශ්වරස්‍ය වංශා භවාමස්තර්හි මනුෂ්‍යෛ ර්විද්‍යයා කෞශලේන ච තක්‍ෂිතං ස්වර්ණං රූප්‍යං දෘෂද් වෛතේෂාමීශ්වරත්වම් අස්මාභි ර්න ඥාතව්‍යං| ");
INSERT INTO sansin_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","තේෂාං පූර්ව්වීයලෝකානාම් අඥානතාං ප්‍රතීශ්වරෝ යද්‍යපි නාවාධත්ත තථාපීදානීං සර්ව්වත්‍ර සර්ව්වාන් මනඃ පරිවර්ත්තයිතුම් ආඥාපයති, ");
INSERT INTO sansin_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","යතඃ ස්වනියුක්තේන පුරුෂේණ යදා ස පෘථිවීස්ථානාං සර්ව්වලෝකානාං විචාරං කරිෂ්‍යති තද්දිනං න්‍යරූපයත්; තස්‍ය ශ්මශානෝත්ථාපනේන තස්මින් සර්ව්වේභ්‍යඃ ප්‍රමාණං ප්‍රාදාත්| ");
INSERT INTO sansin_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","තදා ශ්මශානාද් උත්ථානස්‍ය කථාං ශ්‍රුත්වා කේචිද් උපාහමන්, කේචිදවදන් ඒනාං කථාං පුනරපි ත්වත්තඃ ශ්‍රෝෂ්‍යාමඃ| ");
INSERT INTO sansin_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","තතඃ පෞලස්තේෂාං සමීපාත් ප්‍රස්ථිाතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","තථාපි කේචිල්ලෝකාස්තේන සාර්ද්ධං මිලිත්වා ව්‍යශ්වසන් තේෂාං මධ්‍යේ (අ)රේයපාගීයදියනුසියෝ දාමාරීනාමා කාචින්නාරී කියන්තෝ නරාශ්චාසන්| ");
INSERT INTO sansin_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","තද්ඝටනාතඃ පරං පෞල ආථීනීනගරාද් යාත්‍රාං කෘත්වා කරින්ථනගරම් ආගච්ඡත්| ");
INSERT INTO sansin_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","තස්මින් සමයේ ක්ලෞදියඃ සර්ව්වාන් යිහූදීයාන් රෝමානගරං විහාය ගන්තුම් ආඥාපයත්, තස්මාත් ප්‍රිස්කිල්ලානාම්නා ජායයා සාර්ද්ධම් ඉතාලියාදේශාත් කිඤ්චිත්පූර්ව්වම් ආගමත් යඃ පන්තදේශේ ජාත ආක්කිලනාමා යිහූදීයලෝකඃ පෞලස්තං සාක්‍ෂාත් ප්‍රාප්‍ය තයෝඃ සමීපමිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","තෞ දූෂ්‍යනිර්ම්මාණජීවිනෞ, තස්මාත් පරස්පරම් ඒකවෘත්තිකත්වාත් ස තාභ්‍යාං සහ උෂිත්වා තත් කර්ම්මාකරෝත්| ");
INSERT INTO sansin_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","පෞලඃ ප්‍රතිවිශ්‍රාමවාරං භජනභවනං ගත්වා විචාරං කෘත්වා යිහූදීයාන් අන්‍යදේශීයාංශ්ච ප්‍රවෘත්තිං ග්‍රාහිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","සීලතීමථියයෝ ර්මාකිදනියාදේශාත් සමේතයෝඃ සතෝඃ පෞල උත්තප්තමනා භූත්වා යීශුරීශ්වරේණාභිෂික්තෝ භවතීති ප්‍රමාණං යිහූදීයානාං සමීපේ ප්‍රාදාත්| ");
INSERT INTO sansin_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","කින්තු තේ (අ)තීව විරෝධං විධාය පාෂණ්ඩීයකථාං කථිතවන්තස්තතඃ පෞලෝ වස්ත්‍රං ධුන්වන් ඒතාං කථාං කථිතවාන්, යුෂ්මාකං ශෝණිතපාතාපරාධෝ යුෂ්මාන් ප්‍රත්‍යේව භවතු, තේනාහං නිරපරාධෝ (අ)ද්‍යාරභ්‍ය භින්නදේශීයානාං සමීපං යාමි| ");
INSERT INTO sansin_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","ස තස්මාත් ප්‍රස්ථාය භජනභවනසමීපස්ථස්‍ය යුස්තනාම්න ඊශ්වරභක්තස්‍ය භින්නදේශීයස්‍ය නිවේශනං ප්‍රාවිශත්| ");
INSERT INTO sansin_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","තතඃ ක්‍රීෂ්පනාමා භජනභවනාධිපතිඃ සපරිවාරඃ ප්‍රභෞ ව්‍යශ්වසීත්, කරින්ථනගරීයා බහවෝ ලෝකාශ්ච සමාකර්ණ්‍ය විශ්වස්‍ය මජ්ජිතා අභවන්| ");
INSERT INTO sansin_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","ක්‍ෂණදායාං ප්‍රභුඃ පෞලං දර්ශනං දත්වා භාෂිතවාන්, මා භෛෂීඃ, මා නිරසීඃ කථාං ප්‍රචාරය| ");
INSERT INTO sansin_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","අහං ත්වයා සාර්ද්ධම් ආස හිංසාර්ථං කෝපි ත්වාං ස්ප්‍රෂ්ටුං න ශක්‍ෂ්‍යති නගරේ(අ)ස්මින් මදීයා ලෝකා බහව ආසතේ| ");
INSERT INTO sansin_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","තස්මාත් පෞලස්තන්නගරේ ප්‍රායේණ සාර්ද්ධවත්සරපර‍්‍ය්‍යන්තං සංස්ථායේශ්වරස්‍ය කථාම් උපාදිශත්| ");
INSERT INTO sansin_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","ගාල්ලියනාමා කශ්චිද් ආඛායාදේශස්‍ය ප්‍රාඩ්විවාකඃ සමභවත්, තතෝ යිහූදීයා ඒකවාක්‍යාඃ සන්තඃ පෞලම් ආක්‍රම්‍ය විචාරස්ථානං නීත්වා ");
INSERT INTO sansin_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","මානුෂ ඒෂ ව්‍යවස්ථාය විරුද්ධම් ඊශ්වරභජනං කර්ත්තුං ලෝකාන් කුප්‍රවෘත්තිං ග්‍රාහයතීති නිවේදිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","තතඃ පෞලේ ප්‍රත්‍යුත්තරං දාතුම් උද්‍යතේ සති ගාල්ලියා යිහූදීයාන් ව්‍යාහරත්, යදි කස්‍යචිද් අන්‍යායස්‍ය වාතිශයදුෂ්ටතාචරණස්‍ය විචාරෝ(අ)භවිෂ්‍යත් තර්හි යුෂ්මාකං කථා මයා සහනීයාභවිෂ්‍යත්| ");
INSERT INTO sansin_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","කින්තු යදි කේවලං කථායා වා නාම්නෝ වා යුෂ්මාකං ව්‍යවස්ථායා විවාදෝ භවති තර්හි තස්‍ය විචාරමහං න කරිෂ්‍යාමි, යූයං තස්‍ය මීමාංසාං කුරුත| ");
INSERT INTO sansin_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","තතඃ ස තාන් විචාරස්ථානාද් දූරීකෘතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","තදා භින්නදේශීයාඃ සෝස්ථිනිනාමානං භජනභවනස්‍ය ප්‍රධානාධිපතිං ධෘත්වා විචාරස්ථානස්‍ය සම්මුඛේ ප්‍රාහරන් තථාපි ගාල්ලියා තේෂු සර්ව්වකර්ම්මසු න මනෝ න්‍යදධාත්| ");
INSERT INTO sansin_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","පෞලස්තත්‍ර පුනර්බහුදිනානි න්‍යවසත්, තතෝ භ්‍රාතෘගණාද් විසර්ජනං ප්‍රාප්‍ය කිඤ්චනව්‍රතනිමිත්තං කිංක්‍රියානගරේ ශිරෝ මුණ්ඩයිත්වා ප්‍රිස්කිල්ලාක්කිලාභ්‍යාං සහිතෝ ජලපථේන සුරියාදේශං ගතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","තත ඉඵිෂනගර උපස්ථාය තත්‍ර තෞ විසෘජ්‍ය ස්වයං භජනභ්වනං ප්‍රවිශ්‍ය යිහූදීයෛඃ සහ විචාරිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","තේ ස්වෛඃ සාර්ද්ධං පුනඃ කතිපයදිනානි ස්ථාතුං තං ව්‍යනයන්, ස තදනුරරීකෘත්‍ය කථාමේතාං කථිතවාන්, ");
INSERT INTO sansin_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","යිරූශාලමි ආගාම්‍යුත්සවපාලනාර්ථං මයා ගමනීයං; පශ්චාද් ඊශ්වරේච්ඡායාං ජාතායාං යුෂ්මාකං සමීපං ප්‍රත්‍යාගමිෂ්‍යාමි| තතඃ පරං ස තෛ ර්විසෘෂ්ටඃ සන් ජලපථේන ඉඵිෂනගරාත් ප්‍රස්ථිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","තතඃ කෛසරියාම් උපස්ථිතඃ සන් නගරං ගත්වා සමාජං නමස්කෘත්‍ය තස්මාද් ආන්තියඛියානගරං ප්‍රස්ථිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","තත්‍ර කියත්කාලං යාපයිත්වා තස්මාත් ප්‍රස්ථාය සර්ව්වේෂාං ශිෂ්‍යාණාං මනාංසි සුස්ථිරාණි කෘත්වා ක්‍රමශෝ ගලාතියාඵ්‍රුගියාදේශයෝ ර්භ්‍රමිත්වා ගතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","තස්මින්නේව සමයේ සිකන්දරියානගරේ ජාත ආපල්ලෝනාමා ශාස්ත්‍රවිත් සුවක්තා යිහූදීය ඒකෝ ජන ඉඵිෂනගරම් ආගතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","ස ශික්‍ෂිතප්‍රභුමාර්ගෝ මනසෝද්‍යෝගී ච සන් යෝහනෝ මජ්ජනමාත්‍රං ඥාත්වා යථාර්ථතයා ප්‍රභෝඃ කථාං කථයන් සමුපාදිශත්| ");
INSERT INTO sansin_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ඒෂ ජනෝ නිර්භයත්වේන භජනභවනේ කථයිතුම් ආරබ්ධවාන්, තතඃ ප්‍රිස්කිල්ලාක්කිලෞ තස්‍යෝපදේශකථාං නිශම්‍ය තං ස්වයෝඃ සමීපම් ආනීය ශුද්ධරූපේණේශ්වරස්‍ය කථාම් අබෝධයතාම්| ");
INSERT INTO sansin_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","පශ්චාත් ස ආඛායාදේශං ගන්තුං මතිං කෘතවාන්, තදා තත්‍රත්‍යඃ ශිෂ්‍යගණෝ යථා තං ගෘහ්ලාති තදර්ථං භ්‍රාතෘගණේන සමාශ්වස්‍ය පත්‍රේ ලිඛිතේ සති, ආපල්ලාස්තත්‍රෝපස්ථිතඃ සන් අනුග්‍රහේණ ප්‍රත්‍යයිනාං බහූපකාරාන් අකරෝත්, ");
INSERT INTO sansin_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ඵලතෝ යීශුරභිෂික්තස්ත්‍රාතේති ශාස්ත්‍රප්‍රමාණං දත්වා ප්‍රකාශරූපේණ ප්‍රතිපන්නං කෘත්වා යිහූදීයාන් නිරුත්තරාන් කෘතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","කරින්ථනගර ආපල්ලසඃ ස්ථිතිකාලේ පෞල උත්තරප්‍රදේශෛරාගච්ඡන් ඉඵිෂනගරම් උපස්ථිතවාන්| තත්‍ර කතිපයශිෂ්‍යාන් සාක්‍ෂත් ප්‍රාප්‍ය තාන් අපෘච්ඡත්, ");
INSERT INTO sansin_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","යූයං විශ්වස්‍ය පවිත්‍රමාත්මානං ප්‍රාප්තා න වා? තතස්තේ ප්‍රත්‍යවදන් පවිත්‍ර ආත්මා දීයතේ ඉත්‍යස්මාභිඃ ශ්‍රුතමපි නහි| ");
INSERT INTO sansin_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","තදා සා(අ)වදත් තර්හි යූයං කේන මජ්ජිතා අභවත? තේ(අ)කථයන් යෝහනෝ මජ්ජනේන| ");
INSERT INTO sansin_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","තදා පෞල උක්තවාන් ඉතඃ පරං ය උපස්ථාස්‍යති තස්මින් අර්ථත යීශුඛ්‍රීෂ්ටේ විශ්වසිතව්‍යමිත්‍යුක්ත්වා යෝහන් මනඃපරිවර්ත්තනසූචකේන මජ්ජනේන ජලේ ලෝකාන් අමජ්ජයත්| ");
INSERT INTO sansin_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","තාදෘශීං කථාං ශ්‍රුත්වා තේ ප්‍රභෝ ර‍්‍යීශුඛ්‍රීෂ්ටස්‍ය නාම්නා මජ්ජිතා අභවන්| ");
INSERT INTO sansin_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","තතඃ පෞලේන තේෂාං ගාත්‍රේෂු කරේ(අ)ර්පිතේ තේෂාමුපරි පවිත්‍ර ආත්මාවරූඪවාන්, තස්මාත් තේ නානාදේශීයා භාෂා භවිෂ්‍යත්කථාශ්ච කථිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","තේ ප්‍රායේණ ද්වාදශජනා ආසන්| ");
INSERT INTO sansin_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","පෞලෝ භජනභවනං ගත්වා ප්‍රායේණ මාසත්‍රයම් ඊශ්වරස්‍ය රාජ්‍යස්‍ය විචාරං කෘත්වා ලෝකාන් ප්‍රවර්ත්‍ය සාහසේන කථාමකථයත්| ");
INSERT INTO sansin_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","කින්තු කඨිනාන්තඃකරණත්වාත් කියන්තෝ ජනා න විශ්වස්‍ය සර්ව්වේෂාං සමක්‍ෂම් ඒතත්පථස්‍ය නින්දාං කර්ත්තුං ප්‍රවෘත්තාඃ, අතඃ පෞලස්තේෂාං සමීපාත් ප්‍රස්ථාය ශිෂ්‍යගණං පෘථක්කෘත්වා ප්‍රත්‍යහං තුරාන්නනාම්නඃ කස්‍යචිත් ජනස්‍ය පාඨශාලායාං විචාරං කෘතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ඉත්ථං වත්සරද්වයං ගතං තස්මාද් ආශියාදේශනිවාසිනඃ සර්ව්වේ යිහූදීයා අන්‍යදේශීයලෝකාශ්ච ප්‍රභෝ ර‍්‍යීශෝඃ කථාම් අශ්‍රෞෂන්| ");
INSERT INTO sansin_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","පෞලේන ච ඊශ්වර ඒතාදෘශාන්‍යද්භුතානි කර්ම්මාණි කෘතවාන් ");
INSERT INTO sansin_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","යත් පරිධේයේ ගාත්‍රමාර්ජනවස්ත්‍රේ වා තස්‍ය දේහාත් පීඩිතලෝකානාම් සමීපම් ආනීතේ තේ නිරාමයා ජාතා අපවිත්‍රා භූතාශ්ච තේභ්‍යෝ බහිර්ගතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","තදා දේශාටනකාරිණඃ කියන්තෝ යිහූදීයා භූතාපසාරිණෝ භූතග්‍රස්තනෝකානාං සන්නිධෞ ප්‍රභේ ර‍්‍යීශෝ ර්නාම ජප්ත්වා වාක්‍යමිදම් අවදන්, යස්‍ය කථාං පෞලඃ ප්‍රචාරයති තස්‍ය යීශෝ ර්නාම්නා යුෂ්මාන් ආඥාපයාමඃ| ");
INSERT INTO sansin_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","ස්කිවනාම්නෝ යිහූදීයානාං ප්‍රධානයාජකස්‍ය සප්තභිඃ පුත්තෛස්තථා කෘතේ සති ");
INSERT INTO sansin_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","කශ්චිද් අපවිත්‍රෝ භූතඃ ප්‍රත්‍යුදිතවාන්, යීශුං ජානාමි පෞලඤ්ච පරිචිනෝමි කින්තු කේ යූයං? ");
INSERT INTO sansin_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ඉත්‍යුක්ත්වා සෝපවිත්‍රභූතග්‍රස්තෝ මනුෂ්‍යෝ ලම්ඵං කෘත්වා තේෂාමුපරි පතිත්වා බලේන තාන් ජිතවාන්, තස්මාත්තේ නග්නාඃ ක්‍ෂතාඞ්ගාශ්ච සන්තස්තස්මාද් ගේහාත් පලායන්ත| ");
INSERT INTO sansin_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","සා වාග් ඉඵිෂනගරනිවාසිනසං සර්ව්වේෂාං යිහූදීයානාං භින්නදේශීයානාං ලෝකානාඤ්ච ශ්‍රවෝගෝචරීභූතා; තතඃ සර්ව්වේ භයං ගතාඃ ප්‍රභෝ ර‍්‍යීශෝ ර්නාම්නෝ යශෝ (අ)වර්ද්ධත| ");
INSERT INTO sansin_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","යේෂාමනේකේෂාං ලෝකානාං ප්‍රතීතිරජායත ත ආගත්‍ය ස්වෛඃ කෘතාඃ ක්‍රියාඃ ප්‍රකාශරූපේණාඞ්ගීකෘතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","බහවෝ මායාකර්ම්මකාරිණඃ ස්වස්වග්‍රන්ථාන් ආනීය රාශීකෘත්‍ය සර්ව්වේෂාං සමක්‍ෂම් අදාහයන්, තතෝ ගණනාං කෘත්වාබුධ්‍යන්ත පඤ්චායුතරූප්‍යමුද්‍රාමූල්‍යපුස්තකානි දග්ධානි| ");
INSERT INTO sansin_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ඉත්ථං ප්‍රභෝඃ කථා සර්ව්වදේශං ව්‍යාප්‍ය ප්‍රබලා ජාතා| ");
INSERT INTO sansin_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","සර්ව්වේෂ්වේතේෂු කර්ම්මසු සම්පන්නේෂු සත්සු පෞලෝ මාකිදනියාඛායාදේශාභ්‍යාං යිරූශාලමං ගන්තුං මතිං කෘත්වා කථිතවාන් තත්ස්ථානං යාත්‍රායාං කෘතායාං සත්‍යාං මයා රෝමානගරං ද්‍රෂ්ටව්‍යං| ");
INSERT INTO sansin_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","ස්වානුගතලෝකානාං තීමථියේරාස්තෞ ද්වෞ ජනෞ මාකිදනියාදේශං ප්‍රති ප්‍රහිත්‍ය ස්වයම් ආශියාදේශේ කතිපයදිනානි ස්ථිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","කින්තු තස්මින් සමයේ මතේ(අ)ස්මින් කලහෝ ජාතඃ| ");
INSERT INTO sansin_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","තත්කාරණමිදං, අර්ත්තිමීදේව්‍යා රූප්‍යමන්දිරනිර්ම්මාණේන සර්ව්වේෂාං ශිල්පිනාං යථේෂ්ටලාභම් අජනයත් යෝ දීමීත්‍රියනාමා නාඩීන්ධමඃ ");
INSERT INTO sansin_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ස තාන් තත්කර්ම්මජීවිනඃ සර්ව්වලෝකාංශ්ච සමාහූය භාෂිතවාන් හේ මහේච්ඡා ඒතේන මන්දිරනිර්ම්මාණේනාස්මාකං ජීවිකා භවති, ඒතද් යූයං විත්ථ; ");
INSERT INTO sansin_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","කින්තු හස්තනිර්ම්මිතේශ්වරා ඊශ්වරා නහි පෞලනාම්නා කේනචිජ්ජනේන කථාමිමාං ව්‍යාහෘත්‍ය කේවලේඵිෂනගරේ නහි ප්‍රායේණ සර්ව්වස්මින් ආශියාදේශේ ප්‍රවෘත්තිං ග්‍රාහයිත්වා බහුලෝකානාං ශේමුෂී පරාවර්ත්තිතා, ඒතද් යුෂ්මාභි ර්දෘශ්‍යතේ ශ්‍රූයතේ ච| ");
INSERT INTO sansin_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","තේනාස්මාකං වාණිජ්‍යස්‍ය සර්ව්වථා හානේඃ සම්භවනං කේවලමිති නහි, ආශියාදේශස්ථෛ ර්වා සර්ව්වජගත්ස්ථෛ ර්ලෝකෛඃ පූජ්‍යා යාර්තිමී මහාදේවී තස්‍යා මන්දිරස්‍යාවඥානස්‍ය තස්‍යා ඓශ්වර‍්‍ය්‍යස්‍ය නාශස්‍ය ච සම්භාවනා විද්‍යතේे| ");
INSERT INTO sansin_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","ඒතාදෘශීං කථාං ශ්‍රුත්වා තේ මහාක්‍රෝධාන්විතාඃ සන්ත උච්චෛඃකාරං කථිතවන්ත ඉඵිෂීයානාම් අර්ත්තිමී දේවී මහතී භවති| ");
INSERT INTO sansin_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","තතඃ සර්ව්වනගරං කලහේන පරිපූර්ණමභවත්, තතඃ පරං තේ මාකිදනීයගායාරිස්තාර්ඛනාමානෞ පෞලස්‍ය ද්වෞ සහචරෞ ධෘත්වෛකචිත්තා රඞ්ගභූමිං ජවේන ධාවිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","තතඃ පෞලෝ ලෝකානාං සන්නිධිං යාතුම් උද්‍යතවාන් කින්තු ශිෂ්‍යගණස්තං වාරිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","පෞලස්‍යත්මීයා ආශියාදේශස්ථාඃ කතිපයාඃ ප්‍රධානලෝකාස්තස්‍ය සමීපං නරමේකං ප්‍රේෂ්‍ය ත්වං රඞ්ගභූමිං මාගා ඉති න්‍යවේදයන්| ");
INSERT INTO sansin_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","තතෝ නානාලෝකානාං නානාකථාකථනාත් සභා ව්‍යාකුලා ජාතා කිං කාරණාද් ඒතාවතී ජනතාභවත් ඒතද් අධිකෛ ර්ලෝකෛ ර්නාඥායි| ");
INSERT INTO sansin_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","තතඃ පරං ජනතාමධ්‍යාද් යිහූදීයෛර්බහිෂ්කෘතඃ සිකන්දරෝ හස්තේන සඞ්කේතං කෘත්වා ලෝකේභ්‍ය උත්තරං දාතුමුද්‍යතවාන්, ");
INSERT INTO sansin_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","කින්තු ස යිහූදීයලෝක ඉති නිශ්චිතේ සති ඉඵිෂීයානාම් අර්ත්තිමී දේවී මහතීති වාක්‍යං ප්‍රායේණ පඤ්ච දණ්ඩාන් යාවද් ඒකස්වරේණ ලෝකනිවහෛඃ ප්‍රෝක්තං| ");
INSERT INTO sansin_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","තතෝ නගරාධිපතිස්තාන් ස්ථිරාන් කෘත්වා කථිතවාන් හේ ඉඵිෂායාඃ සර්ව්වේ ලෝකා ආකර්ණයත, අර්තිමීමහාදේව්‍යා මහාදේවාත් පතිතායාස්තත්ප්‍රතිමායාශ්ච පූජනම ඉඵිෂනගරස්ථාඃ සර්ව්වේ ලෝකාඃ කුර්ව්වන්ති, ඒතත් කේ න ජානන්ති? ");
INSERT INTO sansin_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","තස්මාද් ඒතත්ප්‍රතිකූලං කේපි කථයිතුං න ශක්නුවන්ති, ඉති ඥාත්වා යුෂ්මාභිඃ සුස්ථිරත්වේන ස්ථාතව්‍යම් අවිවිච්‍ය කිමපි කර්ම්ම න කර්ත්තව්‍යඤ්ච| ");
INSERT INTO sansin_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","යාන් ඒතාන් මනුෂ්‍යාන් යූයමත්‍ර සමානයත තේ මන්දිරද්‍රව්‍යාපහාරකා යුෂ්මාකං දේව්‍යා නින්දකාශ්ච න භවන්ති| ");
INSERT INTO sansin_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","යදි කඤ්චන ප්‍රති දීමීත්‍රියස්‍ය තස්‍ය සහායානාඤ්ච කාචිද් ආපත්ති ර්විද්‍යතේ තර්හි ප්‍රතිනිධිලෝකා විචාරස්ථානඤ්ච සන්ති, තේ තත් ස්ථානං ගත්වා උත්තරප්‍රත්‍යුත්තරේ කුර්ව්වන්තු| ");
INSERT INTO sansin_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","කින්තු යුෂ්මාකං කාචිදපරා කථා යදි තිෂ්ඨති තර්හි නියමිතායාං සභායාං තස්‍යා නිෂ්පත්ති ර්භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","කින්ත්වේතස්‍ය විරෝධස්‍යෝත්තරං යේන දාතුං ශක්නුම් ඒතාදෘශස්‍ය කස්‍යචිත් කාරණස්‍යාභාවාද් අද්‍යතනඝටනාහේතෝ රාජද්‍රෝහිණාමිවාස්මාකම් අභියෝගෝ භවිෂ්‍යතීති ශඞ්කා විද්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","ඉති කථයිත්වා ස සභාස්ථලෝකාන් විසෘෂ්ටවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ඉත්ථං කලහේ නිවෘත්තේ සති පෞලඃ ශිෂ්‍යගණම් ආහූය විසර්ජනං ප්‍රාප්‍ය මාකිදනියාදේශං ප්‍රස්ථිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","තේන ස්ථානේන ගච්ඡන් තද්දේශීයාන් ශිෂ්‍යාන් බහූපදිශ්‍ය යූනානීයදේශම් උපස්ථිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","තත්‍ර මාසත්‍රයං ස්ථිත්වා තස්මාත් සුරියාදේශං යාතුම් උද්‍යතඃ, කින්තු යිහූදීයාස්තං හන්තුං ගුප්තා අතිෂ්ඨන් තස්මාත් ස පුනරපි මාකිදනියාමාර්ගේණ ප්‍රත්‍යාගන්තුං මතිං කෘතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","බිරයානගරීයසෝපාත්‍රඃ ථිෂලනීකීයාරිස්තාර්ඛසිකුන්දෞ දර්බ්බෝනගරීයගායතීමථියෞ ආශියාදේශීයතුඛිකත්‍රඵිමෞ ච තේන සාර්ද්ධං ආශියාදේශං යාවද් ගතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ඒතේ සර්ව්වේ (අ)ග්‍රසරාඃ සන්තෝ (අ)ස්මාන් අපේක්‍ෂ්‍ය ත්‍රෝයානගරේ ස්ථිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","කිණ්වශූන්‍යපූපෝත්සවදිනේ ච ගතේ සති වයං ඵිලිපීනගරාත් තෝයපථේන ගත්වා පඤ්චභි ර්දිනෛස්ත්‍රෝයානගරම් උපස්ථාය තත්‍ර සප්තදිනාන්‍යවාතිෂ්ඨාම| ");
INSERT INTO sansin_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","සප්තාහස්‍ය ප්‍රථමදිනේ පූපාන් භංක්තු ශිෂ්‍යේෂු මිලිතේෂු පෞලඃ පරදිනේ තස්මාත් ප්‍රස්ථාතුම් උද්‍යතඃ සන් තදහ්නි ප්‍රායේණ ක්‍ෂපායා යාමද්වයං යාවත් ශිෂ්‍යේභ්‍යෝ ධර්ම්මකථාම් අකථයත්| ");
INSERT INTO sansin_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","උපරිස්ථේ යස්මින් ප්‍රකෝෂ්ඨේ සභාං කෘත්වාසන් තත්‍ර බහවඃ ප්‍රදීපාඃ ප්‍රාජ්වලන්| ");
INSERT INTO sansin_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","උතුඛනාමා කශ්චන යුවා ච වාතායන උපවිශන් ඝෝරතරනිද්‍රාග්‍රස්තෝ (අ)භූත් තදා පෞලේන බහුක්‍ෂණං කථායාං ප්‍රචාරිතායාං නිද්‍රාමග්නඃ ස තස්මාද් උපරිස්ථතෘතීයප්‍රකෝෂ්ඨාද් අපතත්, තතෝ ලෝකාස්තං මෘතකල්පං ධෘත්වෝදතෝලයන්| ");
INSERT INTO sansin_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","තතඃ පෞලෝ(අ)වරුහ්‍ය තස්‍ය ගාත්‍රේ පතිත්වා තං ක්‍රෝඩේ නිධාය කථිතවාන්, යූයං ව්‍යාකුලා මා භූත නායං ප්‍රාණෛ ර්වියුක්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","පශ්චාත් ස පුනශ්චෝපරි ගත්වා පූපාන් භංක්ත්වා ප්‍රභාතං යාවත් කථෝපකථනේ කෘත්වා ප්‍රස්ථිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","තේ ච තං ජීවන්තං යුවානං ගෘහීත්වා ගත්වා පරමාප්‍යායිතා ජාතාඃ| ");
INSERT INTO sansin_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","අනන්තරං වයං පෝතේනාග්‍රසරා භූත්වාස්මනගරම් උත්තීර‍්‍ය්‍ය පෞලං ග්‍රහීතුං මතිම් අකුර්ම්ම යතඃ ස තත්‍ර පද්භ්‍යාං ව්‍රජිතුං මතිං කෘත්වේති නිරූපිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","තස්මාත් තත්‍රාස්මාභිඃ සාර්ද්ධං තස්මින් මිලිතේ සති වයං තං නීත්වා මිතුලීන්‍යුපද්වීපං ප්‍රාප්තවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","තස්මාත් පෝතං මෝචයිත්වා පරේ(අ)හනි ඛීයෝපද්වීපස්‍ය සම්මුඛං ලබ්ධවන්තස්තස්මාද් ඒකේනාහ්නා සාමෝපද්වීපං ගත්වා පෝතං ලාගයිත්වා ත්‍රෝගුල්ලියේ ස්ථිත්වා පරස්මින් දිවසේे මිලීතනගරම් උපාතිෂ්ඨාම| ");
INSERT INTO sansin_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","යතඃ පෞල ආශියාදේශේ කාලං යාපයිතුම් නාභිලෂන් ඉඵිෂනගරං ත්‍යක්ත්වා යාතුං මන්ත්‍රණාං ස්ථිරීකෘතවාන්; යස්මාද් යදි සාධ්‍යං භවති තර්හි නිස්තාරෝත්සවස්‍ය පඤ්චාශත්තමදිනේ ස යිරූශාලම්‍යුපස්ථාතුං මතිං කෘතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","පෞලෝ මිලීතාද් ඉඵිෂං ප්‍රති ලෝකං ප්‍රහිත්‍ය සමාජස්‍ය ප්‍රාචීනාන් ආහූයානීතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","තේෂු තස්‍ය සමීපම් උපස්ථිතේෂු ස තේභ්‍ය ඉමාං කථාං කථිතවාන්, අහම් ආශියාදේශේ ප්‍රථමාගමනම් ආරභ්‍යාද්‍ය යාවද් යුෂ්මාකං සන්නිධෞ ස්ථිත්වා සර්ව්වසමයේ යථාචරිතවාන් තද් යූයං ජානීථ; ");
INSERT INTO sansin_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ඵලතඃ සර්ව්වථා නම්‍රමනාඃ සන් බහුශ්‍රුපාතේන යිහුදීයානාම් කුමන්ත්‍රණාජාතනානාපරීක්‍ෂාභිඃ ප්‍රභෝඃ සේවාමකරවං| ");
INSERT INTO sansin_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","කාමපි හිතකථාाං න ගෝපායිතවාන් තාං ප්‍රචාර‍්‍ය්‍ය සප්‍රකාශං ගෘහේ ගෘහේ සමුපදිශ්‍යේශ්වරං ප්‍රති මනඃ පරාවර්ත්තනීයං ප්‍රභෞ යීශුඛ්‍රීෂ්ටේ විශ්වසනීයං ");
INSERT INTO sansin_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","යිහූදීයානාම් අන්‍යදේශීයලෝකානාඤ්ච සමීප ඒතාදෘශං සාක්‍ෂ්‍යං දදාමි| ");
INSERT INTO sansin_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","පශ්‍යත සාම්ප්‍රතම් ආත්මනාකෘෂ්ටඃ සන් යිරූශාලම්නගරේ යාත්‍රාං කරෝමි, තත්‍ර මාම්ප්‍රති යද්‍යද් ඝටිෂ්‍යතේ තාන්‍යහං න ජානාමි; ");
INSERT INTO sansin_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","කින්තු මයා බන්ධනං ක්ලේශශ්ච භෝක්තව්‍ය ඉති පවිත්‍ර ආත්මා නගරේ නගරේ ප්‍රමාණං දදාති| ");
INSERT INTO sansin_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","තථාපි තං ක්ලේශමහං තෘණාය න මන්‍යේ; ඊශ්වරස්‍යානුග්‍රහවිෂයකස්‍ය සුසංවාදස්‍ය ප්‍රමාණං දාතුං, ප්‍රභෝ ර‍්‍යීශෝඃ සකාශාද යස්‍යාඃ සේවායාඃ භාරං ප්‍රාප්නවං තාං සේවාං සාධයිතුං සානන්දං ස්වමාර්ගං සමාපයිතුुඤ්ච නිජප්‍රාණානපි ප්‍රියාන් න මන්‍යේ| ");
INSERT INTO sansin_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","අධුනා පශ්‍යත යේෂාං සමීපේ(අ)හම් ඊශ්වරීයරාජ්‍යස්‍ය සුසංවාදං ප්‍රචාර‍්‍ය්‍ය භ්‍රමණං කෘතවාන් ඒතාදෘශා යූයං මම වදනං පුන ර්ද්‍රෂ්ටුං න ප්‍රාප්ස්‍යථ ඒතදප්‍යහං ජානාමි| ");
INSERT INTO sansin_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","යුෂ්මභ්‍යම් අහම් ඊශ්වරස්‍ය සර්ව්වාන් ආදේශාන් ප්‍රකාශයිතුං න න්‍යවර්ත්තේ| ");
INSERT INTO sansin_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","අහං සර්ව්වේෂාං ලෝකානාං රක්තපාතදෝෂාද් යන්නිර්දෝෂ ආසේ තස්‍යාද්‍ය යුෂ්මාන් සාක්‍ෂිණඃ කරෝමි| ");
INSERT INTO sansin_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","යූයං ස්වේෂු තථා යස්‍ය ව්‍රජස්‍යාධ්‍යක්‍ෂන් ආත්මා යුෂ්මාන් විධාය න්‍යයුඞ්ක්ත තත්සර්ව්වස්මින් සාවධානා භවත, ය සමාජඤ්ච ප්‍රභු ර්නිජරක්තමූල්‍යේන ක්‍රීතවාන තම් අවත, ");
INSERT INTO sansin_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","යතෝ මයා ගමනේ කෘතඒව දුර්ජයා වෘකා යුෂ්මාකං මධ්‍යං ප්‍රවිශ්‍ය ව්‍රජං ප්‍රති නිර්දයතාම් ආචරිෂ්‍යන්ති, ");
INSERT INTO sansin_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","යුෂ්මාකමේව මධ්‍යාදපි ලෝකා උත්ථාය ශිෂ්‍යගණම් අපහන්තුං විපරීතම් උපදේක්‍ෂ්‍යන්තීත්‍යහං ජානාමි| ");
INSERT INTO sansin_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","ඉති හේතෝ ර‍්‍යූයං සචෛතන්‍යාඃ සන්තස්තිෂ්ටත, අහඤ්ච සාශ්‍රුපාතඃ සන් වත්සරත්‍රයං යාවද් දිවානිශං ප්‍රතිජනං බෝධයිතුං න න්‍යවර්ත්තේ තදපි ස්මරත| ");
INSERT INTO sansin_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","ඉදානීං හේ භ්‍රාතරෝ යුෂ්මාකං නිෂ්ඨාං ජනයිතුං පවිත්‍රීකෘතලෝකානාං මධ්‍යේ(අ)ධිකාරඤ්ච දාතුං සමර්ථෝ ය ඊශ්වරස්තස්‍යානුග්‍රහස්‍ය යෝ වාදශ්ච තයෝරුභයෝ ර‍්‍යුෂ්මාන් සමාර්පයම්| ");
INSERT INTO sansin_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","කස්‍යාපි ස්වර්ණං රූප්‍යං වස්ත්‍රං වා ප්‍රති මයා ලෝභෝ න කෘතඃ| ");
INSERT INTO sansin_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","කින්තු මම මත්සහචරලෝකානාඤ්චාවශ්‍යකව්‍යයාය මදීයමිදං කරද්වයම් අශ්‍රාම්‍යද් ඒතද් යූයං ජානීථ| ");
INSERT INTO sansin_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","අනේන ප්‍රකාරේණ ග්‍රහණද් දානං භද්‍රමිති යද්වාක්‍යං ප්‍රභු ර‍්‍යීශුඃ කථිතවාන් තත් ස්මර්ත්තුං දරිද්‍රලෝකානාමුපකාරාර්ථං ශ්‍රමං කර්ත්තුඤ්ච යුෂ්මාකම් උචිතම් ඒතත්සර්ව්වං යුෂ්මානහම් උපදිෂ්ටවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ඒතාං කථාං කථයිත්වා ස ජානුනී පාතයිත්වා සර්වෛඃ සහ ප්‍රාර්ථයත| ");
INSERT INTO sansin_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","තේන තේ ක්‍රන්ද්‍රන්තඃ ");
INSERT INTO sansin_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","පුන ර්මම මුඛං න ද්‍රක්‍ෂ්‍යථ විශේෂත ඒෂා යා කථා තේනාකථි තත්කාරණාත් ශෝකං විලාපඤ්ච කෘත්වා කණ්ඨං ධෘත්වා චුම්බිතවන්තඃ| පශ්චාත් තේ තං පෝතං නීතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","තෛ ර්විසෘෂ්ටාඃ සන්තෝ වයං පෝතං බාහයිත්වා ඍජුමාර්ගේණ කෝෂම් උපද්වීපම් ආගත්‍ය පරේ(අ)හනි රෝදියෝපද්වීපම් ආගච්ඡාම තතස්තස්මාත් පාතාරායාම් උපාතිෂ්ඨාම| ");
INSERT INTO sansin_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","තත්‍ර ඵෛනීකියාදේශගාමිනම් පෝතමේකං ප්‍රාප්‍ය තමාරුහ්‍ය ගතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","කුප්‍රෝපද්වීපං දෘෂ්ට්වා තං සව්‍යදිශි ස්ථාපයිත්වා සුරියාදේශං ගත්වා පෝතස්ථද්‍රව්‍යාණ්‍යවරෝහයිතුං සෝරනගරේ ලාගිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","තත්‍ර ශිෂ්‍යගණස්‍ය සාක්‍ෂාත්කරණාය වයං තත්‍ර සප්තදිනානි ස්ථිතවන්තඃ පශ්චාත්තේ පවිත්‍රේණාත්මනා පෞලං ව්‍යාහරන් ත්වං යිරූශාලම්නගරං මා ගමඃ| ");
INSERT INTO sansin_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","තතස්තේෂු සප්තසු දිනේෂු යාපිතේෂු සත්සු වයං තස්මාත් ස්ථානාත් නිජවර්ත්මනා ගතවන්තඃ, තස්මාත් තේ සබාලවෘද්ධවනිතා අස්මාභිඃ සහ නගරස්‍ය පරිසරපර‍්‍ය්‍යන්තම් ආගතාඃ පශ්චාද්වයං ජලධිතටේ ජානුපාතං ප්‍රාර්ථයාමහි| ");
INSERT INTO sansin_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","තතඃ පරස්පරං විසෘෂ්ටාඃ සන්තෝ වයං පෝතං ගතාස්තේ තු ස්වස්වගෘහං ප්‍රත්‍යාගතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","වයං සෝරනගරාත් නාවා ප්‍රස්ථාය තලිමායිනගරම් උපාතිෂ්ඨාම තත්‍රාස්මාකං සමුද්‍රීයමාර්ගස්‍යාන්තෝ(අ)භවත් තත්‍ර භ්‍රාතෘගණං නමස්කෘත්‍ය දිනමේකං තෛඃ සාර්ද්ධම් උෂතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","පරේ (අ)හනි පෞලස්තස්‍ය සඞ්ගිනෝ වයඤ්ච ප්‍රතිෂ්ඨමානාඃ කෛසරියානගරම් ආගත්‍ය සුසංවාදප්‍රචාරකානාං සප්තජනානාං ඵිලිපනාම්න ඒකස්‍ය ගෘහං ප්‍රවිශ්‍යාවතිෂ්ඨාම| ");
INSERT INTO sansin_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","තස්‍ය චතස්‍රෝ දුහිතරෝ(අ)නූඪා භවිෂ්‍යද්වාදින්‍ය ආසන්| ");
INSERT INTO sansin_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","තත්‍රාස්මාසු බහුදිනානි ප්‍රෝෂිතේෂු යිහූදීයදේශාද් ආගත්‍යාගාබනාමා භවිෂ්‍යද්වාදී සමුපස්ථිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","සෝස්මාකං සමීපමේත්‍ය පෞලස්‍ය කටිබන්ධනං ගෘහීත්වා නිජහස්තාපාදාන් බද්ධ්වා භාෂිතවාන් යස්‍යේදං කටිබන්ධනං තං යිහූදීයලෝකා යිරූශාලමනගර ඉත්ථං බද්ධ්වා භින්නදේශීයානාං කරේෂු සමර්පයිෂ්‍යන්තීති වාක්‍යං පවිත්‍ර ආත්මා කථයති| ");
INSERT INTO sansin_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ඒතාදෘශීං කථාං ශ්‍රුත්වා වයං තන්නගරවාසිනෝ භ්‍රාතරශ්ච යිරූශාලමං න යාතුං පෞලං ව්‍යනයාමහි; ");
INSERT INTO sansin_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","කින්තු ස ප්‍රත්‍යාවාදීත්, යූයං කිං කුරුථ? කිං ක්‍රන්දනේන මමාන්තඃකරණං විදීර්ණං කරිෂ්‍යථ? ප්‍රභෝ ර‍්‍යීශෝ ර්නාම්නෝ නිමිත්තං යිරූශාලමි බද්ධෝ භවිතුං කේවල තන්න ප්‍රාණාන් දාතුමපි සසජ්ජෝස්මි| ");
INSERT INTO sansin_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","තේනාස්මාකං කථායාම් අගෘහීතායාම් ඊශ්වරස්‍ය යථේච්ඡා තථෛව භවත්විත්‍යුක්ත්වා වයං නිරස්‍යාම| ");
INSERT INTO sansin_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","පරේ(අ)හනි පාථේයද්‍රව්‍යාණි ගෘහීත්වා යිරූශාලමං ප්‍රති යාත්‍රාම් අකුර්ම්ම| ");
INSERT INTO sansin_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","තතඃ කෛසරියානගරනිවාසිනඃ කතිපයාඃ ශිෂ්‍යා අස්මාභිඃ සාර්ද්ධම් ඉත්වා කෘප්‍රීයේන ම්නාසන්නාම්නා යේන ප්‍රාචීනශිෂ්‍යේන සාර්ද්ධම් අස්මාභි ර්වස්තව්‍යං තස්‍ය සමීපම් අස්මාන් නීතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","අස්මාසු යිරූශාලම්‍යුපස්ථිතේෂු තත්‍රස්ථභ්‍රාතෘගණෝ(අ)ස්මාන් ආහ්ලාදේන ගෘහීතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","පරස්මින් දිවසේ පෞලේ(අ)ස්මාභිඃ සහ යාකූබෝ ගෘහං ප්‍රවිෂ්ටේ ලෝකප්‍රාචීනාඃ සර්ව්වේ තත්‍ර පරිෂදි සංස්ථිතාඃ| ");
INSERT INTO sansin_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","අනන්තරං ස තාන් නත්වා ස්වීයප්‍රචාරණේන භින්නදේශීයාන් ප්‍රතීශ්වරෝ යානි කර්ම්මාණි සාධිතවාන් තදීයාං කථාම් අනුක්‍රමාත් කථිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ඉති ශ්‍රුත්වා තේ ප්‍රභුං ධන්‍යං ප්‍රෝච්‍ය වාක්‍යමිදම් අභාෂන්ත, හේ භ්‍රාත ර‍්‍යිහූදීයානාං මධ්‍යේ බහුසහස්‍රාණි ලෝකා විශ්වාසින ආසතේ කින්තු තේ සර්ව්වේ ව්‍යවස්ථාමතාචාරිණ ඒතත් ප්‍රත්‍යක්‍ෂං පශ්‍යසි| ");
INSERT INTO sansin_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","ශිශූනාං ත්වක්ඡේදනාද්‍යාචරණං ප්‍රතිෂිධ්‍ය ත්වං භින්නදේශනිවාසිනෝ යිහූදීයලෝකාන් මූසාවාක්‍යම් අශ්‍රද්ධාතුම් උපදිශසීති තෛඃ ශ්‍රුතමස්ති| ");
INSERT INTO sansin_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","ත්වමත්‍රාගතෝසීති වාර්ත්තාං සමාකර්ණ්‍ය ජනනිවහෝ මිලිත්වාවශ්‍යමේවාගමිෂ්‍යති; අතඒව කිං කරණීයම්? අත්‍ර වයං මන්ත්‍රයිත්වා සමුපායං ත්වාං වදාමස්තං ත්වමාචර| ");
INSERT INTO sansin_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","ව්‍රතං කර්ත්තුං කෘතසඞ්කල්පා යේ(අ)ස්මාංක චත්වාරෝ මානවාඃ සන්ති ");
INSERT INTO sansin_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","තාන් ගෘහීත්වා තෛඃ සහිතඃ ස්වං ශුචිං කුරු තථා තේෂාං ශිරෝමුණ්ඩනේ යෝ ව්‍යයෝ භවති තං ත්වං දේහි| තථා කෘතේ ත්වදීයාචාරේ යා ජනශ්‍රුති ර්ජායතේ සාලීකා කින්තු ත්වං විධිං පාලයන් ව්‍යවස්ථානුසාරේණේවාචරසීති තේ භෝත්සන්තේ| ");
INSERT INTO sansin_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","භින්නදේශීයානාං විශ්වාසිලෝකානාං නිකටේ වයං පත්‍රං ලිඛිත්වේත්ථං ස්ථිරීකෘතවන්තඃ, දේවප්‍රසාදභෝජනං රක්තං ගලපීඩනමාරිතප්‍රාණිභෝජනං ව්‍යභිචාරශ්චෛතේභ්‍යඃ ස්වරක්‍ෂණව්‍යතිරේකේණ තේෂාමන්‍යවිධිපාලනං කරණීයං න| ");
INSERT INTO sansin_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","තතඃ පෞලස්තාන් මානුෂානාදාය පරස්මින් දිවසේ තෛඃ සහ ශුචි ර්භූත්වා මන්දිරං ගත්වා ශෞචකර්ම්මණෝ දිනේෂු සම්පූර්ණේෂු තේෂාම් ඒකෛකාර්ථං නෛවේද්‍යාද්‍යුත්සර්ගෝ භවිෂ්‍යතීති ඥාපිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","තේෂු සප්තසු දිනේෂු සමාප්තකල්පේෂු ආශියාදේශනිවාසිනෝ යිහූදීයාස්තං මධ්‍යේමන්දිරං විලෝක්‍ය ජනනිවහස්‍ය මනඃසු කුප්‍රවෘත්තිං ජනයිත්වා තං ධෘත්වා ");
INSERT INTO sansin_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ප්‍රෝච්චෛඃ ප්‍රාවෝචන්, හේ ඉස්‍රායේල්ලෝකාඃ සර්ව්වේ සාහාය්‍යං කුරුත| යෝ මනුජ ඒතේෂාං ලෝකානාං මූසාව්‍යවස්ථායා ඒතස්‍ය ස්ථානස්‍යාපි විපරීතං සර්ව්වත්‍ර සර්ව්වාන් ශික්‍ෂයති ස ඒෂඃ; විශේෂතඃ ස භින්නදේශීයලෝකාන් මන්දිරම් ආනීය පවිත්‍රස්ථානමේතද් අපවිත්‍රමකරෝත්| ");
INSERT INTO sansin_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","පූර්ව්වං තේ මධ්‍යේනගරම් ඉඵිෂනගරීයං ත්‍රඵිමං පෞලේන සහිතං දෘෂ්ටවන්ත ඒතස්මාත් පෞලස්තං මන්දිරමධ්‍යම් ආනයද් ඉත්‍යන්වමිමත| ");
INSERT INTO sansin_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","අතඒව සර්ව්වස්මින් නගරේ කලහෝත්පන්නත්වාත් ධාවන්තෝ ලෝකා ආගත්‍ය පෞලං ධෘත්වා මන්දිරස්‍ය බහිරාකෘෂ්‍යානයන් තත්ක්‍ෂණාද් ද්වාරාණි සර්ව්වාණි ච රුද්ධානි| ");
INSERT INTO sansin_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","තේෂු තං හන්තුමුද්‍යතේेෂු යිරූශාලම්නගරේ මහානුපද්‍රවෝ ජාත ඉති වාර්ත්තායාං සහස්‍රසේනාපතේඃ කර්ණගෝචරීභූතායාං සත්‍යාං ස තත්ක්‍ෂණාත් සෛන්‍යානි සේනාපතිගණඤ්ච ගෘහීත්වා ජවේනාගතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","තතෝ ලෝකාඃ සේනාගණේන සහ සහස්‍රසේනාපතිම් ආගච්ඡන්තං දෘෂ්ට්වා පෞලතාඩනාතෝ න්‍යවර්ත්තන්ත| ");
INSERT INTO sansin_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","ස සහස්‍රසේනාපතිඃ සන්නිධාවාගම්‍ය පෞලං ධෘත්වා ශෘඞ්ඛලද්වයේන බද්ධම් ආදිශ්‍ය තාන් පෘෂ්ටවාන් ඒෂ කඃ? කිං කර්ම්ම චායං කෘතවාන්? ");
INSERT INTO sansin_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","තතෝ ජනසමූහස්‍ය කශ්චිද් ඒකප්‍රකාරං කශ්චිද් අන්‍යප්‍රකාරං වාක්‍යම් අරෞත් ස තත්‍ර සත්‍යං ඥාතුම් කලහකාරණාද් අශක්තඃ සන් තං දුර්ගං නේතුම් ආඥාපයත්| ");
INSERT INTO sansin_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","තේෂු සෝපානස්‍යෝපරි ප්‍රාප්තේෂු ලෝකානාං සාහසකාරණාත් සේනාගණඃ පෞලමුත්තෝල්‍ය නීතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","තතඃ සර්ව්වේ ලෝකාඃ පශ්චාද්ගාමිනඃ සන්ත ඒනං දුරීකුරුතේති වාක්‍යම් උච්චෛරවදන්| ");
INSERT INTO sansin_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","පෞලස්‍ය දුර්ගානයනසමයේ ස තස්මෛ සහස්‍රසේනාපතයේ කථිතවාන්, භවතඃ පුරස්තාත් කථාං කථයිතුං කිම් අනුමන්‍යතේ? ස තමපෘච්ඡත් ත්වං කිං යූනානීයාං භාෂාං ජානාසි? ");
INSERT INTO sansin_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","යෝ මිසරීයෝ ජනඃ පූර්ව්වං විරෝධං කෘත්වා චත්වාරි සහස්‍රාණි ඝාතකාන් සඞ්ගිනඃ කෘත්වා විපිනං ගතවාන් ත්වං කිං සඒව න භවසි? ");
INSERT INTO sansin_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","තදා පෞලෝ(අ)කථයත් අහං කිලිකියාදේශස්‍ය තාර්ෂනගරීයෝ යිහූදීයෝ, නාහං සාමාන්‍යනගරීයෝ මානවඃ; අතඒව විනයේ(අ)හං ලාකානාං සමක්‍ෂං කථාං කථයිතුං මාමනුජානීෂ්ව| ");
INSERT INTO sansin_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","තේනානුඥාතඃ පෞලඃ සෝපානෝපරි තිෂ්ඨන් හස්තේනේඞ්ගිතං කෘතවාන්, තස්මාත් සර්ව්වේ සුස්ථිරා අභවන්| තදා පෞල ඉබ්‍රීයභාෂයා කථයිතුම් ආරභත, ");
INSERT INTO sansin_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","හේ පිතෘගණා හේ භ්‍රාතෘගණාඃ, ඉදානීං මම නිවේදනේ සමවධත්ත| ");
INSERT INTO sansin_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","තදා ස ඉබ්‍රීයභාෂයා කථාං කථයතීති ශ්‍රුත්වා සර්ව්වේ ලෝකා අතීව නිඃශබ්දා සන්තෝ(අ)තිෂ්ඨන්| ");
INSERT INTO sansin_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","පශ්චාත් සෝ(අ)කථයද් අහං යිහූදීය ඉති නිශ්චයඃ කිලිකියාදේශස්‍ය තාර්ෂනගරං මම ජන්මභූමිඃ,ඒතන්නගරීයස්‍ය ගමිලීයේලනාම්නෝ(අ)ධ්‍යාපකස්‍ය ශිෂ්‍යෝ භූත්වා පූර්ව්වපුරුෂාණාං විධිව්‍යවස්ථානුසාරේණ සම්පූර්ණරූපේණ ශික්‍ෂිතෝ(අ)භවම් ඉදානීන්තනා යූයං යාදෘශා භවථ තාදෘශෝ(අ)හමපීශ්වරසේවායාම් උද්‍යෝගී ජාතඃ| ");
INSERT INTO sansin_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","මතමේතද් ද්විෂ්ට්වා තද්ග්‍රාහිනාරීපුරුෂාන් කාරායාං බද්ධ්වා තේෂාං ප්‍රාණනාශපර‍්‍ය්‍යන්තාං විපක්‍ෂතාම් අකරවම්| ");
INSERT INTO sansin_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","මහායාජකඃ සභාසදඃ ප්‍රාචීනලෝකාශ්ච මමෛතස්‍යාඃ කථායාඃ ප්‍රමාණං දාතුං ශක්නුවන්ති, යස්මාත් තේෂාං සමීපාද් දම්මේෂකනගරනිවාසිභ්‍රාතෘගණාර්ථම් ආඥාපත්‍රාණි ගෘහීත්වා යේ තත්‍ර ස්ථිතාස්තාන් දණ්ඩයිතුං යිරූශාලමම් ආනයනාර්ථං දම්මේෂකනගරං ගතෝස්මි| ");
INSERT INTO sansin_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","කින්තු ගච්ඡන් තන්නගරස්‍ය සමීපං ප්‍රාප්තවාන් තදා ද්විතීයප්‍රහරවේලායාං සත්‍යාම් අකස්මාද් ගගණාන්නිර්ගත්‍ය මහතී දීප්ති ර්මම චතුර්දිශි ප්‍රකාශිතවතී| ");
INSERT INTO sansin_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","තතෝ මයි භූමෞै පතිතේ සති, හේ ශෞල හේ ශෞල කුතෝ මාං තාඩයසි? මාම්ප්‍රති භාෂිත ඒතාදෘශ ඒකෝ රවෝපි මයා ශ්‍රුතඃ| ");
INSERT INTO sansin_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","තදාහං ප්‍රත්‍යවදං, හේ ප්‍රභේ කෝ භවාන්? තතඃ සෝ(අ)වාදීත් යං ත්වං තාඩයසි ස නාසරතීයෝ යීශුරහං| ");
INSERT INTO sansin_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","මම සඞ්ගිනෝ ලෝකාස්තාං දීප්තිං දෘෂ්ට්වා භියං ප්‍රාප්තාඃ, කින්තු මාම්ප්‍රත්‍යුදිතං තද්වාක්‍යං තේे නාබුධ්‍යන්ත| ");
INSERT INTO sansin_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","තතඃ පරං පෘෂ්ටවානහං, හේ ප්‍රභෝ මයා කිං කර්ත්තව්‍යං? තතඃ ප්‍රභුරකථයත්, උත්ථාය දම්මේෂකනගරං යාහි ත්වයා යද්‍යත් කර්ත්තව්‍යං නිරූපිතමාස්තේ තත් තත්‍ර ත්වං ඥාපයිෂ්‍යසේ| ");
INSERT INTO sansin_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","අනන්තරං තස්‍යාඃ ඛරතරදීප්තේඃ කාරණාත් කිමපි න දෘෂ්ට්වා සඞ්ගිගණේන ධෘතහස්තඃ සන් දම්මේෂකනගරං ව්‍රජිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","තන්නගරනිවාසිනාං සර්ව්වේෂාං යිහූදීයානාං මාන්‍යෝ ව්‍යවස්ථානුසාරේණ භක්තශ්ච හනානීයනාමා මානව ඒකෝ ");
INSERT INTO sansin_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","මම සන්නිධිම් ඒත්‍ය තිෂ්ඨන් අකථයත්, හේ භ්‍රාතඃ ශෞල සුදෘෂ්ටි ර්භව තස්මින් දණ්ඩේ(අ)හං සම්‍යක් තං දෘෂ්ටවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","තතඃ ස මහ්‍යං කථිතවාන් යථා ත්වම් ඊශ්වරස්‍යාභිප්‍රායං වේත්සි තස්‍ය ශුද්ධසත්ත්වජනස්‍ය දර්ශනං ප්‍රාප්‍ය තස්‍ය ශ්‍රීමුඛස්‍ය වාක්‍යං ශෘණෝෂි තන්නිමිත්තම් අස්මාකං පූර්ව්වපුරුෂාණාම් ඊශ්වරස්ත්වාං මනෝනීතං කෘතවානං| ");
INSERT INTO sansin_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","යතෝ යද්‍යද් අද්‍රාක්‍ෂීරශ්‍රෞෂීශ්ච සර්ව්වේෂාං මානවානාං සමීපේ ත්වං තේෂාං සාක්‍ෂී භවිෂ්‍යසි| ");
INSERT INTO sansin_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","අතඒව කුතෝ විලම්බසේ? ප්‍රභෝ ර්නාම්නා ප්‍රාර්ථ්‍ය නිජපාපප්‍රක්‍ෂාලනාර්ථං මජ්ජනාය සමුත්තිෂ්ඨ| ");
INSERT INTO sansin_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","තතඃ පරං යිරූශාලම්නගරං ප්‍රත්‍යාගත්‍ය මන්දිරේ(අ)හම් ඒකදා ප්‍රාර්ථයේ, තස්මින් සමයේ(අ)හම් අභිභූතඃ සන් ප්‍රභූං සාක්‍ෂාත් පශ්‍යන්, ");
INSERT INTO sansin_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ත්වං ත්වරයා යිරූශාලමඃ ප්‍රතිෂ්ඨස්ව යතෝ ලෝකාමයි තව සාක්‍ෂ්‍යං න ග්‍රහීෂ්‍යන්ති, මාම්ප්‍රත්‍යුදිතං තස්‍යේදං වාක්‍යම් අශ්‍රෞෂම්| ");
INSERT INTO sansin_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","තතෝහං ප්‍රත්‍යවාදිෂම් හේ ප්‍රභෝ ප්‍රතිභජනභවනං ත්වයි විශ්වාසිනෝ ලෝකාන් බද්ධ්වා ප්‍රහෘතවාන්, ");
INSERT INTO sansin_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","තථා තව සාක්‍ෂිණඃ ස්තිඵානස්‍ය රක්තපාතනසමයේ තස්‍ය විනාශං සම්මන්‍ය සන්නිධෞ තිෂ්ඨන් හන්තෘලෝකානාං වාසාංසි රක්‍ෂිතවාන්, ඒතත් තේ විදුඃ| ");
INSERT INTO sansin_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","තතඃ සෝ(අ)කථයත් ප්‍රතිෂ්ඨස්ව ත්වාං දූරස්ථභින්නදේශීයානාං සමීපං ප්‍රේෂයිෂ්‍යේ| ");
INSERT INTO sansin_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","තදා ලෝකා ඒතාවත්පර‍්‍ය්‍යන්තාං තදීයාං කථාං ශ්‍රුත්වා ප්‍රෝච්චෛරකථයන්, ඒනං භූමණ්ඩලාද් දූරීකුරුත, ඒතාදෘශජනස්‍ය ජීවනං නෝචිතම්| ");
INSERT INTO sansin_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ඉත්‍යුච්චෛඃ කථයිත්වා වසනානි පරිත්‍යජ්‍ය ගගණං ප්‍රති ධූලීරක්‍ෂිපන් ");
INSERT INTO sansin_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","තතඃ සහස්‍රසේනාපතිඃ පෞලං දුර්ගාභ්‍යන්තර නේතුං සමාදිශත්| ඒතස්‍ය ප්‍රතිකූලාඃ සන්තෝ ලෝකාඃ කින්නිමිත්තම් ඒතාවදුච්චෛඃස්වරම් අකුර්ව්වන්, ඒතද් වේත්තුං තං කශයා ප්‍රහෘත්‍ය තස්‍ය පරීක්‍ෂාං කර්ත්තුමාදිශත්| ");
INSERT INTO sansin_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","පදාතයශ්චර්ම්මනිර්ම්මිතරජ්ජුභිස්තස්‍ය බන්ධනං කර්ත්තුමුද්‍යතාස්තාස්තදානීං පෞලඃ සම්මුඛස්ථිතං ශතසේනාපතිම් උක්තවාන් දණ්ඩාඥායාම් අප්‍රාප්තායාං කිං රෝමිලෝකං ප්‍රහර්ත්තුං යුෂ්මාකම් අධිකාරෝස්ති? ");
INSERT INTO sansin_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","ඒනාං කථාං ශ්‍රුත්වා ස සහස්‍රසේනාපතේඃ සන්නිධිං ගත්වා තාං වාර්ත්තාමවදත් ස රෝමිලෝක ඒතස්මාත් සාවධානඃ සන් කර්ම්ම කුරු| ");
INSERT INTO sansin_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","තස්මාත් සහස්‍රසේනාපති ර්ගත්වා තමප්‍රාක්‍ෂීත් ත්වං කිං රෝමිලෝකඃ? ඉති මාං බ්‍රූහි| සෝ(අ)කථයත් සත්‍යම්| ");
INSERT INTO sansin_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","තතඃ සහස්‍රසේනාපතිඃ කථිතවාන් බහුද්‍රවිණං දත්ත්වාහං තත් පෞරසඛ්‍යං ප්‍රාප්තවාන්; කින්තු පෞලඃ කථිතවාන් අහං ජනුනා තත් ප්‍රාප්තෝ(අ)ස්මි| ");
INSERT INTO sansin_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","ඉත්ථං සති යේ ප්‍රහාරේණ තං පරීක්‍ෂිතුං සමුද්‍යතා ආසන් තේ තස්‍ය සමීපාත් ප්‍රාතිෂ්ඨන්ත; සහස්‍රසේනාපතිස්තං රෝමිලෝකං විඥාය ස්වයං යත් තස්‍ය බන්ධනම් අකාර්ෂීත් තත්කාරණාද් අබිභේත්| ");
INSERT INTO sansin_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","යිහූදීයලෝකාඃ පෞලං කුතෝ(අ)පවදන්තේ තස්‍ය වෘත්තාන්තං ඥාතුං වාඤ්ඡන් සහස්‍රසේනාපතිඃ පරේ(අ)හනි පෞලං බන්ධනාත් මෝචයිත්වා ප්‍රධානයාජකාන් මහාසභායාඃ සර්ව්වලෝකාශ්ච සමුපස්ථාතුම් ආදිශ්‍ය තේෂාං සන්නිධෞ පෞලම් අවරෝහ්‍ය ස්ථාපිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","සභාසද්ලෝකාන් ප්‍රති පෞලෝ(අ)නන්‍යදෘෂ්ට්‍යා පශ්‍යන් අකථයත්, හේ භ්‍රාතෘගණා අද්‍ය යාවත් සරලේන සර්ව්වාන්තඃකරණේනේශ්වරස්‍ය සාක්‍ෂාද් ආචරාමි| ");
INSERT INTO sansin_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","අනේන හනානීයනාමා මහායාජකස්තං කපෝලේ චපේටේනාහන්තුං සමීපස්ථලෝකාන් ආදිෂ්ටවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","තදා පෞලස්තමවදත්, හේ බහිෂ්පරිෂ්කෘත, ඊශ්වරස්ත්වාං ප්‍රහර්ත්තුම් උද්‍යතෝස්ති, යතෝ ව්‍යවස්ථානුසාරේණ විචාරයිතුම් උපවිශ්‍ය ව්‍යවස්ථාං ලඞ්ඝිත්වා මාං ප්‍රහර්ත්තුම් ආඥාපයසි| ");
INSERT INTO sansin_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","තතෝ නිකටස්ථා ලෝකා අකථයන්, ත්වං කිම් ඊශ්වරස්‍ය මහායාජකං නින්දසි? ");
INSERT INTO sansin_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","තතඃ පෞලඃ ප්‍රතිභාෂිතවාන් හේ භ්‍රාතෘගණ මහායාජක ඒෂ ඉති න බුද්ධං මයා තදන්‍යච්ච ස්වලෝකානාම් අධිපතිං ප්‍රති දුර්ව්වාක්‍යං මා කථය, ඒතාදෘශී ලිපිරස්ති| ");
INSERT INTO sansin_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","අනන්තරං පෞලස්තේෂාම් අර්ද්ධං සිදූකිලෝකා අර්ද්ධං ඵිරූශිලෝකා ඉති දෘෂ්ට්වා ප්‍රෝච්චෛඃ සභාස්ථලෝකාන් අවදත් හේ භ්‍රාතෘගණ අහං ඵිරූශිමතාවලම්බී ඵිරූශිනඃ සත්නානශ්ච, මෘතලෝකානාම් උත්ථානේ ප්‍රත්‍යාශාකරණාද් අහමපවාදිතෝස්මි| ");
INSERT INTO sansin_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ඉති කථායාං කථිතායාං ඵිරූශිසිදූකිනෝඃ පරස්පරං භින්නවාක්‍යත්වාත් සභායා මධ්‍යේ ද්වෞ සංඝෞ ජාතෞ| ");
INSERT INTO sansin_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","යතඃ සිදූකිලෝකා උත්ථානං ස්වර්ගීයදූතා ආත්මානශ්ච සර්ව්වේෂාම් ඒතේෂාං කමපි න මන්‍යන්තේ, කින්තු ඵිරූශිනඃ සර්ව්වම් අඞ්ගීකුර්ව්වන්ති| ");
INSERT INTO sansin_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","තතඃ පරස්පරම් අතිශයකෝලාහලේ සමුපස්ථිතේ ඵිරූශිනාං පක්‍ෂීයාඃ සභාස්ථා අධ්‍යාපකාඃ ප්‍රතිපක්‍ෂා උත්තිෂ්ඨන්තෝ (අ)කථයන්, ඒතස්‍ය මානවස්‍ය කමපි දෝෂං න පශ්‍යාමඃ; යදි කශ්චිද් ආත්මා වා කශ්චිද් දූත ඒනං ප්‍රත්‍යාදිශත් තර්හි වයම් ඊශ්වරස්‍ය ප්‍රාතිකූල්‍යේන න යෝත්ස්‍යාමඃ| ");
INSERT INTO sansin_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","තස්මාද් අතීව භින්නවාක්‍යත්වේ සති තේ පෞලං ඛණ්ඩං ඛණ්ඩං කරිෂ්‍යන්තීත්‍යාශඞ්කයා සහස්‍රසේනාපතිඃ සේනාගණං තත්ස්ථානං යාතුං සභාතෝ බලාත් පෞලං ධෘත්වා දුර්ගං නේතඤ්චාඥාපයත්| ");
INSERT INTO sansin_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","රාත්‍රෝ ප්‍රභුස්තස්‍ය සමීපේ තිෂ්ඨන් කථිතවාන් හේ පෞල නිර්භයෝ භව යථා යිරූශාලම්නගරේ මයි සාක්‍ෂ්‍යං දත්තවාන් තථා රෝමානගරේපි ත්වයා දාතව්‍යම්| ");
INSERT INTO sansin_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","දිනේ සමුපස්ථිතේ සති කියන්තෝ යිහූදීයලෝකා ඒකමන්ත්‍රණාඃ සන්තඃ පෞලං න හත්වා භෝජනපානේ කරිෂ්‍යාම ඉති ශපථේන ස්වාන් අබධ්නන්| ");
INSERT INTO sansin_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","චත්වාරිංශජ්ජනේභ්‍යෝ(අ)ධිකා ලෝකා ඉති පණම් අකුර්ව්වන්| ");
INSERT INTO sansin_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","තේ මහායාජකානාං ප්‍රාචීනලෝකානාඤ්ච සමීපං ගත්වා කථයන්, වයං පෞලං න හත්වා කිමපි න භෝක්‍ෂ්‍යාමහේ දෘඪේනානේන ශපථේන බද්ධ්වා අභවාම| ");
INSERT INTO sansin_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","අතඒව සාම්ප්‍රතං සභාසද්ලෝකෛඃ සහ වයං තස්මින් කඤ්චිද් විශේෂවිචාරං කරිෂ්‍යාමස්තදර්ථං භවාන් ශ්වෝ (අ)ස්මාකං සමීපං තම් ආනයත්විති සහස්‍රසේනාපතයේ නිවේදනං කුරුත තේන යුෂ්මාකං සමීපං උපස්ථිතේඃ පූර්ව්වං වයං තං හන්තු සජ්ජිෂ්‍යාම| ");
INSERT INTO sansin_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","තදා පෞලස්‍ය භාගිනේයස්තේෂාමිති මන්ත්‍රණාං විඥාය දුර්ගං ගත්වා තාං වාර්ත්තාං පෞලම් උක්තවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","තස්මාත් පෞල ඒකං ශතසේනාපතිම් ආහූය වාක්‍යමිදම් භාෂිතවාන් සහස්‍රසේනාපතේඃ සමීපේ(අ)ස්‍ය යුවමනුෂ්‍යස්‍ය කිඤ්චින්නිවේදනම් ආස්තේ, තස්මාත් තත්සවිධම් ඒනං නය| ");
INSERT INTO sansin_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","තතඃ ස තමාදාය සහස්‍රසේනාපතේඃ සමීපම් උපස්ථාය කථිතවාන්, භවතඃ සමීපේ(අ)ස්‍ය කිමපි නිවේදනමාස්තේ තස්මාත් බන්දිඃ පෞලෝ මාමාහූය භවතඃ සමීපම් ඒනම් ආනේතුං ප්‍රාර්ථිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","තදා සහස්‍රසේනාපතිස්තස්‍ය හස්තං ධෘත්වා නිර්ජනස්ථානං නීත්වා පෘෂ්ඨවාන් තව කිං නිවේදනං? තත් කථය| ");
INSERT INTO sansin_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","තතඃ සෝකථයත්, යිහූදීයලාකාඃ පෞලේ කමපි විශේෂවිචාරං ඡලං කෘත්වා තං සභාං නේතුං භවතඃ සමීපේ නිවේදයිතුං අමන්ත්‍රයන්| ");
INSERT INTO sansin_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","කින්තු මවතා තන්න ස්වීකර්ත්තව්‍යං යතස්තේෂාං මධ්‍යේවර්ත්තිනශ්චත්වාරිංශජ්ජනේභ්‍යෝ (අ)ධිකලෝකා ඒකමන්ත්‍රණා භූත්වා පෞලං න හත්වා භෝජනං පානඤ්ච න කරිෂ්‍යාම ඉති ශපථේන බද්ධාඃ සන්තෝ ඝාතකා ඉව සජ්ජිතා ඉදානීං කේවලං භවතෝ (අ)නුමතිම් අපේක්‍ෂන්තේ| ");
INSERT INTO sansin_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","යාමිමාං කථාං ත්වං නිවේදිතවාන් තාං කස්මෛචිදපි මා කථයේත්‍යුක්ත්වා සහස්‍රසේනාපතිස්තං යුවානං විසෘෂ්ටවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","අනන්තරං සහස්‍රසේනාපති ර්ද්වෞ ශතසේනාපතී ආහූයේදම් ආදිශත්, යුවාං රාත්‍රෞ ප්‍රහරෛකාවශිෂ්ටායාං සත්‍යාං කෛසරියානගරං යාතුං පදාතිසෛන්‍යානාං ද්වේ ශතේ ඝෝටකාරෝහිසෛන්‍යානාං සප්තතිං ශක්තිධාරිසෛන්‍යානාං ද්වේ ශතේ ච ජනාන් සජ්ජිතාන් කුරුතං| ");
INSERT INTO sansin_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","පෞලම් ආරෝහයිතුං ඵීලික්‍ෂාධිපතේඃ සමීපං නිර්ව්විඝ්නං නේතුඤ්ච වාහනානි සමුපස්ථාපයතං| ");
INSERT INTO sansin_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","අපරං ස පත්‍රං ලිඛිත්වා දත්තවාන් තල්ලිඛිතමේතත්, ");
INSERT INTO sansin_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","මහාමහිමශ්‍රීයුක්තඵීලික්‍ෂාධිපතයේ ක්ලෞදියලුෂියස්‍ය නමස්කාරඃ| ");
INSERT INTO sansin_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","යිහූදීයලෝකාඃ පූර්ව්වම් ඒනං මානවං ධෘත්වා ස්වහස්තෛ ර්හන්තුම් උද්‍යතා ඒතස්මින්නන්තරේ සසෛන්‍යෝහං තත්‍රෝපස්ථාය ඒෂ ජනෝ රෝමීය ඉති විඥාය තං රක්‍ෂිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","කින්නිමිත්තං තේ තමපවදන්තේ තජ්ඥාතුං තේෂා සභාං තමානායිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","තතස්තේෂාං ව්‍යවස්ථායා විරුද්ධයා කයාචන කථයා සෝ(අ)පවාදිතෝ(අ)භවත්, කින්තු ස ශෘඞ්ඛලබන්ධනාර්හෝ වා ප්‍රාණනාශාර්හෝ භවතීදෘශඃ කෝප්‍යපරාධෝ මයාස්‍ය න දෘෂ්ටඃ| ");
INSERT INTO sansin_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","තථාපි මනුෂ්‍යස්‍යාස්‍ය වධාර්ථං යිහූදීයා ඝාතකාඉව සජ්ජිතා ඒතාං වාර්ත්තාං ශ්‍රුත්වා තත්ක්‍ෂණාත් තව සමීපමේනං ප්‍රේෂිතවාන් අස්‍යාපවාදකාංශ්ච තව සමීපං ගත්වාපවදිතුම් ආඥාපයම්| භවතඃ කුශලං භූයාත්| ");
INSERT INTO sansin_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","සෛන්‍යගණ ආඥානුසාරේණ පෞලං ගෘහීත්වා තස්‍යාං රජන්‍යාම් ආන්තිපාත්‍රිනගරම් ආනයත්| ");
INSERT INTO sansin_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","පරේ(අ)හනි තේන සහ යාතුං ඝෝටකාරූඪසෛන්‍යගණං ස්ථාපයිත්වා පරාවෘත්‍ය දුර්ගං ගතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","තතඃ පරේ ඝෝටකාරෝහිසෛන්‍යගණඃ කෛසරියානගරම් උපස්ථාය තත්පත්‍රම් අධිපතේඃ කරේ සමර්ප්‍ය තස්‍ය සමීපේ පෞලම් උපස්ථාපිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","තදාධිපතිස්තත්පත්‍රං පඨිත්වා පෘෂ්ඨවාන් ඒෂ කිම්ප්‍රදේශීයෝ ජනඃ? ස කිලිකියාප්‍රදේශීය ඒකෝ ජන ඉති ඥාත්වා කථිතවාන්, ");
INSERT INTO sansin_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","තවාපවාදකගණ ආගතේ තව කථාං ශ්‍රෝෂ්‍යාමි| හේරෝද්‍රාජගෘහේ තං ස්ථාපයිතුම් ආදිෂ්ටවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","පඤ්චභ්‍යෝ දිනේභ්‍යඃ පරං හනානීයනාමා මහායාජකෝ(අ)ධිපතේඃ සමක්‍ෂං පෞලස්‍ය ප්‍රාතිකූල්‍යේන නිවේදයිතුං තර්තුල්ලනාමානං කඤ්චන වක්තාරං ප්‍රාචීනජනාංශ්ච සඞ්ගිනඃ කෘත්වා කෛසරියානගරම් ආගච්ඡත්| ");
INSERT INTO sansin_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","තතඃ පෞලේ සමානීතේ සති තර්තුල්ලස්තස්‍යාපවාදකථාං කථයිතුම් ආරභත හේ මහාමහිමඵීලික්‍ෂ භවතෝ වයම් අතිනිර්ව්විඝ්නං කාලං යාපයාමෝ භවතඃ පරිණාමදර්ශිතයා ඒතද්දේශීයානාං බහූනි මඞ්ගලානි ඝටිතානි, ");
INSERT INTO sansin_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","ඉති හේතෝ ර්වයමතිකෘතඥාඃ සන්තඃ සර්ව්වත්‍ර සර්ව්වදා භවතෝ ගුණාන් ගායමඃ| ");
INSERT INTO sansin_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","කින්තු බහුභිඃ කථාභි ර්භවන්තං යේන න විරඤ්ජයාමි තස්මාද් විනයේ භවාන් බනුකම්ප්‍ය මදල්පකථාං ශෘණෝතු| ");
INSERT INTO sansin_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","ඒෂ මහාමාරීස්වරූපෝ නාසරතීයමතග්‍රාහිසංඝාතස්‍ය මුඛ්‍යෝ භූත්වා සර්ව්වදේශේෂු සර්ව්වේෂාං යිහූදීයානාං රාජද්‍රෝහාචරණප්‍රවෘත්තිං ජනයතීත්‍යස්මාභි ර්නිශ්චිතං| ");
INSERT INTO sansin_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","ස මන්දිරමපි අශුචි කර්ත්තුං චේෂ්ටිතවාන්; ඉති කාරණාද් වයම් ඒනං ධෘත්වා ස්වව්‍යවස්ථානුසාරේණ විචාරයිතුං ප්‍රාවර්ත්තාමහි; ");
INSERT INTO sansin_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","කින්තු ලුෂියඃ සහස්‍රසේනාපතිරාගත්‍ය බලාද් අස්මාකං කරේභ්‍ය ඒනං ගෘහීත්වා ");
INSERT INTO sansin_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ඒතස්‍යාපවාදකාන් භවතඃ සමීපම් ආගන්තුම් ආඥාපයත්| වයං යස්මින් තමපවාදාමෝ භවතා පදපවාදකථායාං විචාරිතායාං සත්‍යාං සර්ව්වං වෘත්තාන්තං වේදිතුං ශක්‍ෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","තතෝ යිහූදීයා අපි ස්වීකෘත්‍ය කථිතවන්ත ඒෂා කථා ප්‍රමාණම්| ");
INSERT INTO sansin_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","අධිපතෞ කථාං කථයිතුං පෞලං ප්‍රතීඞ්ගිතං කෘතවති ස කථිතවාන් භවාන් බහූන් වත්සරාන් යාවද් ඒතද්දේශස්‍ය ශාසනං කරෝතීති විඥාය ප්‍රත්‍යුත්තරං දාතුම් අක්‍ෂෝභෝ(අ)භවම්| ");
INSERT INTO sansin_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","අද්‍ය කේවලං ද්වාදශ දිනානි යාතානි, අහම් ආරාධනාං කර්ත්තුං යිරූශාලමනගරං ගතවාන් ඒෂා කථා භවතා ඥාතුං ශක්‍යතේ; ");
INSERT INTO sansin_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","කින්ත්විභේ මාං මධ්‍යේමන්දිරං කේනාපි සහ විතණ්ඩාං කුර්ව්වන්තං කුත්‍රාපි භජනභවනේ නගරේ වා ලෝකාන් කුප්‍රවෘත්තිං ජනයන්තුං න දෘෂ්ටවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","ඉදානීං යස්මින් යස්මින් මාම් අපවදන්තේ තස්‍ය කිමපි ප්‍රමාණං දාතුං න ශක්නුවන්ති| ");
INSERT INTO sansin_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","කින්තු භවිෂ්‍යද්වාක්‍යග්‍රන්ථේ ව්‍යවස්ථාග්‍රන්ථේ ච යා යා කථා ලිඛිතාස්තේ තාසු සර්ව්වාසු විශ්වස්‍ය යන්මතම් ඉමේ විධර්ම්මං ජානන්ති තන්මතානුසාරේණාහං නිජපිතෘපුරුෂාණාම් ඊශ්වරම් ආරාධයාමීත්‍යහං භවතඃ සමක්‍ෂම් අඞ්ගීකරෝමි| ");
INSERT INTO sansin_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","ධාර්ම්මිකාණාම් අධාර්ම්මිකාණාඤ්ච ප්‍රමීතලෝකානාමේවෝත්ථානං භවිෂ්‍යතීති කථාමිමේ ස්වීකුර්ව්වන්ති තථාහමපි තස්මින් ඊශ්වරේ ප්‍රත්‍යාශාං කරෝමි; ");
INSERT INTO sansin_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","ඊශ්වරස්‍ය මානවානාඤ්ච සමීපේ යථා නිර්දෝෂෝ භවාමි තදර්ථං සතතං යත්නවාන් අස්මි| ");
INSERT INTO sansin_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","බහුෂු වත්සරේෂු ගතේෂු ස්වදේශීයලෝකානාං නිමිත්තං දානීයද්‍රව්‍යාණි නෛවේද්‍යානි ච සමාදාය පුනරාගමනං කෘතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","තතෝහං ශුචි ර්භූත්වා ලෝකානාං සමාගමං කලහං වා න කාරිතවාන් තථාප්‍යාශියාදේශීයාඃ කියන්තෝ යිහුදීයලෝකා මධ්‍යේමන්දිරං මාං ධෘතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","මමෝපරි යදි කාචිදපවාදකථාස්ති තර්හි භවතඃ සමීපම් උපස්ථාය තේෂාමේව සාක්‍ෂ්‍යදානම් උචිතම්| ");
INSERT INTO sansin_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","නෝචේත් පූර්ව්වේ මහාසභාස්ථානාං ලෝකානාං සන්නිධෞ මම දණ්ඩායමානත්වසමයේ, අහමද්‍ය මෘතානාමුත්ථානේ යුෂ්මාභි ර්විචාරිතෝස්මි, ");
INSERT INTO sansin_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","තේෂාං මධ්‍යේ තිෂ්ඨන්නහං යාමිමාං කථාමුච්චෛඃ ස්වරේණ කථිතවාන් තදන්‍යෝ මම කෝපි දෝෂෝ(අ)ලභ්‍යත න වේති වරම් ඒතේ සමුපස්ථිතලෝකා වදන්තු| ");
INSERT INTO sansin_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","තදා ඵීලික්‍ෂ ඒතාං කථාං ශ්‍රුත්වා තන්මතස්‍ය විශේෂවෘත්තාන්තං විඥාතුං විචාරං ස්ථගිතං කෘත්වා කථිතවාන් ලුෂියේ සහස්‍රසේනාපතෞ සමායාතේ සති යුෂ්මාකං විචාරම් අහං නිෂ්පාදයිෂ්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","අනන්තරං බන්ධනං විනා පෞලං රක්‍ෂිතුං තස්‍ය සේවනාය සාක්‍ෂාත්කරණාය වා තදීයාත්මීයබන්ධුජනාන් න වාරයිතුඤ්ච ශමසේනාපතිම් ආදිෂ්ටවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","අල්පදිනාත් පරං ඵීලික්‍ෂෝ(අ)ධිපති ර්ද්‍රුෂිල්ලානාම්නා යිහූදීයයා ස්වභාර‍්‍ය්‍යයා සහාගත්‍ය පෞලමාහූය තස්‍ය මුඛාත් ඛ්‍රීෂ්ටධර්ම්මස්‍ය වෘත්තාන්තම් අශ්‍රෞෂීත්| ");
INSERT INTO sansin_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","පෞලේන න්‍යායස්‍ය පරිමිතභෝගස්‍ය චරමවිචාරස්‍ය ච කථායාං කථිතායාං සත්‍යාං ඵීලික්‍ෂඃ කම්පමානඃ සන් ව්‍යාහරද් ඉදානීං යාහි, අහම් අවකාශං ප්‍රාප්‍ය ත්වාම් ආහූස්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","මුක්තිප්‍රප්ත්‍යර්ථං පෞලේන මහ්‍යං මුද්‍රාදාස්‍යන්තේ ඉති පත්‍යාශාං කෘත්වා ස පුනඃ පුනස්තමාහූය තේන සාකං කථෝපකථනං කෘතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","කින්තු වත්සරද්වයාත් පරං පර්කියඵීෂ්ට ඵාලික්‍ෂස්‍ය පදං ප්‍රාප්තේ සති ඵීලික්‍ෂෝ යිහූදීයාන් සන්තුෂ්ටාන් චිකීර්ෂන් පෞලං බද්ධං සංස්ථාප්‍ය ගතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","අනන්තරං ඵීෂ්ටෝ නිජරාජ්‍යම් ආගත්‍ය දිනත්‍රයාත් පරං කෛසරියාතෝ යිරූශාලම්නගරම් ආගමත්| ");
INSERT INTO sansin_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","තදා මහායාජකෝ යිහූදීයානාං ප්‍රධානලෝකාශ්ච තස්‍ය සමක්‍ෂං පෞලම් අපාවදන්ත| ");
INSERT INTO sansin_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","භවාන් තං යිරූශාලමම් ආනේතුම් ආඥාපයත්විති විනීය තේ තස්මාද් අනුග්‍රහං වාඤ්ඡිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","යතඃ පථිමධ්‍යේ ගෝපනේන පෞලං හන්තුං තෛ ර්ඝාතකා නියුක්තාඃ| ඵීෂ්ට උත්තරං දත්තවාන් පෞලඃ කෛසරියායාං ස්ථාස්‍යති පුනරල්පදිනාත් පරම් අහං තත්‍ර යාස්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","තතස්තස්‍ය මානුෂස්‍ය යදි කශ්චිද් අපරාධස්තිෂ්ඨති තර්හි යුෂ්මාකං යේ ශක්නුවන්ති තේ මයා සහ තත්‍ර ගත්වා තමපවදන්තු ස ඒතාං කථාං කථිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","දශදිවසේභ්‍යෝ(අ)ධිකං විලම්බ්‍ය ඵීෂ්ටස්තස්මාත් කෛසරියානගරං ගත්වා පරස්මින් දිවසේ විචාරාසන උපදිශ්‍ය පෞලම් ආනේතුම් ආඥාපයත්| ");
INSERT INTO sansin_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","පෞලේ සමුපස්ථිතේ සති යිරූශාලම්නගරාද් ආගතා යිහූදීයලෝකාස්තං චතුර්දිශි සංවේෂ්ට්‍ය තස්‍ය විරුද්ධං බහූන් මහාදෝෂාන් උත්ථාපිතවන්තඃ කින්තු තේෂාං කිමපි ප්‍රමාණං දාතුං න ශක්නුවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","තතඃ පෞලඃ ස්වස්මින් උත්තරමිදම් උදිතවාන්, යිහූදීයානාං ව්‍යවස්ථායා මන්දිරස්‍ය කෛසරස්‍ය වා ප්‍රතිකූලං කිමපි කර්ම්ම නාහං කෘතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","කින්තු ඵීෂ්ටෝ යිහූදීයාන් සන්තුෂ්ටාන් කර්ත්තුම් අභිලෂන් පෞලම් අභාෂත ත්වං කිං යිරූශාලමං ගත්වාස්මින් අභියෝගේ මම සාක්‍ෂාද් විචාරිතෝ භවිෂ්‍යසි? ");
INSERT INTO sansin_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","තතඃ පෞල උත්තරං ප්‍රෝක්තවාන්, යත්‍ර මම විචාරෝ භවිතුං යෝග්‍යඃ කෛසරස්‍ය තත්‍ර විචාරාසන ඒව සමුපස්ථිතෝස්මි; අහං යිහූදීයානාං කාමපි හානිං නාකාර්ෂම් ඉති භවාන් යථාර්ථතෝ විජානාති| ");
INSERT INTO sansin_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","කඤ්චිදපරාධං කිඤ්චන වධාර්හං කර්ම්ම වා යද්‍යහම් අකරිෂ්‍යං තර්හි ප්‍රාණහනනදණ්ඩමපි භෝක්තුම් උද්‍යතෝ(අ)භවිෂ්‍යං, කින්තු තේ මම සමපවාදං කුර්ව්වන්ති ස යදි කල්පිතමාත්‍රෝ භවති තර්හි තේෂාං කරේෂු මාං සමර්පයිතුං කස්‍යාප්‍යධිකාරෝ නාස්ති, කෛසරස්‍ය නිකටේ මම විචාරෝ භවතු| ");
INSERT INTO sansin_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","තදා ඵීෂ්ටෝ මන්ත්‍රිභිඃ සාර්ද්ධං සංමන්ත්‍ර‍්‍ය පෞලාය කථිතවාන්, කෛසරස්‍ය නිකටේ කිං තව විචාරෝ භවිෂ්‍යති? කෛසරස්‍ය සමීපං ගමිෂ්‍යසි| ");
INSERT INTO sansin_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","කියද්දිනේභ්‍යඃ පරම් ආග්‍රිප්පරාජා බර්ණීකී ච ඵීෂ්ටං සාක්‍ෂාත් කර්ත්තුං කෛසරියානගරම් ආගතවන්තෞ| ");
INSERT INTO sansin_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","තදා තෞ බහුදිනානි තත්‍ර ස්ථිතෞ තතඃ ඵීෂ්ටස්තං රාජානං පෞලස්‍ය කථාං විඥාප්‍ය කථයිතුම් ආරභත පෞලනාමානම් ඒකං බන්දි ඵීලික්‍ෂෝ බද්ධං සංස්ථාප්‍ය ගතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","යිරූශාලමි මම ස්ථිතිකාලේ මහායාජකෝ යිහූදීයානාං ප්‍රාචීනලෝකාශ්ච තම් අපෝද්‍ය තම්ප්‍රති දණ්ඩාඥාං ප්‍රාර්ථයන්ත| ");
INSERT INTO sansin_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","තතෝහම් ඉත්‍යුත්තරම් අවදං යාවද් අපෝදිතෝ ජනඃ ස්වාපවාදකාන් සාක්‍ෂාත් කෘත්වා ස්වස්මින් යෝ(අ)පරාධ ආරෝපිතස්තස්‍ය ප්‍රත්‍යුත්තරං දාතුං සුයෝගං න ප්‍රාප්නෝති, තාවත්කාලං කස්‍යාපි මානුෂස්‍ය ප්‍රාණනාශාඥාපනං රෝමිලෝකානාං රීති ර්නහි| ");
INSERT INTO sansin_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","තතස්තේෂ්වත්‍රාගතේෂු පරස්මින් දිවසේ(අ)හම් අවිලම්බං විචාරාසන උපවිශ්‍ය තං මානුෂම් ආනේතුම් ආඥාපයම්| ");
INSERT INTO sansin_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","තදනන්තරං තස්‍යාපවාදකා උපස්ථාය යාදෘශම් අහං චින්තිතවාන් තාදෘශං කඤ්චන මහාපවාදං නෝත්ථාප්‍ය ");
INSERT INTO sansin_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","ස්වේෂාං මතේ තථා පෞලෝ යං සජීවං වදති තස්මින් යීශුනාමනි මෘතජනේ ච තස්‍ය විරුද්ධං කථිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","තතෝහං තාදෘග්විචාරේ සංශයානඃ සන් කථිතවාන් ත්වං යිරූශාලමං ගත්වා කිං තත්‍ර විචාරිතෝ භවිතුම් ඉච්ඡසි? ");
INSERT INTO sansin_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","තදා පෞලෝ මහාරාජස්‍ය නිකටේ විචාරිතෝ භවිතුං ප්‍රාර්ථයත, තස්මාද් යාවත්කාලං තං කෛසරස්‍ය සමීපං ප්‍රේෂයිතුං න ශක්නෝමි තාවත්කාලං තමත්‍ර ස්ථාපයිතුම් ආදිෂ්ටවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","තත ආග්‍රිප්පඃ ඵීෂ්ටම් උක්තවාන්, අහමපි තස්‍ය මානුෂස්‍ය කථාං ශ්‍රෝතුම් අභිලෂාමි| තදා ඵීෂ්ටෝ ව්‍යාහරත් ශ්වස්තදීයාං කථාං ත්වං ශ්‍රෝෂ්‍යසි| ");
INSERT INTO sansin_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","පරස්මින් දිවසේ ආග්‍රිප්පෝ බර්ණීකී ච මහාසමාගමං කෘත්වා ප්‍රධානවාහිනීපතිභි ර්නගරස්ථප්‍රධානලෝකෛශ්ච සහ මිලිත්වා රාජගෘහමාගත්‍ය සමුපස්ථිතෞ තදා ඵීෂ්ටස්‍යාඥයා පෞල ආනීතෝ(අ)භවත්| ");
INSERT INTO sansin_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","තදා ඵීෂ්ටඃ කථිතවාන් හේ රාජන් ආග්‍රිප්ප හේ උපස්ථිතාඃ සර්ව්වේ ලෝකා යිරූශාලම්නගරේ යිහූදීයලෝකසමූහෝ යස්මින් මානුෂේ මම සමීපේ නිවේදනං කෘත්වා ප්‍රෝච්චෛඃ කථාමිමාං කථිතවාන් පුනරල්පකාලමපි තස්‍ය ජීවනං නෝචිතං තමේතං මානුෂං පශ්‍යත| ");
INSERT INTO sansin_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","කින්ත්වේෂ ජනඃ ප්‍රාණනාශර්හං කිමපි කර්ම්ම න කෘතවාන් ඉත්‍යජානාං තථාපි ස මහාරාජස්‍ය සන්නිධෞ විචාරිතෝ භවිතුං ප්‍රාර්ථයත තස්මාත් තස්‍ය සමීපං තං ප්‍රේෂයිතුං මතිමකරවම්| ");
INSERT INTO sansin_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","කින්තු ශ්‍රීයුක්තස්‍ය සමීපම් ඒතස්මින් කිං ලේඛනීයම් ඉත්‍යස්‍ය කස්‍යචින් නිර්ණයස්‍ය න ජාතත්වාද් ඒතස්‍ය විචාරේ සති යථාහං ලේඛිතුං කිඤ්චන නිශ්චිතං ප්‍රාප්නෝමි තදර්ථං යුෂ්මාකං සමක්‍ෂං විශේෂතෝ හේ ආග්‍රිප්පරාජ භවතඃ සමක්‍ෂම් ඒතම් ආනයේ| ");
INSERT INTO sansin_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","යතෝ බන්දිප්‍රේෂණසමයේ තස්‍යාභියෝගස්‍ය කිඤ්චිදලේඛනම් අහම් අයුක්තං ජානාමි| ");
INSERT INTO sansin_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","තත ආග්‍රිප්පඃ පෞලම් අවාදීත්, නිජාං කථාං කථයිතුං තුභ්‍යම් අනුමති ර්දීයතේ| තස්මාත් පෞලඃ කරං ප්‍රසාර‍්‍ය්‍ය ස්වස්මින් උත්තරම් අවාදීත්| ");
INSERT INTO sansin_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","හේ ආග්‍රිප්පරාජ යත්කාරණාදහං යිහූදීයෛරපවාදිතෝ (අ)භවං තස්‍ය වෘත්තාන්තම් අද්‍ය භවතඃ සාක්‍ෂාන් නිවේදයිතුමනුමතෝහම් ඉදං ස්වීයං පරමං භාග්‍යං මන්‍යේ; ");
INSERT INTO sansin_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","යතෝ යිහූදීයලෝකානාං මධ්‍යේ යා යා රීතිඃ සූක්‍ෂ්මවිචාරාශ්ච සන්ති තේෂු භවාන් විඥතමඃ; අතඒව ප්‍රාර්ථයේ ධෛර‍්‍ය්‍යමවලම්බ්‍ය මම නිවේදනං ශෘණෝතු| ");
INSERT INTO sansin_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","අහං යිරූශාලම්නගරේ ස්වදේශීයලෝකානාං මධ්‍යේ තිෂ්ඨන් ආ යෞවනකාලාද් යද්‍රූපම් ආචරිතවාන් තද් යිහූදීයලෝකාඃ සර්ව්වේ විදන්ති| ");
INSERT INTO sansin_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","අස්මාකං සර්ව්වේභ්‍යඃ ශුද්ධතමං යත් ඵිරූශීයමතං තදවලම්බී භූත්වාහං කාලං යාපිතවාන් යේ ජනා ආ බාල්‍යකාලාන් මාං ජානාන්ති තේ ඒතාදෘශං සාක්‍ෂ්‍යං යදි දදාති තර්හි දාතුං ශක්නුවන්ති| ");
INSERT INTO sansin_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","කින්තු හේ ආග්‍රිප්පරාජ ඊශ්වරෝ(අ)ස්මාකං පූර්ව්වපුරුෂාණාං නිකටේ යද් අඞ්ගීකෘතවාන් තස්‍ය ප්‍රත්‍යාශාහේතෝරහම් ඉදානීං විචාරස්ථානේ දණ්ඩායමානෝස්මි| ");
INSERT INTO sansin_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","තස්‍යාඞ්ගීකාරස්‍ය ඵලං ප්‍රාප්තුම් අස්මාකං ද්වාදශවංශා දිවානිශං මහායත්නාද් ඊශ්වරසේවනං කෘත්වා යාං ප්‍රත්‍යාශාං කුර්ව්වන්ති තස්‍යාඃ ප්‍රත්‍යාශායා හේතෝරහං යිහූදීයෛරපවාදිතෝ(අ)භවම්| ");
INSERT INTO sansin_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","ඊශ්වරෝ මෘතාන් උත්ථාපයිෂ්‍යතීති වාක්‍යං යුෂ්මාකං නිකටේ(අ)සම්භවං කුතෝ භවේත්? ");
INSERT INTO sansin_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","නාසරතීයයීශෝ ර්නාම්නෝ විරුද්ධං නානාප්‍රකාරප්‍රතිකූලාචරණම් උචිතම් ඉත්‍යහං මනසි යථාර්ථං විඥාය ");
INSERT INTO sansin_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","යිරූශාලමනගරේ තදකරවං ඵලතඃ ප්‍රධානයාජකස්‍ය නිකටාත් ක්‍ෂමතාං ප්‍රාප්‍ය බහූන් පවිත්‍රලෝකාන් කාරායාං බද්ධවාන් විශේෂතස්තේෂාං හනනසමයේ තේෂාං විරුද්ධාං නිජාං සම්මතිං ප්‍රකාශිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","වාරං වාරං භජනභවනේෂු තේභ්‍යෝ දණ්ඩං ප්‍රදත්තවාන් බලාත් තං ධර්ම්මං නින්දයිතවාංශ්ච පුනශ්ච තාන් ප්‍රති මහාක්‍රෝධාද් උන්මත්තඃ සන් විදේශීයනගරාණි යාවත් තාන් තාඩිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","ඉත්ථං ප්‍රධානයාජකස්‍ය සමීපාත් ශක්තිම් ආඥාපත්‍රඤ්ච ලබ්ධ්වා දම්මේෂක්නගරං ගතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","තදාහං හේ රාජන් මාර්ගමධ්‍යේ මධ්‍යාහ්නකාලේ මම මදීයසඞ්ගිනාං ලෝකානාඤ්ච චතසෘෂු දික්‍ෂු ගගණාත් ප්‍රකාශමානාං භාස්කරතෝපි තේජස්වතීං දීප්තිං දෘෂ්ටවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","තස්මාද් අස්මාසු සර්ව්වේෂු භූමෞ පතිතේෂු සත්සු හේ ශෞල හෛ ශෞල කුතෝ මාං තාඩයසි? කණ්ටකානාං මුඛේ පාදාහනනං තව දුඃසාධ්‍යම් ඉබ්‍රීයභාෂයා ගදිත ඒතාදෘශ ඒකඃ ශබ්දෝ මයා ශ්‍රුතඃ| ");
INSERT INTO sansin_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","තදාහං පෘෂ්ටවාන් හේ ප්‍රභෝ කෝ භවාන්? තතඃ ස කථිතවාන් යං යීශුං ත්වං තාඩයසි සෝහං, ");
INSERT INTO sansin_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","කින්තු සමුත්තිෂ්ඨ ත්වං යද් දෘෂ්ටවාන් ඉතඃ පුනඤ්ච යද්‍යත් ත්වාං දර්ශයිෂ්‍යාමි තේෂාං සර්ව්වේෂාං කාර‍්‍ය්‍යාණාං ත්වාං සාක්‍ෂිණං මම සේවකඤ්ච කර්ත්තුම් දර්ශනම් අදාම්| ");
INSERT INTO sansin_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","විශේෂතෝ යිහූදීයලෝකේභ්‍යෝ භින්නජාතීයේභ්‍යශ්ච ත්වාං මනෝනීතං කෘත්වා තේෂාං යථා පාපමෝචනං භවති ");
INSERT INTO sansin_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","යථා තේ මයි විශ්වස්‍ය පවිත්‍රීකෘතානාං මධ්‍යේ භාගං ප්‍රාප්නුවන්ති තදභිප්‍රායේණ තේෂාං ඥානචක්‍ෂූංෂි ප්‍රසන්නානි කර්ත්තුං තථාන්ධකාරාද් දීප්තිං ප්‍රති ශෛතානාධිකාරාච්ච ඊශ්වරං ප්‍රති මතීඃ පරාවර්ත්තයිතුං තේෂාං සමීපං ත්වාං ප්‍රේෂ්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","හේ ආග්‍රිප්පරාජ ඒතාදෘශං ස්වර්ගීයප්‍රත්‍යාදේශං අග්‍රාහ්‍යම් අකෘත්වාහං ");
INSERT INTO sansin_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","ප්‍රථමතෝ දම්මේෂක්නගරේ තතෝ යිරූශාලමි සර්ව්වස්මින් යිහූදීයදේශේ අන්‍යේෂු දේශේෂු ච යේेන ලෝකා මතිං පරාවර්ත්ත්‍ය ඊශ්වරං ප්‍රති පරාවර්ත්තයන්තේ, මනඃපරාවර්ත්තනයෝග්‍යානි කර්ම්මාණි ච කුර්ව්වන්ති තාදෘශම් උපදේශං ප්‍රචාරිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","ඒතත්කාරණාද් යිහූදීයා මධ්‍යේමන්දිරං මාං ධෘත්වා හන්තුම් උද්‍යතාඃ| ");
INSERT INTO sansin_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","තථාපි ඛ්‍රීෂ්ටෝ දුඃඛං භුක්ත්වා සර්ව්වේෂාං පූර්ව්වං ශ්මශානාද් උත්ථාය නිජදේශීයානාං භින්නදේශීයානාඤ්ච සමීපේ දීප්තිං ප්‍රකාශයිෂ්‍යති ");
INSERT INTO sansin_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","භවිෂ්‍යද්වාදිගණෝ මූසාශ්ච භාවිකාර‍්‍ය්‍යස්‍ය යදිදං ප්‍රමාණම් අදදුරේතද් විනාන්‍යාං කථාං න කථයිත්වා ඊශ්වරාද් අනුග්‍රහං ලබ්ධ්වා මහතාං ක්‍ෂුද්‍රාණාඤ්ච සර්ව්වේෂාං සමීපේ ප්‍රමාණං දත්ත්වාද්‍ය යාවත් තිෂ්ඨාමි| ");
INSERT INTO sansin_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","තස්‍යමාං කථාං නිශම්‍ය ඵීෂ්ට උච්චෛඃ ස්වරේණ කථිතවාන් හේ පෞල ත්වම් උන්මත්තෝසි බහුවිද්‍යාභ්‍යාසේන ත්වං හතඥානෝ ජාතඃ| ");
INSERT INTO sansin_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","ස උක්තවාන් හේ මහාමහිම ඵීෂ්ට නාහම් උන්මත්තඃ කින්තු සත්‍යං විවේචනීයඤ්ච වාක්‍යං ප්‍රස්තෞමි| ");
INSERT INTO sansin_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","යස්‍ය සාක්‍ෂාද් අක්‍ෂෝභඃ සන් කථාං කථයාමි ස රාජා තද්වෘත්තාන්තං ජානාති තස්‍ය සමීපේ කිමපි ගුප්තං නේති මයා නිශ්චිතං බුධ්‍යතේ යතස්තද් විජනේ න කෘතං| ");
INSERT INTO sansin_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","හේ ආග්‍රිප්පරාජ භවාන් කිං භවිෂ්‍යද්වාදිගණෝක්තානි වාක්‍යානි ප්‍රත්‍යේති? භවාන් ප්‍රත්‍යේති තදහං ජානාමි| ");
INSERT INTO sansin_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","තත ආග්‍රිප්පඃ පෞලම් අභිහිතවාන් ත්වං ප්‍රවෘත්තිං ජනයිත්වා ප්‍රායේණ මාමපි ඛ්‍රීෂ්ටීයං කරෝෂි| ");
INSERT INTO sansin_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","තතඃ සෝ(අ)වාදීත් භවාන් යේ යේ ලෝකාශ්ච මම කථාම් අද්‍ය ශෘණ්වන්ති ප්‍රායේණ ඉති නහි කින්ත්වේතත් ශෘඞ්ඛලබන්ධනං විනා සර්ව්වථා තේ සර්ව්වේ මාදෘශා භවන්ත්විතීශ්වස්‍ය සමීපේ ප්‍රාර්ථයේ(අ)හම්| ");
INSERT INTO sansin_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","ඒතස්‍යාං කථායාං කථිතායාං ස රාජා සෝ(අ)ධිපති ර්බර්ණීකී සභාස්ථා ලෝකාශ්ච තස්මාද් උත්ථාය ");
INSERT INTO sansin_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ගෝපනේ පරස්පරං විවිච්‍ය කථිතවන්ත ඒෂ ජනෝ බන්ධනාර්හං ප්‍රාණහනනාර්හං වා කිමපි කර්ම්ම නාකරෝත්| ");
INSERT INTO sansin_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","තත ආග්‍රිප්පඃ ඵීෂ්ටම් අවදත්, යද්‍යේෂ මානුෂඃ කෛසරස්‍ය නිකටේ විචාරිතෝ භවිතුං න ප්‍රාර්ථයිෂ්‍යත් තර්හි මුක්තෝ භවිතුම් අශක්‍ෂ්‍යත්| ");
INSERT INTO sansin_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","ජලපථේනාස්මාකම් ඉතෝලියාදේශං ප්‍රති යාත්‍රායාං නිශ්චිතායාං සත්‍යාං තේ යූලියනාම්නෝ මහාරාජස්‍ය සංඝාතාන්තර්ගතස්‍ය සේනාපතේඃ සමීපේ පෞලං තදන්‍යාන් කතිනයජනාංශ්ච සමාර්පයන්| ");
INSERT INTO sansin_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","වයම් ආද්‍රාමුත්තීයං පෝතමේකම් ආරුහ්‍ය ආශියාදේශස්‍ය තටසමීපේන යාතුං මතිං කෘත්වා ලඞ්ගරම් උත්ථාප්‍ය පෝතම් අමෝචයාම; මාකිදනියාදේශස්ථථිෂලනීකීනිවාස්‍යාරිස්තාර්ඛනාමා කශ්චිද් ජනෝ(අ)ස්මාභිඃ සාර්ද්ධම් ආසීත්| ");
INSERT INTO sansin_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","පරස්මින් දිවසේ (අ)ස්මාභිඃ සීදෝන්නගරේ පෝතේ ලාගිතේ තත්‍ර යූලියඃ සේනාපතිඃ පෞලං ප්‍රති සෞජන්‍යං ප්‍රදර්ථ්‍ය සාන්ත්වනාර්ථං බන්ධුබාන්ධවාන් උපයාතුම් අනුජඥෞ| ");
INSERT INTO sansin_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","තස්මාත් පෝතේ මෝචිතේ සති සම්මුඛවායෝඃ සම්භවාද් වයං කුප්‍රෝපද්වීපස්‍ය තීරසමීපේන ගතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","කිලිකියායාඃ පාම්ඵූලියායාශ්ච සමුද්‍රස්‍ය පාරං ගත්වා ලූකියාදේශාන්තර්ගතං මුරානගරම් උපාතිෂ්ඨාම| ");
INSERT INTO sansin_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","තත්ස්ථානාද් ඉතාලියාදේශං ගච්ඡති යඃ සිකන්දරියානගරස්‍ය පෝතස්තං තත්‍ර ප්‍රාප්‍ය ශතසේනාපතිස්තං පෝතම් අස්මාන් ආරෝහයත්| ");
INSERT INTO sansin_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","තතඃ පරං බහූනි දිනානි ශනෛඃ ශනෛඃ ර්ගත්වා ක්නීදපාර්ශ්වෝපස්ථ්තිेඃ පූර්ව්වං ප්‍රතිකූලේන පවනේන වයං සල්මෝන්‍යාඃ සම්මුඛම් උපස්ථාය ක්‍රීත්‍යුපද්වීපස්‍ය තීරසමීපේන ගතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","කෂ්ටේන තමුත්තීර‍්‍ය්‍ය ලාසේයානගරස්‍යාධඃ සුන්දරනාමකං ඛාතම් උපාතිෂ්ඨාම| ");
INSERT INTO sansin_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","ඉත්ථං බහුතිථඃ කාලෝ යාපිත උපවාසදිනඤ්චාතීතං, තත්කාරණාත් නෞවර්ත්මනි භයඞ්කරේ සති පෞලෝ විනයේන කථිතවාන්, ");
INSERT INTO sansin_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","හේ මහේච්ඡා අහං නිශ්චයං ජානාමි යාත්‍රායාමස්‍යාම් අස්මාකං ක්ලේශා බහූනාමපචයාශ්ච භවිෂ්‍යන්ති, තේ කේවලං පෝතසාමග්‍ර‍්‍යෝරිති නහි, කින්ත්වස්මාකං ප්‍රාණානාමපි| ");
INSERT INTO sansin_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","තදා ශතසේනාපතිඃ පෞैेලෝක්තවාක්‍යතෝපි කර්ණධාරස්‍ය පෝතවණිජශ්ච වාක්‍යං බහුමංස්ත| ");
INSERT INTO sansin_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","තත් ඛාතං ශීතකාලේ වාසාර්හස්ථානං න තස්මාද් අවාචීප්‍රතීචෝර්දිශෝඃ ක්‍රීත්‍යාඃ ඵෛනීකියඛාතං යාතුං යදි ශක්නුවන්තස්තර්හි තත්‍ර ශීතකාලං යාපයිතුං ප්‍රායේණ සර්ව්වේ මන්ත්‍රයාමාසුඃ| ");
INSERT INTO sansin_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","තතඃ පරං දක්‍ෂිණවායු ර්මන්දං වහතීති විලෝක්‍ය නිජාභිප්‍රායස්‍ය සිද්ධේඃ සුයෝගෝ භවතීති බුද්ධ්වා පෝතං මෝචයිත්වා ක්‍රීත්‍යුපද්වීපස්‍ය තීරසමීපේන චලිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","කින්ත්වල්පක්‍ෂණාත් පරමේව උරක්ලුදෝන්නාමා ප්‍රතිකූලඃ ප්‍රචණ්ඩෝ වායු ර්වහන් පෝතේ(අ)ලගීත් ");
INSERT INTO sansin_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","තස්‍යාභිමුඛං ගන්තුම් පෝතස්‍යාශක්තත්වාද් වයං වායුනා ස්වයං නීතාඃ| ");
INSERT INTO sansin_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","අනන්තරං ක්ලෞදීනාම්න උපද්වීපස්‍ය කූලසමීපේන පෝතං ගමයිත්වා බහුනා කෂ්ටේන ක්‍ෂුද්‍රනාවම් අරක්‍ෂාම| ");
INSERT INTO sansin_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","තේ තාමාරුහ්‍ය රජ්ජ්චා පෝතස්‍යාධෝභාගම් අබධ්නන් තදනන්තරං චේත් පෝතෝ සෛකතේ ලගතීති භයාද් වාතවසනාන්‍යමෝචයන් තතඃ පෝතෝ වායුනා චාලිතඃ| ");
INSERT INTO sansin_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","කින්තු ක්‍රමශෝ වායෝඃ ප්‍රබලත්වාත් පෝතෝ දෝලායමානෝ(අ)භවත් පරස්මින් දිවසේ පෝතස්ථානි කතිපයානි ද්‍රව්‍යාණි තෝයේ නික්‍ෂිප්තානි| ");
INSERT INTO sansin_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","තෘතීයදිවසේ වයං ස්වහස්තෛඃ පෝතසජ්ජනද්‍රව්‍යාණි නික්‍ෂිප්තවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","තතෝ බහුදිනානි යාවත් සූර‍්‍ය්‍යනක්‍ෂත්‍රාදීනි සමාච්ඡන්නානි තතෝ (අ)තීව වාත්‍යාගමාද් අස්මාකං ප්‍රාණරක්‍ෂායාඃ කාපි ප්‍රත්‍යාශා නාතිෂ්ඨත්| ");
INSERT INTO sansin_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","බහුදිනේෂු ලෝකෛරනාහාරේණ යාපිතේෂු සර්ව්වේෂාං සාක්‍ෂත් පෞලස්තිෂ්ඨන් අකථයත්, හේ මහේච්ඡාඃ ක්‍රීත්‍යුපද්වීපාත් පෝතං න මෝචයිතුම් අහං පූර්ව්වං යද් අවදං තද්ග්‍රහණං යුෂ්මාකම් උචිතම් ආසීත් තථා කෘතේ යුෂ්මාකම් ඒෂා විපද් ඒෂෝ(අ)පචයශ්ච නාඝටිෂ්‍යේතාම්| ");
INSERT INTO sansin_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","කින්තු සාම්ප්‍රතං යුෂ්මාන් විනීය බ්‍රවීම්‍යහං, යූයං න ක්‍ෂුභ්‍යත යුෂ්මාකම් ඒකස්‍යාපි ප්‍රාණිනෝ හානි ර්න භවිෂ්‍යති, කේවලස්‍ය පෝතස්‍ය හානි ර්භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","යතෝ යස්‍යේශ්වරස්‍ය ලෝකෝ(අ)හං යඤ්චාහං පරිචරාමි තදීය ඒකෝ දූතෝ හ්‍යෝ රාත්‍රෞ මමාන්තිකේ තිෂ්ඨන් කථිතවාන්, ");
INSERT INTO sansin_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","හේ පෞල මා භෛෂීඃ කෛසරස්‍ය සම්මුඛේ ත්වයෝපස්ථාතව්‍යං; තවෛතාන් සඞ්ගිනෝ ලෝකාන් ඊශ්වරස්තුභ්‍යං දත්තවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","අතඒව හේ මහේච්ඡා යූයං ස්ථිරමනසෝ භවත මහ්‍යං යා කථාකථි සාවශ්‍යං ඝටිෂ්‍යතේ මමෛතාදෘශී විශ්වාස ඊශ්වරේ විද්‍යතේ, ");
INSERT INTO sansin_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","කින්තු කස්‍යචිද් උපද්වීපස්‍යෝපරි පතිතව්‍යම් අස්මාභිඃ| ");
INSERT INTO sansin_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","තතඃ පරම් ආද්‍රියාසමුද්‍රේ පෝතස්තථෛව දෝලායමානඃ සන් ඉතස්තතෝ ගච්ඡන් චතුර්දශදිවසස්‍ය රාත්‍රේ ර්ද්විතීයප්‍රහරසමයේ කස්‍යචිත් ස්ථලස්‍ය සමීපමුපතිෂ්ඨතීති පෝතීයලෝකා අන්වමන්‍යන්ත| ");
INSERT INTO sansin_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","තතස්තේ ජලං පරිමාය තත්‍ර විංශති ර්ව්‍යාමා ජලානීති ඥාතවන්තඃ| කිඤ්චිද්දූරං ගත්වා පුනරපි ජලං පරිමිතවන්තඃ| තත්‍ර පඤ්චදශ ව්‍යාමා ජලානි දෘෂ්ට්වා ");
INSERT INTO sansin_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","චේත් පාෂාණේ ලගතීති භයාත් පෝතස්‍ය පශ්චාද්භාගතශ්චතුරෝ ලඞ්ගරාන් නික්‍ෂිප්‍ය දිවාකරම් අපේක්‍ෂ්‍ය සර්ව්වේ ස්ථිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","කින්තු පෝතීයලෝකාඃ පෝතාග්‍රභාගේ ලඞ්ගරනික්‍ෂේපං ඡලං කෘත්වා ජලධෞ ක්‍ෂුද්‍රනාවම් අවරෝහ්‍ය පලායිතුම් අචේෂ්ටන්ත| ");
INSERT INTO sansin_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","තතඃ පෞලඃ සේනාපතයේ සෛන්‍යගණාය ච කථිතවාන්, ඒතේ යදි පෝතමධ්‍යේ න තිෂ්ඨන්ති තර්හි යුෂ්මාකං රක්‍ෂණං න ශක්‍යං| ");
INSERT INTO sansin_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","තදා සේනාගණෝ රජ්ජූන් ඡිත්වා නාවං ජලේ පතිතුම් අදදාත්| ");
INSERT INTO sansin_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","ප්‍රභාතසමයේ පෞලඃ සර්ව්වාන් ජනාන් භෝජනාර්ථං ප්‍රාර්ථ්‍ය ව්‍යාහරත්, අද්‍ය චතුර්දශදිනානි යාවද් යූයම් අපේක්‍ෂමානා අනාහාරාඃ කාලම් අයාපයත කිමපි නාභුංග්ධං| ");
INSERT INTO sansin_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","අතෝ විනයේे(අ)හං භක්‍ෂ්‍යං භුජ්‍යතාං තතෝ යුෂ්මාකං මඞ්ගලං භවිෂ්‍යති, යුෂ්මාකං කස්‍යචිජ්ජනස්‍ය ශිරසඃ කේශෛකෝපි න නංක්‍ෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","ඉති ව්‍යාහෘත්‍ය පෞලං පූපං ගෘහීත්වේශ්වරං ධන්‍යං භාෂමාණස්තං භංක්ත්වා භෝක්තුම් ආරබ්ධවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","අනන්තරං සර්ව්වේ ච සුස්ථිරාඃ සන්තඃ ඛාද්‍යානි පර්ප්‍යගෘහ්ලන්| ");
INSERT INTO sansin_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","අස්මාකං පෝතේ ෂට්සප්තත්‍යධිකශතද්වයලෝකා ආසන්| ");
INSERT INTO sansin_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","සර්ව්වේෂු ලෝකේෂු යථේෂ්ටං භුක්තවත්සු පෝතස්ථන් ගෝධූමාන් ජලධෞ නික්‍ෂිප්‍ය තෛඃ පෝතස්‍ය භාරෝ ලඝූකෘතඃ| ");
INSERT INTO sansin_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","දිනේ ජාතේ(අ)පි ස කෝ දේශ ඉති තදා න පර‍්‍ය්‍යචීයත; කින්තු තත්‍ර සමතටම් ඒකං ඛාතං දෘෂ්ට්වා යදි ශක්නුමස්තර්හි වයං තස්‍යාභ්‍යන්තරං පෝතං ගමයාම ඉති මතිං කෘත්වා තේ ලඞ්ගරාන් ඡිත්ත්වා ජලධෞ ත්‍යක්තවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","තථා කර්ණබන්ධනං මෝචයිත්වා ප්‍රධානං වාතවසනම් උත්තෝල්‍ය තීරසමීපං ගතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","කින්තු ද්වයෝඃ සමුද්‍රයෝඃ සඞ්ගමස්ථානේ සෛකතෝපරි පෝතේ නික්‍ෂිප්තේ (අ)ග්‍රභාගේ බාධිතේ පශ්චාද්භාගේ ප්‍රබලතරඞ්ගෝ(අ)ලගත් තේන පෝතෝ භග්නඃ| ");
INSERT INTO sansin_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","තස්මාද් බන්දයශ්චේද් බාහුභිස්තරන්තඃ පලායන්තේ ඉත්‍යාශඞ්කයා සේනාගණස්තාන් හන්තුම් අමන්ත්‍රයත්; ");
INSERT INTO sansin_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","කින්තු ශතසේනාපතිඃ පෞලං රක්‍ෂිතුං ප්‍රයත්නං කෘත්වා තාන් තච්චේෂ්ටායා නිවර්ත්‍ය ඉත්‍යාදිෂ්ටවාන්, යේ බාහුතරණං ජානන්ති තේ(අ)ග්‍රේ ප්‍රෝල්ලම්ප්‍ය සමුද්‍රේ පතිත්වා බාහුභිස්තීර්ත්ත්වා කූලං යාන්තු| ");
INSERT INTO sansin_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","අපරම් අවශිෂ්ටා ජනාඃ කාෂ්ඨං පෝතීයං ද්‍රව්‍යං වා යේන යත් ප්‍රාප්‍යතේ තදවලම්බ්‍ය යාන්තු; ඉත්ථං සර්ව්වේ භූමිං ප්‍රාප්‍ය ප්‍රාණෛ ර්ජීවිතාඃ| ");
INSERT INTO sansin_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","ඉත්ථං සර්ව්වේෂු රක්‍ෂාං ප්‍රාප්තේෂු තත්‍රත්‍යෝපද්වීපස්‍ය නාම මිලීතේති තේ ඥාතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","අසභ්‍යලෝකා යථේෂ්ටම් අනුකම්පාං කෘත්වා වර්ත්තමානවෘෂ්ටේඃ ශීතාච්ච වහ්නිං ප්‍රජ්ජ්වාල්‍යාස්මාකම් ආතිථ්‍යම් අකුර්ව්වන්| ");
INSERT INTO sansin_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","කින්තු පෞල ඉන්ධනානි සංගෘහ්‍ය යදා තස්මින් අග්‍රෞ නිරක්‍ෂිපත්, තදා වහ්නේඃ ප්‍රතාපාත් ඒකඃ කෘෂ්ණසර්පෝ නිර්ගත්‍ය තස්‍ය හස්තේ ද්‍රෂ්ටවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","තේ(අ)සභ්‍යලෝකාස්තස්‍ය හස්තේ සර්පම් අවලම්බමානං දෘෂ්ට්වා පරස්පරම් උක්තවන්ත ඒෂ ජනෝ(අ)වශ්‍යං නරහා භවිෂ්‍යති, යතෝ යද්‍යපි ජලධේ රක්‍ෂාං ප්‍රාප්තවාන් තථාපි ප්‍රතිඵලදායක ඒනං ජීවිතුං න දදාති| ");
INSERT INTO sansin_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","කින්තු ස හස්තං විධුන්වන් තං සර්පම් අග්නිමධ්‍යේ නික්‍ෂිප්‍ය කාමපි පීඩාං නාප්තවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","තතෝ විෂජ්වාලයා ඒතස්‍ය ශරීරං ස්ඵීතං භවිෂ්‍යති යද්වා හඨාදයං ප්‍රාණාන් ත්‍යක්‍ෂ්‍යතීති නිශ්චිත්‍ය ලෝකා බහුක්‍ෂණානි යාවත් තද් ද්‍රෂ්ටුං ස්ථිතවන්තඃ කින්තු තස්‍ය කස්‍යාශ්චිද් විපදෝ(අ)ඝටනාත් තේ තද්විපරීතං විඥාය භාෂිතවන්ත ඒෂ කශ්චිද් දේවෝ භවේත්| ");
INSERT INTO sansin_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","පුබ්ලියනාමා ජන ඒකස්තස්‍යෝපද්වීපස්‍යාධිපතිරාසීත් තත්‍ර තස්‍ය භූම්‍යාදි ච ස්ථිතං| ස ජනෝ(අ)ස්මාන් නිජගෘහං නීත්වා සෞජන්‍යං ප්‍රකාශ්‍ය දිනත්‍රයං යාවද් අස්මාකං ආතිථ්‍යම් අකරෝත්| ");
INSERT INTO sansin_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","තදා තස්‍ය පුබ්ලියස්‍ය පිතා ජ්වරාතිසාරේණ පීඩ්‍යමානඃ සන් ශය්‍යායාම් ආසීත්; තතඃ පෞලස්තස්‍ය සමීපං ගත්වා ප්‍රාර්ථනාං කෘත්වා තස්‍ය ගාත්‍රේ හස්තං සමර්ප්‍ය තං ස්වස්ථං කෘතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","ඉත්ථං භූතේ තද්වීපනිවාසින ඉතරේපි රෝගිලෝකා ආගත්‍ය නිරාමයා අභවන්| ");
INSERT INTO sansin_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","තස්මාත්තේ(අ)ස්මාකම් අතීව සත්කාරං කෘතවන්තඃ, විශේෂතඃ ප්‍රස්ථානසමයේ ප්‍රයෝජනීයානි නානද්‍රව්‍යාණි දත්තවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","ඉත්ථං තත්‍ර ත්‍රිෂු මාසේෂු ගතේෂු යස්‍ය චිහ්නං දියස්කූරී තාදෘශ ඒකඃ සිකන්දරීයනගරස්‍ය පෝතඃ ශීතකාලං යාපයන් තස්මින් උපද්වීපේ (අ)තිෂ්ඨත් තමේව පෝතං වයම් ආරුහ්‍ය යාත්‍රාම් අකුර්ම්ම| ");
INSERT INTO sansin_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","තතඃ ප්‍රථමතඃ සුරාකූසනගරම් උපස්ථාය තත්‍ර ත්‍රීණි දිනානි ස්ථිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","තස්මාද් ආවෘත්‍ය රීගියනගරම් උපස්ථිතාඃ දිනෛකස්මාත් පරං දක්‍ෂිණවයෞ සානුකූල්‍යේ සති පරස්මින් දිවසේ පතියලීනගරම් උපාතිෂ්ඨාම| ");
INSERT INTO sansin_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","තතෝ(අ)ස්මාසු තත්‍රත්‍යං භ්‍රාතෘගණං ප්‍රාප්තේෂු තේ ස්වෛඃ සාර්ද්ධම් අස්මාන් සප්ත දිනානි ස්ථාපයිතුම් අයතන්ත, ඉත්ථං වයං රෝමානගරම් ප්‍රත්‍යගච්ඡාම| ");
INSERT INTO sansin_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","තස්මාත් තත්‍රත්‍යාඃ භ්‍රාතරෝ(අ)ස්මාකම් ආගමනවාර්ත්තාං ශ්‍රුත්වා ආප්පියඵරං ත්‍රිෂ්ටාවර්ණීඤ්ච යාවද් අග්‍රේසරාඃ සන්තෝස්මාන් සාක්‍ෂාත් කර්ත්තුම් ආගමන්; තේෂාං දර්ශනාත් පෞල ඊශ්වරං ධන්‍යං වදන් ආශ්වාසම් ආප්තවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","අස්මාසු රෝමානගරං ගතේෂු ශතසේනාපතිඃ සර්ව්වාන් බන්දීන් ප්‍රධානසේනාපතේඃ සමීපේ සමාර්පයත් කින්තු පෞලාය ස්වරක්‍ෂකපදාතිනා සහ පෘථග් වස්තුම් අනුමතිං දත්තවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","දිනත්‍රයාත් පරං පෞලස්තද්දේශස්ථාන් ප්‍රධානයිහූදින ආහූතවාන් තතස්තේෂු සමුපස්ථිතේෂු ස කථිතවාන්, හේ භ්‍රාතෘගණ නිජලෝකානාං පූර්ව්වපුරුෂාණාං වා රීතේ ර්විපරීතං කිඤ්චන කර්ම්මාහං නාකරවං තථාපි යිරූශාලමනිවාසිනෝ ලෝකා මාං බන්දිං කෘත්වා රෝමිලෝකානාං හස්තේෂු සමර්පිතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","රෝමිලෝකා විචාර‍්‍ය්‍ය මම ප්‍රාණහනනාර්හං කිමපි කාරණං න ප්‍රාප්‍ය මාං මෝචයිතුම් ඓච්ඡන්; ");
INSERT INTO sansin_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","කින්තු යිහූදිලෝකානාම් ආපත්ත්‍යා මයා කෛසරරාජස්‍ය සමීපේ විචාරස්‍ය ප්‍රාර්ථනා කර්ත්තව්‍යා ජාතා නෝචේත් නිජදේශීයලෝකාන් ප්‍රති මම කෝප්‍යභියෝගෝ නාස්ති| ");
INSERT INTO sansin_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","ඒතත්කාරණාද් අහං යුෂ්මාන් ද්‍රෂ්ටුං සංලපිතුඤ්චාහූයම් ඉස්‍රායේල්වශීයානාං ප්‍රත්‍යාශාහේතෝහම් ඒතේන ශුඞ්ඛලේන බද්ධෝ(අ)භවම්| ");
INSERT INTO sansin_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","තදා තේ තම් අවාදිෂුඃ, යිහූදීයදේශාද් වයං ත්වාමධි කිමපි පත්‍රං න ප්‍රාප්තා යේ භ්‍රාතරඃ සමායාතාස්තේෂාං කෝපි තව කාමපි වාර්ත්තාං නාවදත් අභද්‍රමපි නාකථයච්ච| ");
INSERT INTO sansin_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","තව මතං කිමිති වයං ත්වත්තඃ ශ්‍රෝතුමිච්ඡාමඃ| යද් ඉදං නවීනං මතමුත්ථිතං තත් සර්ව්වත්‍ර සර්ව්වේෂාං නිකටේ නින්දිතං ජාතම ඉති වයං ජානීමඃ| ");
INSERT INTO sansin_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","තෛස්තදර්ථම් ඒකස්මින් දිනේ නිරූපිතේ තස්මින් දිනේ බහව ඒකත්‍ර මිලිත්වා පෞලස්‍ය වාසගෘහම් ආගච්ඡන් තස්මාත් පෞල ආ ප්‍රාතඃකාලාත් සන්ධ්‍යාකාලං යාවන් මූසාව්‍යවස්ථාග්‍රන්ථාද් භවිෂ්‍යද්වාදිනාං ග්‍රන්ථේභ්‍යශ්ච යීශෝඃ කථාම් උත්ථාප්‍ය ඊශ්වරස්‍ය රාජ්‍යේ ප්‍රමාණං දත්වා තේෂාං ප්‍රවෘත්තිං ජනයිතුං චේෂ්ටිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","කේචිත්තු තස්‍ය කථාං ප්‍රත්‍යායන් කේචිත්තු න ප්‍රත්‍යායන්; ");
INSERT INTO sansin_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","ඒතත්කාරණාත් තේෂාං පරස්පරම් අනෛක්‍යාත් සර්ව්වේ චලිතවන්තඃ; තථාපි පෞල ඒතාං කථාමේකාං කථිතවාන් පවිත්‍ර ආත්මා යිශයියස්‍ය භවිෂ්‍යද්වක්තු ර්වදනාද් අස්මාකං පිතෘපුරුෂේභ්‍ය ඒතාං කථාං භද්‍රං කථයාමාස, යථා, ");
INSERT INTO sansin_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","\"උපගත්‍ය ජනානේතාන් ත්වං භාෂස්ව වචස්ත්විදං| කර්ණෛඃ ශ්‍රෝෂ්‍යථ යූයං හි කින්තු යූයං න භෝත්ස්‍යථ| නේත්‍රෛ ර්ද්‍රක්‍ෂ්‍යථ යූයඤ්ච ඥාතුං යූයං න ශක්‍ෂ්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","තේ මානුෂා යථා නේත්‍රෛඃ පරිපශ්‍යන්ති නෛව හි| කර්ණෛඃ ර‍්‍යථා න ශෘණ්වන්ති බුධ්‍යන්තේ න ච මානසෛඃ| ව්‍යාවර්ත්තයත්සු චිත්තානි කාලේ කුත්‍රාපි තේෂු වෛ| මත්තස්තේ මනුජාඃ ස්වස්ථා යථා නෛව භවන්ති ච| තථා තේෂාං මනුෂ්‍යාණාං සන්ති ස්ථූලා හි බුද්ධයඃ| බධිරීභූතකර්ණාශ්ච ජාතාශ්ච මුද්‍රිතා දෘශඃ|| ");
INSERT INTO sansin_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","අත ඊශ්වරාද් යත් පරිත්‍රාණං තස්‍ය වාර්ත්තා භින්නදේශීයානාං සමීපං ප්‍රේෂිතා තඒව තාං ග්‍රහීෂ්‍යන්තීති යූයං ජානීත| ");
INSERT INTO sansin_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","ඒතාදෘශ්‍යාං කථායාං කථිතායාං සත්‍යාං යිහූදිනඃ පරස්පරං බහුවිචාරං කුර්ව්වන්තෝ ගතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","ඉත්ථං පෞලඃ සම්පූර්ණං වත්සරද්වයං යාවද් භාටකීයේ වාසගෘහේ වසන් යේ ලෝකාස්තස්‍ය සන්නිධිම් ආගච්ඡන්ති තාන් සර්ව්වානේව පරිගෘහ්ලන්, ");
INSERT INTO sansin_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","නිර්විඝ්නම් අතිශයනිඃක්‍ෂෝභම් ඊශ්වරීයරාජත්වස්‍ය කථාං ප්‍රචාරයන් ප්‍රභෞ යීශෞ ඛ්‍රීෂ්ටේ කථාඃ සමුපාදිශත්| ඉති||");
INSERT INTO sansin_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","ඊශ්වරෝ නිජපුත්‍රමධි යං සුසංවාදං භවිෂ්‍යද්වාදිභි ර්ධර්ම්මග්‍රන්ථේ ප්‍රතිශ්‍රුතවාන් තං සුසංවාදං ප්‍රචාරයිතුං පෘථක්කෘත ආහූතඃ ප්‍රේරිතශ්ච ප්‍රභෝ ර‍්‍යීශුඛ්‍රීෂ්ටස්‍ය සේවකෝ යඃ පෞලඃ ");
INSERT INTO sansin_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","ස රෝමානගරස්ථාන් ඊශ්වරප්‍රියාන් ආහූතාංශ්ච පවිත්‍රලෝකාන් ප්‍රති පත්‍රං ලිඛති| ");
INSERT INTO sansin_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","අස්මාකං ස ප්‍රභු ර‍්‍යීශුඃ ඛ්‍රීෂ්ටඃ ශාරීරිකසම්බන්ධේන දායූදෝ වංශෝද්භවඃ ");
INSERT INTO sansin_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","පවිත්‍රස්‍යාත්මනඃ සම්බන්ධේන චේශ්වරස්‍ය ප්‍රභාවවාන් පුත්‍ර ඉති ශ්මශානාත් තස්‍යෝත්ථානේන ප්‍රතිපන්නං| ");
INSERT INTO sansin_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","අපරං යේෂාං මධ්‍යේ යීශුනා ඛ්‍රීෂ්ටේන යූයමප්‍යාහූතාස්තේ (අ)න්‍යදේශීයලෝකාස්තස්‍ය නාම්නි විශ්වස්‍ය නිදේශග්‍රාහිණෝ යථා භවන්ති ");
INSERT INTO sansin_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","තදභිප්‍රායේණ වයං තස්මාද් අනුග්‍රහං ප්‍රේරිතත්වපදඤ්ච ප්‍රාප්තාඃ| ");
INSERT INTO sansin_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","තාතේනාස්මාකම් ඊශ්වරේණ ප්‍රභුණා යීශුඛ්‍රීෂ්ටේන ච යුෂ්මභ්‍යම් අනුග්‍රහඃ ශාන්තිශ්ච ප්‍රදීයේතාං| ");
INSERT INTO sansin_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","ප්‍රථමතඃ සර්ව්වස්මින් ජගති යුෂ්මාකං විශ්වාසස්‍ය ප්‍රකාශිතත්වාද් අහං යුෂ්මාකං සර්ව්වේෂාං නිමිත්තං යීශුඛ්‍රීෂ්ටස්‍ය නාම ගෘහ්ලන් ඊශ්වරස්‍ය ධන්‍යවාදං කරෝමි| ");
INSERT INTO sansin_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","අපරම් ඊශ්වරස්‍ය ප්‍රසාදාද් බහුකාලාත් පරං සාම්ප්‍රතං යුෂ්මාකං සමීපං යාතුං කථමපි යත් සුයෝගං ප්‍රාප්නෝමි, ඒතදර්ථං නිරන්තරං නාමාන්‍යුච්චාරයන් නිජාසු සර්ව්වප්‍රාර්ථනාසු සර්ව්වදා නිවේදයාමි, ");
INSERT INTO sansin_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ඒතස්මින් යමහං තත්පුත්‍රීයසුසංවාදප්‍රචාරණේන මනසා පරිචරාමි ස ඊශ්වරෝ මම සාක්‍ෂී විද්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","යතෝ යුෂ්මාකං මම ච විශ්වාසේන වයම් උභයේ යථා ශාන්තියුක්තා භවාම ඉති කාරණාද් ");
INSERT INTO sansin_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","යුෂ්මාකං ස්ථෛර‍්‍ය්‍යකරණාර්ථං යුෂ්මභ්‍යං කිඤ්චිත්පරමාර්ථදානදානාය යුෂ්මාන් සාක්‍ෂාත් කර්ත්තුං මදීයා වාඤ්ඡා| ");
INSERT INTO sansin_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","හේ භ්‍රාතෘගණ භින්නදේශීයලෝකානාං මධ්‍යේ යද්වත් තද්වද් යුෂ්මාකං මධ්‍යේපි යථා ඵලං භුඤ්ජේ තදභිප්‍රායේණ මුහුර්මුහු ර‍්‍යුෂ්මාකං සමීපං ගන්තුම් උද්‍යතෝ(අ)හං කින්තු යාවද් අද්‍ය තස්මින් ගමනේ මම විඝ්නෝ ජාත ඉති යූයං යද් අඥාතාස්තිෂ්ඨථ තදහම් උචිතං න බුධ්‍යේ| ");
INSERT INTO sansin_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","අහං සභ්‍යාසභ්‍යානාං විද්වදවිද්වතාඤ්ච සර්ව්වේෂාම් ඍණී විද්‍යේ| ");
INSERT INTO sansin_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","අතඒව රෝමානිවාසිනාං යුෂ්මාකං සමීපේ(අ)පි යථාශක්ති සුසංවාදං ප්‍රචාරයිතුම් අහම් උද්‍යතෝස්මි| ");
INSERT INTO sansin_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","යතඃ ඛ්‍රීෂ්ටස්‍ය සුසංවාදෝ මම ලජ්ජාස්පදං නහි ස ඊශ්වරස්‍ය ශක්තිස්වරූපඃ සන් ආ යිහූදීයේභ්‍යෝ (අ)න්‍යජාතීයාන් යාවත් සර්ව්වජාතීයානාං මධ්‍යේ යඃ කශ්චිද් තත්‍ර විශ්වසිති තස්‍යෛව ත්‍රාණං ජනයති| ");
INSERT INTO sansin_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","යතඃ ප්‍රත්‍යයස්‍ය සමපරිමාණම් ඊශ්වරදත්තං පුණ්‍යං තත්සුසංවාදේ ප්‍රකාශතේ| තදධි ධර්ම්මපුස්තකේපි ලිඛිතමිදං \"පුණ්‍යවාන් ජනෝ විශ්වාසේන ජීවිෂ්‍යති\"| ");
INSERT INTO sansin_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","අතඒව යේ මානවාඃ පාපකර්ම්මණා සත්‍යතාං රුන්ධන්ති තේෂාං සර්ව්වස්‍ය දුරාචරණස්‍යාධර්ම්මස්‍ය ච විරුද්ධං ස්වර්ගාද් ඊශ්වරස්‍ය කෝපඃ ප්‍රකාශතේ| ");
INSERT INTO sansin_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","යත ඊශ්වරමධි යද්‍යද් ඥේයං තද් ඊශ්වරඃ ස්වයං තාන් ප්‍රති ප්‍රකාශිතවාන් තස්මාත් තේෂාම් අගෝචරං නහි| ");
INSERT INTO sansin_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","ඵලතස්තස්‍යානන්තශක්තීශ්වරත්වාදීන්‍යදෘශ්‍යාන්‍යපි සෘෂ්ටිකාලම් ආරභ්‍ය කර්ම්මසු ප්‍රකාශමානානි දෘශ්‍යන්තේ තස්මාත් තේෂාං දෝෂප්‍රක්‍ෂාලනස්‍ය පන්ථා නාස්ති| ");
INSERT INTO sansin_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","අපරම් ඊශ්වරං ඥාත්වාපි තේ තම් ඊශ්වරඥානේන නාද්‍රියන්ත කෘතඥා වා න ජාතාඃ; තස්මාත් තේෂාං සර්ව්වේ තර්කා විඵලීභූතාඃ, අපරඤ්ච තේෂාං විවේකශූන්‍යානි මනාංසි තිමිරේ මග්නානි| ");
INSERT INTO sansin_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","තේ ස්වාන් ඥානිනෝ ඥාත්වා ඥානහීනා අභවන් ");
INSERT INTO sansin_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","අනශ්වරස්‍යේශ්වරස්‍ය ගෞරවං විහාය නශ්වරමනුෂ්‍යපශුපක්‍ෂ්‍යුරෝගාමිප්‍රභෘතේරාකෘතිවිශිෂ්ටප්‍රතිමාස්තෛරාශ්‍රිතාඃ| ");
INSERT INTO sansin_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","ඉත්ථං ත ඊශ්වරස්‍ය සත්‍යතාං විහාය මෘෂාමතම් ආශ්‍රිතවන්තඃ සච්චිදානන්දං සෘෂ්ටිකර්ත්තාරං ත්‍යක්ත්වා සෘෂ්ටවස්තුනඃ පූජාං සේවාඤ්ච කෘතවන්තඃ; ");
INSERT INTO sansin_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","ඉති හේතෝරීශ්වරස්තාන් කුක්‍රියායාං සමර්ප්‍ය නිජනිජකුචින්තාභිලාෂාභ්‍යාං ස්වං ස්වං ශරීරං පරස්පරම් අපමානිතං කර්ත්තුම් අදදාත්| ");
INSERT INTO sansin_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","ඊශ්වරේණ තේෂු ක්වභිලාෂේ සමර්පිතේෂු තේෂාං යෝෂිතඃ ස්වාභාවිකාචරණම් අපහාය විපරීතකෘත්‍යේ ප්‍රාවර්ත්තන්ත; ");
INSERT INTO sansin_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","තථා පුරුෂා අපි ස්වාභාවිකයෝෂිත්සඞ්ගමං විහාය පරස්පරං කාමකෘශානුනා දග්ධාඃ සන්තඃ පුමාංසඃ පුංභිඃ සාකං කුකෘත්‍යේ සමාසජ්‍ය නිජනිජභ්‍රාන්තේඃ සමුචිතං ඵලම් අලභන්ත| ");
INSERT INTO sansin_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","තේ ස්වේෂාං මනඃස්වීශ්වරාය ස්ථානං දාතුම් අනිච්ඡුකාස්තතෝ හේතෝරීශ්වරස්තාන් ප්‍රති දුෂ්ටමනස්කත්වම් අවිහිතක්‍රියත්වඤ්ච දත්තවාන්| ");
INSERT INTO sansin_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","අතඒව තේ සර්ව්වේ (අ)න්‍යායෝ ව්‍යභිචාරෝ දුෂ්ටත්වං ලෝභෝ ජිඝාංසා ඊර්ෂ්‍යා වධෝ විවාදශ්චාතුරී කුමතිරිත්‍යාදිභි ර්දුෂ්කර්ම්මභිඃ පරිපූර්ණාඃ සන්තඃ ");
INSERT INTO sansin_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","කර්ණේජපා අපවාදින ඊශ්වරද්වේෂකා හිංසකා අහඞ්කාරිණ ආත්මශ්ලාඝිනඃ කුකර්ම්මෝත්පාදකාඃ පිත්‍රෝරාඥාලඞ්ඝකා ");
INSERT INTO sansin_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","අවිචාරකා නියමලඞ්ඝිනඃ ස්නේහරහිතා අතිද්වේෂිණෝ නිර්දයාශ්ච ජාතාඃ| ");
INSERT INTO sansin_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","යේ ජනා ඒතාදෘශං කර්ම්ම කුර්ව්වන්ති තඒව මෘතියෝග්‍යා ඊශ්වරස්‍ය විචාරමීදෘශං ඥාත්වාපි ත ඒතාදෘශං කර්ම්ම ස්වයං කුර්ව්වන්ති කේවලමිති නහි කින්තු තාදෘශකර්ම්මකාරිෂු ලෝකේෂ්වපි ප්‍රීයන්තේ| ");
INSERT INTO sansin_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","හේ පරදූෂක මනුෂ්‍ය යඃ කශ්චන ත්වං භවසි තවෝත්තරදානාය පන්ථා නාස්ති යතෝ යස්මාත් කර්ම්මණඃ පරස්ත්වයා දූෂ්‍යතේ තස්මාත් ත්වමපි දූෂ්‍යසේ, යතස්තං දූෂයන්නපි ත්වං තද්වද් ආචරසි| ");
INSERT INTO sansin_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","කින්ත්වේතාදෘගාචාරිභ්‍යෝ යං දණ්ඩම් ඊශ්වරෝ නිශ්චිනෝති ස යථාර්ථ ඉති වයං ජානීමඃ| ");
INSERT INTO sansin_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","අතඒව හේ මානුෂ ත්වං යාදෘගාචාරිණෝ දූෂයසි ස්වයං යදි තාදෘගාචරසි තර්හි ත්වම් ඊශ්වරදණ්ඩාත් පලායිතුං ශක්‍ෂ්‍යසීති කිං බුධ්‍යසේ? ");
INSERT INTO sansin_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","අපරං තව මනසඃ පරිවර්ත්තනං කර්ත්තුම් ඉශ්වරස්‍යානුග්‍රහෝ භවති තන්න බුද්ධ්වා ත්වං කිං තදීයානුග්‍රහක්‍ෂමාචිරසහිෂ්ණුත්වනිධිං තුච්ඡීකරෝෂි? ");
INSERT INTO sansin_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","තථා ස්වාන්තඃකරණස්‍ය කඨෝරත්වාත් ඛේදරාහිත්‍යාච්චේශ්වරස්‍ය න්‍යාය්‍යවිචාරප්‍රකාශනස්‍ය ක්‍රෝධස්‍ය ච දිනං යාවත් කිං ස්වාර්ථං කෝපං සඤ්චිනෝෂි? ");
INSERT INTO sansin_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","කින්තු ස ඒකෛකමනුජාය තත්කර්ම්මානුසාරේණ ප්‍රතිඵලං දාස්‍යති; ");
INSERT INTO sansin_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","වස්තුතස්තු යේ ජනා ධෛර‍්‍ය්‍යං ධෘත්වා සත්කර්ම්ම කුර්ව්වන්තෝ මහිමා සත්කාරෝ(අ)මරත්වඤ්චෛතානි මෘගයන්තේ තේභ්‍යෝ(අ)නන්තායු ර්දාස්‍යති| ");
INSERT INTO sansin_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","අපරං යේ ජනාඃ සත්‍යධර්ම්මම් අගෘහීත්වා විපරීතධර්ම්මම් ගෘහ්ලන්ති තාදෘශා විරෝධිජනාඃ කෝපං ක්‍රෝධඤ්ච භෝක්‍ෂ්‍යන්තේ| ");
INSERT INTO sansin_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","ආ යිහූදිනෝ(අ)න්‍යදේශිනඃ පර‍්‍ය්‍යන්තං යාවන්තඃ කුකර්ම්මකාරිණඃ ප්‍රාණිනඃ සන්ති තේ සර්ව්වේ දුඃඛං යාතනාඤ්ච ගමිෂ්‍යන්ති; ");
INSERT INTO sansin_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","කින්තු ආ යිහූදිනෝ භින්නදේශිපර‍්‍ය්‍යන්තා යාවන්තඃ සත්කර්ම්මකාරිණෝ ලෝකාඃ සන්ති තාන් ප්‍රති මහිමා සත්කාරඃ ශාන්තිශ්ච භවිෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","ඊශ්වරස්‍ය විචාරේ පක්‍ෂපාතෝ නාස්ති| ");
INSERT INTO sansin_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","අලබ්ධව්‍යවස්ථාශාස්ත්‍රෛ ර‍්‍යෛඃ පාපානි කෘතානි ව්‍යවස්ථාශාස්ත්‍රාලබ්ධත්වානුරූපස්තේෂාං විනාශෝ භවිෂ්‍යති; කින්තු ලබ්ධව්‍යවස්ථාශාස්ත්‍රා යේ පාපාන්‍යකුර්ව්වන් ව්‍යවස්ථානුසාරාදේව තේෂාං විචාරෝ භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","ව්‍යවස්ථාශ්‍රෝතාර ඊශ්වරස්‍ය සමීපේ නිෂ්පාපා භවිෂ්‍යන්තීති නහි කින්තු ව්‍යවස්ථාචාරිණ ඒව සපුණ්‍යා භවිෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","යතෝ (අ)ලබ්ධව්‍යවස්ථාශාස්ත්‍රා භින්නදේශීයලෝකා යදි ස්වභාවතෝ ව්‍යවස්ථානුරූපාන් ආචාරාන් කුර්ව්වන්ති තර්හ්‍යලබ්ධශාස්ත්‍රාඃ සන්තෝ(අ)පි තේ ස්වේෂාං ව්‍යවස්ථාශාස්ත්‍රමිව ස්වයමේව භවන්ති| ");
INSERT INTO sansin_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","තේෂාං මනසි සාක්‍ෂිස්වරූපේ සති තේෂාං විතර්කේෂු ච කදා තාන් දෝෂිණඃ කදා වා නිර්දෝෂාන් කෘතවත්සු තේ ස්වාන්තර්ලිඛිතස්‍ය ව්‍යවස්ථාශාස්ත්‍රස්‍ය ප්‍රමාණං ස්වයමේව දදති| ");
INSERT INTO sansin_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","යස්මින් දිනේ මයා ප්‍රකාශිතස්‍ය සුසංවාදස්‍යානුසාරාද් ඊශ්වරෝ යීශුඛ්‍රීෂ්ටේන මානුෂාණාම් අන්තඃකරණානාං ගූඪාභිප්‍රායාන් ධෘත්වා විචාරයිෂ්‍යති තස්මින් විචාරදිනේ තත් ප්‍රකාශිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","පශ්‍ය ත්වං ස්වයං යිහූදීති විඛ්‍යාතෝ ව්‍යවස්ථෝපරි විශ්වාසං කරෝෂි, ");
INSERT INTO sansin_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ඊශ්වරමුද්දිශ්‍ය ස්වං ශ්ලාඝසේ, තථා ව්‍යවස්ථයා ශික්‍ෂිතෝ භූත්වා තස්‍යාභිමතං ජානාසි, සර්ව්වාසාං කථානාං සාරං විවිංක්‍ෂේ, ");
INSERT INTO sansin_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","අපරං ඥානස්‍ය සත්‍යතායාශ්චාකරස්වරූපං ශාස්ත්‍රං මම සමීපේ විද්‍යත අතෝ (අ)න්ධලෝකානාං මාර්ගදර්ශයිතා ");
INSERT INTO sansin_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","තිමිරස්ථිතලෝකානාං මධ්‍යේ දීප්තිස්වරූපෝ(අ)ඥානලෝකේභ්‍යෝ ඥානදාතා ශිශූනාං ශික්‍ෂයිතාහමේවේති මන්‍යසේ| ");
INSERT INTO sansin_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","පරාන් ශික්‍ෂයන් ස්වයං ස්වං කිං න ශික්‍ෂයසි? වස්තුතශ්චෞර‍්‍ය්‍යනිෂේධව්‍යවස්ථාං ප්‍රචාරයන් ත්වං කිං ස්වයමේව චෝරයසි? ");
INSERT INTO sansin_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","තථා පරදාරගමනං ප්‍රතිෂේධන් ස්වයං කිං පරදාරාන් ගච්ඡසි? තථා ත්වං ස්වයං ප්‍රතිමාද්වේෂී සන් කිං මන්දිරස්‍ය ද්‍රව්‍යාණි හරසි? ");
INSERT INTO sansin_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","යස්ත්වං ව්‍යවස්ථාං ශ්ලාඝසේ ස ත්වං කිං ව්‍යවස්ථාම් අවමත්‍ය නේශ්වරං සම්මන්‍යසේ? ");
INSERT INTO sansin_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","ශාස්ත්‍රේ යථා ලිඛති \"භින්නදේශිනාං සමීපේ යුෂ්මාකං දෝෂාද් ඊශ්වරස්‍ය නාම්නෝ නින්දා භවති| \" ");
INSERT INTO sansin_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","යදි ව්‍යවස්ථාං පාලයසි තර්හි තව ත්වක්ඡේදක්‍රියා සඵලා භවති; යති ව්‍යවස්ථාං ලඞ්ඝසේ තර්හි තව ත්වක්ඡේදෝ(අ)ත්වක්ඡේදෝ භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","යතෝ ව්‍යවස්ථාශාස්ත්‍රාදිෂ්ටධර්ම්මකර්ම්මාචාරී පුමාන් අත්වක්ඡේදී සන්නපි කිං ත්වක්ඡේදිනාං මධ්‍යේ න ගණයිෂ්‍යතේ? ");
INSERT INTO sansin_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","කින්තු ලබ්ධශාස්ත්‍රශ්ඡින්නත්වක් ච ත්වං යදි ව්‍යවස්ථාලඞ්ඝනං කරෝෂි තර්හි ව්‍යවස්ථාපාලකාඃ ස්වාභාවිකාච්ඡින්නත්වචෝ ලෝකාස්ත්වාං කිං න දූෂයිෂ්‍යන්ති? ");
INSERT INTO sansin_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","තස්මාද් යෝ බාහ්‍යේ යිහූදී ස යිහූදී නහි තථාඞ්ගස්‍ය යස්ත්වක්ඡේදඃ ස ත්වක්ඡේදෝ නහි; ");
INSERT INTO sansin_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","කින්තු යෝ ජන ආන්තරිකෝ යිහූදී ස ඒව යිහූදී අපරඤ්ච කේවලලිඛිතයා ව්‍යවස්ථයා න කින්තු මානසිකෝ යස්ත්වක්ඡේදෝ යස්‍ය ච ප්‍රශංසා මනුෂ්‍යේභ්‍යෝ න භූත්වා ඊශ්වරාද් භවති ස ඒව ත්වක්ඡේදඃ| ");
INSERT INTO sansin_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","අපරඤ්ච යිහූදිනඃ කිං ශ්‍රේෂ්ඨත්වං? තථා ත්වක්ඡේදස්‍ය වා කිං ඵලං? ");
INSERT INTO sansin_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","සර්ව්වථා බහූනි ඵලානි සන්ති, විශේෂත ඊශ්වරස්‍ය ශාස්ත්‍රං තේභ්‍යෝ(අ)දීයත| ");
INSERT INTO sansin_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","කෛශ්චිද් අවිශ්වසනේ කෘතේ තේෂාම් අවිශ්වසනාත් කිම් ඊශ්වරස්‍ය විශ්වාස්‍යතායා හානිරුත්පත්ස්‍යතේ? ");
INSERT INTO sansin_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","කේනාපි ප්‍රකාරේණ නහි| යද්‍යපි සර්ව්වේ මනුෂ්‍යා මිථ්‍යාවාදිනස්තථාපීශ්වරඃ සත්‍යවාදී| ශාස්ත්‍රේ යථා ලිඛිතමාස්තේ, අතස්ත්වන්තු ස්වවාක්‍යේන නිර්ද්දෝෂෝ හි භවිෂ්‍යසි| විචාරේ චෛව නිෂ්පාපෝ භවිෂ්‍යසි න සංශයඃ| ");
INSERT INTO sansin_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","අස්මාකම් අන්‍යායේන යදීශ්වරස්‍ය න්‍යායඃ ප්‍රකාශතේ තර්හි කිං වදිෂ්‍යාමඃ? අහං මානුෂාණාං කථාමිව කථාං කථයාමි, ඊශ්වරඃ සමුචිතං දණ්ඩං දත්ත්වා කිම් අන්‍යායී භවිෂ්‍යති? ");
INSERT INTO sansin_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","ඉත්ථං න භවතු, තථා සතීශ්වරඃ කථං ජගතෝ විචාරයිතා භවිෂ්‍යති? ");
INSERT INTO sansin_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","මම මිථ්‍යාවාක්‍යවදනාද් යදීශ්වරස්‍ය සත්‍යත්වේන තස්‍ය මහිමා වර්ද්ධතේ තර්හි කස්මාදහං විචාරේ(අ)පරාධිත්වේන ගණ්‍යෝ භවාමි? ");
INSERT INTO sansin_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","මඞ්ගලාර්ථං පාපමපි කරණීයමිති වාක්‍යං ත්වයා කුතෝ නෝච්‍යතේ? කින්තු යෛරුච්‍යතේ තේ නිතාන්තං දණ්ඩස්‍ය පාත්‍රාණි භවන්ති; තථාපි තද්වාක්‍යම් අස්මාභිරප්‍යුච්‍යත ඉත්‍යස්මාකං ග්ලානිං කුර්ව්වන්තඃ කියන්තෝ ලෝකා වදන්ති| ");
INSERT INTO sansin_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","අන්‍යලෝකේභ්‍යෝ වයං කිං ශ්‍රේෂ්ඨාඃ? කදාචන නහි යතෝ යිහූදිනෝ (අ)න්‍යදේශිනශ්ච සර්ව්වඒව පාපස්‍යායත්තා ඉත්‍යස්‍ය ප්‍රමාණං වයං පූර්ව්වම් අදදාම| ");
INSERT INTO sansin_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","ලිපි ර‍්‍යථාස්තේ, නෛකෝපි ධාර්ම්මිකෝ ජනඃ| ");
INSERT INTO sansin_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","තථා ඥානීශ්වරඥානී මානවඃ කෝපි නාස්ති හි| ");
INSERT INTO sansin_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","විමාර්ගගාමිනඃ සර්ව්වේ සර්ව්වේ දුෂ්කර්ම්මකාරිණඃ| ඒකෝ ජනෝපි නෝ තේෂාං සාධුකර්ම්ම කරෝති ච| ");
INSERT INTO sansin_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","තථා තේෂාන්තු වෛ කණ්ඨා අනාවෘතශ්මශානවත්| ස්තුතිවාදං ප්‍රකුර්ව්වන්ති ජිහ්වාභිස්තේ තු කේවලං| තේෂාමෝෂ්ඨස්‍ය නිම්නේ තු විෂං තිෂ්ඨති සර්ප්පවත්| ");
INSERT INTO sansin_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","මුඛං තේෂාං හි ශාපේන කපටේන ච පූර‍්‍ය්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","රක්තපාතාය තේෂාං තු පදානි ක්‍ෂිප්‍රගානි ච| ");
INSERT INTO sansin_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","පථි තේෂාං මනුෂ්‍යාණාං නාශඃ ක්ලේශශ්ච කේවලඃ| ");
INSERT INTO sansin_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","තේ ජනා නහි ජානන්ති පන්ථානං සුඛදායිනං| ");
INSERT INTO sansin_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","පරමේශාද් භයං යත්තත් තච්චක්‍ෂුෂෝරගෝචරං| ");
INSERT INTO sansin_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","ව්‍යවස්ථායාං යද්‍යල්ලිඛති තද් ව්‍යවස්ථාධීනාන් ලෝකාන් උද්දිශ්‍ය ලිඛතීති වයං ජානීමඃ| තතෝ මනුෂ්‍යමාත්‍රෝ නිරුත්තරඃ සන් ඊශ්වරස්‍ය සාක්‍ෂාද් අපරාධී භවති| ");
INSERT INTO sansin_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","අතඒව ව්‍යවස්ථානුරූපෛඃ කර්ම්මභිඃ කශ්චිදපි ප්‍රාණීශ්වරස්‍ය සාක්‍ෂාත් සපුණ්‍යීකෘතෝ භවිතුං න ශක්‍ෂ්‍යති යතෝ ව්‍යවස්ථයා පාපඥානමාත්‍රං ජායතේ| ");
INSERT INTO sansin_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","කින්තු ව්‍යවස්ථායාඃ පෘථග් ඊශ්වරේණ දේයං යත් පුණ්‍යං තද් ව්‍යවස්ථායා භවිෂ්‍යද්වාදිගණස්‍ය ච වචනෛඃ ප්‍රමාණීකෘතං සද් ඉදානීං ප්‍රකාශතේ| ");
INSERT INTO sansin_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","යීශුඛ්‍රීෂ්ටේ විශ්වාසකරණාද් ඊශ්වරේණ දත්තං තත් පුණ්‍යං සකලේෂු ප්‍රකාශිතං සත් සර්ව්වාන් විශ්වාසිනඃ ප්‍රති වර්ත්තතේ| ");
INSERT INTO sansin_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","තේෂාං කෝපි ප්‍රභේදෝ නාස්ති, යතඃ සර්ව්වඒව පාපින ඊශ්වරීයතේජෝහීනාශ්ච ජාතාඃ| ");
INSERT INTO sansin_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","ත ඊශ්වරස්‍යානුග්‍රහාද් මූල්‍යං විනා ඛ්‍රීෂ්ටකෘතේන පරිත්‍රාණේන සපුණ්‍යීකෘතා භවන්ති| ");
INSERT INTO sansin_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","යස්මාත් ස්වශෝණිතේන විශ්වාසාත් පාපනාශකෝ බලී භවිතුං ස ඒව පූර්ව්වම් ඊශ්වරේණ නිශ්චිතඃ, ඉත්ථම් ඊශ්වරීයසහිෂ්ණුත්වාත් පුරාකෘතපාපානාං මාර්ජ්ජනකරණේ ස්වීයයාථාර්ථ්‍යං තේන ප්‍රකාශ්‍යතේ, ");
INSERT INTO sansin_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","වර්ත්තමානකාලීයමපි ස්වයාථාර්ථ්‍යං තේන ප්‍රකාශ්‍යතේ, අපරං යීශෞ විශ්වාසිනං සපුණ්‍යීකුර්ව්වන්නපි ස යාථාර්ථිකස්තිෂ්ඨති| ");
INSERT INTO sansin_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","තර්හි කුත්‍රාත්මශ්ලාඝා? සා දූරීකෘතා; කයා ව්‍යවස්ථයා? කිං ක්‍රියාරූපව්‍යවස්ථයා? ඉත්ථං නහි කින්තු තත් කේවලවිශ්වාසරූපයා ව්‍යවස්ථයෛව භවති| ");
INSERT INTO sansin_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","අතඒව ව්‍යවස්ථානුරූපාඃ ක්‍රියා විනා කේවලේන විශ්වාසේන මානවඃ සපුණ්‍යීකෘතෝ භවිතුං ශක්නෝතීත්‍යස්‍ය රාද්ධාන්තං දර්ශයාමඃ| ");
INSERT INTO sansin_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","ස කිං කේවලයිහූදිනාම් ඊශ්වරෝ භවති? භින්නදේශිනාම් ඊශ්වරෝ න භවති? භින්නදේශිනාමපි භවති; ");
INSERT INTO sansin_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","යස්මාද් ඒක ඊශ්වරෝ විශ්වාසාත් ත්වක්ඡේදිනෝ විශ්වාසේනාත්වක්ඡේදිනශ්ච සපුණ්‍යීකරිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","තර්හි විශ්වාසේන වයං කිං ව්‍යවස්ථාං ලුම්පාම? ඉත්ථං න භවතු වයං ව්‍යවස්ථාං සංස්ථාපයාම ඒව| ");
INSERT INTO sansin_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","අස්මාකං පූර්ව්වපුරුෂ ඉබ්‍රාහීම් කායිකක්‍රියයා කිං ලබ්ධවාන් ඒතදධි කිං වදිෂ්‍යාමඃ? ");
INSERT INTO sansin_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","ස යදි නිජක්‍රියාභ්‍යඃ සපුණ්‍යෝ භවේත් තර්හි තස්‍යාත්මශ්ලාඝාං කර්ත්තුං පන්ථා භවේදිති සත්‍යං, කින්ත්වීශ්වරස්‍ය සමීපේ නහි| ");
INSERT INTO sansin_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","ශාස්ත්‍රේ කිං ලිඛති? ඉබ්‍රාහීම් ඊශ්වරේ විශ්වසනාත් ස විශ්වාසස්තස්මෛ පුණ්‍යාර්ථං ගණිතෝ බභූව| ");
INSERT INTO sansin_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","කර්ම්මකාරිණෝ යද් වේතනං තද් අනුග්‍රහස්‍ය ඵලං නහි කින්තු තේනෝපාර්ජිතං මන්තව්‍යම්| ");
INSERT INTO sansin_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","කින්තු යඃ පාපිනං සපුණ්‍යීකරෝති තස්මින් විශ්වාසිනඃ කර්ම්මහීනස්‍ය ජනස්‍ය යෝ විශ්වාසඃ ස පුණ්‍යාර්ථං ගණ්‍යෝ භවති| ");
INSERT INTO sansin_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","අපරං යං ක්‍රියාහීනම් ඊශ්වරඃ සපුණ්‍යීකරෝති තස්‍ය ධන්‍යවාදං දායූද් වර්ණයාමාස, යථා, ");
INSERT INTO sansin_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","ස ධන්‍යෝ(අ)ඝානි මෘෂ්ටානි යස්‍යාගාංස්‍යාවෘතානි ච| ");
INSERT INTO sansin_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","ස ච ධන්‍යඃ පරේශේන පාපං යස්‍ය න ගණ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","ඒෂ ධන්‍යවාදස්ත්වක්ඡේදිනම් අත්වක්ඡේදිනං වා කං ප්‍රති භවති? ඉබ්‍රාහීමෝ විශ්වාසඃ පුණ්‍යාර්ථං ගණිත ඉති වයං වදාමඃ| ");
INSERT INTO sansin_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","ස විශ්වාසස්තස්‍ය ත්වක්ඡේදිත්වාවස්ථායාං කිම් අත්වක්ඡේදිත්වාවස්ථායාං කස්මින් සමයේ පුණ්‍යමිව ගණිතඃ? ත්වක්ඡේදිත්වාවස්ථායාං නහි කින්ත්වත්වක්ඡේදිත්වාවස්ථායාං| ");
INSERT INTO sansin_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","අපරඤ්ච ස යත් සර්ව්වේෂාම් අත්වක්ඡේදිනාං විශ්වාසිනාම් ආදිපුරුෂෝ භවේත්, තේ ච පුණ්‍යවත්ත්වේන ගණ්‍යේරන්; ");
INSERT INTO sansin_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","යේ ච ලෝකාඃ කේවලං ඡින්නත්වචෝ න සන්තෝ (අ)ස්මත්පූර්ව්වපුරුෂ ඉබ්‍රාහීම් අඡින්නත්වක් සන් යේන විශ්වාසමාර්ගේණ ගතවාන් තේනෛව තස්‍ය පාදචිහ්නේන ගච්ඡන්ති තේෂාං ත්වක්ඡේදිනාමප්‍යාදිපුරුෂෝ භවේත් තදර්ථම් අත්වක්ඡේදිනෝ මානවස්‍ය විශ්වාසාත් පුණ්‍යම් උත්පද්‍යත ඉති ප්‍රමාණස්වරූපං ත්වක්ඡේදචිහ්නං ස ප්‍රාප්නෝත්| ");
INSERT INTO sansin_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","ඉබ්‍රාහීම් ජගතෝ(අ)ධිකාරී භවිෂ්‍යති යෛෂා ප්‍රතිඥා තං තස්‍ය වංශඤ්ච ප්‍රති පූර්ව්වම් අක්‍රියත සා ව්‍යවස්ථාමූලිකා නහි කින්තු විශ්වාසජන්‍යපුණ්‍යමූලිකා| ");
INSERT INTO sansin_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","යතෝ ව්‍යවස්ථාවලම්බිනෝ යද්‍යධිකාරිණෝ භවන්ති තර්හි විශ්වාසෝ විඵලෝ ජායතේ සා ප්‍රතිඥාපි ලුප්තෛව| ");
INSERT INTO sansin_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","අධිකන්තු ව්‍යවස්ථා කෝපං ජනයති යතෝ (අ)විද්‍යමානායාං ව්‍යවස්ථායාම් ආඥාලඞ්ඝනං න සම්භවති| ");
INSERT INTO sansin_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","අතඒව සා ප්‍රතිඥා යද් අනුග්‍රහස්‍ය ඵලං භවේත් තදර්ථං විශ්වාසමූලිකා යතස්තථාත්වේ තද්වංශසමුදායං ප්‍රති අර්ථතෝ යේ ව්‍යවස්ථයා තද්වංශසම්භවාඃ කේවලං තාන් ප්‍රති නහි කින්තු ය ඉබ්‍රාහීමීයවිශ්වාසේන තත්සම්භවාස්තානපි ප්‍රති සා ප්‍රතිඥා ස්ථාස්නුර්භවති| ");
INSERT INTO sansin_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","යෝ නිර්ජීවාන් සජීවාන් අවිද්‍යමානානි වස්තූනි ච විද්‍යමානානි කරෝති ඉබ්‍රාහීමෝ විශ්වාසභූමේස්තස්‍යේශ්වරස්‍ය සාක්‍ෂාත් සෝ(අ)ස්මාකං සර්ව්වේෂාම් ආදිපුරුෂ ආස්තේ, යථා ලිඛිතං විද්‍යතේ, අහං ත්වාං බහුජාතීනාම් ආදිපුරුෂං කෘත්වා නියුක්තවාන්| ");
INSERT INTO sansin_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","ත්වදීයස්තාදෘශෝ වංශෝ ජනිෂ්‍යතේ යදිදං වාක්‍යං ප්‍රතිශ්‍රුතං තදනුසාරාද් ඉබ්‍රාහීම් බහුදේශීයලෝකානාම් ආදිපුරුෂෝ යද් භවති තදර්ථං සෝ(අ)නපේක්‍ෂිතව්‍යමප්‍යපේක්‍ෂමාණෝ විශ්වාසං කෘතවාන්| ");
INSERT INTO sansin_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","අපරඤ්ච ක්‍ෂීණවිශ්වාසෝ න භූත්වා ශතවත්සරවයස්කත්වාත් ස්වශරීරස්‍ය ජරාං සාරානාම්නඃ ස්වභාර‍්‍ය්‍යායා රජෝනිවෘත්තිඤ්ච තෘණාය න මේනේ| ");
INSERT INTO sansin_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","අපරම් අවිශ්වාසාද් ඊශ්වරස්‍ය ප්‍රතිඥාවචනේ කමපි සංශයං න චකාර; ");
INSERT INTO sansin_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","කින්ත්වීශ්වරේණ යත් ප්‍රතිශ්‍රුතං තත් සාධයිතුං ශක්‍යත ඉති නිශ්චිතං විඥාය දෘඪවිශ්වාසඃ සන් ඊශ්වරස්‍ය මහිමානං ප්‍රකාශයාඤ්චකාර| ");
INSERT INTO sansin_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","ඉති හේතෝස්තස්‍ය ස විශ්වාසස්තදීයපුණ්‍යමිව ගණයාඤ්චක්‍රේ| ");
INSERT INTO sansin_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","පුණ්‍යමිවාගණ්‍යත තත් කේවලස්‍ය තස්‍ය නිමිත්තං ලිඛිතං නහි, අස්මාකං නිමිත්තමපි, ");
INSERT INTO sansin_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","යතෝ(අ)ස්මාකං පාපනාශාර්ථං සමර්පිතෝ(අ)ස්මාකං පුණ්‍යප්‍රාප්ත්‍යර්ථඤ්චෝත්ථාපිතෝ(අ)භවත් යෝ(අ)ස්මාකං ප්‍රභු ර‍්‍යීශුස්තස්‍යෝත්ථාපයිතරීශ්වරේ ");
INSERT INTO sansin_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","යදි වයං විශ්වසාමස්තර්හ්‍යස්මාකමපි සඒව විශ්වාසඃ පුණ්‍යමිව ගණයිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","විශ්වාසේන සපුණ්‍යීකෘතා වයම් ඊශ්වරේණ සාර්ද්ධං ප්‍රභුණාස්මාකං යීශුඛ්‍රීෂ්ටේන මේලනං ප්‍රාප්තාඃ| ");
INSERT INTO sansin_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","අපරං වයං යස්මින් අනුග්‍රහාශ්‍රයේ තිෂ්ඨාමස්තන්මධ්‍යං විශ්වාසමාර්ගේණ තේනෛවානීතා වයම් ඊශ්වරීයවිභවප්‍රාප්තිප්‍රත්‍යාශයා සමානන්දාමඃ| ");
INSERT INTO sansin_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","තත් කේවලං නහි කින්තු ක්ලේශභෝගේ(අ)ප්‍යානන්දාමෝ යතඃ ක්ලේශාाද් ධෛර‍්‍ය්‍යං ජායත ඉති වයං ජානීමඃ, ");
INSERT INTO sansin_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ධෛර‍්‍ය්‍යාච්ච පරීක්‍ෂිතත්වං ජායතේ, පරීක්‍ෂිතත්වාත් ප්‍රත්‍යාශා ජායතේ, ");
INSERT INTO sansin_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","ප්‍රත්‍යාශාතෝ ව්‍රීඩිතත්වං න ජායතේ, යස්මාද් අස්මභ්‍යං දත්තේන පවිත්‍රේණාත්මනාස්මාකම් අන්තඃකරණානීශ්වරස්‍ය ප්‍රේමවාරිණා සික්තානි| ");
INSERT INTO sansin_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","අස්මාසු නිරුපායේෂු සත්සු ඛ්‍රීෂ්ට උපයුක්තේ සමයේ පාපිනාං නිමිත්තං ස්වීයාන් ප්‍රණාන් අත්‍යජත්| ");
INSERT INTO sansin_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","හිතකාරිණෝ ජනස්‍ය කෘතේ කෝපි ප්‍රණාන් ත්‍යක්තුං සාහසං කර්ත්තුං ශක්නෝති, කින්තු ධාර්ම්මිකස්‍ය කෘතේ ප්‍රායේණ කෝපි ප්‍රාණාන් න ත්‍යජති| ");
INSERT INTO sansin_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","කින්ත්වස්මාසු පාපිෂු සත්ස්වපි නිමිත්තමස්මාකං ඛ්‍රීෂ්ටඃ ස්වප්‍රාණාන් ත්‍යක්තවාන්, තත ඊශ්වරෝස්මාන් ප්‍රති නිජං පරමප්‍රේමාණං දර්ශිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","අතඒව තස්‍ය රක්තපාතේන සපුණ්‍යීකෘතා වයං නිතාන්තං තේන කෝපාද් උද්ධාරිෂ්‍යාමහේ| ");
INSERT INTO sansin_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","ඵලතෝ වයං යදා රිපව ආස්ම තදේශ්වරස්‍ය පුත්‍රස්‍ය මරණේන තේන සාර්ද්ධං යද්‍යස්මාකං මේලනං ජාතං තර්හි මේලනප්‍රාප්තාඃ සන්තෝ(අ)වශ්‍යං තස්‍ය ජීවනේන රක්‍ෂාං ලප්ස්‍යාමහේ| ");
INSERT INTO sansin_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","තත් කේවලං නහි කින්තු යේන මේලනම් අලභාමහි තේනාස්මාකං ප්‍රභුණා යීශුඛ්‍රීෂ්ටේන සාම්ප්‍රතම් ඊශ්වරේ සමානන්දාමශ්ච| ");
INSERT INTO sansin_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","තථා සති, ඒකේන මානුෂේණ පාපං පාපේන ච මරණං ජගතීං ප්‍රාවිශත් අපරං සර්ව්වේෂාං පාපිත්වාත් සර්ව්වේ මානුෂා මෘතේ ර්නිඝ්නා අභවත්| ");
INSERT INTO sansin_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","යතෝ ව්‍යවස්ථාදානසමයං යාවත් ජගති පාපම් ආසීත් කින්තු යත්‍ර ව්‍යවස්ථා න විද්‍යතේ තත්‍ර පාපස්‍යාපි ගණනා න විද්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","තථාප්‍යාදමා යාදෘශං පාපං කෘතං තාදෘශං පාපං යෛ ර්නාකාරි ආදමම් ආරභ්‍ය මූසාං යාවත් තේෂාමප්‍යුපරි මෘත්‍යූ රාජත්වම් අකරෝත් ස ආදම් භාව්‍යාදමෝ නිදර්ශනමේවාස්තේ| ");
INSERT INTO sansin_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","කින්තු පාපකර්ම්මණෝ යාදෘශෝ භාවස්තාදෘග් දානකර්ම්මණෝ භාවෝ න භවති යත ඒකස්‍ය ජනස්‍යාපරාධේන යදි බහූනාං මරණම් අඝටත තථාපීශ්වරානුග්‍රහස්තදනුග්‍රහමූලකං දානඤ්චෛකේන ජනේනාර්ථාද් යීශුනා ඛ්‍රීෂ්ටේන බහුෂු බාහුල්‍යාතිබාහුල්‍යේන ඵලති| ");
INSERT INTO sansin_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","අපරම් ඒකස්‍ය ජනස්‍ය පාපකර්ම්ම යාදෘක් ඵලයුක්තං දානකර්ම්ම තාදෘක් න භවති යතෝ විචාරකර්ම්මෛකං පාපම් ආරභ්‍ය දණ්ඩජනකං බභූව, කින්තු දානකර්ම්ම බහුපාපාන්‍යාරභ්‍ය පුණ්‍යජනකං බභූව| ");
INSERT INTO sansin_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","යත ඒකස්‍ය ජනස්‍ය පාපකර්ම්මතස්තේනෛකේන යදි මරණස්‍ය රාජත්වං ජාතං තර්හි යේ ජනා අනුග්‍රහස්‍ය බාහුල්‍යං පුණ්‍යදානඤ්ච ප්‍රාප්නුවන්ති ත ඒකේන ජනේන, අර්ථාත් යීශුඛ්‍රීෂ්ටේන, ජීවනේ රාජත්වම් අවශ්‍යං කරිෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","ඒකෝ(අ)පරාධෝ යද්වත් සර්ව්වමානවානාං දණ්ඩගාමී මාර්ගෝ (අ)භවත් තද්වද් ඒකං පුණ්‍යදානං සර්ව්වමානවානාං ජීවනයුක්තපුණ්‍යගාමී මාර්ග ඒව| ");
INSERT INTO sansin_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","අපරම් ඒකස්‍ය ජනස්‍යාඥාලඞ්ඝනාද් යථා බහවෝ (අ)පරාධිනෝ ජාතාස්තද්වද් ඒකස්‍යාඥාචරණාද් බහවඃ සපුණ්‍යීකෘතා භවන්ති| ");
INSERT INTO sansin_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","අධිකන්තු ව්‍යවස්ථාගමනාද් අපරාධස්‍ය බාහුල්‍යං ජාතං කින්තු යත්‍ර පාපස්‍ය බාහුල්‍යං තත්‍රෛව තස්මාද් අනුග්‍රහස්‍ය බාහුල්‍යම් අභවත්| ");
INSERT INTO sansin_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","තේන මෘත්‍යුනා යද්වත් පාපස්‍ය රාජත්වම් අභවත් තද්වද් අස්මාකං ප්‍රභුයීශුඛ්‍රීෂ්ටද්වාරානන්තජීවනදායිපුණ්‍යේනානුග්‍රහස්‍ය රාජත්වං භවති| ");
INSERT INTO sansin_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","ප්‍රභූතරූපේණ යද් අනුග්‍රහඃ ප්‍රකාශතේ තදර්ථං පාපේ තිෂ්ඨාම ඉති වාක්‍යං කිං වයං වදිෂ්‍යාමඃ? තන්න භවතු| ");
INSERT INTO sansin_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","පාපං ප්‍රති මෘතා වයං පුනස්තස්මින් කථම් ජීවිෂ්‍යාමඃ? ");
INSERT INTO sansin_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","වයං යාවන්තෝ ලෝකා යීශුඛ්‍රීෂ්ටේ මජ්ජිතා අභවාම තාවන්ත ඒව තස්‍ය මරණේ මජ්ජිතා ඉති කිං යූයං න ජානීථ? ");
INSERT INTO sansin_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","තතෝ යථා පිතුඃ පරාක්‍රමේණ ශ්මශානාත් ඛ්‍රීෂ්ට උත්ථාපිතස්තථා වයමපි යත් නූතනජීවින ඉවාචරාමස්තදර්ථං මජ්ජනේන තේන සාර්ද්ධං මෘත්‍යුරූපේ ශ්මශානේ සංස්ථාපිතාඃ| ");
INSERT INTO sansin_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","අපරං වයං යදි තේන සංයුක්තාඃ සන්තඃ ස ඉව මරණභාගිනෝ ජාතාස්තර්හි ස ඉවෝත්ථානභාගිනෝ(අ)පි භවිෂ්‍යාමඃ| ");
INSERT INTO sansin_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","වයං යත් පාපස්‍ය දාසාඃ පුන ර්න භවාමස්තදර්ථම් අස්මාකං පාපරූපශරීරස්‍ය විනාශාර්ථම් අස්මාකං පුරාතනපුරුෂස්තේන සාකං ක්‍රුශේ(අ)හන්‍යතේති වයං ජානීමඃ| ");
INSERT INTO sansin_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","යෝ හතඃ ස පාපාත් මුක්ත ඒව| ");
INSERT INTO sansin_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","අතඒව යදි වයං ඛ්‍රීෂ්ටේන සාර්ද්ධම් අහන්‍යාමහි තර්හි පුනරපි තේන සහිතා ජීවිෂ්‍යාම ඉත්‍යත්‍රාස්මාකං විශ්වාසෝ විද්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","යතඃ ශ්මශානාද් උත්ථාපිතඃ ඛ්‍රීෂ්ටෝ පුන ර්න ම්‍රියත ඉති වයං ජානීමඃ| තස්මින් කෝප්‍යධිකාරෝ මෘත්‍යෝ ර්නාස්ති| ");
INSERT INTO sansin_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","අපරඤ්ච ස යද් අම්‍රියත තේනෛකදා පාපම් උද්දිශ්‍යාම්‍රියත, යච්ච ජීවති තේනේශ්වරම් උද්දිශ්‍ය ජීවති; ");
INSERT INTO sansin_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","තද්වද් යූයමපි ස්වාන් පාපම් උද්දිශ්‍ය මෘතාන් අස්මාකං ප්‍රභුණා යීශුඛ්‍රීෂ්ටේනේශ්වරම් උද්දිශ්‍ය ජීවන්තෝ ජානීත| ");
INSERT INTO sansin_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","අපරඤ්ච කුත්සිතාභිලාෂාाන් පූරයිතුං යුෂ්මාකං මර්ත්‍යදේහේෂු පාපම් ආධිපත්‍යං න කරෝතු| ");
INSERT INTO sansin_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","අපරං ස්වං ස්වම් අඞ්ගම් අධර්ම්මස්‍යාස්ත්‍රං කෘත්වා පාපසේවායාං න සමර්පයත, කින්තු ශ්මශානාද් උත්ථිතානිව ස්වාන් ඊශ්වරේ සමර්පයත ස්වාන්‍යඞ්ගානි ච ධර්ම්මාස්ත්‍රස්වරූපාණීශ්වරම් උද්දිශ්‍ය සමර්පයත| ");
INSERT INTO sansin_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","යුෂ්මාකම් උපරි පාපස්‍යාධිපත්‍යං පුන ර්න භවිෂ්‍යති, යස්මාද් යූයං ව්‍යවස්ථායා අනායත්තා අනුග්‍රහස්‍ය චායත්තා අභවත| ");
INSERT INTO sansin_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","කින්තු වයං ව්‍යවස්ථායා අනායත්තා අනුග්‍රහස්‍ය චායත්තා අභවාම, ඉති කාරණාත් කිං පාපං කරිෂ්‍යාමඃ? තන්න භවතු| ");
INSERT INTO sansin_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","යතෝ මෘතිජනකං පාපං පුණ්‍යජනකං නිදේශාචරණඤ්චෛතයෝර්ද්වයෝ ර‍්‍යස්මින් ආඥාපාලනාර්ථං භෘත්‍යානිව ස්වාන් සමර්පයථ, තස්‍යෛව භෘත්‍යා භවථ, ඒතත් කිං යූයං න ජානීථ? ");
INSERT INTO sansin_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","අපරඤ්ච පූර්ව්වං යූයං පාපස්‍ය භෘත්‍යා ආස්තේති සත්‍යං කින්තු යස්‍යාං ශික්‍ෂාරූපායාං මූෂායාං නික්‍ෂිප්තා අභවත තස්‍යා ආකෘතිං මනෝභි ර්ලබ්ධවන්ත ඉති කාරණාද් ඊශ්වරස්‍ය ධන්‍යවාදෝ භවතු| ");
INSERT INTO sansin_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","ඉත්ථං යූයං පාපසේවාතෝ මුක්තාඃ සන්තෝ ධර්ම්මස්‍ය භෘත්‍යා ජාතාඃ| ");
INSERT INTO sansin_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","යුෂ්මාකං ශාරීරික්‍යා දුර්බ්බලතායා හේතෝ ර්මානවවද් අහම් ඒතද් බ්‍රවීමි; පුනඃ පුනරධර්ම්මකරණාර්ථං යද්වත් පූර්ව්වං පාපාමේධ්‍යයෝ ර්භෘත්‍යත්වේ නිජාඞ්ගානි සමාර්පයත තද්වද් ඉදානීං සාධුකර්ම්මකරණාර්ථං ධර්ම්මස්‍ය භෘත්‍යත්වේ නිජාඞ්ගානි සමර්පයත| ");
INSERT INTO sansin_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","යදා යූයං පාපස්‍ය භෘත්‍යා ආස්ත තදා ධර්ම්මස්‍ය නායත්තා ආස්ත| ");
INSERT INTO sansin_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","තර්හි යානි කර්ම්මාණි යූයම් ඉදානීං ලජ්ජාජනකානි බුධ්‍යධ්වේ පූර්ව්වං තෛ ර‍්‍යුෂ්මාකං කෝ ලාභ ආසීත්? තේෂාං කර්ම්මණාං ඵලං මරණමේව| ");
INSERT INTO sansin_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","කින්තු සාම්ප්‍රතං යූයං පාපසේවාතෝ මුක්තාඃ සන්ත ඊශ්වරස්‍ය භෘත්‍යා(අ)භවත තස්මාද් යුෂ්මාකං පවිත්‍රත්වරූපං ලභ්‍යම් අනන්තජීවනරූපඤ්ච ඵලම් ආස්තේ| ");
INSERT INTO sansin_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","යතඃ පාපස්‍ය වේතනං මරණං කින්ත්වස්මාකං ප්‍රභුණා යීශුඛ්‍රීෂ්ටේනානන්තජීවනම් ඊශ්වරදත්තං පාරිතෝෂිකම් ආස්තේ| ");
INSERT INTO sansin_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","හේ භ්‍රාතෘගණ ව්‍යවස්ථාවිදඃ ප්‍රති මමේදං නිවේදනං| විධිඃ කේවලං යාවජ්ජීවං මානවෝපර‍්‍ය්‍යධිපතිත්වං කරෝතීති යූයං කිං න ජානීථ? ");
INSERT INTO sansin_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","යාවත්කාලං පති ර්ජීවති තාවත්කාලම් ඌඪා භාර‍්‍ය්‍යා ව්‍යවස්ථයා තස්මින් බද්ධා තිෂ්ඨති කින්තු යදි පති ර්ම්‍රියතේ තර්හි සා නාරී පත්‍යු ර්ව්‍යවස්ථාතෝ මුච්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","ඒතත්කාරණාත් පත්‍යුර්ජීවනකාලේ නාරී යද්‍යන්‍යං පුරුෂං විවහති තර්හි සා ව්‍යභිචාරිණී භවති කින්තු යදි ස පති ර්ම්‍රියතේ තර්හි සා තස්‍යා ව්‍යවස්ථායා මුක්තා සතී පුරුෂාන්තරේණ ව්‍යූඪාපි ව්‍යභිචාරිණී න භවති| ");
INSERT INTO sansin_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","හේ මම භ්‍රාතෘගණ, ඊශ්වරනිමිත්තං යදස්මාකං ඵලං ජායතේ තදර්ථං ශ්මශානාද් උත්ථාපිතේන පුරුෂේණ සහ යුෂ්මාකං විවාහෝ යද් භවේත් තදර්ථං ඛ්‍රීෂ්ටස්‍ය ශරීරේණ යූයං ව්‍යවස්ථාං ප්‍රති මෘතවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","යතෝ(අ)ස්මාකං ශාරීරිකාචරණසමයේ මරණනිමිත්තං ඵලම් උත්පාදයිතුං ව්‍යවස්ථයා දූෂිතඃ පාපාභිලාෂෝ(අ)ස්මාකම් අඞ්ගේෂු ජීවන් ආසීත්| ");
INSERT INTO sansin_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","කින්තු තදා යස්‍යා ව්‍යවස්ථායා වශේ ආස්මහි සාම්ප්‍රතං තාං ප්‍රති මෘතත්වාද් වයං තස්‍යා අධීනත්වාත් මුක්තා ඉති හේතෝරීශ්වරෝ(අ)ස්මාභිඃ පුරාතනලිඛිතානුසාරාත් න සේවිතව්‍යඃ කින්තු නවීනස්වභාවේනෛව සේවිතව්‍යඃ ");
INSERT INTO sansin_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","තර්හි වයං කිං බ්‍රූමඃ? ව්‍යවස්ථා කිං පාපජනිකා භවති? නේත්ථං භවතු| ව්‍යවස්ථාම් අවිද්‍යමානායාං පාපං කිම් ඉත්‍යහං නාවේදං; කිඤ්ච ලෝභං මා කාර්ෂීරිති චේද් ව්‍යවස්ථාග්‍රන්ථේ ලිඛිතං නාභවිෂ්‍යත් තර්හි ලෝභඃ කිම්භූතස්තදහං නාඥාස්‍යං| ");
INSERT INTO sansin_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","කින්තු ව්‍යවස්ථයා පාපං ඡිද්‍රං ප්‍රාප්‍යාස්මාකම් අන්තඃ සර්ව්වවිධං කුත්සිතාභිලාෂම් අජනයත්; යතෝ ව්‍යවස්ථායාම් අවිද්‍යමානායාං පාපං මෘතං| ");
INSERT INTO sansin_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","අපරං පූර්ව්වං ව්‍යවස්ථායාම් අවිද්‍යමානායාම් අහම් අජීවං තතඃ පරම් ආඥායාම් උපස්ථිතායාම් පාපම් අජීවත් තදාහම් අම්‍රියේ| ");
INSERT INTO sansin_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","ඉත්ථං සති ජීවනනිමිත්තා යාඥා සා මම මෘත්‍යුජනිකාභවත්| ");
INSERT INTO sansin_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","යතඃ පාපං ඡිද්‍රං ප්‍රාප්‍ය ව්‍යවස්ථිතාදේශේන මාං වඤ්චයිත්වා තේන මාම් අහන්| ");
INSERT INTO sansin_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","අතඒව ව්‍යවස්ථා පවිත්‍රා, ආදේශශ්ච පවිත්‍රෝ න්‍යාය්‍යෝ හිතකාරී ච භවති| ");
INSERT INTO sansin_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","තර්හි යත් ස්වයං හිතකෘත් තත් කිං මම මෘත්‍යුජනකම් අභවත්? නේත්ථං භවතු; කින්තු පාපං යත් පාතකමිව ප්‍රකාශතේ තථා නිදේශේන පාපං යදතීව පාතකමිව ප්‍රකාශතේ තදර්ථං හිතෝපායේන මම මරණම් අජනයත්| ");
INSERT INTO sansin_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","ව්‍යවස්ථාත්මබෝධිකේති වයං ජානීමඃ කින්ත්වහං ශාරීරතාචාරී පාපස්‍ය ක්‍රීතකිඞ්කරෝ විද්‍යේ| ");
INSERT INTO sansin_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","යතෝ යත් කර්ම්ම කරෝමි තත් මම මනෝ(අ)භිමතං නහි; අපරං යන් මම මනෝ(අ)භිමතං තන්න කරෝමි කින්තු යද් ඍතීයේ තත් කරෝමි| ");
INSERT INTO sansin_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","තථාත්වේ යන් මමානභිමතං තද් යදි කරෝමි තර්හි ව්‍යවස්ථා සූත්තමේති ස්වීකරෝමි| ");
INSERT INTO sansin_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","අතඒව සම්ප්‍රති තත් කර්ම්ම මයා ක්‍රියත ඉති නහි කින්තු මම ශරීරස්ථේන පාපේනෛව ක්‍රියතේ| ");
INSERT INTO sansin_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","යතෝ මයි, අර්ථතෝ මම ශරීරේ, කිමප්‍යුත්තමං න වසති, ඒතද් අහං ජානාමි; මමේච්ඡුකතායාං තිෂ්ඨන්ත්‍යාමප්‍යහම් උත්තමකර්ම්මසාධනේ සමර්ථෝ න භවාමි| ");
INSERT INTO sansin_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","යතෝ යාමුත්තමාං ක්‍රියාං කර්ත්තුමහං වාඤ්ඡාමි තාං න කරෝමි කින්තු යත් කුත්සිතං කර්ම්ම කර්ත්තුම් අනිච්ඡුකෝ(අ)ස්මි තදේව කරෝමි| ");
INSERT INTO sansin_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","අතඒව යද්‍යත් කර්ම්ම කර්ත්තුං මමේච්ඡා න භවති තද් යදි කරෝමි තර්හි තත් මයා න ක්‍රියතේ, මමාන්තර්වර්ත්තිනා පාපේනෛව ක්‍රියතේ| ");
INSERT INTO sansin_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","භද්‍රං කර්ත්තුම් ඉච්ඡුකං මාං යෝ (අ)භද්‍රං කර්ත්තුං ප්‍රවර්ත්තයති තාදෘශං ස්වභාවමේකං මයි පශ්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","අහම් ආන්තරිකපුරුෂේණේශ්වරව්‍යවස්ථායාං සන්තුෂ්ට ආසේ; ");
INSERT INTO sansin_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","කින්තු තද්විපරීතං යුධ්‍යන්තං තදන්‍යමේකං ස්වභාවං මදීයාඞ්ගස්ථිතං ප්‍රපශ්‍යාමි, ස මදීයාඞ්ගස්ථිතපාපස්වභාවස්‍යායත්තං මාං කර්ත්තුං චේෂ්ටතේ| ");
INSERT INTO sansin_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","හා හා යෝ(අ)හං දුර්භාග්‍යෝ මනුජස්තං මාම් ඒතස්මාන් මෘතාච්ඡරීරාත් කෝ නිස්තාරයිෂ්‍යති? ");
INSERT INTO sansin_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","අස්මාකං ප්‍රභුණා යීශුඛ්‍රීෂ්ටේන නිස්තාරයිතාරම් ඊශ්වරං ධන්‍යං වදාමි| අතඒව ශරීරේණ පාපව්‍යවස්ථායා මනසා තු ඊශ්වරව්‍යවස්ථායාඃ සේවනං කරෝමි| ");
INSERT INTO sansin_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","යේ ජනාඃ ඛ්‍රීෂ්ටං යීශුම් ආශ්‍රිත්‍ය ශාරීරිකං නාචරන්ත ආත්මිකමාචරන්ති තේ(අ)ධුනා දණ්ඩාර්හා න භවන්ති| ");
INSERT INTO sansin_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","ජීවනදායකස්‍යාත්මනෝ ව්‍යවස්ථා ඛ්‍රීෂ්ටයීශුනා පාපමරණයෝ ර්ව්‍යවස්ථාතෝ මාමමෝචයත්| ");
INSERT INTO sansin_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","යස්මාච්ඡාරීරස්‍ය දුර්බ්බලත්වාද් ව්‍යවස්ථයා යත් කර්ම්මාසාධ්‍යම් ඊශ්වරෝ නිජපුත්‍රං පාපිශරීරරූපං පාපනාශකබලිරූපඤ්ච ප්‍රේෂ්‍ය තස්‍ය ශරීරේ පාපස්‍ය දණ්ඩං කුර්ව්වන් තත්කර්ම්ම සාධිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","තතඃ ශාරීරිකං නාචරිත්වාස්මාභිරාත්මිකම් ආචරද්භිර්ව්‍යවස්ථාග්‍රන්ථේ නිර්ද්දිෂ්ටානි පුණ්‍යකර්ම්මාණි සර්ව්වාණි සාධ්‍යන්තේ| ");
INSERT INTO sansin_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","යේ ශාරීරිකාචාරිණස්තේ ශාරීරිකාන් විෂයාන් භාවයන්ති යේ චාත්මිකාචාරිණස්තේ ආත්මනෝ විෂයාන් භාවයන්ති| ");
INSERT INTO sansin_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","ශාරීරිකභාවස්‍ය ඵලං මෘත්‍යුඃ කිඤ්චාත්මිකභාවස්‍ය ඵලේ ජීවනං ශාන්තිශ්ච| ");
INSERT INTO sansin_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","යතඃ ශාරීරිකභාව ඊශ්වරස්‍ය විරුද්ධඃ ශත්‍රුතාභාව ඒව ස ඊශ්වරස්‍ය ව්‍යවස්ථායා අධීනෝ න භවති භවිතුඤ්ච න ශක්නෝති| ");
INSERT INTO sansin_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","ඒතස්මාත් ශාරීරිකාචාරිෂු තෝෂ්ටුම් ඊශ්වරේණ න ශක්‍යං| ");
INSERT INTO sansin_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","කින්ත්වීශ්වරස්‍යාත්මා යදි යුෂ්මාකං මධ්‍යේ වසති තර්හි යූයං ශාරීරිකාචාරිණෝ න සන්ත ආත්මිකාචාරිණෝ භවථඃ| යස්මින් තු ඛ්‍රීෂ්ටස්‍යාත්මා න විද්‍යතේ ස තත්සම්භවෝ නහි| ");
INSERT INTO sansin_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","යදි ඛ්‍රීෂ්ටෝ යුෂ්මාන් අධිතිෂ්ඨති තර්හි පාපම් උද්දිශ්‍ය ශරීරං මෘතං කින්තු පුණ්‍යමුද්දිශ්‍යාත්මා ජීවති| ");
INSERT INTO sansin_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","මෘතගණාද් යීශු ර‍්‍යේනෝත්ථාපිතස්තස්‍යාත්මා යදි යුෂ්මන්මධ්‍යේ වසති තර්හි මෘතගණාත් ඛ්‍රීෂ්ටස්‍ය ස උත්ථාපයිතා යුෂ්මන්මධ්‍යවාසිනා ස්වකීයාත්මනා යුෂ්මාකං මෘතදේහානපි පුන ර්ජීවයිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","හේ භ්‍රාතෘගණ ශරීරස්‍ය වයමධමර්ණා න භවාමෝ(අ)තඃ ශාරීරිකාචාරෝ(අ)ස්මාභි ර්න කර්ත්තව්‍යඃ| ");
INSERT INTO sansin_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","යදි යූයං ශරීරිකාචාරිණෝ භවේත තර්හි යුෂ්මාභි ර්මර්ත්තව්‍යමේව කින්ත්වාත්මනා යදි ශරීරකර්ම්මාණි ඝාතයේත තර්හි ජීවිෂ්‍යථ| ");
INSERT INTO sansin_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","යතෝ යාවන්තෝ ලෝකා ඊශ්වරස්‍යාත්මනාකෘෂ්‍යන්තේ තේ සර්ව්ව ඊශ්වරස්‍ය සන්තානා භවන්ති| ");
INSERT INTO sansin_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","යූයං පුනරපි භයජනකං දාස්‍යභාවං න ප්‍රාප්තාඃ කින්තු යේන භාවේනේශ්වරං පිතඃ පිතරිති ප්‍රෝච්‍ය සම්බෝධයථ තාදෘශං දත්තකපුත්‍රත්වභාවම් ප්‍රාප්නුත| ");
INSERT INTO sansin_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","අපරඤ්ච වයම් ඊශ්වරස්‍ය සන්තානා ඒතස්මින් පවිත්‍ර ආත්මා ස්වයම් අස්මාකම් ආත්මාභිඃ සාර්ද්ධං ප්‍රමාණං දදාති| ");
INSERT INTO sansin_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","අතඒව වයං යදි සන්තානාස්තර්හ්‍යධිකාරිණඃ, අර්ථාද් ඊශ්වරස්‍ය ස්වත්ත්වාධිකාරිණඃ ඛ්‍රීෂ්ටේන සහාධිකාරිණශ්ච භවාමඃ; අපරං තේන සාර්ද්ධං යදි දුඃඛභාගිනෝ භවාමස්තර්හි තස්‍ය විභවස්‍යාපි භාගිනෝ භවිෂ්‍යාමඃ| ");
INSERT INTO sansin_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","කින්ත්වස්මාසු යෝ භාවීවිභවඃ ප්‍රකාශිෂ්‍යතේ තස්‍ය සමීපේ වර්ත්තමානකාලීනං දුඃඛමහං තෘණාය මන්‍යේ| ");
INSERT INTO sansin_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","යතඃ ප්‍රාණිගණ ඊශ්වරස්‍ය සන්තානානාං විභවප්‍රාප්තිම් ආකාඞ්ක්‍ෂන් නිතාන්තම් අපේක්‍ෂතේ| ");
INSERT INTO sansin_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","අපරඤ්ච ප්‍රාණිගණඃ ස්වෛරම් අලීකතායා වශීකෘතෝ නාභවත් ");
INSERT INTO sansin_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","කින්තු ප්‍රාණිගණෝ(අ)පි නශ්වරතාධීනත්වාත් මුක්තඃ සන් ඊශ්වරස්‍ය සන්තානානාං පරමමුක්තිං ප්‍රාප්ස්‍යතීත්‍යභිප්‍රායේණ වශීකර්ත්‍රා වශීචක්‍රේ| ");
INSERT INTO sansin_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","අපරඤ්ච ප්‍රසූයමානාවද් ව්‍යථිතඃ සන් ඉදානීං යාවත් කෘත්ස්නඃ ප්‍රාණිගණ ආර්ත්තස්වරං කරෝතීති වයං ජානීමඃ| ");
INSERT INTO sansin_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","කේවලඃ ස ඉති නහි කින්තු ප්‍රථමජාතඵලස්වරූපම් ආත්මානං ප්‍රාප්තා වයමපි දත්තකපුත්‍රත්වපදප්‍රාප්තිම් අර්ථාත් ශරීරස්‍ය මුක්තිං ප්‍රතීක්‍ෂමාණාස්තද්වද් අන්තරාර්ත්තරාවං කුර්ම්මඃ| ");
INSERT INTO sansin_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","වයං ප්‍රත්‍යාශයා ත්‍රාණම් අලභාමහි කින්තු ප්‍රත්‍යක්‍ෂවස්තුනෝ යා ප්‍රත්‍යාශා සා ප්‍රත්‍යාශා නහි, යතෝ මනුෂ්‍යෝ යත් සමීක්‍ෂතේ තස්‍ය ප්‍රත්‍යාශාං කුතඃ කරිෂ්‍යති? ");
INSERT INTO sansin_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","යද් අප්‍රත්‍යක්‍ෂං තස්‍ය ප්‍රත්‍යාශාං යදි වයං කුර්ව්වීමහි තර්හි ධෛර‍්‍ය්‍යම් අවලම්බ්‍ය ප්‍රතීක්‍ෂාමහේ| ");
INSERT INTO sansin_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","තත ආත්මාපි ස්වයම් අස්මාකං දුර්බ්බලතායාඃ සහායත්වං කරෝති; යතඃ කිං ප්‍රාර්ථිතව්‍යං තද් බෝද්ධුං වයං න ශක්නුමඃ, කින්ත්වස්පෂ්ටෛරාර්ත්තරාවෛරාත්මා ස්වයම් අස්මන්නිමිත්තං නිවේදයති| ");
INSERT INTO sansin_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","අපරම් ඊශ්වරාභිමතරූපේණ පවිත්‍රලෝකානාං කෘතේ නිවේදයති ය ආත්මා තස්‍යාභිප්‍රායෝ(අ)න්තර‍්‍ය්‍යාමිනා ඥායතේ| ");
INSERT INTO sansin_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","අපරම් ඊශ්වරීයනිරූපණානුසාරේණාහූතාඃ සන්තෝ යේ තස්මින් ප්‍රීයන්තේ සර්ව්වාණි මිලිත්වා තේෂාං මඞ්ගලං සාධයන්ති, ඒතද් වයං ජානීමඃ| ");
INSERT INTO sansin_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","යත ඊශ්වරෝ බහුභ්‍රාතෘණාං මධ්‍යේ ස්වපුත්‍රං ජ්‍යේෂ්ඨං කර්ත්තුම් ඉච්ඡන් යාන් පූර්ව්වං ලක්‍ෂ්‍යීකෘතවාන් තාන් තස්‍ය ප්‍රතිමූර්ත්‍යාඃ සාදෘශ්‍යප්‍රාප්ත්‍යර්ථං න්‍යයුංක්ත| ");
INSERT INTO sansin_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","අපරඤ්ච තේන යේ නියුක්තාස්ත ආහූතා අපි යේ ච තේනාහූතාස්තේ සපුණ්‍යීකෘතාඃ, යේ ච තේන සපුණ්‍යීකෘතාස්තේ විභවයුක්තාඃ| ");
INSERT INTO sansin_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","ඉත්‍යත්‍ර වයං කිං බ්‍රූමඃ? ඊශ්වරෝ යද්‍යස්මාකං සපක්‍ෂෝ භවති තර්හි කෝ විපක්‍ෂෝ(අ)ස්මාකං? ");
INSERT INTO sansin_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","ආත්මපුත්‍රං න රක්‍ෂිත්වා යෝ(අ)ස්මාකං සර්ව්වේෂාං කෘතේ තං ප්‍රදත්තවාන් ස කිං තේන සහාස්මභ්‍යම් අන්‍යානි සර්ව්වාණි න දාස්‍යති? ");
INSERT INTO sansin_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","ඊශ්වරස්‍යාභිරුචිතේෂු කේන දෝෂ ආරෝපයිෂ්‍යතේ? ය ඊශ්වරස්තාන් පුණ්‍යවත ඉව ගණයති කිං තේන? ");
INSERT INTO sansin_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","අපරං තේභ්‍යෝ දණ්ඩදානාඥා වා කේන කරිෂ්‍යතේ? යෝ(අ)ස්මන්නිමිත්තං ප්‍රාණාන් ත්‍යක්තවාන් කේවලං තන්න කින්තු මෘතගණමධ්‍යාද් උත්ථිතවාන්, අපි චේශ්වරස්‍ය දක්‍ෂිණේ පාර්ශ්වේ තිෂ්ඨන් අද්‍යාප්‍යස්මාකං නිමිත්තං ප්‍රාර්ථත ඒවම්භූතෝ යඃ ඛ්‍රීෂ්ටඃ කිං තේන? ");
INSERT INTO sansin_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","අස්මාභිඃ සහ ඛ්‍රීෂ්ටස්‍ය ප්‍රේමවිච්ඡේදං ජනයිතුං කඃ ශක්නෝති? ක්ලේශෝ ව්‍යසනං වා තාඩනා වා දුර්භික්‍ෂං වා වස්ත්‍රහීනත්වං වා ප්‍රාණසංශයෝ වා ඛඞ්ගෝ වා කිමේතානි ශක්නුවන්ති? ");
INSERT INTO sansin_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","කින්තු ලිඛිතම් ආස්තේ, යථා, වයං තව නිමිත්තං ස්මෝ මෘත්‍යුවක්ත්‍රේ(අ)ඛිලං දිනං| බලිර්දේයෝ යථා මේෂෝ වයං ගණ්‍යාමහේ තථා| ");
INSERT INTO sansin_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","අපරං යෝ(අ)ස්මාසු ප්‍රීයතේ තේනෛතාසු විපත්සු වයං සම්‍යග් විජයාමහේ| ");
INSERT INTO sansin_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","යතෝ(අ)ස්මාකං ප්‍රභුනා යීශුඛ්‍රීෂ්ටේනේශ්වරස්‍ය යත් ප්‍රේම තස්මාද් අස්මාකං විච්ඡේදං ජනයිතුං මෘත්‍යු ර්ජීවනං වා දිව්‍යදූතා වා බලවන්තෝ මුඛ්‍යදූතා වා වර්ත්තමානෝ වා භවිෂ්‍යන් කාලෝ වා උච්චපදං වා නීචපදං වාපරං කිමපි සෘෂ්ටවස්තු ");
INSERT INTO sansin_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","වෛතේෂාං කේනාපි න ශක්‍යමිත්‍යස්මින් දෘඪවිශ්වාසෝ මමාස්තේ| ");
INSERT INTO sansin_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","අහං කාඤ්චිද් කල්පිතාං කථාං න කථයාමි, ඛ්‍රීෂ්ටස්‍ය සාක්‍ෂාත් සත්‍යමේව බ්‍රවීමි පවිත්‍රස්‍යාත්මනඃ සාක්‍ෂාන් මදීයං මන ඒතත් සාක්‍ෂ්‍යං දදාති| ");
INSERT INTO sansin_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","මමාන්තරතිශයදුඃඛං නිරන්තරං ඛේදශ්ච ");
INSERT INTO sansin_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","තස්මාද් අහං ස්වජාතීයභ්‍රාතෘණාං නිමිත්තාත් ස්වයං ඛ්‍රීෂ්ටාච්ඡාපාක්‍රාන්තෝ භවිතුම් ඓච්ඡම්| ");
INSERT INTO sansin_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","යතස්ත ඉස්‍රායේලස්‍ය වංශා අපි ච දත්තකපුත්‍රත්වං තේජෝ නියමෝ ව්‍යවස්ථාදානං මන්දිරේ භජනං ප්‍රතිඥාඃ පිතෘපුරුෂගණශ්චෛතේෂු සර්ව්වේෂු තේෂාම් අධිකාරෝ(අ)ස්ති| ");
INSERT INTO sansin_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","තත් කේවලං නහි කින්තු සර්ව්වාධ්‍යක්‍ෂඃ සර්ව්වදා සච්චිදානන්ද ඊශ්වරෝ යඃ ඛ්‍රීෂ්ටඃ සෝ(අ)පි ශාරීරිකසම්බන්ධේන තේෂාං වංශසම්භවඃ| ");
INSERT INTO sansin_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","ඊශ්වරස්‍ය වාක්‍යං විඵලං ජාතම් ඉති නහි යත්කාරණාද් ඉස්‍රායේලෝ වංශේ යේ ජාතාස්තේ සර්ව්වේ වස්තුත ඉස්‍රායේලීයා න භවන්ති| ");
INSERT INTO sansin_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","අපරම් ඉබ්‍රාහීමෝ වංශේ ජාතා අපි සර්ව්වේ තස්‍යෛව සන්තානා න භවන්ති කින්තු ඉස්හාකෝ නාම්නා තව වංශෝ විඛ්‍යාතෝ භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","අර්ථාත් ශාරීරිකසංසර්ගාත් ජාතාඃ සන්තානා යාවන්තස්තාවන්ත ඒවේශ්වරස්‍ය සන්තානා න භවන්ති කින්තු ප්‍රතිශ්‍රවණාද් යේ ජායන්තේ තඒවේශ්වරවංශෝ ගණ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","යතස්තත්ප්‍රතිශ්‍රුතේ ර්වාක්‍යමේතත්, ඒතාදෘශේ සමයේ (අ)හං පුනරාගමිෂ්‍යාමි තත්පූර්ව්වං සාරායාඃ පුත්‍ර ඒකෝ ජනිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","අපරමපි වදාමි ස්වමනෝ(අ)භිලාෂත ඊශ්වරේණ යන්නිරූපිතං තත් කර්ම්මතෝ නහි කින්ත්වාහ්වයිතු ර්ජාතමේතද් යථා සිද්ධ්‍යති ");
INSERT INTO sansin_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","තදර්ථං රිබ්කානාමිකයා යෝෂිතා ජනෛකස්මාද් අර්ථාද් අස්මාකම් ඉස්හාකඃ පූර්ව්වපුරුෂාද් ගර්භේ ධෘතේ තස්‍යාඃ සන්තානයෝඃ ප්‍රසවාත් පූර්ව්වං කිඤ්ච තයෝඃ ශුභාශුභකර්ම්මණඃ කරණාත් පූර්ව්වං ");
INSERT INTO sansin_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","තාං ප්‍රතීදං වාක්‍යම් උක්තං, ජ්‍යේෂ්ඨඃ කනිෂ්ඨං සේවිෂ්‍යතේ, ");
INSERT INTO sansin_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","යථා ලිඛිතම් ආස්තේ, තථාප්‍යේෂාවි න ප්‍රීත්වා යාකූබි ප්‍රීතවාන් අහං| ");
INSERT INTO sansin_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","තර්හි වයං කිං බ්‍රූමඃ? ඊශ්වරඃ කිම් අන්‍යායකාරී? තථා න භවතු| ");
INSERT INTO sansin_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","යතඃ ස ස්වයං මූසාම් අවදත්; අහං යස්මින් අනුග්‍රහං චිකීර්ෂාමි තමේවානුගෘහ්ලාමි, යඤ්ච දයිතුම් ඉච්ඡාමි තමේව දයේ| ");
INSERT INTO sansin_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","අතඒවේච්ඡතා යතමානේන වා මානවේන තන්න සාධ්‍යතේ දයාකාරිණේශ්වරේණෛව සාධ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","ඵිරෞණි ශාස්ත්‍රේ ලිඛති, අහං ත්වද්ද්වාරා මත්පරාක්‍රමං දර්ශයිතුං සර්ව්වපෘථිව්‍යාං නිජනාම ප්‍රකාශයිතුඤ්ච ත්වාං ස්ථාපිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","අතඃ ස යම් අනුග්‍රහීතුම් ඉච්ඡති තමේවානුගෘහ්ලාති, යඤ්ච නිග්‍රහීතුම් ඉච්ඡති තං නිගෘහ්ලාති| ");
INSERT INTO sansin_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","යදි වදසි තර්හි ස දෝෂං කුතෝ ගෘහ්ලාති? තදීයේච්ඡායාඃ ප්‍රතිබන්ධකත්වං කර්ත්තං කස්‍ය සාමර්ථ්‍යං විද්‍යතේ? ");
INSERT INTO sansin_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","හේ ඊශ්වරස්‍ය ප්‍රතිපක්‍ෂ මර්ත්‍ය ත්වං කඃ? ඒතාදෘශං මාං කුතඃ සෘෂ්ටවාන්? ඉති කථාං සෘෂ්ටවස්තු ස්‍රෂ්ට්‍රේ කිං කථයිෂ්‍යති? ");
INSERT INTO sansin_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","ඒකස්මාන් මෘත්පිණ්ඩාද් උත්කෘෂ්ටාපකෘෂ්ටෞ ද්විවිධෞ කලශෞ කර්ත්තුං කිං කුලාලස්‍ය සාමර්ථ්‍යං නාස්ති? ");
INSERT INTO sansin_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","ඊශ්වරඃ කෝපං ප්‍රකාශයිතුං නිජශක්තිං ඥාපයිතුඤ්චේච්ඡන් යදි විනාශස්‍ය යෝග්‍යානි ක්‍රෝධභාජනානි ප්‍රති බහුකාලං දීර්ඝසහිෂ්ණුතාම් ආශ්‍රයති; ");
INSERT INTO sansin_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","අපරඤ්ච විභවප්‍රාප්ත්‍යර්ථං පූර්ව්වං නියුක්තාන්‍යනුග්‍රහපාත්‍රාණි ප්‍රති නිජවිභවස්‍ය බාහුල්‍යං ප්‍රකාශයිතුං කේවලයිහූදිනාං නහි භින්නදේශිනාමපි මධ්‍යාද් ");
INSERT INTO sansin_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","අස්මානිව තාන්‍යාහ්වයති තත්‍ර තව කිං? ");
INSERT INTO sansin_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","හෝශේයග්‍රන්ථේ යථා ලිඛිතම් ආස්තේ, යෝ ලෝකෝ මම නාසීත් තං වදිෂ්‍යාමි මදීයකං| යා ජාති ර්මේ(අ)ප්‍රියා චාසීත් තාං වදිෂ්‍යාම්‍යහං ප්‍රියාං| ");
INSERT INTO sansin_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","යූයං මදීයලෝකා න යත්‍රේති වාක්‍යමෞච්‍යත| අමරේශස්‍ය සන්තානා ඉති ඛ්‍යාස්‍යන්ති තත්‍ර තේ| ");
INSERT INTO sansin_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","ඉස්‍රායේලීයලෝකේෂු යිශායියෝ(අ)පි වාචමේතාං ප්‍රාචාරයත්, ඉස්‍රායේලීයවංශානාං යා සංඛ්‍යා සා තු නිශ්චිතං| සමුද්‍රසිකතාසංඛ්‍යාසමානා යදි ජායතේ| තථාපි කේවලං ලෝකෛරල්පෛස්ත්‍රාණං ව්‍රජිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","යතෝ න්‍යායේන ස්වං කර්ම්ම පරේශඃ සාධයිෂ්‍යති| දේශේ සඒව සංක්‍ෂේපාන්නිජං කර්ම්ම කරිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","යිශායියෝ(අ)පරමපි කථයාමාස, සෛන්‍යාධ්‍යක්‍ෂපරේශේන චේත් කිඤ්චින්නෝදශිෂ්‍යත| තදා වයං සිදෝමේවාභවිෂ්‍යාම විනිශ්චිතං| යද්වා වයම් අමෝරායා අගමිෂ්‍යාම තුල්‍යතාං| ");
INSERT INTO sansin_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","තර්හි වයං කිං වක්‍ෂ්‍යාමඃ? ඉතරදේශීයා ලෝකා අපි පුණ්‍යාර්ථම් අයතමානා විශ්වාසේන පුණ්‍යම් අලභන්ත; ");
INSERT INTO sansin_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","කින්ත්විස්‍රායේල්ලෝකා ව්‍යවස්ථාපාලනේන පුණ්‍යාර්ථං යතමානාස්තන් නාලභන්ත| ");
INSERT INTO sansin_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","තස්‍ය කිං කාරණං? තේ විශ්වාසේන නහි කින්තු ව්‍යවස්ථායාඃ ක්‍රියයා චේෂ්ටිත්වා තස්මින් ස්ඛලනජනකේ පාෂාණේ පාදස්ඛලනං ප්‍රාප්තාඃ| ");
INSERT INTO sansin_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","ලිඛිතං යාදෘශම් ආස්තේ, පශ්‍ය පාදස්ඛලාර්ථං හි සීයෝනි ප්‍රස්තරන්තථා| බාධාකාරඤ්ච පාෂාණං පරිස්ථාපිතවානහම්| විශ්වසිෂ්‍යති යස්තත්‍ර ස ජනෝ න ත්‍රපිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","හේ භ්‍රාතර ඉස්‍රායේලීයලෝකා යත් පරිත්‍රාණං ප්‍රාප්නුවන්ති තදහං මනසාභිලෂන් ඊශ්වරස්‍ය සමීපේ ප්‍රාර්ථයේ| ");
INSERT INTO sansin_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","යත ඊශ්වරේ තේෂාං චේෂ්ටා විද්‍යත ඉත්‍යත්‍රාහං සාක්‍ෂ්‍යස්මි; කින්තු තේෂාං සා චේෂ්ටා සඥානා නහි, ");
INSERT INTO sansin_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","යතස්ත ඊශ්වරදත්තං පුණ්‍යම් අවිඥාය ස්වකෘතපුණ්‍යං ස්ථාපයිතුම් චේෂ්ටමානා ඊශ්වරදත්තස්‍ය පුණ්‍යස්‍ය නිඝ්නත්වං න ස්වීකුර්ව්වන්ති| ");
INSERT INTO sansin_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","ඛ්‍රීෂ්ට ඒකෛකවිශ්වාසිජනාය පුණ්‍යං දාතුං ව්‍යවස්ථායාඃ ඵලස්වරූපෝ භවති| ");
INSERT INTO sansin_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","ව්‍යවස්ථාපාලනේන යත් පුණ්‍යං තත් මූසා වර්ණයාමාස, යථා, යෝ ජනස්තාං පාලයිෂ්‍යති ස තද්ද්වාරා ජීවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","කින්තු ප්‍රත්‍යයේන යත් පුණ්‍යං තද් ඒතාදෘශං වාක්‍යං වදති, කඃ ස්වර්ගම් ආරුහ්‍ය ඛ්‍රීෂ්ටම් අවරෝහයිෂ්‍යති? ");
INSERT INTO sansin_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","කෝ වා ප්‍රේතලෝකම් අවරුහ්‍ය ඛ්‍රීෂ්ටං මෘතගණමධ්‍යාද් ආනේෂ්‍යතීති වාක් මනසි ත්වයා න ගදිතව්‍යා| ");
INSERT INTO sansin_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","තර්හි කිං බ්‍රවීති? තද් වාක්‍යං තව සමීපස්ථම් අර්ථාත් තව වදනේ මනසි චාස්තේ, තච්ච වාක්‍යම් අස්මාභිඃ ප්‍රචාර‍්‍ය්‍යමාණං විශ්වාසස්‍ය වාක්‍යමේව| ");
INSERT INTO sansin_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","වස්තුතඃ ප්‍රභුං යීශුං යදි වදනේන ස්වීකරෝෂි, තථේශ්වරස්තං ශ්මශානාද් උදස්ථාපයද් ඉති යද්‍යන්තඃකරණේන විශ්වසිෂි තර්හි පරිත්‍රාණං ලප්ස්‍යසේ| ");
INSERT INTO sansin_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","යස්මාත් පුණ්‍යප්‍රාප්ත්‍යර්ථම් අන්තඃකරණේන විශ්වසිතව්‍යං පරිත්‍රාණාර්ථඤ්ච වදනේන ස්වීකර්ත්තව්‍යං| ");
INSERT INTO sansin_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","ශාස්ත්‍රේ යාදෘශං ලිඛති විශ්වසිෂ්‍යති යස්තත්‍ර ස ජනෝ න ත්‍රපිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","ඉත්‍යත්‍ර යිහූදිනි තදන්‍යලෝකේ ච කෝපි විශේෂෝ නාස්ති යස්මාද් යඃ සර්ව්වේෂාම් අද්විතීයඃ ප්‍රභුඃ ස නිජයාචකාන සර්ව්වාන් ප්‍රති වදාන්‍යෝ භවති| ");
INSERT INTO sansin_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","යතඃ, යඃ කශ්චිත් පරමේශස්‍ය නාම්නා හි ප්‍රාර්ථයිෂ්‍යතේ| ස ඒව මනුජෝ නූනං පරිත්‍රාතෝ භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","යං යේ ජනා න ප්‍රත්‍යායන් තේ තමුද්දිශ්‍ය කථං ප්‍රාර්ථයිෂ්‍යන්තේ? යේ වා යස්‍යාඛ්‍යානං කදාපි න ශ්‍රුතවන්තස්තේ තං කථං ප්‍රත්‍යේෂ්‍යන්ති? අපරං යදි ප්‍රචාරයිතාරෝ න තිෂ්ඨන්ති තදා කථං තේ ශ්‍රෝෂ්‍යන්ති? ");
INSERT INTO sansin_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","යදි වා ප්‍රේරිතා න භවන්ති තදා කථං ප්‍රචාරයිෂ්‍යන්ති? යාදෘශං ලිඛිතම් ආස්තේ, යථා, මාඞ්ගලිකං සුසංවාදං දදත්‍යානීය යේ නරාඃ| ප්‍රචාරයන්ති ශාන්තේශ්ච සුසංවාදං ජනාස්තු යේ| තේෂාං චරණපද්මානි කීදෘක් ශෝභාන්විතානි හි| ");
INSERT INTO sansin_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","කින්තු තේ සර්ව්වේ තං සුසංවාදං න ගෘහීතවන්තඃ| යිශායියෝ යථා ලිඛිතවාන්| අස්මත්ප්‍රචාරිතේ වාක්‍යේ විශ්වාසමකරෝද්ධි කඃ| ");
INSERT INTO sansin_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","අතඒව ශ්‍රවණාද් විශ්වාස ඓශ්වරවාක්‍යප්‍රචාරාත් ශ්‍රවණඤ්ච භවති| ");
INSERT INTO sansin_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","තර්හ්‍යහං බ්‍රවීමි තෛඃ කිං නාශ්‍රාවි? අවශ්‍යම් අශ්‍රාවි, යස්මාත් තේෂාං ශබ්දෝ මහීං ව්‍යාප්නෝද් වාක්‍යඤ්ච නිඛිලං ජගත්| ");
INSERT INTO sansin_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","අපරමපි වදාමි, ඉස්‍රායේලීයලෝකාඃ කිම් ඒතාං කථාං න බුධ්‍යන්තේ? ප්‍රථමතෝ මූසා ඉදං වාක්‍යං ප්‍රෝවාච, අහමුත්තාපයිෂ්‍යේ තාන් අගණ්‍යමානවෛරපි| ක්ලේක්‍ෂ්‍යාමි ජාතිම් ඒතාඤ්ච ප්‍රෝන්මත්තභින්නජාතිභිඃ| ");
INSERT INTO sansin_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","අපරඤ්ච යිශායියෝ(අ)තිශයාක්‍ෂෝභේණ කථයාමාස, යථා, අධි මාං යෛස්තු නාචේෂ්ටි සම්ප්‍රාප්තස්තෛ ර්ජනෛරහං| අධි මාං යෛ ර්න සම්පෘෂ්ටං විඥාතස්තෛ ර්ජනෛරහං|| ");
INSERT INTO sansin_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","කින්ත්විස්‍රායේලීයලෝකාන් අධි කථයාඤ්චකාර, යෛරාඥාලඞ්ඝිභි ර්ලෝකෛ ර්විරුද්ධං වාක්‍යමුච්‍යතේ| තාන් ප්‍රත්‍යේව දිනං කෘත්ස්නං හස්තෞ විස්තාරයාම්‍යහං|| ");
INSERT INTO sansin_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","ඊශ්වරේණ ස්වීකීයලෝකා අපසාරිතා අහං කිම් ඊදෘශං වාක්‍යං බ්‍රවීමි? තන්න භවතු යතෝ(අ)හමපි බින්‍යාමීනගෝත්‍රීය ඉබ්‍රාහීමවංශීය ඉස්‍රායේලීයලෝකෝ(අ)ස්මි| ");
INSERT INTO sansin_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","ඊශ්වරේණ පූර්ව්වං යේ ප්‍රදෘෂ්ටාස්තේ ස්වකීයලෝකා අපසාරිතා ඉති නහි| අපරම් ඒලියෝපාඛ්‍යානේ ශාස්ත්‍රේ යල්ලිඛිතම් ආස්තේ තද් යූයං කිං න ජානීථ? ");
INSERT INTO sansin_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","හේ පරමේශ්වර ලෝකාස්ත්වදීයාඃ සර්ව්වා යඥවේදීරභඤ්ජන් තථා තව භවිෂ්‍යද්වාදිනඃ සර්ව්වාන් අඝ්නන් කේවල ඒකෝ(අ)හම් අවශිෂ්ට ආසේ තේ මමාපි ප්‍රාණාන් නාශයිතුං චේෂ්ටනතේ, ඒතාං කථාම් ඉස්‍රායේලීයලෝකානාං විරුද්ධම් ඒලිය ඊශ්වරාය නිවේදයාමාස| ");
INSERT INTO sansin_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","තතස්තං ප්‍රතීශ්වරස්‍යෝත්තරං කිං ජාතං? බාල්නාම්නෝ දේවස්‍ය සාක්‍ෂාත් යෛ ර්ජානූනි න පාතිතානි තාදෘශාඃ සප්ත සහස්‍රාණි ලෝකා අවශේෂිතා මයා| ");
INSERT INTO sansin_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","තද්වද් ඒතස්මින් වර්ත්තමානකාලේ(අ)පි අනුග්‍රහේණාභිරුචිතාස්තේෂාම් අවශිෂ්ටාඃ කතිපයා ලෝකාඃ සන්ති| ");
INSERT INTO sansin_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","අතඒව තද් යද්‍යනුග්‍රහේණ භවති තර්හි ක්‍රියයා න භවති නෝ චේද් අනුග්‍රහෝ(අ)නනුග්‍රහ ඒව, යදි වා ක්‍රියයා භවති තර්හ්‍යනුග්‍රහේණ න භවති නෝ චේත් ක්‍රියා ක්‍රියෛව න භවති| ");
INSERT INTO sansin_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","තර්හි කිං? ඉස්‍රායේලීයලෝකා යද් අමෘගයන්ත තන්න ප්‍රාපුඃ| කින්ත්වභිරුචිතලෝකාස්තත් ප්‍රාපුස්තදන්‍යේ සර්ව්ව අන්ධීභූතාඃ| ");
INSERT INTO sansin_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","යථා ලිඛිතම් ආස්තේ, ඝෝරනිද්‍රාලුතාභාවං දෘෂ්ටිහීනේ ච ලෝචනේ| කර්ණෞ ශ්‍රුතිවිහීනෞ ච ප්‍රදදෞ තේභ්‍ය ඊශ්වරඃ|| ");
INSERT INTO sansin_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","ඒතේස්මින් දායූදපි ලිඛිතවාන් යථා, අතෝ භුක්ත්‍යාසනං තේෂාම් උන්මාථවද් භවිෂ්‍යති| වා වංශයන්ත්‍රවද් බාධා දණ්ඩවද් වා භවිෂ්‍යති|| ");
INSERT INTO sansin_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","භවිෂ්‍යන්ති තථාන්ධාස්තේ නේත්‍රෛඃ පශ්‍යන්ති නෝ යථා| වේපථුඃ කටිදේශස්‍ය තේෂාං නිත්‍යං භවිෂ්‍යති|| ");
INSERT INTO sansin_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","පතනාර්ථං තේ ස්ඛලිතවන්ත ඉති වාචං කිමහං වදාමි? තන්න භවතු කින්තු තාන් උද්‍යෝගිනඃ කර්ත්තුං තේෂාං පතනාද් ඉතරදේශීයලෝකෛඃ පරිත්‍රාණං ප්‍රාප්තං| ");
INSERT INTO sansin_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","තේෂාං පතනං යදි ජගතෝ ලෝකානාං ලාභජනකම් අභවත් තේෂාං හ්‍රාසෝ(අ)පි යදි භින්නදේශිනාං ලාභජනකෝ(අ)භවත් තර්හි තේෂාං වෘද්ධිඃ කති ලාභජනිකා භවිෂ්‍යති? ");
INSERT INTO sansin_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","අතෝ හේ අන්‍යදේශිනෝ යුෂ්මාන් සම්බෝධ්‍ය කථයාමි නිජානාං ඥාතිබන්ධූනාං මනඃසූද්‍යෝගං ජනයන් තේෂාං මධ්‍යේ කියතාං ලෝකානාං යථා පරිත්‍රාණං සාධයාමි ");
INSERT INTO sansin_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","තන්නිමිත්තම් අන්‍යදේශිනාං නිකටේ ප්‍රේරිතඃ සන් අහං ස්වපදස්‍ය මහිමානං ප්‍රකාශයාමි| ");
INSERT INTO sansin_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","තේෂාං නිග්‍රහේණ යදීශ්වරේණ සහ ජගතෝ ජනානාං මේලනං ජාතං තර්හි තේෂාම් අනුගෘහීතත්වං මෘතදේහේ යථා ජීවනලාභස්තද්වත් කිං න භවිෂ්‍යති? ");
INSERT INTO sansin_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","අපරං ප්‍රථමජාතං ඵලං යදි පවිත්‍රං භවති තර්හි සර්ව්වමේව ඵලං පවිත්‍රං භවිෂ්‍යති; තථා මූලං යදි පවිත්‍රං භවති තර්හි ශාඛා අපි තථෛව භවිෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","කියතීනාං ශාඛානාං ඡේදනේ කෘතේ ත්වං වන්‍යජිතවෘක්‍ෂස්‍ය ශාඛා භූත්වා යදි තච්ඡාඛානාං ස්ථානේ රෝපිතා සති ජිතවෘක්‍ෂීයමූලස්‍ය රසං භුංක්‍ෂේ, ");
INSERT INTO sansin_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","තර්හි තාසාං භින්නශාඛානාං විරුද්ධං මාං ගර්ව්වීඃ; යදි ගර්ව්වසි තර්හි ත්වං මූලං යන්න ධාරයසි කින්තු මූලං ත්වාං ධාරයතීති සංස්මර| ");
INSERT INTO sansin_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","අපරඤ්ච යදි වදසි මාං රෝපයිතුං තාඃ ශාඛා විභන්නා අභවන්; ");
INSERT INTO sansin_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","භද්‍රම්, අප්‍රත්‍යයකාරණාත් තේ විභින්නා ජාතාස්තථා විශ්වාසකාරණාත් ත්වං රෝපිතෝ ජාතස්තස්මාද් අහඞ්කාරම් අකෘත්වා සසාධ්වසෝ භව| ");
INSERT INTO sansin_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","යත ඊශ්වරෝ යදි ස්වාභාවිකීඃ ශාඛා න රක්‍ෂති තර්හි සාවධානෝ භව චේත් ත්වාමපි න ස්ථාපයති| ");
INSERT INTO sansin_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","ඉත්‍යත්‍රේශ්වරස්‍ය යාදෘශී කෘපා තාදෘශං භයානකත්වමපි ත්වයා දෘශ්‍යතාං; යේ පතිතාස්තාන් ප්‍රති තස්‍ය භයානකත්වං දෘශ්‍යතාං, ත්වඤ්ච යදි තත්කෘපාශ්‍රිතස්තිෂ්ඨසි තර්හි ත්වාං ප්‍රති කෘපා ද්‍රක්‍ෂ්‍යතේ; නෝ චේත් ත්වමපි තද්වත් ඡින්නෝ භවිෂ්‍යසි| ");
INSERT INTO sansin_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","අපරඤ්ච තේ යද්‍යප්‍රත්‍යයේ න තිෂ්ඨන්ති තර්හි පුනරපි රෝපයිෂ්‍යන්තේ යස්මාත් තාන් පුනරපි රෝපයිතුම් ඉශ්වරස්‍ය ශක්තිරාස්තේ| ");
INSERT INTO sansin_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","වන්‍යජිතවෘක්‍ෂස්‍ය ශාඛා සන් ත්වං යදි තතශ්ඡින්නෝ රීතිව්‍යත්‍යයේනෝත්තමජිතවෘක්‍ෂේ රෝेेපිතෝ(අ)භවස්තර්හි තස්‍ය වෘක්‍ෂස්‍ය ස්වීයා යාඃ ශාඛාස්තාඃ කිං පුනඃ ස්වවෘක්‍ෂේ සංලගිතුං න ශක්නුවන්ති? ");
INSERT INTO sansin_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","හේ භ්‍රාතරෝ යුෂ්මාකම් ආත්මාභිමානෝ යන්න ජායතේ තදර්ථං මමේදෘශී වාඤ්ඡා භවති යූයං ඒතන්නිගූඪතත්ත්වම් අජානන්තෝ යන්න තිෂ්ඨථ; වස්තුතෝ යාවත්කාලං සම්පූර්ණරූපේණ භින්නදේශිනාං සංග්‍රහෝ න භවිෂ්‍යති තාවත්කාලම් අංශත්වේන ඉස්‍රායේලීයලෝකානාම් අන්ධතා ස්ථාස්‍යති; ");
INSERT INTO sansin_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","පශ්චාත් තේ සර්ව්වේ පරිත්‍රාස්‍යන්තේ; ඒතාදෘශං ලිඛිතමප්‍යාස්තේ, ආගමිෂ්‍යති සීයෝනාද් ඒකෝ යස්ත්‍රාණදායකඃ| අධර්ම්මං යාකුබෝ වංශාත් ස තු දූරීකරිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","තථා දූරීකරිෂ්‍යාමි තේෂාං පාපාන්‍යහං යදා| තදා තෛරේව සාර්ද්ධං මේ නියමෝ(අ)යං භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","සුසංවාදාත් තේ යුෂ්මාකං විපක්‍ෂා අභවන් කින්ත්වභිරුචිතත්වාත් තේ පිතෘලෝකානාං කෘතේ ප්‍රියපාත්‍රාණි භවන්ති| ");
INSERT INTO sansin_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","යත ඊශ්වරස්‍ය දානාද් ආහ්වානාඤ්ච පශ්චාත්තාපෝ න භවති| ");
INSERT INTO sansin_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","අතඒව පූර්ව්වම් ඊශ්වරේ(අ)විශ්වාසිනඃ සන්තෝ(අ)පි යූයං යද්වත් සම්ප්‍රති තේෂාම් අවිශ්වාසකාරණාද් ඊශ්වරස්‍ය කෘපාපාත්‍රාණි ජාතාස්තද්වද් ");
INSERT INTO sansin_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","ඉදානීං තේ(අ)විශ්වාසිනඃ සන්ති කින්තු යුෂ්මාභි ර්ලබ්ධකෘපාකාරණාත් තෛරපි කෘපා ලප්ස්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","ඊශ්වරඃ සර්ව්වාන් ප්‍රති කෘපාං ප්‍රකාශයිතුං සර්ව්වාන් අවිශ්වාසිත්වේන ගණයති| ");
INSERT INTO sansin_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","අහෝ ඊශ්වරස්‍ය ඥානබුද්ධිරූපයෝ ර්ධනයෝඃ කීදෘක් ප්‍රාචුර‍්‍ය්‍යං| තස්‍ය රාජශාසනස්‍ය තත්ත්වං කීදෘග් අප්‍රාප්‍යං| තස්‍ය මාර්ගාශ්ච කීදෘග් අනුපලක්‍ෂ්‍යාඃ| ");
INSERT INTO sansin_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","පරමේශ්වරස්‍ය සඞ්කල්පං කෝ ඥාතවාන්? තස්‍ය මන්ත්‍රී වා කෝ(අ)භවත්? ");
INSERT INTO sansin_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","කෝ වා තස්‍යෝපකාරී භෘත්වා තත්කෘතේ තේන ප්‍රත්‍යුපකර්ත්තව්‍යඃ? ");
INSERT INTO sansin_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","යතෝ වස්තුමාත්‍රමේව තස්මාත් තේන තස්මෛ චාභවත් තදීයෝ මහිමා සර්ව්වදා ප්‍රකාශිතෝ භවතු| ඉති| ");
INSERT INTO sansin_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","හේ භ්‍රාතර ඊශ්වරස්‍ය කෘපයාහං යුෂ්මාන් විනයේ යූයං ස්වං ස්වං ශරීරං සජීවං පවිත්‍රං ග්‍රාහ්‍යං බලිම් ඊශ්වරමුද්දිශ්‍ය සමුත්සෘජත, ඒෂා සේවා යුෂ්මාකං යෝග්‍යා| ");
INSERT INTO sansin_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","අපරං යූයං සාංසාරිකා ඉව මාචරත, කින්තු ස්වං ස්වං ස්වභාවං පරාවර්ත්‍ය නූතනාචාරිණෝ භවත, තත ඊශ්වරස්‍ය නිදේශඃ කීදෘග් උත්තමෝ ග්‍රහණීයඃ සම්පූර්ණශ්චේති යුෂ්මාභිරනුභාවිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","කශ්චිදපි ජනෝ යෝග්‍යත්වාදධිකං ස්වං න මන්‍යතාං කින්තු ඊශ්වරෝ යස්මෛ ප්‍රත්‍යයස්‍ය යත්පරිමාණම් අදදාත් ස තදනුසාරතෝ යෝග්‍යරූපං ස්වං මනුතාම්, ඊශ්වරාද් අනුග්‍රහං ප්‍රාප්තඃ සන් යුෂ්මාකම් ඒකෛකං ජනම් ඉත්‍යාඥාපයාමි| ");
INSERT INTO sansin_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","යතෝ යද්වදස්මාකම් ඒකස්මින් ශරීරේ බහූන්‍යඞ්ගානි සන්ති කින්තු සර්ව්වේෂාමඞ්ගානාං කාර‍්‍ය්‍යං සමානං නහි; ");
INSERT INTO sansin_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","තද්වදස්මාකං බහුත්වේ(අ)පි සර්ව්වේ වයං ඛ්‍රීෂ්ටේ ඒකශරීරාඃ පරස්පරම් අඞ්ගප්‍රත්‍යඞ්ගත්වේන භවාමඃ| ");
INSERT INTO sansin_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","අස්මාද් ඊශ්වරානුග්‍රහේණ විශේෂං විශේෂං දානම් අස්මාසු ප්‍රාප්තේෂු සත්සු කෝපි යදි භවිෂ්‍යද්වාක්‍යං වදති තර්හි ප්‍රත්‍යයස්‍ය පරිමාණානුසාරතඃ ස තද් වදතු; ");
INSERT INTO sansin_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","යද්වා යදි කශ්චිත් සේවනකාරී භවති තර්හි ස තත්සේවනං කරෝතු; අථවා යදි කශ්චිද් අධ්‍යාපයිතා භවති තර්හි සෝ(අ)ධ්‍යාපයතු; ");
INSERT INTO sansin_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","තථා ය උපදේෂ්ටා භවති ස උපදිශතු යශ්ච දාතා ස සරලතයා දදාතු යස්ත්වධිපතිඃ ස යත්නේනාධිපතිත්වං කරෝතු යශ්ච දයාලුඃ ස හෘෂ්ටමනසා දයතාම්| ");
INSERT INTO sansin_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","අපරඤ්ච යුෂ්මාකං ප්‍රේම කාපට්‍යවර්ජිතං භවතු යද් අභද්‍රං තද් ඍතීයධ්වං යච්ච භද්‍රං තස්මින් අනුරජ්‍යධ්වම්| ");
INSERT INTO sansin_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","අපරං භ්‍රාතෘත්වප්‍රේම්නා පරස්පරං ප්‍රීයධ්වං සමාදරාද් ඒකෝ(අ)පරජනං ශ්‍රේෂ්ඨං ජානීධ්වම්| ");
INSERT INTO sansin_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","තථා කාර‍්‍ය්‍යේ නිරාලස්‍යා මනසි ච සෝද්‍යෝගාඃ සන්තඃ ප්‍රභුං සේවධ්වම්| ");
INSERT INTO sansin_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","අපරං ප්‍රත්‍යාශායාම් ආනන්දිතා දුඃඛසමයේ ච ධෛර‍්‍ය්‍යයුක්තා භවත; ප්‍රාර්ථනායාං සතතං ප්‍රවර්ත්තධ්වං| ");
INSERT INTO sansin_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","පවිත්‍රාණාං දීනතාං දූරීකුරුධ්වම් අතිථිසේවායාම් අනුරජ්‍යධ්වම්| ");
INSERT INTO sansin_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","යේ ජනා යුෂ්මාන් තාඩයන්ති තාන් ආශිෂං වදත ශාපම් අදත්ත්වා දද්ධ්වමාශිෂම්| ");
INSERT INTO sansin_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","යේ ජනා ආනන්දන්ති තෛඃ සාර්ද්ධම් ආනන්දත යේ ච රුදන්ති තෛඃ සහ රුදිත| ");
INSERT INTO sansin_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","අපරඤ්ච යුෂ්මාකං මනසාං පරස්පරම් ඒකෝභාවෝ භවතු; අපරම් උච්චපදම් අනාකාඞ්ක්‍ෂ්‍ය නීචලෝකෛඃ සහාපි මාර්දවම් ආචරත; ස්වාන් ඥානිනෝ න මන්‍යධ්වං| ");
INSERT INTO sansin_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","පරස්මාද් අපකාරං ප්‍රාප්‍යාපි පරං නාපකුරුත| සර්ව්වේෂාං දෘෂ්ටිතෝ යත් කර්ම්මෝත්තමං තදේව කුරුත| ");
INSERT INTO sansin_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","යදි භවිතුං ශක්‍යතේ තර්හි යථාශක්ති සර්ව්වලෝකෛඃ සහ නිර්ව්විරෝධේන කාලං යාපයත| ");
INSERT INTO sansin_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","හේ ප්‍රියබන්ධවඃ, කස්මෛචිද් අපකාරස්‍ය සමුචිතං දණ්ඩං ස්වයං න දද්ධ්වං, කින්ත්වීශ්වරීයක්‍රෝධාය ස්ථානං දත්ත යතෝ ලිඛිතමාස්තේ පරමේශ්වරඃ කථයති, දානං ඵලස්‍ය මත්කර්ම්ම සූචිතං ප්‍රදදාම්‍යහං| ");
INSERT INTO sansin_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","ඉතිකාරණාද් රිපු ර‍්‍යදි ක්‍ෂුධාර්ත්තස්තේ තර්හි තං ත්වං ප්‍රභෝජය| තථා යදි තෘෂාර්ත්තඃ ස්‍යාත් තර්හි තං පරිපායය| තේන ත්වං මස්තකේ තස්‍ය ජ්වලදග්නිං නිධාස්‍යසි| ");
INSERT INTO sansin_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","කුක්‍රියයා පරාජිතා න සන්ත උත්තමක්‍රියයා කුක්‍රියාං පරාජයත| ");
INSERT INTO sansin_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","යුෂ්මාකම් ඒකෛකජනඃ ශාසනපදස්‍ය නිඝ්නෝ භවතු යතෝ යානි ශාසනපදානි සන්ති තානි සර්ව්වාණීශ්වරේණ ස්ථාපිතානි; ඊශ්වරං විනා පදස්ථාපනං න භවති| ");
INSERT INTO sansin_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","ඉති හේතෝඃ ශාසනපදස්‍ය යත් ප්‍රාතිකූල්‍යං තද් ඊශ්වරීයනිරූපණස්‍ය ප්‍රාතිකූල්‍යමේව; අපරං යේ ප්‍රාතිකූල්‍යම් ආචරන්ති තේ ස්වේෂාං සමුචිතං දණ්ඩං ස්වයමේව ඝටයන්තේ| ");
INSERT INTO sansin_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","ශාස්තා සදාචාරිණාං භයප්‍රදෝ නහි දුරාචාරිණාමේව භයප්‍රදෝ භවති; ත්වං කිං තස්මාන් නිර්භයෝ භවිතුම් ඉච්ඡසි? තර්හි සත්කර්ම්මාචර, තස්මාද් යශෝ ලප්ස්‍යසේ, ");
INSERT INTO sansin_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","යතස්තව සදාචරණාය ස ඊශ්වරස්‍ය භෘත්‍යෝ(අ)ස්ති| කින්තු යදි කුකර්ම්මාචරසි තර්හි ත්වං ශඞ්කස්ව යතඃ ස නිරර්ථකං ඛඞ්ගං න ධාරයති; කුකර්ම්මාචාරිණං සමුචිතං දණ්ඩයිතුම් ස ඊශ්වරස්‍ය දණ්ඩදභෘත්‍ය ඒව| ");
INSERT INTO sansin_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","අතඒව කේවලදණ්ඩභයාන්නහි කින්තු සදසද්බෝධාදපි තස්‍ය වශ්‍යේන භවිතව්‍යං| ");
INSERT INTO sansin_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","ඒතස්මාද් යුෂ්මාකං රාජකරදානමප්‍යුචිතං යස්මාද් යේ කරං ගෘහ්ලන්ති ත ඊශ්වරස්‍ය කිඞ්කරා භූත්වා සතතම් ඒතස්මින් කර්ම්මණි නිවිෂ්ටාස්තිෂ්ඨන්ති| ");
INSERT INTO sansin_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","අස්මාත් කරග්‍රාහිණේ කරං දත්ත, තථා ශුල්කග්‍රාහිණේ ශුල්කං දත්ත, අපරං යස්මාද් භේතව්‍යං තස්මාද් බිභීත, යශ්ච සමාදරණීයස්තං සමාද්‍රියධ්වම්; ඉත්ථං යස්‍ය යත් ප්‍රාප්‍යං තත් තස්මෛ දත්ත| ");
INSERT INTO sansin_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","යුෂ්මාකං පරස්පරං ප්‍රේම විනා (අ)න්‍යත් කිමපි දේයම් ඍණං න භවතු, යතෝ යඃ පරස්මින් ප්‍රේම කරෝති තේන ව්‍යවස්ථා සිධ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","වස්තුතඃ පරදාරාන් මා ගච්ඡ, නරහත්‍යාං මා කාර්ෂීඃ, චෛර‍්‍ය්‍යං මා කාර්ෂීඃ, මිථ්‍යාසාක්‍ෂ්‍යං මා දේහි, ලෝභං මා කාර්ෂීඃ, ඒතාඃ සර්ව්වා ආඥා ඒතාභ්‍යෝ භින්නා යා කාචිද් ආඥාස්ති සාපි ස්වසමීපවාසිනි ස්වවත් ප්‍රේම කුර්ව්විත්‍යනේන වචනේන වේදිතා| ");
INSERT INTO sansin_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","යතඃ ප්‍රේම සමීපවාසිනෝ(අ)ශුභං න ජනයති තස්මාත් ප්‍රේම්නා සර්ව්වා ව්‍යවස්ථා පාල්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","ප්‍රත්‍යයීභවනකාලේ(අ)ස්මාකං පරිත්‍රාණස්‍ය සාමීප්‍යාද් ඉදානීං තස්‍ය සාමීප්‍යම් අව්‍යවහිතං; අතඃ සමයං විවිච්‍යාස්මාභිඃ සාම්ප්‍රතම් අවශ්‍යමේව නිද්‍රාතෝ ජාගර්ත්තව්‍යං| ");
INSERT INTO sansin_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","බහුතරා යාමිනී ගතා ප්‍රභාතං සන්නිධිං ප්‍රාප්තං තස්මාත් තාමසීයාඃ ක්‍රියාඃ පරිත්‍යජ්‍යාස්මාභි ර්වාසරීයා සජ්ජා පරිධාතව්‍යා| ");
INSERT INTO sansin_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","අතෝ හේතෝ ර්වයං දිවා විහිතං සදාචරණම් ආචරිෂ්‍යාමඃ| රඞ්ගරසෝ මත්තත්වං ලම්පටත්වං කාමුකත්වං විවාද ඊර්ෂ්‍යා චෛතානි පරිත්‍යක්‍ෂ්‍යාමඃ| ");
INSERT INTO sansin_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","යූයං ප්‍රභුයීශුඛ්‍රීෂ්ටරූපං පරිච්ඡදං පරිධද්ධ්වං සුඛාභිලාෂපූරණාය ශාරීරිකාචරණං මාචරත| ");
INSERT INTO sansin_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","යෝ ජනෝ(අ)දෘඪවිශ්වාසස්තං යුෂ්මාකං සඞ්ගිනං කුරුත කින්තු සන්දේහවිචාරාර්ථං නහි| ");
INSERT INTO sansin_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","යතෝ නිෂිද්ධං කිමපි ඛාද්‍යද්‍රව්‍යං නාස්ති, කස්‍යචිජ්ජනස්‍ය ප්‍රත්‍යය ඒතාදෘශෝ විද්‍යතේ කින්ත්වදෘඪවිශ්වාසඃ කශ්චිදපරෝ ජනඃ කේවලං ශාකං භුඞ්ක්තං| ");
INSERT INTO sansin_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","තර්හි යෝ ජනඃ සාධාරණං ද්‍රව්‍යං භුඞ්ක්තේ ස විශේෂද්‍රව්‍යභෝක්තාරං නාවජානීයාත් තථා විශේෂද්‍රව්‍යභෝක්තාපි සාධාරණද්‍රව්‍යභෝක්තාරං දෝෂිණං න කුර‍්‍ය්‍යාත්, යස්මාද් ඊශ්වරස්තම් අගෘහ්ලාත්| ");
INSERT INTO sansin_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","හේ පරදාසස්‍ය දූෂයිතස්ත්වං කඃ? නිජප්‍රභෝඃ සමීපේ තේන පදස්ථේන පදච්‍යුතේන වා භවිතව්‍යං ස ච පදස්ථ ඒව භවිෂ්‍යති යත ඊශ්වරස්තං පදස්ථං කර්ත්තුං ශක්නෝති| ");
INSERT INTO sansin_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","අපරඤ්ච කශ්චිජ්ජනෝ දිනාද් දිනං විශේෂං මන්‍යතේ කශ්චිත්තුु සර්ව්වාණි දිනානි සමානානි මන්‍යතේ, ඒකෛකෝ ජනඃ ස්වීයමනසි විවිච්‍ය නිශ්චිනෝතු| ");
INSERT INTO sansin_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","යෝ ජනඃ කිඤ්චන දිනං විශේෂං මන්‍යතේ ස ප්‍රභුභක්ත්‍යා තන් මන්‍යතේ, යශ්ච ජනඃ කිමපි දිනං විශේෂං න මන්‍යතේ සෝ(අ)පි ප්‍රභුභක්ත්‍යා තන්න මන්‍යතේ; අපරඤ්ච යඃ සර්ව්වාණි භක්‍ෂ්‍යද්‍රව්‍යාණි භුඞ්ක්තේ ස ප්‍රභුභක්තයා තානි භුඞ්ක්තේ යතඃ ස ඊශ්වරං ධන්‍යං වක්ති, යශ්ච න භුඞ්ක්තේ සෝ(අ)පි ප්‍රභුභක්ත්‍යෛව න භුඤ්ජාන ඊශ්වරං ධන්‍යං බ්‍රූතේ| ");
INSERT INTO sansin_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","අපරම් අස්මාකං කශ්චිත් නිජනිමිත්තං ප්‍රාණාන් ධාරයති නිජනිමිත්තං ම්‍රියතේ වා තන්න; ");
INSERT INTO sansin_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","කින්තු යදි වයං ප්‍රාණාන් ධාරයාමස්තර්හි ප්‍රභුනිමිත්තං ධාරයාමඃ, යදි ච ප්‍රාණාන් ත්‍යජාමස්තර්හ්‍යපි ප්‍රභුනිමිත්තං ත්‍යජාමඃ, අතඒව ජීවනේ මරණේ වා වයං ප්‍රභෝරේවාස්මහේ| ");
INSERT INTO sansin_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","යතෝ ජීවන්තෝ මෘතාශ්චේත්‍යුභයේෂාං ලෝකානාං ප්‍රභුත්වප්‍රාප්ත්‍යර්ථං ඛ්‍රීෂ්ටෝ මෘත උත්ථිතඃ පුනර්ජීවිතශ්ච| ");
INSERT INTO sansin_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","කින්තු ත්වං නිජං භ්‍රාතරං කුතෝ දූෂයසි? තථා ත්වං නිජං භ්‍රාතරං කුතස්තුච්ඡං ජානාසි? ඛ්‍රීෂ්ටස්‍ය විචාරසිංහාසනස්‍ය සම්මුඛේ සර්ව්වෛරස්මාභිරුපස්ථාතව්‍යං; ");
INSERT INTO sansin_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","යාදෘශං ලිඛිතම් ආස්තේ, පරේශඃ ශපථං කුර්ව්වන් වාක්‍යමේතත් පුරාවදත්| සර්ව්වෝ ජනඃ සමීපේ මේ ජානුපාතං කරිෂ්‍යති| ජිහ්වෛකෛකා තථේශස්‍ය නිඝ්නත්වං ස්වීකරිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","අතඒව ඊශ්වරසමීපේ(අ)ස්මාකම් ඒකෛකජනේන නිජා කථා කථයිතව්‍යා| ");
INSERT INTO sansin_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","ඉත්ථං සති වයම් අද්‍යාරභ්‍ය පරස්පරං න දූෂයන්තඃ ස්වභ්‍රාතු ර්විඝ්නෝ ව්‍යාඝාතෝ වා යන්න ජායේත තාදෘශීමීහාං කුර්ම්මහේ| ");
INSERT INTO sansin_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","කිමපි වස්තු ස්වභාවතෝ නාශුචි භවතීත්‍යහං ජානේ තථා ප්‍රභුනා යීශුඛ්‍රීෂ්ටේනාපි නිශ්චිතං ජානේ, කින්තු යෝ ජනෝ යද් ද්‍රව්‍යම් අපවිත්‍රං ජානීතේ තස්‍ය කෘතේ තද් අපවිත්‍රම් ආස්තේ| ");
INSERT INTO sansin_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","අතඒව තව භක්‍ෂ්‍යද්‍රව්‍යේණ තව භ්‍රාතා ශෝකාන්විතෝ භවති තර්හි ත්වං භ්‍රාතරං ප්‍රති ප්‍රේම්නා නාචරසි| ඛ්‍රීෂ්ටෝ යස්‍ය කෘතේ ස්වප්‍රාණාන් ව්‍යයිතවාන් ත්වං නිජේන භක්‍ෂ්‍යද්‍රව්‍යේණ තං න නාශය| ");
INSERT INTO sansin_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","අපරං යුෂ්මාකම් උත්තමං කර්ම්ම නින්දිතං න භවතු| ");
INSERT INTO sansin_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","භක්‍ෂ්‍යං පේයඤ්චේශ්වරරාජ්‍යස්‍ය සාරෝ නහි, කින්තු පුණ්‍යං ශාන්තිශ්ච පවිත්‍රේණාත්මනා ජාත ආනන්දශ්ච| ");
INSERT INTO sansin_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","ඒතෛ ර‍්‍යෝ ජනඃ ඛ්‍රීෂ්ටං සේවතේ, ස ඒවේශ්වරස්‍ය තුෂ්ටිකරෝ මනුෂ්‍යෛශ්ච සුඛ්‍යාතඃ| ");
INSERT INTO sansin_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","අතඒව යේනාස්මාකං සර්ව්වේෂාං පරස්පරම් ඓක්‍යං නිෂ්ඨා ච ජායතේ තදේවාස්මාභි ර‍්‍යතිතව්‍යං| ");
INSERT INTO sansin_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","භක්‍ෂ්‍යාර්ථම් ඊශ්වරස්‍ය කර්ම්මණෝ හානිං මා ජනයත; සර්ව්වං වස්තු පවිත්‍රමිති සත්‍යං තථාපි යෝ ජනෝ යද් භුක්ත්වා විඝ්නං ලභතේ තදර්ථං තද් භද්‍රං නහි| ");
INSERT INTO sansin_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","තව මාංසභක්‍ෂණසුරාපානාදිභිඃ ක්‍රියාභි ර‍්‍යදි තව භ්‍රාතුඃ පාදස්ඛලනං විඝ්නෝ වා චාඤ්චල්‍යං වා ජායතේ තර්හි තද්භෝජනපානයෝස්ත්‍යාගෝ භද්‍රඃ| ");
INSERT INTO sansin_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","යදි තව ප්‍රත්‍යයස්තිෂ්ඨති තර්හීශ්වරස්‍ය ගෝචරේ ස්වාන්තරේ තං ගෝපය; යෝ ජනඃ ස්වමතේන ස්වං දෝෂිණං න කරෝති ස ඒව ධන්‍යඃ| ");
INSERT INTO sansin_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","කින්තු යඃ කශ්චිත් සංශය්‍ය භුඞ්ක්තේ(අ)ර්ථාත් න ප්‍රතීත්‍ය භුඞ්ක්තේ, ස ඒවාවශ්‍යං දණ්ඩාර්හෝ භවිෂ්‍යති, යතෝ යත් ප්‍රත්‍යයජං නහි තදේව පාපමයං භවති| ");
INSERT INTO sansin_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","බලවද්භිරස්මාභි ර්දුර්බ්බලානාං දෞර්බ්බල්‍යං සෝඪව්‍යං න ච ස්වේෂාම් ඉෂ්ටාචාර ආචරිතව්‍යඃ| ");
INSERT INTO sansin_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","අස්මාකම් ඒකෛකෝ ජනඃ ස්වසමීපවාසිනෝ හිතාර්ථං නිෂ්ඨාර්ථඤ්ච තස්‍යෛවේෂ්ටාචාරම් ආචරතු| ");
INSERT INTO sansin_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","යතඃ ඛ්‍රීෂ්ටෝ(අ)පි නිජේෂ්ටාචාරං නාචරිතවාන්, යථා ලිඛිතම් ආස්තේ, ත්වන්නින්දකගණස්‍යෛව නින්දාභි ර්නින්දිතෝ(අ)ස්ම්‍යහං| ");
INSERT INTO sansin_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","අපරඤ්ච වයං යත් සහිෂ්ණුතාසාන්ත්වනයෝ ර්ජනකේන ශාස්ත්‍රේණ ප්‍රත්‍යාශාං ලභේමහි තන්නිමිත්තං පූර්ව්වකාලේ ලිඛිතානි සර්ව්වවචනාන්‍යස්මාකම් උපදේශාර්ථමේව ලිලිඛිරේ| ");
INSERT INTO sansin_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","සහිෂ්ණුතාසාන්ත්වනයෝරාකරෝ ය ඊශ්වරඃ ස ඒවං කරෝතු යත් ප්‍රභු ර‍්‍යීශුඛ්‍රීෂ්ට ඉව යුෂ්මාකම් ඒකජනෝ(අ)න්‍යජනේන සාර්ද්ධං මනස ඓක්‍යම් ආචරේත්; ");
INSERT INTO sansin_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","යූයඤ්ච සර්ව්ව ඒකචිත්තා භූත්වා මුඛෛකේනේවාස්මත්ප්‍රභුයීශුඛ්‍රීෂ්ටස්‍ය පිතුරීශ්වරස්‍ය ගුණාන් කීර්ත්තයේත| ");
INSERT INTO sansin_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","අපරම් ඊශ්වරස්‍ය මහිම්නඃ ප්‍රකාශාර්ථං ඛ්‍රීෂ්ටෝ යථා යුෂ්මාන් ප්‍රත්‍යගෘහ්ලාත් තථා යුෂ්මාකමප්‍යේකෝ ජනෝ(අ)න්‍යජනං ප්‍රතිගෘහ්ලාතු| ");
INSERT INTO sansin_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","යථා ලිඛිතම් ආස්තේ, අතෝ(අ)හං සම්මුඛේ තිෂ්ඨන් භින්නදේශනිවාසිනාං| ස්තුවංස්ත්වාං පරිගාස්‍යාමි තව නාම්නි පරේශ්වර|| ");
INSERT INTO sansin_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","තස්‍ය දයාලුත්වාච්ච භින්නජාතීයා යද් ඊශ්වරස්‍ය ගුණාන් කීර්ත්තයේයුස්තදර්ථං යීශුඃ ඛ්‍රීෂ්ටස්ත්වක්ඡේදනියමස්‍ය නිඝ්නෝ(අ)භවද් ඉත්‍යහං වදාමි| යථා ලිඛිතම් ආස්තේ, අතෝ(අ)හං සම්මුඛේ තිෂ්ඨන් භින්නදේශනිවාසිනාං| ස්තුවංස්ත්වාං පරිගාස්‍යාමි තව නාම්නි පරේශ්වර|| ");
INSERT INTO sansin_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","අපරමපි ලිඛිතම් ආස්තේ, හේ අන්‍යජාතයෝ යූයං සමං නන්දත තජ්ජනෛඃ| ");
INSERT INTO sansin_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","පුනශ්ච ලිඛිතම් ආස්තේ, හේ සර්ව්වදේශිනෝ යූයං ධන්‍යං බ්‍රූත පරේශ්වරං| හේ තදීයනරා යූයං කුරුධ්වං තත්ප්‍රශංසනං|| ");
INSERT INTO sansin_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","අපර යීශායියෝ(අ)පි ලිලේඛ, යීශයස්‍ය තු යත් මූලං තත් ප්‍රකාශිෂ්‍යතේ තදා| සර්ව්වජාතීයනෘණාඤ්ච ශාසකඃ සමුදේෂ්‍යති| තත්‍රාන්‍යදේශිලෝකෛශ්ච ප්‍රත්‍යාශා ප්‍රකරිෂ්‍යතේ|| ");
INSERT INTO sansin_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","අතඒව යූයං පවිත්‍රස්‍යාත්මනඃ ප්‍රභාවාද් යත් සම්පූර්ණාං ප්‍රත්‍යාශාං ලප්ස්‍යධ්වේ තදර්ථං තත්ප්‍රත්‍යාශාජනක ඊශ්වරඃ ප්‍රත්‍යයේන යුෂ්මාන් ශාන්ත්‍යානන්දාභ්‍යාං සම්පූර්ණාන් කරෝතු| ");
INSERT INTO sansin_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","හේ භ්‍රාතරෝ යූයං සද්භාවයුක්තාඃ සර්ව්වප්‍රකාරේණ ඥානේන ච සම්පූර්ණාඃ පරස්පරෝපදේශේ ච තත්පරා ඉත්‍යහං නිශ්චිතං ජානාමි, ");
INSERT INTO sansin_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","තථාප්‍යහං යත් ප්‍රගල්භතරෝ භවන් යුෂ්මාන් ප්‍රබෝධයාමි තස්‍යෛකං කාරණමිදං| ");
INSERT INTO sansin_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","භින්නජාතීයාඃ පවිත්‍රේණාත්මනා පාවිතනෛවේද්‍යරූපා භූත්වා යද් ග්‍රාහ්‍යා භවේයුස්තන්නිමිත්තමහම් ඊශ්වරස්‍ය සුසංවාදං ප්‍රචාරයිතුං භින්නජාතීයානාං මධ්‍යේ යීශුඛ්‍රීෂ්ටස්‍ය සේවකත්වං දානං ඊශ්වරාත් ලබ්ධවානස්මි| ");
INSERT INTO sansin_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","ඊශ්වරං ප්‍රති යීශුඛ්‍රීෂ්ටේන මම ශ්ලාඝාකරණස්‍ය කාරණම් ආස්තේ| ");
INSERT INTO sansin_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","භින්නදේශින ආඥාග්‍රාහිණඃ කර්ත්තුං ඛ්‍රීෂ්ටෝ වාක්‍යේන ක්‍රියයා ච, ආශ්චර‍්‍ය්‍යලක්‍ෂණෛශ්චිත්‍රක්‍රියාභිඃ පවිත්‍රස්‍යාත්මනඃ ප්‍රභාවේන ච යානි කර්ම්මාණි මයා සාධිතවාන්, ");
INSERT INTO sansin_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","කේවලං තාන්‍යේව විනාන්‍යස්‍ය කස්‍යචිත් කර්ම්මණෝ වර්ණනාං කර්ත්තුං ප්‍රගල්භෝ න භවාමි| තස්මාත් ආ යිරූශාලම ඉල්ලූරිකං යාවත් සර්ව්වත්‍ර ඛ්‍රීෂ්ටස්‍ය සුසංවාදං ප්‍රාචාරයං| ");
INSERT INTO sansin_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","අන්‍යේන නිචිතායාං භිත්තාවහං යන්න නිචිනෝමි තන්නිමිත්තං යත්‍ර යත්‍ර ස්ථානේ ඛ්‍රීෂ්ටස්‍ය නාම කදාපි කේනාපි න ඥාපිතං තත්‍ර තත්‍ර සුසංවාදං ප්‍රචාරයිතුම් අහං යතේ| ");
INSERT INTO sansin_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","යාදෘශං ලිඛිතම් ආස්තේ, යෛ ර්වාර්ත්තා තස්‍ය න ප්‍රාප්තා දර්ශනං තෛස්තු ලප්ස්‍යතේ| යෛශ්ච නෛව ශ්‍රුතං කිඤ්චිත් බෝද්ධුං ශක්‍ෂ්‍යන්ති තේ ජනාඃ|| ");
INSERT INTO sansin_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","තස්මාද් යුෂ්මත්සමීපගමනාද් අහං මුහුර්මුහු ර්නිවාරිතෝ(අ)භවං| ");
INSERT INTO sansin_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","කින්ත්විදානීම් අත්‍ර ප්‍රදේශේෂු මයා න ගතං ස්ථානං කිමපි නාවශිෂ්‍යතේ යුෂ්මත්සමීපං ගන්තුං බහුවත්සරානාරභ්‍ය මාමකීනාකාඞ්ක්‍ෂා ච විද්‍යත ඉති හේතෝඃ ");
INSERT INTO sansin_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","ස්පානියාදේශගමනකාලේ(අ)හං යුෂ්මන්මධ්‍යේන ගච්ඡන් යුෂ්මාන් ආලෝකිෂ්‍යේ, තතඃ පරං යුෂ්මත්සම්භාෂණේන තෘප්තිං පරිලභ්‍ය තද්දේශගමනාර්ථං යුෂ්මාභි ර්විසර්ජයිෂ්‍යේ, ඊදෘශී මදීයා ප්‍රත්‍යාශා විද්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","කින්තු සාම්ප්‍රතං පවිත්‍රලෝකානාං සේවනාය යිරූශාලම්නගරං ව්‍රජාමි| ");
INSERT INTO sansin_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","යතෝ යිරූශාලමස්ථපවිත්‍රලෝකානාං මධ්‍යේ යේ දරිද්‍රා අර්ථවිශ්‍රාණනේන තානුපකර්ත්තුං මාකිදනියාදේශීයා ආඛායාදේශීයාශ්ච ලෝකා ඓච්ඡන්| ");
INSERT INTO sansin_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","ඒෂා තේෂාං සදිච්ඡා යතස්තේ තේෂාම් ඍණිනඃ සන්ති යතෝ හේතෝ ර්භින්නජාතීයා යේෂාං පරමාර්ථස්‍යාංශිනෝ ජාතා ඓහිකවිෂයේ තේෂාමුපකාරස්තෛඃ කර්ත්තව්‍යඃ| ");
INSERT INTO sansin_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","අතෝ මයා තත් කර්ම්ම සාධයිත්වා තස්මින් ඵලේ තේභ්‍යඃ සමර්පිතේ යුෂ්මන්මධ්‍යේන ස්පානියාදේශෝ ගමිෂ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","යුෂ්මත්සමීපේ මමාගමනසමයේ ඛ්‍රීෂ්ටස්‍ය සුසංවාදස්‍ය පූර්ණවරේණ සම්බලිතඃ සන් අහම් ආගමිෂ්‍යාමි ඉති මයා ඥායතේ| ");
INSERT INTO sansin_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","හේ භ්‍රාතෘගණ ප්‍රභෝ ර‍්‍යීශුඛ්‍රීෂ්ටස්‍ය නාම්නා පවිත්‍රස්‍යාත්මානඃ ප්‍රේම්නා ච විනයේ(අ)හං ");
INSERT INTO sansin_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","යිහූදාදේශස්ථානාම් අවිශ්වාසිලෝකානාං කරේභ්‍යෝ යදහං රක්‍ෂාං ලභේය මදීයෛතේන සේවනකර්ම්මණා ච යද් යිරූශාලමස්ථාඃ පවිත්‍රලෝකාස්තුෂ්‍යේයුඃ, ");
INSERT INTO sansin_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","තදර්ථං යූයං මත්කෘත ඊශ්වරාය ප්‍රාර්ථයමාණා යතධ්වං තේනාහම් ඊශ්වරේච්ඡයා සානන්දං යුෂ්මත්සමීපං ගත්වා යුෂ්මාභිඃ සහිතඃ ප්‍රාණාන් ආප්‍යායිතුං පාරයිෂ්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","ශාන්තිදායක ඊශ්වරෝ යුෂ්මාකං සර්ව්වේෂාං සඞ්ගී භූයාත්| ඉති| ");
INSERT INTO sansin_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","කිංක්‍රීයානගරීයධර්ම්මසමාජස්‍ය පරිචාරිකා යා ඵෛබීනාමිකාස්මාකං ධර්ම්මභගිනී තස්‍යාඃ කෘතේ(අ)හං යුෂ්මාන් නිවේදයාමි, ");
INSERT INTO sansin_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","යූයං තාං ප්‍රභුමාශ්‍රිතාං විඥාය තස්‍යා ආතිථ්‍යං පවිත්‍රලෝකාර්හං කුරුධ්වං, යුෂ්මත්තස්තස්‍යා ය උපකාරෝ භවිතුං ශක්නෝති තං කුරුධ්වං, යස්මාත් තයා බහූනාං මම චෝපකාරඃ කෘතඃ| ");
INSERT INTO sansin_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","අපරඤ්ච ඛ්‍රීෂ්ටස්‍ය යීශෝඃ කර්ම්මණි මම සහකාරිණෞ මම ප්‍රාණරක්‍ෂාර්ථඤ්ච ස්වප්‍රාණාන් පණීකෘතවන්තෞ යෞ ප්‍රිෂ්කිල්ලාක්කිලෞ තෞ මම නමස්කාරං ඥාපයධ්වං| ");
INSERT INTO sansin_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","තාභ්‍යාම් උපකාරාප්තිඃ කේවලං මයා ස්වීකර්ත්තව්‍යේති නහි භින්නදේශීයෛඃ සර්ව්වධර්ම්මසමාජෛරපි| ");
INSERT INTO sansin_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","අපරඤ්ච තයෝ ර්ගෘහේ ස්ථිතාන් ධර්ම්මසමාජලෝකාන් මම නමස්කාරං ඥාපයධ්වං| තද්වත් ආශියාදේශේ ඛ්‍රීෂ්ටස්‍ය පක්‍ෂේ ප්‍රථමජාතඵලස්වරූපෝ ය ඉපේනිතනාමා මම ප්‍රියබන්ධුස්තමපි මම නමස්කාරං ඥාපයධ්වං| ");
INSERT INTO sansin_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","අපරං බහුශ්‍රමේණාස්මාන් අසේවත යා මරියම් තාමපි නමස්කාරං ඥාපයධ්වං| ");
INSERT INTO sansin_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","අපරඤ්ච ප්‍රේරිතේෂු ඛ්‍යාතකීර්ත්තී මදග්‍රේ ඛ්‍රීෂ්ටාශ්‍රිතෞ මම ස්වජාතීයෞ සහබන්දිනෞ ච යාවාන්ද්‍රනීකයූනියෞ තෞ මම නමස්කාරං ඥාපයධ්වං| ");
INSERT INTO sansin_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","තථා ප්‍රභෞ මත්ප්‍රියතමම් ආම්ප්ලියමපි මම නමස්කාරං ඥාපයධ්වං| ");
INSERT INTO sansin_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","අපරං ඛ්‍රීෂ්ටසේවායාං මම සහකාරිණම් ඌර්බ්බාණං මම ප්‍රියතමං ස්තාඛුඤ්ච මම නමස්කාරං ඥාපයධ්වං| ");
INSERT INTO sansin_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","අපරං ඛ්‍රීෂ්ටේන පරීක්‍ෂිතම් ආපිල්ලිං මම නමස්කාරං වදත, ආරිෂ්ටබූලස්‍ය පරිජනාංශ්ච මම නමස්කාරං ඥාපයධ්වං| ");
INSERT INTO sansin_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","අපරං මම ඥාතිං හේරෝදියෝනං මම නමස්කාරං වදත, තථා නාර්කිසස්‍ය පරිවාරාණාං මධ්‍යේ යේ ප්‍රභුමාශ්‍රිතාස්තාන් මම නමස්කාරං වදත| ");
INSERT INTO sansin_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","අපරං ප්‍රභෝඃ සේවායාං පරිශ්‍රමකාරිණ්‍යෞ ත්‍රුඵේනාත්‍රුඵෝෂේ මම නමස්කාරං වදත, තථා ප්‍රභෝඃ සේවායාම් අත්‍යන්තං පරිශ්‍රමකාරිණී යා ප්‍රියා පර්ෂිස්තාං නමස්කාරං ඥාපයධ්වං| ");
INSERT INTO sansin_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","අපරං ප්‍රභෝරභිරුචිතං රූඵං මම ධර්ම්මමාතා යා තස්‍ය මාතා තාමපි නමස්කාරං වදත| ");
INSERT INTO sansin_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","අපරම් අසුංකෘතං ඵ්ලිගෝනං හර්ම්මං පාත්‍රබං හර්ම්මිම් ඒතේෂාං සඞ්ගිභ්‍රාතෘගණඤ්ච නමස්කාරං ඥාපයධ්වං| ");
INSERT INTO sansin_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","අපරං ඵිලලගෝ යූලියා නීරියස්තස්‍ය භගින්‍යලුම්පා චෛතාන් ඒතෛඃ සාර්ද්ධං යාවන්තඃ පවිත්‍රලෝකා ආසතේ තානපි නමස්කාරං ඥාපයධ්වං| ");
INSERT INTO sansin_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","යූයං පරස්පරං පවිත්‍රචුම්බනේන නමස්කුරුධ්වං| ඛ්‍රීෂ්ටස්‍ය ධර්ම්මසමාජගණෝ යුෂ්මාන් නමස්කුරුතේ| ");
INSERT INTO sansin_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","හේ භ්‍රාතරෝ යුෂ්මාන් විනයේ(අ)හං යුෂ්මාභි ර‍්‍යා ශික්‍ෂා ලබ්ධා තාම් අතික්‍රම්‍ය යේ විච්ඡේදාන් විඝ්නාංශ්ච කුර්ව්වන්ති තාන් නිශ්චිනුත තේෂාං සඞ්ගං වර්ජයත ච| ");
INSERT INTO sansin_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","යතස්තාදෘශා ලෝකා අස්මාකං ප්‍රභෝ ර‍්‍යීශුඛ්‍රීෂ්ටස්‍ය දාසා ඉති නහි කින්තු ස්වෝදරස්‍යෛව දාසාඃ; අපරං ප්‍රණයවචනෛ ර්මධුරවාක්‍යෛශ්ච සරලලෝකානාං මනාංසි මෝහයන්ති| ");
INSERT INTO sansin_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","යුෂ්මාකම් ආඥාග්‍රාහිත්වං සර්ව්වත්‍ර සර්ව්වෛ ර්ඥාතං තතෝ(අ)හං යුෂ්මාසු සානන්දෝ(අ)භවං තථාපි යූයං යත් සත්ඥානේන ඥානිනඃ කුඥානේे චාතත්පරා භවේතේති මමාභිලාෂඃ| ");
INSERT INTO sansin_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","අධිකන්තු ශාන්තිදායක ඊශ්වරඃ ශෛතානම් අවිලම්බං යුෂ්මාකං පදානාම් අධෝ මර්ද්දිෂ්‍යති| අස්මාකං ප්‍රභු ර‍්‍යීශුඛ්‍රීෂ්ටෝ යුෂ්මාසු ප්‍රසාදං ක්‍රියාත්| ඉති| ");
INSERT INTO sansin_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","මම සහකාරී තීමථියෝ මම ඥාතයෝ ලූකියෝ යාසෝන් සෝසිපාත්‍රශ්චේමේ යුෂ්මාන් නමස්කුර්ව්වන්තේ| ");
INSERT INTO sansin_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","අපරම් ඒතත්පත්‍රලේඛකස්තර්ත්තියනාමාහමපි ප්‍රභෝ ර්නාම්නා යුෂ්මාන් නමස්කරෝමි| ");
INSERT INTO sansin_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","තථා කෘත්ස්නධර්ම්මසමාජස්‍ය මම චාතිථ්‍යකාරී ගායෝ යුෂ්මාන් නමස්කරෝති| අපරම් ඒතන්නගරස්‍ය ධනරක්‍ෂක ඉරාස්තඃ ක්කාර්ත්තනාමකශ්චෛකෝ භ්‍රාතා තාවපි යුෂ්මාන් නමස්කුරුතඃ| ");
INSERT INTO sansin_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","අස්මාකං ප්‍රභු ර‍්‍යීශුඛ්‍රීෂ්ටා යුෂ්මාසු සර්ව්වේෂු ප්‍රසාදං ක්‍රියාත්| ඉති| ");
INSERT INTO sansin_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","පූර්ව්වකාලිකයුගේෂු ප්‍රච්ඡන්නා යා මන්ත්‍රණාධුනා ප්‍රකාශිතා භූත්වා භවිෂ්‍යද්වාදිලිඛිතග්‍රන්ථගණස්‍ය ප්‍රමාණාද් විශ්වාසේන ග්‍රහණාර්ථං සදාතනස්‍යේශ්වරස්‍යාඥයා සර්ව්වදේශීයලෝකාන් ඥාප්‍යතේ, ");
INSERT INTO sansin_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","තස්‍යා මන්ත්‍රණායා ඥානං ලබ්ධ්වා මයා යඃ සුසංවාදෝ යීශුඛ්‍රීෂ්ටමධි ප්‍රචාර‍්‍ය්‍යතේ, තදනුසාරාද් යුෂ්මාන් ධර්ම්මේ සුස්ථිරාන් කර්ත්තුං සමර්ථෝ යෝ(අ)ද්විතීයඃ ");
INSERT INTO sansin_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","සර්ව්වඥ ඊශ්වරස්තස්‍ය ධන්‍යවාදෝ යීශුඛ්‍රීෂ්ටේන සන්තතං භූයාත්| ඉති|");
INSERT INTO sansin_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","යාවන්තඃ පවිත්‍රා ලෝකාඃ ස්වේෂාම් අස්මාකඤ්ච වසතිස්ථානේෂ්වස්මාකං ප්‍රභෝ ර‍්‍යීශෝඃ ඛ්‍රීෂ්ටස්‍ය නාම්නා ප්‍රාර්ථයන්තේ තෛඃ සහාහූතානාං ඛ්‍රීෂ්ටේන යීශුනා පවිත්‍රීකෘතානාං ලෝකානාං ය ඊශ්වරීයධර්ම්මසමාජඃ කරින්ථනගරේ විද්‍යතේ ");
INSERT INTO sansin_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","තං ප්‍රතීශ්වරස්‍යේච්ඡයාහූතෝ යීශුඛ්‍රීෂ්ටස්‍ය ප්‍රේරිතඃ පෞලඃ සෝස්ථිනිනාමා භ්‍රාතා ච පත්‍රං ලිඛති| ");
INSERT INTO sansin_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","අස්මාකං පිත්‍රේශ්වරේණ ප්‍රභුනා යීශුඛ්‍රීෂ්ටේන ච ප්‍රසාදඃ ශාන්තිශ්ච යුෂ්මභ්‍යං දීයතාං| ");
INSERT INTO sansin_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","ඊශ්වරෝ යීශුඛ්‍රීෂ්ටේන යුෂ්මාන් ප්‍රති ප්‍රසාදං ප්‍රකාශිතවාන්, තස්මාදහං යුෂ්මන්නිමිත්තං සර්ව්වදා මදීයේශ්වරං ධන්‍යං වදාමි| ");
INSERT INTO sansin_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","ඛ්‍රීෂ්ටසම්බන්ධීයං සාක්‍ෂ්‍යං යුෂ්මාකං මධ්‍යේ යේන ප්‍රකාරේණ සප්‍රමාණම් අභවත් ");
INSERT INTO sansin_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","තේන යූයං ඛ්‍රීෂ්ටාත් සර්ව්වවිධවක්තෘතාඥානාදීනි සර්ව්වධනානි ලබ්ධවන්තඃ| ");
INSERT INTO sansin_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","තතෝ(අ)ස්මත්ප්‍රභෝ ර‍්‍යීශුඛ්‍රීෂ්ටස්‍ය පුනරාගමනං ප්‍රතීක්‍ෂමාණානාං යුෂ්මාකං කස්‍යාපි වරස්‍යාභාවෝ න භවති| ");
INSERT INTO sansin_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","අපරම් අස්මාකං ප්‍රභෝ ර‍්‍යීශුඛ්‍රීෂ්ටස්‍ය දිවසේ යූයං යන්නිර්ද්දෝෂා භවේත තදර්ථං සඒව යාවදන්තං යුෂ්මාන් සුස්ථිරාන් කරිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","ය ඊශ්වරඃ ස්වපුත්‍රස්‍යාස්මත්ප්‍රභෝ ර‍්‍යීශුඛ්‍රීෂ්ටස්‍යාංශිනඃ කර්ත්තුං යුෂ්මාන් ආහූතවාන් ස විශ්වසනීයඃ| ");
INSERT INTO sansin_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","හේ භ්‍රාතරඃ, අස්මාකං ප්‍රභුයීශුඛ්‍රීෂ්ටස්‍ය නාම්නා යුෂ්මාන් විනයේ(අ)හං සර්ව්වෛ ර‍්‍යුෂ්මාභිරේකරූපාණි වාක්‍යානි කථ්‍යන්තාං යුෂ්මන්මධ්‍යේ භින්නසඞ්ඝාතා න භවන්තු මනෝවිචාරයෝරෛක්‍යේන යුෂ්මාකං සිද්ධත්වං භවතු| ");
INSERT INTO sansin_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","හේ මම භ්‍රාතරෝ යුෂ්මන්මධ්‍යේ විවාදා ජාතා ඉති වාර්ත්තාමහං ක්ලෝය්‍යාඃ පරිජනෛ ර්ඥාපිතඃ| ");
INSERT INTO sansin_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","මමාභිප්‍රේතමිදං යුෂ්මාකං කශ්චිත් කශ්චිද් වදති පෞලස්‍ය ශිෂ්‍යෝ(අ)හම් ආපල්ලෝඃ ශිෂ්‍යෝ(අ)හං කෛඵාඃ ශිෂ්‍යෝ(අ)හං ඛ්‍රීෂ්ටස්‍ය ශිෂ්‍යෝ(අ)හමිති ච| ");
INSERT INTO sansin_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","ඛ්‍රීෂ්ටස්‍ය කිං විභේදඃ කෘතඃ? පෞලඃ කිං යුෂ්මත්කෘතේ ක්‍රුශේ හතඃ? පෞලස්‍ය නාම්නා වා යූයං කිං මජ්ජිතාඃ? ");
INSERT INTO sansin_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","ක්‍රිෂ්පගායෞ විනා යුෂ්මාකං මධ්‍යේ(අ)න්‍යඃ කෝ(අ)පි මයා න මජ්ජිත ඉති හේතෝරහම් ඊශ්වරං ධන්‍යං වදාමි| ");
INSERT INTO sansin_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","ඒතේන මම නාම්නා මානවා මයා මජ්ජිතා ඉති වක්තුං කේනාපි න ශක්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","අපරං ස්තිඵානස්‍ය පරිජනා මයා මජ්ජිතාස්තදන්‍යඃ කශ්චිද් යන්මයා මජ්ජිතස්තදහං න වේද්මි| ");
INSERT INTO sansin_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","ඛ්‍රීෂ්ටේනාහං මජ්ජනාර්ථං න ප්‍රේරිතඃ කින්තු සුසංවාදස්‍ය ප්‍රචාරාර්ථමේව; සෝ(අ)පි වාක්පටුතයා මයා න ප්‍රචාරිතව්‍යඃ, යතස්තථා ප්‍රචාරිතේ ඛ්‍රීෂ්ටස්‍ය ක්‍රුශේ මෘත්‍යුඃ ඵලහීනෝ භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","යතෝ හේතෝ ර‍්‍යේ විනශ්‍යන්ති තේ තාං ක්‍රුශස්‍ය වාර්ත්තාං ප්‍රලාපමිව මන්‍යන්තේ කිඤ්ච පරිත්‍රාණං ලභමානේෂ්වස්මාසු සා ඊශ්වරීයශක්තිස්වරූපා| ");
INSERT INTO sansin_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","තස්මාදිත්ථං ලිඛිතමාස්තේ, ඥානවතාන්තු යත් ඥානං තන්මයා නාශයිෂ්‍යතේ| විලෝපයිෂ්‍යතේ තද්වද් බුද්ධි ර්බද්ධිමතාං මයා|| ");
INSERT INTO sansin_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","ඥානී කුත්‍ර? ශාස්ත්‍රී වා කුත්‍ර? ඉහලෝකස්‍ය විචාරතත්පරෝ වා කුත්‍ර? ඉහලෝකස්‍ය ඥානං කිමීශ්වරේණ මෝහීකෘතං නහි? ");
INSERT INTO sansin_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","ඊශ්වරස්‍ය ඥානාද් ඉහලෝකස්‍ය මානවාඃ ස්වඥානේනේශ්වරස්‍ය තත්ත්වබෝධං න ප්‍රාප්තවන්තස්තස්මාද් ඊශ්වරඃ ප්‍රචාරරූපිණා ප්‍රලාපේන විශ්වාසිනඃ පරිත්‍රාතුං රෝචිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","යිහූදීයලෝකා ලක්‍ෂණානි දිදෘක්‍ෂන්ති භින්නදේශීයලෝකාස්තු විද්‍යාං මෘගයන්තේ, ");
INSERT INTO sansin_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","වයඤ්ච ක්‍රුශේ හතං ඛ්‍රීෂ්ටං ප්‍රචාරයාමඃ| තස්‍ය ප්‍රචාරෝ යිහූදීයෛ ර්විඝ්න ඉව භින්නදේශීයෛශ්ච ප්‍රලාප ඉව මන්‍යතේ, ");
INSERT INTO sansin_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","කින්තු යිහූදීයානාං භින්නදේශීයානාඤ්ච මධ්‍යේ යේ ආහූතාස්තේෂු ස ඛ්‍රීෂ්ට ඊශ්වරීයශක්තිරිවේශ්වරීයඥානමිව ච ප්‍රකාශතේ| ");
INSERT INTO sansin_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","යත ඊශ්වරේ යඃ ප්‍රලාප ආරෝප්‍යතේ ස මානවාතිරික්තං ඥානමේව යච්ච දෞර්බ්බල්‍යම් ඊශ්වර ආරෝප්‍යතේ තත් මානවාතිරික්තං බලමේව| ");
INSERT INTO sansin_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","හේ භ්‍රාතරඃ, ආහූතයුෂ්මද්ගණෝ යෂ්මාභිරාලෝක්‍යතාං තන්මධ්‍යේ සාංසාරිකඥානේන ඥානවන්තඃ පරාක්‍රමිණෝ වා කුලීනා වා බහවෝ න විද්‍යන්තේ| ");
INSERT INTO sansin_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","යත ඊශ්වරෝ ඥානවතස්ත්‍රපයිතුං මූර්ඛලෝකාන් රෝචිතවාන් බලානි ච ත්‍රපයිතුම් ඊශ්වරෝ දුර්බ්බලාන් රෝචිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","තථා වර්ත්තමානලෝකාන් සංස්ථිතිභ්‍රෂ්ටාන් කර්ත්තුම් ඊශ්වරෝ ජගතෝ(අ)පකෘෂ්ටාන් හේයාන් අවර්ත්තමානාංශ්චාභිරෝචිතවාන්| ");
INSERT INTO sansin_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","තත ඊශ්වරස්‍ය සාක්‍ෂාත් කේනාප්‍යාත්මශ්ලාඝා න කර්ත්තව්‍යා| ");
INSERT INTO sansin_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","යූයඤ්ච තස්මාත් ඛ්‍රීෂ්ටේ යීශෞ සංස්ථිතිං ප්‍රාප්තවන්තඃ ස ඊශ්වරාද් යුෂ්මාකං ඥානං පුණ්‍යං පවිත්‍රත්වං මුක්තිශ්ච ජාතා| ");
INSERT INTO sansin_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","අතඒව යද්වද් ලිඛිතමාස්තේ තද්වත්, යඃ කශ්චිත් ශ්ලාඝමානඃ ස්‍යාත් ශ්ලාඝතාං ප්‍රභුනා ස හි| ");
INSERT INTO sansin_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","හේ භ්‍රාතරෝ යුෂ්මත්සමීපේ මමාගමනකාලේ(අ)හං වක්තෘතායා විද්‍යායා වා නෛපුණ්‍යේනේශ්වරස්‍ය සාක්‍ෂ්‍යං ප්‍රචාරිතවාන් තන්නහි; ");
INSERT INTO sansin_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","යතෝ යීශුඛ්‍රීෂ්ටං තස්‍ය ක්‍රුශේ හතත්වඤ්ච විනා නාන්‍යත් කිමපි යුෂ්මන්මධ්‍යේ ඥාපයිතුං විහිතං බුද්ධවාන්| ");
INSERT INTO sansin_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","අපරඤ්චාතීව දෞර්බ්බල්‍යභීතිකම්පයුක්තෝ යුෂ්මාභිඃ සාර්ද්ධමාසං| ");
INSERT INTO sansin_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","අපරං යුෂ්මාකං විශ්වාසෝ යත් මානුෂිකඥානස්‍ය ඵලං න භවේත් කින්ත්වීශ්වරීයශක්තේඃ ඵලං භවේත්, ");
INSERT INTO sansin_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","තදර්ථං මම වක්තෘතා මදීයප්‍රචාරශ්ච මානුෂිකඥානස්‍ය මධුරවාක්‍යසම්බලිතෞ නාස්තාං කින්ත්වාත්මනඃ ශක්තේශ්ච ප්‍රමාණයුක්තාවාස්තාං| ");
INSERT INTO sansin_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","වයං ඥානං භාෂාමහේ තච්ච සිද්ධලෝකෛ ර්ඥානමිව මන්‍යතේ, තදිහලෝකස්‍ය ඥානං නහි, ඉහලෝකස්‍ය නශ්වරාණාම් අධිපතීනාං වා ඥානං නහි; ");
INSERT INTO sansin_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","කින්තු කාලාවස්ථායාඃ පූර්ව්වස්මාද් යත් ඥානම් අස්මාකං විභවාර්ථම් ඊශ්වරේණ නිශ්චිත්‍ය ප්‍රච්ඡන්නං තන්නිගූඪම් ඊශ්වරීයඥානං ප්‍රභාෂාමහේ| ");
INSERT INTO sansin_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","ඉහලෝකස්‍යාධිපතීනාං කේනාපි තත් ඥානං න ලබ්ධං, ලබ්ධේ සති තේ ප්‍රභාවවිශිෂ්ටං ප්‍රභුං ක්‍රුශේ නාහනිෂ්‍යන්| ");
INSERT INTO sansin_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","තද්වල්ලිඛිතමාස්තේ, නේත්‍රේණ ක්කාපි නෝ දෘෂ්ටං කර්ණේනාපි ච න ශ්‍රුතං| මනෝමධ්‍යේ තු කස්‍යාපි න ප්‍රවිෂ්ටං කදාපි යත්| ඊශ්වරේ ප්‍රීයමාණානාං කෘතේ තත් තේන සඤ්චිතං| ");
INSERT INTO sansin_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","අපරමීශ්වරඃ ස්වාත්මනා තදස්මාකං සාක්‍ෂාත් ප්‍රාකාශයත්; යත ආත්මා සර්ව්වමේවානුසන්ධත්තේ තේන චේශ්වරස්‍ය මර්ම්මතත්ත්වමපි බුධ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","මනුජස්‍යාන්තඃස්ථමාත්මානං විනා කේන මනුජේන තස්‍ය මනුජස්‍ය තත්ත්වං බුධ්‍යතේ? තද්වදීශ්වරස්‍යාත්මානං විනා කේනාපීශ්වරස්‍ය තත්ත්වං න බුධ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","වයඤ්චේහලෝකස්‍යාත්මානං ලබ්ධවන්තස්තන්නහි කින්ත්වීශ්වරස්‍යෛවාත්මානං ලබ්ධවන්තඃ, තතෝ හේතෝරීශ්වරේණ ස්වප්‍රසාදාද් අස්මභ්‍යං යද් යද් දත්තං තත්සර්ව්වම් අස්මාභි ර්ඥාතුං ශක්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","තච්චාස්මාභි ර්මානුෂිකඥානස්‍ය වාක්‍යානි ශික්‍ෂිත්වා කථ්‍යත ඉති නහි කින්ත්වාත්මතෝ වාක්‍යානි ශික්‍ෂිත්වාත්මිකෛ ර්වාක්‍යෛරාත්මිකං භාවං ප්‍රකාශයද්භිඃ කථ්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","ප්‍රාණී මනුෂ්‍ය ඊශ්වරීයාත්මනඃ ශික්‍ෂාං න ගෘහ්ලාති යත ආත්මිකවිචාරේණ සා විචාර‍්‍ය්‍යේති හේතෝඃ ස තාං ප්‍රලාපමිව මන්‍යතේ බෝද්ධුඤ්ච න ශක්නෝති| ");
INSERT INTO sansin_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","ආත්මිකෝ මානවඃ සර්ව්වාණි විචාරයති කින්තු ස්වයං කේනාපි න විචාර‍්‍ය්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","යත ඊශ්වරස්‍ය මනෝ ඥාත්වා තමුපදේෂ්ටුං කඃ ශක්නෝති? කින්තු ඛ්‍රීෂ්ටස්‍ය මනෝ(අ)ස්මාභි ර්ලබ්ධං| ");
INSERT INTO sansin_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","හේ භ්‍රාතරඃ, අහමාත්මිකෛරිව යුෂ්මාභිඃ සමං සම්භාෂිතුං නාශක්නවං කින්තු ශාරීරිකාචාරිභිඃ ඛ්‍රීෂ්ටධර්ම්මේ ශිශුතුල්‍යෛශ්ච ජනෛරිව යුෂ්මාභිඃ සහ සමභාෂේ| ");
INSERT INTO sansin_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","යුෂ්මාන් කඨිනභක්‍ෂ්‍යං න භෝජයන් දුග්ධම් අපායයං යතෝ යූයං භක්‍ෂ්‍යං ග්‍රහීතුං තදා නාශක්නුත ඉදානීමපි න ශක්නුථ, යතෝ හේතෝරධුනාපි ශාරීරිකාචාරිණ ආධ්වේ| ");
INSERT INTO sansin_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","යුෂ්මන්මධ්‍යේ මාත්සර‍්‍ය්‍යවිවාදභේදා භවන්ති තතඃ කිං ශාරීරිකාචාරිණෝ නාධ්වේ මානුෂිකමාර්ගේණ ච න චරථ? ");
INSERT INTO sansin_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","පෞලස්‍යාහමිත්‍යාපල්ලෝරහමිති වා යද්වාක්‍යං යුෂ්මාකං කෛශ්චිත් කෛශ්චිත් කථ්‍යතේ තස්මාද් යූයං ශාරීරිකාචාරිණ න භවථ? ");
INSERT INTO sansin_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","පෞලඃ කඃ? ආපල්ලෝ ර්වා කඃ? තෞ පරිචාරකමාත්‍රෞ තයෝරේකෛකස්මෛ ච ප්‍රභු ර‍්‍යාදෘක් ඵලමදදාත් තද්වත් තයෝර්ද්වාරා යූයං විශ්වාසිනෝ ජාතාඃ| ");
INSERT INTO sansin_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","අහං රෝපිතවාන් ආපල්ලෝශ්ච නිෂික්තවාන් ඊශ්වරශ්චාවර්ද්ධයත්| ");
INSERT INTO sansin_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","අතෝ රෝපයිතෘසේක්තාරාවසාරෞ වර්ද්ධයිතේශ්වර ඒව සාරඃ| ");
INSERT INTO sansin_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","රෝපයිතෘසේක්තාරෞ ච සමෞ තයෝරේකෛකශ්ච ස්වශ්‍රමයෝග්‍යං ස්වවේතනං ලප්ස්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","ආවාමීශ්වරේණ සහ කර්ම්මකාරිණෞ, ඊශ්වරස්‍ය යත් ක්‍ෂේත්‍රම් ඊශ්වරස්‍ය යා නිර්ම්මිතිඃ සා යූයමේව| ");
INSERT INTO sansin_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","ඊශ්වරස්‍ය ප්‍රසාදාත් මයා යත් පදං ලබ්ධං තස්මාත් ඥානිනා ගෘහකාරිණේව මයා භිත්තිමූලං ස්ථාපිතං තදුපරි චාන්‍යේන නිචීයතේ| කින්තු යේන යන්නිචීයතේ තත් තේන විවිච්‍යතාං| ");
INSERT INTO sansin_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","යතෝ යීශුඛ්‍රීෂ්ටරූපං යද් භිත්තිමූලං ස්ථාපිතං තදන්‍යත් කිමපි භිත්තිමූලං ස්ථාපයිතුං කේනාපි න ශක්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","ඒතද්භිත්තිමූලස්‍යෝපරි යදි කේචිත් ස්වර්ණරූප්‍යමණිකාෂ්ඨතෘණනලාන් නිචින්වන්ති, ");
INSERT INTO sansin_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","තර්හ්‍යේකෛකස්‍ය කර්ම්ම ප්‍රකාශිෂ්‍යතේ යතඃ ස දිවසස්තත් ප්‍රකාශයිෂ්‍යති| යතෝ හතෝස්තන දිවසේන වහ්නිමයේනෝදේතව්‍යං තත ඒකෛකස්‍ය කර්ම්ම කීදෘශමේතස්‍ය පරීක්‍ෂා බහ්නිනා භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","යස්‍ය නිචයනරූපං කර්ම්ම ස්ථාස්නු භවිෂ්‍යති ස වේතනං ලප්ස්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","යස්‍ය ච කර්ම්ම ධක්‍ෂ්‍යතේ තස්‍ය ක්‍ෂති ර්භවිෂ්‍යති කින්තු වහ්නේ ර්නිර්ගතජන ඉව ස ස්වයං පරිත්‍රාණං ප්‍රාප්ස්‍යති| ");
INSERT INTO sansin_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","යූයම් ඊශ්වරස්‍ය මන්දිරං යුෂ්මන්මධ්‍යේ චේශ්වරස්‍යාත්මා නිවසතීති කිං න ජානීථ? ");
INSERT INTO sansin_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","ඊශ්වරස්‍ය මන්දිරං යේන විනාශ්‍යතේ සෝ(අ)පීශ්වරේණ විනාශයිෂ්‍යතේ යත ඊශ්වරස්‍ය මන්දිරං පවිත්‍රමේව යූයං තු තන්මන්දිරම් ආධ්වේ| ");
INSERT INTO sansin_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","කෝපි ස්වං න වඤ්චයතාං| යුෂ්මාකං කශ්චන චේදිහලෝකස්‍ය ඥානේන ඥානවානහමිති බුධ්‍යතේ තර්හි ස යත් ඥානී භවේත් තදර්ථං මූඪෝ භවතු| ");
INSERT INTO sansin_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","යස්මාදිහලෝකස්‍ය ඥානම් ඊශ්වරස්‍ය සාක්‍ෂාත් මූඪත්වමේව| ඒතස්මින් ලිඛිතමප්‍යාස්තේ, තීක්‍ෂ්ණා යා ඥානිනාං බුද්ධිස්තයා තාන් ධරතීශ්වරඃ| ");
INSERT INTO sansin_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","පුනශ්ච| ඥානිනාං කල්පනා වේත්ති පරමේශෝ නිරර්ථකාඃ| ");
INSERT INTO sansin_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","අතඒව කෝ(අ)පි මනුජෛරාත්මානං න ශ්ලාඝතාං යතඃ සර්ව්වාණි යුෂ්මාකමේව, ");
INSERT INTO sansin_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","පෞල වා ආපල්ලෝ ර්වා කෛඵා වා ජගද් වා ජීවනං වා මරණං වා වර්ත්තමානං වා භවිෂ්‍යද්වා සර්ව්වාණ්‍යේව යුෂ්මාකං, ");
INSERT INTO sansin_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","යූයඤ්ච ඛ්‍රීෂ්ටස්‍ය, ඛ්‍රීෂ්ටශ්චේශ්වරස්‍ය| ");
INSERT INTO sansin_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","ලෝකා අස්මාන් ඛ්‍රීෂ්ටස්‍ය පරිචාරකාන් ඊශ්වරස්‍ය නිගූඨවාක්‍යධනස්‍යාධ්‍යක්‍ෂාංශ්ච මන්‍යන්තාං| ");
INSERT INTO sansin_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","කිඤ්ච ධනාධ්‍යක්‍ෂේණ විශ්වසනීයේන භවිතව්‍යමේතදේව ලෝකෛ ර‍්‍යාච්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","අතෝ විචාරයද්භි ර‍්‍යුෂ්මාභිරන්‍යෛඃ කෛශ්චින් මනුජෛ ර්වා මම පරීක්‍ෂණං මයාතීව ලඝු මන්‍යතේ (අ)හමප්‍යාත්මානං න විචාරයාමි| ");
INSERT INTO sansin_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","මයා කිමප්‍යපරාද්ධමිත්‍යහං න වේද්මි කින්ත්වේතේන මම නිරපරාධත්වං න නිශ්චීයතේ ප්‍රභුරේව මම විචාරයිතාස්ති| ");
INSERT INTO sansin_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","අත උපයුක්තසමයාත් පූර්ව්වම් අර්ථතඃ ප්‍රභෝරාගමනාත් පූර්ව්වං යුෂ්මාභි ර්විචාරෝ න ක්‍රියතාං| ප්‍රභුරාගත්‍ය තිමිරේණ ප්‍රච්ඡන්නානි සර්ව්වාණි දීපයිෂ්‍යති මනසාං මන්ත්‍රණාශ්ච ප්‍රකාශයිෂ්‍යති තස්මින් සමය ඊශ්වරාද් ඒකෛකස්‍ය ප්‍රශංසා භවිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","හේ භ්‍රාතරඃ සර්ව්වාණ්‍යේතානි මයාත්මානම් ආපල්ලවඤ්චෝද්දිශ්‍ය කථිතානි තස්‍යෛතත් කාරණං යුයං යථා ශාස්ත්‍රීයවිධිමතික්‍රම්‍ය මානවම් අතීව නාදරිෂ්‍යධ්බ ඊත්ථඤ්චෛකේන වෛපරීත්‍යාද් අපරේණ න ශ්ලාඝිෂ්‍යධ්බ ඒතාදෘශීං ශික්‍ෂාමාවයෝර්දෘෂ්ටාන්තාත් ලප්ස්‍යධ්වේ| ");
INSERT INTO sansin_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","අපරාත් කස්ත්වාං විශේෂයති? තුභ්‍යං යන්න දත්ත තාදෘශං කිං ධාරයසි? අදත්තේනේව දත්තේන වස්තුනා කුතඃ ශ්ලාඝසේ? ");
INSERT INTO sansin_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","ඉදානීමේව යූයං කිං තෘප්තා ලබ්ධධනා වා? අස්මාස්වවිද්‍යමානේෂු යූයං කිං රාජත්වපදං ප්‍රාප්තාඃ? යුෂ්මාකං රාජත්වං මයාභිලෂිතං යතස්තේන යුෂ්මාභිඃ සහ වයමපි රාජ්‍යාංශිනෝ භවිෂ්‍යාමඃ| ");
INSERT INTO sansin_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","ප්‍රේරිතා වයං ශේෂා හන්තව්‍යාශ්චේවේශ්වරේණ නිදර්ශිතාඃ| යතෝ වයං සර්ව්වලෝකානාම් අර්ථතඃ ස්වර්ගීයදූතානාං මානවානාඤ්ච කෞතුකාස්පදානි ජාතාඃ| ");
INSERT INTO sansin_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","ඛ්‍රීෂ්ටස්‍ය කෘතේ වයං මූඪාඃ කින්තු යූයං ඛ්‍රීෂ්ටේන ඥානිනඃ, වයං දුර්බ්බලා යූයඤ්ච සබලාඃ, යූයං සම්මානිතා වයඤ්චාපමානිතාඃ| ");
INSERT INTO sansin_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","වයමද්‍යාපි ක්‍ෂුධාර්ත්තාස්තෘෂ්ණාර්ත්තා වස්ත්‍රහීනාස්තාඩිතා ආශ්‍රමරහිතාශ්ච සන්තඃ ");
INSERT INTO sansin_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","කර්ම්මණි ස්වකරාන් ව්‍යාපාරයන්තශ්ච දුඃඛෛඃ කාලං යාපයාමඃ| ගර්හිතෛරස්මාභිරාශීඃ කථ්‍යතේ දූරීකෘතෛඃ සහ්‍යතේ නින්දිතෛඃ ප්‍රසාද්‍යතේ| ");
INSERT INTO sansin_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","වයමද්‍යාපි ජගතඃ සම්මාර්ජනීයෝග්‍යා අවකරා ඉව සර්ව්වෛ ර්මන්‍යාමහේ| ");
INSERT INTO sansin_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","යුෂ්මාන් ත්‍රපයිතුමහමේතානි ලිඛාමීති නහි කින්තු ප්‍රියාත්මජානිව යුෂ්මාන් ප්‍රබෝධයාමි| ");
INSERT INTO sansin_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","යතඃ ඛ්‍රීෂ්ටධර්ම්මේ යද්‍යපි යුෂ්මාකං දශසහස්‍රාණි විනේතාරෝ භවන්ති තථාපි බහවෝ ජනකා න භවන්ති යතෝ(අ)හමේව සුසංවාදේන යීශුඛ්‍රීෂ්ටේ යුෂ්මාන් අජනයං| ");
INSERT INTO sansin_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","අතෝ යුෂ්මාන් විනයේ(අ)හං යූයං මදනුගාමිනෝ භවත| ");
INSERT INTO sansin_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","ඉත්‍යර්ථං සර්ව්වේෂු ධර්ම්මසමාජේෂු සර්ව්වත්‍ර ඛ්‍රීෂ්ටධර්ම්මයෝග්‍යා යේ විධයෝ මයෝපදිශ්‍යන්තේ තාන් යෝ යුෂ්මාන් ස්මාරයිෂ්‍යත්‍යේවම්භූතං ප්‍රභෝඃ කෘතේ ප්‍රියං විශ්වාසිනඤ්ච මදීයතනයං තීමථියං යුෂ්මාකං සමීපං ප්‍රේෂිතවානහං| ");
INSERT INTO sansin_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","අපරමහං යුෂ්මාකං සමීපං න ගමිෂ්‍යාමීති බුද්ධ්වා යුෂ්මාකං කියන්තෝ ලෝකා ගර්ව්වන්ති| ");
INSERT INTO sansin_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","කින්තු යදි ප්‍රභේරිච්ඡා භවති තර්හ්‍යහමවිලම්බං යුෂ්මත්සමීපමුපස්ථාය තේෂාං දර්පධ්මාතානාං ලෝකානාං වාචං ඥාස්‍යාමීති නහි සාමර්ථ්‍යමේව ඥාස්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","යස්මාදීශ්වරස්‍ය රාජත්වං වාග්‍යුක්තං නහි කින්තු සාමර්ථ්‍යයුක්තං| ");
INSERT INTO sansin_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","යුෂ්මාකං කා වාඤ්ඡා? යුෂ්මත්සමීපේ මයා කිං දණ්ඩපාණිනා ගන්තව්‍යමුත ප්‍රේමනම්‍රතාත්මයුක්තේන වා? ");
INSERT INTO sansin_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","අපරං යුෂ්මාකං මධ්‍යේ ව්‍යභිචාරෝ විද්‍යතේ ස ච ව්‍යභිචාරස්තාදෘශෝ යද් දේවපූජකානාං මධ්‍යේ(අ)පි තත්තුල්‍යෝ න විද්‍යතේ ඵලතෝ යුෂ්මාකමේකෝ ජනෝ විමාතෘගමනං කෘරුත ඉති වාර්ත්තා සර්ව්වත්‍ර ව්‍යාප්තා| ");
INSERT INTO sansin_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","තථාච යූයං දර්පධ්මාතා ආධ්බේ, තත් කර්ම්ම යේන කෘතං ස යථා යුෂ්මන්මධ්‍යාද් දූරීක්‍රියතේ තථා ශෝකෝ යුෂ්මාභි ර්න ක්‍රියතේ කිම් ඒතත්? ");
INSERT INTO sansin_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","අවිද්‍යමානේ මදීයශරීරේ මමාත්මා යුෂ්මන්මධ්‍යේ විද්‍යතේ අතෝ(අ)හං විද්‍යමාන ඉව තත්කර්ම්මකාරිණෝ විචාරං නිශ්චිතවාන්, ");
INSERT INTO sansin_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","අස්මත්ප්‍රභෝ ර‍්‍යීශුඛ්‍රීෂ්ටස්‍ය නාම්නා යුෂ්මාකං මදීයාත්මනශ්ච මිලනේ ජාතේ (අ)ස්මත්ප්‍රභෝ ර‍්‍යීශුඛ්‍රීෂ්ටස්‍ය ශක්තේඃ සාහාය්‍යේන ");
INSERT INTO sansin_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","ස නරඃ ශරීරනාශාර්ථමස්මාභිඃ ශයතානෝ හස්තේ සමර්පයිතව්‍යස්තතෝ(අ)ස්මාකං ප්‍රභෝ ර‍්‍යීශෝ ර්දිවසේ තස්‍යාත්මා රක්‍ෂාං ගන්තුං ශක්‍ෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","යුෂ්මාකං දර්පෝ න භද්‍රාය යූයං කිමේතන්න ජානීථ, යථා, විකාරඃ කෘත්ස්නශක්තූනාං ස්වල්පකිණ්වේන ජායතේ| ");
INSERT INTO sansin_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","යූයං යත් නවීනශක්තුස්වරූපා භවේත තදර්ථං පුරාතනං කිණ්වම් අවමාර්ජ්ජත යතෝ යුෂ්මාභිඃ කිණ්වශූන්‍යෛ ර්භවිතව්‍යං| අපරම් අස්මාකං නිස්තාරෝත්සවීයමේෂශාවකෝ යඃ ඛ්‍රීෂ්ටඃ සෝ(අ)ස්මදර්ථං බලීකෘතෝ (අ)භවත්| ");
INSERT INTO sansin_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","අතඃ පුරාතනකිණ්වේනාර්ථතෝ දුෂ්ටතාජිඝාංසාරූපේණ කිණ්වේන තන්නහි කින්තු සාරල්‍යසත්‍යත්වරූපයා කිණ්වශූන්‍යතයාස්මාභිරුත්සවඃ කර්ත්තව්‍යඃ| ");
INSERT INTO sansin_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","ව්‍යාභිචාරිණාං සංසර්ගෝ යුෂ්මාභි ර්විහාතව්‍ය ඉති මයා පත්‍රේ ලිඛිතං| ");
INSERT INTO sansin_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","කින්ත්වෛහිකලෝකානාං මධ්‍යේ යේ ව්‍යභිචාරිණෝ ලෝභින උපද්‍රාවිණෝ දේවපූජකා වා තේෂාං සංසර්ගඃ සර්ව්වථා විහාතව්‍ය ඉති නහි, විහාතව්‍යේ සති යුෂ්මාභි ර්ජගතෝ නිර්ගන්තව්‍යමේව| ");
INSERT INTO sansin_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","කින්තු භ්‍රාතෘත්වේන විඛ්‍යාතඃ කශ්චිජ්ජනෝ යදි ව්‍යභිචාරී ලෝභී දේවපූජකෝ නින්දකෝ මද්‍යප උපද්‍රාවී වා භවේත් තර්හි තාදෘශේන මානවේන සහ භෝජනපානේ(අ)පි යුෂ්මාභි ර්න කර්ත්තව්‍යේ ඉත්‍යධුනා මයා ලිඛිතං| ");
INSERT INTO sansin_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","සමාජබහිඃස්ථිතානාං ලෝකානාං විචාරකරණේ මම කෝ(අ)ධිකාරඃ? කින්තු තදන්තර්ගතානාං විචාරණං යුෂ්මාභිඃ කිං න කර්ත්තව්‍යං භවේත්? ");
INSERT INTO sansin_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","බහිඃස්ථානාං තු විචාර ඊශ්වරේණ කාරිෂ්‍යතේ| අතෝ යුෂ්මාභිඃ ස පාතකී ස්වමධ්‍යාද් බහිෂ්ක්‍රියතාං| ");
INSERT INTO sansin_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","යුෂ්මාකමේකස්‍ය ජනස්‍යාපරේණ සහ විවාදේ ජාතේ ස පවිත්‍රලෝකෛ ර්විචාරමකාරයන් කිම් අධාර්ම්මිකලෝකෛ ර්විචාරයිතුං ප්‍රෝත්සහතේ? ");
INSERT INTO sansin_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","ජගතෝ(අ)පි විචාරණං පවිත්‍රලෝකෛඃ කාරිෂ්‍යත ඒතද් යූයං කිං න ජානීථ? අතෝ ජගද් යදි යුෂ්මාභි ර්විචාරයිතව්‍යං තර්හි ක්‍ෂුද්‍රතමවිචාරේෂු යූයං කිමසමර්ථාඃ? ");
INSERT INTO sansin_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","දූතා අප්‍යස්මාභි ර්විචාරයිෂ්‍යන්ත ඉති කිං න ජානීථ? අත ඓහිකවිෂයාඃ කිම් අස්මාභි ර්න විචාරයිතව්‍යා භවේයුඃ? ");
INSERT INTO sansin_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","ඓහිකවිෂයස්‍ය විචාරේ යුෂ්මාභිඃ කර්ත්තව්‍යේ යේ ලෝකාඃ සමිතෞ ක්‍ෂුද්‍රතමාස්ත ඒව නියුජ්‍යන්තාං| ");
INSERT INTO sansin_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","අහං යුෂ්මාන් ත්‍රපයිතුමිච්ඡන් වදාමි යෘෂ්මන්මධ්‍යේ කිමේකෝ(අ)පි මනුෂ්‍යස්තාදෘග් බුද්ධිමාන්නහි යෝ භ්‍රාතෘවිවාදවිචාරණේ සමර්ථඃ ස්‍යාත්? ");
INSERT INTO sansin_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","කිඤ්චෛකෝ භ්‍රාතා භ්‍රාත්‍රාන්‍යේන කිමවිශ්වාසිනාං විචාරකාණාං සාක්‍ෂාද් විවදතේ? යෂ්මන්මධ්‍යේ විවාදා විද්‍යන්ත ඒතදපි යුෂ්මාකං දෝෂඃ| ");
INSERT INTO sansin_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","යූයං කුතෝ(අ)න්‍යායසහනං ක්‍ෂතිසහනං වා ශ්‍රේයෝ න මන්‍යධ්වේ? ");
INSERT INTO sansin_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","කින්තු යූයමපි භ්‍රාතෘනේව ප්‍රත්‍යන්‍යායං ක්‍ෂතිඤ්ච කුරුථ කිමේතත්? ");
INSERT INTO sansin_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","ඊශ්වරස්‍ය රාජ්‍යේ(අ)න්‍යායකාරිණාං ලෝකානාමධිකාරෝ නාස්ත්‍යේතද් යූයං කිං න ජානීථ? මා වඤ්ච්‍යධ්වං, යේ ව්‍යභිචාරිණෝ දේවාර්ච්චිනඃ පාරදාරිකාඃ ස්ත්‍රීවදාචාරිණඃ පුංමෛථුනකාරිණස්තස්කරා ");
INSERT INTO sansin_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","ලෝභිනෝ මද්‍යපා නින්දකා උපද්‍රාවිණෝ වා ත ඊශ්වරස්‍ය රාජ්‍යභාගිනෝ න භවිෂ්‍යන්ති| ");
INSERT INTO sansin_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","යූයඤ්චෛවංවිධා ලෝකා ආස්ත කින්තු ප්‍රභෝ ර‍්‍යීශෝ ර්නාම්නාස්මදීශ්වරස්‍යාත්මනා ච යූයං ප්‍රක්‍ෂාලිතාඃ පාවිතාඃ සපුණ්‍යීකෘතාශ්ච| ");
INSERT INTO sansin_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","මදර්ථං සර්ව්වං ද්‍රව්‍යම් අප්‍රතිෂිද්ධං කින්තු න සර්ව්වං හිතජනකං| මදර්ථං සර්ව්වමප්‍රතිෂිද්ධං තථාප්‍යහං කස්‍යාපි ද්‍රව්‍යස්‍ය වශීකෘතෝ න භවිෂ්‍යාමි| ");
INSERT INTO sansin_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","උදරාය භක්‍ෂ්‍යාණි භක්‍ෂ්‍යේභ්‍යශ්චෝදරං, කින්තු භක්‍ෂ්‍යෝදරේ ඊශ්වරේණ නාශයිෂ්‍යේතේ; අපරං දේහෝ න ව්‍යභිචාරාය කින්තු ප්‍රභවේ ප්‍රභුශ්ච දේහාය| ");
INSERT INTO sansin_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","යශ්චේශ්වරඃ ප්‍රභුමුත්ථාපිතවාන් ස ස්වශක්ත්‍යාස්මානප්‍යුත්ථාපයිෂ්‍යති| ");
INSERT INTO sansin_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","යුෂ්මාකං යානි ශරීරාණි තානි ඛ්‍රීෂ්ටස්‍යාඞ්ගානීති කිං යූයං න ජානීථ? අතඃ ඛ්‍රීෂ්ටස්‍ය යාන්‍යඞ්ගානි තානි මයාපහෘත්‍ය වේශ්‍යායා අඞ්ගානි කිං කාරිෂ්‍යන්තේ? තන්න භවතු| ");
INSERT INTO sansin_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","යඃ කශ්චිද් වේශ්‍යායාම් ආසජ්‍යතේ ස තයා සහෛකදේහෝ භවති කිං යූයමේතන්න ජානීථ? යතෝ ලිඛිතමාස්තේ, යථා, තෞ ද්වෞ ජනාවේකාඞ්ගෞ භවිෂ්‍යතඃ| ");
INSERT INTO sansin_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","මානවා යාන්‍යන්‍යානි කලුෂාණි කුර්ව්වතේ තානි වපු ර්න සමාවිශන්ති කින්තු ව්‍යභිචාරිණා ස්වවිග්‍රහස්‍ය විරුද්ධං කල්මෂං ක්‍රියතේ| ");
INSERT INTO sansin_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","මානවා යාන්‍යන්‍යානි කලුෂාණි කුර්ව්වතේ තානි වපු ර්න සමාවිශන්ති කින්තු ව්‍යභිචාරිණා ස්වවිග්‍රහස්‍ය විරුද්ධං කල්මෂං ක්‍රියතේ| ");
INSERT INTO sansin_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","යුෂ්මාකං යානි වපූංසි තානි යුෂ්මදන්තඃස්ථිතස්‍යේශ්වරාල්ලබ්ධස්‍ය පවිත්‍රස්‍යාත්මනෝ මන්දිරාණි යූයඤ්ච ස්වේෂාං ස්වාමිනෝ නාධ්වේ කිමේතද් යුෂ්මාභි ර්න ඥායතේ? ");
INSERT INTO sansin_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","යූයං මූල්‍යේන ක්‍රීතා අතෝ වපුර්මනෝභ්‍යාම් ඊශ්වරෝ යුෂ්මාභිඃ පූජ්‍යතාං යත ඊශ්වර ඒව තයෝඃ ස්වාමී| ");
INSERT INTO sansin_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","අපරඤ්ච යුෂ්මාභි ර්මාං ප්‍රති යත් පත්‍රමලේඛි තස්‍යෝත්තරමේතත්, යෝෂිතෝ(අ)ස්පර්ශනං මනුජස්‍ය වරං; ");
INSERT INTO sansin_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","කින්තු ව්‍යභිචාරභයාද් ඒකෛකස්‍ය පුංසඃ ස්වකීයභාර‍්‍ය්‍යා භවතු තද්වද් ඒකෛකස්‍යා යෝෂිතෝ (අ)පි ස්වකීයභර්ත්තා භවතු| ");
INSERT INTO sansin_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","භාර‍්‍ය්‍යායෛ භර්ත්‍රා යද්‍යද් විතරණීයං තද් විතීර‍්‍ය්‍යතාං තද්වද් භර්ත්‍රේ(අ)පි භාර‍්‍ය්‍යයා විතරණීයං විතීර‍්‍ය්‍යතාං| ");
INSERT INTO sansin_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","භාර‍්‍ය්‍යායාඃ ස්වදේහේ ස්වත්වං නාස්ති භර්ත්තුරේව, තද්වද් භර්ත්තුරපි ස්වදේහේ ස්වත්වං නාස්ති භාර‍්‍ය්‍යායා ඒව| ");
INSERT INTO sansin_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","උපෝෂණප්‍රාර්ථනයෝඃ සේවනාර්ථම් ඒකමන්ත්‍රණානාං යුෂ්මාකං කියත්කාලං යාවද් යා පෘථක්ස්ථිති ර්භවති තදන්‍යෝ විච්ඡේදෝ යුෂ්මන්මධ්‍යේ න භවතු, තතඃ පරම් ඉන්ද්‍රියාණාම් අධෛර‍්‍ය්‍යාත් ශයතාන් යද් යුෂ්මාන් පරීක්‍ෂාං න නයේත් තදර්ථං පුනරේකත්‍ර මිලත| ");
INSERT INTO sansin_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","ඒතද් ආදේශතෝ නහි කින්ත්වනුඥාත ඒව මයා කථ්‍යතේ, ");
INSERT INTO sansin_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","යතෝ මමාවස්ථේව සර්ව්වමානවානාමවස්ථා භවත්විති මම වාඤ්ඡා කින්ත්වීශ්වරාද් ඒකේනෛකෝ වරෝ(අ)න්‍යේන චාන්‍යෝ වර ඉත්ථමේකෛකේන ස්වකීයවරෝ ලබ්ධඃ| ");
INSERT INTO sansin_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","අපරම් අකෘතවිවාහාන් විධවාශ්ච ප්‍රති මමෛතන්නිවේදනං මමේව තේෂාමවස්ථිති ර්භද්‍රා; ");
INSERT INTO sansin_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","කිඤ්ච යදි තෛරින්ද්‍රියාණි නියන්තුං න ශක්‍යන්තේ තර්හි විවාහඃ ක්‍රියතාං යතඃ කාමදහනාද් ව්‍යූඪත්වං භද්‍රං| ");
INSERT INTO sansin_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","යේ ච කෘතවිවාහාස්තේ මයා නහි ප්‍රභුනෛවෛතද් ආඥාප්‍යන්තේ| ");
INSERT INTO sansin_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","භාර‍්‍ය්‍යා භර්ත්තෘතඃ ප