﻿USE sofia;
DROP TABLE IF EXISTS sofia.sanpun_vpl;
CREATE TABLE sanpun_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sanpun_vpl WRITE;
INSERT INTO sanpun_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ਇਬ੍ਰਾਹੀਮਃ ਸਨ੍ਤਾਨੋ ਦਾਯੂਦ੍ ਤਸ੍ਯ ਸਨ੍ਤਾਨੋ ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟਸ੍ਤਸ੍ਯ ਪੂਰ੍ੱਵਪੁਰੁਸ਼਼ਵੰਸ਼ਸ਼੍ਰੇਣੀ| ");
INSERT INTO sanpun_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ਇਬ੍ਰਾਹੀਮਃ ਪੁਤ੍ਰ ਇਸ੍ਹਾਕ੍ ਤਸ੍ਯ ਪੁਤ੍ਰੋ ਯਾਕੂਬ੍ ਤਸ੍ਯ ਪੁਤ੍ਰੋ ਯਿਹੂਦਾਸ੍ਤਸ੍ਯ ਭ੍ਰਾਤਰਸ਼੍ਚ| ");
INSERT INTO sanpun_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ਤਸ੍ਮਾਦ੍ ਯਿਹੂਦਾਤਸ੍ਤਾਮਰੋ ਗਰ੍ਭੇ ਪੇਰੱਸੇਰਹੌ ਜਜ੍ਞਾਤੇ, ਤਸ੍ਯ ਪੇਰਸਃ ਪੁਤ੍ਰੋ ਹਿਸ਼਼੍ਰੋਣ੍ ਤਸ੍ਯ ਪੁਤ੍ਰੋ (ਅ)ਰਾਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ਤਸ੍ਯ ਪੁਤ੍ਰੋ (ਅ)ੰਮੀਨਾਦਬ੍ ਤਸ੍ਯ ਪੁਤ੍ਰੋ ਨਹਸ਼ੋਨ੍ ਤਸ੍ਯ ਪੁਤ੍ਰਃ ਸਲ੍ਮੋਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ਤਸ੍ਮਾਦ੍ ਰਾਹਬੋ ਗਰ੍ਭੇ ਬੋਯਮ੍ ਜਜ੍ਞੇ, ਤਸ੍ਮਾਦ੍ ਰੂਤੋ ਗਰ੍ਭੇ ਓਬੇਦ੍ ਜਜ੍ਞੇ, ਤਸ੍ਯ ਪੁਤ੍ਰੋ ਯਿਸ਼ਯਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ਤਸ੍ਯ ਪੁਤ੍ਰੋ ਦਾਯੂਦ੍ ਰਾਜਃ ਤਸ੍ਮਾਦ੍ ਮ੍ਰੁʼਤੋਰਿਯਸ੍ਯ ਜਾਯਾਯਾਂ ਸੁਲੇਮਾਨ੍ ਜਜ੍ਞੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ਤਸ੍ਯ ਪੁਤ੍ਰੋ ਰਿਹਬਿਯਾਮ੍, ਤਸ੍ਯ ਪੁਤ੍ਰੋ(ਅ)ਬਿਯਃ, ਤਸ੍ਯ ਪੁਤ੍ਰ ਆਸਾ:| ");
INSERT INTO sanpun_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ਤਸ੍ਯ ਸੁਤੋ ਯਿਹੋਸ਼ਾਫਟ੍ ਤਸ੍ਯ ਸੁਤੋ ਯਿਹੋਰਾਮ ਤਸ੍ਯ ਸੁਤ ਉਸ਼਼ਿਯਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ਤਸ੍ਯ ਸੁਤੋ ਯੋਥਮ੍ ਤਸ੍ਯ ਸੁਤ ਆਹਮ੍ ਤਸ੍ਯ ਸੁਤੋ ਹਿਸ਼਼੍ਕਿਯਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ਤਸ੍ਯ ਸੁਤੋ ਮਿਨਸ਼ਿਃ, ਤਸ੍ਯ ਸੁਤ ਆਮੋਨ੍ ਤਸ੍ਯ ਸੁਤੋ ਯੋਸ਼ਿਯਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ਬਾਬਿਲ੍ਨਗਰੇ ਪ੍ਰਵਸਨਾਤ੍ ਪੂਰ੍ੱਵੰ ਸ ਯੋਸ਼ਿਯੋ ਯਿਖਨਿਯੰ ਤਸ੍ਯ ਭ੍ਰਾਤ੍ਰੁਂʼਸ਼੍ਚ ਜਨਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ਤਤੋ ਬਾਬਿਲਿ ਪ੍ਰਵਸਨਕਾਲੇ ਯਿਖਨਿਯਃ ਸ਼ਲ੍ਤੀਯੇਲੰ ਜਨਯਾਮਾਸ, ਤਸ੍ਯ ਸੁਤਃ ਸਿਰੁੱਬਾਵਿਲ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ਤਸ੍ਯ ਸੁਤੋ (ਅ)ਬੋਹੁਦ੍ ਤਸ੍ਯ ਸੁਤ ਇਲੀਯਾਕੀਮ੍ ਤਸ੍ਯ ਸੁਤੋ(ਅ)ਸੋਰ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ਅਸੋਰਃ ਸੁਤਃ ਸਾਦੋਕ੍ ਤਸ੍ਯ ਸੁਤ ਆਖੀਮ੍ ਤਸ੍ਯ ਸੁਤ ਇਲੀਹੂਦ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ਤਸ੍ਯ ਸੁਤ ਇਲਿਯਾਸਰ੍ ਤਸ੍ਯ ਸੁਤੋ ਮੱਤਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ਤਸ੍ਯ ਸੁਤੋ ਯਾਕੂਬ੍ ਤਸ੍ਯ ਸੁਤੋ ਯੂਸ਼਼ਫ੍ ਤਸ੍ਯ ਜਾਯਾ ਮਰਿਯਮ੍; ਤਸ੍ਯ ਗਰ੍ਭੇ ਯੀਸ਼ੁਰਜਨਿ, ਤਮੇਵ ਖ੍ਰੀਸ਼਼੍ਟਮ੍ (ਅਰ੍ਥਾਦ੍ ਅਭਿਸ਼਼ਿਕ੍ਤੰ) ਵਦਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ਇੱਥਮ੍ ਇਬ੍ਰਾਹੀਮੋ ਦਾਯੂਦੰ ਯਾਵਤ੍ ਸਾਕਲ੍ਯੇਨ ਚਤੁਰ੍ਦਸ਼ਪੁਰੁਸ਼਼ਾਃ; ਆ ਦਾਯੂਦਃ ਕਾਲਾਦ੍ ਬਾਬਿਲਿ ਪ੍ਰਵਸਨਕਾਲੰ ਯਾਵਤ੍ ਚਤੁਰ੍ਦਸ਼ਪੁਰੁਸ਼਼ਾ ਭਵਨ੍ਤਿ| ਬਾਬਿਲਿ ਪ੍ਰਵਾਸਨਕਾਲਾਤ੍ ਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਕਾਲੰ ਯਾਵਤ੍ ਚਤੁਰ੍ਦਸ਼ਪੁਰੁਸ਼਼ਾ ਭਵਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਜਨ੍ਮ ਕਥ੍ਥਤੇ| ਮਰਿਯਮ੍ ਨਾਮਿਕਾ ਕਨ੍ਯਾ ਯੂਸ਼਼ਫੇ ਵਾਗ੍ਦੱਤਾਸੀਤ੍, ਤਦਾ ਤਯੋਃ ਸਙ੍ਗਮਾਤ੍ ਪ੍ਰਾਕ੍ ਸਾ ਕਨ੍ਯਾ  ਪਵਿਤ੍ਰੇਣਾਤ੍ਮਨਾ ਗਰ੍ਭਵਤੀ ਬਭੂਵ| ");
INSERT INTO sanpun_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ਤਤ੍ਰ ਤਸ੍ਯਾਃ ਪਤਿ ਰ੍ਯੂਸ਼਼ਫ੍ ਸੌਜਨ੍ਯਾਤ੍ ਤਸ੍ਯਾਃ ਕਲਙ੍ਗੰ ਪ੍ਰਕਾਸ਼ਯਿਤੁਮ੍ ਅਨਿੱਛਨ੍ ਗੋਪਨੇਨੇ ਤਾਂ ਪਾਰਿਤ੍ਯਕ੍ਤੁੰ ਮਨਸ਼੍ਚਕ੍ਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ਸ ਤਥੈਵ ਭਾਵਯਤਿ, ਤਦਾਨੀਂ ਪਰਮੇਸ਼੍ਵਰਸ੍ਯ ਦੂਤਃ ਸ੍ਵਪ੍ਨੇ ਤੰ ਦਰ੍ਸ਼ਨੰ ਦੱਤ੍ਵਾ ਵ੍ਯਾਜਹਾਰ, ਹੇ ਦਾਯੂਦਃ ਸਨ੍ਤਾਨ ਯੂਸ਼਼ਫ੍ ਤ੍ਵੰ ਨਿਜਾਂ ਜਾਯਾਂ ਮਰਿਯਮਮ੍ ਆਦਾਤੁੰ ਮਾ ਭੈਸ਼਼ੀਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","ਯਤਸ੍ਤਸ੍ਯਾ ਗਰ੍ਭਃ ਪਵਿਤ੍ਰਾਦਾਤ੍ਮਨੋ(ਅ)ਭਵਤ੍, ਸਾ ਚ ਪੁਤ੍ਰੰ ਪ੍ਰਸਵਿਸ਼਼੍ਯਤੇ, ਤਦਾ ਤ੍ਵੰ ਤਸ੍ਯ ਨਾਮ ਯੀਸ਼ੁਮ੍ (ਅਰ੍ਥਾਤ੍ ਤ੍ਰਾਤਾਰੰ) ਕਰੀਸ਼਼੍ਯਸੇ, ਯਸ੍ਮਾਤ੍ ਸ ਨਿਜਮਨੁਜਾਨ੍ ਤੇਸ਼਼ਾਂ ਕਲੁਸ਼਼ੇਭ੍ਯ ਉੱਧਰਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ਇੱਥੰ ਸਤਿ, ਪਸ਼੍ਯ ਗਰ੍ਭਵਤੀ ਕਨ੍ਯਾ ਤਨਯੰ ਪ੍ਰਸਵਿਸ਼਼੍ਯਤੇ| ਇੰਮਾਨੂਯੇਲ੍ ਤਦੀਯਞ੍ਚ ਨਾਮਧੇਯੰ ਭਵਿਸ਼਼੍ਯਤਿ|| ਇੰਮਾਨੂਯੇਲ੍ ਅਸ੍ਮਾਕੰ ਸਙ੍ਗੀਸ਼੍ਵਰਇਤ੍ਯਰ੍ਥਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","ਇਤਿ ਯਦ੍ ਵਚਨੰ ਪੁਰ੍ੱਵੰ ਭਵਿਸ਼਼੍ਯਦ੍ਵਕ੍ਤ੍ਰਾ ਈਸ਼੍ਵਰਃ ਕਥਾਯਾਮਾਸ, ਤਤ੍ ਤਦਾਨੀਂ ਸਿੱਧਮਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ਅਨਨ੍ਤਰੰ ਯੂਸ਼਼ਫ੍ ਨਿਦ੍ਰਾਤੋ ਜਾਗਰਿਤ ਉੱਥਾਯ ਪਰਮੇਸ਼੍ਵਰੀਯਦੂਤਸ੍ਯ ਨਿਦੇਸ਼ਾਨੁਸਾਰੇਣ ਨਿਜਾਂ ਜਾਯਾਂ ਜਗ੍ਰਾਹ, ");
INSERT INTO sanpun_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ਕਿਨ੍ਤੁ ਯਾਵਤ੍ ਸਾ ਨਿਜੰ ਪ੍ਰਥਮਸੁਤੰ ਅ ਸੁਸ਼਼ੁਵੇ, ਤਾਵਤ੍ ਤਾਂ ਨੋਪਾਗੱਛਤ੍, ਤਤਃ ਸੁਤਸ੍ਯ ਨਾਮ ਯੀਸ਼ੁੰ ਚਕ੍ਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","ਅਨਨ੍ਤਰੰ ਹੇਰੋਦ੍ ਸੰਜ੍ਞਕੇ ਰਾਜ੍ਞਿ ਰਾਜ੍ਯੰ ਸ਼ਾਸਤਿ ਯਿਹੂਦੀਯਦੇਸ਼ਸ੍ਯ ਬੈਤ੍ਲੇਹਮਿ ਨਗਰੇ ਯੀਸ਼ੌ ਜਾਤਵਤਿ ਚ, ਕਤਿਪਯਾ ਜ੍ਯੋਤਿਰ੍ੱਵੁਦਃ ਪੂਰ੍ੱਵਸ੍ਯਾ ਦਿਸ਼ੋ ਯਿਰੂਸ਼ਾਲਮ੍ਨਗਰੰ ਸਮੇਤ੍ਯ ਕਥਯਮਾਸੁਃ, ");
INSERT INTO sanpun_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ਯੋ ਯਿਹੂਦੀਯਾਨਾਂ ਰਾਜਾ ਜਾਤਵਾਨ੍, ਸ ਕੁਤ੍ਰਾਸ੍ਤੇ? ਵਯੰ ਪੂਰ੍ੱਵਸ੍ਯਾਂ ਦਿਸ਼ਿ ਤਿਸ਼਼੍ਠਨ੍ਤਸ੍ਤਦੀਯਾਂ ਤਾਰਕਾਮ੍ ਅਪਸ਼੍ਯਾਮ ਤਸ੍ਮਾਤ੍ ਤੰ ਪ੍ਰਣਨ੍ਤੁਮ੍ ਅाਗਮਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ਤਦਾ ਹੇਰੋਦ੍ ਰਾਜਾ ਕਥਾਮੇਤਾਂ ਨਿਸ਼ਮ੍ਯ ਯਿਰੂਸ਼ਾਲਮ੍ਨਗਰਸ੍ਥਿਤੈਃ ਸਰ੍ੱਵਮਾਨਵੈਃ ਸਾਰ੍ੱਧਮ੍ ਉਦ੍ਵਿਜ੍ਯ ");
INSERT INTO sanpun_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ਸਰ੍ੱਵਾਨ੍ ਪ੍ਰਧਾਨਯਾਜਕਾਨ੍ ਅਧ੍ਯਾਪਕਾਂਸ਼੍ਚ ਸਮਾਹੂਯਾਨੀਯ ਪਪ੍ਰੱਛ, ਖ੍ਰੀਸ਼਼੍ਟਃ ਕੁਤ੍ਰ ਜਨਿਸ਼਼੍ਯਤੇ? ");
INSERT INTO sanpun_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ਤਦਾ ਤੇ ਕਥਯਾਮਾਸੁਃ, ਯਿਹੂਦੀਯਦੇਸ਼ਸ੍ਯ ਬੈਤ੍ਲੇਹਮਿ ਨਗਰੇ, ਯਤੋ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਾ ਇੱਥੰ ਲਿਖਿਤਮਾਸ੍ਤੇ, ");
INSERT INTO sanpun_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","ਸਰ੍ੱਵਾਭ੍ਯੋ ਰਾਜਧਾਨੀਭ੍ਯੋ ਯਿਹੂਦੀਯਸ੍ਯ ਨੀਵ੍ਰੁʼਤਃ| ਹੇ ਯੀਹੂਦੀਯਦੇਸ਼ਸ੍ਯੇ ਬੈਤ੍ਲੇਹਮ੍ ਤ੍ਵੰ ਨ ਚਾਵਰਾ| ਇਸ੍ਰਾਯੇਲੀਯਲੋਕਾਨ੍ ਮੇ ਯਤੋ ਯਃ ਪਾਲਯਿਸ਼਼੍ਯਤਿ| ਤਾਦ੍ਰੁʼਗੇਕੋ ਮਹਾਰਾਜਸ੍ਤ੍ਵਨ੍ਮਧ੍ਯ ਉਦ੍ਭਵਿਸ਼਼੍ਯਤੀ|| ");
INSERT INTO sanpun_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","ਤਦਾਨੀਂ ਹੇਰੋਦ੍ ਰਾਜਾ ਤਾਨ੍ ਜ੍ਯੋਤਿਰ੍ੱਵਿਦੋ ਗੋਪਨਮ੍ ਆਹੂਯ ਸਾ ਤਾਰਕਾ ਕਦਾ ਦ੍ਰੁʼਸ਼਼੍ਟਾਭਵਤ੍ , ਤਦ੍ ਵਿਨਿਸ਼੍ਚਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ਅਪਰੰ ਤਾਨ੍ ਬੈਤ੍ਲੇਹਮੰ ਪ੍ਰਹੀਤ੍ਯ ਗਦਿਤਵਾਨ੍, ਯੂਯੰ ਯਾਤ, ਯਤ੍ਨਾਤ੍ ਤੰ ਸ਼ਿਸ਼ੁਮ੍ ਅਨ੍ਵਿਸ਼਼੍ਯ ਤਦੁੱਦੇਸ਼ੇ ਪ੍ਰਾਪ੍ਤੇ ਮਹ੍ਯੰ ਵਾਰ੍ੱਤਾਂ ਦਾਸ੍ਯਥ, ਤਤੋ ਮਯਾਪਿ ਗਤ੍ਵਾ ਸ ਪ੍ਰਣੰਸ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","ਤਦਾਨੀਂ ਰਾਜ੍ਞ ਏਤਾਦ੍ਰੁʼਸ਼ੀਮ੍ ਆਜ੍ਞਾਂ ਪ੍ਰਾਪ੍ਯ ਤੇ ਪ੍ਰਤਸ੍ਥਿਰੇ, ਤਤਃ ਪੂਰ੍ੱਵਰ੍ਸ੍ਯਾਂ ਦਿਸ਼ਿ ਸ੍ਥਿਤੈਸ੍ਤੈ ਰ੍ਯਾ ਤਾਰਕਾ ਦ੍ਰੁʼਸ਼਼੍ਟਾ ਸਾ ਤਾਰਕਾ ਤੇਸ਼਼ਾਮਗ੍ਰੇ ਗਤ੍ਵਾ ਯਤ੍ਰ ਸ੍ਥਾਨੇ ਸ਼ਿਸ਼ੂਰਾਸ੍ਤੇ, ਤਸ੍ਯ ਸ੍ਥਾਨਸ੍ਯੋਪਰਿ ਸ੍ਥਗਿਤਾ ਤਸ੍ਯੌ| ");
INSERT INTO sanpun_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ਤਦ੍ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਤੇ ਮਹਾਨਨ੍ਦਿਤਾ ਬਭੂਵੁਃ, ");
INSERT INTO sanpun_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ਤਤੋ ਗੇਹਮਧ੍ਯ ਪ੍ਰਵਿਸ਼੍ਯ ਤਸ੍ਯ ਮਾਤ੍ਰਾ ਮਰਿਯਮਾ ਸਾੱਧੰ ਤੰ ਸ਼ਿਸ਼ੁੰ ਨਿਰੀਕ੍ਸ਼਼ਯ ਦਣ੍ਡਵਦ੍ ਭੂਤ੍ਵਾ ਪ੍ਰਣੇਮੁਃ, ਅਪਰੰ ਸ੍ਵੇਸ਼਼ਾਂ ਘਨਸਮ੍ਪੱਤਿੰ ਮੋਚਯਿਤ੍ਵਾ ਸੁਵਰ੍ਣੰ ਕੁਨ੍ਦੁਰੁੰ ਗਨ੍ਧਰਮਞ੍ਚ ਤਸ੍ਮੈ ਦਰ੍ਸ਼ਨੀਯੰ ਦੱਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ਪਸ਼੍ਚਾਦ੍ ਹੇਰੋਦ੍ ਰਾਜਸ੍ਯ ਸਮੀਪੰ ਪੁਨਰਪਿ ਗਨ੍ਤੁੰ ਸ੍ਵਪ੍ਨ ਈਸ਼੍ਵਰੇਣ ਨਿਸ਼਼ਿੱਧਾਃ ਸਨ੍ਤੋ (ਅ)ਨ੍ਯੇਨ ਪਥਾ ਤੇ ਨਿਜਦੇਸ਼ੰ ਪ੍ਰਤਿ ਪ੍ਰਤਸ੍ਥਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","ਅਨਨ੍ਤਰੰ ਤੇਸ਼਼ੁ ਗਤਵਤ੍ਮੁ ਪਰਮੇਸ਼੍ਵਰਸ੍ਯ ਦੂਤੋ ਯੂਸ਼਼ਫੇ ਸ੍ਵਪ੍ਨੇ ਦਰ੍ਸ਼ਨੰ ਦਤ੍ਵਾ ਜਗਾਦ, ਤ੍ਵਮ੍ ਉੱਥਾਯ ਸ਼ਿਸ਼ੁੰ ਤਨ੍ਮਾਤਰਞ੍ਚ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਮਿਸਰ੍ਦੇਸ਼ੰ ਪਲਾਯਸ੍ਵ, ਅਪਰੰ ਯਾਵਦਹੰ ਤੁਭ੍ਯੰ ਵਾਰ੍ੱਤਾਂ ਨ ਕਥਯਿਸ਼਼੍ਯਾਮਿ, ਤਾਵਤ੍ ਤਤ੍ਰੈਵ ਨਿਵਸ, ਯਤੋ ਰਾਜਾ ਹੇਰੋਦ੍ ਸ਼ਿਸ਼ੁੰ ਨਾਸ਼ਯਿਤੁੰ ਮ੍ਰੁʼਗਯਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ਤਦਾਨੀਂ ਯੂਸ਼਼ਫ੍ ਉੱਥਾਯ ਰਜਨ੍ਯਾਂ ਸ਼ਿਸ਼ੁੰ ਤਨ੍ਮਾਤਰਞ੍ਚ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਮਿਸਰ੍ਦੇਸ਼ੰ ਪ੍ਰਤਿ ਪ੍ਰਤਸ੍ਥੇ, ");
INSERT INTO sanpun_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ਗਤ੍ਵਾ ਚ ਹੇਰੋਦੋ ਨ੍ਰੁʼਪਤੇ ਰ੍ਮਰਣਪਰ੍ੱਯਨ੍ਤੰ ਤਤ੍ਰ ਦੇਸ਼ੇ ਨ੍ਯੁਵਾਸ, ਤੇਨ ਮਿਸਰ੍ਦੇਸ਼ਾਦਹੰ ਪੁਤ੍ਰੰ ਸ੍ਵਕੀਯੰ ਸਮੁਪਾਹੂਯਮ੍| ਯਦੇਤਦ੍ਵਚਨਮ੍ ਈਸ਼੍ਵਰੇਣ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਾ ਕਥਿਤੰ ਤਤ੍ ਸਫਲਮਭੂਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","ਅਨਨ੍ਤਰੰ ਹੇਰੋਦ੍ ਜ੍ਯੋਤਿਰ੍ਵਿਦ੍ਭਿਰਾਤ੍ਮਾਨੰ ਪ੍ਰਵਞ੍ਚਿਤੰ ਵਿਜ੍ਞਾਯ ਭ੍ਰੁʼਸ਼ੰ ਚੁਕੋਪ; ਅਪਰੰ ਜ੍ਯੋਤਿਰ੍ੱਵਿਦ੍ਭ੍ਯਸ੍ਤੇਨ ਵਿਨਿਸ਼੍ਚਿਤੰ ਯਦ੍ ਦਿਨੰ ਤੱਦਿਨਾਦ੍ ਗਣਯਿਤ੍ਵਾ ਦ੍ਵਿਤੀਯਵਤ੍ਸਰੰ ਪ੍ਰਵਿਸ਼਼੍ਟਾ ਯਾਵਨ੍ਤੋ ਬਾਲਕਾ ਅਸ੍ਮਿਨ੍ ਬੈਤ੍ਲੇਹਮ੍ਨਗਰੇ ਤਤ੍ਸੀਮਮਧ੍ਯੇ ਚਾਸਨ੍, ਲੋਕਾਨ੍ ਪ੍ਰਹਿਤ੍ਯ ਤਾਨ੍ ਸਰ੍ੱਵਾਨ੍ ਘਾਤਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ਅਤਃ ਅਨੇਕਸ੍ਯ ਵਿਲਾਪਸ੍ਯ ਨਿਨਾਦ: ਕ੍ਰਨ੍ਦਨਸ੍ਯ ਚ| ਸ਼ੋਕੇਨ ਕ੍ਰੁʼਤਸ਼ਬ੍ਦਸ਼੍ਚ ਰਾਮਾਯਾਂ ਸੰਨਿਸ਼ਮ੍ਯਤੇ| ਸ੍ਵਬਾਲਗਣਹੇਤੋਰ੍ਵੈ ਰਾਹੇਲ੍ ਨਾਰੀ ਤੁ ਰੋਦਿਨੀ| ਨ ਮਨ੍ਯਤੇ ਪ੍ਰਬੋਧਨ੍ਤੁ ਯਤਸ੍ਤੇ ਨੈਵ ਮਨ੍ਤਿ ਹਿ|| ");
INSERT INTO sanpun_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","ਯਦੇਤਦ੍ ਵਚਨੰ ਯਿਰੀਮਿਯਨਾਮਕਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਾ ਕਥਿਤੰ ਤਤ੍ ਤਦਾਨੀਂ ਸਫਲਮ੍ ਅਭੂਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ਤਦਨਨ੍ਤਰੰ ਹੇਰੇਦਿ ਰਾਜਨਿ ਮ੍ਰੁʼਤੇ ਪਰਮੇਸ਼੍ਵਰਸ੍ਯ ਦੂਤੋ ਮਿਸਰ੍ਦੇਸ਼ੇ ਸ੍ਵਪ੍ਨੇ ਦਰ੍ਸ਼ਨੰ ਦੱਤ੍ਵਾ ਯੂਸ਼਼ਫੇ ਕਥਿਤਵਾਨ੍ ");
INSERT INTO sanpun_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ਤ੍ਵਮ੍ ਉੱਥਾਯ ਸ਼ਿਸ਼ੁੰ ਤਨ੍ਮਾਤਰਞ੍ਚ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਪੁਨਰਪੀਸ੍ਰਾਯੇਲੋ ਦੇਸ਼ੰ ਯਾਹੀ, ਯੇ ਜਨਾਃ ਸ਼ਿਸ਼ੁੰ ਨਾਸ਼ਯਿਤੁਮ੍ ਅਮ੍ਰੁʼਗਯਨ੍ਤ, ਤੇ ਮ੍ਰੁʼਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ਤਦਾਨੀਂ ਸ ਉੱਥਾਯ ਸ਼ਿਸ਼ੁੰ ਤਨ੍ਮਾਤਰਞ੍ਚ ਗ੍ਰੁʼਹ੍ਲਨ੍ ਇਸ੍ਰਾਯੇਲ੍ਦੇਸ਼ਮ੍ ਆਜਗਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","ਕਿਨ੍ਤੁ ਯਿਹੂਦੀਯਦੇਸ਼ੇ ਅਰ੍ਖਿਲਾਯਨਾਮ ਰਾਜਕੁਮਾਰੋ ਨਿਜਪਿਤੁ ਰ੍ਹੇਰੋਦਃ ਪਦੰ ਪ੍ਰਾਪ੍ਯ ਰਾਜਤ੍ਵੰ ਕਰੋਤੀਤਿ ਨਿਸ਼ਮ੍ਯ ਤਤ੍ ਸ੍ਥਾਨੰ ਯਾਤੁੰ ਸ਼ਙ੍ਕਿਤਵਾਨ੍, ਪਸ਼੍ਚਾਤ੍ ਸ੍ਵਪ੍ਨ ਈਸ਼੍ਵਰਾਤ੍ ਪ੍ਰਬੋਧੰ ਪ੍ਰਾਪ੍ਯ ਗਾਲੀਲ੍ਦੇਸ਼ਸ੍ਯ ਪ੍ਰਦੇਸ਼ੈਕੰ ਪ੍ਰਸ੍ਥਾਯ ਨਾਸਰੰਨਾਮ ਨਗਰੰ ਗਤ੍ਵਾ ਤਤ੍ਰ ਨ੍ਯੁਸ਼਼ਿਤਵਾਨ੍, ");
INSERT INTO sanpun_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ਤੇਨ ਤੰ ਨਾਸਰਤੀਯੰ ਕਥਯਿਸ਼਼੍ਯਨ੍ਤਿ, ਯਦੇਤਦ੍ਵਾਕ੍ਯੰ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਭਿਰੁਕ੍ੱਤੰ ਤਤ੍ ਸਫਲਮਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","ਤਦਾਨੋਂ ਯੋਹ੍ੰਨਾਮਾ ਮੱਜਯਿਤਾ ਯਿਹੂਦੀਯਦੇਸ਼ਸ੍ਯ ਪ੍ਰਾਨ੍ਤਰਮ੍ ਉਪਸ੍ਥਾਯ ਪ੍ਰਚਾਰਯਨ੍ ਕਥਯਾਮਾਸ, ");
INSERT INTO sanpun_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ਮਨਾਂਸਿ ਪਰਾਵਰ੍ੱਤਯਤ, ਸ੍ਵਰ੍ਗੀਯਰਾਜਤ੍ਵੰ ਸਮੀਪਮਾਗਤਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ਪਰਮੇਸ਼ਸ੍ਯ ਪਨ੍ਥਾਨੰ ਪਰਿਸ਼਼੍ਕੁਰੁਤ ਸਰ੍ੱਵਤਃ| ਤਸ੍ਯ ਰਾਜਪਥਾਂਸ਼੍ਚੈਵ ਸਮੀਕੁਰੁਤ ਸਰ੍ੱਵਥਾ| ਇਤ੍ਯੇਤਤ੍ ਪ੍ਰਾਨ੍ਤਰੇ ਵਾਕ੍ਯੰ ਵਦਤਃ ਕਸ੍ਯਚਿਦ੍ ਰਵਃ|| ");
INSERT INTO sanpun_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ਏਤਦ੍ਵਚਨੰ ਯਿਸ਼ਯਿਯਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਾ ਯੋਹਨਮੁੱਦਿਸ਼੍ਯ ਭਾਸ਼਼ਿਤਮ੍| ਯੋਹਨੋ ਵਸਨੰ ਮਹਾਙ੍ਗਰੋਮਜੰ ਤਸ੍ਯ ਕਟੌ ਚਰ੍ੰਮਕਟਿਬਨ੍ਧਨੰ; ਸ ਚ ਸ਼ੂਕਕੀਟਾਨ੍ ਮਧੁ ਚ ਭੁਕ੍ਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","ਤਦਾਨੀਂ ਯਿਰੂਸ਼ਾਲਮ੍ਨਗਰਨਿਵਾਸਿਨਃ ਸਰ੍ੱਵੇ ਯਿਹੂਦਿਦੇਸ਼ੀਯਾ ਯਰ੍ੱਦਨ੍ਤਟਿਨ੍ਯਾ ਉਭਯਤਟਸ੍ਥਾਸ਼੍ਚ ਮਾਨਵਾ ਬਹਿਰਾਗਤ੍ਯ ਤਸ੍ਯ ਸਮੀਪੇ ");
INSERT INTO sanpun_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ਸ੍ਵੀਯੰ ਸ੍ਵੀਯੰ ਦੁਰਿਤਮ੍ ਅਙ੍ਗੀਕ੍ਰੁʼਤ੍ਯ ਤਸ੍ਯਾਂ ਯਰ੍ੱਦਨਿ ਤੇਨ ਮੱਜਿਤਾ ਬਭੂਵੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ਅਪਰੰ ਬਹੂਨ੍ ਫਿਰੂਸ਼ਿਨਃ ਸਿਦੂਕਿਨਸ਼੍ਚ ਮਨੁਜਾਨ੍ ਮੰਕ੍ਤੁੰ ਸ੍ਵਸਮੀਪਮ੍ ਆਗੱਛ੍ਤੋ ਵਿਲੋਕ੍ਯ ਸ ਤਾਨ੍ ਅਭਿਦਧੌ, ਰੇ ਰੇ ਭੁਜਗਵੰਸ਼ਾ ਆਗਾਮੀਨਃ ਕੋਪਾਤ੍ ਪਲਾਯਿਤੁੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਕਸ਼੍ਚੇਤਿਤਵਾਨ੍? ");
INSERT INTO sanpun_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","ਮਨਃਪਰਾਵਰ੍ੱਤਨਸ੍ਯ ਸਮੁਚਿਤੰ ਫਲੰ ਫਲਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ਕਿਨ੍ਤ੍ਵਸ੍ਮਾਕੰ ਤਾਤ ਇਬ੍ਰਾਹੀਮ੍ ਅਸ੍ਤੀਤਿ ਸ੍ਵੇਸ਼਼ੁ ਮਨਃਸੁ ਚੀਨ੍ਤਯਨ੍ਤੋ ਮਾ ਵ੍ਯਾਹਰਤ| ਯਤੋ ਯੁਸ਼਼੍ਮਾਨ੍ ਅਹੰ ਵਦਾਮਿ, ਈਸ਼੍ਵਰ ਏਤੇਭ੍ਯਃ ਪਾਸ਼਼ਾਣੇਭ੍ਯ ਇਬ੍ਰਾਹੀਮਃ ਸਨ੍ਤਾਨਾਨ੍ ਉਤ੍ਪਾਦਯਿਤੁੰ ਸ਼ਕ੍ਨੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ਅਪਰੰ ਪਾਦਪਾਨਾਂ ਮੂਲੇ ਕੁਠਾਰ ਇਦਾਨੀਮਪਿ ਲਗਨ੍ ਆਸ੍ਤੇ, ਤਸ੍ਮਾਦ੍ ਯਸ੍ਮਿਨ੍ ਪਾਦਪੇ ਉੱਤਮੰ ਫਲੰ ਨ ਭਵਤਿ, ਸ ਕ੍ਰੁʼੱਤੋ ਮਧ੍ਯੇ(ਅ)ਗ੍ਨਿੰ ਨਿਕ੍ਸ਼਼ੇਪ੍ਸ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","ਅਪਰਮ੍ ਅਹੰ ਮਨਃਪਰਾਵਰ੍ੱਤਨਸੂਚਕੇਨ ਮੱਜਨੇਨ ਯੁਸ਼਼੍ਮਾਨ੍ ਮੱਜਯਾਮੀਤਿ ਸਤ੍ਯੰ, ਕਿਨ੍ਤੁ ਮਮ ਪਸ਼੍ਚਾਦ੍ ਯ ਆਗੱਛਤਿ, ਸ ਮੱਤੋਪਿ ਮਹਾਨ੍, ਅਹੰ ਤਦੀਯੋਪਾਨਹੌ ਵੋਢੁਮਪਿ ਨਹਿ ਯੋਗ੍ਯੋਸ੍ਮਿ, ਸ ਯੁਸ਼਼੍ਮਾਨ੍ ਵਹ੍ਨਿਰੂਪੇ ਪਵਿਤ੍ਰ ਆਤ੍ਮਨਿ ਸੰਮੱਜਯਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ਤਸ੍ਯ ਕਾਰੇ ਸੂਰ੍ਪ ਆਸ੍ਤੇ, ਸ ਸ੍ਵੀਯਸ਼ਸ੍ਯਾਨਿ ਸਮ੍ਯਕ੍ ਪ੍ਰਸ੍ਫੋਟ੍ਯ ਨਿਜਾਨ੍ ਸਕਲਗੋਧੂਮਾਨ੍ ਸੰਗ੍ਰੁʼਹ੍ਯ ਭਾਣ੍ਡਾਗਾਰੇ ਸ੍ਥਾਪਯਿਸ਼਼੍ਯਤਿ, ਕਿੰਨ੍ਤੁ ਸਰ੍ੱਵਾਣਿ ਵੁਸ਼਼ਾਣ੍ਯਨਿਰ੍ੱਵਾਣਵਹ੍ਨਿਨਾ ਦਾਹਯਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","ਅਨਨ੍ਤਰੰ ਯੀਸ਼ੁ ਰ੍ਯੋਹਨਾ ਮੱਜਿਤੋ ਭਵਿਤੁੰ ਗਾਲੀਲ੍ਪ੍ਰਦੇਸ਼ਾਦ੍ ਯਰ੍ੱਦਨਿ ਤਸ੍ਯ ਸਮੀਪਮ੍ ਆਜਗਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","ਕਿਨ੍ਤੁ ਯੋਹਨ੍ ਤੰ ਨਿਸ਼਼ਿਧ੍ਯ ਬਭਾਸ਼਼ੇ, ਤ੍ਵੰ ਕਿੰ ਮਮ ਸਮੀਪਮ੍ ਆਗੱਛਸਿ? ਵਰੰ ਤ੍ਵਯਾ ਮੱਜਨੰ ਮਮ ਪ੍ਰਯੋਜਨਮ੍ ਆਸ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ਤਦਾਨੀਂ ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯਵੋਚਤ੍; ਈਦਾਨੀਮ੍ ਅਨੁਮਨ੍ਯਸ੍ਵ, ਯਤ ਇੱਥੰ ਸਰ੍ੱਵਧਰ੍ੰਮਸਾਧਨਮ੍ ਅਸ੍ਮਾਕੰ ਕਰ੍ੱਤਵ੍ਯੰ, ਤਤਃ ਸੋ(ਅ)ਨ੍ਵਮਨ੍ਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ਅਨਨ੍ਤਰੰ ਯੀਸ਼ੁਰੰਮਸਿ ਮੱਜਿਤੁਃ ਸਨ੍ ਤਤ੍ਕ੍ਸ਼਼ਣਾਤ੍ ਤੋਯਮਧ੍ਯਾਦ੍ ਉੱਥਾਯ ਜਗਾਮ, ਤਦਾ ਜੀਮੂਤਦ੍ਵਾਰੇ ਮੁਕ੍ਤੇ ਜਾਤੇ, ਸ ਈਸ਼੍ਵਰਸ੍ਯਾਤ੍ਮਾਨੰ ਕਪੋਤਵਦ੍ ਅਵਰੁਹ੍ਯ ਸ੍ਵੋਪਰ੍ੱਯਾਗੱਛਨ੍ਤੰ ਵੀਕ੍ਸ਼਼ਾਞ੍ਚਕ੍ਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ਅਪਰਮ੍ ਏਸ਼਼ ਮਮ ਪ੍ਰਿਯਃ ਪੁਤ੍ਰ ਏਤਸ੍ਮਿੰਨੇਵ ਮਮ ਮਹਾਸਨ੍ਤੋਸ਼਼ ਏਤਾਦ੍ਰੁʼਸ਼ੀ ਵ੍ਯੋਮਜਾ ਵਾਗ੍ ਬਭੂਵ| ");
INSERT INTO sanpun_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","ਤਤਃ ਪਰੰ ਯੀਸ਼ੁਃ ਪ੍ਰਤਾਰਕੇਣ ਪਰੀਕ੍ਸ਼਼ਿਤੋ ਭਵਿਤੁਮ੍ ਆਤ੍ਮਨਾ ਪ੍ਰਾਨ੍ਤਰਮ੍ ਆਕ੍ਰੁʼਸ਼਼੍ਟਃ ");
INSERT INTO sanpun_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ਸਨ੍ ਚਤ੍ਵਾਰਿੰਸ਼ਦਹੋਰਾਤ੍ਰਾਨ੍ ਅਨਾਹਾਰਸ੍ਤਿਸ਼਼੍ਠਨ੍ ਕ੍ਸ਼਼ੁਧਿਤੋ ਬਭੂਵ| ");
INSERT INTO sanpun_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ਤਦਾਨੀਂ ਪਰੀਕ੍ਸ਼਼ਿਤਾ ਤਤ੍ਸਮੀਪਮ੍ ਆਗਤ੍ਯ ਵ੍ਯਾਹ੍ਰੁʼਤਵਾਨ੍, ਯਦਿ ਤ੍ਵਮੀਸ਼੍ਵਰਾਤ੍ਮਜੋ ਭਵੇਸ੍ਤਰ੍ਹ੍ਯਾਜ੍ਞਯਾ ਪਾਸ਼਼ਾਣਾਨੇਤਾਨ੍ ਪੂਪਾਨ੍ ਵਿਧੇਹਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","ਤਤਃ ਸ ਪ੍ਰਤ੍ਯਬ੍ਰਵੀਤ੍, ਇੱਥੰ ਲਿਖਿਤਮਾਸ੍ਤੇ, \"ਮਨੁਜਃ ਕੇਵਲਪੂਪੇਨ ਨ ਜੀਵਿਸ਼਼੍ਯਤਿ, ਕਿਨ੍ਤ੍ਵੀਸ਼੍ਵਰਸ੍ਯ ਵਦਨਾਦ੍ ਯਾਨਿ ਯਾਨਿ ਵਚਾਂਸਿ ਨਿਃਸਰਨ੍ਤਿ ਤੈਰੇਵ ਜੀਵਿਸ਼਼੍ਯਤਿ| \" ");
INSERT INTO sanpun_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","ਤਦਾ ਪ੍ਰਤਾਰਕਸ੍ਤੰ ਪੁਣ੍ਯਨਗਰੰ ਨੀਤ੍ਵਾ ਮਨ੍ਦਿਰਸ੍ਯ ਚੂਡੋਪਰਿ ਨਿਧਾਯ ਗਦਿਤਵਾਨ੍, ");
INSERT INTO sanpun_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ਤ੍ਵੰ ਯਦਿਸ਼੍ਵਰਸ੍ਯ ਤਨਯੋ ਭਵੇਸ੍ਤਰ੍ਹੀਤੋ(ਅ)ਧਃ ਪਤ, ਯਤ ਇੱਥੰ ਲਿਖਿਤਮਾਸ੍ਤੇ, ਆਦੇਕ੍ਸ਼਼੍ਯਤਿ ਨਿਜਾਨ੍ ਦੂਤਾਨ੍ ਰਕ੍ਸ਼਼ਿਤੁੰ ਤ੍ਵਾਂ ਪਰਮੇਸ਼੍ਵਰਃ| ਯਥਾ ਸਰ੍ੱਵੇਸ਼਼ੁ ਮਾਰ੍ਗੇਸ਼਼ੁ ਤ੍ਵਦੀਯਚਰਣਦ੍ਵਯੇ| ਨ ਲਗੇਤ੍ ਪ੍ਰਸ੍ਤਰਾਘਾਤਸ੍ਤ੍ਵਾਂ ਘਰਿਸ਼਼੍ਯਨ੍ਤਿ ਤੇ ਕਰੈਃ|| ");
INSERT INTO sanpun_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ਤਦਾਨੀਂ ਯੀਸ਼ੁਸ੍ਤਸ੍ਮੈ ਕਥਿਤਵਾਨ੍ ਏਤਦਪਿ ਲਿਖਿਤਮਾਸ੍ਤੇ, \"ਤ੍ਵੰ ਨਿਜਪ੍ਰਭੁੰ ਪਰਮੇਸ਼੍ਵਰੰ ਮਾ ਪਰੀਕ੍ਸ਼਼ਸ੍ਵ| \" ");
INSERT INTO sanpun_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","ਅਨਨ੍ਤਰੰ ਪ੍ਰਤਾਰਕਃ ਪੁਨਰਪਿ ਤਮ੍ ਅਤ੍ਯੁਞ੍ਚਧਰਾਧਰੋਪਰਿ ਨੀਤ੍ਵਾ ਜਗਤਃ ਸਕਲਰਾਜ੍ਯਾਨਿ ਤਦੈਸ਼੍ਵਰ੍ੱਯਾਣਿ ਚ ਦਰ੍ਸ਼ਯਾਸ਼੍ਚਕਾਰ ਕਥਯਾਞ੍ਚਕਾਰ ਚ, ");
INSERT INTO sanpun_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ਯਦਿ ਤ੍ਵੰ ਦਣ੍ਡਵਦ੍ ਭਵਨ੍ ਮਾਂ ਪ੍ਰਣਮੇਸ੍ਤਰ੍ਹ੍ਯਹਮ੍ ਏਤਾਨਿ ਤੁਭ੍ਯੰ ਪ੍ਰਦਾਸ੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ਤਦਾਨੀਂ ਯੀਸ਼ੁਸ੍ਤਮਵੋਚਤ੍, ਦੂਰੀਭਵ ਪ੍ਰਤਾਰਕ, ਲਿਖਿਤਮਿਦਮ੍ ਆਸ੍ਤੇ, \"ਤ੍ਵਯਾ ਨਿਜਃ ਪ੍ਰਭੁਃ ਪਰਮੇਸ਼੍ਵਰਃ ਪ੍ਰਣਮ੍ਯਃ ਕੇਵਲਃ ਸ ਸੇਵ੍ਯਸ਼੍ਚ| \" ");
INSERT INTO sanpun_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ਤਤਃ ਪ੍ਰਤਾਰਕੇਣ ਸ ਪਰ੍ੱਯਤ੍ਯਾਜਿ, ਤਦਾ ਸ੍ਵਰ੍ਗੀਯਦੂਤੈਰਾਗਤ੍ਯ ਸ ਸਿਸ਼਼ੇਵੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","ਤਦਨਨ੍ਤਰੰ ਯੋਹਨ੍ ਕਾਰਾਯਾਂ ਬਬਨ੍ਧੇ, ਤਦ੍ਵਾਰ੍ੱਤਾਂ ਨਿਸ਼ਮ੍ਯ ਯੀਸ਼ੁਨਾ ਗਾਲੀਲ੍ ਪ੍ਰਾਸ੍ਥੀਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ਤਤਃ ਪਰੰ ਸ ਨਾਸਰੰਨਗਰੰ ਵਿਹਾਯ ਜਲਘੇਸ੍ਤਟੇ ਸਿਬੂਲੂੰਨਪ੍ਤਾਲੀ ਏਤਯੋਰੁਵਭਯੋਃ ਪ੍ਰਦੇਸ਼ਯੋਃ ਸੀਮ੍ਨੋਰ੍ਮਧ੍ਯਵਰ੍ੱਤੀ ਯ: ਕਫਰ੍ਨਾਹੂਮ੍ ਤੰਨਗਰਮ੍ ਇਤ੍ਵਾ ਨ੍ਯਵਸਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ਤਸ੍ਮਾਤ੍, ਅਨ੍ਯਾਦੇਸ਼ੀਯਗਾਲੀਲਿ ਯਰ੍ੱਦਨ੍ਪਾਰੇ(ਅ)ਬ੍ਧਿਰੋਧਸਿ| ਨਪ੍ਤਾਲਿਸਿਬੂਲੂਨ੍ਦੇਸ਼ੌ ਯਤ੍ਰ ਸ੍ਥਾਨੇ ਸ੍ਥਿਤੌ ਪੁਰਾ| ");
INSERT INTO sanpun_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","ਤਤ੍ਰਤ੍ਯਾ ਮਨੁਜਾ ਯੇ ਯੇ ਪਰ੍ੱਯਭ੍ਰਾਮ੍ਯਨ੍ ਤਮਿਸ੍ਰਕੇ| ਤੈਰ੍ਜਨੈਰ੍ਬ੍ਰੁʼਹਦਾਲੋਕਃ ਪਰਿਦਰ੍ਸ਼ਿਸ਼਼੍ਯਤੇ ਤਦਾ| ਅਵਸਨ੍ ਯੇ ਜਨਾ ਦੇਸ਼ੇ ਮ੍ਰੁʼਤ੍ਯੁੱਛਾਯਾਸ੍ਵਰੂਪਕੇ| ਤੇਸ਼਼ਾਮੁਪਰਿ ਲੋਕਾਨਾਮਾਲੋਕਃ ਸੰਪ੍ਰਕਾਸ਼ਿਤਃ|| ");
INSERT INTO sanpun_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ਯਦੇਤਦ੍ਵਚਨੰ ਯਿਸ਼ਯਿਯਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਾ ਪ੍ਰੋਕ੍ਤੰ, ਤਤ੍ ਤਦਾ ਸਫਲਮ੍ ਅਭੂਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","ਅਨਨ੍ਤਰੰ ਯੀਸ਼ੁਃ ਸੁਸੰਵਾਦੰ ਪ੍ਰਚਾਰਯਨ੍ ਏਤਾਂ ਕਥਾਂ ਕਥਯਿਤੁਮ੍ ਆਰੇਭੇ, ਮਨਾਂਸਿ ਪਰਾਵਰ੍ੱਤਯਤ, ਸ੍ਵਰ੍ਗੀਯਰਾਜਤ੍ਵੰ ਸਵਿਧਮਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ਤਤਃ ਪਰੰ ਯੀਸ਼ੁ ਰ੍ਗਾਲੀਲੋ ਜਲਧੇਸ੍ਤਟੇਨ ਗੱਛਨ੍ ਗੱਛਨ੍ ਆਨ੍ਦ੍ਰਿਯਸ੍ਤਸ੍ਯ ਭ੍ਰਾਤਾ ਸ਼ਿਮੋਨ੍ ਅਰ੍ਥਤੋ ਯੰ ਪਿਤਰੰ ਵਦਨ੍ਤਿ ਏਤਾਵੁਭੌ ਜਲਘੌ ਜਾਲੰ ਕ੍ਸ਼਼ਿਪਨ੍ਤੌ ਦਦਰ੍ਸ਼, ਯਤਸ੍ਤੌ ਮੀਨਧਾਰਿਣਾਵਾਸ੍ਤਾਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ਤਦਾ ਸ ਤਾਵਾਹੂਯ ਵ੍ਯਾਜਹਾਰ, ਯੁਵਾਂ ਮਮ ਪਸ਼੍ਚਾਦ੍ ਆਗੱਛਤੰ, ਯੁਵਾਮਹੰ ਮਨੁਜਧਾਰਿਣੌ ਕਰਿਸ਼਼੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","ਤੇਨੈਵ ਤੌ ਜਾਲੰ ਵਿਹਾਯ ਤਸ੍ਯ ਪਸ਼੍ਚਾਤ੍ ਆਗੱਛਤਾਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ਅਨਨ੍ਤਰੰ ਤਸ੍ਮਾਤ੍ ਸ੍ਥਾਨਾਤ੍ ਵ੍ਰਜਨ੍ ਵ੍ਰਜਨ੍ ਸਿਵਦਿਯਸ੍ਯ ਸੁਤੌ ਯਾਕੂਬ੍ ਯੋਹੰਨਾਮਾਨੌ ਦ੍ਵੌ ਸਹਜੌ ਤਾਤੇਨ ਸਾਰ੍ੱਧੰ ਨੌਕੋਪਰਿ ਜਾਲਸ੍ਯ ਜੀਰ੍ਣੋੱਧਾਰੰ ਕੁਰ੍ੱਵਨ੍ਤੌ ਵੀਕ੍ਸ਼਼੍ਯ ਤਾਵਾਹੂਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ਤਤ੍ਕ੍ਸ਼਼ਣਾਤ੍ ਤੌ ਨਾਵੰ ਸ੍ਵਤਾਤਞ੍ਚ ਵਿਹਾਯ ਤਸ੍ਯ ਪਸ਼੍ਚਾਦ੍ਗਾਮਿਨੌ ਬਭੂਵਤੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ਅਨਨ੍ਤਰੰ ਭਜਨਭਵਨੇ ਸਮੁਪਦਿਸ਼ਨ੍ ਰਾਜ੍ਯਸ੍ਯ ਸੁਸੰਵਾਦੰ ਪ੍ਰਚਾਰਯਨ੍ ਮਨੁਜਾਨਾਂ ਸਰ੍ੱਵਪ੍ਰਕਾਰਾਨ੍ ਰੋਗਾਨ੍ ਸਰ੍ੱਵਪ੍ਰਕਾਰਪੀਡਾਸ਼੍ਚ ਸ਼ਮਯਨ੍ ਯੀਸ਼ੁਃ ਕ੍ਰੁʼਤ੍ਸ੍ਨੰ ਗਾਲੀਲ੍ਦੇਸ਼ੰ ਭ੍ਰਮਿਤੁਮ੍ ਆਰਭਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ਤੇਨ ਕ੍ਰੁʼਤ੍ਸ੍ਨਸੁਰਿਯਾਦੇਸ਼ਸ੍ਯ ਮਧ੍ਯੰ ਤਸ੍ਯ ਯਸ਼ੋ ਵ੍ਯਾਪ੍ਨੋਤ੍, ਅਪਰੰ ਭੂਤਗ੍ਰਸ੍ਤਾ ਅਪਸ੍ਮਾਰਰ੍ਗੀਣਃ ਪਕ੍ਸ਼਼ਾਧਾਤਿਪ੍ਰਭ੍ਰੁʼਤਯਸ਼੍ਚ ਯਾਵਨ੍ਤੋ ਮਨੁਜਾ ਨਾਨਾਵਿਧਵ੍ਯਾਧਿਭਿਃ ਕ੍ਲਿਸ਼਼੍ਟਾ ਆਸਨ੍, ਤੇਸ਼਼ੁ ਸਰ੍ੱਵੇਸ਼਼ੁ ਤਸ੍ਯ ਸਮੀਪਮ੍ ਆਨੀਤੇਸ਼਼ੁ ਸ ਤਾਨ੍ ਸ੍ਵਸ੍ਥਾਨ੍ ਚਕਾਰ| ");
INSERT INTO sanpun_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ਏਤੇਨ ਗਾਲੀਲ੍-ਦਿਕਾਪਨਿ-ਯਿਰੂਸ਼ਾਲਮ੍-ਯਿਹੂਦੀਯਦੇਸ਼ੇਭ੍ਯੋ ਯਰ੍ੱਦਨਃ ਪਾਰਾਞ੍ਚ ਬਹਵੋ ਮਨੁਜਾਸ੍ਤਸ੍ਯ ਪਸ਼੍ਚਾਦ੍ ਆਗੱਛਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ਅਨਨ੍ਤਰੰ ਸ ਜਨਨਿਵਹੰ ਨਿਰੀਕ੍ਸ਼਼੍ਯ ਭੂਧਰੋਪਰਿ ਵ੍ਰਜਿਤ੍ਵਾ ਸਮੁਪਵਿਵੇਸ਼| ");
INSERT INTO sanpun_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ਤਦਾਨੀਂ ਸ਼ਿਸ਼਼੍ਯੇਸ਼਼ੁ ਤਸ੍ਯ ਸਮੀਪਮਾਗਤੇਸ਼਼ੁ ਤੇਨ ਤੇਭ੍ਯ ਏਸ਼਼ਾ ਕਥਾ ਕਥ੍ਯਾਞ੍ਚਕ੍ਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","ਅਭਿਮਾਨਹੀਨਾ ਜਨਾ ਧਨ੍ਯਾਃ, ਯਤਸ੍ਤੇ ਸ੍ਵਰ੍ਗੀਯਰਾਜ੍ਯਮ੍ ਅਧਿਕਰਿਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ਖਿਦ੍ਯਮਾਨਾ ਮਨੁਜਾ ਧਨ੍ਯਾਃ, ਯਸ੍ਮਾਤ੍ ਤੇ ਸਾਨ੍ਤ੍ਵਨਾਂ ਪ੍ਰਾਪ੍ਸਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","ਨਮ੍ਰਾ ਮਾਨਵਾਸ਼੍ਚ ਧਨ੍ਯਾਃ, ਯਸ੍ਮਾਤ੍ ਤੇ ਮੇਦਿਨੀਮ੍ ਅਧਿਕਰਿਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ਧਰ੍ੰਮਾਯ ਬੁਭੁਕ੍ਸ਼਼ਿਤਾਃ ਤ੍ਰੁʼਸ਼਼ਾਰ੍ੱਤਾਸ਼੍ਚ ਮਨੁਜਾ ਧਨ੍ਯਾਃ, ਯਸ੍ਮਾਤ੍ ਤੇ ਪਰਿਤਰ੍ਪ੍ਸ੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","ਕ੍ਰੁʼਪਾਲਵੋ ਮਾਨਵਾ ਧਨ੍ਯਾਃ, ਯਸ੍ਮਾਤ੍ ਤੇ ਕ੍ਰੁʼਪਾਂ ਪ੍ਰਾਪ੍ਸ੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ਨਿਰ੍ੰਮਲਹ੍ਰੁʼਦਯਾ ਮਨੁਜਾਸ਼੍ਚ ਧਨ੍ਯਾਃ, ਯਸ੍ਮਾਤ੍ ਤ ਈਸ਼੍ਚਰੰ ਦ੍ਰਕ੍ਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","ਮੇਲਯਿਤਾਰੋ ਮਾਨਵਾ ਧਨ੍ਯਾਃ, ਯਸ੍ਮਾਤ੍ ਤ ਈਸ਼੍ਚਰਸ੍ਯ ਸਨ੍ਤਾਨਤ੍ਵੇਨ ਵਿਖ੍ਯਾਸ੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ਧਰ੍ੰਮਕਾਰਣਾਤ੍ ਤਾਡਿਤਾ ਮਨੁਜਾ ਧਨ੍ਯਾ, ਯਸ੍ਮਾਤ੍ ਸ੍ਵਰ੍ਗੀਯਰਾਜ੍ਯੇ ਤੇਸ਼਼ਾਮਧਿਕਰੋ ਵਿਦ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","ਯਦਾ ਮਨੁਜਾ ਮਮ ਨਾਮਕ੍ਰੁʼਤੇ ਯੁਸ਼਼੍ਮਾਨ੍ ਨਿਨ੍ਦਨ੍ਤਿ ਤਾਡਯਨ੍ਤਿ ਮ੍ਰੁʼਸ਼਼ਾ ਨਾਨਾਦੁਰ੍ੱਵਾਕ੍ਯਾਨਿ ਵਦਨ੍ਤਿ ਚ, ਤਦਾ ਯੁਯੰ ਧਨ੍ਯਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ਤਦਾ ਆਨਨ੍ਦਤ, ਤਥਾ ਭ੍ਰੁʼਸ਼ੰ ਹ੍ਲਾਦਧ੍ਵਞ੍ਚ, ਯਤਃ ਸ੍ਵਰ੍ਗੇ ਭੂਯਾਂਸਿ ਫਲਾਨਿ ਲਪ੍ਸ੍ਯਧ੍ਵੇ; ਤੇ ਯੁਸ਼਼੍ਮਾਕੰ ਪੁਰਾਤਨਾਨ੍ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨੋ(ਅ)ਪਿ ਤਾਦ੍ਰੁʼਗ੍ ਅਤਾਡਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","ਯੁਯੰ ਮੇਦਿਨ੍ਯਾਂ ਲਵਣਰੂਪਾਃ, ਕਿਨ੍ਤੁ ਯਦਿ ਲਵਣਸ੍ਯ ਲਵਣਤ੍ਵਮ੍ ਅਪਯਾਤਿ, ਤਰ੍ਹਿ ਤਤ੍ ਕੇਨ ਪ੍ਰਕਾਰੇਣ ਸ੍ਵਾਦੁਯੁਕ੍ਤੰ ਭਵਿਸ਼਼੍ਯਤਿ? ਤਤ੍ ਕਸ੍ਯਾਪਿ ਕਾਰ੍ੱਯਸ੍ਯਾਯੋਗ੍ਯਤ੍ਵਾਤ੍ ਕੇਵਲੰ ਬਹਿਃ ਪ੍ਰਕ੍ਸ਼਼ੇਪ੍ਤੁੰ ਨਰਾਣਾਂ ਪਦਤਲੇਨ ਦਲਯਿਤੁਞ੍ਚ ਯੋਗ੍ਯੰ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","ਯੂਯੰ ਜਗਤਿ ਦੀਪ੍ਤਿਰੂਪਾਃ, ਭੂਧਰੋਪਰਿ ਸ੍ਥਿਤੰ ਨਗਰੰ ਗੁਪ੍ਤੰ ਭਵਿਤੁੰ ਨਹਿ ਸ਼ਕ੍ਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","ਅਪਰੰ ਮਨੁਜਾਃ ਪ੍ਰਦੀਪਾਨ੍ ਪ੍ਰਜ੍ਵਾਲ੍ਯ ਦ੍ਰੋਣਾਧੋ ਨ ਸ੍ਥਾਪਯਨ੍ਤਿ, ਕਿਨ੍ਤੁ ਦੀਪਾਧਾਰੋਪਰ੍ੱਯੇਵ ਸ੍ਥਾਪਯਨ੍ਤਿ, ਤੇਨ ਤੇ ਦੀਪਾ ਗੇਹਸ੍ਥਿਤਾਨ੍ ਸਕਲਾਨ੍ ਪ੍ਰਕਾਸ਼ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","ਯੇਨ ਮਾਨਵਾ ਯੁਸ਼਼੍ਮਾਕੰ ਸਤ੍ਕਰ੍ੰਮਾਣਿ ਵਿਲੋਕ੍ਯ ਯੁਸ਼਼੍ਮਾਕੰ ਸ੍ਵਰ੍ਗਸ੍ਥੰ ਪਿਤਰੰ ਧਨ੍ਯੰ ਵਦਨ੍ਤਿ, ਤੇਸ਼਼ਾਂ ਸਮਕ੍ਸ਼਼ੰ ਯੁਸ਼਼੍ਮਾਕੰ ਦੀਪ੍ਤਿਸ੍ਤਾਦ੍ਰੁʼਕ੍ ਪ੍ਰਕਾਸ਼ਤਾਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","ਅਹੰ ਵ੍ਯਵਸ੍ਥਾਂ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਕ੍ਯਞ੍ਚ ਲੋਪ੍ਤੁਮ੍ ਆਗਤਵਾਨ੍, ਇੱਥੰ ਮਾਨੁਭਵਤ, ਤੇ ਦ੍ਵੇ ਲੋਪ੍ਤੁੰ ਨਾਗਤਵਾਨ੍, ਕਿਨ੍ਤੁ ਸਫਲੇ ਕਰ੍ੱਤੁਮ੍ ਆਗਤੋਸ੍ਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","ਅਪਰੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਅਹੰ ਤਥ੍ਯੰ ਵਦਾਮਿ ਯਾਵਤ੍ ਵ੍ਯੋਮਮੇਦਿਨ੍ਯੋ ਰ੍ਧ੍ਵੰਸੋ ਨ ਭਵਿਸ਼਼੍ਯਤਿ, ਤਾਵਤ੍ ਸਰ੍ੱਵਸ੍ਮਿਨ੍ ਸਫਲੇ ਨ ਜਾਤੇ ਵ੍ਯਵਸ੍ਥਾਯਾ ਏਕਾ ਮਾਤ੍ਰਾ ਬਿਨ੍ਦੁਰੇਕੋਪਿ ਵਾ ਨ ਲੋਪ੍ਸ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ਤਸ੍ਮਾਤ੍ ਯੋ ਜਨ ਏਤਾਸਾਮ੍ ਆਜ੍ਞਾਨਾਮ੍ ਅਤਿਕ੍ਸ਼਼ੁਦ੍ਰਾਮ੍ ਏਕਾਜ੍ਞਾਮਪੀ ਲੰਘਤੇ ਮਨੁਜਾਂਞ੍ਚ ਤਥੈਵ ਸ਼ਿਕ੍ਸ਼਼ਯਤਿ, ਸ ਸ੍ਵਰ੍ਗੀਯਰਾਜ੍ਯੇ ਸਰ੍ੱਵੇਭ੍ਯਃ ਕ੍ਸ਼਼ੁਦ੍ਰਤ੍ਵੇਨ ਵਿਖ੍ਯਾਸ੍ਯਤੇ, ਕਿਨ੍ਤੁ ਯੋ ਜਨਸ੍ਤਾਂ ਪਾਲਯਤਿ, ਤਥੈਵ ਸ਼ਿਕ੍ਸ਼਼ਯਤਿ ਚ, ਸ ਸ੍ਵਰ੍ਗੀਯਰਾਜ੍ਯੇ ਪ੍ਰਧਾਨਤ੍ਵੇਨ ਵਿਖ੍ਯਾਸ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","ਅਪਰੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਅਹੰ ਵਦਾਮਿ, ਅਧ੍ਯਾਪਕਫਿਰੂਸ਼ਿਮਾਨਵਾਨਾਂ ਧਰ੍ੰਮਾਨੁਸ਼਼੍ਠਾਨਾਤ੍ ਯੁਸ਼਼੍ਮਾਕੰ ਧਰ੍ੰਮਾਨੁਸ਼਼੍ਠਾਨੇ ਨੋੱਤਮੇ ਜਾਤੇ ਯੂਯਮ੍ ਈਸ਼੍ਵਰੀਯਰਾਜ੍ਯੰ ਪ੍ਰਵੇਸ਼਼੍ਟੁੰ ਨ ਸ਼ਕ੍ਸ਼਼੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","ਅਪਰਞ੍ਚ ਤ੍ਵੰ ਨਰੰ ਮਾ ਵਧੀਃ, ਯਸ੍ਮਾਤ੍ ਯੋ ਨਰੰ ਹਨ੍ਤਿ, ਸ ਵਿਚਾਰਸਭਾਯਾਂ ਦਣ੍ਡਾਰ੍ਹੋ ਭਵਿਸ਼਼੍ਯਤਿ, ਪੂਰ੍ੱਵਕਾਲੀਨਜਨੇਭ੍ਯ ਇਤਿ ਕਥਿਤਮਾਸੀਤ੍, ਯੁਸ਼਼੍ਮਾਭਿਰਸ਼੍ਰਾਵਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","ਕਿਨ੍ਤ੍ਵਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਵਦਾਮਿ, ਯਃ ਕਸ਼੍ਚਿਤ੍ ਕਾਰਣੰ ਵਿਨਾ ਨਿਜਭ੍ਰਾਤ੍ਰੇ ਕੁਪ੍ਯਤਿ, ਸ ਵਿਚਾਰਸਭਾਯਾਂ ਦਣ੍ਡਾਰ੍ਹੋ ਭਵਿਸ਼਼੍ਯਤਿ; ਯਃ ਕਸ਼੍ਚਿੱਚ ਸ੍ਵੀਯਸਹਜੰ ਨਿਰ੍ੱਬੋਧੰ ਵਦਤਿ, ਸ ਮਹਾਸਭਾਯਾਂ ਦਣ੍ਡਾਰ੍ਹੋ ਭਵਿਸ਼਼੍ਯਤਿ; ਪੁਨਸ਼੍ਚ ਤ੍ਵੰ ਮੂਢ ਇਤਿ ਵਾਕ੍ਯੰ ਯਦਿ ਕਸ਼੍ਚਿਤ੍ ਸ੍ਵੀਯਭ੍ਰਾਤਰੰ ਵਕ੍ਤਿ, ਤਰ੍ਹਿ ਨਰਕਾਗ੍ਨੌ ਸ ਦਣ੍ਡਾਰ੍ਹੋ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","ਅਤੋ ਵੇਦ੍ਯਾਃ ਸਮੀਪੰ ਨਿਜਨੈਵੇਦ੍ਯੇ ਸਮਾਨੀਤੇ(ਅ)ਪਿ ਨਿਜਭ੍ਰਾਤਰੰ ਪ੍ਰਤਿ ਕਸ੍ਮਾੱਚਿਤ੍ ਕਾਰਣਾਤ੍ ਤ੍ਵੰ ਯਦਿ ਦੋਸ਼਼ੀ ਵਿਦ੍ਯਸੇ, ਤਦਾਨੀਂ ਤਵ ਤਸ੍ਯ ਸ੍ਮ੍ਰੁʼਤਿ ਰ੍ਜਾਯਤੇ ਚ, ");
INSERT INTO sanpun_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ਤਰ੍ਹਿ ਤਸ੍ਯਾ ਵੇਦ੍ਯਾਃ ਸਮੀਪੇ ਨਿਜਨੈਵੈਦ੍ਯੰ ਨਿਧਾਯ ਤਦੈਵ ਗਤ੍ਵਾ ਪੂਰ੍ੱਵੰ ਤੇਨ ਸਾਰ੍ੱਧੰ ਮਿਲ, ਪਸ਼੍ਚਾਤ੍ ਆਗਤ੍ਯ ਨਿਜਨੈਵੇਦ੍ਯੰ ਨਿਵੇਦਯ| ");
INSERT INTO sanpun_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","ਅਨ੍ਯਞ੍ਚ ਯਾਵਤ੍ ਵਿਵਾਦਿਨਾ ਸਾਰ੍ੱਧੰ ਵਰ੍ਤ੍ਮਨਿ ਤਿਸ਼਼੍ਠਸਿ, ਤਾਵਤ੍ ਤੇਨ ਸਾਰ੍ੱਧੰ ਮੇਲਨੰ ਕੁਰੁ; ਨੋ ਚੇਤ੍ ਵਿਵਾਦੀ ਵਿਚਾਰਯਿਤੁਃ ਸਮੀਪੇ ਤ੍ਵਾਂ ਸਮਰ੍ਪਯਤਿ ਵਿਚਾਰਯਿਤਾ ਚ ਰਕ੍ਸ਼਼ਿਣਃ ਸੰਨਿਧੌ ਸਮਰ੍ਪਯਤਿ ਤਦਾ ਤ੍ਵੰ ਕਾਰਾਯਾਂ ਬਧ੍ਯੇਥਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ਤਰ੍ਹਿ ਤ੍ਵਾਮਹੰ ਤਥ੍ਥੰ ਬ੍ਰਵੀਮਿ, ਸ਼ੇਸ਼਼ਕਪਰ੍ਦਕੇ(ਅ)ਪਿ ਨ ਪਰਿਸ਼ੋਧਿਤੇ ਤਸ੍ਮਾਤ੍ ਸ੍ਥਾਨਾਤ੍ ਕਦਾਪਿ ਬਹਿਰਾਗਨ੍ਤੁੰ ਨ ਸ਼ਕ੍ਸ਼਼੍ਯਸਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","ਅਪਰੰ ਤ੍ਵੰ ਮਾ ਵ੍ਯਭਿਚਰ, ਯਦੇਤਦ੍ ਵਚਨੰ ਪੂਰ੍ੱਵਕਾਲੀਨਲੋਕੇਭ੍ਯਃ ਕਥਿਤਮਾਸੀਤ੍, ਤਦ੍ ਯੂਯੰ ਸ਼੍ਰੁਤਵਨ੍ਤਃ; ");
INSERT INTO sanpun_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","ਕਿਨ੍ਤ੍ਵਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਵਦਾਮਿ, ਯਦਿ ਕਸ਼੍ਚਿਤ੍ ਕਾਮਤਃ ਕਾਞ੍ਚਨ ਯੋਸ਼਼ਿਤੰ ਪਸ਼੍ਯਤਿ, ਤਰ੍ਹਿ ਸ ਮਨਸਾ ਤਦੈਵ ਵ੍ਯਭਿਚਰਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ਤਸ੍ਮਾਤ੍ ਤਵ ਦਕ੍ਸ਼਼ਿਣੰ ਨੇਤ੍ਰੰ ਯਦਿ ਤ੍ਵਾਂ ਬਾਧਤੇ, ਤਰ੍ਹਿ ਤੰਨੇਤ੍ਰਮ੍ ਉਤ੍ਪਾਟ੍ਯ ਦੂਰੇ ਨਿਕ੍ਸ਼਼ਿਪ, ਯਸ੍ਮਾਤ੍ ਤਵ ਸਰ੍ੱਵਵਪੁਸ਼਼ੋ ਨਰਕੇ ਨਿਕ੍ਸ਼਼ੇਪਾਤ੍ ਤਵੈਕਾਙ੍ਗਸ੍ਯ ਨਾਸ਼ੋ ਵਰੰ| ");
INSERT INTO sanpun_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","ਯਦ੍ਵਾ ਤਵ ਦਕ੍ਸ਼਼ਿਣਃ ਕਰੋ ਯਦਿ ਤ੍ਵਾਂ ਬਾਧਤੇ, ਤਰ੍ਹਿ ਤੰ ਕਰੰ ਛਿੱਤ੍ਵਾ ਦੂਰੇ ਨਿਕ੍ਸ਼਼ਿਪ, ਯਤਃ ਸਰ੍ੱਵਵਪੁਸ਼਼ੋ ਨਰਕੇ ਨਿਕ੍ਸ਼਼ੇਪਾਤ੍ ਏਕਾਙ੍ਗਸ੍ਯ ਨਾਸ਼ੋ ਵਰੰ| ");
INSERT INTO sanpun_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","ਉਕ੍ਤਮਾਸ੍ਤੇ, ਯਦਿ ਕਸ਼੍ਚਿਨ੍ ਨਿਜਜਾਯਾਂ ਪਰਿਤ੍ਯਕ੍ੱਤੁਮ੍ ਇੱਛਤਿ, ਤਰ੍ਹਿ ਸ ਤਸ੍ਯੈ ਤ੍ਯਾਗਪਤ੍ਰੰ ਦਦਾਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","ਕਿਨ੍ਤ੍ਵਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਵ੍ਯਾਹਰਾਮਿ, ਵ੍ਯਭਿਚਾਰਦੋਸ਼਼ੇ ਨ ਜਾਤੇ ਯਦਿ ਕਸ਼੍ਚਿਨ੍ ਨਿਜਜਾਯਾਂ ਪਰਿਤ੍ਯਜਤਿ, ਤਰ੍ਹਿ ਸ ਤਾਂ ਵ੍ਯਭਿਚਾਰਯਤਿ; ਯਸ਼੍ਚ ਤਾਂ ਤ੍ਯਕ੍ਤਾਂ ਸ੍ਤ੍ਰਿਯੰ ਵਿਵਹਤਿ, ਸੋਪਿ ਵ੍ਯਭਿਚਰਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","ਪੁਨਸ਼੍ਚ ਤ੍ਵੰ ਮ੍ਰੁʼਸ਼਼ਾ ਸ਼ਪਥਮ੍ ਨ ਕੁਰ੍ੱਵਨ੍ ਈਸ਼੍ਚਰਾਯ ਨਿਜਸ਼ਪਥੰ ਪਾਲਯ, ਪੂਰ੍ੱਵਕਾਲੀਨਲੋਕੇਭ੍ਯੋ ਯੈਸ਼਼ਾ ਕਥਾ ਕਥਿਤਾ, ਤਾਮਪਿ ਯੂਯੰ ਸ਼੍ਰੁਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","ਕਿਨ੍ਤ੍ਵਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਵਦਾਮਿ, ਕਮਪਿ ਸ਼ਪਥੰ ਮਾ ਕਾਰ੍ਸ਼਼੍ਟ, ਅਰ੍ਥਤਃ ਸ੍ਵਰ੍ਗਨਾਮ੍ਨਾ ਨ, ਯਤਃ ਸ ਈਸ਼੍ਵਰਸ੍ਯ ਸਿੰਹਾਸਨੰ; ");
INSERT INTO sanpun_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ਪ੍ਰੁʼਥਿਵ੍ਯਾ ਨਾਮ੍ਨਾਪਿ ਨ, ਯਤਃ ਸਾ ਤਸ੍ਯ ਪਾਦਪੀਠੰ; ਯਿਰੂਸ਼ਾਲਮੋ ਨਾਮ੍ਨਾਪਿ ਨ, ਯਤਃ ਸਾ ਮਹਾਰਾਜਸ੍ਯ ਪੁਰੀ; ");
INSERT INTO sanpun_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ਨਿਜਸ਼ਿਰੋਨਾਮ੍ਨਾਪਿ ਨ, ਯਸ੍ਮਾਤ੍ ਤਸ੍ਯੈਕੰ ਕਚਮਪਿ ਸਿਤਮ੍ ਅਸਿਤੰ ਵਾ ਕਰ੍ੱਤੁੰ ਤ੍ਵਯਾ ਨ ਸ਼ਕ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","ਅਪਰੰ ਯੂਯੰ ਸੰਲਾਪਸਮਯੇ ਕੇਵਲੰ ਭਵਤੀਤਿ ਨ ਭਵਤੀਤਿ ਚ ਵਦਤ ਯਤ ਇਤੋ(ਅ)ਧਿਕੰ ਯਤ੍ ਤਤ੍ ਪਾਪਾਤ੍ਮਨੋ ਜਾਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","ਅਪਰੰ ਲੋਚਨਸ੍ਯ ਵਿਨਿਮਯੇਨ ਲੋਚਨੰ ਦਨ੍ਤਸ੍ਯ ਵਿਨਿਮਯੇਨ ਦਨ੍ਤਃ ਪੂਰ੍ੱਵਕ੍ਤਮਿਦੰ ਵਚਨਞ੍ਚ ਯੁਸ਼਼੍ਮਾਭਿਰਸ਼੍ਰੂਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","ਕਿਨ੍ਤ੍ਵਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਵਦਾਮਿ ਯੂਯੰ ਹਿੰਸਕੰ ਨਰੰ ਮਾ ਵ੍ਯਾਘਾਤਯਤ| ਕਿਨ੍ਤੁ ਕੇਨਚਿਤ੍ ਤਵ ਦਕ੍ਸ਼਼ਿਣਕਪੋਲੇ ਚਪੇਟਾਘਾਤੇ ਕ੍ਰੁʼਤੇ ਤੰ ਪ੍ਰਤਿ ਵਾਮੰ ਕਪੋਲਞ੍ਚ ਵ੍ਯਾਘੋਟਯ| ");
INSERT INTO sanpun_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ਅਪਰੰ ਕੇਨਚਿਤ੍ ਤ੍ਵਯਾ ਸਾਰ੍ਧ੍ਦੰ ਵਿਵਾਦੰ ਕ੍ਰੁʼਤ੍ਵਾ ਤਵ ਪਰਿਧੇਯਵਸਨੇ ਜਿਘ੍ਰੁʼਤਿਤੇ ਤਸ੍ਮਾਯੁੱਤਰੀਯਵਸਨਮਪਿ ਦੇਹਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ਯਦਿ ਕਸ਼੍ਚਿਤ੍ ਤ੍ਵਾਂ ਕ੍ਰੋਸ਼ਮੇਕੰ ਨਯਨਾਰ੍ਥੰ ਅਨ੍ਯਾਯਤੋ ਧਰਤਿ, ਤਦਾ ਤੇਨ ਸਾਰ੍ਧ੍ਦੰ ਕ੍ਰੋਸ਼ਦ੍ਵਯੰ ਯਾਹਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ਯਸ਼੍ਚ ਮਾਨਵਸ੍ਤ੍ਵਾਂ ਯਾਚਤੇ, ਤਸ੍ਮੈ ਦੇਹਿ, ਯਦਿ ਕਸ਼੍ਚਿਤ੍ ਤੁਭ੍ਯੰ ਧਾਰਯਿਤੁਮ੍ ਇੱਛਤਿ, ਤਰ੍ਹਿ ਤੰ ਪ੍ਰਤਿ ਪਰਾਂਮੁਖੋ ਮਾ ਭੂਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","ਨਿਜਸਮੀਪਵਸਿਨਿ ਪ੍ਰੇਮ ਕੁਰੁ, ਕਿਨ੍ਤੁ ਸ਼ਤ੍ਰੁੰ ਪ੍ਰਤਿ ਦ੍ਵੇਸ਼਼ੰ ਕੁਰੁ, ਯਦੇਤਤ੍ ਪੁਰੋਕ੍ਤੰ ਵਚਨੰ ਏਤਦਪਿ ਯੂਯੰ ਸ਼੍ਰੁਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","ਕਿਨ੍ਤ੍ਵਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਵਦਾਮਿ, ਯੂਯੰ ਰਿਪੁੱਵਪਿ ਪ੍ਰੇਮ ਕੁਰੁਤ, ਯੇ ਚ ਯੁਸ਼਼੍ਮਾਨ੍ ਸ਼ਪਨ੍ਤੇ, ਤਾਨ, ਆਸ਼ਿਸ਼਼ੰ ਵਦਤ, ਯੇ ਚ ਯੁਸ਼਼੍ਮਾਨ੍ ਰੁʼृਤੀਯਨ੍ਤੇ, ਤੇਸ਼਼ਾਂ ਮਙ੍ਗਲੰ ਕੁਰੁਤ, ਯੇ ਚ ਯੁਸ਼਼੍ਮਾਨ੍ ਨਿਨ੍ਦਨ੍ਤਿ, ਤਾਡਯਨ੍ਤਿ ਚ, ਤੇਸ਼਼ਾਂ ਕ੍ਰੁʼਤੇ ਪ੍ਰਾਰ੍ਥਯਧ੍ਵੰ| ");
INSERT INTO sanpun_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ਤਤ੍ਰ ਯਃ ਸਤਾਮਸਤਾਞ੍ਚੋਪਰਿ ਪ੍ਰਭਾਕਰਮ੍ ਉਦਾਯਯਤਿ, ਤਥਾ ਧਾਰ੍ੰਮਿਕਾਨਾਮਧਾਰ੍ੰਮਿਕਾਨਾਞ੍ਚੋਪਰਿ ਨੀਰੰ ਵਰ੍ਸ਼਼ਯਤਿ ਤਾਦ੍ਰੁʼਸ਼ੋ ਯੋ ਯੁਸ਼਼੍ਮਾਕੰ ਸ੍ਵਰ੍ਗਸ੍ਥਃ ਪਿਤਾ, ਯੂਯੰ ਤਸ੍ਯੈਵ ਸਨ੍ਤਾਨਾ ਭਵਿਸ਼਼੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ਯੇ ਯੁਸ਼਼੍ਮਾਸੁ ਪ੍ਰੇਮ ਕੁਰ੍ੱਵਨ੍ਤਿ, ਯੂਯੰ ਯਦਿ ਕੇਵਲੰ ਤੇੱਵੇਵ ਪ੍ਰੇਮ ਕੁਰੁਥ, ਤਰ੍ਹਿ ਯੁਸ਼਼੍ਮਾਕੰ ਕਿੰ ਫਲੰ ਭਵਿਸ਼਼੍ਯਤਿ? ਚਣ੍ਡਾਲਾ ਅਪਿ ਤਾਦ੍ਰੁʼਸ਼ੰ ਕਿੰ ਨ ਕੁਰ੍ੱਵਨ੍ਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","ਅਪਰੰ ਯੂਯੰ ਯਦਿ ਕੇਵਲੰ ਸ੍ਵੀਯਭ੍ਰਾਤ੍ਰੁʼਤ੍ਵੇਨ ਨਮਤ, ਤਰ੍ਹਿ ਕਿੰ ਮਹਤ੍ ਕਰ੍ੰਮ ਕੁਰੁਥ? ਚਣ੍ਡਾਲਾ ਅਪਿ ਤਾਦ੍ਰੁʼਸ਼ੰ ਕਿੰ ਨ ਕੁਰ੍ੱਵਨ੍ਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","ਤਸ੍ਮਾਤ੍ ਯੁਸ਼਼੍ਮਾਕੰ ਸ੍ਵਰ੍ਗਸ੍ਥਃ ਪਿਤਾ ਯਥਾ ਪੂਰ੍ਣੋ ਭਵਤਿ, ਯੂਯਮਪਿ ਤਾਦ੍ਰੁʼਸ਼ਾ ਭਵਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","ਸਾਵਧਾਨਾ ਭਵਤ, ਮਨੁਜਾਨ੍ ਦਰ੍ਸ਼ਯਿਤੁੰ ਤੇਸ਼਼ਾਂ ਗੋਚਰੇ ਧਰ੍ੰਮਕਰ੍ੰਮ ਮਾ ਕੁਰੁਤ, ਤਥਾ ਕ੍ਰੁʼਤੇ ਯੁਸ਼਼੍ਮਾਕੰ ਸ੍ਵਰ੍ਗਸ੍ਥਪਿਤੁਃ ਸਕਾਸ਼ਾਤ੍ ਕਿਞ੍ਚਨ ਫਲੰ ਨ ਪ੍ਰਾਪ੍ਸ੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","ਤ੍ਵੰ ਯਦਾ ਦਦਾਸਿ ਤਦਾ ਕਪਟਿਨੋ ਜਨਾ ਯਥਾ ਮਨੁਜੇਭ੍ਯਃ ਪ੍ਰਸ਼ੰਸਾਂ ਪ੍ਰਾਪ੍ਤੁੰ ਭਜਨਭਵਨੇ ਰਾਜਮਾਰ੍ਗੇ ਚ ਤੂਰੀਂ ਵਾਦਯਨ੍ਤਿ, ਤਥਾ ਮਾ ਕੁਰਿु, ਅਹੰ ਤੁਭ੍ਯੰ ਯਥਾਰ੍ਥੰ ਕਥਯਾਮਿ, ਤੇ ਸ੍ਵਕਾਯੰ ਫਲਮ੍ ਅਲਭਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","ਕਿਨ੍ਤੁ ਤ੍ਵੰ ਯਦਾ ਦਦਾਸਿ, ਤਦਾ ਨਿਜਦਕ੍ਸ਼਼ਿਣਕਰੋ ਯਤ੍ ਕਰੋਤਿ, ਤਦ੍ ਵਾਮਕਰੰ ਮਾ ਜ੍ਞਾਪਯ| ");
INSERT INTO sanpun_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ਤੇਨ ਤਵ ਦਾਨੰ ਗੁਪ੍ਤੰ ਭਵਿਸ਼਼੍ਯਤਿ ਯਸ੍ਤੁ ਤਵ ਪਿਤਾ ਗੁਪ੍ਤਦਰ੍ਸ਼ੀ, ਸ ਪ੍ਰਕਾਸ਼੍ਯ ਤੁਭ੍ਯੰ ਫਲੰ ਦਾਸ੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","ਅਪਰੰ ਯਦਾ ਪ੍ਰਾਰ੍ਥਯਸੇ, ਤਦਾ ਕਪਟਿਨਇਵ ਮਾ ਕੁਰੁ, ਯਸ੍ਮਾਤ੍ ਤੇ ਭਜਨਭਵਨੇ ਰਾਜਮਾਰ੍ਗਸ੍ਯ ਕੋਣੇ ਤਿਸ਼਼੍ਠਨ੍ਤੋ ਲੋਕਾਨ੍ ਦਰ੍ਸ਼ਯਨ੍ਤਃ ਪ੍ਰਾਰ੍ਥਯਿਤੁੰ ਪ੍ਰੀਯਨ੍ਤੇ; ਅਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਤਥ੍ਯੰ ਵਦਾਮਿ, ਤੇ ਸ੍ਵਕੀਯਫਲੰ ਪ੍ਰਾਪ੍ਨੁਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","ਤਸ੍ਮਾਤ੍ ਪ੍ਰਾਰ੍ਥਨਾਕਾਲੇ ਅਨ੍ਤਰਾਗਾਰੰ ਪ੍ਰਵਿਸ਼੍ਯ ਦ੍ਵਾਰੰ ਰੁਦ੍ੱਵਾ ਗੁਪ੍ਤੰ ਪਸ਼੍ਯਤਸ੍ਤਵ ਪਿਤੁਃ ਸਮੀਪੇ ਪ੍ਰਾਰ੍ਥਯਸ੍ਵ; ਤੇਨ ਤਵ ਯਃ ਪਿਤਾ ਗੁਪ੍ਤਦਰ੍ਸ਼ੀ, ਸ ਪ੍ਰਕਾਸ਼੍ਯ ਤੁਭ੍ਯੰ ਫਲੰ ਦਾਸ੍ਯਤਿl ");
INSERT INTO sanpun_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","ਅਪਰੰ ਪ੍ਰਾਰ੍ਥਨਾਕਾਲੇ ਦੇਵਪੂਜਕਾਇਵ ਮੁਧਾ ਪੁਨਰੁਕ੍ਤਿੰ ਮਾ ਕੁਰੁ, ਯਸ੍ਮਾਤ੍ ਤੇ ਬੋਧਨ੍ਤੇ, ਬਹੁਵਾਰੰ ਕਥਾਯਾਂ ਕਥਿਤਾਯਾਂ ਤੇਸ਼਼ਾਂ ਪ੍ਰਾਰ੍ਥਨਾ ਗ੍ਰਾਹਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","ਯੂਯੰ ਤੇਸ਼਼ਾਮਿਵ ਮਾ ਕੁਰੁਤ, ਯਸ੍ਮਾਤ੍ ਯੁਸ਼਼੍ਮਾਕੰ ਯਦ੍ ਯਤ੍ ਪ੍ਰਯੋਜਨੰ ਯਾਚਨਾਤਃ ਪ੍ਰਾਗੇਵ ਯੁਸ਼਼੍ਮਾਕੰ ਪਿਤਾ ਤਤ੍ ਜਾਨਾਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","ਅਤਏਵ ਯੂਯਮ ਈਦ੍ਰੁʼਕ੍ ਪ੍ਰਾਰ੍ਥਯਧ੍ਵੰ, ਹੇ ਅਸ੍ਮਾਕੰ ਸ੍ਵਰ੍ਗਸ੍ਥਪਿਤਃ, ਤਵ ਨਾਮ ਪੂਜ੍ਯੰ ਭਵਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ਤਵ ਰਾਜਤ੍ਵੰ ਭਵਤੁ; ਤਵੇੱਛਾ ਸ੍ਵਰ੍ਗੇ ਯਥਾ ਤਥੈਵ ਮੇਦਿਨ੍ਯਾਮਪਿ ਸਫਲਾ ਭਵਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ਅਸ੍ਮਾਕੰ ਪ੍ਰਯੋਜਨੀਯਮ੍ ਆਹਾਰਮ੍ ਅਦ੍ਯ ਦੇਹਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ਵਯੰ ਯਥਾ ਨਿਜਾਪਰਾਧਿਨਃ ਕ੍ਸ਼਼ਮਾਮਹੇ, ਤਥੈਵਾਸ੍ਮਾਕਮ੍ ਅਪਰਾਧਾਨ੍ ਕ੍ਸ਼਼ਮਸ੍ਵ| ");
INSERT INTO sanpun_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ਅਸ੍ਮਾਨ੍ ਪਰੀਕ੍ਸ਼਼ਾਂ ਮਾਨਯ, ਕਿਨ੍ਤੁ ਪਾਪਾਤ੍ਮਨੋ ਰਕ੍ਸ਼਼; ਰਾਜਤ੍ਵੰ ਗੌਰਵੰ ਪਰਾਕ੍ਰਮਃ ਏਤੇ ਸਰ੍ੱਵੇ ਸਰ੍ੱਵਦਾ ਤਵ; ਤਥਾਸ੍ਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","ਯਦਿ ਯੂਯਮ੍ ਅਨ੍ਯੇਸ਼਼ਾਮ੍ ਅਪਰਾਧਾਨ੍ ਕ੍ਸ਼਼ਮਧ੍ਵੇ ਤਰ੍ਹਿ ਯੁਸ਼਼੍ਮਾਕੰ ਸ੍ਵਰ੍ਗਸ੍ਥਪਿਤਾਪਿ ਯੁਸ਼਼੍ਮਾਨ੍ ਕ੍ਸ਼਼ਮਿਸ਼਼੍ਯਤੇ; ");
INSERT INTO sanpun_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ਕਿਨ੍ਤੁ ਯਦਿ ਯੂਯਮ੍ ਅਨ੍ਯੇਸ਼਼ਾਮ੍ ਅਪਰਾਧਾਨ੍ ਨ ਕ੍ਸ਼਼ਮਧ੍ਵੇ, ਤਰ੍ਹਿ ਯੁਸ਼਼੍ਮਾਕੰ ਜਨਕੋਪਿ ਯੁਸ਼਼੍ਮਾਕਮ੍ ਅਪਰਾਧਾਨ੍ ਨ ਕ੍ਸ਼਼ਮਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","ਅਪਰਮ੍ ਉਪਵਾਸਕਾਲੇ ਕਪਟਿਨੋ ਜਨਾ ਮਾਨੁਸ਼਼ਾਨ੍ ਉਪਵਾਸੰ ਜ੍ਞਾਪਯਿਤੁੰ ਸ੍ਵੇਸ਼਼ਾਂ ਵਦਨਾਨਿ ਮ੍ਲਾਨਾਨਿ ਕੁਰ੍ੱਵਨ੍ਤਿ, ਯੂਯੰ ਤਇਵ ਵਿਸ਼਼ਣਵਦਨਾ ਮਾ ਭਵਤ; ਅਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਤਥ੍ਯੰ ਵਦਾਮਿ ਤੇ ਸ੍ਵਕੀਯਫਲਮ੍ ਅਲਭਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","ਯਦਾ ਤ੍ਵਮ੍ ਉਪਵਸਸਿ, ਤਦਾ ਯਥਾ ਲੋਕੈਸ੍ਤ੍ਵੰ ਉਪਵਾਸੀਵ ਨ ਦ੍ਰੁʼਸ਼੍ਯਸੇ, ਕਿਨ੍ਤੁ ਤਵ ਯੋ(ਅ)ਗੋਚਰਃ ਪਿਤਾ ਤੇਨੈਵ ਦ੍ਰੁʼਸ਼੍ਯਸੇ, ਤਤ੍ਕ੍ਰੁʼਤੇ ਨਿਜਸ਼ਿਰਸਿ ਤੈਲੰ ਮਰ੍ੱਦਯ ਵਦਨਞ੍ਚ ਪ੍ਰਕ੍ਸ਼਼ਾਲਯ; ");
INSERT INTO sanpun_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ਤੇਨ ਤਵ ਯਃ ਪਿਤਾ ਗੁਪ੍ਤਦਰ੍ਸ਼ੀ ਸ ਪ੍ਰਕਾਸ਼੍ਯ ਤੁਭ੍ਯੰ ਫਲੰ ਦਾਸ੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","ਅਪਰੰ ਯਤ੍ਰ ਸ੍ਥਾਨੇ ਕੀਟਾਃ ਕਲਙ੍ਕਾਸ਼੍ਚ ਕ੍ਸ਼਼ਯੰ ਨਯਨ੍ਤਿ, ਚੌਰਾਸ਼੍ਚ ਸਨ੍ਧਿੰ ਕਰ੍ੱਤਯਿਤ੍ਵਾ ਚੋਰਯਿਤੁੰ ਸ਼ਕ੍ਨੁਵਨ੍ਤਿ, ਤਾਦ੍ਰੁʼਸ਼੍ਯਾਂ ਮੇਦਿਨ੍ਯਾਂ ਸ੍ਵਾਰ੍ਥੰ ਧਨੰ ਮਾ ਸੰਚਿਨੁਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","ਕਿਨ੍ਤੁ ਯਤ੍ਰ ਸ੍ਥਾਨੇ ਕੀਟਾਃ ਕਲਙ੍ਕਾਸ਼੍ਚ ਕ੍ਸ਼਼ਯੰ ਨ ਨਯਨ੍ਤਿ, ਚੌਰਾਸ਼੍ਚ ਸਨ੍ਧਿੰ ਕਰ੍ੱਤਯਿਤ੍ਵਾ ਚੋਰਯਿਤੁੰ ਨ ਸ਼ਕ੍ਨੁਵਨ੍ਤਿ, ਤਾਦ੍ਰੁʼਸ਼ੇ ਸ੍ਵਰ੍ਗੇ ਧਨੰ ਸਞ੍ਚਿਨੁਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ਯਸ੍ਮਾਤ੍ ਯਤ੍ਰ ਸ੍ਥਾਨੇ ਯੁਸ਼਼੍ਮਾਂਕ ਧਨੰ ਤਤ੍ਰੈਵ ਖਾਨੇ ਯੁਸ਼਼੍ਮਾਕੰ ਮਨਾਂਸਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","ਲੋਚਨੰ ਦੇਹਸ੍ਯ ਪ੍ਰਦੀਪਕੰ, ਤਸ੍ਮਾਤ੍ ਯਦਿ ਤਵ ਲੋਚਨੰ ਪ੍ਰਸੰਨੰ ਭਵਤਿ, ਤਰ੍ਹਿ ਤਵ ਕ੍ਰੁʼਤ੍ਸ੍ਨੰ ਵਪੁ ਰ੍ਦੀਪ੍ਤਿਯੁਕ੍ਤੰ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ਕਿਨ੍ਤੁ ਲੋਚਨੇ(ਅ)ਪ੍ਰਸੰਨੇ ਤਵ ਕ੍ਰੁʼਤ੍ਸ੍ਨੰ ਵਪੁਃ ਤਮਿਸ੍ਰਯੁਕ੍ਤੰ ਭਵਿਸ਼਼੍ਯਤਿ| ਅਤਏਵ ਯਾ ਦੀਪ੍ਤਿਸ੍ਤ੍ਵਯਿ ਵਿਦ੍ਯਤੇ, ਸਾ ਯਦਿ ਤਮਿਸ੍ਰਯੁਕ੍ਤਾ ਭਵਤਿ, ਤਰ੍ਹਿ ਤਤ੍ ਤਮਿਸ੍ਰੰ ਕਿਯਨ੍ ਮਹਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","ਕੋਪਿ ਮਨੁਜੋ ਦ੍ਵੌ ਪ੍ਰਭੂ ਸੇਵਿਤੁੰ ਨ ਸ਼ਕ੍ਨੋਤਿ, ਯਸ੍ਮਾਦ੍ ਏਕੰ ਸੰਮਨ੍ਯ ਤਦਨ੍ਯੰ ਨ ਸੰਮਨ੍ਯਤੇ, ਯਦ੍ਵਾ ਏਕਤ੍ਰ ਮਨੋ ਨਿਧਾਯ ਤਦਨ੍ਯਮ੍ ਅਵਮਨ੍ਯਤੇ; ਤਥਾ ਯੂਯਮਪੀਸ਼੍ਵਰੰ ਲਕ੍ਸ਼਼੍ਮੀਞ੍ਚੇਤ੍ਯੁਭੇ ਸੇਵਿਤੁੰ ਨ ਸ਼ਕ੍ਨੁਥ| ");
INSERT INTO sanpun_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","ਅਪਰਮ੍ ਅਹੰ ਯੁਸ਼਼੍ਮਭ੍ਯੰ ਤਥ੍ਯੰ ਕਥਯਾਮਿ, ਕਿੰ ਭਕ੍ਸ਼਼ਿਸ਼਼੍ਯਾਮਃ? ਕਿੰ ਪਾਸ੍ਯਾਮਃ? ਇਤਿ ਪ੍ਰਾਣਧਾਰਣਾਯ ਮਾ ਚਿਨ੍ਤਯਤ; ਕਿੰ ਪਰਿਧਾਸ੍ਯਾਮਃ? ਇਤਿ ਕਾਯਰਕ੍ਸ਼਼ਣਾਯ ਨ ਚਿਨ੍ਤਯਤ; ਭਕ੍ਸ਼਼੍ਯਾਤ੍ ਪ੍ਰਾਣਾ ਵਸਨਾਞ੍ਚ ਵਪੂੰਸ਼਼ਿ ਕਿੰ ਸ਼੍ਰੇਸ਼਼੍ਠਾਣਿ ਨ ਹਿ? ");
INSERT INTO sanpun_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ਵਿਹਾਯਸੋ ਵਿਹਙ੍ਗਮਾਨ੍ ਵਿਲੋਕਯਤ; ਤੈ ਰ੍ਨੋਪ੍ਯਤੇ ਨ ਕ੍ਰੁʼਤ੍ਯਤੇ ਭਾਣ੍ਡਾਗਾਰੇ ਨ ਸਞ੍ਚੀਯਤੇ(ਅ)ਪਿ; ਤਥਾਪਿ ਯੁਸ਼਼੍ਮਾਕੰ ਸ੍ਵਰ੍ਗਸ੍ਥਃ ਪਿਤਾ ਤੇਭ੍ਯ ਆਹਾਰੰ ਵਿਤਰਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","ਯੂਯੰ ਤੇਭ੍ਯਃ ਕਿੰ ਸ਼੍ਰੇਸ਼਼੍ਠਾ ਨ ਭਵਥ? ਯੁਸ਼਼੍ਮਾਕੰ ਕਸ਼੍ਚਿਤ੍ ਮਨੁਜਃ ਚਿਨ੍ਤਯਨ੍ ਨਿਜਾਯੁਸ਼਼ਃ ਕ੍ਸ਼਼ਣਮਪਿ ਵਰ੍ੱਧਯਿਤੁੰ ਸ਼ਕ੍ਨੋਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","ਅਪਰੰ ਵਸਨਾਯ ਕੁਤਸ਼੍ਚਿਨ੍ਤਯਤ? ਕ੍ਸ਼਼ੇਤ੍ਰੋਤ੍ਪੰਨਾਨਿ ਪੁਸ਼਼੍ਪਾਣਿ ਕਥੰ ਵਰ੍ੱਧਨ੍ਤੇ ਤਦਾਲੋਚਯਤ| ਤਾਨਿ ਤਨ੍ਤੂਨ੍ ਨੋਤ੍ਪਾਦਯਨ੍ਤਿ ਕਿਮਪਿ ਕਾਰ੍ੱਯੰ ਨ ਕੁਰ੍ੱਵਨ੍ਤਿ; ");
INSERT INTO sanpun_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ਤਥਾਪ੍ਯਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਵਦਾਮਿ, ਸੁਲੇਮਾਨ੍ ਤਾਦ੍ਰੁʼਗ੍ ਐਸ਼੍ਵਰ੍ੱਯਵਾਨਪਿ ਤਤ੍ਪੁਸ਼਼੍ਪਮਿਵ ਵਿਭੂਸ਼਼ਿਤੋ ਨਾਸੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ਤਸ੍ਮਾਤ੍ ਕ੍ਸ਼਼ਦ੍ਯ ਵਿਦ੍ਯਮਾਨੰ ਸ਼੍ਚਃ ਚੁੱਲ੍ਯਾਂ ਨਿਕ੍ਸ਼਼ੇਪ੍ਸ੍ਯਤੇ ਤਾਦ੍ਰੁʼਸ਼ੰ ਯਤ੍ ਕ੍ਸ਼਼ੇਤ੍ਰਸ੍ਥਿਤੰ ਕੁਸੁਮੰ ਤਤ੍ ਯਦੀਸ਼੍ਚਰ ਇੱਥੰ ਬਿਭੂਸ਼਼ਯਤਿ, ਤਰ੍ਹਿ ਹੇ ਸ੍ਤੋਕਪ੍ਰਤ੍ਯਯਿਨੋ ਯੁਸ਼਼੍ਮਾਨ੍ ਕਿੰ ਨ ਪਰਿਧਾਪਯਿਸ਼਼੍ਯਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","ਤਸ੍ਮਾਤ੍ ਅਸ੍ਮਾਭਿਃ ਕਿਮਤ੍ਸ੍ਯਤੇ? ਕਿਞ੍ਚ ਪਾਯਿਸ਼਼੍ਯਤੇ? ਕਿੰ ਵਾ ਪਰਿਧਾਯਿਸ਼਼੍ਯਤੇ, ਇਤਿ ਨ ਚਿਨ੍ਤਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ਯਸ੍ਮਾਤ੍ ਦੇਵਾਰ੍ੱਚਕਾ ਅਪੀਤਿ ਚੇਸ਼਼੍ਟਨ੍ਤੇ; ਏਤੇਸ਼਼ੁ ਦ੍ਰਵ੍ਯੇਸ਼਼ੁ ਪ੍ਰਯੋਜਨਮਸ੍ਤੀਤਿ ਯੁਸ਼਼੍ਮਾਕੰ ਸ੍ਵਰ੍ਗਸ੍ਥਃ ਪਿਤਾ ਜਾਨਾਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ਅਤਏਵ ਪ੍ਰਥਮਤ ਈਸ਼੍ਵਰੀਯਰਾਜ੍ਯੰ ਧਰ੍ੰਮਞ੍ਚ ਚੇਸ਼਼੍ਟਧ੍ਵੰ, ਤਤ ਏਤਾਨਿ ਵਸ੍ਤੂਨਿ ਯੁਸ਼਼੍ਮਭ੍ਯੰ ਪ੍ਰਦਾਯਿਸ਼਼੍ਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","ਸ਼੍ਵਃ ਕ੍ਰੁʼਤੇ ਮਾ ਚਿਨ੍ਤਯਤ, ਸ਼੍ਵਏਵ ਸ੍ਵਯੰ ਸ੍ਵਮੁੱਦਿਸ਼੍ਯ ਚਿਨ੍ਤਯਿਸ਼਼੍ਯਤਿ; ਅਦ੍ਯਤਨੀ ਯਾ ਚਿਨ੍ਤਾ ਸਾਦ੍ਯਕ੍ਰੁʼਤੇ ਪ੍ਰਚੁਰਤਰਾ| ");
INSERT INTO sanpun_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","ਯਥਾ ਯੂਯੰ ਦੋਸ਼਼ੀਕ੍ਰੁʼਤਾ ਨ ਭਵਥ, ਤਤ੍ਕ੍ਰੁʼਤੇ(ਅ)ਨ੍ਯੰ ਦੋਸ਼਼ਿਣੰ ਮਾ ਕੁਰੁਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ਯਤੋ ਯਾਦ੍ਰੁʼਸ਼ੇਨ ਦੋਸ਼਼ੇਣ ਯੂਯੰ ਪਰਾਨ੍ ਦੋਸ਼਼ਿਣਃ ਕੁਰੁਥ, ਤਾਦ੍ਰੁʼਸ਼ੇਨ ਦੋਸ਼਼ੇਣ ਯੂਯਮਪਿ ਦੋਸ਼਼ੀਕ੍ਰੁʼਤਾ ਭਵਿਸ਼਼੍ਯਥ, ਅਨ੍ਯਞ੍ਚ ਯੇਨ ਪਰਿਮਾਣੇਨ ਯੁਸ਼਼੍ਮਾਭਿਃ ਪਰਿਮੀਯਤੇ, ਤੇਨੈਵ ਪਰਿਮਾਣੇਨ ਯੁਸ਼਼੍ਮਤ੍ਕ੍ਰੁʼਤੇ ਪਰਿਮਾਯਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","ਅਪਰਞ੍ਚ ਨਿਜਨਯਨੇ ਯਾ ਨਾਸਾ ਵਿਦ੍ਯਤੇ, ਤਾਮ੍ ਅਨਾਲੋਚ੍ਯ ਤਵ ਸਹਜਸ੍ਯ ਲੋਚਨੇ ਯਤ੍ ਤ੍ਰੁʼਣਮ੍ ਆਸ੍ਤੇ, ਤਦੇਵ ਕੁਤੋ ਵੀਕ੍ਸ਼਼ਸੇ? ");
INSERT INTO sanpun_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","ਤਵ ਨਿਜਲੋਚਨੇ ਨਾਸਾਯਾਂ ਵਿਦ੍ਯਮਾਨਾਯਾਂ, ਹੇ ਭ੍ਰਾਤਃ, ਤਵ ਨਯਨਾਤ੍ ਤ੍ਰੁʼਣੰ ਬਹਿਸ਼਼੍ਯਰ੍ਤੁੰ ਅਨੁਜਾਨੀਹਿ, ਕਥਾਮੇਤਾਂ ਨਿਜਸਹਜਾਯ ਕਥੰ ਕਥਯਿਤੁੰ ਸ਼ਕ੍ਨੋਸ਼਼ਿ? ");
INSERT INTO sanpun_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ਹੇ ਕਪਟਿਨ੍, ਆਦੌ ਨਿਜਨਯਨਾਤ੍ ਨਾਸਾਂ ਬਹਿਸ਼਼੍ਕੁਰੁ ਤਤੋ ਨਿਜਦ੍ਰੁʼਸ਼਼੍ਟੌ ਸੁਪ੍ਰਸੰਨਾਯਾਂ ਤਵ ਭ੍ਰਾਤ੍ਰੁʼ ਰ੍ਲੋਚਨਾਤ੍ ਤ੍ਰੁʼਣੰ ਬਹਿਸ਼਼੍ਕਰ੍ਤੁੰ ਸ਼ਕ੍ਸ਼਼੍ਯਸਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","ਅਨ੍ਯਞ੍ਚ ਸਾਰਮੇਯੇਭ੍ਯਃ ਪਵਿਤ੍ਰਵਸ੍ਤੂਨਿ ਮਾ ਵਿਤਰਤ, ਵਰਾਹਾਣਾਂ ਸਮਕ੍ਸ਼਼ਞ੍ਚ ਮੁਕ੍ਤਾ ਮਾ ਨਿਕ੍ਸ਼਼ਿਪਤ; ਨਿਕ੍ਸ਼਼ੇਪਣਾਤ੍ ਤੇ ਤਾਃ ਸਰ੍ੱਵਾਃ ਪਦੈ ਰ੍ਦਲਯਿਸ਼਼੍ਯਨ੍ਤਿ, ਪਰਾਵ੍ਰੁʼਤ੍ਯ ਯੁਸ਼਼੍ਮਾਨਪਿ ਵਿਦਾਰਯਿਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","ਯਾਚਧ੍ਵੰ ਤਤੋ ਯੁਸ਼਼੍ਮਭ੍ਯੰ ਦਾਯਿਸ਼਼੍ਯਤੇ; ਮ੍ਰੁʼਗਯਧ੍ਵੰ ਤਤ ਉੱਦੇਸ਼ੰ ਲਪ੍ਸ੍ਯਧ੍ਵੇ; ਦ੍ਵਾਰਮ੍ ਆਹਤ, ਤਤੋ ਯੁਸ਼਼੍ਮਤ੍ਕ੍ਰੁʼਤੇ ਮੁਕ੍ਤੰ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ਯਸ੍ਮਾਦ੍ ਯੇਨ ਯਾਚ੍ਯਤੇ, ਤੇਨ ਲਭ੍ਯਤੇ; ਯੇਨ ਮ੍ਰੁʼਗ੍ਯਤੇ ਤੇਨੋੱਦੇਸ਼ਃ ਪ੍ਰਾਪ੍ਯਤੇ; ਯੇਨ ਚ ਦ੍ਵਾਰਮ੍ ਆਹਨ੍ਯਤੇ, ਤਤ੍ਕ੍ਰੁʼਤੇ ਦ੍ਵਾਰੰ ਮੋਚ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","ਆਤ੍ਮਜੇਨ ਪੂਪੇ ਪ੍ਰਾਰ੍ਥਿਤੇ ਤਸ੍ਮੈ ਪਾਸ਼਼ਾਣੰ ਵਿਸ਼੍ਰਾਣਯਤਿ, ");
INSERT INTO sanpun_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","ਮੀਨੇ ਯਾਚਿਤੇ ਚ ਤਸ੍ਮੈ ਭੁਜਗੰ ਵਿਤਰਤਿ, ਏਤਾਦ੍ਰੁʼਸ਼ਃ ਪਿਤਾ ਯੁਸ਼਼੍ਮਾਕੰ ਮਧ੍ਯੇ ਕ ਆਸ੍ਤੇ? ");
INSERT INTO sanpun_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","ਤਸ੍ਮਾਦ੍ ਯੂਯਮ੍ ਅਭਦ੍ਰਾਃ ਸਨ੍ਤੋ(ਅ)ਪਿ ਯਦਿ ਨਿਜਬਾਲਕੇਭ੍ਯ ਉੱਤਮੰ ਦ੍ਰਵ੍ਯੰ ਦਾਤੁੰ ਜਾਨੀਥ, ਤਰ੍ਹਿ ਯੁਸ਼਼੍ਮਾਕੰ ਸ੍ਵਰ੍ਗਸ੍ਥਃ ਪਿਤਾ ਸ੍ਵੀਯਯਾਚਕੇਭ੍ਯਃ ਕਿਮੁੱਤਮਾਨਿ ਵਸ੍ਤੂਨਿ ਨ ਦਾਸ੍ਯਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","ਯੂਸ਼਼੍ਮਾਨ੍ ਪ੍ਰਤੀਤਰੇਸ਼਼ਾਂ ਯਾਦ੍ਰੁʼਸ਼ੋ ਵ੍ਯਵਹਾਰੋ ਯੁਸ਼਼੍ਮਾਕੰ ਪ੍ਰਿਯਃ, ਯੂਯੰ ਤਾਨ੍ ਪ੍ਰਤਿ ਤਾਦ੍ਰੁʼਸ਼ਾਨੇਵ ਵ੍ਯਵਹਾਰਾਨ੍ ਵਿਧੱਤ; ਯਸ੍ਮਾਦ੍ ਵ੍ਯਵਸ੍ਥਾਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਾਂ ਵਚਨਾਨਾਮ੍ ਇਤਿ ਸਾਰਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","ਸਙ੍ਕੀਰ੍ਣਦ੍ਵਾਰੇਣ ਪ੍ਰਵਿਸ਼ਤ; ਯਤੋ ਨਰਕਗਮਨਾਯ ਯਦ੍ ਦ੍ਵਾਰੰ ਤਦ੍ ਵਿਸ੍ਤੀਰ੍ਣੰ ਯੱਚ ਵਰ੍ਤ੍ਮ ਤਦ੍ ਬ੍ਰੁʼਹਤ੍ ਤੇਨ ਬਹਵਃ ਪ੍ਰਵਿਸ਼ਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","ਅਪਰੰ ਸ੍ਵਰ੍ਗਗਮਨਾਯ ਯਦ੍ ਦ੍ਵਾਰੰ ਤਤ੍ ਕੀਦ੍ਰੁʼਕ੍ ਸੰਕੀਰ੍ਣੰ| ਯੱਚ ਵਰ੍ਤ੍ਮ ਤਤ੍ ਕੀਦ੍ਰੁʼਗ੍ ਦੁਰ੍ਗਮਮ੍| ਤਦੁੱਦੇਸ਼਼੍ਟਾਰਃ ਕਿਯਨ੍ਤੋ(ਅ)ਲ੍ਪਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","ਅਪਰਞ੍ਚ ਯੇ ਜਨਾ ਮੇਸ਼਼ਵੇਸ਼ੇਨ ਯੁਸ਼਼੍ਮਾਕੰ ਸਮੀਪਮ੍ ਆਗੱਛਨ੍ਤਿ, ਕਿਨ੍ਤ੍ਵਨ੍ਤਰ੍ਦੁਰਨ੍ਤਾ ਵ੍ਰੁʼਕਾ ਏਤਾਦ੍ਰੁʼਸ਼ੇਭ੍ਯੋ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਭ੍ਯਃ ਸਾਵਧਾਨਾ ਭਵਤ, ਯੂਯੰ ਫਲੇਨ ਤਾਨ੍ ਪਰਿਚੇਤੁੰ ਸ਼ਕ੍ਨੁਥ| ");
INSERT INTO sanpun_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","ਮਨੁਜਾਃ ਕਿੰ ਕਣ੍ਟਕਿਨੋ ਵ੍ਰੁʼਕ੍ਸ਼਼ਾਦ੍ ਦ੍ਰਾਕ੍ਸ਼਼ਾਫਲਾਨਿ ਸ਼੍ਰੁʼਗਾਲਕੋਲਿਤਸ਼੍ਚ ਉਡੁਮ੍ਬਰਫਲਾਨਿ ਸ਼ਾਤਯਨ੍ਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","ਤਦ੍ਵਦ੍ ਉੱਤਮ ਏਵ ਪਾਦਪ ਉੱਤਮਫਲਾਨਿ ਜਨਯਤਿ, ਅਧਮਪਾਦਪਏਵਾਧਮਫਲਾਨਿ ਜਨਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","ਕਿਨ੍ਤੂੱਤਮਪਾਦਪਃ ਕਦਾਪ੍ਯਧਮਫਲਾਨਿ ਜਨਯਿਤੁੰ ਨ ਸ਼ਕ੍ਨੋਤਿ, ਤਥਾਧਮੋਪਿ ਪਾਦਪ ਉੱਤਮਫਲਾਨਿ ਜਨਯਿਤੁੰ ਨ ਸ਼ਕ੍ਨੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","ਅਪਰੰ ਯੇ ਯੇ ਪਾਦਪਾ ਅਧਮਫਲਾਨਿ ਜਨਯਨ੍ਤਿ, ਤੇ ਕ੍ਰੁʼੱਤਾ ਵਹ੍ਨੌ ਕ੍ਸ਼਼ਿਪ੍ਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ਅਤਏਵ ਯੂਯੰ ਫਲੇਨ ਤਾਨ੍ ਪਰਿਚੇਸ਼਼੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","ਯੇ ਜਨਾ ਮਾਂ ਪ੍ਰਭੁੰ ਵਦਨ੍ਤਿ, ਤੇ ਸਰ੍ੱਵੇ ਸ੍ਵਰ੍ਗਰਾਜ੍ਯੰ ਪ੍ਰਵੇਕ੍ਸ਼਼੍ਯਨ੍ਤਿ ਤੰਨ, ਕਿਨ੍ਤੁ ਯੋ ਮਾਨਵੋ ਮਮ ਸ੍ਵਰ੍ਗਸ੍ਥਸ੍ਯ ਪਿਤੁਰਿਸ਼਼੍ਟੰ ਕਰ੍ੰਮ ਕਰੋਤਿ ਸ ਏਵ ਪ੍ਰਵੇਕ੍ਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","ਤਦ੍ ਦਿਨੇ ਬਹਵੋ ਮਾਂ ਵਦਿਸ਼਼੍ਯਨ੍ਤਿ, ਹੇ ਪ੍ਰਭੋ ਹੇ ਪ੍ਰਭੋ, ਤਵ ਨਾਮ੍ਨਾ ਕਿਮਸ੍ਮਾਮਿ ਰ੍ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਕ੍ਯੰ ਨ ਵ੍ਯਾਹ੍ਰੁʼਤੰ? ਤਵ ਨਾਮ੍ਨਾ ਭੂਤਾਃ ਕਿੰ ਨ ਤ੍ਯਾਜਿਤਾਃ? ਤਵ ਨਾਮ੍ਨਾ ਕਿੰ ਨਾਨਾਦ੍ਭੁਤਾਨਿ ਕਰ੍ੰਮਾਣਿ ਨ ਕ੍ਰੁʼਤਾਨਿ? ");
INSERT INTO sanpun_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","ਤਦਾਹੰ ਵਦਿਸ਼਼੍ਯਾਮਿ, ਹੇ ਕੁਕਰ੍ੰਮਕਾਰਿਣੋ ਯੁਸ਼਼੍ਮਾਨ੍ ਅਹੰ ਨ ਵੇਦ੍ਮਿ, ਯੂਯੰ ਮਤ੍ਸਮੀਪਾਦ੍ ਦੂਰੀਭਵਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","ਯਃ ਕਸ਼੍ਚਿਤ੍ ਮਮੈਤਾਃ ਕਥਾਃ ਸ਼੍ਰੁਤ੍ਵਾ ਪਾਲਯਤਿ, ਸ ਪਾਸ਼਼ਾਣੋਪਰਿ ਗ੍ਰੁʼਹਨਿਰ੍ੰਮਾਤ੍ਰਾ ਜ੍ਞਾਨਿਨਾ ਸਹ ਮਯੋਪਮੀਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","ਯਤੋ ਵ੍ਰੁʼਸ਼਼੍ਟੌ ਸਤ੍ਯਾਮ੍ ਆਪ੍ਲਾਵ ਆਗਤੇ ਵਾਯੌ ਵਾਤੇ ਚ ਤੇਸ਼਼ੁ ਤਦ੍ਗੇਹੰ ਲਗ੍ਨੇਸ਼਼ੁ ਪਾਸ਼਼ਾਣੋਪਰਿ ਤਸ੍ਯ ਭਿੱਤੇਸ੍ਤੰਨ ਪਤਤਿl ");
INSERT INTO sanpun_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","ਕਿਨ੍ਤੁ ਯਃ ਕਸ਼੍ਚਿਤ੍ ਮਮੈਤਾਃ ਕਥਾਃ ਸ਼੍ਰੁਤ੍ਵਾ ਨ ਪਾਲਯਤਿ ਸ ਸੈਕਤੇ ਗੇਹਨਿਰ੍ੰਮਾਤ੍ਰਾ (ਅ)ਜ੍ਞਾਨਿਨਾ ਉਪਮੀਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","ਯਤੋ ਜਲਵ੍ਰੁʼਸ਼਼੍ਟੌ ਸਤ੍ਯਾਮ੍ ਆਪ੍ਲਾਵ ਆਗਤੇ ਪਵਨੇ ਵਾਤੇ ਚ ਤੈ ਰ੍ਗ੍ਰੁʼਹੇ ਸਮਾਘਾਤੇ ਤਤ੍ ਪਤਤਿ ਤਤ੍ਪਤਨੰ ਮਹਦ੍ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","ਯੀਸ਼ੁਨੈਤੇਸ਼਼ੁ ਵਾਕ੍ਯੇਸ਼਼ੁ ਸਮਾਪਿਤੇਸ਼਼ੁ ਮਾਨਵਾਸ੍ਤਦੀਯੋਪਦੇਸ਼ਮ੍ ਆਸ਼੍ਚਰ੍ੱਯੰ ਮੇਨਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ਯਸ੍ਮਾਤ੍ ਸ ਉਪਾਧ੍ਯਾਯਾ ਇਵ ਤਾਨ੍ ਨੋਪਦਿਦੇਸ਼ ਕਿਨ੍ਤੁ ਸਮਰ੍ਥਪੁਰੁਸ਼਼ਇਵ ਸਮੁਪਦਿਦੇਸ਼| ");
INSERT INTO sanpun_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","ਯਦਾ ਸ ਪਰ੍ੱਵਤਾਦ੍ ਅਵਾਰੋਹਤ੍ ਤਦਾ ਬਹਵੋ ਮਾਨਵਾਸ੍ਤਤ੍ਪਸ਼੍ਚਾਦ੍ ਵਵ੍ਰਜੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ਏਕਃ ਕੁਸ਼਼੍ਠਵਾਨ੍ ਆਗਤ੍ਯ ਤੰ ਪ੍ਰਣਮ੍ਯ ਬਭਾਸ਼਼ੇ, ਹੇ ਪ੍ਰਭੋ, ਯਦਿ ਭਵਾਨ੍ ਸੰਮਨ੍ਯਤੇ, ਤਰ੍ਹਿ ਮਾਂ ਨਿਰਾਮਯੰ ਕਰ੍ੱਤੁੰ ਸ਼ਕ੍ਨੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ਤਤੋ ਯੀਸ਼ੁਃ ਕਰੰ ਪ੍ਰਸਾਰ੍ੱਯ ਤਸ੍ਯਾਙ੍ਗੰ ਸ੍ਪ੍ਰੁʼਸ਼ਨ੍ ਵ੍ਯਾਜਹਾਰ, ਸੰਮਨ੍ਯੇ(ਅ)ਹੰ ਤ੍ਵੰ ਨਿਰਾਮਯੋ ਭਵ; ਤੇਨ ਸ ਤਤ੍ਕ੍ਸ਼਼ਣਾਤ੍ ਕੁਸ਼਼੍ਠੇਨਾਮੋਚਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ਤਤੋ ਯੀਸ਼ੁਸ੍ਤੰ ਜਗਾਦ, ਅਵਧੇਹਿ ਕਥਾਮੇਤਾਂ ਕਸ਼੍ਚਿਦਪਿ ਮਾ ਬ੍ਰੂਹਿ, ਕਿਨ੍ਤੁ ਯਾਜਕਸ੍ਯ ਸੰਨਿਧਿੰ ਗਤ੍ਵਾ ਸ੍ਵਾਤ੍ਮਾਨੰ ਦਰ੍ਸ਼ਯ ਮਨੁਜੇਭ੍ਯੋ ਨਿਜਨਿਰਾਮਯਤ੍ਵੰ ਪ੍ਰਮਾਣਯਿਤੁੰ ਮੂਸਾਨਿਰੂਪਿਤੰ ਦ੍ਰਵ੍ਯਮ੍ ਉਤ੍ਸ੍ਰੁʼਜ ਚ| ");
INSERT INTO sanpun_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","ਤਦਨਨ੍ਤਰੰ ਯੀਸ਼ੁਨਾ ਕਫਰ੍ਨਾਹੂਮ੍ਨਾਮਨਿ ਨਗਰੇ ਪ੍ਰਵਿਸ਼਼੍ਟੇ ਕਸ਼੍ਚਿਤ੍ ਸ਼ਤਸੇਨਾਪਤਿਸ੍ਤਤ੍ਸਮੀਪਮ੍ ਆਗਤ੍ਯ ਵਿਨੀਯ ਬਭਾਸ਼਼ੇ, ");
INSERT INTO sanpun_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ਹੇ ਪ੍ਰਭੋ, ਮਦੀਯ ਏਕੋ ਦਾਸਃ ਪਕ੍ਸ਼਼ਾਘਾਤਵ੍ਯਾਧਿਨਾ ਭ੍ਰੁʼਸ਼ੰ ਵ੍ਯਥਿਤਃ, ਸਤੁ ਸ਼ਯਨੀਯ ਆਸ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ਤਦਾਨੀਂ ਯੀਸ਼ੁਸ੍ਤਸ੍ਮੈ ਕਥਿਤਵਾਨ੍, ਅਹੰ ਗਤ੍ਵਾ ਤੰ ਨਿਰਾਮਯੰ ਕਰਿਸ਼਼੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ਤਤਃ ਸ ਸ਼ਤਸੇਨਾਪਤਿਃ ਪ੍ਰਤ੍ਯਵਦਤ੍, ਹੇ ਪ੍ਰਭੋ, ਭਵਾਨ੍ ਯਤ੍ ਮਮ ਗੇਹਮਧ੍ਯੰ ਯਾਤਿ ਤਦ੍ਯੋਗ੍ਯਭਾਜਨੰ ਨਾਹਮਸ੍ਮਿ; ਵਾਙ੍ਮਾਤ੍ਰਮ੍ ਆਦਿਸ਼ਤੁ, ਤੇਨੈਵ ਮਮ ਦਾਸੋ ਨਿਰਾਮਯੋ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","ਯਤੋ ਮਯਿ ਪਰਨਿਧ੍ਨੇ(ਅ)ਪਿ ਮਮ ਨਿਦੇਸ਼ਵਸ਼੍ਯਾਃ ਕਤਿ ਕਤਿ ਸੇਨਾਃ ਸਨ੍ਤਿ, ਤਤ ਏਕਸ੍ਮਿਨ੍ ਯਾਹੀਤ੍ਯੁਕ੍ਤੇ ਸ ਯਾਤਿ, ਤਦਨ੍ਯਸ੍ਮਿਨ੍ ਏਹੀਤ੍ਯੁਕ੍ਤੇ ਸ ਆਯਾਤਿ, ਤਥਾ ਮਮ ਨਿਜਦਾਸੇ ਕਰ੍ੰਮੈਤਤ੍ ਕੁਰ੍ੱਵਿਤ੍ਯੁਕ੍ਤੇ ਸ ਤਤ੍ ਕਰੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ਤਦਾਨੀਂ ਯੀਸ਼ੁਸ੍ਤਸ੍ਯੈਤਤ੍ ਵਚੋ ਨਿਸ਼ਮ੍ਯ ਵਿਸ੍ਮਯਾਪੰਨੋ(ਅ)ਭੂਤ੍; ਨਿਜਪਸ਼੍ਚਾਦ੍ਗਾਮਿਨੋ ਮਾਨਵਾਨ੍ ਅਵੋੱਚ, ਯੁਸ਼਼੍ਮਾਨ੍ ਤਥ੍ਯੰ ਵਚ੍ਮਿ, ਇਸ੍ਰਾਯੇਲੀਯਲੋਕਾਨਾਂ ਮਧ੍ਯੇ(ਅ)ਪਿ ਨੈਤਾਦ੍ਰੁʼਸ਼ੋ ਵਿਸ਼੍ਵਾਸੋ ਮਯਾ ਪ੍ਰਾਪ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","ਅਨ੍ਯੱਚਾਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਵਦਾਮਿ, ਬਹਵਃ ਪੂਰ੍ੱਵਸ੍ਯਾਃ ਪਸ਼੍ਚਿਮਾਯਾਸ਼੍ਚ ਦਿਸ਼ ਆਗਤ੍ਯ ਇਬ੍ਰਾਹੀਮਾ ਇਸ੍ਹਾਕਾ ਯਾਕੂਬਾ ਚ ਸਾਕਮ੍ ਮਿਲਿਤ੍ਵਾ ਸਮੁਪਵੇਕ੍ਸ਼਼੍ਯਨ੍ਤਿ; ");
INSERT INTO sanpun_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ਕਿਨ੍ਤੁ ਯਤ੍ਰ ਸ੍ਥਾਨੇ ਰੋਦਨਦਨ੍ਤਘਰ੍ਸ਼਼ਣੇ ਭਵਤਸ੍ਤਸ੍ਮਿਨ੍ ਬਹਿਰ੍ਭੂਤਤਮਿਸ੍ਰੇ ਰਾਜ੍ਯਸ੍ਯ ਸਨ੍ਤਾਨਾ ਨਿਕ੍ਸ਼਼ੇਸ੍ਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ਤਤਃ ਪਰੰ ਯੀਸ਼ੁਸ੍ਤੰ ਸ਼ਤਸੇਨਾਪਤਿੰ ਜਗਾਦ, ਯਾਹਿ, ਤਵ ਪ੍ਰਤੀਤ੍ਯਨੁਸਾਰਤੋ ਮਙ੍ਗਲੰ ਭੂਯਾਤ੍; ਤਦਾ ਤਸ੍ਮਿੰਨੇਵ ਦਣ੍ਡੇ ਤਦੀਯਦਾਸੋ ਨਿਰਾਮਯੋ ਬਭੂਵ| ");
INSERT INTO sanpun_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ਅਨਨ੍ਤਰੰ ਯੀਸ਼ੁਃ ਪਿਤਰਸ੍ਯ ਗੇਹਮੁਪਸ੍ਥਾਯ ਜ੍ਵਰੇਣ ਪੀਡਿਤਾਂ ਸ਼ਯਨੀਯਸ੍ਥਿਤਾਂ ਤਸ੍ਯ ਸ਼੍ਵਸ਼੍ਰੂੰ ਵੀਕ੍ਸ਼਼ਾਞ੍ਚਕ੍ਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ਤਤਸ੍ਤੇਨ ਤਸ੍ਯਾਃ ਕਰਸ੍ਯ ਸ੍ਪ੍ਰੁʼਸ਼਼੍ਟਤਵਾਤ੍ ਜ੍ਵਰਸ੍ਤਾਂ ਤਤ੍ਯਾਜ, ਤਦਾ ਸਾ ਸਮੁੱਥਾਯ ਤਾਨ੍ ਸਿਸ਼਼ੇਵੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","ਅਨਨ੍ਤਰੰ ਸਨ੍ਧ੍ਯਾਯਾਂ ਸਤ੍ਯਾਂ ਬਹੁਸ਼ੋ ਭੂਤਗ੍ਰਸ੍ਤਮਨੁਜਾਨ੍ ਤਸ੍ਯ ਸਮੀਪਮ੍ ਆਨਿਨ੍ਯੁਃ ਸ ਚ ਵਾਕ੍ਯੇਨ ਭੂਤਾਨ੍ ਤ੍ਯਾਜਯਾਮਾਸ, ਸਰ੍ੱਵਪ੍ਰਕਾਰਪੀਡਿਤਜਨਾਂਸ਼੍ਚ ਨਿਰਾਮਯਾਨ੍ ਚਕਾਰ; ");
INSERT INTO sanpun_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ਤਸ੍ਮਾਤ੍, ਸਰ੍ੱਵਾ ਦੁਰ੍ੱਬਲਤਾਸ੍ਮਾਕੰ ਤੇਨੈਵ ਪਰਿਧਾਰਿਤਾ| ਅਸ੍ਮਾਕੰ ਸਕਲੰ ਵ੍ਯਾਧਿੰ ਸਏਵ ਸੰਗ੍ਰੁʼਹੀਤਵਾਨ੍| ਯਦੇਤਦ੍ਵਚਨੰ ਯਿਸ਼ਯਿਯਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨੋਕ੍ਤਮਾਸੀਤ੍, ਤੱਤਦਾ ਸਫਲਮਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","ਅਨਨ੍ਤਰੰ ਯੀਸ਼ੁਸ਼੍ਚਤੁਰ੍ਦਿਕ੍ਸ਼਼ੁ ਜਨਨਿਵਹੰ ਵਿਲੋਕ੍ਯ ਤਟਿਨ੍ਯਾਃ ਪਾਰੰ ਯਾਤੁੰ ਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਆਦਿਦੇਸ਼| ");
INSERT INTO sanpun_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ਤਦਾਨੀਮ੍ ਏਕ ਉਪਾਧ੍ਯਾਯ ਆਗਤ੍ਯ ਕਥਿਤਵਾਨ੍, ਹੇ ਗੁਰੋ, ਭਵਾਨ੍ ਯਤ੍ਰ ਯਾਸ੍ਯਤਿ ਤਤ੍ਰਾਹਮਪਿ ਭਵਤਃ ਪਸ਼੍ਚਾਦ੍ ਯਾਸ੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ਤਤੋ ਯੀਸ਼ੁ ਰ੍ਜਗਾਦ, ਕ੍ਰੋਸ਼਼੍ਟੁਃ ਸ੍ਥਾਤੁੰ ਸ੍ਥਾਨੰ ਵਿਦ੍ਯਤੇ, ਵਿਹਾਯਸੋ ਵਿਹਙ੍ਗਮਾਨਾਂ ਨੀਡਾਨਿ ਚ ਸਨ੍ਤਿ; ਕਿਨ੍ਤੁ ਮਨੁਸ਼਼੍ਯਪੁਤ੍ਰਸ੍ਯ ਸ਼ਿਰਃ ਸ੍ਥਾਪਯਿਤੁੰ ਸ੍ਥਾਨੰ ਨ ਵਿਦ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","ਅਨਨ੍ਤਰਮ੍ ਅਪਰ ਏਕਃ ਸ਼ਿਸ਼਼੍ਯਸ੍ਤੰ ਬਭਾਸ਼਼ੇ, ਹੇ ਪ੍ਰਭੋ, ਪ੍ਰਥਮਤੋ ਮਮ ਪਿਤਰੰ ਸ਼੍ਮਸ਼ਾਨੇ ਨਿਧਾਤੁੰ ਗਮਨਾਰ੍ਥੰ ਮਾਮ੍ ਅਨੁਮਨ੍ਯਸ੍ਵ| ");
INSERT INTO sanpun_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ਤਤੋ ਯੀਸ਼ੁਰੁਕ੍ਤਵਾਨ੍ ਮ੍ਰੁʼਤਾ ਮ੍ਰੁʼਤਾਨ੍ ਸ਼੍ਮਸ਼ਾਨੇ ਨਿਦਧਤੁ, ਤ੍ਵੰ ਮਮ ਪਸ਼੍ਚਾਦ੍ ਆਗੱਛ| ");
INSERT INTO sanpun_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","ਅਨਨ੍ਤਰੰ ਤਸ੍ਮਿਨ੍ ਨਾਵਮਾਰੂਢੇ ਤਸ੍ਯ ਸ਼ਿਸ਼਼੍ਯਾਸ੍ਤਤ੍ਪਸ਼੍ਚਾਤ੍ ਜਗ੍ਮੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ਪਸ਼੍ਚਾਤ੍ ਸਾਗਰਸ੍ਯ ਮਧ੍ਯੰ ਤੇਸ਼਼ੁ ਗਤੇਸ਼਼ੁ ਤਾਦ੍ਰੁʼਸ਼ਃ ਪ੍ਰਬਲੋ ਝਞ੍ਭ੍ਸ਼ਨਿਲ ਉਦਤਿਸ਼਼੍ਠਤ੍, ਯੇਨ ਮਹਾਤਰਙ੍ਗ ਉੱਥਾਯ ਤਰਣਿੰ ਛਾਦਿਤਵਾਨ੍, ਕਿਨ੍ਤੁ ਸ ਨਿਦ੍ਰਿਤ ਆਸੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ਤਦਾ ਸ਼ਿਸ਼਼੍ਯਾ ਆਗਤ੍ਯ ਤਸ੍ਯ ਨਿਦ੍ਰਾਭਙ੍ਗੰ ਕ੍ਰੁʼਤ੍ਵਾ ਕਥਯਾਮਾਸੁਃ, ਹੇ ਪ੍ਰਭੋ, ਵਯੰ ਮ੍ਰਿਯਾਮਹੇ, ਭਵਾਨ੍ ਅਸ੍ਮਾਕੰ ਪ੍ਰਾਣਾਨ੍ ਰਕ੍ਸ਼਼ਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ਤਦਾ ਸ ਤਾਨ੍ ਉਕ੍ਤਵਾਨ੍, ਹੇ ਅਲ੍ਪਵਿਸ਼੍ਵਾਸਿਨੋ ਯੂਯੰ ਕੁਤੋ ਵਿਭੀਥ? ਤਤਃ ਸ ਉੱਥਾਯ ਵਾਤੰ ਸਾਗਰਞ੍ਚ ਤਰ੍ਜਯਾਮਾਸ, ਤਤੋ ਨਿਰ੍ੱਵਾਤਮਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","ਅਪਰੰ ਮਨੁਜਾ ਵਿਸ੍ਮਯੰ ਵਿਲੋਕ੍ਯ ਕਥਯਾਮਾਸੁਃ, ਅਹੋ ਵਾਤਸਰਿਤ੍ਪਤੀ ਅਸ੍ਯ ਕਿਮਾਜ੍ਞਾਗ੍ਰਾਹਿਣੌ? ਕੀਦ੍ਰੁʼਸ਼ੋ(ਅ)ਯੰ ਮਾਨਵਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","ਅਨਨ੍ਤਰੰ ਸ ਪਾਰੰ ਗਤ੍ਵਾ ਗਿਦੇਰੀਯਦੇਸ਼ਮ੍ ਉਪਸ੍ਥਿਤਵਾਨ੍; ਤਦਾ ਦ੍ਵੌ ਭੂਤਗ੍ਰਸ੍ਤਮਨੁਜੌ ਸ਼੍ਮਸ਼ਾਨਸ੍ਥਾਨਾਦ੍ ਬਹਿ ਰ੍ਭੂਤ੍ਵਾ ਤੰ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਕ੍ਰੁʼਤਵਨ੍ਤੌ, ਤਾਵੇਤਾਦ੍ਰੁʼਸ਼ੌ ਪ੍ਰਚਣ੍ਡਾਵਾਸ੍ਤਾਂ ਯਤ੍ ਤੇਨ ਸ੍ਥਾਨੇਨ ਕੋਪਿ ਯਾਤੁੰ ਨਾਸ਼ਕ੍ਨੋਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ਤਾਵੁਚੈਃ ਕਥਯਾਮਾਸਤੁਃ, ਹੇ ਈਸ਼੍ਵਰਸ੍ਯ ਸੂਨੋ ਯੀਸ਼ੋ, ਤ੍ਵਯਾ ਸਾਕਮ੍ ਆਵਯੋਃ ਕਃ ਸਮ੍ਬਨ੍ਧਃ? ਨਿਰੂਪਿਤਕਾਲਾਤ੍ ਪ੍ਰਾਗੇਵ ਕਿਮਾਵਾਭ੍ਯਾਂ ਯਾਤਨਾਂ ਦਾਤੁਮ੍ ਅਤ੍ਰਾਗਤੋਸਿ? ");
INSERT INTO sanpun_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ਤਦਾਨੀਂ ਤਾਭ੍ਯਾਂ ਕਿਞ੍ਚਿਦ੍ ਦੂਰੇ ਵਰਾਹਾਣਾਮ੍ ਏਕੋ ਮਹਾਵ੍ਰਜੋ(ਅ)ਚਰਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ਤਤੋ ਭੂਤੌ ਤੌ ਤਸ੍ਯਾਨ੍ਤਿਕੇ ਵਿਨੀਯ ਕਥਯਾਮਾਸਤੁਃ, ਯਦ੍ਯਾਵਾਂ ਤ੍ਯਾਜਯਸਿ, ਤਰ੍ਹਿ ਵਰਾਹਾਣਾਂ ਮਧ੍ਯੇਵ੍ਰਜਮ੍ ਆਵਾਂ ਪ੍ਰੇਰਯ| ");
INSERT INTO sanpun_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ਤਦਾ ਯੀਸ਼ੁਰਵਦਤ੍ ਯਾਤੰ, ਅਨਨ੍ਤਰੰ ਤੌ ਯਦਾ ਮਨੁਜੌ ਵਿਹਾਯ ਵਰਾਹਾਨ੍ ਆਸ਼੍ਰਿਤਵਨ੍ਤੌ, ਤਦਾ ਤੇ ਸਰ੍ੱਵੇ ਵਰਾਹਾ ਉੱਚਸ੍ਥਾਨਾਤ੍ ਮਹਾਜਵੇਨ ਧਾਵਨ੍ਤਃ ਸਾਗਰੀਯਤੋਯੇ ਮੱਜਨ੍ਤੋ ਮਮ੍ਰੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ਤਤੋ ਵਰਾਹਰਕ੍ਸ਼਼ਕਾਃ ਪਲਾਯਮਾਨਾ ਮਧ੍ਯੇਨਗਰੰ ਤੌ ਭੂਤਗ੍ਰਸ੍ਤੌ ਪ੍ਰਤਿ ਯਦ੍ਯਦ੍ ਅਘਟਤ, ਤਾਃ ਸਰ੍ੱਵਵਾਰ੍ੱਤਾ ਅਵਦਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ਤਤੋ ਨਾਗਰਿਕਾਃ ਸਰ੍ੱਵੇ ਮਨੁਜਾ ਯੀਸ਼ੁੰ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਕਰ੍ੱਤੁੰ ਬਹਿਰਾਯਾਤਾਃ ਤਞ੍ਚ ਵਿਲੋਕ੍ਯ ਪ੍ਰਾਰ੍ਥਯਾਞ੍ਚਕ੍ਰਿਰੇ ਭਵਾਨ੍ ਅਸ੍ਮਾਕੰ ਸੀਮਾਤੋ ਯਾਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ਅਨਨ੍ਤਰੰ ਯੀਸ਼ੁ ਰ੍ਨੌਕਾਮਾਰੁਹ੍ਯ ਪੁਨਃ ਪਾਰਮਾਗਤ੍ਯ ਨਿਜਗ੍ਰਾਮਮ੍ ਆਯਯੌ| ");
INSERT INTO sanpun_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ਤਤਃ ਕਤਿਪਯਾ ਜਨਾ ਏਕੰ ਪਕ੍ਸ਼਼ਾਘਾਤਿਨੰ ਸ੍ਵੱਟੋਪਰਿ ਸ਼ਾਯਯਿਤ੍ਵਾ ਤਤ੍ਸਮੀਪਮ੍ ਆਨਯਨ੍; ਤਤੋ ਯੀਸ਼ੁਸ੍ਤੇਸ਼਼ਾਂ ਪ੍ਰਤੀਤਿੰ ਵਿਜ੍ਞਾਯ ਤੰ ਪਕ੍ਸ਼਼ਾਘਾਤਿਨੰ ਜਗਾਦ, ਹੇ ਪੁਤ੍ਰ, ਸੁਸ੍ਥਿਰੋ ਭਵ, ਤਵ ਕਲੁਸ਼਼ਸ੍ਯ ਮਰ੍ਸ਼਼ਣੰ ਜਾਤਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ਤਾਂ ਕਥਾਂ ਨਿਸ਼ਮ੍ਯ ਕਿਯਨ੍ਤ ਉਪਾਧ੍ਯਾਯਾ ਮਨਃਸੁ ਚਿਨ੍ਤਿਤਵਨ੍ਤ ਏਸ਼਼ ਮਨੁਜ ਈਸ਼੍ਵਰੰ ਨਿਨ੍ਦਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ਤਤਃ ਸ ਤੇਸ਼਼ਾਮ੍ ਏਤਾਦ੍ਰੁʼਸ਼ੀਂ ਚਿਨ੍ਤਾਂ ਵਿਜ੍ਞਾਯ ਕਥਿਤਵਾਨ੍, ਯੂਯੰ ਮਨਃਸੁ ਕ੍ਰੁʼਤ ਏਤਾਦ੍ਰੁʼਸ਼ੀਂ ਕੁਚਿਨ੍ਤਾਂ ਕੁਰੁਥ? ");
INSERT INTO sanpun_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","ਤਵ ਪਾਪਮਰ੍ਸ਼਼ਣੰ ਜਾਤੰ, ਯਦ੍ਵਾ ਤ੍ਵਮੁੱਥਾਯ ਗੱਛ, ਦ੍ਵਯੋਰਨਯੋ ਰ੍ਵਾਕ੍ਯਯੋਃ ਕਿੰ ਵਾਕ੍ਯੰ ਵਕ੍ਤੁੰ ਸੁਗਮੰ? ");
INSERT INTO sanpun_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","ਕਿਨ੍ਤੁ ਮੇਦਿਨ੍ਯਾਂ ਕਲੁਸ਼਼ੰ ਕ੍ਸ਼਼ਮਿਤੁੰ ਮਨੁਜਸੁਤਸ੍ਯ ਸਾਮਰ੍ਥ੍ਯਮਸ੍ਤੀਤਿ ਯੂਯੰ ਯਥਾ ਜਾਨੀਥ, ਤਦਰ੍ਥੰ ਸ ਤੰ ਪਕ੍ਸ਼਼ਾਘਾਤਿਨੰ ਗਦਿਤਵਾਨ੍, ਉੱਤਿਸ਼਼੍ਠ, ਨਿਜਸ਼ਯਨੀਯੰ ਆਦਾਯ ਗੇਹੰ ਗੱਛ| ");
INSERT INTO sanpun_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ਤਤਃ ਸ ਤਤ੍ਕ੍ਸ਼਼ਣਾਦ੍ ਉੱਥਾਯ ਨਿਜਗੇਹੰ ਪ੍ਰਸ੍ਥਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ਮਾਨਵਾ ਇੱਥੰ ਵਿਲੋਕ੍ਯ ਵਿਸ੍ਮਯੰ ਮੇਨਿਰੇ, ਈਸ਼੍ਵਰੇਣ ਮਾਨਵਾਯ ਸਾਮਰ੍ਥ੍ਯਮ੍ ਈਦ੍ਰੁʼਸ਼ੰ ਦੱਤੰ ਇਤਿ ਕਾਰਣਾਤ੍ ਤੰ ਧਨ੍ਯੰ ਬਭਾਸ਼਼ਿਰੇ ਚ| ");
INSERT INTO sanpun_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ਅਨਨ੍ਤਰੰ ਯੀਸ਼ੁਸ੍ਤਤ੍ਸ੍ਥਾਨਾਦ੍ ਗੱਛਨ੍ ਗੱਛਨ੍ ਕਰਸੰਗ੍ਰਹਸ੍ਥਾਨੇ ਸਮੁਪਵਿਸ਼਼੍ਟੰ ਮਥਿਨਾਮਾਨਮ੍ ਏਕੰ ਮਨੁਜੰ ਵਿਲੋਕ੍ਯ ਤੰ ਬਭਾਸ਼਼ੇ, ਮਮ ਪਸ਼੍ਚਾਦ੍ ਆਗੱਛ, ਤਤਃ ਸ ਉੱਥਾਯ ਤਸ੍ਯ ਪਸ਼੍ਚਾਦ੍ ਵਵ੍ਰਾਜ| ");
INSERT INTO sanpun_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ਤਤਃ ਪਰੰ ਯੀਸ਼ੌ ਗ੍ਰੁʼਹੇ ਭੋਕ੍ਤੁਮ੍ ਉਪਵਿਸ਼਼੍ਟੇ ਬਹਵਃ ਕਰਸੰਗ੍ਰਾਹਿਣਃ ਕਲੁਸ਼਼ਿਣਸ਼੍ਚ ਮਾਨਵਾ ਆਗਤ੍ਯ ਤੇਨ ਸਾਕੰ ਤਸ੍ਯ ਸ਼ਿਸ਼਼੍ਯੈਸ਼੍ਚ ਸਾਕਮ੍ ਉਪਵਿਵਿਸ਼ੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ਫਿਰੂਸ਼ਿਨਸ੍ਤਦ੍ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਤਸ੍ਯ ਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਬਭਾਸ਼਼ਿਰੇ, ਯੁਸ਼਼੍ਮਾਕੰ ਗੁਰੁਃ ਕਿੰ ਨਿਮਿੱਤੰ ਕਰਸੰਗ੍ਰਾਹਿਭਿਃ ਕਲੁਸ਼਼ਿਭਿਸ਼੍ਚ ਸਾਕੰ ਭੁੰਕ੍ਤੇ? ");
INSERT INTO sanpun_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ਯੀਸ਼ੁਸ੍ਤਤ੍ ਸ਼੍ਰੁਤ੍ਵਾ ਤਾਨ੍ ਪ੍ਰਤ੍ਯਵਦਤ੍, ਨਿਰਾਮਯਲੋਕਾਨਾਂ ਚਿਕਿਤ੍ਸਕੇਨ ਪ੍ਰਯੋਜਨੰ ਨਾਸ੍ਤਿ, ਕਿਨ੍ਤੁ ਸਾਮਯਲੋਕਾਨਾਂ ਪ੍ਰਯੋਜਨਮਾਸ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","ਅਤੋ ਯੂਯੰ ਯਾਤ੍ਵਾ ਵਚਨਸ੍ਯਾਸ੍ਯਾਰ੍ਥੰ ਸ਼ਿਕ੍ਸ਼਼ਧ੍ਵਮ੍, ਦਯਾਯਾਂ ਮੇ ਯਥਾ ਪ੍ਰੀਤਿ ਰ੍ਨ ਤਥਾ ਯਜ੍ਞਕਰ੍ੰਮਣਿ| ਯਤੋ(ਅ)ਹੰ ਧਾਰ੍ੰਮਿਕਾਨ੍ ਆਹ੍ਵਾਤੁੰ ਨਾਗਤੋ(ਅ)ਸ੍ਮਿ ਕਿਨ੍ਤੁ ਮਨਃ ਪਰਿਵਰ੍ੱਤਯਿਤੁੰ ਪਾਪਿਨ ਆਹ੍ਵਾਤੁਮ੍ ਆਗਤੋ(ਅ)ਸ੍ਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","ਅਨਨ੍ਤਰੰ ਯੋਹਨਃ ਸ਼ਿਸ਼਼੍ਯਾਸ੍ਤਸ੍ਯ ਸਮੀਪਮ੍ ਆਗਤ੍ਯ ਕਥਯਾਮਾਸੁਃ, ਫਿਰੂਸ਼ਿਨੋ ਵਯਞ੍ਚ ਪੁਨਃ ਪੁਨਰੁਪਵਸਾਮਃ, ਕਿਨ੍ਤੁ ਤਵ ਸ਼ਿਸ਼਼੍ਯਾ ਨੋਪਵਸਨ੍ਤਿ, ਕੁਤਃ? ");
INSERT INTO sanpun_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ਤਦਾ ਯੀਸ਼ੁਸ੍ਤਾਨ੍ ਅਵੋਚਤ੍ ਯਾਵਤ੍ ਸਖੀਨਾਂ ਸੰਙ੍ਗੇ ਕਨ੍ਯਾਯਾ ਵਰਸ੍ਤਿਸ਼਼੍ਠਤਿ, ਤਾਵਤ੍ ਕਿੰ ਤੇ ਵਿਲਾਪੰ ਕਰ੍ੱਤੁੰ ਸ਼ਕ੍ਲੁਵਨ੍ਤਿ? ਕਿਨ੍ਤੁ ਯਦਾ ਤੇਸ਼਼ਾਂ ਸੰਙ੍ਗਾਦ੍ ਵਰੰ ਨਯਨ੍ਤਿ, ਤਾਦ੍ਰੁʼਸ਼ਃ ਸਮਯ ਆਗਮਿਸ਼਼੍ਯਤਿ, ਤਦਾ ਤੇ ਉਪਵਤ੍ਸ੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","ਪੁਰਾਤਨਵਸਨੇ ਕੋਪਿ ਨਵੀਨਵਸ੍ਤ੍ਰੰ ਨ ਯੋਜਯਤਿ, ਯਸ੍ਮਾਤ੍ ਤੇਨ ਯੋਜਿਤੇਨ ਪੁਰਾਤਨਵਸਨੰ ਛਿਨੱਤਿ ਤੱਛਿਦ੍ਰਞ੍ਚ ਬਹੁਕੁਤ੍ਸਿਤੰ ਦ੍ਰੁʼਸ਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ਅਨ੍ਯਞ੍ਚ ਪੁਰਾਤਨਕੁਤ੍ਵਾਂ ਕੋਪਿ ਨਵਾਨਗੋਸ੍ਤਨੀਰਸੰ ਨ ਨਿਦਧਾਤਿ, ਯਸ੍ਮਾਤ੍ ਤਥਾ ਕ੍ਰੁʼਤੇ ਕੁਤੂ ਰ੍ਵਿਦੀਰ੍ੱਯਤੇ ਤੇਨ ਗੋਸ੍ਤਨੀਰਸਃ ਪਤਤਿ ਕੁਤੂਸ਼੍ਚ ਨਸ਼੍ਯਤਿ; ਤਸ੍ਮਾਤ੍ ਨਵੀਨਾਯਾਂ ਕੁਤ੍ਵਾਂ ਨਵੀਨੋ ਗੋਸ੍ਤਨੀਰਸਃ ਸ੍ਥਾਪ੍ਯਤੇ, ਤੇਨ ਦ੍ਵਯੋਰਵਨੰ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","ਅਪਰੰ ਤੇਨੈਤਤ੍ਕਥਾਕਥਨਕਾਲੇ ਏਕੋ(ਅ)ਧਿਪਤਿਸ੍ਤੰ ਪ੍ਰਣਮ੍ਯ ਬਭਾਸ਼਼ੇ, ਮਮ ਦੁਹਿਤਾ ਪ੍ਰਾਯੇਣੈਤਾਵਤ੍ਕਾਲੇ ਮ੍ਰੁʼਤਾ, ਤਸ੍ਮਾਦ੍ ਭਵਾਨਾਗਤ੍ਯ ਤਸ੍ਯਾ ਗਾਤ੍ਰੇ ਹਸ੍ਤਮਰ੍ਪਯਤੁ, ਤੇਨ ਸਾ ਜੀਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ਤਦਾਨੀਂ ਯੀਸ਼ੁਃ ਸ਼ਿਸ਼਼੍ਯੈਃ ਸਾਕਮ੍ ਉੱਥਾਯ ਤਸ੍ਯ ਪਸ਼੍ਚਾਦ੍ ਵਵ੍ਰਾਜ| ");
INSERT INTO sanpun_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ਇਤ੍ਯਨਨ੍ਤਰੇ ਦ੍ਵਾਦਸ਼ਵਤ੍ਸਰਾਨ੍ ਯਾਵਤ੍ ਪ੍ਰਦਰਾਮਯੇਨ ਸ਼ੀਰ੍ਣੈਕਾ ਨਾਰੀ ਤਸ੍ਯ ਪਸ਼੍ਚਾਦ੍ ਆਗਤ੍ਯ ਤਸ੍ਯ ਵਸਨਸ੍ਯ ਗ੍ਰਨ੍ਥਿੰ ਪਸ੍ਪਰ੍ਸ਼; ");
INSERT INTO sanpun_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ਯਸ੍ਮਾਤ੍ ਮਯਾ ਕੇਵਲੰ ਤਸ੍ਯ ਵਸਨੰ ਸ੍ਪ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਸ੍ਵਾਸ੍ਥ੍ਯੰ ਪ੍ਰਾਪ੍ਸ੍ਯਤੇ, ਸਾ ਨਾਰੀਤਿ ਮਨਸਿ ਨਿਸ਼੍ਚਿਤਵਤੀ| ");
INSERT INTO sanpun_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ਤਤੋ ਯੀਸ਼ੁਰ੍ਵਦਨੰ ਪਰਾਵਰ੍ੱਤ੍ਯ ਤਾਂ ਜਗਾਦ, ਹੇ ਕਨ੍ਯੇ, ਤ੍ਵੰ ਸੁਸ੍ਥਿਰਾ ਭਵ, ਤਵ ਵਿਸ਼੍ਵਾਸਸ੍ਤ੍ਵਾਂ ਸ੍ਵਸ੍ਥਾਮਕਾਰ੍ਸ਼਼ੀਤ੍| ਏਤਦ੍ਵਾਕ੍ਯੇ ਗਦਿਤਏਵ ਸਾ ਯੋਸ਼਼ਿਤ੍ ਸ੍ਵਸ੍ਥਾਭੂਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","ਅਪਰੰ ਯੀਸ਼ੁਸ੍ਤਸ੍ਯਾਧ੍ਯਕ੍ਸ਼਼ਸ੍ਯ ਗੇਹੰ ਗਤ੍ਵਾ ਵਾਦਕਪ੍ਰਭ੍ਰੁʼਤੀਨ੍ ਬਹੂਨ੍ ਲੋਕਾਨ੍ ਸ਼ਬ੍ਦਾਯਮਾਨਾਨ੍ ਵਿਲੋਕ੍ਯ ਤਾਨ੍ ਅਵਦਤ੍, ");
INSERT INTO sanpun_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ਪਨ੍ਥਾਨੰ ਤ੍ਯਜ, ਕਨ੍ਯੇਯੰ ਨਾਮ੍ਰਿਯਤ ਨਿਦ੍ਰਿਤਾਸ੍ਤੇ; ਕਥਾਮੇਤਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਤੇ ਤਮੁਪਜਹਸੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","ਕਿਨ੍ਤੁ ਸਰ੍ੱਵੇਸ਼਼ੁ ਬਹਿਸ਼਼੍ਕ੍ਰੁʼਤੇਸ਼਼ੁ ਸੋ(ਅ)ਭ੍ਯਨ੍ਤਰੰ ਗਤ੍ਵਾ ਕਨ੍ਯਾਯਾਃ ਕਰੰ ਧ੍ਰੁʼਤਵਾਨ੍, ਤੇਨ ਸੋਦਤਿਸ਼਼੍ਠਤ੍; ");
INSERT INTO sanpun_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ਤਤਸ੍ਤਤ੍ਕਰ੍ੰਮਣੋ ਯਸ਼ਃ ਕ੍ਰੁʼਤ੍ਸ੍ਨੰ ਤੰ ਦੇਸ਼ੰ ਵ੍ਯਾਪ੍ਤਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","ਤਤਃ ਪਰੰ ਯੀਸ਼ੁਸ੍ਤਸ੍ਮਾਤ੍ ਸ੍ਥਾਨਾਦ੍ ਯਾਤ੍ਰਾਂ ਚਕਾਰ; ਤਦਾ ਹੇ ਦਾਯੂਦਃ ਸਨ੍ਤਾਨ, ਅਸ੍ਮਾਨ੍ ਦਯਸ੍ਵ, ਇਤਿ ਵਦਨ੍ਤੌ ਦ੍ਵੌ ਜਨਾਵਨ੍ਧੌ ਪ੍ਰੋਚੈਰਾਹੂਯਨ੍ਤੌ ਤਤ੍ਪਸ਼੍ਚਾਦ੍ ਵਵ੍ਰਜਤੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ਤਤੋ ਯੀਸ਼ੌ ਗੇਹਮਧ੍ਯੰ ਪ੍ਰਵਿਸ਼਼੍ਟੰ ਤਾਵਪਿ ਤਸ੍ਯ ਸਮੀਪਮ੍ ਉਪਸ੍ਥਿਤਵਨ੍ਤੌ, ਤਦਾਨੀਂ ਸ ਤੌ ਪ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍ ਕਰ੍ੰਮੈਤਤ੍ ਕਰ੍ੱਤੁੰ ਮਮ ਸਾਮਰ੍ਥ੍ਯਮ੍ ਆਸ੍ਤੇ, ਯੁਵਾਂ ਕਿਮਿਤਿ ਪ੍ਰਤੀਥਃ? ਤਦਾ ਤੌ ਪ੍ਰਤ੍ਯੂਚਤੁਃ, ਸਤ੍ਯੰ ਪ੍ਰਭੋ| ");
INSERT INTO sanpun_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","ਤਦਾਨੀਂ ਸ ਤਯੋ ਰ੍ਲੋਚਨਾਨਿ ਸ੍ਪ੍ਰੁʼਸ਼ਨ੍ ਬਭਾਸ਼਼ੇ, ਯੁਵਯੋਃ ਪ੍ਰਤੀਤ੍ਯਨੁਸਾਰਾਦ੍ ਯੁਵਯੋ ਰ੍ਮਙ੍ਗਲੰ ਭੂਯਾਤ੍| ਤੇਨ ਤਤ੍ਕ੍ਸ਼਼ਣਾਤ੍ ਤਯੋ ਰ੍ਨੇਤ੍ਰਾਣਿ ਪ੍ਰਸੰਨਾਨ੍ਯਭਵਨ੍, ");
INSERT INTO sanpun_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ਪਸ਼੍ਚਾਦ੍ ਯੀਸ਼ੁਸ੍ਤੌ ਦ੍ਰੁʼਢਮਾਜ੍ਞਾਪ੍ਯ ਜਗਾਦ, ਅਵਧੱਤਮ੍ ਏਤਾਂ ਕਥਾਂ ਕੋਪਿ ਮਨੁਜੋ ਮ ਜਾਨੀਯਾਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","ਕਿਨ੍ਤੁ ਤੌ ਪ੍ਰਸ੍ਥਾਯ ਤਸ੍ਮਿਨ੍ ਕ੍ਰੁʼਤ੍ਸ੍ਨੇ ਦੇਸ਼ੇ ਤਸ੍ਯ ਕੀਰ੍ੱਤਿੰ ਪ੍ਰਕਾਸ਼ਯਾਮਾਸਤੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ਅਪਰੰ ਤੌ ਬਹਿਰ੍ਯਾਤ ਏਤਸ੍ਮਿੰਨਨ੍ਤਰੇ ਮਨੁਜਾ ਏਕੰ ਭੂਤਗ੍ਰਸ੍ਤਮੂਕੰ ਤਸ੍ਯ ਸਮੀਪਮ੍ ਆਨੀਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ਤੇਨ ਭੂਤੇ ਤ੍ਯਾਜਿਤੇ ਸ ਮੂਕਃ ਕਥਾਂ ਕਥਯਿਤੁੰ ਪ੍ਰਾਰਭਤ, ਤੇਨ ਜਨਾ ਵਿਸ੍ਮਯੰ ਵਿਜ੍ਞਾਯ ਕਥਯਾਮਾਸੁਃ, ਇਸ੍ਰਾਯੇਲੋ ਵੰਸ਼ੇ ਕਦਾਪਿ ਨੇਦ੍ਰੁʼਗਦ੍ਰੁʼਸ਼੍ਯਤ; ");
INSERT INTO sanpun_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","ਕਿਨ੍ਤੁ ਫਿਰੂਸ਼ਿਨਃ ਕਥਯਾਞ੍ਚਕ੍ਰੁਃ ਭੂਤਾਧਿਪਤਿਨਾ ਸ ਭੂਤਾਨ੍ ਤ੍ਯਾਜਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ਤਤਃ ਪਰੰ ਯੀਸ਼ੁਸ੍ਤੇਸ਼਼ਾਂ ਭਜਨਭਵਨ ਉਪਦਿਸ਼ਨ੍ ਰਾਜ੍ਯਸ੍ਯ ਸੁਸੰਵਾਦੰ ਪ੍ਰਚਾਰਯਨ੍ ਲੋਕਾਨਾਂ ਯਸ੍ਯ ਯ ਆਮਯੋ ਯਾ ਚ ਪੀਡਾਸੀਤ੍, ਤਾਨ੍ ਸ਼ਮਯਨ੍ ਸ਼ਮਯੰਸ਼੍ਚ ਸਰ੍ੱਵਾਣਿ ਨਗਰਾਣਿ ਗ੍ਰਾਮਾਂਸ਼੍ਚ ਬਭ੍ਰਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ਅਨ੍ਯਞ੍ਚ ਮਨੁਜਾਨ੍ ਵ੍ਯਾਕੁਲਾਨ੍ ਅਰਕ੍ਸ਼਼ਕਮੇਸ਼਼ਾਨਿਵ ਚ ਤ੍ਯਕ੍ਤਾਨ੍ ਨਿਰੀਕ੍ਸ਼਼੍ਯ ਤੇਸ਼਼ੁ ਕਾਰੁਣਿਕਃ ਸਨ੍ ਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਅਵਦਤ੍, ");
INSERT INTO sanpun_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ਸ਼ਸ੍ਯਾਨਿ ਪ੍ਰਚੁਰਾਣਿ ਸਨ੍ਤਿ, ਕਿਨ੍ਤੁ ਛੇੱਤਾਰਃ ਸ੍ਤੋਕਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ਕ੍ਸ਼਼ੇਤ੍ਰੰ ਪ੍ਰਤ੍ਯਪਰਾਨ੍ ਛੇਦਕਾਨ੍ ਪ੍ਰਹੇਤੁੰ ਸ਼ਸ੍ਯਸ੍ਵਾਮਿਨੰ ਪ੍ਰਾਰ੍ਥਯਧ੍ਵਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","ਅਨਨ੍ਤਰੰ ਯੀਸ਼ੁ ਰ੍ਦ੍ਵਾਦਸ਼ਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਆਹੂਯਾਮੇਧ੍ਯਭੂਤਾਨ੍ ਤ੍ਯਾਜਯਿਤੁੰ ਸਰ੍ੱਵਪ੍ਰਕਾਰਰੋਗਾਨ੍ ਪੀਡਾਸ਼੍ਚ ਸ਼ਮਯਿਤੁੰ ਤੇਭ੍ਯਃ ਸਾਮਰ੍ਥ੍ਯਮਦਾਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","ਤੇਸ਼਼ਾਂ ਦ੍ਵਾਦਸ਼ਪ੍ਰੇਸ਼਼੍ਯਾਣਾਂ ਨਾਮਾਨ੍ਯੇਤਾਨਿ| ਪ੍ਰਥਮੰ ਸ਼ਿਮੋਨ੍ ਯੰ ਪਿਤਰੰ ਵਦਨ੍ਤਿ, ਤਤਃ ਪਰੰ ਤਸ੍ਯ ਸਹਜ ਆਨ੍ਦ੍ਰਿਯਃ, ਸਿਵਦਿਯਸ੍ਯ ਪੁਤ੍ਰੋ ਯਾਕੂਬ੍ ");
INSERT INTO sanpun_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ਤਸ੍ਯ ਸਹਜੋ ਯੋਹਨ੍; ਫਿਲਿਪ੍ ਬਰ੍ਥਲਮਯ੍ ਥੋਮਾਃ ਕਰਸੰਗ੍ਰਾਹੀ ਮਥਿਃ, ਆਲ੍ਫੇਯਪੁਤ੍ਰੋ ਯਾਕੂਬ੍, ");
INSERT INTO sanpun_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ਕਿਨਾਨੀਯਃ ਸ਼ਿਮੋਨ੍, ਯ ਈਸ਼਼੍ਕਰਿਯੋਤੀਯਯਿਹੂਦਾਃ ਖ੍ਰੀਸ਼਼੍ਟੰ ਪਰਕਰੇ(ਅ)ਰ੍ਪਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ਏਤਾਨ੍ ਦ੍ਵਾਦਸ਼ਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਯੀਸ਼ੁਃ ਪ੍ਰੇਸ਼਼ਯਨ੍ ਇਤ੍ਯਾਜ੍ਞਾਪਯਤ੍, ਯੂਯਮ੍ ਅਨ੍ਯਦੇਸ਼ੀਯਾਨਾਂ ਪਦਵੀਂ ਸ਼ੇਮਿਰੋਣੀਯਾਨਾਂ ਕਿਮਪਿ ਨਗਰਞ੍ਚ ਨ ਪ੍ਰਵਿਸ਼੍ਯੇ ");
INSERT INTO sanpun_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ਇਸ੍ਰਾਯੇਲ੍ਗੋਤ੍ਰਸ੍ਯ ਹਾਰਿਤਾ ਯੇ ਯੇ ਮੇਸ਼਼ਾਸ੍ਤੇਸ਼਼ਾਮੇਵ ਸਮੀਪੰ ਯਾਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","ਗਤ੍ਵਾ ਗਤ੍ਵਾ ਸ੍ਵਰ੍ਗਸ੍ਯ ਰਾਜਤ੍ਵੰ ਸਵਿਧਮਭਵਤ੍, ਏਤਾਂ ਕਥਾਂ ਪ੍ਰਚਾਰਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ਆਮਯਗ੍ਰਸ੍ਤਾਨ੍ ਸ੍ਵਸ੍ਥਾਨ੍ ਕੁਰੁਤ, ਕੁਸ਼਼੍ਠਿਨਃ ਪਰਿਸ਼਼੍ਕੁਰੁਤ, ਮ੍ਰੁʼਤਲੋਕਾਨ੍ ਜੀਵਯਤ, ਭੂਤਾਨ੍ ਤ੍ਯਾਜਯਤ, ਵਿਨਾ ਮੂਲ੍ਯੰ ਯੂਯਮ੍ ਅਲਭਧ੍ਵੰ ਵਿਨੈਵ ਮੂਲ੍ਯੰ ਵਿਸ਼੍ਰਾਣਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","ਕਿਨ੍ਤੁ ਸ੍ਵੇਸ਼਼ਾਂ ਕਟਿਬਨ੍ਧੇਸ਼਼ੁ ਸ੍ਵਰ੍ਣਰੂਪ੍ਯਤਾਮ੍ਰਾਣਾਂ ਕਿਮਪਿ ਨ ਗ੍ਰੁʼਹ੍ਲੀਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ਅਨ੍ਯੱਚ ਯਾਤ੍ਰਾਯੈ ਚੇਲਸਮ੍ਪੁਟੰ ਵਾ ਦ੍ਵਿਤੀਯਵਸਨੰ ਵਾ ਪਾਦੁਕੇ ਵਾ ਯਸ਼਼੍ਟਿਃ, ਏਤਾਨ੍ ਮਾ ਗ੍ਰੁʼਹ੍ਲੀਤ, ਯਤਃ ਕਾਰ੍ੱਯਕ੍ਰੁʼਤ੍ ਭਰ੍ੱਤੁੰ ਯੋਗ੍ਯੋ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","ਅਪਰੰ ਯੂਯੰ ਯਤ੍ ਪੁਰੰ ਯਞ੍ਚ ਗ੍ਰਾਮੰ ਪ੍ਰਵਿਸ਼ਥ, ਤਤ੍ਰ ਯੋ ਜਨੋ ਯੋਗ੍ਯਪਾਤ੍ਰੰ ਤਮਵਗਤ੍ਯ ਯਾਨਕਾਲੰ ਯਾਵਤ੍ ਤਤ੍ਰ ਤਿਸ਼਼੍ਠਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ਯਦਾ ਯੂਯੰ ਤਦ੍ਗੇਹੰ ਪ੍ਰਵਿਸ਼ਥ, ਤਦਾ ਤਮਾਸ਼ਿਸ਼਼ੰ ਵਦਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ਯਦਿ ਸ ਯੋਗ੍ਯਪਾਤ੍ਰੰ ਭਵਤਿ, ਤਰ੍ਹਿ ਤਤ੍ਕਲ੍ਯਾਣੰ ਤਸ੍ਮੈ ਭਵਿਸ਼਼੍ਯਤਿ, ਨੋਚੇਤ੍ ਸਾਸ਼ੀਰ੍ਯੁਸ਼਼੍ਮਭ੍ਯਮੇਵ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ਕਿਨ੍ਤੁ ਯੇ ਜਨਾ ਯੁਸ਼਼੍ਮਾਕਮਾਤਿਥ੍ਯੰ ਨ ਵਿਦਧਤਿ ਯੁਸ਼਼੍ਮਾਕੰ ਕਥਾਞ੍ਚ ਨ ਸ਼੍ਰੁʼਣ੍ਵਨ੍ਤਿ ਤੇਸ਼਼ਾਂ ਗੇਹਾਤ੍ ਪੁਰਾਦ੍ਵਾ ਪ੍ਰਸ੍ਥਾਨਕਾਲੇ ਸ੍ਵਪਦੂਲੀਃ ਪਾਤਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","ਯੁਸ਼਼੍ਮਾਨਹੰ ਤਥ੍ਯੰ ਵਚ੍ਮਿ ਵਿਚਾਰਦਿਨੇ ਤਤ੍ਪੁਰਸ੍ਯ ਦਸ਼ਾਤਃ ਸਿਦੋਮਮੋਰਾਪੁਰਯੋਰ੍ਦਸ਼ਾ ਸਹ੍ਯਤਰਾ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","ਪਸ਼੍ਯਤ, ਵ੍ਰੁʼਕਯੂਥਮਧ੍ਯੇ ਮੇਸ਼਼ਃ ਯਥਾਵਿਸ੍ਤਥਾ ਯੁਸ਼਼੍ਮਾਨ ਪ੍ਰਹਿਣੋਮਿ, ਤਸ੍ਮਾਦ੍ ਯੂਯਮ੍ ਅਹਿਰਿਵ ਸਤਰ੍ਕਾਃ ਕਪੋਤਾਇਵਾਹਿੰਸਕਾ ਭਵਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","ਨ੍ਰੁʼਭ੍ਯਃ ਸਾਵਧਾਨਾ ਭਵਤ; ਯਤਸ੍ਤੈ ਰ੍ਯੂਯੰ ਰਾਜਸੰਸਦਿ ਸਮਰ੍ਪਿਸ਼਼੍ਯਧ੍ਵੇ ਤੇਸ਼਼ਾਂ ਭਜਨਗੇਹੇ ਪ੍ਰਹਾਰਿਸ਼਼੍ਯਧ੍ਵੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ਯੂਯੰ ਮੰਨਾਮਹੇਤੋਃ ਸ਼ਾਸ੍ਤ੍ਰੁʼਣਾਂ ਰਾਜ੍ਞਾਞ੍ਚ ਸਮਕ੍ਸ਼਼ੰ ਤਾਨਨ੍ਯਦੇਸ਼ਿਨਸ਼੍ਚਾਧਿ ਸਾਕ੍ਸ਼਼ਿਤ੍ਵਾਰ੍ਥਮਾਨੇਸ਼਼੍ਯਧ੍ਵੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","ਕਿਨ੍ਤ੍ਵਿੱਥੰ ਸਮਰ੍ਪਿਤਾ ਯੂਯੰ ਕਥੰ ਕਿਮੁੱਤਰੰ ਵਕ੍ਸ਼਼੍ਯਥ ਤਤ੍ਰ ਮਾ ਚਿਨ੍ਤਯਤ, ਯਤਸ੍ਤਦਾ ਯੁਸ਼਼੍ਮਾਭਿ ਰ੍ਯਦ੍ ਵਕ੍ਤਵ੍ਯੰ ਤਤ੍ ਤੱਦਣ੍ਡੇ ਯੁਸ਼਼੍ਮਨ੍ਮਨਃ ਸੁ ਸਮੁਪਸ੍ਥਾਸ੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ਯਸ੍ਮਾਤ੍ ਤਦਾ ਯੋ ਵਕ੍ਸ਼਼੍ਯਤਿ ਸ ਨ ਯੂਯੰ ਕਿਨ੍ਤੁ ਯੁਸ਼਼੍ਮਾਕਮਨ੍ਤਰਸ੍ਥਃ ਪਿਤ੍ਰਾਤ੍ਮਾ| ");
INSERT INTO sanpun_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","ਸਹਜਃ ਸਹਜੰ ਤਾਤਃ ਸੁਤਞ੍ਚ ਮ੍ਰੁʼਤੌ ਸਮਰ੍ਪਯਿਸ਼਼੍ਯਤਿ, ਅਪਤ੍ਯਾਗਿ ਸ੍ਵਸ੍ਵਪਿਤ੍ਰੋे ਰ੍ਵਿਪਕ੍ਸ਼਼ੀਭੂਯ ਤੌ ਘਾਤਯਿਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","ਮੰਨਮਹੇਤੋਃ ਸਰ੍ੱਵੇ ਜਨਾ ਯੁਸ਼਼੍ਮਾਨ੍ ਰੁʼृਤੀਯਿਸ਼਼੍ਯਨ੍ਤੇ, ਕਿਨ੍ਤੁ ਯਃ ਸ਼ੇਸ਼਼ੰ ਯਾਵਦ੍ ਧੈਰ੍ੱਯੰ ਘ੍ਰੁʼਤ੍ਵਾ ਸ੍ਥਾਸ੍ਯਤਿ, ਸ ਤ੍ਰਾਯਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","ਤੈ ਰ੍ਯਦਾ ਯੂਯਮੇਕਪੁਰੇ ਤਾਡਿਸ਼਼੍ਯਧ੍ਵੇ, ਤਦਾ ਯੂਯਮਨ੍ਯਪੁਰੰ ਪਲਾਯਧ੍ਵੰ ਯੁਸ਼਼੍ਮਾਨਹੰ ਤਥ੍ਯੰ ਵਚ੍ਮਿ ਯਾਵਨ੍ਮਨੁਜਸੁਤੋ ਨੈਤਿ ਤਾਵਦ੍ ਇਸ੍ਰਾਯੇਲ੍ਦੇਸ਼ੀਯਸਰ੍ੱਵਨਗਰਭ੍ਰਮਣੰ ਸਮਾਪਯਿਤੁੰ ਨ ਸ਼ਕ੍ਸ਼਼੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","ਗੁਰੋਃ ਸ਼ਿਸ਼਼੍ਯੋ ਨ ਮਹਾਨ੍, ਪ੍ਰਭੋਰ੍ਦਾਸੋ ਨ ਮਹਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","ਯਦਿ ਸ਼ਿਸ਼਼੍ਯੋ ਨਿਜਗੁਰੋ ਰ੍ਦਾਸਸ਼੍ਚ ਸ੍ਵਪ੍ਰਭੋਃ ਸਮਾਨੋ ਭਵਤਿ ਤਰ੍ਹਿ ਤਦ੍ ਯਥੇਸ਼਼੍ਟੰ| ਚੇੱਤੈਰ੍ਗ੍ਰੁʼਹਪਤਿਰ੍ਭੂਤਰਾਜ ਉਚ੍ਯਤੇ, ਤਰ੍ਹਿ ਪਰਿਵਾਰਾਃ ਕਿੰ ਤਥਾ ਨ ਵਕ੍ਸ਼਼੍ਯਨ੍ਤੇ? ");
INSERT INTO sanpun_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","ਕਿਨ੍ਤੁ ਤੇਭ੍ਯੋ ਯੂਯੰ ਮਾ ਬਿਭੀਤ, ਯਤੋ ਯੰਨ ਪ੍ਰਕਾਸ਼ਿਸ਼਼੍ਯਤੇ, ਤਾਦ੍ਰੁʼਕ੍ ਛਾਦਿਤੰ ਕਿਮਪਿ ਨਾਸ੍ਤਿ, ਯੱਚ ਨ ਵ੍ਯਞ੍ਚਿਸ਼਼੍ਯਤੇ, ਤਾਦ੍ਰੁʼਗ੍ ਗੁਪ੍ਤੰ ਕਿਮਪਿ ਨਾਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ਯਦਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਤਮਸਿ ਵਚ੍ਮਿ ਤਦ੍ ਯੁਸ਼਼੍ਮਾਭਿਰ੍ਦੀਪ੍ਤੌ ਕਥ੍ਯਤਾਂ; ਕਰ੍ਣਾਭ੍ਯਾਂ ਯਤ੍ ਸ਼੍ਰੂਯਤੇ ਤਦ੍ ਗੇਹੋਪਰਿ ਪ੍ਰਚਾਰ੍ੱਯਤਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ਯੇ ਕਾਯੰ ਹਨ੍ਤੁੰ ਸ਼ਕ੍ਨੁਵਨ੍ਤਿ ਨਾਤ੍ਮਾਨੰ, ਤੇਭ੍ਯੋ ਮਾ ਭੈਸ਼਼੍ਟ; ਯਃ ਕਾਯਾਤ੍ਮਾਨੌ ਨਿਰਯੇ ਨਾਸ਼ਯਿਤੁੰ, ਸ਼ਕ੍ਨੋਤਿ, ਤਤੋ ਬਿਭੀਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ਦ੍ਵੌ ਚਟਕੌ ਕਿਮੇਕਤਾਮ੍ਰਮੁਦ੍ਰਯਾ ਨ ਵਿਕ੍ਰੀਯੇਤੇ? ਤਥਾਪਿ ਯੁਸ਼਼੍ਮੱਤਾਤਾਨੁਮਤਿੰ ਵਿਨਾ ਤੇਸ਼਼ਾਮੇਕੋਪਿ ਭੁਵਿ ਨ ਪਤਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","ਯੁਸ਼਼੍ਮੱਛਿਰਸਾਂ ਸਰ੍ੱਵਕਚਾ ਗਣਿਤਾਂਃ ਸਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ਅਤੋ ਮਾ ਬਿਭੀਤ, ਯੂਯੰ ਬਹੁਚਟਕੇਭ੍ਯੋ ਬਹੁਮੂਲ੍ਯਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","ਯੋ ਮਨੁਜਸਾਕ੍ਸ਼਼ਾਨ੍ਮਾਮਙ੍ਗੀਕੁਰੁਤੇ ਤਮਹੰ ਸ੍ਵਰ੍ਗਸ੍ਥਤਾਤਸਾਕ੍ਸ਼਼ਾਦਙ੍ਗੀਕਰਿਸ਼਼੍ਯੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ਪ੍ਰੁʼਥ੍ਵ੍ਯਾਮਹੰ ਸ਼ਾਨ੍ਤਿੰ ਦਾਤੁਮਾਗਤਇਤਿ ਮਾਨੁਭਵਤ, ਸ਼ਾਨ੍ਤਿੰ ਦਾਤੁੰ ਨ ਕਿਨ੍ਤ੍ਵਸਿੰ| ");
INSERT INTO sanpun_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","ਪਿਤ੍ਰੁʼਮਾਤ੍ਰੁʼਸ਼੍ਚਸ਼੍ਰੂਭਿਃ ਸਾਕੰ ਸੁਤਸੁਤਾਬਧੂ ਰ੍ਵਿਰੋਧਯਿਤੁਞ੍ਚਾਗਤੇाਸ੍ਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ਤਤਃ ਸ੍ਵਸ੍ਵਪਰਿਵਾਰਏਵ ਨ੍ਰੁʼਸ਼ਤ੍ਰੁ ਰ੍ਭਵਿਤਾ| ");
INSERT INTO sanpun_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ਯਃ ਪਿਤਰਿ ਮਾਤਰਿ ਵਾ ਮੱਤੋਧਿਕੰ ਪ੍ਰੀਯਤੇ, ਸ ਨ ਮਦਰ੍ਹਃ; ");
INSERT INTO sanpun_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","ਯਸ਼੍ਚ ਸੁਤੇ ਸੁਤਾਯਾਂ ਵਾ ਮੱਤੋਧਿਕੰ ਪ੍ਰੀਯਤੇ, ਸੇाਪਿ ਨ ਮਦਰ੍ਹਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ਯਃ ਸ੍ਵਕ੍ਰੁਸ਼ੰ ਗ੍ਰੁʼਹ੍ਲਨ੍ ਮਤ੍ਪਸ਼੍ਚਾੰਨੈਤਿ, ਸੇाਪਿ ਨ ਮਦਰ੍ਹਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ਯਃ ਸ੍ਵਪ੍ਰਾਣਾਨਵਤਿ, ਸ ਤਾਨ੍ ਹਾਰਯਿਸ਼਼੍ਯਤੇ, ਯਸ੍ਤੁ ਮਤ੍ਕ੍ਰੁʼਤੇ ਸ੍ਵਪ੍ਰਾਣਾਨ੍ ਹਾਰਯਤਿ, ਸ ਤਾਨਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","ਯੋ ਯੁਸ਼਼੍ਮਾਕਮਾਤਿਥ੍ਯੰ ਵਿਦਧਾਤਿ, ਸ ਮਮਾਤਿਥ੍ਯੰ ਵਿਦਧਾਤਿ, ਯਸ਼੍ਚ ਮਮਾਤਿਥ੍ਯੰ ਵਿਦਧਾਤਿ, ਸ ਮਤ੍ਪ੍ਰੇਰਕਸ੍ਯਾਤਿਥ੍ਯੰ ਵਿਦਧਾਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ਯੋ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦੀਤਿ ਜ੍ਞਾਤ੍ਵਾ ਤਸ੍ਯਾਤਿਥ੍ਯੰ ਵਿਧੱਤੇ, ਸ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਃ ਫਲੰ ਲਪ੍ਸ੍ਯਤੇ, ਯਸ਼੍ਚ ਧਾਰ੍ੰਮਿਕ ਇਤਿ ਵਿਦਿਤ੍ਵਾ ਤਸ੍ਯਾਤਿਥ੍ਯੰ ਵਿਧੱਤੇ ਸ ਧਾਰ੍ੰਮਿਕਮਾਨਵਸ੍ਯ ਫਲੰ ਪ੍ਰਾਪ੍ਸ੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ਯਸ਼੍ਚ ਕਸ਼੍ਚਿਤ੍ ਏਤੇਸ਼਼ਾਂ ਕ੍ਸ਼਼ੁਦ੍ਰਨਰਾਣਾਮ੍ ਯੰ ਕਞ੍ਚਨੈਕੰ ਸ਼ਿਸ਼਼੍ਯ ਇਤਿ ਵਿਦਿਤ੍ਵਾ ਕੰਸੈਕੰ ਸ਼ੀਤਲਸਲਿਲੰ ਤਸ੍ਮੈ ਦੱਤੇ, ਯੁਸ਼਼੍ਮਾਨਹੰ ਤਥ੍ਯੰ ਵਦਾਮਿ, ਸ ਕੇਨਾਪਿ ਪ੍ਰਕਾਰੇਣ ਫਲੇਨ ਨ ਵਞ੍ਚਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ਇੱਥੰ ਯੀਸ਼ੁਃ ਸ੍ਵਦ੍ਵਾਦਸ਼ਸ਼ਿਸ਼਼੍ਯਾਣਾਮਾਜ੍ਞਾਪਨੰ ਸਮਾਪ੍ਯ ਪੁਰੇ ਪੁਰ ਉਪਦੇਸ਼਼੍ਟੁੰ ਸੁਸੰਵਾਦੰ ਪ੍ਰਚਾਰਯਿਤੁੰ ਤਤ੍ਸ੍ਥਾਨਾਤ੍ ਪ੍ਰਤਸ੍ਥੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ਅਨਨ੍ਤਰੰ ਯੋਹਨ੍ ਕਾਰਾਯਾਂ ਤਿਸ਼਼੍ਠਨ੍ ਖ੍ਰਿਸ਼਼੍ਟਸ੍ਯ ਕਰ੍ੰਮਣਾਂ ਵਾਰ੍ੱਤੰ ਪ੍ਰਾਪ੍ਯ ਯਸ੍ਯਾਗਮਨਵਾਰ੍ੱਤਾਸੀਤ੍ ਸਏਵ ਕਿੰ ਤ੍ਵੰ? ਵਾ ਵਯਮਨ੍ਯਮ੍ ਅਪੇਕ੍ਸ਼਼ਿਸ਼਼੍ਯਾਮਹੇ? ");
INSERT INTO sanpun_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ਏਤਤ੍ ਪ੍ਰਸ਼਼੍ਟੁੰ ਨਿਜੌ ਦ੍ਵੌ ਸ਼ਿਸ਼਼੍ਯੌ ਪ੍ਰਾਹਿਣੋਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯਵੋਚਤ੍, ਅਨ੍ਧਾ ਨੇਤ੍ਰਾਣਿ ਲਭਨ੍ਤੇ, ਖਞ੍ਚਾ ਗੱਛਨ੍ਤਿ, ਕੁਸ਼਼੍ਠਿਨਃ ਸ੍ਵਸ੍ਥਾ ਭਵਨ੍ਤਿ, ਬਧਿਰਾਃ ਸ਼੍ਰੁʼਣ੍ਵਨ੍ਤਿ, ਮ੍ਰੁʼਤਾ ਜੀਵਨ੍ਤ ਉੱਤਿਸ਼਼੍ਠਨ੍ਤਿ, ਦਰਿਦ੍ਰਾਣਾਂ ਸਮੀਪੇ ਸੁਸੰਵਾਦਃ ਪ੍ਰਚਾਰ੍ੱਯਤ, ");
INSERT INTO sanpun_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ਏਤਾਨਿ ਯਦ੍ਯਦ੍ ਯੁਵਾਂ ਸ਼੍ਰੁʼਣੁਥਃ ਪਸ਼੍ਯਥਸ਼੍ਚ ਗਤ੍ਵਾ ਤਦ੍ਵਾਰ੍ੱਤਾਂ ਯੋਹਨੰ ਗਦਤੰ| ");
INSERT INTO sanpun_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ਯਸ੍ਯਾਹੰ ਨ ਵਿਘ੍ਨੀਭਵਾਮਿ, ਸਏਵ ਧਨ੍ਯਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ਅਨਨ੍ਤਰੰ ਤਯੋਃ ਪ੍ਰਸ੍ਥਿਤਯੋ ਰ੍ਯੀਸ਼ੁ ਰ੍ਯੋਹਨਮ੍ ਉੱਦਿਸ਼੍ਯ ਜਨਾਨ੍ ਜਗਾਦ, ਯੂਯੰ ਕਿੰ ਦ੍ਰਸ਼਼੍ਟੁੰ ਵਹਿਰ੍ਮਧ੍ਯੇਪ੍ਰਾਨ੍ਤਰਮ੍ ਅਗੱਛਤ? ਕਿੰ ਵਾਤੇਨ ਕਮ੍ਪਿਤੰ ਨਲੰ? ");
INSERT INTO sanpun_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","ਵਾ ਕਿੰ ਵੀਕ੍ਸ਼਼ਿਤੁੰ ਵਹਿਰ੍ਗਤਵਨ੍ਤਃ? ਕਿੰ ਪਰਿਹਿਤਸੂਕ੍ਸ਼਼੍ਮਵਸਨੰ ਮਨੁਜਮੇਕੰ? ਪਸ਼੍ਯਤ, ਯੇ ਸੂਕ੍ਸ਼਼੍ਮਵਸਨਾਨਿ ਪਰਿਦਧਤਿ, ਤੇ ਰਾਜਧਾਨ੍ਯਾਂ ਤਿਸ਼਼੍ਠਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ਤਰ੍ਹਿ ਯੂਯੰ ਕਿੰ ਦ੍ਰਸ਼਼੍ਟੁੰ ਬਹਿਰਗਮਤ, ਕਿਮੇਕੰ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨੰ? ਤਦੇਵ ਸਤ੍ਯੰ| ਯੁਸ਼਼੍ਮਾਨਹੰ ਵਦਾਮਿ, ਸ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨੋਪਿ ਮਹਾਨ੍; ");
INSERT INTO sanpun_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","ਯਤਃ, ਪਸ਼੍ਯ ਸ੍ਵਕੀਯਦੂਤੋਯੰ ਤ੍ਵਦਗ੍ਰੇ ਪ੍ਰੇਸ਼਼੍ਯਤੇ ਮਯਾ| ਸ ਗਤ੍ਵਾ ਤਵ ਪਨ੍ਥਾਨੰ ਸ੍ਮਯਕ੍ ਪਰਿਸ਼਼੍ਕਰਿਸ਼਼੍ਯਤਿ|| ਏਤਦ੍ਵਚਨੰ ਯਮਧਿ ਲਿਖਿਤਮਾਸ੍ਤੇ ਸੋ(ਅ)ਯੰ ਯੋਹਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","ਅਪਰੰ ਯੁਸ਼਼੍ਮਾਨਹੰ ਤਥ੍ਯੰ ਬ੍ਰਵੀਮਿ, ਮੱਜਯਿਤੁ ਰ੍ਯੋਹਨਃ ਸ਼੍ਰੇਸ਼਼੍ਠਃ ਕੋਪਿ ਨਾਰੀਤੋ ਨਾਜਾਯਤ; ਤਥਾਪਿ ਸ੍ਵਰ੍ਗਰਾਜ੍ਯਮਧ੍ਯੇ ਸਰ੍ੱਵੇਭ੍ਯੋ ਯਃ ਕ੍ਸ਼਼ੁਦ੍ਰਃ ਸ ਯੋਹਨਃ ਸ਼੍ਰੇਸ਼਼੍ਠਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","ਅਪਰਞ੍ਚ ਆ ਯੋਹਨੋ(ਅ)ਦ੍ਯ ਯਾਵਤ੍ ਸ੍ਵਰ੍ਗਰਾਜ੍ਯੰ ਬਲਾਦਾਕ੍ਰਾਨ੍ਤੰ ਭਵਤਿ ਆਕ੍ਰਮਿਨਸ਼੍ਚ ਜਨਾ ਬਲੇਨ ਤਦਧਿਕੁਰ੍ੱਵਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","ਯਤੋ ਯੋਹਨੰ ਯਾਵਤ੍ ਸਰ੍ੱਵਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਭਿ ਰ੍ਵ੍ਯਵਸ੍ਥਯਾ ਚ ਉਪਦੇਸ਼ਃ ਪ੍ਰਾਕਾਸ਼੍ਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ਯਦਿ ਯੂਯਮਿਦੰ ਵਾਕ੍ਯੰ ਗ੍ਰਹੀਤੁੰ ਸ਼ਕ੍ਨੁਥ, ਤਰ੍ਹਿ ਸ਼੍ਰੇਯਃ, ਯਸ੍ਯਾਗਮਨਸ੍ਯ ਵਚਨਮਾਸ੍ਤੇ ਸੋ(ਅ)ਯਮ੍ ਏਲਿਯਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ਯਸ੍ਯ ਸ਼੍ਰੋਤੁੰ ਕਰ੍ਣੌ ਸ੍ਤਃ ਸ ਸ਼੍ਰੁʼਣੋਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","ਏਤੇ ਵਿਦ੍ਯਮਾਨਜਨਾਃ ਕੈ ਰ੍ਮਯੋਪਮੀਯਨ੍ਤੇ? ਯੇ ਬਾਲਕਾ ਹੱਟ ਉਪਵਿਸ਼੍ਯ ਸ੍ਵੰ ਸ੍ਵੰ ਬਨ੍ਧੁਮਾਹੂਯ ਵਦਨ੍ਤਿ, ");
INSERT INTO sanpun_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ਵਯੰ ਯੁਸ਼਼੍ਮਾਕੰ ਸਮੀਪੇ ਵੰਸ਼ੀਰਵਾਦਯਾਮ, ਕਿਨ੍ਤੁ ਯੂਯੰ ਨਾਨ੍ਰੁʼਤ੍ਯਤ; ਯੁਸ਼਼੍ਮਾਕੰ ਸਮੀਪੇ ਚ ਵਯਮਰੋਦਿਮ, ਕਿਨ੍ਤੁ ਯੂਯੰ ਨ ਵ੍ਯਲਪਤ, ਤਾਦ੍ਰੁʼਸ਼ੈ ਰ੍ਬਾਲਕੈਸ੍ਤ ਉਪਮਾਯਿਸ਼਼੍ਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","ਯਤੋ ਯੋਹਨ੍ ਆਗਤ੍ਯ ਨ ਭੁਕ੍ਤਵਾਨ੍ ਨ ਪੀਤਵਾਂਸ਼੍ਚ, ਤੇਨ ਲੋਕਾ ਵਦਨ੍ਤਿ, ਸ ਭੂਤਗ੍ਰਸ੍ਤ ਇਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","ਮਨੁਜਸੁਤ ਆਗਤ੍ਯ ਭੁਕ੍ਤਵਾਨ੍ ਪੀਤਵਾਂਸ਼੍ਚ, ਤੇਨ ਲੋਕਾ ਵਦਨ੍ਤਿ, ਪਸ਼੍ਯਤ ਏਸ਼਼ ਭੋਕ੍ਤਾ ਮਦ੍ਯਪਾਤਾ ਚਣ੍ਡਾਲਪਾਪਿਨਾਂ ਬਨ੍ਧਸ਼੍ਚ, ਕਿਨ੍ਤੁ ਜ੍ਞਾਨਿਨੋ ਜ੍ਞਾਨਵ੍ਯਵਹਾਰੰ ਨਿਰ੍ਦੋਸ਼਼ੰ ਜਾਨਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ਸ ਯਤ੍ਰ ਯਤ੍ਰ ਪੁਰੇ ਬਹ੍ਵਾਸ਼੍ਚਰ੍ੱਯੰ ਕਰ੍ੰਮ ਕ੍ਰੁʼਤਵਾਨ੍, ਤੰਨਿਵਾਸਿਨਾਂ ਮਨਃਪਰਾਵ੍ਰੁʼੱਤ੍ਯਭਾਵਾਤ੍ ਤਾਨਿ ਨਗਰਾਣਿ ਪ੍ਰਤਿ ਹਨ੍ਤੇਤ੍ਯੁਕ੍ਤਾ ਕਥਿਤਵਾਨ੍, ");
INSERT INTO sanpun_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","ਹਾ ਕੋਰਾਸੀਨ੍, ਹਾ ਬੈਤ੍ਸੈਦੇ, ਯੁਸ਼਼੍ਮਨ੍ਮਧ੍ਯੇ ਯਦ੍ਯਦਾਸ਼੍ਚਰ੍ੱਯੰ ਕਰ੍ੰਮ ਕ੍ਰੁʼਤੰ ਯਦਿ ਤਤ੍ ਸੋਰਸੀਦੋੰਨਗਰ ਅਕਾਰਿਸ਼਼੍ਯਤ, ਤਰ੍ਹਿ ਪੂਰ੍ੱਵਮੇਵ ਤੰਨਿਵਾਸਿਨਃ ਸ਼ਾਣਵਸਨੇ ਭਸ੍ਮਨਿ ਚੋਪਵਿਸ਼ਨ੍ਤੋ ਮਨਾਂਸਿ ਪਰਾਵਰ੍ੱਤਿਸ਼਼੍ਯਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","ਤਸ੍ਮਾਦਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਵਦਾਮਿ, ਵਿਚਾਰਦਿਨੇ ਯੁਸ਼਼੍ਮਾਕੰ ਦਸ਼ਾਤਃ ਸੋਰਸੀਦੋਨੋ ਰ੍ਦਸ਼ਾ ਸਹ੍ਯਤਰਾ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","ਅਪਰਞ੍ਚ ਬਤ ਕਫਰ੍ਨਾਹੂਮ੍, ਤ੍ਵੰ ਸ੍ਵਰ੍ਗੰ ਯਾਵਦੁੰਨਤੋਸਿ, ਕਿਨ੍ਤੁ ਨਰਕੇ ਨਿਕ੍ਸ਼਼ੇਪ੍ਸ੍ਯਸੇ, ਯਸ੍ਮਾਤ੍ ਤ੍ਵਯਿ ਯਾਨ੍ਯਾਸ਼੍ਚਰ੍ੱਯਾਣਿ ਕਰ੍ੰਮਣ੍ਯਕਾਰਿਸ਼਼ਤ, ਯਦਿ ਤਾਨਿ ਸਿਦੋਮ੍ਨਗਰ ਅਕਾਰਿਸ਼਼੍ਯਨ੍ਤ, ਤਰ੍ਹਿ ਤਦਦ੍ਯ ਯਾਵਦਸ੍ਥਾਸ੍ਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","ਕਿਨ੍ਤ੍ਵਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਵਦਾਮਿ, ਵਿਚਾਰਦਿਨੇ ਤਵ ਦਣ੍ਡਤਃ ਸਿਦੋਮੋ ਦਣ੍ਡੋ ਸਹ੍ਯਤਰੋ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ਏਤਸ੍ਮਿੰਨੇਵ ਸਮਯੇ ਯੀਸ਼ੁਃ ਪੁਨਰੁਵਾਚ, ਹੇ ਸ੍ਵਰ੍ਗਪ੍ਰੁʼਥਿਵ੍ਯੋਰੇਕਾਧਿਪਤੇ ਪਿਤਸ੍ਤ੍ਵੰ ਜ੍ਞਾਨਵਤੋ ਵਿਦੁਸ਼਼ਸ਼੍ਚ ਲੋਕਾਨ੍ ਪ੍ਰਤ੍ਯੇਤਾਨਿ ਨ ਪ੍ਰਕਾਸ਼੍ਯ ਬਾਲਕਾਨ੍ ਪ੍ਰਤਿ ਪ੍ਰਕਾਸ਼ਿਤਵਾਨ੍, ਇਤਿ ਹੇਤੋਸ੍ਤ੍ਵਾਂ ਧਨ੍ਯੰ ਵਦਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ਹੇ ਪਿਤਃ, ਇੱਥੰ ਭਵੇਤ੍ ਯਤ ਇਦੰ ਤ੍ਵਦ੍ਰੁʼਸ਼਼੍ਟਾਵੁੱਤਮੰ| ");
INSERT INTO sanpun_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","ਪਿਤ੍ਰਾ ਮਯਿ ਸਰ੍ੱਵਾਣਿ ਸਮਰ੍ਪਿਤਾਨਿ, ਪਿਤਰੰ ਵਿਨਾ ਕੋਪਿ ਪੁਤ੍ਰੰ ਨ ਜਾਨਾਤਿ, ਯਾਨ੍ ਪ੍ਰਤਿ ਪੁਤ੍ਰੇਣ ਪਿਤਾ ਪ੍ਰਕਾਸ਼੍ਯਤੇ ਤਾਨ੍ ਵਿਨਾ ਪੁਤ੍ਰਾਦ੍ ਅਨ੍ਯਃ ਕੋਪਿ ਪਿਤਰੰ ਨ ਜਾਨਾਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","ਹੇ ਪਰਿਸ਼੍ਰਾਨ੍ਤਾ ਭਾਰਾਕ੍ਰਾਨ੍ਤਾਸ਼੍ਚ ਲੋਕਾ ਯੂਯੰ ਮਤ੍ਸੰਨਿਧਿਮ੍ ਆਗੱਛਤ, ਅਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਵਿਸ਼੍ਰਮਯਿਸ਼਼੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ਅਹੰ ਕ੍ਸ਼਼ਮਣਸ਼ੀਲੋ ਨਮ੍ਰਮਨਾਸ਼੍ਚ, ਤਸ੍ਮਾਤ੍ ਮਮ ਯੁਗੰ ਸ੍ਵੇਸ਼਼ਾਮੁਪਰਿ ਧਾਰਯਤ ਮੱਤਃ ਸ਼ਿਕ੍ਸ਼਼ਧ੍ਵਞ੍ਚ, ਤੇਨ ਯੂਯੰ ਸ੍ਵੇ ਸ੍ਵੇ ਮਨਸਿ ਵਿਸ਼੍ਰਾਮੰ ਲਪ੍ਸ੍ਯਧ੍ਬੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ਯਤੋ ਮਮ ਯੁਗਮ੍ ਅਨਾਯਾਸੰ ਮਮ ਭਾਰਸ਼੍ਚ ਲਘੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","ਅਨਨ੍ਤਰੰ ਯੀਸ਼ੁ ਰ੍ਵਿਸ਼੍ਰਾਮਵਾਰੇ ਸ਼੍ਸ੍ਯਮਧ੍ਯੇਨ ਗੱਛਤਿ, ਤਦਾ ਤੱਛਿਸ਼਼੍ਯਾ ਬੁਭੁਕ੍ਸ਼਼ਿਤਾਃ ਸਨ੍ਤਃ ਸ਼੍ਸ੍ਯਮਞ੍ਜਰੀਸ਼੍ਛਤ੍ਵਾ ਛਿਤ੍ਵਾ ਖਾਦਿਤੁਮਾਰਭਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ਤਦ੍ ਵਿਲੋਕ੍ਯ ਫਿਰੂਸ਼ਿਨੋ ਯੀਸ਼ੁੰ ਜਗਦੁਃ, ਪਸ਼੍ਯ ਵਿਸ਼੍ਰਾਮਵਾਰੇ ਯਤ੍ ਕਰ੍ੰਮਾਕਰ੍ੱਤਵ੍ਯੰ ਤਦੇਵ ਤਵ ਸ਼ਿਸ਼਼੍ਯਾਃ ਕੁਰ੍ੱਵਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ਸ ਤਾਨ੍ ਪ੍ਰਤ੍ਯਾਵਦਤ, ਦਾਯੂਦ੍ ਤਤ੍ਸਙ੍ਗਿਨਸ਼੍ਚ ਬੁਭੁਕ੍ਸ਼਼ਿਤਾਃ ਸਨ੍ਤੋ ਯਤ੍ ਕਰ੍ੰਮਾਕੁਰ੍ੱਵਨ੍ ਤਤ੍ ਕਿੰ ਯੁਸ਼਼੍ਮਾਭਿ ਰ੍ਨਾਪਾਠਿ? ");
INSERT INTO sanpun_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ਯੇ ਦਰ੍ਸ਼ਨੀਯਾਃ ਪੂਪਾਃ ਯਾਜਕਾਨ੍ ਵਿਨਾ ਤਸ੍ਯ ਤਤ੍ਸਙ੍ਗਿਮਨੁਜਾਨਾਞ੍ਚਾਭੋਜਨੀਯਾਸ੍ਤ ਈਸ਼੍ਵਰਾਵਾਸੰ ਪ੍ਰਵਿਸ਼਼੍ਟੇਨ ਤੇਨ ਭੁਕ੍ਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","ਅਨ੍ਯੱਚ ਵਿਸ਼੍ਰਾਮਵਾਰੇ ਮਧ੍ਯੇਮਨ੍ਦਿਰੰ ਵਿਸ਼੍ਰਾਮਵਾਰੀਯੰ ਨਿਯਮੰ ਲਙ੍ਵਨ੍ਤੋਪਿ ਯਾਜਕਾ ਨਿਰ੍ਦੋਸ਼਼ਾ ਭਵਨ੍ਤਿ, ਸ਼ਾਸ੍ਤ੍ਰਮਧ੍ਯੇ ਕਿਮਿਦਮਪਿ ਯੁਸ਼਼੍ਮਾਭਿ ਰ੍ਨ ਪਠਿਤੰ? ");
INSERT INTO sanpun_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","ਯੁਸ਼਼੍ਮਾਨਹੰ ਵਦਾਮਿ, ਅਤ੍ਰ ਸ੍ਥਾਨੇ ਮਨ੍ਦਿਰਾਦਪਿ ਗਰੀਯਾਨ੍ ਏਕ ਆਸ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","ਕਿਨ੍ਤੁ ਦਯਾਯਾਂ ਮੇ ਯਥਾ ਪ੍ਰੀਤਿ ਰ੍ਨ ਤਥਾ ਯਜ੍ਞਕਰ੍ੰਮਣਿ| ਏਤਦ੍ਵਚਨਸ੍ਯਾਰ੍ਥੰ ਯਦਿ ਯੁਯਮ੍ ਅਜ੍ਞਾਸਿਸ਼਼੍ਟ ਤਰ੍ਹਿ ਨਿਰ੍ਦੋਸ਼਼ਾਨ੍ ਦੋਸ਼਼ਿਣੋ ਨਾਕਾਰ੍ਸ਼਼੍ਟ| ");
INSERT INTO sanpun_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","ਅਨ੍ਯੱਚ ਮਨੁਜਸੁਤੋ ਵਿਸ਼੍ਰਾਮਵਾਰਸ੍ਯਾਪਿ ਪਤਿਰਾਸ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ਅਨਨ੍ਤਰੰ ਸ ਤਤ੍ਸ੍ਥਾਨਾਤ੍ ਪ੍ਰਸ੍ਥਾਯ ਤੇਸ਼਼ਾਂ ਭਜਨਭਵਨੰ ਪ੍ਰਵਿਸ਼਼੍ਟਵਾਨ੍, ਤਦਾਨੀਮ੍ ਏਕਃ ਸ਼ੁਸ਼਼੍ਕਕਰਾਮਯਵਾਨ੍ ਉਪਸ੍ਥਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ਤਤੋ ਯੀਸ਼ੁਮ੍ ਅਪਵਦਿਤੁੰ ਮਾਨੁਸ਼਼ਾਃ ਪਪ੍ਰੱਛੁਃ, ਵਿਸ਼੍ਰਾਮਵਾਰੇ ਨਿਰਾਮਯਤ੍ਵੰ ਕਰਣੀਯੰ ਨ ਵਾ? ");
INSERT INTO sanpun_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ਤੇਨ ਸ ਪ੍ਰਤ੍ਯੁਵਾਚ, ਵਿਸ਼੍ਰਾਮਵਾਰੇ ਯਦਿ ਕਸ੍ਯਚਿਦ੍ ਅਵਿ ਰ੍ਗਰ੍ੱਤੇ ਪਤਤਿ, ਤਰ੍ਹਿ ਯਸ੍ਤੰ ਘ੍ਰੁʼਤ੍ਵਾ ਨ ਤੋਲਯਤਿ, ਏਤਾਦ੍ਰੁʼਸ਼ੋ ਮਨੁਜੋ ਯੁਸ਼਼੍ਮਾਕੰ ਮਧ੍ਯੇ ਕ ਆਸ੍ਤੇ? ");
INSERT INTO sanpun_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ਅਵੇ ਰ੍ਮਾਨਵਃ ਕਿੰ ਨਹਿ ਸ਼੍ਰੇਯਾਨ੍? ਅਤੋ ਵਿਸ਼੍ਰਾਮਵਾਰੇ ਹਿਤਕਰ੍ੰਮ ਕਰ੍ੱਤਵ੍ਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","ਅਨਨ੍ਤਰੰ ਸ ਤੰ ਮਾਨਵੰ ਗਦਿਤਵਾਨ੍, ਕਰੰ ਪ੍ਰਸਾਰਯ; ਤੇਨ ਕਰੇ ਪ੍ਰਸਾਰਿਤੇ ਸੋਨ੍ਯਕਰਵਤ੍ ਸ੍ਵਸ੍ਥੋ(ਅ)ਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ਤਦਾ ਫਿਰੂਸ਼ਿਨੋ ਬਹਿਰ੍ਭੂਯ ਕਥੰ ਤੰ ਹਨਿਸ਼਼੍ਯਾਮ ਇਤਿ ਕੁਮਨ੍ਤ੍ਰਣਾਂ ਤਤ੍ਪ੍ਰਾਤਿਕੂਲ੍ਯੇਨ ਚਕ੍ਰੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ਤਤੋ ਯੀਸ਼ੁਸ੍ਤਦ੍ ਵਿਦਿਤ੍ਵਾ ਸ੍ਥਨਾਨ੍ਤਰੰ ਗਤਵਾਨ੍; ਅਨ੍ਯੇਸ਼਼ੁ ਬਹੁਨਰੇਸ਼਼ੁ ਤਤ੍ਪਸ਼੍ਚਾਦ੍ ਗਤੇਸ਼਼ੁ ਤਾਨ੍ ਸ ਨਿਰਾਮਯਾਨ੍ ਕ੍ਰੁʼਤ੍ਵਾ ਇਤ੍ਯਾਜ੍ਞਾਪਯਤ੍, ");
INSERT INTO sanpun_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ਯੂਯੰ ਮਾਂ ਨ ਪਰਿਚਾਯਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ਤਸ੍ਮਾਤ੍ ਮਮ ਪ੍ਰੀਯੋ ਮਨੋਨੀਤੋ ਮਨਸਸ੍ਤੁਸ਼਼੍ਟਿਕਾਰਕਃ| ਮਦੀਯਃ ਸੇਵਕੋ ਯਸ੍ਤੁ ਵਿਦ੍ਯਤੇ ਤੰ ਸਮੀਕ੍ਸ਼਼ਤਾਂ| ਤਸ੍ਯੋਪਰਿ ਸ੍ਵਕੀਯਾਤ੍ਮਾ ਮਯਾ ਸੰਸ੍ਥਾਪਯਿਸ਼਼੍ਯਤੇ| ਤੇਨਾਨ੍ਯਦੇਸ਼ਜਾਤੇਸ਼਼ੁ ਵ੍ਯਵਸ੍ਥਾ ਸੰਪ੍ਰਕਾਸ਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","ਕੇਨਾਪਿ ਨ ਵਿਰੋਧੰ ਸ ਵਿਵਾਦਞ੍ਚ ਕਰਿਸ਼਼੍ਯਤਿ| ਨ ਚ ਰਾਜਪਥੇ ਤੇਨ ਵਚਨੰ ਸ਼੍ਰਾਵਯਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ਵ੍ਯਵਸ੍ਥਾ ਚਲਿਤਾ ਯਾਵਤ੍ ਨਹਿ ਤੇਨ ਕਰਿਸ਼਼੍ਯਤੇ| ਤਾਵਤ੍ ਨਲੋ ਵਿਦੀਰ੍ਣੋ(ਅ)ਪਿ ਭੰਕ੍ਸ਼਼੍ਯਤੇ ਨਹਿ ਤੇਨ ਚ| ਤਥਾ ਸਧੂਮਵਰ੍ੱਤਿਞ੍ਚ ਨ ਸ ਨਿਰ੍ੱਵਾਪਯਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ਪ੍ਰਤ੍ਯਾਸ਼ਾਞ੍ਚ ਕਰਿਸ਼਼੍ਯਨ੍ਤਿ ਤੰਨਾਮ੍ਨਿ ਭਿੰਨਦੇਸ਼ਜਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ਯਾਨ੍ਯੇਤਾਨਿ ਵਚਨਾਨਿ ਯਿਸ਼ਯਿਯਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਾ ਪ੍ਰੋਕ੍ਤਾਨ੍ਯਾਸਨ੍, ਤਾਨਿ ਸਫਲਾਨ੍ਯਭਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","ਅਨਨ੍ਤਰੰ ਲੋਕੈ ਸ੍ਤਤ੍ਸਮੀਪਮ੍ ਆਨੀਤੋ ਭੂਤਗ੍ਰਸ੍ਤਾਨ੍ਧਮੂਕੈਕਮਨੁਜਸ੍ਤੇਨ ਸ੍ਵਸ੍ਥੀਕ੍ਰੁʼਤਃ, ਤਤਃ ਸੋ(ਅ)ਨ੍ਧੋ ਮੂਕੋ ਦ੍ਰਸ਼਼੍ਟੁੰ ਵਕ੍ਤੁਞ੍ਚਾਰਬ੍ਧਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ਅਨੇਨ ਸਰ੍ੱਵੇ ਵਿਸ੍ਮਿਤਾਃ ਕਥਯਾਞ੍ਚਕ੍ਰੁਃ, ਏਸ਼਼ਃ ਕਿੰ ਦਾਯੂਦਃ ਸਨ੍ਤਾਨੋ ਨਹਿ? ");
INSERT INTO sanpun_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","ਕਿਨ੍ਤੁ ਫਿਰੂਸ਼ਿਨਸ੍ਤਤ੍ ਸ਼੍ਰੁਤ੍ਵਾ ਗਦਿਤਵਨ੍ਤਃ, ਬਾਲ੍ਸਿਬੂਬ੍ਨਾਮ੍ਨੋ ਭੂਤਰਾਜਸ੍ਯ ਸਾਹਾੱਯੰ ਵਿਨਾ ਨਾਯੰ ਭੂਤਾਨ੍ ਤ੍ਯਾਜਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ਤਦਾਨੀਂ ਯੀਸ਼ੁਸ੍ਤੇਸ਼਼ਾਮ੍ ਇਤਿ ਮਾਨਸੰ ਵਿਜ੍ਞਾਯ ਤਾਨ੍ ਅਵਦਤ੍ ਕਿਞ੍ਚਨ ਰਾਜ੍ਯੰ ਯਦਿ ਸ੍ਵਵਿਪਕ੍ਸ਼਼ਾਦ੍ ਭਿਦ੍ਯਤੇ, ਤਰ੍ਹਿ ਤਤ੍ ਉੱਛਿਦ੍ਯਤੇ; ਯੱਚ ਕਿਞ੍ਚਨ ਨਗਰੰ ਵਾ ਗ੍ਰੁʼਹੰ ਸ੍ਵਵਿਪਕ੍ਸ਼਼ਾਦ੍ ਵਿਭਿਦ੍ਯਤੇ, ਤਤ੍ ਸ੍ਥਾਤੁੰ ਨ ਸ਼ਕ੍ਨੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","ਤਦ੍ਵਤ੍ ਸ਼ਯਤਾਨੋ ਯਦਿ ਸ਼ਯਤਾਨੰ ਬਹਿਃ ਕ੍ਰੁʼਤ੍ਵਾ ਸ੍ਵਵਿਪਕ੍ਸ਼਼ਾਤ੍ ਪ੍ਰੁʼਥਕ੍ ਪ੍ਰੁʼਥਕ੍ ਭਵਤਿ, ਤਰ੍ਹਿ ਤਸ੍ਯ ਰਾਜ੍ਯੰ ਕੇਨ ਪ੍ਰਕਾਰੇਣ ਸ੍ਥਾਸ੍ਯਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ਅਹਞ੍ਚ ਯਦਿ ਬਾਲ੍ਸਿਬੂਬਾ ਭੂਤਾਨ੍ ਤ੍ਯਾਜਯਾਮਿ, ਤਰ੍ਹਿ ਯੁਸ਼਼੍ਮਾਕੰ ਸਨ੍ਤਾਨਾਃ ਕੇਨ ਭੂਤਾਨ੍ ਤ੍ਯਾਜਯਨ੍ਤਿ? ਤਸ੍ਮਾਦ੍ ਯੁਸ਼਼੍ਮਾਕਮ੍ ਏਤਦ੍ਵਿਚਾਰਯਿਤਾਰਸ੍ਤ ਏਵ ਭਵਿਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","ਕਿਨ੍ਤਵਹੰ ਯਦੀਸ਼੍ਵਰਾਤ੍ਮਨਾ ਭੂਤਾਨ੍ ਤ੍ਯਾਜਯਾਮਿ, ਤਰ੍ਹੀਸ਼੍ਵਰਸ੍ਯ ਰਾਜ੍ਯੰ ਯੁਸ਼਼੍ਮਾਕੰ ਸੰਨਿਧਿਮਾਗਤਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","ਅਨ੍ਯਞ੍ਚ ਕੋਪਿ ਬਲਵਨ੍ਤ ਜਨੰ ਪ੍ਰਥਮਤੋ ਨ ਬਦ੍ੱਵਾ ਕੇਨ ਪ੍ਰਕਾਰੇਣ ਤਸ੍ਯ ਗ੍ਰੁʼਹੰ ਪ੍ਰਵਿਸ਼੍ਯ ਤੱਦ੍ਰਵ੍ਯਾਦਿ ਲੋਠਯਿਤੁੰ ਸ਼ਕ੍ਨੋਤਿ? ਕਿਨ੍ਤੁ ਤਤ੍ ਕ੍ਰੁʼਤ੍ਵਾ ਤਦੀਯਗ੍ਰੁʼਸ੍ਯ ਦ੍ਰਵ੍ਯਾਦਿ ਲੋਠਯਿਤੁੰ ਸ਼ਕ੍ਨੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","ਯਃ ਕਸ਼੍ਚਿਤ੍ ਮਮ ਸ੍ਵਪਕ੍ਸ਼਼ੀਯੋ ਨਹਿ ਸ ਵਿਪਕ੍ਸ਼਼ੀਯ ਆਸ੍ਤੇ, ਯਸ਼੍ਚ ਮਯਾ ਸਾਕੰ ਨ ਸੰਗ੍ਰੁʼਹ੍ਲਾਤਿ, ਸ ਵਿਕਿਰਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ਅਤਏਵ ਯੁਸ਼਼੍ਮਾਨਹੰ ਵਦਾਮਿ, ਮਨੁਜਾਨਾਂ ਸਰ੍ੱਵਪ੍ਰਕਾਰਪਾਪਾਨਾਂ ਨਿਨ੍ਦਾਯਾਸ਼੍ਚ ਮਰ੍ਸ਼਼ਣੰ ਭਵਿਤੁੰ ਸ਼ਕ੍ਨੋਤਿ, ਕਿਨ੍ਤੁ ਪਵਿਤ੍ਰਸ੍ਯਾਤ੍ਮਨੋ ਵਿਰੁੱਧਨਿਨ੍ਦਾਯਾ ਮਰ੍ਸ਼਼ਣੰ ਭਵਿਤੁੰ ਨ ਸ਼ਕ੍ਨੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","ਯੋ ਮਨੁਜਸੁਤਸ੍ਯ ਵਿਰੁੱਧਾਂ ਕਥਾਂ ਕਥਯਤਿ, ਤਸ੍ਯਾਪਰਾਧਸ੍ਯ ਕ੍ਸ਼਼ਮਾ ਭਵਿਤੁੰ ਸ਼ਕ੍ਨੋਤਿ, ਕਿਨ੍ਤੁ ਯਃ ਕਸ਼੍ਚਿਤ੍ ਪਵਿਤ੍ਰਸ੍ਯਾਤ੍ਮਨੋ ਵਿਰੁੱਧਾਂ ਕਥਾਂ ਕਥਯਤਿ ਨੇਹਲੋਕੇ ਨ ਪ੍ਰੇਤ੍ਯ ਤਸ੍ਯਾਪਰਾਧਸ੍ਯ ਕ੍ਸ਼਼ਮਾ ਭਵਿਤੁੰ ਸ਼ਕ੍ਨੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","ਪਾਦਪੰ ਯਦਿ ਭਦ੍ਰੰ ਵਦਥ, ਤਰ੍ਹਿ ਤਸ੍ਯ ਫਲਮਪਿ ਸਾਧੁ ਵਕ੍ਤਵ੍ਯੰ, ਯਦਿ ਚ ਪਾਦਪੰ ਅਸਾਧੁੰ ਵਦਥ, ਤਰ੍ਹਿ ਤਸ੍ਯ ਫਲਮਪ੍ਯਸਾਧੁ ਵਕ੍ਤਵ੍ਯੰ; ਯਤਃ ਸ੍ਵੀਯਸ੍ਵੀਯਫਲੇਨ ਪਾਦਪਃ ਪਰਿਚੀਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","ਰੇ ਭੁਜਗਵੰਸ਼ਾ ਯੂਯਮਸਾਧਵਃ ਸਨ੍ਤਃ ਕਥੰ ਸਾਧੁ ਵਾਕ੍ਯੰ ਵਕ੍ਤੁੰ ਸ਼ਕ੍ਸ਼਼੍ਯਥ? ਯਸ੍ਮਾਦ੍ ਅਨ੍ਤਃਕਰਣਸ੍ਯ ਪੂਰ੍ਣਭਾਵਾਨੁਸਾਰਾਦ੍ ਵਦਨਾਦ੍ ਵਚੋ ਨਿਰ੍ਗੱਛਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","ਤੇਨ ਸਾਧੁਰ੍ਮਾਨਵੋ(ਅ)ਨ੍ਤਃਕਰਣਰੂਪਾਤ੍ ਸਾਧੁਭਾਣ੍ਡਾਗਾਰਾਤ੍ ਸਾਧੁ ਦ੍ਰਵ੍ਯੰ ਨਿਰ੍ਗਮਯਤਿ, ਅਸਾਧੁਰ੍ਮਾਨੁਸ਼਼ਸ੍ਤ੍ਵਸਾਧੁਭਾਣ੍ਡਾਗਾਰਾਦ੍ ਅਸਾਧੁਵਸ੍ਤੂਨਿ ਨਿਰ੍ਗਮਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","ਕਿਨ੍ਤ੍ਵਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਵਦਾਮਿ, ਮਨੁਜਾ ਯਾਵਨ੍ਤ੍ਯਾਲਸ੍ਯਵਚਾਂਸਿ ਵਦਨ੍ਤਿ, ਵਿਚਾਰਦਿਨੇ ਤਦੁੱਤਰਮਵਸ਼੍ਯੰ ਦਾਤਵ੍ਯੰ, ");
INSERT INTO sanpun_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","ਯਤਸ੍ਤ੍ਵੰ ਸ੍ਵੀਯਵਚੋਭਿ ਰ੍ਨਿਰਪਰਾਧਃ ਸ੍ਵੀਯਵਚੋਭਿਸ਼੍ਚ ਸਾਪਰਾਧੋ ਗਣਿਸ਼਼੍ਯਸੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","ਤਦਾਨੀਂ ਕਤਿਪਯਾ ਉਪਾਧ੍ਯਾਯਾਃ ਫਿਰੂਸ਼ਿਨਸ਼੍ਚ ਜਗਦੁਃ, ਹੇ ਗੁਰੋ ਵਯੰ ਭਵੱਤਃ ਕਿਞ੍ਚਨ ਲਕ੍ਸ਼਼੍ਮ ਦਿਦ੍ਰੁʼਕ੍ਸ਼਼ਾਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ਤਦਾ ਸ ਪ੍ਰਤ੍ਯੁਕ੍ਤਵਾਨ੍, ਦੁਸ਼਼੍ਟੋ ਵ੍ਯਭਿਚਾਰੀ ਚ ਵੰਸ਼ੋ ਲਕ੍ਸ਼਼੍ਮ ਮ੍ਰੁʼਗਯਤੇ, ਕਿਨ੍ਤੁ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨੋ ਯੂਨਸੋ ਲਕ੍ਸ਼਼੍ਮ ਵਿਹਾਯਾਨ੍ਯਤ੍ ਕਿਮਪਿ ਲਕ੍ਸ਼਼੍ਮ ਤੇ ਨ ਪ੍ਰਦਰ੍ਸ਼ਯਿਸ਼਼੍ਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ਯਤੋ ਯੂਨਮ੍ ਯਥਾ ਤ੍ਰ੍ਯਹੋਰਾਤ੍ਰੰ ਬ੍ਰੁʼਹਨ੍ਮੀਨਸ੍ਯ ਕੁਕ੍ਸ਼਼ਾਵਾਸੀਤ੍, ਤਥਾ ਮਨੁਜਪੁਤ੍ਰੋਪਿ ਤ੍ਰ੍ਯਹੋਰਾਤ੍ਰੰ ਮੇਦਿਨ੍ਯਾ ਮਧ੍ਯੇ ਸ੍ਥਾਸ੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","ਅਪਰੰ ਨੀਨਿਵੀਯਾ ਮਾਨਵਾ ਵਿਚਾਰਦਿਨ ਏਤਦ੍ਵੰਸ਼ੀਯਾਨਾਂ ਪ੍ਰਤਿਕੂਲਮ੍ ਉੱਥਾਯ ਤਾਨ੍ ਦੋਸ਼਼ਿਣਃ ਕਰਿਸ਼਼੍ਯਨ੍ਤਿ, ਯਸ੍ਮਾੱਤੇ ਯੂਨਸ ਉਪਦੇਸ਼ਾਤ੍ ਮਨਾਂਸਿ ਪਰਾਵਰ੍ੱਤਯਾਞ੍ਚਕ੍ਰਿਰੇ, ਕਿਨ੍ਤ੍ਵਤ੍ਰ ਯੂਨਸੋਪਿ ਗੁਰੁਤਰ ਏਕ ਆਸ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","ਪੁਨਸ਼੍ਚ ਦਕ੍ਸ਼਼ਿਣਦੇਸ਼ੀਯਾ ਰਾਜ੍ਞੀ ਵਿਚਾਰਦਿਨ ਏਤਦ੍ਵੰਸ਼ੀਯਾਨਾਂ ਪ੍ਰਤਿਕੂਲਮੁੱਥਾਯ ਤਾਨ੍ ਦੋਸ਼਼ਿਣਃ ਕਰਿਸ਼਼੍ਯਤਿ ਯਤਃ ਸਾ ਰਾਜ੍ਞੀ ਸੁਲੇਮਨੋ ਵਿਦ੍ਯਾਯਾਃ ਕਥਾਂ ਸ਼੍ਰੋਤੁੰ ਮੇਦਿਨ੍ਯਾਃ ਸੀਮ੍ਨ ਆਗੱਛਤ੍, ਕਿਨ੍ਤੁ ਸੁਲੇਮਨੋਪਿ ਗੁਰੁਤਰ ਏਕੋ ਜਨੋ(ਅ)ਤ੍ਰ ਆਸ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","ਅਪਰੰ ਮਨੁਜਾਦ੍ ਬਹਿਰ੍ਗਤੋ (ਅ)ਪਵਿਤ੍ਰਭੂਤਃ ਸ਼ੁਸ਼਼੍ਕਸ੍ਥਾਨੇਨ ਗਤ੍ਵਾ ਵਿਸ਼੍ਰਾਮੰ ਗਵੇਸ਼਼ਯਤਿ, ਕਿਨ੍ਤੁ ਤਦਲਭਮਾਨਃ ਸ ਵਕ੍ਤਿ, ਯਸ੍ਮਾ; ਨਿਕੇਤਨਾਦ੍ ਆਗਮੰ, ਤਦੇਵ ਵੇਸ਼੍ਮ ਪਕਾਵ੍ਰੁʼਤ੍ਯ ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ਪਸ਼੍ਚਾਤ੍ ਸ ਤਤ੍ ਸ੍ਥਾਨਮ੍ ਉਪਸ੍ਥਾਯ ਤਤ੍ ਸ਼ੂਨ੍ਯੰ ਮਾਰ੍ੱਜਿਤੰ ਸ਼ੋਭਿਤਞ੍ਚ ਵਿਲੋਕ੍ਯ ਵ੍ਰਜਨ੍ ਸ੍ਵਤੋਪਿ ਦੁਸ਼਼੍ਟਤਰਾਨ੍ ਅਨ੍ਯਸਪ੍ਤਭੂਤਾਨ੍ ਸਙ੍ਗਿਨਃ ਕਰੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ਤਤਸ੍ਤੇ ਤਤ੍ ਸ੍ਥਾਨੰ ਪ੍ਰਵਿਸ਼੍ਯ ਨਿਵਸਨ੍ਤਿ, ਤੇਨ ਤਸ੍ਯ ਮਨੁਜਸ੍ਯ ਸ਼ੇਸ਼਼ਦਸ਼ਾ ਪੂਰ੍ੱਵਦਸ਼ਾਤੋਤੀਵਾਸ਼ੁਭਾ ਭਵਤਿ, ਏਤੇਸ਼਼ਾਂ ਦੁਸ਼਼੍ਟਵੰਸ਼੍ਯਾਨਾਮਪਿ ਤਥੈਵ ਘਟਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","ਮਾਨਵੇਭ੍ਯ ਏਤਾਸਾਂ ਕਥਨਾਂ ਕਥਨਕਾਲੇ ਤਸ੍ਯ ਮਾਤਾ ਸਹਜਾਸ਼੍ਚ ਤੇਨ ਸਾਕੰ ਕਾਞ੍ਚਿਤ੍ ਕਥਾਂ ਕਥਯਿਤੁੰ ਵਾਞ੍ਛਨ੍ਤੋ ਬਹਿਰੇਵ ਸ੍ਥਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ਤਤਃ ਕਸ਼੍ਚਿਤ੍ ਤਸ੍ਮੈ ਕਥਿਤਵਾਨ੍, ਪਸ਼੍ਯ ਤਵ ਜਨਨੀ ਸਹਜਾਸ਼੍ਚ ਤ੍ਵਯਾ ਸਾਕੰ ਕਾਞ੍ਚਨ ਕਥਾਂ ਕਥਯਿਤੁੰ ਕਾਮਯਮਾਨਾ ਬਹਿਸ੍ਤਿਸ਼਼੍ਠਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","ਕਿਨ੍ਤੁ ਸ ਤੰ ਪ੍ਰਤ੍ਯਵਦਤ੍, ਮਮ ਕਾ ਜਨਨੀ? ਕੇ ਵਾ ਮਮ ਸਹਜਾਃ? ");
INSERT INTO sanpun_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ਪਸ਼੍ਚਾਤ੍ ਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਪ੍ਰਤਿ ਕਰੰ ਪ੍ਰਸਾਰ੍ੱਯ ਕਥਿਤਵਾਨ੍, ਪਸ਼੍ਯ ਮਮ ਜਨਨੀ ਮਮ ਸਹਜਾਸ਼੍ਚੈਤੇ; ");
INSERT INTO sanpun_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ਯਃ ਕਸ਼੍ਚਿਤ੍ ਮਮ ਸ੍ਵਰ੍ਗਸ੍ਥਸ੍ਯ ਪਿਤੁਰਿਸ਼਼੍ਟੰ ਕਰ੍ੰਮ ਕੁਰੁਤੇ, ਸਏਵ ਮਮ ਭ੍ਰਾਤਾ ਭਗਿਨੀ ਜਨਨੀ ਚ| ");
INSERT INTO sanpun_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","ਅਪਰਞ੍ਚ ਤਸ੍ਮਿਨ੍ ਦਿਨੇ ਯੀਸ਼ੁਃ ਸਦ੍ਮਨੋ ਗਤ੍ਵਾ ਸਰਿਤ੍ਪਤੇ ਰੋਧਸਿ ਸਮੁਪਵਿਵੇਸ਼| ");
INSERT INTO sanpun_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ਤਤ੍ਰ ਤਤ੍ਸੰਨਿਧੌ ਬਹੁਜਨਾਨਾਂ ਨਿਵਹੋਪਸ੍ਥਿਤੇਃ ਸ ਤਰਣਿਮਾਰੁਹ੍ਯ ਸਮੁਪਾਵਿਸ਼ਤ੍, ਤੇਨ ਮਾਨਵਾ ਰੋਧਸਿ ਸ੍ਥਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ਤਦਾਨੀਂ ਸ ਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤੈਸ੍ਤਾਨ੍ ਇੱਥੰ ਬਹੁਸ਼ ਉਪਦਿਸ਼਼੍ਟਵਾਨ੍| ਪਸ਼੍ਯਤ, ਕਸ਼੍ਚਿਤ੍ ਕ੍ਰੁʼਸ਼਼ੀਵਲੋ ਬੀਜਾਨਿ ਵਪ੍ਤੁੰ ਬਹਿਰ੍ਜਗਾਮ, ");
INSERT INTO sanpun_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ਤਸ੍ਯ ਵਪਨਕਾਲੇ ਕਤਿਪਯਬੀਜੇਸ਼਼ੁ ਮਾਰ੍ਗਪਾਰ੍ਸ਼੍ਵੇ ਪਤਿਤੇਸ਼਼ੁ ਵਿਹਗਾਸ੍ਤਾਨਿ ਭਕ੍ਸ਼਼ਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","ਅਪਰੰ ਕਤਿਪਯਬੀਜੇਸ਼਼ੁ ਸ੍ਤੋਕਮ੍ਰੁʼਦ੍ਯੁਕ੍ਤਪਾਸ਼਼ਾਣੇ ਪਤਿਤੇਸ਼਼ੁ ਮ੍ਰੁʼਦਲ੍ਪਤ੍ਵਾਤ੍ ਤਤ੍ਕ੍ਸ਼਼ਣਾਤ੍ ਤਾਨ੍ਯਙ੍ਕੁਰਿਤਾਨਿ, ");
INSERT INTO sanpun_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ਕਿਨ੍ਤੁ ਰਵਾਵੁਦਿਤੇ ਦਗ੍ਧਾਨਿ ਤੇਸ਼਼ਾਂ ਮੂਲਾਪ੍ਰਵਿਸ਼਼੍ਟਤ੍ਵਾਤ੍ ਸ਼ੁਸ਼਼੍ਕਤਾਂ ਗਤਾਨਿ ਚ| ");
INSERT INTO sanpun_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","ਅਪਰੰ ਕਤਿਪਯਬੀਜੇਸ਼਼ੁ ਕਣ੍ਟਕਾਨਾਂ ਮਧ੍ਯੇ ਪਤਿਤੇਸ਼਼ੁ ਕਣ੍ਟਕਾਨ੍ਯੇਧਿਤ੍ਵਾ ਤਾਨਿ ਜਗ੍ਰਸੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","ਅਪਰਞ੍ਚ ਕਤਿਪਯਬੀਜਾਨਿ ਉਰ੍ੱਵਰਾਯਾਂ ਪਤਿਤਾਨਿ; ਤੇਸ਼਼ਾਂ ਮਧ੍ਯੇ ਕਾਨਿਚਿਤ੍ ਸ਼ਤਗੁਣਾਨਿ ਕਾਨਿਚਿਤ੍ ਸ਼਼ਸ਼਼੍ਟਿਗੁਣਾਨਿ ਕਾਨਿਚਿਤ੍ ਤ੍ਰਿੰਸ਼ਗੁੰਣਾਨਿ ਫਲਾਨਿ ਫਲਿਤਵਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ਸ਼੍ਰੋਤੁੰ ਯਸ੍ਯ ਸ਼੍ਰੁਤੀ ਆਸਾਤੇ ਸ ਸ਼੍ਰੁʼਣੁਯਾਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","ਅਨਨ੍ਤਰੰ ਸ਼ਿਸ਼਼੍ਯੈਰਾਗਤ੍ਯ ਸੋ(ਅ)ਪ੍ਰੁʼੱਛ੍ਯਤ, ਭਵਤਾ ਤੇਭ੍ਯਃ ਕੁਤੋ ਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤਕਥਾ ਕਥ੍ਯਤੇ? ");
INSERT INTO sanpun_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ਤਤਃ ਸ ਪ੍ਰਤ੍ਯਵਦਤ੍, ਸ੍ਵਰ੍ਗਰਾਜ੍ਯਸ੍ਯ ਨਿਗੂਢਾਂ ਕਥਾਂ ਵੇਦਿਤੁੰ ਯੁਸ਼਼੍ਮਭ੍ਯੰ ਸਾਮਰ੍ਥ੍ਯਮਦਾਯਿ, ਕਿਨ੍ਤੁ ਤੇਭ੍ਯੋ ਨਾਦਾਯਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","ਯਸ੍ਮਾਦ੍ ਯਸ੍ਯਾਨ੍ਤਿਕੇ ਵਰ੍ੱਧਤੇ, ਤਸ੍ਮਾਯੇਵ ਦਾਯਿਸ਼਼੍ਯਤੇ, ਤਸ੍ਮਾਤ੍ ਤਸ੍ਯ ਬਾਹੁਲ੍ਯੰ ਭਵਿਸ਼਼੍ਯਤਿ, ਕਿਨ੍ਤੁ ਯਸ੍ਯਾਨ੍ਤਿਕੇ ਨ ਵਰ੍ੱਧਤੇ, ਤਸ੍ਯ ਯਤ੍ ਕਿਞ੍ਚਨਾਸ੍ਤੇ, ਤਦਪਿ ਤਸ੍ਮਾਦ੍ ਆਦਾਯਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","ਤੇ ਪਸ਼੍ਯਨ੍ਤੋਪਿ ਨ ਪਸ਼੍ਯਨ੍ਤਿ, ਸ਼੍ਰੁʼਣ੍ਵਨ੍ਤੋਪਿ ਨ ਸ਼੍ਰੁʼਣ੍ਵਨ੍ਤਿ, ਬੁਧ੍ਯਮਾਨਾ ਅਪਿ ਨ ਬੁਧ੍ਯਨ੍ਤੇ ਚ, ਤਸ੍ਮਾਤ੍ ਤੇਭ੍ਯੋ ਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤਕਥਾ ਕਥ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","ਯਥਾ ਕਰ੍ਣੈਃ ਸ਼੍ਰੋਸ਼਼੍ਯਥ ਯੂਯੰ ਵੈ ਕਿਨ੍ਤੁ ਯੂਯੰ ਨ ਭੋਤ੍ਸ੍ਯਥ| ਨੇਤ੍ਰੈਰ੍ਦ੍ਰਕ੍ਸ਼਼੍ਯਥ ਯੂਯਞ੍ਚ ਪਰਿਜ੍ਞਾਤੁੰ ਨ ਸ਼ਕ੍ਸ਼਼੍ਯਥ| ਤੇ ਮਾਨੁਸ਼਼ਾ ਯਥਾ ਨੈਵ ਪਰਿਪਸ਼੍ਯਨ੍ਤਿ ਲੋਚਨੈਃ| ਕਰ੍ਣੈ ਰ੍ਯਥਾ ਨ ਸ਼੍ਰੁʼਣ੍ਵਨ੍ਤਿ ਨ ਬੁਧ੍ਯਨ੍ਤੇ ਚ ਮਾਨਸੈਃ| ਵ੍ਯਾਵਰ੍ੱਤਿਤੇਸ਼਼ੁ ਚਿੱਤੇਸ਼਼ੁ ਕਾਲੇ ਕੁਤ੍ਰਾਪਿ ਤੈਰ੍ਜਨੈਃ| ਮੱਤਸ੍ਤੇ ਮਨੁਜਾਃ ਸ੍ਵਸ੍ਥਾ ਯਥਾ ਨੈਵ ਭਵਨ੍ਤਿ ਚ| ਤਥਾ ਤੇਸ਼਼ਾਂ ਮਨੁਸ਼਼੍ਯਾਣਾਂ ਕ੍ਰਿਯਨ੍ਤੇ ਸ੍ਥੂਲਬੁੱਧਯਃ| ਬਧਿਰੀਭੂਤਕਰ੍ਣਾਸ਼੍ਚ ਜਾਤਾਸ਼੍ਚ ਮੁਦ੍ਰਿਤਾ ਦ੍ਰੁʼਸ਼ਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ਯਦੇਤਾਨਿ ਵਚਨਾਨਿ ਯਿਸ਼ਯਿਯਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਾ ਪ੍ਰੋਕ੍ਤਾਨਿ ਤੇਸ਼਼ੁ ਤਾਨਿ ਫਲਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","ਕਿਨ੍ਤੁ ਯੁਸ਼਼੍ਮਾਕੰ ਨਯਨਾਨਿ ਧਨ੍ਯਾਨਿ, ਯਸ੍ਮਾਤ੍ ਤਾਨਿ ਵੀਕ੍ਸ਼਼ਨ੍ਤੇ; ਧਨ੍ਯਾਸ਼੍ਚ ਯੁਸ਼਼੍ਮਾਕੰ ਸ਼ਬ੍ਦਗ੍ਰਹਾਃ, ਯਸ੍ਮਾਤ੍ ਤੈਰਾਕਰ੍ਣ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","ਮਯਾ ਯੂਯੰ ਤਥ੍ਯੰ ਵਚਾਮਿ ਯੁਸ਼਼੍ਮਾਭਿ ਰ੍ਯਦ੍ਯਦ੍ ਵੀਕ੍ਸ਼਼੍ਯਤੇ, ਤਦ੍ ਬਹਵੋ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨੋ ਧਾਰ੍ੰਮਿਕਾਸ਼੍ਚ ਮਾਨਵਾ ਦਿਦ੍ਰੁʼਕ੍ਸ਼਼ਨ੍ਤੋਪਿ ਦ੍ਰਸ਼਼੍ਟੁੰ ਨਾਲਭਨ੍ਤ, ਪੁਨਸ਼੍ਚ ਯੂਯੰ ਯਦ੍ਯਤ੍ ਸ਼੍ਰੁʼਣੁਥ, ਤਤ੍ ਤੇ ਸ਼ੁਸ਼੍ਰੂਸ਼਼ਮਾਣਾ ਅਪਿ ਸ਼੍ਰੋਤੁੰ ਨਾਲਭਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","ਕ੍ਰੁʼਸ਼਼ੀਵਲੀਯਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤਸ੍ਯਾਰ੍ਥੰ ਸ਼੍ਰੁʼਣੁਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","ਮਾਰ੍ਗਪਾਰ੍ਸ਼੍ਵੇ ਬੀਜਾਨ੍ਯੁਪ੍ਤਾਨਿ ਤਸ੍ਯਾਰ੍ਥ ਏਸ਼਼ਃ, ਯਦਾ ਕਸ਼੍ਚਿਤ੍ ਰਾਜ੍ਯਸ੍ਯ ਕਥਾਂ ਨਿਸ਼ਮ੍ਯ ਨ ਬੁਧ੍ਯਤੇ, ਤਦਾ ਪਾਪਾਤ੍ਮਾਗਤ੍ਯ ਤਦੀਯਮਨਸ ਉਪ੍ਤਾਂ ਕਥਾਂ ਹਰਨ੍ ਨਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","ਅਪਰੰ ਪਾਸ਼਼ਾਣਸ੍ਥਲੇ ਬੀਜਾਨ੍ਯੁਪ੍ਤਾਨਿ ਤਸ੍ਯਾਰ੍ਥ ਏਸ਼਼ਃ; ਕਸ਼੍ਚਿਤ੍ ਕਥਾਂ ਸ਼੍ਰੁਤ੍ਵੈਵ ਹਰ੍ਸ਼਼ਚਿੱਤੇਨ ਗ੍ਰੁʼਹ੍ਲਾਤਿ, ");
INSERT INTO sanpun_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ਕਿਨ੍ਤੁ ਤਸ੍ਯ ਮਨਸਿ ਮੂਲਾਪ੍ਰਵਿਸ਼਼੍ਟਤ੍ਵਾਤ੍ ਸ ਕਿਞ੍ਚਿਤ੍ਕਾਲਮਾਤ੍ਰੰ ਸ੍ਥਿਰਸ੍ਤਿਸ਼਼੍ਠਤਿ; ਪਸ਼੍ਚਾਤ ਤਤ੍ਕਥਾਕਾਰਣਾਤ੍ ਕੋਪਿ ਕ੍ਲੇਸ੍ਤਾਡਨਾ ਵਾ ਚੇਤ੍ ਜਾਯਤੇ, ਤਰ੍ਹਿ ਸ ਤਤ੍ਕ੍ਸ਼਼ਣਾਦ੍ ਵਿਘ੍ਨਮੇਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","ਅਪਰੰ ਕਣ੍ਟਕਾਨਾਂ ਮਧ੍ਯੇ ਬੀਜਾਨ੍ਯੁਪ੍ਤਾਨਿ ਤਦਰ੍ਥ ਏਸ਼਼ਃ; ਕੇਨਚਿਤ੍ ਕਥਾਯਾਂ ਸ਼੍ਰੁਤਾਯਾਂ ਸਾਂਸਾਰਿਕਚਿਨ੍ਤਾਭਿ ਰ੍ਭ੍ਰਾਨ੍ਤਿਭਿਸ਼੍ਚ ਸਾ ਗ੍ਰਸ੍ਯਤੇ, ਤੇਨ ਸਾ ਮਾ ਵਿਫਲਾ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ਅਪਰਮ੍ ਉਰ੍ੱਵਰਾਯਾਂ ਬੀਜਾਨ੍ਯੁਪ੍ਤਾਨਿ ਤਦਰ੍ਥ ਏਸ਼਼ਃ; ਯੇ ਤਾਂ ਕਥਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਵੁਧ੍ਯਨ੍ਤੇ, ਤੇ ਫਲਿਤਾਃ ਸਨ੍ਤਃ ਕੇਚਿਤ੍ ਸ਼ਤਗੁਣਾਨਿ ਕੇਚਿਤ ਸ਼਼ਸ਼਼੍ਟਿਗੁਣਾਨਿ ਕੇਚਿੱਚ ਤ੍ਰਿੰਸ਼ਦ੍ਗੁਣਾਨਿ ਫਲਾਨਿ ਜਨਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ਅਨਨ੍ਤਰੰ ਸੋਪਰਾਮੇਕਾਂ ਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤਕਥਾਮੁਪਸ੍ਥਾਪ੍ਯ ਤੇਭ੍ਯਃ ਕਥਯਾਮਾਸ; ਸ੍ਵਰ੍ਗੀਯਰਾਜ੍ਯੰ ਤਾਦ੍ਰੁʼਸ਼ੇਨ ਕੇਨਚਿਦ੍ ਗ੍ਰੁʼਹਸ੍ਥੇਨੋਪਮੀਯਤੇ, ਯੇਨ ਸ੍ਵੀਯਕ੍ਸ਼਼ੇਤ੍ਰੇ ਪ੍ਰਸ਼ਸ੍ਤਬੀਜਾਨ੍ਯੌਪ੍ਯਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ਕਿਨ੍ਤੁ ਕ੍ਸ਼਼ਣਦਾਯਾਂ ਸਕਲਲੋਕੇਸ਼਼ੁ ਸੁਪ੍ਤੇਸ਼਼ੁ ਤਸ੍ਯ ਰਿਪੁਰਾਗਤ੍ਯ ਤੇਸ਼਼ਾਂ ਗੋਧੂਮਬੀਜਾਨਾਂ ਮਧ੍ਯੇ ਵਨ੍ਯਯਵਮਬੀਜਾਨ੍ਯੁਪ੍ਤ੍ਵਾ ਵਵ੍ਰਾਜ| ");
INSERT INTO sanpun_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ਤਤੋ ਯਦਾ ਬੀਜੇਭ੍ਯੋ(ਅ)ਙ੍ਕਰਾ ਜਾਯਮਾਨਾਃ ਕਣਿਸ਼ਾਨਿ ਘ੍ਰੁʼਤਵਨ੍ਤਃ; ਤਦਾ ਵਨ੍ਯਯਵਸਾਨ੍ਯਪਿ ਦ੍ਰੁʼਸ਼੍ਯਮਾਨਾਨ੍ਯਭਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ਤਤੋ ਗ੍ਰੁʼਹਸ੍ਥਸ੍ਯ ਦਾਸੇਯਾ ਆਗਮ੍ਯ ਤਸ੍ਮੈ ਕਥਯਾਞ੍ਚਕ੍ਰੁਃ, ਹੇ ਮਹੇੱਛ, ਭਵਤਾ ਕਿੰ ਕ੍ਸ਼਼ੇਤ੍ਰੇ ਭਦ੍ਰਬੀਜਾਨਿ ਨੌਪ੍ਯਨ੍ਤ? ਤਥਾਤ੍ਵੇ ਵਨ੍ਯਯਵਸਾਨਿ ਕ੍ਰੁʼਤ ਆਯਨ੍? ");
INSERT INTO sanpun_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","ਤਦਾਨੀਂ ਤੇਨ ਤੇ ਪ੍ਰਤਿਗਦਿਤਾਃ, ਕੇਨਚਿਤ੍ ਰਿਪੁਣਾ ਕਰ੍ੰਮਦਮਕਾਰਿ| ਦਾਸੇਯਾਃ ਕਥਯਾਮਾਸੁਃ, ਵਯੰ ਗਤ੍ਵਾ ਤਾਨ੍ਯੁਤ੍ਪਾੱਯ ਕ੍ਸ਼਼ਿਪਾਮੋ ਭਵਤਃ ਕੀਦ੍ਰੁʼਸ਼ੀੱਛਾ ਜਾਯਤੇ? ");
INSERT INTO sanpun_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","ਤੇਨਾਵਾਦਿ, ਨਹਿ, ਸ਼ਙ੍ਕੇ(ਅ)ਹੰ ਵਨ੍ਯਯਵਸੋਤ੍ਪਾਟਨਕਾਲੇ ਯੁਸ਼਼੍ਮਾਭਿਸ੍ਤੈਃ ਸਾਕੰ ਗੋਧੂਮਾ ਅਪ੍ਯੁਤ੍ਪਾਟਿਸ਼਼੍ਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ਅਤਃ ਸ਼੍ਸ੍ਯਕਰ੍ੱਤਨਕਾਲੰ ਯਾਵਦ੍ ਉਭਯਾਨ੍ਯਪਿ ਸਹ ਵਰ੍ੱਧਨ੍ਤਾਂ, ਪਸ਼੍ਚਾਤ੍ ਕਰ੍ੱਤਨਕਾਲੇ ਕਰ੍ੱਤਕਾਨ੍ ਵਕ੍ਸ਼਼੍ਯਾਮਿ, ਯੂਯਮਾਦੌ ਵਨ੍ਯਯਵਸਾਨਿ ਸੰਗ੍ਰੁʼਹ੍ਯ ਦਾਹਯਿਤੁੰ ਵੀਟਿਕਾ ਬਦ੍ੱਵਾ ਸ੍ਥਾਪਯਤ; ਕਿਨ੍ਤੁ ਸਰ੍ੱਵੇ ਗੋਧੂਮਾ ਯੁਸ਼਼੍ਮਾਭਿ ਰ੍ਭਾਣ੍ਡਾਗਾਰੰ ਨੀਤ੍ਵਾ ਸ੍ਥਾਪ੍ਯਨ੍ਤਾਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ਅਨਨ੍ਤਰੰ ਸੋਪਰਾਮੇਕਾਂ ਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤਕਥਾਮੁੱਥਾਪ੍ਯ ਤੇਭ੍ਯਃ ਕਥਿਤਵਾਨ੍ ਕਸ਼੍ਚਿਨ੍ਮਨੁਜਃ ਸਰ੍ਸ਼਼ਪਬੀਜਮੇਕੰ ਨੀਤ੍ਵਾ ਸ੍ਵਕ੍ਸ਼਼ੇਤ੍ਰ ਉਵਾਪ| ");
INSERT INTO sanpun_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","ਸਰ੍ਸ਼਼ਪਬੀਜੰ ਸਰ੍ੱਵਸ੍ਮਾਦ੍ ਬੀਜਾਤ੍ ਕ੍ਸ਼਼ੁਦ੍ਰਮਪਿ ਸਦਙ੍ਕੁਰਿਤੰ ਸਰ੍ੱਵਸ੍ਮਾਤ੍ ਸ਼ਾਕਾਤ੍ ਬ੍ਰੁʼਹਦ੍ ਭਵਤਿ; ਸ ਤਾਦ੍ਰੁʼਸ਼ਸ੍ਤਰੁ ਰ੍ਭਵਤਿ, ਯਸ੍ਯ ਸ਼ਾਖਾਸੁ ਨਭਸਃ ਖਗਾ ਆਗਤ੍ਯ ਨਿਵਸਨ੍ਤਿ; ਸ੍ਵਰ੍ਗੀਯਰਾਜ੍ਯੰ ਤਾਦ੍ਰੁʼਸ਼ਸ੍ਯ ਸਰ੍ਸ਼਼ਪੈਕਸ੍ਯ ਸਮਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ਪੁਨਰਪਿ ਸ ਉਪਮਾਕਥਾਮੇਕਾਂ ਤੇਭ੍ਯਃ ਕਥਯਾਞ੍ਚਕਾਰ; ਕਾਚਨ ਯੋਸ਼਼ਿਤ੍ ਯਤ੍ ਕਿਣ੍ਵਮਾਦਾਯ ਦ੍ਰੋਣਤ੍ਰਯਮਿਤਗੋਧੂਮਚੂਰ੍ਣਾਨਾਂ ਮਧ੍ਯੇ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਮਿਸ਼੍ਰੀਭਵਨਪਰ੍ੱਯਨ੍ਤੰ ਸਮਾੱਛਾਦ੍ਯ ਨਿਧੱਤਵਤੀ, ਤਤ੍ਕਿਣ੍ਵਮਿਵ ਸ੍ਵਰ੍ਗਰਾਜ੍ਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ਇੱਥੰ ਯੀਸ਼ੁ ਰ੍ਮਨੁਜਨਿਵਹਾਨਾਂ ਸੰਨਿਧਾਵੁਪਮਾਕਥਾਭਿਰੇਤਾਨ੍ਯਾਖ੍ਯਾਨਾਨਿ ਕਥਿਤਵਾਨ੍ ਉਪਮਾਂ ਵਿਨਾ ਤੇਭ੍ਯਃ ਕਿਮਪਿ ਕਥਾਂ ਨਾਕਥਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ਏਤੇਨ ਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤੀਯੇਨ ਵਾਕ੍ਯੇਨ ਵ੍ਯਾਦਾਯ ਵਦਨੰ ਨਿਜੰ| ਅਹੰ ਪ੍ਰਕਾਸ਼ਯਿਸ਼਼੍ਯਾਮਿ ਗੁਪ੍ਤਵਾਕ੍ਯੰ ਪੁਰਾਭਵੰ| ਯਦੇਤਦ੍ਵਚਨੰ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਾ ਪ੍ਰੋਕ੍ਤਮਾਸੀਤ੍, ਤਤ੍ ਸਿੱਧਮਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","ਸਰ੍ੱਵਾਨ੍ ਮਨੁਜਾਨ੍ ਵਿਸ੍ਰੁʼਜ੍ਯ ਯੀਸ਼ੌ ਗ੍ਰੁʼਹੰ ਪ੍ਰਵਿਸ਼਼੍ਟੇ ਤੱਛਿਸ਼਼੍ਯਾ ਆਗਤ੍ਯ ਯੀਸ਼ਵੇ ਕਥਿਤਵਨ੍ਤਃ, ਕ੍ਸ਼਼ੇਤ੍ਰਸ੍ਯ ਵਨ੍ਯਯਵਸੀਯਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤਕਥਾਮ੍ ਭਵਾਨ ਅਸ੍ਮਾਨ੍ ਸ੍ਪਸ਼਼੍ਟੀਕ੍ਰੁʼਤ੍ਯ ਵਦਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ਤਤਃ ਸ ਪ੍ਰਤ੍ਯੁਵਾਚ, ਯੇਨ ਭਦ੍ਰਬੀਜਾਨ੍ਯੁਪ੍ਯਨ੍ਤੇ ਸ ਮਨੁਜਪੁਤ੍ਰਃ, ");
INSERT INTO sanpun_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ਕ੍ਸ਼਼ੇਤ੍ਰੰ ਜਗਤ੍, ਭਦ੍ਰਬੀਜਾਨੀ ਰਾਜ੍ਯਸ੍ਯ ਸਨ੍ਤਾਨਾਃ, ");
INSERT INTO sanpun_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ਵਨ੍ਯਯਵਸਾਨਿ ਪਾਪਾਤ੍ਮਨਃ ਸਨ੍ਤਾਨਾਃ| ਯੇਨ ਰਿਪੁਣਾ ਤਾਨ੍ਯੁਪ੍ਤਾਨਿ ਸ ਸ਼ਯਤਾਨਃ, ਕਰ੍ੱਤਨਸਮਯਸ਼੍ਚ ਜਗਤਃ ਸ਼ੇਸ਼਼ਃ, ਕਰ੍ੱਤਕਾਃ ਸ੍ਵਰ੍ਗੀਯਦੂਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","ਯਥਾ ਵਨ੍ਯਯਵਸਾਨਿ ਸੰਗ੍ਰੁʼਹ੍ਯ ਦਾਹ੍ਯਨ੍ਤੇ, ਤਥਾ ਜਗਤਃ ਸ਼ੇਸ਼਼ੇ ਭਵਿਸ਼਼੍ਯਤਿ; ");
INSERT INTO sanpun_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","ਅਰ੍ਥਾਤ੍ ਮਨੁਜਸੁਤਃ ਸ੍ਵਾਂਯਦੂਤਾਨ੍ ਪ੍ਰੇਸ਼਼ਯਿਸ਼਼੍ਯਤਿ, ਤੇਨ ਤੇ ਚ ਤਸ੍ਯ ਰਾਜ੍ਯਾਤ੍ ਸਰ੍ੱਵਾਨ੍ ਵਿਘ੍ਨਕਾਰਿਣੋ(ਅ)ਧਾਰ੍ੰਮਿਕਲੋਕਾਂਸ਼੍ਚ ਸੰਗ੍ਰੁʼਹ੍ਯ ");
INSERT INTO sanpun_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ਯਤ੍ਰ ਰੋਦਨੰ ਦਨ੍ਤਘਰ੍ਸ਼਼ਣਞ੍ਚ ਭਵਤਿ, ਤਤ੍ਰਾਗ੍ਨਿਕੁਣ੍ਡੇ ਨਿਕ੍ਸ਼਼ੇਪ੍ਸ੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","ਤਦਾਨੀਂ ਧਾਰ੍ੰਮਿਕਲੋਕਾਃ ਸ੍ਵੇਸ਼਼ਾਂ ਪਿਤੂ ਰਾਜ੍ਯੇ ਭਾਸ੍ਕਰਇਵ ਤੇਜਸ੍ਵਿਨੋ ਭਵਿਸ਼਼੍ਯਨ੍ਤਿ| ਸ਼੍ਰੋਤੁੰ ਯਸ੍ਯ ਸ਼੍ਰੁਤੀ ਆਸਾਤੇ, ਮ ਸ਼੍ਰੁʼਣੁਯਾਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","ਅਪਰਞ੍ਚ ਕ੍ਸ਼਼ੇਤ੍ਰਮਧ੍ਯੇ ਨਿਧਿੰ ਪਸ਼੍ਯਨ੍ ਯੋ ਗੋਪਯਤਿ, ਤਤਃ ਪਰੰ ਸਾਨਨ੍ਦੋ ਗਤ੍ਵਾ ਸ੍ਵੀਯਸਰ੍ੱਵਸ੍ਵੰ ਵਿਕ੍ਰੀਯ ੱਤਕ੍ਸ਼਼ੇਤ੍ਰੰ ਕ੍ਰੀਣਾਤਿ, ਸ ਇਵ ਸ੍ਵਰ੍ਗਰਾਜ੍ਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","ਅਨ੍ਯਞ੍ਚ ਯੋ ਵਣਿਕ੍ ਉੱਤਮਾਂ ਮੁਕ੍ਤਾਂ ਗਵੇਸ਼਼ਯਨ੍ ");
INSERT INTO sanpun_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ਮਹਾਰ੍ਘਾਂ ਮੁਕ੍ਤਾਂ ਵਿਲੋਕ੍ਯ ਨਿਜਸਰ੍ੱਵਸ੍ਵੰ ਵਿਕ੍ਰੀਯ ਤਾਂ ਕ੍ਰੀਣਾਤਿ, ਸ ਇਵ ਸ੍ਵਰ੍ਗਰਾਜ੍ਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","ਪੁਨਸ਼੍ਚ ਸਮੁਦ੍ਰੋ ਨਿਕ੍ਸ਼਼ਿਪ੍ਤਃ ਸਰ੍ੱਵਪ੍ਰਕਾਰਮੀਨਸੰਗ੍ਰਾਹ੍ਯਾਨਾਯਇਵ ਸ੍ਵਰ੍ਗਰਾਜ੍ਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ਤਸ੍ਮਿਨ੍ ਆਨਾਯੇ ਪੂਰ੍ਣੇ ਜਨਾ ਯਥਾ ਰੋਧਸ੍ਯੁੱਤੋਲ੍ਯ ਸਮੁਪਵਿਸ਼੍ਯ ਪ੍ਰਸ਼ਸ੍ਤਮੀਨਾਨ੍ ਸੰਗ੍ਰਹ੍ਯ ਭਾਜਨੇਸ਼਼ੁ ਨਿਦਧਤੇ, ਕੁਤ੍ਸਿਤਾਨ੍ ਨਿਕ੍ਸ਼਼ਿਪਨ੍ਤਿ; ");
INSERT INTO sanpun_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","ਤਥੈਵ ਜਗਤਃ ਸ਼ੇਸ਼਼ੇ ਭਵਿਸ਼਼੍ਯਤਿ, ਫਲਤਃ ਸ੍ਵਰ੍ਗੀਯਦੂਤਾ ਆਗਤ੍ਯ ਪੁਣ੍ਯਵੱਜਨਾਨਾਂ ਮਧ੍ਯਾਤ੍ ਪਾਪਿਨਃ ਪ੍ਰੁʼਥਕ੍ ਕ੍ਰੁʼਤ੍ਵਾ ਵਹ੍ਨਿਕੁਣ੍ਡੇ ਨਿਕ੍ਸ਼਼ੇਪ੍ਸ੍ਯਨ੍ਤਿ, ");
INSERT INTO sanpun_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ਤਤ੍ਰ ਰੋਦਨੰ ਦਨ੍ਤੈ ਰ੍ਦਨ੍ਤਘਰ੍ਸ਼਼ਣਞ੍ਚ ਭਵਿਸ਼਼੍ਯਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","ਯੀਸ਼ੁਨਾ ਤੇ ਪ੍ਰੁʼਸ਼਼੍ਟਾ ਯੁਸ਼਼੍ਮਾਭਿਃ ਕਿਮੇਤਾਨ੍ਯਾਖ੍ਯਾਨਾਨ੍ਯਬੁਧ੍ਯਨ੍ਤ? ਤਦਾ ਤੇ ਪ੍ਰਤ੍ਯਵਦਨ੍, ਸਤ੍ਯੰ ਪ੍ਰਭੋ| ");
INSERT INTO sanpun_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ਤਦਾਨੀਂ ਸ ਕਥਿਤਵਾਨ੍, ਨਿਜਭਾਣ੍ਡਾਗਾਰਾਤ੍ ਨਵੀਨਪੁਰਾਤਨਾਨਿ ਵਸ੍ਤੂਨਿ ਨਿਰ੍ਗਮਯਤਿ ਯੋ ਗ੍ਰੁʼਹਸ੍ਥਃ ਸ ਇਵ ਸ੍ਵਰ੍ਗਰਾਜ੍ਯਮਧਿ ਸ਼ਿਕ੍ਸ਼਼ਿਤਾਃ ਸ੍ਵਰ੍ਵ ਉਪਦੇਸ਼਼੍ਟਾਰਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","ਅਨਨ੍ਤਰੰ ਯੀਸ਼ੁਰੇਤਾਃ ਸਰ੍ੱਵਾ ਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤਕਥਾਃ ਸਮਾਪ੍ਯ ਤਸ੍ਮਾਤ੍ ਸ੍ਥਾਨਾਤ੍ ਪ੍ਰਤਸ੍ਥੇ| ਅਪਰੰ ਸ੍ਵਦੇਸ਼ਮਾਗਤ੍ਯ ਜਨਾਨ੍ ਭਜਨਭਵਨ ਉਪਦਿਸ਼਼੍ਟਵਾਨ੍; ");
INSERT INTO sanpun_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ਤੇ ਵਿਸ੍ਮਯੰ ਗਤ੍ਵਾ ਕਥਿਤਵਨ੍ਤ ਏਤਸ੍ਯੈਤਾਦ੍ਰੁʼਸ਼ੰ ਜ੍ਞਾਨਮ੍ ਆਸ਼੍ਚਰ੍ੱਯੰ ਕਰ੍ੰਮ ਚ ਕਸ੍ਮਾਦ੍ ਅਜਾਯਤ? ");
INSERT INTO sanpun_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","ਕਿਮਯੰ ਸੂਤ੍ਰਧਾਰਸ੍ਯ ਪੁਤ੍ਰੋ ਨਹਿ? ਏਤਸ੍ਯ ਮਾਤੁ ਰ੍ਨਾਮ ਚ ਕਿੰ ਮਰਿਯਮ੍ ਨਹਿ? ਯਾਕੁਬ੍-ਯੂਸ਼਼ਫ੍-ਸ਼ਿਮੋਨ੍-ਯਿਹੂਦਾਸ਼੍ਚ ਕਿਮੇਤਸ੍ਯ ਭ੍ਰਾਤਰੋ ਨਹਿ? ");
INSERT INTO sanpun_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ਏਤਸ੍ਯ ਭਗਿਨ੍ਯਸ਼੍ਚ ਕਿਮਸ੍ਮਾਕੰ ਮਧ੍ਯੇ ਨ ਸਨ੍ਤਿ? ਤਰ੍ਹਿ ਕਸ੍ਮਾਦਯਮੇਤਾਨਿ ਲਬ੍ਧਵਾਨ੍? ਇੱਥੰ ਸ ਤੇਸ਼਼ਾਂ ਵਿਘ੍ਨਰੂਪੋ ਬਭੂਵ; ");
INSERT INTO sanpun_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ਤਤੋ ਯੀਸ਼ੁਨਾ ਨਿਗਦਿਤੰ ਸ੍ਵਦੇਸ਼ੀਯਜਨਾਨਾਂ ਮਧ੍ਯੰ ਵਿਨਾ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦੀ ਕੁਤ੍ਰਾਪ੍ਯਨ੍ਯਤ੍ਰ ਨਾਸੰਮਾਨ੍ਯੋ ਭਵਤੀ| ");
INSERT INTO sanpun_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","ਤੇਸ਼਼ਾਮਵਿਸ਼੍ਵਾਸਹੇਤੋਃ ਸ ਤਤ੍ਰ ਸ੍ਥਾਨੇ ਬਹ੍ਵਾਸ਼੍ਚਰ੍ੱਯਕਰ੍ੰਮਾਣਿ ਨ ਕ੍ਰੁʼਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","ਤਦਾਨੀਂ ਰਾਜਾ ਹੇਰੋਦ੍ ਯੀਸ਼ੋ ਰ੍ਯਸ਼ਃ ਸ਼੍ਰੁਤ੍ਵਾ ਨਿਜਦਾਸੇਯਾਨ੍ ਜਗਾਦ੍, ");
INSERT INTO sanpun_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ਏਸ਼਼ ਮੱਜਯਿਤਾ ਯੋਹਨ੍, ਪ੍ਰਮਿਤੇਭਯਸ੍ਤਸ੍ਯੋੱਥਾਨਾਤ੍ ਤੇਨੇੱਥਮਦ੍ਭੁਤੰ ਕਰ੍ੰਮ ਪ੍ਰਕਾਸ਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","ਪੁਰਾ ਹੇਰੋਦ੍ ਨਿਜਭ੍ਰਾਤੁ: ਫਿਲਿਪੋ ਜਾਯਾਯਾ ਹੇਰੋਦੀਯਾਯਾ ਅਨੁਰੋਧਾਦ੍ ਯੋਹਨੰ ਧਾਰਯਿਤ੍ਵਾ ਬੱਧਾ ਕਾਰਾਯਾਂ ਸ੍ਥਾਪਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ਯਤੋ ਯੋਹਨ੍ ਉਕ੍ਤਵਾਨ੍, ਏਤ੍ਸਯਾਃ ਸੰਗ੍ਰਹੋ ਭਵਤੋ ਨੋਚਿਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ਤਸ੍ਮਾਤ੍ ਨ੍ਰੁʼਪਤਿਸ੍ਤੰ ਹਨ੍ਤੁਮਿੱਛੰਨਪਿ ਲੋਕੇਭ੍ਯੋ ਵਿਭਯਾਞ੍ਚਕਾਰ; ਯਤਃ ਸਰ੍ੱਵੇ ਯੋਹਨੰ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨੰ ਮੇਨਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","ਕਿਨ੍ਤੁ ਹੇਰੋਦੋ ਜਨ੍ਮਾਹੀਯਮਹ ਉਪਸ੍ਥਿਤੇ ਹੇਰੋਦੀਯਾਯਾ ਦੁਹਿਤਾ ਤੇਸ਼਼ਾਂ ਸਮਕ੍ਸ਼਼ੰ ਨ੍ਰੁʼਤਿਤ੍ਵਾ ਹੇਰੋਦਮਪ੍ਰੀਣ੍ਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ਤਸ੍ਮਾਤ੍ ਭੂਪਤਿਃ ਸ਼ਪਥੰ ਕੁਰ੍ੱਵਨ੍ ਇਤਿ ਪ੍ਰਤ੍ਯਜ੍ਞਾਸੀਤ੍, ਤ੍ਵਯਾ ਯਦ੍ ਯਾਚ੍ਯਤੇ, ਤਦੇਵਾਹੰ ਦਾਸ੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","ਸਾ ਕੁਮਾਰੀ ਸ੍ਵੀਯਮਾਤੁਃ ਸ਼ਿਕ੍ਸ਼਼ਾਂ ਲਬ੍ਧਾ ਬਭਾਸ਼਼ੇ, ਮੱਜਯਿਤੁਰ੍ਯੋਹਨ ਉੱਤਮਾਙ੍ਗੰ ਭਾਜਨੇ ਸਮਾਨੀਯ ਮਹ੍ਯੰ ਵਿਸ਼੍ਰਾਣਯ| ");
INSERT INTO sanpun_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ਤਤੋ ਰਾਜਾ ਸ਼ੁਸ਼ੋਚ, ਕਿਨ੍ਤੁ ਭੋਜਨਾਯੋਪਵਿਸ਼ਤਾਂ ਸਙ੍ਗਿਨਾਂ ਸ੍ਵਕ੍ਰੁʼਤਸ਼ਪਥਸ੍ਯ ਚਾਨੁਰੋਧਾਤ੍ ਤਤ੍ ਪ੍ਰਦਾਤੁਮ ਆਦਿਦੇਸ਼| ");
INSERT INTO sanpun_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ਪਸ਼੍ਚਾਤ੍ ਕਾਰਾਂ ਪ੍ਰਤਿ ਨਰੰ ਪ੍ਰਹਿਤ੍ਯ ਯੋਹਨ ਉੱਤਮਾਙ੍ਗੰ ਛਿੱਤ੍ਵਾ ");
INSERT INTO sanpun_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ਤਤ੍ ਭਾਜਨ ਆਨਾੱਯ ਤਸ੍ਯੈ ਕੁਮਾਰ੍ੱਯੈ ਵ੍ਯਸ਼੍ਰਾਣਯਤ੍, ਤਤਃ ਸਾ ਸ੍ਵਜਨਨ੍ਯਾਃ ਸਮੀਪੰ ਤੰਨਿਨਾਯ| ");
INSERT INTO sanpun_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ਪਸ਼੍ਚਾਤ੍ ਯੋਹਨਃ ਸ਼ਿਸ਼਼੍ਯਾ ਆਗਤ੍ਯ ਕਾਯੰ ਨੀਤ੍ਵਾ ਸ਼੍ਮਸ਼ਾਨੇ ਸ੍ਥਾਪਯਾਮਾਸੁਸ੍ਤਤੋ ਯੀਸ਼ੋਃ ਸੰਨਿਧਿੰ ਵ੍ਰਜਿਤ੍ਵਾ ਤਦ੍ਵਾਰ੍ੱਤਾਂ ਬਭਾਸ਼਼ਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","ਅਨਨ੍ਤਰੰ ਯੀਸ਼ੁਰਿਤਿ ਨਿਸ਼ਭ੍ਯ ਨਾਵਾ ਨਿਰ੍ਜਨਸ੍ਥਾਨਮ੍ ਏਕਾਕੀ ਗਤਵਾਨ੍, ਪਸ਼੍ਚਾਤ੍ ਮਾਨਵਾਸ੍ਤਤ੍ ਸ਼੍ਰੁਤ੍ਵਾ ਨਾਨਾਨਗਰੇਭ੍ਯ ਆਗਤ੍ਯ ਪਦੈਸ੍ਤਤ੍ਪਸ਼੍ਚਾਦ੍ ਈਯੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ਤਦਾਨੀਂ ਯੀਸ਼ੁ ਰ੍ਬਹਿਰਾਗਤ੍ਯ ਮਹਾਨ੍ਤੰ ਜਨਨਿਵਹੰ ਨਿਰੀਕ੍ਸ਼਼੍ਯ ਤੇਸ਼਼ੁ ਕਾਰੁਣਿਕਃ ਮਨ੍ ਤੇਸ਼਼ਾਂ ਪੀਡਿਤਜਨਾਨ੍ ਨਿਰਾਮਯਾਨ੍ ਚਕਾਰ| ");
INSERT INTO sanpun_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ਤਤਃ ਪਰੰ ਸਨ੍ਧ੍ਯਾਯਾਂ ਸ਼ਿਸ਼਼੍ਯਾਸ੍ਤਦਨ੍ਤਿਕਮਾਗਤ੍ਯ ਕਥਯਾਞ੍ਚਕ੍ਰੁਃ, ਇਦੰ ਨਿਰ੍ਜਨਸ੍ਥਾਨੰ ਵੇਲਾਪ੍ਯਵਸੰਨਾ; ਤਸ੍ਮਾਤ੍ ਮਨੁਜਾਨ੍ ਸ੍ਵਸ੍ਵਗ੍ਰਾਮੰ ਗਨ੍ਤੁੰ ਸ੍ਵਾਰ੍ਥੰ ਭਕ੍ਸ਼਼੍ਯਾਣਿ ਕ੍ਰੇਤੁਞ੍ਚ ਭਵਾਨ੍ ਤਾਨ੍ ਵਿਸ੍ਰੁʼਜਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","ਕਿਨ੍ਤੁ ਯੀਸ਼ੁਸ੍ਤਾਨਵਾਦੀਤ੍, ਤੇਸ਼਼ਾਂ ਗਮਨੇ ਪ੍ਰਯੋਜਨੰ ਨਾਸ੍ਤਿ, ਯੂਯਮੇਵ ਤਾਨ੍ ਭੋਜਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ਤਦਾ ਤੇ ਪ੍ਰਤ੍ਯਵਦਨ੍, ਅਸ੍ਮਾਕਮਤ੍ਰ ਪੂਪਪਞ੍ਚਕੰ ਮੀਨਦ੍ਵਯਞ੍ਚਾਸ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ਤਦਾਨੀਂ ਤੇਨੋਕ੍ਤੰ ਤਾਨਿ ਮਦਨ੍ਤਿਕਮਾਨਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ਅਨਨ੍ਤਰੰ ਸ ਮਨੁਜਾਨ੍ ਯਵਸੋਪਰ੍ੱਯੁਪਵੇਸ਼਼੍ਟੁਮ੍ ਆਜ੍ਞਾਪਯਾਮਾਸ; ਅਪਰ ਤਤ੍ ਪੂਪਪਞ੍ਚਕੰ ਮੀਨਦ੍ਵਯਞ੍ਚ ਗ੍ਰੁʼਹ੍ਲਨ੍ ਸ੍ਵਰ੍ਗੰ ਪ੍ਰਤਿ ਨਿਰੀਕ੍ਸ਼਼੍ਯੇਸ਼੍ਵਰੀਯਗੁਣਾਨ੍ ਅਨੂਦ੍ਯ ਭੰਕ੍ਤ੍ਵਾ ਸ਼ਿਸ਼਼੍ਯੇਭ੍ਯੋ ਦੱਤਵਾਨ੍, ਸ਼ਿਸ਼਼੍ਯਾਸ਼੍ਚ ਲੋਕੇਭ੍ਯੋ ਦਦੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ਤਤਃ ਸਰ੍ੱਵੇ ਭੁਕ੍ਤ੍ਵਾ ਪਰਿਤ੍ਰੁʼਪ੍ਤਵਨ੍ਤਃ, ਤਤਸ੍ਤਦਵਸ਼ਿਸ਼਼੍ਟਭਕ੍ਸ਼਼੍ਯੈਃ ਪੂਰ੍ਣਾਨ੍ ਦ੍ਵਾਦਸ਼ਡਲਕਾਨ੍ ਗ੍ਰੁʼਹੀਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","ਤੇ ਭੋਕ੍ਤਾਰਃ ਸ੍ਤ੍ਰੀਰ੍ਬਾਲਕਾਂਸ਼੍ਚ ਵਿਹਾਯ ਪ੍ਰਾਯੇਣ ਪਞ੍ਚ ਸਹਸ੍ਰਾਣਿ ਪੁਮਾਂਸ ਆਸਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","ਤਦਨਨ੍ਤਰੰ ਯੀਸ਼ੁ ਰ੍ਲੋਕਾਨਾਂ ਵਿਸਰ੍ਜਨਕਾਲੇ ਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਤਰਣਿਮਾਰੋਢੁੰ ਸ੍ਵਾਗ੍ਰੇ ਪਾਰੰ ਯਾਤੁਞ੍ਚ ਗਾਢਮਾਦਿਸ਼਼੍ਟਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ਤਤੋ ਲੋਕੇਸ਼਼ੁ ਵਿਸ੍ਰੁʼਸ਼਼੍ਟੇਸ਼਼ੁ ਸ ਵਿਵਿਕ੍ਤੇ ਪ੍ਰਾਰ੍ਥਯਿਤੁੰ ਗਿਰਿਮੇਕੰ ਗਤ੍ਵਾ ਸਨ੍ਧ੍ਯਾਂ ਯਾਵਤ੍ ਤਤ੍ਰੈਕਾਕੀ ਸ੍ਥਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ਕਿਨ੍ਤੁ ਤਦਾਨੀਂ ਸੰਮੁਖਵਾਤਤ੍ਵਾਤ੍ ਸਰਿਤ੍ਪਤੇ ਰ੍ਮਧ੍ਯੇ ਤਰਙ੍ਗੈਸ੍ਤਰਣਿਰ੍ਦੋਲਾਯਮਾਨਾਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","ਤਦਾ ਸ ਯਾਮਿਨ੍ਯਾਸ਼੍ਚਤੁਰ੍ਥਪ੍ਰਹਰੇ ਪਦ੍ਭ੍ਯਾਂ ਵ੍ਰਜਨ੍ ਤੇਸ਼਼ਾਮਨ੍ਤਿਕੰ ਗਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ਕਿਨ੍ਤੁ ਸ਼ਿਸ਼਼੍ਯਾਸ੍ਤੰ ਸਾਗਰੋਪਰਿ ਵ੍ਰਜਨ੍ਤੰ ਵਿਲੋਕ੍ਯ ਸਮੁਦ੍ਵਿਗ੍ਨਾ ਜਗਦੁਃ, ਏਸ਼਼ ਭੂਤ ਇਤਿ ਸ਼ਙ੍ਕਮਾਨਾ ਉੱਚੈਃ ਸ਼ਬ੍ਦਾਯਾਞ੍ਚਕ੍ਰਿਰੇ ਚ| ");
INSERT INTO sanpun_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ਤਦੈਵ ਯੀਸ਼ੁਸ੍ਤਾਨਵਦਤ੍, ਸੁਸ੍ਥਿਰਾ ਭਵਤ, ਮਾ ਭੈਸ਼਼੍ਟ, ਏਸ਼਼ੋ(ਅ)ਹਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","ਤਤਃ ਪਿਤਰ ਇਤ੍ਯੁਕ੍ਤਵਾਨ੍, ਹੇ ਪ੍ਰਭੋ, ਯਦਿ ਭਵਾਨੇਵ, ਤਰ੍ਹਿ ਮਾਂ ਭਵਤ੍ਸਮੀਪੰ ਯਾਤੁਮਾਜ੍ਞਾਪਯਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ਤਤਃ ਤੇਨਾਦਿਸ਼਼੍ਟਃ ਪਿਤਰਸ੍ਤਰਣਿਤੋ(ਅ)ਵਰੁਹ੍ਯ ਯੀਸ਼ੇाਰਨ੍ਤਿਕੰ ਪ੍ਰਾਪ੍ਤੁੰ ਤੋਯੋਪਰਿ ਵਵ੍ਰਾਜ| ");
INSERT INTO sanpun_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ਕਿਨ੍ਤੁ ਪ੍ਰਚਣ੍ਡੰ ਪਵਨੰ ਵਿਲੋਕ੍ਯ ਭਯਾਤ੍ ਤੋਯੇ ਮੰਕ੍ਤੁਮ੍ ਆਰੇਭੇ, ਤਸ੍ਮਾਦ੍ ਉੱਚੈਃ ਸ਼ਬ੍ਦਾਯਮਾਨਃ ਕਥਿਤਵਾਨ੍, ਹੇ ਪ੍ਰਭੋ, ਮਾਮਵਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ਯੀਸ਼ੁਸ੍ਤਤ੍ਕ੍ਸ਼਼ਣਾਤ੍ ਕਰੰ ਪ੍ਰਸਾਰ੍ੱਯ ਤੰ ਧਰਨ੍ ਉਕ੍ਤਵਾਨ੍, ਹ ਸ੍ਤੋਕਪ੍ਰਤ੍ਯਯਿਨ੍ ਤ੍ਵੰ ਕੁਤਃ ਸਮਸ਼ੇਥਾਃ? ");
INSERT INTO sanpun_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","ਅਨਨ੍ਤਰੰ ਤਯੋਸ੍ਤਰਣਿਮਾਰੂਢਯੋਃ ਪਵਨੋ ਨਿਵਵ੍ਰੁʼਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ਤਦਾਨੀਂ ਯੇ ਤਰਣ੍ਯਾਮਾਸਨ੍, ਤ ਆਗਤ੍ਯ ਤੰ ਪ੍ਰਣਭ੍ਯ ਕਥਿਤਵਨ੍ਤਃ, ਯਥਾਰ੍ਥਸ੍ਤ੍ਵਮੇਵੇਸ਼੍ਵਰਸੁਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ਅਨਨ੍ਤਰੰ ਪਾਰੰ ਪ੍ਰਾਪ੍ਯ ਤੇ ਗਿਨੇਸ਼਼ਰੰਨਾਮਕੰ ਨਗਰਮੁਪਤਸ੍ਥੁਃ, ");
INSERT INTO sanpun_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ਤਦਾ ਤਤ੍ਰਤ੍ਯਾ ਜਨਾ ਯੀਸ਼ੁੰ ਪਰਿਚੀਯ ਤੱਦੇਸ਼੍ਸ੍ਯ ਚਤੁਰ੍ਦਿਸ਼ੋ ਵਾਰ੍ੱਤਾਂ ਪ੍ਰਹਿਤ੍ਯ ਯਤ੍ਰ ਯਾਵਨ੍ਤਃ ਪੀਡਿਤਾ ਆਸਨ੍, ਤਾਵਤਏਵ ਤਦਨ੍ਤਿਕਮਾਨਯਾਮਾਸੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ਅਪਰੰ ਤਦੀਯਵਸਨਸ੍ਯ ਗ੍ਰਨ੍ਥਿਮਾਤ੍ਰੰ ਸ੍ਪ੍ਰਸ਼਼੍ਟੁੰ ਵਿਨੀਯ ਯਾਵਨ੍ਤੋ ਜਨਾਸ੍ਤਤ੍ ਸ੍ਪਰ੍ਸ਼ੰ ਚਕ੍ਰਿਰੇ, ਤੇ ਸਰ੍ੱਵਏਵ ਨਿਰਾਮਯਾ ਬਭੂਵੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","ਅਪਰੰ ਯਿਰੂਸ਼ਾਲਮ੍ਨਗਰੀਯਾਃ ਕਤਿਪਯਾ ਅਧ੍ਯਾਪਕਾਃ ਫਿਰੂਸ਼ਿਨਸ਼੍ਚ ਯੀਸ਼ੋਃ ਸਮੀਪਮਾਗਤ੍ਯ ਕਥਯਾਮਾਸੁਃ, ");
INSERT INTO sanpun_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","ਤਵ ਸ਼ਿਸ਼਼੍ਯਾਃ ਕਿਮਰ੍ਥਮ੍ ਅਪ੍ਰਕ੍ਸ਼਼ਾਲਿਤਕਰੈ ਰ੍ਭਕ੍ਸ਼਼ਿਤ੍ਵਾ ਪਰਮ੍ਪਰਾਗਤੰ ਪ੍ਰਾਚੀਨਾਨਾਂ ਵ੍ਯਵਹਾਰੰ ਲਙ੍ਵਨ੍ਤੇ? ");
INSERT INTO sanpun_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ਤਤੋ ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯੁਵਾਚ, ਯੂਯੰ ਪਰਮ੍ਪਰਾਗਤਾਚਾਰੇਣ ਕੁਤ ਈਸ਼੍ਵਰਾਜ੍ਞਾਂ ਲਙ੍ਵਧ੍ਵੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ਈਸ਼੍ਵਰ ਇਤ੍ਯਾਜ੍ਞਾਪਯਤ੍, ਤ੍ਵੰ ਨਿਜਪਿਤਰੌ ਸੰਮਨ੍ਯੇਥਾਃ, ਯੇਨ ਚ ਨਿਜਪਿਤਰੌ ਨਿਨ੍ਦ੍ਯੇਤੇ, ਸ ਨਿਸ਼੍ਚਿਤੰ ਮ੍ਰਿਯੇਤ; ");
INSERT INTO sanpun_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","ਕਿਨ੍ਤੁ ਯੂਯੰ ਵਦਥ, ਯਃ ਸ੍ਵਜਨਕੰ ਸ੍ਵਜਨਨੀਂ ਵਾ ਵਾਕ੍ਯਮਿਦੰ ਵਦਤਿ, ਯੁਵਾਂ ਮੱਤੋ ਯੱਲਭੇਥੇ, ਤਤ੍ ਨ੍ਯਵਿਦ੍ਯਤ, ");
INSERT INTO sanpun_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ਸ ਨਿਜਪਿਤਰੌ ਪੁਨ ਰ੍ਨ ਸੰਮੰਸ੍ਯਤੇ| ਇੱਥੰ ਯੂਯੰ ਪਰਮ੍ਪਰਾਗਤੇਨ ਸ੍ਵੇਸ਼਼ਾਮਾਚਾਰੇਣੇਸ਼੍ਵਰੀਯਾਜ੍ਞਾਂ ਲੁਮ੍ਪਥ| ");
INSERT INTO sanpun_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ਰੇ ਕਪਟਿਨਃ ਸਰ੍ੱਵੇ ਯਿਸ਼ਯਿਯੋ ਯੁਸ਼਼੍ਮਾਨਧਿ ਭਵਿਸ਼਼੍ਯਦ੍ਵਚਨਾਨ੍ਯੇਤਾਨਿ ਸਮ੍ਯਗ੍ ਉਕ੍ਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","ਵਦਨੈ ਰ੍ਮਨੁਜਾ ਏਤੇ ਸਮਾਯਾਨ੍ਤਿ ਮਦਨ੍ਤਿਕੰ| ਤਥਾਧਰੈ ਰ੍ਮਦੀਯਞ੍ਚ ਮਾਨੰ ਕੁਰ੍ੱਵਨ੍ਤਿ ਤੇ ਨਰਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ਕਿਨ੍ਤੁ ਤੇਸ਼਼ਾਂ ਮਨੋ ਮੱਤੋ ਵਿਦੂਰਏਵ ਤਿਸ਼਼੍ਠਤਿ| ਸ਼ਿਕ੍ਸ਼਼ਯਨ੍ਤੋ ਵਿਧੀਨ੍ ਨ੍ਰਾਜ੍ਞਾ ਭਜਨ੍ਤੇ ਮਾਂ ਮੁਧੈਵ ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ਤਤੋ ਯੀਸ਼ੁ ਰ੍ਲੋਕਾਨ੍ ਆਹੂਯ ਪ੍ਰੋਕ੍ਤਵਾਨ੍, ਯੂਯੰ ਸ਼੍ਰੁਤ੍ਵਾ ਬੁਧ੍ਯਧ੍ਬੰ| ");
INSERT INTO sanpun_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ਯਨ੍ਮੁਖੰ ਪ੍ਰਵਿਸ਼ਤਿ, ਤਤ੍ ਮਨੁਜਮ੍ ਅਮੇਧ੍ਯੰ ਨ ਕਰੋਤਿ, ਕਿਨ੍ਤੁ ਯਦਾਸ੍ਯਾਤ੍ ਨਿਰ੍ਗੱਛਤਿ, ਤਦੇਵ ਮਾਨੁਸ਼਼ਮਮੇਧ੍ਯੀ ਕਰੋਤੀ| ");
INSERT INTO sanpun_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","ਤਦਾਨੀਂ ਸ਼ਿਸ਼਼੍ਯਾ ਆਗਤ੍ਯ ਤਸ੍ਮੈ ਕਥਯਾਞ੍ਚਕ੍ਰੁਃ, ਏਤਾਂ ਕਥਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਫਿਰੂਸ਼ਿਨੋ ਵ੍ਯਰਜ੍ਯਨ੍ਤ, ਤਤ੍ ਕਿੰ ਭਵਤਾ ਜ੍ਞਾਯਤੇ? ");
INSERT INTO sanpun_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ਸ ਪ੍ਰਤ੍ਯਵਦਤ੍, ਮਮ ਸ੍ਵਰ੍ਗਸ੍ਥਃ ਪਿਤਾ ਯੰ ਕਞ੍ਚਿਦਙ੍ਕੁਰੰ ਨਾਰੋਪਯਤ੍, ਸ ਉਤ੍ਪਾਵ੍ਦ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","ਤੇ ਤਿਸ਼਼੍ਠਨ੍ਤੁ, ਤੇ ਅਨ੍ਧਮਨੁਜਾਨਾਮ੍ ਅਨ੍ਧਮਾਰ੍ਗਦਰ੍ਸ਼ਕਾ ਏਵ; ਯਦ੍ਯਨ੍ਧੋ(ਅ)ਨ੍ਧੰ ਪਨ੍ਥਾਨੰ ਦਰ੍ਸ਼ਯਤਿ, ਤਰ੍ਹ੍ਯੁਭੌ ਗਰ੍ੱਤੇ ਪਤਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ਤਦਾ ਪਿਤਰਸ੍ਤੰ ਪ੍ਰਤ੍ਯਵਦਤ੍, ਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤਮਿਮਮਸ੍ਮਾਨ੍ ਬੋਧਯਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ਯੀਸ਼ੁਨਾ ਪ੍ਰੋਕ੍ਤੰ, ਯੂਯਮਦ੍ਯ ਯਾਵਤ੍ ਕਿਮਬੋਧਾਃ ਸ੍ਥ? ");
INSERT INTO sanpun_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","ਕਥਾਮਿਮਾਂ ਕਿੰ ਨ ਬੁਧ੍ਯਧ੍ਬੇ ? ਯਦਾਸ੍ਯੰ ਪ੍ਰੇਵਿਸ਼ਤਿ, ਤਦ੍ ਉਦਰੇ ਪਤਨ੍ ਬਹਿਰ੍ਨਿਰ੍ਯਾਤਿ, ");
INSERT INTO sanpun_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","ਕਿਨ੍ਤ੍ਵਾਸ੍ਯਾਦ੍ ਯੰਨਿਰ੍ਯਾਤਿ, ਤਦ੍ ਅਨ੍ਤਃਕਰਣਾਤ੍ ਨਿਰ੍ਯਾਤਤ੍ਵਾਤ੍ ਮਨੁਜਮਮੇਧ੍ਯੰ ਕਰੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","ਯਤੋ(ਅ)ਨ੍ਤਃਕਰਣਾਤ੍ ਕੁਚਿਨ੍ਤਾ ਬਧਃ ਪਾਰਦਾਰਿਕਤਾ ਵੇਸ਼੍ਯਾਗਮਨੰ ਚੈਰ੍ੱਯੰ ਮਿਥ੍ਯਾਸਾਕ੍ਸ਼਼੍ਯਮ੍ ਈਸ਼੍ਵਰਨਿਨ੍ਦਾ ਚੈਤਾਨਿ ਸਰ੍ੱਵਾਣਿ ਨਿਰ੍ੱਯਾਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ਏਤਾਨਿ ਮਨੁਸ਼਼੍ਯਮਪਵਿਤ੍ਰੀ ਕੁਰ੍ੱਵਨ੍ਤਿ ਕਿਨ੍ਤ੍ਵਪ੍ਰਕ੍ਸ਼਼ਾਲਿਤਕਰੇਣ ਭੋਜਨੰ ਮਨੁਜਮਮੇਧ੍ਯੰ ਨ ਕਰੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ਅਨਨ੍ਤਰੰ ਯੀਸ਼ੁਸ੍ਤਸ੍ਮਾਤ੍ ਸ੍ਥਾਨਾਤ੍ ਪ੍ਰਸ੍ਥਾਯ ਸੋਰਸੀਦੋੰਨਗਰਯੋਃ ਸੀਮਾਮੁਪਤਸ੍ਯੌ| ");
INSERT INTO sanpun_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ਤਦਾ ਤਤ੍ਸੀਮਾਤਃ ਕਾਚਿਤ੍ ਕਿਨਾਨੀਯਾ ਯੋਸ਼਼ਿਦ੍ ਆਗਤ੍ਯ ਤਮੁੱਚੈਰੁਵਾਚ, ਹੇ ਪ੍ਰਭੋ ਦਾਯੂਦਃ ਸਨ੍ਤਾਨ, ਮਮੈਕਾ ਦੁਹਿਤਾਸ੍ਤੇ ਸਾ ਭੂਤਗ੍ਰਸ੍ਤਾ ਸਤੀ ਮਹਾਕ੍ਲੇਸ਼ੰ ਪ੍ਰਾਪ੍ਨੋਤਿ ਮਮ ਦਯਸ੍ਵ| ");
INSERT INTO sanpun_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","ਕਿਨ੍ਤੁ ਯੀਸ਼ੁਸ੍ਤਾਂ ਕਿਮਪਿ ਨੋਕ੍ਤਵਾਨ੍, ਤਤਃ ਸ਼ਿਸ਼਼੍ਯਾ ਆਗਤ੍ਯ ਤੰ ਨਿਵੇਦਯਾਮਾਸੁਃ, ਏਸ਼਼ਾ ਯੋਸ਼਼ਿਦ੍ ਅਸ੍ਮਾਕੰ ਪਸ਼੍ਚਾਦ੍ ਉੱਚੈਰਾਹੂਯਾਗੱਛਤਿ, ਏਨਾਂ ਵਿਸ੍ਰੁʼਜਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ਤਦਾ ਸ ਪ੍ਰਤ੍ਯਵਦਤ੍, ਇਸ੍ਰਾਯੇਲ੍ਗੋਤ੍ਰਸ੍ਯ ਹਾਰਿਤਮੇਸ਼਼ਾਨ੍ ਵਿਨਾ ਕਸ੍ਯਾਪ੍ਯਨ੍ਯਸ੍ਯ ਸਮੀਪੰ ਨਾਹੰ ਪ੍ਰੇਸ਼਼ਿਤੋਸ੍ਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","ਤਤਃ ਸਾ ਨਾਰੀਸਮਾਗਤ੍ਯ ਤੰ ਪ੍ਰਣਮ੍ਯ ਜਗਾਦ, ਹੇ ਪ੍ਰਭੋ ਮਾਮੁਪਕੁਰੁ| ");
INSERT INTO sanpun_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ਸ ਉਕ੍ਤਵਾਨ੍, ਬਾਲਕਾਨਾਂ ਭਕ੍ਸ਼਼੍ਯਮਾਦਾਯ ਸਾਰਮੇਯੇਭ੍ਯੋ ਦਾਨੰ ਨੋਚਿਤੰ| ");
INSERT INTO sanpun_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ਤਦਾ ਸਾ ਬਭਾਸ਼਼ੇ, ਹੇ ਪ੍ਰਭੋ, ਤਤ੍ ਸਤ੍ਯੰ, ਤਥਾਪਿ ਪ੍ਰਭੋ ਰ੍ਭਞ੍ਚਾਦ੍ ਯਦੁੱਛਿਸ਼਼੍ਟੰ ਪਤਤਿ, ਤਤ੍ ਸਾਰਮੇਯਾਃ ਖਾਦਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ਤਤੋ ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯਵਦਤ੍, ਹੇ ਯੋਸ਼਼ਿਤ੍, ਤਵ ਵਿਸ਼੍ਵਾਸੋ ਮਹਾਨ੍ ਤਸ੍ਮਾਤ੍ ਤਵ ਮਨੋਭਿਲਸ਼਼ਿਤੰ ਸਿਦ੍ੱਯਤੁ, ਤੇਨ ਤਸ੍ਯਾਃ ਕਨ੍ਯਾ ਤਸ੍ਮਿੰਨੇਵ ਦਣ੍ਡੇ ਨਿਰਾਮਯਾਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ਅਨਨ੍ਤਰੰ ਯੀਸ਼ਸ੍ਤਸ੍ਮਾਤ੍ ਸ੍ਥਾਨਾਤ੍ ਪ੍ਰਸ੍ਥਾਯ ਗਾਲੀਲ੍ਸਾਗਰਸ੍ਯ ਸੰਨਿਧਿਮਾਗਤ੍ਯ ਧਰਾਧਰਮਾਰੁਹ੍ਯ ਤਤ੍ਰੋਪਵਿਵੇਸ਼| ");
INSERT INTO sanpun_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ਪਸ਼੍ਚਾਤ੍ ਜਨਨਿਵਹੋ ਬਹੂਨ੍ ਖਞ੍ਚਾਨ੍ਧਮੂਕਸ਼ੁਸ਼਼੍ਕਕਰਮਾਨੁਸ਼਼ਾਨ੍ ਆਦਾਯ ਯੀਸ਼ੋਃ ਸਮੀਪਮਾਗਤ੍ਯ ਤੱਚਰਣਾਨ੍ਤਿਕੇ ਸ੍ਥਾਪਯਾਮਾਸੁਃ, ਤਤਃ ਸਾ ਤਾਨ੍ ਨਿਰਾਮਯਾਨ੍ ਅਕਰੋਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ਇੱਥੰ ਮੂਕਾ ਵਾਕ੍ਯੰ ਵਦਨ੍ਤਿ, ਸ਼ੁਸ਼਼੍ਕਕਰਾਃ ਸ੍ਵਾਸ੍ਥ੍ਯਮਾਯਾਨ੍ਤਿ, ਪਙ੍ਗਵੋ ਗੱਛਨ੍ਤਿ, ਅਨ੍ਧਾ ਵੀਕ੍ਸ਼਼ਨ੍ਤੇ, ਇਤਿ ਵਿਲੋਕ੍ਯ ਲੋਕਾ ਵਿਸ੍ਮਯੰ ਮਨ੍ਯਮਾਨਾ ਇਸ੍ਰਾਯੇਲ ਈਸ਼੍ਵਰੰ ਧਨ੍ਯੰ ਬਭਾਸ਼਼ਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","ਤਦਾਨੀਂ ਯੀਸ਼ੁਃ ਸ੍ਵਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਆਹੂਯ ਗਦਿਤਵਾਨ੍, ਏਤੱਜਨਨਿਵਹੇਸ਼਼ੁ ਮਮ ਦਯਾ ਜਾਯਤੇ, ਏਤੇ ਦਿਨਤ੍ਰਯੰ ਮਯਾ ਸਾਕੰ ਸਨ੍ਤਿ, ਏਸ਼਼ਾਂ ਭਕ੍ਸ਼਼੍ਯਵਸ੍ਤੁ ਚ ਕਞ੍ਚਿਦਪਿ ਨਾਸ੍ਤਿ, ਤਸ੍ਮਾਦਹਮੇਤਾਨਕ੍ਰੁʼਤਾਹਾਰਾਨ੍ ਨ ਵਿਸ੍ਰਕ੍ਸ਼਼੍ਯਾਮਿ, ਤਥਾਤ੍ਵੇ ਵਰ੍ਤ੍ਮਮਧ੍ਯੇ ਕ੍ਲਾਮ੍ਯੇਸ਼਼ੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","ਤਦਾ ਸ਼ਿਸ਼਼੍ਯਾ ਊਚੁਃ, ਏਤਸ੍ਮਿਨ੍ ਪ੍ਰਾਨ੍ਤਰਮਧ੍ਯ ਏਤਾਵਤੋ ਮਰ੍ਤ੍ਯਾਨ੍ ਤਰ੍ਪਯਿਤੁੰ ਵਯੰ ਕੁਤ੍ਰ ਪੂਪਾਨ੍ ਪ੍ਰਾਪ੍ਸ੍ਯਾਮਃ? ");
INSERT INTO sanpun_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ਯੀਸ਼ੁਰਪ੍ਰੁʼੱਛਤ੍, ਯੁਸ਼਼੍ਮਾਕੰ ਨਿਕਟੇ ਕਤਿ ਪੂਪਾ ਆਸਤੇ? ਤ ਊਚੁਃ, ਸਪ੍ਤਪੂਪਾ ਅਲ੍ਪਾਃ ਕ੍ਸ਼਼ੁਦ੍ਰਮੀਨਾਸ਼੍ਚ ਸਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","ਤਦਾਨੀਂ ਸ ਲੋਕਨਿਵਹੰ ਭੂਮਾਵੁਪਵੇਸ਼਼੍ਟੁਮ੍ ਆਦਿਸ਼੍ਯ ");
INSERT INTO sanpun_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ਤਾਨ੍ ਸਪ੍ਤਪੂਪਾਨ੍ ਮੀਨਾਂਸ਼੍ਚ ਗ੍ਰੁʼਹ੍ਲਨ੍ ਈਸ਼੍ਵਰੀਯਗੁਣਾਨ੍ ਅਨੂਦ੍ਯ ਭੰਕ੍ਤ੍ਵਾ ਸ਼ਿਸ਼਼੍ਯੇਭ੍ਯੋ ਦਦੌ, ਸ਼ਿਸ਼਼੍ਯਾ ਲੋਕੇਭ੍ਯੋ ਦਦੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ਤਤਃ ਸਰ੍ੱਵੇ ਭੁਕ੍ਤ੍ਵਾ ਤ੍ਰੁʼਪ੍ਤਵਨ੍ਤਃ; ਤਦਵਸ਼ਿਸ਼਼੍ਟਭਕ੍ਸ਼਼੍ਯੇਣ ਸਪ੍ਤਡਲਕਾਨ੍ ਪਰਿਪੂਰ੍ੱਯ ਸੰਜਗ੍ਰੁʼਹੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","ਤੇ ਭੋਕ੍ਤਾਰੋ ਯੋਸ਼਼ਿਤੋ ਬਾਲਕਾਂਸ਼੍ਚ ਵਿਹਾਯ ਪ੍ਰਾਯੇਣ ਚਤੁਃਸਹਸ੍ਰਾਣਿ ਪੁਰੁਸ਼਼ਾ ਆਸਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","ਤਤਃ ਪਰੰ ਸ ਜਨਨਿਵਹੰ ਵਿਸ੍ਰੁʼਜ੍ਯ ਤਰਿਮਾਰੁਹ੍ਯ ਮਗ੍ਦਲਾਪ੍ਰਦੇਸ਼ੰ ਗਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ਤਦਾਨੀਂ ਫਿਰੂਸ਼ਿਨਃ ਸਿਦੂਕਿਨਸ਼੍ਚਾਗਤ੍ਯ ਤੰ ਪਰੀਕ੍ਸ਼਼ਿਤੁੰ ਨਭਮੀਯੰ ਕਿਞ੍ਚਨ ਲਕ੍ਸ਼਼੍ਮ ਦਰ੍ਸ਼ਯਿਤੁੰ ਤਸ੍ਮੈ ਨਿਵੇਦਯਾਮਾਸੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ਤਤਃ ਸ ਉਕ੍ਤਵਾਨ੍, ਸਨ੍ਧ੍ਯਾਯਾਂ ਨਭਸੋ ਰਕ੍ਤਤ੍ਵਾਦ੍ ਯੂਯੰ ਵਦਥ, ਸ਼੍ਵੋ ਨਿਰ੍ੰਮਲੰ ਦਿਨੰ ਭਵਿਸ਼਼੍ਯਤਿ; ");
INSERT INTO sanpun_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ਪ੍ਰਾਤਃਕਾਲੇ ਚ ਨਭਸੋ ਰਕ੍ਤਤ੍ਵਾਤ੍ ਮਲਿਨਤ੍ਵਾਞ੍ਚ ਵਦਥ, ਝਞ੍ਭ੍ਸ਼ਦ੍ਯ ਭਵਿਸ਼਼੍ਯਤਿ| ਹੇ ਕਪਟਿਨੋ ਯਦਿ ਯੂਯਮ੍ ਅਨ੍ਤਰੀਕ੍ਸ਼਼ਸ੍ਯ ਲਕ੍ਸ਼਼੍ਮ ਬੋੱਧੁੰ ਸ਼ਕ੍ਨੁਥ, ਤਰ੍ਹਿ ਕਾਲਸ੍ਯੈਤਸ੍ਯ ਲਕ੍ਸ਼਼੍ਮ ਕਥੰ ਬੋੱਧੁੰ ਨ ਸ਼ਕ੍ਨੁਥ? ");
INSERT INTO sanpun_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ਏਤਤ੍ਕਾਲਸ੍ਯ ਦੁਸ਼਼੍ਟੋ ਵ੍ਯਭਿਚਾਰੀ ਚ ਵੰਸ਼ੋ ਲਕ੍ਸ਼਼੍ਮ ਗਵੇਸ਼਼ਯਤਿ, ਕਿਨ੍ਤੁ ਯੂਨਸੋ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨੋ ਲਕ੍ਸ਼਼੍ਮ ਵਿਨਾਨ੍ਯਤ੍ ਕਿਮਪਿ ਲਕ੍ਸ਼਼੍ਮ ਤਾਨ੍ ਨ ਦਰ੍ਸ਼ਯਿੱਯਤੇ| ਤਦਾਨੀਂ ਸ ਤਾਨ੍ ਵਿਹਾਯ ਪ੍ਰਤਸ੍ਥੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","ਅਨਨ੍ਤਰਮਨ੍ਯਪਾਰਗਮਨਕਾਲੇ ਤਸ੍ਯ ਸ਼ਿਸ਼਼੍ਯਾਃ ਪੂਪਮਾਨੇਤੁੰ ਵਿਸ੍ਮ੍ਰੁʼਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ਯੀਸ਼ੁਸ੍ਤਾਨਵਾਦੀਤ੍, ਯੂਯੰ ਫਿਰੂਸ਼ਿਨਾਂ ਸਿਦੂਕਿਨਾਞ੍ਚ ਕਿਣ੍ਵੰ ਪ੍ਰਤਿ ਸਾਵਧਾਨਾਃ ਸਤਰ੍ਕਾਸ਼੍ਚ ਭਵਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","ਤੇਨ ਤੇ ਪਰਸ੍ਪਰੰ ਵਿਵਿਚ੍ਯ ਕਥਯਿਤੁਮਾਰੇਭਿਰੇ, ਵਯੰ ਪੂਪਾਨਾਨੇਤੁੰ ਵਿਸ੍ਮ੍ਰੁʼਤਵਨ੍ਤ ਏਤਤ੍ਕਾਰਣਾਦ੍ ਇਤਿ ਕਥਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","ਕਿਨ੍ਤੁ ਯੀਸ਼ੁਸ੍ਤਦ੍ਵਿਜ੍ਞਾਯ ਤਾਨਵੋਚਤ੍, ਹੇ ਸ੍ਤੋਕਵਿਸ਼੍ਵਾਸਿਨੋ ਯੂਯੰ ਪੂਪਾਨਾਨਯਨਮਧਿ ਕੁਤਃ ਪਰਸ੍ਪਰਮੇਤਦ੍ ਵਿਵਿੰਕ੍ਯ? ");
INSERT INTO sanpun_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","ਯੁਸ਼਼੍ਮਾਭਿਃ ਕਿਮਦ੍ਯਾਪਿ ਨ ਜ੍ਞਾਯਤੇ? ਪਞ੍ਚਭਿਃ ਪੂਪੈਃ ਪਞ੍ਚਸਹਸ੍ਰਪੁਰੁਸ਼਼ੇਸ਼਼ੁ ਭੋਜਿਤੇਸ਼਼ੁ ਭਕ੍ਸ਼਼੍ਯੋੱਛਿਸ਼਼੍ਟਪੂਰ੍ਣਾਨ੍ ਕਤਿ ਡਲਕਾਨ੍ ਸਮਗ੍ਰੁʼਹ੍ਲੀਤੰ; ");
INSERT INTO sanpun_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ਤਥਾ ਸਪ੍ਤਭਿਃ ਪੂਪੈਸ਼੍ਚਤੁਃਸਹਸ੍ਰਪੁਰੁਸ਼਼ੇਸ਼਼ੁ ਭੇਜਿਤੇਸ਼਼ੁ ਕਤਿ ਡਲਕਾਨ੍ ਸਮਗ੍ਰੁʼਹ੍ਲੀਤ, ਤਤ੍ ਕਿੰ ਯੁਸ਼਼੍ਮਾਭਿਰ੍ਨ ਸ੍ਮਰ੍ੱਯਤੇ? ");
INSERT INTO sanpun_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","ਤਸ੍ਮਾਤ੍ ਫਿਰੂਸ਼ਿਨਾਂ ਸਿਦੂਕਿਨਾਞ੍ਚ ਕਿਣ੍ਵੰ ਪ੍ਰਤਿ ਸਾਵਧਾਨਾਸ੍ਤਿਸ਼਼੍ਠਤ, ਕਥਾਮਿਮਾਮ੍ ਅਹੰ ਪੂਪਾਨਧਿ ਨਾਕਥਯੰ, ਏਤਦ੍ ਯੂਯੰ ਕੁਤੋ ਨ ਬੁਧ੍ਯਧ੍ਵੇ? ");
INSERT INTO sanpun_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","ਤਦਾਨੀਂ ਪੂਪਕਿਣ੍ਵੰ ਪ੍ਰਤਿ ਸਾਵਧਾਨਾਸ੍ਤਿਸ਼਼੍ਠਤੇਤਿ ਨੋਕ੍ਤ੍ਵਾ ਫਿਰੂਸ਼ਿਨਾਂ ਸਿਦੂਕਿਨਾਞ੍ਚ ਉਪਦੇਸ਼ੰ ਪ੍ਰਤਿ ਸਾਵਧਾਨਾਸ੍ਤਿਸ਼਼੍ਠਤੇਤਿ ਕਥਿਤਵਾਨ੍, ਇਤਿ ਤੈਰਬੋਧਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","ਅਪਰਞ੍ਚ ਯੀਸ਼ੁਃ ਕੈਸਰਿਯਾ-ਫਿਲਿਪਿਪ੍ਰਦੇਸ਼ਮਾਗਤ੍ਯ ਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਅਪ੍ਰੁʼੱਛਤ੍, ਯੋ(ਅ)ਹੰ ਮਨੁਜਸੁਤਃ ਸੋ(ਅ)ਹੰ ਕਃ? ਲੋਕੈਰਹੰ ਕਿਮੁਚ੍ਯੇ? ");
INSERT INTO sanpun_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","ਤਦਾਨੀਂ ਤੇ ਕਥਿਤਵਨ੍ਤਃ, ਕੇਚਿਦ੍ ਵਦਨ੍ਤਿ ਤ੍ਵੰ ਮੱਜਯਿਤਾ ਯੋਹਨ੍, ਕੇਚਿਦ੍ਵਦਨ੍ਤਿ, ਤ੍ਵਮ੍ ਏਲਿਯਃ, ਕੇਚਿੱਚ ਵਦਨ੍ਤਿ, ਤ੍ਵੰ ਯਿਰਿਮਿਯੋ ਵਾ ਕਸ਼੍ਚਿਦ੍ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦੀਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ਪਸ਼੍ਚਾਤ੍ ਸ ਤਾਨ੍ ਪਪ੍ਰੱਛ, ਯੂਯੰ ਮਾਂ ਕੰ ਵਦਥ? ਤਤਃ ਸ਼ਿਮੋਨ੍ ਪਿਤਰ ਉਵਾਚ, ");
INSERT INTO sanpun_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ਤ੍ਵਮਮਰੇਸ਼੍ਵਰਸ੍ਯਾਭਿਸ਼਼ਿਕ੍ਤਪੁਤ੍ਰਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ਤਤੋ ਯੀਸ਼ੁਃ ਕਥਿਤਵਾਨ੍, ਹੇ ਯੂਨਸਃ ਪੁਤ੍ਰ ਸ਼ਿਮੋਨ੍ ਤ੍ਵੰ ਧਨ੍ਯਃ; ਯਤਃ ਕੋਪਿ ਅਨੁਜਸ੍ਤ੍ਵੱਯੇਤੱਜ੍ਞਾਨੰ ਨੋਦਪਾਦਯਤ੍, ਕਿਨ੍ਤੁ ਮਮ ਸ੍ਵਰ੍ਗਸ੍ਯਃ ਪਿਤੋਦਪਾਦਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","ਅਤੋ(ਅ)ਹੰ ਤ੍ਵਾਂ ਵਦਾਮਿ, ਤ੍ਵੰ ਪਿਤਰਃ (ਪ੍ਰਸ੍ਤਰਃ) ਅਹਞ੍ਚ ਤਸ੍ਯ ਪ੍ਰਸ੍ਤਰਸ੍ਯੋਪਰਿ ਸ੍ਵਮਣ੍ਡਲੀਂ ਨਿਰ੍ੰਮਾਸ੍ਯਾਮਿ, ਤੇਨ ਨਿਰਯੋ ਬਲਾਤ੍ ਤਾਂ ਪਰਾਜੇਤੁੰ ਨ ਸ਼ਕ੍ਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","ਅਹੰ ਤੁਭ੍ਯੰ ਸ੍ਵਰ੍ਗੀਯਰਾਜ੍ਯਸ੍ਯ ਕੁਞ੍ਜਿਕਾਂ ਦਾਸ੍ਯਾਮਿ, ਤੇਨ ਯਤ੍ ਕਿਞ੍ਚਨ ਤ੍ਵੰ ਪ੍ਰੁʼਥਿਵ੍ਯਾਂ ਭੰਤ੍ਸ੍ਯਸਿ ਤਤ੍ਸ੍ਵਰ੍ਗੇ ਭੰਤ੍ਸ੍ਯਤੇ, ਯੱਚ ਕਿਞ੍ਚਨ ਮਹ੍ਯਾਂ ਮੋਕ੍ਸ਼਼੍ਯਸਿ ਤਤ੍ ਸ੍ਵਰ੍ਗੇ ਮੋਕ੍ਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","ਪਸ਼੍ਚਾਤ੍ ਸ ਸ਼ਿਸ਼਼੍ਯਾਨਾਦਿਸ਼ਤ੍, ਅਹਮਭਿਸ਼਼ਿਕ੍ਤੋ ਯੀਸ਼ੁਰਿਤਿ ਕਥਾਂ ਕਸ੍ਮੈਚਿਦਪਿ ਯੂਯੰ ਮਾ ਕਥਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ਅਨ੍ਯਞ੍ਚ ਯਿਰੂਸ਼ਾਲਮ੍ਨਗਰੰ ਗਤ੍ਵਾ ਪ੍ਰਾਚੀਨਲੋਕੇਭ੍ਯਃ ਪ੍ਰਧਾਨਯਾਜਕੇਭ੍ਯ ਉਪਾਧ੍ਯਾਯੇਭ੍ਯਸ਼੍ਚ ਬਹੁਦੁਃਖਭੋਗਸ੍ਤੈ ਰ੍ਹਤਤ੍ਵੰ ਤ੍ਰੁʼਤੀਯਦਿਨੇ ਪੁਨਰੁੱਥਾਨਞ੍ਚ ਮਮਾਵਸ਼੍ਯਕਮ੍ ਏਤਾਃ ਕਥਾ ਯੀਸ਼ੁਸ੍ਤਤ੍ਕਾਲਮਾਰਭ੍ਯ ਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਜ੍ਞਾਪਯਿਤੁਮ੍ ਆਰਬ੍ਧਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ਤਦਾਨੀਂ ਪਿਤਰਸ੍ਤਸ੍ਯ ਕਰੰ ਘ੍ਰੁʼਤ੍ਵਾ ਤਰ੍ਜਯਿਤ੍ਵਾ ਕਥਯਿਤੁਮਾਰਬ੍ਧਵਾਨ੍, ਹੇ ਪ੍ਰਭੋ, ਤਤ੍ ਤ੍ਵੱਤੋ ਦੂਰੰ ਯਾਤੁ, ਤ੍ਵਾਂ ਪ੍ਰਤਿ ਕਦਾਪਿ ਨ ਘਟਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ਕਿਨ੍ਤੁ ਸ ਵਦਨੰ ਪਰਾਵਰ੍ਤ੍ਯ ਪਿਤਰੰ ਜਗਾਦ, ਹੇ ਵਿਘ੍ਨਕਾਰਿਨ੍, ਮਤ੍ਸੰਮੁਖਾਦ੍ ਦੂਰੀਭਵ, ਤ੍ਵੰ ਮਾਂ ਬਾਧਸੇ, ਈਸ਼੍ਵਰੀਯਕਾਰ੍ੱਯਾਤ੍ ਮਾਨੁਸ਼਼ੀਯਕਾਰ੍ੱਯੰ ਤੁਭ੍ਯੰ ਰੋਚਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","ਅਨਨ੍ਤਰੰ ਯੀਸ਼ੁਃ ਸ੍ਵੀਯਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਉਕ੍ਤਵਾਨ੍ ਯਃ ਕਸ਼੍ਚਿਤ੍ ਮਮ ਪਸ਼੍ਚਾਦ੍ਗਾਮੀ ਭਵਿਤੁਮ੍ ਇੱਛਤਿ, ਸ ਸ੍ਵੰ ਦਾਮ੍ਯਤੁ, ਤਥਾ ਸ੍ਵਕ੍ਰੁਸ਼ੰ ਗ੍ਰੁʼਹ੍ਲਨ੍ ਮਤ੍ਪਸ਼੍ਚਾਦਾਯਾਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","ਯਤੋ ਯਃ ਪ੍ਰਾਣਾਨ੍ ਰਕ੍ਸ਼਼ਿਤੁਮਿੱਛਤਿ, ਸ ਤਾਨ੍ ਹਾਰਯਿਸ਼਼੍ਯਤਿ, ਕਿਨ੍ਤੁ ਯੋ ਮਦਰ੍ਥੰ ਨਿਜਪ੍ਰਾਣਾਨ੍ ਹਾਰਯਤਿ, ਸ ਤਾਨ੍ ਪ੍ਰਾਪ੍ਸ੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","ਮਾਨੁਸ਼਼ੋ ਯਦਿ ਸਰ੍ੱਵੰ ਜਗਤ੍ ਲਭਤੇ ਨਿਜਪ੍ਰਣਾਨ੍ ਹਾਰਯਤਿ, ਤਰ੍ਹਿ ਤਸ੍ਯ ਕੋ ਲਾਭਃ? ਮਨੁਜੋ ਨਿਜਪ੍ਰਾਣਾਨਾਂ ਵਿਨਿਮਯੇਨ ਵਾ ਕਿੰ ਦਾਤੁੰ ਸ਼ਕ੍ਨੋਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","ਮਨੁਜਸੁਤਃ ਸ੍ਵਦੂਤੈਃ ਸਾਕੰ ਪਿਤੁਃ ਪ੍ਰਭਾਵੇਣਾਗਮਿਸ਼਼੍ਯਤਿ; ਤਦਾ ਪ੍ਰਤਿਮਨੁਜੰ ਸ੍ਵਸ੍ਵਕਰ੍ੰਮਾਨੁਸਾਰਾਤ੍ ਫਲੰ ਦਾਸ੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","ਅਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਤਥ੍ਯੰ ਵਚ੍ਮਿ, ਸਰਾਜ੍ਯੰ ਮਨੁਜਸੁਤਮ੍ ਆਗਤੰ ਨ ਪਸ਼੍ਯਨ੍ਤੋ ਮ੍ਰੁʼਤ੍ਯੁੰ ਨ ਸ੍ਵਾਦਿਸ਼਼੍ਯਨ੍ਤਿ, ਏਤਾਦ੍ਰੁʼਸ਼ਾਃ ਕਤਿਪਯਜਨਾ ਅਤ੍ਰਾਪਿ ਦਣ੍ਡਾਯਮਾਨਾਃ ਸਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","ਅਨਨ੍ਤਰੰ ਸ਼਼ਡ੍ਦਿਨੇਭ੍ਯਃ ਪਰੰ ਯੀਸ਼ੁਃ ਪਿਤਰੰ ਯਾਕੂਬੰ ਤਤ੍ਸਹਜੰ ਯੋਹਨਞ੍ਚ ਗ੍ਰੁʼਹ੍ਲਨ੍ ਉੱਚਾਦ੍ਰੇ ਰ੍ਵਿਵਿਕ੍ਤਸ੍ਥਾਨਮ੍ ਆਗਤ੍ਯ ਤੇਸ਼਼ਾਂ ਸਮਕ੍ਸ਼਼ੰ ਰੂਪਮਨ੍ਯਤ੍ ਦਧਾਰ| ");
INSERT INTO sanpun_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ਤੇਨ ਤਦਾਸ੍ਯੰ ਤੇਜਸ੍ਵਿ, ਤਦਾਭਰਣਮ੍ ਆਲੋਕਵਤ੍ ਪਾਣ੍ਡਰਮਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ਅਨ੍ਯੱਚ ਤੇਨ ਸਾਕੰ ਸੰਲਪਨ੍ਤੌ ਮੂਸਾ ਏਲਿਯਸ਼੍ਚ ਤੇਭ੍ਯੋ ਦਰ੍ਸ਼ਨੰ ਦਦਤੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ਤਦਾਨੀਂ ਪਿਤਰੋ ਯੀਸ਼ੁੰ ਜਗਾਦ, ਹੇ ਪ੍ਰਭੋ ਸ੍ਥਿਤਿਰਤ੍ਰਾਸ੍ਮਾਕੰ ਸ਼ੁਭਾ, ਯਦਿ ਭਵਤਾਨੁਮਨ੍ਯਤੇ, ਤਰ੍ਹਿ ਭਵਦਰ੍ਥਮੇਕੰ ਮੂਸਾਰ੍ਥਮੇਕਮ੍ ਏਲਿਯਾਰ੍ਥਞ੍ਚੈਕਮ੍ ਇਤਿ ਤ੍ਰੀਣਿ ਦੂਸ਼਼੍ਯਾਣਿ ਨਿਰ੍ੰਮਮ| ");
INSERT INTO sanpun_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ਏਤਤ੍ਕਥਨਕਾਲ ਏਕ ਉੱਜਵਲਃ ਪਯੋਦਸ੍ਤੇਸ਼਼ਾਮੁਪਰਿ ਛਾਯਾਂ ਕ੍ਰੁʼਤਵਾਨ੍, ਵਾਰਿਦਾਦ੍ ਏਸ਼਼ਾ ਨਭਸੀਯਾ ਵਾਗ੍ ਬਭੂਵ, ਮਮਾਯੰ ਪ੍ਰਿਯਃ ਪੁਤ੍ਰਃ, ਅਸ੍ਮਿਨ੍ ਮਮ ਮਹਾਸਨ੍ਤੋਸ਼਼ ਏਤਸ੍ਯ ਵਾਕ੍ਯੰ ਯੂਯੰ ਨਿਸ਼ਾਮਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","ਕਿਨ੍ਤੁ ਵਾਚਮੇਤਾਂ ਸ਼੍ਰੁʼਣ੍ਵਨ੍ਤਏਵ ਸ਼ਿਸ਼਼੍ਯਾ ਮ੍ਰੁʼਸ਼ੰ ਸ਼ਙ੍ਕਮਾਨਾ ਨ੍ਯੁਬ੍ਜਾ ਨ੍ਯਪਤਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ਤਦਾ ਯੀਸ਼ੁਰਾਗਤ੍ਯ ਤੇਸ਼਼ਾਂ ਗਾਤ੍ਰਾਣਿ ਸ੍ਪ੍ਰੁʼਸ਼ਨ੍ ਉਵਾਚ, ਉੱਤਿਸ਼਼੍ਠਤ, ਮਾ ਭੈਸ਼਼੍ਟ| ");
INSERT INTO sanpun_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ਤਦਾਨੀਂ ਨੇਤ੍ਰਾਣ੍ਯੁਨ੍ਮੀਲ੍ਯ ਯੀਸ਼ੁੰ ਵਿਨਾ ਕਮਪਿ ਨ ਦਦ੍ਰੁʼਸ਼ੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ਤਤਃ ਪਰਮ੍ ਅਦ੍ਰੇਰਵਰੋਹਣਕਾਲੇ ਯੀਸ਼ੁਸ੍ਤਾਨ੍ ਇਤ੍ਯਾਦਿਦੇਸ਼, ਮਨੁਜਸੁਤਸ੍ਯ ਮ੍ਰੁʼਤਾਨਾਂ ਮਧ੍ਯਾਦੁੱਥਾਨੰ ਯਾਵੰਨ ਜਾਯਤੇ, ਤਾਵਤ੍ ਯੁਸ਼਼੍ਮਾਭਿਰੇਤੱਦਰ੍ਸ਼ਨੰ ਕਸ੍ਮੈਚਿਦਪਿ ਨ ਕਥਯਿਤਵ੍ਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","ਤਦਾ ਸ਼ਿਸ਼਼੍ਯਾਸ੍ਤੰ ਪਪ੍ਰੱਛੁਃ, ਪ੍ਰਥਮਮ੍ ਏਲਿਯ ਆਯਾਸ੍ਯਤੀਤਿ ਕੁਤ ਉਪਾਧ੍ਯਾਯੈਰੁਚ੍ਯਤੇ? ");
INSERT INTO sanpun_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ਤਤੋ ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯਵਾਦੀਤ੍, ਏਲਿਯਃ ਪ੍ਰਾਗੇਤ੍ਯ ਸਰ੍ੱਵਾਣਿ ਸਾਧਯਿਸ਼਼੍ਯਤੀਤਿ ਸਤ੍ਯੰ, ");
INSERT INTO sanpun_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","ਕਿਨ੍ਤ੍ਵਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਵਚ੍ਮਿ, ਏਲਿਯ ਏਤ੍ਯ ਗਤਃ, ਤੇ ਤਮਪਰਿਚਿਤ੍ਯ ਤਸ੍ਮਿਨ੍ ਯਥੇੱਛੰ ਵ੍ਯਵਜਹੁਃ; ਮਨੁਜਸੁਤੇਨਾਪਿ ਤੇਸ਼਼ਾਮਨ੍ਤਿਕੇ ਤਾਦ੍ਰੁʼਗ੍ ਦੁਃਖੰ ਭੋਕ੍ਤਵ੍ਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","ਤਦਾਨੀਂ ਸ ਮੱਜਯਿਤਾਰੰ ਯੋਹਨਮਧਿ ਕਥਾਮੇਤਾਂ ਵ੍ਯਾਹ੍ਰੁʼਤਵਾਨ੍, ਇੱਥੰ ਤੱਛਿਸ਼਼੍ਯਾ ਬੁਬੁਧਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ਪਸ਼੍ਚਾਤ੍ ਤੇਸ਼਼ੁ ਜਨਨਿਵਹਸ੍ਯਾਨ੍ਤਿਕਮਾਗਤੇਸ਼਼ੁ ਕਸ਼੍ਚਿਤ੍ ਮਨੁਜਸ੍ਤਦਨ੍ਤਿਕਮੇਤ੍ਯ ਜਾਨੂਨੀ ਪਾਤਯਿਤ੍ਵਾ ਕਥਿਤਵਾਨ੍, ");
INSERT INTO sanpun_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ਹੇ ਪ੍ਰਭੋ, ਮਤ੍ਪੁਤ੍ਰੰ ਪ੍ਰਤਿ ਕ੍ਰੁʼਪਾਂ ਵਿਦਧਾਤੁ, ਸੋਪਸ੍ਮਾਰਾਮਯੇਨ ਭ੍ਰੁʼਸ਼ੰ ਵ੍ਯਥਿਤਃ ਸਨ੍ ਪੁਨਃ ਪੁਨ ਰ੍ਵਹ੍ਨੌ ਮੁਹੁ ਰ੍ਜਲਮਧ੍ਯੇ ਪਤਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","ਤਸ੍ਮਾਦ੍ ਭਵਤਃ ਸ਼ਿਸ਼਼੍ਯਾਣਾਂ ਸਮੀਪੇ ਤਮਾਨਯੰ ਕਿਨ੍ਤੁ ਤੇ ਤੰ ਸ੍ਵਾਸ੍ਥੰ ਕਰ੍ੱਤੁੰ ਨ ਸ਼ਕ੍ਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ਤਦਾ ਯੀਸ਼ੁਃ ਕਥਿਤਵਾਨ੍ ਰੇ ਅਵਿਸ਼੍ਵਾਸਿਨਃ, ਰੇ ਵਿਪਥਗਾਮਿਨਃ, ਪੁਨਃ ਕਤਿਕਾਲਾਨ੍ ਅਹੰ ਯੁਸ਼਼੍ਮਾਕੰ ਸੰਨਿਧੌ ਸ੍ਥਾਸ੍ਯਾਮਿ? ਕਤਿਕਾਲਾਨ੍ ਵਾ ਯੁਸ਼਼੍ਮਾਨ੍ ਸਹਿਸ਼਼੍ਯੇ? ਤਮਤ੍ਰ ਮਮਾਨ੍ਤਿਕਮਾਨਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ਪਸ਼੍ਚਾਦ੍ ਯੀਸ਼ੁਨਾ ਤਰ੍ਜਤਏਵ ਸ ਭੂਤਸ੍ਤੰ ਵਿਹਾਯ ਗਤਵਾਨ੍, ਤੱਦਣ੍ਡਏਵ ਸ ਬਾਲਕੋ ਨਿਰਾਮਯੋ(ਅ)ਭੂਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ਤਤਃ ਸ਼ਿਸ਼਼੍ਯਾ ਗੁਪ੍ਤੰ ਯੀਸ਼ੁਮੁਪਾਗਤ੍ਯ ਬਭਾਸ਼਼ਿਰੇ, ਕੁਤੋ ਵਯੰ ਤੰ ਭੂਤੰ ਤ੍ਯਾਜਯਿਤੁੰ ਨ ਸ਼ਕ੍ਤਾਃ? ");
INSERT INTO sanpun_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ਯੀਸ਼ੁਨਾ ਤੇ ਪ੍ਰੋਕ੍ਤਾਃ, ਯੁਸ਼਼੍ਮਾਕਮਪ੍ਰਤ੍ਯਯਾਤ੍; ");
INSERT INTO sanpun_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","ਯੁਸ਼਼੍ਮਾਨਹੰ ਤਥ੍ਯੰ ਵਚ੍ਮਿ ਯਦਿ ਯੁਸ਼਼੍ਮਾਕੰ ਸਰ੍ਸ਼਼ਪੈਕਮਾਤ੍ਰੋਪਿ ਵਿਸ਼੍ਵਾਸੋ ਜਾਯਤੇ, ਤਰ੍ਹਿ ਯੁਸ਼਼੍ਮਾਭਿਰਸ੍ਮਿਨ੍ ਸ਼ੈਲੇ ਤ੍ਵਮਿਤਃ ਸ੍ਥਾਨਾਤ੍ ਤਤ੍ ਸ੍ਥਾਨੰ ਯਾਹੀਤਿ ਬ੍ਰੂਤੇ ਸ ਤਦੈਵ ਚਲਿਸ਼਼੍ਯਤਿ, ਯੁਸ਼਼੍ਮਾਕੰ ਕਿਮਪ੍ਯਸਾਧ੍ਯਞ੍ਚ ਕਰ੍ੰਮ ਨ ਸ੍ਥਾਸ੍ਯਾਤਿ| ਕਿਨ੍ਤੁ ਪ੍ਰਾਰ੍ਥਨੋਪਵਾਸੌ ਵਿਨੈਤਾਦ੍ਰੁʼਸ਼ੋ ਭੂਤੋ ਨ ਤ੍ਯਾਜ੍ਯੇਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","ਅਪਰੰ ਤੇਸ਼਼ਾਂ ਗਾਲੀਲ੍ਪ੍ਰਦੇਸ਼ੇ ਭ੍ਰਮਣਕਾਲੇ ਯੀਸ਼ੁਨਾ ਤੇ ਗਦਿਤਾਃ, ਮਨੁਜਸੁਤੋ ਜਨਾਨਾਂ ਕਰੇਸ਼਼ੁ ਸਮਰ੍ਪਯਿਸ਼਼੍ਯਤੇ ਤੈ ਰ੍ਹਨਿਸ਼਼੍ਯਤੇ ਚ, ");
INSERT INTO sanpun_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ਕਿਨ੍ਤੁ ਤ੍ਰੁʼਤੀਯੇ(ਅ)ਹਿ्ਨ ਮ ਉੱਥਾਪਿਸ਼਼੍ਯਤੇ, ਤੇਨ ਤੇ ਭ੍ਰੁʼਸ਼ੰ ਦੁਃਖਿਤਾ ਬਭੂਵਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","ਤਦਨਨ੍ਤਰੰ ਤੇਸ਼਼ੁ ਕਫਰ੍ਨਾਹੂਮ੍ਨਗਰਮਾਗਤੇਸ਼਼ੁ ਕਰਸੰਗ੍ਰਾਹਿਣਃ ਪਿਤਰਾਨ੍ਤਿਕਮਾਗਤ੍ਯ ਪਪ੍ਰੱਛੁਃ, ਯੁਸ਼਼੍ਮਾਕੰ ਗੁਰੁਃ ਕਿੰ ਮਨ੍ਦਿਰਾਰ੍ਥੰ ਕਰੰ ਨ ਦਦਾਤਿ? ਤਤਃ ਪਿਤਰਃ ਕਥਿਤਵਾਨ੍ ਦਦਾਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ਤਤਸ੍ਤਸ੍ਮਿਨ੍ ਗ੍ਰੁʼਹਮਧ੍ਯਮਾਗਤੇ ਤਸ੍ਯ ਕਥਾਕਥਨਾਤ੍ ਪੂਰ੍ੱਵਮੇਵ ਯੀਸ਼ੁਰੁਵਾਚ, ਹੇ ਸ਼ਿਮੋਨ੍, ਮੇਦਿਨ੍ਯਾ ਰਾਜਾਨਃ ਸ੍ਵਸ੍ਵਾਪਤ੍ਯੇਭ੍ਯਃ ਕਿੰ ਵਿਦੇਸ਼ਿਭ੍ਯਃ ਕੇਭ੍ਯਃ ਕਰੰ ਗ੍ਰੁʼਹ੍ਲਨ੍ਤਿ? ਅਤ੍ਰ ਤ੍ਵੰ ਕਿੰ ਬੁਧ੍ਯਸੇ? ਤਤਃ ਪਿਤਰ ਉਕ੍ਤਵਾਨ੍, ਵਿਦੇਸ਼ਿਭ੍ਯਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ਤਦਾ ਯੀਸ਼ੁਰੁਕ੍ਤਵਾਨ੍, ਤਰ੍ਹਿ ਸਨ੍ਤਾਨਾ ਮੁਕ੍ਤਾਃ ਸਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","ਤਥਾਪਿ ਯਥਾਸ੍ਮਾਭਿਸ੍ਤੇਸ਼਼ਾਮਨ੍ਤਰਾਯੋ ਨ ਜਨ੍ਯਤੇ, ਤਤ੍ਕ੍ਰੁʼਤੇ ਜਲਧੇਸ੍ਤੀਰੰ ਗਤ੍ਵਾ ਵਡਿਸ਼ੰ ਕ੍ਸ਼਼ਿਪ, ਤੇਨਾਦੌ ਯੋ ਮੀਨ ਉੱਥਾਸ੍ਯਤਿ, ਤੰ ਘ੍ਰੁʼਤ੍ਵਾ ਤਨ੍ਮੁਖੇ ਮੋਚਿਤੇ ਤੋਲਕੈਕੰ ਰੂਪ੍ਯੰ ਪ੍ਰਾਪ੍ਸ੍ਯਸਿ, ਤਦ੍ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਤਵ ਮਮ ਚ ਕ੍ਰੁʼਤੇ ਤੇਭ੍ਯੋ ਦੇਹਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","ਤਦਾਨੀਂ ਸ਼ਿਸ਼਼੍ਯਾ ਯੀਸ਼ੋਃ ਸਮੀਪਮਾਗਤ੍ਯ ਪ੍ਰੁʼਸ਼਼੍ਟਵਨ੍ਤਃ ਸ੍ਵਰ੍ਗਰਾਜ੍ਯੇ ਕਃ ਸ਼੍ਰੇਸ਼਼੍ਠਃ? ");
INSERT INTO sanpun_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ਤਤੋ ਯੀਸ਼ੁਃ ਕ੍ਸ਼਼ੁਦ੍ਰਮੇਕੰ ਬਾਲਕੰ ਸ੍ਵਸਮੀਪਮਾਨੀਯ ਤੇਸ਼਼ਾਂ ਮਧ੍ਯੇ ਨਿਧਾਯ ਜਗਾਦ, ");
INSERT INTO sanpun_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ਯੁਸ਼਼੍ਮਾਨਹੰ ਸਤ੍ਯੰ ਬ੍ਰਵੀਮਿ, ਯੂਯੰ ਮਨੋਵਿਨਿਮਯੇਨ ਕ੍ਸ਼਼ੁਦ੍ਰਬਾਲਵਤ੍ ਨ ਸਨ੍ਤਃ ਸ੍ਵਰ੍ਗਰਾਜ੍ਯੰ ਪ੍ਰਵੇਸ਼਼੍ਟੁੰ ਨ ਸ਼ਕ੍ਨੁਥ| ");
INSERT INTO sanpun_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","ਯਃ ਕਸ਼੍ਚਿਦ੍ ਏਤਸ੍ਯ ਕ੍ਸ਼਼ੁਦ੍ਰਬਾਲਕਸ੍ਯ ਸਮਮਾਤ੍ਮਾਨੰ ਨਮ੍ਰੀਕਰੋਤਿ, ਸਏਵ ਸ੍ਵਰ੍ਗਰਾਜਯੇ ਸ਼੍ਰੇਸ਼਼੍ਠਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ਯਃ ਕਸ਼੍ਚਿਦ੍ ਏਤਾਦ੍ਰੁʼਸ਼ੰ ਕ੍ਸ਼਼ੁਦ੍ਰਬਾਲਕਮੇਕੰ ਮਮ ਨਾਮ੍ਨਿ ਗ੍ਰੁʼਹ੍ਲਾਤਿ, ਸ ਮਾਮੇਵ ਗ੍ਰੁʼਹ੍ਲਾਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","ਕਿਨ੍ਤੁ ਯੋ ਜਨੋ ਮਯਿ ਕ੍ਰੁʼਤਵਿਸ਼੍ਵਾਸਾਨਾਮੇਤੇਸ਼਼ਾਂ ਕ੍ਸ਼਼ੁਦ੍ਰਪ੍ਰਾਣਿਨਾਮ੍ ਏਕਸ੍ਯਾਪਿ ਵਿਧ੍ਨਿੰ ਜਨਯਤਿ, ਕਣ੍ਠਬੱਧਪੇਸ਼਼ਣੀਕਸ੍ਯ ਤਸ੍ਯ ਸਾਗਰਾਗਾਧਜਲੇ ਮੱਜਨੰ ਸ਼੍ਰੇਯਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","ਵਿਘ੍ਨਾਤ੍ ਜਗਤਃ ਸਨ੍ਤਾਪੋ ਭਵਿਸ਼਼੍ਯਤਿ, ਵਿਘ੍ਨੋ(ਅ)ਵਸ਼੍ਯੰ ਜਨਯਿਸ਼਼੍ਯਤੇ, ਕਿਨ੍ਤੁ ਯੇਨ ਮਨੁਜੇਨ ਵਿਘ੍ਨੋ ਜਨਿਸ਼਼੍ਯਤੇ ਤਸ੍ਯੈਵ ਸਨ੍ਤਾਪੋ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","ਤਸ੍ਮਾਤ੍ ਤਵ ਕਰਸ਼੍ਚਰਣੋ ਵਾ ਯਦਿ ਤ੍ਵਾਂ ਬਾਧਤੇ, ਤਰ੍ਹਿ ਤੰ ਛਿੱਤ੍ਵਾ ਨਿਕ੍ਸ਼਼ਿਪ, ਦ੍ਵਿਕਰਸ੍ਯ ਦ੍ਵਿਪਦਸ੍ਯ ਵਾ ਤਵਾਨਪ੍ਤਵਹ੍ਨੌ ਨਿਕ੍ਸ਼਼ੇਪਾਤ੍, ਖਞ੍ਜਸ੍ਯ ਵਾ ਛਿੰਨਹਸ੍ਤਸ੍ਯ ਤਵ ਜੀਵਨੇ ਪ੍ਰਵੇਸ਼ੋ ਵਰੰ| ");
INSERT INTO sanpun_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","ਅਪਰੰ ਤਵ ਨੇਤ੍ਰੰ ਯਦਿ ਤ੍ਵਾਂ ਬਾਧਤੇ, ਤਰ੍ਹਿ ਤਦਪ੍ਯੁਤ੍ਪਾਵ੍ਯ ਨਿਕ੍ਸ਼਼ਿਪ, ਦ੍ਵਿਨੇਤ੍ਰਸ੍ਯ ਨਰਕਾਗ੍ਨੌ ਨਿਕ੍ਸ਼਼ੇਪਾਤ੍ ਕਾਣਸ੍ਯ ਤਵ ਜੀਵਨੇ ਪ੍ਰਵੇਸ਼ੋ ਵਰੰ| ");
INSERT INTO sanpun_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","ਤਸ੍ਮਾਦਵਧੱਧੰ, ਏਤੇਸ਼਼ਾਂ ਕ੍ਸ਼਼ੁਦ੍ਰਪ੍ਰਾਣਿਨਾਮ੍ ਏਕਮਪਿ ਮਾ ਤੁੱਛੀਕੁਰੁਤ, ");
INSERT INTO sanpun_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","ਯਤੋ ਯੁਸ਼਼੍ਮਾਨਹੰ ਤਥ੍ਯੰ ਬ੍ਰਵੀਮਿ, ਸ੍ਵਰ੍ਗੇ ਤੇਸ਼਼ਾਂ ਦੂਤਾ ਮਮ ਸ੍ਵਰ੍ਗਸ੍ਥਸ੍ਯ ਪਿਤੁਰਾਸ੍ਯੰ ਨਿਤ੍ਯੰ ਪਸ਼੍ਯਨ੍ਤਿ| ਏਵੰ ਯੇ ਯੇ ਹਾਰਿਤਾਸ੍ਤਾਨ੍ ਰਕ੍ਸ਼਼ਿਤੁੰ ਮਨੁਜਪੁਤ੍ਰ ਆਗੱਛਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","ਯੂਯਮਤ੍ਰ ਕਿੰ ਵਿਵਿੰੱਘ੍ਵੇ? ਕਸ੍ਯਚਿਦ੍ ਯਦਿ ਸ਼ਤੰ ਮੇਸ਼਼ਾਃ ਸਨ੍ਤਿ, ਤੇਸ਼਼ਾਮੇਕੋ ਹਾਰ੍ੱਯਤੇ ਚ, ਤਰ੍ਹਿ ਸ ਏਕੋਨਸ਼ਤੰ ਮੇਸ਼਼ਾਨ੍ ਵਿਹਾਯ ਪਰ੍ੱਵਤੰ ਗਤ੍ਵਾ ਤੰ ਹਾਰਿਤਮੇਕੰ ਕਿੰ ਨ ਮ੍ਰੁʼਗਯਤੇ? ");
INSERT INTO sanpun_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ਯਦਿ ਚ ਕਦਾਚਿਤ੍ ਤਨ੍ਮੇਸ਼਼ੋੱਦੇਸ਼ੰ ਲਮਤੇ, ਤਰ੍ਹਿ ਯੁਸ਼਼੍ਮਾਨਹੰ ਸਤ੍ਯੰ ਕਥਯਾਮਿ, ਸੋ(ਅ)ਵਿਪਥਗਾਮਿਭ੍ਯ ਏਕੋਨਸ਼ਤਮੇਸ਼਼ੇਭ੍ਯੋਪਿ ਤਦੇਕਹੇਤੋਰਧਿਕਮ੍ ਆਹ੍ਲਾਦਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","ਤਦ੍ਵਦ੍ ਏਤੇਸ਼਼ਾਂ ਕ੍ਸ਼਼ੁਦ੍ਰਪ੍ਰਾਏिਨਾਮ੍ ਏਕੋਪਿ ਨਸ਼੍ਯਤੀਤਿ ਯੁਸ਼਼੍ਮਾਕੰ ਸ੍ਵਰ੍ਗਸ੍ਥਪਿਤੁ ਰ੍ਨਾਭਿਮਤਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","ਯਦ੍ਯਪਿ ਤਵ ਭ੍ਰਾਤਾ ਤ੍ਵਯਿ ਕਿਮਪ੍ਯਪਰਾਧ੍ਯਤਿ, ਤਰ੍ਹਿ ਗਤ੍ਵਾ ਯੁਵਯੋਰ੍ਦ੍ਵਯੋਃ ਸ੍ਥਿਤਯੋਸ੍ਤਸ੍ਯਾਪਰਾਧੰ ਤੰ ਜ੍ਞਾਪਯ| ਤਤ੍ਰ ਸ ਯਦਿ ਤਵ ਵਾਕ੍ਯੰ ਸ਼੍ਰੁʼਣੋਤਿ, ਤਰ੍ਹਿ ਤ੍ਵੰ ਸ੍ਵਭ੍ਰਾਤਰੰ ਪ੍ਰਾਪ੍ਤਵਾਨ੍, ");
INSERT INTO sanpun_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","ਕਿਨ੍ਤੁ ਯਦਿ ਨ ਸ਼੍ਰੁʼਣੋਤਿ, ਤਰ੍ਹਿ ਦ੍ਵਾਭ੍ਯਾਂ ਤ੍ਰਿਭਿ ਰ੍ਵਾ ਸਾਕ੍ਸ਼਼ੀਭਿਃ ਸਰ੍ੱਵੰ ਵਾਕ੍ਯੰ ਯਥਾ ਨਿਸ਼੍ਚਿਤੰ ਜਾਯਤੇ, ਤਦਰ੍ਥਮ੍ ਏਕੰ ਦ੍ਵੌ ਵਾ ਸਾਕ੍ਸ਼਼ਿਣੌ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਯਾਹਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","ਤੇਨ ਸ ਯਦਿ ਤਯੋ ਰ੍ਵਾਕ੍ਯੰ ਨ ਮਾਨ੍ਯਤੇ, ਤਰ੍ਹਿ ਸਮਾਜੰ ਤੱਜ੍ਞਾਪਯ, ਕਿਨ੍ਤੁ ਯਦਿ ਸਮਾਜਸ੍ਯਾਪਿ ਵਾਕ੍ਯੰ ਨ ਮਾਨ੍ਯਤੇ,ਤਰ੍ਹਿ ਸ ਤਵ ਸਮੀਪੇ ਦੇਵਪੂਜਕਇਵ ਚਣ੍ਡਾਲਇਵ ਚ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","ਅਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਸਤ੍ਯੰ ਵਦਾਮਿ, ਯੁਸ਼਼੍ਮਾਭਿਃ ਪ੍ਰੁʼਥਿਵ੍ਯਾਂ ਯਦ੍ ਬਧ੍ਯਤੇ ਤਤ੍ ਸ੍ਵਰ੍ਗੇ ਭੰਤ੍ਸ੍ਯਤੇ; ਮੇਦਿਨ੍ਯਾਂ ਯਤ੍ ਭੋਚ੍ਯਤੇ, ਸ੍ਵਰ੍ਗੇ(ਅ)ਪਿ ਤਤ੍ ਮੋਕ੍ਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","ਪੁਨਰਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਵਦਾਮਿ, ਮੇਦਿਨ੍ਯਾਂ ਯੁਸ਼਼੍ਮਾਕੰ ਯਦਿ ਦ੍ਵਾਵੇਕਵਾਕ੍ਯੀਭੂਯ ਕਿਞ੍ਚਿਤ੍ ਪ੍ਰਾਰ੍ਥਯੇਤੇ, ਤਰ੍ਹਿ ਮਮ ਸ੍ਵਰ੍ਗਸ੍ਥਪਿਤ੍ਰਾ ਤਤ੍ ਤਯੋਃ ਕ੍ਰੁʼਤੇ ਸਮ੍ਪੰਨੰ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","ਯਤੋ ਯਤ੍ਰ ਦ੍ਵੌ ਤ੍ਰਯੋ ਵਾ ਮਮ ਨਾੰਨਿ ਮਿਲਨ੍ਤਿ, ਤਤ੍ਰੈਵਾਹੰ ਤੇਸ਼਼ਾਂ ਮਧ੍ਯੇ(ਅ)ਸ੍ਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","ਤਦਾਨੀਂ ਪਿਤਰਸ੍ਤਤ੍ਸਮੀਪਮਾਗਤ੍ਯ ਕਥਿਤਵਾਨ੍ ਹੇ ਪ੍ਰਭੋ, ਮਮ ਭ੍ਰਾਤਾ ਮਮ ਯਦ੍ਯਪਰਾਧ੍ਯਤਿ, ਤਰ੍ਹਿ ਤੰ ਕਤਿਕ੍ਰੁʼਤ੍ਵਃ ਕ੍ਸ਼਼ਮਿਸ਼਼੍ਯੇ? ");
INSERT INTO sanpun_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","ਕਿੰ ਸਪ੍ਤਕ੍ਰੁʼਤ੍ਵਃ? ਯੀਸ਼ੁਸ੍ਤੰ ਜਗਾਦ, ਤ੍ਵਾਂ ਕੇਵਲੰ ਸਪ੍ਤਕ੍ਰੁʼਤ੍ਵੋ ਯਾਵਤ੍ ਨ ਵਦਾਮਿ, ਕਿਨ੍ਤੁ ਸਪ੍ਤਤ੍ਯਾ ਗੁਣਿਤੰ ਸਪ੍ਤਕ੍ਰੁʼਤ੍ਵੋ ਯਾਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","ਅਪਰੰ ਨਿਜਦਾਸੈਃ ਸਹ ਜਿਗਣਯਿਸ਼਼ੁਃ ਕਸ਼੍ਚਿਦ੍ ਰਾਜੇਵ ਸ੍ਵਰ੍ਗਰਾਜਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ਆਰਬ੍ਧੇ ਤਸ੍ਮਿਨ੍ ਗਣਨੇ ਸਾਰ੍ੱਧਸਹਸ੍ਰਮੁਦ੍ਰਾਪੂਰਿਤਾਨਾਂ ਦਸ਼ਸਹਸ੍ਰਪੁਟਕਾਨਾਮ੍ ਏਕੋ(ਅ)ਘਮਰ੍ਣਸ੍ਤਤ੍ਸਮਕ੍ਸ਼਼ਮਾਨਾਯਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ਤਸ੍ਯ ਪਰਿਸ਼ੋਧਨਾਯ ਦ੍ਰਵ੍ਯਾਭਾਵਾਤ੍ ਪਰਿਸ਼ੋਧਨਾਰ੍ਥੰ ਸ ਤਦੀਯਭਾਰ੍ੱਯਾਪੁਤ੍ਰਾਦਿਸਰ੍ੱਵਸ੍ਵਞ੍ਚ ਵਿਕ੍ਰੀਯਤਾਮਿਤਿ ਤਤ੍ਪ੍ਰਭੁਰਾਦਿਦੇਸ਼| ");
INSERT INTO sanpun_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","ਤੇਨ ਸ ਦਾਸਸ੍ਤਸ੍ਯ ਪਾਦਯੋਃ ਪਤਨ੍ ਪ੍ਰਣਮ੍ਯ ਕਥਿਤਵਾਨ੍ , ਹੇ ਪ੍ਰਭੋ ਭਵਤਾ ਘੈਰ੍ੱਯੇ ਕ੍ਰੁʼਤੇ ਮਯਾ ਸਰ੍ੱਵੰ ਪਰਿਸ਼ੋਧਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","ਤਦਾਨੀਂ ਦਾਸਸ੍ਯ ਪ੍ਰਭੁਃ ਸਕਰੁਣਃ ਸਨ੍ ਸਕਲਰ੍ਣੰ ਕ੍ਸ਼਼ਮਿਤ੍ਵਾ ਤੰ ਤਤ੍ਯਾਜ| ");
INSERT INTO sanpun_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","ਕਿਨ੍ਤੁ ਤਸ੍ਮਿਨ੍ ਦਾਸੇ ਬਹਿ ਰ੍ਯਾਤੇ, ਤਸ੍ਯ ਸ਼ਤੰ ਮੁਦ੍ਰਾਚਤੁਰ੍ਥਾਂਸ਼ਾਨ੍ ਯੋ ਧਾਰਯਤਿ, ਤੰ ਸਹਦਾਸੰ ਦ੍ਰੁʼਸ਼਼੍ਦ੍ਵਾ ਤਸ੍ਯ ਕਣ੍ਠੰ ਨਿਸ਼਼੍ਪੀਡ੍ਯ ਗਦਿਤਵਾਨ੍, ਮਮ ਯਤ੍ ਪ੍ਰਾਪ੍ਯੰ ਤਤ੍ ਪਰਿਸ਼ੋਧਯ| ");
INSERT INTO sanpun_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","ਤਦਾ ਤਸ੍ਯ ਸਹਦਾਸਸ੍ਤਤ੍ਪਾਦਯੋਃ ਪਤਿਤ੍ਵਾ ਵਿਨੀਯ ਬਭਾਸ਼਼ੇ, ਤ੍ਵਯਾ ਧੈਰ੍ੱਯੇ ਕ੍ਰੁʼਤੇ ਮਯਾ ਸਰ੍ੱਵੰ ਪਰਿਸ਼ੋਧਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","ਤਥਾਪਿ ਸ ਤਤ੍ ਨਾਙਗੀਕ੍ਰੁʼਤ੍ਯ ਯਾਵਤ੍ ਸਰ੍ੱਵਮ੍ਰੁʼਣੰ ਨ ਪਰਿਸ਼ੋਧਿਤਵਾਨ੍ ਤਾਵਤ੍ ਤੰ ਕਾਰਾਯਾਂ ਸ੍ਥਾਪਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ਤਦਾ ਤਸ੍ਯ ਸਹਦਾਸਾਸ੍ਤਸ੍ਯੈਤਾਦ੍ਰੁʼਗ੍ ਆਚਰਣੰ ਵਿਲੋਕ੍ਯ ਪ੍ਰਭੋਃ ਸਮੀਪੰ ਗਤ੍ਵਾ ਸਰ੍ੱਵੰ ਵ੍ਰੁʼੱਤਾਨ੍ਤੰ ਨਿਵੇਦਯਾਮਾਸੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","ਤਦਾ ਤਸ੍ਯ ਪ੍ਰਭੁਸ੍ਤਮਾਹੂਯ ਜਗਾਦ, ਰੇ ਦੁਸ਼਼੍ਟ ਦਾਸ, ਤ੍ਵਯਾ ਮਤ੍ਸੰਨਿਧੌ ਪ੍ਰਾਰ੍ਥਿਤੇ ਮਯਾ ਤਵ ਸਰ੍ੱਵਮ੍ਰੁʼਣੰ ਤ੍ਯਕ੍ਤੰ; ");
INSERT INTO sanpun_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ਯਥਾ ਚਾਹੰ ਤ੍ਵਯਿ ਕਰੁਣਾਂ ਕ੍ਰੁʼਤਵਾਨ੍, ਤਥੈਵ ਤ੍ਵਤ੍ਸਹਦਾਸੇ ਕਰੁਣਾਕਰਣੰ ਕਿੰ ਤਵ ਨੋਚਿਤੰ? ");
INSERT INTO sanpun_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ਇਤਿ ਕਥਯਿਤ੍ਵਾ ਤਸ੍ਯ ਪ੍ਰਭੁਃ ਕ੍ਰੁੱਧ੍ਯਨ੍ ਨਿਜਪ੍ਰਾਪ੍ਯੰ ਯਾਵਤ੍ ਸ ਨ ਪਰਿਸ਼ੋਧਿਤਵਾਨ੍, ਤਾਵਤ੍ ਪ੍ਰਹਾਰਕਾਨਾਂ ਕਰੇਸ਼਼ੁ ਤੰ ਸਮਰ੍ਪਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","ਯਦਿ ਯੂਯੰ ਸ੍ਵਾਨ੍ਤਃਕਰਣੈਃ ਸ੍ਵਸ੍ਵਸਹਜਾਨਾਮ੍ ਅਪਰਾਧਾਨ੍ ਨ ਕ੍ਸ਼਼ਮਧ੍ਵੇ, ਤਰ੍ਹਿ ਮਮ ਸ੍ਵਰ੍ਗਸ੍ਯਃ ਪਿਤਾਪਿ ਯੁਸ਼਼੍ਮਾਨ੍ ਪ੍ਰਤੀੱਥੰ ਕਰਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","ਅਨਨ੍ਤਰਮ੍ ਏਤਾਸੁ ਕਥਾਸੁ ਸਮਾਪ੍ਤਾਸੁ ਯੀਸ਼ੁ ਰ੍ਗਾਲੀਲਪ੍ਰਦੇਸ਼ਾਤ੍ ਪ੍ਰਸ੍ਥਾਯ ਯਰ੍ਦਨ੍ਤੀਰਸ੍ਥੰ ਯਿਹੂਦਾਪ੍ਰਦੇਸ਼ੰ ਪ੍ਰਾਪ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ਤਦਾ ਤਤ੍ਪਸ਼੍ਚਾਤ੍ ਜਨਨਿਵਹੇ ਗਤੇ ਸ ਤਤ੍ਰ ਤਾਨ੍ ਨਿਰਾਮਯਾਨ੍ ਅਕਰੋਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ਤਦਨਨ੍ਤਰੰ ਫਿਰੂਸ਼ਿਨਸ੍ਤਤ੍ਸਮੀਪਮਾਗਤ੍ਯ ਪਾਰੀਕ੍ਸ਼਼ਿਤੁੰ ਤੰ ਪਪ੍ਰੱਛੁਃ, ਕਸ੍ਮਾਦਪਿ ਕਾਰਣਾਤ੍ ਨਰੇਣ ਸ੍ਵਜਾਯਾ ਪਰਿਤ੍ਯਾਜ੍ਯਾ ਨ ਵਾ? ");
INSERT INTO sanpun_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ਸ ਪ੍ਰਤ੍ਯੁਵਾਚ, ਪ੍ਰਥਮਮ੍ ਈਸ਼੍ਵਰੋ ਨਰਤ੍ਵੇਨ ਨਾਰੀਤ੍ਵੇਨ ਚ ਮਨੁਜਾਨ੍ ਸਸਰ੍ਜ, ਤਸ੍ਮਾਤ੍ ਕਥਿਤਵਾਨ੍, ");
INSERT INTO sanpun_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ਮਾਨੁਸ਼਼ਃ ਸ੍ਵਪਿਤਰੌ ਪਰਿਤ੍ਯਜ੍ਯ ਸ੍ਵਪਤ੍ਨ੍ਯਾਮ੍ ਆਸਕ੍ਸ਼਼੍ਯਤੇ, ਤੌ ਦ੍ਵੌ ਜਨਾਵੇਕਾਙ੍ਗੌ ਭਵਿਸ਼਼੍ਯਤਃ, ਕਿਮੇਤਦ੍ ਯੁਸ਼਼੍ਮਾਭਿ ਰ੍ਨ ਪਠਿਤਮ੍? ");
INSERT INTO sanpun_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","ਅਤਸ੍ਤੌ ਪੁਨ ਰ੍ਨ ਦ੍ਵੌ ਤਯੋਰੇਕਾਙ੍ਗਤ੍ਵੰ ਜਾਤੰ, ਈਸ਼੍ਵਰੇਣ ਯੱਚ ਸਮਯੁਜ੍ਯਤ, ਮਨੁਜੋ ਨ ਤਦ੍ ਭਿਨ੍ਦ੍ਯਾਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ਤਦਾਨੀਂ ਤੇ ਤੰ ਪ੍ਰਤ੍ਯਵਦਨ੍, ਤਥਾਤ੍ਵੇ ਤ੍ਯਾਜ੍ਯਪਤ੍ਰੰ ਦੱਤ੍ਵਾ ਸ੍ਵਾਂ ਸ੍ਵਾਂ ਜਾਯਾਂ ਤ੍ਯਕ੍ਤੁੰ ਵ੍ਯਵਸ੍ਥਾਂ ਮੂਸਾਃ ਕਥੰ ਲਿਲੇਖ? ");
INSERT INTO sanpun_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ਤਤਃ ਸ ਕਥਿਤਵਾਨ੍, ਯੁਸ਼਼੍ਮਾਕੰ ਮਨਸਾਂ ਕਾਠਿਨ੍ਯਾਦ੍ ਯੁਸ਼਼੍ਮਾਨ੍ ਸ੍ਵਾਂ ਸ੍ਵਾਂ ਜਾਯਾਂ ਤ੍ਯਕ੍ਤੁਮ੍ ਅਨ੍ਵਮਨ੍ਯਤ ਕਿਨ੍ਤੁ ਪ੍ਰਥਮਾਦ੍ ਏਸ਼਼ੋ ਵਿਧਿਰ੍ਨਾਸੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","ਅਤੋ ਯੁਸ਼਼੍ਮਾਨਹੰ ਵਦਾਮਿ, ਵ੍ਯਭਿਚਾਰੰ ਵਿਨਾ ਯੋ ਨਿਜਜਾਯਾਂ ਤ੍ਯਜੇਤ੍ ਅਨ੍ਯਾਞ੍ਚ ਵਿਵਹੇਤ੍, ਸ ਪਰਦਾਰਾਨ੍ ਗੱਛਤਿ; ਯਸ਼੍ਚ ਤ੍ਯਕ੍ਤਾਂ ਨਾਰੀਂ ਵਿਵਹਤਿ ਸੋਪਿ ਪਰਦਾਰੇਸ਼਼ੁ ਰਮਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ਤਦਾ ਤਸ੍ਯ ਸ਼ਿਸ਼਼੍ਯਾਸ੍ਤੰ ਬਭਾਸ਼਼ਿਰੇ, ਯਦਿ ਸ੍ਵਜਾਯਯਾ ਸਾਕੰ ਪੁੰਸ ਏਤਾਦ੍ਰੁʼਕ੍ ਸਮ੍ਬਨ੍ਧੋ ਜਾਯਤੇ, ਤਰ੍ਹਿ ਵਿਵਹਨਮੇਵ ਨ ਭਦ੍ਰੰ| ");
INSERT INTO sanpun_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ਤਤਃ ਸ ਉਕ੍ਤਵਾਨ੍, ਯੇਭ੍ਯਸ੍ਤਤ੍ਸਾਮਰ੍ਥ੍ਯੰ ਆਦਾਯਿ, ਤਾਨ੍ ਵਿਨਾਨ੍ਯਃ ਕੋਪਿ ਮਨੁਜ ਏਤਨ੍ਮਤੰ ਗ੍ਰਹੀਤੁੰ ਨ ਸ਼ਕ੍ਨੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","ਕਤਿਪਯਾ ਜਨਨਕ੍ਲੀਬਃ ਕਤਿਪਯਾ ਨਰਕ੍ਰੁʼਤਕ੍ਲੀਬਃ ਸ੍ਵਰ੍ਗਰਾਜ੍ਯਾਯ ਕਤਿਪਯਾਃ ਸ੍ਵਕ੍ਰੁʼਤਕ੍ਲੀਬਾਸ਼੍ਚ ਸਨ੍ਤਿ, ਯੇ ਗ੍ਰਹੀਤੁੰ ਸ਼ਕ੍ਨੁਵਨ੍ਤਿ ਤੇ ਗ੍ਰੁʼਹ੍ਲਨ੍ਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","ਅਪਰਮ੍ ਯਥਾ ਸ ਸ਼ਿਸ਼ੂਨਾਂ ਗਾਤ੍ਰੇਸ਼਼ੁ ਹਸ੍ਤੰ ਦਤ੍ਵਾ ਪ੍ਰਾਰ੍ਥਯਤੇ, ਤਦਰ੍ਥੰ ਤਤ੍ਸਮੀਂਪੰ ਸ਼ਿਸ਼ਵ ਆਨੀਯਨ੍ਤ, ਤਤ ਆਨਯਿਤ੍ਰੁʼਨ੍ ਸ਼ਿਸ਼਼੍ਯਾਸ੍ਤਿਰਸ੍ਕ੍ਰੁʼਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ਕਿਨ੍ਤੁ ਯੀਸ਼ੁਰੁਵਾਚ, ਸ਼ਿਸ਼ਵੋ ਮਦਨ੍ਤਿਕਮ੍ ਆਗੱਛਨ੍ਤੁ, ਤਾਨ੍ ਮਾ ਵਾਰਯਤ, ਏਤਾਦ੍ਰੁʼਸ਼ਾਂ ਸ਼ਿਸ਼ੂਨਾਮੇਵ ਸ੍ਵਰ੍ਗਰਾਜ੍ਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ਤਤਃ ਸ ਤੇਸ਼਼ਾਂ ਗਾਤ੍ਰੇਸ਼਼ੁ ਹਸ੍ਤੰ ਦਤ੍ਵਾ ਤਸ੍ਮਾਤ੍ ਸ੍ਥਾਨਾਤ੍ ਪ੍ਰਤਸ੍ਥੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","ਅਪਰਮ੍ ਏਕ ਆਗਤ੍ਯ ਤੰ ਪਪ੍ਰੱਛ, ਹੇ ਪਰਮਗੁਰੋ, ਅਨਨ੍ਤਾਯੁਃ ਪ੍ਰਾਪ੍ਤੁੰ ਮਯਾ ਕਿੰ ਕਿੰ ਸਤ੍ਕਰ੍ੰਮ ਕਰ੍ੱਤਵ੍ਯੰ? ");
INSERT INTO sanpun_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ਤਤਃ ਸ ਉਵਾਚ, ਮਾਂ ਪਰਮੰ ਕੁਤੋ ਵਦਸਿ? ਵਿਨੇਸ਼੍ਚਰੰ ਨ ਕੋਪਿ ਪਰਮਃ, ਕਿਨ੍ਤੁ ਯਦ੍ਯਨਨ੍ਤਾਯੁਃ ਪ੍ਰਾਪ੍ਤੁੰ ਵਾਞ੍ਛਸਿ, ਤਰ੍ਹ੍ਯਾਜ੍ਞਾਃ ਪਾਲਯ| ");
INSERT INTO sanpun_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","ਤਦਾ ਸ ਪ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍, ਕਾਃ ਕਾ ਆਜ੍ਞਾਃ? ਤਤੋ ਯੀਸ਼ੁਃ ਕਥਿਤਵਾਨ੍, ਨਰੰ ਮਾ ਹਨ੍ਯਾਃ, ਪਰਦਾਰਾਨ੍ ਮਾ ਗੱਛੇਃ, ਮਾ ਚੋਰਯੇਃ, ਮ੍ਰੁʼਸ਼਼ਾਸਾਕ੍ਸ਼਼੍ਯੰ ਮਾ ਦਦ੍ਯਾਃ, ");
INSERT INTO sanpun_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ਨਿਜਪਿਤਰੌ ਸੰਮਨ੍ਯਸ੍ਵ, ਸ੍ਵਸਮੀਪਵਾਸਿਨਿ ਸ੍ਵਵਤ੍ ਪ੍ਰੇਮ ਕੁਰੁ| ");
INSERT INTO sanpun_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ਸ ਯੁਵਾ ਕਥਿਤਵਾਨ੍, ਆ ਬਾਲ੍ਯਾਦ੍ ਏਤਾਃ ਪਾਲਯਾਮਿ, ਇਦਾਨੀਂ ਕਿੰ ਨ੍ਯੂਨਮਾਸ੍ਤੇ? ");
INSERT INTO sanpun_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ਤਤੋ ਯੀਸ਼ੁਰਵਦਤ੍, ਯਦਿ ਸਿੱਧੋ ਭਵਿਤੁੰ ਵਾਞ੍ਛਸਿ, ਤਰ੍ਹਿ ਗਤ੍ਵਾ ਨਿਜਸਰ੍ੱਵਸ੍ਵੰ ਵਿਕ੍ਰੀਯ ਦਰਿਦ੍ਰੇਭ੍ਯੋ ਵਿਤਰ, ਤਤਃ ਸ੍ਵਰ੍ਗੇ ਵਿੱਤੰ ਲਪ੍ਸ੍ਯਸੇ; ਆਗੱਛ, ਮਤ੍ਪਸ਼੍ਚਾਦ੍ਵਰ੍ੱਤੀ ਚ ਭਵ| ");
INSERT INTO sanpun_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ਏਤਾਂ ਵਾਚੰ ਸ਼੍ਰੁਤ੍ਵਾ ਸ ਯੁਵਾ ਸ੍ਵੀਯਬਹੁਸਮ੍ਪੱਤੇ ਰ੍ਵਿਸ਼਼ਣਃ ਸਨ੍ ਚਲਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ਤਦਾ ਯੀਸ਼ੁਃ ਸ੍ਵਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਅਵਦਤ੍, ਧਨਿਨਾਂ ਸ੍ਵਰ੍ਗਰਾਜ੍ਯਪ੍ਰਵੇਸ਼ੋ ਮਹਾਦੁਸ਼਼੍ਕਰ ਇਤਿ ਯੁਸ਼਼੍ਮਾਨਹੰ ਤਥ੍ਯੰ ਵਦਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","ਪੁਨਰਪਿ ਯੁਸ਼਼੍ਮਾਨਹੰ ਵਦਾਮਿ, ਧਨਿਨਾਂ ਸ੍ਵਰ੍ਗਰਾਜ੍ਯਪ੍ਰਵੇਸ਼ਾਤ੍ ਸੂਚੀਛਿਦ੍ਰੇਣ ਮਹਾਙ੍ਗਗਮਨੰ ਸੁਕਰੰ| ");
INSERT INTO sanpun_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ਇਤਿ ਵਾਕ੍ਯੰ ਨਿਸ਼ਮ੍ਯ ਸ਼ਿਸ਼਼੍ਯਾ ਅਤਿਚਮਤ੍ਕ੍ਰੁʼਤ੍ਯ ਕਥਯਾਮਾਸੁਃ; ਤਰ੍ਹਿ ਕਸ੍ਯ ਪਰਿਤ੍ਰਾਣੰ ਭਵਿਤੁੰ ਸ਼ਕ੍ਨੋਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ਤਦਾ ਸ ਤਾਨ੍ ਦ੍ਰੁʼਸ਼਼੍ਦ੍ਵਾ ਕਥਯਾਮਾਸ, ਤਤ੍ ਮਾਨੁਸ਼਼ਾਣਾਮਸ਼ਕ੍ਯੰ ਭਵਤਿ, ਕਿਨ੍ਤ੍ਵੀਸ਼੍ਵਰਸ੍ਯ ਸਰ੍ੱਵੰ ਸ਼ਕ੍ਯਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","ਤਦਾ ਪਿਤਰਸ੍ਤੰ ਗਦਿਤਵਾਨ੍, ਪਸ਼੍ਯ, ਵਯੰ ਸਰ੍ੱਵੰ ਪਰਿਤ੍ਯਜ੍ਯ ਭਵਤਃ ਪਸ਼੍ਚਾਦ੍ਵਰ੍ੱਤਿਨੋ (ਅ)ਭਵਾਮ; ਵਯੰ ਕਿੰ ਪ੍ਰਾਪ੍ਸ੍ਯਾਮਃ? ");
INSERT INTO sanpun_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ਤਤੋ ਯੀਸ਼ੁਃ ਕਥਿਤਵਾਨ੍, ਯੁਸ਼਼੍ਮਾਨਹੰ ਤਥ੍ਯੰ ਵਦਾਮਿ, ਯੂਯੰ ਮਮ ਪਸ਼੍ਚਾਦ੍ਵਰ੍ੱਤਿਨੋ ਜਾਤਾ ਇਤਿ ਕਾਰਣਾਤ੍ ਨਵੀਨਸ੍ਰੁʼਸ਼਼੍ਟਿਕਾਲੇ ਯਦਾ ਮਨੁਜਸੁਤਃ ਸ੍ਵੀਯੈਸ਼੍ਚਰ੍ੱਯਸਿੰਹਾਸਨ ਉਪਵੇਕ੍ਸ਼਼੍ਯਤਿ, ਤਦਾ ਯੂਯਮਪਿ ਦ੍ਵਾਦਸ਼ਸਿੰਹਾਸਨੇਸ਼਼ੂਪਵਿਸ਼੍ਯ ਇਸ੍ਰਾਯੇਲੀਯਦ੍ਵਾਦਸ਼ਵੰਸ਼ਾਨਾਂ ਵਿਚਾਰੰ ਕਰਿਸ਼਼੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","ਅਨ੍ਯੱਚ ਯਃ ਕਸ਼੍ਚਿਤ੍ ਮਮ ਨਾਮਕਾਰਣਾਤ੍ ਗ੍ਰੁʼਹੰ ਵਾ ਭ੍ਰਾਤਰੰ ਵਾ ਭਗਿਨੀਂ ਵਾ ਪਿਤਰੰ ਵਾ ਮਾਤਰੰ ਵਾ ਜਾਯਾਂ ਵਾ ਬਾਲਕੰ ਵਾ ਭੂਮਿੰ ਪਰਿਤ੍ਯਜਤਿ, ਸ ਤੇਸ਼਼ਾਂ ਸ਼ਤਗੁਣੰ ਲਪ੍ਸ੍ਯਤੇ, ਅਨਨ੍ਤਾਯੁਮੋ(ਅ)ਧਿਕਾਰਿਤ੍ਵਞ੍ਚ ਪ੍ਰਾਪ੍ਸ੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","ਕਿਨ੍ਤੁ ਅਗ੍ਰੀਯਾ ਅਨੇਕੇ ਜਨਾਃ ਪਸ਼੍ਚਾਤ੍, ਪਸ਼੍ਚਾਤੀਯਾਸ਼੍ਚਾਨੇਕੇ ਲੋਕਾ ਅਗ੍ਰੇ ਭਵਿਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","ਸ੍ਵਰ੍ਗਰਾਜ੍ਯਮ੍ ਏਤਾਦ੍ਰੁʼਸ਼ਾ ਕੇਨਚਿਦ੍ ਗ੍ਰੁʼਹਸ੍ਯੇਨ ਸਮੰ, ਯੋ(ਅ)ਤਿਪ੍ਰਭਾਤੇ ਨਿਜਦ੍ਰਾਕ੍ਸ਼਼ਾਕ੍ਸ਼਼ੇਤ੍ਰੇ ਕ੍ਰੁʼਸ਼਼ਕਾਨ੍ ਨਿਯੋਕ੍ਤੁੰ ਗਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ਪਸ਼੍ਚਾਤ੍ ਤੈਃ ਸਾਕੰ ਦਿਨੈਕਭ੍ਰੁʼਤਿੰ ਮੁਦ੍ਰਾਚਤੁਰ੍ਥਾਂਸ਼ੰ ਨਿਰੂਪ੍ਯ ਤਾਨ੍ ਦ੍ਰਾਕ੍ਸ਼਼ਾਕ੍ਸ਼਼ੇਤ੍ਰੰ ਪ੍ਰੇਰਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","ਅਨਨ੍ਤਰੰ ਪ੍ਰਹਰੈਕਵੇਲਾਯਾਂ ਗਤ੍ਵਾ ਹੱਟੇ ਕਤਿਪਯਾਨ੍ ਨਿਸ਼਼੍ਕਰ੍ੰਮਕਾਨ੍ ਵਿਲੋਕ੍ਯ ਤਾਨਵਦਤ੍, ");
INSERT INTO sanpun_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ਯੂਯਮਪਿ ਮਮ ਦ੍ਰਾਕ੍ਸ਼਼ਾਕ੍ਸ਼਼ੇਤ੍ਰੰ ਯਾਤ, ਯੁਸ਼਼੍ਮਭ੍ਯਮਹੰ ਯੋਗ੍ਯਭ੍ਰੁʼਤਿੰ ਦਾਸ੍ਯਾਮਿ, ਤਤਸ੍ਤੇ ਵਵ੍ਰਜੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","ਪੁਨਸ਼੍ਚ ਸ ਦ੍ਵਿਤੀਯਤ੍ਰੁʼਤੀਯਯੋਃ ਪ੍ਰਹਰਯੋ ਰ੍ਬਹਿ ਰ੍ਗਤ੍ਵਾ ਤਥੈਵ ਕ੍ਰੁʼਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","ਤਤੋ ਦਣ੍ਡਦ੍ਵਯਾਵਸ਼ਿਸ਼਼੍ਟਾਯਾਂ ਵੇਲਾਯਾਂ ਬਹਿ ਰ੍ਗਤ੍ਵਾਪਰਾਨ੍ ਕਤਿਪਯਜਨਾਨ੍ ਨਿਸ਼਼੍ਕਰ੍ੰਮਕਾਨ੍ ਵਿਲੋਕ੍ਯ ਪ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍, ਯੂਯੰ ਕਿਮਰ੍ਥਮ੍ ਅਤ੍ਰ ਸਰ੍ੱਵੰ ਦਿਨੰ ਨਿਸ਼਼੍ਕਰ੍ੰਮਾਣਸ੍ਤਿਸ਼਼੍ਠਥ? ");
INSERT INTO sanpun_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","ਤੇ ਪ੍ਰਤ੍ਯਵਦਨ੍, ਅਸ੍ਮਾਨ੍ ਨ ਕੋਪਿ ਕਰ੍ਮਮਣਿ ਨਿਯੁੰਕ੍ਤੇ| ਤਦਾਨੀਂ ਸ ਕਥਿਤਵਾਨ੍, ਯੂਯਮਪਿ ਮਮ ਦ੍ਰਾਕ੍ਸ਼਼ਾਕ੍ਸ਼਼ੇਤ੍ਰੰ ਯਾਤ, ਤੇਨ ਯੋਗ੍ਯਾਂ ਭ੍ਰੁʼਤਿੰ ਲਪ੍ਸ੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","ਤਦਨਨ੍ਤਰੰ ਸਨ੍ਧ੍ਯਾਯਾਂ ਸਤ੍ਯਾਂ ਸਏਵ ਦ੍ਰਾਕ੍ਸ਼਼ਾਕ੍ਸ਼਼ੇਤ੍ਰਪਤਿਰਧ੍ਯਕ੍ਸ਼਼ੰ ਗਦਿਵਾਨ੍, ਕ੍ਰੁʼਸ਼਼ਕਾਨ੍ ਆਹੂਯ ਸ਼ੇਸ਼਼ਜਨਮਾਰਭ੍ਯ ਪ੍ਰਥਮੰ ਯਾਵਤ੍ ਤੇਭ੍ਯੋ ਭ੍ਰੁʼਤਿੰ ਦੇਹਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","ਤੇਨ ਯੇ ਦਣ੍ਡਦ੍ਵਯਾਵਸ੍ਥਿਤੇ ਸਮਾਯਾਤਾਸ੍ਤੇਸ਼਼ਾਮ੍ ਏਕੈਕੋ ਜਨੋ ਮੁਦ੍ਰਾਚਤੁਰ੍ਥਾਂਸ਼ੰ ਪ੍ਰਾਪ੍ਨੋਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ਤਦਾਨੀਂ ਪ੍ਰਥਮਨਿਯੁਕ੍ਤਾ ਜਨਾ ਆਗਤ੍ਯਾਨੁਮਿਤਵਨ੍ਤੋ ਵਯਮਧਿਕੰ ਪ੍ਰਪ੍ਸ੍ਯਾਮਃ, ਕਿਨ੍ਤੁ ਤੈਰਪਿ ਮੁਦ੍ਰਾਚਤੁਰ੍ਥਾਂਸ਼ੋ(ਅ)ਲਾਭਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ਤਤਸ੍ਤੇ ਤੰ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਤੇਨ ਕ੍ਸ਼਼ੇਤ੍ਰਪਤਿਨਾ ਸਾਕੰ ਵਾਗ੍ਯੁੱਧੰ ਕੁਰ੍ੱਵਨ੍ਤਃ ਕਥਯਾਮਾਸੁਃ, ");
INSERT INTO sanpun_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ਵਯੰ ਕ੍ਰੁʼਤ੍ਸ੍ਨੰ ਦਿਨੰ ਤਾਪਕ੍ਲੇਸ਼ੌ ਸੋਢਵਨ੍ਤਃ, ਕਿਨ੍ਤੁ ਪਸ਼੍ਚਾਤਾਯਾ ਸੇ ਜਨਾ ਦਣ੍ਡਦ੍ਵਯਮਾਤ੍ਰੰ ਪਰਿਸ਼੍ਰਾਨ੍ਤਵਨ੍ਤਸ੍ਤੇ(ਅ)ਸ੍ਮਾਭਿਃ ਸਮਾਨਾਂਸ਼ਾਃ ਕ੍ਰੁʼਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","ਤਤਃ ਸ ਤੇਸ਼਼ਾਮੇਕੰ ਪ੍ਰਤ੍ਯੁਵਾਚ, ਹੇ ਵਤ੍ਸ, ਮਯਾ ਤ੍ਵਾਂ ਪ੍ਰਤਿ ਕੋਪ੍ਯਨ੍ਯਾਯੋ ਨ ਕ੍ਰੁʼਤਃ ਕਿੰ ਤ੍ਵਯਾ ਮਤ੍ਸਮਕ੍ਸ਼਼ੰ ਮੁਦ੍ਰਾਚਤੁਰ੍ਥਾਂਸ਼ੋ ਨਾਙ੍ਗੀਕ੍ਰੁʼਤਃ? ");
INSERT INTO sanpun_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ਤਸ੍ਮਾਤ੍ ਤਵ ਯਤ੍ ਪ੍ਰਾਪ੍ਯੰ ਤਦਾਦਾਯ ਯਾਹਿ, ਤੁਭ੍ਯੰ ਯਤਿ, ਪਸ਼੍ਚਾਤੀਯਨਿਯੁਕ੍ਤਲੋਕਾਯਾਪਿ ਤਤਿ ਦਾਤੁਮਿੱਛਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ਸ੍ਵੇੱਛਯਾ ਨਿਜਦ੍ਰਵ੍ਯਵ੍ਯਵਹਰਣੰ ਕਿੰ ਮਯਾ ਨ ਕਰ੍ੱਤਵ੍ਯੰ? ਮਮ ਦਾਤ੍ਰੁʼਤ੍ਵਾਤ੍ ਤ੍ਵਯਾ ਕਿਮ੍ ਈਰ੍ਸ਼਼੍ਯਾਦ੍ਰੁʼਸ਼਼੍ਟਿਃ ਕ੍ਰਿਯਤੇ? ");
INSERT INTO sanpun_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","ਇੱਥਮ੍ ਅਗ੍ਰੀਯਲੋਕਾਃ ਪਸ਼੍ਚਤੀਯਾ ਭਵਿਸ਼਼੍ਯਨ੍ਤਿ, ਪਸ਼੍ਚਾਤੀਯਜਨਾਸ਼੍ਚਗ੍ਰੀਯਾ ਭਵਿਸ਼਼੍ਯਨ੍ਤਿ, ਅਹੂਤਾ ਬਹਵਃ ਕਿਨ੍ਤ੍ਵਲ੍ਪੇ ਮਨੋਭਿਲਸ਼਼ਿਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ਤਦਨਨ੍ਤਰੰ ਯੀਸ਼ੁ ਰ੍ਯਿਰੂਸ਼ਾਲਮ੍ਨਗਰੰ ਗੱਛਨ੍ ਮਾਰ੍ਗਮਧ੍ਯੇ ਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਏਕਾਨ੍ਤੇ ਵਭਾਸ਼਼ੇ, ");
INSERT INTO sanpun_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","ਪਸ਼੍ਯ ਵਯੰ ਯਿਰੂਸ਼ਾਲਮ੍ਨਗਰੰ ਯਾਮਃ, ਤਤ੍ਰ ਪ੍ਰਧਾਨਯਾਜਕਾਧ੍ਯਾਪਕਾਨਾਂ ਕਰੇਸ਼਼ੁ ਮਨੁਸ਼਼੍ਯਪੁਤ੍ਰਃ ਸਮਰ੍ਪਿਸ਼਼੍ਯਤੇ; ");
INSERT INTO sanpun_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ਤੇ ਚ ਤੰ ਹਨ੍ਤੁਮਾਜ੍ਞਾਪ੍ਯ ਤਿਰਸ੍ਕ੍ਰੁʼਤ੍ਯ ਵੇਤ੍ਰੇਣ ਪ੍ਰਹਰ੍ੱਤੁੰ ਕ੍ਰੁਸ਼ੇ ਧਾਤਯਿਤੁਞ੍ਚਾਨ੍ਯਦੇਸ਼ੀਯਾਨਾਂ ਕਰੇਸ਼਼ੁ ਸਮਰ੍ਪਯਿਸ਼਼੍ਯਨ੍ਤਿ, ਕਿਨ੍ਤੁ ਸ ਤ੍ਰੁʼਤੀਯਦਿਵਸੇ ਸ਼੍ਮਸ਼ਾਨਾਦ੍ ਉੱਥਾਪਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","ਤਦਾਨੀਂ ਸਿਵਦੀਯਸ੍ਯ ਨਾਰੀ ਸ੍ਵਪੁਤ੍ਰਾਵਾਦਾਯ ਯੀਸ਼ੋਃ ਸਮੀਪਮ੍ ਏਤ੍ਯ ਪ੍ਰਣਮ੍ਯ ਕਞ੍ਚਨਾਨੁਗ੍ਰਹੰ ਤੰ ਯਯਾਚੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ਤਦਾ ਯੀਸ਼ੁਸ੍ਤਾਂ ਪ੍ਰੋਕ੍ਤਵਾਨ੍, ਤ੍ਵੰ ਕਿੰ ਯਾਚਸੇ? ਤਤਃ ਸਾ ਬਭਾਸ਼਼ੇ, ਭਵਤੋ ਰਾਜਤ੍ਵੇ ਮਮਾਨਯੋਃ ਸੁਤਯੋਰੇਕੰ ਭਵੱਦਕ੍ਸ਼਼ਿਣਪਾਰ੍ਸ਼੍ਵੇ ਦ੍ਵਿਤੀਯੰ ਵਾਮਪਾਰ੍ਸ਼੍ਵ ਉਪਵੇਸ਼਼੍ਟੁਮ੍ ਆਜ੍ਞਾਪਯਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯੁਵਾਚ, ਯੁਵਾਭ੍ਯਾਂ ਯਦ੍ ਯਾਚ੍ਯਤੇ, ਤੰਨ ਬੁਧ੍ਯਤੇ, ਅਹੰ ਯੇਨ ਕੰਸੇਨ ਪਾਸ੍ਯਾਮਿ ਯੁਵਾਭ੍ਯਾਂ ਕਿੰ ਤੇਨ ਪਾਤੁੰ ਸ਼ਕ੍ਯਤੇ? ਅਹਞ੍ਚ ਯੇਨ ਮੱਜੇਨੇਨ ਮੱਜਿਸ਼਼੍ਯੇ, ਯੁਵਾਭ੍ਯਾਂ ਕਿੰ ਤੇਨ ਮੱਜਯਿਤੁੰ ਸ਼ਕ੍ਯਤੇ? ਤੇ ਜਗਦੁਃ ਸ਼ਕ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ਤਦਾ ਸ ਉਕ੍ਤਵਾਨ੍, ਯੁਵਾਂ ਮਮ ਕੰਸੇਨਾਵਸ਼੍ਯੰ ਪਾਸ੍ਯਥਃ, ਮਮ ਮੱਜਨੇਨ ਚ ਯੁਵਾਮਪਿ ਮੱਜਿਸ਼਼੍ਯੇਥੇ, ਕਿਨ੍ਤੁ ਯੇਸ਼਼ਾਂ ਕ੍ਰੁʼਤੇ ਮੱਤਾਤੇਨ ਨਿਰੂਪਿਤਮ੍ ਇਦੰ ਤਾਨ੍ ਵਿਹਾਯਾਨ੍ਯੰ ਕਮਪਿ ਮੱਦਕ੍ਸ਼਼ਿਣਪਾਰ੍ਸ਼੍ਵੇ ਵਾਮਪਾਰ੍ਸ਼੍ਵੇ ਚ ਸਮੁਪਵੇਸ਼ਯਿਤੁੰ ਮਮਾਧਿਕਾਰੋ ਨਾਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ਏਤਾਂ ਕਥਾਂ ਸ਼੍ਰੁਤ੍ਵਾਨ੍ਯੇ ਦਸ਼ਸ਼ਿਸ਼਼੍ਯਾਸ੍ਤੌ ਭ੍ਰਾਤਰੌ ਪ੍ਰਤਿ ਚੁਕੁਪੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ਕਿਨ੍ਤੁ ਯੀਸ਼ੁਃ ਸ੍ਵਸਮੀਪੰ ਤਾਨਾਹੂਯ ਜਗਾਦ, ਅਨ੍ਯਦੇਸ਼ੀਯਲੋਕਾਨਾਂ ਨਰਪਤਯਸ੍ਤਾਨ੍ ਅਧਿਕੁਰ੍ੱਵਨ੍ਤਿ, ਯੇ ਤੁ ਮਹਾਨ੍ਤਸ੍ਤੇ ਤਾਨ੍ ਸ਼ਾਸਤਿ, ਇਤਿ ਯੂਯੰ ਜਾਨੀਥ| ");
INSERT INTO sanpun_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","ਕਿਨ੍ਤੁ ਯੁਸ਼਼੍ਮਾਕੰ ਮਧ੍ਯੇ ਨ ਤਥਾ ਭਵੇਤ੍, ਯੁਸ਼਼੍ਮਾਕੰ ਯਃ ਕਸ਼੍ਚਿਤ੍ ਮਹਾਨ੍ ਬੁਭੂਸ਼਼ਤਿ, ਸ ਯੁਸ਼਼੍ਮਾਨ੍ ਸੇਵੇਤ; ");
INSERT INTO sanpun_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ਯਸ਼੍ਚ ਯੁਸ਼਼੍ਮਾਕੰ ਮਧ੍ਯੇ ਮੁਖ੍ਯੋ ਬੁਭੂਸ਼਼ਤਿ, ਸ ਯੁਸ਼਼੍ਮਾਕੰ ਦਾਸੋ ਭਵੇਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ਇੱਥੰ ਮਨੁਜਪੁਤ੍ਰਃ ਸੇਵ੍ਯੋ ਭਵਿਤੁੰ ਨਹਿ, ਕਿਨ੍ਤੁ ਸੇਵਿਤੁੰ ਬਹੂਨਾਂ ਪਰਿਤ੍ਰਾਣਮੂਲ੍ਯਾਰ੍ਥੰ ਸ੍ਵਪ੍ਰਾਣਾਨ੍ ਦਾਤੁਞ੍ਚਾਗਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","ਅਨਨ੍ਤਰੰ ਯਿਰੀਹੋਨਗਰਾਤ੍ ਤੇਸ਼਼ਾਂ ਬਹਿਰ੍ਗਮਨਸਮਯੇ ਤਸ੍ਯ ਪਸ਼੍ਚਾਦ੍ ਬਹਵੋ ਲੋਕਾ ਵਵ੍ਰਜੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ਅਪਰੰ ਵਰ੍ਤ੍ਮਪਾਰ੍ਸ਼੍ਵ ਉਪਵਿਸ਼ਨ੍ਤੌ ਦ੍ਵਾਵਨ੍ਧੌ ਤੇਨ ਮਾਰ੍ਗੇਣ ਯੀਸ਼ੋ ਰ੍ਗਮਨੰ ਨਿਸ਼ਮ੍ਯ ਪ੍ਰੋੱਚੈਃ ਕਥਯਾਮਾਸਤੁਃ, ਹੇ ਪ੍ਰਭੋ ਦਾਯੂਦਃ ਸਨ੍ਤਾਨ, ਆਵਯੋ ਰ੍ਦਯਾਂ ਵਿਧੇਹਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ਤਤੋ ਲੋਕਾਃ ਸਰ੍ੱਵੇ ਤੁਸ਼਼੍ਣੀਮ੍ਭਵਤਮਿਤ੍ਯੁਕ੍ਤ੍ਵਾ ਤੌ ਤਰ੍ਜਯਾਮਾਸੁਃ; ਤਥਾਪਿ ਤੌ ਪੁਨਰੁੱਚੈਃ ਕਥਯਾਮਾਸਤੁਃ ਹੇ ਪ੍ਰਭੋ ਦਾਯੂਦਃ ਸਨ੍ਤਾਨ, ਆਵਾਂ ਦਯਸ੍ਵ| ");
INSERT INTO sanpun_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ਤਦਾਨੀਂ ਯੀਸ਼ੁਃ ਸ੍ਥਗਿਤਃ ਸਨ੍ ਤਾਵਾਹੂਯ ਭਾਸ਼਼ਿਤਵਾਨ੍, ਯੁਵਯੋਃ ਕ੍ਰੁʼਤੇ ਮਯਾ ਕਿੰ ਕਰ੍ੱਤਰ੍ਵ੍ਯੰ? ਯੁਵਾਂ ਕਿੰ ਕਾਮਯੇਥੇ? ");
INSERT INTO sanpun_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ਤਦਾ ਤਾਵੁਕ੍ਤਵਨ੍ਤੌ, ਪ੍ਰਭੋ ਨੇਤ੍ਰਾਣਿ ਨੌ ਪ੍ਰਸੰਨਾਨਿ ਭਵੇਯੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ਤਦਾਨੀਂ ਯੀਸ਼ੁਸ੍ਤੌ ਪ੍ਰਤਿ ਪ੍ਰਮੰਨਃ ਸਨ੍ ਤਯੋ ਰ੍ਨੇਤ੍ਰਾਣਿ ਪਸ੍ਪਰ੍ਸ਼, ਤੇਨੈਵ ਤੌ ਸੁਵੀਕ੍ਸ਼਼ਾਞ੍ਚਕ੍ਰਾਤੇ ਤਤ੍ਪਸ਼੍ਚਾਤ੍ ਜਗ੍ਮੁਤੁਸ਼੍ਚ| ");
INSERT INTO sanpun_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","ਅਨਨ੍ਤਰੰ ਤੇਸ਼਼ੁ ਯਿਰੂਸ਼ਾਲਮ੍ਨਗਰਸ੍ਯ ਸਮੀਪਵੇਰ੍ੱਤਿਨੋ ਜੈਤੁਨਨਾਮਕਧਰਾਧਰਸ੍ਯ ਸਮੀਪਸ੍ਥ੍ਤਿੰ ਬੈਤ੍ਫਗਿਗ੍ਰਾਮਮ੍ ਆਗਤੇਸ਼਼ੁ, ਯੀਸ਼ੁਃ ਸ਼ਿਸ਼਼੍ਯਦ੍ਵਯੰ ਪ੍ਰੇਸ਼਼ਯਨ੍ ਜਗਾਦ, ");
INSERT INTO sanpun_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ਯੁਵਾਂ ਸੰਮੁਖਸ੍ਥਗ੍ਰਾਮੰ ਗਤ੍ਵਾ ਬੱਧਾਂ ਯਾਂ ਸਵਤ੍ਸਾਂ ਗਰ੍ੱਦਭੀਂ ਹਠਾਤ੍ ਪ੍ਰਾਪ੍ਸ੍ਯਥਃ, ਤਾਂ ਮੋਚਯਿਤ੍ਵਾ ਮਦਨ੍ਤਿਕਮ੍ ਆਨਯਤੰ| ");
INSERT INTO sanpun_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","ਤਤ੍ਰ ਯਦਿ ਕਸ਼੍ਚਿਤ੍ ਕਿਞ੍ਚਿਦ੍ ਵਕ੍ਸ਼਼੍ਯਤਿ, ਤਰ੍ਹਿ ਵਦਿਸ਼਼੍ਯਥਃ, ਏਤਸ੍ਯਾਂ ਪ੍ਰਭੋਃ ਪ੍ਰਯੋਜਨਮਾਸ੍ਤੇ, ਤੇਨ ਸ ਤਤ੍ਕ੍ਸ਼਼ਣਾਤ੍ ਪ੍ਰਹੇਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ਸੀਯੋਨਃ ਕਨ੍ਯਕਾਂ ਯੂਯੰ ਭਾਸ਼਼ਧ੍ਵਮਿਤਿ ਭਾਰਤੀਂ| ਪਸ਼੍ਯ ਤੇ ਨਮ੍ਰਸ਼ੀਲਃ ਸਨ੍ ਨ੍ਰੁʼਪ ਆਰੁਹ੍ਯ ਗਰ੍ਦਭੀਂ| ਅਰ੍ਥਾਦਾਰੁਹ੍ਯ ਤਦ੍ਵਤ੍ਸਮਾਯਾਸ੍ਯਤਿ ਤ੍ਵਦਨ੍ਤਿਕੰ| ");
INSERT INTO sanpun_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨੋਕ੍ਤੰ ਵਚਨਮਿਦੰ ਤਦਾ ਸਫਲਮਭੂਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","ਅਨਨ੍ਤਰੰ ਤੌ ਸ਼੍ਸ਼਼੍ਯਿौ ਯੀਸ਼ੋ ਰ੍ਯਥਾਨਿਦੇਸ਼ੰ ਤੰ ਗ੍ਰਾਮੰ ਗਤ੍ਵਾ ");
INSERT INTO sanpun_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ਗਰ੍ਦਭੀਂ ਤਦ੍ਵਤ੍ਸਞ੍ਚ ਸਮਾਨੀਤਵਨ੍ਤੌ, ਪਸ਼੍ਚਾਤ੍ ਤਦੁਪਰਿ ਸ੍ਵੀਯਵਸਨਾਨੀ ਪਾਤਯਿਤ੍ਵਾ ਤਮਾਰੋਹਯਾਮਾਸਤੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ਤਤੋ ਬਹਵੋ ਲੋਕਾ ਨਿਜਵਸਨਾਨਿ ਪਥਿ ਪ੍ਰਸਾਰਯਿਤੁਮਾਰੇਭਿਰੇ, ਕਤਿਪਯਾ ਜਨਾਸ਼੍ਚ ਪਾਦਪਪਰ੍ਣਾਦਿਕੰ ਛਿਤ੍ਵਾ ਪਥਿ ਵਿਸ੍ਤਾਰਯਾਮਾਸੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ਅਗ੍ਰਗਾਮਿਨਃ ਪਸ਼੍ਚਾਦ੍ਗਾਮਿਨਸ਼੍ਚ ਮਨੁਜਾ ਉੱਚੈਰ੍ਜਯ ਜਯ ਦਾਯੂਦਃ ਸਨ੍ਤਾਨੇਤਿ ਜਗਦੁਃ ਪਰਮੇਸ਼੍ਵਰਸ੍ਯ ਨਾਮ੍ਨਾ ਯ ਆਯਾਤਿ ਸ ਧਨ੍ਯਃ, ਸਰ੍ੱਵੋਪਰਿਸ੍ਥਸ੍ਵਰ੍ਗੇਪਿ ਜਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ਇੱਥੰ ਤਸ੍ਮਿਨ੍ ਯਿਰੂਸ਼ਾਲਮੰ ਪ੍ਰਵਿਸ਼਼੍ਟੇ ਕੋ(ਅ)ਯਮਿਤਿ ਕਥਨਾਤ੍ ਕ੍ਰੁʼਤ੍ਸ੍ਨੰ ਨਗਰੰ ਚਞ੍ਚਲਮਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","ਤਤ੍ਰ ਲੋਕੋਃ ਕਥਯਾਮਾਸੁਃ, ਏਸ਼਼ ਗਾਲੀਲ੍ਪ੍ਰਦੇਸ਼ੀਯ-ਨਾਸਰਤੀਯ-ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦੀ ਯੀਸ਼ੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ਅਨਨ੍ਤਰੰ ਯੀਸ਼ੁਰੀਸ਼੍ਵਰਸ੍ਯ ਮਨ੍ਦਿਰੰ ਪ੍ਰਵਿਸ਼੍ਯ ਤਨ੍ਮਧ੍ਯਾਤ੍ ਕ੍ਰਯਵਿਕ੍ਰਯਿਣੋ ਵਹਿਸ਼੍ਚਕਾਰ; ਵਣਿਜਾਂ ਮੁਦ੍ਰਾਸਨਾਨੀ ਕਪੋਤਵਿਕ੍ਰਯਿਣਾਞ੍ਚਸਨਾਨੀ ਚ ਨ੍ਯੁਵ੍ਜਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ਅਪਰੰ ਤਾਨੁਵਾਚ, ਏਸ਼਼ਾ ਲਿਪਿਰਾਸ੍ਤੇ, \"ਮਮ ਗ੍ਰੁʼਹੰ ਪ੍ਰਾਰ੍ਥਨਾਗ੍ਰੁʼਹਮਿਤਿ ਵਿਖ੍ਯਾਸ੍ਯਤਿ\", ਕਿਨ੍ਤੁ ਯੂਯੰ ਤਦ੍ ਦਸ੍ਯੂਨਾਂ ਗਹ੍ਵਰੰ ਕ੍ਰੁʼਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","ਤਦਨਨ੍ਤਰਮ੍ ਅਨ੍ਧਖਞ੍ਚਲੋਕਾਸ੍ਤਸ੍ਯ ਸਮੀਪਮਾਗਤਾਃ, ਸ ਤਾਨ੍ ਨਿਰਾਮਯਾਨ੍ ਕ੍ਰੁʼਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ਯਦਾ ਪ੍ਰਧਾਨਯਾਜਕਾ ਅਧ੍ਯਾਪਕਾਸ਼੍ਚ ਤੇਨ ਕ੍ਰੁʼਤਾਨ੍ਯੇਤਾਨਿ ਚਿਤ੍ਰਕਰ੍ੰਮਾਣਿ ਦਦ੍ਰੁʼਸ਼ੁਃ, ਜਯ ਜਯ ਦਾਯੂਦਃ ਸਨ੍ਤਾਨ, ਮਨ੍ਦਿਰੇ ਬਾਲਕਾਨਾਮ੍ ਏਤਾਦ੍ਰੁʼਸ਼ਮ੍ ਉੱਚਧ੍ਵਨਿੰ ਸ਼ੁਸ਼੍ਰੁਵੁਸ਼੍ਚ, ਤਦਾ ਮਹਾਕ੍ਰੁੱਧਾ ਬਭੂਵਃ, ");
INSERT INTO sanpun_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ਤੰ ਪਪ੍ਰੱਛੁਸ਼੍ਚ, ਇਮੇ ਯਦ੍ ਵਦਨ੍ਤਿ, ਤਤ੍ ਕਿੰ ਤ੍ਵੰ ਸ਼੍ਰੁʼਣੋਸ਼਼ਿ? ਤਤੋ ਯੀਸ਼ੁਸ੍ਤਾਨ੍ ਅਵੋਚਤ੍, ਸਤ੍ਯਮ੍; ਸ੍ਤਨ੍ਯਪਾਯਿਸ਼ਿਸ਼ੂਨਾਞ੍ਚ ਬਾਲਕਾਨਾਞ੍ਚ ਵਕ੍ਤ੍ਰਤਃ| ਸ੍ਵਕੀਯੰ ਮਹਿਮਾਨੰ ਤ੍ਵੰ ਸੰਪ੍ਰਕਾਸ਼ਯਸਿ ਸ੍ਵਯੰ| ਏਤਦ੍ਵਾਕ੍ਯੰ ਯੂਯੰ ਕਿੰ ਨਾਪਠਤ? ");
INSERT INTO sanpun_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ਤਤਸ੍ਤਾਨ੍ ਵਿਹਾਯ ਸ ਨਗਰਾਦ੍ ਬੈਥਨਿਯਾਗ੍ਰਾਮੰ ਗਤ੍ਵਾ ਤਤ੍ਰ ਰਜਨੀਂ ਯਾਪਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","ਅਨਨ੍ਤਰੰ ਪ੍ਰਭਾਤੇ ਸਤਿ ਯੀਸ਼ੁਃ ਪੁਨਰਪਿ ਨਗਰਮਾਗੱਛਨ੍ ਕ੍ਸ਼਼ੁਧਾਰ੍ੱਤੋ ਬਭੂਵ| ");
INSERT INTO sanpun_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ਤਤੋ ਮਾਰ੍ਗਪਾਰ੍ਸ਼੍ਵ ਉਡੁਮ੍ਬਰਵ੍ਰੁʼਕ੍ਸ਼਼ਮੇਕੰ ਵਿਲੋਕ੍ਯ ਤਤ੍ਸਮੀਪੰ ਗਤ੍ਵਾ ਪਤ੍ਰਾਣਿ ਵਿਨਾ ਕਿਮਪਿ ਨ ਪ੍ਰਾਪ੍ਯ ਤੰ ਪਾਦਪੰ ਪ੍ਰੋਵਾਚ, ਅਦ੍ਯਾਰਭ੍ਯ ਕਦਾਪਿ ਤ੍ਵਯਿ ਫਲੰ ਨ ਭਵਤੁ; ਤੇਨ ਤਤ੍ਕ੍ਸ਼਼ਣਾਤ੍ ਸ ਉਡੁਮ੍ਬਰਮਾਹੀਰੁਹਃ ਸ਼ੁਸ਼਼੍ਕਤਾਂ ਗਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ਤਦ੍ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਸ਼ਿਸ਼਼੍ਯਾ ਆਸ਼੍ਚਰ੍ੱਯੰ ਵਿਜ੍ਞਾਯ ਕਥਯਾਮਾਸੁਃ, ਆਃ, ਉਡੁਮ੍ਵਰਪਾਦਪੋ(ਅ)ਤਿਤੂਰ੍ਣੰ ਸ਼ੁਸ਼਼੍ਕੋ(ਅ)ਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ਤਤੋ ਯੀਸ਼ੁਸ੍ਤਾਨੁਵਾਚ, ਯੁਸ਼਼੍ਮਾਨਹੰ ਸਤ੍ਯੰ ਵਦਾਮਿ, ਯਦਿ ਯੂਯਮਸਨ੍ਦਿਗ੍ਧਾਃ ਪ੍ਰਤੀਥ, ਤਰ੍ਹਿ ਯੂਯਮਪਿ ਕੇਵਲੋਡੁਮ੍ਵਰਪਾਦਪੰ ਪ੍ਰਤੀੱਥੰ ਕਰ੍ੱਤੁੰ ਸ਼ਕ੍ਸ਼਼੍ਯਥ, ਤੰਨ, ਤ੍ਵੰ ਚਲਿਤ੍ਵਾ ਸਾਗਰੇ ਪਤੇਤਿ ਵਾਕ੍ਯੰ ਯੁਸ਼਼੍ਮਾਭਿਰਸ੍ਮਿਨ ਸ਼ੈਲੇ ਪ੍ਰੋਕ੍ਤੇਪਿ ਤਦੈਵ ਤਦ੍ ਘਟਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","ਤਥਾ ਵਿਸ਼੍ਵਸ੍ਯ ਪ੍ਰਾਰ੍ਥ੍ਯ ਯੁਸ਼਼੍ਮਾਭਿ ਰ੍ਯਦ੍ ਯਾਚਿਸ਼਼੍ਯਤੇ, ਤਦੇਵ ਪ੍ਰਾਪ੍ਸ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","ਅਨਨ੍ਤਰੰ ਮਨ੍ਦਿਰੰ ਪ੍ਰਵਿਸ਼੍ਯੋਪਦੇਸ਼ਨਸਮਯੇ ਤਤ੍ਸਮੀਪੰ ਪ੍ਰਧਾਨਯਾਜਕਾਃ ਪ੍ਰਾਚੀਨਲੋਕਾਸ਼੍ਚਾਗਤ੍ਯ ਪਪ੍ਰੱਛੁਃ, ਤ੍ਵਯਾ ਕੇਨ ਸਾਮਰ੍ਥ੍ਯਨੈਤਾਨਿ ਕਰ੍ੰਮਾਣਿ ਕ੍ਰਿਯਨ੍ਤੇ? ਕੇਨ ਵਾ ਤੁਭ੍ਯਮੇਤਾਨਿ ਸਾਮਰ੍ਥ੍ਯਾਨਿ ਦੱਤਾਨਿ? ");
INSERT INTO sanpun_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ਤਤੋ ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯਵਦਤ੍, ਅਹਮਪਿ ਯੁਸ਼਼੍ਮਾਨ੍ ਵਾਚਮੇਕਾਂ ਪ੍ਰੁʼੱਛਾਮਿ, ਯਦਿ ਯੂਯੰ ਤਦੁੱਤਰੰ ਦਾਤੁੰ ਸ਼ਕ੍ਸ਼਼੍ਯਥ, ਤਦਾ ਕੇਨ ਸਾਮਰ੍ਥ੍ਯੇਨ ਕਰ੍ੰਮਾਣ੍ਯੇਤਾਨਿ ਕਰੋਮਿ, ਤਦਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਵਕ੍ਸ਼਼੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","ਯੋਹਨੋ ਮੱਜਨੰ ਕਸ੍ਯਾਜ੍ਞਯਾਭਵਤ੍? ਕਿਮੀਸ਼੍ਵਰਸ੍ਯ ਮਨੁਸ਼਼੍ਯਸ੍ਯ ਵਾ? ਤਤਸ੍ਤੇ ਪਰਸ੍ਪਰੰ ਵਿਵਿਚ੍ਯ ਕਥਯਾਮਾਸੁਃ, ਯਦੀਸ਼੍ਵਰਸ੍ਯੇਤਿ ਵਦਾਮਸ੍ਤਰ੍ਹਿ ਯੂਯੰ ਤੰ ਕੁਤੋ ਨ ਪ੍ਰਤ੍ਯੈਤ? ਵਾਚਮੇਤਾਂ ਵਕ੍ਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","ਮਨੁਸ਼਼੍ਯਸ੍ਯੇਤਿ ਵਕ੍ਤੁਮਪਿ ਲੋਕੇਭ੍ਯੋ ਬਿਭੀਮਃ, ਯਤਃ ਸਰ੍ੱਵੈਰਪਿ ਯੋਹਨ੍ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦੀਤਿ ਜ੍ਞਾਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","ਤਸ੍ਮਾਤ੍ ਤੇ ਯੀਸ਼ੁੰ ਪ੍ਰਤ੍ਯਵਦਨ੍, ਤਦ੍ ਵਯੰ ਨ ਵਿਦ੍ਮਃ| ਤਦਾ ਸ ਤਾਨੁਕ੍ਤਵਾਨ੍, ਤਰ੍ਹਿ ਕੇਨ ਸਾਮਰਥ੍ਯੇਨ ਕਰ੍ੰਮਾਣ੍ਯੇਤਾਨ੍ਯਹੰ ਕਰੋਮਿ, ਤਦਪ੍ਯਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਨ ਵਕ੍ਸ਼਼੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","ਕਸ੍ਯਚਿੱਜਨਸ੍ਯ ਦ੍ਵੌ ਸੁਤਾਵਾਸ੍ਤਾਂ ਸ ਏਕਸ੍ਯ ਸੁਤਸ੍ਯ ਸਮੀਪੰ ਗਤ੍ਵਾ ਜਗਾਦ, ਹੇ ਸੁਤ, ਤ੍ਵਮਦ੍ਯ ਮਮ ਦ੍ਰਾਕ੍ਸ਼਼ਾਕ੍ਸ਼਼ੇਤ੍ਰੇ ਕਰ੍ੰਮ ਕਰ੍ਤੁੰ ਵ੍ਰਜ| ");
INSERT INTO sanpun_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ਤਤਃ ਸ ਉਕ੍ਤਵਾਨ੍, ਨ ਯਾਸ੍ਯਾਮਿ, ਕਿਨ੍ਤੁ ਸ਼ੇਸ਼਼ੇ(ਅ)ਨੁਤਪ੍ਯ ਜਗਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","ਅਨਨ੍ਤਰੰ ਸੋਨ੍ਯਸੁਤਸ੍ਯ ਸਮੀਪੰ ਗਤ੍ਵਾ ਤਥੈਵ ਕਥ੍ਤਿਵਾਨ੍; ਤਤਃ ਸ ਪ੍ਰਤ੍ਯੁਵਾਚ, ਮਹੇੱਛ ਯਾਮਿ, ਕਿਨ੍ਤੁ ਨ ਗਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","ਏਤਯੋਃ ਪੁਤ੍ਰਯੋ ਰ੍ਮਧ੍ਯੇ ਪਿਤੁਰਭਿਮਤੰ ਕੇਨ ਪਾਲਿਤੰ? ਯੁਸ਼਼੍ਮਾਭਿਃ ਕਿੰ ਬੁਧ੍ਯਤੇ? ਤਤਸ੍ਤੇ ਪ੍ਰਤ੍ਯੂਚੁਃ, ਪ੍ਰਥਮੇਨ ਪੁुਤ੍ਰੇਣ| ਤਦਾਨੀਂ ਯੀਸ਼ੁਸ੍ਤਾਨੁਵਾਚ, ਅਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਤਥ੍ਯੰ ਵਦਾਮਿ, ਚਣ੍ਡਾਲਾ ਗਣਿਕਾਸ਼੍ਚ ਯੁਸ਼਼੍ਮਾਕਮਗ੍ਰਤ ਈਸ਼੍ਵਰਸ੍ਯ ਰਾਜ੍ਯੰ ਪ੍ਰਵਿਸ਼ਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ਯਤੋ ਯੁਸ਼਼੍ਮਾਕੰ ਸਮੀਪੰ ਯੋਹਨਿ ਧਰ੍ੰਮਪਥੇਨਾਗਤੇ ਯੂਯੰ ਤੰ ਨ ਪ੍ਰਤੀਥ, ਕਿਨ੍ਤੁ ਚਣ੍ਡਾਲਾ ਗਣਿਕਾਸ਼੍ਚ ਤੰ ਪ੍ਰਤ੍ਯਾਯਨ੍, ਤਦ੍ ਵਿਲੋਕ੍ਯਾਪਿ ਯੂਯੰ ਪ੍ਰਤ੍ਯੇਤੁੰ ਨਾਖਿਦ੍ਯਧ੍ਵੰ| ");
INSERT INTO sanpun_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","ਅਪਰਮੇਕੰ ਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤੰ ਸ਼੍ਰੁʼਣੁਤ, ਕਸ਼੍ਚਿਦ੍ ਗ੍ਰੁʼਹਸ੍ਥਃ ਕ੍ਸ਼਼ੇਤ੍ਰੇ ਦ੍ਰਾਕ੍ਸ਼਼ਾਲਤਾ ਰੋਪਯਿਤ੍ਵਾ ਤੱਚਤੁਰ੍ਦਿਕ੍ਸ਼਼ੁ ਵਾਰਣੀਂ ਵਿਧਾਯ ਤਨ੍ਮਧ੍ਯੇ ਦ੍ਰਾਕ੍ਸ਼਼ਾਯਨ੍ਤ੍ਰੰ ਸ੍ਥਾਪਿਤਵਾਨ੍, ਮਾਞ੍ਚਞ੍ਚ ਨਿਰ੍ੰਮਿਤਵਾਨ੍, ਤਤਃ ਕ੍ਰੁʼਸ਼਼ਕੇਸ਼਼ੁ ਤਤ੍ ਕ੍ਸ਼਼ੇਤ੍ਰੰ ਸਮਰ੍ਪ੍ਯ ਸ੍ਵਯੰ ਦੂਰਦੇਸ਼ੰ ਜਗਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","ਤਦਨਨ੍ਤਰੰ ਫਲਸਮਯ ਉਪਸ੍ਥਿਤੇ ਸ ਫਲਾਨਿ ਪ੍ਰਾਪ੍ਤੁੰ ਕ੍ਰੁʼਸ਼਼ੀਵਲਾਨਾਂ ਸਮੀਪੰ ਨਿਜਦਾਸਾਨ੍ ਪ੍ਰੇਸ਼਼ਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","ਕਿਨ੍ਤੁ ਕ੍ਰੁʼਸ਼਼ੀਵਲਾਸ੍ਤਸ੍ਯ ਤਾਨ੍ ਦਾਸੇਯਾਨ੍ ਧ੍ਰੁʼਤ੍ਵਾ ਕਞ੍ਚਨ ਪ੍ਰਹ੍ਰੁʼਤਵਨ੍ਤਃ, ਕਞ੍ਚਨ ਪਾਸ਼਼ਾਣੈਰਾਹਤਵਨ੍ਤਃ, ਕਞ੍ਚਨ ਚ ਹਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","ਪੁਨਰਪਿ ਸ ਪ੍ਰਭੁਃ ਪ੍ਰਥਮਤੋ(ਅ)ਧਿਕਦਾਸੇਯਾਨ੍ ਪ੍ਰੇਸ਼਼ਯਾਮਾਸ, ਕਿਨ੍ਤੁ ਤੇ ਤਾਨ੍ ਪ੍ਰਤ੍ਯਪਿ ਤਥੈਵ ਚਕ੍ਰੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","ਅਨਨ੍ਤਰੰ ਮਮ ਸੁਤੇ ਗਤੇ ਤੰ ਸਮਾਦਰਿਸ਼਼੍ਯਨ੍ਤੇ, ਇਤ੍ਯੁਕ੍ਤ੍ਵਾ ਸ਼ੇਸ਼਼ੇ ਸ ਨਿਜਸੁਤੰ ਤੇਸ਼਼ਾਂ ਸੰਨਿਧਿੰ ਪ੍ਰੇਸ਼਼ਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","ਕਿਨ੍ਤੁ ਤੇ ਕ੍ਰੁʼਸ਼਼ੀਵਲਾਃ ਸੁਤੰ ਵੀਕ੍ਸ਼਼੍ਯ ਪਰਸ੍ਪਰਮ੍ ਇਤਿ ਮਨ੍ਤ੍ਰਯਿਤੁਮ੍ ਆਰੇਭਿਰੇ, ਅਯਮੁੱਤਰਾਧਿਕਾਰੀ ਵਯਮੇਨੰ ਨਿਹਤ੍ਯਾਸ੍ਯਾਧਿਕਾਰੰ ਸ੍ਵਵਸ਼ੀਕਰਿਸ਼਼੍ਯਾਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","ਪਸ਼੍ਚਾਤ੍ ਤੇ ਤੰ ਧ੍ਰੁʼਤ੍ਵਾ ਦ੍ਰਾਕ੍ਸ਼਼ਾਕ੍ਸ਼਼ੇਤ੍ਰਾਦ੍ ਬਹਿਃ ਪਾਤਯਿਤ੍ਵਾਬਧਿਸ਼਼ੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","ਯਦਾ ਸ ਦ੍ਰਾਕ੍ਸ਼਼ਾਕ੍ਸ਼਼ੇਤ੍ਰਪਤਿਰਾਗਮਿਸ਼਼੍ਯਤਿ, ਤਦਾ ਤਾਨ੍ ਕ੍ਰੁʼਸ਼਼ੀਵਲਾਨ੍ ਕਿੰ ਕਰਿਸ਼਼੍ਯਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ਤਤਸ੍ਤੇ ਪ੍ਰਤ੍ਯਵਦਨ੍, ਤਾਨ੍ ਕਲੁਸ਼਼ਿਣੋ ਦਾਰੁਣਯਾਤਨਾਭਿਰਾਹਨਿਸ਼਼੍ਯਤਿ, ਯੇ ਚ ਸਮਯਾਨੁਕ੍ਰਮਾਤ੍ ਫਲਾਨਿ ਦਾਸ੍ਯਨ੍ਤਿ, ਤਾਦ੍ਰੁʼਸ਼ੇਸ਼਼ੁ ਕ੍ਰੁʼਸ਼਼ੀਵਲੇਸ਼਼ੁ ਕ੍ਸ਼਼ੇਤ੍ਰੰ ਸਮਰ੍ਪਯਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ਤਦਾ ਯੀਸ਼ੁਨਾ ਤੇ ਗਦਿਤਾਃ, ਗ੍ਰਹਣੰ ਨ ਕ੍ਰੁʼਤੰ ਯਸ੍ਯ ਪਾਸ਼਼ਾਣਸ੍ਯ ਨਿਚਾਯਕੈਃ| ਪ੍ਰਧਾਨਪ੍ਰਸ੍ਤਰਃ ਕੋਣੇ ਸਏਵ ਸੰਭਵਿਸ਼਼੍ਯਤਿ| ਏਤਤ੍ ਪਰੇਸ਼ਿਤੁਃ ਕਰ੍ੰਮਾਸ੍ਮਦ੍ਰੁʼਸ਼਼੍ਟਾਵਦ੍ਭੁਤੰ ਭਵੇਤ੍| ਧਰ੍ੰਮਗ੍ਰਨ੍ਥੇ ਲਿਖਿਤਮੇਤਦ੍ਵਚਨੰ ਯੁਸ਼਼੍ਮਾਭਿਃ ਕਿੰ ਨਾਪਾਠਿ? ");
INSERT INTO sanpun_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","ਤਸ੍ਮਾਦਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਵਦਾਮਿ, ਯੁਸ਼਼੍ਮੱਤ ਈਸ਼੍ਵਰੀਯਰਾਜ੍ਯਮਪਨੀਯ ਫਲੋਤ੍ਪਾਦਯਿਤ੍ਰਨ੍ਯਜਾਤਯੇ ਦਾਯਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","ਯੋ ਜਨ ਏਤਤ੍ਪਾਸ਼਼ਾਣੋਪਰਿ ਪਤਿਸ਼਼੍ਯਤਿ, ਤੰ ਸ ਭੰਕ੍ਸ਼਼੍ਯਤੇ, ਕਿਨ੍ਤ੍ਵਯੰ ਪਾਸ਼਼ਾਣੋ ਯਸ੍ਯੋਪਰਿ ਪਤਿਸ਼਼੍ਯਤਿ, ਤੰ ਸ ਧੂਲਿਵਤ੍ ਚੂਰ੍ਣੀਕਰਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","ਤਦਾਨੀਂ ਪ੍ਰਾਧਨਯਾਜਕਾਃ ਫਿਰੂਸ਼ਿਨਸ਼੍ਚ ਤਸ੍ਯੇਮਾਂ ਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤਕਥਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਸੋ(ਅ)ਸ੍ਮਾਨੁੱਦਿਸ਼੍ਯ ਕਥਿਤਵਾਨ੍, ਇਤਿ ਵਿਜ੍ਞਾਯ ਤੰ ਧਰ੍ੱਤੁੰ ਚੇਸ਼਼੍ਟਿਤਵਨ੍ਤਃ; ");
INSERT INTO sanpun_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ਕਿਨ੍ਤੁ ਲੋਕੇਭ੍ਯੋ ਬਿਭ੍ਯੁਃ, ਯਤੋ ਲੋਕੈਃ ਸ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦੀਤ੍ਯਜ੍ਞਾਯਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","ਅਨਨ੍ਤਰੰ ਯੀਸ਼ੁਃ ਪੁਨਰਪਿ ਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤੇਨ ਤਾਨ੍ ਅਵਾਦੀਤ੍, ");
INSERT INTO sanpun_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","ਸ੍ਵਰ੍ਗੀਯਰਾਜ੍ਯਮ੍ ਏਤਾਦ੍ਰੁʼਸ਼ਸ੍ਯ ਨ੍ਰੁʼਪਤੇਃ ਸਮੰ, ਯੋ ਨਿਜ ਪੁਤ੍ਰੰ ਵਿਵਾਹਯਨ੍ ਸਰ੍ੱਵਾਨ੍ ਨਿਮਨ੍ਤ੍ਰਿਤਾਨ੍ ਆਨੇਤੁੰ ਦਾਸੇਯਾਨ੍ ਪ੍ਰਹਿਤਵਾਨ੍, ");
INSERT INTO sanpun_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ਕਿਨ੍ਤੁ ਤੇ ਸਮਾਗਨ੍ਤੁੰ ਨੇਸ਼਼੍ਟਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ਤਤੋ ਰਾਜਾ ਪੁਨਰਪਿ ਦਾਸਾਨਨ੍ਯਾਨ੍ ਇਤ੍ਯੁਕ੍ਤ੍ਵਾ ਪ੍ਰੇਸ਼਼ਯਾਮਾਸ, ਨਿਮਨ੍ਤ੍ਰਿਤਾਨ੍ ਵਦਤ, ਪਸ਼੍ਯਤ, ਮਮ ਭੇਜ੍ਯਮਾਸਾਦਿਤਮਾਸ੍ਤੇ, ਨਿਜਵ੍ਟਸ਼਼ਾਦਿਪੁਸ਼਼੍ਟਜਨ੍ਤੂਨ੍ ਮਾਰਯਿਤ੍ਵਾ ਸਰ੍ੱਵੰ ਖਾਦ੍ਯਦ੍ਰਵ੍ਯਮਾਸਾਦਿਤਵਾਨ੍, ਯੂਯੰ ਵਿਵਾਹਮਾਗੱਛਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","ਤਥਪਿ ਤੇ ਤੁੱਛੀਕ੍ਰੁʼਤ੍ਯ ਕੇਚਿਤ੍ ਨਿਜਕ੍ਸ਼਼ੇਤ੍ਰੰ ਕੇਚਿਦ੍ ਵਾਣਿਜ੍ਯੰ ਪ੍ਰਤਿ ਸ੍ਵਸ੍ਵਮਾਰ੍ਗੇਣ ਚਲਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ਅਨ੍ਯੇ ਲੋਕਾਸ੍ਤਸ੍ਯ ਦਾਸੇਯਾਨ੍ ਧ੍ਰੁʼਤ੍ਵਾ ਦੌਰਾਤ੍ਮ੍ਯੰ ਵ੍ਯਵਹ੍ਰੁʼਤ੍ਯ ਤਾਨਵਧਿਸ਼਼ੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","ਅਨਨ੍ਤਰੰ ਸ ਨ੍ਰੁʼਪਤਿਸ੍ਤਾਂ ਵਾਰ੍ੱਤਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਕ੍ਰੁਧ੍ਯਨ੍ ਸੈਨ੍ਯਾਨਿ ਪ੍ਰਹਿਤ੍ਯ ਤਾਨ੍ ਘਾਤਕਾਨ੍ ਹਤ੍ਵਾ ਤੇਸ਼਼ਾਂ ਨਗਰੰ ਦਾਹਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","ਤਤਃ ਸ ਨਿਜਦਾਸੇਯਾਨ੍ ਬਭਾਸ਼਼ੇ, ਵਿਵਾਹੀਯੰ ਭੋਜ੍ਯਮਾਸਾਦਿਤਮਾਸ੍ਤੇ, ਕਿਨ੍ਤੁ ਨਿਮਨ੍ਤ੍ਰਿਤਾ ਜਨਾ ਅਯੋਗ੍ਯਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ਤਸ੍ਮਾਦ੍ ਯੂਯੰ ਰਾਜਮਾਰ੍ਗੰ ਗਤ੍ਵਾ ਯਾਵਤੋ ਮਨੁਜਾਨ੍ ਪਸ਼੍ਯਤ, ਤਾਵਤਏਵ ਵਿਵਾਹੀਯਭੋਜ੍ਯਾਯ ਨਿਮਨ੍ਤ੍ਰਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","ਤਦਾ ਤੇ ਦਾਸੇਯਾ ਰਾਜਮਾਰ੍ਗੰ ਗਤ੍ਵਾ ਭਦ੍ਰਾਨ੍ ਅਭਦ੍ਰਾਨ੍ ਵਾ ਯਾਵਤੋ ਜਨਾਨ੍ ਦਦ੍ਰੁʼਸ਼ੁਃ, ਤਾਵਤਏਵ ਸੰਗ੍ਰੁʼਹ੍ਯਾਨਯਨ੍; ਤਤੋ(ਅ)ਭ੍ਯਾਗਤਮਨੁਜੈ ਰ੍ਵਿਵਾਹਗ੍ਰੁʼਹਮ੍ ਅਪੂਰ੍ੱਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","ਤਦਾਨੀਂ ਸ ਰਾਜਾ ਸਰ੍ੱਵਾਨਭ੍ਯਾਗਤਾਨ੍ ਦ੍ਰਸ਼਼੍ਟੁਮ੍ ਅਭ੍ਯਨ੍ਤਰਮਾਗਤਵਾਨ੍; ਤਦਾ ਤਤ੍ਰ ਵਿਵਾਹੀਯਵਸਨਹੀਨਮੇਕੰ ਜਨੰ ਵੀਕ੍ਸ਼਼੍ਯ ਤੰ ਜਗਾਦ੍, ");
INSERT INTO sanpun_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ਹੇ ਮਿਤ੍ਰ,ਤ੍ਵੰ ਵਿਵਾਹੀਯਵਸਨੰ ਵਿਨਾ ਕਥਮਤ੍ਰ ਪ੍ਰਵਿਸ਼਼੍ਟਵਾਨ੍? ਤੇਨ ਸ ਨਿਰੁੱਤਰੋ ਬਭੂਵ| ");
INSERT INTO sanpun_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","ਤਦਾ ਰਾਜਾ ਨਿਜਾਨੁਚਰਾਨ੍ ਅਵਦਤ੍, ਏਤਸ੍ਯ ਕਰਚਰਣਾਨ੍ ਬੱਧਾ ਯਤ੍ਰ ਰੋਦਨੰ ਦਨ੍ਤੈਰ੍ਦਨ੍ਤਘਰ੍ਸ਼਼ਣਞ੍ਚ ਭਵਤਿ, ਤਤ੍ਰ ਵਹਿਰ੍ਭੂਤਤਮਿਸ੍ਰੇ ਤੰ ਨਿਕ੍ਸ਼਼ਿਪਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","ਇੱਥੰ ਬਹਵ ਆਹੂਤਾ ਅਲ੍ਪੇ ਮਨੋਭਿਮਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","ਅਨਨ੍ਤਰੰ ਫਿਰੂਸ਼ਿਨਃ ਪ੍ਰਗਤ੍ਯ ਯਥਾ ਸੰਲਾਪੇਨ ਤਮ੍ ਉਨ੍ਮਾਥੇ ਪਾਤਯੇਯੁਸ੍ਤਥਾ ਮਨ੍ਤ੍ਰਯਿਤ੍ਵਾ ");
INSERT INTO sanpun_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ਹੇਰੋਦੀਯਮਨੁਜੈਃ ਸਾਕੰ ਨਿਜਸ਼ਿਸ਼਼੍ਯਗਣੇਨ ਤੰ ਪ੍ਰਤਿ ਕਥਯਾਮਾਸੁਃ, ਹੇ ਗੁਰੋ, ਭਵਾਨ੍ ਸਤ੍ਯਃ ਸਤ੍ਯਮੀਸ਼੍ਵਰੀਯਮਾਰ੍ਗਮੁਪਦਿਸ਼ਤਿ, ਕਮਪਿ ਮਾਨੁਸ਼਼ੰ ਨਾਨੁਰੁਧ੍ਯਤੇ, ਕਮਪਿ ਨਾਪੇਕ੍ਸ਼਼ਤੇ ਚ, ਤਦ੍ ਵਯੰ ਜਾਨੀਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","ਅਤਃ ਕੈਸਰਭੂਪਾਯ ਕਰੋ(ਅ)ਸ੍ਮਾਕੰ ਦਾਤਵ੍ਯੋ ਨ ਵਾ? ਅਤ੍ਰ ਭਵਤਾ ਕਿੰ ਬੁਧ੍ਯਤੇ? ਤਦ੍ ਅਸ੍ਮਾਨ੍ ਵਦਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ਤਤੋ ਯੀਸ਼ੁਸ੍ਤੇਸ਼਼ਾਂ ਖਲਤਾਂ ਵਿਜ੍ਞਾਯ ਕਥਿਤਵਾਨ੍, ਰੇ ਕਪਟਿਨਃ ਯੁਯੰ ਕੁਤੋ ਮਾਂ ਪਰਿਕ੍ਸ਼਼ਧ੍ਵੇ? ");
INSERT INTO sanpun_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","ਤਤ੍ਕਰਦਾਨਸ੍ਯ ਮੁਦ੍ਰਾਂ ਮਾਂ ਦਰ੍ਸ਼ਯਤ| ਤਦਾਨੀਂ ਤੈਸ੍ਤਸ੍ਯ ਸਮੀਪੰ ਮੁਦ੍ਰਾਚਤੁਰ੍ਥਭਾਗ ਆਨੀਤੇ ");
INSERT INTO sanpun_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ਸ ਤਾਨ੍ ਪਪ੍ਰੱਛ, ਅਤ੍ਰ ਕਸ੍ਯੇਯੰ ਮੂਰ੍ੱਤਿ ਰ੍ਨਾਮ ਚਾਸ੍ਤੇ? ਤੇ ਜਗਦੁਃ, ਕੈਸਰਭੂਪਸ੍ਯ| ");
INSERT INTO sanpun_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ਤਤਃ ਸ ਉਕ੍ਤਵਾਨ, ਕੈਸਰਸ੍ਯ ਯਤ੍ ਤਤ੍ ਕੈਸਰਾਯ ਦੱਤ, ਈਸ਼੍ਵਰਸ੍ਯ ਯਤ੍ ਤਦ੍ ਈਸ਼੍ਵਰਾਯ ਦੱਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ਇਤਿ ਵਾਕ੍ਯੰ ਨਿਸ਼ਮ੍ਯ ਤੇ ਵਿਸ੍ਮਯੰ ਵਿਜ੍ਞਾਯ ਤੰ ਵਿਹਾਯ ਚਲਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","ਤਸ੍ਮਿੰਨਹਨਿ ਸਿਦੂਕਿਨੋ(ਅ)ਰ੍ਥਾਤ੍ ਸ਼੍ਮਸ਼ਾਨਾਤ੍ ਨੋੱਥਾਸ੍ਯਨ੍ਤੀਤਿ ਵਾਕ੍ਯੰ ਯੇ ਵਦਨ੍ਤਿ, ਤੇ ਯੀਸ਼ੇाਰਨ੍ਤਿਕਮ੍ ਆਗਤ੍ਯ ਪਪ੍ਰੱਛੁਃ, ");
INSERT INTO sanpun_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ਹੇ ਗੁਰੋ, ਕਸ਼੍ਚਿਨ੍ਮਨੁਜਸ਼੍ਚੇਤ੍ ਨਿਃਸਨ੍ਤਾਨਃ ਸਨ੍ ਪ੍ਰਾਣਾਨ੍ ਤ੍ਯਜਤਿ, ਤਰ੍ਹਿ ਤਸ੍ਯ ਭ੍ਰਾਤਾ ਤਸ੍ਯ ਜਾਯਾਂ ਵ੍ਯੁਹ੍ਯ ਭ੍ਰਾਤੁਃ ਸਨ੍ਤਾਨਮ੍ ਉਤ੍ਪਾਦਯਿਸ਼਼੍ਯਤੀਤਿ ਮੂਸਾ ਆਦਿਸ਼਼੍ਟਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ਕਿਨ੍ਤ੍ਵਸ੍ਮਾਕਮਤ੍ਰ ਕੇ(ਅ)ਪਿ ਜਨਾਃ ਸਪ੍ਤਸਹੋਦਰਾ ਆਸਨ੍, ਤੇਸ਼਼ਾਂ ਜ੍ਯੇਸ਼਼੍ਠ ਏਕਾਂ ਕਨ੍ਯਾਂ ਵ੍ਯਵਹਾਤ੍, ਅਪਰੰ ਪ੍ਰਾਣਤ੍ਯਾਗਕਾਲੇ ਸ੍ਵਯੰ ਨਿਃਸਨ੍ਤਾਨਃ ਸਨ੍ ਤਾਂ ਸ੍ਤ੍ਰਿਯੰ ਸ੍ਵਭ੍ਰਾਤਰਿ ਸਮਰ੍ਪਿਤਵਾਨ੍, ");
INSERT INTO sanpun_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ਤਤੋ ਦ੍ਵਿਤੀਯਾਦਿਸਪ੍ਤਮਾਨ੍ਤਾਸ਼੍ਚ ਤਥੈਵ ਚਕ੍ਰੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ਸ਼ੇਸ਼਼ੇ ਸਾਪੀ ਨਾਰੀ ਮਮਾਰ| ");
INSERT INTO sanpun_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","ਮ੍ਰੁʼਤਾਨਾਮ੍ ਉੱਥਾਨਸਮਯੇ ਤੇਸ਼਼ਾਂ ਸਪ੍ਤਾਨਾਂ ਮਧ੍ਯੇ ਸਾ ਨਾਰੀ ਕਸ੍ਯ ਭਾਰ੍ੱਯਾ ਭਵਿਸ਼਼੍ਯਤਿ? ਯਸ੍ਮਾਤ੍ ਸਰ੍ੱਵਏਵ ਤਾਂ ਵ੍ਯਵਹਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ਤਤੋ ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯਵਾਦੀਤ੍, ਯੂਯੰ ਧਰ੍ੰਮਪੁਸ੍ਤਕਮ੍ ਈਸ਼੍ਵਰੀਯਾਂ ਸ਼ਕ੍ਤਿਞ੍ਚ ਨ ਵਿਜ੍ਞਾਯ ਭ੍ਰਾਨ੍ਤਿਮਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","ਉੱਥਾਨਪ੍ਰਾਪ੍ਤਾ ਲੋਕਾ ਨ ਵਿਵਹਨ੍ਤਿ, ਨ ਚ ਵਾਚਾ ਦੀਯਨ੍ਤੇ, ਕਿਨ੍ਤ੍ਵੀਸ਼੍ਵਰਸ੍ਯ ਸ੍ਵਰ੍ਗਸ੍ਥਦੂਤਾਨਾਂ ਸਦ੍ਰੁʼਸ਼ਾ ਭਵਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","ਅਪਰੰ ਮ੍ਰੁʼਤਾਨਾਮੁੱਥਾਨਮਧਿ ਯੁਸ਼਼੍ਮਾਨ੍ ਪ੍ਰਤੀਯਮੀਸ਼੍ਵਰੋਕ੍ਤਿਃ, ");
INSERT INTO sanpun_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","\"ਅਹਮਿਬ੍ਰਾਹੀਮ ਈਸ਼੍ਵਰ ਇਸ੍ਹਾਕ ਈਸ਼੍ਵਰੋ ਯਾਕੂਬ ਈਸ਼੍ਵਰ\" ਇਤਿ ਕਿੰ ਯੁਸ਼਼੍ਮਾਭਿ ਰ੍ਨਾਪਾਠਿ? ਕਿਨ੍ਤ੍ਵੀਸ਼੍ਵਰੋ ਜੀਵਤਾਮ੍ ਈਸ਼੍ਵਰ:, ਸ ਮ੍ਰੁʼਤਾਨਾਮੀਸ਼੍ਵਰੋ ਨਹਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ਇਤਿ ਸ਼੍ਰੁਤ੍ਵਾ ਸਰ੍ੱਵੇ ਲੋਕਾਸ੍ਤਸ੍ਯੋਪਦੇਸ਼ਾਦ੍ ਵਿਸ੍ਮਯੰ ਗਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","ਅਨਨ੍ਤਰੰ ਸਿਦੂਕਿਨਾਮ੍ ਨਿਰੁੱਤਰਤ੍ਵਵਾਰ੍ਤਾਂ ਨਿਸ਼ਮ੍ਯ ਫਿਰੂਸ਼ਿਨ ਏਕਤ੍ਰ ਮਿਲਿਤਵਨ੍ਤਃ, ");
INSERT INTO sanpun_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ਤੇਸ਼਼ਾਮੇਕੋ ਵ੍ਯਵਸ੍ਥਾਪਕੋ ਯੀਸ਼ੁੰ ਪਰੀਕ੍ਸ਼਼ਿਤੁੰ ਪਪੱਛ, ");
INSERT INTO sanpun_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","ਹੇ ਗੁਰੋ ਵ੍ਯਵਸ੍ਥਾਸ਼ਾਸ੍ਤ੍ਰਮਧ੍ਯੇ ਕਾਜ੍ਞਾ ਸ਼੍ਰੇਸ਼਼੍ਠਾ? ");
INSERT INTO sanpun_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ਤਤੋ ਯੀਸ਼ੁਰੁਵਾਚ, ਤ੍ਵੰ ਸਰ੍ੱਵਾਨ੍ਤਃਕਰਣੈਃ ਸਰ੍ੱਵਪ੍ਰਾਣੈਃ ਸਰ੍ੱਵਚਿੱਤੈਸ਼੍ਚ ਸਾਕੰ ਪ੍ਰਭੌ ਪਰਮੇਸ਼੍ਵਰੇ ਪ੍ਰੀਯਸ੍ਵ, ");
INSERT INTO sanpun_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ਏਸ਼਼ਾ ਪ੍ਰਥਮਮਹਾਜ੍ਞਾ| ਤਸ੍ਯਾਃ ਸਦ੍ਰੁʼਸ਼ੀ ਦ੍ਵਿਤੀਯਾਜ੍ਞੈਸ਼਼ਾ, ");
INSERT INTO sanpun_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ਤਵ ਸਮੀਪਵਾਸਿਨਿ ਸ੍ਵਾਤ੍ਮਨੀਵ ਪ੍ਰੇਮ ਕੁਰੁ| ");
INSERT INTO sanpun_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","ਅਨਯੋ ਰ੍ਦ੍ਵਯੋਰਾਜ੍ਞਯੋਃ ਕ੍ਰੁʼਤ੍ਸ੍ਨਵ੍ਯਵਸ੍ਥਾਯਾ ਭਵਿਸ਼਼੍ਯਦ੍ਵਕ੍ਤ੍ਰੁʼਗ੍ਰਨ੍ਥਸ੍ਯ ਚ ਭਾਰਸ੍ਤਿਸ਼਼੍ਠਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ਅਨਨ੍ਤਰੰ ਫਿਰੂਸ਼ਿਨਾਮ੍ ਏਕਤ੍ਰ ਸ੍ਥਿਤਿਕਾਲੇ ਯੀਸ਼ੁਸ੍ਤਾਨ੍ ਪਪ੍ਰੱਛ, ");
INSERT INTO sanpun_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","ਖ੍ਰੀਸ਼਼੍ਟਮਧਿ ਯੁਸ਼਼੍ਮਾਕੰ ਕੀਦ੍ਰੁʼਗ੍ਬੋਧੋ ਜਾਯਤੇ? ਸ ਕਸ੍ਯ ਸਨ੍ਤਾਨਃ? ਤਤਸ੍ਤੇ ਪ੍ਰਤ੍ਯਵਦਨ੍, ਦਾਯੂਦਃ ਸਨ੍ਤਾਨਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","ਤਦਾ ਸ ਉਕ੍ਤਵਾਨ੍, ਤਰ੍ਹਿ ਦਾਯੂਦ੍ ਕਥਮ੍ ਆਤ੍ਮਾਧਿਸ਼਼੍ਠਾਨੇਨ ਤੰ ਪ੍ਰਭੁੰ ਵਦਤਿ ? ");
INSERT INTO sanpun_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","ਯਥਾ ਮਮ ਪ੍ਰਭੁਮਿਦੰ ਵਾਕ੍ਯਮਵਦਤ੍ ਪਰਮੇਸ਼੍ਵਰਃ| ਤਵਾਰੀਨ੍ ਪਾਦਪੀਠੰ ਤੇ ਯਾਵੰਨਹਿ ਕਰੋਮ੍ਯਹੰ| ਤਾਵਤ੍ ਕਾਲੰ ਮਦੀਯੇ ਤ੍ਵੰ ਦਕ੍ਸ਼਼ਪਾਰ੍ਸ਼੍ਵ ਉਪਾਵਿਸ਼| ਅਤੋ ਯਦਿ ਦਾਯੂਦ੍ ਤੰ ਪ੍ਰਭੁੰ ਵਦਤਿ, ਰ੍ਤਿਹ ਸ ਕਥੰ ਤਸ੍ਯ ਸਨ੍ਤਾਨੋ ਭਵਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","ਤਦਾਨੀਂ ਤੇਸ਼਼ਾਂ ਕੋਪਿ ਤਦ੍ਵਾਕ੍ਯਸ੍ਯ ਕਿਮਪ੍ਯੁੱਤਰੰ ਦਾਤੁੰ ਨਾਸ਼ਕ੍ਨੋਤ੍; ");
INSERT INTO sanpun_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ਤੱਦਿਨਮਾਰਭ੍ਯ ਤੰ ਕਿਮਪਿ ਵਾਕ੍ਯੰ ਪ੍ਰਸ਼਼੍ਟੁੰ ਕਸ੍ਯਾਪਿ ਸਾਹਸੋ ਨਾਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","ਅਨਨ੍ਤਰੰ ਯੀਸ਼ੁ ਰ੍ਜਨਨਿਵਹੰ ਸ਼ਿਸ਼਼੍ਯਾਂਸ਼੍ਚਾਵਦਤ੍, ");
INSERT INTO sanpun_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","ਅਧ੍ਯਾਪਕਾਃ ਫਿਰੂਸ਼ਿਨਸ਼੍ਚ ਮੂਸਾਸਨੇ ਉਪਵਿਸ਼ਨ੍ਤਿ, ");
INSERT INTO sanpun_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ਅਤਸ੍ਤੇ ਯੁਸ਼਼੍ਮਾਨ੍ ਯਦ੍ਯਤ੍ ਮਨ੍ਤੁਮ੍ ਆਜ੍ਞਾਪਯਨ੍ਤਿ, ਤਤ੍ ਮਨ੍ਯਧ੍ਵੰ ਪਾਲਯਧ੍ਵਞ੍ਚ, ਕਿਨ੍ਤੁ ਤੇਸ਼਼ਾਂ ਕਰ੍ੰਮਾਨੁਰੂਪੰ ਕਰ੍ੰਮ ਨ ਕੁਰੁਧ੍ਵੰ; ਯਤਸ੍ਤੇਸ਼਼ਾਂ ਵਾਕ੍ਯਮਾਤ੍ਰੰ ਸਾਰੰ ਕਾਰ੍ੱਯੇ ਕਿਮਪਿ ਨਾਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","ਤੇ ਦੁਰ੍ੱਵਹਾਨ੍ ਗੁਰੁਤਰਾਨ੍ ਭਾਰਾਨ੍ ਬਦ੍ੱਵਾ ਮਨੁਸ਼਼੍ਯਾਣਾਂ ਸ੍ਕਨ੍ਧੇਪਰਿ ਸਮਰ੍ਪਯਨ੍ਤਿ, ਕਿਨ੍ਤੁ ਸ੍ਵਯਮਙ੍ਗੁਲ੍ਯੈਕਯਾਪਿ ਨ ਚਾਲਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","ਕੇਵਲੰ ਲੋਕਦਰ੍ਸ਼ਨਾਯ ਸਰ੍ੱਵਕਰ੍ੰਮਾਣਿ ਕੁਰ੍ੱਵਨ੍ਤਿ; ਫਲਤਃ ਪੱਟਬਨ੍ਧਾਨ੍ ਪ੍ਰਸਾਰ੍ੱਯ ਧਾਰਯਨ੍ਤਿ, ਸ੍ਵਵਸ੍ਤ੍ਰੇਸ਼਼ੁ ਚ ਦੀਰ੍ਘਗ੍ਰਨ੍ਥੀਨ੍ ਧਾਰਯਨ੍ਤਿ; ");
INSERT INTO sanpun_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ਭੋਜਨਭਵਨ ਉੱਚਸ੍ਥਾਨੰ, ਭਜਨਭਵਨੇ ਪ੍ਰਧਾਨਮਾਸਨੰ, ");
INSERT INTO sanpun_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ਹੱਠੇ ਨਮਸ੍ਕਾਰੰ ਗੁਰੁਰਿਤਿ ਸਮ੍ਬੋਧਨਞ੍ਚੈਤਾਨਿ ਸਰ੍ੱਵਾਣਿ ਵਾਞ੍ਛਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","ਕਿਨ੍ਤੁ ਯੂਯੰ ਗੁਰਵ ਇਤਿ ਸਮ੍ਬੋਧਨੀਯਾ ਮਾ ਭਵਤ, ਯਤੋ ਯੁਸ਼਼੍ਮਾਕਮ੍ ਏਕਃ ਖ੍ਰੀਸ਼਼੍ਟਏਵ ਗੁਰੁ ");
INSERT INTO sanpun_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ਰ੍ਯੂਯੰ ਸਰ੍ੱਵੇ ਮਿਥੋ ਭ੍ਰਾਤਰਸ਼੍ਚ| ਪੁਨਃ ਪ੍ਰੁʼਥਿਵ੍ਯਾਂ ਕਮਪਿ ਪਿਤੇਤਿ ਮਾ ਸਮ੍ਬੁਧ੍ਯਧ੍ਵੰ, ਯਤੋ ਯੁਸ਼਼੍ਮਾਕਮੇਕਃ ਸ੍ਵਰ੍ਗਸ੍ਥਏਵ ਪਿਤਾ| ");
INSERT INTO sanpun_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ਯੂਯੰ ਨਾਯਕੇਤਿ ਸਮ੍ਭਾਸ਼਼ਿਤਾ ਮਾ ਭਵਤ, ਯਤੋ ਯੁਸ਼਼੍ਮਾਕਮੇਕਃ ਖ੍ਰੀਸ਼਼੍ਟਏਵ ਨਾਯਕਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","ਅਪਰੰ ਯੁਸ਼਼੍ਮਾਕੰ ਮਧ੍ਯੇ ਯਃ ਪੁਮਾਨ੍ ਸ਼੍ਰੇਸ਼਼੍ਠਃ ਸ ਯੁਸ਼਼੍ਮਾਨ੍ ਸੇਵਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ਯਤੋ ਯਃ ਸ੍ਵਮੁੰਨਮਤਿ, ਸ ਨਤਃ ਕਰਿਸ਼਼੍ਯਤੇ; ਕਿਨ੍ਤੁ ਯਃ ਕਸ਼੍ਚਿਤ੍ ਸ੍ਵਮਵਨਤੰ ਕਰੋਤਿ, ਸ ਉੰਨਤਃ ਕਰਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","ਹਨ੍ਤ ਕਪਟਿਨ ਉਪਾਧ੍ਯਾਯਾਃ ਫਿਰੂਸ਼ਿਨਸ਼੍ਚ, ਯੂਯੰ ਮਨੁਜਾਨਾਂ ਸਮਕ੍ਸ਼਼ੰ ਸ੍ਵਰ੍ਗਦ੍ਵਾਰੰ ਰੁਨ੍ਧ, ਯੂਯੰ ਸ੍ਵਯੰ ਤੇਨ ਨ ਪ੍ਰਵਿਸ਼ਥ, ਪ੍ਰਵਿਵਿਕ੍ਸ਼਼ੂਨਪਿ ਵਾਰਯਥ| ਵਤ ਕਪਟਿਨ ਉਪਾਧ੍ਯਾਯਾਃ ਫਿਰੂਸ਼ਿਨਸ਼੍ਚ ਯੂਯੰ ਛਲਾਦ੍ ਦੀਰ੍ਘੰ ਪ੍ਰਾਰ੍ਥ੍ਯ ਵਿਧਵਾਨਾਂ ਸਰ੍ੱਵਸ੍ਵੰ ਗ੍ਰਸਥ, ਯੁਸ਼਼੍ਮਾਕੰ ਘੋਰਤਰਦਣ੍ਡੋ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","ਹਨ੍ਤ ਕਪਟਿਨ ਉਪਾਧ੍ਯਾਯਾਃ ਫਿਰੂਸ਼ਿਨਸ਼੍ਚ, ਯੂਯਮੇਕੰ ਸ੍ਵਧਰ੍ੰਮਾਵਲਮ੍ਬਿਨੰ ਕਰ੍ੱਤੁੰ ਸਾਗਰੰ ਭੂਮਣ੍ਡਲਞ੍ਚ ਪ੍ਰਦਕ੍ਸ਼਼ਿਣੀਕੁਰੁਥ, ");
INSERT INTO sanpun_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","ਕਞ੍ਚਨ ਪ੍ਰਾਪ੍ਯ ਸ੍ਵਤੋ ਦ੍ਵਿਗੁਣਨਰਕਭਾਜਨੰ ਤੰ ਕੁਰੁਥ| ");
INSERT INTO sanpun_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","ਵਤ ਅਨ੍ਧਪਥਦਰ੍ਸ਼ਕਾਃ ਸਰ੍ੱਵੇ, ਯੂਯੰ ਵਦਥ, ਮਨ੍ਦਿਰਸ੍ਯ ਸ਼ਪਥਕਰਣਾਤ੍ ਕਿਮਪਿ ਨ ਦੇਯੰ; ਕਿਨ੍ਤੁ ਮਨ੍ਦਿਰਸ੍ਥਸੁਵਰ੍ਣਸ੍ਯ ਸ਼ਪਥਕਰਣਾਦ੍ ਦੇਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ਹੇ ਮੂਢਾ ਹੇ ਅਨ੍ਧਾਃ ਸੁਵਰ੍ਣੰ ਤਤ੍ਸੁਵਰ੍ਣਪਾਵਕਮਨ੍ਦਿਰਮ੍ ਏਤਯੋਰੁਭਯੋ ਰ੍ਮਧ੍ਯੇ ਕਿੰ ਸ਼੍ਰੇਯਃ? ");
INSERT INTO sanpun_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","ਅਨ੍ਯੱਚ ਵਦਥ, ਯਜ੍ਞਵੇਦ੍ਯਾਃ ਸ਼ਪਥਕਰਣਾਤ੍ ਕਿਮਪਿ ਨ ਦੇਯੰ, ਕਿਨ੍ਤੁ ਤਦੁਪਰਿਸ੍ਥਿਤਸ੍ਯ ਨੈਵੇਦ੍ਯਸ੍ਯ ਸ਼ਪਥਕਰਣਾਦ੍ ਦੇਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ਹੇ ਮੂਢਾ ਹੇ ਅਨ੍ਧਾਃ, ਨੈਵੇਦ੍ਯੰ ਤੰਨੈਵੇਦ੍ਯਪਾਵਕਵੇਦਿਰੇਤਯੋਰੁਭਯੋ ਰ੍ਮਧ੍ਯੇ ਕਿੰ ਸ਼੍ਰੇਯਃ? ");
INSERT INTO sanpun_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ਅਤਃ ਕੇਨਚਿਦ੍ ਯਜ੍ਞਵੇਦ੍ਯਾਃ ਸ਼ਪਥੇ ਕ੍ਰੁʼਤੇ ਤਦੁਪਰਿਸ੍ਥਸ੍ਯ ਸਰ੍ੱਵਸ੍ਯ ਸ਼ਪਥਃ ਕ੍ਰਿਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ਕੇਨਚਿਤ੍ ਮਨ੍ਦਿਰਸ੍ਯ ਸ਼ਪਥੇ ਕ੍ਰੁʼਤੇ ਮਨ੍ਦਿਰਤੰਨਿਵਾਸਿਨੋਃ ਸ਼ਪਥਃ ਕ੍ਰਿਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ਕੇਨਚਿਤ੍ ਸ੍ਵਰ੍ਗਸ੍ਯ ਸ਼ਪਥੇ ਕ੍ਰੁʼਤੇ ਈਸ਼੍ਵਰੀਯਸਿੰਹਾਸਨਤਦੁਪਰ੍ੱਯੁਪਵਿਸ਼਼੍ਟਯੋਃ ਸ਼ਪਥਃ ਕ੍ਰਿਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","ਹਨ੍ਤ ਕਪਟਿਨ ਉਪਾਧ੍ਯਾਯਾਃ ਫਿਰੂਸ਼ਿਨਸ਼੍ਚ, ਯੂਯੰ ਪੋਦਿਨਾਯਾਃ ਸਿਤੱਛਤ੍ਰਾਯਾ ਜੀਰਕਸ੍ਯ ਚ ਦਸ਼ਮਾਂਸ਼ਾਨ੍ ਦੱਥ, ਕਿਨ੍ਤੁ ਵ੍ਯਵਸ੍ਥਾਯਾ ਗੁਰੁਤਰਾਨ੍ ਨ੍ਯਾਯਦਯਾਵਿਸ਼੍ਵਾਸਾਨ੍ ਪਰਿਤ੍ਯਜਥ; ਇਮੇ ਯੁਸ਼਼੍ਮਾਭਿਰਾਚਰਣੀਯਾ ਅਮੀ ਚ ਨ ਲੰਘਨੀਯਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ਹੇ ਅਨ੍ਧਪਥਦਰ੍ਸ਼ਕਾ ਯੂਯੰ ਮਸ਼ਕਾਨ੍ ਅਪਸਾਰਯਥ, ਕਿਨ੍ਤੁ ਮਹਾਙ੍ਗਾਨ੍ ਗ੍ਰਸਥ| ");
INSERT INTO sanpun_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","ਹਨ੍ਤ ਕਪਟਿਨ ਉਪਾਧ੍ਯਾਯਾਃ ਫਿਰੂਸ਼ਿਨਸ਼੍ਚ, ਯੂਯੰ ਪਾਨਪਾਤ੍ਰਾਣਾਂ ਭੋਜਨਪਾਤ੍ਰਾਣਾਞ੍ਚ ਬਹਿਃ ਪਰਿਸ਼਼੍ਕੁਰੁਥ; ਕਿਨ੍ਤੁ ਤਦਭ੍ਯਨ੍ਤਰੰ ਦੁਰਾਤ੍ਮਤਯਾ ਕਲੁਸ਼਼ੇਣ ਚ ਪਰਿਪੂਰ੍ਣਮਾਸ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ਹੇ ਅਨ੍ਧਾਃ ਫਿਰੂਸ਼ਿਲੋਕਾ ਆਦੌ ਪਾਨਪਾਤ੍ਰਾਣਾਂ ਭੋਜਨਪਾਤ੍ਰਾਣਾਞ੍ਚਾਭ੍ਯਨ੍ਤਰੰ ਪਰਿਸ਼਼੍ਕੁਰੁਤ, ਤੇਨ ਤੇਸ਼਼ਾਂ ਬਹਿਰਪਿ ਪਰਿਸ਼਼੍ਕਾਰਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","ਹਨ੍ਤ ਕਪਟਿਨ ਉਪਾਧ੍ਯਾਯਾਃ ਫਿਰੂਸ਼ਿਨਸ਼੍ਚ, ਯੂਯੰ ਸ਼ੁਕ੍ਲੀਕ੍ਰੁʼਤਸ਼੍ਮਸ਼ਾਨਸ੍ਵਰੂਪਾ ਭਵਥ, ਯਥਾ ਸ਼੍ਮਸ਼ਾਨਭਵਨਸ੍ਯ ਬਹਿਸ਼੍ਚਾਰੁ, ਕਿਨ੍ਤ੍ਵਭ੍ਯਨ੍ਤਰੰ ਮ੍ਰੁʼਤਲੋਕਾਨਾਂ ਕੀਕਸ਼ੈਃ ਸਰ੍ੱਵਪ੍ਰਕਾਰਮਲੇਨ ਚ ਪਰਿਪੂਰ੍ਣਮ੍; ");
INSERT INTO sanpun_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","ਤਥੈਵ ਯੂਯਮਪਿ ਲੋਕਾਨਾਂ ਸਮਕ੍ਸ਼਼ੰ ਬਹਿਰ੍ਧਾਰ੍ੰਮਿਕਾਃ ਕਿਨ੍ਤ੍ਵਨ੍ਤਃਕਰਣੇਸ਼਼ੁ ਕੇਵਲਕਾਪਟ੍ਯਾਧਰ੍ੰਮਾਭ੍ਯਾਂ ਪਰਿਪੂਰ੍ਣਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","ਹਾ ਹਾ ਕਪਟਿਨ ਉਪਾਧ੍ਯਾਯਾਃ ਫਿਰੂਸ਼ਿਨਸ਼੍ਚ, ਯੂਯੰ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਾਂ ਸ਼੍ਮਸ਼ਾਨਗੇਹੰ ਨਿਰ੍ੰਮਾਥ, ਸਾਧੂਨਾਂ ਸ਼੍ਮਸ਼ਾਨਨਿਕੇਤਨੰ ਸ਼ੋਭਯਥ ");
INSERT INTO sanpun_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ਵਦਥ ਚ ਯਦਿ ਵਯੰ ਸ੍ਵੇਸ਼਼ਾਂ ਪੂਰ੍ੱਵਪੁਰੁਸ਼਼ਾਣਾਂ ਕਾਲ ਅਸ੍ਥਾਸ੍ਯਾਮ, ਤਰ੍ਹਿ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਾਂ ਸ਼ੋਣਿਤਪਾਤਨੇ ਤੇਸ਼਼ਾਂ ਸਹਭਾਗਿਨੋ ਨਾਭਵਿਸ਼਼੍ਯਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ਅਤੋ ਯੂਯੰ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਘਾਤਕਾਨਾਂ ਸਨ੍ਤਾਨਾ ਇਤਿ ਸ੍ਵਯਮੇਵ ਸ੍ਵੇਸ਼਼ਾਂ ਸਾਕ੍ਸ਼਼੍ਯੰ ਦੱਥ| ");
INSERT INTO sanpun_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","ਅਤੋ ਯੂਯੰ ਨਿਜਪੂਰ੍ੱਵਪੁਰੁਸ਼਼ਾਣਾਂ ਪਰਿਮਾਣਪਾਤ੍ਰੰ ਪਰਿਪੂਰਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","ਰੇ ਭੁਜਗਾਃ ਕ੍ਰੁʼਸ਼਼੍ਣਭੁਜਗਵੰਸ਼ਾਃ, ਯੂਯੰ ਕਥੰ ਨਰਕਦਣ੍ਡਾਦ੍ ਰਕ੍ਸ਼਼ਿਸ਼਼੍ਯਧ੍ਵੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","ਪਸ਼੍ਯਤ, ਯੁਸ਼਼੍ਮਾਕਮਨ੍ਤਿਕਮ੍ ਅਹੰ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨੋ ਬੁੱਧਿਮਤ ਉਪਾਧ੍ਯਾਯਾਂਸ਼੍ਚ ਪ੍ਰੇਸ਼਼ਯਿਸ਼਼੍ਯਾਮਿ, ਕਿਨ੍ਤੁ ਤੇਸ਼਼ਾਂ ਕਤਿਪਯਾ ਯੁਸ਼਼੍ਮਾਭਿ ਰ੍ਘਾਨਿਸ਼਼੍ਯਨ੍ਤੇ, ਕ੍ਰੁਸ਼ੇ ਚ ਘਾਨਿਸ਼਼੍ਯਨ੍ਤੇ, ਕੇਚਿਦ੍ ਭਜਨਭਵਨੇ ਕਸ਼਼ਾਭਿਰਾਘਾਨਿਸ਼਼੍ਯਨ੍ਤੇ, ਨਗਰੇ ਨਗਰੇ ਤਾਡਿਸ਼਼੍ਯਨ੍ਤੇ ਚ; ");
INSERT INTO sanpun_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","ਤੇਨ ਸਤ੍ਪੁਰੁਸ਼਼ਸ੍ਯ ਹਾਬਿਲੋ ਰਕ੍ਤਪਾਤਮਾਰਭ੍ਯ ਬੇਰਿਖਿਯਃ ਪੁਤ੍ਰੰ ਯੰ ਸਿਖਰਿਯੰ ਯੂਯੰ ਮਨ੍ਦਿਰਯਜ੍ਞਵੇਦ੍ਯੋ ਰ੍ਮਧ੍ਯੇ ਹਤਵਨ੍ਤਃ, ਤਦੀਯਸ਼ੋਣਿਤਪਾਤੰ ਯਾਵਦ੍ ਅਸ੍ਮਿਨ੍ ਦੇਸ਼ੇ ਯਾਵਤਾਂ ਸਾਧੁਪੁਰੁਸ਼਼ਾਣਾਂ ਸ਼ੋਣਿਤਪਾਤੋ (ਅ)ਭਵਤ੍ ਤਤ੍ ਸਰ੍ੱਵੇਸ਼਼ਾਮਾਗਸਾਂ ਦਣ੍ਡਾ ਯੁਸ਼਼੍ਮਾਸੁ ਵਰ੍ੱਤਿਸ਼਼੍ਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ਅਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ਤ ਤਥ੍ਯੰ ਵਦਾਮਿ, ਵਿਦ੍ਯਮਾਨੇ(ਅ)ਸ੍ਮਿਨ੍ ਪੁਰੁਸ਼਼ੇ ਸਰ੍ੱਵੇ ਵਰ੍ੱਤਿਸ਼਼੍ਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","ਹੇ ਯਿਰੂਸ਼ਾਲਮ੍ ਹੇ ਯਿਰੂਸ਼ਾਲਮ੍ ਨਗਰਿ ਤ੍ਵੰ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨੋ ਹਤਵਤੀ, ਤਵ ਸਮੀਪੰ ਪ੍ਰੇਰਿਤਾਂਸ਼੍ਚ ਪਾਸ਼਼ਾਣੈਰਾਹਤਵਤੀ, ਯਥਾ ਕੁੱਕੁਟੀ ਸ਼ਾਵਕਾਨ੍ ਪਕ੍ਸ਼਼ਾਧਃ ਸੰਗ੍ਰੁʼਹ੍ਲਾਤਿ, ਤਥਾ ਤਵ ਸਨ੍ਤਾਨਾਨ੍ ਸੰਗ੍ਰਹੀਤੁੰ ਅਹੰ ਬਹੁਵਾਰਮ੍ ਐੱਛੰ; ਕਿਨ੍ਤੁ ਤ੍ਵੰ ਨ ਸਮਮਨ੍ਯਥਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ਪਸ਼੍ਯਤ ਯਸ਼਼੍ਮਾਕੰ ਵਾਸਸ੍ਥਾਨਮ੍ ਉੱਛਿੰਨੰ ਤ੍ਯਕ੍ਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ਅਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਤਥ੍ਯੰ ਵਦਾਮਿ, ਯਃ ਪਰਮੇਸ਼੍ਵਰਸ੍ਯ ਨਾਮ੍ਨਾਗੱਛਤਿ, ਸ ਧਨ੍ਯ ਇਤਿ ਵਾਣੀਂ ਯਾਵੰਨ ਵਦਿਸ਼਼੍ਯਥ, ਤਾਵਤ੍ ਮਾਂ ਪੁਨ ਰ੍ਨ ਦ੍ਰਕ੍ਸ਼਼੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","ਅਨਨ੍ਤਰੰ ਯੀਸ਼ੁ ਰ੍ਯਦਾ ਮਨ੍ਦਿਰਾਦ੍ ਬਹਿ ਰ੍ਗੱਛਤਿ, ਤਦਾਨੀਂ ਸ਼ਿਸ਼਼੍ਯਾਸ੍ਤੰ ਮਨ੍ਦਿਰਨਿਰ੍ੰਮਾਣੰ ਦਰ੍ਸ਼ਯਿਤੁਮਾਗਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ਤਤੋ ਯੀਸ਼ੁਸ੍ਤਾਨੁਵਾਚ, ਯੂਯੰ ਕਿਮੇਤਾਨਿ ਨ ਪਸ਼੍ਯਥ? ਯੁਸ਼਼੍ਮਾਨਹੰ ਸਤ੍ਯੰ ਵਦਾਮਿ, ਏਤੰਨਿਚਯਨਸ੍ਯ ਪਾਸ਼਼ਾਣੈਕਮਪ੍ਯਨ੍ਯਪਾਸ਼਼ਾਣੇाਪਰਿ ਨ ਸ੍ਥਾਸ੍ਯਤਿ ਸਰ੍ੱਵਾਣਿ ਭੂਮਿਸਾਤ੍ ਕਾਰਿਸ਼਼੍ਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","ਅਨਨ੍ਤਰੰ ਤਸ੍ਮਿਨ੍ ਜੈਤੁਨਪਰ੍ੱਵਤੋਪਰਿ ਸਮੁਪਵਿਸ਼਼੍ਟੇ ਸ਼ਿਸ਼਼੍ਯਾਸ੍ਤਸ੍ਯ ਸਮੀਪਮਾਗਤ੍ਯ ਗੁਪ੍ਤੰ ਪਪ੍ਰੱਛੁਃ, ਏਤਾ ਘਟਨਾਃ ਕਦਾ ਭਵਿਸ਼਼੍ਯਨ੍ਤਿ? ਭਵਤ ਆਗਮਨਸ੍ਯ ਯੁਗਾਨ੍ਤਸ੍ਯ ਚ ਕਿੰ ਲਕ੍ਸ਼਼੍ਮ? ਤਦਸ੍ਮਾਨ੍ ਵਦਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ਤਦਾਨੀਂ ਯੀਸ਼ੁਸ੍ਤਾਨਵੋਚਤ੍, ਅਵਧਦ੍ੱਵੰ, ਕੋਪਿ ਯੁਸ਼਼੍ਮਾਨ੍ ਨ ਭ੍ਰਮਯੇਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ਬਹਵੋ ਮਮ ਨਾਮ ਗ੍ਰੁʼਹ੍ਲਨ੍ਤ ਆਗਮਿਸ਼਼੍ਯਨ੍ਤਿ, ਖ੍ਰੀਸ਼਼੍ਟੋ(ਅ)ਹਮੇਵੇਤਿ ਵਾਚੰ ਵਦਨ੍ਤੋ ਬਹੂਨ੍ ਭ੍ਰਮਯਿਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","ਯੂਯਞ੍ਚ ਸੰਗ੍ਰਾਮਸ੍ਯ ਰਣਸ੍ਯ ਚਾਡਮ੍ਬਰੰ ਸ਼੍ਰੋਸ਼਼੍ਯਥ, ਅਵਧਦ੍ੱਵੰ ਤੇਨ ਚਞ੍ਚਲਾ ਮਾ ਭਵਤ, ਏਤਾਨ੍ਯਵਸ਼੍ਯੰ ਘਟਿਸ਼਼੍ਯਨ੍ਤੇ, ਕਿਨ੍ਤੁ ਤਦਾ ਯੁਗਾਨ੍ਤੋ ਨਹਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","ਅਪਰੰ ਦੇਸ਼ਸ੍ਯ ਵਿਪਕ੍ਸ਼਼ੋ ਦੇਸ਼ੋ ਰਾਜ੍ਯਸ੍ਯ ਵਿਪਕ੍ਸ਼਼ੋ ਰਾਜ੍ਯੰ ਭਵਿਸ਼਼੍ਯਤਿ, ਸ੍ਥਾਨੇ ਸ੍ਥਾਨੇ ਚ ਦੁਰ੍ਭਿਕ੍ਸ਼਼ੰ ਮਹਾਮਾਰੀ ਭੂਕਮ੍ਪਸ਼੍ਚ ਭਵਿਸ਼਼੍ਯਨ੍ਤਿ, ");
INSERT INTO sanpun_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ਏਤਾਨਿ ਦੁਃਖੋਪਕ੍ਰਮਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","ਤਦਾਨੀਂ ਲੋਕਾ ਦੁਃਖੰ ਭੋਜਯਿਤੁੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਪਰਕਰੇਸ਼਼ੁ ਸਮਰ੍ਪਯਿਸ਼਼੍ਯਨ੍ਤਿ ਹਨਿਸ਼਼੍ਯਨ੍ਤਿ ਚ, ਤਥਾ ਮਮ ਨਾਮਕਾਰਣਾਦ੍ ਯੂਯੰ ਸਰ੍ੱਵਦੇਸ਼ੀਯਮਨੁਜਾਨਾਂ ਸਮੀਪੇ ਘ੍ਰੁʼਣਾਰ੍ਹਾ ਭਵਿਸ਼਼੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","ਬਹੁਸ਼਼ੁ ਵਿਘ੍ਨੰ ਪ੍ਰਾਪ੍ਤਵਤ੍ਸੁ ਪਰਸ੍ਪਰਮ੍ ਰੁʼृਤੀਯਾਂ ਕ੍ਰੁʼਤਵਤ੍ਸੁ ਚ ਏਕੋ(ਅ)ਪਰੰ ਪਰਕਰੇਸ਼਼ੁ ਸਮਰ੍ਪਯਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ਤਥਾ ਬਹਵੋ ਮ੍ਰੁʼਸ਼਼ਾਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨ ਉਪਸ੍ਥਾਯ ਬਹੂਨ੍ ਭ੍ਰਮਯਿਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","ਦੁਸ਼਼੍ਕਰ੍ੰਮਣਾਂ ਬਾਹੁਲ੍ਯਾਞ੍ਚ ਬਹੂਨਾਂ ਪ੍ਰੇਮ ਸ਼ੀਤਲੰ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","ਕਿਨ੍ਤੁ ਯਃ ਕਸ਼੍ਚਿਤ੍ ਸ਼ੇਸ਼਼ੰ ਯਾਵਦ੍ ਧੈਰ੍ੱਯਮਾਸ਼੍ਰਯਤੇ, ਸਏਵ ਪਰਿਤ੍ਰਾਯਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","ਅਪਰੰ ਸਰ੍ੱਵਦੇਸ਼ੀਯਲੋਕਾਨ੍ ਪ੍ਰਤਿਮਾਕ੍ਸ਼਼ੀ ਭਵਿਤੁੰ ਰਾਜਸ੍ਯ ਸ਼ੁਭਸਮਾਚਾਰਃ ਸਰ੍ੱਵਜਗਤਿ ਪ੍ਰਚਾਰਿਸ਼਼੍ਯਤੇ, ਏਤਾਦ੍ਰੁʼਸ਼ਿ ਸਤਿ ਯੁਗਾਨ੍ਤ ਉਪਸ੍ਥਾਸ੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","ਅਤੋ ਯਤ੍ ਸਰ੍ੱਵਨਾਸ਼ਕ੍ਰੁʼਦ੍ਘ੍ਰੁʼਣਾਰ੍ਹੰ ਵਸ੍ਤੁ ਦਾਨਿਯੇਲ੍ਭਵਿਸ਼਼੍ਯਦ੍ਵਦਿਨਾ ਪ੍ਰੋਕ੍ਤੰ ਤਦ੍ ਯਦਾ ਪੁਣ੍ਯਸ੍ਥਾਨੇ ਸ੍ਥਾਪਿਤੰ ਦ੍ਰਕ੍ਸ਼਼੍ਯਥ, (ਯਃ ਪਠਤਿ, ਸ ਬੁਧ੍ਯਤਾਂ) ");
INSERT INTO sanpun_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ਤਦਾਨੀਂ ਯੇ ਯਿਹੂਦੀਯਦੇਸ਼ੇ ਤਿਸ਼਼੍ਠਨ੍ਤਿ, ਤੇ ਪਰ੍ੱਵਤੇਸ਼਼ੁ ਪਲਾਯਨ੍ਤਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ਯਃ ਕਸ਼੍ਚਿਦ੍ ਗ੍ਰੁʼਹਪ੍ਰੁʼਸ਼਼੍ਠੇ ਤਿਸ਼਼੍ਠਤਿ, ਸ ਗ੍ਰੁʼਹਾਤ੍ ਕਿਮਪਿ ਵਸ੍ਤ੍ਵਾਨੇਤੁਮ੍ ਅਧੇा ਨਾਵਰੋਹੇਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ਯਸ਼੍ਚ ਕ੍ਸ਼਼ੇਤ੍ਰੇ ਤਿਸ਼਼੍ਠਤਿ, ਸੋਪਿ ਵਸ੍ਤ੍ਰਮਾਨੇਤੁੰ ਪਰਾਵ੍ਰੁʼਤ੍ਯ ਨ ਯਾਯਾਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","ਤਦਾਨੀਂ ਗਰ੍ਭਿਣੀਸ੍ਤਨ੍ਯਪਾਯਯਿਤ੍ਰੀਣਾਂ ਦੁਰ੍ਗਤਿ ਰ੍ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ਅਤੋ ਯਸ਼਼੍ਮਾਕੰ ਪਲਾਯਨੰ ਸ਼ੀਤਕਾਲੇ ਵਿਸ਼੍ਰਾਮਵਾਰੇ ਵਾ ਯੰਨ ਭਵੇਤ੍, ਤਦਰ੍ਥੰ ਪ੍ਰਾਰ੍ਥਯਧ੍ਵਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ਆ ਜਗਦਾਰਮ੍ਭਾਦ੍ ਏਤਤ੍ਕਾਲਪਰ੍ੱਯਨਨ੍ਤੰ ਯਾਦ੍ਰੁʼਸ਼ਃ ਕਦਾਪਿ ਨਾਭਵਤ੍ ਨ ਚ ਭਵਿਸ਼਼੍ਯਤਿ ਤਾਦ੍ਰੁʼਸ਼ੋ ਮਹਾਕ੍ਲੇਸ਼ਸ੍ਤਦਾਨੀਮ੍ ਉਪਸ੍ਥਾਸ੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","ਤਸ੍ਯ ਕ੍ਲੇਸ਼ਸ੍ਯ ਸਮਯੋ ਯਦਿ ਹ੍ਸ੍ਵੋ ਨ ਕ੍ਰਿਯੇਤ, ਤਰ੍ਹਿ ਕਸ੍ਯਾਪਿ ਪ੍ਰਾਣਿਨੋ ਰਕ੍ਸ਼਼ਣੰ ਭਵਿਤੁੰ ਨ ਸ਼ਕ੍ਨੁਯਾਤ੍, ਕਿਨ੍ਤੁ ਮਨੋਨੀਤਮਨੁਜਾਨਾਂ ਕ੍ਰੁʼਤੇ ਸ ਕਾਲੋ ਹ੍ਸ੍ਵੀਕਰਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","ਅਪਰਞ੍ਚ ਪਸ਼੍ਯਤ, ਖ੍ਰੀਸ਼਼੍ਟੋ(ਅ)ਤ੍ਰ ਵਿਦ੍ਯਤੇ, ਵਾ ਤਤ੍ਰ ਵਿਦ੍ਯਤੇ, ਤਦਾਨੀਂ ਯਦੀ ਕਸ਼੍ਚਿਦ੍ ਯੁਸ਼਼੍ਮਾਨ ਇਤਿ ਵਾਕ੍ਯੰ ਵਦਤਿ, ਤਥਾਪਿ ਤਤ੍ ਨ ਪ੍ਰਤੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","ਯਤੋ ਭਾਕ੍ਤਖ੍ਰੀਸ਼਼੍ਟਾ ਭਾਕ੍ਤਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਸ਼੍ਚ ਉਪਸ੍ਥਾਯ ਯਾਨਿ ਮਹਨ੍ਤਿ ਲਕ੍ਸ਼਼੍ਮਾਣਿ ਚਿਤ੍ਰਕਰ੍ੰਮਾਣਿ ਚ ਪ੍ਰਕਾਸ਼ਯਿਸ਼਼੍ਯਨ੍ਤਿ, ਤੈ ਰ੍ਯਦਿ ਸਮ੍ਭਵੇਤ੍ ਤਰ੍ਹਿ ਮਨੋਨੀਤਮਾਨਵਾ ਅਪਿ ਭ੍ਰਾਮਿਸ਼਼੍ਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","ਪਸ਼੍ਯਤ, ਘਟਨਾਤਃ ਪੂਰ੍ੱਵੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਵਾਰ੍ੱਤਾਮ੍ ਅਵਾਦਿਸ਼਼ਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","ਅਤਃ ਪਸ਼੍ਯਤ, ਸ ਪ੍ਰਾਨ੍ਤਰੇ ਵਿਦ੍ਯਤ ਇਤਿ ਵਾਕ੍ਯੇ ਕੇਨਚਿਤ੍ ਕਥਿਤੇਪਿ ਬਹਿ ਰ੍ਮਾ ਗੱਛਤ, ਵਾ ਪਸ਼੍ਯਤ, ਸੋਨ੍ਤਃਪੁਰੇ ਵਿਦ੍ਯਤੇ, ਏਤਦ੍ਵਾਕ੍ਯ ਉਕ੍ਤੇਪਿ ਮਾ ਪ੍ਰਤੀਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","ਯਤੋ ਯਥਾ ਵਿਦ੍ਯੁਤ੍ ਪੂਰ੍ੱਵਦਿਸ਼ੋ ਨਿਰ੍ਗਤ੍ਯ ਪਸ਼੍ਚਿਮਦਿਸ਼ੰ ਯਾਵਤ੍ ਪ੍ਰਕਾਸ਼ਤੇ, ਤਥਾ ਮਾਨੁਸ਼਼ਪੁਤ੍ਰਸ੍ਯਾਪ੍ਯਾਗਮਨੰ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","ਯਤ੍ਰ ਸ਼ਵਸ੍ਤਿਸ਼਼੍ਠਤਿ, ਤਤ੍ਰੇਵ ਗ੍ਰੁʼਧ੍ਰਾ ਮਿਲਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","ਅਪਰੰ ਤਸ੍ਯ ਕ੍ਲੇਸ਼ਸਮਯਸ੍ਯਾਵ੍ਯਵਹਿਤਪਰਤ੍ਰ ਸੂਰ੍ੱਯਸ੍ਯ ਤੇਜੋ ਲੋਪ੍ਸ੍ਯਤੇ, ਚਨ੍ਦ੍ਰਮਾ ਜ੍ਯੋਸ੍ਨਾਂ ਨ ਕਰਿਸ਼਼੍ਯਤਿ, ਨਭਸੋ ਨਕ੍ਸ਼਼ਤ੍ਰਾਣਿ ਪਤਿਸ਼਼੍ਯਨ੍ਤਿ, ਗਗਣੀਯਾ ਗ੍ਰਹਾਸ਼੍ਚ ਵਿਚਲਿਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","ਤਦਾਨੀਮ੍ ਆਕਾਸ਼ਮਧ੍ਯੇ ਮਨੁਜਸੁਤਸ੍ਯ ਲਕ੍ਸ਼਼੍ਮ ਦਰ੍ਸ਼ਿਸ਼਼੍ਯਤੇ, ਤਤੋ ਨਿਜਪਰਾਕ੍ਰਮੇਣ ਮਹਾਤੇਜਸਾ ਚ ਮੇਘਾਰੂਢੰ ਮਨੁਜਸੁਤੰ ਨਭਸਾਗੱਛਨ੍ਤੰ ਵਿਲੋਕ੍ਯ ਪ੍ਰੁʼਥਿਵ੍ਯਾਃ ਸਰ੍ੱਵਵੰਸ਼ੀਯਾ ਵਿਲਪਿਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ਤਦਾਨੀਂ ਸ ਮਹਾਸ਼ਬ੍ਦਾਯਮਾਨਤੂਰ੍ੱਯਾ ਵਾਦਕਾਨ੍ ਨਿਜਦੂਤਾਨ੍ ਪ੍ਰਹੇਸ਼਼੍ਯਤਿ, ਤੇ ਵ੍ਯੋਮ੍ਨ ਏਕਸੀਮਾਤੋ(ਅ)ਪਰਸੀਮਾਂ ਯਾਵਤ੍ ਚਤੁਰ੍ਦਿਸ਼ਸ੍ਤਸ੍ਯ ਮਨੋਨੀਤਜਨਾਨ੍ ਆਨੀਯ ਮੇਲਯਿਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","ਉਡੁਮ੍ਬਰਪਾਦਪਸ੍ਯ ਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤੰ ਸ਼ਿਕ੍ਸ਼਼ਧ੍ਵੰ; ਯਦਾ ਤਸ੍ਯ ਨਵੀਨਾਃ ਸ਼ਾਖਾ ਜਾਯਨ੍ਤੇ, ਪੱਲਵਾਦਿਸ਼੍ਚ ਨਿਰ੍ਗੱਛਤਿ, ਤਦਾ ਨਿਦਾਘਕਾਲਃ ਸਵਿਧੋ ਭਵਤੀਤਿ ਯੂਯੰ ਜਾਨੀਥ; ");
INSERT INTO sanpun_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ਤਦ੍ਵਦ੍ ਏਤਾ ਘਟਨਾ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਸ ਸਮਯੋ ਦ੍ਵਾਰ ਉਪਾਸ੍ਥਾਦ੍ ਇਤਿ ਜਾਨੀਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","ਯੁਸ਼਼੍ਮਾਨਹੰ ਤਥ੍ਯੰ ਵਦਾਮਿ, ਇਦਾਨੀਨ੍ਤਨਜਨਾਨਾਂ ਗਮਨਾਤ੍ ਪੂਰ੍ੱਵਮੇਵ ਤਾਨਿ ਸਰ੍ੱਵਾਣਿ ਘਟਿਸ਼਼੍ਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ਨਭੋਮੇਦਿਨ੍ਯੋ ਰ੍ਲੁਪ੍ਤਯੋਰਪਿ ਮਮ ਵਾਕ੍ ਕਦਾਪਿ ਨ ਲੋਪ੍ਸ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","ਅਪਰੰ ਮਮ ਤਾਤੰ ਵਿਨਾ ਮਾਨੁਸ਼਼ਃ ਸ੍ਵਰ੍ਗਸ੍ਥੋ ਦੂਤੋ ਵਾ ਕੋਪਿ ਤੱਦਿਨੰ ਤੱਦਣ੍ਡਞ੍ਚ ਨ ਜ੍ਞਾਪਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","ਅਪਰੰ ਨੋਹੇ ਵਿਦ੍ਯਮਾਨੇ ਯਾਦ੍ਰੁʼਸ਼ਮਭਵਤ੍ ਤਾਦ੍ਰੁʼਸ਼ੰ ਮਨੁਜਸੁਤਸ੍ਯਾਗਮਨਕਾਲੇਪਿ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ਫਲਤੋ ਜਲਾਪ੍ਲਾਵਨਾਤ੍ ਪੂਰ੍ੱਵੰ ਯੱਦਿਨੰ ਯਾਵਤ੍ ਨੋਹਃ ਪੋਤੰ ਨਾਰੋਹਤ੍, ਤਾਵਤ੍ਕਾਲੰ ਯਥਾ ਮਨੁਸ਼਼੍ਯਾ ਭੋਜਨੇ ਪਾਨੇ ਵਿਵਹਨੇ ਵਿਵਾਹਨੇ ਚ ਪ੍ਰਵ੍ਰੁʼੱਤਾ ਆਸਨ੍; ");
INSERT INTO sanpun_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ਅਪਰਮ੍ ਆਪ੍ਲਾਵਿਤੋਯਮਾਗਤ੍ਯ ਯਾਵਤ੍ ਸਕਲਮਨੁਜਾਨ੍ ਪ੍ਲਾਵਯਿਤ੍ਵਾ ਨਾਨਯਤ੍, ਤਾਵਤ੍ ਤੇ ਯਥਾ ਨ ਵਿਦਾਮਾਸੁਃ, ਤਥਾ ਮਨੁਜਸੁਤਾਗਮਨੇਪਿ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","ਤਦਾ ਕ੍ਸ਼਼ੇਤ੍ਰਸ੍ਥਿਤਯੋਰ੍ਦ੍ਵਯੋਰੇਕੋ ਧਾਰਿਸ਼਼੍ਯਤੇ, ਅਪਰਸ੍ਤ੍ਯਾਜਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ਤਥਾ ਪੇਸ਼਼ਣ੍ਯਾ ਪਿੰਸ਼਼ਤ੍ਯੋਰੁਭਯੋ ਰ੍ਯੋਸ਼਼ਿਤੋਰੇਕਾ ਧਾਰਿਸ਼਼੍ਯਤੇ(ਅ)ਪਰਾ ਤ੍ਯਾਜਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","ਯੁਸ਼਼੍ਮਾਕੰ ਪ੍ਰਭੁਃ ਕਸ੍ਮਿਨ੍ ਦਣ੍ਡ ਆਗਮਿਸ਼਼੍ਯਤਿ, ਤਦ੍ ਯੁਸ਼਼੍ਮਾਭਿ ਰ੍ਨਾਵਗਮ੍ਯਤੇ, ਤਸ੍ਮਾਤ੍ ਜਾਗ੍ਰਤਃ ਸਨ੍ਤਸ੍ਤਿਸ਼਼੍ਠਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","ਕੁਤ੍ਰ ਯਾਮੇ ਸ੍ਤੇਨ ਆਗਮਿਸ਼਼੍ਯਤੀਤਿ ਚੇਦ੍ ਗ੍ਰੁʼਹਸ੍ਥੋ ਜ੍ਞਾਤੁਮ੍ ਅਸ਼ਕ੍ਸ਼਼੍ਯਤ੍, ਤਰ੍ਹਿ ਜਾਗਰਿਤ੍ਵਾ ਤੰ ਸਨ੍ਧਿੰ ਕਰ੍ੱਤਿਤੁਮ੍ ਅਵਾਰਯਿਸ਼਼੍ਯਤ੍ ਤਦ੍ ਜਾਨੀਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","ਯੁਸ਼਼੍ਮਾਭਿਰਵਧੀਯਤਾਂ, ਯਤੋ ਯੁਸ਼਼੍ਮਾਭਿ ਰ੍ਯਤ੍ਰ ਨ ਬੁਧ੍ਯਤੇ, ਤਤ੍ਰੈਵ ਦਣ੍ਡੇ ਮਨੁਜਸੁਤ ਆਯਾਸ੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","ਪ੍ਰਭੁ ਰ੍ਨਿਜਪਰਿਵਾਰਾਨ੍ ਯਥਾਕਾਲੰ ਭੋਜਯਿਤੁੰ ਯੰ ਦਾਸਮ੍ ਅਧ੍ਯਕ੍ਸ਼਼ੀਕ੍ਰੁʼਤ੍ਯ ਸ੍ਥਾਪਯਤਿ, ਤਾਦ੍ਰੁʼਸ਼ੋ ਵਿਸ਼੍ਵਾਸ੍ਯੋ ਧੀਮਾਨ੍ ਦਾਸਃ ਕਃ? ");
INSERT INTO sanpun_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ਪ੍ਰਭੁਰਾਗਤ੍ਯ ਯੰ ਦਾਸੰ ਤਥਾਚਰਨ੍ਤੰ ਵੀਕ੍ਸ਼਼ਤੇ, ਸਏਵ ਧਨ੍ਯਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","ਯੁਸ਼਼੍ਮਾਨਹੰ ਸਤ੍ਯੰ ਵਦਾਮਿ, ਸ ਤੰ ਨਿਜਸਰ੍ੱਵਸ੍ਵਸ੍ਯਾਧਿਪੰ ਕਰਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","ਕਿਨ੍ਤੁ ਪ੍ਰਭੁਰਾਗਨ੍ਤੁੰ ਵਿਲਮ੍ਬਤ ਇਤਿ ਮਨਸਿ ਚਿਨ੍ਤਯਿਤ੍ਵਾ ਯੋ ਦੁਸ਼਼੍ਟੋ ਦਾਸੋ ");
INSERT INTO sanpun_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","(ਅ)ਪਰਦਾਸਾਨ੍ ਪ੍ਰਹਰ੍ੱਤੁੰ ਮੱਤਾਨਾਂ ਸਙ੍ਗੇ ਭੋਕ੍ਤੁੰ ਪਾਤੁਞ੍ਚ ਪ੍ਰਵਰ੍ੱਤਤੇ, ");
INSERT INTO sanpun_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ਸ ਦਾਸੋ ਯਦਾ ਨਾਪੇਕ੍ਸ਼਼ਤੇ, ਯਞ੍ਚ ਦਣ੍ਡੰ ਨ ਜਾਨਾਤਿ, ਤਤ੍ਕਾਲਏਵ ਤਤ੍ਪ੍ਰਭੁਰੁਪਸ੍ਥਾਸ੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ਤਦਾ ਤੰ ਦਣ੍ਡਯਿਤ੍ਵਾ ਯਤ੍ਰ ਸ੍ਥਾਨੇ ਰੋਦਨੰ ਦਨ੍ਤਘਰ੍ਸ਼਼ਣਞ੍ਚਾਸਾਤੇ, ਤਤ੍ਰ ਕਪਟਿਭਿਃ ਸਾਕੰ ਤੱਦਸ਼ਾਂ ਨਿਰੂਪਯਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","ਯਾ ਦਸ਼ ਕਨ੍ਯਾਃ ਪ੍ਰਦੀਪਾਨ੍ ਗ੍ਰੁʼਹ੍ਲਤ੍ਯੋ ਵਰੰ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਕਰ੍ੱਤੁੰ ਬਹਿਰਿਤਾਃ, ਤਾਭਿਸ੍ਤਦਾ ਸ੍ਵਰ੍ਗੀਯਰਾਜ੍ਯਸ੍ਯ ਸਾਦ੍ਰੁʼਸ਼੍ਯੰ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ਤਾਸਾਂ ਕਨ੍ਯਾਨਾਂ ਮਧ੍ਯੇ ਪਞ੍ਚ ਸੁਧਿਯਃ ਪਞ੍ਚ ਦੁਰ੍ਧਿਯ ਆਸਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ਯਾ ਦੁਰ੍ਧਿਯਸ੍ਤਾਃ ਪ੍ਰਦੀਪਾਨ੍ ਸਙ੍ਗੇ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਤੈਲੰ ਨ ਜਗ੍ਰੁʼਹੁਃ, ");
INSERT INTO sanpun_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ਕਿਨ੍ਤੁ ਸੁਧਿਯਃ ਪ੍ਰਦੀਪਾਨ੍ ਪਾਤ੍ਰੇਣ ਤੈਲਞ੍ਚ ਜਗ੍ਰੁʼਹੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","ਅਨਨ੍ਤਰੰ ਵਰੇ ਵਿਲਮ੍ਬਿਤੇ ਤਾਃ ਸਰ੍ੱਵਾ ਨਿਦ੍ਰਾਵਿਸ਼਼੍ਟਾ ਨਿਦ੍ਰਾਂ ਜਗ੍ਮੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","ਅਨਨ੍ਤਰਮ੍ ਅਰ੍ੱਧਰਾਤ੍ਰੇ ਪਸ਼੍ਯਤ ਵਰ ਆਗੱਛਤਿ, ਤੰ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਕਰ੍ੱਤੁੰ ਬਹਿਰ੍ਯਾਤੇਤਿ ਜਨਰਵਾਤ੍ ");
INSERT INTO sanpun_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","ਤਾਃ ਸਰ੍ੱਵਾਃ ਕਨ੍ਯਾ ਉੱਥਾਯ ਪ੍ਰਦੀਪਾਨ੍ ਆਸਾਦਯਿਤੁੰ ਆਰਭਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ਤਤੋ ਦੁਰ੍ਧਿਯਃ ਸੁਧਿਯ ਊਚੁਃ, ਕਿਞ੍ਚਿਤ੍ ਤੈਲੰ ਦੱਤ, ਪ੍ਰਦੀਪਾ ਅਸ੍ਮਾਕੰ ਨਿਰ੍ੱਵਾਣਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","ਕਿਨ੍ਤੁ ਸੁਧਿਯਃ ਪ੍ਰਤ੍ਯਵਦਨ੍, ਦੱਤੇ ਯੁਸ਼਼੍ਮਾਨਸ੍ਮਾਂਸ਼੍ਚ ਪ੍ਰਤਿ ਤੈਲੰ ਨ੍ਯੂਨੀਭਵੇਤ੍, ਤਸ੍ਮਾਦ੍ ਵਿਕ੍ਰੇਤ੍ਰੁʼਣਾਂ ਸਮੀਪੰ ਗਤ੍ਵਾ ਸ੍ਵਾਰ੍ਥੰ ਤੈਲੰ ਕ੍ਰੀਣੀਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","ਤਦਾ ਤਾਸੁ ਕ੍ਰੇਤੁੰ ਗਤਾਸੁ ਵਰ ਆਜਗਾਮ, ਤਤੋ ਯਾਃ ਸੱਜਿਤਾ ਆਸਨ੍, ਤਾਸ੍ਤੇਨ ਸਾਕੰ ਵਿਵਾਹੀਯੰ ਵੇਸ਼੍ਮ ਪ੍ਰਵਿਵਿਸ਼ੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","ਅਨਨ੍ਤਰੰ ਦ੍ਵਾਰੇ ਰੁੱਧੇ ਅਪਰਾਃ ਕਨ੍ਯਾ ਆਗਤ੍ਯ ਜਗਦੁਃ, ਹੇ ਪ੍ਰਭੋ, ਹੇ ਪ੍ਰਭੋ, ਅਸ੍ਮਾਨ੍ ਪ੍ਰਤਿ ਦ੍ਵਾਰੰ ਮੋਚਯ| ");
INSERT INTO sanpun_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ਕਿਨ੍ਤੁ ਸ ਉਕ੍ਤਵਾਨ੍, ਤਥ੍ਯੰ ਵਦਾਮਿ, ਯੁਸ਼਼੍ਮਾਨਹੰ ਨ ਵੇਦ੍ਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","ਅਤੋ ਜਾਗ੍ਰਤਃ ਸਨ੍ਤਸ੍ਤਿਸ਼਼੍ਠਤ, ਮਨੁਜਸੁਤਃ ਕਸ੍ਮਿਨ੍ ਦਿਨੇ ਕਸ੍ਮਿਨ੍ ਦਣ੍ਡੇ ਵਾਗਮਿਸ਼਼੍ਯਤਿ, ਤਦ੍ ਯੁਸ਼਼੍ਮਾਭਿ ਰ੍ਨ ਜ੍ਞਾਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","ਅਪਰੰ ਸ ਏਤਾਦ੍ਰੁʼਸ਼ਃ ਕਸ੍ਯਚਿਤ੍ ਪੁੰਸਸ੍ਤੁਲ੍ਯਃ, ਯੋ ਦੂਰਦੇਸ਼ੰ ਪ੍ਰਤਿ ਯਾਤ੍ਰਾਕਾਲੇ ਨਿਜਦਾਸਾਨ੍ ਆਹੂਯ ਤੇਸ਼਼ਾਂ ਸ੍ਵਸ੍ਵਸਾਮਰ੍ਥ੍ਯਾਨੁਰੂਪਮ੍ ");
INSERT INTO sanpun_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ਏਕਸ੍ਮਿਨ੍ ਮੁਦ੍ਰਾਣਾਂ ਪਞ੍ਚ ਪੋਟਲਿਕਾਃ ਅਨ੍ਯਸ੍ਮਿੰਸ਼੍ਚ ਦ੍ਵੇ ਪੋਟਲਿਕੇ ਅਪਰਸ੍ਮਿੰਸ਼੍ਚ ਪੋਟਲਿਕੈਕਾਮ੍ ਇੱਥੰ ਪ੍ਰਤਿਜਨੰ ਸਮਰ੍ਪ੍ਯ ਸ੍ਵਯੰ ਪ੍ਰਵਾਸੰ ਗਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","ਅਨਨ੍ਤਰੰ ਯੋ ਦਾਸਃ ਪਞ੍ਚ ਪੋਟਲਿਕਾਃ ਲਬ੍ਧਵਾਨ੍, ਸ ਗਤ੍ਵਾ ਵਾਣਿਜ੍ਯੰ ਵਿਧਾਯ ਤਾ ਦ੍ਵਿਗੁਣੀਚਕਾਰ| ");
INSERT INTO sanpun_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ਯਸ਼੍ਚ ਦਾਸੋ ਦ੍ਵੇ ਪੋਟਲਿਕੇ ਅਲਭਤ, ਸੋਪਿ ਤਾ ਮੁਦ੍ਰਾ ਦ੍ਵਿਗੁਣੀਚਕਾਰ| ");
INSERT INTO sanpun_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","ਕਿਨ੍ਤੁ ਯੋ ਦਾਸ ਏਕਾਂ ਪੋਟਲਿਕਾਂ ਲਬ੍ਧਵਾਨ੍, ਸ ਗਤ੍ਵਾ ਭੂਮਿੰ ਖਨਿਤ੍ਵਾ ਤਨ੍ਮਧ੍ਯੇ ਨਿਜਪ੍ਰਭੋਸ੍ਤਾ ਮੁਦ੍ਰਾ ਗੋਪਯਾਞ੍ਚਕਾਰ| ");
INSERT INTO sanpun_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","ਤਦਨਨ੍ਤਰੰ ਬਹੁਤਿਥੇ ਕਾਲੇ ਗਤੇ ਤੇਸ਼਼ਾਂ ਦਾਸਾਨਾਂ ਪ੍ਰਭੁਰਾਗਤ੍ਯ ਤੈਰ੍ਦਾਸੈਃ ਸਮੰ ਗਣਯਾਞ੍ਚਕਾਰ| ");
INSERT INTO sanpun_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","ਤਦਾਨੀਂ ਯਃ ਪਞ੍ਚ ਪੋਟਲਿਕਾਃ ਪ੍ਰਾਪ੍ਤਵਾਨ੍ ਸ ਤਾ ਦ੍ਵਿਗੁਣੀਕ੍ਰੁʼਤਮੁਦ੍ਰਾ ਆਨੀਯ ਜਗਾਦ; ਹੇ ਪ੍ਰਭੋ, ਭਵਤਾ ਮਯਿ ਪਞ੍ਚ ਪੋਟਲਿਕਾਃ ਸਮਰ੍ਪਿਤਾਃ, ਪਸ਼੍ਯਤੁ, ਤਾ ਮਯਾ ਦ੍ਵਿਗੁਣੀਕ੍ਰੁʼਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ਤਦਾਨੀਂ ਤਸ੍ਯ ਪ੍ਰਭੁਸ੍ਤਮੁਵਾਚ, ਹੇ ਉੱਤਮ ਵਿਸ਼੍ਵਾਸ੍ਯ ਦਾਸ, ਤ੍ਵੰ ਧਨ੍ਯੋਸਿ, ਸ੍ਤੋਕੇਨ ਵਿਸ਼੍ਵਾਸ੍ਯੋ ਜਾਤਃ, ਤਸ੍ਮਾਤ੍ ਤ੍ਵਾਂ ਬਹੁਵਿੱਤਾਧਿਪੰ ਕਰੋਮਿ, ਤ੍ਵੰ ਸ੍ਵਪ੍ਰਭੋਃ ਸੁਖਸ੍ਯ ਭਾਗੀ ਭਵ| ");
INSERT INTO sanpun_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","ਤਤੋ ਯੇਨ ਦ੍ਵੇ ਪੋਟਲਿਕੇ ਲਬ੍ਧੇ ਸੋਪ੍ਯਾਗਤ੍ਯ ਜਗਾਦ, ਹੇ ਪ੍ਰਭੋ, ਭਵਤਾ ਮਯਿ ਦ੍ਵੇ ਪੋਟਲਿਕੇ ਸਮਰ੍ਪਿਤੇ, ਪਸ਼੍ਯਤੁ ਤੇ ਮਯਾ ਦ੍ਵਿਗੁਣੀਕ੍ਰੁʼਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ਤੇਨ ਤਸ੍ਯ ਪ੍ਰਭੁਸ੍ਤਮਵੋਚਤ੍, ਹੇ ਉੱਤਮ ਵਿਸ਼੍ਵਾਸ੍ਯ ਦਾਸ, ਤ੍ਵੰ ਧਨ੍ਯੋਸਿ, ਸ੍ਤੋਕੇਨ ਵਿਸ਼੍ਵਾਸ੍ਯੋ ਜਾਤਃ, ਤਸ੍ਮਾਤ੍ ਤ੍ਵਾਂ ਬਹੁਦ੍ਰਵਿਣਾਧਿਪੰ ਕਰੋਮਿ, ਤ੍ਵੰ ਨਿਜਪ੍ਰਭੋਃ ਸੁਖਸ੍ਯ ਭਾਗੀ ਭਵ| ");
INSERT INTO sanpun_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","ਅਨਨ੍ਤਰੰ ਯ ਏਕਾਂ ਪੋਟਲਿਕਾਂ ਲਬ੍ਧਵਾਨ੍, ਸ ਏਤ੍ਯ ਕਥਿਤਵਾਨ੍, ਹੇ ਪ੍ਰਭੋ, ਤ੍ਵਾਂ ਕਠਿਨਨਰੰ ਜ੍ਞਾਤਵਾਨ੍, ਤ੍ਵਯਾ ਯਤ੍ਰ ਨੋਪ੍ਤੰ, ਤਤ੍ਰੈਵ ਕ੍ਰੁʼਤ੍ਯਤੇ, ਯਤ੍ਰ ਚ ਨ ਕੀਰ੍ਣੰ, ਤਤ੍ਰੈਵ ਸੰਗ੍ਰੁʼਹ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ਅਤੋਹੰ ਸਸ਼ਙ੍ਕਃ ਸਨ੍ ਗਤ੍ਵਾ ਤਵ ਮੁਦ੍ਰਾ ਭੂਮਧ੍ਯੇ ਸੰਗੋਪ੍ਯ ਸ੍ਥਾਪਿਤਵਾਨ੍, ਪਸ਼੍ਯ, ਤਵ ਯਤ੍ ਤਦੇਵ ਗ੍ਰੁʼਹਾਣ| ");
INSERT INTO sanpun_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","ਤਦਾ ਤਸ੍ਯ ਪ੍ਰਭੁਃ ਪ੍ਰਤ੍ਯਵਦਤ੍ ਰੇ ਦੁਸ਼਼੍ਟਾਲਸ ਦਾਸ, ਯਤ੍ਰਾਹੰ ਨ ਵਪਾਮਿ, ਤਤ੍ਰ ਛਿਨਦ੍ਮਿ, ਯਤ੍ਰ ਚ ਨ ਕਿਰਾਮਿ, ਤਤ੍ਰੇਵ ਸੰਗ੍ਰੁʼਹ੍ਲਾਮੀਤਿ ਚੇਦਜਾਨਾਸ੍ਤਰ੍ਹਿ ");
INSERT INTO sanpun_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ਵਣਿਕ੍ਸ਼਼ੁ ਮਮ ਵਿੱਤਾਰ੍ਪਣੰ ਤਵੋਚਿਤਮਾਸੀਤ੍, ਯੇਨਾਹਮਾਗਤ੍ਯ ਵ੍ਰੁʼਦ੍ਵ੍ਯਾ ਸਾਕੰ ਮੂਲਮੁਦ੍ਰਾਃ ਪ੍ਰਾਪ੍ਸ੍ਯਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","ਅਤੋਸ੍ਮਾਤ੍ ਤਾਂ ਪੋਟਲਿਕਾਮ੍ ਆਦਾਯ ਯਸ੍ਯ ਦਸ਼ ਪੋਟਲਿਕਾਃ ਸਨ੍ਤਿ ਤਸ੍ਮਿੰਨਰ੍ਪਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ਯੇਨ ਵਰ੍ਦ੍ਵ੍ਯਤੇ ਤਸ੍ਮਿੰਨੈਵਾਰ੍ਪਿਸ਼਼੍ਯਤੇ, ਤਸ੍ਯੈਵ ਚ ਬਾਹੁਲ੍ਯੰ ਭਵਿਸ਼਼੍ਯਤਿ, ਕਿਨ੍ਤੁ ਯੇਨ ਨ ਵਰ੍ਦ੍ਵ੍ਯਤੇ, ਤਸ੍ਯਾਨ੍ਤਿਕੇ ਯਤ੍ ਕਿਞ੍ਚਨ ਤਿਸ਼਼੍ਠਤਿ, ਤਦਪਿ ਪੁਨਰ੍ਨੇਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","ਅਪਰੰ ਯੂਯੰ ਤਮਕਰ੍ੰਮਣ੍ਯੰ ਦਾਸੰ ਨੀਤ੍ਵਾ ਯਤ੍ਰ ਸ੍ਥਾਨੇ ਕ੍ਰਨ੍ਦਨੰ ਦਨ੍ਤਘਰ੍ਸ਼਼ਣਞ੍ਚ ਵਿਦ੍ਯੇਤੇ, ਤਸ੍ਮਿਨ੍ ਬਹਿਰ੍ਭੂਤਤਮਸਿ ਨਿਕ੍ਸ਼਼ਿਪਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","ਯਦਾ ਮਨੁਜਸੁਤਃ ਪਵਿਤ੍ਰਦੂਤਾਨ੍ ਸਙ੍ਗਿਨਃ ਕ੍ਰੁʼਤ੍ਵਾ ਨਿਜਪ੍ਰਭਾਵੇਨਾਗਤ੍ਯ ਨਿਜਤੇਜੋਮਯੇ ਸਿੰਹਾਸਨੇ ਨਿਵੇਕ੍ਸ਼਼੍ਯਤਿ, ");
INSERT INTO sanpun_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ਤਦਾ ਤਤ੍ਸੰਮੁਖੇ ਸਰ੍ੱਵਜਾਤੀਯਾ ਜਨਾ ਸੰਮੇਲਿਸ਼਼੍ਯਨ੍ਤਿ| ਤਤੋ ਮੇਸ਼਼ਪਾਲਕੋ ਯਥਾ ਛਾਗੇਭ੍ਯੋ(ਅ)ਵੀਨ੍ ਪ੍ਰੁʼਥਕ੍ ਕਰੋਤਿ ਤਥਾ ਸੋਪ੍ਯੇਕਸ੍ਮਾਦਨ੍ਯਮ੍ ਇੱਥੰ ਤਾਨ੍ ਪ੍ਰੁʼਥਕ ਕ੍ਰੁʼਤ੍ਵਾਵੀਨ੍ ");
INSERT INTO sanpun_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ਦਕ੍ਸ਼਼ਿਣੇ ਛਾਗਾਂਸ਼੍ਚ ਵਾਮੇ ਸ੍ਥਾਪਯਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","ਤਤਃ ਪਰੰ ਰਾਜਾ ਦਕ੍ਸ਼਼ਿਣਸ੍ਥਿਤਾਨ੍ ਮਾਨਵਾਨ੍ ਵਦਿਸ਼਼੍ਯਤਿ, ਆਗੱਛਤ ਮੱਤਾਤਸ੍ਯਾਨੁਗ੍ਰਹਭਾਜਨਾਨਿ, ਯੁਸ਼਼੍ਮਤ੍ਕ੍ਰੁʼਤ ਆ ਜਗਦਾਰਮ੍ਭਤ੍ ਯਦ੍ ਰਾਜ੍ਯਮ੍ ਆਸਾਦਿਤੰ ਤਦਧਿਕੁਰੁਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ਯਤੋ ਬੁਭੁਕ੍ਸ਼਼ਿਤਾਯ ਮਹ੍ਯੰ ਭੋਜ੍ਯਮ੍ ਅਦੱਤ, ਪਿਪਾਸਿਤਾਯ ਪੇਯਮਦੱਤ, ਵਿਦੇਸ਼ਿਨੰ ਮਾਂ ਸ੍ਵਸ੍ਥਾਨਮਨਯਤ, ");
INSERT INTO sanpun_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ਵਸ੍ਤ੍ਰਹੀਨੰ ਮਾਂ ਵਸਨੰ ਪਰ੍ੱਯਧਾਪਯਤ, ਪੀਡੀਤੰ ਮਾਂ ਦ੍ਰਸ਼਼੍ਟੁਮਾਗੱਛਤ, ਕਾਰਾਸ੍ਥਞ੍ਚ ਮਾਂ ਵੀਕ੍ਸ਼਼ਿਤੁਮ ਆਗੱਛਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","ਤਦਾ ਧਾਰ੍ੰਮਿਕਾਃ ਪ੍ਰਤਿਵਦਿਸ਼਼੍ਯਨ੍ਤਿ, ਹੇ ਪ੍ਰਭੋ, ਕਦਾ ਤ੍ਵਾਂ ਕ੍ਸ਼਼ੁਧਿਤੰ ਵੀਕ੍ਸ਼਼੍ਯ ਵਯਮਭੋਜਯਾਮ? ਵਾ ਪਿਪਾਸਿਤੰ ਵੀਕ੍ਸ਼਼੍ਯ ਅਪਾਯਯਾਮ? ");
INSERT INTO sanpun_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ਕਦਾ ਵਾ ਤ੍ਵਾਂ ਵਿਦੇਸ਼ਿਨੰ ਵਿਲੋਕ੍ਯ ਸ੍ਵਸ੍ਥਾਨਮਨਯਾਮ? ਕਦਾ ਵਾ ਤ੍ਵਾਂ ਨਗ੍ਨੰ ਵੀਕ੍ਸ਼਼੍ਯ ਵਸਨੰ ਪਰ੍ੱਯਧਾਪਯਾਮ? ");
INSERT INTO sanpun_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ਕਦਾ ਵਾ ਤ੍ਵਾਂ ਪੀਡਿਤੰ ਕਾਰਾਸ੍ਥਞ੍ਚ ਵੀਕ੍ਸ਼਼੍ਯ ਤ੍ਵਦਨ੍ਤਿਕਮਗੱਛਾਮ? ");
INSERT INTO sanpun_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","ਤਦਾਨੀਂ ਰਾਜਾ ਤਾਨ੍ ਪ੍ਰਤਿਵਦਿਸ਼਼੍ਯਤਿ, ਯੁਸ਼਼੍ਮਾਨਹੰ ਸਤ੍ਯੰ ਵਦਾਮਿ, ਮਮੈਤੇਸ਼਼ਾਂ ਭ੍ਰਾਤ੍ਰੁʼਣਾਂ ਮਧ੍ਯੇ ਕਞ੍ਚਨੈਕੰ ਕ੍ਸ਼਼ੁਦ੍ਰਤਮੰ ਪ੍ਰਤਿ ਯਦ੍ ਅਕੁਰੁਤ, ਤਨ੍ਮਾਂ ਪ੍ਰਤ੍ਯਕੁਰੁਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","ਪਸ਼੍ਚਾਤ੍ ਸ ਵਾਮਸ੍ਥਿਤਾਨ੍ ਜਨਾਨ੍ ਵਦਿਸ਼਼੍ਯਤਿ, ਰੇ ਸ਼ਾਪਗ੍ਰਸ੍ਤਾਃ ਸਰ੍ੱਵੇ, ਸ਼ੈਤਾਨੇ ਤਸ੍ਯ ਦੂਤੇਭ੍ਯਸ਼੍ਚ ਯੋ(ਅ)ਨਨ੍ਤਵਹ੍ਨਿਰਾਸਾਦਿਤ ਆਸ੍ਤੇ, ਯੂਯੰ ਮਦਨ੍ਤਿਕਾਤ੍ ਤਮਗ੍ਨਿੰ ਗੱਛਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ਯਤੋ ਕ੍ਸ਼਼ੁਧਿਤਾਯ ਮਹ੍ਯਮਾਹਾਰੰ ਨਾਦੱਤ, ਪਿਪਾਸਿਤਾਯ ਮਹ੍ਯੰ ਪੇਯੰ ਨਾਦੱਤ, ");
INSERT INTO sanpun_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ਵਿਦੇਸ਼ਿਨੰ ਮਾਂ ਸ੍ਵਸ੍ਥਾਨੰ ਨਾਨਯਤ, ਵਸਨਹੀਨੰ ਮਾਂ ਵਸਨੰ ਨ ਪਰ੍ੱਯਧਾਪਯਤ, ਪੀਡਿਤੰ ਕਾਰਾਸ੍ਥਞ੍ਚ ਮਾਂ ਵੀਕ੍ਸ਼਼ਿਤੁੰ ਨਾਗੱਛਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","ਤਦਾ ਤੇ ਪ੍ਰਤਿਵਦਿਸ਼਼੍ਯਨ੍ਤਿ, ਹੇ ਪ੍ਰਭੋ, ਕਦਾ ਤ੍ਵਾਂ ਕ੍ਸ਼਼ੁਧਿਤੰ ਵਾ ਪਿਪਾਸਿਤੰ ਵਾ ਵਿਦੇਸ਼ਿਨੰ ਵਾ ਨਗ੍ਨੰ ਵਾ ਪੀਡਿਤੰ ਵਾ ਕਾਰਾਸ੍ਥੰ ਵੀਕ੍ਸ਼਼੍ਯ ਤ੍ਵਾਂ ਨਾਸੇਵਾਮਹਿ? ");
INSERT INTO sanpun_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","ਤਦਾ ਸ ਤਾਨ੍ ਵਦਿਸ਼਼੍ਯਤਿ, ਤਥ੍ਯਮਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਬ੍ਰਵੀਮਿ, ਯੁਸ਼਼੍ਮਾਭਿਰੇਸ਼਼ਾਂ ਕਞ੍ਚਨ ਕ੍ਸ਼਼ੋਦਿਸ਼਼੍ਠੰ ਪ੍ਰਤਿ ਯੰਨਾਕਾਰਿ, ਤਨ੍ਮਾਂ ਪ੍ਰਤ੍ਯੇਵ ਨਾਕਾਰਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","ਪਸ਼੍ਚਾਦਮ੍ਯਨਨ੍ਤਸ਼ਾਸ੍ਤਿੰ ਕਿਨ੍ਤੁ ਧਾਰ੍ੰਮਿਕਾ ਅਨਨ੍ਤਾਯੁਸ਼਼ੰ ਭੋਕ੍ਤੁੰ ਯਾਸ੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","ਯੀਸ਼ੁਰੇਤਾਨ੍ ਪ੍ਰਸ੍ਤਾਵਾਨ੍ ਸਮਾਪ੍ਯ ਸ਼ਿਸ਼਼੍ਯਾਨੂਚੇ, ");
INSERT INTO sanpun_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","ਯੁਸ਼਼੍ਮਾਭਿ ਰ੍ਜ੍ਞਾਤੰ ਦਿਨਦ੍ਵਯਾਤ੍ ਪਰੰ ਨਿਸ੍ਤਾਰਮਹ ਉਪਸ੍ਥਾਸ੍ਯਤਿ, ਤਤ੍ਰ ਮਨੁਜਸੁਤਃ ਕ੍ਰੁਸ਼ੇਨ ਹਨ੍ਤੁੰ ਪਰਕਰੇਸ਼਼ੁ ਸਮਰ੍ਪਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","ਤਤਃ ਪਰੰ ਪ੍ਰਧਾਨਯਾਜਕਾਧ੍ਯਾਪਕਪ੍ਰਾਞ੍ਚਃ ਕਿਯਫਾਨਾਮ੍ਨੋ ਮਹਾਯਾਜਕਸ੍ਯਾੱਟਾਲਿਕਾਯਾਂ ਮਿਲਿਤ੍ਵਾ ");
INSERT INTO sanpun_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ਕੇਨੋਪਾਯੇਨ ਯੀਸ਼ੁੰ ਧ੍ਰੁʼਤ੍ਵਾ ਹਨ੍ਤੁੰ ਸ਼ਕ੍ਨੁਯੁਰਿਤਿ ਮਨ੍ਤ੍ਰਯਾਞ੍ਚਕ੍ਰੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ਕਿਨ੍ਤੁ ਤੈਰੁਕ੍ਤੰ ਮਹਕਾਲੇ ਨ ਧਰ੍ੱਤਵ੍ਯਃ, ਧ੍ਰੁʼਤੇ ਪ੍ਰਜਾਨਾਂ ਕਲਹੇਨ ਭਵਿਤੁੰ ਸ਼ਕ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","ਤਤੋ ਬੈਥਨਿਯਾਪੁਰੇ ਸ਼ਿਮੋਨਾਖ੍ਯਸ੍ਯ ਕੁਸ਼਼੍ਠਿਨੋ ਵੇਸ਼੍ਮਨਿ ਯੀਸ਼ੌ ਤਿਸ਼਼੍ਠਤਿ ");
INSERT INTO sanpun_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ਕਾਚਨ ਯੋਸ਼਼ਾ ਸ਼੍ਵੇਤੋਪਲਭਾਜਨੇਨ ਮਹਾਰ੍ਘ੍ਯੰ ਸੁਗਨ੍ਧਿ ਤੈਲਮਾਨੀਯ ਭੋਜਨਾਯੋਪਵਿਸ਼ਤਸ੍ਤਸ੍ਯ ਸ਼ਿਰੋਭ੍ਯਸ਼਼ੇਚਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ਕਿਨ੍ਤੁ ਤਦਾਲੋਕ੍ਯ ਤੱਛਿਸ਼਼੍ਯੈਃ ਕੁਪਿਤੈਰੁਕ੍ਤੰ, ਕੁਤ ਇੱਥਮਪਵ੍ਯਯਤੇ? ");
INSERT INTO sanpun_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ਚੇਦਿਦੰ ਵ੍ਯਕ੍ਰੇਸ਼਼੍ਯਤ, ਤਰ੍ਹਿ ਭੂਰਿਮੂਲ੍ਯੰ ਪ੍ਰਾਪ੍ਯ ਦਰਿਦ੍ਰੇਭ੍ਯੋ ਵ੍ਯਤਾਰਿਸ਼਼੍ਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","ਯੀਸ਼ੁਨਾ ਤਦਵਗਤ੍ਯ ਤੇ ਸਮੁਦਿਤਾਃ, ਯੋਸ਼਼ਾਮੇਨਾਂ ਕੁਤੋ ਦੁਃਖਿਨੀਂ ਕੁਰੁਥ, ਸਾ ਮਾਂ ਪ੍ਰਤਿ ਸਾਧੁ ਕਰ੍ੰਮਾਕਾਰ੍ਸ਼਼ੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","ਯੁਸ਼਼੍ਮਾਕਮੰ ਸਮੀਪੇ ਦਰਿਦ੍ਰਾਃ ਸਤਤਮੇਵਾਸਤੇ, ਕਿਨ੍ਤੁ ਯੁਸ਼਼੍ਮਾਕਮਨ੍ਤਿਕੇਹੰ ਨਾਸੇ ਸਤਤੰ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ਸਾ ਮਮ ਕਾਯੋਪਰਿ ਸੁਗਨ੍ਧਿਤੈਲੰ ਸਿਕ੍ਤ੍ਵਾ ਮਮ ਸ਼੍ਮਸ਼ਾਨਦਾਨਕਰ੍ੰਮਾਕਾਰ੍ਸ਼਼ੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","ਅਤੋਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਤਥ੍ਯੰ ਵਦਾਮਿ ਸਰ੍ੱਵਸ੍ਮਿਨ੍ ਜਗਤਿ ਯਤ੍ਰ ਯਤ੍ਰੈਸ਼਼ ਸੁਸਮਾਚਾਰਃ ਪ੍ਰਚਾਰਿਸ਼਼੍ਯਤੇ, ਤਤ੍ਰ ਤਤ੍ਰੈਤਸ੍ਯਾ ਨਾਰ੍ੱਯਾਃ ਸ੍ਮਰਣਾਰ੍ਥਮ੍ ਕਰ੍ੰਮੇਦੰ ਪ੍ਰਚਾਰਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","ਤਤੋ ਦ੍ਵਾਦਸ਼ਸ਼ਿਸ਼਼੍ਯਾਣਾਮ੍ ਈਸ਼਼੍ਕਰਿਯੋਤੀਯਯਿਹੂਦਾਨਾਮਕ ਏਕਃ ਸ਼ਿਸ਼਼੍ਯਃ ਪ੍ਰਧਾਨਯਾਜਕਾਨਾਮਨ੍ਤਿਕੰ ਗਤ੍ਵਾ ਕਥਿਤਵਾਨ੍, ");
INSERT INTO sanpun_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ਯਦਿ ਯੁਸ਼਼੍ਮਾਕੰ ਕਰੇਸ਼਼ੁ ਯੀਸ਼ੁੰ ਸਮਰ੍ਪਯਾਮਿ, ਤਰ੍ਹਿ ਕਿੰ ਦਾਸ੍ਯਥ? ਤਦਾਨੀਂ ਤੇ ਤਸ੍ਮੈ ਤ੍ਰਿੰਸ਼ਨ੍ਮੁਦ੍ਰਾ ਦਾਤੁੰ ਸ੍ਥਿਰੀਕ੍ਰੁʼਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ਸ ਤਦਾਰਭ੍ਯ ਤੰ ਪਰਕਰੇਸ਼਼ੁ ਸਮਰ੍ਪਯਿਤੁੰ ਸੁਯੋਗੰ ਚੇਸ਼਼੍ਟਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","ਅਨਨ੍ਤਰੰ ਕਿਣ੍ਵਸ਼ੂਨ੍ਯਪੂਪਪਰ੍ੱਵਣਃ ਪ੍ਰਥਮੇਹ੍ਨਿ ਸ਼ਿਸ਼਼੍ਯਾ ਯੀਸ਼ੁਮ੍ ਉਪਗਤ੍ਯ ਪਪ੍ਰੱਛੁਃ ਭਵਤ੍ਕ੍ਰੁʼਤੇ ਕੁਤ੍ਰ ਵਯੰ ਨਿਸ੍ਤਾਰਮਹਭੋਜ੍ਯਮ੍ ਆਯੋਜਯਿਸ਼਼੍ਯਾਮਃ? ਭਵਤਃ ਕੇੱਛਾ? ");
INSERT INTO sanpun_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ਤਦਾ ਸ ਗਦਿਤਵਾਨ੍, ਮਧ੍ਯੇਨਗਰਮਮੁਕਪੁੰਸਃ ਸਮੀਪੰ ਵ੍ਰਜਿਤ੍ਵਾ ਵਦਤ, ਗੁਰੁ ਰ੍ਗਦਿਤਵਾਨ੍, ਮਤ੍ਕਾਲਃ ਸਵਿਧਃ, ਸਹ ਸ਼ਿਸ਼਼੍ਯੈਸ੍ਤ੍ਵਦਾਲਯੇ ਨਿਸ੍ਤਾਰਮਹਭੋਜ੍ਯੰ ਭੋਕ੍ਸ਼਼੍ਯੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ਤਦਾ ਸ਼ਿਸ਼਼੍ਯਾ ਯੀਸ਼ੋਸ੍ਤਾਦ੍ਰੁʼਸ਼ਨਿਦੇਸ਼ਾਨੁਰੂਪਕਰ੍ੰਮ ਵਿਧਾਯ ਤਤ੍ਰ ਨਿਸ੍ਤਾਰਮਹਭੋਜ੍ਯਮਾਸਾਦਯਾਮਾਸੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ਤਤਃ ਸਨ੍ਧ੍ਯਾਯਾਂ ਸਤ੍ਯਾਂ ਦ੍ਵਾਦਸ਼ਭਿਃ ਸ਼ਿਸ਼਼੍ਯੈਃ ਸਾਕੰ ਸ ਨ੍ਯਵਿਸ਼ਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ਅਪਰੰ ਭੁਞ੍ਜਾਨ ਉਕ੍ਤਵਾਨ੍ ਯੁਸ਼਼੍ਮਾਨ੍ ਤਥ੍ਯੰ ਵਦਾਮਿ, ਯੁਸ਼਼੍ਮਾਕਮੇਕੋ ਮਾਂ ਪਰਕਰੇਸ਼਼ੁ ਸਮਰ੍ਪਯਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ਤਦਾ ਤੇ(ਅ)ਤੀਵ ਦੁਃਖਿਤਾ ਏਕੈਕਸ਼ੋ ਵਕ੍ਤੁਮਾਰੇਭਿਰੇ, ਹੇ ਪ੍ਰਭੋ, ਸ ਕਿਮਹੰ? ");
INSERT INTO sanpun_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ਤਤਃ ਸ ਜਗਾਦ, ਮਯਾ ਸਾਕੰ ਯੋ ਜਨੋ ਭੋਜਨਪਾਤ੍ਰੇ ਕਰੰ ਸੰਕ੍ਸ਼਼ਿਪਤਿ, ਸ ਏਵ ਮਾਂ ਪਰਕਰੇਸ਼਼ੁ ਸਮਰ੍ਪਯਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","ਮਨੁਜਸੁਤਮਧਿ ਯਾਦ੍ਰੁʼਸ਼ੰ ਲਿਖਿਤਮਾਸ੍ਤੇ, ਤਦਨੁਰੂਪਾ ਤਦ੍ਗਤਿ ਰ੍ਭਵਿਸ਼਼੍ਯਤਿ; ਕਿਨ੍ਤੁ ਯੇਨ ਪੁੰਸਾ ਸ ਪਰਕਰੇਸ਼਼ੁ ਸਮਰ੍ਪਯਿਸ਼਼੍ਯਤੇ, ਹਾ ਹਾ ਚੇਤ੍ ਸ ਨਾਜਨਿਸ਼਼੍ਯਤ, ਤਦਾ ਤਸ੍ਯ ਕ੍ਸ਼਼ੇਮਮਭਵਿਸ਼਼੍ਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ਤਦਾ ਯਿਹੂਦਾਨਾਮਾ ਯੋ ਜਨਸ੍ਤੰ ਪਰਕਰੇਸ਼਼ੁ ਸਮਰ੍ਪਯਿਸ਼਼੍ਯਤਿ, ਸ ਉਕ੍ਤਵਾਨ੍, ਹੇ ਗੁਰੋ, ਸ ਕਿਮਹੰ? ਤਤਃ ਸ ਪ੍ਰਤ੍ਯੁਕ੍ਤਵਾਨ੍, ਤ੍ਵਯਾ ਸਤ੍ਯੰ ਗਦਿਤਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","ਅਨਨ੍ਤਰੰ ਤੇਸ਼਼ਾਮਸ਼ਨਕਾਲੇ ਯੀਸ਼ੁਃ ਪੂਪਮਾਦਾਯੇਸ਼੍ਵਰੀਯਗੁਣਾਨਨੂਦ੍ਯ ਭੰਕ੍ਤ੍ਵਾ ਸ਼ਿਸ਼਼੍ਯੇਭ੍ਯਃ ਪ੍ਰਦਾਯ ਜਗਾਦ, ਮਦ੍ਵਪੁਃਸ੍ਵਰੂਪਮਿਮੰ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਖਾਦਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ਪਸ਼੍ਚਾਤ੍ ਸ ਕੰਸੰ ਗ੍ਰੁʼਹ੍ਲਨ੍ ਈਸ਼੍ਵਰੀਯਗੁਣਾਨਨੂਦ੍ਯ ਤੇਭ੍ਯਃ ਪ੍ਰਦਾਯ ਕਥਿਤਵਾਨ੍, ਸਰ੍ੱਵੈ ਰ੍ਯੁਸ਼਼੍ਮਾਭਿਰਨੇਨ ਪਾਤਵ੍ਯੰ, ");
INSERT INTO sanpun_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ਯਸ੍ਮਾਦਨੇਕੇਸ਼਼ਾਂ ਪਾਪਮਰ੍ਸ਼਼ਣਾਯ ਪਾਤਿਤੰ ਯਨ੍ਮੰਨੂਤ੍ਨਨਿਯਮਰੂਪਸ਼ੋਣਿਤੰ ਤਦੇਤਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","ਅਪਰਮਹੰ ਨੂਤ੍ਨਗੋਸ੍ਤਨੀਰਸੰ ਨ ਪਾਸ੍ਯਾਮਿ, ਤਾਵਤ੍ ਗੋਸ੍ਤਨੀਫਲਰਸੰ ਪੁਨਃ ਕਦਾਪਿ ਨ ਪਾਸ੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ਪਸ਼੍ਚਾਤ੍ ਤੇ ਗੀਤਮੇਕੰ ਸੰਗੀਯ ਜੈਤੁਨਾਖ੍ਯਗਿਰਿੰ ਗਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","ਤਦਾਨੀਂ ਯੀਸ਼ੁਸ੍ਤਾਨਵੋਚਤ੍, ਅਸ੍ਯਾਂ ਰਜਨ੍ਯਾਮਹੰ ਯੁਸ਼਼੍ਮਾਕੰ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਵਿਘ੍ਨਰੂਪੋ ਭਵਿਸ਼਼੍ਯਾਮਿ, ਯਤੋ ਲਿਖਿਤਮਾਸ੍ਤੇ, \"ਮੇਸ਼਼ਾਣਾਂ ਰਕ੍ਸ਼਼ਕੋ ਯਸ੍ਤੰ ਪ੍ਰਹਰਿਸ਼਼੍ਯਾਮ੍ਯਹੰ ਤਤਃ| ਮੇਸ਼਼ਾਣਾਂ ਨਿਵਹੋ ਨੂਨੰ ਪ੍ਰਵਿਕੀਰ੍ਣੋ ਭਵਿਸ਼਼੍ਯਤਿ\"|| ");
INSERT INTO sanpun_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","ਕਿਨ੍ਤੁ ਸ਼੍ਮਸ਼ਾਨਾਤ੍ ਸਮੁੱਥਾਯ ਯੁਸ਼਼੍ਮਾਕਮਗ੍ਰੇ(ਅ)ਹੰ ਗਾਲੀਲੰ ਗਮਿਸ਼਼੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ਪਿਤਰਸ੍ਤੰ ਪ੍ਰੋਵਾਚ, ਭਵਾਂਸ਼੍ਚੇਤ੍ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਵਿਘ੍ਨਰੂਪੋ ਭਵਤਿ, ਤਥਾਪਿ ਮਮ ਨ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ਤਤੋ ਯੀਸ਼ੁਨਾ ਸ ਉਕ੍ਤਃ, ਤੁਭ੍ਯਮਹੰ ਤਥ੍ਯੰ ਕਥਯਾਮਿ, ਯਾਮਿਨ੍ਯਾਮਸ੍ਯਾਂ ਚਰਣਾਯੁਧਸ੍ਯ ਰਵਾਤ੍ ਪੂਰ੍ੱਵੰ ਤ੍ਵੰ ਮਾਂ ਤ੍ਰਿ ਰ੍ਨਾਙ੍ਗੀਕਰਿਸ਼਼੍ਯਸਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ਤਤਃ ਪਿਤਰ ਉਦਿਤਵਾਨ੍, ਯਦ੍ਯਪਿ ਤ੍ਵਯਾ ਸਮੰ ਮਰ੍ੱਤਵ੍ਯੰ, ਤਥਾਪਿ ਕਦਾਪਿ ਤ੍ਵਾਂ ਨ ਨਾਙ੍ਗੀਕਰਿਸ਼਼੍ਯਾਮਿ; ਤਥੈਵ ਸਰ੍ੱਵੇ ਸ਼ਿਸ਼਼੍ਯਾਸ਼੍ਚੋਚੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","ਅਨਨ੍ਤਰੰ ਯੀਸ਼ੁਃ ਸ਼ਿਸ਼਼੍ਯੈਃ ਸਾਕੰ ਗੇਤ੍ਸ਼ਿਮਾਨੀਨਾਮਕੰ ਸ੍ਥਾਨੰ ਪ੍ਰਸ੍ਥਾਯ ਤੇਭ੍ਯਃ ਕਥਿਤਵਾਨ੍, ਅਦਃ ਸ੍ਥਾਨੰ ਗਤ੍ਵਾ ਯਾਵਦਹੰ ਪ੍ਰਾਰ੍ਥਯਿਸ਼਼੍ਯੇ ਤਾਵਦ੍ ਯੂਯਮਤ੍ਰੋਪਵਿਸ਼ਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ਪਸ਼੍ਚਾਤ੍ ਸ ਪਿਤਰੰ ਸਿਵਦਿਯਸੁਤੌ ਚ ਸਙ੍ਗਿਨਃ ਕ੍ਰੁʼਤ੍ਵਾ ਗਤਵਾਨ੍, ਸ਼ੋਕਾਕੁਲੋ(ਅ)ਤੀਵ ਵ੍ਯਥਿਤਸ਼੍ਚ ਬਭੂਵ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ਤਾਨਵਾਦੀੱਚ ਮ੍ਰੁʼਤਿਯਾਤਨੇਵ ਮਤ੍ਪ੍ਰਾਣਾਨਾਂ ਯਾਤਨਾ ਜਾਯਤੇ, ਯੂਯਮਤ੍ਰ ਮਯਾ ਸਾਰ੍ੱਧੰ ਜਾਗ੍ਰੁʼਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ਤਤਃ ਸ ਕਿਞ੍ਚਿੱਦੂਰੰ ਗਤ੍ਵਾਧੋਮੁਖਃ ਪਤਨ੍ ਪ੍ਰਾਰ੍ਥਯਾਞ੍ਚਕ੍ਰੇ, ਹੇ ਮਤ੍ਪਿਤਰ੍ਯਦਿ ਭਵਿਤੁੰ ਸ਼ਕ੍ਨੋਤਿ, ਤਰ੍ਹਿ ਕੰਸੋ(ਅ)ਯੰ ਮੱਤੋ ਦੂਰੰ ਯਾਤੁ; ਕਿਨ੍ਤੁ ਮਦਿੱਛਾਵਤ੍ ਨ ਭਵਤੁ, ਤ੍ਵਦਿੱਛਾਵਦ੍ ਭਵਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ਤਤਃ ਸ ਸ਼ਿਸ਼਼੍ਯਾਨੁਪੇਤ੍ਯ ਤਾਨ੍ ਨਿਦ੍ਰਤੋ ਨਿਰੀਕ੍ਸ਼਼੍ਯ ਪਿਤਰਾਯ ਕਥਯਾਮਾਸ, ਯੂਯੰ ਮਯਾ ਸਾਕੰ ਦਣ੍ਡਮੇਕਮਪਿ ਜਾਗਰਿਤੁੰ ਨਾਸ਼ਨ੍ਕੁਤ? ");
INSERT INTO sanpun_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","ਪਰੀਕ੍ਸ਼਼ਾਯਾਂ ਨ ਪਤਿਤੁੰ ਜਾਗ੍ਰੁʼਤ ਪ੍ਰਾਰ੍ਥਯਧ੍ਵਞ੍ਚ; ਆਤ੍ਮਾ ਸਮੁਦ੍ਯਤੋਸ੍ਤਿ, ਕਿਨ੍ਤੁ ਵਪੁ ਰ੍ਦੁਰ੍ੱਬਲੰ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ਸ ਦ੍ਵਿਤੀਯਵਾਰੰ ਪ੍ਰਾਰ੍ਥਯਾਞ੍ਚਕ੍ਰੇ, ਹੇ ਮੱਤਾਤ, ਨ ਪੀਤੇ ਯਦਿ ਕੰਸਮਿਦੰ ਮੱਤੋ ਦੂਰੰ ਯਾਤੁੰ ਨ ਸ਼ਕ੍ਨੋਤਿ, ਤਰ੍ਹਿ ਤ੍ਵਦਿੱਛਾਵਦ੍ ਭਵਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ਸ ਪੁਨਰੇਤ੍ਯ ਤਾਨ੍ ਨਿਦ੍ਰਤੋ ਦਦਰ੍ਸ਼, ਯਤਸ੍ਤੇਸ਼਼ਾਂ ਨੇਤ੍ਰਾਣਿ ਨਿਦ੍ਰਯਾ ਪੂਰ੍ਣਾਨ੍ਯਾਸਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ਪਸ਼੍ਚਾਤ੍ ਸ ਤਾਨ੍ ਵਿਹਾਯ ਵ੍ਰਜਿਤ੍ਵਾ ਤ੍ਰੁʼਤੀਯਵਾਰੰ ਪੂਰ੍ੱਵਵਤ੍ ਕਥਯਨ੍ ਪ੍ਰਾਰ੍ਥਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ਤਤਃ ਸ਼ਿਸ਼਼੍ਯਾਨੁਪਾਗਤ੍ਯ ਗਦਿਤਵਾਨ੍, ਸਾਮ੍ਪ੍ਰਤੰ ਸ਼ਯਾਨਾਃ ਕਿੰ ਵਿਸ਼੍ਰਾਮ੍ਯਥ? ਪਸ਼੍ਯਤ, ਸਮਯ ਉਪਾਸ੍ਥਾਤ੍, ਮਨੁਜਸੁਤਃ ਪਾਪਿਨਾਂ ਕਰੇਸ਼਼ੁ ਸਮਰ੍ਪ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ਉੱਤਿਸ਼਼੍ਠਤ, ਵਯੰ ਯਾਮਃ, ਯੋ ਮਾਂ ਪਰਕਰੇਸ਼਼ੁ ਮਸਰ੍ਪਯਿਸ਼਼੍ਯਤਿ, ਪਸ਼੍ਯਤ, ਸ ਸਮੀਪਮਾਯਾਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ਏਤਤ੍ਕਥਾਕਥਨਕਾਲੇ ਦ੍ਵਾਦਸ਼ਸ਼ਿਸ਼਼੍ਯਾਣਾਮੇਕੋ ਯਿਹੂਦਾਨਾਮਕੋ ਮੁਖ੍ਯਯਾਜਕਲੋਕਪ੍ਰਾਚੀਨੈਃ ਪ੍ਰਹਿਤਾਨ੍ ਅਸਿਧਾਰਿਯਸ਼਼੍ਟਿਧਾਰਿਣੋ ਮਨੁਜਾਨ੍ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਤਤ੍ਸਮੀਪਮੁਪਤਸ੍ਥੌ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ਅਸੌ ਪਰਕਰੇਸ਼਼੍ਵਰ੍ਪਯਿਤਾ ਪੂਰ੍ੱਵੰ ਤਾਨ੍ ਇੱਥੰ ਸਙ੍ਕੇਤਯਾਮਾਸ, ਯਮਹੰ ਚੁਮ੍ਬਿਸ਼਼੍ਯੇ, ਸੋ(ਅ)ਸੌ ਮਨੁਜਃ,ਸਏਵ ਯੁਸ਼਼੍ਮਾਭਿ ਰ੍ਧਾਰ੍ੱਯਤਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ਤਦਾ ਸ ਸਪਦਿ ਯੀਸ਼ੁਮੁਪਾਗਤ੍ਯ ਹੇ ਗੁਰੋ, ਪ੍ਰਣਮਾਮੀਤ੍ਯੁਕ੍ਤ੍ਵਾ ਤੰ ਚੁਚੁਮ੍ਬੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ਤਦਾ ਯੀਸ਼ੁਸ੍ਤਮੁਵਾਚ, ਹੇ ਮਿਤ੍ਰੰ ਕਿਮਰ੍ਥਮਾਗਤੋਸਿ? ਤਦਾ ਤੈਰਾਗਤ੍ਯ ਯੀਸ਼ੁਰਾਕ੍ਰਮ੍ਯ ਦਘ੍ਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ਤਤੋ ਯੀਸ਼ੋਃ ਸਙ੍ਗਿਨਾਮੇਕਃ ਕਰੰ ਪ੍ਰਸਾਰ੍ੱਯ ਕੋਸ਼਼ਾਦਸਿੰ ਬਹਿਸ਼਼੍ਕ੍ਰੁʼਤ੍ਯ ਮਹਾਯਾਜਕਸ੍ਯ ਦਾਸਮੇਕਮਾਹਤ੍ਯ ਤਸ੍ਯ ਕਰ੍ਣੰ ਚਿੱਛੇਦ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","ਤਤੋ ਯੀਸ਼ੁਸ੍ਤੰ ਜਗਾਦ, ਖਡ੍ਗੰ ਸ੍ਵਸ੍ਥਾਨੇे ਨਿਧੇਹਿ ਯਤੋ ਯੇ ਯੇ ਜਨਾ ਅਸਿੰ ਧਾਰਯਨ੍ਤਿ, ਤਏਵਾਸਿਨਾ ਵਿਨਸ਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","ਅਪਰੰ ਪਿਤਾ ਯਥਾ ਮਦਨ੍ਤਿਕੰ ਸ੍ਵਰ੍ਗੀਯਦੂਤਾਨਾਂ ਦ੍ਵਾਦਸ਼ਵਾਹਿਨੀਤੋ(ਅ)ਧਿਕੰ ਪ੍ਰਹਿਣੁਯਾਤ੍ ਮਯਾ ਤਮੁੱਦਿਸ਼੍ਯੇਦਾਨੀਮੇਵ ਤਥਾ ਪ੍ਰਾਰ੍ਥਯਿਤੁੰ ਨ ਸ਼ਕ੍ਯਤੇ, ਤ੍ਵਯਾ ਕਿਮਿੱਥੰ ਜ੍ਞਾਯਤੇ? ");
INSERT INTO sanpun_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","ਤਥਾ ਸਤੀੱਥੰ ਘਟਿਸ਼਼੍ਯਤੇ ਧਰ੍ੰਮਪੁਸ੍ਤਕਸ੍ਯ ਯਦਿਦੰ ਵਾਕ੍ਯੰ ਤਤ੍ ਕਥੰ ਸਿਧ੍ਯੇਤ੍? ");
INSERT INTO sanpun_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","ਤਦਾਨੀਂ ਯੀਸ਼ੁ ਰ੍ਜਨਨਿਵਹੰ ਜਗਾਦ, ਯੂਯੰ ਖਡ੍ਗਯਸ਼਼੍ਟੀਨ੍ ਆਦਾਯ ਮਾਂ ਕਿੰ ਚੌਰੰ ਧਰ੍ੱਤੁਮਾਯਾਤਾਃ? ਅਹੰ ਪ੍ਰਤ੍ਯਹੰ ਯੁਸ਼਼੍ਮਾਭਿਃ ਸਾਕਮੁਪਵਿਸ਼੍ਯ ਸਮੁਪਾਦਿਸ਼ੰ, ਤਦਾ ਮਾਂ ਨਾਧਰਤ; ");
INSERT INTO sanpun_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","ਕਿਨ੍ਤੁ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਾਂ ਵਾਕ੍ਯਾਨਾਂ ਸੰਸਿੱਧਯੇ ਸਰ੍ੱਵਮੇਤਦਭੂਤ੍| ਤਦਾ ਸਰ੍ੱਵੇ ਸ਼ਿਸ਼਼੍ਯਾਸ੍ਤੰ ਵਿਹਾਯ ਪਲਾਯਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","ਅਨਨ੍ਤਰੰ ਤੇ ਮਨੁਜਾ ਯੀਸ਼ੁੰ ਧ੍ਰੁʼਤ੍ਵਾ ਯਤ੍ਰਾਧ੍ਯਾਪਕਪ੍ਰਾਞ੍ਚਃ ਪਰਿਸ਼਼ਦੰ ਕੁਰ੍ੱਵਨ੍ਤ ਉਪਾਵਿਸ਼ਨ੍ ਤਤ੍ਰ ਕਿਯਫਾਨਾाਮਕਮਹਾਯਾਜਕਸ੍ਯਾਨ੍ਤਿਕੰ ਨਿਨ੍ਯੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ਕਿਨ੍ਤੁ ਸ਼ੇਸ਼਼ੇ ਕਿੰ ਭਵਿਸ਼਼੍ਯਤੀਤਿ ਵੇੱਤੁੰ ਪਿਤਰੋ ਦੂਰੇ ਤਤ੍ਪਸ਼੍ਚਾਦ੍ ਵ੍ਰਜਿਤ੍ਵਾ ਮਹਾਯਾਜਕਸ੍ਯਾੱਟਾਲਿਕਾਂ ਪ੍ਰਵਿਸ਼੍ਯ ਦਾਸੈਃ ਸਹਿਤ ਉਪਾਵਿਸ਼ਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ਤਦਾਨੀਂ ਪ੍ਰਧਾਨਯਾਜਕਪ੍ਰਾਚੀਨਮਨ੍ਤ੍ਰਿਣਃ ਸਰ੍ੱਵੇ ਯੀਸ਼ੁੰ ਹਨ੍ਤੁੰ ਮ੍ਰੁʼਸ਼਼ਾਸਾਕ੍ਸ਼਼੍ਯਮ੍ ਅਲਿਪ੍ਸਨ੍ਤ, ");
INSERT INTO sanpun_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ਕਿਨ੍ਤੁ ਨ ਲੇਭਿਰੇ| ਅਨੇਕੇਸ਼਼ੁ ਮ੍ਰੁʼਸ਼਼ਾਸਾਕ੍ਸ਼਼ਿਸ਼਼੍ਵਾਗਤੇਸ਼਼੍ਵਪਿ ਤੰਨ ਪ੍ਰਾਪੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ਸ਼ੇਸ਼਼ੇ ਦ੍ਵੌ ਮ੍ਰੁʼਸ਼਼ਾਸਾਕ੍ਸ਼਼ਿਣਾਵਾਗਤ੍ਯ ਜਗਦਤੁਃ, ਪੁਮਾਨਯਮਕਥਯਤ੍, ਅਹਮੀਸ਼੍ਵਰਮਨ੍ਦਿਰੰ ਭੰਕ੍ਤ੍ਵਾ ਦਿਨਤ੍ਰਯਮਧ੍ਯੇ ਤੰਨਿਰ੍ੰਮਾਤੁੰ ਸ਼ਕ੍ਨੋਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ਤਦਾ ਮਹਾਯਾਜਕ ਉੱਥਾਯ ਯੀਸ਼ੁਮ੍ ਅਵਾਦੀਤ੍| ਤ੍ਵੰ ਕਿਮਪਿ ਨ ਪ੍ਰਤਿਵਦਸਿ? ਤ੍ਵਾਮਧਿ ਕਿਮੇਤੇ ਸਾਕ੍ਸ਼਼੍ਯੰ ਵਦਨ੍ਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","ਕਿਨ੍ਤੁ ਯੀਸ਼ੁ ਰ੍ਮੌਨੀਭੂਯ ਤਸ੍ਯੌ| ਤਤੋ ਮਹਾਯਾਜਕ ਉਕ੍ਤਵਾਨ੍, ਤ੍ਵਾਮ੍ ਅਮਰੇਸ਼੍ਵਰਨਾਮ੍ਨਾ ਸ਼ਪਯਾਮਿ, ਤ੍ਵਮੀਸ਼੍ਵਰਸ੍ਯ ਪੁਤ੍ਰੋ(ਅ)ਭਿਸ਼਼ਿਕ੍ਤੋ ਭਵਸਿ ਨਵੇਤਿ ਵਦ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯਵਦਤ੍, ਤ੍ਵੰ ਸਤ੍ਯਮੁਕ੍ਤਵਾਨ੍; ਅਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਤਥ੍ਯੰ ਵਦਾਮਿ, ਇਤਃਪਰੰ ਮਨੁਜਸੁਤੰ ਸਰ੍ੱਵਸ਼ਕ੍ਤਿਮਤੋ ਦਕ੍ਸ਼਼ਿਣਪਾਰ੍ਸ਼੍ਵੇ ਸ੍ਥਾਤੁੰ ਗਗਣਸ੍ਥੰ ਜਲਧਰਾਨਾਰੁਹ੍ਯਾਯਾਨ੍ਤੰ ਵੀਕ੍ਸ਼਼ਧ੍ਵੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ਤਦਾ ਮਹਾਯਾਜਕੋ ਨਿਜਵਸਨੰ ਛਿੱਤ੍ਵਾ ਜਗਾਦ, ਏਸ਼਼ ਈਸ਼੍ਵਰੰ ਨਿਨ੍ਦਿਤਵਾਨ੍, ਅਸ੍ਮਾਕਮਪਰਸਾਕ੍ਸ਼਼੍ਯੇਣ ਕਿੰ ਪ੍ਰਯੋਜਨੰ? ਪਸ਼੍ਯਤ, ਯੂਯਮੇਵਾਸ੍ਯਾਸ੍ਯਾਦ੍ ਈਸ਼੍ਵਰਨਿਨ੍ਦਾਂ ਸ਼੍ਰੁਤਵਨ੍ਤਃ, ");
INSERT INTO sanpun_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","ਯੁਸ਼਼੍ਮਾਭਿਃ ਕਿੰ ਵਿਵਿਚ੍ਯਤੇ? ਤੇ ਪ੍ਰਤ੍ਯੂਚੁਃ, ਵਧਾਰ੍ਹੋ(ਅ)ਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ਤਤੋ ਲੋਕੈਸ੍ਤਦਾਸ੍ਯੇ ਨਿਸ਼਼੍ਠੀਵਿਤੰ ਕੇਚਿਤ੍ ਪ੍ਰਤਲਮਾਹਤ੍ਯ ਕੇਚਿੱਚ ਚਪੇਟਮਾਹਤ੍ਯ ਬਭਾਸ਼਼ਿਰੇ, ");
INSERT INTO sanpun_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ਹੇ ਖ੍ਰੀਸ਼਼੍ਟ ਤ੍ਵਾਂ ਕਸ਼੍ਚਪੇਟਮਾਹਤਵਾਨ੍? ਇਤਿ ਗਣਯਿਤ੍ਵਾ ਵਦਾਸ੍ਮਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ਪਿਤਰੋ ਬਹਿਰਙ੍ਗਨ ਉਪਵਿਸ਼ਤਿ, ਤਦਾਨੀਮੇਕਾ ਦਾਸੀ ਤਮੁਪਾਗਤ੍ਯ ਬਭਾਸ਼਼ੇ, ਤ੍ਵੰ ਗਾਲੀਲੀਯਯੀਸ਼ੋਃ ਸਹਚਰਏਕਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","ਕਿਨ੍ਤੁ ਸ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਸਮਕ੍ਸ਼਼ਮ੍ ਅਨਙ੍ਗੀਕ੍ਰੁʼਤ੍ਯਾਵਾਦੀਤ੍, ਤ੍ਵਯਾ ਯਦੁਚ੍ਯਤੇ, ਤਦਰ੍ਥਮਹੰ ਨ ਵੇਦ੍ਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ਤਦਾ ਤਸ੍ਮਿਨ੍ ਬਹਿਰ੍ਦ੍ਵਾਰੰ ਗਤੇ (ਅ)ਨ੍ਯਾ ਦਾਸੀ ਤੰ ਨਿਰੀਕ੍ਸ਼਼੍ਯ ਤਤ੍ਰਤ੍ਯਜਨਾਨਵਦਤ੍, ਅਯਮਪਿ ਨਾਸਰਤੀਯਯੀਸ਼ੁਨਾ ਸਾਰ੍ੱਧਮ੍ ਆਸੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ਤਤਃ ਸ ਸ਼ਪਥੇਨ ਪੁਨਰਨਙ੍ਗੀਕ੍ਰੁʼਤ੍ਯ ਕਥਿਤਵਾਨ੍, ਤੰ ਨਰੰ ਨ ਪਰਿਚਿਨੋਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ਕ੍ਸ਼਼ਣਾਤ੍ ਪਰੰ ਤਿਸ਼਼੍ਠਨ੍ਤੋ ਜਨਾ ਏਤ੍ਯ ਪਿਤਰਮ੍ ਅਵਦਨ੍, ਤ੍ਵਮਵਸ਼੍ਯੰ ਤੇਸ਼਼ਾਮੇਕ ਇਤਿ ਤ੍ਵਦੁੱਚਾਰਣਮੇਵ ਦ੍ਯੋਤਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","ਕਿਨ੍ਤੁ ਸੋ(ਅ)ਭਿਸ਼ਪ੍ਯ ਕਥਿਤਵਾਨ੍, ਤੰ ਜਨੰ ਨਾਹੰ ਪਰਿਚਿਨੋਮਿ, ਤਦਾ ਸਪਦਿ ਕੁੱਕੁਟੋ ਰੁਰਾਵ| ");
INSERT INTO sanpun_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ਕੁੱਕੁਟਰਵਾਤ੍ ਪ੍ਰਾਕ੍ ਤ੍ਵੰ ਮਾਂ ਤ੍ਰਿਰਪਾਹ੍ਨੋਸ਼਼੍ਯਸੇ, ਯੈਸ਼਼ਾ ਵਾਗ੍ ਯੀਸ਼ੁਨਾਵਾਦਿ ਤਾਂ ਪਿਤਰਃ ਸੰਸ੍ਮ੍ਰੁʼਤ੍ਯ ਬਹਿਰਿਤ੍ਵਾ ਖੇਦਾਦ੍ ਭ੍ਰੁʼਸ਼ੰ ਚਕ੍ਰਨ੍ਦ| ");
INSERT INTO sanpun_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ਪ੍ਰਭਾਤੇ ਜਾਤੇ ਪ੍ਰਧਾਨਯਾਜਕਲੋਕਪ੍ਰਾਚੀਨਾ ਯੀਸ਼ੁੰ ਹਨ੍ਤੁੰ ਤਤ੍ਪ੍ਰਤਿਕੂਲੰ ਮਨ੍ਤ੍ਰਯਿਤ੍ਵਾ ");
INSERT INTO sanpun_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ਤੰ ਬਦ੍ੱਵਾ ਨੀਤ੍ਵਾ ਪਨ੍ਤੀਯਪੀਲਾਤਾਖ੍ਯਾਧਿਪੇ ਸਮਰ੍ਪਯਾਮਾਸੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","ਤਤੋ ਯੀਸ਼ੋਃ ਪਰਕਰੇੱਵਰ੍ਪਯਿਤਾ ਯਿਹੂਦਾਸ੍ਤਤ੍ਪ੍ਰਾਣਾਦਣ੍ਡਾਜ੍ਞਾਂ ਵਿਦਿਤ੍ਵਾ ਸਨ੍ਤਪ੍ਤਮਨਾਃ ਪ੍ਰਧਾਨਯਾਜਕਲੋਕਪ੍ਰਾਚੀਨਾਨਾਂ ਸਮਕ੍ਸ਼਼ੰ ਤਾਸ੍ਤ੍ਰੀਂਸ਼ਨ੍ਮੁਦ੍ਰਾਃ ਪ੍ਰਤਿਦਾਯਾਵਾਦੀਤ੍, ");
INSERT INTO sanpun_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ਏਤੰਨਿਰਾਗੋਨਰਪ੍ਰਾਣਪਰਕਰਾਰ੍ਪਣਾਤ੍ ਕਲੁਸ਼਼ੰ ਕ੍ਰੁʼਤਵਾਨਹੰ| ਤਦਾ ਤ ਉਦਿਤਵਨ੍ਤਃ, ਤੇਨਾਸ੍ਮਾਕੰ ਕਿੰ? ਤ੍ਵਯਾ ਤਦ੍ ਬੁਧ੍ਯਤਾਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ਤਤੋ ਯਿਹੂਦਾ ਮਨ੍ਦਿਰਮਧ੍ਯੇ ਤਾ ਮੁਦ੍ਰਾ ਨਿਕ੍ਸ਼਼ਿਪ੍ਯ ਪ੍ਰਸ੍ਥਿਤਵਾਨ੍ ਇਤ੍ਵਾ ਚ ਸ੍ਵਯਮਾਤ੍ਮਾਨਮੁਦ੍ਬਬਨ੍ਧ| ");
INSERT INTO sanpun_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","ਪਸ਼੍ਚਾਤ੍ ਪ੍ਰਧਾਨਯਾਜਕਾਸ੍ਤਾ ਮੁਦ੍ਰਾ ਆਦਾਯ ਕਥਿਤਵਨ੍ਤਃ, ਏਤਾ ਮੁਦ੍ਰਾਃ ਸ਼ੋਣਿਤਮੂਲ੍ਯੰ ਤਸ੍ਮਾਦ੍ ਭਾਣ੍ਡਾਗਾਰੇ ਨ ਨਿਧਾਤਵ੍ਯਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ਅਨਨ੍ਤਰੰ ਤੇ ਮਨ੍ਤ੍ਰਯਿਤ੍ਵਾ ਵਿਦੇਸ਼ਿਨਾਂ ਸ਼੍ਮਸ਼ਾਨਸ੍ਥਾਨਾਯ ਤਾਭਿਃ ਕੁਲਾਲਸ੍ਯ ਕ੍ਸ਼਼ੇਤ੍ਰਮਕ੍ਰੀਣਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ਅਤੋ(ਅ)ਦ੍ਯਾਪਿ ਤਤ੍ਸ੍ਥਾਨੰ ਰਕ੍ਤਕ੍ਸ਼਼ੇਤ੍ਰੰ ਵਦਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ਇੱਥੰ ਸਤਿ ਇਸ੍ਰਾਯੇਲੀਯਸਨ੍ਤਾਨੈ ਰ੍ਯਸ੍ਯ ਮੂਲ੍ਯੰ ਨਿਰੁਪਿਤੰ, ਤਸ੍ਯ ਤ੍ਰਿੰਸ਼ਨ੍ਮੁਦ੍ਰਾਮਾਨੰ ਮੂਲ੍ਯੰ ");
INSERT INTO sanpun_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ਮਾਂ ਪ੍ਰਤਿ ਪਰਮੇਸ਼੍ਵਰਸ੍ਯਾਦੇਸ਼ਾਤ੍ ਤੇਭ੍ਯ ਆਦੀਯਤ, ਤੇਨ ਚ ਕੁਲਾਲਸ੍ਯ ਕ੍ਸ਼਼ੇਤ੍ਰੰ ਕ੍ਰੀਤਮਿਤਿ ਯਦ੍ਵਚਨੰ ਯਿਰਿਮਿਯਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਾ ਪ੍ਰੋਕ੍ਤੰ ਤਤ੍ ਤਦਾਸਿਧ੍ਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ਅਨਨ੍ਤਰੰ ਯੀਸ਼ੌ ਤਦਧਿਪਤੇਃ ਸੰਮੁਖ ਉਪਤਿਸ਼਼੍ਠਤਿ ਸ ਤੰ ਪਪ੍ਰੱਛ, ਤ੍ਵੰ ਕਿੰ ਯਿਹੂਦੀਯਾਨਾਂ ਰਾਜਾ? ਤਦਾ ਯੀਸ਼ੁਸ੍ਤਮਵਦਤ੍, ਤ੍ਵੰ ਸਤ੍ਯਮੁਕ੍ਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","ਕਿਨ੍ਤੁ ਪ੍ਰਧਾਨਯਾਜਕਪ੍ਰਾਚੀਨੈਰਭਿਯੁਕ੍ਤੇਨ ਤੇਨ ਕਿਮਪਿ ਨ ਪ੍ਰਤ੍ਯਵਾਦਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","ਤਤਃ ਪੀਲਾਤੇਨ ਸ ਉਦਿਤਃ, ਇਮੇ ਤ੍ਵਤ੍ਪ੍ਰਤਿਕੂਲਤਃ ਕਤਿ ਕਤਿ ਸਾਕ੍ਸ਼਼੍ਯੰ ਦਦਤਿ, ਤਤ੍ ਤ੍ਵੰ ਨ ਸ਼੍ਰੁʼਣੋਸ਼਼ਿ? ");
INSERT INTO sanpun_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","ਤਥਾਪਿ ਸ ਤੇਸ਼਼ਾਮੇਕਸ੍ਯਾਪਿ ਵਚਸ ਉੱਤਰੰ ਨੋਦਿਤਵਾਨ੍; ਤੇਨ ਸੋ(ਅ)ਧਿਪਤਿ ਰ੍ਮਹਾਚਿਤ੍ਰੰ ਵਿਦਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","ਅਨ੍ਯੱਚ ਤਨ੍ਮਹਕਾਲੇ(ਅ)ਧਿਪਤੇਰੇਤਾਦ੍ਰੁʼਸ਼ੀ ਰਾਤਿਰਾਸੀਤ੍, ਪ੍ਰਜਾ ਯੰ ਕਞ੍ਚਨ ਬਨ੍ਧਿਨੰ ਯਾਚਨ੍ਤੇ, ਤਮੇਵ ਸ ਮੋਚਯਤੀਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ਤਦਾਨੀਂ ਬਰੱਬਾਨਾਮਾ ਕਸ਼੍ਚਿਤ੍ ਖ੍ਯਾਤਬਨ੍ਧ੍ਯਾਸੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ਤਤਃ ਪੀਲਾਤਸ੍ਤਤ੍ਰ ਮਿਲਿਤਾਨ੍ ਲੋਕਾਨ੍ ਅਪ੍ਰੁʼੱਛਤ੍, ਏਸ਼਼ ਬਰੱਬਾ ਬਨ੍ਧੀ ਖ੍ਰੀਸ਼਼੍ਟਵਿਖ੍ਯਾਤੋ ਯੀਸ਼ੁਸ਼੍ਚੈਤਯੋਃ ਕੰ ਮੋਚਯਿਸ਼਼੍ਯਾਮਿ? ਯੁਸ਼਼੍ਮਾਕੰ ਕਿਮੀਪ੍ਸਿਤੰ? ");
INSERT INTO sanpun_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","ਤੈਰੀਰ੍ਸ਼਼੍ਯਯਾ ਸ ਸਮਰ੍ਪਿਤ ਇਤਿ ਸ ਜ੍ਞਾਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ਅਪਰੰ ਵਿਚਾਰਾਸਨੋਪਵੇਸ਼ਨਕਾਲੇ ਪੀਲਾਤਸ੍ਯ ਪਤ੍ਨੀ ਭ੍ਰੁʼਤ੍ਯੰ ਪ੍ਰਹਿਤ੍ਯ ਤਸ੍ਮੈ ਕਥਯਾਮਾਸ, ਤੰ ਧਾਰ੍ੰਮਿਕਮਨੁਜੰ ਪ੍ਰਤਿ ਤ੍ਵਯਾ ਕਿਮਪਿ ਨ ਕਰ੍ੱਤਵ੍ਯੰ; ਯਸ੍ਮਾਤ੍ ਤਤ੍ਕ੍ਰੁʼਤੇ(ਅ)ਦ੍ਯਾਹੰ ਸ੍ਵਪ੍ਨੇ ਪ੍ਰਭੂਤਕਸ਼਼੍ਟਮਲਭੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","ਅਨਨ੍ਤਰੰ ਪ੍ਰਧਾਨਯਾਜਕਪ੍ਰਾਚੀਨਾ ਬਰੱਬਾਂ ਯਾਚਿਤ੍ਵਾਦਾਤੁੰ ਯੀਸ਼ੁਞ੍ਚ ਹਨ੍ਤੁੰ ਸਕਲਲੋਕਾਨ੍ ਪ੍ਰਾਵਰ੍ੱਤਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ਤਤੋ(ਅ)ਧਿਪਤਿਸ੍ਤਾਨ੍ ਪ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍, ਏਤਯੋਃ ਕਮਹੰ ਮੋਚਯਿਸ਼਼੍ਯਾਮਿ? ਯੁਸ਼਼੍ਮਾਕੰ ਕੇੱਛਾ? ਤੇ ਪ੍ਰੋਚੁ ਰ੍ਬਰੱਬਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ਤਦਾ ਪੀਲਾਤਃ ਪਪ੍ਰੱਛ, ਤਰ੍ਹਿ ਯੰ ਖ੍ਰੀਸ਼਼੍ਟੰ ਵਦਨ੍ਤਿ, ਤੰ ਯੀਸ਼ੁੰ ਕਿੰ ਕਰਿਸ਼਼੍ਯਾਮਿ? ਸਰ੍ੱਵੇ ਕਥਯਾਮਾਸੁਃ, ਸ ਕ੍ਰੁਸ਼ੇਨ ਵਿਧ੍ਯਤਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ਤਤੋ(ਅ)ਧਿਪਤਿਰਵਾਦੀਤ੍, ਕੁਤਃ? ਕਿੰ ਤੇਨਾਪਰਾੱਧੰ? ਕਿਨ੍ਤੁ ਤੇ ਪੁਨਰੁਚੈ ਰ੍ਜਗਦੁਃ, ਸ ਕ੍ਰੁਸ਼ੇਨ ਵਿਧ੍ਯਤਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ਤਦਾ ਨਿਜਵਾਕ੍ਯਮਗ੍ਰਾਹ੍ਯਮਭੂਤ੍, ਕਲਹਸ਼੍ਚਾਪ੍ਯਭੂਤ੍, ਪੀਲਾਤ ਇਤਿ ਵਿਲੋਕ੍ਯ ਲੋਕਾਨਾਂ ਸਮਕ੍ਸ਼਼ੰ ਤੋਯਮਾਦਾਯ ਕਰੌ ਪ੍ਰਕ੍ਸ਼਼ਾਲ੍ਯਾਵੋਚਤ੍, ਏਤਸ੍ਯ ਧਾਰ੍ੰਮਿਕਮਨੁਸ਼਼੍ਯਸ੍ਯ ਸ਼ੋਣਿਤਪਾਤੇ ਨਿਰ੍ਦੋਸ਼਼ੋ(ਅ)ਹੰ, ਯੁਸ਼਼੍ਮਾਭਿਰੇਵ ਤਦ੍ ਬੁਧ੍ਯਤਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ਤਦਾ ਸਰ੍ੱਵਾਃ ਪ੍ਰਜਾਃ ਪ੍ਰਤ੍ਯਵੋਚਨ੍, ਤਸ੍ਯ ਸ਼ੋਣਿਤਪਾਤਾਪਰਾਧੋ(ਅ)ਸ੍ਮਾਕਮ੍ ਅਸ੍ਮਤ੍ਸਨ੍ਤਾਨਾਨਾਞ੍ਚੋਪਰਿ ਭਵਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","ਤਤਃ ਸ ਤੇਸ਼਼ਾਂ ਸਮੀਪੇ ਬਰੱਬਾਂ ਮੋਚਯਾਮਾਸ ਯੀਸ਼ੁਨ੍ਤੁ ਕਸ਼਼ਾਭਿਰਾਹਤ੍ਯ ਕ੍ਰੁਸ਼ੇਨ ਵੇਧਿਤੁੰ ਸਮਰ੍ਪਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","ਅਨਨ੍ਤਰਮ੍ ਅਧਿਪਤੇਃ ਸੇਨਾ ਅਧਿਪਤੇ ਰ੍ਗ੍ਰੁʼਹੰ ਯੀਸ਼ੁਮਾਨੀਯ ਤਸ੍ਯ ਸਮੀਪੇ ਸੇਨਾਸਮੂਹੰ ਸੰਜਗ੍ਰੁʼਹੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ਤਤਸ੍ਤੇ ਤਸ੍ਯ ਵਸਨੰ ਮੋਚਯਿਤ੍ਵਾ ਕ੍ਰੁʼਸ਼਼੍ਣਲੋਹਿਤਵਰ੍ਣਵਸਨੰ ਪਰਿਧਾਪਯਾਮਾਸੁਃ ");
INSERT INTO sanpun_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ਕਣ੍ਟਕਾਨਾਂ ਮੁਕੁਟੰ ਨਿਰ੍ੰਮਾਯ ਤੱਛਿਰਸਿ ਦਦੁਃ, ਤਸ੍ਯ ਦਕ੍ਸ਼਼ਿਣਕਰੇ ਵੇਤ੍ਰਮੇਕੰ ਦੱਤ੍ਵਾ ਤਸ੍ਯ ਸੰਮੁਖੇ ਜਾਨੂਨਿ ਪਾਤਯਿਤ੍ਵਾ, ਹੇ ਯਿਹੂਦੀਯਾਨਾਂ ਰਾਜਨ੍, ਤੁਭ੍ਯੰ ਨਮ ਇਤ੍ਯੁਕ੍ਤ੍ਵਾ ਤੰ ਤਿਰਸ਼੍ਚਕ੍ਰੁਃ, ");
INSERT INTO sanpun_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ਤਤਸ੍ਤਸ੍ਯ ਗਾਤ੍ਰੇ ਨਿਸ਼਼੍ਠੀਵੰ ਦਤ੍ਵਾ ਤੇਨ ਵੇਤ੍ਰੇਣ ਸ਼ਿਰ ਆਜਘ੍ਨੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ਇੱਥੰ ਤੰ ਤਿਰਸ੍ਕ੍ਰੁʼਤ੍ਯ ਤਦ੍ ਵਸਨੰ ਮੋਚਯਿਤ੍ਵਾ ਪੁਨਰ੍ਨਿਜਵਸਨੰ ਪਰਿਧਾਪਯਾਞ੍ਚਕ੍ਰੁਃ, ਤੰ ਕ੍ਰੁਸ਼ੇਨ ਵੇਧਿਤੁੰ ਨੀਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ਪਸ਼੍ਚਾੱਤੇ ਬਹਿਰ੍ਭੂਯ ਕੁਰੀਣੀਯੰ ਸ਼ਿਮੋੰਨਾਮਕਮੇਕੰ ਵਿਲੋਕ੍ਯ ਕ੍ਰੁਸ਼ੰ ਵੋਢੁੰ ਤਮਾਦਦਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ਅਨਨ੍ਤਰੰ ਗੁਲ੍ਗਲ੍ਤਾਮ੍ ਅਰ੍ਥਾਤ੍ ਸ਼ਿਰਸ੍ਕਪਾਲਨਾਮਕਸ੍ਥਾਨਮੁ ਪਸ੍ਥਾਯ ਤੇ ਯੀਸ਼ਵੇ ਪਿੱਤਮਿਸ਼੍ਰਿਤਾਮ੍ਲਰਸੰ ਪਾਤੁੰ ਦਦੁਃ, ");
INSERT INTO sanpun_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ਕਿਨ੍ਤੁ ਸ ਤਮਾਸ੍ਵਾਦ੍ਯ ਨ ਪਪੌ| ");
INSERT INTO sanpun_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ਤਦਾਨੀਂ ਤੇ ਤੰ ਕ੍ਰੁਸ਼ੇਨ ਸੰਵਿਧ੍ਯ ਤਸ੍ਯ ਵਸਨਾਨਿ ਗੁਟਿਕਾਪਾਤੇਨ ਵਿਭਜ੍ਯ ਜਗ੍ਰੁʼਹੁਃ, ਤਸ੍ਮਾਤ੍, ਵਿਭਜਨ੍ਤੇ(ਅ)ਧਰੀਯੰ ਮੇ ਤੇ ਮਨੁਸ਼਼੍ਯਾਃ ਪਰਸ੍ਪਰੰ| ਮਦੁੱਤਰੀਯਵਸ੍ਤ੍ਰਾਰ੍ਥੰ ਗੁਟਿਕਾਂ ਪਾਤਯਨ੍ਤਿ ਚ|| ਯਦੇਤਦ੍ਵਚਨੰ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਭਿਰੁਕ੍ਤਮਾਸੀਤ੍, ਤਦਾ ਤਦ੍ ਅਸਿਧ੍ਯਤ੍, ");
INSERT INTO sanpun_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ਪਸ਼੍ਚਾਤ੍ ਤੇ ਤਤ੍ਰੋਪਵਿਸ਼੍ਯ ਤਦ੍ਰਕ੍ਸ਼਼ਣਕਰ੍ੱਵਣਿ ਨਿਯੁਕ੍ਤਾਸ੍ਤਸ੍ਥੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ਅਪਰਮ੍ ਏਸ਼਼ ਯਿਹੂਦੀਯਾਨਾਂ ਰਾਜਾ ਯੀਸ਼ੁਰਿਤ੍ਯਪਵਾਦਲਿਪਿਪਤ੍ਰੰ ਤੱਛਿਰਸ ਊਰ੍ਦ੍ੱਵੇ ਯੋਜਯਾਮਾਸੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ਤਤਸ੍ਤਸ੍ਯ ਵਾਮੇ ਦਕ੍ਸ਼਼ਿਣੇ ਚ ਦ੍ਵੌ ਚੈਰੌ ਤੇਨ ਸਾਕੰ ਕ੍ਰੁਸ਼ੇਨ ਵਿਵਿਧੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","ਤਦਾ ਪਾਨ੍ਥਾ ਨਿਜਸ਼ਿਰੋ ਲਾਡਯਿਤ੍ਵਾ ਤੰ ਨਿਨ੍ਦਨ੍ਤੋ ਜਗਦੁਃ, ");
INSERT INTO sanpun_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ਹੇ ਈਸ਼੍ਵਰਮਨ੍ਦਿਰਭਞ੍ਜਕ ਦਿਨਤ੍ਰਯੇ ਤੰਨਿਰ੍ੰਮਾਤਃ ਸ੍ਵੰ ਰਕ੍ਸ਼਼, ਚੇੱਤ੍ਵਮੀਸ਼੍ਵਰਸੁਤਸ੍ਤਰ੍ਹਿ ਕ੍ਰੁਸ਼ਾਦਵਰੋਹ| ");
INSERT INTO sanpun_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ਪ੍ਰਧਾਨਯਾਜਕਾਧ੍ਯਾਪਕਪ੍ਰਾਚੀਨਾਸ਼੍ਚ ਤਥਾ ਤਿਰਸ੍ਕ੍ਰੁʼਤ੍ਯ ਜਗਦੁਃ, ");
INSERT INTO sanpun_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","ਸੋ(ਅ)ਨ੍ਯਜਨਾਨਾਵਤ੍, ਕਿਨ੍ਤੁ ਸ੍ਵਮਵਿਤੁੰ ਨ ਸ਼ਕ੍ਨੋਤਿ| ਯਦੀਸ੍ਰਾਯੇਲੋ ਰਾਜਾ ਭਵੇਤ੍, ਤਰ੍ਹੀਦਾਨੀਮੇਵ ਕ੍ਰੁਸ਼ਾਦਵਰੋਹਤੁ, ਤੇਨ ਤੰ ਵਯੰ ਪ੍ਰਤ੍ਯੇਸ਼਼੍ਯਾਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ਸ ਈਸ਼੍ਵਰੇ ਪ੍ਰਤ੍ਯਾਸ਼ਾਮਕਰੋਤ੍, ਯਦੀਸ਼੍ਵਰਸ੍ਤਸ੍ਮਿਨ੍ ਸਨ੍ਤੁਸ਼਼੍ਟਸ੍ਤਰ੍ਹੀਦਾਨੀਮੇਵ ਤਮਵੇਤ੍, ਯਤਃ ਸ ਉਕ੍ਤਵਾਨ੍ ਅਹਮੀਸ਼੍ਵਰਸੁਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ਯੌ ਸ੍ਤੇਨੌ ਸਾਕੰ ਤੇਨ ਕ੍ਰੁਸ਼ੇਨ ਵਿੱਧੌ ਤੌ ਤਦ੍ਵਦੇਵ ਤੰ ਨਿਨਿਨ੍ਦਤੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","ਤਦਾ ਦ੍ਵਿਤੀਯਯਾਮਾਤ੍ ਤ੍ਰੁʼਤੀਯਯਾਮੰ ਯਾਵਤ੍ ਸਰ੍ੱਵਦੇਸ਼ੇ ਤਮਿਰੰ ਬਭੂਵ, ");
INSERT INTO sanpun_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ਤ੍ਰੁʼਤੀਯਯਾਮੇ \"ਏਲੀ ਏਲੀ ਲਾਮਾ ਸ਼ਿਵਕ੍ਤਨੀ\", ਅਰ੍ਥਾਤ੍ ਮਦੀਸ਼੍ਵਰ ਮਦੀਸ਼੍ਵਰ ਕੁਤੋ ਮਾਮਤ੍ਯਾਕ੍ਸ਼਼ੀਃ? ਯੀਸ਼ੁਰੁੱਚੈਰਿਤਿ ਜਗਾਦ| ");
INSERT INTO sanpun_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ਤਦਾ ਤਤ੍ਰ ਸ੍ਥਿਤਾਃ ਕੇਚਿਤ੍ ਤਤ੍ ਸ਼੍ਰੁਤ੍ਵਾ ਬਭਾਸ਼਼ਿਰੇ, ਅਯਮ੍ ਏਲਿਯਮਾਹੂਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ਤੇਸ਼਼ਾਂ ਮਧ੍ਯਾਦ੍ ਏਕਃ ਸ਼ੀਘ੍ਰੰ ਗਤ੍ਵਾ ਸ੍ਪਞ੍ਜੰ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਤਤ੍ਰਾਮ੍ਲਰਸੰ ਦੱਤ੍ਵਾ ਨਲੇਨ ਪਾਤੁੰ ਤਸ੍ਮੈ ਦਦੌ| ");
INSERT INTO sanpun_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ਇਤਰੇ(ਅ)ਕਥਯਨ੍ ਤਿਸ਼਼੍ਠਤ, ਤੰ ਰਕ੍ਸ਼਼ਿਤੁਮ੍ ਏਲਿਯ ਆਯਾਤਿ ਨਵੇਤਿ ਪਸ਼੍ਯਾਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","ਯੀਸ਼ੁਃ ਪੁਨਰੁਚੈਰਾਹੂਯ ਪ੍ਰਾਣਾਨ੍ ਜਹੌ| ");
INSERT INTO sanpun_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","ਤਤੋ ਮਨ੍ਦਿਰਸ੍ਯ ਵਿੱਛੇਦਵਸਨਮ੍ ਊਰ੍ਦ੍ੱਵਾਦਧੋ ਯਾਵਤ੍ ਛਿਦ੍ਯਮਾਨੰ ਦ੍ਵਿਧਾਭਵਤ੍, ");
INSERT INTO sanpun_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ਭੂਮਿਸ਼੍ਚਕਮ੍ਪੇ ਭੂਧਰੋਵ੍ਯਦੀਰ੍ੱਯਤ ਚ| ਸ਼੍ਮਸ਼ਾਨੇ ਮੁਕ੍ਤੇ ਭੂਰਿਪੁਣ੍ਯਵਤਾਂ ਸੁਪ੍ਤਦੇਹਾ ਉਦਤਿਸ਼਼੍ਠਨ੍, ");
INSERT INTO sanpun_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ਸ਼੍ਮਸ਼ਾਨਾਦ੍ ਵਹਿਰ੍ਭੂਯ ਤਦੁੱਥਾਨਾਤ੍ ਪਰੰ ਪੁਣ੍ਯਪੁਰੰ ਗਤ੍ਵਾ ਬਹੁਜਨਾਨ੍ ਦਰ੍ਸ਼ਯਾਮਾਸੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ਯੀਸ਼ੁਰਕ੍ਸ਼਼ਣਾਯ ਨਿਯੁਕ੍ਤਃ ਸ਼ਤਸੇਨਾਪਤਿਸ੍ਤਤ੍ਸਙ੍ਗਿਨਸ਼੍ਚ ਤਾਦ੍ਰੁʼਸ਼ੀਂ ਭੂਕਮ੍ਪਾਦਿਘਟਨਾਂ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਭੀਤਾ ਅਵਦਨ੍, ਏਸ਼਼ ਈਸ਼੍ਵਰਪੁਤ੍ਰੋ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ਯਾ ਬਹੁਯੋਸ਼਼ਿਤੋ ਯੀਸ਼ੁੰ ਸੇਵਮਾਨਾ ਗਾਲੀਲਸ੍ਤਤ੍ਪਸ਼੍ਚਾਦਾਗਤਾਸ੍ਤਾਸਾਂ ਮਧ੍ਯੇ ");
INSERT INTO sanpun_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ਮਗ੍ਦਲੀਨੀ ਮਰਿਯਮ੍ ਯਾਕੂਬ੍ਯੋਸ਼੍ਯੋ ਰ੍ਮਾਤਾ ਯਾ ਮਰਿਯਮ੍ ਸਿਬਦਿਯਪੁਤ੍ਰਯੋ ਰ੍ਮਾਤਾ ਚ ਯੋਸ਼਼ਿਤ ਏਤਾ ਦੂਰੇ ਤਿਸ਼਼੍ਠਨ੍ਤ੍ਯੋ ਦਦ੍ਰੁʼਸ਼ੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","ਸਨ੍ਧ੍ਯਾਯਾਂ ਸਤ੍ਯਮ੍ ਅਰਿਮਥਿਯਾਨਗਰਸ੍ਯ ਯੂਸ਼਼ਫ੍ਨਾਮਾ ਧਨੀ ਮਨੁਜੋ ਯੀਸ਼ੋਃ ਸ਼ਿਸ਼਼੍ਯਤ੍ਵਾਤ੍ ");
INSERT INTO sanpun_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ਪੀਲਾਤਸ੍ਯ ਸਮੀਪੰ ਗਤ੍ਵਾ ਯੀਸ਼ੋਃ ਕਾਯੰ ਯਯਾਚੇ, ਤੇਨ ਪੀਲਾਤਃ ਕਾਯੰ ਦਾਤੁਮ੍ ਆਦਿਦੇਸ਼| ");
INSERT INTO sanpun_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ਯੂਸ਼਼ਫ੍ ਤਤ੍ਕਾਯੰ ਨੀਤ੍ਵਾ ਸ਼ੁਚਿਵਸ੍ਤ੍ਰੇਣਾੱਛਾਦ੍ਯ ");
INSERT INTO sanpun_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ਸ੍ਵਾਰ੍ਥੰ ਸ਼ੈਲੇ ਯਤ੍ ਸ਼੍ਮਸ਼ਾਨੰ ਚਖਾਨ, ਤਨ੍ਮਧ੍ਯੇ ਤਤ੍ਕਾਯੰ ਨਿਧਾਯ ਤਸ੍ਯ ਦ੍ਵਾਰਿ ਵ੍ਰੁʼਹਤ੍ਪਾਸ਼਼ਾਣੰ ਦਦੌ| ");
INSERT INTO sanpun_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","ਕਿਨ੍ਤੁ ਮਗ੍ਦਲੀਨੀ ਮਰਿਯਮ੍ ਅਨ੍ਯਮਰਿਯਮ੍ ਏਤੇ ਸ੍ਤ੍ਰਿਯੌ ਤਤ੍ਰ ਸ਼੍ਮਸ਼ਾਨਸੰਮੁਖ ਉਪਵਿਵਿਸ਼ਤੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","ਤਦਨਨ੍ਤਰੰ ਨਿਸ੍ਤਾਰੋਤ੍ਸਵਸ੍ਯਾਯੋਜਨਦਿਨਾਤ੍ ਪਰੇ(ਅ)ਹਨਿ ਪ੍ਰਧਾਨਯਾਜਕਾਃ ਫਿਰੂਸ਼ਿਨਸ਼੍ਚ ਮਿਲਿਤ੍ਵਾ ਪੀਲਾਤਮੁਪਾਗਤ੍ਯਾਕਥਯਨ੍, ");
INSERT INTO sanpun_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ਹੇ ਮਹੇੱਛ ਸ ਪ੍ਰਤਾਰਕੋ ਜੀਵਨ ਅਕਥਯਤ੍, ਦਿਨਤ੍ਰਯਾਤ੍ ਪਰੰ ਸ਼੍ਮਸ਼ਾਨਾਦੁੱਥਾਸ੍ਯਾਮਿ ਤਦ੍ਵਾਕ੍ਯੰ ਸ੍ਮਰਾਮੋ ਵਯੰ; ");
INSERT INTO sanpun_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ਤਸ੍ਮਾਤ੍ ਤ੍ਰੁʼਤੀਯਦਿਨੰ ਯਾਵਤ੍ ਤਤ੍ ਸ਼੍ਮਸ਼ਾਨੰ ਰਕ੍ਸ਼਼ਿਤੁਮਾਦਿਸ਼ਤੁ, ਨੋਚੇਤ੍ ਤੱਛਿਸ਼਼੍ਯਾ ਯਾਮਿਨ੍ਯਾਮਾਗਤ੍ਯ ਤੰ ਹ੍ਰੁʼਤ੍ਵਾ ਲੋਕਾਨ੍ ਵਦਿਸ਼਼੍ਯਨ੍ਤਿ, ਸ ਸ਼੍ਮਸ਼ਾਨਾਦੁਦਤਿਸ਼਼੍ਠਤ੍, ਤਥਾ ਸਤਿ ਪ੍ਰਥਮਭ੍ਰਾਨ੍ਤੇਃ ਸ਼ੇਸ਼਼ੀਯਭ੍ਰਾਨ੍ਤਿ ਰ੍ਮਹਤੀ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ਤਦਾ ਪੀਲਾਤ ਅਵਾਦੀਤ੍, ਯੁਸ਼਼੍ਮਾਕੰ ਸਮੀਪੇ ਰਕ੍ਸ਼਼ਿਗਣ ਆਸ੍ਤੇ, ਯੂਯੰ ਗਤ੍ਵਾ ਯਥਾ ਸਾਧ੍ਯੰ ਰਕ੍ਸ਼਼ਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ਤਤਸ੍ਤੇ ਗਤ੍ਵਾ ਤੱਦੂाਰਪਾਸ਼਼ਾਣੰ ਮੁਦ੍ਰਾਙ੍ਕਿਤੰ ਕ੍ਰੁʼਤ੍ਵਾ ਰਕ੍ਸ਼਼ਿਗਣੰ ਨਿਯੋਜ੍ਯ ਸ਼੍ਮਸ਼ਾਨੰ ਰਕ੍ਸ਼਼ਯਾਮਾਸੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ਤਤਃ ਪਰੰ ਵਿਸ਼੍ਰਾਮਵਾਰਸ੍ਯ ਸ਼ੇਸ਼਼ੇ ਸਪ੍ਤਾਹਪ੍ਰਥਮਦਿਨਸ੍ਯ ਪ੍ਰਭੋਤੇ ਜਾਤੇ ਮਗ੍ਦਲੀਨੀ ਮਰਿਯਮ੍ ਅਨ੍ਯਮਰਿਯਮ੍ ਚ ਸ਼੍ਮਸ਼ਾਨੰ ਦ੍ਰਸ਼਼੍ਟੁਮਾਗਤਾ| ");
INSERT INTO sanpun_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ਤਦਾ ਮਹਾਨ੍ ਭੂਕਮ੍ਪੋ(ਅ)ਭਵਤ੍; ਪਰਮੇਸ਼੍ਵਰੀਯਦੂਤਃ ਸ੍ਵਰ੍ਗਾਦਵਰੁਹ੍ਯ ਸ਼੍ਮਸ਼ਾਨਦ੍ਵਾਰਾਤ੍ ਪਾਸ਼਼ਾਣਮਪਸਾਰ੍ੱਯ ਤਦੁਪਰ੍ੱਯੁਪਵਿਵੇਸ਼| ");
INSERT INTO sanpun_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ਤਦ੍ਵਦਨੰ ਵਿਦ੍ਯੁਦ੍ਵਤ੍ ਤੇਜੋਮਯੰ ਵਸਨੰ ਹਿਮਸ਼ੁਭ੍ਰਞ੍ਚ| ");
INSERT INTO sanpun_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ਤਦਾਨੀਂ ਰਕ੍ਸ਼਼ਿਣਸ੍ਤਦ੍ਭਯਾਤ੍ ਕਮ੍ਪਿਤਾ ਮ੍ਰੁʼਤਵਦ੍ ਬਭੂਵਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ਸ ਦੂਤੋ ਯੋਸ਼਼ਿਤੋ ਜਗਾਦ, ਯੂਯੰ ਮਾ ਭੈਸ਼਼੍ਟ, ਕ੍ਰੁਸ਼ਹਤਯੀਸ਼ੁੰ ਮ੍ਰੁʼਗਯਧ੍ਵੇ ਤਦਹੰ ਵੇਦ੍ਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ਸੋ(ਅ)ਤ੍ਰ ਨਾਸ੍ਤਿ, ਯਥਾਵਦਤ੍ ਤਥੋੱਥਿਤਵਾਨ੍; ਏਤਤ੍ ਪ੍ਰਭੋਃ ਸ਼ਯਨਸ੍ਥਾਨੰ ਪਸ਼੍ਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ਤੂਰ੍ਣੰ ਗਤ੍ਵਾ ਤੱਛਿਸ਼਼੍ਯਾਨ੍ ਇਤਿ ਵਦਤ, ਸ ਸ਼੍ਮਸ਼ਾਨਾਦ੍ ਉਦਤਿਸ਼਼੍ਠਤ੍, ਯੁਸ਼਼੍ਮਾਕਮਗ੍ਰੇ ਗਾਲੀਲੰ ਯਾਸ੍ਯਤਿ ਯੂਯੰ ਤਤ੍ਰ ਤੰ ਵੀਕ੍ਸ਼਼ਿਸ਼਼੍ਯਧ੍ਵੇ, ਪਸ਼੍ਯਤਾਹੰ ਵਾਰ੍ੱਤਾਮਿਮਾਂ ਯੁਸ਼਼੍ਮਾਨਵਾਦਿਸ਼਼ੰ| ");
INSERT INTO sanpun_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ਤਤਸ੍ਤਾ ਭਯਾਤ੍ ਮਹਾਨਨ੍ਦਾਞ੍ਚ ਸ਼੍ਮਸ਼ਾਨਾਤ੍ ਤੂਰ੍ਣੰ ਬਹਿਰ੍ਭੂਯ ਤੱਛਿਸ਼਼੍ਯਾਨ੍ ਵਾਰ੍ੱਤਾਂ ਵਕ੍ਤੁੰ ਧਾਵਿਤਵਤ੍ਯਃ| ਕਿਨ੍ਤੁ ਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਵਾਰ੍ੱਤਾਂ ਵਕ੍ਤੁੰ ਯਾਨ੍ਤਿ, ਤਦਾ ਯੀਸ਼ੁ ਰ੍ਦਰ੍ਸ਼ਨੰ ਦੱਤ੍ਵਾ ਤਾ ਜਗਾਦ, ");
INSERT INTO sanpun_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ਯੁਸ਼਼੍ਮਾਕੰ ਕਲ੍ਯਾਣੰ ਭੂਯਾਤ੍, ਤਤਸ੍ਤਾ ਆਗਤ੍ਯ ਤਤ੍ਪਾਦਯੋਃ ਪਤਿਤ੍ਵਾ ਪ੍ਰਣੇਮੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","ਯੀਸ਼ੁਸ੍ਤਾ ਅਵਾਦੀਤ੍, ਮਾ ਬਿਭੀਤ, ਯੂਯੰ ਗਤ੍ਵਾ ਮਮ ਭ੍ਰਾਤ੍ਰੁʼਨ੍ ਗਾਲੀਲੰ ਯਾਤੁੰ ਵਦਤ, ਤਤ੍ਰ ਤੇ ਮਾਂ ਦ੍ਰਕ੍ਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","ਸ੍ਤ੍ਰਿਯੋ ਗੱਛਨ੍ਤਿ, ਤਦਾ ਰਕ੍ਸ਼਼ਿਣਾਂ ਕੇਚਿਤ੍ ਪੁਰੰ ਗਤ੍ਵਾ ਯਦ੍ਯਦ੍ ਘਟਿਤੰ ਤਤ੍ਸਰ੍ੱਵੰ ਪ੍ਰਧਾਨਯਾਜਕਾਨ੍ ਜ੍ਞਾਪਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ਤੇ ਪ੍ਰਾਚੀਨੈਃ ਸਮੰ ਸੰਸਦੰ ਕ੍ਰੁʼਤ੍ਵਾ ਮਨ੍ਤ੍ਰਯਨ੍ਤੋ ਬਹੁਮੁਦ੍ਰਾਃ ਸੇਨਾਭ੍ਯੋ ਦੱਤ੍ਵਾਵਦਨ੍, ");
INSERT INTO sanpun_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ਅਸ੍ਮਾਸੁ ਨਿਦ੍ਰਿਤੇਸ਼਼ੁ ਤੱਛਿਸ਼਼੍ਯਾ ਯਾਮਿਨ੍ਯਾਮਾਗਤ੍ਯ ਤੰ ਹ੍ਰੁʼਤ੍ਵਾਨਯਨ੍, ਇਤਿ ਯੂਯੰ ਪ੍ਰਚਾਰਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ਯਦ੍ਯੇਤਦਧਿਪਤੇਃ ਸ਼੍ਰੋਤ੍ਰਗੋਚਰੀਭਵੇਤ੍, ਤਰ੍ਹਿ ਤੰ ਬੋਧਯਿਤ੍ਵਾ ਯੁਸ਼਼੍ਮਾਨਵਿਸ਼਼੍ਯਾਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","ਤਤਸ੍ਤੇ ਮੁਦ੍ਰਾ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਸ਼ਿਕ੍ਸ਼਼ਾਨੁਰੂਪੰ ਕਰ੍ੰਮ ਚਕ੍ਰੁਃ, ਯਿਹੂਦੀਯਾਨਾਂ ਮਧ੍ਯੇ ਤਸ੍ਯਾਦ੍ਯਾਪਿ ਕਿੰਵਦਨ੍ਤੀ ਵਿਦ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ਏਕਾਦਸ਼ ਸ਼ਿਸ਼਼੍ਯਾ ਯੀਸ਼ੁਨਿਰੂਪਿਤਾਗਾਲੀਲਸ੍ਯਾਦ੍ਰਿੰ ਗਤ੍ਵਾ ");
INSERT INTO sanpun_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ਤਤ੍ਰ ਤੰ ਸੰਵੀਕ੍ਸ਼਼੍ਯ ਪ੍ਰਣੇਮੁਃ, ਕਿਨ੍ਤੁ ਕੇਚਿਤ੍ ਸਨ੍ਦਿਗ੍ਧਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ਯੀਸ਼ੁਸ੍ਤੇਸ਼਼ਾਂ ਸਮੀਪਮਾਗਤ੍ਯ ਵ੍ਯਾਹ੍ਰੁʼਤਵਾਨ੍, ਸ੍ਵਰ੍ਗਮੇਦਿਨ੍ਯੋਃ ਸਰ੍ੱਵਾਧਿਪਤਿਤ੍ਵਭਾਰੋ ਮੱਯਰ੍ਪਿਤ ਆਸ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ਅਤੋ ਯੂਯੰ ਪ੍ਰਯਾਯ ਸਰ੍ੱਵਦੇਸ਼ੀਯਾਨ੍ ਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਕ੍ਰੁʼਤ੍ਵਾ ਪਿਤੁਃ ਪੁਤ੍ਰਸ੍ਯ ਪਵਿਤ੍ਰਸ੍ਯਾਤ੍ਮਨਸ਼੍ਚ ਨਾਮ੍ਨਾ ਤਾਨਵਗਾਹਯਤ; ਅਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਯਦ੍ਯਦਾਦਿਸ਼ੰ ਤਦਪਿ ਪਾਲਯਿਤੁੰ ਤਾਨੁਪਾਦਿਸ਼ਤ| ");
INSERT INTO sanpun_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ਪਸ਼੍ਯਤ, ਜਗਦਨ੍ਤੰ ਯਾਵਤ੍ ਸਦਾਹੰ ਯੁਸ਼਼੍ਮਾਭਿਃ ਸਾਕੰ ਤਿਸ਼਼੍ਠਾਮਿ| ਇਤਿ|");
INSERT INTO sanpun_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ਈਸ਼੍ਵਰਪੁਤ੍ਰਸ੍ਯ ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਸੁਸੰਵਾਦਾਰਮ੍ਭਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਾਂ ਗ੍ਰਨ੍ਥੇਸ਼਼ੁ ਲਿਪਿਰਿੱਥਮਾਸ੍ਤੇ, ਪਸ਼੍ਯ ਸ੍ਵਕੀਯਦੂਤਨ੍ਤੁ ਤਵਾਗ੍ਰੇ ਪ੍ਰੇਸ਼਼ਯਾਮ੍ਯਹਮ੍| ਗਤ੍ਵਾ ਤ੍ਵਦੀਯਪਨ੍ਥਾਨੰ ਸ ਹਿ ਪਰਿਸ਼਼੍ਕਰਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","\"ਪਰਮੇਸ਼ਸ੍ਯ ਪਨ੍ਥਾਨੰ ਪਰਿਸ਼਼੍ਕੁਰੁਤ ਸਰ੍ੱਵਤਃ| ਤਸ੍ਯ ਰਾਜਪਥਞ੍ਚੈਵ ਸਮਾਨੰ ਕੁਰੁਤਾਧੁਨਾ| \" ਇਤ੍ਯੇਤਤ੍ ਪ੍ਰਾਨ੍ਤਰੇ ਵਾਕ੍ਯੰ ਵਦਤਃ ਕਸ੍ਯਚਿਦ੍ਰਵਃ|| ");
INSERT INTO sanpun_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","ਸਏਵ ਯੋਹਨ੍ ਪ੍ਰਾਨ੍ਤਰੇ ਮੱਜਿਤਵਾਨ੍ ਤਥਾ ਪਾਪਮਾਰ੍ਜਨਨਿਮਿੱਤੰ ਮਨੋਵ੍ਯਾਵਰ੍ੱਤਕਮੱਜਨਸ੍ਯ ਕਥਾਞ੍ਚ ਪ੍ਰਚਾਰਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ਤਤੋ ਯਿਹੂਦਾਦੇਸ਼ਯਿਰੂਸ਼ਾਲਮ੍ਨਗਰਨਿਵਾਸਿਨਃ ਸਰ੍ੱਵੇ ਲੋਕਾ ਬਹਿ ਰ੍ਭੂਤ੍ਵਾ ਤਸ੍ਯ ਸਮੀਪਮਾਗਤ੍ਯ ਸ੍ਵਾਨਿ ਸ੍ਵਾਨਿ ਪਾਪਾਨ੍ਯਙ੍ਗੀਕ੍ਰੁʼਤ੍ਯ ਯਰ੍ੱਦਨਨਦ੍ਯਾਂ ਤੇਨ ਮੱਜਿਤਾ ਬਭੂਵੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ਅਸ੍ਯ ਯੋਹਨਃ ਪਰਿਧੇਯਾਨਿ ਕ੍ਰਮੇਲਕਲੋਮਜਾਨਿ, ਤਸ੍ਯ ਕਟਿਬਨ੍ਧਨੰ ਚਰ੍ੰਮਜਾਤਮ੍, ਤਸ੍ਯ ਭਕ੍ਸ਼਼੍ਯਾਣਿ ਚ ਸ਼ੂਕਕੀਟਾ ਵਨ੍ਯਮਧੂਨਿ ਚਾਸਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ਸ ਪ੍ਰਚਾਰਯਨ੍ ਕਥਯਾਞ੍ਚਕ੍ਰੇ, ਅਹੰ ਨਮ੍ਰੀਭੂਯ ਯਸ੍ਯ ਪਾਦੁਕਾਬਨ੍ਧਨੰ ਮੋਚਯਿਤੁਮਪਿ ਨ ਯੋਗ੍ਯੋਸ੍ਮਿ, ਤਾਦ੍ਰੁʼਸ਼ੋ ਮੱਤੋ ਗੁਰੁਤਰ ਏਕਃ ਪੁਰੁਸ਼਼ੋ ਮਤ੍ਪਸ਼੍ਚਾਦਾਗੱਛਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ਅਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਜਲੇ ਮੱਜਿਤਵਾਨ੍ ਕਿਨ੍ਤੁ ਸ ਪਵਿਤ੍ਰ ਆਤ੍ਮਾਨਿ ਸੰਮੱਜਯਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","ਅਪਰਞ੍ਚ ਤਸ੍ਮਿੰਨੇਵ ਕਾਲੇ ਗਾਲੀਲ੍ਪ੍ਰਦੇਸ਼ਸ੍ਯ ਨਾਸਰਦ੍ਗ੍ਰਾਮਾਦ੍ ਯੀਸ਼ੁਰਾਗਤ੍ਯ ਯੋਹਨਾ ਯਰ੍ੱਦਨਨਦ੍ਯਾਂ ਮੱਜਿਤੋ(ਅ)ਭੂਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ਸ ਜਲਾਦੁੱਥਿਤਮਾਤ੍ਰੋ ਮੇਘਦ੍ਵਾਰੰ ਮੁਕ੍ਤੰ ਕਪੋਤਵਤ੍ ਸ੍ਵਸ੍ਯੋਪਰਿ ਅਵਰੋਹਨ੍ਤਮਾਤ੍ਮਾਨਞ੍ਚ ਦ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ਤ੍ਵੰ ਮਮ ਪ੍ਰਿਯਃ ਪੁਤ੍ਰਸ੍ਤ੍ਵੱਯੇਵ ਮਮਮਹਾਸਨ੍ਤੋਸ਼਼ ਇਯਮਾਕਾਸ਼ੀਯਾ ਵਾਣੀ ਬਭੂਵ| ");
INSERT INTO sanpun_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","ਤਸ੍ਮਿਨ੍ ਕਾਲੇ ਆਤ੍ਮਾ ਤੰ ਪ੍ਰਾਨ੍ਤਰਮਧ੍ਯੰ ਨਿਨਾਯ| ");
INSERT INTO sanpun_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ਅਥ ਸ ਚਤ੍ਵਾਰਿੰਸ਼ੱਦਿਨਾਨਿ ਤਸ੍ਮਿਨ੍ ਸ੍ਥਾਨੇ ਵਨ੍ਯਪਸ਼ੁਭਿਃ ਸਹ ਤਿਸ਼਼੍ਠਨ੍ ਸ਼ੈਤਾਨਾ ਪਰੀਕ੍ਸ਼਼ਿਤਃ; ਪਸ਼੍ਚਾਤ੍ ਸ੍ਵਰ੍ਗੀਯਦੂਤਾਸ੍ਤੰ ਸਿਸ਼਼ੇਵਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","ਅਨਨ੍ਤਰੰ ਯੋਹਨਿ ਬਨ੍ਧਨਾਲਯੇ ਬੱਧੇ ਸਤਿ ਯੀਸ਼ੁ ਰ੍ਗਾਲੀਲ੍ਪ੍ਰਦੇਸ਼ਮਾਗਤ੍ਯ ਈਸ਼੍ਵਰਰਾਜ੍ਯਸ੍ਯ ਸੁਸੰਵਾਦੰ ਪ੍ਰਚਾਰਯਨ੍ ਕਥਯਾਮਾਸ, ");
INSERT INTO sanpun_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ਕਾਲਃ ਸਮ੍ਪੂਰ੍ਣ ਈਸ਼੍ਵਰਰਾਜ੍ਯਞ੍ਚ ਸਮੀਪਮਾਗਤੰ; ਅਤੋਹੇਤੋ ਰ੍ਯੂਯੰ ਮਨਾਂਸਿ ਵ੍ਯਾਵਰ੍ੱਤਯਧ੍ਵੰ ਸੁਸੰਵਾਦੇ ਚ ਵਿਸ਼੍ਵਾਸਿਤ| ");
INSERT INTO sanpun_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ਤਦਨਨ੍ਤਰੰ ਸ ਗਾਲੀਲੀਯਸਮੁਦ੍ਰਸ੍ਯ ਤੀਰੇ ਗੱਛਨ੍ ਸ਼ਿਮੋਨ੍ ਤਸ੍ਯ ਭ੍ਰਾਤਾ ਅਨ੍ਦ੍ਰਿਯਨਾਮਾ ਚ ਇਮੌ ਦ੍ਵੌ ਜਨੌ ਮਤ੍ਸ੍ਯਧਾਰਿਣੌ ਸਾਗਰਮਧ੍ਯੇ ਜਾਲੰ ਪ੍ਰਕ੍ਸ਼਼ਿਪਨ੍ਤੌ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਤਾਵਵਦਤ੍, ");
INSERT INTO sanpun_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ਯੁਵਾਂ ਮਮ ਪਸ਼੍ਚਾਦਾਗੱਛਤੰ, ਯੁਵਾਮਹੰ ਮਨੁਸ਼਼੍ਯਧਾਰਿਣੌ ਕਰਿਸ਼਼੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ਤਤਸ੍ਤੌ ਤਤ੍ਕ੍ਸ਼਼ਣਮੇਵ ਜਾਲਾਨਿ ਪਰਿਤ੍ਯਜ੍ਯ ਤਸ੍ਯ ਪਸ਼੍ਚਾਤ੍ ਜਗ੍ਮਤੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ਤਤਃ ਪਰੰ ਤਤ੍ਸ੍ਥਾਨਾਤ੍ ਕਿਞ੍ਚਿਦ੍ ਦੂਰੰ ਗਤ੍ਵਾ ਸ ਸਿਵਦੀਪੁਤ੍ਰਯਾਕੂਬ੍ ਤਦ੍ਭ੍ਰਾਤ੍ਰੁʼਯੋਹਨ੍ ਚ ਇਮੌ ਨੌਕਾਯਾਂ ਜਾਲਾਨਾਂ ਜੀਰ੍ਣਮੁੱਧਾਰਯਨ੍ਤੌ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਤਾਵਾਹੂਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ਤਤਸ੍ਤੌ ਨੌਕਾਯਾਂ ਵੇਤਨਭੁਗ੍ਭਿਃ ਸਹਿਤੰ ਸ੍ਵਪਿਤਰੰ ਵਿਹਾਯ ਤਤ੍ਪਸ਼੍ਚਾਦੀਯਤੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ਤਤਃ ਪਰੰ ਕਫਰ੍ਨਾਹੂਮ੍ਨਾਮਕੰ ਨਗਰਮੁਪਸ੍ਥਾਯ ਸ ਵਿਸ਼੍ਰਾਮਦਿਵਸੇ ਭਜਨਗ੍ਰਹੰ ਪ੍ਰਵਿਸ਼੍ਯ ਸਮੁਪਦਿਦੇਸ਼| ");
INSERT INTO sanpun_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ਤਸ੍ਯੋਪਦੇਸ਼ਾੱਲੋਕਾ ਆਸ਼੍ਚਰ੍ੱਯੰ ਮੇਨਿਰੇ ਯਤਃ ਸੋਧ੍ਯਾਪਕਾਇਵ ਨੋਪਦਿਸ਼ਨ੍ ਪ੍ਰਭਾਵਵਾਨਿਵ ਪ੍ਰੋਪਦਿਦੇਸ਼| ");
INSERT INTO sanpun_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","ਅਪਰਞ੍ਚ ਤਸ੍ਮਿਨ੍ ਭਜਨਗ੍ਰੁʼਹੇ ਅਪਵਿਤ੍ਰਭੂਤੇਨ ਗ੍ਰਸ੍ਤ ਏਕੋ ਮਾਨੁਸ਼਼ ਆਸੀਤ੍| ਸ ਚੀਤ੍ਸ਼ਬ੍ਦੰ ਕ੍ਰੁʼਤ੍ਵਾ ਕਥਯਾਞ੍ਚਕੇ ");
INSERT INTO sanpun_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ਭੋ ਨਾਸਰਤੀਯ ਯੀਸ਼ੋ ਤ੍ਵਮਸ੍ਮਾਨ੍ ਤ੍ਯਜ, ਤ੍ਵਯਾ ਸਹਾਸ੍ਮਾਕੰ ਕਃ ਸਮ੍ਬਨ੍ਧਃ? ਤ੍ਵੰ ਕਿਮਸ੍ਮਾਨ੍ ਨਾਸ਼ਯਿਤੁੰ ਸਮਾਗਤਃ? ਤ੍ਵਮੀਸ਼੍ਵਰਸ੍ਯ ਪਵਿਤ੍ਰਲੋਕ ਇਤ੍ਯਹੰ ਜਾਨਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ਤਦਾ ਯੀਸ਼ੁਸ੍ਤੰ ਤਰ੍ਜਯਿਤ੍ਵਾ ਜਗਾਦ ਤੂਸ਼਼੍ਣੀਂ ਭਵ ਇਤੋ ਬਹਿਰ੍ਭਵ ਚ| ");
INSERT INTO sanpun_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ਤਤਃ ਸੋ(ਅ)ਪਵਿਤ੍ਰਭੂਤਸ੍ਤੰ ਸਮ੍ਪੀਡ੍ਯ ਅਤ੍ਯੁਚੈਸ਼੍ਚੀਤ੍ਕ੍ਰੁʼਤ੍ਯ ਨਿਰ੍ਜਗਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ਤੇਨੈਵ ਸਰ੍ੱਵੇ ਚਮਤ੍ਕ੍ਰੁʼਤ੍ਯ ਪਰਸ੍ਪਰੰ ਕਥਯਾਞ੍ਚਕ੍ਰਿਰੇ, ਅਹੋ ਕਿਮਿਦੰ? ਕੀਦ੍ਰੁʼਸ਼ੋ(ਅ)ਯੰ ਨਵ੍ਯ ਉਪਦੇਸ਼ਃ? ਅਨੇਨ ਪ੍ਰਭਾਵੇਨਾਪਵਿਤ੍ਰਭੂਤੇਸ਼਼੍ਵਾਜ੍ਞਾਪਿਤੇਸ਼਼ੁ ਤੇ ਤਦਾਜ੍ਞਾਨੁਵਰ੍ੱਤਿਨੋ ਭਵਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","ਤਦਾ ਤਸ੍ਯ ਯਸ਼ੋ ਗਾਲੀਲਸ਼੍ਚਤੁਰ੍ਦਿਕ੍ਸ੍ਥਸਰ੍ੱਵਦੇਸ਼ਾਨ੍ ਵ੍ਯਾਪ੍ਨੋਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ਅਪਰਞ੍ਚ ਤੇ ਭਜਨਗ੍ਰੁʼਹਾਦ੍ ਬਹਿ ਰ੍ਭੂਤ੍ਵਾ ਯਾਕੂਬ੍ਯੋਹਨ੍ਭ੍ਯਾਂ ਸਹ ਸ਼ਿਮੋਨ ਆਨ੍ਦ੍ਰਿਯਸ੍ਯ ਚ ਨਿਵੇਸ਼ਨੰ ਪ੍ਰਵਿਵਿਸ਼ੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ਤਦਾ ਪਿਤਰਸ੍ਯ ਸ਼੍ਵਸ਼੍ਰੂਰ੍ਜ੍ਵਰਪੀਡਿਤਾ ਸ਼ੱਯਾਯਾਮਾਸ੍ਤ ਇਤਿ ਤੇ ਤੰ ਝਟਿਤਿ ਵਿਜ੍ਞਾਪਯਾਞ੍ਚਕ੍ਰੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ਤਤਃ ਸ ਆਗਤ੍ਯ ਤਸ੍ਯਾ ਹਸ੍ਤੰ ਧ੍ਰੁʼਤ੍ਵਾ ਤਾਮੁਦਸ੍ਥਾਪਯਤ੍; ਤਦੈਵ ਤਾਂ ਜ੍ਵਰੋ(ਅ)ਤ੍ਯਾਕ੍ਸ਼਼ੀਤ੍ ਤਤਃ ਪਰੰ ਸਾ ਤਾਨ੍ ਸਿਸ਼਼ੇਵੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","ਅਥਾਸ੍ਤੰ ਗਤੇ ਰਵੌ ਸਨ੍ਧ੍ਯਾਕਾਲੇ ਸਤਿ ਲੋਕਾਸ੍ਤਤ੍ਸਮੀਪੰ ਸਰ੍ੱਵਾਨ੍ ਰੋਗਿਣੋ ਭੂਤਧ੍ਰੁʼਤਾਂਸ਼੍ਚ ਸਮਾਨਿਨ੍ਯੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ਸਰ੍ੱਵੇ ਨਾਗਰਿਕਾ ਲੋਕਾ ਦ੍ਵਾਰਿ ਸੰਮਿਲਿਤਾਸ਼੍ਚ| ");
INSERT INTO sanpun_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ਤਤਃ ਸ ਨਾਨਾਵਿਧਰੋਗਿਣੋ ਬਹੂਨ੍ ਮਨੁਜਾਨਰੋਗਿਣਸ਼੍ਚਕਾਰ ਤਥਾ ਬਹੂਨ੍ ਭੂਤਾਨ੍ ਤ੍ਯਾਜਯਾਞ੍ਚਕਾਰ ਤਾਨ੍ ਭੂਤਾਨ੍ ਕਿਮਪਿ ਵਾਕ੍ਯੰ ਵਕ੍ਤੁੰ ਨਿਸ਼਼ਿਸ਼਼ੇਧ ਚ ਯਤੋਹੇਤੋਸ੍ਤੇ ਤਮਜਾਨਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","ਅਪਰਞ੍ਚ ਸੋ(ਅ)ਤਿਪ੍ਰਤ੍ਯੂਸ਼਼ੇ ਵਸ੍ਤੁਤਸ੍ਤੁ ਰਾਤ੍ਰਿਸ਼ੇਸ਼਼ੇ ਸਮੁੱਥਾਯ ਬਹਿਰ੍ਭੂਯ ਨਿਰ੍ਜਨੰ ਸ੍ਥਾਨੰ ਗਤ੍ਵਾ ਤਤ੍ਰ ਪ੍ਰਾਰ੍ਥਯਾਞ੍ਚਕ੍ਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ਅਨਨ੍ਤਰੰ ਸ਼ਿਮੋਨ੍ ਤਤ੍ਸਙ੍ਗਿਨਸ਼੍ਚ ਤਸ੍ਯ ਪਸ਼੍ਚਾਦ੍ ਗਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ਤਦੁੱਦੇਸ਼ੰ ਪ੍ਰਾਪ੍ਯ ਤਮਵਦਨ੍ ਸਰ੍ੱਵੇ ਲੋਕਾਸ੍ਤ੍ਵਾਂ ਮ੍ਰੁʼਗਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","ਤਦਾ ਸੋ(ਅ)ਕਥਯਤ੍ ਆਗੱਛਤ ਵਯੰ ਸਮੀਪਸ੍ਥਾਨਿ ਨਗਰਾਣਿ ਯਾਮਃ, ਯਤੋ(ਅ)ਹੰ ਤਤ੍ਰ ਕਥਾਂ ਪ੍ਰਚਾਰਯਿਤੁੰ ਬਹਿਰਾਗਮਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","ਅਥ ਸ ਤੇਸ਼਼ਾਂ ਗਾਲੀਲ੍ਪ੍ਰਦੇਸ਼ਸ੍ਯ ਸਰ੍ੱਵੇਸ਼਼ੁ ਭਜਨਗ੍ਰੁʼਹੇਸ਼਼ੁ ਕਥਾਃ ਪ੍ਰਚਾਰਯਾਞ੍ਚਕ੍ਰੇ ਭੂਤਾਨਤ੍ਯਾਜਯਞ੍ਚ| ");
INSERT INTO sanpun_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ਅਨਨ੍ਤਰਮੇਕਃ ਕੁਸ਼਼੍ਠੀ ਸਮਾਗਤ੍ਯ ਤਤ੍ਸੰਮੁਖੇ ਜਾਨੁਪਾਤੰ ਵਿਨਯਞ੍ਚ ਕ੍ਰੁʼਤ੍ਵਾ ਕਥਿਤਵਾਨ੍ ਯਦਿ ਭਵਾਨ੍ ਇੱਛਤਿ ਤਰ੍ਹਿ ਮਾਂ ਪਰਿਸ਼਼੍ਕਰ੍ੱਤੁੰ ਸ਼ਕ੍ਨੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ਤਤਃ ਕ੍ਰੁʼਪਾਲੁ ਰ੍ਯੀਸ਼ੁਃ ਕਰੌ ਪ੍ਰਸਾਰ੍ੱਯ ਤੰ ਸ੍ਪਸ਼਼੍ਟ੍ਵਾ ਕਥਯਾਮਾਸ ");
INSERT INTO sanpun_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ਮਮੇੱਛਾ ਵਿਦ੍ਯਤੇ ਤ੍ਵੰ ਪਰਿਸ਼਼੍ਕ੍ਰੁʼਤੋ ਭਵ| ਏਤਤ੍ਕਥਾਯਾਃ ਕਥਨਮਾਤ੍ਰਾਤ੍ ਸ ਕੁਸ਼਼੍ਠੀ ਰੋਗਾਨ੍ਮੁਕ੍ਤਃ ਪਰਿਸ਼਼੍ਕ੍ਰੁʼਤੋ(ਅ)ਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","ਤਦਾ ਸ ਤੰ ਵਿਸ੍ਰੁʼਜਨ੍ ਗਾਢਮਾਦਿਸ਼੍ਯ ਜਗਾਦ ");
INSERT INTO sanpun_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ਸਾਵਧਾਨੋ ਭਵ ਕਥਾਮਿਮਾਂ ਕਮਪਿ ਮਾ ਵਦ; ਸ੍ਵਾਤ੍ਮਾਨੰ ਯਾਜਕੰ ਦਰ੍ਸ਼ਯ, ਲੋਕੇਭ੍ਯਃ ਸ੍ਵਪਰਿਸ਼਼੍ਕ੍ਰੁʼਤੇਃ ਪ੍ਰਮਾਣਦਾਨਾਯ ਮੂਸਾਨਿਰ੍ਣੀਤੰ ਯੱਦਾਨੰ ਤਦੁਤ੍ਸ੍ਰੁʼਜਸ੍ਵ ਚ| ");
INSERT INTO sanpun_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ਕਿਨ੍ਤੁ ਸ ਗਤ੍ਵਾ ਤਤ੍ ਕਰ੍ੰਮ ਇੱਥੰ ਵਿਸ੍ਤਾਰ੍ੱਯ ਪ੍ਰਚਾਰਯਿਤੁੰ ਪ੍ਰਾਰੇਭੇ ਤੇਨੈਵ ਯੀਸ਼ੁਃ ਪੁਨਃ ਸਪ੍ਰਕਾਸ਼ੰ ਨਗਰੰ ਪ੍ਰਵੇਸ਼਼੍ਟੁੰ ਨਾਸ਼ਕ੍ਨੋਤ੍ ਤਤੋਹੇਤੋਰ੍ਬਹਿਃ ਕਾਨਨਸ੍ਥਾਨੇ ਤਸ੍ਯੌ; ਤਥਾਪਿ ਚਤੁਰ੍ੱਦਿਗ੍ਭ੍ਯੋ ਲੋਕਾਸ੍ਤਸ੍ਯ ਸਮੀਪਮਾਯਯੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","ਤਦਨਨ੍ਤਰੰ ਯੀਸ਼ੈ ਕਤਿਪਯਦਿਨਾਨਿ ਵਿਲਮ੍ਬ੍ਯ ਪੁਨਃ ਕਫਰ੍ਨਾਹੂਮ੍ਨਗਰੰ ਪ੍ਰਵਿਸ਼਼੍ਟੇ ਸ ਗ੍ਰੁʼਹ ਆਸ੍ਤ ਇਤਿ ਕਿੰਵਦਨ੍ਤ੍ਯਾ ਤਤ੍ਕ੍ਸ਼਼ਣੰ ਤਤ੍ਸਮੀਪੰ ਬਹਵੋ ਲੋਕਾ ਆਗਤ੍ਯ ਸਮੁਪਤਸ੍ਥੁਃ, ");
INSERT INTO sanpun_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ਤਸ੍ਮਾਦ੍ ਗ੍ਰੁʼਹਮਧ੍ਯੇ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਕ੍ਰੁʼਤੇ ਸ੍ਥਾਨੰ ਨਾਭਵਦ੍ ਦ੍ਵਾਰਸ੍ਯ ਚਤੁਰ੍ਦਿਕ੍ਸ਼਼੍ਵਪਿ ਨਾਭਵਤ੍, ਤਤ੍ਕਾਲੇ ਸ ਤਾਨ੍ ਪ੍ਰਤਿ ਕਥਾਂ ਪ੍ਰਚਾਰਯਾਞ੍ਚਕ੍ਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ਤਤਃ ਪਰੰ ਲੋਕਾਸ਼੍ਚਤੁਰ੍ਭਿ ਰ੍ਮਾਨਵੈਰੇਕੰ ਪਕ੍ਸ਼਼ਾਘਾਤਿਨੰ ਵਾਹਯਿਤ੍ਵਾ ਤਤ੍ਸਮੀਪਮ੍ ਆਨਿਨ੍ਯੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ਕਿਨ੍ਤੁ ਜਨਾਨਾਂ ਬਹੁਤ੍ਵਾਤ੍ ਤੰ ਯੀਸ਼ੋਃ ਸੰਮੁਖਮਾਨੇਤੁੰ ਨ ਸ਼ਕ੍ਨੁਵਨ੍ਤੋ ਯਸ੍ਮਿਨ੍ ਸ੍ਥਾਨੇ ਸ ਆਸ੍ਤੇ ਤਦੁਪਰਿਗ੍ਰੁʼਹਪ੍ਰੁʼਸ਼਼੍ਠੰ ਖਨਿਤ੍ਵਾ ਛਿਦ੍ਰੰ ਕ੍ਰੁʼਤ੍ਵਾ ਤੇਨ ਮਾਰ੍ਗੇਣ ਸਸ਼ੱਯੰ ਪਕ੍ਸ਼਼ਾਘਾਤਿਨਮ੍ ਅਵਰੋਹਯਾਮਾਸੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ਤਤੋ ਯੀਸ਼ੁਸ੍ਤੇਸ਼਼ਾਂ ਵਿਸ਼੍ਵਾਸੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਤੰ ਪਕ੍ਸ਼਼ਾਘਾਤਿਨੰ ਬਭਾਸ਼਼ੇ ਹੇ ਵਤ੍ਸ ਤਵ ਪਾਪਾਨਾਂ ਮਾਰ੍ਜਨੰ ਭਵਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ਤਦਾ ਕਿਯਨ੍ਤੋ(ਅ)ਧ੍ਯਾਪਕਾਸ੍ਤਤ੍ਰੋਪਵਿਸ਼ਨ੍ਤੋ ਮਨੋਭਿ ਰ੍ਵਿਤਰ੍ਕਯਾਞ੍ਚਕ੍ਰੁਃ, ਏਸ਼਼ ਮਨੁਸ਼਼੍ਯ ਏਤਾਦ੍ਰੁʼਸ਼ੀਮੀਸ਼੍ਵਰਨਿਨ੍ਦਾਂ ਕਥਾਂ ਕੁਤਃ ਕਥਯਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","ਈਸ਼੍ਵਰੰ ਵਿਨਾ ਪਾਪਾਨਿ ਮਾਰ੍ਸ਼਼੍ਟੁੰ ਕਸ੍ਯ ਸਾਮਰ੍ਥ੍ਯਮ੍ ਆਸ੍ਤੇ? ");
INSERT INTO sanpun_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ਇੱਥੰ ਤੇ ਵਿਤਰ੍ਕਯਨ੍ਤਿ ਯੀਸ਼ੁਸ੍ਤਤ੍ਕ੍ਸ਼਼ਣੰ ਮਨਸਾ ਤਦ੍ ਬੁਦ੍ੱਵਾ ਤਾਨਵਦਦ੍ ਯੂਯਮਨ੍ਤਃਕਰਣੈਃ ਕੁਤ ਏਤਾਨਿ ਵਿਤਰ੍ਕਯਥ? ");
INSERT INTO sanpun_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","ਤਦਨਨ੍ਤਰੰ ਯੀਸ਼ੁਸ੍ਤਤ੍ਸ੍ਥਾਨਾਤ੍ ਪੁਨਃ ਸਮੁਦ੍ਰਤਟੰ ਯਯੌ; ਲੋਕਨਿਵਹੇ ਤਤ੍ਸਮੀਪਮਾਗਤੇ ਸ ਤਾਨ੍ ਸਮੁਪਦਿਦੇਸ਼| ");
INSERT INTO sanpun_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","ਕਿਨ੍ਤੁ ਪ੍ਰੁʼਥਿਵ੍ਯਾਂ ਪਾਪਾਨਿ ਮਾਰ੍ਸ਼਼੍ਟੁੰ ਮਨੁਸ਼਼੍ਯਪੁਤ੍ਰਸ੍ਯ ਸਾਮਰ੍ਥ੍ਯਮਸ੍ਤਿ, ਏਤਦ੍ ਯੁਸ਼਼੍ਮਾਨ੍ ਜ੍ਞਾਪਯਿਤੁੰ (ਸ ਤਸ੍ਮੈ ਪਕ੍ਸ਼਼ਾਘਾਤਿਨੇ ਕਥਯਾਮਾਸ) ");
INSERT INTO sanpun_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","ਉੱਤਿਸ਼਼੍ਠ ਤਵ ਸ਼ੱਯਾਂ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਸ੍ਵਗ੍ਰੁʼਹੰ ਯਾਹਿ, ਅਹੰ ਤ੍ਵਾਮਿਦਮ੍ ਆਜ੍ਞਾਪਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ਤਤਃ ਸ ਤਤ੍ਕ੍ਸ਼਼ਣਮ੍ ਉੱਥਾਯ ਸ਼ੱਯਾਂ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਜਗਾਮ; ਸਰ੍ੱਵੇ ਵਿਸ੍ਮਿਤਾ ਏਤਾਦ੍ਰੁʼਸ਼ੰ ਕਰ੍ੰਮ ਵਯਮ੍ ਕਦਾਪਿ ਨਾਪਸ਼੍ਯਾਮ, ਇਮਾਂ ਕਥਾਂ ਕਥਯਿਤ੍ਵੇਸ਼੍ਵਰੰ ਧਨ੍ਯਮਬ੍ਰੁਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","ਤਦਨਨ੍ਤਰੰ ਯੀਸ਼ੁਸ੍ਤਤ੍ਸ੍ਥਾਨਾਤ੍ ਪੁਨਃ ਸਮੁਦ੍ਰਤਟੰ ਯਯੌ; ਲੋਕਨਿਵਹੇ ਤਤ੍ਸਮੀਪਮਾਗਤੇ ਸ ਤਾਨ੍ ਸਮੁਪਦਿਦੇਸ਼| ");
INSERT INTO sanpun_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ਅਥ ਗੱਛਨ੍ ਕਰਸਞ੍ਚਯਗ੍ਰੁʼਹ ਉਪਵਿਸ਼਼੍ਟਮ੍ ਆਲ੍ਫੀਯਪੁਤ੍ਰੰ ਲੇਵਿੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਤਮਾਹੂਯ ਕਥਿਤਵਾਨ੍ ਮਤ੍ਪਸ਼੍ਚਾਤ੍ ਤ੍ਵਾਮਾਮੱਛ ਤਤਃ ਸ ਉੱਥਾਯ ਤਤ੍ਪਸ਼੍ਚਾਦ੍ ਯਯੌ| ");
INSERT INTO sanpun_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","ਅਨਨ੍ਤਰੰ ਯੀਸ਼ੌ ਤਸ੍ਯ ਗ੍ਰੁʼਹੇ ਭੋਕ੍ਤੁਮ੍ ਉਪਵਿਸ਼਼੍ਟੇ ਬਹਵਃ ਕਰਮਞ੍ਚਾਯਿਨਃ ਪਾਪਿਨਸ਼੍ਚ ਤੇਨ ਤੱਛਿਸ਼਼੍ਯੈਸ਼੍ਚ ਸਹੋਪਵਿਵਿਸ਼ੁਃ, ਯਤੋ ਬਹਵਸ੍ਤਤ੍ਪਸ਼੍ਚਾਦਾਜਗ੍ਮੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ਤਦਾ ਸ ਕਰਮਞ੍ਚਾਯਿਭਿਃ ਪਾਪਿਭਿਸ਼੍ਚ ਸਹ ਖਾਦਤਿ, ਤਦ੍ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾਧ੍ਯਾਪਕਾਃ ਫਿਰੂਸ਼ਿਨਸ਼੍ਚ ਤਸ੍ਯ ਸ਼ਿਸ਼਼੍ਯਾਨੂਚੁਃ ਕਰਮਞ੍ਚਾਯਿਭਿਃ ਪਾਪਿਭਿਸ਼੍ਚ ਸਹਾਯੰ ਕੁਤੋ ਭੁੰਕ੍ਤੇ ਪਿਵਤਿ ਚ? ");
INSERT INTO sanpun_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ਤਦ੍ਵਾਕ੍ਯੰ ਸ਼੍ਰੁਤ੍ਵਾ ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯੁਵਾਚ,ਅਰੋਗਿਲੋਕਾਨਾਂ ਚਿਕਿਤ੍ਸਕੇਨ ਪ੍ਰਯੋਜਨੰ ਨਾਸ੍ਤਿ, ਕਿਨ੍ਤੁ ਰੋਗਿਣਾਮੇਵ; ਅਹੰ ਧਾਰ੍ੰਮਿਕਾਨਾਹ੍ਵਾਤੁੰ ਨਾਗਤਃ ਕਿਨ੍ਤੁ ਮਨੋ ਵ੍ਯਾਵਰ੍ੱਤਯਿਤੁੰ ਪਾਪਿਨ ਏਵ| ");
INSERT INTO sanpun_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ਤਤਃ ਪਰੰ ਯੋਹਨਃ ਫਿਰੂਸ਼ਿਨਾਞ੍ਚੋਪਵਾਸਾਚਾਰਿਸ਼ਿਸ਼਼੍ਯਾ ਯੀਸ਼ੋਃ ਸਮੀਪਮ੍ ਆਗਤ੍ਯ ਕਥਯਾਮਾਸੁਃ, ਯੋਹਨਃ ਫਿਰੂਸ਼ਿਨਾਞ੍ਚ ਸ਼ਿਸ਼਼੍ਯਾ ਉਪਵਸਨ੍ਤਿ ਕਿਨ੍ਤੁ ਭਵਤਃ ਸ਼ਿਸ਼਼੍ਯਾ ਨੋਪਵਸਨ੍ਤਿ ਕਿੰ ਕਾਰਣਮਸ੍ਯ? ");
INSERT INTO sanpun_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","ਤਦਾ ਯੀਸ਼ੁਸ੍ਤਾਨ੍ ਬਭਾਸ਼਼ੇ ਯਾਵਤ੍ ਕਾਲੰ ਸਖਿਭਿਃ ਸਹ ਕਨ੍ਯਾਯਾ ਵਰਸ੍ਤਿਸ਼਼੍ਠਤਿ ਤਾਵਤ੍ਕਾਲੰ ਤੇ ਕਿਮੁਪਵਸ੍ਤੁੰ ਸ਼ਕ੍ਨੁਵਨ੍ਤਿ? ਯਾਵਤ੍ਕਾਲੰ ਵਰਸ੍ਤੈਃ ਸਹ ਤਿਸ਼਼੍ਠਤਿ ਤਾਵਤ੍ਕਾਲੰ ਤ ਉਪਵਸ੍ਤੁੰ ਨ ਸ਼ਕ੍ਨੁਵਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","ਯਸ੍ਮਿਨ੍ ਕਾਲੇ ਤੇਭ੍ਯਃ ਸਕਾਸ਼ਾਦ੍ ਵਰੋ ਨੇਸ਼਼੍ਯਤੇ ਸ ਕਾਲ ਆਗੱਛਤਿ, ਤਸ੍ਮਿਨ੍ ਕਾਲੇ ਤੇ ਜਨਾ ਉਪਵਤ੍ਸ੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","ਕੋਪਿ ਜਨਃ ਪੁਰਾਤਨਵਸ੍ਤ੍ਰੇ ਨੂਤਨਵਸ੍ਤ੍ਰੰ ਨ ਸੀਵ੍ਯਤਿ, ਯਤੋ ਨੂਤਨਵਸ੍ਤ੍ਰੇਣ ਸਹ ਸੇਵਨੇ ਕ੍ਰੁʼਤੇ ਜੀਰ੍ਣੰ ਵਸ੍ਤ੍ਰੰ ਛਿਦ੍ਯਤੇ ਤਸ੍ਮਾਤ੍ ਪੁਨ ਰ੍ਮਹਤ੍ ਛਿਦ੍ਰੰ ਜਾਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","ਕੋਪਿ ਜਨਃ ਪੁਰਾਤਨਕੁਤੂਸ਼਼ੁ ਨੂਤਨੰ ਦ੍ਰਾਕ੍ਸ਼਼ਾਰਸੰ ਨ ਸ੍ਥਾਪਯਤਿ, ਯਤੋ ਨੂਤਨਦ੍ਰਾਕ੍ਸ਼਼ਾਰਸਸ੍ਯ ਤੇਜਸਾ ਤਾਃ ਕੁਤ੍ਵੋ ਵਿਦੀਰ੍ੱਯਨ੍ਤੇ ਤਤੋ ਦ੍ਰਾਕ੍ਸ਼਼ਾਰਸਸ਼੍ਚ ਪਤਤਿ ਕੁਤ੍ਵਸ਼੍ਚ ਨਸ਼੍ਯਨ੍ਤਿ, ਅਤਏਵ ਨੂਤਨਦ੍ਰਾਕ੍ਸ਼਼ਾਰਸੋ ਨੂਤਨਕੁਤੂਸ਼਼ੁ ਸ੍ਥਾਪਨੀਯਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","ਤਦਨਨ੍ਤਰੰ ਯੀਸ਼ੁ ਰ੍ਯਦਾ ਵਿਸ਼੍ਰਾਮਵਾਰੇ ਸ਼ਸ੍ਯਕ੍ਸ਼਼ੇਤ੍ਰੇਣ ਗੱਛਤਿ ਤਦਾ ਤਸ੍ਯ ਸ਼ਿਸ਼਼੍ਯਾ ਗੱਛਨ੍ਤਃ ਸ਼ਸ੍ਯਮਞ੍ਜਰੀਸ਼੍ਛੇੱਤੁੰ ਪ੍ਰਵ੍ਰੁʼੱਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ਅਤਃ ਫਿਰੂਸ਼ਿਨੋ ਯੀਸ਼ਵੇ ਕਥਯਾਮਾਸੁਃ ਪਸ਼੍ਯਤੁ ਵਿਸ਼੍ਰਾਮਵਾਸਰੇ ਯਤ੍ ਕਰ੍ੰਮ ਨ ਕਰ੍ੱਤਵ੍ਯੰ ਤਦ੍ ਇਮੇ ਕੁਤਃ ਕੁਰ੍ੱਵਨ੍ਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ਤਦਾ ਸ ਤੇਭ੍ਯੋ(ਅ)ਕਥਯਤ੍ ਦਾਯੂਦ੍ ਤਤ੍ਸੰਙ੍ਗਿਨਸ਼੍ਚ ਭਕ੍ਸ਼਼੍ਯਾਭਾਵਾਤ੍ ਕ੍ਸ਼਼ੁਧਿਤਾਃ ਸਨ੍ਤੋ ਯਤ੍ ਕਰ੍ੰਮ ਕ੍ਰੁʼਤਵਨ੍ਤਸ੍ਤਤ੍ ਕਿੰ ਯੁਸ਼਼੍ਮਾਭਿ ਰ੍ਨ ਪਠਿਤਮ੍? ");
INSERT INTO sanpun_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ਅਬਿਯਾਥਰ੍ਨਾਮਕੇ ਮਹਾਯਾਜਕਤਾਂ ਕੁਰ੍ੱਵਤਿ ਸ ਕਥਮੀਸ਼੍ਵਰਸ੍ਯਾਵਾਸੰ ਪ੍ਰਵਿਸ਼੍ਯ ਯੇ ਦਰ੍ਸ਼ਨੀਯਪੂਪਾ ਯਾਜਕਾਨ੍ ਵਿਨਾਨ੍ਯਸ੍ਯ ਕਸ੍ਯਾਪਿ ਨ ਭਕ੍ਸ਼਼੍ਯਾਸ੍ਤਾਨੇਵ ਬੁਭੁਜੇ ਸਙ੍ਗਿਲੋਕੇਭ੍ਯੋ(ਅ)ਪਿ ਦਦੌ| ");
INSERT INTO sanpun_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","ਸੋ(ਅ)ਪਰਮਪਿ ਜਗਾਦ, ਵਿਸ਼੍ਰਾਮਵਾਰੋ ਮਨੁਸ਼਼੍ਯਾਰ੍ਥਮੇਵ ਨਿਰੂਪਿਤੋ(ਅ)ਸ੍ਤਿ ਕਿਨ੍ਤੁ ਮਨੁਸ਼਼੍ਯੋ ਵਿਸ਼੍ਰਾਮਵਾਰਾਰ੍ਥੰ ਨੈਵ| ");
INSERT INTO sanpun_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","ਮਨੁਸ਼਼੍ਯਪੁਤ੍ਰੋ ਵਿਸ਼੍ਰਾਮਵਾਰਸ੍ਯਾਪਿ ਪ੍ਰਭੁਰਾਸ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ਅਨਨ੍ਤਰੰ ਯੀਸ਼ੁਃ ਪੁਨ ਰ੍ਭਜਨਗ੍ਰੁʼਹੰ ਪ੍ਰਵਿਸ਼਼੍ਟਸ੍ਤਸ੍ਮਿਨ੍ ਸ੍ਥਾਨੇ ਸ਼ੁਸ਼਼੍ਕਹਸ੍ਤ ਏਕੋ ਮਾਨਵ ਆਸੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ਸ ਵਿਸ਼੍ਰਾਮਵਾਰੇ ਤਮਰੋਗਿਣੰ ਕਰਿਸ਼਼੍ਯਤਿ ਨਵੇਤ੍ਯਤ੍ਰ ਬਹਵਸ੍ਤਮ੍ ਅਪਵਦਿਤੁੰ ਛਿਦ੍ਰਮਪੇਕ੍ਸ਼਼ਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ਤਦਾ ਸ ਤੰ ਸ਼ੁਸ਼਼੍ਕਹਸ੍ਤੰ ਮਨੁਸ਼਼੍ਯੰ ਜਗਾਦ ਮਧ੍ਯਸ੍ਥਾਨੇ ਤ੍ਵਮੁੱਤਿਸ਼਼੍ਠ| ");
INSERT INTO sanpun_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ਤਤਃ ਪਰੰ ਸ ਤਾਨ੍ ਪਪ੍ਰੱਛ ਵਿਸ਼੍ਰਾਮਵਾਰੇ ਹਿਤਮਹਿਤੰ ਤਥਾ ਹਿ ਪ੍ਰਾਣਰਕ੍ਸ਼਼ਾ ਵਾ ਪ੍ਰਾਣਨਾਸ਼ ਏਸ਼਼ਾਂ ਮਧ੍ਯੇ ਕਿੰ ਕਰਣੀਯੰ ? ਕਿਨ੍ਤੁ ਤੇ ਨਿਃਸ਼ਬ੍ਦਾਸ੍ਤਸ੍ਥੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ਤਦਾ ਸ ਤੇਸ਼਼ਾਮਨ੍ਤਃਕਰਣਾਨਾਂ ਕਾਠਿਨ੍ਯਾੱਧੇਤੋ ਰ੍ਦੁਃਖਿਤਃ ਕ੍ਰੋਧਾਤ੍ ਚਰ੍ਤੁिਦਸ਼ੋ ਦ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍ ਤੰ ਮਾਨੁਸ਼਼ੰ ਗਦਿਤਵਾਨ੍ ਤੰ ਹਸ੍ਤੰ ਵਿਸ੍ਤਾਰਯ, ਤਤਸ੍ਤੇਨ ਹਸ੍ਤੇ ਵਿਸ੍ਤ੍ਰੁʼਤੇ ਤੱਧਸ੍ਤੋ(ਅ)ਨ੍ਯਹਸ੍ਤਵਦ੍ ਅਰੋਗੋ ਜਾਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ਅਥ ਫਿਰੂਸ਼ਿਨਃ ਪ੍ਰਸ੍ਥਾਯ ਤੰ ਨਾਸ਼ਯਿਤੁੰ ਹੇਰੋਦੀਯੈਃ ਸਹ ਮਨ੍ਤ੍ਰਯਿਤੁਮਾਰੇਭਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ਅਤਏਵ ਯੀਸ਼ੁਸ੍ਤਤ੍ਸ੍ਥਾਨੰ ਪਰਿਤ੍ਯਜ੍ਯ ਸ਼ਿਸ਼਼੍ਯੈਃ ਸਹ ਪੁਨਃ ਸਾਗਰਸਮੀਪੰ ਗਤਃ; ");
INSERT INTO sanpun_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ਤਤੋ ਗਾਲੀਲ੍ਯਿਹੂਦਾ-ਯਿਰੂਸ਼ਾਲਮ੍-ਇਦੋਮ੍-ਯਰ੍ਦੰਨਦੀਪਾਰਸ੍ਥਾਨੇਭ੍ਯੋ ਲੋਕਸਮੂਹਸ੍ਤਸ੍ਯ ਪਸ਼੍ਚਾਦ੍ ਗਤਃ; ਤਦਨ੍ਯਃ ਸੋਰਸੀਦਨੋਃ ਸਮੀਪਵਾਸਿਲੋਕਸਮੂਹਸ਼੍ਚ ਤਸ੍ਯ ਮਹਾਕਰ੍ੰਮਣਾਂ ਵਾਰ੍ੱਤੰ ਸ਼੍ਰੁਤ੍ਵਾ ਤਸ੍ਯ ਸੰਨਿਧਿਮਾਗਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","ਤਦਾ ਲੋਕਸਮੂਹਸ਼੍ਚੇਤ੍ ਤਸ੍ਯੋਪਰਿ ਪਤਤਿ ਇਤ੍ਯਾਸ਼ਙ੍ਕ੍ਯ ਸ ਨਾਵਮੇਕਾਂ ਨਿਕਟੇ ਸ੍ਥਾਪਯਿਤੁੰ ਸ਼ਿਸ਼਼੍ਯਾਨਾਦਿਸ਼਼੍ਟਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ਯਤੋ(ਅ)ਨੇਕਮਨੁਸ਼਼੍ਯਾਣਾਮਾਰੋਗ੍ਯਕਰਣਾਦ੍ ਵ੍ਯਾਧਿਗ੍ਰਸ੍ਤਾਃ ਸਰ੍ੱਵੇ ਤੰ ਸ੍ਪ੍ਰਸ਼਼੍ਟੁੰ ਪਰਸ੍ਪਰੰ ਬਲੇਨ ਯਤ੍ਨਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ਅਪਰਞ੍ਚ ਅਪਵਿਤ੍ਰਭੂਤਾਸ੍ਤੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਤੱਚਰਣਯੋਃ ਪਤਿਤ੍ਵਾ ਪ੍ਰੋਚੈਃ ਪ੍ਰੋਚੁਃ, ਤ੍ਵਮੀਸ਼੍ਵਰਸ੍ਯ ਪੁਤ੍ਰਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","ਕਿਨ੍ਤੁ ਸ ਤਾਨ੍ ਦ੍ਰੁʼਢਮ੍ ਆਜ੍ਞਾਪ੍ਯ ਸ੍ਵੰ ਪਰਿਚਾਯਿਤੁੰ ਨਿਸ਼਼ਿੱਧਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","ਅਨਨ੍ਤਰੰ ਸ ਪਰ੍ੱਵਤਮਾਰੁਹ੍ਯ ਯੰ ਯੰ ਪ੍ਰਤਿੱਛਾ ਤੰ ਤਮਾਹੂਤਵਾਨ੍ ਤਤਸ੍ਤੇ ਤਤ੍ਸਮੀਪਮਾਗਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ਤਦਾ ਸ ਦ੍ਵਾਦਸ਼ਜਨਾਨ੍ ਸ੍ਵੇਨ ਸਹ ਸ੍ਥਾਤੁੰ ਸੁਸੰਵਾਦਪ੍ਰਚਾਰਾਯ ਪ੍ਰੇਰਿਤਾ ਭਵਿਤੁੰ ");
INSERT INTO sanpun_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ਸਰ੍ੱਵਪ੍ਰਕਾਰਵ੍ਯਾਧੀਨਾਂ ਸ਼ਮਨਕਰਣਾਯ ਪ੍ਰਭਾਵੰ ਪ੍ਰਾਪ੍ਤੁੰ ਭੂਤਾਨ੍ ਤ੍ਯਾਜਯਿਤੁਞ੍ਚ ਨਿਯੁਕ੍ਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ਤੇਸ਼਼ਾਂ ਨਾਮਾਨੀਮਾਨਿ, ਸ਼ਿਮੋਨ੍ ਸਿਵਦਿਪੁਤ੍ਰੋ ");
INSERT INTO sanpun_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ਯਾਕੂਬ੍ ਤਸ੍ਯ ਭ੍ਰਾਤਾ ਯੋਹਨ੍ ਚ ਆਨ੍ਦ੍ਰਿਯਃ ਫਿਲਿਪੋ ਬਰ੍ਥਲਮਯਃ, ");
INSERT INTO sanpun_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ਮਥੀ ਥੋਮਾ ਚ ਆਲ੍ਫੀਯਪੁਤ੍ਰੋ ਯਾਕੂਬ੍ ਥੱਦੀਯਃ ਕਿਨਾਨੀਯਃ ਸ਼ਿਮੋਨ੍ ਯਸ੍ਤੰ ਪਰਹਸ੍ਤੇਸ਼਼੍ਵਰ੍ਪਯਿਸ਼਼੍ਯਤਿ ਸ ਈਸ਼਼੍ਕਰਿਯੋਤੀਯਯਿਹੂਦਾਸ਼੍ਚ| ");
INSERT INTO sanpun_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ਸ ਸ਼ਿਮੋਨੇ ਪਿਤਰ ਇਤ੍ਯੁਪਨਾਮ ਦਦੌ ਯਾਕੂਬ੍ਯੋਹਨ੍ਭ੍ਯਾਂ ਚ ਬਿਨੇਰਿਗਿਸ਼੍ ਅਰ੍ਥਤੋ ਮੇਘਨਾਦਪੁਤ੍ਰਾਵਿਤ੍ਯੁਪਨਾਮ ਦਦੌ| ");
INSERT INTO sanpun_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ਅਨਨ੍ਤਰੰ ਤੇ ਨਿਵੇਸ਼ਨੰ ਗਤਾਃ, ਕਿਨ੍ਤੁ ਤਤ੍ਰਾਪਿ ਪੁਨਰ੍ਮਹਾਨ੍ ਜਨਸਮਾਗਮੋ (ਅ)ਭਵਤ੍ ਤਸ੍ਮਾੱਤੇ ਭੋਕ੍ਤੁਮਪ੍ਯਵਕਾਸ਼ੰ ਨ ਪ੍ਰਾਪ੍ਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ਤਤਸ੍ਤਸ੍ਯ ਸੁਹ੍ਰੁʼੱਲੋਕਾ ਇਮਾਂ ਵਾਰ੍ੱਤਾਂ ਪ੍ਰਾਪ੍ਯ ਸ ਹਤਜ੍ਞਾਨੋਭੂਦ੍ ਇਤਿ ਕਥਾਂ ਕਥਯਿਤ੍ਵਾ ਤੰ ਧ੍ਰੁʼਤ੍ਵਾਨੇਤੁੰ ਗਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","ਅਪਰਞ੍ਚ ਯਿਰੂਸ਼ਾਲਮ ਆਗਤਾ ਯੇ ਯੇ(ਅ)ਧ੍ਯਾਪਕਾਸ੍ਤੇ ਜਗਦੁਰਯੰ ਪੁਰੁਸ਼਼ੋ ਭੂਤਪਤ੍ਯਾਬਿਸ਼਼੍ਟਸ੍ਤੇਨ ਭੂਤਪਤਿਨਾ ਭੂਤਾਨ੍ ਤ੍ਯਾਜਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","ਤਤਸ੍ਤਾਨਾਹੂਯ ਯੀਸ਼ੁ ਰ੍ਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤੈਃ ਕਥਾਂ ਕਥਿਤਵਾਨ੍ ਸ਼ੈਤਾਨ੍ ਕਥੰ ਸ਼ੈਤਾਨੰ ਤ੍ਯਾਜਯਿਤੁੰ ਸ਼ਕ੍ਨੋਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","ਕਿਞ੍ਚਨ ਰਾਜ੍ਯੰ ਯਦਿ ਸ੍ਵਵਿਰੋਧੇਨ ਪ੍ਰੁʼਥਗ੍ ਭਵਤਿ ਤਰ੍ਹਿ ਤਦ੍ ਰਾਜ੍ਯੰ ਸ੍ਥਿਰੰ ਸ੍ਥਾਤੁੰ ਨ ਸ਼ਕ੍ਨੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ਤਥਾ ਕਸ੍ਯਾਪਿ ਪਰਿਵਾਰੋ ਯਦਿ ਪਰਸ੍ਪਰੰ ਵਿਰੋਧੀ ਭਵਤਿ ਤਰ੍ਹਿ ਸੋਪਿ ਪਰਿਵਾਰਃ ਸ੍ਥਿਰੰ ਸ੍ਥਾਤੁੰ ਨ ਸ਼ਕ੍ਨੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","ਤਦ੍ਵਤ੍ ਸ਼ੈਤਾਨ੍ ਯਦਿ ਸ੍ਵਵਿਪਕ੍ਸ਼਼ਤਯਾ ਉੱਤਿਸ਼਼੍ਠਨ੍ ਭਿੰਨੋ ਭਵਤਿ ਤਰ੍ਹਿ ਸੋਪਿ ਸ੍ਥਿਰੰ ਸ੍ਥਾਤੁੰ ਨ ਸ਼ਕ੍ਨੋਤਿ ਕਿਨ੍ਤੂੱਛਿੰਨੋ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","ਅਪਰਞ੍ਚ ਪ੍ਰਬਲੰ ਜਨੰ ਪ੍ਰਥਮੰ ਨ ਬੱਧਾ ਕੋਪਿ ਤਸ੍ਯ ਗ੍ਰੁʼਹੰ ਪ੍ਰਵਿਸ਼੍ਯ ਦ੍ਰਵ੍ਯਾਣਿ ਲੁਣ੍ਠਯਿਤੁੰ ਨ ਸ਼ਕ੍ਨੋਤਿ, ਤੰ ਬਦ੍ੱਵੈਵ ਤਸ੍ਯ ਗ੍ਰੁʼਹਸ੍ਯ ਦ੍ਰਵ੍ਯਾਣਿ ਲੁਣ੍ਠਯਿਤੁੰ ਸ਼ਕ੍ਨੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","ਅਤੋਹੇਤੋ ਰ੍ਯੁਸ਼਼੍ਮਭ੍ਯਮਹੰ ਸਤ੍ਯੰ ਕਥਯਾਮਿ ਮਨੁਸ਼਼੍ਯਾਣਾਂ ਸਨ੍ਤਾਨਾ ਯਾਨਿ ਯਾਨਿ ਪਾਪਾਨੀਸ਼੍ਵਰਨਿਨ੍ਦਾਞ੍ਚ ਕੁਰ੍ੱਵਨ੍ਤਿ ਤੇਸ਼਼ਾਂ ਤਤ੍ਸਰ੍ੱਵੇਸ਼਼ਾਮਪਰਾਧਾਨਾਂ ਕ੍ਸ਼਼ਮਾ ਭਵਿਤੁੰ ਸ਼ਕ੍ਨੋਤਿ, ");
INSERT INTO sanpun_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ਕਿਨ੍ਤੁ ਯਃ ਕਸ਼੍ਚਿਤ੍ ਪਵਿਤ੍ਰਮਾਤ੍ਮਾਨੰ ਨਿਨ੍ਦਤਿ ਤਸ੍ਯਾਪਰਾਧਸ੍ਯ ਕ੍ਸ਼਼ਮਾ ਕਦਾਪਿ ਨ ਭਵਿਸ਼਼੍ਯਤਿ ਸੋਨਨ੍ਤਦਣ੍ਡਸ੍ਯਾਰ੍ਹੋ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","ਤਸ੍ਯਾਪਵਿਤ੍ਰਭੂਤੋ(ਅ)ਸ੍ਤਿ ਤੇਸ਼਼ਾਮੇਤਤ੍ਕਥਾਹੇਤੋਃ ਸ ਇੱਥੰ ਕਥਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ਅਥ ਤਸ੍ਯ ਮਾਤਾ ਭ੍ਰਾਤ੍ਰੁʼਗਣਸ਼੍ਚਾਗਤ੍ਯ ਬਹਿਸ੍ਤਿਸ਼਼੍ਠਨਤੋ ਲੋਕਾਨ੍ ਪ੍ਰੇਸ਼਼੍ਯ ਤਮਾਹੂਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ਤਤਸ੍ਤਤ੍ਸੰਨਿਧੌ ਸਮੁਪਵਿਸ਼਼੍ਟਾ ਲੋਕਾਸ੍ਤੰ ਬਭਾਸ਼਼ਿਰੇ ਪਸ਼੍ਯ ਬਹਿਸ੍ਤਵ ਮਾਤਾ ਭ੍ਰਾਤਰਸ਼੍ਚ ਤ੍ਵਾਮ੍ ਅਨ੍ਵਿੱਛਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ਤਦਾ ਸ ਤਾਨ੍ ਪ੍ਰਤ੍ਯੁਵਾਚ ਮਮ ਮਾਤਾ ਕਾ ਭ੍ਰਾਤਰੋ ਵਾ ਕੇ? ਤਤਃ ਪਰੰ ਸ ਸ੍ਵਮੀਪੋਪਵਿਸ਼਼੍ਟਾਨ੍ ਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਪ੍ਰਤਿ ਅਵਲੋਕਨੰ ਕ੍ਰੁʼਤ੍ਵਾ ਕਥਯਾਮਾਸ ");
INSERT INTO sanpun_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ਪਸ਼੍ਯਤੈਤੇ ਮਮ ਮਾਤਾ ਭ੍ਰਾਤਰਸ਼੍ਚ| ");
INSERT INTO sanpun_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ਯਃ ਕਸ਼੍ਚਿਦ੍ ਈਸ਼੍ਵਰਸ੍ਯੇਸ਼਼੍ਟਾਂ ਕ੍ਰਿਯਾਂ ਕਰੋਤਿ ਸ ਏਵ ਮਮ ਭ੍ਰਾਤਾ ਭਗਿਨੀ ਮਾਤਾ ਚ| ");
INSERT INTO sanpun_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","ਅਨਨ੍ਤਰੰ ਸ ਸਮੁਦ੍ਰਤਟੇ ਪੁਨਰੁਪਦੇਸ਼਼੍ਟੁੰ ਪ੍ਰਾਰੇਭੇ, ਤਤਸ੍ਤਤ੍ਰ ਬਹੁਜਨਾਨਾਂ ਸਮਾਗਮਾਤ੍ ਸ ਸਾਗਰੋਪਰਿ ਨੌਕਾਮਾਰੁਹ੍ਯ ਸਮੁਪਵਿਸ਼਼੍ਟਃ; ਸਰ੍ੱਵੇ ਲੋਕਾਃ ਸਮੁਦ੍ਰਕੂਲੇ ਤਸ੍ਥੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ਤਦਾ ਸ ਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤਕਥਾਭਿ ਰ੍ਬਹੂਪਦਿਸ਼਼੍ਟਵਾਨ੍ ਉਪਦਿਸ਼ੰਸ਼੍ਚ ਕਥਿਤਵਾਨ੍, ");
INSERT INTO sanpun_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","ਅਵਧਾਨੰ ਕੁਰੁਤ, ਏਕੋ ਬੀਜਵਪ੍ਤਾ ਬੀਜਾਨਿ ਵਪ੍ਤੁੰ ਗਤਃ; ");
INSERT INTO sanpun_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ਵਪਨਕਾਲੇ ਕਿਯਨ੍ਤਿ ਬੀਜਾਨਿ ਮਾਰ੍ਗਪਾਸ਼੍ਵੇ ਪਤਿਤਾਨਿ, ਤਤ ਆਕਾਸ਼ੀਯਪਕ੍ਸ਼਼ਿਣ ਏਤ੍ਯ ਤਾਨਿ ਚਖਾਦੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","ਕਿਯਨ੍ਤਿ ਬੀਜਾਨਿ ਸ੍ਵਲ੍ਪਮ੍ਰੁʼੱਤਿਕਾਵਤ੍ਪਾਸ਼਼ਾਣਭੂਮੌ ਪਤਿਤਾਨਿ ਤਾਨਿ ਮ੍ਰੁʼਦੋਲ੍ਪਤ੍ਵਾਤ੍ ਸ਼ੀਘ੍ਰਮਙ੍ਕੁਰਿਤਾਨਿ; ");
INSERT INTO sanpun_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ਕਿਨ੍ਤੂਦਿਤੇ ਸੂਰ੍ੱਯੇ ਦਗ੍ਧਾਨਿ ਤਥਾ ਮੂਲਾਨੋ ਨਾਧੋਗਤਤ੍ਵਾਤ੍ ਸ਼ੁਸ਼਼੍ਕਾਣਿ ਚ| ");
INSERT INTO sanpun_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","ਕਿਯਨ੍ਤਿ ਬੀਜਾਨਿ ਕਣ੍ਟਕਿਵਨਮਧ੍ਯੇ ਪਤਿਤਾਨਿ ਤਤਃ ਕਣ੍ਟਕਾਨਿ ਸੰਵ੍ਰੁʼਦ੍ਵ੍ਯ ਤਾਨਿ ਜਗ੍ਰਸੁਸ੍ਤਾਨਿ ਨ ਚ ਫਲਿਤਾਨਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","ਤਥਾ ਕਿਯਨ੍ਤਿ ਬੀਜਾਨ੍ਯੁੱਤਮਭੂਮੌ ਪਤਿਤਾਨਿ ਤਾਨਿ ਸੰਵ੍ਰੁʼਦ੍ਵ੍ਯ ਫਲਾਨ੍ਯੁਤ੍ਪਾਦਿਤਾਨਿ ਕਿਯਨ੍ਤਿ ਬੀਜਾਨਿ ਤ੍ਰਿੰਸ਼ਦ੍ਗੁਣਾਨਿ ਕਿਯਨ੍ਤਿ ਸ਼਼ਸ਼਼੍ਟਿਗੁਣਾਨਿ ਕਿਯਨ੍ਤਿ ਸ਼ਤਗੁਣਾਨਿ ਫਲਾਨਿ ਫਲਿਤਵਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ਅਥ ਸ ਤਾਨਵਦਤ੍ ਯਸ੍ਯ ਸ਼੍ਰੋਤੁੰ ਕਰ੍ਣੌ ਸ੍ਤਃ ਸ ਸ਼੍ਰੁʼਣੋਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","ਤਦਨਨ੍ਤਰੰ ਨਿਰ੍ਜਨਸਮਯੇ ਤਤ੍ਸਙ੍ਗਿਨੋ ਦ੍ਵਾਦਸ਼ਸ਼ਿਸ਼਼੍ਯਾਸ਼੍ਚ ਤੰ ਤੱਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤਵਾਕ੍ਯਸ੍ਯਾਰ੍ਥੰ ਪਪ੍ਰੱਛੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ਤਦਾ ਸ ਤਾਨੁਦਿਤਵਾਨ੍ ਈਸ਼੍ਵਰਰਾਜ੍ਯਸ੍ਯ ਨਿਗੂਢਵਾਕ੍ਯੰ ਬੋੱਧੁੰ ਯੁਸ਼਼੍ਮਾਕਮਧਿਕਾਰੋ(ਅ)ਸ੍ਤਿ; ");
INSERT INTO sanpun_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ਕਿਨ੍ਤੁ ਯੇ ਵਹਿਰ੍ਭੂਤਾਃ \"ਤੇ ਪਸ਼੍ਯਨ੍ਤਃ ਪਸ਼੍ਯਨ੍ਤਿ ਕਿਨ੍ਤੁ ਨ ਜਾਨਨ੍ਤਿ, ਸ਼੍ਰੁʼਣ੍ਵਨ੍ਤਃ ਸ਼੍ਰੁʼਣ੍ਵਨ੍ਤਿ ਕਿਨ੍ਤੁ ਨ ਬੁਧ੍ਯਨ੍ਤੇ, ਚੇੱਤੈ ਰ੍ਮਨਃਸੁ ਕਦਾਪਿ ਪਰਿਵਰ੍ੱਤਿਤੇਸ਼਼ੁ ਤੇਸ਼਼ਾਂ ਪਾਪਾਨ੍ਯਮੋਚਯਿਸ਼਼੍ਯਨ੍ਤ,\" ਅਤੋਹੇਤੋਸ੍ਤਾਨ੍ ਪ੍ਰਤਿ ਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤੈਰੇਵ ਤਾਨਿ ਮਯਾ ਕਥਿਤਾਨਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","ਅਥ ਸ ਕਥਿਤਵਾਨ੍ ਯੂਯੰ ਕਿਮੇਤਦ੍ ਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤਵਾਕ੍ਯੰ ਨ ਬੁਧ੍ਯਧ੍ਵੇ? ਤਰ੍ਹਿ ਕਥੰ ਸਰ੍ੱਵਾਨ੍ ਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤਾਨ ਭੋਤ੍ਸ੍ਯਧ੍ਵੇ? ");
INSERT INTO sanpun_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ਬੀਜਵਪ੍ਤਾ ਵਾਕ੍ਯਰੂਪਾਣਿ ਬੀਜਾਨਿ ਵਪਤਿ; ");
INSERT INTO sanpun_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ਤਤ੍ਰ ਯੇ ਯੇ ਲੋਕਾ ਵਾਕ੍ਯੰ ਸ਼੍ਰੁʼਣ੍ਵਨ੍ਤਿ, ਕਿਨ੍ਤੁ ਸ਼੍ਰੁਤਮਾਤ੍ਰਾਤ੍ ਸ਼ੈਤਾਨ੍ ਸ਼ੀਘ੍ਰਮਾਗਤ੍ਯ ਤੇਸ਼਼ਾਂ ਮਨਃਸੂਪ੍ਤਾਨਿ ਤਾਨਿ ਵਾਕ੍ਯਰੂਪਾਣਿ ਬੀਜਾਨ੍ਯਪਨਯਤਿ ਤਏਵ ਉਪ੍ਤਬੀਜਮਾਰ੍ਗਪਾਰ੍ਸ਼੍ਵੇਸ੍ਵਰੂਪਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ਯੇ ਜਨਾ ਵਾਕ੍ਯੰ ਸ਼੍ਰੁਤ੍ਵਾ ਸਹਸਾ ਪਰਮਾਨਨ੍ਦੇਨ ਗ੍ਰੁʼਹ੍ਲਨ੍ਤਿ, ਕਿਨ੍ਤੁ ਹ੍ਰੁʼਦਿ ਸ੍ਥੈਰ੍ੱਯਾਭਾਵਾਤ੍ ਕਿਞ੍ਚਿਤ੍ ਕਾਲਮਾਤ੍ਰੰ ਤਿਸ਼਼੍ਠਨ੍ਤਿ ਤਤ੍ਪਸ਼੍ਚਾਤ੍ ਤਦ੍ਵਾਕ੍ਯਹੇਤੋਃ ");
INSERT INTO sanpun_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ਕੁਤ੍ਰਚਿਤ੍ ਕ੍ਲੇਸ਼ੇ ਉਪਦ੍ਰਵੇ ਵਾ ਸਮੁਪਸ੍ਥਿਤੇ ਤਦੈਵ ਵਿਘ੍ਨੰ ਪ੍ਰਾਪ੍ਨੁਵਨ੍ਤਿ ਤਏਵ ਉਪ੍ਤਬੀਜਪਾਸ਼਼ਾਣਭੂਮਿਸ੍ਵਰੂਪਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","ਯੇ ਜਨਾਃ ਕਥਾਂ ਸ਼੍ਰੁʼਣ੍ਵਨ੍ਤਿ ਕਿਨ੍ਤੁ ਸਾਂਸਾਰਿਕੀ ਚਿਨ੍ਤਾ ਧਨਭ੍ਰਾਨ੍ਤਿ ਰ੍ਵਿਸ਼਼ਯਲੋਭਸ਼੍ਚ ਏਤੇ ਸਰ੍ੱਵੇ ਉਪਸ੍ਥਾਯ ਤਾਂ ਕਥਾਂ ਗ੍ਰਸਨ੍ਤਿ ਤਤਃ ਮਾ ਵਿਫਲਾ ਭਵਤਿ ");
INSERT INTO sanpun_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ਤਏਵ ਉਪ੍ਤਬੀਜਸਕਣ੍ਟਕਭੂਮਿਸ੍ਵਰੂਪਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ਯੇ ਜਨਾ ਵਾਕ੍ਯੰ ਸ਼੍ਰੁਤ੍ਵਾ ਗ੍ਰੁʼਹ੍ਲਨ੍ਤਿ ਤੇਸ਼਼ਾਂ ਕਸ੍ਯ ਵਾ ਤ੍ਰਿੰਸ਼ਦ੍ਗੁਣਾਨਿ ਕਸ੍ਯ ਵਾ ਸ਼਼ਸ਼਼੍ਟਿਗੁਣਾਨਿ ਕਸ੍ਯ ਵਾ ਸ਼ਤਗੁਣਾਨਿ ਫਲਾਨਿ ਭਵਨ੍ਤਿ ਤਏਵ ਉਪ੍ਤਬੀਜੋਰ੍ੱਵਰਭੂਮਿਸ੍ਵਰੂਪਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ਤਦਾ ਸੋ(ਅ)ਪਰਮਪਿ ਕਥਿਤਵਾਨ੍ ਕੋਪਿ ਜਨੋ ਦੀਪਾਧਾਰੰ ਪਰਿਤ੍ਯਜ੍ਯ ਦ੍ਰੋਣਸ੍ਯਾਧਃ ਖਟ੍ਵਾਯਾ ਅਧੇ ਵਾ ਸ੍ਥਾਪਯਿਤੁੰ ਦੀਪਮਾਨਯਤਿ ਕਿੰ? ");
INSERT INTO sanpun_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","ਅਤੋਹੇਤੋ ਰ੍ਯੰਨ ਪ੍ਰਕਾਸ਼ਯਿਸ਼਼੍ਯਤੇ ਤਾਦ੍ਰੁʼਗ੍ ਲੁੱਕਾਯਿਤੰ ਕਿਮਪਿ ਵਸ੍ਤੁ ਨਾਸ੍ਤਿ; ਯਦ੍ ਵ੍ਯਕ੍ਤੰ ਨ ਭਵਿਸ਼਼੍ਯਤਿ ਤਾਦ੍ਰੁʼਸ਼ੰ ਗੁਪ੍ਤੰ ਕਿਮਪਿ ਵਸ੍ਤੁ ਨਾਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ਯਸ੍ਯ ਸ਼੍ਰੋਤੁੰ ਕਰ੍ਣੌ ਸ੍ਤਃ ਸ ਸ਼੍ਰੁʼਣੋਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","ਅਪਰਮਪਿ ਕਥਿਤਵਾਨ੍ ਯੂਯੰ ਯਦ੍ ਯਦ੍ ਵਾਕ੍ਯੰ ਸ਼੍ਰੁʼਣੁਥ ਤਤ੍ਰ ਸਾਵਧਾਨਾ ਭਵਤ, ਯਤੋ ਯੂਯੰ ਯੇਨ ਪਰਿਮਾਣੇਨ ਪਰਿਮਾਥ ਤੇਨੈਵ ਪਰਿਮਾਣੇਨ ਯੁਸ਼਼੍ਮਦਰ੍ਥਮਪਿ ਪਰਿਮਾਸ੍ਯਤੇ; ਸ਼੍ਰੋਤਾਰੋ ਯੂਯੰ ਯੁਸ਼਼੍ਮਭ੍ਯਮਧਿਕੰ ਦਾਸ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","ਯਸ੍ਯਾਸ਼੍ਰਯੇ ਵਰ੍ੱਧਤੇ ਤਸ੍ਮੈ ਅਪਰਮਪਿ ਦਾਸ੍ਯਤੇ, ਕਿਨ੍ਤੁ ਯਸ੍ਯਾਸ਼੍ਰਯੇ ਨ ਵਰ੍ੱਧਤੇ ਤਸ੍ਯ ਯਤ੍ ਕਿਞ੍ਚਿਦਸ੍ਤਿ ਤਦਪਿ ਤਸ੍ਮਾਨ੍ ਨੇਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","ਅਨਨ੍ਤਰੰ ਸ ਕਥਿਤਵਾਨ੍ ਏਕੋ ਲੋਕਃ ਕ੍ਸ਼਼ੇਤ੍ਰੇ ਬੀਜਾਨ੍ਯੁਪ੍ਤ੍ਵਾ ");
INSERT INTO sanpun_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ਜਾਗਰਣਨਿਦ੍ਰਾਭ੍ਯਾਂ ਦਿਵਾਨਿਸ਼ੰ ਗਮਯਤਿ, ਪਰਨ੍ਤੁ ਤਦ੍ਵੀਜੰ ਤਸ੍ਯਾਜ੍ਞਾਤਰੂਪੇਣਾਙ੍ਕੁਰਯਤਿ ਵਰ੍ੱਧਤੇ ਚ; ");
INSERT INTO sanpun_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ਯਤੋਹੇਤੋਃ ਪ੍ਰਥਮਤਃ ਪਤ੍ਰਾਣਿ ਤਤਃ ਪਰੰ ਕਣਿਸ਼ਾਨਿ ਤਤ੍ਪਸ਼੍ਚਾਤ੍ ਕਣਿਸ਼ਪੂਰ੍ਣਾਨਿ ਸ਼ਸ੍ਯਾਨਿ ਭੂਮਿਃ ਸ੍ਵਯਮੁਤ੍ਪਾਦਯਤਿ; ");
INSERT INTO sanpun_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ਕਿਨ੍ਤੁ ਫਲੇਸ਼਼ੁ ਪੱਕੇਸ਼਼ੁ ਸ਼ਸ੍ਯੱਛੇਦਨਕਾਲੰ ਜ੍ਞਾਤ੍ਵਾ ਸ ਤਤ੍ਕ੍ਸ਼਼ਣੰ ਸ਼ਸ੍ਯਾਨਿ ਛਿਨੱਤਿ, ਅਨੇਨ ਤੁਲ੍ਯਮੀਸ਼੍ਵਰਰਾਜ੍ਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","ਪੁਨਃ ਸੋ(ਅ)ਕਥਯਦ੍ ਈਸ਼੍ਵਰਰਾਜ੍ਯੰ ਕੇਨ ਸਮੰ? ਕੇਨ ਵਸ੍ਤੁਨਾ ਸਹ ਵਾ ਤਦੁਪਮਾਸ੍ਯਾਮਿ? ");
INSERT INTO sanpun_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","ਤਤ੍ ਸਰ੍ਸ਼਼ਪੈਕੇਨ ਤੁਲ੍ਯੰ ਯਤੋ ਮ੍ਰੁʼਦਿ ਵਪਨਕਾਲੇ ਸਰ੍ਸ਼਼ਪਬੀਜੰ ਸਰ੍ੱਵਪ੍ਰੁʼਥਿਵੀਸ੍ਥਬੀਜਾਤ੍ ਕ੍ਸ਼਼ੁਦ੍ਰੰ ");
INSERT INTO sanpun_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ਕਿਨ੍ਤੁ ਵਪਨਾਤ੍ ਪਰਮ੍ ਅਙ੍ਕੁਰਯਿਤ੍ਵਾ ਸਰ੍ੱਵਸ਼ਾਕਾਦ੍ ਬ੍ਰੁʼਹਦ੍ ਭਵਤਿ, ਤਸ੍ਯ ਬ੍ਰੁʼਹਤ੍ਯਃ ਸ਼ਾਖਾਸ਼੍ਚ ਜਾਯਨ੍ਤੇ ਤਤਸ੍ਤੱਛਾਯਾਂ ਪਕ੍ਸ਼਼ਿਣ ਆਸ਼੍ਰਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ਇੱਥੰ ਤੇਸ਼਼ਾਂ ਬੋਧਾਨੁਰੂਪੰ ਸੋ(ਅ)ਨੇਕਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤੈਸ੍ਤਾਨੁਪਦਿਸ਼਼੍ਟਵਾਨ੍, ");
INSERT INTO sanpun_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤੰ ਵਿਨਾ ਕਾਮਪਿ ਕਥਾਂ ਤੇਭ੍ਯੋ ਨ ਕਥਿਤਵਾਨ੍ ਪਸ਼੍ਚਾਨ੍ ਨਿਰ੍ਜਨੇ ਸ ਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਸਰ੍ੱਵਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤਾਰ੍ਥੰ ਬੋਧਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","ਤੱਦਿਨਸ੍ਯ ਸਨ੍ਧ੍ਯਾਯਾਂ ਸ ਤੇਭ੍ਯੋ(ਅ)ਕਥਯਦ੍ ਆਗੱਛਤ ਵਯੰ ਪਾਰੰ ਯਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ਤਦਾ ਤੇ ਲੋਕਾਨ੍ ਵਿਸ੍ਰੁʼਜ੍ਯ ਤਮਵਿਲਮ੍ਬੰ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਨੌਕਯਾ ਪ੍ਰਤਸ੍ਥਿਰੇ; ਅਪਰਾ ਅਪਿ ਨਾਵਸ੍ਤਯਾ ਸਹ ਸ੍ਥਿਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ਤਤਃ ਪਰੰ ਮਹਾਝਞ੍ਭ੍ਸ਼ਗਮਾਤ੍ ਨੌ ਰ੍ਦੋਲਾਯਮਾਨਾ ਤਰਙ੍ਗੇਣ ਜਲੈਃ ਪੂਰ੍ਣਾਭਵੱਚ| ");
INSERT INTO sanpun_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ਤਦਾ ਸ ਨੌਕਾਚਸ਼੍ਚਾਦ੍ਭਾਗੇ ਉਪਧਾਨੇ ਸ਼ਿਰੋ ਨਿਧਾਯ ਨਿਦ੍ਰਿਤ ਆਸੀਤ੍ ਤਤਸ੍ਤੇ ਤੰ ਜਾਗਰਯਿਤ੍ਵਾ ਜਗਦੁਃ, ਹੇ ਪ੍ਰਭੋ, ਅਸ੍ਮਾਕੰ ਪ੍ਰਾਣਾ ਯਾਨ੍ਤਿ ਕਿਮਤ੍ਰ ਭਵਤਸ਼੍ਚਿਨ੍ਤਾ ਨਾਸ੍ਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ਤਦਾ ਸ ਉੱਥਾਯ ਵਾਯੁੰ ਤਰ੍ਜਿਤਵਾਨ੍ ਸਮੁਦ੍ਰਞ੍ਚੋਕ੍ਤਵਾਨ੍ ਸ਼ਾਨ੍ਤਃ ਸੁਸ੍ਥਿਰਸ਼੍ਚ ਭਵ; ਤਤੋ ਵਾਯੌ ਨਿਵ੍ਰੁʼੱਤੇ(ਅ)ਬ੍ਧਿਰ੍ਨਿਸ੍ਤਰਙ੍ਗੋਭੂਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","ਤਦਾ ਸ ਤਾਨੁਵਾਚ ਯੂਯੰ ਕੁਤ ਏਤਾਦ੍ਰੁʼਕ੍ਸ਼ਙ੍ਕਾਕੁਲਾ ਭਵਤ? ਕਿੰ ਵੋ ਵਿਸ਼੍ਵਾਸੋ ਨਾਸ੍ਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ਤਸ੍ਮਾੱਤੇ(ਅ)ਤੀਵਭੀਤਾਃ ਪਰਸ੍ਪਰੰ ਵਕ੍ਤੁਮਾਰੇਭਿਰੇ, ਅਹੋ ਵਾਯੁਃ ਸਿਨ੍ਧੁਸ਼੍ਚਾਸ੍ਯ ਨਿਦੇਸ਼ਗ੍ਰਾਹਿਣੌ ਕੀਦ੍ਰੁʼਗਯੰ ਮਨੁਜਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ਅਥ ਤੂ ਸਿਨ੍ਧੁਪਾਰੰ ਗਤ੍ਵਾ ਗਿਦੇਰੀਯਪ੍ਰਦੇਸ਼ ਉਪਤਸ੍ਥੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ਨੌਕਾਤੋ ਨਿਰ੍ਗਤਮਾਤ੍ਰਾਦ੍ ਅਪਵਿਤ੍ਰਭੂਤਗ੍ਰਸ੍ਤ ਏਕਃ ਸ਼੍ਮਸ਼ਾਨਾਦੇਤ੍ਯ ਤੰ ਸਾਕ੍ਸ਼਼ਾਚ੍ ਚਕਾਰ| ");
INSERT INTO sanpun_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ਸ ਸ਼੍ਮਸ਼ਾਨੇ(ਅ)ਵਾਤ੍ਸੀਤ੍ ਕੋਪਿ ਤੰ ਸ਼੍ਰੁʼਙ੍ਖਲੇਨ ਬਦ੍ੱਵਾ ਸ੍ਥਾਪਯਿਤੁੰ ਨਾਸ਼ਕ੍ਨੋਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ਜਨੈਰ੍ਵਾਰੰ ਨਿਗਡੈਃ ਸ਼੍ਰੁʼਙ੍ਖਲੈਸ਼੍ਚ ਸ ਬੱਧੋਪਿ ਸ਼੍ਰੁʼਙ੍ਖਲਾਨ੍ਯਾਕ੍ਰੁʼਸ਼਼੍ਯ ਮੋਚਿਤਵਾਨ੍ ਨਿਗਡਾਨਿ ਚ ਭੰਕ੍ਤ੍ਵਾ ਖਣ੍ਡੰ ਖਣ੍ਡੰ ਕ੍ਰੁʼਤਵਾਨ੍ ਕੋਪਿ ਤੰ ਵਸ਼ੀਕਰ੍ੱਤੁੰ ਨ ਸ਼ਸ਼ਕ| ");
INSERT INTO sanpun_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ਦਿਵਾਨਿਸ਼ੰ ਸਦਾ ਪਰ੍ੱਵਤੰ ਸ਼੍ਮਸ਼ਾਨਞ੍ਚ ਭ੍ਰਮਿਤ੍ਵਾ ਚੀਤ੍ਸ਼ਬ੍ਦੰ ਕ੍ਰੁʼਤਵਾਨ੍ ਗ੍ਰਾਵਭਿਸ਼੍ਚ ਸ੍ਵਯੰ ਸ੍ਵੰ ਕ੍ਰੁʼਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ਸ ਯੀਸ਼ੁੰ ਦੂਰਾਤ੍ ਪਸ਼੍ਯੰਨੇਵ ਧਾਵਨ੍ ਤੰ ਪ੍ਰਣਨਾਮ ਉਚੈਰੁਵੰਸ਼੍ਚੋਵਾਚ, ");
INSERT INTO sanpun_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ਹੇ ਸਰ੍ੱਵੋਪਰਿਸ੍ਥੇਸ਼੍ਵਰਪੁਤ੍ਰ ਯੀਸ਼ੋ ਭਵਤਾ ਸਹ ਮੇ ਕਃ ਸਮ੍ਬਨ੍ਧਃ? ਅਹੰ ਤ੍ਵਾਮੀਸ਼੍ਵਰੇਣ ਸ਼ਾਪਯੇ ਮਾਂ ਮਾ ਯਾਤਯ| ");
INSERT INTO sanpun_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","ਯਤੋ ਯੀਸ਼ੁਸ੍ਤੰ ਕਥਿਤਵਾਨ੍ ਰੇ ਅਪਵਿਤ੍ਰਭੂਤ, ਅਸ੍ਮਾੰਨਰਾਦ੍ ਬਹਿਰ੍ਨਿਰ੍ਗੱਛ| ");
INSERT INTO sanpun_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","ਅਥ ਸ ਤੰ ਪ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍ ਕਿਨ੍ਤੇ ਨਾਮ? ਤੇਨ ਪ੍ਰਤ੍ਯੁਕ੍ਤੰ ਵਯਮਨੇਕੇ (ਅ)ਸ੍ਮਸ੍ਤਤੋ(ਅ)ਸ੍ਮੰਨਾਮ ਬਾਹਿਨੀ| ");
INSERT INTO sanpun_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ਤਤੋਸ੍ਮਾਨ੍ ਦੇਸ਼ਾੰਨ ਪ੍ਰੇਸ਼਼ਯੇਤਿ ਤੇ ਤੰ ਪ੍ਰਾਰ੍ਥਯਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ਤਦਾਨੀਂ ਪਰ੍ੱਵਤੰ ਨਿਕਸ਼਼ਾ ਬ੍ਰੁʼਹਨ੍ ਵਰਾਹਵ੍ਰਜਸ਼੍ਚਰੰਨਾਸੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ਤਸ੍ਮਾਦ੍ ਭੂਤਾ ਵਿਨਯੇਨ ਜਗਦੁਃ, ਅਮੁੰ ਵਰਾਹਵ੍ਰਜਮ੍ ਆਸ਼੍ਰਯਿਤੁਮ੍ ਅਸ੍ਮਾਨ੍ ਪ੍ਰਹਿਣੁ| ");
INSERT INTO sanpun_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ਯੀਸ਼ੁਨਾਨੁਜ੍ਞਾਤਾਸ੍ਤੇ(ਅ)ਪਵਿਤ੍ਰਭੂਤਾ ਬਹਿਰ੍ਨਿਰ੍ਯਾਯ ਵਰਾਹਵ੍ਰਜੰ ਪ੍ਰਾਵਿਸ਼ਨ੍ ਤਤਃ ਸਰ੍ੱਵੇ ਵਰਾਹਾ ਵਸ੍ਤੁਤਸ੍ਤੁ ਪ੍ਰਾਯੋਦ੍ਵਿਸਹਸ੍ਰਸੰਙ੍ਖ੍ਯਕਾਃ ਕਟਕੇਨ ਮਹਾਜਵਾਦ੍ ਧਾਵਨ੍ਤਃ ਸਿਨ੍ਧੌ ਪ੍ਰਾਣਾਨ੍ ਜਹੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ਤਸ੍ਮਾਦ੍ ਵਰਾਹਪਾਲਕਾਃ ਪਲਾਯਮਾਨਾਃ ਪੁਰੇ ਗ੍ਰਾਮੇ ਚ ਤਦ੍ਵਾਰ੍ੱਤੰ ਕਥਯਾਞ੍ਚਕ੍ਰੁਃ| ਤਦਾ ਲੋਕਾ ਘਟਿਤੰ ਤਤ੍ਕਾਰ੍ੱਯੰ ਦ੍ਰਸ਼਼੍ਟੁੰ ਬਹਿਰ੍ਜਗ੍ਮੁਃ ");
INSERT INTO sanpun_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ਯੀਸ਼ੋਃ ਸੰਨਿਧਿੰ ਗਤ੍ਵਾ ਤੰ ਭੂਤਗ੍ਰਸ੍ਤਮ੍ ਅਰ੍ਥਾਦ੍ ਬਾਹਿਨੀਭੂਤਗ੍ਰਸ੍ਤੰ ਨਰੰ ਸਵਸ੍ਤ੍ਰੰ ਸਚੇਤਨੰ ਸਮੁਪਵਿਸ਼਼੍ਟਞ੍ਚ ਦ੍ਰੁʼृਸ਼਼੍ਟ੍ਵਾ ਬਿਭ੍ਯੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ਤਤੋ ਦ੍ਰੁʼਸ਼਼੍ਟਤਤ੍ਕਾਰ੍ੱਯਲੋਕਾਸ੍ਤਸ੍ਯ ਭੂਤਗ੍ਰਸ੍ਤਨਰਸ੍ਯ ਵਰਾਹਵ੍ਰਜਸ੍ਯਾਪਿ ਤਾਂ ਧਟਨਾਂ ਵਰ੍ਣਯਾਮਾਸੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ਤਤਸ੍ਤੇ ਸ੍ਵਸੀਮਾਤੋ ਬਹਿਰ੍ਗਨ੍ਤੁੰ ਯੀਸ਼ੁੰ ਵਿਨੇਤੁਮਾਰੇਭਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ਅਥ ਤਸ੍ਯ ਨੌਕਾਰੋਹਣਕਾਲੇ ਸ ਭੂਤਮੁਕ੍ਤੋ ਨਾ ਯੀਸ਼ੁਨਾ ਸਹ ਸ੍ਥਾਤੁੰ ਪ੍ਰਾਰ੍ਥਯਤੇ; ");
INSERT INTO sanpun_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","ਕਿਨ੍ਤੁ ਸ ਤਮਨਨੁਮਤ੍ਯ ਕਥਿਤਵਾਨ੍ ਤ੍ਵੰ ਨਿਜਾਤ੍ਮੀਯਾਨਾਂ ਸਮੀਪੰ ਗ੍ਰੁʼਹਞ੍ਚ ਗੱਛ ਪ੍ਰਭੁਸ੍ਤ੍ਵਯਿ ਕ੍ਰੁʼਪਾਂ ਕ੍ਰੁʼਤ੍ਵਾ ਯਾਨਿ ਕਰ੍ੰਮਾਣਿ ਕ੍ਰੁʼਤਵਾਨ੍ ਤਾਨਿ ਤਾਨ੍ ਜ੍ਞਾਪਯ| ");
INSERT INTO sanpun_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ਅਤਃ ਸ ਪ੍ਰਸ੍ਥਾਯ ਯੀਸ਼ੁਨਾ ਕ੍ਰੁʼਤੰ ਤਤ੍ਸਰ੍ੱਵਾਸ਼੍ਚਰ੍ੱਯੰ ਕਰ੍ੰਮ ਦਿਕਾਪਲਿਦੇਸ਼ੇ ਪ੍ਰਚਾਰਯਿਤੁੰ ਪ੍ਰਾਰਬ੍ਧਵਾਨ੍ ਤਤਃ ਸਰ੍ੱਵੇ ਲੋਕਾ ਆਸ਼੍ਚਰ੍ੱਯੰ ਮੇਨਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","ਅਨਨ੍ਤਰੰ ਯੀਸ਼ੌ ਨਾਵਾ ਪੁਨਰਨ੍ਯਪਾਰ ਉੱਤੀਰ੍ਣੇ ਸਿਨ੍ਧੁਤਟੇ ਚ ਤਿਸ਼਼੍ਠਤਿ ਸਤਿ ਤਤ੍ਸਮੀਪੇ ਬਹੁਲੋਕਾਨਾਂ ਸਮਾਗਮੋ(ਅ)ਭੂਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ਅਪਰੰ ਯਾਯੀਰ੍ ਨਾਮ੍ਨਾ ਕਸ਼੍ਚਿਦ੍ ਭਜਨਗ੍ਰੁʼਹਸ੍ਯਾਧਿਪ ਆਗਤ੍ਯ ਤੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵੈਵ ਚਰਣਯੋਃ ਪਤਿਤ੍ਵਾ ਬਹੁ ਨਿਵੇਦ੍ਯ ਕਥਿਤਵਾਨ੍; ");
INSERT INTO sanpun_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ਮਮ ਕਨ੍ਯਾ ਮ੍ਰੁʼਤਪ੍ਰਾਯਾਭੂਦ੍ ਅਤੋ ਭਵਾਨੇਤ੍ਯ ਤਦਾਰੋਗ੍ਯਾਯ ਤਸ੍ਯਾ ਗਾਤ੍ਰੇ ਹਸ੍ਤਮ੍ ਅਰ੍ਪਯਤੁ ਤੇਨੈਵ ਸਾ ਜੀਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ਤਦਾ ਯੀਸ਼ੁਸ੍ਤੇਨ ਸਹ ਚਲਿਤਃ ਕਿਨ੍ਤੁ ਤਤ੍ਪਸ਼੍ਚਾਦ੍ ਬਹੁਲੋਕਾਸ਼੍ਚਲਿਤ੍ਵਾ ਤਾਦ੍ਗਾਤ੍ਰੇ ਪਤਿਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","ਅਥ ਦ੍ਵਾਦਸ਼ਵਰ੍ਸ਼਼ਾਣਿ ਪ੍ਰਦਰਰੋਗੇਣ ");
INSERT INTO sanpun_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ਸ਼ੀਰ੍ਣਾ ਚਿਕਿਤ੍ਸਕਾਨਾਂ ਨਾਨਾਚਿਕਿਤ੍ਸਾਭਿਸ਼੍ਚ ਦੁਃਖੰ ਭੁਕ੍ਤਵਤੀ ਚ ਸਰ੍ੱਵਸ੍ਵੰ ਵ੍ਯਯਿਤ੍ਵਾਪਿ ਨਾਰੋਗ੍ਯੰ ਪ੍ਰਾਪ੍ਤਾ ਚ ਪੁਨਰਪਿ ਪੀਡਿਤਾਸੀੱਚ ");
INSERT INTO sanpun_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ਯਾ ਸ੍ਤ੍ਰੀ ਸਾ ਯੀਸ਼ੋ ਰ੍ਵਾਰ੍ੱਤਾਂ ਪ੍ਰਾਪ੍ਯ ਮਨਸਾਕਥਯਤ੍ ਯਦ੍ਯਹੰ ਤਸ੍ਯ ਵਸ੍ਤ੍ਰਮਾਤ੍ਰ ਸ੍ਪ੍ਰਸ਼਼੍ਟੁੰ ਲਭੇਯੰ ਤਦਾ ਰੋਗਹੀਨਾ ਭਵਿਸ਼਼੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ਅਤੋਹੇਤੋਃ ਸਾ ਲੋਕਾਰਣ੍ਯਮਧ੍ਯੇ ਤਤ੍ਪਸ਼੍ਚਾਦਾਗਤ੍ਯ ਤਸ੍ਯ ਵਸ੍ਤ੍ਰੰ ਪਸ੍ਪਰ੍ਸ਼| ");
INSERT INTO sanpun_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ਤੇਨੈਵ ਤਤ੍ਕ੍ਸ਼਼ਣੰ ਤਸ੍ਯਾ ਰਕ੍ਤਸ੍ਰੋਤਃ ਸ਼ੁਸ਼਼੍ਕੰ ਸ੍ਵਯੰ ਤਸ੍ਮਾਦ੍ ਰੋਗਾਨ੍ਮੁਕ੍ਤਾ ਇਤ੍ਯਪਿ ਦੇਹੇ(ਅ)ਨੁਭੂਤਾ| ");
INSERT INTO sanpun_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","ਅਥ ਸ੍ਵਸ੍ਮਾਤ੍ ਸ਼ਕ੍ਤਿ ਰ੍ਨਿਰ੍ਗਤਾ ਯੀਸ਼ੁਰੇਤਨ੍ਮਨਸਾ ਜ੍ਞਾਤ੍ਵਾ ਲੋਕਨਿਵਹੰ ਪ੍ਰਤਿ ਮੁਖੰ ਵ੍ਯਾਵ੍ਰੁʼਤ੍ਯ ਪ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍ ਕੇਨ ਮਦ੍ਵਸ੍ਤ੍ਰੰ ਸ੍ਪ੍ਰੁʼਸ਼਼੍ਟੰ? ");
INSERT INTO sanpun_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ਤਤਸ੍ਤਸ੍ਯ ਸ਼ਿਸ਼਼੍ਯਾ ਊਚੁਃ ਭਵਤੋ ਵਪੁਸ਼਼ਿ ਲੋਕਾਃ ਸੰਘਰ੍ਸ਼਼ਨ੍ਤਿ ਤਦ੍ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਕੇਨ ਮਦ੍ਵਸ੍ਤ੍ਰੰ ਸ੍ਪ੍ਰੁʼਸ਼਼੍ਟਮਿਤਿ ਕੁਤਃ ਕਥਯਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","ਕਿਨ੍ਤੁ ਕੇਨ ਤਤ੍ ਕਰ੍ੰਮ ਕ੍ਰੁʼਤੰ ਤਦ੍ ਦ੍ਰਸ਼਼੍ਟੁੰ ਯੀਸ਼ੁਸ਼੍ਚਤੁਰ੍ਦਿਸ਼ੋ ਦ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ਤਤਃ ਸਾ ਸ੍ਤ੍ਰੀ ਭੀਤਾ ਕਮ੍ਪਿਤਾ ਚ ਸਤੀ ਸ੍ਵਸ੍ਯਾ ਰੁਕ੍ਪ੍ਰਤਿਕ੍ਰਿਯਾ ਜਾਤੇਤਿ ਜ੍ਞਾਤ੍ਵਾਗਤ੍ਯ ਤਤ੍ਸੰਮੁਖੇ ਪਤਿਤ੍ਵਾ ਸਰ੍ੱਵਵ੍ਰੁʼੱਤਾਨ੍ਤੰ ਸਤ੍ਯੰ ਤਸ੍ਮੈ ਕਥਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ਤਦਾਨੀਂ ਯੀਸ਼ੁਸ੍ਤਾਂ ਗਦਿਤਵਾਨ੍, ਹੇ ਕਨ੍ਯੇ ਤਵ ਪ੍ਰਤੀਤਿਸ੍ਤ੍ਵਾਮ੍ ਅਰੋਗਾਮਕਰੋਤ੍ ਤ੍ਵੰ ਕ੍ਸ਼਼ੇਮੇਣ ਵ੍ਰਜ ਸ੍ਵਰੋਗਾਨ੍ਮੁਕ੍ਤਾ ਚ ਤਿਸ਼਼੍ਠ| ");
INSERT INTO sanpun_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ਇਤਿਵਾਕ੍ਯਵਦਨਕਾਲੇ ਭਜਨਗ੍ਰੁʼਹਾਧਿਪਸ੍ਯ ਨਿਵੇਸ਼ਨਾਲ੍ ਲੋਕਾ ਏਤ੍ਯਾਧਿਪੰ ਬਭਾਸ਼਼ਿਰੇ ਤਵ ਕਨ੍ਯਾ ਮ੍ਰੁʼਤਾ ਤਸ੍ਮਾਦ੍ ਗੁਰੁੰ ਪੁਨਃ ਕੁਤਃ ਕ੍ਲਿਸ਼੍ਨਾਸਿ? ");
INSERT INTO sanpun_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","ਕਿਨ੍ਤੁ ਯੀਸ਼ੁਸ੍ਤਦ੍ ਵਾਕ੍ਯੰ ਸ਼੍ਰੁਤ੍ਵੈਵ ਭਜਨਗ੍ਰੁʼਹਾਧਿਪੰ ਗਦਿਤਵਾਨ੍ ਮਾ ਭੈਸ਼਼ੀਃ ਕੇਵਲੰ ਵਿਸ਼੍ਵਾਸਿਹਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","ਅਥ ਪਿਤਰੋ ਯਾਕੂਬ੍ ਤਦ੍ਭ੍ਰਾਤਾ ਯੋਹਨ੍ ਚ ਏਤਾਨ੍ ਵਿਨਾ ਕਮਪਿ ਸ੍ਵਪਸ਼੍ਚਾਦ੍ ਯਾਤੁੰ ਨਾਨ੍ਵਮਨ੍ਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ਤਸ੍ਯ ਭਜਨਗ੍ਰੁʼਹਾਧਿਪਸ੍ਯ ਨਿਵੇਸ਼ਨਸਮੀਪਮ੍ ਆਗਤ੍ਯ ਕਲਹੰ ਬਹੁਰੋਦਨੰ ਵਿਲਾਪਞ੍ਚ ਕੁਰ੍ੱਵਤੋ ਲੋਕਾਨ੍ ਦਦਰ੍ਸ਼| ");
INSERT INTO sanpun_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ਤਸ੍ਮਾਨ੍ ਨਿਵੇਸ਼ਨੰ ਪ੍ਰਵਿਸ਼੍ਯ ਪ੍ਰੋਕ੍ਤਵਾਨ੍ ਯੂਯੰ ਕੁਤ ਇੱਥੰ ਕਲਹੰ ਰੋਦਨਞ੍ਚ ਕੁਰੁਥ? ਕਨ੍ਯਾ ਨ ਮ੍ਰੁʼਤਾ ਨਿਦ੍ਰਾਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","ਤਸ੍ਮਾੱਤੇ ਤਮੁਪਜਹਸੁਃ ਕਿਨ੍ਤੁ ਯੀਸ਼ੁਃ ਸਰ੍ੱਵਾਨ ਬਹਿਸ਼਼੍ਕ੍ਰੁʼਤ੍ਯ ਕਨ੍ਯਾਯਾਃ ਪਿਤਰੌ ਸ੍ਵਸਙ੍ਗਿਨਸ਼੍ਚ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਯਤ੍ਰ ਕਨ੍ਯਾਸੀਤ੍ ਤਤ੍ ਸ੍ਥਾਨੰ ਪ੍ਰਵਿਸ਼਼੍ਟਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","ਅਥ ਸ ਤਸ੍ਯਾਃ ਕਨ੍ਯਾਯਾ ਹਸ੍ਤੌ ਧ੍ਰੁʼਤ੍ਵਾ ਤਾਂ ਬਭਾਸ਼਼ੇ ਟਾਲੀਥਾ ਕੂਮੀ, ਅਰ੍ਥਤੋ ਹੇ ਕਨ੍ਯੇ ਤ੍ਵਮੁੱਤਿਸ਼਼੍ਠ ਇਤ੍ਯਾਜ੍ਞਾਪਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ਤੁਨੈਵ ਤਤ੍ਕ੍ਸ਼਼ਣੰ ਸਾ ਦ੍ਵਾਦਸ਼ਵਰ੍ਸ਼਼ਵਯਸ੍ਕਾ ਕਨ੍ਯਾ ਪੋੱਥਾਯ ਚਲਿਤੁਮਾਰੇਭੇ, ਇਤਃ ਸਰ੍ੱਵੇ ਮਹਾਵਿਸ੍ਮਯੰ ਗਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","ਤਤ ਏਤਸ੍ਯੈ ਕਿਞ੍ਚਿਤ੍ ਖਾਦ੍ਯੰ ਦੱਤੇਤਿ ਕਥਯਿਤ੍ਵਾ ਏਤਤ੍ਕਰ੍ੰਮ ਕਮਪਿ ਨ ਜ੍ਞਾਪਯਤੇਤਿ ਦ੍ਰੁʼਢਮਾਦਿਸ਼਼੍ਟਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","ਅਨਨ੍ਤਰੰ ਸ ਤਤ੍ਸ੍ਥਾਨਾਤ੍ ਪ੍ਰਸ੍ਥਾਯ ਸ੍ਵਪ੍ਰਦੇਸ਼ਮਾਗਤਃ ਸ਼ਿਸ਼਼੍ਯਾਸ਼੍ਚ ਤਤ੍ਪਸ਼੍ਚਾਦ੍ ਗਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ਅਥ ਵਿਸ਼੍ਰਾਮਵਾਰੇ ਸਤਿ ਸ ਭਜਨਗ੍ਰੁʼਹੇ ਉਪਦੇਸ਼਼੍ਟੁਮਾਰਬ੍ਧਵਾਨ੍ ਤਤੋ(ਅ)ਨੇਕੇ ਲੋਕਾਸ੍ਤਤ੍ਕਥਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਵਿਸ੍ਮਿਤ੍ਯ ਜਗਦੁਃ, ਅਸ੍ਯ ਮਨੁਜਸ੍ਯ ਈਦ੍ਰੁʼਸ਼ੀ ਆਸ਼੍ਚਰ੍ੱਯਕ੍ਰਿਯਾ ਕਸ੍ਮਾਜ੍ ਜਾਤਾ? ਤਥਾ ਸ੍ਵਕਰਾਭ੍ਯਾਮ੍ ਇੱਥਮਦ੍ਭੁਤੰ ਕਰ੍ੰਮ ਕਰ੍ੱਤਾुਮ੍ ਏਤਸ੍ਮੈ ਕਥੰ ਜ੍ਞਾਨੰ ਦੱਤਮ੍? ");
INSERT INTO sanpun_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","ਕਿਮਯੰ ਮਰਿਯਮਃ ਪੁਤ੍ਰਸ੍ਤਜ੍ਞਾ ਨੋ? ਕਿਮਯੰ ਯਾਕੂਬ੍-ਯੋਸਿ-ਯਿਹੁਦਾ-ਸ਼ਿਮੋਨਾਂ ਭ੍ਰਾਤਾ ਨੋ? ਅਸ੍ਯ ਭਗਿਨ੍ਯਃ ਕਿਮਿਹਾਸ੍ਮਾਭਿਃ ਸਹ ਨੋ? ਇੱਥੰ ਤੇ ਤਦਰ੍ਥੇ ਪ੍ਰਤ੍ਯੂਹੰ ਗਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ਤਦਾ ਯੀਸ਼ੁਸ੍ਤੇਭ੍ਯੋ(ਅ)ਕਥਯਤ੍ ਸ੍ਵਦੇਸ਼ੰ ਸ੍ਵਕੁਟੁਮ੍ਬਾਨ੍ ਸ੍ਵਪਰਿਜਨਾਂਸ਼੍ਚ ਵਿਨਾ ਕੁਤ੍ਰਾਪਿ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦੀ ਅਸਤ੍ਕ੍ਰੁʼਤੋ ਨ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ਅਪਰਞ੍ਚ ਤੇਸ਼਼ਾਮਪ੍ਰਤ੍ਯਯਾਤ੍ ਸ ਵਿਸ੍ਮਿਤਃ ਕਿਯਤਾਂ ਰੋਗਿਣਾਂ ਵਪੁਃਸ਼਼ੁ ਹਸ੍ਤਮ੍ ਅਰ੍ਪਯਿਤ੍ਵਾ ਕੇਵਲੰ ਤੇਸ਼਼ਾਮਾਰੋਗ੍ਯਕਰਣਾਦ੍ ਅਨ੍ਯਤ੍ ਕਿਮਪਿ ਚਿਤ੍ਰਕਾਰ੍ੱਯੰ ਕਰ੍ੱਤਾਂ ਨ ਸ਼ਕ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ਅਥ ਸ ਚਤੁਰ੍ਦਿਕ੍ਸ੍ਥ ਗ੍ਰਾਮਾਨ੍ ਭ੍ਰਮਿਤ੍ਵਾ ਉਪਦਿਸ਼਼੍ਟਵਾਨ੍ ");
INSERT INTO sanpun_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ਦ੍ਵਾਦਸ਼ਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਆਹੂਯ ਅਮੇਧ੍ਯਭੂਤਾਨ੍ ਵਸ਼ੀਕਰ੍ੱਤਾਂ ਸ਼ਕ੍ਤਿੰ ਦੱਤ੍ਵਾ ਤੇਸ਼਼ਾਂ ਦ੍ਵੌ ਦ੍ਵੌ ਜਨੋ ਪ੍ਰੇਸ਼਼ਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ਪੁਨਰਿਤ੍ਯਾਦਿਸ਼ਦ੍ ਯੂਯਮ੍ ਏਕੈਕਾਂ ਯਸ਼਼੍ਟਿੰ ਵਿਨਾ ਵਸ੍ਤ੍ਰਸੰਪੁਟਃ ਪੂਪਃ ਕਟਿਬਨ੍ਧੇ ਤਾਮ੍ਰਖਣ੍ਡਞ੍ਚ ਏਸ਼਼ਾਂ ਕਿਮਪਿ ਮਾ ਗ੍ਰਹ੍ਲੀਤ, ");
INSERT INTO sanpun_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ਮਾਰ੍ਗਯਾਤ੍ਰਾਯੈ ਪਾਦੇਸ਼਼ੂਪਾਨਹੌ ਦੱਤ੍ਵਾ ਦ੍ਵੇ ਉੱਤਰੀਯੇ ਮਾ ਪਰਿਧਦ੍ੱਵੰ| ");
INSERT INTO sanpun_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","ਅਪਰਮਪ੍ਯੁਕ੍ਤੰ ਤੇਨ ਯੂਯੰ ਯਸ੍ਯਾਂ ਪੁਰ੍ੱਯਾਂ ਯਸ੍ਯ ਨਿਵੇਸ਼ਨੰ ਪ੍ਰਵੇਕ੍ਸ਼਼੍ਯਥ ਤਾਂ ਪੁਰੀਂ ਯਾਵੰਨ ਤ੍ਯਕ੍ਸ਼਼੍ਯਥ ਤਾਵਤ੍ ਤੰਨਿਵੇਸ਼ਨੇ ਸ੍ਥਾਸ੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","ਤਤ੍ਰ ਯਦਿ ਕੇਪਿ ਯੁਸ਼਼੍ਮਾਕਮਾਤਿਥ੍ਯੰ ਨ ਵਿਦਧਤਿ ਯੁਸ਼਼੍ਮਾਕੰ ਕਥਾਸ਼੍ਚ ਨ ਸ਼੍ਰੁʼਣ੍ਵਨ੍ਤਿ ਤਰ੍ਹਿ ਤਤ੍ਸ੍ਥਾਨਾਤ੍ ਪ੍ਰਸ੍ਥਾਨਸਮਯੇ ਤੇਸ਼਼ਾਂ ਵਿਰੁੱਧੰ ਸਾਕ੍ਸ਼਼੍ਯੰ ਦਾਤੁੰ ਸ੍ਵਪਾਦਾਨਾਸ੍ਫਾਲ੍ਯ ਰਜਃ ਸਮ੍ਪਾਤਯਤ; ਅਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਯਥਾਰ੍ਥੰ ਵਚ੍ਮਿ ਵਿਚਾਰਦਿਨੇ ਤੰਨਗਰਸ੍ਯਾਵਸ੍ਥਾਤਃ ਸਿਦੋਮਾਮੋਰਯੋ ਰ੍ਨਗਰਯੋਰਵਸ੍ਥਾ ਸਹ੍ਯਤਰਾ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","ਅਥ ਤੇ ਗਤ੍ਵਾ ਲੋਕਾਨਾਂ ਮਨਃਪਰਾਵਰ੍ੱਤਨੀਃ ਕਥਾ ਪ੍ਰਚਾਰਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ਏਵਮਨੇਕਾਨ੍ ਭੂਤਾਂਸ਼੍ਚ ਤ੍ਯਾਜਿਤਵਨ੍ਤਸ੍ਤਥਾ ਤੈਲੇਨ ਮਰ੍ੱਦਯਿਤ੍ਵਾ ਬਹੂਨ੍ ਜਨਾਨਰੋਗਾਨਕਾਰ੍ਸ਼਼ੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ਇੱਥੰ ਤਸ੍ਯ ਸੁਖ੍ਯਾਤਿਸ਼੍ਚਤੁਰ੍ਦਿਸ਼ੋ ਵ੍ਯਾਪ੍ਤਾ ਤਦਾ ਹੇਰੋਦ੍ ਰਾਜਾ ਤੰਨਿਸ਼ਮ੍ਯ ਕਥਿਤਵਾਨ੍, ਯੋਹਨ੍ ਮੱਜਕਃ ਸ਼੍ਮਸ਼ਾਨਾਦ੍ ਉੱਥਿਤ ਅਤੋਹੇਤੋਸ੍ਤੇਨ ਸਰ੍ੱਵਾ ਏਤਾ ਅਦ੍ਭੁਤਕ੍ਰਿਯਾਃ ਪ੍ਰਕਾਸ਼ਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","ਅਨ੍ਯੇ(ਅ)ਕਥਯਨ੍ ਅਯਮ੍ ਏਲਿਯਃ, ਕੇਪਿ ਕਥਿਤਵਨ੍ਤ ਏਸ਼਼ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦੀ ਯਦ੍ਵਾ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਾਂ ਸਦ੍ਰੁʼਸ਼ ਏਕੋਯਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","ਕਿਨ੍ਤੁ ਹੇਰੋਦ੍ ਇਤ੍ਯਾਕਰ੍ਣ੍ਯ ਭਾਸ਼਼ਿਤਵਾਨ੍ ਯਸ੍ਯਾਹੰ ਸ਼ਿਰਸ਼੍ਛਿੰਨਵਾਨ੍ ਸ ਏਵ ਯੋਹਨਯੰ ਸ ਸ਼੍ਮਸ਼ਾਨਾਦੁਦਤਿਸ਼਼੍ਠਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","ਪੂਰ੍ੱਵੰ ਸ੍ਵਭ੍ਰਾਤੁਃ ਫਿਲਿਪਸ੍ਯ ਪਤ੍ਨ੍ਯਾ ਉਦ੍ਵਾਹੰ ਕ੍ਰੁʼਤਵਨ੍ਤੰ ਹੇਰੋਦੰ ਯੋਹਨਵਾਦੀਤ੍ ਸ੍ਵਭਾਤ੍ਰੁʼਵਧੂ ਰ੍ਨ ਵਿਵਾਹ੍ਯਾ| ");
INSERT INTO sanpun_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ਅਤਃ ਕਾਰਣਾਤ੍ ਹੇਰੋਦ੍ ਲੋਕੰ ਪ੍ਰਹਿਤ੍ਯ ਯੋਹਨੰ ਧ੍ਰੁʼਤ੍ਵਾ ਬਨ੍ਧਨਾਲਯੇ ਬੱਧਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ਹੇਰੋਦਿਯਾ ਤਸ੍ਮੈ ਯੋਹਨੇ ਪ੍ਰਕੁਪ੍ਯ ਤੰ ਹਨ੍ਤੁਮ੍ ਐੱਛਤ੍ ਕਿਨ੍ਤੁ ਨ ਸ਼ਕ੍ਤਾ, ");
INSERT INTO sanpun_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ਯਸ੍ਮਾਦ੍ ਹੇਰੋਦ੍ ਤੰ ਧਾਰ੍ੰਮਿਕੰ ਸਤ੍ਪੁਰੁਸ਼਼ਞ੍ਚ ਜ੍ਞਾਤ੍ਵਾ ਸੰਮਨ੍ਯ ਰਕ੍ਸ਼਼ਿਤਵਾਨ੍; ਤਤ੍ਕਥਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਤਦਨੁਸਾਰੇਣ ਬਹੂਨਿ ਕਰ੍ੰਮਾਣਿ ਕ੍ਰੁʼਤਵਾਨ੍ ਹ੍ਰੁʼਸ਼਼੍ਟਮਨਾਸ੍ਤਦੁਪਦੇਸ਼ੰ ਸ਼੍ਰੁਤਵਾਂਸ਼੍ਚ| ");
INSERT INTO sanpun_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","ਕਿਨ੍ਤੁ ਹੇਰੋਦ੍ ਯਦਾ ਸ੍ਵਜਨ੍ਮਦਿਨੇ ਪ੍ਰਧਾਨਲੋਕੇਭ੍ਯਃ ਸੇਨਾਨੀਭ੍ਯਸ਼੍ਚ ਗਾਲੀਲ੍ਪ੍ਰਦੇਸ਼ੀਯਸ਼੍ਰੇਸ਼਼੍ਠਲੋਕੇਭ੍ਯਸ਼੍ਚ ਰਾਤ੍ਰੌ ਭੋਜ੍ਯਮੇਕੰ ਕ੍ਰੁʼਤਵਾਨ੍ ");
INSERT INTO sanpun_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ਤਸ੍ਮਿਨ੍ ਸ਼ੁਭਦਿਨੇ ਹੇਰੋਦਿਯਾਯਾਃ ਕਨ੍ਯਾ ਸਮੇਤ੍ਯ ਤੇਸ਼਼ਾਂ ਸਮਕ੍ਸ਼਼ੰ ਸੰਨ੍ਰੁʼਤ੍ਯ ਹੇਰੋਦਸ੍ਤੇਨ ਸਹੋਪਵਿਸ਼਼੍ਟਾਨਾਞ੍ਚ ਤੋਸ਼਼ਮਜੀਜਨਤ੍ ਤਤਾ ਨ੍ਰੁʼਪਃ ਕਨ੍ਯਾਮਾਹ ਸ੍ਮ ਮੱਤੋ ਯਦ੍ ਯਾਚਸੇ ਤਦੇਵ ਤੁਭ੍ਯੰ ਦਾਸ੍ਯੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ਸ਼ਪਥੰ ਕ੍ਰੁʼਤ੍ਵਾਕਥਯਤ੍ ਚੇਦ੍ ਰਾਜ੍ਯਾਰ੍ੱਧਮਪਿ ਯਾਚਸੇ ਤਦਪਿ ਤੁਭ੍ਯੰ ਦਾਸ੍ਯੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ਤਤਃ ਸਾ ਬਹਿ ਰ੍ਗਤ੍ਵਾ ਸ੍ਵਮਾਤਰੰ ਪਪ੍ਰੱਛ ਕਿਮਹੰ ਯਾਚਿਸ਼਼੍ਯੇ? ਤਦਾ ਸਾਕਥਯਤ੍ ਯੋਹਨੋ ਮੱਜਕਸ੍ਯ ਸ਼ਿਰਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","ਅਥ ਤੂਰ੍ਣੰ ਭੂਪਸਮੀਪਮ੍ ਏਤ੍ਯ ਯਾਚਮਾਨਾਵਦਤ੍ ਕ੍ਸ਼਼ਣੇਸ੍ਮਿਨ੍ ਯੋਹਨੋ ਮੱਜਕਸ੍ਯ ਸ਼ਿਰਃ ਪਾਤ੍ਰੇ ਨਿਧਾਯ ਦੇਹਿ, ਏਤਦ੍ ਯਾਚੇ(ਅ)ਹੰ| ");
INSERT INTO sanpun_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ਤਸ੍ਮਾਤ੍ ਭੂਪੋ(ਅ)ਤਿਦੁਃਖਿਤਃ, ਤਥਾਪਿ ਸ੍ਵਸ਼ਪਥਸ੍ਯ ਸਹਭੋਜਿਨਾਞ੍ਚਾਨੁਰੋਧਾਤ੍ ਤਦਨਙ੍ਗੀਕਰ੍ੱਤੁੰ ਨ ਸ਼ਕ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ਤਤ੍ਕ੍ਸ਼਼ਣੰ ਰਾਜਾ ਘਾਤਕੰ ਪ੍ਰੇਸ਼਼੍ਯ ਤਸ੍ਯ ਸ਼ਿਰ ਆਨੇਤੁਮਾਦਿਸ਼਼੍ਟਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ਤਤਃ ਸ ਕਾਰਾਗਾਰੰ ਗਤ੍ਵਾ ਤੱਛਿਰਸ਼੍ਛਿਤ੍ਵਾ ਪਾਤ੍ਰੇ ਨਿਧਾਯਾਨੀਯ ਤਸ੍ਯੈ ਕਨ੍ਯਾਯੈ ਦੱਤਵਾਨ੍ ਕਨ੍ਯਾ ਚ ਸ੍ਵਮਾਤ੍ਰੇ ਦਦੌ| ");
INSERT INTO sanpun_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ਅਨਨਤਰੰ ਯੋਹਨਃ ਸ਼ਿਸ਼਼੍ਯਾਸ੍ਤਦ੍ਵਾਰ੍ੱਤਾਂ ਪ੍ਰਾਪ੍ਯਾਗਤ੍ਯ ਤਸ੍ਯ ਕੁਣਪੰ ਸ਼੍ਮਸ਼ਾਨੇ(ਅ)ਸ੍ਥਾਪਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","ਅਥ ਪ੍ਰੇਸ਼਼ਿਤਾ ਯੀਸ਼ੋਃ ਸੰਨਿਧੌ ਮਿਲਿਤਾ ਯਦ੍ ਯਚ੍ ਚਕ੍ਰੁਃ ਸ਼ਿਕ੍ਸ਼਼ਯਾਮਾਸੁਸ਼੍ਚ ਤਤ੍ਸਰ੍ੱਵਵਾਰ੍ੱਤਾਸ੍ਤਸ੍ਮੈ ਕਥਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ਸ ਤਾਨੁਵਾਚ ਯੂਯੰ ਵਿਜਨਸ੍ਥਾਨੰ ਗਤ੍ਵਾ ਵਿਸ਼੍ਰਾਮ੍ਯਤ ਯਤਸ੍ਤਤ੍ਸੰਨਿਧੌ ਬਹੁਲੋਕਾਨਾਂ ਸਮਾਗਮਾਤ੍ ਤੇ ਭੋਕ੍ਤੁੰ ਨਾਵਕਾਸ਼ੰ ਪ੍ਰਾਪ੍ਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ਤਤਸ੍ਤੇ ਨਾਵਾ ਵਿਜਨਸ੍ਥਾਨੰ ਗੁਪ੍ਤੰ ਗਗ੍ਮੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ਤਤੋ ਲੋਕਨਿਵਹਸ੍ਤੇਸ਼਼ਾਂ ਸ੍ਥਾਨਾਨ੍ਤਰਯਾਨੰ ਦਦਰ੍ਸ਼, ਅਨੇਕੇ ਤੰ ਪਰਿਚਿਤ੍ਯ ਨਾਨਾਪੁਰੇਭ੍ਯਃ ਪਦੈਰ੍ਵ੍ਰਜਿਤ੍ਵਾ ਜਵੇਨ ਤੈਸ਼਼ਾਮਗ੍ਰੇ ਯੀਸ਼ੋਃ ਸਮੀਪ ਉਪਤਸ੍ਥੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","ਤਦਾ ਯੀਸ਼ੁ ਰ੍ਨਾਵੋ ਬਹਿਰ੍ਗਤ੍ਯ ਲੋਕਾਰਣ੍ਯਾਨੀਂ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਤੇਸ਼਼ੁ ਕਰੁਣਾਂ ਕ੍ਰੁʼਤਵਾਨ੍ ਯਤਸ੍ਤੇ(ਅ)ਰਕ੍ਸ਼਼ਕਮੇਸ਼਼ਾ ਇਵਾਸਨ੍ ਤਦਾ ਸ ਤਾਨ ਨਾਨਾਪ੍ਰਸਙ੍ਗਾਨ੍ ਉਪਦਿਸ਼਼੍ਟਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ਅਥ ਦਿਵਾਨ੍ਤੇ ਸਤਿ ਸ਼ਿਸ਼਼੍ਯਾ ਏਤ੍ਯ ਯੀਸ਼ੁਮੂਚਿਰੇ, ਇਦੰ ਵਿਜਨਸ੍ਥਾਨੰ ਦਿਨਞ੍ਚਾਵਸੰਨੰ| ");
INSERT INTO sanpun_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ਲੋਕਾਨਾਂ ਕਿਮਪਿ ਖਾਦ੍ਯੰ ਨਾਸ੍ਤਿ, ਅਤਸ਼੍ਚਤੁਰ੍ਦਿਕ੍ਸ਼਼ੁ ਗ੍ਰਾਮਾਨ੍ ਗਨ੍ਤੁੰ ਭੋਜ੍ਯਦ੍ਰਵ੍ਯਾਣਿ ਕ੍ਰੇਤੁਞ੍ਚ ਭਵਾਨ੍ ਤਾਨ੍ ਵਿਸ੍ਰੁʼਜਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ਤਦਾ ਸ ਤਾਨੁਵਾਚ ਯੂਯਮੇਵ ਤਾਨ੍ ਭੋਜਯਤ; ਤਤਸ੍ਤੇ ਜਗਦੁ ਰ੍ਵਯੰ ਗਤ੍ਵਾ ਦ੍ਵਿਸ਼ਤਸੰਖ੍ਯਕੈ ਰ੍ਮੁਦ੍ਰਾਪਾਦੈਃ ਪੂਪਾਨ੍ ਕ੍ਰੀਤ੍ਵਾ ਕਿੰ ਤਾਨ੍ ਭੋਜਯਿਸ਼਼੍ਯਾਮਃ? ");
INSERT INTO sanpun_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ਤਦਾ ਸ ਤਾਨ੍ ਪ੍ਰੁʼਸ਼਼੍ਠਵਾਨ੍ ਯੁਸ਼਼੍ਮਾਕੰ ਸੰਨਿਧੌ ਕਤਿ ਪੂਪਾ ਆਸਤੇ? ਗਤ੍ਵਾ ਪਸ਼੍ਯਤ; ਤਤਸ੍ਤੇ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਤਮਵਦਨ੍ ਪਞ੍ਚ ਪੂਪਾ ਦ੍ਵੌ ਮਤ੍ਸ੍ਯੌ ਚ ਸਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","ਤਦਾ ਸ ਲੋਕਾਨ੍ ਸ਼ਸ੍ਪੋਪਰਿ ਪੰਕ੍ਤਿਭਿਰੁਪਵੇਸ਼ਯਿਤੁਮ੍ ਆਦਿਸ਼਼੍ਟਵਾਨ੍, ");
INSERT INTO sanpun_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ਤਤਸ੍ਤੇ ਸ਼ਤੰ ਸ਼ਤੰ ਜਨਾਃ ਪਞ੍ਚਾਸ਼ਤ੍ ਪਞ੍ਚਾਸ਼ੱਜਨਾਸ਼੍ਚ ਪੰਕ੍ਤਿਭਿ ਰ੍ਭੁਵਿ ਸਮੁਪਵਿਵਿਸ਼ੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","ਅਥ ਸ ਤਾਨ੍ ਪਞ੍ਚਪੂਪਾਨ੍ ਮਤ੍ਸ੍ਯਦ੍ਵਯਞ੍ਚ ਧ੍ਰੁʼਤ੍ਵਾ ਸ੍ਵਰ੍ਗੰ ਪਸ਼੍ਯਨ੍ ਈਸ਼੍ਵਰਗੁਣਾਨ੍ ਅਨ੍ਵਕੀਰ੍ੱਤਯਤ੍ ਤਾਨ੍ ਪੂਪਾਨ੍ ਭੰਕ੍ਤ੍ਵਾ ਲੋਕੇਭ੍ਯਃ ਪਰਿਵੇਸ਼਼ਯਿਤੁੰ ਸ਼ਿਸ਼਼੍ਯੇਭ੍ਯੋ ਦੱਤਵਾਨ੍ ਦ੍ਵਾ ਮਤ੍ਸ੍ਯੌ ਚ ਵਿਭਜ੍ਯ ਸਰ੍ੱਵੇਭ੍ਯੋ ਦੱਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ਤਤਃ ਸਰ੍ੱਵੇ ਭੁਕ੍ਤ੍ਵਾਤ੍ਰੁʼਪ੍ਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ਅਨਨ੍ਤਰੰ ਸ਼ਿਸ਼਼੍ਯਾ ਅਵਸ਼ਿਸ਼਼੍ਟੈਃ ਪੂਪੈ ਰ੍ਮਤ੍ਸ੍ਯੈਸ਼੍ਚ ਪੂਰ੍ਣਾਨ੍ ਦ੍ਵਦਸ਼ ਡੱਲਕਾਨ੍ ਜਗ੍ਰੁʼਹੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","ਤੇ ਭੋਕ੍ਤਾਰਃ ਪ੍ਰਾਯਃ ਪਞ੍ਚ ਸਹਸ੍ਰਾਣਿ ਪੁਰੁਸ਼਼ਾ ਆਸਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ਅਥ ਸ ਲੋਕਾਨ੍ ਵਿਸ੍ਰੁʼਜੰਨੇਵ ਨਾਵਮਾਰੋਢੁੰ ਸ੍ਵਸ੍ਮਾਦਗ੍ਰੇ ਪਾਰੇ ਬੈਤ੍ਸੈਦਾਪੁਰੰ ਯਾਤੁਞ੍ਚ ਸ਼੍ਸ਼਼੍ਯਿाਨ੍ ਵਾਢਮਾਦਿਸ਼਼੍ਟਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ਤਦਾ ਸ ਸਰ੍ੱਵਾਨ੍ ਵਿਸ੍ਰੁʼਜ੍ਯ ਪ੍ਰਾਰ੍ਥਯਿਤੁੰ ਪਰ੍ੱਵਤੰ ਗਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ਤਤਃ ਸਨ੍ਧ੍ਯਾਯਾਂ ਸਤ੍ਯਾਂ ਨੌਃ ਸਿਨ੍ਧੁਮਧ੍ਯ ਉਪਸ੍ਥਿਤਾ ਕਿਨ੍ਤੁ ਸ ਏਕਾਕੀ ਸ੍ਥਲੇ ਸ੍ਥਿਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ਅਥ ਸੰਮੁਖਵਾਤਵਹਨਾਤ੍ ਸ਼ਿਸ਼਼੍ਯਾ ਨਾਵੰ ਵਾਹਯਿਤ੍ਵਾ ਪਰਿਸ਼੍ਰਾਨ੍ਤਾ ਇਤਿ ਜ੍ਞਾਤ੍ਵਾ ਸ ਨਿਸ਼ਾਚਤੁਰ੍ਥਯਾਮੇ ਸਿਨ੍ਧੂਪਰਿ ਪਦ੍ਭ੍ਯਾਂ ਵ੍ਰਜਨ੍ ਤੇਸ਼਼ਾਂ ਸਮੀਪਮੇਤ੍ਯ ਤੇਸ਼਼ਾਮਗ੍ਰੇ ਯਾਤੁਮ੍ ਉਦ੍ਯਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ਕਿਨ੍ਤੁ ਸ਼ਿਸ਼਼੍ਯਾਃ ਸਿਨ੍ਧੂਪਰਿ ਤੰ ਵ੍ਰਜਨ੍ਤੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਭੂਤਮਨੁਮਾਯ ਰੁਰੁਵੁਃ, ");
INSERT INTO sanpun_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ਯਤਃ ਸਰ੍ੱਵੇ ਤੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਵ੍ਯਾਕੁਲਿਤਾਃ| ਅਤਏਵ ਯੀਸ਼ੁਸ੍ਤਤ੍ਕ੍ਸ਼਼ਣੰ ਤੈਃ ਸਹਾਲਪ੍ਯ ਕਥਿਤਵਾਨ੍, ਸੁਸ੍ਥਿਰਾ ਭੂਤ, ਅਯਮਹੰ ਮਾ ਭੈਸ਼਼੍ਟ| ");
INSERT INTO sanpun_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ਅਥ ਨੌਕਾਮਾਰੁਹ੍ਯ ਤਸ੍ਮਿਨ੍ ਤੇਸ਼਼ਾਂ ਸੰਨਿਧਿੰ ਗਤੇ ਵਾਤੋ ਨਿਵ੍ਰੁʼੱਤਃ; ਤਸ੍ਮਾੱਤੇ ਮਨਃਸੁ ਵਿਸ੍ਮਿਤਾ ਆਸ਼੍ਚਰ੍ੱਯੰ ਮੇਨਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ਯਤਸ੍ਤੇ ਮਨਸਾਂ ਕਾਠਿਨ੍ਯਾਤ੍ ਤਤ੍ ਪੂਪੀਯਮ੍ ਆਸ਼੍ਚਰ੍ੱਯੰ ਕਰ੍ੰਮ ਨ ਵਿਵਿਕ੍ਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ਅਥ ਤੇ ਪਾਰੰ ਗਤ੍ਵਾ ਗਿਨੇਸ਼਼ਰਤ੍ਪ੍ਰਦੇਸ਼ਮੇਤ੍ਯ ਤਟ ਉਪਸ੍ਥਿਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ਤੇਸ਼਼ੁ ਨੌਕਾਤੋ ਬਹਿਰ੍ਗਤੇਸ਼਼ੁ ਤਤ੍ਪ੍ਰਦੇਸ਼ੀਯਾ ਲੋਕਾਸ੍ਤੰ ਪਰਿਚਿਤ੍ਯ ");
INSERT INTO sanpun_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ਚਤੁਰ੍ਦਿਕ੍ਸ਼਼ੁ ਧਾਵਨ੍ਤੋ ਯਤ੍ਰ ਯਤ੍ਰ ਰੋਗਿਣੋ ਨਰਾ ਆਸਨ੍ ਤਾਨ੍ ਸਰ੍ੱਵਾਨ ਖਟ੍ਵੋਪਰਿ ਨਿਧਾਯ ਯਤ੍ਰ ਕੁਤ੍ਰਚਿਤ੍ ਤਦ੍ਵਾਰ੍ੱਤਾਂ ਪ੍ਰਾਪੁਃ ਤਤ੍ ਸ੍ਥਾਨਮ੍ ਆਨੇਤੁਮ੍ ਆਰੇਭਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","ਤਥਾ ਯਤ੍ਰ ਯਤ੍ਰ ਗ੍ਰਾਮੇ ਯਤ੍ਰ ਯਤ੍ਰ ਪੁਰੇ ਯਤ੍ਰ ਯਤ੍ਰ ਪੱਲ੍ਯਾਞ੍ਚ ਤੇਨ ਪ੍ਰਵੇਸ਼ਃ ਕ੍ਰੁʼਤਸ੍ਤਦ੍ਵਰ੍ਤ੍ਮਮਧ੍ਯੇ ਲੋਕਾਃ ਪੀਡਿਤਾਨ੍ ਸ੍ਥਾਪਯਿਤ੍ਵਾ ਤਸ੍ਯ ਚੇਲਗ੍ਰਨ੍ਥਿਮਾਤ੍ਰੰ ਸ੍ਪ੍ਰਸ਼਼੍ਟੁਮ੍ ਤੇਸ਼਼ਾਮਰ੍ਥੇ ਤਦਨੁਜ੍ਞਾਂ ਪ੍ਰਾਰ੍ਥਯਨ੍ਤਃ ਯਾਵਨ੍ਤੋ ਲੋਕਾਃ ਪਸ੍ਪ੍ਰੁʼਸ਼ੁਸ੍ਤਾਵਨ੍ਤ ਏਵ ਗਦਾਨ੍ਮੁਕ੍ਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","ਅਨਨ੍ਤਰੰ ਯਿਰੂਸ਼ਾਲਮ ਆਗਤਾਃ ਫਿਰੂਸ਼ਿਨੋ(ਅ)ਧ੍ਯਾਪਕਾਸ਼੍ਚ ਯੀਸ਼ੋਃ ਸਮੀਪਮ੍ ਆਗਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ਤੇ ਤਸ੍ਯ ਕਿਯਤਃ ਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਅਸ਼ੁਚਿਕਰੈਰਰ੍ਥਾਦ ਅਪ੍ਰਕ੍ਸ਼਼ਾਲਿਤਹਸ੍ਤੈ ਰ੍ਭੁਞ੍ਜਤੋ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਤਾਨਦੂਸ਼਼ਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ਯਤਃ ਫਿਰੂਸ਼ਿਨਃ ਸਰ੍ੱਵਯਿਹੂਦੀਯਾਸ਼੍ਚ ਪ੍ਰਾਚਾਂ ਪਰਮ੍ਪਰਾਗਤਵਾਕ੍ਯੰ ਸੰਮਨ੍ਯ ਪ੍ਰਤਲੇਨ ਹਸ੍ਤਾਨ੍ ਅਪ੍ਰਕ੍ਸ਼਼ਾਲ੍ਯ ਨ ਭੁਞ੍ਜਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ਆਪਨਾਦਾਗਤ੍ਯ ਮੱਜਨੰ ਵਿਨਾ ਨ ਖਾਦਨ੍ਤਿ; ਤਥਾ ਪਾਨਪਾਤ੍ਰਾਣਾਂ ਜਲਪਾਤ੍ਰਾਣਾਂ ਪਿੱਤਲਪਾਤ੍ਰਾਣਾਮ੍ ਆਸਨਾਨਾਞ੍ਚ ਜਲੇ ਮੱਜਨਮ੍ ਇਤ੍ਯਾਦਯੋਨ੍ਯੇਪਿ ਬਹਵਸ੍ਤੇਸ਼਼ਾਮਾਚਾਰਾਃ ਸਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ਤੇ ਫਿਰੂਸ਼ਿਨੋ(ਅ)ਧ੍ਯਾਪਕਾਸ਼੍ਚ ਯੀਸ਼ੁੰ ਪਪ੍ਰੱਛੁਃ, ਤਵ ਸ਼ਿਸ਼਼੍ਯਾਃ ਪ੍ਰਾਚਾਂ ਪਰਮ੍ਪਰਾਗਤਵਾਕ੍ਯਾਨੁਸਾਰੇਣ ਨਾਚਰਨ੍ਤੋ(ਅ)ਪ੍ਰਕ੍ਸ਼਼ਾਲਿਤਕਰੈਃ ਕੁਤੋ ਭੁਜੰਤੇ? ");
INSERT INTO sanpun_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ਤਤਃ ਸ ਪ੍ਰਤ੍ਯੁਵਾਚ ਕਪਟਿਨੋ ਯੁਸ਼਼੍ਮਾਨ੍ ਉੱਦਿਸ਼੍ਯ ਯਿਸ਼ਯਿਯਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦੀ ਯੁਕ੍ਤਮਵਾਦੀਤ੍| ਯਥਾ ਸ੍ਵਕੀਯੈਰਧਰੈਰੇਤੇ ਸੰਮਨ੍ਯਨਤੇ ਸਦੈਵ ਮਾਂ| ਕਿਨ੍ਤੁ ਮੱਤੋ ਵਿਪ੍ਰਕਰ੍ਸ਼਼ੇ ਸਨ੍ਤਿ ਤੇਸ਼਼ਾਂ ਮਨਾਂਸਿ ਚ| ");
INSERT INTO sanpun_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ਸ਼ਿਕ੍ਸ਼਼ਯਨ੍ਤੋ ਬਿਧੀਨ੍ ੰਨਾਜ੍ਞਾ ਭਜਨ੍ਤੇ ਮਾਂ ਮੁਧੈਵ ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","ਯੂਯੰ ਜਲਪਾਤ੍ਰਪਾਨਪਾਤ੍ਰਾਦੀਨਿ ਮੱਜਯਨ੍ਤੋ ਮਨੁਜਪਰਮ੍ਪਰਾਗਤਵਾਕ੍ਯੰ ਰਕ੍ਸ਼਼ਥ ਕਿਨ੍ਤੁ ਈਸ਼੍ਵਰਾਜ੍ਞਾਂ ਲੰਘਧ੍ਵੇ; ਅਪਰਾ ਈਦ੍ਰੁʼਸ਼੍ਯੋਨੇਕਾਃ ਕ੍ਰਿਯਾ ਅਪਿ ਕੁਰੁਧ੍ਵੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","ਅਨ੍ਯਞ੍ਚਾਕਥਯਤ੍ ਯੂਯੰ ਸ੍ਵਪਰਮ੍ਪਰਾਗਤਵਾਕ੍ਯਸ੍ਯ ਰਕ੍ਸ਼਼ਾਰ੍ਥੰ ਸ੍ਪਸ਼਼੍ਟਰੂਪੇਣ ਈਸ਼੍ਵਰਾਜ੍ਞਾਂ ਲੋਪਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","ਯਤੋ ਮੂਸਾਦ੍ਵਾਰਾ ਪ੍ਰੋਕ੍ਤਮਸ੍ਤਿ ਸ੍ਵਪਿਤਰੌ ਸੰਮਨ੍ਯਧ੍ਵੰ ਯਸ੍ਤੁ ਮਾਤਰੰ ਪਿਤਰੰ ਵਾ ਦੁਰ੍ੱਵਾਕ੍ਯੰ ਵਕ੍ਤਿ ਸ ਨਿਤਾਨ੍ਤੰ ਹਨ੍ਯਤਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","ਕਿਨ੍ਤੁ ਮਦੀਯੇਨ ਯੇਨ ਦ੍ਰਵ੍ਯੇਣ ਤਵੋਪਕਾਰੋਭਵਤ੍ ਤਤ੍ ਕਰ੍ੱਬਾਣਮਰ੍ਥਾਦ੍ ਈਸ਼੍ਵਰਾਯ ਨਿਵੇਦਿਤਮ੍ ਇਦੰ ਵਾਕ੍ਯੰ ਯਦਿ ਕੋਪਿ ਪਿਤਰੰ ਮਾਤਰੰ ਵਾ ਵਕ੍ਤਿ ");
INSERT INTO sanpun_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ਤਰ੍ਹਿ ਯੂਯੰ ਮਾਤੁਃ ਪਿਤੁ ਰ੍ਵੋਪਕਾਰੰ ਕਰ੍ੱਤਾਂ ਤੰ ਵਾਰਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ਇੱਥੰ ਸ੍ਵਪ੍ਰਚਾਰਿਤਪਰਮ੍ਪਰਾਗਤਵਾਕ੍ਯੇਨ ਯੂਯਮ੍ ਈਸ਼੍ਵਰਾਜ੍ਞਾਂ ਮੁਧਾ ਵਿਧਦ੍ੱਵੇ, ਈਦ੍ਰੁʼਸ਼ਾਨ੍ਯਨ੍ਯਾਨ੍ਯਨੇਕਾਨਿ ਕਰ੍ੰਮਾਣਿ ਕੁਰੁਧ੍ਵੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","ਅਥ ਸ ਲੋਕਾਨਾਹੂਯ ਬਭਾਸ਼਼ੇ ਯੂਯੰ ਸਰ੍ੱਵੇ ਮਦ੍ਵਾਕ੍ਯੰ ਸ਼੍ਰੁʼਣੁਤ ਬੁਧ੍ਯਧ੍ਵਞ੍ਚ| ");
INSERT INTO sanpun_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ਬਾਹ੍ਯਾਦਨ੍ਤਰੰ ਪ੍ਰਵਿਸ਼੍ਯ ਨਰਮਮੇਧ੍ਯੰ ਕਰ੍ੱਤਾਂ ਸ਼ਕ੍ਨੋਤਿ ਈਦ੍ਰੁʼਸ਼ੰ ਕਿਮਪਿ ਵਸ੍ਤੁ ਨਾਸ੍ਤਿ, ਵਰਮ੍ ਅਨ੍ਤਰਾਦ੍ ਬਹਿਰ੍ਗਤੰ ਯਦ੍ਵਸ੍ਤੁ ਤਨ੍ਮਨੁਜਮ੍ ਅਮੇਧ੍ਯੰ ਕਰੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","ਯਸ੍ਯ ਸ਼੍ਰੋਤੁੰ ਸ਼੍ਰੋਤ੍ਰੇ ਸ੍ਤਃ ਸ ਸ਼੍ਰੁʼਣੋਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ਤਤਃ ਸ ਲੋਕਾਨ੍ ਹਿਤ੍ਵਾ ਗ੍ਰੁʼਹਮਧ੍ਯੰ ਪ੍ਰਵਿਸ਼਼੍ਟਸ੍ਤਦਾ ਸ਼ਿਸ਼਼੍ਯਾਸ੍ਤਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤਵਾਕ੍ਯਾਰ੍ਥੰ ਪਪ੍ਰੱਛੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","ਤਸ੍ਮਾਤ੍ ਸ ਤਾਨ੍ ਜਗਾਦ ਯੂਯਮਪਿ ਕਿਮੇਤਾਦ੍ਰੁʼਗਬੋਧਾਃ? ਕਿਮਪਿ ਦ੍ਰਵ੍ਯੰ ਬਾਹ੍ਯਾਦਨ੍ਤਰੰ ਪ੍ਰਵਿਸ਼੍ਯ ਨਰਮਮੇਧ੍ਯੰ ਕਰ੍ੱਤਾਂ ਨ ਸ਼ਕ੍ਨੋਤਿ ਕਥਾਮਿਮਾਂ ਕਿੰ ਨ ਬੁਧ੍ਯਧ੍ਵੇ? ");
INSERT INTO sanpun_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ਤਤ੍ ਤਦਨ੍ਤਰ੍ਨ ਪ੍ਰਵਿਸ਼ਤਿ ਕਿਨ੍ਤੁ ਕੁਕ੍ਸ਼਼ਿਮਧ੍ਯੰ ਪ੍ਰਵਿਸ਼ਤਿ ਸ਼ੇਸ਼਼ੇ ਸਰ੍ੱਵਭੁਕ੍ਤਵਸ੍ਤੁਗ੍ਰਾਹਿਣਿ ਬਹਿਰ੍ਦੇਸ਼ੇ ਨਿਰ੍ਯਾਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ਅਪਰਮਪ੍ਯਵਾਦੀਦ੍ ਯੰਨਰਾੰਨਿਰੇਤਿ ਤਦੇਵ ਨਰਮਮੇਧ੍ਯੰ ਕਰੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ਯਤੋ(ਅ)ਨ੍ਤਰਾਦ੍ ਅਰ੍ਥਾਨ੍ ਮਾਨਵਾਨਾਂ ਮਨੋਭ੍ਯਃ ਕੁਚਿਨ੍ਤਾ ਪਰਸ੍ਤ੍ਰੀਵੇਸ਼੍ਯਾਗਮਨੰ ");
INSERT INTO sanpun_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ਨਰਵਧਸ਼੍ਚੌਰ੍ੱਯੰ ਲੋਭੋ ਦੁਸ਼਼੍ਟਤਾ ਪ੍ਰਵਞ੍ਚਨਾ ਕਾਮੁਕਤਾ ਕੁਦ੍ਰੁʼਸ਼਼੍ਟਿਰੀਸ਼੍ਵਰਨਿਨ੍ਦਾ ਗਰ੍ੱਵਸ੍ਤਮ ਇਤ੍ਯਾਦੀਨਿ ਨਿਰ੍ਗੱਛਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ਏਤਾਨਿ ਸਰ੍ੱਵਾਣਿ ਦੁਰਿਤਾਨ੍ਯਨ੍ਤਰਾਦੇਤ੍ਯ ਨਰਮਮੇਧ੍ਯੰ ਕੁਰ੍ੱਵਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","ਅਥ ਸ ਉੱਥਾਯ ਤਤ੍ਸ੍ਥਾਨਾਤ੍ ਸੋਰਸੀਦੋਨ੍ਪੁਰਪ੍ਰਦੇਸ਼ੰ ਜਗਾਮ ਤਤ੍ਰ ਕਿਮਪਿ ਨਿਵੇਸ਼ਨੰ ਪ੍ਰਵਿਸ਼੍ਯ ਸਰ੍ੱਵੈਰਜ੍ਞਾਤਃ ਸ੍ਥਾਤੁੰ ਮਤਿਞ੍ਚਕ੍ਰੇ ਕਿਨ੍ਤੁ ਗੁਪ੍ਤਃ ਸ੍ਥਾਤੁੰ ਨ ਸ਼ਸ਼ਾਕ| ");
INSERT INTO sanpun_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ਯਤਃ ਸੁਰਫੈਨਿਕੀਦੇਸ਼ੀਯਯੂਨਾਨੀਵੰਸ਼ੋਦ੍ਭਵਸ੍ਤ੍ਰਿਯਾਃ ਕਨ੍ਯਾ ਭੂਤਗ੍ਰਸ੍ਤਾਸੀਤ੍| ਸਾ ਸ੍ਤ੍ਰੀ ਤਦ੍ਵਾਰ੍ੱਤਾਂ ਪ੍ਰਾਪ੍ਯ ਤਤ੍ਸਮੀਪਮਾਗਤ੍ਯ ਤੱਚਰਣਯੋਃ ਪਤਿਤ੍ਵਾ ");
INSERT INTO sanpun_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ਸ੍ਵਕਨ੍ਯਾਤੋ ਭੂਤੰ ਨਿਰਾਕਰ੍ੱਤਾਂ ਤਸ੍ਮਿਨ੍ ਵਿਨਯੰ ਕ੍ਰੁʼਤਵਤੀ| ");
INSERT INTO sanpun_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ਕਿਨ੍ਤੁ ਯੀਸ਼ੁਸ੍ਤਾਮਵਦਤ੍ ਪ੍ਰਥਮੰ ਬਾਲਕਾਸ੍ਤ੍ਰੁʼਪ੍ਯਨ੍ਤੁ ਯਤੋ ਬਾਲਕਾਨਾਂ ਖਾਦ੍ਯੰ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਕੁੱਕੁਰੇਭ੍ਯੋ ਨਿਕ੍ਸ਼਼ੇਪੋ(ਅ)ਨੁਚਿਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","ਤਦਾ ਸਾ ਸ੍ਤ੍ਰੀ ਤਮਵਾਦੀਤ੍ ਭੋਃ ਪ੍ਰਭੋ ਤਤ੍ ਸਤ੍ਯੰ ਤਥਾਪਿ ਮਞ੍ਚਾਧਃਸ੍ਥਾਃ ਕੁੱਕੁਰਾ ਬਾਲਾਨਾਂ ਕਰਪਤਿਤਾਨਿ ਖਾਦ੍ਯਖਣ੍ਡਾਨਿ ਖਾਦਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ਤਤਃ ਸੋ(ਅ)ਕਥਯਦ੍ ਏਤਤ੍ਕਥਾਹੇਤੋਃ ਸਕੁਸ਼ਲਾ ਯਾਹਿ ਤਵ ਕਨ੍ਯਾਂ ਤ੍ਯਕ੍ਤ੍ਵਾ ਭੂਤੋ ਗਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ਅਥ ਸਾ ਸ੍ਤ੍ਰੀ ਗ੍ਰੁʼਹੰ ਗਤ੍ਵਾ ਕਨ੍ਯਾਂ ਭੂਤਤ੍ਯਕ੍ਤਾਂ ਸ਼ੱਯਾਸ੍ਥਿਤਾਂ ਦਦਰ੍ਸ਼| ");
INSERT INTO sanpun_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","ਪੁਨਸ਼੍ਚ ਸ ਸੋਰਸੀਦੋਨ੍ਪੁਰਪ੍ਰਦੇਸ਼ਾਤ੍ ਪ੍ਰਸ੍ਥਾਯ ਦਿਕਾਪਲਿਦੇਸ਼ਸ੍ਯ ਪ੍ਰਾਨ੍ਤਰਭਾਗੇਨ ਗਾਲੀਲ੍ਜਲਧੇਃ ਸਮੀਪੰ ਗਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ਤਦਾ ਲੋਕੈਰੇਕੰ ਬਧਿਰੰ ਕਦ੍ਵਦਞ੍ਚ ਨਰੰ ਤੰਨਿਕਟਮਾਨੀਯ ਤਸ੍ਯ ਗਾਤ੍ਰੇ ਹਸ੍ਤਮਰ੍ਪਯਿਤੁੰ ਵਿਨਯਃ ਕ੍ਰੁʼਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ਤਤੋ ਯੀਸ਼ੁ ਰ੍ਲੋਕਾਰਣ੍ਯਾਤ੍ ਤੰ ਨਿਰ੍ਜਨਮਾਨੀਯ ਤਸ੍ਯ ਕਰ੍ਣਯੋਙ੍ਗੁਲੀ ਰ੍ਦਦੌ ਨਿਸ਼਼੍ਠੀਵੰ ਦੱਤ੍ਵਾ ਚ ਤੱਜਿਹ੍ਵਾਂ ਪਸ੍ਪਰ੍ਸ਼| ");
INSERT INTO sanpun_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ਅਨਨ੍ਤਰੰ ਸ੍ਵਰ੍ਗੰ ਨਿਰੀਕ੍ਸ਼਼੍ਯ ਦੀਰ੍ਘੰ ਨਿਸ਼੍ਵਸ੍ਯ ਤਮਵਦਤ੍ ਇਤਫਤਃ ਅਰ੍ਥਾਨ੍ ਮੁਕ੍ਤੋ ਭੂਯਾਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ਤਤਸ੍ਤਤ੍ਕ੍ਸ਼਼ਣੰ ਤਸ੍ਯ ਕਰ੍ਣੌ ਮੁਕ੍ਤੌ ਜਿਹ੍ਵਾਯਾਸ਼੍ਚ ਜਾਡ੍ਯਾਪਗਮਾਤ੍ ਸ ਸੁਸ੍ਪਸ਼਼੍ਟਵਾਕ੍ਯਮਕਥਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","ਅਥ ਸ ਤਾਨ੍ ਵਾਢਮਿਤ੍ਯਾਦਿਦੇਸ਼ ਯੂਯਮਿਮਾਂ ਕਥਾਂ ਕਸ੍ਮੈਚਿਦਪਿ ਮਾ ਕਥਯਤ, ਕਿਨ੍ਤੁ ਸ ਯਤਿ ਨ੍ਯਸ਼਼ੇਧਤ੍ ਤੇ ਤਤਿ ਬਾਹੁਲ੍ਯੇਨ ਪ੍ਰਾਚਾਰਯਨ੍; ");
INSERT INTO sanpun_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ਤੇ(ਅ)ਤਿਚਮਤ੍ਕ੍ਰੁʼਤ੍ਯ ਪਰਸ੍ਪਰੰ ਕਥਯਾਮਾਸੁਃ ਸ ਬਧਿਰਾਯ ਸ਼੍ਰਵਣਸ਼ਕ੍ਤਿੰ ਮੂਕਾਯ ਚ ਕਥਨਸ਼ਕ੍ਤਿੰ ਦੱਤ੍ਵਾ ਸਰ੍ੱਵੰ ਕਰ੍ੰਮੋੱਤਮਰੂਪੇਣ ਚਕਾਰ| ");
INSERT INTO sanpun_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ਤਦਾ ਤਤ੍ਸਮੀਪੰ ਬਹਵੋ ਲੋਕਾ ਆਯਾਤਾ ਅਤਸ੍ਤੇਸ਼਼ਾਂ ਭੋਜ੍ਯਦ੍ਰਵ੍ਯਾਭਾਵਾਦ੍ ਯੀਸ਼ੁਃ ਸ਼ਿਸ਼਼੍ਯਾਨਾਹੂਯ ਜਗਾਦ,| ");
INSERT INTO sanpun_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","ਲੋਕਨਿਵਹੇ ਮਮ ਕ੍ਰੁʼਪਾ ਜਾਯਤੇ ਤੇ ਦਿਨਤ੍ਰਯੰ ਮਯਾ ਸਾਰ੍ੱਧੰ ਸਨ੍ਤਿ ਤੇਸ਼਼ਾਂ ਭੋਜ੍ਯੰ ਕਿਮਪਿ ਨਾਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ਤੇਸ਼਼ਾਂ ਮਧ੍ਯੇ(ਅ)ਨੇਕੇ ਦੂਰਾਦ੍ ਆਗਤਾਃ, ਅਭੁਕ੍ਤੇਸ਼਼ੁ ਤੇਸ਼਼ੁ ਮਯਾ ਸ੍ਵਗ੍ਰੁʼਹਮਭਿਪ੍ਰਹਿਤੇਸ਼਼ੁ ਤੇ ਪਥਿ ਕ੍ਲਮਿਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ਸ਼ਿਸ਼਼੍ਯਾ ਅਵਾਦਿਸ਼਼ੁਃ, ਏਤਾਵਤੋ ਲੋਕਾਨ੍ ਤਰ੍ਪਯਿਤੁਮ੍ ਅਤ੍ਰ ਪ੍ਰਨ੍ਤਰੇ ਪੂਪਾਨ੍ ਪ੍ਰਾਪ੍ਤੁੰ ਕੇਨ ਸ਼ਕ੍ਯਤੇ? ");
INSERT INTO sanpun_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ਤਤਃ ਸ ਤਾਨ੍ ਪਪ੍ਰੱਛ ਯੁਸ਼਼੍ਮਾਕੰ ਕਤਿ ਪੂਪਾਃ ਸਨ੍ਤਿ? ਤੇ(ਅ)ਕਥਯਨ੍ ਸਪ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","ਤਤਃ ਸ ਤਾੱਲੋਕਾਨ੍ ਭੁਵਿ ਸਮੁਪਵੇਸ਼਼੍ਟੁਮ੍ ਆਦਿਸ਼੍ਯ ਤਾਨ੍ ਸਪ੍ਤ ਪੂਪਾਨ੍ ਧ੍ਰੁʼਤ੍ਵਾ ਈਸ਼੍ਵਰਗੁਣਾਨ੍ ਅਨੁਕੀਰ੍ੱਤਯਾਮਾਸ, ਭੰਕ੍ਤ੍ਵਾ ਪਰਿਵੇਸ਼਼ਯਿਤੁੰ ਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਪ੍ਰਤਿ ਦਦੌ, ਤਤਸ੍ਤੇ ਲੋਕੇਭ੍ਯਃ ਪਰਿਵੇਸ਼਼ਯਾਮਾਸੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ਤਥਾ ਤੇਸ਼਼ਾਂ ਸਮੀਪੇ ਯੇ ਕ੍ਸ਼਼ੁਦ੍ਰਮਤ੍ਸ੍ਯਾ ਆਸਨ੍ ਤਾਨਪ੍ਯਾਦਾਯ ਈਸ਼੍ਵਰਗੁਣਾਨ੍ ਸੰਕੀਰ੍ਤ੍ਯ ਪਰਿਵੇਸ਼਼ਯਿਤੁਮ੍ ਆਦਿਸ਼਼੍ਟਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ਤਤੋ ਲੋਕਾ ਭੁਕ੍ਤ੍ਵਾ ਤ੍ਰੁʼਪ੍ਤਿੰ ਗਤਾ ਅਵਸ਼ਿਸ਼਼੍ਟਖਾਦ੍ਯੈਃ ਪੂਰ੍ਣਾਃ ਸਪ੍ਤਡੱਲਕਾ ਗ੍ਰੁʼਹੀਤਾਸ਼੍ਚ| ");
INSERT INTO sanpun_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ਏਤੇ ਭੋਕ੍ਤਾਰਃ ਪ੍ਰਾਯਸ਼੍ਚਤੁਃ ਸਹਸ੍ਰਪੁਰੁਸ਼਼ਾ ਆਸਨ੍ ਤਤਃ ਸ ਤਾਨ੍ ਵਿਸਸਰ੍ਜ| ");
INSERT INTO sanpun_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ਅਥ ਸ ਸ਼ਿਸ਼਼੍ਯਃ ਸਹ ਨਾਵਮਾਰੁਹ੍ਯ ਦਲ੍ਮਾਨੂਥਾਸੀਮਾਮਾਗਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ਤਤਃ ਪਰੰ ਫਿਰੂਸ਼ਿਨ ਆਗਤ੍ਯ ਤੇਨ ਸਹ ਵਿਵਦਮਾਨਾਸ੍ਤਸ੍ਯ ਪਰੀਕ੍ਸ਼਼ਾਰ੍ਥਮ੍ ਆਕਾਸ਼ੀਯਚਿਹ੍ਨੰ ਦ੍ਰਸ਼਼੍ਟੁੰ ਯਾਚਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","ਤਦਾ ਸੋ(ਅ)ਨ੍ਤਰ੍ਦੀਰ੍ਘੰ ਨਿਸ਼੍ਵਸ੍ਯਾਕਥਯਤ੍, ਏਤੇ ਵਿਦ੍ਯਮਾਨਨਰਾਃ ਕੁਤਸ਼੍ਚਿਨ੍ਹੰ ਮ੍ਰੁʼਗਯਨ੍ਤੇ? ਯੁਸ਼਼੍ਮਾਨਹੰ ਯਥਾਰ੍ਥੰ ਬ੍ਰਵੀਮਿ ਲੋਕਾਨੇਤਾਨ੍ ਕਿਮਪਿ ਚਿਹ੍ਨੰ ਨ ਦਰ੍ਸ਼ਯਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ਅਥ ਤਾਨ੍ ਹਿਤ੍ਵਾ ਪੁਨ ਰ੍ਨਾਵਮ੍ ਆਰੁਹ੍ਯ ਪਾਰਮਗਾਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ਏਤਰ੍ਹਿ ਸ਼ਿਸ਼਼੍ਯੈਃ ਪੂਪੇਸ਼਼ੁ ਵਿਸ੍ਮ੍ਰੁʼਤੇਸ਼਼ੁ ਨਾਵਿ ਤੇਸ਼਼ਾਂ ਸੰਨਿਧੌ ਪੂਪ ਏਕਏਵ ਸ੍ਥਿਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ਤਦਾਨੀਂ ਯੀਸ਼ੁਸ੍ਤਾਨ੍ ਆਦਿਸ਼਼੍ਟਵਾਨ੍ ਫਿਰੂਸ਼ਿਨਾਂ ਹੇਰੋਦਸ਼੍ਚ ਕਿਣ੍ਵੰ ਪ੍ਰਤਿ ਸਤਰ੍ਕਾਃ ਸਾਵਧਾਨਾਸ਼੍ਚ ਭਵਤ| ");
INSERT INTO sanpun_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ਤਤਸ੍ਤੇ(ਅ)ਨ੍ਯੋਨ੍ਯੰ ਵਿਵੇਚਨੰ ਕਰ੍ਤੁਮ੍ ਆਰੇਭਿਰੇ, ਅਸ੍ਮਾਕੰ ਸੰਨਿਧੌ ਪੂਪੋ ਨਾਸ੍ਤੀਤਿ ਹੇਤੋਰਿਦੰ ਕਥਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ਤਦ੍ ਬੁਦ੍ੱਵਾ ਯੀਸ਼ੁਸ੍ਤੇਭ੍ਯੋ(ਅ)ਕਥਯਤ੍ ਯੁਸ਼਼੍ਮਾਕੰ ਸ੍ਥਾਨੇ ਪੂਪਾਭਾਵਾਤ੍ ਕੁਤ ਇੱਥੰ ਵਿਤਰ੍ਕਯਥ? ਯੂਯੰ ਕਿਮਦ੍ਯਾਪਿ ਕਿਮਪਿ ਨ ਜਾਨੀਥ? ਬੋੱਧੁਞ੍ਚ ਨ ਸ਼ਕ੍ਨੁਥ? ਯਾਵਦਦ੍ਯ ਕਿੰ ਯੁਸ਼਼੍ਮਾਕੰ ਮਨਾਂਸਿ ਕਠਿਨਾਨਿ ਸਨ੍ਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","ਸਤ੍ਸੁ ਨੇਤ੍ਰੇਸ਼਼ੁ ਕਿੰ ਨ ਪਸ਼੍ਯਥ? ਸਤ੍ਸੁ ਕਰ੍ਣੇਸ਼਼ੁ ਕਿੰ ਨ ਸ਼੍ਰੁʼਣੁਥ? ਨ ਸ੍ਮਰਥ ਚ? ");
INSERT INTO sanpun_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ਯਦਾਹੰ ਪਞ੍ਚਪੂਪਾਨ੍ ਪਞ੍ਚਸਹਸ੍ਰਾਣਾਂ ਪੁਰੁਸ਼਼ਾਣਾਂ ਮਧ੍ਯੇ ਭੰਕ੍ਤ੍ਵਾ ਦੱਤਵਾਨ੍ ਤਦਾਨੀਂ ਯੂਯਮ੍ ਅਵਸ਼ਿਸ਼਼੍ਟਪੂਪੈਃ ਪੂਰ੍ਣਾਨ੍ ਕਤਿ ਡੱਲਕਾਨ੍ ਗ੍ਰੁʼਹੀਤਵਨ੍ਤਃ? ਤੇ(ਅ)ਕਥਯਨ੍ ਦ੍ਵਾਦਸ਼ਡੱਲਕਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","ਅਪਰਞ੍ਚ ਯਦਾ ਚਤੁਃਸਹਸ੍ਰਾਣਾਂ ਪੁਰੁਸ਼਼ਾਣਾਂ ਮਧ੍ਯੇ ਪੂਪਾਨ੍ ਭੰਕ੍ਤ੍ਵਾਦਦਾਂ ਤਦਾ ਯੂਯਮ੍ ਅਤਿਰਿਕ੍ਤਪੂਪਾਨਾਂ ਕਤਿ ਡੱਲਕਾਨ੍ ਗ੍ਰੁʼਹੀਤਵਨ੍ਤਃ? ਤੇ ਕਥਯਾਮਾਸੁਃ ਸਪ੍ਤਡੱਲਕਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ਤਦਾ ਸ ਕਥਿਤਵਾਨ੍ ਤਰ੍ਹਿ ਯੂਯਮ੍ ਅਧੁਨਾਪਿ ਕੁਤੋ ਬੋਦ੍ੱਵੁੰ ਨ ਸ਼ਕ੍ਨੁਥ? ");
INSERT INTO sanpun_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","ਅਨਨ੍ਤਰੰ ਤਸ੍ਮਿਨ੍ ਬੈਤ੍ਸੈਦਾਨਗਰੇ ਪ੍ਰਾਪ੍ਤੇ ਲੋਕਾ ਅਨ੍ਧਮੇਕੰ ਨਰੰ ਤਤ੍ਸਮੀਪਮਾਨੀਯ ਤੰ ਸ੍ਪ੍ਰਸ਼਼੍ਟੁੰ ਤੰ ਪ੍ਰਾਰ੍ਥਯਾਞ੍ਚਕ੍ਰਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ਤਦਾ ਤਸ੍ਯਾਨ੍ਧਸ੍ਯ ਕਰੌ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਨਗਰਾਦ੍ ਬਹਿਰ੍ਦੇਸ਼ੰ ਤੰ ਨੀਤਵਾਨ੍; ਤੰਨੇਤ੍ਰੇ ਨਿਸ਼਼੍ਠੀਵੰ ਦੱਤ੍ਵਾ ਤਦ੍ਗਾਤ੍ਰੇ ਹਸ੍ਤਾਵਰ੍ਪਯਿਤ੍ਵਾ ਤੰ ਪਪ੍ਰੱਛ, ਕਿਮਪਿ ਪਸ਼੍ਯਸਿ? ");
INSERT INTO sanpun_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ਸ ਨੇਤ੍ਰੇ ਉਨ੍ਮੀਲ੍ਯ ਜਗਾਦ, ਵ੍ਰੁʼਕ੍ਸ਼਼ਵਤ੍ ਮਨੁਜਾਨ੍ ਗੱਛਤੋ ਨਿਰੀਕ੍ਸ਼਼ੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ਤਤੋ ਯੀਸ਼ੁਃ ਪੁਨਸ੍ਤਸ੍ਯ ਨਯਨਯੋ ਰ੍ਹਸ੍ਤਾਵਰ੍ਪਯਿਤ੍ਵਾ ਤਸ੍ਯ ਨੇਤ੍ਰੇ ਉਨ੍ਮੀਲਯਾਮਾਸ; ਤਸ੍ਮਾਤ੍ ਸ ਸ੍ਵਸ੍ਥੋ ਭੂਤ੍ਵਾ ਸ੍ਪਸ਼਼੍ਟਰੂਪੰ ਸਰ੍ੱਵਲੋਕਾਨ੍ ਦਦਰ੍ਸ਼| ");
INSERT INTO sanpun_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ਤਤਃ ਪਰੰ ਤ੍ਵੰ ਗ੍ਰਾਮੰ ਮਾ ਗੱਛ ਗ੍ਰਾਮਸ੍ਥੰ ਕਮਪਿ ਚ ਕਿਮਪ੍ਯਨੁਕ੍ਤ੍ਵਾ ਨਿਜਗ੍ਰੁʼਹੰ ਯਾਹੀਤ੍ਯਾਦਿਸ਼੍ਯ ਯੀਸ਼ੁਸ੍ਤੰ ਨਿਜਗ੍ਰੁʼਹੰ ਪ੍ਰਹਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","ਅਨਨ੍ਤਰੰ ਸ਼ਿਸ਼਼੍ਯੈਃ ਸਹਿਤੋ ਯੀਸ਼ੁਃ ਕੈਸਰੀਯਾਫਿਲਿਪਿਪੁਰੰ ਜਗਾਮ, ਪਥਿ ਗੱਛਨ੍ ਤਾਨਪ੍ਰੁʼੱਛਤ੍ ਕੋ(ਅ)ਹਮ੍ ਅਤ੍ਰ ਲੋਕਾਃ ਕਿੰ ਵਦਨ੍ਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","ਤੇ ਪ੍ਰਤ੍ਯੂਚੁਃ ਤ੍ਵਾਂ ਯੋਹਨੰ ਮੱਜਕੰ ਵਦਨ੍ਤਿ ਕਿਨ੍ਤੁ ਕੇਪਿ ਕੇਪਿ ਏਲਿਯੰ ਵਦਨ੍ਤਿ; ਅਪਰੇ ਕੇਪਿ ਕੇਪਿ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਾਮ੍ ਏਕੋ ਜਨ ਇਤਿ ਵਦਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","ਅਥ ਸ ਤਾਨਪ੍ਰੁʼੱਛਤ੍ ਕਿਨ੍ਤੁ ਕੋਹਮ੍? ਇਤ੍ਯਤ੍ਰ ਯੂਯੰ ਕਿੰ ਵਦਥ? ਤਦਾ ਪਿਤਰਃ ਪ੍ਰਤ੍ਯਵਦਤ੍ ਭਵਾਨ੍ ਅਭਿਸ਼਼ਿਕ੍ਤਸ੍ਤ੍ਰਾਤਾ| ");
INSERT INTO sanpun_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","ਤਤਃ ਸ ਤਾਨ੍ ਗਾਢਮਾਦਿਸ਼ਦ੍ ਯੂਯੰ ਮਮ ਕਥਾ ਕਸ੍ਮੈਚਿਦਪਿ ਮਾ ਕਥਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","ਮਨੁਸ਼਼੍ਯਪੁਤ੍ਰੇਣਾਵਸ਼੍ਯੰ ਬਹਵੋ ਯਾਤਨਾ ਭੋਕ੍ਤਵ੍ਯਾਃ ਪ੍ਰਾਚੀਨਲੋਕੈਃ ਪ੍ਰਧਾਨਯਾਜਕੈਰਧ੍ਯਾਪਕੈਸ਼੍ਚ ਸ ਨਿਨ੍ਦਿਤਃ ਸਨ੍ ਘਾਤਯਿਸ਼਼੍ਯਤੇ ਤ੍ਰੁʼਤੀਯਦਿਨੇ ਉੱਥਾਸ੍ਯਤਿ ਚ, ਯੀਸ਼ੁਃ ਸ਼ਿਸ਼਼੍ਯਾਨੁਪਦੇਸ਼਼੍ਟੁਮਾਰਭ੍ਯ ਕਥਾਮਿਮਾਂ ਸ੍ਪਸ਼਼੍ਟਮਾਚਸ਼਼੍ਟ| ");
INSERT INTO sanpun_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ਤਸ੍ਮਾਤ੍ ਪਿਤਰਸ੍ਤਸ੍ਯ ਹਸ੍ਤੌ ਧ੍ਰੁʼਤ੍ਵਾ ਤੰ ਤਰ੍ੱਜਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","ਕਿਨ੍ਤੁ ਸ ਮੁਖੰ ਪਰਾਵਰ੍ਤ੍ਯ ਸ਼ਿਸ਼਼੍ਯਗਣੰ ਨਿਰੀਕ੍ਸ਼਼੍ਯ ਪਿਤਰੰ ਤਰ੍ਜਯਿਤ੍ਵਾਵਾਦੀਦ੍ ਦੂਰੀਭਵ ਵਿਘ੍ਨਕਾਰਿਨ੍ ਈਸ਼੍ਵਰੀਯਕਾਰ੍ੱਯਾਦਪਿ ਮਨੁਸ਼਼੍ਯਕਾਰ੍ੱਯੰ ਤੁਭ੍ਯੰ ਰੋਚਤਤਰਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ਅਥ ਸ ਲੋਕਾਨ੍ ਸ਼ਿਸ਼਼੍ਯਾਂਸ਼੍ਚਾਹੂਯ ਜਗਾਦ ਯਃ ਕਸ਼੍ਚਿਨ੍ ਮਾਮਨੁਗਨ੍ਤੁਮ੍ ਇੱਛਤਿ ਸ ਆਤ੍ਮਾਨੰ ਦਾਮ੍ਯਤੁ, ਸ੍ਵਕ੍ਰੁਸ਼ੰ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਮਤ੍ਪਸ਼੍ਚਾਦ੍ ਆਯਾਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ਯਤੋ ਯਃ ਕਸ਼੍ਚਿਤ੍ ਸ੍ਵਪ੍ਰਾਣੰ ਰਕ੍ਸ਼਼ਿਤੁਮਿੱਛਤਿ ਸ ਤੰ ਹਾਰਯਿਸ਼਼੍ਯਤਿ, ਕਿਨ੍ਤੁ ਯਃ ਕਸ਼੍ਚਿਨ੍ ਮਦਰ੍ਥੰ ਸੁਸੰਵਾਦਾਰ੍ਥਞ੍ਚ ਪ੍ਰਾਣੰ ਹਾਰਯਤਿ ਸ ਤੰ ਰਕ੍ਸ਼਼ਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","ਅਪਰਞ੍ਚ ਮਨੁਜਃ ਸਰ੍ੱਵੰ ਜਗਤ੍ ਪ੍ਰਾਪ੍ਯ ਯਦਿ ਸ੍ਵਪ੍ਰਾਣੰ ਹਾਰਯਤਿ ਤਰ੍ਹਿ ਤਸ੍ਯ ਕੋ ਲਾਭਃ? ");
INSERT INTO sanpun_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","ਨਰਃ ਸ੍ਵਪ੍ਰਾਣਵਿਨਿਮਯੇਨ ਕਿੰ ਦਾਤੁੰ ਸ਼ਕ੍ਨੋਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ਏਤੇਸ਼਼ਾਂ ਵ੍ਯਭਿਚਾਰਿਣਾਂ ਪਾਪਿਨਾਞ੍ਚ ਲੋਕਾਨਾਂ ਸਾਕ੍ਸ਼਼ਾਦ੍ ਯਦਿ ਕੋਪਿ ਮਾਂ ਮਤ੍ਕਥਾਞ੍ਚ ਲੱਜਾਸ੍ਪਦੰ ਜਾਨਾਤਿ ਤਰ੍ਹਿ ਮਨੁਜਪੁਤ੍ਰੋ ਯਦਾ ਧਰ੍ੰਮਦੂਤੈਃ ਸਹ ਪਿਤੁਃ ਪ੍ਰਭਾਵੇਣਾਗਮਿਸ਼਼੍ਯਤਿ ਤਦਾ ਸੋਪਿ ਤੰ ਲੱਜਾਸ੍ਪਦੰ ਜ੍ਞਾਸ੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","ਅਥ ਸ ਤਾਨਵਾਦੀਤ੍ ਯੁਸ਼਼੍ਮਭ੍ਯਮਹੰ ਯਥਾਰ੍ਥੰ ਕਥਯਾਮਿ, ਈਸ਼੍ਵਰਰਾਜ੍ਯੰ ਪਰਾਕ੍ਰਮੇਣੋਪਸ੍ਥਿਤੰ ਨ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਮ੍ਰੁʼਤ੍ਯੁੰ ਨਾਸ੍ਵਾਦਿਸ਼਼੍ਯਨ੍ਤੇ, ਅਤ੍ਰ ਦਣ੍ਡਾਯਮਾਨਾਨਾਂ ਮਧ੍ਯੇਪਿ ਤਾਦ੍ਰੁʼਸ਼ਾ ਲੋਕਾਃ ਸਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","ਅਥ ਸ਼਼ਡ੍ਦਿਨੇਭ੍ਯਃ ਪਰੰ ਯੀਸ਼ੁਃ ਪਿਤਰੰ ਯਾਕੂਬੰ ਯੋਹਨਞ੍ਚ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਗਿਰੇਰੁੱਚਸ੍ਯ ਨਿਰ੍ਜਨਸ੍ਥਾਨੰ ਗਤ੍ਵਾ ਤੇਸ਼਼ਾਂ ਪ੍ਰਤ੍ਯਕ੍ਸ਼਼ੇ ਮੂਰ੍ਤ੍ਯਨ੍ਤਰੰ ਦਧਾਰ| ");
INSERT INTO sanpun_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ਤਤਸ੍ਤਸ੍ਯ ਪਰਿਧੇਯਮ੍ ਈਦ੍ਰੁʼਸ਼ਮ੍ ਉੱਜ੍ਵਲਹਿਮਪਾਣਡਰੰ ਜਾਤੰ ਯਦ੍ ਜਗਤਿ ਕੋਪਿ ਰਜਕੋ ਨ ਤਾਦ੍ਰੁʼਕ੍ ਪਾਣਡਰੰ ਕਰ੍ੱਤਾਂ ਸ਼ਕ੍ਨੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","ਅਪਰਞ੍ਚ ਏਲਿਯੋ ਮੂਸਾਸ਼੍ਚ ਤੇਭ੍ਯੋ ਦਰ੍ਸ਼ਨੰ ਦੱਤ੍ਵਾ ਯੀਸ਼ੁਨਾ ਸਹ ਕਥਨੰ ਕਰ੍ੱਤੁਮਾਰੇਭਾਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ਤਦਾ ਪਿਤਰੋ ਯੀਸ਼ੁਮਵਾਦੀਤ੍ ਹੇ ਗੁਰੋ(ਅ)ਸ੍ਮਾਕਮਤ੍ਰ ਸ੍ਥਿਤਿਰੁੱਤਮਾ, ਤਤਏਵ ਵਯੰ ਤ੍ਵਤ੍ਕ੍ਰੁʼਤੇ ਏਕਾਂ ਮੂਸਾਕ੍ਰੁʼਤੇ ਏਕਾਮ੍ ਏਲਿਯਕ੍ਰੁʼਤੇ ਚੈਕਾਂ, ਏਤਾਸ੍ਤਿਸ੍ਰਃ ਕੁਟੀ ਰ੍ਨਿਰ੍ੰਮਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","ਕਿਨ੍ਤੁ ਸ ਯਦੁਕ੍ਤਵਾਨ੍ ਤਤ੍ ਸ੍ਵਯੰ ਨ ਬੁਬੁਧੇ ਤਤਃ ਸਰ੍ੱਵੇ ਬਿਭਯਾਞ੍ਚਕ੍ਰੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ਏਤਰ੍ਹਿ ਪਯੋਦਸ੍ਤਾਨ੍ ਛਾਦਯਾਮਾਸ, ਮਮਯਾਂ ਪ੍ਰਿਯਃ ਪੁਤ੍ਰਃ ਕਥਾਸੁ ਤਸ੍ਯ ਮਨਾਂਸਿ ਨਿਵੇਸ਼ਯਤੇਤਿ ਨਭੋਵਾਣੀ ਤਨ੍ਮੇਦ੍ਯਾੰਨਿਰ੍ਯਯੌ| ");
INSERT INTO sanpun_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","ਅਥ ਹਠਾੱਤੇ ਚਤੁਰ੍ਦਿਸ਼ੋ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਯੀਸ਼ੁੰ ਵਿਨਾ ਸ੍ਵੈਃ ਸਹਿਤੰ ਕਮਪਿ ਨ ਦਦ੍ਰੁʼਸ਼ੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ਤਤਃ ਪਰੰ ਗਿਰੇਰਵਰੋਹਣਕਾਲੇ ਸ ਤਾਨ੍ ਗਾਢਮ੍ ਦੂਤ੍ਯਾਦਿਦੇਸ਼ ਯਾਵੰਨਰਸੂਨੋਃ ਸ਼੍ਮਸ਼ਾਨਾਦੁੱਥਾਨੰ ਨ ਭਵਤਿ, ਤਾਵਤ੍ ਦਰ੍ਸ਼ਨਸ੍ਯਾਸ੍ਯ ਵਾਰ੍ੱਤਾ ਯੁਸ਼਼੍ਮਾਭਿਃ ਕਸ੍ਮੈਚਿਦਪਿ ਨ ਵਕ੍ਤਵ੍ਯਾ| ");
INSERT INTO sanpun_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ਤਦਾ ਸ਼੍ਮਸ਼ਾਨਾਦੁੱਥਾਨਸ੍ਯ ਕੋਭਿਪ੍ਰਾਯ ਇਤਿ ਵਿਚਾਰ੍ੱਯ ਤੇ ਤਦ੍ਵਾਕ੍ਯੰ ਸ੍ਵੇਸ਼਼ੁ ਗੋਪਾਯਾਞ੍ਚਕ੍ਰਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ਅਥ ਤੇ ਯੀਸ਼ੁੰ ਪਪ੍ਰੱਛੁਃ ਪ੍ਰਥਮਤ ਏਲਿਯੇਨਾਗਨ੍ਤਵ੍ਯਮ੍ ਇਤਿ ਵਾਕ੍ਯੰ ਕੁਤ ਉਪਾਧ੍ਯਾਯਾ ਆਹੁਃ? ");
INSERT INTO sanpun_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","ਤਦਾ ਸ ਪ੍ਰਤ੍ਯੁਵਾਚ , ਏਲਿਯਃ ਪ੍ਰਥਮਮੇਤ੍ਯ ਸਰ੍ੱਵਕਾਰ੍ੱਯਾਣਿ ਸਾਧਯਿਸ਼਼੍ਯਤਿ; ਨਰਪੁਤ੍ਰੇ ਚ ਲਿਪਿ ਰ੍ਯਥਾਸ੍ਤੇ ਤਥੈਵ ਸੋਪਿ ਬਹੁਦੁਃਖੰ ਪ੍ਰਾਪ੍ਯਾਵਜ੍ਞਾਸ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","ਕਿਨ੍ਤ੍ਵਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਵਦਾਮਿ , ਏਲਿਯਾਰ੍ਥੇ ਲਿਪਿ ਰ੍ਯਥਾਸ੍ਤੇ ਤਥੈਵ ਸ ਏਤ੍ਯ ਯਯੌ, ਲੋਕਾ: ਸ੍ਵੇੱਛਾਨੁਰੂਪੰ ਤਮਭਿਵ੍ਯਵਹਰਨ੍ਤਿ ਸ੍ਮ| ");
INSERT INTO sanpun_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","ਅਨਨ੍ਤਰੰ ਸ ਸ਼ਿਸ਼਼੍ਯਸਮੀਪਮੇਤ੍ਯ ਤੇਸ਼਼ਾਂ ਚਤੁਃਪਾਰ੍ਸ਼੍ਵੇ ਤੈਃ ਸਹ ਬਹੁਜਨਾਨ੍ ਵਿਵਦਮਾਨਾਨ੍ ਅਧ੍ਯਾਪਕਾਂਸ਼੍ਚ ਦ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍; ");
INSERT INTO sanpun_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ਕਿਨ੍ਤੁ ਸਰ੍ੱਵਲੋਕਾਸ੍ਤੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵੈਵ ਚਮਤ੍ਕ੍ਰੁʼਤ੍ਯ ਤਦਾਸੰਨੰ ਧਾਵਨ੍ਤਸ੍ਤੰ ਪ੍ਰਣੇਮੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ਤਦਾ ਯੀਸ਼ੁਰਧ੍ਯਾਪਕਾਨਪ੍ਰਾਕ੍ਸ਼਼ੀਦ੍ ਏਤੈਃ ਸਹ ਯੂਯੰ ਕਿੰ ਵਿਵਦਧ੍ਵੇ? ");
INSERT INTO sanpun_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ਤਤੋ ਲੋਕਾਨਾਂ ਕਸ਼੍ਚਿਦੇਕਃ ਪ੍ਰਤ੍ਯਵਾਦੀਤ੍ ਹੇ ਗੁਰੋ ਮਮ ਸੂਨੁੰ ਮੂਕੰ ਭੂਤਧ੍ਰੁʼਤਞ੍ਚ ਭਵਦਾਸੰਨਮ੍ ਆਨਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ਯਦਾਸੌ ਭੂਤਸ੍ਤਮਾਕ੍ਰਮਤੇ ਤਦੈਵ ਪਾਤਸਤਿ ਤਥਾ ਸ ਫੇਣਾਯਤੇ, ਦਨ੍ਤੈਰ੍ਦਨ੍ਤਾਨ੍ ਘਰ੍ਸ਼਼ਤਿ ਕ੍ਸ਼਼ੀਣੋ ਭਵਤਿ ਚ; ਤਤੋ ਹੇਤੋਸ੍ਤੰ ਭੂਤੰ ਤ੍ਯਾਜਯਿਤੁੰ ਭਵੱਛਿਸ਼਼੍ਯਾਨ੍ ਨਿਵੇਦਿਤਵਾਨ੍ ਕਿਨ੍ਤੁ ਤੇ ਨ ਸ਼ੇਕੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ਤਦਾ ਸ ਤਮਵਾਦੀਤ੍, ਰੇ ਅਵਿਸ਼੍ਵਾਸਿਨਃ ਸਨ੍ਤਾਨਾ ਯੁਸ਼਼੍ਮਾਭਿਃ ਸਹ ਕਤਿ ਕਾਲਾਨਹੰ ਸ੍ਥਾਸ੍ਯਾਮਿ? ਅਪਰਾਨ੍ ਕਤਿ ਕਾਲਾਨ੍ ਵਾ ਵ ਆਚਾਰਾਨ੍ ਸਹਿਸ਼਼੍ਯੇ? ਤੰ ਮਦਾਸੰਨਮਾਨਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ਤਤਸ੍ਤਤ੍ਸੰਨਿਧਿੰ ਸ ਆਨੀਯਤ ਕਿਨ੍ਤੁ ਤੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵੈਵ ਭੂਤੋ ਬਾਲਕੰ ਧ੍ਰੁʼਤਵਾਨ੍; ਸ ਚ ਭੂਮੌ ਪਤਿਤ੍ਵਾ ਫੇਣਾਯਮਾਨੋ ਲੁਲੋਠ| ");
INSERT INTO sanpun_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","ਤਦਾ ਸ ਤਤ੍ਪਿਤਰੰ ਪਪ੍ਰੱਛ, ਅਸ੍ਯੇਦ੍ਰੁʼਸ਼ੀ ਦਸ਼ਾ ਕਤਿ ਦਿਨਾਨਿ ਭੂਤਾ? ਤਤਃ ਸੋਵਾਦੀਤ੍ ਬਾਲ੍ਯਕਾਲਾਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","ਭੂਤੋਯੰ ਤੰ ਨਾਸ਼ਯਿਤੁੰ ਬਹੁਵਾਰਾਨ੍ ਵਹ੍ਨੌ ਜਲੇ ਚ ਨ੍ਯਕ੍ਸ਼਼ਿਪਤ੍ ਕਿਨ੍ਤੁ ਯਦਿ ਭਵਾਨ ਕਿਮਪਿ ਕਰ੍ੱਤਾਂ ਸ਼ਕ੍ਨੋਤਿ ਤਰ੍ਹਿ ਦਯਾਂ ਕ੍ਰੁʼਤ੍ਵਾਸ੍ਮਾਨ੍ ਉਪਕਰੋਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ਤਦਾ ਯੀਸ਼ੁਸ੍ਤਮਵਦਤ੍ ਯਦਿ ਪ੍ਰਤ੍ਯੇਤੁੰ ਸ਼ਕ੍ਨੋਸ਼਼ਿ ਤਰ੍ਹਿ ਪ੍ਰਤ੍ਯਯਿਨੇ ਜਨਾਯ ਸਰ੍ੱਵੰ ਸਾਧ੍ਯਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ਤਤਸ੍ਤਤ੍ਕ੍ਸ਼਼ਣੰ ਤਦ੍ਬਾਲਕਸ੍ਯ ਪਿਤਾ ਪ੍ਰੋੱਚੈ ਰੂਵਨ੍ ਸਾਸ਼੍ਰੁਨੇਤ੍ਰਃ ਪ੍ਰੋਵਾਚ, ਪ੍ਰਭੋ ਪ੍ਰਤ੍ਯੇਮਿ ਮਮਾਪ੍ਰਤ੍ਯਯੰ ਪ੍ਰਤਿਕੁਰੁ| ");
INSERT INTO sanpun_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","ਅਥ ਯੀਸ਼ੁ ਰ੍ਲੋਕਸਙ੍ਘੰ ਧਾਵਿਤ੍ਵਾਯਾਨ੍ਤੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਤਮਪੂਤਭੂਤੰ ਤਰ੍ਜਯਿਤ੍ਵਾ ਜਗਾਦ, ਰੇ ਬਧਿਰ ਮੂਕ ਭੂਤ ਤ੍ਵਮੇਤਸ੍ਮਾਦ੍ ਬਹਿਰ੍ਭਵ ਪੁਨਃ ਕਦਾਪਿ ਮਾਸ਼੍ਰਯੈਨੰ ਤ੍ਵਾਮਹਮ੍ ਇਤ੍ਯਾਦਿਸ਼ਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ਤਦਾ ਸ ਭੂਤਸ਼੍ਚੀਤ੍ਸ਼ਬ੍ਦੰ ਕ੍ਰੁʼਤ੍ਵਾ ਤਮਾਪੀਡ੍ਯ ਬਹਿਰ੍ਜਜਾਮ, ਤਤੋ ਬਾਲਕੋ ਮ੍ਰੁʼਤਕਲ੍ਪੋ ਬਭੂਵ ਤਸ੍ਮਾਦਯੰ ਮ੍ਰੁʼਤਇਤ੍ਯਨੇਕੇ ਕਥਯਾਮਾਸੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","ਕਿਨ੍ਤੁ ਕਰੰ ਧ੍ਰੁʼਤ੍ਵਾ ਯੀਸ਼ੁਨੋੱਥਾਪਿਤਃ ਸ ਉੱਤਸ੍ਥੌ| ");
INSERT INTO sanpun_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","ਅਥ ਯੀਸ਼ੌ ਗ੍ਰੁʼਹੰ ਪ੍ਰਵਿਸ਼਼੍ਟੇ ਸ਼ਿਸ਼਼੍ਯਾ ਗੁਪ੍ਤੰ ਤੰ ਪਪ੍ਰੱਛੁਃ, ਵਯਮੇਨੰ ਭੂਤੰ ਤ੍ਯਾਜਯਿਤੁੰ ਕੁਤੋ ਨ ਸ਼ਕ੍ਤਾਃ? ");
INSERT INTO sanpun_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ਸ ਉਵਾਚ, ਪ੍ਰਾਰ੍ਥਨੋਪਵਾਸੌ ਵਿਨਾ ਕੇਨਾਪ੍ਯਨ੍ਯੇਨ ਕਰ੍ੰਮਣਾ ਭੂਤਮੀਦ੍ਰੁʼਸ਼ੰ ਤ੍ਯਾਜਯਿਤੁੰ ਨ ਸ਼ਕ੍ਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","ਅਨਨ੍ਤਰੰ ਸ ਤਤ੍ਸ੍ਥਾਨਾਦਿਤ੍ਵਾ ਗਾਲੀਲ੍ਮਧ੍ਯੇਨ ਯਯੌ, ਕਿਨ੍ਤੁ ਤਤ੍ ਕੋਪਿ ਜਾਨੀਯਾਦਿਤਿ ਸ ਨੈੱਛਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ਅਪਰਞ੍ਚ ਸ ਸ਼ਿਸ਼਼੍ਯਾਨੁਪਦਿਸ਼ਨ੍ ਬਭਾਸ਼਼ੇ, ਨਰਪੁਤ੍ਰੋ ਨਰਹਸ੍ਤੇਸ਼਼ੁ ਸਮਰ੍ਪਯਿਸ਼਼੍ਯਤੇ ਤੇ ਚ ਤੰ ਹਨਿਸ਼਼੍ਯਨ੍ਤਿ ਤੈਸ੍ਤਸ੍ਮਿਨ੍ ਹਤੇ ਤ੍ਰੁʼਤੀਯਦਿਨੇ ਸ ਉੱਥਾਸ੍ਯਤੀਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","ਕਿਨ੍ਤੁ ਤਤ੍ਕਥਾਂ ਤੇ ਨਾਬੁਧ੍ਯਨ੍ਤ ਪ੍ਰਸ਼਼੍ਟੁਞ੍ਚ ਬਿਭ੍ਯਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","ਅਥ ਯੀਸ਼ੁਃ ਕਫਰ੍ਨਾਹੂਮ੍ਪੁਰਮਾਗਤ੍ਯ ਮਧ੍ਯੇਗ੍ਰੁʼਹਞ੍ਚੇਤ੍ਯ ਤਾਨਪ੍ਰੁʼੱਛਦ੍ ਵਰ੍ਤ੍ਮਮਧ੍ਯੇ ਯੂਯਮਨ੍ਯੋਨ੍ਯੰ ਕਿੰ ਵਿਵਦਧ੍ਵੇ ਸ੍ਮ? ");
INSERT INTO sanpun_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","ਕਿਨ੍ਤੁ ਤੇ ਨਿਰੁੱਤਰਾਸ੍ਤਸ੍ਥੁ ਰ੍ਯਸ੍ਮਾੱਤੇਸ਼਼ਾਂ ਕੋ ਮੁਖ੍ਯ ਇਤਿ ਵਰ੍ਤ੍ਮਾਨਿ ਤੇ(ਅ)ਨ੍ਯੋਨ੍ਯੰ ਵ੍ਯਵਦਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ਤਤਃ ਸ ਉਪਵਿਸ਼੍ਯ ਦ੍ਵਾਦਸ਼ਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਆਹੂਯ ਬਭਾਸ਼਼ੇ ਯਃ ਕਸ਼੍ਚਿਤ੍ ਮੁਖ੍ਯੋ ਭਵਿਤੁਮਿੱਛਤਿ ਸ ਸਰ੍ੱਵੇਭ੍ਯੋ ਗੌਣਃ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਸੇਵਕਸ਼੍ਚ ਭਵਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","ਤਦਾ ਸ ਬਾਲਕਮੇਕੰ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਮਧ੍ਯੇ ਸਮੁਪਾਵੇਸ਼ਯਤ੍ ਤਤਸ੍ਤੰ ਕ੍ਰੋਡੇ ਕ੍ਰੁʼਤ੍ਵਾ ਤਾਨਵਾਦਾਤ੍ ");
INSERT INTO sanpun_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","ਯਃ ਕਸ਼੍ਚਿਦੀਦ੍ਰੁʼਸ਼ਸ੍ਯ ਕਸ੍ਯਾਪਿ ਬਾਲਸ੍ਯਾਤਿਥ੍ਯੰ ਕਰੋਤਿ ਸ ਮਮਾਤਿਥ੍ਯੰ ਕਰੋਤਿ; ਯਃ ਕਸ਼੍ਚਿਨ੍ਮਮਾਤਿਥ੍ਯੰ ਕਰੋਤਿ ਸ ਕੇਵਲਮ੍ ਮਮਾਤਿਥ੍ਯੰ ਕਰੋਤਿ ਤੰਨ ਮਤ੍ਪ੍ਰੇਰਕਸ੍ਯਾਪ੍ਯਾਤਿਥ੍ਯੰ ਕਰੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ਅਥ ਯੋਹਨ੍ ਤਮਬ੍ਰਵੀਤ੍ ਹੇ ਗੁਰੋ, ਅਸ੍ਮਾਕਮਨਨੁਗਾਮਿਨਮ੍ ਏਕੰ ਤ੍ਵਾੰਨਾਮ੍ਨਾ ਭੂਤਾਨ੍ ਤ੍ਯਾਜਯਨ੍ਤੰ ਵਯੰ ਦ੍ਰੁʼਸ਼਼੍ਟਵਨ੍ਤਃ, ਅਸ੍ਮਾਕਮਪਸ਼੍ਚਾਦ੍ਗਾਮਿਤ੍ਵਾੱਚ ਤੰ ਨ੍ਯਸ਼਼ੇਧਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ਕਿਨ੍ਤੁ ਯੀਸ਼ੁਰਵਦਤ੍ ਤੰ ਮਾ ਨਿਸ਼਼ੇਧਤ੍, ਯਤੋ ਯਃ ਕਸ਼੍ਚਿਨ੍ ਮੰਨਾਮ੍ਨਾ ਚਿਤ੍ਰੰ ਕਰ੍ੰਮ ਕਰੋਤਿ ਸ ਸਹਸਾ ਮਾਂ ਨਿਨ੍ਦਿਤੁੰ ਨ ਸ਼ਕ੍ਨੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ਤਥਾ ਯਃ ਕਸ਼੍ਚਿਦ੍ ਯੁਸ਼਼੍ਮਾਕੰ ਵਿਪਕ੍ਸ਼਼ਤਾਂ ਨ ਕਰੋਤਿ ਸ ਯੁਸ਼਼੍ਮਾਕਮੇਵ ਸਪਕ੍ਸ਼਼ਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ਯਃ ਕਸ਼੍ਚਿਦ੍ ਯੁਸ਼਼੍ਮਾਨ੍ ਖ੍ਰੀਸ਼਼੍ਟਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਜ੍ਞਾਤ੍ਵਾ ਮੰਨਾਮ੍ਨਾ ਕੰਸੈਕੇਨ ਪਾਨੀਯੰ ਪਾਤੁੰ ਦਦਾਤਿ, ਯੁਸ਼਼੍ਮਾਨਹੰ ਯਥਾਰ੍ਥੰ ਵਚ੍ਮਿ, ਸ ਫਲੇਨ ਵਞ੍ਚਿਤੋ ਨ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","ਕਿਨ੍ਤੁ ਯਦਿ ਕਸ਼੍ਚਿਨ੍ ਮਯਿ ਵਿਸ਼੍ਵਾਸਿਨਾਮੇਸ਼਼ਾਂ ਕ੍ਸ਼਼ੁਦ੍ਰਪ੍ਰਾਣਿਨਾਮ੍ ਏਕਸ੍ਯਾਪਿ ਵਿਘ੍ਨੰ ਜਨਯਤਿ, ਤਰ੍ਹਿ ਤਸ੍ਯੈਤਤ੍ਕਰ੍ੰਮ ਕਰਣਾਤ੍ ਕਣ੍ਠਬੱਧਪੇਸ਼਼ਣੀਕਸ੍ਯ ਤਸ੍ਯ ਸਾਗਰਾਗਾਧਜਲ ਮੱਜਨੰ ਭਦ੍ਰੰ| ");
INSERT INTO sanpun_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","ਅਤਃ ਸ੍ਵਕਰੋ ਯਦਿ ਤ੍ਵਾਂ ਬਾਧਤੇ ਤਰ੍ਹਿ ਤੰ ਛਿਨ੍ਧਿ; ");
INSERT INTO sanpun_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ਯਸ੍ਮਾਤ੍ ਯਤ੍ਰ ਕੀਟਾ ਨ ਮ੍ਰਿਯਨ੍ਤੇ ਵਹ੍ਨਿਸ਼੍ਚ ਨ ਨਿਰ੍ੱਵਾਤਿ, ਤਸ੍ਮਿਨ੍ ਅਨਿਰ੍ੱਵਾਣਾਨਲਨਰਕੇ ਕਰਦ੍ਵਯਵਸ੍ਤਵ ਗਮਨਾਤ੍ ਕਰਹੀਨਸ੍ਯ ਸ੍ਵਰ੍ਗਪ੍ਰਵੇਸ਼ਸ੍ਤਵ ਕ੍ਸ਼਼ੇਮੰ| ");
INSERT INTO sanpun_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","ਯਦਿ ਤਵ ਪਾਦੋ ਵਿਘ੍ਨੰ ਜਨਯਤਿ ਤਰ੍ਹਿ ਤੰ ਛਿਨ੍ਧਿ, ");
INSERT INTO sanpun_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ਯਤੋ ਯਤ੍ਰ ਕੀਟਾ ਨ ਮ੍ਰਿਯਨ੍ਤੇ ਵਹ੍ਨਿਸ਼੍ਚ ਨ ਨਿਰ੍ੱਵਾਤਿ, ਤਸ੍ਮਿਨ੍ (ਅ)ਨਿਰ੍ੱਵਾਣਵਹ੍ਨੌ ਨਰਕੇ ਦ੍ਵਿਪਾਦਵਤਸ੍ਤਵ ਨਿਕ੍ਸ਼਼ੇਪਾਤ੍ ਪਾਦਹੀਨਸ੍ਯ ਸ੍ਵਰ੍ਗਪ੍ਰਵੇਸ਼ਸ੍ਤਵ ਕ੍ਸ਼਼ੇਮੰ| ");
INSERT INTO sanpun_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","ਸ੍ਵਨੇਤ੍ਰੰ ਯਦਿ ਤ੍ਵਾਂ ਬਾਧਤੇ ਤਰ੍ਹਿ ਤਦਪ੍ਯੁਤ੍ਪਾਟਯ, ਯਤੋ ਯਤ੍ਰ ਕੀਟਾ ਨ ਮ੍ਰਿਯਨ੍ਤੇ ਵਹ੍ਨਿਸ਼੍ਚ ਨ ਨਿਰ੍ੱਵਾਤਿ, ");
INSERT INTO sanpun_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ਤਸ੍ਮਿਨ (ਅ)ਨਿਰ੍ੱਵਾਣਵਹ੍ਨੌ ਨਰਕੇ ਦ੍ਵਿਨੇਤ੍ਰਸ੍ਯ ਤਵ ਨਿਕ੍ਸ਼਼ੇਪਾਦ੍ ਏਕਨੇਤ੍ਰਵਤ ਈਸ਼੍ਵਰਰਾਜ੍ਯੇ ਪ੍ਰਵੇਸ਼ਸ੍ਤਵ ਕ੍ਸ਼਼ੇਮੰ| ");
INSERT INTO sanpun_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","ਯਥਾ ਸਰ੍ੱਵੋ ਬਲਿ ਰ੍ਲਵਣਾਕ੍ਤਃ ਕ੍ਰਿਯਤੇ ਤਥਾ ਸਰ੍ੱਵੋ ਜਨੋ ਵਹ੍ਨਿਰੂਪੇਣ ਲਵਣਾਕ੍ਤਃ ਕਾਰਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","ਲਵਣੰ ਭਦ੍ਰੰ ਕਿਨ੍ਤੁ ਯਦਿ ਲਵਣੇ ਸ੍ਵਾਦੁਤਾ ਨ ਤਿਸ਼਼੍ਠਤਿ, ਤਰ੍ਹਿ ਕਥਮ੍ ਆਸ੍ਵਾਦ੍ਯੁਕ੍ਤੰ ਕਰਿਸ਼਼੍ਯਥ? ਯੂਯੰ ਲਵਣਯੁਕ੍ਤਾ ਭਵਤ ਪਰਸ੍ਪਰੰ ਪ੍ਰੇਮ ਕੁਰੁਤ| ");
INSERT INTO sanpun_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","ਅਨਨ੍ਤਰੰ ਸ ਤਤ੍ਸ੍ਥਾਨਾਤ੍ ਪ੍ਰਸ੍ਥਾਯ ਯਰ੍ੱਦਨਨਦ੍ਯਾਃ ਪਾਰੇ ਯਿਹੂਦਾਪ੍ਰਦੇਸ਼ ਉਪਸ੍ਥਿਤਵਾਨ੍, ਤਤ੍ਰ ਤਦਨ੍ਤਿਕੇ ਲੋਕਾਨਾਂ ਸਮਾਗਮੇ ਜਾਤੇ ਸ ਨਿਜਰੀਤ੍ਯਨੁਸਾਰੇਣ ਪੁਨਸ੍ਤਾਨ੍ ਉਪਦਿਦੇਸ਼| ");
INSERT INTO sanpun_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ਤਦਾ ਫਿਰੂਸ਼ਿਨਸ੍ਤਤ੍ਸਮੀਪਮ੍ ਏਤ੍ਯ ਤੰ ਪਰੀਕ੍ਸ਼਼ਿਤੁੰ ਪਪ੍ਰੱਛਃ ਸ੍ਵਜਾਯਾ ਮਨੁਜਾਨਾਂ ਤ੍ਯਜ੍ਯਾ ਨ ਵੇਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ਤਤਃ ਸ ਪ੍ਰਤ੍ਯਵਾਦੀਤ੍, ਅਤ੍ਰ ਕਾਰ੍ੱਯੇ ਮੂਸਾ ਯੁਸ਼਼੍ਮਾਨ੍ ਪ੍ਰਤਿ ਕਿਮਾਜ੍ਞਾਪਯਤ੍? ");
INSERT INTO sanpun_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ਤ ਊਚੁਃ ਤ੍ਯਾਗਪਤ੍ਰੰ ਲੇਖਿਤੁੰ ਸ੍ਵਪਤ੍ਨੀਂ ਤ੍ਯਕ੍ਤੁਞ੍ਚ ਮੂਸਾ(ਅ)ਨੁਮਨ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","ਤਦਾ ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯੁਵਾਚ, ਯੁਸ਼਼੍ਮਾਕੰ ਮਨਸਾਂ ਕਾਠਿਨ੍ਯਾੱਧੇਤੋ ਰ੍ਮੂਸਾ ਨਿਦੇਸ਼ਮਿਮਮ੍ ਅਲਿਖਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","ਕਿਨ੍ਤੁ ਸ੍ਰੁʼਸ਼਼੍ਟੇਰਾਦੌ ਈਸ਼੍ਵਰੋ ਨਰਾਨ੍ ਪੁੰਰੂਪੇਣ ਸ੍ਤ੍ਰੀਰੂਪੇਣ ਚ ਸਸਰ੍ਜ| ");
INSERT INTO sanpun_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","\"ਤਤਃ ਕਾਰਣਾਤ੍ ਪੁਮਾਨ੍ ਪਿਤਰੰ ਮਾਤਰਞ੍ਚ ਤ੍ਯਕ੍ਤ੍ਵਾ ਸ੍ਵਜਾਯਾਯਾਮ੍ ਆਸਕ੍ਤੋ ਭਵਿਸ਼਼੍ਯਤਿ, ");
INSERT INTO sanpun_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ਤੌ ਦ੍ਵਾਵ੍ ਏਕਾਙ੍ਗੌ ਭਵਿਸ਼਼੍ਯਤਃ| \" ਤਸ੍ਮਾਤ੍ ਤਤ੍ਕਾਲਮਾਰਭ੍ਯ ਤੌ ਨ ਦ੍ਵਾਵ੍ ਏਕਾਙ੍ਗੌ| ");
INSERT INTO sanpun_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ਅਤਃ ਕਾਰਣਾਦ੍ ਈਸ਼੍ਵਰੋ ਯਦਯੋਜਯਤ੍ ਕੋਪਿ ਨਰਸ੍ਤੰਨ ਵਿਯੇਜਯੇਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","ਅਥ ਯੀਸ਼ੁ ਰ੍ਗ੍ਰੁʼਹੰ ਪ੍ਰਵਿਸ਼਼੍ਟਸ੍ਤਦਾ ਸ਼ਿਸ਼਼੍ਯਾਃ ਪੁਨਸ੍ਤਤ੍ਕਥਾਂ ਤੰ ਪਪ੍ਰੱਛੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ਤਤਃ ਸੋਵਦਤ੍ ਕਸ਼੍ਚਿਦ੍ ਯਦਿ ਸ੍ਵਭਾਰ੍ੱਯਾਂ ਤ੍ਯਕ੍ਤਵਾਨ੍ਯਾਮ੍ ਉਦ੍ਵਹਤਿ ਤਰ੍ਹਿ ਸ ਸ੍ਵਭਾਰ੍ੱਯਾਯਾਃ ਪ੍ਰਾਤਿਕੂਲ੍ਯੇਨ ਵ੍ਯਭਿਚਾਰੀ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ਕਾਚਿੰਨਾਰੀ ਯਦਿ ਸ੍ਵਪਤਿੰ ਹਿਤ੍ਵਾਨ੍ਯਪੁੰਸਾ ਵਿਵਾਹਿਤਾ ਭਵਤਿ ਤਰ੍ਹਿ ਸਾਪਿ ਵ੍ਯਭਿਚਾਰਿਣੀ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","ਅਥ ਸ ਯਥਾ ਸ਼ਿਸ਼ੂਨ੍ ਸ੍ਪ੍ਰੁʼਸ਼ੇਤ੍, ਤਦਰ੍ਥੰ ਲੋਕੈਸ੍ਤਦਨ੍ਤਿਕੰ ਸ਼ਿਸ਼ਵ ਆਨੀਯਨ੍ਤ, ਕਿਨ੍ਤੁ ਸ਼ਿਸ਼਼੍ਯਾਸ੍ਤਾਨਾਨੀਤਵਤਸ੍ਤਰ੍ਜਯਾਮਾਸੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ਯੀਸ਼ੁਸ੍ਤਦ੍ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਕ੍ਰੁਧ੍ਯਨ੍ ਜਗਾਦ, ਮੰਨਿਕਟਮ੍ ਆਗਨ੍ਤੁੰ ਸ਼ਿਸ਼ੂਨ੍ ਮਾ ਵਾਰਯਤ, ਯਤ ਏਤਾਦ੍ਰੁʼਸ਼ਾ ਈਸ਼੍ਵਰਰਾਜ੍ਯਾਧਿਕਾਰਿਣਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","ਯੁਸ਼਼੍ਮਾਨਹੰ ਯਥਾਰ੍ਥੰ ਵਚ੍ਮਿ, ਯਃ ਕਸ਼੍ਚਿਤ੍ ਸ਼ਿਸ਼ੁਵਦ੍ ਭੂਤ੍ਵਾ ਰਾਜ੍ਯਮੀਸ਼੍ਵਰਸ੍ਯ ਨ ਗ੍ਰੁʼਹ੍ਲੀਯਾਤ੍ ਸ ਕਦਾਪਿ ਤਦ੍ਰਾਜ੍ਯੰ ਪ੍ਰਵੇਸ਼਼੍ਟੁੰ ਨ ਸ਼ਕ੍ਨੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ਅਨਨਤਰੰ ਸ ਸ਼ਿਸ਼ੂਨਙ੍ਕੇ ਨਿਧਾਯ ਤੇਸ਼਼ਾਂ ਗਾਤ੍ਰੇਸ਼਼ੁ ਹਸ੍ਤੌ ਦੱਤ੍ਵਾਸ਼ਿਸ਼਼ੰ ਬਭਾਸ਼਼ੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","ਅਥ ਸ ਵਰ੍ਤ੍ਮਨਾ ਯਾਤਿ, ਏਤਰ੍ਹਿ ਜਨ ਏਕੋ ਧਾਵਨ੍ ਆਗਤ੍ਯ ਤਤ੍ਸੰਮੁਖੇ ਜਾਨੁਨੀ ਪਾਤਯਿਤ੍ਵਾ ਪ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍, ਭੋਃ ਪਰਮਗੁਰੋ, ਅਨਨ੍ਤਾਯੁਃ ਪ੍ਰਾਪ੍ਤਯੇ ਮਯਾ ਕਿੰ ਕਰ੍ੱਤਵ੍ਯੰ? ");
INSERT INTO sanpun_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","ਤਦਾ ਯੀਸ਼ੁਰੁਵਾਚ, ਮਾਂ ਪਰਮੰ ਕੁਤੋ ਵਦਸਿ? ਵਿਨੇਸ਼੍ਵਰੰ ਕੋਪਿ ਪਰਮੋ ਨ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","ਪਰਸ੍ਤ੍ਰੀਂ ਨਾਭਿਗੱਛ; ਨਰੰ ਮਾ ਘਾਤਯ; ਸ੍ਤੇਯੰ ਮਾ ਕੁਰੁ; ਮ੍ਰੁʼਸ਼਼ਾਸਾਕ੍ਸ਼਼੍ਯੰ ਮਾ ਦੇਹਿ; ਹਿੰਸਾਞ੍ਚ ਮਾ ਕੁਰੁ; ਪਿਤਰੌ ਸੰਮਨ੍ਯਸ੍ਵ; ਨਿਦੇਸ਼ਾ ਏਤੇ ਤ੍ਵਯਾ ਜ੍ਞਾਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ਤਤਸ੍ਤਨ ਪ੍ਰਤ੍ਯੁਕ੍ਤੰ, ਹੇ ਗੁਰੋ ਬਾਲ੍ਯਕਾਲਾਦਹੰ ਸਰ੍ੱਵਾਨੇਤਾਨ੍ ਆਚਰਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ਤਦਾ ਯੀਸ਼ੁਸ੍ਤੰ ਵਿਲੋਕ੍ਯ ਸ੍ਨੇਹੇਨ ਬਭਾਸ਼਼ੇ, ਤਵੈਕਸ੍ਯਾਭਾਵ ਆਸ੍ਤੇ; ਤ੍ਵੰ ਗਤ੍ਵਾ ਸਰ੍ੱਵਸ੍ਵੰ ਵਿਕ੍ਰੀਯ ਦਰਿਦ੍ਰੇਭ੍ਯੋ ਵਿਸ਼੍ਰਾਣਯ, ਤਤਃ ਸ੍ਵਰ੍ਗੇ ਧਨੰ ਪ੍ਰਾਪ੍ਸ੍ਯਸਿ; ਤਤਃ ਪਰਮ੍ ਏਤ੍ਯ ਕ੍ਰੁਸ਼ੰ ਵਹਨ੍ ਮਦਨੁਵਰ੍ੱਤੀ ਭਵ| ");
INSERT INTO sanpun_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ਕਿਨ੍ਤੁ ਤਸ੍ਯ ਬਹੁਸਮ੍ਪਦ੍ਵਿਦ੍ਯਮਾਨਤ੍ਵਾਤ੍ ਸ ਇਮਾਂ ਕਥਾਮਾਕਰ੍ਣ੍ਯ ਵਿਸ਼਼ਣੋ ਦੁਃਖਿਤਸ਼੍ਚ ਸਨ੍ ਜਗਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","ਅਥ ਯੀਸ਼ੁਸ਼੍ਚਤੁਰ੍ਦਿਸ਼ੋ ਨਿਰੀਕ੍ਸ਼਼੍ਯ ਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਅਵਾਦੀਤ੍, ਧਨਿਲੋਕਾਨਾਮ੍ ਈਸ਼੍ਵਰਰਾਜ੍ਯਪ੍ਰਵੇਸ਼ਃ ਕੀਦ੍ਰੁʼਗ੍ ਦੁਸ਼਼੍ਕਰਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","ਤਸ੍ਯ ਕਥਾਤਃ ਸ਼ਿਸ਼਼੍ਯਾਸ਼੍ਚਮੱਚਕ੍ਰੁਃ, ਕਿਨ੍ਤੁ ਸ ਪੁਨਰਵਦਤ੍, ਹੇ ਬਾਲਕਾ ਯੇ ਧਨੇ ਵਿਸ਼੍ਵਸਨ੍ਤਿ ਤੇਸ਼਼ਾਮ੍ ਈਸ਼੍ਵਰਰਾਜ੍ਯਪ੍ਰਵੇਸ਼ਃ ਕੀਦ੍ਰੁʼਗ੍ ਦੁਸ਼਼੍ਕਰਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ਈਸ਼੍ਵਰਰਾਜ੍ਯੇ ਧਨਿਨਾਂ ਪ੍ਰਵੇਸ਼ਾਤ੍ ਸੂਚਿਰਨ੍ਧ੍ਰੇਣ ਮਹਾਙ੍ਗਸ੍ਯ ਗਮਨਾਗਮਨੰ ਸੁਕਰੰ| ");
INSERT INTO sanpun_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","ਤਦਾ ਸ਼ਿਸ਼਼੍ਯਾ ਅਤੀਵ ਵਿਸ੍ਮਿਤਾਃ ਪਰਸ੍ਪਰੰ ਪ੍ਰੋਚੁਃ, ਤਰ੍ਹਿ ਕਃ ਪਰਿਤ੍ਰਾਣੰ ਪ੍ਰਾਪ੍ਤੁੰ ਸ਼ਕ੍ਨੋਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ਤਤੋ ਯੀਸ਼ੁਸ੍ਤਾਨ੍ ਵਿਲੋਕ੍ਯ ਬਭਾਸ਼਼ੇ, ਤਨ੍ ਨਰਸ੍ਯਾਸਾਧ੍ਯੰ ਕਿਨ੍ਤੁ ਨੇਸ਼੍ਵਰਸ੍ਯ, ਯਤੋ ਹੇਤੋਰੀਸ਼੍ਵਰਸ੍ਯ ਸਰ੍ੱਵੰ ਸਾਧ੍ਯਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ਤਦਾ ਪਿਤਰ ਉਵਾਚ, ਪਸ਼੍ਯ ਵਯੰ ਸਰ੍ੱਵੰ ਪਰਿਤ੍ਯਜ੍ਯ ਭਵਤੋਨੁਗਾਮਿਨੋ ਜਾਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","ਤਤੋ ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯਵਦਤ੍, ਯੁਸ਼਼੍ਮਾਨਹੰ ਯਥਾਰ੍ਥੰ ਵਦਾਮਿ, ਮਦਰ੍ਥੰ ਸੁਸੰਵਾਦਾਰ੍ਥੰ ਵਾ ਯੋ ਜਨਃ ਸਦਨੰ ਭ੍ਰਾਤਰੰ ਭਗਿਨੀਂ ਪਿਤਰੰ ਮਾਤਰੰ ਜਾਯਾਂ ਸਨ੍ਤਾਨਾਨ੍ ਭੂਮਿ ਵਾ ਤ੍ਯਕ੍ਤ੍ਵਾ ");
INSERT INTO sanpun_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ਗ੍ਰੁʼਹਭ੍ਰਾਤ੍ਰੁʼਭਗਿਨੀਪਿਤ੍ਰੁʼਮਾਤ੍ਰੁʼਪਤ੍ਨੀਸਨ੍ਤਾਨਭੂਮੀਨਾਮਿਹ ਸ਼ਤਗੁਣਾਨ੍ ਪ੍ਰੇਤ੍ਯਾਨਨ੍ਤਾਯੁਸ਼੍ਚ ਨ ਪ੍ਰਾਪ੍ਨੋਤਿ ਤਾਦ੍ਰੁʼਸ਼ਃ ਕੋਪਿ ਨਾਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","ਕਿਨ੍ਤ੍ਵਗ੍ਰੀਯਾ ਅਨੇਕੇ ਲੋਕਾਃ ਸ਼ੇਸ਼਼ਾਃ, ਸ਼ੇਸ਼਼ੀਯਾ ਅਨੇਕੇ ਲੋਕਾਸ਼੍ਚਾਗ੍ਰਾ ਭਵਿਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","ਅਥ ਯਿਰੂਸ਼ਾਲਮ੍ਯਾਨਕਾਲੇ ਯੀਸ਼ੁਸ੍ਤੇਸ਼਼ਾਮ੍ ਅਗ੍ਰਗਾਮੀ ਬਭੂਵ, ਤਸ੍ਮਾੱਤੇ ਚਿਤ੍ਰੰ ਜ੍ਞਾਤ੍ਵਾ ਪਸ਼੍ਚਾਦ੍ਗਾਮਿਨੋ ਭੂਤ੍ਵਾ ਬਿਭ੍ਯੁਃ| ਤਦਾ ਸ ਪੁਨ ਰ੍ਦ੍ਵਾਦਸ਼ਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਸ੍ਵੀਯੰ ਯਦ੍ਯਦ੍ ਘਟਿਸ਼਼੍ਯਤੇ ਤੱਤਤ੍ ਤੇਭ੍ਯਃ ਕਥਯਿਤੁੰ ਪ੍ਰਾਰੇਭੇ; ");
INSERT INTO sanpun_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ਪਸ਼੍ਯਤ ਵਯੰ ਯਿਰੂਸ਼ਾਲਮ੍ਪੁਰੰ ਯਾਮਃ, ਤਤ੍ਰ ਮਨੁਸ਼਼੍ਯਪੁਤ੍ਰਃ ਪ੍ਰਧਾਨਯਾਜਕਾਨਾਮ੍ ਉਪਾਧ੍ਯਾਯਾਨਾਞ੍ਚ ਕਰੇਸ਼਼ੁ ਸਮਰ੍ਪਯਿਸ਼਼੍ਯਤੇ; ਤੇ ਚ ਵਧਦਣ੍ਡਾਜ੍ਞਾਂ ਦਾਪਯਿਤ੍ਵਾ ਪਰਦੇਸ਼ੀਯਾਨਾਂ ਕਰੇਸ਼਼ੁ ਤੰ ਸਮਰ੍ਪਯਿਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ਤੇ ਤਮੁਪਹਸ੍ਯ ਕਸ਼ਯਾ ਪ੍ਰਹ੍ਰੁʼਤ੍ਯ ਤਦ੍ਵਪੁਸ਼਼ਿ ਨਿਸ਼਼੍ਠੀਵੰ ਨਿਕ੍ਸ਼਼ਿਪ੍ਯ ਤੰ ਹਨਿਸ਼਼੍ਯਨ੍ਤਿ, ਤਤਃ ਸ ਤ੍ਰੁʼਤੀਯਦਿਨੇ ਪ੍ਰੋੱਥਾਸ੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ਤਤਃ ਸਿਵਦੇਃ ਪੁਤ੍ਰੌ ਯਾਕੂਬ੍ਯੋਹਨੌ ਤਦਨ੍ਤਿਕਮ੍ ਏਤ੍ਯ ਪ੍ਰੋਚਤੁਃ, ਹੇ ਗੁਰੋ ਯਦ੍ ਆਵਾਭ੍ਯਾਂ ਯਾਚਿਸ਼਼੍ਯਤੇ ਤਦਸ੍ਮਦਰ੍ਥੰ ਭਵਾਨ੍ ਕਰੋਤੁ ਨਿਵੇਦਨਮਿਦਮਾਵਯੋਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ਤਤਃ ਸ ਕਥਿਤਵਾਨ੍, ਯੁਵਾਂ ਕਿਮਿੱਛਥਃ? ਕਿੰ ਮਯਾ ਯੁਸ਼਼੍ਮਦਰ੍ਥੰ ਕਰਣੀਯੰ? ");
INSERT INTO sanpun_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ਤਦਾ ਤੌ ਪ੍ਰੋਚਤੁਃ, ਆਵਯੋਰੇਕੰ ਦਕ੍ਸ਼਼ਿਣਪਾਰ੍ਸ਼੍ਵੇ ਵਾਮਪਾਰ੍ਸ਼੍ਵੇ ਚੈਕੰ ਤਵੈਸ਼੍ਵਰ੍ੱਯਪਦੇ ਸਮੁਪਵੇਸ਼਼੍ਟੁਮ੍ ਆਜ੍ਞਾਪਯ| ");
INSERT INTO sanpun_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ਕਿਨ੍ਤੁ ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯੁਵਾਚ ਯੁਵਾਮਜ੍ਞਾਤ੍ਵੇਦੰ ਪ੍ਰਾਰ੍ਥਯੇਥੇ, ਯੇਨ ਕੰਸੇਨਾਹੰ ਪਾਸ੍ਯਾਮਿ ਤੇਨ ਯੁਵਾਭ੍ਯਾਂ ਕਿੰ ਪਾਤੁੰ ਸ਼ਕ੍ਸ਼਼੍ਯਤੇ? ਯਸ੍ਮਿਨ੍ ਮੱਜਨੇਨਾਹੰ ਮੱਜਿਸ਼਼੍ਯੇ ਤਨ੍ਮੱਜਨੇ ਮੱਜਯਿਤੁੰ ਕਿੰ ਯੁਵਾਭ੍ਯਾਂ ਸ਼ਕ੍ਸ਼਼੍ਯਤੇ? ਤੌ ਪ੍ਰਤ੍ਯੂਚਤੁਃ ਸ਼ਕ੍ਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","ਤਦਾ ਯੀਸ਼ੁਰਵਦਤ੍ ਯੇਨ ਕੰਸੇਨਾਹੰ ਪਾਸ੍ਯਾਮਿ ਤੇਨਾਵਸ਼੍ਯੰ ਯੁਵਾਮਪਿ ਪਾਸ੍ਯਥਃ, ਯੇਨ ਮੱਜਨੇਨ ਚਾਹੰ ਮੱਜਿੱਯੇ ਤਤ੍ਰ ਯੁਵਾਮਪਿ ਮੱਜਿਸ਼਼੍ਯੇਥੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ਕਿਨ੍ਤੁ ਯੇਸ਼਼ਾਮਰ੍ਥਮ੍ ਇਦੰ ਨਿਰੂਪਿਤੰ, ਤਾਨ੍ ਵਿਹਾਯਾਨ੍ਯੰ ਕਮਪਿ ਮਮ ਦਕ੍ਸ਼਼ਿਣਪਾਰ੍ਸ਼੍ਵੇ ਵਾਮਪਾਰ੍ਸ਼੍ਵੇ ਵਾ ਸਮੁਪਵੇਸ਼ਯਿਤੁੰ ਮਮਾਧਿਕਾਰੋ ਨਾਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ਅਥਾਨ੍ਯਦਸ਼ਸ਼ਿਸ਼਼੍ਯਾ ਇਮਾਂ ਕਥਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਯਾਕੂਬ੍ਯੋਹਨ੍ਭ੍ਯਾਂ ਚੁਕੁਪੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ਕਿਨ੍ਤੁ ਯੀਸ਼ੁਸ੍ਤਾਨ੍ ਸਮਾਹੂਯ ਬਭਾਸ਼਼ੇ, ਅਨ੍ਯਦੇਸ਼ੀਯਾਨਾਂ ਰਾਜਤ੍ਵੰ ਯੇ ਕੁਰ੍ੱਵਨ੍ਤਿ ਤੇ ਤੇਸ਼਼ਾਮੇਵ ਪ੍ਰਭੁਤ੍ਵੰ ਕੁਰ੍ੱਵਨ੍ਤਿ, ਤਥਾ ਯੇ ਮਹਾਲੋਕਾਸ੍ਤੇ ਤੇਸ਼਼ਾਮ੍ ਅਧਿਪਤਿਤ੍ਵੰ ਕੁਰ੍ੱਵਨ੍ਤੀਤਿ ਯੂਯੰ ਜਾਨੀਥ| ");
INSERT INTO sanpun_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","ਕਿਨ੍ਤੁ ਯੁਸ਼਼੍ਮਾਕੰ ਮਧ੍ਯੇ ਨ ਤਥਾ ਭਵਿਸ਼਼੍ਯਤਿ, ਯੁਸ਼਼੍ਮਾਕੰ ਮਧ੍ਯੇ ਯਃ ਪ੍ਰਾਧਾਨ੍ਯੰ ਵਾਞ੍ਛਤਿ ਸ ਯੁਸ਼਼੍ਮਾਕੰ ਸੇਵਕੋ ਭਵਿਸ਼਼੍ਯਤਿ, ");
INSERT INTO sanpun_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ਯੁਸ਼਼੍ਮਾਕੰ ਯੋ ਮਹਾਨ੍ ਭਵਿਤੁਮਿੱਛਤਿ ਸ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਕਿਙ੍ਕਰੋ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","ਯਤੋ ਮਨੁਸ਼਼੍ਯਪੁਤ੍ਰਃ ਸੇਵ੍ਯੋ ਭਵਿਤੁੰ ਨਾਗਤਃ ਸੇਵਾਂ ਕਰ੍ੱਤਾਂ ਤਥਾਨੇਕੇਸ਼਼ਾਂ ਪਰਿਤ੍ਰਾਣਸ੍ਯ ਮੂਲ੍ਯਰੂਪਸ੍ਵਪ੍ਰਾਣੰ ਦਾਤੁਞ੍ਚਾਗਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ਅਥ ਤੇ ਯਿਰੀਹੋਨਗਰੰ ਪ੍ਰਾਪ੍ਤਾਸ੍ਤਸ੍ਮਾਤ੍ ਸ਼ਿਸ਼਼੍ਯੈ ਰ੍ਲੋਕੈਸ਼੍ਚ ਸਹ ਯੀਸ਼ੋ ਰ੍ਗਮਨਕਾਲੇ ਟੀਮਯਸ੍ਯ ਪੁਤ੍ਰੋ ਬਰ੍ਟੀਮਯਨਾਮਾ ਅਨ੍ਧਸ੍ਤਨ੍ਮਾਰ੍ਗਪਾਰ੍ਸ਼੍ਵੇ ਭਿਕ੍ਸ਼਼ਾਰ੍ਥਮ੍ ਉਪਵਿਸ਼਼੍ਟਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ਸ ਨਾਸਰਤੀਯਸ੍ਯ ਯੀਸ਼ੋਰਾਗਮਨਵਾਰ੍ੱਤਾਂ ਪ੍ਰਾਪ੍ਯ ਪ੍ਰੋਚੈ ਰ੍ਵਕ੍ਤੁਮਾਰੇਭੇ, ਹੇ ਯੀਸ਼ੋ ਦਾਯੂਦਃ ਸਨ੍ਤਾਨ ਮਾਂ ਦਯਸ੍ਵ| ");
INSERT INTO sanpun_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ਤਤੋਨੇਕੇ ਲੋਕਾ ਮੌਨੀਭਵੇਤਿ ਤੰ ਤਰ੍ਜਯਾਮਾਸੁਃ, ਕਿਨ੍ਤੁ ਸ ਪੁਨਰਧਿਕਮੁੱਚੈ ਰ੍ਜਗਾਦ, ਹੇ ਯੀਸ਼ੋ ਦਾਯੂਦਃ ਸਨ੍ਤਾਨ ਮਾਂ ਦਯਸ੍ਵ| ");
INSERT INTO sanpun_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","ਤਦਾ ਯੀਸ਼ੁਃ ਸ੍ਥਿਤ੍ਵਾ ਤਮਾਹ੍ਵਾਤੁੰ ਸਮਾਦਿਦੇਸ਼, ਤਤੋ ਲੋਕਾਸ੍ਤਮਨ੍ਧਮਾਹੂਯ ਬਭਾਸ਼਼ਿਰੇ, ਹੇ ਨਰ, ਸ੍ਥਿਰੋ ਭਵ, ਉੱਤਿਸ਼਼੍ਠ, ਸ ਤ੍ਵਾਮਾਹ੍ਵਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ਤਦਾ ਸ ਉੱਤਰੀਯਵਸ੍ਤ੍ਰੰ ਨਿਕ੍ਸ਼਼ਿਪ੍ਯ ਪ੍ਰੋੱਥਾਯ ਯੀਸ਼ੋਃ ਸਮੀਪੰ ਗਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ਤਤੋ ਯੀਸ਼ੁਸ੍ਤਮਵਦਤ੍ ਤ੍ਵਯਾ ਕਿੰ ਪ੍ਰਾਰ੍ਥ੍ਯਤੇ? ਤੁਭ੍ਯਮਹੰ ਕਿੰ ਕਰਿਸ਼਼੍ਯਾਮੀ? ਤਦਾ ਸੋਨ੍ਧਸ੍ਤਮੁਵਾਚ, ਹੇ ਗੁਰੋ ਮਦੀਯਾ ਦ੍ਰੁʼਸ਼਼੍ਟਿਰ੍ਭਵੇਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ਤਤੋ ਯੀਸ਼ੁਸ੍ਤਮੁਵਾਚ ਯਾਹਿ ਤਵ ਵਿਸ਼੍ਵਾਸਸ੍ਤ੍ਵਾਂ ਸ੍ਵਸ੍ਥਮਕਾਰ੍ਸ਼਼ੀਤ੍, ਤਸ੍ਮਾਤ੍ ਤਤ੍ਕ੍ਸ਼਼ਣੰ ਸ ਦ੍ਰੁʼਸ਼਼੍ਟਿੰ ਪ੍ਰਾਪ੍ਯ ਪਥਾ ਯੀਸ਼ੋਃ ਪਸ਼੍ਚਾਦ੍ ਯਯੌ| ");
INSERT INTO sanpun_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ਅਨਨ੍ਤਰੰ ਤੇਸ਼਼ੁ ਯਿਰੂਸ਼ਾਲਮਃ ਸਮੀਪਸ੍ਥਯੋ ਰ੍ਬੈਤ੍ਫਗੀਬੈਥਨੀਯਪੁਰਯੋਰਨ੍ਤਿਕਸ੍ਥੰ ਜੈਤੁਨਨਾਮਾਦ੍ਰਿਮਾਗਤੇਸ਼਼ੁ ਯੀਸ਼ੁਃ ਪ੍ਰੇਸ਼਼ਣਕਾਲੇ ਦ੍ਵੌ ਸ਼ਿਸ਼਼੍ਯਾਵਿਦੰ ਵਾਕ੍ਯੰ ਜਗਾਦ, ");
INSERT INTO sanpun_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ਯੁਵਾਮਮੁੰ ਸੰਮੁਖਸ੍ਥੰ ਗ੍ਰਾਮੰ ਯਾਤੰ, ਤਤ੍ਰ ਪ੍ਰਵਿਸ਼੍ਯ ਯੋ ਨਰੰ ਨਾਵਹਤ੍ ਤੰ ਗਰ੍ੱਦਭਸ਼ਾਵਕੰ ਦ੍ਰਕ੍ਸ਼਼੍ਯਥਸ੍ਤੰ ਮੋਚਯਿਤ੍ਵਾਨਯਤੰ| ");
INSERT INTO sanpun_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","ਕਿਨ੍ਤੁ ਯੁਵਾਂ ਕਰ੍ੰਮੇਦੰ ਕੁਤਃ ਕੁਰੁਥਃ? ਕਥਾਮਿਮਾਂ ਯਦਿ ਕੋਪਿ ਪ੍ਰੁʼੱਛਤਿ ਤਰ੍ਹਿ ਪ੍ਰਭੋਰਤ੍ਰ ਪ੍ਰਯੋਜਨਮਸ੍ਤੀਤਿ ਕਥਿਤੇ ਸ ਸ਼ੀਘ੍ਰੰ ਤਮਤ੍ਰ ਪ੍ਰੇਸ਼਼ਯਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ਤਤਸ੍ਤੌ ਗਤ੍ਵਾ ਦ੍ਵਿਮਾਰ੍ਗਮੇਲਨੇ ਕਸ੍ਯਚਿਦ੍ ਦ੍ਵਾਰਸ੍ਯ ਪਾਰ੍ਸ਼੍ਵੇ ਤੰ ਗਰ੍ੱਦਭਸ਼ਾਵਕੰ ਪ੍ਰਾਪ੍ਯ ਮੋਚਯਤਃ, ");
INSERT INTO sanpun_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ਏਤਰ੍ਹਿ ਤਤ੍ਰੋਪਸ੍ਥਿਤਲੋਕਾਨਾਂ ਕਸ਼੍ਚਿਦ੍ ਅਪ੍ਰੁʼੱਛਤ੍, ਗਰ੍ੱਦਭਸ਼ਿਸ਼ੁੰ ਕੁਤੋ ਮੋਚਯਥਃ? ");
INSERT INTO sanpun_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ਤਦਾ ਯੀਸ਼ੋਰਾਜ੍ਞਾਨੁਸਾਰੇਣ ਤੇਭ੍ਯਃ ਪ੍ਰਤ੍ਯੁਦਿਤੇ ਤਤ੍ਕ੍ਸ਼਼ਣੰ ਤਮਾਦਾਤੁੰ ਤੇ(ਅ)ਨੁਜਜ੍ਞੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ਅਥ ਤੌ ਯੀਸ਼ੋਃ ਸੰਨਿਧਿੰ ਗਰ੍ੱਦਭਸ਼ਿਸ਼ੁਮ੍ ਆਨੀਯ ਤਦੁਪਰਿ ਸ੍ਵਵਸ੍ਤ੍ਰਾਣਿ ਪਾਤਯਾਮਾਸਤੁਃ; ਤਤਃ ਸ ਤਦੁਪਰਿ ਸਮੁਪਵਿਸ਼਼੍ਟਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ਤਦਾਨੇਕੇ ਪਥਿ ਸ੍ਵਵਾਸਾਂਸਿ ਪਾਤਯਾਮਾਸੁਃ, ਪਰੈਸ਼੍ਚ ਤਰੁਸ਼ਾਖਾਸ਼੍ਛਿਤਵਾ ਮਾਰ੍ਗੇ ਵਿਕੀਰ੍ਣਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","ਅਪਰਞ੍ਚ ਪਸ਼੍ਚਾਦ੍ਗਾਮਿਨੋ(ਅ)ਗ੍ਰਗਾਮਿਨਸ਼੍ਚ ਸਰ੍ੱਵੇ ਜਨਾ ਉਚੈਃਸ੍ਵਰੇਣ ਵਕ੍ਤੁਮਾਰੇਭਿਰੇ, ਜਯ ਜਯ ਯਃ ਪਰਮੇਸ਼੍ਵਰਸ੍ਯ ਨਾਮ੍ਨਾਗੱਛਤਿ ਸ ਧਨ੍ਯ ਇਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","ਤਥਾਸ੍ਮਾਕਮੰ ਪੂਰ੍ੱਵਪੁਰੁਸ਼਼ਸ੍ਯ ਦਾਯੂਦੋ ਯਦ੍ਰਾਜ੍ਯੰ ਪਰਮੇਸ਼੍ਵਰਨਾਮ੍ਨਾਯਾਤਿ ਤਦਪਿ ਧਨ੍ਯੰ, ਸਰ੍ੱਵਸ੍ਮਾਦੁੱਛ੍ਰਾਯੇ ਸ੍ਵਰ੍ਗੇ ਈਸ਼੍ਵਰਸ੍ਯ ਜਯੋ ਭਵੇਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ਇੱਥੰ ਯੀਸ਼ੁ ਰ੍ਯਿਰੂਸ਼ਾਲਮਿ ਮਨ੍ਦਿਰੰ ਪ੍ਰਵਿਸ਼੍ਯ ਚਤੁਰ੍ਦਿਕ੍ਸ੍ਥਾਨਿ ਸਰ੍ੱਵਾਣਿ ਵਸ੍ਤੂਨਿ ਦ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍; ਅਥ ਸਾਯੰਕਾਲ ਉਪਸ੍ਥਿਤੇ ਦ੍ਵਾਦਸ਼ਸ਼ਿਸ਼਼੍ਯਸਹਿਤੋ ਬੈਥਨਿਯੰ ਜਗਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","ਅਪਰੇਹਨਿ ਬੈਥਨਿਯਾਦ੍ ਆਗਮਨਸਮਯੇ ਕ੍ਸ਼਼ੁਧਾਰ੍ੱਤੋ ਬਭੂਵ| ");
INSERT INTO sanpun_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ਤਤੋ ਦੂਰੇ ਸਪਤ੍ਰਮੁਡੁਮ੍ਬਰਪਾਦਪੰ ਵਿਲੋਕ੍ਯ ਤਤ੍ਰ ਕਿਞ੍ਚਿਤ੍ ਫਲੰ ਪ੍ਰਾਪ੍ਤੁੰ ਤਸ੍ਯ ਸੰਨਿਕ੍ਰੁʼਸ਼਼੍ਟੰ ਯਯੌ, ਤਦਾਨੀਂ ਫਲਪਾਤਨਸ੍ਯ ਸਮਯੋ ਨਾਗੱਛਤਿ| ਤਤਸ੍ਤਤ੍ਰੋਪਸ੍ਥਿਤਃ ਪਤ੍ਰਾਣਿ ਵਿਨਾ ਕਿਮਪ੍ਯਪਰੰ ਨ ਪ੍ਰਾਪ੍ਯ ਸ ਕਥਿਤਵਾਨ੍, ");
INSERT INTO sanpun_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ਅਦ੍ਯਾਰਭ੍ਯ ਕੋਪਿ ਮਾਨਵਸ੍ਤ੍ਵੱਤਃ ਫਲੰ ਨ ਭੁਞ੍ਜੀਤ; ਇਮਾਂ ਕਥਾਂ ਤਸ੍ਯ ਸ਼ਿਸ਼਼੍ਯਾਃ ਸ਼ੁਸ਼੍ਰੁਵੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","ਤਦਨਨ੍ਤਰੰ ਤੇਸ਼਼ੁ ਯਿਰੂਸ਼ਾਲਮਮਾਯਾਤੇਸ਼਼ੁ ਯੀਸ਼ੁ ਰ੍ਮਨ੍ਦਿਰੰ ਗਤ੍ਵਾ ਤਤ੍ਰਸ੍ਥਾਨਾਂ ਬਣਿਜਾਂ ਮੁਦ੍ਰਾਸਨਾਨਿ ਪਾਰਾਵਤਵਿਕ੍ਰੇਤ੍ਰੁʼਣਾਮ੍ ਆਸਨਾਨਿ ਚ ਨ੍ਯੁਬ੍ਜਯਾਞ੍ਚਕਾਰ ਸਰ੍ੱਵਾਨ੍ ਕ੍ਰੇਤ੍ਰੁʼਨ੍ ਵਿਕ੍ਰੇਤ੍ਰੁਂʼਸ਼੍ਚ ਬਹਿਸ਼੍ਚਕਾਰ| ");
INSERT INTO sanpun_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ਅਪਰੰ ਮਨ੍ਦਿਰਮਧ੍ਯੇਨ ਕਿਮਪਿ ਪਾਤ੍ਰੰ ਵੋਢੁੰ ਸਰ੍ੱਵਜਨੰ ਨਿਵਾਰਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ਲੋਕਾਨੁਪਦਿਸ਼ਨ੍ ਜਗਾਦ, ਮਮ ਗ੍ਰੁʼਹੰ ਸਰ੍ੱਵਜਾਤੀਯਾਨਾਂ ਪ੍ਰਾਰ੍ਥਨਾਗ੍ਰੁʼਹਮ੍ ਇਤਿ ਨਾਮ੍ਨਾ ਪ੍ਰਥਿਤੰ ਭਵਿਸ਼਼੍ਯਤਿ ਏਤਤ੍ ਕਿੰ ਸ਼ਾਸ੍ਤ੍ਰੇ ਲਿਖਿਤੰ ਨਾਸ੍ਤਿ? ਕਿਨ੍ਤੁ ਯੂਯੰ ਤਦੇਵ ਚੋਰਾਣਾਂ ਗਹ੍ਵਰੰ ਕੁਰੁਥ| ");
INSERT INTO sanpun_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ਇਮਾਂ ਵਾਣੀਂ ਸ਼੍ਰੁਤ੍ਵਾਧ੍ਯਾਪਕਾਃ ਪ੍ਰਧਾਨਯਾਜਕਾਸ਼੍ਚ ਤੰ ਯਥਾ ਨਾਸ਼ਯਿਤੁੰ ਸ਼ਕ੍ਨੁਵਨ੍ਤਿ ਤਥੋेਪਾਯੰ ਮ੍ਰੁʼਗਯਾਮਾਸੁਃ, ਕਿਨ੍ਤੁ ਤਸ੍ਯੋਪਦੇਸ਼ਾਤ੍ ਸਰ੍ੱਵੇ ਲੋਕਾ ਵਿਸ੍ਮਯੰ ਗਤਾ ਅਤਸ੍ਤੇ ਤਸ੍ਮਾਦ੍ ਬਿਭ੍ਯੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ਅਥ ਸਾਯੰਸਮਯ ਉਪਸ੍ਥਿਤੇ ਯੀਸ਼ੁਰ੍ਨਗਰਾਦ੍ ਬਹਿਰ੍ਵਵ੍ਰਾਜ| ");
INSERT INTO sanpun_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","ਅਨਨ੍ਤਰੰ ਪ੍ਰਾਤਃਕਾਲੇ ਤੇ ਤੇਨ ਮਾਰ੍ਗੇਣ ਗੱਛਨ੍ਤਸ੍ਤਮੁਡੁਮ੍ਬਰਮਹੀਰੁਹੰ ਸਮੂਲੰ ਸ਼ੁਸ਼਼੍ਕੰ ਦਦ੍ਰੁʼਸ਼ੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ਤਤਃ ਪਿਤਰਃ ਪੂਰ੍ੱਵਵਾਕ੍ਯੰ ਸ੍ਮਰਨ੍ ਯੀਸ਼ੁੰ ਬਭਾਸ਼਼ੰ, ਹੇ ਗੁਰੋ ਪਸ਼੍ਯਤੁ ਯ ਉਡੁਮ੍ਬਰਵਿਟਪੀ ਭਵਤਾ ਸ਼ਪ੍ਤਃ ਸ ਸ਼ੁਸ਼਼੍ਕੋ ਬਭੂਵ| ");
INSERT INTO sanpun_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ਤਤੋ ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯਵਾਦੀਤ੍, ਯੂਯਮੀਸ਼੍ਵਰੇ ਵਿਸ਼੍ਵਸਿਤ| ");
INSERT INTO sanpun_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ਯੁਸ਼਼੍ਮਾਨਹੰ ਯਥਾਰ੍ਥੰ ਵਦਾਮਿ ਕੋਪਿ ਯਦ੍ਯੇਤਦ੍ਗਿਰਿੰ ਵਦਤਿ, ਤ੍ਵਮੁੱਥਾਯ ਗਤ੍ਵਾ ਜਲਧੌ ਪਤ, ਪ੍ਰੋਕ੍ਤਮਿਦੰ ਵਾਕ੍ਯਮਵਸ਼੍ਯੰ ਘਟਿਸ਼਼੍ਯਤੇ, ਮਨਸਾ ਕਿਮਪਿ ਨ ਸਨ੍ਦਿਹ੍ਯ ਚੇਦਿਦੰ ਵਿਸ਼੍ਵਸੇਤ੍ ਤਰ੍ਹਿ ਤਸ੍ਯ ਵਾਕ੍ਯਾਨੁਸਾਰੇਣ ਤਦ੍ ਘਟਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ਅਤੋ ਹੇਤੋਰਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਵਚ੍ਮਿ, ਪ੍ਰਾਰ੍ਥਨਾਕਾਲੇ ਯਦ੍ਯਦਾਕਾਂਕ੍ਸ਼਼ਿਸ਼਼੍ਯਧ੍ਵੇ ਤੱਤਦਵਸ਼੍ਯੰ ਪ੍ਰਾਪ੍ਸ੍ਯਥ, ਇੱਥੰ ਵਿਸ਼੍ਵਸਿਤ, ਤਤਃ ਪ੍ਰਾਪ੍ਸ੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","ਅਪਰਞ੍ਚ ਯੁਸ਼਼੍ਮਾਸੁ ਪ੍ਰਾਰ੍ਥਯਿਤੁੰ ਸਮੁੱਥਿਤੇਸ਼਼ੁ ਯਦਿ ਕੋਪਿ ਯੁਸ਼਼੍ਮਾਕਮ੍ ਅਪਰਾਧੀ ਤਿਸ਼਼੍ਠਤਿ, ਤਰ੍ਹਿ ਤੰ ਕ੍ਸ਼਼ਮਧ੍ਵੰ, ਤਥਾ ਕ੍ਰੁʼਤੇ ਯੁਸ਼਼੍ਮਾਕੰ ਸ੍ਵਰ੍ਗਸ੍ਥਃ ਪਿਤਾਪਿ ਯੁਸ਼਼੍ਮਾਕਮਾਗਾਂਮਿ ਕ੍ਸ਼਼ਮਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","ਕਿਨ੍ਤੁ ਯਦਿ ਨ ਕ੍ਸ਼਼ਮਧ੍ਵੇ ਤਰ੍ਹਿ ਵਃ ਸ੍ਵਰ੍ਗਸ੍ਥਃ ਪਿਤਾਪਿ ਯੁਸ਼਼੍ਮਾਕਮਾਗਾਂਸਿ ਨ ਕ੍ਸ਼਼ਮਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ਅਨਨ੍ਤਰੰ ਤੇ ਪੁਨ ਰ੍ਯਿਰੂਸ਼ਾਲਮੰ ਪ੍ਰਵਿਵਿਸ਼ੁਃ, ਯੀਸ਼ੁ ਰ੍ਯਦਾ ਮਧ੍ਯੇਮਨ੍ਦਿਰਮ੍ ਇਤਸ੍ਤਤੋ ਗੱਛਤਿ, ਤਦਾਨੀਂ ਪ੍ਰਧਾਨਯਾਜਕਾ ਉਪਾਧ੍ਯਾਯਾਃ ਪ੍ਰਾਞ੍ਚਸ਼੍ਚ ਤਦਨ੍ਤਿਕਮੇਤ੍ਯ ਕਥਾਮਿਮਾਂ ਪਪ੍ਰੱਛੁਃ, ");
INSERT INTO sanpun_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ਤ੍ਵੰ ਕੇਨਾਦੇਸ਼ੇਨ ਕਰ੍ੰਮਾਣ੍ਯੇਤਾਨਿ ਕਰੋਸ਼਼ਿ? ਤਥੈਤਾਨਿ ਕਰ੍ੰਮਾਣਿ ਕਰ੍ੱਤਾਂ ਕੇਨਾਦਿਸ਼਼੍ਟੋਸਿ? ");
INSERT INTO sanpun_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ਤਤੋ ਯੀਸ਼ੁਃ ਪ੍ਰਤਿਗਦਿਤਵਾਨ੍ ਅਹਮਪਿ ਯੁਸ਼਼੍ਮਾਨ੍ ਏਕਕਥਾਂ ਪ੍ਰੁʼੱਛਾਮਿ, ਯਦਿ ਯੂਯੰ ਤਸ੍ਯਾ ਉੱਤਰੰ ਕੁਰੁਥ, ਤਰ੍ਹਿ ਕਯਾਜ੍ਞਯਾਹੰ ਕਰ੍ੰਮਾਣ੍ਯੇਤਾਨਿ ਕਰੋਮਿ ਤਦ੍ ਯੁਸ਼਼੍ਮਭ੍ਯੰ ਕਥਯਿਸ਼਼੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ਯੋਹਨੋ ਮੱਜਨਮ੍ ਈਸ਼੍ਵਰਾਤ੍ ਜਾਤੰ ਕਿੰ ਮਾਨਵਾਤ੍? ਤਨ੍ਮਹ੍ਯੰ ਕਥਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","ਤੇ ਪਰਸ੍ਪਰੰ ਵਿਵੇਕ੍ਤੁੰ ਪ੍ਰਾਰੇਭਿਰੇ, ਤਦ੍ ਈਸ਼੍ਵਰਾਦ੍ ਬਭੂਵੇਤਿ ਚੇਦ੍ ਵਦਾਮਸ੍ਤਰ੍ਹਿ ਕੁਤਸ੍ਤੰ ਨ ਪ੍ਰਤ੍ਯੈਤ? ਕਥਮੇਤਾਂ ਕਥਯਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","ਮਾਨਵਾਦ੍ ਅਭਵਦਿਤਿ ਚੇਦ੍ ਵਦਾਮਸ੍ਤਰ੍ਹਿ ਲੋਕੇਭ੍ਯੋ ਭਯਮਸ੍ਤਿ ਯਤੋ ਹੇਤੋਃ ਸਰ੍ੱਵੇ ਯੋਹਨੰ ਸਤ੍ਯੰ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨੰ ਮਨ੍ਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ਅਤਏਵ ਤੇ ਯੀਸ਼ੁੰ ਪ੍ਰਤ੍ਯਵਾਦਿਸ਼਼ੁ ਰ੍ਵਯੰ ਤਦ੍ ਵਕ੍ਤੁੰ ਨ ਸ਼ਕ੍ਨੁਮਃ| ਯੀਸ਼ੁਰੁਵਾਚ, ਤਰ੍ਹਿ ਯੇਨਾਦੇਸ਼ੇਨ ਕਰ੍ੰਮਾਣ੍ਯੇਤਾਨਿ ਕਰੋਮਿ, ਅਹਮਪਿ ਯੁਸ਼਼੍ਮਭ੍ਯੰ ਤੰਨ ਕਥਯਿਸ਼਼੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","ਅਨਨ੍ਤਰੰ ਯੀਸ਼ੁ ਰ੍ਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤੇਨ ਤੇਭ੍ਯਃ ਕਥਯਿਤੁਮਾਰੇਭੇ, ਕਸ਼੍ਚਿਦੇਕੋ ਦ੍ਰਾਕ੍ਸ਼਼ਾਕ੍ਸ਼਼ੇਤ੍ਰੰ ਵਿਧਾਯ ਤੱਚਤੁਰ੍ਦਿਕ੍ਸ਼਼ੁ ਵਾਰਣੀਂ ਕ੍ਰੁʼਤ੍ਵਾ ਤਨ੍ਮਧ੍ਯੇ ਦ੍ਰਾਕ੍ਸ਼਼ਾਪੇਸ਼਼ਣਕੁਣ੍ਡਮ੍ ਅਖਨਤ੍, ਤਥਾ ਤਸ੍ਯ ਗਡਮਪਿ ਨਿਰ੍ੰਮਿਤਵਾਨ੍ ਤਤਸ੍ਤਤ੍ਕ੍ਸ਼਼ੇਤ੍ਰੰ ਕ੍ਰੁʼਸ਼਼ੀਵਲੇਸ਼਼ੁ ਸਮਰ੍ਪ੍ਯ ਦੂਰਦੇਸ਼ੰ ਜਗਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","ਤਦਨਨ੍ਤਰੰ ਫਲਕਾਲੇ ਕ੍ਰੁʼਸ਼਼ੀਵਲੇਭ੍ਯੋ ਦ੍ਰਾਕ੍ਸ਼਼ਾਕ੍ਸ਼਼ੇਤ੍ਰਫਲਾਨਿ ਪ੍ਰਾਪ੍ਤੁੰ ਤੇਸ਼਼ਾਂ ਸਵਿਧੇ ਭ੍ਰੁʼਤ੍ਯਮ੍ ਏਕੰ ਪ੍ਰਾਹਿਣੋਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","ਕਿਨ੍ਤੁ ਕ੍ਰੁʼਸ਼਼ੀਵਲਾਸ੍ਤੰ ਧ੍ਰੁʼਤ੍ਵਾ ਪ੍ਰਹ੍ਰੁʼਤ੍ਯ ਰਿਕ੍ਤਹਸ੍ਤੰ ਵਿਸਸ੍ਰੁʼਜੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ਤਤਃ ਸ ਪੁਨਰਨ੍ਯਮੇਕੰ ਭ੍ਰੁʼਤ੍ਯੰ ਪ੍ਰਸ਼਼ਯਾਮਾਸ, ਕਿਨ੍ਤੁ ਤੇ ਕ੍ਰੁʼਸ਼਼ੀਵਲਾਃ ਪਾਸ਼਼ਾਣਾਘਾਤੈਸ੍ਤਸ੍ਯ ਸ਼ਿਰੋ ਭਙ੍ਕ੍ਤ੍ਵਾ ਸਾਪਮਾਨੰ ਤੰ ਵ੍ਯਸਰ੍ਜਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ਤਤਃ ਪਰੰ ਸੋਪਰੰ ਦਾਸੰ ਪ੍ਰਾਹਿਣੋਤ੍ ਤਦਾ ਤੇ ਤੰ ਜਘ੍ਨੁਃ, ਏਵਮ੍ ਅਨੇਕੇਸ਼਼ਾਂ ਕਸ੍ਯਚਿਤ੍ ਪ੍ਰਹਾਰਃ ਕਸ੍ਯਚਿਦ੍ ਵਧਸ਼੍ਚ ਤੈਃ ਕ੍ਰੁʼਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ਤਤਃ ਪਰੰ ਮਯਾ ਸ੍ਵਪੁਤ੍ਰੇ ਪ੍ਰਹਿਤੇ ਤੇ ਤਮਵਸ਼੍ਯੰ ਸੰਮੰਸ੍ਯਨ੍ਤੇ, ਇਤ੍ਯੁਕ੍ਤ੍ਵਾਵਸ਼ੇਸ਼਼ੇ ਤੇਸ਼਼ਾਂ ਸੰਨਿਧੌ ਨਿਜਪ੍ਰਿਯਮ੍ ਅਦ੍ਵਿਤੀਯੰ ਪੁਤ੍ਰੰ ਪ੍ਰੇਸ਼਼ਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","ਕਿਨ੍ਤੁ ਕ੍ਰੁʼਸ਼਼ੀਵਲਾਃ ਪਰਸ੍ਪਰੰ ਜਗਦੁਃ, ਏਸ਼਼ ਉੱਤਰਾਧਿਕਾਰੀ, ਆਗੱਛਤ ਵਯਮੇਨੰ ਹਨ੍ਮਸ੍ਤਥਾ ਕ੍ਰੁʼਤੇ (ਅ)ਧਿਕਾਰੋਯਮ੍ ਅਸ੍ਮਾਕੰ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ਤਤਸ੍ਤੰ ਧ੍ਰੁʼਤ੍ਵਾ ਹਤ੍ਵਾ ਦ੍ਰਾਕ੍ਸ਼਼ਾਕ੍ਸ਼਼ੇਤ੍ਰਾਦ੍ ਬਹਿਃ ਪ੍ਰਾਕ੍ਸ਼਼ਿਪਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","ਅਨੇਨਾਸੌ ਦ੍ਰਾਕ੍ਸ਼਼ਾਕ੍ਸ਼਼ੇਤ੍ਰਪਤਿਃ ਕਿੰ ਕਰਿਸ਼਼੍ਯਤਿ? ਸ ਏਤ੍ਯ ਤਾਨ੍ ਕ੍ਰੁʼਸ਼਼ੀਵਲਾਨ੍ ਸੰਹਤ੍ਯ ਤਤ੍ਕ੍ਸ਼਼ੇਤ੍ਰਮ੍ ਅਨ੍ਯੇਸ਼਼ੁ ਕ੍ਰੁʼਸ਼਼ੀਵਲੇਸ਼਼ੁ ਸਮਰ੍ਪਯਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","ਅਪਰਞ੍ਚ, \"ਸ੍ਥਪਤਯਃ ਕਰਿਸ਼਼੍ਯਨ੍ਤਿ ਗ੍ਰਾਵਾਣੰ ਯਨ੍ਤੁ ਤੁੱਛਕੰ| ਪ੍ਰਾਧਾਨਪ੍ਰਸ੍ਤਰਃ ਕੋਣੇ ਸ ਏਵ ਸੰਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ਏਤਤ੍ ਕਰ੍ੰਮ ਪਰੇਸ਼ਸ੍ਯਾਂਦ੍ਭੁਤੰ ਨੋ ਦ੍ਰੁʼਸ਼਼੍ਟਿਤੋ ਭਵੇਤ੍|| \" ਇਮਾਂ ਸ਼ਾਸ੍ਤ੍ਰੀਯਾਂ ਲਿਪਿੰ ਯੂਯੰ ਕਿੰ ਨਾਪਾਠਿਸ਼਼੍ਟ? ");
INSERT INTO sanpun_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ਤਦਾਨੀਂ ਸ ਤਾਨੁੱਦਿਸ਼੍ਯ ਤਾਂ ਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤਕਥਾਂ ਕਥਿਤਵਾਨ੍, ਤ ਇੱਥੰ ਬੁਦ੍ੱਵਾ ਤੰ ਧਰ੍ੱਤਾਮੁਦ੍ਯਤਾਃ, ਕਿਨ੍ਤੁ ਲੋਕੇਭ੍ਯੋ ਬਿਭ੍ਯੁਃ, ਤਦਨਨ੍ਤਰੰ ਤੇ ਤੰ ਵਿਹਾਯ ਵਵ੍ਰਜੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ਅਪਰਞ੍ਚ ਤੇ ਤਸ੍ਯ ਵਾਕ੍ਯਦੋਸ਼਼ੰ ਧਰ੍ੱਤਾਂ ਕਤਿਪਯਾਨ੍ ਫਿਰੂਸ਼ਿਨੋ ਹੇਰੋਦੀਯਾਂਸ਼੍ਚ ਲੋਕਾਨ੍ ਤਦਨ੍ਤਿਕੰ ਪ੍ਰੇਸ਼਼ਯਾਮਾਸੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ਤ ਆਗਤ੍ਯ ਤਮਵਦਨ੍, ਹੇ ਗੁਰੋ ਭਵਾਨ੍ ਤਥ੍ਯਭਾਸ਼਼ੀ ਕਸ੍ਯਾਪ੍ਯਨੁਰੋਧੰ ਨ ਮਨ੍ਯਤੇ, ਪਕ੍ਸ਼਼ਪਾਤਞ੍ਚ ਨ ਕਰੋਤਿ, ਯਥਾਰ੍ਥਤ ਈਸ਼੍ਵਰੀਯੰ ਮਾਰ੍ਗੰ ਦਰ੍ਸ਼ਯਤਿ ਵਯਮੇਤਤ੍ ਪ੍ਰਜਾਨੀਮਃ, ਕੈਸਰਾਯ ਕਰੋ ਦੇਯੋ ਨ ਵਾਂ? ਵਯੰ ਦਾਸ੍ਯਾਮੋ ਨ ਵਾ? ");
INSERT INTO sanpun_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","ਕਿਨ੍ਤੁ ਸ ਤੇਸ਼਼ਾਂ ਕਪਟੰ ਜ੍ਞਾਤ੍ਵਾ ਜਗਾਦ, ਕੁਤੋ ਮਾਂ ਪਰੀਕ੍ਸ਼਼ਧ੍ਵੇ? ਏਕੰ ਮੁਦ੍ਰਾਪਾਦੰ ਸਮਾਨੀਯ ਮਾਂ ਦਰ੍ਸ਼ਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ਤਦਾ ਤੈਰੇਕਸ੍ਮਿਨ੍ ਮੁਦ੍ਰਾਪਾਦੇ ਸਮਾਨੀਤੇ ਸ ਤਾਨ੍ ਪਪ੍ਰੱਛ, ਅਤ੍ਰ ਲਿਖਿਤੰ ਨਾਮ ਮੂਰ੍ੱਤਿ ਰ੍ਵਾ ਕਸ੍ਯ? ਤੇ ਪ੍ਰਤ੍ਯੂਚੁਃ, ਕੈਸਰਸ੍ਯ| ");
INSERT INTO sanpun_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","ਤਦਾ ਯੀਸ਼ੁਰਵਦਤ੍ ਤਰ੍ਹਿ ਕੈਸਰਸ੍ਯ ਦ੍ਰਵ੍ਯਾਣਿ ਕੈਸਰਾਯ ਦੱਤ, ਈਸ਼੍ਵਰਸ੍ਯ ਦ੍ਰਵ੍ਯਾਣਿ ਤੁ ਈਸ਼੍ਵਰਾਯ ਦੱਤ; ਤਤਸ੍ਤੇ ਵਿਸ੍ਮਯੰ ਮੇਨਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","ਅਥ ਮ੍ਰੁʼਤਾਨਾਮੁੱਥਾਨੰ ਯੇ ਨ ਮਨ੍ਯਨ੍ਤੇ ਤੇ ਸਿਦੂਕਿਨੋ ਯੀਸ਼ੋਃ ਸਮੀਪਮਾਗਤ੍ਯ ਤੰ ਪਪ੍ਰੱਛੁਃ; ");
INSERT INTO sanpun_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","ਹੇ ਗੁਰੋ ਕਸ਼੍ਚਿੱਜਨੋ ਯਦਿ ਨਿਃਸਨ੍ਤਤਿਃ ਸਨ੍ ਭਾਰ੍ੱਯਾਯਾਂ ਸਤ੍ਯਾਂ ਮ੍ਰਿਯਤੇ ਤਰ੍ਹਿ ਤਸ੍ਯ ਭ੍ਰਾਤਾ ਤਸ੍ਯ ਭਾਰ੍ੱਯਾਂ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਭ੍ਰਾਤੁ ਰ੍ਵੰਸ਼ੋਤ੍ਪੱਤਿੰ ਕਰਿਸ਼਼੍ਯਤਿ, ਵ੍ਯਵਸ੍ਥਾਮਿਮਾਂ ਮੂਸਾ ਅਸ੍ਮਾਨ੍ ਪ੍ਰਤਿ ਵ੍ਯਲਿਖਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ਕਿਨ੍ਤੁ ਕੇਚਿਤ੍ ਸਪ੍ਤ ਭ੍ਰਾਤਰ ਆਸਨ੍, ਤਤਸ੍ਤੇਸ਼਼ਾਂ ਜ੍ਯੇਸ਼਼੍ਠਭ੍ਰਾਤਾ ਵਿਵਹ੍ਯ ਨਿਃਸਨ੍ਤਤਿਃ ਸਨ੍ ਅਮ੍ਰਿਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ਤਤੋ ਦ੍ਵਿਤੀਯੋ ਭ੍ਰਾਤਾ ਤਾਂ ਸ੍ਤ੍ਰਿਯਮਗ੍ਰੁʼਹਣਤ੍ ਕਿਨ੍ਤੁ ਸੋਪਿ ਨਿਃਸਨ੍ਤਤਿਃ ਸਨ੍ ਅਮ੍ਰਿਯਤ; ਅਥ ਤ੍ਰੁʼਤੀਯੋਪਿ ਭ੍ਰਾਤਾ ਤਾਦ੍ਰੁʼਸ਼ੋਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ਇੱਥੰ ਸਪ੍ਤੈਵ ਭ੍ਰਾਤਰਸ੍ਤਾਂ ਸ੍ਤ੍ਰਿਯੰ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਨਿਃਸਨ੍ਤਾਨਾਃ ਸਨ੍ਤੋ(ਅ)ਮ੍ਰਿਯਨ੍ਤ, ਸਰ੍ੱਵਸ਼ੇਸ਼਼ੇ ਸਾਪਿ ਸ੍ਤ੍ਰੀ ਮ੍ਰਿਯਤੇ ਸ੍ਮ| ");
INSERT INTO sanpun_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ਅਥ ਮ੍ਰੁʼਤਾਨਾਮੁੱਥਾਨਕਾਲੇ ਯਦਾ ਤ ਉੱਥਾਸ੍ਯਨ੍ਤਿ ਤਦਾ ਤੇਸ਼਼ਾਂ ਕਸ੍ਯ ਭਾਰ੍ੱਯਾ ਸਾ ਭਵਿਸ਼਼੍ਯਤਿ? ਯਤਸ੍ਤੇ ਸਪ੍ਤੈਵ ਤਾਂ ਵ੍ਯਵਹਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ਤਤੋ ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯੁਵਾਚ ਸ਼ਾਸ੍ਤ੍ਰਮ੍ ਈਸ਼੍ਵਰਸ਼ਕ੍ਤਿਞ੍ਚ ਯੂਯਮਜ੍ਞਾਤ੍ਵਾ ਕਿਮਭ੍ਰਾਮ੍ਯਤ ਨ? ");
INSERT INTO sanpun_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","ਮ੍ਰੁʼਤਲੋਕਾਨਾਮੁੱਥਾਨੰ ਸਤਿ ਤੇ ਨ ਵਿਵਹਨ੍ਤਿ ਵਾਗ੍ਦੱਤਾ ਅਪਿ ਨ ਭਵਨ੍ਤਿ, ਕਿਨ੍ਤੁ ਸ੍ਵਰ੍ਗੀਯਦੂਤਾਨਾਂ ਸਦ੍ਰੁʼਸ਼ਾ ਭਵਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","ਪੁਨਸ਼੍ਚ \"ਅਹਮ੍ ਇਬ੍ਰਾਹੀਮ ਈਸ਼੍ਵਰ ਇਸ੍ਹਾਕ ਈਸ਼੍ਵਰੋ ਯਾਕੂਬਸ਼੍ਚੇਸ਼੍ਵਰਃ\" ਯਾਮਿਮਾਂ ਕਥਾਂ ਸ੍ਤਮ੍ਬਮਧ੍ਯੇ ਤਿਸ਼਼੍ਠਨ੍ ਈਸ਼੍ਵਰੋ ਮੂਸਾਮਵਾਦੀਤ੍ ਮ੍ਰੁʼਤਾਨਾਮੁੱਥਾਨਾਰ੍ਥੇ ਸਾ ਕਥਾ ਮੂਸਾਲਿਖਿਤੇ ਪੁਸ੍ਤਕੇ ਕਿੰ ਯੁਸ਼਼੍ਮਾਭਿ ਰ੍ਨਾਪਾਠਿ? ");
INSERT INTO sanpun_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ਈਸ਼੍ਵਰੋ ਜੀਵਤਾਂ ਪ੍ਰਭੁਃ ਕਿਨ੍ਤੁ ਮ੍ਰੁʼਤਾਨਾਂ ਪ੍ਰਭੁ ਰ੍ਨ ਭਵਤਿ, ਤਸ੍ਮਾੱਧੇਤੋ ਰ੍ਯੂਯੰ ਮਹਾਭ੍ਰਮੇਣ ਤਿਸ਼਼੍ਠਥ| ");
INSERT INTO sanpun_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ਏਤਰ੍ਹਿ ਏਕੋਧ੍ਯਾਪਕ ਏਤ੍ਯ ਤੇਸ਼਼ਾਮਿੱਥੰ ਵਿਚਾਰੰ ਸ਼ੁਸ਼੍ਰਾਵ; ਯੀਸ਼ੁਸ੍ਤੇਸ਼਼ਾਂ ਵਾਕ੍ਯਸ੍ਯ ਸਦੁੱਤਰੰ ਦੱਤਵਾਨ੍ ਇਤਿ ਬੁਦ੍ੱਵਾ ਤੰ ਪ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍ ਸਰ੍ੱਵਾਸਾਮ੍ ਆਜ੍ਞਾਨਾਂ ਕਾ ਸ਼੍ਰੇਸ਼਼੍ਠਾ? ਤਤੋ ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯੁਵਾਚ, ");
INSERT INTO sanpun_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","\"ਹੇ ਇਸ੍ਰਾਯੇੱਲੋਕਾ ਅਵਧੱਤ, ਅਸ੍ਮਾਕੰ ਪ੍ਰਭੁਃ ਪਰਮੇਸ਼੍ਵਰ ਏਕ ਏਵ, ");
INSERT INTO sanpun_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ਯੂਯੰ ਸਰ੍ੱਵਨ੍ਤਃਕਰਣੈਃ ਸਰ੍ੱਵਪ੍ਰਾਣੈਃ ਸਰ੍ੱਵਚਿੱਤੈਃ ਸਰ੍ੱਵਸ਼ਕ੍ਤਿਭਿਸ਼੍ਚ ਤਸ੍ਮਿਨ੍ ਪ੍ਰਭੌ ਪਰਮੇਸ਼੍ਵਰੇ ਪ੍ਰੀਯਧ੍ਵੰ,\" ਇਤ੍ਯਾਜ੍ਞਾ ਸ਼੍ਰੇਸ਼਼੍ਠਾ| ");
INSERT INTO sanpun_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ਤਥਾ \"ਸ੍ਵਪ੍ਰਤਿਵਾਸਿਨਿ ਸ੍ਵਵਤ੍ ਪ੍ਰੇਮ ਕੁਰੁਧ੍ਵੰ,\" ਏਸ਼਼ਾ ਯਾ ਦ੍ਵਿਤੀਯਾਜ੍ਞਾ ਸਾ ਤਾਦ੍ਰੁʼਸ਼ੀ; ਏਤਾਭ੍ਯਾਂ ਦ੍ਵਾਭ੍ਯਾਮ੍ ਆਜ੍ਞਾਭ੍ਯਾਮ੍ ਅਨ੍ਯਾ ਕਾਪ੍ਯਾਜ੍ਞਾ ਸ਼੍ਰੇਸ਼਼੍ਠਾ ਨਾਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ਤਦਾ ਸੋਧ੍ਯਾਪਕਸ੍ਤਮਵਦਤ੍, ਹੇ ਗੁਰੋ ਸਤ੍ਯੰ ਭਵਾਨ੍ ਯਥਾਰ੍ਥੰ ਪ੍ਰੋਕ੍ਤਵਾਨ੍ ਯਤ ਏਕਸ੍ਮਾਦ੍ ਈਸ਼੍ਵਰਾਦ੍ ਅਨ੍ਯੋ ਦ੍ਵਿਤੀਯ ਈਸ਼੍ਵਰੋ ਨਾਸ੍ਤਿ; ");
INSERT INTO sanpun_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ਅਪਰੰ ਸਰ੍ੱਵਾਨ੍ਤਃਕਰਣੈਃ ਸਰ੍ੱਵਪ੍ਰਾਣੈਃ ਸਰ੍ੱਵਚਿੱਤੈਃ ਸਰ੍ੱਵਸ਼ਕ੍ਤਿਭਿਸ਼੍ਚ ਈਸ਼੍ਵਰੇ ਪ੍ਰੇਮਕਰਣੰ ਤਥਾ ਸ੍ਵਮੀਪਵਾਸਿਨਿ ਸ੍ਵਵਤ੍ ਪ੍ਰੇਮਕਰਣਞ੍ਚ ਸਰ੍ੱਵੇਭ੍ਯੋ ਹੋਮਬਲਿਦਾਨਾਦਿਭ੍ਯਃ ਸ਼੍ਰਸ਼਼੍ਠੰ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","ਤਤੋ ਯੀਸ਼ੁਃ ਸੁਬੁੱਧੇਰਿਵ ਤਸ੍ਯੇਦਮ੍ ਉੱਤਰੰ ਸ਼੍ਰੁਤ੍ਵਾ ਤੰ ਭਾਸ਼਼ਿਤਵਾਨ੍ ਤ੍ਵਮੀਸ਼੍ਵਰਸ੍ਯ ਰਾਜ੍ਯਾੰਨ ਦੂਰੋਸਿ| ਇਤਃ ਪਰੰ ਤੇਨ ਸਹ ਕਸ੍ਯਾਪਿ ਵਾਕ੍ਯਸ੍ਯ ਵਿਚਾਰੰ ਕਰ੍ੱਤਾਂ ਕਸ੍ਯਾਪਿ ਪ੍ਰਗਲ੍ਭਤਾ ਨ ਜਾਤਾ| ");
INSERT INTO sanpun_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","ਅਨਨ੍ਤਰੰ ਮਧ੍ਯੇਮਨ੍ਦਿਰਮ੍ ਉਪਦਿਸ਼ਨ੍ ਯੀਸ਼ੁਰਿਮੰ ਪ੍ਰਸ਼੍ਨੰ ਚਕਾਰ, ਅਧ੍ਯਾਪਕਾ ਅਭਿਸ਼਼ਿਕ੍ਤੰ (ਤਾਰਕੰ) ਕੁਤੋ ਦਾਯੂਦਃ ਸਨ੍ਤਾਨੰ ਵਦਨ੍ਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ਸ੍ਵਯੰ ਦਾਯੂਦ੍ ਪਵਿਤ੍ਰਸ੍ਯਾਤ੍ਮਨ ਆਵੇਸ਼ੇਨੇਦੰ ਕਥਯਾਮਾਸ| ਯਥਾ| \"ਮਮ ਪ੍ਰਭੁਮਿਦੰ ਵਾਕ੍ਯਵਦਤ੍ ਪਰਮੇਸ਼੍ਵਰਃ| ਤਵ ਸ਼ਤ੍ਰੂਨਹੰ ਯਾਵਤ੍ ਪਾਦਪੀਠੰ ਕਰੋਮਿ ਨ| ਤਾਵਤ੍ ਕਾਲੰ ਮਦੀਯੇ ਤ੍ਵੰ ਦਕ੍ਸ਼਼ਪਾਰ੍ਸ਼੍ਵ੍ ਉਪਾਵਿਸ਼| \" ");
INSERT INTO sanpun_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","ਯਦਿ ਦਾਯੂਦ੍ ਤੰ ਪ੍ਰਭੂੰ ਵਦਤਿ ਤਰ੍ਹਿ ਕਥੰ ਸ ਤਸ੍ਯ ਸਨ੍ਤਾਨੋ ਭਵਿਤੁਮਰ੍ਹਤਿ? ਇਤਰੇ ਲੋਕਾਸ੍ਤਤ੍ਕਥਾਂ ਸ਼੍ਰੁਤ੍ਵਾਨਨਨ੍ਦੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","ਤਦਾਨੀਂ ਸ ਤਾਨੁਪਦਿਸ਼੍ਯ ਕਥਿਤਵਾਨ੍ ਯੇ ਨਰਾ ਦੀਰ੍ਘਪਰਿਧੇਯਾਨਿ ਹੱਟੇ ਵਿਪਨੌ ਚ ");
INSERT INTO sanpun_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ਲੋਕਕ੍ਰੁʼਤਨਮਸ੍ਕਾਰਾਨ੍ ਭਜਨਗ੍ਰੁʼਹੇ ਪ੍ਰਧਾਨਾਸਨਾਨਿ ਭੋਜਨਕਾਲੇ ਪ੍ਰਧਾਨਸ੍ਥਾਨਾਨਿ ਚ ਕਾਙ੍ਕ੍ਸ਼਼ਨ੍ਤੇ; ");
INSERT INTO sanpun_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ਵਿਧਵਾਨਾਂ ਸਰ੍ੱਵਸ੍ਵੰ ਗ੍ਰਸਿਤ੍ਵਾ ਛਲਾਦ੍ ਦੀਰ੍ਘਕਾਲੰ ਪ੍ਰਾਰ੍ਥਯਨ੍ਤੇ ਤੇਭ੍ਯ ਉਪਾਧ੍ਯਾਯੇਭ੍ਯਃ ਸਾਵਧਾਨਾ ਭਵਤ; ਤੇ(ਅ)ਧਿਕਤਰਾਨ੍ ਦਣ੍ਡਾਨ੍ ਪ੍ਰਾਪ੍ਸ੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","ਤਦਨਨ੍ਤਰੰ ਲੋਕਾ ਭਾਣ੍ਡਾਗਾਰੇ ਮੁਦ੍ਰਾ ਯਥਾ ਨਿਕ੍ਸ਼਼ਿਪਨ੍ਤਿ ਭਾਣ੍ਡਾਗਾਰਸ੍ਯ ਸੰਮੁਖੇ ਸਮੁਪਵਿਸ਼੍ਯ ਯੀਸ਼ੁਸ੍ਤਦਵਲੁਲੋਕ; ਤਦਾਨੀਂ ਬਹਵੋ ਧਨਿਨਸ੍ਤਸ੍ਯ ਮਧ੍ਯੇ ਬਹੂਨਿ ਧਨਾਨਿ ਨਿਰਕ੍ਸ਼਼ਿਪਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ਪਸ਼੍ਚਾਦ੍ ਏਕਾ ਦਰਿਦ੍ਰਾ ਵਿਧਵਾ ਸਮਾਗਤ੍ਯ ਦ੍ਵਿਪਣਮੂਲ੍ਯਾਂ ਮੁਦ੍ਰੈਕਾਂ ਤਤ੍ਰ ਨਿਰਕ੍ਸ਼਼ਿਪਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ਤਦਾ ਯੀਸ਼ੁਃ ਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਆਹੂਯ ਕਥਿਤਵਾਨ੍ ਯੁਸ਼਼੍ਮਾਨਹੰ ਯਥਾਰ੍ਥੰ ਵਦਾਮਿ ਯੇ ਯੇ ਭਾਣ੍ਡਾਗਾਰੇ(ਅ)ਸ੍ਮਿਨ ਧਨਾਨਿ ਨਿਃਕ੍ਸ਼਼ਿਪਨ੍ਤਿ ਸ੍ਮ ਤੇਭ੍ਯਃ ਸਰ੍ੱਵੇਭ੍ਯ ਇਯੰ ਵਿਧਵਾ ਦਰਿਦ੍ਰਾਧਿਕਮ੍ ਨਿਃਕ੍ਸ਼਼ਿਪਤਿ ਸ੍ਮ| ");
INSERT INTO sanpun_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ਯਤਸ੍ਤੇ ਪ੍ਰਭੂਤਧਨਸ੍ਯ ਕਿਞ੍ਚਿਤ੍ ਨਿਰਕ੍ਸ਼਼ਿਪਨ੍ ਕਿਨ੍ਤੁ ਦੀਨੇਯੰ ਸ੍ਵਦਿਨਯਾਪਨਯੋਗ੍ਯੰ ਕਿਞ੍ਚਿਦਪਿ ਨ ਸ੍ਥਾਪਯਿਤ੍ਵਾ ਸਰ੍ੱਵਸ੍ਵੰ ਨਿਰਕ੍ਸ਼਼ਿਪਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","ਅਨਨ੍ਤਰੰ ਮਨ੍ਦਿਰਾਦ੍ ਬਹਿਰ੍ਗਮਨਕਾਲੇ ਤਸ੍ਯ ਸ਼ਿਸ਼਼੍ਯਾਣਾਮੇਕਸ੍ਤੰ ਵ੍ਯਾਹ੍ਰੁʼਤਵਾਨ੍ ਹੇ ਗੁਰੋ ਪਸ਼੍ਯਤੁ ਕੀਦ੍ਰੁʼਸ਼ਾਃ ਪਾਸ਼਼ਾਣਾਃ ਕੀਦ੍ਰੁʼਕ੍ ਚ ਨਿਚਯਨੰ| ");
INSERT INTO sanpun_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","ਤਦਾ ਯੀਸ਼ੁਸ੍ਤਮ੍ ਅਵਦਤ੍ ਤ੍ਵੰ ਕਿਮੇਤਦ੍ ਬ੍ਰੁʼਹੰਨਿਚਯਨੰ ਪਸ਼੍ਯਸਿ? ਅਸ੍ਯੈਕਪਾਸ਼਼ਾਣੋਪਿ ਦ੍ਵਿਤੀਯਪਾਸ਼਼ਾਣੋਪਰਿ ਨ ਸ੍ਥਾਸ੍ਯਤਿ ਸਰ੍ੱਵੇ (ਅ)ਧਃਕ੍ਸ਼਼ੇਪ੍ਸ੍ਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","ਅਥ ਯਸ੍ਮਿਨ੍ ਕਾਲੇ ਜੈਤੁਨ੍ਗਿਰੌ ਮਨ੍ਦਿਰਸ੍ਯ ਸੰਮੁਖੇ ਸ ਸਮੁਪਵਿਸ਼਼੍ਟਸ੍ਤਸ੍ਮਿਨ੍ ਕਾਲੇ ਪਿਤਰੋ ਯਾਕੂਬ੍ ਯੋਹਨ੍ ਆਨ੍ਦ੍ਰਿਯਸ਼੍ਚੈਤੇ ਤੰ ਰਹਸਿ ਪਪ੍ਰੱਛੁਃ, ");
INSERT INTO sanpun_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","ਏਤਾ ਘਟਨਾਃ ਕਦਾ ਭਵਿਸ਼਼੍ਯਨ੍ਤਿ? ਤਥੈਤਤ੍ਸਰ੍ੱਵਾਸਾਂ ਸਿੱਧ੍ਯੁਪਕ੍ਰਮਸ੍ਯ ਵਾ ਕਿੰ ਚਿਹ੍ਨੰ? ਤਦਸ੍ਮਭ੍ਯੰ ਕਥਯਤੁ ਭਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ਤਤੋ ਯਾਸ਼ੁਸ੍ਤਾਨ੍ ਵਕ੍ਤੁਮਾਰੇਭੇ, ਕੋਪਿ ਯਥਾ ਯੁਸ਼਼੍ਮਾਨ੍ ਨ ਭ੍ਰਾਮਯਤਿ ਤਥਾਤ੍ਰ ਯੂਯੰ ਸਾਵਧਾਨਾ ਭਵਤ| ");
INSERT INTO sanpun_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ਯਤਃ ਖ੍ਰੀਸ਼਼੍ਟੋਹਮਿਤਿ ਕਥਯਿਤ੍ਵਾ ਮਮ ਨਾਮ੍ਨਾਨੇਕੇ ਸਮਾਗਤ੍ਯ ਲੋਕਾਨਾਂ ਭ੍ਰਮੰ ਜਨਯਿਸ਼਼੍ਯਨ੍ਤਿ; ");
INSERT INTO sanpun_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","ਕਿਨ੍ਤੁ ਯੂਯੰ ਰਣਸ੍ਯ ਵਾਰ੍ੱਤਾਂ ਰਣਾਡਮ੍ਬਰਞ੍ਚ ਸ਼੍ਰੁਤ੍ਵਾ ਮਾ ਵ੍ਯਾਕੁਲਾ ਭਵਤ, ਘਟਨਾ ਏਤਾ ਅਵਸ਼੍ਯੰਮਾਵਿਨ੍ਯਃ; ਕਿਨ੍ਤ੍ਵਾਪਾਤਤੋ ਨ ਯੁਗਾਨ੍ਤੋ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","ਦੇਸ਼ਸ੍ਯ ਵਿਪਕ੍ਸ਼਼ਤਯਾ ਦੇਸ਼ੋ ਰਾਜ੍ਯਸ੍ਯ ਵਿਪਕ੍ਸ਼਼ਤਯਾ ਚ ਰਾਜ੍ਯਮੁੱਥਾਸ੍ਯਤਿ, ਤਥਾ ਸ੍ਥਾਨੇ ਸ੍ਥਾਨੇ ਭੂਮਿਕਮ੍ਪੋ ਦੁਰ੍ਭਿਕ੍ਸ਼਼ੰ ਮਹਾਕ੍ਲੇਸ਼ਾਸ਼੍ਚ ਸਮੁਪਸ੍ਥਾਸ੍ਯਨ੍ਤਿ, ਸਰ੍ੱਵ ਏਤੇ ਦੁਃਖਸ੍ਯਾਰਮ੍ਭਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","ਕਿਨ੍ਤੁ ਯੂਯਮ੍ ਆਤ੍ਮਾਰ੍ਥੇ ਸਾਵਧਾਨਾਸ੍ਤਿਸ਼਼੍ਠਤ, ਯਤੋ ਲੋਕਾ ਰਾਜਸਭਾਯਾਂ ਯੁਸ਼਼੍ਮਾਨ੍ ਸਮਰ੍ਪਯਿਸ਼਼੍ਯਨ੍ਤਿ, ਤਥਾ ਭਜਨਗ੍ਰੁʼਹੇ ਪ੍ਰਹਰਿਸ਼਼੍ਯਨ੍ਤਿ; ਯੂਯੰ ਮਦਰ੍ਥੇ ਦੇਸ਼ਾਧਿਪਾਨ੍ ਭੂਪਾਂਸ਼੍ਚ ਪ੍ਰਤਿ ਸਾਕ੍ਸ਼਼੍ਯਦਾਨਾਯ ਤੇਸ਼਼ਾਂ ਸੰਮੁਖੇ ਉਪਸ੍ਥਾਪਯਿਸ਼਼੍ਯਧ੍ਵੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ਸ਼ੇਸ਼਼ੀਭਵਨਾਤ੍ ਪੂਰ੍ੱਵੰ ਸਰ੍ੱਵਾਨ੍ ਦੇਸ਼ੀਯਾਨ੍ ਪ੍ਰਤਿ ਸੁਸੰਵਾਦਃ ਪ੍ਰਚਾਰਯਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","ਕਿਨ੍ਤੁ ਯਦਾ ਤੇ ਯੁਸ਼਼੍ਮਾਨ੍ ਧ੍ਰੁʼਤ੍ਵਾ ਸਮਰ੍ਪਯਿਸ਼਼੍ਯਨ੍ਤਿ ਤਦਾ ਯੂਯੰ ਯਦ੍ਯਦ੍ ਉੱਤਰੰ ਦਾਸ੍ਯਥ, ਤਦਗ੍ਰ ਤਸ੍ਯ ਵਿਵੇਚਨੰ ਮਾ ਕੁਰੁਤ ਤਦਰ੍ਥੰ ਕਿਞ੍ਚਿਦਪਿ ਮਾ ਚਿਨ੍ਤਯਤ ਚ, ਤਦਾਨੀਂ ਯੁਸ਼਼੍ਮਾਕੰ ਮਨਃਸੁ ਯਦ੍ਯਦ੍ ਵਾਕ੍ਯਮ੍ ਉਪਸ੍ਥਾਪਯਿਸ਼਼੍ਯਤੇ ਤਦੇਵ ਵਦਿਸ਼਼੍ਯਥ, ਯਤੋ ਯੂਯੰ ਨ ਤਦ੍ਵਕ੍ਤਾਰਃ ਕਿਨ੍ਤੁ ਪਵਿਤ੍ਰ ਆਤ੍ਮਾ ਤਸ੍ਯ ਵਕ੍ਤਾ| ");
INSERT INTO sanpun_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","ਤਦਾ ਭ੍ਰਾਤਾ ਭ੍ਰਾਤਰੰ ਪਿਤਾ ਪੁਤ੍ਰੰ ਘਾਤਨਾਰ੍ਥੰ ਪਰਹਸ੍ਤੇਸ਼਼ੁ ਸਮਰ੍ਪਯਿਸ਼਼੍ਯਤੇ, ਤਥਾ ਪਤ੍ਯਾਨਿ ਮਾਤਾਪਿਤ੍ਰੋ ਰ੍ਵਿਪਕ੍ਸ਼਼ਤਯਾ ਤੌ ਘਾਤਯਿਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","ਮਮ ਨਾਮਹੇਤੋਃ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਸਵਿਧੇ ਯੂਯੰ ਜੁਗੁਪ੍ਸਿਤਾ ਭਵਿਸ਼਼੍ਯਥ, ਕਿਨ੍ਤੁ ਯਃ ਕਸ਼੍ਚਿਤ੍ ਸ਼ੇਸ਼਼ਪਰ੍ੱਯਨ੍ਤੰ ਧੈਰ੍ੱਯਮ੍ ਆਲਮ੍ਬਿਸ਼਼੍ਯਤੇ ਸਏਵ ਪਰਿਤ੍ਰਾਸ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","ਦਾਨਿਯੇਲ੍ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਾ ਪ੍ਰੋਕ੍ਤੰ ਸਰ੍ੱਵਨਾਸ਼ਿ ਜੁਗੁਪ੍ਸਿਤਞ੍ਚ ਵਸ੍ਤੁ ਯਦਾ ਤ੍ਵਯੋਗ੍ਯਸ੍ਥਾਨੇ ਵਿਦ੍ਯਮਾਨੰ ਦ੍ਰਕ੍ਸ਼਼ਥ (ਯੋ ਜਨਃ ਪਠਤਿ ਸ ਬੁਧ੍ਯਤਾਂ) ਤਦਾ ਯੇ ਯਿਹੂਦੀਯਦੇਸ਼ੇ ਤਿਸ਼਼੍ਠਨ੍ਤਿ ਤੇ ਮਹੀਧ੍ਰੰ ਪ੍ਰਤਿ ਪਲਾਯਨ੍ਤਾਂ; ");
INSERT INTO sanpun_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ਤਥਾ ਯੋ ਨਰੋ ਗ੍ਰੁʼਹੋਪਰਿ ਤਿਸ਼਼੍ਠਤਿ ਸ ਗ੍ਰੁʼਹਮਧ੍ਯੰ ਨਾਵਰੋਹਤੁ, ਤਥਾ ਕਿਮਪਿ ਵਸ੍ਤੁ ਗ੍ਰਹੀਤੁੰ ਮਧ੍ਯੇਗ੍ਰੁʼਹੰ ਨ ਪ੍ਰਵਿਸ਼ਤੁ; ");
INSERT INTO sanpun_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ਤਥਾ ਚ ਯੋ ਨਰਃ ਕ੍ਸ਼਼ੇਤ੍ਰੇ ਤਿਸ਼਼੍ਠਤਿ ਸੋਪਿ ਸ੍ਵਵਸ੍ਤ੍ਰੰ ਗ੍ਰਹੀਤੁੰ ਪਰਾਵ੍ਰੁʼਤ੍ਯ ਨ ਵ੍ਰਜਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ਤਦਾਨੀਂ ਗਰ੍ੱਭਵਤੀਨਾਂ ਸ੍ਤਨ੍ਯਦਾਤ੍ਰੀਣਾਞ੍ਚ ਯੋਸ਼਼ਿਤਾਂ ਦੁਰ੍ਗਤਿ ਰ੍ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ਯੁਸ਼਼੍ਮਾਕੰ ਪਲਾਯਨੰ ਸ਼ੀਤਕਾਲੇ ਯਥਾ ਨ ਭਵਤਿ ਤਦਰ੍ਥੰ ਪ੍ਰਾਰ੍ਥਯਧ੍ਵੰ| ");
INSERT INTO sanpun_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ਯਤਸ੍ਤਦਾ ਯਾਦ੍ਰੁʼਸ਼ੀ ਦੁਰ੍ਘਟਨਾ ਘਟਿਸ਼਼੍ਯਤੇ ਤਾਦ੍ਰੁʼਸ਼ੀ ਦੁਰ੍ਘਟਨਾ ਈਸ਼੍ਵਰਸ੍ਰੁʼਸ਼਼੍ਟੇਃ ਪ੍ਰਥਮਮਾਰਭ੍ਯਾਦ੍ਯ ਯਾਵਤ੍ ਕਦਾਪਿ ਨ ਜਾਤਾ ਨ ਜਨਿਸ਼਼੍ਯਤੇ ਚ| ");
INSERT INTO sanpun_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","ਅਪਰਞ੍ਚ ਪਰਮੇਸ਼੍ਵਰੋ ਯਦਿ ਤਸ੍ਯ ਸਮਯਸ੍ਯ ਸੰਕ੍ਸ਼਼ੇਪੰ ਨ ਕਰੋਤਿ ਤਰ੍ਹਿ ਕਸ੍ਯਾਪਿ ਪ੍ਰਾਣਭ੍ਰੁʼਤੋ ਰਕ੍ਸ਼਼ਾ ਭਵਿਤੁੰ ਨ ਸ਼ਕ੍ਸ਼਼੍ਯਤਿ, ਕਿਨ੍ਤੁ ਯਾਨ੍ ਜਨਾਨ੍ ਮਨੋਨੀਤਾਨ੍ ਅਕਰੋਤ੍ ਤੇਸ਼਼ਾਂ ਸ੍ਵਮਨੋਨੀਤਾਨਾਂ ਹੇਤੋਃ ਸ ਤਦਨੇਹਸੰ ਸੰਕ੍ਸ਼਼ੇਪ੍ਸ੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","ਅਨ੍ਯੱਚ ਪਸ਼੍ਯਤ ਖ੍ਰੀਸ਼਼੍ਟੋਤ੍ਰ ਸ੍ਥਾਨੇ ਵਾ ਤਤ੍ਰ ਸ੍ਥਾਨੇ ਵਿਦ੍ਯਤੇ, ਤਸ੍ਮਿਨ੍ਕਾਲੇ ਯਦਿ ਕਸ਼੍ਚਿਦ੍ ਯੁਸ਼਼੍ਮਾਨ੍ ਏਤਾਦ੍ਰੁʼਸ਼ੰ ਵਾਕ੍ਯੰ ਵ੍ਯਾਹਰਤਿ, ਤਰ੍ਹਿ ਤਸ੍ਮਿਨ੍ ਵਾਕ੍ਯੇ ਭੈਵ ਵਿਸ਼੍ਵਸਿਤ| ");
INSERT INTO sanpun_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ਯਤੋਨੇਕੇ ਮਿਥ੍ਯਾਖ੍ਰੀਸ਼਼੍ਟਾ ਮਿਥ੍ਯਾਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਸ਼੍ਚ ਸਮੁਪਸ੍ਥਾਯ ਬਹੂਨਿ ਚਿਹ੍ਨਾਨ੍ਯਦ੍ਭੁਤਾਨਿ ਕਰ੍ੰਮਾਣਿ ਚ ਦਰ੍ਸ਼ਯਿਸ਼਼੍ਯਨ੍ਤਿ; ਤਥਾ ਯਦਿ ਸਮ੍ਭਵਤਿ ਤਰ੍ਹਿ ਮਨੋਨੀਤਲੋਕਾਨਾਮਪਿ ਮਿਥ੍ਯਾਮਤਿੰ ਜਨਯਿਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","ਪਸ਼੍ਯਤ ਘਟਨਾਤਃ ਪੂਰ੍ੱਵੰ ਸਰ੍ੱਵਕਾਰ੍ੱਯਸ੍ਯ ਵਾਰ੍ੱਤਾਂ ਯੁਸ਼਼੍ਮਭ੍ਯਮਦਾਮ੍, ਯੂਯੰ ਸਾਵਧਾਨਾਸ੍ਤਿਸ਼਼੍ਠਤ| ");
INSERT INTO sanpun_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","ਅਪਰਞ੍ਚ ਤਸ੍ਯ ਕ੍ਲੇਸ਼ਕਾਲਸ੍ਯਾਵ੍ਯਵਹਿਤੇ ਪਰਕਾਲੇ ਭਾਸ੍ਕਰਃ ਸਾਨ੍ਧਕਾਰੋ ਭਵਿਸ਼਼੍ਯਤਿ ਤਥੈਵ ਚਨ੍ਦ੍ਰਸ਼੍ਚਨ੍ਦ੍ਰਿਕਾਂ ਨ ਦਾਸ੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ਨਭਃਸ੍ਥਾਨਿ ਨਕ੍ਸ਼਼ਤ੍ਰਾਣਿ ਪਤਿਸ਼਼੍ਯਨ੍ਤਿ, ਵ੍ਯੋਮਮਣ੍ਡਲਸ੍ਥਾ ਗ੍ਰਹਾਸ਼੍ਚ ਵਿਚਲਿਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","ਤਦਾਨੀਂ ਮਹਾਪਰਾਕ੍ਰਮੇਣ ਮਹੈਸ਼੍ਵਰ੍ੱਯੇਣ ਚ ਮੇਘਮਾਰੁਹ੍ਯ ਸਮਾਯਾਨ੍ਤੰ ਮਾਨਵਸੁਤੰ ਮਾਨਵਾਃ ਸਮੀਕ੍ਸ਼਼ਿਸ਼਼੍ਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ਅਨ੍ਯੱਚ ਸ ਨਿਜਦੂਤਾਨ੍ ਪ੍ਰਹਿਤ੍ਯ ਨਭੋਭੂਮ੍ਯੋਃ ਸੀਮਾਂ ਯਾਵਦ੍ ਜਗਤਸ਼੍ਚਤੁਰ੍ਦਿਗ੍ਭ੍ਯਃ ਸ੍ਵਮਨੋਨੀਤਲੋਕਾਨ੍ ਸੰਗ੍ਰਹੀਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","ਉਡੁਮ੍ਬਰਤਰੋ ਰ੍ਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤੰ ਸ਼ਿਕ੍ਸ਼਼ਧ੍ਵੰ ਯਦੋਡੁਮ੍ਬਰਸ੍ਯ ਤਰੋ ਰ੍ਨਵੀਨਾਃ ਸ਼ਾਖਾ ਜਾਯਨ੍ਤੇ ਪੱਲਵਾਦੀਨਿ ਚ ਰ੍ਨਿਗੱਛਨ੍ਤਿ, ਤਦਾ ਨਿਦਾਘਕਾਲਃ ਸਵਿਧੋ ਭਵਤੀਤਿ ਯੂਯੰ ਜ੍ਞਾਤੁੰ ਸ਼ਕ੍ਨੁਥ| ");
INSERT INTO sanpun_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ਤਦ੍ਵਦ੍ ਏਤਾ ਘਟਨਾ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਸ ਕਾਲੋ ਦ੍ਵਾਰ੍ੱਯੁਪਸ੍ਥਿਤ ਇਤਿ ਜਾਨੀਤ| ");
INSERT INTO sanpun_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ਯੁਸ਼਼੍ਮਾਨਹੰ ਯਥਾਰ੍ਥੰ ਵਦਾਮਿ, ਆਧੁਨਿਕਲੋਕਾਨਾਂ ਗਮਨਾਤ੍ ਪੂਰ੍ੱਵੰ ਤਾਨਿ ਸਰ੍ੱਵਾਣਿ ਘਟਿਸ਼਼੍ਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ਦ੍ਯਾਵਾਪ੍ਰੁʼਥਿਵ੍ਯੋ ਰ੍ਵਿਚਲਿਤਯੋਃ ਸਤ੍ਯੋ ਰ੍ਮਦੀਯਾ ਵਾਣੀ ਨ ਵਿਚਲਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","ਅਪਰਞ੍ਚ ਸ੍ਵਰ੍ਗਸ੍ਥਦੂਤਗਣੋ ਵਾ ਪੁਤ੍ਰੋ ਵਾ ਤਾਤਾਦਨ੍ਯਃ ਕੋਪਿ ਤੰ ਦਿਵਸੰ ਤੰ ਦਣ੍ਡੰ ਵਾ ਨ ਜ੍ਞਾਪਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ਅਤਃ ਸ ਸਮਯਃ ਕਦਾ ਭਵਿਸ਼਼੍ਯਤਿ, ਏਤੱਜ੍ਞਾਨਾਭਾਵਾਦ੍ ਯੂਯੰ ਸਾਵਧਾਨਾਸ੍ਤਿਸ਼਼੍ਠਤ, ਸਤਰ੍ਕਾਸ਼੍ਚ ਭੂਤ੍ਵਾ ਪ੍ਰਾਰ੍ਥਯਧ੍ਵੰ; ");
INSERT INTO sanpun_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ਯਦ੍ਵਤ੍ ਕਸ਼੍ਚਿਤ੍ ਪੁਮਾਨ੍ ਸ੍ਵਨਿਵੇਸ਼ਨਾਦ੍ ਦੂਰਦੇਸ਼ੰ ਪ੍ਰਤਿ ਯਾਤ੍ਰਾਕਰਣਕਾਲੇ ਦਾਸੇਸ਼਼ੁ ਸ੍ਵਕਾਰ੍ੱਯਸ੍ਯ ਭਾਰਮਰ੍ਪਯਿਤ੍ਵਾ ਸਰ੍ੱਵਾਨ੍ ਸ੍ਵੇ ਸ੍ਵੇ ਕਰ੍ੰਮਣਿ ਨਿਯੋਜਯਤਿ; ਅਪਰੰ ਦੌਵਾਰਿਕੰ ਜਾਗਰਿਤੁੰ ਸਮਾਦਿਸ਼੍ਯ ਯਾਤਿ, ਤਦ੍ਵਨ੍ ਨਰਪੁਤ੍ਰਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","ਗ੍ਰੁʼਹਪਤਿਃ ਸਾਯੰਕਾਲੇ ਨਿਸ਼ੀਥੇ ਵਾ ਤ੍ਰੁʼਤੀਯਯਾਮੇ ਵਾ ਪ੍ਰਾਤਃਕਾਲੇ ਵਾ ਕਦਾਗਮਿਸ਼਼੍ਯਤਿ ਤਦ੍ ਯੂਯੰ ਨ ਜਾਨੀਥ; ");
INSERT INTO sanpun_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ਸ ਹਠਾਦਾਗਤ੍ਯ ਯਥਾ ਯੁਸ਼਼੍ਮਾਨ੍ ਨਿਦ੍ਰਿਤਾਨ੍ ਨ ਪਸ਼੍ਯਤਿ, ਤਦਰ੍ਥੰ ਜਾਗਰਿਤਾਸ੍ਤਿਸ਼਼੍ਠਤ| ");
INSERT INTO sanpun_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","ਯੁਸ਼਼੍ਮਾਨਹੰ ਯਦ੍ ਵਦਾਮਿ ਤਦੇਵ ਸਰ੍ੱਵਾਨ੍ ਵਦਾਮਿ, ਜਾਗਰਿਤਾਸ੍ਤਿਸ਼਼੍ਠਤੇਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ਤਦਾ ਨਿਸ੍ਤਾਰੋਤ੍ਸਵਕਿਣ੍ਵਹੀਨਪੂਪੋਤ੍ਸਵਯੋਰਾਰਮ੍ਭਸ੍ਯ ਦਿਨਦ੍ਵਯੇ (ਅ)ਵਸ਼ਿਸ਼਼੍ਟੇ ਪ੍ਰਧਾਨਯਾਜਕਾ ਅਧ੍ਯਾਪਕਾਸ਼੍ਚ ਕੇਨਾਪਿ ਛਲੇਨ ਯੀਸ਼ੁੰ ਧਰ੍ੱਤਾਂ ਹਨ੍ਤੁਞ੍ਚ ਮ੍ਰੁʼਗਯਾਞ੍ਚਕ੍ਰਿਰੇ; ");
INSERT INTO sanpun_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ਕਿਨ੍ਤੁ ਲੋਕਾਨਾਂ ਕਲਹਭਯਾਦੂਚਿਰੇ, ਨਚੋਤ੍ਸਵਕਾਲ ਉਚਿਤਮੇਤਦਿਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","ਅਨਨ੍ਤਰੰ ਬੈਥਨਿਯਾਪੁुਰੇ ਸ਼ਿਮੋਨਕੁਸ਼਼੍ਠਿਨੋ ਗ੍ਰੁʼਹੇ ਯੋਸ਼ੌ ਭੋਤ੍ਕੁਮੁਪਵਿਸ਼਼੍ਟੇ ਸਤਿ ਕਾਚਿਦ੍ ਯੋਸ਼਼ਿਤ੍ ਪਾਣ੍ਡਰਪਾਸ਼਼ਾਣਸ੍ਯ ਸਮ੍ਪੁਟਕੇਨ ਮਹਾਰ੍ਘ੍ਯੋੱਤਮਤੈਲਮ੍ ਆਨੀਯ ਸਮ੍ਪੁਟਕੰ ਭੰਕ੍ਤ੍ਵਾ ਤਸ੍ਯੋੱਤਮਾਙ੍ਗੇ ਤੈਲਧਾਰਾਂ ਪਾਤਯਾਞ੍ਚਕ੍ਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ਤਸ੍ਮਾਤ੍ ਕੇਚਿਤ੍ ਸ੍ਵਾਨ੍ਤੇ ਕੁਪ੍ਯਨ੍ਤਃ ਕਥਿਤਵੰਨ੍ਤਃ ਕੁਤੋਯੰ ਤੈਲਾਪਵ੍ਯਯਃ? ");
INSERT INTO sanpun_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ਯਦ੍ਯੇਤਤ੍ ਤੈਲ ਵ੍ਯਕ੍ਰੇਸ਼਼੍ਯਤ ਤਰ੍ਹਿ ਮੁਦ੍ਰਾਪਾਦਸ਼ਤਤ੍ਰਯਾਦਪ੍ਯਧਿਕੰ ਤਸ੍ਯ ਪ੍ਰਾਪ੍ਤਮੂਲ੍ਯੰ ਦਰਿਦ੍ਰਲੋਕੇਭ੍ਯੋ ਦਾਤੁਮਸ਼ਕ੍ਸ਼਼੍ਯਤ, ਕਥਾਮੇਤਾਂ ਕਥਯਿਤ੍ਵਾ ਤਯਾ ਯੋਸ਼਼ਿਤਾ ਸਾਕੰ ਵਾਚਾਯੁਹ੍ਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","ਕਿਨ੍ਤੁ ਯੀਸ਼ੁਰੁਵਾਚ, ਕੁਤ ਏਤਸ੍ਯੈ ਕ੍ਰੁʼੱਛ੍ਰੰ ਦਦਾਸਿ? ਮਹ੍ਯਮਿਯੰ ਕਰ੍ੰਮੋੱਤਮੰ ਕ੍ਰੁʼਤਵਤੀ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ਦਰਿਦ੍ਰਾਃ ਸਰ੍ੱਵਦਾ ਯੁਸ਼਼੍ਮਾਭਿਃ ਸਹ ਤਿਸ਼਼੍ਠਨ੍ਤਿ, ਤਸ੍ਮਾਦ੍ ਯੂਯੰ ਯਦੇੱਛਥ ਤਦੈਵ ਤਾਨੁਪਕਰ੍ੱਤਾਂ ਸ਼ਕ੍ਨੁਥ, ਕਿਨ੍ਤ੍ਵਹੰ ਯੁਭਾਭਿਃ ਸਹ ਨਿਰਨ੍ਤਰੰ ਨ ਤਿਸ਼਼੍ਠਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","ਅਸ੍ਯਾ ਯਥਾਸਾਧ੍ਯੰ ਤਥੈਵਾਕਰੋਦਿਯੰ, ਸ਼੍ਮਸ਼ਾਨਯਾਪਨਾਤ੍ ਪੂਰ੍ੱਵੰ ਸਮੇਤ੍ਯ ਮਦ੍ਵਪੁਸ਼਼ਿ ਤੈਲਮ੍ ਅਮਰ੍ੱਦਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","ਅਹੰ ਯੁਸ਼਼੍ਮਭ੍ਯੰ ਯਥਾਰ੍ਥੰ ਕਥਯਾਮਿ, ਜਗਤਾਂ ਮਧ੍ਯੇ ਯਤ੍ਰ ਯਤ੍ਰ ਸੁਸੰਵਾਦੋਯੰ ਪ੍ਰਚਾਰਯਿਸ਼਼੍ਯਤੇ ਤਤ੍ਰ ਤਤ੍ਰ ਯੋਸ਼਼ਿਤ ਏਤਸ੍ਯਾਃ ਸ੍ਮਰਣਾਰ੍ਥੰ ਤਤ੍ਕ੍ਰੁʼਤਕਰ੍ੰਮੈਤਤ੍ ਪ੍ਰਚਾਰਯਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ਤਤਃ ਪਰੰ ਦ੍ਵਾਦਸ਼ਾਨਾਂ ਸ਼ਿਸ਼਼੍ਯਾਣਾਮੇਕ ਈਸ਼਼੍ਕਰਿਯੋਤੀਯਯਿਹੂਦਾਖ੍ਯੋ ਯੀਸ਼ੁੰ ਪਰਕਰੇਸ਼਼ੁ ਸਮਰ੍ਪਯਿਤੁੰ ਪ੍ਰਧਾਨਯਾਜਕਾਨਾਂ ਸਮੀਪਮਿਯਾਯ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ਤੇ ਤਸ੍ਯ ਵਾਕ੍ਯੰ ਸਮਾਕਰ੍ਣ੍ਯ ਸਨ੍ਤੁਸ਼਼੍ਟਾਃ ਸਨ੍ਤਸ੍ਤਸ੍ਮੈ ਮੁਦ੍ਰਾ ਦਾਤੁੰ ਪ੍ਰਤ੍ਯਜਾਨਤ; ਤਸ੍ਮਾਤ੍ ਸ ਤੰ ਤੇਸ਼਼ਾਂ ਕਰੇਸ਼਼ੁ ਸਮਰ੍ਪਣਾਯੋਪਾਯੰ ਮ੍ਰੁʼਗਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","ਅਨਨ੍ਤਰੰ ਕਿਣ੍ਵਸ਼ੂਨ੍ਯਪੂਪੋਤ੍ਸਵਸ੍ਯ ਪ੍ਰਥਮੇ(ਅ)ਹਨਿ ਨਿਸ੍ਤਾਰੋਤ੍ਮਵਾਰ੍ਥੰ ਮੇਸ਼਼ਮਾਰਣਾਸਮਯੇ ਸ਼ਿਸ਼਼੍ਯਾਸ੍ਤੰ ਪਪ੍ਰੱਛਃ ਕੁਤ੍ਰ ਗਤ੍ਵਾ ਵਯੰ ਨਿਸ੍ਤਾਰੋਤ੍ਸਵਸ੍ਯ ਭੋਜ੍ਯਮਾਸਾਦਯਿਸ਼਼੍ਯਾਮਃ? ਕਿਮਿੱਛਤਿ ਭਵਾਨ੍? ");
INSERT INTO sanpun_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","ਤਦਾਨੀਂ ਸ ਤੇਸ਼਼ਾਂ ਦ੍ਵਯੰ ਪ੍ਰੇਰਯਨ੍ ਬਭਾਸ਼਼ੇ ਯੁਵਯੋਃ ਪੁਰਮਧ੍ਯੰ ਗਤਯੋਃ ਸਤੋ ਰ੍ਯੋ ਜਨਃ ਸਜਲਕੁਮ੍ਭੰ ਵਹਨ੍ ਯੁਵਾਂ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਕਰਿਸ਼਼੍ਯਤਿ ਤਸ੍ਯੈਵ ਪਸ਼੍ਚਾਦ੍ ਯਾਤੰ; ");
INSERT INTO sanpun_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ਸ ਯਤ੍ ਸਦਨੰ ਪ੍ਰਵੇਕ੍ਸ਼਼੍ਯਤਿ ਤਦ੍ਭਵਨਪਤਿੰ ਵਦਤੰ, ਗੁਰੁਰਾਹ ਯਤ੍ਰ ਸਸ਼ਿਸ਼਼੍ਯੋਹੰ ਨਿਸ੍ਤਾਰੋਤ੍ਸਵੀਯੰ ਭੋਜਨੰ ਕਰਿਸ਼਼੍ਯਾਮਿ, ਸਾ ਭੋਜਨਸ਼ਾਲਾ ਕੁਤ੍ਰਾਸ੍ਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ਤਤਃ ਸ ਪਰਿਸ਼਼੍ਕ੍ਰੁʼਤਾਂ ਸੁਸੱਜਿਤਾਂ ਬ੍ਰੁʼਹਤੀਚਞ੍ਚ ਯਾਂ ਸ਼ਾਲਾਂ ਦਰ੍ਸ਼ਯਿਸ਼਼੍ਯਤਿ ਤਸ੍ਯਾਮਸ੍ਮਦਰ੍ਥੰ ਭੋਜ੍ਯਦ੍ਰਵ੍ਯਾਣ੍ਯਾਸਾਦਯਤੰ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ਤਤਃ ਸ਼ਿਸ਼਼੍ਯੌ ਪ੍ਰਸ੍ਥਾਯ ਪੁਰੰ ਪ੍ਰਵਿਸ਼੍ਯ ਸ ਯਥੋਕ੍ਤਵਾਨ੍ ਤਥੈਵ ਪ੍ਰਾਪ੍ਯ ਨਿਸ੍ਤਾਰੋਤ੍ਸਵਸ੍ਯ ਭੋਜ੍ਯਦ੍ਰਵ੍ਯਾਣਿ ਸਮਾਸਾਦਯੇਤਾਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ਅਨਨ੍ਤਰੰ ਯੀਸ਼ੁਃ ਸਾਯੰਕਾਲੇ ਦ੍ਵਾਦਸ਼ਭਿਃ ਸ਼ਿਸ਼਼੍ਯੈਃ ਸਾਰ੍ੱਧੰ ਜਗਾਮ; ");
INSERT INTO sanpun_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ਸਰ੍ੱਵੇਸ਼਼ੁ ਭੋਜਨਾਯ ਪ੍ਰੋਪਵਿਸ਼਼੍ਟੇਸ਼਼ੁ ਸ ਤਾਨੁਦਿਤਵਾਨ੍ ਯੁਸ਼਼੍ਮਾਨਹੰ ਯਥਾਰ੍ਥੰ ਵ੍ਯਾਹਰਾਮਿ, ਅਤ੍ਰ ਯੁਸ਼਼੍ਮਾਕਮੇਕੋ ਜਨੋ ਯੋ ਮਯਾ ਸਹ ਭੁੰਕ੍ਤੇ ਮਾਂ ਪਰਕੇਰੇਸ਼਼ੁ ਸਮਰ੍ਪਯਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","ਤਦਾਨੀਂ ਤੇ ਦੁਃਖਿਤਾਃ ਸਨ੍ਤ ਏਕੈਕਸ਼ਸ੍ਤੰ ਪ੍ਰਸ਼਼੍ਟੁਮਾਰਬ੍ਧਵਨ੍ਤਃ ਸ ਕਿਮਹੰ? ਪਸ਼੍ਚਾਦ੍ ਅਨ੍ਯ ਏਕੋਭਿਦਧੇ ਸ ਕਿਮਹੰ? ");
INSERT INTO sanpun_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ਤਤਃ ਸ ਪ੍ਰਤ੍ਯਵਦਦ੍ ਏਤੇਸ਼਼ਾਂ ਦ੍ਵਾਦਸ਼ਾਨਾਂ ਯੋ ਜਨੋ ਮਯਾ ਸਮੰ ਭੋਜਨਾਪਾਤ੍ਰੇ ਪਾਣਿੰ ਮੱਜਯਿਸ਼਼੍ਯਤਿ ਸ ਏਵ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","ਮਨੁਜਤਨਯਮਧਿ ਯਾਦ੍ਰੁʼਸ਼ੰ ਲਿਖਿਤਮਾਸ੍ਤੇ ਤਦਨੁਰੂਪਾ ਗਤਿਸ੍ਤਸ੍ਯ ਭਵਿਸ਼਼੍ਯਤਿ, ਕਿਨ੍ਤੁ ਯੋ ਜਨੋ ਮਾਨਵਸੁਤੰ ਸਮਰ੍ਪਯਿਸ਼਼੍ਯਤੇ ਹਨ੍ਤ ਤਸ੍ਯ ਜਨ੍ਮਾਭਾਵੇ ਸਤਿ ਭਦ੍ਰਮਭਵਿਸ਼਼੍ਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ਅਪਰਞ੍ਚ ਤੇਸ਼਼ਾਂ ਭੋਜਨਸਮਯੇ ਯੀਸ਼ੁਃ ਪੂਪੰ ਗ੍ਰੁʼਹੀਤ੍ਵੇਸ਼੍ਵਰਗੁਣਾਨ੍ ਅਨੁਕੀਰ੍ਤ੍ਯ ਭਙ੍ਕ੍ਤ੍ਵਾ ਤੇਭ੍ਯੋ ਦੱਤ੍ਵਾ ਬਭਾਸ਼਼ੇ, ਏਤਦ੍ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਭੁਞ੍ਜੀਧ੍ਵਮ੍ ਏਤਨ੍ਮਮ ਵਿਗ੍ਰਹਰੂਪੰ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ਅਨਨ੍ਤਰੰ ਸ ਕੰਸੰ ਗ੍ਰੁʼਹੀਤ੍ਵੇਸ਼੍ਵਰਸ੍ਯ ਗੁਣਾਨ੍ ਕੀਰ੍ੱਤਯਿਤ੍ਵਾ ਤੇਭ੍ਯੋ ਦਦੌ, ਤਤਸ੍ਤੇ ਸਰ੍ੱਵੇ ਪਪੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ਅਪਰੰ ਸ ਤਾਨਵਾਦੀਦ੍ ਬਹੂਨਾਂ ਨਿਮਿੱਤੰ ਪਾਤਿਤੰ ਮਮ ਨਵੀਨਨਿਯਮਰੂਪੰ ਸ਼ੋਣਿਤਮੇਤਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","ਯੁਸ਼਼੍ਮਾਨਹੰ ਯਥਾਰ੍ਥੰ ਵਦਾਮਿ, ਈਸ਼੍ਵਰਸ੍ਯ ਰਾਜ੍ਯੇ ਯਾਵਤ੍ ਸਦ੍ਯੋਜਾਤੰ ਦ੍ਰਾਕ੍ਸ਼਼ਾਰਸੰ ਨ ਪਾਸ੍ਯਾਮਿ,ਤਾਵਦਹੰ ਦ੍ਰਾਕ੍ਸ਼਼ਾਫਲਰਸੰ ਪੁਨ ਰ੍ਨ ਪਾਸ੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ਤਦਨਨ੍ਤਰੰ ਤੇ ਗੀਤਮੇਕੰ ਸੰਗੀਯ ਬਹਿ ਰ੍ਜੈਤੁਨੰ ਸ਼ਿਖਰਿਣੰ ਯਯੁਃ ");
INSERT INTO sanpun_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","ਅਥ ਯੀਸ਼ੁਸ੍ਤਾਨੁਵਾਚ ਨਿਸ਼ਾਯਾਮਸ੍ਯਾਂ ਮਯਿ ਯੁਸ਼਼੍ਮਾਕੰ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਪ੍ਰਤ੍ਯੂਹੋ ਭਵਿਸ਼਼੍ਯਤਿ ਯਤੋ ਲਿਖਿਤਮਾਸ੍ਤੇ ਯਥਾ, ਮੇਸ਼਼ਾਣਾਂ ਰਕ੍ਸ਼਼ਕਞ੍ਚਾਹੰ ਪ੍ਰਹਰਿਸ਼਼੍ਯਾਮਿ ਵੈ ਤਤਃ| ਮੇਸ਼਼ਾਣਾਂ ਨਿਵਹੋ ਨੂਨੰ ਪ੍ਰਵਿਕੀਰ੍ਣੋ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","ਕਨ੍ਤੁ ਮਦੁੱਥਾਨੇ ਜਾਤੇ ਯੁਸ਼਼੍ਮਾਕਮਗ੍ਰੇ(ਅ)ਹੰ ਗਾਲੀਲੰ ਵ੍ਰਜਿਸ਼਼੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ਤਦਾ ਪਿਤਰਃ ਪ੍ਰਤਿਬਭਾਸ਼਼ੇ, ਯਦ੍ਯਪਿ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਪ੍ਰਤ੍ਯੂਹੋ ਭਵਤਿ ਤਥਾਪਿ ਮਮ ਨੈਵ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ਤਤੋ ਯੀਸ਼ੁਰੁਕ੍ਤਾਵਾਨ੍ ਅਹੰ ਤੁਭ੍ਯੰ ਤਥ੍ਯੰ ਕਥਯਾਮਿ, ਕ੍ਸ਼਼ਣਾਦਾਯਾਮਦ੍ਯ ਕੁੱਕੁਟਸ੍ਯ ਦ੍ਵਿਤੀਯਵਾਰਰਵਣਾਤ੍ ਪੂਰ੍ੱਵੰ ਤ੍ਵੰ ਵਾਰਤ੍ਰਯੰ ਮਾਮਪਹ੍ਨੋਸ਼਼੍ਯਸੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ਕਿਨ੍ਤੁ ਸ ਗਾਢੰ ਵ੍ਯਾਹਰਦ੍ ਯਦ੍ਯਪਿ ਤ੍ਵਯਾ ਸਾਰ੍ੱਧੰ ਮਮ ਪ੍ਰਾਣੋ ਯਾਤਿ ਤਥਾਪਿ ਕਥਮਪਿ ਤ੍ਵਾਂ ਨਾਪਹ੍ਨੋਸ਼਼੍ਯੇ; ਸਰ੍ੱਵੇ(ਅ)ਪੀਤਰੇ ਤਥੈਵ ਬਭਾਸ਼਼ਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ਅਪਰਞ੍ਚ ਤੇਸ਼਼ੁ ਗੇਤ੍ਸ਼ਿਮਾਨੀਨਾਮਕੰ ਸ੍ਥਾਨ ਗਤੇਸ਼਼ੁ ਸ ਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਜਗਾਦ, ਯਾਵਦਹੰ ਪ੍ਰਾਰ੍ਥਯੇ ਤਾਵਦਤ੍ਰ ਸ੍ਥਾਨੇ ਯੂਯੰ ਸਮੁਪਵਿਸ਼ਤ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","ਅਥ ਸ ਪਿਤਰੰ ਯਾਕੂਬੰ ਯੋਹਨਞ੍ਚ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਵਵ੍ਰਾਜ; ਅਤ੍ਯਨ੍ਤੰ ਤ੍ਰਾਸਿਤੋ ਵ੍ਯਾਕੁਲਿਤਸ਼੍ਚ ਤੇਭ੍ਯਃ ਕਥਯਾਮਾਸ, ");
INSERT INTO sanpun_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ਨਿਧਨਕਾਲਵਤ੍ ਪ੍ਰਾਣੋ ਮੇ(ਅ)ਤੀਵ ਦਃਖਮੇਤਿ, ਯੂਯੰ ਜਾਗ੍ਰਤੋਤ੍ਰ ਸ੍ਥਾਨੇ ਤਿਸ਼਼੍ਠਤ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ਤਤਃ ਸ ਕਿਞ੍ਚਿੱਦੂਰੰ ਗਤ੍ਵਾ ਭੂਮਾਵਧੋਮੁਖਃ ਪਤਿਤ੍ਵਾ ਪ੍ਰਾਰ੍ਥਿਤਵਾਨੇਤਤ੍, ਯਦਿ ਭਵਿਤੁੰ ਸ਼ਕ੍ਯੰ ਤਰ੍ਹਿ ਦੁਃਖਸਮਯੋਯੰ ਮੱਤੋ ਦੂਰੀਭਵਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ਅਪਰਮੁਦਿਤਵਾਨ੍ ਹੇ ਪਿਤ ਰ੍ਹੇ ਪਿਤਃ ਸਰ੍ੱਵੇਂ ਤ੍ਵਯਾ ਸਾਧ੍ਯੰ, ਤਤੋ ਹੇਤੋਰਿਮੰ ਕੰਸੰ ਮੱਤੋ ਦੂਰੀਕੁਰੁ, ਕਿਨ੍ਤੁ ਤਨ੍ ਮਮੇੱਛਾਤੋ ਨ ਤਵੇੱਛਾਤੋ ਭਵਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","ਤਤਃ ਪਰੰ ਸ ਏਤ੍ਯ ਤਾਨ੍ ਨਿਦ੍ਰਿਤਾਨ੍ ਨਿਰੀਕ੍ਸ਼਼੍ਯ ਪਿਤਰੰ ਪ੍ਰੋਵਾਚ, ਸ਼ਿਮੋਨ੍ ਤ੍ਵੰ ਕਿੰ ਨਿਦ੍ਰਾਸਿ? ਘਟਿਕਾਮੇਕਾਮ੍ ਅਪਿ ਜਾਗਰਿਤੁੰ ਨ ਸ਼ਕ੍ਨੋਸ਼਼ਿ? ");
INSERT INTO sanpun_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","ਪਰੀਕ੍ਸ਼਼ਾਯਾਂ ਯਥਾ ਨ ਪਤਥ ਤਦਰ੍ਥੰ ਸਚੇਤਨਾਃ ਸਨ੍ਤਃ ਪ੍ਰਾਰ੍ਥਯਧ੍ਵੰ; ਮਨ ਉਦ੍ਯੁਕ੍ਤਮਿਤਿ ਸਤ੍ਯੰ ਕਿਨ੍ਤੁ ਵਪੁਰਸ਼ਕ੍ਤਿਕੰ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ਅਥ ਸ ਪੁਨਰ੍ਵ੍ਰਜਿਤ੍ਵਾ ਪੂਰ੍ੱਵਵਤ੍ ਪ੍ਰਾਰ੍ਥਯਾਞ੍ਚਕ੍ਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ਪਰਾਵ੍ਰੁʼਤ੍ਯਾਗਤ੍ਯ ਪੁਨਰਪਿ ਤਾਨ੍ ਨਿਦ੍ਰਿਤਾਨ੍ ਦਦਰ੍ਸ਼ ਤਦਾ ਤੇਸ਼਼ਾਂ ਲੋਚਨਾਨਿ ਨਿਦ੍ਰਯਾ ਪੂਰ੍ਣਾਨਿ, ਤਸ੍ਮਾੱਤਸ੍ਮੈ ਕਾ ਕਥਾ ਕਥਯਿਤਵ੍ਯਾ ਤ ਏਤਦ੍ ਬੋੱਧੁੰ ਨ ਸ਼ੇਕੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ਤਤਃਪਰੰ ਤ੍ਰੁʼਤੀਯਵਾਰੰ ਆਗਤ੍ਯ ਤੇਭ੍ਯੋ (ਅ)ਕਥਯਦ੍ ਇਦਾਨੀਮਪਿ ਸ਼ਯਿਤ੍ਵਾ ਵਿਸ਼੍ਰਾਮ੍ਯਥ? ਯਥੇਸ਼਼੍ਟੰ ਜਾਤੰ, ਸਮਯਸ਼੍ਚੋਪਸ੍ਥਿਤਃ ਪਸ਼੍ਯਤ ਮਾਨਵਤਨਯਃ ਪਾਪਿਲੋਕਾਨਾਂ ਪਾਣਿਸ਼਼ੁ ਸਮਰ੍ਪ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ਉੱਤਿਸ਼਼੍ਠਤ, ਵਯੰ ਵ੍ਰਜਾਮੋ ਯੋ ਜਨੋ ਮਾਂ ਪਰਪਾਣਿਸ਼਼ੁ ਸਮਰ੍ਪਯਿਸ਼਼੍ਯਤੇ ਪਸ਼੍ਯਤ ਸ ਸਮੀਪਮਾਯਾਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ਇਮਾਂ ਕਥਾਂ ਕਥਯਤਿ ਸ, ਏਤਰ੍ਹਿਦ੍ਵਾਦਸ਼ਾਨਾਮੇਕੋ ਯਿਹੂਦਾ ਨਾਮਾ ਸ਼ਿਸ਼਼੍ਯਃ ਪ੍ਰਧਾਨਯਾਜਕਾਨਾਮ੍ ਉਪਾਧ੍ਯਾਯਾਨਾਂ ਪ੍ਰਾਚੀਨਲੋਕਾਨਾਞ੍ਚ ਸੰਨਿਧੇਃ ਖਙ੍ਗਲਗੁਡਧਾਰਿਣੋ ਬਹੁਲੋਕਾਨ੍ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਤਸ੍ਯ ਸਮੀਪ ਉਪਸ੍ਥਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ਅਪਰਞ੍ਚਾਸੌ ਪਰਪਾਣਿਸ਼਼ੁ ਸਮਰ੍ਪਯਿਤਾ ਪੂਰ੍ੱਵਮਿਤਿ ਸਙ੍ਕੇਤੰ ਕ੍ਰੁʼਤਵਾਨ੍ ਯਮਹੰ ਚੁਮ੍ਬਿਸ਼਼੍ਯਾਮਿ ਸ ਏਵਾਸੌ ਤਮੇਵ ਧ੍ਰੁʼਤ੍ਵਾ ਸਾਵਧਾਨੰ ਨਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ਅਤੋ ਹੇਤੋਃ ਸ ਆਗਤ੍ਯੈਵ ਯੋਸ਼ੋਃ ਸਵਿਧੰ ਗਤ੍ਵਾ ਹੇ ਗੁਰੋ ਹੇ ਗੁਰੋ, ਇਤ੍ਯੁਕ੍ਤ੍ਵਾ ਤੰ ਚੁਚੁਮ੍ਬ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ਤਦਾ ਤੇ ਤਦੁਪਰਿ ਪਾਣੀਨਰ੍ਪਯਿਤ੍ਵਾ ਤੰ ਦਧ੍ਨੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ਤਤਸ੍ਤਸ੍ਯ ਪਾਰ੍ਸ਼੍ਵਸ੍ਥਾਨਾਂ ਲੋਕਾਨਾਮੇਕਃ ਖਙ੍ਗੰ ਨਿਸ਼਼੍ਕੋਸ਼਼ਯਨ੍ ਮਹਾਯਾਜਕਸ੍ਯ ਦਾਸਮੇਕੰ ਪ੍ਰਹ੍ਰੁʼਤ੍ਯ ਤਸ੍ਯ ਕਰ੍ਣੰ ਚਿੱਛੇਦ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","ਪਸ਼੍ਚਾਦ੍ ਯੀਸ਼ੁਸ੍ਤਾਨ੍ ਵ੍ਯਾਜਹਾਰ ਖਙ੍ਗਾਨ੍ ਲਗੁਡਾਂਸ਼੍ਚ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਮਾਂ ਕਿੰ ਚੌਰੰ ਧਰ੍ੱਤਾਂ ਸਮਾਯਾਤਾਃ? ");
INSERT INTO sanpun_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","ਮਧ੍ਯੇਮਨ੍ਦਿਰੰ ਸਮੁਪਦਿਸ਼ਨ੍ ਪ੍ਰਤ੍ਯਹੰ ਯੁਸ਼਼੍ਮਾਭਿਃ ਸਹ ਸ੍ਥਿਤਵਾਨਤਹੰ, ਤਸ੍ਮਿਨ੍ ਕਾਲੇ ਯੂਯੰ ਮਾਂ ਨਾਦੀਧਰਤ, ਕਿਨ੍ਤ੍ਵਨੇਨ ਸ਼ਾਸ੍ਤ੍ਰੀਯੰ ਵਚਨੰ ਸੇਧਨੀਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ਤਦਾ ਸਰ੍ੱਵੇ ਸ਼ਿਸ਼਼੍ਯਾਸ੍ਤੰ ਪਰਿਤ੍ਯਜ੍ਯ ਪਲਾਯਾਞ੍ਚਕ੍ਰਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ਅਥੈਕੋ ਯੁਵਾ ਮਾਨਵੋ ਨਗ੍ਨਕਾਯੇ ਵਸ੍ਤ੍ਰਮੇਕੰ ਨਿਧਾਯ ਤਸ੍ਯ ਪਸ਼੍ਚਾਦ੍ ਵ੍ਰਜਨ੍ ਯੁਵਲੋਕੈ ਰ੍ਧ੍ਰੁʼਤੋ ");
INSERT INTO sanpun_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ਵਸ੍ਤ੍ਰੰ ਵਿਹਾਯ ਨਗ੍ਨਃ ਪਲਾਯਾਞ੍ਚਕ੍ਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ਅਪਰਞ੍ਚ ਯਸ੍ਮਿਨ੍ ਸ੍ਥਾਨੇ ਪ੍ਰਧਾਨਯਾਜਕਾ ਉਪਾਧ੍ਯਾਯਾਃ ਪ੍ਰਾਚੀਨਲੋਕਾਸ਼੍ਚ ਮਹਾਯਾਜਕੇਨ ਸਹ ਸਦਸਿ ਸ੍ਥਿਤਾਸ੍ਤਸ੍ਮਿਨ੍ ਸ੍ਥਾਨੇ ਮਹਾਯਾਜਕਸ੍ਯ ਸਮੀਪੰ ਯੀਸ਼ੁੰ ਨਿਨ੍ਯੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ਪਿਤਰੋ ਦੂਰੇ ਤਤ੍ਪਸ਼੍ਚਾਦ੍ ਇਤ੍ਵਾ ਮਹਾਯਾਜਕਸ੍ਯਾੱਟਾਲਿਕਾਂ ਪ੍ਰਵਿਸ਼੍ਯ ਕਿਙ੍ਕਰੈਃ ਸਹੋਪਵਿਸ਼੍ਯ ਵਹ੍ਨਿਤਾਪੰ ਜਗ੍ਰਾਹ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ਤਦਾਨੀਂ ਪ੍ਰਧਾਨਯਾਜਕਾ ਮਨ੍ਤ੍ਰਿਣਸ਼੍ਚ ਯੀਸ਼ੁੰ ਘਾਤਯਿਤੁੰ ਤਤ੍ਪ੍ਰਾਤਿਕੂਲ੍ਯੇਨ ਸਾਕ੍ਸ਼਼ਿਣੋ ਮ੍ਰੁʼਗਯਾਞ੍ਚਕ੍ਰਿਰੇ, ਕਿਨ੍ਤੁ ਨ ਪ੍ਰਾਪ੍ਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ਅਨੇਕੈਸ੍ਤਦ੍ਵਿਰੁੱਧੰ ਮ੍ਰੁʼਸ਼਼ਾਸਾਕ੍ਸ਼਼੍ਯੇ ਦੱਤੇਪਿ ਤੇਸ਼਼ਾਂ ਵਾਕ੍ਯਾਨਿ ਨ ਸਮਗੱਛਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","ਸਰ੍ੱਵਸ਼ੇਸ਼਼ੇ ਕਿਯਨ੍ਤ ਉੱਥਾਯ ਤਸ੍ਯ ਪ੍ਰਾਤਿਕੂਲ੍ਯੇਨ ਮ੍ਰੁʼਸ਼਼ਾਸਾਕ੍ਸ਼਼੍ਯੰ ਦੱਤ੍ਵਾ ਕਥਯਾਮਾਸੁਃ, ");
INSERT INTO sanpun_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","ਇਦੰ ਕਰਕ੍ਰੁʼਤਮਨ੍ਦਿਰੰ ਵਿਨਾਸ਼੍ਯ ਦਿਨਤ੍ਰਯਮਧ੍ਯੇ ਪੁਨਰਪਰਮ੍ ਅਕਰਕ੍ਰੁʼਤੰ ਮਨ੍ਦਿਰੰ ਨਿਰ੍ੰਮਾਸ੍ਯਾਮਿ, ਇਤਿ ਵਾਕ੍ਯਮ੍ ਅਸ੍ਯ ਮੁਖਾਤ੍ ਸ਼੍ਰੁਤਮਸ੍ਮਾਭਿਰਿਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","ਕਿਨ੍ਤੁ ਤਤ੍ਰਾਪਿ ਤੇਸ਼਼ਾਂ ਸਾਕ੍ਸ਼਼੍ਯਕਥਾ ਨ ਸਙ੍ਗਾਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ਅਥ ਮਹਾਯਾਜਕੋ ਮਧ੍ਯੇਸਭਮ੍ ਉੱਥਾਯ ਯੀਸ਼ੁੰ ਵ੍ਯਾਜਹਾਰ, ਏਤੇ ਜਨਾਸ੍ਤ੍ਵਯਿ ਯਤ੍ ਸਾਕ੍ਸ਼਼੍ਯਮਦੁਃ ਤ੍ਵਮੇਤਸ੍ਯ ਕਿਮਪ੍ਯੁੱਤਰੰ ਕਿੰ ਨ ਦਾਸ੍ਯਸਿ? ");
INSERT INTO sanpun_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","ਕਿਨ੍ਤੁ ਸ ਕਿਮਪ੍ਯੁੱਤਰੰ ਨ ਦਤ੍ਵਾ ਮੌਨੀਭੂਯ ਤਸ੍ਯੌ; ਤਤੋ ਮਹਾਯਾਜਕਃ ਪੁਨਰਪਿ ਤੰ ਪ੍ਰੁʼਸ਼਼੍ਟਾਵਾਨ੍ ਤ੍ਵੰ ਸੱਚਿਦਾਨਨ੍ਦਸ੍ਯ ਤਨਯੋ (ਅ)ਭਿਸ਼਼ਿਕ੍ਤਸ੍ਤ੍ਰਤਾ? ");
INSERT INTO sanpun_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","ਤਦਾ ਯੀਸ਼ੁਸ੍ਤੰ ਪ੍ਰੋਵਾਚ ਭਵਾਮ੍ਯਹਮ੍ ਯੂਯਞ੍ਚ ਸਰ੍ੱਵਸ਼ਕ੍ਤਿਮਤੋ ਦਕ੍ਸ਼਼ੀਣਪਾਰ੍ਸ਼੍ਵੇ ਸਮੁਪਵਿਸ਼ਨ੍ਤੰ ਮੇਘ ਮਾਰੁਹ੍ਯ ਸਮਾਯਾਨ੍ਤਞ੍ਚ ਮਨੁਸ਼਼੍ਯਪੁਤ੍ਰੰ ਸਨ੍ਦ੍ਰਕ੍ਸ਼਼੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ਤਦਾ ਮਹਾਯਾਜਕਃ ਸ੍ਵੰ ਵਮਨੰ ਛਿਤ੍ਵਾ ਵ੍ਯਾਵਹਰਤ੍ ");
INSERT INTO sanpun_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ਕਿਮਸ੍ਮਾਕੰ ਸਾਕ੍ਸ਼਼ਿਭਿਃ ਪ੍ਰਯੋਜਨਮ੍? ਈਸ਼੍ਵਰਨਿਨ੍ਦਾਵਾਕ੍ਯੰ ਯੁਸ਼਼੍ਮਾਭਿਰਸ਼੍ਰਾਵਿ ਕਿੰ ਵਿਚਾਰਯਥ? ਤਦਾਨੀਂ ਸਰ੍ੱਵੇ ਜਗਦੁਰਯੰ ਨਿਧਨਦਣ੍ਡਮਰ੍ਹਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","ਤਤਃ ਕਸ਼੍ਚਿਤ੍ ਕਸ਼੍ਚਿਤ੍ ਤਦ੍ਵਪੁਸ਼਼ਿ ਨਿਸ਼਼੍ਠੀਵੰ ਨਿਚਿਕ੍ਸ਼਼ੇਪ ਤਥਾ ਤਨ੍ਮੁਖਮਾੱਛਾਦ੍ਯ ਚਪੇਟੇਨ ਹਤ੍ਵਾ ਗਦਿਤਵਾਨ੍ ਗਣਯਿਤ੍ਵਾ ਵਦ, ਅਨੁਚਰਾਸ਼੍ਚ ਚਪੇਟੈਸ੍ਤਮਾਜਘ੍ਨੁਃ ");
INSERT INTO sanpun_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ਤਤਃ ਪਰੰ ਪਿਤਰੇ(ਅ)ੱਟਾਲਿਕਾਧਃਕੋਸ਼਼੍ਠੇ ਤਿਸ਼਼੍ਠਤਿ ਮਹਾਯਾਜਕਸ੍ਯੈਕਾ ਦਾਸੀ ਸਮੇਤ੍ਯ ");
INSERT INTO sanpun_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ਤੰ ਵਿਹ੍ਨਿਤਾਪੰ ਗ੍ਰੁʼਹ੍ਲਨ੍ਤੰ ਵਿਲੋਕ੍ਯ ਤੰ ਸੁਨਿਰੀਕ੍ਸ਼਼੍ਯ ਬਭਾਸ਼਼ੇ ਤ੍ਵਮਪਿ ਨਾਸਰਤੀਯਯੀਸ਼ੋਃ ਸਙ੍ਗਿਨਾਮ੍ ਏਕੋ ਜਨ ਆਸੀਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","ਕਿਨ੍ਤੁ ਸੋਪਹ੍ਨੁਤ੍ਯ ਜਗਾਦ ਤਮਹੰ ਨ ਵਦ੍ਮਿ ਤ੍ਵੰ ਯਤ੍ ਕਥਯਮਿ ਤਦਪ੍ਯਹੰ ਨ ਬੁੱਧ੍ਯੇ| ਤਦਾਨੀਂ ਪਿਤਰੇ ਚਤ੍ਵਰੰ ਗਤਵਤਿ ਕੁेੱਕੁਟੋ ਰੁਰਾਵ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ਅਥਾਨ੍ਯਾ ਦਾਸੀ ਪਿਤਰੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਸਮੀਪਸ੍ਥਾਨ੍ ਜਨਾਨ੍ ਜਗਾਦ ਅਯੰ ਤੇਸ਼਼ਾਮੇਕੋ ਜਨਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ਤਤਃ ਸ ਦ੍ਵਿਤੀਯਵਾਰਮ੍ ਅਪਹ੍ਨੁਤਵਾਨ੍ ਪਸ਼੍ਚਾਤ੍ ਤਤ੍ਰਸ੍ਥਾ ਲੋਕਾਃ ਪਿਤਰੰ ਪ੍ਰੋਚੁਸ੍ਤ੍ਵਮਵਸ਼੍ਯੰ ਤੇਸ਼਼ਾਮੇਕੋ ਜਨਃ ਯਤਸ੍ਤ੍ਵੰ ਗਾਲੀਲੀਯੋ ਨਰ ਇਤਿ ਤਵੋੱਚਾਰਣੰ ਪ੍ਰਕਾਸ਼ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","ਤਦਾ ਸ ਸ਼ਪਥਾਭਿਸ਼ਾਪੌ ਕ੍ਰੁʼਤ੍ਵਾ ਪ੍ਰੋਵਾਚ ਯੂਯੰ ਕਥਾਂ ਕਥਯਥ ਤੰ ਨਰੰ ਨ ਜਾਨੇ(ਅ)ਹੰ| ");
INSERT INTO sanpun_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ਤਦਾਨੀਂ ਦ੍ਵਿਤੀਯਵਾਰੰ ਕੁੱਕੁਟੋ (ਅ)ਰਾਵੀਤ੍| ਕੁੱਕੁਟਸ੍ਯ ਦ੍ਵਿਤੀਯਰਵਾਤ੍ ਪੂਰ੍ੱਵੰ ਤ੍ਵੰ ਮਾਂ ਵਾਰਤ੍ਰਯਮ੍ ਅਪਹ੍ਨੋਸ਼਼੍ਯਸਿ, ਇਤਿ ਯਦ੍ਵਾਕ੍ਯੰ ਯੀਸ਼ੁਨਾ ਸਮੁਦਿਤੰ ਤਤ੍ ਤਦਾ ਸੰਸ੍ਮ੍ਰੁʼਤ੍ਯ ਪਿਤਰੋ ਰੋਦਿਤੁਮ੍ ਆਰਭਤ| ");
INSERT INTO sanpun_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","ਅਥ ਪ੍ਰਭਾਤੇ ਸਤਿ ਪ੍ਰਧਾਨਯਾਜਕਾਃ ਪ੍ਰਾਞ੍ਚ ਉਪਾਧ੍ਯਾਯਾਃ ਸਰ੍ੱਵੇ ਮਨ੍ਤ੍ਰਿਣਸ਼੍ਚ ਸਭਾਂ ਕ੍ਰੁʼਤ੍ਵਾ ਯੀਸ਼ੁृਂ ਬਨ੍ਧਯਿਤ੍ਵ ਪੀਲਾਤਾਖ੍ਯਸ੍ਯ ਦੇਸ਼ਾਧਿਪਤੇਃ ਸਵਿਧੰ ਨੀਤ੍ਵਾ ਸਮਰ੍ਪਯਾਮਾਸੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ਤਦਾ ਪੀਲਾਤਸ੍ਤੰ ਪ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍ ਤ੍ਵੰ ਕਿੰ ਯਿਹੂਦੀਯਲੋਕਾਨਾਂ ਰਾਜਾ? ਤਤਃ ਸ ਪ੍ਰਤ੍ਯੁਕ੍ਤਵਾਨ੍ ਸਤ੍ਯੰ ਵਦਸਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","ਅਪਰੰ ਪ੍ਰਧਾਨਯਾਜਕਾਸ੍ਤਸ੍ਯ ਬਹੁਸ਼਼ੁ ਵਾਕ੍ਯੇਸ਼਼ੁ ਦੋਸ਼਼ਮਾਰੋਪਯਾਞ੍ਚਕ੍ਰੁਃ ਕਿਨ੍ਤੁ ਸ ਕਿਮਪਿ ਨ ਪ੍ਰਤ੍ਯੁਵਾਚ| ");
INSERT INTO sanpun_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ਤਦਾਨੀਂ ਪੀਲਾਤਸ੍ਤੰ ਪੁਨਃ ਪਪ੍ਰੱਛ ਤ੍ਵੰ ਕਿੰ ਨੋੱਤਰਯਸਿ? ਪਸ਼੍ਯੈਤੇ ਤ੍ਵਦ੍ਵਿਰੁੱਧੰ ਕਤਿਸ਼਼ੁ ਸਾਧ੍ਯੇਸ਼਼ੁ ਸਾਕ੍ਸ਼਼ੰ ਦਦਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ਕਨ੍ਤੁ ਯੀਸ਼ੁਸ੍ਤਦਾਪਿ ਨੋੱਤਰੰ ਦਦੌ ਤਤਃ ਪੀਲਾਤ ਆਸ਼੍ਚਰ੍ੱਯੰ ਜਗਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ਅਪਰਞ੍ਚ ਕਾਰਾਬੱਧੇ ਕਸ੍ਤਿੰਸ਼੍ਚਿਤ੍ ਜਨੇ ਤਨ੍ਮਹੋਤ੍ਸਵਕਾਲੇ ਲੋਕੈ ਰ੍ਯਾਚਿਤੇ ਦੇਸ਼ਾਧਿਪਤਿਸ੍ਤੰ ਮੋਚਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ਯੇ ਚ ਪੂਰ੍ੱਵਮੁਪਪ੍ਲਵਮਕਾਰ੍ਸ਼਼ੁਰੁਪਪ੍ਲਵੇ ਵਧਮਪਿ ਕ੍ਰੁʼਤਵਨ੍ਤਸ੍ਤੇਸ਼਼ਾਂ ਮਧ੍ਯੇ ਤਦਾਨੋਂ ਬਰੱਬਾਨਾਮਕ ਏਕੋ ਬੱਧ ਆਸੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ਅਤੋ ਹੇਤੋਃ ਪੂਰ੍ੱਵਾਪਰੀਯਾਂ ਰੀਤਿਕਥਾਂ ਕਥਯਿਤ੍ਵਾ ਲੋਕਾ ਉੱਚੈਰੁਵਨ੍ਤਃ ਪੀਲਾਤਸ੍ਯ ਸਮਕ੍ਸ਼਼ੰ ਨਿਵੇਦਯਾਮਾਸੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ਤਦਾ ਪੀਲਾਤਸ੍ਤਾਨਾਚਖ੍ਯੌ ਤਰ੍ਹਿ ਕਿੰ ਯਿਹੂਦੀਯਾਨਾਂ ਰਾਜਾਨੰ ਮੋਚਯਿਸ਼਼੍ਯਾਮਿ? ਯੁਸ਼਼੍ਮਾਭਿਃ ਕਿਮਿਸ਼਼੍ਯਤੇ? ");
INSERT INTO sanpun_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ਯਤਃ ਪ੍ਰਧਾਨਯਾਜਕਾ ਈਰ੍ਸ਼਼੍ਯਾਤ ਏਵ ਯੀਸ਼ੁੰ ਸਮਾਰ੍ਪਯੰਨਿਤਿ ਸ ਵਿਵੇਦ| ");
INSERT INTO sanpun_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","ਕਿਨ੍ਤੁ ਯਥਾ ਬਰੱਬਾਂ ਮੋਚਯਤਿ ਤਥਾ ਪ੍ਰਾਰ੍ਥਯਿਤੁੰ ਪ੍ਰਧਾਨਯਾਜਕਾ ਲੋਕਾਨ੍ ਪ੍ਰਵਰ੍ੱਤਯਾਮਾਸੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ਅਥ ਪੀਲਾਤਃ ਪੁਨਃ ਪ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍ ਤਰ੍ਹਿ ਯੰ ਯਿਹੂਦੀਯਾਨਾਂ ਰਾਜੇਤਿ ਵਦਥ ਤਸ੍ਯ ਕਿੰ ਕਰਿਸ਼਼੍ਯਾਮਿ ਯੁਸ਼਼੍ਮਾਭਿਃ ਕਿਮਿਸ਼਼੍ਯਤੇ? ");
INSERT INTO sanpun_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","ਤਦਾ ਤੇ ਪੁਨਰਪਿ ਪ੍ਰੋੱਚੈਃ ਪ੍ਰੋਚੁਸ੍ਤੰ ਕ੍ਰੁਸ਼ੇ ਵੇਧਯ| ");
INSERT INTO sanpun_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ਤਸ੍ਮਾਤ੍ ਪੀਲਾਤਃ ਕਥਿਤਵਾਨ੍ ਕੁਤਃ? ਸ ਕਿੰ ਕੁਕਰ੍ੰਮ ਕ੍ਰੁʼਤਵਾਨ੍? ਕਿਨ੍ਤੁ ਤੇ ਪੁਨਸ਼੍ਚ ਰੁਵਨ੍ਤੋ ਵ੍ਯਾਜਹ੍ਰੁਸ੍ਤੰ ਕ੍ਰੁਸ਼ੇ ਵੇਧਯ| ");
INSERT INTO sanpun_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ਤਦਾ ਪੀਲਾਤਃ ਸਰ੍ੱਵਾੱਲੋਕਾਨ੍ ਤੋਸ਼਼ਯਿਤੁਮਿੱਛਨ੍ ਬਰੱਬਾਂ ਮੋਚਯਿਤ੍ਵਾ ਯੀਸ਼ੁੰ ਕਸ਼ਾਭਿਃ ਪ੍ਰਹ੍ਰੁʼਤ੍ਯ ਕ੍ਰੁਸ਼ੇ ਵੇੱਧੁੰ ਤੰ ਸਮਰ੍ਪਯਾਮ੍ਬਭੂਵ| ");
INSERT INTO sanpun_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ਅਨਨ੍ਤਰੰ ਸੈਨ੍ਯਗਣੋ(ਅ)ੱਟਾਲਿਕਾਮ੍ ਅਰ੍ਥਾਦ੍ ਅਧਿਪਤੇ ਰ੍ਗ੍ਰੁʼਹੰ ਯੀਸ਼ੁੰ ਨੀਤ੍ਵਾ ਸੇਨਾਨਿਵਹੰ ਸਮਾਹੁਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ਪਸ਼੍ਚਾਤ੍ ਤੇ ਤੰ ਧੂਮਲਵਰ੍ਣਵਸ੍ਤ੍ਰੰ ਪਰਿਧਾਪ੍ਯ ਕਣ੍ਟਕਮੁਕੁਟੰ ਰਚਯਿਤ੍ਵਾ ਸ਼ਿਰਸਿ ਸਮਾਰੋਪ੍ਯ ");
INSERT INTO sanpun_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ਹੇ ਯਿਹੂਦੀਯਾਨਾਂ ਰਾਜਨ੍ ਨਮਸ੍ਕਾਰ ਇਤ੍ਯੁਕ੍ਤ੍ਵਾ ਤੰ ਨਮਸ੍ਕਰ੍ੱਤਾਮਾਰੇਭਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ਤਸ੍ਯੋੱਤਮਾਙ੍ਗੇ ਵੇਤ੍ਰਾਘਾਤੰ ਚਕ੍ਰੁਸ੍ਤਦ੍ਗਾਤ੍ਰੇ ਨਿਸ਼਼੍ਠੀਵਞ੍ਚ ਨਿਚਿਕ੍ਸ਼਼ਿਪੁਃ, ਤਥਾ ਤਸ੍ਯ ਸੰਮੁਖੇ ਜਾਨੁਪਾਤੰ ਪ੍ਰਣੋਮੁਃ ");
INSERT INTO sanpun_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ਇੱਥਮੁਪਹਸ੍ਯ ਧੂਮ੍ਰਵਰ੍ਣਵਸ੍ਤ੍ਰਮ੍ ਉੱਤਾਰ੍ੱਯ ਤਸ੍ਯ ਵਸ੍ਤ੍ਰੰ ਤੰ ਪਰ੍ੱਯਧਾਪਯਨ੍ ਕ੍ਰੁਸ਼ੇ ਵੇੱਧੁੰ ਬਹਿਰ੍ਨਿਨ੍ਯੁਸ਼੍ਚ| ");
INSERT INTO sanpun_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","ਤਤਃ ਪਰੰ ਸੇਕਨ੍ਦਰਸ੍ਯ ਰੁਫਸ੍ਯ ਚ ਪਿਤਾ ਸ਼ਿਮੋੰਨਾਮਾ ਕੁਰੀਣੀਯਲੋਕ ਏਕਃ ਕੁਤਸ਼੍ਚਿਦ੍ ਗ੍ਰਾਮਾਦੇਤ੍ਯ ਪਥਿ ਯਾਤਿ ਤੰ ਤੇ ਯੀਸ਼ੋਃ ਕ੍ਰੁਸ਼ੰ ਵੋਢੁੰ ਬਲਾਦ੍ ਦਧ੍ਨੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ਅਥ ਗੁਲ੍ਗਲ੍ਤਾ ਅਰ੍ਥਾਤ੍ ਸ਼ਿਰਃਕਪਾਲਨਾਮਕੰ ਸ੍ਥਾਨੰ ਯੀਸ਼ੁਮਾਨੀਯ ");
INSERT INTO sanpun_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ਤੇ ਗਨ੍ਧਰਸਮਿਸ਼੍ਰਿਤੰ ਦ੍ਰਾਕ੍ਸ਼਼ਾਰਸੰ ਪਾਤੁੰ ਤਸ੍ਮੈ ਦਦੁਃ ਕਿਨ੍ਤੁ ਸ ਨ ਜਗ੍ਰਾਹ| ");
INSERT INTO sanpun_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ਤਸ੍ਮਿਨ੍ ਕ੍ਰੁਸ਼ੇ ਵਿੱਧੇ ਸਤਿ ਤੇਸ਼਼ਾਮੇਕੈਕਸ਼ਃ ਕਿੰ ਪ੍ਰਾਪ੍ਸ੍ਯਤੀਤਿ ਨਿਰ੍ਣਯਾਯ ");
INSERT INTO sanpun_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ਤਸ੍ਯ ਪਰਿਧੇਯਾਨਾਂ ਵਿਭਾਗਾਰ੍ਥੰ ਗੁਟਿਕਾਪਾਤੰ ਚਕ੍ਰੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ਅਪਰਮ੍ ਏਸ਼਼ ਯਿਹੂਦੀਯਾਨਾਂ ਰਾਜੇਤਿ ਲਿਖਿਤੰ ਦੋਸ਼਼ਪਤ੍ਰੰ ਤਸ੍ਯ ਸ਼ਿਰਊਰ੍ਦ੍ੱਵਮ੍ ਆਰੋਪਯਾਞ੍ਚਕ੍ਰੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ਤਸ੍ਯ ਵਾਮਦਕ੍ਸ਼਼ਿਣਯੋ ਰ੍ਦ੍ਵੌ ਚੌਰੌ ਕ੍ਰੁਸ਼ਯੋ ਰ੍ਵਿਵਿਧਾਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","ਤੇਨੈਵ \"ਅਪਰਾਧਿਜਨੈਃ ਸਾਰ੍ੱਧੰ ਸ ਗਣਿਤੋ ਭਵਿਸ਼਼੍ਯਤਿ,\" ਇਤਿ ਸ਼ਾਸ੍ਤ੍ਰੋਕ੍ਤੰ ਵਚਨੰ ਸਿੱਧਮਭੂਤ| ");
INSERT INTO sanpun_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","ਅਨਨ੍ਤਰੰ ਮਾਰ੍ਗੇ ਯੇ ਯੇ ਲੋਕਾ ਗਮਨਾਗਮਨੇ ਚਕ੍ਰੁਸ੍ਤੇ ਸਰ੍ੱਵ ਏਵ ਸ਼ਿਰਾਂਸ੍ਯਾਨ੍ਦੋਲ੍ਯ ਨਿਨ੍ਦਨ੍ਤੋ ਜਗਦੁਃ, ਰੇ ਮਨ੍ਦਿਰਨਾਸ਼ਕ ਰੇ ਦਿਨਤ੍ਰਯਮਧ੍ਯੇ ਤੰਨਿਰ੍ੰਮਾਯਕ, ");
INSERT INTO sanpun_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ਅਧੁਨਾਤ੍ਮਾਨਮ੍ ਅਵਿਤ੍ਵਾ ਕ੍ਰੁਸ਼ਾਦਵਰੋਹ| ");
INSERT INTO sanpun_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","ਕਿਞ੍ਚ ਪ੍ਰਧਾਨਯਾਜਕਾ ਅਧ੍ਯਾਪਕਾਸ਼੍ਚ ਤਦ੍ਵਤ੍ ਤਿਰਸ੍ਕ੍ਰੁʼਤ੍ਯ ਪਰਸ੍ਪਰੰ ਚਚਕ੍ਸ਼਼ਿਰੇ ਏਸ਼਼ ਪਰਾਨਾਵਤ੍ ਕਿਨ੍ਤੁ ਸ੍ਵਮਵਿਤੁੰ ਨ ਸ਼ਕ੍ਨੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ਯਦੀਸ੍ਰਾਯੇਲੋ ਰਾਜਾਭਿਸ਼਼ਿਕ੍ਤਸ੍ਤ੍ਰਾਤਾ ਭਵਤਿ ਤਰ੍ਹ੍ਯਧੁਨੈਨ ਕ੍ਰੁਸ਼ਾਦਵਰੋਹਤੁ ਵਯੰ ਤਦ੍ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਵਿਸ਼੍ਵਸਿਸ਼਼੍ਯਾਮਃ; ਕਿਞ੍ਚ ਯੌ ਲੋਕੌ ਤੇਨ ਸਾਰ੍ੱਧੰ ਕ੍ਰੁਸ਼ੇ (ਅ)ਵਿਧ੍ਯੇਤਾਂ ਤਾਵਪਿ ਤੰ ਨਿਰ੍ਭਰ੍ਤ੍ਸਯਾਮਾਸਤੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","ਅਥ ਦ੍ਵਿਤੀਯਯਾਮਾਤ੍ ਤ੍ਰੁʼਤੀਯਯਾਮੰ ਯਾਵਤ੍ ਸਰ੍ੱਵੋ ਦੇਸ਼ਃ ਸਾਨ੍ਧਕਾਰੋਭੂਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ਤਤਸ੍ਤ੍ਰੁʼਤੀਯਪ੍ਰਹਰੇ ਯੀਸ਼ੁਰੁੱਚੈਰਵਦਤ੍ ਏਲੀ ਏਲੀ ਲਾਮਾ ਸ਼ਿਵਕ੍ਤਨੀ ਅਰ੍ਥਾਦ੍ \"ਹੇ ਮਦੀਸ਼ ਮਦੀਸ਼ ਤ੍ਵੰ ਪਰ੍ੱਯਤ੍ਯਾਕ੍ਸ਼਼ੀਃ ਕੁਤੋ ਹਿ ਮਾਂ?\" ");
INSERT INTO sanpun_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ਤਦਾ ਸਮੀਪਸ੍ਥਲੋਕਾਨਾਂ ਕੇਚਿਤ੍ ਤਦ੍ਵਾਕ੍ਯੰ ਨਿਸ਼ਮ੍ਯਾਚਖ੍ਯੁਃ ਪਸ਼੍ਯੈਸ਼਼ ਏਲਿਯਮ੍ ਆਹੂਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","ਤਤ ਏਕੋ ਜਨੋ ਧਾਵਿਤ੍ਵਾਗਤ੍ਯ ਸ੍ਪਞ੍ਜੇ (ਅ)ਮ੍ਲਰਸੰ ਪੂਰਯਿਤ੍ਵਾ ਤੰ ਨਡਾਗ੍ਰੇ ਨਿਧਾਯ ਪਾਤੁੰ ਤਸ੍ਮੈ ਦੱਤ੍ਵਾਵਦਤ੍ ਤਿਸ਼਼੍ਠ ਏਲਿਯ ਏਨਮਵਰੋਹਯਿਤੁਮ੍ ਏਤਿ ਨ ਵੇਤਿ ਪਸ਼੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","ਅਥ ਯੀਸ਼ੁਰੁੱਚੈਃ ਸਮਾਹੂਯ ਪ੍ਰਾਣਾਨ੍ ਜਹੌ| ");
INSERT INTO sanpun_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ਤਦਾ ਮਨ੍ਦਿਰਸ੍ਯ ਜਵਨਿਕੋਰ੍ਦ੍ੱਵਾਦਧਃਰ੍ੱਯਨ੍ਤਾ ਵਿਦੀਰ੍ਣਾ ਦ੍ਵਿਖਣ੍ਡਾਭੂਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","ਕਿਞ੍ਚ ਇੱਥਮੁੱਚੈਰਾਹੂਯ ਪ੍ਰਾਣਾਨ੍ ਤ੍ਯਜਨ੍ਤੰ ਤੰ ਦ੍ਰੁʼਸ਼਼੍ਦ੍ਵਾ ਤਦ੍ਰਕ੍ਸ਼਼ਣਾਯ ਨਿਯੁਕ੍ਤੋ ਯਃ ਸੇਨਾਪਤਿਰਾਸੀਤ੍ ਸੋਵਦਤ੍ ਨਰੋਯਮ੍ ਈਸ਼੍ਵਰਪੁਤ੍ਰ ਇਤਿ ਸਤ੍ਯਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","ਤਦਾਨੀਂ ਮਗ੍ਦਲੀਨੀ ਮਰਿਸਮ੍ ਕਨਿਸ਼਼੍ਠਯਾਕੂਬੋ ਯੋਸੇਸ਼੍ਚ ਮਾਤਾਨ੍ਯਮਰਿਯਮ੍ ਸ਼ਾਲੋਮੀ ਚ ਯਾਃ ਸ੍ਤ੍ਰਿਯੋ ");
INSERT INTO sanpun_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","ਗਾਲੀਲ੍ਪ੍ਰਦੇਸ਼ੇ ਯੀਸ਼ੁੰ ਸੇਵਿਤ੍ਵਾ ਤਦਨੁਗਾਮਿਨ੍ਯੋ ਜਾਤਾ ਇਮਾਸ੍ਤਦਨ੍ਯਾਸ਼੍ਚ ਯਾ ਅਨੇਕਾ ਨਾਰ੍ਯੋ ਯੀਸ਼ੁਨਾ ਸਾਰ੍ੱਧੰ ਯਿਰੂਸ਼ਾਲਮਮਾਯਾਤਾਸ੍ਤਾਸ਼੍ਚ ਦੂਰਾਤ੍ ਤਾਨਿ ਦਦ੍ਰੁʼਸ਼ੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","ਅਥਾਸਾਦਨਦਿਨਸ੍ਯਾਰ੍ਥਾਦ੍ ਵਿਸ਼੍ਰਾਮਵਾਰਾਤ੍ ਪੂਰ੍ੱਵਦਿਨਸ੍ਯ ਸਾਯੰਕਾਲ ਆਗਤ ");
INSERT INTO sanpun_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ਈਸ਼੍ਵਰਰਾਜ੍ਯਾਪੇਕ੍ਸ਼਼੍ਯਰਿਮਥੀਯਯੂਸ਼਼ਫਨਾਮਾ ਮਾਨ੍ਯਮਨ੍ਤ੍ਰੀ ਸਮੇਤ੍ਯ ਪੀਲਾਤਸਵਿਧੰ ਨਿਰ੍ਭਯੋ ਗਤ੍ਵਾ ਯੀਸ਼ੋਰ੍ਦੇਹੰ ਯਯਾਚੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ਕਿਨ੍ਤੁ ਸ ਇਦਾਨੀਂ ਮ੍ਰੁʼਤਃ ਪੀਲਾਤ ਇਤ੍ਯਸਮ੍ਭਵੰ ਮਤ੍ਵਾ ਸ਼ਤਸੇਨਾਪਤਿਮਾਹੂਯ ਸ ਕਦਾ ਮ੍ਰੁʼਤ ਇਤਿ ਪਪ੍ਰੱਛ| ");
INSERT INTO sanpun_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ਸ਼ਤਸੇਮਨਾਪਤਿਮੁਖਾਤ੍ ਤੱਜ੍ਞਾਤ੍ਵਾ ਯੂਸ਼਼ਫੇ ਯੀਸ਼ੋਰ੍ਦੇਹੰ ਦਦੌ| ");
INSERT INTO sanpun_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","ਪਸ਼੍ਚਾਤ੍ ਸ ਸੂਕ੍ਸ਼਼੍ਮੰ ਵਾਸਃ ਕ੍ਰੀਤ੍ਵਾ ਯੀਸ਼ੋਃ ਕਾਯਮਵਰੋਹ੍ਯ ਤੇਨ ਵਾਸਸਾ ਵੇਸ਼਼੍ਟਾਯਿਤ੍ਵਾ ਗਿਰੌ ਖਾਤਸ਼੍ਮਸ਼ਾਨੇ ਸ੍ਥਾਪਿਤਵਾਨ੍ ਪਾਸ਼਼ਾਣੰ ਲੋਠਯਿਤ੍ਵਾ ਦ੍ਵਾਰਿ ਨਿਦਧੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","ਕਿਨ੍ਤੁ ਯਤ੍ਰ ਸੋਸ੍ਥਾਪ੍ਯਤ ਤਤ ਮਗ੍ਦਲੀਨੀ ਮਰਿਯਮ੍ ਯੋਸਿਮਾਤ੍ਰੁʼਮਰਿਯਮ੍ ਚ ਦਦ੍ਰੁʼਸ਼ਤ੍ਰੁʼਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ਅਥ ਵਿਸ਼੍ਰਾਮਵਾਰੇ ਗਤੇ ਮਗ੍ਦਲੀਨੀ ਮਰਿਯਮ੍ ਯਾਕੂਬਮਾਤਾ ਮਰਿਯਮ੍ ਸ਼ਾਲੋਮੀ ਚੇਮਾਸ੍ਤੰ ਮਰ੍ੱਦਯਿਤੁੰ ਸੁਗਨ੍ਧਿਦ੍ਰਵ੍ਯਾਣਿ ਕ੍ਰੀਤ੍ਵਾ ");
INSERT INTO sanpun_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ਸਪ੍ਤਾਹਪ੍ਰਥਮਦਿਨੇ(ਅ)ਤਿਪ੍ਰਤ੍ਯੂਸ਼਼ੇ ਸੂਰ੍ੱਯੋਦਯਕਾਲੇ ਸ਼੍ਮਸ਼ਾਨਮੁਪਗਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ਕਿਨ੍ਤੁ ਸ਼੍ਮਸ਼ਾਨਦ੍ਵਾਰਪਾਸ਼਼ਾਣੋ(ਅ)ਤਿਬ੍ਰੁʼਹਨ੍ ਤੰ ਕੋ(ਅ)ਪਸਾਰਯਿਸ਼਼੍ਯਤੀਤਿ ਤਾਃ ਪਰਸ੍ਪਰੰ ਗਦਨ੍ਤਿ! ");
INSERT INTO sanpun_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ਏਤਰ੍ਹਿ ਨਿਰੀਕ੍ਸ਼਼੍ਯ ਪਾਸ਼਼ਾਣੋ ਦ੍ਵਾਰੋ (ਅ)ਪਸਾਰਿਤ ਇਤਿ ਦਦ੍ਰੁʼਸ਼ੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ਪਸ਼੍ਚਾੱਤਾਃ ਸ਼੍ਮਸ਼ਾਨੰ ਪ੍ਰਵਿਸ਼੍ਯ ਸ਼ੁਕ੍ਲਵਰ੍ਣਦੀਰ੍ਘਪਰਿੱਛਦਾਵ੍ਰੁʼਤਮੇਕੰ ਯੁਵਾਨੰ ਸ਼੍ਮਸ਼ਾਨਦਕ੍ਸ਼਼ਿਣਪਾਰ੍ਸ਼੍ਵ ਉਪਵਿਸ਼਼੍ਟੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਚਮੱਚਕ੍ਰੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ਸੋ(ਅ)ਵਦਤ੍, ਮਾਭੈਸ਼਼੍ਟ ਯੂਯੰ ਕ੍ਰੁਸ਼ੇ ਹਤੰ ਨਾਸਰਤੀਯਯੀਸ਼ੁੰ ਗਵੇਸ਼਼ਯਥ ਸੋਤ੍ਰ ਨਾਸ੍ਤਿ ਸ਼੍ਮਸ਼ਾਨਾਦੁਦਸ੍ਥਾਤ੍; ਤੈ ਰ੍ਯਤ੍ਰ ਸ ਸ੍ਥਾਪਿਤਃ ਸ੍ਥਾਨੰ ਤਦਿਦੰ ਪਸ਼੍ਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","ਕਿਨ੍ਤੁ ਤੇਨ ਯਥੋਕ੍ਤੰ ਤਥਾ ਯੁਸ਼਼੍ਮਾਕਮਗ੍ਰੇ ਗਾਲੀਲੰ ਯਾਸ੍ਯਤੇ ਤਤ੍ਰ ਸ ਯੁਸ਼਼੍ਮਾਨ੍ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਕਰਿਸ਼਼੍ਯਤੇ ਯੂਯੰ ਗਤ੍ਵਾ ਤਸ੍ਯ ਸ਼ਿਸ਼਼੍ਯੇਭ੍ਯਃ ਪਿਤਰਾਯ ਚ ਵਾਰ੍ੱਤਾਮਿਮਾਂ ਕਥਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ਤਾਃ ਕਮ੍ਪਿਤਾ ਵਿਸ੍ਤਿਤਾਸ਼੍ਚ ਤੂਰ੍ਣੰ ਸ਼੍ਮਸ਼ਾਨਾਦ੍ ਬਹਿਰ੍ਗਤ੍ਵਾ ਪਲਾਯਨ੍ਤ ਭਯਾਤ੍ ਕਮਪਿ ਕਿਮਪਿ ਨਾਵਦੰਸ਼੍ਚ| ");
INSERT INTO sanpun_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","ਅਪਰੰ ਯੀਸ਼ੁਃ ਸਪ੍ਤਾਹਪ੍ਰਥਮਦਿਨੇ ਪ੍ਰਤ੍ਯੂਸ਼਼ੇ ਸ਼੍ਮਸ਼ਾਨਾਦੁੱਥਾਯ ਯਸ੍ਯਾਃ ਸਪ੍ਤਭੂਤਾਸ੍ਤ੍ਯਾਜਿਤਾਸ੍ਤਸ੍ਯੈ ਮਗ੍ਦਲੀਨੀਮਰਿਯਮੇ ਪ੍ਰਥਮੰ ਦਰ੍ਸ਼ਨੰ ਦਦੌ| ");
INSERT INTO sanpun_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ਤਤਃ ਸਾ ਗਤ੍ਵਾ ਸ਼ੋਕਰੋਦਨਕ੍ਰੁʼਦ੍ਭ੍ਯੋ(ਅ)ਨੁਗਤਲੋਕੇਭ੍ਯਸ੍ਤਾਂ ਵਾਰ੍ੱਤਾਂ ਕਥਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","ਕਿਨ੍ਤੁ ਯੀਸ਼ੁਃ ਪੁਨਰ੍ਜੀਵਨ੍ ਤਸ੍ਯੈ ਦਰ੍ਸ਼ਨੰ ਦੱਤਵਾਨਿਤਿ ਸ਼੍ਰੁਤ੍ਵਾ ਤੇ ਨ ਪ੍ਰਤ੍ਯਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ਪਸ਼੍ਚਾਤ੍ ਤੇਸ਼਼ਾਂ ਦ੍ਵਾਯੋ ਰ੍ਗ੍ਰਾਮਯਾਨਕਾਲੇ ਯੀਸ਼ੁਰਨ੍ਯਵੇਸ਼ੰ ਧ੍ਰੁʼਤ੍ਵਾ ਤਾਭ੍ਯਾਂ ਦਰ੍ਸ਼ਨ ਦਦੌ! ");
INSERT INTO sanpun_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ਤਾਵਪਿ ਗਤ੍ਵਾਨ੍ਯਸ਼ਿਸ਼਼੍ਯੇਭ੍ਯਸ੍ਤਾਂ ਕਥਾਂ ਕਥਯਾਞ੍ਚਕ੍ਰਤੁਃ ਕਿਨ੍ਤੁ ਤਯੋਃ ਕਥਾਮਪਿ ਤੇ ਨ ਪ੍ਰਤ੍ਯਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ਸ਼ੇਸ਼਼ਤ ਏਕਾਦਸ਼ਸ਼ਿਸ਼਼੍ਯੇਸ਼਼ੁ ਭੋਜਨੋਪਵਿਸ਼਼੍ਟੇਸ਼਼ੁ ਯੀਸ਼ੁਸ੍ਤੇਭ੍ਯੋ ਦਰ੍ਸ਼ਨੰ ਦਦੌ ਤਥੋੱਥਾਨਾਤ੍ ਪਰੰ ਤੱਦਰ੍ਸ਼ਨਪ੍ਰਾਪ੍ਤਲੋਕਾਨਾਂ ਕਥਾਯਾਮਵਿਸ਼੍ਵਾਸਕਰਣਾਤ੍ ਤੇਸ਼਼ਾਮਵਿਸ਼੍ਵਾਸਮਨਃਕਾਠਿਨ੍ਯਾਭ੍ਯਾਂ ਹੇਤੁਭ੍ਯਾਂ ਸ ਤਾਂਸ੍ਤਰ੍ਜਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ਅਥ ਤਾਨਾਚਖ੍ਯੌ ਯੂਯੰ ਸਰ੍ੱਵਜਗਦ੍ ਗਤ੍ਵਾ ਸਰ੍ੱਵਜਨਾਨ੍ ਪ੍ਰਤਿ ਸੁਸੰਵਾਦੰ ਪ੍ਰਚਾਰਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ਤਤ੍ਰ ਯਃ ਕਸ਼੍ਚਿਦ੍ ਵਿਸ਼੍ਵਸ੍ਯ ਮੱਜਿਤੋ ਭਵੇਤ੍ ਸ ਪਰਿਤ੍ਰਾਸ੍ਯਤੇ ਕਿਨ੍ਤੁ ਯੋ ਨ ਵਿਸ਼੍ਵਸਿਸ਼਼੍ਯਤਿ ਸ ਦਣ੍ਡਯਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","ਕਿਞ੍ਚ ਯੇ ਪ੍ਰਤ੍ਯੇਸ਼਼੍ਯਨ੍ਤਿ ਤੈਰੀਦ੍ਰੁʼਗ੍ ਆਸ਼੍ਚਰ੍ੱਯੰ ਕਰ੍ੰਮ ਪ੍ਰਕਾਸ਼ਯਿਸ਼਼੍ਯਤੇ ਤੇ ਮੰਨਾਮ੍ਨਾ ਭੂਤਾਨ੍ ਤ੍ਯਾਜਯਿਸ਼਼੍ਯਨ੍ਤਿ ਭਾਸ਼਼ਾ ਅਨ੍ਯਾਸ਼੍ਚ ਵਦਿਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ਅਪਰੰ ਤੈਃ ਸਰ੍ਪੇਸ਼਼ੁ ਧ੍ਰੁʼਤੇਸ਼਼ੁ ਪ੍ਰਾਣਨਾਸ਼ਕਵਸ੍ਤੁਨਿ ਪੀਤੇ ਚ ਤੇਸ਼਼ਾਂ ਕਾਪਿ ਕ੍ਸ਼਼ਤਿ ਰ੍ਨ ਭਵਿਸ਼਼੍ਯਤਿ; ਰੋਗਿਣਾਂ ਗਾਤ੍ਰੇਸ਼਼ੁ ਕਰਾਰ੍ਪਿਤੇ ਤੇ(ਅ)ਰੋਗਾ ਭਵਿਸ਼਼੍ਯਨ੍ਤਿ ਚ| ");
INSERT INTO sanpun_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","ਅਥ ਪ੍ਰਭੁਸ੍ਤਾਨਿਤ੍ਯਾਦਿਸ਼੍ਯ ਸ੍ਵਰ੍ਗੰ ਨੀਤਃ ਸਨ੍ ਪਰਮੇਸ਼੍ਵਰਸ੍ਯ ਦਕ੍ਸ਼਼ਿਣ ਉਪਵਿਵੇਸ਼| ");
INSERT INTO sanpun_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ਤਤਸ੍ਤੇ ਪ੍ਰਸ੍ਥਾਯ ਸਰ੍ੱਵਤ੍ਰ ਸੁਸੰਵਾਦੀਯਕਥਾਂ ਪ੍ਰਚਾਰਯਿਤੁਮਾਰੇਭਿਰੇ ਪ੍ਰਭੁਸ੍ਤੁ ਤੇਸ਼਼ਾਂ ਸਹਾਯਃ ਸਨ੍ ਪ੍ਰਕਾਸ਼ਿਤਾਸ਼੍ਚਰ੍ੱਯਕ੍ਰਿਯਾਭਿਸ੍ਤਾਂ ਕਥਾਂ ਪ੍ਰਮਾਣਵਤੀਂ ਚਕਾਰ| ਇਤਿ|");
INSERT INTO sanpun_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","ਪ੍ਰਥਮਤੋ ਯੇ ਸਾਕ੍ਸ਼਼ਿਣੋ ਵਾਕ੍ਯਪ੍ਰਚਾਰਕਾਸ਼੍ਚਾਸਨ੍ ਤੇ(ਅ)ਸ੍ਮਾਕੰ ਮਧ੍ਯੇ ਯਦ੍ਯਤ੍ ਸਪ੍ਰਮਾਣੰ ਵਾਕ੍ਯਮਰ੍ਪਯਨ੍ਤਿ ਸ੍ਮ ");
INSERT INTO sanpun_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ਤਦਨੁਸਾਰਤੋ(ਅ)ਨ੍ਯੇਪਿ ਬਹਵਸ੍ਤਦ੍ਵ੍ਰੁʼੱਤਾਨ੍ਤੰ ਰਚਯਿਤੁੰ ਪ੍ਰਵ੍ਰੁʼੱਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ਅਤਏਵ ਹੇ ਮਹਾਮਹਿਮਥਿਯਫਿਲ੍ ਤ੍ਵੰ ਯਾ ਯਾਃ ਕਥਾ ਅਸ਼ਿਕ੍ਸ਼਼੍ਯਥਾਸ੍ਤਾਸਾਂ ਦ੍ਰੁʼਢਪ੍ਰਮਾਣਾਨਿ ਯਥਾ ਪ੍ਰਾਪ੍ਨੋਸ਼਼ਿ ");
INSERT INTO sanpun_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ਤਦਰ੍ਥੰ ਪ੍ਰਥਮਮਾਰਭ੍ਯ ਤਾਨਿ ਸਰ੍ੱਵਾਣਿ ਜ੍ਞਾਤ੍ਵਾਹਮਪਿ ਅਨੁਕ੍ਰਮਾਤ੍ ਸਰ੍ੱਵਵ੍ਰੁʼੱਤਾਨ੍ਤਾਨ੍ ਤੁਭ੍ਯੰ ਲੇਖਿਤੁੰ ਮਤਿਮਕਾਰ੍ਸ਼਼ਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ਯਿਹੂਦਾਦੇਸ਼ੀਯਹੇਰੋਦ੍ਨਾਮਕੇ ਰਾਜਤ੍ਵੰ ਕੁਰ੍ੱਵਤਿ ਅਬੀਯਯਾਜਕਸ੍ਯ ਪਰ੍ੱਯਾਯਾਧਿਕਾਰੀ ਸਿਖਰਿਯਨਾਮਕ ਏਕੋ ਯਾਜਕੋ ਹਾਰੋਣਵੰਸ਼ੋਦ੍ਭਵਾ ਇਲੀਸ਼ੇਵਾਖ੍ਯਾ ");
INSERT INTO sanpun_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ਤਸ੍ਯ ਜਾਯਾ ਦ੍ਵਾਵਿਮੌ ਨਿਰ੍ਦੋਸ਼਼ੌ ਪ੍ਰਭੋਃ ਸਰ੍ੱਵਾਜ੍ਞਾ ਵ੍ਯਵਸ੍ਥਾਸ਼੍ਚ ਸੰਮਨ੍ਯ ਈਸ਼੍ਵਰਦ੍ਰੁʼਸ਼਼੍ਟੌ ਧਾਰ੍ੰਮਿਕਾਵਾਸ੍ਤਾਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","ਤਯੋਃ ਸਨ੍ਤਾਨ ਏਕੋਪਿ ਨਾਸੀਤ੍, ਯਤ ਇਲੀਸ਼ੇਵਾ ਬਨ੍ਧ੍ਯਾ ਤੌ ਦ੍ਵਾਵੇਵ ਵ੍ਰੁʼੱਧਾਵਭਵਤਾਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","ਯਦਾ ਸ੍ਵਪਰ੍ੱਯਾਨੁਕ੍ਰਮੇਣ ਸਿਖਰਿਯ ਈਸ਼੍ਵਾਸ੍ਯ ਸਮਕ੍ਸ਼਼ੰ ਯਾਜਕੀਯੰ ਕਰ੍ੰਮ ਕਰੋਤਿ ");
INSERT INTO sanpun_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ਤਦਾ ਯਜ੍ਞਸ੍ਯ ਦਿਨਪਰਿਪਾੱਯਾ ਪਰਮੇਸ਼੍ਵਰਸ੍ਯ ਮਨ੍ਦਿਰੇ ਪ੍ਰਵੇਸ਼ਕਾਲੇ ਧੂਪਜ੍ਵਾਲਨੰ ਕਰ੍ੰਮ ਤਸ੍ਯ ਕਰਣੀਯਮਾਸੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ਤੱਧੂਪਜ੍ਵਾਲਨਕਾਲੇ ਲੋਕਨਿਵਹੇ ਪ੍ਰਾਰ੍ਥਨਾਂ ਕਰ੍ਤੁੰ ਬਹਿਸ੍ਤਿਸ਼਼੍ਠਤਿ ");
INSERT INTO sanpun_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ਸਤਿ ਸਿਖਰਿਯੋ ਯਸ੍ਯਾਂ ਵੇਦ੍ਯਾਂ ਧੂਪੰ ਜ੍ਵਾਲਯਤਿ ਤੱਦਕ੍ਸ਼਼ਿਣਪਾਰ੍ਸ਼੍ਵੇ ਪਰਮੇਸ਼੍ਵਰਸ੍ਯ ਦੂਤ ਏਕ ਉਪਸ੍ਥਿਤੋ ਦਰ੍ਸ਼ਨੰ ਦਦੌ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ਤੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਸਿਖਰਿਯ ਉਦ੍ਵਿਵਿਜੇ ਸ਼ਸ਼ਙ੍ਕੇ ਚ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","ਤਦਾ ਸ ਦੂਤਸ੍ਤੰ ਬਭਾਸ਼਼ੇ ਹੇ ਸਿਖਰਿਯ ਮਾ ਭੈਸ੍ਤਵ ਪ੍ਰਾਰ੍ਥਨਾ ਗ੍ਰਾਹ੍ਯਾ ਜਾਤਾ ਤਵ ਭਾਰ੍ੱਯਾ ਇਲੀਸ਼ੇਵਾ ਪੁਤ੍ਰੰ ਪ੍ਰਸੋਸ਼਼੍ਯਤੇ ਤਸ੍ਯ ਨਾਮ ਯੋेਹਨ੍ ਇਤਿ ਕਰਿਸ਼਼੍ਯਸਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ਕਿਞ੍ਚ ਤ੍ਵੰ ਸਾਨਨ੍ਦਃ ਸਹਰ੍ਸ਼਼ਸ਼੍ਚ ਭਵਿਸ਼਼੍ਯਸਿ ਤਸ੍ਯ ਜਨ੍ਮਨਿ ਬਹਵ ਆਨਨ੍ਦਿਸ਼਼੍ਯਨ੍ਤਿ ਚ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ਯਤੋ ਹੇਤੋਃ ਸ ਪਰਮੇਸ਼੍ਵਰਸ੍ਯ ਗੋਚਰੇ ਮਹਾਨ੍ ਭਵਿਸ਼਼੍ਯਤਿ ਤਥਾ ਦ੍ਰਾਕ੍ਸ਼਼ਾਰਸੰ ਸੁਰਾਂ ਵਾ ਕਿਮਪਿ ਨ ਪਾਸ੍ਯਤਿ, ਅਪਰੰ ਜਨ੍ਮਾਰਭ੍ਯ ਪਵਿਤ੍ਰੇਣਾਤ੍ਮਨਾ ਪਰਿਪੂਰ੍ਣਃ ");
INSERT INTO sanpun_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","ਸਨ੍ ਇਸ੍ਰਾਯੇਲ੍ਵੰਸ਼ੀਯਾਨ੍ ਅਨੇਕਾਨ੍ ਪ੍ਰਭੋਃ ਪਰਮੇਸ਼੍ਵਰਸ੍ਯ ਮਾਰ੍ਗਮਾਨੇਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","ਸਨ੍ਤਾਨਾਨ੍ ਪ੍ਰਤਿ ਪਿਤ੍ਰੁʼਣਾਂ ਮਨਾਂਸਿ ਧਰ੍ੰਮਜ੍ਞਾਨੰ ਪ੍ਰਤ੍ਯਨਾਜ੍ਞਾਗ੍ਰਾਹਿਣਸ਼੍ਚ ਪਰਾਵਰ੍ੱਤਯਿਤੁੰ, ਪ੍ਰਭੋਃ ਪਰਮੇਸ਼੍ਵਰਸ੍ਯ ਸੇਵਾਰ੍ਥਮ੍ ਏਕਾਂ ਸੱਜਿਤਜਾਤਿੰ ਵਿਧਾਤੁਞ੍ਚ ਸ ਏਲਿਯਰੂਪਾਤ੍ਮਸ਼ਕ੍ਤਿਪ੍ਰਾਪ੍ਤਸ੍ਤਸ੍ਯਾਗ੍ਰੇ ਗਮਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ਤਦਾ ਸਿਖਰਿਯੋ ਦੂਤਮਵਾਦੀਤ੍ ਕਥਮੇਤਦ੍ ਵੇਤ੍ਸ੍ਯਾਮਿ? ਯਤੋਹੰ ਵ੍ਰੁʼੱਧੋ ਮਮ ਭਾਰ੍ੱਯਾ ਚ ਵ੍ਰੁʼੱਧਾ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ਤਤੋ ਦੂਤਃ ਪ੍ਰਤ੍ਯੁਵਾਚ ਪਸ਼੍ਯੇਸ਼੍ਵਰਸ੍ਯ ਸਾਕ੍ਸ਼਼ਾਦ੍ਵਰ੍ੱਤੀ ਜਿਬ੍ਰਾਯੇਲ੍ਨਾਮਾ ਦੂਤੋਹੰ ਤ੍ਵਯਾ ਸਹ ਕਥਾਂ ਗਦਿਤੁੰ ਤੁਭ੍ਯਮਿਮਾਂ ਸ਼ੁਭਵਾਰ੍ੱਤਾਂ ਦਾਤੁਞ੍ਚ ਪ੍ਰੇਸ਼਼ਿਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ਕਿਨ੍ਤੁ ਮਦੀਯੰ ਵਾਕ੍ਯੰ ਕਾਲੇ ਫਲਿਸ਼਼੍ਯਤਿ ਤਤ੍ ਤ੍ਵਯਾ ਨ ਪ੍ਰਤੀਤਮ੍ ਅਤਃ ਕਾਰਣਾਦ੍ ਯਾਵਦੇਵ ਤਾਨਿ ਨ ਸੇਤ੍ਸ੍ਯਨ੍ਤਿ ਤਾਵਤ੍ ਤ੍ਵੰ ਵਕ੍ਤੁੰਮਸ਼ਕ੍ਤੋ ਮੂਕੋ ਭਵ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","ਤਦਾਨੀਂ ਯੇ ਯੇ ਲੋਕਾਃ ਸਿਖਰਿਯਮਪੈਕ੍ਸ਼਼ਨ੍ਤ ਤੇ ਮਧ੍ਯੇਮਨ੍ਦਿਰੰ ਤਸ੍ਯ ਬਹੁਵਿਲਮ੍ਬਾਦ੍ ਆਸ਼੍ਚਰ੍ੱਯੰ ਮੇਨਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ਸ ਬਹਿਰਾਗਤੋ ਯਦਾ ਕਿਮਪਿ ਵਾਕ੍ਯੰ ਵਕ੍ਤੁਮਸ਼ਕ੍ਤਃ ਸਙ੍ਕੇਤੰ ਕ੍ਰੁʼਤ੍ਵਾ ਨਿਃਸ਼ਬ੍ਦਸ੍ਤਸ੍ਯੌ ਤਦਾ ਮਧ੍ਯੇਮਨ੍ਦਿਰੰ ਕਸ੍ਯਚਿਦ੍ ਦਰ੍ਸ਼ਨੰ ਤੇਨ ਪ੍ਰਾਪ੍ਤਮ੍ ਇਤਿ ਸਰ੍ੱਵੇ ਬੁਬੁਧਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ਅਨਨ੍ਤਰੰ ਤਸ੍ਯ ਸੇਵਨਪਰ੍ੱਯਾਯੇ ਸਮ੍ਪੂਰ੍ਣੇ ਸਤਿ ਸ ਨਿਜਗੇਹੰ ਜਗਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","ਕਤਿਪਯਦਿਨੇਸ਼਼ੁ ਗਤੇਸ਼਼ੁ ਤਸ੍ਯ ਭਾਰ੍ੱਯਾ ਇਲੀਸ਼ੇਵਾ ਗਰ੍ੱਭਵਤੀ ਬਭੂਵ ");
INSERT INTO sanpun_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ਪਸ਼੍ਚਾਤ੍ ਸਾ ਪਞ੍ਚਮਾਸਾਨ੍ ਸੰਗੋਪ੍ਯਾਕਥਯਤ੍ ਲੋਕਾਨਾਂ ਸਮਕ੍ਸ਼਼ੰ ਮਮਾਪਮਾਨੰ ਖਣ੍ਡਯਿਤੁੰ ਪਰਮੇਸ਼੍ਵਰੋ ਮਯਿ ਦ੍ਰੁʼਸ਼਼੍ਟਿੰ ਪਾਤਯਿਤ੍ਵਾ ਕਰ੍ੰਮੇਦ੍ਰੁʼਸ਼ੰ ਕ੍ਰੁʼਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ਅਪਰਞ੍ਚ ਤਸ੍ਯਾ ਗਰ੍ੱਭਸ੍ਯ ਸ਼਼ਸ਼਼੍ਠੇ ਮਾਸੇ ਜਾਤੇ ਗਾਲੀਲ੍ਪ੍ਰਦੇਸ਼ੀਯਨਾਸਰਤ੍ਪੁਰੇ ");
INSERT INTO sanpun_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ਦਾਯੂਦੋ ਵੰਸ਼ੀਯਾਯ ਯੂਸ਼਼ਫ੍ਨਾਮ੍ਨੇ ਪੁਰੁਸ਼਼ਾਯ ਯਾ ਮਰਿਯਮ੍ਨਾਮਕੁਮਾਰੀ ਵਾਗ੍ਦੱਤਾਸੀਤ੍ ਤਸ੍ਯਾਃ ਸਮੀਪੰ ਜਿਬ੍ਰਾਯੇਲ੍ ਦੂਤ ਈਸ਼੍ਵਰੇਣ ਪ੍ਰਹਿਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ਸ ਗਤ੍ਵਾ ਜਗਾਦ ਹੇ ਈਸ਼੍ਵਰਾਨੁਗ੍ਰੁʼਹੀਤਕਨ੍ਯੇ ਤਵ ਸ਼ੁਭੰ ਭੂਯਾਤ੍ ਪ੍ਰਭੁਃ ਪਰਮੇਸ਼੍ਵਰਸ੍ਤਵ ਸਹਾਯੋਸ੍ਤਿ ਨਾਰੀਣਾਂ ਮਧ੍ਯੇ ਤ੍ਵਮੇਵ ਧਨ੍ਯਾ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","ਤਦਾਨੀਂ ਸਾ ਤੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਤਸ੍ਯ ਵਾਕ੍ਯਤ ਉਦ੍ਵਿਜ੍ਯ ਕੀਦ੍ਰੁʼਸ਼ੰ ਭਾਸ਼਼ਣਮਿਦਮ੍ ਇਤਿ ਮਨਸਾ ਚਿਨ੍ਤਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ਤਤੋ ਦੂਤੋ(ਅ)ਵਦਤ੍ ਹੇ ਮਰਿਯਮ੍ ਭਯੰ ਮਾਕਾਰ੍ਸ਼਼ੀਃ, ਤ੍ਵਯਿ ਪਰਮੇਸ਼੍ਵਰਸ੍ਯਾਨੁਗ੍ਰਹੋਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ਪਸ਼੍ਯ ਤ੍ਵੰ ਗਰ੍ੱਭੰ ਧ੍ਰੁʼਤ੍ਵਾ ਪੁਤ੍ਰੰ ਪ੍ਰਸੋਸ਼਼੍ਯਸੇ ਤਸ੍ਯ ਨਾਮ ਯੀਸ਼ੁਰਿਤਿ ਕਰਿਸ਼਼੍ਯਸਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ਸ ਮਹਾਨ੍ ਭਵਿਸ਼਼੍ਯਤਿ ਤਥਾ ਸਰ੍ੱਵੇਭ੍ਯਃ ਸ਼੍ਰੇਸ਼਼੍ਠਸ੍ਯ ਪੁਤ੍ਰ ਇਤਿ ਖ੍ਯਾਸ੍ਯਤਿ; ਅਪਰੰ ਪ੍ਰਭੁਃ ਪਰਮੇਸ਼੍ਵਰਸ੍ਤਸ੍ਯ ਪਿਤੁਰ੍ਦਾਯੂਦਃ ਸਿੰਹਾਸਨੰ ਤਸ੍ਮੈ ਦਾਸ੍ਯਤਿ; ");
INSERT INTO sanpun_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ਤਥਾ ਸ ਯਾਕੂਬੋ ਵੰਸ਼ੋਪਰਿ ਸਰ੍ੱਵਦਾ ਰਾਜਤ੍ਵੰ ਕਰਿਸ਼਼੍ਯਤਿ, ਤਸ੍ਯ ਰਾਜਤ੍ਵਸ੍ਯਾਨ੍ਤੋ ਨ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","ਤਦਾ ਮਰਿਯਮ੍ ਤੰ ਦੂਤੰ ਬਭਾਸ਼਼ੇ ਨਾਹੰ ਪੁਰੁਸ਼਼ਸਙ੍ਗੰ ਕਰੋਮਿ ਤਰ੍ਹਿ ਕਥਮੇਤਤ੍ ਸਮ੍ਭਵਿਸ਼਼੍ਯਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ਤਤੋ ਦੂਤੋ(ਅ)ਕਥਯਤ੍ ਪਵਿਤ੍ਰ ਆਤ੍ਮਾ ਤ੍ਵਾਮਾਸ਼੍ਰਾਯਿਸ਼਼੍ਯਤਿ ਤਥਾ ਸਰ੍ੱਵਸ਼੍ਰੇਸ਼਼੍ਠਸ੍ਯ ਸ਼ਕ੍ਤਿਸ੍ਤਵੋਪਰਿ ਛਾਯਾਂ ਕਰਿਸ਼਼੍ਯਤਿ ਤਤੋ ਹੇਤੋਸ੍ਤਵ ਗਰ੍ੱਭਾਦ੍ ਯਃ ਪਵਿਤ੍ਰਬਾਲਕੋ ਜਨਿਸ਼਼੍ਯਤੇ ਸ ਈਸ਼੍ਵਰਪੁਤ੍ਰ ਇਤਿ ਖ੍ਯਾਤਿੰ ਪ੍ਰਾਪ੍ਸ੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ਅਪਰਞ੍ਚ ਪਸ਼੍ਯ ਤਵ ਜ੍ਞਾਤਿਰਿਲੀਸ਼ੇਵਾ ਯਾਂ ਸਰ੍ੱਵੇ ਬਨ੍ਧ੍ਯਾਮਵਦਨ੍ ਇਦਾਨੀਂ ਸਾ ਵਾਰ੍ੱਧਕ੍ਯੇ ਸਨ੍ਤਾਨਮੇਕੰ ਗਰ੍ੱਭੇ(ਅ)ਧਾਰਯਤ੍ ਤਸ੍ਯ ਸ਼਼ਸ਼਼੍ਠਮਾਸੋਭੂਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ਕਿਮਪਿ ਕਰ੍ੰਮ ਨਾਸਾਧ੍ਯਮ੍ ਈਸ਼੍ਵਰਸ੍ਯ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","ਤਦਾ ਮਰਿਯਮ੍ ਜਗਾਦ, ਪਸ਼੍ਯ ਪ੍ਰਭੇਰਹੰ ਦਾਸੀ ਮਹ੍ਯੰ ਤਵ ਵਾਕ੍ਯਾਨੁਸਾਰੇਣ ਸਰ੍ੱਵਮੇਤਦ੍ ਘਟਤਾਮ੍; ਅਨਨਤਰੰ ਦੂਤਸ੍ਤਸ੍ਯਾਃ ਸਮੀਪਾਤ੍ ਪ੍ਰਤਸ੍ਥੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","ਅਥ ਕਤਿਪਯਦਿਨਾਤ੍ ਪਰੰ ਮਰਿਯਮ੍ ਤਸ੍ਮਾਤ੍ ਪਰ੍ੱਵਤਮਯਪ੍ਰਦੇਸ਼ੀਯਯਿਹੂਦਾਯਾ ਨਗਰਮੇਕੰ ਸ਼ੀਘ੍ਰੰ ਗਤ੍ਵਾ ");
INSERT INTO sanpun_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ਸਿਖਰਿਯਯਾਜਕਸ੍ਯ ਗ੍ਰੁʼਹੰ ਪ੍ਰਵਿਸ਼੍ਯ ਤਸ੍ਯ ਜਾਯਾਮ੍ ਇਲੀਸ਼ੇਵਾਂ ਸਮ੍ਬੋਧ੍ਯਾਵਦਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ਤਤੋ ਮਰਿਯਮਃ ਸਮ੍ਬੋਧਨਵਾਕ੍ਯੇ ਇਲੀਸ਼ੇਵਾਯਾਃ ਕਰ੍ਣਯੋਃ ਪ੍ਰਵਿਸ਼਼੍ਟਮਾਤ੍ਰੇ ਸਤਿ ਤਸ੍ਯਾ ਗਰ੍ੱਭਸ੍ਥਬਾਲਕੋ ਨਨਰ੍ੱਤ| ਤਤ ਇਲੀਸ਼ੇਵਾ ਪਵਿਤ੍ਰੇਣਾਤ੍ਮਨਾ ਪਰਿਪੂਰ੍ਣਾ ਸਤੀ ");
INSERT INTO sanpun_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ਪ੍ਰੋੱਚੈਰ੍ਗਦਿਤੁਮਾਰੇਭੇ, ਯੋਸ਼਼ਿਤਾਂ ਮਧ੍ਯੇ ਤ੍ਵਮੇਵ ਧਨ੍ਯਾ, ਤਵ ਗਰ੍ੱਭਸ੍ਥਃ ਸ਼ਿਸ਼ੁਸ਼੍ਚ ਧਨ੍ਯਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ਤ੍ਵੰ ਪ੍ਰਭੋਰ੍ਮਾਤਾ, ਮਮ ਨਿਵੇਸ਼ਨੇ ਤ੍ਵਯਾ ਚਰਣਾਵਰ੍ਪਿਤੌ, ਮਮਾਦ੍ਯ ਸੌਭਾਗ੍ਯਮੇਤਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","ਪਸ਼੍ਯ ਤਵ ਵਾਕ੍ਯੇ ਮਮ ਕਰ੍ਣਯੋਃ ਪ੍ਰਵਿਸ਼਼੍ਟਮਾਤ੍ਰੇ ਸਤਿ ਮਮੋਦਰਸ੍ਥਃ ਸ਼ਿਸ਼ੁਰਾਨਨ੍ਦਾਨ੍ ਨਨਰ੍ੱਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","ਯਾ ਸ੍ਤ੍ਰੀ ਵ੍ਯਸ਼੍ਵਸੀਤ੍ ਸਾ ਧਨ੍ਯਾ, ਯਤੋ ਹੇਤੋਸ੍ਤਾਂ ਪ੍ਰਤਿ ਪਰਮੇਸ਼੍ਵਰੋਕ੍ਤੰ ਵਾਕ੍ਯੰ ਸਰ੍ੱਵੰ ਸਿੱਧੰ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ਤਦਾਨੀਂ ਮਰਿਯਮ੍ ਜਗਾਦ| ਧਨ੍ਯਵਾਦੰ ਪਰੇਸ਼ਸ੍ਯ ਕਰੋਤਿ ਮਾਮਕੰ ਮਨਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ਮਮਾਤ੍ਮਾ ਤਾਰਕੇਸ਼ੇ ਚ ਸਮੁੱਲਾਸੰ ਪ੍ਰਗੱਛਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ਅਕਰੋਤ੍ ਸ ਪ੍ਰਭੁ ਰ੍ਦੁਸ਼਼੍ਟਿੰ ਸ੍ਵਦਾਸ੍ਯਾ ਦੁਰ੍ਗਤਿੰ ਪ੍ਰਤਿ| ਪਸ਼੍ਯਾਦ੍ਯਾਰਭ੍ਯ ਮਾਂ ਧਨ੍ਯਾਂ ਵਕ੍ਸ਼਼੍ਯਨ੍ਤਿ ਪੁਰੁਸ਼਼ਾਃ ਸਦਾ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ਯਃ ਸਰ੍ੱਵਸ਼ਕ੍ਤਿਮਾਨ੍ ਯਸ੍ਯ ਨਾਮਾਪਿ ਚ ਪਵਿਤ੍ਰਕੰ| ਸ ਏਵ ਸੁਮਹਤ੍ਕਰ੍ੰਮ ਕ੍ਰੁʼਤਵਾਨ੍ ਮੰਨਿਮਿੱਤਕੰ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ਯੇ ਬਿਭ੍ਯਤਿ ਜਨਾਸ੍ਤਸ੍ਮਾਤ੍ ਤੇਸ਼਼ਾਂ ਸਨ੍ਤਾਨਪੰਕ੍ਤਿਸ਼਼ੁ| ਅਨੁਕਮ੍ਪਾ ਤਦੀਯਾ ਚ ਸਰ੍ੱਵਦੈਵ ਸੁਤਿਸ਼਼੍ਠਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ਸ੍ਵਬਾਹੁਬਲਤਸ੍ਤੇਨ ਪ੍ਰਾਕਾਸ਼੍ਯਤ ਪਰਾਕ੍ਰਮਃ| ਮਨਃਕੁਮਨ੍ਤ੍ਰਣਾਸਾਰ੍ੱਧੰ ਵਿਕੀਰ੍ੱਯਨ੍ਤੇ(ਅ)ਭਿਮਾਨਿਨਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ਸਿੰਹਾਸਨਗਤਾੱਲੋਕਾਨ੍ ਬਲਿਨਸ਼੍ਚਾਵਰੋਹ੍ਯ ਸਃ| ਪਦੇਸ਼਼ੂੱਚੇਸ਼਼ੁ ਲੋਕਾਂਸ੍ਤੁ ਕ੍ਸ਼਼ੁਦ੍ਰਾਨ੍ ਸੰਸ੍ਥਾਪਯਤ੍ਯਪਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ਕ੍ਸ਼਼ੁਧਿਤਾਨ੍ ਮਾਨਵਾਨ੍ ਦ੍ਰਵ੍ਯੈਰੁੱਤਮੈਃ ਪਰਿਤਰ੍ਪ੍ਯ ਸਃ| ਸਕਲਾਨ੍ ਧਨਿਨੋ ਲੋਕਾਨ੍ ਵਿਸ੍ਰੁʼਜੇਦ੍ ਰਿਕ੍ਤਹਸ੍ਤਕਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ਇਬ੍ਰਾਹੀਮਿ ਚ ਤਦ੍ਵੰਸ਼ੇ ਯਾ ਦਯਾਸ੍ਤਿ ਸਦੈਵ ਤਾਂ| ਸ੍ਮ੍ਰੁʼਤ੍ਵਾ ਪੁਰਾ ਪਿਤ੍ਰੁʼਣਾਂ ਨੋ ਯਥਾ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਪ੍ਰਤਿਸ਼੍ਰੁਤੰ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ਇਸ੍ਰਾਯੇਲ੍ਸੇਵਕਸ੍ਤੇਨ ਤਥੋਪਕ੍ਰਿਯਤੇ ਸ੍ਵਯੰ|| ");
INSERT INTO sanpun_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","ਅਨਨ੍ਤਰੰ ਮਰਿਯਮ੍ ਪ੍ਰਾਯੇਣ ਮਾਸਤ੍ਰਯਮ੍ ਇਲੀਸ਼ੇਵਯਾ ਸਹੋਸ਼਼ਿਤ੍ਵਾ ਵ੍ਯਾਘੁੱਯ ਨਿਜਨਿਵੇਸ਼ਨੰ ਯਯੌ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","ਤਦਨਨ੍ਤਰਮ੍ ਇਲੀਸ਼ੇਵਾਯਾਃ ਪ੍ਰਸਵਕਾਲ ਉਪਸ੍ਥਿਤੇ ਸਤਿ ਸਾ ਪੁਤ੍ਰੰ ਪ੍ਰਾਸੋਸ਼਼੍ਟ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ਤਤਃ ਪਰਮੇਸ਼੍ਵਰਸ੍ਤਸ੍ਯਾਂ ਮਹਾਨੁਗ੍ਰਹੰ ਕ੍ਰੁʼਤਵਾਨ੍ ਏਤਤ੍ ਸ਼੍ਰੁਤ੍ਵਾ ਸਮੀਪਵਾਸਿਨਃ ਕੁਟੁਮ੍ਬਾਸ਼੍ਚਾਗਤ੍ਯ ਤਯਾ ਸਹ ਮੁਮੁਦਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","ਤਥਾਸ਼਼੍ਟਮੇ ਦਿਨੇ ਤੇ ਬਾਲਕਸ੍ਯ ਤ੍ਵਚੰ ਛੇੱਤੁਮ੍ ਏਤ੍ਯ ਤਸ੍ਯ ਪਿਤ੍ਰੁʼਨਾਮਾਨੁਰੂਪੰ ਤੰਨਾਮ ਸਿਖਰਿਯ ਇਤਿ ਕਰ੍ੱਤੁਮੀਸ਼਼ੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ਕਿਨ੍ਤੁ ਤਸ੍ਯ ਮਾਤਾਕਥਯਤ੍ ਤੰਨ, ਨਾਮਾਸ੍ਯ ਯੋਹਨ੍ ਇਤਿ ਕਰ੍ੱਤਵ੍ਯਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ਤਦਾ ਤੇ ਵ੍ਯਾਹਰਨ੍ ਤਵ ਵੰਸ਼ਮਧ੍ਯੇ ਨਾਮੇਦ੍ਰੁʼਸ਼ੰ ਕਸ੍ਯਾਪਿ ਨਾਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ਤਤਃ ਪਰੰ ਤਸ੍ਯ ਪਿਤਰੰ ਸਿਖਰਿਯੰ ਪ੍ਰਤਿ ਸਙ੍ਕੇਤ੍ਯ ਪਪ੍ਰੱਛੁਃ ਸ਼ਿਸ਼ੋਃ ਕਿੰ ਨਾਮ ਕਾਰਿਸ਼਼੍ਯਤੇ? ");
INSERT INTO sanpun_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ਤਤਃ ਸ ਫਲਕਮੇਕੰ ਯਾਚਿਤ੍ਵਾ ਲਿਲੇਖ ਤਸ੍ਯ ਨਾਮ ਯੋਹਨ੍ ਭਵਿਸ਼਼੍ਯਤਿ| ਤਸ੍ਮਾਤ੍ ਸਰ੍ੱਵੇ ਆਸ਼੍ਚਰ੍ੱਯੰ ਮੇਨਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ਤਤ੍ਕ੍ਸ਼਼ਣੰ ਸਿਖਰਿਯਸ੍ਯ ਜਿਹ੍ਵਾਜਾਡ੍ਯੇ(ਅ)ਪਗਤੇ ਸ ਮੁਖੰ ਵ੍ਯਾਦਾਯ ਸ੍ਪਸ਼਼੍ਟਵਰ੍ਣਮੁੱਚਾਰ੍ੱਯ ਈਸ਼੍ਵਰਸ੍ਯ ਗੁਣਾਨੁਵਾਦੰ ਚਕਾਰ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","ਤਸ੍ਮਾੱਚਤੁਰ੍ਦਿਕ੍ਸ੍ਥਾਃ ਸਮੀਪਵਾਸਿਲੋਕਾ ਭੀਤਾ ਏਵਮੇਤਾਃ ਸਰ੍ੱਵਾਃ ਕਥਾ ਯਿਹੂਦਾਯਾਃ ਪਰ੍ੱਵਤਮਯਪ੍ਰਦੇਸ਼ਸ੍ਯ ਸਰ੍ੱਵਤ੍ਰ ਪ੍ਰਚਾਰਿਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ਤਸ੍ਮਾਤ੍ ਸ਼੍ਰੋਤਾਰੋ ਮਨਃਸੁ ਸ੍ਥਾਪਯਿਤ੍ਵਾ ਕਥਯਾਮ੍ਬਭੂਵੁਃ ਕੀਦ੍ਰੁʼਸ਼ੋਯੰ ਬਾਲੋ ਭਵਿਸ਼਼੍ਯਤਿ? ਅਥ ਪਰਮੇਸ਼੍ਵਰਸ੍ਤਸ੍ਯ ਸਹਾਯੋਭੂਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ਤਦਾ ਯੋਹਨਃ ਪਿਤਾ ਸਿਖਰਿਯਃ ਪਵਿਤ੍ਰੇਣਾਤ੍ਮਨਾ ਪਰਿਪੂਰ੍ਣਃ ਸਨ੍ ਏਤਾਦ੍ਰੁʼਸ਼ੰ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਕ੍ਯੰ ਕਥਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","ਇਸ੍ਰਾਯੇਲਃ ਪ੍ਰਭੁ ਰ੍ਯਸ੍ਤੁ ਸ ਧਨ੍ਯਃ ਪਰਮੇਸ਼੍ਵਰਃ| ਅਨੁਗ੍ਰੁʼਹ੍ਯ ਨਿਜਾੱਲੋਕਾਨ੍ ਸ ਏਵ ਪਰਿਮੋਚਯੇਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ਵਿਪਕ੍ਸ਼਼ਜਨਹਸ੍ਤੇਭ੍ਯੋ ਯਥਾ ਮੋਚ੍ਯਾਮਹੇ ਵਯੰ| ਯਾਵੱਜੀਵਞ੍ਚ ਧਰ੍ੰਮੇਣ ਸਾਰਲ੍ਯੇਨ ਚ ਨਿਰ੍ਭਯਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ਸੇਵਾਮਹੈ ਤਮੇਵੈਕਮ੍ ਏਤਤ੍ਕਾਰਣਮੇਵ ਚ| ਸ੍ਵਕੀਯੰ ਸੁਪਵਿਤ੍ਰਞ੍ਚ ਸੰਸ੍ਮ੍ਰੁʼਤ੍ਯ ਨਿਯਮੰ ਸਦਾ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ਕ੍ਰੁʼਪਯਾ ਪੁਰੁਸ਼਼ਾਨ੍ ਪੂਰ੍ੱਵਾਨ੍ ਨਿਕਸ਼਼ਾਰ੍ਥਾੱਤੁ ਨਃ ਪਿਤੁਃ| ਇਬ੍ਰਾਹੀਮਃ ਸਮੀਪੇ ਯੰ ਸ਼ਪਥੰ ਕ੍ਰੁʼਤਵਾਨ੍ ਪੁਰਾ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ਤਮੇਵ ਸਫਲੰ ਕਰ੍ੱਤੰ ਤਥਾ ਸ਼ਤ੍ਰੁਗਣਸ੍ਯ ਚ| ਰੁʼृਤੀਯਾਕਾਰਿਣਸ਼੍ਚੈਵ ਕਰੇਭ੍ਯੋ ਰਕ੍ਸ਼਼ਣਾਯ ਨਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ਸ੍ਰੁʼਸ਼਼੍ਟੇਃ ਪ੍ਰਥਮਤਃ ਸ੍ਵੀਯੈਃ ਪਵਿਤ੍ਰੈ ਰ੍ਭਾਵਿਵਾਦਿਭਿਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ਯਥੋਕ੍ਤਵਾਨ੍ ਤਥਾ ਸ੍ਵਸ੍ਯ ਦਾਯੂਦਃ ਸੇਵਕਸ੍ਯ ਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ਵੰਸ਼ੇ ਤ੍ਰਾਤਾਰਮੇਕੰ ਸ ਸਮੁਤ੍ਪਾਦਿਤਵਾਨ੍ ਸ੍ਵਯਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ਅਤੋ ਹੇ ਬਾਲਕ ਤ੍ਵਨ੍ਤੁ ਸਰ੍ੱਵੇਭ੍ਯਃ ਸ਼੍ਰੇਸ਼਼੍ਠ ਏਵ ਯਃ| ਤਸ੍ਯੈਵ ਭਾਵਿਵਾਦੀਤਿ ਪ੍ਰਵਿਖ੍ਯਾਤੋ ਭਵਿਸ਼਼੍ਯਸਿ| ਅਸ੍ਮਾਕੰ ਚਰਣਾਨ੍ ਕ੍ਸ਼਼ੇਮੇ ਮਾਰ੍ਗੇ ਚਾਲਯਿਤੁੰ ਸਦਾ| ਏਵੰ ਧ੍ਵਾਨ੍ਤੇ(ਅ)ਰ੍ਥਤੋ ਮ੍ਰੁʼਤ੍ਯੋਸ਼੍ਛਾਯਾਯਾਂ ਯੇ ਤੁ ਮਾਨਵਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ਉਪਵਿਸ਼਼੍ਟਾਸ੍ਤੁ ਤਾਨੇਵ ਪ੍ਰਕਾਸ਼ਯਿਤੁਮੇਵ ਹਿ| ਕ੍ਰੁʼਤ੍ਵਾ ਮਹਾਨੁਕਮ੍ਪਾਂ ਹਿ ਯਾਮੇਵ ਪਰਮੇਸ਼੍ਵਰਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ਊਰ੍ਦ੍ੱਵਾਤ੍ ਸੂਰ੍ੱਯਮੁਦਾੱਯੈਵਾਸ੍ਮਭ੍ਯੰ ਪ੍ਰਾਦਾੱਤੁ ਦਰ੍ਸ਼ਨੰ| ਤਯਾਨੁਕਮ੍ਪਯਾ ਸ੍ਵਸ੍ਯ ਲੋਕਾਨਾਂ ਪਾਪਮੋਚਨੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ਪਰਿਤ੍ਰਾਣਸ੍ਯ ਤੇਭ੍ਯੋ ਹਿ ਜ੍ਞਾਨਵਿਸ਼੍ਰਾਣਨਾਯ ਚ| ਪ੍ਰਭੋ ਰ੍ਮਾਰ੍ਗੰ ਪਰਿਸ਼਼੍ਕਰ੍ੱਤੁੰ ਤਸ੍ਯਾਗ੍ਰਾਯੀ ਭਵਿਸ਼਼੍ਯਸਿ|| ");
INSERT INTO sanpun_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","ਅਥ ਬਾਲਕਃ ਸ਼ਰੀਰੇਣ ਬੁੱਧ੍ਯਾ ਚ ਵਰ੍ੱਧਿਤੁਮਾਰੇਭੇ; ਅਪਰਞ੍ਚ ਸ ਇਸ੍ਰਾਯੇਲੋ ਵੰਸ਼ੀਯਲੋਕਾਨਾਂ ਸਮੀਪੇ ਯਾਵੰਨ ਪ੍ਰਕਟੀਭੂਤਸ੍ਤਾਸ੍ਤਾਵਤ੍ ਪ੍ਰਾਨ੍ਤਰੇ ਨ੍ਯਵਸਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","ਅਪਰਞ੍ਚ ਤਸ੍ਮਿਨ੍ ਕਾਲੇ ਰਾਜ੍ਯਸ੍ਯ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਲੋਕਾਨਾਂ ਨਾਮਾਨਿ ਲੇਖਯਿਤੁਮ੍ ਅਗਸ੍ਤਕੈਸਰ ਆਜ੍ਞਾਪਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ਤਦਨੁਸਾਰੇਣ ਕੁਰੀਣਿਯਨਾਮਨਿ ਸੁਰਿਯਾਦੇਸ਼ਸ੍ਯ ਸ਼ਾਸਕੇ ਸਤਿ ਨਾਮਲੇਖਨੰ ਪ੍ਰਾਰੇਭੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","ਅਤੋ ਹੇਤੋ ਰ੍ਨਾਮ ਲੇਖਿਤੁੰ ਸਰ੍ੱਵੇ ਜਨਾਃ ਸ੍ਵੀਯੰ ਸ੍ਵੀਯੰ ਨਗਰੰ ਜਗ੍ਮੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ਤਦਾਨੀਂ ਯੂਸ਼਼ਫ੍ ਨਾਮ ਲੇਖਿਤੁੰ ਵਾਗ੍ਦੱਤਯਾ ਸ੍ਵਭਾਰ੍ੱਯਯਾ ਗਰ੍ੱਭਵਤ੍ਯਾ ਮਰਿਯਮਾ ਸਹ ਸ੍ਵਯੰ ਦਾਯੂਦਃ ਸਜਾਤਿਵੰਸ਼ ਇਤਿ ਕਾਰਣਾਦ੍ ਗਾਲੀਲ੍ਪ੍ਰਦੇਸ਼ਸ੍ਯ ਨਾਸਰਤ੍ਨਗਰਾਦ੍ ");
INSERT INTO sanpun_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ਯਿਹੂਦਾਪ੍ਰਦੇਸ਼ਸ੍ਯ ਬੈਤ੍ਲੇਹਮਾਖ੍ਯੰ ਦਾਯੂਦ੍ਨਗਰੰ ਜਗਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ਅਨ੍ਯੱਚ ਤਤ੍ਰ ਸ੍ਥਾਨੇ ਤਯੋਸ੍ਤਿਸ਼਼੍ਠਤੋਃ ਸਤੋ ਰ੍ਮਰਿਯਮਃ ਪ੍ਰਸੂਤਿਕਾਲ ਉਪਸ੍ਥਿਤੇ ");
INSERT INTO sanpun_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ਸਾ ਤੰ ਪ੍ਰਥਮਸੁਤੰ ਪ੍ਰਾਸੋਸ਼਼੍ਟ ਕਿਨ੍ਤੁ ਤਸ੍ਮਿਨ੍ ਵਾਸਗ੍ਰੁʼਹੇ ਸ੍ਥਾਨਾਭਾਵਾਦ੍ ਬਾਲਕੰ ਵਸ੍ਤ੍ਰੇਣ ਵੇਸ਼਼੍ਟਯਿਤ੍ਵਾ ਗੋਸ਼ਾਲਾਯਾਂ ਸ੍ਥਾਪਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","ਅਨਨ੍ਤਰੰ ਯੇ ਕਿਯਨ੍ਤੋ ਮੇਸ਼਼ਪਾਲਕਾਃ ਸ੍ਵਮੇਸ਼਼ਵ੍ਰਜਰਕ੍ਸ਼਼ਾਯੈ ਤਤ੍ਪ੍ਰਦੇਸ਼ੇ ਸ੍ਥਿਤ੍ਵਾ ਰਜਨ੍ਯਾਂ ਪ੍ਰਾਨ੍ਤਰੇ ਪ੍ਰਹਰਿਣਃ ਕਰ੍ੰਮ ਕੁਰ੍ੱਵਨ੍ਤਿ, ");
INSERT INTO sanpun_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","ਤੇਸ਼਼ਾਂ ਸਮੀਪੰ ਪਰਮੇਸ਼੍ਵਰਸ੍ਯ ਦੂਤ ਆਗਤ੍ਯੋਪਤਸ੍ਥੌ; ਤਦਾ ਚਤੁਸ਼਼੍ਪਾਰ੍ਸ਼੍ਵੇ ਪਰਮੇਸ਼੍ਵਰਸ੍ਯ ਤੇਜਸਃ ਪ੍ਰਕਾਸ਼ਿਤਤ੍ਵਾਤ੍ ਤੇ(ਅ)ਤਿਸ਼ਸ਼ਙ੍ਕਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ਤਦਾ ਸ ਦੂਤ ਉਵਾਚ ਮਾ ਭੈਸ਼਼੍ਟ ਪਸ਼੍ਯਤਾਦ੍ਯ ਦਾਯੂਦਃ ਪੁਰੇ ਯੁਸ਼਼੍ਮੰਨਿਮਿੱਤੰ ਤ੍ਰਾਤਾ ਪ੍ਰਭੁਃ ਖ੍ਰੀਸ਼਼੍ਟੋ(ਅ)ਜਨਿਸ਼਼੍ਟ, ");
INSERT INTO sanpun_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਲੋਕਾਨਾਂ ਮਹਾਨਨ੍ਦਜਨਕਮ੍ ਇਮੰ ਮਙ੍ਗਲਵ੍ਰੁʼੱਤਾਨ੍ਤੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਜ੍ਞਾਪਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","ਯੂਯੰ (ਤਤ੍ਸ੍ਥਾਨੰ ਗਤ੍ਵਾ) ਵਸ੍ਤ੍ਰਵੇਸ਼਼੍ਟਿਤੰ ਤੰ ਬਾਲਕੰ ਗੋਸ਼ਾਲਾਯਾਂ ਸ਼ਯਨੰ ਦ੍ਰਕ੍ਸ਼਼੍ਯਥ ਯੁਸ਼਼੍ਮਾਨ੍ ਪ੍ਰਤੀਦੰ ਚਿਹ੍ਨੰ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ਦੂਤ ਇਮਾਂ ਕਥਾਂ ਕਥਿਤਵਤਿ ਤਤ੍ਰਾਕਸ੍ਮਾਤ੍ ਸ੍ਵਰ੍ਗੀਯਾਃ ਪ੍ਰੁʼਤਨਾ ਆਗਤ੍ਯ ਕਥਾਮ੍ ਇਮਾਂ ਕਥਯਿਤ੍ਵੇਸ਼੍ਵਰਸ੍ਯ ਗੁਣਾਨਨ੍ਵਵਾਦਿਸ਼਼ੁਃ, ਯਥਾ, ");
INSERT INTO sanpun_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","ਸਰ੍ੱਵੋਰ੍ਦ੍ੱਵਸ੍ਥੈਰੀਸ਼੍ਵਰਸ੍ਯ ਮਹਿਮਾ ਸਮ੍ਪ੍ਰਕਾਸ਼੍ਯਤਾਂ| ਸ਼ਾਨ੍ਤਿਰ੍ਭੂਯਾਤ੍ ਪ੍ਰੁʼਥਿਵ੍ਯਾਸ੍ਤੁ ਸਨ੍ਤੋਸ਼਼ਸ਼੍ਚ ਨਰਾਨ੍ ਪ੍ਰਤਿ|| ");
INSERT INTO sanpun_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ਤਤਃ ਪਰੰ ਤੇਸ਼਼ਾਂ ਸੰਨਿਧੇ ਰ੍ਦੂਤਗਣੇ ਸ੍ਵਰ੍ਗੰ ਗਤੇ ਮੇਸ਼਼ਪਾਲਕਾਃ ਪਰਸ੍ਪਰਮ੍ ਅਵੇਚਨ੍ ਆਗੱਛਤ ਪ੍ਰਭੁਃ ਪਰਮੇਸ਼੍ਵਰੋ ਯਾਂ ਘਟਨਾਂ ਜ੍ਞਾਪਿਤਵਾਨ੍ ਤਸ੍ਯਾ ਯਾਥਰ੍ਯੰ ਜ੍ਞਾਤੁੰ ਵਯਮਧੁਨਾ ਬੈਤ੍ਲੇਹਮ੍ਪੁਰੰ ਯਾਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ਪਸ਼੍ਚਾਤ੍ ਤੇ ਤੂਰ੍ਣੰ ਵ੍ਰਜਿਤ੍ਵਾ ਮਰਿਯਮੰ ਯੂਸ਼਼ਫੰ ਗੋਸ਼ਾਲਾਯਾਂ ਸ਼ਯਨੰ ਬਾਲਕਞ੍ਚ ਦਦ੍ਰੁʼਸ਼ੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ਇੱਥੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਬਾਲਕਸ੍ਯਾਰ੍ਥੇ ਪ੍ਰੋਕ੍ਤਾਂ ਸਰ੍ੱਵਕਥਾਂ ਤੇ ਪ੍ਰਾਚਾਰਯਾਞ੍ਚਕ੍ਰੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ਤਤੋ ਯੇ ਲੋਕਾ ਮੇਸ਼਼ਰਕ੍ਸ਼਼ਕਾਣਾਂ ਵਦਨੇਭ੍ਯਸ੍ਤਾਂ ਵਾਰ੍ੱਤਾਂ ਸ਼ੁਸ਼੍ਰੁਵੁਸ੍ਤੇ ਮਹਾਸ਼੍ਚਰ੍ੱਯੰ ਮੇਨਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ਕਿਨ੍ਤੁ ਮਰਿਯਮ੍ ਏਤਤ੍ਸਰ੍ੱਵਘਟਨਾਨਾਂ ਤਾਤ੍ਪਰ੍ੱਯੰ ਵਿਵਿਚ੍ਯ ਮਨਸਿ ਸ੍ਥਾਪਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","ਤਤ੍ਪਸ਼੍ਚਾਦ੍ ਦੂਤਵਿਜ੍ਞਪ੍ਤਾਨੁਰੂਪੰ ਸ਼੍ਰੁਤ੍ਵਾ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਚ ਮੇਸ਼਼ਪਾਲਕਾ ਈਸ਼੍ਵਰਸ੍ਯ ਗੁਣਾਨੁਵਾਦੰ ਧਨ੍ਯਵਾਦਞ੍ਚ ਕੁਰ੍ੱਵਾਣਾਃ ਪਰਾਵ੍ਰੁʼਤ੍ਯ ਯਯੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","ਅਥ ਬਾਲਕਸ੍ਯ ਤ੍ਵਕ੍ਛੇਦਨਕਾਲੇ(ਅ)ਸ਼਼੍ਟਮਦਿਵਸੇ ਸਮੁਪਸ੍ਥਿਤੇ ਤਸ੍ਯ ਗਰ੍ੱਭਸ੍ਥਿਤੇਃ ਪੁਰ੍ੱਵੰ ਸ੍ਵਰ੍ਗੀਯਦੂਤੋ ਯਥਾਜ੍ਞਾਪਯਤ੍ ਤਦਨੁਰੂਪੰ ਤੇ ਤੰਨਾਮਧੇਯੰ ਯੀਸ਼ੁਰਿਤਿ ਚਕ੍ਰਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","ਤਤਃ ਪਰੰ ਮੂਸਾਲਿਖਿਤਵ੍ਯਵਸ੍ਥਾਯਾ ਅਨੁਸਾਰੇਣ ਮਰਿਯਮਃ ਸ਼ੁਚਿਤ੍ਵਕਾਲ ਉਪਸ੍ਥਿਤੇ, ");
INSERT INTO sanpun_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","\"ਪ੍ਰਥਮਜਃ ਸਰ੍ੱਵਃ ਪੁਰੁਸ਼਼ਸਨ੍ਤਾਨਃ ਪਰਮੇਸ਼੍ਵਰੇ ਸਮਰ੍ਪ੍ਯਤਾਂ,\" ਇਤਿ ਪਰਮੇਸ਼੍ਵਰਸ੍ਯ ਵ੍ਯਵਸ੍ਥਯਾ ");
INSERT INTO sanpun_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ਯੀਸ਼ੁੰ ਪਰਮੇਸ਼੍ਵਰੇ ਸਮਰ੍ਪਯਿਤੁਮ੍ ਸ਼ਾਸ੍ਤ੍ਰੀਯਵਿਧ੍ਯੁਕ੍ਤੰ ਕਪੋਤਦ੍ਵਯੰ ਪਾਰਾਵਤਸ਼ਾਵਕਦ੍ਵਯੰ ਵਾ ਬਲਿੰ ਦਾਤੁੰ ਤੇ ਤੰ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਯਿਰੂਸ਼ਾਲਮਮ੍ ਆਯਯੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ਯਿਰੂਸ਼ਾਲਮ੍ਪੁਰਨਿਵਾਸੀ ਸ਼ਿਮਿਯੋੰਨਾਮਾ ਧਾਰ੍ੰਮਿਕ ਏਕ ਆਸੀਤ੍ ਸ ਇਸ੍ਰਾਯੇਲਃ ਸਾਨ੍ਤ੍ਵਨਾਮਪੇਕ੍ਸ਼਼੍ਯ ਤਸ੍ਥੌ ਕਿਞ੍ਚ ਪਵਿਤ੍ਰ ਆਤ੍ਮਾ ਤਸ੍ਮਿੰਨਾਵਿਰ੍ਭੂਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ਅਪਰੰ ਪ੍ਰਭੁਣਾ ਪਰਮੇਸ਼੍ਵਰੇਣਾਭਿਸ਼਼ਿਕ੍ਤੇ ਤ੍ਰਾਤਰਿ ਤ੍ਵਯਾ ਨ ਦ੍ਰੁʼਸ਼਼੍ਟੇ ਤ੍ਵੰ ਨ ਮਰਿਸ਼਼੍ਯਸੀਤਿ ਵਾਕ੍ਯੰ ਪਵਿਤ੍ਰੇਣ ਆਤ੍ਮਨਾ ਤਸ੍ਮ ਪ੍ਰਾਕਥ੍ਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ਅਪਰਞ੍ਚ ਯਦਾ ਯੀਸ਼ੋਃ ਪਿਤਾ ਮਾਤਾ ਚ ਤਦਰ੍ਥੰ ਵ੍ਯਵਸ੍ਥਾਨੁਰੂਪੰ ਕਰ੍ੰਮ ਕਰ੍ੱਤੁੰ ਤੰ ਮਨ੍ਦਿਰਮ੍ ਆਨਿਨ੍ਯਤੁਸ੍ਤਦਾ ");
INSERT INTO sanpun_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ਸ਼ਿਮਿਯੋਨ੍ ਆਤ੍ਮਨ ਆਕਰ੍ਸ਼਼ਣੇਨ ਮਨ੍ਦਿਰਮਾਗਤ੍ਯ ਤੰ ਕ੍ਰੋਡੇ ਨਿਧਾਯ ਈਸ਼੍ਵਰਸ੍ਯ ਧਨ੍ਯਵਾਦੰ ਕ੍ਰੁʼਤ੍ਵਾ ਕਥਯਾਮਾਸ, ਯਥਾ, ");
INSERT INTO sanpun_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","ਹੇ ਪ੍ਰਭੋ ਤਵ ਦਾਸੋਯੰ ਨਿਜਵਾਕ੍ਯਾਨੁਸਾਰਤਃ| ਇਦਾਨੀਨ੍ਤੁ ਸਕਲ੍ਯਾਣੋ ਭਵਤਾ ਸੰਵਿਸ੍ਰੁʼਜ੍ਯਤਾਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ਯਤਃ ਸਕਲਦੇਸ਼ਸ੍ਯ ਦੀਪ੍ਤਯੇ ਦੀਪ੍ਤਿਰੂਪਕੰ| ");
INSERT INTO sanpun_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ਇਸ੍ਰਾਯੇਲੀਯਲੋਕਸ੍ਯ ਮਹਾਗੌਰਵਰੂਪਕੰ| ");
INSERT INTO sanpun_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ਯੰ ਤ੍ਰਾਯਕੰ ਜਨਾਨਾਨ੍ਤੁ ਸੰਮੁਖੇ ਤ੍ਵਮਜੀਜਨਃ| ਸਏਵ ਵਿਦ੍ਯਤੇ(ਅ)ਸ੍ਮਾਕੰ ਧ੍ਰਵੰ ਨਯਨਨਗੋਚਰੇ|| ");
INSERT INTO sanpun_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ਤਦਾਨੀਂ ਤੇਨੋਕ੍ਤਾ ਏਤਾਃ ਸਕਲਾਃ ਕਥਾਃ ਸ਼੍ਰੁਤ੍ਵਾ ਤਸ੍ਯ ਮਾਤਾ ਯੂਸ਼਼ਫ੍ ਚ ਵਿਸ੍ਮਯੰ ਮੇਨਾਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ਤਤਃ ਪਰੰ ਸ਼ਿਮਿਯੋਨ੍ ਤੇਭ੍ਯ ਆਸ਼ਿਸ਼਼ੰ ਦੱਤ੍ਵਾ ਤਨ੍ਮਾਤਰੰ ਮਰਿਯਮਮ੍ ਉਵਾਚ, ਪਸ਼੍ਯ ਇਸ੍ਰਾਯੇਲੋ ਵੰਸ਼ਮਧ੍ਯੇ ਬਹੂਨਾਂ ਪਾਤਨਾਯੋੱਥਾਪਨਾਯ ਚ ਤਥਾ ਵਿਰੋਧਪਾਤ੍ਰੰ ਭਵਿਤੁੰ, ਬਹੂਨਾਂ ਗੁਪ੍ਤਮਨੋਗਤਾਨਾਂ ਪ੍ਰਕਟੀਕਰਣਾਯ ਬਾਲਕੋਯੰ ਨਿਯੁਕ੍ਤੋਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ਤਸ੍ਮਾਤ੍ ਤਵਾਪਿ ਪ੍ਰਾਣਾਃ ਸ਼ੂਲੇਨ ਵ੍ਯਤ੍ਸ੍ਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","ਅਪਰਞ੍ਚ ਆਸ਼ੇਰਸ੍ਯ ਵੰਸ਼ੀਯਫਿਨੂਯੇਲੋ ਦੁਹਿਤਾ ਹੰਨਾਖ੍ਯਾ ਅਤਿਜਰਤੀ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨ੍ਯੇਕਾ ਯਾ ਵਿਵਾਹਾਤ੍ ਪਰੰ ਸਪ੍ਤ ਵਤ੍ਸਰਾਨ੍ ਪਤ੍ਯਾ ਸਹ ਨ੍ਯਵਸਤ੍ ਤਤੋ ਵਿਧਵਾ ਭੂਤ੍ਵਾ ਚਤੁਰਸ਼ੀਤਿਵਰ੍ਸ਼਼ਵਯਃਪਰ੍ੱਯਨਤੰ ");
INSERT INTO sanpun_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ਮਨ੍ਦਿਰੇ ਸ੍ਥਿਤ੍ਵਾ ਪ੍ਰਾਰ੍ਥਨੋਪਵਾਸੈਰ੍ਦਿਵਾਨਿਸ਼ਮ੍ ਈਸ਼੍ਵਰਮ੍ ਅਸੇਵਤ ਸਾਪਿ ਸ੍ਤ੍ਰੀ ਤਸ੍ਮਿਨ੍ ਸਮਯੇ ਮਨ੍ਦਿਰਮਾਗਤ੍ਯ ");
INSERT INTO sanpun_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","ਪਰਮੇਸ਼੍ਵਰਸ੍ਯ ਧਨ੍ਯਵਾਦੰ ਚਕਾਰ, ਯਿਰੂਸ਼ਾਲਮ੍ਪੁਰਵਾਸਿਨੋ ਯਾਵਨ੍ਤੋ ਲੋਕਾ ਮੁਕ੍ਤਿਮਪੇਕ੍ਸ਼਼੍ਯ ਸ੍ਥਿਤਾਸ੍ਤਾਨ੍ ਯੀਸ਼ੋਰ੍ਵ੍ਰੁʼੱਤਾਨ੍ਤੰ ਜ੍ਞਾਪਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ਇੱਥੰ ਪਰਮੇਸ਼੍ਵਰਸ੍ਯ ਵ੍ਯਵਸ੍ਥਾਨੁਸਾਰੇਣ ਸਰ੍ੱਵੇਸ਼਼ੁ ਕਰ੍ੰਮਸੁ ਕ੍ਰੁʼਤੇਸ਼਼ੁ ਤੌ ਪੁਨਸ਼੍ਚ ਗਾਲੀਲੋ ਨਾਸਰਤ੍ਨਾਮਕੰ ਨਿਜਨਗਰੰ ਪ੍ਰਤਸ੍ਥਾਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","ਤਤ੍ਪਸ਼੍ਚਾਦ੍ ਬਾਲਕਃ ਸ਼ਰੀਰੇਣ ਵ੍ਰੁʼੱਧਿਮੇਤ੍ਯ ਜ੍ਞਾਨੇਨ ਪਰਿਪੂਰ੍ਣ ਆਤ੍ਮਨਾ ਸ਼ਕ੍ਤਿਮਾਂਸ਼੍ਚ ਭਵਿਤੁਮਾਰੇਭੇ ਤਥਾ ਤਸ੍ਮਿਨ੍ ਈਸ਼੍ਵਰਾਨੁਗ੍ਰਹੋ ਬਭੂਵ| ");
INSERT INTO sanpun_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","ਤਸ੍ਯ ਪਿਤਾ ਮਾਤਾ ਚ ਪ੍ਰਤਿਵਰ੍ਸ਼਼ੰ ਨਿਸ੍ਤਾਰੋਤ੍ਸਵਸਮਯੇ ਯਿਰੂਸ਼ਾਲਮਮ੍ ਅਗੱਛਤਾਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","ਅਪਰਞ੍ਚ ਯੀਸ਼ੌ ਦ੍ਵਾਦਸ਼ਵਰ੍ਸ਼਼ਵਯਸ੍ਕੇ ਸਤਿ ਤੌ ਪਰ੍ੱਵਸਮਯਸ੍ਯ ਰੀਤ੍ਯਨੁਸਾਰੇਣ ਯਿਰੂਸ਼ਾਲਮੰ ਗਤ੍ਵਾ ");
INSERT INTO sanpun_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ਪਾਰ੍ੱਵਣੰ ਸਮ੍ਪਾਦ੍ਯ ਪੁਨਰਪਿ ਵ੍ਯਾਘੁੱਯ ਯਾਤਃ ਕਿਨ੍ਤੁ ਯੀਸ਼ੁਰ੍ਬਾਲਕੋ ਯਿਰੂਸ਼ਾਲਮਿ ਤਿਸ਼਼੍ਠਤਿ| ਯੂਸ਼਼ਫ੍ ਤਨ੍ਮਾਤਾ ਚ ਤਦ੍ ਅਵਿਦਿਤ੍ਵਾ ");
INSERT INTO sanpun_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ਸ ਸਙ੍ਗਿਭਿਃ ਸਹ ਵਿਦ੍ਯਤ ਏਤੱਚ ਬੁਦ੍ੱਵਾ ਦਿਨੈਕਗਮ੍ਯਮਾਰ੍ਗੰ ਜਗ੍ਮਤੁਃ| ਕਿਨ੍ਤੁ ਸ਼ੇਸ਼਼ੇ ਜ੍ਞਾਤਿਬਨ੍ਧੂਨਾਂ ਸਮੀਪੇ ਮ੍ਰੁʼਗਯਿਤ੍ਵਾ ਤਦੁੱਦੇेਸ਼ਮਪ੍ਰਾਪ੍ਯ ");
INSERT INTO sanpun_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ਤੌ ਪੁਨਰਪਿ ਯਿਰੂਸ਼ਾਲਮਮ੍ ਪਰਾਵ੍ਰੁʼਤ੍ਯਾਗਤ੍ਯ ਤੰ ਮ੍ਰੁʼਗਯਾਞ੍ਚਕ੍ਰਤੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ਅਥ ਦਿਨਤ੍ਰਯਾਤ੍ ਪਰੰ ਪਣ੍ਡਿਤਾਨਾਂ ਮਧ੍ਯੇ ਤੇਸ਼਼ਾਂ ਕਥਾਃ ਸ਼੍ਰੁʼਣ੍ਵਨ੍ ਤੱਤ੍ਵੰ ਪ੍ਰੁʼੱਛੰਸ਼੍ਚ ਮਨ੍ਦਿਰੇ ਸਮੁਪਵਿਸ਼਼੍ਟਃ ਸ ਤਾਭ੍ਯਾਂ ਦ੍ਰੁʼਸ਼਼੍ਟਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ਤਦਾ ਤਸ੍ਯ ਬੁੱਧ੍ਯਾ ਪ੍ਰਤ੍ਯੁੱਤਰੈਸ਼੍ਚ ਸਰ੍ੱਵੇ ਸ਼੍ਰੋਤਾਰੋ ਵਿਸ੍ਮਯਮਾਪਦ੍ਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ਤਾਦ੍ਰੁʼਸ਼ੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਤਸ੍ਯ ਜਨਕੋ ਜਨਨੀ ਚ ਚਮੱਚਕ੍ਰਤੁਃ ਕਿਞ੍ਚ ਤਸ੍ਯ ਮਾਤਾ ਤਮਵਦਤ੍, ਹੇ ਪੁਤ੍ਰ, ਕਥਮਾਵਾਂ ਪ੍ਰਤੀੱਥੰ ਸਮਾਚਰਸ੍ਤ੍ਵਮ੍? ਪਸ਼੍ਯ ਤਵ ਪਿਤਾਹਞ੍ਚ ਸ਼ੋਕਾਕੁਲੌ ਸਨ੍ਤੌ ਤ੍ਵਾਮਨ੍ਵਿੱਛਾਵਃ ਸ੍ਮ| ");
INSERT INTO sanpun_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ਤਤਃ ਸੋਵਦਤ੍ ਕੁਤੋ ਮਾਮ੍ ਅਨ੍ਵੈੱਛਤੰ? ਪਿਤੁਰ੍ਗ੍ਰੁʼਹੇ ਮਯਾ ਸ੍ਥਾਤਵ੍ਯਮ੍ ਏਤਤ੍ ਕਿੰ ਯੁਵਾਭ੍ਯਾਂ ਨ ਜ੍ਞਾਯਤੇ? ");
INSERT INTO sanpun_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","ਕਿਨ੍ਤੁ ਤੌ ਤਸ੍ਯੈਤਦ੍ਵਾਕ੍ਯਸ੍ਯ ਤਾਤ੍ਪਰ੍ੱਯੰ ਬੋੱਧੁੰ ਨਾਸ਼ਕ੍ਨੁਤਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ਤਤਃ ਪਰੰ ਸ ਤਾਭ੍ਯਾਂ ਸਹ ਨਾਸਰਤੰ ਗਤ੍ਵਾ ਤਯੋਰ੍ਵਸ਼ੀਭੂਤਸ੍ਤਸ੍ਥੌ ਕਿਨ੍ਤੁ ਸਰ੍ੱਵਾ ਏਤਾਃ ਕਥਾਸ੍ਤਸ੍ਯ ਮਾਤਾ ਮਨਸਿ ਸ੍ਥਾਪਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","ਅਥ ਯੀਸ਼ੋ ਰ੍ਬੁੱਧਿਃ ਸ਼ਰੀਰਞ੍ਚ ਤਥਾ ਤਸ੍ਮਿਨ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਮਾਨਵਾਨਾਞ੍ਚਾਨੁਗ੍ਰਹੋ ਵਰ੍ੱਧਿਤੁਮ੍ ਆਰੇਭੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","ਅਨਨ੍ਤਰੰ ਤਿਬਿਰਿਯਕੈਸਰਸ੍ਯ ਰਾਜਤ੍ਵਸ੍ਯ ਪਞ੍ਚਦਸ਼ੇ ਵਤ੍ਸਰੇ ਸਤਿ ਯਦਾ ਪਨ੍ਤੀਯਪੀਲਾਤੋ ਯਿਹੂਦਾਦੇਸ਼ਾਧਿਪਤਿ ਰ੍ਹੇਰੋਦ੍ ਤੁ ਗਾਲੀਲ੍ਪ੍ਰਦੇਸ਼ਸ੍ਯ ਰਾਜਾ ਫਿਲਿਪਨਾਮਾ ਤਸ੍ਯ ਭ੍ਰਾਤਾ ਤੁ ਯਿਤੂਰਿਯਾਯਾਸ੍ਤ੍ਰਾਖੋਨੀਤਿਯਾਪ੍ਰਦੇਸ਼ਸ੍ਯ ਚ ਰਾਜਾਸੀਤ੍ ਲੁਸ਼਼ਾਨੀਯਨਾਮਾ ਅਵਿਲੀਨੀਦੇਸ਼ਸ੍ਯ ਰਾਜਾਸੀਤ੍ ");
INSERT INTO sanpun_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ਹਾਨਨ੍ ਕਿਯਫਾਸ਼੍ਚੇਮੌ ਪ੍ਰਧਾਨਯਾਜਾਕਾਵਾਸ੍ਤਾਂ ਤਦਾਨੀਂ ਸਿਖਰਿਯਸ੍ਯ ਪੁਤ੍ਰਾਯ ਯੋਹਨੇ ਮਧ੍ਯੇਪ੍ਰਾਨ੍ਤਰਮ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਵਾਕ੍ਯੇ ਪ੍ਰਕਾਸ਼ਿਤੇ ਸਤਿ ");
INSERT INTO sanpun_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ਸ ਯਰ੍ੱਦਨ ਉਭਯਤਟਪ੍ਰਦੇਸ਼ਾਨ੍ ਸਮੇਤ੍ਯ ਪਾਪਮੋਚਨਾਰ੍ਥੰ ਮਨਃਪਰਾਵਰ੍ੱਤਨਸ੍ਯ ਚਿਹ੍ਨਰੂਪੰ ਯਨ੍ਮੱਜਨੰ ਤਦੀਯਾਃ ਕਥਾਃ ਸਰ੍ੱਵਤ੍ਰ ਪ੍ਰਚਾਰਯਿਤੁਮਾਰੇਭੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ਯਿਸ਼ਯਿਯਭਵਿਸ਼਼੍ਯਦ੍ਵਕ੍ਤ੍ਰੁʼਗ੍ਰਨ੍ਥੇ ਯਾਦ੍ਰੁʼਸ਼ੀ ਲਿਪਿਰਾਸ੍ਤੇ ਯਥਾ, ਪਰਮੇਸ਼ਸ੍ਯ ਪਨ੍ਥਾਨੰ ਪਰਿਸ਼਼੍ਕੁਰੁਤ ਸਰ੍ੱਵਤਃ| ਤਸ੍ਯ ਰਾਜਪਥਞ੍ਚੈਵ ਸਮਾਨੰ ਕੁਰੁਤਾਧੁਨਾ| ");
INSERT INTO sanpun_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ਕਾਰਿਸ਼਼੍ਯਨ੍ਤੇ ਸਮੁੱਛ੍ਰਾਯਾਃ ਸਕਲਾ ਨਿਮ੍ਨਭੂਮਯਃ| ਕਾਰਿਸ਼਼੍ਯਨ੍ਤੇ ਨਤਾਃ ਸਰ੍ੱਵੇ ਪਰ੍ੱਵਤਾਸ਼੍ਚੋਪਪਰ੍ੱਵਤਾਃ| ਕਾਰਿਸ਼਼੍ਯਨ੍ਤੇ ਚ ਯਾ ਵਕ੍ਰਾਸ੍ਤਾਃ ਸਰ੍ੱਵਾਃ ਸਰਲਾ ਭੁਵਃ| ਕਾਰਿਸ਼਼੍ਯਨ੍ਤੇ ਸਮਾਨਾਸ੍ਤਾ ਯਾ ਉੱਚਨੀਚਭੂਮਯਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ਈਸ਼੍ਵਰੇਣ ਕ੍ਰੁʼਤੰ ਤ੍ਰਾਣੰ ਦ੍ਰਕ੍ਸ਼਼੍ਯਨ੍ਤਿ ਸਰ੍ੱਵਮਾਨਵਾਃ| ਇਤ੍ਯੇਤਤ੍ ਪ੍ਰਾਨ੍ਤਰੇ ਵਾਕ੍ਯੰ ਵਦਤਃ ਕਸ੍ਯਚਿਦ੍ ਰਵਃ|| ");
INSERT INTO sanpun_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ਯੇ ਯੇ ਲੋਕਾ ਮੱਜਨਾਰ੍ਥੰ ਬਹਿਰਾਯਯੁਸ੍ਤਾਨ੍ ਸੋਵਦਤ੍ ਰੇ ਰੇ ਸਰ੍ਪਵੰਸ਼ਾ ਆਗਾਮਿਨਃ ਕੋਪਾਤ੍ ਪਲਾਯਿਤੁੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਕਸ਼੍ਚੇਤਯਾਮਾਸ? ");
INSERT INTO sanpun_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","ਤਸ੍ਮਾਦ੍ ਇਬ੍ਰਾਹੀਮ੍ ਅਸ੍ਮਾਕੰ ਪਿਤਾ ਕਥਾਮੀਦ੍ਰੁʼਸ਼ੀਂ ਮਨੋਭਿ ਰ੍ਨ ਕਥਯਿਤ੍ਵਾ ਯੂਯੰ ਮਨਃਪਰਿਵਰ੍ੱਤਨਯੋਗ੍ਯੰ ਫਲੰ ਫਲਤ; ਯੁਸ਼਼੍ਮਾਨਹੰ ਯਥਾਰ੍ਥੰ ਵਦਾਮਿ ਪਾਸ਼਼ਾਣੇਭ੍ਯ ਏਤੇਭ੍ਯ ਈਸ਼੍ਵਰ ਇਬ੍ਰਾਹੀਮਃ ਸਨ੍ਤਾਨੋਤ੍ਪਾਦਨੇ ਸਮਰ੍ਥਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ਅਪਰਞ੍ਚ ਤਰੁਮੂਲੇ(ਅ)ਧੁਨਾਪਿ ਪਰਸ਼ੁਃ ਸੰਲਗ੍ਨੋਸ੍ਤਿ ਯਸ੍ਤਰੁਰੁੱਤਮੰ ਫਲੰ ਨ ਫਲਤਿ ਸ ਛਿਦ੍ਯਤੇ(ਅ)ਗ੍ਨੌ ਨਿਕ੍ਸ਼਼ਿਪ੍ਯਤੇ ਚ| ");
INSERT INTO sanpun_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","ਤਦਾਨੀਂ ਲੋਕਾਸ੍ਤੰ ਪਪ੍ਰੱਛੁਸ੍ਤਰ੍ਹਿ ਕਿੰ ਕਰ੍ੱਤਵ੍ਯਮਸ੍ਮਾਭਿਃ? ");
INSERT INTO sanpun_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ਤਤਃ ਸੋਵਾਦੀਤ੍ ਯਸ੍ਯ ਦ੍ਵੇ ਵਸਨੇ ਵਿਦ੍ਯੇਤੇ ਸ ਵਸ੍ਤ੍ਰਹੀਨਾਯੈਕੰ ਵਿਤਰਤੁ ਕਿੰਞ੍ਚ ਯਸ੍ਯ ਖਾਦ੍ਯਦ੍ਰਵ੍ਯੰ ਵਿਦ੍ਯਤੇ ਸੋਪਿ ਤਥੈਵ ਕਰੋਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ਤਤਃ ਪਰੰ ਕਰਸਞ੍ਚਾਯਿਨੋ ਮੱਜਨਾਰ੍ਥਮ੍ ਆਗਤ੍ਯ ਪਪ੍ਰੱਛੁਃ ਹੇ ਗੁਰੋ ਕਿੰ ਕਰ੍ੱਤਵ੍ਯਮਸ੍ਮਾਭਿਃ? ");
INSERT INTO sanpun_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ਤਤਃ ਸੋਕਥਯਤ੍ ਨਿਰੂਪਿਤਾਦਧਿਕੰ ਨ ਗ੍ਰੁʼਹ੍ਲਿਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","ਅਨਨ੍ਤਰੰ ਸੇਨਾਗਣ ਏਤ੍ਯ ਪਪ੍ਰੱਛ ਕਿਮਸ੍ਮਾਭਿ ਰ੍ਵਾ ਕਰ੍ੱਤਵ੍ਯਮ੍? ਤਤਃ ਸੋਭਿਦਧੇ ਕਸ੍ਯ ਕਾਮਪਿ ਹਾਨਿੰ ਮਾ ਕਾਰ੍ਸ਼਼੍ਟ ਤਥਾ ਮ੍ਰੁʼਸ਼਼ਾਪਵਾਦੰ ਮਾ ਕੁਰੁਤ ਨਿਜਵੇਤਨੇਨ ਚ ਸਨ੍ਤੁਸ਼਼੍ਯ ਤਿਸ਼਼੍ਠਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","ਅਪਰਞ੍ਚ ਲੋਕਾ ਅਪੇਕ੍ਸ਼਼ਯਾ ਸ੍ਥਿਤ੍ਵਾ ਸਰ੍ੱਵੇਪੀਤਿ ਮਨੋਭਿ ਰ੍ਵਿਤਰ੍ਕਯਾਞ੍ਚਕ੍ਰੁਃ, ਯੋਹਨਯਮ੍ ਅਭਿਸ਼਼ਿਕ੍ਤਸ੍ਤ੍ਰਾਤਾ ਨ ਵੇਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ਤਦਾ ਯੋਹਨ੍ ਸਰ੍ੱਵਾਨ੍ ਵ੍ਯਾਜਹਾਰ, ਜਲੇ(ਅ)ਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਮੱਜਯਾਮਿ ਸਤ੍ਯੰ ਕਿਨ੍ਤੁ ਯਸ੍ਯ ਪਾਦੁਕਾਬਨ੍ਧਨੰ ਮੋਚਯਿਤੁਮਪਿ ਨ ਯੋਗ੍ਯੋਸ੍ਮਿ ਤਾਦ੍ਰੁʼਸ਼ ਏਕੋ ਮੱਤੋ ਗੁਰੁਤਰਃ ਪੁਮਾਨ੍ ਏਤਿ, ਸ ਯੁਸ਼਼੍ਮਾਨ੍ ਵਹ੍ਨਿਰੂਪੇ ਪਵਿਤ੍ਰ ਆਤ੍ਮਨਿ ਮੱਜਯਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ਅਪਰਞ੍ਚ ਤਸ੍ਯ ਹਸ੍ਤੇ ਸ਼ੂਰ੍ਪ ਆਸ੍ਤੇ ਸ ਸ੍ਵਸ਼ਸ੍ਯਾਨਿ ਸ਼ੁੱਧਰੂਪੰ ਪ੍ਰਸ੍ਫੋਟ੍ਯ ਗੋਧੂਮਾਨ੍ ਸਰ੍ੱਵਾਨ੍ ਭਾਣ੍ਡਾਗਾਰੇ ਸੰਗ੍ਰਹੀਸ਼਼੍ਯਤਿ ਕਿਨ੍ਤੁ ਬੂਸ਼਼ਾਣਿ ਸਰ੍ੱਵਾਣ੍ਯਨਿਰ੍ੱਵਾਣਵਹ੍ਨਿਨਾ ਦਾਹਯਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ਯੋਹਨ੍ ਉਪਦੇਸ਼ੇਨੇੱਥੰ ਨਾਨਾਕਥਾ ਲੋਕਾਨਾਂ ਸਮਕ੍ਸ਼਼ੰ ਪ੍ਰਚਾਰਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ਅਪਰਞ੍ਚ ਹੇਰੋਦ੍ ਰਾਜਾ ਫਿਲਿਪ੍ਨਾਮ੍ਨਃ ਸਹੋਦਰਸ੍ਯ ਭਾਰ੍ੱਯਾਂ ਹੇਰੋਦਿਯਾਮਧਿ ਤਥਾਨ੍ਯਾਨਿ ਯਾਨਿ ਯਾਨਿ ਕੁਕਰ੍ੰਮਾਣਿ ਕ੍ਰੁʼਤਵਾਨ੍ ਤਦਧਿ ਚ ");
INSERT INTO sanpun_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ਯੋਹਨਾ ਤਿਰਸ੍ਕ੍ਰੁʼਤੋ ਭੂਤ੍ਵਾ ਕਾਰਾਗਾਰੇ ਤਸ੍ਯ ਬਨ੍ਧਨਾਦ੍ ਅਪਰਮਪਿ ਕੁਕਰ੍ੰਮ ਚਕਾਰ| ");
INSERT INTO sanpun_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ਇਤਃ ਪੂਰ੍ੱਵੰ ਯਸ੍ਮਿਨ੍ ਸਮਯੇ ਸਰ੍ੱਵੇ ਯੋਹਨਾ ਮੱਜਿਤਾਸ੍ਤਦਾਨੀਂ ਯੀਸ਼ੁਰਪ੍ਯਾਗਤ੍ਯ ਮੱਜਿਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ਤਦਨਨ੍ਤਰੰ ਤੇਨ ਪ੍ਰਾਰ੍ਥਿਤੇ ਮੇਘਦ੍ਵਾਰੰ ਮੁਕ੍ਤੰ ਤਸ੍ਮਾੱਚ ਪਵਿਤ੍ਰ ਆਤ੍ਮਾ ਮੂਰ੍ੱਤਿਮਾਨ੍ ਭੂਤ੍ਵਾ ਕਪੋਤਵਤ੍ ਤਦੁਪਰ੍ੱਯਵਰੁਰੋਹ; ਤਦਾ ਤ੍ਵੰ ਮਮ ਪ੍ਰਿਯਃ ਪੁਤ੍ਰਸ੍ਤ੍ਵਯਿ ਮਮ ਪਰਮਃ ਸਨ੍ਤੋਸ਼਼ ਇਤ੍ਯਾਕਾਸ਼ਵਾਣੀ ਬਭੂਵ| ");
INSERT INTO sanpun_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","ਤਦਾਨੀਂ ਯੀਸ਼ੁਃ ਪ੍ਰਾਯੇਣ ਤ੍ਰਿੰਸ਼ਦ੍ਵਰ੍ਸ਼਼ਵਯਸ੍ਕ ਆਸੀਤ੍| ਲੌਕਿਕਜ੍ਞਾਨੇ ਤੁ ਸ ਯੂਸ਼਼ਫਃ ਪੁਤ੍ਰਃ, ");
INSERT INTO sanpun_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ਯੂਸ਼਼ਫ੍ ਏਲੇਃ ਪੁਤ੍ਰਃ, ਏਲਿਰ੍ਮੱਤਤਃ ਪੁਤ੍ਰਃ, ਮੱਤਤ੍ ਲੇਵੇਃ ਪੁਤ੍ਰਃ, ਲੇਵਿ ਰ੍ਮਲ੍ਕੇਃ ਪੁਤ੍ਰਃ, ਮਲ੍ਕਿਰ੍ਯਾੰਨਸ੍ਯ ਪੁਤ੍ਰਃ; ਯਾੰਨੋ ਯੂਸ਼਼ਫਃ ਪੁਤ੍ਰਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ਯੂਸ਼਼ਫ੍ ਮੱਤਥਿਯਸ੍ਯ ਪੁਤ੍ਰਃ, ਮੱਤਥਿਯ ਆਮੋਸਃ ਪੁਤ੍ਰਃ, ਆਮੋਸ੍ ਨਹੂਮਃ ਪੁਤ੍ਰਃ, ਨਹੂਮ੍ ਇਸ਼਼੍ਲੇਃ ਪੁਤ੍ਰਃ ਇਸ਼਼੍ਲਿਰ੍ਨਗੇਃ ਪੁਤ੍ਰਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ਨਗਿਰ੍ਮਾਟਃ ਪੁਤ੍ਰਃ, ਮਾਟ੍ ਮੱਤਥਿਯਸ੍ਯ ਪੁਤ੍ਰਃ, ਮੱਤਥਿਯਃ ਸ਼ਿਮਿਯੇਃ ਪੁਤ੍ਰਃ, ਸ਼ਿਮਿਯਿਰ੍ਯੂਸ਼਼ਫਃ ਪੁਤ੍ਰਃ, ਯੂਸ਼਼ਫ੍ ਯਿਹੂਦਾਃ ਪੁਤ੍ਰਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ਯਿਹੂਦਾ ਯੋਹਾਨਾਃ ਪੁਤ੍ਰਃ, ਯੋਹਾਨਾ ਰੀਸ਼਼ਾਃ ਪੁਤ੍ਰਃ, ਰੀਸ਼਼ਾਃ ਸਿਰੁੱਬਾਬਿਲਃ ਪੁਤ੍ਰਃ, ਸਿਰੁੱਬਾਬਿਲ੍ ਸ਼ਲ੍ਤੀਯੇਲਃ ਪੁਤ੍ਰਃ, ਸ਼ਲ੍ਤੀਯੇਲ੍ ਨੇਰੇਃ ਪੁਤ੍ਰਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ਨੇਰਿਰ੍ਮਲ੍ਕੇਃ ਪੁਤ੍ਰਃ, ਮਲ੍ਕਿਃ ਅਦ੍ਯਃ ਪੁਤ੍ਰਃ, ਅੱਦੀ ਕੋਸ਼਼ਮਃ ਪੁਤ੍ਰਃ, ਕੋਸ਼਼ਮ੍ ਇਲ੍ਮੋਦਦਃ ਪੁਤ੍ਰਃ, ਇਲ੍ਮੋਦਦ੍ ਏਰਃ ਪੁਤ੍ਰਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ਏਰ੍ ਯੋਸ਼ੇਃ ਪੁਤ੍ਰਃ, ਯੋਸ਼ਿਃ ਇਲੀਯੇਸ਼਼ਰਃ ਪੁਤ੍ਰਃ, ਇਲੀਯੇਸ਼਼ਰ੍ ਯੋਰੀਮਃ ਪੁਤ੍ਰਃ, ਯੋਰੀਮ੍ ਮੱਤਤਃ ਪੁਤ੍ਰਃ, ਮੱਤਤ ਲੇਵੇਃ ਪੁਤ੍ਰਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ਲੇਵਿਃ ਸ਼ਿਮਿਯੋਨਃ ਪੁਤ੍ਰਃ, ਸ਼ਿਮਿਯੋਨ੍ ਯਿਹੂਦਾਃ ਪੁਤ੍ਰਃ, ਯਿਹੂਦਾ ਯੂਸ਼਼ੁਫਃ ਪੁਤ੍ਰਃ, ਯੂਸ਼਼ੁਫ੍ ਯੋਨਨਃ ਪੁਤ੍ਰਃ, ਯਾਨਨ੍ ਇਲੀਯਾਕੀਮਃ ਪੁਤ੍ਰਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ਇਲਿਯਾਕੀਮ੍ਃ ਮਿਲੇਯਾਃ ਪੁਤ੍ਰਃ, ਮਿਲੇਯਾ ਮੈਨਨਃ ਪੁਤ੍ਰਃ, ਮੈਨਨ੍ ਮੱਤੱਤਸ੍ਯ ਪੁਤ੍ਰਃ, ਮੱਤੱਤੋ ਨਾਥਨਃ ਪੁਤ੍ਰਃ, ਨਾਥਨ੍ ਦਾਯੂਦਃ ਪੁਤ੍ਰਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ਦਾਯੂਦ੍ ਯਿਸ਼ਯਃ ਪੁਤ੍ਰਃ, ਯਿਸ਼ਯ ਓਬੇਦਃ ਪੁਤ੍ਰ, ਓਬੇਦ੍ ਬੋਯਸਃ ਪੁਤ੍ਰਃ, ਬੋਯਸ੍ ਸਲ੍ਮੋਨਃ ਪੁਤ੍ਰਃ, ਸਲ੍ਮੋਨ੍ ਨਹਸ਼ੋਨਃ ਪੁਤ੍ਰਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ਨਹਸ਼ੋਨ੍ ਅੰਮੀਨਾਦਬਃ ਪੁਤ੍ਰਃ, ਅੰਮੀਨਾਦਬ੍ ਅਰਾਮਃ ਪੁਤ੍ਰਃ, ਅਰਾਮ੍ ਹਿਸ਼਼੍ਰੋਣਃ ਪੁਤ੍ਰਃ, ਹਿਸ਼਼੍ਰੋਣ੍ ਪੇਰਸਃ ਪੁਤ੍ਰਃ, ਪੇਰਸ੍ ਯਿਹੂਦਾਃ ਪੁਤ੍ਰਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ਯਿਹੂਦਾ ਯਾਕੂਬਃ ਪੁਤ੍ਰਃ, ਯਾਕੂਬ੍ ਇਸ੍ਹਾਕਃ ਪੁਤ੍ਰਃ, ਇਸ੍ਹਾਕ੍ ਇਬ੍ਰਾਹੀਮਃ ਪੁਤ੍ਰਃ, ਇਬ੍ਰਾਹੀਮ੍ ਤੇਰਹਃ ਪੁਤ੍ਰਃ, ਤੇਰਹ੍ ਨਾਹੋਰਃ ਪੁਤ੍ਰਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ਨਾਹੋਰ੍ ਸਿਰੁਗਃ ਪੁਤ੍ਰਃ, ਸਿਰੁਗ੍ ਰਿਯ੍ਵਃ ਪੁਤ੍ਰਃ, ਰਿਯੂਃ ਪੇਲਗਃ ਪੁਤ੍ਰਃ, ਪੇਲਗ੍ ਏਵਰਃ ਪੁਤ੍ਰਃ, ਏਵਰ੍ ਸ਼ੇਲਹਃ ਪੁਤ੍ਰਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ਸ਼ੇਲਹ੍ ਕੈਨਨਃ ਪੁਤ੍ਰਃ, ਕੈਨਨ੍ ਅਰ੍ਫਕ੍ਸ਼਼ਦਃ ਪੁਤ੍ਰਃ, ਅਰ੍ਫਕ੍ਸ਼਼ਦ੍ ਸ਼ਾਮਃ ਪੁਤ੍ਰਃ, ਸ਼ਾਮ੍ ਨੋਹਃ ਪੁਤ੍ਰਃ, ਨੋਹੋ ਲੇਮਕਃ ਪੁਤ੍ਰਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ਲੇਮਕ੍ ਮਿਥੂਸ਼ੇਲਹਃ ਪੁਤ੍ਰਃ, ਮਿਥੂਸ਼ੇਲਹ੍ ਹਨੋਕਃ ਪੁਤ੍ਰਃ, ਹਨੋਕ੍ ਯੇਰਦਃ ਪੁਤ੍ਰਃ, ਯੇਰਦ੍ ਮਹਲਲੇਲਃ ਪੁਤ੍ਰਃ, ਮਹਲਲੇਲ੍ ਕੈਨਨਃ ਪੁਤ੍ਰਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ਕੈਨਨ੍ ਇਨੋਸ਼ਃ ਪੁਤ੍ਰਃ, ਇਨੋਸ਼੍ ਸ਼ੇਤਃ ਪੁਤ੍ਰਃ, ਸ਼ੇਤ੍ ਆਦਮਃ ਪੁਤ੍ਰ, ਆਦਮ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਪੁਤ੍ਰਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ਤਤਃ ਪਰੰ ਯੀਸ਼ੁਃ ਪਵਿਤ੍ਰੇਣਾਤ੍ਮਨਾ ਪੂਰ੍ਣਃ ਸਨ੍ ਯਰ੍ੱਦਨਨਦ੍ਯਾਃ ਪਰਾਵ੍ਰੁʼਤ੍ਯਾਤ੍ਮਨਾ ਪ੍ਰਾਨ੍ਤਰੰ ਨੀਤਃ ਸਨ੍ ਚਤ੍ਵਾਰਿੰਸ਼ੱਦਿਨਾਨਿ ਯਾਵਤ੍ ਸ਼ੈਤਾਨਾ ਪਰੀਕ੍ਸ਼਼ਿਤੋ(ਅ)ਭੂਤ੍, ");
INSERT INTO sanpun_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ਕਿਞ੍ਚ ਤਾਨਿ ਸਰ੍ੱਵਦਿਨਾਨਿ ਭੋਜਨੰ ਵਿਨਾ ਸ੍ਥਿਤਤ੍ਵਾਤ੍ ਕਾਲੇ ਪੂਰ੍ਣੇ ਸ ਕ੍ਸ਼਼ੁਧਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ਤਤਃ ਸ਼ੈਤਾਨਾਗਤ੍ਯ ਤਮਵਦਤ੍ ਤ੍ਵੰ ਚੇਦੀਸ਼੍ਵਰਸ੍ਯ ਪੁਤ੍ਰਸ੍ਤਰ੍ਹਿ ਪ੍ਰਸ੍ਤਰਾਨੇਤਾਨ੍ ਆਜ੍ਞਯਾ ਪੂਪਾਨ੍ ਕੁਰੁ| ");
INSERT INTO sanpun_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","ਤਦਾ ਯੀਸ਼ੁਰੁਵਾਚ, ਲਿਪਿਰੀਦ੍ਰੁʼਸ਼ੀ ਵਿਦ੍ਯਤੇ ਮਨੁਜਃ ਕੇਵਲੇਨ ਪੂਪੇਨ ਨ ਜੀਵਤਿ ਕਿਨ੍ਤ੍ਵੀਸ਼੍ਵਰਸ੍ਯ ਸਰ੍ੱਵਾਭਿਰਾਜ੍ਞਾਭਿ ਰ੍ਜੀਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ਤਦਾ ਸ਼ੈਤਾਨ੍ ਤਮੁੱਚੰ ਪਰ੍ੱਵਤੰ ਨੀਤ੍ਵਾ ਨਿਮਿਸ਼਼ੈਕਮਧ੍ਯੇ ਜਗਤਃ ਸਰ੍ੱਵਰਾਜ੍ਯਾਨਿ ਦਰ੍ਸ਼ਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ਪਸ਼੍ਚਾਤ੍ ਤਮਵਾਦੀਤ੍ ਸਰ੍ੱਵਮ੍ ਏਤਦ੍ ਵਿਭਵੰ ਪ੍ਰਤਾਪਞ੍ਚ ਤੁਭ੍ਯੰ ਦਾਸ੍ਯਾਮਿ ਤਨ੍ ਮਯਿ ਸਮਰ੍ਪਿਤਮਾਸ੍ਤੇ ਯੰ ਪ੍ਰਤਿ ਮਮੇੱਛਾ ਜਾਯਤੇ ਤਸ੍ਮੈ ਦਾਤੁੰ ਸ਼ਕ੍ਨੋਮਿ, ");
INSERT INTO sanpun_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ਤ੍ਵੰ ਚੇਨ੍ਮਾਂ ਭਜਸੇ ਤਰ੍ਹਿ ਸਰ੍ੱਵਮੇਤਤ੍ ਤਵੈਵ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","ਤਦਾ ਯੀਸ਼ੁਸ੍ਤੰ ਪ੍ਰਤ੍ਯੁਕ੍ਤਵਾਨ੍ ਦੂਰੀ ਭਵ ਸ਼ੈਤਾਨ੍ ਲਿਪਿਰਾਸ੍ਤੇ, ਨਿਜੰ ਪ੍ਰਭੁੰ ਪਰਮੇਸ਼੍ਵਰੰ ਭਜਸ੍ਵ ਕੇਵਲੰ ਤਮੇਵ ਸੇਵਸ੍ਵ ਚ| ");
INSERT INTO sanpun_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ਅਥ ਸ਼ੈਤਾਨ੍ ਤੰ ਯਿਰੂਸ਼ਾਲਮੰ ਨੀਤ੍ਵਾ ਮਨ੍ਦਿਰਸ੍ਯ ਚੂਡਾਯਾ ਉਪਰਿ ਸਮੁਪਵੇਸ਼੍ਯ ਜਗਾਦ ਤ੍ਵੰ ਚੇਦੀਸ਼੍ਵਰਸ੍ਯ ਪੁਤ੍ਰਸ੍ਤਰ੍ਹਿ ਸ੍ਥਾਨਾਦਿਤੋ ਲਮ੍ਫਿਤ੍ਵਾਧਃ ");
INSERT INTO sanpun_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ਪਤ ਯਤੋ ਲਿਪਿਰਾਸ੍ਤੇ, ਆਜ੍ਞਾਪਯਿਸ਼਼੍ਯਤਿ ਸ੍ਵੀਯਾਨ੍ ਦੂਤਾਨ੍ ਸ ਪਰਮੇਸ਼੍ਵਰਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ਰਕ੍ਸ਼਼ਿਤੁੰ ਸਰ੍ੱਵਮਾਰ੍ਗੇ ਤ੍ਵਾਂ ਤੇਨ ਤ੍ਵੱਚਰਣੇ ਯਥਾ| ਨ ਲਗੇਤ੍ ਪ੍ਰਸ੍ਤਰਾਘਾਤਸ੍ਤ੍ਵਾਂ ਧਰਿਸ਼਼੍ਯਨ੍ਤਿ ਤੇ ਤਥਾ| ");
INSERT INTO sanpun_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","ਤਦਾ ਯੀਸ਼ੁਨਾ ਪ੍ਰਤ੍ਯੁਕ੍ਤਮ੍ ਇਦਮਪ੍ਯੁਕ੍ਤਮਸ੍ਤਿ ਤ੍ਵੰ ਸ੍ਵਪ੍ਰਭੁੰ ਪਰੇਸ਼ੰ ਮਾ ਪਰੀਕ੍ਸ਼਼ਸ੍ਵ| ");
INSERT INTO sanpun_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","ਪਸ਼੍ਚਾਤ੍ ਸ਼ੈਤਾਨ੍ ਸਰ੍ੱਵਪਰੀਕ੍ਸ਼਼ਾਂ ਸਮਾਪ੍ਯ ਕ੍ਸ਼਼ਣਾੱਤੰ ਤ੍ਯਕ੍ਤ੍ਵਾ ਯਯੌ| ");
INSERT INTO sanpun_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","ਤਦਾ ਯੀਸ਼ੁਰਾਤ੍ਮਪ੍ਰਭਾਵਾਤ੍ ਪੁਨਰ੍ਗਾਲੀਲ੍ਪ੍ਰਦੇਸ਼ੰ ਗਤਸ੍ਤਦਾ ਤਤ੍ਸੁਖ੍ਯਾਤਿਸ਼੍ਚਤੁਰ੍ਦਿਸ਼ੰ ਵ੍ਯਾਨਸ਼ੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ਸ ਤੇਸ਼਼ਾਂ ਭਜਨਗ੍ਰੁʼਹੇਸ਼਼ੁ ਉਪਦਿਸ਼੍ਯ ਸਰ੍ੱਵੈਃ ਪ੍ਰਸ਼ੰਸਿਤੋ ਬਭੂਵ| ");
INSERT INTO sanpun_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","ਅਥ ਸ ਸ੍ਵਪਾਲਨਸ੍ਥਾਨੰ ਨਾਸਰਤ੍ਪੁਰਮੇਤ੍ਯ ਵਿਸ਼੍ਰਾਮਵਾਰੇ ਸ੍ਵਾਚਾਰਾਦ੍ ਭਜਨਗੇਹੰ ਪ੍ਰਵਿਸ਼੍ਯ ਪਠਿਤੁਮੁੱਤਸ੍ਥੌ| ");
INSERT INTO sanpun_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ਤਤੋ ਯਿਸ਼ਯਿਯਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਃ ਪੁਸ੍ਤਕੇ ਤਸ੍ਯ ਕਰਦੱਤੇ ਸਤਿ ਸ ਤਤ੍ ਪੁਸ੍ਤਕੰ ਵਿਸ੍ਤਾਰ੍ੱਯ ਯਤ੍ਰ ਵਕ੍ਸ਼਼੍ਯਮਾਣਾਨਿ ਵਚਨਾਨਿ ਸਨ੍ਤਿ ਤਤ੍ ਸ੍ਥਾਨੰ ਪ੍ਰਾਪ੍ਯ ਪਪਾਠ| ");
INSERT INTO sanpun_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","ਆਤ੍ਮਾ ਤੁ ਪਰਮੇਸ਼ਸ੍ਯ ਮਦੀਯੋਪਰਿ ਵਿਦ੍ਯਤੇ| ਦਰਿਦ੍ਰੇਸ਼਼ੁ ਸੁਸੰਵਾਦੰ ਵਕ੍ਤੁੰ ਮਾਂ ਸੋਭਿਸ਼਼ਿਕ੍ਤਵਾਨ੍| ਭਗ੍ਨਾਨ੍ਤਃ ਕਰਣਾੱਲੋਕਾਨ੍ ਸੁਸ੍ਵਸ੍ਥਾਨ੍ ਕਰ੍ੱਤੁਮੇਵ ਚ| ਬਨ੍ਦੀਕ੍ਰੁʼਤੇਸ਼਼ੁ ਲੋਕੇਸ਼਼ੁ ਮੁਕ੍ਤੇ ਰ੍ਘੋਸ਼਼ਯਿਤੁੰ ਵਚਃ| ਨੇਤ੍ਰਾਣਿ ਦਾਤੁਮਨ੍ਧੇਭ੍ਯਸ੍ਤ੍ਰਾਤੁੰ ਬੱਧਜਨਾਨਪਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ਪਰੇਸ਼ਾਨੁਗ੍ਰਹੇ ਕਾਲੰ ਪ੍ਰਚਾਰਯਿਤੁਮੇਵ ਚ| ਸਰ੍ੱਵੈਤਤ੍ਕਰਣਾਰ੍ਥਾਯ ਮਾਮੇਵ ਪ੍ਰਹਿਣੋਤਿ ਸਃ|| ");
INSERT INTO sanpun_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ਤਤਃ ਪੁਸ੍ਤਕੰ ਬਦ੍ੱਵਾ ਪਰਿਚਾਰਕਸ੍ਯ ਹਸ੍ਤੇ ਸਮਰ੍ਪ੍ਯ ਚਾਸਨੇ ਸਮੁਪਵਿਸ਼਼੍ਟਃ, ਤਤੋ ਭਜਨਗ੍ਰੁʼਹੇ ਯਾਵਨ੍ਤੋ ਲੋਕਾ ਆਸਨ੍ ਤੇ ਸਰ੍ੱਵੇ(ਅ)ਨਨ੍ਯਦ੍ਰੁʼਸ਼਼੍ਟ੍ਯਾ ਤੰ ਵਿਲੁਲੋਕਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ਅਨਨ੍ਤਰਮ੍ ਅਦ੍ਯੈਤਾਨਿ ਸਰ੍ੱਵਾਣਿ ਲਿਖਿਤਵਚਨਾਨਿ ਯੁਸ਼਼੍ਮਾਕੰ ਮਧ੍ਯੇ ਸਿੱਧਾਨਿ ਸ ਇਮਾਂ ਕਥਾਂ ਤੇਭ੍ਯਃ ਕਥਯਿਤੁਮਾਰੇਭੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ਤਤਃ ਸਰ੍ੱਵੇ ਤਸ੍ਮਿਨ੍ ਅਨ੍ਵਰਜ੍ਯਨ੍ਤ, ਕਿਞ੍ਚ ਤਸ੍ਯ ਮੁਖਾੰਨਿਰ੍ਗਤਾਭਿਰਨੁਗ੍ਰਹਸ੍ਯ ਕਥਾਭਿਸ਼੍ਚਮਤ੍ਕ੍ਰੁʼਤ੍ਯ ਕਥਯਾਮਾਸੁਃ ਕਿਮਯੰ ਯੂਸ਼਼ਫਃ ਪੁਤ੍ਰੋ ਨ? ");
INSERT INTO sanpun_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ਤਦਾ ਸੋ(ਅ)ਵਾਦੀਦ੍ ਹੇ ਚਿਕਿਤ੍ਸਕ ਸ੍ਵਮੇਵ ਸ੍ਵਸ੍ਥੰ ਕੁਰੁ ਕਫਰ੍ਨਾਹੂਮਿ ਯਦ੍ਯਤ੍ ਕ੍ਰੁʼਤਵਾਨ੍ ਤਦਸ਼੍ਰੌਸ਼਼੍ਮ ਤਾਃ ਸਰ੍ਵਾਃ ਕ੍ਰਿਯਾ ਅਤ੍ਰ ਸ੍ਵਦੇਸ਼ੇ ਕੁਰੁ ਕਥਾਮੇਤਾਂ ਯੂਯਮੇਵਾਵਸ਼੍ਯੰ ਮਾਂ ਵਦਿਸ਼਼੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ਪੁਨਃ ਸੋਵਾਦੀਦ੍ ਯੁਸ਼਼੍ਮਾਨਹੰ ਯਥਾਰ੍ਥੰ ਵਦਾਮਿ, ਕੋਪਿ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦੀ ਸ੍ਵਦੇਸ਼ੇ ਸਤ੍ਕਾਰੰ ਨ ਪ੍ਰਾਪ੍ਨੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","ਅਪਰਞ੍ਚ ਯਥਾਰ੍ਥੰ ਵਚ੍ਮਿ, ਏਲਿਯਸ੍ਯ ਜੀਵਨਕਾਲੇ ਯਦਾ ਸਾਰ੍ੱਧਤ੍ਰਿਤਯਵਰ੍ਸ਼਼ਾਣਿ ਯਾਵਤ੍ ਜਲਦਪ੍ਰਤਿਬਨ੍ਧਾਤ੍ ਸਰ੍ੱਵਸ੍ਮਿਨ੍ ਦੇਸ਼ੇ ਮਹਾਦੁਰ੍ਭਿਕ੍ਸ਼਼ਮ੍ ਅਜਨਿਸ਼਼੍ਟ ਤਦਾਨੀਮ੍ ਇਸ੍ਰਾਯੇਲੋ ਦੇਸ਼ਸ੍ਯ ਮਧ੍ਯੇ ਬਹ੍ਵ੍ਯੋ ਵਿਧਵਾ ਆਸਨ੍, ");
INSERT INTO sanpun_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ਕਿਨ੍ਤੁ ਸੀਦੋਨ੍ਪ੍ਰਦੇਸ਼ੀਯਸਾਰਿਫਤ੍ਪੁਰਨਿਵਾਸਿਨੀਮ੍ ਏਕਾਂ ਵਿਧਵਾਂ ਵਿਨਾ ਕਸ੍ਯਾਸ਼੍ਚਿਦਪਿ ਸਮੀਪੇ ਏਲਿਯਃ ਪ੍ਰੇਰਿਤੋ ਨਾਭੂਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","ਅਪਰਞ੍ਚ ਇਲੀਸ਼ਾਯਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਵਿਦ੍ਯਮਾਨਤਾਕਾਲੇ ਇਸ੍ਰਾਯੇਲ੍ਦੇਸ਼ੇ ਬਹਵਃ ਕੁਸ਼਼੍ਠਿਨ ਆਸਨ੍ ਕਿਨ੍ਤੁ ਸੁਰੀਯਦੇਸ਼ੀਯੰ ਨਾਮਾਨ੍ਕੁਸ਼਼੍ਠਿਨੰ ਵਿਨਾ ਕੋਪ੍ਯਨ੍ਯਃ ਪਰਿਸ਼਼੍ਕ੍ਰੁʼਤੋ ਨਾਭੂਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ਇਮਾਂ ਕਥਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਭਜਨਗੇਹਸ੍ਥਿਤਾ ਲੋਕਾਃ ਸਕ੍ਰੋਧਮ੍ ਉੱਥਾਯ ");
INSERT INTO sanpun_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ਨਗਰਾੱਤੰ ਬਹਿਸ਼਼੍ਕ੍ਰੁʼਤ੍ਯ ਯਸ੍ਯ ਸ਼ਿਖਰਿਣ ਉਪਰਿ ਤੇਸ਼਼ਾਂ ਨਗਰੰ ਸ੍ਥਾਪਿਤਮਾਸ੍ਤੇ ਤਸ੍ਮਾੰਨਿਕ੍ਸ਼਼ੇਪ੍ਤੁੰ ਤਸ੍ਯ ਸ਼ਿਖਰੰ ਤੰ ਨਿਨ੍ਯੁਃ ");
INSERT INTO sanpun_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","ਕਿਨ੍ਤੁ ਸ ਤੇਸ਼਼ਾਂ ਮਧ੍ਯਾਦਪਸ੍ਰੁʼਤ੍ਯ ਸ੍ਥਾਨਾਨ੍ਤਰੰ ਜਗਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ਤਤਃ ਪਰੰ ਯੀਸ਼ੁਰ੍ਗਾਲੀਲ੍ਪ੍ਰਦੇਸ਼ੀਯਕਫਰ੍ਨਾਹੂਮ੍ਨਗਰ ਉਪਸ੍ਥਾਯ ਵਿਸ਼੍ਰਾਮਵਾਰੇ ਲੋਕਾਨੁਪਦੇਸ਼਼੍ਟੁਮ੍ ਆਰਬ੍ਧਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ਤਦੁਪਦੇਸ਼ਾਤ੍ ਸਰ੍ੱਵੇ ਚਮੱਚਕ੍ਰੁ ਰ੍ਯਤਸ੍ਤਸ੍ਯ ਕਥਾ ਗੁਰੁਤਰਾ ਆਸਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","ਤਦਾਨੀਂ ਤਦ੍ਭਜਨਗੇਹਸ੍ਥਿਤੋ(ਅ)ਮੇਧ੍ਯਭੂਤਗ੍ਰਸ੍ਤ ਏਕੋ ਜਨ ਉੱਚੈਃ ਕਥਯਾਮਾਸ, ");
INSERT INTO sanpun_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","ਹੇ ਨਾਸਰਤੀਯਯੀਸ਼ੋ(ਅ)ਸ੍ਮਾਨ੍ ਤ੍ਯਜ, ਤ੍ਵਯਾ ਸਹਾਸ੍ਮਾਕੰ ਕਃ ਸਮ੍ਬਨ੍ਧਃ? ਕਿਮਸ੍ਮਾਨ੍ ਵਿਨਾਸ਼ਯਿਤੁਮਾਯਾਸਿ? ਤ੍ਵਮੀਸ਼੍ਵਰਸ੍ਯ ਪਵਿਤ੍ਰੋ ਜਨ ਏਤਦਹੰ ਜਾਨਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","ਤਦਾ ਯੀਸ਼ੁਸ੍ਤੰ ਤਰ੍ਜਯਿਤ੍ਵਾਵਦਤ੍ ਮੌਨੀ ਭਵ ਇਤੋ ਬਹਿਰ੍ਭਵ; ਤਤਃ ਸੋਮੇਧ੍ਯਭੂਤਸ੍ਤੰ ਮਧ੍ਯਸ੍ਥਾਨੇ ਪਾਤਯਿਤ੍ਵਾ ਕਿਞ੍ਚਿਦਪ੍ਯਹਿੰਸਿਤ੍ਵਾ ਤਸ੍ਮਾਦ੍ ਬਹਿਰ੍ਗਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ਤਤਃ ਸਰ੍ੱਵੇ ਲੋਕਾਸ਼੍ਚਮਤ੍ਕ੍ਰੁʼਤ੍ਯ ਪਰਸ੍ਪਰੰ ਵਕ੍ਤੁਮਾਰੇਭਿਰੇ ਕੋਯੰ ਚਮਤ੍ਕਾਰਃ| ਏਸ਼਼ ਪ੍ਰਭਾਵੇਣ ਪਰਾਕ੍ਰਮੇਣ ਚਾਮੇਧ੍ਯਭੂਤਾਨ੍ ਆਜ੍ਞਾਪਯਤਿ ਤੇਨੈਵ ਤੇ ਬਹਿਰ੍ਗੱਛਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ਅਨਨ੍ਤਰੰ ਚਤੁਰ੍ਦਿਕ੍ਸ੍ਥਦੇਸ਼ਾਨ੍ ਤਸ੍ਯ ਸੁਖ੍ਯਾਤਿਰ੍ਵ੍ਯਾਪ੍ਨੋਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ਤਦਨਨ੍ਤਰੰ ਸ ਭਜਨਗੇਹਾਦ੍ ਬਹਿਰਾਗਤ੍ਯ ਸ਼ਿਮੋਨੋ ਨਿਵੇਸ਼ਨੰ ਪ੍ਰਵਿਵੇਸ਼ ਤਦਾ ਤਸ੍ਯ ਸ਼੍ਵਸ਼੍ਰੂਰ੍ਜ੍ਵਰੇਣਾਤ੍ਯਨ੍ਤੰ ਪੀਡਿਤਾਸੀਤ੍ ਸ਼ਿਸ਼਼੍ਯਾਸ੍ਤਦਰ੍ਥੰ ਤਸ੍ਮਿਨ੍ ਵਿਨਯੰ ਚਕ੍ਰੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ਤਤਃ ਸ ਤਸ੍ਯਾਃ ਸਮੀਪੇ ਸ੍ਥਿਤ੍ਵਾ ਜ੍ਵਰੰ ਤਰ੍ਜਯਾਮਾਸ ਤੇਨੈਵ ਤਾਂ ਜ੍ਵਰੋ(ਅ)ਤ੍ਯਾਕ੍ਸ਼਼ੀਤ੍ ਤਤਃ ਸਾ ਤਤ੍ਕ੍ਸ਼਼ਣਮ੍ ਉੱਥਾਯ ਤਾਨ੍ ਸਿਸ਼਼ੇਵੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","ਅਥ ਸੂਰ੍ੱਯਾਸ੍ਤਕਾਲੇ ਸ੍ਵੇਸ਼਼ਾਂ ਯੇ ਯੇ ਜਨਾ ਨਾਨਾਰੋਗੈਃ ਪੀਡਿਤਾ ਆਸਨ੍ ਲੋਕਾਸ੍ਤਾਨ੍ ਯੀਸ਼ੋਃ ਸਮੀਪਮ੍ ਆਨਿਨ੍ਯੁਃ, ਤਦਾ ਸ ਏਕੈਕਸ੍ਯ ਗਾਤ੍ਰੇ ਕਰਮਰ੍ਪਯਿਤ੍ਵਾ ਤਾਨਰੋਗਾਨ੍ ਚਕਾਰ| ");
INSERT INTO sanpun_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ਤਤੋ ਭੂਤਾ ਬਹੁਭ੍ਯੋ ਨਿਰ੍ਗਤ੍ਯ ਚੀਤ੍ਸ਼ਬ੍ਦੰ ਕ੍ਰੁʼਤ੍ਵਾ ਚ ਬਭਾਸ਼਼ਿਰੇ ਤ੍ਵਮੀਸ਼੍ਵਰਸ੍ਯ ਪੁਤ੍ਰੋ(ਅ)ਭਿਸ਼਼ਿਕ੍ਤਤ੍ਰਾਤਾ; ਕਿਨ੍ਤੁ ਸੋਭਿਸ਼਼ਿਕ੍ਤਤ੍ਰਾਤੇਤਿ ਤੇ ਵਿਵਿਦੁਰੇਤਸ੍ਮਾਤ੍ ਕਾਰਣਾਤ੍ ਤਾਨ੍ ਤਰ੍ਜਯਿਤ੍ਵਾ ਤਦ੍ਵਕ੍ਤੁੰ ਨਿਸ਼਼ਿਸ਼਼ੇਧ| ");
INSERT INTO sanpun_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","ਅਪਰਞ੍ਚ ਪ੍ਰਭਾਤੇ ਸਤਿ ਸ ਵਿਜਨਸ੍ਥਾਨੰ ਪ੍ਰਤਸ੍ਥੇ ਪਸ਼੍ਚਾਤ੍ ਜਨਾਸ੍ਤਮਨ੍ਵਿੱਛਨ੍ਤਸ੍ਤੰਨਿਕਟੰ ਗਤ੍ਵਾ ਸ੍ਥਾਨਾਨ੍ਤਰਗਮਨਾਰ੍ਥੰ ਤਮਨ੍ਵਰੁਨ੍ਧਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ਕਿਨ੍ਤੁ ਸ ਤਾਨ੍ ਜਗਾਦ, ਈਸ਼੍ਵਰੀਯਰਾਜ੍ਯਸ੍ਯ ਸੁਸੰਵਾਦੰ ਪ੍ਰਚਾਰਯਿਤੁਮ੍ ਅਨ੍ਯਾਨਿ ਪੁਰਾਣ੍ਯਪਿ ਮਯਾ ਯਾਤਵ੍ਯਾਨਿ ਯਤਸ੍ਤਦਰ੍ਥਮੇਵ ਪ੍ਰੇਰਿਤੋਹੰ| ");
INSERT INTO sanpun_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ਅਥ ਗਾਲੀਲੋ ਭਜਨਗੇਹੇਸ਼਼ੁ ਸ ਉਪਦਿਦੇਸ਼| ");
INSERT INTO sanpun_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","ਅਨਨ੍ਤਰੰ ਯੀਸ਼ੁਰੇਕਦਾ ਗਿਨੇਸ਼਼ਰਥ੍ਦਸ੍ਯ ਤੀਰ ਉੱਤਿਸ਼਼੍ਠਤਿ, ਤਦਾ ਲੋਕਾ ਈਸ਼੍ਵਰੀਯਕਥਾਂ ਸ਼੍ਰੋਤੁੰ ਤਦੁਪਰਿ ਪ੍ਰਪਤਿਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ਤਦਾਨੀਂ ਸ ਹ੍ਦਸ੍ਯ ਤੀਰਸਮੀਪੇ ਨੌਦ੍ਵਯੰ ਦਦਰ੍ਸ਼ ਕਿਞ੍ਚ ਮਤ੍ਸ੍ਯੋਪਜੀਵਿਨੋ ਨਾਵੰ ਵਿਹਾਯ ਜਾਲੰ ਪ੍ਰਕ੍ਸ਼਼ਾਲਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ਤਤਸ੍ਤਯੋਰ੍ਦ੍ਵਯੋ ਰ੍ਮਧ੍ਯੇ ਸ਼ਿਮੋਨੋ ਨਾਵਮਾਰੁਹ੍ਯ ਤੀਰਾਤ੍ ਕਿਞ੍ਚਿੱਦੂਰੰ ਯਾਤੁੰ ਤਸ੍ਮਿਨ੍ ਵਿਨਯੰ ਕ੍ਰੁʼਤ੍ਵਾ ਨੌਕਾਯਾਮੁਪਵਿਸ਼੍ਯ ਲੋਕਾਨ੍ ਪ੍ਰੋਪਦਿਸ਼਼੍ਟਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ਪਸ਼੍ਚਾਤ੍ ਤੰ ਪ੍ਰਸ੍ਤਾਵੰ ਸਮਾਪ੍ਯ ਸ ਸ਼ਿਮੋਨੰ ਵ੍ਯਾਜਹਾਰ, ਗਭੀਰੰ ਜਲੰ ਗਤ੍ਵਾ ਮਤ੍ਸ੍ਯਾਨ੍ ਧਰ੍ੱਤੁੰ ਜਾਲੰ ਨਿਕ੍ਸ਼਼ਿਪ| ");
INSERT INTO sanpun_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ਤਤਃ ਸ਼ਿਮੋਨ ਬਭਾਸ਼਼ੇ, ਹੇ ਗੁਰੋ ਯਦ੍ਯਪਿ ਵਯੰ ਕ੍ਰੁʼਤ੍ਸ੍ਨਾਂ ਯਾਮਿਨੀਂ ਪਰਿਸ਼੍ਰਮ੍ਯ ਮਤ੍ਸ੍ਯੈਕਮਪਿ ਨ ਪ੍ਰਾਪ੍ਤਾਸ੍ਤਥਾਪਿ ਭਵਤੋ ਨਿਦੇਸ਼ਤੋ ਜਾਲੰ ਕ੍ਸ਼਼ਿਪਾਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ਅਥ ਜਾਲੇ ਕ੍ਸ਼਼ਿਪ੍ਤੇ ਬਹੁਮਤ੍ਸ੍ਯਪਤਨਾਦ੍ ਆਨਾਯਃ ਪ੍ਰੱਛਿੰਨਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ਤਸ੍ਮਾਦ੍ ਉਪਕਰ੍ੱਤੁਮ੍ ਅਨ੍ਯਨੌਸ੍ਥਾਨ੍ ਸਙ੍ਗਿਨ ਆਯਾਤੁਮ੍ ਇਙ੍ਗਿਤੇਨ ਸਮਾਹ੍ਵਯਨ੍ ਤਤਸ੍ਤ ਆਗਤ੍ਯ ਮਤ੍ਸ੍ਯੈ ਰ੍ਨੌਦ੍ਵਯੰ ਪ੍ਰਪੂਰਯਾਮਾਸੁ ਰ੍ਯੈ ਰ੍ਨੌਦ੍ਵਯੰ ਪ੍ਰਮਗ੍ਨਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ਤਦਾ ਸ਼ਿਮੋਨ੍ਪਿਤਰਸ੍ਤਦ੍ ਵਿਲੋਕ੍ਯ ਯੀਸ਼ੋਸ਼੍ਚਰਣਯੋਃ ਪਤਿਤ੍ਵਾ, ਹੇ ਪ੍ਰਭੋਹੰ ਪਾਪੀ ਨਰੋ ਮਮ ਨਿਕਟਾਦ੍ ਭਵਾਨ੍ ਯਾਤੁ, ਇਤਿ ਕਥਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","ਯਤੋ ਜਾਲੇ ਪਤਿਤਾਨਾਂ ਮਤ੍ਸ੍ਯਾਨਾਂ ਯੂਥਾਤ੍ ਸ਼ਿਮੋਨ੍ ਤਤ੍ਸਙ੍ਗਿਨਸ਼੍ਚ ਚਮਤ੍ਕ੍ਰੁʼਤਵਨ੍ਤਃ; ਸ਼ਿਮੋਨਃ ਸਹਕਾਰਿਣੌ ਸਿਵਦੇਃ ਪੁਤ੍ਰੌ ਯਾਕੂਬ੍ ਯੋਹਨ੍ ਚੇਮੌ ਤਾਦ੍ਰੁʼਸ਼ੌ ਬਭੂਵਤੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ਤਦਾ ਯੀਸ਼ੁਃ ਸ਼ਿਮੋਨੰ ਜਗਾਦ ਮਾ ਭੈਸ਼਼ੀਰਦ੍ਯਾਰਭ੍ਯ ਤ੍ਵੰ ਮਨੁਸ਼਼੍ਯਧਰੋ ਭਵਿਸ਼਼੍ਯਸਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ਅਨਨ੍ਤਰੰ ਸਰ੍ੱਵਾਸੁ ਨੌਸੁ ਤੀਰਮ੍ ਆਨੀਤਾਸੁ ਤੇ ਸਰ੍ੱਵਾਨ੍ ਪਰਿਤ੍ਯਜ੍ਯ ਤਸ੍ਯ ਪਸ਼੍ਚਾਦ੍ਗਾਮਿਨੋ ਬਭੂਵੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","ਤਤਃ ਪਰੰ ਯੀਸ਼ੌ ਕਸ੍ਮਿੰਸ਼੍ਚਿਤ੍ ਪੁਰੇ ਤਿਸ਼਼੍ਠਤਿ ਜਨ ਏਕਃ ਸਰ੍ੱਵਾਙ੍ਗਕੁਸ਼਼੍ਠਸ੍ਤੰ ਵਿਲੋਕ੍ਯ ਤਸ੍ਯ ਸਮੀਪੇ ਨ੍ਯੁਬ੍ਜਃ ਪਤਿਤ੍ਵਾ ਸਵਿਨਯੰ ਵਕ੍ਤੁਮਾਰੇਭੇ, ਹੇ ਪ੍ਰਭੋ ਯਦਿ ਭਵਾਨਿੱਛਤਿ ਤਰ੍ਹਿ ਮਾਂ ਪਰਿਸ਼਼੍ਕਰ੍ੱਤੁੰ ਸ਼ਕ੍ਨੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","ਤਦਾਨੀਂ ਸ ਪਾਣਿੰ ਪ੍ਰਸਾਰ੍ੱਯ ਤਦਙ੍ਗੰ ਸ੍ਪ੍ਰੁʼਸ਼ਨ੍ ਬਭਾਸ਼਼ੇ ਤ੍ਵੰ ਪਰਿਸ਼਼੍ਕ੍ਰਿਯਸ੍ਵੇਤਿ ਮਮੇੱਛਾਸ੍ਤਿ ਤਤਸ੍ਤਤ੍ਕ੍ਸ਼਼ਣੰ ਸ ਕੁਸ਼਼੍ਠਾਤ੍ ਮੁਕ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","ਪਸ਼੍ਚਾਤ੍ ਸ ਤਮਾਜ੍ਞਾਪਯਾਮਾਸ ਕਥਾਮਿਮਾਂ ਕਸ੍ਮੈਚਿਦ੍ ਅਕਥਯਿਤ੍ਵਾ ਯਾਜਕਸ੍ਯ ਸਮੀਪਞ੍ਚ ਗਤ੍ਵਾ ਸ੍ਵੰ ਦਰ੍ਸ਼ਯ, ਲੋਕੇਭ੍ਯੋ ਨਿਜਪਰਿਸ਼਼੍ਕ੍ਰੁʼਤਤ੍ਵਸ੍ਯ ਪ੍ਰਮਾਣਦਾਨਾਯ ਮੂਸਾਜ੍ਞਾਨੁਸਾਰੇਣ ਦ੍ਰਵ੍ਯਮੁਤ੍ਮ੍ਰੁʼਜਸ੍ਵ ਚ| ");
INSERT INTO sanpun_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","ਤਥਾਪਿ ਯੀਸ਼ੋਃ ਸੁਖ੍ਯਾਤਿ ਰ੍ਬਹੁ ਵ੍ਯਾਪ੍ਤੁਮਾਰੇਭੇ ਕਿਞ੍ਚ ਤਸ੍ਯ ਕਥਾਂ ਸ਼੍ਰੋਤੁੰ ਸ੍ਵੀਯਰੋਗੇਭ੍ਯੋ ਮੋਕ੍ਤੁਞ੍ਚ ਲੋਕਾ ਆਜਗ੍ਮੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","ਅਥ ਸ ਪ੍ਰਾਨ੍ਤਰੰ ਗਤ੍ਵਾ ਪ੍ਰਾਰ੍ਥਯਾਞ੍ਚਕ੍ਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","ਅਪਰਞ੍ਚ ਏਕਦਾ ਯੀਸ਼ੁਰੁਪਦਿਸ਼ਤਿ, ਏਤਰ੍ਹਿ ਗਾਲੀਲ੍ਯਿਹੂਦਾਪ੍ਰਦੇਸ਼ਯੋਃ ਸਰ੍ੱਵਨਗਰੇਭ੍ਯੋ ਯਿਰੂਸ਼ਾਲਮਸ਼੍ਚ ਕਿਯਨ੍ਤਃ ਫਿਰੂਸ਼ਿਲੋਕਾ ਵ੍ਯਵਸ੍ਥਾਪਕਾਸ਼੍ਚ ਸਮਾਗਤ੍ਯ ਤਦਨ੍ਤਿਕੇ ਸਮੁਪਵਿਵਿਸ਼ੁਃ, ਤਸ੍ਮਿਨ੍ ਕਾਲੇ ਲੋਕਾਨਾਮਾਰੋਗ੍ਯਕਾਰਣਾਤ੍ ਪ੍ਰਭੋਃ ਪ੍ਰਭਾਵਃ ਪ੍ਰਚਕਾਸ਼ੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","ਪਸ਼੍ਚਾਤ੍ ਕਿਯਨ੍ਤੋ ਲੋਕਾ ਏਕੰ ਪਕ੍ਸ਼਼ਾਘਾਤਿਨੰ ਖਟ੍ਵਾਯਾਂ ਨਿਧਾਯ ਯੀਸ਼ੋਃ ਸਮੀਪਮਾਨੇਤੁੰ ਸੰਮੁਖੇ ਸ੍ਥਾਪਯਿਤੁਞ੍ਚ ਵ੍ਯਾਪ੍ਰਿਯਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ਕਿਨ੍ਤੁ ਬਹੁਜਨਨਿਵਹਸਮ੍ਵਾਧਾਤ੍ ਨ ਸ਼ਕ੍ਨੁਵਨ੍ਤੋ ਗ੍ਰੁʼਹੋਪਰਿ ਗਤ੍ਵਾ ਗ੍ਰੁʼਹਪ੍ਰੁʼਸ਼਼੍ਠੰ ਖਨਿਤ੍ਵਾ ਤੰ ਪਕ੍ਸ਼਼ਾਘਾਤਿਨੰ ਸਖਟ੍ਵੰ ਗ੍ਰੁʼਹਮਧ੍ਯੇ ਯੀਸ਼ੋਃ ਸੰਮੁਖੇ (ਅ)ਵਰੋਹਯਾਮਾਸੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","ਤਦਾ ਯੀਸ਼ੁਸ੍ਤੇਸ਼਼ਾਮ੍ ਈਦ੍ਰੁʼਸ਼ੰ ਵਿਸ਼੍ਵਾਸੰ ਵਿਲੋਕ੍ਯ ਤੰ ਪਕ੍ਸ਼਼ਾਘਾਤਿਨੰ ਵ੍ਯਾਜਹਾਰ, ਹੇ ਮਾਨਵ ਤਵ ਪਾਪਮਕ੍ਸ਼਼ਮ੍ਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ਤਸ੍ਮਾਦ੍ ਅਧ੍ਯਾਪਕਾਃ ਫਿਰੂਸ਼ਿਨਸ਼੍ਚ ਚਿੱਤੈਰਿੱਥੰ ਪ੍ਰਚਿਨ੍ਤਿਤਵਨ੍ਤਃ, ਏਸ਼਼ ਜਨ ਈਸ਼੍ਵਰੰ ਨਿਨ੍ਦਤਿ ਕੋਯੰ? ਕੇਵਲਮੀਸ਼੍ਵਰੰ ਵਿਨਾ ਪਾਪੰ ਕ੍ਸ਼਼ਨ੍ਤੁੰ ਕਃ ਸ਼ਕ੍ਨੋਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","ਤਦਾ ਯੀਸ਼ੁਸ੍ਤੇਸ਼਼ਾਮ੍ ਇੱਥੰ ਚਿਨ੍ਤਨੰ ਵਿਦਿਤ੍ਵਾ ਤੇਭ੍ਯੋਕਥਯਦ੍ ਯੂਯੰ ਮਨੋਭਿਃ ਕੁਤੋ ਵਿਤਰ੍ਕਯਥ? ");
INSERT INTO sanpun_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","ਤਵ ਪਾਪਕ੍ਸ਼਼ਮਾ ਜਾਤਾ ਯਦ੍ਵਾ ਤ੍ਵਮੁੱਥਾਯ ਵ੍ਰਜ ਏਤਯੋ ਰ੍ਮਧ੍ਯੇ ਕਾ ਕਥਾ ਸੁਕਥ੍ਯਾ? ");
INSERT INTO sanpun_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","ਕਿਨ੍ਤੁ ਪ੍ਰੁʼਥਿਵ੍ਯਾਂ ਪਾਪੰ ਕ੍ਸ਼਼ਨ੍ਤੁੰ ਮਾਨਵਸੁਤਸ੍ਯ ਸਾਮਰ੍ਥ੍ਯਮਸ੍ਤੀਤਿ ਯਥਾ ਯੂਯੰ ਜ੍ਞਾਤੁੰ ਸ਼ਕ੍ਨੁਥ ਤਦਰ੍ਥੰ (ਸ ਤੰ ਪਕ੍ਸ਼਼ਾਘਾਤਿਨੰ ਜਗਾਦ) ਉੱਤਿਸ਼਼੍ਠ ਸ੍ਵਸ਼ੱਯਾਂ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਗ੍ਰੁʼਹੰ ਯਾਹੀਤਿ ਤ੍ਵਾਮਾਦਿਸ਼ਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","ਤਸ੍ਮਾਤ੍ ਸ ਤਤ੍ਕ੍ਸ਼਼ਣਮ੍ ਉੱਥਾਯ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਨਿਜਸ਼ਯਨੀਯੰ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਈਸ਼੍ਵਰੰ ਧਨ੍ਯੰ ਵਦਨ੍ ਨਿਜਨਿਵੇਸ਼ਨੰ ਯਯੌ| ");
INSERT INTO sanpun_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","ਤਸ੍ਮਾਤ੍ ਸਰ੍ੱਵੇ ਵਿਸ੍ਮਯ ਪ੍ਰਾਪ੍ਤਾ ਮਨਃਸੁ ਭੀਤਾਸ਼੍ਚ ਵਯਮਦ੍ਯਾਸਮ੍ਭਵਕਾਰ੍ੱਯਾਣ੍ਯਦਰ੍ਸ਼ਾਮ ਇਤ੍ਯੁਕ੍ਤ੍ਵਾ ਪਰਮੇਸ਼੍ਵਰੰ ਧਨ੍ਯੰ ਪ੍ਰੋਦਿਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","ਤਤਃ ਪਰੰ ਬਹਿਰ੍ਗੱਛਨ੍ ਕਰਸਞ੍ਚਯਸ੍ਥਾਨੇ ਲੇਵਿਨਾਮਾਨੰ ਕਰਸਞ੍ਚਾਯਕੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਯੀਸ਼ੁਸ੍ਤਮਭਿਦਧੇ ਮਮ ਪਸ਼੍ਚਾਦੇਹਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ਤਸ੍ਮਾਤ੍ ਸ ਤਤ੍ਕ੍ਸ਼਼ਣਾਤ੍ ਸਰ੍ੱਵੰ ਪਰਿਤ੍ਯਜ੍ਯ ਤਸ੍ਯ ਪਸ਼੍ਚਾਦਿਯਾਯ| ");
INSERT INTO sanpun_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","ਅਨਨ੍ਤਰੰ ਲੇਵਿ ਰ੍ਨਿਜਗ੍ਰੁʼਹੇ ਤਦਰ੍ਥੰ ਮਹਾਭੋਜ੍ਯੰ ਚਕਾਰ, ਤਦਾ ਤੈਃ ਸਹਾਨੇਕੇ ਕਰਸਞ੍ਚਾਯਿਨਸ੍ਤਦਨ੍ਯਲੋਕਾਸ਼੍ਚ ਭੋਕ੍ਤੁਮੁਪਵਿਵਿਸ਼ੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ਤਸ੍ਮਾਤ੍ ਕਾਰਣਾਤ੍ ਚਣ੍ਡਾਲਾਨਾਂ ਪਾਪਿਲੋਕਾਨਾਞ੍ਚ ਸਙ੍ਗੇ ਯੂਯੰ ਕੁਤੋ ਭੰਗ੍ਧ੍ਵੇ ਪਿਵਥ ਚੇਤਿ ਕਥਾਂ ਕਥਯਿਤ੍ਵਾ ਫਿਰੂਸ਼ਿਨੋ(ਅ)ਧ੍ਯਾਪਕਾਸ਼੍ਚ ਤਸ੍ਯ ਸ਼ਿਸ਼਼੍ਯੈਃ ਸਹ ਵਾਗ੍ਯੁੱਧੰ ਕਰ੍ੱਤੁਮਾਰੇਭਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","ਤਸ੍ਮਾਦ੍ ਯੀਸ਼ੁਸ੍ਤਾਨ੍ ਪ੍ਰਤ੍ਯਵੋਚਦ੍ ਅਰੋਗਲੋਕਾਨਾਂ ਚਿਕਿਤ੍ਸਕੇਨ ਪ੍ਰਯੋਜਨੰ ਨਾਸ੍ਤਿ ਕਿਨ੍ਤੁ ਸਰੋਗਾਣਾਮੇਵ| ");
INSERT INTO sanpun_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ਅਹੰ ਧਾਰ੍ੰਮਿਕਾਨ੍ ਆਹ੍ਵਾਤੁੰ ਨਾਗਤੋਸ੍ਮਿ ਕਿਨ੍ਤੁ ਮਨਃ ਪਰਾਵਰ੍ੱਤਯਿਤੁੰ ਪਾਪਿਨ ਏਵ| ");
INSERT INTO sanpun_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","ਤਤਸ੍ਤੇ ਪ੍ਰੋਚੁਃ, ਯੋਹਨਃ ਫਿਰੂਸ਼ਿਨਾਞ੍ਚ ਸ਼ਿਸ਼਼੍ਯਾ ਵਾਰੰਵਾਰਮ੍ ਉਪਵਸਨ੍ਤਿ ਪ੍ਰਾਰ੍ਥਯਨ੍ਤੇ ਚ ਕਿਨ੍ਤੁ ਤਵ ਸ਼ਿਸ਼਼੍ਯਾਃ ਕੁਤੋ ਭੁਞ੍ਜਤੇ ਪਿਵਨ੍ਤਿ ਚ? ");
INSERT INTO sanpun_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","ਤਦਾ ਸ ਤਾਨਾਚਖ੍ਯੌ ਵਰੇ ਸਙ੍ਗੇ ਤਿਸ਼਼੍ਠਤਿ ਵਰਸ੍ਯ ਸਖਿਗਣੰ ਕਿਮੁਪਵਾਸਯਿਤੁੰ ਸ਼ਕ੍ਨੁਥ? ");
INSERT INTO sanpun_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","ਕਿਨ੍ਤੁ ਯਦਾ ਤੇਸ਼਼ਾਂ ਨਿਕਟਾਦ੍ ਵਰੋ ਨੇਸ਼਼੍ਯਤੇ ਤਦਾ ਤੇ ਸਮੁਪਵਤ੍ਸ੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ਸੋਪਰਮਪਿ ਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤੰ ਕਥਯਾਮ੍ਬਭੂਵ ਪੁਰਾਤਨਵਸ੍ਤ੍ਰੇ ਕੋਪਿ ਨੁਤਨਵਸ੍ਤ੍ਰੰ ਨ ਸੀਵ੍ਯਤਿ ਯਤਸ੍ਤੇਨ ਸੇਵਨੇਨ ਜੀਰ੍ਣਵਸ੍ਤ੍ਰੰ ਛਿਦ੍ਯਤੇ, ਨੂਤਨਪੁਰਾਤਨਵਸ੍ਤ੍ਰਯੋ ਰ੍ਮੇਲਞ੍ਚ ਨ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ਪੁਰਾਤਨ੍ਯਾਂ ਕੁਤ੍ਵਾਂ ਕੋਪਿ ਨੁਤਨੰ ਦ੍ਰਾਕ੍ਸ਼਼ਾਰਸੰ ਨ ਨਿਦਧਾਤਿ, ਯਤੋ ਨਵੀਨਦ੍ਰਾਕ੍ਸ਼਼ਾਰਸਸ੍ਯ ਤੇਜਸਾ ਪੁਰਾਤਨੀ ਕੁਤੂ ਰ੍ਵਿਦੀਰ੍ੱਯਤੇ ਤਤੋ ਦ੍ਰਾਕ੍ਸ਼਼ਾਰਸਃ ਪਤਤਿ ਕੁਤੂਸ਼੍ਚ ਨਸ਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","ਤਤੋ ਹੇਤੋ ਰ੍ਨੂਤਨ੍ਯਾਂ ਕੁਤ੍ਵਾਂ ਨਵੀਨਦ੍ਰਾਕ੍ਸ਼਼ਾਰਸਃ ਨਿਧਾਤਵ੍ਯਸ੍ਤੇਨੋਭਯਸ੍ਯ ਰਕ੍ਸ਼਼ਾ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","ਅਪਰਞ੍ਚ ਪੁਰਾਤਨੰ ਦ੍ਰਾਕ੍ਸ਼਼ਾਰਸੰ ਪੀਤ੍ਵਾ ਕੋਪਿ ਨੂਤਨੰ ਨ ਵਾਞ੍ਛਤਿ, ਯਤਃ ਸ ਵਕ੍ਤਿ ਨੂਤਨਾਤ੍ ਪੁਰਾਤਨਮ੍ ਪ੍ਰਸ਼ਸ੍ਤਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ਅਚਰਞ੍ਚ ਪਰ੍ੱਵਣੋ ਦ੍ਵਿਤੀਯਦਿਨਾਤ੍ ਪਰੰ ਪ੍ਰਥਮਵਿਸ਼੍ਰਾਮਵਾਰੇ ਸ਼ਸ੍ਯਕ੍ਸ਼਼ੇਤ੍ਰੇਣ ਯੀਸ਼ੋਰ੍ਗਮਨਕਾਲੇ ਤਸ੍ਯ ਸ਼ਿਸ਼਼੍ਯਾਃ ਕਣਿਸ਼ੰ ਛਿੱਤ੍ਵਾ ਕਰੇਸ਼਼ੁ ਮਰ੍ੱਦਯਿਤ੍ਵਾ ਖਾਦਿਤੁਮਾਰੇਭਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ਤਸ੍ਮਾਤ੍ ਕਿਯਨ੍ਤਃ ਫਿਰੂਸ਼ਿਨਸ੍ਤਾਨਵਦਨ੍ ਵਿਸ਼੍ਰਾਮਵਾਰੇ ਯਤ੍ ਕਰ੍ੰਮ ਨ ਕਰ੍ੱਤਵ੍ਯੰ ਤਤ੍ ਕੁਤਃ ਕੁਰੁਥ? ");
INSERT INTO sanpun_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯੁਵਾਚ ਦਾਯੂਦ੍ ਤਸ੍ਯ ਸਙ੍ਗਿਨਸ਼੍ਚ ਕ੍ਸ਼਼ੁਧਾਰ੍ੱਤਾਃ ਕਿੰ ਚਕ੍ਰੁਃ ਸ ਕਥਮ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਮਨ੍ਦਿਰੰ ਪ੍ਰਵਿਸ਼੍ਯ ");
INSERT INTO sanpun_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ਯੇ ਦਰ੍ਸ਼ਨੀਯਾਃ ਪੂਪਾ ਯਾਜਕਾਨ੍ ਵਿਨਾਨ੍ਯਸ੍ਯ ਕਸ੍ਯਾਪ੍ਯਭੋਜਨੀਯਾਸ੍ਤਾਨਾਨੀਯ ਸ੍ਵਯੰ ਬੁਭਜੇ ਸਙ੍ਗਿਭ੍ਯੋਪਿ ਦਦੌ ਤਤ੍ ਕਿੰ ਯੁਸ਼਼੍ਮਾਭਿਃ ਕਦਾਪਿ ਨਾਪਾਠਿ? ");
INSERT INTO sanpun_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ਪਸ਼੍ਚਾਤ੍ ਸ ਤਾਨਵਦਤ੍ ਮਨੁਜਸੁਤੋ ਵਿਸ਼੍ਰਾਮਵਾਰਸ੍ਯਾਪਿ ਪ੍ਰਭੁ ਰ੍ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","ਅਨਨ੍ਤਰਮ੍ ਅਨ੍ਯਵਿਸ਼੍ਰਾਮਵਾਰੇ ਸ ਭਜਨਗੇਹੰ ਪ੍ਰਵਿਸ਼੍ਯ ਸਮੁਪਦਿਸ਼ਤਿ| ਤਦਾ ਤਤ੍ਸ੍ਥਾਨੇ ਸ਼ੁਸ਼਼੍ਕਦਕ੍ਸ਼਼ਿਣਕਰ ਏਕਃ ਪੁਮਾਨ੍ ਉਪਤਸ੍ਥਿਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ਤਸ੍ਮਾਦ੍ ਅਧ੍ਯਾਪਕਾਃ ਫਿਰੂਸ਼ਿਨਸ਼੍ਚ ਤਸ੍ਮਿਨ੍ ਦੋਸ਼਼ਮਾਰੋਪਯਿਤੁੰ ਸ ਵਿਸ਼੍ਰਾਮਵਾਰੇ ਤਸ੍ਯ ਸ੍ਵਾਸ੍ਥ੍ਯੰ ਕਰੋਤਿ ਨਵੇਤਿ ਪ੍ਰਤੀਕ੍ਸ਼਼ਿਤੁਮਾਰੇਭਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","ਤਦਾ ਯੀਸ਼ੁਸ੍ਤੇਸ਼਼ਾਂ ਚਿਨ੍ਤਾਂ ਵਿਦਿਤ੍ਵਾ ਤੰ ਸ਼ੁਸ਼਼੍ਕਕਰੰ ਪੁਮਾਂਸੰ ਪ੍ਰੋਵਾਚ, ਤ੍ਵਮੁੱਥਾਯ ਮਧ੍ਯਸ੍ਥਾਨੇ ਤਿਸ਼਼੍ਠ| ");
INSERT INTO sanpun_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ਤਸ੍ਮਾਤ੍ ਤਸ੍ਮਿਨ੍ ਉੱਥਿਤਵਤਿ ਯੀਸ਼ੁਸ੍ਤਾਨ੍ ਵ੍ਯਾਜਹਾਰ, ਯੁਸ਼਼੍ਮਾਨ੍ ਇਮਾਂ ਕਥਾਂ ਪ੍ਰੁʼੱਛਾਮਿ, ਵਿਸ਼੍ਰਾਮਵਾਰੇ ਹਿਤਮ੍ ਅਹਿਤੰ ਵਾ, ਪ੍ਰਾਣਰਕ੍ਸ਼਼ਣੰ ਪ੍ਰਾਣਨਾਸ਼ਨੰ ਵਾ, ਏਤੇਸ਼਼ਾਂ ਕਿੰ ਕਰ੍ੰਮਕਰਣੀਯਮ੍? ");
INSERT INTO sanpun_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ਪਸ਼੍ਚਾਤ੍ ਚਤੁਰ੍ਦਿਕ੍ਸ਼਼ੁ ਸਰ੍ੱਵਾਨ੍ ਵਿਲੋਕ੍ਯ ਤੰ ਮਾਨਵੰ ਬਭਾਸ਼਼ੇ, ਨਿਜਕਰੰ ਪ੍ਰਸਾਰਯ; ਤਤਸ੍ਤੇਨ ਤਥਾ ਕ੍ਰੁʼਤ ਇਤਰਕਰਵਤ੍ ਤਸ੍ਯ ਹਸ੍ਤਃ ਸ੍ਵਸ੍ਥੋਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","ਤਸ੍ਮਾਤ੍ ਤੇ ਪ੍ਰਚਣ੍ਡਕੋਪਾਨ੍ਵਿਤਾ ਯੀਸ਼ੁੰ ਕਿੰ ਕਰਿਸ਼਼੍ਯਨ੍ਤੀਤਿ ਪਰਸ੍ਪਰੰ ਪ੍ਰਮਨ੍ਤ੍ਰਿਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ਤਤਃ ਪਰੰ ਸ ਪਰ੍ੱਵਤਮਾਰੁਹ੍ਯੇਸ਼੍ਵਰਮੁੱਦਿਸ਼੍ਯ ਪ੍ਰਾਰ੍ਥਯਮਾਨਃ ਕ੍ਰੁʼਤ੍ਸ੍ਨਾਂ ਰਾਤ੍ਰਿੰ ਯਾਪਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ਅਥ ਦਿਨੇ ਸਤਿ ਸ ਸਰ੍ੱਵਾਨ੍ ਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਆਹੂਤਵਾਨ੍ ਤੇਸ਼਼ਾਂ ਮਧ੍ਯੇ ");
INSERT INTO sanpun_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ਪਿਤਰਨਾਮ੍ਨਾ ਖ੍ਯਾਤਃ ਸ਼ਿਮੋਨ੍ ਤਸ੍ਯ ਭ੍ਰਾਤਾ ਆਨ੍ਦ੍ਰਿਯਸ਼੍ਚ ਯਾਕੂਬ੍ ਯੋਹਨ੍ ਚ ਫਿਲਿਪ੍ ਬਰ੍ਥਲਮਯਸ਼੍ਚ ");
INSERT INTO sanpun_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ਮਥਿਃ ਥੋਮਾ ਆਲ੍ਫੀਯਸ੍ਯ ਪੁਤ੍ਰੋ ਯਾਕੂਬ੍ ਜ੍ਵਲਨ੍ਤਨਾਮ੍ਨਾ ਖ੍ਯਾਤਃ ਸ਼ਿਮੋਨ੍ ");
INSERT INTO sanpun_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ਚ ਯਾਕੂਬੋ ਭ੍ਰਾਤਾ ਯਿਹੂਦਾਸ਼੍ਚ ਤੰ ਯਃ ਪਰਕਰੇਸ਼਼ੁ ਸਮਰ੍ਪਯਿਸ਼਼੍ਯਤਿ ਸ ਈਸ਼਼੍ਕਰੀਯੋਤੀਯਯਿਹੂਦਾਸ਼੍ਚੈਤਾਨ੍ ਦ੍ਵਾਦਸ਼ ਜਨਾਨ੍ ਮਨੋਨੀਤਾਨ੍ ਕ੍ਰੁʼਤ੍ਵਾ ਸ ਜਗ੍ਰਾਹ ਤਥਾ ਪ੍ਰੇਰਿਤ ਇਤਿ ਤੇਸ਼਼ਾਂ ਨਾਮ ਚਕਾਰ| ");
INSERT INTO sanpun_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","ਤਤਃ ਪਰੰ ਸ ਤੈਃ ਸਹ ਪਰ੍ੱਵਤਾਦਵਰੁਹ੍ਯ ਉਪਤ੍ਯਕਾਯਾਂ ਤਸ੍ਥੌ ਤਤਸ੍ਤਸ੍ਯ ਸ਼ਿਸ਼਼੍ਯਸਙ੍ਘੋ ਯਿਹੂਦਾਦੇਸ਼ਾਦ੍ ਯਿਰੂਸ਼ਾਲਮਸ਼੍ਚ ਸੋਰਃ ਸੀਦੋਨਸ਼੍ਚ ਜਲਧੇ ਰੋਧਸੋ ਜਨਨਿਹਾਸ਼੍ਚ ਏਤ੍ਯ ਤਸ੍ਯ ਕਥਾਸ਼੍ਰਵਣਾਰ੍ਥੰ ਰੋਗਮੁਕ੍ਤ੍ਯਰ੍ਥਞ੍ਚ ਤਸ੍ਯ ਸਮੀਪੇ ਤਸ੍ਥੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ਅਮੇਧ੍ਯਭੂਤਗ੍ਰਸ੍ਤਾਸ਼੍ਚ ਤੰਨਿਕਟਮਾਗਤ੍ਯ ਸ੍ਵਾਸ੍ਥ੍ਯੰ ਪ੍ਰਾਪੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਸ੍ਵਾਸ੍ਥ੍ਯਕਰਣਪ੍ਰਭਾਵਸ੍ਯ ਪ੍ਰਕਾਸ਼ਿਤਤ੍ਵਾਤ੍ ਸਰ੍ੱਵੇ ਲੋਕਾ ਏਤ੍ਯ ਤੰ ਸ੍ਪ੍ਰਸ਼਼੍ਟੁੰ ਯੇਤਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","ਪਸ਼੍ਚਾਤ੍ ਸ ਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਪ੍ਰਤਿ ਦ੍ਰੁʼਸ਼਼੍ਟਿੰ ਕੁਤ੍ਵਾ ਜਗਾਦ, ਹੇ ਦਰਿਦ੍ਰਾ ਯੂਯੰ ਧਨ੍ਯਾ ਯਤ ਈਸ਼੍ਵਰੀਯੇ ਰਾਜ੍ਯੇ ਵੋ(ਅ)ਧਿਕਾਰੋਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ਹੇ ਅਧੁਨਾ ਕ੍ਸ਼਼ੁਧਿਤਲੋਕਾ ਯੂਯੰ ਧਨ੍ਯਾ ਯਤੋ ਯੂਯੰ ਤਰ੍ਪ੍ਸ੍ਯਥ; ਹੇ ਇਹ ਰੋਦਿਨੋ ਜਨਾ ਯੂਯੰ ਧਨ੍ਯਾ ਯਤੋ ਯੂਯੰ ਹਸਿਸ਼਼੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","ਯਦਾ ਲੋਕਾ ਮਨੁਸ਼਼੍ਯਸੂਨੋ ਰ੍ਨਾਮਹੇਤੋ ਰ੍ਯੁਸ਼਼੍ਮਾਨ੍ ਰੁʼृਤੀਯਿਸ਼਼੍ਯਨ੍ਤੇ ਪ੍ਰੁʼਥਕ੍ ਕ੍ਰੁʼਤ੍ਵਾ ਨਿਨ੍ਦਿਸ਼਼੍ਯਨ੍ਤਿ, ਅਧਮਾਨਿਵ ਯੁਸ਼਼੍ਮਾਨ੍ ਸ੍ਵਸਮੀਪਾਦ੍ ਦੂਰੀਕਰਿਸ਼਼੍ਯਨ੍ਤਿ ਚ ਤਦਾ ਯੂਯੰ ਧਨ੍ਯਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ਸ੍ਵਰ੍ਗੇ ਯੁਸ਼਼੍ਮਾਕੰ ਯਥੇਸ਼਼੍ਟੰ ਫਲੰ ਭਵਿਸ਼਼੍ਯਤਿ, ਏਤਦਰ੍ਥੰ ਤਸ੍ਮਿਨ੍ ਦਿਨੇ ਪ੍ਰੋੱਲਸਤ ਆਨਨ੍ਦੇਨ ਨ੍ਰੁʼਤ੍ਯਤ ਚ, ਤੇਸ਼਼ਾਂ ਪੂਰ੍ੱਵਪੁਰੁਸ਼਼ਾਸ਼੍ਚ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਃ ਪ੍ਰਤਿ ਤਥੈਵ ਵ੍ਯਵਾਹਰਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","ਕਿਨ੍ਤੁ ਹਾ ਹਾ ਧਨਵਨ੍ਤੋ ਯੂਯੰ ਸੁਖੰ ਪ੍ਰਾਪ੍ਨੁਤ| ਹਨ੍ਤ ਪਰਿਤ੍ਰੁʼਪ੍ਤਾ ਯੂਯੰ ਕ੍ਸ਼਼ੁਧਿਤਾ ਭਵਿਸ਼਼੍ਯਥ; ");
INSERT INTO sanpun_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ਇਹ ਹਸਨ੍ਤੋ ਯੂਯੰ ਵਤ ਯੁਸ਼਼੍ਮਾਭਿਃ ਸ਼ੋਚਿਤਵ੍ਯੰ ਰੋਦਿਤਵ੍ਯਞ੍ਚ| ");
INSERT INTO sanpun_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","ਸਰ੍ੱਵੈਲਾਕੈ ਰ੍ਯੁਸ਼਼੍ਮਾਕੰ ਸੁਖ੍ਯਾਤੌ ਕ੍ਰੁʼਤਾਯਾਂ ਯੁਸ਼਼੍ਮਾਕੰ ਦੁਰ੍ਗਤਿ ਰ੍ਭਵਿਸ਼਼੍ਯਤਿ ਯੁਸ਼਼੍ਮਾਕੰ ਪੂਰ੍ੱਵਪੁਰੁਸ਼਼ਾ ਮ੍ਰੁʼਸ਼਼ਾਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਃ ਪ੍ਰਤਿ ਤਦ੍ਵਤ੍ ਕ੍ਰੁʼਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","ਹੇ ਸ਼੍ਰੋਤਾਰੋ ਯੁਸ਼਼੍ਮਭ੍ਯਮਹੰ ਕਥਯਾਮਿ, ਯੂਯੰ ਸ਼ਤ੍ਰੁਸ਼਼ੁ ਪ੍ਰੀਯਧ੍ਵੰ ਯੇ ਚ ਯੁਸ਼਼੍ਮਾਨ੍ ਦ੍ਵਿਸ਼਼ਨ੍ਤਿ ਤੇਸ਼਼ਾਮਪਿ ਹਿਤੰ ਕੁਰੁਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ਯੇ ਚ ਯੁਸ਼਼੍ਮਾਨ੍ ਸ਼ਪਨ੍ਤਿ ਤੇਭ੍ਯ ਆਸ਼ਿਸ਼਼ੰ ਦੱਤ ਯੇ ਚ ਯੁਸ਼਼੍ਮਾਨ੍ ਅਵਮਨ੍ਯਨ੍ਤੇ ਤੇਸ਼਼ਾਂ ਮਙ੍ਗਲੰ ਪ੍ਰਾਰ੍ਥਯਧ੍ਵੰ| ");
INSERT INTO sanpun_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","ਯਦਿ ਕਸ਼੍ਚਿਤ੍ ਤਵ ਕਪੋਲੇ ਚਪੇਟਾਘਾਤੰ ਕਰੋਤਿ ਤਰ੍ਹਿ ਤੰ ਪ੍ਰਤਿ ਕਪੋਲਮ੍ ਅਨ੍ਯੰ ਪਰਾਵਰ੍ੱਤ੍ਯ ਸੰਮੁਖੀਕੁਰੁ ਪੁਨਸ਼੍ਚ ਯਦਿ ਕਸ਼੍ਚਿਤ੍ ਤਵ ਗਾਤ੍ਰੀਯਵਸ੍ਤ੍ਰੰ ਹਰਤਿ ਤਰ੍ਹਿ ਤੰ ਪਰਿਧੇਯਵਸ੍ਤ੍ਰਮ੍ ਅਪਿ ਗ੍ਰਹੀਤੁੰ ਮਾ ਵਾਰਯ| ");
INSERT INTO sanpun_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ਯਸ੍ਤ੍ਵਾਂ ਯਾਚਤੇ ਤਸ੍ਮੈ ਦੇਹਿ, ਯਸ਼੍ਚ ਤਵ ਸਮ੍ਪੱਤਿੰ ਹਰਤਿ ਤੰ ਮਾ ਯਾਚਸ੍ਵ| ");
INSERT INTO sanpun_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","ਪਰੇਭ੍ਯਃ ਸ੍ਵਾਨ੍ ਪ੍ਰਤਿ ਯਥਾਚਰਣਮ੍ ਅਪੇਕ੍ਸ਼਼ਧ੍ਵੇ ਪਰਾਨ੍ ਪ੍ਰਤਿ ਯੂਯਮਪਿ ਤਥਾਚਰਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","ਯੇ ਜਨਾ ਯੁਸ਼਼੍ਮਾਸੁ ਪ੍ਰੀਯਨ੍ਤੇ ਕੇਵਲੰ ਤੇਸ਼਼ੁ ਪ੍ਰੀਯਮਾਣੇਸ਼਼ੁ ਯੁਸ਼਼੍ਮਾਕੰ ਕਿੰ ਫਲੰ? ਪਾਪਿਲੋਕਾ ਅਪਿ ਸ੍ਵੇਸ਼਼ੁ ਪ੍ਰੀਯਮਾਣੇਸ਼਼ੁ ਪ੍ਰੀਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","ਯਦਿ ਹਿਤਕਾਰਿਣ ਏਵ ਹਿਤੰ ਕੁਰੁਥ ਤਰ੍ਹਿ ਯੁਸ਼਼੍ਮਾਕੰ ਕਿੰ ਫਲੰ? ਪਾਪਿਲੋਕਾ ਅਪਿ ਤਥਾ ਕੁਰ੍ੱਵਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","ਯੇਭ੍ਯ ਰੁʼਣਪਰਿਸ਼ੋਧਸ੍ਯ ਪ੍ਰਾਪ੍ਤਿਪ੍ਰਤ੍ਯਾਸ਼ਾਸ੍ਤੇ ਕੇਵਲੰ ਤੇਸ਼਼ੁ ਰੁʼਣੇ ਸਮਰ੍ਪਿਤੇ ਯੁਸ਼਼੍ਮਾਕੰ ਕਿੰ ਫਲੰ? ਪੁਨਃ ਪ੍ਰਾਪ੍ਤ੍ਯਾਸ਼ਯਾ ਪਾਪੀਲੋਕਾ ਅਪਿ ਪਾਪਿਜਨੇਸ਼਼ੁ ਰੁʼਣਮ੍ ਅਰ੍ਪਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","ਅਤੋ ਯੂਯੰ ਰਿਪੁਸ਼਼੍ਵਪਿ ਪ੍ਰੀਯਧ੍ਵੰ, ਪਰਹਿਤੰ ਕੁਰੁਤ ਚ; ਪੁਨਃ ਪ੍ਰਾਪ੍ਤ੍ਯਾਸ਼ਾਂ ਤ੍ਯਕ੍ਤ੍ਵਾ ਰੁʼਣਮਰ੍ਪਯਤ, ਤਥਾ ਕ੍ਰੁʼਤੇ ਯੁਸ਼਼੍ਮਾਕੰ ਮਹਾਫਲੰ ਭਵਿਸ਼਼੍ਯਤਿ, ਯੂਯਞ੍ਚ ਸਰ੍ੱਵਪ੍ਰਧਾਨਸ੍ਯ ਸਨ੍ਤਾਨਾ ਇਤਿ ਖ੍ਯਾਤਿੰ ਪ੍ਰਾਪ੍ਸ੍ਯਥ, ਯਤੋ ਯੁਸ਼਼੍ਮਾਕੰ ਪਿਤਾ ਕ੍ਰੁʼਤਘ੍ਨਾਨਾਂ ਦੁਰ੍ਵ੍ਟੱਤਾਨਾਞ੍ਚ ਹਿਤਮਾਚਰਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ਅਤ ਏਵ ਸ ਯਥਾ ਦਯਾਲੁ ਰ੍ਯੂਯਮਪਿ ਤਾਦ੍ਰੁʼਸ਼ਾ ਦਯਾਲਵੋ ਭਵਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","ਅਪਰਞ੍ਚ ਪਰਾਨ੍ ਦੋਸ਼਼ਿਣੋ ਮਾ ਕੁਰੁਤ ਤਸ੍ਮਾਦ੍ ਯੂਯੰ ਦੋਸ਼਼ੀਕ੍ਰੁʼਤਾ ਨ ਭਵਿਸ਼਼੍ਯਥ; ਅਦਣ੍ਡ੍ਯਾਨ੍ ਮਾ ਦਣ੍ਡਯਤ ਤਸ੍ਮਾਦ੍ ਯੂਯਮਪਿ ਦਣ੍ਡੰ ਨ ਪ੍ਰਾਪ੍ਸ੍ਯਥ; ਪਰੇਸ਼਼ਾਂ ਦੋਸ਼਼ਾਨ੍ ਕ੍ਸ਼਼ਮਧ੍ਵੰ ਤਸ੍ਮਾਦ੍ ਯੁਸ਼਼੍ਮਾਕਮਪਿ ਦੋਸ਼਼ਾਃ ਕ੍ਸ਼਼ਮਿਸ਼਼੍ਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","ਦਾਨਾਨਿਦੱਤ ਤਸ੍ਮਾਦ੍ ਯੂਯੰ ਦਾਨਾਨਿ ਪ੍ਰਾਪ੍ਸ੍ਯਥ, ਵਰਞ੍ਚ ਲੋਕਾਃ ਪਰਿਮਾਣਪਾਤ੍ਰੰ ਪ੍ਰਦਲੱਯ ਸਞ੍ਚਾਲ੍ਯ ਪ੍ਰੋਞ੍ਚਾਲ੍ਯ ਪਰਿਪੂਰ੍ੱਯ ਯੁਸ਼਼੍ਮਾਕੰ ਕ੍ਰੋਡੇਸ਼਼ੁ ਸਮਰ੍ਪਯਿਸ਼਼੍ਯਨ੍ਤਿ; ਯੂਯੰ ਯੇਨ ਪਰਿਮਾਣੇਨ ਪਰਿਮਾਥ ਤੇਨੈਵ ਪਰਿਮਾਣੇਨ ਯੁਸ਼਼੍ਮਤ੍ਕ੍ਰੁʼਤੇ ਪਰਿਮਾਸ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ਅਥ ਸ ਤੇਭ੍ਯੋ ਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤਕਥਾਮਕਥਯਤ੍, ਅਨ੍ਧੋ ਜਨਃ ਕਿਮਨ੍ਧੰ ਪਨ੍ਥਾਨੰ ਦਰ੍ਸ਼ਯਿਤੁੰ ਸ਼ਕ੍ਨੋਤਿ? ਤਸ੍ਮਾਦ੍ ਉਭਾਵਪਿ ਕਿੰ ਗਰ੍ੱਤੇ ਨ ਪਤਿਸ਼਼੍ਯਤਃ? ");
INSERT INTO sanpun_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ਗੁਰੋਃ ਸ਼ਿਸ਼਼੍ਯੋ ਨ ਸ਼੍ਰੇਸ਼਼੍ਠਃ ਕਿਨ੍ਤੁ ਸ਼ਿਸ਼਼੍ਯੇ ਸਿੱਧੇ ਸਤਿ ਸ ਗੁਰੁਤੁਲ੍ਯੋ ਭਵਿਤੁੰ ਸ਼ਕ੍ਨੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","ਅਪਰਞ੍ਚ ਤ੍ਵੰ ਸ੍ਵਚਕ੍ਸ਼਼ੁुਸ਼਼ਿ ਨਾਸਾਮ੍ ਅਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਤਵ ਭ੍ਰਾਤੁਸ਼੍ਚਕ੍ਸ਼਼ੁਸ਼਼ਿ ਯੱਤ੍ਰੁʼਣਮਸ੍ਤਿ ਤਦੇਵ ਕੁਤਃ ਪਸ਼੍ਯਮਿ? ");
INSERT INTO sanpun_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","ਸ੍ਵਚਕ੍ਸ਼਼ੁਸ਼਼ਿ ਯਾ ਨਾਸਾ ਵਿਦ੍ਯਤੇ ਤਾਮ੍ ਅਜ੍ਞਾਤ੍ਵਾ, ਭ੍ਰਾਤਸ੍ਤਵ ਨੇਤ੍ਰਾਤ੍ ਤ੍ਰੁʼਣੰ ਬਹਿਃ ਕਰੋਮੀਤਿ ਵਾਕ੍ਯੰ ਭ੍ਰਾਤਰੰ ਕਥੰ ਵਕ੍ਤੁੰ ਸ਼ਕ੍ਨੋਸ਼਼ਿ? ਹੇ ਕਪਟਿਨ੍ ਪੂਰ੍ੱਵੰ ਸ੍ਵਨਯਨਾਤ੍ ਨਾਸਾਂ ਬਹਿਃ ਕੁਰੁ ਤਤੋ ਭ੍ਰਾਤੁਸ਼੍ਚਕ੍ਸ਼਼ੁਸ਼਼ਸ੍ਤ੍ਰੁʼਣੰ ਬਹਿਃ ਕਰ੍ੱਤੁੰ ਸੁਦ੍ਰੁʼਸ਼਼੍ਟਿੰ ਪ੍ਰਾਪ੍ਸ੍ਯਸਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","ਅਨ੍ਯਞ੍ਚ ਉੱਤਮਸ੍ਤਰੁਃ ਕਦਾਪਿ ਫਲਮਨੁੱਤਮੰ ਨ ਫਲਤਿ, ਅਨੁੱਤਮਤਰੁਸ਼੍ਚ ਫਲਮੁੱਤਮੰ ਨ ਫਲਤਿ ਕਾਰਣਾਦਤਃ ਫਲੈਸ੍ਤਰਵੋ ਜ੍ਞਾਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","ਕਣ੍ਟਕਿਪਾਦਪਾਤ੍ ਕੋਪਿ ਉਡੁਮ੍ਬਰਫਲਾਨਿ ਨ ਪਾਤਯਤਿ ਤਥਾ ਸ਼੍ਰੁʼਗਾਲਕੋਲਿਵ੍ਰੁʼਕ੍ਸ਼਼ਾਦਪਿ ਕੋਪਿ ਦ੍ਰਾਕ੍ਸ਼਼ਾਫਲੰ ਨ ਪਾਤਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","ਤਦ੍ਵਤ੍ ਸਾਧੁਲੋਕੋ(ਅ)ਨ੍ਤਃਕਰਣਰੂਪਾਤ੍ ਸੁਭਾਣ੍ਡਾਗਾਰਾਦ੍ ਉੱਤਮਾਨਿ ਦ੍ਰਵ੍ਯਾਣਿ ਬਹਿਃ ਕਰੋਤਿ, ਦੁਸ਼਼੍ਟੋ ਲੋਕਸ਼੍ਚਾਨ੍ਤਃਕਰਣਰੂਪਾਤ੍ ਕੁਭਾਣ੍ਡਾਗਾਰਾਤ੍ ਕੁਤ੍ਸਿਤਾਨਿ ਦ੍ਰਵ੍ਯਾਣਿ ਨਿਰ੍ਗਮਯਤਿ ਯਤੋ(ਅ)ਨ੍ਤਃਕਰਣਾਨਾਂ ਪੂਰ੍ਣਭਾਵਾਨੁਰੂਪਾਣਿ ਵਚਾਂਸਿ ਮੁਖਾੰਨਿਰ੍ਗੱਛਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","ਅਪਰਞ੍ਚ ਮਮਾਜ੍ਞਾਨੁਰੂਪੰ ਨਾਚਰਿਤ੍ਵਾ ਕੁਤੋ ਮਾਂ ਪ੍ਰਭੋ ਪ੍ਰਭੋ ਇਤਿ ਵਦਥ? ");
INSERT INTO sanpun_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ਯਃ ਕਸ਼੍ਚਿਨ੍ ਮਮ ਨਿਕਟਮ੍ ਆਗਤ੍ਯ ਮਮ ਕਥਾ ਨਿਸ਼ਮ੍ਯ ਤਦਨੁਰੂਪੰ ਕਰ੍ੰਮ ਕਰੋਤਿ ਸ ਕਸ੍ਯ ਸਦ੍ਰੁʼਸ਼ੋ ਭਵਤਿ ਤਦਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਜ੍ਞਾाਪਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ਯੋ ਜਨੋ ਗਭੀਰੰ ਖਨਿਤ੍ਵਾ ਪਾਸ਼਼ਾਣਸ੍ਥਲੇ ਭਿੱਤਿੰ ਨਿਰ੍ੰਮਾਯ ਸ੍ਵਗ੍ਰੁʼਹੰ ਰਚਯਤਿ ਤੇਨ ਸਹ ਤਸ੍ਯੋਪਮਾ ਭਵਤਿ; ਯਤ ਆਪ੍ਲਾਵਿਜਲਮੇਤ੍ਯ ਤਸ੍ਯ ਮੂਲੇ ਵੇਗੇਨ ਵਹਦਪਿ ਤਦ੍ਗੇਹੰ ਲਾਡਯਿਤੁੰ ਨ ਸ਼ਕ੍ਨੋਤਿ ਯਤਸ੍ਤਸ੍ਯ ਭਿੱਤਿਃ ਪਾਸ਼਼ਾਣੋਪਰਿ ਤਿਸ਼਼੍ਠਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","ਕਿਨ੍ਤੁ ਯਃ ਕਸ਼੍ਚਿਨ੍ ਮਮ ਕਥਾਃ ਸ਼੍ਰੁਤ੍ਵਾ ਤਦਨੁਰੂਪੰ ਨਾਚਰਤਿ ਸ ਭਿੱਤਿੰ ਵਿਨਾ ਮ੍ਰੁʼृਦੁਪਰਿ ਗ੍ਰੁʼਹਨਿਰ੍ੰਮਾਤ੍ਰਾ ਸਮਾਨੋ ਭਵਤਿ; ਯਤ ਆਪ੍ਲਾਵਿਜਲਮਾਗਤ੍ਯ ਵੇਗੇਨ ਯਦਾ ਵਹਤਿ ਤਦਾ ਤਦ੍ਗ੍ਰੁʼਹੰ ਪਤਤਿ ਤਸ੍ਯ ਮਹਤ੍ ਪਤਨੰ ਜਾਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ਤਤਃ ਪਰੰ ਸ ਲੋਕਾਨਾਂ ਕਰ੍ਣਗੋਚਰੇ ਤਾਨ੍ ਸਰ੍ੱਵਾਨ੍ ਉਪਦੇਸ਼ਾਨ੍ ਸਮਾਪ੍ਯ ਯਦਾ ਕਫਰ੍ਨਾਹੂਮ੍ਪੁਰੰ ਪ੍ਰਵਿਸ਼ਤਿ ");
INSERT INTO sanpun_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","ਤਦਾ ਸ਼ਤਸੇਨਾਪਤੇਃ ਪ੍ਰਿਯਦਾਸ ਏਕੋ ਮ੍ਰੁʼਤਕਲ੍ਪਃ ਪੀਡਿਤ ਆਸੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ਅਤਃ ਸੇਨਾਪਤਿ ਰ੍ਯੀਸ਼ੋ ਰ੍ਵਾਰ੍ੱਤਾਂ ਨਿਸ਼ਮ੍ਯ ਦਾਸਸ੍ਯਾਰੋਗ੍ਯਕਰਣਾਯ ਤਸ੍ਯਾਗਮਨਾਰ੍ਥੰ ਵਿਨਯਕਰਣਾਯ ਯਿਹੂਦੀਯਾਨ੍ ਕਿਯਤਃ ਪ੍ਰਾਚਃ ਪ੍ਰੇਸ਼਼ਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","ਤੇ ਯੀਸ਼ੋਰਨ੍ਤਿਕੰ ਗਤ੍ਵਾ ਵਿਨਯਾਤਿਸ਼ਯੰ ਵਕ੍ਤੁਮਾਰੇਭਿਰੇ, ਸ ਸੇਨਾਪਤਿ ਰ੍ਭਵਤੋਨੁਗ੍ਰਹੰ ਪ੍ਰਾਪ੍ਤੁਮ੍ ਅਰ੍ਹਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ਯਤਃ ਸੋਸ੍ਮੱਜਾਤੀਯੇਸ਼਼ੁ ਲੋਕੇਸ਼਼ੁ ਪ੍ਰੀਯਤੇ ਤਥਾਸ੍ਮਤ੍ਕ੍ਰੁʼਤੇ ਭਜਨਗੇਹੰ ਨਿਰ੍ੰਮਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ਤਸ੍ਮਾਦ੍ ਯੀਸ਼ੁਸ੍ਤੈਃ ਸਹ ਗਤ੍ਵਾ ਨਿਵੇਸ਼ਨਸ੍ਯ ਸਮੀਪੰ ਪ੍ਰਾਪ, ਤਦਾ ਸ ਸ਼ਤਸੇਨਾਪਤਿ ਰ੍ਵਕ੍ਸ਼਼੍ਯਮਾਣਵਾਕ੍ਯੰ ਤੰ ਵਕ੍ਤੁੰ ਬਨ੍ਧੂਨ੍ ਪ੍ਰਾਹਿਣੋਤ੍| ਹੇ ਪ੍ਰਭੋ ਸ੍ਵਯੰ ਸ਼੍ਰਮੋ ਨ ਕਰ੍ੱਤਵ੍ਯੋ ਯਦ੍ ਭਵਤਾ ਮਦ੍ਗੇਹਮਧ੍ਯੇ ਪਾਦਾਰ੍ਪਣੰ ਕ੍ਰਿਯੇਤ ਤਦਪ੍ਯਹੰ ਨਾਰ੍ਹਾਮਿ, ");
INSERT INTO sanpun_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ਕਿਞ੍ਚਾਹੰ ਭਵਤ੍ਸਮੀਪੰ ਯਾਤੁਮਪਿ ਨਾਤ੍ਮਾਨੰ ਯੋਗ੍ਯੰ ਬੁੱਧਵਾਨ੍, ਤਤੋ ਭਵਾਨ੍ ਵਾਕ੍ਯਮਾਤ੍ਰੰ ਵਦਤੁ ਤੇਨੈਵ ਮਮ ਦਾਸਃ ਸ੍ਵਸ੍ਥੋ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","ਯਸ੍ਮਾਦ੍ ਅਹੰ ਪਰਾਧੀਨੋਪਿ ਮਮਾਧੀਨਾ ਯਾਃ ਸੇਨਾਃ ਸਨ੍ਤਿ ਤਾਸਾਮ੍ ਏਕਜਨੰ ਪ੍ਰਤਿ ਯਾਹੀਤਿ ਮਯਾ ਪ੍ਰੋਕ੍ਤੇ ਸ ਯਾਤਿ; ਤਦਨ੍ਯੰ ਪ੍ਰਤਿ ਆਯਾਹੀਤਿ ਪ੍ਰੋਕ੍ਤੇ ਸ ਆਯਾਤਿ; ਤਥਾ ਨਿਜਦਾਸੰ ਪ੍ਰਤਿ ਏਤਤ੍ ਕੁਰ੍ੱਵਿਤਿ ਪ੍ਰੋਕ੍ਤੇ ਸ ਤਦੇਵ ਕਰੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ਯੀਸ਼ੁਰਿਦੰ ਵਾਕ੍ਯੰ ਸ਼੍ਰੁਤ੍ਵਾ ਵਿਸ੍ਮਯੰ ਯਯੌ, ਮੁਖੰ ਪਰਾਵਰ੍ਤ੍ਯ ਪਸ਼੍ਚਾਦ੍ਵਰ੍ੱਤਿਨੋ ਲੋਕਾਨ੍ ਬਭਾਸ਼਼ੇ ਚ, ਯੁਸ਼਼੍ਮਾਨਹੰ ਵਦਾਮਿ ਇਸ੍ਰਾਯੇਲੋ ਵੰਸ਼ਮਧ੍ਯੇਪਿ ਵਿਸ਼੍ਵਾਸਮੀਦ੍ਰੁʼਸ਼ੰ ਨ ਪ੍ਰਾਪ੍ਨਵੰ| ");
INSERT INTO sanpun_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ਤਤਸ੍ਤੇ ਪ੍ਰੇਸ਼਼ਿਤਾ ਗ੍ਰੁʼਹੰ ਗਤ੍ਵਾ ਤੰ ਪੀਡਿਤੰ ਦਾਸੰ ਸ੍ਵਸ੍ਥੰ ਦਦ੍ਰੁʼਸ਼ੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","ਪਰੇ(ਅ)ਹਨਿ ਸ ਨਾਯੀਨਾਖ੍ਯੰ ਨਗਰੰ ਜਗਾਮ ਤਸ੍ਯਾਨੇਕੇ ਸ਼ਿਸ਼਼੍ਯਾ ਅਨ੍ਯੇ ਚ ਲੋਕਾਸ੍ਤੇਨ ਸਾਰ੍ੱਧੰ ਯਯੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ਤੇਸ਼਼ੁ ਤੰਨਗਰਸ੍ਯ ਦ੍ਵਾਰਸੰਨਿਧਿੰ ਪ੍ਰਾਪ੍ਤੇਸ਼਼ੁ ਕਿਯਨ੍ਤੋ ਲੋਕਾ ਏਕੰ ਮ੍ਰੁʼਤਮਨੁਜੰ ਵਹਨ੍ਤੋ ਨਗਰਸ੍ਯ ਬਹਿਰ੍ਯਾਨ੍ਤਿ, ਸ ਤਨ੍ਮਾਤੁਰੇਕਪੁਤ੍ਰਸ੍ਤਨ੍ਮਾਤਾ ਚ ਵਿਧਵਾ; ਤਯਾ ਸਾਰ੍ੱਧੰ ਤੰਨਗਰੀਯਾ ਬਹਵੋ ਲੋਕਾ ਆਸਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ਪ੍ਰਭੁਸ੍ਤਾਂ ਵਿਲੋਕ੍ਯ ਸਾਨੁਕਮ੍ਪਃ ਕਥਯਾਮਾਸ, ਮਾ ਰੋਦੀਃ| ਸ ਸਮੀਪਮਿਤ੍ਵਾ ਖਟ੍ਵਾਂ ਪਸ੍ਪਰ੍ਸ਼ ਤਸ੍ਮਾਦ੍ ਵਾਹਕਾਃ ਸ੍ਥਗਿਤਾਸ੍ਤਮ੍ਯੁਃ; ");
INSERT INTO sanpun_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ਤਦਾ ਸ ਉਵਾਚ ਹੇ ਯੁਵਮਨੁਸ਼਼੍ਯ ਤ੍ਵਮੁੱਤਿਸ਼਼੍ਠ, ਤ੍ਵਾਮਹਮ੍ ਆਜ੍ਞਾਪਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","ਤਸ੍ਮਾਤ੍ ਸ ਮ੍ਰੁʼਤੋ ਜਨਸ੍ਤਤ੍ਕ੍ਸ਼਼ਣਮੁੱਥਾਯ ਕਥਾਂ ਪ੍ਰਕਥਿਤਃ; ਤਤੋ ਯੀਸ਼ੁਸ੍ਤਸ੍ਯ ਮਾਤਰਿ ਤੰ ਸਮਰ੍ਪਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","ਤਸ੍ਮਾਤ੍ ਸਰ੍ੱਵੇ ਲੋਕਾਃ ਸ਼ਸ਼ਙ੍ਕਿਰੇ; ਏਕੋ ਮਹਾਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦੀ ਮਧ੍ਯੇ(ਅ)ਸ੍ਮਾਕਮ੍ ਸਮੁਦੈਤ੍, ਈਸ਼੍ਵਰਸ਼੍ਚ ਸ੍ਵਲੋਕਾਨਨ੍ਵਗ੍ਰੁʼਹ੍ਲਾਤ੍ ਕਥਾਮਿਮਾਂ ਕਥਯਿਤ੍ਵਾ ਈਸ਼੍ਵਰੰ ਧਨ੍ਯੰ ਜਗਦੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ਤਤਃ ਪਰੰ ਸਮਸ੍ਤੰ ਯਿਹੂਦਾਦੇਸ਼ੰ ਤਸ੍ਯ ਚਤੁਰ੍ਦਿਕ੍ਸ੍ਥਦੇਸ਼ਞ੍ਚ ਤਸ੍ਯੈਤਤ੍ਕੀਰ੍ੱਤਿ ਰ੍ਵ੍ਯਾਨਸ਼ੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ਤਤਃ ਪਰੰ ਯੋਹਨਃ ਸ਼ਿਸ਼਼੍ਯੇਸ਼਼ੁ ਤੰ ਤਦ੍ਵ੍ਰੁʼੱਤਾਨ੍ਤੰ ਜ੍ਞਾਪਿਤਵਤ੍ਸੁ ");
INSERT INTO sanpun_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ਸ ਸ੍ਵਸ਼ਿਸ਼਼੍ਯਾਣਾਂ ਦ੍ਵੌ ਜਨਾਵਾਹੂਯ ਯੀਸ਼ੁੰ ਪ੍ਰਤਿ ਵਕ੍ਸ਼਼੍ਯਮਾਣੰ ਵਾਕ੍ਯੰ ਵਕ੍ਤੁੰ ਪ੍ਰੇਸ਼਼ਯਾਮਾਸ, ਯਸ੍ਯਾਗਮਨਮ੍ ਅਪੇਕ੍ਸ਼਼੍ਯ ਤਿਸ਼਼੍ਠਾਮੋ ਵਯੰ ਕਿੰ ਸ ਏਵ ਜਨਸ੍ਤ੍ਵੰ? ਕਿੰ ਵਯਮਨ੍ਯਮਪੇਕ੍ਸ਼਼੍ਯ ਸ੍ਥਾਸ੍ਯਾਮਃ? ");
INSERT INTO sanpun_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","ਪਸ਼੍ਚਾੱਤੌ ਮਾਨਵੌ ਗਤ੍ਵਾ ਕਥਯਾਮਾਸਤੁਃ, ਯਸ੍ਯਾਗਮਨਮ੍ ਅਪੇਕ੍ਸ਼਼੍ਯ ਤਿਸ਼਼੍ਠਾਮੋ ਵਯੰ, ਕਿੰ ਸਏਵ ਜਨਸ੍ਤ੍ਵੰ? ਕਿੰ ਵਯਮਨ੍ਯਮਪੇਕ੍ਸ਼਼੍ਯ ਸ੍ਥਾਸ੍ਯਾਮਃ? ਕਥਾਮਿਮਾਂ ਤੁਭ੍ਯੰ ਕਥਯਿਤੁੰ ਯੋਹਨ੍ ਮੱਜਕ ਆਵਾਂ ਪ੍ਰੇਸ਼਼ਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ਤਸ੍ਮਿਨ੍ ਦਣ੍ਡੇ ਯੀਸ਼ੂਰੋਗਿਣੋ ਮਹਾਵ੍ਯਾਧਿਮਤੋ ਦੁਸ਼਼੍ਟਭੂਤਗ੍ਰਸ੍ਤਾਂਸ਼੍ਚ ਬਹੂਨ੍ ਸ੍ਵਸ੍ਥਾਨ੍ ਕ੍ਰੁʼਤ੍ਵਾ, ਅਨੇਕਾਨ੍ਧੇਭ੍ਯਸ਼੍ਚਕ੍ਸ਼਼ੁੰਸ਼਼ਿ ਦੱਤ੍ਵਾ ਪ੍ਰਤ੍ਯੁਵਾਚ, ");
INSERT INTO sanpun_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ਯੁਵਾਂ ਵ੍ਰਜਤਮ੍ ਅਨ੍ਧਾ ਨੇਤ੍ਰਾਣਿ ਖਞ੍ਜਾਸ਼੍ਚਰਣਾਨਿ ਚ ਪ੍ਰਾਪ੍ਨੁਵਨ੍ਤਿ, ਕੁਸ਼਼੍ਠਿਨਃ ਪਰਿਸ਼਼੍ਕ੍ਰਿਯਨ੍ਤੇ, ਬਧਿਰਾਃ ਸ਼੍ਰਵਣਾਨਿ ਮ੍ਰੁʼਤਾਸ਼੍ਚ ਜੀਵਨਾਨਿ ਪ੍ਰਾਪ੍ਨੁਵਨ੍ਤਿ, ਦਰਿਦ੍ਰਾਣਾਂ ਸਮੀਪੇਸ਼਼ੁ ਸੁਸੰਵਾਦਃ ਪ੍ਰਚਾਰ੍ੱਯਤੇ, ਯੰ ਪ੍ਰਤਿ ਵਿਘ੍ਨਸ੍ਵਰੂਪੋਹੰ ਨ ਭਵਾਮਿ ਸ ਧਨ੍ਯਃ, ");
INSERT INTO sanpun_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ਏਤਾਨਿ ਯਾਨਿ ਪਸ਼੍ਯਥਃ ਸ਼੍ਰੁʼਣੁਥਸ਼੍ਚ ਤਾਨਿ ਯੋਹਨੰ ਜ੍ਞਾਪਯਤਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ਤਯੋ ਰ੍ਦੂਤਯੋ ਰ੍ਗਤਯੋਃ ਸਤੋ ਰ੍ਯੋਹਨਿ ਸ ਲੋਕਾਨ੍ ਵਕ੍ਤੁਮੁਪਚਕ੍ਰਮੇ, ਯੂਯੰ ਮਧ੍ਯੇਪ੍ਰਾਨ੍ਤਰੰ ਕਿੰ ਦ੍ਰਸ਼਼੍ਟੁੰ ਨਿਰਗਮਤ? ਕਿੰ ਵਾਯੁਨਾ ਕਮ੍ਪਿਤੰ ਨਡੰ? ");
INSERT INTO sanpun_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ਯੂਯੰ ਕਿੰ ਦ੍ਰਸ਼਼੍ਟੁੰ ਨਿਰਗਮਤ? ਕਿੰ ਸੂਕ੍ਸ਼਼੍ਮਵਸ੍ਤ੍ਰਪਰਿਧਾਯਿਨੰ ਕਮਪਿ ਨਰੰ? ਕਿਨ੍ਤੁ ਯੇ ਸੂਕ੍ਸ਼਼੍ਮਮ੍ਰੁʼਦੁਵਸ੍ਤ੍ਰਾਣਿ ਪਰਿਦਧਤਿ ਸੂੱਤਮਾਨਿ ਦ੍ਰਵ੍ਯਾਣਿ ਭੁਞ੍ਜਤੇ ਚ ਤੇ ਰਾਜਧਾਨੀਸ਼਼ੁ ਤਿਸ਼਼੍ਠਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ਤਰ੍ਹਿ ਯੂਯੰ ਕਿੰ ਦ੍ਰਸ਼਼੍ਟੁੰ ਨਿਰਗਮਤ? ਕਿਮੇਕੰ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨੰ? ਤਦੇਵ ਸਤ੍ਯੰ ਕਿਨ੍ਤੁ ਸ ਪੁਮਾਨ੍ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨੋਪਿ ਸ਼੍ਰੇਸ਼਼੍ਠ ਇਤ੍ਯਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਵਦਾਮਿ; ");
INSERT INTO sanpun_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ਪਸ਼੍ਯ ਸ੍ਵਕੀਯਦੂਤਨ੍ਤੁ ਤਵਾਗ੍ਰ ਪ੍ਰੇਸ਼਼ਯਾਮ੍ਯਹੰ| ਗਤ੍ਵਾ ਤ੍ਵਦੀਯਮਾਰ੍ਗਨ੍ਤੁ ਸ ਹਿ ਪਰਿਸ਼਼੍ਕਰਿਸ਼਼੍ਯਤਿ| ਯਦਰ੍ਥੇ ਲਿਪਿਰਿਯਮ੍ ਆਸ੍ਤੇ ਸ ਏਵ ਯੋਹਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","ਅਤੋ ਯੁਸ਼਼੍ਮਾਨਹੰ ਵਦਾਮਿ ਸ੍ਤ੍ਰਿਯਾ ਗਰ੍ੱਭਜਾਤਾਨਾਂ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਾਂ ਮਧ੍ਯੇ ਯੋਹਨੋ ਮੱਜਕਾਤ੍ ਸ਼੍ਰੇਸ਼਼੍ਠਃ ਕੋਪਿ ਨਾਸ੍ਤਿ, ਤਤ੍ਰਾਪਿ ਈਸ਼੍ਵਰਸ੍ਯ ਰਾਜ੍ਯੇ ਯਃ ਸਰ੍ੱਵਸ੍ਮਾਤ੍ ਕ੍ਸ਼਼ੁਦ੍ਰਃ ਸ ਯੋਹਨੋਪਿ ਸ਼੍ਰੇਸ਼਼੍ਠਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","ਅਪਰਞ੍ਚ ਸਰ੍ੱਵੇ ਲੋਕਾਃ ਕਰਮਞ੍ਚਾਯਿਨਸ਼੍ਚ ਤਸ੍ਯ ਵਾਕ੍ਯਾਨਿ ਸ਼੍ਰੁਤ੍ਵਾ ਯੋਹਨਾ ਮੱਜਨੇਨ ਮੱਜਿਤਾਃ ਪਰਮੇਸ਼੍ਵਰੰ ਨਿਰ੍ਦੋਸ਼਼ੰ ਮੇਨਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","ਕਿਨ੍ਤੁ ਫਿਰੂਸ਼ਿਨੋ ਵ੍ਯਵਸ੍ਥਾਪਕਾਸ਼੍ਚ ਤੇਨ ਨ ਮੱਜਿਤਾਃ ਸ੍ਵਾਨ੍ ਪ੍ਰਤੀਸ਼੍ਵਰਸ੍ਯੋਪਦੇਸ਼ੰ ਨਿਸ਼਼੍ਫਲਮ੍ ਅਕੁਰ੍ੱਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","ਅਥ ਪ੍ਰਭੁਃ ਕਥਯਾਮਾਸ, ਇਦਾਨੀਨ੍ਤਨਜਨਾਨ੍ ਕੇਨੋਪਮਾਮਿ? ਤੇ ਕਸ੍ਯ ਸਦ੍ਰੁʼਸ਼ਾਃ? ");
INSERT INTO sanpun_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ਯੇ ਬਾਲਕਾ ਵਿਪਣ੍ਯਾਮ੍ ਉਪਵਿਸ਼੍ਯ ਪਰਸ੍ਪਰਮ੍ ਆਹੂਯ ਵਾਕ੍ਯਮਿਦੰ ਵਦਨ੍ਤਿ, ਵਯੰ ਯੁਸ਼਼੍ਮਾਕੰ ਨਿਕਟੇ ਵੰਸ਼ੀਰਵਾਦਿਸ਼਼੍ਮ, ਕਿਨ੍ਤੁ ਯੂਯੰ ਨਾਨਰ੍ੱਤਿਸ਼਼੍ਟ, ਵਯੰ ਯੁਸ਼਼੍ਮਾਕੰ ਨਿਕਟ ਅਰੋਦਿਸ਼਼੍ਮ, ਕਿਨ੍ਤੁ ਯੁਯੰ ਨ ਵ੍ਯਲਪਿਸ਼਼੍ਟ, ਬਾਲਕੈਰੇਤਾਦ੍ਰੁʼਸ਼ੈਸ੍ਤੇਸ਼਼ਾਮ੍ ਉਪਮਾ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","ਯਤੋ ਯੋਹਨ੍ ਮੱਜਕ ਆਗਤ੍ਯ ਪੂਪੰ ਨਾਖਾਦਤ੍ ਦ੍ਰਾਕ੍ਸ਼਼ਾਰਸਞ੍ਚ ਨਾਪਿਵਤ੍ ਤਸ੍ਮਾਦ੍ ਯੂਯੰ ਵਦਥ, ਭੂਤਗ੍ਰਸ੍ਤੋਯਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","ਤਤਃ ਪਰੰ ਮਾਨਵਸੁਤ ਆਗਤ੍ਯਾਖਾਦਦਪਿਵਞ੍ਚ ਤਸ੍ਮਾਦ੍ ਯੂਯੰ ਵਦਥ, ਖਾਦਕਃ ਸੁਰਾਪਸ਼੍ਚਾਣ੍ਡਾਲਪਾਪਿਨਾਂ ਬਨ੍ਧੁਰੇਕੋ ਜਨੋ ਦ੍ਰੁʼਸ਼੍ਯਤਾਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","ਕਿਨ੍ਤੁ ਜ੍ਞਾਨਿਨੋ ਜ੍ਞਾਨੰ ਨਿਰ੍ਦੋਸ਼਼ੰ ਵਿਦੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ਪਸ਼੍ਚਾਦੇਕਃ ਫਿਰੂਸ਼ੀ ਯੀਸ਼ੁੰ ਭੋਜਨਾਯ ਨ੍ਯਮਨ੍ਤ੍ਰਯਤ੍ ਤਤਃ ਸ ਤਸ੍ਯ ਗ੍ਰੁʼਹੰ ਗਤ੍ਵਾ ਭੋਕ੍ਤੁਮੁਪਵਿਸ਼਼੍ਟਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ਏਤਰ੍ਹਿ ਤਤ੍ਫਿਰੂਸ਼ਿਨੋ ਗ੍ਰੁʼਹੇ ਯੀਸ਼ੁ ਰ੍ਭੇਕ੍ਤੁਮ੍ ਉਪਾਵੇਕ੍ਸ਼਼ੀਤ੍ ਤੱਛ੍ਰੁਤ੍ਵਾ ਤੰਨਗਰਵਾਸਿਨੀ ਕਾਪਿ ਦੁਸ਼਼੍ਟਾ ਨਾਰੀ ਪਾਣ੍ਡਰਪ੍ਰਸ੍ਤਰਸ੍ਯ ਸਮ੍ਪੁਟਕੇ ਸੁਗਨ੍ਧਿਤੈਲਮ੍ ਆਨੀਯ ");
INSERT INTO sanpun_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ਤਸ੍ਯ ਪਸ਼੍ਚਾਤ੍ ਪਾਦਯੋਃ ਸੰਨਿਧੌ ਤਸ੍ਯੌ ਰੁਦਤੀ ਚ ਨੇਤ੍ਰਾਮ੍ਬੁਭਿਸ੍ਤਸ੍ਯ ਚਰਣੌ ਪ੍ਰਕ੍ਸ਼਼ਾਲ੍ਯ ਨਿਜਕਚੈਰਮਾਰ੍ਕ੍ਸ਼਼ੀਤ੍, ਤਤਸ੍ਤਸ੍ਯ ਚਰਣੌ ਚੁਮ੍ਬਿਤ੍ਵਾ ਤੇਨ ਸੁਗਨ੍ਧਿਤੈਲੇਨ ਮਮਰ੍ਦ| ");
INSERT INTO sanpun_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ਤਸ੍ਮਾਤ੍ ਸ ਨਿਮਨ੍ਤ੍ਰਯਿਤਾ ਫਿਰੂਸ਼ੀ ਮਨਸਾ ਚਿਨ੍ਤਯਾਮਾਸ, ਯਦ੍ਯਯੰ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦੀ ਭਵੇਤ੍ ਤਰ੍ਹਿ ਏਨੰ ਸ੍ਪ੍ਰੁʼਸ਼ਤਿ ਯਾ ਸ੍ਤ੍ਰੀ ਸਾ ਕਾ ਕੀਦ੍ਰੁʼਸ਼ੀ ਚੇਤਿ ਜ੍ਞਾਤੁੰ ਸ਼ਕ੍ਨੁਯਾਤ੍ ਯਤਃ ਸਾ ਦੁਸ਼਼੍ਟਾ| ");
INSERT INTO sanpun_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ਤਦਾ ਯਾਸ਼ੁਸ੍ਤੰ ਜਗਾਦ, ਹੇ ਸ਼ਿਮੋਨ੍ ਤ੍ਵਾਂ ਪ੍ਰਤਿ ਮਮ ਕਿਞ੍ਚਿਦ੍ ਵਕ੍ਤਵ੍ਯਮਸ੍ਤਿ; ਤਸ੍ਮਾਤ੍ ਸ ਬਭਾਸ਼਼ੇ, ਹੇ ਗੁਰੋ ਤਦ੍ ਵਦਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ਏਕੋੱਤਮਰ੍ਣਸ੍ਯ ਦ੍ਵਾਵਧਮਰ੍ਣਾਵਾਸ੍ਤਾਂ, ਤਯੋਰੇਕਃ ਪਞ੍ਚਸ਼ਤਾਨਿ ਮੁਦ੍ਰਾਪਾਦਾਨ੍ ਅਪਰਸ਼੍ਚ ਪਞ੍ਚਾਸ਼ਤ੍ ਮੁਦ੍ਰਾਪਾਦਾਨ੍ ਧਾਰਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","ਤਦਨਨ੍ਤਰੰ ਤਯੋਃ ਸ਼ੋਧ੍ਯਾਭਾਵਾਤ੍ ਸ ਉੱਤਮਰ੍ਣਸ੍ਤਯੋ ਰ੍ਰੁʼਣੇ ਚਕ੍ਸ਼਼ਮੇ; ਤਸ੍ਮਾਤ੍ ਤਯੋਰ੍ਦ੍ਵਯੋਃ ਕਸ੍ਤਸ੍ਮਿਨ੍ ਪ੍ਰੇਸ਼਼੍ਯਤੇ ਬਹੁ? ਤਦ੍ ਬ੍ਰੂਹਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ਸ਼ਿਮੋਨ੍ ਪ੍ਰਤ੍ਯੁਵਾਚ, ਮਯਾ ਬੁਧ੍ਯਤੇ ਯਸ੍ਯਾਧਿਕਮ੍ ਰੁʼਣੰ ਚਕ੍ਸ਼਼ਮੇ ਸ ਇਤਿ; ਤਤੋ ਯੀਸ਼ੁਸ੍ਤੰ ਵ੍ਯਾਜਹਾਰ, ਤ੍ਵੰ ਯਥਾਰ੍ਥੰ ਵ੍ਯਚਾਰਯਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ਅਥ ਤਾਂ ਨਾਰੀਂ ਪ੍ਰਤਿ ਵ੍ਯਾਘੁਠ੍ਯ ਸ਼ਿਮੋਨਮਵੋਚਤ੍, ਸ੍ਤ੍ਰੀਮਿਮਾਂ ਪਸ਼੍ਯਸਿ? ਤਵ ਗ੍ਰੁʼਹੇ ਮੱਯਾਗਤੇ ਤ੍ਵੰ ਪਾਦਪ੍ਰਕ੍ਸ਼਼ਾਲਨਾਰ੍ਥੰ ਜਲੰ ਨਾਦਾਃ ਕਿਨ੍ਤੁ ਯੋਸ਼਼ਿਦੇਸ਼਼ਾ ਨਯਨਜਲੈ ਰ੍ਮਮ ਪਾਦੌ ਪ੍ਰਕ੍ਸ਼਼ਾਲ੍ਯ ਕੇਸ਼ੈਰਮਾਰ੍ਕ੍ਸ਼਼ੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ਤ੍ਵੰ ਮਾਂ ਨਾਚੁਮ੍ਬੀਃ ਕਿਨ੍ਤੁ ਯੋਸ਼਼ਿਦੇਸ਼਼ਾ ਸ੍ਵੀਯਾਗਮਨਾਦਾਰਭ੍ਯ ਮਦੀਯਪਾਦੌ ਚੁਮ੍ਬਿਤੁੰ ਨ ਵ੍ਯਰੰਸ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ਤ੍ਵਞ੍ਚ ਮਦੀਯੋੱਤਮਾਙ੍ਗੇ ਕਿਞ੍ਚਿਦਪਿ ਤੈਲੰ ਨਾਮਰ੍ਦੀਃ ਕਿਨ੍ਤੁ ਯੋਸ਼਼ਿਦੇਸ਼਼ਾ ਮਮ ਚਰਣੌ ਸੁਗਨ੍ਧਿਤੈਲੇਨਾਮਰ੍ੱਦੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","ਅਤਸ੍ਤ੍ਵਾਂ ਵ੍ਯਾਹਰਾਮਿ, ਏਤਸ੍ਯਾ ਬਹੁ ਪਾਪਮਕ੍ਸ਼਼ਮ੍ਯਤ ਤਤੋ ਬਹੁ ਪ੍ਰੀਯਤੇ ਕਿਨ੍ਤੁ ਯਸ੍ਯਾਲ੍ਪਪਾਪੰ ਕ੍ਸ਼਼ਮ੍ਯਤੇ ਸੋਲ੍ਪੰ ਪ੍ਰੀਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ਤਤਃ ਪਰੰ ਸ ਤਾਂ ਬਭਾਸ਼਼ੇ, ਤ੍ਵਦੀਯੰ ਪਾਪਮਕ੍ਸ਼਼ਮ੍ਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ਤਦਾ ਤੇਨ ਸਾਰ੍ੱਧੰ ਯੇ ਭੋਕ੍ਤੁਮ੍ ਉਪਵਿਵਿਸ਼ੁਸ੍ਤੇ ਪਰਸ੍ਪਰੰ ਵਕ੍ਤੁਮਾਰੇਭਿਰੇ, ਅਯੰ ਪਾਪੰ ਕ੍ਸ਼਼ਮਤੇ ਕ ਏਸ਼਼ਃ? ");
INSERT INTO sanpun_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","ਕਿਨ੍ਤੁ ਸ ਤਾਂ ਨਾਰੀਂ ਜਗਾਦ, ਤਵ ਵਿਸ਼੍ਵਾਸਸ੍ਤ੍ਵਾਂ ਪਰ੍ੱਯਤ੍ਰਾਸ੍ਤ ਤ੍ਵੰ ਕ੍ਸ਼਼ੇਮੇਣ ਵ੍ਰਜ| ");
INSERT INTO sanpun_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ਅਪਰਞ੍ਚ ਯੀਸ਼ੁ ਰ੍ਦ੍ਵਾਦਸ਼ਭਿਃ ਸ਼ਿਸ਼਼੍ਯੈਃ ਸਾਰ੍ੱਧੰ ਨਾਨਾਨਗਰੇਸ਼਼ੁ ਨਾਨਾਗ੍ਰਾਮੇਸ਼਼ੁ ਚ ਗੱਛਨ੍ ਇਸ਼੍ਵਰੀਯਰਾਜਤ੍ਵਸ੍ਯ ਸੁਸੰਵਾਦੰ ਪ੍ਰਚਾਰਯਿਤੁੰ ਪ੍ਰਾਰੇਭੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ਤਦਾ ਯਸ੍ਯਾਃ ਸਪ੍ਤ ਭੂਤਾ ਨਿਰਗੱਛਨ੍ ਸਾ ਮਗ੍ਦਲੀਨੀਤਿ ਵਿਖ੍ਯਾਤਾ ਮਰਿਯਮ੍ ਹੇਰੋਦ੍ਰਾਜਸ੍ਯ ਗ੍ਰੁʼਹਾਧਿਪਤੇਃ ਹੋਸ਼਼ੇ ਰ੍ਭਾਰ੍ੱਯਾ ਯੋਹਨਾ ਸ਼ੂਸ਼ਾਨਾ ");
INSERT INTO sanpun_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ਪ੍ਰਭ੍ਰੁʼਤਯੋ ਯਾ ਬਹ੍ਵ੍ਯਃ ਸ੍ਤ੍ਰਿਯਃ ਦੁਸ਼਼੍ਟਭੂਤੇਭ੍ਯੋ ਰੋਗੇਭ੍ਯਸ਼੍ਚ ਮੁਕ੍ਤਾਃ ਸਤ੍ਯੋ ਨਿਜਵਿਭੂਤੀ ਰ੍ਵ੍ਯਯਿਤ੍ਵਾ ਤਮਸੇਵਨ੍ਤ, ਤਾਃ ਸਰ੍ੱਵਾਸ੍ਤੇਨ ਸਾਰ੍ੱਧਮ੍ ਆਸਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","ਅਨਨ੍ਤਰੰ ਨਾਨਾਨਗਰੇਭ੍ਯੋ ਬਹਵੋ ਲੋਕਾ ਆਗਤ੍ਯ ਤਸ੍ਯ ਸਮੀਪੇ(ਅ)ਮਿਲਨ੍, ਤਦਾ ਸ ਤੇਭ੍ਯ ਏਕਾਂ ਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤਕਥਾਂ ਕਥਯਾਮਾਸ| ਏਕਃ ਕ੍ਰੁʼਸ਼਼ੀਬਲੋ ਬੀਜਾਨਿ ਵਪ੍ਤੁੰ ਬਹਿਰ੍ਜਗਾਮ, ");
INSERT INTO sanpun_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","ਤਤੋ ਵਪਨਕਾਲੇ ਕਤਿਪਯਾਨਿ ਬੀਜਾਨਿ ਮਾਰ੍ਗਪਾਰ੍ਸ਼੍ਵੇ ਪੇਤੁਃ, ਤਤਸ੍ਤਾਨਿ ਪਦਤਲੈ ਰ੍ਦਲਿਤਾਨਿ ਪਕ੍ਸ਼਼ਿਭਿ ਰ੍ਭਕ੍ਸ਼਼ਿਤਾਨਿ ਚ| ");
INSERT INTO sanpun_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","ਕਤਿਪਯਾਨਿ ਬੀਜਾਨਿ ਪਾਸ਼਼ਾਣਸ੍ਥਲੇ ਪਤਿਤਾਨਿ ਯਦ੍ਯਪਿ ਤਾਨ੍ਯਙ੍ਕੁਰਿਤਾਨਿ ਤਥਾਪਿ ਰਸਾਭਾਵਾਤ੍ ਸ਼ੁਸ਼ੁਸ਼਼ੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","ਕਤਿਪਯਾਨਿ ਬੀਜਾਨਿ ਕਣ੍ਟਕਿਵਨਮਧ੍ਯੇ ਪਤਿਤਾਨਿ ਤਤਃ ਕਣ੍ਟਕਿਵਨਾਨਿ ਸੰਵ੍ਰੁʼੱਧ੍ਯ ਤਾਨਿ ਜਗ੍ਰਸੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","ਤਦਨ੍ਯਾਨਿ ਕਤਿਪਯਬੀਜਾਨਿ ਚ ਭੂਮ੍ਯਾਮੁੱਤਮਾਯਾਂ ਪੇਤੁਸ੍ਤਤਸ੍ਤਾਨ੍ਯਙ੍ਕੁਰਯਿਤ੍ਵਾ ਸ਼ਤਗੁਣਾਨਿ ਫਲਾਨਿ ਫੇਲੁਃ| ਸ ਇਮਾ ਕਥਾਂ ਕਥਯਿਤ੍ਵਾ ਪ੍ਰੋੱਚੈਃ ਪ੍ਰੋਵਾਚ, ਯਸ੍ਯ ਸ਼੍ਰੋਤੁੰ ਸ਼੍ਰੋਤ੍ਰੇ ਸ੍ਤਃ ਸ ਸ਼੍ਰੁʼਣੋਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ਤਤਃ ਪਰੰ ਸ਼ਿਸ਼਼੍ਯਾਸ੍ਤੰ ਪਪ੍ਰੱਛੁਰਸ੍ਯ ਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤਸ੍ਯ ਕਿੰ ਤਾਤ੍ਪਰ੍ੱਯੰ? ");
INSERT INTO sanpun_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ਤਤਃ ਸ ਵ੍ਯਾਜਹਾਰ, ਈਸ਼੍ਵਰੀਯਰਾਜ੍ਯਸ੍ਯ ਗੁਹ੍ਯਾਨਿ ਜ੍ਞਾਤੁੰ ਯੁਸ਼਼੍ਮਭ੍ਯਮਧਿਕਾਰੋ ਦੀਯਤੇ ਕਿਨ੍ਤ੍ਵਨ੍ਯੇ ਯਥਾ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾਪਿ ਨ ਪਸ਼੍ਯਨ੍ਤਿ ਸ਼੍ਰੁਤ੍ਵਾਪਿ ਮ ਬੁਧ੍ਯਨ੍ਤੇ ਚ ਤਦਰ੍ਥੰ ਤੇਸ਼਼ਾਂ ਪੁਰਸ੍ਤਾਤ੍ ਤਾਃ ਸਰ੍ੱਵਾਃ ਕਥਾ ਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤੇਨ ਕਥ੍ਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","ਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤਸ੍ਯਾਸ੍ਯਾਭਿਪ੍ਰਾਯਃ, ਈਸ਼੍ਵਰੀਯਕਥਾ ਬੀਜਸ੍ਵਰੂਪਾ| ");
INSERT INTO sanpun_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ਯੇ ਕਥਾਮਾਤ੍ਰੰ ਸ਼੍ਰੁʼਣ੍ਵਨ੍ਤਿ ਕਿਨ੍ਤੁ ਪਸ਼੍ਚਾਦ੍ ਵਿਸ਼੍ਵਸ੍ਯ ਯਥਾ ਪਰਿਤ੍ਰਾਣੰ ਨ ਪ੍ਰਾਪ੍ਨੁਵਨ੍ਤਿ ਤਦਾਸ਼ਯੇਨ ਸ਼ੈਤਾਨੇਤ੍ਯ ਹ੍ਰੁʼਦਯਾਤ੍ਰੁʼ ਤਾਂ ਕਥਾਮ੍ ਅਪਹਰਤਿ ਤ ਏਵ ਮਾਰ੍ਗਪਾਰ੍ਸ਼੍ਵਸ੍ਥਭੂਮਿਸ੍ਵਰੂਪਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ਯੇ ਕਥੰ ਸ਼੍ਰੁਤ੍ਵਾ ਸਾਨਨ੍ਦੰ ਗ੍ਰੁʼਹ੍ਲਨ੍ਤਿ ਕਿਨ੍ਤ੍ਵਬੱਧਮੂਲਤ੍ਵਾਤ੍ ਸ੍ਵਲ੍ਪਕਾਲਮਾਤ੍ਰੰ ਪ੍ਰਤੀਤ੍ਯ ਪਰੀਕ੍ਸ਼਼ਾਕਾਲੇ ਭ੍ਰਸ਼੍ਯਨ੍ਤਿ ਤਏਵ ਪਾਸ਼਼ਾਣਭੂਮਿਸ੍ਵਰੂਪਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ਯੇ ਕਥਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਯਾਨ੍ਤਿ ਵਿਸ਼਼ਯਚਿਨ੍ਤਾਯਾਂ ਧਨਲੋਭੇਨ ਏेਹਿਕਸੁਖੇ ਚ ਮੱਜਨ੍ਤ ਉਪਯੁਕ੍ਤਫਲਾਨਿ ਨ ਫਲਨ੍ਤਿ ਤ ਏਵੋਪ੍ਤਬੀਜਕਣ੍ਟਕਿਭੂਸ੍ਵਰੂਪਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","ਕਿਨ੍ਤੁ ਯੇ ਸ਼੍ਰੁਤ੍ਵਾ ਸਰਲੈਃ ਸ਼ੁੱਧੈਸ਼੍ਚਾਨ੍ਤਃਕਰਣੈਃ ਕਥਾਂ ਗ੍ਰੁʼਹ੍ਲਨ੍ਤਿ ਧੈਰ੍ੱਯਮ੍ ਅਵਲਮ੍ਬ੍ਯ ਫਲਾਨ੍ਯੁਤ੍ਪਾਦਯਨ੍ਤਿ ਚ ਤ ਏਵੋੱਤਮਮ੍ਰੁʼਤ੍ਸ੍ਵਰੂਪਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","ਅਪਰਞ੍ਚ ਪ੍ਰਦੀਪੰ ਪ੍ਰਜ੍ਵਾਲ੍ਯ ਕੋਪਿ ਪਾਤ੍ਰੇਣ ਨਾੱਛਾਦਯਤਿ ਤਥਾ ਖਟ੍ਵਾਧੋਪਿ ਨ ਸ੍ਥਾਪਯਤਿ, ਕਿਨ੍ਤੁ ਦੀਪਾਧਾਰੋਪਰ੍ੱਯੇਵ ਸ੍ਥਾਪਯਤਿ, ਤਸ੍ਮਾਤ੍ ਪ੍ਰਵੇਸ਼ਕਾ ਦੀਪ੍ਤਿੰ ਪਸ਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","ਯੰਨ ਪ੍ਰਕਾਸ਼ਯਿਸ਼਼੍ਯਤੇ ਤਾਦ੍ਰੁʼਗ੍ ਅਪ੍ਰਕਾਸ਼ਿਤੰ ਵਸ੍ਤੁ ਕਿਮਪਿ ਨਾਸ੍ਤਿ ਯੱਚ ਨ ਸੁਵ੍ਯਕ੍ਤੰ ਪ੍ਰਚਾਰਯਿਸ਼਼੍ਯਤੇ ਤਾਦ੍ਰੁʼਗ੍ ਗ੍ਰੁʼਪ੍ਤੰ ਵਸ੍ਤੁ ਕਿਮਪਿ ਨਾਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","ਅਤੋ ਯੂਯੰ ਕੇਨ ਪ੍ਰਕਾਰੇਣ ਸ਼੍ਰੁʼਣੁਥ ਤਤ੍ਰ ਸਾਵਧਾਨਾ ਭਵਤ, ਯਸ੍ਯ ਸਮੀਪੇ ਬਰ੍ੱਧਤੇ ਤਸ੍ਮੈ ਪੁਨਰ੍ਦਾਸ੍ਯਤੇ ਕਿਨ੍ਤੁ ਯਸ੍ਯਾਸ਼੍ਰਯੇ ਨ ਬਰ੍ੱਧਤੇ ਤਸ੍ਯ ਯਦ੍ਯਦਸ੍ਤਿ ਤਦਪਿ ਤਸ੍ਮਾਤ੍ ਨੇਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ਅਪਰਞ੍ਚ ਯੀਸ਼ੋ ਰ੍ਮਾਤਾ ਭ੍ਰਾਤਰਸ਼੍ਚ ਤਸ੍ਯ ਸਮੀਪੰ ਜਿਗਮਿਸ਼਼ਵਃ ");
INSERT INTO sanpun_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","ਕਿਨ੍ਤੁ ਜਨਤਾਸਮ੍ਬਾਧਾਤ੍ ਤਤ੍ਸੰਨਿਧਿੰ ਪ੍ਰਾਪ੍ਤੁੰ ਨ ਸ਼ੇਕੁਃ| ਤਤ੍ਪਸ਼੍ਚਾਤ੍ ਤਵ ਮਾਤਾ ਭ੍ਰਾਤਰਸ਼੍ਚ ਤ੍ਵਾਂ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਚਿਕੀਰ੍ਸ਼਼ਨ੍ਤੋ ਬਹਿਸ੍ਤਿਸ਼਼੍ਠਨਤੀਤਿ ਵਾਰ੍ੱਤਾਯਾਂ ਤਸ੍ਮੈ ਕਥਿਤਾਯਾਂ ");
INSERT INTO sanpun_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ਸ ਪ੍ਰਤ੍ਯੁਵਾਚ; ਯੇ ਜਨਾ ਈਸ਼੍ਵਰਸ੍ਯ ਕਥਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਤਦਨੁਰੂਪਮਾਚਰਨ੍ਤਿ ਤਏਵ ਮਮ ਮਾਤਾ ਭ੍ਰਾਤਰਸ਼੍ਚ| ");
INSERT INTO sanpun_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","ਅਨਨ੍ਤਰੰ ਏਕਦਾ ਯੀਸ਼ੁਃ ਸ਼ਿਸ਼਼੍ਯੈਃ ਸਾਰ੍ੱਧੰ ਨਾਵਮਾਰੁਹ੍ਯ ਜਗਾਦ, ਆਯਾਤ ਵਯੰ ਹ੍ਰਦਸ੍ਯ ਪਾਰੰ ਯਾਮਃ, ਤਤਸ੍ਤੇ ਜਗ੍ਮੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ਤੇਸ਼਼ੁ ਨੌਕਾਂ ਵਾਹਯਤ੍ਸੁ ਸ ਨਿਦਦ੍ਰੌ; ");
INSERT INTO sanpun_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ਅਥਾਕਸ੍ਮਾਤ੍ ਪ੍ਰਬਲਝਞ੍ਭ੍ਸ਼ਗਮਾਦ੍ ਹ੍ਰਦੇ ਨੌਕਾਯਾਂ ਤਰਙ੍ਗੈਰਾੱਛੰਨਾਯਾਂ ਵਿਪਤ੍ ਤਾਨ੍ ਜਗ੍ਰਾਸ| ਤਸ੍ਮਾਦ੍ ਯੀਸ਼ੋਰਨ੍ਤਿਕੰ ਗਤ੍ਵਾ ਹੇ ਗੁਰੋ ਹੇ ਗੁਰੋ ਪ੍ਰਾਣਾ ਨੋ ਯਾਨ੍ਤੀਤਿ ਗਦਿਤ੍ਵਾ ਤੰ ਜਾਗਰਯਾਮ੍ਬਭੂਵੁਃ| ਤਦਾ ਸ ਉੱਥਾਯ ਵਾਯੁੰ ਤਰਙ੍ਗਾਂਸ਼੍ਚ ਤਰ੍ਜਯਾਮਾਸ ਤਸ੍ਮਾਦੁਭੌ ਨਿਵ੍ਰੁʼਤ੍ਯ ਸ੍ਥਿਰੌ ਬਭੂਵਤੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ਸ ਤਾਨ੍ ਬਭਾਸ਼਼ੇ ਯੁਸ਼਼੍ਮਾਕੰ ਵਿਸ਼੍ਵਾਸਃ ਕ? ਤਸ੍ਮਾੱਤੇ ਭੀਤਾ ਵਿਸ੍ਮਿਤਾਸ਼੍ਚ ਪਰਸ੍ਪਰੰ ਜਗਦੁਃ, ਅਹੋ ਕੀਦ੍ਰੁʼਗਯੰ ਮਨੁਜਃ ਪਵਨੰ ਪਾਨੀਯਞ੍ਚਾਦਿਸ਼ਤਿ ਤਦੁਭਯੰ ਤਦਾਦੇਸ਼ੰ ਵਹਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ਤਤਃ ਪਰੰ ਗਾਲੀਲ੍ਪ੍ਰਦੇਸ਼ਸ੍ਯ ਸੰਮੁਖਸ੍ਥਗਿਦੇਰੀਯਪ੍ਰਦੇਸ਼ੇ ਨੌਕਾਯਾਂ ਲਗਨ੍ਤ੍ਯਾਂ ਤਟੇ(ਅ)ਵਰੋਹਮਾਵਾਦ੍ ");
INSERT INTO sanpun_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ਬਹੁਤਿਥਕਾਲੰ ਭੂਤਗ੍ਰਸ੍ਤ ਏਕੋ ਮਾਨੁਸ਼਼ਃ ਪੁਰਾਦਾਗਤ੍ਯ ਤੰ ਸਾਕ੍ਸ਼਼ਾੱਚਕਾਰ| ਸ ਮਨੁਸ਼਼ੋ ਵਾਸੋ ਨ ਪਰਿਦਧਤ੍ ਗ੍ਰੁʼਹੇ ਚ ਨ ਵਸਨ੍ ਕੇਵਲੰ ਸ਼੍ਮਸ਼ਾਨਮ੍ ਅਧ੍ਯੁਵਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ਸ ਯੀਸ਼ੁੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵੈਵ ਚੀੱਛਬ੍ਦੰ ਚਕਾਰ ਤਸ੍ਯ ਸੰਮੁਖੇ ਪਤਿਤ੍ਵਾ ਪ੍ਰੋੱਚੈਰ੍ਜਗਾਦ ਚ, ਹੇ ਸਰ੍ੱਵਪ੍ਰਧਾਨੇਸ਼੍ਵਰਸ੍ਯ ਪੁਤ੍ਰ, ਮਯਾ ਸਹ ਤਵ ਕਃ ਸਮ੍ਬਨ੍ਧਃ? ਤ੍ਵਯਿ ਵਿਨਯੰ ਕਰੋਮਿ ਮਾਂ ਮਾ ਯਾਤਯ| ");
INSERT INTO sanpun_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","ਯਤਃ ਸ ਤੰ ਮਾਨੁਸ਼਼ੰ ਤ੍ਯਕ੍ਤ੍ਵਾ ਯਾਤੁਮ੍ ਅਮੇਧ੍ਯਭੂਤਮ੍ ਆਦਿਦੇਸ਼; ਸ ਭੂਤਸ੍ਤੰ ਮਾਨੁਸ਼਼ਮ੍ ਅਸਕ੍ਰੁʼਦ੍ ਦਧਾਰ ਤਸ੍ਮਾੱਲੋਕਾਃ ਸ਼੍ਰੁʼਙ੍ਖਲੇਨ ਨਿਗਡੇਨ ਚ ਬਬਨ੍ਧੁਃ; ਸ ਤਦ੍ ਭੰਕ੍ਤ੍ਵਾ ਭੂਤਵਸ਼ਤ੍ਵਾਤ੍ ਮਧ੍ਯੇਪ੍ਰਾਨ੍ਤਰੰ ਯਯੌ| ");
INSERT INTO sanpun_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","ਅਨਨ੍ਤਰੰ ਯੀਸ਼ੁਸ੍ਤੰ ਪਪ੍ਰੱਛ ਤਵ ਕਿੰਨਾਮ? ਸ ਉਵਾਚ, ਮਮ ਨਾਮ ਬਾਹਿਨੋ ਯਤੋ ਬਹਵੋ ਭੂਤਾਸ੍ਤਮਾਸ਼ਿਸ਼੍ਰਿਯੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","ਅਥ ਭੂਤਾ ਵਿਨਯੇਨ ਜਗਦੁਃ, ਗਭੀਰੰ ਗਰ੍ੱਤੰ ਗਨ੍ਤੁੰ ਮਾਜ੍ਞਾਪਯਾਸ੍ਮਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ਤਦਾ ਪਰ੍ੱਵਤੋਪਰਿ ਵਰਾਹਵ੍ਰਜਸ਼੍ਚਰਤਿ ਤਸ੍ਮਾਦ੍ ਭੂਤਾ ਵਿਨਯੇਨ ਪ੍ਰੋਚੁਃ, ਅਮੁੰ ਵਰਾਹਵ੍ਰਜਮ੍ ਆਸ਼੍ਰਯਿਤੁਮ੍ ਅਸ੍ਮਾਨ੍ ਅਨੁਜਾਨੀਹਿ; ਤਤਃ ਸੋਨੁਜਜ੍ਞੌ| ");
INSERT INTO sanpun_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ਤਤਃ ਪਰੰ ਭੂਤਾਸ੍ਤੰ ਮਾਨੁਸ਼਼ੰ ਵਿਹਾਯ ਵਰਾਹਵ੍ਰਜਮ੍ ਆਸ਼ਿਸ਼੍ਰਿਯੁਃ ਵਰਾਹਵ੍ਰਜਾਸ਼੍ਚ ਤਤ੍ਕ੍ਸ਼਼ਣਾਤ੍ ਕਟਕੇਨ ਧਾਵਨ੍ਤੋ ਹ੍ਰਦੇ ਪ੍ਰਾਣਾਨ੍ ਵਿਜ੍ਰੁʼਹੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ਤਦ੍ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਸ਼ੂਕਰਰਕ੍ਸ਼਼ਕਾਃ ਪਲਾਯਮਾਨਾ ਨਗਰੰ ਗ੍ਰਾਮਞ੍ਚ ਗਤ੍ਵਾ ਤਤ੍ਸਰ੍ੱਵਵ੍ਰੁʼੱਤਾਨ੍ਤੰ ਕਥਯਾਮਾਸੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","ਤਤਃ ਕਿੰ ਵ੍ਰੁʼੱਤਮ੍ ਏਤੱਦਰ੍ਸ਼ਨਾਰ੍ਥੰ ਲੋਕਾ ਨਿਰ੍ਗਤ੍ਯ ਯੀਸ਼ੋਃ ਸਮੀਪੰ ਯਯੁਃ, ਤੰ ਮਾਨੁਸ਼਼ੰ ਤ੍ਯਕ੍ਤਭੂਤੰ ਪਰਿਹਿਤਵਸ੍ਤ੍ਰੰ ਸ੍ਵਸ੍ਥਮਾਨੁਸ਼਼ਵਦ੍ ਯੀਸ਼ੋਸ਼੍ਚਰਣਸੰਨਿਧੌ ਸੂਪਵਿਸ਼ਨ੍ਤੰ ਵਿਲੋਕ੍ਯ ਬਿਭ੍ਯੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ਯੇ ਲੋਕਾਸ੍ਤਸ੍ਯ ਭੂਤਗ੍ਰਸ੍ਤਸ੍ਯ ਸ੍ਵਾਸ੍ਥ੍ਯਕਰਣੰ ਦਦ੍ਰੁʼਸ਼ੁਸ੍ਤੇ ਤੇਭ੍ਯਃ ਸਰ੍ੱਵਵ੍ਰੁʼੱਤਾਨ੍ਤੰ ਕਥਯਾਮਾਸੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ਤਦਨਨ੍ਤਰੰ ਤਸ੍ਯ ਗਿਦੇਰੀਯਪ੍ਰਦੇਸ਼ਸ੍ਯ ਚਤੁਰ੍ਦਿਕ੍ਸ੍ਥਾ ਬਹਵੋ ਜਨਾ ਅਤਿਤ੍ਰਸ੍ਤਾ ਵਿਨਯੇਨ ਤੰ ਜਗਦੁਃ, ਭਵਾਨ੍ ਅਸ੍ਮਾਕੰ ਨਿਕਟਾਦ੍ ਵ੍ਰਜਤੁ ਤਸ੍ਮਾਤ੍ ਸ ਨਾਵਮਾਰੁਹ੍ਯ ਤਤੋ ਵ੍ਯਾਘੁਟ੍ਯ ਜਗਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ਤਦਾਨੀਂ ਤ੍ਯਕ੍ਤਭੂਤਮਨੁਜਸ੍ਤੇਨ ਸਹ ਸ੍ਥਾਤੁੰ ਪ੍ਰਾਰ੍ਥਯਾਞ੍ਚਕ੍ਰੇ ");
INSERT INTO sanpun_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","ਕਿਨ੍ਤੁ ਤਦਰ੍ਥਮ੍ ਈਸ਼੍ਵਰਃ ਕੀਦ੍ਰੁʼਙ੍ਮਹਾਕਰ੍ੰਮ ਕ੍ਰੁʼਤਵਾਨ੍ ਇਤਿ ਨਿਵੇਸ਼ਨੰ ਗਤ੍ਵਾ ਵਿਜ੍ਞਾਪਯ, ਯੀਸ਼ੁਃ ਕਥਾਮੇਤਾਂ ਕਥਯਿਤ੍ਵਾ ਤੰ ਵਿਸਸਰ੍ਜ| ਤਤਃ ਸ ਵ੍ਰਜਿਤ੍ਵਾ ਯੀਸ਼ੁਸ੍ਤਦਰ੍ਥੰ ਯਨ੍ਮਹਾਕਰ੍ੰਮ ਚਕਾਰ ਤਤ੍ ਪੁਰਸ੍ਯ ਸਰ੍ੱਵਤ੍ਰ ਪ੍ਰਕਾਸ਼ਯਿਤੁੰ ਪ੍ਰਾਰੇਭੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","ਅਥ ਯੀਸ਼ੌ ਪਰਾਵ੍ਰੁʼਤ੍ਯਾਗਤੇ ਲੋਕਾਸ੍ਤੰ ਆਦਰੇਣ ਜਗ੍ਰੁʼਹੁ ਰ੍ਯਸ੍ਮਾੱਤੇ ਸਰ੍ੱਵੇ ਤਮਪੇਕ੍ਸ਼਼ਾਞ੍ਚਕ੍ਰਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","ਤਦਨਨ੍ਤਰੰ ਯਾਯੀਰ੍ਨਾਮ੍ਨੋ ਭਜਨਗੇਹਸ੍ਯੈਕੋਧਿਪ ਆਗਤ੍ਯ ਯੀਸ਼ੋਸ਼੍ਚਰਣਯੋਃ ਪਤਿਤ੍ਵਾ ਸ੍ਵਨਿਵੇਸ਼ਨਾਗਮਨਾਰ੍ਥੰ ਤਸ੍ਮਿਨ੍ ਵਿਨਯੰ ਚਕਾਰ, ");
INSERT INTO sanpun_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ਯਤਸ੍ਤਸ੍ਯ ਦ੍ਵਾਦਸ਼ਵਰ੍ਸ਼਼ਵਯਸ੍ਕਾ ਕਨ੍ਯੈਕਾਸੀਤ੍ ਸਾ ਮ੍ਰੁʼਤਕਲ੍ਪਾਭਵਤ੍| ਤਤਸ੍ਤਸ੍ਯ ਗਮਨਕਾਲੇ ਮਾਰ੍ਗੇ ਲੋਕਾਨਾਂ ਮਹਾਨ੍ ਸਮਾਗਮੋ ਬਭੂਵ| ");
INSERT INTO sanpun_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ਦ੍ਵਾਦਸ਼ਵਰ੍ਸ਼਼ਾਣਿ ਪ੍ਰਦਰਰੋਗਗ੍ਰਸ੍ਤਾ ਨਾਨਾ ਵੈਦ੍ਯੈਸ਼੍ਚਿਕਿਤ੍ਸਿਤਾ ਸਰ੍ੱਵਸ੍ਵੰ ਵ੍ਯਯਿਤ੍ਵਾਪਿ ਸ੍ਵਾਸ੍ਥ੍ਯੰ ਨ ਪ੍ਰਾਪ੍ਤਾ ਯਾ ਯੋਸ਼਼ਿਤ੍ ਸਾ ਯੀਸ਼ੋਃ ਪਸ਼੍ਚਾਦਾਗਤ੍ਯ ਤਸ੍ਯ ਵਸ੍ਤ੍ਰਗ੍ਰਨ੍ਥਿੰ ਪਸ੍ਪਰ੍ਸ਼| ");
INSERT INTO sanpun_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ਤਸ੍ਮਾਤ੍ ਤਤ੍ਕ੍ਸ਼਼ਣਾਤ੍ ਤਸ੍ਯਾ ਰਕ੍ਤਸ੍ਰਾਵੋ ਰੁੱਧਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ਤਦਾਨੀਂ ਯੀਸ਼ੁਰਵਦਤ੍ ਕੇਨਾਹੰ ਸ੍ਪ੍ਰੁʼਸ਼਼੍ਟਃ? ਤਤੋ(ਅ)ਨੇਕੈਰਨਙ੍ਗੀਕ੍ਰੁʼਤੇ ਪਿਤਰਸ੍ਤਸ੍ਯ ਸਙ੍ਗਿਨਸ਼੍ਚਾਵਦਨ੍, ਹੇ ਗੁਰੋ ਲੋਕਾ ਨਿਕਟਸ੍ਥਾਃ ਸਨ੍ਤਸ੍ਤਵ ਦੇਹੇ ਘਰ੍ਸ਼਼ਯਨ੍ਤਿ, ਤਥਾਪਿ ਕੇਨਾਹੰ ਸ੍ਪ੍ਰੁʼਸ਼਼੍ਟਇਤਿ ਭਵਾਨ੍ ਕੁਤਃ ਪ੍ਰੁʼੱਛਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","ਯੀਸ਼ੁਃ ਕਥਯਾਮਾਸ, ਕੇਨਾਪ੍ਯਹੰ ਸ੍ਪ੍ਰੁʼਸ਼਼੍ਟੋ, ਯਤੋ ਮੱਤਃ ਸ਼ਕ੍ਤਿ ਰ੍ਨਿਰ੍ਗਤੇਤਿ ਮਯਾ ਨਿਸ਼੍ਚਿਤਮਜ੍ਞਾਯਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ਤਦਾ ਸਾ ਨਾਰੀ ਸ੍ਵਯੰ ਨ ਗੁਪ੍ਤੇਤਿ ਵਿਦਿਤ੍ਵਾ ਕਮ੍ਪਮਾਨਾ ਸਤੀ ਤਸ੍ਯ ਸੰਮੁਖੇ ਪਪਾਤ; ਯੇਨ ਨਿਮਿੱਤੇਨ ਤੰ ਪਸ੍ਪਰ੍ਸ਼ ਸ੍ਪਰ੍ਸ਼ਮਾਤ੍ਰਾੱਚ ਯੇਨ ਪ੍ਰਕਾਰੇਣ ਸ੍ਵਸ੍ਥਾਭਵਤ੍ ਤਤ੍ ਸਰ੍ੱਵੰ ਤਸ੍ਯ ਸਾਕ੍ਸ਼਼ਾਦਾਚਖ੍ਯੌ| ");
INSERT INTO sanpun_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ਤਤਃ ਸ ਤਾਂ ਜਗਾਦ ਹੇ ਕਨ੍ਯੇ ਸੁਸ੍ਥਿਰਾ ਭਵ, ਤਵ ਵਿਸ਼੍ਵਾਸਸ੍ਤ੍ਵਾਂ ਸ੍ਵਸ੍ਥਾਮ੍ ਅਕਾਰ੍ਸ਼਼ੀਤ੍ ਤ੍ਵੰ ਕ੍ਸ਼਼ੇਮੇਣ ਯਾਹਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","ਯੀਸ਼ੋਰੇਤਦ੍ਵਾਕ੍ਯਵਦਨਕਾਲੇ ਤਸ੍ਯਾਧਿਪਤੇ ਰ੍ਨਿਵੇਸ਼ਨਾਤ੍ ਕਸ਼੍ਚਿੱਲੋਕ ਆਗਤ੍ਯ ਤੰ ਬਭਾਸ਼਼ੇ, ਤਵ ਕਨ੍ਯਾ ਮ੍ਰੁʼਤਾ ਗੁਰੁੰ ਮਾ ਕ੍ਲਿਸ਼ਾਨ| ");
INSERT INTO sanpun_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","ਕਿਨ੍ਤੁ ਯੀਸ਼ੁਸ੍ਤਦਾਕਰ੍ਣ੍ਯਾਧਿਪਤਿੰ ਵ੍ਯਾਜਹਾਰ, ਮਾ ਭੈਸ਼਼ੀਃ ਕੇਵਲੰ ਵਿਸ਼੍ਵਸਿਹਿ ਤਸ੍ਮਾਤ੍ ਸਾ ਜੀਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ਅਥ ਤਸ੍ਯ ਨਿਵੇਸ਼ਨੇ ਪ੍ਰਾਪ੍ਤੇ ਸ ਪਿਤਰੰ ਯੋਹਨੰ ਯਾਕੂਬਞ੍ਚ ਕਨ੍ਯਾਯਾ ਮਾਤਰੰ ਪਿਤਰਞ੍ਚ ਵਿਨਾ, ਅਨ੍ਯੰ ਕਞ੍ਚਨ ਪ੍ਰਵੇਸ਼਼੍ਟੁੰ ਵਾਰਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","ਅਪਰਞ੍ਚ ਯੇ ਰੁਦਨ੍ਤਿ ਵਿਲਪਨ੍ਤਿ ਚ ਤਾਨ੍ ਸਰ੍ੱਵਾਨ੍ ਜਨਾਨ੍ ਉਵਾਚ, ਯੂਯੰ ਮਾ ਰੋਦਿਸ਼਼੍ਟ ਕਨ੍ਯਾ ਨ ਮ੍ਰੁʼਤਾ ਨਿਦ੍ਰਾਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","ਕਿਨ੍ਤੁ ਸਾ ਨਿਸ਼੍ਚਿਤੰ ਮ੍ਰੁʼਤੇਤਿ ਜ੍ਞਾਤ੍ਵਾ ਤੇ ਤਮੁਪਜਹਸੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","ਪਸ਼੍ਚਾਤ੍ ਸ ਸਰ੍ੱਵਾਨ੍ ਬਹਿਃ ਕ੍ਰੁʼਤ੍ਵਾ ਕਨ੍ਯਾਯਾਃ ਕਰੌ ਧ੍ਰੁʼਤ੍ਵਾਜੁਹੁਵੇ, ਹੇ ਕਨ੍ਯੇ ਤ੍ਵਮੁੱਤਿਸ਼਼੍ਠ, ");
INSERT INTO sanpun_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ਤਸ੍ਮਾਤ੍ ਤਸ੍ਯਾਃ ਪ੍ਰਾਣੇਸ਼਼ੁ ਪੁਨਰਾਗਤੇਸ਼਼ੁ ਸਾ ਤਤ੍ਕ੍ਸ਼਼ਣਾਦ੍ ਉੱਤਸ੍ਯੌ| ਤਦਾਨੀਂ ਤਸ੍ਯੈ ਕਿਞ੍ਚਿਦ੍ ਭਕ੍ਸ਼਼੍ਯੰ ਦਾਤੁਮ੍ ਆਦਿਦੇਸ਼| ");
INSERT INTO sanpun_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ਤਤਸ੍ਤਸ੍ਯਾਃ ਪਿਤਰੌ ਵਿਸ੍ਮਯੰ ਗਤੌ ਕਿਨ੍ਤੁ ਸ ਤਾਵਾਦਿਦੇਸ਼ ਘਟਨਾਯਾ ਏਤਸ੍ਯਾਃ ਕਥਾਂ ਕਸ੍ਮੈਚਿਦਪਿ ਮਾ ਕਥਯਤੰ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","ਤਤਃ ਪਰੰ ਸ ਦ੍ਵਾਦਸ਼ਸ਼ਿਸ਼਼੍ਯਾਨਾਹੂਯ ਭੂਤਾਨ੍ ਤ੍ਯਾਜਯਿਤੁੰ ਰੋਗਾਨ੍ ਪ੍ਰਤਿਕਰ੍ੱਤੁਞ੍ਚ ਤੇਭ੍ਯਃ ਸ਼ਕ੍ਤਿਮਾਧਿਪਤ੍ਯਞ੍ਚ ਦਦੌ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ਅਪਰਞ੍ਚ ਈਸ਼੍ਵਰੀਯਰਾਜ੍ਯਸ੍ਯ ਸੁਸੰਵਾਦੰ ਪ੍ਰਕਾਸ਼ਯਿਤੁਮ੍ ਰੋਗਿਣਾਮਾਰੋਗ੍ਯੰ ਕਰ੍ੱਤੁਞ੍ਚ ਪ੍ਰੇਰਣਕਾਲੇ ਤਾਨ੍ ਜਗਾਦ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ਯਾਤ੍ਰਾਰ੍ਥੰ ਯਸ਼਼੍ਟਿ ਰ੍ਵਸ੍ਤ੍ਰਪੁਟਕੰ ਭਕ੍ਸ਼਼੍ਯੰ ਮੁਦ੍ਰਾ ਦ੍ਵਿਤੀਯਵਸ੍ਤ੍ਰਮ੍, ਏਸ਼਼ਾਂ ਕਿਮਪਿ ਮਾ ਗ੍ਰੁʼਹ੍ਲੀਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ਯੂਯਞ੍ਚ ਯੰਨਿਵੇਸ਼ਨੰ ਪ੍ਰਵਿਸ਼ਥ ਨਗਰਤ੍ਯਾਗਪਰ੍ੱਯਨਤੰ ਤੰਨਿਵੇਸ਼ਨੇ ਤਿਸ਼਼੍ਠਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","ਤਤ੍ਰ ਯਦਿ ਕਸ੍ਯਚਿਤ੍ ਪੁਰਸ੍ਯ ਲੋਕਾ ਯੁਸ਼਼੍ਮਾਕਮਾਤਿਥ੍ਯੰ ਨ ਕੁਰ੍ੱਵਨ੍ਤਿ ਤਰ੍ਹਿ ਤਸ੍ਮਾੰਨਗਰਾਦ੍ ਗਮਨਕਾਲੇ ਤੇਸ਼਼ਾਂ ਵਿਰੁੱਧੰ ਸਾਕ੍ਸ਼਼੍ਯਾਰ੍ਥੰ ਯੁਸ਼਼੍ਮਾਕੰ ਪਦਧੂਲੀਃ ਸਮ੍ਪਾਤਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","ਅਥ ਤੇ ਪ੍ਰਸ੍ਥਾਯ ਸਰ੍ੱਵਤ੍ਰ ਸੁਸੰਵਾਦੰ ਪ੍ਰਚਾਰਯਿਤੁੰ ਪੀਡਿਤਾਨ੍ ਸ੍ਵਸ੍ਥਾਨ੍ ਕਰ੍ੱਤੁਞ੍ਚ ਗ੍ਰਾਮੇਸ਼਼ੁ ਭ੍ਰਮਿਤੁੰ ਪ੍ਰਾਰੇਭਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ਏਤਰ੍ਹਿ ਹੇਰੋਦ੍ ਰਾਜਾ ਯੀਸ਼ੋਃ ਸਰ੍ੱਵਕਰ੍ੰਮਣਾਂ ਵਾਰ੍ੱਤਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਭ੍ਰੁʼਸ਼ਮੁਦ੍ਵਿਵਿਜੇ ");
INSERT INTO sanpun_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ਯਤਃ ਕੇਚਿਦੂਚੁਰ੍ਯੋਹਨ੍ ਸ਼੍ਮਸ਼ਾਨਾਦੁਦਤਿਸ਼਼੍ਠਤ੍| ਕੇਚਿਦੂਚੁਃ, ਏਲਿਯੋ ਦਰ੍ਸ਼ਨੰ ਦੱਤਵਾਨ੍; ਏਵਮਨ੍ਯਲੋਕਾ ਊਚੁਃ ਪੂਰ੍ੱਵੀਯਃ ਕਸ਼੍ਚਿਦ੍ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦੀ ਸਮੁੱਥਿਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","ਕਿਨ੍ਤੁ ਹੇਰੋਦੁਵਾਚ ਯੋਹਨਃ ਸ਼ਿਰੋ(ਅ)ਹਮਛਿਨਦਮ੍ ਇਦਾਨੀਂ ਯਸ੍ਯੇਦ੍ਰੁʼੱਕਰ੍ੰਮਣਾਂ ਵਾਰ੍ੱਤਾਂ ਪ੍ਰਾਪ੍ਨੋਮਿ ਸ ਕਃ? ਅਥ ਸ ਤੰ ਦ੍ਰਸ਼਼੍ਟੁਮ੍ ਐੱਛਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","ਅਨਨ੍ਤਰੰ ਪ੍ਰੇਰਿਤਾਃ ਪ੍ਰਤ੍ਯਾਗਤ੍ਯ ਯਾਨਿ ਯਾਨਿ ਕਰ੍ੰਮਾਣਿ ਚਕ੍ਰੁਸ੍ਤਾਨਿ ਯੀਸ਼ਵੇ ਕਥਯਾਮਾਸੁਃ ਤਤਃ ਸ ਤਾਨ੍ ਬੈਤ੍ਸੈਦਾਨਾਮਕਨਗਰਸ੍ਯ ਵਿਜਨੰ ਸ੍ਥਾਨੰ ਨੀਤ੍ਵਾ ਗੁਪ੍ਤੰ ਜਗਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ਪਸ਼੍ਚਾਲ੍ ਲੋਕਾਸ੍ਤਦ੍ ਵਿਦਿਤ੍ਵਾ ਤਸ੍ਯ ਪਸ਼੍ਚਾਦ੍ ਯਯੁਃ; ਤਤਃ ਸ ਤਾਨ੍ ਨਯਨ੍ ਈਸ਼੍ਵਰੀਯਰਾਜ੍ਯਸ੍ਯ ਪ੍ਰਸਙ੍ਗਮੁਕ੍ਤਵਾਨ੍, ਯੇਸ਼਼ਾਂ ਚਿਕਿਤ੍ਸਯਾ ਪ੍ਰਯੋਜਨਮ੍ ਆਸੀਤ੍ ਤਾਨ੍ ਸ੍ਵਸ੍ਥਾਨ੍ ਚਕਾਰ ਚ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ਅਪਰਞ੍ਚ ਦਿਵਾਵਸੰਨੇ ਸਤਿ ਦ੍ਵਾਦਸ਼ਸ਼ਿਸ਼਼੍ਯਾ ਯੀਸ਼ੋਰਨ੍ਤਿਕਮ੍ ਏਤ੍ਯ ਕਥਯਾਮਾਸੁਃ, ਵਯਮਤ੍ਰ ਪ੍ਰਾਨ੍ਤਰਸ੍ਥਾਨੇ ਤਿਸ਼਼੍ਠਾਮਃ, ਤਤੋ ਨਗਰਾਣਿ ਗ੍ਰਾਮਾਣਿ ਗਤ੍ਵਾ ਵਾਸਸ੍ਥਾਨਾਨਿ ਪ੍ਰਾਪ੍ਯ ਭਕ੍ਸ਼਼੍ਯਦ੍ਰਵ੍ਯਾਣਿ ਕ੍ਰੇਤੁੰ ਜਨਨਿਵਹੰ ਭਵਾਨ੍ ਵਿਸ੍ਰੁʼਜਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","ਤਦਾ ਸ ਉਵਾਚ, ਯੂਯਮੇਵ ਤਾਨ੍ ਭੇਜਯਧ੍ਵੰ; ਤਤਸ੍ਤੇ ਪ੍ਰੋਚੁਰਸ੍ਮਾਕੰ ਨਿਕਟੇ ਕੇਵਲੰ ਪਞ੍ਚ ਪੂਪਾ ਦ੍ਵੌ ਮਤ੍ਸ੍ਯੌ ਚ ਵਿਦ੍ਯਨ੍ਤੇ, ਅਤਏਵ ਸ੍ਥਾਨਾਨ੍ਤਰਮ੍ ਇਤ੍ਵਾ ਨਿਮਿੱਤਮੇਤੇਸ਼਼ਾਂ ਭਕ੍ਸ਼਼੍ਯਦ੍ਰਵ੍ਯੇਸ਼਼ੁ ਨ ਕ੍ਰੀਤੇਸ਼਼ੁ ਨ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","ਤਤ੍ਰ ਪ੍ਰਾਯੇਣ ਪਞ੍ਚਸਹਸ੍ਰਾਣਿ ਪੁਰੁਸ਼਼ਾ ਆਸਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","ਤਦਾ ਸ ਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਜਗਾਦ ਪਞ੍ਚਾਸ਼ਤ੍ ਪਞ੍ਚਾਸ਼ੱਜਨੈਃ ਪੰਕ੍ਤੀਕ੍ਰੁʼਤ੍ਯ ਤਾਨੁਪਵੇਸ਼ਯਤ, ਤਸ੍ਮਾਤ੍ ਤੇ ਤਦਨੁਸਾਰੇਣ ਸਰ੍ੱਵਲੋਕਾਨੁਪਵੇਸ਼ਯਾਪਾਸੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ਤਤਃ ਸ ਤਾਨ੍ ਪਞ੍ਚ ਪੂਪਾਨ੍ ਮੀਨਦ੍ਵਯਞ੍ਚ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਸ੍ਵਰ੍ਗੰ ਵਿਲੋਕ੍ਯੇਸ਼੍ਵਰਗੁਣਾਨ੍ ਕੀਰ੍ੱਤਯਾਞ੍ਚਕ੍ਰੇ ਭਙ੍ਕ੍ਤਾ ਚ ਲੋਕੇਭ੍ਯਃ ਪਰਿਵੇਸ਼਼ਣਾਰ੍ਥੰ ਸ਼ਿਸ਼਼੍ਯੇਸ਼਼ੁ ਸਮਰ੍ਪਯਾਮ੍ਬਭੂਵ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ਤਤਃ ਸਰ੍ੱਵੇ ਭੁਕ੍ਤ੍ਵਾ ਤ੍ਰੁʼਪ੍ਤਿੰ ਗਤਾ ਅਵਸ਼ਿਸ਼਼੍ਟਾਨਾਞ੍ਚ ਦ੍ਵਾਦਸ਼ ਡੱਲਕਾਨ੍ ਸੰਜਗ੍ਰੁʼਹੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","ਅਥੈਕਦਾ ਨਿਰ੍ਜਨੇ ਸ਼ਿਸ਼਼੍ਯੈਃ ਸਹ ਪ੍ਰਾਰ੍ਥਨਾਕਾਲੇ ਤਾਨ੍ ਪਪ੍ਰੱਛ, ਲੋਕਾ ਮਾਂ ਕੰ ਵਦਨ੍ਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","ਤਤਸ੍ਤੇ ਪ੍ਰਾਚੁਃ, ਤ੍ਵਾਂ ਯੋਹਨ੍ਮੱਜਕੰ ਵਦਨ੍ਤਿ; ਕੇਚਿਤ੍ ਤ੍ਵਾਮ੍ ਏਲਿਯੰ ਵਦਨ੍ਤਿ, ਪੂਰ੍ੱਵਕਾਲਿਕਃ ਕਸ਼੍ਚਿਦ੍ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦੀ ਸ਼੍ਮਸ਼ਾਨਾਦ੍ ਉਦਤਿਸ਼਼੍ਠਦ੍ ਇਤ੍ਯਪਿ ਕੇਚਿਦ੍ ਵਦਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ਤਦਾ ਸ ਉਵਾਚ, ਯੂਯੰ ਮਾਂ ਕੰ ਵਦਥ? ਤਤਃ ਪਿਤਰ ਉਕ੍ਤਵਾਨ੍ ਤ੍ਵਮ੍ ਈਸ਼੍ਵਰਾਭਿਸ਼਼ਿਕ੍ਤਃ ਪੁਰੁਸ਼਼ਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","ਤਦਾ ਸ ਤਾਨ੍ ਦ੍ਰੁʼਢਮਾਦਿਦੇਸ਼, ਕਥਾਮੇਤਾਂ ਕਸ੍ਮੈਚਿਦਪਿ ਮਾ ਕਥਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ਸ ਪੁਨਰੁਵਾਚ, ਮਨੁਸ਼਼੍ਯਪੁਤ੍ਰੇਣ ਵਹੁਯਾਤਨਾ ਭੋਕ੍ਤਵ੍ਯਾਃ ਪ੍ਰਾਚੀਨਲੋਕੈਃ ਪ੍ਰਧਾਨਯਾਜਕੈਰਧ੍ਯਾਪਕੈਸ਼੍ਚ ਸੋਵਜ੍ਞਾਯ ਹਨ੍ਤਵ੍ਯਃ ਕਿਨ੍ਤੁ ਤ੍ਰੁʼਤੀਯਦਿਵਸੇ ਸ਼੍ਮਸ਼ਾਨਾਤ੍ ਤੇਨੋੱਥਾਤਵ੍ਯਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ਅਪਰੰ ਸ ਸਰ੍ੱਵਾਨੁਵਾਚ, ਕਸ਼੍ਚਿਦ੍ ਯਦਿ ਮਮ ਪਸ਼੍ਚਾਦ੍ ਗਨ੍ਤੁੰ ਵਾਞ੍ਛਤਿ ਤਰ੍ਹਿ ਸ ਸ੍ਵੰ ਦਾਮ੍ਯਤੁ, ਦਿਨੇ ਦਿਨੇ ਕ੍ਰੁਸ਼ੰ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਚ ਮਮ ਪਸ਼੍ਚਾਦਾਗੱਛਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ਯਤੋ ਯਃ ਕਸ਼੍ਚਿਤ੍ ਸ੍ਵਪ੍ਰਾਣਾਨ੍ ਰਿਰਕ੍ਸ਼਼ਿਸ਼਼ਤਿ ਸ ਤਾਨ੍ ਹਾਰਯਿਸ਼਼੍ਯਤਿ, ਯਃ ਕਸ਼੍ਚਿਨ੍ ਮਦਰ੍ਥੰ ਪ੍ਰਾਣਾਨ੍ ਹਾਰਯਿਸ਼਼੍ਯਤਿ ਸ ਤਾਨ੍ ਰਕ੍ਸ਼਼ਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","ਕਸ਼੍ਚਿਦ੍ ਯਦਿ ਸਰ੍ੱਵੰ ਜਗਤ੍ ਪ੍ਰਾਪ੍ਨੋਤਿ ਕਿਨ੍ਤੁ ਸ੍ਵਪ੍ਰਾਣਾਨ੍ ਹਾਰਯਤਿ ਸ੍ਵਯੰ ਵਿਨਸ਼੍ਯਤਿ ਚ ਤਰ੍ਹਿ ਤਸ੍ਯ ਕੋ ਲਾਭਃ? ");
INSERT INTO sanpun_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","ਪੁਨ ਰ੍ਯਃ ਕਸ਼੍ਚਿਨ੍ ਮਾਂ ਮਮ ਵਾਕ੍ਯੰ ਵਾ ਲੱਜਾਸ੍ਪਦੰ ਜਾਨਾਤਿ ਮਨੁਸ਼਼੍ਯਪੁਤ੍ਰੋ ਯਦਾ ਸ੍ਵਸ੍ਯ ਪਿਤੁਸ਼੍ਚ ਪਵਿਤ੍ਰਾਣਾਂ ਦੂਤਾਨਾਞ੍ਚ ਤੇਜੋਭਿਃ ਪਰਿਵੇਸ਼਼੍ਟਿਤ ਆਗਮਿਸ਼਼੍ਯਤਿ ਤਦਾ ਸੋਪਿ ਤੰ ਲੱਜਾਸ੍ਪਦੰ ਜ੍ਞਾਸ੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","ਕਿਨ੍ਤੁ ਯੁਸ਼਼੍ਮਾਨਹੰ ਯਥਾਰ੍ਥੰ ਵਦਾਮਿ, ਈਸ਼੍ਵਰੀਯਰਾਜਤ੍ਵੰ ਨ ਦ੍ਰੁʼਸ਼਼੍ਟਵਾ ਮ੍ਰੁʼਤ੍ਯੁੰ ਨਾਸ੍ਵਾਦਿਸ਼਼੍ਯਨ੍ਤੇ, ਏਤਾਦ੍ਰੁʼਸ਼ਾਃ ਕਿਯਨ੍ਤੋ ਲੋਕਾ ਅਤ੍ਰ ਸ੍ਥਨੇ(ਅ)ਪਿ ਦਣ੍ਡਾਯਮਾਨਾਃ ਸਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ਏਤਦਾਖ੍ਯਾਨਕਥਨਾਤ੍ ਪਰੰ ਪ੍ਰਾਯੇਣਾਸ਼਼੍ਟਸੁ ਦਿਨੇਸ਼਼ੁ ਗਤੇਸ਼਼ੁ ਸ ਪਿਤਰੰ ਯੋਹਨੰ ਯਾਕੂਬਞ੍ਚ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਪ੍ਰਾਰ੍ਥਯਿਤੁੰ ਪਰ੍ੱਵਤਮੇਕੰ ਸਮਾਰੁਰੋਹ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ਅਥ ਤਸ੍ਯ ਪ੍ਰਾਰ੍ਥਨਕਾਲੇ ਤਸ੍ਯ ਮੁਖਾਕ੍ਰੁʼਤਿਰਨ੍ਯਰੂਪਾ ਜਾਤਾ, ਤਦੀਯੰ ਵਸ੍ਤ੍ਰਮੁੱਜ੍ਵਲਸ਼ੁਕ੍ਲੰ ਜਾਤੰ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","ਅਪਰਞ੍ਚ ਮੂਸਾ ਏਲਿਯਸ਼੍ਚੋਭੌ ਤੇਜਸ੍ਵਿਨੌ ਦ੍ਰੁʼਸ਼਼੍ਟੌ ");
INSERT INTO sanpun_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ਤੌ ਤੇਨ ਯਿਰੂਸ਼ਾਲਮ੍ਪੁਰੇ ਯੋ ਮ੍ਰੁʼਤ੍ਯੁਃ ਸਾਧਿਸ਼਼੍ਯਤੇ ਤਦੀਯਾਂ ਕਥਾਂ ਤੇਨ ਸਾਰ੍ੱਧੰ ਕਥਯਿਤੁਮ੍ ਆਰੇਭਾਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ਤਦਾ ਪਿਤਰਾਦਯਃ ਸ੍ਵਸ੍ਯ ਸਙ੍ਗਿਨੋ ਨਿਦ੍ਰਯਾਕ੍ਰੁʼਸ਼਼੍ਟਾ ਆਸਨ੍ ਕਿਨ੍ਤੁ ਜਾਗਰਿਤ੍ਵਾ ਤਸ੍ਯ ਤੇਜਸ੍ਤੇਨ ਸਾਰ੍ੱਧਮ੍ ਉੱਤਿਸ਼਼੍ਠਨ੍ਤੌ ਜਨੌ ਚ ਦਦ੍ਰੁʼਸ਼ੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","ਅਥ ਤਯੋਰੁਭਯੋ ਰ੍ਗਮਨਕਾਲੇ ਪਿਤਰੋ ਯੀਸ਼ੁੰ ਬਭਾਸ਼਼ੇ, ਹੇ ਗੁਰੋ(ਅ)ਸ੍ਮਾਕੰ ਸ੍ਥਾਨੇ(ਅ)ਸ੍ਮਿਨ੍ ਸ੍ਥਿਤਿਃ ਸ਼ੁਭਾ, ਤਤ ਏਕਾ ਤ੍ਵਦਰ੍ਥਾ, ਏਕਾ ਮੂਸਾਰ੍ਥਾ, ਏਕਾ ਏਲਿਯਾਰ੍ਥਾ, ਇਤਿ ਤਿਸ੍ਰਃ ਕੁਟ੍ਯੋਸ੍ਮਾਭਿ ਰ੍ਨਿਰ੍ੰਮੀਯਨ੍ਤਾਂ, ਇਮਾਂ ਕਥਾਂ ਸ ਨ ਵਿਵਿਚ੍ਯ ਕਥਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","ਅਪਰਞ੍ਚ ਤਦ੍ਵਾਕ੍ਯਵਦਨਕਾਲੇ ਪਯੋਦ ਏਕ ਆਗਤ੍ਯ ਤੇਸ਼਼ਾਮੁਪਰਿ ਛਾਯਾਂ ਚਕਾਰ, ਤਤਸ੍ਤਨ੍ਮਧ੍ਯੇ ਤਯੋਃ ਪ੍ਰਵੇਸ਼ਾਤ੍ ਤੇ ਸ਼ਸ਼ਙ੍ਕਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ਤਦਾ ਤਸ੍ਮਾਤ੍ ਪਯੋਦਾਦ੍ ਇਯਮਾਕਾਸ਼ੀਯਾ ਵਾਣੀ ਨਿਰ੍ਜਗਾਮ, ਮਮਾਯੰ ਪ੍ਰਿਯਃ ਪੁਤ੍ਰ ਏਤਸ੍ਯ ਕਥਾਯਾਂ ਮਨੋ ਨਿਧੱਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ਇਤਿ ਸ਼ਬ੍ਦੇ ਜਾਤੇ ਤੇ ਯੀਸ਼ੁਮੇਕਾਕਿਨੰ ਦਦ੍ਰੁʼਸ਼ੁਃ ਕਿਨ੍ਤੁ ਤੇ ਤਦਾਨੀਂ ਤਸ੍ਯ ਦਰ੍ਸ਼ਨਸ੍ਯ ਵਾਚਮੇਕਾਮਪਿ ਨੋਕ੍ਤ੍ਵਾ ਮਨਃਸੁ ਸ੍ਥਾਪਯਾਮਾਸੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","ਪਰੇ(ਅ)ਹਨਿ ਤੇਸ਼਼ੁ ਤਸ੍ਮਾੱਛੈਲਾਦ੍ ਅਵਰੂਢੇਸ਼਼ੁ ਤੰ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਕਰ੍ੱਤੁੰ ਬਹਵੋ ਲੋਕਾ ਆਜਗ੍ਮੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ਤੇਸ਼਼ਾਂ ਮਧ੍ਯਾਦ੍ ਏਕੋ ਜਨ ਉੱਚੈਰੁਵਾਚ, ਹੇ ਗੁਰੋ ਅਹੰ ਵਿਨਯੰ ਕਰੋਮਿ ਮਮ ਪੁਤ੍ਰੰ ਪ੍ਰਤਿ ਕ੍ਰੁʼਪਾਦ੍ਰੁʼਸ਼਼੍ਟਿੰ ਕਰੋਤੁ, ਮਮ ਸ ਏਵੈਕਃ ਪੁਤ੍ਰਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ਭੂਤੇਨ ਧ੍ਰੁʼਤਃ ਸਨ੍ ਸੰ ਪ੍ਰਸਭੰ ਚੀੱਛਬ੍ਦੰ ਕਰੋਤਿ ਤਨ੍ਮੁਖਾਤ੍ ਫੇਣਾ ਨਿਰ੍ਗੱਛਨ੍ਤਿ ਚ, ਭੂਤ ਇੱਥੰ ਵਿਦਾਰ੍ੱਯ ਕ੍ਲਿਸ਼਼੍ਟ੍ਵਾ ਪ੍ਰਾਯਸ਼ਸ੍ਤੰ ਨ ਤ੍ਯਜਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ਤਸ੍ਮਾਤ੍ ਤੰ ਭੂਤੰ ਤ੍ਯਾਜਯਿਤੁੰ ਤਵ ਸ਼ਿਸ਼਼੍ਯਸਮੀਪੇ ਨ੍ਯਵੇਦਯੰ ਕਿਨ੍ਤੁ ਤੇ ਨ ਸ਼ੇਕੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ਤਦਾ ਯੀਸ਼ੁਰਵਾਦੀਤ੍, ਰੇ ਆਵਿਸ਼੍ਵਾਸਿਨ੍ ਵਿਪਥਗਾਮਿਨ੍ ਵੰਸ਼ ਕਤਿਕਾਲਾਨ੍ ਯੁਸ਼਼੍ਮਾਭਿਃ ਸਹ ਸ੍ਥਾਸ੍ਯਾਮ੍ਯਹੰ ਯੁਸ਼਼੍ਮਾਕਮ੍ ਆਚਰਣਾਨਿ ਚ ਸਹਿਸ਼਼੍ਯੇ? ਤਵ ਪੁਤ੍ਰਮਿਹਾਨਯ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ਤਤਸ੍ਤਸ੍ਮਿੰਨਾਗਤਮਾਤ੍ਰੇ ਭੂਤਸ੍ਤੰ ਭੂਮੌ ਪਾਤਯਿਤ੍ਵਾ ਵਿਦਦਾਰ; ਤਦਾ ਯੀਸ਼ੁਸ੍ਤਮਮੇਧ੍ਯੰ ਭੂਤੰ ਤਰ੍ਜਯਿਤ੍ਵਾ ਬਾਲਕੰ ਸ੍ਵਸ੍ਥੰ ਕ੍ਰੁʼਤ੍ਵਾ ਤਸ੍ਯ ਪਿਤਰਿ ਸਮਰ੍ਪਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ਈਸ਼੍ਵਰਸ੍ਯ ਮਹਾਸ਼ਕ੍ਤਿਮ੍ ਇਮਾਂ ਵਿਲੋਕ੍ਯ ਸਰ੍ੱਵੇ ਚਮੱਚਕ੍ਰੁਃ; ਇੱਥੰ ਯੀਸ਼ੋਃ ਸਰ੍ੱਵਾਭਿਃ ਕ੍ਰਿਯਾਭਿਃ ਸਰ੍ੱਵੈਰ੍ਲੋਕੈਰਾਸ਼੍ਚਰ੍ੱਯੇ ਮਨ੍ਯਮਾਨੇ ਸਤਿ ਸ ਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਬਭਾਸ਼਼ੇ, ");
INSERT INTO sanpun_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","ਕਥੇਯੰ ਯੁਸ਼਼੍ਮਾਕੰ ਕਰ੍ਣੇਸ਼਼ੁ ਪ੍ਰਵਿਸ਼ਤੁ, ਮਨੁਸ਼਼੍ਯਪੁਤ੍ਰੋ ਮਨੁਸ਼਼੍ਯਾਣਾਂ ਕਰੇਸ਼਼ੁ ਸਮਰ੍ਪਯਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","ਕਿਨ੍ਤੁ ਤੇ ਤਾਂ ਕਥਾਂ ਨ ਬੁਬੁਧਿਰੇ, ਸ੍ਪਸ਼਼੍ਟਤ੍ਵਾਭਾਵਾਤ੍ ਤਸ੍ਯਾ ਅਭਿਪ੍ਰਾਯਸ੍ਤੇਸ਼਼ਾਂ ਬੋਧਗਮ੍ਯੋ ਨ ਬਭੂਵ; ਤਸ੍ਯਾ ਆਸ਼ਯਃ ਕ ਇਤ੍ਯਪਿ ਤੇ ਭਯਾਤ੍ ਪ੍ਰਸ਼਼੍ਟੁੰ ਨ ਸ਼ੇਕੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","ਤਦਨਨ੍ਤਰੰ ਤੇਸ਼਼ਾਂ ਮਧ੍ਯੇ ਕਃ ਸ਼੍ਰੇਸ਼਼੍ਠਃ ਕਥਾਮੇਤਾਂ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਤੇ ਮਿਥੋ ਵਿਵਾਦੰ ਚਕ੍ਰੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ਤਤੋ ਯੀਸ਼ੁਸ੍ਤੇਸ਼਼ਾਂ ਮਨੋਭਿਪ੍ਰਾਯੰ ਵਿਦਿਤ੍ਵਾ ਬਾਲਕਮੇਕੰ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਸ੍ਵਸ੍ਯ ਨਿਕਟੇ ਸ੍ਥਾਪਯਿਤ੍ਵਾ ਤਾਨ੍ ਜਗਾਦ, ");
INSERT INTO sanpun_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ਯੋ ਜਨੋ ਮਮ ਨਾਮ੍ਨਾਸ੍ਯ ਬਾਲਾਸ੍ਯਾਤਿਥ੍ਯੰ ਵਿਦਧਾਤਿ ਸ ਮਮਾਤਿਥ੍ਯੰ ਵਿਦਧਾਤਿ, ਯਸ਼੍ਚ ਮਮਾਤਿਥ੍ਯੰ ਵਿਦਧਾਤਿ ਸ ਮਮ ਪ੍ਰੇਰਕਸ੍ਯਾਤਿਥ੍ਯੰ ਵਿਦਧਾਤਿ, ਯੁਸ਼਼੍ਮਾਕੰ ਮਧ੍ਯੇਯਃ ਸ੍ਵੰ ਸਰ੍ੱਵਸ੍ਮਾਤ੍ ਕ੍ਸ਼਼ੁਦ੍ਰੰ ਜਾਨੀਤੇ ਸ ਏਵ ਸ਼੍ਰੇਸ਼਼੍ਠੋ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","ਅਪਰਞ੍ਚ ਯੋਹਨ੍ ਵ੍ਯਾਜਹਾਰ ਹੇ ਪ੍ਰਭੇा ਤਵ ਨਾਮ੍ਨਾ ਭੂਤਾਨ੍ ਤ੍ਯਾਜਯਨ੍ਤੰ ਮਾਨੁਸ਼਼ਮ੍ ਏਕੰ ਦ੍ਰੁʼਸ਼਼੍ਟਵਨ੍ਤੋ ਵਯੰ, ਕਿਨ੍ਤ੍ਵਸ੍ਮਾਕਮ੍ ਅਪਸ਼੍ਚਾਦ੍ ਗਾਮਿਤ੍ਵਾਤ੍ ਤੰ ਨ੍ਯਸ਼਼ੇਧਾਮ੍| ਤਦਾਨੀਂ ਯੀਸ਼ੁਰੁਵਾਚ, ");
INSERT INTO sanpun_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","ਤੰ ਮਾ ਨਿਸ਼਼ੇਧਤ, ਯਤੋ ਯੋ ਜਨੋਸ੍ਮਾਕੰ ਨ ਵਿਪਕ੍ਸ਼਼ਃ ਸ ਏਵਾਸ੍ਮਾਕੰ ਸਪਕ੍ਸ਼਼ੋ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","ਅਨਨ੍ਤਰੰ ਤਸ੍ਯਾਰੋਹਣਸਮਯ ਉਪਸ੍ਥਿਤੇ ਸ ਸ੍ਥਿਰਚੇਤਾ ਯਿਰੂਸ਼ਾਲਮੰ ਪ੍ਰਤਿ ਯਾਤ੍ਰਾਂ ਕਰ੍ੱਤੁੰ ਨਿਸ਼੍ਚਿਤ੍ਯਾਗ੍ਰੇ ਦੂਤਾਨ੍ ਪ੍ਰੇਸ਼਼ਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ਤਸ੍ਮਾਤ੍ ਤੇ ਗਤ੍ਵਾ ਤਸ੍ਯ ਪ੍ਰਯੋਜਨੀਯਦ੍ਰਵ੍ਯਾਣਿ ਸੰਗ੍ਰਹੀਤੁੰ ਸ਼ੋਮਿਰੋਣੀਯਾਨਾਂ ਗ੍ਰਾਮੰ ਪ੍ਰਵਿਵਿਸ਼ੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ਕਿਨ੍ਤੁ ਸ ਯਿਰੂਸ਼ਾਲਮੰ ਨਗਰੰ ਯਾਤਿ ਤਤੋ ਹੇਤੋ ਰ੍ਲੋਕਾਸ੍ਤਸ੍ਯਾਤਿਥ੍ਯੰ ਨ ਚਕ੍ਰੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ਅਤਏਵ ਯਾਕੂਬ੍ਯੋਹਨੌ ਤਸ੍ਯ ਸ਼ਿਸ਼਼੍ਯੌ ਤਦ੍ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਜਗਦਤੁਃ, ਹੇ ਪ੍ਰਭੋ ਏਲਿਯੋ ਯਥਾ ਚਕਾਰ ਤਥਾ ਵਯਮਪਿ ਕਿੰ ਗਗਣਾਦ੍ ਆਗਨ੍ਤੁਮ੍ ਏਤਾਨ੍ ਭਸ੍ਮੀਕਰ੍ੱਤੁਞ੍ਚ ਵਹ੍ਨਿਮਾਜ੍ਞਾਪਯਾਮਃ? ਭਵਾਨ੍ ਕਿਮਿੱਛਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","ਕਿਨ੍ਤੁ ਸ ਮੁਖੰ ਪਰਾਵਰ੍ਤ੍ਯ ਤਾਨ੍ ਤਰ੍ਜਯਿਤ੍ਵਾ ਗਦਿਤਵਾਨ੍ ਯੁਸ਼਼੍ਮਾਕੰ ਮਨੋਭਾਵਃ ਕਃ, ਇਤਿ ਯੂਯੰ ਨ ਜਾਨੀਥ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ਮਨੁਜਸੁਤੋ ਮਨੁਜਾਨਾਂ ਪ੍ਰਾਣਾਨ੍ ਨਾਸ਼ਯਿਤੁੰ ਨਾਗੱਛਤ੍, ਕਿਨ੍ਤੁ ਰਕ੍ਸ਼਼ਿਤੁਮ੍ ਆਗੱਛਤ੍| ਪਸ਼੍ਚਾਦ੍ ਇਤਰਗ੍ਰਾਮੰ ਤੇ ਯਯੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","ਤਦਨਨ੍ਤਰੰ ਪਥਿ ਗਮਨਕਾਲੇ ਜਨ ਏਕਸ੍ਤੰ ਬਭਾਸ਼਼ੇ, ਹੇ ਪ੍ਰਭੋ ਭਵਾਨ੍ ਯਤ੍ਰ ਯਾਤਿ ਭਵਤਾ ਸਹਾਹਮਪਿ ਤਤ੍ਰ ਯਾਸ੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ਤਦਾਨੀਂ ਯੀਸ਼ੁਸ੍ਤਮੁਵਾਚ, ਗੋਮਾਯੂਨਾਂ ਗਰ੍ੱਤਾ ਆਸਤੇ, ਵਿਹਾਯਸੀਯਵਿਹਗਾाਨਾਂ ਨੀਡਾਨਿ ਚ ਸਨ੍ਤਿ, ਕਿਨ੍ਤੁ ਮਾਨਵਤਨਯਸ੍ਯ ਸ਼ਿਰਃ ਸ੍ਥਾਪਯਿਤੁੰ ਸ੍ਥਾਨੰ ਨਾਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ਤਤਃ ਪਰੰ ਸ ਇਤਰਜਨੰ ਜਗਾਦ, ਤ੍ਵੰ ਮਮ ਪਸ਼੍ਚਾਦ੍ ਏਹਿ; ਤਤਃ ਸ ਉਵਾਚ, ਹੇ ਪ੍ਰਭੋ ਪੂਰ੍ੱਵੰ ਪਿਤਰੰ ਸ਼੍ਮਸ਼ਾਨੇ ਸ੍ਥਾਪਯਿਤੁੰ ਮਾਮਾਦਿਸ਼ਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ਤਦਾ ਯੀਸ਼ੁਰੁਵਾਚ, ਮ੍ਰੁʼਤਾ ਮ੍ਰੁʼਤਾਨ੍ ਸ਼੍ਮਸ਼ਾਨੇ ਸ੍ਥਾਪਯਨ੍ਤੁ ਕਿਨ੍ਤੁ ਤ੍ਵੰ ਗਤ੍ਵੇਸ਼੍ਵਰੀਯਰਾਜ੍ਯਸ੍ਯ ਕਥਾਂ ਪ੍ਰਚਾਰਯ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ਤਤੋਨ੍ਯਃ ਕਥਯਾਮਾਸ, ਹੇ ਪ੍ਰਭੋ ਮਯਾਪਿ ਭਵਤਃ ਪਸ਼੍ਚਾਦ੍ ਗੰਸ੍ਯਤੇ, ਕਿਨ੍ਤੁ ਪੂਰ੍ੱਵੰ ਮਮ ਨਿਵੇਸ਼ਨਸ੍ਯ ਪਰਿਜਨਾਨਾਮ੍ ਅਨੁਮਤਿੰ ਗ੍ਰਹੀਤੁਮ੍ ਅਹਮਾਦਿਸ਼੍ਯੈ ਭਵਤਾ| ");
INSERT INTO sanpun_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ਤਦਾਨੀਂ ਯੀਸ਼ੁਸ੍ਤੰ ਪ੍ਰੋਕ੍ਤਵਾਨ੍, ਯੋ ਜਨੋ ਲਾਙ੍ਗਲੇ ਕਰਮਰ੍ਪਯਿਤ੍ਵਾ ਪਸ਼੍ਚਾਤ੍ ਪਸ਼੍ਯਤਿ ਸ ਈਸ਼੍ਵਰੀਯਰਾਜ੍ਯੰ ਨਾਰ੍ਹਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ਤਤਃ ਪਰੰ ਪ੍ਰਭੁਰਪਰਾਨ੍ ਸਪ੍ਤਤਿਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਨਿਯੁਜ੍ਯ ਸ੍ਵਯੰ ਯਾਨਿ ਨਗਰਾਣਿ ਯਾਨਿ ਸ੍ਥਾਨਾਨਿ ਚ ਗਮਿਸ਼਼੍ਯਤਿ ਤਾਨਿ ਨਗਰਾਣਿ ਤਾਨਿ ਸ੍ਥਾਨਾਨਿ ਚ ਪ੍ਰਤਿ ਦ੍ਵੌ ਦ੍ਵੌ ਜਨੌ ਪ੍ਰਹਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ਤੇਭ੍ਯਃ ਕਥਯਾਮਾਸ ਚ ਸ਼ਸ੍ਯਾਨਿ ਬਹੂਨੀਤਿ ਸਤ੍ਯੰ ਕਿਨ੍ਤੁ ਛੇਦਕਾ ਅਲ੍ਪੇ; ਤਸ੍ਮਾੱਧੇਤੋਃ ਸ਼ਸ੍ਯਕ੍ਸ਼਼ੇਤ੍ਰੇ ਛੇਦਕਾਨ੍ ਅਪਰਾਨਪਿ ਪ੍ਰੇਸ਼਼ਯਿਤੁੰ ਕ੍ਸ਼਼ੇਤ੍ਰਸ੍ਵਾਮਿਨੰ ਪ੍ਰਾਰ੍ਥਯਧ੍ਵੰ| ");
INSERT INTO sanpun_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","ਯੂਯੰ ਯਾਤ, ਪਸ਼੍ਯਤ, ਵ੍ਰੁʼਕਾਣਾਂ ਮਧ੍ਯੇ ਮੇਸ਼਼ਸ਼ਾਵਕਾਨਿਵ ਯੁਸ਼਼੍ਮਾਨ੍ ਪ੍ਰਹਿਣੋਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","ਯੂਯੰ ਕ੍ਸ਼਼ੁਦ੍ਰੰ ਮਹਦ੍ ਵਾ ਵਸਨਸਮ੍ਪੁਟਕੰ ਪਾਦੁਕਾਸ਼੍ਚ ਮਾ ਗ੍ਰੁʼਹ੍ਲੀਤ, ਮਾਰ੍ਗਮਧ੍ਯੇ ਕਮਪਿ ਮਾ ਨਮਤ ਚ| ");
INSERT INTO sanpun_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","ਅਪਰਞ੍ਚ ਯੂਯੰ ਯਦ੍ ਯਤ੍ ਨਿਵੇਸ਼ਨੰ ਪ੍ਰਵਿਸ਼ਥ ਤਤ੍ਰ ਨਿਵੇਸ਼ਨਸ੍ਯਾਸ੍ਯ ਮਙ੍ਗਲੰ ਭੂਯਾਦਿਤਿ ਵਾਕ੍ਯੰ ਪ੍ਰਥਮੰ ਵਦਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","ਤਸ੍ਮਾਤ੍ ਤਸ੍ਮਿਨ੍ ਨਿਵੇਸ਼ਨੇ ਯਦਿ ਮਙ੍ਗਲਪਾਤ੍ਰੰ ਸ੍ਥਾਸ੍ਯਤਿ ਤਰ੍ਹਿ ਤਨ੍ਮਙ੍ਗਲੰ ਤਸ੍ਯ ਭਵਿਸ਼਼੍ਯਤਿ, ਨੋਚੇਤ੍ ਯੁਸ਼਼੍ਮਾਨ੍ ਪ੍ਰਤਿ ਪਰਾਵਰ੍ੱਤਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","ਅਪਰਞ੍ਚ ਤੇ ਯਤ੍ਕਿਞ੍ਚਿਦ੍ ਦਾਸ੍ਯਨ੍ਤਿ ਤਦੇਵ ਭੁਕ੍ਤ੍ਵਾ ਪੀਤ੍ਵਾ ਤਸ੍ਮਿੰਨਿਵੇਸ਼ਨੇ ਸ੍ਥਾਸ੍ਯਥ; ਯਤਃ ਕਰ੍ੰਮਕਾਰੀ ਜਨੋ ਭ੍ਰੁʼਤਿਮ੍ ਅਰ੍ਹਤਿ; ਗ੍ਰੁʼਹਾਦ੍ ਗ੍ਰੁʼਹੰ ਮਾ ਯਾਸ੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","ਅਨ੍ਯੱਚ ਯੁਸ਼਼੍ਮਾਸੁ ਕਿਮਪਿ ਨਗਰੰ ਪ੍ਰਵਿਸ਼਼੍ਟੇਸ਼਼ੁ ਲੋਕਾ ਯਦਿ ਯੁਸ਼਼੍ਮਾਕਮ੍ ਆਤਿਥ੍ਯੰ ਕਰਿਸ਼਼੍ਯਨ੍ਤਿ, ਤਰ੍ਹਿ ਯਤ੍ ਖਾਦ੍ਯਮ੍ ਉਪਸ੍ਥਾਸ੍ਯਨ੍ਤਿ ਤਦੇਵ ਖਾਦਿਸ਼਼੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ਤੰਨਗਰਸ੍ਥਾਨ੍ ਰੋਗਿਣਃ ਸ੍ਵਸ੍ਥਾਨ੍ ਕਰਿਸ਼਼੍ਯਥ, ਈਸ਼੍ਵਰੀਯੰ ਰਾਜ੍ਯੰ ਯੁਸ਼਼੍ਮਾਕਮ੍ ਅਨ੍ਤਿਕਮ੍ ਆਗਮਤ੍ ਕਥਾਮੇਤਾਞ੍ਚ ਪ੍ਰਚਾਰਯਿਸ਼਼੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","ਕਿਨ੍ਤੁ ਕਿਮਪਿ ਪੁਰੰ ਯੁਸ਼਼੍ਮਾਸੁ ਪ੍ਰਵਿਸ਼਼੍ਟੇਸ਼਼ੁ ਲੋਕਾ ਯਦਿ ਯੁਸ਼਼੍ਮਾਕਮ੍ ਆਤਿਥ੍ਯੰ ਨ ਕਰਿਸ਼਼੍ਯਨ੍ਤਿ, ਤਰ੍ਹਿ ਤਸ੍ਯ ਨਗਰਸ੍ਯ ਪਨ੍ਥਾਨੰ ਗਤ੍ਵਾ ਕਥਾਮੇਤਾਂ ਵਦਿਸ਼਼੍ਯਥ, ");
INSERT INTO sanpun_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","ਯੁਸ਼਼੍ਮਾਕੰ ਨਗਰੀਯਾ ਯਾ ਧੂਲ੍ਯੋ(ਅ)ਸ੍ਮਾਸੁ ਸਮਲਗਨ੍ ਤਾ ਅਪਿ ਯੁਸ਼਼੍ਮਾਕੰ ਪ੍ਰਾਤਿਕੂਲ੍ਯੇਨ ਸਾਕ੍ਸ਼਼੍ਯਾਰ੍ਥੰ ਸਮ੍ਪਾਤਯਾਮਃ; ਤਥਾਪੀਸ਼੍ਵਰਰਾਜ੍ਯੰ ਯੁਸ਼਼੍ਮਾਕੰ ਸਮੀਪਮ੍ ਆਗਤਮ੍ ਇਤਿ ਨਿਸ਼੍ਚਿਤੰ ਜਾਨੀਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","ਅਹੰ ਯੁਸ਼਼੍ਮਭ੍ਯੰ ਯਥਾਰ੍ਥੰ ਕਥਯਾਮਿ, ਵਿਚਾਰਦਿਨੇ ਤਸ੍ਯ ਨਗਰਸ੍ਯ ਦਸ਼ਾਤਃ ਸਿਦੋਮੋ ਦਸ਼ਾ ਸਹ੍ਯਾ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","ਹਾ ਹਾ ਕੋਰਾਸੀਨ੍ ਨਗਰ, ਹਾ ਹਾ ਬੈਤ੍ਸੈਦਾਨਗਰ ਯੁਵਯੋਰ੍ਮਧ੍ਯੇ ਯਾਦ੍ਰੁʼਸ਼ਾਨਿ ਆਸ਼੍ਚਰ੍ੱਯਾਣਿ ਕਰ੍ੰਮਾਣ੍ਯਕ੍ਰਿਯਨ੍ਤ, ਤਾਨਿ ਕਰ੍ੰਮਾਣਿ ਯਦਿ ਸੋਰਸੀਦੋਨੋ ਰ੍ਨਗਰਯੋਰਕਾਰਿਸ਼਼੍ਯਨ੍ਤ, ਤਦਾ ਇਤੋ ਬਹੁਦਿਨਪੂਰ੍ੱਵੰ ਤੰਨਿਵਾਸਿਨਃ ਸ਼ਣਵਸ੍ਤ੍ਰਾਣਿ ਪਰਿਧਾਯ ਗਾਤ੍ਰੇਸ਼਼ੁ ਭਸ੍ਮ ਵਿਲਿਪ੍ਯ ਸਮੁਪਵਿਸ਼੍ਯ ਸਮਖੇਤ੍ਸ੍ਯਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","ਅਤੋ ਵਿਚਾਰਦਿਵਸੇ ਯੁਸ਼਼੍ਮਾਕੰ ਦਸ਼ਾਤਃ ਸੋਰਸੀਦੋੰਨਿਵਾਸਿਨਾਂ ਦਸ਼ਾ ਸਹ੍ਯਾ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ਹੇ ਕਫਰ੍ਨਾਹੂਮ੍, ਤ੍ਵੰ ਸ੍ਵਰ੍ਗੰ ਯਾਵਦ੍ ਉੰਨਤਾ ਕਿਨ੍ਤੁ ਨਰਕੰ ਯਾਵਤ੍ ਨ੍ਯਗ੍ਭਵਿਸ਼਼੍ਯਸਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ਯੋ ਜਨੋ ਯੁਸ਼਼੍ਮਾਕੰ ਵਾਕ੍ਯੰ ਗ੍ਰੁʼਹ੍ਲਾਤਿ ਸ ਮਮੈਵ ਵਾਕ੍ਯੰ ਗ੍ਰੁʼਹ੍ਲਾਤਿ; ਕਿਞ੍ਚ ਯੋ ਜਨੋ ਯੁਸ਼਼੍ਮਾਕਮ੍ ਅਵਜ੍ਞਾਂ ਕਰੋਤਿ ਸ ਮਮੈਵਾਵਜ੍ਞਾਂ ਕਰੋਤਿ; ਯੋ ਜਨੋ ਮਮਾਵਜ੍ਞਾਂ ਕਰੋਤਿ ਚ ਸ ਮਤ੍ਪ੍ਰੇਰਕਸ੍ਯੈਵਾਵਜ੍ਞਾਂ ਕਰੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","ਅਥ ਤੇ ਸਪ੍ਤਤਿਸ਼ਿਸ਼਼੍ਯਾ ਆਨਨ੍ਦੇਨ ਪ੍ਰਤ੍ਯਾਗਤ੍ਯ ਕਥਯਾਮਾਸੁਃ, ਹੇ ਪ੍ਰਭੋ ਭਵਤੋ ਨਾਮ੍ਨਾ ਭੂਤਾ ਅਪ੍ਯਸ੍ਮਾਕੰ ਵਸ਼ੀਭਵਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ਤਦਾਨੀਂ ਸ ਤਾਨ੍ ਜਗਾਦ, ਵਿਦ੍ਯੁਤਮਿਵ ਸ੍ਵਰ੍ਗਾਤ੍ ਪਤਨ੍ਤੰ ਸ਼ੈਤਾਨਮ੍ ਅਦਰ੍ਸ਼ਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","ਪਸ਼੍ਯਤ ਸਰ੍ਪਾਨ੍ ਵ੍ਰੁʼਸ਼੍ਚਿਕਾਨ੍ ਰਿਪੋਃ ਸਰ੍ੱਵਪਰਾਕ੍ਰਮਾਂਸ਼੍ਚ ਪਦਤਲੈ ਰ੍ਦਲਯਿਤੁੰ ਯੁਸ਼਼੍ਮਭ੍ਯੰ ਸ਼ਕ੍ਤਿੰ ਦਦਾਮਿ ਤਸ੍ਮਾਦ੍ ਯੁਸ਼਼੍ਮਾਕੰ ਕਾਪਿ ਹਾਨਿ ਰ੍ਨ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","ਭੂਤਾ ਯੁਸ਼਼੍ਮਾਕੰ ਵਸ਼ੀਭਵਨ੍ਤਿ, ਏਤੰਨਿਮਿੱਤਤ੍ ਮਾ ਸਮੁੱਲਸਤ, ਸ੍ਵਰ੍ਗੇ ਯੁਸ਼਼੍ਮਾਕੰ ਨਾਮਾਨਿ ਲਿਖਿਤਾਨਿ ਸਨ੍ਤੀਤਿ ਨਿਮਿੱਤੰ ਸਮੁੱਲਸਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","ਤਦ੍ਘਟਿਕਾਯਾਂ ਯੀਸ਼ੁ ਰ੍ਮਨਸਿ ਜਾਤਾਹ੍ਲਾਦਃ ਕਥਯਾਮਾਸ ਹੇ ਸ੍ਵਰ੍ਗਪ੍ਰੁʼਥਿਵ੍ਯੋਰੇਕਾਧਿਪਤੇ ਪਿਤਸ੍ਤ੍ਵੰ ਜ੍ਞਾਨਵਤਾਂ ਵਿਦੁਸ਼਼ਾਞ੍ਚ ਲੋਕਾਨਾਂ ਪੁਰਸ੍ਤਾਤ੍ ਸਰ੍ੱਵਮੇਤਦ੍ ਅਪ੍ਰਕਾਸ਼੍ਯ ਬਾਲਕਾਨਾਂ ਪੁਰਸ੍ਤਾਤ੍ ਪ੍ਰਾਕਾਸ਼ਯ ਏਤਸ੍ਮਾੱਧੇਤੋਸ੍ਤ੍ਵਾਂ ਧਨ੍ਯੰ ਵਦਾਮਿ, ਹੇ ਪਿਤਰਿੱਥੰ ਭਵਤੁ ਯਦ੍ ਏਤਦੇਵ ਤਵ ਗੋਚਰ ਉੱਤਮਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","ਪਿਤ੍ਰਾ ਸਰ੍ੱਵਾਣਿ ਮਯਿ ਸਮਰ੍ਪਿਤਾਨਿ ਪਿਤਰੰ ਵਿਨਾ ਕੋਪਿ ਪੁਤ੍ਰੰ ਨ ਜਾਨਾਤਿ ਕਿਞ੍ਚ ਪੁਤ੍ਰੰ ਵਿਨਾ ਯਸ੍ਮੈ ਜਨਾਯ ਪੁਤ੍ਰਸ੍ਤੰ ਪ੍ਰਕਾਸ਼ਿਤਵਾਨ੍ ਤਞ੍ਚ ਵਿਨਾ ਕੋਪਿ ਪਿਤਰੰ ਨ ਜਾਨਾਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ਤਪਃ ਪਰੰ ਸ ਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਪ੍ਰਤਿ ਪਰਾਵ੍ਰੁʼਤ੍ਯ ਗੁਪ੍ਤੰ ਜਗਾਦ, ਯੂਯਮੇਤਾਨਿ ਸਰ੍ੱਵਾਣਿ ਪਸ਼੍ਯਥ ਤਤੋ ਯੁਸ਼਼੍ਮਾਕੰ ਚਕ੍ਸ਼਼ੂੰਸ਼਼ਿ ਧਨ੍ਯਾਨਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ਯੁਸ਼਼੍ਮਾਨਹੰ ਵਦਾਮਿ, ਯੂਯੰ ਯਾਨਿ ਸਰ੍ੱਵਾਣਿ ਪਸ਼੍ਯਥ ਤਾਨਿ ਬਹਵੋ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨੋ ਭੂਪਤਯਸ਼੍ਚ ਦ੍ਰਸ਼਼੍ਟੁਮਿੱਛਨ੍ਤੋਪਿ ਦ੍ਰਸ਼਼੍ਟੁੰ ਨ ਪ੍ਰਾਪ੍ਨੁਵਨ੍, ਯੁਸ਼਼੍ਮਾਭਿ ਰ੍ਯਾ ਯਾਃ ਕਥਾਸ਼੍ਚ ਸ਼੍ਰੂਯਨ੍ਤੇ ਤਾਃ ਸ਼੍ਰੋਤੁਮਿੱਛਨ੍ਤੋਪਿ ਸ਼੍ਰੋਤੁੰ ਨਾਲਭਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","ਅਨਨ੍ਤਰਮ੍ ਏਕੋ ਵ੍ਯਵਸ੍ਥਾਪਕ ਉੱਥਾਯ ਤੰ ਪਰੀਕ੍ਸ਼਼ਿਤੁੰ ਪਪ੍ਰੱਛ, ਹੇ ਉਪਦੇਸ਼ਕ ਅਨਨ੍ਤਾਯੁਸ਼਼ਃ ਪ੍ਰਾਪ੍ਤਯੇ ਮਯਾ ਕਿੰ ਕਰਣੀਯੰ? ");
INSERT INTO sanpun_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯੁਵਾਚ, ਅਤ੍ਰਾਰ੍ਥੇ ਵ੍ਯਵਸ੍ਥਾਯਾਂ ਕਿੰ ਲਿਖਿਤਮਸ੍ਤਿ? ਤ੍ਵੰ ਕੀਦ੍ਰੁʼਕ੍ ਪਠਸਿ? ");
INSERT INTO sanpun_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ਤਤਃ ਸੋਵਦਤ੍, ਤ੍ਵੰ ਸਰ੍ੱਵਾਨ੍ਤਃਕਰਣੈਃ ਸਰ੍ੱਵਪ੍ਰਾਣੈਃ ਸਰ੍ੱਵਸ਼ਕ੍ਤਿਭਿਃ ਸਰ੍ੱਵਚਿੱਤੈਸ਼੍ਚ ਪ੍ਰਭੌ ਪਰਮੇਸ਼੍ਵਰੇ ਪ੍ਰੇਮ ਕੁਰੁ, ਸਮੀਪਵਾਸਿਨਿ ਸ੍ਵਵਤ੍ ਪ੍ਰੇਮ ਕੁਰੁ ਚ| ");
INSERT INTO sanpun_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ਤਦਾ ਸ ਕਥਯਾਮਾਸ, ਤ੍ਵੰ ਯਥਾਰ੍ਥੰ ਪ੍ਰਤ੍ਯਵੋਚਃ, ਇੱਥਮ੍ ਆਚਰ ਤੇਨੈਵ ਜੀਵਿਸ਼਼੍ਯਸਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","ਕਿਨ੍ਤੁ ਸ ਜਨਃ ਸ੍ਵੰ ਨਿਰ੍ੱਦੋਸ਼਼ੰ ਜ੍ਞਾਪਯਿਤੁੰ ਯੀਸ਼ੁੰ ਪਪ੍ਰੱਛ, ਮਮ ਸਮੀਪਵਾਸੀ ਕਃ? ਤਤੋ ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯੁਵਾਚ, ");
INSERT INTO sanpun_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ਏਕੋ ਜਨੋ ਯਿਰੂਸ਼ਾਲਮ੍ਪੁਰਾਦ੍ ਯਿਰੀਹੋਪੁਰੰ ਯਾਤਿ, ਏਤਰ੍ਹਿ ਦਸ੍ਯੂਨਾਂ ਕਰੇਸ਼਼ੁ ਪਤਿਤੇ ਤੇ ਤਸ੍ਯ ਵਸ੍ਤ੍ਰਾਦਿਕੰ ਹ੍ਰੁʼਤਵਨ੍ਤਃ ਤਮਾਹਤ੍ਯ ਮ੍ਰੁʼਤਪ੍ਰਾਯੰ ਕ੍ਰੁʼਤ੍ਵਾ ਤ੍ਯਕ੍ਤ੍ਵਾ ਯਯੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ਅਕਸ੍ਮਾਦ੍ ਏਕੋ ਯਾਜਕਸ੍ਤੇਨ ਮਾਰ੍ਗੇਣ ਗੱਛਨ੍ ਤੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਮਾਰ੍ਗਾਨ੍ਯਪਾਰ੍ਸ਼੍ਵੇਨ ਜਗਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ਇੱਥਮ੍ ਏਕੋ ਲੇਵੀਯਸ੍ਤਤ੍ਸ੍ਥਾਨੰ ਪ੍ਰਾਪ੍ਯ ਤਸ੍ਯਾਨ੍ਤਿਕੰ ਗਤ੍ਵਾ ਤੰ ਵਿਲੋਕ੍ਯਾਨ੍ਯੇਨ ਪਾਰ੍ਸ਼੍ਵੇਨ ਜਗਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","ਕਿਨ੍ਤ੍ਵੇਕਃ ਸ਼ੋਮਿਰੋਣੀਯੋ ਗੱਛਨ੍ ਤਤ੍ਸ੍ਥਾਨੰ ਪ੍ਰਾਪ੍ਯ ਤੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾਦਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ਤਸ੍ਯਾਨ੍ਤਿਕੰ ਗਤ੍ਵਾ ਤਸ੍ਯ ਕ੍ਸ਼਼ਤੇਸ਼਼ੁ ਤੈਲੰ ਦ੍ਰਾਕ੍ਸ਼਼ਾਰਸਞ੍ਚ ਪ੍ਰਕ੍ਸ਼਼ਿਪ੍ਯ ਕ੍ਸ਼਼ਤਾਨਿ ਬੱਧ੍ਵਾ ਨਿਜਵਾਹਨੋਪਰਿ ਤਮੁਪਵੇਸ਼੍ਯ ਪ੍ਰਵਾਸੀਯਗ੍ਰੁʼਹਮ੍ ਆਨੀਯ ਤੰ ਸਿਸ਼਼ੇਵੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","ਪਰਸ੍ਮਿਨ੍ ਦਿਵਸੇ ਨਿਜਗਮਨਕਾਲੇ ਦ੍ਵੌ ਮੁਦ੍ਰਾਪਾਦੌ ਤਦ੍ਗ੍ਰੁʼਹਸ੍ਵਾਮਿਨੇ ਦੱਤ੍ਵਾਵਦਤ੍ ਜਨਮੇਨੰ ਸੇਵਸ੍ਵ ਤਤ੍ਰ ਯੋ(ਅ)ਧਿਕੋ ਵ੍ਯਯੋ ਭਵਿਸ਼਼੍ਯਤਿ ਤਮਹੰ ਪੁਨਰਾਗਮਨਕਾਲੇ ਪਰਿਸ਼ੋਤ੍ਸ੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","ਏਸ਼਼ਾਂ ਤ੍ਰਯਾਣਾਂ ਮਧ੍ਯੇ ਤਸ੍ਯ ਦਸ੍ਯੁਹਸ੍ਤਪਤਿਤਸ੍ਯ ਜਨਸ੍ਯ ਸਮੀਪਵਾਸੀ ਕਃ? ਤ੍ਵਯਾ ਕਿੰ ਬੁਧ੍ਯਤੇ? ");
INSERT INTO sanpun_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ਤਤਃ ਸ ਵ੍ਯਵਸ੍ਥਾਪਕਃ ਕਥਯਾਮਾਸ ਯਸ੍ਤਸ੍ਮਿਨ੍ ਦਯਾਂ ਚਕਾਰ| ਤਦਾ ਯੀਸ਼ੁਃ ਕਥਯਾਮਾਸ ਤ੍ਵਮਪਿ ਗਤ੍ਵਾ ਤਥਾਚਰ| ");
INSERT INTO sanpun_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","ਤਤਃ ਪਰੰ ਤੇ ਗੱਛਨ੍ਤ ਏਕੰ ਗ੍ਰਾਮੰ ਪ੍ਰਵਿਵਿਸ਼ੁਃ; ਤਦਾ ਮਰ੍ਥਾਨਾਮਾ ਸ੍ਤ੍ਰੀ ਸ੍ਵਗ੍ਰੁʼਹੇ ਤਸ੍ਯਾਤਿਥ੍ਯੰ ਚਕਾਰ| ");
INSERT INTO sanpun_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","ਤਸ੍ਮਾਤ੍ ਮਰਿਯਮ੍ ਨਾਮਧੇਯਾ ਤਸ੍ਯਾ ਭਗਿਨੀ ਯੀਸ਼ੋਃ ਪਦਸਮੀਪ ਉਵਵਿਸ਼੍ਯ ਤਸ੍ਯੋਪਦੇਸ਼ਕਥਾਂ ਸ਼੍ਰੋਤੁਮਾਰੇਭੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","ਕਿਨ੍ਤੁ ਮਰ੍ਥਾ ਨਾਨਾਪਰਿਚਰ੍ੱਯਾਯਾਂ ਵ੍ਯਗ੍ਰਾ ਬਭੂਵ ਤਸ੍ਮਾੱਧੇਤੋਸ੍ਤਸ੍ਯ ਸਮੀਪਮਾਗਤ੍ਯ ਬਭਾਸ਼਼ੇ; ਹੇ ਪ੍ਰਭੋ ਮਮ ਭਗਿਨੀ ਕੇਵਲੰ ਮਮੋਪਰਿ ਸਰ੍ੱਵਕਰ੍ੰਮਣਾਂ ਭਾਰਮ੍ ਅਰ੍ਪਿਤਵਤੀ ਤਤ੍ਰ ਭਵਤਾ ਕਿਞ੍ਚਿਦਪਿ ਨ ਮਨੋ ਨਿਧੀਯਤੇ ਕਿਮ੍? ਮਮ ਸਾਹਾੱਯੰ ਕਰ੍ੱਤੁੰ ਭਵਾਨ੍ ਤਾਮਾਦਿਸ਼ਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ਤਤੋ ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯੁਵਾਚ ਹੇ ਮਰ੍ਥੇ ਹੇ ਮਰ੍ਥੇ, ਤ੍ਵੰ ਨਾਨਾਕਾਰ੍ੱਯੇਸ਼਼ੁ ਚਿਨ੍ਤਿਤਵਤੀ ਵ੍ਯਗ੍ਰਾ ਚਾਸਿ, ");
INSERT INTO sanpun_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ਕਿਨ੍ਤੁ ਪ੍ਰਯੋਜਨੀਯਮ੍ ਏਕਮਾਤ੍ਰਮ੍ ਆਸ੍ਤੇ| ਅਪਰਞ੍ਚ ਯਮੁੱਤਮੰ ਭਾਗੰ ਕੋਪਿ ਹਰ੍ੱਤੁੰ ਨ ਸ਼ਕ੍ਨੋਤਿ ਸਏਵ ਮਰਿਯਮਾ ਵ੍ਰੁʼਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","ਅਨਨ੍ਤਰੰ ਸ ਕਸ੍ਮਿੰਸ਼੍ਚਿਤ੍ ਸ੍ਥਾਨੇ ਪ੍ਰਾਰ੍ਥਯਤ ਤਤ੍ਸਮਾਪ੍ਤੌ ਸਤ੍ਯਾਂ ਤਸ੍ਯੈਕਃ ਸ਼ਿਸ਼਼੍ਯਸ੍ਤੰ ਜਗਾਦ ਹੇ ਪ੍ਰਭੋ ਯੋਹਨ੍ ਯਥਾ ਸ੍ਵਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਪ੍ਰਾਰ੍ਥਯਿਤੁਮ੍ ਉਪਦਿਸ਼਼੍ਟਵਾਨ੍ ਤਥਾ ਭਵਾਨਪ੍ਯਸ੍ਮਾਨ੍ ਉਪਦਿਸ਼ਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","ਤਸ੍ਮਾਤ੍ ਸ ਕਥਯਾਮਾਸ, ਪ੍ਰਾਰ੍ਥਨਕਾਲੇ ਯੂਯਮ੍ ਇੱਥੰ ਕਥਯਧ੍ਵੰ, ਹੇ ਅਸ੍ਮਾਕੰ ਸ੍ਵਰ੍ਗਸ੍ਥਪਿਤਸ੍ਤਵ ਨਾਮ ਪੂਜ੍ਯੰ ਭਵਤੁ; ਤਵ ਰਾਜਤ੍ਵੰ ਭਵਤੁ; ਸ੍ਵਰ੍ਗੇ ਯਥਾ ਤਥਾ ਪ੍ਰੁʼਥਿਵ੍ਯਾਮਪਿ ਤਵੇੱਛਯਾ ਸਰ੍ੱਵੰ ਭਵਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ਪ੍ਰਤ੍ਯਹਮ੍ ਅਸ੍ਮਾਕੰ ਪ੍ਰਯੋਜਨੀਯੰ ਭੋਜ੍ਯੰ ਦੇਹਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ਯਥਾ ਵਯੰ ਸਰ੍ੱਵਾਨ੍ ਅਪਰਾਧਿਨਃ ਕ੍ਸ਼਼ਮਾਮਹੇ ਤਥਾ ਤ੍ਵਮਪਿ ਪਾਪਾਨ੍ਯਸ੍ਮਾਕੰ ਕ੍ਸ਼਼ਮਸ੍ਵ| ਅਸ੍ਮਾਨ੍ ਪਰੀਕ੍ਸ਼਼ਾਂ ਮਾਨਯ ਕਿਨ੍ਤੁ ਪਾਪਾਤ੍ਮਨੋ ਰਕ੍ਸ਼਼| ");
INSERT INTO sanpun_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ਪਸ਼੍ਚਾਤ੍ ਸੋਪਰਮਪਿ ਕਥਿਤਵਾਨ੍ ਯਦਿ ਯੁਸ਼਼੍ਮਾਕੰ ਕਸ੍ਯਚਿਦ੍ ਬਨ੍ਧੁਸ੍ਤਿਸ਼਼੍ਠਤਿ ਨਿਸ਼ੀਥੇ ਚ ਤਸ੍ਯ ਸਮੀਪੰ ਸ ਗਤ੍ਵਾ ਵਦਤਿ, ");
INSERT INTO sanpun_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ਹੇ ਬਨ੍ਧੋ ਪਥਿਕ ਏਕੋ ਬਨ੍ਧੁ ਰ੍ਮਮ ਨਿਵੇਸ਼ਨਮ੍ ਆਯਾਤਃ ਕਿਨ੍ਤੁ ਤਸ੍ਯਾਤਿਥ੍ਯੰ ਕਰ੍ੱਤੁੰ ਮਮਾਨ੍ਤਿਕੇ ਕਿਮਪਿ ਨਾਸ੍ਤਿ, ਅਤਏਵ ਪੂਪਤ੍ਰਯੰ ਮਹ੍ਯਮ੍ ਰੁʼਣੰ ਦੇਹਿ; ");
INSERT INTO sanpun_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ਤਦਾ ਸ ਯਦਿ ਗ੍ਰੁʼਹਮਧ੍ਯਾਤ੍ ਪ੍ਰਤਿਵਦਤਿ ਮਾਂ ਮਾ ਕ੍ਲਿਸ਼ਾਨ, ਇਦਾਨੀਂ ਦ੍ਵਾਰੰ ਰੁੱਧੰ ਸ਼ਯਨੇ ਮਯਾ ਸਹ ਬਾਲਕਾਸ਼੍ਚ ਤਿਸ਼਼੍ਠਨ੍ਤਿ ਤੁਭ੍ਯੰ ਦਾਤੁਮ੍ ਉੱਥਾਤੁੰ ਨ ਸ਼ਕ੍ਨੋਮਿ, ");
INSERT INTO sanpun_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","ਤਰ੍ਹਿ ਯੁਸ਼਼੍ਮਾਨਹੰ ਵਦਾਮਿ, ਸ ਯਦਿ ਮਿਤ੍ਰਤਯਾ ਤਸ੍ਮੈ ਕਿਮਪਿ ਦਾਤੁੰ ਨੋੱਤਿਸ਼਼੍ਠਤਿ ਤਥਾਪਿ ਵਾਰੰ ਵਾਰੰ ਪ੍ਰਾਰ੍ਥਨਾਤ ਉੱਥਾਪਿਤਃ ਸਨ੍ ਯਸ੍ਮਿਨ੍ ਤਸ੍ਯ ਪ੍ਰਯੋਜਨੰ ਤਦੇਵ ਦਾਸ੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","ਅਤਃ ਕਾਰਣਾਤ੍ ਕਥਯਾਮਿ, ਯਾਚਧ੍ਵੰ ਤਤੋ ਯੁਸ਼਼੍ਮਭ੍ਯੰ ਦਾਸ੍ਯਤੇ, ਮ੍ਰੁʼਗਯਧ੍ਵੰ ਤਤ ਉੱਦੇਸ਼ੰ ਪ੍ਰਾਪ੍ਸ੍ਯਥ, ਦ੍ਵਾਰਮ੍ ਆਹਤ ਤਤੋ ਯੁਸ਼਼੍ਮਭ੍ਯੰ ਦ੍ਵਾਰੰ ਮੋਕ੍ਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","ਯੋ ਯਾਚਤੇ ਸ ਪ੍ਰਾਪ੍ਨੋਤਿ, ਯੋ ਮ੍ਰੁʼਗਯਤੇ ਸ ਏਵੋੱਦੇਸ਼ੰ ਪ੍ਰਾਪ੍ਨੋਤਿ, ਯੋ ਦ੍ਵਾਰਮ੍ ਆਹਨ੍ਤਿ ਤਦਰ੍ਥੰ ਦ੍ਵਾਰੰ ਮੋਚ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","ਪੁਤ੍ਰੇਣ ਪੂਪੇ ਯਾਚਿਤੇ ਤਸ੍ਮੈ ਪਾਸ਼਼ਾਣੰ ਦਦਾਤਿ ਵਾ ਮਤ੍ਸ੍ਯੇ ਯਾਚਿਤੇ ਤਸ੍ਮੈ ਸਰ੍ਪੰ ਦਦਾਤਿ ");
INSERT INTO sanpun_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ਵਾ ਅਣ੍ਡੇ ਯਾਚਿਤੇ ਤਸ੍ਮੈ ਵ੍ਰੁʼਸ਼੍ਚਿਕੰ ਦਦਾਤਿ ਯੁਸ਼਼੍ਮਾਕੰ ਮਧ੍ਯੇ ਕ ਏਤਾਦ੍ਰੁʼਸ਼ਃ ਪਿਤਾਸ੍ਤੇ? ");
INSERT INTO sanpun_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ਤਸ੍ਮਾਦੇਵ ਯੂਯਮਭਦ੍ਰਾ ਅਪਿ ਯਦਿ ਸ੍ਵਸ੍ਵਬਾਲਕੇਭ੍ਯ ਉੱਤਮਾਨਿ ਦ੍ਰਵ੍ਯਾਣਿ ਦਾਤੁੰ ਜਾਨੀਥ ਤਰ੍ਹ੍ਯਸ੍ਮਾਕੰ ਸ੍ਵਰ੍ਗਸ੍ਥਃ ਪਿਤਾ ਨਿਜਯਾਚਕੇਭ੍ਯਃ ਕਿੰ ਪਵਿਤ੍ਰਮ੍ ਆਤ੍ਮਾਨੰ ਨ ਦਾਸ੍ਯਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","ਅਨਨ੍ਤਰੰ ਯੀਸ਼ੁਨਾ ਕਸ੍ਮਾੱਚਿਦ੍ ਏਕਸ੍ਮਿਨ੍ ਮੂਕਭੂਤੇ ਤ੍ਯਾਜਿਤੇ ਸਤਿ ਸ ਭੂਤਤ੍ਯਕ੍ਤੋ ਮਾਨੁਸ਼਼ੋ ਵਾਕ੍ਯੰ ਵਕ੍ਤੁਮ੍ ਆਰੇਭੇ; ਤਤੋ ਲੋਕਾਃ ਸਕਲਾ ਆਸ਼੍ਚਰ੍ੱਯੰ ਮੇਨਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ਕਿਨ੍ਤੁ ਤੇਸ਼਼ਾਂ ਕੇਚਿਦੂਚੁ ਰ੍ਜਨੋਯੰ ਬਾਲਸਿਬੂਬਾ ਅਰ੍ਥਾਦ੍ ਭੂਤਰਾਜੇਨ ਭੂਤਾਨ੍ ਤ੍ਯਾਜਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ਤੰ ਪਰੀਕ੍ਸ਼਼ਿਤੁੰ ਕੇਚਿਦ੍ ਆਕਾਸ਼ੀਯਮ੍ ਏਕੰ ਚਿਹ੍ਨੰ ਦਰ੍ਸ਼ਯਿਤੁੰ ਤੰ ਪ੍ਰਾਰ੍ਥਯਾਞ੍ਚਕ੍ਰਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","ਤਦਾ ਸ ਤੇਸ਼਼ਾਂ ਮਨਃਕਲ੍ਪਨਾਂ ਜ੍ਞਾਤ੍ਵਾ ਕਥਯਾਮਾਸ, ਕਸ੍ਯਚਿਦ੍ ਰਾਜ੍ਯਸ੍ਯ ਲੋਕਾ ਯਦਿ ਪਰਸ੍ਪਰੰ ਵਿਰੁਨ੍ਧਨ੍ਤਿ ਤਰ੍ਹਿ ਤਦ੍ ਰਾਜ੍ਯਮ੍ ਨਸ਼੍ਯਤਿ; ਕੇਚਿਦ੍ ਗ੍ਰੁʼਹਸ੍ਥਾ ਯਦਿ ਪਰਸ੍ਪਰੰ ਵਿਰੁਨ੍ਧਨ੍ਤਿ ਤਰ੍ਹਿ ਤੇਪਿ ਨਸ਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","ਤਥੈਵ ਸ਼ੈਤਾਨਪਿ ਸ੍ਵਲੋਕਾਨ੍ ਯਦਿ ਵਿਰੁਣੱਧਿ ਤਦਾ ਤਸ੍ਯ ਰਾਜ੍ਯੰ ਕਥੰ ਸ੍ਥਾਸ੍ਯਤਿ? ਬਾਲਸਿਬੂਬਾਹੰ ਭੂਤਾਨ੍ ਤ੍ਯਾਜਯਾਮਿ ਯੂਯਮਿਤਿ ਵਦਥ| ");
INSERT INTO sanpun_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ਯਦ੍ਯਹੰ ਬਾਲਸਿਬੂਬਾ ਭੂਤਾਨ੍ ਤ੍ਯਾਜਯਾਮਿ ਤਰ੍ਹਿ ਯੁਸ਼਼੍ਮਾਕੰ ਸਨ੍ਤਾਨਾਃ ਕੇਨ ਤ੍ਯਾਜਯਨ੍ਤਿ? ਤਸ੍ਮਾਤ੍ ਤਏਵ ਕਥਾਯਾ ਏਤਸ੍ਯਾ ਵਿਚਾਰਯਿਤਾਰੋ ਭਵਿਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","ਕਿਨ੍ਤੁ ਯਦ੍ਯਹਮ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਪਰਾਕ੍ਰਮੇਣ ਭੂਤਾਨ੍ ਤ੍ਯਾਜਯਾਮਿ ਤਰ੍ਹਿ ਯੁਸ਼਼੍ਮਾਕੰ ਨਿਕਟਮ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਰਾਜ੍ਯਮਵਸ਼੍ਯਮ੍ ਉਪਤਿਸ਼਼੍ਠਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","ਬਲਵਾਨ੍ ਪੁਮਾਨ੍ ਸੁਸੱਜਮਾਨੋ ਯਤਿਕਾਲੰ ਨਿਜਾੱਟਾਲਿਕਾਂ ਰਕ੍ਸ਼਼ਤਿ ਤਤਿਕਾਲੰ ਤਸ੍ਯ ਦ੍ਰਵ੍ਯੰ ਨਿਰੁਪਦ੍ਰਵੰ ਤਿਸ਼਼੍ਠਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","ਕਿਨ੍ਤੁ ਤਸ੍ਮਾਦ੍ ਅਧਿਕਬਲਃ ਕਸ਼੍ਚਿਦਾਗਤ੍ਯ ਯਦਿ ਤੰ ਜਯਤਿ ਤਰ੍ਹਿ ਯੇਸ਼਼ੁ ਸ਼ਸ੍ਤ੍ਰਾਸ੍ਤ੍ਰੇਸ਼਼ੁ ਤਸ੍ਯ ਵਿਸ਼੍ਵਾਸ ਆਸੀਤ੍ ਤਾਨਿ ਸਰ੍ੱਵਾਣਿ ਹ੍ਰੁʼਤ੍ਵਾ ਤਸ੍ਯ ਦ੍ਰਵ੍ਯਾਣਿ ਗ੍ਰੁʼਹ੍ਲਾਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","ਅਤਃ ਕਾਰਣਾਦ੍ ਯੋ ਮਮ ਸਪਕ੍ਸ਼਼ੋ ਨ ਸ ਵਿਪਕ੍ਸ਼਼ਃ, ਯੋ ਮਯਾ ਸਹ ਨ ਸੰਗ੍ਰੁʼਹ੍ਲਾਤਿ ਸ ਵਿਕਿਰਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","ਅਪਰਞ੍ਚ ਅਮੇਧ੍ਯਭੂਤੋ ਮਾਨੁਸ਼਼ਸ੍ਯਾਨ੍ਤਰ੍ਨਿਰ੍ਗਤ੍ਯ ਸ਼ੁਸ਼਼੍ਕਸ੍ਥਾਨੇ ਭ੍ਰਾਨ੍ਤ੍ਵਾ ਵਿਸ਼੍ਰਾਮੰ ਮ੍ਰੁʼਗਯਤੇ ਕਿਨ੍ਤੁ ਨ ਪ੍ਰਾਪ੍ਯ ਵਦਤਿ ਮਮ ਯਸ੍ਮਾਦ੍ ਗ੍ਰੁʼਹਾਦ੍ ਆਗਤੋਹੰ ਪੁਨਸ੍ਤਦ੍ ਗ੍ਰੁʼਹੰ ਪਰਾਵ੍ਰੁʼਤ੍ਯ ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ਤਤੋ ਗਤ੍ਵਾ ਤਦ੍ ਗ੍ਰੁʼਹੰ ਮਾਰ੍ਜਿਤੰ ਸ਼ੋਭਿਤਞ੍ਚ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ");
INSERT INTO sanpun_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ਤਤ੍ਕ੍ਸ਼਼ਣਮ੍ ਅਪਗਤ੍ਯ ਸ੍ਵਸ੍ਮਾਦਪਿ ਦੁਰ੍ੰਮਤੀਨ੍ ਅਪਰਾਨ੍ ਸਪ੍ਤਭੂਤਾਨ੍ ਸਹਾਨਯਤਿ ਤੇ ਚ ਤਦ੍ਗ੍ਰੁʼਹੰ ਪਵਿਸ਼੍ਯ ਨਿਵਸਨ੍ਤਿ| ਤਸ੍ਮਾਤ੍ ਤਸ੍ਯ ਮਨੁਸ਼਼੍ਯਸ੍ਯ ਪ੍ਰਥਮਦਸ਼ਾਤਃ ਸ਼ੇਸ਼਼ਦਸ਼ਾ ਦੁਃਖਤਰਾ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","ਅਸ੍ਯਾਃ ਕਥਾਯਾਃ ਕਥਨਕਾਲੇ ਜਨਤਾਮਧ੍ਯਸ੍ਥਾ ਕਾਚਿੰਨਾਰੀ ਤਮੁੱਚੈਃਸ੍ਵਰੰ ਪ੍ਰੋਵਾਚ, ਯਾ ਯੋਸ਼਼ਿਤ੍ ਤ੍ਵਾਂ ਗਰ੍ੱਭੇ(ਅ)ਧਾਰਯਤ੍ ਸ੍ਤਨ੍ਯਮਪਾਯਯੱਚ ਸੈਵ ਧਨ੍ਯਾ| ");
INSERT INTO sanpun_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","ਕਿਨ੍ਤੁ ਸੋਕਥਯਤ੍ ਯੇ ਪਰਮੇਸ਼੍ਵਰਸ੍ਯ ਕਥਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਤਦਨੁਰੂਪਮ੍ ਆਚਰਨ੍ਤਿ ਤਏਵ ਧਨ੍ਯਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","ਤਤਃ ਪਰੰ ਤਸ੍ਯਾਨ੍ਤਿਕੇ ਬਹੁਲੋਕਾਨਾਂ ਸਮਾਗਮੇ ਜਾਤੇ ਸ ਵਕ੍ਤੁਮਾਰੇਭੇ, ਆਧੁਨਿਕਾ ਦੁਸ਼਼੍ਟਲੋਕਾਸ਼੍ਚਿਹ੍ਨੰ ਦ੍ਰਸ਼਼੍ਟੁਮਿੱਛਨ੍ਤਿ ਕਿਨ੍ਤੁ ਯੂਨਸ੍ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਸ਼੍ਚਿਹ੍ਨੰ ਵਿਨਾਨ੍ਯਤ੍ ਕਿਞ੍ਚਿੱਚਿਹ੍ਨੰ ਤਾਨ੍ ਨ ਦਰ੍ਸ਼ਯਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","ਯੂਨਸ੍ ਤੁ ਯਥਾ ਨੀਨਿਵੀਯਲੋਕਾਨਾਂ ਸਮੀਪੇ ਚਿਹ੍ਨਰੂਪੋਭਵਤ੍ ਤਥਾ ਵਿਦ੍ਯਮਾਨਲੋਕਾਨਾਮ੍ ਏਸ਼਼ਾਂ ਸਮੀਪੇ ਮਨੁਸ਼਼੍ਯਪੁਤ੍ਰੋਪਿ ਚਿਹ੍ਨਰੂਪੋ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ਵਿਚਾਰਸਮਯੇ ਇਦਾਨੀਨ੍ਤਨਲੋਕਾਨਾਂ ਪ੍ਰਾਤਿਕੂਲ੍ਯੇਨ ਦਕ੍ਸ਼਼ਿਣਦੇਸ਼ੀਯਾ ਰਾਜ੍ਞੀ ਪ੍ਰੋੱਥਾਯ ਤਾਨ੍ ਦੋਸ਼਼ਿਣਃ ਕਰਿਸ਼਼੍ਯਤਿ, ਯਤਃ ਸਾ ਰਾਜ੍ਞੀ ਸੁਲੇਮਾਨ ਉਪਦੇਸ਼ਕਥਾਂ ਸ਼੍ਰੋਤੁੰ ਪ੍ਰੁʼਥਿਵ੍ਯਾਃ ਸੀਮਾਤ ਆਗੱਛਤ੍ ਕਿਨ੍ਤੁ ਪਸ਼੍ਯਤ ਸੁਲੇਮਾਨੋਪਿ ਗੁਰੁਤਰ ਏਕੋ ਜਨੋ(ਅ)ਸ੍ਮਿਨ੍ ਸ੍ਥਾਨੇ ਵਿਦ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","ਅਪਰਞ੍ਚ ਵਿਚਾਰਸਮਯੇ ਨੀਨਿਵੀਯਲੋਕਾ ਅਪਿ ਵਰ੍ੱਤਮਾਨਕਾਲਿਕਾਨਾਂ ਲੋਕਾਨਾਂ ਵੈਪਰੀਤ੍ਯੇਨ ਪ੍ਰੋੱਥਾਯ ਤਾਨ੍ ਦੋਸ਼਼ਿਣਃ ਕਰਿਸ਼਼੍ਯਨ੍ਤਿ, ਯਤੋ ਹੇਤੋਸ੍ਤੇ ਯੂਨਸੋ ਵਾਕ੍ਯਾਤ੍ ਚਿੱਤਾਨਿ ਪਰਿਵਰ੍ੱਤਯਾਮਾਸੁਃ ਕਿਨ੍ਤੁ ਪਸ਼੍ਯਤ ਯੂਨਸੋਤਿਗੁਰੁਤਰ ਏਕੋ ਜਨੋ(ਅ)ਸ੍ਮਿਨ੍ ਸ੍ਥਾਨੇ ਵਿਦ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","ਪ੍ਰਦੀਪੰ ਪ੍ਰਜ੍ਵਾਲ੍ਯ ਦ੍ਰੋਣਸ੍ਯਾਧਃ ਕੁਤ੍ਰਾਪਿ ਗੁਪ੍ਤਸ੍ਥਾਨੇ ਵਾ ਕੋਪਿ ਨ ਸ੍ਥਾਪਯਤਿ ਕਿਨ੍ਤੁ ਗ੍ਰੁʼਹਪ੍ਰਵੇਸ਼ਿਭ੍ਯੋ ਦੀਪ੍ਤਿੰ ਦਾਤੰ ਦੀਪਾਧਾਰੋਪਰ੍ੱਯੇਵ ਸ੍ਥਾਪਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","ਦੇਹਸ੍ਯ ਪ੍ਰਦੀਪਸ਼੍ਚਕ੍ਸ਼਼ੁਸ੍ਤਸ੍ਮਾਦੇਵ ਚਕ੍ਸ਼਼ੁ ਰ੍ਯਦਿ ਪ੍ਰਸੰਨੰ ਭਵਤਿ ਤਰ੍ਹਿ ਤਵ ਸਰ੍ੱਵਸ਼ਰੀਰੰ ਦੀਪ੍ਤਿਮਦ੍ ਭਵਿਸ਼਼੍ਯਤਿ ਕਿਨ੍ਤੁ ਚਕ੍ਸ਼਼ੁ ਰ੍ਯਦਿ ਮਲੀਮਸੰ ਤਿਸ਼਼੍ਠਤਿ ਤਰ੍ਹਿ ਸਰ੍ੱਵਸ਼ਰੀਰੰ ਸਾਨ੍ਧਕਾਰੰ ਸ੍ਥਾਸ੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","ਅਸ੍ਮਾਤ੍ ਕਾਰਣਾਤ੍ ਤਵਾਨ੍ਤਃਸ੍ਥੰ ਜ੍ਯੋਤਿ ਰ੍ਯਥਾਨ੍ਧਕਾਰਮਯੰ ਨ ਭਵਤਿ ਤਦਰ੍ਥੇ ਸਾਵਧਾਨੋ ਭਵ| ");
INSERT INTO sanpun_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","ਯਤਃ ਸ਼ਰੀਰਸ੍ਯ ਕੁਤ੍ਰਾਪ੍ਯੰਸ਼ੇ ਸਾਨ੍ਧਕਾਰੇ ਨ ਜਾਤੇ ਸਰ੍ੱਵੰ ਯਦਿ ਦੀਪ੍ਤਿਮਤ੍ ਤਿਸ਼਼੍ਠਤਿ ਤਰ੍ਹਿ ਤੁਭ੍ਯੰ ਦੀਪ੍ਤਿਦਾਯਿਪ੍ਰੋੱਜ੍ਵਲਨ੍ ਪ੍ਰਦੀਪ ਇਵ ਤਵ ਸਵਰ੍ਵਸ਼ਰੀਰੰ ਦੀਪ੍ਤਿਮਦ੍ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ਏਤਤ੍ਕਥਾਯਾਃ ਕਥਨਕਾਲੇ ਫਿਰੁਸ਼੍ਯੇਕੋ ਭੇਜਨਾਯ ਤੰ ਨਿਮਨ੍ਤ੍ਰਯਾਮਾਸ, ਤਤਃ ਸ ਗਤ੍ਵਾ ਭੋਕ੍ਤੁਮ੍ ਉਪਵਿਵੇਸ਼| ");
INSERT INTO sanpun_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ਕਿਨ੍ਤੁ ਭੋਜਨਾਤ੍ ਪੂਰ੍ੱਵੰ ਨਾਮਾਙ੍ਕ੍ਸ਼਼ੀਤ੍ ਏਤਦ੍ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਸ ਫਿਰੁਸ਼੍ਯਾਸ਼੍ਚਰ੍ੱਯੰ ਮੇਨੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","ਤਦਾ ਪ੍ਰਭੁਸ੍ਤੰ ਪ੍ਰੋਵਾਚ ਯੂਯੰ ਫਿਰੂਸ਼ਿਲੋਕਾਃ ਪਾਨਪਾਤ੍ਰਾਣਾਂ ਭੋਜਨਪਾਤ੍ਰਾਣਾਞ੍ਚ ਬਹਿਃ ਪਰਿਸ਼਼੍ਕੁਰੁਥ ਕਿਨ੍ਤੁ ਯੁਸ਼਼੍ਮਾਕਮਨ੍ਤ ਰ੍ਦੌਰਾਤ੍ਮ੍ਯੈ ਰ੍ਦੁਸ਼਼੍ਕ੍ਰਿਯਾਭਿਸ਼੍ਚ ਪਰਿਪੂਰ੍ਣੰ ਤਿਸ਼਼੍ਠਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ਹੇ ਸਰ੍ੱਵੇ ਨਿਰ੍ਬੋਧਾ ਯੋ ਬਹਿਃ ਸਸਰ੍ਜ ਸ ਏਵ ਕਿਮਨ੍ਤ ਰ੍ਨ ਸਸਰ੍ਜ? ");
INSERT INTO sanpun_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","ਤਤ ਏਵ ਯੁਸ਼਼੍ਮਾਭਿਰਨ੍ਤਃਕਰਣੰ (ਈਸ਼੍ਵਰਾਯ) ਨਿਵੇਦ੍ਯਤਾਂ ਤਸ੍ਮਿਨ੍ ਕ੍ਰੁʼਤੇ ਯੁਸ਼਼੍ਮਾਕੰ ਸਰ੍ੱਵਾਣਿ ਸ਼ੁਚਿਤਾਂ ਯਾਸ੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","ਕਿਨ੍ਤੁ ਹਨ੍ਤ ਫਿਰੂਸ਼ਿਗਣਾ ਯੂਯੰ ਨ੍ਯਾਯਮ੍ ਈਸ਼੍ਵਰੇ ਪ੍ਰੇਮ ਚ ਪਰਿਤ੍ਯਜ੍ਯ ਪੋਦਿਨਾਯਾ ਅਰੁਦਾਦੀਨਾਂ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਸ਼ਾਕਾਨਾਞ੍ਚ ਦਸ਼ਮਾਂਸ਼ਾਨ੍ ਦੱਥ ਕਿਨ੍ਤੁ ਪ੍ਰਥਮੰ ਪਾਲਯਿਤ੍ਵਾ ਸ਼ੇਸ਼਼ਸ੍ਯਾਲਙ੍ਘਨੰ ਯੁਸ਼਼੍ਮਾਕਮ੍ ਉਚਿਤਮਾਸੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","ਹਾ ਹਾ ਫਿਰੂਸ਼ਿਨੋ ਯੂਯੰ ਭਜਨਗੇਹੇ ਪ੍ਰੋੱਚਾਸਨੇ ਆਪਣੇਸ਼਼ੁ ਚ ਨਮਸ੍ਕਾਰੇਸ਼਼ੁ ਪ੍ਰੀਯਧ੍ਵੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","ਵਤ ਕਪਟਿਨੋ(ਅ)ਧ੍ਯਾਪਕਾਃ ਫਿਰੂਸ਼ਿਨਸ਼੍ਚ ਲੋਕਾਯਤ੍ ਸ਼੍ਮਸ਼ਾਨਮ੍ ਅਨੁਪਲਭ੍ਯ ਤਦੁਪਰਿ ਗੱਛਨ੍ਤਿ ਯੂਯਮ੍ ਤਾਦ੍ਰੁʼਗਪ੍ਰਕਾਸ਼ਿਤਸ਼੍ਮਸ਼ਾਨਵਾਦ੍ ਭਵਥ| ");
INSERT INTO sanpun_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ਤਦਾਨੀਂ ਵ੍ਯਵਸ੍ਥਾਪਕਾਨਾਮ੍ ਏਕਾ ਯੀਸ਼ੁਮਵਦਤ੍, ਹੇ ਉਪਦੇਸ਼ਕ ਵਾਕ੍ਯੇਨੇਦ੍ਰੁʼਸ਼ੇਨਾਸ੍ਮਾਸ੍ਵਪਿ ਦੋਸ਼਼ਮ੍ ਆਰੋਪਯਸਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ਤਤਃ ਸ ਉਵਾਚ, ਹਾ ਹਾ ਵ੍ਯਵਸ੍ਥਾਪਕਾ ਯੂਯਮ੍ ਮਾਨੁਸ਼਼ਾਣਾਮ੍ ਉਪਰਿ ਦੁਃਸਹ੍ਯਾਨ੍ ਭਾਰਾਨ੍ ਨ੍ਯਸ੍ਯਥ ਕਿਨ੍ਤੁ ਸ੍ਵਯਮ੍ ਏਕਾਙ੍ਗੁुਲ੍ਯਾਪਿ ਤਾਨ੍ ਭਾਰਾਨ੍ ਨ ਸ੍ਪ੍ਰੁʼਸ਼ਥ| ");
INSERT INTO sanpun_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","ਹਨ੍ਤ ਯੁਸ਼਼੍ਮਾਕੰ ਪੂਰ੍ੱਵਪੁਰੁਸ਼਼ਾ ਯਾਨ੍ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨੋ(ਅ)ਵਧਿਸ਼਼ੁਸ੍ਤੇਸ਼਼ਾਂ ਸ਼੍ਮਸ਼ਾਨਾਨਿ ਯੂਯੰ ਨਿਰ੍ੰਮਾਥ| ");
INSERT INTO sanpun_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","ਤੇਨੈਵ ਯੂਯੰ ਸ੍ਵਪੂਰ੍ੱਵਪੁਰੁਸ਼਼ਾਣਾਂ ਕਰ੍ੰਮਾਣਿ ਸੰਮਨ੍ਯਧ੍ਵੇ ਤਦੇਵ ਸਪ੍ਰਮਾਣੰ ਕੁਰੁਥ ਚ, ਯਤਸ੍ਤੇ ਤਾਨਵਧਿਸ਼਼ੁਃ ਯੂਯੰ ਤੇਸ਼਼ਾਂ ਸ਼੍ਮਸ਼ਾਨਾਨਿ ਨਿਰ੍ੰਮਾਥ| ");
INSERT INTO sanpun_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ਅਤਏਵ ਈਸ਼੍ਵਰਸ੍ਯ ਸ਼ਾਸ੍ਤ੍ਰੇ ਪ੍ਰੋਕ੍ਤਮਸ੍ਤਿ ਤੇਸ਼਼ਾਮਨ੍ਤਿਕੇ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਃ ਪ੍ਰੇਰਿਤਾਂਸ਼੍ਚ ਪ੍ਰੇਸ਼਼ਯਿਸ਼਼੍ਯਾਮਿ ਤਤਸ੍ਤੇ ਤੇਸ਼਼ਾਂ ਕਾਂਸ਼੍ਚਨ ਹਨਿਸ਼਼੍ਯਨ੍ਤਿ ਕਾਂਸ਼੍ਚਨ ਤਾਡਸ਼੍ਸ਼਼੍ਯਿਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ਏਤਸ੍ਮਾਤ੍ ਕਾਰਣਾਤ੍ ਹਾਬਿਲਃ ਸ਼ੋਣਿਤਪਾਤਮਾਰਭ੍ਯ ਮਨ੍ਦਿਰਯਜ੍ਞਵੇਦ੍ਯੋ ਰ੍ਮਧ੍ਯੇ ਹਤਸ੍ਯ ਸਿਖਰਿਯਸ੍ਯ ਰਕ੍ਤਪਾਤਪਰ੍ੱਯਨ੍ਤੰ ");
INSERT INTO sanpun_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ਜਗਤਃ ਸ੍ਰੁʼਸ਼਼੍ਟਿਮਾਰਭ੍ਯ ਪ੍ਰੁʼਥਿਵ੍ਯਾਂ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਾਂ ਯਤਿਰਕ੍ਤਪਾਤਾ ਜਾਤਾਸ੍ਤਤੀਨਾਮ੍ ਅਪਰਾਧਦਣ੍ਡਾ ਏਸ਼਼ਾਂ ਵਰ੍ੱਤਮਾਨਲੋਕਾਨਾਂ ਭਵਿਸ਼਼੍ਯਨ੍ਤਿ, ਯੁਸ਼਼੍ਮਾਨਹੰ ਨਿਸ਼੍ਚਿਤੰ ਵਦਾਮਿ ਸਰ੍ੱਵੇ ਦਣ੍ਡਾ ਵੰਸ਼ਸ੍ਯਾਸ੍ਯ ਭਵਿਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","ਹਾ ਹਾ ਵ੍ਯਵਸ੍ਥਪਕਾ ਯੂਯੰ ਜ੍ਞਾਨਸ੍ਯ ਕੁਞ੍ਚਿਕਾਂ ਹ੍ਰੁʼਤ੍ਵਾ ਸ੍ਵਯੰ ਨ ਪ੍ਰਵਿਸ਼਼੍ਟਾ ਯੇ ਪ੍ਰਵੇਸ਼਼੍ਟੁਞ੍ਚ ਪ੍ਰਯਾਸਿਨਸ੍ਤਾਨਪਿ ਪ੍ਰਵੇਸ਼਼੍ਟੁੰ ਵਾਰਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ਇੱਥੰ ਕਥਾਕਥਨਾਦ੍ ਅਧ੍ਯਾਪਕਾਃ ਫਿਰੂਸ਼ਿਨਸ਼੍ਚ ਸਤਰ੍ਕਾਃ ");
INSERT INTO sanpun_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ਸਨ੍ਤਸ੍ਤਮਪਵਦਿਤੁੰ ਤਸ੍ਯ ਕਥਾਯਾ ਦੋਸ਼਼ੰ ਧਰ੍ੱਤਮਿੱਛਨ੍ਤੋ ਨਾਨਾਖ੍ਯਾਨਕਥਨਾਯ ਤੰ ਪ੍ਰਵਰ੍ੱਤਯਿਤੁੰ ਕੋਪਯਿਤੁਞ੍ਚ ਪ੍ਰਾਰੇਭਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","ਤਦਾਨੀਂ ਲੋਕਾਃ ਸਹਸ੍ਰੰ ਸਹਸ੍ਰਮ੍ ਆਗਤ੍ਯ ਸਮੁਪਸ੍ਥਿਤਾਸ੍ਤਤ ਏਕੈਕੋ (ਅ)ਨ੍ਯੇਸ਼਼ਾਮੁਪਰਿ ਪਤਿਤੁਮ੍ ਉਪਚਕ੍ਰਮੇ; ਤਦਾ ਯੀਸ਼ੁਃ ਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਬਭਾਸ਼਼ੇ, ਯੂਯੰ ਫਿਰੂਸ਼ਿਨਾਂ ਕਿਣ੍ਵਰੂਪਕਾਪਟ੍ਯੇ ਵਿਸ਼ੇਸ਼਼ੇਣ ਸਾਵਧਾਨਾਸ੍ਤਿਸ਼਼੍ਠਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","ਯਤੋ ਯੰਨ ਪ੍ਰਕਾਸ਼ਯਿਸ਼਼੍ਯਤੇ ਤਦਾੱਛੰਨੰ ਵਸ੍ਤੁ ਕਿਮਪਿ ਨਾਸ੍ਤਿ; ਤਥਾ ਯੰਨ ਜ੍ਞਾਸ੍ਯਤੇ ਤਦ੍ ਗੁਪ੍ਤੰ ਵਸ੍ਤੁ ਕਿਮਪਿ ਨਾਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","ਅਨ੍ਧਕਾਰੇ ਤਿਸ਼਼੍ਠਨਤੋ ਯਾਃ ਕਥਾ ਅਕਥਯਤ ਤਾਃ ਸਰ੍ੱਵਾਃ ਕਥਾ ਦੀਪ੍ਤੌ ਸ਼੍ਰੋਸ਼਼੍ਯਨ੍ਤੇ ਨਿਰ੍ਜਨੇ ਕਰ੍ਣੇ ਚ ਯਦਕਥਯਤ ਗ੍ਰੁʼਹਪ੍ਰੁʼਸ਼਼੍ਠਾਤ੍ ਤਤ੍ ਪ੍ਰਚਾਰਯਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","ਹੇ ਬਨ੍ਧਵੋ ਯੁਸ਼਼੍ਮਾਨਹੰ ਵਦਾਮਿ, ਯੇ ਸ਼ਰੀਰਸ੍ਯ ਨਾਸ਼ੰ ਵਿਨਾ ਕਿਮਪ੍ਯਪਰੰ ਕਰ੍ੱਤੁੰ ਨ ਸ਼ਕ੍ਰੁਵਨ੍ਤਿ ਤੇਭ੍ਯੋ ਮਾ ਭੈਸ਼਼੍ਟ| ");
INSERT INTO sanpun_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","ਤਰ੍ਹਿ ਕਸ੍ਮਾਦ੍ ਭੇਤਵ੍ਯਮ੍ ਇਤ੍ਯਹੰ ਵਦਾਮਿ, ਯਃ ਸ਼ਰੀਰੰ ਨਾਸ਼ਯਿਤ੍ਵਾ ਨਰਕੰ ਨਿਕ੍ਸ਼਼ੇਪ੍ਤੁੰ ਸ਼ਕ੍ਨੋਤਿ ਤਸ੍ਮਾਦੇਵ ਭਯੰ ਕੁਰੁਤ, ਪੁਨਰਪਿ ਵਦਾਮਿ ਤਸ੍ਮਾਦੇਵ ਭਯੰ ਕੁਰੁਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","ਪਞ੍ਚ ਚਟਕਪਕ੍ਸ਼਼ਿਣਃ ਕਿੰ ਦ੍ਵਾਭ੍ਯਾਂ ਤਾਮ੍ਰਖਣ੍ਡਾਭ੍ਯਾਂ ਨ ਵਿਕ੍ਰੀਯਨ੍ਤੇ? ਤਥਾਪੀਸ਼੍ਵਰਸ੍ਤੇਸ਼਼ਾਮ੍ ਏਕਮਪਿ ਨ ਵਿਸ੍ਮਰਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","ਯੁਸ਼਼੍ਮਾਕੰ ਸ਼ਿਰਃਕੇਸ਼ਾ ਅਪਿ ਗਣਿਤਾਃ ਸਨ੍ਤਿ ਤਸ੍ਮਾਤ੍ ਮਾ ਵਿਭੀਤ ਬਹੁਚਟਕਪਕ੍ਸ਼਼ਿਭ੍ਯੋਪਿ ਯੂਯੰ ਬਹੁਮੂਲ੍ਯਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","ਅਪਰੰ ਯੁਸ਼਼੍ਮਭ੍ਯੰ ਕਥਯਾਮਿ ਯਃ ਕਸ਼੍ਚਿਨ੍ ਮਾਨੁਸ਼਼ਾਣਾਂ ਸਾਕ੍ਸ਼਼ਾਨ੍ ਮਾਂ ਸ੍ਵੀਕਰੋਤਿ ਮਨੁਸ਼਼੍ਯਪੁਤ੍ਰ ਈਸ਼੍ਵਰਦੂਤਾਨਾਂ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਤੰ ਸ੍ਵੀਕਰਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","ਕਿਨ੍ਤੁ ਯਃ ਕਸ਼੍ਚਿਨ੍ਮਾਨੁਸ਼਼ਾਣਾਂ ਸਾਕ੍ਸ਼਼ਾਨ੍ਮਾਮ੍ ਅਸ੍ਵੀਕਰੋਤਿ ਤਮ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਦੂਤਾਨਾਂ ਸਾਕ੍ਸ਼਼ਾਦ੍ ਅਹਮ੍ ਅਸ੍ਵੀਕਰਿਸ਼਼੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","ਅਨ੍ਯੱਚ ਯਃ ਕਸ਼੍ਚਿਨ੍ ਮਨੁਜਸੁਤਸ੍ਯ ਨਿਨ੍ਦਾਭਾਵੇਨ ਕਾਞ੍ਚਿਤ੍ ਕਥਾਂ ਕਥਯਤਿ ਤਸ੍ਯ ਤਤ੍ਪਾਪਸ੍ਯ ਮੋਚਨੰ ਭਵਿਸ਼਼੍ਯਤਿ ਕਿਨ੍ਤੁ ਯਦਿ ਕਸ਼੍ਚਿਤ੍ ਪਵਿਤ੍ਰਮ੍ ਆਤ੍ਮਾਨੰ ਨਿਨ੍ਦਤਿ ਤਰ੍ਹਿ ਤਸ੍ਯ ਤਤ੍ਪਾਪਸ੍ਯ ਮੋਚਨੰ ਨ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","ਯਦਾ ਲੋਕਾ ਯੁਸ਼਼੍ਮਾਨ੍ ਭਜਨਗੇਹੰ ਵਿਚਾਰਕਰ੍ਤ੍ਰੁʼਰਾਜ੍ਯਕਰ੍ਤ੍ਰੁʼਣਾਂ ਸੰਮੁਖਞ੍ਚ ਨੇਸ਼਼੍ਯਨ੍ਤਿ ਤਦਾ ਕੇਨ ਪ੍ਰਕਾਰੇਣ ਕਿਮੁੱਤਰੰ ਵਦਿਸ਼਼੍ਯਥ ਕਿੰ ਕਥਯਿਸ਼਼੍ਯਥ ਚੇਤ੍ਯਤ੍ਰ ਮਾ ਚਿਨ੍ਤਯਤ; ");
INSERT INTO sanpun_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ਯਤੋ ਯੁਸ਼਼੍ਮਾਭਿਰ੍ਯਦ੍ ਯਦ੍ ਵਕ੍ਤਵ੍ਯੰ ਤਤ੍ ਤਸ੍ਮਿਨ੍ ਸਮਯਏਵ ਪਵਿਤ੍ਰ ਆਤ੍ਮਾ ਯੁਸ਼਼੍ਮਾਨ੍ ਸ਼ਿਕ੍ਸ਼਼ਯਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ਤਤਃ ਪਰੰ ਜਨਤਾਮਧ੍ਯਸ੍ਥਃ ਕਸ਼੍ਚਿੱਜਨਸ੍ਤੰ ਜਗਾਦ ਹੇ ਗੁਰੋ ਮਯਾ ਸਹ ਪੈਤ੍ਰੁʼਕੰ ਧਨੰ ਵਿਭਕ੍ਤੁੰ ਮਮ ਭ੍ਰਾਤਰਮਾਜ੍ਞਾਪਯਤੁ ਭਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","ਕਿਨ੍ਤੁ ਸ ਤਮਵਦਤ੍ ਹੇ ਮਨੁਸ਼਼੍ਯ ਯੁਵਯੋ ਰ੍ਵਿਚਾਰੰ ਵਿਭਾਗਞ੍ਚ ਕਰ੍ੱਤੁੰ ਮਾਂ ਕੋ ਨਿਯੁਕ੍ਤਵਾਨ੍? ");
INSERT INTO sanpun_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ਅਨਨ੍ਤਰੰ ਸ ਲੋਕਾਨਵਦਤ੍ ਲੋਭੇ ਸਾਵਧਾਨਾਃ ਸਤਰ੍ਕਾਸ਼੍ਚ ਤਿਸ਼਼੍ਠਤ, ਯਤੋ ਬਹੁਸਮ੍ਪੱਤਿਪ੍ਰਾਪ੍ਤ੍ਯਾ ਮਨੁਸ਼਼੍ਯਸ੍ਯਾਯੁ ਰ੍ਨ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ਪਸ਼੍ਚਾਦ੍ ਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤਕਥਾਮੁੱਥਾਪ੍ਯ ਕਥਯਾਮਾਸ, ਏਕਸ੍ਯ ਧਨਿਨੋ ਭੂਮੌ ਬਹੂਨਿ ਸ਼ਸ੍ਯਾਨਿ ਜਾਤਾਨਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ਤਤਃ ਸ ਮਨਸਾ ਚਿਨ੍ਤਯਿਤ੍ਵਾ ਕਥਯਾਮ੍ਬਭੂਵ ਮਮੈਤਾਨਿ ਸਮੁਤ੍ਪੰਨਾਨਿ ਦ੍ਰਵ੍ਯਾਣਿ ਸ੍ਥਾਪਯਿਤੁੰ ਸ੍ਥਾਨੰ ਨਾਸ੍ਤਿ ਕਿੰ ਕਰਿਸ਼਼੍ਯਾਮਿ? ");
INSERT INTO sanpun_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ਤਤੋਵਦਦ੍ ਇੱਥੰ ਕਰਿਸ਼਼੍ਯਾਮਿ, ਮਮ ਸਰ੍ੱਵਭਾਣ੍ਡਾਗਾਰਾਣਿ ਭਙ੍ਕ੍ਤ੍ਵਾ ਬ੍ਰੁʼਹਦ੍ਭਾਣ੍ਡਾਗਾਰਾਣਿ ਨਿਰ੍ੰਮਾਯ ਤਨ੍ਮਧ੍ਯੇ ਸਰ੍ੱਵਫਲਾਨਿ ਦ੍ਰਵ੍ਯਾਣਿ ਚ ਸ੍ਥਾਪਯਿਸ਼਼੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ਅਪਰੰ ਨਿਜਮਨੋ ਵਦਿਸ਼਼੍ਯਾਮਿ, ਹੇ ਮਨੋ ਬਹੁਵਤ੍ਸਰਾਰ੍ਥੰ ਨਾਨਾਦ੍ਰਵ੍ਯਾਣਿ ਸਞ੍ਚਿਤਾਨਿ ਸਨ੍ਤਿ ਵਿਸ਼੍ਰਾਮੰ ਕੁਰੁ ਭੁਕ੍ਤ੍ਵਾ ਪੀਤ੍ਵਾ ਕੌਤੁਕਞ੍ਚ ਕੁਰੁ| ਕਿਨ੍ਤ੍ਵੀਸ਼੍ਵਰਸ੍ਤਮ੍ ਅਵਦਤ੍, ");
INSERT INTO sanpun_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","ਰੇ ਨਿਰ੍ਬੋਧ ਅਦ੍ਯ ਰਾਤ੍ਰੌ ਤਵ ਪ੍ਰਾਣਾਸ੍ਤ੍ਵੱਤੋ ਨੇਸ਼਼੍ਯਨ੍ਤੇ ਤਤ ਏਤਾਨਿ ਯਾਨਿ ਦ੍ਰਵ੍ਯਾਣਿ ਤ੍ਵਯਾਸਾਦਿਤਾਨਿ ਤਾਨਿ ਕਸ੍ਯ ਭਵਿਸ਼਼੍ਯਨ੍ਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","ਅਤਏਵ ਯਃ ਕਸ਼੍ਚਿਦ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਸਮੀਪੇ ਧਨਸਞ੍ਚਯਮਕ੍ਰੁʼਤ੍ਵਾ ਕੇਵਲੰ ਸ੍ਵਨਿਕਟੇ ਸਞ੍ਚਯੰ ਕਰੋਤਿ ਸੋਪਿ ਤਾਦ੍ਰੁʼਸ਼ਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","ਅਥ ਸ ਸ਼ਿਸ਼਼੍ਯੇਭ੍ਯਃ ਕਥਯਾਮਾਸ, ਯੁਸ਼਼੍ਮਾਨਹੰ ਵਦਾਮਿ, ਕਿੰ ਖਾਦਿਸ਼਼੍ਯਾਮਃ? ਕਿੰ ਪਰਿਧਾਸ੍ਯਾਮਃ? ਇਤ੍ਯੁਕ੍ਤ੍ਵਾ ਜੀਵਨਸ੍ਯ ਸ਼ਰੀਰਸ੍ਯ ਚਾਰ੍ਥੰ ਚਿਨ੍ਤਾਂ ਮਾ ਕਾਰ੍ਸ਼਼੍ਟ| ");
INSERT INTO sanpun_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ਭਕ੍ਸ਼਼੍ਯਾੱਜੀਵਨੰ ਭੂਸ਼਼ਣਾੱਛਰੀਰਞ੍ਚ ਸ਼੍ਰੇਸ਼਼੍ਠੰ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","ਕਾਕਪਕ੍ਸ਼਼ਿਣਾਂ ਕਾਰ੍ੱਯੰ ਵਿਚਾਰਯਤ, ਤੇ ਨ ਵਪਨ੍ਤਿ ਸ਼ਸ੍ਯਾਨਿ ਚ ਨ ਛਿਨ੍ਦਨ੍ਤਿ, ਤੇਸ਼਼ਾਂ ਭਾਣ੍ਡਾਗਾਰਾਣਿ ਨ ਸਨ੍ਤਿ ਕੋਸ਼਼ਾਸ਼੍ਚ ਨ ਸਨ੍ਤਿ, ਤਥਾਪੀਸ਼੍ਵਰਸ੍ਤੇਭ੍ਯੋ ਭਕ੍ਸ਼਼੍ਯਾਣਿ ਦਦਾਤਿ, ਯੂਯੰ ਪਕ੍ਸ਼਼ਿਭ੍ਯਃ ਸ਼੍ਰੇਸ਼਼੍ਠਤਰਾ ਨ ਕਿੰ? ");
INSERT INTO sanpun_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","ਅਪਰਞ੍ਚ ਭਾਵਯਿਤ੍ਵਾ ਨਿਜਾਯੁਸ਼਼ਃ ਕ੍ਸ਼਼ਣਮਾਤ੍ਰੰ ਵਰ੍ੱਧਯਿਤੁੰ ਸ਼ਕ੍ਨੋਤਿ, ਏਤਾਦ੍ਰੁʼਸ਼ੋ ਲਾਕੋ ਯੁਸ਼਼੍ਮਾਕੰ ਮਧ੍ਯੇ ਕੋਸ੍ਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","ਅਤਏਵ ਕ੍ਸ਼਼ੁਦ੍ਰੰ ਕਾਰ੍ੱਯੰ ਸਾਧਯਿਤੁਮ੍ ਅਸਮਰ੍ਥਾ ਯੂਯਮ੍ ਅਨ੍ਯਸ੍ਮਿਨ੍ ਕਾਰ੍ੱਯੇ ਕੁਤੋ ਭਾਵਯਥ? ");
INSERT INTO sanpun_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","ਅਨ੍ਯੱਚ ਕਾਮ੍ਪਿਲਪੁਸ਼਼੍ਪੰ ਕਥੰ ਵਰ੍ੱਧਤੇ ਤਦਾਪਿ ਵਿਚਾਰਯਤ, ਤਤ੍ ਕਞ੍ਚਨ ਸ਼੍ਰਮੰ ਨ ਕਰੋਤਿ ਤਨ੍ਤੂੰਸ਼੍ਚ ਨ ਜਨਯਤਿ ਕਿਨ੍ਤੁ ਯੁਸ਼਼੍ਮਭ੍ਯੰ ਯਥਾਰ੍ਥੰ ਕਥਯਾਮਿ ਸੁਲੇਮਾਨ੍ ਬਹ੍ਵੈਸ਼੍ਵਰ੍ੱਯਾਨ੍ਵਿਤੋਪਿ ਪੁਸ਼਼੍ਪਸ੍ਯਾਸ੍ਯ ਸਦ੍ਰੁʼਸ਼ੋ ਵਿਭੂਸ਼਼ਿਤੋ ਨਾਸੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ਅਦ੍ਯ ਕ੍ਸ਼਼ੇਤ੍ਰੇ ਵਰ੍ੱਤਮਾਨੰ ਸ਼੍ਵਸ਼੍ਚੂੱਲ੍ਯਾਂ ਕ੍ਸ਼਼ੇਪ੍ਸ੍ਯਮਾਨੰ ਯਤ੍ ਤ੍ਰੁʼਣੰ, ਤਸ੍ਮੈ ਯਦੀਸ਼੍ਵਰ ਇੱਥੰ ਭੂਸ਼਼ਯਤਿ ਤਰ੍ਹਿ ਹੇ ਅਲ੍ਪਪ੍ਰਤ੍ਯਯਿਨੋ ਯੁਸ਼਼੍ਮਾਨ ਕਿੰ ਨ ਪਰਿਧਾਪਯਿਸ਼਼੍ਯਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","ਅਤਏਵ ਕਿੰ ਖਾਦਿਸ਼਼੍ਯਾਮਃ? ਕਿੰ ਪਰਿਧਾਸ੍ਯਾਮਃ? ਏਤਦਰ੍ਥੰ ਮਾ ਚੇਸ਼਼੍ਟਧ੍ਵੰ ਮਾ ਸੰਦਿਗ੍ਧ੍ਵਞ੍ਚ| ");
INSERT INTO sanpun_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ਜਗਤੋ ਦੇਵਾਰ੍ੱਚਕਾ ਏਤਾਨਿ ਸਰ੍ੱਵਾਣਿ ਚੇਸ਼਼੍ਟਨਤੇ; ਏਸ਼਼ੁ ਵਸ੍ਤੁਸ਼਼ੁ ਯੁਸ਼਼੍ਮਾਕੰ ਪ੍ਰਯੋਜਨਮਾਸ੍ਤੇ ਇਤਿ ਯੁਸ਼਼੍ਮਾਕੰ ਪਿਤਾ ਜਾਨਾਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","ਅਤਏਵੇਸ਼੍ਵਰਸ੍ਯ ਰਾਜ੍ਯਾਰ੍ਥੰ ਸਚੇਸ਼਼੍ਟਾ ਭਵਤ ਤਥਾ ਕ੍ਰੁʼਤੇ ਸਰ੍ੱਵਾਣ੍ਯੇਤਾਨਿ ਦ੍ਰਵ੍ਯਾਣਿ ਯੁਸ਼਼੍ਮਭ੍ਯੰ ਪ੍ਰਦਾਯਿਸ਼਼੍ਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","ਹੇ ਕ੍ਸ਼਼ੁਦ੍ਰਮੇਸ਼਼ਵ੍ਰਜ ਯੂਯੰ ਮਾ ਭੈਸ਼਼੍ਟ ਯੁਸ਼਼੍ਮਭ੍ਯੰ ਰਾਜ੍ਯੰ ਦਾਤੁੰ ਯੁਸ਼਼੍ਮਾਕੰ ਪਿਤੁਃ ਸੰਮਤਿਰਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ਅਤਏਵ ਯੁਸ਼਼੍ਮਾਕੰ ਯਾ ਯਾ ਸਮ੍ਪੱਤਿਰਸ੍ਤਿ ਤਾਂ ਤਾਂ ਵਿਕ੍ਰੀਯ ਵਿਤਰਤ, ਯਤ੍ ਸ੍ਥਾਨੰ ਚੌਰਾ ਨਾਗੱਛਨ੍ਤਿ, ਕੀਟਾਸ਼੍ਚ ਨ ਕ੍ਸ਼਼ਾਯਯਨ੍ਤਿ ਤਾਦ੍ਰੁʼਸ਼ੇ ਸ੍ਵਰ੍ਗੇ ਨਿਜਾਰ੍ਥਮ੍ ਅਜਰੇ ਸਮ੍ਪੁਟਕੇ (ਅ)ਕ੍ਸ਼਼ਯੰ ਧਨੰ ਸਞ੍ਚਿਨੁਤ ਚ; ");
INSERT INTO sanpun_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","ਯਤੋ ਯਤ੍ਰ ਯੁਸ਼਼੍ਮਾਕੰ ਧਨੰ ਵਰ੍ੱਤਤੇ ਤਤ੍ਰੇਵ ਯੁਸ਼਼੍ਮਾਕੰ ਮਨਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","ਅਪਰਞ੍ਚ ਯੂਯੰ ਪ੍ਰਦੀਪੰ ਜ੍ਵਾਲਯਿਤ੍ਵਾ ਬੱਧਕਟਯਸ੍ਤਿਸ਼਼੍ਠਤ; ");
INSERT INTO sanpun_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ਪ੍ਰਭੁ ਰ੍ਵਿਵਾਹਾਦਾਗਤ੍ਯ ਯਦੈਵ ਦ੍ਵਾਰਮਾਹਨ੍ਤਿ ਤਦੈਵ ਦ੍ਵਾਰੰ ਮੋਚਯਿਤੁੰ ਯਥਾ ਭ੍ਰੁʼਤ੍ਯਾ ਅਪੇਕ੍ਸ਼਼੍ਯ ਤਿਸ਼਼੍ਠਨ੍ਤਿ ਤਥਾ ਯੂਯਮਪਿ ਤਿਸ਼਼੍ਠਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ਯਤਃ ਪ੍ਰਭੁਰਾਗਤ੍ਯ ਯਾਨ੍ ਦਾਸਾਨ੍ ਸਚੇਤਨਾਨ੍ ਤਿਸ਼਼੍ਠਤੋ ਦ੍ਰਕ੍ਸ਼਼੍ਯਤਿ ਤਏਵ ਧਨ੍ਯਾਃ; ਅਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਯਥਾਰ੍ਥੰ ਵਦਾਮਿ ਪ੍ਰਭੁਸ੍ਤਾਨ੍ ਭੋਜਨਾਰ੍ਥਮ੍ ਉਪਵੇਸ਼੍ਯ ਸ੍ਵਯੰ ਬੱਧਕਟਿਃ ਸਮੀਪਮੇਤ੍ਯ ਪਰਿਵੇਸ਼਼ਯਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ਯਦਿ ਦ੍ਵਿਤੀਯੇ ਤ੍ਰੁʼਤੀਯੇ ਵਾ ਪ੍ਰਹਰੇ ਸਮਾਗਤ੍ਯ ਤਥੈਵ ਪਸ਼੍ਯਤਿ, ਤਰ੍ਹਿ ਤਏਵ ਦਾਸਾ ਧਨ੍ਯਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","ਅਪਰਞ੍ਚ ਕਸ੍ਮਿਨ੍ ਕ੍ਸ਼਼ਣੇ ਚੌਰਾ ਆਗਮਿਸ਼਼੍ਯਨ੍ਤਿ ਇਤਿ ਯਦਿ ਗ੍ਰੁʼਹਪਤਿ ਰ੍ਜ੍ਞਾਤੁੰ ਸ਼ਕ੍ਨੋਤਿ ਤਦਾਵਸ਼੍ਯੰ ਜਾਗ੍ਰਨ੍ ਨਿਜਗ੍ਰੁʼਹੇ ਸਨ੍ਧਿੰ ਕਰ੍ੱਤਯਿਤੁੰ ਵਾਰਯਤਿ ਯੂਯਮੇਤਦ੍ ਵਿੱਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","ਅਤਏਵ ਯੂਯਮਪਿ ਸੱਜਮਾਨਾਸ੍ਤਿਸ਼਼੍ਠਤ ਯਤੋ ਯਸ੍ਮਿਨ੍ ਕ੍ਸ਼਼ਣੇ ਤੰ ਨਾਪ੍ਰੇਕ੍ਸ਼਼ਧ੍ਵੇ ਤਸ੍ਮਿੰਨੇਵ ਕ੍ਸ਼਼ਣੇ ਮਨੁਸ਼਼੍ਯਪੁਤ੍ਰ ਆਗਮਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ਤਦਾ ਪਿਤਰਃ ਪਪ੍ਰੱਛ, ਹੇ ਪ੍ਰਭੋ ਭਵਾਨ੍ ਕਿਮਸ੍ਮਾਨ੍ ਉੱਦਿਸ਼੍ਯ ਕਿੰ ਸਰ੍ੱਵਾਨ੍ ਉੱਦਿਸ਼੍ਯ ਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤਕਥਾਮਿਮਾਂ ਵਦਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ਤਤਃ ਪ੍ਰਭੁਃ ਪ੍ਰੋਵਾਚ, ਪ੍ਰਭੁਃ ਸਮੁਚਿਤਕਾਲੇ ਨਿਜਪਰਿਵਾਰਾਰ੍ਥੰ ਭੋਜ੍ਯਪਰਿਵੇਸ਼਼ਣਾਯ ਯੰ ਤਤ੍ਪਦੇ ਨਿਯੋਕ੍ਸ਼਼੍ਯਤਿ ਤਾਦ੍ਰੁʼਸ਼ੋ ਵਿਸ਼੍ਵਾਸ੍ਯੋ ਬੋੱਧਾ ਕਰ੍ੰਮਾਧੀਸ਼ਃ ਕੋਸ੍ਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ਪ੍ਰਭੁਰਾਗਤ੍ਯ ਯਮ੍ ਏਤਾਦ੍ਰੁʼਸ਼ੇ ਕਰ੍ੰਮਣਿ ਪ੍ਰਵ੍ਰੁʼੱਤੰ ਦ੍ਰਕ੍ਸ਼਼੍ਯਤਿ ਸਏਵ ਦਾਸੋ ਧਨ੍ਯਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ਅਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਯਥਾਰ੍ਥੰ ਵਦਾਮਿ ਸ ਤੰ ਨਿਜਸਰ੍ੱਵਸ੍ਵਸ੍ਯਾਧਿਪਤਿੰ ਕਰਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","ਕਿਨ੍ਤੁ ਪ੍ਰਭੁਰ੍ਵਿਲਮ੍ਬੇਨਾਗਮਿਸ਼਼੍ਯਤਿ, ਇਤਿ ਵਿਚਿਨ੍ਤ੍ਯ ਸ ਦਾਸੋ ਯਦਿ ਤਦਨ੍ਯਦਾਸੀਦਾਸਾਨ੍ ਪ੍ਰਹਰ੍ੱਤੁਮ੍ ਭੋਕ੍ਤੁੰ ਪਾਤੁੰ ਮਦਿਤੁਞ੍ਚ ਪ੍ਰਾਰਭਤੇ, ");
INSERT INTO sanpun_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ਤਰ੍ਹਿ ਯਦਾ ਪ੍ਰਭੁੰ ਨਾਪੇਕ੍ਸ਼਼ਿਸ਼਼੍ਯਤੇ ਯਸ੍ਮਿਨ੍ ਕ੍ਸ਼਼ਣੇ ਸੋ(ਅ)ਚੇਤਨਸ਼੍ਚ ਸ੍ਥਾਸ੍ਯਤਿ ਤਸ੍ਮਿੰਨੇਵ ਕ੍ਸ਼਼ਣੇ ਤਸ੍ਯ ਪ੍ਰਭੁਰਾਗਤ੍ਯ ਤੰ ਪਦਭ੍ਰਸ਼਼੍ਟੰ ਕ੍ਰੁʼਤ੍ਵਾ ਵਿਸ਼੍ਵਾਸਹੀਨੈਃ ਸਹ ਤਸ੍ਯ ਅੰਸ਼ੰ ਨਿਰੂਪਯਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","ਯੋ ਦਾਸਃ ਪ੍ਰਭੇाਰਾਜ੍ਞਾਂ ਜ੍ਞਾਤ੍ਵਾਪਿ ਸੱਜਿਤੋ ਨ ਤਿਸ਼਼੍ਠਤਿ ਤਦਾਜ੍ਞਾਨੁਸਾਰੇਣ ਚ ਕਾਰ੍ੱਯੰ ਨ ਕਰੋਤਿ ਸੋਨੇਕਾਨ੍ ਪ੍ਰਹਾਰਾਨ੍ ਪ੍ਰਾਪ੍ਸ੍ਯਤਿ; ");
INSERT INTO sanpun_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","ਕਿਨ੍ਤੁ ਯੋ ਜਨੋ(ਅ)ਜ੍ਞਾਤ੍ਵਾ ਪ੍ਰਹਾਰਾਰ੍ਹੰ ਕਰ੍ੰਮ ਕਰੋਤਿ ਸੋਲ੍ਪਪ੍ਰਹਾਰਾਨ੍ ਪ੍ਰਾਪ੍ਸ੍ਯਤਿ| ਯਤੋ ਯਸ੍ਮੈ ਬਾਹੁਲ੍ਯੇਨ ਦੱਤੰ ਤਸ੍ਮਾਦੇਵ ਬਾਹੁਲ੍ਯੇਨ ਗ੍ਰਹੀਸ਼਼੍ਯਤੇ, ਮਾਨੁਸ਼਼ਾ ਯਸ੍ਯ ਨਿਕਟੇ ਬਹੁ ਸਮਰ੍ਪਯਨ੍ਤਿ ਤਸ੍ਮਾਦ੍ ਬਹੁ ਯਾਚਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","ਅਹੰ ਪ੍ਰੁʼਥਿਵ੍ਯਾਮ੍ ਅਨੈਕ੍ਯਰੂਪੰ ਵਹ੍ਨਿ ਨਿਕ੍ਸ਼਼ੇਪ੍ਤੁਮ੍ ਆਗਤੋਸ੍ਮਿ, ਸ ਚੇਦ੍ ਇਦਾਨੀਮੇਵ ਪ੍ਰਜ੍ਵਲਤਿ ਤਤ੍ਰ ਮਮ ਕਾ ਚਿਨ੍ਤਾ? ");
INSERT INTO sanpun_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","ਕਿਨ੍ਤੁ ਯੇਨ ਮੱਜਨੇਨਾਹੰ ਮਗ੍ਨੋ ਭਵਿਸ਼਼੍ਯਾਮਿ ਯਾਵਤ੍ਕਾਲੰ ਤਸ੍ਯ ਸਿੱਧਿ ਰ੍ਨ ਭਵਿਸ਼਼੍ਯਤਿ ਤਾਵਦਹੰ ਕਤਿਕਸ਼਼੍ਟੰ ਪ੍ਰਾਪ੍ਸ੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","ਮੇਲਨੰ ਕਰ੍ੱਤੁੰ ਜਗਦ੍ ਆਗਤੋਸ੍ਮਿ ਯੂਯੰ ਕਿਮਿੱਥੰ ਬੋਧਧ੍ਵੇ? ਯੁਸ਼਼੍ਮਾਨ੍ ਵਦਾਮਿ ਨ ਤਥਾ, ਕਿਨ੍ਤ੍ਵਹੰ ਮੇਲਨਾਭਾਵੰ ਕਰ੍ੱਤੁੰਮ੍ ਆਗਤੋਸ੍ਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ਯਸ੍ਮਾਦੇਤਤ੍ਕਾਲਮਾਰਭ੍ਯ ਏਕਤ੍ਰਸ੍ਥਪਰਿਜਨਾਨਾਂ ਮਧ੍ਯੇ ਪਞ੍ਚਜਨਾਃ ਪ੍ਰੁʼਥਗ੍ ਭੂਤ੍ਵਾ ਤ੍ਰਯੋ ਜਨਾ ਦ੍ਵਯੋਰ੍ਜਨਯੋਃ ਪ੍ਰਤਿਕੂਲਾ ਦ੍ਵੌ ਜਨੌ ਚ ਤ੍ਰਯਾਣਾਂ ਜਨਾਨਾਂ ਪ੍ਰਤਿਕੂਲੌ ਭਵਿਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","ਪਿਤਾ ਪੁਤ੍ਰਸ੍ਯ ਵਿਪਕ੍ਸ਼਼ਃ ਪੁਤ੍ਰਸ਼੍ਚ ਪਿਤੁ ਰ੍ਵਿਪਕ੍ਸ਼਼ੋ ਭਵਿਸ਼਼੍ਯਤਿ ਮਾਤਾ ਕਨ੍ਯਾਯਾ ਵਿਪਕ੍ਸ਼਼ਾ ਕਨ੍ਯਾ ਚ ਮਾਤੁ ਰ੍ਵਿਪਕ੍ਸ਼਼ਾ ਭਵਿਸ਼਼੍ਯਤਿ, ਤਥਾ ਸ਼੍ਵਸ਼੍ਰੂਰ੍ਬਧ੍ਵਾ ਵਿਪਕ੍ਸ਼਼ਾ ਬਧੂਸ਼੍ਚ ਸ਼੍ਵਸ਼੍ਰ੍ਵਾ ਵਿਪਕ੍ਸ਼਼ਾ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ਸ ਲੋਕੇਭ੍ਯੋਪਰਮਪਿ ਕਥਯਾਮਾਸ, ਪਸ਼੍ਚਿਮਦਿਸ਼ਿ ਮੇਘੋਦ੍ਗਮੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਯੂਯੰ ਹਠਾਦ੍ ਵਦਥ ਵ੍ਰੁʼਸ਼਼੍ਟਿ ਰ੍ਭਵਿਸ਼਼੍ਯਤਿ ਤਤਸ੍ਤਥੈਵ ਜਾਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","ਅਪਰੰ ਦਕ੍ਸ਼਼ਿਣਤੋ ਵਾਯੌ ਵਾਤਿ ਸਤਿ ਵਦਥ ਨਿਦਾਘੋ ਭਵਿਸ਼਼੍ਯਤਿ ਤਤਃ ਸੋਪਿ ਜਾਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ਰੇ ਰੇ ਕਪਟਿਨ ਆਕਾਸ਼ਸ੍ਯ ਭੂਮ੍ਯਾਸ਼੍ਚ ਲਕ੍ਸ਼਼ਣੰ ਬੋੱਧੁੰ ਸ਼ਕ੍ਨੁਥ, ");
INSERT INTO sanpun_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","ਕਿਨ੍ਤੁ ਕਾਲਸ੍ਯਾਸ੍ਯ ਲਕ੍ਸ਼਼ਣੰ ਕੁਤੋ ਬੋੱਧੁੰ ਨ ਸ਼ਕ੍ਨੁਥ? ਯੂਯਞ੍ਚ ਸ੍ਵਯੰ ਕੁਤੋ ਨ ਨ੍ਯਾਸ਼਼੍ਯੰ ਵਿਚਾਰਯਥ? ");
INSERT INTO sanpun_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","ਅਪਰਞ੍ਚ ਵਿਵਾਦਿਨਾ ਸਾਰ੍ੱਧੰ ਵਿਚਾਰਯਿਤੁਃ ਸਮੀਪੰ ਗੱਛਨ੍ ਪਥਿ ਤਸ੍ਮਾਦੁੱਧਾਰੰ ਪ੍ਰਾਪ੍ਤੁੰ ਯਤਸ੍ਵ ਨੋਚੇਤ੍ ਸ ਤ੍ਵਾਂ ਧ੍ਰੁʼਤ੍ਵਾ ਵਿਚਾਰਯਿਤੁਃ ਸਮੀਪੰ ਨਯਤਿ| ਵਿਚਾਰਯਿਤਾ ਯਦਿ ਤ੍ਵਾਂ ਪ੍ਰਹਰ੍ੱਤੁਃ ਸਮੀਪੰ ਸਮਰ੍ਪਯਤਿ ਪ੍ਰਹਰ੍ੱਤਾ ਤ੍ਵਾਂ ਕਾਰਾਯਾਂ ਬਧ੍ਨਾਤਿ ");
INSERT INTO sanpun_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","ਤਰ੍ਹਿ ਤ੍ਵਾਮਹੰ ਵਦਾਮਿ ਤ੍ਵਯਾ ਨਿਃਸ਼ੇਸ਼਼ੰ ਕਪਰ੍ਦਕੇਸ਼਼ੁ ਨ ਪਰਿਸ਼ੋਧਿਤੇਸ਼਼ੁ ਤ੍ਵੰ ਤਤੋ ਮੁਕ੍ਤਿੰ ਪ੍ਰਾਪ੍ਤੁੰ ਨ ਸ਼ਕ੍ਸ਼਼੍ਯਸਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","ਅਪਰਞ੍ਚ ਪੀਲਾਤੋ ਯੇਸ਼਼ਾਂ ਗਾਲੀਲੀਯਾਨਾਂ ਰਕ੍ਤਾਨਿ ਬਲੀਨਾਂ ਰਕ੍ਤੈਃ ਸਹਾਮਿਸ਼੍ਰਯਤ੍ ਤੇਸ਼਼ਾਂ ਗਾਲੀਲੀਯਾਨਾਂ ਵ੍ਰੁʼੱਤਾਨ੍ਤੰ ਕਤਿਪਯਜਨਾ ਉਪਸ੍ਥਾਪ੍ਯ ਯੀਸ਼ਵੇ ਕਥਯਾਮਾਸੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ਤਤਃ ਸ ਪ੍ਰਤ੍ਯੁਵਾਚ ਤੇਸ਼਼ਾਂ ਲੋਕਾਨਾਮ੍ ਏਤਾਦ੍ਰੁʼਸ਼ੀ ਦੁਰ੍ਗਤਿ ਰ੍ਘਟਿਤਾ ਤਤ੍ਕਾਰਣਾਦ੍ ਯੂਯੰ ਕਿਮਨ੍ਯੇਭ੍ਯੋ ਗਾਲੀਲੀਯੇਭ੍ਯੋਪ੍ਯਧਿਕਪਾਪਿਨਸ੍ਤਾਨ੍ ਬੋਧਧ੍ਵੇ? ");
INSERT INTO sanpun_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","ਯੁਸ਼਼੍ਮਾਨਹੰ ਵਦਾਮਿ ਤਥਾ ਨ ਕਿਨ੍ਤੁ ਮਨਃਸੁ ਨ ਪਰਾਵਰ੍ੱਤਿਤੇਸ਼਼ੁ ਯੂਯਮਪਿ ਤਥਾ ਨੰਕ੍ਸ਼਼੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","ਅਪਰਞ੍ਚ ਸ਼ੀਲੋਹਨਾਮ੍ਨ ਉੱਚਗ੍ਰੁʼਹਸ੍ਯ ਪਤਨਾਦ੍ ਯੇ(ਅ)ਸ਼਼੍ਟਾਦਸ਼ਜਨਾ ਮ੍ਰੁʼਤਾਸ੍ਤੇ ਯਿਰੂਸ਼ਾਲਮਿ ਨਿਵਾਸਿਸਰ੍ੱਵਲੋਕੇਭ੍ਯੋ(ਅ)ਧਿਕਾਪਰਾਧਿਨਃ ਕਿੰ ਯੂਯਮਿਤ੍ਯੰ ਬੋਧਧ੍ਵੇ? ");
INSERT INTO sanpun_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","ਯੁਸ਼਼੍ਮਾਨਹੰ ਵਦਾਮਿ ਤਥਾ ਨ ਕਿਨ੍ਤੁ ਮਨਃਸੁ ਨ ਪਰਿਵਰ੍ੱਤਿਤੇਸ਼਼ੁ ਯੂਯਮਪਿ ਤਥਾ ਨੰਕ੍ਸ਼਼੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ਅਨਨ੍ਤਰੰ ਸ ਇਮਾਂ ਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤਕਥਾਮਕਥਯਦ੍ ਏਕੋ ਜਨੋ ਦ੍ਰਾਕ੍ਸ਼਼ਾਕ੍ਸ਼਼ੇਤ੍ਰਮਧ੍ਯ ਏਕਮੁਡੁਮ੍ਬਰਵ੍ਰੁʼਕ੍ਸ਼਼ੰ ਰੋਪਿਤਵਾਨ੍| ਪਸ਼੍ਚਾਤ੍ ਸ ਆਗਤ੍ਯ ਤਸ੍ਮਿਨ੍ ਫਲਾਨਿ ਗਵੇਸ਼਼ਯਾਮਾਸ, ");
INSERT INTO sanpun_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","ਕਿਨ੍ਤੁ ਫਲਾਪ੍ਰਾਪ੍ਤੇਃ ਕਾਰਣਾਦ੍ ਉਦ੍ਯਾਨਕਾਰੰ ਭ੍ਰੁʼਤ੍ਯੰ ਜਗਾਦ, ਪਸ਼੍ਯ ਵਤ੍ਸਰਤ੍ਰਯੰ ਯਾਵਦਾਗਤ੍ਯ ਏਤਸ੍ਮਿੰਨੁਡੁਮ੍ਬਰਤਰੌ ਕ੍ਸ਼਼ਲਾਨ੍ਯਨ੍ਵਿੱਛਾਮਿ, ਕਿਨ੍ਤੁ ਨੈਕਮਪਿ ਪ੍ਰਪ੍ਨੋਮਿ ਤਰੁਰਯੰ ਕੁਤੋ ਵ੍ਰੁʼਥਾ ਸ੍ਥਾਨੰ ਵ੍ਯਾਪ੍ਯ ਤਿਸ਼਼੍ਠਤਿ? ਏਨੰ ਛਿਨ੍ਧਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ਤਤੋ ਭ੍ਰੁʼਤ੍ਯਃ ਪ੍ਰਤ੍ਯੁਵਾਚ, ਹੇ ਪ੍ਰਭੋ ਪੁਨਰ੍ਵਰ੍ਸ਼਼ਮੇਕੰ ਸ੍ਥਾਤੁਮ੍ ਆਦਿਸ਼; ਏਤਸ੍ਯ ਮੂਲਸ੍ਯ ਚਤੁਰ੍ਦਿਕ੍ਸ਼਼ੁ ਖਨਿਤ੍ਵਾਹਮ੍ ਆਲਵਾਲੰ ਸ੍ਥਾਪਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ਤਤਃ ਫਲਿਤੁੰ ਸ਼ਕ੍ਨੋਤਿ ਯਦਿ ਨ ਫਲਤਿ ਤਰ੍ਹਿ ਪਸ਼੍ਚਾਤ੍ ਛੇਤ੍ਸ੍ਯਸਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","ਅਥ ਵਿਸ਼੍ਰਾਮਵਾਰੇ ਭਜਨਗੇਹੇ ਯੀਸ਼ੁਰੁਪਦਿਸ਼ਤਿ ");
INSERT INTO sanpun_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ਤਸ੍ਮਿਤ੍ ਸਮਯੇ ਭੂਤਗ੍ਰਸ੍ਤਤ੍ਵਾਤ੍ ਕੁਬ੍ਜੀਭੂਯਾਸ਼਼੍ਟਾਦਸ਼ਵਰ੍ਸ਼਼ਾਣਿ ਯਾਵਤ੍ ਕੇਨਾਪ੍ਯੁਪਾਯੇਨ ਰੁʼਜੁ ਰ੍ਭਵਿਤੁੰ ਨ ਸ਼ਕ੍ਨੋਤਿ ਯਾ ਦੁਰ੍ੱਬਲਾ ਸ੍ਤ੍ਰੀ, ");
INSERT INTO sanpun_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ਤਾਂ ਤਤ੍ਰੋਪਸ੍ਥਿਤਾਂ ਵਿਲੋਕ੍ਯ ਯੀਸ਼ੁਸ੍ਤਾਮਾਹੂਯ ਕਥਿਤਵਾਨ੍ ਹੇ ਨਾਰਿ ਤਵ ਦੌਰ੍ੱਬਲ੍ਯਾਤ੍ ਤ੍ਵੰ ਮੁਕ੍ਤਾ ਭਵ| ");
INSERT INTO sanpun_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ਤਤਃ ਪਰੰ ਤਸ੍ਯਾ ਗਾਤ੍ਰੇ ਹਸ੍ਤਾਰ੍ਪਣਮਾਤ੍ਰਾਤ੍ ਸਾ ਰੁʼਜੁਰ੍ਭੂਤ੍ਵੇਸ਼੍ਵਰਸ੍ਯ ਧਨ੍ਯਵਾਦੰ ਕਰ੍ੱਤੁਮਾਰੇਭੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","ਕਿਨ੍ਤੁ ਵਿਸ਼੍ਰਾਮਵਾਰੇ ਯੀਸ਼ੁਨਾ ਤਸ੍ਯਾਃ ਸ੍ਵਾਸ੍ਥ੍ਯਕਰਣਾਦ੍ ਭਜਨਗੇਹਸ੍ਯਾਧਿਪਤਿਃ ਪ੍ਰਕੁਪ੍ਯ ਲੋਕਾਨ੍ ਉਵਾਚ, ਸ਼਼ਟ੍ਸੁ ਦਿਨੇਸ਼਼ੁ ਲੋਕੈਃ ਕਰ੍ੰਮ ਕਰ੍ੱਤਵ੍ਯੰ ਤਸ੍ਮਾੱਧੇਤੋਃ ਸ੍ਵਾਸ੍ਥ੍ਯਾਰ੍ਥੰ ਤੇਸ਼਼ੁ ਦਿਨੇਸ਼਼ੁ ਆਗੱਛਤ, ਵਿਸ਼੍ਰਾਮਵਾਰੇ ਮਾਗੱਛਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ਤਦਾ ਪਭੁਃ ਪ੍ਰਤ੍ਯੁਵਾਚ ਰੇ ਕਪਟਿਨੋ ਯੁਸ਼਼੍ਮਾਕਮ੍ ਏਕੈਕੋ ਜਨੋ ਵਿਸ਼੍ਰਾਮਵਾਰੇ ਸ੍ਵੀਯੰ ਸ੍ਵੀਯੰ ਵ੍ਰੁʼਸ਼਼ਭੰ ਗਰ੍ਦਭੰ ਵਾ ਬਨ੍ਧਨਾਨ੍ਮੋਚਯਿਤ੍ਵਾ ਜਲੰ ਪਾਯਯਿਤੁੰ ਕਿੰ ਨ ਨਯਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","ਤਰ੍ਹ੍ਯਾਸ਼਼੍ਟਾਦਸ਼ਵਤ੍ਸਰਾਨ੍ ਯਾਵਤ੍ ਸ਼ੈਤਾਨਾ ਬੱਧਾ ਇਬ੍ਰਾਹੀਮਃ ਸਨ੍ਤਤਿਰਿਯੰ ਨਾਰੀ ਕਿੰ ਵਿਸ਼੍ਰਾਮਵਾਰੇ ਨ ਮੋਚਯਿਤਵ੍ਯਾ? ");
INSERT INTO sanpun_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ਏਸ਼਼ੁ ਵਾਕ੍ਯੇਸ਼਼ੁ ਕਥਿਤੇਸ਼਼ੁ ਤਸ੍ਯ ਵਿਪਕ੍ਸ਼਼ਾਃ ਸਲੱਜਾ ਜਾਤਾਃ ਕਿਨ੍ਤੁ ਤੇਨ ਕ੍ਰੁʼਤਸਰ੍ੱਵਮਹਾਕਰ੍ੰਮਕਾਰਣਾਤ੍ ਲੋਕਨਿਵਹਃ ਸਾਨਨ੍ਦੋ(ਅ)ਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ਅਨਨ੍ਤਰੰ ਸੋਵਦਦ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਰਾਜ੍ਯੰ ਕਸ੍ਯ ਸਦ੍ਰੁʼਸ਼ੰ? ਕੇਨ ਤਦੁਪਮਾਸ੍ਯਾਮਿ? ");
INSERT INTO sanpun_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ਯਤ੍ ਸਰ੍ਸ਼਼ਪਬੀਜੰ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਕਸ਼੍ਚਿੱਜਨ ਉਦ੍ਯਾਨ ਉਪ੍ਤਵਾਨ੍ ਤਦ੍ ਬੀਜਮਙ੍ਕੁਰਿਤੰ ਸਤ੍ ਮਹਾਵ੍ਰੁʼਕ੍ਸ਼਼ੋ(ਅ)ਜਾਯਤ, ਤਤਸ੍ਤਸ੍ਯ ਸ਼ਾਖਾਸੁ ਵਿਹਾਯਸੀਯਵਿਹਗਾ ਆਗਤ੍ਯ ਨ੍ਯੂਸ਼਼ੁਃ, ਤਦ੍ਰਾਜ੍ਯੰ ਤਾਦ੍ਰੁʼਸ਼ੇਨ ਸਰ੍ਸ਼਼ਪਬੀਜੇਨ ਤੁਲ੍ਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ਪੁਨਃ ਕਥਯਾਮਾਸ, ਈਸ਼੍ਵਰਸ੍ਯ ਰਾਜ੍ਯੰ ਕਸ੍ਯ ਸਦ੍ਰੁʼਸ਼ੰ ਵਦਿਸ਼਼੍ਯਾਮਿ? ਯਤ੍ ਕਿਣ੍ਵੰ ਕਾਚਿਤ੍ ਸ੍ਤ੍ਰੀ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਦ੍ਰੋਣਤ੍ਰਯਪਰਿਮਿਤਗੋਧੂਮਚੂਰ੍ਣੇਸ਼਼ੁ ਸ੍ਥਾਪਯਾਮਾਸ, ");
INSERT INTO sanpun_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ਤਤਃ ਕ੍ਰਮੇਣ ਤਤ੍ ਸਰ੍ੱਵਗੋਧੂਮਚੂਰ੍ਣੰ ਵ੍ਯਾਪ੍ਨੋਤਿ, ਤਸ੍ਯ ਕਿਣ੍ਵਸ੍ਯ ਤੁਲ੍ਯਮ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਰਾਜ੍ਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ਤਤਃ ਸ ਯਿਰੂਸ਼ਾਲਮ੍ਨਗਰੰ ਪ੍ਰਤਿ ਯਾਤ੍ਰਾਂ ਕ੍ਰੁʼਤ੍ਵਾ ਨਗਰੇ ਨਗਰੇ ਗ੍ਰਾਮੇ ਗ੍ਰਾਮੇ ਸਮੁਪਦਿਸ਼ਨ੍ ਜਗਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ਤਦਾ ਕਸ਼੍ਚਿੱਜਨਸ੍ਤੰ ਪਪ੍ਰੱਛ, ਹੇ ਪ੍ਰਭੋ ਕਿੰ ਕੇਵਲਮ੍ ਅਲ੍ਪੇ ਲੋਕਾਃ ਪਰਿਤ੍ਰਾਸ੍ਯਨ੍ਤੇ? ");
INSERT INTO sanpun_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","ਤਤਃ ਸ ਲੋਕਾਨ੍ ਉਵਾਚ, ਸੰਕੀਰ੍ਣਦ੍ਵਾਰੇਣ ਪ੍ਰਵੇਸ਼਼੍ਟੁੰ ਯਤਘ੍ਵੰ, ਯਤੋਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਵਦਾਮਿ, ਬਹਵਃ ਪ੍ਰਵੇਸ਼਼੍ਟੁੰ ਚੇਸ਼਼੍ਟਿਸ਼਼੍ਯਨ੍ਤੇ ਕਿਨ੍ਤੁ ਨ ਸ਼ਕ੍ਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ਗ੍ਰੁʼਹਪਤਿਨੋੱਥਾਯ ਦ੍ਵਾਰੇ ਰੁੱਧੇ ਸਤਿ ਯਦਿ ਯੂਯੰ ਬਹਿਃ ਸ੍ਥਿਤ੍ਵਾ ਦ੍ਵਾਰਮਾਹਤ੍ਯ ਵਦਥ, ਹੇ ਪ੍ਰਭੋ ਹੇ ਪ੍ਰਭੋ ਅਸ੍ਮਤ੍ਕਾਰਣਾਦ੍ ਦ੍ਵਾਰੰ ਮੋਚਯਤੁ, ਤਤਃ ਸ ਇਤਿ ਪ੍ਰਤਿਵਕ੍ਸ਼਼੍ਯਤਿ, ਯੂਯੰ ਕੁਤ੍ਰਤ੍ਯਾ ਲੋਕਾ ਇਤ੍ਯਹੰ ਨ ਜਾਨਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","ਤਦਾ ਯੂਯੰ ਵਦਿਸ਼਼੍ਯਥ, ਤਵ ਸਾਕ੍ਸ਼਼ਾਦ੍ ਵਯੰ ਭੇाਜਨੰ ਪਾਨਞ੍ਚ ਕ੍ਰੁʼਤਵਨ੍ਤਃ, ਤ੍ਵਞ੍ਚਾਸ੍ਮਾਕੰ ਨਗਰਸ੍ਯ ਪਥਿ ਸਮੁਪਦਿਸ਼਼੍ਟਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","ਕਿਨ੍ਤੁ ਸ ਵਕ੍ਸ਼਼੍ਯਤਿ, ਯੁਸ਼਼੍ਮਾਨਹੰ ਵਦਾਮਿ, ਯੂਯੰ ਕੁਤ੍ਰਤ੍ਯਾ ਲੋਕਾ ਇਤ੍ਯਹੰ ਨ ਜਾਨਾਮਿ; ਹੇ ਦੁਰਾਚਾਰਿਣੋ ਯੂਯੰ ਮੱਤੋ ਦੂਰੀਭਵਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","ਤਦਾ ਇਬ੍ਰਾਹੀਮੰ ਇਸ੍ਹਾਕੰ ਯਾਕੂਬਞ੍ਚ ਸਰ੍ੱਵਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਸ਼੍ਚ ਈਸ਼੍ਵਰਸ੍ਯ ਰਾਜ੍ਯੰ ਪ੍ਰਾਪ੍ਤਾਨ੍ ਸ੍ਵਾਂਸ਼੍ਚ ਬਹਿਸ਼਼੍ਕ੍ਰੁʼਤਾਨ੍ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਯੂਯੰ ਰੋਦਨੰ ਦਨ੍ਤੈਰ੍ਦਨ੍ਤਘਰ੍ਸ਼਼ਣਞ੍ਚ ਕਰਿਸ਼਼੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","ਅਪਰਞ੍ਚ ਪੂਰ੍ੱਵਪਸ਼੍ਚਿਮਦਕ੍ਸ਼਼ਿਣੋੱਤਰਦਿਗ੍ਭ੍ਯੋ ਲੋਕਾ ਆਗਤ੍ਯ ਈਸ਼੍ਵਰਸ੍ਯ ਰਾਜ੍ਯੇ ਨਿਵਤ੍ਸ੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ਪਸ਼੍ਯਤੇੱਥੰ ਸ਼ੇਸ਼਼ੀਯਾ ਲੋਕਾ ਅਗ੍ਰਾ ਭਵਿਸ਼਼੍ਯਨ੍ਤਿ, ਅਗ੍ਰੀਯਾ ਲੋਕਾਸ਼੍ਚ ਸ਼ੇਸ਼਼ਾ ਭਵਿਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","ਅਪਰਞ੍ਚ ਤਸ੍ਮਿਨ੍ ਦਿਨੇ ਕਿਯਨ੍ਤਃ ਫਿਰੂਸ਼ਿਨ ਆਗਤ੍ਯ ਯੀਸ਼ੁੰ ਪ੍ਰੋਚੁਃ, ਬਹਿਰ੍ਗੱਛ, ਸ੍ਥਾਨਾਦਸ੍ਮਾਤ੍ ਪ੍ਰਸ੍ਥਾਨੰ ਕੁਰੁ, ਹੇਰੋਦ੍ ਤ੍ਵਾਂ ਜਿਘਾਂਸਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ਤਤਃ ਸ ਪ੍ਰਤ੍ਯਵੋਚਤ੍ ਪਸ਼੍ਯਤਾਦ੍ਯ ਸ਼੍ਵਸ਼੍ਚ ਭੂਤਾਨ੍ ਵਿਹਾਪ੍ਯ ਰੋਗਿਣੋ(ਅ)ਰੋਗਿਣਃ ਕ੍ਰੁʼਤ੍ਵਾ ਤ੍ਰੁʼਤੀਯੇਹ੍ਨਿ ਸੇਤ੍ਸ੍ਯਾਮਿ, ਕਥਾਮੇਤਾਂ ਯੂਯਮਿਤ੍ਵਾ ਤੰ ਭੂਰਿਮਾਯੰ ਵਦਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","ਤਤ੍ਰਾਪ੍ਯਦ੍ਯ ਸ਼੍ਵਃ ਪਰਸ਼੍ਵਸ਼੍ਚ ਮਯਾ ਗਮਨਾਗਮਨੇ ਕਰ੍ੱਤਵ੍ਯੇ, ਯਤੋ ਹੇਤੋ ਰ੍ਯਿਰੂਸ਼ਾਲਮੋ ਬਹਿਃ ਕੁਤ੍ਰਾਪਿ ਕੋਪਿ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦੀ ਨ ਘਾਨਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","ਹੇ ਯਿਰੂਸ਼ਾਲਮ੍ ਹੇ ਯਿਰੂਸ਼ਾਲਮ੍ ਤ੍ਵੰ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨੋ ਹੰਸਿ ਤਵਾਨ੍ਤਿਕੇ ਪ੍ਰੇਰਿਤਾਨ੍ ਪ੍ਰਸ੍ਤਰੈਰ੍ਮਾਰਯਸਿ ਚ, ਯਥਾ ਕੁੱਕੁਟੀ ਨਿਜਪਕ੍ਸ਼਼ਾਧਃ ਸ੍ਵਸ਼ਾਵਕਾਨ੍ ਸੰਗ੍ਰੁʼਹ੍ਲਾਤਿ, ਤਥਾਹਮਪਿ ਤਵ ਸ਼ਿਸ਼ੂਨ੍ ਸੰਗ੍ਰਹੀਤੁੰ ਕਤਿਵਾਰਾਨ੍ ਐੱਛੰ ਕਿਨ੍ਤੁ ਤ੍ਵੰ ਨੈੱਛਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ਪਸ਼੍ਯਤ ਯੁਸ਼਼੍ਮਾਕੰ ਵਾਸਸ੍ਥਾਨਾਨਿ ਪ੍ਰੋੱਛਿਦ੍ਯਮਾਨਾਨਿ ਪਰਿਤ੍ਯਕ੍ਤਾਨਿ ਚ ਭਵਿਸ਼਼੍ਯਨ੍ਤਿ; ਯੁਸ਼਼੍ਮਾਨਹੰ ਯਥਾਰ੍ਥੰ ਵਦਾਮਿ, ਯਃ ਪ੍ਰਭੋ ਰ੍ਨਾਮ੍ਨਾਗੱਛਤਿ ਸ ਧਨ੍ਯ ਇਤਿ ਵਾਚੰ ਯਾਵਤ੍ਕਾਲੰ ਨ ਵਦਿਸ਼਼੍ਯਥ, ਤਾਵਤ੍ਕਾਲੰ ਯੂਯੰ ਮਾਂ ਨ ਦ੍ਰਕ੍ਸ਼਼੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ਅਨਨ੍ਤਰੰ ਵਿਸ਼੍ਰਾਮਵਾਰੇ ਯੀਸ਼ੌ ਪ੍ਰਧਾਨਸ੍ਯ ਫਿਰੂਸ਼ਿਨੋ ਗ੍ਰੁʼਹੇ ਭੋਕ੍ਤੁੰ ਗਤਵਤਿ ਤੇ ਤੰ ਵੀਕ੍ਸ਼਼ਿਤੁਮ੍ ਆਰੇਭਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ਤਦਾ ਜਲੋਦਰੀ ਤਸ੍ਯ ਸੰਮੁਖੇ ਸ੍ਥਿਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ਤਤਃ ਸ ਵ੍ਯਵਸ੍ਥਾਪਕਾਨ੍ ਫਿਰੂਸ਼ਿਨਸ਼੍ਚ ਪਪ੍ਰੱਛ, ਵਿਸ਼੍ਰਾਮਵਾਰੇ ਸ੍ਵਾਸ੍ਥ੍ਯੰ ਕਰ੍ੱਤਵ੍ਯੰ ਨ ਵਾ? ਤਤਸ੍ਤੇ ਕਿਮਪਿ ਨ ਪ੍ਰਤ੍ਯੂਚੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","ਤਦਾ ਸ ਤੰ ਰੋਗਿਣੰ ਸ੍ਵਸ੍ਥੰ ਕ੍ਰੁʼਤ੍ਵਾ ਵਿਸਸਰ੍ਜ; ");
INSERT INTO sanpun_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ਤਾਨੁਵਾਚ ਚ ਯੁਸ਼਼੍ਮਾਕੰ ਕਸ੍ਯਚਿਦ੍ ਗਰ੍ੱਦਭੋ ਵ੍ਰੁʼਸ਼਼ਭੋ ਵਾ ਚੇਦ੍ ਗਰ੍ੱਤੇ ਪਤਤਿ ਤਰ੍ਹਿ ਵਿਸ਼੍ਰਾਮਵਾਰੇ ਤਤ੍ਕ੍ਸ਼਼ਣੰ ਸ ਕਿੰ ਤੰ ਨੋੱਥਾਪਯਿਸ਼਼੍ਯਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ਤਤਸ੍ਤੇ ਕਥਾਯਾ ਏਤਸ੍ਯਾਃ ਕਿਮਪਿ ਪ੍ਰਤਿਵਕ੍ਤੁੰ ਨ ਸ਼ੇਕੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ਅਪਰਞ੍ਚ ਪ੍ਰਧਾਨਸ੍ਥਾਨਮਨੋਨੀਤਤ੍ਵਕਰਣੰ ਵਿਲੋਕ੍ਯ ਸ ਨਿਮਨ੍ਤ੍ਰਿਤਾਨ੍ ਏਤਦੁਪਦੇਸ਼ਕਥਾਂ ਜਗਾਦ, ");
INSERT INTO sanpun_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","ਤ੍ਵੰ ਵਿਵਾਹਾਦਿਭੋਜ੍ਯੇਸ਼਼ੁ ਨਿਮਨ੍ਤ੍ਰਿਤਃ ਸਨ੍ ਪ੍ਰਧਾਨਸ੍ਥਾਨੇ ਮੋਪਾਵੇਕ੍ਸ਼਼ੀਃ| ਤ੍ਵੱਤੋ ਗੌਰਵਾਨ੍ਵਿਤਨਿਮਨ੍ਤ੍ਰਿਤਜਨ ਆਯਾਤੇ ");
INSERT INTO sanpun_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ਨਿਮਨ੍ਤ੍ਰਯਿਤਾਗਤ੍ਯ ਮਨੁਸ਼਼੍ਯਾਯੈਤਸ੍ਮੈ ਸ੍ਥਾਨੰ ਦੇਹੀਤਿ ਵਾਕ੍ਯੰ ਚੇਦ੍ ਵਕ੍ਸ਼਼੍ਯਤਿ ਤਰ੍ਹਿ ਤ੍ਵੰ ਸਙ੍ਕੁਚਿਤੋ ਭੂਤ੍ਵਾ ਸ੍ਥਾਨ ਇਤਰਸ੍ਮਿਨ੍ ਉਪਵੇਸ਼਼੍ਟੁਮ੍ ਉਦ੍ਯੰਸ੍ਯਸਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","ਅਸ੍ਮਾਤ੍ ਕਾਰਣਾਦੇਵ ਤ੍ਵੰ ਨਿਮਨ੍ਤ੍ਰਿਤੋ ਗਤ੍ਵਾ(ਅ)ਪ੍ਰਧਾਨਸ੍ਥਾਨ ਉਪਵਿਸ਼, ਤਤੋ ਨਿਮਨ੍ਤ੍ਰਯਿਤਾਗਤ੍ਯ ਵਦਿਸ਼਼੍ਯਤਿ, ਹੇ ਬਨ੍ਧੋ ਪ੍ਰੋੱਚਸ੍ਥਾਨੰ ਗਤ੍ਵੋਪਵਿਸ਼, ਤਥਾ ਸਤਿ ਭੋਜਨੋਪਵਿਸ਼਼੍ਟਾਨਾਂ ਸਕਲਾਨਾਂ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਤ੍ਵੰ ਮਾਨ੍ਯੋ ਭਵਿਸ਼਼੍ਯਸਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","ਯਃ ਕਸ਼੍ਚਿਤ੍ ਸ੍ਵਮੁੰਨਮਯਤਿ ਸ ਨਮਯਿਸ਼਼੍ਯਤੇ, ਕਿਨ੍ਤੁ ਯਃ ਕਸ਼੍ਚਿਤ੍ ਸ੍ਵੰ ਨਮਯਤਿ ਸ ਉੰਨਮਯਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ਤਦਾ ਸ ਨਿਮਨ੍ਤ੍ਰਯਿਤਾਰੰ ਜਨਮਪਿ ਜਗਾਦ, ਮਧ੍ਯਾਹ੍ਨੇ ਰਾਤ੍ਰੌ ਵਾ ਭੋਜ੍ਯੇ ਕ੍ਰੁʼਤੇ ਨਿਜਬਨ੍ਧੁਗਣੋ ਵਾ ਭ੍ਰਾਤ੍ਰੁʼृਗਣੋ ਵਾ ਜ੍ਞਾਤਿਗਣੋ ਵਾ ਧਨਿਗਣੋ ਵਾ ਸਮੀਪਵਾਸਿਗਣੋ ਵਾ ਏਤਾਨ੍ ਨ ਨਿਮਨ੍ਤ੍ਰਯ, ਤਥਾ ਕ੍ਰੁʼਤੇ ਚੇਤ੍ ਤੇ ਤ੍ਵਾਂ ਨਿਮਨ੍ਤ੍ਰਯਿਸ਼਼੍ਯਨ੍ਤਿ, ਤਰ੍ਹਿ ਪਰਿਸ਼ੋਧੋ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","ਕਿਨ੍ਤੁ ਯਦਾ ਭੇਜ੍ਯੰ ਕਰੋਸ਼਼ਿ ਤਦਾ ਦਰਿਦ੍ਰਸ਼ੁਸ਼਼੍ਕਕਰਖਞ੍ਜਾਨ੍ਧਾਨ੍ ਨਿਮਨ੍ਤ੍ਰਯ, ");
INSERT INTO sanpun_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ਤਤ ਆਸ਼ਿਸ਼਼ੰ ਲਪ੍ਸ੍ਯਸੇ, ਤੇਸ਼਼ੁ ਪਰਿਸ਼ੋਧੰ ਕਰ੍ੱਤੁਮਸ਼ਕ੍ਨੁਵਤ੍ਸੁ ਸ਼੍ਮਸ਼ਾਨਾੱਧਾਰ੍ੰਮਿਕਾਨਾਮੁੱਥਾਨਕਾਲੇ ਤ੍ਵੰ ਫਲਾਂ ਲਪ੍ਸ੍ਯਸੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ਅਨਨ੍ਤਰੰ ਤਾਂ ਕਥਾਂ ਨਿਸ਼ਮ੍ਯ ਭੋਜਨੋਪਵਿਸ਼਼੍ਟਃ ਕਸ਼੍ਚਿਤ੍ ਕਥਯਾਮਾਸ, ਯੋ ਜਨ ਈਸ਼੍ਵਰਸ੍ਯ ਰਾਜ੍ਯੇ ਭੋਕ੍ਤੁੰ ਲਪ੍ਸ੍ਯਤੇ ਸਏਵ ਧਨ੍ਯਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ਤਤਃ ਸ ਉਵਾਚ, ਕਸ਼੍ਚਿਤ੍ ਜਨੋ ਰਾਤ੍ਰੌ ਭੇाਜ੍ਯੰ ਕ੍ਰੁʼਤ੍ਵਾ ਬਹੂਨ੍ ਨਿਮਨ੍ਤ੍ਰਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ਤਤੋ ਭੋਜਨਸਮਯੇ ਨਿਮਨ੍ਤ੍ਰਿਤਲੋਕਾਨ੍ ਆਹ੍ਵਾਤੁੰ ਦਾਸਦ੍ਵਾਰਾ ਕਥਯਾਮਾਸ, ਖਦ੍ਯਦ੍ਰਵ੍ਯਾਣਿ ਸਰ੍ੱਵਾਣਿ ਸਮਾਸਾਦਿਤਾਨਿ ਸਨ੍ਤਿ, ਯੂਯਮਾਗੱਛਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","ਕਿਨ੍ਤੁ ਤੇ ਸਰ੍ੱਵ ਏਕੈਕੰ ਛਲੰ ਕ੍ਰੁʼਤ੍ਵਾ ਕ੍ਸ਼਼ਮਾਂ ਪ੍ਰਾਰ੍ਥਯਾਞ੍ਚਕ੍ਰਿਰੇ| ਪ੍ਰਥਮੋ ਜਨਃ ਕਥਯਾਮਾਸ, ਕ੍ਸ਼਼ੇਤ੍ਰਮੇਕੰ ਕ੍ਰੀਤਵਾਨਹੰ ਤਦੇਵ ਦ੍ਰਸ਼਼੍ਟੁੰ ਮਯਾ ਗਨ੍ਤਵ੍ਯਮ੍, ਅਤਏਵ ਮਾਂ ਕ੍ਸ਼਼ਨ੍ਤੁੰ ਤੰ ਨਿਵੇਦਯ| ");
INSERT INTO sanpun_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","ਅਨ੍ਯੋ ਜਨਃ ਕਥਯਾਮਾਸ, ਦਸ਼ਵ੍ਰੁʼਸ਼਼ਾਨਹੰ ਕ੍ਰੀਤਵਾਨ੍ ਤਾਨ੍ ਪਰੀਕ੍ਸ਼਼ਿਤੁੰ ਯਾਮਿ ਤਸ੍ਮਾਦੇਵ ਮਾਂ ਕ੍ਸ਼਼ਨ੍ਤੁੰ ਤੰ ਨਿਵੇਦਯ| ");
INSERT INTO sanpun_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","ਅਪਰਃ ਕਥਯਾਮਾਸ, ਵ੍ਯੂਢਵਾਨਹੰ ਤਸ੍ਮਾਤ੍ ਕਾਰਣਾਦ੍ ਯਾਤੁੰ ਨ ਸ਼ਕ੍ਨੋਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","ਪਸ਼੍ਚਾਤ੍ ਸ ਦਾਸੋ ਗਤ੍ਵਾ ਨਿਜਪ੍ਰਭੋਃ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਸਰ੍ੱਵਵ੍ਰੁʼੱਤਾਨ੍ਤੰ ਨਿਵੇਦਯਾਮਾਸ, ਤਤੋਸੌ ਗ੍ਰੁʼਹਪਤਿਃ ਕੁਪਿਤ੍ਵਾ ਸ੍ਵਦਾਸੰ ਵ੍ਯਾਜਹਾਰ, ਤ੍ਵੰ ਸਤ੍ਵਰੰ ਨਗਰਸ੍ਯ ਸੰਨਿਵੇਸ਼ਾਨ੍ ਮਾਰ੍ਗਾਂਸ਼੍ਚ ਗਤ੍ਵਾ ਦਰਿਦ੍ਰਸ਼ੁਸ਼਼੍ਕਕਰਖਞ੍ਜਾਨ੍ਧਾਨ੍ ਅਤ੍ਰਾਨਯ| ");
INSERT INTO sanpun_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","ਤਤੋ ਦਾਸੋ(ਅ)ਵਦਤ੍, ਹੇ ਪ੍ਰਭੋ ਭਵਤ ਆਜ੍ਞਾਨੁਸਾਰੇਣਾਕ੍ਰਿਯਤ ਤਥਾਪਿ ਸ੍ਥਾਨਮਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","ਤਦਾ ਪ੍ਰਭੁਃ ਪੁਨ ਰ੍ਦਾਸਾਯਾਕਥਯਤ੍, ਰਾਜਪਥਾਨ੍ ਵ੍ਰੁʼਕ੍ਸ਼਼ਮੂਲਾਨਿ ਚ ਯਾਤ੍ਵਾ ਮਦੀਯਗ੍ਰੁʼਹਪੂਰਣਾਰ੍ਥੰ ਲੋਕਾਨਾਗਨ੍ਤੁੰ ਪ੍ਰਵਰ੍ੱਤਯ| ");
INSERT INTO sanpun_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ਅਹੰ ਯੁਸ਼਼੍ਮਭ੍ਯੰ ਕਥਯਾਮਿ, ਪੂਰ੍ੱਵਨਿਮਨ੍ਤ੍ਰਿਤਾਨਮੇਕੋਪਿ ਮਮਾਸ੍ਯ ਰਾਤ੍ਰਿਭੋਜ੍ਯਸ੍ਯਾਸ੍ਵਾਦੰ ਨ ਪ੍ਰਾਪ੍ਸ੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","ਅਨਨ੍ਤਰੰ ਬਹੁਸ਼਼ੁ ਲੋਕੇਸ਼਼ੁ ਯੀਸ਼ੋਃ ਪਸ਼੍ਚਾਦ੍ ਵ੍ਰਜਿਤੇਸ਼਼ੁ ਸਤ੍ਸੁ ਸ ਵ੍ਯਾਘੁਟ੍ਯ ਤੇਭ੍ਯਃ ਕਥਯਾਮਾਸ, ");
INSERT INTO sanpun_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","ਯਃ ਕਸ਼੍ਚਿਨ੍ ਮਮ ਸਮੀਪਮ੍ ਆਗਤ੍ਯ ਸ੍ਵਸ੍ਯ ਮਾਤਾ ਪਿਤਾ ਪਤ੍ਨੀ ਸਨ੍ਤਾਨਾ ਭ੍ਰਾਤਰੋ ਭਗਿਮ੍ਯੋ ਨਿਜਪ੍ਰਾਣਾਸ਼੍ਚ, ਏਤੇਭ੍ਯਃ ਸਰ੍ੱਵੇਭ੍ਯੋ ਮੱਯਧਿਕੰ ਪ੍ਰੇਮ ਨ ਕਰੋਤਿ, ਸ ਮਮ ਸ਼ਿਸ਼਼੍ਯੋ ਭਵਿਤੁੰ ਨ ਸ਼ਕ੍ਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ਯਃ ਕਸ਼੍ਚਿਤ੍ ਸ੍ਵੀਯੰ ਕ੍ਰੁਸ਼ੰ ਵਹਨ੍ ਮਮ ਪਸ਼੍ਚਾੰਨ ਗੱਛਤਿ, ਸੋਪਿ ਮਮ ਸ਼ਿਸ਼਼੍ਯੋ ਭਵਿਤੁੰ ਨ ਸ਼ਕ੍ਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","ਦੁਰ੍ਗਨਿਰ੍ੰਮਾਣੇ ਕਤਿਵ੍ਯਯੋ ਭਵਿਸ਼਼੍ਯਤਿ, ਤਥਾ ਤਸ੍ਯ ਸਮਾਪ੍ਤਿਕਰਣਾਰ੍ਥੰ ਸਮ੍ਪੱਤਿਰਸ੍ਤਿ ਨ ਵਾ, ਪ੍ਰਥਮਮੁਪਵਿਸ਼੍ਯ ਏਤੰਨ ਗਣਯਤਿ, ਯੁਸ਼਼੍ਮਾਕੰ ਮਧ੍ਯ ਏਤਾਦ੍ਰੁʼਸ਼ਃ ਕੋਸ੍ਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","ਨੋਚੇਦ੍ ਭਿੱਤਿੰ ਕ੍ਰੁʼਤ੍ਵਾ ਸ਼ੇਸ਼਼ੇ ਯਦਿ ਸਮਾਪਯਿਤੁੰ ਨ ਸ਼ਕ੍ਸ਼਼੍ਯਤਿ, ");
INSERT INTO sanpun_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ਤਰ੍ਹਿ ਮਾਨੁਸ਼਼ੋਯੰ ਨਿਚੇਤੁਮ੍ ਆਰਭਤ ਸਮਾਪਯਿਤੁੰ ਨਾਸ਼ਕ੍ਨੋਤ੍, ਇਤਿ ਵ੍ਯਾਹ੍ਰੁʼਤ੍ਯ ਸਰ੍ੱਵੇ ਤਮੁਪਹਸਿਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","ਅਪਰਞ੍ਚ ਭਿੰਨਭੂਪਤਿਨਾ ਸਹ ਯੁੱਧੰ ਕਰ੍ੱਤੁਮ੍ ਉਦ੍ਯਮ੍ਯ ਦਸ਼ਸਹਸ੍ਰਾਣਿ ਸੈਨ੍ਯਾਨਿ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਵਿੰਸ਼ਤਿਸਹਸ੍ਰੇਃ ਸੈਨ੍ਯੈਃ ਸਹਿਤਸ੍ਯ ਸਮੀਪਵਾਸਿਨਃ ਸੰਮੁਖੰ ਯਾਤੁੰ ਸ਼ਕ੍ਸ਼਼੍ਯਾਮਿ ਨ ਵੇਤਿ ਪ੍ਰਥਮੰ ਉਪਵਿਸ਼੍ਯ ਨ ਵਿਚਾਰਯਤਿ ਏਤਾਦ੍ਰੁʼਸ਼ੋ ਭੂਮਿਪਤਿਃ ਕਃ? ");
INSERT INTO sanpun_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","ਯਦਿ ਨ ਸ਼ਕ੍ਨੋਤਿ ਤਰ੍ਹਿ ਰਿਪਾਵਤਿਦੂਰੇ ਤਿਸ਼਼੍ਠਤਿ ਸਤਿ ਨਿਜਦੂਤੰ ਪ੍ਰੇਸ਼਼੍ਯ ਸਨ੍ਧਿੰ ਕਰ੍ੱਤੁੰ ਪ੍ਰਾਰ੍ਥਯੇਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","ਤਦ੍ਵਦ੍ ਯੁਸ਼਼੍ਮਾਕੰ ਮਧ੍ਯੇ ਯਃ ਕਸ਼੍ਚਿਨ੍ ਮਦਰ੍ਥੰ ਸਰ੍ੱਵਸ੍ਵੰ ਹਾਤੁੰ ਨ ਸ਼ਕ੍ਨੋਤਿ ਸ ਮਮ ਸ਼ਿਸ਼਼੍ਯੋ ਭਵਿਤੁੰ ਨ ਸ਼ਕ੍ਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","ਲਵਣਮ੍ ਉੱਤਮਮ੍ ਇਤਿ ਸਤ੍ਯੰ, ਕਿਨ੍ਤੁ ਯਦਿ ਲਵਣਸ੍ਯ ਲਵਣਤ੍ਵਮ੍ ਅਪਗੱਛਤਿ ਤਰ੍ਹਿ ਤਤ੍ ਕਥੰ ਸ੍ਵਾਦੁਯੁਕ੍ਤੰ ਭਵਿਸ਼਼੍ਯਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ਤਦ ਭੂਮ੍ਯਰ੍ਥਮ੍ ਆਲਵਾਲਰਾਸ਼੍ਯਰ੍ਥਮਪਿ ਭਦ੍ਰੰ ਨ ਭਵਤਿ; ਲੋਕਾਸ੍ਤਦ੍ ਬਹਿਃ ਕ੍ਸ਼਼ਿਪਨ੍ਤਿ| ਯਸ੍ਯ ਸ਼੍ਰੋਤੁੰ ਸ਼੍ਰੋਤ੍ਰੇ ਸ੍ਤਃ ਸ ਸ਼੍ਰੁʼਣੋਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ਤਦਾ ਕਰਸਞ੍ਚਾਯਿਨਃ ਪਾਪਿਨਸ਼੍ਚ ਲੋਕਾ ਉਪਦੇਸ਼੍ਕਥਾਂ ਸ਼੍ਰੋਤੁੰ ਯੀਸ਼ੋਃ ਸਮੀਪਮ੍ ਆਗੱਛਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ਤਤਃ ਫਿਰੂਸ਼ਿਨ ਉਪਾਧ੍ਯਾਯਾਸ਼੍ਚ ਵਿਵਦਮਾਨਾਃ ਕਥਯਾਮਾਸੁਃ ਏਸ਼਼ ਮਾਨੁਸ਼਼ਃ ਪਾਪਿਭਿਃ ਸਹ ਪ੍ਰਣਯੰ ਕ੍ਰੁʼਤ੍ਵਾ ਤੈਃ ਸਾਰ੍ੱਧੰ ਭੁੰਕ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ਤਦਾ ਸ ਤੇਭ੍ਯ ਇਮਾਂ ਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤਕਥਾਂ ਕਥਿਤਵਾਨ੍, ");
INSERT INTO sanpun_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","ਕਸ੍ਯਚਿਤ੍ ਸ਼ਤਮੇਸ਼਼ੇਸ਼਼ੁ ਤਿਸ਼਼੍ਠਤ੍ਮੁ ਤੇਸ਼਼ਾਮੇਕੰ ਸ ਯਦਿ ਹਾਰਯਤਿ ਤਰ੍ਹਿ ਮਧ੍ਯੇਪ੍ਰਾਨ੍ਤਰਮ੍ ਏਕੋਨਸ਼ਤਮੇਸ਼਼ਾਨ੍ ਵਿਹਾਯ ਹਾਰਿਤਮੇਸ਼਼ਸ੍ਯ ਉੱਦੇਸ਼ਪ੍ਰਾਪ੍ਤਿਪਰ੍ੱਯਨਤੰ ਨ ਗਵੇਸ਼਼ਯਤਿ, ਏਤਾਦ੍ਰੁʼਸ਼ੋ ਲੋਕੋ ਯੁਸ਼਼੍ਮਾਕੰ ਮਧ੍ਯੇ ਕ ਆਸ੍ਤੇ? ");
INSERT INTO sanpun_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","ਤਸ੍ਯੋੱਦੇਸ਼ੰ ਪ੍ਰਾਪ੍ਯ ਹ੍ਰੁʼਸ਼਼੍ਟਮਨਾਸ੍ਤੰ ਸ੍ਕਨ੍ਧੇ ਨਿਧਾਯ ਸ੍ਵਸ੍ਥਾਨਮ੍ ਆਨੀਯ ਬਨ੍ਧੁਬਾਨ੍ਧਵਸਮੀਪਵਾਸਿਨ ਆਹੂਯ ਵਕ੍ਤਿ, ");
INSERT INTO sanpun_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ਹਾਰਿਤੰ ਮੇਸ਼਼ੰ ਪ੍ਰਾਪ੍ਤੋਹਮ੍ ਅਤੋ ਹੇਤੋ ਰ੍ਮਯਾ ਸਾਰ੍ੱਧਮ੍ ਆਨਨ੍ਦਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","ਤਦ੍ਵਦਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਵਦਾਮਿ, ਯੇਸ਼਼ਾਂ ਮਨਃਪਰਾਵਰ੍ੱਤਨਸ੍ਯ ਪ੍ਰਯੋਜਨੰ ਨਾਸ੍ਤਿ, ਤਾਦ੍ਰੁʼਸ਼ੈਕੋਨਸ਼ਤਧਾਰ੍ੰਮਿਕਕਾਰਣਾਦ੍ ਯ ਆਨਨ੍ਦਸ੍ਤਸ੍ਮਾਦ੍ ਏਕਸ੍ਯ ਮਨਃਪਰਿਵਰ੍ੱਤਿਨਃ ਪਾਪਿਨਃ ਕਾਰਣਾਤ੍ ਸ੍ਵਰ੍ਗੇ (ਅ)ਧਿਕਾਨਨ੍ਦੋ ਜਾਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","ਅਪਰਞ੍ਚ ਦਸ਼ਾਨਾਂ ਰੂਪ੍ਯਖਣ੍ਡਾਨਾਮ੍ ਏਕਖਣ੍ਡੇ ਹਾਰਿਤੇ ਪ੍ਰਦੀਪੰ ਪ੍ਰਜ੍ਵਾਲ੍ਯ ਗ੍ਰੁʼਹੰ ਸੰਮਾਰ੍ਜ੍ਯ ਤਸ੍ਯ ਪ੍ਰਾਪ੍ਤਿੰ ਯਾਵਦ੍ ਯਤ੍ਨੇਨ ਨ ਗਵੇਸ਼਼ਯਤਿ, ਏਤਾਦ੍ਰੁʼਸ਼ੀ ਯੋਸ਼਼ਿਤ੍ ਕਾਸ੍ਤੇ? ");
INSERT INTO sanpun_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ਪ੍ਰਾਪ੍ਤੇ ਸਤਿ ਬਨ੍ਧੁਬਾਨ੍ਧਵਸਮੀਪਵਾਸਿਨੀਰਾਹੂਯ ਕਥਯਤਿ, ਹਾਰਿਤੰ ਰੂਪ੍ਯਖਣ੍ਡੰ ਪ੍ਰਾਪ੍ਤਾਹੰ ਤਸ੍ਮਾਦੇਵ ਮਯਾ ਸਾਰ੍ੱਧਮ੍ ਆਨਨ੍ਦਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","ਤਦ੍ਵਦਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਵ੍ਯਾਹਰਾਮਿ, ਏਕੇਨ ਪਾਪਿਨਾ ਮਨਸਿ ਪਰਿਵਰ੍ੱਤਿਤੇ, ਈਸ਼੍ਵਰਸ੍ਯ ਦੂਤਾਨਾਂ ਮਧ੍ਯੇਪ੍ਯਾਨਨ੍ਦੋ ਜਾਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","ਅਪਰਞ੍ਚ ਸ ਕਥਯਾਮਾਸ, ਕਸ੍ਯਚਿਦ੍ ਦ੍ਵੌ ਪੁਤ੍ਰਾਵਾਸ੍ਤਾਂ, ");
INSERT INTO sanpun_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ਤਯੋਃ ਕਨਿਸ਼਼੍ਠਃ ਪੁਤ੍ਰਃ ਪਿਤ੍ਰੇ ਕਥਯਾਮਾਸ, ਹੇ ਪਿਤਸ੍ਤਵ ਸਮ੍ਪੱਤ੍ਯਾ ਯਮੰਸ਼ੰ ਪ੍ਰਾਪ੍ਸ੍ਯਾਮ੍ਯਹੰ ਵਿਭਜ੍ਯ ਤੰ ਦੇਹਿ, ਤਤਃ ਪਿਤਾ ਨਿਜਾਂ ਸਮ੍ਪੱਤਿੰ ਵਿਭਜ੍ਯ ਤਾਭ੍ਯਾਂ ਦਦੌ| ");
INSERT INTO sanpun_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","ਕਤਿਪਯਾਤ੍ ਕਾਲਾਤ੍ ਪਰੰ ਸ ਕਨਿਸ਼਼੍ਠਪੁਤ੍ਰਃ ਸਮਸ੍ਤੰ ਧਨੰ ਸੰਗ੍ਰੁʼਹ੍ਯ ਦੂਰਦੇਸ਼ੰ ਗਤ੍ਵਾ ਦੁਸ਼਼੍ਟਾਚਰਣੇਨ ਸਰ੍ੱਵਾਂ ਸਮ੍ਪੱਤਿੰ ਨਾਸ਼ਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ਤਸ੍ਯ ਸਰ੍ੱਵਧਨੇ ਵ੍ਯਯੰ ਗਤੇ ਤੱਦੇਸ਼ੇ ਮਹਾਦੁਰ੍ਭਿਕ੍ਸ਼਼ੰ ਬਭੂਵ, ਤਤਸ੍ਤਸ੍ਯ ਦੈਨ੍ਯਦਸ਼ਾ ਭਵਿਤੁਮ੍ ਆਰੇਭੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ਤਤਃ ਪਰੰ ਸ ਗਤ੍ਵਾ ਤੱਦੇਸ਼ੀਯੰ ਗ੍ਰੁʼਹਸ੍ਥਮੇਕਮ੍ ਆਸ਼੍ਰਯਤ; ਤਤਃ ਸਤੰ ਸ਼ੂਕਰਵ੍ਰਜੰ ਚਾਰਯਿਤੁੰ ਪ੍ਰਾਨ੍ਤਰੰ ਪ੍ਰੇਸ਼਼ਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ਕੇਨਾਪਿ ਤਸ੍ਮੈ ਭਕ੍ਸ਼਼੍ਯਾਦਾਨਾਤ੍ ਸ ਸ਼ੂਕਰਫਲਵਲ੍ਕਲੇਨ ਪਿਚਿਣ੍ਡਪੂਰਣਾਂ ਵਵਾਞ੍ਛ| ");
INSERT INTO sanpun_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ਸ਼ੇਸ਼਼ੇ ਸ ਮਨਸਿ ਚੇਤਨਾਂ ਪ੍ਰਾਪ੍ਯ ਕਥਯਾਮਾਸ, ਹਾ ਮਮ ਪਿਤੁਃ ਸਮੀਪੇ ਕਤਿ ਕਤਿ ਵੇਤਨਭੁਜੋ ਦਾਸਾ ਯਥੇਸ਼਼੍ਟੰ ਤਤੋਧਿਕਞ੍ਚ ਭਕ੍ਸ਼਼੍ਯੰ ਪ੍ਰਾਪ੍ਨੁਵਨ੍ਤਿ ਕਿਨ੍ਤ੍ਵਹੰ ਕ੍ਸ਼਼ੁਧਾ ਮੁਮੂਰ੍ਸ਼਼ੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ਅਹਮੁੱਥਾਯ ਪਿਤੁਃ ਸਮੀਪੰ ਗਤ੍ਵਾ ਕਥਾਮੇਤਾਂ ਵਦਿਸ਼਼੍ਯਾਮਿ, ਹੇ ਪਿਤਰ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਤਵ ਚ ਵਿਰੁੱਧੰ ਪਾਪਮਕਰਵਮ੍ ");
INSERT INTO sanpun_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ਤਵ ਪੁਤ੍ਰਇਤਿ ਵਿਖ੍ਯਾਤੋ ਭਵਿਤੁੰ ਨ ਯੋਗ੍ਯੋਸ੍ਮਿ ਚ, ਮਾਂ ਤਵ ਵੈਤਨਿਕੰ ਦਾਸੰ ਕ੍ਰੁʼਤ੍ਵਾ ਸ੍ਥਾਪਯ| ");
INSERT INTO sanpun_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","ਪਸ਼੍ਚਾਤ੍ ਸ ਉੱਥਾਯ ਪਿਤੁਃ ਸਮੀਪੰ ਜਗਾਮ; ਤਤਸ੍ਤਸ੍ਯ ਪਿਤਾਤਿਦੂਰੇ ਤੰ ਨਿਰੀਕ੍ਸ਼਼੍ਯ ਦਯਾਞ੍ਚਕ੍ਰੇ, ਧਾਵਿਤ੍ਵਾ ਤਸ੍ਯ ਕਣ੍ਠੰ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਤੰ ਚੁਚੁਮ੍ਬ ਚ| ");
INSERT INTO sanpun_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ਤਦਾ ਪੁਤ੍ਰ ਉਵਾਚ, ਹੇ ਪਿਤਰ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਤਵ ਚ ਵਿਰੁੱਧੰ ਪਾਪਮਕਰਵੰ, ਤਵ ਪੁਤ੍ਰਇਤਿ ਵਿਖ੍ਯਾਤੋ ਭਵਿਤੁੰ ਨ ਯੋਗ੍ਯੋਸ੍ਮਿ ਚ| ");
INSERT INTO sanpun_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","ਕਿਨ੍ਤੁ ਤਸ੍ਯ ਪਿਤਾ ਨਿਜਦਾਸਾਨ੍ ਆਦਿਦੇਸ਼, ਸਰ੍ੱਵੋੱਤਮਵਸ੍ਤ੍ਰਾਣ੍ਯਾਨੀਯ ਪਰਿਧਾਪਯਤੈਨੰ ਹਸ੍ਤੇ ਚਾਙ੍ਗੁਰੀਯਕਮ੍ ਅਰ੍ਪਯਤ ਪਾਦਯੋਸ਼੍ਚੋਪਾਨਹੌ ਸਮਰ੍ਪਯਤ; ");
INSERT INTO sanpun_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ਪੁਸ਼਼੍ਟੰ ਗੋਵਤ੍ਸਮ੍ ਆਨੀਯ ਮਾਰਯਤ ਚ ਤੰ ਭੁਕ੍ਤ੍ਵਾ ਵਯਮ੍ ਆਨਨ੍ਦਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ਯਤੋ ਮਮ ਪੁਤ੍ਰੋਯਮ੍ ਅਮ੍ਰਿਯਤ ਪੁਨਰਜੀਵੀਦ੍ ਹਾਰਿਤਸ਼੍ਚ ਲਬ੍ਧੋਭੂਤ੍ ਤਤਸ੍ਤ ਆਨਨ੍ਦਿਤੁਮ੍ ਆਰੇਭਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","ਤਤ੍ਕਾਲੇ ਤਸ੍ਯ ਜ੍ਯੇਸ਼਼੍ਠਃ ਪੁਤ੍ਰਃ ਕ੍ਸ਼਼ੇਤ੍ਰ ਆਸੀਤ੍| ਅਥ ਸ ਨਿਵੇਸ਼ਨਸ੍ਯ ਨਿਕਟੰ ਆਗੱਛਨ੍ ਨ੍ਰੁʼਤ੍ਯਾਨਾਂ ਵਾਦ੍ਯਾਨਾਞ੍ਚ ਸ਼ਬ੍ਦੰ ਸ਼੍ਰੁਤ੍ਵਾ ");
INSERT INTO sanpun_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ਦਾਸਾਨਾਮ੍ ਏਕਮ੍ ਆਹੂਯ ਪਪ੍ਰੱਛ, ਕਿੰ ਕਾਰਣਮਸ੍ਯ? ");
INSERT INTO sanpun_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","ਤਤਃ ਸੋਵਾਦੀਤ੍, ਤਵ ਭ੍ਰਾਤਾਗਮਤ੍, ਤਵ ਤਾਤਸ਼੍ਚ ਤੰ ਸੁਸ਼ਰੀਰੰ ਪ੍ਰਾਪ੍ਯ ਪੁਸ਼਼੍ਟੰ ਗੋਵਤ੍ਸੰ ਮਾਰਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","ਤਤਃ ਸ ਪ੍ਰਕੁਪ੍ਯ ਨਿਵੇਸ਼ਨਾਨ੍ਤਃ ਪ੍ਰਵੇਸ਼਼੍ਟੁੰ ਨ ਸੰਮੇਨੇ; ਤਤਸ੍ਤਸ੍ਯ ਪਿਤਾ ਬਹਿਰਾਗਤ੍ਯ ਤੰ ਸਾਧਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ਤਤਃ ਸ ਪਿਤਰੰ ਪ੍ਰਤ੍ਯੁਵਾਚ, ਪਸ਼੍ਯ ਤਵ ਕਾਞ੍ਚਿਦਪ੍ਯਾਜ੍ਞਾਂ ਨ ਵਿਲੰਘ੍ਯ ਬਹੂਨ੍ ਵਤ੍ਸਰਾਨ੍ ਅਹੰ ਤ੍ਵਾਂ ਸੇਵੇ ਤਥਾਪਿ ਮਿਤ੍ਰੈਃ ਸਾਰ੍ੱਧਮ੍ ਉਤ੍ਸਵੰ ਕਰ੍ੱਤੁੰ ਕਦਾਪਿ ਛਾਗਮੇਕਮਪਿ ਮਹ੍ਯੰ ਨਾਦਦਾਃ; ");
INSERT INTO sanpun_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","ਕਿਨ੍ਤੁ ਤਵ ਯਃ ਪੁਤ੍ਰੋ ਵੇਸ਼੍ਯਾਗਮਨਾਦਿਭਿਸ੍ਤਵ ਸਮ੍ਪੱਤਿਮ੍ ਅਪਵ੍ਯਯਿਤਵਾਨ੍ ਤਸ੍ਮਿੰਨਾਗਤਮਾਤ੍ਰੇ ਤਸ੍ਯੈਵ ਨਿਮਿੱਤੰ ਪੁਸ਼਼੍ਟੰ ਗੋਵਤ੍ਸੰ ਮਾਰਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","ਤਦਾ ਤਸ੍ਯ ਪਿਤਾਵੋਚਤ੍, ਹੇ ਪੁਤ੍ਰ ਤ੍ਵੰ ਸਰ੍ੱਵਦਾ ਮਯਾ ਸਹਾਸਿ ਤਸ੍ਮਾਨ੍ ਮਮ ਯਦ੍ਯਦਾਸ੍ਤੇ ਤਤ੍ਸਰ੍ੱਵੰ ਤਵ| ");
INSERT INTO sanpun_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","ਕਿਨ੍ਤੁ ਤਵਾਯੰ ਭ੍ਰਾਤਾ ਮ੍ਰੁʼਤਃ ਪੁਨਰਜੀਵੀਦ੍ ਹਾਰਿਤਸ਼੍ਚ ਭੂਤ੍ਵਾ ਪ੍ਰਾਪ੍ਤੋਭੂਤ੍, ਏਤਸ੍ਮਾਤ੍ ਕਾਰਣਾਦ੍ ਉਤ੍ਸਵਾਨਨ੍ਦੌ ਕਰ੍ੱਤੁਮ੍ ਉਚਿਤਮਸ੍ਮਾਕਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","ਅਪਰਞ੍ਚ ਯੀਸ਼ੁਃ ਸ਼ਿਸ਼਼੍ਯੇਭ੍ਯੋਨ੍ਯਾਮੇਕਾਂ ਕਥਾਂ ਕਥਯਾਮਾਸ ਕਸ੍ਯਚਿਦ੍ ਧਨਵਤੋ ਮਨੁਸ਼਼੍ਯਸ੍ਯ ਗ੍ਰੁʼਹਕਾਰ੍ੱਯਾਧੀਸ਼ੇ ਸਮ੍ਪੱਤੇਰਪਵ੍ਯਯੇ(ਅ)ਪਵਾਦਿਤੇ ਸਤਿ ");
INSERT INTO sanpun_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","ਤਸ੍ਯ ਪ੍ਰਭੁਸ੍ਤਮ੍ ਆਹੂਯ ਜਗਾਦ, ਤ੍ਵਯਿ ਯਾਮਿਮਾਂ ਕਥਾਂ ਸ਼੍ਰੁʼਣੋਮਿ ਸਾ ਕੀਦ੍ਰੁʼਸ਼ੀ? ਤ੍ਵੰ ਗ੍ਰੁʼਹਕਾਰ੍ੱਯਾਧੀਸ਼ਕਰ੍ੰਮਣੋ ਗਣਨਾਂ ਦਰ੍ਸ਼ਯ ਗ੍ਰੁʼਹਕਾਰ੍ੱਯਾਧੀਸ਼ਪਦੇ ਤ੍ਵੰ ਨ ਸ੍ਥਾਸ੍ਯਸਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","ਤਦਾ ਸ ਗ੍ਰੁʼਹਕਾਰ੍ੱਯਾਧੀਸ਼ੋ ਮਨਸਾ ਚਿਨ੍ਤਯਾਮਾਸ, ਪ੍ਰਭੁ ਰ੍ਯਦਿ ਮਾਂ ਗ੍ਰੁʼਹਕਾਰ੍ੱਯਾਧੀਸ਼ਪਦਾਦ੍ ਭ੍ਰੰਸ਼ਯਤਿ ਤਰ੍ਹਿ ਕਿੰ ਕਰਿਸ਼਼੍ਯੇ(ਅ)ਹੰ? ਮ੍ਰੁʼਦੰ ਖਨਿਤੁੰ ਮਮ ਸ਼ਕ੍ਤਿ ਰ੍ਨਾਸ੍ਤਿ ਭਿਕ੍ਸ਼਼ਿਤੁਞ੍ਚ ਲੱਜਿਸ਼਼੍ਯੇ(ਅ)ਹੰ| ");
INSERT INTO sanpun_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ਅਤਏਵ ਮਯਿ ਗ੍ਰੁʼਹਕਾਰ੍ੱਯਾਧੀਸ਼ਪਦਾਤ੍ ਚ੍ਯੁਤੇ ਸਤਿ ਯਥਾ ਲੋਕਾ ਮਹ੍ਯਮ੍ ਆਸ਼੍ਰਯੰ ਦਾਸ੍ਯਨ੍ਤਿ ਤਦਰ੍ਥੰ ਯਤ੍ਕਰ੍ੰਮ ਮਯਾ ਕਰਣੀਯੰ ਤਨ੍ ਨਿਰ੍ਣੀਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","ਪਸ਼੍ਚਾਤ੍ ਸ ਸ੍ਵਪ੍ਰਭੋਰੇਕੈਕਮ੍ ਅਧਮਰ੍ਣਮ੍ ਆਹੂਯ ਪ੍ਰਥਮੰ ਪਪ੍ਰੱਛ, ਤ੍ਵੱਤੋ ਮੇ ਪ੍ਰਭੁਣਾ ਕਤਿ ਪ੍ਰਾਪ੍ਯਮ੍? ");
INSERT INTO sanpun_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ਤਤਃ ਸ ਉਵਾਚ, ਏਕਸ਼ਤਾਢਕਤੈਲਾਨਿ; ਤਦਾ ਗ੍ਰੁʼਹਕਾਰ੍ੱਯਾਧੀਸ਼ਃ ਪ੍ਰੋਵਾਚ, ਤਵ ਪਤ੍ਰਮਾਨੀਯ ਸ਼ੀਘ੍ਰਮੁਪਵਿਸ਼੍ਯ ਤਤ੍ਰ ਪਞ੍ਚਾਸ਼ਤੰ ਲਿਖ| ");
INSERT INTO sanpun_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","ਪਸ਼੍ਚਾਦਨ੍ਯਮੇਕੰ ਪਪ੍ਰੱਛ, ਤ੍ਵੱਤੋ ਮੇ ਪ੍ਰਭੁਣਾ ਕਤਿ ਪ੍ਰਾਪ੍ਯਮ੍? ਤਤਃ ਸੋਵਾਦੀਦ੍ ਏਕਸ਼ਤਾਢਕਗੋਧੂਮਾਃ; ਤਦਾ ਸ ਕਥਯਾਮਾਸ, ਤਵ ਪਤ੍ਰਮਾਨੀਯ ਅਸ਼ੀਤਿੰ ਲਿਖ| ");
INSERT INTO sanpun_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","ਤੇਨੈਵ ਪ੍ਰਭੁਸ੍ਤਮਯਥਾਰ੍ਥਕ੍ਰੁʼਤਮ੍ ਅਧੀਸ਼ੰ ਤਦ੍ਬੁੱਧਿਨੈਪੁਣ੍ਯਾਤ੍ ਪ੍ਰਸ਼ਸ਼ੰਸ; ਇੱਥੰ ਦੀਪ੍ਤਿਰੂਪਸਨ੍ਤਾਨੇਭ੍ਯ ਏਤਤ੍ਸੰਸਾਰਸ੍ਯ ਸਨ੍ਤਾਨਾ ਵਰ੍ੱਤਮਾਨਕਾਲੇ(ਅ)ਧਿਕਬੁੱਧਿਮਨ੍ਤੋ ਭਵਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","ਅਤੋ ਵਦਾਮਿ ਯੂਯਮਪ੍ਯਯਥਾਰ੍ਥੇਨ ਧਨੇਨ ਮਿਤ੍ਰਾਣਿ ਲਭਧ੍ਵੰ ਤਤੋ ਯੁਸ਼਼੍ਮਾਸੁ ਪਦਭ੍ਰਸ਼਼੍ਟੇਸ਼਼੍ਵਪਿ ਤਾਨਿ ਚਿਰਕਾਲਮ੍ ਆਸ਼੍ਰਯੰ ਦਾਸ੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ਯਃ ਕਸ਼੍ਚਿਤ੍ ਕ੍ਸ਼਼ੁਦ੍ਰੇ ਕਾਰ੍ੱਯੇ ਵਿਸ਼੍ਵਾਸ੍ਯੋ ਭਵਤਿ ਸ ਮਹਤਿ ਕਾਰ੍ੱਯੇਪਿ ਵਿਸ਼੍ਵਾਸ੍ਯੋ ਭਵਤਿ, ਕਿਨ੍ਤੁ ਯਃ ਕਸ਼੍ਚਿਤ੍ ਕ੍ਸ਼਼ੁਦ੍ਰੇ ਕਾਰ੍ੱਯੇ(ਅ)ਵਿਸ਼੍ਵਾਸ੍ਯੋ ਭਵਤਿ ਸ ਮਹਤਿ ਕਾਰ੍ੱਯੇਪ੍ਯਵਿਸ਼੍ਵਾਸ੍ਯੋ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ਅਤਏਵ ਅਯਥਾਰ੍ਥੇਨ ਧਨੇਨ ਯਦਿ ਯੂਯਮਵਿਸ਼੍ਵਾਸ੍ਯਾ ਜਾਤਾਸ੍ਤਰ੍ਹਿ ਸਤ੍ਯੰ ਧਨੰ ਯੁਸ਼਼੍ਮਾਕੰ ਕਰੇਸ਼਼ੁ ਕਃ ਸਮਰ੍ਪਯਿਸ਼਼੍ਯਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","ਯਦਿ ਚ ਪਰਧਨੇਨ ਯੂਯਮ੍ ਅਵਿਸ਼੍ਵਾਸ੍ਯਾ ਭਵਥ ਤਰ੍ਹਿ ਯੁਸ਼਼੍ਮਾਕੰ ਸ੍ਵਕੀਯਧਨੰ ਯੁਸ਼਼੍ਮਭ੍ਯੰ ਕੋ ਦਾਸ੍ਯਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","ਕੋਪਿ ਦਾਸ ਉਭੌ ਪ੍ਰਭੂ ਸੇਵਿਤੁੰ ਨ ਸ਼ਕ੍ਨੋਤਿ, ਯਤ ਏਕਸ੍ਮਿਨ੍ ਪ੍ਰੀਯਮਾਣੋ(ਅ)ਨ੍ਯਸ੍ਮਿੰਨਪ੍ਰੀਯਤੇ ਯਦ੍ਵਾ ਏਕੰ ਜਨੰ ਸਮਾਦ੍ਰੁʼਤ੍ਯ ਤਦਨ੍ਯੰ ਤੁੱਛੀਕਰੋਤਿ ਤਦ੍ਵਦ੍ ਯੂਯਮਪਿ ਧਨੇਸ਼੍ਵਰੌ ਸੇਵਿਤੁੰ ਨ ਸ਼ਕ੍ਨੁਥ| ");
INSERT INTO sanpun_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ਤਦੈਤਾਃ ਸਰ੍ੱਵਾਃ ਕਥਾਃ ਸ਼੍ਰੁਤ੍ਵਾ ਲੋਭਿਫਿਰੂਸ਼ਿਨਸ੍ਤਮੁਪਜਹਸੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ਤਤਃ ਸ ਉਵਾਚ, ਯੂਯੰ ਮਨੁਸ਼਼੍ਯਾਣਾਂ ਨਿਕਟੇ ਸ੍ਵਾਨ੍ ਨਿਰ੍ਦੋਸ਼਼ਾਨ੍ ਦਰ੍ਸ਼ਯਥ ਕਿਨ੍ਤੁ ਯੁਸ਼਼੍ਮਾਕਮ੍ ਅਨ੍ਤਃਕਰਣਾਨੀਸ਼੍ਵਰੋ ਜਾਨਾਤਿ, ਯਤ੍ ਮਨੁਸ਼਼੍ਯਾਣਾਮ੍ ਅਤਿ ਪ੍ਰਸ਼ੰਸ੍ਯੰ ਤਦ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਘ੍ਰੁʼਣ੍ਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","ਯੋਹਨ ਆਗਮਨਪਰ੍ੱਯਨਤੰ ਯੁਸ਼਼੍ਮਾਕੰ ਸਮੀਪੇ ਵ੍ਯਵਸ੍ਥਾਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਾਂ ਲੇਖਨਾਨਿ ਚਾਸਨ੍ ਤਤਃ ਪ੍ਰਭ੍ਰੁʼਤਿ ਈਸ਼੍ਵਰਰਾਜ੍ਯਸ੍ਯ ਸੁਸੰਵਾਦਃ ਪ੍ਰਚਰਤਿ, ਏਕੈਕੋ ਲੋਕਸ੍ਤਨ੍ਮਧ੍ਯੰ ਯਤ੍ਨੇਨ ਪ੍ਰਵਿਸ਼ਤਿ ਚ| ");
INSERT INTO sanpun_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ਵਰੰ ਨਭਸਃ ਪ੍ਰੁʼਥਿਵ੍ਯਾਸ਼੍ਚ ਲੋਪੋ ਭਵਿਸ਼਼੍ਯਤਿ ਤਥਾਪਿ ਵ੍ਯਵਸ੍ਥਾਯਾ ਏਕਬਿਨ੍ਦੋਰਪਿ ਲੋਪੋ ਨ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","ਯਃ ਕਸ਼੍ਚਿਤ੍ ਸ੍ਵੀਯਾਂ ਭਾਰ੍ੱਯਾਂ ਵਿਹਾਯ ਸ੍ਤ੍ਰਿਯਮਨ੍ਯਾਂ ਵਿਵਹਤਿ ਸ ਪਰਦਾਰਾਨ੍ ਗੱਛਤਿ, ਯਸ਼੍ਚ ਤਾ ਤ੍ਯਕ੍ਤਾਂ ਨਾਰੀਂ ਵਿਵਹਤਿ ਸੋਪਿ ਪਰਦਾਰਾਨ ਗੱਛਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ਏਕੋ ਧਨੀ ਮਨੁਸ਼਼੍ਯਃ ਸ਼ੁਕ੍ਲਾਨਿ ਸੂਕ੍ਸ਼਼੍ਮਾਣਿ ਵਸ੍ਤ੍ਰਾਣਿ ਪਰ੍ੱਯਦਧਾਤ੍ ਪ੍ਰਤਿਦਿਨੰ ਪਰਿਤੋਸ਼਼ਰੂਪੇਣਾਭੁੰਕ੍ਤਾਪਿਵੱਚ| ");
INSERT INTO sanpun_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","ਸਰ੍ੱਵਾਙ੍ਗੇ ਕ੍ਸ਼਼ਤਯੁਕ੍ਤ ਇਲਿਯਾਸਰਨਾਮਾ ਕਸ਼੍ਚਿਦ੍ ਦਰਿਦ੍ਰਸ੍ਤਸ੍ਯ ਧਨਵਤੋ ਭੋਜਨਪਾਤ੍ਰਾਤ੍ ਪਤਿਤਮ੍ ਉੱਛਿਸ਼਼੍ਟੰ ਭੋਕ੍ਤੁੰ ਵਾਞ੍ਛਨ੍ ਤਸ੍ਯ ਦ੍ਵਾਰੇ ਪਤਿਤ੍ਵਾਤਿਸ਼਼੍ਠਤ੍; ");
INSERT INTO sanpun_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ਅਥ ਸ਼੍ਵਾਨ ਆਗਤ੍ਯ ਤਸ੍ਯ ਕ੍ਸ਼਼ਤਾਨ੍ਯਲਿਹਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","ਕਿਯਤ੍ਕਾਲਾਤ੍ਪਰੰ ਸ ਦਰਿਦ੍ਰਃ ਪ੍ਰਾਣਾਨ੍ ਜਹੌ; ਤਤਃ ਸ੍ਵਰ੍ਗੀਯਦੂਤਾਸ੍ਤੰ ਨੀਤ੍ਵਾ ਇਬ੍ਰਾਹੀਮਃ ਕ੍ਰੋਡ ਉਪਵੇਸ਼ਯਾਮਾਸੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ਪਸ਼੍ਚਾਤ੍ ਸ ਧਨਵਾਨਪਿ ਮਮਾਰ, ਤੰ ਸ਼੍ਮਸ਼ਾਨੇ ਸ੍ਥਾਪਯਾਮਾਸੁਸ਼੍ਚ; ਕਿਨ੍ਤੁ ਪਰਲੋਕੇ ਸ ਵੇਦਨਾਕੁਲਃ ਸਨ੍ ਊਰ੍ੱਧ੍ਵਾਂ ਨਿਰੀਕ੍ਸ਼਼੍ਯ ਬਹੁਦੂਰਾਦ੍ ਇਬ੍ਰਾਹੀਮੰ ਤਤ੍ਕ੍ਰੋਡ ਇਲਿਯਾਸਰਞ੍ਚ ਵਿਲੋਕ੍ਯ ਰੁਵੰਨੁਵਾਚ; ");
INSERT INTO sanpun_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ਹੇ ਪਿਤਰ੍ ਇਬ੍ਰਾਹੀਮ੍ ਅਨੁਗ੍ਰੁʼਹ੍ਯ ਅਙ੍ਗੁਲ੍ਯਗ੍ਰਭਾਗੰ ਜਲੇ ਮੱਜਯਿਤ੍ਵਾ ਮਮ ਜਿਹ੍ਵਾਂ ਸ਼ੀਤਲਾਂ ਕਰ੍ੱਤੁਮ੍ ਇਲਿਯਾਸਰੰ ਪ੍ਰੇਰਯ, ਯਤੋ ਵਹ੍ਨਿਸ਼ਿਖਾਤੋਹੰ ਵ੍ਯਥਿਤੋਸ੍ਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","ਤਦਾ ਇਬ੍ਰਾਹੀਮ੍ ਬਭਾਸ਼਼ੇ, ਹੇ ਪੁਤ੍ਰ ਤ੍ਵੰ ਜੀਵਨ੍ ਸਮ੍ਪਦੰ ਪ੍ਰਾਪ੍ਤਵਾਨ੍ ਇਲਿਯਾਸਰਸ੍ਤੁ ਵਿਪਦੰ ਪ੍ਰਾਪ੍ਤਵਾਨ੍ ਏਤਤ੍ ਸ੍ਮਰ, ਕਿਨ੍ਤੁ ਸਮ੍ਪ੍ਰਤਿ ਤਸ੍ਯ ਸੁਖੰ ਤਵ ਚ ਦੁਃਖੰ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","ਅਪਰਮਪਿ ਯੁਸ਼਼੍ਮਾਕਮ੍ ਅਸ੍ਮਾਕਞ੍ਚ ਸ੍ਥਾਨਯੋ ਰ੍ਮਧ੍ਯੇ ਮਹਦ੍ਵਿੱਛੇਦੋ(ਅ)ਸ੍ਤਿ ਤਤ ਏਤਤ੍ਸ੍ਥਾਨਸ੍ਯ ਲੋਕਾਸ੍ਤਤ੍ ਸ੍ਥਾਨੰ ਯਾਤੁੰ ਯਦ੍ਵਾ ਤਤ੍ਸ੍ਥਾਨਸ੍ਯ ਲੋਕਾ ਏਤਤ੍ ਸ੍ਥਾਨਮਾਯਾਤੁੰ ਨ ਸ਼ਕ੍ਨੁਵਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","ਤਦਾ ਸ ਉਕ੍ਤਵਾਨ੍, ਹੇ ਪਿਤਸ੍ਤਰ੍ਹਿ ਤ੍ਵਾਂ ਨਿਵੇਦਯਾਮਿ ਮਮ ਪਿਤੁ ਰ੍ਗੇਹੇ ਯੇ ਮਮ ਪਞ੍ਚ ਭ੍ਰਾਤਰਃ ਸਨ੍ਤਿ ");
INSERT INTO sanpun_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ਤੇ ਯਥੈਤਦ੍ ਯਾਤਨਾਸ੍ਥਾਨੰ ਨਾਯਾਸ੍ਯਨ੍ਤਿ ਤਥਾ ਮਨ੍ਤ੍ਰਣਾਂ ਦਾਤੁੰ ਤੇਸ਼਼ਾਂ ਸਮੀਪਮ੍ ਇਲਿਯਾਸਰੰ ਪ੍ਰੇਰਯ| ");
INSERT INTO sanpun_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","ਤਤ ਇਬ੍ਰਾਹੀਮ੍ ਉਵਾਚ, ਮੂਸਾਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਾਞ੍ਚ ਪੁਸ੍ਤਕਾਨਿ ਤੇਸ਼਼ਾਂ ਨਿਕਟੇ ਸਨ੍ਤਿ ਤੇ ਤਦ੍ਵਚਨਾਨਿ ਮਨ੍ਯਨ੍ਤਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","ਤਦਾ ਸ ਨਿਵੇਦਯਾਮਾਸ, ਹੇ ਪਿਤਰ੍ ਇਬ੍ਰਾਹੀਮ੍ ਨ ਤਥਾ, ਕਿਨ੍ਤੁ ਯਦਿ ਮ੍ਰੁʼਤਲੋਕਾਨਾਂ ਕਸ਼੍ਚਿਤ੍ ਤੇਸ਼਼ਾਂ ਸਮੀਪੰ ਯਾਤਿ ਤਰ੍ਹਿ ਤੇ ਮਨਾਂਸਿ ਵ੍ਯਾਘੋਟਯਿਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","ਤਤ ਇਬ੍ਰਾਹੀਮ੍ ਜਗਾਦ, ਤੇ ਯਦਿ ਮੂਸਾਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਾਞ੍ਚ ਵਚਨਾਨਿ ਨ ਮਨ੍ਯਨ੍ਤੇ ਤਰ੍ਹਿ ਮ੍ਰੁʼਤਲੋਕਾਨਾਂ ਕਸ੍ਮਿੰਸ਼੍ਚਿਦ੍ ਉੱਥਿਤੇਪਿ ਤੇ ਤਸ੍ਯ ਮਨ੍ਤ੍ਰਣਾਂ ਨ ਮੰਸ੍ਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ਇਤਃ ਪਰੰ ਯੀਸ਼ੁਃ ਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਉਵਾਚ, ਵਿਘ੍ਨੈਰਵਸ਼੍ਯਮ੍ ਆਗਨ੍ਤਵ੍ਯੰ ਕਿਨ੍ਤੁ ਵਿਘ੍ਨਾ ਯੇਨ ਘਟਿਸ਼਼੍ਯਨ੍ਤੇ ਤਸ੍ਯ ਦੁਰ੍ਗਤਿ ਰ੍ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ਏਤੇਸ਼਼ਾਂ ਕ੍ਸ਼਼ੁਦ੍ਰਪ੍ਰਾਣਿਨਾਮ੍ ਏਕਸ੍ਯਾਪਿ ਵਿਘ੍ਨਜਨਨਾਤ੍ ਕਣ੍ਠਬੱਧਪੇਸ਼਼ਣੀਕਸ੍ਯ ਤਸ੍ਯ ਸਾਗਰਾਗਾਧਜਲੇ ਮੱਜਨੰ ਭਦ੍ਰੰ| ");
INSERT INTO sanpun_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","ਯੂਯੰ ਸ੍ਵੇਸ਼਼ੁ ਸਾਵਧਾਨਾਸ੍ਤਿਸ਼਼੍ਠਤ; ਤਵ ਭ੍ਰਾਤਾ ਯਦਿ ਤਵ ਕਿਞ੍ਚਿਦ੍ ਅਪਰਾਧ੍ਯਤਿ ਤਰ੍ਹਿ ਤੰ ਤਰ੍ਜਯ, ਤੇਨ ਯਦਿ ਮਨਃ ਪਰਿਵਰ੍ੱਤਯਤਿ ਤਰ੍ਹਿ ਤੰ ਕ੍ਸ਼਼ਮਸ੍ਵ| ");
INSERT INTO sanpun_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","ਪੁਨਰੇਕਦਿਨਮਧ੍ਯੇ ਯਦਿ ਸ ਤਵ ਸਪ੍ਤਕ੍ਰੁʼਤ੍ਵੋ(ਅ)ਪਰਾਧ੍ਯਤਿ ਕਿਨ੍ਤੁ ਸਪ੍ਤਕ੍ਰੁʼਤ੍ਵ ਆਗਤ੍ਯ ਮਨਃ ਪਰਿਵਰ੍ਤ੍ਯ ਮਯਾਪਰਾੱਧਮ੍ ਇਤਿ ਵਦਤਿ ਤਰ੍ਹਿ ਤੰ ਕ੍ਸ਼਼ਮਸ੍ਵ| ");
INSERT INTO sanpun_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","ਤਦਾ ਪ੍ਰੇਰਿਤਾਃ ਪ੍ਰਭੁਮ੍ ਅਵਦਨ੍ ਅਸ੍ਮਾਕੰ ਵਿਸ਼੍ਵਾਸੰ ਵਰ੍ੱਧਯ| ");
INSERT INTO sanpun_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ਪ੍ਰਭੁਰੁਵਾਚ, ਯਦਿ ਯੁਸ਼਼੍ਮਾਕੰ ਸਰ੍ਸ਼਼ਪੈਕਪ੍ਰਮਾਣੋ ਵਿਸ਼੍ਵਾਸੋਸ੍ਤਿ ਤਰ੍ਹਿ ਤ੍ਵੰ ਸਮੂਲਮੁਤ੍ਪਾਟਿਤੋ ਭੂਤ੍ਵਾ ਸਮੁਦ੍ਰੇ ਰੋਪਿਤੋ ਭਵ ਕਥਾਯਾਮ੍ ਏਤਸ੍ਯਾਮ੍ ਏਤਦੁਡੁਮ੍ਬਰਾਯ ਕਥਿਤਾਯਾਂ ਸ ਯੁਸ਼਼੍ਮਾਕਮਾਜ੍ਞਾਵਹੋ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","ਅਪਰੰ ਸ੍ਵਦਾਸੇ ਹਲੰ ਵਾਹਯਿਤ੍ਵਾ ਵਾ ਪਸ਼ੂਨ੍ ਚਾਰਯਿਤ੍ਵਾ ਕ੍ਸ਼਼ੇਤ੍ਰਾਦ੍ ਆਗਤੇ ਸਤਿ ਤੰ ਵਦਤਿ, ਏਹਿ ਭੋਕ੍ਤੁਮੁਪਵਿਸ਼, ਯੁਸ਼਼੍ਮਾਕਮ੍ ਏਤਾਦ੍ਰੁʼਸ਼ਃ ਕੋਸ੍ਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ਵਰਞ੍ਚ ਪੂਰ੍ੱਵੰ ਮਮ ਖਾਦ੍ਯਮਾਸਾਦ੍ਯ ਯਾਵਦ੍ ਭੁਞ੍ਜੇ ਪਿਵਾਮਿ ਚ ਤਾਵਦ੍ ਬੱਧਕਟਿਃ ਪਰਿਚਰ ਪਸ਼੍ਚਾਤ੍ ਤ੍ਵਮਪਿ ਭੋਕ੍ਸ਼਼੍ਯਸੇ ਪਾਸ੍ਯਸਿ ਚ ਕਥਾਮੀਦ੍ਰੁʼਸ਼ੀਂ ਕਿੰ ਨ ਵਕ੍ਸ਼਼੍ਯਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","ਤੇਨ ਦਾਸੇਨ ਪ੍ਰਭੋਰਾਜ੍ਞਾਨੁਰੂਪੇ ਕਰ੍ੰਮਣਿ ਕ੍ਰੁʼਤੇ ਪ੍ਰਭੁਃ ਕਿੰ ਤਸ੍ਮਿਨ੍ ਬਾਧਿਤੋ ਜਾਤਃ? ਨੇੱਥੰ ਬੁਧ੍ਯਤੇ ਮਯਾ| ");
INSERT INTO sanpun_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ਇੱਥੰ ਨਿਰੂਪਿਤੇਸ਼਼ੁ ਸਰ੍ੱਵਕਰ੍ੰਮਸੁ ਕ੍ਰੁʼਤੇਸ਼਼ੁ ਸਤ੍ਮੁ ਯੂਯਮਪੀਦੰ ਵਾਕ੍ਯੰ ਵਦਥ, ਵਯਮ੍ ਅਨੁਪਕਾਰਿਣੋ ਦਾਸਾ ਅਸ੍ਮਾਭਿਰ੍ਯਦ੍ਯਤ੍ਕਰ੍ੱਤਵ੍ਯੰ ਤਨ੍ਮਾਤ੍ਰਮੇਵ ਕ੍ਰੁʼਤੰ| ");
INSERT INTO sanpun_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ਸ ਯਿਰੂਸ਼ਾਲਮਿ ਯਾਤ੍ਰਾਂ ਕੁਰ੍ੱਵਨ੍ ਸ਼ੋਮਿਰੋਣ੍ਗਾਲੀਲ੍ਪ੍ਰਦੇਸ਼ਮਧ੍ਯੇਨ ਗੱਛਤਿ, ");
INSERT INTO sanpun_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ਏਤਰ੍ਹਿ ਕੁਤ੍ਰਚਿਦ੍ ਗ੍ਰਾਮੇ ਪ੍ਰਵੇਸ਼ਮਾਤ੍ਰੇ ਦਸ਼ਕੁਸ਼਼੍ਠਿਨਸ੍ਤੰ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਕ੍ਰੁʼਤ੍ਵਾ ");
INSERT INTO sanpun_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ਦੂਰੇ ਤਿਸ਼਼੍ਠਨਤ ਉੱਚੈ ਰ੍ਵਕ੍ਤੁਮਾਰੇਭਿਰੇ, ਹੇ ਪ੍ਰਭੋ ਯੀਸ਼ੋ ਦਯਸ੍ਵਾਸ੍ਮਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ਤਤਃ ਸ ਤਾਨ੍ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਜਗਾਦ, ਯੂਯੰ ਯਾਜਕਾਨਾਂ ਸਮੀਪੇ ਸ੍ਵਾਨ੍ ਦਰ੍ਸ਼ਯਤ, ਤਤਸ੍ਤੇ ਗੱਛਨ੍ਤੋ ਰੋਗਾਤ੍ ਪਰਿਸ਼਼੍ਕ੍ਰੁʼਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","ਤਦਾ ਤੇਸ਼਼ਾਮੇਕਃ ਸ੍ਵੰ ਸ੍ਵਸ੍ਥੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਪ੍ਰੋੱਚੈਰੀਸ਼੍ਵਰੰ ਧਨ੍ਯੰ ਵਦਨ੍ ਵ੍ਯਾਘੁਟ੍ਯਾਯਾਤੋ ਯੀਸ਼ੋ ਰ੍ਗੁਣਾਨਨੁਵਦਨ੍ ਤੱਚਰਣਾਧੋਭੂਮੌ ਪਪਾਤ; ");
INSERT INTO sanpun_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ਸ ਚਾਸੀਤ੍ ਸ਼ੋਮਿਰੋਣੀ| ");
INSERT INTO sanpun_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ਤਦਾ ਯੀਸ਼ੁਰਵਦਤ੍, ਦਸ਼ਜਨਾਃ ਕਿੰ ਨ ਪਰਿਸ਼਼੍ਕ੍ਰੁʼਤਾਃ? ਤਹ੍ਯਨ੍ਯੇ ਨਵਜਨਾਃ ਕੁਤ੍ਰ? ");
INSERT INTO sanpun_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ਈਸ਼੍ਵਰੰ ਧਨ੍ਯੰ ਵਦਨ੍ਤਮ੍ ਏਨੰ ਵਿਦੇਸ਼ਿਨੰ ਵਿਨਾ ਕੋਪ੍ਯਨ੍ਯੋ ਨ ਪ੍ਰਾਪ੍ਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ਤਦਾ ਸ ਤਮੁਵਾਚ, ਤ੍ਵਮੁੱਥਾਯ ਯਾਹਿ ਵਿਸ਼੍ਵਾਸਸ੍ਤੇ ਤ੍ਵਾਂ ਸ੍ਵਸ੍ਥੰ ਕ੍ਰੁʼਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","ਅਥ ਕਦੇਸ਼੍ਵਰਸ੍ਯ ਰਾਜਤ੍ਵੰ ਭਵਿਸ਼਼੍ਯਤੀਤਿ ਫਿਰੂਸ਼ਿਭਿਃ ਪ੍ਰੁʼਸ਼਼੍ਟੇ ਸ ਪ੍ਰਤ੍ਯੁਵਾਚ, ਈਸ਼੍ਵਰਸ੍ਯ ਰਾਜਤ੍ਵਮ੍ ਐਸ਼੍ਵਰ੍ੱਯਦਰ੍ਸ਼ਨੇਨ ਨ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ਅਤ ਏਤਸ੍ਮਿਨ੍ ਪਸ਼੍ਯ ਤਸ੍ਮਿਨ੍ ਵਾ ਪਸ਼੍ਯ, ਇਤਿ ਵਾਕ੍ਯੰ ਲੋਕਾ ਵਕ੍ਤੁੰ ਨ ਸ਼ਕ੍ਸ਼਼੍ਯਨ੍ਤਿ, ਈਸ਼੍ਵਰਸ੍ਯ ਰਾਜਤ੍ਵੰ ਯੁਸ਼਼੍ਮਾਕਮ੍ ਅਨ੍ਤਰੇਵਾਸ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ਤਤਃ ਸ ਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਜਗਾਦ, ਯਦਾ ਯੁਸ਼਼੍ਮਾਭਿ ਰ੍ਮਨੁਜਸੁਤਸ੍ਯ ਦਿਨਮੇਕੰ ਦ੍ਰਸ਼਼੍ਟੁਮ੍ ਵਾਞ੍ਛਿਸ਼਼੍ਯਤੇ ਕਿਨ੍ਤੁ ਨ ਦਰ੍ਸ਼ਿਸ਼਼੍ਯਤੇ, ਈਦ੍ਰੁʼੱਕਾਲ ਆਯਾਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","ਤਦਾਤ੍ਰ ਪਸ਼੍ਯ ਵਾ ਤਤ੍ਰ ਪਸ਼੍ਯੇਤਿ ਵਾਕ੍ਯੰ ਲੋਕਾ ਵਕ੍ਸ਼਼੍ਯਨ੍ਤਿ, ਕਿਨ੍ਤੁ ਤੇਸ਼਼ਾਂ ਪਸ਼੍ਚਾਤ੍ ਮਾ ਯਾਤ, ਮਾਨੁਗੱਛਤ ਚ| ");
INSERT INTO sanpun_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","ਯਤਸ੍ਤਡਿਦ੍ ਯਥਾਕਾਸ਼ੈਕਦਿਸ਼੍ਯੁਦਿਯ ਤਦਨ੍ਯਾਮਪਿ ਦਿਸ਼ੰ ਵ੍ਯਾਪ੍ਯ ਪ੍ਰਕਾਸ਼ਤੇ ਤਦ੍ਵਤ੍ ਨਿਜਦਿਨੇ ਮਨੁਜਸੂਨੁਃ ਪ੍ਰਕਾਸ਼ਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","ਕਿਨ੍ਤੁ ਤਤ੍ਪੂਰ੍ੱਵੰ ਤੇਨਾਨੇਕਾਨਿ ਦੁਃਖਾਨਿ ਭੋਕ੍ਤਵ੍ਯਾਨ੍ਯੇਤਦ੍ਵਰ੍ੱਤਮਾਨਲੋਕੈਸ਼੍ਚ ਸੋ(ਅ)ਵਜ੍ਞਾਤਵ੍ਯਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","ਨੋਹਸ੍ਯ ਵਿਦ੍ਯਮਾਨਕਾਲੇ ਯਥਾਭਵਤ੍ ਮਨੁਸ਼਼੍ਯਸੂਨੋਃ ਕਾਲੇਪਿ ਤਥਾ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ਯਾਵਤ੍ਕਾਲੰ ਨੋਹੋ ਮਹਾਪੋਤੰ ਨਾਰੋਹਦ੍ ਆਪ੍ਲਾਵਿਵਾਰ੍ੱਯੇਤ੍ਯ ਸਰ੍ੱਵੰ ਨਾਨਾਸ਼ਯੱਚ ਤਾਵਤ੍ਕਾਲੰ ਯਥਾ ਲੋਕਾ ਅਭੁਞ੍ਜਤਾਪਿਵਨ੍ ਵ੍ਯਵਹਨ੍ ਵ੍ਯਵਾਹਯੰਸ਼੍ਚ; ");
INSERT INTO sanpun_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ਇੱਥੰ ਲੋਟੋ ਵਰ੍ੱਤਮਾਨਕਾਲੇਪਿ ਯਥਾ ਲੋਕਾ ਭੋਜਨਪਾਨਕ੍ਰਯਵਿਕ੍ਰਯਰੋਪਣਗ੍ਰੁʼਹਨਿਰ੍ੰਮਾਣਕਰ੍ੰਮਸੁ ਪ੍ਰਾਵਰ੍ੱਤਨ੍ਤ, ");
INSERT INTO sanpun_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ਕਿਨ੍ਤੁ ਯਦਾ ਲੋਟ੍ ਸਿਦੋਮੋ ਨਿਰ੍ਜਗਾਮ ਤਦਾ ਨਭਸਃ ਸਗਨ੍ਧਕਾਗ੍ਨਿਵ੍ਰੁʼਸ਼਼੍ਟਿ ਰ੍ਭੂਤ੍ਵਾ ਸਰ੍ੱਵੰ ਵ੍ਯਨਾਸ਼ਯਤ੍ ");
INSERT INTO sanpun_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","ਤਦ੍ਵਨ੍ ਮਾਨਵਪੁਤ੍ਰਪ੍ਰਕਾਸ਼ਦਿਨੇਪਿ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","ਤਦਾ ਯਦਿ ਕਸ਼੍ਚਿਦ੍ ਗ੍ਰੁʼਹੋਪਰਿ ਤਿਸ਼਼੍ਠਤਿ ਤਰ੍ਹਿ ਸ ਗ੍ਰੁʼਹਮਧ੍ਯਾਤ੍ ਕਿਮਪਿ ਦ੍ਰਵ੍ਯਮਾਨੇਤੁਮ੍ ਅਵਰੁਹ੍ਯ ਨੈਤੁ; ਯਸ਼੍ਚ ਕ੍ਸ਼਼ੇਤ੍ਰੇ ਤਿਸ਼਼੍ਠਤਿ ਸੋਪਿ ਵ੍ਯਾਘੁਟ੍ਯ ਨਾਯਾਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","ਲੋਟਃ ਪਤ੍ਨੀਂ ਸ੍ਮਰਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ਯਃ ਪ੍ਰਾਣਾਨ੍ ਰਕ੍ਸ਼਼ਿਤੁੰ ਚੇਸ਼਼੍ਟਿਸ਼਼੍ਯਤੇ ਸ ਪ੍ਰਾਣਾਨ੍ ਹਾਰਯਿਸ਼਼੍ਯਤਿ ਯਸ੍ਤੁ ਪ੍ਰਾਣਾਨ੍ ਹਾਰਯਿਸ਼਼੍ਯਤਿ ਸਏਵ ਪ੍ਰਾਣਾਨ੍ ਰਕ੍ਸ਼਼ਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","ਯੁਸ਼਼੍ਮਾਨਹੰ ਵਚ੍ਮਿ ਤਸ੍ਯਾਂ ਰਾਤ੍ਰੌ ਸ਼ੱਯੈਕਗਤਯੋ ਰ੍ਲੋਕਯੋਰੇਕੋ ਧਾਰਿਸ਼਼੍ਯਤੇ ਪਰਸ੍ਤ੍ਯਕ੍ਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ਸ੍ਤ੍ਰਿਯੌ ਯੁਗਪਤ੍ ਪੇਸ਼਼ਣੀਂ ਵ੍ਯਾਵਰ੍ੱਤਯਿਸ਼਼੍ਯਤਸ੍ਤਯੋਰੇਕਾ ਧਾਰਿਸ਼਼੍ਯਤੇ ਪਰਾਤ੍ਯਕ੍ਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","ਪੁਰੁਸ਼਼ੌ ਕ੍ਸ਼਼ੇਤ੍ਰੇ ਸ੍ਥਾਸ੍ਯਤਸ੍ਤਯੋਰੇਕੋ ਧਾਰਿਸ਼਼੍ਯਤੇ ਪਰਸ੍ਤ੍ਯਕ੍ਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ਤਦਾ ਤੇ ਪਪ੍ਰੱਛੁਃ, ਹੇ ਪ੍ਰਭੋ ਕੁਤ੍ਰੇੱਥੰ ਭਵਿਸ਼਼੍ਯਤਿ? ਤਤਃ ਸ ਉਵਾਚ, ਯਤ੍ਰ ਸ਼ਵਸ੍ਤਿਸ਼਼੍ਠਤਿ ਤਤ੍ਰ ਗ੍ਰੁʼਧ੍ਰਾ ਮਿਲਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ਅਪਰਞ੍ਚ ਲੋਕੈਰਕ੍ਲਾਨ੍ਤੈ ਰ੍ਨਿਰਨ੍ਤਰੰ ਪ੍ਰਾਰ੍ਥਯਿਤਵ੍ਯਮ੍ ਇਤ੍ਯਾਸ਼ਯੇਨ ਯੀਸ਼ੁਨਾ ਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤ ਏਕਃ ਕਥਿਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","ਕੁਤ੍ਰਚਿੰਨਗਰੇ ਕਸ਼੍ਚਿਤ੍ ਪ੍ਰਾਡ੍ਵਿਵਾਕ ਆਸੀਤ੍ ਸ ਈਸ਼੍ਵਰਾੰਨਾਬਿਭੇਤ੍ ਮਾਨੁਸ਼਼ਾਂਸ਼੍ਚ ਨਾਮਨ੍ਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","ਅਥ ਤਤ੍ਪੁਰਵਾਸਿਨੀ ਕਾਚਿਦ੍ਵਿਧਵਾ ਤਤ੍ਸਮੀਪਮੇਤ੍ਯ ਵਿਵਾਦਿਨਾ ਸਹ ਮਮ ਵਿਵਾਦੰ ਪਰਿਸ਼਼੍ਕੁਰ੍ੱਵਿਤਿ ਨਿਵੇਦਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ਤਤਃ ਸ ਪ੍ਰਾਡ੍ਵਿਵਾਕਃ ਕਿਯੱਦਿਨਾਨਿ ਨ ਤਦਙ੍ਗੀਕ੍ਰੁʼਤਵਾਨ੍ ਪਸ਼੍ਚਾੱਚਿੱਤੇ ਚਿਨ੍ਤਯਾਮਾਸ, ਯਦ੍ਯਪੀਸ਼੍ਵਰਾੰਨ ਬਿਭੇਮਿ ਮਨੁਸ਼਼੍ਯਾਨਪਿ ਨ ਮਨ੍ਯੇ ");
INSERT INTO sanpun_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ਤਥਾਪ੍ਯੇਸ਼਼ਾ ਵਿਧਵਾ ਮਾਂ ਕ੍ਲਿਸ਼੍ਨਾਤਿ ਤਸ੍ਮਾਦਸ੍ਯਾ ਵਿਵਾਦੰ ਪਰਿਸ਼਼੍ਕਰਿਸ਼਼੍ਯਾਮਿ ਨੋਚੇਤ੍ ਸਾ ਸਦਾਗਤ੍ਯ ਮਾਂ ਵ੍ਯਗ੍ਰੰ ਕਰਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ਪਸ਼੍ਚਾਤ੍ ਪ੍ਰਭੁਰਵਦਦ੍ ਅਸਾਵਨ੍ਯਾਯਪ੍ਰਾਡ੍ਵਿਵਾਕੋ ਯਦਾਹ ਤਤ੍ਰ ਮਨੋ ਨਿਧਧ੍ਵੰ| ");
INSERT INTO sanpun_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ਈਸ਼੍ਵਰਸ੍ਯ ਯੇ (ਅ)ਭਿਰੁਚਿਤਲੋਕਾ ਦਿਵਾਨਿਸ਼ੰ ਪ੍ਰਾਰ੍ਥਯਨ੍ਤੇ ਸ ਬਹੁਦਿਨਾਨਿ ਵਿਲਮ੍ਬ੍ਯਾਪਿ ਤੇਸ਼਼ਾਂ ਵਿਵਾਦਾਨ੍ ਕਿੰ ਨ ਪਰਿਸ਼਼੍ਕਰਿਸ਼਼੍ਯਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","ਯੁਸ਼਼੍ਮਾਨਹੰ ਵਦਾਮਿ ਤ੍ਵਰਯਾ ਪਰਿਸ਼਼੍ਕਰਿਸ਼਼੍ਯਤਿ, ਕਿਨ੍ਤੁ ਯਦਾ ਮਨੁਸ਼਼੍ਯਪੁਤ੍ਰ ਆਗਮਿਸ਼਼੍ਯਤਿ ਤਦਾ ਪ੍ਰੁʼਥਿਵ੍ਯਾਂ ਕਿਮੀਦ੍ਰੁʼਸ਼ੰ ਵਿਸ਼੍ਵਾਸੰ ਪ੍ਰਾਪ੍ਸ੍ਯਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ਯੇ ਸ੍ਵਾਨ੍ ਧਾਰ੍ੰਮਿਕਾਨ੍ ਜ੍ਞਾਤ੍ਵਾ ਪਰਾਨ੍ ਤੁੱਛੀਕੁਰ੍ੱਵਨ੍ਤਿ ਏਤਾਦ੍ਰੁʼਗ੍ਭ੍ਯਃ, ਕਿਯਦ੍ਭ੍ਯ ਇਮੰ ਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤੰ ਕਥਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","ਏਕਃ ਫਿਰੂਸ਼੍ਯਪਰਃ ਕਰਸਞ੍ਚਾਯੀ ਦ੍ਵਾਵਿਮੌ ਪ੍ਰਾਰ੍ਥਯਿਤੁੰ ਮਨ੍ਦਿਰੰ ਗਤੌ| ");
INSERT INTO sanpun_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ਤਤੋ(ਅ)ਸੌ ਫਿਰੂਸ਼੍ਯੇਕਪਾਰ੍ਸ਼੍ਵੇ ਤਿਸ਼਼੍ਠਨ੍ ਹੇ ਈਸ਼੍ਵਰ ਅਹਮਨ੍ਯਲੋਕਵਤ੍ ਲੋਠਯਿਤਾਨ੍ਯਾਯੀ ਪਾਰਦਾਰਿਕਸ਼੍ਚ ਨ ਭਵਾਮਿ ਅਸ੍ਯ ਕਰਸਞ੍ਚਾਯਿਨਸ੍ਤੁਲ੍ਯਸ਼੍ਚ ਨ, ਤਸ੍ਮਾੱਤ੍ਵਾਂ ਧਨ੍ਯੰ ਵਦਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","ਸਪ੍ਤਸੁ ਦਿਨੇਸ਼਼ੁ ਦਿਨਦ੍ਵਯਮੁਪਵਸਾਮਿ ਸਰ੍ੱਵਸਮ੍ਪੱਤੇ ਰ੍ਦਸ਼ਮਾਂਸ਼ੰ ਦਦਾਮਿ ਚ, ਏਤਤ੍ਕਥਾਂ ਕਥਯਨ੍ ਪ੍ਰਾਰ੍ਥਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","ਕਿਨ੍ਤੁ ਸ ਕਰਸਞ੍ਚਾਯਿ ਦੂਰੇ ਤਿਸ਼਼੍ਠਨ੍ ਸ੍ਵਰ੍ਗੰ ਦ੍ਰਸ਼਼੍ਟੁੰ ਨੇੱਛਨ੍ ਵਕ੍ਸ਼਼ਸਿ ਕਰਾਘਾਤੰ ਕੁਰ੍ੱਵਨ੍ ਹੇ ਈਸ਼੍ਵਰ ਪਾਪਿਸ਼਼੍ਠੰ ਮਾਂ ਦਯਸ੍ਵ, ਇੱਥੰ ਪ੍ਰਾਰ੍ਥਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","ਯੁਸ਼਼੍ਮਾਨਹੰ ਵਦਾਮਿ, ਤਯੋਰ੍ਦ੍ਵਯੋ ਰ੍ਮਧ੍ਯੇ ਕੇਵਲਃ ਕਰਸਞ੍ਚਾਯੀ ਪੁਣ੍ਯਵੱਤ੍ਵੇਨ ਗਣਿਤੋ ਨਿਜਗ੍ਰੁʼਹੰ ਜਗਾਮ, ਯਤੋ ਯਃ ਕਸ਼੍ਚਿਤ੍ ਸ੍ਵਮੁੰਨਮਯਤਿ ਸ ਨਾਮਯਿਸ਼਼੍ਯਤੇ ਕਿਨ੍ਤੁ ਯਃ ਕਸ਼੍ਚਿਤ੍ ਸ੍ਵੰ ਨਮਯਤਿ ਸ ਉੰਨਮਯਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","ਅਥ ਸ਼ਿਸ਼ੂਨਾਂ ਗਾਤ੍ਰਸ੍ਪਰ੍ਸ਼ਾਰ੍ਥੰ ਲੋਕਾਸ੍ਤਾਨ੍ ਤਸ੍ਯ ਸਮੀਪਮਾਨਿਨ੍ਯੁਃ ਸ਼ਿਸ਼਼੍ਯਾਸ੍ਤਦ੍ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾਨੇਤ੍ਰੁʼਨ੍ ਤਰ੍ਜਯਾਮਾਸੁਃ, ");
INSERT INTO sanpun_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","ਕਿਨ੍ਤੁ ਯੀਸ਼ੁਸ੍ਤਾਨਾਹੂਯ ਜਗਾਦ, ਮੰਨਿਕਟਮ੍ ਆਗਨ੍ਤੁੰ ਸ਼ਿਸ਼ੂਨ੍ ਅਨੁਜਾਨੀਧ੍ਵੰ ਤਾਂਸ਼੍ਚ ਮਾ ਵਾਰਯਤ; ਯਤ ਈਸ਼੍ਵਰਰਾਜ੍ਯਾਧਿਕਾਰਿਣ ਏਸ਼਼ਾਂ ਸਦ੍ਰੁʼਸ਼ਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ਅਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਯਥਾਰ੍ਥੰ ਵਦਾਮਿ, ਯੋ ਜਨਃ ਸ਼ਿਸ਼ੋਃ ਸਦ੍ਰੁʼਸ਼ੋ ਭੂਤ੍ਵਾ ਈਸ਼੍ਵਰਰਾਜ੍ਯੰ ਨ ਗ੍ਰੁʼਹ੍ਲਾਤਿ ਸ ਕੇਨਾਪਿ ਪ੍ਰਕਾਰੇਣ ਤਤ੍ ਪ੍ਰਵੇਸ਼਼੍ਟੁੰ ਨ ਸ਼ਕ੍ਨੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","ਅਪਰਮ੍ ਏਕੋਧਿਪਤਿਸ੍ਤੰ ਪਪ੍ਰੱਛ, ਹੇ ਪਰਮਗੁਰੋ, ਅਨਨ੍ਤਾਯੁਸ਼਼ਃ ਪ੍ਰਾਪ੍ਤਯੇ ਮਯਾ ਕਿੰ ਕਰ੍ੱਤਵ੍ਯੰ? ");
INSERT INTO sanpun_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ਯੀਸ਼ੁਰੁਵਾਚ, ਮਾਂ ਕੁਤਃ ਪਰਮੰ ਵਦਸਿ? ਈਸ਼੍ਵਰੰ ਵਿਨਾ ਕੋਪਿ ਪਰਮੋ ਨ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","ਪਰਦਾਰਾਨ੍ ਮਾ ਗੱਛ, ਨਰੰ ਮਾ ਜਹਿ, ਮਾ ਚੋਰਯ, ਮਿਥ੍ਯਾਸਾਕ੍ਸ਼਼੍ਯੰ ਮਾ ਦੇਹਿ, ਮਾਤਰੰ ਪਿਤਰਞ੍ਚ ਸੰਮਨ੍ਯਸ੍ਵ, ਏਤਾ ਯਾ ਆਜ੍ਞਾਃ ਸਨ੍ਤਿ ਤਾਸ੍ਤ੍ਵੰ ਜਾਨਾਸਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","ਤਦਾ ਸ ਉਵਾਚ, ਬਾਲ੍ਯਕਾਲਾਤ੍ ਸਰ੍ੱਵਾ ਏਤਾ ਆਚਰਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ਇਤਿ ਕਥਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਯੀਸ਼ੁਸ੍ਤਮਵਦਤ੍, ਤਥਾਪਿ ਤਵੈਕੰ ਕਰ੍ੰਮ ਨ੍ਯੂਨਮਾਸ੍ਤੇ, ਨਿਜੰ ਸਰ੍ੱਵਸ੍ਵੰ ਵਿਕ੍ਰੀਯ ਦਰਿਦ੍ਰੇਭ੍ਯੋ ਵਿਤਰ, ਤਸ੍ਮਾਤ੍ ਸ੍ਵਰ੍ਗੇ ਧਨੰ ਪ੍ਰਾਪ੍ਸ੍ਯਸਿ; ਤਤ ਆਗਤ੍ਯ ਮਮਾਨੁਗਾਮੀ ਭਵ| ");
INSERT INTO sanpun_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","ਕਿਨ੍ਤ੍ਵੇਤਾਂ ਕਥਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਸੋਧਿਪਤਿਃ ਸ਼ੁਸ਼ੋਚ, ਯਤਸ੍ਤਸ੍ਯ ਬਹੁਧਨਮਾਸੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ਤਦਾ ਯੀਸ਼ੁਸ੍ਤਮਤਿਸ਼ੋਕਾਨ੍ਵਿਤੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਜਗਾਦ, ਧਨਵਤਾਮ੍ ਈਸ਼੍ਵਰਰਾਜ੍ਯਪ੍ਰਵੇਸ਼ਃ ਕੀਦ੍ਰੁʼਗ੍ ਦੁਸ਼਼੍ਕਰਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ਈਸ਼੍ਵਰਰਾਜ੍ਯੇ ਧਨਿਨਃ ਪ੍ਰਵੇਸ਼ਾਤ੍ ਸੂਚੇਸ਼੍ਛਿਦ੍ਰੇਣ ਮਹਾਙ੍ਗਸ੍ਯ ਗਮਨਾਗਮਨੇ ਸੁਕਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ਸ਼੍ਰੋਤਾਰਃ ਪਪ੍ਰੱਛੁਸ੍ਤਰ੍ਹਿ ਕੇਨ ਪਰਿਤ੍ਰਾਣੰ ਪ੍ਰਾਪ੍ਸ੍ਯਤੇ? ");
INSERT INTO sanpun_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ਸ ਉਕ੍ਤਵਾਨ੍, ਯਨ੍ ਮਾਨੁਸ਼਼ੇਣਾਸ਼ਕ੍ਯੰ ਤਦ੍ ਈਸ਼੍ਵਰੇਣ ਸ਼ਕ੍ਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ਤਦਾ ਪਿਤਰ ਉਵਾਚ, ਪਸ਼੍ਯ ਵਯੰ ਸਰ੍ੱਵਸ੍ਵੰ ਪਰਿਤ੍ਯਜ੍ਯ ਤਵ ਪਸ਼੍ਚਾਦ੍ਗਾਮਿਨੋ(ਅ)ਭਵਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ਤਤਃ ਸ ਉਵਾਚ, ਯੁਸ਼਼੍ਮਾਨਹੰ ਯਥਾਰ੍ਥੰ ਵਦਾਮਿ, ਈਸ਼੍ਵਰਰਾਜ੍ਯਾਰ੍ਥੰ ਗ੍ਰੁʼਹੰ ਪਿਤਰੌ ਭ੍ਰਾਤ੍ਰੁʼਗਣੰ ਜਾਯਾਂ ਸਨ੍ਤਾਨਾਂਸ਼੍ਚ ਤ੍ਯਕ੍ਤਵਾ ");
INSERT INTO sanpun_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ਇਹ ਕਾਲੇ ਤਤੋ(ਅ)ਧਿਕੰ ਪਰਕਾਲੇ (ਅ)ਨਨ੍ਤਾਯੁਸ਼੍ਚ ਨ ਪ੍ਰਾਪ੍ਸ੍ਯਤਿ ਲੋਕ ਈਦ੍ਰੁʼਸ਼ਃ ਕੋਪਿ ਨਾਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","ਅਨਨ੍ਤਰੰ ਸ ਦ੍ਵਾਦਸ਼ਸ਼ਿਸ਼਼੍ਯਾਨਾਹੂਯ ਬਭਾਸ਼਼ੇ, ਪਸ਼੍ਯਤ ਵਯੰ ਯਿਰੂਸ਼ਾਲਮ੍ਨਗਰੰ ਯਾਮਃ, ਤਸ੍ਮਾਤ੍ ਮਨੁਸ਼਼੍ਯਪੁਤ੍ਰੇ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਭਿਰੁਕ੍ਤੰ ਯਦਸ੍ਤਿ ਤਦਨੁਰੂਪੰ ਤੰ ਪ੍ਰਤਿ ਘਟਿਸ਼਼੍ਯਤੇ; ");
INSERT INTO sanpun_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","ਵਸ੍ਤੁਤਸ੍ਤੁ ਸੋ(ਅ)ਨ੍ਯਦੇਸ਼ੀਯਾਨਾਂ ਹਸ੍ਤੇਸ਼਼ੁ ਸਮਰ੍ਪਯਿਸ਼਼੍ਯਤੇ, ਤੇ ਤਮੁਪਹਸਿਸ਼਼੍ਯਨ੍ਤਿ, ਅਨ੍ਯਾਯਮਾਚਰਿਸ਼਼੍ਯਨ੍ਤਿ ਤਦ੍ਵਪੁਸ਼਼ਿ ਨਿਸ਼਼੍ਠੀਵੰ ਨਿਕ੍ਸ਼਼ੇਪ੍ਸ੍ਯਨ੍ਤਿ, ਕਸ਼ਾਭਿਃ ਪ੍ਰਹ੍ਰੁʼਤ੍ਯ ਤੰ ਹਨਿਸ਼਼੍ਯਨ੍ਤਿ ਚ, ");
INSERT INTO sanpun_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ਕਿਨ੍ਤੁ ਤ੍ਰੁʼਤੀਯਦਿਨੇ ਸ ਸ਼੍ਮਸ਼ਾਨਾਦ੍ ਉੱਥਾਸ੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ਏਤਸ੍ਯਾਃ ਕਥਾਯਾ ਅਭਿਪ੍ਰਾਯੰ ਕਿਞ੍ਚਿਦਪਿ ਤੇ ਬੋੱਧੁੰ ਨ ਸ਼ੇਕੁਃ ਤੇਸ਼਼ਾਂ ਨਿਕਟੇ(ਅ)ਸ੍ਪਸ਼਼੍ਟਤਵਾਤ੍ ਤਸ੍ਯੈਤਾਸਾਂ ਕਥਾਨਾਮ੍ ਆਸ਼ਯੰ ਤੇ ਜ੍ਞਾਤੁੰ ਨ ਸ਼ੇਕੁਸ਼੍ਚ| ");
INSERT INTO sanpun_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","ਅਥ ਤਸ੍ਮਿਨ੍ ਯਿਰੀਹੋਃ ਪੁਰਸ੍ਯਾਨ੍ਤਿਕੰ ਪ੍ਰਾਪ੍ਤੇ ਕਸ਼੍ਚਿਦਨ੍ਧਃ ਪਥਃ ਪਾਰ੍ਸ਼੍ਵ ਉਪਵਿਸ਼੍ਯ ਭਿਕ੍ਸ਼਼ਾਮ੍ ਅਕਰੋਤ੍ ");
INSERT INTO sanpun_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ਸ ਲੋਕਸਮੂਹਸ੍ਯ ਗਮਨਸ਼ਬ੍ਦੰ ਸ਼੍ਰੁਤ੍ਵਾ ਤਤ੍ਕਾਰਣੰ ਪ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","ਨਾਸਰਤੀਯਯੀਸ਼ੁਰ੍ਯਾਤੀਤਿ ਲੋਕੈਰੁਕ੍ਤੇ ਸ ਉੱਚੈਰ੍ਵਕ੍ਤੁਮਾਰੇਭੇ, ");
INSERT INTO sanpun_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ਹੇ ਦਾਯੂਦਃ ਸਨ੍ਤਾਨ ਯੀਸ਼ੋ ਮਾਂ ਦਯਸ੍ਵ| ");
INSERT INTO sanpun_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ਤਤੋਗ੍ਰਗਾਮਿਨਸ੍ਤੰ ਮੌਨੀ ਤਿਸ਼਼੍ਠੇਤਿ ਤਰ੍ਜਯਾਮਾਸੁਃ ਕਿਨ੍ਤੁ ਸ ਪੁਨਾਰੁਵਨ੍ ਉਵਾਚ, ਹੇ ਦਾਯੂਦਃ ਸਨ੍ਤਾਨ ਮਾਂ ਦਯਸ੍ਵ| ");
INSERT INTO sanpun_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","ਤਦਾ ਯੀਸ਼ੁਃ ਸ੍ਥਗਿਤੋ ਭੂਤ੍ਵਾ ਸ੍ਵਾਨ੍ਤਿਕੇ ਤਮਾਨੇਤੁਮ੍ ਆਦਿਦੇਸ਼| ");
INSERT INTO sanpun_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","ਤਤਃ ਸ ਤਸ੍ਯਾਨ੍ਤਿਕਮ੍ ਆਗਮਤ੍, ਤਦਾ ਸ ਤੰ ਪਪ੍ਰੱਛ, ਤ੍ਵੰ ਕਿਮਿੱਛਸਿ? ਤ੍ਵਦਰ੍ਥਮਹੰ ਕਿੰ ਕਰਿਸ਼਼੍ਯਾਮਿ? ਸ ਉਕ੍ਤਵਾਨ੍, ਹੇ ਪ੍ਰਭੋ(ਅ)ਹੰ ਦ੍ਰਸ਼਼੍ਟੁੰ ਲਭੈ| ");
INSERT INTO sanpun_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","ਤਦਾ ਯੀਸ਼ੁਰੁਵਾਚ, ਦ੍ਰੁʼਸ਼਼੍ਟਿਸ਼ਕ੍ਤਿੰ ਗ੍ਰੁʼਹਾਣ ਤਵ ਪ੍ਰਤ੍ਯਯਸ੍ਤ੍ਵਾਂ ਸ੍ਵਸ੍ਥੰ ਕ੍ਰੁʼਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ਤਤਸ੍ਤਤ੍ਕ੍ਸ਼਼ਣਾਤ੍ ਤਸ੍ਯ ਚਕ੍ਸ਼਼ੁਸ਼਼ੀ ਪ੍ਰਸੰਨੇ; ਤਸ੍ਮਾਤ੍ ਸ ਈਸ਼੍ਵਰੰ ਧਨ੍ਯੰ ਵਦਨ੍ ਤਤ੍ਪਸ਼੍ਚਾਦ੍ ਯਯੌ, ਤਦਾਲੋਕ੍ਯ ਸਰ੍ੱਵੇ ਲੋਕਾ ਈਸ਼੍ਵਰੰ ਪ੍ਰਸ਼ੰਸਿਤੁਮ੍ ਆਰੇਭਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","ਯਦਾ ਯੀਸ਼ੁ ਰ੍ਯਿਰੀਹੋਪੁਰੰ ਪ੍ਰਵਿਸ਼੍ਯ ਤਨ੍ਮਧ੍ਯੇਨ ਗੱਛੰਸ੍ਤਦਾ ");
INSERT INTO sanpun_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ਸੱਕੇਯਨਾਮਾ ਕਰਸਞ੍ਚਾਯਿਨਾਂ ਪ੍ਰਧਾਨੋ ਧਨਵਾਨੇਕੋ ");
INSERT INTO sanpun_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ਯੀਸ਼ੁਃ ਕੀਦ੍ਰੁʼਗਿਤਿ ਦ੍ਰਸ਼਼੍ਟੁੰ ਚੇਸ਼਼੍ਟਿਤਵਾਨ੍ ਕਿਨ੍ਤੁ ਖਰ੍ੱਵਤ੍ਵਾੱਲੋਕਸੰਘਮਧ੍ਯੇ ਤੱਦਰ੍ਸ਼ਨਮਪ੍ਰਾਪ੍ਯ ");
INSERT INTO sanpun_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","ਯੇਨ ਪਥਾ ਸ ਯਾਸ੍ਯਤਿ ਤਤ੍ਪਥੇ(ਅ)ਗ੍ਰੇ ਧਾਵਿਤ੍ਵਾ ਤੰ ਦ੍ਰਸ਼਼੍ਟੁਮ੍ ਉਡੁਮ੍ਬਰਤਰੁਮਾਰੁਰੋਹ| ");
INSERT INTO sanpun_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","ਪਸ਼੍ਚਾਦ੍ ਯੀਸ਼ੁਸ੍ਤਤ੍ਸ੍ਥਾਨਮ੍ ਇਤ੍ਵਾ ਊਰ੍ੱਧ੍ਵੰ ਵਿਲੋਕ੍ਯ ਤੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾਵਾਦੀਤ੍, ਹੇ ਸੱਕੇਯ ਤ੍ਵੰ ਸ਼ੀਘ੍ਰਮਵਰੋਹ ਮਯਾਦ੍ਯ ਤ੍ਵਦ੍ਗੇਹੇ ਵਸ੍ਤਵ੍ਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ਤਤਃ ਸ ਸ਼ੀਘ੍ਰਮਵਰੁਹ੍ਯ ਸਾਹ੍ਲਾਦੰ ਤੰ ਜਗ੍ਰਾਹ| ");
INSERT INTO sanpun_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ਤਦ੍ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਸਰ੍ੱਵੇ ਵਿਵਦਮਾਨਾ ਵਕ੍ਤੁਮਾਰੇਭਿਰੇ, ਸੋਤਿਥਿਤ੍ਵੇਨ ਦੁਸ਼਼੍ਟਲੋਕਗ੍ਰੁʼਹੰ ਗੱਛਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ਕਿਨ੍ਤੁ ਸੱਕੇਯੋ ਦਣ੍ਡਾਯਮਾਨੋ ਵਕ੍ਤੁਮਾਰੇਭੇ, ਹੇ ਪ੍ਰਭੋ ਪਸ਼੍ਯ ਮਮ ਯਾ ਸਮ੍ਪੱਤਿਰਸ੍ਤਿ ਤਦਰ੍ੱਧੰ ਦਰਿਦ੍ਰੇਭ੍ਯੋ ਦਦੇ, ਅਪਰਮ੍ ਅਨ੍ਯਾਯੰ ਕ੍ਰੁʼਤ੍ਵਾ ਕਸ੍ਮਾਦਪਿ ਯਦਿ ਕਦਾਪਿ ਕਿਞ੍ਚਿਤ੍ ਮਯਾ ਗ੍ਰੁʼਹੀਤੰ ਤਰ੍ਹਿ ਤੱਚਤੁਰ੍ਗੁਣੰ ਦਦਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ਤਦਾ ਯੀਸ਼ੁਸ੍ਤਮੁਕ੍ਤਵਾਨ੍ ਅਯਮਪਿ ਇਬ੍ਰਾਹੀਮਃ ਸਨ੍ਤਾਨੋ(ਅ)ਤਃ ਕਾਰਣਾਦ੍ ਅਦ੍ਯਾਸ੍ਯ ਗ੍ਰੁʼਹੇ ਤ੍ਰਾਣਮੁਪਸ੍ਥਿਤੰ| ");
INSERT INTO sanpun_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","ਯਦ੍ ਹਾਰਿਤੰ ਤਤ੍ ਮ੍ਰੁʼਗਯਿਤੁੰ ਰਕ੍ਸ਼਼ਿਤੁਞ੍ਚ ਮਨੁਸ਼਼੍ਯਪੁਤ੍ਰ ਆਗਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","ਅਥ ਸ ਯਿਰੂਸ਼ਾਲਮਃ ਸਮੀਪ ਉਪਾਤਿਸ਼਼੍ਠਦ੍ ਈਸ਼੍ਵਰਰਾਜਤ੍ਵਸ੍ਯਾਨੁਸ਼਼੍ਠਾਨੰ ਤਦੈਵ ਭਵਿਸ਼਼੍ਯਤੀਤਿ ਲੋਕੈਰਨ੍ਵਭੂਯਤ, ਤਸ੍ਮਾਤ੍ ਸ ਸ਼੍ਰੋਤ੍ਰੁʼਭ੍ਯਃ ਪੁਨਰ੍ਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤਕਥਾਮ੍ ਉੱਥਾਪ੍ਯ ਕਥਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ਕੋਪਿ ਮਹਾੱਲੋਕੋ ਨਿਜਾਰ੍ਥੰ ਰਾਜਤ੍ਵਪਦੰ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਪੁਨਰਾਗਨ੍ਤੁੰ ਦੂਰਦੇਸ਼ੰ ਜਗਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ਯਾਤ੍ਰਾਕਾਲੇ ਨਿਜਾਨ੍ ਦਸ਼ਦਾਸਾਨ੍ ਆਹੂਯ ਦਸ਼ਸ੍ਵਰ੍ਣਮੁਦ੍ਰਾ ਦੱਤ੍ਵਾ ਮਮਾਗਮਨਪਰ੍ੱਯਨ੍ਤੰ ਵਾਣਿਜ੍ਯੰ ਕੁਰੁਤੇਤ੍ਯਾਦਿਦੇਸ਼| ");
INSERT INTO sanpun_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","ਕਿਨ੍ਤੁ ਤਸ੍ਯ ਪ੍ਰਜਾਸ੍ਤਮਵਜ੍ਞਾਯ ਮਨੁਸ਼਼੍ਯਮੇਨਮ੍ ਅਸ੍ਮਾਕਮੁਪਰਿ ਰਾਜਤ੍ਵੰ ਨ ਕਾਰਯਿਵ੍ਯਾਮ ਇਮਾਂ ਵਾਰ੍ੱਤਾਂ ਤੰਨਿਕਟੇ ਪ੍ਰੇਰਯਾਮਾਸੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","ਅਥ ਸ ਰਾਜਤ੍ਵਪਦੰ ਪ੍ਰਾਪ੍ਯਾਗਤਵਾਨ੍ ਏਕੈਕੋ ਜਨੋ ਬਾਣਿਜ੍ਯੇਨ ਕਿੰ ਲਬ੍ਧਵਾਨ੍ ਇਤਿ ਜ੍ਞਾਤੁੰ ਯੇਸ਼਼ੁ ਦਾਸੇਸ਼਼ੁ ਮੁਦ੍ਰਾ ਅਰ੍ਪਯਤ੍ ਤਾਨ੍ ਆਹੂਯਾਨੇਤੁਮ੍ ਆਦਿਦੇਸ਼| ");
INSERT INTO sanpun_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","ਤਦਾ ਪ੍ਰਥਮ ਆਗਤ੍ਯ ਕਥਿਤਵਾਨ੍, ਹੇ ਪ੍ਰਭੋ ਤਵ ਤਯੈਕਯਾ ਮੁਦ੍ਰਯਾ ਦਸ਼ਮੁਦ੍ਰਾ ਲਬ੍ਧਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","ਤਤਃ ਸ ਉਵਾਚ ਤ੍ਵਮੁੱਤਮੋ ਦਾਸਃ ਸ੍ਵਲ੍ਪੇਨ ਵਿਸ਼੍ਵਾਸ੍ਯੋ ਜਾਤ ਇਤਃ ਕਾਰਣਾਤ੍ ਤ੍ਵੰ ਦਸ਼ਨਗਰਾਣਾਮ੍ ਅਧਿਪੋ ਭਵ| ");
INSERT INTO sanpun_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","ਦ੍ਵਿਤੀਯ ਆਗਤ੍ਯ ਕਥਿਤਵਾਨ੍, ਹੇ ਪ੍ਰਭੋ ਤਵੈਕਯਾ ਮੁਦ੍ਰਯਾ ਪਞ੍ਚਮੁਦ੍ਰਾ ਲਬ੍ਧਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ਤਤਃ ਸ ਉਵਾਚ, ਤ੍ਵੰ ਪਞ੍ਚਾਨਾਂ ਨਗਰਾਣਾਮਧਿਪਤਿ ਰ੍ਭਵ| ");
INSERT INTO sanpun_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","ਤਤੋਨ੍ਯ ਆਗਤ੍ਯ ਕਥਯਾਮਾਸ, ਹੇ ਪ੍ਰਭੋ ਪਸ਼੍ਯ ਤਵ ਯਾ ਮੁਦ੍ਰਾ ਅਹੰ ਵਸ੍ਤ੍ਰੇ ਬੱਧ੍ਵਾਸ੍ਥਾਪਯੰ ਸੇਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ਤ੍ਵੰ ਕ੍ਰੁʼਪਣੋ ਯੰਨਾਸ੍ਥਾਪਯਸ੍ਤਦਪਿ ਗ੍ਰੁʼਹ੍ਲਾਸਿ, ਯੰਨਾਵਪਸ੍ਤਦੇਵ ਚ ਛਿਨਤ੍ਸਿ ਤਤੋਹੰ ਤ੍ਵੱਤੋ ਭੀਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","ਤਦਾ ਸ ਜਗਾਦ, ਰੇ ਦੁਸ਼਼੍ਟਦਾਸ ਤਵ ਵਾਕ੍ਯੇਨ ਤ੍ਵਾਂ ਦੋਸ਼਼ਿਣੰ ਕਰਿਸ਼਼੍ਯਾਮਿ, ਯਦਹੰ ਨਾਸ੍ਥਾਪਯੰ ਤਦੇਵ ਗ੍ਰੁʼਹ੍ਲਾਮਿ, ਯਦਹੰ ਨਾਵਪਞ੍ਚ ਤਦੇਵ ਛਿਨਦ੍ਮਿ, ਏਤਾਦ੍ਰੁʼਸ਼ਃ ਕ੍ਰੁʼਪਣੋਹਮਿਤਿ ਯਦਿ ਤ੍ਵੰ ਜਾਨਾਸਿ, ");
INSERT INTO sanpun_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ਤਰ੍ਹਿ ਮਮ ਮੁਦ੍ਰਾ ਬਣਿਜਾਂ ਨਿਕਟੇ ਕੁਤੋ ਨਾਸ੍ਥਾਪਯਃ? ਤਯਾ ਕ੍ਰੁʼਤੇ(ਅ)ਹਮ੍ ਆਗਤ੍ਯ ਕੁਸੀਦੇਨ ਸਾਰ੍ੱਧੰ ਨਿਜਮੁਦ੍ਰਾ ਅਪ੍ਰਾਪ੍ਸ੍ਯਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","ਪਸ਼੍ਚਾਤ੍ ਸ ਸਮੀਪਸ੍ਥਾਨ੍ ਜਨਾਨ੍ ਆਜ੍ਞਾਪਯਤ੍ ਅਸ੍ਮਾਤ੍ ਮੁਦ੍ਰਾ ਆਨੀਯ ਯਸ੍ਯ ਦਸ਼ਮੁਦ੍ਰਾਃ ਸਨ੍ਤਿ ਤਸ੍ਮੈ ਦੱਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","ਤੇ ਪ੍ਰੋਚੁਃ ਪ੍ਰਭੋ(ਅ)ਸ੍ਯ ਦਸ਼ਮੁਦ੍ਰਾਃ ਸਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","ਯੁਸ਼਼੍ਮਾਨਹੰ ਵਦਾਮਿ ਯਸ੍ਯਾਸ਼੍ਰਯੇ ਵੱਧਤੇ (ਅ)ਧਿਕੰ ਤਸ੍ਮੈ ਦਾਯਿਸ਼਼੍ਯਤੇ, ਕਿਨ੍ਤੁ ਯਸ੍ਯਾਸ਼੍ਰਯੇ ਨ ਵਰ੍ੱਧਤੇ ਤਸ੍ਯ ਯਦ੍ਯਦਸ੍ਤਿ ਤਦਪਿ ਤਸ੍ਮਾਨ੍ ਨਾਯਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ਕਿਨ੍ਤੁ ਮਮਾਧਿਪਤਿਤ੍ਵਸ੍ਯ ਵਸ਼ਤ੍ਵੇ ਸ੍ਥਾਤੁਮ੍ ਅਸੰਮਨ੍ਯਮਾਨਾ ਯੇ ਮਮ ਰਿਪਵਸ੍ਤਾਨਾਨੀਯ ਮਮ ਸਮਕ੍ਸ਼਼ੰ ਸੰਹਰਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ਇਤ੍ਯੁਪਦੇਸ਼ਕਥਾਂ ਕਥਯਿਤ੍ਵਾ ਸੋਗ੍ਰਗਃ ਸਨ੍ ਯਿਰੂਸ਼ਾਲਮਪੁਰੰ ਯਯੌ| ");
INSERT INTO sanpun_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ਤਤੋ ਬੈਤ੍ਫਗੀਬੈਥਨੀਯਾਗ੍ਰਾਮਯੋਃ ਸਮੀਪੇ ਜੈਤੁਨਾਦ੍ਰੇਰਨ੍ਤਿਕਮ੍ ਇਤ੍ਵਾ ਸ਼ਿਸ਼਼੍ਯਦ੍ਵਯਮ੍ ਇਤ੍ਯੁਕ੍ਤ੍ਵਾ ਪ੍ਰੇਸ਼਼ਯਾਮਾਸ, ");
INSERT INTO sanpun_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ਯੁਵਾਮਮੁੰ ਸੰਮੁਖਸ੍ਥਗ੍ਰਾਮੰ ਪ੍ਰਵਿਸ਼੍ਯੈਵ ਯੰ ਕੋਪਿ ਮਾਨੁਸ਼਼ਃ ਕਦਾਪਿ ਨਾਰੋਹਤ੍ ਤੰ ਗਰ੍ੱਦਭਸ਼ਾਵਕੰ ਬੱਧੰ ਦ੍ਰਕ੍ਸ਼਼੍ਯਥਸ੍ਤੰ ਮੋਚਯਿਤ੍ਵਾਨਯਤੰ| ");
INSERT INTO sanpun_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","ਤਤ੍ਰ ਕੁਤੋ ਮੋਚਯਥਃ? ਇਤਿ ਚੇਤ੍ ਕੋਪਿ ਵਕ੍ਸ਼਼੍ਯਤਿ ਤਰ੍ਹਿ ਵਕ੍ਸ਼਼੍ਯਥਃ ਪ੍ਰਭੇाਰਤ੍ਰ ਪ੍ਰਯੋਜਨਮ੍ ਆਸ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ਤਦਾ ਤੌ ਪ੍ਰਰਿਤੌ ਗਤ੍ਵਾ ਤਤ੍ਕਥਾाਨੁਸਾਰੇਣ ਸਰ੍ੱਵੰ ਪ੍ਰਾਪ੍ਤੌ| ");
INSERT INTO sanpun_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ਗਰ੍ਦਭਸ਼ਾਵਕਮੋਚਨਕਾਲੇ ਤਤ੍ਵਾਮਿਨ ਊਚੁਃ, ਗਰ੍ਦਭਸ਼ਾਵਕੰ ਕੁਤੋ ਮੋਚਯਥਃ? ");
INSERT INTO sanpun_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","ਤਾਵੂਚਤੁਃ ਪ੍ਰਭੋਰਤ੍ਰ ਪ੍ਰਯੋਜਨਮ੍ ਆਸ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ਪਸ਼੍ਚਾਤ੍ ਤੌ ਤੰ ਗਰ੍ਦਭਸ਼ਾਵਕੰ ਯੀਸ਼ੋਰਨ੍ਤਿਕਮਾਨੀਯ ਤਤ੍ਪ੍ਰੁʼਸ਼਼੍ਠੇ ਨਿਜਵਸਨਾਨਿ ਪਾਤਯਿਤ੍ਵਾ ਤਦੁਪਰਿ ਯੀਸ਼ੁਮਾਰੋਹਯਾਮਾਸਤੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ਅਥ ਯਾਤ੍ਰਾਕਾਲੇ ਲੋਕਾਃ ਪਥਿ ਸ੍ਵਵਸ੍ਤ੍ਰਾਣਿ ਪਾਤਯਿਤੁਮ੍ ਆਰੇਭਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ਅਪਰੰ ਜੈਤੁਨਾਦ੍ਰੇਰੁਪਤ੍ਯਕਾਮ੍ ਇਤ੍ਵਾ ਸ਼ਿਸ਼਼੍ਯਸੰਘਃ ਪੂਰ੍ੱਵਦ੍ਰੁʼਸ਼਼੍ਟਾਨਿ ਮਹਾਕਰ੍ੰਮਾਣਿ ਸ੍ਮ੍ਰੁʼਤ੍ਵਾ, ");
INSERT INTO sanpun_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ਯੋ ਰਾਜਾ ਪ੍ਰਭੋ ਰ੍ਨਾਮ੍ਨਾਯਾਤਿ ਸ ਧਨ੍ਯਃ ਸ੍ਵਰ੍ਗੇ ਕੁਸ਼ਲੰ ਸਰ੍ੱਵੋੱਚੇ ਜਯਧ੍ਵਨਿ ਰ੍ਭਵਤੁ, ਕਥਾਮੇਤਾਂ ਕਥਯਿਤ੍ਵਾ ਸਾਨਨ੍ਦਮ੍ ਉਚੈਰੀਸ਼੍ਵਰੰ ਧਨ੍ਯੰ ਵਕ੍ਤੁਮਾਰੇਭੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","ਤਦਾ ਲੋਕਾਰਣ੍ਯਮਧ੍ਯਸ੍ਥਾਃ ਕਿਯਨ੍ਤਃ ਫਿਰੂਸ਼ਿਨਸ੍ਤਤ੍ ਸ਼੍ਰੁਤ੍ਵਾ ਯੀਸ਼ੁੰ ਪ੍ਰੋਚੁਃ, ਹੇ ਉਪਦੇਸ਼ਕ ਸ੍ਵਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਤਰ੍ਜਯ| ");
INSERT INTO sanpun_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ਸ ਉਵਾਚ, ਯੁਸ਼਼੍ਮਾਨਹੰ ਵਦਾਮਿ ਯਦ੍ਯਮੀ ਨੀਰਵਾਸ੍ਤਿਸ਼਼੍ਠਨ੍ਤਿ ਤਰ੍ਹਿ ਪਾਸ਼਼ਾਣਾ ਉਚੈਃ ਕਥਾਃ ਕਥਯਿਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","ਪਸ਼੍ਚਾਤ੍ ਤਤ੍ਪੁਰਾਨ੍ਤਿਕਮੇਤ੍ਯ ਤਦਵਲੋਕ੍ਯ ਸਾਸ਼੍ਰੁਪਾਤੰ ਜਗਾਦ, ");
INSERT INTO sanpun_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ਹਾ ਹਾ ਚੇਤ੍ ਤ੍ਵਮਗ੍ਰੇ(ਅ)ਜ੍ਞਾਸ੍ਯਥਾਃ, ਤਵਾਸ੍ਮਿੰਨੇਵ ਦਿਨੇ ਵਾ ਯਦਿ ਸ੍ਵਮਙ੍ਗਲਮ੍ ਉਪਾਲਪ੍ਸ੍ਯਥਾਃ, ਤਰ੍ਹ੍ਯੁੱਤਮਮ੍ ਅਭਵਿਸ਼਼੍ਯਤ੍, ਕਿਨ੍ਤੁ ਕ੍ਸ਼਼ਣੇਸ੍ਮਿਨ੍ ਤੱਤਵ ਦ੍ਰੁʼਸ਼਼੍ਟੇਰਗੋਚਰਮ੍ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ਤ੍ਵੰ ਸ੍ਵਤ੍ਰਾਣਕਾਲੇ ਨ ਮਨੋ ਨ੍ਯਧੱਥਾ ਇਤਿ ਹੇਤੋ ਰ੍ਯਤ੍ਕਾਲੇ ਤਵ ਰਿਪਵਸ੍ਤ੍ਵਾਂ ਚਤੁਰ੍ਦਿਕ੍ਸ਼਼ੁ ਪ੍ਰਾਚੀਰੇਣ ਵੇਸ਼਼੍ਟਯਿਤ੍ਵਾ ਰੋਤ੍ਸ੍ਯਨ੍ਤਿ ");
INSERT INTO sanpun_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ਬਾਲਕੈਃ ਸਾਰ੍ੱਧੰ ਭੂਮਿਸਾਤ੍ ਕਰਿਸ਼਼੍ਯਨ੍ਤਿ ਚ ਤ੍ਵਨ੍ਮਧ੍ਯੇ ਪਾਸ਼਼ਾਣੈਕੋਪਿ ਪਾਸ਼਼ਾਣੋਪਰਿ ਨ ਸ੍ਥਾਸ੍ਯਤਿ ਚ, ਕਾਲ ਈਦ੍ਰੁʼਸ਼ ਉਪਸ੍ਥਾਸ੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","ਅਥ ਮਧ੍ਯੇਮਨ੍ਦਿਰੰ ਪ੍ਰਵਿਸ਼੍ਯ ਤਤ੍ਰਤ੍ਯਾਨ੍ ਕ੍ਰਯਿਵਿਕ੍ਰਯਿਣੋ ਬਹਿਸ਼਼੍ਕੁਰ੍ੱਵਨ੍ ");
INSERT INTO sanpun_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ਅਵਦਤ੍ ਮਦ੍ਗ੍ਰੁʼਹੰ ਪ੍ਰਾਰ੍ਥਨਾਗ੍ਰੁʼਹਮਿਤਿ ਲਿਪਿਰਾਸ੍ਤੇ ਕਿਨ੍ਤੁ ਯੂਯੰ ਤਦੇਵ ਚੈਰਾਣਾਂ ਗਹ੍ਵਰੰ ਕੁਰੁਥ| ");
INSERT INTO sanpun_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","ਪਸ਼੍ਚਾਤ੍ ਸ ਪ੍ਰਤ੍ਯਹੰ ਮਧ੍ਯੇਮਨ੍ਦਿਰਮ੍ ਉਪਦਿਦੇਸ਼; ਤਤਃ ਪ੍ਰਧਾਨਯਾਜਕਾ ਅਧ੍ਯਾਪਕਾਃ ਪ੍ਰਾਚੀਨਾਸ਼੍ਚ ਤੰ ਨਾਸ਼ਯਿਤੁੰ ਚਿਚੇਸ਼਼੍ਟਿਰੇ; ");
INSERT INTO sanpun_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ਕਿਨ੍ਤੁ ਤਦੁਪਦੇਸ਼ੇ ਸਰ੍ੱਵੇ ਲੋਕਾ ਨਿਵਿਸ਼਼੍ਟਚਿੱਤਾਃ ਸ੍ਥਿਤਾਸ੍ਤਸ੍ਮਾਤ੍ ਤੇ ਤਤ੍ਕਰ੍ੱਤੁੰ ਨਾਵਕਾਸ਼ੰ ਪ੍ਰਾਪੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","ਅਥੈਕਦਾ ਯੀਸ਼ੁ ਰ੍ਮਨਿਦਰੇ ਸੁਸੰਵਾਦੰ ਪ੍ਰਚਾਰਯਨ੍ ਲੋਕਾਨੁਪਦਿਸ਼ਤਿ, ਏਤਰ੍ਹਿ ਪ੍ਰਧਾਨਯਾਜਕਾ ਅਧ੍ਯਾਪਕਾਃ ਪ੍ਰਾਞ੍ਚਸ਼੍ਚ ਤੰਨਿਕਟਮਾਗਤ੍ਯ ਪਪ੍ਰੱਛੁਃ ");
INSERT INTO sanpun_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ਕਯਾਜ੍ਞਯਾ ਤ੍ਵੰ ਕਰ੍ੰਮਾਣ੍ਯੇਤਾਨਿ ਕਰੋਸ਼਼ਿ? ਕੋ ਵਾ ਤ੍ਵਾਮਾਜ੍ਞਾਪਯਤ੍? ਤਦਸ੍ਮਾਨ੍ ਵਦ| ");
INSERT INTO sanpun_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ਸ ਪ੍ਰਤ੍ਯੁਵਾਚ, ਤਰ੍ਹਿ ਯੁਸ਼਼੍ਮਾਨਪਿ ਕਥਾਮੇਕਾਂ ਪ੍ਰੁʼੱਛਾਮਿ ਤਸ੍ਯੋੱਤਰੰ ਵਦਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ਯੋਹਨੋ ਮੱਜਨਮ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਮਾਨੁਸ਼਼ਾਣਾਂ ਵਾਜ੍ਞਾਤੋ ਜਾਤੰ? ");
INSERT INTO sanpun_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ਤਤਸ੍ਤੇ ਮਿਥੋ ਵਿਵਿਚ੍ਯ ਜਗਦੁਃ, ਯਦੀਸ਼੍ਵਰਸ੍ਯ ਵਦਾਮਸ੍ਤਰ੍ਹਿ ਤੰ ਕੁਤੋ ਨ ਪ੍ਰਤ੍ਯੈਤ ਸ ਇਤਿ ਵਕ੍ਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","ਯਦਿ ਮਨੁਸ਼਼੍ਯਸ੍ਯੇਤਿ ਵਦਾਮਸ੍ਤਰ੍ਹਿ ਸਰ੍ੱਵੇ ਲੋਕਾ ਅਸ੍ਮਾਨ੍ ਪਾਸ਼਼ਾਣੈ ਰ੍ਹਨਿਸ਼਼੍ਯਨ੍ਤਿ ਯਤੋ ਯੋਹਨ੍ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦੀਤਿ ਸਰ੍ੱਵੇ ਦ੍ਰੁʼਢੰ ਜਾਨਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ਅਤਏਵ ਤੇ ਪ੍ਰਤ੍ਯੂਚੁਃ ਕਸ੍ਯਾਜ੍ਞਯਾ ਜਾਤਮ੍ ਇਤਿ ਵਕ੍ਤੁੰ ਨ ਸ਼ਕ੍ਨੁਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","ਤਦਾ ਯੀਸ਼ੁਰਵਦਤ੍ ਤਰ੍ਹਿ ਕਯਾਜ੍ਞਯਾ ਕਰ੍ੰਮਾਣ੍ਯੇਤਾਤਿ ਕਰੋਮੀਤਿ ਚ ਯੁਸ਼਼੍ਮਾਨ੍ ਨ ਵਕ੍ਸ਼਼੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","ਅਥ ਲੋਕਾਨਾਂ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਸ ਇਮਾਂ ਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤਕਥਾਂ ਵਕ੍ਤੁਮਾਰੇਭੇ, ਕਸ਼੍ਚਿਦ੍ ਦ੍ਰਾਕ੍ਸ਼਼ਾਕ੍ਸ਼਼ੇਤ੍ਰੰ ਕ੍ਰੁʼਤ੍ਵਾ ਤਤ੍ ਕ੍ਸ਼਼ੇਤ੍ਰੰ ਕ੍ਰੁʼਸ਼਼ੀਵਲਾਨਾਂ ਹਸ੍ਤੇਸ਼਼ੁ ਸਮਰ੍ਪ੍ਯ ਬਹੁਕਾਲਾਰ੍ਥੰ ਦੂਰਦੇਸ਼ੰ ਜਗਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","ਅਥ ਫਲਕਾਲੇ ਫਲਾਨਿ ਗ੍ਰਹੀਤੁ ਕ੍ਰੁʼਸ਼਼ੀਵਲਾਨਾਂ ਸਮੀਪੇ ਦਾਸੰ ਪ੍ਰਾਹਿਣੋਤ੍ ਕਿਨ੍ਤੁ ਕ੍ਰੁʼਸ਼਼ੀਵਲਾਸ੍ਤੰ ਪ੍ਰਹ੍ਰੁʼਤ੍ਯ ਰਿਕ੍ਤਹਸ੍ਤੰ ਵਿਸਸਰ੍ਜੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ਤਤਃ ਸੋਧਿਪਤਿਃ ਪੁਨਰਨ੍ਯੰ ਦਾਸੰ ਪ੍ਰੇਸ਼਼ਯਾਮਾਸ, ਤੇ ਤਮਪਿ ਪ੍ਰਹ੍ਰੁʼਤ੍ਯ ਕੁਵ੍ਯਵਹ੍ਰੁʼਤ੍ਯ ਰਿਕ੍ਤਹਸ੍ਤੰ ਵਿਸਸ੍ਰੁʼਜੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ਤਤਃ ਸ ਤ੍ਰੁʼਤੀਯਵਾਰਮ੍ ਅਨ੍ਯੰ ਪ੍ਰਾਹਿਣੋਤ੍ ਤੇ ਤਮਪਿ ਕ੍ਸ਼਼ਤਾਙ੍ਗੰ ਕ੍ਰੁʼਤ੍ਵਾ ਬਹਿ ਰ੍ਨਿਚਿਕ੍ਸ਼਼ਿਪੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ਤਦਾ ਕ੍ਸ਼਼ੇਤ੍ਰਪਤਿ ਰ੍ਵਿਚਾਰਯਾਮਾਸ, ਮਮੇਦਾਨੀਂ ਕਿੰ ਕਰ੍ੱਤਵ੍ਯੰ? ਮਮ ਪ੍ਰਿਯੇ ਪੁਤ੍ਰੇ ਪ੍ਰਹਿਤੇ ਤੇ ਤਮਵਸ਼੍ਯੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਸਮਾਦਰਿਸ਼਼੍ਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","ਕਿਨ੍ਤੁ ਕ੍ਰੁʼਸ਼਼ੀਵਲਾਸ੍ਤੰ ਨਿਰੀਕ੍ਸ਼਼੍ਯ ਪਰਸ੍ਪਰੰ ਵਿਵਿਚ੍ਯ ਪ੍ਰੋਚੁਃ, ਅਯਮੁੱਤਰਾਧਿਕਾਰੀ ਆਗੱਛਤੈਨੰ ਹਨ੍ਮਸ੍ਤਤੋਧਿਕਾਰੋਸ੍ਮਾਕੰ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ਤਤਸ੍ਤੇ ਤੰ ਕ੍ਸ਼਼ੇਤ੍ਰਾਦ੍ ਬਹਿ ਰ੍ਨਿਪਾਤ੍ਯ ਜਘ੍ਨੁਸ੍ਤਸ੍ਮਾਤ੍ ਸ ਕ੍ਸ਼਼ੇਤ੍ਰਪਤਿਸ੍ਤਾਨ੍ ਪ੍ਰਤਿ ਕਿੰ ਕਰਿਸ਼਼੍ਯਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ਸ ਆਗਤ੍ਯ ਤਾਨ੍ ਕ੍ਰੁʼਸ਼਼ੀਵਲਾਨ੍ ਹਤ੍ਵਾ ਪਰੇਸ਼਼ਾਂ ਹਸ੍ਤੇਸ਼਼ੁ ਤਤ੍ਕ੍ਸ਼਼ੇਤ੍ਰੰ ਸਮਰ੍ਪਯਿਸ਼਼੍ਯਤਿ; ਇਤਿ ਕਥਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਤੇ (ਅ)ਵਦਨ੍ ਏਤਾਦ੍ਰੁʼਸ਼ੀ ਘਟਨਾ ਨ ਭਵਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ਕਿਨ੍ਤੁ ਯੀਸ਼ੁਸ੍ਤਾਨਵਲੋਕ੍ਯ ਜਗਾਦ, ਤਰ੍ਹਿ, ਸ੍ਥਪਤਯਃ ਕਰਿਸ਼਼੍ਯਨ੍ਤਿ ਗ੍ਰਾਵਾਣੰ ਯਨ੍ਤੁ ਤੁੱਛਕੰ| ਪ੍ਰਧਾਨਪ੍ਰਸ੍ਤਰਃ ਕੋਣੇ ਸ ਏਵ ਹਿ ਭਵਿਸ਼਼੍ਯਤਿ| ਏਤਸ੍ਯ ਸ਼ਾਸ੍ਤ੍ਰੀਯਵਚਨਸ੍ਯ ਕਿੰ ਤਾਤ੍ਪਰ੍ੱਯੰ? ");
INSERT INTO sanpun_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","ਅਪਰੰ ਤਤ੍ਪਾਸ਼਼ਾਣੋਪਰਿ ਯਃ ਪਤਿਸ਼਼੍ਯਤਿ ਸ ਭੰਕ੍ਸ਼਼੍ਯਤੇ ਕਿਨ੍ਤੁ ਯਸ੍ਯੋਪਰਿ ਸ ਪਾਸ਼਼ਾਣਃ ਪਤਿਸ਼਼੍ਯਤਿ ਸ ਤੇਨ ਧੂਲਿਵਚ੍ ਚੂਰ੍ਣੀਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ਸੋਸ੍ਮਾਕੰ ਵਿਰੁੱਧੰ ਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤਮਿਮੰ ਕਥਿਤਵਾਨ੍ ਇਤਿ ਜ੍ਞਾਤ੍ਵਾ ਪ੍ਰਧਾਨਯਾਜਕਾ ਅਧ੍ਯਾਪਕਾਸ਼੍ਚ ਤਦੈਵ ਤੰ ਧਰ੍ਤੁੰ ਵਵਾਞ੍ਛੁਃ ਕਿਨ੍ਤੁ ਲੋਕੇਭ੍ਯੋ ਬਿਭ੍ਯੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ਅਤਏਵ ਤੰ ਪ੍ਰਤਿ ਸਤਰ੍ਕਾਃ ਸਨ੍ਤਃ ਕਥੰ ਤਦ੍ਵਾਕ੍ਯਦੋਸ਼਼ੰ ਧ੍ਰੁʼਤ੍ਵਾ ਤੰ ਦੇਸ਼ਾਧਿਪਸ੍ਯ ਸਾਧੁਵੇਸ਼ਧਾਰਿਣਸ਼੍ਚਰਾਨ੍ ਤਸ੍ਯ ਸਮੀਪੇ ਪ੍ਰੇਸ਼਼ਯਾਮਾਸੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","ਤਦਾ ਤੇ ਤੰ ਪਪ੍ਰੱਛੁਃ, ਹੇ ਉਪਦੇਸ਼ਕ ਭਵਾਨ੍ ਯਥਾਰ੍ਥੰ ਕਥਯਨ੍ ਉਪਦਿਸ਼ਤਿ, ਕਮਪ੍ਯਨਪੇਕ੍ਸ਼਼੍ਯ ਸਤ੍ਯਤ੍ਵੇਨੈਸ਼੍ਵਰੰ ਮਾਰ੍ਗਮੁਪਦਿਸ਼ਤਿ, ਵਯਮੇਤੱਜਾਨੀਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ਕੈਸਰਰਾਜਾਯ ਕਰੋਸ੍ਮਾਭਿ ਰ੍ਦੇਯੋ ਨ ਵਾ? ");
INSERT INTO sanpun_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ਸ ਤੇਸ਼਼ਾਂ ਵਞ੍ਚਨੰ ਜ੍ਞਾਤ੍ਵਾਵਦਤ੍ ਕੁਤੋ ਮਾਂ ਪਰੀਕ੍ਸ਼਼ਧ੍ਵੇ? ਮਾਂ ਮੁਦ੍ਰਾਮੇਕੰ ਦਰ੍ਸ਼ਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","ਇਹ ਲਿਖਿਤਾ ਮੂਰ੍ਤਿਰਿਯੰ ਨਾਮ ਚ ਕਸ੍ਯ? ਤੇ(ਅ)ਵਦਨ੍ ਕੈਸਰਸ੍ਯ| ");
INSERT INTO sanpun_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ਤਦਾ ਸ ਉਵਾਚ, ਤਰ੍ਹਿ ਕੈਸਰਸ੍ਯ ਦ੍ਰਵ੍ਯੰ ਕੈਸਰਾਯ ਦੱਤ; ਈਸ਼੍ਵਰਸ੍ਯ ਤੁ ਦ੍ਰਵ੍ਯਮੀਸ਼੍ਵਰਾਯ ਦੱਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ਤਸ੍ਮਾੱਲੋਕਾਨਾਂ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਤਤ੍ਕਥਾਯਾਃ ਕਮਪਿ ਦੋਸ਼਼ੰ ਧਰ੍ਤੁਮਪ੍ਰਾਪ੍ਯ ਤੇ ਤਸ੍ਯੋੱਤਰਾਦ੍ ਆਸ਼੍ਚਰ੍ੱਯੰ ਮਨ੍ਯਮਾਨਾ ਮੌਨਿਨਸ੍ਤਸ੍ਥੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","ਅਪਰਞ੍ਚ ਸ਼੍ਮਸ਼ਾਨਾਦੁੱਥਾਨਾਨਙ੍ਗੀਕਾਰਿਣਾਂ ਸਿਦੂਕਿਨਾਂ ਕਿਯਨ੍ਤੋ ਜਨਾ ਆਗਤ੍ਯ ਤੰ ਪਪ੍ਰੱਛੁਃ, ");
INSERT INTO sanpun_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","ਹੇ ਉਪਦੇਸ਼ਕ ਸ਼ਾਸ੍ਤ੍ਰੇ ਮੂਸਾ ਅਸ੍ਮਾਨ੍ ਪ੍ਰਤੀਤਿ ਲਿਲੇਖ ਯਸ੍ਯ ਭ੍ਰਾਤਾ ਭਾਰ੍ੱਯਾਯਾਂ ਸਤ੍ਯਾਂ ਨਿਃਸਨ੍ਤਾਨੋ ਮ੍ਰਿਯਤੇ ਸ ਤੱਜਾਯਾਂ ਵਿਵਹ੍ਯ ਤਦ੍ਵੰਸ਼ਮ੍ ਉਤ੍ਪਾਦਯਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ਤਥਾਚ ਕੇਚਿਤ੍ ਸਪ੍ਤ ਭ੍ਰਾਤਰ ਆਸਨ੍ ਤੇਸ਼਼ਾਂ ਜ੍ਯੇਸ਼਼੍ਠੋ ਭ੍ਰਾਤਾ ਵਿਵਹ੍ਯ ਨਿਰਪਤ੍ਯਃ ਪ੍ਰਾਣਾਨ੍ ਜਹੌ| ");
INSERT INTO sanpun_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ਅਥ ਦ੍ਵਿਤੀਯਸ੍ਤਸ੍ਯ ਜਾਯਾਂ ਵਿਵਹ੍ਯ ਨਿਰਪਤ੍ਯਃ ਸਨ੍ ਮਮਾਰ| ਤ੍ਰੁʼਤੀਯਸ਼੍ਚ ਤਾਮੇਵ ਵ੍ਯੁਵਾਹ; ");
INSERT INTO sanpun_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ਇੱਥੰ ਸਪ੍ਤ ਭ੍ਰਾਤਰਸ੍ਤਾਮੇਵ ਵਿਵਹ੍ਯ ਨਿਰਪਤ੍ਯਾਃ ਸਨ੍ਤੋ ਮਮ੍ਰੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ਸ਼ੇਸ਼਼ੇ ਸਾ ਸ੍ਤ੍ਰੀ ਚ ਮਮਾਰ| ");
INSERT INTO sanpun_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ਅਤਏਵ ਸ਼੍ਮਸ਼ਾਨਾਦੁੱਥਾਨਕਾਲੇ ਤੇਸ਼਼ਾਂ ਸਪ੍ਤਜਨਾਨਾਂ ਕਸ੍ਯ ਸਾ ਭਾਰ੍ੱਯਾ ਭਵਿਸ਼਼੍ਯਤਿ? ਯਤਃ ਸਾ ਤੇਸ਼਼ਾਂ ਸਪ੍ਤਾਨਾਮੇਵ ਭਾਰ੍ੱਯਾਸੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","ਤਦਾ ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯੁਵਾਚ, ਏਤਸ੍ਯ ਜਗਤੋ ਲੋਕਾ ਵਿਵਹਨ੍ਤਿ ਵਾਗ੍ਦੱਤਾਸ਼੍ਚ ਭਵਨ੍ਤਿ ");
INSERT INTO sanpun_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ਕਿਨ੍ਤੁ ਯੇ ਤੱਜਗਤ੍ਪ੍ਰਾਪ੍ਤਿਯੋਗ੍ਯਤ੍ਵੇਨ ਗਣਿਤਾਂ ਭਵਿਸ਼਼੍ਯਨ੍ਤਿ ਸ਼੍ਮਸ਼ਾਨਾੱਚੋੱਥਾਸ੍ਯਨ੍ਤਿ ਤੇ ਨ ਵਿਵਹਨ੍ਤਿ ਵਾਗ੍ਦੱਤਾਸ਼੍ਚ ਨ ਭਵਨ੍ਤਿ, ");
INSERT INTO sanpun_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ਤੇ ਪੁਨ ਰ੍ਨ ਮ੍ਰਿਯਨ੍ਤੇ ਕਿਨ੍ਤੁ ਸ਼੍ਮਸ਼ਾਨਾਦੁੱਥਾਪਿਤਾਃ ਸਨ੍ਤ ਈਸ਼੍ਵਰਸ੍ਯ ਸਨ੍ਤਾਨਾਃ ਸ੍ਵਰ੍ਗੀਯਦੂਤਾਨਾਂ ਸਦ੍ਰੁʼਸ਼ਾਸ਼੍ਚ ਭਵਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","ਅਧਿਕਨ੍ਤੁ ਮੂਸਾਃ ਸ੍ਤਮ੍ਬੋਪਾਖ੍ਯਾਨੇ ਪਰਮੇਸ਼੍ਵਰ ਈਬ੍ਰਾਹੀਮ ਈਸ਼੍ਵਰ ਇਸ੍ਹਾਕ ਈਸ਼੍ਵਰੋ ਯਾਕੂਬਸ਼੍ਚੇਸ਼੍ਵਰ ਇਤ੍ਯੁਕ੍ਤ੍ਵਾ ਮ੍ਰੁʼਤਾਨਾਂ ਸ਼੍ਮਸ਼ਾਨਾਦ੍ ਉੱਥਾਨਸ੍ਯ ਪ੍ਰਮਾਣੰ ਲਿਲੇਖ| ");
INSERT INTO sanpun_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ਅਤਏਵ ਯ ਈਸ਼੍ਵਰਃ ਸ ਮ੍ਰੁʼਤਾਨਾਂ ਪ੍ਰਭੁ ਰ੍ਨ ਕਿਨ੍ਤੁ ਜੀਵਤਾਮੇਵ ਪ੍ਰਭੁਃ, ਤੰਨਿਕਟੇ ਸਰ੍ੱਵੇ ਜੀਵਨ੍ਤਃ ਸਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ਇਤਿ ਸ਼੍ਰੁਤ੍ਵਾ ਕਿਯਨ੍ਤੋਧ੍ਯਾਪਕਾ ਊਚੁਃ, ਹੇ ਉਪਦੇਸ਼ਕ ਭਵਾਨ੍ ਭਦ੍ਰੰ ਪ੍ਰਤ੍ਯੁਕ੍ਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ਇਤਃ ਪਰੰ ਤੰ ਕਿਮਪਿ ਪ੍ਰਸ਼਼੍ਟੰ ਤੇਸ਼਼ਾਂ ਪ੍ਰਗਲ੍ਭਤਾ ਨਾਭੂਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ਪਸ਼੍ਚਾਤ੍ ਸ ਤਾਨ੍ ਉਵਾਚ, ਯਃ ਖ੍ਰੀਸ਼਼੍ਟਃ ਸ ਦਾਯੂਦਃ ਸਨ੍ਤਾਨ ਏਤਾਂ ਕਥਾਂ ਲੋਕਾਃ ਕਥੰ ਕਥਯਨ੍ਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","ਯਤਃ ਮਮ ਪ੍ਰਭੁਮਿਦੰ ਵਾਕ੍ਯਮਵਦਤ੍ ਪਰਮੇਸ਼੍ਵਰਃ| ਤਵ ਸ਼ਤ੍ਰੂਨਹੰ ਯਾਵਤ੍ ਪਾਦਪੀਠੰ ਕਰੋਮਿ ਨ| ਤਾਵਤ੍ ਕਾਲੰ ਮਦੀਯੇ ਤ੍ਵੰ ਦਕ੍ਸ਼਼ਪਾਰ੍ਸ਼੍ਵ ਉਪਾਵਿਸ਼| ");
INSERT INTO sanpun_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ਇਤਿ ਕਥਾਂ ਦਾਯੂਦ੍ ਸ੍ਵਯੰ ਗੀਤਗ੍ਰਨ੍ਥੇ(ਅ)ਵਦਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","ਅਤਏਵ ਯਦਿ ਦਾਯੂਦ੍ ਤੰ ਪ੍ਰਭੁੰ ਵਦਤਿ, ਤਰ੍ਹਿ ਸ ਕਥੰ ਤਸ੍ਯ ਸਨ੍ਤਾਨੋ ਭਵਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","ਪਸ਼੍ਚਾਦ੍ ਯੀਸ਼ੁਃ ਸਰ੍ੱਵਜਨਾਨਾਂ ਕਰ੍ਣਗੋਚਰੇ ਸ਼ਿਸ਼਼੍ਯਾਨੁਵਾਚ, ");
INSERT INTO sanpun_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","ਯੇ(ਅ)ਧ੍ਯਾਪਕਾ ਦੀਰ੍ਘਪਰਿੱਛਦੰ ਪਰਿਧਾਯ ਭ੍ਰਮਨ੍ਤਿ, ਹੱਟਾਪਣਯੋ ਰ੍ਨਮਸ੍ਕਾਰੇ ਭਜਨਗੇਹਸ੍ਯ ਪ੍ਰੋੱਚਾਸਨੇ ਭੋਜਨਗ੍ਰੁʼਹਸ੍ਯ ਪ੍ਰਧਾਨਸ੍ਥਾਨੇ ਚ ਪ੍ਰੀਯਨ੍ਤੇ ");
INSERT INTO sanpun_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ਵਿਧਵਾਨਾਂ ਸਰ੍ੱਵਸ੍ਵੰ ਗ੍ਰਸਿਤ੍ਵਾ ਛਲੇਨ ਦੀਰ੍ਘਕਾਲੰ ਪ੍ਰਾਰ੍ਥਯਨ੍ਤੇ ਚ ਤੇਸ਼਼ੁ ਸਾਵਧਾਨਾ ਭਵਤ, ਤੇਸ਼਼ਾਮੁਗ੍ਰਦਣ੍ਡੋ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","ਅਥ ਧਨਿਲੋਕਾ ਭਾਣ੍ਡਾਗਾਰੇ ਧਨੰ ਨਿਕ੍ਸ਼਼ਿਪਨ੍ਤਿ ਸ ਤਦੇਵ ਪਸ਼੍ਯਤਿ, ");
INSERT INTO sanpun_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ਏਤਰ੍ਹਿ ਕਾਚਿੱਦੀਨਾ ਵਿਧਵਾ ਪਣਦ੍ਵਯੰ ਨਿਕ੍ਸ਼਼ਿਪਤਿ ਤਦ੍ ਦਦਰ੍ਸ਼| ");
INSERT INTO sanpun_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ਤਤੋ ਯੀਸ਼ੁਰੁਵਾਚ ਯੁਸ਼਼੍ਮਾਨਹੰ ਯਥਾਰ੍ਥੰ ਵਦਾਮਿ, ਦਰਿਦ੍ਰੇਯੰ ਵਿਧਵਾ ਸਰ੍ੱਵੇਭ੍ਯੋਧਿਕੰ ਨ੍ਯਕ੍ਸ਼਼ੇਪ੍ਸੀਤ੍, ");
INSERT INTO sanpun_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ਯਤੋਨ੍ਯੇ ਸ੍ਵਪ੍ਰਾਜ੍ਯਧਨੇਭ੍ਯ ਈਸ਼੍ਵਰਾਯ ਕਿਞ੍ਚਿਤ੍ ਨ੍ਯਕ੍ਸ਼਼ੇਪ੍ਸੁਃ, ਕਿਨ੍ਤੁ ਦਰਿਦ੍ਰੇਯੰ ਵਿਧਵਾ ਦਿਨਯਾਪਨਾਰ੍ਥੰ ਸ੍ਵਸ੍ਯ ਯਤ੍ ਕਿਞ੍ਚਿਤ੍ ਸ੍ਥਿਤੰ ਤਤ੍ ਸਰ੍ੱਵੰ ਨ੍ਯਕ੍ਸ਼਼ੇਪ੍ਸੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","ਅਪਰਞ੍ਚ ਉੱਤਮਪ੍ਰਸ੍ਤਰੈਰੁਤ੍ਸ੍ਰੁʼਸ਼਼੍ਟਵ੍ਯੈਸ਼੍ਚ ਮਨ੍ਦਿਰੰ ਸੁਸ਼ੋਭਤੇਤਰਾਂ ਕੈਸ਼੍ਚਿਦਿਤ੍ਯੁਕ੍ਤੇ ਸ ਪ੍ਰਤ੍ਯੁਵਾਚ ");
INSERT INTO sanpun_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","ਯੂਯੰ ਯਦਿਦੰ ਨਿਚਯਨੰ ਪਸ਼੍ਯਥ, ਅਸ੍ਯ ਪਾਸ਼਼ਾਣੈਕੋਪ੍ਯਨ੍ਯਪਾਸ਼਼ਾਣੋਪਰਿ ਨ ਸ੍ਥਾਸ੍ਯਤਿ, ਸਰ੍ੱਵੇ ਭੂਸਾਦ੍ਭਵਿਸ਼਼੍ਯਨ੍ਤਿ ਕਾਲੋਯਮਾਯਾਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ਤਦਾ ਤੇ ਪਪ੍ਰੱਛੁਃ, ਹੇ ਗੁਰੋ ਘਟਨੇਦ੍ਰੁʼਸ਼ੀ ਕਦਾ ਭਵਿਸ਼਼੍ਯਤਿ? ਘਟਨਾਯਾ ਏਤਸ੍ਯਸਸ਼੍ਚਿਹ੍ਨੰ ਵਾ ਕਿੰ ਭਵਿਸ਼਼੍ਯਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ਤਦਾ ਸ ਜਗਾਦ, ਸਾਵਧਾਨਾ ਭਵਤ ਯਥਾ ਯੁਸ਼਼੍ਮਾਕੰ ਭ੍ਰਮੰ ਕੋਪਿ ਨ ਜਨਯਤਿ, ਖੀਸ਼਼੍ਟੋਹਮਿਤ੍ਯੁਕ੍ਤ੍ਵਾ ਮਮ ਨਾਮ੍ਰਾ ਬਹਵ ਉਪਸ੍ਥਾਸ੍ਯਨ੍ਤਿ ਸ ਕਾਲਃ ਪ੍ਰਾਯੇਣੋਪਸ੍ਥਿਤਃ, ਤੇਸ਼਼ਾਂ ਪਸ਼੍ਚਾਨ੍ਮਾ ਗੱਛਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","ਯੁੱਧਸ੍ਯੋਪਪ੍ਲਵਸ੍ਯ ਚ ਵਾਰ੍ੱਤਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਮਾ ਸ਼ਙ੍ਕਧ੍ਵੰ, ਯਤਃ ਪ੍ਰਥਮਮ੍ ਏਤਾ ਘਟਨਾ ਅਵਸ਼੍ਯੰ ਭਵਿਸ਼਼੍ਯਨ੍ਤਿ ਕਿਨ੍ਤੁ ਨਾਪਾਤੇ ਯੁਗਾਨ੍ਤੋ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","ਅਪਰਞ੍ਚ ਕਥਯਾਮਾਸ, ਤਦਾ ਦੇਸ਼ਸ੍ਯ ਵਿਪਕ੍ਸ਼਼ਤ੍ਵੇਨ ਦੇਸ਼ੋ ਰਾਜ੍ਯਸ੍ਯ ਵਿਪਕ੍ਸ਼਼ਤ੍ਵੇਨ ਰਾਜ੍ਯਮ੍ ਉੱਥਾਸ੍ਯਤਿ, ");
INSERT INTO sanpun_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ਨਾਨਾਸ੍ਥਾਨੇਸ਼਼ੁ ਮਹਾਭੂਕਮ੍ਪੋ ਦੁਰ੍ਭਿਕ੍ਸ਼਼ੰ ਮਾਰੀ ਚ ਭਵਿਸ਼਼੍ਯਨ੍ਤਿ, ਤਥਾ ਵ੍ਯੋਮਮਣ੍ਡਲਸ੍ਯ ਭਯਙ੍ਕਰਦਰ੍ਸ਼ਨਾਨ੍ਯਸ਼੍ਚਰ੍ੱਯਲਕ੍ਸ਼਼ਣਾਨਿ ਚ ਪ੍ਰਕਾਸ਼ਯਿਸ਼਼੍ਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","ਕਿਨ੍ਤੁ ਸਰ੍ੱਵਾਸਾਮੇਤਾਸਾਂ ਘਟਨਾਨਾਂ ਪੂਰ੍ੱਵੰ ਲੋਕਾ ਯੁਸ਼਼੍ਮਾਨ੍ ਧ੍ਰੁʼਤ੍ਵਾ ਤਾਡਯਿਸ਼਼੍ਯਨ੍ਤਿ, ਭਜਨਾਲਯੇ ਕਾਰਾਯਾਞ੍ਚ ਸਮਰ੍ਪਯਿਸ਼਼੍ਯਨ੍ਤਿ ਮਮ ਨਾਮਕਾਰਣਾਦ੍ ਯੁਸ਼਼੍ਮਾਨ੍ ਭੂਪਾਨਾਂ ਸ਼ਾਸਕਾਨਾਞ੍ਚ ਸੰਮੁਖੰ ਨੇਸ਼਼੍ਯਨ੍ਤਿ ਚ| ");
INSERT INTO sanpun_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ਸਾਕ੍ਸ਼਼੍ਯਾਰ੍ਥਮ੍ ਏਤਾਨਿ ਯੁਸ਼਼੍ਮਾਨ੍ ਪ੍ਰਤਿ ਘਟਿਸ਼਼੍ਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ਤਦਾ ਕਿਮੁੱਤਰੰ ਵਕ੍ਤਵ੍ਯਮ੍ ਏਤਤ੍ ਨ ਚਿਨ੍ਤਯਿਸ਼਼੍ਯਾਮ ਇਤਿ ਮਨਃਸੁ ਨਿਸ਼੍ਚਿਤਨੁਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ਵਿਪਕ੍ਸ਼਼ਾ ਯਸ੍ਮਾਤ੍ ਕਿਮਪ੍ਯੁੱਤਰਮ੍ ਆਪੱਤਿਞ੍ਚ ਕਰ੍ੱਤੁੰ ਨ ਸ਼ਕ੍ਸ਼਼੍ਯਨ੍ਤਿ ਤਾਦ੍ਰੁʼਸ਼ੰ ਵਾਕ੍ਪਟੁਤ੍ਵੰ ਜ੍ਞਾਨਞ੍ਚ ਯੁਸ਼਼੍ਮਭ੍ਯੰ ਦਾਸ੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","ਕਿਞ੍ਚ ਯੂਯੰ ਪਿਤ੍ਰਾ ਮਾਤ੍ਰਾ ਭ੍ਰਾਤ੍ਰਾ ਬਨ੍ਧੁਨਾ ਜ੍ਞਾਤ੍ਯਾ ਕੁਟੁਮ੍ਬੇਨ ਚ ਪਰਕਰੇਸ਼਼ੁ ਸਮਰ੍ਪਯਿਸ਼਼੍ਯਧ੍ਵੇ; ਤਤਸ੍ਤੇ ਯੁਸ਼਼੍ਮਾਕੰ ਕਞ੍ਚਨ ਕਞ੍ਚਨ ਘਾਤਯਿਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","ਮਮ ਨਾਮ੍ਨਃ ਕਾਰਣਾਤ੍ ਸਰ੍ੱਵੈ ਰ੍ਮਨੁਸ਼਼੍ਯੈ ਰ੍ਯੂਯਮ੍ ਰੁʼਤੀਯਿਸ਼਼੍ਯਧ੍ਵੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ਕਿਨ੍ਤੁ ਯੁਸ਼਼੍ਮਾਕੰ ਸ਼ਿਰਃਕੇਸ਼ੈਕੋਪਿ ਨ ਵਿਨੰਕ੍ਸ਼਼੍ਯਤਿ, ");
INSERT INTO sanpun_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ਤਸ੍ਮਾਦੇਵ ਧੈਰ੍ੱਯਮਵਲਮ੍ਬ੍ਯ ਸ੍ਵਸ੍ਵਪ੍ਰਾਣਾਨ੍ ਰਕ੍ਸ਼਼ਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","ਅਪਰਞ੍ਚ ਯਿਰੂਸ਼ਾਲਮ੍ਪੁਰੰ ਸੈਨ੍ਯਵੇਸ਼਼੍ਟਿਤੰ ਵਿਲੋਕ੍ਯ ਤਸ੍ਯੋੱਛਿੰਨਤਾਯਾਃ ਸਮਯਃ ਸਮੀਪ ਇਤ੍ਯਵਗਮਿਸ਼਼੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","ਤਦਾ ਯਿਹੂਦਾਦੇਸ਼ਸ੍ਥਾ ਲੋਕਾਃ ਪਰ੍ੱਵਤੰ ਪਲਾਯਨ੍ਤਾਂ, ਯੇ ਚ ਨਗਰੇ ਤਿਸ਼਼੍ਠਨ੍ਤਿ ਤੇ ਦੇਸ਼ਾਨ੍ਤਰੰ ਪਲਾਯਨ੍ਤਾ, ਯੇ ਚ ਗ੍ਰਾਮੇ ਤਿਸ਼਼੍ਠਨ੍ਤਿ ਤੇ ਨਗਰੰ ਨ ਪ੍ਰਵਿਸ਼ਨ੍ਤੁ, ");
INSERT INTO sanpun_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","ਯਤਸ੍ਤਦਾ ਸਮੁਚਿਤਦਣ੍ਡਨਾਯ ਧਰ੍ੰਮਪੁਸ੍ਤਕੇ ਯਾਨਿ ਸਰ੍ੱਵਾਣਿ ਲਿਖਿਤਾਨਿ ਤਾਨਿ ਸਫਲਾਨਿ ਭਵਿਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","ਕਿਨ੍ਤੁ ਯਾ ਯਾਸ੍ਤਦਾ ਗਰ੍ਭਵਤ੍ਯਃ ਸ੍ਤਨ੍ਯਦਾਵ੍ਯਸ਼੍ਚ ਤਾਮਾਂ ਦੁਰ੍ਗਤਿ ਰ੍ਭਵਿਸ਼਼੍ਯਤਿ, ਯਤ ਏਤਾੱਲੋਕਾਨ੍ ਪ੍ਰਤਿ ਕੋਪੋ ਦੇਸ਼ੇ ਚ ਵਿਸ਼਼ਮਦੁਰ੍ਗਤਿ ਰ੍ਘਟਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","ਵਸ੍ਤੁਤਸ੍ਤੁ ਤੇ ਖਙ੍ਗਧਾਰਪਰਿੱਵਙ੍ਗੰ ਲਪ੍ਸ੍ਯਨ੍ਤੇ ਬੱਧਾਃ ਸਨ੍ਤਃ ਸਰ੍ੱਵਦੇਸ਼ੇਸ਼਼ੁ ਨਾਯਿਸ਼਼੍ਯਨ੍ਤੇ ਚ ਕਿਞ੍ਚਾਨ੍ਯਦੇਸ਼ੀਯਾਨਾਂ ਸਮਯੋਪਸ੍ਥਿਤਿਪਰ੍ੱਯਨ੍ਤੰ ਯਿਰੂਸ਼ਾਲਮ੍ਪੁਰੰ ਤੈਃ ਪਦਤਲੈ ਰ੍ਦਲਯਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","ਸੂਰ੍ੱਯਚਨ੍ਦ੍ਰਨਕ੍ਸ਼਼ਤ੍ਰੇਸ਼਼ੁ ਲਕ੍ਸ਼਼ਣਾਦਿ ਭਵਿਸ਼਼੍ਯਨ੍ਤਿ, ਭੁਵਿ ਸਰ੍ੱਵਦੇਸ਼ੀਯਾਨਾਂ ਦੁਃਖੰ ਚਿਨ੍ਤਾ ਚ ਸਿਨ੍ਧੌ ਵੀਚੀਨਾਂ ਤਰ੍ਜਨੰ ਗਰ੍ਜਨਞ੍ਚ ਭਵਿਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ਭੂਭੌ ਭਾਵਿਘਟਨਾਂ ਚਿਨ੍ਤਯਿਤ੍ਵਾ ਮਨੁਜਾ ਭਿਯਾਮ੍ਰੁʼਤਕਲ੍ਪਾ ਭਵਿਸ਼਼੍ਯਨ੍ਤਿ, ਯਤੋ ਵ੍ਯੋਮਮਣ੍ਡਲੇ ਤੇਜਸ੍ਵਿਨੋ ਦੋਲਾਯਮਾਨਾ ਭਵਿਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ਤਦਾ ਪਰਾਕ੍ਰਮੇਣਾ ਮਹਾਤੇਜਸਾ ਚ ਮੇਘਾਰੂਢੰ ਮਨੁਸ਼਼੍ਯਪੁਤ੍ਰਮ੍ ਆਯਾਨ੍ਤੰ ਦ੍ਰਕ੍ਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","ਕਿਨ੍ਤ੍ਵੇਤਾਸਾਂ ਘਟਨਾਨਾਮਾਰਮ੍ਭੇ ਸਤਿ ਯੂਯੰ ਮਸ੍ਤਕਾਨ੍ਯੁੱਤੋਲ੍ਯ ਊਰ੍ਦਧ੍ਵੰ ਦ੍ਰਕ੍ਸ਼਼੍ਯਥ, ਯਤੋ ਯੁਸ਼਼੍ਮਾਕੰ ਮੁਕ੍ਤੇਃ ਕਾਲਃ ਸਵਿਧੋ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ਤਤਸ੍ਤੇਨੈਤਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤਕਥਾ ਕਥਿਤਾ, ਪਸ਼੍ਯਤ ਉਡੁਮ੍ਬਰਾਦਿਵ੍ਰੁʼਕ੍ਸ਼਼ਾਣਾਂ ");
INSERT INTO sanpun_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ਨਵੀਨਪਤ੍ਰਾਣਿ ਜਾਤਾਨੀਤਿ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਨਿਦਾਵਕਾਲ ਉਪਸ੍ਥਿਤ ਇਤਿ ਯਥਾ ਯੂਯੰ ਜ੍ਞਾਤੁੰ ਸ਼ਕ੍ਨੁਥ, ");
INSERT INTO sanpun_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ਤਥਾ ਸਰ੍ੱਵਾਸਾਮਾਸਾਂ ਘਟਨਾਨਾਮ੍ ਆਰਮ੍ਭੇ ਦ੍ਰੁʼਸ਼਼੍ਟੇ ਸਤੀਸ਼੍ਵਰਸ੍ਯ ਰਾਜਤ੍ਵੰ ਨਿਕਟਮ੍ ਇਤ੍ਯਪਿ ਜ੍ਞਾਸ੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","ਯੁਸ਼਼੍ਮਾਨਹੰ ਯਥਾਰ੍ਥੰ ਵਦਾਮਿ, ਵਿਦ੍ਯਮਾਨਲੋਕਾਨਾਮੇਸ਼਼ਾਂ ਗਮਨਾਤ੍ ਪੂਰ੍ੱਵਮ੍ ਏਤਾਨਿ ਘਟਿਸ਼਼੍ਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ਨਭੋਭੁਵੋਰ੍ਲੋਪੋ ਭਵਿਸ਼਼੍ਯਤਿ ਮਮ ਵਾਕ੍ ਤੁ ਕਦਾਪਿ ਲੁਪ੍ਤਾ ਨ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","ਅਤਏਵ ਵਿਸ਼਼ਮਾਸ਼ਨੇਨ ਪਾਨੇਨ ਚ ਸਾਂਮਾਰਿਕਚਿਨ੍ਤਾਭਿਸ਼੍ਚ ਯੁਸ਼਼੍ਮਾਕੰ ਚਿੱਤੇਸ਼਼ੁ ਮੱਤੇਸ਼਼ੁ ਤੱਦਿਨਮ੍ ਅਕਸ੍ਮਾਦ੍ ਯੁਸ਼਼੍ਮਾਨ੍ ਪ੍ਰਤਿ ਯਥਾ ਨੋਪਤਿਸ਼਼੍ਠਤਿ ਤਦਰ੍ਥੰ ਸ੍ਵੇਸ਼਼ੁ ਸਾਵਧਾਨਾਸ੍ਤਿਸ਼਼੍ਠਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ਪ੍ਰੁʼਥਿਵੀਸ੍ਥਸਰ੍ੱਵਲੋਕਾਨ੍ ਪ੍ਰਤਿ ਤੱਦਿਨਮ੍ ਉਨ੍ਮਾਥ ਇਵ ਉਪਸ੍ਥਾਸ੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ਯਥਾ ਯੂਯਮ੍ ਏਤਦ੍ਭਾਵਿਘਟਨਾ ਉੱਤਰ੍ੱਤੁੰ ਮਨੁਜਸੁਤਸ੍ਯ ਸੰਮੁਖੇ ਸੰਸ੍ਥਾਤੁਞ੍ਚ ਯੋਗ੍ਯਾ ਭਵਥ ਕਾਰਣਾਦਸ੍ਮਾਤ੍ ਸਾਵਧਾਨਾਃ ਸਨ੍ਤੋ ਨਿਰਨ੍ਤਰੰ ਪ੍ਰਾਰ੍ਥਯਧ੍ਵੰ| ");
INSERT INTO sanpun_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ਅਪਰਞ੍ਚ ਸ ਦਿਵਾ ਮਨ੍ਦਿਰ ਉਪਦਿਸ਼੍ਯ ਰਾਚੈ ਜੈਤੁਨਾਦ੍ਰਿੰ ਗਤ੍ਵਾਤਿਸ਼਼੍ਠਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ਤਤਃ ਪ੍ਰਤ੍ਯੂਸ਼਼ੇ ਲਾਕਾਸ੍ਤਤ੍ਕਥਾਂ ਸ਼੍ਰੋਤੁੰ ਮਨ੍ਦਿਰੇ ਤਦਨ੍ਤਿਕਮ੍ ਆਗੱਛਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","ਅਪਰਞ੍ਚ ਕਿਣ੍ਵਸ਼ੂਨ੍ਯਪੂਪੋਤ੍ਸਵਸ੍ਯ ਕਾਲ ਉਪਸ੍ਥਿਤੇ ");
INSERT INTO sanpun_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ਪ੍ਰਧਾਨਯਾਜਕਾ ਅਧ੍ਯਾਯਕਾਸ਼੍ਚ ਯਥਾ ਤੰ ਹਨ੍ਤੁੰ ਸ਼ਕ੍ਨੁਵਨ੍ਤਿ ਤਥੋਪਾਯਾਮ੍ ਅਚੇਸ਼਼੍ਟਨ੍ਤ ਕਿਨ੍ਤੁ ਲੋਕੇਭ੍ਯੋ ਬਿਭ੍ਯੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ਏਤਸ੍ਤਿਨ੍ ਸਮਯੇ ਦ੍ਵਾਦਸ਼ਸ਼ਿਸ਼਼੍ਯੇਸ਼਼ੁ ਗਣਿਤ ਈਸ਼਼੍ਕਰਿਯੋਤੀਯਰੂਢਿਮਾਨ੍ ਯੋ ਯਿਹੂਦਾਸ੍ਤਸ੍ਯਾਨ੍ਤਃਕਰਣੰ ਸ਼ੈਤਾਨਾਸ਼੍ਰਿਤਤ੍ਵਾਤ੍ ");
INSERT INTO sanpun_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ਸ ਗਤ੍ਵਾ ਯਥਾ ਯੀਸ਼ੁੰ ਤੇਸ਼਼ਾਂ ਕਰੇਸ਼਼ੁ ਸਮਰ੍ਪਯਿਤੁੰ ਸ਼ਕ੍ਨੋਤਿ ਤਥਾ ਮਨ੍ਤ੍ਰਣਾਂ ਪ੍ਰਧਾਨਯਾਜਕੈਃ ਸੇਨਾਪਤਿਭਿਸ਼੍ਚ ਸਹ ਚਕਾਰ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","ਤੇਨ ਤੇ ਤੁਸ਼਼੍ਟਾਸ੍ਤਸ੍ਮੈ ਮੁਦ੍ਰਾਂ ਦਾਤੁੰ ਪਣੰ ਚਕ੍ਰੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ਤਤਃ ਸੋਙ੍ਗੀਕ੍ਰੁʼਤ੍ਯ ਯਥਾ ਲੋਕਾਨਾਮਗੋਚਰੇ ਤੰ ਪਰਕਰੇਸ਼਼ੁ ਸਮਰ੍ਪਯਿਤੁੰ ਸ਼ਕ੍ਨੋਤਿ ਤਥਾਵਕਾਸ਼ੰ ਚੇਸ਼਼੍ਟਿਤੁਮਾਰੇਭੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","ਅਥ ਕਿਣ੍ਵਸ਼ੂਨ੍ਯਪੂਪੋਤ੍ਮਵਦਿਨੇ, ਅਰ੍ਥਾਤ੍ ਯਸ੍ਮਿਨ੍ ਦਿਨੇ ਨਿਸ੍ਤਾਰੋਤ੍ਸਵਸ੍ਯ ਮੇਸ਼਼ੋ ਹਨ੍ਤਵ੍ਯਸ੍ਤਸ੍ਮਿਨ੍ ਦਿਨੇ ");
INSERT INTO sanpun_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ਯੀਸ਼ੁਃ ਪਿਤਰੰ ਯੋਹਨਞ੍ਚਾਹੂਯ ਜਗਾਦ, ਯੁਵਾਂ ਗਤ੍ਵਾਸ੍ਮਾਕੰ ਭੋਜਨਾਰ੍ਥੰ ਨਿਸ੍ਤਾਰੋਤ੍ਸਵਸ੍ਯ ਦ੍ਰਵ੍ਯਾਣ੍ਯਾਸਾਦਯਤੰ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ਤਦਾ ਤੌ ਪਪ੍ਰੱਛਤੁਃ ਕੁਚਾਸਾਦਯਾਵੋ ਭਵਤਃ ਕੇੱਛਾ? ");
INSERT INTO sanpun_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ਤਦਾ ਸੋਵਾਦੀਤ੍, ਨਗਰੇ ਪ੍ਰਵਿਸ਼਼੍ਟੇ ਕਸ਼੍ਚਿੱਜਲਕੁਮ੍ਭਮਾਦਾਯ ਯੁਵਾਂ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਕਰਿਸ਼਼੍ਯਤਿ ਸ ਯੰਨਿਵੇਸ਼ਨੰ ਪ੍ਰਵਿਸ਼ਤਿ ਯੁਵਾਮਪਿ ਤੰਨਿਵੇਸ਼ਨੰ ਤਤ੍ਪਸ਼੍ਚਾਦਿਤ੍ਵਾ ਨਿਵੇਸ਼ਨਪਤਿਮ੍ ਇਤਿ ਵਾਕ੍ਯੰ ਵਦਤੰ, ");
INSERT INTO sanpun_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ਯਤ੍ਰਾਹੰ ਨਿਸ੍ਤਾਰੋਤ੍ਸਵਸ੍ਯ ਭੋਜ੍ਯੰ ਸ਼ਿਸ਼਼੍ਯੈਃ ਸਾਰ੍ੱਧੰ ਭੋਕ੍ਤੁੰ ਸ਼ਕ੍ਨੋਮਿ ਸਾਤਿਥਿਸ਼ਾਲਾा ਕੁਤ੍ਰ? ਕਥਾਮਿਮਾਂ ਪ੍ਰਭੁਸ੍ਤ੍ਵਾਂ ਪ੍ਰੁʼੱਛਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ਤਤਃ ਸ ਜਨੋ ਦ੍ਵਿਤੀਯਪ੍ਰਕੋਸ਼਼੍ਠੀਯਮ੍ ਏਕੰ ਸ਼ਸ੍ਤੰ ਕੋਸ਼਼੍ਠੰ ਦਰ੍ਸ਼ਯਿਸ਼਼੍ਯਤਿ ਤਤ੍ਰ ਭੋਜ੍ਯਮਾਸਾਦਯਤੰ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ਤਤਸ੍ਤੌ ਗਤ੍ਵਾ ਤਦ੍ਵਾਕ੍ਯਾਨੁਸਾਰੇਣ ਸਰ੍ੱਵੰ ਦ੍ਰੁʼਸ਼਼੍ਦ੍ਵਾ ਤਤ੍ਰ ਨਿਸ੍ਤਾਰੋਤ੍ਸਵੀਯੰ ਭੋਜ੍ਯਮਾਸਾਦਯਾਮਾਸਤੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","ਅਥ ਕਾਲ ਉਪਸ੍ਥਿਤੇ ਯੀਸ਼ੁ ਰ੍ਦ੍ਵਾਦਸ਼ਭਿਃ ਪ੍ਰੇਰਿਤੈਃ ਸਹ ਭੋਕ੍ਤੁਮੁਪਵਿਸ਼੍ਯ ਕਥਿਤਵਾਨ੍ ");
INSERT INTO sanpun_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ਮਮ ਦੁਃਖਭੋਗਾਤ੍ ਪੂਰ੍ੱਵੰ ਯੁਭਾਭਿਃ ਸਹ ਨਿਸ੍ਤਾਰੋਤ੍ਸਵਸ੍ਯੈਤਸ੍ਯ ਭੋਜ੍ਯੰ ਭੋਕ੍ਤੁੰ ਮਯਾਤਿਵਾਞ੍ਛਾ ਕ੍ਰੁʼਤਾ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","ਯੁਸ਼਼੍ਮਾਨ੍ ਵਦਾਮਿ, ਯਾਵਤ੍ਕਾਲਮ੍ ਈਸ਼੍ਵਰਰਾਜ੍ਯੇ ਭੋਜਨੰ ਨ ਕਰਿਸ਼਼੍ਯੇ ਤਾਵਤ੍ਕਾਲਮ੍ ਇਦੰ ਨ ਭੋਕ੍ਸ਼਼੍ਯੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ਤਦਾ ਸ ਪਾਨਪਾਤ੍ਰਮਾਦਾਯ ਈਸ਼੍ਵਰਸ੍ਯ ਗੁਣਾਨ੍ ਕੀਰ੍ੱਤਯਿਤ੍ਵਾ ਤੇਭ੍ਯੋ ਦਤ੍ਵਾਵਦਤ੍, ਇਦੰ ਗ੍ਰੁʼਹ੍ਲੀਤ ਯੂਯੰ ਵਿਭਜ੍ਯ ਪਿਵਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ਯੁਸ਼਼੍ਮਾਨ੍ ਵਦਾਮਿ ਯਾਵਤ੍ਕਾਲਮ੍ ਈਸ਼੍ਵਰਰਾਜਤ੍ਵਸ੍ਯ ਸੰਸ੍ਥਾਪਨੰ ਨ ਭਵਤਿ ਤਾਵਦ੍ ਦ੍ਰਾਕ੍ਸ਼਼ਾਫਲਰਸੰ ਨ ਪਾਸ੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ਤਤਃ ਪੂਪੰ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਈਸ਼੍ਵਰਗੁਣਾਨ੍ ਕੀਰ੍ੱਤਯਿਤ੍ਵਾ ਭਙ੍ਕ੍ਤਾ ਤੇਭ੍ਯੋ ਦਤ੍ਵਾਵਦਤ੍, ਯੁਸ਼਼੍ਮਦਰ੍ਥੰ ਸਮਰ੍ਪਿਤੰ ਯਨ੍ਮਮ ਵਪੁਸ੍ਤਦਿਦੰ, ਏਤਤ੍ ਕਰ੍ੰਮ ਮਮ ਸ੍ਮਰਣਾਰ੍ਥੰ ਕੁਰੁਧ੍ਵੰ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","ਅਥ ਭੋਜਨਾਨ੍ਤੇ ਤਾਦ੍ਰੁʼਸ਼ੰ ਪਾਤ੍ਰੰ ਗ੍ਰੁʼਹੀਤ੍ਵਾਵਦਤ੍, ਯੁਸ਼਼੍ਮਤ੍ਕ੍ਰੁʼਤੇ ਪਾਤਿਤੰ ਯਨ੍ਮਮ ਰਕ੍ਤੰ ਤੇਨ ਨਿਰ੍ਣੀਤਨਵਨਿਯਮਰੂਪੰ ਪਾਨਪਾਤ੍ਰਮਿਦੰ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","ਪਸ਼੍ਯਤ ਯੋ ਮਾਂ ਪਰਕਰੇਸ਼਼ੁ ਸਮਰ੍ਪਯਿਸ਼਼੍ਯਤਿ ਸ ਮਯਾ ਸਹ ਭੋਜਨਾਸਨ ਉਪਵਿਸ਼ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","ਯਥਾ ਨਿਰੂਪਿਤਮਾਸ੍ਤੇ ਤਦਨੁਸਾਰੇਣਾ ਮਨੁਸ਼਼੍ਯਪੁुਤ੍ਰਸ੍ਯ ਗਤਿ ਰ੍ਭਵਿਸ਼਼੍ਯਤਿ ਕਿਨ੍ਤੁ ਯਸ੍ਤੰ ਪਰਕਰੇਸ਼਼ੁ ਸਮਰ੍ਪਯਿਸ਼਼੍ਯਤਿ ਤਸ੍ਯ ਸਨ੍ਤਾਪੋ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ਤਦਾ ਤੇਸ਼਼ਾਂ ਕੋ ਜਨ ਏਤਤ੍ ਕਰ੍ੰਮ ਕਰਿਸ਼਼੍ਯਤਿ ਤਤ੍ ਤੇ ਪਰਸ੍ਪਰੰ ਪ੍ਰਸ਼਼੍ਟੁਮਾਰੇਭਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","ਅਪਰੰ ਤੇਸ਼਼ਾਂ ਕੋ ਜਨਃ ਸ਼੍ਰੇਸ਼਼੍ਠਤ੍ਵੇਨ ਗਣਯਿਸ਼਼੍ਯਤੇ, ਅਤ੍ਰਾਰ੍ਥੇ ਤੇਸ਼਼ਾਂ ਵਿਵਾਦੋਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","ਅਸ੍ਮਾਤ੍ ਕਾਰਣਾਤ੍ ਸੋਵਦਤ੍, ਅਨ੍ਯਦੇਸ਼ੀਯਾਨਾਂ ਰਾਜਾਨਃ ਪ੍ਰਜਾਨਾਮੁਪਰਿ ਪ੍ਰਭੁਤ੍ਵੰ ਕੁਰ੍ੱਵਨ੍ਤਿ ਦਾਰੁਣਸ਼ਾਸਨੰ ਕ੍ਰੁʼਤ੍ਵਾਪਿ ਤੇ ਭੂਪਤਿਤ੍ਵੇਨ ਵਿਖ੍ਯਾਤਾ ਭਵਨ੍ਤਿ ਚ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","ਕਿਨ੍ਤੁ ਯੁਸ਼਼੍ਮਾਕੰ ਤਥਾ ਨ ਭਵਿਸ਼਼੍ਯਤਿ, ਯੋ ਯੁਸ਼਼੍ਮਾਕੰ ਸ਼੍ਰੇਸ਼਼੍ਠੋ ਭਵਿਸ਼਼੍ਯਤਿ ਸ ਕਨਿਸ਼਼੍ਠਵਦ੍ ਭਵਤੁ, ਯਸ਼੍ਚ ਮੁਖ੍ਯੋ ਭਵਿਸ਼਼੍ਯਤਿ ਸ ਸੇਵਕਵਦ੍ਭਵਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","ਭੋਜਨੋਪਵਿਸ਼਼੍ਟਪਰਿਚਾਰਕਯੋਃ ਕਃ ਸ਼੍ਰੇਸ਼਼੍ਠਃ? ਯੋ ਭੋਜਨਾਯੋਪਵਿਸ਼ਤਿ ਸ ਕਿੰ ਸ਼੍ਰੇਸ਼਼੍ਠੋ ਨ ਭਵਤਿ? ਕਿਨ੍ਤੁ ਯੁਸ਼਼੍ਮਾਕੰ ਮਧ੍ਯੇ(ਅ)ਹੰ ਪਰਿਚਾਰਕਇਵਾਸ੍ਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","ਅਪਰਞ੍ਚ ਯੁਯੰ ਮਮ ਪਰੀਕ੍ਸ਼਼ਾਕਾਲੇ ਪ੍ਰਥਮਮਾਰਭ੍ਯ ਮਯਾ ਸਹ ਸ੍ਥਿਤਾ ");
INSERT INTO sanpun_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ਏਤਤ੍ਕਾਰਣਾਤ੍ ਪਿਤ੍ਰਾ ਯਥਾ ਮਦਰ੍ਥੰ ਰਾਜ੍ਯਮੇਕੰ ਨਿਰੂਪਿਤੰ ਤਥਾਹਮਪਿ ਯੁਸ਼਼੍ਮਦਰ੍ਥੰ ਰਾਜ੍ਯੰ ਨਿਰੂਪਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ਤਸ੍ਮਾਨ੍ ਮਮ ਰਾਜ੍ਯੇ ਭੋਜਨਾਸਨੇ ਚ ਭੋਜਨਪਾਨੇ ਕਰਿਸ਼਼੍ਯਧ੍ਵੇ ਸਿੰਹਾਸਨੇਸ਼਼ੂਪਵਿਸ਼੍ਯ ਚੇਸ੍ਰਾਯੇਲੀਯਾਨਾਂ ਦ੍ਵਾਦਸ਼ਵੰਸ਼ਾਨਾਂ ਵਿਚਾਰੰ ਕਰਿਸ਼਼੍ਯਧ੍ਵੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","ਅਪਰੰ ਪ੍ਰਭੁਰੁਵਾਚ, ਹੇ ਸ਼ਿਮੋਨ੍ ਪਸ਼੍ਯ ਤਿਤਉਨਾ ਧਾਨ੍ਯਾਨੀਵ ਯੁਸ਼਼੍ਮਾਨ੍ ਸ਼ੈਤਾਨ੍ ਚਾਲਯਿਤੁਮ੍ ਐੱਛਤ੍, ");
INSERT INTO sanpun_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","ਕਿਨ੍ਤੁ ਤਵ ਵਿਸ਼੍ਵਾਸਸ੍ਯ ਲੋਪੋ ਯਥਾ ਨ ਭਵਤਿ ਏਤਤ੍ ਤ੍ਵਦਰ੍ਥੰ ਪ੍ਰਾਰ੍ਥਿਤੰ ਮਯਾ, ਤ੍ਵਨ੍ਮਨਸਿ ਪਰਿਵਰ੍ੱਤਿਤੇ ਚ ਭ੍ਰਾਤ੍ਰੁʼਣਾਂ ਮਨਾਂਸਿ ਸ੍ਥਿਰੀਕੁਰੁ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ਤਦਾ ਸੋਵਦਤ੍, ਹੇ ਪ੍ਰਭੋਹੰ ਤ੍ਵਯਾ ਸਾਰ੍ੱਧੰ ਕਾਰਾਂ ਮ੍ਰੁʼਤਿਞ੍ਚ ਯਾਤੁੰ ਮੱਜਿਤੋਸ੍ਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ਤਤਃ ਸ ਉਵਾਚ, ਹੇ ਪਿਤਰ ਤ੍ਵਾਂ ਵਦਾਮਿ, ਅਦ੍ਯ ਕੁੱਕੁਟਰਵਾਤ੍ ਪੂਰ੍ੱਵੰ ਤ੍ਵੰ ਮਤ੍ਪਰਿਚਯੰ ਵਾਰਤ੍ਰਯਮ੍ ਅਪਹ੍ਵੋਸ਼਼੍ਯਸੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ਅਪਰੰ ਸ ਪਪ੍ਰੱਛ, ਯਦਾ ਮੁਦ੍ਰਾਸਮ੍ਪੁਟੰ ਖਾਦ੍ਯਪਾਤ੍ਰੰ ਪਾਦੁਕਾਞ੍ਚ ਵਿਨਾ ਯੁਸ਼਼੍ਮਾਨ੍ ਪ੍ਰਾਹਿਣਵੰ ਤਦਾ ਯੁਸ਼਼੍ਮਾਕੰ ਕਸ੍ਯਾਪਿ ਨ੍ਯੂਨਤਾਸੀਤ੍? ਤੇ ਪ੍ਰੋਚੁਃ ਕਸ੍ਯਾਪਿ ਨ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ਤਦਾ ਸੋਵਦਤ੍ ਕਿਨ੍ਤ੍ਵਿਦਾਨੀਂ ਮੁਦ੍ਰਾਸਮ੍ਪੁਟੰ ਖਾਦ੍ਯਪਾਤ੍ਰੰ ਵਾ ਯਸ੍ਯਾਸ੍ਤਿ ਤੇਨ ਤਦ੍ਗ੍ਰਹੀਤਵ੍ਯੰ, ਯਸ੍ਯ ਚ ਕ੍ਰੁʼਪਾਣੋे ਨਾਸ੍ਤਿ ਤੇਨ ਸ੍ਵਵਸ੍ਤ੍ਰੰ ਵਿਕ੍ਰੀਯ ਸ ਕ੍ਰੇਤਵ੍ਯਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","ਯਤੋ ਯੁਸ਼਼੍ਮਾਨਹੰ ਵਦਾਮਿ, ਅਪਰਾਧਿਜਨੈਃ ਸਾਰ੍ੱਧੰ ਗਣਿਤਃ ਸ ਭਵਿਸ਼਼੍ਯਤਿ| ਇਦੰ ਯੱਛਾਸ੍ਤ੍ਰੀਯੰ ਵਚਨੰ ਲਿਖਿਤਮਸ੍ਤਿ ਤਨ੍ਮਯਿ ਫਲਿਸ਼਼੍ਯਤਿ ਯਤੋ ਮਮ ਸਮ੍ਬਨ੍ਧੀਯੰ ਸਰ੍ੱਵੰ ਸੇਤ੍ਸ੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","ਤਦਾ ਤੇ ਪ੍ਰੋਚੁਃ ਪ੍ਰਭੋ ਪਸ਼੍ਯ ਇਮੌ ਕ੍ਰੁʼਪਾਣੌ| ਤਤਃ ਸੋਵਦਦ੍ ਏਤੌ ਯਥੇਸ਼਼੍ਟੌ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","ਅਥ ਸ ਤਸ੍ਮਾਦ੍ਵਹਿ ਰ੍ਗਤ੍ਵਾ ਸ੍ਵਾਚਾਰਾਨੁਸਾਰੇਣ ਜੈਤੁਨਨਾਮਾਦ੍ਰਿੰ ਜਗਾਮ ਸ਼ਿਸ਼਼੍ਯਾਸ਼੍ਚ ਤਤ੍ਪਸ਼੍ਚਾਦ੍ ਯਯੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ਤਤ੍ਰੋਪਸ੍ਥਾਯ ਸ ਤਾਨੁਵਾਚ, ਯਥਾ ਪਰੀਕ੍ਸ਼਼ਾਯਾਂ ਨ ਪਤਥ ਤਦਰ੍ਥੰ ਪ੍ਰਾਰ੍ਥਯਧ੍ਵੰ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ਪਸ਼੍ਚਾਤ੍ ਸ ਤਸ੍ਮਾਦ੍ ਏਕਸ਼ਰਕ੍ਸ਼਼ੇਪਾਦ੍ ਬਹਿ ਰ੍ਗਤ੍ਵਾ ਜਾਨੁਨੀ ਪਾਤਯਿਤ੍ਵਾ ਏਤਤ੍ ਪ੍ਰਾਰ੍ਥਯਾਞ੍ਚਕ੍ਰੇ, ");
INSERT INTO sanpun_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ਹੇ ਪਿਤ ਰ੍ਯਦਿ ਭਵਾਨ੍ ਸੰਮਨ੍ਯਤੇ ਤਰ੍ਹਿ ਕੰਸਮੇਨੰ ਮਮਾਨ੍ਤਿਕਾਦ੍ ਦੂਰਯ ਕਿਨ੍ਤੁ ਮਦਿੱਛਾਨੁਰੂਪੰ ਨ ਤ੍ਵਦਿੱਛਾਨੁਰੂਪੰ ਭਵਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ਤਦਾ ਤਸ੍ਮੈ ਸ਼ਕ੍ਤਿੰ ਦਾਤੁੰ ਸ੍ਵਰ੍ਗੀਯਦੂਤੋ ਦਰ੍ਸ਼ਨੰ ਦਦੌ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ਪਸ਼੍ਚਾਤ੍ ਸੋਤ੍ਯਨ੍ਤੰ ਯਾਤਨਯਾ ਵ੍ਯਾਕੁਲੋ ਭੂਤ੍ਵਾ ਪੁਨਰ੍ਦ੍ਰੁʼਢੰ ਪ੍ਰਾਰ੍ਥਯਾਞ੍ਚਕ੍ਰੇ, ਤਸ੍ਮਾਦ੍ ਬ੍ਰੁʼਹੱਛੋਣਿਤਬਿਨ੍ਦਵ ਇਵ ਤਸ੍ਯ ਸ੍ਵੇਦਬਿਨ੍ਦਵਃ ਪ੍ਰੁʼਥਿਵ੍ਯਾਂ ਪਤਿਤੁਮਾਰੇਭਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","ਅਥ ਪ੍ਰਾਰ੍ਥਨਾਤ ਉੱਥਾਯ ਸ਼ਿਸ਼਼੍ਯਾਣਾਂ ਸਮੀਪਮੇਤ੍ਯ ਤਾਨ੍ ਮਨੋਦੁਃਖਿਨੋ ਨਿਦ੍ਰਿਤਾਨ੍ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾਵਦਤ੍ ");
INSERT INTO sanpun_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ਕੁਤੋ ਨਿਦ੍ਰਾਥ? ਪਰੀਕ੍ਸ਼਼ਾਯਾਮ੍ ਅਪਤਨਾਰ੍ਥੰ ਪ੍ਰਰ੍ਥਯਧ੍ਵੰ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ਏਤਤ੍ਕਥਾਯਾਃ ਕਥਨਕਾਲੇ ਦ੍ਵਾਦਸ਼ਸ਼ਿਸ਼਼੍ਯਾਣਾਂ ਮਧ੍ਯੇ ਗਣਿਤੋ ਯਿਹੂਦਾਨਾਮਾ ਜਨਤਾਸਹਿਤਸ੍ਤੇਸ਼਼ਾਮ੍ ਅਗ੍ਰੇ ਚਲਿਤ੍ਵਾ ਯੀਸ਼ੋਸ਼੍ਚੁਮ੍ਬਨਾਰ੍ਥੰ ਤਦਨ੍ਤਿਕਮ੍ ਆਯਯੌ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ਤਦਾ ਯੀਸ਼ੁਰੁਵਾਚ, ਹੇ ਯਿਹੂਦਾ ਕਿੰ ਚੁਮ੍ਬਨੇਨ ਮਨੁਸ਼਼੍ਯਪੁਤ੍ਰੰ ਪਰਕਰੇਸ਼਼ੁ ਸਮਰ੍ਪਯਸਿ? ");
INSERT INTO sanpun_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ਤਦਾ ਯਦ੍ਯਦ੍ ਘਟਿਸ਼਼੍ਯਤੇ ਤਦਨੁਮਾਯ ਸਙ੍ਗਿਭਿਰੁਕ੍ਤੰ, ਹੇ ਪ੍ਰਭੋ ਵਯੰ ਕਿ ਖਙ੍ਗੇਨ ਘਾਤਯਿਸ਼਼੍ਯਾਮਃ? ");
INSERT INTO sanpun_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ਤਤ ਏਕਃ ਕਰਵਾਲੇਨਾਹਤ੍ਯ ਪ੍ਰਧਾਨਯਾਜਕਸ੍ਯ ਦਾਸਸ੍ਯ ਦਕ੍ਸ਼਼ਿਣੰ ਕਰ੍ਣੰ ਚਿੱਛੇਦ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","ਅਧੂਨਾ ਨਿਵਰ੍ੱਤਸ੍ਵ ਇਤ੍ਯੁਕ੍ਤ੍ਵਾ ਯੀਸ਼ੁਸ੍ਤਸ੍ਯ ਸ਼੍ਰੁਤਿੰ ਸ੍ਪ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਸ੍ਵਸ੍ਯੰ ਚਕਾਰ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ਪਸ਼੍ਚਾਦ੍ ਯੀਸ਼ੁਃ ਸਮੀਪਸ੍ਥਾਨ੍ ਪ੍ਰਧਾਨਯਾਜਕਾਨ੍ ਮਨ੍ਦਿਰਸ੍ਯ ਸੇਨਾਪਤੀਨ੍ ਪ੍ਰਾਚੀਨਾਂਸ਼੍ਚ ਜਗਾਦ, ਯੂਯੰ ਕ੍ਰੁʼਪਾਣਾਨ੍ ਯਸ਼਼੍ਟੀਂਸ਼੍ਚ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਮਾਂ ਕਿੰ ਚੋਰੰ ਧਰ੍ੱਤੁਮਾਯਾਤਾਃ? ");
INSERT INTO sanpun_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ਯਦਾਹੰ ਯੁਸ਼਼੍ਮਾਭਿਃ ਸਹ ਪ੍ਰਤਿਦਿਨੰ ਮਨ੍ਦਿਰੇ(ਅ)ਤਿਸ਼਼੍ਠੰ ਤਦਾ ਮਾਂ ਧਰ੍ੱਤੰ ਨ ਪ੍ਰਵ੍ਰੁʼੱਤਾਃ, ਕਿਨ੍ਤ੍ਵਿਦਾਨੀਂ ਯੁਸ਼਼੍ਮਾਕੰ ਸਮਯੋਨ੍ਧਕਾਰਸ੍ਯ ਚਾਧਿਪਤ੍ਯਮਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","ਅਥ ਤੇ ਤੰ ਧ੍ਰੁʼਤ੍ਵਾ ਮਹਾਯਾਜਕਸ੍ਯ ਨਿਵੇਸ਼ਨੰ ਨਿਨ੍ਯੁਃ| ਤਤਃ ਪਿਤਰੋ ਦੂਰੇ ਦੂਰੇ ਪਸ਼੍ਚਾਦਿਤ੍ਵਾ ");
INSERT INTO sanpun_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","ਬ੍ਰੁʼਹਤ੍ਕੋਸ਼਼੍ਠਸ੍ਯ ਮਧ੍ਯੇ ਯਤ੍ਰਾਗ੍ਨਿੰ ਜ੍ਵਾਲਯਿਤ੍ਵਾ ਲੋਕਾਃ ਸਮੇਤ੍ਯੋਪਵਿਸ਼਼੍ਟਾਸ੍ਤਤ੍ਰ ਤੈਃ ਸਾਰ੍ੱਧਮ੍ ਉਪਵਿਵੇਸ਼| ");
INSERT INTO sanpun_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ਅਥ ਵਹ੍ਨਿਸੰਨਿਧੌ ਸਮੁਪਵੇਸ਼ਕਾਲੇ ਕਾਚਿੱਦਾਸੀ ਮਨੋ ਨਿਵਿਸ਼੍ਯ ਤੰ ਨਿਰੀਕ੍ਸ਼਼੍ਯਾਵਦਤ੍ ਪੁਮਾਨਯੰ ਤਸ੍ਯ ਸਙ੍ਗੇ(ਅ)ਸ੍ਥਾਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","ਕਿਨ੍ਤੁ ਸ ਤਦ੍ ਅਪਹ੍ਨੁਤ੍ਯਾਵਾਦੀਤ੍ ਹੇ ਨਾਰਿ ਤਮਹੰ ਨ ਪਰਿਚਿਨੋਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ਕ੍ਸ਼਼ਣਾਨ੍ਤਰੇ(ਅ)ਨ੍ਯਜਨਸ੍ਤੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾਬ੍ਰਵੀਤ੍ ਤ੍ਵਮਪਿ ਤੇਸ਼਼ਾਂ ਨਿਕਰਸ੍ਯੈਕਜਨੋਸਿ| ਪਿਤਰਃ ਪ੍ਰਤ੍ਯੁਵਾਚ ਹੇ ਨਰ ਨਾਹਮਸ੍ਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ਤਤਃ ਸਾਰ੍ੱਧਦਣ੍ਡਦ੍ਵਯਾਤ੍ ਪਰੰ ਪੁਨਰਨ੍ਯੋ ਜਨੋ ਨਿਸ਼੍ਚਿਤ੍ਯ ਬਭਾਸ਼਼ੇ, ਏਸ਼਼ ਤਸ੍ਯ ਸਙ੍ਗੀਤਿ ਸਤ੍ਯੰ ਯਤੋਯੰ ਗਾਲੀਲੀਯੋ ਲੋਕਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","ਤਦਾ ਪਿਤਰ ਉਵਾਚ ਹੇ ਨਰ ਤ੍ਵੰ ਯਦ੍ ਵਦਮਿ ਤਦਹੰ ਬੋੱਧੁੰ ਨ ਸ਼ਕ੍ਨੋਮਿ, ਇਤਿ ਵਾਕ੍ਯੇ ਕਥਿਤਮਾਤ੍ਰੇ ਕੁੱਕੁਟੋ ਰੁਰਾਵ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ਤਦਾ ਪ੍ਰਭੁਣਾ ਵ੍ਯਾਧੁਟ੍ਯ ਪਿਤਰੇ ਨਿਰੀਕ੍ਸ਼਼ਿਤੇ ਕ੍ਰੁʼਕਵਾਕੁਰਵਾਤ੍ ਪੂਰ੍ੱਵੰ ਮਾਂ ਤ੍ਰਿਰਪਹ੍ਨੋਸ਼਼੍ਯਸੇ ਇਤਿ ਪੂਰ੍ੱਵੋਕ੍ਤੰ ਤਸ੍ਯ ਵਾਕ੍ਯੰ ਪਿਤਰਃ ਸ੍ਮ੍ਰੁʼਤ੍ਵਾ ");
INSERT INTO sanpun_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ਬਹਿਰ੍ਗਤ੍ਵਾ ਮਹਾਖੇਦੇਨ ਚਕ੍ਰਨ੍ਦ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","ਤਦਾ ਯੈ ਰ੍ਯੀਸ਼ੁਰ੍ਧ੍ਰੁʼਤਸ੍ਤੇ ਤਮੁਪਹਸ੍ਯ ਪ੍ਰਹਰ੍ੱਤੁਮਾਰੇਭਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ਵਸ੍ਤ੍ਰੇਣ ਤਸ੍ਯ ਦ੍ਰੁʼਸ਼ੌ ਬੱਧ੍ਵਾ ਕਪੋਲੇ ਚਪੇਟਾਘਾਤੰ ਕ੍ਰੁʼਤ੍ਵਾ ਪਪ੍ਰੱਛੁਃ, ਕਸ੍ਤੇ ਕਪੋਲੇ ਚਪੇਟਾਘਾਤੰ ਕ੍ਰੁʼਤਵਾਨ? ਗਣਯਿਤ੍ਵਾ ਤਦ੍ ਵਦ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ਤਦਨ੍ਯਤ੍ ਤਦ੍ਵਿਰੁੱਧੰ ਬਹੁਨਿਨ੍ਦਾਵਾਕ੍ਯੰ ਵਕ੍ਤੁਮਾਰੇਭਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","ਅਥ ਪ੍ਰਭਾਤੇ ਸਤਿ ਲੋਕਪ੍ਰਾਞ੍ਚਃ ਪ੍ਰਧਾਨਯਾਜਕਾ ਅਧ੍ਯਾਪਕਾਸ਼੍ਚ ਸਭਾਂ ਕ੍ਰੁʼਤ੍ਵਾ ਮਧ੍ਯੇਸਭੰ ਯੀਸ਼ੁਮਾਨੀਯ ਪਪ੍ਰੱਛੁਃ, ਤ੍ਵਮ੍ ਅਭਿਸ਼਼ਿਕਤੋਸਿ ਨ ਵਾਸ੍ਮਾਨ੍ ਵਦ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ਸ ਪ੍ਰਤ੍ਯੁਵਾਚ, ਮਯਾ ਤਸ੍ਮਿੰਨੁਕ੍ਤੇ(ਅ)ਪਿ ਯੂਯੰ ਨ ਵਿਸ਼੍ਵਸਿਸ਼਼੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ਕਸ੍ਮਿੰਸ਼੍ਚਿਦ੍ਵਾਕ੍ਯੇ ਯੁਸ਼਼੍ਮਾਨ੍ ਪ੍ਰੁʼਸ਼਼੍ਟੇ(ਅ)ਪਿ ਮਾਂ ਨ ਤਦੁੱਤਰੰ ਵਕ੍ਸ਼਼੍ਯਥ ਨ ਮਾਂ ਤ੍ਯਕ੍ਸ਼਼੍ਯਥ ਚ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","ਕਿਨ੍ਤ੍ਵਿਤਃ ਪਰੰ ਮਨੁਜਸੁਤਃ ਸਰ੍ੱਵਸ਼ਕ੍ਤਿਮਤ ਈਸ਼੍ਵਰਸ੍ਯ ਦਕ੍ਸ਼਼ਿਣੇ ਪਾਰ੍ਸ਼੍ਵੇ ਸਮੁਪਵੇਕ੍ਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ਤਤਸ੍ਤੇ ਪਪ੍ਰੱਛੁਃ, ਰ੍ਤਿਹ ਤ੍ਵਮੀਸ਼੍ਵਰਸ੍ਯ ਪੁਤ੍ਰਃ? ਸ ਕਥਯਾਮਾਸ, ਯੂਯੰ ਯਥਾਰ੍ਥੰ ਵਦਥ ਸ ਏਵਾਹੰ| ");
INSERT INTO sanpun_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ਤਦਾ ਤੇ ਸਰ੍ੱਵੇ ਕਥਯਾਮਾਸੁਃ, ਰ੍ਤਿਹ ਸਾਕ੍ਸ਼਼੍ਯੇ(ਅ)ਨ੍ਸਸ੍ਮਿਨ੍ ਅਸ੍ਮਾਕੰ ਕਿੰ ਪ੍ਰਯੋਜਨੰ? ਅਸ੍ਯ ਸ੍ਵਮੁਖਾਦੇਵ ਸਾਕ੍ਸ਼਼੍ਯੰ ਪ੍ਰਾਪ੍ਤਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ਤਤਃ ਸਭਾਸ੍ਥਾਃ ਸਰ੍ੱਵਲੋਕਾ ਉੱਥਾਯ ਤੰ ਪੀਲਾਤਸੰਮੁਖੰ ਨੀਤ੍ਵਾਪ੍ਰੋਦ੍ਯ ਵਕ੍ਤੁਮਾਰੇਭਿਰੇ, ");
INSERT INTO sanpun_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ਸ੍ਵਮਭਿਸ਼਼ਿਕ੍ਤੰ ਰਾਜਾਨੰ ਵਦਨ੍ਤੰ ਕੈਮਰਰਾਜਾਯ ਕਰਦਾਨੰ ਨਿਸ਼਼ੇਧਨ੍ਤੰ ਰਾਜ੍ਯਵਿਪਰ੍ੱਯਯੰ ਕੁਰ੍ੱਤੁੰ ਪ੍ਰਵਰ੍ੱਤਮਾਨਮ੍ ਏਨ ਪ੍ਰਾਪ੍ਤਾ ਵਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ਤਦਾ ਪੀਲਾਤਸ੍ਤੰ ਪ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍ ਤ੍ਵੰ ਕਿੰ ਯਿਹੂਦੀਯਾਨਾਂ ਰਾਜਾ? ਸ ਪ੍ਰਤ੍ਯੁਵਾਚ ਤ੍ਵੰ ਸਤ੍ਯਮੁਕ੍ਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ਤਦਾ ਪੀਲਾਤਃ ਪ੍ਰਧਾਨਯਾਜਕਾਦਿਲੋਕਾਨ੍ ਜਗਾਦ੍, ਅਹਮੇਤਸ੍ਯ ਕਮਪ੍ਯਪਰਾਧੰ ਨਾਪ੍ਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","ਤਤਸ੍ਤੇ ਪੁਨਃ ਸਾਹਮਿਨੋ ਭੂਤ੍ਵਾਵਦਨ੍, ਏਸ਼਼ ਗਾਲੀਲ ਏਤਤ੍ਸ੍ਥਾਨਪਰ੍ੱਯਨ੍ਤੇ ਸਰ੍ੱਵਸ੍ਮਿਨ੍ ਯਿਹੂਦਾਦੇਸ਼ੇ ਸਰ੍ੱਵਾੱਲੋਕਾਨੁਪਦਿਸ਼੍ਯ ਕੁਪ੍ਰਵ੍ਰੁʼੱਤਿੰ ਗ੍ਰਾਹੀਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ਤਦਾ ਪੀਲਾਤੋ ਗਾਲੀਲਪ੍ਰਦੇਸ਼ਸ੍ਯ ਨਾਮ ਸ਼੍ਰੁਤ੍ਵਾ ਪਪ੍ਰੱਛ, ਕਿਮਯੰ ਗਾਲੀਲੀਯੋ ਲੋਕਃ? ");
INSERT INTO sanpun_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ਤਤਃ ਸ ਗਾਲੀਲ੍ਪ੍ਰਦੇਸ਼ੀਯਹੇਰੋਦ੍ਰਾਜਸ੍ਯ ਤਦਾ ਸ੍ਥਿਤੇਸ੍ਤਸ੍ਯ ਸਮੀਪੇ ਯੀਸ਼ੁੰ ਪ੍ਰੇਸ਼਼ਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ਤਦਾ ਹੇਰੋਦ੍ ਯੀਸ਼ੁੰ ਵਿਲੋਕ੍ਯ ਸਨ੍ਤੁਤੋਸ਼਼, ਯਤਃ ਸ ਤਸ੍ਯ ਬਹੁਵ੍ਰੁʼੱਤਾਨ੍ਤਸ਼੍ਰਵਣਾਤ੍ ਤਸ੍ਯ ਕਿਞਿ्ਚਦਾਸ਼੍ਚਰ੍ੱਯਕਰ੍ੰਮ ਪਸ਼੍ਯਤਿ ਇਤ੍ਯਾਸ਼ਾਂ ਕ੍ਰੁʼਤ੍ਵਾ ਬਹੁਕਾਲਮਾਰਭ੍ਯ ਤੰ ਦ੍ਰਸ਼਼੍ਟੁੰ ਪ੍ਰਯਾਸੰ ਕ੍ਰੁʼਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ਤਸ੍ਮਾਤ੍ ਤੰ ਬਹੁਕਥਾਃ ਪਪ੍ਰੱਛ ਕਿਨ੍ਤੁ ਸ ਤਸ੍ਯ ਕਸ੍ਯਾਪਿ ਵਾਕ੍ਯਸ੍ਯ ਪ੍ਰਤ੍ਯੁੱਤਰੰ ਨੋਵਾਚ| ");
INSERT INTO sanpun_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","ਅਥ ਪ੍ਰਧਾਨਯਾਜਕਾ ਅਧ੍ਯਾਪਕਾਸ਼੍ਚ ਪ੍ਰੋੱਤਿਸ਼਼੍ਠਨ੍ਤਃ ਸਾਹਸੇਨ ਤਮਪਵਦਿਤੁੰ ਪ੍ਰਾਰੇਭਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ਹੇਰੋਦ੍ ਤਸ੍ਯ ਸੇਨਾਗਣਸ਼੍ਚ ਤਮਵਜ੍ਞਾਯ ਉਪਹਾਸਤ੍ਵੇਨ ਰਾਜਵਸ੍ਤ੍ਰੰ ਪਰਿਧਾਪ੍ਯ ਪੁਨਃ ਪੀਲਾਤੰ ਪ੍ਰਤਿ ਤੰ ਪ੍ਰਾਹਿਣੋਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ਪੂਰ੍ੱਵੰ ਹੇਰੋਦ੍ਪੀਲਾਤਯੋਃ ਪਰਸ੍ਪਰੰ ਵੈਰਭਾਵ ਆਸੀਤ੍ ਕਿਨ੍ਤੁ ਤੱਦਿਨੇ ਦ੍ਵਯੋ ਰ੍ਮੇਲਨੰ ਜਾਤਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","ਪਸ਼੍ਚਾਤ੍ ਪੀਲਾਤਃ ਪ੍ਰਧਾਨਯਾਜਕਾਨ੍ ਸ਼ਾਸਕਾਨ੍ ਲੋਕਾਂਸ਼੍ਚ ਯੁਗਪਦਾਹੂਯ ਬਭਾਸ਼਼ੇ, ");
INSERT INTO sanpun_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ਰਾਜ੍ਯਵਿਪਰ੍ੱਯਯਕਾਰਕੋਯਮ੍ ਇਤ੍ਯੁਕ੍ਤ੍ਵਾ ਮਨੁਸ਼਼੍ਯਮੇਨੰ ਮਮ ਨਿਕਟਮਾਨੈਸ਼਼੍ਟ ਕਿਨ੍ਤੁ ਪਸ਼੍ਯਤ ਯੁਸ਼਼੍ਮਾਕੰ ਸਮਕ੍ਸ਼਼ਮ੍ ਅਸ੍ਯ ਵਿਚਾਰੰ ਕ੍ਰੁʼਤ੍ਵਾਪਿ ਪ੍ਰੋਕ੍ਤਾਪਵਾਦਾਨੁਰੂਪੇਣਾਸ੍ਯ ਕੋਪ੍ਯਪਰਾਧਃ ਸਪ੍ਰਮਾਣੋ ਨ ਜਾਤਃ, ");
INSERT INTO sanpun_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ਯੂਯਞ੍ਚ ਹੇਰੋਦਃ ਸੰਨਿਧੌ ਪ੍ਰੇਸ਼਼ਿਤਾ ਮਯਾ ਤਤ੍ਰਾਸ੍ਯ ਕੋਪ੍ਯਪਰਾਧਸ੍ਤੇਨਾਪਿ ਨ ਪ੍ਰਾਪ੍ਤਃ| ਪਸ਼੍ਯਤਾਨੇਨ ਵਧਹੇेਤੁਕੰ ਕਿਮਪਿ ਨਾਪਰਾੱਧੰ| ");
INSERT INTO sanpun_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","ਤਸ੍ਮਾਦੇਨੰ ਤਾਡਯਿਤ੍ਵਾ ਵਿਹਾਸ੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","ਤਤ੍ਰੋਤ੍ਸਵੇ ਤੇਸ਼਼ਾਮੇਕੋ ਮੋਚਯਿਤਵ੍ਯਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ਇਤਿ ਹੇਤੋਸ੍ਤੇ ਪ੍ਰੋੱਚੈਰੇਕਦਾ ਪ੍ਰੋਚੁਃ, ਏਨੰ ਦੂਰੀਕ੍ਰੁʼਤ੍ਯ ਬਰੱਬਾਨਾਮਾਨੰ ਮੋਚਯ| ");
INSERT INTO sanpun_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","ਸ ਬਰੱਬਾ ਨਗਰ ਉਪਪ੍ਲਵਵਧਾਪਰਾਧਾਭ੍ਯਾਂ ਕਾਰਾਯਾਂ ਬੱਧ ਆਸੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","ਕਿਨ੍ਤੁ ਪੀਲਾਤੋ ਯੀਸ਼ੁੰ ਮੋਚਯਿਤੁੰ ਵਾਞ੍ਛਨ੍ ਪੁਨਸ੍ਤਾਨੁਵਾਚ| ");
INSERT INTO sanpun_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ਤਥਾਪ੍ਯੇਨੰ ਕ੍ਰੁਸ਼ੇ ਵ੍ਯਧ ਕ੍ਰੁਸ਼ੇ ਵ੍ਯਧੇਤਿ ਵਦਨ੍ਤਸ੍ਤੇ ਰੁਰੁਵੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ਤਤਃ ਸ ਤ੍ਰੁʼਤੀਯਵਾਰੰ ਜਗਾਦ ਕੁਤਃ? ਸ ਕਿੰ ਕਰ੍ੰਮ ਕ੍ਰੁʼਤਵਾਨ੍? ਨਾਹਮਸ੍ਯ ਕਮਪਿ ਵਧਾਪਰਾਧੰ ਪ੍ਰਾਪ੍ਤਃ ਕੇਵਲੰ ਤਾਡਯਿਤ੍ਵਾਮੁੰ ਤ੍ਯਜਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","ਤਥਾਪਿ ਤੇ ਪੁਨਰੇਨੰ ਕ੍ਰੁਸ਼ੇ ਵ੍ਯਧ ਇਤ੍ਯੁਕ੍ਤ੍ਵਾ ਪ੍ਰੋੱਚੈਰ੍ਦ੍ਰੁʼਢੰ ਪ੍ਰਾਰ੍ਥਯਾਞ੍ਚਕ੍ਰਿਰੇ; ");
INSERT INTO sanpun_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ਤਤਃ ਪ੍ਰਧਾਨਯਾਜਕਾਦੀਨਾਂ ਕਲਰਵੇ ਪ੍ਰਬਲੇ ਸਤਿ ਤੇਸ਼਼ਾਂ ਪ੍ਰਾਰ੍ਥਨਾਰੂਪੰ ਕਰ੍ੱਤੁੰ ਪੀਲਾਤ ਆਦਿਦੇਸ਼| ");
INSERT INTO sanpun_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ਰਾਜਦ੍ਰੋਹਵਧਯੋਰਪਰਾਧੇਨ ਕਾਰਾਸ੍ਥੰ ਯੰ ਜਨੰ ਤੇ ਯਯਾਚਿਰੇ ਤੰ ਮੋਚਯਿਤ੍ਵਾ ਯੀਸ਼ੁੰ ਤੇਸ਼਼ਾਮਿੱਛਾਯਾਂ ਸਮਾਰ੍ਪਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","ਅਥ ਤੇ ਯੀਸ਼ੁੰ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਯਾਨ੍ਤਿ, ਏਤਰ੍ਹਿ ਗ੍ਰਾਮਾਦਾਗਤੰ ਸ਼ਿਮੋਨਨਾਮਾਨੰ ਕੁਰੀਣੀਯੰ ਜਨੰ ਧ੍ਰੁʼਤ੍ਵਾ ਯੀਸ਼ੋਃ ਪਸ਼੍ਚਾੰਨੇਤੁੰ ਤਸ੍ਯ ਸ੍ਕਨ੍ਧੇ ਕ੍ਰੁਸ਼ਮਰ੍ਪਯਾਮਾਸੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ਤਤੋ ਲੋाਕਾਰਣ੍ਯਮਧ੍ਯੇ ਬਹੁਸ੍ਤ੍ਰਿਯੋ ਰੁਦਤ੍ਯੋ ਵਿਲਪਨ੍ਤ੍ਯਸ਼੍ਚ ਯੀਸ਼ੋਃ ਪਸ਼੍ਚਾਦ੍ ਯਯੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","ਕਿਨ੍ਤੁ ਸ ਵ੍ਯਾਘੁਟ੍ਯ ਤਾ ਉਵਾਚ, ਹੇ ਯਿਰੂਸ਼ਾਲਮੋ ਨਾਰ੍ੱਯੋ ਯੁਯੰ ਮਦਰ੍ਥੰ ਨ ਰੁਦਿਤ੍ਵਾ ਸ੍ਵਾਰ੍ਥੰ ਸ੍ਵਾਪਤ੍ਯਾਰ੍ਥਞ੍ਚ ਰੁਦਿਤਿ; ");
INSERT INTO sanpun_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ਪਸ਼੍ਯਤ ਯਃ ਕਦਾਪਿ ਗਰ੍ਭਵਤ੍ਯੋ ਨਾਭਵਨ੍ ਸ੍ਤਨ੍ਯਞ੍ਚ ਨਾਪਾਯਯਨ੍ ਤਾਦ੍ਰੁʼਸ਼ੀ ਰ੍ਵਨ੍ਧ੍ਯਾ ਯਦਾ ਧਨ੍ਯਾ ਵਕ੍ਸ਼਼੍ਯਨ੍ਤਿ ਸ ਕਾਲ ਆਯਾਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","ਤਦਾ ਹੇ ਸ਼ੈਲਾ ਅਸ੍ਮਾਕਮੁਪਰਿ ਪਤਤ, ਹੇ ਉਪਸ਼ੈਲਾ ਅਸ੍ਮਾਨਾੱਛਾਦਯਤ ਕਥਾਮੀਦ੍ਰੁʼਸ਼ੀਂ ਲੋਕਾ ਵਕ੍ਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","ਯਤਃ ਸਤੇਜਸਿ ਸ਼ਾਖਿਨਿ ਚੇਦੇਤਦ੍ ਘਟਤੇ ਤਰ੍ਹਿ ਸ਼ੁਸ਼਼੍ਕਸ਼ਾਖਿਨਿ ਕਿੰ ਨ ਘਟਿਸ਼਼੍ਯਤੇ? ");
INSERT INTO sanpun_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ਤਦਾ ਤੇ ਹਨ੍ਤੁੰ ਦ੍ਵਾਵਪਰਾਧਿਨੌ ਤੇਨ ਸਾਰ੍ੱਧੰ ਨਿਨ੍ਯੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","ਅਪਰੰ ਸ਼ਿਰਃਕਪਾਲਨਾਮਕਸ੍ਥਾਨੰ ਪ੍ਰਾਪ੍ਯ ਤੰ ਕ੍ਰੁਸ਼ੇ ਵਿਵਿਧੁਃ; ਤੱਦ੍ਵਯੋਰਪਰਾਧਿਨੋਰੇਕੰ ਤਸ੍ਯ ਦਕ੍ਸ਼਼ਿਣੋ ਤਦਨ੍ਯੰ ਵਾਮੇ ਕ੍ਰੁਸ਼ੇ ਵਿਵਿਧੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ਤਦਾ ਯੀਸ਼ੁਰਕਥਯਤ੍, ਹੇ ਪਿਤਰੇਤਾਨ੍ ਕ੍ਸ਼਼ਮਸ੍ਵ ਯਤ ਏਤੇ ਯਤ੍ ਕਰ੍ੰਮ ਕੁਰ੍ੱਵਨ੍ਤਿ ਤਨ੍ ਨ ਵਿਦੁਃ; ਪਸ਼੍ਚਾੱਤੇ ਗੁਟਿਕਾਪਾਤੰ ਕ੍ਰੁʼਤ੍ਵਾ ਤਸ੍ਯ ਵਸ੍ਤ੍ਰਾਣਿ ਵਿਭਜ੍ਯ ਜਗ੍ਰੁʼਹੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","ਤਤ੍ਰ ਲੋਕਸੰਘਸ੍ਤਿਸ਼਼੍ਠਨ੍ ਦਦਰ੍ਸ਼; ਤੇ ਤੇਸ਼਼ਾਂ ਸ਼ਾਸਕਾਸ਼੍ਚ ਤਮੁਪਹਸ੍ਯ ਜਗਦੁਃ, ਏਸ਼਼ ਇਤਰਾਨ੍ ਰਕ੍ਸ਼਼ਿਤਵਾਨ੍ ਯਦੀਸ਼੍ਵਰੇਣਾਭਿਰੁਚਿਤੋ (ਅ)ਭਿਸ਼਼ਿਕ੍ਤਸ੍ਤ੍ਰਾਤਾ ਭਵਤਿ ਤਰ੍ਹਿ ਸ੍ਵਮਧੁਨਾ ਰਕ੍ਸ਼਼ਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","ਤਦਨ੍ਯਃ ਸੇਨਾਗਣਾ ਏਤ੍ਯ ਤਸ੍ਮੈ ਅਮ੍ਲਰਸੰ ਦਤ੍ਵਾ ਪਰਿਹਸ੍ਯ ਪ੍ਰੋਵਾਚ, ");
INSERT INTO sanpun_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ਚੇੱਤ੍ਵੰ ਯਿਹੂਦੀਯਾਨਾਂ ਰਾਜਾਸਿ ਤਰ੍ਹਿ ਸ੍ਵੰ ਰਕ੍ਸ਼਼| ");
INSERT INTO sanpun_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ਯਿਹੂਦੀਯਾਨਾਂ ਰਾਜੇਤਿ ਵਾਕ੍ਯੰ ਯੂਨਾਨੀਯਰੋਮੀਯੇਬ੍ਰੀਯਾਕ੍ਸ਼਼ਰੈ ਰ੍ਲਿਖਿਤੰ ਤੱਛਿਰਸ ਊਰ੍ੱਧ੍ਵੇ(ਅ)ਸ੍ਥਾਪ੍ਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","ਤਦੋਭਯਪਾਰ੍ਸ਼੍ਵਯੋ ਰ੍ਵਿੱਧੌ ਯਾਵਪਰਾਧਿਨੌ ਤਯੋਰੇਕਸ੍ਤੰ ਵਿਨਿਨ੍ਦ੍ਯ ਬਭਾਸ਼਼ੇ, ਚੇੱਤ੍ਵਮ੍ ਅਭਿਸ਼਼ਿਕ੍ਤੋਸਿ ਤਰ੍ਹਿ ਸ੍ਵਮਾਵਾਞ੍ਚ ਰਕ੍ਸ਼਼| ");
INSERT INTO sanpun_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","ਕਿਨ੍ਤ੍ਵਨ੍ਯਸ੍ਤੰ ਤਰ੍ਜਯਿਤ੍ਵਾਵਦਤ੍, ਈਸ਼੍ਵਰਾੱਤਵ ਕਿਞ੍ਚਿਦਪਿ ਭਯੰ ਨਾਸ੍ਤਿ ਕਿੰ? ਤ੍ਵਮਪਿ ਸਮਾਨਦਣ੍ਡੋਸਿ, ");
INSERT INTO sanpun_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ਯੋਗ੍ਯਪਾਤ੍ਰੇ ਆਵਾਂ ਸ੍ਵਸ੍ਵਕਰ੍ੰਮਣਾਂ ਸਮੁਚਿਤਫਲੰ ਪ੍ਰਾਪ੍ਨੁਵਃ ਕਿਨ੍ਤ੍ਵਨੇਨ ਕਿਮਪਿ ਨਾਪਰਾੱਧੰ| ");
INSERT INTO sanpun_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ਅਥ ਸ ਯੀਸ਼ੁੰ ਜਗਾਦ ਹੇ ਪ੍ਰਭੇ ਭਵਾਨ੍ ਸ੍ਵਰਾਜ੍ਯਪ੍ਰਵੇਸ਼ਕਾਲੇ ਮਾਂ ਸ੍ਮਰਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ਤਦਾ ਯੀਸ਼ੁਃ ਕਥਿਤਵਾਨ੍ ਤ੍ਵਾਂ ਯਥਾਰ੍ਥੰ ਵਦਾਮਿ ਤ੍ਵਮਦ੍ਯੈਵ ਮਯਾ ਸਾਰ੍ੱਧੰ ਪਰਲੋਕਸ੍ਯ ਸੁਖਸ੍ਥਾਨੰ ਪ੍ਰਾਪ੍ਸ੍ਯਸਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","ਅਪਰਞ੍ਚ ਦ੍ਵਿਤੀਯਯਾਮਾਤ੍ ਤ੍ਰੁʼਤੀਯਯਾਮਪਰ੍ੱਯਨ੍ਤੰ ਰਵੇਸ੍ਤੇਜਸੋਨ੍ਤਰ੍ਹਿਤਤ੍ਵਾਤ੍ ਸਰ੍ੱਵਦੇਸ਼ੋ(ਅ)ਨ੍ਧਕਾਰੇਣਾਵ੍ਰੁʼਤੋ ");
INSERT INTO sanpun_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ਮਨ੍ਦਿਰਸ੍ਯ ਯਵਨਿਕਾ ਚ ਛਿਦ੍ਯਮਾਨਾ ਦ੍ਵਿਧਾ ਬਭੂਵ| ");
INSERT INTO sanpun_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ਤਤੋ ਯੀਸ਼ੁਰੁੱਚੈਰੁਵਾਚ, ਹੇ ਪਿਤ ਰ੍ਮਮਾਤ੍ਮਾਨੰ ਤਵ ਕਰੇ ਸਮਰ੍ਪਯੇ, ਇਤ੍ਯੁਕ੍ਤ੍ਵਾ ਸ ਪ੍ਰਾਣਾਨ੍ ਜਹੌ| ");
INSERT INTO sanpun_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ਤਦੈਤਾ ਘਟਨਾ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਸ਼ਤਸੇਨਾਪਤਿਰੀਸ਼੍ਵਰੰ ਧਨ੍ਯਮੁਕ੍ਤ੍ਵਾ ਕਥਿਤਵਾਨ੍ ਅਯੰ ਨਿਤਾਨ੍ਤੰ ਸਾਧੁਮਨੁਸ਼਼੍ਯ ਆਸੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","ਅਥ ਯਾਵਨ੍ਤੋ ਲੋਕਾ ਦ੍ਰਸ਼਼੍ਟੁਮ੍ ਆਗਤਾਸ੍ਤੇ ਤਾ ਘਟਨਾ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਵਕ੍ਸ਼਼ਃਸੁ ਕਰਾਘਾਤੰ ਕ੍ਰੁʼਤ੍ਵਾ ਵ੍ਯਾਚੁਟ੍ਯ ਗਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","ਯੀਸ਼ੋ ਰ੍ਜ੍ਞਾਤਯੋ ਯਾ ਯਾ ਯੋਸ਼਼ਿਤਸ਼੍ਚ ਗਾਲੀਲਸ੍ਤੇਨ ਸਾਰ੍ੱਧਮਾਯਾਤਾਸ੍ਤਾ ਅਪਿ ਦੂਰੇ ਸ੍ਥਿਤ੍ਵਾ ਤਤ੍ ਸਰ੍ੱਵੰ ਦਦ੍ਰੁʼਸ਼ੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","ਤਦਾ ਯਿਹੂਦੀਯਾਨਾਂ ਮਨ੍ਤ੍ਰਣਾਂ ਕ੍ਰਿਯਾਞ੍ਚਾਸੰਮਨ੍ਯਮਾਨ ਈਸ਼੍ਵਰਸ੍ਯ ਰਾਜਤ੍ਵਮ੍ ਅਪੇਕ੍ਸ਼਼ਮਾਣੋ ");
INSERT INTO sanpun_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ਯਿਹੂਦਿਦੇਸ਼ੀਯੋ (ਅ)ਰਿਮਥੀਯਨਗਰੀਯੋ ਯੂਸ਼਼ਫ੍ਨਾਮਾ ਮਨ੍ਤ੍ਰੀ ਭਦ੍ਰੋ ਧਾਰ੍ੰਮਿਕਸ਼੍ਚ ਪੁਮਾਨ੍ ");
INSERT INTO sanpun_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ਪੀਲਾਤਾਨ੍ਤਿਕੰ ਗਤ੍ਵਾ ਯੀਸ਼ੋ ਰ੍ਦੇਹੰ ਯਯਾਚੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ਪਸ਼੍ਚਾਦ੍ ਵਪੁਰਵਰੋਹ੍ਯ ਵਾਸਸਾ ਸੰਵੇਸ਼਼੍ਟ੍ਯ ਯਤ੍ਰ ਕੋਪਿ ਮਾਨੁਸ਼਼ੋ ਨਾਸ੍ਥਾਪ੍ਯਤ ਤਸ੍ਮਿਨ੍ ਸ਼ੈਲੇ ਸ੍ਵਾਤੇ ਸ਼੍ਮਸ਼ਾਨੇ ਤਦਸ੍ਥਾਪਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ਤੱਦਿਨਮਾਯੋਜਨੀਯੰ ਦਿਨੰ ਵਿਸ਼੍ਰਾਮਵਾਰਸ਼੍ਚ ਸਮੀਪਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","ਅਪਰੰ ਯੀਸ਼ੁਨਾ ਸਾਰ੍ੱਧੰ ਗਾਲੀਲ ਆਗਤਾ ਯੋਸ਼਼ਿਤਃ ਪਸ਼੍ਚਾਦਿਤ੍ਵਾ ਸ਼੍ਮਸ਼ਾਨੇ ਤਤ੍ਰ ਯਥਾ ਵਪੁਃ ਸ੍ਥਾਪਿਤੰ ਤੱਚ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ");
INSERT INTO sanpun_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ਵ੍ਯਾਘੁਟ੍ਯ ਸੁਗਨ੍ਧਿਦ੍ਰਵ੍ਯਤੈਲਾਨਿ ਕ੍ਰੁʼਤ੍ਵਾ ਵਿਧਿਵਦ੍ ਵਿਸ਼੍ਰਾਮਵਾਰੇ ਵਿਸ਼੍ਰਾਮੰ ਚਕ੍ਰੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","ਅਥ ਸਪ੍ਤਾਹਪ੍ਰਥਮਦਿਨੇ(ਅ)ਤਿਪ੍ਰਤ੍ਯੂਸ਼਼ੇ ਤਾ ਯੋਸ਼਼ਿਤਃ ਸਮ੍ਪਾਦਿਤੰ ਸੁਗਨ੍ਧਿਦ੍ਰਵ੍ਯੰ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਤਦਨ੍ਯਾਭਿਃ ਕਿਯਤੀਭਿਃ ਸ੍ਤ੍ਰੀਭਿਃ ਸਹ ਸ਼੍ਮਸ਼ਾਨੰ ਯਯੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","ਕਿਨ੍ਤੁ ਸ਼੍ਮਸ਼ਾਨਦ੍ਵਾਰਾਤ੍ ਪਾਸ਼਼ਾਣਮਪਸਾਰਿਤੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ");
INSERT INTO sanpun_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ਤਾਃ ਪ੍ਰਵਿਸ਼੍ਯ ਪ੍ਰਭੋ ਰ੍ਦੇਹਮਪ੍ਰਾਪ੍ਯ ");
INSERT INTO sanpun_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ਵ੍ਯਾਕੁਲਾ ਭਵਨ੍ਤਿ ਏਤਰ੍ਹਿ ਤੇਜੋਮਯਵਸ੍ਤ੍ਰਾਨ੍ਵਿਤੌ ਦ੍ਵੌ ਪੁਰੁਸ਼਼ੌ ਤਾਸਾਂ ਸਮੀਪੇ ਸਮੁਪਸ੍ਥਿਤੌ ");
INSERT INTO sanpun_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ਤਸ੍ਮਾੱਤਾਃ ਸ਼ਙ੍ਕਾਯੁਕ੍ਤਾ ਭੂਮਾਵਧੋਮੁਖ੍ਯਸ੍ਯਸ੍ਥੁਃ| ਤਦਾ ਤੌ ਤਾ ਊਚਤੁ ਰ੍ਮ੍ਰੁʼਤਾਨਾਂ ਮਧ੍ਯੇ ਜੀਵਨ੍ਤੰ ਕੁਤੋ ਮ੍ਰੁʼਗਯਥ? ");
INSERT INTO sanpun_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","ਸੋਤ੍ਰ ਨਾਸ੍ਤਿ ਸ ਉਦਸ੍ਥਾਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ਪਾਪਿਨਾਂ ਕਰੇਸ਼਼ੁ ਸਮਰ੍ਪਿਤੇਨ ਕ੍ਰੁਸ਼ੇ ਹਤੇਨ ਚ ਮਨੁਸ਼਼੍ਯਪੁਤ੍ਰੇਣ ਤ੍ਰੁʼਤੀਯਦਿਵਸੇ ਸ਼੍ਮਸ਼ਾਨਾਦੁੱਥਾਤਵ੍ਯਮ੍ ਇਤਿ ਕਥਾਂ ਸ ਗਲੀਲਿ ਤਿਸ਼਼੍ਠਨ੍ ਯੁਸ਼਼੍ਮਭ੍ਯੰ ਕਥਿਤਵਾਨ੍ ਤਾਂ ਸ੍ਮਰਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","ਤਦਾ ਤਸ੍ਯ ਸਾ ਕਥਾ ਤਾਸਾਂ ਮਨਃਸੁ ਜਾਤਾ| ");
INSERT INTO sanpun_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ਅਨਨ੍ਤਰੰ ਸ਼੍ਮਸ਼ਾਨਾਦ੍ ਗਤ੍ਵਾ ਤਾ ਏਕਾਦਸ਼ਸ਼ਿਸ਼਼੍ਯਾਦਿਭ੍ਯਃ ਸਰ੍ੱਵੇਭ੍ਯਸ੍ਤਾਂ ਵਾਰ੍ੱਤਾਂ ਕਥਯਾਮਾਸੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","ਮਗ੍ਦਲੀਨੀਮਰਿਯਮ੍, ਯੋਹਨਾ, ਯਾਕੂਬੋ ਮਾਤਾ ਮਰਿਯਮ੍ ਤਦਨ੍ਯਾਃ ਸਙ੍ਗਿਨ੍ਯੋ ਯੋਸ਼਼ਿਤਸ਼੍ਚ ਪ੍ਰੇਰਿਤੇਭ੍ਯ ਏਤਾਃ ਸਰ੍ੱਵਾ ਵਾਰ੍ੱਤਾਃ ਕਥਯਾਮਾਸੁਃ ");
INSERT INTO sanpun_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ਕਿਨ੍ਤੁ ਤਾਸਾਂ ਕਥਾਮ੍ ਅਨਰ੍ਥਕਾਖ੍ਯਾਨਮਾਤ੍ਰੰ ਬੁੱਧ੍ਵਾ ਕੋਪਿ ਨ ਪ੍ਰਤ੍ਯੈਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","ਤਦਾ ਪਿਤਰ ਉੱਥਾਯ ਸ਼੍ਮਸ਼ਾਨਾਨ੍ਤਿਕੰ ਦਧਾਵ, ਤਤ੍ਰ ਚ ਪ੍ਰਹ੍ਵੋ ਭੂਤ੍ਵਾ ਪਾਰ੍ਸ਼੍ਵੈਕਸ੍ਥਾਪਿਤੰ ਕੇਵਲੰ ਵਸ੍ਤ੍ਰੰ ਦਦਰ੍ਸ਼; ਤਸ੍ਮਾਦਾਸ਼੍ਚਰ੍ੱਯੰ ਮਨ੍ਯਮਾਨੋ ਯਦਘਟਤ ਤਨ੍ਮਨਸਿ ਵਿਚਾਰਯਨ੍ ਪ੍ਰਤਸ੍ਥੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","ਤਸ੍ਮਿੰਨੇਵ ਦਿਨੇ ਦ੍ਵੌ ਸ਼ਿੱਯੌ ਯਿਰੂਸ਼ਾਲਮਸ਼੍ਚਤੁਸ਼਼੍ਕ੍ਰੋਸ਼ਾਨ੍ਤਰਿਤਮ੍ ਇੰਮਾਯੁਗ੍ਰਾਮੰ ਗੱਛਨ੍ਤੌ ");
INSERT INTO sanpun_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ਤਾਸਾਂ ਘਟਨਾਨਾਂ ਕਥਾਮਕਥਯਤਾਂ ");
INSERT INTO sanpun_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ਤਯੋਰਾਲਾਪਵਿਚਾਰਯੋਃ ਕਾਲੇ ਯੀਸ਼ੁਰਾਗਤ੍ਯ ਤਾਭ੍ਯਾਂ ਸਹ ਜਗਾਮ ");
INSERT INTO sanpun_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ਕਿਨ੍ਤੁ ਯਥਾ ਤੌ ਤੰ ਨ ਪਰਿਚਿਨੁਤਸ੍ਤਦਰ੍ਥੰ ਤਯੋ ਰ੍ਦ੍ਰੁʼਸ਼਼੍ਟਿਃ ਸੰਰੁੱਧਾ| ");
INSERT INTO sanpun_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ਸ ਤੌ ਪ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍ ਯੁਵਾਂ ਵਿਸ਼਼ੱਣੌ ਕਿੰ ਵਿਚਾਰਯਨ੍ਤੌ ਗੱਛਥਃ? ");
INSERT INTO sanpun_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ਤਤਸ੍ਤਯੋਃ ਕ੍ਲਿਯਪਾਨਾਮਾ ਪ੍ਰਤ੍ਯੁਵਾਚ ਯਿਰੂਸ਼ਾਲਮਪੁਰੇ(ਅ)ਧੁਨਾ ਯਾਨ੍ਯਘਟਨ੍ਤ ਤ੍ਵੰ ਕੇਵਲਵਿਦੇਸ਼ੀ ਕਿੰ ਤਦ੍ਵ੍ਰੁʼੱਤਾਨ੍ਤੰ ਨ ਜਾਨਾਸਿ? ");
INSERT INTO sanpun_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ਸ ਪਪ੍ਰੱਛ ਕਾ ਘਟਨਾਃ? ਤਦਾ ਤੌ ਵਕ੍ਤੁਮਾਰੇਭਾਤੇ ਯੀਸ਼ੁਨਾਮਾ ਯੋ ਨਾਸਰਤੀਯੋ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦੀ ਈਸ਼੍ਵਰਸ੍ਯ ਮਾਨੁਸ਼਼ਾਣਾਞ੍ਚ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਵਾਕ੍ਯੇ ਕਰ੍ੰਮਣਿ ਚ ਸ਼ਕ੍ਤਿਮਾਨਾਸੀਤ੍ ");
INSERT INTO sanpun_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ਤਮ੍ ਅਸ੍ਮਾਕੰ ਪ੍ਰਧਾਨਯਾਜਕਾ ਵਿਚਾਰਕਾਸ਼੍ਚ ਕੇਨਾਪਿ ਪ੍ਰਕਾਰੇਣ ਕ੍ਰੁਸ਼ੇ ਵਿੱਧ੍ਵਾ ਤਸ੍ਯ ਪ੍ਰਾਣਾਨਨਾਸ਼ਯਨ੍ ਤਦੀਯਾ ਘਟਨਾਃ; ");
INSERT INTO sanpun_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","ਕਿਨ੍ਤੁ ਯ ਇਸ੍ਰਾਯੇਲੀਯਲੋਕਾਨ੍ ਉੱਧਾਰਯਿਸ਼਼੍ਯਤਿ ਸ ਏਵਾਯਮ੍ ਇਤ੍ਯਾਸ਼ਾਸ੍ਮਾਭਿਃ ਕ੍ਰੁʼਤਾ| ਤਦ੍ਯਥਾ ਤਥਾਸ੍ਤੁ ਤਸ੍ਯਾ ਘਟਨਾਯਾ ਅਦ੍ਯ ਦਿਨਤ੍ਰਯੰ ਗਤੰ| ");
INSERT INTO sanpun_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ਅਧਿਕਨ੍ਤ੍ਵਸ੍ਮਾਕੰ ਸਙ੍ਗਿਨੀਨਾਂ ਕਿਯਤ੍ਸ੍ਤ੍ਰੀਣਾਂ ਮੁਖੇਭ੍ਯੋ(ਅ)ਸਮ੍ਭਵਵਾਕ੍ਯਮਿਦੰ ਸ਼੍ਰੁਤੰ; ");
INSERT INTO sanpun_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ਤਾਃ ਪ੍ਰਤ੍ਯੂਸ਼਼ੇ ਸ਼੍ਮਸ਼ਾਨੰ ਗਤ੍ਵਾ ਤਤ੍ਰ ਤਸ੍ਯ ਦੇਹਮ੍ ਅਪ੍ਰਾਪ੍ਯ ਵ੍ਯਾਘੁਟ੍ਯੇਤ੍ਵਾ ਪ੍ਰੋਕ੍ਤਵਤ੍ਯਃ ਸ੍ਵਰ੍ਗੀਸਦੂਤੌ ਦ੍ਰੁʼਸ਼਼੍ਟਾਵਸ੍ਮਾਭਿਸ੍ਤੌ ਚਾਵਾਦਿਸ਼਼੍ਟਾਂ ਸ ਜੀਵਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ਤਤੋਸ੍ਮਾਕੰ ਕੈਸ਼੍ਚਿਤ੍ ਸ਼੍ਮਸ਼ਾਨਮਗਮ੍ਯਤ ਤੇ(ਅ)ਪਿ ਸ੍ਤ੍ਰੀਣਾਂ ਵਾਕ੍ਯਾਨੁਰੂਪੰ ਦ੍ਰੁʼਸ਼਼੍ਟਵਨ੍ਤਃ ਕਿਨ੍ਤੁ ਤੰ ਨਾਪਸ਼੍ਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ਤਦਾ ਸ ਤਾਵੁਵਾਚ, ਹੇ ਅਬੋਧੌ ਹੇ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਭਿਰੁਕ੍ਤਵਾਕ੍ਯੰ ਪ੍ਰਤ੍ਯੇਤੁੰ ਵਿਲਮ੍ਬਮਾਨੌ; ");
INSERT INTO sanpun_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ਏਤਤ੍ਸਰ੍ੱਵਦੁਃਖੰ ਭੁਕ੍ਤ੍ਵਾ ਸ੍ਵਭੂਤਿਪ੍ਰਾਪ੍ਤਿਃ ਕਿੰ ਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਨ ਨ੍ਯਾੱਯਾ? ");
INSERT INTO sanpun_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ਤਤਃ ਸ ਮੂਸਾਗ੍ਰਨ੍ਥਮਾਰਭ੍ਯ ਸਰ੍ੱਵਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਾਂ ਸਰ੍ੱਵਸ਼ਾਸ੍ਤ੍ਰੇ ਸ੍ਵਸ੍ਮਿਨ੍ ਲਿਖਿਤਾਖ੍ਯਾਨਾਭਿਪ੍ਰਾਯੰ ਬੋਧਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","ਅਥ ਗਮ੍ਯਗ੍ਰਾਮਾਭ੍ਯਰ੍ਣੰ ਪ੍ਰਾਪ੍ਯ ਤੇਨਾਗ੍ਰੇ ਗਮਨਲਕ੍ਸ਼਼ਣੇ ਦਰ੍ਸ਼ਿਤੇ ");
INSERT INTO sanpun_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ਤੌ ਸਾਧਯਿਤ੍ਵਾਵਦਤਾਂ ਸਹਾਵਾਭ੍ਯਾਂ ਤਿਸ਼਼੍ਠ ਦਿਨੇ ਗਤੇ ਸਤਿ ਰਾਤ੍ਰਿਰਭੂਤ੍; ਤਤਃ ਸ ਤਾਭ੍ਯਾਂ ਸਾਰ੍ੱਧੰ ਸ੍ਥਾਤੁੰ ਗ੍ਰੁʼਹੰ ਯਯੌ| ");
INSERT INTO sanpun_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","ਪਸ਼੍ਚਾਦ੍ਭੋਜਨੋਪਵੇਸ਼ਕਾਲੇ ਸ ਪੂਪੰ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਈਸ਼੍ਵਰਗੁਣਾਨ੍ ਜਗਾਦ ਤਞ੍ਚ ਭੰਕ੍ਤ੍ਵਾ ਤਾਭ੍ਯਾਂ ਦਦੌ| ");
INSERT INTO sanpun_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ਤਦਾ ਤਯੋ ਰ੍ਦ੍ਰੁʼਸ਼਼੍ਟੌ ਪ੍ਰਸੰਨਾਯਾਂ ਤੰ ਪ੍ਰਤ੍ਯਭਿਜ੍ਞਤੁਃ ਕਿਨ੍ਤੁ ਸ ਤਯੋਃ ਸਾਕ੍ਸ਼਼ਾਦਨ੍ਤਰ੍ਦਧੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ਤਤਸ੍ਤੌ ਮਿਥੋਭਿਧਾਤੁਮ੍ ਆਰਬ੍ਧਵਨ੍ਤੌ ਗਮਨਕਾਲੇ ਯਦਾ ਕਥਾਮਕਥਯਤ੍ ਸ਼ਾਸ੍ਤ੍ਰਾਰ੍ਥਞ੍ਚਬੋਧਯਤ੍ ਤਦਾਵਯੋ ਰ੍ਬੁੱਧਿਃ ਕਿੰ ਨ ਪ੍ਰਾਜ੍ਵਲਤ੍? ");
INSERT INTO sanpun_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","ਤੌ ਤਤ੍ਕ੍ਸ਼਼ਣਾਦੁੱਥਾਯ ਯਿਰੂਸ਼ਾਲਮਪੁਰੰ ਪ੍ਰਤ੍ਯਾਯਯਤੁਃ, ਤਤ੍ਸ੍ਥਾਨੇ ਸ਼ਿਸ਼਼੍ਯਾਣਾਮ੍ ਏਕਾਦਸ਼ਾਨਾਂ ਸਙ੍ਗਿਨਾਞ੍ਚ ਦਰ੍ਸ਼ਨੰ ਜਾਤੰ| ");
INSERT INTO sanpun_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ਤੇ ਪ੍ਰੋਚੁਃ ਪ੍ਰਭੁਰੁਦਤਿਸ਼਼੍ਠਦ੍ ਇਤਿ ਸਤ੍ਯੰ ਸ਼ਿਮੋਨੇ ਦਰ੍ਸ਼ਨਮਦਾੱਚ| ");
INSERT INTO sanpun_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","ਤਤਃ ਪਥਃ ਸਰ੍ੱਵਘਟਨਾਯਾਃ ਪੂਪਭਞ੍ਜਨੇਨ ਤਤ੍ਪਰਿਚਯਸ੍ਯ ਚ ਸਰ੍ੱਵਵ੍ਰੁʼੱਤਾਨ੍ਤੰ ਤੌ ਵਕ੍ਤੁਮਾਰੇਭਾਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ਇੱਥੰ ਤੇ ਪਰਸ੍ਪਰੰ ਵਦਨ੍ਤਿ ਤਤ੍ਕਾਲੇ ਯੀਸ਼ੁਃ ਸ੍ਵਯੰ ਤੇਸ਼਼ਾਂ ਮਧ੍ਯ ਪ੍ਰੋੱਥਯ ਯੁਸ਼਼੍ਮਾਕੰ ਕਲ੍ਯਾਣੰ ਭੂਯਾਦ੍ ਇਤ੍ਯੁਵਾਚ, ");
INSERT INTO sanpun_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ਕਿਨ੍ਤੁ ਭੂਤੰ ਪਸ਼੍ਯਾਮ ਇਤ੍ਯਨੁਮਾਯ ਤੇ ਸਮੁਦ੍ਵਿਵਿਜਿਰੇ ਤ੍ਰੇਸ਼਼ੁਸ਼੍ਚ| ");
INSERT INTO sanpun_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","ਸ ਉਵਾਚ, ਕੁਤੋ ਦੁਃਖਿਤਾ ਭਵਥ? ਯੁਸ਼਼੍ਮਾਕੰ ਮਨਃਸੁ ਸਨ੍ਦੇਹ ਉਦੇਤਿ ਚ ਕੁਤਃ? ");
INSERT INTO sanpun_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ਏਸ਼਼ੋਹੰ, ਮਮ ਕਰੌ ਪਸ਼੍ਯਤ ਵਰੰ ਸ੍ਪ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਪਸ਼੍ਯਤ, ਮਮ ਯਾਦ੍ਰੁʼਸ਼ਾਨਿ ਪਸ਼੍ਯਥ ਤਾਦ੍ਰੁʼਸ਼ਾਨਿ ਭੂਤਸ੍ਯ ਮਾਂਸਾਸ੍ਥੀਨਿ ਨ ਸਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ਇਤ੍ਯੁਕ੍ਤ੍ਵਾ ਸ ਹਸ੍ਤਪਾਦਾਨ੍ ਦਰ੍ਸ਼ਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ਤੇ(ਅ)ਸਮ੍ਭਵੰ ਜ੍ਞਾਤ੍ਵਾ ਸਾਨਨ੍ਦਾ ਨ ਪ੍ਰਤ੍ਯਯਨ੍| ਤਤਃ ਸ ਤਾਨ੍ ਪਪ੍ਰੱਛ, ਅਤ੍ਰ ਯੁਸ਼਼੍ਮਾਕੰ ਸਮੀਪੇ ਖਾਦ੍ਯੰ ਕਿਞ੍ਚਿਦਸ੍ਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ਤਤਸ੍ਤੇ ਕਿਯੱਦਗ੍ਧਮਤ੍ਸ੍ਯੰ ਮਧੁ ਚ ਦਦੁਃ ");
INSERT INTO sanpun_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ਸ ਤਦਾਦਾਯ ਤੇਸ਼਼ਾਂ ਸਾਕ੍ਸ਼਼ਾਦ੍ ਬੁਭੁਜੇ ");
INSERT INTO sanpun_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","ਕਥਯਾਮਾਸ ਚ ਮੂਸਾਵ੍ਯਵਸ੍ਥਾਯਾਂ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਾਂ ਗ੍ਰਨ੍ਥੇਸ਼਼ੁ ਗੀਤਪੁਸ੍ਤਕੇ ਚ ਮਯਿ ਯਾਨਿ ਸਰ੍ੱਵਾਣਿ ਵਚਨਾਨਿ ਲਿਖਿਤਾਨਿ ਤਦਨੁਰੂਪਾਣਿ ਘਟਿਸ਼਼੍ਯਨ੍ਤੇ ਯੁਸ਼਼੍ਮਾਭਿਃ ਸਾਰ੍ੱਧੰ ਸ੍ਥਿਤ੍ਵਾਹੰ ਯਦੇਤਦ੍ਵਾਕ੍ਯਮ੍ ਅਵਦੰ ਤਦਿਦਾਨੀਂ ਪ੍ਰਤ੍ਯਕ੍ਸ਼਼ਮਭੂਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","ਅਥ ਤੇਭ੍ਯਃ ਸ਼ਾਸ੍ਤ੍ਰਬੋਧਾਧਿਕਾਰੰ ਦਤ੍ਵਾਵਦਤ੍, ");
INSERT INTO sanpun_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ਖ੍ਰੀਸ਼਼੍ਟੇਨੇੱਥੰ ਮ੍ਰੁʼਤਿਯਾਤਨਾ ਭੋਕ੍ਤਵ੍ਯਾ ਤ੍ਰੁʼਤੀਯਦਿਨੇ ਚ ਸ਼੍ਮਸ਼ਾਨਾਦੁੱਥਾਤਵ੍ਯਞ੍ਚੇਤਿ ਲਿਪਿਰਸ੍ਤਿ; ");
INSERT INTO sanpun_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ਤੰਨਾਮ੍ਨਾ ਯਿਰੂਸ਼ਾਲਮਮਾਰਭ੍ਯ ਸਰ੍ੱਵਦੇਸ਼ੇ ਮਨਃਪਰਾਵਰ੍ੱਤਨਸ੍ਯ ਪਾਪਮੋਚਨਸ੍ਯ ਚ ਸੁਸੰਵਾਦਃ ਪ੍ਰਚਾਰਯਿਤਵ੍ਯਃ, ");
INSERT INTO sanpun_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ਏਸ਼਼ੁ ਸਰ੍ੱਵੇਸ਼਼ੁ ਯੂਯੰ ਸਾਕ੍ਸ਼਼ਿਣਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ਅਪਰਞ੍ਚ ਪਸ਼੍ਯਤ ਪਿਤ੍ਰਾ ਯਤ੍ ਪ੍ਰਤਿਜ੍ਞਾਤੰ ਤਤ੍ ਪ੍ਰੇਸ਼਼ਯਿਸ਼਼੍ਯਾਮਿ, ਅਤਏਵ ਯਾਵਤ੍ਕਾਲੰ ਯੂਯੰ ਸ੍ਵਰ੍ਗੀਯਾਂ ਸ਼ਕ੍ਤਿੰ ਨ ਪ੍ਰਾਪ੍ਸ੍ਯਥ ਤਾਵਤ੍ਕਾਲੰ ਯਿਰੂਸ਼ਾਲਮ੍ਨਗਰੇ ਤਿਸ਼਼੍ਠਤ| ");
INSERT INTO sanpun_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","ਅਥ ਸ ਤਾਨ੍ ਬੈਥਨੀਯਾਪਰ੍ੱਯਨ੍ਤੰ ਨੀਤ੍ਵਾ ਹਸ੍ਤਾਵੁੱਤੋਲ੍ਯ ਆਸ਼ਿਸ਼਼ ਵਕ੍ਤੁਮਾਰੇਭੇ ");
INSERT INTO sanpun_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ਆਸ਼ਿਸ਼਼ੰ ਵਦੰਨੇਵ ਚ ਤੇਭ੍ਯਃ ਪ੍ਰੁʼਥਗ੍ ਭੂਤ੍ਵਾ ਸ੍ਵਰ੍ਗਾਯ ਨੀਤੋ(ਅ)ਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","ਤਦਾ ਤੇ ਤੰ ਭਜਮਾਨਾ ਮਹਾਨਨ੍ਦੇਨ ਯਿਰੂਸ਼ਾਲਮੰ ਪ੍ਰਤ੍ਯਾਜਗ੍ਮੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ਤਤੋ ਨਿਰਨ੍ਤਰੰ ਮਨ੍ਦਿਰੇ ਤਿਸ਼਼੍ਠਨ੍ਤ ਈਸ਼੍ਵਰਸ੍ਯ ਪ੍ਰਸ਼ੰਸਾਂ ਧਨ੍ਯਵਾਦਞ੍ਚ ਕਰ੍ੱਤਮ੍ ਆਰੇਭਿਰੇ| ਇਤਿ||");
INSERT INTO sanpun_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ਆਦੌ ਵਾਦ ਆਸੀਤ੍ ਸ ਚ ਵਾਦ ਈਸ਼੍ਵਰੇਣ ਸਾਰ੍ਧਮਾਸੀਤ੍ ਸ ਵਾਦਃ ਸ੍ਵਯਮੀਸ਼੍ਵਰ ਏਵ| ");
INSERT INTO sanpun_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ਸ ਆਦਾਵੀਸ਼੍ਵਰੇਣ ਸਹਾਸੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ਤੇਨ ਸਰ੍ੱਵੰ ਵਸ੍ਤੁ ਸਸ੍ਰੁʼਜੇ ਸਰ੍ੱਵੇਸ਼਼ੁ ਸ੍ਰੁʼਸ਼਼੍ਟਵਸ੍ਤੁਸ਼਼ੁ ਕਿਮਪਿ ਵਸ੍ਤੁ ਤੇਨਾਸ੍ਰੁʼਸ਼਼੍ਟੰ ਨਾਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ਸ ਜੀਵਨਸ੍ਯਾਕਾਰਃ, ਤੱਚ ਜੀਵਨੰ ਮਨੁਸ਼਼੍ਯਾਣਾਂ ਜ੍ਯੋਤਿਃ ");
INSERT INTO sanpun_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","ਤੱਜ੍ਯੋਤਿਰਨ੍ਧਕਾਰੇ ਪ੍ਰਚਕਾਸ਼ੇ ਕਿਨ੍ਤ੍ਵਨ੍ਧਕਾਰਸ੍ਤੰਨ ਜਗ੍ਰਾਹ| ");
INSERT INTO sanpun_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","ਯੋਹਨ੍ ਨਾਮਕ ਏਕੋ ਮਨੁਜ ਈਸ਼੍ਵਰੇਣ ਪ੍ਰੇਸ਼਼ਯਾਞ੍ਚਕ੍ਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ਤਦ੍ਵਾਰਾ ਯਥਾ ਸਰ੍ੱਵੇ ਵਿਸ਼੍ਵਸਨ੍ਤਿ ਤਦਰ੍ਥੰ ਸ ਤੱਜ੍ਯੋਤਿਸ਼਼ਿ ਪ੍ਰਮਾਣੰ ਦਾਤੁੰ ਸਾਕ੍ਸ਼਼ਿਸ੍ਵਰੂਪੋ ਭੂਤ੍ਵਾਗਮਤ੍, ");
INSERT INTO sanpun_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ਸ ਸ੍ਵਯੰ ਤੱਜ੍ਯੋਤਿ ਰ੍ਨ ਕਿਨ੍ਤੁ ਤੱਜ੍ਯੋਤਿਸ਼਼ਿ ਪ੍ਰਮਾਣੰ ਦਾਤੁਮਾਗਮਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ਜਗਤ੍ਯਾਗਤ੍ਯ ਯਃ ਸਰ੍ੱਵਮਨੁਜੇਭ੍ਯੋ ਦੀਪ੍ਤਿੰ ਦਦਾਤਿ ਤਦੇਵ ਸਤ੍ਯਜ੍ਯੋਤਿਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ਸ ਯੱਜਗਦਸ੍ਰੁʼਜਤ੍ ਤਨ੍ਮਦ੍ਯ ਏਵ ਸ ਆਸੀਤ੍ ਕਿਨ੍ਤੁ ਜਗਤੋ ਲੋਕਾਸ੍ਤੰ ਨਾਜਾਨਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","ਨਿਜਾਧਿਕਾਰੰ ਸ ਆਗੱਛਤ੍ ਕਿਨ੍ਤੁ ਪ੍ਰਜਾਸ੍ਤੰ ਨਾਗ੍ਰੁʼਹ੍ਲਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","ਤਥਾਪਿ ਯੇ ਯੇ ਤਮਗ੍ਰੁʼਹ੍ਲਨ੍ ਅਰ੍ਥਾਤ੍ ਤਸ੍ਯ ਨਾਮ੍ਨਿ ਵ੍ਯਸ਼੍ਵਸਨ੍ ਤੇਭ੍ਯ ਈਸ਼੍ਵਰਸ੍ਯ ਪੁਤ੍ਰਾ ਭਵਿਤੁਮ੍ ਅਧਿਕਾਰਮ੍ ਅਦਦਾਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ਤੇਸ਼਼ਾਂ ਜਨਿਃ ਸ਼ੋਣਿਤਾੰਨ ਸ਼ਾਰੀਰਿਕਾਭਿਲਾਸ਼਼ਾੰਨ ਮਾਨਵਾਨਾਮਿੱਛਾਤੋ ਨ ਕਿਨ੍ਤ੍ਵੀਸ਼੍ਵਰਾਦਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","ਸ ਵਾਦੋ ਮਨੁਸ਼਼੍ਯਰੂਪੇਣਾਵਤੀਰ੍ੱਯ ਸਤ੍ਯਤਾਨੁਗ੍ਰਹਾਭ੍ਯਾਂ ਪਰਿਪੂਰ੍ਣਃ ਸਨ੍ ਸਾਰ੍ਧਮ੍ ਅਸ੍ਮਾਭਿ ਰ੍ਨ੍ਯਵਸਤ੍ ਤਤਃ ਪਿਤੁਰਦ੍ਵਿਤੀਯਪੁਤ੍ਰਸ੍ਯ ਯੋਗ੍ਯੋ ਯੋ ਮਹਿਮਾ ਤੰ ਮਹਿਮਾਨੰ ਤਸ੍ਯਾਪਸ਼੍ਯਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ਤਤੋ ਯੋਹਨਪਿ ਪ੍ਰਚਾਰ੍ੱਯ ਸਾਕ੍ਸ਼਼੍ਯਮਿਦੰ ਦੱਤਵਾਨ੍ ਯੋ ਮਮ ਪਸ਼੍ਚਾਦ੍ ਆਗਮਿਸ਼਼੍ਯਤਿ ਸ ਮੱਤੋ ਗੁਰੁਤਰਃ; ਯਤੋ ਮਤ੍ਪੂਰ੍ੱਵੰ ਸ ਵਿਦ੍ਯਮਾਨ ਆਸੀਤ੍; ਯਦਰ੍ਥਮ੍ ਅਹੰ ਸਾਕ੍ਸ਼਼੍ਯਮਿਦਮ੍ ਅਦਾਂ ਸ ਏਸ਼਼ਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ਅਪਰਞ੍ਚ ਤਸ੍ਯ ਪੂਰ੍ਣਤਾਯਾ ਵਯੰ ਸਰ੍ੱਵੇ ਕ੍ਰਮਸ਼ਃ ਕ੍ਰਮਸ਼ੋਨੁਗ੍ਰਹੰ ਪ੍ਰਾਪ੍ਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","ਮੂਸਾਦ੍ਵਾਰਾ ਵ੍ਯਵਸ੍ਥਾ ਦੱਤਾ ਕਿਨ੍ਤ੍ਵਨੁਗ੍ਰਹਃ ਸਤ੍ਯਤ੍ਵਞ੍ਚ ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟਦ੍ਵਾਰਾ ਸਮੁਪਾਤਿਸ਼਼੍ਠਤਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","ਕੋਪਿ ਮਨੁਜ ਈਸ਼੍ਵਰੰ ਕਦਾਪਿ ਨਾਪਸ਼੍ਯਤ੍ ਕਿਨ੍ਤੁ ਪਿਤੁਃ ਕ੍ਰੋਡਸ੍ਥੋ(ਅ)ਦ੍ਵਿਤੀਯਃ ਪੁਤ੍ਰਸ੍ਤੰ ਪ੍ਰਕਾਸ਼ਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","ਤ੍ਵੰ ਕਃ? ਇਤਿ ਵਾਕ੍ਯੰ ਪ੍ਰੇਸ਼਼੍ਟੁੰ ਯਦਾ ਯਿਹੂਦੀਯਲੋਕਾ ਯਾਜਕਾਨ੍ ਲੇਵਿਲੋਕਾਂਸ਼੍ਚ ਯਿਰੂਸ਼ਾਲਮੋ ਯੋਹਨਃ ਸਮੀਪੇ ਪ੍ਰੇਸ਼਼ਯਾਮਾਸੁਃ, ");
INSERT INTO sanpun_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ਤਦਾ ਸ ਸ੍ਵੀਕ੍ਰੁʼਤਵਾਨ੍ ਨਾਪਹ੍ਨੂਤਵਾਨ੍ ਨਾਹਮ੍ ਅਭਿਸ਼਼ਿਕ੍ਤ ਇਤ੍ਯਙ੍ਗੀਕ੍ਰੁʼਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","ਤਦਾ ਤੇ(ਅ)ਪ੍ਰੁʼੱਛਨ੍ ਤਰ੍ਹਿ ਕੋ ਭਵਾਨ੍? ਕਿੰ ਏਲਿਯਃ? ਸੋਵਦਤ੍ ਨ; ਤਤਸ੍ਤੇ(ਅ)ਪ੍ਰੁʼੱਛਨ੍ ਤਰ੍ਹਿ ਭਵਾਨ੍ ਸ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦੀ? ਸੋਵਦਤ੍ ਨਾਹੰ ਸਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","ਤਦਾ ਤੇ(ਅ)ਪ੍ਰੁʼੱਛਨ੍ ਤਰ੍ਹਿ ਭਵਾਨ੍ ਕਃ? ਵਯੰ ਗਤ੍ਵਾ ਪ੍ਰੇਰਕਾਨ੍ ਤ੍ਵਯਿ ਕਿੰ ਵਕ੍ਸ਼਼੍ਯਾਮਃ? ਸ੍ਵਸ੍ਮਿਨ੍ ਕਿੰ ਵਦਸਿ? ");
INSERT INTO sanpun_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ਤਦਾ ਸੋਵਦਤ੍| ਪਰਮੇਸ਼ਸ੍ਯ ਪਨ੍ਥਾਨੰ ਪਰਿਸ਼਼੍ਕੁਰੁਤ ਸਰ੍ੱਵਤਃ| ਇਤੀਦੰ ਪ੍ਰਾਨ੍ਤਰੇ ਵਾਕ੍ਯੰ ਵਦਤਃ ਕਸ੍ਯਚਿਦ੍ਰਵਃ| ਕਥਾਮਿਮਾਂ ਯਸ੍ਮਿਨ੍ ਯਿਸ਼ਯਿਯੋ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦੀ ਲਿਖਿਤਵਾਨ੍ ਸੋਹਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ਯੇ ਪ੍ਰੇਸ਼਼ਿਤਾਸ੍ਤੇ ਫਿਰੂਸ਼ਿਲੋਕਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ਤਦਾ ਤੇ(ਅ)ਪ੍ਰੁʼੱਛਨ੍ ਯਦਿ ਨਾਭਿਸ਼਼ਿਕ੍ਤੋਸਿ ਏਲਿਯੋਸਿ ਨ ਸ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦ੍ਯਪਿ ਨਾਸਿ ਚ, ਤਰ੍ਹਿ ਲੋਕਾਨ੍ ਮੱਜਯਸਿ ਕੁਤਃ? ");
INSERT INTO sanpun_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ਤਤੋ ਯੋਹਨ੍ ਪ੍ਰਤ੍ਯਵੋਚਤ੍, ਤੋਯੇ(ਅ)ਹੰ ਮੱਜਯਾਮੀਤਿ ਸਤ੍ਯੰ ਕਿਨ੍ਤੁ ਯੰ ਯੂਯੰ ਨ ਜਾਨੀਥ ਤਾਦ੍ਰੁʼਸ਼ ਏਕੋ ਜਨੋ ਯੁਸ਼਼੍ਮਾਕੰ ਮਧ੍ਯ ਉਪਤਿਸ਼਼੍ਠਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ਸ ਮਤ੍ਪਸ਼੍ਚਾਦ੍ ਆਗਤੋਪਿ ਮਤ੍ਪੂਰ੍ੱਵੰ ਵਰ੍ੱਤਮਾਨ ਆਸੀਤ੍ ਤਸ੍ਯ ਪਾਦੁਕਾਬਨ੍ਧਨੰ ਮੋਚਯਿਤੁਮਪਿ ਨਾਹੰ ਯੋਗ੍ਯੋਸ੍ਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ਯਰ੍ੱਦਨਨਦ੍ਯਾਃ ਪਾਰਸ੍ਥਬੈਥਬਾਰਾਯਾਂ ਯਸ੍ਮਿਨ੍ਸ੍ਥਾਨੇ ਯੋਹਨਮੱਜਯਤ੍ ਤਸ੍ਮਿਨ ਸ੍ਥਾਨੇ ਸਰ੍ੱਵਮੇਤਦ੍ ਅਘਟਤ| ");
INSERT INTO sanpun_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","ਪਰੇ(ਅ)ਹਨਿ ਯੋਹਨ੍ ਸ੍ਵਨਿਕਟਮਾਗੱਛਨ੍ਤੰ ਯਿਸ਼ੁੰ ਵਿਲੋਕ੍ਯ ਪ੍ਰਾਵੋਚਤ੍ ਜਗਤਃ ਪਾਪਮੋਚਕਮ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਮੇਸ਼਼ਸ਼ਾਵਕੰ ਪਸ਼੍ਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","ਯੋ ਮਮ ਪਸ਼੍ਚਾਦਾਗਮਿਸ਼਼੍ਯਤਿ ਸ ਮੱਤੋ ਗੁਰੁਤਰਃ, ਯਤੋ ਹੇਤੋਰ੍ਮਤ੍ਪੂਰ੍ੱਵੰ ਸੋ(ਅ)ਵਰ੍ੱਤਤ ਯਸ੍ਮਿੰਨਹੰ ਕਥਾਮਿਮਾਂ ਕਥਿਤਵਾਨ੍ ਸ ਏਵਾਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","ਅਪਰੰ ਨਾਹਮੇਨੰ ਪ੍ਰਤ੍ਯਭਿਜ੍ਞਾਤਵਾਨ੍ ਕਿਨ੍ਤੁ ਇਸ੍ਰਾਯੇੱਲੋਕਾ ਏਨੰ ਯਥਾ ਪਰਿਚਿਨ੍ਵਨ੍ਤਿ ਤਦਭਿਪ੍ਰਾਯੇਣਾਹੰ ਜਲੇ ਮੱਜਯਿਤੁਮਾਗੱਛਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","ਪੁਨਸ਼੍ਚ ਯੋਹਨਪਰਮੇਕੰ ਪ੍ਰਮਾਣੰ ਦਤ੍ਵਾ ਕਥਿਤਵਾਨ੍ ਵਿਹਾਯਸਃ ਕਪੋਤਵਦ੍ ਅਵਤਰਨ੍ਤਮਾਤ੍ਮਾਨਮ੍ ਅਸ੍ਯੋਪਰ੍ੱਯਵਤਿਸ਼਼੍ਠਨ੍ਤੰ ਚ ਦ੍ਰੁʼਸ਼਼੍ਟਵਾਨਹਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","ਨਾਹਮੇਨੰ ਪ੍ਰਤ੍ਯਭਿਜ੍ਞਾਤਵਾਨ੍ ਇਤਿ ਸਤ੍ਯੰ ਕਿਨ੍ਤੁ ਯੋ ਜਲੇ ਮੱਜਯਿਤੁੰ ਮਾਂ ਪ੍ਰੈਰਯਤ੍ ਸ ਏਵੇਮਾਂ ਕਥਾਮਕਥਯਤ੍ ਯਸ੍ਯੋਪਰ੍ੱਯਾਤ੍ਮਾਨਮ੍ ਅਵਤਰਨ੍ਤਮ੍ ਅਵਤਿਸ਼਼੍ਠਨ੍ਤਞ੍ਚ ਦ੍ਰਕ੍ਸ਼਼ਯਸਿ ਸਏਵ ਪਵਿਤ੍ਰੇ ਆਤ੍ਮਨਿ ਮੱਜਯਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","ਅਵਸ੍ਤੰਨਿਰੀਕ੍ਸ਼਼੍ਯਾਯਮ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਤਨਯ ਇਤਿ ਪ੍ਰਮਾਣੰ ਦਦਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","ਪਰੇ(ਅ)ਹਨਿ ਯੋਹਨ੍ ਦ੍ਵਾਭ੍ਯਾਂ ਸ਼ਿਸ਼਼੍ਯਾਭ੍ਯਾਂ ਸਾਰ੍ੱਧੇਂ ਤਿਸ਼਼੍ਠਨ੍ ");
INSERT INTO sanpun_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ਯਿਸ਼ੁੰ ਗੱਛਨ੍ਤੰ ਵਿਲੋਕ੍ਯ ਗਦਿਤਵਾਨ੍, ਈਸ਼੍ਵਰਸ੍ਯ ਮੇਸ਼਼ਸ਼ਾਵਕੰ ਪਸ਼੍ਯਤੰ| ");
INSERT INTO sanpun_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ਇਮਾਂ ਕਥਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਦ੍ਵੌ ਸ਼ਿਸ਼਼੍ਯੌ ਯੀਸ਼ੋਃ ਪਸ਼੍ਚਾਦ੍ ਈਯਤੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ਤਤੋ ਯੀਸ਼ੁਃ ਪਰਾਵ੍ਰੁʼਤ੍ਯ ਤੌ ਪਸ਼੍ਚਾਦ੍ ਆਗੱਛਨ੍ਤੌ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਪ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍ ਯੁਵਾਂ ਕਿੰ ਗਵੇਸ਼ਯਥਃ? ਤਾਵਪ੍ਰੁʼੱਛਤਾਂ ਹੇ ਰੱਬਿ ਅਰ੍ਥਾਤ੍ ਹੇ ਗੁਰੋ ਭਵਾਨ੍ ਕੁਤ੍ਰ ਤਿਸ਼਼੍ਠਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ਤਤਃ ਸੋਵਾਦਿਤ੍ ਏਤ੍ਯ ਪਸ਼੍ਯਤੰ| ਤਤੋ ਦਿਵਸਸ੍ਯ ਤ੍ਰੁʼਤੀਯਪ੍ਰਹਰਸ੍ਯ ਗਤਤ੍ਵਾਤ੍ ਤੌ ਤੱਦਿਨੰ ਤਸ੍ਯ ਸਙ੍ਗੇ(ਅ)ਸ੍ਥਾਤਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ਯੌ ਦ੍ਵੌ ਯੋਹਨੋ ਵਾਕ੍ਯੰ ਸ਼੍ਰੁਤ੍ਵਾ ਯਿਸ਼ੋਃ ਪਸ਼੍ਚਾਦ੍ ਆਗਮਤਾਂ ਤਯੋਃ ਸ਼ਿਮੋਨ੍ਪਿਤਰਸ੍ਯ ਭ੍ਰਾਤਾ ਆਨ੍ਦ੍ਰਿਯਃ ");
INSERT INTO sanpun_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ਸ ਇਤ੍ਵਾ ਪ੍ਰਥਮੰ ਨਿਜਸੋਦਰੰ ਸ਼ਿਮੋਨੰ ਸਾਕ੍ਸ਼਼ਾਤ੍ਪ੍ਰਾਪ੍ਯ ਕਥਿਤਵਾਨ੍ ਵਯੰ ਖ੍ਰੀਸ਼਼੍ਟਮ੍ ਅਰ੍ਥਾਤ੍ ਅਭਿਸ਼਼ਿਕ੍ਤਪੁਰੁਸ਼਼ੰ ਸਾਕ੍ਸ਼਼ਾਤ੍ਕ੍ਰੁʼਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","ਪਸ਼੍ਚਾਤ੍ ਸ ਤੰ ਯਿਸ਼ੋਃ ਸਮੀਪਮ੍ ਆਨਯਤ੍| ਤਦਾ ਯੀਸ਼ੁਸ੍ਤੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾਵਦਤ੍ ਤ੍ਵੰ ਯੂਨਸਃ ਪੁਤ੍ਰਃ ਸ਼ਿਮੋਨ੍ ਕਿਨ੍ਤੁ ਤ੍ਵੰਨਾਮਧੇਯੰ ਕੈਫਾਃ ਵਾ ਪਿਤਰਃ ਅਰ੍ਥਾਤ੍ ਪ੍ਰਸ੍ਤਰੋ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","ਪਰੇ(ਅ)ਹਨਿ ਯੀਸ਼ੌ ਗਾਲੀਲੰ ਗਨ੍ਤੁੰ ਨਿਸ਼੍ਚਿਤਚੇਤਸਿ ਸਤਿ ਫਿਲਿਪਨਾਮਾਨੰ ਜਨੰ ਸਾਕ੍ਸ਼਼ਾਤ੍ਪ੍ਰਾਪ੍ਯਾਵੋਚਤ੍ ਮਮ ਪਸ਼੍ਚਾਦ੍ ਆਗੱਛ| ");
INSERT INTO sanpun_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ਬੈਤ੍ਸੈਦਾਨਾਮ੍ਨਿ ਯਸ੍ਮਿਨ੍ ਗ੍ਰਾਮੇ ਪਿਤਰਾਨ੍ਦ੍ਰਿਯਯੋਰ੍ਵਾਸ ਆਸੀਤ੍ ਤਸ੍ਮਿਨ੍ ਗ੍ਰਾਮੇ ਤਸ੍ਯ ਫਿਲਿਪਸ੍ਯ ਵਸਤਿਰਾਸੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ਪਸ਼੍ਚਾਤ੍ ਫਿਲਿਪੋ ਨਿਥਨੇਲੰ ਸਾਕ੍ਸ਼਼ਾਤ੍ਪ੍ਰਾਪ੍ਯਾਵਦਤ੍ ਮੂਸਾ ਵ੍ਯਵਸ੍ਥਾ ਗ੍ਰਨ੍ਥੇ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਾਂ ਗ੍ਰਨ੍ਥੇਸ਼਼ੁ ਚ ਯਸ੍ਯਾਖ੍ਯਾਨੰ ਲਿਖਿਤਮਾਸ੍ਤੇ ਤੰ ਯੂਸ਼਼ਫਃ ਪੁਤ੍ਰੰ ਨਾਸਰਤੀਯੰ ਯੀਸ਼ੁੰ ਸਾਕ੍ਸ਼਼ਾਦ੍ ਅਕਾਰ੍ਸ਼਼੍ਮ ਵਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","ਤਦਾ ਨਿਥਨੇਲ੍ ਕਥਿਤਵਾਨ੍ ਨਾਸਰੰਨਗਰਾਤ ਕਿੰ ਕਸ਼੍ਚਿਦੁੱਤਮ ਉਤ੍ਪਨ੍ਤੁੰ ਸ਼ਕ੍ਨੋਤਿ? ਤਤਃ ਫਿਲਿਪੋ (ਅ)ਵੋਚਤ੍ ਏਤ੍ਯ ਪਸ਼੍ਯ| ");
INSERT INTO sanpun_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ਅਪਰਞ੍ਚ ਯੀਸ਼ੁਃ ਸ੍ਵਸ੍ਯ ਸਮੀਪੰ ਤਮ੍ ਆਗੱਛਨ੍ਤੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਵ੍ਯਾਹ੍ਰੁʼਤਵਾਨ੍, ਪਸ਼੍ਯਾਯੰ ਨਿਸ਼਼੍ਕਪਟਃ ਸਤ੍ਯ ਇਸ੍ਰਾਯੇੱਲੋਕਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","ਤਤਃ ਸੋਵਦਦ੍, ਭਵਾਨ੍ ਮਾਂ ਕਥੰ ਪ੍ਰਤ੍ਯਭਿਜਾਨਾਤਿ? ਯੀਸ਼ੁਰਵਾਦੀਤ੍ ਫਿਲਿਪਸ੍ਯ ਆਹ੍ਵਾਨਾਤ੍ ਪੂਰ੍ੱਵੰ ਯਦਾ ਤ੍ਵਮੁਡੁਮ੍ਬਰਸ੍ਯ ਤਰੋਰ੍ਮੂਲੇ(ਅ)ਸ੍ਥਾਸ੍ਤਦਾ ਤ੍ਵਾਮਦਰ੍ਸ਼ਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","ਨਿਥਨੇਲ੍ ਅਚਕਥਤ੍, ਹੇ ਗੁਰੋ ਭਵਾਨ੍ ਨਿਤਾਨ੍ਤਮ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਪੁਤ੍ਰੋਸਿ, ਭਵਾਨ੍ ਇਸ੍ਰਾਯੇਲ੍ਵੰਸ਼ਸ੍ਯ ਰਾਜਾ| ");
INSERT INTO sanpun_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ਤਤੋ ਯੀਸ਼ੁ ਰ੍ਵ੍ਯਾਹਰਤ੍, ਤ੍ਵਾਮੁਡੁਮ੍ਬਰਸ੍ਯ ਪਾਦਪਸ੍ਯ ਮੂਲੇ ਦ੍ਰੁʼਸ਼਼੍ਟਵਾਨਾਹੰ ਮਮੈਤਸ੍ਮਾਦ੍ਵਾਕ੍ਯਾਤ੍ ਕਿੰ ਤ੍ਵੰ ਵ੍ਯਸ਼੍ਵਸੀਃ? ਏਤਸ੍ਮਾਦਪ੍ਯਾਸ਼੍ਚਰ੍ੱਯਾਣਿ ਕਾਰ੍ੱਯਾਣਿ ਦ੍ਰਕ੍ਸ਼਼੍ਯਸਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","ਅਨ੍ਯੱਚਾਵਾਦੀਦ੍ ਯੁਸ਼਼੍ਮਾਨਹੰ ਯਥਾਰ੍ਥੰ ਵਦਾਮਿ, ਇਤਃ ਪਰੰ ਮੋਚਿਤੇ ਮੇਘਦ੍ਵਾਰੇ ਤਸ੍ਮਾਨ੍ਮਨੁਜਸੂਨੁਨਾ ਈਸ਼੍ਵਰਸ੍ਯ ਦੂਤਗਣਮ੍ ਅਵਰੋਹਨ੍ਤਮਾਰੋਹਨ੍ਤਞ੍ਚ ਦ੍ਰਕ੍ਸ਼਼੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","ਅਨਨ੍ਤਰੰ ਤ੍ਰੁਤੀਯਦਿਵਸੇ ਗਾਲੀਲ੍ ਪ੍ਰਦੇਸ਼ਿਯੇ ਕਾੰਨਾਨਾਮ੍ਨਿ ਨਗਰੇ ਵਿਵਾਹ ਆਸੀਤ੍ ਤਤ੍ਰ ਚ ਯੀਸ਼ੋਰ੍ਮਾਤਾ ਤਿਸ਼਼੍ਠਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ਤਸ੍ਮੈ ਵਿਵਾਹਾਯ ਯੀਸ਼ੁਸ੍ਤਸ੍ਯ ਸ਼ਿਸ਼਼੍ਯਾਸ਼੍ਚ ਨਿਮਨ੍ਤ੍ਰਿਤਾ ਆਸਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ਤਦਨਨ੍ਤਰੰ ਦ੍ਰਾਕ੍ਸ਼਼ਾਰਸਸ੍ਯ ਨ੍ਯੂਨਤ੍ਵਾਦ੍ ਯੀਸ਼ੋਰ੍ਮਾਤਾ ਤਮਵਦਤ੍ ਏਤੇਸ਼਼ਾਂ ਦ੍ਰਾਕ੍ਸ਼਼ਾਰਸੋ ਨਾਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","ਤਦਾ ਸ ਤਾਮਵੋਚਤ੍ ਹੇ ਨਾਰਿ ਮਯਾ ਸਹ ਤਵ ਕਿੰ ਕਾਰ੍ੱਯੰ? ਮਮ ਸਮਯ ਇਦਾਨੀਂ ਨੋਪਤਿਸ਼਼੍ਠਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ਤਤਸ੍ਤਸ੍ਯ ਮਾਤਾ ਦਾਸਾਨਵੋਚਦ੍ ਅਯੰ ਯਦ੍ ਵਦਤਿ ਤਦੇਵ ਕੁਰੁਤ| ");
INSERT INTO sanpun_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ਤਸ੍ਮਿਨ੍ ਸ੍ਥਾਨੇ ਯਿਹੂਦੀਯਾਨਾਂ ਸ਼ੁਚਿਤ੍ਵਕਰਣਵ੍ਯਵਹਾਰਾਨੁਸਾਰੇਣਾਢਕੈਕਜਲਧਰਾਣਿ ਪਾਸ਼਼ਾਣਮਯਾਨਿ ਸ਼਼ਡ੍ਵ੍ਰੁʼਹਤ੍ਪਾਤ੍ਰਾਣਿਆਸਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ਤਦਾ ਯੀਸ਼ੁਸ੍ਤਾਨ੍ ਸਰ੍ੱਵਕਲਸ਼ਾਨ੍ ਜਲੈਃ ਪੂਰਯਿਤੁੰ ਤਾਨਾਜ੍ਞਾਪਯਤ੍, ਤਤਸ੍ਤੇ ਸਰ੍ੱਵਾਨ੍ ਕੁਮ੍ਭਾਨਾਕਰ੍ਣੰ ਜਲੈਃ ਪਰ੍ੱਯਪੂਰਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ਅਥ ਤੇਭ੍ਯਃ ਕਿਞ੍ਚਿਦੁੱਤਾਰ੍ੱਯ ਭੋਜ੍ਯਾਧਿਪਾਤੇਃਸਮੀਪੰ ਨੇਤੁੰ ਸ ਤਾਨਾਦਿਸ਼ਤ੍, ਤੇ ਤਦਨਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ਅਪਰਞ੍ਚ ਤੱਜਲੰ ਕਥੰ ਦ੍ਰਾਕ੍ਸ਼਼ਾਰਸੋ(ਅ)ਭਵਤ੍ ਤੱਜਲਵਾਹਕਾਦਾਸਾ ਜ੍ਞਾਤੁੰ ਸ਼ਕ੍ਤਾਃ ਕਿਨ੍ਤੁ ਤਦ੍ਭੋਜ੍ਯਾਧਿਪੋ ਜ੍ਞਾਤੁੰ ਨਾਸ਼ਕ੍ਨੋਤ੍ ਤਦਵਲਿਹ੍ਯ ਵਰੰ ਸੰਮ੍ਬੋਦ੍ਯਾਵਦਤ, ");
INSERT INTO sanpun_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ਲੋਕਾਃ ਪ੍ਰਥਮੰ ਉੱਤਮਦ੍ਰਾਕ੍ਸ਼਼ਾਰਸੰ ਦਦਤਿ ਤਸ਼਼ੁ ਯਥੇਸ਼਼੍ਟੰ ਪਿਤਵਤ੍ਸੁ ਤਸ੍ਮਾ ਕਿਞ੍ਚਿਦਨੁੱਤਮਞ੍ਚ ਦਦਤਿ ਕਿਨ੍ਤੁ ਤ੍ਵਮਿਦਾਨੀਂ ਯਾਵਤ੍ ਉੱਤਮਦ੍ਰਾਕ੍ਸ਼਼ਾਰਸੰ ਸ੍ਥਾਪਯਸਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ਇੱਥੰ ਯੀਸ਼ੁਰ੍ਗਾਲੀਲਪ੍ਰਦੇਸ਼ੇ ਆਸ਼੍ਚਰ੍ੱਯਕਾਰ੍ੰਮ ਪ੍ਰਾਰਮ੍ਭ ਨਿਜਮਹਿਮਾਨੰ ਪ੍ਰਾਕਾਸ਼ਯਤ੍ ਤਤਃ ਸ਼ਿਸ਼਼੍ਯਾਸ੍ਤਸ੍ਮਿਨ੍ ਵ੍ਯਸ਼੍ਵਸਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ਤਤਃ ਪਰਮ੍ ਸ ਨਿਜਮਾਤ੍ਰੁਭ੍ਰਾਤ੍ਰੁਸ੍ਸ਼ਿਸ਼਼੍ਯੈਃ ਸਾਰ੍ੱਧ੍ਂ ਕਫਰ੍ਨਾਹੂਮਮ੍ ਆਗਮਤ੍ ਕਿਨ੍ਤੁ ਤਤ੍ਰ ਬਹੂਦਿਨਾਨਿ ਆਤਿਸ਼਼੍ਠਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","ਤਦਨਨ੍ਤਰੰ ਯਿਹੂਦਿਯਾਨਾਂ ਨਿਸ੍ਤਾਰੋਤ੍ਸਵੇ ਨਿਕਟਮਾਗਤੇ ਯੀਸ਼ੁ ਰ੍ਯਿਰੂਸ਼ਾਲਮ੍ ਨਗਰਮ੍ ਆਗੱਛਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ਤਤੋ ਮਨ੍ਦਿਰਸ੍ਯ ਮਧ੍ਯੇ ਗੋਮੇਸ਼਼ਪਾਰਾਵਤਵਿਕ੍ਰਯਿਣੋ ਵਾਣਿਜਕ੍ਸ਼਼੍ਚੋਪਵਿਸ਼਼੍ਟਾਨ੍ ਵਿਲੋਕ੍ਯ ");
INSERT INTO sanpun_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ਰੱਜੁਭਿਃ ਕਸ਼ਾਂ ਨਿਰ੍ੰਮਾਯ ਸਰ੍ੱਵਗੋਮੇਸ਼਼ਾਦਿਭਿਃ ਸਾਰ੍ੱਧੰ ਤਾਨ੍ ਮਨ੍ਦਿਰਾਦ੍ ਦੂਰੀਕ੍ਰੁʼਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ਵਣਿਜਾਂ ਮੁਦ੍ਰਾਦਿ ਵਿਕੀਰ੍ੱਯ ਆਸਨਾਨਿ ਨ੍ਯੂਬ੍ਜੀਕ੍ਰੁʼਤ੍ਯ ਪਾਰਾਵਤਵਿਕ੍ਰਯਿਭ੍ਯੋ(ਅ)ਕਥਯਦ੍ ਅਸ੍ਮਾਤ੍ ਸ੍ਥਾਨਾਤ੍ ਸਰ੍ਵਾਣ੍ਯੇਤਾਨਿ ਨਯਤ, ਮਮ ਪਿਤੁਗ੍ਰੁʼਹੰ ਵਾਣਿਜ੍ਯਗ੍ਰੁʼਹੰ ਮਾ ਕਾਰ੍ਸ਼਼੍ਟ| ");
INSERT INTO sanpun_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","ਤਸ੍ਮਾਤ੍ ਤਨ੍ਮਨ੍ਦਿਰਾਰ੍ਥ ਉਦ੍ਯੋਗੋ ਯਸ੍ਤੁ ਸ ਗ੍ਰਸਤੀਵ ਮਾਮ੍| ਇਮਾਂ ਸ਼ਾਸ੍ਤ੍ਰੀਯਲਿਪਿੰ ਸ਼ਿਸ਼਼੍ਯਾਃਸਮਸ੍ਮਰਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ਤਤਃ ਪਰਮ੍ ਯਿਹੂਦੀਯਲੋਕਾ ਯੀਸ਼਼ਿਮਵਦਨ੍ ਤਵਮਿਦ੍ਰੁʼਸ਼ਕਰ੍ੰਮਕਰਣਾਤ੍ ਕਿੰ ਚਿਹ੍ਨਮਸ੍ਮਾਨ੍ ਦਰ੍ਸ਼ਯਸਿ? ");
INSERT INTO sanpun_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ਤਤੋ ਯੀਸ਼ੁਸ੍ਤਾਨਵੋਚਦ੍ ਯੁਸ਼਼੍ਮਾਭਿਰੇ ਤਸ੍ਮਿਨ੍ ਮਨ੍ਦਿਰੇ ਨਾਸ਼ਿਤੇ ਦਿਨਤ੍ਰਯਮਧ੍ਯੇ(ਅ)ਹੰ ਤਦ੍ ਉੱਥਾਪਯਿਸ਼਼੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","ਤਦਾ ਯਿਹੂਦਿਯਾ ਵ੍ਯਾਹਾਰ੍ਸ਼਼ੁਃ, ਏਤਸ੍ਯ ਮਨ੍ਦਿਰਸ ਨਿਰ੍ੰਮਾਣੇਨ ਸ਼਼ਟ੍ਚਤ੍ਵਾਰਿੰਸ਼ਦ੍ ਵਤ੍ਸਰਾ ਗਤਾਃ, ਤ੍ਵੰ ਕਿੰ ਦਿਨਤ੍ਰਯਮਧ੍ਯੇ ਤਦ੍ ਉੱਥਾਪਯਿਸ਼਼੍ਯਸਿ? ");
INSERT INTO sanpun_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","ਕਿਨ੍ਤੁ ਸ ਨਿਜਦੇਹਰੂਪਮਨ੍ਦਿਰੇ ਕਥਾਮਿਮਾਂ ਕਥਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ਸ ਯਦੇਤਾਦ੍ਰੁʼਸ਼ੰ ਗਦਿਤਵਾਨ੍ ਤੱਛਿਸ਼਼੍ਯਾਃ ਸ਼੍ਮਸ਼ਾਨਾਤ੍ ਤਦੀਯੋੱਥਾਨੇ ਸਤਿ ਸ੍ਮ੍ਰੁʼਤ੍ਵਾ ਧਰ੍ੰਮਗ੍ਰਨ੍ਥੇ ਯੀਸ਼ੁਨੋਕ੍ਤਕਥਾਯਾਂ ਚ ਵ੍ਯਸ਼੍ਵਸਿਸ਼਼ੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","ਅਨਨ੍ਤਰੰ ਨਿਸ੍ਤਾਰੋਤ੍ਸਵਸ੍ਯ ਭੋਜ੍ਯਸਮਯੇ ਯਿਰੂਸ਼ਾਲਮ੍ ਨਗਰੇ ਤਤ੍ਕ੍ਰੁਤਾਸ਼੍ਚਰ੍ੱਯਕਰ੍ੰਮਾਣਿ ਵਿਲੋਕ੍ਯ ਬਹੁਭਿਸ੍ਤਸ੍ਯ ਨਾਮਨਿ ਵਿਸ਼੍ਵਸਿਤੰ| ");
INSERT INTO sanpun_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","ਕਿਨ੍ਤੁ ਸ ਤੇਸ਼਼ਾਂ ਕਰੇਸ਼਼ੁ ਸ੍ਵੰ ਨ ਸਮਰ੍ਪਯਤ੍, ਯਤਃ ਸ ਸਰ੍ੱਵਾਨਵੈਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ਸ ਮਾਨਵੇਸ਼਼ੁ ਕਸ੍ਯਚਿਤ੍ ਪ੍ਰਮਾਣੰ ਨਾਪੇਕ੍ਸ਼਼ਤ ਯਤੋ ਮਨੁਜਾਨਾਂ ਮਧ੍ਯੇ ਯਦ੍ਯਦਸ੍ਤਿ ਤੱਤਤ੍ ਸੋਜਾਨਾਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","ਨਿਕਦਿਮਨਾਮਾ ਯਿਹੂਦੀਯਾਨਾਮ੍ ਅਧਿਪਤਿਃ ਫਿਰੂਸ਼ੀ ਕ੍ਸ਼਼ਣਦਾਯਾਂ ");
INSERT INTO sanpun_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ਯੀਸ਼ੌਰਭ੍ਯਰ੍ਣਮ੍ ਆਵ੍ਰਜ੍ਯ ਵ੍ਯਾਹਾਰ੍ਸ਼਼ੀਤ੍, ਹੇ ਗੁਰੋ ਭਵਾਨ੍ ਈਸ਼੍ਵਰਾਦ੍ ਆਗਤ੍ ਏਕ ਉਪਦੇਸ਼਼੍ਟਾ, ਏਤਦ੍ ਅਸ੍ਮਾਭਿਰ੍ਜ੍ਞਾਯਤੇ; ਯਤੋ ਭਵਤਾ ਯਾਨ੍ਯਾਸ਼੍ਚਰ੍ੱਯਕਰ੍ੰਮਾਣਿ ਕ੍ਰਿਯਨ੍ਤੇ ਪਰਮੇਸ਼੍ਵਰਸ੍ਯ ਸਾਹਾੱਯੰ ਵਿਨਾ ਕੇਨਾਪਿ ਤੱਤਤ੍ਕਰ੍ੰਮਾਣਿ ਕਰ੍ੱਤੁੰ ਨ ਸ਼ਕ੍ਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","ਤਦਾ ਯੀਸ਼ੁਰੁੱਤਰੰ ਦੱਤਵਾਨ੍ ਤਵਾਹੰ ਯਥਾਰ੍ਥਤਰੰ ਵ੍ਯਾਹਰਾਮਿ ਪੁਨਰ੍ਜਨ੍ਮਨਿ ਨ ਸਤਿ ਕੋਪਿ ਮਾਨਵ ਈਸ਼੍ਵਰਸ੍ਯ ਰਾਜ੍ਯੰ ਦ੍ਰਸ਼਼੍ਟੁੰ ਨ ਸ਼ਕ੍ਨੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ਤਤੋ ਨਿਕਦੀਮਃ ਪ੍ਰਤ੍ਯਵੋਚਤ੍ ਮਨੁਜੋ ਵ੍ਰੁʼੱਧੋ ਭੂਤ੍ਵਾ ਕਥੰ ਜਨਿਸ਼਼੍ਯਤੇ? ਸ ਕਿੰ ਪੁਨ ਰ੍ਮਾਤ੍ਰੁʼਰ੍ਜਠਰੰ ਪ੍ਰਵਿਸ਼੍ਯ ਜਨਿਤੁੰ ਸ਼ਕ੍ਨੋਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","ਯੀਸ਼ੁਰਵਾਦੀਦ੍ ਯਥਾਰ੍ਥਤਰਮ੍ ਅਹੰ ਕਥਯਾਮਿ ਮਨੁਜੇ ਤੋਯਾਤ੍ਮਭ੍ਯਾਂ ਪੁਨ ਰ੍ਨ ਜਾਤੇ ਸ ਈਸ਼੍ਵਰਸ੍ਯ ਰਾਜ੍ਯੰ ਪ੍ਰਵੇਸ਼਼੍ਟੁੰ ਨ ਸ਼ਕ੍ਨੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","ਮਾਂਸਾਦ੍ ਯਤ੍ ਜਾਯਤੇ ਤਨ੍ ਮਾਂਸਮੇਵ ਤਥਾਤ੍ਮਨੋ ਯੋ ਜਾਯਤੇ ਸ ਆਤ੍ਮੈਵ| ");
INSERT INTO sanpun_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","ਯੁਸ਼਼੍ਮਾਭਿਃ ਪੁਨ ਰ੍ਜਨਿਤਵ੍ਯੰ ਮਮੈਤਸ੍ਯਾਂ ਕਥਾਯਾਮ੍ ਆਸ਼੍ਚਰ੍ਯੰ ਮਾ ਮੰਸ੍ਥਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","ਸਦਾਗਤਿਰ੍ਯਾਂ ਦਿਸ਼ਮਿੱਛਤਿ ਤਸ੍ਯਾਮੇਵ ਦਿਸ਼ਿ ਵਾਤਿ, ਤ੍ਵੰ ਤਸ੍ਯ ਸ੍ਵਨੰ ਸ਼ੁਣੋਸ਼਼ਿ ਕਿਨ੍ਤੁ ਸ ਕੁਤ ਆਯਾਤਿ ਕੁਤ੍ਰ ਯਾਤਿ ਵਾ ਕਿਮਪਿ ਨ ਜਾਨਾਸਿ ਤਦ੍ਵਾਦ੍ ਆਤ੍ਮਨਃ ਸਕਾਸ਼ਾਤ੍ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਮਨੁਜਾਨਾਂ ਜਨ੍ਮ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","ਤਦਾ ਨਿਕਦੀਮਃ ਪ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍ ਏਤਤ੍ ਕਥੰ ਭਵਿਤੁੰ ਸ਼ਕ੍ਨੋਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯਕ੍ਤਵਾਨ੍ ਤ੍ਵਮਿਸ੍ਰਾਯੇਲੋ ਗੁਰੁਰ੍ਭੂਤ੍ਵਾਪਿ ਕਿਮੇਤਾਂ ਕਥਾਂ ਨ ਵੇਤ੍ਸਿ? ");
INSERT INTO sanpun_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","ਤੁਭ੍ਯੰ ਯਥਾਰ੍ਥੰ ਕਥਯਾਮਿ, ਵਯੰ ਯਦ੍ ਵਿਦ੍ਮਸ੍ਤਦ੍ ਵਚ੍ਮਃ ਯੰੱਚ ਪਸ਼੍ਯਾਮਸ੍ਤਸ੍ਯੈਵ ਸਾਕ੍ਸ਼਼੍ਯੰ ਦਦ੍ਮਃ ਕਿਨ੍ਤੁ ਯੁਸ਼਼੍ਮਾਭਿਰਸ੍ਮਾਕੰ ਸਾਕ੍ਸ਼਼ਿਤ੍ਵੰ ਨ ਗ੍ਰੁʼਹ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ਏਤਸ੍ਯ ਸੰਸਾਰਸ੍ਯ ਕਥਾਯਾਂ ਕਥਿਤਾਯਾਂ ਯਦਿ ਯੂਯੰ ਨ ਵਿਸ਼੍ਵਸਿਥ ਤਰ੍ਹਿ ਸ੍ਵਰ੍ਗੀਯਾਯਾਂ ਕਥਾਯਾਂ ਕਥੰ ਵਿਸ਼੍ਵਸਿਸ਼਼੍ਯਥ? ");
INSERT INTO sanpun_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ਯਃ ਸ੍ਵਰ੍ਗੇ(ਅ)ਸ੍ਤਿ ਯੰ ਚ ਸ੍ਵਰ੍ਗਾਦ੍ ਅਵਾਰੋਹਤ੍ ਤੰ ਮਾਨਵਤਨਯੰ ਵਿਨਾ ਕੋਪਿ ਸ੍ਵਰ੍ਗੰ ਨਾਰੋਹਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","ਅਪਰਞ੍ਚ ਮੂਸਾ ਯਥਾ ਪ੍ਰਾਨ੍ਤਰੇ ਸਰ੍ਪੰ ਪ੍ਰੋੱਥਾਪਿਤਵਾਨ੍ ਮਨੁਸ਼਼੍ਯਪੁਤ੍ਰੋ(ਅ)ਪਿ ਤਥੈਵੋੱਥਾਪਿਤਵ੍ਯਃ; ");
INSERT INTO sanpun_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ਤਸ੍ਮਾਦ੍ ਯਃ ਕਸ਼੍ਚਿਤ੍ ਤਸ੍ਮਿਨ੍ ਵਿਸ਼੍ਵਸਿਸ਼਼੍ਯਤਿ ਸੋ(ਅ)ਵਿਨਾਸ਼੍ਯਃ ਸਨ੍ ਅਨਨ੍ਤਾਯੁਃ ਪ੍ਰਾਪ੍ਸ੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ਈਸ਼੍ਵਰ ਇੱਥੰ ਜਗਦਦਯਤ ਯਤ੍ ਸ੍ਵਮਦ੍ਵਿਤੀਯੰ ਤਨਯੰ ਪ੍ਰਾਦਦਾਤ੍ ਤਤੋ ਯਃ ਕਸ਼੍ਚਿਤ੍ ਤਸ੍ਮਿਨ੍ ਵਿਸ਼੍ਵਸਿਸ਼਼੍ਯਤਿ ਸੋ(ਅ)ਵਿਨਾਸ਼੍ਯਃ ਸਨ੍ ਅਨਨ੍ਤਾਯੁਃ ਪ੍ਰਾਪ੍ਸ੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ਈਸ਼੍ਵਰੋ ਜਗਤੋ ਲੋਕਾਨ੍ ਦਣ੍ਡਯਿਤੁੰ ਸ੍ਵਪੁਤ੍ਰੰ ਨ ਪ੍ਰੇਸ਼਼੍ਯ ਤਾਨ੍ ਪਰਿਤ੍ਰਾਤੁੰ ਪ੍ਰੇਸ਼਼ਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ਅਤਏਵ ਯਃ ਕਸ਼੍ਚਿਤ੍ ਤਸ੍ਮਿਨ੍ ਵਿਸ਼੍ਵਸਿਤਿ ਸ ਦਣ੍ਡਾਰ੍ਹੋ ਨ ਭਵਤਿ ਕਿਨ੍ਤੁ ਯਃ ਕਸ਼੍ਚਿਤ੍ ਤਸ੍ਮਿਨ੍ ਨ ਵਿਸ਼੍ਵਸਿਤਿ ਸ ਇਦਾਨੀਮੇਵ ਦਣ੍ਡਾਰ੍ਹੋ ਭਵਤਿ,ਯਤਃ ਸ ਈਸ਼੍ਵਰਸ੍ਯਾਦ੍ਵਿਤੀਯਪੁਤ੍ਰਸ੍ਯ ਨਾਮਨਿ ਪ੍ਰਤ੍ਯਯੰ ਨ ਕਰੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","ਜਗਤੋ ਮਧ੍ਯੇ ਜ੍ਯੋਤਿਃ ਪ੍ਰਾਕਾਸ਼ਤ ਕਿਨ੍ਤੁ ਮਨੁਸ਼਼੍ਯਾਣਾਂ ਕਰ੍ੰਮਣਾਂ ਦ੍ਰੁʼਸ਼਼੍ਟਤ੍ਵਾਤ੍ ਤੇ ਜ੍ਯੋਤਿਸ਼਼ੋਪਿ ਤਿਮਿਰੇ ਪ੍ਰੀਯਨ੍ਤੇ ਏਤਦੇਵ ਦਣ੍ਡਸ੍ਯ ਕਾਰਣਾਂ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ਯਃ ਕੁਕਰ੍ੰਮ ਕਰੋਤਿ ਤਸ੍ਯਾਚਾਰਸ੍ਯ ਦ੍ਰੁʼਸ਼਼੍ਟਤ੍ਵਾਤ੍ ਸ ਜ੍ਯੋਤਿਰ੍ਰੂʼਤੀਯਿਤ੍ਵਾ ਤੰਨਿਕਟੰ ਨਾਯਾਤਿ; ");
INSERT INTO sanpun_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","ਕਿਨ੍ਤੁ ਯਃ ਸਤ੍ਕਰ੍ੰਮ ਕਰੋਤਿ ਤਸ੍ਯ ਸਰ੍ੱਵਾਣਿ ਕਰ੍ੰਮਾਣੀਸ਼੍ਵਰੇਣ ਕ੍ਰੁʼਤਾਨੀਤਿ ਸਥਾ ਪ੍ਰਕਾਸ਼ਤੇ ਤਦਭਿਪ੍ਰਾਯੇਣ ਸ ਜ੍ਯੋਤਿਸ਼਼ਃ ਸੰਨਿਧਿਮ੍ ਆਯਾਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ਤਤਃ ਪਰਮ੍ ਯੀਸ਼ੁਃ ਸ਼ਿਸ਼਼੍ਯੈਃ ਸਾਰ੍ੱਧੰ ਯਿਹੂਦੀਯਦੇਸ਼ੰ ਗਤ੍ਵਾ ਤਤ੍ਰ ਸ੍ਥਿਤ੍ਵਾ ਮੱਜਯਿਤੁਮ੍ ਆਰਭਤ| ");
INSERT INTO sanpun_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","ਤਦਾ ਸ਼ਾਲਮ੍ ਨਗਰਸ੍ਯ ਸਮੀਪਸ੍ਥਾਯਿਨਿ ਐਨਨ੍ ਗ੍ਰਾਮੇ ਬਹੁਤਰਤੋਯਸ੍ਥਿਤੇਸ੍ਤਤ੍ਰ ਯੋਹਨ੍ ਅਮੱਜਯਤ੍ ਤਥਾ ਚ ਲੋਕਾ ਆਗਤ੍ਯ ਤੇਨ ਮੱਜਿਤਾ ਅਭਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ਤਦਾ ਯੋਹਨ੍ ਕਾਰਾਯਾਂ ਨ ਬੱਧਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","ਅਪਰਞ੍ਚ ਸ਼ਾਚਕਰ੍ੰਮਣਿ ਯੋਹਾਨਃ ਸ਼ਿਸ਼਼੍ਯੈਃ ਸਹ ਯਿਹੂਦੀਯਲੋਕਾਨਾਂ ਵਿਵਾਦੇ ਜਾਤੇ, ਤੇ ਯੋਹਨਃ ਸੰੰਨਿਧਿੰ ਗਤ੍ਵਾਕਥਯਨ੍, ");
INSERT INTO sanpun_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ਹੇ ਗੁਰੋ ਯਰ੍ੱਦਨਨਦ੍ਯਾਃ ਪਾਰੇ ਭਵਤਾ ਸਾਰ੍ੱਧੰ ਯ ਆਸੀਤ੍ ਯਸ੍ਮਿੰਸ਼੍ਚ ਭਵਾਨ੍ ਸਾਕ੍ਸ਼਼੍ਯੰ ਪ੍ਰਦਦਾਤ੍ ਪਸ਼੍ਯਤੁ ਸੋਪਿ ਮੱਜਯਤਿ ਸਰ੍ੱਵੇ ਤਸ੍ਯ ਸਮੀਪੰ ਯਾਨ੍ਤਿ ਚ| ");
INSERT INTO sanpun_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ਤਦਾ ਯੋਹਨ੍ ਪ੍ਰਤ੍ਯਵੋਚਦ੍ ਈਸ਼੍ਵਰੇਣ ਨ ਦੱਤੇ ਕੋਪਿ ਮਨੁਜਃ ਕਿਮਪਿ ਪ੍ਰਾਪ੍ਤੁੰ ਨ ਸ਼ਕ੍ਨੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","ਅਹੰ ਅਭਿਸ਼਼ਿਕ੍ਤੋ ਨ ਭਵਾਮਿ ਕਿਨ੍ਤੁ ਤਦਗ੍ਰੇ ਪ੍ਰੇਸ਼਼ਿਤੋਸ੍ਮਿ ਯਾਮਿਮਾਂ ਕਥਾਂ ਕਥਿਤਵਾਨਾਹੰ ਤਤ੍ਰ ਯੂਯੰ ਸਰ੍ੱਵੇ ਸਾਕ੍ਸ਼਼ਿਣਃ ਸ੍ਥ| ");
INSERT INTO sanpun_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","ਯੋ ਜਨਃ ਕਨ੍ਯਾਂ ਲਭਤੇ ਸ ਏਵ ਵਰਃ ਕਿਨ੍ਤੁ ਵਰਸ੍ਯ ਸੰਨਿਧੌ ਦਣ੍ਡਾਯਮਾਨੰ ਤਸ੍ਯ ਯਨ੍ਮਿਤ੍ਰੰ ਤੇਨ ਵਰਸ੍ਯ ਸ਼ਬ੍ਦੇ ਸ਼੍ਰੁਤੇ(ਅ)ਤੀਵਾਹ੍ਲਾਦ੍ਯਤੇ ਮਮਾਪਿ ਤਦ੍ਵਦ੍ ਆਨਨ੍ਦਸਿੱਧਿਰ੍ਜਾਤਾ| ");
INSERT INTO sanpun_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ਤੇਨ ਕ੍ਰਮਸ਼ੋ ਵਰ੍ੱਧਿਤਵ੍ਯੰ ਕਿਨ੍ਤੁ ਮਯਾ ਹ੍ਸਿਤਵ੍ਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ਯ ਊਰ੍ਧ੍ਵਾਦਾਗੱਛਤ੍ ਸ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਮੁਖ੍ਯੋ ਯਸ਼੍ਚ ਸੰਸਾਰਾਦ੍ ਉਦਪਦ੍ਯਤ ਸ ਸਾਂਸਾਰਿਕਃ ਸੰਸਾਰੀਯਾਂ ਕਥਾਞ੍ਚ ਕਥਯਤਿ ਯਸ੍ਤੁ ਸ੍ਵਰ੍ਗਾਦਾਗੱਛਤ੍ ਸ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਮੁਖ੍ਯਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ਸ ਯਦਪਸ਼੍ਯਦਸ਼੍ਰੁʼਣੋੱਚ ਤਸ੍ਮਿੰਨੇਵ ਸਾਕ੍ਸ਼਼੍ਯੰ ਦਦਾਤਿ ਤਥਾਪਿ ਪ੍ਰਾਯਸ਼ਃ ਕਸ਼੍ਚਿਤ੍ ਤਸ੍ਯ ਸਾਕ੍ਸ਼਼੍ਯੰ ਨ ਗ੍ਰੁʼਹ੍ਲਾਤਿ; ");
INSERT INTO sanpun_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ਕਿਨ੍ਤੁ ਯੋ ਗ੍ਰੁʼਹ੍ਲਾਤਿ ਸ ਈਸ਼੍ਵਰਸ੍ਯ ਸਤ੍ਯਵਾਦਿਤ੍ਵੰ ਮੁਦ੍ਰਾਙ੍ਗਿਤੰ ਕਰੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ਈਸ਼੍ਵਰੇਣ ਯਃ ਪ੍ਰੇਰਿਤਃ ਸਏਵ ਈਸ਼੍ਵਰੀਯਕਥਾਂ ਕਥਯਤਿ ਯਤ ਈਸ਼੍ਵਰ ਆਤ੍ਮਾਨੰ ਤਸ੍ਮੈ ਅਪਰਿਮਿਤਮ੍ ਅਦਦਾਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","ਪਿਤਾ ਪੁਤ੍ਰੇ ਸ੍ਨੇਹੰ ਕ੍ਰੁʼਤ੍ਵਾ ਤਸ੍ਯ ਹਸ੍ਤੇ ਸਰ੍ੱਵਾਣਿ ਸਮਰ੍ਪਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ਯਃ ਕਸ਼੍ਚਿਤ੍ ਪੁਤ੍ਰੇ ਵਿਸ਼੍ਵਸਿਤਿ ਸ ਏਵਾਨਨ੍ਤਮ੍ ਪਰਮਾਯੁਃ ਪ੍ਰਾਪ੍ਨੋਤਿ ਕਿਨ੍ਤੁ ਯਃ ਕਸ਼੍ਚਿਤ੍ ਪੁਤ੍ਰੇ ਨ ਵਿਸ਼੍ਵਸਿਤਿ ਸ ਪਰਮਾਯੁਸ਼਼ੋ ਦਰ੍ਸ਼ਨੰ ਨ ਪ੍ਰਾਪ੍ਨੋਤਿ ਕਿਨ੍ਤ੍ਵੀਸ਼੍ਵਰਸ੍ਯ ਕੋਪਭਾਜਨੰ ਭੂਤ੍ਵਾ ਤਿਸ਼਼੍ਠਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","ਯੀਸ਼ੁਃ ਸ੍ਵਯੰ ਨਾਮੱਜਯਤ੍ ਕੇਵਲੰ ਤਸ੍ਯ ਸ਼ਿਸ਼਼੍ਯਾ ਅਮੱਜਯਤ੍ ਕਿਨ੍ਤੁ ਯੋਹਨੋ(ਅ)ਧਿਕਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਸ ਕਰੋਤਿ ਮੱਜਯਤਿ ਚ, ");
INSERT INTO sanpun_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ਫਿਰੂਸ਼ਿਨ ਇਮਾਂ ਵਾਰ੍ੱਤਾਮਸ਼੍ਰੁʼਣ੍ਵਨ੍ ਇਤਿ ਪ੍ਰਭੁਰਵਗਤ੍ਯ ");
INSERT INTO sanpun_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ਯਿਹੂਦੀਯਦੇਸ਼ੰ ਵਿਹਾਯ ਪੁਨ ਰ੍ਗਾਲੀਲਮ੍ ਆਗਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ਤਤਃ ਸ਼ੋਮਿਰੋਣਪ੍ਰਦੇਸ਼ਸ੍ਯ ਮਦ੍ਯੇਨ ਤੇਨ ਗਨ੍ਤਵ੍ਯੇ ਸਤਿ ");
INSERT INTO sanpun_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ਯਾਕੂਬ੍ ਨਿਜਪੁਤ੍ਰਾਯ ਯੂਸ਼਼ਫੇ ਯਾਂ ਭੂਮਿਮ੍ ਅਦਦਾਤ੍ ਤਤ੍ਸਮੀਪਸ੍ਥਾਯਿ ਸ਼ੋਮਿਰੋਣਪ੍ਰਦੇਸ਼ਸ੍ਯ ਸੁਖਾਰ੍ ਨਾਮ੍ਨਾ ਵਿਖ੍ਯਾਤਸ੍ਯ ਨਗਰਸ੍ਯ ਸੰਨਿਧਾਵੁਪਾਸ੍ਥਾਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ਤਤ੍ਰ ਯਾਕੂਬਃ ਪ੍ਰਹਿਰਾਸੀਤ੍; ਤਦਾ ਦ੍ਵਿਤੀਯਯਾਮਵੇਲਾਯਾਂ ਜਾਤਾਯਾਂ ਸ ਮਾਰ੍ਗੇ ਸ਼੍ਰਮਾਪੰਨਸ੍ਤਸ੍ਯ ਪ੍ਰਹੇਃ ਪਾਰ੍ਸ਼੍ਵੇ ਉਪਾਵਿਸ਼ਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ਏਤਰ੍ਹਿ ਕਾਚਿਤ੍ ਸ਼ੋਮਿਰੋਣੀਯਾ ਯੋਸ਼਼ਿਤ੍ ਤੋਯੋੱਤੋਲਨਾਰ੍ਥਮ੍ ਤਤ੍ਰਾਗਮਤ੍ ");
INSERT INTO sanpun_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","ਤਦਾ ਸ਼ਿਸ਼਼੍ਯਾਃ ਖਾਦ੍ਯਦ੍ਰਵ੍ਯਾਣਿ ਕ੍ਰੇਤੁੰ ਨਗਰਮ੍ ਅਗੱਛਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","ਯੀਸ਼ੁਃ ਸ਼ੋਮਿਰੋਣੀਯਾਂ ਤਾਂ ਯੋਸ਼਼ਿਤਮ੍ ਵ੍ਯਾਹਾਰ੍ਸ਼਼ੀਤ੍ ਮਹ੍ਯੰ ਕਿਞ੍ਚਿਤ੍ ਪਾਨੀਯੰ ਪਾਤੁੰ ਦੇਹਿ| ਕਿਨ੍ਤੁ ਸ਼ੋਮਿਰੋਣੀਯੈਃ ਸਾਕੰ ਯਿਹੂਦੀਯਲੋਕਾ ਨ ਵ੍ਯਵਾਹਰਨ੍ ਤਸ੍ਮਾੱਧੇਤੋਃ ਸਾਕਥਯਤ੍ ਸ਼ੋਮਿਰੋਣੀਯਾ ਯੋਸ਼਼ਿਤਦਹੰ ਤ੍ਵੰ ਯਿਹੂਦੀਯੋਸਿ ਕਥੰ ਮੱਤਃ ਪਾਨੀਯੰ ਪਾਤੁਮ੍ ਇੱਛਸਿ? ");
INSERT INTO sanpun_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ਤਤੋ ਯੀਸ਼ੁਰਵਦਦ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਯੱਦਾਨੰ ਤਤ੍ਕੀਦ੍ਰੁʼਕ੍ ਪਾਨੀਯੰ ਪਾਤੁੰ ਮਹ੍ਯੰ ਦੇਹਿ ਯ ਇੱਥੰ ਤ੍ਵਾਂ ਯਾਚਤੇ ਸ ਵਾ ਕ ਇਤਿ ਚੇਦਜ੍ਞਾਸ੍ਯਥਾਸ੍ਤਰ੍ਹਿ ਤਮਯਾਚਿਸ਼਼੍ਯਥਾਃ ਸ ਚ ਤੁਭ੍ਯਮਮ੍ਰੁʼਤੰ ਤੋਯਮਦਾਸ੍ਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","ਤਦਾ ਸਾ ਸੀਮਨ੍ਤਿਨੀ ਭਾਸ਼਼ਿਤਵਤਿ, ਹੇ ਮਹੇੱਛ ਪ੍ਰਹਿਰ੍ਗਮ੍ਭੀਰੋ ਭਵਤੋ ਨੀਰੋੱਤੋਲਨਪਾਤ੍ਰੰ ਨਾਸ੍ਤੀ ਚ ਤਸ੍ਮਾਤ੍ ਤਦਮ੍ਰੁʼਤੰ ਕੀਲਾਲੰ ਕੁਤਃ ਪ੍ਰਾਪ੍ਸ੍ਯਸਿ? ");
INSERT INTO sanpun_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","ਯੋਸ੍ਮਭ੍ਯਮ੍ ਇਮਮਨ੍ਧੂੰ ਦਦੌ, ਯਸ੍ਯ ਚ ਪਰਿਜਨਾ ਗੋਮੇਸ਼਼ਾਦਯਸ਼੍ਚ ਸਰ੍ੱਵੇ(ਅ)ਸ੍ਯ ਪ੍ਰਹੇਃ ਪਾਨੀਯੰ ਪਪੁਰੇਤਾਦ੍ਰੁʼਸ਼ੋ ਯੋਸ੍ਮਾਕੰ ਪੂਰ੍ੱਵਪੁਰੁਸ਼਼ੋ ਯਾਕੂਬ੍ ਤਸ੍ਮਾਦਪਿ ਭਵਾਨ੍ ਮਹਾਨ੍ ਕਿੰ? ");
INSERT INTO sanpun_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ਤਤੋ ਯੀਸ਼ੁਰਕਥਯਦ੍ ਇਦੰ ਪਾਨੀਯੰ ਸਃ ਪਿਵਤਿ ਸ ਪੁਨਸ੍ਤ੍ਰੁʼਸ਼਼ਾਰ੍ੱਤੋ ਭਵਿਸ਼਼੍ਯਤਿ, ");
INSERT INTO sanpun_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ਕਿਨ੍ਤੁ ਮਯਾ ਦੱਤੰ ਪਾਨੀਯੰ ਯਃ ਪਿਵਤਿ ਸ ਪੁਨਃ ਕਦਾਪਿ ਤ੍ਰੁʼਸ਼਼ਾਰ੍ੱਤੋ ਨ ਭਵਿਸ਼਼੍ਯਤਿ| ਮਯਾ ਦੱਤਮ੍ ਇਦੰ ਤੋਯੰ ਤਸ੍ਯਾਨ੍ਤਃ ਪ੍ਰਸ੍ਰਵਣਰੂਪੰ ਭੂਤ੍ਵਾ ਅਨਨ੍ਤਾਯੁਰ੍ਯਾਵਤ੍ ਸ੍ਰੋਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","ਤਦਾ ਸਾ ਵਨਿਤਾਕਥਯਤ੍ ਹੇ ਮਹੇੱਛ ਤਰ੍ਹਿ ਮਮ ਪੁਨਃ ਪੀਪਾਸਾ ਯਥਾ ਨ ਜਾਯਤੇ ਤੋਯੋੱਤੋਲਨਾਯ ਯਥਾਤ੍ਰਾਗਮਨੰ ਨ ਭਵਤਿ ਚ ਤਦਰ੍ਥੰ ਮਹ੍ਯੰ ਤੱਤੋਯੰ ਦੇਹੀ| ");
INSERT INTO sanpun_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ਤਤੋ ਯੀਸ਼ੂਰਵਦਦ੍ਯਾਹਿ ਤਵ ਪਤਿਮਾਹੂਯ ਸ੍ਥਾਨੇ(ਅ)ਤ੍ਰਾਗੱਛ| ");
INSERT INTO sanpun_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","ਸਾ ਵਾਮਾਵਦਤ੍ ਮਮ ਪਤਿਰ੍ਨਾਸ੍ਤਿ| ਯੀਸ਼ੁਰਵਦਤ੍ ਮਮ ਪਤਿਰ੍ਨਾਸ੍ਤੀਤਿ ਵਾਕ੍ਯੰ ਭਦ੍ਰਮਵੋਚਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ਯਤਸ੍ਤਵ ਪਞ੍ਚ ਪਤਯੋਭਵਨ੍ ਅਧੁਨਾ ਤੁ ਤ੍ਵਯਾ ਸਾਰ੍ੱਧੰ ਯਸ੍ਤਿਸ਼਼੍ਠਤਿ ਸ ਤਵ ਭਰ੍ੱਤਾ ਨ ਵਾਕ੍ਯਮਿਦੰ ਸਤ੍ਯਮਵਾਦਿਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","ਤਦਾ ਸਾ ਮਹਿਲਾ ਗਦਿਤਵਤਿ ਹੇ ਮਹੇੱਛ ਭਵਾਨ੍ ਏਕੋ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦੀਤਿ ਬੁੱਧੰ ਮਯਾ| ");
INSERT INTO sanpun_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","ਅਸ੍ਮਾਕੰ ਪਿਤ੍ਰੁʼਲੋਕਾ ਏਤਸ੍ਮਿਨ੍ ਸ਼ਿਲੋੱਚਯੇ(ਅ)ਭਜਨ੍ਤ, ਕਿਨ੍ਤੁ ਭਵਦ੍ਭਿਰੁਚ੍ਯਤੇ ਯਿਰੂਸ਼ਾਲਮ੍ ਨਗਰੇ ਭਜਨਯੋਗ੍ਯੰ ਸ੍ਥਾਨਮਾਸ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","ਯੀਸ਼ੁਰਵੋਚਤ੍ ਹੇ ਯੋਸ਼਼ਿਤ੍ ਮਮ ਵਾਕ੍ਯੇ ਵਿਸ਼੍ਵਸਿਹਿ ਯਦਾ ਯੂਯੰ ਕੇਵਲਸ਼ੈਲੇ(ਅ)ਸ੍ਮਿਨ੍ ਵਾ ਯਿਰੂਸ਼ਾਲਮ੍ ਨਗਰੇ ਪਿਤੁਰ੍ਭਜਨੰ ਨ ਕਰਿਸ਼਼੍ਯਧ੍ਵੇ ਕਾਲ ਏਤਾਦ੍ਰੁʼਸ਼ ਆਯਾਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ਯੂਯੰ ਯੰ ਭਜਧ੍ਵੇ ਤੰ ਨ ਜਾਨੀਥ, ਕਿਨ੍ਤੁ ਵਯੰ ਯੰ ਭਜਾਮਹੇ ਤੰ ਜਾਨੀਮਹੇ, ਯਤੋ ਯਿਹੂਦੀਯਲੋਕਾਨਾਂ ਮਧ੍ਯਾਤ੍ ਪਰਿਤ੍ਰਾਣੰ ਜਾਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","ਕਿਨ੍ਤੁ ਯਦਾ ਸਤ੍ਯਭਕ੍ਤਾ ਆਤ੍ਮਨਾ ਸਤ੍ਯਰੂਪੇਣ ਚ ਪਿਤੁਰ੍ਭਜਨੰ ਕਰਿਸ਼਼੍ਯਨ੍ਤੇ ਸਮਯ ਏਤਾਦ੍ਰੁʼਸ਼ ਆਯਾਤਿ, ਵਰਮ੍ ਇਦਾਨੀਮਪਿ ਵਿਦ੍ਯਤੇ ; ਯਤ ਏਤਾਦ੍ਰੁʼਸ਼ੋ ਭਤ੍ਕਾਨ੍ ਪਿਤਾ ਚੇਸ਼਼੍ਟਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ਈਸ਼੍ਵਰ ਆਤ੍ਮਾ; ਤਤਸ੍ਤਸ੍ਯ ਯੇ ਭਕ੍ਤਾਸ੍ਤੈਃ ਸ ਆਤ੍ਮਨਾ ਸਤ੍ਯਰੂਪੇਣ ਚ ਭਜਨੀਯਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","ਤਦਾ ਸਾ ਮਹਿਲਾਵਾਦੀਤ੍ ਖ੍ਰੀਸ਼਼੍ਟਨਾਮ੍ਨਾ ਵਿਖ੍ਯਾਤੋ(ਅ)ਭਿਸ਼਼ਿਕ੍ਤਃ ਪੁਰੁਸ਼਼ ਆਗਮਿਸ਼਼੍ਯਤੀਤਿ ਜਾਨਾਮਿ ਸ ਚ ਸਰ੍ੱਵਾਃ ਕਥਾ ਅਸ੍ਮਾਨ੍ ਜ੍ਞਾਪਯਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ਤਤੋ ਯੀਸ਼ੁਰਵਦਤ੍ ਤ੍ਵਯਾ ਸਾਰ੍ੱਧੰ ਕਥਨੰ ਕਰੋਮਿ ਯੋ(ਅ)ਹਮ੍ ਅਹਮੇਵ ਸ ਪੁਰੁਸ਼਼ਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ਏਤਸ੍ਮਿਨ੍ ਸਮਯੇ ਸ਼ਿਸ਼਼੍ਯਾ ਆਗਤ੍ਯ ਤਥਾ ਸ੍ਤ੍ਰਿਯਾ ਸਾਰ੍ੱਧੰ ਤਸ੍ਯ ਕਥੋਪਕਥਨੇ ਮਹਾਸ਼੍ਚਰ੍ੱਯਮ੍ ਅਮਨ੍ਯਨ੍ਤ ਤਥਾਪਿ ਭਵਾਨ੍ ਕਿਮਿੱਛਤਿ? ਯਦ੍ਵਾ ਕਿਮਰ੍ਥਮ੍ ਏਤਯਾ ਸਾਰ੍ੱਧੰ ਕਥਾਂ ਕਥਯਤਿ? ਇਤਿ ਕੋਪਿ ਨਾਪ੍ਰੁʼੱਛਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","ਤਤਃ ਪਰੰ ਸਾ ਨਾਰੀ ਕਲਸ਼ੰ ਸ੍ਥਾਪਯਿਤ੍ਵਾ ਨਗਰਮਧ੍ਯੰ ਗਤ੍ਵਾ ਲੋਕੇਭ੍ਯੋਕਥਾਯਦ੍ ");
INSERT INTO sanpun_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","ਅਹੰ ਯਦ੍ਯਤ੍ ਕਰ੍ੰਮਾਕਰਵੰ ਤਤ੍ਸਰ੍ੱਵੰ ਮਹ੍ਯਮਕਥਯਦ੍ ਏਤਾਦ੍ਰੁʼਸ਼ੰ ਮਾਨਵਮੇਕਮ੍ ਆਗਤ੍ਯ ਪਸ਼੍ਯਤ ਰੁ ਕਿਮ੍ ਅਭਿਸ਼਼ਿਕ੍ਤੋ ਨ ਭਵਤਿ ? ");
INSERT INTO sanpun_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ਤਤਸ੍ਤੇ ਨਗਰਾਦ੍ ਬਹਿਰਾਗਤ੍ਯ ਤਾਤਸ੍ਯ ਸਮੀਪਮ੍ ਆਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ਏਤਰ੍ਹਿ ਸ਼ਿਸ਼਼੍ਯਾਃ ਸਾਧਯਿਤ੍ਵਾ ਤੰ ਵ੍ਯਾਹਾਰ੍ਸ਼਼ੁਃ ਹੇ ਗੁਰੋ ਭਵਾਨ੍ ਕਿਞ੍ਚਿਦ੍ ਭੂਕ੍ਤਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ਤਤਃ ਸੋਵਦਦ੍ ਯੁਸ਼਼੍ਮਾਭਿਰ੍ਯੰਨ ਜ੍ਞਾਯਤੇ ਤਾਦ੍ਰੁʼਸ਼ੰ ਭਕ੍ਸ਼਼੍ਯੰ ਮਮਾਸ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","ਤਦਾ ਸ਼ਿਸ਼਼੍ਯਾਃ ਪਰਸ੍ਪਰੰ ਪ੍ਰਸ਼਼੍ਟੁਮ੍ ਆਰਮ੍ਭਨ੍ਤ, ਕਿਮਸ੍ਮੈ ਕੋਪਿ ਕਿਮਪਿ ਭਕ੍ਸ਼਼੍ਯਮਾਨੀਯ ਦੱਤਵਾਨ੍? ");
INSERT INTO sanpun_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","ਯੀਸ਼ੁਰਵੋਚਤ੍ ਮਤ੍ਪ੍ਰੇਰਕਸ੍ਯਾਭਿਮਤਾਨੁਰੂਪਕਰਣੰ ਤਸ੍ਯੈਵ ਕਰ੍ੰਮਸਿੱਧਿਕਾਰਣਞ੍ਚ ਮਮ ਭਕ੍ਸ਼਼੍ਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","ਮਾਸਚਤੁਸ਼਼੍ਟਯੇ ਜਾਤੇ ਸ਼ਸ੍ਯਕਰ੍ੱਤਨਸਮਯੋ ਭਵਿਸ਼਼੍ਯਤੀਤਿ ਵਾਕ੍ਯੰ ਯੁਸ਼਼੍ਮਾਭਿਃ ਕਿੰ ਨੋਦ੍ਯਤੇ? ਕਿਨ੍ਤ੍ਵਹੰ ਵਦਾਮਿ, ਸ਼ਿਰ ਉੱਤੋਲ੍ਯ ਕ੍ਸ਼਼ੇਤ੍ਰਾਣਿ ਪ੍ਰਤਿ ਨਿਰੀਕ੍ਸ਼਼੍ਯ ਪਸ਼੍ਯਤ, ਇਦਾਨੀਂ ਕਰ੍ੱਤਨਯੋਗ੍ਯਾਨਿ ਸ਼ੁਕ੍ਲਵਰ੍ਣਾਨ੍ਯਭਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","ਯਸ਼੍ਛਿਨੱਤਿ ਸ ਵੇਤਨੰ ਲਭਤੇ ਅਨਨ੍ਤਾਯੁਃਸ੍ਵਰੂਪੰ ਸ਼ਸ੍ਯੰ ਸ ਗ੍ਰੁʼਹ੍ਲਾਤਿ ਚ, ਤੇਨੈਵ ਵਪ੍ਤਾ ਛੇੱਤਾ ਚ ਯੁਗਪਦ੍ ਆਨਨ੍ਦਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ਇੱਥੰ ਸਤਿ ਵਪਤ੍ਯੇਕਸ਼੍ਛਿਨਤ੍ਯਨ੍ਯ ਇਤਿ ਵਚਨੰ ਸਿੱਧ੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","ਯਤ੍ਰ ਯੂਯੰ ਨ ਪਰ੍ੱਯਸ਼੍ਰਾਮ੍ਯਤ ਤਾਦ੍ਰੁʼਸ਼ੰ ਸ਼ਸ੍ਯੰ ਛੇੱਤੁੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਪ੍ਰੈਰਯਮ੍ ਅਨ੍ਯੇ ਜਨਾਃਪਰ੍ੱਯਸ਼੍ਰਾਮ੍ਯਨ੍ ਯੂਯੰ ਤੇਸ਼਼ਾਂ ਸ਼੍ਰਗਸ੍ਯ ਫਲਮ੍ ਅਲਭਧ੍ਵਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ਯਸ੍ਮਿਨ੍ ਕਾਲੇ ਯਦ੍ਯਤ੍ ਕਰ੍ੰਮਾਕਾਰ੍ਸ਼਼ੰ ਤਤ੍ਸਰ੍ੱਵੰ ਸ ਮਹ੍ਯਮ੍ ਅਕਥਯਤ੍ ਤਸ੍ਯਾ ਵਨਿਤਾਯਾ ਇਦੰ ਸਾਕ੍ਸ਼਼੍ਯਵਾਕ੍ਯੰ ਸ਼੍ਰੁਤ੍ਵਾ ਤੰਨਗਰਨਿਵਾਸਿਨੋ ਬਹਵਃ ਸ਼ੋਮਿਰੋਣੀਯਲੋਕਾ ਵ੍ਯਸ਼੍ਵਸਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ਤਥਾ ਚ ਤਸ੍ਯਾਨ੍ਤਿਕੇ ਸਮੁਪਸ੍ਥਾਯ ਸ੍ਵੇਸ਼਼ਾਂ ਸੰਨਿਧੌ ਕਤਿਚਿਦ੍ ਦਿਨਾਨਿ ਸ੍ਥਾਤੁੰ ਤਸ੍ਮਿਨ੍ ਵਿਨਯਮ੍ ਅਕੁਰ੍ੱਵਾਨ ਤਸ੍ਮਾਤ੍ ਸ ਦਿਨਦ੍ਵਯੰ ਤਤ੍ਸ੍ਥਾਨੇ ਨ੍ਯਵਸ਼਼੍ਟਤ੍ ");
INSERT INTO sanpun_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ਤਤਸ੍ਤਸ੍ਯੋਪਦੇਸ਼ੇਨ ਬਹਵੋ(ਅ)ਪਰੇ ਵਿਸ਼੍ਵਸ੍ਯ ");
INSERT INTO sanpun_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ਤਾਂ ਯੋਸ਼਼ਾਮਵਦਨ੍ ਕੇਵਲੰ ਤਵ ਵਾਕ੍ਯੇਨ ਪ੍ਰਤੀਮ ਇਤਿ ਨ, ਕਿਨ੍ਤੁ ਸ ਜਗਤੋ(ਅ)ਭਿਸ਼਼ਿਕ੍ਤਸ੍ਤ੍ਰਾਤੇਤਿ ਤਸ੍ਯ ਕਥਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਵਯੰ ਸ੍ਵਯਮੇਵਾਜ੍ਞਾਸਮਹਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","ਸ੍ਵਦੇਸ਼ੇ ਭਵਿਸ਼਼੍ਯਦ੍ਵਕ੍ਤੁਃ ਸਤ੍ਕਾਰੋ ਨਾਸ੍ਤੀਤਿ ਯਦ੍ਯਪਿ ਯੀਸ਼ੁਃ ਪ੍ਰਮਾਣੰ ਦਤ੍ਵਾਕਥਯਤ੍ ");
INSERT INTO sanpun_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","ਤਥਾਪਿ ਦਿਵਸਦ੍ਵਯਾਤ੍ ਪਰੰ ਸ ਤਸ੍ਮਾਤ੍ ਸ੍ਥਾਨਾਦ੍ ਗਾਲੀਲੰ ਗਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ਅਨਨ੍ਤਰੰ ਯੇ ਗਾਲੀਲੀ ਲਿਯਲੋਕਾ ਉਤ੍ਸਵੇ ਗਤਾ ਉਤ੍ਸਵਸਮਯੇ ਯਿਰੂਸ਼ਲਮ੍ ਨਗਰੇ ਤਸ੍ਯ ਸਰ੍ੱਵਾਃ ਕ੍ਰਿਯਾ ਅਪਸ਼੍ਯਨ੍ ਤੇ ਗਾਲੀਲਮ੍ ਆਗਤੰ ਤਮ੍ ਆਗ੍ਰੁʼਹ੍ਲਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ਤਤਃ ਪਰਮ੍ ਯੀਸ਼ੁ ਰ੍ਯਸ੍ਮਿਨ੍ ਕਾੰਨਾਨਗਰੇ ਜਲੰ ਦ੍ਰਾਕ੍ਸ਼਼ਾਰਸਮ੍ ਆਕਰੋਤ੍ ਤਤ੍ ਸ੍ਥਾਨੰ ਪੁਨਰਗਾਤ੍| ਤਸ੍ਮਿੰਨੇਵ ਸਮਯੇ ਕਸ੍ਯਚਿਦ੍ ਰਾਜਸਭਾਸ੍ਤਾਰਸ੍ਯ ਪੁਤ੍ਰਃ ਕਫਰ੍ਨਾਹੂਮਪੁਰੀ ਰੋਗਗ੍ਰਸ੍ਤ ਆਸੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ਸ ਯੇਹੂਦੀਯਦੇਸ਼ਾਦ੍ ਯੀਸ਼ੋ ਰ੍ਗਾਲੀਲਾਗਮਨਵਾਰ੍ੱਤਾਂ ਨਿਸ਼ਮ੍ਯ ਤਸ੍ਯ ਸਮੀਪੰ ਗਤ੍ਵਾ ਪ੍ਰਾਰ੍ਥ੍ਯ ਵ੍ਯਾਹ੍ਰੁʼਤਵਾਨ੍ ਮਮ ਪੁਤ੍ਰਸ੍ਯ ਪ੍ਰਾਯੇਣ ਕਾਲ ਆਸੰਨਃ ਭਵਾਨ੍ ਆਗਤ੍ਯ ਤੰ ਸ੍ਵਸ੍ਥੰ ਕਰੋਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","ਤਦਾ ਯੀਸ਼ੁਰਕਥਯਦ੍ ਆਸ਼੍ਚਰ੍ੱਯੰ ਕਰ੍ੰਮ ਚਿਤ੍ਰੰ ਚਿਹ੍ਨੰ ਚ ਨ ਦ੍ਰੁʼਸ਼਼੍ਟਾ ਯੂਯੰ ਨ ਪ੍ਰਤ੍ਯੇਸ਼਼੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ਤਤਃ ਸ ਸਭਾਸਦਵਦਤ੍ ਹੇ ਮਹੇੱਛ ਮਮ ਪੁਤ੍ਰੇ ਨ ਮ੍ਰੁʼਤੇ ਭਵਾਨਾਗੱਛਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","ਯੀਸ਼ੁਸ੍ਤਮਵਦਦ੍ ਗੱਛ ਤਵ ਪੁਤ੍ਰੋ(ਅ)ਜੀਵੀਤ੍ ਤਦਾ ਯੀਸ਼ੁਨੋਕ੍ਤਵਾਕ੍ਯੇ ਸ ਵਿਸ਼੍ਵਸ੍ਯ ਗਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ਗਮਨਕਾਲੇ ਮਾਰ੍ਗਮਧ੍ਯੇ ਦਾਸਾਸ੍ਤੰ ਸਾਕ੍ਸ਼਼ਾਤ੍ਪ੍ਰਾਪ੍ਯਾਵਦਨ੍ ਭਵਤਃ ਪੁਤ੍ਰੋ(ਅ)ਜੀਵੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ਤਤਃ ਕੰ ਕਾਲਮਾਰਭ੍ਯ ਰੋਗਪ੍ਰਤੀਕਾਰਾਰਮ੍ਭੋ ਜਾਤਾ ਇਤਿ ਪ੍ਰੁʼਸ਼਼੍ਟੇ ਤੈਰੁਕ੍ਤੰ ਹ੍ਯਃ ਸਾਰ੍ੱਧਦਣ੍ਡਦ੍ਵਯਾਧਿਕਦ੍ਵਿਤੀਯਯਾਮੇ ਤਸ੍ਯ ਜ੍ਵਰਤ੍ਯਾਗੋ(ਅ)ਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","ਤਦਾ ਯੀਸ਼ੁਸ੍ਤਸ੍ਮਿਨ੍ ਕ੍ਸ਼਼ਣੇ ਪ੍ਰੋਕ੍ਤਵਾਨ੍ ਤਵ ਪੁਤ੍ਰੋ(ਅ)ਜੀਵੀਤ੍ ਪਿਤਾ ਤਦ੍ਬੁੱਧ੍ਵਾ ਸਪਰਿਵਾਰੋ ਵ੍ਯਸ਼੍ਵਸੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ਯਿਹੂਦੀਯਦੇਸ਼ਾਦ੍ ਆਗਤ੍ਯ ਗਾਲੀਲਿ ਯੀਸ਼ੁਰੇਤਦ੍ ਦ੍ਵਿਤੀਯਮ੍ ਆਸ਼੍ਚਰ੍ੱਯਕਰ੍ੰਮਾਕਰੋਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ਤਤਃ ਪਰੰ ਯਿਹੂਦੀਯਾਨਾਮ੍ ਉਤ੍ਸਵ ਉਪਸ੍ਥਿਤੇ ਯੀਸ਼ੁ ਰ੍ਯਿਰੂਸ਼ਾਲਮੰ ਗਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","ਤਸ੍ਮਿੰਨਗਰੇ ਮੇਸ਼਼ਨਾਮ੍ਨੋ ਦ੍ਵਾਰਸ੍ਯ ਸਮੀਪੇ ਇਬ੍ਰੀਯਭਾਸ਼਼ਯਾ ਬੈਥੇਸ੍ਦਾ ਨਾਮ੍ਨਾ ਪਿਸ਼਼੍ਕਰਿਣੀ ਪਞ੍ਚਘੱਟਯੁਕ੍ਤਾਸੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ਤਸ੍ਯਾਸ੍ਤੇਸ਼਼ੁ ਘੱਟੇਸ਼਼ੁ ਕਿਲਾਲਕਮ੍ਪਨਮ੍ ਅਪੇਕ੍ਸ਼਼੍ਯ ਅਨ੍ਧਖਞ੍ਚਸ਼ੁਸ਼਼੍ਕਾਙ੍ਗਾਦਯੋ ਬਹਵੋ ਰੋਗਿਣਃ ਪਤਨ੍ਤਸ੍ਤਿਸ਼਼੍ਠਨ੍ਤਿ ਸ੍ਮ| ");
INSERT INTO sanpun_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ਯਤੋ ਵਿਸ਼ੇਸ਼਼ਕਾਲੇ ਤਸ੍ਯ ਸਰਸੋ ਵਾਰਿ ਸ੍ਵਰ੍ਗੀਯਦੂਤ ਏਤ੍ਯਾਕਮ੍ਪਯਤ੍ ਤਤ੍ਕੀਲਾਲਕਮ੍ਪਨਾਤ੍ ਪਰੰ ਯਃ ਕਸ਼੍ਚਿਦ੍ ਰੋਗੀ ਪ੍ਰਥਮੰ ਪਾਨੀਯਮਵਾਰੋਹਤ੍ ਸ ਏਵ ਤਤ੍ਕ੍ਸ਼਼ਣਾਦ੍ ਰੋਗਮੁਕ੍ਤੋ(ਅ)ਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","ਤਦਾਸ਼਼੍ਟਾਤ੍ਰਿੰਸ਼ਦ੍ਵਰ੍ਸ਼਼ਾਣਿ ਯਾਵਦ੍ ਰੋਗਗ੍ਰਸ੍ਤ ਏਕਜਨਸ੍ਤਸ੍ਮਿਨ੍ ਸ੍ਥਾਨੇ ਸ੍ਥਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ਯੀਸ਼ੁਸ੍ਤੰ ਸ਼ਯਿਤੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਬਹੁਕਾਲਿਕਰੋਗੀਤਿ ਜ੍ਞਾਤ੍ਵਾ ਵ੍ਯਾਹ੍ਰੁʼਤਵਾਨ੍ ਤ੍ਵੰ ਕਿੰ ਸ੍ਵਸ੍ਥੋ ਬੁਭੂਸ਼਼ਸਿ? ");
INSERT INTO sanpun_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ਤਤੋ ਰੋਗੀ ਕਥਿਤਵਾਨ੍ ਹੇ ਮਹੇੱਛ ਯਦਾ ਕੀਲਾਲੰ ਕਮ੍ਪਤੇ ਤਦਾ ਮਾਂ ਪੁਸ਼਼੍ਕਰਿਣੀਮ੍ ਅਵਰੋਹਯਿਤੁੰ ਮਮ ਕੋਪਿ ਨਾਸ੍ਤਿ, ਤਸ੍ਮਾਨ੍ ਮਮ ਗਮਨਕਾਲੇ ਕਸ਼੍ਚਿਦਨ੍ਯੋ(ਅ)ਗ੍ਰੋ ਗਤ੍ਵਾ ਅਵਰੋਹਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","ਤਦਾ ਯੀਸ਼ੁਰਕਥਯਦ੍ ਉੱਤਿਸ਼਼੍ਠ, ਤਵ ਸ਼ੱਯਾਮੁੱਤੋਲ੍ਯ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਯਾਹਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","ਸ ਤਤ੍ਕ੍ਸ਼਼ਣਾਤ੍ ਸ੍ਵਸ੍ਥੋ ਭੂਤ੍ਵਾ ਸ਼ੱਯਾਮੁੱਤੋਲ੍ਯਾਦਾਯ ਗਤਵਾਨ੍ ਕਿਨ੍ਤੁ ਤੱਦਿਨੰ ਵਿਸ਼੍ਰਾਮਵਾਰਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ਤਸ੍ਮਾਦ੍ ਯਿਹੂਦੀਯਾਃ ਸ੍ਵਸ੍ਥੰ ਨਰੰ ਵ੍ਯਾਹਰਨ੍ ਅਦ੍ਯ ਵਿਸ਼੍ਰਾਮਵਾਰੇ ਸ਼ਯਨੀਯਮਾਦਾਯ ਨ ਯਾਤਵ੍ਯਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","ਤਤਃ ਸ ਪ੍ਰਤ੍ਯਵੋਚਦ੍ ਯੋ ਮਾਂ ਸ੍ਵਸ੍ਥਮ੍ ਅਕਾਰ੍ਸ਼਼ੀਤ੍ ਸ਼ਯਨੀਯਮ੍ ਉੱਤੋਲ੍ਯਾਦਾਯ ਯਾਤੁੰ ਮਾਂ ਸ ਏਵਾਦਿਸ਼ਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ਤਦਾ ਤੇ(ਅ)ਪ੍ਰੁʼੱਛਨ੍ ਸ਼ਯਨੀਯਮ੍ ਉੱਤੋਲ੍ਯਾਦਾਯ ਯਾਤੁੰ ਯ ਆਜ੍ਞਾਪਯਤ੍ ਸ ਕਃ? ");
INSERT INTO sanpun_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","ਕਿਨ੍ਤੁ ਸ ਕ ਇਤਿ ਸ੍ਵਸ੍ਥੀਭੂਤੋ ਨਾਜਾਨਾਦ੍ ਯਤਸ੍ਤਸ੍ਮਿਨ੍ ਸ੍ਥਾਨੇ ਜਨਤਾਸੱਤ੍ਵਾਦ੍ ਯੀਸ਼ੁਃ ਸ੍ਥਾਨਾਨ੍ਤਰਮ੍ ਆਗਮਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","ਤਤਃ ਪਰੰ ਯੇਸ਼ੁ ਰ੍ਮਨ੍ਦਿਰੇ ਤੰ ਨਰੰ ਸਾਕ੍ਸ਼਼ਾਤ੍ਪ੍ਰਾਪ੍ਯਾਕਥਯਤ੍ ਪਸ਼੍ਯੇਦਾਨੀਮ੍ ਅਨਾਮਯੋ ਜਾਤੋਸਿ ਯਥਾਧਿਕਾ ਦੁਰ੍ਦਸ਼ਾ ਨ ਘਟਤੇ ਤੱਧੇਤੋਃ ਪਾਪੰ ਕਰ੍ੰਮ ਪੁਨਰ੍ਮਾਕਾਰ੍ਸ਼਼ੀਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ਤਤਃ ਸ ਗਤ੍ਵਾ ਯਿਹੂਦੀਯਾਨ੍ ਅਵਦਦ੍ ਯੀਸ਼ੁ ਰ੍ਮਾਮ੍ ਅਰੋਗਿਣਮ੍ ਅਕਾਰ੍ਸ਼਼ੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","ਤਤੋ ਯੀਸ਼ੁ ਰ੍ਵਿਸ਼੍ਰਾਮਵਾਰੇ ਕਰ੍ੰਮੇਦ੍ਰੁʼਸ਼ੰ ਕ੍ਰੁʼਤਵਾਨ੍ ਇਤਿ ਹੇਤੋ ਰ੍ਯਿਹੂਦੀਯਾਸ੍ਤੰ ਤਾਡਯਿਤ੍ਵਾ ਹਨ੍ਤੁਮ੍ ਅਚੇਸ਼਼੍ਟਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","ਯੀਸ਼ੁਸ੍ਤਾਨਾਖ੍ਯਤ੍ ਮਮ ਪਿਤਾ ਯਤ੍ ਕਾਰ੍ੱਯੰ ਕਰੋਤਿ ਤਦਨੁਰੂਪਮ੍ ਅਹਮਪਿ ਕਰੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","ਤਤੋ ਯਿਹੂਦੀਯਾਸ੍ਤੰ ਹਨ੍ਤੁੰ ਪੁਨਰਯਤਨ੍ਤ ਯਤੋ ਵਿਸ਼੍ਰਾਮਵਾਰੰ ਨਾਮਨ੍ਯਤ ਤਦੇਵ ਕੇਵਲੰ ਨ ਅਧਿਕਨ੍ਤੁ ਈਸ਼੍ਵਰੰ ਸ੍ਵਪਿਤਰੰ ਪ੍ਰੋਚ੍ਯ ਸ੍ਵਮਪੀਸ਼੍ਵਰਤੁਲ੍ਯੰ ਕ੍ਰੁʼਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","ਪਸ਼੍ਚਾਦ੍ ਯੀਸ਼ੁਰਵਦਦ੍ ਯੁਸ਼਼੍ਮਾਨਹੰ ਯਥਾਰ੍ਥਤਰੰ ਵਦਾਮਿ ਪੁਤ੍ਰਃ ਪਿਤਰੰ ਯਦ੍ਯਤ੍ ਕਰ੍ੰਮ ਕੁਰ੍ੱਵਨ੍ਤੰ ਪਸ਼੍ਯਤਿ ਤਦਤਿਰਿਕ੍ਤੰ ਸ੍ਵੇੱਛਾਤਃ ਕਿਮਪਿ ਕਰ੍ੰਮ ਕਰ੍ੱਤੁੰ ਨ ਸ਼ਕ੍ਨੋਤਿ| ਪਿਤਾ ਯਤ੍ ਕਰੋਤਿ ਪੁਤ੍ਰੋਪਿ ਤਦੇਵ ਕਰੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ਪਿਤਾ ਪੁਤ੍ਰੇ ਸ੍ਨੇਹੰ ਕਰੋਤਿ ਤਸ੍ਮਾਤ੍ ਸ੍ਵਯੰ ਯਦ੍ਯਤ੍ ਕਰ੍ੰਮ ਕਰੋਤਿ ਤਤ੍ਸਰ੍ੱਵੰ ਪੁਤ੍ਰੰ ਦਰ੍ਸ਼ਯਤਿ ; ਯਥਾ ਚ ਯੁਸ਼਼੍ਮਾਕੰ ਆਸ਼੍ਚਰ੍ੱਯਜ੍ਞਾਨੰ ਜਨਿਸ਼਼੍ਯਤੇ ਤਦਰ੍ਥਮ੍ ਇਤੋਪਿ ਮਹਾਕਰ੍ੰਮ ਤੰ ਦਰ੍ਸ਼ਯਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","ਵਸ੍ਤੁਤਸ੍ਤੁ ਪਿਤਾ ਯਥਾ ਪ੍ਰਮਿਤਾਨ੍ ਉੱਥਾਪ੍ਯ ਸਜਿਵਾਨ੍ ਕਰੋਤਿ ਤਦ੍ਵਤ੍ ਪੁਤ੍ਰੋਪਿ ਯੰ ਯੰ ਇੱਛਤਿ ਤੰ ਤੰ ਸਜੀਵੰ ਕਰੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","ਸਰ੍ੱਵੇ ਪਿਤਰੰ ਯਥਾ ਸਤ੍ਕੁਰ੍ੱਵਨ੍ਤਿ ਤਥਾ ਪੁਤ੍ਰਮਪਿ ਸਤ੍ਕਾਰਯਿਤੁੰ ਪਿਤਾ ਸ੍ਵਯੰ ਕਸ੍ਯਾਪਿ ਵਿਚਾਰਮਕ੍ਰੁʼਤ੍ਵਾ ਸਰ੍ੱਵਵਿਚਾਰਾਣਾਂ ਭਾਰੰ ਪੁਤ੍ਰੇ ਸਮਰ੍ਪਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ਯਃ ਪੁਤ੍ਰੰ ਸਤ੍ ਕਰੋਤਿ ਸ ਤਸ੍ਯ ਪ੍ਰੇਰਕਮਪਿ ਸਤ੍ ਕਰੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","ਯੁਸ਼਼੍ਮਾਨਾਹੰ ਯਥਾਰ੍ਥਤਰੰ ਵਦਾਮਿ ਯੋ ਜਨੋ ਮਮ ਵਾਕ੍ਯੰ ਸ਼੍ਰੁਤ੍ਵਾ ਮਤ੍ਪ੍ਰੇਰਕੇ ਵਿਸ਼੍ਵਸਿਤਿ ਸੋਨਨ੍ਤਾਯੁਃ ਪ੍ਰਾਪ੍ਨੋਤਿ ਕਦਾਪਿ ਦਣ੍ਡਬਾਜਨੰ ਨ ਭਵਤਿ ਨਿਧਨਾਦੁੱਥਾਯ ਪਰਮਾਯੁਃ ਪ੍ਰਾਪ੍ਨੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","ਅਹੰ ਯੁਸ਼਼੍ਮਾਨਤਿਯਥਾਰ੍ਥੰ ਵਦਾਮਿ ਯਦਾ ਮ੍ਰੁʼਤਾ ਈਸ਼੍ਵਰਪੁਤ੍ਰਸ੍ਯ ਨਿਨਾਦੰ ਸ਼੍ਰੋਸ਼਼੍ਯਨ੍ਤਿ ਯੇ ਚ ਸ਼੍ਰੋਸ਼਼੍ਯਨ੍ਤਿ ਤੇ ਸਜੀਵਾ ਭਵਿਸ਼਼੍ਯਨ੍ਤਿ ਸਮਯ ਏਤਾਦ੍ਰੁʼਸ਼ ਆਯਾਤਿ ਵਰਮ੍ ਇਦਾਨੀਮਪ੍ਯੁਪਤਿਸ਼਼੍ਠਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","ਪਿਤਾ ਯਥਾ ਸ੍ਵਯਞ੍ਜੀਵੀ ਤਥਾ ਪੁਤ੍ਰਾਯ ਸ੍ਵਯਞ੍ਜੀਵਿਤ੍ਵਾਧਿਕਾਰੰ ਦੱਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ਸ ਮਨੁਸ਼਼੍ਯਪੁਤ੍ਰਃ ਏਤਸ੍ਮਾਤ੍ ਕਾਰਣਾਤ੍ ਪਿਤਾ ਦਣ੍ਡਕਰਣਾਧਿਕਾਰਮਪਿ ਤਸ੍ਮਿਨ੍ ਸਮਰ੍ਪਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","ਏਤਦਰ੍ਥੇ ਯੂਯਮ੍ ਆਸ਼੍ਚਰ੍ੱਯੰ ਨ ਮਨ੍ਯਧ੍ਵੰ ਯਤੋ ਯਸ੍ਮਿਨ੍ ਸਮਯੇ ਤਸ੍ਯ ਨਿਨਾਦੰ ਸ਼੍ਰੁਤ੍ਵਾ ਸ਼੍ਮਸ਼ਾਨਸ੍ਥਾਃ ਸਰ੍ੱਵੇ ਬਹਿਰਾਗਮਿਸ਼਼੍ਯਨ੍ਤਿ ਸਮਯ ਏਤਾਦ੍ਰੁʼਸ਼ ਉਪਸ੍ਥਾਸ੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ਤਸ੍ਮਾਦ੍ ਯੇ ਸਤ੍ਕਰ੍ੰਮਾਣਿ ਕ੍ਰੁʼਤਵਨ੍ਤਸ੍ਤ ਉੱਥਾਯ ਆਯੁਃ ਪ੍ਰਾਪ੍ਸ੍ਯਨ੍ਤਿ ਯੇ ਚ ਕੁਕਰ੍ਮਾਣਿ ਕ੍ਰੁʼਤਵਨ੍ਤਸ੍ਤ ਉੱਥਾਯ ਦਣ੍ਡੰ ਪ੍ਰਾਪ੍ਸ੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","ਅਹੰ ਸ੍ਵਯੰ ਕਿਮਪਿ ਕਰ੍ੱਤੁੰ ਨ ਸ਼ਕ੍ਨੋਮਿ ਯਥਾ ਸ਼ੁਣੋਮਿ ਤਥਾ ਵਿਚਾਰਯਾਮਿ ਮਮ ਵਿਚਾਰਞ੍ਚ ਨ੍ਯਾੱਯਃ ਯਤੋਹੰ ਸ੍ਵੀਯਾਭੀਸ਼਼੍ਟੰ ਨੇਹਿਤ੍ਵਾ ਮਤ੍ਪ੍ਰੇਰਯਿਤੁਃ ਪਿਤੁਰਿਸ਼਼੍ਟਮ੍ ਈਹੇ| ");
INSERT INTO sanpun_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","ਯਦਿ ਸ੍ਵਸ੍ਮਿਨ੍ ਸ੍ਵਯੰ ਸਾਕ੍ਸ਼਼੍ਯੰ ਦਦਾਮਿ ਤਰ੍ਹਿ ਤਤ੍ਸਾਕ੍ਸ਼਼੍ਯਮ੍ ਆਗ੍ਰਾਹ੍ਯੰ ਭਵਤਿ ; ");
INSERT INTO sanpun_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","ਕਿਨ੍ਤੁ ਮਦਰ੍ਥੇ(ਅ)ਪਰੋ ਜਨਃ ਸਾਕ੍ਸ਼਼੍ਯੰ ਦਦਾਤਿ ਮਦਰ੍ਥੇ ਤਸ੍ਯ ਯਤ੍ ਸਾਕ੍ਸ਼਼੍ਯੰ ਤਤ੍ ਸਤ੍ਯਮ੍ ਏਤਦਪ੍ਯਹੰ ਜਾਨਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","ਯੁਸ਼਼੍ਮਾਭਿ ਰ੍ਯੋਹਨੰ ਪ੍ਰਤਿ ਲੋਕੇਸ਼਼ੁ ਪ੍ਰੇਰਿਤੇਸ਼਼ੁ ਸ ਸਤ੍ਯਕਥਾਯਾਂ ਸਾਕ੍ਸ਼਼੍ਯਮਦਦਾਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","ਮਾਨੁਸ਼਼ਾਦਹੰ ਸਾਕ੍ਸ਼਼੍ਯੰ ਨੋਪੇਕ੍ਸ਼਼ੇ ਤਥਾਪਿ ਯੂਯੰ ਯਥਾ ਪਰਿਤ੍ਰਯਧ੍ਵੇ ਤਦਰ੍ਥਮ੍ ਇਦੰ ਵਾਕ੍ਯੰ ਵਦਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","ਯੋਹਨ੍ ਦੇਦੀਪ੍ਯਮਾਨੋ ਦੀਪ ਇਵ ਤੇਜਸ੍ਵੀ ਸ੍ਥਿਤਵਾਨ੍ ਯੂਯਮ੍ ਅਲ੍ਪਕਾਲੰ ਤਸ੍ਯ ਦੀਪ੍ਤ੍ਯਾਨਨ੍ਦਿਤੁੰ ਸਮਮਨ੍ਯਧ੍ਵੰ| ");
INSERT INTO sanpun_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","ਕਿਨ੍ਤੁ ਤਤ੍ਪ੍ਰਮਾਣਾਦਪਿ ਮਮ ਗੁਰੁਤਰੰ ਪ੍ਰਮਾਣੰ ਵਿਦ੍ਯਤੇ ਪਿਤਾ ਮਾਂ ਪ੍ਰੇਸ਼਼੍ਯ ਯਦ੍ਯਤ੍ ਕਰ੍ੰਮ ਸਮਾਪਯਿਤੁੰ ਸ਼ਕ੍ੱਤਿਮਦਦਾਤ੍ ਮਯਾ ਕ੍ਰੁʼਤੰ ਤੱਤਤ੍ ਕਰ੍ੰਮ ਮਦਰ੍ਥੇ ਪ੍ਰਮਾਣੰ ਦਦਾਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ਯਃ ਪਿਤਾ ਮਾਂ ਪ੍ਰੇਰਿਤਵਾਨ੍ ਮੋਪਿ ਮਦਰ੍ਥੇ ਪ੍ਰਮਾਣੰ ਦਦਾਤਿ| ਤਸ੍ਯ ਵਾਕ੍ਯੰ ਯੁਸ਼਼੍ਮਾਭਿਃ ਕਦਾਪਿ ਨ ਸ਼੍ਰੁਤੰ ਤਸ੍ਯ ਰੂਪਞ੍ਚ ਨ ਦ੍ਰੁʼਸ਼਼੍ਟੰ ");
INSERT INTO sanpun_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ਤਸ੍ਯ ਵਾਕ੍ਯਞ੍ਚ ਯੁਸ਼਼੍ਮਾਕਮ੍ ਅਨ੍ਤਃ ਕਦਾਪਿ ਸ੍ਥਾਨੰ ਨਾਪ੍ਨੋਤਿ ਯਤਃ ਸ ਯੰ ਪ੍ਰੇਸ਼਼ਿਤਵਾਨ੍ ਯੂਯੰ ਤਸ੍ਮਿਨ੍ ਨ ਵਿਸ਼੍ਵਸਿਥ| ");
INSERT INTO sanpun_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","ਧਰ੍ੰਮਪੁਸ੍ਤਕਾਨਿ ਯੂਯਮ੍ ਆਲੋਚਯਧ੍ਵੰ ਤੈ ਰ੍ਵਾਕ੍ਯੈਰਨਨ੍ਤਾਯੁਃ ਪ੍ਰਾਪ੍ਸ੍ਯਾਮ ਇਤਿ ਯੂਯੰ ਬੁਧ੍ਯਧ੍ਵੇ ਤੱਧਰ੍ੰਮਪੁਸ੍ਤਕਾਨਿ ਮਦਰ੍ਥੇ ਪ੍ਰਮਾਣੰ ਦਦਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ਤਥਾਪਿ ਯੂਯੰ ਪਰਮਾਯੁਃਪ੍ਰਾਪ੍ਤਯੇ ਮਮ ਸੰਨਿਧਿਮ੍ ਨ ਜਿਗਮਿਸ਼਼ਥ| ");
INSERT INTO sanpun_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","ਅਹੰ ਮਾਨੁਸ਼਼ੇਭ੍ਯਃ ਸਤ੍ਕਾਰੰ ਨ ਗ੍ਰੁʼਹ੍ਲਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ਅਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਜਾਨਾਮਿ; ਯੁਸ਼਼੍ਮਾਕਮਨ੍ਤਰ ਈਸ਼੍ਵਰਪ੍ਰੇਮ ਨਾਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ਅਹੰ ਨਿਜਪਿਤੁ ਰ੍ਨਾਮ੍ਨਾਗਤੋਸ੍ਮਿ ਤਥਾਪਿ ਮਾਂ ਨ ਗ੍ਰੁʼਹ੍ਲੀਥ ਕਿਨ੍ਤੁ ਕਸ਼੍ਚਿਦ੍ ਯਦਿ ਸ੍ਵਨਾਮ੍ਨਾ ਸਮਾਗਮਿਸ਼਼੍ਯਤਿ ਤਰ੍ਹਿ ਤੰ ਗ੍ਰਹੀਸ਼਼੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","ਯੂਯਮ੍ ਈਸ਼੍ਵਰਾਤ੍ ਸਤ੍ਕਾਰੰ ਨ ਚਿਸ਼਼੍ਟਤ੍ਵਾ ਕੇਵਲੰ ਪਰਸ੍ਪਰੰ ਸਤ੍ਕਾਰਮ੍ ਚੇਦ੍ ਆਦਧ੍ੱਵੇ ਤਰ੍ਹਿ ਕਥੰ ਵਿਸ਼੍ਵਸਿਤੁੰ ਸ਼ਕ੍ਨੁਥ? ");
INSERT INTO sanpun_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","ਪੁਤੁਃ ਸਮੀਪੇ(ਅ)ਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਅਪਵਦਿਸ਼਼੍ਯਾਮੀਤਿ ਮਾ ਚਿਨ੍ਤਯਤ ਯਸ੍ਮਿਨ੍ , ਯਸ੍ਮਿਨ੍ ਯੁਸ਼਼੍ਮਾਕੰ ਵਿਸ਼੍ਵਸਃ ਸਏਵ ਮੂਸਾ ਯੁਸ਼਼੍ਮਾਨ੍ ਅਪਵਦਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","ਯਦਿ ਯੂਯੰ ਤਸ੍ਮਿਨ੍ ਵ੍ਯਸ਼੍ਵਸਿਸ਼਼੍ਯਤ ਤਰ੍ਹਿ ਮੱਯਪਿ ਵ੍ਯਸ਼੍ਵਸਿਸ਼਼੍ਯਤ, ਯਤ੍ ਸ ਮਯਿ ਲਿਖਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","ਤਤੋ ਯਦਿ ਤੇਨ ਲਿਖਿਤਵਾਨਿ ਨ ਪ੍ਰਤਿਥ ਤਰ੍ਹਿ ਮਮ ਵਾਕ੍ਯਾਨਿ ਕਥੰ ਪ੍ਰਤ੍ਯੇਸ਼਼੍ਯਥ? ");
INSERT INTO sanpun_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","ਤਤਃ ਪਰੰ ਯੀਸ਼ੁ ਰ੍ਗਾਲੀਲ੍ ਪ੍ਰਦੇਸ਼ੀਯਸ੍ਯ ਤਿਵਿਰਿਯਾਨਾਮ੍ਨਃ ਸਿਨ੍ਧੋਃ ਪਾਰੰ ਗਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ਤਤੋ ਵ੍ਯਾਧਿਮੱਲੋਕਸ੍ਵਾਸ੍ਥ੍ਯਕਰਣਰੂਪਾਣਿ ਤਸ੍ਯਾਸ਼੍ਚਰ੍ੱਯਾਣਿ ਕਰ੍ੰਮਾਣਿ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਬਹਵੋ ਜਨਾਸ੍ਤਤ੍ਪਸ਼੍ਚਾਦ੍ ਅਗੱਛਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ਤਤੋ ਯੀਸ਼ੁਃ ਪਰ੍ੱਵਤਮਾਰੁਹ੍ਯ ਤਤ੍ਰ ਸ਼ਿਸ਼਼੍ਯੈਃ ਸਾਕਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","ਤਸ੍ਮਿਨ੍ ਸਮਯ ਨਿਸ੍ਤਾਰੋਤ੍ਸਵਨਾਮ੍ਨਿ ਯਿਹੂਦੀਯਾਨਾਮ ਉਤ੍ਸਵ ਉਪਸ੍ਥਿਤੇ ");
INSERT INTO sanpun_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","ਯੀਸ਼ੁ ਰ੍ਨੇਤ੍ਰੇ ਉੱਤੋਲ੍ਯ ਬਹੁਲੋਕਾਨ੍ ਸ੍ਵਸਮੀਪਾਗਤਾਨ੍ ਵਿਲੋਕ੍ਯ ਫਿਲਿਪੰ ਪ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍ ਏਤੇਸ਼਼ਾਂ ਭੋਜਨਾਯ ਭੋਜਦ੍ਰਵ੍ਯਾਣਿ ਵਯੰ ਕੁਤ੍ਰ ਕ੍ਰੇਤੁੰ ਸ਼ਕ੍ਰੁਮਃ? ");
INSERT INTO sanpun_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ਵਾਕ੍ਯਮਿਦੰ ਤਸ੍ਯ ਪਰੀਕ੍ਸ਼਼ਾਰ੍ਥਮ੍ ਅਵਾਦੀਤ੍ ਕਿਨ੍ਤੁ ਯਤ੍ ਕਰਿਸ਼਼੍ਯਤਿ ਤਤ੍ ਸ੍ਵਯਮ੍ ਅਜਾਨਾਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ਫਿਲਿਪਃ ਪ੍ਰਤ੍ਯਵੋਚਤ੍ ਏਤੇਸ਼਼ਾਮ੍ ਏਕੈਕੋ ਯਦ੍ਯਲ੍ਪਮ੍ ਅਲ੍ਪੰ ਪ੍ਰਾਪ੍ਨੋਤਿ ਤਰ੍ਹਿ ਮੁਦ੍ਰਾਪਾਦਦ੍ਵਿਸ਼ਤੇਨ ਕ੍ਰੀਤਪੂਪਾ ਅਪਿ ਨ੍ਯੂਨਾ ਭਵਿਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ਸ਼ਿਮੋਨ੍ ਪਿਤਰਸ੍ਯ ਭ੍ਰਾਤਾ ਆਨ੍ਦ੍ਰਿਯਾਖ੍ਯਃ ਸ਼ਿਸ਼਼੍ਯਾਣਾਮੇਕੋ ਵ੍ਯਾਹ੍ਰੁʼਤਵਾਨ੍ ");
INSERT INTO sanpun_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","ਅਤ੍ਰ ਕਸ੍ਯਚਿਦ੍ ਬਾਲਕਸ੍ਯ ਸਮੀਪੇ ਪਞ੍ਚ ਯਾਵਪੂਪਾਃ ਕ੍ਸ਼਼ੁਦ੍ਰਮਤ੍ਸ੍ਯਦ੍ਵਯਞ੍ਚ ਸਨ੍ਤਿ ਕਿਨ੍ਤੁ ਲੋਕਾਨਾਂ ਏਤਾਵਾਤਾਂ ਮਧ੍ਯੇ ਤੈਃ ਕਿੰ ਭਵਿਸ਼਼੍ਯਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","ਪਸ਼੍ਚਾਦ੍ ਯੀਸ਼ੁਰਵਦਤ੍ ਲੋਕਾਨੁਪਵੇਸ਼ਯਤ ਤਤ੍ਰ ਬਹੁਯਵਸਸੱਤ੍ਵਾਤ੍ ਪਞ੍ਚਸਹਸ੍ਤ੍ਰੇਭ੍ਯੋ ਨ੍ਯੂਨਾ ਅਧਿਕਾ ਵਾ ਪੁਰੁਸ਼਼ਾ ਭੂਮ੍ਯਾਮ੍ ਉਪਾਵਿਸ਼ਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ਤਤੋ ਯੀਸ਼ੁਸ੍ਤਾਨ੍ ਪੂਪਾਨਾਦਾਯ ਈਸ਼੍ਵਰਸ੍ਯ ਗੁਣਾਨ੍ ਕੀਰ੍ੱਤਯਿਤ੍ਵਾ ਸ਼ਿਸ਼਼੍ਯੇਸ਼਼ੁ ਸਮਾਰ੍ਪਯਤ੍ ਤਤਸ੍ਤੇ ਤੇਭ੍ਯ ਉਪਵਿਸ਼਼੍ਟਲੋਕੇਭ੍ਯਃ ਪੂਪਾਨ੍ ਯਥੇਸ਼਼੍ਟਮਤ੍ਸ੍ਯਞ੍ਚ ਪ੍ਰਾਦੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ਤੇਸ਼਼ੁ ਤ੍ਰੁʼਪ੍ਤੇਸ਼਼ੁ ਸ ਤਾਨਵੋਚਦ੍ ਏਤੇਸ਼਼ਾਂ ਕਿਞ੍ਚਿਦਪਿ ਯਥਾ ਨਾਪਚੀਯਤੇ ਤਥਾ ਸਰ੍ੱਵਾਣ੍ਯਵਸ਼ਿਸ਼਼੍ਟਾਨਿ ਸੰਗ੍ਰੁʼਹ੍ਲੀਤ| ");
INSERT INTO sanpun_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ਤਤਃ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਭੋਜਨਾਤ੍ ਪਰੰ ਤੇ ਤੇਸ਼਼ਾਂ ਪਞ੍ਚਾਨਾਂ ਯਾਵਪੂਪਾਨਾਂ ਅਵਸ਼ਿਸ਼਼੍ਟਾਨ੍ਯਖਿਲਾਨਿ ਸੰਗ੍ਰੁʼਹ੍ਯ ਦ੍ਵਾਦਸ਼ਡੱਲਕਾਨ੍ ਅਪੂਰਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","ਅਪਰੰ ਯੀਸ਼ੋਰੇਤਾਦ੍ਰੁʼਸ਼ੀਮ੍ ਆਸ਼੍ਚਰ੍ੱਯਕ੍ਰਿਯਾਂ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਲੋਕਾ ਮਿਥੋ ਵਕ੍ਤੁਮਾਰੇਭਿਰੇ ਜਗਤਿ ਯਸ੍ਯਾਗਮਨੰ ਭਵਿਸ਼਼੍ਯਤਿ ਸ ਏਵਾਯਮ੍ ਅਵਸ਼੍ਯੰ ਭਵਿਸ਼਼੍ਯਦ੍ਵਕ੍ੱਤਾ| ");
INSERT INTO sanpun_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ਅਤਏਵ ਲੋਕਾ ਆਗਤ੍ਯ ਤਮਾਕ੍ਰਮ੍ਯ ਰਾਜਾਨੰ ਕਰਿਸ਼਼੍ਯਨ੍ਤਿ ਯੀਸ਼ੁਸ੍ਤੇਸ਼਼ਾਮ੍ ਈਦ੍ਰੁʼਸ਼ੰ ਮਾਨਸੰ ਵਿਜ੍ਞਾਯ ਪੁਨਸ਼੍ਚ ਪਰ੍ੱਵਤਮ੍ ਏਕਾਕੀ ਗਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ਸਾਯੰਕਾਲ ਉਪਸ੍ਥਿਤੇ ਸ਼ਿਸ਼਼੍ਯਾ ਜਲਧਿਤਟੰ ਵ੍ਰਜਿਤ੍ਵਾ ਨਾਵਮਾਰੁਹ੍ਯ ਨਗਰਦਿਸ਼ਿ ਸਿਨ੍ਧੌ ਵਾਹਯਿਤ੍ਵਾਗਮਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ਤਸ੍ਮਿਨ੍ ਸਮਯੇ ਤਿਮਿਰ ਉਪਾਤਿਸ਼਼੍ਠਤ੍ ਕਿਨ੍ਤੁ ਯੀਸ਼਼ੁਸ੍ਤੇਸ਼਼ਾਂ ਸਮੀਪੰ ਨਾਗੱਛਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ਤਦਾ ਪ੍ਰਬਲਪਵਨਵਹਨਾਤ੍ ਸਾਗਰੇ ਮਹਾਤਰਙ੍ਗੋ ਭਵਿਤੁਮ੍ ਆਰੇਭੇ| ");
INSERT INTO sanpun_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ਤਤਸ੍ਤੇ ਵਾਹਯਿਤ੍ਵਾ ਦ੍ਵਿਤ੍ਰਾਨ੍ ਕ੍ਰੋਸ਼ਾਨ੍ ਗਤਾਃ ਪਸ਼੍ਚਾਦ੍ ਯੀਸ਼ੁੰ ਜਲਧੇਰੁਪਰਿ ਪਦ੍ਭ੍ਯਾਂ ਵ੍ਰਜਨ੍ਤੰ ਨੌਕਾਨ੍ਤਿਕਮ੍ ਆਗੱਛਨ੍ਤੰ ਵਿਲੋਕ੍ਯ ਤ੍ਰਾਸਯੁਕ੍ਤਾ ਅਭਵਨ੍ ");
INSERT INTO sanpun_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ਕਿਨ੍ਤੁ ਸ ਤਾਨੁਕ੍ੱਤਵਾਨ੍ ਅਯਮਹੰ ਮਾ ਭੈਸ਼਼੍ਟ| ");
INSERT INTO sanpun_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ਤਦਾ ਤੇ ਤੰ ਸ੍ਵੈਰੰ ਨਾਵਿ ਗ੍ਰੁʼਹੀਤਵਨ੍ਤਃ ਤਦਾ ਤਤ੍ਕ੍ਸ਼਼ਣਾਦ੍ ਉੱਦਿਸ਼਼੍ਟਸ੍ਥਾਨੇ ਨੌਰੁਪਾਸ੍ਥਾਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","ਯਯਾ ਨਾਵਾ ਸ਼ਿਸ਼਼੍ਯਾ ਅਗੱਛਨ੍ ਤਦਨ੍ਯਾ ਕਾਪਿ ਨੌਕਾ ਤਸ੍ਮਿਨ੍ ਸ੍ਥਾਨੇ ਨਾਸੀਤ੍ ਤਤੋ ਯੀਸ਼ੁਃ ਸ਼ਿਸ਼਼੍ਯੈਃ ਸਾਕੰ ਨਾਗਮਤ੍ ਕੇਵਲਾਃ ਸ਼ਿਸ਼਼੍ਯਾ ਅਗਮਨ੍ ਏਤਤ੍ ਪਾਰਸ੍ਥਾ ਲੋਕਾ ਜ੍ਞਾਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","ਕਿਨ੍ਤੁ ਤਤਃ ਪਰੰ ਪ੍ਰਭੁ ਰ੍ਯਤ੍ਰ ਈਸ਼੍ਵਰਸ੍ਯ ਗੁਣਾਨ੍ ਅਨੁਕੀਰ੍ੱਤ੍ਯ ਲੋਕਾਨ੍ ਪੂਪਾਨ੍ ਅਭੋਜਯਤ੍ ਤਤ੍ਸ੍ਥਾਨਸ੍ਯ ਸਮੀਪਸ੍ਥਤਿਵਿਰਿਯਾਯਾ ਅਪਰਾਸ੍ਤਰਣਯ ਆਗਮਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","ਯੀਸ਼ੁਸ੍ਤਤ੍ਰ ਨਾਸ੍ਤਿ ਸ਼ਿਸ਼਼੍ਯਾ ਅਪਿ ਤਤ੍ਰ ਨਾ ਸਨ੍ਤਿ ਲੋਕਾ ਇਤਿ ਵਿਜ੍ਞਾਯ ਯੀਸ਼ੁੰ ਗਵੇਸ਼਼ਯਿਤੁੰ ਤਰਣਿਭਿਃ ਕਫਰ੍ਨਾਹੂਮ੍ ਪੁਰੰ ਗਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","ਤਤਸ੍ਤੇ ਸਰਿਤ੍ਪਤੇਃ ਪਾਰੇ ਤੰ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਪ੍ਰਾਪ੍ਯ ਪ੍ਰਾਵੋਚਨ੍ ਹੇ ਗੁਰੋ ਭਵਾਨ੍ ਅਤ੍ਰ ਸ੍ਥਾਨੇ ਕਦਾਗਮਤ੍? ");
INSERT INTO sanpun_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","ਤਦਾ ਯੀਸ਼ੁਸ੍ਤਾਨ੍ ਪ੍ਰਤ੍ਯਵਾਦੀਦ੍ ਯੁਸ਼਼੍ਮਾਨਹੰ ਯਥਾਰ੍ਥਤਰੰ ਵਦਾਮਿ ਆਸ਼੍ਚਰ੍ੱਯਕਰ੍ੰਮਦਰ੍ਸ਼ਨਾੱਧੇਤੋ ਰ੍ਨ ਕਿਨ੍ਤੁ ਪੂਪਭੋਜਨਾਤ੍ ਤੇਨ ਤ੍ਰੁʼਪ੍ਤਤ੍ਵਾਞ੍ਚ ਮਾਂ ਗਵੇਸ਼਼ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ਕ੍ਸ਼਼ਯਣੀਯਭਕ੍ਸ਼਼੍ਯਾਰ੍ਥੰ ਮਾ ਸ਼੍ਰਾਮਿਸ਼਼੍ਟ ਕਿਨ੍ਤ੍ਵਨ੍ਤਾਯੁਰ੍ਭਕ੍ਸ਼਼੍ਯਾਰ੍ਥੰ ਸ਼੍ਰਾਮ੍ਯਤ, ਤਸ੍ਮਾਤ੍ ਤਾਦ੍ਰੁʼਸ਼ੰ ਭਕ੍ਸ਼਼੍ਯੰ ਮਨੁਜਪੁਤ੍ਰੋ ਯੁਸ਼਼੍ਮਾਭ੍ਯੰ ਦਾਸ੍ਯਤਿ; ਤਸ੍ਮਿਨ੍ ਤਾਤ ਈਸ਼੍ਵਰਃ ਪ੍ਰਮਾਣੰ ਪ੍ਰਾਦਾਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","ਤਦਾ ਤੇ(ਅ)ਪ੍ਰੁʼੱਛਨ੍ ਈਸ਼੍ਵਰਾਭਿਮਤੰ ਕਰ੍ੰਮ ਕਰ੍ੱਤੁਮ੍ ਅਸ੍ਮਾਭਿਃ ਕਿੰ ਕਰ੍ੱਤਵ੍ਯੰ? ");
INSERT INTO sanpun_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","ਤਤੋ ਯੀਸ਼ੁਰਵਦਦ੍ ਈਸ਼੍ਵਰੋ ਯੰ ਪ੍ਰੈਰਯਤ੍ ਤਸ੍ਮਿਨ੍ ਵਿਸ਼੍ਵਸਨਮ੍ ਈਸ਼੍ਵਰਾਭਿਮਤੰ ਕਰ੍ੰਮ| ");
INSERT INTO sanpun_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","ਤਦਾ ਤੇ ਵ੍ਯਾਹਰਨ੍ ਭਵਤਾ ਕਿੰ ਲਕ੍ਸ਼਼ਣੰ ਦਰ੍ਸ਼ਿਤੰ ਯੱਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਭਵਤਿ ਵਿਸ਼੍ਵਸਿਸ਼਼੍ਯਾਮਃ? ਤ੍ਵਯਾ ਕਿੰ ਕਰ੍ੰਮ ਕ੍ਰੁʼਤੰ? ");
INSERT INTO sanpun_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","ਅਸ੍ਮਾਕੰ ਪੂਰ੍ੱਵਪੁਰੁਸ਼਼ਾ ਮਹਾਪ੍ਰਾਨ੍ਤਰੇ ਮਾੰਨਾਂ ਭੋਕ੍ੱਤੁੰ ਪ੍ਰਾਪੁਃ ਯਥਾ ਲਿਪਿਰਾਸ੍ਤੇ| ਸ੍ਵਰ੍ਗੀਯਾਣਿ ਤੁ ਭਕ੍ਸ਼਼੍ਯਾਣਿ ਪ੍ਰਦਦੌ ਪਰਮੇਸ਼੍ਵਰਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","ਤਦਾ ਯੀਸ਼ੁਰਵਦਦ੍ ਅਹੰ ਯੁਸ਼਼੍ਮਾਨਤਿਯਥਾਰ੍ਥੰ ਵਦਾਮਿ ਮੂਸਾ ਯੁਸ਼਼੍ਮਾਭ੍ਯੰ ਸ੍ਵਰ੍ਗੀਯੰ ਭਕ੍ਸ਼਼੍ਯੰ ਨਾਦਾਤ੍ ਕਿਨ੍ਤੁ ਮਮ ਪਿਤਾ ਯੁਸ਼਼੍ਮਾਭ੍ਯੰ ਸ੍ਵਰ੍ਗੀਯੰ ਪਰਮੰ ਭਕ੍ਸ਼਼੍ਯੰ ਦਦਾਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ਯਃ ਸ੍ਵਰ੍ਗਾਦਵਰੁਹ੍ਯ ਜਗਤੇ ਜੀਵਨੰ ਦਦਾਤਿ ਸ ਈਸ਼੍ਵਰਦੱਤਭਕ੍ਸ਼਼੍ਯਰੂਪਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","ਤਦਾ ਤੇ ਪ੍ਰਾਵੋਚਨ੍ ਹੇ ਪ੍ਰਭੋ ਭਕ੍ਸ਼਼੍ਯਮਿਦੰ ਨਿਤ੍ਯਮਸ੍ਮਭ੍ਯੰ ਦਦਾਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","ਯੀਸ਼ੁਰਵਦਦ੍ ਅਹਮੇਵ ਜੀਵਨਰੂਪੰ ਭਕ੍ਸ਼਼੍ਯੰ ਯੋ ਜਨੋ ਮਮ ਸੰਨਿਧਿਮ੍ ਆਗੱਛਤਿ ਸ ਜਾਤੁ ਕ੍ਸ਼਼ੁਧਾਰ੍ੱਤੋ ਨ ਭਵਿਸ਼਼੍ਯਤਿ, ਤਥਾ ਯੋ ਜਨੋ ਮਾਂ ਪ੍ਰਤ੍ਯੇਤਿ ਸ ਜਾਤੁ ਤ੍ਰੁʼਸ਼਼ਾਰ੍ੱਤੋ ਨ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","ਮਾਂ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾਪਿ ਯੂਯੰ ਨ ਵਿਸ਼੍ਵਸਿਥ ਯੁਸ਼਼੍ਮਾਨਹਮ੍ ਇਤ੍ਯਵੋਚੰ| ");
INSERT INTO sanpun_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","ਪਿਤਾ ਮਹ੍ਯੰ ਯਾਵਤੋ ਲੋਕਾਨਦਦਾਤ੍ ਤੇ ਸਰ੍ੱਵ ਏਵ ਮਮਾਨ੍ਤਿਕਮ੍ ਆਗਮਿਸ਼਼੍ਯਨ੍ਤਿ ਯਃ ਕਸ਼੍ਚਿੱਚ ਮਮ ਸੰਨਿਧਿਮ੍ ਆਯਾਸ੍ਯਤਿ ਤੰ ਕੇਨਾਪਿ ਪ੍ਰਕਾਰੇਣ ਨ ਦੂਰੀਕਰਿਸ਼਼੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ਨਿਜਾਭਿਮਤੰ ਸਾਧਯਿਤੁੰ ਨ ਹਿ ਕਿਨ੍ਤੁ ਪ੍ਰੇਰਯਿਤੁਰਭਿਮਤੰ ਸਾਧਯਿਤੁੰ ਸ੍ਵਰ੍ਗਾਦ੍ ਆਗਤੋਸ੍ਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ਸ ਯਾਨ੍ ਯਾਨ੍ ਲੋਕਾਨ੍ ਮਹ੍ਯਮਦਦਾਤ੍ ਤੇਸ਼਼ਾਮੇਕਮਪਿ ਨ ਹਾਰਯਿਤ੍ਵਾ ਸ਼ੇਸ਼਼ਦਿਨੇ ਸਰ੍ੱਵਾਨਹਮ੍ ਉੱਥਾਪਯਾਮਿ ਇਦੰ ਮਤ੍ਪ੍ਰੇਰਯਿਤੁਃ ਪਿਤੁਰਭਿਮਤੰ| ");
INSERT INTO sanpun_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","ਯਃ ਕਸ਼੍ਚਿਨ੍ ਮਾਨਵਸੁਤੰ ਵਿਲੋਕ੍ਯ ਵਿਸ਼੍ਵਸਿਤਿ ਸ ਸ਼ੇਸ਼਼ਦਿਨੇ ਮਯੋੱਥਾਪਿਤਃ ਸਨ੍ ਅਨਨ੍ਤਾਯੁਃ ਪ੍ਰਾਪ੍ਸ੍ਯਤਿ ਇਤਿ ਮਤ੍ਪ੍ਰੇਰਕਸ੍ਯਾਭਿਮਤੰ| ");
INSERT INTO sanpun_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","ਤਦਾ ਸ੍ਵਰ੍ਗਾਦ੍ ਯਦ੍ ਭਕ੍ਸ਼਼੍ਯਮ੍ ਅਵਾਰੋਹਤ੍ ਤਦ੍ ਭਕ੍ਸ਼਼੍ਯਮ੍ ਅਹਮੇਵ ਯਿਹੂਦੀਯਲੋਕਾਸ੍ਤਸ੍ਯੈਤਦ੍ ਵਾਕ੍ਯੇ ਵਿਵਦਮਾਨਾ ਵਕ੍ੱਤੁਮਾਰੇਭਿਰੇ ");
INSERT INTO sanpun_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ਯੂਸ਼਼ਫਃ ਪੁਤ੍ਰੋ ਯੀਸ਼ੁ ਰ੍ਯਸ੍ਯ ਮਾਤਾਪਿਤਰੌ ਵਯੰ ਜਾਨੀਮ ਏਸ਼਼ ਕਿੰ ਸਏਵ ਨ? ਤਰ੍ਹਿ ਸ੍ਵਰ੍ਗਾਦ੍ ਅਵਾਰੋਹਮ੍ ਇਤਿ ਵਾਕ੍ਯੰ ਕਥੰ ਵਕ੍ੱਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","ਤਦਾ ਯੀਸ਼ੁਸ੍ਤਾਨ੍ ਪ੍ਰਤ੍ਯਵਦਤ੍ ਪਰਸ੍ਪਰੰ ਮਾ ਵਿਵਦਧ੍ਵੰ ");
INSERT INTO sanpun_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","ਮਤ੍ਪ੍ਰੇਰਕੇਣ ਪਿਤ੍ਰਾ ਨਾਕ੍ਰੁʼਸ਼਼੍ਟਃ ਕੋਪਿ ਜਨੋ ਮਮਾਨ੍ਤਿਕਮ੍ ਆਯਾਤੁੰ ਨ ਸ਼ਕ੍ਨੋਤਿ ਕਿਨ੍ਤ੍ਵਾਗਤੰ ਜਨੰ ਚਰਮੇ(ਅ)ਹ੍ਨਿ ਪ੍ਰੋੱਥਾਪਯਿਸ਼਼੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","ਤੇ ਸਰ੍ੱਵ ਈਸ਼੍ਵਰੇਣ ਸ਼ਿਕ੍ਸ਼਼ਿਤਾ ਭਵਿਸ਼਼੍ਯਨ੍ਤਿ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਾਂ ਗ੍ਰਨ੍ਥੇਸ਼਼ੁ ਲਿਪਿਰਿੱਥਮਾਸ੍ਤੇ ਅਤੋ ਯਃ ਕਸ਼੍ਚਿਤ੍ ਪਿਤੁਃ ਸਕਾਸ਼ਾਤ੍ ਸ਼੍ਰੁਤ੍ਵਾ ਸ਼ਿਕ੍ਸ਼਼ਤੇ ਸ ਏਵ ਮਮ ਸਮੀਪਮ੍ ਆਗਮਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ਯ ਈਸ਼੍ਵਰਾਦ੍ ਅਜਾਯਤ ਤੰ ਵਿਨਾ ਕੋਪਿ ਮਨੁਸ਼਼੍ਯੋ ਜਨਕੰ ਨਾਦਰ੍ਸ਼ਤ੍ ਕੇਵਲਃ ਸਏਵ ਤਾਤਮ੍ ਅਦ੍ਰਾਕ੍ਸ਼਼ੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","ਅਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਯਥਾਰ੍ਥਤਰੰ ਵਦਾਮਿ ਯੋ ਜਨੋ ਮਯਿ ਵਿਸ਼੍ਵਾਸੰ ਕਰੋਤਿ ਸੋਨਨ੍ਤਾਯੁਃ ਪ੍ਰਾਪ੍ਨੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ਅਹਮੇਵ ਤੱਜੀਵਨਭਕ੍ਸ਼਼੍ਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","ਯੁਸ਼਼੍ਮਾਕੰ ਪੂਰ੍ੱਵਪੁਰੁਸ਼਼ਾ ਮਹਾਪ੍ਰਾਨ੍ਤਰੇ ਮੰਨਾਭਕ੍ਸ਼਼੍ਯੰ ਭੂਕ੍ੱਤਾਪਿ ਮ੍ਰੁʼਤਾਃ ");
INSERT INTO sanpun_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","ਕਿਨ੍ਤੁ ਯਦ੍ਭਕ੍ਸ਼਼੍ਯੰ ਸ੍ਵਰ੍ਗਾਦਾਗੱਛਤ੍ ਤਦ੍ ਯਦਿ ਕਸ਼੍ਚਿਦ੍ ਭੁਙ੍ਕ੍ੱਤੇ ਤਰ੍ਹਿ ਸ ਨ ਮ੍ਰਿਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","ਯੱਜੀਵਨਭਕ੍ਸ਼਼੍ਯੰ ਸ੍ਵਰ੍ਗਾਦਾਗੱਛਤ੍ ਸੋਹਮੇਵ ਇਦੰ ਭਕ੍ਸ਼਼੍ਯੰ ਯੋ ਜਨੋ ਭੁਙ੍ਕ੍ੱਤੇ ਸ ਨਿਤ੍ਯਜੀਵੀ ਭਵਿਸ਼਼੍ਯਤਿ| ਪੁਨਸ਼੍ਚ ਜਗਤੋ ਜੀਵਨਾਰ੍ਥਮਹੰ ਯਤ੍ ਸ੍ਵਕੀਯਪਿਸ਼ਿਤੰ ਦਾਸ੍ਯਾਮਿ ਤਦੇਵ ਮਯਾ ਵਿਤਰਿਤੰ ਭਕ੍ਸ਼਼੍ਯਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","ਤਸ੍ਮਾਦ੍ ਯਿਹੂਦੀਯਾਃ ਪਰਸ੍ਪਰੰ ਵਿਵਦਮਾਨਾ ਵਕ੍ੱਤੁਮਾਰੇਭਿਰੇ ਏਸ਼਼ ਭੋਜਨਾਰ੍ਥੰ ਸ੍ਵੀਯੰ ਪਲਲੰ ਕਥਮ੍ ਅਸ੍ਮਭ੍ਯੰ ਦਾਸ੍ਯਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ਤਦਾ ਯੀਸ਼ੁਸ੍ਤਾਨ੍ ਆਵੋਚਦ੍ ਯੁਸ਼਼੍ਮਾਨਹੰ ਯਥਾਰ੍ਥਤਰੰ ਵਦਾਮਿ ਮਨੁਸ਼਼੍ਯਪੁਤ੍ਰਸ੍ਯਾਮਿਸ਼਼ੇ ਯੁਸ਼਼੍ਮਾਭਿ ਰ੍ਨ ਭੁਕ੍ੱਤੇ ਤਸ੍ਯ ਰੁਧਿਰੇ ਚ ਨ ਪੀਤੇ ਜੀਵਨੇਨ ਸਾਰ੍ੱਧੰ ਯੁਸ਼਼੍ਮਾਕੰ ਸਮ੍ਬਨ੍ਧੋ ਨਾਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ਯੋ ਮਮਾਮਿਸ਼਼ੰ ਸ੍ਵਾਦਤਿ ਮਮ ਸੁਧਿਰਞ੍ਚ ਪਿਵਤਿ ਸੋਨਨ੍ਤਾਯੁਃ ਪ੍ਰਾਪ੍ਨੋਤਿ ਤਤਃ ਸ਼ੇਸ਼਼ੇ(ਅ)ਹ੍ਨਿ ਤਮਹਮ੍ ਉੱਥਾਪਯਿਸ਼਼੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","ਯਤੋ ਮਦੀਯਮਾਮਿਸ਼਼ੰ ਪਰਮੰ ਭਕ੍ਸ਼਼੍ਯੰ ਤਥਾ ਮਦੀਯੰ ਸ਼ੋਣਿਤੰ ਪਰਮੰ ਪੇਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ਯੋ ਜਨੋ ਮਦੀਯੰ ਪਲਲੰ ਸ੍ਵਾਦਤਿ ਮਦੀਯੰ ਰੁਧਿਰਞ੍ਚ ਪਿਵਤਿ ਸ ਮਯਿ ਵਸਤਿ ਤਸ੍ਮਿੰਨਹਞ੍ਚ ਵਸਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","ਮਤ੍ਪ੍ਰੇਰਯਿਤ੍ਰਾ ਜੀਵਤਾ ਤਾਤੇਨ ਯਥਾਹੰ ਜੀਵਾਮਿ ਤਦ੍ਵਦ੍ ਯਃ ਕਸ਼੍ਚਿਨ੍ ਮਾਮੱਤਿ ਸੋਪਿ ਮਯਾ ਜੀਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","ਯਦ੍ਭਕ੍ਸ਼਼੍ਯੰ ਸ੍ਵਰ੍ਗਾਦਾਗੱਛਤ੍ ਤਦਿਦੰ ਯਨ੍ਮਾੰਨਾਂ ਸ੍ਵਾਦਿਤ੍ਵਾ ਯੁਸ਼਼੍ਮਾਕੰ ਪਿਤਰੋ(ਅ)ਮ੍ਰਿਯਨ੍ਤ ਤਾਦ੍ਰੁʼਸ਼ਮ੍ ਇਦੰ ਭਕ੍ਸ਼਼੍ਯੰ ਨ ਭਵਤਿ ਇਦੰ ਭਕ੍ਸ਼਼੍ਯੰ ਯੋ ਭਕ੍ਸ਼਼ਤਿ ਸ ਨਿਤ੍ਯੰ ਜੀਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ਯਦਾ ਕਫਰ੍ਨਾਹੂਮ੍ ਪੁਰ੍ੱਯਾਂ ਭਜਨਗੇਹੇ ਉਪਾਦਿਸ਼ਤ੍ ਤਦਾ ਕਥਾ ਏਤਾ ਅਕਥਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","ਤਦੇੱਥੰ ਸ਼੍ਰੁਤ੍ਵਾ ਤਸ੍ਯ ਸ਼ਿਸ਼਼੍ਯਾਣਾਮ੍ ਅਨੇਕੇ ਪਰਸ੍ਪਰਮ੍ ਅਕਥਯਨ੍ ਇਦੰ ਗਾਢੰ ਵਾਕ੍ਯੰ ਵਾਕ੍ਯਮੀਦ੍ਰੁʼਸ਼ੰ ਕਃ ਸ਼੍ਰੋਤੁੰ ਸ਼ਕ੍ਰੁਯਾਤ੍? ");
INSERT INTO sanpun_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","ਕਿਨ੍ਤੁ ਯੀਸ਼ੁਃ ਸ਼ਿਸ਼਼੍ਯਾਣਾਮ੍ ਇੱਥੰ ਵਿਵਾਦੰ ਸ੍ਵਚਿੱਤੇ ਵਿਜ੍ਞਾਯ ਕਥਿਤਵਾਨ੍ ਇਦੰ ਵਾਕ੍ਯੰ ਕਿੰ ਯੁਸ਼਼੍ਮਾਕੰ ਵਿਘ੍ਨੰ ਜਨਯਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","ਯਦਿ ਮਨੁਜਸੁਤੰ ਪੂਰ੍ੱਵਵਾਸਸ੍ਥਾਨਮ੍ ਊਰ੍ਦ੍ੱਵੰ ਗੱਛਨ੍ਤੰ ਪਸ਼੍ਯਥ ਤਰ੍ਹਿ ਕਿੰ ਭਵਿਸ਼਼੍ਯਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","ਆਤ੍ਮੈਵ ਜੀਵਨਦਾਯਕਃ ਵਪੁ ਰ੍ਨਿਸ਼਼੍ਫਲੰ ਯੁਸ਼਼੍ਮਭ੍ਯਮਹੰ ਯਾਨਿ ਵਚਾਂਸਿ ਕਥਯਾਮਿ ਤਾਨ੍ਯਾਤ੍ਮਾ ਜੀਵਨਞ੍ਚ| ");
INSERT INTO sanpun_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","ਕਿਨ੍ਤੁ ਯੁਸ਼਼੍ਮਾਕੰ ਮਧ੍ਯੇ ਕੇਚਨ ਅਵਿਸ਼੍ਵਾਸਿਨਃ ਸਨ੍ਤਿ ਕੇ ਕੇ ਨ ਵਿਸ਼੍ਵਸਨ੍ਤਿ ਕੋ ਵਾ ਤੰ ਪਰਕਰੇਸ਼਼ੁ ਸਮਰ੍ਪਯਿਸ਼਼੍ਯਤਿ ਤਾਨ੍ ਯੀਸ਼ੁਰਾਪ੍ਰਥਮਾਦ੍ ਵੇੱਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","ਅਪਰਮਪਿ ਕਥਿਤਵਾਨ੍ ਅਸ੍ਮਾਤ੍ ਕਾਰਣਾਦ੍ ਅਕਥਯੰ ਪਿਤੁਃ ਸਕਾਸ਼ਾਤ੍ ਸ਼ਕ੍ੱਤਿਮਪ੍ਰਾਪ੍ਯ ਕੋਪਿ ਮਮਾਨ੍ਤਿਕਮ੍ ਆਗਨ੍ਤੁੰ ਨ ਸ਼ਕ੍ਨੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","ਤਤ੍ਕਾਲੇ(ਅ)ਨੇਕੇ ਸ਼ਿਸ਼਼੍ਯਾ ਵ੍ਯਾਘੁਟ੍ਯ ਤੇਨ ਸਾਰ੍ੱਧੰ ਪੁਨ ਰ੍ਨਾਗੱਛਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","ਤਦਾ ਯੀਸ਼ੁ ਰ੍ਦ੍ਵਾਦਸ਼ਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਉਕ੍ੱਤਵਾਨ੍ ਯੂਯਮਪਿ ਕਿੰ ਯਾਸ੍ਯਥ? ");
INSERT INTO sanpun_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ਤਤਃ ਸ਼ਿਮੋਨ੍ ਪਿਤਰਃ ਪ੍ਰਤ੍ਯਵੋਚਤ੍ ਹੇ ਪ੍ਰਭੋ ਕਸ੍ਯਾਭ੍ਯਰ੍ਣੰ ਗਮਿਸ਼਼੍ਯਾਮਃ? ");
INSERT INTO sanpun_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ਅਨਨ੍ਤਜੀਵਨਦਾਯਿਨ੍ਯੋ ਯਾਃ ਕਥਾਸ੍ਤਾਸ੍ਤਵੈਵ| ਭਵਾਨ੍ ਅਮਰੇਸ਼੍ਵਰਸ੍ਯਾਭਿਸ਼਼ਿਕ੍ੱਤਪੁਤ੍ਰ ਇਤਿ ਵਿਸ਼੍ਵਸ੍ਯ ਨਿਸ਼੍ਚਿਤੰ ਜਾਨੀਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","ਤਦਾ ਯੀਸ਼ੁਰਵਦਤ੍ ਕਿਮਹੰ ਯੁਸ਼਼੍ਮਾਕੰ ਦ੍ਵਾਦਸ਼ਜਨਾਨ੍ ਮਨੋਨੀਤਾਨ੍ ਨ ਕ੍ਰੁʼਤਵਾਨ੍? ਕਿਨ੍ਤੁ ਯੁਸ਼਼੍ਮਾਕੰ ਮਧ੍ਯੇਪਿ ਕਸ਼੍ਚਿਦੇਕੋ ਵਿਘ੍ਨਕਾਰੀ ਵਿਦ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ਇਮਾਂ ਕਥੰ ਸ ਸ਼ਿਮੋਨਃ ਪੁਤ੍ਰਮ੍ ਈਸ਼਼੍ਕਰੀਯੋਤੀਯੰ ਯਿਹੂਦਾਮ੍ ਉੱਦਿਸ਼੍ਯ ਕਥਿਤਵਾਨ੍ ਯਤੋ ਦ੍ਵਾਦਸ਼ਾਨਾਂ ਮਧ੍ਯੇ ਗਣਿਤਃ ਸ ਤੰ ਪਰਕਰੇਸ਼਼ੁ ਸਮਰ੍ਪਯਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ਤਤਃ ਪਰੰ ਯਿਹੂਦੀਯਲੋਕਾਸ੍ਤੰ ਹਨ੍ਤੁੰ ਸਮੈਹਨ੍ਤ ਤਸ੍ਮਾਦ੍ ਯੀਸ਼ੁ ਰ੍ਯਿਹੂਦਾਪ੍ਰਦੇਸ਼ੇ ਪਰ੍ੱਯਟਿਤੁੰ ਨੇੱਛਨ੍ ਗਾਲੀਲ੍ ਪ੍ਰਦੇਸ਼ੇ ਪਰ੍ੱਯਟਿਤੁੰ ਪ੍ਰਾਰਭਤ| ");
INSERT INTO sanpun_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","ਕਿਨ੍ਤੁ ਤਸ੍ਮਿਨ੍ ਸਮਯੇ ਯਿਹੂਦੀਯਾਨਾਂ ਦੂਸ਼਼੍ਯਵਾਸਨਾਮੋਤ੍ਸਵ ਉਪਸ੍ਥਿਤੇ ");
INSERT INTO sanpun_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ਤਸ੍ਯ ਭ੍ਰਾਤਰਸ੍ਤਮ੍ ਅਵਦਨ੍ ਯਾਨਿ ਕਰ੍ੰਮਾਣਿ ਤ੍ਵਯਾ ਕ੍ਰਿਯਨ੍ਤੇ ਤਾਨਿ ਯਥਾ ਤਵ ਸ਼ਿਸ਼਼੍ਯਾਃ ਪਸ਼੍ਯਨ੍ਤਿ ਤਦਰ੍ਥੰ ਤ੍ਵਮਿਤਃ ਸ੍ਥਾਨਾਦ੍ ਯਿਹੂਦੀਯਦੇਸ਼ੰ ਵ੍ਰਜ| ");
INSERT INTO sanpun_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ਯਃ ਕਸ਼੍ਚਿਤ੍ ਸ੍ਵਯੰ ਪ੍ਰਚਿਕਾਸ਼ਿਸ਼਼ਤਿ ਸ ਕਦਾਪਿ ਗੁਪ੍ਤੰ ਕਰ੍ੰਮ ਨ ਕਰੋਤਿ ਯਦੀਦ੍ਰੁʼਸ਼ੰ ਕਰ੍ੰਮ ਕਰੋਸ਼਼ਿ ਤਰ੍ਹਿ ਜਗਤਿ ਨਿਜੰ ਪਰਿਚਾਯਯ| ");
INSERT INTO sanpun_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ਯਤਸ੍ਤਸ੍ਯ ਭ੍ਰਾਤਰੋਪਿ ਤੰ ਨ ਵਿਸ਼੍ਵਸਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","ਤਦਾ ਯੀਸ਼ੁਸ੍ਤਾਨ੍ ਅਵੋਚਤ੍ ਮਮ ਸਮਯ ਇਦਾਨੀਂ ਨੋਪਤਿਸ਼਼੍ਠਤਿ ਕਿਨ੍ਤੁ ਯੁਸ਼਼੍ਮਾਕੰ ਸਮਯਃ ਸਤਤਮ੍ ਉਪਤਿਸ਼਼੍ਠਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","ਜਗਤੋ ਲੋਕਾ ਯੁਸ਼਼੍ਮਾਨ੍ ਰੁʼਤੀਯਿਤੁੰ ਨ ਸ਼ਕ੍ਰੁਵਨ੍ਤਿ ਕਿਨ੍ਤੁ ਮਾਮੇਵ ਰੁʼਤੀਯਨ੍ਤੇ ਯਤਸ੍ਤੇਸ਼਼ਾਂ ਕਰ੍ਮਾਣਿ ਦੁਸ਼਼੍ਟਾਨਿ ਤਤ੍ਰ ਸਾਕ੍ਸ਼਼੍ਯਮਿਦਮ੍ ਅਹੰ ਦਦਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","ਅਤਏਵ ਯੂਯਮ੍ ਉਤ੍ਸਵੇ(ਅ)ਸ੍ਮਿਨ੍ ਯਾਤ ਨਾਹਮ੍ ਇਦਾਨੀਮ੍ ਅਸ੍ਮਿੰਨੁਤ੍ਸਵੇ ਯਾਮਿ ਯਤੋ ਮਮ ਸਮਯ ਇਦਾਨੀਂ ਨ ਸਮ੍ਪੂਰ੍ਣਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ਇਤਿ ਵਾਕ੍ਯਮ੍ ਉਕ੍ੱਤ੍ਵਾ ਸ ਗਾਲੀਲਿ ਸ੍ਥਿਤਵਾਨ੍ ");
INSERT INTO sanpun_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","ਕਿਨ੍ਤੁ ਤਸ੍ਯ ਭ੍ਰਾਤ੍ਰੁʼਸ਼਼ੁ ਤਤ੍ਰ ਪ੍ਰਸ੍ਥਿਤੇਸ਼਼ੁ ਸਤ੍ਸੁ ਸੋ(ਅ)ਪ੍ਰਕਟ ਉਤ੍ਸਵਮ੍ ਅਗੱਛਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","ਅਨਨ੍ਤਰਮ੍ ਉਤ੍ਸਵਮ੍ ਉਪਸ੍ਥਿਤਾ ਯਿਹੂਦੀਯਾਸ੍ਤੰ ਮ੍ਰੁʼਗਯਿਤ੍ਵਾਪ੍ਰੁʼੱਛਨ੍ ਸ ਕੁਤ੍ਰ? ");
INSERT INTO sanpun_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","ਤਤੋ ਲੋਕਾਨਾਂ ਮਧ੍ਯੇ ਤਸ੍ਮਿਨ੍ ਨਾਨਾਵਿਧਾ ਵਿਵਾਦਾ ਭਵਿਤੁਮ੍ ਆਰਬ੍ਧਵਨ੍ਤਃ| ਕੇਚਿਦ੍ ਅਵੋਚਨ੍ ਸ ਉੱਤਮਃ ਪੁਰੁਸ਼਼ਃ ਕੇਚਿਦ੍ ਅਵੋਚਨ੍ ਨ ਤਥਾ ਵਰੰ ਲੋਕਾਨਾਂ ਭ੍ਰਮੰ ਜਨਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","ਕਿਨ੍ਤੁ ਯਿਹੂਦੀਯਾਨਾਂ ਭਯਾਤ੍ ਕੋਪਿ ਤਸ੍ਯ ਪਕ੍ਸ਼਼ੇ ਸ੍ਪਸ਼਼੍ਟੰ ਨਾਕਥਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ਤਤਃ ਪਰਮ੍ ਉਤ੍ਸਵਸ੍ਯ ਮਧ੍ਯਸਮਯੇ ਯੀਸ਼ੁ ਰ੍ਮਨ੍ਦਿਰੰ ਗਤ੍ਵਾ ਸਮੁਪਦਿਸ਼ਤਿ ਸ੍ਮ| ");
INSERT INTO sanpun_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ਤਤੋ ਯਿਹੂਦੀਯਾ ਲੋਕਾ ਆਸ਼੍ਚਰ੍ੱਯੰ ਜ੍ਞਾਤ੍ਵਾਕਥਯਨ੍ ਏਸ਼਼ਾ ਮਾਨੁਸ਼਼ੋ ਨਾਧੀਤ੍ਯਾ ਕਥਮ੍ ਏਤਾਦ੍ਰੁʼਸ਼ੋ ਵਿਦ੍ਵਾਨਭੂਤ੍? ");
INSERT INTO sanpun_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","ਤਦਾ ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯਵੋਚਦ੍ ਉਪਦੇਸ਼ੋਯੰ ਨ ਮਮ ਕਿਨ੍ਤੁ ਯੋ ਮਾਂ ਪ੍ਰੇਸ਼਼ਿਤਵਾਨ੍ ਤਸ੍ਯ| ");
INSERT INTO sanpun_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","ਯੋ ਜਨੋ ਨਿਦੇਸ਼ੰ ਤਸ੍ਯ ਗ੍ਰਹੀਸ਼਼੍ਯਤਿ ਮਮੋਪਦੇਸ਼ੋ ਮੱਤੋ ਭਵਤਿ ਕਿਮ੍ ਈਸ਼੍ਵਰਾਦ੍ ਭਵਤਿ ਸ ਗਨਸ੍ਤੱਜ੍ਞਾਤੁੰ ਸ਼ਕ੍ਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","ਯੋ ਜਨਃ ਸ੍ਵਤਃ ਕਥਯਤਿ ਸ ਸ੍ਵੀਯੰ ਗੌਰਵਮ੍ ਈਹਤੇ ਕਿਨ੍ਤੁ ਯਃ ਪ੍ਰੇਰਯਿਤੁ ਰ੍ਗੌਰਵਮ੍ ਈਹਤੇ ਸ ਸਤ੍ਯਵਾਦੀ ਤਸ੍ਮਿਨ੍ ਕੋਪ੍ਯਧਰ੍ੰਮੋ ਨਾਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","ਮੂਸਾ ਯੁਸ਼਼੍ਮਭ੍ਯੰ ਵ੍ਯਵਸ੍ਥਾਗ੍ਰਨ੍ਥੰ ਕਿੰ ਨਾਦਦਾਤ੍? ਕਿਨ੍ਤੁ ਯੁਸ਼਼੍ਮਾਕੰ ਕੋਪਿ ਤਾਂ ਵ੍ਯਵਸ੍ਥਾਂ ਨ ਸਮਾਚਰਤਿ| ਮਾਂ ਹਨ੍ਤੁੰ ਕੁਤੋ ਯਤਧ੍ਵੇ? ");
INSERT INTO sanpun_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","ਤਦਾ ਲੋਕਾ ਅਵਦਨ੍ ਤ੍ਵੰ ਭੂਤਗ੍ਰਸ੍ਤਸ੍ਤ੍ਵਾਂ ਹਨ੍ਤੁੰ ਕੋ ਯਤਤੇ? ");
INSERT INTO sanpun_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ਤਤੋ ਯੀਸ਼ੁਰਵੋਚਦ੍ ਏਕੰ ਕਰ੍ੰਮ ਮਯਾਕਾਰਿ ਤਸ੍ਮਾਦ੍ ਯੂਯੰ ਸਰ੍ੱਵ ਮਹਾਸ਼੍ਚਰ੍ੱਯੰ ਮਨ੍ਯਧ੍ਵੇ| ");
INSERT INTO sanpun_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","ਮੂਸਾ ਯੁਸ਼਼੍ਮਭ੍ਯੰ ਤ੍ਵਕ੍ਛੇਦਵਿਧਿੰ ਪ੍ਰਦਦੌ ਸ ਮੂਸਾਤੋ ਨ ਜਾਤਃ ਕਿਨ੍ਤੁ ਪਿਤ੍ਰੁʼਪੁਰੁਸ਼਼ੇਭ੍ਯੋ ਜਾਤਃ ਤੇਨ ਵਿਸ਼੍ਰਾਮਵਾਰੇ(ਅ)ਪਿ ਮਾਨੁਸ਼਼ਾਣਾਂ ਤ੍ਵਕ੍ਛੇਦੰ ਕੁਰੁਥ| ");
INSERT INTO sanpun_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ਅਤਏਵ ਵਿਸ਼੍ਰਾਮਵਾਰੇ ਮਨੁਸ਼਼੍ਯਾਣਾਂ ਤ੍ਵਕ੍ਛੇਦੇ ਕ੍ਰੁʼਤੇ ਯਦਿ ਮੂਸਾਵ੍ਯਵਸ੍ਥਾਮਙ੍ਗਨੰ ਨ ਭਵਤਿ ਤਰ੍ਹਿ ਮਯਾ ਵਿਸ਼੍ਰਾਮਵਾਰੇ ਮਾਨੁਸ਼਼ਃ ਸਮ੍ਪੂਰ੍ਣਰੂਪੇਣ ਸ੍ਵਸ੍ਥੋ(ਅ)ਕਾਰਿ ਤਤ੍ਕਾਰਣਾਦ੍ ਯੂਯੰ ਕਿੰ ਮਹ੍ਯੰ ਕੁਪ੍ਯਥ? ");
INSERT INTO sanpun_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","ਸਪਕ੍ਸ਼਼ਪਾਤੰ ਵਿਚਾਰਮਕ੍ਰੁʼਤ੍ਵਾ ਨ੍ਯਾੱਯੰ ਵਿਚਾਰੰ ਕੁਰੁਤ| ");
INSERT INTO sanpun_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","ਤਦਾ ਯਿਰੂਸ਼ਾਲਮ੍ ਨਿਵਾਸਿਨਃ ਕਤਿਪਯਜਨਾ ਅਕਥਯਨ੍ ਇਮੇ ਯੰ ਹਨ੍ਤੁੰ ਚੇਸ਼਼੍ਟਨ੍ਤੇ ਸ ਏਵਾਯੰ ਕਿੰ ਨ? ");
INSERT INTO sanpun_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","ਕਿਨ੍ਤੁ ਪਸ਼੍ਯਤ ਨਿਰ੍ਭਯਃ ਸਨ੍ ਕਥਾਂ ਕਥਯਤਿ ਤਥਾਪਿ ਕਿਮਪਿ ਅ ਵਦਨ੍ਤ੍ਯੇਤੇ ਅਯਮੇਵਾਭਿਸ਼਼ਿਕ੍ੱਤੋ ਭਵਤੀਤਿ ਨਿਸ਼੍ਚਿਤੰ ਕਿਮਧਿਪਤਯੋ ਜਾਨਨ੍ਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","ਮਨੁਜੋਯੰ ਕਸ੍ਮਾਦਾਗਮਦ੍ ਇਤਿ ਵਯੰ ਜਾਨੋਮਃ ਕਿਨ੍ਤ੍ਵਭਿਸ਼਼ਿਕ੍ੱਤ ਆਗਤੇ ਸ ਕਸ੍ਮਾਦਾਗਤਵਾਨ੍ ਇਤਿ ਕੋਪਿ ਜ੍ਞਾਤੁੰ ਨ ਸ਼ਕ੍ਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","ਤਦਾ ਯੀਸ਼ੁ ਰ੍ਮਧ੍ਯੇਮਨ੍ਦਿਰਮ੍ ਉਪਦਿਸ਼ਨ੍ ਉੱਚੈਃਕਾਰਮ੍ ਉਕ੍ੱਤਵਾਨ੍ ਯੂਯੰ ਕਿੰ ਮਾਂ ਜਾਨੀਥ? ਕਸ੍ਮਾੱਚਾਗਤੋਸ੍ਮਿ ਤਦਪਿ ਕਿੰ ਜਾਨੀਥ? ਨਾਹੰ ਸ੍ਵਤ ਆਗਤੋਸ੍ਮਿ ਕਿਨ੍ਤੁ ਯਃ ਸਤ੍ਯਵਾਦੀ ਸਏਵ ਮਾਂ ਪ੍ਰੇਸ਼਼ਿਤਵਾਨ੍ ਯੂਯੰ ਤੰ ਨ ਜਾਨੀਥ| ");
INSERT INTO sanpun_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ਤਮਹੰ ਜਾਨੇ ਤੇਨਾਹੰ ਪ੍ਰੇਰਿਤ ਅਗਤੋਸ੍ਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","ਤਸ੍ਮਾਦ੍ ਯਿਹੂਦੀਯਾਸ੍ਤੰ ਧਰ੍ੱਤੁਮ੍ ਉਦ੍ਯਤਾਸ੍ਤਥਾਪਿ ਕੋਪਿ ਤਸ੍ਯ ਗਾਤ੍ਰੇ ਹਸ੍ਤੰ ਨਾਰ੍ਪਯਦ੍ ਯਤੋ ਹੇਤੋਸ੍ਤਦਾ ਤਸ੍ਯ ਸਮਯੋ ਨੋਪਤਿਸ਼਼੍ਠਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","ਕਿਨ੍ਤੁ ਬਹਵੋ ਲੋਕਾਸ੍ਤਸ੍ਮਿਨ੍ ਵਿਸ਼੍ਵਸ੍ਯ ਕਥਿਤਵਾਨ੍ਤੋ(ਅ)ਭਿਸ਼਼ਿਕ੍ੱਤਪੁਰੁਸ਼਼ ਆਗਤ੍ਯ ਮਾਨੁਸ਼਼ਸ੍ਯਾਸ੍ਯ ਕ੍ਰਿਯਾਭ੍ਯਃ ਕਿਮ੍ ਅਧਿਕਾ ਆਸ਼੍ਚਰ੍ੱਯਾਃ ਕ੍ਰਿਯਾਃ ਕਰਿਸ਼਼੍ਯਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","ਤਤਃ ਪਰੰ ਲੋਕਾਸ੍ਤਸ੍ਮਿਨ੍ ਇੱਥੰ ਵਿਵਦਨ੍ਤੇ ਫਿਰੂਸ਼ਿਨਃ ਪ੍ਰਧਾਨਯਾਜਕਾਞ੍ਚੇਤਿ ਸ਼੍ਰੁਤਵਨ੍ਤਸ੍ਤੰ ਧ੍ਰੁʼਤ੍ਵਾ ਨੇਤੁੰ ਪਦਾਤਿਗਣੰ ਪ੍ਰੇਸ਼਼ਯਾਮਾਸੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ਤਤੋ ਯੀਸ਼ੁਰਵਦਦ੍ ਅਹਮ੍ ਅਲ੍ਪਦਿਨਾਨਿ ਯੁਸ਼਼੍ਮਾਭਿਃ ਸਾਰ੍ੱਧੰ ਸ੍ਥਿਤ੍ਵਾ ਮਤ੍ਪ੍ਰੇਰਯਿਤੁਃ ਸਮੀਪੰ ਯਾਸ੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","ਮਾਂ ਮ੍ਰੁʼਗਯਿਸ਼਼੍ਯਧ੍ਵੇ ਕਿਨ੍ਤੂੱਦੇਸ਼ੰ ਨ ਲਪ੍ਸ੍ਯਧ੍ਵੇ ਰਤ੍ਰ ਸ੍ਥਾਸ੍ਯਾਮਿ ਤਤ੍ਰ ਯੂਯੰ ਗਨ੍ਤੁੰ ਨ ਸ਼ਕ੍ਸ਼਼੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","ਤਦਾ ਯਿਹੂਦੀਯਾਃ ਪਰਸ੍ਪਰੰ ਵਕ੍ੱਤੁਮਾਰੇਭਿਰੇ ਅਸ੍ਯੋੱਦੇਸ਼ੰ ਨ ਪ੍ਰਾਪ੍ਸ੍ਯਾਮ ਏਤਾਦ੍ਰੁʼਸ਼ੰ ਕਿੰ ਸ੍ਥਾਨੰ ਯਾਸ੍ਯਤਿ? ਭਿੰਨਦੇਸ਼ੇ ਵਿਕੀਰ੍ਣਾਨਾਂ ਯਿਹੂਦੀਯਾਨਾਂ ਸੰਨਿਧਿਮ੍ ਏਸ਼਼ ਗਤ੍ਵਾ ਤਾਨ੍ ਉਪਦੇਕ੍ਸ਼਼੍ਯਤਿ ਕਿੰ? ");
INSERT INTO sanpun_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","ਨੋ ਚੇਤ੍ ਮਾਂ ਗਵੇਸ਼਼ਯਿਸ਼਼੍ਯਥ ਕਿਨ੍ਤੂੱਦੇਸ਼ੰ ਨ ਪ੍ਰਾਪ੍ਸ੍ਯਥ ਏਸ਼਼ ਕੋਦ੍ਰੁʼਸ਼ੰ ਵਾਕ੍ਯਮਿਦੰ ਵਦਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","ਅਨਨ੍ਤਰਮ੍ ਉਤ੍ਸਵਸ੍ਯ ਚਰਮੇ(ਅ)ਹਨਿ ਅਰ੍ਥਾਤ੍ ਪ੍ਰਧਾਨਦਿਨੇ ਯੀਸ਼ੁਰੁੱਤਿਸ਼਼੍ਠਨ੍ ਉੱਚੈਃਕਾਰਮ੍ ਆਹ੍ਵਯਨ੍ ਉਦਿਤਵਾਨ੍ ਯਦਿ ਕਸ਼੍ਚਿਤ੍ ਤ੍ਰੁʼਸ਼਼ਾਰ੍ੱਤੋ ਭਵਤਿ ਤਰ੍ਹਿ ਮਮਾਨ੍ਤਿਕਮ੍ ਆਗਤ੍ਯ ਪਿਵਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ਯਃ ਕਸ਼੍ਚਿਨ੍ਮਯਿ ਵਿਸ਼੍ਵਸਿਤਿ ਧਰ੍ੰਮਗ੍ਰਨ੍ਥਸ੍ਯ ਵਚਨਾਨੁਸਾਰੇਣ ਤਸ੍ਯਾਭ੍ਯਨ੍ਤਰਤੋ(ਅ)ਮ੍ਰੁʼਤਤੋਯਸ੍ਯ ਸ੍ਰੋਤਾਂਸਿ ਨਿਰ੍ਗਮਿਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ਯੇ ਤਸ੍ਮਿਨ੍ ਵਿਸ਼੍ਵਸਨ੍ਤਿ ਤ ਆਤ੍ਮਾਨੰ ਪ੍ਰਾਪ੍ਸ੍ਯਨ੍ਤੀਤ੍ਯਰ੍ਥੇ ਸ ਇਦੰ ਵਾਕ੍ਯੰ ਵ੍ਯਾਹ੍ਰੁʼਤਵਾਨ੍ ਏਤਤ੍ਕਾਲੰ ਯਾਵਦ੍ ਯੀਸ਼ੁ ਰ੍ਵਿਭਵੰ ਨ ਪ੍ਰਾਪ੍ਤਸ੍ਤਸ੍ਮਾਤ੍ ਪਵਿਤ੍ਰ ਆਤ੍ਮਾ ਨਾਦੀਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ਏਤਾਂ ਵਾਣੀਂ ਸ਼੍ਰੁਤ੍ਵਾ ਬਹਵੋ ਲੋਕਾ ਅਵਦਨ੍ ਅਯਮੇਵ ਨਿਸ਼੍ਚਿਤੰ ਸ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦੀ| ");
INSERT INTO sanpun_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","ਕੇਚਿਦ੍ ਅਕਥਯਨ੍ ਏਸ਼਼ਏਵ ਸੋਭਿਸ਼਼ਿਕ੍ੱਤਃ ਕਿਨ੍ਤੁ ਕੇਚਿਦ੍ ਅਵਦਨ੍ ਸੋਭਿਸ਼਼ਿਕ੍ੱਤਃ ਕਿੰ ਗਾਲੀਲ੍ ਪ੍ਰਦੇਸ਼ੇ ਜਨਿਸ਼਼੍ਯਤੇ? ");
INSERT INTO sanpun_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","ਸੋਭਿਸ਼਼ਿਕ੍ੱਤੋ ਦਾਯੂਦੋ ਵੰਸ਼ੇ ਦਾਯੂਦੋ ਜਨ੍ਮਸ੍ਥਾਨੇ ਬੈਤ੍ਲੇਹਮਿ ਪੱਤਨੇ ਜਨਿਸ਼਼੍ਯਤੇ ਧਰ੍ੰਮਗ੍ਰਨ੍ਥੇ ਕਿਮਿੱਥੰ ਲਿਖਿਤੰ ਨਾਸ੍ਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ਇੱਥੰ ਤਸ੍ਮਿਨ੍ ਲੋਕਾਨਾਂ ਭਿੰਨਵਾਕ੍ਯਤਾ ਜਾਤਾ| ");
INSERT INTO sanpun_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","ਕਤਿਪਯਲੋਕਾਸ੍ਤੰ ਧਰ੍ੱਤੁਮ੍ ਐੱਛਨ੍ ਤਥਾਪਿ ਤਦ੍ਵਪੁਸ਼਼ਿ ਕੋਪਿ ਹਸ੍ਤੰ ਨਾਰ੍ਪਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","ਅਨਨ੍ਤਰੰ ਪਾਦਾਤਿਗਣੇ ਪ੍ਰਧਾਨਯਾਜਕਾਨਾਂ ਫਿਰੂਸ਼ਿਨਾਞ੍ਚ ਸਮੀਪਮਾਗਤਵਤਿ ਤੇ ਤਾਨ੍ ਅਪ੍ਰੁʼੱਛਨ੍ ਕੁਤੋ ਹੇਤੋਸ੍ਤੰ ਨਾਨਯਤ? ");
INSERT INTO sanpun_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","ਤਦਾ ਪਦਾਤਯਃ ਪ੍ਰਤ੍ਯਵਦਨ੍ ਸ ਮਾਨਵ ਇਵ ਕੋਪਿ ਕਦਾਪਿ ਨੋਪਾਦਿਸ਼ਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ਤਤਃ ਫਿਰੂਸ਼ਿਨਃ ਪ੍ਰਾਵੋਚਨ੍ ਯੂਯਮਪਿ ਕਿਮਭ੍ਰਾਮਿਸ਼਼੍ਟ? ");
INSERT INTO sanpun_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","ਅਧਿਪਤੀਨਾਂ ਫਿਰੂਸ਼ਿਨਾਞ੍ਚ ਕੋਪਿ ਕਿੰ ਤਸ੍ਮਿਨ੍ ਵ੍ਯਸ਼੍ਵਸੀਤ੍? ");
INSERT INTO sanpun_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ਯੇ ਸ਼ਾਸ੍ਤ੍ਰੰ ਨ ਜਾਨਨ੍ਤਿ ਤ ਇਮੇ(ਅ)ਧਮਲੋਕਾਏਵ ਸ਼ਾਪਗ੍ਰਸ੍ਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ਤਦਾ ਨਿਕਦੀਮਨਾਮਾ ਤੇਸ਼਼ਾਮੇਕੋ ਯਃ ਕ੍ਸ਼਼ਣਦਾਯਾਂ ਯੀਸ਼ੋਃ ਸੰਨਿਧਿਮ੍ ਅਗਾਤ੍ ਸ ਉਕ੍ੱਤਵਾਨ੍ ");
INSERT INTO sanpun_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","ਤਸ੍ਯ ਵਾਕ੍ਯੇ ਨ ਸ਼੍ਰੁਤੇ ਕਰ੍ੰਮਣਿ ਚ ਨ ਵਿਦਿਤੇ (ਅ)ਸ੍ਮਾਕੰ ਵ੍ਯਵਸ੍ਥਾ ਕਿੰ ਕਞ੍ਚਨ ਮਨੁਜੰ ਦੋਸ਼਼ੀਕਰੋਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ਤਤਸ੍ਤੇ ਵ੍ਯਾਹਰਨ੍ ਤ੍ਵਮਪਿ ਕਿੰ ਗਾਲੀਲੀਯਲੋਕਃ? ਵਿਵਿਚ੍ਯ ਪਸ਼੍ਯ ਗਲੀਲਿ ਕੋਪਿ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦੀ ਨੋਤ੍ਪਦ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","ਤਤਃ ਪਰੰ ਸਰ੍ੱਵੇ ਸ੍ਵੰ ਸ੍ਵੰ ਗ੍ਰੁʼਹੰ ਗਤਾਃ ਕਿਨ੍ਤੁ ਯੀਸ਼ੁ ਰ੍ਜੈਤੁਨਨਾਮਾਨੰ ਸ਼ਿਲੋੱਚਯੰ ਗਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ਪ੍ਰਤ੍ਯੂਸ਼਼ੇ ਯੀਸ਼ੁਃ ਪਨਰ੍ਮਨ੍ਦਿਰਮ੍ ਆਗੱਛਤ੍ ");
INSERT INTO sanpun_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ਤਤਃ ਸਰ੍ੱਵੇਸ਼਼ੁ ਲੋਕੇਸ਼਼ੁ ਤਸ੍ਯ ਸਮੀਪ ਆਗਤੇਸ਼਼ੁ ਸ ਉਪਵਿਸ਼੍ਯ ਤਾਨ੍ ਉਪਦੇਸ਼਼੍ਟੁਮ੍ ਆਰਭਤ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ਤਦਾ ਅਧ੍ਯਾਪਕਾਃ ਫਿਰੂਸ਼ਿਨਞ੍ਚ ਵ੍ਯਭਿਚਾਰਕਰ੍ੰਮਣਿ ਧ੍ਰੁʼਤੰ ਸ੍ਤ੍ਰਿਯਮੇਕਾਮ੍ ਆਨਿਯ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਮਧ੍ਯੇ ਸ੍ਥਾਪਯਿਤ੍ਵਾ ਵ੍ਯਾਹਰਨ੍ ");
INSERT INTO sanpun_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ਹੇ ਗੁਰੋ ਯੋਸ਼਼ਿਤਮ੍ ਇਮਾਂ ਵ੍ਯਭਿਚਾਰਕਰ੍ੰਮ ਕੁਰ੍ੱਵਾਣਾਂ ਲੋਕਾ ਧ੍ਰੁʼਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ਏਤਾਦ੍ਰੁʼਸ਼ਲੋਕਾਃ ਪਾਸ਼਼ਾਣਾਘਾਤੇਨ ਹਨ੍ਤਵ੍ਯਾ ਇਤਿ ਵਿਧਿਰ੍ਮੂਸਾਵ੍ਯਵਸ੍ਥਾਗ੍ਰਨ੍ਥੇ ਲਿਖਿਤੋਸ੍ਤਿ ਕਿਨ੍ਤੁ ਭਵਾਨ੍ ਕਿਮਾਦਿਸ਼ਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","ਤੇ ਤਮਪਵਦਿਤੁੰ ਪਰੀਕ੍ਸ਼਼ਾਭਿਪ੍ਰਾਯੇਣ ਵਾਕ੍ਯਮਿਦਮ੍ ਅਪ੍ਰੁʼੱਛਨ੍ ਕਿਨ੍ਤੁ ਸ ਪ੍ਰਹ੍ਵੀਭੂਯ ਭੂਮਾਵਙ੍ਗਲ੍ਯਾ ਲੇਖਿਤੁਮ੍ ਆਰਭਤ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ਤਤਸ੍ਤੈਃ ਪੁਨਃ ਪੁਨਃ ਪ੍ਰੁʼਸ਼਼੍ਟ ਉੱਥਾਯ ਕਥਿਤਵਾਨ੍ ਯੁਸ਼਼੍ਮਾਕੰ ਮਧ੍ਯੇ ਯੋ ਜਨੋ ਨਿਰਪਰਾਧੀ ਸਏਵ ਪ੍ਰਥਮਮ੍ ਏਨਾਂ ਪਾਸ਼਼ਾਣੇਨਾਹਨ੍ਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ਪਸ਼੍ਚਾਤ੍ ਸ ਪੁਨਸ਼੍ਚ ਪ੍ਰਹ੍ਵੀਭੂਯ ਭੂਮੌ ਲੇਖਿਤੁਮ੍ ਆਰਭਤ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ਤਾਂ ਕਥੰ ਸ਼੍ਰੁਤ੍ਵਾ ਤੇ ਸ੍ਵਸ੍ਵਮਨਸਿ ਪ੍ਰਬੋਧੰ ਪ੍ਰਾਪ੍ਯ ਜ੍ਯੇਸ਼਼੍ਠਾਨੁਕ੍ਰਮੰ ਏਕੈਕਸ਼ਃ ਸਰ੍ੱਵੇ ਬਹਿਰਗੱਛਨ੍ ਤਤੋ ਯੀਸ਼ੁਰੇਕਾਕੀ ਤਯਕ੍ੱਤੋਭਵਤ੍ ਮਧ੍ਯਸ੍ਥਾਨੇ ਦਣ੍ਡਾਯਮਾਨਾ ਸਾ ਯੋਸ਼਼ਾ ਚ ਸ੍ਥਿਤਾ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ਤਤ੍ਪਸ਼੍ਚਾਦ੍ ਯੀਸ਼ੁਰੁੱਥਾਯ ਤਾਂ ਵਨਿਤਾਂ ਵਿਨਾ ਕਮਪ੍ਯਪਰੰ ਨ ਵਿਲੋਕ੍ਯ ਪ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍ ਹੇ ਵਾਮੇ ਤਵਾਪਵਾਦਕਾਃ ਕੁਤ੍ਰ? ਕੋਪਿ ਤ੍ਵਾਂ ਕਿੰ ਨ ਦਣ੍ਡਯਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","ਸਾਵਦਤ੍ ਹੇ ਮਹੇੱਛ ਕੋਪਿ ਨ ਤਦਾ ਯੀਸ਼ੁਰਵੋਚਤ੍ ਨਾਹਮਪਿ ਦਣ੍ਡਯਾਮਿ ਯਾਹਿ ਪੁਨਃ ਪਾਪੰ ਮਾਕਾਰ੍ਸ਼਼ੀਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ਤਤੋ ਯੀਸ਼ੁਃ ਪੁਨਰਪਿ ਲੋਕੇਭ੍ਯ ਇੱਥੰ ਕਥਯਿਤੁਮ੍ ਆਰਭਤ ਜਗਤੋਹੰ ਜ੍ਯੋਤਿਃਸ੍ਵਰੂਪੋ ਯਃ ਕਸ਼੍ਚਿਨ੍ ਮਤ੍ਪਸ਼੍ਚਾਦ ਗੱਛਤਿ ਸ ਤਿਮਿਰੇ ਨ ਭ੍ਰਮਿਤ੍ਵਾ ਜੀਵਨਰੂਪਾਂ ਦੀਪ੍ਤਿੰ ਪ੍ਰਾਪ੍ਸ੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ਤਤਃ ਫਿਰੂਸ਼ਿਨੋ(ਅ)ਵਾਦਿਸ਼਼ੁਸ੍ਤ੍ਵੰ ਸ੍ਵਾਰ੍ਥੇ ਸ੍ਵਯੰ ਸਾਕ੍ਸ਼਼੍ਯੰ ਦਦਾਸਿ ਤਸ੍ਮਾਤ੍ ਤਵ ਸਾਕ੍ਸ਼਼੍ਯੰ ਗ੍ਰਾਹ੍ਯੰ ਨ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","ਤਦਾ ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯੁਦਿਤਵਾਨ੍ ਯਦ੍ਯਪਿ ਸ੍ਵਾਰ੍ਥੇ(ਅ)ਹੰ ਸ੍ਵਯੰ ਸਾਕ੍ਸ਼਼੍ਯੰ ਦਦਾਮਿ ਤਥਾਪਿ ਮਤ੍ ਸਾਕ੍ਸ਼਼੍ਯੰ ਗ੍ਰਾਹ੍ਯੰ ਯਸ੍ਮਾਦ੍ ਅਹੰ ਕੁਤ ਆਗਤੋਸ੍ਮਿ ਕ੍ਵ ਯਾਮਿ ਚ ਤਦਹੰ ਜਾਨਾਮਿ ਕਿਨ੍ਤੁ ਕੁਤ ਆਗਤੋਸ੍ਮਿ ਕੁਤ੍ਰ ਗੱਛਾਮਿ ਚ ਤਦ੍ ਯੂਯੰ ਨ ਜਾਨੀਥ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","ਯੂਯੰ ਲੌਕਿਕੰ ਵਿਚਾਰਯਥ ਨਾਹੰ ਕਿਮਪਿ ਵਿਚਾਰਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","ਕਿਨ੍ਤੁ ਯਦਿ ਵਿਚਾਰਯਾਮਿ ਤਰ੍ਹਿ ਮਮ ਵਿਚਾਰੋ ਗ੍ਰਹੀਤਵ੍ਯੋ ਯਤੋਹਮ੍ ਏਕਾਕੀ ਨਾਸ੍ਮਿ ਪ੍ਰੇਰਯਿਤਾ ਪਿਤਾ ਮਯਾ ਸਹ ਵਿਦ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","ਦ੍ਵਯੋ ਰ੍ਜਨਯੋਃ ਸਾਕ੍ਸ਼਼੍ਯੰ ਗ੍ਰਹਣੀਯੰ ਭਵਤੀਤਿ ਯੁਸ਼਼੍ਮਾਕੰ ਵ੍ਯਵਸ੍ਥਾਗ੍ਰਨ੍ਥੇ ਲਿਖਿਤਮਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ਅਹੰ ਸ੍ਵਾਰ੍ਥੇ ਸ੍ਵਯੰ ਸਾਕ੍ਸ਼਼ਿਤ੍ਵੰ ਦਦਾਮਿ ਯਸ਼੍ਚ ਮਮ ਤਾਤੋ ਮਾਂ ਪ੍ਰੇਰਿਤਵਾਨ੍ ਸੋਪਿ ਮਦਰ੍ਥੇ ਸਾਕ੍ਸ਼਼੍ਯੰ ਦਦਾਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ਤਦਾ ਤੇ(ਅ)ਪ੍ਰੁʼੱਛਨ੍ ਤਵ ਤਾਤਃ ਕੁਤ੍ਰ? ਤਤੋ ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯਵਾਦੀਦ੍ ਯੂਯੰ ਮਾਂ ਨ ਜਾਨੀਥ ਮਤ੍ਪਿਤਰਞ੍ਚ ਨ ਜਾਨੀਥ ਯਦਿ ਮਾਮ੍ ਅਕ੍ਸ਼਼ਾਸ੍ਯਤ ਤਰ੍ਹਿ ਮਮ ਤਾਤਮਪ੍ਯਕ੍ਸ਼਼ਾਸ੍ਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ਯੀਸ਼ੁ ਰ੍ਮਨ੍ਦਿਰ ਉਪਦਿਸ਼੍ਯ ਭਣ੍ਡਾਗਾਰੇ ਕਥਾ ਏਤਾ ਅਕਥਯਤ੍ ਤਥਾਪਿ ਤੰ ਪ੍ਰਤਿ ਕੋਪਿ ਕਰੰ ਨੋਦਤੋਲਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ਤਤਃ ਪਰੰ ਯੀਸ਼ੁਃ ਪੁਨਰੁਦਿਤਵਾਨ੍ ਅਧੁਨਾਹੰ ਗੱਛਾਮਿ ਯੂਯੰ ਮਾਂ ਗਵੇਸ਼਼ਯਿਸ਼਼੍ਯਥ ਕਿਨ੍ਤੁ ਨਿਜੈਃ ਪਾਪੈ ਰ੍ਮਰਿਸ਼਼੍ਯਥ ਯਤ੍ ਸ੍ਥਾਨਮ੍ ਅਹੰ ਯਾਸ੍ਯਾਮਿ ਤਤ੍ ਸ੍ਥਾਨਮ੍ ਯੂਯੰ ਯਾਤੁੰ ਨ ਸ਼ਕ੍ਸ਼਼੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","ਤਦਾ ਯਿਹੂਦੀਯਾਃ ਪ੍ਰਾਵੋਚਨ੍ ਕਿਮਯਮ੍ ਆਤ੍ਮਘਾਤੰ ਕਰਿਸ਼਼੍ਯਤਿ? ਯਤੋ ਯਤ੍ ਸ੍ਥਾਨਮ੍ ਅਹੰ ਯਾਸ੍ਯਾਮਿ ਤਤ੍ ਸ੍ਥਾਨਮ੍ ਯੂਯੰ ਯਾਤੁੰ ਨ ਸ਼ਕ੍ਸ਼਼੍ਯਥ ਇਤਿ ਵਾਕ੍ਯੰ ਬ੍ਰਵੀਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ਤਤੋ ਯੀਸ਼ੁਸ੍ਤੇਭ੍ਯਃ ਕਥਿਤਵਾਨ੍ ਯੂਯਮ੍ ਅਧਃਸ੍ਥਾਨੀਯਾ ਲੋਕਾ ਅਹਮ੍ ਊਰ੍ਦ੍ੱਵਸ੍ਥਾਨੀਯਃ ਯੂਯਮ੍ ਏਤੱਜਗਤ੍ਸਮ੍ਬਨ੍ਧੀਯਾ ਅਹਮ੍ ਏਤੱਜਗਤ੍ਸਮ੍ਬਨ੍ਧੀਯੋ ਨ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","ਤਸ੍ਮਾਤ੍ ਕਥਿਤਵਾਨ੍ ਯੂਯੰ ਨਿਜੈਃ ਪਾਪੈ ਰ੍ਮਰਿਸ਼਼੍ਯਥ ਯਤੋਹੰ ਸ ਪੁਮਾਨ੍ ਇਤਿ ਯਦਿ ਨ ਵਿਸ਼੍ਵਸਿਥ ਤਰ੍ਹਿ ਨਿਜੈਃ ਪਾਪੈ ਰ੍ਮਰਿਸ਼਼੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ਤਦਾ ਤੇ (ਅ)ਪ੍ਰੁʼੱਛਨ੍ ਕਸ੍ਤ੍ਵੰ? ਤਤੋ ਯੀਸ਼ੁਃ ਕਥਿਤਵਾਨ੍ ਯੁਸ਼਼੍ਮਾਕੰ ਸੰਨਿਧੌ ਯਸ੍ਯ ਪ੍ਰਸ੍ਤਾਵਮ੍ ਆ ਪ੍ਰਥਮਾਤ੍ ਕਰੋਮਿ ਸਏਵ ਪੁਰੁਸ਼਼ੋਹੰ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","ਯੁਸ਼਼੍ਮਾਸੁ ਮਯਾ ਬਹੁਵਾਕ੍ਯੰ ਵਕ੍ੱਤਵ੍ਯੰ ਵਿਚਾਰਯਿਤਵ੍ਯਞ੍ਚ ਕਿਨ੍ਤੁ ਮਤ੍ਪ੍ਰੇਰਯਿਤਾ ਸਤ੍ਯਵਾਦੀ ਤਸ੍ਯ ਸਮੀਪੇ ਯਦਹੰ ਸ਼੍ਰੁਤਵਾਨ੍ ਤਦੇਵ ਜਗਤੇ ਕਥਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","ਕਿਨ੍ਤੁ ਸ ਜਨਕੇ ਵਾਕ੍ਯਮਿਦੰ ਪ੍ਰੋਕ੍ੱਤਵਾਨ੍ ਇਤਿ ਤੇ ਨਾਬੁਧ੍ਯਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ਤਤੋ ਯੀਸ਼ੁਰਕਥਯਦ੍ ਯਦਾ ਮਨੁਸ਼਼੍ਯਪੁਤ੍ਰਮ੍ ਊਰ੍ਦ੍ੱਵ ਉੱਥਾਪਯਿਸ਼਼੍ਯਥ ਤਦਾਹੰ ਸ ਪੁਮਾਨ੍ ਕੇਵਲਃ ਸ੍ਵਯੰ ਕਿਮਪਿ ਕਰ੍ੰਮ ਨ ਕਰੋਮਿ ਕਿਨ੍ਤੁ ਤਾਤੋ ਯਥਾ ਸ਼ਿਕ੍ਸ਼਼ਯਤਿ ਤਦਨੁਸਾਰੇਣ ਵਾਕ੍ਯਮਿਦੰ ਵਦਾਮੀਤਿ ਚ ਯੂਯੰ ਜ੍ਞਾਤੁੰ ਸ਼ਕ੍ਸ਼਼੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","ਮਤ੍ਪ੍ਰੇਰਯਿਤਾ ਪਿਤਾ ਮਾਮ੍ ਏਕਾਕਿਨੰ ਨ ਤ੍ਯਜਤਿ ਸ ਮਯਾ ਸਾਰ੍ੱਧੰ ਤਿਸ਼਼੍ਠਤਿ ਯਤੋਹੰ ਤਦਭਿਮਤੰ ਕਰ੍ੰਮ ਸਦਾ ਕਰੋਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","ਤਦਾ ਤਸ੍ਯੈਤਾਨਿ ਵਾਕ੍ਯਾਨਿ ਸ਼੍ਰੁਤ੍ਵਾ ਬਹੁਵਸ੍ਤਾਸ੍ਮਿਨ੍ ਵ੍ਯਸ਼੍ਵਸਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","ਯੇ ਯਿਹੂਦੀਯਾ ਵ੍ਯਸ਼੍ਵਸਨ੍ ਯੀਸ਼ੁਸ੍ਤੇਭ੍ਯੋ(ਅ)ਕਥਯਤ੍ ");
INSERT INTO sanpun_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ਮਮ ਵਾਕ੍ਯੇ ਯਦਿ ਯੂਯਮ੍ ਆਸ੍ਥਾਂ ਕੁਰੁਥ ਤਰ੍ਹਿ ਮਮ ਸ਼ਿਸ਼਼੍ਯਾ ਭੂਤ੍ਵਾ ਸਤ੍ਯਤ੍ਵੰ ਜ੍ਞਾਸ੍ਯਥ ਤਤਃ ਸਤ੍ਯਤਯਾ ਯੁਸ਼਼੍ਮਾਕੰ ਮੋਕ੍ਸ਼਼ੋ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","ਤਦਾ ਤੇ ਪ੍ਰਤ੍ਯਵਾਦਿਸ਼਼ੁਃ ਵਯਮ੍ ਇਬ੍ਰਾਹੀਮੋ ਵੰਸ਼ਃ ਕਦਾਪਿ ਕਸ੍ਯਾਪਿ ਦਾਸਾ ਨ ਜਾਤਾਸ੍ਤਰ੍ਹਿ ਯੁਸ਼਼੍ਮਾਕੰ ਮੁਕ੍ੱਤਿ ਰ੍ਭਵਿਸ਼਼੍ਯਤੀਤਿ ਵਾਕ੍ਯੰ ਕਥੰ ਬ੍ਰਵੀਸ਼਼ਿ? ");
INSERT INTO sanpun_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","ਤਦਾ ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯਵਦਦ੍ ਯੁਸ਼਼੍ਮਾਨਹੰ ਯਥਾਰ੍ਥਤਰੰ ਵਦਾਮਿ ਯਃ ਪਾਪੰ ਕਰੋਤਿ ਸ ਪਾਪਸ੍ਯ ਦਾਸਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","ਦਾਸਸ਼੍ਚ ਨਿਰਨ੍ਤਰੰ ਨਿਵੇਸ਼ਨੇ ਨ ਤਿਸ਼਼੍ਠਤਿ ਕਿਨ੍ਤੁ ਪੁਤ੍ਰੋ ਨਿਰਨ੍ਤਰੰ ਤਿਸ਼਼੍ਠਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","ਅਤਃ ਪੁਤ੍ਰੋ ਯਦਿ ਯੁਸ਼਼੍ਮਾਨ੍ ਮੋਚਯਤਿ ਤਰ੍ਹਿ ਨਿਤਾਨ੍ਤਮੇਵ ਮੁਕ੍ੱਤਾ ਭਵਿਸ਼਼੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","ਯੁਯਮ੍ ਇਬ੍ਰਾਹੀਮੋ ਵੰਸ਼ ਇਤ੍ਯਹੰ ਜਾਨਾਮਿ ਕਿਨ੍ਤੁ ਮਮ ਕਥਾ ਯੁਸ਼਼੍ਮਾਕਮ੍ ਅਨ੍ਤਃਕਰਣੇਸ਼਼ੁ ਸ੍ਥਾਨੰ ਨ ਪ੍ਰਾਪ੍ਨੁਵਨ੍ਤਿ ਤਸ੍ਮਾੱਧੇਤੋ ਰ੍ਮਾਂ ਹਨ੍ਤੁਮ੍ ਈਹਧ੍ਵੇ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ਅਹੰ ਸ੍ਵਪਿਤੁਃ ਸਮੀਪੇ ਯਦਪਸ਼੍ਯੰ ਤਦੇਵ ਕਥਯਾਮਿ ਤਥਾ ਯੂਯਮਪਿ ਸ੍ਵਪਿਤੁਃ ਸਮੀਪੇ ਯਦਪਸ਼੍ਯਤ ਤਦੇਵ ਕੁਰੁਧ੍ਵੇ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","ਤਦਾ ਤੇ ਪ੍ਰਤ੍ਯਵੋਚਨ੍ ਇਬ੍ਰਾਹੀਮ੍ ਅਸ੍ਮਾਕੰ ਪਿਤਾ ਤਤੋ ਯੀਸ਼ੁਰਕਥਯਦ੍ ਯਦਿ ਯੂਯਮ੍ ਇਬ੍ਰਾਹੀਮਃ ਸਨ੍ਤਾਨਾ ਅਭਵਿਸ਼਼੍ਯਤ ਤਰ੍ਹਿ ਇਬ੍ਰਾਹੀਮ ਆਚਾਰਣਵਦ੍ ਆਚਰਿਸ਼਼੍ਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ਈਸ਼੍ਵਰਸ੍ਯ ਮੁਖਾਤ੍ ਸਤ੍ਯੰ ਵਾਕ੍ਯੰ ਸ਼੍ਰੁਤ੍ਵਾ ਯੁਸ਼਼੍ਮਾਨ੍ ਜ੍ਞਾਪਯਾਮਿ ਯੋਹੰ ਤੰ ਮਾਂ ਹਨ੍ਤੁੰ ਚੇਸ਼਼੍ਟਧ੍ਵੇ ਇਬ੍ਰਾਹੀਮ੍ ਏਤਾਦ੍ਰੁʼਸ਼ੰ ਕਰ੍ੰਮ ਨ ਚਕਾਰ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","ਯੂਯੰ ਸ੍ਵਸ੍ਵਪਿਤੁਃ ਕਰ੍ੰਮਾਣਿ ਕੁਰੁਥ ਤਦਾ ਤੈਰੁਕ੍ੱਤੰ ਨ ਵਯੰ ਜਾਰਜਾਤਾ ਅਸ੍ਮਾਕਮ੍ ਏਕਏਵ ਪਿਤਾਸ੍ਤਿ ਸ ਏਵੇਸ਼੍ਵਰਃ ");
INSERT INTO sanpun_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ਤਤੋ ਯੀਸ਼ੁਨਾ ਕਥਿਤਮ੍ ਈਸ਼੍ਵਰੋ ਯਦਿ ਯੁਸ਼਼੍ਮਾਕੰ ਤਾਤੋਭਵਿਸ਼਼੍ਯਤ੍ ਤਰ੍ਹਿ ਯੂਯੰ ਮਯਿ ਪ੍ਰੇਮਾਕਰਿਸ਼਼੍ਯਤ ਯਤੋਹਮ੍ ਈਸ਼੍ਵਰਾੰਨਿਰ੍ਗਤ੍ਯਾਗਤੋਸ੍ਮਿ ਸ੍ਵਤੋ ਨਾਗਤੋਹੰ ਸ ਮਾਂ ਪ੍ਰਾਹਿਣੋਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","ਯੂਯੰ ਮਮ ਵਾਕ੍ਯਮਿਦੰ ਨ ਬੁਧ੍ਯਧ੍ਵੇ ਕੁਤਃ? ਯਤੋ ਯੂਯੰ ਮਮੋਪਦੇਸ਼ੰ ਸੋਢੁੰ ਨ ਸ਼ਕ੍ਨੁਥ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","ਯੂਯੰ ਸ਼ੈਤਾਨ੍ ਪਿਤੁਃ ਸਨ੍ਤਾਨਾ ਏਤਸ੍ਮਾਦ੍ ਯੁਸ਼਼੍ਮਾਕੰ ਪਿਤੁਰਭਿਲਾਸ਼਼ੰ ਪੂਰਯਥ ਸ ਆ ਪ੍ਰਥਮਾਤ੍ ਨਰਘਾਤੀ ਤਦਨ੍ਤਃ ਸਤ੍ਯਤ੍ਵਸ੍ਯ ਲੇਸ਼ੋਪਿ ਨਾਸ੍ਤਿ ਕਾਰਣਾਦਤਃ ਸ ਸਤ੍ਯਤਾਯਾਂ ਨਾਤਿਸ਼਼੍ਠਤ੍ ਸ ਯਦਾ ਮ੍ਰੁʼਸ਼਼ਾ ਕਥਯਤਿ ਤਦਾ ਨਿਜਸ੍ਵਭਾਵਾਨੁਸਾਰੇਣੈਵ ਕਥਯਤਿ ਯਤੋ ਸ ਮ੍ਰੁʼਸ਼਼ਾਭਾਸ਼਼ੀ ਮ੍ਰੁʼਸ਼਼ੋਤ੍ਪਾਦਕਸ਼੍ਚ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","ਅਹੰ ਤਥ੍ਯਵਾਕ੍ਯੰ ਵਦਾਮਿ ਕਾਰਣਾਦਸ੍ਮਾਦ੍ ਯੂਯੰ ਮਾਂ ਨ ਪ੍ਰਤੀਥ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","ਮਯਿ ਪਾਪਮਸ੍ਤੀਤਿ ਪ੍ਰਮਾਣੰ ਯੁਸ਼਼੍ਮਾਕੰ ਕੋ ਦਾਤੁੰ ਸ਼ਕ੍ਨੋਤਿ? ਯਦ੍ਯਹੰ ਤਥ੍ਯਵਾਕ੍ਯੰ ਵਦਾਮਿ ਤਰ੍ਹਿ ਕੁਤੋ ਮਾਂ ਨ ਪ੍ਰਤਿਥ? ");
INSERT INTO sanpun_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ਯਃ ਕਸ਼੍ਚਨ ਈਸ਼੍ਵਰੀਯੋ ਲੋਕਃ ਸ ਈਸ਼੍ਵਰੀਯਕਥਾਯਾਂ ਮਨੋ ਨਿਧੱਤੇ ਯੂਯਮ੍ ਈਸ਼੍ਵਰੀਯਲੋਕਾ ਨ ਭਵਥ ਤੰਨਿਦਾਨਾਤ੍ ਤਤ੍ਰ ਨ ਮਨਾਂਸਿ ਨਿਧਦ੍ਵੇ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","ਤਦਾ ਯਿਹੂਦੀਯਾਃ ਪ੍ਰਤ੍ਯਵਾਦਿਸ਼਼ੁਃ ਤ੍ਵਮੇਕਃ ਸ਼ੋਮਿਰੋਣੀਯੋ ਭੂਤਗ੍ਰਸ੍ਤਸ਼੍ਚ ਵਯੰ ਕਿਮਿਦੰ ਭਦ੍ਰੰ ਨਾਵਾਦਿਸ਼਼੍ਮ? ");
INSERT INTO sanpun_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ਤਤੋ ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯਵਾਦੀਤ੍ ਨਾਹੰ ਭੂਤਗ੍ਰਸ੍ਤਃ ਕਿਨ੍ਤੁ ਨਿਜਤਾਤੰ ਸੰਮਨ੍ਯੇ ਤਸ੍ਮਾਦ੍ ਯੂਯੰ ਮਾਮ੍ ਅਪਮਨ੍ਯਧ੍ਵੇ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","ਅਹੰ ਸ੍ਵਸੁਖ੍ਯਾਤਿੰ ਨ ਚੇਸ਼਼੍ਟੇ ਕਿਨ੍ਤੁ ਚੇਸ਼਼੍ਟਿਤਾ ਵਿਚਾਰਯਿਤਾ ਚਾਪਰ ਏਕ ਆਸ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ਅਹੰ ਯੁਸ਼਼੍ਮਭ੍ਯਮ੍ ਅਤੀਵ ਯਥਾਰ੍ਥੰ ਕਥਯਾਮਿ ਯੋ ਨਰੋ ਮਦੀਯੰ ਵਾਚੰ ਮਨ੍ਯਤੇ ਸ ਕਦਾਚਨ ਨਿਧਨੰ ਨ ਦ੍ਰਕ੍ਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","ਯਿਹੂਦੀਯਾਸ੍ਤਮਵਦਨ੍ ਤ੍ਵੰ ਭੂਤਗ੍ਰਸ੍ਤ ਇਤੀਦਾਨੀਮ੍ ਅਵੈਸ਼਼੍ਮ| ਇਬ੍ਰਾਹੀਮ੍ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਞ੍ਚ ਸਰ੍ੱਵੇ ਮ੍ਰੁʼਤਾਃ ਕਿਨ੍ਤੁ ਤ੍ਵੰ ਭਾਸ਼਼ਸੇ ਯੋ ਨਰੋ ਮਮ ਭਾਰਤੀਂ ਗ੍ਰੁʼਹ੍ਲਾਤਿ ਸ ਜਾਤੁ ਨਿਧਾਨਾਸ੍ਵਾਦੰ ਨ ਲਪ੍ਸ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","ਤਰ੍ਹਿ ਤ੍ਵੰ ਕਿਮ੍ ਅਸ੍ਮਾਕੰ ਪੂਰ੍ੱਵਪੁਰੁਸ਼਼ਾਦ੍ ਇਬ੍ਰਾਹੀਮੋਪਿ ਮਹਾਨ੍? ਯਸ੍ਮਾਤ੍ ਸੋਪਿ ਮ੍ਰੁʼਤਃ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨੋਪਿ ਮ੍ਰੁʼਤਾਃ ਤ੍ਵੰ ਸ੍ਵੰ ਕੰ ਪੁਮਾਂਸੰ ਮਨੁਸ਼਼ੇ? ");
INSERT INTO sanpun_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯਵੋਚਦ੍ ਯਦ੍ਯਹੰ ਸ੍ਵੰ ਸ੍ਵਯੰ ਸੰਮਨ੍ਯੇ ਤਰ੍ਹਿ ਮਮ ਤਤ੍ ਸੰਮਨਨੰ ਕਿਮਪਿ ਨ ਕਿਨ੍ਤੁ ਮਮ ਤਾਤੋ ਯੰ ਯੂਯੰ ਸ੍ਵੀਯਮ੍ ਈਸ਼੍ਵਰੰ ਭਾਸ਼਼ਧ੍ਵੇ ਸਏਵ ਮਾਂ ਸੰਮਨੁਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ਯੂਯੰ ਤੰ ਨਾਵਗੱਛਥ ਕਿਨ੍ਤ੍ਵਹੰ ਤਮਵਗੱਛਾਮਿ ਤੰ ਨਾਵਗੱਛਾਮੀਤਿ ਵਾਕ੍ਯੰ ਯਦਿ ਵਦਾਮਿ ਤਰ੍ਹਿ ਯੂਯਮਿਵ ਮ੍ਰੁʼਸ਼਼ਾਭਾਸ਼਼ੀ ਭਵਾਮਿ ਕਿਨ੍ਤ੍ਵਹੰ ਤਮਵਗੱਛਾਮਿ ਤਦਾਕ੍ਸ਼਼ਾਮਪਿ ਗ੍ਰੁʼਹ੍ਲਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","ਯੁਸ਼਼੍ਮਾਕੰ ਪੂਰ੍ੱਵਪੁਰੁਸ਼਼ ਇਬ੍ਰਾਹੀਮ੍ ਮਮ ਸਮਯੰ ਦ੍ਰਸ਼਼੍ਟੁਮ੍ ਅਤੀਵਾਵਾਞ੍ਛਤ੍ ਤੰਨਿਰੀਕ੍ਸ਼਼੍ਯਾਨਨ੍ਦੱਚ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","ਤਦਾ ਯਿਹੂਦੀਯਾ ਅਪ੍ਰੁʼੱਛਨ੍ ਤਵ ਵਯਃ ਪਞ੍ਚਾਸ਼ਦ੍ਵਤ੍ਸਰਾ ਨ ਤ੍ਵੰ ਕਿਮ੍ ਇਬ੍ਰਾਹੀਮਮ੍ ਅਦ੍ਰਾਕ੍ਸ਼਼ੀਃ? ");
INSERT INTO sanpun_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯਵਾਦੀਦ੍ ਯੁਸ਼਼੍ਮਾਨਹੰ ਯਥਾਰ੍ਥਤਰੰ ਵਦਾਮਿ ਇਬ੍ਰਾਹੀਮੋ ਜਨ੍ਮਨਃ ਪੂਰ੍ੱਵਕਾਲਮਾਰਭ੍ਯਾਹੰ ਵਿਦ੍ਯੇ| ");
INSERT INTO sanpun_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ਤਦਾ ਤੇ ਪਾਸ਼਼ਾਣਾਨ੍ ਉੱਤੋਲ੍ਯ ਤਮਾਹਨ੍ਤੁਮ੍ ਉਦਯੱਛਨ੍ ਕਿਨ੍ਤੁ ਯੀਸ਼ੁ ਰ੍ਗੁਪ੍ਤੋ ਮਨ੍ਤਿਰਾਦ੍ ਬਹਿਰ੍ਗਤ੍ਯ ਤੇਸ਼਼ਾਂ ਮਧ੍ਯੇਨ ਪ੍ਰਸ੍ਥਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","ਤਤਃ ਪਰੰ ਯੀਸ਼ੁਰ੍ਗੱਛਨ੍ ਮਾਰ੍ਗਮਧ੍ਯੇ ਜਨ੍ਮਾਨ੍ਧੰ ਨਰਮ੍ ਅਪਸ਼੍ਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ਤਤਃ ਸ਼ਿਸ਼਼੍ਯਾਸ੍ਤਮ੍ ਅਪ੍ਰੁʼੱਛਨ੍ ਹੇ ਗੁਰੋ ਨਰੋਯੰ ਸ੍ਵਪਾਪੇਨ ਵਾ ਸ੍ਵਪਿਤ੍ਰਾਃ ਪਾਪੇਨਾਨ੍ਧੋ(ਅ)ਜਾਯਤ? ");
INSERT INTO sanpun_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ਤਤਃ ਸ ਪ੍ਰਤ੍ਯੁਦਿਤਵਾਨ੍ ਏਤਸ੍ਯ ਵਾਸ੍ਯ ਪਿਤ੍ਰੋਃ ਪਾਪਾਦ੍ ਏਤਾਦ੍ਰੁʼਸ਼ੋਭੂਦ ਇਤਿ ਨਹਿ ਕਿਨ੍ਤ੍ਵਨੇਨ ਯਥੇਸ਼੍ਵਰਸ੍ਯ ਕਰ੍ੰਮ ਪ੍ਰਕਾਸ਼੍ਯਤੇ ਤੱਧੇਤੋਰੇਵ| ");
INSERT INTO sanpun_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","ਦਿਨੇ ਤਿਸ਼਼੍ਠਤਿ ਮਤ੍ਪ੍ਰੇਰਯਿਤੁਃ ਕਰ੍ੰਮ ਮਯਾ ਕਰ੍ੱਤਵ੍ਯੰ ਯਦਾ ਕਿਮਪਿ ਕਰ੍ੰਮ ਨ ਕ੍ਰਿਯਤੇ ਤਾਦ੍ਰੁʼਸ਼ੀ ਨਿਸ਼ਾਗੱਛਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ਅਹੰ ਯਾਵਤ੍ਕਾਲੰ ਜਗਤਿ ਤਿਸ਼਼੍ਠਾਮਿ ਤਾਵਤ੍ਕਾਲੰ ਜਗਤੋ ਜ੍ਯੋਤਿਃਸ੍ਵਰੂਪੋਸ੍ਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ਇਤ੍ਯੁਕ੍ੱਤਾ ਭੂਮੌ ਨਿਸ਼਼੍ਠੀਵੰ ਨਿਕ੍ਸ਼਼ਿਪ੍ਯ ਤੇਨ ਪਙ੍ਕੰ ਕ੍ਰੁʼਤਵਾਨ੍ ");
INSERT INTO sanpun_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ਪਸ਼੍ਚਾਤ੍ ਤਤ੍ਪਙ੍ਕੇਨ ਤਸ੍ਯਾਨ੍ਧਸ੍ਯ ਨੇਤ੍ਰੇ ਪ੍ਰਲਿਪ੍ਯ ਤਮਿਤ੍ਯਾਦਿਸ਼ਤ੍ ਗਤ੍ਵਾ ਸ਼ਿਲੋਹੇ (ਅ)ਰ੍ਥਾਤ੍ ਪ੍ਰੇਰਿਤਨਾਮ੍ਨਿ ਸਰਸਿ ਸ੍ਨਾਹਿ| ਤਤੋਨ੍ਧੋ ਗਤ੍ਵਾ ਤਤ੍ਰਾਸ੍ਨਾਤ੍ ਤਤਃ ਪ੍ਰੰਨਚਕ੍ਸ਼਼ੁ ਰ੍ਭੂਤ੍ਵਾ ਵ੍ਯਾਘੁਟ੍ਯਾਗਾਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","ਅਪਰਞ੍ਚ ਸਮੀਪਵਾਸਿਨੋ ਲੋਕਾ ਯੇ ਚ ਤੰ ਪੂਰ੍ੱਵਮਨ੍ਧਮ੍ ਅਪਸ਼੍ਯਨ੍ ਤੇ ਬਕ੍ੱਤੁਮ੍ ਆਰਭਨ੍ਤ ਯੋਨ੍ਧਲੋਕੋ ਵਰ੍ਤ੍ਮਨ੍ਯੁਪਵਿਸ਼੍ਯਾਭਿਕ੍ਸ਼਼ਤ ਸ ਏਵਾਯੰ ਜਨਃ ਕਿੰ ਨ ਭਵਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","ਕੇਚਿਦਵਦਨ੍ ਸ ਏਵ ਕੇਚਿਦਵੋਚਨ੍ ਤਾਦ੍ਰੁʼਸ਼ੋ ਭਵਤਿ ਕਿਨ੍ਤੁ ਸ ਸ੍ਵਯਮਬ੍ਰਵੀਤ੍ ਸ ਏਵਾਹੰ ਭਵਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ਅਤਏਵ ਤੇ (ਅ)ਪ੍ਰੁʼੱਛਨ੍ ਤ੍ਵੰ ਕਥੰ ਦ੍ਰੁʼਸ਼਼੍ਟਿੰ ਪਾਪ੍ਤਵਾਨ੍? ");
INSERT INTO sanpun_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ਤਤਃ ਸੋਵਦਦ੍ ਯੀਸ਼ਨਾਮਕ ਏਕੋ ਜਨੋ ਮਮ ਨਯਨੇ ਪਙ੍ਕੇਨ ਪ੍ਰਲਿਪ੍ਯ ਇਤ੍ਯਾਜ੍ਞਾਪਯਤ੍ ਸ਼ਿਲੋਹਕਾਸਾਰੰ ਗਤ੍ਵਾ ਤਤ੍ਰ ਸ੍ਨਾਹਿ| ਤਤਸ੍ਤਤ੍ਰ ਗਤ੍ਵਾ ਮਯਿ ਸ੍ਨਾਤੇ ਦ੍ਰੁʼਸ਼਼੍ਟਿਮਹੰ ਲਬ੍ਧਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","ਤਦਾ ਤੇ (ਅ)ਵਦਨ੍ ਸ ਪੁਮਾਨ੍ ਕੁਤ੍ਰ? ਤੇਨੋਕ੍ੱਤੰ ਨਾਹੰ ਜਾਨਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","ਅਪਰੰ ਤਸ੍ਮਿਨ੍ ਪੂਰ੍ੱਵਾਨ੍ਧੇ ਜਨੇ ਫਿਰੂਸ਼ਿਨਾਂ ਨਿਕਟਮ੍ ਆਨੀਤੇ ਸਤਿ ਫਿਰੂਸ਼ਿਨੋਪਿ ਤਮਪ੍ਰੁʼੱਛਨ੍ ਕਥੰ ਦ੍ਰੁʼਸ਼਼੍ਟਿੰ ਪ੍ਰਾਪ੍ਤੋਸਿ? ");
INSERT INTO sanpun_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ਤਤਃ ਸ ਕਥਿਤਵਾਨ੍ ਸ ਪਙ੍ਕੇਨ ਮਮ ਨੇਤ੍ਰੇ (ਅ)ਲਿਮ੍ਪਤ੍ ਪਸ਼੍ਚਾਦ੍ ਸ੍ਨਾਤ੍ਵਾ ਦ੍ਰੁʼਸ਼਼੍ਟਿਮਲਭੇ| ");
INSERT INTO sanpun_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","ਕਿਨ੍ਤੁ ਯੀਸ਼ੁ ਰ੍ਵਿਸ਼੍ਰਾਮਵਾਰੇ ਕਰ੍ੱਦਮੰ ਕ੍ਰੁʼਤ੍ਵਾ ਤਸ੍ਯ ਨਯਨੇ ਪ੍ਰਸੰਨੇ(ਅ)ਕਰੋਦ੍ ਇਤਿਕਾਰਣਾਤ੍ ਕਤਿਪਯਫਿਰੂਸ਼ਿਨੋ(ਅ)ਵਦਨ੍ ");
INSERT INTO sanpun_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ਸ ਪੁਮਾਨ੍ ਈਸ਼੍ਵਰਾੰਨ ਯਤਃ ਸ ਵਿਸ਼੍ਰਾਮਵਾਰੰ ਨ ਮਨ੍ਯਤੇ| ਤਤੋਨ੍ਯੇ ਕੇਚਿਤ੍ ਪ੍ਰਤ੍ਯਵਦਨ੍ ਪਾਪੀ ਪੁਮਾਨ੍ ਕਿਮ੍ ਏਤਾਦ੍ਰੁʼਸ਼ਮ੍ ਆਸ਼੍ਚਰ੍ੱਯੰ ਕਰ੍ੰਮ ਕਰ੍ੱਤੁੰ ਸ਼ਕ੍ਨੋਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ਇੱਥੰ ਤੇਸ਼਼ਾਂ ਪਰਸ੍ਪਰੰ ਭਿੰਨਵਾਕ੍ਯਤ੍ਵਮ੍ ਅਭਵਤ੍| ਪਸ਼੍ਚਾਤ੍ ਤੇ ਪੁਨਰਪਿ ਤੰ ਪੂਰ੍ੱਵਾਨ੍ਧੰ ਮਾਨੁਸ਼਼ਮ੍ ਅਪ੍ਰਾਕ੍ਸ਼਼ੁਃ ਯੋ ਜਨਸ੍ਤਵ ਚਕ੍ਸ਼਼ੁਸ਼਼ੀ ਪ੍ਰਸੰਨੇ ਕ੍ਰੁʼਤਵਾਨ੍ ਤਸ੍ਮਿਨ੍ ਤ੍ਵੰ ਕਿੰ ਵਦਸਿ? ਸ ਉਕ੍ੱਤਵਾਨ੍ ਸ ਭਵਿਸ਼ਦ੍ਵਾਦੀ| ");
INSERT INTO sanpun_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","ਸ ਦ੍ਰੁʼਸ਼਼੍ਟਿਮ੍ ਆਪ੍ਤਵਾਨ੍ ਇਤਿ ਯਿਹੂਦੀਯਾਸ੍ਤਸ੍ਯ ਦ੍ਰੁʼਸ਼਼੍ਟਿੰ ਪ੍ਰਾਪ੍ਤਸ੍ਯ ਜਨਸ੍ਯ ਪਿਤ੍ਰੋ ਰ੍ਮੁਖਾਦ੍ ਅਸ਼੍ਰੁਤ੍ਵਾ ਨ ਪ੍ਰਤ੍ਯਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ਅਤਏਵ ਤੇ ਤਾਵਪ੍ਰੁʼੱਛਨ੍ ਯੁਵਯੋ ਰ੍ਯੰ ਪੁਤ੍ਰੰ ਜਨ੍ਮਾਨ੍ਧੰ ਵਦਥਃ ਸ ਕਿਮਯੰ? ਤਰ੍ਹੀਦਾਨੀਂ ਕਥੰ ਦ੍ਰਸ਼਼੍ਟੁੰ ਸ਼ਕ੍ਨੋਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ਤਤਸ੍ਤਸ੍ਯ ਪਿਤਰੌ ਪ੍ਰਤ੍ਯਵੋਚਤਾਮ੍ ਅਯਮ੍ ਆਵਯੋਃ ਪੁਤ੍ਰ ਆ ਜਨੇਰਨ੍ਧਸ਼੍ਚ ਤਦਪ੍ਯਾਵਾਂ ਜਾਨੀਵਃ ");
INSERT INTO sanpun_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ਕਿਨ੍ਤ੍ਵਧੁਨਾ ਕਥੰ ਦ੍ਰੁʼਸ਼਼੍ਟਿੰ ਪ੍ਰਾਪ੍ਤਵਾਨ੍ ਤਦਾਵਾਂ ਨ੍ ਜਾਨੀਵਃ ਕੋਸ੍ਯ ਚਕ੍ਸ਼਼ੁਸ਼਼ੀ ਪ੍ਰਸੰਨੇ ਕ੍ਰੁʼਤਵਾਨ੍ ਤਦਪਿ ਨ ਜਾਨੀਵ ਏਸ਼਼ ਵਯਃਪ੍ਰਾਪ੍ਤ ਏਨੰ ਪ੍ਰੁʼੱਛਤ ਸ੍ਵਕਥਾਂ ਸ੍ਵਯੰ ਵਕ੍ਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ਯਿਹੂਦੀਯਾਨਾਂ ਭਯਾਤ੍ ਤਸ੍ਯ ਪਿਤਰੌ ਵਾਕ੍ਯਮਿਦਮ੍ ਅਵਦਤਾਂ ਯਤਃ ਕੋਪਿ ਮਨੁਸ਼਼੍ਯੋ ਯਦਿ ਯੀਸ਼ੁਮ੍ ਅਭਿਸ਼਼ਿਕ੍ਤੰ ਵਦਤਿ ਤਰ੍ਹਿ ਸ ਭਜਨਗ੍ਰੁʼਹਾਦ੍ ਦੂਰੀਕਾਰਿਸ਼਼੍ਯਤੇ ਯਿਹੂਦੀਯਾ ਇਤਿ ਮਨ੍ਤ੍ਰਣਾਮ੍ ਅਕੁਰ੍ੱਵਨ੍ ");
INSERT INTO sanpun_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","ਅਤਸ੍ਤਸ੍ਯ ਪਿਤਰੌ ਵ੍ਯਾਹਰਤਾਮ੍ ਏਸ਼਼ ਵਯਃਪ੍ਰਾਪ੍ਤ ਏਨੰ ਪ੍ਰੁʼੱਛਤ| ");
INSERT INTO sanpun_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","ਤਦਾ ਤੇ ਪੁਨਸ਼੍ਚ ਤੰ ਪੂਰ੍ੱਵਾਨ੍ਧਮ੍ ਆਹੂਯ ਵ੍ਯਾਹਰਨ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਗੁਣਾਨ੍ ਵਦ ਏਸ਼਼ ਮਨੁਸ਼਼੍ਯਃ ਪਾਪੀਤਿ ਵਯੰ ਜਾਨੀਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","ਤਦਾ ਸ ਉਕ੍ੱਤਵਾਨ੍ ਸ ਪਾਪੀ ਨ ਵੇਤਿ ਨਾਹੰ ਜਾਨੇ ਪੂਰ੍ਵਾਮਨ੍ਧ ਆਸਮਹਮ੍ ਅਧੁਨਾ ਪਸ਼੍ਯਾਮੀਤਿ ਮਾਤ੍ਰੰ ਜਾਨਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ਤੇ ਪੁਨਰਪ੍ਰੁʼੱਛਨ੍ ਸ ਤ੍ਵਾਂ ਪ੍ਰਤਿ ਕਿਮਕਰੋਤ੍? ਕਥੰ ਨੇਤ੍ਰੇ ਪ੍ਰਸੰਨੇ (ਅ)ਕਰੋਤ੍? ");
INSERT INTO sanpun_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","ਤਤਃ ਸੋਵਾਦੀਦ੍ ਏਕਕ੍ਰੁʼਤ੍ਵੋਕਥਯੰ ਯੂਯੰ ਨ ਸ਼੍ਰੁʼਣੁਥ ਤਰ੍ਹਿ ਕੁਤਃ ਪੁਨਃ ਸ਼੍ਰੋਤੁਮ੍ ਇੱਛਥ? ਯੂਯਮਪਿ ਕਿੰ ਤਸ੍ਯ ਸ਼ਿਸ਼਼੍ਯਾ ਭਵਿਤੁਮ੍ ਇੱਛਥ? ");
INSERT INTO sanpun_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","ਤਦਾ ਤੇ ਤੰ ਤਿਰਸ੍ਕ੍ਰੁʼਤ੍ਯ ਵ੍ਯਾਹਰਨ੍ ਤ੍ਵੰ ਤਸ੍ਯ ਸ਼ਿਸ਼਼੍ਯੋ ਵਯੰ ਮੂਸਾਃ ਸ਼ਿਸ਼਼੍ਯਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","ਮੂਸਾਵਕ੍ਤ੍ਰੇਣੇਸ਼੍ਵਰੋ ਜਗਾਦ ਤੱਜਾਨੀਮਃ ਕਿਨ੍ਤ੍ਵੇਸ਼਼ ਕੁਤ੍ਰਤ੍ਯਲੋਕ ਇਤਿ ਨ ਜਾਨੀਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","ਸੋਵਦਦ੍ ਏਸ਼਼ ਮਮ ਲੋਚਨੇ ਪ੍ਰਸੰਨੇ (ਅ)ਕਰੋਤ੍ ਤਥਾਪਿ ਕੁਤ੍ਰਤ੍ਯਲੋਕ ਇਤਿ ਯੂਯੰ ਨ ਜਾਨੀਥ ਏਤਦ੍ ਆਸ਼੍ਚਰ੍ੱਯੰ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ਈਸ਼੍ਵਰਃ ਪਾਪਿਨਾਂ ਕਥਾਂ ਨ ਸ਼੍ਰੁʼਣੋਤਿ ਕਿਨ੍ਤੁ ਯੋ ਜਨਸ੍ਤਸ੍ਮਿਨ੍ ਭਕ੍ਤਿੰ ਕ੍ਰੁʼਤ੍ਵਾ ਤਦਿਸ਼਼੍ਟਕ੍ਰਿਯਾਂ ਕਰੋਤਿ ਤਸ੍ਯੈਵ ਕਥਾਂ ਸ਼੍ਰੁʼਣੋਤਿ ਏਤਦ੍ ਵਯੰ ਜਾਨੀਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","ਕੋਪਿ ਮਨੁਸ਼਼੍ਯੋ ਜਨ੍ਮਾਨ੍ਧਾਯ ਚਕ੍ਸ਼਼ੁਸ਼਼ੀ ਅਦਦਾਤ੍ ਜਗਦਾਰਮ੍ਭਾਦ੍ ਏਤਾਦ੍ਰੁʼਸ਼ੀਂ ਕਥਾਂ ਕੋਪਿ ਕਦਾਪਿ ਨਾਸ਼੍ਰੁʼਣੋਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","ਅਸ੍ਮਾਦ੍ ਏਸ਼਼ ਮਨੁਸ਼਼੍ਯੋ ਯਦੀਸ਼੍ਵਰਾੰਨਾਜਾਯਤ ਤਰ੍ਹਿ ਕਿਞ੍ਚਿਦਪੀਦ੍ਰੁʼਸ਼ੰ ਕਰ੍ੰਮ ਕਰ੍ੱਤੁੰ ਨਾਸ਼ਕ੍ਨੋਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","ਤੇ ਵ੍ਯਾਹਰਨ੍ ਤ੍ਵੰ ਪਾਪਾਦ੍ ਅਜਾਯਥਾਃ ਕਿਮਸ੍ਮਾਨ੍ ਤ੍ਵੰ ਸ਼ਿਕ੍ਸ਼਼ਯਸਿ? ਪਸ਼੍ਚਾੱਤੇ ਤੰ ਬਹਿਰਕੁਰ੍ੱਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","ਤਦਨਨ੍ਤਰੰ ਯਿਹੂਦੀਯੈਃ ਸ ਬਹਿਰਕ੍ਰਿਯਤ ਯੀਸ਼ੁਰਿਤਿ ਵਾਰ੍ੱਤਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਤੰ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਪ੍ਰਾਪ੍ਯ ਪ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਪੁਤ੍ਰੇ ਤ੍ਵੰ ਵਿਸ਼੍ਵਸਿਸ਼਼ਿ? ");
INSERT INTO sanpun_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","ਤਦਾ ਸ ਪ੍ਰਤ੍ਯਵੋਚਤ੍ ਹੇ ਪ੍ਰਭੋ ਸ ਕੋ ਯਤ੍ ਤਸ੍ਮਿੰਨਹੰ ਵਿਸ਼੍ਵਸਿਮਿ? ");
INSERT INTO sanpun_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ਤਤੋ ਯੀਸ਼ੁਃ ਕਥਿਤਵਾਨ੍ ਤ੍ਵੰ ਤੰ ਦ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍ ਤ੍ਵਯਾ ਸਾਕੰ ਯਃ ਕਥੰ ਕਥਯਤਿ ਸਏਵ ਸਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","ਤਦਾ ਹੇ ਪ੍ਰਭੋ ਵਿਸ਼੍ਵਸਿਮੀਤ੍ਯੁਕ੍ਤ੍ਵਾ ਸ ਤੰ ਪ੍ਰਣਾਮਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","ਪਸ਼੍ਚਾਦ੍ ਯੀਸ਼ੁਃ ਕਥਿਤਵਾਨ੍ ਨਯਨਹੀਨਾ ਨਯਨਾਨਿ ਪ੍ਰਾਪ੍ਨੁਵਨ੍ਤਿ ਨਯਨਵਨ੍ਤਸ਼੍ਚਾਨ੍ਧਾ ਭਵਨ੍ਤੀਤ੍ਯਭਿਪ੍ਰਾਯੇਣ ਜਗਦਾਹਮ੍ ਆਗੱਛਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ਏਤਤ੍ ਸ਼੍ਰੁਤ੍ਵਾ ਨਿਕਟਸ੍ਥਾਃ ਕਤਿਪਯਾਃ ਫਿਰੂਸ਼ਿਨੋ ਵ੍ਯਾਹਰਨ੍ ਵਯਮਪਿ ਕਿਮਨ੍ਧਾਃ? ");
INSERT INTO sanpun_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","ਤਦਾ ਯੀਸ਼ੁਰਵਾਦੀਦ੍ ਯਦ੍ਯਨ੍ਧਾ ਅਭਵਤ ਤਰ੍ਹਿ ਪਾਪਾਨਿ ਨਾਤਿਸ਼਼੍ਠਨ੍ ਕਿਨ੍ਤੁ ਪਸ਼੍ਯਾਮੀਤਿ ਵਾਕ੍ਯਵਦਨਾਦ੍ ਯੁਸ਼਼੍ਮਾਕੰ ਪਾਪਾਨਿ ਤਿਸ਼਼੍ਠਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ਅਹੰ ਯੁਸ਼਼੍ਮਾਨਤਿਯਥਾਰ੍ਥੰ ਵਦਾਮਿ, ਯੋ ਜਨੋ ਦ੍ਵਾਰੇਣ ਨ ਪ੍ਰਵਿਸ਼੍ਯ ਕੇਨਾਪ੍ਯਨ੍ਯੇਨ ਮੇਸ਼਼ਗ੍ਰੁʼਹੰ ਪ੍ਰਵਿਸ਼ਤਿ ਸ ਏਵ ਸ੍ਤੇਨੋ ਦਸ੍ਯੁਸ਼੍ਚ| ");
INSERT INTO sanpun_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","ਯੋ ਦ੍ਵਾਰੇਣ ਪ੍ਰਵਿਸ਼ਤਿ ਸ ਏਵ ਮੇਸ਼਼ਪਾਲਕਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ਦੌਵਾਰਿਕਸ੍ਤਸ੍ਮੈ ਦ੍ਵਾਰੰ ਮੋਚਯਤਿ ਮੇਸ਼਼ਗਣਸ਼੍ਚ ਤਸ੍ਯ ਵਾਕ੍ਯੰ ਸ਼੍ਰੁʼਣੋਤਿ ਸ ਨਿਜਾਨ੍ ਮੇਸ਼਼ਾਨ੍ ਸ੍ਵਸ੍ਵਨਾਮ੍ਨਾਹੂਯ ਬਹਿਃ ਕ੍ਰੁʼਤ੍ਵਾ ਨਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","ਤਥਾ ਨਿਜਾਨ੍ ਮੇਸ਼਼ਾਨ੍ ਬਹਿਃ ਕ੍ਰੁʼਤ੍ਵਾ ਸ੍ਵਯੰ ਤੇਸ਼਼ਾਮ੍ ਅਗ੍ਰੇ ਗੱਛਤਿ, ਤਤੋ ਮੇਸ਼਼ਾਸ੍ਤਸ੍ਯ ਸ਼ਬ੍ਦੰ ਬੁਧ੍ਯਨ੍ਤੇ, ਤਸ੍ਮਾਤ੍ ਤਸ੍ਯ ਪਸ਼੍ਚਾਦ੍ ਵ੍ਰਜਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","ਕਿਨ੍ਤੁ ਪਰਸ੍ਯ ਸ਼ਬ੍ਦੰ ਨ ਬੁਧ੍ਯਨ੍ਤੇ ਤਸ੍ਮਾਤ੍ ਤਸ੍ਯ ਪਸ਼੍ਚਾਦ੍ ਵ੍ਰਜਿਸ਼਼੍ਯਨ੍ਤਿ ਵਰੰ ਤਸ੍ਯ ਸਮੀਪਾਤ੍ ਪਲਾਯਿਸ਼਼੍ਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","ਯੀਸ਼ੁਸ੍ਤੇਭ੍ਯ ਇਮਾਂ ਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤਕਥਾਮ੍ ਅਕਥਯਤ੍ ਕਿਨ੍ਤੁ ਤੇਨ ਕਥਿਤਕਥਾਯਾਸ੍ਤਾਤ੍ਪਰ੍ੱਯੰ ਤੇ ਨਾਬੁਧ੍ਯਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","ਅਤੋ ਯੀਸ਼ੁਃ ਪੁਨਰਕਥਯਤ੍, ਯੁਸ਼਼੍ਮਾਨਾਹੰ ਯਥਾਰ੍ਥਤਰੰ ਵ੍ਯਾਹਰਾਮਿ, ਮੇਸ਼਼ਗ੍ਰੁʼਹਸ੍ਯ ਦ੍ਵਾਰਮ੍ ਅਹਮੇਵ| ");
INSERT INTO sanpun_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ਮਯਾ ਨ ਪ੍ਰਵਿਸ਼੍ਯ ਯ ਆਗੱਛਨ੍ ਤੇ ਸ੍ਤੇਨਾ ਦਸ੍ਯਵਸ਼੍ਚ ਕਿਨ੍ਤੁ ਮੇਸ਼਼ਾਸ੍ਤੇਸ਼਼ਾਂ ਕਥਾ ਨਾਸ਼੍ਰੁʼਣ੍ਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","ਅਹਮੇਵ ਦ੍ਵਾਰਸ੍ਵਰੂਪਃ, ਮਯਾ ਯਃ ਕਸ਼੍ਚਿਤ ਪ੍ਰਵਿਸ਼ਤਿ ਸ ਰਕ੍ਸ਼਼ਾਂ ਪ੍ਰਾਪ੍ਸ੍ਯਤਿ ਤਥਾ ਬਹਿਰਨ੍ਤਸ਼੍ਚ ਗਮਨਾਗਮਨੇ ਕ੍ਰੁʼਤ੍ਵਾ ਚਰਣਸ੍ਥਾਨੰ ਪ੍ਰਾਪ੍ਸ੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","ਯੋ ਜਨਸ੍ਤੇਨਃ ਸ ਕੇਵਲੰ ਸ੍ਤੈਨ੍ਯਬਧਵਿਨਾਸ਼ਾਨ੍ ਕਰ੍ੱਤੁਮੇਵ ਸਮਾਯਾਤਿ ਕਿਨ੍ਤ੍ਵਹਮ੍ ਆਯੁ ਰ੍ਦਾਤੁਮ੍ ਅਰ੍ਥਾਤ੍ ਬਾਹੂਲ੍ਯੇਨ ਤਦੇਵ ਦਾਤੁਮ੍ ਆਗੱਛਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","ਅਹਮੇਵ ਸਤ੍ਯਮੇਸ਼਼ਪਾਲਕੋ ਯਸ੍ਤੁ ਸਤ੍ਯੋ ਮੇਸ਼਼ਪਾਲਕਃ ਸ ਮੇਸ਼਼ਾਰ੍ਥੰ ਪ੍ਰਾਣਤ੍ਯਾਗੰ ਕਰੋਤਿ; ");
INSERT INTO sanpun_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","ਕਿਨ੍ਤੁ ਯੋ ਜਨੋ ਮੇਸ਼਼ਪਾਲਕੋ ਨ, ਅਰ੍ਥਾਦ੍ ਯਸ੍ਯ ਮੇਸ਼਼ਾ ਨਿਜਾ ਨ ਭਵਨ੍ਤਿ, ਯ ਏਤਾਦ੍ਰੁʼਸ਼ੋ ਵੈਤਨਿਕਃ ਸ ਵ੍ਰੁʼਕਮ੍ ਆਗੱਛਨ੍ਤੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਮੇਜਵ੍ਰਜੰ ਵਿਹਾਯ ਪਲਾਯਤੇ, ਤਸ੍ਮਾਦ੍ ਵ੍ਰੁʼਕਸ੍ਤੰ ਵ੍ਰਜੰ ਧ੍ਰੁʼਤ੍ਵਾ ਵਿਕਿਰਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ਵੈਤਨਿਕਃ ਪਲਾਯਤੇ ਯਤਃ ਸ ਵੇਤਨਾਰ੍ਥੀ ਮੇਸ਼਼ਾਰ੍ਥੰ ਨ ਚਿਨ੍ਤਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","ਅਹਮੇਵ ਸਤ੍ਯੋ ਮੇਸ਼਼ਪਾਲਕਃ, ਪਿਤਾ ਮਾਂ ਯਥਾ ਜਾਨਾਤਿ, ਅਹਞ੍ਚ ਯਥਾ ਪਿਤਰੰ ਜਾਨਾਮਿ, ");
INSERT INTO sanpun_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ਤਥਾ ਨਿਜਾਨ੍ ਮੇਸ਼਼ਾਨਪਿ ਜਾਨਾਮਿ, ਮੇਸ਼਼ਾਸ਼੍ਚ ਮਾਂ ਜਾਨਾਨ੍ਤਿ, ਅਹਞ੍ਚ ਮੇਸ਼਼ਾਰ੍ਥੰ ਪ੍ਰਾਣਤ੍ਯਾਗੰ ਕਰੋਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","ਅਪਰਞ੍ਚ ਏਤਦ੍ ਗ੍ਰੁʼਹੀਯ ਮੇਸ਼਼ੇਭ੍ਯੋ ਭਿੰਨਾ ਅਪਿ ਮੇਸ਼਼ਾ ਮਮ ਸਨ੍ਤਿ ਤੇ ਸਕਲਾ ਆਨਯਿਤਵ੍ਯਾਃ; ਤੇ ਮਮ ਸ਼ਬ੍ਦੰ ਸ਼੍ਰੋਸ਼਼੍ਯਨ੍ਤਿ ਤਤ ਏਕੋ ਵ੍ਰਜ ਏਕੋ ਰਕ੍ਸ਼਼ਕੋ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","ਪ੍ਰਾਣਾਨਹੰ ਤ੍ਯਕ੍ਤ੍ਵਾ ਪੁਨਃ ਪ੍ਰਾਣਾਨ੍ ਗ੍ਰਹੀਸ਼਼੍ਯਾਮਿ, ਤਸ੍ਮਾਤ੍ ਪਿਤਾ ਮਯਿ ਸ੍ਨੇਹੰ ਕਰੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","ਕਸ਼੍ਚਿੱਜਨੋ ਮਮ ਪ੍ਰਾਣਾਨ੍ ਹਨ੍ਤੁੰ ਨ ਸ਼ਕ੍ਨੋਤਿ ਕਿਨ੍ਤੁ ਸ੍ਵਯੰ ਤਾਨ੍ ਸਮਰ੍ਪਯਾਮਿ ਤਾਨ੍ ਸਮਰ੍ਪਯਿਤੁੰ ਪੁਨਰ੍ਗ੍ਰਹੀਤੁਞ੍ਚ ਮਮ ਸ਼ਕ੍ਤਿਰਾਸ੍ਤੇ ਭਾਰਮਿਮੰ ਸ੍ਵਪਿਤੁਃ ਸਕਾਸ਼ਾਤ੍ ਪ੍ਰਾਪ੍ਤੋਹਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","ਅਸ੍ਮਾਦੁਪਦੇਸ਼ਾਤ੍ ਪੁਨਸ਼੍ਚ ਯਿਹੂਦੀਯਾਨਾਂ ਮਧ੍ਯੇ ਭਿੰਨਵਾਕ੍ਯਤਾ ਜਾਤਾ| ");
INSERT INTO sanpun_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ਤਤੋ ਬਹਵੋ ਵ੍ਯਾਹਰਨ੍ ਏਸ਼਼ ਭੂਤਗ੍ਰਸ੍ਤ ਉਨ੍ਮੱਤਸ਼੍ਚ, ਕੁਤ ਏਤਸ੍ਯ ਕਥਾਂ ਸ਼੍ਰੁʼਣੁਥ? ");
INSERT INTO sanpun_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","ਕੇਚਿਦ੍ ਅਵਦਨ੍ ਏਤਸ੍ਯ ਕਥਾ ਭੂਤਗ੍ਰਸ੍ਤਸ੍ਯ ਕਥਾਵੰਨ ਭਵਨ੍ਤਿ, ਭੂਤਃ ਕਿਮ੍ ਅਨ੍ਧਾਯ ਚਕ੍ਸ਼਼ੁਸ਼਼ੀ ਦਾਤੁੰ ਸ਼ਕ੍ਨੋਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","ਸ਼ੀਤਕਾਲੇ ਯਿਰੂਸ਼ਾਲਮਿ ਮਨ੍ਦਿਰੋਤ੍ਸਰ੍ਗਪਰ੍ੱਵਣ੍ਯੁਪਸ੍ਥਿਤੇ ");
INSERT INTO sanpun_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ਯੀਸ਼ੁਃ ਸੁਲੇਮਾਨੋ ਨਿਃਸਾਰੇਣ ਗਮਨਾਗਮਨੇ ਕਰੋਤਿ, ");
INSERT INTO sanpun_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ਏਤਸ੍ਮਿਨ੍ ਸਮਯੇ ਯਿਹੂਦੀਯਾਸ੍ਤੰ ਵੇਸ਼਼੍ਟਯਿਤ੍ਵਾ ਵ੍ਯਾਹਰਨ੍ ਕਤਿ ਕਾਲਾਨ੍ ਅਸ੍ਮਾਕੰ ਵਿਚਿਕਿਤ੍ਸਾਂ ਸ੍ਥਾਪਯਿਸ਼਼੍ਯਾਮਿ? ਯਦ੍ਯਭਿਸ਼਼ਿਕ੍ਤੋ ਭਵਤਿ ਤਰ੍ਹਿ ਤਤ੍ ਸ੍ਪਸ਼਼੍ਟੰ ਵਦ| ");
INSERT INTO sanpun_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","ਤਦਾ ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯਵਦਦ੍ ਅਹਮ੍ ਅਚਕਥੰ ਕਿਨ੍ਤੁ ਯੂਯੰ ਨ ਪ੍ਰਤੀਥ, ਨਿਜਪਿਤੁ ਰ੍ਨਾਮ੍ਨਾ ਯਾਂ ਯਾਂ ਕ੍ਰਿਯਾਂ ਕਰੋਮਿ ਸਾ ਕ੍ਰਿਯੈਵ ਮਮ ਸਾਕ੍ਸ਼਼ਿਸ੍ਵਰੂਪਾ| ");
INSERT INTO sanpun_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ਕਿਨ੍ਤ੍ਵਹੰ ਪੂਰ੍ੱਵਮਕਥਯੰ ਯੂਯੰ ਮਮ ਮੇਸ਼਼ਾ ਨ ਭਵਥ, ਕਾਰਣਾਦਸ੍ਮਾਨ੍ ਨ ਵਿਸ਼੍ਵਸਿਥ| ");
INSERT INTO sanpun_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","ਮਮ ਮੇਸ਼਼ਾ ਮਮ ਸ਼ਬ੍ਦੰ ਸ਼੍ਰੁʼਣ੍ਵਨ੍ਤਿ ਤਾਨਹੰ ਜਾਨਾਮਿ ਤੇ ਚ ਮਮ ਪਸ਼੍ਚਾਦ੍ ਗੱਛਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ਅਹੰ ਤੇਭ੍ਯੋ(ਅ)ਨਨ੍ਤਾਯੁ ਰ੍ਦਦਾਮਿ, ਤੇ ਕਦਾਪਿ ਨ ਨੰਕ੍ਸ਼਼੍ਯਨ੍ਤਿ ਕੋਪਿ ਮਮ ਕਰਾਤ੍ ਤਾਨ੍ ਹਰ੍ੱਤੁੰ ਨ ਸ਼ਕ੍ਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","ਯੋ ਮਮ ਪਿਤਾ ਤਾਨ੍ ਮਹ੍ਯੰ ਦੱਤਵਾਨ੍ ਸ ਸਰ੍ੱਵਸ੍ਮਾਤ੍ ਮਹਾਨ੍, ਕੋਪਿ ਮਮ ਪਿਤੁਃ ਕਰਾਤ੍ ਤਾਨ੍ ਹਰ੍ੱਤੁੰ ਨ ਸ਼ਕ੍ਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ਅਹੰ ਪਿਤਾ ਚ ਦ੍ਵਯੋਰੇਕਤ੍ਵਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","ਤਤੋ ਯਿਹੂਦੀਯਾਃ ਪੁਨਰਪਿ ਤੰ ਹਨ੍ਤੁੰ ਪਾਸ਼਼ਾਣਾਨ੍ ਉਦਤੋਲਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ਯੀਸ਼ੁਃ ਕਥਿਤਵਾਨ੍ ਪਿਤੁਃ ਸਕਾਸ਼ਾਦ੍ ਬਹੂਨ੍ਯੁੱਤਮਕਰ੍ੰਮਾਣਿ ਯੁਸ਼਼੍ਮਾਕੰ ਪ੍ਰਾਕਾਸ਼ਯੰ ਤੇਸ਼਼ਾਂ ਕਸ੍ਯ ਕਰ੍ੰਮਣਃ ਕਾਰਣਾਨ੍ ਮਾਂ ਪਾਸ਼਼ਾਣੈਰਾਹਨ੍ਤੁਮ੍ ਉਦ੍ਯਤਾਃ ਸ੍ਥ? ");
INSERT INTO sanpun_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","ਯਿਹੂਦੀਯਾਃ ਪ੍ਰਤ੍ਯਵਦਨ੍ ਪ੍ਰਸ਼ਸ੍ਤਕਰ੍ੰਮਹੇਤੋ ਰ੍ਨ ਕਿਨ੍ਤੁ ਤ੍ਵੰ ਮਾਨੁਸ਼਼ਃ ਸ੍ਵਮੀਸ਼੍ਵਰਮ੍ ਉਕ੍ਤ੍ਵੇਸ਼੍ਵਰੰ ਨਿਨ੍ਦਸਿ ਕਾਰਣਾਦਸ੍ਮਾਤ੍ ਤ੍ਵਾਂ ਪਾਸ਼਼ਾਣੈਰ੍ਹਨ੍ਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","ਤਦਾ ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯੁਕ੍ਤਵਾਨ੍ ਮਯਾ ਕਥਿਤੰ ਯੂਯਮ੍ ਈਸ਼੍ਵਰਾ ਏਤਦ੍ਵਚਨੰ ਯੁਸ਼਼੍ਮਾਕੰ ਸ਼ਾਸ੍ਤ੍ਰੇ ਲਿਖਿਤੰ ਨਾਸ੍ਤਿ ਕਿੰ? ");
INSERT INTO sanpun_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","ਤਸ੍ਮਾਦ੍ ਯੇਸ਼਼ਾਮ੍ ਉੱਦੇਸ਼ੇ ਈਸ਼੍ਵਰਸ੍ਯ ਕਥਾ ਕਥਿਤਾ ਤੇ ਯਦੀਸ਼੍ਵਰਗਣਾ ਉਚ੍ਯਨ੍ਤੇ ਧਰ੍ੰਮਗ੍ਰਨ੍ਥਸ੍ਯਾਪ੍ਯਨ੍ਯਥਾ ਭਵਿਤੁੰ ਨ ਸ਼ਕ੍ਯੰ, ");
INSERT INTO sanpun_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ਤਰ੍ਹ੍ਯਾਹਮ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਪੁਤ੍ਰ ਇਤਿ ਵਾਕ੍ਯਸ੍ਯ ਕਥਨਾਤ੍ ਯੂਯੰ ਪਿਤ੍ਰਾਭਿਸ਼਼ਿਕ੍ਤੰ ਜਗਤਿ ਪ੍ਰੇਰਿਤਞ੍ਚ ਪੁਮਾਂਸੰ ਕਥਮ੍ ਈਸ਼੍ਵਰਨਿਨ੍ਦਕੰ ਵਾਦਯ? ");
INSERT INTO sanpun_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","ਯਦ੍ਯਹੰ ਪਿਤੁਃ ਕਰ੍ੰਮ ਨ ਕਰੋਮਿ ਤਰ੍ਹਿ ਮਾਂ ਨ ਪ੍ਰਤੀਤ; ");
INSERT INTO sanpun_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","ਕਿਨ੍ਤੁ ਯਦਿ ਕਰੋਮਿ ਤਰ੍ਹਿ ਮਯਿ ਯੁਸ਼਼੍ਮਾਭਿਃ ਪ੍ਰਤ੍ਯਯੇ ਨ ਕ੍ਰੁʼਤੇ(ਅ)ਪਿ ਕਾਰ੍ੱਯੇ ਪ੍ਰਤ੍ਯਯਃ ਕ੍ਰਿਯਤਾਂ, ਤਤੋ ਮਯਿ ਪਿਤਾਸ੍ਤੀਤਿ ਪਿਤਰ੍ੱਯਹਮ੍ ਅਸ੍ਮੀਤਿ ਚ ਕ੍ਸ਼਼ਾਤ੍ਵਾ ਵਿਸ਼੍ਵਸਿਸ਼਼੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ਤਦਾ ਤੇ ਪੁਨਰਪਿ ਤੰ ਧਰ੍ੱਤੁਮ੍ ਅਚੇਸ਼਼੍ਟਨ੍ਤ ਕਿਨ੍ਤੁ ਸ ਤੇਸ਼਼ਾਂ ਕਰੇਭ੍ਯੋ ਨਿਸ੍ਤੀਰ੍ੱਯ ");
INSERT INTO sanpun_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ਪੁਨ ਰ੍ਯਰ੍ੱਦਨ੍ ਅਦ੍ਯਾਸ੍ਤਟੇ ਯਤ੍ਰ ਪੁਰ੍ੱਵੰ ਯੋਹਨ੍ ਅਮੱਜਯਤ੍ ਤਤ੍ਰਾਗਤ੍ਯ ਨ੍ਯਵਸਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ਤਤੋ ਬਹਵੋ ਲੋਕਾਸ੍ਤਤ੍ਸਮੀਪਮ੍ ਆਗਤ੍ਯ ਵ੍ਯਾਹਰਨ੍ ਯੋਹਨ੍ ਕਿਮਪ੍ਯਾਸ਼੍ਚਰ੍ੱਯੰ ਕਰ੍ੰਮ ਨਾਕਰੋਤ੍ ਕਿਨ੍ਤ੍ਵਸ੍ਮਿਨ੍ ਮਨੁਸ਼਼੍ਯੇ ਯਾ ਯਃ ਕਥਾ ਅਕਥਯਤ੍ ਤਾਃ ਸਰ੍ੱਵਾਃ ਸਤ੍ਯਾਃ; ");
INSERT INTO sanpun_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ਤਤ੍ਰ ਚ ਬਹਵੋ ਲੋਕਾਸ੍ਤਸ੍ਮਿਨ੍ ਵ੍ਯਸ਼੍ਵਸਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","ਅਨਨ੍ਤਰੰ ਮਰਿਯਮ੍ ਤਸ੍ਯਾ ਭਗਿਨੀ ਮਰ੍ਥਾ ਚ ਯਸ੍ਮਿਨ੍ ਵੈਥਨੀਯਾਗ੍ਰਾਮੇ ਵਸਤਸ੍ਤਸ੍ਮਿਨ੍ ਗ੍ਰਾਮੇ ਇਲਿਯਾਸਰ੍ ਨਾਮਾ ਪੀਡਿਤ ਏਕ ਆਸੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ਯਾ ਮਰਿਯਮ੍ ਪ੍ਰਭੁੰ ਸੁਗਨ੍ਧਿਤੇਲੈਨ ਮਰ੍ੱਦਯਿਤ੍ਵਾ ਸ੍ਵਕੇਸ਼ੈਸ੍ਤਸ੍ਯ ਚਰਣੌ ਸਮਮਾਰ੍ਜਤ੍ ਤਸ੍ਯਾ ਭ੍ਰਾਤਾ ਸ ਇਲਿਯਾਸਰ੍ ਰੋਗੀ| ");
INSERT INTO sanpun_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ਅਪਰਞ੍ਚ ਹੇ ਪ੍ਰਭੋ ਭਵਾਨ੍ ਯਸ੍ਮਿਨ੍ ਪ੍ਰੀਯਤੇ ਸ ਏਵ ਪੀਡਿਤੋਸ੍ਤੀਤਿ ਕਥਾਂ ਕਥਯਿਤ੍ਵਾ ਤਸ੍ਯ ਭਗਿਨ੍ਯੌ ਪ੍ਰੇਸ਼਼ਿਤਵਤ੍ਯੌ| ");
INSERT INTO sanpun_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ਤਦਾ ਯੀਸ਼ੁਰਿਮਾਂ ਵਾਰ੍ੱਤਾਂ ਸ਼੍ਰੁਤ੍ਵਾਕਥਯਤ ਪੀਡੇਯੰ ਮਰਣਾਰ੍ਥੰ ਨ ਕਿਨ੍ਤ੍ਵੀਸ਼੍ਵਰਸ੍ਯ ਮਹਿਮਾਰ੍ਥਮ੍ ਈਸ਼੍ਵਰਪੁਤ੍ਰਸ੍ਯ ਮਹਿਮਪ੍ਰਕਾਸ਼ਾਰ੍ਥਞ੍ਚ ਜਾਤਾ| ");
INSERT INTO sanpun_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","ਯੀਸ਼ੁ ਰ੍ਯਦ੍ਯਪਿਮਰ੍ਥਾਯਾਂ ਤਦ੍ਭਗਿਨ੍ਯਾਮ੍ ਇਲਿਯਾਸਰਿ ਚਾਪ੍ਰੀਯਤ, ");
INSERT INTO sanpun_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ਤਥਾਪਿ ਇਲਿਯਾਸਰਃ ਪੀਡਾਯਾਃ ਕਥੰ ਸ਼੍ਰੁਤ੍ਵਾ ਯਤ੍ਰ ਆਸੀਤ੍ ਤਤ੍ਰੈਵ ਦਿਨਦ੍ਵਯਮਤਿਸ਼਼੍ਠਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ਤਤਃ ਪਰਮ੍ ਸ ਸ਼ਿਸ਼਼੍ਯਾਨਕਥਯਦ੍ ਵਯੰ ਪੁਨ ਰ੍ਯਿਹੂਦੀਯਪ੍ਰਦੇਸ਼ੰ ਯਾਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","ਤਤਸ੍ਤੇ ਪ੍ਰਤ੍ਯਵਦਨ੍, ਹੇ ਗੁਰੋ ਸ੍ਵਲ੍ਪਦਿਨਾਨਿ ਗਤਾਨਿ ਯਿਹੂਦੀਯਾਸ੍ਤ੍ਵਾਂ ਪਾਸ਼਼ਾਣੈ ਰ੍ਹਨ੍ਤੁਮ੍ ਉਦ੍ਯਤਾਸ੍ਤਥਾਪਿ ਕਿੰ ਪੁਨਸ੍ਤਤ੍ਰ ਯਾਸ੍ਯਸਿ? ");
INSERT INTO sanpun_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯਵਦਤ੍, ਏਕਸ੍ਮਿਨ੍ ਦਿਨੇ ਕਿੰ ਦ੍ਵਾਦਸ਼ਘਟਿਕਾ ਨ ਭਵਨ੍ਤਿ? ਕੋਪਿ ਦਿਵਾ ਗੱਛਨ੍ ਨ ਸ੍ਖਲਤਿ ਯਤਃ ਸ ਏਤੱਜਗਤੋ ਦੀਪ੍ਤਿੰ ਪ੍ਰਾਪ੍ਨੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ਕਿਨ੍ਤੁ ਰਾਤ੍ਰੌ ਗੱਛਨ੍ ਸ੍ਖਲਤਿ ਯਤੋ ਹੇਤੋਸ੍ਤਤ੍ਰ ਦੀਪ੍ਤਿ ਰ੍ਨਾਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ਇਮਾਂ ਕਥਾਂ ਕਥਯਿਤ੍ਵਾ ਸ ਤਾਨਵਦਦ੍, ਅਸ੍ਮਾਕੰ ਬਨ੍ਧੁਃ ਇਲਿਯਾਸਰ੍ ਨਿਦ੍ਰਿਤੋਭੂਦ੍ ਇਦਾਨੀਂ ਤੰ ਨਿਦ੍ਰਾਤੋ ਜਾਗਰਯਿਤੁੰ ਗੱਛਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","ਯੀਸ਼ੁ ਰ੍ਮ੍ਰੁʼਤੌ ਕਥਾਮਿਮਾਂ ਕਥਿਤਵਾਨ੍ ਕਿਨ੍ਤੁ ਵਿਸ਼੍ਰਾਮਾਰ੍ਥੰ ਨਿਦ੍ਰਾਯਾਂ ਕਥਿਤਵਾਨ੍ ਇਤਿ ਜ੍ਞਾਤ੍ਵਾ ਸ਼ਿਸ਼਼੍ਯਾ ਅਕਥਯਨ੍, ");
INSERT INTO sanpun_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ਹੇ ਗੁਰੋ ਸ ਯਦਿ ਨਿਦ੍ਰਾਤਿ ਤਰ੍ਹਿ ਭਦ੍ਰਮੇਵ| ");
INSERT INTO sanpun_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","ਤਦਾ ਯੀਸ਼ੁਃ ਸ੍ਪਸ਼਼੍ਟੰ ਤਾਨ੍ ਵ੍ਯਾਹਰਤ੍, ਇਲਿਯਾਸਰ੍ ਅਮ੍ਰਿਯਤ; ");
INSERT INTO sanpun_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ਕਿਨ੍ਤੁ ਯੂਯੰ ਯਥਾ ਪ੍ਰਤੀਥ ਤਦਰ੍ਥਮਹੰ ਤਤ੍ਰ ਨ ਸ੍ਥਿਤਵਾਨ੍ ਇਤ੍ਯਸ੍ਮਾਦ੍ ਯੁਸ਼਼੍ਮੰਨਿਮਿੱਤਮ੍ ਆਹ੍ਲਾਦਿਤੋਹੰ, ਤਥਾਪਿ ਤਸ੍ਯ ਸਮੀਪੇ ਯਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","ਤਦਾ ਥੋਮਾ ਯੰ ਦਿਦੁਮੰ ਵਦਨ੍ਤਿ ਸ ਸਙ੍ਗਿਨਃ ਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਅਵਦਦ੍ ਵਯਮਪਿ ਗਤ੍ਵਾ ਤੇਨ ਸਾਰ੍ੱਧੰ ਮ੍ਰਿਯਾਮਹੈ| ");
INSERT INTO sanpun_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","ਯੀਸ਼ੁਸ੍ਤਤ੍ਰੋਪਸ੍ਥਾਯ ਇਲਿਯਾਸਰਃ ਸ਼੍ਮਸ਼ਾਨੇ ਸ੍ਥਾਪਨਾਤ੍ ਚਤ੍ਵਾਰਿ ਦਿਨਾਨਿ ਗਤਾਨੀਤਿ ਵਾਰ੍ੱਤਾਂ ਸ਼੍ਰੁਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","ਵੈਥਨੀਯਾ ਯਿਰੂਸ਼ਾਲਮਃ ਸਮੀਪਸ੍ਥਾ ਕ੍ਰੋਸ਼ੈਕਮਾਤ੍ਰਾਨ੍ਤਰਿਤਾ; ");
INSERT INTO sanpun_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ਤਸ੍ਮਾਦ੍ ਬਹਵੋ ਯਿਹੂਦੀਯਾ ਮਰ੍ਥਾਂ ਮਰਿਯਮਞ੍ਚ ਭ੍ਯਾਤ੍ਰੁʼਸ਼ੋਕਾਪੰਨਾਂ ਸਾਨ੍ਤ੍ਵਯਿਤੁੰ ਤਯੋਃ ਸਮੀਪਮ੍ ਆਗੱਛਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","ਮਰ੍ਥਾ ਯੀਸ਼ੋਰਾਗਮਨਵਾਰ੍ਤਾਂ ਸ਼੍ਰੁਤ੍ਵੈਵ ਤੰ ਸਾਕ੍ਸ਼਼ਾਦ੍ ਅਕਰੋਤ੍ ਕਿਨ੍ਤੁ ਮਰਿਯਮ੍ ਗੇਹ ਉਪਵਿਸ਼੍ਯ ਸ੍ਥਿਤਾ| ");
INSERT INTO sanpun_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","ਤਦਾ ਮਰ੍ਥਾ ਯੀਸ਼ੁਮਵਾਦਤ੍, ਹੇ ਪ੍ਰਭੋ ਯਦਿ ਭਵਾਨ੍ ਅਤ੍ਰਾਸ੍ਥਾਸ੍ਯਤ੍ ਤਰ੍ਹਿ ਮਮ ਭ੍ਰਾਤਾ ਨਾਮਰਿਸ਼਼੍ਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","ਕਿਨ੍ਤ੍ਵਿਦਾਨੀਮਪਿ ਯਦ੍ ਈਸ਼੍ਵਰੇ ਪ੍ਰਾਰ੍ਥਯਿਸ਼਼੍ਯਤੇ ਈਸ਼੍ਵਰਸ੍ਤਦ੍ ਦਾਸ੍ਯਤੀਤਿ ਜਾਨੇ(ਅ)ਹੰ| ");
INSERT INTO sanpun_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","ਯੀਸ਼ੁਰਵਾਦੀਤ੍ ਤਵ ਭ੍ਰਾਤਾ ਸਮੁੱਥਾਸ੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","ਮਰ੍ਥਾ ਵ੍ਯਾਹਰਤ੍ ਸ਼ੇਸ਼਼ਦਿਵਸੇ ਸ ਉੱਥਾਨਸਮਯੇ ਪ੍ਰੋੱਥਾਸ੍ਯਤੀਤਿ ਜਾਨੇ(ਅ)ਹੰ| ");
INSERT INTO sanpun_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","ਤਦਾ ਯੀਸ਼ੁਃ ਕਥਿਤਵਾਨ੍ ਅਹਮੇਵ ਉੱਥਾਪਯਿਤਾ ਜੀਵਯਿਤਾ ਚ ਯਃ ਕਸ਼੍ਚਨ ਮਯਿ ਵਿਸ਼੍ਵਸਿਤਿ ਸ ਮ੍ਰੁʼਤ੍ਵਾਪਿ ਜੀਵਿਸ਼਼੍ਯਤਿ; ");
INSERT INTO sanpun_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ਯਃ ਕਸ਼੍ਚਨ ਚ ਜੀਵਨ੍ ਮਯਿ ਵਿਸ਼੍ਵਸਿਤਿ ਸ ਕਦਾਪਿ ਨ ਮਰਿਸ਼਼੍ਯਤਿ, ਅਸ੍ਯਾਂ ਕਥਾਯਾਂ ਕਿੰ ਵਿਸ਼੍ਵਸਿਸ਼਼ਿ? ");
INSERT INTO sanpun_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ਸਾਵਦਤ੍ ਪ੍ਰਭੋ ਯਸ੍ਯਾਵਤਰਣਾਪੇਕ੍ਸ਼਼ਾਸ੍ਤਿ ਭਵਾਨ੍ ਸਏਵਾਭਿਸ਼਼ਿਕ੍ੱਤ ਈਸ਼੍ਵਰਪੁਤ੍ਰ ਇਤਿ ਵਿਸ਼੍ਵਸਿਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ਇਤਿ ਕਥਾਂ ਕਥਯਿਤ੍ਵਾ ਸਾ ਗਤ੍ਵਾ ਸ੍ਵਾਂ ਭਗਿਨੀਂ ਮਰਿਯਮੰ ਗੁਪ੍ਤਮਾਹੂਯ ਵ੍ਯਾਹਰਤ੍ ਗੁਰੁਰੁਪਤਿਸ਼਼੍ਠਤਿ ਤ੍ਵਾਮਾਹੂਯਤਿ ਚ| ");
INSERT INTO sanpun_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","ਕਥਾਮਿਮਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਸਾ ਤੂਰ੍ਣਮ੍ ਉੱਥਾਯ ਤਸ੍ਯ ਸਮੀਪਮ੍ ਅਗੱਛਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ਯੀਸ਼ੁ ਰ੍ਗ੍ਰਾਮਮਧ੍ਯੰ ਨ ਪ੍ਰਵਿਸ਼੍ਯ ਯਤ੍ਰ ਮਰ੍ਥਾ ਤੰ ਸਾਕ੍ਸ਼਼ਾਦ੍ ਅਕਰੋਤ੍ ਤਤ੍ਰ ਸ੍ਥਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","ਯੇ ਯਿਹੂਦੀਯਾ ਮਰਿਯਮਾ ਸਾਕੰ ਗ੍ਰੁʼਹੇ ਤਿਸ਼਼੍ਠਨ੍ਤਸ੍ਤਾਮ੍ ਅਸਾਨ੍ਤ੍ਵਯਨ ਤੇ ਤਾਂ ਕ੍ਸ਼਼ਿਪ੍ਰਮ੍ ਉੱਥਾਯ ਗੱਛਨ੍ਤਿੰ ਵਿਲੋਕ੍ਯ ਵ੍ਯਾਹਰਨ੍, ਸ ਸ਼੍ਮਸ਼ਾਨੇ ਰੋਦਿਤੁੰ ਯਾਤਿ, ਇਤ੍ਯੁਕ੍ਤ੍ਵਾ ਤੇ ਤਸ੍ਯਾਃ ਪਸ਼੍ਚਾਦ੍ ਅਗੱਛਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","ਯਤ੍ਰ ਯੀਸ਼ੁਰਤਿਸ਼਼੍ਠਤ੍ ਤਤ੍ਰ ਮਰਿਯਮ੍ ਉਪਸ੍ਥਾਯ ਤੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਤਸ੍ਯ ਚਰਣਯੋਃ ਪਤਿਤ੍ਵਾ ਵ੍ਯਾਹਰਤ੍ ਹੇ ਪ੍ਰਭੋ ਯਦਿ ਭਵਾਨ੍ ਅਤ੍ਰਾਸ੍ਥਾਸ੍ਯਤ੍ ਤਰ੍ਹਿ ਮਮ ਭ੍ਰਾਤਾ ਨਾਮਰਿਸ਼਼੍ਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","ਯੀਸ਼ੁਸ੍ਤਾਂ ਤਸ੍ਯਾਃ ਸਙ੍ਗਿਨੋ ਯਿਹੂਦੀਯਾਂਸ਼੍ਚ ਰੁਦਤੋ ਵਿਲੋਕ੍ਯ ਸ਼ੋਕਾਰ੍ੱਤਃ ਸਨ੍ ਦੀਰ੍ਘੰ ਨਿਸ਼੍ਵਸ੍ਯ ਕਥਿਤਵਾਨ੍ ਤੰ ਕੁਤ੍ਰਾਸ੍ਥਾਪਯਤ? ");
INSERT INTO sanpun_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ਤੇ ਵ੍ਯਾਹਰਨ੍, ਹੇ ਪ੍ਰਭੋ ਭਵਾਨ੍ ਆਗਤ੍ਯ ਪਸ਼੍ਯਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","ਯੀਸ਼ੁਨਾ ਕ੍ਰਨ੍ਦਿਤੰ| ");
INSERT INTO sanpun_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ਅਤਏਵ ਯਿਹੂਦੀਯਾ ਅਵਦਨ੍, ਪਸ਼੍ਯਤਾਯੰ ਤਸ੍ਮਿਨ੍ ਕਿਦ੍ਰੁʼਗ੍ ਅਪ੍ਰਿਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","ਤੇਸ਼਼ਾਂ ਕੇਚਿਦ੍ ਅਵਦਨ੍ ਯੋਨ੍ਧਾਯ ਚਕ੍ਸ਼਼ੁਸ਼਼ੀ ਦੱਤਵਾਨ੍ ਸ ਕਿਮ੍ ਅਸ੍ਯ ਮ੍ਰੁʼਤ੍ਯੁੰ ਨਿਵਾਰਯਿਤੁੰ ਨਾਸ਼ਕ੍ਨੋਤ੍? ");
INSERT INTO sanpun_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","ਤਤੋ ਯੀਸ਼ੁਃ ਪੁਨਰਨ੍ਤਰ੍ਦੀਰ੍ਘੰ ਨਿਸ਼੍ਵਸ੍ਯ ਸ਼੍ਮਸ਼ਾਨਾਨ੍ਤਿਕਮ੍ ਅਗੱਛਤ੍| ਤਤ੍ ਸ਼੍ਮਸ਼ਾਨਮ੍ ਏਕੰ ਗਹ੍ਵਰੰ ਤਨ੍ਮੁਖੇ ਪਾਸ਼਼ਾਣ ਏਕ ਆਸੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","ਤਦਾ ਯੀਸ਼ੁਰਵਦਦ੍ ਏਨੰ ਪਾਸ਼਼ਾਣਮ੍ ਅਪਸਾਰਯਤ, ਤਤਃ ਪ੍ਰਮੀਤਸ੍ਯ ਭਗਿਨੀ ਮਰ੍ਥਾਵਦਤ੍ ਪ੍ਰਭੋ, ਅਧੁਨਾ ਤਤ੍ਰ ਦੁਰ੍ਗਨ੍ਧੋ ਜਾਤਃ, ਯਤੋਦ੍ਯ ਚਤ੍ਵਾਰਿ ਦਿਨਾਨਿ ਸ਼੍ਮਸ਼ਾਨੇ ਸ ਤਿਸ਼਼੍ਠਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","ਤਦਾ ਯੀਸ਼ੁਰਵਾਦੀਤ੍, ਯਦਿ ਵਿਸ਼੍ਵਸਿਸ਼਼ਿ ਤਰ੍ਹੀਸ਼੍ਵਰਸ੍ਯ ਮਹਿਮਪ੍ਰਕਾਸ਼ੰ ਦ੍ਰਕ੍ਸ਼਼੍ਯਸਿ ਕਥਾਮਿਮਾਂ ਕਿੰ ਤੁਭ੍ਯੰ ਨਾਕਥਯੰ? ");
INSERT INTO sanpun_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","ਤਦਾ ਮ੍ਰੁʼਤਸ੍ਯ ਸ਼੍ਮਸ਼ਾਨਾਤ੍ ਪਾਸ਼਼ਾਣੋ(ਅ)ਪਸਾਰਿਤੇ ਯੀਸ਼ੁਰੂਰ੍ਦ੍ੱਵੰ ਪਸ਼੍ਯਨ੍ ਅਕਥਯਤ੍, ਹੇ ਪਿਤ ਰ੍ਮਮ ਨੇਵੇਸਨਮ੍ ਅਸ਼੍ਰੁʼਣੋਃ ਕਾਰਣਾਦਸ੍ਮਾਤ੍ ਤ੍ਵਾਂ ਧਨ੍ਯੰ ਵਦਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ਤ੍ਵੰ ਸਤਤੰ ਸ਼੍ਰੁʼਣੋਸ਼਼ਿ ਤਦਪ੍ਯਹੰ ਜਾਨਾਮਿ, ਕਿਨ੍ਤੁ ਤ੍ਵੰ ਮਾਂ ਯਤ੍ ਪ੍ਰੈਰਯਸ੍ਤਦ੍ ਯਥਾਸ੍ਮਿਨ੍ ਸ੍ਥਾਨੇ ਸ੍ਥਿਤਾ ਲੋਕਾ ਵਿਸ਼੍ਵਸਨ੍ਤਿ ਤਦਰ੍ਥਮ੍ ਇਦੰ ਵਾਕ੍ਯੰ ਵਦਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ਇਮਾਂ ਕਥਾਂ ਕਥਯਿਤ੍ਵਾ ਸ ਪ੍ਰੋੱਚੈਰਾਹ੍ਵਯਤ੍, ਹੇ ਇਲਿਯਾਸਰ੍ ਬਹਿਰਾਗੱਛ| ");
INSERT INTO sanpun_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","ਤਤਃ ਸ ਪ੍ਰਮੀਤਃ ਸ਼੍ਮਸ਼ਾਨਵਸ੍ਤ੍ਰੈ ਰ੍ਬੱਧਹਸ੍ਤਪਾਦੋ ਗਾਤ੍ਰਮਾਰ੍ਜਨਵਾਸਸਾ ਬੱਧਮੁਖਸ਼੍ਚ ਬਹਿਰਾਗੱਛਤ੍| ਯੀਸ਼ੁਰੁਦਿਤਵਾਨ੍ ਬਨ੍ਧਨਾਨਿ ਮੋਚਯਿਤ੍ਵਾ ਤ੍ਯਜਤੈਨੰ| ");
INSERT INTO sanpun_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","ਮਰਿਯਮਃ ਸਮੀਪਮ੍ ਆਗਤਾ ਯੇ ਯਿਹੂਦੀਯਲੋਕਾਸ੍ਤਦਾ ਯੀਸ਼ੋਰੇਤਤ੍ ਕਰ੍ੰਮਾਪਸ਼੍ਯਨ੍ ਤੇਸ਼਼ਾਂ ਬਹਵੋ ਵ੍ਯਸ਼੍ਵਸਨ੍, ");
INSERT INTO sanpun_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","ਕਿਨ੍ਤੁ ਕੇਚਿਦਨ੍ਯੇ ਫਿਰੂਸ਼ਿਨਾਂ ਸਮੀਪੰ ਗਤ੍ਵਾ ਯੀਸ਼ੋਰੇਤਸ੍ਯ ਕਰ੍ੰਮਣੋ ਵਾਰ੍ੱਤਾਮ੍ ਅਵਦਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","ਤਤਃ ਪਰੰ ਪ੍ਰਧਾਨਯਾਜਕਾਃ ਫਿਰੂਸ਼ਿਨਾਸ਼੍ਚ ਸਭਾਂ ਕ੍ਰੁʼਤ੍ਵਾ ਵ੍ਯਾਹਰਨ੍ ਵਯੰ ਕਿੰ ਕੁਰ੍ੰਮਃ? ਏਸ਼਼ ਮਾਨਵੋ ਬਹੂਨ੍ਯਾਸ਼੍ਚਰ੍ੱਯਕਰ੍ੰਮਾਣਿ ਕਰੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","ਯਦੀਦ੍ਰੁʼਸ਼ੰ ਕਰ੍ੰਮ ਕਰ੍ੱਤੁੰ ਨ ਵਾਰਯਾਮਸ੍ਤਰ੍ਹਿ ਸਰ੍ੱਵੇ ਲੋਕਾਸ੍ਤਸ੍ਮਿਨ੍ ਵਿਸ਼੍ਵਸਿਸ਼਼੍ਯਨ੍ਤਿ ਰੋਮਿਲੋਕਾਸ਼੍ਚਾਗਤ੍ਯਾਸ੍ਮਾਕਮ੍ ਅਨਯਾ ਰਾਜਧਾਨ੍ਯਾ ਸਾਰ੍ੱਧੰ ਰਾਜ੍ਯਮ੍ ਆਛੇਤ੍ਸ੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","ਤਦਾ ਤੇਸ਼਼ਾਂ ਕਿਯਫਾਨਾਮਾ ਯਸ੍ਤਸ੍ਮਿਨ੍ ਵਤ੍ਸਰੇ ਮਹਾਯਾਜਕਪਦੇ ਨ੍ਯਯੁਜ੍ਯਤ ਸ ਪ੍ਰਤ੍ਯਵਦਦ੍ ਯੂਯੰ ਕਿਮਪਿ ਨ ਜਾਨੀਥ; ");
INSERT INTO sanpun_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ਸਮਗ੍ਰਦੇਸ਼ਸ੍ਯ ਵਿਨਾਸ਼ਤੋਪਿ ਸਰ੍ੱਵਲੋਕਾਰ੍ਥਮ੍ ਏਕਸ੍ਯ ਜਨਸ੍ਯ ਮਰਣਮ੍ ਅਸ੍ਮਾਕੰ ਮਙ੍ਗਲਹੇਤੁਕਮ੍ ਏਤਸ੍ਯ ਵਿਵੇਚਨਾਮਪਿ ਨ ਕੁਰੁਥ| ");
INSERT INTO sanpun_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","ਏਤਾਂ ਕਥਾਂ ਸ ਨਿਜਬੁੱਧ੍ਯਾ ਵ੍ਯਾਹਰਦ੍ ਇਤਿ ਨ, ");
INSERT INTO sanpun_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ਕਿਨ੍ਤੁ ਯੀਸ਼ੂਸ੍ਤੱਦੇਸ਼ੀਯਾਨਾਂ ਕਾਰਣਾਤ੍ ਪ੍ਰਾਣਾਨ੍ ਤ੍ਯਕ੍ਸ਼਼੍ਯਤਿ, ਦਿਸ਼ਿ ਦਿਸ਼ਿ ਵਿਕੀਰ੍ਣਾਨ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਸਨ੍ਤਾਨਾਨ੍ ਸੰਗ੍ਰੁʼਹ੍ਯੈਕਜਾਤਿੰ ਕਰਿਸ਼਼੍ਯਤਿ ਚ, ਤਸ੍ਮਿਨ੍ ਵਤ੍ਸਰੇ ਕਿਯਫਾ ਮਹਾਯਾਜਕਤ੍ਵਪਦੇ ਨਿਯੁਕ੍ਤਃ ਸਨ੍ ਇਦੰ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਕ੍ਯੰ ਕਥਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","ਤੱਦਿਨਮਾਰਭ੍ਯ ਤੇ ਕਥੰ ਤੰ ਹਨ੍ਤੁੰ ਸ਼ਕ੍ਨੁਵਨ੍ਤੀਤਿ ਮਨ੍ਤ੍ਰਣਾਂ ਕਰ੍ੱਤੁੰ ਪ੍ਰਾਰੇਭਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ਅਤਏਵ ਯਿਹੂਦੀਯਾਨਾਂ ਮਧ੍ਯੇ ਯੀਸ਼ੁਃ ਸਪ੍ਰਕਾਸ਼ੰ ਗਮਨਾਗਮਨੇ ਅਕ੍ਰੁʼਤ੍ਵਾ ਤਸ੍ਮਾਦ੍ ਗਤ੍ਵਾ ਪ੍ਰਾਨ੍ਤਰਸ੍ਯ ਸਮੀਪਸ੍ਥਾਯਿਪ੍ਰਦੇਸ਼ਸ੍ਯੇਫ੍ਰਾਯਿਮ੍ ਨਾਮ੍ਨਿ ਨਗਰੇ ਸ਼ਿਸ਼਼੍ਯੈਃ ਸਾਕੰ ਕਾਲੰ ਯਾਪਯਿਤੁੰ ਪ੍ਰਾਰੇਭੇ| ");
INSERT INTO sanpun_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","ਅਨਨ੍ਤਰੰ ਯਿਹੂਦੀਯਾਨਾਂ ਨਿਸ੍ਤਾਰੋਤ੍ਸਵੇ ਨਿਕਟਵਰ੍ੱਤਿਨਿ ਸਤਿ ਤਦੁਤ੍ਸਵਾਤ੍ ਪੂਰ੍ੱਵੰ ਸ੍ਵਾਨ੍ ਸ਼ੁਚੀਨ੍ ਕਰ੍ੱਤੁੰ ਬਹਵੋ ਜਨਾ ਗ੍ਰਾਮੇਭ੍ਯੋ ਯਿਰੂਸ਼ਾਲਮ੍ ਨਗਰਮ੍ ਆਗੱਛਨ੍, ");
INSERT INTO sanpun_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ਯੀਸ਼ੋਰਨ੍ਵੇਸ਼਼ਣੰ ਕ੍ਰੁʼਤ੍ਵਾ ਮਨ੍ਦਿਰੇ ਦਣ੍ਡਾਯਮਾਨਾਃ ਸਨ੍ਤਃ ਪਰਸ੍ਪਰੰ ਵ੍ਯਾਹਰਨ੍, ਯੁਸ਼਼੍ਮਾਕੰ ਕੀਦ੍ਰੁʼਸ਼ੋ ਬੋਧੋ ਜਾਯਤੇ? ਸ ਕਿਮ੍ ਉਤ੍ਸਵੇ(ਅ)ਸ੍ਮਿਨ੍ ਅਤ੍ਰਾਗਮਿਸ਼਼੍ਯਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","ਸ ਚ ਕੁਤ੍ਰਾਸ੍ਤਿ ਯਦ੍ਯੇਤਤ੍ ਕਸ਼੍ਚਿਦ੍ ਵੇੱਤਿ ਤਰ੍ਹਿ ਦਰ੍ਸ਼ਯਤੁ ਪ੍ਰਧਾਨਯਾਜਕਾਃ ਫਿਰੂਸ਼ਿਨਸ਼੍ਚ ਤੰ ਧਰ੍ੱਤੁੰ ਪੂਰ੍ੱਵਮ੍ ਇਮਾਮ੍ ਆਜ੍ਞਾਂ ਪ੍ਰਾਚਾਰਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","ਨਿਸ੍ਤਾਰੋਤ੍ਸਵਾਤ੍ ਪੂਰ੍ੱਵੰ ਦਿਨਸ਼਼ਟ੍ਕੇ ਸ੍ਥਿਤੇ ਯੀਸ਼ੁ ਰ੍ਯੰ ਪ੍ਰਮੀਤਮ੍ ਇਲਿਯਾਸਰੰ ਸ਼੍ਮਸ਼ਾਨਾਦ੍ ਉਦਸ੍ਥਾਪਰਤ੍ ਤਸ੍ਯ ਨਿਵਾਸਸ੍ਥਾਨੰ ਬੈਥਨਿਯਾਗ੍ਰਾਮਮ੍ ਆਗੱਛਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","ਤਤ੍ਰ ਤਦਰ੍ਥੰ ਰਜਨ੍ਯਾਂ ਭੋਜ੍ਯੇ ਕ੍ਰੁʼਤੇ ਮਰ੍ਥਾ ਪਰ੍ੱਯਵੇਸ਼਼ਯਦ੍ ਇਲਿਯਾਸਰ੍ ਚ ਤਸ੍ਯ ਸਙ੍ਗਿਭਿਃ ਸਾਰ੍ੱਧੰ ਭੋਜਨਾਸਨ ਉਪਾਵਿਸ਼ਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","ਤਦਾ ਮਰਿਯਮ੍ ਅਰ੍ੱਧਸੇਟਕੰ ਬਹੁਮੂਲ੍ਯੰ ਜਟਾਮਾਂਸੀਯੰ ਤੈਲਮ੍ ਆਨੀਯ ਯੀਸ਼ੋਸ਼੍ਚਰਣਯੋ ਰ੍ਮਰ੍ੱਦਯਿਤ੍ਵਾ ਨਿਜਕੇਸ਼ ਰ੍ਮਾਰ੍ਸ਼਼੍ਟੁਮ੍ ਆਰਭਤ; ਤਦਾ ਤੈਲਸ੍ਯ ਪਰਿਮਲੇਨ ਗ੍ਰੁʼਹਮ੍ ਆਮੋਦਿਤਮ੍ ਅਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ਯਃ ਸ਼ਿਮੋਨਃ ਪੁਤ੍ਰ ਰਿਸ਼਼੍ਕਰਿਯੋਤੀਯੋ ਯਿਹੂਦਾਨਾਮਾ ਯੀਸ਼ੁੰ ਪਰਕਰੇਸ਼਼ੁ ਸਮਰ੍ਪਯਿਸ਼਼੍ਯਤਿ ਸ ਸ਼ਿਸ਼਼੍ਯਸ੍ਤਦਾ ਕਥਿਤਵਾਨ੍, ");
INSERT INTO sanpun_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","ਏਤੱਤੈਲੰ ਤ੍ਰਿਭਿਃ ਸ਼ਤੈ ਰ੍ਮੁਦ੍ਰਾਪਦੈ ਰ੍ਵਿਕ੍ਰੀਤੰ ਸਦ੍ ਦਰਿਦ੍ਰੇਭ੍ਯਃ ਕੁਤੋ ਨਾਦੀਯਤ? ");
INSERT INTO sanpun_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ਸ ਦਰਿਦ੍ਰਲੋਕਾਰ੍ਥਮ੍ ਅਚਿਨ੍ਤਯਦ੍ ਇਤਿ ਨ, ਕਿਨ੍ਤੁ ਸ ਚੌਰ ਏਵੰ ਤੰਨਿਕਟੇ ਮੁਦ੍ਰਾਸਮ੍ਪੁਟਕਸ੍ਥਿਤ੍ਯਾ ਤਨ੍ਮਧ੍ਯੇ ਯਦਤਿਸ਼਼੍ਠਤ੍ ਤਦਪਾਹਰਤ੍ ਤਸ੍ਮਾਤ੍ ਕਾਰਣਾਦ੍ ਇਮਾਂ ਕਥਾਮਕਥਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","ਤਦਾ ਯੀਸ਼ੁਰਕਥਯਦ੍ ਏਨਾਂ ਮਾ ਵਾਰਯ ਸਾ ਮਮ ਸ਼੍ਮਸ਼ਾਨਸ੍ਥਾਪਨਦਿਨਾਰ੍ਥੰ ਤਦਰਕ੍ਸ਼਼ਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","ਦਰਿਦ੍ਰਾ ਯੁਸ਼਼੍ਮਾਕੰ ਸੰਨਿਧੌ ਸਰ੍ੱਵਦਾ ਤਿਸ਼਼੍ਠਨ੍ਤਿ ਕਿਨ੍ਤ੍ਵਹੰ ਸਰ੍ੱਵਦਾ ਯੁਸ਼਼੍ਮਾਕੰ ਸੰਨਿਧੌ ਨ ਤਿਸ਼਼੍ਠਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","ਤਤਃ ਪਰੰ ਯੀਸ਼ੁਸ੍ਤਤ੍ਰਾਸ੍ਤੀਤਿ ਵਾਰ੍ੱਤਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਬਹਵੋ ਯਿਹੂਦੀਯਾਸ੍ਤੰ ਸ਼੍ਮਸ਼ਾਨਾਦੁੱਥਾਪਿਤਮ੍ ਇਲਿਯਾਸਰਞ੍ਚ ਦ੍ਰਸ਼਼੍ਟੁੰ ਤਤ੍ ਸ੍ਥਾਨਮ੍ ਆਗੱਛਨ| ");
INSERT INTO sanpun_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","ਤਦਾ ਪ੍ਰਧਾਨਯਾਜਕਾਸ੍ਤਮ੍ ਇਲਿਯਾਸਰਮਪਿ ਸੰਹਰ੍ੱਤੁਮ੍ ਅਮਨ੍ਤ੍ਰਯਨ੍ ; ");
INSERT INTO sanpun_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ਯਤਸ੍ਤੇਨ ਬਹਵੋ ਯਿਹੂਦੀਯਾ ਗਤ੍ਵਾ ਯੀਸ਼ੌ ਵ੍ਯਸ਼੍ਵਸਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","ਅਨਨ੍ਤਰੰ ਯੀਸ਼ੁ ਰ੍ਯਿਰੂਸ਼ਾਲਮ੍ ਨਗਰਮ੍ ਆਗੱਛਤੀਤਿ ਵਾਰ੍ੱਤਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਪਰੇ(ਅ)ਹਨਿ ਉਤ੍ਸਵਾਗਤਾ ਬਹਵੋ ਲੋਕਾਃ ");
INSERT INTO sanpun_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ਖਰ੍ੱਜੂਰਪਤ੍ਰਾਦ੍ਯਾਨੀਯ ਤੰ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਕਰ੍ੱਤੁੰ ਬਹਿਰਾਗਤ੍ਯ ਜਯ ਜਯੇਤਿ ਵਾਚੰ ਪ੍ਰੋੱਚੈ ਰ੍ਵਕ੍ਤੁਮ੍ ਆਰਭਨ੍ਤ, ਇਸ੍ਰਾਯੇਲੋ ਯੋ ਰਾਜਾ ਪਰਮੇਸ਼੍ਵਰਸ੍ਯ ਨਾਮ੍ਨਾਗੱਛਤਿ ਸ ਧਨ੍ਯਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","ਤਦਾ \"ਹੇ ਸਿਯੋਨਃ ਕਨ੍ਯੇ ਮਾ ਭੈਸ਼਼ੀਃ ਪਸ਼੍ਯਾਯੰ ਤਵ ਰਾਜਾ ਗਰ੍ੱਦਭਸ਼ਾਵਕਮ੍ ਆਰੁਹ੍ਯਾਗੱਛਤਿ\" ");
INSERT INTO sanpun_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","ਇਤਿ ਸ਼ਾਸ੍ਤ੍ਰੀਯਵਚਨਾਨੁਸਾਰੇਣ ਯੀਸ਼ੁਰੇਕੰ ਯੁਵਗਰ੍ੱਦਭੰ ਪ੍ਰਾਪ੍ਯ ਤਦੁਪਰ੍ੱਯਾਰੋਹਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","ਅਸ੍ਯਾਃ ਘਟਨਾਯਾਸ੍ਤਾਤ੍ਪਰ੍ੱਯੰ ਸ਼ਿਸ਼਼੍ਯਾਃ ਪ੍ਰਥਮੰ ਨਾਬੁਧ੍ਯਨ੍ਤ, ਕਿਨ੍ਤੁ ਯੀਸ਼ੌ ਮਹਿਮਾਨੰ ਪ੍ਰਾਪ੍ਤੇ ਸਤਿ ਵਾਕ੍ਯਮਿਦੰ ਤਸ੍ਮਿਨ ਅਕਥ੍ਯਤ ਲੋਕਾਸ਼੍ਚ ਤਮ੍ਪ੍ਰਤੀੱਥਮ੍ ਅਕੁਰ੍ੱਵਨ੍ ਇਤਿ ਤੇ ਸ੍ਮ੍ਰੁʼਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","ਸ ਇਲਿਯਾਸਰੰ ਸ਼੍ਮਸ਼ਾਨਾਦ੍ ਆਗਨ੍ਤੁਮ੍ ਆਹ੍ਵਤਵਾਨ੍ ਸ਼੍ਮਸ਼ਾਨਾਞ੍ਚ ਉਦਸ੍ਥਾਪਯਦ੍ ਯੇ ਯੇ ਲੋਕਾਸ੍ਤਤ੍ਕਰ੍ਮ੍ਯ ਸਾਕ੍ਸ਼਼ਾਦ੍ ਅਪਸ਼੍ਯਨ੍ ਤੇ ਪ੍ਰਮਾਣੰ ਦਾਤੁਮ੍ ਆਰਭਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ਸ ਏਤਾਦ੍ਰੁʼਸ਼ਮ੍ ਅਦ੍ਭੁਤੰ ਕਰ੍ੰਮਕਰੋਤ੍ ਤਸ੍ਯ ਜਨਸ਼੍ਰੁਤੇ ਰ੍ਲੋਕਾਸ੍ਤੰ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਕਰ੍ੱਤੁਮ੍ ਆਗੱਛਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ਤਤਃ ਫਿਰੂਸ਼ਿਨਃ ਪਰਸ੍ਪਰੰ ਵਕ੍ਤੁਮ੍ ਆਰਭਨ੍ਤ ਯੁਸ਼਼੍ਮਾਕੰ ਸਰ੍ੱਵਾਸ਼੍ਚੇਸ਼਼੍ਟਾ ਵ੍ਰੁʼਥਾ ਜਾਤਾਃ, ਇਤਿ ਕਿੰ ਯੂਯੰ ਨ ਬੁਧ੍ਯਧ੍ਵੇ? ਪਸ਼੍ਯਤ ਸਰ੍ੱਵੇ ਲੋਕਾਸ੍ਤਸ੍ਯ ਪਸ਼੍ਚਾਦ੍ਵਰ੍ੱਤਿਨੋਭਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ਭਜਨੰ ਕਰ੍ੱਤੁਮ੍ ਉਤ੍ਸਵਾਗਤਾਨਾਂ ਲੋਕਾਨਾਂ ਕਤਿਪਯਾ ਜਨਾ ਅਨ੍ਯਦੇਸ਼ੀਯਾ ਆਸਨ੍ , ");
INSERT INTO sanpun_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ਤੇ ਗਾਲੀਲੀਯਬੈਤ੍ਸੈਦਾਨਿਵਾਸਿਨਃ ਫਿਲਿਪਸ੍ਯ ਸਮੀਪਮ੍ ਆਗਤ੍ਯ ਵ੍ਯਾਹਰਨ੍ ਹੇ ਮਹੇੱਛ ਵਯੰ ਯੀਸ਼ੁੰ ਦ੍ਰਸ਼਼੍ਟੁਮ੍ ਇੱਛਾਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ਤਤਃ ਫਿਲਿਪੋ ਗਤ੍ਵਾ ਆਨ੍ਦ੍ਰਿਯਮ੍ ਅਵਦਤ੍ ਪਸ਼੍ਚਾਦ੍ ਆਨ੍ਦ੍ਰਿਯਫਿਲਿਪੌ ਯੀਸ਼ਵੇ ਵਾਰ੍ੱਤਾਮ੍ ਅਕਥਯਤਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","ਤਦਾ ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯੁਦਿਤਵਾਨ੍ ਮਾਨਵਸੁਤਸ੍ਯ ਮਹਿਮਪ੍ਰਾਪ੍ਤਿਸਮਯ ਉਪਸ੍ਥਿਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ਅਹੰ ਯੁਸ਼਼੍ਮਾਨਤਿਯਥਾਰ੍ਥੰ ਵਦਾਮਿ, ਧਾਨ੍ਯਬੀਜੰ ਮ੍ਰੁʼੱਤਿਕਾਯਾਂ ਪਤਿਤ੍ਵਾ ਯਦਿ ਨ ਮ੍ਰੁʼਯਤੇ ਤਰ੍ਹ੍ਯੇਕਾਕੀ ਤਿਸ਼਼੍ਠਤਿ ਕਿਨ੍ਤੁ ਯਦਿ ਮ੍ਰੁʼਯਤੇ ਤਰ੍ਹਿ ਬਹੁਗੁਣੰ ਫਲੰ ਫਲਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ਯੋ ਜਨੇा ਨਿਜਪ੍ਰਾਣਾਨ੍ ਪ੍ਰਿਯਾਨ੍ ਜਾਨਾਤਿ ਸ ਤਾਨ੍ ਹਾਰਯਿਸ਼਼੍ਯਤਿ ਕਿਨ੍ਤੁ ਯੇा ਜਨ ਇਹਲੋਕੇ ਨਿਜਪ੍ਰਾਣਾਨ੍ ਅਪ੍ਰਿਯਾਨ੍ ਜਾਨਾਤਿ ਸੇाਨਨ੍ਤਾਯੁਃ ਪ੍ਰਾਪ੍ਤੁੰ ਤਾਨ੍ ਰਕ੍ਸ਼਼ਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","ਕਸ਼੍ਚਿਦ੍ ਯਦਿ ਮਮ ਸੇਵਕੋ ਭਵਿਤੁੰ ਵਾਞ੍ਛਤਿ ਤਰ੍ਹਿ ਸ ਮਮ ਪਸ਼੍ਚਾਦ੍ਗਾਮੀ ਭਵਤੁ, ਤਸ੍ਮਾਦ੍ ਅਹੰ ਯਤ੍ਰ ਤਿਸ਼਼੍ਠਾਮਿ ਮਮ ਸੇਵਕੇाਪਿ ਤਤ੍ਰ ਸ੍ਥਾਸ੍ਯਤਿ; ਯੋ ਜਨੋ ਮਾਂ ਸੇਵਤੇ ਮਮ ਪਿਤਾਪਿ ਤੰ ਸੰਮੰਸ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","ਸਾਮ੍ਪ੍ਰਤੰ ਮਮ ਪ੍ਰਾਣਾ ਵ੍ਯਾਕੁਲਾ ਭਵਨ੍ਤਿ, ਤਸ੍ਮਾਦ੍ ਹੇ ਪਿਤਰ ਏਤਸ੍ਮਾਤ੍ ਸਮਯਾਨ੍ ਮਾਂ ਰਕ੍ਸ਼਼, ਇਤ੍ਯਹੰ ਕਿੰ ਪ੍ਰਾਰ੍ਥਯਿਸ਼਼੍ਯੇ? ਕਿਨ੍ਤ੍ਵਹਮ੍ ਏਤਤ੍ਸਮਯਾਰ੍ਥਮ੍ ਅਵਤੀਰ੍ਣਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ਹੇ ਪਿਤ: ਸ੍ਵਨਾਮ੍ਨੋ ਮਹਿਮਾਨੰ ਪ੍ਰਕਾਸ਼ਯ; ਤਨੈਵ ਸ੍ਵਨਾਮ੍ਨੋ ਮਹਿਮਾਨਮ੍ ਅਹੰ ਪ੍ਰਾਕਾਸ਼ਯੰ ਪੁਨਰਪਿ ਪ੍ਰਕਾਸ਼ਯਿਸ਼਼੍ਯਾਮਿ, ਏਸ਼਼ਾ ਗਗਣੀਯਾ ਵਾਣੀ ਤਸ੍ਮਿਨ੍ ਸਮਯੇ(ਅ)ਜਾਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","ਤਚ੍ਸ਼੍ਰੁਤ੍ਵਾ ਸਮੀਪਸ੍ਥਲੋਕਾਨਾਂ ਕੇਚਿਦ੍ ਅਵਦਨ੍ ਮੇਘੋ(ਅ)ਗਰ੍ਜੀਤ੍, ਕੇਚਿਦ੍ ਅਵਦਨ੍ ਸ੍ਵਰ੍ਗੀਯਦੂਤੋ(ਅ)ਨੇਨ ਸਹ ਕਥਾਮਚਕਥਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","ਤਦਾ ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯਵਾਦੀਤ੍, ਮਦਰ੍ਥੰ ਸ਼ਬ੍ਦੋਯੰ ਨਾਭੂਤ੍ ਯੁਸ਼਼੍ਮਦਰ੍ਥਮੇਵਾਭੂਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","ਅਧੁਨਾ ਜਗਤੋਸ੍ਯ ਵਿਚਾਰ: ਸਮ੍ਪਤ੍ਸ੍ਯਤੇ, ਅਧੁਨਾਸ੍ਯ ਜਗਤ: ਪਤੀ ਰਾਜ੍ਯਾਤ੍ ਚ੍ਯੋਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","ਯਦ੍ਯਈ ਪ੍ਰੁʼਥਿਵ੍ਯਾ ਊਰ੍ਦ੍ੱਵੇ ਪ੍ਰੋੱਥਾਪਿਤੋਸ੍ਮਿ ਤਰ੍ਹਿ ਸਰ੍ੱਵਾਨ੍ ਮਾਨਵਾਨ੍ ਸ੍ਵਸਮੀਪਮ੍ ਆਕਰ੍ਸ਼਼ਿਸ਼਼੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","ਕਥੰ ਤਸ੍ਯ ਮ੍ਰੁʼਤਿ ਰ੍ਭਵਿਸ਼਼੍ਯਤਿ, ਏਤਦ੍ ਬੋਧਯਿਤੁੰ ਸ ਇਮਾਂ ਕਥਾਮ੍ ਅਕਥਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","ਤਦਾ ਲੋਕਾ ਅਕਥਯਨ੍ ਸੋਭਿਸ਼਼ਿਕ੍ਤਃ ਸਰ੍ੱਵਦਾ ਤਿਸ਼਼੍ਠਤੀਤਿ ਵ੍ਯਵਸ੍ਥਾਗ੍ਰਨ੍ਥੇ ਸ਼੍ਰੁਤਮ੍ ਅਸ੍ਮਾਭਿਃ, ਤਰ੍ਹਿ ਮਨੁਸ਼਼੍ਯਪੁਤ੍ਰਃ ਪ੍ਰੋੱਥਾਪਿਤੋ ਭਵਿਸ਼਼੍ਯਤੀਤਿ ਵਾਕ੍ਯੰ ਕਥੰ ਵਦਸਿ? ਮਨੁਸ਼਼੍ਯਪੁਤ੍ਰੋਯੰ ਕਃ? ");
INSERT INTO sanpun_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","ਤਦਾ ਯੀਸ਼ੁਰਕਥਾਯਦ੍ ਯੁਸ਼਼੍ਮਾਭਿਃ ਸਾਰ੍ੱਧਮ੍ ਅਲ੍ਪਦਿਨਾਨਿ ਜ੍ਯੋਤਿਰਾਸ੍ਤੇ, ਯਥਾ ਯੁਸ਼਼੍ਮਾਨ੍ ਅਨ੍ਧਕਾਰੋ ਨਾੱਛਾਦਯਤਿ ਤਦਰ੍ਥੰ ਯਾਵਤ੍ਕਾਲੰ ਯੁਸ਼਼੍ਮਾਭਿਃ ਸਾਰ੍ੱਧੰ ਜ੍ਯੋਤਿਸ੍ਤਿਸ਼਼੍ਠਤਿ ਤਾਵਤ੍ਕਾਲੰ ਗੱਛਤ; ਯੋ ਜਨੋ(ਅ)ਨ੍ਧਕਾਰੇ ਗੱਛਤਿ ਸ ਕੁਤ੍ਰ ਯਾਤੀਤਿ ਨ ਜਾਨਾਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ਅਤਏਵ ਯਾਵਤ੍ਕਾਲੰ ਯੁਸ਼਼੍ਮਾਕੰ ਨਿਕਟੇ ਜ੍ਯੋਤਿਰਾਸ੍ਤੇ ਤਾਵਤ੍ਕਾਲੰ ਜ੍ਯੋਤੀਰੂਪਸਨ੍ਤਾਨਾ ਭਵਿਤੁੰ ਜ੍ਯੋਤਿਸ਼਼ਿ ਵਿਸ਼੍ਵਸਿਤ; ਇਮਾਂ ਕਥਾਂ ਕਥਯਿਤ੍ਵਾ ਯੀਸ਼ੁਃ ਪ੍ਰਸ੍ਥਾਯ ਤੇਭ੍ਯਃ ਸ੍ਵੰ ਗੁਪ੍ਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","ਯਦ੍ਯਪਿ ਯੀਸ਼ੁਸ੍ਤੇਸ਼਼ਾਂ ਸਮਕ੍ਸ਼਼ਮ੍ ਏਤਾਵਦਾਸ਼੍ਚਰ੍ੱਯਕਰ੍ੰਮਾਣਿ ਕ੍ਰੁʼਤਵਾਨ੍ ਤਥਾਪਿ ਤੇ ਤਸ੍ਮਿਨ੍ ਨ ਵ੍ਯਸ਼੍ਵਸਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ਅਤਏਵ ਕਃ ਪ੍ਰਤ੍ਯੇਤਿ ਸੁਸੰਵਾਦੰ ਪਰੇਸ਼ਾਸ੍ਮਤ੍ ਪ੍ਰਚਾਰਿਤੰ? ਪ੍ਰਕਾਸ਼ਤੇ ਪਰੇਸ਼ਸ੍ਯ ਹਸ੍ਤਃ ਕਸ੍ਯ ਚ ਸੰਨਿਧੌ? ਯਿਸ਼ਯਿਯਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਾ ਯਦੇਤਦ੍ ਵਾਕ੍ਯਮੁਕ੍ਤੰ ਤਤ੍ ਸਫਲਮ੍ ਅਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","ਤੇ ਪ੍ਰਤ੍ਯੇਤੁੰ ਨਾਸ਼ਨ੍ਕੁਵਨ੍ ਤਸ੍ਮਿਨ੍ ਯਿਸ਼ਯਿਯਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿ ਪੁਨਰਵਾਦੀਦ੍, ");
INSERT INTO sanpun_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","ਯਦਾ, \"ਤੇ ਨਯਨੈ ਰ੍ਨ ਪਸ਼੍ਯਨ੍ਤਿ ਬੁੱਧਿਭਿਸ਼੍ਚ ਨ ਬੁਧ੍ਯਨ੍ਤੇ ਤੈ ਰ੍ਮਨਃਸੁ ਪਰਿਵਰ੍ੱਤਿਤੇਸ਼਼ੁ ਚ ਤਾਨਹੰ ਯਥਾ ਸ੍ਵਸ੍ਥਾਨ੍ ਨ ਕਰੋਮਿ ਤਥਾ ਸ ਤੇਸ਼਼ਾਂ ਲੋਚਨਾਨ੍ਯਨ੍ਧਾਨਿ ਕ੍ਰੁʼਤ੍ਵਾ ਤੇਸ਼਼ਾਮਨ੍ਤਃਕਰਣਾਨਿ ਗਾਢਾਨਿ ਕਰਿਸ਼਼੍ਯਤਿ| \" ");
INSERT INTO sanpun_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","ਯਿਸ਼ਯਿਯੋ ਯਦਾ ਯੀਸ਼ੋ ਰ੍ਮਹਿਮਾਨੰ ਵਿਲੋਕ੍ਯ ਤਸ੍ਮਿਨ੍ ਕਥਾਮਕਥਯਤ੍ ਤਦਾ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਕ੍ਯਮ੍ ਈਦ੍ਰੁʼਸ਼ੰ ਪ੍ਰਕਾਸ਼ਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ਤਥਾਪ੍ਯਧਿਪਤਿਨਾਂ ਬਹਵਸ੍ਤਸ੍ਮਿਨ੍ ਪ੍ਰਤ੍ਯਾਯਨ੍| ਕਿਨ੍ਤੁ ਫਿਰੂਸ਼ਿਨਸ੍ਤਾਨ੍ ਭਜਨਗ੍ਰੁʼਹਾਦ੍ ਦੂਰੀਕੁਰ੍ੱਵਨ੍ਤੀਤਿ ਭਯਾਤ੍ ਤੇ ਤੰ ਨ ਸ੍ਵੀਕ੍ਰੁʼਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ਯਤ ਈਸ਼੍ਵਰਸ੍ਯ ਪ੍ਰਸ਼ੰਸਾਤੋ ਮਾਨਵਾਨਾਂ ਪ੍ਰਸ਼ੰਸਾਯਾਂ ਤੇ(ਅ)ਪ੍ਰਿਯਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","ਤਦਾ ਯੀਸ਼ੁਰੁੱਚੈਃਕਾਰਮ੍ ਅਕਥਯਦ੍ ਯੋ ਜਨੋ ਮਯਿ ਵਿਸ਼੍ਵਸਿਤਿ ਸ ਕੇਵਲੇ ਮਯਿ ਵਿਸ਼੍ਵਸਿਤੀਤਿ ਨ, ਸ ਮਤ੍ਪ੍ਰੇਰਕੇ(ਅ)ਪਿ ਵਿਸ਼੍ਵਸਿਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ਯੋ ਜਨੋ ਮਾਂ ਪਸ਼੍ਯਤਿ ਸ ਮਤ੍ਪ੍ਰੇਰਕਮਪਿ ਪਸ਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","ਯੋ ਜਨੋ ਮਾਂ ਪ੍ਰਤ੍ਯੇਤਿ ਸ ਯਥਾਨ੍ਧਕਾਰੇ ਨ ਤਿਸ਼਼੍ਠਤਿ ਤਦਰ੍ਥਮ੍ ਅਹੰ ਜ੍ਯੋਤਿਃਸ੍ਵਰੂਪੋ ਭੂਤ੍ਵਾ ਜਗਤ੍ਯਸ੍ਮਿਨ੍ ਅਵਤੀਰ੍ਣਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","ਮਮ ਕਥਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਯਦਿ ਕਸ਼੍ਚਿਨ੍ ਨ ਵਿਸ਼੍ਵਸਿਤਿ ਤਰ੍ਹਿ ਤਮਹੰ ਦੋਸ਼਼ਿਣੰ ਨ ਕਰੋਮਿ, ਯਤੋ ਹੇਤੋ ਰ੍ਜਗਤੋ ਜਨਾਨਾਂ ਦੋਸ਼਼ਾਨ੍ ਨਿਸ਼੍ਚਿਤਾਨ੍ ਕਰ੍ੱਤੁੰ ਨਾਗਤ੍ਯ ਤਾਨ੍ ਪਰਿਚਾਤੁਮ੍ ਆਗਤੋਸ੍ਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ਯਃ ਕਸ਼੍ਚਿਨ੍ ਮਾਂ ਨ ਸ਼੍ਰੱਧਾਯ ਮਮ ਕਥੰ ਨ ਗ੍ਰੁʼਹ੍ਲਾਤਿ, ਅਨ੍ਯਸ੍ਤੰ ਦੋਸ਼਼ਿਣੰ ਕਰਿਸ਼਼੍ਯਤਿ ਵਸ੍ਤੁਤਸ੍ਤੁ ਯਾਂ ਕਥਾਮਹਮ੍ ਅਚਕਥੰ ਸਾ ਕਥਾ ਚਰਮੇ(ਅ)ਨ੍ਹਿ ਤੰ ਦੋਸ਼਼ਿਣੰ ਕਰਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","ਯਤੋ ਹੇਤੋਰਹੰ ਸ੍ਵਤਃ ਕਿਮਪਿ ਨ ਕਥਯਾਮਿ, ਕਿੰ ਕਿੰ ਮਯਾ ਕਥਯਿਤਵ੍ਯੰ ਕਿੰ ਸਮੁਪਦੇਸ਼਼੍ਟਵ੍ਯਞ੍ਚ ਇਤਿ ਮਤ੍ਪ੍ਰੇਰਯਿਤਾ ਪਿਤਾ ਮਾਮਾਜ੍ਞਾਪਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ਤਸ੍ਯ ਸਾਜ੍ਞਾ ਅਨਨ੍ਤਾਯੁਰਿਤ੍ਯਹੰ ਜਾਨਾਮਿ, ਅਤਏਵਾਹੰ ਯਤ੍ ਕਥਯਾਮਿ ਤਤ੍ ਪਿਤਾ ਯਥਾਜ੍ਞਾਪਯਤ੍ ਤਥੈਵ ਕਥਯਾਮ੍ਯਹਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","ਨਿਸ੍ਤਾਰੋਤ੍ਸਵਸ੍ਯ ਕਿਞ੍ਚਿਤ੍ਕਾਲਾਤ੍ ਪੂਰ੍ੱਵੰ ਪ੍ਰੁʼਥਿਵ੍ਯਾਃ ਪਿਤੁਃ ਸਮੀਪਗਮਨਸ੍ਯ ਸਮਯਃ ਸੰਨਿਕਰ੍ਸ਼਼ੋਭੂਦ੍ ਇਤਿ ਜ੍ਞਾਤ੍ਵਾ ਯੀਸ਼ੁਰਾਪ੍ਰਥਮਾਦ੍ ਯੇਸ਼਼ੁ ਜਗਤ੍ਪ੍ਰਵਾਸਿਸ਼਼੍ਵਾਤ੍ਮੀਯਲੋਕੇਸ਼਼ ਪ੍ਰੇਮ ਕਰੋਤਿ ਸ੍ਮ ਤੇਸ਼਼ੁ ਸ਼ੇਸ਼਼ੰ ਯਾਵਤ੍ ਪ੍ਰੇਮ ਕ੍ਰੁʼਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","ਪਿਤਾ ਤਸ੍ਯ ਹਸ੍ਤੇ ਸਰ੍ੱਵੰ ਸਮਰ੍ਪਿਤਵਾਨ੍ ਸ੍ਵਯਮ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਸਮੀਪਾਦ੍ ਆਗੱਛਦ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਸਮੀਪੰ ਯਾਸ੍ਯਤਿ ਚ, ਸਰ੍ੱਵਾਣ੍ਯੇਤਾਨਿ ਜ੍ਞਾਤ੍ਵਾ ਰਜਨ੍ਯਾਂ ਭੋਜਨੇ ਸਮ੍ਪੂਰ੍ਣੇ ਸਤਿ, ");
INSERT INTO sanpun_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ਯਦਾ ਸ਼ੈਤਾਨ੍ ਤੰ ਪਰਹਸ੍ਤੇਸ਼਼ੁ ਸਮਰ੍ਪਯਿਤੁੰ ਸ਼ਿਮੋਨਃ ਪੁਤ੍ਰਸ੍ਯ ਈਸ਼਼੍ਕਾਰਿਯੋਤਿਯਸ੍ਯ ਯਿਹੂਦਾ ਅਨ੍ਤਃਕਰਣੇ ਕੁਪ੍ਰਵ੍ਰੁʼੱਤਿੰ ਸਮਾਰ੍ਪਯਤ੍, ");
INSERT INTO sanpun_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ਤਦਾ ਯੀਸ਼ੁ ਰ੍ਭੋਜਨਾਸਨਾਦ੍ ਉੱਥਾਯ ਗਾਤ੍ਰਵਸ੍ਤ੍ਰੰ ਮੋਚਯਿਤ੍ਵਾ ਗਾਤ੍ਰਮਾਰ੍ਜਨਵਸ੍ਤ੍ਰੰ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਤੇਨ ਸ੍ਵਕਟਿਮ੍ ਅਬਧ੍ਨਾਤ੍, ");
INSERT INTO sanpun_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ਪਸ਼੍ਚਾਦ੍ ਏਕਪਾਤ੍ਰੇ ਜਲਮ੍ ਅਭਿਸ਼਼ਿਚ੍ਯ ਸ਼ਿਸ਼਼੍ਯਾਣਾਂ ਪਾਦਾਨ੍ ਪ੍ਰਕ੍ਸ਼਼ਾਲ੍ਯ ਤੇਨ ਕਟਿਬੱਧਗਾਤ੍ਰਮਾਰ੍ਜਨਵਾਸਸਾ ਮਾਰ੍ਸ਼਼੍ਟੁੰ ਪ੍ਰਾਰਭਤ| ");
INSERT INTO sanpun_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ਤਤਃ ਸ਼ਿਮੋਨ੍ਪਿਤਰਸ੍ਯ ਸਮੀਪਮਾਗਤੇ ਸ ਉਕ੍ਤਵਾਨ੍ ਹੇ ਪ੍ਰਭੋ ਭਵਾਨ੍ ਕਿੰ ਮਮ ਪਾਦੌ ਪ੍ਰਕ੍ਸ਼਼ਾਲਯਿਸ਼਼੍ਯਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ਯੀਸ਼ੁਰੁਦਿਤਵਾਨ੍ ਅਹੰ ਯਤ੍ ਕਰੋਮਿ ਤਤ੍ ਸਮ੍ਪ੍ਰਤਿ ਨ ਜਾਨਾਸਿ ਕਿਨ੍ਤੁ ਪਸ਼੍ਚਾਜ੍ ਜ੍ਞਾਸ੍ਯਸਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","ਤਤਃ ਪਿਤਰਃ ਕਥਿਤਵਾਨ੍ ਭਵਾਨ੍ ਕਦਾਪਿ ਮਮ ਪਾਦੌ ਨ ਪ੍ਰਕ੍ਸ਼਼ਾਲਯਿਸ਼਼੍ਯਤਿ| ਯੀਸ਼ੁਰਕਥਯਦ੍ ਯਦਿ ਤ੍ਵਾਂ ਨ ਪ੍ਰਕ੍ਸ਼਼ਾਲਯੇ ਤਰ੍ਹਿ ਮਯਿ ਤਵ ਕੋਪ੍ਯੰਸ਼ੋ ਨਾਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ਤਦਾ ਸ਼ਿਮੋਨ੍ਪਿਤਰਃ ਕਥਿਤਵਾਨ੍ ਹੇ ਪ੍ਰਭੋ ਤਰ੍ਹਿ ਕੇਵਲਪਾਦੌ ਨ, ਮਮ ਹਸ੍ਤੌ ਸ਼ਿਰਸ਼੍ਚ ਪ੍ਰਕ੍ਸ਼਼ਾਲਯਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ਤਤੋ ਯੀਸ਼ੁਰਵਦਦ੍ ਯੋ ਜਨੋ ਧੌਤਸ੍ਤਸ੍ਯ ਸਰ੍ੱਵਾਙ੍ਗਪਰਿਸ਼਼੍ਕ੍ਰੁʼਤਤ੍ਵਾਤ੍ ਪਾਦੌ ਵਿਨਾਨ੍ਯਾਙ੍ਗਸ੍ਯ ਪ੍ਰਕ੍ਸ਼਼ਾਲਨਾਪੇਕ੍ਸ਼਼ਾ ਨਾਸ੍ਤਿ| ਯੂਯੰ ਪਰਿਸ਼਼੍ਕ੍ਰੁʼਤਾ ਇਤਿ ਸਤ੍ਯੰ ਕਿਨ੍ਤੁ ਨ ਸਰ੍ੱਵੇ, ");
INSERT INTO sanpun_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","ਯਤੋ ਯੋ ਜਨਸ੍ਤੰ ਪਰਕਰੇਸ਼਼ੁ ਸਮਰ੍ਪਯਿਸ਼਼੍ਯਤਿ ਤੰ ਸ ਜ੍ਞਾਤਵਾਨ; ਅਤਏਵ ਯੂਯੰ ਸਰ੍ੱਵੇ ਨ ਪਰਿਸ਼਼੍ਕ੍ਰੁʼਤਾ ਇਮਾਂ ਕਥਾਂ ਕਥਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ਇੱਥੰ ਯੀਸ਼ੁਸ੍ਤੇਸ਼਼ਾਂ ਪਾਦਾਨ੍ ਪ੍ਰਕ੍ਸ਼਼ਾਲ੍ਯ ਵਸ੍ਤ੍ਰੰ ਪਰਿਧਾਯਾਸਨੇ ਸਮੁਪਵਿਸ਼੍ਯ ਕਥਿਤਵਾਨ੍ ਅਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਪ੍ਰਤਿ ਕਿੰ ਕਰ੍ੰਮਾਕਾਰ੍ਸ਼਼ੰ ਜਾਨੀਥ? ");
INSERT INTO sanpun_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","ਯੂਯੰ ਮਾਂ ਗੁਰੁੰ ਪ੍ਰਭੁਞ੍ਚ ਵਦਥ ਤਤ੍ ਸਤ੍ਯਮੇਵ ਵਦਥ ਯਤੋਹੰ ਸਏਵ ਭਵਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ਯਦ੍ਯਹੰ ਪ੍ਰਭੁ ਰ੍ਗੁਰੁਸ਼੍ਚ ਸਨ੍ ਯੁਸ਼਼੍ਮਾਕੰ ਪਾਦਾਨ੍ ਪ੍ਰਕ੍ਸ਼਼ਾਲਿਤਵਾਨ੍ ਤਰ੍ਹਿ ਯੁਸ਼਼੍ਮਾਕਮਪਿ ਪਰਸ੍ਪਰੰ ਪਾਦਪ੍ਰਕ੍ਸ਼਼ਾਲਨਮ੍ ਉਚਿਤਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","ਅਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਪ੍ਰਤਿ ਯਥਾ ਵ੍ਯਵਾਹਰੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਤਥਾ ਵ੍ਯਵਹਰ੍ੱਤੁਮ੍ ਏਕੰ ਪਨ੍ਥਾਨੰ ਦਰ੍ਸ਼ਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","ਅਹੰ ਯੁਸ਼਼੍ਮਾਨਤਿਯਥਾਰ੍ਥੰ ਵਦਾਮਿ, ਪ੍ਰਭੋ ਰ੍ਦਾਸੋ ਨ ਮਹਾਨ੍ ਪ੍ਰੇਰਕਾੱਚ ਪ੍ਰੇਰਿਤੋ ਨ ਮਹਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ਇਮਾਂ ਕਥਾਂ ਵਿਦਿਤ੍ਵਾ ਯਦਿ ਤਦਨੁਸਾਰਤਃ ਕਰ੍ੰਮਾਣਿ ਕੁਰੁਥ ਤਰ੍ਹਿ ਯੂਯੰ ਧਨ੍ਯਾ ਭਵਿਸ਼਼੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","ਸਰ੍ੱਵੇਸ਼਼ੁ ਯੁਸ਼਼੍ਮਾਸੁ ਕਥਾਮਿਮਾਂ ਕਥਯਾਮਿ ਇਤਿ ਨ, ਯੇ ਮਮ ਮਨੋਨੀਤਾਸ੍ਤਾਨਹੰ ਜਾਨਾਮਿ, ਕਿਨ੍ਤੁ ਮਮ ਭਕ੍ਸ਼਼੍ਯਾਣਿ ਯੋ ਭੁਙ੍ਕ੍ਤੇ ਮਤ੍ਪ੍ਰਾਣਪ੍ਰਾਤਿਕੂਲ੍ਯਤਃ| ਉੱਥਾਪਯਤਿ ਪਾਦਸ੍ਯ ਮੂਲੰ ਸ ਏਸ਼਼ ਮਾਨਵਃ| ਯਦੇਤਦ੍ ਧਰ੍ੰਮਪੁਸ੍ਤਕਸ੍ਯ ਵਚਨੰ ਤਦਨੁਸਾਰੇਣਾਵਸ਼੍ਯੰ ਘਟਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","ਅਹੰ ਸ ਜਨ ਇਤ੍ਯਤ੍ਰ ਯਥਾ ਯੁਸ਼਼੍ਮਾਕੰ ਵਿਸ਼੍ਵਾਸੋ ਜਾਯਤੇ ਤਦਰ੍ਥੰ ਏਤਾਦ੍ਰੁʼਸ਼ਘਟਨਾਤ੍ ਪੂਰ੍ੱਵਮ੍ ਅਹਮਿਦਾਨੀਂ ਯੁਸ਼਼੍ਮਭ੍ਯਮਕਥਯਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","ਅਹੰ ਯੁਸ਼਼੍ਮਾਨਤੀਵ ਯਥਾਰ੍ਥੰ ਵਦਾਮਿ, ਮਯਾ ਪ੍ਰੇਰਿਤੰ ਜਨੰ ਯੋ ਗ੍ਰੁʼਹ੍ਲਾਤਿ ਸ ਮਾਮੇਵ ਗ੍ਰੁʼਹ੍ਲਾਤਿ ਯਸ਼੍ਚ ਮਾਂ ਗ੍ਰੁʼਹ੍ਲਾਤਿ ਸ ਮਤ੍ਪ੍ਰੇਰਕੰ ਗ੍ਰੁʼਹ੍ਲਾਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ਏਤਾਂ ਕਥਾਂ ਕਥਯਿਤ੍ਵਾ ਯੀਸ਼ੁ ਰ੍ਦੁਃਖੀ ਸਨ੍ ਪ੍ਰਮਾਣੰ ਦੱਤ੍ਵਾ ਕਥਿਤਵਾਨ੍ ਅਹੰ ਯੁਸ਼਼੍ਮਾਨਤਿਯਥਾਰ੍ਥੰ ਵਦਾਮਿ ਯੁਸ਼਼੍ਮਾਕਮ੍ ਏਕੋ ਜਨੋ ਮਾਂ ਪਰਕਰੇਸ਼਼ੁ ਸਮਰ੍ਪਯਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ਤਤਃ ਸ ਕਮੁੱਦਿਸ਼੍ਯ ਕਥਾਮੇਤਾਂ ਕਥਿਤਵਾਨ੍ ਇਤ੍ਯਤ੍ਰ ਸਨ੍ਦਿਗ੍ਧਾਃ ਸ਼ਿਸ਼਼੍ਯਾਃ ਪਰਸ੍ਪਰੰ ਮੁਖਮਾਲੋਕਯਿਤੁੰ ਪ੍ਰਾਰਭਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ਤਸ੍ਮਿਨ੍ ਸਮਯੇ ਯੀਸ਼ੁ ਰ੍ਯਸ੍ਮਿਨ੍ ਅਪ੍ਰੀਯਤ ਸ ਸ਼ਿਸ਼਼੍ਯਸ੍ਤਸ੍ਯ ਵਕ੍ਸ਼਼ਃਸ੍ਥਲਮ੍ ਅਵਾਲਮ੍ਬਤ| ");
INSERT INTO sanpun_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ਸ਼ਿਮੋਨ੍ਪਿਤਰਸ੍ਤੰ ਸਙ੍ਕੇਤੇਨਾਵਦਤ੍, ਅਯੰ ਕਮੁੱਦਿਸ਼੍ਯ ਕਥਾਮੇਤਾਮ੍ ਕਥਯਤੀਤਿ ਪ੍ਰੁʼੱਛ| ");
INSERT INTO sanpun_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ਤਦਾ ਸ ਯੀਸ਼ੋ ਰ੍ਵਕ੍ਸ਼਼ਃਸ੍ਥਲਮ੍ ਅਵਲਮ੍ਬ੍ਯ ਪ੍ਰੁʼਸ਼਼੍ਠਵਾਨ੍, ਹੇ ਪ੍ਰਭੋ ਸ ਜਨਃ ਕਃ? ");
INSERT INTO sanpun_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ਤਤੋ ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯਵਦਦ੍ ਏਕਖਣ੍ਡੰ ਪੂਪੰ ਮੱਜਯਿਤ੍ਵਾ ਯਸ੍ਮੈ ਦਾਸ੍ਯਾਮਿ ਸਏਵ ਸਃ; ਪਸ਼੍ਚਾਤ੍ ਪੂਪਖਣ੍ਡਮੇਕੰ ਮੱਜਯਿਤ੍ਵਾ ਸ਼ਿਮੋਨਃ ਪੁਤ੍ਰਾਯ ਈਸ਼਼੍ਕਰਿਯੋਤੀਯਾਯ ਯਿਹੂਦੈ ਦੱਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","ਤਸ੍ਮਿਨ੍ ਦੱਤੇ ਸਤਿ ਸ਼ੈਤਾਨ੍ ਤਮਾਸ਼੍ਰਯਤ੍; ਤਦਾ ਯੀਸ਼ੁਸ੍ਤਮ੍ ਅਵਦਤ੍ ਤ੍ਵੰ ਯਤ੍ ਕਰਿਸ਼਼੍ਯਸਿ ਤਤ੍ ਕ੍ਸ਼਼ਿਪ੍ਰੰ ਕੁਰੁ| ");
INSERT INTO sanpun_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","ਕਿਨ੍ਤੁ ਸ ਯੇਨਾਸ਼ਯੇਨ ਤਾਂ ਕਥਾਮਕਥਾਯਤ੍ ਤਮ੍ ਉਪਵਿਸ਼਼੍ਟਲੋਕਾਨਾਂ ਕੋਪਿ ਨਾਬੁਧ੍ਯਤ; ");
INSERT INTO sanpun_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ਕਿਨ੍ਤੁ ਯਿਹੂਦਾਃ ਸਮੀਪੇ ਮੁਦ੍ਰਾਸਮ੍ਪੁਟਕਸ੍ਥਿਤੇਃ ਕੇਚਿਦ੍ ਇੱਥਮ੍ ਅਬੁਧ੍ਯਨ੍ਤ ਪਾਰ੍ੱਵਣਾਸਾਦਨਾਰ੍ਥੰ ਕਿਮਪਿ ਦ੍ਰਵ੍ਯੰ ਕ੍ਰੇਤੁੰ ਵਾ ਦਰਿਦ੍ਰੇਭ੍ਯਃ ਕਿਞ੍ਚਿਦ੍ ਵਿਤਰਿਤੁੰ ਕਥਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ਤਦਾ ਪੂਪਖਣ੍ਡਗ੍ਰਹਣਾਤ੍ ਪਰੰ ਸ ਤੂਰ੍ਣੰ ਬਹਿਰਗੱਛਤ੍; ਰਾਤ੍ਰਿਸ਼੍ਚ ਸਮੁਪਸ੍ਯਿਤਾ| ");
INSERT INTO sanpun_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","ਯਿਹੂਦੇ ਬਹਿਰ੍ਗਤੇ ਯੀਸ਼ੁਰਕਥਯਦ੍ ਇਦਾਨੀਂ ਮਾਨਵਸੁਤਸ੍ਯ ਮਹਿਮਾ ਪ੍ਰਕਾਸ਼ਤੇ ਤੇਨੇਸ਼੍ਵਰਸ੍ਯਾਪਿ ਮਹਿਮਾ ਪ੍ਰਕਾਸ਼ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ਯਦਿ ਤੇਨੇਸ਼੍ਵਰਸ੍ਯ ਮਹਿਮਾ ਪ੍ਰਕਾਸ਼ਤੇ ਤਰ੍ਹੀਸ਼੍ਵਰੋਪਿ ਸ੍ਵੇਨ ਤਸ੍ਯ ਮਹਿਮਾਨੰ ਪ੍ਰਕਾਸ਼ਯਿਸ਼਼੍ਯਤਿ ਤੂਰ੍ਣਮੇਵ ਪ੍ਰਕਾਸ਼ਯਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ਹੇ ਵਤ੍ਸਾ ਅਹੰ ਯੁਸ਼਼੍ਮਾਭਿਃ ਸਾਰ੍ੱਧੰ ਕਿਞ੍ਚਿਤ੍ਕਾਲਮਾਤ੍ਰਮ੍ ਆਸੇ, ਤਤਃ ਪਰੰ ਮਾਂ ਮ੍ਰੁʼਗਯਿਸ਼਼੍ਯਧ੍ਵੇ ਕਿਨ੍ਤ੍ਵਹੰ ਯਤ੍ਸ੍ਥਾਨੰ ਯਾਮਿ ਤਤ੍ਸ੍ਥਾਨੰ ਯੂਯੰ ਗਨ੍ਤੁੰ ਨ ਸ਼ਕ੍ਸ਼਼੍ਯਥ, ਯਾਮਿਮਾਂ ਕਥਾਂ ਯਿਹੂਦੀਯੇਭ੍ਯਃ ਕਥਿਤਵਾਨ੍ ਤਥਾਧੁਨਾ ਯੁਸ਼਼੍ਮਭ੍ਯਮਪਿ ਕਥਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","ਯੂਯੰ ਪਰਸ੍ਪਰੰ ਪ੍ਰੀਯਧ੍ਵਮ੍ ਅਹੰ ਯੁਸ਼਼੍ਮਾਸੁ ਯਥਾ ਪ੍ਰੀਯੇ ਯੂਯਮਪਿ ਪਰਸ੍ਪਰਮ੍ ਤਥੈਵ ਪ੍ਰੀਯਧ੍ਵੰ, ਯੁਸ਼਼੍ਮਾਨ੍ ਇਮਾਂ ਨਵੀਨਾਮ੍ ਆਜ੍ਞਾਮ੍ ਆਦਿਸ਼ਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","ਤੇਨੈਵ ਯਦਿ ਪਰਸ੍ਪਰੰ ਪ੍ਰੀਯਧ੍ਵੇ ਤਰ੍ਹਿ ਲਕ੍ਸ਼਼ਣੇਨਾਨੇਨ ਯੂਯੰ ਮਮ ਸ਼ਿਸ਼਼੍ਯਾ ਇਤਿ ਸਰ੍ੱਵੇ ਜ੍ਞਾਤੁੰ ਸ਼ਕ੍ਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ਸ਼ਿਮੋਨਪਿਤਰਃ ਪ੍ਰੁʼਸ਼਼੍ਠਵਾਨ੍ ਹੇ ਪ੍ਰਭੋ ਭਵਾਨ੍ ਕੁਤ੍ਰ ਯਾਸ੍ਯਤਿ? ਤਤੋ ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯਵਦਤ੍, ਅਹੰ ਯਤ੍ਸ੍ਥਾਨੰ ਯਾਮਿ ਤਤ੍ਸ੍ਥਾਨੰ ਸਾਮ੍ਪ੍ਰਤੰ ਮਮ ਪਸ਼੍ਚਾਦ੍ ਗਨ੍ਤੁੰ ਨ ਸ਼ਕ੍ਨੋਸ਼਼ਿ ਕਿਨ੍ਤੁ ਪਸ਼੍ਚਾਦ੍ ਗਮਿਸ਼਼੍ਯਸਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","ਤਦਾ ਪਿਤਰਃ ਪ੍ਰਤ੍ਯੁਦਿਤਵਾਨ੍, ਹੇ ਪ੍ਰਭੋ ਸਾਮ੍ਪ੍ਰਤੰ ਕੁਤੋ ਹੇਤੋਸ੍ਤਵ ਪਸ਼੍ਚਾਦ੍ ਗਨ੍ਤੁੰ ਨ ਸ਼ਕ੍ਨੋਮਿ? ਤ੍ਵਦਰ੍ਥੰ ਪ੍ਰਾਣਾਨ੍ ਦਾਤੁੰ ਸ਼ਕ੍ਨੋਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ਤਤੋ ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯੁਕ੍ਤਵਾਨ੍ ਮੰਨਿਮਿੱਤੰ ਕਿੰ ਪ੍ਰਾਣਾਨ੍ ਦਾਤੁੰ ਸ਼ਕ੍ਨੋਸ਼਼ਿ? ਤ੍ਵਾਮਹੰ ਯਥਾਰ੍ਥੰ ਵਦਾਮਿ, ਕੁੱਕੁਟਰਵਣਾਤ੍ ਪੂਰ੍ੱਵੰ ਤ੍ਵੰ ਤ੍ਰਿ ਰ੍ਮਾਮ੍ ਅਪਹ੍ਨੋਸ਼਼੍ਯਸੇ| ");
INSERT INTO sanpun_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","ਮਨੋਦੁਃਖਿਨੋ ਮਾ ਭੂਤ; ਈਸ਼੍ਵਰੇ ਵਿਸ਼੍ਵਸਿਤ ਮਯਿ ਚ ਵਿਸ਼੍ਵਸਿਤ| ");
INSERT INTO sanpun_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","ਮਮ ਪਿਤੁ ਗ੍ਰੁʼਹੇ ਬਹੂਨਿ ਵਾਸਸ੍ਥਾਨਿ ਸਨ੍ਤਿ ਨੋ ਚੇਤ੍ ਪੂਰ੍ੱਵੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਅਜ੍ਞਾਪਯਿਸ਼਼੍ਯੰ ਯੁਸ਼਼੍ਮਦਰ੍ਥੰ ਸ੍ਥਾਨੰ ਸੱਜਯਿਤੁੰ ਗੱਛਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","ਯਦਿ ਗਤ੍ਵਾਹੰ ਯੁਸ਼਼੍ਮੰਨਿਮਿੱਤੰ ਸ੍ਥਾਨੰ ਸੱਜਯਾਮਿ ਤਰ੍ਹਿ ਪਨਰਾਗਤ੍ਯ ਯੁਸ਼਼੍ਮਾਨ੍ ਸ੍ਵਸਮੀਪੰ ਨੇਸ਼਼੍ਯਾਮਿ, ਤਤੋ ਯਤ੍ਰਾਹੰ ਤਿਸ਼਼੍ਠਾਮਿ ਤਤ੍ਰ ਯੂਯਮਪਿ ਸ੍ਥਾਸ੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ਅਹੰ ਯਤ੍ਸ੍ਥਾਨੰ ਬ੍ਰਜਾਮਿ ਤਤ੍ਸ੍ਥਾਨੰ ਯੂਯੰ ਜਾਨੀਥ ਤਸ੍ਯ ਪਨ੍ਥਾਨਮਪਿ ਜਾਨੀਥ| ");
INSERT INTO sanpun_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","ਤਦਾ ਥੋਮਾ ਅਵਦਤ੍, ਹੇ ਪ੍ਰਭੋ ਭਵਾਨ੍ ਕੁਤ੍ਰ ਯਾਤਿ ਤਦ੍ਵਯੰ ਨ ਜਾਨੀਮਃ, ਤਰ੍ਹਿ ਕਥੰ ਪਨ੍ਥਾਨੰ ਜ੍ਞਾਤੁੰ ਸ਼ਕ੍ਨੁਮਃ? ");
INSERT INTO sanpun_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","ਯੀਸ਼ੁਰਕਥਯਦ੍ ਅਹਮੇਵ ਸਤ੍ਯਜੀਵਨਰੂਪਪਥੋ ਮਯਾ ਨ ਗਨ੍ਤਾ ਕੋਪਿ ਪਿਤੁਃ ਸਮੀਪੰ ਗਨ੍ਤੁੰ ਨ ਸ਼ਕ੍ਨੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","ਯਦਿ ਮਾਮ੍ ਅਜ੍ਞਾਸ੍ਯਤ ਤਰ੍ਹਿ ਮਮ ਪਿਤਰਮਪ੍ਯਜ੍ਞਾਸ੍ਯਤ ਕਿਨ੍ਤ੍ਵਧੁਨਾਤਸ੍ਤੰ ਜਾਨੀਥ ਪਸ਼੍ਯਥ ਚ| ");
INSERT INTO sanpun_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ਤਦਾ ਫਿਲਿਪਃ ਕਥਿਤਵਾਨ੍, ਹੇ ਪ੍ਰਭੋ ਪਿਤਰੰ ਦਰ੍ਸ਼ਯ ਤਸ੍ਮਾਦਸ੍ਮਾਕੰ ਯਥੇਸ਼਼੍ਟੰ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ਤਤੋ ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯਾਵਾਦੀਤ੍, ਹੇ ਫਿਲਿਪ ਯੁਸ਼਼੍ਮਾਭਿਃ ਸਾਰ੍ੱਧਮ੍ ਏਤਾਵੱਦਿਨਾਨਿ ਸ੍ਥਿਤਮਪਿ ਮਾਂ ਕਿੰ ਨ ਪ੍ਰਤ੍ਯਭਿਜਾਨਾਸਿ? ਯੋ ਜਨੋ ਮਾਮ੍ ਅਪਸ਼੍ਯਤ੍ ਸ ਪਿਤਰਮਪ੍ਯਪਸ਼੍ਯਤ੍ ਤਰ੍ਹਿ ਪਿਤਰਮ੍ ਅਸ੍ਮਾਨ੍ ਦਰ੍ਸ਼ਯੇਤਿ ਕਥਾਂ ਕਥੰ ਕਥਯਸਿ? ");
INSERT INTO sanpun_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ਅਹੰ ਪਿਤਰਿ ਤਿਸ਼਼੍ਠਾਮਿ ਪਿਤਾ ਮਯਿ ਤਿਸ਼਼੍ਠਤੀਤਿ ਕਿੰ ਤ੍ਵੰ ਨ ਪ੍ਰਤ੍ਯਸ਼਼ਿ? ਅਹੰ ਯਦ੍ਵਾਕ੍ਯੰ ਵਦਾਮਿ ਤਤ੍ ਸ੍ਵਤੋ ਨ ਵਦਾਮਿ ਕਿਨ੍ਤੁ ਯਃ ਪਿਤਾ ਮਯਿ ਵਿਰਾਜਤੇ ਸ ਏਵ ਸਰ੍ੱਵਕਰ੍ੰਮਾਣਿ ਕਰਾਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ਅਤਏਵ ਪਿਤਰ੍ੱਯਹੰ ਤਿਸ਼਼੍ਠਾਮਿ ਪਿਤਾ ਚ ਮਯਿ ਤਿਸ਼਼੍ਠਤਿ ਮਮਾਸ੍ਯਾਂ ਕਥਾਯਾਂ ਪ੍ਰਤ੍ਯਯੰ ਕੁਰੁਤ, ਨੋ ਚੇਤ੍ ਕਰ੍ੰਮਹੇਤੋਃ ਪ੍ਰਤ੍ਯਯੰ ਕੁਰੁਤ| ");
INSERT INTO sanpun_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","ਅਹੰ ਯੁਸ਼਼੍ਮਾਨਤਿਯਥਾਰ੍ਥੰ ਵਦਾਮਿ, ਯੋ ਜਨੋ ਮਯਿ ਵਿਸ਼੍ਵਸਿਤਿ ਸੋਹਮਿਵ ਕਰ੍ੰਮਾਣਿ ਕਰਿਸ਼਼੍ਯਤਿ ਵਰੰ ਤਤੋਪਿ ਮਹਾਕਰ੍ੰਮਾਣਿ ਕਰਿਸ਼਼੍ਯਤਿ ਯਤੋ ਹੇਤੋਰਹੰ ਪਿਤੁਃ ਸਮੀਪੰ ਗੱਛਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","ਯਥਾ ਪੁਤ੍ਰੇਣ ਪਿਤੁ ਰ੍ਮਹਿਮਾ ਪ੍ਰਕਾਸ਼ਤੇ ਤਦਰ੍ਥੰ ਮਮ ਨਾਮ ਪ੍ਰੋਚ੍ਯ ਯਤ੍ ਪ੍ਰਾਰ੍ਥਯਿਸ਼਼੍ਯਧ੍ਵੇ ਤਤ੍ ਸਫਲੰ ਕਰਿਸ਼਼੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","ਯਦਿ ਮਮ ਨਾਮ੍ਨਾ ਯਤ੍ ਕਿਞ੍ਚਿਦ੍ ਯਾਚਧ੍ਵੇ ਤਰ੍ਹਿ ਤਦਹੰ ਸਾਧਯਿਸ਼਼੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","ਯਦਿ ਮਯਿ ਪ੍ਰੀਯਧ੍ਵੇ ਤਰ੍ਹਿ ਮਮਾਜ੍ਞਾਃ ਸਮਾਚਰਤ| ");
INSERT INTO sanpun_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ਤਤੋ ਮਯਾ ਪਿਤੁਃ ਸਮੀਪੇ ਪ੍ਰਾਰ੍ਥਿਤੇ ਪਿਤਾ ਨਿਰਨ੍ਤਰੰ ਯੁਸ਼਼੍ਮਾਭਿਃ ਸਾਰ੍ੱਧੰ ਸ੍ਥਾਤੁਮ੍ ਇਤਰਮੇਕੰ ਸਹਾਯਮ੍ ਅਰ੍ਥਾਤ੍ ਸਤ੍ਯਮਯਮ੍ ਆਤ੍ਮਾਨੰ ਯੁਸ਼਼੍ਮਾਕੰ ਨਿਕਟੰ ਪ੍ਰੇਸ਼਼ਯਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ਏਤੱਜਗਤੋ ਲੋਕਾਸ੍ਤੰ ਗ੍ਰਹੀਤੁੰ ਨ ਸ਼ਕ੍ਨੁਵਨ੍ਤਿ ਯਤਸ੍ਤੇ ਤੰ ਨਾਪਸ਼੍ਯਨ੍ ਨਾਜਨੰਸ਼੍ਚ ਕਿਨ੍ਤੁ ਯੂਯੰ ਜਾਨੀਥ ਯਤੋ ਹੇਤੋਃ ਸ ਯੁਸ਼਼੍ਮਾਕਮਨ੍ਤ ਰ੍ਨਿਵਸਤਿ ਯੁਸ਼਼੍ਮਾਕੰ ਮਧ੍ਯੇ ਸ੍ਥਾਸ੍ਯਤਿ ਚ| ");
INSERT INTO sanpun_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","ਅਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਅਨਾਥਾਨ੍ ਕ੍ਰੁʼਤ੍ਵਾ ਨ ਯਾਸ੍ਯਾਮਿ ਪੁਨਰਪਿ ਯੁਸ਼਼੍ਮਾਕੰ ਸਮੀਪਮ੍ ਆਗਮਿਸ਼਼੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ਕਿਯਤ੍ਕਾਲਰਤ੍ ਪਰਮ੍ ਅਸ੍ਯ ਜਗਤੋ ਲੋਕਾ ਮਾਂ ਪੁਨ ਰ੍ਨ ਦ੍ਰਕ੍ਸ਼਼੍ਯਨ੍ਤਿ ਕਿਨ੍ਤੁ ਯੂਯੰ ਦ੍ਰਕ੍ਸ਼਼੍ਯਥ;ਅਹੰ ਜੀਵਿਸ਼਼੍ਯਾਮਿ ਤਸ੍ਮਾਤ੍ ਕਾਰਣਾਦ੍ ਯੂਯਮਪਿ ਜੀਵਿਸ਼਼੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","ਪਿਤਰ੍ੱਯਹਮਸ੍ਮਿ ਮਯਿ ਚ ਯੂਯੰ ਸ੍ਥ, ਤਥਾਹੰ ਯੁਸ਼਼੍ਮਾਸ੍ਵਸ੍ਮਿ ਤਦਪਿ ਤਦਾ ਜ੍ਞਾਸ੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","ਯੋ ਜਨੋ ਮਮਾਜ੍ਞਾ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਤਾ ਆਚਰਤਿ ਸਏਵ ਮਯਿ ਪ੍ਰੀਯਤੇ; ਯੋ ਜਨਸ਼੍ਚ ਮਯਿ ਪ੍ਰੀਯਤੇ ਸਏਵ ਮਮ ਪਿਤੁਃ ਪ੍ਰਿਯਪਾਤ੍ਰੰ ਭਵਿਸ਼਼੍ਯਤਿ, ਤਥਾਹਮਪਿ ਤਸ੍ਮਿਨ੍ ਪ੍ਰੀਤ੍ਵਾ ਤਸ੍ਮੈ ਸ੍ਵੰ ਪ੍ਰਕਾਸ਼ਯਿਸ਼਼੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","ਤਦਾ ਈਸ਼਼੍ਕਰਿਯੋਤੀਯਾਦ੍ ਅਨ੍ਯੋ ਯਿਹੂਦਾਸ੍ਤਮਵਦਤ੍, ਹੇ ਪ੍ਰਭੋ ਭਵਾਨ੍ ਜਗਤੋ ਲੋਕਾਨਾਂ ਸੰਨਿਧੌ ਪ੍ਰਕਾਸ਼ਿਤੋ ਨ ਭੂਤ੍ਵਾਸ੍ਮਾਕੰ ਸੰਨਿਧੌ ਕੁਤਃ ਪ੍ਰਕਾਸ਼ਿਤੋ ਭਵਿਸ਼਼੍ਯਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ਤਤੋ ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯੁਦਿਤਵਾਨ੍, ਯੋ ਜਨੋ ਮਯਿ ਪ੍ਰੀਯਤੇ ਸ ਮਮਾਜ੍ਞਾ ਅਪਿ ਗ੍ਰੁʼਹ੍ਲਾਤਿ, ਤੇਨ ਮਮ ਪਿਤਾਪਿ ਤਸ੍ਮਿਨ੍ ਪ੍ਰੇਸ਼਼੍ਯਤੇ, ਆਵਾਞ੍ਚ ਤੰਨਿਕਟਮਾਗਤ੍ਯ ਤੇਨ ਸਹ ਨਿਵਤ੍ਸ੍ਯਾਵਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ਯੋ ਜਨੋ ਮਯਿ ਨ ਪ੍ਰੀਯਤੇ ਸ ਮਮ ਕਥਾ ਅਪਿ ਨ ਗ੍ਰੁʼਹ੍ਲਾਤਿ ਪੁਨਸ਼੍ਚ ਯਾਮਿਮਾਂ ਕਥਾਂ ਯੂਯੰ ਸ਼੍ਰੁʼਣੁਥ ਸਾ ਕਥਾ ਕੇਵਲਸ੍ਯ ਮਮ ਨ ਕਿਨ੍ਤੁ ਮਮ ਪ੍ਰੇਰਕੋ ਯਃ ਪਿਤਾ ਤਸ੍ਯਾਪਿ ਕਥਾ| ");
INSERT INTO sanpun_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","ਇਦਾਨੀਂ ਯੁਸ਼਼੍ਮਾਕੰ ਨਿਕਟੇ ਵਿਦ੍ਯਮਾਨੋਹਮ੍ ਏਤਾਃ ਸਕਲਾਃ ਕਥਾਃ ਕਥਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ਕਿਨ੍ਤ੍ਵਿਤਃ ਪਰੰ ਪਿਤ੍ਰਾ ਯਃ ਸਹਾਯੋ(ਅ)ਰ੍ਥਾਤ੍ ਪਵਿਤ੍ਰ ਆਤ੍ਮਾ ਮਮ ਨਾਮ੍ਨਿ ਪ੍ਰੇਰਯਿਸ਼਼੍ਯਤਿ ਸ ਸਰ੍ੱਵੰ ਸ਼ਿਕ੍ਸ਼਼ਯਿਤ੍ਵਾ ਮਯੋਕ੍ਤਾਃ ਸਮਸ੍ਤਾਃ ਕਥਾ ਯੁਸ਼਼੍ਮਾਨ੍ ਸ੍ਮਾਰਯਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","ਅਹੰ ਯੁਸ਼਼੍ਮਾਕੰ ਨਿਕਟੇ ਸ਼ਾਨ੍ਤਿੰ ਸ੍ਥਾਪਯਿਤ੍ਵਾ ਯਾਮਿ, ਨਿਜਾਂ ਸ਼ਾਨ੍ਤਿੰ ਯੁਸ਼਼੍ਮਭ੍ਯੰ ਦਦਾਮਿ, ਜਗਤੋ ਲੋਕਾ ਯਥਾ ਦਦਾਤਿ ਤਥਾਹੰ ਨ ਦਦਾਮਿ; ਯੁਸ਼਼੍ਮਾਕਮ੍ ਅਨ੍ਤਃਕਰਣਾਨਿ ਦੁਃਖਿਤਾਨਿ ਭੀਤਾਨਿ ਚ ਨ ਭਵਨ੍ਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","ਅਹੰ ਗਤ੍ਵਾ ਪੁਨਰਪਿ ਯੁਸ਼਼੍ਮਾਕੰ ਸਮੀਪਮ੍ ਆਗਮਿਸ਼਼੍ਯਾਮਿ ਮਯੋਕ੍ਤੰ ਵਾਕ੍ਯਮਿਦੰ ਯੂਯਮ੍ ਅਸ਼੍ਰੌਸ਼਼੍ਟ; ਯਦਿ ਮੱਯਪ੍ਰੇਸ਼਼੍ਯਧ੍ਵੰ ਤਰ੍ਹ੍ਯਹੰ ਪਿਤੁਃ ਸਮੀਪੰ ਗੱਛਾਮਿ ਮਮਾਸ੍ਯਾਂ ਕਥਾਯਾਂ ਯੂਯਮ੍ ਅਹ੍ਲਾਦਿਸ਼਼੍ਯਧ੍ਵੰ ਯਤੋ ਮਮ ਪਿਤਾ ਮੱਤੋਪਿ ਮਹਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","ਤਸ੍ਯਾ ਘਟਨਾਯਾਃ ਸਮਯੇ ਯਥਾ ਯੁਸ਼਼੍ਮਾਕੰ ਸ਼੍ਰੱਧਾ ਜਾਯਤੇ ਤਦਰ੍ਥਮ੍ ਅਹੰ ਤਸ੍ਯਾ ਘਟਨਾਯਾਃ ਪੂਰ੍ੱਵਮ੍ ਇਦਾਨੀਂ ਯੁਸ਼਼੍ਮਾਨ੍ ਏਤਾਂ ਵਾਰ੍ੱਤਾਂ ਵਦਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ਇਤਃ ਪਰੰ ਯੁਸ਼਼੍ਮਾਭਿਃ ਸਹ ਮਮ ਬਹਵ ਆਲਾਪਾ ਨ ਭਵਿਸ਼਼੍ਯਨ੍ਤਿ ਯਤਃ ਕਾਰਣਾਦ੍ ਏਤਸ੍ਯ ਜਗਤਃ ਪਤਿਰਾਗੱਛਤਿ ਕਿਨ੍ਤੁ ਮਯਾ ਸਹ ਤਸ੍ਯ ਕੋਪਿ ਸਮ੍ਬਨ੍ਧੋ ਨਾਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ਅਹੰ ਪਿਤਰਿ ਪ੍ਰੇਮ ਕਰੋਮਿ ਤਥਾ ਪਿਤੁ ਰ੍ਵਿਧਿਵਤ੍ ਕਰ੍ੰਮਾਣਿ ਕਰੋਮੀਤਿ ਯੇਨ ਜਗਤੋ ਲੋਕਾ ਜਾਨਨ੍ਤਿ ਤਦਰ੍ਥਮ੍ ਉੱਤਿਸ਼਼੍ਠਤ ਵਯੰ ਸ੍ਥਾਨਾਦਸ੍ਮਾਦ੍ ਗੱਛਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","ਅਹੰ ਸਤ੍ਯਦ੍ਰਾਕ੍ਸ਼਼ਾਲਤਾਸ੍ਵਰੂਪੋ ਮਮ ਪਿਤਾ ਤੂਦ੍ਯਾਨਪਰਿਚਾਰਕਸ੍ਵਰੂਪਞ੍ਚ| ");
INSERT INTO sanpun_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","ਮਮ ਯਾਸੁ ਸ਼ਾਖਾਸੁ ਫਲਾਨਿ ਨ ਭਵਨ੍ਤਿ ਤਾਃ ਸ ਛਿਨੱਤਿ ਤਥਾ ਫਲਵਤ੍ਯਃ ਸ਼ਾਖਾ ਯਥਾਧਿਕਫਲਾਨਿ ਫਲਨ੍ਤਿ ਤਦਰ੍ਥੰ ਤਾਃ ਪਰਿਸ਼਼੍ਕਰੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ਇਦਾਨੀਂ ਮਯੋਕ੍ਤੋਪਦੇਸ਼ੇਨ ਯੂਯੰ ਪਰਿਸ਼਼੍ਕ੍ਰੁʼਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ਅਤਃ ਕਾਰਣਾਤ੍ ਮਯਿ ਤਿਸ਼਼੍ਠਤ ਤੇਨਾਹਮਪਿ ਯੁਸ਼਼੍ਮਾਸੁ ਤਿਸ਼਼੍ਠਾਮਿ, ਯਤੋ ਹੇਤੋ ਰ੍ਦ੍ਰਾਕ੍ਸ਼਼ਾਲਤਾਯਾਮ੍ ਅਸੰਲਗ੍ਨਾ ਸ਼ਾਖਾ ਯਥਾ ਫਲਵਤੀ ਭਵਿਤੁੰ ਨ ਸ਼ਕ੍ਨੋਤਿ ਤਥਾ ਯੂਯਮਪਿ ਮੱਯਤਿਸ਼਼੍ਠਨ੍ਤਃ ਫਲਵਨ੍ਤੋ ਭਵਿਤੁੰ ਨ ਸ਼ਕ੍ਨੁਥ| ");
INSERT INTO sanpun_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","ਅਹੰ ਦ੍ਰਾਕ੍ਸ਼਼ਾਲਤਾਸ੍ਵਰੂਪੋ ਯੂਯਞ੍ਚ ਸ਼ਾਖਾਸ੍ਵਰੂਪੋਃ; ਯੋ ਜਨੋ ਮਯਿ ਤਿਸ਼਼੍ਠਤਿ ਯਤ੍ਰ ਚਾਹੰ ਤਿਸ਼਼੍ਠਾਮਿ, ਸ ਪ੍ਰਚੂਰਫਲੈਃ ਫਲਵਾਨ੍ ਭਵਤਿ, ਕਿਨ੍ਤੁ ਮਾਂ ਵਿਨਾ ਯੂਯੰ ਕਿਮਪਿ ਕਰ੍ੱਤੁੰ ਨ ਸ਼ਕ੍ਨੁਥ| ");
INSERT INTO sanpun_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ਯਃ ਕਸ਼੍ਚਿਨ੍ ਮਯਿ ਨ ਤਿਸ਼਼੍ਠਤਿ ਸ ਸ਼ੁਸ਼਼੍ਕਸ਼ਾਖੇਵ ਬਹਿ ਰ੍ਨਿਕ੍ਸ਼਼ਿਪ੍ਯਤੇ ਲੋਕਾਸ਼੍ਚ ਤਾ ਆਹ੍ਰੁʼਤ੍ਯ ਵਹ੍ਨੌ ਨਿਕ੍ਸ਼਼ਿਪ੍ਯ ਦਾਹਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","ਯਦਿ ਯੂਯੰ ਮਯਿ ਤਿਸ਼਼੍ਠਥ ਮਮ ਕਥਾ ਚ ਯੁਸ਼਼੍ਮਾਸੁ ਤਿਸ਼਼੍ਠਤਿ ਤਰ੍ਹਿ ਯਦ੍ ਵਾਞ੍ਛਿਤ੍ਵਾ ਯਾਚਿਸ਼਼੍ਯਧ੍ਵੇ ਯੁਸ਼਼੍ਮਾਕੰ ਤਦੇਵ ਸਫਲੰ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","ਯਦਿ ਯੂਯੰ ਪ੍ਰਚੂਰਫਲਵਨ੍ਤੋ ਭਵਥ ਤਰ੍ਹਿ ਤਦ੍ਵਾਰਾ ਮਮ ਪਿਤੁ ਰ੍ਮਹਿਮਾ ਪ੍ਰਕਾਸ਼ਿਸ਼਼੍ਯਤੇ ਤਥਾ ਯੂਯੰ ਮਮ ਸ਼ਿਸ਼਼੍ਯਾ ਇਤਿ ਪਰਿਕ੍ਸ਼਼ਾਯਿਸ਼਼੍ਯਧ੍ਵੇ| ");
INSERT INTO sanpun_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","ਪਿਤਾ ਯਥਾ ਮਯਿ ਪ੍ਰੀਤਵਾਨ੍ ਅਹਮਪਿ ਯੁਸ਼਼੍ਮਾਸੁ ਤਥਾ ਪ੍ਰੀਤਵਾਨ੍ ਅਤੋ ਹੇਤੋ ਰ੍ਯੂਯੰ ਨਿਰਨ੍ਤਰੰ ਮਮ ਪ੍ਰੇਮਪਾਤ੍ਰਾਣਿ ਭੂਤ੍ਵਾ ਤਿਸ਼਼੍ਠਤ| ");
INSERT INTO sanpun_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ਅਹੰ ਯਥਾ ਪਿਤੁਰਾਜ੍ਞਾ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਤਸ੍ਯ ਪ੍ਰੇਮਭਾਜਨੰ ਤਿਸ਼਼੍ਠਾਮਿ ਤਥੈਵ ਯੂਯਮਪਿ ਯਦਿ ਮਮਾਜ੍ਞਾ ਗੁਹ੍ਲੀਥ ਤਰ੍ਹਿ ਮਮ ਪ੍ਰੇਮਭਾਜਨਾਨਿ ਸ੍ਥਾਸ੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","ਯੁਸ਼਼੍ਮੰਨਿਮਿੱਤੰ ਮਮ ਯ ਆਹ੍ਲਾਦਃ ਸ ਯਥਾ ਚਿਰੰ ਤਿਸ਼਼੍ਠਤਿ ਯੁਸ਼਼੍ਮਾਕਮ੍ ਆਨਨ੍ਦਸ਼੍ਚ ਯਥਾ ਪੂਰ੍ੱਯਤੇ ਤਦਰ੍ਥੰ ਯੁਸ਼਼੍ਮਭ੍ਯਮ੍ ਏਤਾਃ ਕਥਾ ਅਤ੍ਰਕਥਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","ਅਹੰ ਯੁਸ਼਼੍ਮਾਸੁ ਯਥਾ ਪ੍ਰੀਯੇ ਯੂਯਮਪਿ ਪਰਸ੍ਪਰੰ ਤਥਾ ਪ੍ਰੀਯਧ੍ਵਮ੍ ਏਸ਼਼ਾ ਮਮਾਜ੍ਞਾ| ");
INSERT INTO sanpun_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","ਮਿਤ੍ਰਾਣਾਂ ਕਾਰਣਾਤ੍ ਸ੍ਵਪ੍ਰਾਣਦਾਨਪਰ੍ੱਯਨ੍ਤੰ ਯਤ੍ ਪ੍ਰੇਮ ਤਸ੍ਮਾਨ੍ ਮਹਾਪ੍ਰੇਮ ਕਸ੍ਯਾਪਿ ਨਾਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","ਅਹੰ ਯਦ੍ਯਦ੍ ਆਦਿਸ਼ਾਮਿ ਤੱਤਦੇਵ ਯਦਿ ਯੂਯਮ੍ ਆਚਰਤ ਤਰ੍ਹਿ ਯੂਯਮੇਵ ਮਮ ਮਿਤ੍ਰਾਣਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","ਅਦ੍ਯਾਰਭ੍ਯ ਯੁਸ਼਼੍ਮਾਨ੍ ਦਾਸਾਨ੍ ਨ ਵਦਿਸ਼਼੍ਯਾਮਿ ਯਤ੍ ਪ੍ਰਭੁ ਰ੍ਯਤ੍ ਕਰੋਤਿ ਦਾਸਸ੍ਤਦ੍ ਨ ਜਾਨਾਤਿ; ਕਿਨ੍ਤੁ ਪਿਤੁਃ ਸਮੀਪੇ ਯਦ੍ਯਦ੍ ਅਸ਼੍ਰੁʼਣਵੰ ਤਤ੍ ਸਰ੍ੱਵੰ ਯੂਸ਼਼੍ਮਾਨ੍ ਅਜ੍ਞਾਪਯਮ੍ ਤਤ੍ਕਾਰਣਾਦ੍ ਯੁਸ਼਼੍ਮਾਨ੍ ਮਿਤ੍ਰਾਣਿ ਪ੍ਰੋਕ੍ਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","ਯੂਯੰ ਮਾਂ ਰੋਚਿਤਵਨ੍ਤ ਇਤਿ ਨ, ਕਿਨ੍ਤ੍ਵਹਮੇਵ ਯੁਸ਼਼੍ਮਾਨ੍ ਰੋਚਿਤਵਾਨ੍ ਯੂਯੰ ਗਤ੍ਵਾ ਯਥਾ ਫਲਾਨ੍ਯੁਤ੍ਪਾਦਯਥ ਤਾਨਿ ਫਲਾਨਿ ਚਾਕ੍ਸ਼਼ਯਾਣਿ ਭਵਨ੍ਤਿ, ਤਦਰ੍ਥੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਨ੍ਯਜੁਨਜੰ ਤਸ੍ਮਾਨ੍ ਮਮ ਨਾਮ ਪ੍ਰੋਚ੍ਯ ਪਿਤਰੰ ਯਤ੍ ਕਿਞ੍ਚਿਦ੍ ਯਾਚਿਸ਼਼੍ਯਧ੍ਵੇ ਤਦੇਵ ਸ ਯੁਸ਼਼੍ਮਭ੍ਯੰ ਦਾਸ੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","ਯੂਯੰ ਪਰਸ੍ਪਰੰ ਪ੍ਰੀਯਧ੍ਵਮ੍ ਅਹਮ੍ ਇਤ੍ਯਾਜ੍ਞਾਪਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","ਜਗਤੋ ਲੋਕੈ ਰ੍ਯੁਸ਼਼੍ਮਾਸੁ ਰੁʼਤੀਯਿਤੇਸ਼਼ੁ ਤੇ ਪੂਰ੍ੱਵੰ ਮਾਮੇਵਾਰ੍ੱਤੀਯਨ੍ਤ ਇਤਿ ਯੂਯੰ ਜਾਨੀਥ| ");
INSERT INTO sanpun_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","ਯਦਿ ਯੂਯੰ ਜਗਤੋ ਲੋਕਾ ਅਭਵਿਸ਼਼੍ਯਤ ਤਰ੍ਹਿ ਜਗਤੋ ਲੋਕਾ ਯੁਸ਼਼੍ਮਾਨ੍ ਆਤ੍ਮੀਯਾਨ੍ ਬੁੱਧ੍ਵਾਪ੍ਰੇਸ਼਼੍ਯਨ੍ਤ; ਕਿਨ੍ਤੁ ਯੂਯੰ ਜਗਤੋ ਲੋਕਾ ਨ ਭਵਥ, ਅਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਅਸ੍ਮਾੱਜਗਤੋ(ਅ)ਰੋਚਯਮ੍ ਏਤਸ੍ਮਾਤ੍ ਕਾਰਣਾੱਜਗਤੋ ਲੋਕਾ ਯੁਸ਼਼੍ਮਾਨ੍ ਰੁʼਤੀਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","ਦਾਸਃ ਪ੍ਰਭੋ ਰ੍ਮਹਾਨ੍ ਨ ਭਵਤਿ ਮਮੈਤਤ੍ ਪੂਰ੍ੱਵੀਯੰ ਵਾਕ੍ਯੰ ਸ੍ਮਰਤ; ਤੇ ਯਦਿ ਮਾਮੇਵਾਤਾਡਯਨ੍ ਤਰ੍ਹਿ ਯੁਸ਼਼੍ਮਾਨਪਿ ਤਾਡਯਿਸ਼਼੍ਯਨ੍ਤਿ, ਯਦਿ ਮਮ ਵਾਕ੍ਯੰ ਗ੍ਰੁʼਹ੍ਲਨ੍ਤਿ ਤਰ੍ਹਿ ਯੁਸ਼਼੍ਮਾਕਮਪਿ ਵਾਕ੍ਯੰ ਗ੍ਰਹੀਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","ਕਿਨ੍ਤੁ ਤੇ ਮਮ ਨਾਮਕਾਰਣਾਦ੍ ਯੁਸ਼਼੍ਮਾਨ੍ ਪ੍ਰਤਿ ਤਾਦ੍ਰੁʼਸ਼ੰ ਵ੍ਯਵਹਰਿਸ਼਼੍ਯਨ੍ਤਿ ਯਤੋ ਯੋ ਮਾਂ ਪ੍ਰੇਰਿਤਵਾਨ੍ ਤੰ ਤੇ ਨ ਜਾਨਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","ਤੇਸ਼਼ਾਂ ਸੰਨਿਧਿਮ੍ ਆਗਤ੍ਯ ਯਦ੍ਯਹੰ ਨਾਕਥਯਿਸ਼਼੍ਯੰ ਤਰ੍ਹਿ ਤੇਸ਼਼ਾਂ ਪਾਪੰ ਨਾਭਵਿਸ਼਼੍ਯਤ੍ ਕਿਨ੍ਤ੍ਵਧੁਨਾ ਤੇਸ਼਼ਾਂ ਪਾਪਮਾੱਛਾਦਯਿਤੁਮ੍ ਉਪਾਯੋ ਨਾਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","ਯੋ ਜਨੋ ਮਾਮ੍ ਰੁʼਤੀਯਤੇ ਸ ਮਮ ਪਿਤਰਮਪਿ ਰੁʼਤੀਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","ਯਾਦ੍ਰੁʼਸ਼ਾਨਿ ਕਰ੍ੰਮਾਣਿ ਕੇਨਾਪਿ ਕਦਾਪਿ ਨਾਕ੍ਰਿਯਨ੍ਤ ਤਾਦ੍ਰੁʼਸ਼ਾਨਿ ਕਰ੍ੰਮਾਣਿ ਯਦਿ ਤੇਸ਼਼ਾਂ ਸਾਕ੍ਸ਼਼ਾਦ੍ ਅਹੰ ਨਾਕਰਿਸ਼਼੍ਯੰ ਤਰ੍ਹਿ ਤੇਸ਼਼ਾਂ ਪਾਪੰ ਨਾਭਵਿਸ਼਼੍ਯਤ੍ ਕਿਨ੍ਤ੍ਵਧੁਨਾ ਤੇ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾਪਿ ਮਾਂ ਮਮ ਪਿਤਰਞ੍ਚਾਰ੍ੱਤੀਯਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","ਤਸ੍ਮਾਤ੍ ਤੇ(ਅ)ਕਾਰਣੰ ਮਾਮ੍ ਰੁʼਤੀਯਨ੍ਤੇ ਯਦੇਤਦ੍ ਵਚਨੰ ਤੇਸ਼਼ਾਂ ਸ਼ਾਸ੍ਤ੍ਰੇ ਲਿਖਿਤਮਾਸ੍ਤੇ ਤਤ੍ ਸਫਲਮ੍ ਅਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","ਕਿਨ੍ਤੁ ਪਿਤੁ ਰ੍ਨਿਰ੍ਗਤੰ ਯੰ ਸਹਾਯਮਰ੍ਥਾਤ੍ ਸਤ੍ਯਮਯਮ੍ ਆਤ੍ਮਾਨੰ ਪਿਤੁਃ ਸਮੀਪਾਦ੍ ਯੁਸ਼਼੍ਮਾਕੰ ਸਮੀਪੇ ਪ੍ਰੇਸ਼਼ਯਿਸ਼਼੍ਯਾਮਿ ਸ ਆਗਤ੍ਯ ਮਯਿ ਪ੍ਰਮਾਣੰ ਦਾਸ੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ਯੂਯੰ ਪ੍ਰਥਮਮਾਰਭ੍ਯ ਮਯਾ ਸਾਰ੍ੱਧੰ ਤਿਸ਼਼੍ਠਥ ਤਸ੍ਮਾੱਧੇਤੋ ਰ੍ਯੂਯਮਪਿ ਪ੍ਰਮਾਣੰ ਦਾਸ੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","ਯੁਸ਼਼੍ਮਾਕੰ ਯਥਾ ਵਾਧਾ ਨ ਜਾਯਤੇ ਤਦਰ੍ਥੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਏਤਾਨਿ ਸਰ੍ੱਵਵਾਕ੍ਯਾਨਿ ਵ੍ਯਾਹਰੰ| ");
INSERT INTO sanpun_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ਲੋਕਾ ਯੁਸ਼਼੍ਮਾਨ੍ ਭਜਨਗ੍ਰੁʼਹੇਭ੍ਯੋ ਦੂਰੀਕਰਿਸ਼਼੍ਯਨ੍ਤਿ ਤਥਾ ਯਸ੍ਮਿਨ੍ ਸਮਯੇ ਯੁਸ਼਼੍ਮਾਨ੍ ਹਤ੍ਵਾ ਈਸ਼੍ਵਰਸ੍ਯ ਤੁਸ਼਼੍ਟਿ ਜਨਕੰ ਕਰ੍ੰਮਾਕੁਰ੍ੰਮ ਇਤਿ ਮੰਸ੍ਯਨ੍ਤੇ ਸ ਸਮਯ ਆਗੱਛਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","ਤੇ ਪਿਤਰੰ ਮਾਞ੍ਚ ਨ ਜਾਨਨ੍ਤਿ, ਤਸ੍ਮਾਦ੍ ਯੁਸ਼਼੍ਮਾਨ੍ ਪ੍ਰਤੀਦ੍ਰੁʼਸ਼ਮ੍ ਆਚਰਿਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","ਅਤੋ ਹੇਤਾਃ ਸਮਯੇ ਸਮੁਪਸ੍ਥਿਤੇ ਯਥਾ ਮਮ ਕਥਾ ਯੁਸ਼਼੍ਮਾਕੰ ਮਨਃਸੁਃ ਸਮੁਪਤਿਸ਼਼੍ਠਤਿ ਤਦਰ੍ਥੰ ਯੁਸ਼਼੍ਮਾਭ੍ਯਮ੍ ਏਤਾਂ ਕਥਾਂ ਕਥਯਾਮਿ ਯੁਸ਼਼੍ਮਾਭਿਃ ਸਾਰ੍ੱਧਮ੍ ਅਹੰ ਤਿਸ਼਼੍ਠਨ੍ ਪ੍ਰਥਮੰ ਤਾਂ ਯੁਸ਼਼੍ਮਭ੍ਯੰ ਨਾਕਥਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","ਸਾਮ੍ਪ੍ਰਤੰ ਸ੍ਵਸ੍ਯ ਪ੍ਰੇਰਯਿਤੁਃ ਸਮੀਪੰ ਗੱਛਾਮਿ ਤਥਾਪਿ ਤ੍ਵੰ ੱਕ ਗੱਛਸਿ ਕਥਾਮੇਤਾਂ ਯੁਸ਼਼੍ਮਾਕੰ ਕੋਪਿ ਮਾਂ ਨ ਪ੍ਰੁʼੱਛਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","ਕਿਨ੍ਤੁ ਮਯੋਕ੍ਤਾਭਿਰਾਭਿਃ ਕਥਾਭਿ ਰ੍ਯੂਸ਼਼੍ਮਾਕਮ੍ ਅਨ੍ਤਃਕਰਣਾਨਿ ਦੁਃਖੇਨ ਪੂਰ੍ਣਾਨ੍ਯਭਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","ਤਥਾਪ੍ਯਹੰ ਯਥਾਰ੍ਥੰ ਕਥਯਾਮਿ ਮਮ ਗਮਨੰ ਯੁਸ਼਼੍ਮਾਕੰ ਹਿਤਾਰ੍ਥਮੇਵ, ਯਤੋ ਹੇਤੋ ਰ੍ਗਮਨੇ ਨ ਕ੍ਰੁʼਤੇ ਸਹਾਯੋ ਯੁਸ਼਼੍ਮਾਕੰ ਸਮੀਪੰ ਨਾਗਮਿਸ਼਼੍ਯਤਿ ਕਿਨ੍ਤੁ ਯਦਿ ਗੱਛਾਮਿ ਤਰ੍ਹਿ ਯੁਸ਼਼੍ਮਾਕੰ ਸਮੀਪੇ ਤੰ ਪ੍ਰੇਸ਼਼ਯਿਸ਼਼੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","ਤਤਃ ਸ ਆਗਤ੍ਯ ਪਾਪਪੁਣ੍ਯਦਣ੍ਡੇਸ਼਼ੁ ਜਗਤੋ ਲੋਕਾਨਾਂ ਪ੍ਰਬੋਧੰ ਜਨਯਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ਤੇ ਮਯਿ ਨ ਵਿਸ਼੍ਵਸਨ੍ਤਿ ਤਸ੍ਮਾੱਧੇਤੋਃ ਪਾਪਪ੍ਰਬੋਧੰ ਜਨਯਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ਯੁਸ਼਼੍ਮਾਕਮ੍ ਅਦ੍ਰੁʼਸ਼੍ਯਃ ਸੰਨਹੰ ਪਿਤੁਃ ਸਮੀਪੰ ਗੱਛਾਮਿ ਤਸ੍ਮਾਦ੍ ਪੁਣ੍ਯੇ ਪ੍ਰਬੋਧੰ ਜਨਯਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ਏਤੱਜਗਤੋ(ਅ)ਧਿਪਤਿ ਰ੍ਦਣ੍ਡਾਜ੍ਞਾਂ ਪ੍ਰਾਪ੍ਨੋਤਿ ਤਸ੍ਮਾਦ੍ ਦਣ੍ਡੇ ਪ੍ਰਬੋਧੰ ਜਨਯਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","ਯੁਸ਼਼੍ਮਭ੍ਯੰ ਕਥਯਿਤੁੰ ਮਮਾਨੇਕਾਃ ਕਥਾ ਆਸਤੇ, ਤਾਃ ਕਥਾ ਇਦਾਨੀਂ ਯੂਯੰ ਸੋਢੁੰ ਨ ਸ਼ਕ੍ਨੁਥ; ");
INSERT INTO sanpun_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","ਕਿਨ੍ਤੁ ਸਤ੍ਯਮਯ ਆਤ੍ਮਾ ਯਦਾ ਸਮਾਗਮਿਸ਼਼੍ਯਤਿ ਤਦਾ ਸਰ੍ੱਵੰ ਸਤ੍ਯੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਨੇਸ਼਼੍ਯਤਿ, ਸ ਸ੍ਵਤਃ ਕਿਮਪਿ ਨ ਵਦਿਸ਼਼੍ਯਤਿ ਕਿਨ੍ਤੁ ਯੱਛ੍ਰੋਸ਼਼੍ਯਤਿ ਤਦੇਵ ਕਥਯਿਤ੍ਵਾ ਭਾਵਿਕਾਰ੍ੱਯੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਜ੍ਞਾਪਯਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","ਮਮ ਮਹਿਮਾਨੰ ਪ੍ਰਕਾਸ਼ਯਿਸ਼਼੍ਯਤਿ ਯਤੋ ਮਦੀਯਾਂ ਕਥਾਂ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਯੁਸ਼਼੍ਮਾਨ੍ ਬੋਧਯਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","ਪਿਤੁ ਰ੍ਯਦ੍ਯਦ੍ ਆਸ੍ਤੇ ਤਤ੍ ਸਰ੍ੱਵੰ ਮਮ ਤਸ੍ਮਾਦ੍ ਕਾਰਣਾਦ੍ ਅਵਾਦਿਸ਼਼ੰ ਸ ਮਦੀਯਾਂ ਕਥਾਂ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਯੁਸ਼਼੍ਮਾਨ੍ ਬੋਧਯਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","ਕਿਯਤ੍ਕਾਲਾਤ੍ ਪਰੰ ਯੂਯੰ ਮਾਂ ਦ੍ਰਸ਼਼੍ਟੁੰ ਨ ਲਪ੍ਸ੍ਯਧ੍ਵੇ ਕਿਨ੍ਤੁ ਕਿਯਤ੍ਕਾਲਾਤ੍ ਪਰੰ ਪੁਨ ਰ੍ਦ੍ਰਸ਼਼੍ਟੁੰ ਲਪ੍ਸ੍ਯਧ੍ਵੇ ਯਤੋਹੰ ਪਿਤੁਃ ਸਮੀਪੰ ਗੱਛਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ਤਤਃ ਸ਼ਿਸ਼਼੍ਯਾਣਾਂ ਕਿਯਨ੍ਤੋ ਜਨਾਃ ਪਰਸ੍ਪਰੰ ਵਦਿਤੁਮ੍ ਆਰਭਨ੍ਤ, ਕਿਯਤ੍ਕਾਲਾਤ੍ ਪਰੰ ਮਾਂ ਦ੍ਰਸ਼਼੍ਟੁੰ ਨ ਲਪ੍ਸ੍ਯਧ੍ਵੇ ਕਿਨ੍ਤੁ ਕਿਯਤ੍ਕਾਲਾਤ੍ ਪਰੰ ਪੁਨ ਰ੍ਦ੍ਰਸ਼਼੍ਟੁੰ ਲਪ੍ਸ੍ਯਧ੍ਵੇ ਯਤੋਹੰ ਪਿਤੁਃ ਸਮੀਪੰ ਗੱਛਾਮਿ, ਇਤਿ ਯਦ੍ ਵਾਕ੍ਯਮ੍ ਅਯੰ ਵਦਤਿ ਤਤ੍ ਕਿੰ? ");
INSERT INTO sanpun_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","ਤਤਃ ਕਿਯਤ੍ਕਾਲਾਤ੍ ਪਰਮ੍ ਇਤਿ ਤਸ੍ਯ ਵਾਕ੍ਯੰ ਕਿੰ? ਤਸ੍ਯ ਵਾਕ੍ਯਸ੍ਯਾਭਿਪ੍ਰਾਯੰ ਵਯੰ ਬੋੱਧੁੰ ਨ ਸ਼ਕ੍ਨੁਮਸ੍ਤੈਰਿਤਿ ");
INSERT INTO sanpun_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","ਨਿਗਦਿਤੇ ਯੀਸ਼ੁਸ੍ਤੇਸ਼਼ਾਂ ਪ੍ਰਸ਼੍ਨੇੱਛਾਂ ਜ੍ਞਾਤ੍ਵਾ ਤੇਭ੍ਯੋ(ਅ)ਕਥਯਤ੍ ਕਿਯਤ੍ਕਾਲਾਤ੍ ਪਰੰ ਮਾਂ ਦ੍ਰਸ਼਼੍ਟੁੰ ਨ ਲਪ੍ਸ੍ਯਧ੍ਵੇ, ਕਿਨ੍ਤੁ ਕਿਯਤ੍ਕਾਲਾਤ੍ ਪਰੰ ਪੂਨ ਰ੍ਦ੍ਰਸ਼਼੍ਟੁੰ ਲਪ੍ਸ੍ਯਧ੍ਵੇ, ਯਾਮਿਮਾਂ ਕਥਾਮਕਥਯੰ ਤਸ੍ਯਾ ਅਭਿਪ੍ਰਾਯੰ ਕਿੰ ਯੂਯੰ ਪਰਸ੍ਪਰੰ ਮ੍ਰੁʼਗਯਧ੍ਵੇ? ");
INSERT INTO sanpun_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","ਯੁਸ਼਼੍ਮਾਨਹਮ੍ ਅਤਿਯਥਾਰ੍ਥੰ ਵਦਾਮਿ ਯੂਯੰ ਕ੍ਰਨ੍ਦਿਸ਼਼੍ਯਥ ਵਿਲਪਿਸ਼਼੍ਯਥ ਚ, ਕਿਨ੍ਤੁ ਜਗਤੋ ਲੋਕਾ ਆਨਨ੍ਦਿਸ਼਼੍ਯਨ੍ਤਿ; ਯੂਯੰ ਸ਼ੋਕਾਕੁਲਾ ਭਵਿਸ਼਼੍ਯਥ ਕਿਨ੍ਤੁ ਸ਼ੋਕਾਤ੍ ਪਰੰ ਆਨਨ੍ਦਯੁਕ੍ਤਾ ਭਵਿਸ਼਼੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","ਪ੍ਰਸਵਕਾਲ ਉਪਸ੍ਥਿਤੇ ਨਾਰੀ ਯਥਾ ਪ੍ਰਸਵਵੇਦਨਯਾ ਵ੍ਯਾਕੁਲਾ ਭਵਤਿ ਕਿਨ੍ਤੁ ਪੁਤ੍ਰੇ ਭੂਮਿਸ਼਼੍ਠੇ ਸਤਿ ਮਨੁਸ਼਼੍ਯੈਕੋ ਜਨ੍ਮਨਾ ਨਰਲੋਕੇ ਪ੍ਰਵਿਸ਼਼੍ਟ ਇਤ੍ਯਾਨਨ੍ਦਾਤ੍ ਤਸ੍ਯਾਸ੍ਤਤ੍ਸਰ੍ੱਵੰ ਦੁਃਖੰ ਮਨਸਿ ਨ ਤਿਸ਼਼੍ਠਤਿ, ");
INSERT INTO sanpun_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","ਤਥਾ ਯੂਯਮਪਿ ਸਾਮ੍ਪ੍ਰਤੰ ਸ਼ੋਕਾਕੁਲਾ ਭਵਥ ਕਿਨ੍ਤੁ ਪੁਨਰਪਿ ਯੁਸ਼਼੍ਮਭ੍ਯੰ ਦਰ੍ਸ਼ਨੰ ਦਾਸ੍ਯਾਮਿ ਤੇਨ ਯੁਸ਼਼੍ਮਾਕਮ੍ ਅਨ੍ਤਃਕਰਣਾਨਿ ਸਾਨਨ੍ਦਾਨਿ ਭਵਿਸ਼਼੍ਯਨ੍ਤਿ, ਯੁਸ਼਼੍ਮਾਕੰ ਤਮ੍ ਆਨਨ੍ਦਞ੍ਚ ਕੋਪਿ ਹਰ੍ੱਤੁੰ ਨ ਸ਼ਕ੍ਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","ਤਸ੍ਮਿਨ੍ ਦਿਵਸੇ ਕਾਮਪਿ ਕਥਾਂ ਮਾਂ ਨ ਪ੍ਰਕ੍ਸ਼਼੍ਯਥ| ਯੁਸ਼਼੍ਮਾਨਹਮ੍ ਅਤਿਯਥਾਰ੍ਥੰ ਵਦਾਮਿ, ਮਮ ਨਾਮ੍ਨਾ ਯਤ੍ ਕਿਞ੍ਚਿਦ੍ ਪਿਤਰੰ ਯਾਚਿਸ਼਼੍ਯਧ੍ਵੇ ਤਦੇਵ ਸ ਦਾਸ੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","ਪੂਰ੍ੱਵੇ ਮਮ ਨਾਮ੍ਨਾ ਕਿਮਪਿ ਨਾਯਾਚਧ੍ਵੰ, ਯਾਚਧ੍ਵੰ ਤਤਃ ਪ੍ਰਾਪ੍ਸ੍ਯਥ ਤਸ੍ਮਾਦ੍ ਯੁਸ਼਼੍ਮਾਕੰ ਸਮ੍ਪੂਰ੍ਣਾਨਨ੍ਦੋ ਜਨਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","ਉਪਮਾਕਥਾਭਿਃ ਸਰ੍ੱਵਾਣ੍ਯੇਤਾਨਿ ਯੁਸ਼਼੍ਮਾਨ੍ ਜ੍ਞਾਪਿਤਵਾਨ੍ ਕਿਨ੍ਤੁ ਯਸ੍ਮਿਨ੍ ਸਮਯੇ ਉਪਮਯਾ ਨੋਕ੍ਤ੍ਵਾ ਪਿਤੁਃ ਕਥਾਂ ਸ੍ਪਸ਼਼੍ਟੰ ਜ੍ਞਾਪਯਿਸ਼਼੍ਯਾਮਿ ਸਮਯ ਏਤਾਦ੍ਰੁʼਸ਼ ਆਗੱਛਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ਤਦਾ ਮਮ ਨਾਮ੍ਨਾ ਪ੍ਰਾਰ੍ਥਯਿਸ਼਼੍ਯਧ੍ਵੇ (ਅ)ਹੰ ਯੁਸ਼਼੍ਮੰਨਿਮਿੱਤੰ ਪਿਤਰੰ ਵਿਨੇਸ਼਼੍ਯੇ ਕਥਾਮਿਮਾਂ ਨ ਵਦਾਮਿ; ");
INSERT INTO sanpun_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ਯਤੋ ਯੂਯੰ ਮਯਿ ਪ੍ਰੇਮ ਕੁਰੁਥ, ਤਥਾਹਮ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਸਮੀਪਾਦ੍ ਆਗਤਵਾਨ੍ ਇਤ੍ਯਪਿ ਪ੍ਰਤੀਥ, ਤਸ੍ਮਾਦ੍ ਕਾਰਣਾਤ੍ ਕਾਰਣਾਤ੍ ਪਿਤਾ ਸ੍ਵਯੰ ਯੁਸ਼਼੍ਮਾਸੁ ਪ੍ਰੀਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","ਪਿਤੁਃ ਸਮੀਪਾੱਜਜਦ੍ ਆਗਤੋਸ੍ਮਿ ਜਗਤ੍ ਪਰਿਤ੍ਯਜ੍ਯ ਚ ਪੁਨਰਪਿ ਪਿਤੁਃ ਸਮੀਪੰ ਗੱਛਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ਤਦਾ ਸ਼ਿਸ਼਼੍ਯਾ ਅਵਦਨ੍, ਹੇ ਪ੍ਰਭੋ ਭਵਾਨ੍ ਉਪਮਯਾ ਨੋਕ੍ਤ੍ਵਾਧੁਨਾ ਸ੍ਪਸ਼਼੍ਟੰ ਵਦਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ਭਵਾਨ੍ ਸਰ੍ੱਵਜ੍ਞਃ ਕੇਨਚਿਤ੍ ਪ੍ਰੁʼਸ਼਼੍ਟੋ ਭਵਿਤੁਮਪਿ ਭਵਤਃ ਪ੍ਰਯੋਜਨੰ ਨਾਸ੍ਤੀਤ੍ਯਧੁਨਾਸ੍ਮਾਕੰ ਸ੍ਥਿਰਜ੍ਞਾਨੰ ਜਾਤੰ ਤਸ੍ਮਾਦ੍ ਭਵਾਨ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਸਮੀਪਾਦ੍ ਆਗਤਵਾਨ੍ ਇਤ੍ਯਤ੍ਰ ਵਯੰ ਵਿਸ਼੍ਵਸਿਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ਤਤੋ ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯਵਾਦੀਦ੍ ਇਦਾਨੀਂ ਕਿੰ ਯੂਯੰ ਵਿਸ਼੍ਵਸਿਥ? ");
INSERT INTO sanpun_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ਪਸ਼੍ਯਤ ਸਰ੍ੱਵੇ ਯੂਯੰ ਵਿਕੀਰ੍ਣਾਃ ਸਨ੍ਤੋ ਮਾਮ੍ ਏਕਾਕਿਨੰ ਪੀਰਤ੍ਯਜ੍ਯ ਸ੍ਵੰ ਸ੍ਵੰ ਸ੍ਥਾਨੰ ਗਮਿਸ਼਼੍ਯਥ, ਏਤਾਦ੍ਰੁʼਸ਼ਃ ਸਮਯ ਆਗੱਛਤਿ ਵਰੰ ਪ੍ਰਾਯੇਣੋਪਸ੍ਥਿਤਵਾਨ੍; ਤਥਾਪ੍ਯਹੰ ਨੈਕਾਕੀ ਭਵਾਮਿ ਯਤਃ ਪਿਤਾ ਮਯਾ ਸਾਰ੍ੱਧਮ੍ ਆਸ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","ਯਥਾ ਮਯਾ ਯੁਸ਼਼੍ਮਾਕੰ ਸ਼ਾਨ੍ਤਿ ਰ੍ਜਾਯਤੇ ਤਦਰ੍ਥਮ੍ ਏਤਾਃ ਕਥਾ ਯੁਸ਼਼੍ਮਭ੍ਯਮ੍ ਅਚਕਥੰ; ਅਸ੍ਮਿਨ੍ ਜਗਤਿ ਯੁਸ਼਼੍ਮਾਕੰ ਕ੍ਲੇਸ਼ੋ ਘਟਿਸ਼਼੍ਯਤੇ ਕਿਨ੍ਤ੍ਵਕ੍ਸ਼਼ੋਭਾ ਭਵਤ ਯਤੋ ਮਯਾ ਜਗੱਜਿਤੰ| ");
INSERT INTO sanpun_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","ਤਤਃ ਪਰੰ ਯੀਸ਼ੁਰੇਤਾਃ ਕਥਾਃ ਕਥਯਿਤ੍ਵਾ ਸ੍ਵਰ੍ਗੰ ਵਿਲੋਕ੍ਯੈਤਤ੍ ਪ੍ਰਾਰ੍ਥਯਤ੍, ਹੇ ਪਿਤਃ ਸਮਯ ਉਪਸ੍ਥਿਤਵਾਨ੍; ਯਥਾ ਤਵ ਪੁਤ੍ਰਸ੍ਤਵ ਮਹਿਮਾਨੰ ਪ੍ਰਕਾਸ਼ਯਤਿ ਤਦਰ੍ਥੰ ਤ੍ਵੰ ਨਿਜਪੁਤ੍ਰਸ੍ਯ ਮਹਿਮਾਨੰ ਪ੍ਰਕਾਸ਼ਯ| ");
INSERT INTO sanpun_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ਤ੍ਵੰ ਯੋੱਲੋਕਾਨ੍ ਤਸ੍ਯ ਹਸ੍ਤੇ ਸਮਰ੍ਪਿਤਵਾਨ੍ ਸ ਯਥਾ ਤੇਭ੍ਯੋ(ਅ)ਨਨ੍ਤਾਯੁ ਰ੍ਦਦਾਤਿ ਤਦਰ੍ਥੰ ਤ੍ਵੰ ਪ੍ਰਾਣਿਮਾਤ੍ਰਾਣਾਮ੍ ਅਧਿਪਤਿਤ੍ਵਭਾਰੰ ਤਸ੍ਮੈ ਦੱਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","ਯਸ੍ਤ੍ਵਮ੍ ਅਦ੍ਵਿਤੀਯਃ ਸਤ੍ਯ ਈਸ਼੍ਵਰਸ੍ਤ੍ਵਯਾ ਪ੍ਰੇਰਿਤਸ਼੍ਚ ਯੀਸ਼ੁਃ ਖ੍ਰੀਸ਼਼੍ਟ ਏਤਯੋਰੁਭਯੋਃ ਪਰਿਚਯੇ ਪ੍ਰਾਪ੍ਤੇ(ਅ)ਨਨ੍ਤਾਯੁ ਰ੍ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ਤ੍ਵੰ ਯਸ੍ਯ ਕਰ੍ੰਮਣੋ ਭਾਰੰ ਮਹ੍ਯੰ ਦੱਤਵਾਨ੍, ਤਤ੍ ਸਮ੍ਪੰਨੰ ਕ੍ਰੁʼਤ੍ਵਾ ਜਗਤ੍ਯਸ੍ਮਿਨ੍ ਤਵ ਮਹਿਮਾਨੰ ਪ੍ਰਾਕਾਸ਼ਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ਅਤਏਵ ਹੇ ਪਿਤ ਰ੍ਜਗਤ੍ਯਵਿਦ੍ਯਮਾਨੇ ਤ੍ਵਯਾ ਸਹ ਤਿਸ਼਼੍ਠਤੋ ਮਮ ਯੋ ਮਹਿਮਾਸੀਤ੍ ਸਮ੍ਪ੍ਰਤਿ ਤਵ ਸਮੀਪੇ ਮਾਂ ਤੰ ਮਹਿਮਾਨੰ ਪ੍ਰਾਪਯ| ");
INSERT INTO sanpun_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","ਅਨ੍ਯੱਚ ਤ੍ਵਮ੍ ਏਤੱਜਗਤੋ ਯਾੱਲੋਕਾਨ੍ ਮਹ੍ਯਮ੍ ਅਦਦਾ ਅਹੰ ਤੇਭ੍ਯਸ੍ਤਵ ਨਾਮ੍ਨਸ੍ਤੱਤ੍ਵਜ੍ਞਾਨਮ੍ ਅਦਦਾਂ, ਤੇ ਤਵੈਵਾਸਨ੍, ਤ੍ਵੰ ਤਾਨ੍ ਮਹ੍ਯਮਦਦਾਃ, ਤਸ੍ਮਾੱਤੇ ਤਵੋਪਦੇਸ਼ਮ੍ ਅਗ੍ਰੁʼਹ੍ਲਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ਤ੍ਵੰ ਮਹ੍ਯੰ ਯਤ੍ ਕਿਞ੍ਚਿਦ੍ ਅਦਦਾਸ੍ਤਤ੍ਸਰ੍ੱਵੰ ਤ੍ਵੱਤੋ ਜਾਯਤੇ ਇਤ੍ਯਧੁਨਾਜਾਨਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ਮਹ੍ਯੰ ਯਮੁਪਦੇਸ਼ਮ੍ ਅਦਦਾ ਅਹਮਪਿ ਤੇਭ੍ਯਸ੍ਤਮੁਪਦੇਸ਼ਮ੍ ਅਦਦਾਂ ਤੇਪਿ ਤਮਗ੍ਰੁʼਹ੍ਲਨ੍ ਤ੍ਵੱਤੋਹੰ ਨਿਰ੍ਗਤ੍ਯ ਤ੍ਵਯਾ ਪ੍ਰੇਰਿਤੋਭਵਮ੍ ਅਤ੍ਰ ਚ ਵ੍ਯਸ਼੍ਵਸਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","ਤੇਸ਼਼ਾਮੇਵ ਨਿਮਿੱਤੰ ਪ੍ਰਾਰ੍ਥਯੇ(ਅ)ਹੰ ਜਗਤੋ ਲੋਕਨਿਮਿੱਤੰ ਨ ਪ੍ਰਾਰ੍ਥਯੇ ਕਿਨ੍ਤੁ ਯਾੱਲੋਕਾਨ੍ ਮਹ੍ਯਮ੍ ਅਦਦਾਸ੍ਤੇਸ਼਼ਾਮੇਵ ਨਿਮਿੱਤੰ ਪ੍ਰਾਰ੍ਥਯੇ(ਅ)ਹੰ ਯਤਸ੍ਤੇ ਤਵੈਵਾਸਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ਯੇ ਮਮ ਤੇ ਤਵ ਯੇ ਚ ਤਵ ਤੇ ਮਮ ਤਥਾ ਤੈ ਰ੍ਮਮ ਮਹਿਮਾ ਪ੍ਰਕਾਸ਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","ਸਾਮ੍ਪ੍ਰਤਮ੍ ਅਸ੍ਮਿਨ੍ ਜਗਤਿ ਮਮਾਵਸ੍ਥਿਤੇਃ ਸ਼ੇਸ਼਼ਮ੍ ਅਭਵਤ੍ ਅਹੰ ਤਵ ਸਮੀਪੰ ਗੱਛਾਮਿ ਕਿਨ੍ਤੁ ਤੇ ਜਗਤਿ ਸ੍ਥਾਸ੍ਯਨ੍ਤਿ; ਹੇ ਪਵਿਤ੍ਰ ਪਿਤਰਾਵਯੋ ਰ੍ਯਥੈਕਤ੍ਵਮਾਸ੍ਤੇ ਤਥਾ ਤੇਸ਼਼ਾਮਪ੍ਯੇਕਤ੍ਵੰ ਭਵਤਿ ਤਦਰ੍ਥੰ ਯਾੱਲੋਕਾਨ੍ ਮਹ੍ਯਮ੍ ਅਦਦਾਸ੍ਤਾਨ੍ ਸ੍ਵਨਾਮ੍ਨਾ ਰਕ੍ਸ਼਼| ");
INSERT INTO sanpun_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","ਯਾਵਨ੍ਤਿ ਦਿਨਾਨਿ ਜਗਤ੍ਯਸ੍ਮਿਨ੍ ਤੈਃ ਸਹਾਹਮਾਸੰ ਤਾਵਨ੍ਤਿ ਦਿਨਾਨਿ ਤਾਨ੍ ਤਵ ਨਾਮ੍ਨਾਹੰ ਰਕ੍ਸ਼਼ਿਤਵਾਨ੍; ਯਾੱਲੋਕਾਨ੍ ਮਹ੍ਯਮ੍ ਅਦਦਾਸ੍ਤਾਨ੍ ਸਰ੍ੱਵਾਨ੍ ਅਹਮਰਕ੍ਸ਼਼ੰ, ਤੇਸ਼਼ਾਂ ਮਧ੍ਯੇ ਕੇਵਲੰ ਵਿਨਾਸ਼ਪਾਤ੍ਰੰ ਹਾਰਿਤੰ ਤੇਨ ਧਰ੍ੰਮਪੁਸ੍ਤਕਸ੍ਯ ਵਚਨੰ ਪ੍ਰਤ੍ਯਕ੍ਸ਼਼ੰ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","ਕਿਨ੍ਤ੍ਵਧੁਨਾ ਤਵ ਸੰਨਿਧਿੰ ਗੱਛਾਮਿ ਮਯਾ ਯਥਾ ਤੇਸ਼਼ਾਂ ਸਮ੍ਪੂਰ੍ਣਾਨਨ੍ਦੋ ਭਵਤਿ ਤਦਰ੍ਥਮਹੰ ਜਗਤਿ ਤਿਸ਼਼੍ਠਨ੍ ਏਤਾਃ ਕਥਾ ਅਕਥਯਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","ਤਵੋਪਦੇਸ਼ੰ ਤੇਭ੍ਯੋ(ਅ)ਦਦਾਂ ਜਗਤਾ ਸਹ ਯਥਾ ਮਮ ਸਮ੍ਬਨ੍ਧੋ ਨਾਸ੍ਤਿ ਤਥਾ ਜਜਤਾ ਸਹ ਤੇਸ਼਼ਾਮਪਿ ਸਮ੍ਬਨ੍ਧਾਭਾਵਾਜ੍ ਜਗਤੋ ਲੋਕਾਸ੍ਤਾਨ੍ ਰੁʼਤੀਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ਤ੍ਵੰ ਜਗਤਸ੍ਤਾਨ੍ ਗ੍ਰੁʼਹਾਣੇਤਿ ਨ ਪ੍ਰਾਰ੍ਥਯੇ ਕਿਨ੍ਤ੍ਵਸ਼ੁਭਾਦ੍ ਰਕ੍ਸ਼਼ੇਤਿ ਪ੍ਰਾਰ੍ਥਯੇਹਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ਅਹੰ ਯਥਾ ਜਗਤ੍ਸਮ੍ਬਨ੍ਧੀਯੋ ਨ ਭਵਾਮਿ ਤਥਾ ਤੇਪਿ ਜਗਤ੍ਸਮ੍ਬਨ੍ਧੀਯਾ ਨ ਭਵਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","ਤਵ ਸਤ੍ਯਕਥਯਾ ਤਾਨ੍ ਪਵਿਤ੍ਰੀਕੁਰੁ ਤਵ ਵਾਕ੍ਯਮੇਵ ਸਤ੍ਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ਤ੍ਵੰ ਯਥਾ ਮਾਂ ਜਗਤਿ ਪ੍ਰੈਰਯਸ੍ਤਥਾਹਮਪਿ ਤਾਨ੍ ਜਗਤਿ ਪ੍ਰੈਰਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","ਤੇਸ਼਼ਾਂ ਹਿਤਾਰ੍ਥੰ ਯਥਾਹੰ ਸ੍ਵੰ ਪਵਿਤ੍ਰੀਕਰੋਮਿ ਤਥਾ ਸਤ੍ਯਕਥਯਾ ਤੇਪਿ ਪਵਿਤ੍ਰੀਭਵਨ੍ਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","ਕੇਵਲੰ ਏਤੇਸ਼਼ਾਮਰ੍ਥੇ ਪ੍ਰਾਰ੍ਥਯੇ(ਅ)ਹਮ੍ ਇਤਿ ਨ ਕਿਨ੍ਤ੍ਵੇਤੇਸ਼਼ਾਮੁਪਦੇਸ਼ੇਨ ਯੇ ਜਨਾ ਮਯਿ ਵਿਸ਼੍ਵਸਿਸ਼਼੍ਯਨ੍ਤਿ ਤੇਸ਼਼ਾਮਪ੍ਯਰ੍ਥੇ ਪ੍ਰਾਰ੍ਥੇਯੇ(ਅ)ਹਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ਹੇ ਪਿਤਸ੍ਤੇਸ਼਼ਾਂ ਸਰ੍ੱਵੇਸ਼਼ਾਮ੍ ਏਕਤ੍ਵੰ ਭਵਤੁ ਤਵ ਯਥਾ ਮਯਿ ਮਮ ਚ ਯਥਾ ਤ੍ਵੱਯੇਕਤ੍ਵੰ ਤਥਾ ਤੇਸ਼਼ਾਮਪ੍ਯਾਵਯੋਰੇਕਤ੍ਵੰ ਭਵਤੁ ਤੇਨ ਤ੍ਵੰ ਮਾਂ ਪ੍ਰੇਰਿਤਵਾਨ੍ ਇਤਿ ਜਗਤੋ ਲੋਕਾਃ ਪ੍ਰਤਿਯਨ੍ਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","ਯਥਾਵਯੋਰੇਕਤ੍ਵੰ ਤਥਾ ਤੇਸ਼਼ਾਮਪ੍ਯੇਕਤ੍ਵੰ ਭਵਤੁ ਤੇਸ਼਼੍ਵਹੰ ਮਯਿ ਚ ਤ੍ਵਮ੍ ਇੱਥੰ ਤੇਸ਼਼ਾਂ ਸਮ੍ਪੂਰ੍ਣਮੇਕਤ੍ਵੰ ਭਵਤੁ, ਤ੍ਵੰ ਪ੍ਰੇਰਿਤਵਾਨ੍ ਤ੍ਵੰ ਮਯਿ ਯਥਾ ਪ੍ਰੀਯਸੇ ਚ ਤਥਾ ਤੇਸ਼਼੍ਵਪਿ ਪ੍ਰੀਤਵਾਨ੍ ਏਤਦ੍ਯਥਾ ਜਗਤੋ ਲੋਕਾ ਜਾਨਨ੍ਤਿ ");
INSERT INTO sanpun_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ਤਦਰ੍ਥੰ ਤ੍ਵੰ ਯੰ ਮਹਿਮਾਨੰ ਮਹ੍ਯਮ੍ ਅਦਦਾਸ੍ਤੰ ਮਹਿਮਾਨਮ੍ ਅਹਮਪਿ ਤੇਭ੍ਯੋ ਦੱਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","ਹੇ ਪਿਤ ਰ੍ਜਗਤੋ ਨਿਰ੍ੰਮਾਣਾਤ੍ ਪੂਰ੍ੱਵੰ ਮਯਿ ਸ੍ਨੇਹੰ ਕ੍ਰੁʼਤ੍ਵਾ ਯੰ ਮਹਿਮਾਨੰ ਦੱਤਵਾਨ੍ ਮਮ ਤੰ ਮਹਿਮਾਨੰ ਯਥਾ ਤੇ ਪਸ਼੍ਯਨ੍ਤਿ ਤਦਰ੍ਥੰ ਯਾੱਲੋਕਾਨ੍ ਮਹ੍ਯੰ ਦੱਤਵਾਨ੍ ਅਹੰ ਯਤ੍ਰ ਤਿਸ਼਼੍ਠਾਮਿ ਤੇਪਿ ਯਥਾ ਤਤ੍ਰ ਤਿਸ਼਼੍ਠਨ੍ਤਿ ਮਮੈਸ਼਼ਾ ਵਾਞ੍ਛਾ| ");
INSERT INTO sanpun_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ਹੇ ਯਥਾਰ੍ਥਿਕ ਪਿਤ ਰ੍ਜਗਤੋ ਲੋਕੈਸ੍ਤ੍ਵੱਯਜ੍ਞਾਤੇਪਿ ਤ੍ਵਾਮਹੰ ਜਾਨੇ ਤ੍ਵੰ ਮਾਂ ਪ੍ਰੇਰਿਤਵਾਨ੍ ਇਤੀਮੇ ਸ਼ਿਸ਼਼੍ਯਾ ਜਾਨਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","ਯਥਾਹੰ ਤੇਸ਼਼ੁ ਤਿਸ਼਼੍ਠਾਮਿ ਤਥਾ ਮਯਿ ਯੇਨ ਪ੍ਰੇਮ੍ਨਾ ਪ੍ਰੇਮਾਕਰੋਸ੍ਤਤ੍ ਤੇਸ਼਼ੁ ਤਿਸ਼਼੍ਠਤਿ ਤਦਰ੍ਥੰ ਤਵ ਨਾਮਾਹੰ ਤਾਨ੍ ਜ੍ਞਾਪਿਤਵਾਨ੍ ਪੁਨਰਪਿ ਜ੍ਞਾਪਯਿਸ਼਼੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","ਤਾਃ ਕਥਾਃ ਕਥਯਿਤ੍ਵਾ ਯੀਸ਼ੁਃ ਸ਼ਿਸ਼਼੍ਯਾਨਾਦਾਯ ਕਿਦ੍ਰੋੰਨਾਮਕੰ ਸ੍ਰੋਤ ਉੱਤੀਰ੍ੱਯ ਸ਼ਿਸ਼਼੍ਯੈਃ ਸਹ ਤਤ੍ਰਤ੍ਯੋਦ੍ਯਾਨੰ ਪ੍ਰਾਵਿਸ਼ਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","ਕਿਨ੍ਤੁ ਵਿਸ਼੍ਵਾਸਘਾਤਿਯਿਹੂਦਾਸ੍ਤਤ੍ ਸ੍ਥਾਨੰ ਪਰਿਚੀਯਤੇ ਯਤੋ ਯੀਸ਼ੁਃ ਸ਼ਿਸ਼਼੍ਯੈਃ ਸਾਰ੍ੱਧੰ ਕਦਾਚਿਤ੍ ਤਤ੍ ਸ੍ਥਾਨਮ੍ ਅਗੱਛਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ਤਦਾ ਸ ਯਿਹੂਦਾਃ ਸੈਨ੍ਯਗਣੰ ਪ੍ਰਧਾਨਯਾਜਕਾਨਾਂ ਫਿਰੂਸ਼ਿਨਾਞ੍ਚ ਪਦਾਤਿਗਣਞ੍ਚ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਪ੍ਰਦੀਪਾਨ੍ ਉਲ੍ਕਾਨ੍ ਅਸ੍ਤ੍ਰਾਣਿ ਚਾਦਾਯ ਤਸ੍ਮਿਨ੍ ਸ੍ਥਾਨ ਉਪਸ੍ਥਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","ਸ੍ਵੰ ਪ੍ਰਤਿ ਯਦ੍ ਘਟਿਸ਼਼੍ਯਤੇ ਤਜ੍ ਜ੍ਞਾਤ੍ਵਾ ਯੀਸ਼ੁਰਗ੍ਰੇਸਰਃ ਸਨ੍ ਤਾਨਪ੍ਰੁʼੱਛਤ੍ ਕੰ ਗਵੇਸ਼਼ਯਥ? ");
INSERT INTO sanpun_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","ਤੇ ਪ੍ਰਤ੍ਯਵਦਨ੍, ਨਾਸਰਤੀਯੰ ਯੀਸ਼ੁੰ; ਤਤੋ ਯੀਸ਼ੁਰਵਾਦੀਦ੍ ਅਹਮੇਵ ਸਃ; ਤੈਃ ਸਹ ਵਿਸ਼੍ਵਾਸਘਾਤੀ ਯਿਹੂਦਾਸ਼੍ਚਾਤਿਸ਼਼੍ਠਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ਤਦਾਹਮੇਵ ਸ ਤਸ੍ਯੈਤਾਂ ਕਥਾਂ ਸ਼੍ਰੁਤ੍ਵੈਵ ਤੇ ਪਸ਼੍ਚਾਦੇਤ੍ਯ ਭੂਮੌ ਪਤਿਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","ਤਤੋ ਯੀਸ਼ੁਃ ਪੁਨਰਪਿ ਪ੍ਰੁʼਸ਼਼੍ਠਵਾਨ੍ ਕੰ ਗਵੇਸ਼਼ਯਥ? ਤਤਸ੍ਤੇ ਪ੍ਰਤ੍ਯਵਦਨ੍ ਨਾਸਰਤੀਯੰ ਯੀਸ਼ੁੰ| ");
INSERT INTO sanpun_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ਤਦਾ ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯੁਦਿਤਵਾਨ੍ ਅਹਮੇਵ ਸ ਇਮਾਂ ਕਥਾਮਚਕਥਮ੍; ਯਦਿ ਮਾਮਨ੍ਵਿੱਛਥ ਤਰ੍ਹੀਮਾਨ੍ ਗਨ੍ਤੁੰ ਮਾ ਵਾਰਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ਇੱਥੰ ਭੂਤੇ ਮਹ੍ਯੰ ਯਾੱਲੋਕਾਨ੍ ਅਦਦਾਸ੍ਤੇਸ਼਼ਾਮ੍ ਏਕਮਪਿ ਨਾਹਾਰਯਮ੍ ਇਮਾਂ ਯਾਂ ਕਥਾਂ ਸ ਸ੍ਵਯਮਕਥਯਤ੍ ਸਾ ਕਥਾ ਸਫਲਾ ਜਾਤਾ| ");
INSERT INTO sanpun_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","ਤਦਾ ਸ਼ਿਮੋਨ੍ਪਿਤਰਸ੍ਯ ਨਿਕਟੇ ਖਙ੍ਗਲ੍ਸ੍ਥਿਤੇਃ ਸ ਤੰ ਨਿਸ਼਼੍ਕੋਸ਼਼ੰ ਕ੍ਰੁʼਤ੍ਵਾ ਮਹਾਯਾਜਕਸ੍ਯ ਮਾਲ੍ਖਨਾਮਾਨੰ ਦਾਸਮ੍ ਆਹਤ੍ਯ ਤਸ੍ਯ ਦਕ੍ਸ਼਼ਿਣਕਰ੍ਣੰ ਛਿੰਨਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ਤਤੋ ਯੀਸ਼ੁਃ ਪਿਤਰਮ੍ ਅਵਦਤ੍, ਖਙ੍ਗੰ ਕੋਸ਼਼ੇ ਸ੍ਥਾਪਯ ਮਮ ਪਿਤਾ ਮਹ੍ਯੰ ਪਾਤੁੰ ਯੰ ਕੰਸਮ੍ ਅਦਦਾਤ੍ ਤੇਨਾਹੰ ਕਿੰ ਨ ਪਾਸ੍ਯਾਮਿ? ");
INSERT INTO sanpun_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","ਤਦਾ ਸੈਨ੍ਯਗਣਃ ਸੇਨਾਪਤਿ ਰ੍ਯਿਹੂਦੀਯਾਨਾਂ ਪਦਾਤਯਸ਼੍ਚ ਯੀਸ਼ੁੰ ਘ੍ਰੁʼਤ੍ਵਾ ਬੱਧ੍ਵਾ ਹਾਨੰਨਾਮ੍ਨਃ ਕਿਯਫਾਃ ਸ਼੍ਵਸ਼ੁਰਸ੍ਯ ਸਮੀਪੰ ਪ੍ਰਥਮਮ੍ ਅਨਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ਸ ਕਿਯਫਾਸ੍ਤਸ੍ਮਿਨ੍ ਵਤ੍ਸਰੇ ਮਹਾਯਾਜਤ੍ਵਪਦੇ ਨਿਯੁਕ੍ਤਃ ");
INSERT INTO sanpun_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ਸਨ੍ ਸਾਧਾਰਣਲੋਕਾਨਾਂ ਮਙ੍ਗਲਾਰ੍ਥਮ੍ ਏਕਜਨਸ੍ਯ ਮਰਣਮੁਚਿਤਮ੍ ਇਤਿ ਯਿਹੂਦੀਯੈਃ ਸਾਰ੍ੱਧਮ੍ ਅਮਨ੍ਤ੍ਰਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","ਤਦਾ ਸ਼ਿਮੋਨ੍ਪਿਤਰੋ(ਅ)ਨ੍ਯੈਕਸ਼ਿਸ਼਼੍ਯਸ਼੍ਚ ਯੀਸ਼ੋਃ ਪਸ਼੍ਚਾਦ੍ ਅਗੱਛਤਾਂ ਤਸ੍ਯਾਨ੍ਯਸ਼ਿਸ਼਼੍ਯਸ੍ਯ ਮਹਾਯਾਜਕੇਨ ਪਰਿਚਿਤਤ੍ਵਾਤ੍ ਸ ਯੀਸ਼ੁਨਾ ਸਹ ਮਹਾਯਾਜਕਸ੍ਯਾੱਟਾਲਿਕਾਂ ਪ੍ਰਾਵਿਸ਼ਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ਕਿਨ੍ਤੁ ਪਿਤਰੋ ਬਹਿਰ੍ਦ੍ਵਾਰਸ੍ਯ ਸਮੀਪੇ(ਅ)ਤਿਸ਼਼੍ਠਦ੍ ਅਤਏਵ ਮਹਾਯਾਜਕੇਨ ਪਰਿਚਿਤਃ ਸ ਸ਼ਿਸ਼਼੍ਯਃ ਪੁਨਰ੍ਬਹਿਰ੍ਗਤ੍ਵਾ ਦੌਵਾਯਿਕਾਯੈ ਕਥਯਿਤ੍ਵਾ ਪਿਤਰਮ੍ ਅਭ੍ਯਨ੍ਤਰਮ੍ ਆਨਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ਤਦਾ ਸ ਦ੍ਵਾਰਰਕ੍ਸ਼਼ਿਕਾ ਪਿਤਰਮ੍ ਅਵਦਤ੍ ਤ੍ਵੰ ਕਿੰ ਨ ਤਸ੍ਯ ਮਾਨਵਸ੍ਯ ਸ਼ਿਸ਼਼੍ਯਃ? ਤਤਃ ਸੋਵਦਦ੍ ਅਹੰ ਨ ਭਵਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ਤਤਃ ਪਰੰ ਯਤ੍ਸ੍ਥਾਨੇ ਦਾਸਾਃ ਪਦਾਤਯਸ਼੍ਚ ਸ਼ੀਤਹੇਤੋਰਙ੍ਗਾਰੈ ਰ੍ਵਹ੍ਨਿੰ ਪ੍ਰਜ੍ਵਾਲ੍ਯ ਤਾਪੰ ਸੇਵਿਤਵਨ੍ਤਸ੍ਤਤ੍ਸ੍ਥਾਨੇ ਪਿਤਰਸ੍ਤਿਸ਼਼੍ਠਨ੍ ਤੈਃ ਸਹ ਵਹ੍ਨਿਤਾਪੰ ਸੇਵਿਤੁਮ੍ ਆਰਭਤ| ");
INSERT INTO sanpun_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","ਤਦਾ ਸ਼ਿਸ਼਼੍ਯੇਸ਼਼ੂਪਦੇਸ਼ੇ ਚ ਮਹਾਯਾਜਕੇਨ ਯੀਸ਼ੁਃ ਪ੍ਰੁʼਸ਼਼੍ਟਃ ");
INSERT INTO sanpun_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","ਸਨ੍ ਪ੍ਰਤ੍ਯੁਕ੍ਤਵਾਨ੍ ਸਰ੍ੱਵਲੋਕਾਨਾਂ ਸਮਕ੍ਸ਼਼ੰ ਕਥਾਮਕਥਯੰ ਗੁਪ੍ਤੰ ਕਾਮਪਿ ਕਥਾਂ ਨ ਕਥਯਿਤ੍ਵਾ ਯਤ੍ ਸ੍ਥਾਨੰ ਯਿਹੂਦੀਯਾਃ ਸਤਤੰ ਗੱਛਨ੍ਤਿ ਤਤ੍ਰ ਭਜਨਗੇਹੇ ਮਨ੍ਦਿਰੇ ਚਾਸ਼ਿਕ੍ਸ਼਼ਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","ਮੱਤਃ ਕੁਤਃ ਪ੍ਰੁʼੱਛਸਿ? ਯੇ ਜਨਾ ਮਦੁਪਦੇਸ਼ਮ੍ ਅਸ਼੍ਰੁʼਣ੍ਵਨ੍ ਤਾਨੇਵ ਪ੍ਰੁʼੱਛ ਯਦ੍ਯਦ੍ ਅਵਦੰ ਤੇ ਤਤ੍ ਜਾਨਿਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","ਤਦੇੱਥੰ ਪ੍ਰਤ੍ਯੁਦਿਤਤ੍ਵਾਤ੍ ਨਿਕਟਸ੍ਥਪਦਾਤਿ ਰ੍ਯੀਸ਼ੁੰ ਚਪੇਟੇਨਾਹਤ੍ਯ ਵ੍ਯਾਹਰਤ੍ ਮਹਾਯਾਜਕਮ੍ ਏਵੰ ਪ੍ਰਤਿਵਦਸਿ? ");
INSERT INTO sanpun_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ਤਤੋ ਯੀਸ਼ੁਃ ਪ੍ਰਤਿਗਦਿਤਵਾਨ੍ ਯਦ੍ਯਯਥਾਰ੍ਥਮ੍ ਅਚਕਥੰ ਤਰ੍ਹਿ ਤਸ੍ਯਾਯਥਾਰ੍ਥਸ੍ਯ ਪ੍ਰਮਾਣੰ ਦੇਹਿ, ਕਿਨ੍ਤੁ ਯਦਿ ਯਥਾਰ੍ਥੰ ਤਰ੍ਹਿ ਕੁਤੋ ਹੇਤੋ ਰ੍ਮਾਮ੍ ਅਤਾਡਯਃ? ");
INSERT INTO sanpun_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","ਪੂਰ੍ੱਵੰ ਹਾਨਨ੍ ਸਬਨ੍ਧਨੰ ਤੰ ਕਿਯਫਾਮਹਾਯਾਜਕਸ੍ਯ ਸਮੀਪੰ ਪ੍ਰੈਸ਼਼ਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ਸ਼ਿਮੋਨ੍ਪਿਤਰਸ੍ਤਿਸ਼਼੍ਠਨ੍ ਵਹ੍ਨਿਤਾਪੰ ਸੇਵਤੇ, ਏਤਸ੍ਮਿਨ੍ ਸਮਯੇ ਕਿਯਨ੍ਤਸ੍ਤਮ੍ ਅਪ੍ਰੁʼੱਛਨ੍ ਤ੍ਵੰ ਕਿਮ੍ ਏਤਸ੍ਯ ਜਨਸ੍ਯ ਸ਼ਿਸ਼਼੍ਯੋ ਨ? ਤਤਃ ਸੋਪਹ੍ਨੁਤ੍ਯਾਬ੍ਰਵੀਦ੍ ਅਹੰ ਨ ਭਵਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","ਤਦਾ ਮਹਾਯਾਜਕਸ੍ਯ ਯਸ੍ਯ ਦਾਸਸ੍ਯ ਪਿਤਰਃ ਕਰ੍ਣਮੱਛਿਨਤ੍ ਤਸ੍ਯ ਕੁਟੁਮ੍ਬਃ ਪ੍ਰਤ੍ਯੁਦਿਤਵਾਨ੍ ਉਦ੍ਯਾਨੇ ਤੇਨ ਸਹ ਤਿਸ਼਼੍ਠਨ੍ਤੰ ਤ੍ਵਾਂ ਕਿੰ ਨਾਪਸ਼੍ਯੰ? ");
INSERT INTO sanpun_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","ਕਿਨ੍ਤੁ ਪਿਤਰਃ ਪੁਨਰਪਹ੍ਨੁਤ੍ਯ ਕਥਿਤਵਾਨ੍; ਤਦਾਨੀਂ ਕੁੱਕੁਟੋ(ਅ)ਰੌਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","ਤਦਨਨ੍ਤਰੰ ਪ੍ਰਤ੍ਯੂਸ਼਼ੇ ਤੇ ਕਿਯਫਾਗ੍ਰੁʼਹਾਦ੍ ਅਧਿਪਤੇ ਰ੍ਗ੍ਰੁʼਹੰ ਯੀਸ਼ੁਮ੍ ਅਨਯਨ੍ ਕਿਨ੍ਤੁ ਯਸ੍ਮਿਨ੍ ਅਸ਼ੁਚਿਤ੍ਵੇ ਜਾਤੇ ਤੈ ਰ੍ਨਿਸ੍ਤਾਰੋਤ੍ਸਵੇ ਨ ਭੋਕ੍ਤਵ੍ਯੰ, ਤਸ੍ਯ ਭਯਾਦ੍ ਯਿਹੂਦੀਯਾਸ੍ਤਦ੍ਗ੍ਰੁʼਹੰ ਨਾਵਿਸ਼ਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","ਅਪਰੰ ਪੀਲਾਤੋ ਬਹਿਰਾਗਤ੍ਯ ਤਾਨ੍ ਪ੍ਰੁʼਸ਼਼੍ਠਵਾਨ੍ ਏਤਸ੍ਯ ਮਨੁਸ਼਼੍ਯਸ੍ਯ ਕੰ ਦੋਸ਼਼ੰ ਵਦਥ? ");
INSERT INTO sanpun_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ਤਦਾ ਤੇ ਪੇਤ੍ਯਵਦਨ੍ ਦੁਸ਼਼੍ਕਰ੍ੰਮਕਾਰਿਣਿ ਨ ਸਤਿ ਭਵਤਃ ਸਮੀਪੇ ਨੈਨੰ ਸਮਾਰ੍ਪਯਿਸ਼਼੍ਯਾਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ਤਤਃ ਪੀਲਾਤੋ(ਅ)ਵਦਦ੍ ਯੂਯਮੇਨੰ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਸ੍ਵੇਸ਼਼ਾਂ ਵ੍ਯਵਸ੍ਥਯਾ ਵਿਚਾਰਯਤ| ਤਦਾ ਯਿਹੂਦੀਯਾਃ ਪ੍ਰਤ੍ਯਵਦਨ੍ ਕਸ੍ਯਾਪਿ ਮਨੁਸ਼਼੍ਯਸ੍ਯ ਪ੍ਰਾਣਦਣ੍ਡੰ ਕਰ੍ੱਤੁੰ ਨਾਸ੍ਮਾਕਮ੍ ਅਧਿਕਾਰੋ(ਅ)ਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ਏਵੰ ਸਤਿ ਯੀਸ਼ੁਃ ਸ੍ਵਸ੍ਯ ਮ੍ਰੁʼਤ੍ਯੌ ਯਾਂ ਕਥਾਂ ਕਥਿਤਵਾਨ੍ ਸਾ ਸਫਲਾਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","ਤਦਨਨ੍ਤਰੰ ਪੀਲਾਤਃ ਪੁਨਰਪਿ ਤਦ੍ ਰਾਜਗ੍ਰੁʼਹੰ ਗਤ੍ਵਾ ਯੀਸ਼ੁਮਾਹੂਯ ਪ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍ ਤ੍ਵੰ ਕਿੰ ਯਿਹੂਦੀਯਾਨਾਂ ਰਾਜਾ? ");
INSERT INTO sanpun_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯਵਦਤ੍ ਤ੍ਵਮ੍ ਏਤਾਂ ਕਥਾਂ ਸ੍ਵਤਃ ਕਥਯਸਿ ਕਿਮਨ੍ਯਃ ਕਸ਼੍ਚਿਨ੍ ਮਯਿ ਕਥਿਤਵਾਨ੍? ");
INSERT INTO sanpun_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ਪੀਲਾਤੋ(ਅ)ਵਦਦ੍ ਅਹੰ ਕਿੰ ਯਿਹੂਦੀਯਃ? ਤਵ ਸ੍ਵਦੇਸ਼ੀਯਾ ਵਿਸ਼ੇਸ਼਼ਤਃ ਪ੍ਰਧਾਨਯਾਜਕਾ ਮਮ ਨਿਕਟੇ ਤ੍ਵਾਂ ਸਮਾਰ੍ਪਯਨ, ਤ੍ਵੰ ਕਿੰ ਕ੍ਰੁʼਤਵਾਨ੍? ");
INSERT INTO sanpun_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯਵਦਤ੍ ਮਮ ਰਾਜ੍ਯਮ੍ ਏਤੱਜਗਤ੍ਸਮ੍ਬਨ੍ਧੀਯੰ ਨ ਭਵਤਿ ਯਦਿ ਮਮ ਰਾਜ੍ਯੰ ਜਗਤ੍ਸਮ੍ਬਨ੍ਧੀਯਮ੍ ਅਭਵਿਸ਼਼੍ਯਤ੍ ਤਰ੍ਹਿ ਯਿਹੂਦੀਯਾਨਾਂ ਹਸ੍ਤੇਸ਼਼ੁ ਯਥਾ ਸਮਰ੍ਪਿਤੋ ਨਾਭਵੰ ਤਦਰ੍ਥੰ ਮਮ ਸੇਵਕਾ ਅਯੋਤ੍ਸ੍ਯਨ੍ ਕਿਨ੍ਤੁ ਮਮ ਰਾਜ੍ਯਮ੍ ਐਹਿਕੰ ਨ| ");
INSERT INTO sanpun_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","ਤਦਾ ਪੀਲਾਤਃ ਕਥਿਤਵਾਨ੍, ਤਰ੍ਹਿ ਤ੍ਵੰ ਰਾਜਾ ਭਵਸਿ? ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯੁਕ੍ਤਵਾਨ੍ ਤ੍ਵੰ ਸਤ੍ਯੰ ਕਥਯਸਿ, ਰਾਜਾਹੰ ਭਵਾਮਿ; ਸਤ੍ਯਤਾਯਾਂ ਸਾਕ੍ਸ਼਼੍ਯੰ ਦਾਤੁੰ ਜਨਿੰ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਜਗਤ੍ਯਸ੍ਮਿਨ੍ ਅਵਤੀਰ੍ਣਵਾਨ੍, ਤਸ੍ਮਾਤ੍ ਸਤ੍ਯਧਰ੍ੰਮਪਕ੍ਸ਼਼ਪਾਤਿਨੋ ਮਮ ਕਥਾਂ ਸ਼੍ਰੁʼਣ੍ਵਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","ਤਦਾ ਸਤ੍ਯੰ ਕਿੰ? ਏਤਾਂ ਕਥਾਂ ਪਸ਼਼੍ਟ੍ਵਾ ਪੀਲਾਤਃ ਪੁਨਰਪਿ ਬਹਿਰ੍ਗਤ੍ਵਾ ਯਿਹੂਦੀਯਾਨ੍ ਅਭਾਸ਼਼ਤ, ਅਹੰ ਤਸ੍ਯ ਕਮਪ੍ਯਪਰਾਧੰ ਨ ਪ੍ਰਾਪ੍ਨੋਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","ਨਿਸ੍ਤਾਰੋਤ੍ਸਵਸਮਯੇ ਯੁਸ਼਼੍ਮਾਭਿਰਭਿਰੁਚਿਤ ਏਕੋ ਜਨੋ ਮਯਾ ਮੋਚਯਿਤਵ੍ਯ ਏਸ਼਼ਾ ਯੁਸ਼਼੍ਮਾਕੰ ਰੀਤਿਰਸ੍ਤਿ, ਅਤਏਵ ਯੁਸ਼਼੍ਮਾਕੰ ਨਿਕਟੇ ਯਿਹੂਦੀਯਾਨਾਂ ਰਾਜਾਨੰ ਕਿੰ ਮੋਚਯਾਮਿ, ਯੁਸ਼਼੍ਮਾਕਮ੍ ਇੱਛਾ ਕਾ? ");
INSERT INTO sanpun_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","ਤਦਾ ਤੇ ਸਰ੍ੱਵੇ ਰੁਵਨ੍ਤੋ ਵ੍ਯਾਹਰਨ੍ ਏਨੰ ਮਾਨੁਸ਼਼ੰ ਨਹਿ ਬਰੱਬਾਂ ਮੋਚਯ| ਕਿਨ੍ਤੁ ਸ ਬਰੱਬਾ ਦਸ੍ਯੁਰਾਸੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","ਪੀਲਾਤੋ ਯੀਸ਼ੁਮ੍ ਆਨੀਯ ਕਸ਼ਯਾ ਪ੍ਰਾਹਾਰਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ਪਸ਼੍ਚਾਤ੍ ਸੇਨਾਗਣਃ ਕਣ੍ਟਕਨਿਰ੍ੰਮਿਤੰ ਮੁਕੁਟੰ ਤਸ੍ਯ ਮਸ੍ਤਕੇ ਸਮਰ੍ਪ੍ਯ ਵਾਰ੍ੱਤਾਕੀਵਰ੍ਣੰ ਰਾਜਪਰਿੱਛਦੰ ਪਰਿਧਾਪ੍ਯ, ");
INSERT INTO sanpun_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ਹੇ ਯਿਹੂਦੀਯਾਨਾਂ ਰਾਜਨ੍ ਨਮਸ੍ਕਾਰ ਇਤ੍ਯੁਕ੍ਤ੍ਵਾ ਤੰ ਚਪੇਟੇਨਾਹਨ੍ਤੁਮ੍ ਆਰਭਤ| ");
INSERT INTO sanpun_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","ਤਦਾ ਪੀਲਾਤਃ ਪੁਨਰਪਿ ਬਹਿਰ੍ਗਤ੍ਵਾ ਲੋਕਾਨ੍ ਅਵਦਤ੍, ਅਸ੍ਯ ਕਮਪ੍ਯਪਰਾਧੰ ਨ ਲਭੇ(ਅ)ਹੰ, ਪਸ਼੍ਯਤ ਤਦ੍ ਯੁਸ਼਼੍ਮਾਨ੍ ਜ੍ਞਾਪਯਿਤੁੰ ਯੁਸ਼਼੍ਮਾਕੰ ਸੰਨਿਧੌ ਬਹਿਰੇਨਮ੍ ਆਨਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","ਤਤਃ ਪਰੰ ਯੀਸ਼ੁਃ ਕਣ੍ਟਕਮੁਕੁਟਵਾਨ੍ ਵਾਰ੍ੱਤਾਕੀਵਰ੍ਣਵਸਨਵਾਂਸ਼੍ਚ ਬਹਿਰਾਗੱਛਤ੍| ਤਤਃ ਪੀਲਾਤ ਉਕ੍ਤਵਾਨ੍ ਏਨੰ ਮਨੁਸ਼਼੍ਯੰ ਪਸ਼੍ਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ਤਦਾ ਪ੍ਰਧਾਨਯਾਜਕਾਃ ਪਦਾਤਯਸ਼੍ਚ ਤੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ, ਏਨੰ ਕ੍ਰੁਸ਼ੇ ਵਿਧ, ਏਨੰ ਕ੍ਰੁਸ਼ੇ ਵਿਧ, ਇਤ੍ਯੁਕ੍ਤ੍ਵਾ ਰਵਿਤੁੰ ਆਰਭਨ੍ਤ| ਤਤਃ ਪੀਲਾਤਃ ਕਥਿਤਵਾਨ੍ ਯੂਯੰ ਸ੍ਵਯਮ੍ ਏਨੰ ਨੀਤ੍ਵਾ ਕ੍ਰੁਸ਼ੇ ਵਿਧਤ, ਅਹਮ੍ ਏਤਸ੍ਯ ਕਮਪ੍ਯਪਰਾਧੰ ਨ ਪ੍ਰਾਪ੍ਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","ਯਿਹੂਦੀਯਾਃ ਪ੍ਰਤ੍ਯਵਦਨ੍ ਅਸ੍ਮਾਕੰ ਯਾ ਵ੍ਯਵਸ੍ਥਾਸ੍ਤੇ ਤਦਨੁਸਾਰੇਣਾਸ੍ਯ ਪ੍ਰਾਣਹਨਨਮ੍ ਉਚਿਤੰ ਯਤੋਯੰ ਸ੍ਵਮ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਪੁਤ੍ਰਮਵਦਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ਪੀਲਾਤ ਇਮਾਂ ਕਥਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਮਹਾਤ੍ਰਾਸਯੁਕ੍ਤਃ ");
INSERT INTO sanpun_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ਸਨ੍ ਪੁਨਰਪਿ ਰਾਜਗ੍ਰੁʼਹ ਆਗਤ੍ਯ ਯੀਸ਼ੁੰ ਪ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍ ਤ੍ਵੰ ਕੁਤ੍ਰਤ੍ਯੋ ਲੋਕਃ? ਕਿਨ੍ਤੁ ਯੀਸ਼ਸ੍ਤਸ੍ਯ ਕਿਮਪਿ ਪ੍ਰਤ੍ਯੁੱਤਰੰ ਨਾਵਦਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","੧॰ ਤਤਃ ਪੀਲਾਤ੍ ਕਥਿਤਵਾਨ ਤ੍ਵੰ ਕਿੰ ਮਯਾ ਸਾਰ੍ੱਧੰ ਨ ਸੰਲਪਿਸ਼਼੍ਯਸਿ ? ਤ੍ਵਾਂ ਕ੍ਰੁਸ਼ੇ ਵੇਧਿਤੁੰ ਵਾ ਮੋਚਯਿਤੁੰ ਸ਼ਕ੍ਤਿ ਰ੍ਮਮਾਸ੍ਤੇ ਇਤਿ ਕਿੰ ਤ੍ਵੰ ਨ ਜਾਨਾਸਿ ? ਤਦਾ ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯਵਦਦ੍ ਈਸ਼੍ਵਰੇਣਾਦŸाਂ ਮਮੋਪਰਿ ਤਵ ਕਿਮਪ੍ਯਧਿਪਤਿਤ੍ਵੰ ਨ ਵਿਦ੍ਯਤੇ, ਤਥਾਪਿ ਯੋ ਜਨੋ ਮਾਂ ਤਵ ਹਸ੍ਤੇ ਸਮਾਰ੍ਪਯਤ੍ ਤਸ੍ਯ ਮਹਾਪਾਤਕੰ ਜਾਤਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ਤਦਾ ਯੀਸ਼ੁਃ ਪ੍ਰਤ੍ਯਵਦਦ੍ ਈਸ਼੍ਵਰੇਣਾਦੱਤੰ ਮਮੋਪਰਿ ਤਵ ਕਿਮਪ੍ਯਧਿਪਤਿਤ੍ਵੰ ਨ ਵਿਦ੍ਯਤੇ, ਤਥਾਪਿ ਯੋ ਜਨੋ ਮਾਂ ਤਵ ਹਸ੍ਤੇ ਸਮਾਰ੍ਪਯਤ੍ ਤਸ੍ਯ ਮਹਾਪਾਤਕੰ ਜਾਤਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ਤਦਾਰਭ੍ਯ ਪੀਲਾਤਸ੍ਤੰ ਮੋਚਯਿਤੁੰ ਚੇਸ਼਼੍ਟਿਤਵਾਨ੍ ਕਿਨ੍ਤੁ ਯਿਹੂਦੀਯਾ ਰੁਵਨ੍ਤੋ ਵ੍ਯਾਹਰਨ੍ ਯਦੀਮੰ ਮਾਨਵੰ ਤ੍ਯਜਸਿ ਤਰ੍ਹਿ ਤ੍ਵੰ ਕੈਸਰਸ੍ਯ ਮਿਤ੍ਰੰ ਨ ਭਵਸਿ, ਯੋ ਜਨਃ ਸ੍ਵੰ ਰਾਜਾਨੰ ਵਕ੍ਤਿ ਸਏਵ ਕੈਮਰਸ੍ਯ ਵਿਰੁੱਧਾਂ ਕਥਾਂ ਕਥਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ਏਤਾਂ ਕਥਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਪੀਲਾਤੋ ਯੀਸ਼ੁੰ ਬਹਿਰਾਨੀਯ ਨਿਸ੍ਤਾਰੋਤ੍ਸਵਸ੍ਯ ਆਸਾਦਨਦਿਨਸ੍ਯ ਦ੍ਵਿਤੀਯਪ੍ਰਹਰਾਤ੍ ਪੂਰ੍ੱਵੰ ਪ੍ਰਸ੍ਤਰਬਨ੍ਧਨਨਾਮ੍ਨਿ ਸ੍ਥਾਨੇ (ਅ)ਰ੍ਥਾਤ੍ ਇਬ੍ਰੀਯਭਾਸ਼਼ਯਾ ਯਦ੍ ਗੱਬਿਥਾ ਕਥ੍ਯਤੇ ਤਸ੍ਮਿਨ੍ ਸ੍ਥਾਨੇ ਵਿਚਾਰਾਸਨ ਉਪਾਵਿਸ਼ਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ਅਨਨ੍ਤਰੰ ਪੀਲਾਤੋ ਯਿਹੂਦੀਯਾਨ੍ ਅਵਦਤ੍, ਯੁਸ਼਼੍ਮਾਕੰ ਰਾਜਾਨੰ ਪਸ਼੍ਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","ਕਿਨ੍ਤੁ ਏਨੰ ਦੂਰੀਕੁਰੁ, ਏਨੰ ਦੂਰੀਕੁਰੁ, ਏਨੰ ਕ੍ਰੁਸ਼ੇ ਵਿਧ, ਇਤਿ ਕਥਾਂ ਕਥਯਿਤ੍ਵਾ ਤੇ ਰਵਿਤੁਮ੍ ਆਰਭਨ੍ਤ; ਤਦਾ ਪੀਲਾਤਃ ਕਥਿਤਵਾਨ੍ ਯੁਸ਼਼੍ਮਾਕੰ ਰਾਜਾਨੰ ਕਿੰ ਕ੍ਰੁਸ਼ੇ ਵੇਧਿਸ਼਼੍ਯਾਮਿ? ਪ੍ਰਧਾਨਯਾਜਕਾ ਉੱਤਰਮ੍ ਅਵਦਨ੍ ਕੈਸਰੰ ਵਿਨਾ ਕੋਪਿ ਰਾਜਾਸ੍ਮਾਕੰ ਨਾਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","ਤਤਃ ਪੀਲਾਤੋ ਯੀਸ਼ੁੰ ਕ੍ਰੁਸ਼ੇ ਵੇਧਿਤੁੰ ਤੇਸ਼਼ਾਂ ਹਸ੍ਤੇਸ਼਼ੁ ਸਮਾਰ੍ਪਯਤ੍, ਤਤਸ੍ਤੇ ਤੰ ਧ੍ਰੁʼਤ੍ਵਾ ਨੀਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ਤਤਃ ਪਰੰ ਯੀਸ਼ੁਃ ਕ੍ਰੁਸ਼ੰ ਵਹਨ੍ ਸ਼ਿਰਃਕਪਾਲਮ੍ ਅਰ੍ਥਾਦ੍ ਯਦ੍ ਇਬ੍ਰੀਯਭਾਸ਼਼ਯਾ ਗੁਲ੍ਗਲ੍ਤਾਂ ਵਦਨ੍ਤਿ ਤਸ੍ਮਿਨ੍ ਸ੍ਥਾਨ ਉਪਸ੍ਥਿਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ਤਤਸ੍ਤੇ ਮਧ੍ਯਸ੍ਥਾਨੇ ਤੰ ਤਸ੍ਯੋਭਯਪਾਰ੍ਸ਼੍ਵੇ ਦ੍ਵਾਵਪਰੌ ਕ੍ਰੁਸ਼ੇ(ਅ)ਵਿਧਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","ਅਪਰਮ੍ ਏਸ਼਼ ਯਿਹੂਦੀਯਾਨਾਂ ਰਾਜਾ ਨਾਸਰਤੀਯਯੀਸ਼ੁਃ, ਇਤਿ ਵਿਜ੍ਞਾਪਨੰ ਲਿਖਿਤ੍ਵਾ ਪੀਲਾਤਸ੍ਤਸ੍ਯ ਕ੍ਰੁਸ਼ੋਪਰਿ ਸਮਯੋਜਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","ਸਾ ਲਿਪਿਃ ਇਬ੍ਰੀਯਯੂਨਾਨੀਯਰੋਮੀਯਭਾਸ਼਼ਾਭਿ ਰ੍ਲਿਖਿਤਾ; ਯੀਸ਼ੋਃ ਕ੍ਰੁਸ਼ਵੇਧਨਸ੍ਥਾਨੰ ਨਗਰਸ੍ਯ ਸਮੀਪੰ, ਤਸ੍ਮਾਦ੍ ਬਹਵੋ ਯਿਹੂਦੀਯਾਸ੍ਤਾਂ ਪਠਿਤੁਮ੍ ਆਰਭਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","ਯਿਹੂਦੀਯਾਨਾਂ ਪ੍ਰਧਾਨਯਾਜਕਾਃ ਪੀਲਾਤਮਿਤਿ ਨ੍ਯਵੇਦਯਨ੍ ਯਿਹੂਦੀਯਾਨਾਂ ਰਾਜੇਤਿ ਵਾਕ੍ਯੰ ਨ ਕਿਨ੍ਤੁ ਏਸ਼਼ ਸ੍ਵੰ ਯਿਹੂਦੀਯਾਨਾਂ ਰਾਜਾਨਮ੍ ਅਵਦਦ੍ ਇੱਥੰ ਲਿਖਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ਤਤਃ ਪੀਲਾਤ ਉੱਤਰੰ ਦੱਤਵਾਨ੍ ਯੱਲੇਖਨੀਯੰ ਤੱਲਿਖਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ਇੱਥੰ ਸੇਨਾਗਣੋ ਯੀਸ਼ੁੰ ਕ੍ਰੁਸ਼ੇ ਵਿਧਿਤ੍ਵਾ ਤਸ੍ਯ ਪਰਿਧੇਯਵਸ੍ਤ੍ਰੰ ਚਤੁਰੋ ਭਾਗਾਨ੍ ਕ੍ਰੁʼਤ੍ਵਾ ਏਕੈਕਸੇਨਾ ਏਕੈਕਭਾਗਮ੍ ਅਗ੍ਰੁʼਹ੍ਲਤ੍ ਤਸ੍ਯੋੱਤਰੀਯਵਸ੍ਤ੍ਰਞ੍ਚਾਗ੍ਰੁʼਹ੍ਲਤ੍| ਕਿਨ੍ਤੂੱਤਰੀਯਵਸ੍ਤ੍ਰੰ ਸੂਚਿਸੇਵਨੰ ਵਿਨਾ ਸਰ੍ੱਵਮ੍ ਊਤੰ| ");
INSERT INTO sanpun_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ਤਸ੍ਮਾੱਤੇ ਵ੍ਯਾਹਰਨ੍ ਏਤਤ੍ ਕਃ ਪ੍ਰਾਪ੍ਸ੍ਯਤਿ? ਤੰਨ ਖਣ੍ਡਯਿਤ੍ਵਾ ਤਤ੍ਰ ਗੁਟਿਕਾਪਾਤੰ ਕਰਵਾਮ| ਵਿਭਜਨ੍ਤੇ(ਅ)ਧਰੀਯੰ ਮੇ ਵਸਨੰ ਤੇ ਪਰਸ੍ਪਰੰ| ਮਮੋੱਤਰੀਯਵਸ੍ਤ੍ਰਾਰ੍ਥੰ ਗੁਟਿਕਾਂ ਪਾਤਯਨ੍ਤਿ ਚ| ਇਤਿ ਯਦ੍ਵਾਕ੍ਯੰ ਧਰ੍ੰਮਪੁਸ੍ਤਕੇ ਲਿਖਿਤਮਾਸ੍ਤੇ ਤਤ੍ ਸੇਨਾਗਣੇਨੇੱਥੰ ਵ੍ਯਵਹਰਣਾਤ੍ ਸਿੱਧਮਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ਤਦਾਨੀਂ ਯੀਸ਼ੋ ਰ੍ਮਾਤਾ ਮਾਤੁ ਰ੍ਭਗਿਨੀ ਚ ਯਾ ਕ੍ਲਿਯਪਾ ਭਾਰ੍ੱਯਾ ਮਰਿਯਮ੍ ਮਗ੍ਦਲੀਨੀ ਮਰਿਯਮ੍ ਚ ਏਤਾਸ੍ਤਸ੍ਯ ਕ੍ਰੁਸ਼ਸ੍ਯ ਸੰਨਿਧੌ ਸਮਤਿਸ਼਼੍ਠਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ਤਤੋ ਯੀਸ਼ੁਃ ਸ੍ਵਮਾਤਰੰ ਪ੍ਰਿਯਤਮਸ਼ਿਸ਼਼੍ਯਞ੍ਚ ਸਮੀਪੇ ਦਣ੍ਡਾਯਮਾਨੌ ਵਿਲੋਕ੍ਯ ਮਾਤਰਮ੍ ਅਵਦਤ੍, ਹੇ ਯੋਸ਼਼ਿਦ੍ ਏਨੰ ਤਵ ਪੁਤ੍ਰੰ ਪਸ਼੍ਯ, ");
INSERT INTO sanpun_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ਸ਼ਿਸ਼਼੍ਯਨ੍ਤ੍ਵਵਦਤ੍, ਏਨਾਂ ਤਵ ਮਾਤਰੰ ਪਸ਼੍ਯ| ਤਤਃ ਸ ਸ਼ਿਸ਼਼੍ਯਸ੍ਤਦ੍ਘਟਿਕਾਯਾਂ ਤਾਂ ਨਿਜਗ੍ਰੁʼਹੰ ਨੀਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","ਅਨਨ੍ਤਰੰ ਸਰ੍ੱਵੰ ਕਰ੍ੰਮਾਧੁਨਾ ਸਮ੍ਪੰਨਮਭੂਤ੍ ਯੀਸ਼ੁਰਿਤਿ ਜ੍ਞਾਤ੍ਵਾ ਧਰ੍ੰਮਪੁਸ੍ਤਕਸ੍ਯ ਵਚਨੰ ਯਥਾ ਸਿੱਧੰ ਭਵਤਿ ਤਦਰ੍ਥਮ੍ ਅਕਥਯਤ੍ ਮਮ ਪਿਪਾਸਾ ਜਾਤਾ| ");
INSERT INTO sanpun_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ਤਤਸ੍ਤਸ੍ਮਿਨ੍ ਸ੍ਥਾਨੇ ਅਮ੍ਲਰਸੇਨ ਪੂਰ੍ਣਪਾਤ੍ਰਸ੍ਥਿਤ੍ਯਾ ਤੇ ਸ੍ਪਞ੍ਜਮੇਕੰ ਤਦਮ੍ਲਰਸੇਨਾਰ੍ਦ੍ਰੀਕ੍ਰੁʼਤ੍ਯ ਏਸੋਬ੍ਨਲੇ ਤਦ੍ ਯੋਜਯਿਤ੍ਵਾ ਤਸ੍ਯ ਮੁਖਸ੍ਯ ਸੰਨਿਧਾਵਸ੍ਥਾਪਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ਤਦਾ ਯੀਸ਼ੁਰਮ੍ਲਰਸੰ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਸਰ੍ੱਵੰ ਸਿੱਧਮ੍ ਇਤਿ ਕਥਾਂ ਕਥਯਿਤ੍ਵਾ ਮਸ੍ਤਕੰ ਨਮਯਨ੍ ਪ੍ਰਾਣਾਨ੍ ਪਰ੍ੱਯਤ੍ਯਜਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","ਤਦ੍ਵਿਨਮ੍ ਆਸਾਦਨਦਿਨੰ ਤਸ੍ਮਾਤ੍ ਪਰੇ(ਅ)ਹਨਿ ਵਿਸ਼੍ਰਾਮਵਾਰੇ ਦੇਹਾ ਯਥਾ ਕ੍ਰੁਸ਼ੋਪਰਿ ਨ ਤਿਸ਼਼੍ਠਨ੍ਤਿ, ਯਤਃ ਸ ਵਿਸ਼੍ਰਾਮਵਾਰੋ ਮਹਾਦਿਨਮਾਸੀਤ੍, ਤਸ੍ਮਾਦ੍ ਯਿਹੂਦੀਯਾਃ ਪੀਲਾਤਨਿਕਟੰ ਗਤ੍ਵਾ ਤੇਸ਼਼ਾਂ ਪਾਦਭਞ੍ਜਨਸ੍ਯ ਸ੍ਥਾਨਾਨ੍ਤਰਨਯਨਸ੍ਯ ਚਾਨੁਮਤਿੰ ਪ੍ਰਾਰ੍ਥਯਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ਅਤਃ ਸੇਨਾ ਆਗਤ੍ਯ ਯੀਸ਼ੁਨਾ ਸਹ ਕ੍ਰੁਸ਼ੇ ਹਤਯੋਃ ਪ੍ਰਥਮਦ੍ਵਿਤੀਯਚੋਰਯੋਃ ਪਾਦਾਨ੍ ਅਭਞ੍ਜਨ੍; ");
INSERT INTO sanpun_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ਕਿਨ੍ਤੁ ਯੀਸ਼ੋਃ ਸੰਨਿਧਿੰ ਗਤ੍ਵਾ ਸ ਮ੍ਰੁʼਤ ਇਤਿ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਤਸ੍ਯ ਪਾਦੌ ਨਾਭਞ੍ਜਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","ਪਸ਼੍ਚਾਦ੍ ਏਕੋ ਯੋੱਧਾ ਸ਼ੂਲਾਘਾਤੇਨ ਤਸ੍ਯ ਕੁਕ੍ਸ਼਼ਿਮ੍ ਅਵਿਧਤ੍ ਤਤ੍ਕ੍ਸ਼਼ਣਾਤ੍ ਤਸ੍ਮਾਦ੍ ਰਕ੍ਤੰ ਜਲਞ੍ਚ ਨਿਰਗੱਛਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","ਯੋ ਜਨੋ(ਅ)ਸ੍ਯ ਸਾਕ੍ਸ਼਼੍ਯੰ ਦਦਾਤਿ ਸ ਸ੍ਵਯੰ ਦ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍ ਤਸ੍ਯੇਦੰ ਸਾਕ੍ਸ਼਼੍ਯੰ ਸਤ੍ਯੰ ਤਸ੍ਯ ਕਥਾ ਯੁਸ਼਼੍ਮਾਕੰ ਵਿਸ਼੍ਵਾਸੰ ਜਨਯਿਤੁੰ ਯੋਗ੍ਯਾ ਤਤ੍ ਸ ਜਾਨਾਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","ਤਸ੍ਯੈਕਮ੍ ਅਸ੍ਧ੍ਯਪਿ ਨ ਭੰਕ੍ਸ਼਼੍ਯਤੇ, ");
INSERT INTO sanpun_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ਤਦ੍ਵਦ੍ ਅਨ੍ਯਸ਼ਾਸ੍ਤ੍ਰੇਪਿ ਲਿਖ੍ਯਤੇ, ਯਥਾ, \"ਦ੍ਰੁʼਸ਼਼੍ਟਿਪਾਤੰ ਕਰਿਸ਼਼੍ਯਨ੍ਤਿ ਤੇ(ਅ)ਵਿਧਨ੍ ਯਨ੍ਤੁ ਤਮ੍ਪ੍ਰਤਿ| \" ");
INSERT INTO sanpun_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","ਅਰਿਮਥੀਯਨਗਰਸ੍ਯ ਯੂਸ਼਼ਫ੍ਨਾਮਾ ਸ਼ਿਸ਼਼੍ਯ ਏਕ ਆਸੀਤ੍ ਕਿਨ੍ਤੁ ਯਿਹੂਦੀਯੇਭ੍ਯੋ ਭਯਾਤ੍ ਪ੍ਰਕਾਸ਼ਿਤੋ ਨ ਭਵਤਿ; ਸ ਯੀਸ਼ੋ ਰ੍ਦੇਹੰ ਨੇਤੁੰ ਪੀਲਾਤਸ੍ਯਾਨੁਮਤਿੰ ਪ੍ਰਾਰ੍ਥਯਤ, ਤਤਃ ਪੀਲਾਤੇਨਾਨੁਮਤੇ ਸਤਿ ਸ ਗਤ੍ਵਾ ਯੀਸ਼ੋ ਰ੍ਦੇਹਮ੍ ਅਨਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ਅਪਰੰ ਯੋ ਨਿਕਦੀਮੋ ਰਾਤ੍ਰੌ ਯੀਸ਼ੋਃ ਸਮੀਪਮ੍ ਅਗੱਛਤ੍ ਸੋਪਿ ਗਨ੍ਧਰਸੇਨ ਮਿਸ਼੍ਰਿਤੰ ਪ੍ਰਾਯੇਣ ਪਞ੍ਚਾਸ਼ਤ੍ਸੇਟਕਮਗੁਰੁੰ ਗ੍ਰੁʼਹੀਤ੍ਵਾਗੱਛਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ਤਤਸ੍ਤੇ ਯਿਹੂਦੀਯਾਨਾਂ ਸ਼੍ਮਸ਼ਾਨੇ ਸ੍ਥਾਪਨਰੀਤ੍ਯਨੁਸਾਰੇਣ ਤਤ੍ਸੁਗਨ੍ਧਿਦ੍ਰਵ੍ਯੇਣ ਸਹਿਤੰ ਤਸ੍ਯ ਦੇਹੰ ਵਸ੍ਤ੍ਰੇਣਾਵੇਸ਼਼੍ਟਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","ਅਪਰਞ੍ਚ ਯਤ੍ਰ ਸ੍ਥਾਨੇ ਤੰ ਕ੍ਰੁਸ਼ੇ(ਅ)ਵਿਧਨ੍ ਤਸ੍ਯ ਨਿਕਟਸ੍ਥੋਦ੍ਯਾਨੇ ਯਤ੍ਰ ਕਿਮਪਿ ਮ੍ਰੁʼਤਦੇਹੰ ਕਦਾਪਿ ਨਾਸ੍ਥਾਪ੍ਯਤ ਤਾਦ੍ਰੁʼਸ਼ਮ੍ ਏਕੰ ਨੂਤਨੰ ਸ਼੍ਮਸ਼ਾਨਮ੍ ਆਸੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","ਯਿਹੂਦੀਯਾਨਾਮ੍ ਆਸਾਦਨਦਿਨਾਗਮਨਾਤ੍ ਤੇ ਤਸ੍ਮਿਨ੍ ਸਮੀਪਸ੍ਥਸ਼੍ਮਸ਼ਾਨੇ ਯੀਸ਼ੁਮ੍ ਅਸ਼ਾਯਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","ਅਨਨ੍ਤਰੰ ਸਪ੍ਤਾਹਸ੍ਯ ਪ੍ਰਥਮਦਿਨੇ (ਅ)ਤਿਪ੍ਰਤ੍ਯੂਸ਼਼ੇ (ਅ)ਨ੍ਧਕਾਰੇ ਤਿਸ਼਼੍ਠਤਿ ਮਗ੍ਦਲੀਨੀ ਮਰਿਯਮ੍ ਤਸ੍ਯ ਸ਼੍ਮਸ਼ਾਨਸ੍ਯ ਨਿਕਟੰ ਗਤ੍ਵਾ ਸ਼੍ਮਸ਼ਾਨਸ੍ਯ ਮੁਖਾਤ੍ ਪ੍ਰਸ੍ਤਰਮਪਸਾਰਿਤਮ੍ ਅਪਸ਼੍ਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","ਪਸ਼੍ਚਾਦ੍ ਧਾਵਿਤ੍ਵਾ ਸ਼ਿਮੋਨ੍ਪਿਤਰਾਯ ਯੀਸ਼ੋਃ ਪ੍ਰਿਯਤਮਸ਼ਿਸ਼਼੍ਯਾਯ ਚੇਦਮ੍ ਅਕਥਯਤ੍, ਲੋਕਾਃ ਸ਼੍ਮਸ਼ਾਨਾਤ੍ ਪ੍ਰਭੁੰ ਨੀਤ੍ਵਾ ਕੁਤ੍ਰਾਸ੍ਥਾਪਯਨ੍ ਤਦ੍ ਵਕ੍ਤੁੰ ਨ ਸ਼ਕ੍ਨੋਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","ਅਤਃ ਪਿਤਰਃ ਸੋਨ੍ਯਸ਼ਿਸ਼਼੍ਯਸ਼੍ਚ ਬਰ੍ਹਿ ਰ੍ਭੁਤ੍ਵਾ ਸ਼੍ਮਸ਼ਾਨਸ੍ਥਾਨੰ ਗਨ੍ਤੁਮ੍ ਆਰਭੇਤਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ਉਭਯੋਰ੍ਧਾਵਤੋਃ ਸੋਨ੍ਯਸ਼ਿਸ਼਼੍ਯਃ ਪਿਤਰੰ ਪਸ਼੍ਚਾਤ੍ ਤ੍ਯਕ੍ਤ੍ਵਾ ਪੂਰ੍ੱਵੰ ਸ਼੍ਮਸ਼ਾਨਸ੍ਥਾਨ ਉਪਸ੍ਥਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ਤਦਾ ਪ੍ਰਹ੍ਵੀਭੂਯ ਸ੍ਥਾਪਿਤਵਸ੍ਤ੍ਰਾਣਿ ਦ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍ ਕਿਨ੍ਤੁ ਨ ਪ੍ਰਾਵਿਸ਼ਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","ਅਪਰੰ ਸ਼ਿਮੋਨ੍ਪਿਤਰ ਆਗਤ੍ਯ ਸ਼੍ਮਸ਼ਾਨਸ੍ਥਾਨੰ ਪ੍ਰਵਿਸ਼੍ਯ ");
INSERT INTO sanpun_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ਸ੍ਥਾਪਿਤਵਸ੍ਤ੍ਰਾਣਿ ਮਸ੍ਤਕਸ੍ਯ ਵਸ੍ਤ੍ਰਞ੍ਚ ਪ੍ਰੁʼਥਕ੍ ਸ੍ਥਾਨਾਨ੍ਤਰੇ ਸ੍ਥਾਪਿਤੰ ਦ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","ਤਤਃ ਸ਼੍ਮਸ਼ਾਨਸ੍ਥਾਨੰ ਪੂਰ੍ੱਵਮ੍ ਆਗਤੋ ਯੋਨ੍ਯਸ਼ਿਸ਼਼੍ਯਃ ਸੋਪਿ ਪ੍ਰਵਿਸ਼੍ਯ ਤਾਦ੍ਰੁʼਸ਼ੰ ਦ੍ਰੁʼਸ਼਼੍ਟਾ ਵ੍ਯਸ਼੍ਵਸੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","ਯਤਃ ਸ਼੍ਮਸ਼ਾਨਾਤ੍ ਸ ਉੱਥਾਪਯਿਤਵ੍ਯ ਏਤਸ੍ਯ ਧਰ੍ੰਮਪੁਸ੍ਤਕਵਚਨਸ੍ਯ ਭਾਵੰ ਤੇ ਤਦਾ ਵੋੱਧੁੰ ਨਾਸ਼ਨ੍ਕੁਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","ਅਨਨ੍ਤਰੰ ਤੌ ਦ੍ਵੌ ਸ਼ਿਸ਼਼੍ਯੌ ਸ੍ਵੰ ਸ੍ਵੰ ਗ੍ਰੁʼਹੰ ਪਰਾਵ੍ਰੁʼਤ੍ਯਾਗੱਛਤਾਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","ਤਤਃ ਪਰੰ ਮਰਿਯਮ੍ ਸ਼੍ਮਸ਼ਾਨਦ੍ਵਾਰਸ੍ਯ ਬਹਿਃ ਸ੍ਥਿਤ੍ਵਾ ਰੋਦਿਤੁਮ੍ ਆਰਭਤ ਤਤੋ ਰੁਦਤੀ ਪ੍ਰਹ੍ਵੀਭੂਯ ਸ਼੍ਮਸ਼ਾਨੰ ਵਿਲੋਕ੍ਯ ");
INSERT INTO sanpun_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ਯੀਸ਼ੋਃ ਸ਼ਯਨਸ੍ਥਾਨਸ੍ਯ ਸ਼ਿਰਃਸ੍ਥਾਨੇ ਪਦਤਲੇ ਚ ਦ੍ਵਯੋ ਰ੍ਦਿਸ਼ੋ ਦ੍ਵੌ ਸ੍ਵਰ੍ਗੀਯਦੂਤਾਵੁਪਵਿਸ਼਼੍ਟੌ ਸਮਪਸ਼੍ਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","ਤੌ ਪ੍ਰੁʼਸ਼਼੍ਟਵਨ੍ਤੌ ਹੇ ਨਾਰਿ ਕੁਤੋ ਰੋਦਿਸ਼਼ਿ? ਸਾਵਦਤ੍ ਲੋਕਾ ਮਮ ਪ੍ਰਭੁੰ ਨੀਤ੍ਵਾ ਕੁਤ੍ਰਾਸ੍ਥਾਪਯਨ੍ ਇਤਿ ਨ ਜਾਨਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ਇਤ੍ਯੁਕ੍ਤ੍ਵਾ ਮੁਖੰ ਪਰਾਵ੍ਰੁʼਤ੍ਯ ਯੀਸ਼ੁੰ ਦਣ੍ਡਾਯਮਾਨਮ੍ ਅਪਸ਼੍ਯਤ੍ ਕਿਨ੍ਤੁ ਸ ਯੀਸ਼ੁਰਿਤਿ ਸਾ ਜ੍ਞਾਤੁੰ ਨਾਸ਼ਕ੍ਨੋਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","ਤਦਾ ਯੀਸ਼ੁਸ੍ਤਾਮ੍ ਅਪ੍ਰੁʼੱਛਤ੍ ਹੇ ਨਾਰਿ ਕੁਤੋ ਰੋਦਿਸ਼਼ਿ? ਕੰ ਵਾ ਮ੍ਰੁʼਗਯਸੇ? ਤਤਃ ਸਾ ਤਮ੍ ਉਦ੍ਯਾਨਸੇਵਕੰ ਜ੍ਞਾਤ੍ਵਾ ਵ੍ਯਾਹਰਤ੍, ਹੇ ਮਹੇੱਛ ਤ੍ਵੰ ਯਦੀਤਃ ਸ੍ਥਾਨਾਤ੍ ਤੰ ਨੀਤਵਾਨ੍ ਤਰ੍ਹਿ ਕੁਤ੍ਰਾਸ੍ਥਾਪਯਸ੍ਤਦ੍ ਵਦ ਤਤ੍ਸ੍ਥਾਨਾਤ੍ ਤਮ੍ ਆਨਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","ਤਦਾ ਯੀਸ਼ੁਸ੍ਤਾਮ੍ ਅਵਦਤ੍ ਹੇ ਮਰਿਯਮ੍| ਤਤਃ ਸਾ ਪਰਾਵ੍ਰੁʼਤ੍ਯ ਪ੍ਰਤ੍ਯਵਦਤ੍ ਹੇ ਰੱਬੂਨੀ ਅਰ੍ਥਾਤ੍ ਹੇ ਗੁਰੋ| ");
INSERT INTO sanpun_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","ਤਦਾ ਯੀਸ਼ੁਰਵਦਤ੍ ਮਾਂ ਮਾ ਧਰ, ਇਦਾਨੀਂ ਪਿਤੁਃ ਸਮੀਪੇ ਊਰ੍ੱਧ੍ਵਗਮਨੰ ਨ ਕਰੋਮਿ ਕਿਨ੍ਤੁ ਯੋ ਮਮ ਯੁਸ਼਼੍ਮਾਕਞ੍ਚ ਪਿਤਾ ਮਮ ਯੁਸ਼਼੍ਮਾਕਞ੍ਚੇਸ਼੍ਵਰਸ੍ਤਸ੍ਯ ਨਿਕਟ ਊਰ੍ੱਧ੍ਵਗਮਨੰ ਕਰ੍ੱਤੁਮ੍ ਉਦ੍ਯਤੋਸ੍ਮਿ, ਇਮਾਂ ਕਥਾਂ ਤ੍ਵੰ ਗਤ੍ਵਾ ਮਮ ਭ੍ਰਾਤ੍ਰੁʼਗਣੰ ਜ੍ਞਾਪਯ| ");
INSERT INTO sanpun_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","ਤਤੋ ਮਗ੍ਦਲੀਨੀਮਰਿਯਮ੍ ਤਤ੍ਕ੍ਸ਼਼ਣਾਦ੍ ਗਤ੍ਵਾ ਪ੍ਰਭੁਸ੍ਤਸ੍ਯੈ ਦਰ੍ਸ਼ਨੰ ਦੱਤ੍ਵਾ ਕਥਾ ਏਤਾ ਅਕਥਯਦ੍ ਇਤਿ ਵਾਰ੍ੱਤਾਂ ਸ਼ਿਸ਼਼੍ਯੇਭ੍ਯੋ(ਅ)ਕਥਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ਤਤਃ ਪਰੰ ਸਪ੍ਤਾਹਸ੍ਯ ਪ੍ਰਥਮਦਿਨਸ੍ਯ ਸਨ੍ਧ੍ਯਾਸਮਯੇ ਸ਼ਿਸ਼਼੍ਯਾ ਏਕਤ੍ਰ ਮਿਲਿਤ੍ਵਾ ਯਿਹੂਦੀਯੇਭ੍ਯੋ ਭਿਯਾ ਦ੍ਵਾਰਰੁੱਧਮ੍ ਅਕੁਰ੍ੱਵਨ੍, ਏਤਸ੍ਮਿਨ੍ ਕਾਲੇ ਯੀਸ਼ੁਸ੍ਤੇਸ਼਼ਾਂ ਮਧ੍ਯਸ੍ਥਾਨੇ ਤਿਸ਼਼੍ਠਨ੍ ਅਕਥਯਦ੍ ਯੁਸ਼਼੍ਮਾਕੰ ਕਲ੍ਯਾਣੰ ਭੂਯਾਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ਇਤ੍ਯੁਕ੍ਤ੍ਵਾ ਨਿਜਹਸ੍ਤੰ ਕੁਕ੍ਸ਼਼ਿਞ੍ਚ ਦਰ੍ਸ਼ਿਤਵਾਨ੍, ਤਤਃ ਸ਼ਿਸ਼਼੍ਯਾਃ ਪ੍ਰਭੁੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਹ੍ਰੁʼਸ਼਼੍ਟਾ ਅਭਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ਯੀਸ਼ੁਃ ਪੁਨਰਵਦਦ੍ ਯੁਸ਼਼੍ਮਾਕੰ ਕਲ੍ਯਾਣੰ ਭੂਯਾਤ੍ ਪਿਤਾ ਯਥਾ ਮਾਂ ਪ੍ਰੈਸ਼਼ਯਤ੍ ਤਥਾਹਮਪਿ ਯੁਸ਼਼੍ਮਾਨ੍ ਪ੍ਰੇਸ਼਼ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ਇਤ੍ਯੁਕ੍ਤ੍ਵਾ ਸ ਤੇਸ਼਼ਾਮੁਪਰਿ ਦੀਰ੍ਘਪ੍ਰਸ਼੍ਵਾਸੰ ਦੱਤ੍ਵਾ ਕਥਿਤਵਾਨ੍ ਪਵਿਤ੍ਰਮ੍ ਆਤ੍ਮਾਨੰ ਗ੍ਰੁʼਹ੍ਲੀਤ| ");
INSERT INTO sanpun_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","ਯੂਯੰ ਯੇਸ਼਼ਾਂ ਪਾਪਾਨਿ ਮੋਚਯਿਸ਼਼੍ਯਥ ਤੇ ਮੋਚਯਿਸ਼਼੍ਯਨ੍ਤੇ ਯੇਸ਼਼ਾਞ੍ਚ ਪਾਪਾਤਿ ਨ ਮੋਚਯਿਸ਼਼੍ਯਥ ਤੇ ਨ ਮੋਚਯਿਸ਼਼੍ਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","ਦ੍ਵਾਦਸ਼ਮਧ੍ਯੇ ਗਣਿਤੋ ਯਮਜੋ ਥੋਮਾਨਾਮਾ ਸ਼ਿਸ਼਼੍ਯੋ ਯੀਸ਼ੋਰਾਗਮਨਕਾਲੈ ਤੈਃ ਸਾਰ੍ੱਧੰ ਨਾਸੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","ਅਤੋ ਵਯੰ ਪ੍ਰਭੂਮ੍ ਅਪਸ਼੍ਯਾਮੇਤਿ ਵਾਕ੍ਯੇ(ਅ)ਨ੍ਯਸ਼ਿਸ਼਼੍ਯੈਰੁਕ੍ਤੇ ਸੋਵਦਤ੍, ਤਸ੍ਯ ਹਸ੍ਤਯੋ ਰ੍ਲੌਹਕੀਲਕਾਨਾਂ ਚਿਹ੍ਨੰ ਨ ਵਿਲੋਕ੍ਯ ਤੱਚਿਹ੍ਨਮ੍ ਅਙ੍ਗੁਲ੍ਯਾ ਨ ਸ੍ਪ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਤਸ੍ਯ ਕੁਕ੍ਸ਼਼ੌ ਹਸ੍ਤੰ ਨਾਰੋਪ੍ਯ ਚਾਹੰ ਨ ਵਿਸ਼੍ਵਸਿਸ਼਼੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","ਅਪਰਮ੍ ਅਸ਼਼੍ਟਮੇ(ਅ)ਹ੍ਨਿ ਗਤੇ ਸਤਿ ਥੋਮਾਸਹਿਤਃ ਸ਼ਿਸ਼਼੍ਯਗਣ ਏਕਤ੍ਰ ਮਿਲਿਤ੍ਵਾ ਦ੍ਵਾਰੰ ਰੁੱਧ੍ਵਾਭ੍ਯਨ੍ਤਰ ਆਸੀਤ੍, ਏਤਰ੍ਹਿ ਯੀਸ਼ੁਸ੍ਤੇਸ਼਼ਾਂ ਮਧ੍ਯਸ੍ਥਾਨੇ ਤਿਸ਼਼੍ਠਨ੍ ਅਕਥਯਤ੍, ਯੁਸ਼਼੍ਮਾਕੰ ਕੁਸ਼ਲੰ ਭੂਯਾਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","ਪਸ਼੍ਚਾਤ੍ ਥਾਮੈ ਕਥਿਤਵਾਨ੍ ਤ੍ਵਮ੍ ਅਙ੍ਗੁਲੀਮ੍ ਅਤ੍ਰਾਰ੍ਪਯਿਤ੍ਵਾ ਮਮ ਕਰੌ ਪਸ਼੍ਯ ਕਰੰ ਪ੍ਰਸਾਰ੍ੱਯ ਮਮ ਕੁਕ੍ਸ਼਼ਾਵਰ੍ਪਯ ਨਾਵਿਸ਼੍ਵਸ੍ਯ| ");
INSERT INTO sanpun_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ਤਦਾ ਥੋਮਾ ਅਵਦਤ੍, ਹੇ ਮਮ ਪ੍ਰਭੋ ਹੇ ਮਦੀਸ਼੍ਵਰ| ");
INSERT INTO sanpun_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","ਯੀਸ਼ੁਰਕਥਯਤ੍, ਹੇ ਥੋਮਾ ਮਾਂ ਨਿਰੀਕ੍ਸ਼਼੍ਯ ਵਿਸ਼੍ਵਸਿਸ਼਼ਿ ਯੇ ਨ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਵਿਸ਼੍ਵਸਨ੍ਤਿ ਤਏਵ ਧਨ੍ਯਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ਏਤਦਨ੍ਯਾਨਿ ਪੁਸ੍ਤਕੇ(ਅ)ਸ੍ਮਿਨ੍ ਅਲਿਖਿਤਾਨਿ ਬਹੂਨ੍ਯਾਸ਼੍ਚਰ੍ੱਯਕਰ੍ੰਮਾਣਿ ਯੀਸ਼ੁਃ ਸ਼ਿਸ਼਼੍ਯਾਣਾਂ ਪੁਰਸ੍ਤਾਦ੍ ਅਕਰੋਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ਕਿਨ੍ਤੁ ਯੀਸ਼ੁਰੀਸ਼੍ਵਰਸ੍ਯਾਭਿਸ਼਼ਿਕ੍ਤਃ ਸੁਤ ਏਵੇਤਿ ਯਥਾ ਯੂਯੰ ਵਿਸ਼੍ਵਸਿਥ ਵਿਸ਼੍ਵਸ੍ਯ ਚ ਤਸ੍ਯ ਨਾਮ੍ਨਾ ਪਰਮਾਯੁਃ ਪ੍ਰਾਪ੍ਨੁਥ ਤਦਰ੍ਥਮ੍ ਏਤਾਨਿ ਸਰ੍ੱਵਾਣ੍ਯਲਿਖ੍ਯਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","ਤਤਃ ਪਰੰ ਤਿਬਿਰਿਯਾਜਲਧੇਸ੍ਤਟੇ ਯੀਸ਼ੁਃ ਪੁਨਰਪਿ ਸ਼ਿਸ਼਼੍ਯੇਭ੍ਯੋ ਦਰ੍ਸ਼ਨੰ ਦੱਤਵਾਨ੍ ਦਰ੍ਸ਼ਨਸ੍ਯਾਖ੍ਯਾਨਮਿਦਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ਸ਼ਿਮੋਨ੍ਪਿਤਰਃ ਯਮਜਥੋਮਾ ਗਾਲੀਲੀਯਕਾੰਨਾਨਗਰਨਿਵਾਸੀ ਨਿਥਨੇਲ੍ ਸਿਵਦੇਃ ਪੁਤ੍ਰਾਵਨ੍ਯੌ ਦ੍ਵੌ ਸ਼ਿਸ਼਼੍ਯੌ ਚੈਤੇਸ਼਼੍ਵੇਕਤ੍ਰ ਮਿਲਿਤੇਸ਼਼ੁ ਸ਼ਿਮੋਨ੍ਪਿਤਰੋ(ਅ)ਕਥਯਤ੍ ਮਤ੍ਸ੍ਯਾਨ੍ ਧਰ੍ਤੁੰ ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ਤਤਸ੍ਤੇ ਵ੍ਯਾਹਰਨ੍ ਤਰ੍ਹਿ ਵਯਮਪਿ ਤ੍ਵਯਾ ਸਾਰ੍ੱਧੰ ਯਾਮਃ ਤਦਾ ਤੇ ਬਹਿਰ੍ਗਤਾਃ ਸਨ੍ਤਃ ਕ੍ਸ਼਼ਿਪ੍ਰੰ ਨਾਵਮ੍ ਆਰੋਹਨ੍ ਕਿਨ੍ਤੁ ਤਸ੍ਯਾਂ ਰਜਨ੍ਯਾਮ੍ ਏਕਮਪਿ ਨ ਪ੍ਰਾਪ੍ਨੁਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","ਪ੍ਰਭਾਤੇ ਸਤਿ ਯੀਸ਼ੁਸ੍ਤਟੇ ਸ੍ਥਿਤਵਾਨ੍ ਕਿਨ੍ਤੁ ਸ ਯੀਸ਼ੁਰਿਤਿ ਸ਼ਿਸ਼਼੍ਯਾ ਜ੍ਞਾਤੁੰ ਨਾਸ਼ਕ੍ਨੁਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","ਤਦਾ ਯੀਸ਼ੁਰਪ੍ਰੁʼੱਛਤ੍, ਹੇ ਵਤ੍ਸਾ ਸੰਨਿਧੌ ਕਿਞ੍ਚਿਤ੍ ਖਾਦ੍ਯਦ੍ਰਵ੍ਯਮ੍ ਆਸ੍ਤੇ? ਤੇ(ਅ)ਵਦਨ੍ ਕਿਮਪਿ ਨਾਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ਤਦਾ ਸੋ(ਅ)ਵਦਤ੍ ਨੌਕਾਯਾ ਦਕ੍ਸ਼਼ਿਣਪਾਰ੍ਸ਼੍ਵੇ ਜਾਲੰ ਨਿਕ੍ਸ਼਼ਿਪਤ ਤਤੋ ਲਪ੍ਸ੍ਯਧ੍ਵੇ, ਤਸ੍ਮਾਤ੍ ਤੈ ਰ੍ਨਿਕ੍ਸ਼਼ਿਪ੍ਤੇ ਜਾਲੇ ਮਤ੍ਸ੍ਯਾ ਏਤਾਵਨ੍ਤੋ(ਅ)ਪਤਨ੍ ਯੇਨ ਤੇ ਜਾਲਮਾਕ੍ਰੁʼਸ਼਼੍ਯ ਨੋੱਤੋਲਯਿਤੁੰ ਸ਼ਕ੍ਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","ਤਸ੍ਮਾਦ੍ ਯੀਸ਼ੋਃ ਪ੍ਰਿਯਤਮਸ਼ਿਸ਼਼੍ਯਃ ਪਿਤਰਾਯਾਕਥਯਤ੍ ਏਸ਼਼ ਪ੍ਰਭੁ ਰ੍ਭਵੇਤ੍, ਏਸ਼਼ ਪ੍ਰਭੁਰਿਤਿ ਵਾਚੰ ਸ਼੍ਰੁਤ੍ਵੈਵ ਸ਼ਿਮੋਨ੍ ਨਗ੍ਨਤਾਹੇਤੋ ਰ੍ਮਤ੍ਸ੍ਯਧਾਰਿਣ ਉੱਤਰੀਯਵਸ੍ਤ੍ਰੰ ਪਰਿਧਾਯ ਹ੍ਰਦੰ ਪ੍ਰਤ੍ਯੁਦਲਮ੍ਫਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","ਅਪਰੇ ਸ਼ਿਸ਼਼੍ਯਾ ਮਤ੍ਸ੍ਯੈਃ ਸਾਰ੍ੱਧੰ ਜਾਲਮ੍ ਆਕਰ੍ਸ਼਼ਨ੍ਤਃ ਕ੍ਸ਼਼ੁਦ੍ਰਨੌਕਾਂ ਵਾਹਯਿਤ੍ਵਾ ਕੂਲਮਾਨਯਨ੍ ਤੇ ਕੂਲਾਦ੍ ਅਤਿਦੂਰੇ ਨਾਸਨ੍ ਦ੍ਵਿਸ਼ਤਹਸ੍ਤੇਭ੍ਯੋ ਦੂਰ ਆਸਨ੍ ਇਤ੍ਯਨੁਮੀਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","ਤੀਰੰ ਪ੍ਰਾਪ੍ਤੈਸ੍ਤੈਸ੍ਤਤ੍ਰ ਪ੍ਰਜ੍ਵਲਿਤਾਗ੍ਨਿਸ੍ਤਦੁਪਰਿ ਮਤ੍ਸ੍ਯਾਃ ਪੂਪਾਸ਼੍ਚ ਦ੍ਰੁʼਸ਼਼੍ਟਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ਤਤੋ ਯੀਸ਼ੁਰਕਥਯਦ੍ ਯਾਨ੍ ਮਤ੍ਸ੍ਯਾਨ੍ ਅਧਰਤ ਤੇਸ਼਼ਾਂ ਕਤਿਪਯਾਨ੍ ਆਨਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ਅਤਃ ਸ਼ਿਮੋਨ੍ਪਿਤਰਃ ਪਰਾਵ੍ਰੁʼਤ੍ਯ ਗਤ੍ਵਾ ਬ੍ਰੁʼਹਦ੍ਭਿਸ੍ਤ੍ਰਿਪਞ੍ਚਾਸ਼ਦਧਿਕਸ਼ਤਮਤ੍ਸ੍ਯੈਃ ਪਰਿਪੂਰ੍ਣੰ ਤੱਜਾਲਮ੍ ਆਕ੍ਰੁʼਸ਼਼੍ਯੋਦਤੋਲਯਤ੍ ਕਿਨ੍ਤ੍ਵੇਤਾਵਦ੍ਭਿ ਰ੍ਮਤ੍ਸ੍ਯੈਰਪਿ ਜਾਲੰ ਨਾਛਿਦ੍ਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","ਅਨਨ੍ਤਰੰ ਯੀਸ਼ੁਸ੍ਤਾਨ੍ ਅਵਾਦੀਤ੍ ਯੂਯਮਾਗਤ੍ਯ ਭੁੰਗ੍ਧ੍ਵੰ; ਤਦਾ ਸਏਵ ਪ੍ਰਭੁਰਿਤਿ ਜ੍ਞਾਤਤ੍ਵਾਤ੍ ਤ੍ਵੰ ਕਃ? ਇਤਿ ਪ੍ਰਸ਼਼੍ਟੁੰ ਸ਼ਿਸ਼਼੍ਯਾਣਾਂ ਕਸ੍ਯਾਪਿ ਪ੍ਰਗਲ੍ਭਤਾ ਨਾਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ਤਤੋ ਯੀਸ਼ੁਰਾਗਤ੍ਯ ਪੂਪਾਨ੍ ਮਤ੍ਸ੍ਯਾਂਸ਼੍ਚ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਤੇਭ੍ਯਃ ਪਰ੍ੱਯਵੇਸ਼਼ਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ਇੱਥੰ ਸ਼੍ਮਸ਼ਾਨਾਦੁੱਥਾਨਾਤ੍ ਪਰੰ ਯੀਸ਼ੁਃ ਸ਼ਿਸ਼਼੍ਯੇਭ੍ਯਸ੍ਤ੍ਰੁʼਤੀਯਵਾਰੰ ਦਰ੍ਸ਼ਨੰ ਦੱਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ਭੋਜਨੇ ਸਮਾਪ੍ਤੇ ਸਤਿ ਯੀਸ਼ੁਃ ਸ਼ਿਮੋਨ੍ਪਿਤਰੰ ਪ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍, ਹੇ ਯੂਨਸਃ ਪੁਤ੍ਰ ਸ਼ਿਮੋਨ੍ ਤ੍ਵੰ ਕਿਮ੍ ਏਤੇਭ੍ਯੋਧਿਕੰ ਮਯਿ ਪ੍ਰੀਯਸੇ? ਤਤਃ ਸ ਉਦਿਤਵਾਨ੍ ਸਤ੍ਯੰ ਪ੍ਰਭੋ ਤ੍ਵਯਿ ਪ੍ਰੀਯੇ(ਅ)ਹੰ ਤਦ੍ ਭਵਾਨ੍ ਜਾਨਾਤਿ; ਤਦਾ ਯੀਸ਼ੁਰਕਥਯਤ੍ ਤਰ੍ਹਿ ਮਮ ਮੇਸ਼਼ਸ਼ਾਵਕਗਣੰ ਪਾਲਯ| ");
INSERT INTO sanpun_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ਤਤਃ ਸ ਦ੍ਵਿਤੀਯਵਾਰੰ ਪ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍ ਹੇ ਯੂਨਸਃ ਪੁਤ੍ਰ ਸ਼ਿਮੋਨ੍ ਤ੍ਵੰ ਕਿੰ ਮਯਿ ਪ੍ਰੀਯਸੇ? ਤਤਃ ਸ ਉਕ੍ਤਵਾਨ੍ ਸਤ੍ਯੰ ਪ੍ਰਭੋ ਤ੍ਵਯਿ ਪ੍ਰੀਯੇ(ਅ)ਹੰ ਤਦ੍ ਭਵਾਨ੍ ਜਾਨਾਤਿ; ਤਦਾ ਯੀਸ਼ੁਰਕਥਯਤ ਤਰ੍ਹਿ ਮਮ ਮੇਸ਼਼ਗਣੰ ਪਾਲਯ| ");
INSERT INTO sanpun_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ਪਸ਼੍ਚਾਤ੍ ਸ ਤ੍ਰੁʼਤੀਯਵਾਰੰ ਪ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍, ਹੇ ਯੂਨਸਃ ਪੁਤ੍ਰ ਸ਼ਿਮੋਨ੍ ਤ੍ਵੰ ਕਿੰ ਮਯਿ ਪ੍ਰੀਯਸੇ? ਏਤਦ੍ਵਾਕ੍ਯੰ ਤ੍ਰੁʼਤੀਯਵਾਰੰ ਪ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍ ਤਸ੍ਮਾਤ੍ ਪਿਤਰੋ ਦੁਃਖਿਤੋ ਭੂਤ੍ਵਾ(ਅ)ਕਥਯਤ੍ ਹੇ ਪ੍ਰਭੋ ਭਵਤਃ ਕਿਮਪ੍ਯਗੋਚਰੰ ਨਾਸ੍ਤਿ ਤ੍ਵੱਯਹੰ ਪ੍ਰੀਯੇ ਤਦ੍ ਭਵਾਨ੍ ਜਾਨਾਤਿ; ਤਤੋ ਯੀਸ਼ੁਰਵਦਤ੍ ਤਰ੍ਹਿ ਮਮ ਮੇਸ਼਼ਗਣੰ ਪਾਲਯ| ");
INSERT INTO sanpun_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","ਅਹੰ ਤੁਭ੍ਯੰ ਯਥਾਰ੍ਥੰ ਕਥਯਾਮਿ ਯੌਵਨਕਾਲੇ ਸ੍ਵਯੰ ਬੱਧਕਟਿ ਰ੍ਯਤ੍ਰੇੱਛਾ ਤਤ੍ਰ ਯਾਤਵਾਨ੍ ਕਿਨ੍ਤ੍ਵਿਤਃ ਪਰੰ ਵ੍ਰੁʼੱਧੇ ਵਯਸਿ ਹਸ੍ਤੰ ਵਿਸ੍ਤਾਰਯਿਸ਼਼੍ਯਸਿ, ਅਨ੍ਯਜਨਸ੍ਤ੍ਵਾਂ ਬੱਧ੍ਵਾ ਯਤ੍ਰ ਗਨ੍ਤੁੰ ਤਵੇੱਛਾ ਨ ਭਵਤਿ ਤ੍ਵਾਂ ਧ੍ਰੁʼਤ੍ਵਾ ਤਤ੍ਰ ਨੇਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ਫਲਤਃ ਕੀਦ੍ਰੁʼਸ਼ੇਨ ਮਰਣੇਨ ਸ ਈਸ਼੍ਵਰਸ੍ਯ ਮਹਿਮਾਨੰ ਪ੍ਰਕਾਸ਼ਯਿਸ਼਼੍ਯਤਿ ਤਦ੍ ਬੋਧਯਿਤੁੰ ਸ ਇਤਿ ਵਾਕ੍ਯੰ ਪ੍ਰੋਕ੍ਤਵਾਨ੍| ਇਤ੍ਯੁਕ੍ਤੇ ਸਤਿ ਸ ਤਮਵੋਚਤ੍ ਮਮ ਪਸ਼੍ਚਾਦ੍ ਆਗੱਛ| ");
INSERT INTO sanpun_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","ਯੋ ਜਨੋ ਰਾਤ੍ਰਿਕਾਲੇ ਯੀਸ਼ੋ ਰ੍ਵਕ੍ਸ਼਼ੋ(ਅ)ਵਲਮ੍ਬ੍ਯ, ਹੇ ਪ੍ਰਭੋ ਕੋ ਭਵਨ੍ਤੰ ਪਰਕਰੇਸ਼਼ੁ ਸਮਰ੍ਪਯਿਸ਼਼੍ਯਤੀਤਿ ਵਾਕ੍ਯੰ ਪ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍, ਤੰ ਯੀਸ਼ੋਃ ਪ੍ਰਿਯਤਮਸ਼ਿਸ਼਼੍ਯੰ ਪਸ਼੍ਚਾਦ੍ ਆਗੱਛਨ੍ਤੰ ");
INSERT INTO sanpun_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ਪਿਤਰੋ ਮੁਖੰ ਪਰਾਵਰ੍ੱਤ੍ਯ ਵਿਲੋਕ੍ਯ ਯੀਸ਼ੁੰ ਪ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍, ਹੇ ਪ੍ਰਭੋ ਏਤਸ੍ਯ ਮਾਨਵਸ੍ਯ ਕੀਦ੍ਰੁʼਸ਼ੀ ਗਤਿ ਰ੍ਭਵਿਸ਼਼੍ਯਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","ਸ ਪ੍ਰਤ੍ਯਵਦਤ੍, ਮਮ ਪੁਨਰਾਗਮਨਪਰ੍ੱਯਨ੍ਤੰ ਯਦਿ ਤੰ ਸ੍ਥਾਪਯਿਤੁਮ੍ ਇੱਛਾਮਿ ਤਤ੍ਰ ਤਵ ਕਿੰ? ਤ੍ਵੰ ਮਮ ਪਸ਼੍ਚਾਦ੍ ਆਗੱਛ| ");
INSERT INTO sanpun_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","ਤਸ੍ਮਾਤ੍ ਸ ਸ਼ਿਸ਼਼੍ਯੋ ਨ ਮਰਿਸ਼਼੍ਯਤੀਤਿ ਭ੍ਰਾਤ੍ਰੁʼਗਣਮਧ੍ਯੇ ਕਿੰਵਦਨ੍ਤੀ ਜਾਤਾ ਕਿਨ੍ਤੁ ਸ ਨ ਮਰਿਸ਼਼੍ਯਤੀਤਿ ਵਾਕ੍ਯੰ ਯੀਸ਼ੁ ਰ੍ਨਾਵਦਤ੍ ਕੇਵਲੰ ਮਮ ਪੁਨਰਾਗਮਨਪਰ੍ੱਯਨ੍ਤੰ ਯਦਿ ਤੰ ਸ੍ਥਾਪਯਿਤੁਮ੍ ਇੱਛਾਮਿ ਤਤ੍ਰ ਤਵ ਕਿੰ? ਇਤਿ ਵਾਕ੍ਯਮ੍ ਉਕ੍ਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","ਯੋ ਜਨ ਏਤਾਨਿ ਸਰ੍ੱਵਾਣਿ ਲਿਖਿਤਵਾਨ੍ ਅਤ੍ਰ ਸਾਕ੍ਸ਼਼੍ਯਞ੍ਚ ਦੱਤਵਾਨ੍ ਸਏਵ ਸ ਸ਼ਿਸ਼਼੍ਯਃ, ਤਸ੍ਯ ਸਾਕ੍ਸ਼਼੍ਯੰ ਪ੍ਰਮਾਣਮਿਤਿ ਵਯੰ ਜਾਨੀਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","ਯੀਸ਼ੁਰੇਤੇਭ੍ਯੋ(ਅ)ਪਰਾਣ੍ਯਪਿ ਬਹੂਨਿ ਕਰ੍ੰਮਾਣਿ ਕ੍ਰੁʼਤਵਾਨ੍ ਤਾਨਿ ਸਰ੍ੱਵਾਣਿ ਯਦ੍ਯੇਕੈਕੰ ਕ੍ਰੁʼਤ੍ਵਾ ਲਿਖ੍ਯਨ੍ਤੇ ਤਰ੍ਹਿ ਗ੍ਰਨ੍ਥਾ ਏਤਾਵਨ੍ਤੋ ਭਵਨ੍ਤਿ ਤੇਸ਼਼ਾਂ ਧਾਰਣੇ ਪ੍ਰੁʼਥਿਵ੍ਯਾਂ ਸ੍ਥਾਨੰ ਨ ਭਵਤਿ| ਇਤਿ||");
INSERT INTO sanpun_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","ਹੇ ਥਿਯਫਿਲ, ਯੀਸ਼ੁਃ ਸ੍ਵਮਨੋਨੀਤਾਨ੍ ਪ੍ਰੇਰਿਤਾਨ੍ ਪਵਿਤ੍ਰੇਣਾਤ੍ਮਨਾ ਸਮਾਦਿਸ਼੍ਯ ਯਸ੍ਮਿਨ੍ ਦਿਨੇ ਸ੍ਵਰ੍ਗਮਾਰੋਹਤ੍ ਯਾਂ ਯਾਂ ਕ੍ਰਿਯਾਮਕਰੋਤ੍ ਯਦ੍ਯਦ੍ ਉਪਾਦਿਸ਼ੱਚ ਤਾਨਿ ਸਰ੍ੱਵਾਣਿ ਪੂਰ੍ੱਵੰ ਮਯਾ ਲਿਖਿਤਾਨਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ਸ ਸ੍ਵਨਿਧਨਦੁਃਖਭੋਗਾਤ੍ ਪਰਮ੍ ਅਨੇਕਪ੍ਰਤ੍ਯਯਕ੍ਸ਼਼ਪ੍ਰਮਾਣੌਃ ਸ੍ਵੰ ਸਜੀਵੰ ਦਰ੍ਸ਼ਯਿਤ੍ਵਾ ");
INSERT INTO sanpun_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ਚਤ੍ਵਾਰਿੰਸ਼ੱਦਿਨਾਨਿ ਯਾਵਤ੍ ਤੇਭ੍ਯਃ ਪ੍ਰੇਰਿਤੇਭ੍ਯੋ ਦਰ੍ਸ਼ਨੰ ਦੱਤ੍ਵੇਸ਼੍ਵਰੀਯਰਾਜ੍ਯਸ੍ਯ ਵਰ੍ਣਨਮ ਅਕਰੋਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","ਅਨਨ੍ਤਰੰ ਤੇਸ਼਼ਾਂ ਸਭਾਂ ਕ੍ਰੁʼਤ੍ਵਾ ਇਤ੍ਯਾਜ੍ਞਾਪਯਤ੍, ਯੂਯੰ ਯਿਰੂਸ਼ਾਲਮੋ(ਅ)ਨ੍ਯਤ੍ਰ ਗਮਨਮਕ੍ਰੁʼਤ੍ਵਾ ਯਸ੍ਤਿਨ੍ ਪਿਤ੍ਰਾਙ੍ਗੀਕ੍ਰੁʼਤੇ ਮਮ ਵਦਨਾਤ੍ ਕਥਾ ਅਸ਼੍ਰੁʼਣੁਤ ਤਤ੍ਪ੍ਰਾਪ੍ਤਿਮ੍ ਅਪੇਕ੍ਸ਼਼੍ਯ ਤਿਸ਼਼੍ਠਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","ਯੋਹਨ੍ ਜਲੇ ਮੱਜਿਤਾਵਾਨ੍ ਕਿਨ੍ਤ੍ਵਲ੍ਪਦਿਨਮਧ੍ਯੇ ਯੂਯੰ ਪਵਿਤ੍ਰ ਆਤ੍ਮਨਿ ਮੱਜਿਤਾ ਭਵਿਸ਼਼੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","ਪਸ਼੍ਚਾਤ੍ ਤੇ ਸਰ੍ੱਵੇ ਮਿਲਿਤ੍ਵਾ ਤਮ੍ ਅਪ੍ਰੁʼੱਛਨ੍ ਹੇ ਪ੍ਰਭੋ ਭਵਾਨ੍ ਕਿਮਿਦਾਨੀਂ ਪੁਨਰਪਿ ਰਾਜ੍ਯਮ੍ ਇਸ੍ਰਾਯੇਲੀਯਲੋਕਾਨਾਂ ਕਰੇਸ਼਼ੁ ਸਮਰ੍ਪਯਿਸ਼਼੍ਯਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ਤਤਃ ਸੋਵਦਤ੍ ਯਾਨ੍ ਸਰ੍ੱਵਾਨ੍ ਕਾਲਾਨ੍ ਸਮਯਾਂਸ਼੍ਚ ਪਿਤਾ ਸ੍ਵਵਸ਼ੇ(ਅ)ਸ੍ਥਾਪਯਤ੍ ਤਾਨ੍ ਜ੍ਞਾਤ੍ਰੁਂʼ ਯੁਸ਼਼੍ਮਾਕਮ੍ ਅਧਿਕਾਰੋ ਨ ਜਾਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","ਕਿਨ੍ਤੁ ਯੁਸ਼਼੍ਮਾਸੁ ਪਵਿਤ੍ਰਸ੍ਯਾਤ੍ਮਨ ਆਵਿਰ੍ਭਾਵੇ ਸਤਿ ਯੂਯੰ ਸ਼ਕ੍ਤਿੰ ਪ੍ਰਾਪ੍ਯ ਯਿਰੂਸ਼ਾਲਮਿ ਸਮਸ੍ਤਯਿਹੂਦਾਸ਼ੋਮਿਰੋਣਦੇਸ਼ਯੋਃ ਪ੍ਰੁʼਥਿਵ੍ਯਾਃ ਸੀਮਾਂ ਯਾਵਦ੍ ਯਾਵਨ੍ਤੋ ਦੇਸ਼ਾਸ੍ਤੇਸ਼਼ੁ ਯਰ੍ੱਵੇਸ਼਼ੁ ਚ ਮਯਿ ਸਾਕ੍ਸ਼਼੍ਯੰ ਦਾਸ੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ਇਤਿ ਵਾਕ੍ਯਮੁਕ੍ਤ੍ਵਾ ਸ ਤੇਸ਼਼ਾਂ ਸਮਕ੍ਸ਼਼ੰ ਸ੍ਵਰ੍ਗੰ ਨੀਤੋ(ਅ)ਭਵਤ੍, ਤਤੋ ਮੇਘਮਾਰੁਹ੍ਯ ਤੇਸ਼਼ਾਂ ਦ੍ਰੁʼਸ਼਼੍ਟੇਰਗੋਚਰੋ(ਅ)ਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ਯਸ੍ਮਿਨ੍ ਸਮਯੇ ਤੇ ਵਿਹਾਯਸੰ ਪ੍ਰਤ੍ਯਨਨ੍ਯਦ੍ਰੁʼਸ਼਼੍ਟ੍ਯਾ ਤਸ੍ਯ ਤਾਦ੍ਰੁʼਸ਼ਮ੍ ਊਰ੍ਦ੍ੱਵਗਮਨਮ੍ ਅਪਸ਼੍ਯਨ੍ ਤਸ੍ਮਿੰਨੇਵ ਸਮਯੇ ਸ਼ੁਕ੍ਲਵਸ੍ਤ੍ਰੌ ਦ੍ਵੌ ਜਨੌ ਤੇਸ਼਼ਾਂ ਸੰਨਿਧੌ ਦਣ੍ਡਾਯਮਾਨੌ ਕਥਿਤਵਨ੍ਤੌ, ");
INSERT INTO sanpun_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ਹੇ ਗਾਲੀਲੀਯਲੋਕਾ ਯੂਯੰ ਕਿਮਰ੍ਥੰ ਗਗਣੰ ਪ੍ਰਤਿ ਨਿਰੀਕ੍ਸ਼਼੍ਯ ਦਣ੍ਡਾਯਮਾਨਾਸ੍ਤਿਸ਼਼੍ਠਥ? ਯੁਸ਼਼੍ਮਾਕੰ ਸਮੀਪਾਤ੍ ਸ੍ਵਰ੍ਗੰ ਨੀਤੋ ਯੋ ਯੀਸ਼ੁਸ੍ਤੰ ਯੂਯੰ ਯਥਾ ਸ੍ਵਰ੍ਗਮ੍ ਆਰੋਹਨ੍ਤਮ੍ ਅਦਰ੍ਸ਼ਮ੍ ਤਥਾ ਸ ਪੁਨਸ਼੍ਚਾਗਮਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ਤਤਃ ਪਰੰ ਤੇ ਜੈਤੁਨਨਾਮ੍ਨਃ ਪਰ੍ੱਵਤਾਦ੍ ਵਿਸ਼੍ਰਾਮਵਾਰਸ੍ਯ ਪਥਃ ਪਰਿਮਾਣਮ੍ ਅਰ੍ਥਾਤ੍ ਪ੍ਰਾਯੇਣਾਰ੍ੱਧਕ੍ਰੋਸ਼ੰ ਦੁਰਸ੍ਥੰ ਯਿਰੂਸ਼ਾਲਮ੍ਨਗਰੰ ਪਰਾਵ੍ਰੁʼਤ੍ਯਾਗੱਛਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","ਨਗਰੰ ਪ੍ਰਵਿਸ਼੍ਯ ਪਿਤਰੋ ਯਾਕੂਬ੍ ਯੋਹਨ੍ ਆਨ੍ਦ੍ਰਿਯਃ ਫਿਲਿਪਃ ਥੋਮਾ ਬਰ੍ਥਜਮਯੋ ਮਥਿਰਾਲ੍ਫੀਯਪੁਤ੍ਰੋ ਯਾਕੂਬ੍ ਉਦ੍ਯੋਗਾी ਸ਼ਿਮੋਨ੍ ਯਾਕੂਬੋ ਭ੍ਰਾਤਾ ਯਿਹੂਦਾ ਏਤੇ ਸਰ੍ੱਵੇ ਯਤ੍ਰ ਸ੍ਥਾਨੇ ਪ੍ਰਵਸਨ੍ਤਿ ਤਸ੍ਮਿਨ੍ ਉਪਰਿਤਨਪ੍ਰਕੋਸ਼਼੍ਠੇ ਪ੍ਰਾਵਿਸ਼ਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ਪਸ਼੍ਚਾਦ੍ ਇਮੇ ਕਿਯਤ੍ਯਃ ਸ੍ਤ੍ਰਿਯਸ਼੍ਚ ਯੀਸ਼ੋ ਰ੍ਮਾਤਾ ਮਰਿਯਮ੍ ਤਸ੍ਯ ਭ੍ਰਾਤਰਸ਼੍ਚੈਤੇ ਸਰ੍ੱਵ ਏਕਚਿੱਤੀਭੂਤ ਸਤਤੰ ਵਿਨਯੇਨ ਵਿਨਯੇਨ ਪ੍ਰਾਰ੍ਥਯਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","ਤਸ੍ਮਿਨ੍ ਸਮਯੇ ਤਤ੍ਰ ਸ੍ਥਾਨੇ ਸਾਕਲ੍ਯੇਨ ਵਿੰਸ਼ਤ੍ਯਧਿਕਸ਼ਤੰ ਸ਼ਿਸ਼਼੍ਯਾ ਆਸਨ੍| ਤਤਃ ਪਿਤਰਸ੍ਤੇਸ਼਼ਾਂ ਮਧ੍ਯੇ ਤਿਸ਼਼੍ਠਨ੍ ਉਕ੍ਤਵਾਨ੍ ");
INSERT INTO sanpun_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","ਹੇ ਭ੍ਰਾਤ੍ਰੁʼਗਣ ਯੀਸ਼ੁਧਾਰਿਣਾਂ ਲੋਕਾਨਾਂ ਪਥਦਰ੍ਸ਼ਕੋ ਯੋ ਯਿਹੂਦਾਸ੍ਤਸ੍ਮਿਨ੍ ਦਾਯੂਦਾ ਪਵਿਤ੍ਰ ਆਤ੍ਮਾ ਯਾਂ ਕਥਾਂ ਕਥਯਾਮਾਸ ਤਸ੍ਯਾਃ ਪ੍ਰਤ੍ਯਕ੍ਸ਼਼ੀਭਵਨਸ੍ਯਾਵਸ਼੍ਯਕਤ੍ਵਮ੍ ਆਸੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ਸ ਜਨੋ(ਅ)ਸ੍ਮਾਕੰ ਮਧ੍ਯਵਰ੍ੱਤੀ ਸਨ੍ ਅਸ੍ਯਾਃ ਸੇਵਾਯਾ ਅੰਸ਼ਮ੍ ਅਲਭਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","ਤਦਨਨ੍ਤਰੰ ਕੁਕਰ੍ੰਮਣਾ ਲਬ੍ਧੰ ਯਨ੍ਮੂਲ੍ਯੰ ਤੇਨ ਕ੍ਸ਼਼ੇਤ੍ਰਮੇਕੰ ਕ੍ਰੀਤਮ੍ ਅਪਰੰ ਤਸ੍ਮਿਨ੍ ਅਧੋਮੁਖੇ ਭ੍ਰੁʼਮੌ ਪਤਿਤੇ ਸਤਿ ਤਸ੍ਯੋਦਰਸ੍ਯ ਵਿਦੀਰ੍ਣਤ੍ਵਾਤ੍ ਸਰ੍ੱਵਾ ਨਾਡ੍ਯੋ ਨਿਰਗੱਛਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ਏਤਾਂ ਕਥਾਂ ਯਿਰੂਸ਼ਾਲਮ੍ਨਿਵਾਸਿਨਃ ਸਰ੍ੱਵੇ ਲੋਕਾ ਵਿਦਾਨ੍ਤਿ; ਤੇਸ਼਼ਾਂ ਨਿਜਭਾਸ਼਼ਯਾ ਤਤ੍ਕ੍ਸ਼਼ੇਤ੍ਰਞ੍ਚ ਹਕਲ੍ਦਾਮਾ, ਅਰ੍ਥਾਤ੍ ਰਕ੍ਤਕ੍ਸ਼਼ੇਤ੍ਰਮਿਤਿ ਵਿਖ੍ਯਾਤਮਾਸ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","ਅਨ੍ਯੱਚ, ਨਿਕੇਤਨੰ ਤਦੀਯਨ੍ਤੁ ਸ਼ੁਨ੍ਯਮੇਵ ਭਵਿਸ਼਼੍ਯਤਿ| ਤਸ੍ਯ ਦੂਸ਼਼੍ਯੇ ਨਿਵਾਸਾਰ੍ਥੰ ਕੋਪਿ ਸ੍ਥਾਸ੍ਯਤਿ ਨੈਵ ਹਿ| ਅਨ੍ਯ ਏਵ ਜਨਸ੍ਤਸ੍ਯ ਪਦੰ ਸੰਪ੍ਰਾਪ੍ਸ੍ਯਤਿ ਧ੍ਰੁਵੰ| ਇੱਥੰ ਗੀਤਪੁਸ੍ਤਕੇ ਲਿਖਿਤਮਾਸ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","ਅਤੋ ਯੋਹਨੋ ਮੱਜਨਮ੍ ਆਰਭ੍ਯਾਸ੍ਮਾਕੰ ਸਮੀਪਾਤ੍ ਪ੍ਰਭੋ ਰ੍ਯੀਸ਼ੋਃ ਸ੍ਵਰ੍ਗਾਰੋਹਣਦਿਨੰ ਯਾਵਤ੍ ਸੋਸ੍ਮਾਕੰ ਮਧ੍ਯੇ ਯਾਵਨ੍ਤਿ ਦਿਨਾਨਿ ਯਾਪਿਤਵਾਨ੍ ");
INSERT INTO sanpun_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ਤਾਵਨ੍ਤਿ ਦਿਨਾਨਿ ਯੇ ਮਾਨਵਾ ਅਸ੍ਮਾਭਿਃ ਸਾਰ੍ੱਧੰ ਤਿਸ਼਼੍ਠਨ੍ਤਿ ਤੇਸ਼਼ਾਮ੍ ਏਕੇਨ ਜਨੇਨਾਸ੍ਮਾਭਿਃ ਸਾਰ੍ੱਧੰ ਯੀਸ਼ੋਰੁੱਥਾਨੇ ਸਾਕ੍ਸ਼਼ਿਣਾ ਭਵਿਤਵ੍ਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","ਅਤੋ ਯਸ੍ਯ ਰੂਢਿ ਰ੍ਯੁਸ਼਼੍ਟੋ ਯੰ ਬਰ੍ਸ਼ੱਬੇਤ੍ਯੁਕ੍ਤ੍ਵਾਹੂਯਨ੍ਤਿ ਸ ਯੂਸ਼਼ਫ੍ ਮਤਥਿਸ਼੍ਚ ਦ੍ਵਾਵੇਤੌ ਪ੍ਰੁʼਥਕ੍ ਕ੍ਰੁʼਤ੍ਵਾ ਤ ਈਸ਼੍ਵਰਸ੍ਯ ਸੰਨਿਧੌ ਪ੍ਰਾਰ੍ੱਯ ਕਥਿਤਵਨ੍ਤਃ, ");
INSERT INTO sanpun_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","ਹੇ ਸਰ੍ੱਵਾਨ੍ਤਰ੍ੱਯਾਮਿਨ੍ ਪਰਮੇਸ਼੍ਵਰ, ਯਿਹੂਦਾਃ ਸੇਵਨਪ੍ਰੇਰਿਤਤ੍ਵਪਦਚ੍ਯੁਤਃ ");
INSERT INTO sanpun_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ਸਨ੍ ਨਿਜਸ੍ਥਾਨਮ੍ ਅਗੱਛਤ੍, ਤਤ੍ਪਦੰ ਲਬ੍ਧੁਮ੍ ਏਨਯੋ ਰ੍ਜਨਯੋ ਰ੍ਮਧ੍ਯੇ ਭਵਤਾ ਕੋ(ਅ)ਭਿਰੁਚਿਤਸ੍ਤਦਸ੍ਮਾਨ੍ ਦਰ੍ਸ਼੍ਯਤਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ਤਤੋ ਗੁਟਿਕਾਪਾਟੇ ਕ੍ਰੁʼਤੇ ਮਤਥਿਰ੍ਨਿਰਚੀਯਤ ਤਸ੍ਮਾਤ੍ ਸੋਨ੍ਯੇਸ਼਼ਾਮ੍ ਏਕਾਦਸ਼ਾਨਾਂ ਪ੍ਰਰਿਤਾਨਾਂ ਮਧ੍ਯੇ ਗਣਿਤੋਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","ਅਪਰਞ੍ਚ ਨਿਸ੍ਤਾਰੋਤ੍ਸਵਾਤ੍ ਪਰੰ ਪਞ੍ਚਾਸ਼ੱਤਮੇ ਦਿਨੇ ਸਮੁਪਸ੍ਥਿਤੇ ਸਤਿ ਤੇ ਸਰ੍ੱਵੇ ਏਕਾਚਿੱਤੀਭੂਯ ਸ੍ਥਾਨ ਏਕਸ੍ਮਿਨ੍ ਮਿਲਿਤਾ ਆਸਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ਏਤਸ੍ਮਿੰਨੇਵ ਸਮਯੇ(ਅ)ਕਸ੍ਮਾਦ੍ ਆਕਾਸ਼ਾਤ੍ ਪ੍ਰਚਣ੍ਡਾਤ੍ਯੁਗ੍ਰਵਾਯੋਃ ਸ਼ਬ੍ਦਵਦ੍ ਏਕਃ ਸ਼ਬ੍ਦ ਆਗਤ੍ਯ ਯਸ੍ਮਿਨ੍ ਗ੍ਰੁʼਹੇ ਤ ਉਪਾਵਿਸ਼ਨ੍ ਤਦ੍ ਗ੍ਰੁʼਹੰ ਸਮਸ੍ਤੰ ਵ੍ਯਾਪ੍ਨੋਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ਤਤਃ ਪਰੰ ਵਹ੍ਨਿਸ਼ਿਖਾਸ੍ਵਰੂਪਾ ਜਿਹ੍ਵਾਃ ਪ੍ਰਤ੍ਯਕ੍ਸ਼਼ੀਭੂਯ ਵਿਭਕ੍ਤਾਃ ਸਤ੍ਯਃ ਪ੍ਰਤਿਜਨੋਰ੍ੱਧ੍ਵੇ ਸ੍ਥਗਿਤਾ ਅਭੂਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","ਤਸ੍ਮਾਤ੍ ਸਰ੍ੱਵੇ ਪਵਿਤ੍ਰੇਣਾਤ੍ਮਨਾ ਪਰਿਪੂਰ੍ਣਾਃ ਸਨ੍ਤ ਆਤ੍ਮਾ ਯਥਾ ਵਾਚਿਤਵਾਨ੍ ਤਦਨੁਸਾਰੇਣਾਨ੍ਯਦੇਸ਼ੀਯਾਨਾਂ ਭਾਸ਼਼ਾ ਉਕ੍ਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","ਤਸ੍ਮਿਨ੍ ਸਮਯੇ ਪ੍ਰੁʼਥਿਵੀਸ੍ਥਸਰ੍ੱਵਦੇਸ਼ੇਭ੍ਯੋ ਯਿਹੂਦੀਯਮਤਾਵਲਮ੍ਬਿਨੋ ਭਕ੍ਤਲੋਕਾ ਯਿਰੂਸ਼ਾਲਮਿ ਪ੍ਰਾਵਸਨ੍; ");
INSERT INTO sanpun_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ਤਸ੍ਯਾਃ ਕਥਾਯਾਃ ਕਿੰਵਦਨ੍ਤ੍ਯਾ ਜਾਤਤ੍ਵਾਤ੍ ਸਰ੍ੱਵੇ ਲੋਕਾ ਮਿਲਿਤ੍ਵਾ ਨਿਜਨਿਜਭਾਸ਼਼ਯਾ ਸ਼ਿਸ਼਼੍ਯਾਣਾਂ ਕਥਾਕਥਨੰ ਸ਼੍ਰੁਤ੍ਵਾ ਸਮੁਦ੍ਵਿਗ੍ਨਾ ਅਭਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ਸਰ੍ੱਵਏਵ ਵਿਸ੍ਮਯਾਪੰਨਾ ਆਸ਼੍ਚਰ੍ੱਯਾਨ੍ਵਿਤਾਸ਼੍ਚ ਸਨ੍ਤਃ ਪਰਸ੍ਪਰੰ ਉਕ੍ਤਵਨ੍ਤਃ ਪਸ਼੍ਯਤ ਯੇ ਕਥਾਂ ਕਥਯਨ੍ਤਿ ਤੇ ਸਰ੍ੱਵੇ ਗਾਲੀਲੀਯਲੋਕਾਃ ਕਿੰ ਨ ਭਵਨ੍ਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ਤਰ੍ਹਿ ਵਯੰ ਪ੍ਰਤ੍ਯੇਕਸ਼ਃ ਸ੍ਵਸ੍ਵਜਨ੍ਮਦੇਸ਼ੀਯਭਾਸ਼਼ਾਭਿਃ ਕਥਾ ਏਤੇਸ਼਼ਾਂ ਸ਼੍ਰੁʼਣੁਮਃ ਕਿਮਿਦੰ? ");
INSERT INTO sanpun_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","ਪਾਰ੍ਥੀ-ਮਾਦੀ-ਅਰਾਮ੍ਨਹਰਯਿਮ੍ਦੇਸ਼ਨਿਵਾਸਿਮਨੋ ਯਿਹੂਦਾ-ਕੱਪਦਕਿਯਾ-ਪਨ੍ਤ-ਆਸ਼ਿਯਾ- ");
INSERT INTO sanpun_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ਫ੍ਰੁਗਿਯਾ-ਪਮ੍ਫੁਲਿਯਾ-ਮਿਸਰਨਿਵਾਸਿਨਃ ਕੁਰੀਣੀਨਿਕਟਵਰ੍ੱਤਿਲੂਬੀਯਪ੍ਰਦੇਸ਼ਨਿਵਾਸਿਨੋ ਰੋਮਨਗਰਾਦ੍ ਆਗਤਾ ਯਿਹੂਦੀਯਲੋਕਾ ਯਿਹੂਦੀਯਮਤਗ੍ਰਾਹਿਣਃ ਕ੍ਰੀਤੀਯਾ ਅਰਾਬੀਯਾਦਯੋ ਲੋਕਾਸ਼੍ਚ ਯੇ ਵਯਮ੍ ");
INSERT INTO sanpun_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ਅਸ੍ਮਾਕੰ ਨਿਜਨਿਜਭਾਸ਼਼ਾਭਿਰੇਤੇਸ਼਼ਾਮ੍ ਈਸ਼੍ਵਰੀਯਮਹਾਕਰ੍ੰਮਵ੍ਯਾਖ੍ਯਾਨੰ ਸ਼੍ਰੁʼਣੁਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ਇੱਥੰ ਤੇ ਸਰ੍ੱਵਏਵ ਵਿਸ੍ਮਯਾਪੰਨਾਃ ਸਨ੍ਦਿਗ੍ਧਚਿੱਤਾਃ ਸਨ੍ਤਃ ਪਰਸ੍ਪਰਮੂਚੁਃ, ਅਸ੍ਯ ਕੋ ਭਾਵਃ? ");
INSERT INTO sanpun_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","ਅਪਰੇ ਕੇਚਿਤ੍ ਪਰਿਹਸ੍ਯ ਕਥਿਤਵਨ੍ਤ ਏਤੇ ਨਵੀਨਦ੍ਰਾਕ੍ਸ਼਼ਾਰਸੇਨ ਮੱਤਾ ਅਭਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","ਤਦਾ ਪਿਤਰ ਏਕਾਦਸ਼ਭਿ ਰ੍ਜਨੈਃ ਸਾਕੰ ਤਿਸ਼਼੍ਠਨ੍ ਤਾੱਲੋਕਾਨ੍ ਉੱਚੈਃਕਾਰਮ੍ ਅਵਦਤ੍, ਹੇ ਯਿਹੂਦੀਯਾ ਹੇ ਯਿਰੂਸ਼ਾਲਮ੍ਨਿਵਾਸਿਨਃ ਸਰ੍ੱਵੇ, ਅਵਧਾਨੰ ਕ੍ਰੁʼਤ੍ਵਾ ਮਦੀਯਵਾਕ੍ਯੰ ਬੁਧ੍ਯਧ੍ਵੰ| ");
INSERT INTO sanpun_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ਇਦਾਨੀਮ੍ ਏਕਯਾਮਾਦ੍ ਅਧਿਕਾ ਵੇਲਾ ਨਾਸ੍ਤਿ ਤਸ੍ਮਾਦ੍ ਯੂਯੰ ਯਦ੍ ਅਨੁਮਾਥ ਮਾਨਵਾ ਇਮੇ ਮਦ੍ਯਪਾਨੇਨ ਮੱਤਾਸ੍ਤੰਨ| ");
INSERT INTO sanpun_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","ਕਿਨ੍ਤੁ ਯੋਯੇਲ੍ਭਵਿਸ਼਼੍ਯਦ੍ਵਕ੍ਤ੍ਰੈਤਦ੍ਵਾਕ੍ਯਮੁਕ੍ਤੰ ਯਥਾ, ");
INSERT INTO sanpun_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","ਈਸ਼੍ਵਰਃ ਕਥਯਾਮਾਸ ਯੁਗਾਨ੍ਤਸਮਯੇ ਤ੍ਵਹਮ੍| ਵਰ੍ਸ਼਼ਿਸ਼਼੍ਯਾਮਿ ਸ੍ਵਮਾਤ੍ਮਾਨੰ ਸਰ੍ੱਵਪ੍ਰਾਣ੍ਯੁਪਰਿ ਧ੍ਰੁਵਮ੍| ਭਾਵਿਵਾਕ੍ਯੰ ਵਦਿਸ਼਼੍ਯਨ੍ਤਿ ਕਨ੍ਯਾਃ ਪੁਤ੍ਰਾਸ਼੍ਚ ਵਸ੍ਤੁਤਃ| ਪ੍ਰਤ੍ਯਾਦੇਸ਼ਞ੍ਚ ਪ੍ਰਾਪ੍ਸ੍ਯਨ੍ਤਿ ਯੁਸ਼਼੍ਮਾਕੰ ਯੁਵਮਾਨਵਾਃ| ਤਥਾ ਪ੍ਰਾਚੀਨਲੋਕਾਸ੍ਤੁ ਸ੍ਵਪ੍ਨਾਨ੍ ਦ੍ਰਕ੍ਸ਼਼੍ਯਨ੍ਤਿ ਨਿਸ਼੍ਚਿਤੰ| ");
INSERT INTO sanpun_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","ਵਰ੍ਸ਼਼ਿਸ਼਼੍ਯਾਮਿ ਤਦਾਤ੍ਮਾਨੰ ਦਾਸਦਾਸੀਜਨੋਪਿਰਿ| ਤੇਨੈਵ ਭਾਵਿਵਾਕ੍ਯੰ ਤੇ ਵਦਿਸ਼਼੍ਯਨ੍ਤਿ ਹਿ ਸਰ੍ੱਵਸ਼ਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ਊਰ੍ੱਧ੍ਵਸ੍ਥੇ ਗਗਣੇ ਚੈਵ ਨੀਚਸ੍ਥੇ ਪ੍ਰੁʼਥਿਵੀਤਲੇ| ਸ਼ੋਣਿਤਾਨਿ ਬ੍ਰੁʼਹਦ੍ਭਾਨੂਨ੍ ਘਨਧੂਮਾਦਿਕਾਨਿ ਚ| ਚਿਹ੍ਨਾਨਿ ਦਰ੍ਸ਼ਯਿਸ਼਼੍ਯਾਮਿ ਮਹਾਸ਼੍ਚਰ੍ੱਯਕ੍ਰਿਯਾਸ੍ਤਥਾ| ");
INSERT INTO sanpun_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","ਮਹਾਭਯਾਨਕਸ੍ਯੈਵ ਤੱਦਿਨਸ੍ਯ ਪਰੇਸ਼ਿਤੁਃ| ਪੁਰਾਗਮਾਦ੍ ਰਵਿਃ ਕ੍ਰੁʼਸ਼਼੍ਣੋ ਰਕ੍ਤਸ਼੍ਚਨ੍ਦ੍ਰੋ ਭਵਿਸ਼਼੍ਯਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","ਕਿਨ੍ਤੁ ਯਃ ਪਰਮੇਸ਼ਸ੍ਯ ਨਾਮ੍ਨਿ ਸਮ੍ਪ੍ਰਾਰ੍ਥਯਿਸ਼਼੍ਯਤੇ| ਸਏਵ ਮਨੁਜੋ ਨੂਨੰ ਪਰਿਤ੍ਰਾਤੋ ਭਵਿਸ਼਼੍ਯਤਿ|| ");
INSERT INTO sanpun_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","ਅਤੋ ਹੇ ਇਸ੍ਰਾਯੇਲ੍ਵੰਸ਼ੀਯਲੋਕਾਃ ਸਰ੍ੱਵੇ ਕਥਾਯਾਮੇਤਸ੍ਯਾਮ੍ ਮਨੋ ਨਿਧੱਧ੍ਵੰ ਨਾਸਰਤੀਯੋ ਯੀਸ਼ੁਰੀਸ਼੍ਵਰਸ੍ਯ ਮਨੋਨੀਤਃ ਪੁਮਾਨ੍ ਏਤਦ੍ ਈਸ਼੍ਵਰਸ੍ਤਤ੍ਕ੍ਰੁʼਤੈਰਾਸ਼੍ਚਰ੍ੱਯਾਦ੍ਭੁਤਕਰ੍ੰਮਭਿ ਰ੍ਲਕ੍ਸ਼਼ਣੈਸ਼੍ਚ ਯੁਸ਼਼੍ਮਾਕੰ ਸਾਕ੍ਸ਼਼ਾਦੇਵ ਪ੍ਰਤਿਪਾਦਿਤਵਾਨ੍ ਇਤਿ ਯੂਯੰ ਜਾਨੀਥ| ");
INSERT INTO sanpun_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","ਤਸ੍ਮਿਨ੍ ਯੀਸ਼ੌ ਈਸ਼੍ਵਰਸ੍ਯ ਪੂਰ੍ੱਵਨਿਸ਼੍ਚਿਤਮਨ੍ਤ੍ਰਣਾਨਿਰੂਪਣਾਨੁਸਾਰੇਣ ਮ੍ਰੁʼਤ੍ਯੌ ਸਮਰ੍ਪਿਤੇ ਸਤਿ ਯੂਯੰ ਤੰ ਧ੍ਰੁʼਤ੍ਵਾ ਦੁਸ਼਼੍ਟਲੋਕਾਨਾਂ ਹਸ੍ਤੈਃ ਕ੍ਰੁਸ਼ੇ ਵਿਧਿਤ੍ਵਾਹਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","ਕਿਨ੍ਤ੍ਵੀਸ਼੍ਵਰਸ੍ਤੰ ਨਿਧਨਸ੍ਯ ਬਨ੍ਧਨਾਨ੍ਮੋਚਯਿਤ੍ਵਾ ਉਦਸ੍ਥਾਪਯਤ੍ ਯਤਃ ਸ ਮ੍ਰੁʼਤ੍ਯੁਨਾ ਬੱਧਸ੍ਤਿਸ਼਼੍ਠਤੀਤਿ ਨ ਸਮ੍ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ਏਤਸ੍ਤਿਨ੍ ਦਾਯੂਦਪਿ ਕਥਿਤਵਾਨ੍ ਯਥਾ, ਸਰ੍ੱਵਦਾ ਮਮ ਸਾਕ੍ਸ਼਼ਾੱਤੰ ਸ੍ਥਾਪਯ ਪਰਮੇਸ਼੍ਵਰੰ| ਸ੍ਥਿਤੇ ਮੱਦਕ੍ਸ਼਼ਿਣੇ ਤਸ੍ਮਿਨ੍ ਸ੍ਖਲਿਸ਼਼੍ਯਾਮਿ ਤ੍ਵਹੰ ਨਹਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ਆਨਨ੍ਦਿਸ਼਼੍ਯਤਿ ਤੱਧੇਤੋ ਰ੍ਮਾਮਕੀਨੰ ਮਨਸ੍ਤੁ ਵੈ| ਆਹ੍ਲਾਦਿਸ਼਼੍ਯਤਿ ਜਿਹ੍ਵਾਪਿ ਮਦੀਯਾ ਤੁ ਤਥੈਵ ਚ| ਪ੍ਰਤ੍ਯਾਸ਼ਯਾ ਸ਼ਰੀਰਨ੍ਤੁ ਮਦੀਯੰ ਵੈਸ਼ਯਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ਪਰਲੋਕੇ ਯਤੋ ਹੇਤੋਸ੍ਤ੍ਵੰ ਮਾਂ ਨੈਵ ਹਿ ਤ੍ਯਕ੍ਸ਼਼੍ਯਸਿ| ਸ੍ਵਕੀਯੰ ਪੁਣ੍ਯਵਨ੍ਤੰ ਤ੍ਵੰ ਕ੍ਸ਼਼ਯਿਤੁੰ ਨੈਵ ਦਾਸ੍ਯਸਿ| ਏਵੰ ਜੀਵਨਮਾਰ੍ਗੰ ਤ੍ਵੰ ਮਾਮੇਵ ਦਰ੍ਸ਼ਯਿਸ਼਼੍ਯਸਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","ਸ੍ਵਸੰਮੁਖੇ ਯ ਆਨਨ੍ਦੋ ਦਕ੍ਸ਼਼ਿਣੇ ਸ੍ਵਸ੍ਯ ਯਤ੍ ਸੁਖੰ| ਅਨਨ੍ਤੰ ਤੇਨ ਮਾਂ ਪੂਰ੍ਣੰ ਕਰਿਸ਼਼੍ਯਸਿ ਨ ਸੰਸ਼ਯਃ|| ");
INSERT INTO sanpun_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","ਹੇ ਭ੍ਰਾਤਰੋ(ਅ)ਸ੍ਮਾਕੰ ਤਸ੍ਯ ਪੂਰ੍ੱਵਪੁਰੁਸ਼਼ਸ੍ਯ ਦਾਯੂਦਃ ਕਥਾਂ ਸ੍ਪਸ਼਼੍ਟੰ ਕਥਯਿਤੁੰ ਮਾਮ੍ ਅਨੁਮਨ੍ਯਧ੍ਵੰ, ਸ ਪ੍ਰਾਣਾਨ੍ ਤ੍ਯਕ੍ਤ੍ਵਾ ਸ਼੍ਮਸ਼ਾਨੇ ਸ੍ਥਾਪਿਤੋਭਵਦ੍ ਅਦ੍ਯਾਪਿ ਤਤ੍ ਸ਼੍ਮਸ਼ਾਨਮ੍ ਅਸ੍ਮਾਕੰ ਸੰਨਿਧੌ ਵਿਦ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","ਫਲਤੋ ਲੌਕਿਕਭਾਵੇਨ ਦਾਯੂਦੋ ਵੰਸ਼ੇ ਖ੍ਰੀਸ਼਼੍ਟੰ ਜਨ੍ਮ ਗ੍ਰਾਹਯਿਤ੍ਵਾ ਤਸ੍ਯੈਵ ਸਿੰਹਾਸਨੇ ਸਮੁਵੇਸ਼਼੍ਟੁੰ ਤਮੁੱਥਾਪਯਿਸ਼਼੍ਯਤਿ ਪਰਮੇਸ਼੍ਵਰਃ ਸ਼ਪਥੰ ਕੁਤ੍ਵਾ ਦਾਯੂਦਃ ਸਮੀਪ ਇਮਮ੍ ਅਙ੍ਗੀਕਾਰੰ ਕ੍ਰੁʼਤਵਾਨ੍, ");
INSERT INTO sanpun_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ਇਤਿ ਜ੍ਞਾਤ੍ਵਾ ਦਾਯੂਦ੍ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦੀ ਸਨ੍ ਭਵਿਸ਼਼੍ਯਤ੍ਕਾਲੀਯਜ੍ਞਾਨੇਨ ਖ੍ਰੀਸ਼਼੍ਟੋੱਥਾਨੇ ਕਥਾਮਿਮਾਂ ਕਥਯਾਮਾਸ ਯਥਾ ਤਸ੍ਯਾਤ੍ਮਾ ਪਰਲੋਕੇ ਨ ਤ੍ਯਕ੍ਸ਼਼੍ਯਤੇ ਤਸ੍ਯ ਸ਼ਰੀਰਞ੍ਚ ਨ ਕ੍ਸ਼਼ੇਸ਼਼੍ਯਤਿ; ");
INSERT INTO sanpun_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","ਅਤਃ ਪਰਮੇਸ਼੍ਵਰ ਏਨੰ ਯੀਸ਼ੁੰ ਸ਼੍ਮਸ਼ਾਨਾਦ੍ ਉਦਸ੍ਥਾਪਯਤ੍ ਤਤ੍ਰ ਵਯੰ ਸਰ੍ੱਵੇ ਸਾਕ੍ਸ਼਼ਿਣ ਆਸ੍ਮਹੇ| ");
INSERT INTO sanpun_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ਸ ਈਸ਼੍ਵਰਸ੍ਯ ਦਕ੍ਸ਼਼ਿਣਕਰੇਣੋੰਨਤਿੰ ਪ੍ਰਾਪ੍ਯ ਪਵਿਤ੍ਰ ਆਤ੍ਮਿਨ ਪਿਤਾ ਯਮਙ੍ਗੀਕਾਰੰ ਕ੍ਰੁʼਤਵਾਨ੍ ਤਸ੍ਯ ਫਲੰ ਪ੍ਰਾਪ੍ਯ ਯਤ੍ ਪਸ਼੍ਯਥ ਸ਼੍ਰੁʼਣੁਥ ਚ ਤਦਵਰ੍ਸ਼਼ਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","ਯਤੋ ਦਾਯੂਦ੍ ਸ੍ਵਰ੍ਗੰ ਨਾਰੁਰੋਹ ਕਿਨ੍ਤੁ ਸ੍ਵਯਮ੍ ਇਮਾਂ ਕਥਾਮ੍ ਅਕਥਯਦ੍ ਯਥਾ, ਮਮ ਪ੍ਰਭੁਮਿਦੰ ਵਾਕ੍ਯਮਵਦਤ੍ ਪਰਮੇਸ਼੍ਵਰਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ਤਵ ਸ਼ਤ੍ਰੂਨਹੰ ਯਾਵਤ੍ ਪਾਦਪੀਠੰ ਕਰੋਮਿ ਨ| ਤਾਵਤ੍ ਕਾਲੰ ਮਦੀਯੇ ਤ੍ਵੰ ਦਕ੍ਸ਼਼ਵਾਰ੍ਸ਼੍ਵ ਉਪਾਵਿਸ਼| ");
INSERT INTO sanpun_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","ਅਤੋ ਯੰ ਯੀਸ਼ੁੰ ਯੂਯੰ ਕ੍ਰੁਸ਼ੇ(ਅ)ਹਤ ਪਰਮੇਸ਼੍ਵਰਸ੍ਤੰ ਪ੍ਰਭੁਤ੍ਵਾਭਿਸ਼਼ਿਕ੍ਤਤ੍ਵਪਦੇ ਨ੍ਯਯੁੰਕ੍ਤੇਤਿ ਇਸ੍ਰਾਯੇਲੀਯਾ ਲੋਕਾ ਨਿਸ਼੍ਚਿਤੰ ਜਾਨਨ੍ਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ਏਤਾਦ੍ਰੁʼਸ਼ੀਂ ਕਥਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਤੇਸ਼਼ਾਂ ਹ੍ਰੁʼਦਯਾਨਾਂ ਵਿਦੀਰ੍ਣਤ੍ਵਾਤ੍ ਤੇ ਪਿਤਰਾਯ ਤਦਨ੍ਯਪ੍ਰੇਰਿਤੇਭ੍ਯਸ਼੍ਚ ਕਥਿਤਵਨ੍ਤਃ, ਹੇ ਭ੍ਰਾਤ੍ਰੁʼਗਣ ਵਯੰ ਕਿੰ ਕਰਿਸ਼਼੍ਯਾਮਃ? ");
INSERT INTO sanpun_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","ਤਤਃ ਪਿਤਰਃ ਪ੍ਰਤ੍ਯਵਦਦ੍ ਯੂਯੰ ਸਰ੍ੱਵੇ ਸ੍ਵੰ ਸ੍ਵੰ ਮਨਃ ਪਰਿਵਰ੍ੱਤਯਧ੍ਵੰ ਤਥਾ ਪਾਪਮੋਚਨਾਰ੍ਥੰ ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਨਾਮ੍ਨਾ ਮੱਜਿਤਾਸ਼੍ਚ ਭਵਤ, ਤਸ੍ਮਾਦ੍ ਦਾਨਰੂਪੰ ਪਰਿਤ੍ਰਮ੍ ਆਤ੍ਮਾਨੰ ਲਪ੍ਸ੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","ਯਤੋ ਯੁਸ਼਼੍ਮਾਕੰ ਯੁਸ਼਼੍ਮਤ੍ਸਨ੍ਤਾਨਾਨਾਞ੍ਚ ਦੂਰਸ੍ਥਸਰ੍ੱਵਲੋਕਾਨਾਞ੍ਚ ਨਿਮਿੱਤਮ੍ ਅਰ੍ਥਾਦ੍ ਅਸ੍ਮਾਕੰ ਪ੍ਰਭੁਃ ਪਰਮੇਸ਼੍ਵਰੋ ਯਾਵਤੋ ਲਾਕਾਨ੍ ਆਹ੍ਵਾਸ੍ਯਤਿ ਤੇਸ਼਼ਾਂ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਨਿਮਿੱਤਮ੍ ਅਯਮਙ੍ਗੀਕਾਰ ਆਸ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ਏਤਦਨ੍ਯਾਭਿ ਰ੍ਬਹੁਕਥਾਭਿਃ ਪ੍ਰਮਾਣੰ ਦਤ੍ਵਾਕਥਯਤ੍ ਏਤੇਭ੍ਯੋ ਵਿਪਥਗਾਮਿਭ੍ਯੋ ਵਰ੍ੱਤਮਾਨਲੋਕੇਭ੍ਯਃ ਸ੍ਵਾਨ੍ ਰਕ੍ਸ਼਼ਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ਤਤਃ ਪਰੰ ਯੇ ਸਾਨਨ੍ਦਾਸ੍ਤਾਂ ਕਥਾਮ੍ ਅਗ੍ਰੁʼਹ੍ਲਨ੍ ਤੇ ਮੱਜਿਤਾ ਅਭਵਨ੍| ਤਸ੍ਮਿਨ੍ ਦਿਵਸੇ ਪ੍ਰਾਯੇਣ ਤ੍ਰੀਣਿ ਸਹਸ੍ਰਾਣਿ ਲੋਕਾਸ੍ਤੇਸ਼਼ਾਂ ਸਪਕ੍ਸ਼਼ਾਃ ਸਨ੍ਤਃ ");
INSERT INTO sanpun_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ਪ੍ਰੇਰਿਤਾਨਾਮ੍ ਉਪਦੇਸ਼ੇ ਸਙ੍ਗਤੌ ਪੂਪਭਞ੍ਜਨੇ ਪ੍ਰਾਰ੍ਥਨਾਸੁ ਚ ਮਨਃਸੰਯੋਗੰ ਕ੍ਰੁʼਤ੍ਵਾਤਿਸ਼਼੍ਠਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","ਪ੍ਰੇਰਿਤੈ ਰ੍ਨਾਨਾਪ੍ਰਕਾਰਲਕ੍ਸ਼਼ਣੇਸ਼਼ੁ ਮਹਾਸ਼੍ਚਰ੍ੱਯਕਰ੍ਮਮਸੁ ਚ ਦਰ੍ਸ਼ਿਤੇਸ਼਼ੁ ਸਰ੍ੱਵਲੋਕਾਨਾਂ ਭਯਮੁਪਸ੍ਥਿਤੰ| ");
INSERT INTO sanpun_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","ਵਿਸ਼੍ਵਾਸਕਾਰਿਣਃ ਸਰ੍ੱਵ ਚ ਸਹ ਤਿਸ਼਼੍ਠਨਤਃ| ਸ੍ਵੇਸ਼਼ਾਂ ਸਰ੍ੱਵਾਃ ਸਮ੍ਪੱਤੀਃ ਸਾਧਾਰਣ੍ਯੇਨ ਸ੍ਥਾਪਯਿਤ੍ਵਾਭੁਞ੍ਜਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ਫਲਤੋ ਗ੍ਰੁʼਹਾਣਿ ਦ੍ਰਵ੍ਯਾਣਿ ਚ ਸਰ੍ੱਵਾਣਿ ਵਿਕ੍ਰੀਯ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਸ੍ਵਸ੍ਵਪ੍ਰਯੋਜਨਾਨੁਸਾਰੇਣ ਵਿਭਜ੍ਯ ਸਰ੍ੱਵੇਭ੍ਯੋ(ਅ)ਦਦਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","ਸਰ੍ੱਵ ਏਕਚਿੱਤੀਭੂਯ ਦਿਨੇ ਦਿਨੇ ਮਨ੍ਦਿਰੇ ਸਨ੍ਤਿਸ਼਼੍ਠਮਾਨਾ ਗ੍ਰੁʼਹੇ ਗ੍ਰੁʼਹੇ ਚ ਪੂਪਾਨਭਞ੍ਜਨ੍ਤ ਈਸ਼੍ਵਰਸ੍ਯ ਧਨ੍ਯਵਾਦੰ ਕੁਰ੍ੱਵਨ੍ਤੋ ਲੋਕੈਃ ਸਮਾਦ੍ਰੁʼਤਾਃ ਪਰਮਾਨਨ੍ਦੇਨ ਸਰਲਾਨ੍ਤਃਕਰਣੇਨ ਭੋਜਨੰ ਪਾਨਞ੍ਚਕੁਰ੍ੱਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ਪਰਮੇਸ਼੍ਵਰੋ ਦਿਨੇ ਦਿਨੇ ਪਰਿਤ੍ਰਾਣਭਾਜਨੈ ਰ੍ਮਣ੍ਡਲੀਮ੍ ਅਵਰ੍ੱਧਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","ਤ੍ਰੁʼਤੀਯਯਾਮਵੇਲਾਯਾਂ ਸਤ੍ਯਾਂ ਪ੍ਰਾਰ੍ਥਨਾਯਾਃ ਸਮਯੇ ਪਿਤਰਯੋਹਨੌ ਸਮ੍ਭੂਯ ਮਨ੍ਦਿਰੰ ਗੱਛਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ਤਸ੍ਮਿੰਨੇਵ ਸਮਯੇ ਮਨ੍ਦਿਰਪ੍ਰਵੇਸ਼ਕਾਨਾਂ ਸਮੀਪੇ ਭਿਕ੍ਸ਼਼ਾਰਣਾਰ੍ਥੰ ਯੰ ਜਨ੍ਮਖਞ੍ਜਮਾਨੁਸ਼਼ੰ ਲੋਕਾ ਮਨ੍ਦਿਰਸ੍ਯ ਸੁਨ੍ਦਰਨਾਮ੍ਨਿ ਦ੍ਵਾਰੇ ਪ੍ਰਤਿਦਿਨਮ੍ ਅਸ੍ਥਾਪਯਨ੍ ਤੰ ਵਹਨ੍ਤਸ੍ਤਦ੍ਵਾਰੰ ਆਨਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ਤਦਾ ਪਿਤਰਯੋਹਨੌ ਮਨ੍ਤਿਰੰ ਪ੍ਰਵੇਸ਼਼੍ਟੁਮ੍ ਉਦ੍ਯਤੌ ਵਿਲੋਕ੍ਯ ਸ ਖਞ੍ਜਸ੍ਤੌ ਕਿਞ੍ਚਿਦ੍ ਭਿਕ੍ਸ਼਼ਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","ਤਸ੍ਮਾਦ੍ ਯੋਹਨਾ ਸਹਿਤਃ ਪਿਤਰਸ੍ਤਮ੍ ਅਨਨ੍ਯਦ੍ਰੁʼਸ਼਼੍ਟ੍ਯਾ ਨਿਰੀਕ੍ਸ਼਼੍ਯ ਪ੍ਰੋਕ੍ਤਵਾਨ੍ ਆਵਾਂ ਪ੍ਰਤਿ ਦ੍ਰੁʼਸ਼਼੍ਟਿੰ ਕੁਰੁ| ");
INSERT INTO sanpun_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ਤਤਃ ਸ ਕਿਞ੍ਚਿਤ੍ ਪ੍ਰਾਪ੍ਤ੍ਯਾਸ਼ਯਾ ਤੌ ਪ੍ਰਤਿ ਦ੍ਰੁʼਸ਼਼੍ਟਿੰ ਕ੍ਰੁʼਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","ਤਦਾ ਪਿਤਰੋ ਗਦਿਤਵਾਨ੍ ਮਮ ਨਿਕਟੇ ਸ੍ਵਰ੍ਣਰੂਪ੍ਯਾਦਿ ਕਿਮਪਿ ਨਾਸ੍ਤਿ ਕਿਨ੍ਤੁ ਯਦਾਸ੍ਤੇ ਤਦ੍ ਦਦਾਮਿ ਨਾਸਰਤੀਯਸ੍ਯ ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਨਾਮ੍ਨਾ ਤ੍ਵਮੁੱਥਾਯ ਗਮਨਾਗਮਨੇ ਕੁਰੁ| ");
INSERT INTO sanpun_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ਤਤਃ ਪਰੰ ਸ ਤਸ੍ਯ ਦਕ੍ਸ਼਼ਿਣਕਰੰ ਧ੍ਰੁʼਤ੍ਵਾ ਤਮ੍ ਉਦਤੋਲਯਤ੍; ਤੇਨ ਤਤ੍ਕ੍ਸ਼਼ਣਾਤ੍ ਤਸ੍ਯ ਜਨਸ੍ਯ ਪਾਦਗੁਲ੍ਫਯੋਃ ਸਬਲਤ੍ਵਾਤ੍ ਸ ਉੱਲਮ੍ਫ੍ਯ ਪ੍ਰੋੱਥਾਯ ਗਮਨਾਗਮਨੇ (ਅ)ਕਰੋਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ਤਤੋ ਗਮਨਾਗਮਨੇ ਕੁਰ੍ੱਵਨ੍ ਉੱਲਮ੍ਫਨ੍ ਈਸ਼੍ਵਰੰ ਧਨ੍ਯੰ ਵਦਨ੍ ਤਾਭ੍ਯਾਂ ਸਾਰ੍ੱਧੰ ਮਨ੍ਦਿਰੰ ਪ੍ਰਾਵਿਸ਼ਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ਤਤਃ ਸਰ੍ੱਵੇ ਲੋਕਾਸ੍ਤੰ ਗਮਨਾਗਮਨੇ ਕੁਰ੍ੱਵਨ੍ਤਮ੍ ਈਸ਼੍ਵਰੰ ਧਨ੍ਯੰ ਵਦਨ੍ਤਞ੍ਚ ਵਿਲੋਕ੍ਯ ");
INSERT INTO sanpun_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ਮਨ੍ਦਿਰਸ੍ਯ ਸੁਨ੍ਦਰੇ ਦ੍ਵਾਰੇ ਯ ਉਪਵਿਸ਼੍ਯ ਭਿਕ੍ਸ਼਼ਿਤਵਾਨ੍ ਸਏਵਾਯਮ੍ ਇਤਿ ਜ੍ਞਾਤ੍ਵਾ ਤੰ ਪ੍ਰਤਿ ਤਯਾ ਘਟਨਯਾ ਚਮਤ੍ਕ੍ਰੁʼਤਾ ਵਿਸ੍ਮਯਾਪੰਨਾਸ਼੍ਚਾਭਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","ਯਃ ਖਞ੍ਜਃ ਸ੍ਵਸ੍ਥੋਭਵਤ੍ ਤੇਨ ਪਿਤਰਯੋਹਨੋਃ ਕਰਯੋਰ੍ਧ੍ਟਤਯੋਃ ਸਤੋਃ ਸਰ੍ੱਵੇ ਲੋਕਾ ਸੰਨਿਧਿਮ੍ ਆਗੱਛਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ਤਦ੍ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਪਿਤਰਸ੍ਤੇਭ੍ਯੋ(ਅ)ਕਥਯਤ੍, ਹੇ ਇਸ੍ਰਾਯੇਲੀਯਲੋਕਾ ਯੂਯੰ ਕੁਤੋ (ਅ)ਨੇਨਾਸ਼੍ਚਰ੍ੱਯੰ ਮਨ੍ਯਧ੍ਵੇ? ਆਵਾਂ ਨਿਜਸ਼ਕ੍ਤ੍ਯਾ ਯਦ੍ਵਾ ਨਿਜਪੁਣ੍ਯੇਨ ਖਞ੍ਜਮਨੁਸ਼਼੍ਯਮੇਨੰ ਗਮਿਤਵਨ੍ਤਾਵਿਤਿ ਚਿਨ੍ਤਯਿਤ੍ਵਾ ਆਵਾਂ ਪ੍ਰਤਿ ਕੁਤੋ(ਅ)ਨਨ੍ਯਦ੍ਰੁʼਸ਼਼੍ਟਿੰ ਕੁਰੁਥ? ");
INSERT INTO sanpun_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","ਯੰ ਯੀਸ਼ੁੰ ਯੂਯੰ ਪਰਕਰੇਸ਼਼ੁ ਸਮਾਰ੍ਪਯਤ ਤਤੋ ਯੰ ਪੀਲਾਤੋ ਮੋਚਯਿਤੁਮ੍ ਏैੱਛਤ੍ ਤਥਾਪਿ ਯੂਯੰ ਤਸ੍ਯ ਸਾਕ੍ਸ਼਼ਾਨ੍ ਨਾਙ੍ਗੀਕ੍ਰੁʼਤਵਨ੍ਤ ਇਬ੍ਰਾਹੀਮ ਇਸ੍ਹਾਕੋ ਯਾਕੂਬਸ਼੍ਚੇਸ਼੍ਵਰੋ(ਅ)ਰ੍ਥਾਦ੍ ਅਸ੍ਮਾਕੰ ਪੂਰ੍ੱਵਪੁਰੁਸ਼਼ਾਣਾਮ੍ ਈਸ਼੍ਵਰਃ ਸ੍ਵਪੁਤ੍ਰਸ੍ਯ ਤਸ੍ਯ ਯੀਸ਼ੋ ਰ੍ਮਹਿਮਾਨੰ ਪ੍ਰਾਕਾਸ਼ਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","ਕਿਨ੍ਤੁ ਯੂਯੰ ਤੰ ਪਵਿਤ੍ਰੰ ਧਾਰ੍ੰਮਿਕੰ ਪੁਮਾਂਸੰ ਨਾਙ੍ਗੀਕ੍ਰੁʼਤ੍ਯ ਹਤ੍ਯਾਕਾਰਿਣਮੇਕੰ ਸ੍ਵੇਭ੍ਯੋ ਦਾਤੁਮ੍ ਅਯਾਚਧ੍ਵੰ| ");
INSERT INTO sanpun_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ਪਸ਼੍ਚਾਤ੍ ਤੰ ਜੀਵਨਸ੍ਯਾਧਿਪਤਿਮ੍ ਅਹਤ ਕਿਨ੍ਤ੍ਵੀਸ਼੍ਵਰਃ ਸ਼੍ਮਸ਼ਾਨਾਤ੍ ਤਮ੍ ਉਦਸ੍ਥਾਪਯਤ ਤਤ੍ਰ ਵਯੰ ਸਾਕ੍ਸ਼਼ਿਣ ਆਸ੍ਮਹੇ| ");
INSERT INTO sanpun_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ਇਮੰ ਯੰ ਮਾਨੁਸ਼਼ੰ ਯੂਯੰ ਪਸ਼੍ਯਥ ਪਰਿਚਿਨੁਥ ਚ ਸ ਤਸ੍ਯ ਨਾਮ੍ਨਿ ਵਿਸ਼੍ਵਾਸਕਰਣਾਤ੍ ਚਲਨਸ਼ਕ੍ਤਿੰ ਲਬ੍ਧਵਾਨ੍ ਤਸ੍ਮਿਨ੍ ਤਸ੍ਯ ਯੋ ਵਿਸ਼੍ਵਾਸਃ ਸ ਤੰ ਯੁਸ਼਼੍ਮਾਕੰ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਸਮ੍ਪੂਰ੍ਣਰੂਪੇਣ ਸ੍ਵਸ੍ਥਮ੍ ਅਕਾਰ੍ਸ਼਼ੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","ਹੇ ਭ੍ਰਾਤਰੋ ਯੂਯੰ ਯੁਸ਼਼੍ਮਾਕਮ੍ ਅਧਿਪਤਯਸ਼੍ਚ ਅਜ੍ਞਾਤ੍ਵਾ ਕਰ੍ੰਮਾਣ੍ਯੇਤਾਨਿ ਕ੍ਰੁʼਤਵਨ੍ਤ ਇਦਾਨੀਂ ਮਮੈਸ਼਼ ਬੋਧੋ ਜਾਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","ਕਿਨ੍ਤ੍ਵੀਸ਼੍ਵਰਃ ਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਦੁਃਖਭੋਗੇ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਾਂ ਮੁਖੇਭ੍ਯੋ ਯਾਂ ਯਾਂ ਕਥਾਂ ਪੂਰ੍ੱਵਮਕਥਯਤ੍ ਤਾਃ ਕਥਾ ਇੱਥੰ ਸਿੱਧਾ ਅਕਰੋਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","ਅਤਃ ਸ੍ਵੇਸ਼਼ਾਂ ਪਾਪਮੋਚਨਾਰ੍ਥੰ ਖੇਦੰ ਕ੍ਰੁʼਤ੍ਵਾ ਮਨਾਂਸਿ ਪਰਿਵਰ੍ੱਤਯਧ੍ਵੰ, ਤਸ੍ਮਾਦ੍ ਈਸ਼੍ਵਰਾਤ੍ ਸਾਨ੍ਤ੍ਵਨਾਪ੍ਰਾਪ੍ਤੇਃ ਸਮਯ ਉਪਸ੍ਥਾਸ੍ਯਤਿ; ");
INSERT INTO sanpun_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ਪੁਨਸ਼੍ਚ ਪੂਰ੍ੱਵਕਾਲਮ੍ ਆਰਭ੍ਯ ਪ੍ਰਚਾਰਿਤੋ ਯੋ ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟਸ੍ਤਮ੍ ਈਸ਼੍ਵਰੋ ਯੁਸ਼਼੍ਮਾਨ੍ ਪ੍ਰਤਿ ਪ੍ਰੇਸ਼਼ਯਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","ਕਿਨ੍ਤੁ ਜਗਤਃ ਸ੍ਰੁʼਸ਼਼੍ਟਿਮਾਰਭ੍ਯ ਈਸ਼੍ਵਰੋ ਨਿਜਪਵਿਤ੍ਰਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਗਣੋਨ ਯਥਾ ਕਥਿਤਵਾਨ੍ ਤਦਨੁਸਾਰੇਣ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਕਾਰ੍ੱਯਾਣਾਂ ਸਿੱਧਿਪਰ੍ੱਯਨ੍ਤੰ ਤੇਨ ਸ੍ਵਰ੍ਗੇ ਵਾਸਃ ਕਰ੍ੱਤਵ੍ਯਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","ਯੁਸ਼਼੍ਮਾਕੰ ਪ੍ਰਭੁਃ ਪਰਮੇਸ਼੍ਵਰੋ ਯੁਸ਼਼੍ਮਾਕੰ ਭ੍ਰਾਤ੍ਰੁʼਗਣਮਧ੍ਯਾਤ੍ ਮਤ੍ਸਦ੍ਰੁʼਸ਼ੰ ਭਵਿਸ਼਼੍ਯਦ੍ਵਕ੍ਤਾਰਮ੍ ਉਤ੍ਪਾਦਯਿਸ਼਼੍ਯਤਿ, ਤਤਃ ਸ ਯਤ੍ ਕਿਞ੍ਚਿਤ੍ ਕਥਯਿਸ਼਼੍ਯਤਿ ਤਤ੍ਰ ਯੂਯੰ ਮਨਾਂਸਿ ਨਿਧੱਧ੍ਵੰ| ");
INSERT INTO sanpun_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","ਕਿਨ੍ਤੁ ਯਃ ਕਸ਼੍ਚਿਤ੍ ਪ੍ਰਾਣੀ ਤਸ੍ਯ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਃ ਕਥਾਂ ਨ ਗ੍ਰਹੀਸ਼਼੍ਯਤਿ ਸ ਨਿਜਲੋਕਾਨਾਂ ਮਧ੍ਯਾਦ੍ ਉੱਛੇਤ੍ਸ੍ਯਤੇ,\" ਇਮਾਂ ਕਥਾਮ੍ ਅਸ੍ਮਾਕੰ ਪੂਰ੍ੱਵਪੁਰੁਸ਼਼ੇਭ੍ਯਃ ਕੇਵਲੋ ਮੂਸਾਃ ਕਥਯਾਮਾਸ ਇਤਿ ਨਹਿ, ");
INSERT INTO sanpun_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","ਸ਼ਿਮੂਯੇਲ੍ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਮ੍ ਆਰਭ੍ਯ ਯਾਵਨ੍ਤੋ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਕ੍ਯਮ੍ ਅਕਥਯਨ੍ ਤੇ ਸਰ੍ੱਵਏਵ ਸਮਯਸ੍ਯੈਤਸ੍ਯ ਕਥਾਮ੍ ਅਕਥਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","ਯੂਯਮਪਿ ਤੇਸ਼਼ਾਂ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਾਂ ਸਨ੍ਤਾਨਾਃ, \"ਤਵ ਵੰਸ਼ੋਦ੍ਭਵਪੁੰਸਾ ਸਰ੍ੱਵਦੇਸ਼ੀਯਾ ਲੋਕਾ ਆਸ਼ਿਸ਼਼ੰ ਪ੍ਰਾਪ੍ਤਾ ਭਵਿਸ਼਼੍ਯਨ੍ਤਿ\", ਇਬ੍ਰਾਹੀਮੇ ਕਥਾਮੇਤਾਂ ਕਥਯਿਤ੍ਵਾ ਈਸ਼੍ਵਰੋਸ੍ਮਾਕੰ ਪੂਰ੍ੱਵਪੁਰੁਸ਼਼ੈਃ ਸਾਰ੍ੱਧੰ ਯੰ ਨਿਯਮੰ ਸ੍ਥਿਰੀਕ੍ਰੁʼਤਵਾਨ੍ ਤਸ੍ਯ ਨਿਯਮਸ੍ਯਾਧਿਕਾਰਿਣੋਪਿ ਯੂਯੰ ਭਵਥ| ");
INSERT INTO sanpun_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ਅਤ ਈਸ਼੍ਵਰੋ ਨਿਜਪੁਤ੍ਰੰ ਯੀਸ਼ੁਮ੍ ਉੱਥਾਪ੍ਯ ਯੁਸ਼਼੍ਮਾਕੰ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਸ੍ਵਸ੍ਵਪਾਪਾਤ੍ ਪਰਾਵਰ੍ੱਤ੍ਯ ਯੁਸ਼਼੍ਮਭ੍ਯਮ੍ ਆਸ਼ਿਸ਼਼ੰ ਦਾਤੁੰ ਪ੍ਰਥਮਤਸ੍ਤੰ ਯੁਸ਼਼੍ਮਾਕੰ ਨਿਕਟੰ ਪ੍ਰੇਸ਼਼ਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","ਯਸ੍ਮਿਨ੍ ਸਮਯੇ ਪਿਤਰਯੋਹਨੌ ਲੋਕਾਨ੍ ਉਪਦਿਸ਼ਤਸ੍ਤਸ੍ਮਿਨ੍ ਸਮਯੇ ਯਾਜਕਾ ਮਨ੍ਦਿਰਸ੍ਯ ਸੇਨਾਪਤਯਃ ਸਿਦੂਕੀਗਣਸ਼੍ਚ ");
INSERT INTO sanpun_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ਤਯੋਰ੍ ਉਪਦੇਸ਼ਕਰਣੇ ਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯੋੱਥਾਨਮ੍ ਉਪਲਕ੍ਸ਼਼੍ਯ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਮ੍ਰੁʼਤਾਨਾਮ੍ ਉੱਥਾਨਪ੍ਰਸ੍ਤਾਵੇ ਚ ਵ੍ਯਗ੍ਰਾਃ ਸਨ੍ਤਸ੍ਤਾਵੁਪਾਗਮਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","ਤੌ ਧ੍ਰੁʼਤ੍ਵਾ ਦਿਨਾਵਸਾਨਕਾਰਣਾਤ੍ ਪਰਦਿਨਪਰ੍ੱਯਨਨ੍ਤੰ ਰੁੱਧ੍ਵਾ ਸ੍ਥਾਪਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","ਤਥਾਪਿ ਯੇ ਲੋਕਾਸ੍ਤਯੋਰੁਪਦੇਸ਼ਮ੍ ਅਸ਼੍ਰੁʼਣ੍ਵਨ੍ ਤੇਸ਼਼ਾਂ ਪ੍ਰਾਯੇਣ ਪਞ੍ਚਸਹਸ੍ਰਾਣਿ ਜਨਾ ਵ੍ਯਸ਼੍ਵਸਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","ਪਰੇ(ਅ)ਹਨਿ ਅਧਿਪਤਯਃ ਪ੍ਰਾਚੀਨਾ ਅਧ੍ਯਾਪਕਾਸ਼੍ਚ ਹਾਨਨਨਾਮਾ ਮਹਾਯਾਜਕਃ ");
INSERT INTO sanpun_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ਕਿਯਫਾ ਯੋਹਨ੍ ਸਿਕਨ੍ਦਰ ਇਤ੍ਯਾਦਯੋ ਮਹਾਯਾਜਕਸ੍ਯ ਜ੍ਞਾਤਯਃ ਸਰ੍ੱਵੇ ਯਿਰੂਸ਼ਾਲਮ੍ਨਗਰੇ ਮਿਲਿਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","ਅਨਨ੍ਤਰੰ ਪ੍ਰੇਰਿਤੌ ਮਧ੍ਯੇ ਸ੍ਥਾਪਯਿਤ੍ਵਾਪ੍ਰੁʼੱਛਨ੍ ਯੁਵਾਂ ਕਯਾ ਸ਼ਕ੍ਤਯਾ ਵਾ ਕੇਨ ਨਾਮ੍ਨਾ ਕਰ੍ੰਮਾਣ੍ਯੇਤਾਨਿ ਕੁਰੁਥਃ? ");
INSERT INTO sanpun_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","ਤਦਾ ਪਿਤਰਃ ਪਵਿਤ੍ਰੇਣਾਤ੍ਮਨਾ ਪਰਿਪੂਰ੍ਣਃ ਸਨ੍ ਪ੍ਰਤ੍ਯਵਾਦੀਤ੍, ਹੇ ਲੋਕਾਨਾਮ੍ ਅਧਿਪਤਿਗਣ ਹੇ ਇਸ੍ਰਾਯੇਲੀਯਪ੍ਰਾਚੀਨਾਃ, ");
INSERT INTO sanpun_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ਏਤਸ੍ਯ ਦੁਰ੍ੱਬਲਮਾਨੁਸ਼਼ਸ੍ਯ ਹਿਤੰ ਯਤ੍ ਕਰ੍ੰਮਾਕ੍ਰਿਯਤ, ਅਰ੍ਥਾਤ੍, ਸ ਯੇਨ ਪ੍ਰਕਾਰੇਣ ਸ੍ਵਸ੍ਥੋਭਵਤ੍ ਤੱਚੇਦ੍ ਅਦ੍ਯਾਵਾਂ ਪ੍ਰੁʼੱਛਥ, ");
INSERT INTO sanpun_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ਤਰ੍ਹਿ ਸਰ੍ੱਵ ਇਸ੍ਰਾਯੇेਲੀਯਲੋਕਾ ਯੂਯੰ ਜਾਨੀਤ ਨਾਸਰਤੀਯੋ ਯੋ ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟਃ ਕ੍ਰੁਸ਼ੇ ਯੁਸ਼਼੍ਮਾਭਿਰਵਿਧ੍ਯਤ ਯਸ਼੍ਚੇਸ਼੍ਵਰੇਣ ਸ਼੍ਮਸ਼ਾਨਾਦ੍ ਉੱਥਾਪਿਤਃ, ਤਸ੍ਯ ਨਾਮ੍ਨਾ ਜਨੋਯੰ ਸ੍ਵਸ੍ਥਃ ਸਨ੍ ਯੁਸ਼਼੍ਮਾਕੰ ਸੰਮੁਖੇ ਪ੍ਰੋੱਤਿਸ਼਼੍ਠਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","ਨਿਚੇਤ੍ਰੁʼਭਿ ਰ੍ਯੁਸ਼਼੍ਮਾਭਿਰਯੰ ਯਃ ਪ੍ਰਸ੍ਤਰੋ(ਅ)ਵਜ੍ਞਾਤੋ(ਅ)ਭਵਤ੍ ਸ ਪ੍ਰਧਾਨਕੋਣਸ੍ਯ ਪ੍ਰਸ੍ਤਰੋ(ਅ)ਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","ਤਦ੍ਭਿੰਨਾਦਪਰਾਤ੍ ਕਸ੍ਮਾਦਪਿ ਪਰਿਤ੍ਰਾਣੰ ਭਵਿਤੁੰ ਨ ਸ਼ਕ੍ਨੋਤਿ, ਯੇਨ ਤ੍ਰਾਣੰ ਪ੍ਰਾਪ੍ਯੇਤ ਭੂਮਣ੍ਡਲਸ੍ਯਲੋਕਾਨਾਂ ਮਧ੍ਯੇ ਤਾਦ੍ਰੁʼਸ਼ੰ ਕਿਮਪਿ ਨਾਮ ਨਾਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ਤਦਾ ਪਿਤਰਯੋਹਨੋਰੇਤਾਦ੍ਰੁʼਸ਼ੀਮ੍ ਅਕ੍ਸ਼਼ੇਭਤਾਂ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਤਾਵਵਿਦ੍ਵਾਂਸੌ ਨੀਚਲੋਕਾਵਿਤਿ ਬੁੱਧ੍ਵਾ ਆਸ਼੍ਚਰ੍ੱਯਮ੍ ਅਮਨ੍ਯਨ੍ਤ ਤੌ ਚ ਯੀਸ਼ੋਃ ਸਙ੍ਗਿਨੌ ਜਾਤਾਵਿਤਿ ਜ੍ਞਾਤੁਮ੍ ਅਸ਼ਕ੍ਨੁਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","ਕਿਨ੍ਤੁ ਤਾਭ੍ਯਾਂ ਸਾਰ੍ੱਧੰ ਤੰ ਸ੍ਵਸ੍ਥਮਾਨੁਸ਼਼ੰ ਤਿਸ਼਼੍ਠਨ੍ਤੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਤੇ ਕਾਮਪ੍ਯਪਰਾਮ੍ ਆਪੱਤਿੰ ਕਰ੍ੱਤੰ ਨਾਸ਼ਕ੍ਨੁਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","ਤਦਾ ਤੇ ਸਭਾਤਃ ਸ੍ਥਾਨਾਨ੍ਤਰੰ ਗਨ੍ਤੁੰ ਤਾਨ੍ ਆਜ੍ਞਾਪ੍ਯ ਸ੍ਵਯੰ ਪਰਸ੍ਪਰਮ੍ ਇਤਿ ਮਨ੍ਤ੍ਰਣਾਮਕੁਰ੍ੱਵਨ੍ ");
INSERT INTO sanpun_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ਤੌ ਮਾਨਵੌ ਪ੍ਰਤਿ ਕਿੰ ਕਰ੍ੱਤਵ੍ਯੰ? ਤਾਵੇਕੰ ਪ੍ਰਸਿੱਧਮ੍ ਆਸ਼੍ਚਰ੍ੱਯੰ ਕਰ੍ੰਮ ਕ੍ਰੁʼਤਵਨ੍ਤੌ ਤਦ੍ ਯਿਰੂਸ਼ਾਲਮ੍ਨਿਵਾਸਿਨਾਂ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਲੋਕਾਨਾਂ ਸਮੀਪੇ ਪ੍ਰਾਕਾਸ਼ਤ ਤੱਚ ਵਯਮਪਹ੍ਨੋਤੁੰ ਨ ਸ਼ਕ੍ਨੁਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","ਕਿਨ੍ਤੁ ਲੋਕਾਨਾਂ ਮਧ੍ਯਮ੍ ਏਤਦ੍ ਯਥਾ ਨ ਵ੍ਯਾਪ੍ਨੋਤਿ ਤਦਰ੍ਥੰ ਤੌ ਭਯੰ ਪ੍ਰਦਰ੍ਸ਼੍ਯ ਤੇਨ ਨਾਮ੍ਨਾ ਕਮਪਿ ਮਨੁਸ਼਼੍ਯੰ ਨੋਪਦਿਸ਼ਤਮ੍ ਇਤਿ ਦ੍ਰੁʼਢੰ ਨਿਸ਼਼ੇਧਾਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ਤਤਸ੍ਤੇ ਪ੍ਰੇਰਿਤਾਵਾਹੂਯ ਏਤਦਾਜ੍ਞਾਪਯਨ੍ ਇਤਃ ਪਰੰ ਯੀਸ਼ੋ ਰ੍ਨਾਮ੍ਨਾ ਕਦਾਪਿ ਕਾਮਪਿ ਕਥਾਂ ਮਾ ਕਥਯਤੰ ਕਿਮਪਿ ਨੋਪਦਿਸ਼ਞ੍ਚ| ");
INSERT INTO sanpun_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","ਤਤਃ ਪਿਤਰਯੋਹਨੌ ਪ੍ਰਤ੍ਯਵਦਤਾਮ੍ ਈਸ਼੍ਵਰਸ੍ਯਾਜ੍ਞਾਗ੍ਰਹਣੰ ਵਾ ਯੁਸ਼਼੍ਮਾਕਮ੍ ਆਜ੍ਞਾਗ੍ਰਹਣਮ੍ ਏਤਯੋ ਰ੍ਮਧ੍ਯੇ ਈਸ਼੍ਵਰਸ੍ਯ ਗੋਚਰੇ ਕਿੰ ਵਿਹਿਤੰ? ਯੂਯੰ ਤਸ੍ਯ ਵਿਵੇਚਨਾਂ ਕੁਰੁਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","ਵਯੰ ਯਦ੍ ਅਪਸ਼੍ਯਾਮ ਯਦਸ਼੍ਰੁʼਣੁਮ ਚ ਤੰਨ ਪ੍ਰਚਾਰਯਿਸ਼਼੍ਯਾਮ ਏਤਤ੍ ਕਦਾਪਿ ਭਵਿਤੁੰ ਨ ਸ਼ਕ੍ਨੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","ਯਦਘਟਤ ਤਦ੍ ਦ੍ਰੁʼਸ਼਼੍ਟਾ ਸਰ੍ੱਵੇ ਲੋਕਾ ਈਸ਼੍ਵਰਸ੍ਯ ਗੁਣਾਨ੍ ਅਨ੍ਵਵਦਨ੍ ਤਸ੍ਮਾਤ੍ ਲੋਕਭਯਾਤ੍ ਤੌ ਦਣ੍ਡਯਿਤੁੰ ਕਮਪ੍ਯੁਪਾਯੰ ਨ ਪ੍ਰਾਪ੍ਯ ਤੇ ਪੁਨਰਪਿ ਤਰ੍ਜਯਿਤ੍ਵਾ ਤਾਵਤ੍ਯਜਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ਯਸ੍ਯ ਮਾਨੁਸ਼਼ਸ੍ਯੈਤਤ੍ ਸ੍ਵਾਸ੍ਥ੍ਯਕਰਣਮ੍ ਆਸ਼੍ਚਰ੍ੱਯੰ ਕਰ੍ੰਮਾਕ੍ਰਿਯਤ ਤਸ੍ਯ ਵਯਸ਼੍ਚਤ੍ਵਾਰਿੰਸ਼ਦ੍ਵਤ੍ਸਰਾ ਵ੍ਯਤੀਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ਤਤਃ ਪਰੰ ਤੌ ਵਿਸ੍ਰੁʼਸ਼਼੍ਟੌ ਸਨ੍ਤੌ ਸ੍ਵਸਙ੍ਗਿਨਾਂ ਸੰਨਿਧਿੰ ਗਤ੍ਵਾ ਪ੍ਰਧਾਨਯਾਜਕੈਃ ਪ੍ਰਾਚੀਨਲੋਕੈਸ਼੍ਚ ਪ੍ਰੋਕ੍ਤਾਃ ਸਰ੍ੱਵਾਃ ਕਥਾ ਜ੍ਞਾਪਿਤਵਨ੍ਤੌ| ");
INSERT INTO sanpun_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ਤੱਛ੍ਰੁਤ੍ਵਾ ਸਰ੍ੱਵ ਏਕਚਿੱਤੀਭੂਯ ਈਸ਼੍ਵਰਮੁੱਦਿਸ਼੍ਯ ਪ੍ਰੋੱਚੈਰੇਤਤ੍ ਪ੍ਰਾਰ੍ਥਯਨ੍ਤ, ਹੇ ਪ੍ਰਭੋ ਗਗਣਪ੍ਰੁʼਥਿਵੀਪਯੋਧੀਨਾਂ ਤੇਸ਼਼ੁ ਚ ਯਦ੍ਯਦ੍ ਆਸ੍ਤੇ ਤੇਸ਼਼ਾਂ ਸ੍ਰਸ਼਼੍ਟੇਸ਼੍ਵਰਸ੍ਤ੍ਵੰ| ");
INSERT INTO sanpun_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ਤ੍ਵੰ ਨਿਜਸੇਵਕੇਨ ਦਾਯੂਦਾ ਵਾਕ੍ਯਮਿਦਮ੍ ਉਵਚਿਥ, ਮਨੁਸ਼਼੍ਯਾ ਅਨ੍ਯਦੇਸ਼ੀਯਾਃ ਕੁਰ੍ੱਵਨ੍ਤਿ ਕਲਹੰ ਕੁਤਃ| ਲੋਕਾਃ ਸਰ੍ੱਵੇ ਕਿਮਰ੍ਥੰ ਵਾ ਚਿਨ੍ਤਾਂ ਕੁਰ੍ੱਵਨ੍ਤਿ ਨਿਸ਼਼੍ਫਲਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ਪਰਮੇਸ਼ਸ੍ਯ ਤੇਨੈਵਾਭਿਸ਼਼ਿਕ੍ਤਸ੍ਯ ਜਨਸ੍ਯ ਚ| ਵਿਰੁੱਧਮਭਿਤਿਸ਼਼੍ਠਨ੍ਤਿ ਪ੍ਰੁʼਥਿਵ੍ਯਾਃ ਪਤਯਃ ਕੁਤਃ|| ");
INSERT INTO sanpun_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","ਫਲਤਸ੍ਤਵ ਹਸ੍ਤੇਨ ਮਨ੍ਤ੍ਰਣਯਾ ਚ ਪੂਰ੍ੱਵ ਯਦ੍ਯਤ੍ ਸ੍ਥਿਰੀਕ੍ਰੁʼਤੰ ਤਦ੍ ਯਥਾ ਸਿੱਧੰ ਭਵਤਿ ਤਦਰ੍ਥੰ ਤ੍ਵੰ ਯਮ੍ ਅਥਿਸ਼਼ਿਕ੍ਤਵਾਨ੍ ਸ ਏਵ ਪਵਿਤ੍ਰੋ ਯੀਸ਼ੁਸ੍ਤਸ੍ਯ ਪ੍ਰਾਤਿਕੂਲ੍ਯੇਨ ਹੇਰੋਦ੍ ਪਨ੍ਤੀਯਪੀਲਾਤੋ ");
INSERT INTO sanpun_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","(ਅ)ਨ੍ਯਦੇਸ਼ੀਯਲੋਕਾ ਇਸ੍ਰਾਯੇੱਲੋਕਾਸ਼੍ਚ ਸਰ੍ੱਵ ਏਤੇ ਸਭਾਯਾਮ੍ ਅਤਿਸ਼਼੍ਠਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ਹੇ ਪਰਮੇਸ਼੍ਵਰ ਅਧੁਨਾ ਤੇਸ਼਼ਾਂ ਤਰ੍ਜਨੰ ਗਰ੍ਜਨਞ੍ਚ ਸ਼੍ਰੁʼਣੁ; ");
INSERT INTO sanpun_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ਤਥਾ ਸ੍ਵਾਸ੍ਥ੍ਯਕਰਣਕਰ੍ੰਮਣਾ ਤਵ ਬਾਹੁਬਲਪ੍ਰਕਾਸ਼ਪੂਰ੍ੱਵਕੰ ਤਵ ਸੇਵਕਾਨ੍ ਨਿਰ੍ਭਯੇਨ ਤਵ ਵਾਕ੍ਯੰ ਪ੍ਰਚਾਰਯਿਤੁੰ ਤਵ ਪਵਿਤ੍ਰਪੁਤ੍ਰਸ੍ਯ ਯੀਸ਼ੋ ਰ੍ਨਾਮ੍ਨਾ ਆਸ਼੍ਚਰ੍ੱਯਾਣ੍ਯਸਮ੍ਭਵਾਨਿ ਚ ਕਰ੍ੰਮਾਣਿ ਕਰ੍ੱਤੁਞ੍ਚਾਜ੍ਞਾਪਯ| ");
INSERT INTO sanpun_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ਇੱਥੰ ਪ੍ਰਾਰ੍ਥਨਯਾ ਯਤ੍ਰ ਸ੍ਥਾਨੇ ਤੇ ਸਭਾਯਾਮ੍ ਆਸਨ੍ ਤਤ੍ ਸ੍ਥਾਨੰ ਪ੍ਰਾਕਮ੍ਪਤ; ਤਤਃ ਸਰ੍ੱਵੇ ਪਵਿਤ੍ਰੇਣਾਤ੍ਮਨਾ ਪਰਿਪੂਰ੍ਣਾਃ ਸਨ੍ਤ ਈਸ਼੍ਵਰਸ੍ਯ ਕਥਾਮ੍ ਅਕ੍ਸ਼਼ੋਭੇਣ ਪ੍ਰਾਚਾਰਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","ਅਪਰਞ੍ਚ ਪ੍ਰਤ੍ਯਯਕਾਰਿਲੋਕਸਮੂਹਾ ਏਕਮਨਸ ਏਕਚਿੱਤੀਭੂਯ ਸ੍ਥਿਤਾਃ| ਤੇਸ਼਼ਾਂ ਕੇਪਿ ਨਿਜਸਮ੍ਪੱਤਿੰ ਸ੍ਵੀਯਾਂ ਨਾਜਾਨਨ੍ ਕਿਨ੍ਤੁ ਤੇਸ਼਼ਾਂ ਸਰ੍ੱਵਾਃ ਸਮ੍ਪੱਤ੍ਯਃ ਸਾਧਾਰਣ੍ਯੇਨ ਸ੍ਥਿਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","ਅਨ੍ਯੱਚ ਪ੍ਰੇਰਿਤਾ ਮਹਾਸ਼ਕ੍ਤਿਪ੍ਰਕਾਸ਼ਪੂਰ੍ੱਵਕੰ ਪ੍ਰਭੋ ਰ੍ਯੀਸ਼ੋਰੁੱਥਾਨੇ ਸਾਕ੍ਸ਼਼੍ਯਮ੍ ਅਦਦੁਃ, ਤੇਸ਼਼ੁ ਸਰ੍ੱਵੇਸ਼਼ੁ ਮਹਾਨੁਗ੍ਰਹੋ(ਅ)ਭਵੱਚ| ");
INSERT INTO sanpun_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","ਤੇਸ਼਼ਾਂ ਮਧ੍ਯੇ ਕਸ੍ਯਾਪਿ ਦ੍ਰਵ੍ਯਨ੍ਯੂਨਤਾ ਨਾਭਵਦ੍ ਯਤਸ੍ਤੇਸ਼਼ਾਂ ਗ੍ਰੁʼਹਭੂਮ੍ਯਾਦ੍ਯਾ ਯਾਃ ਸਮ੍ਪੱਤਯ ਆਸਨ੍ ਤਾ ਵਿਕ੍ਰੀਯ ");
INSERT INTO sanpun_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ਤਨ੍ਮੂਲ੍ਯਮਾਨੀਯ ਪ੍ਰੇਰਿਤਾਨਾਂ ਚਰਣੇਸ਼਼ੁ ਤੈਃ ਸ੍ਥਾਪਿਤੰ; ਤਤਃ ਪ੍ਰਤ੍ਯੇਕਸ਼ਃ ਪ੍ਰਯੋਜਨਾਨੁਸਾਰੇਣ ਦੱਤਮਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","ਵਿਸ਼ੇਸ਼਼ਤਃ ਕੁਪ੍ਰੋਪਦ੍ਵੀਪੀਯੋ ਯੋਸਿਨਾਮਕੋ ਲੇਵਿਵੰਸ਼ਜਾਤ ਏਕੋ ਜਨੋ ਭੂਮ੍ਯਧਿਕਾਰੀ, ਯੰ ਪ੍ਰੇਰਿਤਾ ਬਰ੍ਣੱਬਾ ਅਰ੍ਥਾਤ੍ ਸਾਨ੍ਤ੍ਵਨਾਦਾਯਕ ਇਤ੍ਯੁਕ੍ਤ੍ਵਾ ਸਮਾਹੂਯਨ੍, ");
INSERT INTO sanpun_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ਸ ਜਨੋ ਨਿਜਭੂਮਿੰ ਵਿਕ੍ਰੀਯ ਤਨ੍ਮੂਲ੍ਯਮਾਨੀਯ ਪ੍ਰੇਰਿਤਾਨਾਂ ਚਰਣੇਸ਼਼ੁ ਸ੍ਥਾਪਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","ਤਦਾ ਅਨਾਨਿਯਨਾਮਕ ਏਕੋ ਜਨੋ ਯਸ੍ਯ ਭਾਰ੍ੱਯਾਯਾ ਨਾਮ ਸਫੀਰਾ ਸ ਸ੍ਵਾਧਿਕਾਰੰ ਵਿਕ੍ਰੀਯ ");
INSERT INTO sanpun_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ਸ੍ਵਭਾਰ੍ੱਯਾਂ ਜ੍ਞਾਪਯਿਤ੍ਵਾ ਤਨ੍ਮੂਲ੍ਯਸ੍ਯੈਕਾਂਸ਼ੰ ਸਙ੍ਗੋਪ੍ਯ ਸ੍ਥਾਪਯਿਤ੍ਵਾ ਤਦਨ੍ਯਾਂਸ਼ਮਾਤ੍ਰਮਾਨੀਯ ਪ੍ਰੇਰਿਤਾਨਾਂ ਚਰਣੇਸ਼਼ੁ ਸਮਰ੍ਪਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ਤਸ੍ਮਾਤ੍ ਪਿਤਰੋਕਥਯਤ੍ ਹੇ ਅਨਾਨਿਯ ਭੂਮੇ ਰ੍ਮੂਲ੍ਯੰ ਕਿਞ੍ਚਿਤ੍ ਸਙ੍ਗੋਪ੍ਯ ਸ੍ਥਾਪਯਿਤੁੰ ਪਵਿਤ੍ਰਸ੍ਯਾਤ੍ਮਨਃ ਸੰਨਿਧੌ ਮ੍ਰੁʼਸ਼਼ਾਵਾਕ੍ਯੰ ਕਥਯਿਤੁਞ੍ਚ ਸ਼ੈਤਾਨ੍ ਕੁਤਸ੍ਤਵਾਨ੍ਤਃਕਰਣੇ ਪ੍ਰਵ੍ਰੁʼੱਤਿਮਜਨਯਤ੍? ");
INSERT INTO sanpun_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","ਸਾ ਭੂਮਿ ਰ੍ਯਦਾ ਤਵ ਹਸ੍ਤਗਤਾ ਤਦਾ ਕਿੰ ਤਵ ਸ੍ਵੀਯਾ ਨਾਸੀਤ੍? ਤਰ੍ਹਿ ਸ੍ਵਾਨ੍ਤਃਕਰਣੇ ਕੁਤ ਏਤਾਦ੍ਰੁʼਸ਼ੀ ਕੁਕਲ੍ਪਨਾ ਤ੍ਵਯਾ ਕ੍ਰੁʼਤਾ? ਤ੍ਵੰ ਕੇਵਲਮਨੁਸ਼਼੍ਯਸ੍ਯ ਨਿਕਟੇ ਮ੍ਰੁʼਸ਼਼ਾਵਾਕ੍ਯੰ ਨਾਵਾਦੀਃ ਕਿਨ੍ਤ੍ਵੀਸ਼੍ਵਰਸ੍ਯ ਨਿਕਟੇ(ਅ)ਪਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ਏਤਾਂ ਕਥਾਂ ਸ਼੍ਰੁਤ੍ਵੈਵ ਸੋ(ਅ)ਨਾਨਿਯੋ ਭੂਮੌ ਪਤਨ੍ ਪ੍ਰਾਣਾਨ੍ ਅਤ੍ਯਜਤ੍, ਤਦ੍ਵ੍ਰੁʼੱਤਾਨ੍ਤੰ ਯਾਵਨ੍ਤੋ ਲੋਕਾ ਅਸ਼੍ਰੁʼਣ੍ਵਨ੍ ਤੇਸ਼਼ਾਂ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਮਹਾਭਯਮ੍ ਅਜਾਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","ਤਦਾ ਯੁਵਲੋਕਾਸ੍ਤੰ ਵਸ੍ਤ੍ਰੇਣਾੱਛਾਦ੍ਯ ਬਹਿ ਰ੍ਨੀਤ੍ਵਾ ਸ਼੍ਮਸ਼ਾਨੇ(ਅ)ਸ੍ਥਾਪਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","ਤਤਃ ਪ੍ਰਹਰੈਕਾਨਨ੍ਤਰੰ ਕਿੰ ਵ੍ਰੁʼੱਤੰ ਤੰਨਾਵਗਤ੍ਯ ਤਸ੍ਯ ਭਾਰ੍ੱਯਾਪਿ ਤਤ੍ਰ ਸਮੁਪਸ੍ਥਿਤਾ| ");
INSERT INTO sanpun_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ਤਤਃ ਪਿਤਰਸ੍ਤਾਮ੍ ਅਪ੍ਰੁʼੱਛਤ੍, ਯੁਵਾਭ੍ਯਾਮ੍ ਏਤਾਵਨ੍ਮੁਦ੍ਰਾਭ੍ਯੋ ਭੂਮਿ ਰ੍ਵਿਕ੍ਰੀਤਾ ਨ ਵਾ? ਏਤਤ੍ਵੰ ਵਦ; ਤਦਾ ਸਾ ਪ੍ਰਤ੍ਯਵਾਦੀਤ੍ ਸਤ੍ਯਮ੍ ਏਤਾਵਦ੍ਭ੍ਯੋ ਮੁਦ੍ਰਾਭ੍ਯ ਏਵ| ");
INSERT INTO sanpun_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ਤਤਃ ਪਿਤਰੋਕਥਯਤ੍ ਯੁਵਾਂ ਕਥੰ ਪਰਮੇਸ਼੍ਵਰਸ੍ਯਾਤ੍ਮਾਨੰ ਪਰੀਕ੍ਸ਼਼ਿਤੁਮ੍ ਏਕਮਨ੍ਤ੍ਰਣਾਵਭਵਤਾਂ? ਪਸ਼੍ਯ ਯੇ ਤਵ ਪਤਿੰ ਸ਼੍ਮਸ਼ਾਨੇ ਸ੍ਥਾਪਿਤਵਨ੍ਤਸ੍ਤੇ ਦ੍ਵਾਰਸ੍ਯ ਸਮੀਪੇ ਸਮੁਪਤਿਸ਼਼੍ਠਨ੍ਤਿ ਤ੍ਵਾਮਪਿ ਬਹਿਰ੍ਨੇਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ਤਤਃ ਸਾਪਿ ਤਸ੍ਯ ਚਰਣਸੰਨਿਧੌ ਪਤਿਤ੍ਵਾ ਪ੍ਰਾਣਾਨ੍ ਅਤ੍ਯਾਕ੍ਸ਼਼ੀਤ੍| ਪਸ਼੍ਚਾਤ੍ ਤੇ ਯੁਵਾਨੋ(ਅ)ਭ੍ਯਨ੍ਤਰਮ੍ ਆਗਤ੍ਯ ਤਾਮਪਿ ਮ੍ਰੁʼਤਾਂ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਬਹਿ ਰ੍ਨੀਤ੍ਵਾ ਤਸ੍ਯਾਃ ਪਤ੍ਯੁਃ ਪਾਰ੍ਸ਼੍ਵੇ ਸ਼੍ਮਸ਼ਾਨੇ ਸ੍ਥਾਪਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","ਤਸ੍ਮਾਤ੍ ਮਣ੍ਡਲ੍ਯਾਃ ਸਰ੍ੱਵੇ ਲੋਕਾ ਅਨ੍ਯਲੋਕਾਸ਼੍ਚ ਤਾਂ ਵਾਰ੍ੱਤਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਸਾਧ੍ਵਸੰ ਗਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","ਤਤਃ ਪਰੰ ਪ੍ਰੇਰਿਤਾਨਾਂ ਹਸ੍ਤੈ ਰ੍ਲੋਕਾਨਾਂ ਮਧ੍ਯੇ ਬਹ੍ਵਾਸ਼੍ਚਰ੍ੱਯਾਣ੍ਯਦ੍ਭੁਤਾਨਿ ਕਰ੍ੰਮਾਣ੍ਯਕ੍ਰਿਯਨ੍ਤ; ਤਦਾ ਸ਼ਿਸ਼਼੍ਯਾਃ ਸਰ੍ੱਵ ਏਕਚਿੱਤੀਭੂਯ ਸੁਲੇਮਾਨੋ (ਅ)ਲਿਨ੍ਦੇ ਸਮ੍ਭੂਯਾਸਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","ਤੇਸ਼਼ਾਂ ਸਙ੍ਘਾਨ੍ਤਰ੍ਗੋ ਭਵਿਤੁੰ ਕੋਪਿ ਪ੍ਰਗਲ੍ਭਤਾਂ ਨਾਗਮਤ੍ ਕਿਨ੍ਤੁ ਲੋਕਾਸ੍ਤਾਨ੍ ਸਮਾਦ੍ਰਿਯਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","ਸ੍ਤ੍ਰਿਯਃ ਪੁਰੁਸ਼਼ਾਸ਼੍ਚ ਬਹਵੋ ਲੋਕਾ ਵਿਸ਼੍ਵਾਸ੍ਯ ਪ੍ਰਭੁੰ ਸ਼ਰਣਮਾਪੰਨਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","ਪਿਤਰਸ੍ਯ ਗਮਨਾਗਮਨਾਭ੍ਯਾਂ ਕੇਨਾਪਿ ਪ੍ਰਕਾਰੇਣ ਤਸ੍ਯ ਛਾਯਾ ਕਸ੍ਮਿੰਸ਼੍ਚਿੱਜਨੇ ਲਗਿਸ਼਼੍ਯਤੀਤ੍ਯਾਸ਼ਯਾ ਲੋਕਾ ਰੋਗਿਣਃ ਸ਼ਿਵਿਕਯਾ ਖਟ੍ਵਯਾ ਚਾਨੀਯ ਪਥਿ ਪਥਿ ਸ੍ਥਾਪਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","ਚਤੁਰ੍ਦਿਕ੍ਸ੍ਥਨਗਰੇਭ੍ਯੋ ਬਹਵੋ ਲੋਕਾਃ ਸਮ੍ਭੂਯ ਰੋਗਿਣੋ(ਅ)ਪਵਿਤ੍ਰਭੁਤਗ੍ਰਸ੍ਤਾਂਸ਼੍ਚ ਯਿਰੂਸ਼ਾਲਮਮ੍ ਆਨਯਨ੍ ਤਤਃ ਸਰ੍ੱਵੇ ਸ੍ਵਸ੍ਥਾ ਅਕ੍ਰਿਯਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","ਅਨਨ੍ਤਰੰ ਮਹਾਯਾਜਕਃ ਸਿਦੂਕਿਨਾਂ ਮਤਗ੍ਰਾਹਿਣਸ੍ਤੇਸ਼਼ਾਂ ਸਹਚਰਾਸ਼੍ਚ ");
INSERT INTO sanpun_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ਮਹਾਕ੍ਰੋਧਾਨ੍ਤ੍ਵਿਤਾਃ ਸਨ੍ਤਃ ਪ੍ਰੇਰਿਤਾਨ੍ ਧ੍ਰੁʼਤ੍ਵਾ ਨੀਚਲੋਕਾਨਾਂ ਕਾਰਾਯਾਂ ਬੱਧ੍ਵਾ ਸ੍ਥਾਪਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","ਕਿਨ੍ਤੁ ਰਾਤ੍ਰੌ ਪਰਮੇਸ਼੍ਵਰਸ੍ਯ ਦੂਤਃ ਕਾਰਾਯਾ ਦ੍ਵਾਰੰ ਮੋਚਯਿਤ੍ਵਾ ਤਾਨ੍ ਬਹਿਰਾਨੀਯਾਕਥਯਤ੍, ");
INSERT INTO sanpun_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","ਯੂਯੰ ਗਤ੍ਵਾ ਮਨ੍ਦਿਰੇ ਦਣ੍ਡਾਯਮਾਨਾਃ ਸਨ੍ਤੋ ਲੋਕਾਨ੍ ਪ੍ਰਤੀਮਾਂ ਜੀਵਨਦਾਯਿਕਾਂ ਸਰ੍ੱਵਾਂ ਕਥਾਂ ਪ੍ਰਚਾਰਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ਇਤਿ ਸ਼੍ਰੁਤ੍ਵਾ ਤੇ ਪ੍ਰਤ੍ਯੂਸ਼਼ੇ ਮਨ੍ਦਿਰ ਉਪਸ੍ਥਾਯ ਉਪਦਿਸ਼਼੍ਟਵਨ੍ਤਃ| ਤਦਾ ਸਹਚਰਗਣੇਨ ਸਹਿਤੋ ਮਹਾਯਾਜਕ ਆਗਤ੍ਯ ਮਨ੍ਤ੍ਰਿਗਣਮ੍ ਇਸ੍ਰਾਯੇਲ੍ਵੰਸ਼ਸ੍ਯ ਸਰ੍ੱਵਾਨ੍ ਰਾਜਸਭਾਸਦਃ ਸਭਾਸ੍ਥਾਨ੍ ਕ੍ਰੁʼਤ੍ਵਾ ਕਾਰਾਯਾਸ੍ਤਾਨ੍ ਆਪਯਿਤੁੰ ਪਦਾਤਿਗਣੰ ਪ੍ਰੇਰਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","ਤਤਸ੍ਤੇ ਗਤ੍ਵਾ ਕਾਰਾਯਾਂ ਤਾਨ੍ ਅਪ੍ਰਾਪ੍ਯ ਪ੍ਰਤ੍ਯਾਗਤ੍ਯ ਇਤਿ ਵਾਰ੍ੱਤਾਮ੍ ਅਵਾਦਿਸ਼਼ੁਃ, ");
INSERT INTO sanpun_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ਵਯੰ ਤਤ੍ਰ ਗਤ੍ਵਾ ਨਿਰ੍ੱਵਿਘ੍ਨੰ ਕਾਰਾਯਾ ਦ੍ਵਾਰੰ ਰੁੱਧੰ ਰਕ੍ਸ਼਼ਕਾਂਸ਼੍ਚ ਦ੍ਵਾਰਸ੍ਯ ਬਹਿਰ੍ਦਣ੍ਡਾਯਮਾਨਾਨ੍ ਅਦਰ੍ਸ਼ਾਮ ਏਵ ਕਿਨ੍ਤੁ ਦ੍ਵਾਰੰ ਮੋਚਯਿਤ੍ਵਾ ਤਨ੍ਮਧ੍ਯੇ ਕਮਪਿ ਦ੍ਰਸ਼਼੍ਟੁੰ ਨ ਪ੍ਰਾਪ੍ਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ਏਤਾਂ ਕਥਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਮਹਾਯਾਜਕੋ ਮਨ੍ਦਿਰਸ੍ਯ ਸੇਨਾਪਤਿਃ ਪ੍ਰਧਾਨਯਾਜਕਾਸ਼੍ਚ, ਇਤ ਪਰੰ ਕਿਮਪਰੰ ਭਵਿਸ਼਼੍ਯਤੀਤਿ ਚਿਨ੍ਤਯਿਤ੍ਵਾ ਸਨ੍ਦਿਗ੍ਧਚਿੱਤਾ ਅਭਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ਏਤਸ੍ਮਿੰਨੇਵ ਸਮਯੇ ਕਸ਼੍ਚਿਤ੍ ਜਨ ਆਗਤ੍ਯ ਵਾਰ੍ੱਤਾਮੇਤਾਮ੍ ਅਵਦਤ੍ ਪਸ਼੍ਯਤ ਯੂਯੰ ਯਾਨ੍ ਮਾਨਵਾਨ੍ ਕਾਰਾਯਾਮ੍ ਅਸ੍ਥਾਪਯਤ ਤੇ ਮਨ੍ਦਿਰੇ ਤਿਸ਼਼੍ਠਨ੍ਤੋ ਲੋਕਾਨ੍ ਉਪਦਿਸ਼ਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","ਤਦਾ ਮਨ੍ਦਿਰਸ੍ਯ ਸੇਨਾਪਤਿਃ ਪਦਾਤਯਸ਼੍ਚ ਤਤ੍ਰ ਗਤ੍ਵਾ ਚੇੱਲੋਕਾਃ ਪਾਸ਼਼ਾਣਾਨ੍ ਨਿਕ੍ਸ਼਼ਿਪ੍ਯਾਸ੍ਮਾਨ੍ ਮਾਰਯਨ੍ਤੀਤਿ ਭਿਯਾ ਵਿਨਤ੍ਯਾਚਾਰੰ ਤਾਨ੍ ਆਨਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","ਤੇ ਮਹਾਸਭਾਯਾ ਮਧ੍ਯੇ ਤਾਨ੍ ਅਸ੍ਥਾਪਯਨ੍ ਤਤਃ ਪਰੰ ਮਹਾਯਾਜਕਸ੍ਤਾਨ੍ ਅਪ੍ਰੁʼੱਛਤ੍, ");
INSERT INTO sanpun_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","ਅਨੇਨ ਨਾਮ੍ਨਾ ਸਮੁਪਦੇਸ਼਼੍ਟੁੰ ਵਯੰ ਕਿੰ ਦ੍ਰੁʼਢੰ ਨ ਨ੍ਯਸ਼਼ੇਧਾਮ? ਤਥਾਪਿ ਪਸ਼੍ਯਤ ਯੂਯੰ ਸ੍ਵੇਸ਼਼ਾਂ ਤੇਨੋਪਦੇਸ਼ੇਨੇ ਯਿਰੂਸ਼ਾਲਮੰ ਪਰਿਪੂਰ੍ਣੰ ਕ੍ਰੁʼਤ੍ਵਾ ਤਸ੍ਯ ਜਨਸ੍ਯ ਰਕ੍ਤਪਾਤਜਨਿਤਾਪਰਾਧਮ੍ ਅਸ੍ਮਾਨ੍ ਪ੍ਰਤ੍ਯਾਨੇਤੁੰ ਚੇਸ਼਼੍ਟਧ੍ਵੇ| ");
INSERT INTO sanpun_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","ਤਤਃ ਪਿਤਰੋਨ੍ਯਪ੍ਰੇਰਿਤਾਸ਼੍ਚ ਪ੍ਰਤ੍ਯਵਦਨ੍ ਮਾਨੁਸ਼਼ਸ੍ਯਾਜ੍ਞਾਗ੍ਰਹਣਾਦ੍ ਈਸ਼੍ਵਰਸ੍ਯਾਜ੍ਞਾਗ੍ਰਹਣਮ੍ ਅਸ੍ਮਾਕਮੁਚਿਤਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","ਯੰ ਯੀਸ਼ੁੰ ਯੂਯੰ ਕ੍ਰੁਸ਼ੇ ਵੇਧਿਤ੍ਵਾਹਤ ਤਮ੍ ਅਸ੍ਮਾਕੰ ਪੈਤ੍ਰੁʼਕ ਈਸ਼੍ਵਰ ਉੱਥਾਪ੍ਯ ");
INSERT INTO sanpun_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ਇਸ੍ਰਾਯੇਲ੍ਵੰਸ਼ਾਨਾਂ ਮਨਃਪਰਿਵਰ੍ੱਤਨੰ ਪਾਪਕ੍ਸ਼਼ਮਾਞ੍ਚ ਕਰ੍ੱਤੁੰ ਰਾਜਾਨੰ ਪਰਿਤ੍ਰਾਤਾਰਞ੍ਚ ਕ੍ਰੁʼਤ੍ਵਾ ਸ੍ਵਦਕ੍ਸ਼਼ਿਣਪਾਰ੍ਸ਼੍ਵੇ ਤਸ੍ਯਾੰਨਤਿਮ੍ ਅਕਰੋਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ਏਤਸ੍ਮਿਨ੍ ਵਯਮਪਿ ਸਾਕ੍ਸ਼਼ਿਣ ਆਸ੍ਮਹੇ, ਤਤ੍ ਕੇਵਲੰ ਨਹਿ, ਈਸ਼੍ਵਰ ਆਜ੍ਞਾਗ੍ਰਾਹਿਭ੍ਯੋ ਯੰ ਪਵਿਤ੍ਰਮ੍ ਆਤ੍ਮਨੰ ਦੱਤਵਾਨ੍ ਸੋਪਿ ਸਾਕ੍ਸ਼਼੍ਯਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","ਏਤਦ੍ਵਾਕ੍ਯੇ ਸ਼੍ਰੁਤੇ ਤੇਸ਼਼ਾਂ ਹ੍ਰੁʼਦਯਾਨਿ ਵਿੱਧਾਨ੍ਯਭਵਨ੍ ਤਤਸ੍ਤੇ ਤਾਨ੍ ਹਨ੍ਤੁੰ ਮਨ੍ਤ੍ਰਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ਏਤਸ੍ਮਿੰਨੇਵ ਸਮਯੇ ਤਤ੍ਸਭਾਸ੍ਥਾਨਾਂ ਸਰ੍ੱਵਲੋਕਾਨਾਂ ਮਧ੍ਯੇ ਸੁਖ੍ਯਾਤੋ ਗਮਿਲੀਯੇਲ੍ਨਾਮਕ ਏਕੋ ਜਨੋ ਵ੍ਯਵਸ੍ਥਾਪਕਃ ਫਿਰੂਸ਼ਿਲੋਕ ਉੱਥਾਯ ਪ੍ਰੇਰਿਤਾਨ੍ ਕ੍ਸ਼਼ਣਾਰ੍ਥੰ ਸ੍ਥਾਨਾਨ੍ਤਰੰ ਗਨ੍ਤੁਮ੍ ਆਦਿਸ਼੍ਯ ਕਥਿਤਵਾਨ੍, ");
INSERT INTO sanpun_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ਹੇ ਇਸ੍ਰਾਯੇਲ੍ਵੰਸ਼ੀਯਾਃ ਸਰ੍ੱਵੇ ਯੂਯਮ੍ ਏਤਾਨ੍ ਮਾਨੁਸ਼਼ਾਨ੍ ਪ੍ਰਤਿ ਯਤ੍ ਕਰ੍ੱਤੁਮ੍ ਉਦ੍ਯਤਾਸ੍ਤਸ੍ਮਿਨ੍ ਸਾਵਧਾਨਾ ਭਵਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","ਇਤਃ ਪੂਰ੍ੱਵੰ ਥੂਦਾਨਾਮੈਕੋ ਜਨ ਉਪਸ੍ਥਾਯ ਸ੍ਵੰ ਕਮਪਿ ਮਹਾਪੁਰੁਸ਼਼ਮ੍ ਅਵਦਤ੍, ਤਤਃ ਪ੍ਰਾਯੇਣ ਚਤੁਃਸ਼ਤਲੋਕਾਸ੍ਤਸ੍ਯ ਮਤਗ੍ਰਾਹਿਣੋਭਵਨ੍ ਪਸ਼੍ਚਾਤ੍ ਸ ਹਤੋਭਵਤ੍ ਤਸ੍ਯਾਜ੍ਞਾਗ੍ਰਾਹਿਣੋ ਯਾਵਨ੍ਤੋ ਲੋਕਾਸ੍ਤੇ ਸਰ੍ੱਵੇ ਵਿਰ੍ਕੀਰ੍ਣਾਃ ਸਨ੍ਤੋ (ਅ)ਕ੍ਰੁʼਤਕਾਰ੍ੱਯਾ ਅਭਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","ਤਸ੍ਮਾੱਜਨਾਤ੍ ਪਰੰ ਨਾਮਲੇਖਨਸਮਯੇ ਗਾਲੀਲੀਯਯਿਹੂਦਾਨਾਮੈਕੋ ਜਨ ਉਪਸ੍ਥਾਯ ਬਹੂੱਲੋਕਾਨ੍ ਸ੍ਵਮਤੰ ਗ੍ਰਾਹੀਤਵਾਨ੍ ਤਤਃ ਸੋਪਿ ਵ੍ਯਨਸ਼੍ਯਤ੍ ਤਸ੍ਯਾਜ੍ਞਾਗ੍ਰਾਹਿਣੋ ਯਾਵਨ੍ਤੋ ਲੋਕਾ ਆਸਨ੍ ਤੇ ਸਰ੍ੱਵੇ ਵਿਕੀਰ੍ਣਾ ਅਭਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","ਅਧੁਨਾ ਵਦਾਮਿ, ਯੂਯਮ੍ ਏਤਾਨ੍ ਮਨੁਸ਼਼੍ਯਾਨ੍ ਪ੍ਰਤਿ ਕਿਮਪਿ ਨ ਕ੍ਰੁʼਤ੍ਵਾ ਕ੍ਸ਼਼ਾਨ੍ਤਾ ਭਵਤ, ਯਤ ਏਸ਼਼ ਸਙ੍ਕਲ੍ਪ ਏਤਤ੍ ਕਰ੍ੰਮ ਚ ਯਦਿ ਮਨੁਸ਼਼੍ਯਾਦਭਵਤ੍ ਤਰ੍ਹਿ ਵਿਫਲੰ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ਯਦੀਸ਼੍ਵਰਾਦਭਵਤ੍ ਤਰ੍ਹਿ ਯੂਯੰ ਤਸ੍ਯਾਨ੍ਯਥਾ ਕਰ੍ੱਤੁੰ ਨ ਸ਼ਕ੍ਸ਼਼੍ਯਥ, ਵਰਮ੍ ਈਸ਼੍ਵਰਰੋਧਕਾ ਭਵਿਸ਼਼੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ਤਦਾ ਤਸ੍ਯ ਮਨ੍ਤ੍ਰਣਾਂ ਸ੍ਵੀਕ੍ਰੁʼਤ੍ਯ ਤੇ ਪ੍ਰੇਰਿਤਾਨ੍ ਆਹੂਯ ਪ੍ਰਹ੍ਰੁʼਤ੍ਯ ਯੀਸ਼ੋ ਰ੍ਨਾਮ੍ਨਾ ਕਾਮਪਿ ਕਥਾਂ ਕਥਯਿਤੁੰ ਨਿਸ਼਼ਿਧ੍ਯ ਵ੍ਯਸਰ੍ਜਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","ਕਿਨ੍ਤੁ ਤਸ੍ਯ ਨਾਮਾਰ੍ਥੰ ਵਯੰ ਲੱਜਾਭੋਗਸ੍ਯ ਯੋਗ੍ਯਤ੍ਵੇਨ ਗਣਿਤਾ ਇਤ੍ਯਤ੍ਰ ਤੇ ਸਾਨਨ੍ਦਾਃ ਸਨ੍ਤਃ ਸਭਾਸ੍ਥਾਨਾਂ ਸਾਕ੍ਸ਼਼ਾਦ੍ ਅਗੱਛਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ਤਤਃ ਪਰੰ ਪ੍ਰਤਿਦਿਨੰ ਮਨ੍ਦਿਰੇ ਗ੍ਰੁʼਹੇ ਗ੍ਰੁʼਹੇ ਚਾਵਿਸ਼੍ਰਾਮਮ੍ ਉਪਦਿਸ਼੍ਯ ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਸੁਸੰਵਾਦੰ ਪ੍ਰਚਾਰਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","ਤਸ੍ਮਿਨ੍ ਸਮਯੇ ਸ਼ਿਸ਼਼੍ਯਾਣਾਂ ਬਾਹੁਲ੍ਯਾਤ੍ ਪ੍ਰਾਤ੍ਯਹਿਕਦਾਨਸ੍ਯ ਵਿਸ਼੍ਰਾਣਨੈ ਰ੍ਭਿੰਨਦੇਸ਼ੀਯਾਨਾਂ ਵਿਧਵਾਸ੍ਤ੍ਰੀਗਣ ਉਪੇਕ੍ਸ਼਼ਿਤੇ ਸਤਿ ਇਬ੍ਰੀਯਲੋਕੈਃ ਸਹਾਨ੍ਯਦੇਸ਼ੀਯਾਨਾਂ ਵਿਵਾਦ ਉਪਾਤਿਸ਼਼੍ਠਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","ਤਦਾ ਦ੍ਵਾਦਸ਼ਪ੍ਰੇਰਿਤਾਃ ਸਰ੍ੱਵਾਨ੍ ਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਸੰਗ੍ਰੁʼਹ੍ਯਾਕਥਯਨ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਕਥਾਪ੍ਰਚਾਰੰ ਪਰਿਤ੍ਯਜ੍ਯ ਭੋਜਨਗਵੇਸ਼਼ਣਮ੍ ਅਸ੍ਮਾਕਮ੍ ਉਚਿਤੰ ਨਹਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ਅਤੋ ਹੇ ਭ੍ਰਾਤ੍ਰੁʼਗਣ ਵਯਮ੍ ਏਤਤ੍ਕਰ੍ੰਮਣੋ ਭਾਰੰ ਯੇਭ੍ਯੋ ਦਾਤੁੰ ਸ਼ਕ੍ਨੁਮ ਏਤਾਦ੍ਰੁʼਸ਼ਾਨ੍ ਸੁਖ੍ਯਾਤ੍ਯਾਪੰਨਾਨ੍ ਪਵਿਤ੍ਰੇਣਾਤ੍ਮਨਾ ਜ੍ਞਾਨੇਨ ਚ ਪੂਰ੍ਣਾਨ੍ ਸੱਪ੍ਰਜਨਾਨ੍ ਯੂਯੰ ਸ੍ਵੇਸ਼਼ਾਂ ਮਧ੍ਯੇ ਮਨੋਨੀਤਾਨ੍ ਕੁਰੁਤ, ");
INSERT INTO sanpun_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ਕਿਨ੍ਤੁ ਵਯੰ ਪ੍ਰਾਰ੍ਥਨਾਯਾਂ ਕਥਾਪ੍ਰਚਾਰਕਰ੍ੰਮਣਿ ਚ ਨਿਤ੍ਯਪ੍ਰਵ੍ਰੁʼੱਤਾਃ ਸ੍ਥਾਸ੍ਯਾਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ਏਤਸ੍ਯਾਂ ਕਥਾਯਾਂ ਸਰ੍ੱਵੇ ਲੋਕਾਃ ਸਨ੍ਤੁਸ਼਼੍ਟਾਃ ਸਨ੍ਤਃ ਸ੍ਵੇਸ਼਼ਾਂ ਮਧ੍ਯਾਤ੍ ਸ੍ਤਿਫਾਨਃ ਫਿਲਿਪਃ ਪ੍ਰਖਰੋ ਨਿਕਾਨੋਰ੍ ਤੀਮਨ੍ ਪਰ੍ੰਮਿਣਾ ਯਿਹੂਦਿਮਤਗ੍ਰਾਹੀ-ਆਨ੍ਤਿਯਖਿਯਾਨਗਰੀਯੋ ਨਿਕਲਾ ਏਤਾਨ੍ ਪਰਮਭਕ੍ਤਾਨ੍ ਪਵਿਤ੍ਰੇਣਾਤ੍ਮਨਾ ਪਰਿਪੂਰ੍ਣਾਨ੍ ਸਪ੍ਤ ਜਨਾਨ੍ ");
INSERT INTO sanpun_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ਪ੍ਰੇਰਿਤਾਨਾਂ ਸਮਕ੍ਸ਼਼ਮ੍ ਆਨਯਨ੍, ਤਤਸ੍ਤੇ ਪ੍ਰਾਰ੍ਥਨਾਂ ਕ੍ਰੁʼਤ੍ਵਾ ਤੇਸ਼਼ਾਂ ਸ਼ਿਰਃਸੁ ਹਸ੍ਤਾਨ੍ ਆਰ੍ਪਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","ਅਪਰਞ੍ਚ ਈਸ਼੍ਵਰਸ੍ਯ ਕਥਾ ਦੇਸ਼ੰ ਵ੍ਯਾਪ੍ਨੋਤ੍ ਵਿਸ਼ੇਸ਼਼ਤੋ ਯਿਰੂਸ਼ਾਲਮਿ ਨਗਰੇ ਸ਼ਿਸ਼਼੍ਯਾਣਾਂ ਸੰਖ੍ਯਾ ਪ੍ਰਭੂਤਰੂਪੇਣਾਵਰ੍ੱਧਤ ਯਾਜਕਾਨਾਂ ਮਧ੍ਯੇਪਿ ਬਹਵਃ ਖ੍ਰੀਸ਼਼੍ਟਮਤਗ੍ਰਾਹਿਣੋ(ਅ)ਭਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","ਸ੍ਤਿਫਾਨੋे ਵਿਸ਼੍ਵਾਸੇਨ ਪਰਾਕ੍ਰਮੇਣ ਚ ਪਰਿਪੂਰ੍ਣਃ ਸਨ੍ ਲੋਕਾਨਾਂ ਮਧ੍ਯੇ ਬਹੁਵਿਧਮ੍ ਅਦ੍ਭੁਤਮ੍ ਆਸ਼੍ਚਰ੍ੱਯੰ ਕਰ੍ੰਮਾਕਰੋਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","ਤੇਨ ਲਿਬਰ੍ੱਤਿਨੀਯਨਾਮ੍ਨਾ ਵਿਖ੍ਯਾਤਸਙ੍ਘਸ੍ਯ ਕਤਿਪਯਜਨਾਃ ਕੁਰੀਣੀਯਸਿਕਨ੍ਦਰੀਯ-ਕਿਲਿਕੀਯਾਸ਼ੀਯਾਦੇਸ਼ੀਯਾਃ ਕਿਯਨ੍ਤੋ ਜਨਾਸ਼੍ਚੋੱਥਾਯ ਸ੍ਤਿਫਾਨੇਨ ਸਾਰ੍ੱਧੰ ਵ੍ਯਵਦਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ਕਿਨ੍ਤੁ ਸ੍ਤਿਫਾਨੋ ਜ੍ਞਾਨੇਨ ਪਵਿਤ੍ਰੇਣਾਤ੍ਮਨਾ ਚ ਈਦ੍ਰੁʼਸ਼ੀਂ ਕਥਾਂ ਕਥਿਤਵਾਨ੍ ਯਸ੍ਯਾਸ੍ਤੇ ਆਪੱਤਿੰ ਕਰ੍ੱਤੁੰ ਨਾਸ਼ਕ੍ਨੁਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","ਪਸ਼੍ਚਾਤ੍ ਤੈ ਰ੍ਲੋਭਿਤਾਃ ਕਤਿਪਯਜਨਾਃ ਕਥਾਮੇਨਾਮ੍ ਅਕਥਯਨ੍, ਵਯੰ ਤਸ੍ਯ ਮੁਖਤੋ ਮੂਸਾ ਈਸ਼੍ਵਰਸ੍ਯ ਚ ਨਿਨ੍ਦਾਵਾਕ੍ਯਮ੍ ਅਸ਼੍ਰੌਸ਼਼੍ਮ| ");
INSERT INTO sanpun_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ਤੇ ਲੋਕਾਨਾਂ ਲੋਕਪ੍ਰਾਚੀਨਾਨਾਮ੍ ਅਧ੍ਯਾਪਕਾਨਾਞ੍ਚ ਪ੍ਰਵ੍ਰੁʼੱਤਿੰ ਜਨਯਿਤ੍ਵਾ ਸ੍ਤਿਫਾਨਸ੍ਯ ਸੰਨਿਧਿਮ੍ ਆਗਤ੍ਯ ਤੰ ਧ੍ਰੁʼਤ੍ਵਾ ਮਹਾਸਭਾਮਧ੍ਯਮ੍ ਆਨਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ਤਦਨਨ੍ਤਰੰ ਕਤਿਪਯਜਨੇਸ਼਼ੁ ਮਿਥ੍ਯਾਸਾਕ੍ਸ਼਼ਿਸ਼਼ੁ ਸਮਾਨੀਤੇਸ਼਼ੁ ਤੇ(ਅ)ਕਥਯਨ੍ ਏਸ਼਼ ਜਨ ਏਤਤ੍ਪੁਣ੍ਯਸ੍ਥਾਨਵ੍ਯਵਸ੍ਥਯੋ ਰ੍ਨਿਨ੍ਦਾਤਃ ਕਦਾਪਿ ਨ ਨਿਵਰ੍ੱਤਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ਫਲਤੋ ਨਾਸਰਤੀਯਯੀਸ਼ੁਃ ਸ੍ਥਾਨਮੇਤਦ੍ ਉੱਛਿੰਨੰ ਕਰਿਸ਼਼੍ਯਤਿ ਮੂਸਾਸਮਰ੍ਪਿਤਮ੍ ਅਸ੍ਮਾਕੰ ਵ੍ਯਵਹਰਣਮ੍ ਅਨ੍ਯਰੂਪੰ ਕਰਿਸ਼਼੍ਯਤਿ ਤਸ੍ਯੈਤਾਦ੍ਰੁʼਸ਼ੀਂ ਕਥਾਂ ਵਯਮ੍ ਅਸ਼੍ਰੁʼਣੁਮ| ");
INSERT INTO sanpun_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","ਤਦਾ ਮਹਾਸਭਾਸ੍ਥਾਃ ਸਰ੍ੱਵੇ ਤੰ ਪ੍ਰਤਿ ਸ੍ਥਿਰਾਂ ਦ੍ਰੁʼਸ਼਼੍ਟਿੰ ਕ੍ਰੁʼਤ੍ਵਾ ਸ੍ਵਰ੍ਗਦੂਤਮੁਖਸਦ੍ਰੁʼਸ਼ੰ ਤਸ੍ਯ ਮੁਖਮ੍ ਅਪਸ਼੍ਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ਤਤਃ ਪਰੰ ਮਹਾਯਾਜਕਃ ਪ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍, ਏਸ਼਼ਾ ਕਥਾਂ ਕਿੰ ਸਤ੍ਯਾ? ");
INSERT INTO sanpun_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","ਤਤਃ ਸ ਪ੍ਰਤ੍ਯਵਦਤ੍, ਹੇ ਪਿਤਰੋ ਹੇ ਭ੍ਰਾਤਰਃ ਸਰ੍ੱਵੇ ਲਾਕਾ ਮਨਾਂਸਿ ਨਿਧੱਧ੍ਵੰ| ਅਸ੍ਮਾਕੰ ਪੂਰ੍ੱਵਪੁਰੁਸ਼਼ ਇਬ੍ਰਾਹੀਮ੍ ਹਾਰਣ੍ਨਗਰੇ ਵਾਸਕਰਣਾਤ੍ ਪੂਰ੍ੱਵੰ ਯਦਾ ਅਰਾਮ੍-ਨਹਰਯਿਮਦੇਸ਼ੇ ਆਸੀਤ੍ ਤਦਾ ਤੇਜੋਮਯ ਈਸ਼੍ਵਰੋ ਦਰ੍ਸ਼ਨੰ ਦਤ੍ਵਾ ");
INSERT INTO sanpun_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ਤਮਵਦਤ੍ ਤ੍ਵੰ ਸ੍ਵਦੇਸ਼ਜ੍ਞਾਤਿਮਿਤ੍ਰਾਣਿ ਪਰਿਤ੍ਯਜ੍ਯ ਯੰ ਦੇਸ਼ਮਹੰ ਦਰ੍ਸ਼ਯਿਸ਼਼੍ਯਾਮਿ ਤੰ ਦੇਸ਼ੰ ਵ੍ਰਜ| ");
INSERT INTO sanpun_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","ਅਤਃ ਸ ਕਸ੍ਦੀਯਦੇਸ਼ੰ ਵਿਹਾਯ ਹਾਰਣ੍ਨਗਰੇ ਨ੍ਯਵਸਤ੍, ਤਦਨਨ੍ਤਰੰ ਤਸ੍ਯ ਪਿਤਰਿ ਮ੍ਰੁʼਤੇ ਯਤ੍ਰ ਦੇਸ਼ੇ ਯੂਯੰ ਨਿਵਸਥ ਸ ਏਨੰ ਦੇਸ਼ਮਾਗੱਛਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","ਕਿਨ੍ਤ੍ਵੀਸ਼੍ਵਰਸ੍ਤਸ੍ਮੈ ਕਮਪ੍ਯਧਿਕਾਰਮ੍ ਅਰ੍ਥਾਦ੍ ਏਕਪਦਪਰਿਮਿਤਾਂ ਭੂਮਿਮਪਿ ਨਾਦਦਾਤ੍; ਤਦਾ ਤਸ੍ਯ ਕੋਪਿ ਸਨ੍ਤਾਨੋ ਨਾਸੀਤ੍ ਤਥਾਪਿ ਸਨ੍ਤਾਨੈਃ ਸਾਰ੍ੱਧਮ੍ ਏਤਸ੍ਯ ਦੇਸ਼ਸ੍ਯਾਧਿਕਾਰੀ ਤ੍ਵੰ ਭਵਿਸ਼਼੍ਯਸੀਤਿ ਤਮ੍ਪ੍ਰਤ੍ਯਙ੍ਗੀਕ੍ਰੁʼਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ਈਸ਼੍ਵਰ ਇੱਥਮ੍ ਅਪਰਮਪਿ ਕਥਿਤਵਾਨ੍ ਤਵ ਸਨ੍ਤਾਨਾਃ ਪਰਦੇਸ਼ੇ ਨਿਵਤ੍ਸ੍ਯਨ੍ਤਿ ਤਤਸ੍ਤੱਦੇਸ਼ੀਯਲੋਕਾਸ਼੍ਚਤੁਃਸ਼ਤਵਤ੍ਸਰਾਨ੍ ਯਾਵਤ੍ ਤਾਨ੍ ਦਾਸਤ੍ਵੇ ਸ੍ਥਾਪਯਿਤ੍ਵਾ ਤਾਨ੍ ਪ੍ਰਤਿ ਕੁਵ੍ਯਵਹਾਰੰ ਕਰਿਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","ਅਪਰਮ੍ ਈਸ਼੍ਵਰ ਏਨਾਂ ਕਥਾਮਪਿ ਕਥਿਤਵਾਨ੍, ਯੇ ਲੋਕਾਸ੍ਤਾਨ੍ ਦਾਸਤ੍ਵੇ ਸ੍ਥਾਪਯਿਸ਼਼੍ਯਨ੍ਤਿ ਤਾੱਲੋਕਾਨ੍ ਅਹੰ ਦਣ੍ਡਯਿਸ਼਼੍ਯਾਮਿ, ਤਤਃ ਪਰੰ ਤੇ ਬਹਿਰ੍ਗਤਾਃ ਸਨ੍ਤੋ ਮਾਮ੍ ਅਤ੍ਰ ਸ੍ਥਾਨੇ ਸੇਵਿਸ਼਼੍ਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","ਪਸ਼੍ਚਾਤ੍ ਸ ਤਸ੍ਮੈ ਤ੍ਵਕ੍ਛੇਦਸ੍ਯ ਨਿਯਮੰ ਦੱਤਵਾਨ੍, ਅਤ ਇਸ੍ਹਾਕਨਾਮ੍ਨਿ ਇਬ੍ਰਾਹੀਮ ਏਕਪੁਤ੍ਰੇ ਜਾਤੇ, ਅਸ਼਼੍ਟਮਦਿਨੇ ਤਸ੍ਯ ਤ੍ਵਕ੍ਛੇਦਮ੍ ਅਕਰੋਤ੍| ਤਸ੍ਯ ਇਸ੍ਹਾਕਃ ਪੁਤ੍ਰੋ ਯਾਕੂਬ੍, ਤਤਸ੍ਤਸ੍ਯ ਯਾਕੂਬੋ(ਅ)ਸ੍ਮਾਕੰ ਦ੍ਵਾਦਸ਼ ਪੂਰ੍ੱਵਪੁਰੁਸ਼਼ਾ ਅਜਾਯਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","ਤੇ ਪੂਰ੍ੱਵਪੁਰੁਸ਼਼ਾ ਈਰ੍ਸ਼਼੍ਯਯਾ ਪਰਿਪੂਰ੍ਣਾ ਮਿਸਰਦੇਸ਼ੰ ਪ੍ਰੇਸ਼਼ਯਿਤੁੰ ਯੂਸ਼਼ਫੰ ਵ੍ਯਕ੍ਰੀਣਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ਕਿਨ੍ਤ੍ਵੀਸ਼੍ਵਰਸ੍ਤਸ੍ਯ ਸਹਾਯੋ ਭੂਤ੍ਵਾ ਸਰ੍ੱਵਸ੍ਯਾ ਦੁਰ੍ਗਤੇ ਰਕ੍ਸ਼਼ਿਤ੍ਵਾ ਤਸ੍ਮੈ ਬੁੱਧਿੰ ਦੱਤ੍ਵਾ ਮਿਸਰਦੇਸ਼ਸ੍ਯ ਰਾਜ੍ਞਃ ਫਿਰੌਣਃ ਪ੍ਰਿਯਪਾਤ੍ਰੰ ਕ੍ਰੁʼਤਵਾਨ੍ ਤਤੋ ਰਾਜਾ ਮਿਸਰਦੇਸ਼ਸ੍ਯ ਸ੍ਵੀਯਸਰ੍ੱਵਪਰਿਵਾਰਸ੍ਯ ਚ ਸ਼ਾਸਨਪਦੰ ਤਸ੍ਮੈ ਦੱਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","ਤਸ੍ਮਿਨ੍ ਸਮਯੇ ਮਿਸਰ-ਕਿਨਾਨਦੇਸ਼ਯੋ ਰ੍ਦੁਰ੍ਭਿਕ੍ਸ਼਼ਹੇਤੋਰਤਿਕ੍ਲਿਸ਼਼੍ਟਤ੍ਵਾਤ੍ ਨਃ ਪੂਰ੍ੱਵਪੁਰੁਸ਼਼ਾ ਭਕ੍ਸ਼਼੍ਯਦ੍ਰਵ੍ਯੰ ਨਾਲਭਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","ਕਿਨ੍ਤੁ ਮਿਸਰਦੇਸ਼ੇ ਸ਼ਸ੍ਯਾਨਿ ਸਨ੍ਤਿ, ਯਾਕੂਬ੍ ਇਮਾਂ ਵਾਰ੍ੱਤਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਪ੍ਰਥਮਮ੍ ਅਸ੍ਮਾਕੰ ਪੂਰ੍ੱਵਪੁਰੁਸ਼਼ਾਨ੍ ਮਿਸਰੰ ਪ੍ਰੇਸ਼਼ਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ਤਤੋ ਦ੍ਵਿਤੀਯਵਾਰਗਮਨੇ ਯੂਸ਼਼ਫ੍ ਸ੍ਵਭ੍ਰਾਤ੍ਰੁʼਭਿਃ ਪਰਿਚਿਤੋ(ਅ)ਭਵਤ੍; ਯੂਸ਼਼ਫੋ ਭ੍ਰਾਤਰਃ ਫਿਰੌਣ੍ ਰਾਜੇਨ ਪਰਿਚਿਤਾ ਅਭਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","ਅਨਨ੍ਤਰੰ ਯੂਸ਼਼ਫ੍ ਭ੍ਰਾਤ੍ਰੁʼਗਣੰ ਪ੍ਰੇਸ਼਼੍ਯ ਨਿਜਪਿਤਰੰ ਯਾਕੂਬੰ ਨਿਜਾਨ੍ ਪਞ੍ਚਾਧਿਕਸਪ੍ਤਤਿਸੰਖ੍ਯਕਾਨ੍ ਜ੍ਞਾਤਿਜਨਾਂਸ਼੍ਚ ਸਮਾਹੂਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","ਤਸ੍ਮਾਦ੍ ਯਾਕੂਬ੍ ਮਿਸਰਦੇਸ਼ੰ ਗਤ੍ਵਾ ਸ੍ਵਯਮ੍ ਅਸ੍ਮਾਕੰ ਪੂਰ੍ੱਵਪੁਰੁਸ਼਼ਾਸ਼੍ਚ ਤਸ੍ਮਿਨ੍ ਸ੍ਥਾਨੇ(ਅ)ਮ੍ਰਿਯਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ਤਤਸ੍ਤੇ ਸ਼ਿਖਿਮੰ ਨੀਤਾ ਯਤ੍ ਸ਼੍ਮਸ਼ਾਨਮ੍ ਇਬ੍ਰਾਹੀਮ੍ ਮੁਦ੍ਰਾਦਤ੍ਵਾ ਸ਼ਿਖਿਮਃ ਪਿਤੁ ਰ੍ਹਮੋਰਃ ਪੁਤ੍ਰੇਭ੍ਯਃ ਕ੍ਰੀਤਵਾਨ੍ ਤਤ੍ਸ਼੍ਮਸ਼ਾਨੇ ਸ੍ਥਾਪਯਾਞ੍ਚਕ੍ਰਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","ਤਤਃ ਪਰਮ੍ ਈਸ਼੍ਵਰ ਇਬ੍ਰਾਹੀਮਃ ਸੰਨਿਧੌ ਸ਼ਪਥੰ ਕ੍ਰੁʼਤ੍ਵਾ ਯਾਂ ਪ੍ਰਤਿਜ੍ਞਾਂ ਕ੍ਰੁʼਤਵਾਨ੍ ਤਸ੍ਯਾਃ ਪ੍ਰਤਿਜ੍ਞਾਯਾਃ ਫਲਨਸਮਯੇ ਨਿਕਟੇ ਸਤਿ ਇਸ੍ਰਾਯੇੱਲੋਕਾ ਸਿਮਰਦੇਸ਼ੇ ਵਰ੍ੱਧਮਾਨਾ ਬਹੁਸੰਖ੍ਯਾ ਅਭਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ਸ਼ੇਸ਼਼ੇ ਯੂਸ਼਼ਫੰ ਯੋ ਨ ਪਰਿਚਿਨੋਤਿ ਤਾਦ੍ਰੁʼਸ਼ ਏਕੋ ਨਰਪਤਿਰੁਪਸ੍ਥਾਯ ");
INSERT INTO sanpun_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ਅਸ੍ਮਾਕੰ ਜ੍ਞਾਤਿਭਿਃ ਸਾਰ੍ੱਧੰ ਧੂਰ੍ੱਤਤਾਂ ਵਿਧਾਯ ਪੂਰ੍ੱਵਪੁਰੁਸ਼਼ਾਨ੍ ਪ੍ਰਤਿ ਕੁਵ੍ਯਵਹਰਣਪੂਰ੍ੱਵਕੰ ਤੇਸ਼਼ਾਂ ਵੰਸ਼ਨਾਸ਼ਨਾਯ ਤੇਸ਼਼ਾਂ ਨਵਜਾਤਾਨ੍ ਸ਼ਿਸ਼ੂਨ੍ ਬਹਿ ਰ੍ਨਿਰਕ੍ਸ਼਼ੇਪਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","ਏਤਸ੍ਮਿਨ੍ ਸਮਯੇ ਮੂਸਾ ਜਜ੍ਞੇ, ਸ ਤੁ ਪਰਮਸੁਨ੍ਦਰੋ(ਅ)ਭਵਤ੍ ਤਥਾ ਪਿਤ੍ਰੁʼਗ੍ਰੁʼਹੇ ਮਾਸਤ੍ਰਯਪਰ੍ੱਯਨ੍ਤੰ ਪਾਲਿਤੋ(ਅ)ਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ਕਿਨ੍ਤੁ ਤਸ੍ਮਿਨ੍ ਬਹਿਰ੍ਨਿਕ੍ਸ਼਼ਿਪ੍ਤੇ ਸਤਿ ਫਿਰੌਣਰਾਜਸ੍ਯ ਕਨ੍ਯਾ ਤਮ੍ ਉੱਤੋਲ੍ਯ ਨੀਤ੍ਵਾ ਦੱਤਕਪੁਤ੍ਰੰ ਕ੍ਰੁʼਤ੍ਵਾ ਪਾਲਿਤਵਤੀ| ");
INSERT INTO sanpun_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","ਤਸ੍ਮਾਤ੍ ਸ ਮੂਸਾ ਮਿਸਰਦੇਸ਼ੀਯਾਯਾਃ ਸਰ੍ੱਵਵਿਦ੍ਯਾਯਾਃ ਪਾਰਦ੍ਰੁʼਸ਼਼੍ਵਾ ਸਨ੍ ਵਾਕ੍ਯੇ ਕ੍ਰਿਯਾਯਾਞ੍ਚ ਸ਼ਕ੍ਤਿਮਾਨ੍ ਅਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","ਸ ਸਮ੍ਪੂਰ੍ਣਚਤ੍ਵਾਰਿੰਸ਼ਦ੍ਵਤ੍ਸਰਵਯਸ੍ਕੋ ਭੂਤ੍ਵਾ ਇਸ੍ਰਾਯੇਲੀਯਵੰਸ਼ਨਿਜਭ੍ਰਾਤ੍ਰੁʼਨ੍ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਕਰ੍ਤੁੰ ਮਤਿੰ ਚਕ੍ਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","ਤੇਸ਼਼ਾਂ ਜਨਮੇਕੰ ਹਿੰਸਿਤੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਤਸ੍ਯ ਸਪਕ੍ਸ਼਼ਃ ਸਨ੍ ਹਿੰਸਿਤਜਨਮ੍ ਉਪਕ੍ਰੁʼਤ੍ਯ ਮਿਸਰੀਯਜਨੰ ਜਘਾਨ| ");
INSERT INTO sanpun_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ਤਸ੍ਯ ਹਸ੍ਤੇਨੇਸ਼੍ਵਰਸ੍ਤਾਨ੍ ਉੱਧਰਿਸ਼਼੍ਯਤਿ ਤਸ੍ਯ ਭ੍ਰਾਤ੍ਰੁʼਗਣ ਇਤਿ ਜ੍ਞਾਸ੍ਯਤਿ ਸ ਇਤ੍ਯਨੁਮਾਨੰ ਚਕਾਰ, ਕਿਨ੍ਤੁ ਤੇ ਨ ਬੁਬੁਧਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","ਤਤ੍ਪਰੇ (ਅ)ਹਨਿ ਤੇਸ਼਼ਾਮ੍ ਉਭਯੋ ਰ੍ਜਨਯੋ ਰ੍ਵਾੱਕਲਹ ਉਪਸ੍ਥਿਤੇ ਸਤਿ ਮੂਸਾਃ ਸਮੀਪੰ ਗਤ੍ਵਾ ਤਯੋ ਰ੍ਮੇਲਨੰ ਕਰ੍ੱਤੁੰ ਮਤਿੰ ਕ੍ਰੁʼਤ੍ਵਾ ਕਥਯਾਮਾਸ, ਹੇ ਮਹਾਸ਼ਯੌ ਯੁਵਾਂ ਭ੍ਰਾਤਰੌ ਪਰਸ੍ਪਰਮ੍ ਅਨ੍ਯਾਯੰ ਕੁਤਃ ਕੁਰੁਥਃ? ");
INSERT INTO sanpun_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","ਤਤਃ ਸਮੀਪਵਾਸਿਨੰ ਪ੍ਰਤਿ ਯੋ ਜਨੋ(ਅ)ਨ੍ਯਾਯੰ ਚਕਾਰ ਸ ਤੰ ਦੂਰੀਕ੍ਰੁʼਤ੍ਯ ਕਥਯਾਮਾਸ, ਅਸ੍ਮਾਕਮੁਪਰਿ ਸ਼ਾਸ੍ਤ੍ਰੁʼਤ੍ਵਵਿਚਾਰਯਿਤ੍ਰੁʼਤ੍ਵਪਦਯੋਃ ਕਸ੍ਤ੍ਵਾਂ ਨਿਯੁਕ੍ਤਵਾਨ੍? ");
INSERT INTO sanpun_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","ਹ੍ਯੋ ਯਥਾ ਮਿਸਰੀਯੰ ਹਤਵਾਨ੍ ਤਥਾ ਕਿੰ ਮਾਮਪਿ ਹਨਿਸ਼਼੍ਯਸਿ? ");
INSERT INTO sanpun_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ਤਦਾ ਮੂਸਾ ਏਤਾਦ੍ਰੁʼਸ਼ੀਂ ਕਥਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਪਲਾਯਨੰ ਚਕ੍ਰੇ, ਤਤੋ ਮਿਦਿਯਨਦੇਸ਼ੰ ਗਤ੍ਵਾ ਪ੍ਰਵਾਸੀ ਸਨ੍ ਤਸ੍ਥੌ, ਤਤਸ੍ਤਤ੍ਰ ਦ੍ਵੌ ਪੁਤ੍ਰੌ ਜਜ੍ਞਾਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","ਅਨਨ੍ਤਰੰ ਚਤ੍ਵਾਰਿੰਸ਼ਦ੍ਵਤ੍ਸਰੇਸ਼਼ੁ ਗਤੇਸ਼਼ੁ ਸੀਨਯਪਰ੍ੱਵਤਸ੍ਯ ਪ੍ਰਾਨ੍ਤਰੇ ਪ੍ਰਜ੍ਵਲਿਤਸ੍ਤਮ੍ਬਸ੍ਯ ਵਹ੍ਨਿਸ਼ਿਖਾਯਾਂ ਪਰਮੇਸ਼੍ਵਰਦੂਤਸ੍ਤਸ੍ਮੈ ਦਰ੍ਸ਼ਨੰ ਦਦੌ| ");
INSERT INTO sanpun_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","ਮੂਸਾਸ੍ਤਸ੍ਮਿਨ੍ ਦਰ੍ਸ਼ਨੇ ਵਿਸ੍ਮਯੰ ਮਤ੍ਵਾ ਵਿਸ਼ੇਸ਼਼ੰ ਜ੍ਞਾਤੁੰ ਨਿਕਟੰ ਗੱਛਤਿ, ");
INSERT INTO sanpun_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","ਏਤਸ੍ਮਿਨ੍ ਸਮਯੇ, ਅਹੰ ਤਵ ਪੂਰ੍ੱਵਪੁਰੁਸ਼਼ਾਣਾਮ੍ ਈਸ਼੍ਵਰੋ(ਅ)ਰ੍ਥਾਦ੍ ਇਬ੍ਰਾਹੀਮ ਈਸ਼੍ਵਰ ਇਸ੍ਹਾਕ ਈਸ਼੍ਵਰੋ ਯਾਕੂਬ ਈਸ਼੍ਵਰਸ਼੍ਚ, ਮੂਸਾਮੁੱਦਿਸ਼੍ਯ ਪਰਮੇਸ਼੍ਵਰਸ੍ਯੈਤਾਦ੍ਰੁʼਸ਼ੀ ਵਿਹਾਯਸੀਯਾ ਵਾਣੀ ਬਭੂਵ, ਤਤਃ ਸ ਕਮ੍ਪਾਨ੍ਵਿਤਃ ਸਨ੍ ਪੁਨ ਰ੍ਨਿਰੀਕ੍ਸ਼਼ਿਤੁੰ ਪ੍ਰਗਲ੍ਭੋ ਨ ਬਭੂਵ| ");
INSERT INTO sanpun_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","ਪਰਮੇਸ਼੍ਵਰਸ੍ਤੰ ਜਗਾਦ, ਤਵ ਪਾਦਯੋਃ ਪਾਦੁਕੇ ਮੋਚਯ ਯਤ੍ਰ ਤਿਸ਼਼੍ਠਸਿ ਸਾ ਪਵਿਤ੍ਰਭੂਮਿਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ਅਹੰ ਮਿਸਰਦੇਸ਼ਸ੍ਥਾਨਾਂ ਨਿਜਲੋਕਾਨਾਂ ਦੁਰ੍ੱਦਸ਼ਾਂ ਨਿਤਾਨ੍ਤਮ੍ ਅਪਸ਼੍ਯੰ, ਤੇਸ਼਼ਾਂ ਕਾਤਰ੍ੱਯੋਕ੍ਤਿਞ੍ਚ ਸ਼੍ਰੁਤਵਾਨ੍ ਤਸ੍ਮਾਤ੍ ਤਾਨ੍ ਉੱਧਰ੍ੱਤੁਮ੍ ਅਵਰੁਹ੍ਯਾਗਮਮ੍; ਇਦਾਨੀਮ੍ ਆਗੱਛ ਮਿਸਰਦੇਸ਼ੰ ਤ੍ਵਾਂ ਪ੍ਰੇਸ਼਼ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","ਕਸ੍ਤ੍ਵਾਂ ਸ਼ਾਸ੍ਤ੍ਰੁʼਤ੍ਵਵਿਚਾਰਯਿਤ੍ਰੁʼਤ੍ਵਪਦਯੋ ਰ੍ਨਿਯੁਕ੍ਤਵਾਨ੍, ਇਤਿ ਵਾਕ੍ਯਮੁਕ੍ਤ੍ਵਾ ਤੈ ਰ੍ਯੋ ਮੂਸਾ ਅਵਜ੍ਞਾਤਸ੍ਤਮੇਵ ਈਸ਼੍ਵਰਃ ਸ੍ਤਮ੍ਬਮਧ੍ਯੇ ਦਰ੍ਸ਼ਨਦਾਤ੍ਰਾ ਤੇਨ ਦੂਤੇਨ ਸ਼ਾਸ੍ਤਾਰੰ ਮੁਕ੍ਤਿਦਾਤਾਰਞ੍ਚ ਕ੍ਰੁʼਤ੍ਵਾ ਪ੍ਰੇਸ਼਼ਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","ਸ ਚ ਮਿਸਰਦੇਸ਼ੇ ਸੂਫ੍ਨਾਮ੍ਨਿ ਸਮੁਦ੍ਰੇ ਚ ਪਸ਼੍ਚਾਤ੍ ਚਤ੍ਵਾਰਿੰਸ਼ਦ੍ਵਤ੍ਸਰਾਨ੍ ਯਾਵਤ੍ ਮਹਾਪ੍ਰਾਨ੍ਤਰੇ ਨਾਨਾਪ੍ਰਕਾਰਾਣ੍ਯਦ੍ਭੁਤਾਨਿ ਕਰ੍ੰਮਾਣਿ ਲਕ੍ਸ਼਼ਣਾਨਿ ਚ ਦਰ੍ਸ਼ਯਿਤ੍ਵਾ ਤਾਨ੍ ਬਹਿਃ ਕ੍ਰੁʼਤ੍ਵਾ ਸਮਾਨਿਨਾਯ| ");
INSERT INTO sanpun_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","ਪ੍ਰਭੁਃ ਪਰਮੇਸ਼੍ਵਰੋ ਯੁਸ਼਼੍ਮਾਕੰ ਭ੍ਰਾਤ੍ਰੁʼਗਣਸ੍ਯ ਮਧ੍ਯੇ ਮਾਦ੍ਰੁʼਸ਼ਮ੍ ਏਕੰ ਭਵਿਸ਼਼੍ਯਦ੍ਵਕ੍ਤਾਰਮ੍ ਉਤ੍ਪਾਦਯਿਸ਼਼੍ਯਤਿ ਤਸ੍ਯ ਕਥਾਯਾਂ ਯੂਯੰ ਮਨੋ ਨਿਧਾਸ੍ਯਥ, ਯੋ ਜਨ ਇਸ੍ਰਾਯੇਲਃ ਸਨ੍ਤਾਨੇਭ੍ਯ ਏਨਾਂ ਕਥਾਂ ਕਥਯਾਮਾਸ ਸ ਏਸ਼਼ ਮੂਸਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","ਮਹਾਪ੍ਰਾਨ੍ਤਰਸ੍ਥਮਣ੍ਡਲੀਮਧ੍ਯੇ(ਅ)ਪਿ ਸ ਏਵ ਸੀਨਯਪਰ੍ੱਵਤੋਪਰਿ ਤੇਨ ਸਾਰ੍ੱਧੰ ਸੰਲਾਪਿਨੋ ਦੂਤਸ੍ਯ ਚਾਸ੍ਮਤ੍ਪਿਤ੍ਰੁʼਗਣਸ੍ਯ ਮਧ੍ਯਸ੍ਥਃ ਸਨ੍ ਅਸ੍ਮਭ੍ਯੰ ਦਾਤਵ੍ਯਨਿ ਜੀਵਨਦਾਯਕਾਨਿ ਵਾਕ੍ਯਾਨਿ ਲੇਭੇ| ");
INSERT INTO sanpun_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","ਅਸ੍ਮਾਕੰ ਪੂਰ੍ੱਵਪੁਰੁਸ਼਼ਾਸ੍ਤਮ੍ ਅਮਾਨ੍ਯੰ ਕਤ੍ਵਾ ਸ੍ਵੇਭ੍ਯੋ ਦੂਰੀਕ੍ਰੁʼਤ੍ਯ ਮਿਸਰਦੇਸ਼ੰ ਪਰਾਵ੍ਰੁʼਤ੍ਯ ਗਨ੍ਤੁੰ ਮਨੋਭਿਰਭਿਲਸ਼਼੍ਯ ਹਾਰੋਣੰ ਜਗਦੁਃ, ");
INSERT INTO sanpun_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ਅਸ੍ਮਾਕਮ੍ ਅਗ੍ਰੇ(ਅ)ਗ੍ਰੇ ਗਨ੍ਤੁुਮ੍ ਅਸ੍ਮਦਰ੍ਥੰ ਦੇਵਗਣੰ ਨਿਰ੍ੰਮਾਹਿ ਯਤੋ ਯੋ ਮੂਸਾ ਅਸ੍ਮਾਨ੍ ਮਿਸਰਦੇਸ਼ਾਦ੍ ਬਹਿਃ ਕ੍ਰੁʼਤ੍ਵਾਨੀਤਵਾਨ੍ ਤਸ੍ਯ ਕਿੰ ਜਾਤੰ ਤਦਸ੍ਮਾਭਿ ਰ੍ਨ ਜ੍ਞਾਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","ਤਸ੍ਮਿਨ੍ ਸਮਯੇ ਤੇ ਗੋਵਤ੍ਸਾਕ੍ਰੁʼਤਿੰ ਪ੍ਰਤਿਮਾਂ ਨਿਰ੍ੰਮਾਯ ਤਾਮੁੱਦਿਸ਼੍ਯ ਨੈਵੇਦ੍ਯਮੁਤ੍ਮ੍ਰੁʼਜ੍ਯ ਸ੍ਵਹਸ੍ਤਕ੍ਰੁʼਤਵਸ੍ਤੁਨਾ ਆਨਨ੍ਦਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","ਤਸ੍ਮਾਦ੍ ਈਸ਼੍ਵਰਸ੍ਤੇਸ਼਼ਾਂ ਪ੍ਰਤਿ ਵਿਮੁਖਃ ਸਨ੍ ਆਕਾਸ਼ਸ੍ਥੰ ਜ੍ਯੋਤਿਰ੍ਗਣੰ ਪੂਜਯਿਤੁੰ ਤੇਭ੍ਯੋ(ਅ)ਨੁਮਤਿੰ ਦਦੌ, ਯਾਦ੍ਰੁʼਸ਼ੰ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਾਂ ਗ੍ਰਨ੍ਥੇਸ਼਼ੁ ਲਿਖਿਤਮਾਸ੍ਤੇ, ਯਥਾ, ਇਸ੍ਰਾਯੇਲੀਯਵੰਸ਼ਾ ਰੇ ਚਤ੍ਵਾਰਿੰਸ਼ਤ੍ਸਮਾਨ੍ ਪੁਰਾ| ਮਹਤਿ ਪ੍ਰਾਨ੍ਤਰੇ ਸੰਸ੍ਥਾ ਯੂਯਨ੍ਤੁ ਯਾਨਿ ਚ| ਬਲਿਹੋਮਾਦਿਕਰ੍ੰਮਾਣਿ ਕ੍ਰੁʼਤਵਨ੍ਤਸ੍ਤੁ ਤਾਨਿ ਕਿੰ| ਮਾਂ ਸਮੁੱਦਿਸ਼੍ਯ ਯੁਸ਼਼੍ਮਾਭਿਃ ਪ੍ਰਕ੍ਰੁʼਤਾਨੀਤਿ ਨੈਵ ਚ| ");
INSERT INTO sanpun_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","ਕਿਨ੍ਤੁ ਵੋ ਮੋਲਕਾਖ੍ਯਸ੍ਯ ਦੇਵਸ੍ਯ ਦੂਸ਼਼੍ਯਮੇਵ ਚ| ਯੁਸ਼਼੍ਮਾਕੰ ਰਿਮ੍ਫਨਾਖ੍ਯਾਯਾ ਦੇਵਤਾਯਾਸ਼੍ਚ ਤਾਰਕਾ| ਏਤਯੋਰੁਭਯੋ ਰ੍ਮੂਰ੍ਤੀ ਯੁਸ਼਼੍ਮਾਭਿਃ ਪਰਿਪੂਜਿਤੇ| ਅਤੋ ਯੁਸ਼਼੍ਮਾਂਸ੍ਤੁ ਬਾਬੇਲਃ ਪਾਰੰ ਨੇਸ਼਼੍ਯਾਮਿ ਨਿਸ਼੍ਚਿਤੰ| ");
INSERT INTO sanpun_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","ਅਪਰਞ੍ਚ ਯੰਨਿਦਰ੍ਸ਼ਨਮ੍ ਅਪਸ਼੍ਯਸ੍ਤਦਨੁਸਾਰੇਣ ਦੂਸ਼਼੍ਯੰ ਨਿਰ੍ੰਮਾਹਿ ਯਸ੍ਮਿਨ੍ ਈਸ਼੍ਵਰੋ ਮੂਸਾਮ੍ ਏਤਦ੍ਵਾਕ੍ਯੰ ਬਭਾਸ਼਼ੇ ਤਤ੍ ਤਸ੍ਯ ਨਿਰੂਪਿਤੰ ਸਾਕ੍ਸ਼਼੍ਯਸ੍ਵਰੂਪੰ ਦੂਸ਼਼੍ਯਮ੍ ਅਸ੍ਮਾਕੰ ਪੂਰ੍ੱਵਪੁਰੁਸ਼਼ੈਃ ਸਹ ਪ੍ਰਾਨ੍ਤਰੇ ਤਸ੍ਥੌ| ");
INSERT INTO sanpun_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","ਪਸ਼੍ਚਾਤ੍ ਯਿਹੋਸ਼ੂਯੇਨ ਸਹਿਤੈਸ੍ਤੇਸ਼਼ਾਂ ਵੰਸ਼ਜਾਤੈਰਸ੍ਮਤ੍ਪੂਰ੍ੱਵਪੁਰੁਸ਼਼ੈਃ ਸ੍ਵੇਸ਼਼ਾਂ ਸੰਮੁਖਾਦ੍ ਈਸ਼੍ਵਰੇਣ ਦੂਰੀਕ੍ਰੁʼਤਾਨਾਮ੍ ਅਨ੍ਯਦੇਸ਼ੀਯਾਨਾਂ ਦੇਸ਼ਾਧਿਕ੍ਰੁʼਤਿਕਾਲੇ ਸਮਾਨੀਤੰ ਤਦ੍ ਦੂਸ਼਼੍ਯੰ ਦਾਯੂਦੋਧਿਕਾਰੰ ਯਾਵਤ੍ ਤਤ੍ਰ ਸ੍ਥਾਨ ਆਸੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ਸ ਦਾਯੂਦ੍ ਪਰਮੇਸ਼੍ਵਰਸ੍ਯਾਨੁਗ੍ਰਹੰ ਪ੍ਰਾਪ੍ਯ ਯਾਕੂਬ੍ ਈਸ਼੍ਵਰਾਰ੍ਥਮ੍ ਏਕੰ ਦੂਸ਼਼੍ਯੰ ਨਿਰ੍ੰਮਾਤੁੰ ਵਵਾਞ੍ਛ; ");
INSERT INTO sanpun_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","ਕਿਨ੍ਤੁ ਸੁਲੇਮਾਨ੍ ਤਦਰ੍ਥੰ ਮਨ੍ਦਿਰਮ੍ ਏਕੰ ਨਿਰ੍ੰਮਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","ਤਥਾਪਿ ਯਃ ਸਰ੍ੱਵੋਪਰਿਸ੍ਥਃ ਸ ਕਸ੍ਮਿੰਸ਼੍ਚਿਦ੍ ਹਸ੍ਤਕ੍ਰੁʼਤੇ ਮਨ੍ਦਿਰੇ ਨਿਵਸਤੀਤਿ ਨਹਿ, ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦੀ ਕਥਾਮੇਤਾਂ ਕਥਯਤਿ, ਯਥਾ, ");
INSERT INTO sanpun_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","ਪਰੇਸ਼ੋ ਵਦਤਿ ਸ੍ਵਰ੍ਗੋ ਰਾਜਸਿੰਹਾਸਨੰ ਮਮ| ਮਦੀਯੰ ਪਾਦਪੀਠਞ੍ਚ ਪ੍ਰੁʼਥਿਵੀ ਭਵਤਿ ਧ੍ਰੁਵੰ| ਤਰ੍ਹਿ ਯੂਯੰ ਕ੍ਰੁʼਤੇ ਮੇ ਕਿੰ ਪ੍ਰਨਿਰ੍ੰਮਾਸ੍ਯਥ ਮਨ੍ਦਿਰੰ| ਵਿਸ਼੍ਰਾਮਾਯ ਮਦੀਯੰ ਵਾ ਸ੍ਥਾਨੰ ਕਿੰ ਵਿਦ੍ਯਤੇ ਤ੍ਵਿਹ| ");
INSERT INTO sanpun_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","ਸਰ੍ੱਵਾਣ੍ਯੇਤਾਨਿ ਵਸ੍ਤੂਨਿ ਕਿੰ ਮੇ ਹਸ੍ਤਕ੍ਰੁʼਤਾਨਿ ਨ|| ");
INSERT INTO sanpun_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","ਹੇ ਅਨਾਜ੍ਞਾਗ੍ਰਾਹਕਾ ਅਨ੍ਤਃਕਰਣੇ ਸ਼੍ਰਵਣੇ ਚਾਪਵਿਤ੍ਰਲੋਕਾਃ ਯੂਯਮ੍ ਅਨਵਰਤੰ ਪਵਿਤ੍ਰਸ੍ਯਾਤ੍ਮਨਃ ਪ੍ਰਾਤਿਕੂਲ੍ਯਮ੍ ਆਚਰਥ, ਯੁਸ਼਼੍ਮਾਕੰ ਪੂਰ੍ੱਵਪੁਰੁਸ਼਼ਾ ਯਾਦ੍ਰੁʼਸ਼ਾ ਯੂਯਮਪਿ ਤਾਦ੍ਰੁʼਸ਼ਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","ਯੁਸ਼਼੍ਮਾਕੰ ਪੂਰ੍ੱਵਪੁਰੁਸ਼਼ਾਃ ਕੰ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨੰ ਨਾਤਾਡਯਨ੍? ਯੇ ਤਸ੍ਯ ਧਾਰ੍ੰਮਿਕਸ੍ਯ ਜਨਸ੍ਯਾਗਮਨਕਥਾਂ ਕਥਿਤਵਨ੍ਤਸ੍ਤਾਨ੍ ਅਘ੍ਨਨ੍ ਯੂਯਮ੍ ਅਧੂਨਾ ਵਿਸ਼੍ਵਾਸਘਾਤਿਨੋ ਭੂਤ੍ਵਾ ਤੰ ਧਾਰ੍ੰਮਿਕੰ ਜਨਮ੍ ਅਹਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","ਯੂਯੰ ਸ੍ਵਰ੍ਗੀਯਦੂਤਗਣੇਨ ਵ੍ਯਵਸ੍ਥਾਂ ਪ੍ਰਾਪ੍ਯਾਪਿ ਤਾਂ ਨਾਚਰਥ| ");
INSERT INTO sanpun_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ਇਮਾਂ ਕਥਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਤੇ ਮਨਃਸੁ ਬਿੱਧਾਃ ਸਨ੍ਤਸ੍ਤੰ ਪ੍ਰਤਿ ਦਨ੍ਤਘਰ੍ਸ਼਼ਣਮ੍ ਅਕੁਰ੍ੱਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","ਕਿਨ੍ਤੁ ਸ੍ਤਿਫਾਨਃ ਪਵਿਤ੍ਰੇਣਾਤ੍ਮਨਾ ਪੂਰ੍ਣੋ ਭੂਤ੍ਵਾ ਗਗਣੰ ਪ੍ਰਤਿ ਸ੍ਥਿਰਦ੍ਰੁʼਸ਼਼੍ਟਿੰ ਕ੍ਰੁʼਤ੍ਵਾ ਈਸ਼੍ਵਰਸ੍ਯ ਦਕ੍ਸ਼਼ਿਣੇ ਦਣ੍ਡਾਯਮਾਨੰ ਯੀਸ਼ੁਞ੍ਚ ਵਿਲੋਕ੍ਯ ਕਥਿਤਵਾਨ੍; ");
INSERT INTO sanpun_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","ਪਸ਼੍ਯ,ਮੇਘਦ੍ਵਾਰੰ ਮੁਕ੍ਤਮ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਦਕ੍ਸ਼਼ਿਣੇ ਸ੍ਥਿਤੰ ਮਾਨਵਸੁਤਞ੍ਚ ਪਸ਼੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","ਤਦਾ ਤੇ ਪ੍ਰੋੱਚੈਃ ਸ਼ਬ੍ਦੰ ਕ੍ਰੁʼਤ੍ਵਾ ਕਰ੍ਣੇਸ਼਼੍ਵਙ੍ਗੁਲੀ ਰ੍ਨਿਧਾਯ ਏਕਚਿੱਤੀਭੂਯ ਤਮ੍ ਆਕ੍ਰਮਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ਪਸ਼੍ਚਾਤ੍ ਤੰ ਨਗਰਾਦ੍ ਬਹਿਃ ਕ੍ਰੁʼਤ੍ਵਾ ਪ੍ਰਸ੍ਤਰੈਰਾਘ੍ਨਨ੍ ਸਾਕ੍ਸ਼਼ਿਣੋ ਲਾਕਾਃ ਸ਼ੌਲਨਾਮ੍ਨੋ ਯੂਨਸ਼੍ਚਰਣਸੰਨਿਧੌ ਨਿਜਵਸ੍ਤ੍ਰਾਣਿ ਸ੍ਥਾਪਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","ਅਨਨ੍ਤਰੰ ਹੇ ਪ੍ਰਭੋ ਯੀਸ਼ੇ ਮਦੀਯਮਾਤ੍ਮਾਨੰ ਗ੍ਰੁʼਹਾਣ ਸ੍ਤਿਫਾਨਸ੍ਯੇਤਿ ਪ੍ਰਾਰ੍ਥਨਵਾਕ੍ਯਵਦਨਸਮਯੇ ਤੇ ਤੰ ਪ੍ਰਸ੍ਤਰੈਰਾਘ੍ਨਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ਤਸ੍ਮਾਤ੍ ਸ ਜਾਨੁਨੀ ਪਾਤਯਿਤ੍ਵਾ ਪ੍ਰੋੱਚੈਃ ਸ਼ਬ੍ਦੰ ਕ੍ਰੁʼਤ੍ਵਾ, ਹੇ ਪ੍ਰਭੇ ਪਾਪਮੇਤਦ੍ ਏਤੇਸ਼਼ੁ ਮਾ ਸ੍ਥਾਪਯ, ਇਤ੍ਯੁਕ੍ਤ੍ਵਾ ਮਹਾਨਿਦ੍ਰਾਂ ਪ੍ਰਾਪ੍ਨੋਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","ਤਸ੍ਯ ਹਤ੍ਯਾਕਰਣੰ ਸ਼ੌਲੋਪਿ ਸਮਮਨ੍ਯਤ| ਤਸ੍ਮਿਨ੍ ਸਮਯੇ ਯਿਰੂਸ਼ਾਲਮ੍ਨਗਰਸ੍ਥਾਂ ਮਣ੍ਡਲੀਂ ਪ੍ਰਤਿ ਮਹਾਤਾਡਨਾਯਾਂ ਜਾਤਾਯਾਂ ਪ੍ਰੇਰਿਤਲੋਕਾਨ੍ ਹਿਤ੍ਵਾ ਸਰ੍ੱਵੇ(ਅ)ਪਰੇ ਯਿਹੂਦਾਸ਼ੋਮਿਰੋਣਦੇਸ਼ਯੋ ਰ੍ਨਾਨਾਸ੍ਥਾਨੇ ਵਿਕੀਰ੍ਣਾਃ ਸਨ੍ਤੋ ਗਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","ਅਨ੍ਯੱਚ ਭਕ੍ਤਲੋਕਾਸ੍ਤੰ ਸ੍ਤਿਫਾਨੰ ਸ਼੍ਮਸ਼ਾਨੇ ਸ੍ਥਾਪਯਿਤ੍ਵਾ ਬਹੁ ਵ੍ਯਲਪਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","ਕਿਨ੍ਤੁ ਸ਼ੌਲੋ ਗ੍ਰੁʼਹੇ ਗ੍ਰੁʼਹੇ ਭ੍ਰਮਿਤ੍ਵਾ ਸ੍ਤ੍ਰਿਯਃ ਪੁਰੁਸ਼਼ਾਂਸ਼੍ਚ ਧ੍ਰੁʼਤ੍ਵਾ ਕਾਰਾਯਾਂ ਬੱਧ੍ਵਾ ਮਣ੍ਡਲ੍ਯਾ ਮਹੋਤ੍ਪਾਤੰ ਕ੍ਰੁʼਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","ਅਨ੍ਯੱਚ ਯੇ ਵਿਕੀਰ੍ਣਾ ਅਭਵਨ੍ ਤੇ ਸਰ੍ੱਵਤ੍ਰ ਭ੍ਰਮਿਤ੍ਵਾ ਸੁਸੰਵਾਦੰ ਪ੍ਰਾਚਾਰਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ਤਦਾ ਫਿਲਿਪਃ ਸ਼ੋਮਿਰੋਣ੍ਨਗਰੰ ਗਤ੍ਵਾ ਖ੍ਰੀਸ਼਼੍ਟਾਖ੍ਯਾਨੰ ਪ੍ਰਾਚਾਰਯਤ੍; ");
INSERT INTO sanpun_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ਤਤੋ(ਅ)ਸ਼ੁਚਿ-ਭ੍ਰੁʼਤਗ੍ਰਸ੍ਤਲੋਕੇਭ੍ਯੋ ਭੂਤਾਸ਼੍ਚੀਤ੍ਕ੍ਰੁʼਤ੍ਯਾਗੱਛਨ੍ ਤਥਾ ਬਹਵਃ ਪਕ੍ਸ਼਼ਾਘਾਤਿਨਃ ਖਞ੍ਜਾ ਲੋਕਾਸ਼੍ਚ ਸ੍ਵਸ੍ਥਾ ਅਭਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","ਤਸ੍ਮਾਤ੍ ਲਾਕਾ ਈਦ੍ਰੁʼਸ਼ੰ ਤਸ੍ਯਾਸ਼੍ਚਰ੍ੱਯੰ ਕਰ੍ੰਮ ਵਿਲੋਕ੍ਯ ਨਿਸ਼ਮ੍ਯ ਚ ਸਰ੍ੱਵ ਏਕਚਿੱਤੀਭੂਯ ਤੇਨੋਕ੍ਤਾਖ੍ਯਾਨੇ ਮਨਾਂਸਿ ਨ੍ਯਦਧੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","ਤਸ੍ਮਿੰਨਗਰੇ ਮਹਾਨਨ੍ਦਸ਼੍ਚਾਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ਤਤਃ ਪੂਰ੍ੱਵੰ ਤਸ੍ਮਿੰਨਗਰੇ ਸ਼ਿਮੋੰਨਾਮਾ ਕਸ਼੍ਚਿੱਜਨੋ ਬਹ੍ਵੀ ਰ੍ਮਾਯਾਕ੍ਰਿਯਾਃ ਕ੍ਰੁʼਤ੍ਵਾ ਸ੍ਵੰ ਕਞ੍ਚਨ ਮਹਾਪੁਰੁਸ਼਼ੰ ਪ੍ਰੋਚ੍ਯ ਸ਼ੋਮਿਰੋਣੀਯਾਨਾਂ ਮੋਹੰ ਜਨਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ਤਸ੍ਮਾਤ੍ ਸ ਮਾਨੁਸ਼਼ ਈਸ਼੍ਵਰਸ੍ਯ ਮਹਾਸ਼ਕ੍ਤਿਸ੍ਵਰੂਪ ਇਤ੍ਯੁਕ੍ਤ੍ਵਾ ਬਾਲਵ੍ਰੁʼੱਧਵਨਿਤਾਃ ਸਰ੍ੱਵੇ ਲਾਕਾਸ੍ਤਸ੍ਮਿਨ੍ ਮਨਾਂਸਿ ਨ੍ਯਦਧੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ਸ ਬਹੁਕਾਲਾਨ੍ ਮਾਯਾਵਿਕ੍ਰਿਯਯਾ ਸਰ੍ੱਵਾਨ੍ ਅਤੀਵ ਮੋਹਯਾਞ੍ਚਕਾਰ, ਤਸ੍ਮਾਤ੍ ਤੇ ਤੰ ਮੇਨਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","ਕਿਨ੍ਤ੍ਵੀਸ਼੍ਵਰਸ੍ਯ ਰਾਜ੍ਯਸ੍ਯ ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਨਾਮ੍ਨਸ਼੍ਚਾਖ੍ਯਾਨਪ੍ਰਚਾਰਿਣਃ ਫਿਲਿਪਸ੍ਯ ਕਥਾਯਾਂ ਵਿਸ਼੍ਵਸ੍ਯ ਤੇਸ਼਼ਾਂ ਸ੍ਤ੍ਰੀਪੁਰੁਸ਼਼ੋਭਯਲੋਕਾ ਮੱਜਿਤਾ ਅਭਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ਸ਼ੇਸ਼਼ੇ ਸ ਸ਼ਿਮੋਨਪਿ ਸ੍ਵਯੰ ਪ੍ਰਤ੍ਯੈਤ੍ ਤਤੋ ਮੱਜਿਤਃ ਸਨ੍ ਫਿਲਿਪੇਨ ਕ੍ਰੁʼਤਾਮ੍ ਆਸ਼੍ਚਰ੍ੱਯਕ੍ਰਿਯਾਂ ਲਕ੍ਸ਼਼ਣਞ੍ਚ ਵਿਲੋਕ੍ਯਾਸਮ੍ਭਵੰ ਮਨ੍ਯਮਾਨਸ੍ਤੇਨ ਸਹ ਸ੍ਥਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ਇੱਥੰ ਸ਼ੋਮਿਰੋਣ੍ਦੇਸ਼ੀਯਲੋਕਾ ਈਸ਼੍ਵਰਸ੍ਯ ਕਥਾਮ੍ ਅਗ੍ਰੁʼਹ੍ਲਨ੍ ਇਤਿ ਵਾਰ੍ੱਤਾਂ ਯਿਰੂਸ਼ਾਲਮ੍ਨਗਰਸ੍ਥਪ੍ਰੇਰਿਤਾਃ ਪ੍ਰਾਪ੍ਯ ਪਿਤਰੰ ਯੋਹਨਞ੍ਚ ਤੇਸ਼਼ਾਂ ਨਿਕਟੇ ਪ੍ਰੇਸ਼਼ਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ਤਤਸ੍ਤੌ ਤਤ੍ ਸ੍ਥਾਨਮ੍ ਉਪਸ੍ਥਾਯ ਲੋਕਾ ਯਥਾ ਪਵਿਤ੍ਰਮ੍ ਆਤ੍ਮਾਨੰ ਪ੍ਰਾਪ੍ਨੁਵਨ੍ਤਿ ਤਦਰ੍ਥੰ ਪ੍ਰਾਰ੍ਥਯੇਤਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ਯਤਸ੍ਤੇ ਪੁਰਾ ਕੇਵਲਪ੍ਰਭੁਯੀਸ਼ੋ ਰ੍ਨਾਮ੍ਨਾ ਮੱਜਿਤਮਾਤ੍ਰਾ ਅਭਵਨ੍, ਨ ਤੁ ਤੇਸ਼਼ਾਂ ਮਧ੍ਯੇ ਕਮਪਿ ਪ੍ਰਤਿ ਪਵਿਤ੍ਰਸ੍ਯਾਤ੍ਮਨ ਆਵਿਰ੍ਭਾਵੋ ਜਾਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","ਕਿਨ੍ਤੁ ਪ੍ਰੇਰਿਤਾਭ੍ਯਾਂ ਤੇਸ਼਼ਾਂ ਗਾਤ੍ਰੇਸ਼਼ੁ ਕਰੇਸ਼਼੍ਵਰ੍ਪਿਤੇਸ਼਼ੁ ਸਤ੍ਸੁ ਤੇ ਪਵਿਤ੍ਰਮ੍ ਆਤ੍ਮਾਨਮ੍ ਪ੍ਰਾਪ੍ਨੁਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","ਇੱਥੰ ਲੋਕਾਨਾਂ ਗਾਤ੍ਰੇਸ਼਼ੁ ਪ੍ਰੇਰਿਤਯੋਃ ਕਰਾਰ੍ਪਣੇਨ ਤਾਨ੍ ਪਵਿਤ੍ਰਮ੍ ਆਤ੍ਮਾਨੰ ਪ੍ਰਾਪ੍ਤਾਨ੍ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਸ ਸ਼ਿਮੋਨ੍ ਤਯੋਃ ਸਮੀਪੇ ਮੁਦ੍ਰਾ ਆਨੀਯ ਕਥਿਤਵਾਨ੍; ");
INSERT INTO sanpun_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ਅਹੰ ਯਸ੍ਯ ਗਾਤ੍ਰੇ ਹਸ੍ਤਮ੍ ਅਰ੍ਪਯਿਸ਼਼੍ਯਾਮਿ ਤਸ੍ਯਾਪਿ ਯਥੇੱਥੰ ਪਵਿਤ੍ਰਾਤ੍ਮਪ੍ਰਾਪ੍ਤਿ ਰ੍ਭਵਤਿ ਤਾਦ੍ਰੁʼਸ਼ੀਂ ਸ਼ਕ੍ਤਿੰ ਮਹ੍ਯੰ ਦੱਤੰ| ");
INSERT INTO sanpun_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","ਕਿਨ੍ਤੁ ਪਿਤਰਸ੍ਤੰ ਪ੍ਰਤ੍ਯਵਦਤ੍ ਤਵ ਮੁਦ੍ਰਾਸ੍ਤ੍ਵਯਾ ਵਿਨਸ਼੍ਯਨ੍ਤੁ ਯਤ ਈਸ਼੍ਵਰਸ੍ਯ ਦਾਨੰ ਮੁਦ੍ਰਾਭਿਃ ਕ੍ਰੀਯਤੇ ਤ੍ਵਮਿੱਥੰ ਬੁੱਧਵਾਨ੍; ");
INSERT INTO sanpun_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ਈਸ਼੍ਵਰਾਯ ਤਾਵਨ੍ਤਃਕਰਣੰ ਸਰਲੰ ਨਹਿ, ਤਸ੍ਮਾਦ੍ ਅਤ੍ਰ ਤਵਾਂਸ਼ੋ(ਅ)ਧਿਕਾਰਸ਼੍ਚ ਕੋਪਿ ਨਾਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ਅਤ ਏਤਤ੍ਪਾਪਹੇਤੋਃ ਖੇਦਾਨ੍ਵਿਤਃ ਸਨ੍ ਕੇਨਾਪਿ ਪ੍ਰਕਾਰੇਣ ਤਵ ਮਨਸ ਏਤਸ੍ਯਾਃ ਕੁਕਲ੍ਪਨਾਯਾਃ ਕ੍ਸ਼਼ਮਾ ਭਵਤਿ, ਏਤਦਰ੍ਥਮ੍ ਈਸ਼੍ਵਰੇ ਪ੍ਰਾਰ੍ਥਨਾਂ ਕੁਰੁ; ");
INSERT INTO sanpun_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","ਯਤਸ੍ਤ੍ਵੰ ਤਿਕ੍ਤਪਿੱਤੇ ਪਾਪਸ੍ਯ ਬਨ੍ਧਨੇ ਚ ਯਦਸਿ ਤਨ੍ਮਯਾ ਬੁੱਧਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","ਤਦਾ ਸ਼ਿਮੋਨ੍ ਅਕਥਯਤ੍ ਤਰ੍ਹਿ ਯੁਵਾਭ੍ਯਾਮੁਦਿਤਾ ਕਥਾ ਮਯਿ ਯਥਾ ਨ ਫਲਤਿ ਤਦਰ੍ਥੰ ਯੁਵਾਂ ਮੰਨਿਮਿੱਤੰ ਪ੍ਰਭੌ ਪ੍ਰਾਰ੍ਥਨਾਂ ਕੁਰੁਤੰ| ");
INSERT INTO sanpun_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","ਅਨੇਨ ਪ੍ਰਕਾਰੇਣ ਤੌ ਸਾਕ੍ਸ਼਼੍ਯੰ ਦੱਤ੍ਵਾ ਪ੍ਰਭੋਃ ਕਥਾਂ ਪ੍ਰਚਾਰਯਨ੍ਤੌ ਸ਼ੋਮਿਰੋਣੀਯਾਨਾਮ੍ ਅਨੇਕਗ੍ਰਾਮੇਸ਼਼ੁ ਸੁਸੰਵਾਦਞ੍ਚ ਪ੍ਰਚਾਰਯਨ੍ਤੌ ਯਿਰੂਸ਼ਾਲਮ੍ਨਗਰੰ ਪਰਾਵ੍ਰੁʼਤ੍ਯ ਗਤੌ| ");
INSERT INTO sanpun_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ਤਤਃ ਪਰਮ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਦੂਤਃ ਫਿਲਿਪਮ੍ ਇਤ੍ਯਾਦਿਸ਼ਤ੍, ਤ੍ਵਮੁੱਥਾਯ ਦਕ੍ਸ਼਼ਿਣਸ੍ਯਾਂ ਦਿਸ਼ਿ ਯੋ ਮਾਰ੍ਗੋ ਪ੍ਰਾਨ੍ਤਰਸ੍ਯ ਮਧ੍ਯੇਨ ਯਿਰੂਸ਼ਾਲਮੋ (ਅ)ਸਾਨਗਰੰ ਯਾਤਿ ਤੰ ਮਾਰ੍ਗੰ ਗੱਛ| ");
INSERT INTO sanpun_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ਤਤਃ ਸ ਉੱਥਾਯ ਗਤਵਾਨ੍; ਤਦਾ ਕਨ੍ਦਾਕੀਨਾਮ੍ਨਃ ਕੂਸ਼੍ਲੋਕਾਨਾਂ ਰਾਜ੍ਞ੍ਯਾਃ ਸਰ੍ੱਵਸਮ੍ਪੱਤੇਰਧੀਸ਼ਃ ਕੂਸ਼ਦੇਸ਼ੀਯ ਏਕਃ ਸ਼਼ਣ੍ਡੋ ਭਜਨਾਰ੍ਥੰ ਯਿਰੂਸ਼ਾਲਮ੍ਨਗਰਮ੍ ਆਗਤ੍ਯ ");
INSERT INTO sanpun_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ਪੁਨਰਪਿ ਰਥਮਾਰੁਹ੍ਯ ਯਿਸ਼ਯਿਯਨਾਮ੍ਨੋ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨੋ ਗ੍ਰਨ੍ਥੰ ਪਠਨ੍ ਪ੍ਰਤ੍ਯਾਗੱਛਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ਏਤਸ੍ਮਿਨ੍ ਸਮਯੇ ਆਤ੍ਮਾ ਫਿਲਿਪਮ੍ ਅਵਦਤ੍, ਤ੍ਵਮ੍ ਰਥਸ੍ਯ ਸਮੀਪੰ ਗਤ੍ਵਾ ਤੇਨ ਸਾਰ੍ੱਧੰ ਮਿਲ| ");
INSERT INTO sanpun_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","ਤਸ੍ਮਾਤ੍ ਸ ਧਾਵਨ੍ ਤਸ੍ਯ ਸੰਨਿਧਾਵੁਪਸ੍ਥਾਯ ਤੇਨ ਪਠ੍ਯਮਾਨੰ ਯਿਸ਼ਯਿਯਥਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨੋ ਵਾਕ੍ਯੰ ਸ਼੍ਰੁਤ੍ਵਾ ਪ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍ ਯਤ੍ ਪਠਸਿ ਤਤ੍ ਕਿੰ ਬੁਧ੍ਯਸੇ? ");
INSERT INTO sanpun_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","ਤਤਃ ਸ ਕਥਿਤਵਾਨ੍ ਕੇਨਚਿੰਨ ਬੋਧਿਤੋਹੰ ਕਥੰ ਬੁਧ੍ਯੇਯ? ਤਤਃ ਸ ਫਿਲਿਪੰ ਰਥਮਾਰੋਢੁੰ ਸ੍ਵੇਨ ਸਾਰ੍ੱਧਮ੍ ਉਪਵੇਸ਼਼੍ਟੁਞ੍ਚ ਨ੍ਯਵੇਦਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ਸ ਸ਼ਾਸ੍ਤ੍ਰਸ੍ਯੇਤਦ੍ਵਾਕ੍ਯੰ ਪਠਿਤਵਾਨ੍ ਯਥਾ, ਸਮਾਨੀਯਤ ਘਾਤਾਯ ਸ ਯਥਾ ਮੇਸ਼਼ਸ਼ਾਵਕਃ| ਲੋਮੱਛੇਦਕਸਾਕ੍ਸ਼਼ਾੱਚ ਮੇਸ਼਼ਸ਼੍ਚ ਨੀਰਵੋ ਯਥਾ| ਆਬਧ੍ਯ ਵਦਨੰ ਸ੍ਵੀਯੰ ਤਥਾ ਸ ਸਮਤਿਸ਼਼੍ਠਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ਅਨ੍ਯਾਯੇਨ ਵਿਚਾਰੇਣ ਸ ਉੱਛਿੰਨੋ (ਅ)ਭਵਤ੍ ਤਦਾ| ਤਤ੍ਕਾਲੀਨਮਨੁਸ਼਼੍ਯਾਨ੍ ਕੋ ਜਨੋ ਵਰ੍ਣਯਿਤੁੰ ਕ੍ਸ਼਼ਮਃ| ਯਤੋ ਜੀਵੰਨ੍ਰੁʼਣਾਂ ਦੇਸ਼ਾਤ੍ ਸ ਉੱਛਿੰਨੋ (ਅ)ਭਵਤ੍ ਧ੍ਰੁਵੰ| ");
INSERT INTO sanpun_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","ਅਨਨ੍ਤਰੰ ਸ ਫਿਲਿਪਮ੍ ਅਵਦਤ੍ ਨਿਵੇਦਯਾਮਿ, ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦੀ ਯਾਮਿਮਾਂ ਕਥਾਂ ਕਥਯਾਮਾਸ ਸ ਕਿੰ ਸ੍ਵਸ੍ਮਿਨ੍ ਵਾ ਕਸ੍ਮਿੰਸ਼੍ਚਿਦ੍ ਅਨ੍ਯਸ੍ਮਿਨ੍? ");
INSERT INTO sanpun_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ਤਤਃ ਫਿਲਿਪਸ੍ਤਤ੍ਪ੍ਰਕਰਣਮ੍ ਆਰਭ੍ਯ ਯੀਸ਼ੋਰੁਪਾਖ੍ਯਾਨੰ ਤਸ੍ਯਾਗ੍ਰੇ ਪ੍ਰਾਸ੍ਤੌਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ਇੱਥੰ ਮਾਰ੍ਗੇਣ ਗੱਛਨ੍ਤੌ ਜਲਾਸ਼ਯਸ੍ਯ ਸਮੀਪ ਉਪਸ੍ਥਿਤੌ; ਤਦਾ ਕ੍ਲੀਬੋ(ਅ)ਵਾਦੀਤ੍ ਪਸ਼੍ਯਾਤ੍ਰ ਸ੍ਥਾਨੇ ਜਲਮਾਸ੍ਤੇ ਮਮ ਮੱਜਨੇ ਕਾ ਬਾਧਾ? ");
INSERT INTO sanpun_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","ਤਤਃ ਫਿਲਿਪ ਉੱਤਰੰ ਵ੍ਯਾਹਰਤ੍ ਸ੍ਵਾਨ੍ਤਃਕਰਣੇਨ ਸਾਕੰ ਯਦਿ ਪ੍ਰਤ੍ਯੇਸ਼਼ਿ ਤਰ੍ਹਿ ਬਾਧਾ ਨਾਸ੍ਤਿ| ਤਤਃ ਸ ਕਥਿਤਵਾਨ੍ ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟ ਈਸ਼੍ਵਰਸ੍ਯ ਪੁਤ੍ਰ ਇਤ੍ਯਹੰ ਪ੍ਰਤ੍ਯੇਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","ਤਦਾ ਰਥੰ ਸ੍ਥਗਿਤੰ ਕਰ੍ੱਤੁਮ੍ ਆਦਿਸ਼਼੍ਟੇ ਫਿਲਿਪਕ੍ਲੀਬੌ ਦ੍ਵੌ ਜਲਮ੍ ਅਵਾਰੁਹਤਾਂ; ਤਦਾ ਫਿਲਿਪਸ੍ਤਮ੍ ਮੱਜਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","ਤਤ੍ਪਸ਼੍ਚਾਤ੍ ਜਲਮਧ੍ਯਾਦ੍ ਉੱਥਿਤਯੋਃ ਸਤੋਃ ਪਰਮੇਸ਼੍ਵਰਸ੍ਯਾਤ੍ਮਾ ਫਿਲਿਪੰ ਹ੍ਰੁʼਤ੍ਵਾ ਨੀਤਵਾਨ੍, ਤਸ੍ਮਾਤ੍ ਕ੍ਲੀਬਃ ਪੁਨਸ੍ਤੰ ਨ ਦ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍ ਤਥਾਪਿ ਹ੍ਰੁʼਸ਼਼੍ਟਚਿੱਤਃ ਸਨ੍ ਸ੍ਵਮਾਰ੍ਗੇਣ ਗਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ਫਿਲਿਪਸ਼੍ਚਾਸ੍ਦੋਦ੍ਨਗਰਮ੍ ਉਪਸ੍ਥਾਯ ਤਸ੍ਮਾਤ੍ ਕੈਸਰਿਯਾਨਗਰ ਉਪਸ੍ਥਿਤਿਕਾਲਪਰ੍ੱਯਨਤੰ ਸਰ੍ੱਵਸ੍ਮਿੰਨਗਰੇ ਸੁਸੰਵਾਦੰ ਪ੍ਰਚਾਰਯਨ੍ ਗਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","ਤਤ੍ਕਾਲਪਰ੍ੱਯਨਤੰ ਸ਼ੌਲਃ ਪ੍ਰਭੋਃ ਸ਼ਿਸ਼਼੍ਯਾਣਾਂ ਪ੍ਰਾਤਿਕੂਲ੍ਯੇਨ ਤਾਡਨਾਬਧਯੋਃ ਕਥਾਂ ਨਿਃਸਾਰਯਨ੍ ਮਹਾਯਾਜਕਸ੍ਯ ਸੰਨਿਧਿੰ ਗਤ੍ਵਾ ");
INSERT INTO sanpun_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ਸ੍ਤ੍ਰਿਯੰ ਪੁਰੁਸ਼਼ਞ੍ਚ ਤਨ੍ਮਤਗ੍ਰਾਹਿਣੰ ਯੰ ਕਞ੍ਚਿਤ੍ ਪਸ਼੍ਯਤਿ ਤਾਨ੍ ਧ੍ਰੁʼਤ੍ਵਾ ਬੱਧ੍ਵਾ ਯਿਰੂਸ਼ਾਲਮਮ੍ ਆਨਯਤੀਤ੍ਯਾਸ਼ਯੇਨ ਦੰਮੇਸ਼਼ਕ੍ਨਗਰੀਯੰ ਧਰ੍ੰਮਸਮਾਜਾਨ੍ ਪ੍ਰਤਿ ਪਤ੍ਰੰ ਯਾਚਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","ਗੱਛਨ੍ ਤੁ ਦੰਮੇਸ਼਼ਕ੍ਨਗਰਨਿਕਟ ਉਪਸ੍ਥਿਤਵਾਨ੍; ਤਤੋ(ਅ)ਕਸ੍ਮਾਦ੍ ਆਕਾਸ਼ਾਤ੍ ਤਸ੍ਯ ਚਤੁਰ੍ਦਿਕ੍ਸ਼਼ੁ ਤੇਜਸਃ ਪ੍ਰਕਾਸ਼ਨਾਤ੍ ਸ ਭੂਮਾਵਪਤਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ਪਸ਼੍ਚਾਤ੍ ਹੇ ਸ਼ੌਲ ਹੇ ਸ਼ੌਲ ਕੁਤੋ ਮਾਂ ਤਾਡਯਸਿ? ਸ੍ਵੰ ਪ੍ਰਤਿ ਪ੍ਰੋਕ੍ਤਮ੍ ਏਤੰ ਸ਼ਬ੍ਦੰ ਸ਼੍ਰੁਤ੍ਵਾ ");
INSERT INTO sanpun_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ਸ ਪ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍, ਹੇ ਪ੍ਰਭੋ ਭਵਾਨ੍ ਕਃ? ਤਦਾ ਪ੍ਰਭੁਰਕਥਯਤ੍ ਯੰ ਯੀਸ਼ੁੰ ਤ੍ਵੰ ਤਾਡਯਸਿ ਸ ਏਵਾਹੰ; ਕਣ੍ਟਕਸ੍ਯ ਮੁਖੇ ਪਦਾਘਾਤਕਰਣੰ ਤਵ ਕਸ਼਼੍ਟਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","ਤਦਾ ਕਮ੍ਪਮਾਨੋ ਵਿਸ੍ਮਯਾਪੰਨਸ਼੍ਚ ਸੋਵਦਤ੍ ਹੇ ਪ੍ਰਭੋ ਮਯਾ ਕਿੰ ਕਰ੍ੱਤਵ੍ਯੰ? ਭਵਤ ਇੱਛਾ ਕਾ? ਤਤਃ ਪ੍ਰਭੁਰਾਜ੍ਞਾਪਯਦ੍ ਉੱਥਾਯ ਨਗਰੰ ਗੱਛ ਤਤ੍ਰ ਤ੍ਵਯਾ ਯਤ੍ ਕਰ੍ੱਤਵ੍ਯੰ ਤਦ੍ ਵਦਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","ਤਸ੍ਯ ਸਙ੍ਗਿਨੋ ਲੋਕਾ ਅਪਿ ਤੰ ਸ਼ਬ੍ਦੰ ਸ਼੍ਰੁਤਵਨ੍ਤਃ ਕਿਨ੍ਤੁ ਕਮਪਿ ਨ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਸ੍ਤਬ੍ਧਾਃ ਸਨ੍ਤਃ ਸ੍ਥਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","ਅਨਨ੍ਤਰੰ ਸ਼ੌਲੋ ਭੂਮਿਤ ਉੱਥਾਯ ਚਕ੍ਸ਼਼ੁਸ਼਼ੀ ਉਨ੍ਮੀਲ੍ਯ ਕਮਪਿ ਨ ਦ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍| ਤਦਾ ਲੋਕਾਸ੍ਤਸ੍ਯ ਹਸ੍ਤੌ ਧ੍ਰੁʼਤ੍ਵਾ ਦੰਮੇਸ਼਼ਕ੍ਨਗਰਮ੍ ਆਨਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ਤਤਃ ਸ ਦਿਨਤ੍ਰਯੰ ਯਾਵਦ੍ ਅਨ੍ਧੋ ਭੂਤ੍ਵਾ ਨ ਭੁਕ੍ਤਵਾਨ੍ ਪੀਤਵਾਂਸ਼੍ਚ| ");
INSERT INTO sanpun_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","ਤਦਨਨ੍ਤਰੰ ਪ੍ਰਭੁਸ੍ਤੱਦੰਮੇਸ਼਼ਕ੍ਨਗਰਵਾਸਿਨ ਏਕਸ੍ਮੈ ਸ਼ਿਸ਼਼੍ਯਾਯ ਦਰ੍ਸ਼ਨੰ ਦਤ੍ਵਾ ਆਹੂਤਵਾਨ੍ ਹੇ ਅਨਨਿਯ| ਤਤਃ ਸ ਪ੍ਰਤ੍ਯਵਾਦੀਤ੍, ਹੇ ਪ੍ਰਭੋ ਪਸ਼੍ਯ ਸ਼੍ਰੁʼਣੋਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ਤਦਾ ਪ੍ਰਭੁਸ੍ਤਮਾਜ੍ਞਾਪਯਤ੍ ਤ੍ਵਮੁੱਥਾਯ ਸਰਲਨਾਮਾਨੰ ਮਾਰ੍ਗੰ ਗਤ੍ਵਾ ਯਿਹੂਦਾਨਿਵੇਸ਼ਨੇ ਤਾਰ੍ਸ਼਼ਨਗਰੀਯੰ ਸ਼ੌਲਨਾਮਾਨੰ ਜਨੰ ਗਵੇਸ਼਼ਯਨ੍ ਪ੍ਰੁʼੱਛ; ");
INSERT INTO sanpun_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ਪਸ਼੍ਯ ਸ ਪ੍ਰਾਰ੍ਥਯਤੇ, ਤਥਾ ਅਨਨਿਯਨਾਮਕ ਏਕੋ ਜਨਸ੍ਤਸ੍ਯ ਸਮੀਪਮ੍ ਆਗਤ੍ਯ ਤਸ੍ਯ ਗਾਤ੍ਰੇ ਹਸ੍ਤਾਰ੍ਪਣੰ ਕ੍ਰੁʼਤ੍ਵਾ ਦ੍ਰੁʼਸ਼਼੍ਟਿੰ ਦਦਾਤੀੱਥੰ ਸ੍ਵਪ੍ਨੇ ਦ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","ਤਸ੍ਮਾਦ੍ ਅਨਨਿਯਃ ਪ੍ਰਤ੍ਯਵਦਤ੍ ਹੇ ਪ੍ਰਭੋ ਯਿਰੂਸ਼ਾਲਮਿ ਪਵਿਤ੍ਰਲੋਕਾਨ੍ ਪ੍ਰਤਿ ਸੋ(ਅ)ਨੇਕਹਿੰਸਾਂ ਕ੍ਰੁʼਤਵਾਨ੍; ");
INSERT INTO sanpun_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","ਅਤ੍ਰ ਸ੍ਥਾਨੇ ਚ ਯੇ ਲੋਕਾਸ੍ਤਵ ਨਾਮ੍ਨਿ ਪ੍ਰਾਰ੍ਥਯਨ੍ਤਿ ਤਾਨਪਿ ਬੱਧੁੰ ਸ ਪ੍ਰਧਾਨਯਾਜਕੇਭ੍ਯਃ ਸ਼ਕ੍ਤਿੰ ਪ੍ਰਾਪ੍ਤਵਾਨ੍, ਇਮਾਂ ਕਥਾਮ੍ ਅਹਮ੍ ਅਨੇਕੇਸ਼਼ਾਂ ਮੁਖੇਭ੍ਯਃ ਸ਼੍ਰੁਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","ਕਿਨ੍ਤੁ ਪ੍ਰਭੁਰਕਥਯਤ੍, ਯਾਹਿ ਭਿੰਨਦੇਸ਼ੀਯਲੋਕਾਨਾਂ ਭੂਪਤੀਨਾਮ੍ ਇਸ੍ਰਾਯੇੱਲੋਕਾਨਾਞ੍ਚ ਨਿਕਟੇ ਮਮ ਨਾਮ ਪ੍ਰਚਾਰਯਿਤੁੰ ਸ ਜਨੋ ਮਮ ਮਨੋਨੀਤਪਾਤ੍ਰਮਾਸ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","ਮਮ ਨਾਮਨਿਮਿੱਤਞ੍ਚ ਤੇਨ ਕਿਯਾਨ੍ ਮਹਾਨ੍ ਕ੍ਲੇਸ਼ੋ ਭੋਕ੍ਤਵ੍ਯ ਏਤਤ੍ ਤੰ ਦਰ੍ਸ਼ਯਿਸ਼਼੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ਤਤੋ (ਅ)ਨਨਿਯੋ ਗਤ੍ਵਾ ਗ੍ਰੁʼਹੰ ਪ੍ਰਵਿਸ਼੍ਯ ਤਸ੍ਯ ਗਾਤ੍ਰੇ ਹਸ੍ਤਾਰ੍ਪ੍ਰਣੰ ਕ੍ਰੁʼਤ੍ਵਾ ਕਥਿਤਵਾਨ੍, ਹੇ ਭ੍ਰਾਤਃ ਸ਼ੌਲ ਤ੍ਵੰ ਯਥਾ ਦ੍ਰੁʼਸ਼਼੍ਟਿੰ ਪ੍ਰਾਪ੍ਨੋਸ਼਼ਿ ਪਵਿਤ੍ਰੇਣਾਤ੍ਮਨਾ ਪਰਿਪੂਰ੍ਣੋ ਭਵਸਿ ਚ, ਤਦਰ੍ਥੰ ਤਵਾਗਮਨਕਾਲੇ ਯਃ ਪ੍ਰਭੁਯੀਸ਼ੁਸ੍ਤੁਭ੍ਯੰ ਦਰ੍ਸ਼ਨਮ੍ ਅਦਦਾਤ੍ ਸ ਮਾਂ ਪ੍ਰੇਸ਼਼ਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ਇਤ੍ਯੁਕ੍ਤਮਾਤ੍ਰੇ ਤਸ੍ਯ ਚਕ੍ਸ਼਼ੁਰ੍ਭ੍ਯਾਮ੍ ਮੀਨਸ਼ਲ੍ਕਵਦ੍ ਵਸ੍ਤੁਨਿ ਨਿਰ੍ਗਤੇ ਤਤ੍ਕ੍ਸ਼਼ਣਾਤ੍ ਸ ਪ੍ਰਸੰਨਚਕ੍ਸ਼਼ੁ ਰ੍ਭੂਤ੍ਵਾ ਪ੍ਰੋੱਥਾਯ ਮੱਜਿਤੋ(ਅ)ਭਵਤ੍ ਭੁਕ੍ਤ੍ਵਾ ਪੀਤ੍ਵਾ ਸਬਲੋਭਵੱਚ| ");
INSERT INTO sanpun_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ਤਤਃ ਪਰੰ ਸ਼ੌਲਃ ਸ਼ਿਸ਼਼੍ਯੈਃ ਸਹ ਕਤਿਪਯਦਿਵਸਾਨ੍ ਤਸ੍ਮਿਨ੍ ਦੰਮੇਸ਼਼ਕਨਗਰੇ ਸ੍ਥਿਤ੍ਵਾ(ਅ)ਵਿਲਮ੍ਬੰ ");
INSERT INTO sanpun_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ਸਰ੍ੱਵਭਜਨਭਵਨਾਨਿ ਗਤ੍ਵਾ ਯੀਸ਼ੁਰੀਸ਼੍ਵਰਸ੍ਯ ਪੁਤ੍ਰ ਇਮਾਂ ਕਥਾਂ ਪ੍ਰਾਚਾਰਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","ਤਸ੍ਮਾਤ੍ ਸਰ੍ੱਵੇ ਸ਼੍ਰੋਤਾਰਸ਼੍ਚਮਤ੍ਕ੍ਰੁʼਤ੍ਯ ਕਥਿਤਵਨ੍ਤੋ ਯੋ ਯਿਰੂਸ਼ਾਲਮ੍ਨਗਰ ਏਤੰਨਾਮ੍ਨਾ ਪ੍ਰਾਰ੍ਥਯਿਤ੍ਰੁʼਲੋਕਾਨ੍ ਵਿਨਾਸ਼ਿਤਵਾਨ੍ ਏਵਮ੍ ਏਤਾਦ੍ਰੁʼਸ਼ਲੋਕਾਨ੍ ਬੱਧ੍ਵਾ ਪ੍ਰਧਾਨਯਾਜਕਨਿਕਟੰ ਨਯਤੀਤ੍ਯਾਸ਼ਯਾ ਏਤਤ੍ਸ੍ਥਾਨਮਪ੍ਯਾਗੱਛਤ੍ ਸਏਵ ਕਿਮਯੰ ਨ ਭਵਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","ਕਿਨ੍ਤੁ ਸ਼ੌਲਃ ਕ੍ਰਮਸ਼ ਉਤ੍ਸਾਹਵਾਨ੍ ਭੂਤ੍ਵਾ ਯੀਸ਼ੁਰੀਸ਼੍ਵਰੇਣਾਭਿਸ਼਼ਿਕ੍ਤੋ ਜਨ ਏਤਸ੍ਮਿਨ੍ ਪ੍ਰਮਾਣੰ ਦਤ੍ਵਾ ਦੰਮੇਸ਼਼ਕ੍-ਨਿਵਾਸਿਯਿਹੂਦੀਯਲੋਕਾਨ੍ ਨਿਰੁੱਤਰਾਨ੍ ਅਕਰੋਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ਇੱਥੰ ਬਹੁਤਿਥੇ ਕਾਲੇ ਗਤੇ ਯਿਹੂਦੀਯਲੋਕਾਸ੍ਤੰ ਹਨ੍ਤੁੰ ਮਨ੍ਤ੍ਰਯਾਮਾਸੁਃ ");
INSERT INTO sanpun_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ਕਿਨ੍ਤੁ ਸ਼ੌਲਸ੍ਤੇਸ਼਼ਾਮੇਤਸ੍ਯਾ ਮਨ੍ਤ੍ਰਣਾਯਾ ਵਾਰ੍ੱਤਾਂ ਪ੍ਰਾਪ੍ਤਵਾਨ੍| ਤੇ ਤੰ ਹਨ੍ਤੁੰ ਤੁ ਦਿਵਾਨਿਸ਼ੰ ਗੁਪ੍ਤਾਃ ਸਨ੍ਤੋ ਨਗਰਸ੍ਯ ਦ੍ਵਾਰੇ(ਅ)ਤਿਸ਼਼੍ਠਨ੍; ");
INSERT INTO sanpun_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ਤਸ੍ਮਾਤ੍ ਸ਼ਿਸ਼਼੍ਯਾਸ੍ਤੰ ਨੀਤ੍ਵਾ ਰਾਤ੍ਰੌ ਪਿਟਕੇ ਨਿਧਾਯ ਪ੍ਰਾਚੀਰੇਣਾਵਾਰੋਹਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","ਤਤਃ ਪਰੰ ਸ਼ੌਲੋ ਯਿਰੂਸ਼ਾਲਮੰ ਗਤ੍ਵਾ ਸ਼ਿਸ਼਼੍ਯਗਣੇਨ ਸਾਰ੍ੱਧੰ ਸ੍ਥਾਤੁਮ੍ ਐਹਤ੍, ਕਿਨ੍ਤੁ ਸਰ੍ੱਵੇ ਤਸ੍ਮਾਦਬਿਭਯੁਃ ਸ ਸ਼ਿਸ਼਼੍ਯ ਇਤਿ ਚ ਨ ਪ੍ਰਤ੍ਯਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","ਏਤਸ੍ਮਾਦ੍ ਬਰ੍ਣੱਬਾਸ੍ਤੰ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਪ੍ਰੇਰਿਤਾਨਾਂ ਸਮੀਪਮਾਨੀਯ ਮਾਰ੍ਗਮਧ੍ਯੇ ਪ੍ਰਭੁਃ ਕਥੰ ਤਸ੍ਮੈ ਦਰ੍ਸ਼ਨੰ ਦੱਤਵਾਨ੍ ਯਾਃ ਕਥਾਸ਼੍ਚ ਕਥਿਤਵਾਨ੍ ਸ ਚ ਯਥਾਕ੍ਸ਼਼ੋਭਃ ਸਨ੍ ਦੰਮੇਸ਼਼ਕ੍ਨਗਰੇ ਯੀਸ਼ੋ ਰ੍ਨਾਮ ਪ੍ਰਾਚਾਰਯਤ੍ ਏਤਾਨ੍ ਸਰ੍ੱਵਵ੍ਰੁʼੱਤਾਨ੍ਤਾਨ੍ ਤਾਨ੍ ਜ੍ਞਾਪਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","ਤਤਃ ਸ਼ੌਲਸ੍ਤੈਃ ਸਹ ਯਿਰੂਸ਼ਾਲਮਿ ਕਾਲੰ ਯਾਪਯਨ੍ ਨਿਰ੍ਭਯੰ ਪ੍ਰਭੋ ਰ੍ਯੀਸ਼ੋ ਰ੍ਨਾਮ ਪ੍ਰਾਚਾਰਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ਤਸ੍ਮਾਦ੍ ਅਨ੍ਯਦੇਸ਼ੀਯਲੋਕੈਃ ਸਾਰ੍ੱਧੰ ਵਿਵਾਦਸ੍ਯੋਪਸ੍ਥਿਤਤ੍ਵਾਤ੍ ਤੇ ਤੰ ਹਨ੍ਤੁਮ੍ ਅਚੇਸ਼਼੍ਟਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","ਕਿਨ੍ਤੁ ਭ੍ਰਾਤ੍ਰੁʼਗਣਸ੍ਤੱਜ੍ਞਾਤ੍ਵਾ ਤੰ ਕੈਸਰਿਯਾਨਗਰੰ ਨੀਤ੍ਵਾ ਤਾਰ੍ਸ਼਼ਨਗਰੰ ਪ੍ਰੇਸ਼਼ਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ਇੱਥੰ ਸਤਿ ਯਿਹੂਦਿਯਾਗਾਲੀਲ੍ਸ਼ੋਮਿਰੋਣਦੇਸ਼ੀਯਾਃ ਸਰ੍ੱਵਾ ਮਣ੍ਡਲ੍ਯੋ ਵਿਸ਼੍ਰਾਮੰ ਪ੍ਰਾਪ੍ਤਾਸ੍ਤਤਸ੍ਤਾਸਾਂ ਨਿਸ਼਼੍ਠਾਭਵਤ੍ ਪ੍ਰਭੋ ਰ੍ਭਿਯਾ ਪਵਿਤ੍ਰਸ੍ਯਾਤ੍ਮਨਃ ਸਾਨ੍ਤ੍ਵਨਯਾ ਚ ਕਾਲੰ ਕ੍ਸ਼਼ੇਪਯਿਤ੍ਵਾ ਬਹੁਸੰਖ੍ਯਾ ਅਭਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","ਤਤਃ ਪਰੰ ਪਿਤਰਃ ਸ੍ਥਾਨੇ ਸ੍ਥਾਨੇ ਭ੍ਰਮਿਤ੍ਵਾ ਸ਼ੇਸ਼਼ੇ ਲੋਦ੍ਨਗਰਨਿਵਾਸਿਪਵਿਤ੍ਰਲੋਕਾਨਾਂ ਸਮੀਪੇ ਸ੍ਥਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ਤਦਾ ਤਤ੍ਰ ਪਕ੍ਸ਼਼ਾਘਾਤਵ੍ਯਾਧਿਨਾਸ਼਼੍ਟੌ ਵਤ੍ਸਰਾਨ੍ ਸ਼ੱਯਾਗਤਮ੍ ਐਨੇਯਨਾਮਾਨੰ ਮਨੁਸ਼਼੍ਯੰ ਸਾਕ੍ਸ਼਼ਤ੍ ਪ੍ਰਾਪ੍ਯ ਤਮਵਦਤ੍, ");
INSERT INTO sanpun_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ਹੇ ਐਨੇਯ ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟਸ੍ਤ੍ਵਾਂ ਸ੍ਵਸ੍ਥਮ੍ ਅਕਾਰ੍ਸ਼਼ੀਤ੍, ਤ੍ਵਮੁੱਥਾਯ ਸ੍ਵਸ਼ੱਯਾਂ ਨਿਕ੍ਸ਼਼ਿਪ, ਇਤ੍ਯੁਕ੍ਤਮਾਤ੍ਰੇ ਸ ਉਦਤਿਸ਼਼੍ਠਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ਏਤਾਦ੍ਰੁʼਸ਼ੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਲੋਦ੍ਸ਼ਾਰੋਣਨਿਵਾਸਿਨੋ ਲੋਕਾਃ ਪ੍ਰਭੁੰ ਪ੍ਰਤਿ ਪਰਾਵਰ੍ੱਤਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","ਅਪਰਞ੍ਚ ਭਿਕ੍ਸ਼਼ਾਦਾਨਾਦਿਸ਼਼ੁ ਨਾਨਕ੍ਰਿਯਾਸੁ ਨਿਤ੍ਯੰ ਪ੍ਰਵ੍ਰੁʼੱਤਾ ਯਾ ਯਾਫੋਨਗਰਨਿਵਾਸਿਨੀ ਟਾਬਿਥਾਨਾਮਾ ਸ਼ਿਸ਼਼੍ਯਾ ਯਾਂ ਦਰ੍ੱਕਾਂ ਅਰ੍ਥਾਦ੍ ਹਰਿਣੀਮਯੁਕ੍ਤ੍ਵਾ ਆਹ੍ਵਯਨ੍ ਸਾ ਨਾਰੀ ");
INSERT INTO sanpun_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","ਤਸ੍ਮਿਨ੍ ਸਮਯੇ ਰੁਗ੍ਨਾ ਸਤੀ ਪ੍ਰਾਣਾਨ੍ ਅਤ੍ਯਜਤ੍, ਤਤੋ ਲੋਕਾਸ੍ਤਾਂ ਪ੍ਰਕ੍ਸ਼਼ਾਲ੍ਯੋਪਰਿਸ੍ਥਪ੍ਰਕੋਸ਼਼੍ਠੇ ਸ਼ਾਯਯਿਤ੍ਵਾਸ੍ਥਾਪਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","ਲੋਦ੍ਨਗਰੰ ਯਾਫੋਨਗਰਸ੍ਯ ਸਮੀਪਸ੍ਥੰ ਤਸ੍ਮਾੱਤਤ੍ਰ ਪਿਤਰ ਆਸ੍ਤੇ, ਇਤਿ ਵਾਰ੍ੱਤਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਤੂਰ੍ਣੰ ਤਸ੍ਯਾਗਮਨਾਰ੍ਥੰ ਤਸ੍ਮਿਨ੍ ਵਿਨਯਮੁਕ੍ਤ੍ਵਾ ਸ਼ਿਸ਼਼੍ਯਗਣੋ ਦ੍ਵੌ ਮਨੁਜੌ ਪ੍ਰੇਸ਼਼ਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","ਤਸ੍ਮਾਤ੍ ਪਿਤਰ ਉੱਥਾਯ ਤਾਭ੍ਯਾਂ ਸਾਰ੍ੱਧਮ੍ ਆਗੱਛਤ੍, ਤਤ੍ਰ ਤਸ੍ਮਿਨ੍ ਉਪਸ੍ਥਿਤ ਉਪਰਿਸ੍ਥਪ੍ਰਕੋਸ਼਼੍ਠੰ ਸਮਾਨੀਤੇ ਚ ਵਿਧਵਾਃ ਸ੍ਵਾਭਿਃ ਸਹ ਸ੍ਥਿਤਿਕਾਲੇ ਦਰ੍ੱਕਯਾ ਕ੍ਰੁʼਤਾਨਿ ਯਾਨ੍ਯੁੱਤਰੀਯਾਣਿ ਪਰਿਧੇਯਾਨਿ ਚ ਤਾਨਿ ਸਰ੍ੱਵਾਣਿ ਤੰ ਦਰ੍ਸ਼ਯਿਤ੍ਵਾ ਰੁਦਤ੍ਯਸ਼੍ਚਤਸ੍ਰੁʼਸ਼਼ੁ ਦਿਕ੍ਸ਼਼੍ਵਤਿਸ਼਼੍ਠਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","ਕਿਨ੍ਤੁ ਪਿਤਰਸ੍ਤਾਃ ਸਰ੍ੱਵਾ ਬਹਿਃ ਕ੍ਰੁʼਤ੍ਵਾ ਜਾਨੁਨੀ ਪਾਤਯਿਤ੍ਵਾ ਪ੍ਰਾਰ੍ਥਿਤਵਾਨ੍; ਪਸ਼੍ਚਾਤ੍ ਸ਼ਵੰ ਪ੍ਰਤਿ ਦ੍ਰੁʼਸ਼਼੍ਟਿੰ ਕ੍ਰੁʼਤ੍ਵਾ ਕਥਿਤਵਾਨ੍, ਹੇ ਟਾਬੀਥੇ ਤ੍ਵਮੁੱਤਿਸ਼਼੍ਠ, ਇਤਿ ਵਾਕ੍ਯ ਉਕ੍ਤੇ ਸਾ ਸ੍ਤ੍ਰੀ ਚਕ੍ਸ਼਼ੁਸ਼਼ੀ ਪ੍ਰੋਨ੍ਮੀਲ੍ਯ ਪਿਤਰਮ੍ ਅਵਲੋਕ੍ਯੋੱਥਾਯੋਪਾਵਿਸ਼ਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","ਤਤਃ ਪਿਤਰਸ੍ਤਸ੍ਯਾਃ ਕਰੌ ਧ੍ਰੁʼਤ੍ਵਾ ਉੱਤੋਲ੍ਯ ਪਵਿਤ੍ਰਲੋਕਾਨ੍ ਵਿਧਵਾਸ਼੍ਚਾਹੂਯ ਤੇਸ਼਼ਾਂ ਨਿਕਟੇ ਸਜੀਵਾਂ ਤਾਂ ਸਮਾਰ੍ਪਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ਏਸ਼਼ਾ ਕਥਾ ਸਮਸ੍ਤਯਾਫੋਨਗਰੰ ਵ੍ਯਾਪ੍ਤਾ ਤਸ੍ਮਾਦ੍ ਅਨੇਕੇ ਲੋਕਾਃ ਪ੍ਰਭੌ ਵ੍ਯਸ਼੍ਵਸਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","ਅਪਰਞ੍ਚ ਪਿਤਰਸ੍ਤਦ੍ਯਾਫੋਨਗਰੀਯਸ੍ਯ ਕਸ੍ਯਚਿਤ੍ ਸ਼ਿਮੋੰਨਾਮ੍ਨਸ਼੍ਚਰ੍ੰਮਕਾਰਸ੍ਯ ਗ੍ਰੁʼਹੇ ਬਹੁਦਿਨਾਨਿ ਨ੍ਯਵਸਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","ਕੈਸਰਿਯਾਨਗਰ ਇਤਾਲਿਯਾਖ੍ਯਸੈਨ੍ਯਾਨ੍ਤਰ੍ਗਤਃ ਕਰ੍ਣੀਲਿਯਨਾਮਾ ਸੇਨਾਪਤਿਰਾਸੀਤ੍ ");
INSERT INTO sanpun_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ਸ ਸਪਰਿਵਾਰੋ ਭਕ੍ਤ ਈਸ਼੍ਵਰਪਰਾਯਣਸ਼੍ਚਾਸੀਤ੍; ਲੋਕੇਭ੍ਯੋ ਬਹੂਨਿ ਦਾਨਾਦੀਨਿ ਦਤ੍ਵਾ ਨਿਰਨ੍ਤਰਮ੍ ਈਸ਼੍ਵਰੇ ਪ੍ਰਾਰ੍ਥਯਾਞ੍ਚਕ੍ਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ਏਕਦਾ ਤ੍ਰੁʼਤੀਯਪ੍ਰਹਰਵੇਲਾਯਾਂ ਸ ਦ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍ ਈਸ਼੍ਵਰਸ੍ਯੈਕੋ ਦੂਤਃ ਸਪ੍ਰਕਾਸ਼ੰ ਤਤ੍ਸਮੀਪਮ੍ ਆਗਤ੍ਯ ਕਥਿਤਵਾਨ੍, ਹੇ ਕਰ੍ਣੀਲਿਯ| ");
INSERT INTO sanpun_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","ਕਿਨ੍ਤੁ ਸ ਤੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਭੀਤੋ(ਅ)ਕਥਯਤ੍, ਹੇ ਪ੍ਰਭੋ ਕਿੰ? ਤਦਾ ਤਮਵਦਤ੍ ਤਵ ਪ੍ਰਾਰ੍ਥਨਾ ਦਾਨਾਦਿ ਚ ਸਾਕ੍ਸ਼਼ਿਸ੍ਵਰੂਪੰ ਭੂਤ੍ਵੇਸ਼੍ਵਰਸ੍ਯ ਗੋਚਰਮਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ਇਦਾਨੀਂ ਯਾਫੋਨਗਰੰ ਪ੍ਰਤਿ ਲੋਕਾਨ੍ ਪ੍ਰੇਸ਼਼੍ਯ ਸਮੁਦ੍ਰਤੀਰੇ ਸ਼ਿਮੋੰਨਾਮ੍ਨਸ਼੍ਚਰ੍ੰਮਕਾਰਸ੍ਯ ਗ੍ਰੁʼਹੇ ਪ੍ਰਵਾਸਕਾਰੀ ਪਿਤਰਨਾਮ੍ਨਾ ਵਿਖ੍ਯਾਤੋ ਯਃ ਸ਼ਿਮੋਨ੍ ਤਮ੍ ਆਹ੍ਵਾਯਯ; ");
INSERT INTO sanpun_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ਤਸ੍ਮਾਤ੍ ਤ੍ਵਯਾ ਯਦ੍ਯਤ੍ ਕਰ੍ੱਤਵ੍ਯੰ ਤੱਤਤ੍ ਸ ਵਦਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ਇਤ੍ਯੁਪਦਿਸ਼੍ਯ ਦੂਤੇ ਪ੍ਰਸ੍ਥਿਤੇ ਸਤਿ ਕਰ੍ਣੀਲਿਯਃ ਸ੍ਵਗ੍ਰੁʼਹਸ੍ਥਾਨਾਂ ਦਾਸਾਨਾਂ ਦ੍ਵੌ ਜਨੌ ਨਿਤ੍ਯੰ ਸ੍ਵਸਙ੍ਗਿਨਾਂ ਸੈਨ੍ਯਾਨਾਮ੍ ਏਕਾਂ ਭਕ੍ਤਸੇਨਾਞ੍ਚਾਹੂਯ ");
INSERT INTO sanpun_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ਸਕਲਮੇਤੰ ਵ੍ਰੁʼੱਤਾਨ੍ਤੰ ਵਿਜ੍ਞਾਪ੍ਯ ਯਾਫੋਨਗਰੰ ਤਾਨ੍ ਪ੍ਰਾਹਿਣੋਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","ਪਰਸ੍ਮਿਨ੍ ਦਿਨੇ ਤੇ ਯਾਤ੍ਰਾਂ ਕ੍ਰੁʼਤ੍ਵਾ ਯਦਾ ਨਗਰਸ੍ਯ ਸਮੀਪ ਉਪਾਤਿਸ਼਼੍ਠਨ੍, ਤਦਾ ਪਿਤਰੋ ਦ੍ਵਿਤੀਯਪ੍ਰਹਰਵੇਲਾਯਾਂ ਪ੍ਰਾਰ੍ਥਯਿਤੁੰ ਗ੍ਰੁʼਹਪ੍ਰੁʼਸ਼਼੍ਠਮ੍ ਆਰੋਹਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ਏਤਸ੍ਮਿਨ੍ ਸਮਯੇ ਕ੍ਸ਼਼ੁਧਾਰ੍ੱਤਃ ਸਨ੍ ਕਿਞ੍ਚਿਦ੍ ਭੋਕ੍ਤੁਮ੍ ਐੱਛਤ੍ ਕਿਨ੍ਤੁ ਤੇਸ਼਼ਾਮ੍ ਅੰਨਾਸਾਦਨਸਮਯੇ ਸ ਮੂਰ੍ੱਛਿਤਃ ਸੰਨਪਤਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ਤਤੋ ਮੇਘਦ੍ਵਾਰੰ ਮੁਕ੍ਤੰ ਚਤੁਰ੍ਭਿਃ ਕੋਣੈ ਰ੍ਲਮ੍ਬਿਤੰ ਬ੍ਰੁʼਹਦ੍ਵਸ੍ਤ੍ਰਮਿਵ ਕਿਞ੍ਚਨ ਭਾਜਨਮ੍ ਆਕਾਸ਼ਾਤ੍ ਪ੍ਰੁʼਥਿਵੀਮ੍ ਅਵਾਰੋਹਤੀਤਿ ਦ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ਤਨ੍ਮਧ੍ਯੇ ਨਾਨਪ੍ਰਕਾਰਾ ਗ੍ਰਾਮ੍ਯਵਨ੍ਯਪਸ਼ਵਃ ਖੇਚਰੋਰੋਗਾਮਿਪ੍ਰਭ੍ਰੁʼਤਯੋ ਜਨ੍ਤਵਸ਼੍ਚਾਸਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","ਅਨਨ੍ਤਰੰ ਹੇ ਪਿਤਰ ਉੱਥਾਯ ਹਤ੍ਵਾ ਭੁੰਕ੍ਸ਼਼੍ਵ ਤਮ੍ਪ੍ਰਤੀਯੰ ਗਗਣੀਯਾ ਵਾਣੀ ਜਾਤਾ| ");
INSERT INTO sanpun_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","ਤਦਾ ਪਿਤਰਃ ਪ੍ਰਤ੍ਯਵਦਤ੍, ਹੇ ਪ੍ਰਭੋ ਈਦ੍ਰੁʼਸ਼ੰ ਮਾ ਭਵਤੁ, ਅਹਮ੍ ਏਤਤ੍ ਕਾਲੰ ਯਾਵਤ੍ ਨਿਸ਼਼ਿੱਧਮ੍ ਅਸ਼ੁਚਿ ਵਾ ਦ੍ਰਵ੍ਯੰ ਕਿਞ੍ਚਿਦਪਿ ਨ ਭੁਕ੍ਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ਤਤਃ ਪੁਨਰਪਿ ਤਾਦ੍ਰੁʼਸ਼ੀ ਵਿਹਯਸੀਯਾ ਵਾਣੀ ਜਾਤਾ ਯਦ੍ ਈਸ਼੍ਵਰਃ ਸ਼ੁਚਿ ਕ੍ਰੁʼਤਵਾਨ੍ ਤਤ੍ ਤ੍ਵੰ ਨਿਸ਼਼ਿੱਧੰ ਨ ਜਾਨੀਹਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ਇੱਥੰ ਤ੍ਰਿਃ ਸਤਿ ਤਤ੍ ਪਾਤ੍ਰੰ ਪੁਨਰਾਕ੍ਰੁʼਸ਼਼੍ਟੰ ਆਕਾਸ਼ਮ੍ ਅਗੱਛਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ਤਤਃ ਪਰੰ ਯਦ੍ ਦਰ੍ਸ਼ਨੰ ਪ੍ਰਾਪ੍ਤਵਾਨ੍ ਤਸ੍ਯ ਕੋ ਭਾਵ ਇਤ੍ਯਤ੍ਰ ਪਿਤਰੋ ਮਨਸਾ ਸਨ੍ਦੇਗ੍ਧਿ, ਏਤਸ੍ਮਿਨ੍ ਸਮਯੇ ਕਰ੍ਣੀਲਿਯਸ੍ਯ ਤੇ ਪ੍ਰੇਸ਼਼ਿਤਾ ਮਨੁਸ਼਼੍ਯਾ ਦ੍ਵਾਰਸ੍ਯ ਸੰਨਿਧਾਵੁਪਸ੍ਥਾਯ, ");
INSERT INTO sanpun_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ਸ਼ਿਮੋਨੋ ਗ੍ਰੁʼਹਮਨ੍ਵਿੱਛਨ੍ਤਃ ਸਮ੍ਪ੍ਰੁʼਛ੍ਯਾਹੂਯ ਕਥਿਤਵਨ੍ਤਃ ਪਿਤਰਨਾਮ੍ਨਾ ਵਿਖ੍ਯਾਤੋ ਯਃ ਸ਼ਿਮੋਨ੍ ਸ ਕਿਮਤ੍ਰ ਪ੍ਰਵਸਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","ਯਦਾ ਪਿਤਰਸ੍ਤੱਦਰ੍ਸ਼ਨਸ੍ਯ ਭਾਵੰ ਮਨਸਾਨ੍ਦੋਲਯਤਿ ਤਦਾਤ੍ਮਾ ਤਮਵਦਤ੍, ਪਸ਼੍ਯ ਤ੍ਰਯੋ ਜਨਾਸ੍ਤ੍ਵਾਂ ਮ੍ਰੁʼਗਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ਤ੍ਵਮ੍ ਉੱਥਾਯਾਵਰੁਹ੍ਯ ਨਿਃਸਨ੍ਦੇਹੰ ਤੈਃ ਸਹ ਗੱਛ ਮਯੈਵ ਤੇ ਪ੍ਰੇਸ਼਼ਿਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","ਤਸ੍ਮਾਤ੍ ਪਿਤਰੋ(ਅ)ਵਰੁਹ੍ਯ ਕਰ੍ਣੀਲਿਯਪ੍ਰੇਰਿਤਲੋਕਾਨਾਂ ਨਿਕਟਮਾਗਤ੍ਯ ਕਥਿਤਵਾਨ੍ ਪਸ਼੍ਯਤ ਯੂਯੰ ਯੰ ਮ੍ਰੁʼਗਯਧ੍ਵੇ ਸ ਜਨੋਹੰ, ਯੂਯੰ ਕਿੰਨਿਮਿੱਤਮ੍ ਆਗਤਾਃ? ");
INSERT INTO sanpun_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ਤਤਸ੍ਤੇ ਪ੍ਰਤ੍ਯਵਦਨ੍ ਕਰ੍ਣੀਲਿਯਨਾਮਾ ਸ਼ੁੱਧਸੱਤ੍ਵ ਈਸ਼੍ਵਰਪਰਾਯਣੋ ਯਿਹੂਦੀਯਦੇਸ਼ਸ੍ਥਾਨਾਂ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਸੰਨਿਧੌ ਸੁਖ੍ਯਾਤ੍ਯਾਪੰਨ ਏਕਃ ਸੇਨਾਪਤਿ ਰ੍ਨਿਜਗ੍ਰੁʼਹੰ ਤ੍ਵਾਮਾਹੂਯ ਨੇਤੁੰ ਤ੍ਵੱਤਃ ਕਥਾ ਸ਼੍ਰੋਤੁਞ੍ਚ ਪਵਿਤ੍ਰਦੂਤੇਨ ਸਮਾਦਿਸ਼਼੍ਟਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","ਤਦਾ ਪਿਤਰਸ੍ਤਾਨਭ੍ਯਨ੍ਤਰੰ ਨੀਤ੍ਵਾ ਤੇਸ਼਼ਾਮਾਤਿਥ੍ਯੰ ਕ੍ਰੁʼਤਵਾਨ੍, ਪਰੇ(ਅ)ਹਨਿ ਤੈਃ ਸਾਰ੍ੱਧੰ ਯਾਤ੍ਰਾਮਕਰੋਤ੍, ਯਾਫੋਨਿਵਾਸਿਨਾਂ ਭ੍ਰਾਤ੍ਰੁʼਣਾਂ ਕਿਯਨ੍ਤੋ ਜਨਾਸ਼੍ਚ ਤੇਨ ਸਹ ਗਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","ਪਰਸ੍ਮਿਨ੍ ਦਿਵਸੇ ਕੈਸਰਿਯਾਨਗਰਮਧ੍ਯਪ੍ਰਵੇਸ਼ਸਮਯੇ ਕਰ੍ਣੀਲਿਯੋ ਜ੍ਞਾਤਿਬਨ੍ਧੂਨ੍ ਆਹੂਯਾਨੀਯ ਤਾਨ੍ ਅਪੇਕ੍ਸ਼਼੍ਯ ਸ੍ਥਿਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","ਪਿਤਰੇ ਗ੍ਰੁʼਹ ਉਪਸ੍ਥਿਤੇ ਕਰ੍ਣੀਲਿਯਸ੍ਤੰ ਸਾਕ੍ਸ਼਼ਾਤ੍ਕ੍ਰੁʼਤ੍ਯ ਚਰਣਯੋਃ ਪਤਿਤ੍ਵਾ ਪ੍ਰਾਣਮਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","ਪਿਤਰਸ੍ਤਮੁੱਥਾਪ੍ਯ ਕਥਿਤਵਾਨ੍, ਉੱਤਿਸ਼਼੍ਠਾਹਮਪਿ ਮਾਨੁਸ਼਼ਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ਤਦਾ ਕਰ੍ਣੀਲਿਯੇਨ ਸਾਕਮ੍ ਆਲਪਨ੍ ਗ੍ਰੁʼਹੰ ਪ੍ਰਾਵਿਸ਼ਤ੍ ਤਨ੍ਮਧ੍ਯੇ ਚ ਬਹੁਲੋਕਾਨਾਂ ਸਮਾਗਮੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਤਾਨ੍ ਅਵਦਤ੍, ");
INSERT INTO sanpun_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ਅਨ੍ਯਜਾਤੀਯਲੋਕੈਃ ਮਹਾਲਪਨੰ ਵਾ ਤੇਸ਼਼ਾਂ ਗ੍ਰੁʼਹਮਧ੍ਯੇ ਪ੍ਰਵੇਸ਼ਨੰ ਯਿਹੂਦੀਯਾਨਾਂ ਨਿਸ਼਼ਿੱਧਮ੍ ਅਸ੍ਤੀਤਿ ਯੂਯਮ੍ ਅਵਗੱਛਥ; ਕਿਨ੍ਤੁ ਕਮਪਿ ਮਾਨੁਸ਼਼ਮ੍ ਅਵ੍ਯਵਹਾਰ੍ੱਯਮ੍ ਅਸ਼ੁਚਿੰ ਵਾ ਜ੍ਞਾਤੁੰ ਮਮ ਨੋਚਿਤਮ੍ ਇਤਿ ਪਰਮੇਸ਼੍ਵਰੋ ਮਾਂ ਜ੍ਞਾਪਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ਇਤਿ ਹੇਤੋਰਾਹ੍ਵਾਨਸ਼੍ਰਵਣਮਾਤ੍ਰਾਤ੍ ਕਾਞ੍ਚਨਾਪੱਤਿਮ੍ ਅਕ੍ਰੁʼਤ੍ਵਾ ਯੁਸ਼਼੍ਮਾਕੰ ਸਮੀਪਮ੍ ਆਗਤੋਸ੍ਮਿ; ਪ੍ਰੁʼੱਛਾਮਿ ਯੂਯੰ ਕਿੰਨਿਮਿੱਤੰ ਮਾਮ੍ ਆਹੂਯਤ? ");
INSERT INTO sanpun_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","ਤਦਾ ਕਰ੍ਣੀਲਿਯਃ ਕਥਿਤਵਾਨ੍, ਅਦ੍ਯ ਚਤ੍ਵਾਰਿ ਦਿਨਾਨਿ ਜਾਤਾਨਿ ਏਤਾਵਦ੍ਵੇਲਾਂ ਯਾਵਦ੍ ਅਹਮ੍ ਅਨਾਹਾਰ ਆਸਨ੍ ਤਤਸ੍ਤ੍ਰੁʼਤੀਯਪ੍ਰਹਰੇ ਸਤਿ ਗ੍ਰੁʼਹੇ ਪ੍ਰਾਰ੍ਥਨਸਮਯੇ ਤੇਜੋਮਯਵਸ੍ਤ੍ਰਭ੍ਰੁʼਦ੍ ਏਕੋ ਜਨੋ ਮਮ ਸਮਕ੍ਸ਼਼ੰ ਤਿਸ਼਼੍ਠਨ੍ ਏਤਾਂ ਕਥਾਮ੍ ਅਕਥਯਤ੍, ");
INSERT INTO sanpun_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ਹੇ ਕਰ੍ਣੀਲਿਯ ਤ੍ਵਦੀਯਾ ਪ੍ਰਾਰ੍ਥਨਾ ਈਸ਼੍ਵਰਸ੍ਯ ਕਰ੍ਣਗੋਚਰੀਭੂਤਾ ਤਵ ਦਾਨਾਦਿ ਚ ਸਾਕ੍ਸ਼਼ਿਸ੍ਵਰੂਪੰ ਭੂਤ੍ਵਾ ਤਸ੍ਯ ਦ੍ਰੁʼਸ਼਼੍ਟਿਗੋਚਰਮਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ਅਤੋ ਯਾਫੋਨਗਰੰ ਪ੍ਰਤਿ ਲੋਕਾਨ੍ ਪ੍ਰਹਿਤ੍ਯ ਤਤ੍ਰ ਸਮੁਦ੍ਰਤੀਰੇ ਸ਼ਿਮੋੰਨਾਮ੍ਨਃ ਕਸ੍ਯਚਿੱਚਰ੍ੰਮਕਾਰਸ੍ਯ ਗ੍ਰੁʼਹੇ ਪ੍ਰਵਾਸਕਾਰੀ ਪਿਤਰਨਾਮ੍ਨਾ ਵਿਖ੍ਯਾਤੋ ਯਃ ਸ਼ਿਮੋਨ੍ ਤਮਾਹੂाਯਯ; ਤਤਃ ਸ ਆਗਤ੍ਯ ਤ੍ਵਾਮ੍ ਉਪਦੇਕ੍ਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ਇਤਿ ਕਾਰਣਾਤ੍ ਤਤ੍ਕ੍ਸ਼਼ਣਾਤ੍ ਤਵ ਨਿਕਟੇ ਲੋਕਾਨ੍ ਪ੍ਰੇਸ਼਼ਿਤਵਾਨ੍, ਤ੍ਵਮਾਗਤਵਾਨ੍ ਇਤਿ ਭਦ੍ਰੰ ਕ੍ਰੁʼਤਵਾਨ੍| ਈਸ਼੍ਵਰੋ ਯਾਨ੍ਯਾਖ੍ਯਾਨਾਨਿ ਕਥਯਿਤੁਮ੍ ਆਦਿਸ਼ਤ੍ ਤਾਨਿ ਸ਼੍ਰੋਤੁੰ ਵਯੰ ਸਰ੍ੱਵੇ ਸਾਮ੍ਪ੍ਰਤਮ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਸਾਕ੍ਸ਼਼ਾਦ੍ ਉਪਸ੍ਥਿਤਾਃ ਸ੍ਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","ਤਦਾ ਪਿਤਰ ਇਮਾਂ ਕਥਾਂ ਕਥਯਿਤੁਮ੍ ਆਰਬ੍ਧਵਾਨ੍, ਈਸ਼੍ਵਰੋ ਮਨੁਸ਼਼੍ਯਾਣਾਮ੍ ਅਪਕ੍ਸ਼਼ਪਾਤੀ ਸਨ੍ ");
INSERT INTO sanpun_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ਯਸ੍ਯ ਕਸ੍ਯਚਿਦ੍ ਦੇਸ਼ਸ੍ਯ ਯੋ ਲੋਕਾਸ੍ਤਸ੍ਮਾਦ੍ਭੀਤ੍ਵਾ ਸਤ੍ਕਰ੍ੰਮ ਕਰੋਤਿ ਸ ਤਸ੍ਯ ਗ੍ਰਾਹ੍ਯੋ ਭਵਤਿ, ਏਤਸ੍ਯ ਨਿਸ਼੍ਚਯਮ੍ ਉਪਲਬ੍ਧਵਾਨਹਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਪ੍ਰਭੁ ਰ੍ਯੋ ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟਸ੍ਤੇਨ ਈਸ਼੍ਵਰ ਇਸ੍ਰਾਯੇਲ੍ਵੰਸ਼ਾਨਾਂ ਨਿਕਟੇ ਸੁਸੰਵਾਦੰ ਪ੍ਰੇਸ਼਼੍ਯ ਸੰਮੇਲਨਸ੍ਯ ਯੰ ਸੰਵਾਦੰ ਪ੍ਰਾਚਾਰਯਤ੍ ਤੰ ਸੰਵਾਦੰ ਯੂਯੰ ਸ਼੍ਰੁਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","ਯਤੋ ਯੋਹਨਾ ਮੱਜਨੇ ਪ੍ਰਚਾਰਿਤੇ ਸਤਿ ਸ ਗਾਲੀਲਦੇਸ਼ਮਾਰਭ੍ਯ ਸਮਸ੍ਤਯਿਹੂਦੀਯਦੇਸ਼ੰ ਵ੍ਯਾਪ੍ਨੋਤ੍; ");
INSERT INTO sanpun_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ਫਲਤ ਈਸ਼੍ਵਰੇਣ ਪਵਿਤ੍ਰੇਣਾਤ੍ਮਨਾ ਸ਼ਕ੍ਤ੍ਯਾ ਚਾਭਿਸ਼਼ਿਕ੍ਤੋ ਨਾਸਰਤੀਯਯੀਸ਼ੁਃ ਸ੍ਥਾਨੇ ਸ੍ਥਾਨੇ ਭ੍ਰਮਨ੍ ਸੁਕ੍ਰਿਯਾਂ ਕੁਰ੍ੱਵਨ੍ ਸ਼ੈਤਾਨਾ ਕ੍ਲਿਸ਼਼੍ਟਾਨ੍ ਸਰ੍ੱਵਲੋਕਾਨ੍ ਸ੍ਵਸ੍ਥਾਨ੍ ਅਕਰੋਤ੍, ਯਤ ਈਸ਼੍ਵਰਸ੍ਤਸ੍ਯ ਸਹਾਯ ਆਸੀਤ੍; ");
INSERT INTO sanpun_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","ਵਯਞ੍ਚ ਯਿਹੂਦੀਯਦੇਸ਼ੇ ਯਿਰੂਸ਼ਾਲਮ੍ਨਗਰੇ ਚ ਤੇਨ ਕ੍ਰੁʼਤਾਨਾਂ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਕਰ੍ੰਮਣਾਂ ਸਾਕ੍ਸ਼਼ਿਣੋ ਭਵਾਮਃ| ਲੋਕਾਸ੍ਤੰ ਕ੍ਰੁਸ਼ੇ ਵਿੱਧ੍ਵਾ ਹਤਵਨ੍ਤਃ, ");
INSERT INTO sanpun_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ਕਿਨ੍ਤੁ ਤ੍ਰੁʼਤੀਯਦਿਵਸੇ ਈਸ਼੍ਵਰਸ੍ਤਮੁੱਥਾਪ੍ਯ ਸਪ੍ਰਕਾਸ਼ਮ੍ ਅਦਰ੍ਸ਼ਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ਸਰ੍ੱਵਲੋਕਾਨਾਂ ਨਿਕਟ ਇਤਿ ਨ ਹਿ, ਕਿਨ੍ਤੁ ਤਸ੍ਮਿਨ੍ ਸ਼੍ਮਸ਼ਾਨਾਦੁੱਥਿਤੇ ਸਤਿ ਤੇਨ ਸਾਰ੍ੱਧੰ ਭੋਜਨੰ ਪਾਨਞ੍ਚ ਕ੍ਰੁʼਤਵਨ੍ਤ ਏਤਾਦ੍ਰੁʼਸ਼ਾ ਈਸ਼੍ਵਰਸ੍ਯ ਮਨੋਨੀਤਾਃ ਸਾਕ੍ਸ਼਼ਿਣੋ ਯੇ ਵਯਮ੍ ਅਸ੍ਮਾਕੰ ਨਿਕਟੇ ਤਮਦਰ੍ਸ਼ਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ਜੀਵਿਤਮ੍ਰੁʼਤੋਭਯਲੋਕਾਨਾਂ ਵਿਚਾਰੰ ਕਰ੍ੱਤੁਮ੍ ਈਸ਼੍ਵਰੋ ਯੰ ਨਿਯੁਕ੍ਤਵਾਨ੍ ਸ ਏਵ ਸ ਜਨਃ, ਇਮਾਂ ਕਥਾਂ ਪ੍ਰਚਾਰਯਿਤੁੰ ਤਸ੍ਮਿਨ੍ ਪ੍ਰਮਾਣੰ ਦਾਤੁਞ੍ਚ ਸੋ(ਅ)ਸ੍ਮਾਨ੍ ਆਜ੍ਞਾਪਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ਯਸ੍ਤਸ੍ਮਿਨ੍ ਵਿਸ਼੍ਵਸਿਤਿ ਸ ਤਸ੍ਯ ਨਾਮ੍ਨਾ ਪਾਪਾਨ੍ਮੁਕ੍ਤੋ ਭਵਿਸ਼਼੍ਯਤਿ ਤਸ੍ਮਿਨ੍ ਸਰ੍ੱਵੇ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨੋਪਿ ਏਤਾਦ੍ਰੁʼਸ਼ੰ ਸਾਕ੍ਸ਼਼੍ਯੰ ਦਦਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","ਪਿਤਰਸ੍ਯੈਤਤ੍ਕਥਾਕਥਨਕਾਲੇ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਸ਼੍ਰੋਤ੍ਰੁʼਣਾਮੁਪਰਿ ਪਵਿਤ੍ਰ ਆਤ੍ਮਾਵਾਰੋਹਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ਤਤਃ ਪਿਤਰੇਣ ਸਾਰ੍ੱਧਮ੍ ਆਗਤਾਸ੍ਤ੍ਵਕ੍ਛੇਦਿਨੋ ਵਿਸ਼੍ਵਾਸਿਨੋ ਲੋਕਾ ਅਨ੍ਯਦੇਸ਼ੀਯੇਭ੍ਯਃ ਪਵਿਤ੍ਰ ਆਤ੍ਮਨਿ ਦੱਤੇ ਸਤਿ ");
INSERT INTO sanpun_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ਤੇ ਨਾਨਾਜਾਤੀਯਭਾਸ਼਼ਾਭਿਃ ਕਥਾਂ ਕਥਯਨ੍ਤ ਈਸ਼੍ਵਰੰ ਪ੍ਰਸ਼ੰਸਨ੍ਤਿ, ਇਤਿ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਸ਼੍ਰੁਤ੍ਵਾ ਚ ਵਿਸ੍ਮਯਮ੍ ਆਪਦ੍ਯਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","ਤਦਾ ਪਿਤਰਃ ਕਥਿਤਵਾਨ੍, ਵਯਮਿਵ ਯੇ ਪਵਿਤ੍ਰਮ੍ ਆਤ੍ਮਾਨੰ ਪ੍ਰਾਪ੍ਤਾਸ੍ਤੇਸ਼਼ਾਂ ਜਲਮੱਜਨੰ ਕਿੰ ਕੋਪਿ ਨਿਸ਼਼ੇੱਧੁੰ ਸ਼ਕ੍ਨੋਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","ਤਤਃ ਪ੍ਰਭੋ ਰ੍ਨਾਮ੍ਨਾ ਮੱਜਿਤਾ ਭਵਤੇਤਿ ਤਾਨਾਜ੍ਞਾਪਯਤ੍| ਅਨਨ੍ਤਰੰ ਤੇ ਸ੍ਵੈਃ ਸਾਰ੍ੱਧੰ ਕਤਿਪਯਦਿਨਾਨਿ ਸ੍ਥਾਤੁੰ ਪ੍ਰਾਰ੍ਥਯਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ਇੱਥੰ ਭਿੰਨਦੇਸ਼ੀਯਲੋਕਾ ਅਪੀਸ਼੍ਵਰਸ੍ਯ ਵਾਕ੍ਯਮ੍ ਅਗ੍ਰੁʼਹ੍ਲਨ੍ ਇਮਾਂ ਵਾਰ੍ੱਤਾਂ ਯਿਹੂਦੀਯਦੇਸ਼ਸ੍ਥਪ੍ਰੇਰਿਤਾ ਭ੍ਰਾਤ੍ਰੁʼਗਣਸ਼੍ਚ ਸ਼੍ਰੁਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ਤਤਃ ਪਿਤਰੇ ਯਿਰੂਸ਼ਾਲਮ੍ਨਗਰੰ ਗਤਵਤਿ ਤ੍ਵਕ੍ਛੇਦਿਨੋ ਲੋਕਾਸ੍ਤੇਨ ਸਹ ਵਿਵਦਮਾਨਾ ਅਵਦਨ੍, ");
INSERT INTO sanpun_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ਤ੍ਵਮ੍ ਅਤ੍ਵਕ੍ਛੇਦਿਲੋਕਾਨਾਂ ਗ੍ਰੁʼਹੰ ਗਤ੍ਵਾ ਤੈਃ ਸਾਰ੍ੱਧੰ ਭੁਕ੍ਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","ਤਤਃ ਪਿਤਰ ਆਦਿਤਃ ਕ੍ਰਮਸ਼ਸ੍ਤਤ੍ਕਾਰ੍ੱਯਸ੍ਯ ਸਰ੍ੱਵਵ੍ਰੁʼੱਤਾਨ੍ਤਮਾਖ੍ਯਾਤੁਮ੍ ਆਰਬ੍ਧਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","ਯਾਫੋਨਗਰ ਏਕਦਾਹੰ ਪ੍ਰਾਰ੍ਥਯਮਾਨੋ ਮੂਰ੍ੱਛਿਤਃ ਸਨ੍ ਦਰ੍ਸ਼ਨੇਨ ਚਤੁਰ੍ਸ਼਼ੁ ਕੋਣੇਸ਼਼ੁ ਲਮ੍ਬਨਮਾਨੰ ਵ੍ਰੁʼਹਦ੍ਵਸ੍ਤ੍ਰਮਿਵ ਪਾਤ੍ਰਮੇਕਮ੍ ਆਕਾਸ਼ਦਵਰੁਹ੍ਯ ਮੰਨਿਕਟਮ੍ ਆਗੱਛਦ੍ ਅਪਸ਼੍ਯਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ਪਸ਼੍ਚਾਤ੍ ਤਦ੍ ਅਨਨ੍ਯਦ੍ਰੁʼਸ਼਼੍ਟ੍ਯਾ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਵਿਵਿਚ੍ਯ ਤਸ੍ਯ ਮਧ੍ਯੇ ਨਾਨਾਪ੍ਰਕਾਰਾਨ੍ ਗ੍ਰਾਮ੍ਯਵਨ੍ਯਪਸ਼ੂਨ੍ ਉਰੋਗਾਮਿਖੇਚਰਾਂਸ਼੍ਚ ਦ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍; ");
INSERT INTO sanpun_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","ਹੇ ਪਿਤਰ ਤ੍ਵਮੁੱਥਾਯ ਗਤ੍ਵਾ ਭੁੰਕ੍ਸ਼਼੍ਵ ਮਾਂ ਸਮ੍ਬੋਧ੍ਯ ਕਥਯਨ੍ਤੰ ਸ਼ਬ੍ਦਮੇਕੰ ਸ਼੍ਰੁਤਵਾਂਸ਼੍ਚ| ");
INSERT INTO sanpun_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","ਤਤੋਹੰ ਪ੍ਰਤ੍ਯਵਦੰ, ਹੇ ਪ੍ਰਭੋ ਨੇੱਥੰ ਭਵਤੁ, ਯਤਃ ਕਿਞ੍ਚਨ ਨਿਸ਼਼ਿੱਧਮ੍ ਅਸ਼ੁਚਿ ਦ੍ਰਵ੍ਯੰ ਵਾ ਮਮ ਮੁਖਮਧ੍ਯੰ ਕਦਾਪਿ ਨ ਪ੍ਰਾਵਿਸ਼ਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","ਅਪਰਮ੍ ਈਸ਼੍ਵਰੋ ਯਤ੍ ਸ਼ੁਚਿ ਕ੍ਰੁʼਤਵਾਨ੍ ਤੰਨਿਸ਼਼ਿੱਧੰ ਨ ਜਾਨੀਹਿ ਦ੍ਵਿ ਰ੍ਮਾਮ੍ਪ੍ਰਤੀਦ੍ਰੁʼਸ਼ੀ ਵਿਹਾਯਸੀਯਾ ਵਾਣੀ ਜਾਤਾ| ");
INSERT INTO sanpun_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","ਤ੍ਰਿਰਿੱਥੰ ਸਤਿ ਤਤ੍ ਸਰ੍ੱਵੰ ਪੁਨਰਾਕਾਸ਼ਮ੍ ਆਕ੍ਰੁʼਸ਼਼੍ਟੰ| ");
INSERT INTO sanpun_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","ਪਸ਼੍ਚਾਤ੍ ਕੈਸਰਿਯਾਨਗਰਾਤ੍ ਤ੍ਰਯੋ ਜਨਾ ਮੰਨਿਕਟੰ ਪ੍ਰੇਸ਼਼ਿਤਾ ਯਤ੍ਰ ਨਿਵੇਸ਼ਨੇ ਸ੍ਥਿਤੋਹੰ ਤਸ੍ਮਿਨ੍ ਸਮਯੇ ਤਤ੍ਰੋਪਾਤਿਸ਼਼੍ਠਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","ਤਦਾ ਨਿਃਸਨ੍ਦੇਹੰ ਤੈਃ ਸਾਰ੍ੱਧੰ ਯਾਤੁਮ੍ ਆਤ੍ਮਾ ਮਾਮਾਦਿਸ਼਼੍ਟਵਾਨ੍; ਤਤਃ ਪਰੰ ਮਯਾ ਸਹੈਤੇਸ਼਼ੁ ਸ਼਼ਡ੍ਭ੍ਰਾਤ੍ਰੁʼਸ਼਼ੁ ਗਤੇਸ਼਼ੁ ਵਯੰ ਤਸ੍ਯ ਮਨੁਜਸ੍ਯ ਗ੍ਰੁʼਹੰ ਪ੍ਰਾਵਿਸ਼ਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ਸੋਸ੍ਮਾਕੰ ਨਿਕਟੇ ਕਥਾਮੇਤਾਮ੍ ਅਕਥਯਤ੍ ਏਕਦਾ ਦੂਤ ਏਕਃ ਪ੍ਰਤ੍ਯਕ੍ਸ਼਼ੀਭੂਯ ਮਮ ਗ੍ਰੁʼਹਮਧ੍ਯੇ ਤਿਸ਼਼੍ਟਨ੍ ਮਾਮਿਤ੍ਯਾਜ੍ਞਾਪਿਤਵਾਨ੍, ਯਾਫੋਨਗਰੰ ਪ੍ਰਤਿ ਲੋਕਾਨ੍ ਪ੍ਰਹਿਤ੍ਯ ਪਿਤਰਨਾਮ੍ਨਾ ਵਿਖ੍ਯਾਤੰ ਸ਼ਿਮੋਨਮ੍ ਆਹੂਯਯ; ");
INSERT INTO sanpun_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ਤਤਸ੍ਤਵ ਤ੍ਵਦੀਯਪਰਿਵਾਰਾਣਾਞ੍ਚ ਯੇਨ ਪਰਿਤ੍ਰਾਣੰ ਭਵਿਸ਼਼੍ਯਤਿ ਤਤ੍ ਸ ਉਪਦੇਕ੍ਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","ਅਹੰ ਤਾਂ ਕਥਾਮੁੱਥਾਪ੍ਯ ਕਥਿਤਵਾਨ੍ ਤੇਨ ਪ੍ਰਥਮਮ੍ ਅਸ੍ਮਾਕਮ੍ ਉਪਰਿ ਯਥਾ ਪਵਿਤ੍ਰ ਆਤ੍ਮਾਵਰੂਢਵਾਨ੍ ਤਥਾ ਤੇਸ਼਼ਾਮਪ੍ਯੁਪਰਿ ਸਮਵਰੂਢਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","ਤੇਨ ਯੋਹਨ੍ ਜਲੇ ਮੱਜਿਤਵਾਨ੍ ਇਤਿ ਸਤ੍ਯੰ ਕਿਨ੍ਤੁ ਯੂਯੰ ਪਵਿਤ੍ਰ ਆਤ੍ਮਨਿ ਮੱਜਿਤਾ ਭਵਿਸ਼਼੍ਯਥ, ਇਤਿ ਯਦ੍ਵਾਕ੍ਯੰ ਪ੍ਰਭੁਰੁਦਿਤਵਾਨ੍ ਤਤ੍ ਤਦਾ ਮਯਾ ਸ੍ਮ੍ਰੁʼਤਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","ਅਤਃ ਪ੍ਰਭਾ ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟੇ ਪ੍ਰਤ੍ਯਯਕਾਰਿਣੋ ਯੇ ਵਯਮ੍ ਅਸ੍ਮਭ੍ਯਮ੍ ਈਸ਼੍ਵਰੋ ਯਦ੍ ਦੱਤਵਾਨ੍ ਤਤ੍ ਤੇਭ੍ਯੋ ਲੋਕੇਭ੍ਯੋਪਿ ਦੱਤਵਾਨ੍ ਤਤਃ ਕੋਹੰ? ਕਿਮਹਮ੍ ਈਸ਼੍ਵਰੰ ਵਾਰਯਿਤੁੰ ਸ਼ਕ੍ਨੋਮਿ? ");
INSERT INTO sanpun_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","ਕਥਾਮੇਤਾਂ ਸ਼੍ਰੁਵਾ ਤੇ ਕ੍ਸ਼਼ਾਨ੍ਤਾ ਈਸ਼੍ਵਰਸ੍ਯ ਗੁਣਾਨ੍ ਅਨੁਕੀਰ੍ੱਤ੍ਯ ਕਥਿਤਵਨ੍ਤਃ, ਤਰ੍ਹਿ ਪਰਮਾਯੁਃਪ੍ਰਾਪ੍ਤਿਨਿਮਿੱਤਮ੍ ਈਸ਼੍ਵਰੋਨ੍ਯਦੇਸ਼ੀਯਲੋਕੇਭ੍ਯੋਪਿ ਮਨਃਪਰਿਵਰ੍ੱਤਨਰੂਪੰ ਦਾਨਮ੍ ਅਦਾਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","ਸ੍ਤਿਫਾਨੰ ਪ੍ਰਤਿ ਉਪਦ੍ਰਵੇ ਘਟਿਤੇ ਯੇ ਵਿਕੀਰ੍ਣਾ ਅਭਵਨ੍ ਤੈ ਫੈਨੀਕੀਕੁਪ੍ਰਾਨ੍ਤਿਯਖਿਯਾਸੁ ਭ੍ਰਮਿਤ੍ਵਾ ਕੇਵਲਯਿਹੂਦੀਯਲੋਕਾਨ੍ ਵਿਨਾ ਕਸ੍ਯਾਪ੍ਯਨ੍ਯਸ੍ਯ ਸਮੀਪ ਈਸ਼੍ਵਰਸ੍ਯ ਕਥਾਂ ਨ ਪ੍ਰਾਚਾਰਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","ਅਪਰੰ ਤੇਸ਼਼ਾਂ ਕੁਪ੍ਰੀਯਾਃ ਕੁਰੀਨੀਯਾਸ਼੍ਚ ਕਿਯਨ੍ਤੋ ਜਨਾ ਆਨ੍ਤਿਯਖਿਯਾਨਗਰੰ ਗਤ੍ਵਾ ਯੂਨਾਨੀਯਲੋਕਾਨਾਂ ਸਮੀਪੇਪਿ ਪ੍ਰਭੋਰ੍ਯੀਸ਼ੋਃ ਕਥਾਂ ਪ੍ਰਾਚਾਰਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ਪ੍ਰਭੋਃ ਕਰਸ੍ਤੇਸ਼਼ਾਂ ਸਹਾਯ ਆਸੀਤ੍ ਤਸ੍ਮਾਦ੍ ਅਨੇਕੇ ਲੋਕਾ ਵਿਸ਼੍ਵਸ੍ਯ ਪ੍ਰਭੁੰ ਪ੍ਰਤਿ ਪਰਾਵਰ੍ੱਤਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ਇਤਿ ਵਾਰ੍ੱਤਾਯਾਂ ਯਿਰੂਸ਼ਾਲਮਸ੍ਥਮਣ੍ਡਲੀਯਲੋਕਾਨਾਂ ਕਰ੍ਣਗੋਚਰੀਭੂਤਾਯਾਮ੍ ਆਨ੍ਤਿਯਖਿਯਾਨਗਰੰ ਗਨ੍ਤੁ ਤੇ ਬਰ੍ਣੱਬਾਂ ਪ੍ਰੈਰਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ਤਤੋ ਬਰ੍ਣੱਬਾਸ੍ਤਤ੍ਰ ਉਪਸ੍ਥਿਤਃ ਸਨ੍ ਈਸ਼੍ਵਰਸ੍ਯਾਨੁਗ੍ਰਹਸ੍ਯ ਫਲੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਸਾਨਨ੍ਦੋ ਜਾਤਃ, ");
INSERT INTO sanpun_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ਸ ਸ੍ਵਯੰ ਸਾਧੁ ਰ੍ਵਿਸ਼੍ਵਾਸੇਨ ਪਵਿਤ੍ਰੇਣਾਤ੍ਮਨਾ ਚ ਪਰਿਪੂਰ੍ਣਃ ਸਨ੍ ਗਨੋਨਿਸ਼਼੍ਟਯਾ ਪ੍ਰਭਾਵਾਸ੍ਥਾਂ ਕਰ੍ੱਤੁੰ ਸਰ੍ੱਵਾਨ੍ ਉਪਦਿਸ਼਼੍ਟਵਾਨ੍ ਤੇਨ ਪ੍ਰਭੋਃ ਸ਼ਿਸ਼਼੍ਯਾ ਅਨੇਕੇ ਬਭੂਵੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","ਸ਼ੇਸ਼਼ੇ ਸ਼ੌਲੰ ਮ੍ਰੁʼਗਯਿਤੁੰ ਬਰ੍ਣੱਬਾਸ੍ਤਾਰ੍ਸ਼਼ਨਗਰੰ ਪ੍ਰਸ੍ਥਿਤਵਾਨ੍| ਤਤ੍ਰ ਤਸ੍ਯੋੱਦੇਸ਼ੰ ਪ੍ਰਾਪ੍ਯ ਤਮ੍ ਆਨ੍ਤਿਯਖਿਯਾਨਗਰਮ੍ ਆਨਯਤ੍; ");
INSERT INTO sanpun_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ਤਤਸ੍ਤੌ ਮਣ੍ਡਲੀਸ੍ਥਲੋਕੈਃ ਸਭਾਂ ਕ੍ਰੁʼਤ੍ਵਾ ਸੰਵਤ੍ਸਰਮੇਕੰ ਯਾਵਦ੍ ਬਹੁਲੋਕਾਨ੍ ਉਪਾਦਿਸ਼ਤਾਂ; ਤਸ੍ਮਿਨ੍ ਆਨ੍ਤਿਯਖਿਯਾਨਗਰੇ ਸ਼ਿਸ਼਼੍ਯਾਃ ਪ੍ਰਥਮੰ ਖ੍ਰੀਸ਼਼੍ਟੀਯਨਾਮ੍ਨਾ ਵਿਖ੍ਯਾਤਾ ਅਭਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","ਤਤਃ ਪਰੰ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਗਣੇ ਯਿਰੂਸ਼ਾਲਮ ਆਨ੍ਤਿਯਖਿਯਾਨਗਰਮ੍ ਆਗਤੇ ਸਤਿ ");
INSERT INTO sanpun_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ਆਗਾਬਨਾਮਾ ਤੇਸ਼਼ਾਮੇਕ ਉੱਥਾਯ ਆਤ੍ਮਨਃ ਸ਼ਿਕ੍ਸ਼਼ਯਾ ਸਰ੍ੱਵਦੇਸ਼ੇ ਦੁਰ੍ਭਿਕ੍ਸ਼਼ੰ ਭਵਿਸ਼਼੍ਯਤੀਤਿ ਜ੍ਞਾਪਿਤਵਾਨ੍; ਤਤਃ ਕ੍ਲੌਦਿਯਕੈਸਰਸ੍ਯਾਧਿਕਾਰੇ ਸਤਿ ਤਤ੍ ਪ੍ਰਤ੍ਯਕ੍ਸ਼਼ਮ੍ ਅਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","ਤਸ੍ਮਾਤ੍ ਸ਼ਿਸ਼਼੍ਯਾ ਏਕੈਕਸ਼ਃ ਸ੍ਵਸ੍ਵਸ਼ਕ੍ਤ੍ਯਨੁਸਾਰਤੋ ਯਿਹੂਦੀਯਦੇਸ਼ਨਿਵਾਸਿਨਾਂ ਭ੍ਰਤ੍ਰੁʼਣਾਂ ਦਿਨਯਾਪਨਾਰ੍ਥੰ ਧਨੰ ਪ੍ਰੇਸ਼਼ਯਿਤੁੰ ਨਿਸ਼੍ਚਿਤ੍ਯ ");
INSERT INTO sanpun_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ਬਰ੍ਣੱਬਾਸ਼ੌਲਯੋ ਰ੍ਦ੍ਵਾਰਾ ਪ੍ਰਾਚੀਨਲੋਕਾਨਾਂ ਸਮੀਪੰ ਤਤ੍ ਪ੍ਰੇਸ਼਼ਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","ਤਸ੍ਮਿਨ੍ ਸਮਯੇ ਹੇਰੋਦ੍‌ਰਾਜੋ ਮਣ੍ਡਲ੍ਯਾਃ ਕਿਯੱਜਨੇਭ੍ਯੋ ਦੁਃਖੰ ਦਾਤੁੰ ਪ੍ਰਾਰਭਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ਵਿਸ਼ੇਸ਼਼ਤੋ ਯੋਹਨਃ ਸੋਦਰੰ ਯਾਕੂਬੰ ਕਰਵਾਲਾਘਾਤੇਨ੍ ਹਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ਤਸ੍ਮਾਦ੍ ਯਿਹੂਦੀਯਾਃ ਸਨ੍ਤੁਸ਼਼੍ਟਾ ਅਭਵਨ੍ ਇਤਿ ਵਿਜ੍ਞਾਯ ਸ ਪਿਤਰਮਪਿ ਧਰ੍ੱਤੁੰ ਗਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ਤਦਾ ਕਿਣ੍ਵਸ਼ੂਨ੍ਯਪੂਪੋਤ੍ਸਵਸਮਯ ਉਪਾਤਿਸ਼਼੍ਟਤ੍; ਅਤ ਉਤ੍ਸਵੇ ਗਤੇ ਸਤਿ ਲੋਕਾਨਾਂ ਸਮਕ੍ਸ਼਼ੰ ਤੰ ਬਹਿਰਾਨੇੱਯਾਮੀਤਿ ਮਨਸਿ ਸ੍ਥਿਰੀਕ੍ਰੁʼਤ੍ਯ ਸ ਤੰ ਧਾਰਯਿਤ੍ਵਾ ਰਕ੍ਸ਼਼੍ਣਾਰ੍ਥਮ੍ ਯੇਸ਼਼ਾਮ੍ ਏਕੈਕਸੰਘੇ ਚਤ੍ਵਾਰੋ ਜਨਾਃ ਸਨ੍ਤਿ ਤੇਸ਼਼ਾਂ ਚਤੁਰ੍ਣਾਂ ਰਕ੍ਸ਼਼ਕਸੰਘਾਨਾਂ ਸਮੀਪੇ ਤੰ ਸਮਰ੍ਪ੍ਯ ਕਾਰਾਯਾਂ ਸ੍ਥਾਪਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","ਕਿਨ੍ਤੁੰ ਪਿਤਰਸ੍ਯ ਕਾਰਾਸ੍ਥਿਤਿਕਾਰਣਾਤ੍ ਮਣ੍ਡਲ੍ਯਾ ਲੋਕਾ ਅਵਿਸ਼੍ਰਾਮਮ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਸਮੀਪੇ ਪ੍ਰਾਰ੍ਥਯਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","ਅਨਨ੍ਤਰੰ ਹੇਰੋਦਿ ਤੰ ਬਹਿਰਾਨਾਯਿਤੁੰ ਉਦ੍ਯਤੇ ਸਤਿ ਤਸ੍ਯਾਂ ਰਾਤ੍ਰੌ ਪਿਤਰੋ ਰਕ੍ਸ਼਼ਕਦ੍ਵਯਮਧ੍ਯਸ੍ਥਾਨੇ ਸ਼੍ਰੁʼਙ੍ਖਲਦ੍ਵਯੇਨ ਬੱਧ੍ਵਃ ਸਨ੍ ਨਿਦ੍ਰਿਤ ਆਸੀਤ੍, ਦੌਵਾਰਿਕਾਸ਼੍ਚ ਕਾਰਾਯਾਃ ਸੰਮੁਖੇ ਤਿਸ਼਼੍ਠਨਤੋ ਦ੍ਵਾਰਮ੍ ਅਰਕ੍ਸ਼਼ਿਸ਼਼ੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ਏਤਸ੍ਮਿਨ੍ ਸਮਯੇ ਪਰਮੇਸ਼੍ਵਰਸ੍ਯ ਦੂਤੇ ਸਮੁਪਸ੍ਥਿਤੇ ਕਾਰਾ ਦੀਪ੍ਤਿਮਤੀ ਜਾਤਾ; ਤਤਃ ਸ ਦੂਤਃ ਪਿਤਰਸ੍ਯ ਕੁਕ੍ਸ਼਼ਾਵਾਵਾਤੰ ਕ੍ਰੁʼਤ੍ਵਾ ਤੰ ਜਾਗਰਯਿਤ੍ਵਾ ਭਾਸ਼਼ਿਤਵਾਨ੍ ਤੂਰ੍ਣਮੁੱਤਿਸ਼਼੍ਠ; ਤਤਸ੍ਤਸ੍ਯ ਹਸ੍ਤਸ੍ਥਸ਼੍ਰੁʼਙ੍ਖਲਦ੍ਵਯੰ ਗਲਤ੍ ਪਤਿਤੰ| ");
INSERT INTO sanpun_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ਸ ਦੂਤਸ੍ਤਮਵਦਤ੍, ਬੱਧਕਟਿਃ ਸਨ੍ ਪਾਦਯੋਃ ਪਾਦੁਕੇ ਅਰ੍ਪਯ; ਤੇਨ ਤਥਾ ਕ੍ਰੁʼਤੇ ਸਤਿ ਦੂਤਸ੍ਤਮ੍ ਉਕ੍ਤਵਾਨ੍ ਗਾਤ੍ਰੀਯਵਸ੍ਤ੍ਰੰ ਗਾਤ੍ਰੇ ਨਿਧਾਯ ਮਮ ਪਸ਼੍ਚਾਦ੍ ਏਹਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ਤਤਃ ਪਿਤਰਸ੍ਤਸ੍ਯ ਪਸ਼੍ਚਾਦ੍ ਵ੍ਰਜਨ ਬਹਿਰਗੱਛਤ੍, ਕਿਨ੍ਤੁ ਦੂਤੇਨ ਕਰ੍ੰਮੈਤਤ੍ ਕ੍ਰੁʼਤਮਿਤਿ ਸਤ੍ਯਮਜ੍ਞਾਤ੍ਵਾ ਸ੍ਵਪ੍ਨਦਰ੍ਸ਼ਨੰ ਜ੍ਞਾਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ਇੱਥੰ ਤੌ ਪ੍ਰਥਮਾਂ ਦ੍ਵਿਤੀਯਾਞ੍ਚ ਕਾਰਾਂ ਲਙ੍ਘਿਤ੍ਵਾ ਯੇਨ ਲੌਹਨਿਰ੍ੰਮਿਤਦ੍ਵਾਰੇਣ ਨਗਰੰ ਗਮ੍ਯਤੇ ਤਤ੍ਸਮੀਪੰ ਪ੍ਰਾਪ੍ਨੁਤਾਂ; ਤਤਸ੍ਤਸ੍ਯ ਕਵਾਟੰ ਸ੍ਵਯੰ ਮੁਕ੍ਤਮਭਵਤ੍ ਤਤਸ੍ਤੌ ਤਤ੍ਸ੍ਥਾਨਾਦ੍ ਬਹਿ ਰ੍ਭੂਤ੍ਵਾ ਮਾਰ੍ਗੈਕਸ੍ਯ ਸੀਮਾਂ ਯਾਵਦ੍ ਗਤੌ; ਤਤੋ(ਅ)ਕਸ੍ਮਾਤ੍ ਸ ਦੂਤਃ ਪਿਤਰੰ ਤ੍ਯਕ੍ਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","ਤਦਾ ਸ ਚੇਤਨਾਂ ਪ੍ਰਾਪ੍ਯ ਕਥਿਤਵਾਨ੍ ਨਿਜਦੂਤੰ ਪ੍ਰਹਿਤ੍ਯ ਪਰਮੇਸ਼੍ਵਰੋ ਹੇਰੋਦੋ ਹਸ੍ਤਾਦ੍ ਯਿਹੂਦੀਯਲੋਕਾਨਾਂ ਸਰ੍ੱਵਾਸ਼ਾਯਾਸ਼੍ਚ ਮਾਂ ਸਮੁੱਧ੍ਰੁʼਤਵਾਨ੍ ਇਤ੍ਯਹੰ ਨਿਸ਼੍ਚਯੰ ਜ੍ਞਾਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ਸ ਵਿਵਿਚ੍ਯ ਮਾਰ੍ਕਨਾਮ੍ਰਾ ਵਿਖ੍ਯਾਤਸ੍ਯ ਯੋਹਨੋ ਮਾਤੁ ਰ੍ਮਰਿਯਮੋ ਯਸ੍ਮਿਨ੍ ਗ੍ਰੁʼਹੇ ਬਹਵਃ ਸਮ੍ਭੂਯ ਪ੍ਰਾਰ੍ਥਯਨ੍ਤ ਤੰਨਿਵੇਸ਼ਨੰ ਗਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","ਪਿਤਰੇਣ ਬਹਿਰ੍ਦ੍ਵਾਰ ਆਹਤੇ ਸਤਿ ਰੋਦਾਨਾਮਾ ਬਾਲਿਕਾ ਦ੍ਰਸ਼਼੍ਟੁੰ ਗਤਾ| ");
INSERT INTO sanpun_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","ਤਤਃ ਪਿਤਰਸ੍ਯ ਸ੍ਵਰੰ ਸ਼੍ਰੁਵਾ ਸਾ ਹਰ੍ਸ਼਼ਯੁਕ੍ਤਾ ਸਤੀ ਦ੍ਵਾਰੰ ਨ ਮੋਚਯਿਤ੍ਵਾ ਪਿਤਰੋ ਦ੍ਵਾਰੇ ਤਿਸ਼਼੍ਠਤੀਤਿ ਵਾਰ੍ੱਤਾਂ ਵਕ੍ਤੁਮ੍ ਅਭ੍ਯਨ੍ਤਰੰ ਧਾਵਿਤ੍ਵਾ ਗਤਵਤੀ| ");
INSERT INTO sanpun_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","ਤੇ ਪ੍ਰਾਵੋਚਨ੍ ਤ੍ਵਮੁਨ੍ਮੱਤਾ ਜਾਤਾਸਿ ਕਿਨ੍ਤੁ ਸਾ ਮੁਹੁਰ੍ਮੁਹੁਰੁਕ੍ਤਵਤੀ ਸਤ੍ਯਮੇਵੈਤਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","ਤਦਾ ਤੇ ਕਥਿਤਵਨ੍ਤਸ੍ਤਰ੍ਹਿ ਤਸ੍ਯ ਦੂਤੋ ਭਵੇਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","ਪਿਤਰੋ ਦ੍ਵਾਰਮਾਹਤਵਾਨ੍ ਏਤਸ੍ਮਿੰਨਨ੍ਤਰੇ ਦ੍ਵਾਰੰ ਮੋਚਯਿਤ੍ਵਾ ਪਿਤਰੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਵਿਸ੍ਮਯੰ ਪ੍ਰਾਪ੍ਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","ਤਤਃ ਪਿਤਰੋ ਨਿਃਸ਼ਬ੍ਦੰ ਸ੍ਥਾਤੁੰ ਤਾਨ੍ ਪ੍ਰਤਿ ਹਸ੍ਤੇਨ ਸਙ੍ਕੇਤੰ ਕ੍ਰੁʼਤ੍ਵਾ ਪਰਮੇਸ਼੍ਵਰੋ ਯੇਨ ਪ੍ਰਕਾਰੇਣ ਤੰ ਕਾਰਾਯਾ ਉੱਧ੍ਰੁʼਤ੍ਯਾਨੀਤਵਾਨ੍ ਤਸ੍ਯ ਵ੍ਰੁʼੱਤਾਨ੍ਤੰ ਤਾਨਜ੍ਞਾਪਯਤ੍, ਯੂਯੰ ਗਤ੍ਵਾ ਯਾਕੁਬੰ ਭ੍ਰਾਤ੍ਰੁʼਗਣਞ੍ਚ ਵਾਰ੍ੱਤਾਮੇਤਾਂ ਵਦਤੇਤ੍ਯੁਕ੍ਤਾ ਸ੍ਥਾਨਾਨ੍ਤਰੰ ਪ੍ਰਸ੍ਥਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ਪ੍ਰਭਾਤੇ ਸਤਿ ਪਿਤਰਃ ਕ੍ਵ ਗਤ ਇਤ੍ਯਤ੍ਰ ਰਕ੍ਸ਼਼ਕਾਣਾਂ ਮਧ੍ਯੇ ਮਹਾਨ੍ ਕਲਹੋ ਜਾਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ਹੇਰੋਦ੍ ਬਹੁ ਮ੍ਰੁʼਗਯਿਤ੍ਵਾ ਤਸ੍ਯੋੱਦੇਸ਼ੇ ਨ ਪ੍ਰਾਪ੍ਤੇ ਸਤਿ ਰਕ੍ਸ਼਼ਕਾਨ੍ ਸੰਪ੍ਰੁʼੱਛ੍ਯ ਤੇਸ਼਼ਾਂ ਪ੍ਰਾਣਾਨ੍ ਹਨ੍ਤੁਮ੍ ਆਦਿਸ਼਼੍ਟਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ਪਸ਼੍ਚਾਤ੍ ਸ ਯਿਹੂਦੀਯਪ੍ਰਦੇਸ਼ਾਤ੍ ਕੈਸਰਿਯਾਨਗਰੰ ਗਤ੍ਵਾ ਤਤ੍ਰਾਵਾਤਿਸ਼਼੍ਠਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","ਸੋਰਸੀਦੋਨਦੇਸ਼ਯੋ ਰ੍ਲੋਕੇਭ੍ਯੋ ਹੇਰੋਦਿ ਯੁਯੁਤ੍ਸੌ ਸਤਿ ਤੇ ਸਰ੍ੱਵ ਏਕਮਨ੍ਤ੍ਰਣਾਃ ਸਨ੍ਤਸ੍ਤਸ੍ਯ ਸਮੀਪ ਉਪਸ੍ਥਾਯ ਲ੍ਵਾਸ੍ਤਨਾਮਾਨੰ ਤਸ੍ਯ ਵਸ੍ਤ੍ਰਗ੍ਰੁʼਹਾਧੀਸ਼ੰ ਸਹਾਯੰ ਕ੍ਰੁʼਤ੍ਵਾ ਹੇਰੋਦਾ ਸਾਰ੍ੱਧੰ ਸਨ੍ਧਿੰ ਪ੍ਰਾਰ੍ਥਯਨ੍ਤ ਯਤਸ੍ਤਸ੍ਯ ਰਾਜ੍ਞੋ ਦੇਸ਼ੇਨ ਤੇਸ਼਼ਾਂ ਦੇਸ਼ੀਯਾਨਾਂ ਭਰਣਮ੍ ਅਭਵਤ੍ਂ ");
INSERT INTO sanpun_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","ਅਤਃ ਕੁਤ੍ਰਚਿਨ੍ ਨਿਰੁਪਿਤਦਿਨੇ ਹੇਰੋਦ੍ ਰਾਜਕੀਯੰ ਪਰਿੱਛਦੰ ਪਰਿਧਾਯ ਸਿੰਹਾਸਨੇ ਸਮੁਪਵਿਸ਼੍ਯ ਤਾਨ੍ ਪ੍ਰਤਿ ਕਥਾਮ੍ ਉਕ੍ਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","ਤਤੋ ਲੋਕਾ ਉੱਚੈਃਕਾਰੰ ਪ੍ਰਤ੍ਯਵਦਨ੍, ਏਸ਼਼ ਮਨੁਜਰਵੋ ਨ ਹਿ, ਈਸ਼੍ਵਰੀਯਰਵਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","ਤਦਾ ਹੇਰੋਦ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਸੰਮਾਨੰ ਨਾਕਰੋਤ੍; ਤਸ੍ਮਾੱਧੇਤੋਃ ਪਰਮੇਸ਼੍ਵਰਸ੍ਯ ਦੂਤੋ ਹਠਾਤ੍ ਤੰ ਪ੍ਰਾਹਰਤ੍ ਤੇਨੈਵ ਸ ਕੀਟੈਃ ਕ੍ਸ਼਼ੀਣਃ ਸਨ੍ ਪ੍ਰਾਣਾਨ੍ ਅਜਹਾਤ੍| ਕਿਨ੍ਤ੍ਵੀਸ਼੍ਵਰਸ੍ਯ ਕਥਾ ਦੇਸ਼ੰ ਵ੍ਯਾਪ੍ਯ ਪ੍ਰਬਲਾਭਵਤ੍| ਤਤਃ ਪਰੰ ਬਰ੍ਣੱਬਾਸ਼ੌਲੌ ਯਸ੍ਯ ਕਰ੍ੰਮਣੋ ਭਾਰੰ ਪ੍ਰਾਪ੍ਨੁਤਾਂ ਤਾਭ੍ਯਾਂ ਤਸ੍ਮਿਨ੍ ਸਮ੍ਪਾਦਿਤੇ ਸਤਿ ਮਾਰ੍ਕਨਾਮ੍ਨਾ ਵਿਖ੍ਯਾਤੋ ਯੋ ਯੋਹਨ੍ ਤੰ ਸਙ੍ਗਿਨੰ ਕ੍ਰੁʼਤ੍ਵਾ ਯਿਰੂਸ਼ਾਲਮ੍ਨਗਰਾਤ੍ ਪ੍ਰਤ੍ਯਾਗਤੌ| ");
INSERT INTO sanpun_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","ਅਪਰਞ੍ਚ ਬਰ੍ਣੱਬਾਃ, ਸ਼ਿਮੋਨ੍ ਯੰ ਨਿਗ੍ਰੰ ਵਦਨ੍ਤਿ, ਕੁਰੀਨੀਯਲੂਕਿਯੋ ਹੇਰੋਦਾ ਰਾਜ੍ਞਾ ਸਹ ਕ੍ਰੁʼਤਵਿਦ੍ਯਾाਭ੍ਯਾਸੋ ਮਿਨਹੇਮ੍, ਸ਼ੌਲਸ਼੍ਚੈਤੇ ਯੇ ਕਿਯਨ੍ਤੋ ਜਨਾ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨ ਉਪਦੇਸ਼਼੍ਟਾਰਸ਼੍ਚਾਨ੍ਤਿਯਖਿਯਾਨਗਰਸ੍ਥਮਣ੍ਡਲ੍ਯਾਮ੍ ਆਸਨ੍, ");
INSERT INTO sanpun_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","ਤੇ ਯਦੋਪਵਾਸੰ ਕ੍ਰੁʼਤ੍ਵੇਸ਼੍ਵਰਮ੍ ਅਸੇਵਨ੍ਤ ਤਸ੍ਮਿਨ੍ ਸਮਯੇ ਪਵਿਤ੍ਰ ਆਤ੍ਮਾ ਕਥਿਤਵਾਨ੍ ਅਹੰ ਯਸ੍ਮਿਨ੍ ਕਰ੍ੰਮਣਿ ਬਰ੍ਣੱਬਾਸ਼ੈਲੌ ਨਿਯੁਕ੍ਤਵਾਨ੍ ਤਤ੍ਕਰ੍ੰਮ ਕਰ੍ੱਤੁੰ ਤੌ ਪ੍ਰੁʼਥਕ੍ ਕੁਰੁਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","ਤਤਸ੍ਤੈਰੁਪਵਾਸਪ੍ਰਾਰ੍ਥਨਯੋਃ ਕ੍ਰੁʼਤਯੋਃ ਸਤੋਸ੍ਤੇ ਤਯੋ ਰ੍ਗਾਤ੍ਰਯੋ ਰ੍ਹਸ੍ਤਾਰ੍ਪਣੰ ਕ੍ਰੁʼਤ੍ਵਾ ਤੌ ਵ੍ਯਸ੍ਰੁʼਜਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","ਤਤਃ ਪਰੰ ਤੌ ਪਵਿਤ੍ਰੇਣਾਤ੍ਮਨਾ ਪ੍ਰੇਰਿਤੌ ਸਨ੍ਤੌ ਸਿਲੂਕਿਯਾਨਗਰਮ੍ ਉਪਸ੍ਥਾਯ ਸਮੁਦ੍ਰਪਥੇਨ ਕੁਪ੍ਰੋਪਦ੍ਵੀਪਮ੍ ਅਗੱਛਤਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ਤਤਃ ਸਾਲਾਮੀਨਗਰਮ੍ ਉਪਸ੍ਥਾਯ ਤਤ੍ਰ ਯਿਹੂਦੀਯਾਨਾਂ ਭਜਨਭਵਨਾਨਿ ਗਤ੍ਵੇਸ਼੍ਵਰਸ੍ਯ ਕਥਾਂ ਪ੍ਰਾਚਾਰਯਤਾਂ; ਯੋਹਨਪਿ ਤਤ੍ਸਹਚਰੋ(ਅ)ਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ਇੱਥੰ ਤੇ ਤਸ੍ਯੋਪਦ੍ਵੀਪਸ੍ਯ ਸਰ੍ੱਵਤ੍ਰ ਭ੍ਰਮਨ੍ਤਃ ਪਾਫਨਗਰਮ੍ ਉਪਸ੍ਥਿਤਾਃ; ਤਤ੍ਰ ਸੁਵਿਵੇਚਕੇਨ ਸਰ੍ਜਿਯਪੌਲਨਾਮ੍ਨਾ ਤੱਦੇਸ਼ਾਧਿਪਤਿਨਾ ਸਹ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨੋ ਵੇਸ਼ਧਾਰੀ ਬਰ੍ਯੀਸ਼ੁਨਾਮਾ ਯੋ ਮਾਯਾਵੀ ਯਿਹੂਦੀ ਆਸੀਤ੍ ਤੰ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਪ੍ਰਾਪ੍ਤਵਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","ਤੱਦੇਸ਼ਾਧਿਪ ਈਸ਼੍ਵਰਸ੍ਯ ਕਥਾਂ ਸ਼੍ਰੋਤੁੰ ਵਾਞ੍ਛਨ੍ ਪੌਲਬਰ੍ਣੱਬੌ ਨ੍ਯਮਨ੍ਤ੍ਰਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","ਕਿਨ੍ਤ੍ਵਿਲੁਮਾ ਯੰ ਮਾਯਾਵਿਨੰ ਵਦਨ੍ਤਿ ਸ ਦੇਸ਼ਾਧਿਪਤਿੰ ਧਰ੍ੰਮਮਾਰ੍ਗਾਦ੍ ਬਹਿਰ੍ਭੂਤੰ ਕਰ੍ੱਤੁਮ੍ ਅਯਤਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","ਤਸ੍ਮਾਤ੍ ਸ਼ੋਲੋ(ਅ)ਰ੍ਥਾਤ੍ ਪੌਲਃ ਪਵਿਤ੍ਰੇਣਾਤ੍ਮਨਾ ਪਰਿਪੂਰ੍ਣਃ ਸਨ੍ ਤੰ ਮਾਯਾਵਿਨੰ ਪ੍ਰਤ੍ਯਨਨ੍ਯਦ੍ਰੁʼਸ਼਼੍ਟਿੰ ਕ੍ਰੁʼਤ੍ਵਾਕਥਯਤ੍, ");
INSERT INTO sanpun_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ਹੇ ਨਰਕਿਨ੍ ਧਰ੍ੰਮਦ੍ਵੇਸ਼਼ਿਨ੍ ਕੌਟਿਲ੍ਯਦੁਸ਼਼੍ਕਰ੍ੰਮਪਰਿਪੂਰ੍ਣ, ਤ੍ਵੰ ਕਿੰ ਪ੍ਰਭੋਃ ਸਤ੍ਯਪਥਸ੍ਯ ਵਿਪਰ੍ੱਯਯਕਰਣਾਤ੍ ਕਦਾਪਿ ਨ ਨਿਵਰ੍ੱਤਿਸ਼਼੍ਯਸੇ? ");
INSERT INTO sanpun_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","ਅਧੁਨਾ ਪਰਮੇਸ਼੍ਵਰਸ੍ਤਵ ਸਮੁਚਿਤੰ ਕਰਿਸ਼਼੍ਯਤਿ ਤੇਨ ਕਤਿਪਯਦਿਨਾਨਿ ਤ੍ਵਮ੍ ਅਨ੍ਧਃ ਸਨ੍ ਸੂਰ੍ੱਯਮਪਿ ਨ ਦ੍ਰਕ੍ਸ਼਼੍ਯਸਿ| ਤਤ੍ਕ੍ਸ਼਼ਣਾਦ੍ ਰਾਤ੍ਰਿਵਦ੍ ਅਨ੍ਧਕਾਰਸ੍ਤਸ੍ਯ ਦ੍ਰੁʼਸ਼਼੍ਟਿਮ੍ ਆੱਛਾਦਿਤਵਾਨ੍; ਤਸ੍ਮਾਤ੍ ਤਸ੍ਯ ਹਸ੍ਤੰ ਧਰ੍ੱਤੁੰ ਸ ਲੋਕਮਨ੍ਵਿੱਛਨ੍ ਇਤਸ੍ਤਤੋ ਭ੍ਰਮਣੰ ਕ੍ਰੁʼਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ਏਨਾਂ ਘਟਨਾਂ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਸ ਦੇਸ਼ਾਧਿਪਤਿਃ ਪ੍ਰਭੂਪਦੇਸ਼ਾਦ੍ ਵਿਸ੍ਮਿਤ੍ਯ ਵਿਸ਼੍ਵਾਸੰ ਕ੍ਰੁʼਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","ਤਦਨਨ੍ਤਰੰ ਪੌਲਸ੍ਤਤ੍ਸਙ੍ਗਿਨੌ ਚ ਪਾਫਨਗਰਾਤ੍ ਪ੍ਰੋਤੰ ਚਾਲਯਿਤ੍ਵਾ ਪਮ੍ਫੁਲਿਯਾਦੇਸ਼ਸ੍ਯ ਪਰ੍ਗੀਨਗਰਮ੍ ਅਗੱਛਨ੍ ਕਿਨ੍ਤੁ ਯੋਹਨ੍ ਤਯੋਃ ਸਮੀਪਾਦ੍ ਏਤ੍ਯ ਯਿਰੂਸ਼ਾਲਮੰ ਪ੍ਰਤ੍ਯਾਗੱਛਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","ਪਸ਼੍ਚਾਤ੍ ਤੌ ਪਰ੍ਗੀਤੋ ਯਾਤ੍ਰਾਂ ਕ੍ਰੁʼਤ੍ਵਾ ਪਿਸਿਦਿਯਾਦੇਸ਼ਸ੍ਯ ਆਨ੍ਤਿਯਖਿਯਾਨਗਰਮ੍ ਉਪਸ੍ਥਾਯ ਵਿਸ਼੍ਰਾਮਵਾਰੇ ਭਜਨਭਵਨੰ ਪ੍ਰਵਿਸ਼੍ਯ ਸਮੁਪਾਵਿਸ਼ਤਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ਵ੍ਯਵਸ੍ਥਾਭਵਿਸ਼਼੍ਯਦ੍ਵਾਕ੍ਯਯੋਃ ਪਠਿਤਯੋਃ ਸਤੋ ਰ੍ਹੇ ਭ੍ਰਾਤਰੌ ਲੋਕਾਨ੍ ਪ੍ਰਤਿ ਯੁਵਯੋਃ ਕਾਚਿਦ੍ ਉਪਦੇਸ਼ਕਥਾ ਯਦ੍ਯਸ੍ਤਿ ਤਰ੍ਹਿ ਤਾਂ ਵਦਤੰ ਤੌ ਪ੍ਰਤਿ ਤਸ੍ਯ ਭਜਨਭਵਨਸ੍ਯਾਧਿਪਤਯਃ ਕਥਾਮ੍ ਏਤਾਂ ਕਥਯਿਤ੍ਵਾ ਪ੍ਰੈਸ਼਼ਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ਅਤਃ ਪੌਲ ਉੱਤਿਸ਼਼੍ਠਨ੍ ਹਸ੍ਤੇਨ ਸਙ੍ਕੇਤੰ ਕੁਰ੍ੱਵਨ੍ ਕਥਿਤਵਾਨ੍ ਹੇ ਇਸ੍ਰਾਯੇਲੀਯਮਨੁਸ਼਼੍ਯਾ ਈਸ਼੍ਵਰਪਰਾਯਣਾਃ ਸਰ੍ੱਵੇ ਲੋਕਾ ਯੂਯਮ੍ ਅਵਧੱਧੰ| ");
INSERT INTO sanpun_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ਏਤੇਸ਼਼ਾਮਿਸ੍ਰਾਯੇੱਲੋਕਾਨਾਮ੍ ਈਸ਼੍ਵਰੋ(ਅ)ਸ੍ਮਾਕੰ ਪੂਰ੍ੱਵਪਰੁਸ਼਼ਾਨ੍ ਮਨੋਨੀਤਾਨ੍ ਕਤ੍ਵਾ ਗ੍ਰੁʼਹੀਤਵਾਨ੍ ਤਤੋ ਮਿਸਰਿ ਦੇਸ਼ੇ ਪ੍ਰਵਸਨਕਾਲੇ ਤੇਸ਼਼ਾਮੁੰਨਤਿੰ ਕ੍ਰੁʼਤ੍ਵਾ ਤਸ੍ਮਾਤ੍ ਸ੍ਵੀਯਬਾਹੁਬਲੇਨ ਤਾਨ੍ ਬਹਿਃ ਕ੍ਰੁʼਤ੍ਵਾ ਸਮਾਨਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ਚਤ੍ਵਾਰਿੰਸ਼ਦ੍ਵਤ੍ਸਰਾਨ੍ ਯਾਵੱਚ ਮਹਾਪ੍ਰਾਨ੍ਤਰੇ ਤੇਸ਼਼ਾਂ ਭਰਣੰ ਕ੍ਰੁʼਤ੍ਵਾ ");
INSERT INTO sanpun_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ਕਿਨਾਨ੍ਦੇਸ਼ਾਨ੍ਤਰ੍ੱਵਰ੍ੱਤੀਣਿ ਸਪ੍ਤਰਾਜ੍ਯਾਨਿ ਨਾਸ਼ਯਿਤ੍ਵਾ ਗੁਟਿਕਾਪਾਤੇਨ ਤੇਸ਼਼ੁ ਸਰ੍ੱਵਦੇਸ਼ੇਸ਼਼ੁ ਤੇਭ੍ਯੋ(ਅ)ਧਿਕਾਰੰ ਦੱਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ਪਞ੍ਚਾਸ਼ਦਧਿਕਚਤੁਃਸ਼ਤੇਸ਼਼ੁ ਵਤ੍ਸਰੇਸ਼਼ੁ ਗਤੇਸ਼਼ੁ ਚ ਸ਼ਿਮੂਯੇਲ੍ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਪਰ੍ੱਯਨ੍ਤੰ ਤੇਸ਼਼ਾਮੁਪਰਿ ਵਿਚਾਰਯਿਤ੍ਰੁʼਨ੍ ਨਿਯੁਕ੍ਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","ਤੈਸ਼੍ਚ ਰਾਜ੍ਞਿ ਪ੍ਰਾਰ੍ਥਿਤੇ, ਈਸ਼੍ਵਰੋ ਬਿਨ੍ਯਾਮੀਨੋ ਵੰਸ਼ਜਾਤਸ੍ਯ ਕੀਸ਼ਃ ਪੁਤ੍ਰੰ ਸ਼ੌਲੰ ਚਤ੍ਵਾਰਿੰਸ਼ਦ੍ਵਰ੍ਸ਼਼ਪਰ੍ੱਯਨ੍ਤੰ ਤੇਸ਼਼ਾਮੁਪਰਿ ਰਾਜਾਨੰ ਕ੍ਰੁʼਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","ਪਸ਼੍ਚਾਤ੍ ਤੰ ਪਦਚ੍ਯੁਤੰ ਕ੍ਰੁʼਤ੍ਵਾ ਯੋ ਮਦਿਸ਼਼੍ਟਕ੍ਰਿਯਾਃ ਸਰ੍ੱਵਾਃ ਕਰਿਸ਼਼੍ਯਤਿ ਤਾਦ੍ਰੁʼਸ਼ੰ ਮਮ ਮਨੋਭਿਮਤਮ੍ ਏਕੰ ਜਨੰ ਯਿਸ਼ਯਃ ਪੁਤ੍ਰੰ ਦਾਯੂਦੰ ਪ੍ਰਾਪ੍ਤਵਾਨ੍ ਇਦੰ ਪ੍ਰਮਾਣੰ ਯਸ੍ਮਿਨ੍ ਦਾਯੂਦਿ ਸ ਦੱਤਵਾਨ੍ ਤੰ ਦਾਯੂਦੰ ਤੇਸ਼਼ਾਮੁਪਰਿ ਰਾਜਤ੍ਵੰ ਕਰ੍ੱਤੁਮ੍ ਉਤ੍ਪਾਦਿਤਵਾਨ| ");
INSERT INTO sanpun_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","ਤਸ੍ਯ ਸ੍ਵਪ੍ਰਤਿਸ਼੍ਰੁਤਸ੍ਯ ਵਾਕ੍ਯਸ੍ਯਾਨੁਸਾਰੇਣ ਇਸ੍ਰਾਯੇੱਲੋਕਾਨਾਂ ਨਿਮਿੱਤੰ ਤੇਸ਼਼ਾਂ ਮਨੁਸ਼਼੍ਯਾਣਾਂ ਵੰਸ਼ਾਦ੍ ਈਸ਼੍ਵਰ ਏਕੰ ਯੀਸ਼ੁੰ (ਤ੍ਰਾਤਾਰਮ੍) ਉਦਪਾਦਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","ਤਸ੍ਯ ਪ੍ਰਕਾਸ਼ਨਾਤ੍ ਪੂਰ੍ੱਵੰ ਯੋਹਨ੍ ਇਸ੍ਰਾਯੇੱਲੋਕਾਨਾਂ ਸੰਨਿਧੌ ਮਨਃਪਰਾਵਰ੍ੱਤਨਰੂਪੰ ਮੱਜਨੰ ਪ੍ਰਾਚਾਰਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ਯਸ੍ਯ ਚ ਕਰ੍ੰਮਣੋे ਭਾਰੰ ਪ੍ਰਪ੍ਤਵਾਨ੍ ਯੋਹਨ੍ ਤਨ੍ ਨਿਸ਼਼੍ਪਾਦਯਨ੍ ਏਤਾਂ ਕਥਾਂ ਕਥਿਤਵਾਨ੍, ਯੂਯੰ ਮਾਂ ਕੰ ਜਨੰ ਜਾਨੀਥ? ਅਹਮ੍ ਅਭਿਸ਼਼ਿਕ੍ਤਤ੍ਰਾਤਾ ਨਹਿ, ਕਿਨ੍ਤੁ ਪਸ਼੍ਯਤ ਯਸ੍ਯ ਪਾਦਯੋਃ ਪਾਦੁਕਯੋ ਰ੍ਬਨ੍ਧਨੇ ਮੋਚਯਿਤੁਮਪਿ ਯੋਗ੍ਯੋ ਨ ਭਵਾਮਿ ਤਾਦ੍ਰੁʼਸ਼ ਏਕੋ ਜਨੋ ਮਮ ਪਸ਼੍ਚਾਦ੍ ਉਪਤਿਸ਼਼੍ਠਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","ਹੇ ਇਬ੍ਰਾਹੀਮੋ ਵੰਸ਼ਜਾਤਾ ਭ੍ਰਾਤਰੋ ਹੇ ਈਸ਼੍ਵਰਭੀਤਾਃ ਸਰ੍ੱਵਲੋਕਾ ਯੁਸ਼਼੍ਮਾਨ੍ ਪ੍ਰਤਿ ਪਰਿਤ੍ਰਾਣਸ੍ਯ ਕਥੈਸ਼਼ਾ ਪ੍ਰੇਰਿਤਾ| ");
INSERT INTO sanpun_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","ਯਿਰੂਸ਼ਾਲਮ੍ਨਿਵਾਸਿਨਸ੍ਤੇਸ਼਼ਾਮ੍ ਅਧਿਪਤਯਸ਼੍ਚ ਤਸ੍ਯ ਯੀਸ਼ੋਃ ਪਰਿਚਯੰ ਨ ਪ੍ਰਾਪ੍ਯ ਪ੍ਰਤਿਵਿਸ਼੍ਰਾਮਵਾਰੰ ਪਠ੍ਯਮਾਨਾਨਾਂ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਕਥਾਨਾਮ੍ ਅਭਿਪ੍ਰਾਯਮ੍ ਅਬੁੱਧ੍ਵਾ ਚ ਤਸ੍ਯ ਵਧੇਨ ਤਾਃ ਕਥਾਃ ਸਫਲਾ ਅਕੁਰ੍ੱਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","ਪ੍ਰਾਣਹਨਨਸ੍ਯ ਕਮਪਿ ਹੇਤੁਮ੍ ਅਪ੍ਰਾਪ੍ਯਾਪਿ ਪੀਲਾਤਸ੍ਯ ਨਿਕਟੇ ਤਸ੍ਯ ਵਧੰ ਪ੍ਰਾਰ੍ਥਯਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","ਤਸ੍ਮਿਨ੍ ਯਾਃ ਕਥਾ ਲਿਖਿਤਾਃ ਸਨ੍ਤਿ ਤਦਨੁਸਾਰੇਣ ਕਰ੍ੰਮ ਸਮ੍ਪਾਦ੍ਯ ਤੰ ਕ੍ਰੁਸ਼ਾਦ੍ ਅਵਤਾਰ੍ੱਯ ਸ਼੍ਮਸ਼ਾਨੇ ਸ਼ਾਯਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","ਕਿਨ੍ਤ੍ਵੀਸ਼੍ਵਰਃ ਸ਼੍ਮਸ਼ਾਨਾਤ੍ ਤਮੁਦਸ੍ਥਾਪਯਤ੍, ");
INSERT INTO sanpun_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ਪੁਨਸ਼੍ਚ ਗਾਲੀਲਪ੍ਰਦੇਸ਼ਾਦ੍ ਯਿਰੂਸ਼ਾਲਮਨਗਰੰ ਤੇਨ ਸਾਰ੍ੱਧੰ ਯੇ ਲੋਕਾ ਆਗੱਛਨ੍ ਸ ਬਹੁਦਿਨਾਨਿ ਤੇਭ੍ਯੋ ਦਰ੍ਸ਼ਨੰ ਦੱਤਵਾਨ੍, ਅਤਸ੍ਤ ਇਦਾਨੀਂ ਲੋਕਾਨ੍ ਪ੍ਰਤਿ ਤਸ੍ਯ ਸਾਕ੍ਸ਼਼ਿਣਃ ਸਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","ਅਸ੍ਮਾਕੰ ਪੂਰ੍ੱਵਪੁਰੁਸ਼਼ਾਣਾਂ ਸਮਕ੍ਸ਼਼ਮ੍ ਈਸ਼੍ਵਰੋ ਯਸ੍ਮਿਨ੍ ਪ੍ਰਤਿਜ੍ਞਾਤਵਾਨ੍ ਯਥਾ, ਤ੍ਵੰ ਮੇ ਪੁਤ੍ਰੋਸਿ ਚਾਦ੍ਯ ਤ੍ਵਾਂ ਸਮੁੱਥਾਪਿਤਵਾਨਹਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ਇਦੰ ਯਦ੍ਵਚਨੰ ਦ੍ਵਿਤੀਯਗੀਤੇ ਲਿਖਿਤਮਾਸ੍ਤੇ ਤਦ੍ ਯੀਸ਼ੋਰੁੱਥਾਨੇਨ ਤੇਸ਼਼ਾਂ ਸਨ੍ਤਾਨਾ ਯੇ ਵਯਮ੍ ਅਸ੍ਮਾਕੰ ਸੰਨਿਧੌ ਤੇਨ ਪ੍ਰਤ੍ਯਕ੍ਸ਼਼ੀ ਕ੍ਰੁʼਤੰ, ਯੁਸ਼਼੍ਮਾਨ੍ ਇਮੰ ਸੁਸੰਵਾਦੰ ਜ੍ਞਾਪਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","ਪਰਮੇਸ਼੍ਵਰੇਣ ਸ਼੍ਮਸ਼ਾਨਾਦ੍ ਉੱਥਾਪਿਤੰ ਤਦੀਯੰ ਸ਼ਰੀਰੰ ਕਦਾਪਿ ਨ ਕ੍ਸ਼਼ੇਸ਼਼੍ਯਤੇ, ਏਤਸ੍ਮਿਨ੍ ਸ ਸ੍ਵਯੰ ਕਥਿਤਵਾਨ੍ ਯਥਾ ਦਾਯੂਦੰ ਪ੍ਰਤਿ ਪ੍ਰਤਿਜ੍ਞਾਤੋ ਯੋ ਵਰਸ੍ਤਮਹੰ ਤੁਭ੍ਯੰ ਦਾਸ੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","ਏਤਦਨ੍ਯਸ੍ਮਿਨ੍ ਗੀਤੇ(ਅ)ਪਿ ਕਥਿਤਵਾਨ੍| ਸ੍ਵਕੀਯੰ ਪੁਣ੍ਯਵਨ੍ਤੰ ਤ੍ਵੰ ਕ੍ਸ਼਼ਯਿਤੁੰ ਨ ਚ ਦਾਸ੍ਯਸਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","ਦਾਯੂਦਾ ਈਸ਼੍ਵਰਾਭਿਮਤਸੇਵਾਯੈ ਨਿਜਾਯੁਸ਼਼ਿ ਵ੍ਯਯਿਤੇ ਸਤਿ ਸ ਮਹਾਨਿਦ੍ਰਾਂ ਪ੍ਰਾਪ੍ਯ ਨਿਜੈਃ ਪੂਰ੍ੱਵਪੁਰੁਸ਼਼ੈਃ ਸਹ ਮਿਲਿਤਃ ਸਨ੍ ਅਕ੍ਸ਼਼ੀਯਤ; ");
INSERT INTO sanpun_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","ਕਿਨ੍ਤੁ ਯਮੀਸ਼੍ਵਰਃ ਸ਼੍ਮਸ਼ਾਨਾਦ੍ ਉਦਸ੍ਥਾਪਯਤ੍ ਸ ਨਾਕ੍ਸ਼਼ੀਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","ਅਤੋ ਹੇ ਭ੍ਰਾਤਰਃ, ਅਨੇਨ ਜਨੇਨ ਪਾਪਮੋਚਨੰ ਭਵਤੀਤਿ ਯੁਸ਼਼੍ਮਾਨ੍ ਪ੍ਰਤਿ ਪ੍ਰਚਾਰਿਤਮ੍ ਆਸ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ਫਲਤੋ ਮੂਸਾਵ੍ਯਵਸ੍ਥਯਾ ਯੂਯੰ ਯੇਭ੍ਯੋ ਦੋਸ਼਼ੇਭ੍ਯੋ ਮੁਕ੍ਤਾ ਭਵਿਤੁੰ ਨ ਸ਼ਕ੍ਸ਼਼੍ਯਥ ਤੇਭ੍ਯਃ ਸਰ੍ੱਵਦੋਸ਼਼ੇਭ੍ਯ ਏਤਸ੍ਮਿਨ੍ ਜਨੇ ਵਿਸ਼੍ਵਾਸਿਨਃ ਸਰ੍ੱਵੇ ਮੁਕ੍ਤਾ ਭਵਿਸ਼਼੍ਯਨ੍ਤੀਤਿ ਯੁਸ਼਼੍ਮਾਭਿ ਰ੍ਜ੍ਞਾਯਤਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","ਅਪਰਞ੍ਚ| ਅਵਜ੍ਞਾਕਾਰਿਣੋ ਲੋਕਾਸ਼੍ਚਕ੍ਸ਼਼ੁਰੁਨ੍ਮੀਲ੍ਯ ਪਸ਼੍ਯਤ| ਤਥੈਵਾਸਮ੍ਭਵੰ ਜ੍ਞਾਤ੍ਵਾ ਸ੍ਯਾਤ ਯੂਯੰ ਵਿਲੱਜਿਤਾਃ| ਯਤੋ ਯੁਸ਼਼੍ਮਾਸੁ ਤਿਸ਼਼੍ਠਤ੍ਸੁ ਕਰਿਸ਼਼੍ਯੇ ਕਰ੍ੰਮ ਤਾਦ੍ਰੁʼਸ਼ੰ| ਯੇਨੈਵ ਤਸ੍ਯ ਵ੍ਰੁʼੱਤਾਨ੍ਤੇ ਯੁਸ਼਼੍ਮਭ੍ਯੰ ਕਥਿਤੇ(ਅ)ਪਿ ਹਿ| ਯੂਯੰ ਨ ਤਨ੍ਤੁ ਵ੍ਰੁʼੱਤਾਨ੍ਤੰ ਪ੍ਰਤ੍ਯੇਸ਼਼੍ਯਥ ਕਦਾਚਨ|| ");
INSERT INTO sanpun_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","ਯੇਯੰ ਕਥਾ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਾਂ ਗ੍ਰਨ੍ਥੇਸ਼਼ੁ ਲਿਖਿਤਾਸ੍ਤੇ ਸਾਵਧਾਨਾ ਭਵਤ ਸ ਕਥਾ ਯਥਾ ਯੁਸ਼਼੍ਮਾਨ੍ ਪ੍ਰਤਿ ਨ ਘਟਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ਯਿਹੂਦੀਯਭਜਨਭਵਨਾਨ੍ ਨਿਰ੍ਗਤਯੋਸ੍ਤਯੋ ਰ੍ਭਿੰਨਦੇਸ਼ੀਯੈ ਰ੍ਵਕ੍ਸ਼਼੍ਯਮਾਣਾ ਪ੍ਰਾਰ੍ਥਨਾ ਕ੍ਰੁʼਤਾ, ਆਗਾਮਿਨਿ ਵਿਸ਼੍ਰਾਮਵਾਰੇ(ਅ)ਪਿ ਕਥੇਯਮ੍ ਅਸ੍ਮਾਨ੍ ਪ੍ਰਤਿ ਪ੍ਰਚਾਰਿਤਾ ਭਵਤ੍ਵਿਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","ਸਭਾਯਾ ਭਙ੍ਗੇ ਸਤਿ ਬਹਵੋ ਯਿਹੂਦੀਯਲੋਕਾ ਯਿਹੂਦੀਯਮਤਗ੍ਰਾਹਿਣੋ ਭਕ੍ਤਲੋਕਾਸ਼੍ਚ ਬਰ੍ਣੱਬਾਪੌਲਯੋਃ ਪਸ਼੍ਚਾਦ੍ ਆਗੱਛਨ੍, ਤੇਨ ਤੌ ਤੈਃ ਸਹ ਨਾਨਾਕਥਾਃ ਕਥਯਿਤ੍ਵੇਸ਼੍ਵਰਾਨੁਗ੍ਰਹਾਸ਼੍ਰਯੇ ਸ੍ਥਾਤੁੰ ਤਾਨ੍ ਪ੍ਰਾਵਰ੍ੱਤਯਤਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","ਪਰਵਿਸ਼੍ਰਾਮਵਾਰੇ ਨਗਰਸ੍ਯ ਪ੍ਰਾਯੇਣ ਸਰ੍ੱਵੇ ਲਾਕਾ ਈਸ਼੍ਵਰੀਯਾਂ ਕਥਾਂ ਸ਼੍ਰੋਤੁੰ ਮਿਲਿਤਾਃ, ");
INSERT INTO sanpun_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","ਕਿਨ੍ਤੁ ਯਿਹੂਦੀਯਲੋਕਾ ਜਨਨਿਵਹੰ ਵਿਲੋਕ੍ਯ ਈਰ੍ਸ਼਼੍ਯਯਾ ਪਰਿਪੂਰ੍ਣਾਃ ਸਨ੍ਤੋ ਵਿਪਰੀਤਕਥਾਕਥਨੇਨੇਸ਼੍ਵਰਨਿਨ੍ਦਯਾ ਚ ਪੌਲੇਨੋਕ੍ਤਾਂ ਕਥਾਂ ਖਣ੍ਡਯਿਤੁੰ ਚੇਸ਼਼੍ਟਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","ਤਤਃ ਪੌैਲਬਰ੍ਣੱਬਾਵਕ੍ਸ਼਼ੋਭੌ ਕਥਿਤਵਨ੍ਤੌ ਪ੍ਰਥਮੰ ਯੁਸ਼਼੍ਮਾਕੰ ਸੰਨਿਧਾਵੀਸ਼੍ਵਰੀਯਕਥਾਯਾਃ ਪ੍ਰਚਾਰਣਮ੍ ਉਚਿਤਮਾਸੀਤ੍ ਕਿਨ੍ਤੁੰ ਤਦਗ੍ਰਾਹ੍ਯਤ੍ਵਕਰਣੇਨ ਯੂਯੰ ਸ੍ਵਾਨ੍ ਅਨਨ੍ਤਾਯੁਸ਼਼ੋ(ਅ)ਯੋਗ੍ਯਾਨ੍ ਦਰ੍ਸ਼ਯਥ, ਏਤਤ੍ਕਾਰਣਾਦ੍ ਵਯਮ੍ ਅਨ੍ਯਦੇਸ਼ੀਯਲੋਕਾਨਾਂ ਸਮੀਪੰ ਗੱਛਾਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ਪ੍ਰਭੁਰਸ੍ਮਾਨ੍ ਇੱਥਮ੍ ਆਦਿਸ਼਼੍ਟਵਾਨ੍ ਯਥਾ, ਯਾਵੱਚ ਜਗਤਃ ਸੀਮਾਂ ਲੋਕਾਨਾਂ ਤ੍ਰਾਣਕਾਰਣਾਤ੍| ਮਯਾਨ੍ਯਦੇਸ਼ਮਧ੍ਯੇ ਤ੍ਵੰ ਸ੍ਥਾਪਿਤੋ ਭੂਃ ਪ੍ਰਦੀਪਵਤ੍|| ");
INSERT INTO sanpun_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","ਤਦਾ ਕਥਾਮੀਦ੍ਰੁʼਸ਼ੀਂ ਸ਼੍ਰੁਤ੍ਵਾ ਭਿੰਨਦੇਸ਼ੀਯਾ ਆਹ੍ਲਾਦਿਤਾਃ ਸਨ੍ਤਃ ਪ੍ਰਭੋਃ ਕਥਾਂ ਧਨ੍ਯਾਂ ਧਨ੍ਯਾਮ੍ ਅਵਦਨ੍, ਯਾਵਨ੍ਤੋ ਲੋਕਾਸ਼੍ਚ ਪਰਮਾਯੁਃ ਪ੍ਰਾਪ੍ਤਿਨਿਮਿੱਤੰ ਨਿਰੂਪਿਤਾ ਆਸਨ੍ ਤੇे ਵ੍ਯਸ਼੍ਵਸਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ਇੱਥੰ ਪ੍ਰਭੋਃ ਕਥਾ ਸਰ੍ੱਵੇਦੇਸ਼ੰ ਵ੍ਯਾਪ੍ਨੋਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","ਕਿਨ੍ਤੁ ਯਿਹੂਦੀਯਾ ਨਗਰਸ੍ਯ ਪ੍ਰਧਾਨਪੁਰੁਸ਼਼ਾਨ੍ ਸੰਮਾਨ੍ਯਾਃ ਕਥਿਪਯਾ ਭਕ੍ਤਾ ਯੋਸ਼਼ਿਤਸ਼੍ਚ ਕੁਪ੍ਰਵ੍ਰੁʼੱਤਿੰ ਗ੍ਰਾਹਯਿਤ੍ਵਾ ਪੌਲਬਰ੍ਣੱਬੌ ਤਾਡਯਿਤ੍ਵਾ ਤਸ੍ਮਾਤ੍ ਪ੍ਰਦੇਸ਼ਾਦ੍ ਦੂਰੀਕ੍ਰੁʼਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","ਅਤਃ ਕਾਰਣਾਤ੍ ਤੌ ਨਿਜਪਦਧੂਲੀਸ੍ਤੇਸ਼਼ਾਂ ਪ੍ਰਾਤਿਕੂਲ੍ਯੇਨ ਪਾਤਯਿਤ੍ਵੇेਕਨਿਯੰ ਨਗਰੰ ਗਤੌ| ");
INSERT INTO sanpun_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","ਤਤਃ ਸ਼ਿਸ਼਼੍ਯਗਣ ਆਨਨ੍ਦੇਨ ਪਵਿਤ੍ਰੇਣਾਤ੍ਮਨਾ ਚ ਪਰਿਪੂਰ੍ਣੋਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","ਤੌ ਦ੍ਵੌ ਜਨੌ ਯੁਗਪਦ੍ ਇਕਨਿਯਨਗਰਸ੍ਥਯਿਹੂਦੀਯਾਨਾਂ ਭਜਨਭਵਨੰ ਗਤ੍ਵਾ ਯਥਾ ਬਹਵੋ ਯਿਹੂਦੀਯਾ ਅਨ੍ਯਦੇेਸ਼ੀਯਲੋਕਾਸ਼੍ਚ ਵ੍ਯਸ਼੍ਵਸਨ੍ ਤਾਦ੍ਰੁʼਸ਼ੀਂ ਕਥਾਂ ਕਥਿਤਵਨ੍ਤੌ| ");
INSERT INTO sanpun_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","ਕਿਨ੍ਤੁ ਵਿਸ਼੍ਵਾਸਹੀਨਾ ਯਿਹੂਦੀਯਾ ਅਨ੍ਯਦੇਸ਼ੀਯਲੋਕਾਨ੍ ਕੁਪ੍ਰਵ੍ਰੁʼੱਤਿੰ ਗ੍ਰਾਹਯਿਤ੍ਵਾ ਭ੍ਰਾਤ੍ਰੁʼਗਣੰ ਪ੍ਰਤਿ ਤੇਸ਼਼ਾਂ ਵੈਰੰ ਜਨਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ਅਤਃ ਸ੍ਵਾਨੁਗ੍ਰਹਕਥਾਯਾਃ ਪ੍ਰਮਾਣੰ ਦਤ੍ਵਾ ਤਯੋ ਰ੍ਹਸ੍ਤੈ ਰ੍ਬਹੁਲਕ੍ਸ਼਼ਣਮ੍ ਅਦ੍ਭੁਤਕਰ੍ੰਮ ਚ ਪ੍ਰਾਕਾਸ਼ਯਦ੍ ਯਃ ਪ੍ਰਭੁਸ੍ਤਸ੍ਯ ਕਥਾ ਅਕ੍ਸ਼਼ੋਭੇਨ ਪ੍ਰਚਾਰ੍ੱਯ ਤੌ ਤਤ੍ਰ ਬਹੁਦਿਨਾਨਿ ਸਮਵਾਤਿਸ਼਼੍ਠੇਤਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","ਕਿਨ੍ਤੁ ਕਿਯਨ੍ਤੋ ਲੋਕਾ ਯਿਹੂਦੀਯਾਨਾਂ ਸਪਕ੍ਸ਼਼ਾਃ ਕਿਯਨ੍ਤੋ ਲੋਕਾਃ ਪ੍ਰੇਰਿਤਾਨਾਂ ਸਪਕ੍ਸ਼਼ਾ ਜਾਤਾਃ, ਅਤੋ ਨਾਗਰਿਕਜਨਨਿਵਹਮਧ੍ਯੇ ਭਿੰਨਵਾਕ੍ਯਤ੍ਵਮ੍ ਅਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","ਅਨ੍ਯਦੇਸ਼ੀਯਾ ਯਿਹੂਦੀਯਾਸ੍ਤੇਸ਼਼ਾਮ੍ ਅਧਿਪਤਯਸ਼੍ਚ ਦੌਰਾਤ੍ਮ੍ਯੰ ਕੁਤ੍ਵਾ ਤੌ ਪ੍ਰਸ੍ਤਰੈਰਾਹਨ੍ਤੁਮ੍ ਉਦ੍ਯਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ਤੌ ਤਦ੍ਵਾਰ੍ੱਤਾਂ ਪ੍ਰਾਪ੍ਯ ਪਲਾਯਿਤ੍ਵਾ ਲੁਕਾਯਨਿਯਾਦੇਸ਼ਸ੍ਯਾਨ੍ਤਰ੍ੱਵਰ੍ੱਤਿਲੁਸ੍ਤ੍ਰਾਦਰ੍ੱਬੋ ");
INSERT INTO sanpun_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ਤਤ੍ਸਮੀਪਸ੍ਥਦੇਸ਼ਞ੍ਚ ਗਤ੍ਵਾ ਤਤ੍ਰ ਸੁਸੰਵਾਦੰ ਪ੍ਰਚਾਰਯਤਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","ਤਤ੍ਰੋਭਯਪਾਦਯੋਸ਼੍ਚਲਨਸ਼ਕ੍ਤਿਹੀਨੋ ਜਨ੍ਮਾਰਭ੍ਯ ਖਞ੍ਜਃ ਕਦਾਪਿ ਗਮਨੰ ਨਾਕਰੋਤ੍ ਏਤਾਦ੍ਰੁʼਸ਼ ਏਕੋ ਮਾਨੁਸ਼਼ੋ ਲੁਸ੍ਤ੍ਰਾਨਗਰ ਉਪਵਿਸ਼੍ਯ ਪੌਲਸ੍ਯ ਕਥਾਂ ਸ਼੍ਰੁਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ਏਤਸ੍ਮਿਨ੍ ਸਮਯੇ ਪੌਲਸ੍ਤਮ੍ਪ੍ਰਤਿ ਦ੍ਰੁʼਸ਼਼੍ਟਿੰ ਕ੍ਰੁʼਤ੍ਵਾ ਤਸ੍ਯ ਸ੍ਵਾਸ੍ਥ੍ਯੇ ਵਿਸ਼੍ਵਾਸੰ ਵਿਦਿਤ੍ਵਾ ਪ੍ਰੋੱਚੈਃ ਕਥਿਤਵਾਨ੍ ");
INSERT INTO sanpun_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ਪਦ੍ਭ੍ਯਾਮੁੱਤਿਸ਼਼੍ਠਨ੍ ਰੁʼਜੁ ਰ੍ਭਵ| ਤਤਃ ਸ ਉੱਲਮ੍ਫੰ ਕ੍ਰੁʼਤ੍ਵਾ ਗਮਨਾਗਮਨੇ ਕੁਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","ਤਦਾ ਲੋਕਾਃ ਪੌਲਸ੍ਯ ਤਤ੍ ਕਾਰ੍ੱਯੰ ਵਿਲੋਕ੍ਯ ਲੁਕਾਯਨੀਯਭਾਸ਼਼ਯਾ ਪ੍ਰੋੱਚੈਃ ਕਥਾਮੇਤਾਂ ਕਥਿਤਵਨ੍ਤਃ, ਦੇਵਾ ਮਨੁਸ਼਼੍ਯਰੂਪੰ ਧ੍ਰੁʼਤ੍ਵਾਸ੍ਮਾਕੰ ਸਮੀਪਮ੍ ਅਵਾਰੋਹਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","ਤੇ ਬਰ੍ਣੱਬਾਂ ਯੂਪਿਤਰਮ੍ ਅਵਦਨ੍ ਪੌਲਸ਼੍ਚ ਮੁਖ੍ਯੋ ਵਕ੍ਤਾ ਤਸ੍ਮਾਤ੍ ਤੰ ਮਰ੍ਕੁਰਿਯਮ੍ ਅਵਦਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ਤਸ੍ਯ ਨਗਰਸ੍ਯ ਸੰਮੁਖੇ ਸ੍ਥਾਪਿਤਸ੍ਯ ਯੂਪਿਤਰਵਿਗ੍ਰਹਸ੍ਯ ਯਾਜਕੋ ਵ੍ਰੁʼਸ਼਼ਾਨ੍ ਪੁਸ਼਼੍ਪਮਾਲਾਸ਼੍ਚ ਦ੍ਵਾਰਸਮੀਪਮ੍ ਆਨੀਯ ਲੋਕੈਃ ਸਰ੍ੱਧੰ ਤਾਵੁੱਦਿਸ਼੍ਯ ਸਮੁਤ੍ਸ੍ਰੁʼਜ੍ਯ ਦਾਤੁਮ੍ ਉਦ੍ਯਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","ਤਦ੍ਵਾਰ੍ੱਤਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਬਰ੍ਣੱਬਾਪੌਲੌ ਸ੍ਵੀਯਵਸ੍ਤ੍ਰਾਣਿ ਛਿਤ੍ਵਾ ਲੋਕਾਨਾਂ ਮਧ੍ਯੰ ਵੇਗੇਨ ਪ੍ਰਵਿਸ਼੍ਯ ਪ੍ਰੋੱਚੈਃ ਕਥਿਤਵਨ੍ਤੌ, ");
INSERT INTO sanpun_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","ਹੇ ਮਹੇੱਛਾਃ ਕੁਤ ਏਤਾਦ੍ਰੁʼਸ਼ੰ ਕਰ੍ੰਮ ਕੁਰੁਥ? ਆਵਾਮਪਿ ਯੁਸ਼਼੍ਮਾਦ੍ਰੁʼਸ਼ੌ ਸੁਖਦੁਃਖਭੋਗਿਨੌ ਮਨੁਸ਼਼੍ਯੌ, ਯੁਯਮ੍ ਏਤਾਃ ਸਰ੍ੱਵਾ ਵ੍ਰੁʼਥਾਕਲ੍ਪਨਾਃ ਪਰਿਤ੍ਯਜ੍ਯ ਯਥਾ ਗਗਣਵਸੁਨ੍ਧਰਾਜਲਨਿਧੀਨਾਂ ਤਨ੍ਮਧ੍ਯਸ੍ਥਾਨਾਂ ਸਰ੍ੱਵੇਸ਼਼ਾਞ੍ਚ ਸ੍ਰਸ਼਼੍ਟਾਰਮਮਰਮ੍ ਈਸ਼੍ਵਰੰ ਪ੍ਰਤਿ ਪਰਾਵਰ੍ੱਤਧ੍ਵੇ ਤਦਰ੍ਥਮ੍ ਆਵਾਂ ਯੁਸ਼਼੍ਮਾਕੰ ਸੰਨਿਧੌ ਸੁਸੰਵਾਦੰ ਪ੍ਰਚਾਰਯਾਵਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ਸ ਈਸ਼੍ਵਰਃ ਪੂਰ੍ੱਵਕਾਲੇ ਸਰ੍ੱਵਦੇਸ਼ੀਯਲੋਕਾਨ੍ ਸ੍ਵਸ੍ਵਮਾਰ੍ਗੇ ਚਲਿਤੁਮਨੁਮਤਿੰ ਦੱਤਵਾਨ੍, ");
INSERT INTO sanpun_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ਤਥਾਪਿ ਆਕਾਸ਼ਾਤ੍ ਤੋਯਵਰ੍ਸ਼਼ਣੇਨ ਨਾਨਾਪ੍ਰਕਾਰਸ਼ਸ੍ਯੋਤ੍ਪਤ੍ਯਾ ਚ ਯੁਸ਼਼੍ਮਾਕੰ ਹਿਤੈਸ਼਼ੀ ਸਨ੍ ਭਕ੍ਸ਼਼੍ਯੈਰਾਨਨਦੇਨ ਚ ਯੁਸ਼਼੍ਮਾਕਮ੍ ਅਨ੍ਤਃਕਰਣਾਨਿ ਤਰ੍ਪਯਨ੍ ਤਾਨਿ ਦਾਨਾਨਿ ਨਿਜਸਾਕ੍ਸ਼਼ਿਸ੍ਵਰੂਪਾਣਿ ਸ੍ਥਪਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","ਕਿਨ੍ਤੁ ਤਾਦ੍ਰੁʼਸ਼ਾਯਾਂ ਕਥਾਯਾਂ ਕਥਿਤਾਯਾਮਪਿ ਤਯੋਃ ਸਮੀਪ ਉਤ੍ਸਰ੍ਜਨਾਤ੍ ਲੋਕਨਿਵਹੰ ਪ੍ਰਾਯੇਣ ਨਿਵਰ੍ੱਤਯਿਤੁੰ ਨਾਸ਼ਕ੍ਨੁਤਾਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","ਆਨ੍ਤਿਯਖਿਯਾ-ਇਕਨਿਯਨਗਰਾਭ੍ਯਾਂ ਕਤਿਪਯਯਿਹੂਦੀਯਲੋਕਾ ਆਗਤ੍ਯ ਲੋਕਾਨ੍ ਪ੍ਰਾਵਰ੍ੱਤਯਨ੍ਤ ਤਸ੍ਮਾਤ੍ ਤੈ ਪੌਲੰ ਪ੍ਰਸ੍ਤਰੈਰਾਘ੍ਨਨ੍ ਤੇਨ ਸ ਮ੍ਰੁʼਤ ਇਤਿ ਵਿਜ੍ਞਾਯ ਨਗਰਸ੍ਯ ਬਹਿਸ੍ਤਮ੍ ਆਕ੍ਰੁʼਸ਼਼੍ਯ ਨੀਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","ਕਿਨ੍ਤੁ ਸ਼ਿਸ਼਼੍ਯਗਣੇ ਤਸ੍ਯ ਚਤੁਰ੍ਦਿਸ਼ਿ ਤਿਸ਼਼੍ਠਤਿ ਸਤਿ ਸ ਸ੍ਵਯਮ੍ ਉੱਥਾਯ ਪੁਨਰਪਿ ਨਗਰਮਧ੍ਯੰ ਪ੍ਰਾਵਿਸ਼ਤ੍ ਤਤ੍ਪਰੇ(ਅ)ਹਨਿ ਬਰ੍ਣੱਬਾਸਹਿਤੋ ਦਰ੍ੱਬੀਨਗਰੰ ਗਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","ਤਤ੍ਰ ਸੁਸੰਵਾਦੰ ਪ੍ਰਚਾਰ੍ੱਯ ਬਹੁਲੋਕਾਨ੍ ਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਕ੍ਰੁʼਤ੍ਵਾ ਤੌ ਲੁਸ੍ਤ੍ਰਾਮ੍ ਇਕਨਿਯਮ੍ ਆਨ੍ਤਿਯਖਿਯਾਞ੍ਚ ਪਰਾਵ੍ਰੁʼਤ੍ਯ ਗਤੌ| ");
INSERT INTO sanpun_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ਬਹੁਦੁਃਖਾਨਿ ਭੁਕ੍ਤ੍ਵਾਪੀਸ਼੍ਵਰਰਾਜ੍ਯੰ ਪ੍ਰਵੇਸ਼਼੍ਟਵ੍ਯਮ੍ ਇਤਿ ਕਾਰਣਾਦ੍ ਧਰ੍ੰਮਮਾਰ੍ਗੇ ਸ੍ਥਾਤੁੰ ਵਿਨਯੰ ਕ੍ਰੁʼਤ੍ਵਾ ਸ਼ਿਸ਼਼੍ਯਗਣਸ੍ਯ ਮਨਃਸ੍ਥੈਰ੍ੱਯਮ੍ ਅਕੁਰੁਤਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","ਮਣ੍ਡਲੀਨਾਂ ਪ੍ਰਾਚੀਨਵਰ੍ਗਾਨ੍ ਨਿਯੁਜ੍ਯ ਪ੍ਰਾਰ੍ਥਨੋਪਵਾਸੌ ਕ੍ਰੁʼਤ੍ਵਾ ਯਤ੍ਪ੍ਰਭੌ ਤੇ ਵ੍ਯਸ਼੍ਵਸਨ੍ ਤਸ੍ਯ ਹਸ੍ਤੇ ਤਾਨ੍ ਸਮਰ੍ਪ੍ਯ ");
INSERT INTO sanpun_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","ਪਿਸਿਦਿਯਾਮਧ੍ਯੇਨ ਪਾਮ੍ਫੁਲਿਯਾਦੇਸ਼ੰ ਗਤਵਨ੍ਤੌ| ");
INSERT INTO sanpun_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ਪਸ਼੍ਚਾਤ੍ ਪਰ੍ਗਾਨਗਰੰ ਗਤ੍ਵਾ ਸੁਸੰਵਾਦੰ ਪ੍ਰਚਾਰ੍ੱਯ ਅੱਤਾਲਿਯਾਨਗਰੰ ਪ੍ਰਸ੍ਥਿਤਵਨ੍ਤੌ| ");
INSERT INTO sanpun_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ਤਸ੍ਮਾਤ੍ ਸਮੁਦ੍ਰਪਥੇਨ ਗਤ੍ਵਾ ਤਾਭ੍ਯਾਂ ਯਤ੍ ਕਰ੍ੰਮ ਸਮ੍ਪੰਨੰ ਤਤ੍ਕਰ੍ੰਮ ਸਾਧਯਿਤੁੰ ਯੰਨਗਰੇ ਦਯਾਲੋਰੀਸ਼੍ਵਰਸ੍ਯ ਹਸ੍ਤੇ ਸਮਰ੍ਪਿਤੌ ਜਾਤੌ ਤਦ੍ ਆਨ੍ਤਿਯਖਿਯਾਨਗਰੰ ਗਤਵਨ੍ਤਾ| ");
INSERT INTO sanpun_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","ਤਤ੍ਰੋਪਸ੍ਥਾਯ ਤੰਨਗਰਸ੍ਥਮਣ੍ਡਲੀਂ ਸੰਗ੍ਰੁʼਹ੍ਯ ਸ੍ਵਾਭ੍ਯਾਮ ਈਸ਼੍ਵਰੋ ਯਦ੍ਯਤ੍ ਕਰ੍ੰਮਕਰੋਤ੍ ਤਥਾ ਯੇਨ ਪ੍ਰਕਾਰੇਣ ਭਿੰਨਦੇਸ਼ੀਯਲੋਕਾਨ੍ ਪ੍ਰਤਿ ਵਿਸ਼੍ਵਾਸਰੂਪਦ੍ਵਾਰਮ੍ ਅਮੋਚਯਦ੍ ਏਤਾਨ੍ ਸਰ੍ੱਵਵ੍ਰੁʼੱਤਾਨ੍ਤਾਨ੍ ਤਾਨ੍ ਜ੍ਞਾਪਿਤਵਨ੍ਤੌ| ");
INSERT INTO sanpun_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ਤਤਸ੍ਤੌ ਸ਼ਿਰ੍ੱਯੈਃ ਸਾਰ੍ੱਧੰ ਤਤ੍ਰ ਬਹੁਦਿਨਾਨਿ ਨ੍ਯਵਸਤਾਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","ਯਿਹੂਦਾਦੇਸ਼ਾਤ੍ ਕਿਯਨ੍ਤੋ ਜਨਾ ਆਗਤ੍ਯ ਭ੍ਰਾਤ੍ਰੁʼਗਣਮਿੱਥੰ ਸ਼ਿਕ੍ਸ਼਼ਿਤਵਨ੍ਤੋ ਮੂਸਾਵ੍ਯਵਸ੍ਥਯਾ ਯਦਿ ਯੁਸ਼਼੍ਮਾਕੰ ਤ੍ਵਕ੍ਛੇਦੋ ਨ ਭਵਤਿ ਤਰ੍ਹਿ ਯੂਯੰ ਪਰਿਤ੍ਰਾਣੰ ਪ੍ਰਾਪ੍ਤੁੰ ਨ ਸ਼ਕ੍ਸ਼਼੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","ਪੌਲਬਰ੍ਣੱਬੌ ਤੈਃ ਸਹ ਬਹੂਨ੍ ਵਿਚਾਰਾਨ੍ ਵਿਵਾਦਾਂਸ਼੍ਚ ਕ੍ਰੁʼਤਵਨ੍ਤੌ, ਤਤੋ ਮਣ੍ਡਲੀਯਨੋਕਾ ਏਤਸ੍ਯਾਃ ਕਥਾਯਾਸ੍ਤੱਤ੍ਵੰ ਜ੍ਞਾਤੁੰ ਯਿਰੂਸ਼ਾਲਮ੍ਨਗਰਸ੍ਥਾਨ੍ ਪ੍ਰੇਰਿਤਾਨ੍ ਪ੍ਰਾਚੀਨਾਂਸ਼੍ਚ ਪ੍ਰਤਿ ਪੌਲਬਰ੍ਣੱਬਾਪ੍ਰਭ੍ਰੁʼਤੀਨ੍ ਕਤਿਪਯਜਨਾਨ੍ ਪ੍ਰੇਸ਼਼ਯਿਤੁੰ ਨਿਸ਼੍ਚਯੰ ਕ੍ਰੁʼਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","ਤੇ ਮਣ੍ਡਲ੍ਯਾ ਪ੍ਰੇਰਿਤਾਃ ਸਨ੍ਤਃ ਫੈਣੀਕੀਸ਼ੋਮਿਰੋਨ੍ਦੇਸ਼ਾਭ੍ਯਾਂ ਗਤ੍ਵਾ ਭਿੰਨਦੇਸ਼ੀਯਾਨਾਂ ਮਨਃਪਰਿਵਰ੍ੱਤਨਸ੍ਯ ਵਾਰ੍ੱਤਯਾ ਭ੍ਰਾਤ੍ਰੁʼਣਾਂ ਪਰਮਾਹ੍ਲਾਦਮ੍ ਅਜਨਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","ਯਿਰੂਸ਼ਾਲਮ੍ਯੁਪਸ੍ਥਾਯ ਪ੍ਰੇਰਿਤਗਣੇਨ ਲੋਕਪ੍ਰਾਚੀਨਗਣੇਨ ਸਮਾਜੇਨ ਚ ਸਮੁਪਗ੍ਰੁʼਹੀਤਾਃ ਸਨ੍ਤਃ ਸ੍ਵੈਰੀਸ਼੍ਵਰੋ ਯਾਨਿ ਕਰ੍ੰਮਾਣਿ ਕ੍ਰੁʼਤਵਾਨ੍ ਤੇਸ਼਼ਾਂ ਸਰ੍ੱਵਵ੍ਰੁʼੱਤਾਨ੍ਤਾਨ੍ ਤੇਸ਼਼ਾਂ ਸਮਕ੍ਸ਼਼ਮ੍ ਅਕਥਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","ਕਿਨ੍ਤੁ ਵਿਸ਼੍ਵਾਸਿਨਃ ਕਿਯਨ੍ਤਃ ਫਿਰੂਸ਼ਿਮਤਗ੍ਰਾਹਿਣੋ ਲੋਕਾ ਉੱਥਾਯ ਕਥਾਮੇਤਾਂ ਕਥਿਤਵਨ੍ਤੋ ਭਿੰਨਦੇਸ਼ੀਯਾਨਾਂ ਤ੍ਵਕ੍ਛੇਦੰ ਕਰ੍ੱਤੁੰ ਮੂਸਾਵ੍ਯਵਸ੍ਥਾਂ ਪਾਲਯਿਤੁਞ੍ਚ ਸਮਾਦੇਸ਼਼੍ਟਵ੍ਯਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","ਤਤਃ ਪ੍ਰੇਰਿਤਾ ਲੋਕਪ੍ਰਾਚੀਨਾਸ਼੍ਚ ਤਸ੍ਯ ਵਿਵੇਚਨਾਂ ਕਰ੍ੱਤੁੰ ਸਭਾਯਾਂ ਸ੍ਥਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","ਬਹੁਵਿਚਾਰੇਸ਼਼ੁ ਜਾਤਸ਼਼ੁ ਪਿਤਰ ਉੱਥਾਯ ਕਥਿਤਵਾਨ੍, ਹੇ ਭ੍ਰਾਤਰੋ ਯਥਾ ਭਿੰਨਦੇਸ਼ੀਯਲੋਕਾ ਮਮ ਮੁਖਾਤ੍ ਸੁਸੰਵਾਦੰ ਸ਼੍ਰੁਤ੍ਵਾ ਵਿਸ਼੍ਵਸਨ੍ਤਿ ਤਦਰ੍ਥੰ ਬਹੁਦਿਨਾਤ੍ ਪੂਰ੍ੱਵਮ੍ ਈਸ਼੍ਵਰੋਸ੍ਮਾਕੰ ਮਧ੍ਯੇ ਮਾਂ ਵ੍ਰੁʼਤ੍ਵਾ ਨਿਯੁਕ੍ਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","ਅਨ੍ਤਰ੍ੱਯਾਮੀਸ਼੍ਵਰੋ ਯਥਾਸ੍ਮਭ੍ਯੰ ਤਥਾ ਭਿੰਨਦੇਸ਼ੀਯੇਭ੍ਯਃ ਪਵਿਤ੍ਰਮਾਤ੍ਮਾਨੰ ਪ੍ਰਦਾਯ ਵਿਸ਼੍ਵਾਸੇਨ ਤੇਸ਼਼ਾਮ੍ ਅਨ੍ਤਃਕਰਣਾਨਿ ਪਵਿਤ੍ਰਾਣਿ ਕ੍ਰੁʼਤ੍ਵਾ ");
INSERT INTO sanpun_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ਤੇਸ਼਼ਾਮ੍ ਅਸ੍ਮਾਕਞ੍ਚ ਮਧ੍ਯੇ ਕਿਮਪਿ ਵਿਸ਼ੇਸ਼਼ੰ ਨ ਸ੍ਥਾਪਯਿਤ੍ਵਾ ਤਾਨਧਿ ਸ੍ਵਯੰ ਪ੍ਰਮਾਣੰ ਦੱਤਵਾਨ੍ ਇਤਿ ਯੂਯੰ ਜਾਨੀਥ| ");
INSERT INTO sanpun_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","ਅਤਏਵਾਸ੍ਮਾਕੰ ਪੂਰ੍ੱਵਪੁਰੁਸ਼਼ਾ ਵਯਞ੍ਚ ਸ੍ਵਯੰ ਯਦ੍ਯੁਗਸ੍ਯ ਭਾਰੰ ਸੋਢੁੰ ਨ ਸ਼ਕ੍ਤਾਃ ਸਮ੍ਪ੍ਰਤਿ ਤੰ ਸ਼ਿਸ਼਼੍ਯਗਣਸ੍ਯ ਸ੍ਕਨ੍ਧੇਸ਼਼ੁ ਨ੍ਯਸਿਤੁੰ ਕੁਤ ਈਸ਼੍ਵਰਸ੍ਯ ਪਰੀਕ੍ਸ਼਼ਾਂ ਕਰਿਸ਼਼੍ਯਥ? ");
INSERT INTO sanpun_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","ਪ੍ਰਭੋ ਰ੍ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯਾਨੁਗ੍ਰਹੇਣ ਤੇ ਯਥਾ ਵਯਮਪਿ ਤਥਾ ਪਰਿਤ੍ਰਾਣੰ ਪ੍ਰਾਪ੍ਤੁਮ੍ ਆਸ਼ਾਂ ਕੁਰ੍ੰਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","ਅਨਨ੍ਤਰੰ ਬਰ੍ਣੱਬਾਪੌਲਾਭ੍ਯਾਮ੍ ਈਸ਼੍ਵਰੋ ਭਿੰਨਦੇਸ਼ੀਯਾਨਾਂ ਮਧ੍ਯੇ ਯਦ੍ਯਦ੍ ਆਸ਼੍ਚਰ੍ੱਯਮ੍ ਅਦ੍ਭੁਤਞ੍ਚ ਕਰ੍ੰਮ ਕ੍ਰੁʼਤਵਾਨ੍ ਤਦ੍ਵ੍ਰੁʼੱਤਾਨ੍ਤੰ ਤੌ ਸ੍ਵਮੁਖਾਭ੍ਯਾਮ੍ ਅਵਰ੍ਣਯਤਾਂ ਸਭਾਸ੍ਥਾਃ ਸਰ੍ੱਵੇ ਨੀਰਵਾਃ ਸਨ੍ਤਃ ਸ਼੍ਰੁਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","ਤਯੋਃ ਕਥਾਯਾਂ ਸਮਾਪ੍ਤਾਯਾਂ ਸਤ੍ਯਾਂ ਯਾਕੂਬ੍ ਕਥਯਿਤੁਮ੍ ਆਰਬ੍ਧਵਾਨ੍ ");
INSERT INTO sanpun_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ਹੇ ਭ੍ਰਾਤਰੋ ਮਮ ਕਥਾਯਾਮ੍ ਮਨੋ ਨਿਧੱਤ| ਈਸ਼੍ਵਰਃ ਸ੍ਵਨਾਮਾਰ੍ਥੰ ਭਿੰਨਦੇਸ਼ੀਯਲੋਕਾਨਾਮ੍ ਮਧ੍ਯਾਦ੍ ਏਕੰ ਲੋਕਸੰਘੰ ਗ੍ਰਹੀਤੁੰ ਮਤਿੰ ਕ੍ਰੁʼਤ੍ਵਾ ਯੇਨ ਪ੍ਰਕਾਰੇਣ ਪ੍ਰਥਮੰ ਤਾਨ੍ ਪ੍ਰਤਿ ਕ੍ਰੁʼਪਾਵਲੇਕਨੰ ਕ੍ਰੁʼਤਵਾਨ੍ ਤੰ ਸ਼ਿਮੋਨ੍ ਵਰ੍ਣਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਭਿਰੁਕ੍ਤਾਨਿ ਯਾਨਿ ਵਾਕ੍ਯਾਨਿ ਤੈਃ ਸਾਰ੍ੱਧਮ੍ ਏਤਸ੍ਯੈਕ੍ਯੰ ਭਵਤਿ ਯਥਾ ਲਿਖਿਤਮਾਸ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਕਰ੍ੰਮਣਾਂ ਯਸ੍ਤੁ ਸਾਧਕਃ ਪਰਮੇਸ਼੍ਵਰਃ| ਸ ਏਵੇਦੰ ਵਦੇਦ੍ਵਾਕ੍ਯੰ ਸ਼ੇਸ਼਼ਾਃ ਸਕਲਮਾਨਵਾਃ| ਭਿੰਨਦੇਸ਼ੀਯਲੋਕਾਸ਼੍ਚ ਯਾਵਨ੍ਤੋ ਮਮ ਨਾਮਤਃ| ਭਵਨ੍ਤਿ ਹਿ ਸੁਵਿਖ੍ਯਾਤਾਸ੍ਤੇ ਯਥਾ ਪਰਮੇਸ਼ਿਤੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ਤਤ੍ਵੰ ਸਮ੍ਯਕ੍ ਸਮੀਹਨ੍ਤੇ ਤੰਨਿਮਿੱਤਮਹੰ ਕਿਲ| ਪਰਾਵ੍ਰੁʼਤ੍ਯ ਸਮਾਗਤ੍ਯ ਦਾਯੂਦਃ ਪਤਿਤੰ ਪੁਨਃ| ਦੂਸ਼਼੍ਯਮੁੱਥਾਪਯਿਸ਼਼੍ਯਾਮਿ ਤਦੀਯੰ ਸਰ੍ੱਵਵਸ੍ਤੁ ਚ| ਪਤਿਤੰ ਪੁਨਰੁਥਾਪ੍ਯ ਸੱਜਯਿਸ਼਼੍ਯਾਮਿ ਸਰ੍ੱਵਥਾ|| ");
INSERT INTO sanpun_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ਆ ਪ੍ਰਥਮਾਦ੍ ਈਸ਼੍ਵਰਃ ਸ੍ਵੀਯਾਨਿ ਸਰ੍ੱਵਕਰ੍ੰਮਾਣਿ ਜਾਨਾਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","ਅਤਏਵ ਮਮ ਨਿਵੇਦਨਮਿਦੰ ਭਿੰਨਦੇਸ਼ੀਯਲੋਕਾਨਾਂ ਮਧ੍ਯੇ ਯੇ ਜਨਾ ਈਸ਼੍ਵਰੰ ਪ੍ਰਤਿ ਪਰਾਵਰ੍ੱਤਨ੍ਤ ਤੇਸ਼਼ਾਮੁਪਰਿ ਅਨ੍ਯੰ ਕਮਪਿ ਭਾਰੰ ਨ ਨ੍ਯਸ੍ਯ ");
INSERT INTO sanpun_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ਦੇਵਤਾਪ੍ਰਸਾਦਾਸ਼ੁਚਿਭਕ੍ਸ਼਼੍ਯੰ ਵ੍ਯਭਿਚਾਰਕਰ੍ੰਮ ਕਣ੍ਠਸਮ੍ਪੀਡਨਮਾਰਿਤਪ੍ਰਾਣਿਭਕ੍ਸ਼਼੍ਯੰ ਰਕ੍ਤਭਕ੍ਸ਼਼੍ਯਞ੍ਚ ਏਤਾਨਿ ਪਰਿਤ੍ਯਕ੍ਤੁੰ ਲਿਖਾਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","ਯਤਃ ਪੂਰ੍ੱਵਕਾਲਤੋ ਮੂਸਾਵ੍ਯਵਸ੍ਥਾਪ੍ਰਚਾਰਿਣੋ ਲੋਕਾ ਨਗਰੇ ਨਗਰੇ ਸਨ੍ਤਿ ਪ੍ਰਤਿਵਿਸ਼੍ਰਾਮਵਾਰਞ੍ਚ ਭਜਨਭਵਨੇ ਤਸ੍ਯਾਃ ਪਾਠੋ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","ਤਤਃ ਪਰੰ ਪ੍ਰੇਰਿਤਗਣੋ ਲੋਕਪ੍ਰਾਚੀਨਗਣਃ ਸਰ੍ੱਵਾ ਮਣ੍ਡਲੀ ਚ ਸ੍ਵੇਸ਼਼ਾਂ ਮਧ੍ਯੇ ਬਰ੍ਸ਼ੱਬਾ ਨਾਮ੍ਨਾ ਵਿਖ੍ਯਾਤੋ ਮਨੋਨੀਤੌ ਕ੍ਰੁʼਤ੍ਵਾ ਪੌਲਬਰ੍ਣੱਬਾਭ੍ਯਾਂ ਸਾਰ੍ੱਧਮ੍ ਆਨ੍ਤਿਯਖਿਯਾਨਗਰੰ ਪ੍ਰਤਿ ਪ੍ਰੇਸ਼਼ਣਮ੍ ਉਚਿਤੰ ਬੁੱਧ੍ਵਾ ਤਾਭ੍ਯਾਂ ਪਤ੍ਰੰ ਪ੍ਰੈਸ਼਼ਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ਤਸ੍ਮਿਨ੍ ਪਤ੍ਰੇ ਲਿਖਿਤਮਿੰਦ, ਆਨ੍ਤਿਯਖਿਯਾ-ਸੁਰਿਯਾ-ਕਿਲਿਕਿਯਾਦੇਸ਼ਸ੍ਥਭਿੰਨਦੇਸ਼ੀਯਭ੍ਰਾਤ੍ਰੁʼਗਣਾਯ ਪ੍ਰੇਰਿਤਗਣਸ੍ਯ ਲੋਕਪ੍ਰਾਚੀਨਗਣਸ੍ਯ ਭ੍ਰਾਤ੍ਰੁʼਗਣਸ੍ਯ ਚ ਨਮਸ੍ਕਾਰਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","ਵਿਸ਼ੇਸ਼਼ਤੋ(ਅ)ਸ੍ਮਾਕਮ੍ ਆਜ੍ਞਾਮ੍ ਅਪ੍ਰਾਪ੍ਯਾਪਿ ਕਿਯਨ੍ਤੋ ਜਨਾ ਅਸ੍ਮਾਕੰ ਮਧ੍ਯਾਦ੍ ਗਤ੍ਵਾ ਤ੍ਵਕ੍ਛੇਦੋ ਮੂਸਾਵ੍ਯਵਸ੍ਥਾ ਚ ਪਾਲਯਿਤਵ੍ਯਾਵਿਤਿ ਯੁਸ਼਼੍ਮਾਨ੍ ਸ਼ਿਕ੍ਸ਼਼ਯਿਤ੍ਵਾ ਯੁਸ਼਼੍ਮਾਕੰ ਮਨਸਾਮਸ੍ਥੈਰ੍ੱਯੰ ਕ੍ਰੁʼਤ੍ਵਾ ਯੁਸ਼਼੍ਮਾਨ੍ ਸਸਨ੍ਦੇਹਾਨ੍ ਅਕੁਰ੍ੱਵਨ੍ ਏਤਾਂ ਕਥਾਂ ਵਯਮ੍ ਅਸ਼੍ਰੁʼਨ੍ਮ| ");
INSERT INTO sanpun_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","ਤਤ੍ਕਾਰਣਾਦ੍ ਵਯਮ੍ ਏਕਮਨ੍ਤ੍ਰਣਾਃ ਸਨ੍ਤਃ ਸਭਾਯਾਂ ਸ੍ਥਿਤ੍ਵਾ ਪ੍ਰਭੋ ਰ੍ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਨਾਮਨਿਮਿੱਤੰ ਮ੍ਰੁʼਤ੍ਯੁਮੁਖਗਤਾਭ੍ਯਾਮਸ੍ਮਾਕੰ ");
INSERT INTO sanpun_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ਪ੍ਰਿਯਬਰ੍ਣੱਬਾਪੌਲਾਭ੍ਯਾਂ ਸਾਰ੍ੱਧੰ ਮਨੋਨੀਤਲੋਕਾਨਾਂ ਕੇਸ਼਼ਾਞ੍ਚਿਦ੍ ਯੁਸ਼਼੍ਮਾਕੰ ਸੰਨਿਧੌ ਪ੍ਰੇਸ਼਼ਣਮ੍ ਉਚਿਤੰ ਬੁੱਧਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","ਅਤੋ ਯਿਹੂਦਾਸੀਲੌ ਯੁਸ਼਼੍ਮਾਨ੍ ਪ੍ਰਤਿ ਪ੍ਰੇਸ਼਼ਿਤਵਨ੍ਤਃ, ਏਤਯੋ ਰ੍ਮੁਖਾਭ੍ਯਾਂ ਸਰ੍ੱਵਾਂ ਕਥਾਂ ਜ੍ਞਾਸ੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","ਦੇਵਤਾਪ੍ਰਸਾਦਭਕ੍ਸ਼਼੍ਯੰ ਰਕ੍ਤਭਕ੍ਸ਼਼੍ਯੰ ਗਲਪੀਡਨਮਾਰਿਤਪ੍ਰਾਣਿਭਕ੍ਸ਼਼੍ਯੰ ਵ੍ਯਭਿਚਾਰਕਰ੍ੰਮ ਚੇਮਾਨਿ ਸਰ੍ੱਵਾਣਿ ਯੁਸ਼਼੍ਮਾਭਿਸ੍ਤ੍ਯਾਜ੍ਯਾਨਿ; ਏਤਤ੍ਪ੍ਰਯੋਜਨੀਯਾਜ੍ਞਾਵ੍ਯਤਿਰੇਕੇਨ ਯੁਸ਼਼੍ਮਾਕਮ੍ ਉਪਰਿ ਭਾਰਮਨ੍ਯੰ ਨ ਨ੍ਯਸਿਤੁੰ ਪਵਿਤ੍ਰਸ੍ਯਾਤ੍ਮਨੋ(ਅ)ਸ੍ਮਾਕਞ੍ਚ ਉਚਿਤਜ੍ਞਾਨਮ੍ ਅਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ਅਤਏਵ ਤੇਭ੍ਯਃ ਸਰ੍ੱਵੇਭ੍ਯਃ ਸ੍ਵੇਸ਼਼ੁ ਰਕ੍ਸ਼਼ਿਤੇਸ਼਼ੁ ਯੂਯੰ ਭਦ੍ਰੰ ਕਰ੍ੰਮ ਕਰਿਸ਼਼੍ਯਥ| ਯੁਸ਼਼੍ਮਾਕੰ ਮਙ੍ਗਲੰ ਭੂਯਾਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","ਤੇे ਵਿਸ੍ਰੁʼਸ਼਼੍ਟਾਃ ਸਨ੍ਤ ਆਨ੍ਤਿਯਖਿਯਾਨਗਰ ਉਪਸ੍ਥਾਯ ਲੋਕਨਿਵਹੰ ਸੰਗ੍ਰੁʼਹ੍ਯ ਪਤ੍ਰਮ੍ ਅਦਦਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ਤਤਸ੍ਤੇ ਤਤ੍ਪਤ੍ਰੰ ਪਠਿਤ੍ਵਾ ਸਾਨ੍ਤ੍ਵਨਾਂ ਪ੍ਰਾਪ੍ਯ ਸਾਨਨ੍ਦਾ ਅਭਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ਯਿਹੂਦਾਸੀਲੌ ਚ ਸ੍ਵਯੰ ਪ੍ਰਚਾਰਕੌ ਭੂਤ੍ਵਾ ਭ੍ਰਾਤ੍ਰੁʼਗਣੰ ਨਾਨੋਪਦਿਸ਼੍ਯ ਤਾਨ੍ ਸੁਸ੍ਥਿਰਾਨ੍ ਅਕੁਰੁਤਾਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ਇੱਥੰ ਤੌ ਤਤ੍ਰ ਤੈਃ ਸਾਕੰ ਕਤਿਪਯਦਿਨਾਨਿ ਯਾਪਯਿਤ੍ਵਾ ਪਸ਼੍ਚਾਤ੍ ਪ੍ਰੇਰਿਤਾਨਾਂ ਸਮੀਪੇ ਪ੍ਰਤ੍ਯਾਗਮਨਾਰ੍ਥੰ ਤੇਸ਼਼ਾਂ ਸੰਨਿਧੇਃ ਕਲ੍ਯਾਣੇਨ ਵਿਸ੍ਰੁʼਸ਼਼੍ਟਾਵਭਵਤਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","ਕਿਨ੍ਤੁ ਸੀਲਸ੍ਤਤ੍ਰ ਸ੍ਥਾਤੁੰ ਵਾਞ੍ਛਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","ਅਪਰੰ ਪੌਲਬਰ੍ਣੱਬੌ ਬਹਵਃ ਸ਼ਿਸ਼਼੍ਯਾਸ਼੍ਚ ਲੋਕਾਨ੍ ਉਪਦਿਸ਼੍ਯ ਪ੍ਰਭੋਃ ਸੁਸੰਵਾਦੰ ਪ੍ਰਚਾਰਯਨ੍ਤ ਆਨ੍ਤਿਯਖਿਯਾਯਾਂ ਕਾਲੰ ਯਾਪਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","ਕਤਿਪਯਦਿਨੇਸ਼਼ੁ ਗਤੇਸ਼਼ੁ ਪੌਲੋ ਬਰ੍ਣੱਬਾਮ੍ ਅਵਦਤ੍ ਆਗੱਛਾਵਾਂ ਯੇਸ਼਼ੁ ਨਗਰੇਸ਼਼੍ਵੀਸ਼੍ਵਰਸ੍ਯ ਸੁਸੰਵਾਦੰ ਪ੍ਰਚਾਰਿਤਵਨ੍ਤੌ ਤਾਨਿ ਸਰ੍ੱਵਨਗਰਾਣਿ ਪੁਨਰ੍ਗਤ੍ਵਾ ਭ੍ਰਾਤਰਃ ਕੀਦ੍ਰੁʼਸ਼ਾਃ ਸਨ੍ਤੀਤਿ ਦ੍ਰਸ਼਼੍ਟੁੰ ਤਾਨ੍ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਕੁਰ੍ੱਵਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","ਤੇਨ ਮਾਰ੍ਕਨਾਮ੍ਨਾ ਵਿਖ੍ਯਾਤੰ ਯੋਹਨੰ ਸਙ੍ਗਿਨੰ ਕਰ੍ੱਤੁੰ ਬਰ੍ਣੱਬਾ ਮਤਿਮਕਰੋਤ੍, ");
INSERT INTO sanpun_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ਕਿਨ੍ਤੁ ਸ ਪੂਰ੍ੱਵੰ ਤਾਭ੍ਯਾਂ ਸਹ ਕਾਰ੍ੱਯਾਰ੍ਥੰ ਨ ਗਤ੍ਵਾ ਪਾਮ੍ਫੂਲਿਯਾਦੇਸ਼ੇ ਤੌ ਤ੍ਯਕ੍ਤਵਾਨ੍ ਤਤ੍ਕਾਰਣਾਤ੍ ਪੌਲਸ੍ਤੰ ਸਙ੍ਗਿਨੰ ਕਰ੍ੱਤੁਮ੍ ਅਨੁਚਿਤੰ ਜ੍ਞਾਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ਇੱਥੰ ਤਯੋਰਤਿਸ਼ਯਵਿਰੋਧਸ੍ਯੋਪਸ੍ਥਿਤਤ੍ਵਾਤ੍ ਤੌ ਪਰਸ੍ਪਰੰ ਪ੍ਰੁʼਥਗਭਵਤਾਂ ਤਤੋ ਬਰ੍ਣੱਬਾ ਮਾਰ੍ਕੰ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਪੋਤੇਨ ਕੁਪ੍ਰੋਪਦ੍ਵੀਪੰ ਗਤਵਾਨ੍; ");
INSERT INTO sanpun_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","ਕਿਨ੍ਤੁ ਪੌਲਃ ਸੀਲੰ ਮਨੋਨੀਤੰ ਕ੍ਰੁʼਤ੍ਵਾ ਭ੍ਰਾਤ੍ਰੁʼਭਿਰੀਸ਼੍ਵਰਾਨੁਗ੍ਰਹੇ ਸਮਰ੍ਪਿਤਃ ਸਨ੍ ਪ੍ਰਸ੍ਥਾਯ ");
INSERT INTO sanpun_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","ਸੁਰਿਯਾਕਿਲਿਕਿਯਾਦੇਸ਼ਾਭ੍ਯਾਂ ਮਣ੍ਡਲੀਃ ਸ੍ਥਿਰੀਕੁਰ੍ੱਵਨ੍ ਅਗੱਛਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","ਪੌਲੋ ਦਰ੍ੱਬੀਲੁਸ੍ਤ੍ਰਾਨਗਰਯੋਰੁਪਸ੍ਥਿਤੋਭਵਤ੍ ਤਤ੍ਰ ਤੀਮਥਿਯਨਾਮਾ ਸ਼ਿਸ਼਼੍ਯ ਏਕ ਆਸੀਤ੍; ਸ ਵਿਸ਼੍ਵਾਸਿਨ੍ਯਾ ਯਿਹੂਦੀਯਾਯਾ ਯੋਸ਼਼ਿਤੋ ਗਰ੍ੱਭਜਾਤਃ ਕਿਨ੍ਤੁ ਤਸ੍ਯ ਪਿਤਾਨ੍ਯਦੇਸ਼ੀਯਲੋਕਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","ਸ ਜਨੋ ਲੁਸ੍ਤ੍ਰਾ-ਇਕਨਿਯਨਗਰਸ੍ਥਾਨਾਂ ਭ੍ਰਾਤ੍ਰੁʼਣਾਂ ਸਮੀਪੇਪਿ ਸੁਖ੍ਯਾਤਿਮਾਨ੍ ਆਸੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","ਪੌਲਸ੍ਤੰ ਸ੍ਵਸਙ੍ਗਿਨੰ ਕਰ੍ੱਤੁੰ ਮਤਿੰ ਕ੍ਰੁʼਤ੍ਵਾ ਤੰ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਤੱਦੇਸ਼ਨਿਵਾਸਿਨਾਂ ਯਿਹੂਦੀਯਾਨਾਮ੍ ਅਨੁਰੋਧਾਤ੍ ਤਸ੍ਯ ਤ੍ਵਕ੍ਛੇਦੰ ਕ੍ਰੁʼਤਵਾਨ੍ ਯਤਸ੍ਤਸ੍ਯ ਪਿਤਾ ਭਿੰਨਦੇਸ਼ੀਯਲੋਕ ਇਤਿ ਸਰ੍ੱਵੈਰਜ੍ਞਾਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","ਤਤਃ ਪਰੰ ਤੇ ਨਗਰੇ ਨਗਰੇ ਭ੍ਰਮਿਤ੍ਵਾ ਯਿਰੂਸ਼ਾਲਮਸ੍ਥੈਃ ਪ੍ਰੇਰਿਤੈ ਰ੍ਲੋਕਪ੍ਰਾਚੀਨੈਸ਼੍ਚ ਨਿਰੂਪਿਤੰ ਯਦ੍ ਵ੍ਯਵਸ੍ਥਾਪਤ੍ਰੰ ਤਦਨੁਸਾਰੇਣਾਚਰਿਤੁੰ ਲੋਕੇਭ੍ਯਸ੍ਤਦ੍ ਦੱਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","ਤੇਨੈਵ ਸਰ੍ੱਵੇ ਧਰ੍ੰਮਸਮਾਜਾਃ ਖ੍ਰੀਸ਼਼੍ਟਧਰ੍ੰਮੇ ਸੁਸ੍ਥਿਰਾਃ ਸਨ੍ਤਃ ਪ੍ਰਤਿਦਿਨੰ ਵਰ੍ੱਧਿਤਾ ਅਭਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","ਤੇਸ਼਼ੁ ਫ੍ਰੁਗਿਯਾਗਾਲਾਤਿਯਾਦੇਸ਼ਮਧ੍ਯੇਨ ਗਤੇਸ਼਼ੁ ਸਤ੍ਸੁ ਪਵਿਤ੍ਰ ਆਤ੍ਮਾ ਤਾਨ੍ ਆਸ਼ਿਯਾਦੇਸ਼ੇ ਕਥਾਂ ਪ੍ਰਕਾਸ਼ਯਿਤੁੰ ਪ੍ਰਤਿਸ਼਼ਿੱਧਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ਤਥਾ ਮੁਸਿਯਾਦੇਸ਼ ਉਪਸ੍ਥਾਯ ਬਿਥੁਨਿਯਾਂ ਗਨ੍ਤੁੰ ਤੈਰੁਦ੍ਯੋਗੇ ਕ੍ਰੁʼਤੇ ਆਤ੍ਮਾ ਤਾਨ੍ ਨਾਨ੍ਵਮਨ੍ਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","ਤਸ੍ਮਾਤ੍ ਤੇ ਮੁਸਿਯਾਦੇਸ਼ੰ ਪਰਿਤ੍ਯਜ੍ਯ ਤ੍ਰੋਯਾਨਗਰੰ ਗਤ੍ਵਾ ਸਮੁਪਸ੍ਥਿਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ਰਾਤ੍ਰੌ ਪੌਲਃ ਸ੍ਵਪ੍ਨੇ ਦ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍ ਏਕੋ ਮਾਕਿਦਨਿਯਲੋਕਸ੍ਤਿਸ਼਼੍ਠਨ੍ ਵਿਨਯੰ ਕ੍ਰੁʼਤ੍ਵਾ ਤਸ੍ਮੈ ਕਥਯਤਿ, ਮਾਕਿਦਨਿਯਾਦੇਸ਼ਮ੍ ਆਗਤ੍ਯਾਸ੍ਮਾਨ੍ ਉਪਕੁਰ੍ੱਵਿਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ਤਸ੍ਯੇੱਥੰ ਸ੍ਵਪ੍ਨਦਰ੍ਸ਼ਨਾਤ੍ ਪ੍ਰਭੁਸ੍ਤੱਦੇਸ਼ੀਯਲੋਕਾਨ੍ ਪ੍ਰਤਿ ਸੁਸੰਵਾਦੰ ਪ੍ਰਚਾਰਯਿਤੁਮ੍ ਅਸ੍ਮਾਨ੍ ਆਹੂਯਤੀਤਿ ਨਿਸ਼੍ਚਿਤੰ ਬੁੱਧ੍ਵਾ ਵਯੰ ਤੂਰ੍ਣੰ ਮਾਕਿਦਨਿਯਾਦੇਸ਼ੰ ਗਨ੍ਤੁਮ੍ ਉਦ੍ਯੋਗਮ੍ ਅਕੁਰ੍ੰਮ| ");
INSERT INTO sanpun_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","ਤਤਃ ਪਰੰ ਵਯੰ ਤ੍ਰੋਯਾਨਗਰਾਦ੍ ਪ੍ਰਸ੍ਥਾਯ ਰੁʼਜੁਮਾਰ੍ਗੇਣ ਸਾਮਥ੍ਰਾਕਿਯੋਪਦ੍ਵੀਪੇਨ ਗਤ੍ਵਾ ਪਰੇ(ਅ)ਹਨਿ ਨਿਯਾਪਲਿਨਗਰ ਉਪਸ੍ਥਿਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ਤਸ੍ਮਾਦ੍ ਗਤ੍ਵਾ ਮਾਕਿਦਨਿਯਾਨ੍ਤਰ੍ੱਵਰ੍ੱਤਿ ਰੋਮੀਯਵਸਤਿਸ੍ਥਾਨੰ ਯਤ੍ ਫਿਲਿਪੀਨਾਮਪ੍ਰਧਾਨਨਗਰੰ ਤਤ੍ਰੋਪਸ੍ਥਾਯ ਕਤਿਪਯਦਿਨਾਨਿ ਤਤ੍ਰ ਸ੍ਥਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","ਵਿਸ਼੍ਰਾਮਵਾਰੇ ਨਗਰਾਦ੍ ਬਹਿ ਰ੍ਗਤ੍ਵਾ ਨਦੀਤਟੇ ਯਤ੍ਰ ਪ੍ਰਾਰ੍ਥਨਾਚਾਰ ਆਸੀਤ੍ ਤਤ੍ਰੋਪਵਿਸ਼੍ਯ ਸਮਾਗਤਾ ਨਾਰੀਃ ਪ੍ਰਤਿ ਕਥਾਂ ਪ੍ਰਾਚਾਰਯਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","ਤਤਃ ਥੁਯਾਤੀਰਾਨਗਰੀਯਾ ਧੂਸ਼਼ਰਾਮ੍ਬਰਵਿਕ੍ਰਾਯਿਣੀ ਲੁਦਿਯਾਨਾਮਿਕਾ ਯਾ ਈਸ਼੍ਵਰਸੇਵਿਕਾ ਯੋਸ਼਼ਿਤ੍ ਸ਼੍ਰੋਤ੍ਰੀਣਾਂ ਮਧ੍ਯ ਆਸੀਤ੍ ਤਯਾ ਪੌਲੋਕ੍ਤਵਾਕ੍ਯਾਨਿ ਯਦ੍ ਗ੍ਰੁʼਹ੍ਯਨ੍ਤੇ ਤਦਰ੍ਥੰ ਪ੍ਰਭੁਸ੍ਤਸ੍ਯਾ ਮਨੋਦ੍ਵਾਰੰ ਮੁਕ੍ਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ਅਤਃ ਸਾ ਯੋਸ਼਼ਿਤ੍ ਸਪਰਿਵਾਰਾ ਮੱਜਿਤਾ ਸਤੀ ਵਿਨਯੰ ਕ੍ਰੁʼਤ੍ਵਾ ਕਥਿਤਵਤੀ, ਯੁਸ਼਼੍ਮਾਕੰ ਵਿਚਾਰਾਦ੍ ਯਦਿ ਪ੍ਰਭੌ ਵਿਸ਼੍ਵਾਸਿਨੀ ਜਾਤਾਹੰ ਤਰ੍ਹਿ ਮਮ ਗ੍ਰੁʼਹਮ੍ ਆਗਤ੍ਯ ਤਿਸ਼਼੍ਠਤ| ਇੱਥੰ ਸਾ ਯਤ੍ਨੇਨਾਸ੍ਮਾਨ੍ ਅਸ੍ਥਾਪਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","ਯਸ੍ਯਾ ਗਣਨਯਾ ਤਦਧਿਪਤੀਨਾਂ ਬਹੁਧਨੋਪਾਰ੍ਜਨੰ ਜਾਤੰ ਤਾਦ੍ਰੁʼਸ਼ੀ ਗਣਕਭੂਤਗ੍ਰਸ੍ਤਾ ਕਾਚਨ ਦਾਸੀ ਪ੍ਰਾਰ੍ਥਨਾਸ੍ਥਾਨਗਮਨਕਾਲ ਆਗਤ੍ਯਾਸ੍ਮਾਨ੍ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਕ੍ਰੁʼਤਵਤੀ| ");
INSERT INTO sanpun_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","ਸਾਸ੍ਮਾਕੰ ਪੌਲਸ੍ਯ ਚ ਪਸ਼੍ਚਾਦ੍ ਏਤ੍ਯ ਪ੍ਰੋੱਚੈਃ ਕਥਾਮਿਮਾਂ ਕਥਿਤਵਤੀ, ਮਨੁਸ਼਼੍ਯਾ ਏਤੇ ਸਰ੍ੱਵੋਪਰਿਸ੍ਥਸ੍ਯੇਸ਼੍ਵਰਸ੍ਯ ਸੇਵਕਾਃ ਸਨ੍ਤੋ(ਅ)ਸ੍ਮਾਨ੍ ਪ੍ਰਤਿ ਪਰਿਤ੍ਰਾਣਸ੍ਯ ਮਾਰ੍ਗੰ ਪ੍ਰਕਾਸ਼ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","ਸਾ ਕਨ੍ਯਾ ਬਹੁਦਿਨਾਨਿ ਤਾਦ੍ਰੁʼਸ਼ਮ੍ ਅਕਰੋਤ੍ ਤਸ੍ਮਾਤ੍ ਪੌਲੋ ਦੁਃਖਿਤਃ ਸਨ੍ ਮੁਖੰ ਪਰਾਵਰ੍ਤ੍ਯ ਤੰ ਭੂਤਮਵਦਦ੍, ਅਹੰ ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਨਾਮ੍ਨਾ ਤ੍ਵਾਮਾਜ੍ਞਾਪਯਾਮਿ ਤ੍ਵਮਸ੍ਯਾ ਬਹਿਰ੍ਗੱਛ; ਤੇਨੈਵ ਤਤ੍ਕ੍ਸ਼਼ਣਾਤ੍ ਸ ਭੂਤਸ੍ਤਸ੍ਯਾ ਬਹਿਰ੍ਗਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","ਤਤਃ ਸ੍ਵੇਸ਼਼ਾਂ ਲਾਭਸ੍ਯ ਪ੍ਰਤ੍ਯਾਸ਼ਾ ਵਿਫਲਾ ਜਾਤੇਤਿ ਵਿਲੋਕ੍ਯ ਤਸ੍ਯਾਃ ਪ੍ਰਭਵਃ ਪੌਲੰ ਸੀਲਞ੍ਚ ਧ੍ਰੁʼਤ੍ਵਾਕ੍ਰੁʼਸ਼਼੍ਯ ਵਿਚਾਰਸ੍ਥਾਨੇ(ਅ)ਧਿਪਤੀਨਾਂ ਸਮੀਪਮ੍ ਆਨਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ਤਤਃ ਸ਼ਾਸਕਾਨਾਂ ਨਿਕਟੰ ਨੀਤ੍ਵਾ ਰੋਮਿਲੋਕਾ ਵਯਮ੍ ਅਸ੍ਮਾਕੰ ਯਦ੍ ਵ੍ਯਵਹਰਣੰ ਗ੍ਰਹੀਤੁਮ੍ ਆਚਰਿਤੁਞ੍ਚ ਨਿਸ਼਼ਿੱਧੰ, ");
INSERT INTO sanpun_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ਇਮੇ ਯਿਹੂਦੀਯਲੋਕਾਃ ਸਨ੍ਤੋਪਿ ਤਦੇਵ ਸ਼ਿਕ੍ਸ਼਼ਯਿਤ੍ਵਾ ਨਗਰੇ(ਅ)ਸ੍ਮਾਕਮ੍ ਅਤੀਵ ਕਲਹੰ ਕੁਰ੍ੱਵਨ੍ਤਿ, ");
INSERT INTO sanpun_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","ਇਤਿ ਕਥਿਤੇ ਸਤਿ ਲੋਕਨਿਵਹਸ੍ਤਯੋਃ ਪ੍ਰਾਤਿਕੂਲ੍ਯੇਨੋਦਤਿਸ਼਼੍ਠਤ੍ ਤਥਾ ਸ਼ਾਸਕਾਸ੍ਤਯੋ ਰ੍ਵਸ੍ਤ੍ਰਾਣਿ ਛਿਤ੍ਵਾ ਵੇਤ੍ਰਾਘਾਤੰ ਕਰ੍ੱਤੁਮ੍ ਆਜ੍ਞਾਪਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","ਅਪਰੰ ਤੇ ਤੌ ਬਹੁ ਪ੍ਰਹਾਰ੍ੱਯ ਤ੍ਵਮੇਤੌ ਕਾਰਾਂ ਨੀਤ੍ਵਾ ਸਾਵਧਾਨੰ ਰਕ੍ਸ਼਼ਯੇਤਿ ਕਾਰਾਰਕ੍ਸ਼਼ਕਮ੍ ਆਦਿਸ਼ਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ਇੱਥਮ੍ ਆਜ੍ਞਾਂ ਪ੍ਰਾਪ੍ਯ ਸ ਤਾਵਭ੍ਯਨ੍ਤਰਸ੍ਥਕਾਰਾਂ ਨੀਤ੍ਵਾ ਪਾਦੇਸ਼਼ੁ ਪਾਦਪਾਸ਼ੀਭਿ ਰ੍ਬੱਧ੍ਵਾ ਸ੍ਥਾਪਿਤਾਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","ਅਥ ਨਿਸ਼ੀਥਸਮਯੇ ਪੌਲਸੀਲਾਵੀਸ਼੍ਵਰਮੁੱਦਿਸ਼੍ਯ ਪ੍ਰਾਥਨਾਂ ਗਾਨਞ੍ਚ ਕ੍ਰੁʼਤਵਨ੍ਤੌ, ਕਾਰਾਸ੍ਥਿਤਾ ਲੋਕਾਸ਼੍ਚ ਤਦਸ਼੍ਰੁʼਣ੍ਵਨ੍ ");
INSERT INTO sanpun_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ਤਦਾਕਸ੍ਮਾਤ੍ ਮਹਾਨ੍ ਭੂਮਿਕਮ੍ਪੋ(ਅ)ਭਵਤ੍ ਤੇਨ ਭਿੱਤਿਮੂਲੇਨ ਸਹ ਕਾਰਾ ਕਮ੍ਪਿਤਾਭੂਤ੍ ਤਤ੍ਕ੍ਸ਼਼ਣਾਤ੍ ਸਰ੍ੱਵਾਣਿ ਦ੍ਵਾਰਾਣਿ ਮੁਕ੍ਤਾਨਿ ਜਾਤਾਨਿ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਬਨ੍ਧਨਾਨਿ ਚ ਮੁਕ੍ਤਾਨਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","ਅਤਏਵ ਕਾਰਾਰਕ੍ਸ਼਼ਕੋ ਨਿਦ੍ਰਾਤੋ ਜਾਗਰਿਤ੍ਵਾ ਕਾਰਾਯਾ ਦ੍ਵਾਰਾਣਿ ਮੁਕ੍ਤਾਨਿ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਬਨ੍ਦਿਲੋਕਾਃ ਪਲਾਯਿਤਾ ਇਤ੍ਯਨੁਮਾਯ ਕੋਸ਼਼ਾਤ੍ ਖਙ੍ਗੰ ਬਹਿਃ ਕ੍ਰੁʼਤ੍ਵਾਤ੍ਮਘਾਤੰ ਕਰ੍ੱਤੁਮ੍ ਉਦ੍ਯਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","ਕਿਨ੍ਤੁ ਪੌਲਃ ਪ੍ਰੋੱਚੈਸ੍ਤਮਾਹੂਯ ਕਥਿਤਵਾਨ੍ ਪਸ਼੍ਯ ਵਯੰ ਸਰ੍ੱਵੇ(ਅ)ਤ੍ਰਾਸ੍ਮਹੇ, ਤ੍ਵੰ ਨਿਜਪ੍ਰਾਣਹਿੰਸਾਂ ਮਾਕਾਰ੍ਸ਼਼ੀਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","ਤਦਾ ਪ੍ਰਦੀਪਮ੍ ਆਨੇਤੁਮ੍ ਉਕ੍ਤ੍ਵਾ ਸ ਕਮ੍ਪਮਾਨਃ ਸਨ੍ ਉੱਲਮ੍ਪ੍ਯਾਭ੍ਯਨ੍ਤਰਮ੍ ਆਗਤ੍ਯ ਪੌਲਸੀਲਯੋਃ ਪਾਦੇਸ਼਼ੁ ਪਤਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ਪਸ਼੍ਚਾਤ੍ ਸ ਤੌ ਬਹਿਰਾਨੀਯ ਪ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍ ਹੇ ਮਹੇੱਛੌ ਪਰਿਤ੍ਰਾਣੰ ਪ੍ਰਾਪ੍ਤੁੰ ਮਯਾ ਕਿੰ ਕਰ੍ੱਤਵ੍ਯੰ? ");
INSERT INTO sanpun_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","ਪਸ਼੍ਚਾਤ੍ ਤੌ ਸ੍ਵਗ੍ਰੁʼਹਮਾਨੀਯ ਤਯੋਃ ਸੰਮੁਖੇ ਖਾਦ੍ਯਦ੍ਰਵ੍ਯਾਣਿ ਸ੍ਥਾਪਿਤਵਾਨ੍ ਤਥਾ ਸ ਸ੍ਵਯੰ ਤਦੀਯਾਃ ਸਰ੍ੱਵੇ ਪਰਿਵਾਰਾਸ਼੍ਚੇਸ਼੍ਵਰੇ ਵਿਸ਼੍ਵਸਨ੍ਤਃ ਸਾਨਨ੍ਦਿਤਾ ਅਭਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ਤਸ੍ਮੈ ਤਸ੍ਯ ਗ੍ਰੁʼਹਸ੍ਥਿਤਸਰ੍ੱਵਲੋਕੇਭ੍ਯਸ਼੍ਚ ਪ੍ਰਭੋਃ ਕਥਾਂ ਕਥਿਤਵਨ੍ਤੌ| ");
INSERT INTO sanpun_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","ਤਥਾ ਰਾਤ੍ਰੇਸ੍ਤਸ੍ਮਿੰਨੇਵ ਦਣ੍ਡੇ ਸ ਤੌ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਤਯੋਃ ਪ੍ਰਹਾਰਾਣਾਂ ਕ੍ਸ਼਼ਤਾਨਿ ਪ੍ਰਕ੍ਸ਼਼ਾਲਿਤਵਾਨ੍ ਤਤਃ ਸ ਸ੍ਵਯੰ ਤਸ੍ਯ ਸਰ੍ੱਵੇ ਪਰਿਜਨਾਸ਼੍ਚ ਮੱਜਿਤਾ ਅਭਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","ਪਸ਼੍ਚਾਤ੍ ਤੌ ਸ੍ਵਗ੍ਰੁʼਹਮਾਨੀਯ ਤਯੋਃ ਸੰਮੁਖੇ ਖਾਦ੍ਯਦ੍ਰਵ੍ਯਾਣਿ ਸ੍ਥਾਪਿਤਵਾਨ੍ ਤਥਾ ਸ ਸ੍ਵਯੰ ਤਦੀਯਾਃ ਸਰ੍ੱਵੇ ਪਰਿਵਾਰਾਸ਼੍ਚੇਸ਼੍ਵਰੇ ਵਿਸ਼੍ਵਸਨ੍ਤਃ ਸਾਨਨ੍ਦਿਤਾ ਅਭਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","ਦਿਨ ਉਪਸ੍ਥਿਤੇ ਤੌ ਲੋਕੌ ਮੋਚਯੇਤਿ ਕਥਾਂ ਕਥਯਿਤੁੰ ਸ਼ਾਸਕਾਃ ਪਦਾਤਿਗਣੰ ਪ੍ਰੇਸ਼਼ਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","ਤਤਃ ਕਾਰਾਰਕ੍ਸ਼਼ਕਃ ਪੌਲਾਯ ਤਾਂ ਵਾਰ੍ੱਤਾਂ ਕਥਿਤਵਾਨ੍ ਯੁਵਾਂ ਤ੍ਯਾਜਯਿਤੁੰ ਸ਼ਾਸਕਾ ਲੋਕਾਨ ਪ੍ਰੇਸ਼਼ਿਤਵਨ੍ਤ ਇਦਾਨੀਂ ਯੁਵਾਂ ਬਹਿ ਰ੍ਭੂਤ੍ਵਾ ਕੁਸ਼ਲੇਨ ਪ੍ਰਤਿਸ਼਼੍ਠੇਤਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","ਕਿਨ੍ਤੁ ਪੌਲਸ੍ਤਾਨ੍ ਅਵਦਤ੍ ਰੋਮਿਲੋਕਯੋਰਾਵਯੋਃ ਕਮਪਿ ਦੋਸ਼਼ਮ੍ ਨ ਨਿਸ਼੍ਚਿਤ੍ਯ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਸਮਕ੍ਸ਼਼ਮ੍ ਆਵਾਂ ਕਸ਼ਯਾ ਤਾਡਯਿਤ੍ਵਾ ਕਾਰਾਯਾਂ ਬੱਧਵਨ੍ਤ ਇਦਾਨੀਂ ਕਿਮਾਵਾਂ ਗੁਪ੍ਤੰ ਵਿਸ੍ਤ੍ਰਕ੍ਸ਼਼੍ਯਨ੍ਤਿ? ਤੰਨ ਭਵਿਸ਼਼੍ਯਤਿ, ਸ੍ਵਯਮਾਗਤ੍ਯਾਵਾਂ ਬਹਿਃ ਕ੍ਰੁʼਤ੍ਵਾ ਨਯਨ੍ਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","ਤਦਾ ਪਦਾਤਿਭਿਃ ਸ਼ਾਸਕੇਭ੍ਯ ਏਤਦ੍ਵਾਰ੍ੱਤਾਯਾਂ ਕਥਿਤਾਯਾਂ ਤੌ ਰੋਮਿਲੋਕਾਵਿਤਿ ਕਥਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਤੇ ਭੀਤਾਃ ");
INSERT INTO sanpun_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","ਸਨ੍ਤਸ੍ਤਯੋਃ ਸੰਨਿਧਿਮਾਗਤ੍ਯ ਵਿਨਯਮ੍ ਅਕੁਰ੍ੱਵਨ੍ ਅਪਰੰ ਬਹਿਃ ਕ੍ਰੁʼਤ੍ਵਾ ਨਗਰਾਤ੍ ਪ੍ਰਸ੍ਥਾਤੁੰ ਪ੍ਰਾਰ੍ਥਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ਤਤਸ੍ਤੌ ਕਾਰਾਯਾ ਨਿਰ੍ਗਤ੍ਯ ਲੁਦਿਯਾਯਾ ਗ੍ਰੁʼਹੰ ਗਤਵਨ੍ਤੌ ਤਤ੍ਰ ਭ੍ਰਾਤ੍ਰੁʼਗਣੰ ਸਾਕ੍ਸ਼਼ਾਤ੍ਕ੍ਰੁʼਤ੍ਯ ਤਾਨ੍ ਸਾਨ੍ਤ੍ਵਯਿਤ੍ਵਾ ਤਸ੍ਮਾਤ੍ ਸ੍ਥਾਨਾਤ੍ ਪ੍ਰਸ੍ਥਿਤੌ| ");
INSERT INTO sanpun_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","ਪੌਲਸੀਲੌ ਆਮ੍ਫਿਪਲ੍ਯਾਪੱਲੋਨਿਯਾਨਗਰਾਭ੍ਯਾਂ ਗਤ੍ਵਾ ਯਤ੍ਰ ਯਿਹੂਦੀਯਾਨਾਂ ਭਜਨਭਵਨਮੇਕਮ੍ ਆਸ੍ਤੇ ਤਤ੍ਰ ਥਿਸ਼਼ਲਨੀਕੀਨਗਰ ਉਪਸ੍ਥਿਤੌ| ");
INSERT INTO sanpun_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","ਤਦਾ ਪੌਲਃ ਸ੍ਵਾਚਾਰਾਨੁਸਾਰੇਣ ਤੇਸ਼਼ਾਂ ਸਮੀਪੰ ਗਤ੍ਵਾ ਵਿਸ਼੍ਰਾਮਵਾਰਤ੍ਰਯੇ ਤੈਃ ਸਾਰ੍ੱਧੰ ਧਰ੍ੰਮਪੁਸ੍ਤਕੀਯਕਥਾਯਾ ਵਿਚਾਰੰ ਕ੍ਰੁʼਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ਫਲਤਃ ਖ੍ਰੀਸ਼਼੍ਟੇਨ ਦੁਃਖਭੋਗਃ ਕਰ੍ੱਤਵ੍ਯਃ ਸ਼੍ਮਸ਼ਾਨਦੁੱਥਾਨਞ੍ਚ ਕਰ੍ੱਤਵ੍ਯੰ ਯੁਸ਼਼੍ਮਾਕੰ ਸੰਨਿਧੌ ਯਸ੍ਯ ਯੀਸ਼ੋਃ ਪ੍ਰਸ੍ਤਾਵੰ ਕਰੋਮਿ ਸ ਈਸ਼੍ਵਰੇਣਾਭਿਸ਼਼ਿਕ੍ਤਃ ਸ ਏਤਾਃ ਕਥਾਃ ਪ੍ਰਕਾਸ਼੍ਯ ਪ੍ਰਮਾਣੰ ਦਤ੍ਵਾ ਸ੍ਥਿਰੀਕ੍ਰੁʼਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","ਤਸ੍ਮਾਤ੍ ਤੇਸ਼਼ਾਂ ਕਤਿਪਯਜਨਾ ਅਨ੍ਯਦੇਸ਼ੀਯਾ ਬਹਵੋ ਭਕ੍ਤਲੋਕਾ ਬਹ੍ਯਃ ਪ੍ਰਧਾਨਨਾਰ੍ੱਯਸ਼੍ਚ ਵਿਸ਼੍ਵਸ੍ਯ ਪੌਲਸੀਲਯੋਃ ਪਸ਼੍ਚਾਦ੍ਗਾਮਿਨੋ ਜਾਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","ਕਿਨ੍ਤੁ ਵਿਸ਼੍ਵਾਸਹੀਨਾ ਯਿਹੂਦੀਯਲੋਕਾ ਈਰ੍ਸ਼਼੍ਯਯਾ ਪਰਿਪੂਰ੍ਣਾਃ ਸਨ੍ਤੋ ਹਟਟ੍ਸ੍ਯ ਕਤਿਨਯਲਮ੍ਪਟਲੋਕਾਨ੍ ਸਙ੍ਗਿਨਃ ਕ੍ਰੁʼਤ੍ਵਾ ਜਨਤਯਾ ਨਗਰਮਧ੍ਯੇ ਮਹਾਕਲਹੰ ਕ੍ਰੁʼਤ੍ਵਾ ਯਾਸੋਨੋ ਗ੍ਰੁʼਹਮ੍ ਆਕ੍ਰਮ੍ਯ ਪ੍ਰੇਰਿਤਾਨ੍ ਧ੍ਰੁʼਤ੍ਵਾ ਲੋਕਨਿਵਹਸ੍ਯ ਸਮੀਪਮ੍ ਆਨੇਤੁੰ ਚੇਸ਼਼੍ਟਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","ਤੇਸ਼਼ਾਮੁੱਦੇਸ਼ਮ੍ ਅਪ੍ਰਾਪ੍ਯ ਚ ਯਾਸੋਨੰ ਕਤਿਪਯਾਨ੍ ਭ੍ਰਾਤ੍ਰੁਂʼਸ਼੍ਚ ਧ੍ਰੁʼਤ੍ਵਾ ਨਗਰਾਧਿਪਤੀਨਾਂ ਨਿਕਟਮਾਨੀਯ ਪ੍ਰੋੱਚੈਃ ਕਥਿਤਵਨ੍ਤੋ ਯੇ ਮਨੁਸ਼਼੍ਯਾ ਜਗਦੁਦ੍ਵਾਟਿਤਵਨ੍ਤਸ੍ਤੇ (ਅ)ਤ੍ਰਾਪ੍ਯੁਪਸ੍ਥਿਤਾਃ ਸਨ੍ਤਿ, ");
INSERT INTO sanpun_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ਏਸ਼਼ ਯਾਸੋਨ੍ ਆਤਿਥ੍ਯੰ ਕ੍ਰੁʼਤ੍ਵਾ ਤਾਨ੍ ਗ੍ਰੁʼਹੀਤਵਾਨ੍| ਯੀਸ਼ੁਨਾਮਕ ਏਕੋ ਰਾਜਸ੍ਤੀਤਿ ਕਥਯਨ੍ਤਸ੍ਤੇ ਕੈਸਰਸ੍ਯਾਜ੍ਞਾਵਿਰੁੱਧੰ ਕਰ੍ੰਮ ਕੁਰ੍ੱਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","ਤੇਸ਼਼ਾਂ ਕਥਾਮਿਮਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਲੋਕਨਿਵਹੋ ਨਗਰਾਧਿਪਤਯਸ਼੍ਚ ਸਮੁਦ੍ਵਿਗ੍ਨਾ ਅਭਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ਤਦਾ ਯਾਸੋਨਸ੍ਤਦਨ੍ਯੇਸ਼਼ਾਞ੍ਚ ਧਨਦਣ੍ਡੰ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਤਾਨ੍ ਪਰਿਤ੍ਯਕ੍ਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","ਤਤਃ ਪਰੰ ਭ੍ਰਾਤ੍ਰੁʼਗਣੋ ਰਜਨ੍ਯਾਂ ਪੌਲਸੀਲੌ ਸ਼ੀਘ੍ਰੰ ਬਿਰਯਾਨਗਰੰ ਪ੍ਰੇਸ਼਼ਿਤਵਾਨ੍ ਤੌ ਤਤ੍ਰੋਪਸ੍ਥਾਯ ਯਿਹੂਦੀਯਾਨਾਂ ਭਜਨਭਵਨੰ ਗਤਵਨ੍ਤੌ| ");
INSERT INTO sanpun_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","ਤਤ੍ਰਸ੍ਥਾ ਲੋਕਾਃ ਥਿਸ਼਼ਲਨੀਕੀਸ੍ਥਲੋਕੇਭ੍ਯੋ ਮਹਾਤ੍ਮਾਨ ਆਸਨ੍ ਯਤ ਇੱਥੰ ਭਵਤਿ ਨ ਵੇਤਿ ਜ੍ਞਾਤੁੰ ਦਿਨੇ ਦਿਨੇ ਧਰ੍ੰਮਗ੍ਰਨ੍ਥਸ੍ਯਾਲੋਚਨਾਂ ਕ੍ਰੁʼਤ੍ਵਾ ਸ੍ਵੈਰੰ ਕਥਾਮ੍ ਅਗ੍ਰੁʼਹ੍ਲਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ਤਸ੍ਮਾਦ੍ ਅਨੇਕੇ ਯਿਹੂਦੀਯਾ ਅਨ੍ਯਦੇਸ਼ੀਯਾਨਾਂ ਮਾਨ੍ਯਾ ਸ੍ਤ੍ਰਿਯਃ ਪੁਰੁਸ਼਼ਾਸ਼੍ਚਾਨੇਕੇ ਵ੍ਯਸ਼੍ਵਸਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","ਕਿਨ੍ਤੁ ਬਿਰਯਾਨਗਰੇ ਪੌਲੇਨੇਸ਼੍ਵਰੀਯਾ ਕਥਾ ਪ੍ਰਚਾਰ੍ੱਯਤ ਇਤਿ ਥਿਸ਼਼ਲਨੀਕੀਸ੍ਥਾ ਯਿਹੂਦੀਯਾ ਜ੍ਞਾਤ੍ਵਾ ਤਤ੍ਸ੍ਥਾਨਮਪ੍ਯਾਗਤ੍ਯ ਲੋਕਾਨਾਂ ਕੁਪ੍ਰਵ੍ਰੁʼੱਤਿਮ੍ ਅਜਨਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","ਅਤਏਵ ਤਸ੍ਮਾਤ੍ ਸ੍ਥਾਨਾਤ੍ ਸਮੁਦ੍ਰੇਣ ਯਾਨ੍ਤੀਤਿ ਦਰ੍ਸ਼ਯਿਤ੍ਵਾ ਭ੍ਰਾਤਰਃ ਕ੍ਸ਼਼ਿਪ੍ਰੰ ਪੌਲੰ ਪ੍ਰਾਹਿਣ੍ਵਨ੍ ਕਿਨ੍ਤੁ ਸੀਲਤੀਮਥਿਯੌ ਤਤ੍ਰ ਸ੍ਥਿਤਵਨ੍ਤੌ| ");
INSERT INTO sanpun_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","ਤਤਃ ਪਰੰ ਪੌਲਸ੍ਯ ਮਾਰ੍ਗਦਰ੍ਸ਼ਕਾਸ੍ਤਮ੍ ਆਥੀਨੀਨਗਰ ਉਪਸ੍ਥਾਪਯਨ੍ ਪਸ਼੍ਚਾਦ੍ ਯੁਵਾਂ ਤੂਰ੍ਣਮ੍ ਏਤਤ੍ ਸ੍ਥਾਨੰ ਆਗਮਿਸ਼਼੍ਯਥਃ ਸੀਲਤੀਮਥਿਯੌ ਪ੍ਰਤੀਮਾਮ੍ ਆਜ੍ਞਾਂ ਪ੍ਰਾਪ੍ਯ ਤੇ ਪ੍ਰਤ੍ਯਾਗਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","ਪੌਲ ਆਥੀਨੀਨਗਰੇ ਤਾਵਪੇਕ੍ਸ਼਼੍ਯ ਤਿਸ਼਼੍ਠਨ੍ ਤੰਨਗਰੰ ਪ੍ਰਤਿਮਾਭਿਃ ਪਰਿਪੂਰ੍ਣੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਸਨ੍ਤਪ੍ਤਹ੍ਰੁʼਦਯੋ (ਅ)ਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","ਤਤਃ ਸ ਭਜਨਭਵਨੇ ਯਾਨ੍ ਯਿਹੂਦੀਯਾਨ੍ ਭਕ੍ਤਲੋਕਾਂਸ਼੍ਚ ਹੱਟੇ ਚ ਯਾਨ੍ ਅਪਸ਼੍ਯਤ੍ ਤੈਃ ਸਹ ਪ੍ਰਤਿਦਿਨੰ ਵਿਚਾਰਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","ਕਿਨ੍ਤ੍ਵਿਪਿਕੂਰੀਯਮਤਗ੍ਰਹਿਣਃ ਸ੍ਤੋਯਿਕੀਯਮਤਗ੍ਰਾਹਿਣਸ਼੍ਚ ਕਿਯਨ੍ਤੋ ਜਨਾਸ੍ਤੇਨ ਸਾਰ੍ੱਧੰ ਵ੍ਯਵਦਨ੍ਤ| ਤਤ੍ਰ ਕੇਚਿਦ੍ ਅਕਥਯਨ੍ ਏਸ਼਼ ਵਾਚਾਲਃ ਕਿੰ ਵਕ੍ਤੁਮ੍ ਇੱਛਤਿ? ਅਪਰੇ ਕੇਚਿਦ੍ ਏਸ਼਼ ਜਨਃ ਕੇਸ਼਼ਾਞ੍ਚਿਦ੍ ਵਿਦੇਸ਼ੀਯਦੇਵਾਨਾਂ ਪ੍ਰਚਾਰਕ ਇਤ੍ਯਨੁਮੀਯਤੇ ਯਤਃ ਸ ਯੀਸ਼ੁਮ੍ ਉੱਥਿਤਿਞ੍ਚ ਪ੍ਰਚਾਰਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","ਤੇ ਤਮ੍ ਅਰੇਯਪਾਗਨਾਮ ਵਿਚਾਰਸ੍ਥਾਨਮ੍ ਆਨੀਯ ਪ੍ਰਾਵੋਚਨ੍ ਇਦੰ ਯੰਨਵੀਨੰ ਮਤੰ ਤ੍ਵੰ ਪ੍ਰਾਚੀਕਸ਼ ਇਦੰ ਕੀਦ੍ਰੁʼਸ਼ੰ ਏਤਦ੍ ਅਸ੍ਮਾਨ੍ ਸ਼੍ਰਾਵਯ; ");
INSERT INTO sanpun_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","ਯਾਮਿਮਾਮ੍ ਅਸਮ੍ਭਵਕਥਾਮ੍ ਅਸ੍ਮਾਕੰ ਕਰ੍ਣਗੋਚਰੀਕ੍ਰੁʼਤਵਾਨ੍ ਅਸ੍ਯਾ ਭਾਵਾਰ੍ਥਃ ਕ ਇਤਿ ਵਯੰ ਜ੍ਞਾਤੁਮ੍ ਇੱਛਾਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","ਤਦਾਥੀਨੀਨਿਵਾਸਿਨਸ੍ਤੰਨਗਰਪ੍ਰਵਾਸਿਨਸ਼੍ਚ ਕੇਵਲੰ ਕਸ੍ਯਾਸ਼੍ਚਨ ਨਵੀਨਕਥਾਯਾਃ ਸ਼੍ਰਵਣੇਨ ਪ੍ਰਚਾਰਣੇਨ ਚ ਕਾਲਮ੍ ਅਯਾਪਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","ਪੌਲੋ(ਅ)ਰੇਯਪਾਗਸ੍ਯ ਮਧ੍ਯੇ ਤਿਸ਼਼੍ਠਨ੍ ਏਤਾਂ ਕਥਾਂ ਪ੍ਰਚਾਰਿਤਵਾਨ੍, ਹੇ ਆਥੀਨੀਯਲੋਕਾ ਯੂਯੰ ਸਰ੍ੱਵਥਾ ਦੇਵਪੂਜਾਯਾਮ੍ ਆਸਕ੍ਤਾ ਇਤ੍ਯਹ ਪ੍ਰਤ੍ਯਕ੍ਸ਼਼ੰ ਪਸ਼੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","ਯਤਃ ਪਰ੍ੱਯਟਨਕਾਲੇ ਯੁਸ਼਼੍ਮਾਕੰ ਪੂਜਨੀਯਾਨਿ ਪਸ਼੍ਯਨ੍ ‘ਅਵਿਜ੍ਞਾਤੇਸ਼੍ਵਰਾਯ’ ਏਤੱਲਿਪਿਯੁਕ੍ਤਾਂ ਯਜ੍ਞਵੇਦੀਮੇਕਾਂ ਦ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍; ਅਤੋ ਨ ਵਿਦਿਤ੍ਵਾ ਯੰ ਪੂਜਯਧ੍ਵੇ ਤਸ੍ਯੈਵ ਤਤ੍ਵੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਪ੍ਰਤਿ ਪ੍ਰਚਾਰਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ਜਗਤੋ ਜਗਤ੍ਸ੍ਥਾਨਾਂ ਸਰ੍ੱਵਵਸ੍ਤੂਨਾਞ੍ਚ ਸ੍ਰਸ਼਼੍ਟਾ ਯ ਈਸ਼੍ਵਰਃ ਸ ਸ੍ਵਰ੍ਗਪ੍ਰੁʼਥਿਵ੍ਯੋਰੇਕਾਧਿਪਤਿਃ ਸਨ੍ ਕਰਨਿਰ੍ੰਮਿਤਮਨ੍ਦਿਰੇਸ਼਼ੁ ਨ ਨਿਵਸਤਿ; ");
INSERT INTO sanpun_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ਸ ਏਵ ਸਰ੍ੱਵੇਭ੍ਯੋ ਜੀਵਨੰ ਪ੍ਰਾਣਾਨ੍ ਸਰ੍ੱਵਸਾਮਗ੍ਰੀਸ਼੍ਚ ਪ੍ਰਦਦਾਤਿ; ਅਤਏਵ ਸ ਕਸ੍ਯਾਸ਼੍ਚਿਤ੍ ਸਾਮਗ੍ਯ੍ਰਾ ਅਭਾਵਹੇਤੋ ਰ੍ਮਨੁਸ਼਼੍ਯਾਣਾਂ ਹਸ੍ਤੈਃ ਸੇਵਿਤੋ ਭਵਤੀਤਿ ਨ| ");
INSERT INTO sanpun_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ਸ ਭੂਮਣ੍ਡਲੇ ਨਿਵਾਸਾਰ੍ਥਮ੍ ਏਕਸ੍ਮਾਤ੍ ਸ਼ੋਣਿਤਾਤ੍ ਸਰ੍ੱਵਾਨ੍ ਮਨੁਸ਼਼੍ਯਾਨ੍ ਸ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਤੇਸ਼਼ਾਂ ਪੂਰ੍ੱਵਨਿਰੂਪਿਤਸਮਯੰ ਵਸਤਿਸੀਮਾਞ੍ਚ ਨਿਰਚਿਨੋਤ੍; ");
INSERT INTO sanpun_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ਤਸ੍ਮਾਤ੍ ਲੋਕੈਃ ਕੇਨਾਪਿ ਪ੍ਰਕਾਰੇਣ ਮ੍ਰੁʼਗਯਿਤ੍ਵਾ ਪਰਮੇਸ਼੍ਵਰਸ੍ਯ ਤਤ੍ਵੰ ਪ੍ਰਾਪ੍ਤੁੰ ਤਸ੍ਯ ਗਵੇਸ਼਼ਣੰ ਕਰਣੀਯਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","ਕਿਨ੍ਤੁ ਸੋ(ਅ)ਸ੍ਮਾਕੰ ਕਸ੍ਮਾੱਚਿਦਪਿ ਦੂਰੇ ਤਿਸ਼਼੍ਠਤੀਤਿ ਨਹਿ, ਵਯੰ ਤੇਨ ਨਿਸ਼੍ਵਸਨਪ੍ਰਸ਼੍ਵਸਨਗਮਨਾਗਮਨਪ੍ਰਾਣਧਾਰਣਾਨਿ ਕੁਰ੍ੰਮਃ, ਪੁुਨਸ਼੍ਚ ਯੁਸ਼਼੍ਮਾਕਮੇਵ ਕਤਿਪਯਾਃ ਕਵਯਃ ਕਥਯਨ੍ਤਿ ‘ਤਸ੍ਯ ਵੰਸ਼ਾ ਵਯੰ ਸ੍ਮੋ ਹਿ’ ਇਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","ਅਤਏਵ ਯਦਿ ਵਯਮ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਵੰਸ਼ਾ ਭਵਾਮਸ੍ਤਰ੍ਹਿ ਮਨੁਸ਼਼੍ਯੈ ਰ੍ਵਿਦ੍ਯਯਾ ਕੌਸ਼ਲੇਨ ਚ ਤਕ੍ਸ਼਼ਿਤੰ ਸ੍ਵਰ੍ਣੰ ਰੂਪ੍ਯੰ ਦ੍ਰੁʼਸ਼਼ਦ੍ ਵੈਤੇਸ਼਼ਾਮੀਸ਼੍ਵਰਤ੍ਵਮ੍ ਅਸ੍ਮਾਭਿ ਰ੍ਨ ਜ੍ਞਾਤਵ੍ਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","ਤੇਸ਼਼ਾਂ ਪੂਰ੍ੱਵੀਯਲੋਕਾਨਾਮ੍ ਅਜ੍ਞਾਨਤਾਂ ਪ੍ਰਤੀਸ਼੍ਵਰੋ ਯਦ੍ਯਪਿ ਨਾਵਾਧੱਤ ਤਥਾਪੀਦਾਨੀਂ ਸਰ੍ੱਵਤ੍ਰ ਸਰ੍ੱਵਾਨ੍ ਮਨਃ ਪਰਿਵਰ੍ੱਤਯਿਤੁਮ੍ ਆਜ੍ਞਾਪਯਤਿ, ");
INSERT INTO sanpun_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","ਯਤਃ ਸ੍ਵਨਿਯੁਕ੍ਤੇਨ ਪੁਰੁਸ਼਼ੇਣ ਯਦਾ ਸ ਪ੍ਰੁʼਥਿਵੀਸ੍ਥਾਨਾਂ ਸਰ੍ੱਵਲੋਕਾਨਾਂ ਵਿਚਾਰੰ ਕਰਿਸ਼਼੍ਯਤਿ ਤੱਦਿਨੰ ਨ੍ਯਰੂਪਯਤ੍; ਤਸ੍ਯ ਸ਼੍ਮਸ਼ਾਨੋੱਥਾਪਨੇਨ ਤਸ੍ਮਿਨ੍ ਸਰ੍ੱਵੇਭ੍ਯਃ ਪ੍ਰਮਾਣੰ ਪ੍ਰਾਦਾਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","ਤਦਾ ਸ਼੍ਮਸ਼ਾਨਾਦ੍ ਉੱਥਾਨਸ੍ਯ ਕਥਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਕੇਚਿਦ੍ ਉਪਾਹਮਨ੍, ਕੇਚਿਦਵਦਨ੍ ਏਨਾਂ ਕਥਾਂ ਪੁਨਰਪਿ ਤ੍ਵੱਤਃ ਸ਼੍ਰੋਸ਼਼੍ਯਾਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","ਤਤਃ ਪੌਲਸ੍ਤੇਸ਼਼ਾਂ ਸਮੀਪਾਤ੍ ਪ੍ਰਸ੍ਥਿाਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","ਤਥਾਪਿ ਕੇਚਿੱਲੋਕਾਸ੍ਤੇਨ ਸਾਰ੍ੱਧੰ ਮਿਲਿਤ੍ਵਾ ਵ੍ਯਸ਼੍ਵਸਨ੍ ਤੇਸ਼਼ਾਂ ਮਧ੍ਯੇ (ਅ)ਰੇਯਪਾਗੀਯਦਿਯਨੁਸਿਯੋ ਦਾਮਾਰੀਨਾਮਾ ਕਾਚਿੰਨਾਰੀ ਕਿਯਨ੍ਤੋ ਨਰਾਸ਼੍ਚਾਸਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","ਤਦ੍ਘਟਨਾਤਃ ਪਰੰ ਪੌਲ ਆਥੀਨੀਨਗਰਾਦ੍ ਯਾਤ੍ਰਾਂ ਕ੍ਰੁʼਤ੍ਵਾ ਕਰਿਨ੍ਥਨਗਰਮ੍ ਆਗੱਛਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","ਤਸ੍ਮਿਨ੍ ਸਮਯੇ ਕ੍ਲੌਦਿਯਃ ਸਰ੍ੱਵਾਨ੍ ਯਿਹੂਦੀਯਾਨ੍ ਰੋਮਾਨਗਰੰ ਵਿਹਾਯ ਗਨ੍ਤੁਮ੍ ਆਜ੍ਞਾਪਯਤ੍, ਤਸ੍ਮਾਤ੍ ਪ੍ਰਿਸ੍ਕਿੱਲਾਨਾਮ੍ਨਾ ਜਾਯਯਾ ਸਾਰ੍ੱਧਮ੍ ਇਤਾਲਿਯਾਦੇਸ਼ਾਤ੍ ਕਿਞ੍ਚਿਤ੍ਪੂਰ੍ੱਵਮ੍ ਆਗਮਤ੍ ਯਃ ਪਨ੍ਤਦੇਸ਼ੇ ਜਾਤ ਆੱਕਿਲਨਾਮਾ ਯਿਹੂਦੀਯਲੋਕਃ ਪੌਲਸ੍ਤੰ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਪ੍ਰਾਪ੍ਯ ਤਯੋਃ ਸਮੀਪਮਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ਤੌ ਦੂਸ਼਼੍ਯਨਿਰ੍ੰਮਾਣਜੀਵਿਨੌ, ਤਸ੍ਮਾਤ੍ ਪਰਸ੍ਪਰਮ੍ ਏਕਵ੍ਰੁʼੱਤਿਕਤ੍ਵਾਤ੍ ਸ ਤਾਭ੍ਯਾਂ ਸਹ ਉਸ਼਼ਿਤ੍ਵਾ ਤਤ੍ ਕਰ੍ੰਮਾਕਰੋਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","ਪੌਲਃ ਪ੍ਰਤਿਵਿਸ਼੍ਰਾਮਵਾਰੰ ਭਜਨਭਵਨੰ ਗਤ੍ਵਾ ਵਿਚਾਰੰ ਕ੍ਰੁʼਤ੍ਵਾ ਯਿਹੂਦੀਯਾਨ੍ ਅਨ੍ਯਦੇਸ਼ੀਯਾਂਸ਼੍ਚ ਪ੍ਰਵ੍ਰੁʼੱਤਿੰ ਗ੍ਰਾਹਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","ਸੀਲਤੀਮਥਿਯਯੋ ਰ੍ਮਾਕਿਦਨਿਯਾਦੇਸ਼ਾਤ੍ ਸਮੇਤਯੋਃ ਸਤੋਃ ਪੌਲ ਉੱਤਪ੍ਤਮਨਾ ਭੂਤ੍ਵਾ ਯੀਸ਼ੁਰੀਸ਼੍ਵਰੇਣਾਭਿਸ਼਼ਿਕ੍ਤੋ ਭਵਤੀਤਿ ਪ੍ਰਮਾਣੰ ਯਿਹੂਦੀਯਾਨਾਂ ਸਮੀਪੇ ਪ੍ਰਾਦਾਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","ਕਿਨ੍ਤੁ ਤੇ (ਅ)ਤੀਵ ਵਿਰੋਧੰ ਵਿਧਾਯ ਪਾਸ਼਼ਣ੍ਡੀਯਕਥਾਂ ਕਥਿਤਵਨ੍ਤਸ੍ਤਤਃ ਪੌਲੋ ਵਸ੍ਤ੍ਰੰ ਧੁਨ੍ਵਨ੍ ਏਤਾਂ ਕਥਾਂ ਕਥਿਤਵਾਨ੍, ਯੁਸ਼਼੍ਮਾਕੰ ਸ਼ੋਣਿਤਪਾਤਾਪਰਾਧੋ ਯੁਸ਼਼੍ਮਾਨ੍ ਪ੍ਰਤ੍ਯੇਵ ਭਵਤੁ, ਤੇਨਾਹੰ ਨਿਰਪਰਾਧੋ (ਅ)ਦ੍ਯਾਰਭ੍ਯ ਭਿੰਨਦੇਸ਼ੀਯਾਨਾਂ ਸਮੀਪੰ ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","ਸ ਤਸ੍ਮਾਤ੍ ਪ੍ਰਸ੍ਥਾਯ ਭਜਨਭਵਨਸਮੀਪਸ੍ਥਸ੍ਯ ਯੁਸ੍ਤਨਾਮ੍ਨ ਈਸ਼੍ਵਰਭਕ੍ਤਸ੍ਯ ਭਿੰਨਦੇਸ਼ੀਯਸ੍ਯ ਨਿਵੇਸ਼ਨੰ ਪ੍ਰਾਵਿਸ਼ਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","ਤਤਃ ਕ੍ਰੀਸ਼਼੍ਪਨਾਮਾ ਭਜਨਭਵਨਾਧਿਪਤਿਃ ਸਪਰਿਵਾਰਃ ਪ੍ਰਭੌ ਵ੍ਯਸ਼੍ਵਸੀਤ੍, ਕਰਿਨ੍ਥਨਗਰੀਯਾ ਬਹਵੋ ਲੋਕਾਸ਼੍ਚ ਸਮਾਕਰ੍ਣ੍ਯ ਵਿਸ਼੍ਵਸ੍ਯ ਮੱਜਿਤਾ ਅਭਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","ਕ੍ਸ਼਼ਣਦਾਯਾਂ ਪ੍ਰਭੁਃ ਪੌਲੰ ਦਰ੍ਸ਼ਨੰ ਦਤ੍ਵਾ ਭਾਸ਼਼ਿਤਵਾਨ੍, ਮਾ ਭੈਸ਼਼ੀਃ, ਮਾ ਨਿਰਸੀਃ ਕਥਾਂ ਪ੍ਰਚਾਰਯ| ");
INSERT INTO sanpun_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ਅਹੰ ਤ੍ਵਯਾ ਸਾਰ੍ੱਧਮ੍ ਆਸ ਹਿੰਸਾਰ੍ਥੰ ਕੋਪਿ ਤ੍ਵਾਂ ਸ੍ਪ੍ਰਸ਼਼੍ਟੁੰ ਨ ਸ਼ਕ੍ਸ਼਼੍ਯਤਿ ਨਗਰੇ(ਅ)ਸ੍ਮਿਨ੍ ਮਦੀਯਾ ਲੋਕਾ ਬਹਵ ਆਸਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","ਤਸ੍ਮਾਤ੍ ਪੌਲਸ੍ਤੰਨਗਰੇ ਪ੍ਰਾਯੇਣ ਸਾਰ੍ੱਧਵਤ੍ਸਰਪਰ੍ੱਯਨ੍ਤੰ ਸੰਸ੍ਥਾਯੇਸ਼੍ਵਰਸ੍ਯ ਕਥਾਮ੍ ਉਪਾਦਿਸ਼ਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","ਗਾੱਲਿਯਨਾਮਾ ਕਸ਼੍ਚਿਦ੍ ਆਖਾਯਾਦੇਸ਼ਸ੍ਯ ਪ੍ਰਾਡ੍ਵਿਵਾਕਃ ਸਮਭਵਤ੍, ਤਤੋ ਯਿਹੂਦੀਯਾ ਏਕਵਾਕ੍ਯਾਃ ਸਨ੍ਤਃ ਪੌਲਮ੍ ਆਕ੍ਰਮ੍ਯ ਵਿਚਾਰਸ੍ਥਾਨੰ ਨੀਤ੍ਵਾ ");
INSERT INTO sanpun_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","ਮਾਨੁਸ਼਼ ਏਸ਼਼ ਵ੍ਯਵਸ੍ਥਾਯ ਵਿਰੁੱਧਮ੍ ਈਸ਼੍ਵਰਭਜਨੰ ਕਰ੍ੱਤੁੰ ਲੋਕਾਨ੍ ਕੁਪ੍ਰਵ੍ਰੁʼੱਤਿੰ ਗ੍ਰਾਹਯਤੀਤਿ ਨਿਵੇਦਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","ਤਤਃ ਪੌਲੇ ਪ੍ਰਤ੍ਯੁੱਤਰੰ ਦਾਤੁਮ੍ ਉਦ੍ਯਤੇ ਸਤਿ ਗਾੱਲਿਯਾ ਯਿਹੂਦੀਯਾਨ੍ ਵ੍ਯਾਹਰਤ੍, ਯਦਿ ਕਸ੍ਯਚਿਦ੍ ਅਨ੍ਯਾਯਸ੍ਯ ਵਾਤਿਸ਼ਯਦੁਸ਼਼੍ਟਤਾਚਰਣਸ੍ਯ ਵਿਚਾਰੋ(ਅ)ਭਵਿਸ਼਼੍ਯਤ੍ ਤਰ੍ਹਿ ਯੁਸ਼਼੍ਮਾਕੰ ਕਥਾ ਮਯਾ ਸਹਨੀਯਾਭਵਿਸ਼਼੍ਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","ਕਿਨ੍ਤੁ ਯਦਿ ਕੇਵਲੰ ਕਥਾਯਾ ਵਾ ਨਾਮ੍ਨੋ ਵਾ ਯੁਸ਼਼੍ਮਾਕੰ ਵ੍ਯਵਸ੍ਥਾਯਾ ਵਿਵਾਦੋ ਭਵਤਿ ਤਰ੍ਹਿ ਤਸ੍ਯ ਵਿਚਾਰਮਹੰ ਨ ਕਰਿਸ਼਼੍ਯਾਮਿ, ਯੂਯੰ ਤਸ੍ਯ ਮੀਮਾਂਸਾਂ ਕੁਰੁਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","ਤਤਃ ਸ ਤਾਨ੍ ਵਿਚਾਰਸ੍ਥਾਨਾਦ੍ ਦੂਰੀਕ੍ਰੁʼਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","ਤਦਾ ਭਿੰਨਦੇਸ਼ੀਯਾਃ ਸੋਸ੍ਥਿਨਿਨਾਮਾਨੰ ਭਜਨਭਵਨਸ੍ਯ ਪ੍ਰਧਾਨਾਧਿਪਤਿੰ ਧ੍ਰੁʼਤ੍ਵਾ ਵਿਚਾਰਸ੍ਥਾਨਸ੍ਯ ਸੰਮੁਖੇ ਪ੍ਰਾਹਰਨ੍ ਤਥਾਪਿ ਗਾੱਲਿਯਾ ਤੇਸ਼਼ੁ ਸਰ੍ੱਵਕਰ੍ੰਮਸੁ ਨ ਮਨੋ ਨ੍ਯਦਧਾਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","ਪੌਲਸ੍ਤਤ੍ਰ ਪੁਨਰ੍ਬਹੁਦਿਨਾਨਿ ਨ੍ਯਵਸਤ੍, ਤਤੋ ਭ੍ਰਾਤ੍ਰੁʼਗਣਾਦ੍ ਵਿਸਰ੍ਜਨੰ ਪ੍ਰਾਪ੍ਯ ਕਿਞ੍ਚਨਵ੍ਰਤਨਿਮਿੱਤੰ ਕਿੰਕ੍ਰਿਯਾਨਗਰੇ ਸ਼ਿਰੋ ਮੁਣ੍ਡਯਿਤ੍ਵਾ ਪ੍ਰਿਸ੍ਕਿੱਲਾੱਕਿਲਾਭ੍ਯਾਂ ਸਹਿਤੋ ਜਲਪਥੇਨ ਸੁਰਿਯਾਦੇਸ਼ੰ ਗਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","ਤਤ ਇਫਿਸ਼਼ਨਗਰ ਉਪਸ੍ਥਾਯ ਤਤ੍ਰ ਤੌ ਵਿਸ੍ਰੁʼਜ੍ਯ ਸ੍ਵਯੰ ਭਜਨਭ੍ਵਨੰ ਪ੍ਰਵਿਸ਼੍ਯ ਯਿਹੂਦੀਯੈਃ ਸਹ ਵਿਚਾਰਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","ਤੇ ਸ੍ਵੈਃ ਸਾਰ੍ੱਧੰ ਪੁਨਃ ਕਤਿਪਯਦਿਨਾਨਿ ਸ੍ਥਾਤੁੰ ਤੰ ਵ੍ਯਨਯਨ੍, ਸ ਤਦਨੁਰਰੀਕ੍ਰੁʼਤ੍ਯ ਕਥਾਮੇਤਾਂ ਕਥਿਤਵਾਨ੍, ");
INSERT INTO sanpun_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ਯਿਰੂਸ਼ਾਲਮਿ ਆਗਾਮ੍ਯੁਤ੍ਸਵਪਾਲਨਾਰ੍ਥੰ ਮਯਾ ਗਮਨੀਯੰ; ਪਸ਼੍ਚਾਦ੍ ਈਸ਼੍ਵਰੇੱਛਾਯਾਂ ਜਾਤਾਯਾਂ ਯੁਸ਼਼੍ਮਾਕੰ ਸਮੀਪੰ ਪ੍ਰਤ੍ਯਾਗਮਿਸ਼਼੍ਯਾਮਿ| ਤਤਃ ਪਰੰ ਸ ਤੈ ਰ੍ਵਿਸ੍ਰੁʼਸ਼਼੍ਟਃ ਸਨ੍ ਜਲਪਥੇਨ ਇਫਿਸ਼਼ਨਗਰਾਤ੍ ਪ੍ਰਸ੍ਥਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","ਤਤਃ ਕੈਸਰਿਯਾਮ੍ ਉਪਸ੍ਥਿਤਃ ਸਨ੍ ਨਗਰੰ ਗਤ੍ਵਾ ਸਮਾਜੰ ਨਮਸ੍ਕ੍ਰੁʼਤ੍ਯ ਤਸ੍ਮਾਦ੍ ਆਨ੍ਤਿਯਖਿਯਾਨਗਰੰ ਪ੍ਰਸ੍ਥਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","ਤਤ੍ਰ ਕਿਯਤ੍ਕਾਲੰ ਯਾਪਯਿਤ੍ਵਾ ਤਸ੍ਮਾਤ੍ ਪ੍ਰਸ੍ਥਾਯ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਸ਼ਿਸ਼਼੍ਯਾਣਾਂ ਮਨਾਂਸਿ ਸੁਸ੍ਥਿਰਾਣਿ ਕ੍ਰੁʼਤ੍ਵਾ ਕ੍ਰਮਸ਼ੋ ਗਲਾਤਿਯਾਫ੍ਰੁਗਿਯਾਦੇਸ਼ਯੋ ਰ੍ਭ੍ਰਮਿਤ੍ਵਾ ਗਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","ਤਸ੍ਮਿੰਨੇਵ ਸਮਯੇ ਸਿਕਨ੍ਦਰਿਯਾਨਗਰੇ ਜਾਤ ਆਪੱਲੋਨਾਮਾ ਸ਼ਾਸ੍ਤ੍ਰਵਿਤ੍ ਸੁਵਕ੍ਤਾ ਯਿਹੂਦੀਯ ਏਕੋ ਜਨ ਇਫਿਸ਼਼ਨਗਰਮ੍ ਆਗਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","ਸ ਸ਼ਿਕ੍ਸ਼਼ਿਤਪ੍ਰਭੁਮਾਰ੍ਗੋ ਮਨਸੋਦ੍ਯੋਗੀ ਚ ਸਨ੍ ਯੋਹਨੋ ਮੱਜਨਮਾਤ੍ਰੰ ਜ੍ਞਾਤ੍ਵਾ ਯਥਾਰ੍ਥਤਯਾ ਪ੍ਰਭੋਃ ਕਥਾਂ ਕਥਯਨ੍ ਸਮੁਪਾਦਿਸ਼ਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ਏਸ਼਼ ਜਨੋ ਨਿਰ੍ਭਯਤ੍ਵੇਨ ਭਜਨਭਵਨੇ ਕਥਯਿਤੁਮ੍ ਆਰਬ੍ਧਵਾਨ੍, ਤਤਃ ਪ੍ਰਿਸ੍ਕਿੱਲਾੱਕਿਲੌ ਤਸ੍ਯੋਪਦੇਸ਼ਕਥਾਂ ਨਿਸ਼ਮ੍ਯ ਤੰ ਸ੍ਵਯੋਃ ਸਮੀਪਮ੍ ਆਨੀਯ ਸ਼ੁੱਧਰੂਪੇਣੇਸ਼੍ਵਰਸ੍ਯ ਕਥਾਮ੍ ਅਬੋਧਯਤਾਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","ਪਸ਼੍ਚਾਤ੍ ਸ ਆਖਾਯਾਦੇਸ਼ੰ ਗਨ੍ਤੁੰ ਮਤਿੰ ਕ੍ਰੁʼਤਵਾਨ੍, ਤਦਾ ਤਤ੍ਰਤ੍ਯਃ ਸ਼ਿਸ਼਼੍ਯਗਣੋ ਯਥਾ ਤੰ ਗ੍ਰੁʼਹ੍ਲਾਤਿ ਤਦਰ੍ਥੰ ਭ੍ਰਾਤ੍ਰੁʼਗਣੇਨ ਸਮਾਸ਼੍ਵਸ੍ਯ ਪਤ੍ਰੇ ਲਿਖਿਤੇ ਸਤਿ, ਆਪੱਲਾਸ੍ਤਤ੍ਰੋਪਸ੍ਥਿਤਃ ਸਨ੍ ਅਨੁਗ੍ਰਹੇਣ ਪ੍ਰਤ੍ਯਯਿਨਾਂ ਬਹੂਪਕਾਰਾਨ੍ ਅਕਰੋਤ੍, ");
INSERT INTO sanpun_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ਫਲਤੋ ਯੀਸ਼ੁਰਭਿਸ਼਼ਿਕ੍ਤਸ੍ਤ੍ਰਾਤੇਤਿ ਸ਼ਾਸ੍ਤ੍ਰਪ੍ਰਮਾਣੰ ਦਤ੍ਵਾ ਪ੍ਰਕਾਸ਼ਰੂਪੇਣ ਪ੍ਰਤਿਪੰਨੰ ਕ੍ਰੁʼਤ੍ਵਾ ਯਿਹੂਦੀਯਾਨ੍ ਨਿਰੁੱਤਰਾਨ੍ ਕ੍ਰੁʼਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","ਕਰਿਨ੍ਥਨਗਰ ਆਪੱਲਸਃ ਸ੍ਥਿਤਿਕਾਲੇ ਪੌਲ ਉੱਤਰਪ੍ਰਦੇਸ਼ੈਰਾਗੱਛਨ੍ ਇਫਿਸ਼਼ਨਗਰਮ੍ ਉਪਸ੍ਥਿਤਵਾਨ੍| ਤਤ੍ਰ ਕਤਿਪਯਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਸਾਕ੍ਸ਼਼ਤ੍ ਪ੍ਰਾਪ੍ਯ ਤਾਨ੍ ਅਪ੍ਰੁʼੱਛਤ੍, ");
INSERT INTO sanpun_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ਯੂਯੰ ਵਿਸ਼੍ਵਸ੍ਯ ਪਵਿਤ੍ਰਮਾਤ੍ਮਾਨੰ ਪ੍ਰਾਪ੍ਤਾ ਨ ਵਾ? ਤਤਸ੍ਤੇ ਪ੍ਰਤ੍ਯਵਦਨ੍ ਪਵਿਤ੍ਰ ਆਤ੍ਮਾ ਦੀਯਤੇ ਇਤ੍ਯਸ੍ਮਾਭਿਃ ਸ਼੍ਰੁਤਮਪਿ ਨਹਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","ਤਦਾ ਸਾ(ਅ)ਵਦਤ੍ ਤਰ੍ਹਿ ਯੂਯੰ ਕੇਨ ਮੱਜਿਤਾ ਅਭਵਤ? ਤੇ(ਅ)ਕਥਯਨ੍ ਯੋਹਨੋ ਮੱਜਨੇਨ| ");
INSERT INTO sanpun_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","ਤਦਾ ਪੌਲ ਉਕ੍ਤਵਾਨ੍ ਇਤਃ ਪਰੰ ਯ ਉਪਸ੍ਥਾਸ੍ਯਤਿ ਤਸ੍ਮਿਨ੍ ਅਰ੍ਥਤ ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟੇ ਵਿਸ਼੍ਵਸਿਤਵ੍ਯਮਿਤ੍ਯੁਕ੍ਤ੍ਵਾ ਯੋਹਨ੍ ਮਨਃਪਰਿਵਰ੍ੱਤਨਸੂਚਕੇਨ ਮੱਜਨੇਨ ਜਲੇ ਲੋਕਾਨ੍ ਅਮੱਜਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ਤਾਦ੍ਰੁʼਸ਼ੀਂ ਕਥਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਤੇ ਪ੍ਰਭੋ ਰ੍ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਨਾਮ੍ਨਾ ਮੱਜਿਤਾ ਅਭਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ਤਤਃ ਪੌਲੇਨ ਤੇਸ਼਼ਾਂ ਗਾਤ੍ਰੇਸ਼਼ੁ ਕਰੇ(ਅ)ਰ੍ਪਿਤੇ ਤੇਸ਼਼ਾਮੁਪਰਿ ਪਵਿਤ੍ਰ ਆਤ੍ਮਾਵਰੂਢਵਾਨ੍, ਤਸ੍ਮਾਤ੍ ਤੇ ਨਾਨਾਦੇਸ਼ੀਯਾ ਭਾਸ਼਼ਾ ਭਵਿਸ਼਼੍ਯਤ੍ਕਥਾਸ਼੍ਚ ਕਥਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","ਤੇ ਪ੍ਰਾਯੇਣ ਦ੍ਵਾਦਸ਼ਜਨਾ ਆਸਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","ਪੌਲੋ ਭਜਨਭਵਨੰ ਗਤ੍ਵਾ ਪ੍ਰਾਯੇਣ ਮਾਸਤ੍ਰਯਮ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਰਾਜ੍ਯਸ੍ਯ ਵਿਚਾਰੰ ਕ੍ਰੁʼਤ੍ਵਾ ਲੋਕਾਨ੍ ਪ੍ਰਵਰ੍ਤ੍ਯ ਸਾਹਸੇਨ ਕਥਾਮਕਥਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","ਕਿਨ੍ਤੁ ਕਠਿਨਾਨ੍ਤਃਕਰਣਤ੍ਵਾਤ੍ ਕਿਯਨ੍ਤੋ ਜਨਾ ਨ ਵਿਸ਼੍ਵਸ੍ਯ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਸਮਕ੍ਸ਼਼ਮ੍ ਏਤਤ੍ਪਥਸ੍ਯ ਨਿਨ੍ਦਾਂ ਕਰ੍ੱਤੁੰ ਪ੍ਰਵ੍ਰੁʼੱਤਾਃ, ਅਤਃ ਪੌਲਸ੍ਤੇਸ਼਼ਾਂ ਸਮੀਪਾਤ੍ ਪ੍ਰਸ੍ਥਾਯ ਸ਼ਿਸ਼਼੍ਯਗਣੰ ਪ੍ਰੁʼਥੱਕ੍ਰੁʼਤ੍ਵਾ ਪ੍ਰਤ੍ਯਹੰ ਤੁਰਾੰਨਨਾਮ੍ਨਃ ਕਸ੍ਯਚਿਤ੍ ਜਨਸ੍ਯ ਪਾਠਸ਼ਾਲਾਯਾਂ ਵਿਚਾਰੰ ਕ੍ਰੁʼਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ਇੱਥੰ ਵਤ੍ਸਰਦ੍ਵਯੰ ਗਤੰ ਤਸ੍ਮਾਦ੍ ਆਸ਼ਿਯਾਦੇਸ਼ਨਿਵਾਸਿਨਃ ਸਰ੍ੱਵੇ ਯਿਹੂਦੀਯਾ ਅਨ੍ਯਦੇਸ਼ੀਯਲੋਕਾਸ਼੍ਚ ਪ੍ਰਭੋ ਰ੍ਯੀਸ਼ੋਃ ਕਥਾਮ੍ ਅਸ਼੍ਰੌਸ਼਼ਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","ਪੌਲੇਨ ਚ ਈਸ਼੍ਵਰ ਏਤਾਦ੍ਰੁʼਸ਼ਾਨ੍ਯਦ੍ਭੁਤਾਨਿ ਕਰ੍ੰਮਾਣਿ ਕ੍ਰੁʼਤਵਾਨ੍ ");
INSERT INTO sanpun_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ਯਤ੍ ਪਰਿਧੇਯੇ ਗਾਤ੍ਰਮਾਰ੍ਜਨਵਸ੍ਤ੍ਰੇ ਵਾ ਤਸ੍ਯ ਦੇਹਾਤ੍ ਪੀਡਿਤਲੋਕਾਨਾਮ੍ ਸਮੀਪਮ੍ ਆਨੀਤੇ ਤੇ ਨਿਰਾਮਯਾ ਜਾਤਾ ਅਪਵਿਤ੍ਰਾ ਭੂਤਾਸ਼੍ਚ ਤੇਭ੍ਯੋ ਬਹਿਰ੍ਗਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","ਤਦਾ ਦੇਸ਼ਾਟਨਕਾਰਿਣਃ ਕਿਯਨ੍ਤੋ ਯਿਹੂਦੀਯਾ ਭੂਤਾਪਸਾਰਿਣੋ ਭੂਤਗ੍ਰਸ੍ਤਨੋਕਾਨਾਂ ਸੰਨਿਧੌ ਪ੍ਰਭੇ ਰ੍ਯੀਸ਼ੋ ਰ੍ਨਾਮ ਜਪ੍ਤ੍ਵਾ ਵਾਕ੍ਯਮਿਦਮ੍ ਅਵਦਨ੍, ਯਸ੍ਯ ਕਥਾਂ ਪੌਲਃ ਪ੍ਰਚਾਰਯਤਿ ਤਸ੍ਯ ਯੀਸ਼ੋ ਰ੍ਨਾਮ੍ਨਾ ਯੁਸ਼਼੍ਮਾਨ੍ ਆਜ੍ਞਾਪਯਾਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","ਸ੍ਕਿਵਨਾਮ੍ਨੋ ਯਿਹੂਦੀਯਾਨਾਂ ਪ੍ਰਧਾਨਯਾਜਕਸ੍ਯ ਸਪ੍ਤਭਿਃ ਪੁੱਤੈਸ੍ਤਥਾ ਕ੍ਰੁʼਤੇ ਸਤਿ ");
INSERT INTO sanpun_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","ਕਸ਼੍ਚਿਦ੍ ਅਪਵਿਤ੍ਰੋ ਭੂਤਃ ਪ੍ਰਤ੍ਯੁਦਿਤਵਾਨ੍, ਯੀਸ਼ੁੰ ਜਾਨਾਮਿ ਪੌਲਞ੍ਚ ਪਰਿਚਿਨੋਮਿ ਕਿਨ੍ਤੁ ਕੇ ਯੂਯੰ? ");
INSERT INTO sanpun_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ਇਤ੍ਯੁਕ੍ਤ੍ਵਾ ਸੋਪਵਿਤ੍ਰਭੂਤਗ੍ਰਸ੍ਤੋ ਮਨੁਸ਼਼੍ਯੋ ਲਮ੍ਫੰ ਕ੍ਰੁʼਤ੍ਵਾ ਤੇਸ਼਼ਾਮੁਪਰਿ ਪਤਿਤ੍ਵਾ ਬਲੇਨ ਤਾਨ੍ ਜਿਤਵਾਨ੍, ਤਸ੍ਮਾੱਤੇ ਨਗ੍ਨਾਃ ਕ੍ਸ਼਼ਤਾਙ੍ਗਾਸ਼੍ਚ ਸਨ੍ਤਸ੍ਤਸ੍ਮਾਦ੍ ਗੇਹਾਤ੍ ਪਲਾਯਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","ਸਾ ਵਾਗ੍ ਇਫਿਸ਼਼ਨਗਰਨਿਵਾਸਿਨਸੰ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਯਿਹੂਦੀਯਾਨਾਂ ਭਿੰਨਦੇਸ਼ੀਯਾਨਾਂ ਲੋਕਾਨਾਞ੍ਚ ਸ਼੍ਰਵੋਗੋਚਰੀਭੂਤਾ; ਤਤਃ ਸਰ੍ੱਵੇ ਭਯੰ ਗਤਾਃ ਪ੍ਰਭੋ ਰ੍ਯੀਸ਼ੋ ਰ੍ਨਾਮ੍ਨੋ ਯਸ਼ੋ (ਅ)ਵਰ੍ੱਧਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","ਯੇਸ਼਼ਾਮਨੇਕੇਸ਼਼ਾਂ ਲੋਕਾਨਾਂ ਪ੍ਰਤੀਤਿਰਜਾਯਤ ਤ ਆਗਤ੍ਯ ਸ੍ਵੈਃ ਕ੍ਰੁʼਤਾਃ ਕ੍ਰਿਯਾਃ ਪ੍ਰਕਾਸ਼ਰੂਪੇਣਾਙ੍ਗੀਕ੍ਰੁʼਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","ਬਹਵੋ ਮਾਯਾਕਰ੍ੰਮਕਾਰਿਣਃ ਸ੍ਵਸ੍ਵਗ੍ਰਨ੍ਥਾਨ੍ ਆਨੀਯ ਰਾਸ਼ੀਕ੍ਰੁʼਤ੍ਯ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਸਮਕ੍ਸ਼਼ਮ੍ ਅਦਾਹਯਨ੍, ਤਤੋ ਗਣਨਾਂ ਕ੍ਰੁʼਤ੍ਵਾਬੁਧ੍ਯਨ੍ਤ ਪਞ੍ਚਾਯੁਤਰੂਪ੍ਯਮੁਦ੍ਰਾਮੂਲ੍ਯਪੁਸ੍ਤਕਾਨਿ ਦਗ੍ਧਾਨਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ਇੱਥੰ ਪ੍ਰਭੋਃ ਕਥਾ ਸਰ੍ੱਵਦੇਸ਼ੰ ਵ੍ਯਾਪ੍ਯ ਪ੍ਰਬਲਾ ਜਾਤਾ| ");
INSERT INTO sanpun_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","ਸਰ੍ੱਵੇਸ਼਼੍ਵੇਤੇਸ਼਼ੁ ਕਰ੍ੰਮਸੁ ਸਮ੍ਪੰਨੇਸ਼਼ੁ ਸਤ੍ਸੁ ਪੌਲੋ ਮਾਕਿਦਨਿਯਾਖਾਯਾਦੇਸ਼ਾਭ੍ਯਾਂ ਯਿਰੂਸ਼ਾਲਮੰ ਗਨ੍ਤੁੰ ਮਤਿੰ ਕ੍ਰੁʼਤ੍ਵਾ ਕਥਿਤਵਾਨ੍ ਤਤ੍ਸ੍ਥਾਨੰ ਯਾਤ੍ਰਾਯਾਂ ਕ੍ਰੁʼਤਾਯਾਂ ਸਤ੍ਯਾਂ ਮਯਾ ਰੋਮਾਨਗਰੰ ਦ੍ਰਸ਼਼੍ਟਵ੍ਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","ਸ੍ਵਾਨੁਗਤਲੋਕਾਨਾਂ ਤੀਮਥਿਯੇਰਾਸ੍ਤੌ ਦ੍ਵੌ ਜਨੌ ਮਾਕਿਦਨਿਯਾਦੇਸ਼ੰ ਪ੍ਰਤਿ ਪ੍ਰਹਿਤ੍ਯ ਸ੍ਵਯਮ੍ ਆਸ਼ਿਯਾਦੇਸ਼ੇ ਕਤਿਪਯਦਿਨਾਨਿ ਸ੍ਥਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","ਕਿਨ੍ਤੁ ਤਸ੍ਮਿਨ੍ ਸਮਯੇ ਮਤੇ(ਅ)ਸ੍ਮਿਨ੍ ਕਲਹੋ ਜਾਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","ਤਤ੍ਕਾਰਣਮਿਦੰ, ਅਰ੍ੱਤਿਮੀਦੇਵ੍ਯਾ ਰੂਪ੍ਯਮਨ੍ਦਿਰਨਿਰ੍ੰਮਾਣੇਨ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਸ਼ਿਲ੍ਪਿਨਾਂ ਯਥੇਸ਼਼੍ਟਲਾਭਮ੍ ਅਜਨਯਤ੍ ਯੋ ਦੀਮੀਤ੍ਰਿਯਨਾਮਾ ਨਾਡੀਨ੍ਧਮਃ ");
INSERT INTO sanpun_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ਸ ਤਾਨ੍ ਤਤ੍ਕਰ੍ੰਮਜੀਵਿਨਃ ਸਰ੍ੱਵਲੋਕਾਂਸ਼੍ਚ ਸਮਾਹੂਯ ਭਾਸ਼਼ਿਤਵਾਨ੍ ਹੇ ਮਹੇੱਛਾ ਏਤੇਨ ਮਨ੍ਦਿਰਨਿਰ੍ੰਮਾਣੇਨਾਸ੍ਮਾਕੰ ਜੀਵਿਕਾ ਭਵਤਿ, ਏਤਦ੍ ਯੂਯੰ ਵਿੱਥ; ");
INSERT INTO sanpun_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","ਕਿਨ੍ਤੁ ਹਸ੍ਤਨਿਰ੍ੰਮਿਤੇਸ਼੍ਵਰਾ ਈਸ਼੍ਵਰਾ ਨਹਿ ਪੌਲਨਾਮ੍ਨਾ ਕੇਨਚਿੱਜਨੇਨ ਕਥਾਮਿਮਾਂ ਵ੍ਯਾਹ੍ਰੁʼਤ੍ਯ ਕੇਵਲੇਫਿਸ਼਼ਨਗਰੇ ਨਹਿ ਪ੍ਰਾਯੇਣ ਸਰ੍ੱਵਸ੍ਮਿਨ੍ ਆਸ਼ਿਯਾਦੇਸ਼ੇ ਪ੍ਰਵ੍ਰੁʼੱਤਿੰ ਗ੍ਰਾਹਯਿਤ੍ਵਾ ਬਹੁਲੋਕਾਨਾਂ ਸ਼ੇਮੁਸ਼਼ੀ ਪਰਾਵਰ੍ੱਤਿਤਾ, ਏਤਦ੍ ਯੁਸ਼਼੍ਮਾਭਿ ਰ੍ਦ੍ਰੁʼਸ਼੍ਯਤੇ ਸ਼੍ਰੂਯਤੇ ਚ| ");
INSERT INTO sanpun_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","ਤੇਨਾਸ੍ਮਾਕੰ ਵਾਣਿਜ੍ਯਸ੍ਯ ਸਰ੍ੱਵਥਾ ਹਾਨੇਃ ਸਮ੍ਭਵਨੰ ਕੇਵਲਮਿਤਿ ਨਹਿ, ਆਸ਼ਿਯਾਦੇਸ਼ਸ੍ਥੈ ਰ੍ਵਾ ਸਰ੍ੱਵਜਗਤ੍ਸ੍ਥੈ ਰ੍ਲੋਕੈਃ ਪੂਜ੍ਯਾ ਯਾਰ੍ਤਿਮੀ ਮਹਾਦੇਵੀ ਤਸ੍ਯਾ ਮਨ੍ਦਿਰਸ੍ਯਾਵਜ੍ਞਾਨਸ੍ਯ ਤਸ੍ਯਾ ਐਸ਼੍ਵਰ੍ੱਯਸ੍ਯ ਨਾਸ਼ਸ੍ਯ ਚ ਸਮ੍ਭਾਵਨਾ ਵਿਦ੍ਯਤੇे| ");
INSERT INTO sanpun_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","ਏਤਾਦ੍ਰੁʼਸ਼ੀਂ ਕਥਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਤੇ ਮਹਾਕ੍ਰੋਧਾਨ੍ਵਿਤਾਃ ਸਨ੍ਤ ਉੱਚੈਃਕਾਰੰ ਕਥਿਤਵਨ੍ਤ ਇਫਿਸ਼਼ੀਯਾਨਾਮ੍ ਅਰ੍ੱਤਿਮੀ ਦੇਵੀ ਮਹਤੀ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","ਤਤਃ ਸਰ੍ੱਵਨਗਰੰ ਕਲਹੇਨ ਪਰਿਪੂਰ੍ਣਮਭਵਤ੍, ਤਤਃ ਪਰੰ ਤੇ ਮਾਕਿਦਨੀਯਗਾਯਾਰਿਸ੍ਤਾਰ੍ਖਨਾਮਾਨੌ ਪੌਲਸ੍ਯ ਦ੍ਵੌ ਸਹਚਰੌ ਧ੍ਰੁʼਤ੍ਵੈਕਚਿੱਤਾ ਰਙ੍ਗਭੂਮਿੰ ਜਵੇਨ ਧਾਵਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","ਤਤਃ ਪੌਲੋ ਲੋਕਾਨਾਂ ਸੰਨਿਧਿੰ ਯਾਤੁਮ੍ ਉਦ੍ਯਤਵਾਨ੍ ਕਿਨ੍ਤੁ ਸ਼ਿਸ਼਼੍ਯਗਣਸ੍ਤੰ ਵਾਰਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","ਪੌਲਸ੍ਯਤ੍ਮੀਯਾ ਆਸ਼ਿਯਾਦੇਸ਼ਸ੍ਥਾਃ ਕਤਿਪਯਾਃ ਪ੍ਰਧਾਨਲੋਕਾਸ੍ਤਸ੍ਯ ਸਮੀਪੰ ਨਰਮੇਕੰ ਪ੍ਰੇਸ਼਼੍ਯ ਤ੍ਵੰ ਰਙ੍ਗਭੂਮਿੰ ਮਾਗਾ ਇਤਿ ਨ੍ਯਵੇਦਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","ਤਤੋ ਨਾਨਾਲੋਕਾਨਾਂ ਨਾਨਾਕਥਾਕਥਨਾਤ੍ ਸਭਾ ਵ੍ਯਾਕੁਲਾ ਜਾਤਾ ਕਿੰ ਕਾਰਣਾਦ੍ ਏਤਾਵਤੀ ਜਨਤਾਭਵਤ੍ ਏਤਦ੍ ਅਧਿਕੈ ਰ੍ਲੋਕੈ ਰ੍ਨਾਜ੍ਞਾਯਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","ਤਤਃ ਪਰੰ ਜਨਤਾਮਧ੍ਯਾਦ੍ ਯਿਹੂਦੀਯੈਰ੍ਬਹਿਸ਼਼੍ਕ੍ਰੁʼਤਃ ਸਿਕਨ੍ਦਰੋ ਹਸ੍ਤੇਨ ਸਙ੍ਕੇਤੰ ਕ੍ਰੁʼਤ੍ਵਾ ਲੋਕੇਭ੍ਯ ਉੱਤਰੰ ਦਾਤੁਮੁਦ੍ਯਤਵਾਨ੍, ");
INSERT INTO sanpun_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","ਕਿਨ੍ਤੁ ਸ ਯਿਹੂਦੀਯਲੋਕ ਇਤਿ ਨਿਸ਼੍ਚਿਤੇ ਸਤਿ ਇਫਿਸ਼਼ੀਯਾਨਾਮ੍ ਅਰ੍ੱਤਿਮੀ ਦੇਵੀ ਮਹਤੀਤਿ ਵਾਕ੍ਯੰ ਪ੍ਰਾਯੇਣ ਪਞ੍ਚ ਦਣ੍ਡਾਨ੍ ਯਾਵਦ੍ ਏਕਸ੍ਵਰੇਣ ਲੋਕਨਿਵਹੈਃ ਪ੍ਰੋਕ੍ਤੰ| ");
INSERT INTO sanpun_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","ਤਤੋ ਨਗਰਾਧਿਪਤਿਸ੍ਤਾਨ੍ ਸ੍ਥਿਰਾਨ੍ ਕ੍ਰੁʼਤ੍ਵਾ ਕਥਿਤਵਾਨ੍ ਹੇ ਇਫਿਸ਼਼ਾਯਾਃ ਸਰ੍ੱਵੇ ਲੋਕਾ ਆਕਰ੍ਣਯਤ, ਅਰ੍ਤਿਮੀਮਹਾਦੇਵ੍ਯਾ ਮਹਾਦੇਵਾਤ੍ ਪਤਿਤਾਯਾਸ੍ਤਤ੍ਪ੍ਰਤਿਮਾਯਾਸ਼੍ਚ ਪੂਜਨਮ ਇਫਿਸ਼਼ਨਗਰਸ੍ਥਾਃ ਸਰ੍ੱਵੇ ਲੋਕਾਃ ਕੁਰ੍ੱਵਨ੍ਤਿ, ਏਤਤ੍ ਕੇ ਨ ਜਾਨਨ੍ਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","ਤਸ੍ਮਾਦ੍ ਏਤਤ੍ਪ੍ਰਤਿਕੂਲੰ ਕੇਪਿ ਕਥਯਿਤੁੰ ਨ ਸ਼ਕ੍ਨੁਵਨ੍ਤਿ, ਇਤਿ ਜ੍ਞਾਤ੍ਵਾ ਯੁਸ਼਼੍ਮਾਭਿਃ ਸੁਸ੍ਥਿਰਤ੍ਵੇਨ ਸ੍ਥਾਤਵ੍ਯਮ੍ ਅਵਿਵਿਚ੍ਯ ਕਿਮਪਿ ਕਰ੍ੰਮ ਨ ਕਰ੍ੱਤਵ੍ਯਞ੍ਚ| ");
INSERT INTO sanpun_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","ਯਾਨ੍ ਏਤਾਨ੍ ਮਨੁਸ਼਼੍ਯਾਨ੍ ਯੂਯਮਤ੍ਰ ਸਮਾਨਯਤ ਤੇ ਮਨ੍ਦਿਰਦ੍ਰਵ੍ਯਾਪਹਾਰਕਾ ਯੁਸ਼਼੍ਮਾਕੰ ਦੇਵ੍ਯਾ ਨਿਨ੍ਦਕਾਸ਼੍ਚ ਨ ਭਵਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","ਯਦਿ ਕਞ੍ਚਨ ਪ੍ਰਤਿ ਦੀਮੀਤ੍ਰਿਯਸ੍ਯ ਤਸ੍ਯ ਸਹਾਯਾਨਾਞ੍ਚ ਕਾਚਿਦ੍ ਆਪੱਤਿ ਰ੍ਵਿਦ੍ਯਤੇ ਤਰ੍ਹਿ ਪ੍ਰਤਿਨਿਧਿਲੋਕਾ ਵਿਚਾਰਸ੍ਥਾਨਞ੍ਚ ਸਨ੍ਤਿ, ਤੇ ਤਤ੍ ਸ੍ਥਾਨੰ ਗਤ੍ਵਾ ਉੱਤਰਪ੍ਰਤ੍ਯੁੱਤਰੇ ਕੁਰ੍ੱਵਨ੍ਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","ਕਿਨ੍ਤੁ ਯੁਸ਼਼੍ਮਾਕੰ ਕਾਚਿਦਪਰਾ ਕਥਾ ਯਦਿ ਤਿਸ਼਼੍ਠਤਿ ਤਰ੍ਹਿ ਨਿਯਮਿਤਾਯਾਂ ਸਭਾਯਾਂ ਤਸ੍ਯਾ ਨਿਸ਼਼੍ਪੱਤਿ ਰ੍ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","ਕਿਨ੍ਤ੍ਵੇਤਸ੍ਯ ਵਿਰੋਧਸ੍ਯੋੱਤਰੰ ਯੇਨ ਦਾਤੁੰ ਸ਼ਕ੍ਨੁਮ੍ ਏਤਾਦ੍ਰੁʼਸ਼ਸ੍ਯ ਕਸ੍ਯਚਿਤ੍ ਕਾਰਣਸ੍ਯਾਭਾਵਾਦ੍ ਅਦ੍ਯਤਨਘਟਨਾਹੇਤੋ ਰਾਜਦ੍ਰੋਹਿਣਾਮਿਵਾਸ੍ਮਾਕਮ੍ ਅਭਿਯੋਗੋ ਭਵਿਸ਼਼੍ਯਤੀਤਿ ਸ਼ਙ੍ਕਾ ਵਿਦ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","ਇਤਿ ਕਥਯਿਤ੍ਵਾ ਸ ਸਭਾਸ੍ਥਲੋਕਾਨ੍ ਵਿਸ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ਇੱਥੰ ਕਲਹੇ ਨਿਵ੍ਰੁʼੱਤੇ ਸਤਿ ਪੌਲਃ ਸ਼ਿਸ਼਼੍ਯਗਣਮ੍ ਆਹੂਯ ਵਿਸਰ੍ਜਨੰ ਪ੍ਰਾਪ੍ਯ ਮਾਕਿਦਨਿਯਾਦੇਸ਼ੰ ਪ੍ਰਸ੍ਥਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","ਤੇਨ ਸ੍ਥਾਨੇਨ ਗੱਛਨ੍ ਤੱਦੇਸ਼ੀਯਾਨ੍ ਸ਼ਿਸ਼਼੍ਯਾਨ੍ ਬਹੂਪਦਿਸ਼੍ਯ ਯੂਨਾਨੀਯਦੇਸ਼ਮ੍ ਉਪਸ੍ਥਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ਤਤ੍ਰ ਮਾਸਤ੍ਰਯੰ ਸ੍ਥਿਤ੍ਵਾ ਤਸ੍ਮਾਤ੍ ਸੁਰਿਯਾਦੇਸ਼ੰ ਯਾਤੁਮ੍ ਉਦ੍ਯਤਃ, ਕਿਨ੍ਤੁ ਯਿਹੂਦੀਯਾਸ੍ਤੰ ਹਨ੍ਤੁੰ ਗੁਪ੍ਤਾ ਅਤਿਸ਼਼੍ਠਨ੍ ਤਸ੍ਮਾਤ੍ ਸ ਪੁਨਰਪਿ ਮਾਕਿਦਨਿਯਾਮਾਰ੍ਗੇਣ ਪ੍ਰਤ੍ਯਾਗਨ੍ਤੁੰ ਮਤਿੰ ਕ੍ਰੁʼਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","ਬਿਰਯਾਨਗਰੀਯਸੋਪਾਤ੍ਰਃ ਥਿਸ਼਼ਲਨੀਕੀਯਾਰਿਸ੍ਤਾਰ੍ਖਸਿਕੁਨ੍ਦੌ ਦਰ੍ੱਬੋਨਗਰੀਯਗਾਯਤੀਮਥਿਯੌ ਆਸ਼ਿਯਾਦੇਸ਼ੀਯਤੁਖਿਕਤ੍ਰਫਿਮੌ ਚ ਤੇਨ ਸਾਰ੍ੱਧੰ ਆਸ਼ਿਯਾਦੇਸ਼ੰ ਯਾਵਦ੍ ਗਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ਏਤੇ ਸਰ੍ੱਵੇ (ਅ)ਗ੍ਰਸਰਾਃ ਸਨ੍ਤੋ (ਅ)ਸ੍ਮਾਨ੍ ਅਪੇਕ੍ਸ਼਼੍ਯ ਤ੍ਰੋਯਾਨਗਰੇ ਸ੍ਥਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","ਕਿਣ੍ਵਸ਼ੂਨ੍ਯਪੂਪੋਤ੍ਸਵਦਿਨੇ ਚ ਗਤੇ ਸਤਿ ਵਯੰ ਫਿਲਿਪੀਨਗਰਾਤ੍ ਤੋਯਪਥੇਨ ਗਤ੍ਵਾ ਪਞ੍ਚਭਿ ਰ੍ਦਿਨੈਸ੍ਤ੍ਰੋਯਾਨਗਰਮ੍ ਉਪਸ੍ਥਾਯ ਤਤ੍ਰ ਸਪ੍ਤਦਿਨਾਨ੍ਯਵਾਤਿਸ਼਼੍ਠਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","ਸਪ੍ਤਾਹਸ੍ਯ ਪ੍ਰਥਮਦਿਨੇ ਪੂਪਾਨ੍ ਭੰਕ੍ਤੁ ਸ਼ਿਸ਼਼੍ਯੇਸ਼਼ੁ ਮਿਲਿਤੇਸ਼਼ੁ ਪੌਲਃ ਪਰਦਿਨੇ ਤਸ੍ਮਾਤ੍ ਪ੍ਰਸ੍ਥਾਤੁਮ੍ ਉਦ੍ਯਤਃ ਸਨ੍ ਤਦਹ੍ਨਿ ਪ੍ਰਾਯੇਣ ਕ੍ਸ਼਼ਪਾਯਾ ਯਾਮਦ੍ਵਯੰ ਯਾਵਤ੍ ਸ਼ਿਸ਼਼੍ਯੇਭ੍ਯੋ ਧਰ੍ੰਮਕਥਾਮ੍ ਅਕਥਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ਉਪਰਿਸ੍ਥੇ ਯਸ੍ਮਿਨ੍ ਪ੍ਰਕੋਸ਼਼੍ਠੇ ਸਭਾਂ ਕ੍ਰੁʼਤ੍ਵਾਸਨ੍ ਤਤ੍ਰ ਬਹਵਃ ਪ੍ਰਦੀਪਾਃ ਪ੍ਰਾਜ੍ਵਲਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ਉਤੁਖਨਾਮਾ ਕਸ਼੍ਚਨ ਯੁਵਾ ਚ ਵਾਤਾਯਨ ਉਪਵਿਸ਼ਨ੍ ਘੋਰਤਰਨਿਦ੍ਰਾਗ੍ਰਸ੍ਤੋ (ਅ)ਭੂਤ੍ ਤਦਾ ਪੌਲੇਨ ਬਹੁਕ੍ਸ਼਼ਣੰ ਕਥਾਯਾਂ ਪ੍ਰਚਾਰਿਤਾਯਾਂ ਨਿਦ੍ਰਾਮਗ੍ਨਃ ਸ ਤਸ੍ਮਾਦ੍ ਉਪਰਿਸ੍ਥਤ੍ਰੁʼਤੀਯਪ੍ਰਕੋਸ਼਼੍ਠਾਦ੍ ਅਪਤਤ੍, ਤਤੋ ਲੋਕਾਸ੍ਤੰ ਮ੍ਰੁʼਤਕਲ੍ਪੰ ਧ੍ਰੁʼਤ੍ਵੋਦਤੋਲਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","ਤਤਃ ਪੌਲੋ(ਅ)ਵਰੁਹ੍ਯ ਤਸ੍ਯ ਗਾਤ੍ਰੇ ਪਤਿਤ੍ਵਾ ਤੰ ਕ੍ਰੋਡੇ ਨਿਧਾਯ ਕਥਿਤਵਾਨ੍, ਯੂਯੰ ਵ੍ਯਾਕੁਲਾ ਮਾ ਭੂਤ ਨਾਯੰ ਪ੍ਰਾਣੈ ਰ੍ਵਿਯੁਕ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","ਪਸ਼੍ਚਾਤ੍ ਸ ਪੁਨਸ਼੍ਚੋਪਰਿ ਗਤ੍ਵਾ ਪੂਪਾਨ੍ ਭੰਕ੍ਤ੍ਵਾ ਪ੍ਰਭਾਤੰ ਯਾਵਤ੍ ਕਥੋਪਕਥਨੇ ਕ੍ਰੁʼਤ੍ਵਾ ਪ੍ਰਸ੍ਥਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","ਤੇ ਚ ਤੰ ਜੀਵਨ੍ਤੰ ਯੁਵਾਨੰ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਗਤ੍ਵਾ ਪਰਮਾਪ੍ਯਾਯਿਤਾ ਜਾਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","ਅਨਨ੍ਤਰੰ ਵਯੰ ਪੋਤੇਨਾਗ੍ਰਸਰਾ ਭੂਤ੍ਵਾਸ੍ਮਨਗਰਮ੍ ਉੱਤੀਰ੍ੱਯ ਪੌਲੰ ਗ੍ਰਹੀਤੁੰ ਮਤਿਮ੍ ਅਕੁਰ੍ੰਮ ਯਤਃ ਸ ਤਤ੍ਰ ਪਦ੍ਭ੍ਯਾਂ ਵ੍ਰਜਿਤੁੰ ਮਤਿੰ ਕ੍ਰੁʼਤ੍ਵੇਤਿ ਨਿਰੂਪਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","ਤਸ੍ਮਾਤ੍ ਤਤ੍ਰਾਸ੍ਮਾਭਿਃ ਸਾਰ੍ੱਧੰ ਤਸ੍ਮਿਨ੍ ਮਿਲਿਤੇ ਸਤਿ ਵਯੰ ਤੰ ਨੀਤ੍ਵਾ ਮਿਤੁਲੀਨ੍ਯੁਪਦ੍ਵੀਪੰ ਪ੍ਰਾਪ੍ਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","ਤਸ੍ਮਾਤ੍ ਪੋਤੰ ਮੋਚਯਿਤ੍ਵਾ ਪਰੇ(ਅ)ਹਨਿ ਖੀਯੋਪਦ੍ਵੀਪਸ੍ਯ ਸੰਮੁਖੰ ਲਬ੍ਧਵਨ੍ਤਸ੍ਤਸ੍ਮਾਦ੍ ਏਕੇਨਾਹ੍ਨਾ ਸਾਮੋਪਦ੍ਵੀਪੰ ਗਤ੍ਵਾ ਪੋਤੰ ਲਾਗਯਿਤ੍ਵਾ ਤ੍ਰੋਗੁੱਲਿਯੇ ਸ੍ਥਿਤ੍ਵਾ ਪਰਸ੍ਮਿਨ੍ ਦਿਵਸੇे ਮਿਲੀਤਨਗਰਮ੍ ਉਪਾਤਿਸ਼਼੍ਠਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","ਯਤਃ ਪੌਲ ਆਸ਼ਿਯਾਦੇਸ਼ੇ ਕਾਲੰ ਯਾਪਯਿਤੁਮ੍ ਨਾਭਿਲਸ਼਼ਨ੍ ਇਫਿਸ਼਼ਨਗਰੰ ਤ੍ਯਕ੍ਤ੍ਵਾ ਯਾਤੁੰ ਮਨ੍ਤ੍ਰਣਾਂ ਸ੍ਥਿਰੀਕ੍ਰੁʼਤਵਾਨ੍; ਯਸ੍ਮਾਦ੍ ਯਦਿ ਸਾਧ੍ਯੰ ਭਵਤਿ ਤਰ੍ਹਿ ਨਿਸ੍ਤਾਰੋਤ੍ਸਵਸ੍ਯ ਪਞ੍ਚਾਸ਼ੱਤਮਦਿਨੇ ਸ ਯਿਰੂਸ਼ਾਲਮ੍ਯੁਪਸ੍ਥਾਤੁੰ ਮਤਿੰ ਕ੍ਰੁʼਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","ਪੌਲੋ ਮਿਲੀਤਾਦ੍ ਇਫਿਸ਼਼ੰ ਪ੍ਰਤਿ ਲੋਕੰ ਪ੍ਰਹਿਤ੍ਯ ਸਮਾਜਸ੍ਯ ਪ੍ਰਾਚੀਨਾਨ੍ ਆਹੂਯਾਨੀਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","ਤੇਸ਼਼ੁ ਤਸ੍ਯ ਸਮੀਪਮ੍ ਉਪਸ੍ਥਿਤੇਸ਼਼ੁ ਸ ਤੇਭ੍ਯ ਇਮਾਂ ਕਥਾਂ ਕਥਿਤਵਾਨ੍, ਅਹਮ੍ ਆਸ਼ਿਯਾਦੇਸ਼ੇ ਪ੍ਰਥਮਾਗਮਨਮ੍ ਆਰਭ੍ਯਾਦ੍ਯ ਯਾਵਦ੍ ਯੁਸ਼਼੍ਮਾਕੰ ਸੰਨਿਧੌ ਸ੍ਥਿਤ੍ਵਾ ਸਰ੍ੱਵਸਮਯੇ ਯਥਾਚਰਿਤਵਾਨ੍ ਤਦ੍ ਯੂਯੰ ਜਾਨੀਥ; ");
INSERT INTO sanpun_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ਫਲਤਃ ਸਰ੍ੱਵਥਾ ਨਮ੍ਰਮਨਾਃ ਸਨ੍ ਬਹੁਸ਼੍ਰੁਪਾਤੇਨ ਯਿਹੁਦੀਯਾਨਾਮ੍ ਕੁਮਨ੍ਤ੍ਰਣਾਜਾਤਨਾਨਾਪਰੀਕ੍ਸ਼਼ਾਭਿਃ ਪ੍ਰਭੋਃ ਸੇਵਾਮਕਰਵੰ| ");
INSERT INTO sanpun_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","ਕਾਮਪਿ ਹਿਤਕਥਾाਂ ਨ ਗੋਪਾਯਿਤਵਾਨ੍ ਤਾਂ ਪ੍ਰਚਾਰ੍ੱਯ ਸਪ੍ਰਕਾਸ਼ੰ ਗ੍ਰੁʼਹੇ ਗ੍ਰੁʼਹੇ ਸਮੁਪਦਿਸ਼੍ਯੇਸ਼੍ਵਰੰ ਪ੍ਰਤਿ ਮਨਃ ਪਰਾਵਰ੍ੱਤਨੀਯੰ ਪ੍ਰਭੌ ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟੇ ਵਿਸ਼੍ਵਸਨੀਯੰ ");
INSERT INTO sanpun_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","ਯਿਹੂਦੀਯਾਨਾਮ੍ ਅਨ੍ਯਦੇਸ਼ੀਯਲੋਕਾਨਾਞ੍ਚ ਸਮੀਪ ਏਤਾਦ੍ਰੁʼਸ਼ੰ ਸਾਕ੍ਸ਼਼੍ਯੰ ਦਦਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","ਪਸ਼੍ਯਤ ਸਾਮ੍ਪ੍ਰਤਮ੍ ਆਤ੍ਮਨਾਕ੍ਰੁʼਸ਼਼੍ਟਃ ਸਨ੍ ਯਿਰੂਸ਼ਾਲਮ੍ਨਗਰੇ ਯਾਤ੍ਰਾਂ ਕਰੋਮਿ, ਤਤ੍ਰ ਮਾਮ੍ਪ੍ਰਤਿ ਯਦ੍ਯਦ੍ ਘਟਿਸ਼਼੍ਯਤੇ ਤਾਨ੍ਯਹੰ ਨ ਜਾਨਾਮਿ; ");
INSERT INTO sanpun_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","ਕਿਨ੍ਤੁ ਮਯਾ ਬਨ੍ਧਨੰ ਕ੍ਲੇਸ਼ਸ਼੍ਚ ਭੋਕ੍ਤਵ੍ਯ ਇਤਿ ਪਵਿਤ੍ਰ ਆਤ੍ਮਾ ਨਗਰੇ ਨਗਰੇ ਪ੍ਰਮਾਣੰ ਦਦਾਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","ਤਥਾਪਿ ਤੰ ਕ੍ਲੇਸ਼ਮਹੰ ਤ੍ਰੁʼਣਾਯ ਨ ਮਨ੍ਯੇ; ਈਸ਼੍ਵਰਸ੍ਯਾਨੁਗ੍ਰਹਵਿਸ਼਼ਯਕਸ੍ਯ ਸੁਸੰਵਾਦਸ੍ਯ ਪ੍ਰਮਾਣੰ ਦਾਤੁੰ, ਪ੍ਰਭੋ ਰ੍ਯੀਸ਼ੋਃ ਸਕਾਸ਼ਾਦ ਯਸ੍ਯਾਃ ਸੇਵਾਯਾਃ ਭਾਰੰ ਪ੍ਰਾਪ੍ਨਵੰ ਤਾਂ ਸੇਵਾਂ ਸਾਧਯਿਤੁੰ ਸਾਨਨ੍ਦੰ ਸ੍ਵਮਾਰ੍ਗੰ ਸਮਾਪਯਿਤੁुਞ੍ਚ ਨਿਜਪ੍ਰਾਣਾਨਪਿ ਪ੍ਰਿਯਾਨ੍ ਨ ਮਨ੍ਯੇ| ");
INSERT INTO sanpun_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","ਅਧੁਨਾ ਪਸ਼੍ਯਤ ਯੇਸ਼਼ਾਂ ਸਮੀਪੇ(ਅ)ਹਮ੍ ਈਸ਼੍ਵਰੀਯਰਾਜ੍ਯਸ੍ਯ ਸੁਸੰਵਾਦੰ ਪ੍ਰਚਾਰ੍ੱਯ ਭ੍ਰਮਣੰ ਕ੍ਰੁʼਤਵਾਨ੍ ਏਤਾਦ੍ਰੁʼਸ਼ਾ ਯੂਯੰ ਮਮ ਵਦਨੰ ਪੁਨ ਰ੍ਦ੍ਰਸ਼਼੍ਟੁੰ ਨ ਪ੍ਰਾਪ੍ਸ੍ਯਥ ਏਤਦਪ੍ਯਹੰ ਜਾਨਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","ਯੁਸ਼਼੍ਮਭ੍ਯਮ੍ ਅਹਮ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਸਰ੍ੱਵਾਨ੍ ਆਦੇਸ਼ਾਨ੍ ਪ੍ਰਕਾਸ਼ਯਿਤੁੰ ਨ ਨ੍ਯਵਰ੍ੱਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","ਅਹੰ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਲੋਕਾਨਾਂ ਰਕ੍ਤਪਾਤਦੋਸ਼਼ਾਦ੍ ਯੰਨਿਰ੍ਦੋਸ਼਼ ਆਸੇ ਤਸ੍ਯਾਦ੍ਯ ਯੁਸ਼਼੍ਮਾਨ੍ ਸਾਕ੍ਸ਼਼ਿਣਃ ਕਰੋਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","ਯੂਯੰ ਸ੍ਵੇਸ਼਼ੁ ਤਥਾ ਯਸ੍ਯ ਵ੍ਰਜਸ੍ਯਾਧ੍ਯਕ੍ਸ਼਼ਨ੍ ਆਤ੍ਮਾ ਯੁਸ਼਼੍ਮਾਨ੍ ਵਿਧਾਯ ਨ੍ਯਯੁਙ੍ਕ੍ਤ ਤਤ੍ਸਰ੍ੱਵਸ੍ਮਿਨ੍ ਸਾਵਧਾਨਾ ਭਵਤ, ਯ ਸਮਾਜਞ੍ਚ ਪ੍ਰਭੁ ਰ੍ਨਿਜਰਕ੍ਤਮੂਲ੍ਯੇਨ ਕ੍ਰੀਤਵਾਨ ਤਮ੍ ਅਵਤ, ");
INSERT INTO sanpun_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","ਯਤੋ ਮਯਾ ਗਮਨੇ ਕ੍ਰੁʼਤਏਵ ਦੁਰ੍ਜਯਾ ਵ੍ਰੁʼਕਾ ਯੁਸ਼਼੍ਮਾਕੰ ਮਧ੍ਯੰ ਪ੍ਰਵਿਸ਼੍ਯ ਵ੍ਰਜੰ ਪ੍ਰਤਿ ਨਿਰ੍ਦਯਤਾਮ੍ ਆਚਰਿਸ਼਼੍ਯਨ੍ਤਿ, ");
INSERT INTO sanpun_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","ਯੁਸ਼਼੍ਮਾਕਮੇਵ ਮਧ੍ਯਾਦਪਿ ਲੋਕਾ ਉੱਥਾਯ ਸ਼ਿਸ਼਼੍ਯਗਣਮ੍ ਅਪਹਨ੍ਤੁੰ ਵਿਪਰੀਤਮ੍ ਉਪਦੇਕ੍ਸ਼਼੍ਯਨ੍ਤੀਤ੍ਯਹੰ ਜਾਨਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","ਇਤਿ ਹੇਤੋ ਰ੍ਯੂਯੰ ਸਚੈਤਨ੍ਯਾਃ ਸਨ੍ਤਸ੍ਤਿਸ਼਼੍ਟਤ, ਅਹਞ੍ਚ ਸਾਸ਼੍ਰੁਪਾਤਃ ਸਨ੍ ਵਤ੍ਸਰਤ੍ਰਯੰ ਯਾਵਦ੍ ਦਿਵਾਨਿਸ਼ੰ ਪ੍ਰਤਿਜਨੰ ਬੋਧਯਿਤੁੰ ਨ ਨ੍ਯਵਰ੍ੱਤੇ ਤਦਪਿ ਸ੍ਮਰਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","ਇਦਾਨੀਂ ਹੇ ਭ੍ਰਾਤਰੋ ਯੁਸ਼਼੍ਮਾਕੰ ਨਿਸ਼਼੍ਠਾਂ ਜਨਯਿਤੁੰ ਪਵਿਤ੍ਰੀਕ੍ਰੁʼਤਲੋਕਾਨਾਂ ਮਧ੍ਯੇ(ਅ)ਧਿਕਾਰਞ੍ਚ ਦਾਤੁੰ ਸਮਰ੍ਥੋ ਯ ਈਸ਼੍ਵਰਸ੍ਤਸ੍ਯਾਨੁਗ੍ਰਹਸ੍ਯ ਯੋ ਵਾਦਸ਼੍ਚ ਤਯੋਰੁਭਯੋ ਰ੍ਯੁਸ਼਼੍ਮਾਨ੍ ਸਮਾਰ੍ਪਯਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","ਕਸ੍ਯਾਪਿ ਸ੍ਵਰ੍ਣੰ ਰੂਪ੍ਯੰ ਵਸ੍ਤ੍ਰੰ ਵਾ ਪ੍ਰਤਿ ਮਯਾ ਲੋਭੋ ਨ ਕ੍ਰੁʼਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","ਕਿਨ੍ਤੁ ਮਮ ਮਤ੍ਸਹਚਰਲੋਕਾਨਾਞ੍ਚਾਵਸ਼੍ਯਕਵ੍ਯਯਾਯ ਮਦੀਯਮਿਦੰ ਕਰਦ੍ਵਯਮ੍ ਅਸ਼੍ਰਾਮ੍ਯਦ੍ ਏਤਦ੍ ਯੂਯੰ ਜਾਨੀਥ| ");
INSERT INTO sanpun_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","ਅਨੇਨ ਪ੍ਰਕਾਰੇਣ ਗ੍ਰਹਣਦ੍ ਦਾਨੰ ਭਦ੍ਰਮਿਤਿ ਯਦ੍ਵਾਕ੍ਯੰ ਪ੍ਰਭੁ ਰ੍ਯੀਸ਼ੁਃ ਕਥਿਤਵਾਨ੍ ਤਤ੍ ਸ੍ਮਰ੍ੱਤੁੰ ਦਰਿਦ੍ਰਲੋਕਾਨਾਮੁਪਕਾਰਾਰ੍ਥੰ ਸ਼੍ਰਮੰ ਕਰ੍ੱਤੁਞ੍ਚ ਯੁਸ਼਼੍ਮਾਕਮ੍ ਉਚਿਤਮ੍ ਏਤਤ੍ਸਰ੍ੱਵੰ ਯੁਸ਼਼੍ਮਾਨਹਮ੍ ਉਪਦਿਸ਼਼੍ਟਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ਏਤਾਂ ਕਥਾਂ ਕਥਯਿਤ੍ਵਾ ਸ ਜਾਨੁਨੀ ਪਾਤਯਿਤ੍ਵਾ ਸਰ੍ਵੈਃ ਸਹ ਪ੍ਰਾਰ੍ਥਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","ਤੇਨ ਤੇ ਕ੍ਰਨ੍ਦ੍ਰਨ੍ਤਃ ");
INSERT INTO sanpun_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ਪੁਨ ਰ੍ਮਮ ਮੁਖੰ ਨ ਦ੍ਰਕ੍ਸ਼਼੍ਯਥ ਵਿਸ਼ੇਸ਼਼ਤ ਏਸ਼਼ਾ ਯਾ ਕਥਾ ਤੇਨਾਕਥਿ ਤਤ੍ਕਾਰਣਾਤ੍ ਸ਼ੋਕੰ ਵਿਲਾਪਞ੍ਚ ਕ੍ਰੁʼਤ੍ਵਾ ਕਣ੍ਠੰ ਧ੍ਰੁʼਤ੍ਵਾ ਚੁਮ੍ਬਿਤਵਨ੍ਤਃ| ਪਸ਼੍ਚਾਤ੍ ਤੇ ਤੰ ਪੋਤੰ ਨੀਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","ਤੈ ਰ੍ਵਿਸ੍ਰੁʼਸ਼਼੍ਟਾਃ ਸਨ੍ਤੋ ਵਯੰ ਪੋਤੰ ਬਾਹਯਿਤ੍ਵਾ ਰੁʼਜੁਮਾਰ੍ਗੇਣ ਕੋਸ਼਼ਮ੍ ਉਪਦ੍ਵੀਪਮ੍ ਆਗਤ੍ਯ ਪਰੇ(ਅ)ਹਨਿ ਰੋਦਿਯੋਪਦ੍ਵੀਪਮ੍ ਆਗੱਛਾਮ ਤਤਸ੍ਤਸ੍ਮਾਤ੍ ਪਾਤਾਰਾਯਾਮ੍ ਉਪਾਤਿਸ਼਼੍ਠਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","ਤਤ੍ਰ ਫੈਨੀਕਿਯਾਦੇਸ਼ਗਾਮਿਨਮ੍ ਪੋਤਮੇਕੰ ਪ੍ਰਾਪ੍ਯ ਤਮਾਰੁਹ੍ਯ ਗਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","ਕੁਪ੍ਰੋਪਦ੍ਵੀਪੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਤੰ ਸਵ੍ਯਦਿਸ਼ਿ ਸ੍ਥਾਪਯਿਤ੍ਵਾ ਸੁਰਿਯਾਦੇਸ਼ੰ ਗਤ੍ਵਾ ਪੋਤਸ੍ਥਦ੍ਰਵ੍ਯਾਣ੍ਯਵਰੋਹਯਿਤੁੰ ਸੋਰਨਗਰੇ ਲਾਗਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","ਤਤ੍ਰ ਸ਼ਿਸ਼਼੍ਯਗਣਸ੍ਯ ਸਾਕ੍ਸ਼਼ਾਤ੍ਕਰਣਾਯ ਵਯੰ ਤਤ੍ਰ ਸਪ੍ਤਦਿਨਾਨਿ ਸ੍ਥਿਤਵਨ੍ਤਃ ਪਸ਼੍ਚਾੱਤੇ ਪਵਿਤ੍ਰੇਣਾਤ੍ਮਨਾ ਪੌਲੰ ਵ੍ਯਾਹਰਨ੍ ਤ੍ਵੰ ਯਿਰੂਸ਼ਾਲਮ੍ਨਗਰੰ ਮਾ ਗਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","ਤਤਸ੍ਤੇਸ਼਼ੁ ਸਪ੍ਤਸੁ ਦਿਨੇਸ਼਼ੁ ਯਾਪਿਤੇਸ਼਼ੁ ਸਤ੍ਸੁ ਵਯੰ ਤਸ੍ਮਾਤ੍ ਸ੍ਥਾਨਾਤ੍ ਨਿਜਵਰ੍ਤ੍ਮਨਾ ਗਤਵਨ੍ਤਃ, ਤਸ੍ਮਾਤ੍ ਤੇ ਸਬਾਲਵ੍ਰੁʼੱਧਵਨਿਤਾ ਅਸ੍ਮਾਭਿਃ ਸਹ ਨਗਰਸ੍ਯ ਪਰਿਸਰਪਰ੍ੱਯਨ੍ਤਮ੍ ਆਗਤਾਃ ਪਸ਼੍ਚਾਦ੍ਵਯੰ ਜਲਧਿਤਟੇ ਜਾਨੁਪਾਤੰ ਪ੍ਰਾਰ੍ਥਯਾਮਹਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ਤਤਃ ਪਰਸ੍ਪਰੰ ਵਿਸ੍ਰੁʼਸ਼਼੍ਟਾਃ ਸਨ੍ਤੋ ਵਯੰ ਪੋਤੰ ਗਤਾਸ੍ਤੇ ਤੁ ਸ੍ਵਸ੍ਵਗ੍ਰੁʼਹੰ ਪ੍ਰਤ੍ਯਾਗਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","ਵਯੰ ਸੋਰਨਗਰਾਤ੍ ਨਾਵਾ ਪ੍ਰਸ੍ਥਾਯ ਤਲਿਮਾਯਿਨਗਰਮ੍ ਉਪਾਤਿਸ਼਼੍ਠਾਮ ਤਤ੍ਰਾਸ੍ਮਾਕੰ ਸਮੁਦ੍ਰੀਯਮਾਰ੍ਗਸ੍ਯਾਨ੍ਤੋ(ਅ)ਭਵਤ੍ ਤਤ੍ਰ ਭ੍ਰਾਤ੍ਰੁʼਗਣੰ ਨਮਸ੍ਕ੍ਰੁʼਤ੍ਯ ਦਿਨਮੇਕੰ ਤੈਃ ਸਾਰ੍ੱਧਮ੍ ਉਸ਼਼ਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","ਪਰੇ (ਅ)ਹਨਿ ਪੌਲਸ੍ਤਸ੍ਯ ਸਙ੍ਗਿਨੋ ਵਯਞ੍ਚ ਪ੍ਰਤਿਸ਼਼੍ਠਮਾਨਾਃ ਕੈਸਰਿਯਾਨਗਰਮ੍ ਆਗਤ੍ਯ ਸੁਸੰਵਾਦਪ੍ਰਚਾਰਕਾਨਾਂ ਸਪ੍ਤਜਨਾਨਾਂ ਫਿਲਿਪਨਾਮ੍ਨ ਏਕਸ੍ਯ ਗ੍ਰੁʼਹੰ ਪ੍ਰਵਿਸ਼੍ਯਾਵਤਿਸ਼਼੍ਠਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","ਤਸ੍ਯ ਚਤਸ੍ਰੋ ਦੁਹਿਤਰੋ(ਅ)ਨੂਢਾ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨ੍ਯ ਆਸਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","ਤਤ੍ਰਾਸ੍ਮਾਸੁ ਬਹੁਦਿਨਾਨਿ ਪ੍ਰੋਸ਼਼ਿਤੇਸ਼਼ੁ ਯਿਹੂਦੀਯਦੇਸ਼ਾਦ੍ ਆਗਤ੍ਯਾਗਾਬਨਾਮਾ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦੀ ਸਮੁਪਸ੍ਥਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ਸੋਸ੍ਮਾਕੰ ਸਮੀਪਮੇਤ੍ਯ ਪੌਲਸ੍ਯ ਕਟਿਬਨ੍ਧਨੰ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਨਿਜਹਸ੍ਤਾਪਾਦਾਨ੍ ਬੱਧ੍ਵਾ ਭਾਸ਼਼ਿਤਵਾਨ੍ ਯਸ੍ਯੇਦੰ ਕਟਿਬਨ੍ਧਨੰ ਤੰ ਯਿਹੂਦੀਯਲੋਕਾ ਯਿਰੂਸ਼ਾਲਮਨਗਰ ਇੱਥੰ ਬੱਧ੍ਵਾ ਭਿੰਨਦੇਸ਼ੀਯਾਨਾਂ ਕਰੇਸ਼਼ੁ ਸਮਰ੍ਪਯਿਸ਼਼੍ਯਨ੍ਤੀਤਿ ਵਾਕ੍ਯੰ ਪਵਿਤ੍ਰ ਆਤ੍ਮਾ ਕਥਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ਏਤਾਦ੍ਰੁʼਸ਼ੀਂ ਕਥਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਵਯੰ ਤੰਨਗਰਵਾਸਿਨੋ ਭ੍ਰਾਤਰਸ਼੍ਚ ਯਿਰੂਸ਼ਾਲਮੰ ਨ ਯਾਤੁੰ ਪੌਲੰ ਵ੍ਯਨਯਾਮਹਿ; ");
INSERT INTO sanpun_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","ਕਿਨ੍ਤੁ ਸ ਪ੍ਰਤ੍ਯਾਵਾਦੀਤ੍, ਯੂਯੰ ਕਿੰ ਕੁਰੁਥ? ਕਿੰ ਕ੍ਰਨ੍ਦਨੇਨ ਮਮਾਨ੍ਤਃਕਰਣੰ ਵਿਦੀਰ੍ਣੰ ਕਰਿਸ਼਼੍ਯਥ? ਪ੍ਰਭੋ ਰ੍ਯੀਸ਼ੋ ਰ੍ਨਾਮ੍ਨੋ ਨਿਮਿੱਤੰ ਯਿਰੂਸ਼ਾਲਮਿ ਬੱਧੋ ਭਵਿਤੁੰ ਕੇਵਲ ਤੰਨ ਪ੍ਰਾਣਾਨ੍ ਦਾਤੁਮਪਿ ਸਸੱਜੋਸ੍ਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","ਤੇਨਾਸ੍ਮਾਕੰ ਕਥਾਯਾਮ੍ ਅਗ੍ਰੁʼਹੀਤਾਯਾਮ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਯਥੇੱਛਾ ਤਥੈਵ ਭਵਤ੍ਵਿਤ੍ਯੁਕ੍ਤ੍ਵਾ ਵਯੰ ਨਿਰਸ੍ਯਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","ਪਰੇ(ਅ)ਹਨਿ ਪਾਥੇਯਦ੍ਰਵ੍ਯਾਣਿ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਯਿਰੂਸ਼ਾਲਮੰ ਪ੍ਰਤਿ ਯਾਤ੍ਰਾਮ੍ ਅਕੁਰ੍ੰਮ| ");
INSERT INTO sanpun_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","ਤਤਃ ਕੈਸਰਿਯਾਨਗਰਨਿਵਾਸਿਨਃ ਕਤਿਪਯਾਃ ਸ਼ਿਸ਼਼੍ਯਾ ਅਸ੍ਮਾਭਿਃ ਸਾਰ੍ੱਧਮ੍ ਇਤ੍ਵਾ ਕ੍ਰੁʼਪ੍ਰੀਯੇਨ ਮ੍ਨਾਸੰਨਾਮ੍ਨਾ ਯੇਨ ਪ੍ਰਾਚੀਨਸ਼ਿਸ਼਼੍ਯੇਨ ਸਾਰ੍ੱਧਮ੍ ਅਸ੍ਮਾਭਿ ਰ੍ਵਸ੍ਤਵ੍ਯੰ ਤਸ੍ਯ ਸਮੀਪਮ੍ ਅਸ੍ਮਾਨ੍ ਨੀਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","ਅਸ੍ਮਾਸੁ ਯਿਰੂਸ਼ਾਲਮ੍ਯੁਪਸ੍ਥਿਤੇਸ਼਼ੁ ਤਤ੍ਰਸ੍ਥਭ੍ਰਾਤ੍ਰੁʼਗਣੋ(ਅ)ਸ੍ਮਾਨ੍ ਆਹ੍ਲਾਦੇਨ ਗ੍ਰੁʼਹੀਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","ਪਰਸ੍ਮਿਨ੍ ਦਿਵਸੇ ਪੌਲੇ(ਅ)ਸ੍ਮਾਭਿਃ ਸਹ ਯਾਕੂਬੋ ਗ੍ਰੁʼਹੰ ਪ੍ਰਵਿਸ਼਼੍ਟੇ ਲੋਕਪ੍ਰਾਚੀਨਾਃ ਸਰ੍ੱਵੇ ਤਤ੍ਰ ਪਰਿਸ਼਼ਦਿ ਸੰਸ੍ਥਿਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","ਅਨਨ੍ਤਰੰ ਸ ਤਾਨ੍ ਨਤ੍ਵਾ ਸ੍ਵੀਯਪ੍ਰਚਾਰਣੇਨ ਭਿੰਨਦੇਸ਼ੀਯਾਨ੍ ਪ੍ਰਤੀਸ਼੍ਵਰੋ ਯਾਨਿ ਕਰ੍ੰਮਾਣਿ ਸਾਧਿਤਵਾਨ੍ ਤਦੀਯਾਂ ਕਥਾਮ੍ ਅਨੁਕ੍ਰਮਾਤ੍ ਕਥਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ਇਤਿ ਸ਼੍ਰੁਤ੍ਵਾ ਤੇ ਪ੍ਰਭੁੰ ਧਨ੍ਯੰ ਪ੍ਰੋਚ੍ਯ ਵਾਕ੍ਯਮਿਦਮ੍ ਅਭਾਸ਼਼ਨ੍ਤ, ਹੇ ਭ੍ਰਾਤ ਰ੍ਯਿਹੂਦੀਯਾਨਾਂ ਮਧ੍ਯੇ ਬਹੁਸਹਸ੍ਰਾਣਿ ਲੋਕਾ ਵਿਸ਼੍ਵਾਸਿਨ ਆਸਤੇ ਕਿਨ੍ਤੁ ਤੇ ਸਰ੍ੱਵੇ ਵ੍ਯਵਸ੍ਥਾਮਤਾਚਾਰਿਣ ਏਤਤ੍ ਪ੍ਰਤ੍ਯਕ੍ਸ਼਼ੰ ਪਸ਼੍ਯਸਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","ਸ਼ਿਸ਼ੂਨਾਂ ਤ੍ਵਕ੍ਛੇਦਨਾਦ੍ਯਾਚਰਣੰ ਪ੍ਰਤਿਸ਼਼ਿਧ੍ਯ ਤ੍ਵੰ ਭਿੰਨਦੇਸ਼ਨਿਵਾਸਿਨੋ ਯਿਹੂਦੀਯਲੋਕਾਨ੍ ਮੂਸਾਵਾਕ੍ਯਮ੍ ਅਸ਼੍ਰੱਧਾਤੁਮ੍ ਉਪਦਿਸ਼ਸੀਤਿ ਤੈਃ ਸ਼੍ਰੁਤਮਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","ਤ੍ਵਮਤ੍ਰਾਗਤੋਸੀਤਿ ਵਾਰ੍ੱਤਾਂ ਸਮਾਕਰ੍ਣ੍ਯ ਜਨਨਿਵਹੋ ਮਿਲਿਤ੍ਵਾਵਸ਼੍ਯਮੇਵਾਗਮਿਸ਼਼੍ਯਤਿ; ਅਤਏਵ ਕਿੰ ਕਰਣੀਯਮ੍? ਅਤ੍ਰ ਵਯੰ ਮਨ੍ਤ੍ਰਯਿਤ੍ਵਾ ਸਮੁਪਾਯੰ ਤ੍ਵਾਂ ਵਦਾਮਸ੍ਤੰ ਤ੍ਵਮਾਚਰ| ");
INSERT INTO sanpun_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","ਵ੍ਰਤੰ ਕਰ੍ੱਤੁੰ ਕ੍ਰੁʼਤਸਙ੍ਕਲ੍ਪਾ ਯੇ(ਅ)ਸ੍ਮਾਂਕ ਚਤ੍ਵਾਰੋ ਮਾਨਵਾਃ ਸਨ੍ਤਿ ");
INSERT INTO sanpun_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","ਤਾਨ੍ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਤੈਃ ਸਹਿਤਃ ਸ੍ਵੰ ਸ਼ੁਚਿੰ ਕੁਰੁ ਤਥਾ ਤੇਸ਼਼ਾਂ ਸ਼ਿਰੋਮੁਣ੍ਡਨੇ ਯੋ ਵ੍ਯਯੋ ਭਵਤਿ ਤੰ ਤ੍ਵੰ ਦੇਹਿ| ਤਥਾ ਕ੍ਰੁʼਤੇ ਤ੍ਵਦੀਯਾਚਾਰੇ ਯਾ ਜਨਸ਼੍ਰੁਤਿ ਰ੍ਜਾਯਤੇ ਸਾਲੀਕਾ ਕਿਨ੍ਤੁ ਤ੍ਵੰ ਵਿਧਿੰ ਪਾਲਯਨ੍ ਵ੍ਯਵਸ੍ਥਾਨੁਸਾਰੇਣੇਵਾਚਰਸੀਤਿ ਤੇ ਭੋਤ੍ਸਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","ਭਿੰਨਦੇਸ਼ੀਯਾਨਾਂ ਵਿਸ਼੍ਵਾਸਿਲੋਕਾਨਾਂ ਨਿਕਟੇ ਵਯੰ ਪਤ੍ਰੰ ਲਿਖਿਤ੍ਵੇੱਥੰ ਸ੍ਥਿਰੀਕ੍ਰੁʼਤਵਨ੍ਤਃ, ਦੇਵਪ੍ਰਸਾਦਭੋਜਨੰ ਰਕ੍ਤੰ ਗਲਪੀਡਨਮਾਰਿਤਪ੍ਰਾਣਿਭੋਜਨੰ ਵ੍ਯਭਿਚਾਰਸ਼੍ਚੈਤੇਭ੍ਯਃ ਸ੍ਵਰਕ੍ਸ਼਼ਣਵ੍ਯਤਿਰੇਕੇਣ ਤੇਸ਼਼ਾਮਨ੍ਯਵਿਧਿਪਾਲਨੰ ਕਰਣੀਯੰ ਨ| ");
INSERT INTO sanpun_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","ਤਤਃ ਪੌਲਸ੍ਤਾਨ੍ ਮਾਨੁਸ਼਼ਾਨਾਦਾਯ ਪਰਸ੍ਮਿਨ੍ ਦਿਵਸੇ ਤੈਃ ਸਹ ਸ਼ੁਚਿ ਰ੍ਭੂਤ੍ਵਾ ਮਨ੍ਦਿਰੰ ਗਤ੍ਵਾ ਸ਼ੌਚਕਰ੍ੰਮਣੋ ਦਿਨੇਸ਼਼ੁ ਸਮ੍ਪੂਰ੍ਣੇਸ਼਼ੁ ਤੇਸ਼਼ਾਮ੍ ਏਕੈਕਾਰ੍ਥੰ ਨੈਵੇਦ੍ਯਾਦ੍ਯੁਤ੍ਸਰ੍ਗੋ ਭਵਿਸ਼਼੍ਯਤੀਤਿ ਜ੍ਞਾਪਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","ਤੇਸ਼਼ੁ ਸਪ੍ਤਸੁ ਦਿਨੇਸ਼਼ੁ ਸਮਾਪ੍ਤਕਲ੍ਪੇਸ਼਼ੁ ਆਸ਼ਿਯਾਦੇਸ਼ਨਿਵਾਸਿਨੋ ਯਿਹੂਦੀਯਾਸ੍ਤੰ ਮਧ੍ਯੇਮਨ੍ਦਿਰੰ ਵਿਲੋਕ੍ਯ ਜਨਨਿਵਹਸ੍ਯ ਮਨਃਸੁ ਕੁਪ੍ਰਵ੍ਰੁʼੱਤਿੰ ਜਨਯਿਤ੍ਵਾ ਤੰ ਧ੍ਰੁʼਤ੍ਵਾ ");
INSERT INTO sanpun_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ਪ੍ਰੋੱਚੈਃ ਪ੍ਰਾਵੋਚਨ੍, ਹੇ ਇਸ੍ਰਾਯੇੱਲੋਕਾਃ ਸਰ੍ੱਵੇ ਸਾਹਾੱਯੰ ਕੁਰੁਤ| ਯੋ ਮਨੁਜ ਏਤੇਸ਼਼ਾਂ ਲੋਕਾਨਾਂ ਮੂਸਾਵ੍ਯਵਸ੍ਥਾਯਾ ਏਤਸ੍ਯ ਸ੍ਥਾਨਸ੍ਯਾਪਿ ਵਿਪਰੀਤੰ ਸਰ੍ੱਵਤ੍ਰ ਸਰ੍ੱਵਾਨ੍ ਸ਼ਿਕ੍ਸ਼਼ਯਤਿ ਸ ਏਸ਼਼ਃ; ਵਿਸ਼ੇਸ਼਼ਤਃ ਸ ਭਿੰਨਦੇਸ਼ੀਯਲੋਕਾਨ੍ ਮਨ੍ਦਿਰਮ੍ ਆਨੀਯ ਪਵਿਤ੍ਰਸ੍ਥਾਨਮੇਤਦ੍ ਅਪਵਿਤ੍ਰਮਕਰੋਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","ਪੂਰ੍ੱਵੰ ਤੇ ਮਧ੍ਯੇਨਗਰਮ੍ ਇਫਿਸ਼਼ਨਗਰੀਯੰ ਤ੍ਰਫਿਮੰ ਪੌਲੇਨ ਸਹਿਤੰ ਦ੍ਰੁʼਸ਼਼੍ਟਵਨ੍ਤ ਏਤਸ੍ਮਾਤ੍ ਪੌਲਸ੍ਤੰ ਮਨ੍ਦਿਰਮਧ੍ਯਮ੍ ਆਨਯਦ੍ ਇਤ੍ਯਨ੍ਵਮਿਮਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","ਅਤਏਵ ਸਰ੍ੱਵਸ੍ਮਿਨ੍ ਨਗਰੇ ਕਲਹੋਤ੍ਪੰਨਤ੍ਵਾਤ੍ ਧਾਵਨ੍ਤੋ ਲੋਕਾ ਆਗਤ੍ਯ ਪੌਲੰ ਧ੍ਰੁʼਤ੍ਵਾ ਮਨ੍ਦਿਰਸ੍ਯ ਬਹਿਰਾਕ੍ਰੁʼਸ਼਼੍ਯਾਨਯਨ੍ ਤਤ੍ਕ੍ਸ਼਼ਣਾਦ੍ ਦ੍ਵਾਰਾਣਿ ਸਰ੍ੱਵਾਣਿ ਚ ਰੁੱਧਾਨਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","ਤੇਸ਼਼ੁ ਤੰ ਹਨ੍ਤੁਮੁਦ੍ਯਤੇेਸ਼਼ੁ ਯਿਰੂਸ਼ਾਲਮ੍ਨਗਰੇ ਮਹਾਨੁਪਦ੍ਰਵੋ ਜਾਤ ਇਤਿ ਵਾਰ੍ੱਤਾਯਾਂ ਸਹਸ੍ਰਸੇਨਾਪਤੇਃ ਕਰ੍ਣਗੋਚਰੀਭੂਤਾਯਾਂ ਸਤ੍ਯਾਂ ਸ ਤਤ੍ਕ੍ਸ਼਼ਣਾਤ੍ ਸੈਨ੍ਯਾਨਿ ਸੇਨਾਪਤਿਗਣਞ੍ਚ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਜਵੇਨਾਗਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","ਤਤੋ ਲੋਕਾਃ ਸੇਨਾਗਣੇਨ ਸਹ ਸਹਸ੍ਰਸੇਨਾਪਤਿਮ੍ ਆਗੱਛਨ੍ਤੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਪੌਲਤਾਡਨਾਤੋ ਨ੍ਯਵਰ੍ੱਤਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","ਸ ਸਹਸ੍ਰਸੇਨਾਪਤਿਃ ਸੰਨਿਧਾਵਾਗਮ੍ਯ ਪੌਲੰ ਧ੍ਰੁʼਤ੍ਵਾ ਸ਼੍ਰੁʼਙ੍ਖਲਦ੍ਵਯੇਨ ਬੱਧਮ੍ ਆਦਿਸ਼੍ਯ ਤਾਨ੍ ਪ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍ ਏਸ਼਼ ਕਃ? ਕਿੰ ਕਰ੍ੰਮ ਚਾਯੰ ਕ੍ਰੁʼਤਵਾਨ੍? ");
INSERT INTO sanpun_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","ਤਤੋ ਜਨਸਮੂਹਸ੍ਯ ਕਸ਼੍ਚਿਦ੍ ਏਕਪ੍ਰਕਾਰੰ ਕਸ਼੍ਚਿਦ੍ ਅਨ੍ਯਪ੍ਰਕਾਰੰ ਵਾਕ੍ਯਮ੍ ਅਰੌਤ੍ ਸ ਤਤ੍ਰ ਸਤ੍ਯੰ ਜ੍ਞਾਤੁਮ੍ ਕਲਹਕਾਰਣਾਦ੍ ਅਸ਼ਕ੍ਤਃ ਸਨ੍ ਤੰ ਦੁਰ੍ਗੰ ਨੇਤੁਮ੍ ਆਜ੍ਞਾਪਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","ਤੇਸ਼਼ੁ ਸੋਪਾਨਸ੍ਯੋਪਰਿ ਪ੍ਰਾਪ੍ਤੇਸ਼਼ੁ ਲੋਕਾਨਾਂ ਸਾਹਸਕਾਰਣਾਤ੍ ਸੇਨਾਗਣਃ ਪੌਲਮੁੱਤੋਲ੍ਯ ਨੀਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ਤਤਃ ਸਰ੍ੱਵੇ ਲੋਕਾਃ ਪਸ਼੍ਚਾਦ੍ਗਾਮਿਨਃ ਸਨ੍ਤ ਏਨੰ ਦੁਰੀਕੁਰੁਤੇਤਿ ਵਾਕ੍ਯਮ੍ ਉੱਚੈਰਵਦਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","ਪੌਲਸ੍ਯ ਦੁਰ੍ਗਾਨਯਨਸਮਯੇ ਸ ਤਸ੍ਮੈ ਸਹਸ੍ਰਸੇਨਾਪਤਯੇ ਕਥਿਤਵਾਨ੍, ਭਵਤਃ ਪੁਰਸ੍ਤਾਤ੍ ਕਥਾਂ ਕਥਯਿਤੁੰ ਕਿਮ੍ ਅਨੁਮਨ੍ਯਤੇ? ਸ ਤਮਪ੍ਰੁʼੱਛਤ੍ ਤ੍ਵੰ ਕਿੰ ਯੂਨਾਨੀਯਾਂ ਭਾਸ਼਼ਾਂ ਜਾਨਾਸਿ? ");
INSERT INTO sanpun_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","ਯੋ ਮਿਸਰੀਯੋ ਜਨਃ ਪੂਰ੍ੱਵੰ ਵਿਰੋਧੰ ਕ੍ਰੁʼਤ੍ਵਾ ਚਤ੍ਵਾਰਿ ਸਹਸ੍ਰਾਣਿ ਘਾਤਕਾਨ੍ ਸਙ੍ਗਿਨਃ ਕ੍ਰੁʼਤ੍ਵਾ ਵਿਪਿਨੰ ਗਤਵਾਨ੍ ਤ੍ਵੰ ਕਿੰ ਸਏਵ ਨ ਭਵਸਿ? ");
INSERT INTO sanpun_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","ਤਦਾ ਪੌਲੋ(ਅ)ਕਥਯਤ੍ ਅਹੰ ਕਿਲਿਕਿਯਾਦੇਸ਼ਸ੍ਯ ਤਾਰ੍ਸ਼਼ਨਗਰੀਯੋ ਯਿਹੂਦੀਯੋ, ਨਾਹੰ ਸਾਮਾਨ੍ਯਨਗਰੀਯੋ ਮਾਨਵਃ; ਅਤਏਵ ਵਿਨਯੇ(ਅ)ਹੰ ਲਾਕਾਨਾਂ ਸਮਕ੍ਸ਼਼ੰ ਕਥਾਂ ਕਥਯਿਤੁੰ ਮਾਮਨੁਜਾਨੀਸ਼਼੍ਵ| ");
INSERT INTO sanpun_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","ਤੇਨਾਨੁਜ੍ਞਾਤਃ ਪੌਲਃ ਸੋਪਾਨੋਪਰਿ ਤਿਸ਼਼੍ਠਨ੍ ਹਸ੍ਤੇਨੇਙ੍ਗਿਤੰ ਕ੍ਰੁʼਤਵਾਨ੍, ਤਸ੍ਮਾਤ੍ ਸਰ੍ੱਵੇ ਸੁਸ੍ਥਿਰਾ ਅਭਵਨ੍| ਤਦਾ ਪੌਲ ਇਬ੍ਰੀਯਭਾਸ਼਼ਯਾ ਕਥਯਿਤੁਮ੍ ਆਰਭਤ, ");
INSERT INTO sanpun_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","ਹੇ ਪਿਤ੍ਰੁʼਗਣਾ ਹੇ ਭ੍ਰਾਤ੍ਰੁʼਗਣਾਃ, ਇਦਾਨੀਂ ਮਮ ਨਿਵੇਦਨੇ ਸਮਵਧੱਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","ਤਦਾ ਸ ਇਬ੍ਰੀਯਭਾਸ਼਼ਯਾ ਕਥਾਂ ਕਥਯਤੀਤਿ ਸ਼੍ਰੁਤ੍ਵਾ ਸਰ੍ੱਵੇ ਲੋਕਾ ਅਤੀਵ ਨਿਃਸ਼ਬ੍ਦਾ ਸਨ੍ਤੋ(ਅ)ਤਿਸ਼਼੍ਠਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","ਪਸ਼੍ਚਾਤ੍ ਸੋ(ਅ)ਕਥਯਦ੍ ਅਹੰ ਯਿਹੂਦੀਯ ਇਤਿ ਨਿਸ਼੍ਚਯਃ ਕਿਲਿਕਿਯਾਦੇਸ਼ਸ੍ਯ ਤਾਰ੍ਸ਼਼ਨਗਰੰ ਮਮ ਜਨ੍ਮਭੂਮਿਃ,ਏਤੰਨਗਰੀਯਸ੍ਯ ਗਮਿਲੀਯੇਲਨਾਮ੍ਨੋ(ਅ)ਧ੍ਯਾਪਕਸ੍ਯ ਸ਼ਿਸ਼਼੍ਯੋ ਭੂਤ੍ਵਾ ਪੂਰ੍ੱਵਪੁਰੁਸ਼਼ਾਣਾਂ ਵਿਧਿਵ੍ਯਵਸ੍ਥਾਨੁਸਾਰੇਣ ਸਮ੍ਪੂਰ੍ਣਰੂਪੇਣ ਸ਼ਿਕ੍ਸ਼਼ਿਤੋ(ਅ)ਭਵਮ੍ ਇਦਾਨੀਨ੍ਤਨਾ ਯੂਯੰ ਯਾਦ੍ਰੁʼਸ਼ਾ ਭਵਥ ਤਾਦ੍ਰੁʼਸ਼ੋ(ਅ)ਹਮਪੀਸ਼੍ਵਰਸੇਵਾਯਾਮ੍ ਉਦ੍ਯੋਗੀ ਜਾਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","ਮਤਮੇਤਦ੍ ਦ੍ਵਿਸ਼਼੍ਟ੍ਵਾ ਤਦ੍ਗ੍ਰਾਹਿਨਾਰੀਪੁਰੁਸ਼਼ਾਨ੍ ਕਾਰਾਯਾਂ ਬੱਧ੍ਵਾ ਤੇਸ਼਼ਾਂ ਪ੍ਰਾਣਨਾਸ਼ਪਰ੍ੱਯਨ੍ਤਾਂ ਵਿਪਕ੍ਸ਼਼ਤਾਮ੍ ਅਕਰਵਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","ਮਹਾਯਾਜਕਃ ਸਭਾਸਦਃ ਪ੍ਰਾਚੀਨਲੋਕਾਸ਼੍ਚ ਮਮੈਤਸ੍ਯਾਃ ਕਥਾਯਾਃ ਪ੍ਰਮਾਣੰ ਦਾਤੁੰ ਸ਼ਕ੍ਨੁਵਨ੍ਤਿ, ਯਸ੍ਮਾਤ੍ ਤੇਸ਼਼ਾਂ ਸਮੀਪਾਦ੍ ਦੰਮੇਸ਼਼ਕਨਗਰਨਿਵਾਸਿਭ੍ਰਾਤ੍ਰੁʼਗਣਾਰ੍ਥਮ੍ ਆਜ੍ਞਾਪਤ੍ਰਾਣਿ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਯੇ ਤਤ੍ਰ ਸ੍ਥਿਤਾਸ੍ਤਾਨ੍ ਦਣ੍ਡਯਿਤੁੰ ਯਿਰੂਸ਼ਾਲਮਮ੍ ਆਨਯਨਾਰ੍ਥੰ ਦੰਮੇਸ਼਼ਕਨਗਰੰ ਗਤੋਸ੍ਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","ਕਿਨ੍ਤੁ ਗੱਛਨ੍ ਤੰਨਗਰਸ੍ਯ ਸਮੀਪੰ ਪ੍ਰਾਪ੍ਤਵਾਨ੍ ਤਦਾ ਦ੍ਵਿਤੀਯਪ੍ਰਹਰਵੇਲਾਯਾਂ ਸਤ੍ਯਾਮ੍ ਅਕਸ੍ਮਾਦ੍ ਗਗਣਾੰਨਿਰ੍ਗਤ੍ਯ ਮਹਤੀ ਦੀਪ੍ਤਿ ਰ੍ਮਮ ਚਤੁਰ੍ਦਿਸ਼ਿ ਪ੍ਰਕਾਸ਼ਿਤਵਤੀ| ");
INSERT INTO sanpun_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ਤਤੋ ਮਯਿ ਭੂਮੌै ਪਤਿਤੇ ਸਤਿ, ਹੇ ਸ਼ੌਲ ਹੇ ਸ਼ੌਲ ਕੁਤੋ ਮਾਂ ਤਾਡਯਸਿ? ਮਾਮ੍ਪ੍ਰਤਿ ਭਾਸ਼਼ਿਤ ਏਤਾਦ੍ਰੁʼਸ਼ ਏਕੋ ਰਵੋਪਿ ਮਯਾ ਸ਼੍ਰੁਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","ਤਦਾਹੰ ਪ੍ਰਤ੍ਯਵਦੰ, ਹੇ ਪ੍ਰਭੇ ਕੋ ਭਵਾਨ੍? ਤਤਃ ਸੋ(ਅ)ਵਾਦੀਤ੍ ਯੰ ਤ੍ਵੰ ਤਾਡਯਸਿ ਸ ਨਾਸਰਤੀਯੋ ਯੀਸ਼ੁਰਹੰ| ");
INSERT INTO sanpun_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","ਮਮ ਸਙ੍ਗਿਨੋ ਲੋਕਾਸ੍ਤਾਂ ਦੀਪ੍ਤਿੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਭਿਯੰ ਪ੍ਰਾਪ੍ਤਾਃ, ਕਿਨ੍ਤੁ ਮਾਮ੍ਪ੍ਰਤ੍ਯੁਦਿਤੰ ਤਦ੍ਵਾਕ੍ਯੰ ਤੇे ਨਾਬੁਧ੍ਯਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","ਤਤਃ ਪਰੰ ਪ੍ਰੁʼਸ਼਼੍ਟਵਾਨਹੰ, ਹੇ ਪ੍ਰਭੋ ਮਯਾ ਕਿੰ ਕਰ੍ੱਤਵ੍ਯੰ? ਤਤਃ ਪ੍ਰਭੁਰਕਥਯਤ੍, ਉੱਥਾਯ ਦੰਮੇਸ਼਼ਕਨਗਰੰ ਯਾਹਿ ਤ੍ਵਯਾ ਯਦ੍ਯਤ੍ ਕਰ੍ੱਤਵ੍ਯੰ ਨਿਰੂਪਿਤਮਾਸ੍ਤੇ ਤਤ੍ ਤਤ੍ਰ ਤ੍ਵੰ ਜ੍ਞਾਪਯਿਸ਼਼੍ਯਸੇ| ");
INSERT INTO sanpun_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","ਅਨਨ੍ਤਰੰ ਤਸ੍ਯਾਃ ਖਰਤਰਦੀਪ੍ਤੇਃ ਕਾਰਣਾਤ੍ ਕਿਮਪਿ ਨ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਸਙ੍ਗਿਗਣੇਨ ਧ੍ਰੁʼਤਹਸ੍ਤਃ ਸਨ੍ ਦੰਮੇਸ਼਼ਕਨਗਰੰ ਵ੍ਰਜਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","ਤੰਨਗਰਨਿਵਾਸਿਨਾਂ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਯਿਹੂਦੀਯਾਨਾਂ ਮਾਨ੍ਯੋ ਵ੍ਯਵਸ੍ਥਾਨੁਸਾਰੇਣ ਭਕ੍ਤਸ਼੍ਚ ਹਨਾਨੀਯਨਾਮਾ ਮਾਨਵ ਏਕੋ ");
INSERT INTO sanpun_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","ਮਮ ਸੰਨਿਧਿਮ੍ ਏਤ੍ਯ ਤਿਸ਼਼੍ਠਨ੍ ਅਕਥਯਤ੍, ਹੇ ਭ੍ਰਾਤਃ ਸ਼ੌਲ ਸੁਦ੍ਰੁʼਸ਼਼੍ਟਿ ਰ੍ਭਵ ਤਸ੍ਮਿਨ੍ ਦਣ੍ਡੇ(ਅ)ਹੰ ਸਮ੍ਯਕ੍ ਤੰ ਦ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","ਤਤਃ ਸ ਮਹ੍ਯੰ ਕਥਿਤਵਾਨ੍ ਯਥਾ ਤ੍ਵਮ੍ ਈਸ਼੍ਵਰਸ੍ਯਾਭਿਪ੍ਰਾਯੰ ਵੇਤ੍ਸਿ ਤਸ੍ਯ ਸ਼ੁੱਧਸੱਤ੍ਵਜਨਸ੍ਯ ਦਰ੍ਸ਼ਨੰ ਪ੍ਰਾਪ੍ਯ ਤਸ੍ਯ ਸ਼੍ਰੀਮੁਖਸ੍ਯ ਵਾਕ੍ਯੰ ਸ਼੍ਰੁʼਣੋਸ਼਼ਿ ਤੰਨਿਮਿੱਤਮ੍ ਅਸ੍ਮਾਕੰ ਪੂਰ੍ੱਵਪੁਰੁਸ਼਼ਾਣਾਮ੍ ਈਸ਼੍ਵਰਸ੍ਤ੍ਵਾਂ ਮਨੋਨੀਤੰ ਕ੍ਰੁʼਤਵਾਨੰ| ");
INSERT INTO sanpun_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","ਯਤੋ ਯਦ੍ਯਦ੍ ਅਦ੍ਰਾਕ੍ਸ਼਼ੀਰਸ਼੍ਰੌਸ਼਼ੀਸ਼੍ਚ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਮਾਨਵਾਨਾਂ ਸਮੀਪੇ ਤ੍ਵੰ ਤੇਸ਼਼ਾਂ ਸਾਕ੍ਸ਼਼ੀ ਭਵਿਸ਼਼੍ਯਸਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","ਅਤਏਵ ਕੁਤੋ ਵਿਲਮ੍ਬਸੇ? ਪ੍ਰਭੋ ਰ੍ਨਾਮ੍ਨਾ ਪ੍ਰਾਰ੍ਥ੍ਯ ਨਿਜਪਾਪਪ੍ਰਕ੍ਸ਼਼ਾਲਨਾਰ੍ਥੰ ਮੱਜਨਾਯ ਸਮੁੱਤਿਸ਼਼੍ਠ| ");
INSERT INTO sanpun_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","ਤਤਃ ਪਰੰ ਯਿਰੂਸ਼ਾਲਮ੍ਨਗਰੰ ਪ੍ਰਤ੍ਯਾਗਤ੍ਯ ਮਨ੍ਦਿਰੇ(ਅ)ਹਮ੍ ਏਕਦਾ ਪ੍ਰਾਰ੍ਥਯੇ, ਤਸ੍ਮਿਨ੍ ਸਮਯੇ(ਅ)ਹਮ੍ ਅਭਿਭੂਤਃ ਸਨ੍ ਪ੍ਰਭੂੰ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਪਸ਼੍ਯਨ੍, ");
INSERT INTO sanpun_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ਤ੍ਵੰ ਤ੍ਵਰਯਾ ਯਿਰੂਸ਼ਾਲਮਃ ਪ੍ਰਤਿਸ਼਼੍ਠਸ੍ਵ ਯਤੋ ਲੋਕਾਮਯਿ ਤਵ ਸਾਕ੍ਸ਼਼੍ਯੰ ਨ ਗ੍ਰਹੀਸ਼਼੍ਯਨ੍ਤਿ, ਮਾਮ੍ਪ੍ਰਤ੍ਯੁਦਿਤੰ ਤਸ੍ਯੇਦੰ ਵਾਕ੍ਯਮ੍ ਅਸ਼੍ਰੌਸ਼਼ਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","ਤਤੋਹੰ ਪ੍ਰਤ੍ਯਵਾਦਿਸ਼਼ਮ੍ ਹੇ ਪ੍ਰਭੋ ਪ੍ਰਤਿਭਜਨਭਵਨੰ ਤ੍ਵਯਿ ਵਿਸ਼੍ਵਾਸਿਨੋ ਲੋਕਾਨ੍ ਬੱਧ੍ਵਾ ਪ੍ਰਹ੍ਰੁʼਤਵਾਨ੍, ");
INSERT INTO sanpun_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","ਤਥਾ ਤਵ ਸਾਕ੍ਸ਼਼ਿਣਃ ਸ੍ਤਿਫਾਨਸ੍ਯ ਰਕ੍ਤਪਾਤਨਸਮਯੇ ਤਸ੍ਯ ਵਿਨਾਸ਼ੰ ਸੰਮਨ੍ਯ ਸੰਨਿਧੌ ਤਿਸ਼਼੍ਠਨ੍ ਹਨ੍ਤ੍ਰੁʼਲੋਕਾਨਾਂ ਵਾਸਾਂਸਿ ਰਕ੍ਸ਼਼ਿਤਵਾਨ੍, ਏਤਤ੍ ਤੇ ਵਿਦੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","ਤਤਃ ਸੋ(ਅ)ਕਥਯਤ੍ ਪ੍ਰਤਿਸ਼਼੍ਠਸ੍ਵ ਤ੍ਵਾਂ ਦੂਰਸ੍ਥਭਿੰਨਦੇਸ਼ੀਯਾਨਾਂ ਸਮੀਪੰ ਪ੍ਰੇਸ਼਼ਯਿਸ਼਼੍ਯੇ| ");
INSERT INTO sanpun_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","ਤਦਾ ਲੋਕਾ ਏਤਾਵਤ੍ਪਰ੍ੱਯਨ੍ਤਾਂ ਤਦੀਯਾਂ ਕਥਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਪ੍ਰੋੱਚੈਰਕਥਯਨ੍, ਏਨੰ ਭੂਮਣ੍ਡਲਾਦ੍ ਦੂਰੀਕੁਰੁਤ, ਏਤਾਦ੍ਰੁʼਸ਼ਜਨਸ੍ਯ ਜੀਵਨੰ ਨੋਚਿਤਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ਇਤ੍ਯੁੱਚੈਃ ਕਥਯਿਤ੍ਵਾ ਵਸਨਾਨਿ ਪਰਿਤ੍ਯਜ੍ਯ ਗਗਣੰ ਪ੍ਰਤਿ ਧੂਲੀਰਕ੍ਸ਼਼ਿਪਨ੍ ");
INSERT INTO sanpun_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ਤਤਃ ਸਹਸ੍ਰਸੇਨਾਪਤਿਃ ਪੌਲੰ ਦੁਰ੍ਗਾਭ੍ਯਨ੍ਤਰ ਨੇਤੁੰ ਸਮਾਦਿਸ਼ਤ੍| ਏਤਸ੍ਯ ਪ੍ਰਤਿਕੂਲਾਃ ਸਨ੍ਤੋ ਲੋਕਾਃ ਕਿੰਨਿਮਿੱਤਮ੍ ਏਤਾਵਦੁੱਚੈਃਸ੍ਵਰਮ੍ ਅਕੁਰ੍ੱਵਨ੍, ਏਤਦ੍ ਵੇੱਤੁੰ ਤੰ ਕਸ਼ਯਾ ਪ੍ਰਹ੍ਰੁʼਤ੍ਯ ਤਸ੍ਯ ਪਰੀਕ੍ਸ਼਼ਾਂ ਕਰ੍ੱਤੁਮਾਦਿਸ਼ਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","ਪਦਾਤਯਸ਼੍ਚਰ੍ੰਮਨਿਰ੍ੰਮਿਤਰੱਜੁਭਿਸ੍ਤਸ੍ਯ ਬਨ੍ਧਨੰ ਕਰ੍ੱਤੁਮੁਦ੍ਯਤਾਸ੍ਤਾਸ੍ਤਦਾਨੀਂ ਪੌਲਃ ਸੰਮੁਖਸ੍ਥਿਤੰ ਸ਼ਤਸੇਨਾਪਤਿਮ੍ ਉਕ੍ਤਵਾਨ੍ ਦਣ੍ਡਾਜ੍ਞਾਯਾਮ੍ ਅਪ੍ਰਾਪ੍ਤਾਯਾਂ ਕਿੰ ਰੋਮਿਲੋਕੰ ਪ੍ਰਹਰ੍ੱਤੁੰ ਯੁਸ਼਼੍ਮਾਕਮ੍ ਅਧਿਕਾਰੋਸ੍ਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","ਏਨਾਂ ਕਥਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਸ ਸਹਸ੍ਰਸੇਨਾਪਤੇਃ ਸੰਨਿਧਿੰ ਗਤ੍ਵਾ ਤਾਂ ਵਾਰ੍ੱਤਾਮਵਦਤ੍ ਸ ਰੋਮਿਲੋਕ ਏਤਸ੍ਮਾਤ੍ ਸਾਵਧਾਨਃ ਸਨ੍ ਕਰ੍ੰਮ ਕੁਰੁ| ");
INSERT INTO sanpun_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","ਤਸ੍ਮਾਤ੍ ਸਹਸ੍ਰਸੇਨਾਪਤਿ ਰ੍ਗਤ੍ਵਾ ਤਮਪ੍ਰਾਕ੍ਸ਼਼ੀਤ੍ ਤ੍ਵੰ ਕਿੰ ਰੋਮਿਲੋਕਃ? ਇਤਿ ਮਾਂ ਬ੍ਰੂਹਿ| ਸੋ(ਅ)ਕਥਯਤ੍ ਸਤ੍ਯਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","ਤਤਃ ਸਹਸ੍ਰਸੇਨਾਪਤਿਃ ਕਥਿਤਵਾਨ੍ ਬਹੁਦ੍ਰਵਿਣੰ ਦੱਤ੍ਵਾਹੰ ਤਤ੍ ਪੌਰਸਖ੍ਯੰ ਪ੍ਰਾਪ੍ਤਵਾਨ੍; ਕਿਨ੍ਤੁ ਪੌਲਃ ਕਥਿਤਵਾਨ੍ ਅਹੰ ਜਨੁਨਾ ਤਤ੍ ਪ੍ਰਾਪ੍ਤੋ(ਅ)ਸ੍ਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","ਇੱਥੰ ਸਤਿ ਯੇ ਪ੍ਰਹਾਰੇਣ ਤੰ ਪਰੀਕ੍ਸ਼਼ਿਤੁੰ ਸਮੁਦ੍ਯਤਾ ਆਸਨ੍ ਤੇ ਤਸ੍ਯ ਸਮੀਪਾਤ੍ ਪ੍ਰਾਤਿਸ਼਼੍ਠਨ੍ਤ; ਸਹਸ੍ਰਸੇਨਾਪਤਿਸ੍ਤੰ ਰੋਮਿਲੋਕੰ ਵਿਜ੍ਞਾਯ ਸ੍ਵਯੰ ਯਤ੍ ਤਸ੍ਯ ਬਨ੍ਧਨਮ੍ ਅਕਾਰ੍ਸ਼਼ੀਤ੍ ਤਤ੍ਕਾਰਣਾਦ੍ ਅਬਿਭੇਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","ਯਿਹੂਦੀਯਲੋਕਾਃ ਪੌਲੰ ਕੁਤੋ(ਅ)ਪਵਦਨ੍ਤੇ ਤਸ੍ਯ ਵ੍ਰੁʼੱਤਾਨ੍ਤੰ ਜ੍ਞਾਤੁੰ ਵਾਞ੍ਛਨ੍ ਸਹਸ੍ਰਸੇਨਾਪਤਿਃ ਪਰੇ(ਅ)ਹਨਿ ਪੌਲੰ ਬਨ੍ਧਨਾਤ੍ ਮੋਚਯਿਤ੍ਵਾ ਪ੍ਰਧਾਨਯਾਜਕਾਨ੍ ਮਹਾਸਭਾਯਾਃ ਸਰ੍ੱਵਲੋਕਾਸ਼੍ਚ ਸਮੁਪਸ੍ਥਾਤੁਮ੍ ਆਦਿਸ਼੍ਯ ਤੇਸ਼਼ਾਂ ਸੰਨਿਧੌ ਪੌਲਮ੍ ਅਵਰੋਹ੍ਯ ਸ੍ਥਾਪਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","ਸਭਾਸਦ੍ਲੋਕਾਨ੍ ਪ੍ਰਤਿ ਪੌਲੋ(ਅ)ਨਨ੍ਯਦ੍ਰੁʼਸ਼਼੍ਟ੍ਯਾ ਪਸ਼੍ਯਨ੍ ਅਕਥਯਤ੍, ਹੇ ਭ੍ਰਾਤ੍ਰੁʼਗਣਾ ਅਦ੍ਯ ਯਾਵਤ੍ ਸਰਲੇਨ ਸਰ੍ੱਵਾਨ੍ਤਃਕਰਣੇਨੇਸ਼੍ਵਰਸ੍ਯ ਸਾਕ੍ਸ਼਼ਾਦ੍ ਆਚਰਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","ਅਨੇਨ ਹਨਾਨੀਯਨਾਮਾ ਮਹਾਯਾਜਕਸ੍ਤੰ ਕਪੋਲੇ ਚਪੇਟੇਨਾਹਨ੍ਤੁੰ ਸਮੀਪਸ੍ਥਲੋਕਾਨ੍ ਆਦਿਸ਼਼੍ਟਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","ਤਦਾ ਪੌਲਸ੍ਤਮਵਦਤ੍, ਹੇ ਬਹਿਸ਼਼੍ਪਰਿਸ਼਼੍ਕ੍ਰੁʼਤ, ਈਸ਼੍ਵਰਸ੍ਤ੍ਵਾਂ ਪ੍ਰਹਰ੍ੱਤੁਮ੍ ਉਦ੍ਯਤੋਸ੍ਤਿ, ਯਤੋ ਵ੍ਯਵਸ੍ਥਾਨੁਸਾਰੇਣ ਵਿਚਾਰਯਿਤੁਮ੍ ਉਪਵਿਸ਼੍ਯ ਵ੍ਯਵਸ੍ਥਾਂ ਲਙ੍ਘਿਤ੍ਵਾ ਮਾਂ ਪ੍ਰਹਰ੍ੱਤੁਮ੍ ਆਜ੍ਞਾਪਯਸਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","ਤਤੋ ਨਿਕਟਸ੍ਥਾ ਲੋਕਾ ਅਕਥਯਨ੍, ਤ੍ਵੰ ਕਿਮ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਮਹਾਯਾਜਕੰ ਨਿਨ੍ਦਸਿ? ");
INSERT INTO sanpun_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","ਤਤਃ ਪੌਲਃ ਪ੍ਰਤਿਭਾਸ਼਼ਿਤਵਾਨ੍ ਹੇ ਭ੍ਰਾਤ੍ਰੁʼਗਣ ਮਹਾਯਾਜਕ ਏਸ਼਼ ਇਤਿ ਨ ਬੁੱਧੰ ਮਯਾ ਤਦਨ੍ਯੱਚ ਸ੍ਵਲੋਕਾਨਾਮ੍ ਅਧਿਪਤਿੰ ਪ੍ਰਤਿ ਦੁਰ੍ੱਵਾਕ੍ਯੰ ਮਾ ਕਥਯ, ਏਤਾਦ੍ਰੁʼਸ਼ੀ ਲਿਪਿਰਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","ਅਨਨ੍ਤਰੰ ਪੌਲਸ੍ਤੇਸ਼਼ਾਮ੍ ਅਰ੍ੱਧੰ ਸਿਦੂਕਿਲੋਕਾ ਅਰ੍ੱਧੰ ਫਿਰੂਸ਼ਿਲੋਕਾ ਇਤਿ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਪ੍ਰੋੱਚੈਃ ਸਭਾਸ੍ਥਲੋਕਾਨ੍ ਅਵਦਤ੍ ਹੇ ਭ੍ਰਾਤ੍ਰੁʼਗਣ ਅਹੰ ਫਿਰੂਸ਼ਿਮਤਾਵਲਮ੍ਬੀ ਫਿਰੂਸ਼ਿਨਃ ਸਤ੍ਨਾਨਸ਼੍ਚ, ਮ੍ਰੁʼਤਲੋਕਾਨਾਮ੍ ਉੱਥਾਨੇ ਪ੍ਰਤ੍ਯਾਸ਼ਾਕਰਣਾਦ੍ ਅਹਮਪਵਾਦਿਤੋਸ੍ਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ਇਤਿ ਕਥਾਯਾਂ ਕਥਿਤਾਯਾਂ ਫਿਰੂਸ਼ਿਸਿਦੂਕਿਨੋਃ ਪਰਸ੍ਪਰੰ ਭਿੰਨਵਾਕ੍ਯਤ੍ਵਾਤ੍ ਸਭਾਯਾ ਮਧ੍ਯੇ ਦ੍ਵੌ ਸੰਘੌ ਜਾਤੌ| ");
INSERT INTO sanpun_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","ਯਤਃ ਸਿਦੂਕਿਲੋਕਾ ਉੱਥਾਨੰ ਸ੍ਵਰ੍ਗੀਯਦੂਤਾ ਆਤ੍ਮਾਨਸ਼੍ਚ ਸਰ੍ੱਵੇਸ਼਼ਾਮ੍ ਏਤੇਸ਼਼ਾਂ ਕਮਪਿ ਨ ਮਨ੍ਯਨ੍ਤੇ, ਕਿਨ੍ਤੁ ਫਿਰੂਸ਼ਿਨਃ ਸਰ੍ੱਵਮ੍ ਅਙ੍ਗੀਕੁਰ੍ੱਵਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","ਤਤਃ ਪਰਸ੍ਪਰਮ੍ ਅਤਿਸ਼ਯਕੋਲਾਹਲੇ ਸਮੁਪਸ੍ਥਿਤੇ ਫਿਰੂਸ਼ਿਨਾਂ ਪਕ੍ਸ਼਼ੀਯਾਃ ਸਭਾਸ੍ਥਾ ਅਧ੍ਯਾਪਕਾਃ ਪ੍ਰਤਿਪਕ੍ਸ਼਼ਾ ਉੱਤਿਸ਼਼੍ਠਨ੍ਤੋ (ਅ)ਕਥਯਨ੍, ਏਤਸ੍ਯ ਮਾਨਵਸ੍ਯ ਕਮਪਿ ਦੋਸ਼਼ੰ ਨ ਪਸ਼੍ਯਾਮਃ; ਯਦਿ ਕਸ਼੍ਚਿਦ੍ ਆਤ੍ਮਾ ਵਾ ਕਸ਼੍ਚਿਦ੍ ਦੂਤ ਏਨੰ ਪ੍ਰਤ੍ਯਾਦਿਸ਼ਤ੍ ਤਰ੍ਹਿ ਵਯਮ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਪ੍ਰਾਤਿਕੂਲ੍ਯੇਨ ਨ ਯੋਤ੍ਸ੍ਯਾਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","ਤਸ੍ਮਾਦ੍ ਅਤੀਵ ਭਿੰਨਵਾਕ੍ਯਤ੍ਵੇ ਸਤਿ ਤੇ ਪੌਲੰ ਖਣ੍ਡੰ ਖਣ੍ਡੰ ਕਰਿਸ਼਼੍ਯਨ੍ਤੀਤ੍ਯਾਸ਼ਙ੍ਕਯਾ ਸਹਸ੍ਰਸੇਨਾਪਤਿਃ ਸੇਨਾਗਣੰ ਤਤ੍ਸ੍ਥਾਨੰ ਯਾਤੁੰ ਸਭਾਤੋ ਬਲਾਤ੍ ਪੌਲੰ ਧ੍ਰੁʼਤ੍ਵਾ ਦੁਰ੍ਗੰ ਨੇਤਞ੍ਚਾਜ੍ਞਾਪਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","ਰਾਤ੍ਰੋ ਪ੍ਰਭੁਸ੍ਤਸ੍ਯ ਸਮੀਪੇ ਤਿਸ਼਼੍ਠਨ੍ ਕਥਿਤਵਾਨ੍ ਹੇ ਪੌਲ ਨਿਰ੍ਭਯੋ ਭਵ ਯਥਾ ਯਿਰੂਸ਼ਾਲਮ੍ਨਗਰੇ ਮਯਿ ਸਾਕ੍ਸ਼਼੍ਯੰ ਦੱਤਵਾਨ੍ ਤਥਾ ਰੋਮਾਨਗਰੇਪਿ ਤ੍ਵਯਾ ਦਾਤਵ੍ਯਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","ਦਿਨੇ ਸਮੁਪਸ੍ਥਿਤੇ ਸਤਿ ਕਿਯਨ੍ਤੋ ਯਿਹੂਦੀਯਲੋਕਾ ਏਕਮਨ੍ਤ੍ਰਣਾਃ ਸਨ੍ਤਃ ਪੌਲੰ ਨ ਹਤ੍ਵਾ ਭੋਜਨਪਾਨੇ ਕਰਿਸ਼਼੍ਯਾਮ ਇਤਿ ਸ਼ਪਥੇਨ ਸ੍ਵਾਨ੍ ਅਬਧ੍ਨਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","ਚਤ੍ਵਾਰਿੰਸ਼ੱਜਨੇਭ੍ਯੋ(ਅ)ਧਿਕਾ ਲੋਕਾ ਇਤਿ ਪਣਮ੍ ਅਕੁਰ੍ੱਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","ਤੇ ਮਹਾਯਾਜਕਾਨਾਂ ਪ੍ਰਾਚੀਨਲੋਕਾਨਾਞ੍ਚ ਸਮੀਪੰ ਗਤ੍ਵਾ ਕਥਯਨ੍, ਵਯੰ ਪੌਲੰ ਨ ਹਤ੍ਵਾ ਕਿਮਪਿ ਨ ਭੋਕ੍ਸ਼਼੍ਯਾਮਹੇ ਦ੍ਰੁʼਢੇਨਾਨੇਨ ਸ਼ਪਥੇਨ ਬੱਧ੍ਵਾ ਅਭਵਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","ਅਤਏਵ ਸਾਮ੍ਪ੍ਰਤੰ ਸਭਾਸਦ੍ਲੋਕੈਃ ਸਹ ਵਯੰ ਤਸ੍ਮਿਨ੍ ਕਞ੍ਚਿਦ੍ ਵਿਸ਼ੇਸ਼਼ਵਿਚਾਰੰ ਕਰਿਸ਼਼੍ਯਾਮਸ੍ਤਦਰ੍ਥੰ ਭਵਾਨ੍ ਸ਼੍ਵੋ (ਅ)ਸ੍ਮਾਕੰ ਸਮੀਪੰ ਤਮ੍ ਆਨਯਤ੍ਵਿਤਿ ਸਹਸ੍ਰਸੇਨਾਪਤਯੇ ਨਿਵੇਦਨੰ ਕੁਰੁਤ ਤੇਨ ਯੁਸ਼਼੍ਮਾਕੰ ਸਮੀਪੰ ਉਪਸ੍ਥਿਤੇਃ ਪੂਰ੍ੱਵੰ ਵਯੰ ਤੰ ਹਨ੍ਤੁ ਸੱਜਿਸ਼਼੍ਯਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","ਤਦਾ ਪੌਲਸ੍ਯ ਭਾਗਿਨੇਯਸ੍ਤੇਸ਼਼ਾਮਿਤਿ ਮਨ੍ਤ੍ਰਣਾਂ ਵਿਜ੍ਞਾਯ ਦੁਰ੍ਗੰ ਗਤ੍ਵਾ ਤਾਂ ਵਾਰ੍ੱਤਾਂ ਪੌਲਮ੍ ਉਕ੍ਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","ਤਸ੍ਮਾਤ੍ ਪੌਲ ਏਕੰ ਸ਼ਤਸੇਨਾਪਤਿਮ੍ ਆਹੂਯ ਵਾਕ੍ਯਮਿਦਮ੍ ਭਾਸ਼਼ਿਤਵਾਨ੍ ਸਹਸ੍ਰਸੇਨਾਪਤੇਃ ਸਮੀਪੇ(ਅ)ਸ੍ਯ ਯੁਵਮਨੁਸ਼਼੍ਯਸ੍ਯ ਕਿਞ੍ਚਿੰਨਿਵੇਦਨਮ੍ ਆਸ੍ਤੇ, ਤਸ੍ਮਾਤ੍ ਤਤ੍ਸਵਿਧਮ੍ ਏਨੰ ਨਯ| ");
INSERT INTO sanpun_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","ਤਤਃ ਸ ਤਮਾਦਾਯ ਸਹਸ੍ਰਸੇਨਾਪਤੇਃ ਸਮੀਪਮ੍ ਉਪਸ੍ਥਾਯ ਕਥਿਤਵਾਨ੍, ਭਵਤਃ ਸਮੀਪੇ(ਅ)ਸ੍ਯ ਕਿਮਪਿ ਨਿਵੇਦਨਮਾਸ੍ਤੇ ਤਸ੍ਮਾਤ੍ ਬਨ੍ਦਿਃ ਪੌਲੋ ਮਾਮਾਹੂਯ ਭਵਤਃ ਸਮੀਪਮ੍ ਏਨਮ੍ ਆਨੇਤੁੰ ਪ੍ਰਾਰ੍ਥਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","ਤਦਾ ਸਹਸ੍ਰਸੇਨਾਪਤਿਸ੍ਤਸ੍ਯ ਹਸ੍ਤੰ ਧ੍ਰੁʼਤ੍ਵਾ ਨਿਰ੍ਜਨਸ੍ਥਾਨੰ ਨੀਤ੍ਵਾ ਪ੍ਰੁʼਸ਼਼੍ਠਵਾਨ੍ ਤਵ ਕਿੰ ਨਿਵੇਦਨੰ? ਤਤ੍ ਕਥਯ| ");
INSERT INTO sanpun_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","ਤਤਃ ਸੋਕਥਯਤ੍, ਯਿਹੂਦੀਯਲਾਕਾਃ ਪੌਲੇ ਕਮਪਿ ਵਿਸ਼ੇਸ਼਼ਵਿਚਾਰੰ ਛਲੰ ਕ੍ਰੁʼਤ੍ਵਾ ਤੰ ਸਭਾਂ ਨੇਤੁੰ ਭਵਤਃ ਸਮੀਪੇ ਨਿਵੇਦਯਿਤੁੰ ਅਮਨ੍ਤ੍ਰਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","ਕਿਨ੍ਤੁ ਮਵਤਾ ਤੰਨ ਸ੍ਵੀਕਰ੍ੱਤਵ੍ਯੰ ਯਤਸ੍ਤੇਸ਼਼ਾਂ ਮਧ੍ਯੇਵਰ੍ੱਤਿਨਸ਼੍ਚਤ੍ਵਾਰਿੰਸ਼ੱਜਨੇਭ੍ਯੋ (ਅ)ਧਿਕਲੋਕਾ ਏਕਮਨ੍ਤ੍ਰਣਾ ਭੂਤ੍ਵਾ ਪੌਲੰ ਨ ਹਤ੍ਵਾ ਭੋਜਨੰ ਪਾਨਞ੍ਚ ਨ ਕਰਿਸ਼਼੍ਯਾਮ ਇਤਿ ਸ਼ਪਥੇਨ ਬੱਧਾਃ ਸਨ੍ਤੋ ਘਾਤਕਾ ਇਵ ਸੱਜਿਤਾ ਇਦਾਨੀਂ ਕੇਵਲੰ ਭਵਤੋ (ਅ)ਨੁਮਤਿਮ੍ ਅਪੇਕ੍ਸ਼਼ਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","ਯਾਮਿਮਾਂ ਕਥਾਂ ਤ੍ਵੰ ਨਿਵੇਦਿਤਵਾਨ੍ ਤਾਂ ਕਸ੍ਮੈਚਿਦਪਿ ਮਾ ਕਥਯੇਤ੍ਯੁਕ੍ਤ੍ਵਾ ਸਹਸ੍ਰਸੇਨਾਪਤਿਸ੍ਤੰ ਯੁਵਾਨੰ ਵਿਸ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","ਅਨਨ੍ਤਰੰ ਸਹਸ੍ਰਸੇਨਾਪਤਿ ਰ੍ਦ੍ਵੌ ਸ਼ਤਸੇਨਾਪਤੀ ਆਹੂਯੇਦਮ੍ ਆਦਿਸ਼ਤ੍, ਯੁਵਾਂ ਰਾਤ੍ਰੌ ਪ੍ਰਹਰੈਕਾਵਸ਼ਿਸ਼਼੍ਟਾਯਾਂ ਸਤ੍ਯਾਂ ਕੈਸਰਿਯਾਨਗਰੰ ਯਾਤੁੰ ਪਦਾਤਿਸੈਨ੍ਯਾਨਾਂ ਦ੍ਵੇ ਸ਼ਤੇ ਘੋਟਕਾਰੋਹਿਸੈਨ੍ਯਾਨਾਂ ਸਪ੍ਤਤਿੰ ਸ਼ਕ੍ਤਿਧਾਰਿਸੈਨ੍ਯਾਨਾਂ ਦ੍ਵੇ ਸ਼ਤੇ ਚ ਜਨਾਨ੍ ਸੱਜਿਤਾਨ੍ ਕੁਰੁਤੰ| ");
INSERT INTO sanpun_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","ਪੌਲਮ੍ ਆਰੋਹਯਿਤੁੰ ਫੀਲਿਕ੍ਸ਼਼ਾਧਿਪਤੇਃ ਸਮੀਪੰ ਨਿਰ੍ੱਵਿਘ੍ਨੰ ਨੇਤੁਞ੍ਚ ਵਾਹਨਾਨਿ ਸਮੁਪਸ੍ਥਾਪਯਤੰ| ");
INSERT INTO sanpun_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","ਅਪਰੰ ਸ ਪਤ੍ਰੰ ਲਿਖਿਤ੍ਵਾ ਦੱਤਵਾਨ੍ ਤੱਲਿਖਿਤਮੇਤਤ੍, ");
INSERT INTO sanpun_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","ਮਹਾਮਹਿਮਸ਼੍ਰੀਯੁਕ੍ਤਫੀਲਿਕ੍ਸ਼਼ਾਧਿਪਤਯੇ ਕ੍ਲੌਦਿਯਲੁਸ਼਼ਿਯਸ੍ਯ ਨਮਸ੍ਕਾਰਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","ਯਿਹੂਦੀਯਲੋਕਾਃ ਪੂਰ੍ੱਵਮ੍ ਏਨੰ ਮਾਨਵੰ ਧ੍ਰੁʼਤ੍ਵਾ ਸ੍ਵਹਸ੍ਤੈ ਰ੍ਹਨ੍ਤੁਮ੍ ਉਦ੍ਯਤਾ ਏਤਸ੍ਮਿੰਨਨ੍ਤਰੇ ਸਸੈਨ੍ਯੋਹੰ ਤਤ੍ਰੋਪਸ੍ਥਾਯ ਏਸ਼਼ ਜਨੋ ਰੋਮੀਯ ਇਤਿ ਵਿਜ੍ਞਾਯ ਤੰ ਰਕ੍ਸ਼਼ਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","ਕਿੰਨਿਮਿੱਤੰ ਤੇ ਤਮਪਵਦਨ੍ਤੇ ਤੱਜ੍ਞਾਤੁੰ ਤੇਸ਼਼ਾ ਸਭਾਂ ਤਮਾਨਾਯਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","ਤਤਸ੍ਤੇਸ਼਼ਾਂ ਵ੍ਯਵਸ੍ਥਾਯਾ ਵਿਰੁੱਧਯਾ ਕਯਾਚਨ ਕਥਯਾ ਸੋ(ਅ)ਪਵਾਦਿਤੋ(ਅ)ਭਵਤ੍, ਕਿਨ੍ਤੁ ਸ ਸ਼੍ਰੁʼਙ੍ਖਲਬਨ੍ਧਨਾਰ੍ਹੋ ਵਾ ਪ੍ਰਾਣਨਾਸ਼ਾਰ੍ਹੋ ਭਵਤੀਦ੍ਰੁʼਸ਼ਃ ਕੋਪ੍ਯਪਰਾਧੋ ਮਯਾਸ੍ਯ ਨ ਦ੍ਰੁʼਸ਼਼੍ਟਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","ਤਥਾਪਿ ਮਨੁਸ਼਼੍ਯਸ੍ਯਾਸ੍ਯ ਵਧਾਰ੍ਥੰ ਯਿਹੂਦੀਯਾ ਘਾਤਕਾਇਵ ਸੱਜਿਤਾ ਏਤਾਂ ਵਾਰ੍ੱਤਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਤਤ੍ਕ੍ਸ਼਼ਣਾਤ੍ ਤਵ ਸਮੀਪਮੇਨੰ ਪ੍ਰੇਸ਼਼ਿਤਵਾਨ੍ ਅਸ੍ਯਾਪਵਾਦਕਾਂਸ਼੍ਚ ਤਵ ਸਮੀਪੰ ਗਤ੍ਵਾਪਵਦਿਤੁਮ੍ ਆਜ੍ਞਾਪਯਮ੍| ਭਵਤਃ ਕੁਸ਼ਲੰ ਭੂਯਾਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","ਸੈਨ੍ਯਗਣ ਆਜ੍ਞਾਨੁਸਾਰੇਣ ਪੌਲੰ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ਤਸ੍ਯਾਂ ਰਜਨ੍ਯਾਮ੍ ਆਨ੍ਤਿਪਾਤ੍ਰਿਨਗਰਮ੍ ਆਨਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","ਪਰੇ(ਅ)ਹਨਿ ਤੇਨ ਸਹ ਯਾਤੁੰ ਘੋਟਕਾਰੂਢਸੈਨ੍ਯਗਣੰ ਸ੍ਥਾਪਯਿਤ੍ਵਾ ਪਰਾਵ੍ਰੁʼਤ੍ਯ ਦੁਰ੍ਗੰ ਗਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","ਤਤਃ ਪਰੇ ਘੋਟਕਾਰੋਹਿਸੈਨ੍ਯਗਣਃ ਕੈਸਰਿਯਾਨਗਰਮ੍ ਉਪਸ੍ਥਾਯ ਤਤ੍ਪਤ੍ਰਮ੍ ਅਧਿਪਤੇਃ ਕਰੇ ਸਮਰ੍ਪ੍ਯ ਤਸ੍ਯ ਸਮੀਪੇ ਪੌਲਮ੍ ਉਪਸ੍ਥਾਪਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","ਤਦਾਧਿਪਤਿਸ੍ਤਤ੍ਪਤ੍ਰੰ ਪਠਿਤ੍ਵਾ ਪ੍ਰੁʼਸ਼਼੍ਠਵਾਨ੍ ਏਸ਼਼ ਕਿਮ੍ਪ੍ਰਦੇਸ਼ੀਯੋ ਜਨਃ? ਸ ਕਿਲਿਕਿਯਾਪ੍ਰਦੇਸ਼ੀਯ ਏਕੋ ਜਨ ਇਤਿ ਜ੍ਞਾਤ੍ਵਾ ਕਥਿਤਵਾਨ੍, ");
INSERT INTO sanpun_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ਤਵਾਪਵਾਦਕਗਣ ਆਗਤੇ ਤਵ ਕਥਾਂ ਸ਼੍ਰੋਸ਼਼੍ਯਾਮਿ| ਹੇਰੋਦ੍ਰਾਜਗ੍ਰੁʼਹੇ ਤੰ ਸ੍ਥਾਪਯਿਤੁਮ੍ ਆਦਿਸ਼਼੍ਟਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","ਪਞ੍ਚਭ੍ਯੋ ਦਿਨੇਭ੍ਯਃ ਪਰੰ ਹਨਾਨੀਯਨਾਮਾ ਮਹਾਯਾਜਕੋ(ਅ)ਧਿਪਤੇਃ ਸਮਕ੍ਸ਼਼ੰ ਪੌਲਸ੍ਯ ਪ੍ਰਾਤਿਕੂਲ੍ਯੇਨ ਨਿਵੇਦਯਿਤੁੰ ਤਰ੍ਤੁੱਲਨਾਮਾਨੰ ਕਞ੍ਚਨ ਵਕ੍ਤਾਰੰ ਪ੍ਰਾਚੀਨਜਨਾਂਸ਼੍ਚ ਸਙ੍ਗਿਨਃ ਕ੍ਰੁʼਤ੍ਵਾ ਕੈਸਰਿਯਾਨਗਰਮ੍ ਆਗੱਛਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","ਤਤਃ ਪੌਲੇ ਸਮਾਨੀਤੇ ਸਤਿ ਤਰ੍ਤੁੱਲਸ੍ਤਸ੍ਯਾਪਵਾਦਕਥਾਂ ਕਥਯਿਤੁਮ੍ ਆਰਭਤ ਹੇ ਮਹਾਮਹਿਮਫੀਲਿਕ੍ਸ਼਼ ਭਵਤੋ ਵਯਮ੍ ਅਤਿਨਿਰ੍ੱਵਿਘ੍ਨੰ ਕਾਲੰ ਯਾਪਯਾਮੋ ਭਵਤਃ ਪਰਿਣਾਮਦਰ੍ਸ਼ਿਤਯਾ ਏਤੱਦੇਸ਼ੀਯਾਨਾਂ ਬਹੂਨਿ ਮਙ੍ਗਲਾਨਿ ਘਟਿਤਾਨਿ, ");
INSERT INTO sanpun_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","ਇਤਿ ਹੇਤੋ ਰ੍ਵਯਮਤਿਕ੍ਰੁʼਤਜ੍ਞਾਃ ਸਨ੍ਤਃ ਸਰ੍ੱਵਤ੍ਰ ਸਰ੍ੱਵਦਾ ਭਵਤੋ ਗੁਣਾਨ੍ ਗਾਯਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","ਕਿਨ੍ਤੁ ਬਹੁਭਿਃ ਕਥਾਭਿ ਰ੍ਭਵਨ੍ਤੰ ਯੇਨ ਨ ਵਿਰਞ੍ਜਯਾਮਿ ਤਸ੍ਮਾਦ੍ ਵਿਨਯੇ ਭਵਾਨ੍ ਬਨੁਕਮ੍ਪ੍ਯ ਮਦਲ੍ਪਕਥਾਂ ਸ਼੍ਰੁʼਣੋਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","ਏਸ਼਼ ਮਹਾਮਾਰੀਸ੍ਵਰੂਪੋ ਨਾਸਰਤੀਯਮਤਗ੍ਰਾਹਿਸੰਘਾਤਸ੍ਯ ਮੁਖ੍ਯੋ ਭੂਤ੍ਵਾ ਸਰ੍ੱਵਦੇਸ਼ੇਸ਼਼ੁ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਯਿਹੂਦੀਯਾਨਾਂ ਰਾਜਦ੍ਰੋਹਾਚਰਣਪ੍ਰਵ੍ਰੁʼੱਤਿੰ ਜਨਯਤੀਤ੍ਯਸ੍ਮਾਭਿ ਰ੍ਨਿਸ਼੍ਚਿਤੰ| ");
INSERT INTO sanpun_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","ਸ ਮਨ੍ਦਿਰਮਪਿ ਅਸ਼ੁਚਿ ਕਰ੍ੱਤੁੰ ਚੇਸ਼਼੍ਟਿਤਵਾਨ੍; ਇਤਿ ਕਾਰਣਾਦ੍ ਵਯਮ੍ ਏਨੰ ਧ੍ਰੁʼਤ੍ਵਾ ਸ੍ਵਵ੍ਯਵਸ੍ਥਾਨੁਸਾਰੇਣ ਵਿਚਾਰਯਿਤੁੰ ਪ੍ਰਾਵਰ੍ੱਤਾਮਹਿ; ");
INSERT INTO sanpun_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","ਕਿਨ੍ਤੁ ਲੁਸ਼਼ਿਯਃ ਸਹਸ੍ਰਸੇਨਾਪਤਿਰਾਗਤ੍ਯ ਬਲਾਦ੍ ਅਸ੍ਮਾਕੰ ਕਰੇਭ੍ਯ ਏਨੰ ਗ੍ਰੁʼਹੀਤ੍ਵਾ ");
INSERT INTO sanpun_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ਏਤਸ੍ਯਾਪਵਾਦਕਾਨ੍ ਭਵਤਃ ਸਮੀਪਮ੍ ਆਗਨ੍ਤੁਮ੍ ਆਜ੍ਞਾਪਯਤ੍| ਵਯੰ ਯਸ੍ਮਿਨ੍ ਤਮਪਵਾਦਾਮੋ ਭਵਤਾ ਪਦਪਵਾਦਕਥਾਯਾਂ ਵਿਚਾਰਿਤਾਯਾਂ ਸਤ੍ਯਾਂ ਸਰ੍ੱਵੰ ਵ੍ਰੁʼੱਤਾਨ੍ਤੰ ਵੇਦਿਤੁੰ ਸ਼ਕ੍ਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","ਤਤੋ ਯਿਹੂਦੀਯਾ ਅਪਿ ਸ੍ਵੀਕ੍ਰੁʼਤ੍ਯ ਕਥਿਤਵਨ੍ਤ ਏਸ਼਼ਾ ਕਥਾ ਪ੍ਰਮਾਣਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","ਅਧਿਪਤੌ ਕਥਾਂ ਕਥਯਿਤੁੰ ਪੌਲੰ ਪ੍ਰਤੀਙ੍ਗਿਤੰ ਕ੍ਰੁʼਤਵਤਿ ਸ ਕਥਿਤਵਾਨ੍ ਭਵਾਨ੍ ਬਹੂਨ੍ ਵਤ੍ਸਰਾਨ੍ ਯਾਵਦ੍ ਏਤੱਦੇਸ਼ਸ੍ਯ ਸ਼ਾਸਨੰ ਕਰੋਤੀਤਿ ਵਿਜ੍ਞਾਯ ਪ੍ਰਤ੍ਯੁੱਤਰੰ ਦਾਤੁਮ੍ ਅਕ੍ਸ਼਼ੋਭੋ(ਅ)ਭਵਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","ਅਦ੍ਯ ਕੇਵਲੰ ਦ੍ਵਾਦਸ਼ ਦਿਨਾਨਿ ਯਾਤਾਨਿ, ਅਹਮ੍ ਆਰਾਧਨਾਂ ਕਰ੍ੱਤੁੰ ਯਿਰੂਸ਼ਾਲਮਨਗਰੰ ਗਤਵਾਨ੍ ਏਸ਼਼ਾ ਕਥਾ ਭਵਤਾ ਜ੍ਞਾਤੁੰ ਸ਼ਕ੍ਯਤੇ; ");
INSERT INTO sanpun_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","ਕਿਨ੍ਤ੍ਵਿਭੇ ਮਾਂ ਮਧ੍ਯੇਮਨ੍ਦਿਰੰ ਕੇਨਾਪਿ ਸਹ ਵਿਤਣ੍ਡਾਂ ਕੁਰ੍ੱਵਨ੍ਤੰ ਕੁਤ੍ਰਾਪਿ ਭਜਨਭਵਨੇ ਨਗਰੇ ਵਾ ਲੋਕਾਨ੍ ਕੁਪ੍ਰਵ੍ਰੁʼੱਤਿੰ ਜਨਯਨ੍ਤੁੰ ਨ ਦ੍ਰੁʼਸ਼਼੍ਟਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","ਇਦਾਨੀਂ ਯਸ੍ਮਿਨ੍ ਯਸ੍ਮਿਨ੍ ਮਾਮ੍ ਅਪਵਦਨ੍ਤੇ ਤਸ੍ਯ ਕਿਮਪਿ ਪ੍ਰਮਾਣੰ ਦਾਤੁੰ ਨ ਸ਼ਕ੍ਨੁਵਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","ਕਿਨ੍ਤੁ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਕ੍ਯਗ੍ਰਨ੍ਥੇ ਵ੍ਯਵਸ੍ਥਾਗ੍ਰਨ੍ਥੇ ਚ ਯਾ ਯਾ ਕਥਾ ਲਿਖਿਤਾਸ੍ਤੇ ਤਾਸੁ ਸਰ੍ੱਵਾਸੁ ਵਿਸ਼੍ਵਸ੍ਯ ਯਨ੍ਮਤਮ੍ ਇਮੇ ਵਿਧਰ੍ੰਮੰ ਜਾਨਨ੍ਤਿ ਤਨ੍ਮਤਾਨੁਸਾਰੇਣਾਹੰ ਨਿਜਪਿਤ੍ਰੁʼਪੁਰੁਸ਼਼ਾਣਾਮ੍ ਈਸ਼੍ਵਰਮ੍ ਆਰਾਧਯਾਮੀਤ੍ਯਹੰ ਭਵਤਃ ਸਮਕ੍ਸ਼਼ਮ੍ ਅਙ੍ਗੀਕਰੋਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","ਧਾਰ੍ੰਮਿਕਾਣਾਮ੍ ਅਧਾਰ੍ੰਮਿਕਾਣਾਞ੍ਚ ਪ੍ਰਮੀਤਲੋਕਾਨਾਮੇਵੋੱਥਾਨੰ ਭਵਿਸ਼਼੍ਯਤੀਤਿ ਕਥਾਮਿਮੇ ਸ੍ਵੀਕੁਰ੍ੱਵਨ੍ਤਿ ਤਥਾਹਮਪਿ ਤਸ੍ਮਿਨ੍ ਈਸ਼੍ਵਰੇ ਪ੍ਰਤ੍ਯਾਸ਼ਾਂ ਕਰੋਮਿ; ");
INSERT INTO sanpun_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","ਈਸ਼੍ਵਰਸ੍ਯ ਮਾਨਵਾਨਾਞ੍ਚ ਸਮੀਪੇ ਯਥਾ ਨਿਰ੍ਦੋਸ਼਼ੋ ਭਵਾਮਿ ਤਦਰ੍ਥੰ ਸਤਤੰ ਯਤ੍ਨਵਾਨ੍ ਅਸ੍ਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","ਬਹੁਸ਼਼ੁ ਵਤ੍ਸਰੇਸ਼਼ੁ ਗਤੇਸ਼਼ੁ ਸ੍ਵਦੇਸ਼ੀਯਲੋਕਾਨਾਂ ਨਿਮਿੱਤੰ ਦਾਨੀਯਦ੍ਰਵ੍ਯਾਣਿ ਨੈਵੇਦ੍ਯਾਨਿ ਚ ਸਮਾਦਾਯ ਪੁਨਰਾਗਮਨੰ ਕ੍ਰੁʼਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","ਤਤੋਹੰ ਸ਼ੁਚਿ ਰ੍ਭੂਤ੍ਵਾ ਲੋਕਾਨਾਂ ਸਮਾਗਮੰ ਕਲਹੰ ਵਾ ਨ ਕਾਰਿਤਵਾਨ੍ ਤਥਾਪ੍ਯਾਸ਼ਿਯਾਦੇਸ਼ੀਯਾਃ ਕਿਯਨ੍ਤੋ ਯਿਹੁਦੀਯਲੋਕਾ ਮਧ੍ਯੇਮਨ੍ਦਿਰੰ ਮਾਂ ਧ੍ਰੁʼਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","ਮਮੋਪਰਿ ਯਦਿ ਕਾਚਿਦਪਵਾਦਕਥਾਸ੍ਤਿ ਤਰ੍ਹਿ ਭਵਤਃ ਸਮੀਪਮ੍ ਉਪਸ੍ਥਾਯ ਤੇਸ਼਼ਾਮੇਵ ਸਾਕ੍ਸ਼਼੍ਯਦਾਨਮ੍ ਉਚਿਤਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","ਨੋਚੇਤ੍ ਪੂਰ੍ੱਵੇ ਮਹਾਸਭਾਸ੍ਥਾਨਾਂ ਲੋਕਾਨਾਂ ਸੰਨਿਧੌ ਮਮ ਦਣ੍ਡਾਯਮਾਨਤ੍ਵਸਮਯੇ, ਅਹਮਦ੍ਯ ਮ੍ਰੁʼਤਾਨਾਮੁੱਥਾਨੇ ਯੁਸ਼਼੍ਮਾਭਿ ਰ੍ਵਿਚਾਰਿਤੋਸ੍ਮਿ, ");
INSERT INTO sanpun_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","ਤੇਸ਼਼ਾਂ ਮਧ੍ਯੇ ਤਿਸ਼਼੍ਠੰਨਹੰ ਯਾਮਿਮਾਂ ਕਥਾਮੁੱਚੈਃ ਸ੍ਵਰੇਣ ਕਥਿਤਵਾਨ੍ ਤਦਨ੍ਯੋ ਮਮ ਕੋਪਿ ਦੋਸ਼਼ੋ(ਅ)ਲਭ੍ਯਤ ਨ ਵੇਤਿ ਵਰਮ੍ ਏਤੇ ਸਮੁਪਸ੍ਥਿਤਲੋਕਾ ਵਦਨ੍ਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","ਤਦਾ ਫੀਲਿਕ੍ਸ਼਼ ਏਤਾਂ ਕਥਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਤਨ੍ਮਤਸ੍ਯ ਵਿਸ਼ੇਸ਼਼ਵ੍ਰੁʼੱਤਾਨ੍ਤੰ ਵਿਜ੍ਞਾਤੁੰ ਵਿਚਾਰੰ ਸ੍ਥਗਿਤੰ ਕ੍ਰੁʼਤ੍ਵਾ ਕਥਿਤਵਾਨ੍ ਲੁਸ਼਼ਿਯੇ ਸਹਸ੍ਰਸੇਨਾਪਤੌ ਸਮਾਯਾਤੇ ਸਤਿ ਯੁਸ਼਼੍ਮਾਕੰ ਵਿਚਾਰਮ੍ ਅਹੰ ਨਿਸ਼਼੍ਪਾਦਯਿਸ਼਼੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","ਅਨਨ੍ਤਰੰ ਬਨ੍ਧਨੰ ਵਿਨਾ ਪੌਲੰ ਰਕ੍ਸ਼਼ਿਤੁੰ ਤਸ੍ਯ ਸੇਵਨਾਯ ਸਾਕ੍ਸ਼਼ਾਤ੍ਕਰਣਾਯ ਵਾ ਤਦੀਯਾਤ੍ਮੀਯਬਨ੍ਧੁਜਨਾਨ੍ ਨ ਵਾਰਯਿਤੁਞ੍ਚ ਸ਼ਮਸੇਨਾਪਤਿਮ੍ ਆਦਿਸ਼਼੍ਟਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","ਅਲ੍ਪਦਿਨਾਤ੍ ਪਰੰ ਫੀਲਿਕ੍ਸ਼਼ੋ(ਅ)ਧਿਪਤਿ ਰ੍ਦ੍ਰੁਸ਼਼ਿੱਲਾਨਾਮ੍ਨਾ ਯਿਹੂਦੀਯਯਾ ਸ੍ਵਭਾਰ੍ੱਯਯਾ ਸਹਾਗਤ੍ਯ ਪੌਲਮਾਹੂਯ ਤਸ੍ਯ ਮੁਖਾਤ੍ ਖ੍ਰੀਸ਼਼੍ਟਧਰ੍ੰਮਸ੍ਯ ਵ੍ਰੁʼੱਤਾਨ੍ਤਮ੍ ਅਸ਼੍ਰੌਸ਼਼ੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","ਪੌਲੇਨ ਨ੍ਯਾਯਸ੍ਯ ਪਰਿਮਿਤਭੋਗਸ੍ਯ ਚਰਮਵਿਚਾਰਸ੍ਯ ਚ ਕਥਾਯਾਂ ਕਥਿਤਾਯਾਂ ਸਤ੍ਯਾਂ ਫੀਲਿਕ੍ਸ਼਼ਃ ਕਮ੍ਪਮਾਨਃ ਸਨ੍ ਵ੍ਯਾਹਰਦ੍ ਇਦਾਨੀਂ ਯਾਹਿ, ਅਹਮ੍ ਅਵਕਾਸ਼ੰ ਪ੍ਰਾਪ੍ਯ ਤ੍ਵਾਮ੍ ਆਹੂਸ੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","ਮੁਕ੍ਤਿਪ੍ਰਪ੍ਤ੍ਯਰ੍ਥੰ ਪੌਲੇਨ ਮਹ੍ਯੰ ਮੁਦ੍ਰਾਦਾਸ੍ਯਨ੍ਤੇ ਇਤਿ ਪਤ੍ਯਾਸ਼ਾਂ ਕ੍ਰੁʼਤ੍ਵਾ ਸ ਪੁਨਃ ਪੁਨਸ੍ਤਮਾਹੂਯ ਤੇਨ ਸਾਕੰ ਕਥੋਪਕਥਨੰ ਕ੍ਰੁʼਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","ਕਿਨ੍ਤੁ ਵਤ੍ਸਰਦ੍ਵਯਾਤ੍ ਪਰੰ ਪਰ੍ਕਿਯਫੀਸ਼਼੍ਟ ਫਾਲਿਕ੍ਸ਼਼ਸ੍ਯ ਪਦੰ ਪ੍ਰਾਪ੍ਤੇ ਸਤਿ ਫੀਲਿਕ੍ਸ਼਼ੋ ਯਿਹੂਦੀਯਾਨ੍ ਸਨ੍ਤੁਸ਼਼੍ਟਾਨ੍ ਚਿਕੀਰ੍ਸ਼਼ਨ੍ ਪੌਲੰ ਬੱਧੰ ਸੰਸ੍ਥਾਪ੍ਯ ਗਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","ਅਨਨ੍ਤਰੰ ਫੀਸ਼਼੍ਟੋ ਨਿਜਰਾਜ੍ਯਮ੍ ਆਗਤ੍ਯ ਦਿਨਤ੍ਰਯਾਤ੍ ਪਰੰ ਕੈਸਰਿਯਾਤੋ ਯਿਰੂਸ਼ਾਲਮ੍ਨਗਰਮ੍ ਆਗਮਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","ਤਦਾ ਮਹਾਯਾਜਕੋ ਯਿਹੂਦੀਯਾਨਾਂ ਪ੍ਰਧਾਨਲੋਕਾਸ਼੍ਚ ਤਸ੍ਯ ਸਮਕ੍ਸ਼਼ੰ ਪੌਲਮ੍ ਅਪਾਵਦਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ਭਵਾਨ੍ ਤੰ ਯਿਰੂਸ਼ਾਲਮਮ੍ ਆਨੇਤੁਮ੍ ਆਜ੍ਞਾਪਯਤ੍ਵਿਤਿ ਵਿਨੀਯ ਤੇ ਤਸ੍ਮਾਦ੍ ਅਨੁਗ੍ਰਹੰ ਵਾਞ੍ਛਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","ਯਤਃ ਪਥਿਮਧ੍ਯੇ ਗੋਪਨੇਨ ਪੌਲੰ ਹਨ੍ਤੁੰ ਤੈ ਰ੍ਘਾਤਕਾ ਨਿਯੁਕ੍ਤਾਃ| ਫੀਸ਼਼੍ਟ ਉੱਤਰੰ ਦੱਤਵਾਨ੍ ਪੌਲਃ ਕੈਸਰਿਯਾਯਾਂ ਸ੍ਥਾਸ੍ਯਤਿ ਪੁਨਰਲ੍ਪਦਿਨਾਤ੍ ਪਰਮ੍ ਅਹੰ ਤਤ੍ਰ ਯਾਸ੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","ਤਤਸ੍ਤਸ੍ਯ ਮਾਨੁਸ਼਼ਸ੍ਯ ਯਦਿ ਕਸ਼੍ਚਿਦ੍ ਅਪਰਾਧਸ੍ਤਿਸ਼਼੍ਠਤਿ ਤਰ੍ਹਿ ਯੁਸ਼਼੍ਮਾਕੰ ਯੇ ਸ਼ਕ੍ਨੁਵਨ੍ਤਿ ਤੇ ਮਯਾ ਸਹ ਤਤ੍ਰ ਗਤ੍ਵਾ ਤਮਪਵਦਨ੍ਤੁ ਸ ਏਤਾਂ ਕਥਾਂ ਕਥਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","ਦਸ਼ਦਿਵਸੇਭ੍ਯੋ(ਅ)ਧਿਕੰ ਵਿਲਮ੍ਬ੍ਯ ਫੀਸ਼਼੍ਟਸ੍ਤਸ੍ਮਾਤ੍ ਕੈਸਰਿਯਾਨਗਰੰ ਗਤ੍ਵਾ ਪਰਸ੍ਮਿਨ੍ ਦਿਵਸੇ ਵਿਚਾਰਾਸਨ ਉਪਦਿਸ਼੍ਯ ਪੌਲਮ੍ ਆਨੇਤੁਮ੍ ਆਜ੍ਞਾਪਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","ਪੌਲੇ ਸਮੁਪਸ੍ਥਿਤੇ ਸਤਿ ਯਿਰੂਸ਼ਾਲਮ੍ਨਗਰਾਦ੍ ਆਗਤਾ ਯਿਹੂਦੀਯਲੋਕਾਸ੍ਤੰ ਚਤੁਰ੍ਦਿਸ਼ਿ ਸੰਵੇਸ਼਼੍ਟ੍ਯ ਤਸ੍ਯ ਵਿਰੁੱਧੰ ਬਹੂਨ੍ ਮਹਾਦੋਸ਼਼ਾਨ੍ ਉੱਥਾਪਿਤਵਨ੍ਤਃ ਕਿਨ੍ਤੁ ਤੇਸ਼਼ਾਂ ਕਿਮਪਿ ਪ੍ਰਮਾਣੰ ਦਾਤੁੰ ਨ ਸ਼ਕ੍ਨੁਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","ਤਤਃ ਪੌਲਃ ਸ੍ਵਸ੍ਮਿਨ੍ ਉੱਤਰਮਿਦਮ੍ ਉਦਿਤਵਾਨ੍, ਯਿਹੂਦੀਯਾਨਾਂ ਵ੍ਯਵਸ੍ਥਾਯਾ ਮਨ੍ਦਿਰਸ੍ਯ ਕੈਸਰਸ੍ਯ ਵਾ ਪ੍ਰਤਿਕੂਲੰ ਕਿਮਪਿ ਕਰ੍ੰਮ ਨਾਹੰ ਕ੍ਰੁʼਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","ਕਿਨ੍ਤੁ ਫੀਸ਼਼੍ਟੋ ਯਿਹੂਦੀਯਾਨ੍ ਸਨ੍ਤੁਸ਼਼੍ਟਾਨ੍ ਕਰ੍ੱਤੁਮ੍ ਅਭਿਲਸ਼਼ਨ੍ ਪੌਲਮ੍ ਅਭਾਸ਼਼ਤ ਤ੍ਵੰ ਕਿੰ ਯਿਰੂਸ਼ਾਲਮੰ ਗਤ੍ਵਾਸ੍ਮਿਨ੍ ਅਭਿਯੋਗੇ ਮਮ ਸਾਕ੍ਸ਼਼ਾਦ੍ ਵਿਚਾਰਿਤੋ ਭਵਿਸ਼਼੍ਯਸਿ? ");
INSERT INTO sanpun_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","ਤਤਃ ਪੌਲ ਉੱਤਰੰ ਪ੍ਰੋਕ੍ਤਵਾਨ੍, ਯਤ੍ਰ ਮਮ ਵਿਚਾਰੋ ਭਵਿਤੁੰ ਯੋਗ੍ਯਃ ਕੈਸਰਸ੍ਯ ਤਤ੍ਰ ਵਿਚਾਰਾਸਨ ਏਵ ਸਮੁਪਸ੍ਥਿਤੋਸ੍ਮਿ; ਅਹੰ ਯਿਹੂਦੀਯਾਨਾਂ ਕਾਮਪਿ ਹਾਨਿੰ ਨਾਕਾਰ੍ਸ਼਼ਮ੍ ਇਤਿ ਭਵਾਨ੍ ਯਥਾਰ੍ਥਤੋ ਵਿਜਾਨਾਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","ਕਞ੍ਚਿਦਪਰਾਧੰ ਕਿਞ੍ਚਨ ਵਧਾਰ੍ਹੰ ਕਰ੍ੰਮ ਵਾ ਯਦ੍ਯਹਮ੍ ਅਕਰਿਸ਼਼੍ਯੰ ਤਰ੍ਹਿ ਪ੍ਰਾਣਹਨਨਦਣ੍ਡਮਪਿ ਭੋਕ੍ਤੁਮ੍ ਉਦ੍ਯਤੋ(ਅ)ਭਵਿਸ਼਼੍ਯੰ, ਕਿਨ੍ਤੁ ਤੇ ਮਮ ਸਮਪਵਾਦੰ ਕੁਰ੍ੱਵਨ੍ਤਿ ਸ ਯਦਿ ਕਲ੍ਪਿਤਮਾਤ੍ਰੋ ਭਵਤਿ ਤਰ੍ਹਿ ਤੇਸ਼਼ਾਂ ਕਰੇਸ਼਼ੁ ਮਾਂ ਸਮਰ੍ਪਯਿਤੁੰ ਕਸ੍ਯਾਪ੍ਯਧਿਕਾਰੋ ਨਾਸ੍ਤਿ, ਕੈਸਰਸ੍ਯ ਨਿਕਟੇ ਮਮ ਵਿਚਾਰੋ ਭਵਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","ਤਦਾ ਫੀਸ਼਼੍ਟੋ ਮਨ੍ਤ੍ਰਿਭਿਃ ਸਾਰ੍ੱਧੰ ਸੰਮਨ੍ਤ੍ਰ੍ਯ ਪੌਲਾਯ ਕਥਿਤਵਾਨ੍, ਕੈਸਰਸ੍ਯ ਨਿਕਟੇ ਕਿੰ ਤਵ ਵਿਚਾਰੋ ਭਵਿਸ਼਼੍ਯਤਿ? ਕੈਸਰਸ੍ਯ ਸਮੀਪੰ ਗਮਿਸ਼਼੍ਯਸਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","ਕਿਯੱਦਿਨੇਭ੍ਯਃ ਪਰਮ੍ ਆਗ੍ਰਿੱਪਰਾਜਾ ਬਰ੍ਣੀਕੀ ਚ ਫੀਸ਼਼੍ਟੰ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਕਰ੍ੱਤੁੰ ਕੈਸਰਿਯਾਨਗਰਮ੍ ਆਗਤਵਨ੍ਤੌ| ");
INSERT INTO sanpun_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","ਤਦਾ ਤੌ ਬਹੁਦਿਨਾਨਿ ਤਤ੍ਰ ਸ੍ਥਿਤੌ ਤਤਃ ਫੀਸ਼਼੍ਟਸ੍ਤੰ ਰਾਜਾਨੰ ਪੌਲਸ੍ਯ ਕਥਾਂ ਵਿਜ੍ਞਾਪ੍ਯ ਕਥਯਿਤੁਮ੍ ਆਰਭਤ ਪੌਲਨਾਮਾਨਮ੍ ਏਕੰ ਬਨ੍ਦਿ ਫੀਲਿਕ੍ਸ਼਼ੋ ਬੱਧੰ ਸੰਸ੍ਥਾਪ੍ਯ ਗਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","ਯਿਰੂਸ਼ਾਲਮਿ ਮਮ ਸ੍ਥਿਤਿਕਾਲੇ ਮਹਾਯਾਜਕੋ ਯਿਹੂਦੀਯਾਨਾਂ ਪ੍ਰਾਚੀਨਲੋਕਾਸ਼੍ਚ ਤਮ੍ ਅਪੋਦ੍ਯ ਤਮ੍ਪ੍ਰਤਿ ਦਣ੍ਡਾਜ੍ਞਾਂ ਪ੍ਰਾਰ੍ਥਯਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","ਤਤੋਹਮ੍ ਇਤ੍ਯੁੱਤਰਮ੍ ਅਵਦੰ ਯਾਵਦ੍ ਅਪੋਦਿਤੋ ਜਨਃ ਸ੍ਵਾਪਵਾਦਕਾਨ੍ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਕ੍ਰੁʼਤ੍ਵਾ ਸ੍ਵਸ੍ਮਿਨ੍ ਯੋ(ਅ)ਪਰਾਧ ਆਰੋਪਿਤਸ੍ਤਸ੍ਯ ਪ੍ਰਤ੍ਯੁੱਤਰੰ ਦਾਤੁੰ ਸੁਯੋਗੰ ਨ ਪ੍ਰਾਪ੍ਨੋਤਿ, ਤਾਵਤ੍ਕਾਲੰ ਕਸ੍ਯਾਪਿ ਮਾਨੁਸ਼਼ਸ੍ਯ ਪ੍ਰਾਣਨਾਸ਼ਾਜ੍ਞਾਪਨੰ ਰੋਮਿਲੋਕਾਨਾਂ ਰੀਤਿ ਰ੍ਨਹਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","ਤਤਸ੍ਤੇਸ਼਼੍ਵਤ੍ਰਾਗਤੇਸ਼਼ੁ ਪਰਸ੍ਮਿਨ੍ ਦਿਵਸੇ(ਅ)ਹਮ੍ ਅਵਿਲਮ੍ਬੰ ਵਿਚਾਰਾਸਨ ਉਪਵਿਸ਼੍ਯ ਤੰ ਮਾਨੁਸ਼਼ਮ੍ ਆਨੇਤੁਮ੍ ਆਜ੍ਞਾਪਯਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","ਤਦਨਨ੍ਤਰੰ ਤਸ੍ਯਾਪਵਾਦਕਾ ਉਪਸ੍ਥਾਯ ਯਾਦ੍ਰੁʼਸ਼ਮ੍ ਅਹੰ ਚਿਨ੍ਤਿਤਵਾਨ੍ ਤਾਦ੍ਰੁʼਸ਼ੰ ਕਞ੍ਚਨ ਮਹਾਪਵਾਦੰ ਨੋੱਥਾਪ੍ਯ ");
INSERT INTO sanpun_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","ਸ੍ਵੇਸ਼਼ਾਂ ਮਤੇ ਤਥਾ ਪੌਲੋ ਯੰ ਸਜੀਵੰ ਵਦਤਿ ਤਸ੍ਮਿਨ੍ ਯੀਸ਼ੁਨਾਮਨਿ ਮ੍ਰੁʼਤਜਨੇ ਚ ਤਸ੍ਯ ਵਿਰੁੱਧੰ ਕਥਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","ਤਤੋਹੰ ਤਾਦ੍ਰੁʼਗ੍ਵਿਚਾਰੇ ਸੰਸ਼ਯਾਨਃ ਸਨ੍ ਕਥਿਤਵਾਨ੍ ਤ੍ਵੰ ਯਿਰੂਸ਼ਾਲਮੰ ਗਤ੍ਵਾ ਕਿੰ ਤਤ੍ਰ ਵਿਚਾਰਿਤੋ ਭਵਿਤੁਮ੍ ਇੱਛਸਿ? ");
INSERT INTO sanpun_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","ਤਦਾ ਪੌਲੋ ਮਹਾਰਾਜਸ੍ਯ ਨਿਕਟੇ ਵਿਚਾਰਿਤੋ ਭਵਿਤੁੰ ਪ੍ਰਾਰ੍ਥਯਤ, ਤਸ੍ਮਾਦ੍ ਯਾਵਤ੍ਕਾਲੰ ਤੰ ਕੈਸਰਸ੍ਯ ਸਮੀਪੰ ਪ੍ਰੇਸ਼਼ਯਿਤੁੰ ਨ ਸ਼ਕ੍ਨੋਮਿ ਤਾਵਤ੍ਕਾਲੰ ਤਮਤ੍ਰ ਸ੍ਥਾਪਯਿਤੁਮ੍ ਆਦਿਸ਼਼੍ਟਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","ਤਤ ਆਗ੍ਰਿੱਪਃ ਫੀਸ਼਼੍ਟਮ੍ ਉਕ੍ਤਵਾਨ੍, ਅਹਮਪਿ ਤਸ੍ਯ ਮਾਨੁਸ਼਼ਸ੍ਯ ਕਥਾਂ ਸ਼੍ਰੋਤੁਮ੍ ਅਭਿਲਸ਼਼ਾਮਿ| ਤਦਾ ਫੀਸ਼਼੍ਟੋ ਵ੍ਯਾਹਰਤ੍ ਸ਼੍ਵਸ੍ਤਦੀਯਾਂ ਕਥਾਂ ਤ੍ਵੰ ਸ਼੍ਰੋਸ਼਼੍ਯਸਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","ਪਰਸ੍ਮਿਨ੍ ਦਿਵਸੇ ਆਗ੍ਰਿੱਪੋ ਬਰ੍ਣੀਕੀ ਚ ਮਹਾਸਮਾਗਮੰ ਕ੍ਰੁʼਤ੍ਵਾ ਪ੍ਰਧਾਨਵਾਹਿਨੀਪਤਿਭਿ ਰ੍ਨਗਰਸ੍ਥਪ੍ਰਧਾਨਲੋਕੈਸ਼੍ਚ ਸਹ ਮਿਲਿਤ੍ਵਾ ਰਾਜਗ੍ਰੁʼਹਮਾਗਤ੍ਯ ਸਮੁਪਸ੍ਥਿਤੌ ਤਦਾ ਫੀਸ਼਼੍ਟਸ੍ਯਾਜ੍ਞਯਾ ਪੌਲ ਆਨੀਤੋ(ਅ)ਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","ਤਦਾ ਫੀਸ਼਼੍ਟਃ ਕਥਿਤਵਾਨ੍ ਹੇ ਰਾਜਨ੍ ਆਗ੍ਰਿੱਪ ਹੇ ਉਪਸ੍ਥਿਤਾਃ ਸਰ੍ੱਵੇ ਲੋਕਾ ਯਿਰੂਸ਼ਾਲਮ੍ਨਗਰੇ ਯਿਹੂਦੀਯਲੋਕਸਮੂਹੋ ਯਸ੍ਮਿਨ੍ ਮਾਨੁਸ਼਼ੇ ਮਮ ਸਮੀਪੇ ਨਿਵੇਦਨੰ ਕ੍ਰੁʼਤ੍ਵਾ ਪ੍ਰੋੱਚੈਃ ਕਥਾਮਿਮਾਂ ਕਥਿਤਵਾਨ੍ ਪੁਨਰਲ੍ਪਕਾਲਮਪਿ ਤਸ੍ਯ ਜੀਵਨੰ ਨੋਚਿਤੰ ਤਮੇਤੰ ਮਾਨੁਸ਼਼ੰ ਪਸ਼੍ਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","ਕਿਨ੍ਤ੍ਵੇਸ਼਼ ਜਨਃ ਪ੍ਰਾਣਨਾਸ਼ਰ੍ਹੰ ਕਿਮਪਿ ਕਰ੍ੰਮ ਨ ਕ੍ਰੁʼਤਵਾਨ੍ ਇਤ੍ਯਜਾਨਾਂ ਤਥਾਪਿ ਸ ਮਹਾਰਾਜਸ੍ਯ ਸੰਨਿਧੌ ਵਿਚਾਰਿਤੋ ਭਵਿਤੁੰ ਪ੍ਰਾਰ੍ਥਯਤ ਤਸ੍ਮਾਤ੍ ਤਸ੍ਯ ਸਮੀਪੰ ਤੰ ਪ੍ਰੇਸ਼਼ਯਿਤੁੰ ਮਤਿਮਕਰਵਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","ਕਿਨ੍ਤੁ ਸ਼੍ਰੀਯੁਕ੍ਤਸ੍ਯ ਸਮੀਪਮ੍ ਏਤਸ੍ਮਿਨ੍ ਕਿੰ ਲੇਖਨੀਯਮ੍ ਇਤ੍ਯਸ੍ਯ ਕਸ੍ਯਚਿਨ੍ ਨਿਰ੍ਣਯਸ੍ਯ ਨ ਜਾਤਤ੍ਵਾਦ੍ ਏਤਸ੍ਯ ਵਿਚਾਰੇ ਸਤਿ ਯਥਾਹੰ ਲੇਖਿਤੁੰ ਕਿਞ੍ਚਨ ਨਿਸ਼੍ਚਿਤੰ ਪ੍ਰਾਪ੍ਨੋਮਿ ਤਦਰ੍ਥੰ ਯੁਸ਼਼੍ਮਾਕੰ ਸਮਕ੍ਸ਼਼ੰ ਵਿਸ਼ੇਸ਼਼ਤੋ ਹੇ ਆਗ੍ਰਿੱਪਰਾਜ ਭਵਤਃ ਸਮਕ੍ਸ਼਼ਮ੍ ਏਤਮ੍ ਆਨਯੇ| ");
INSERT INTO sanpun_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","ਯਤੋ ਬਨ੍ਦਿਪ੍ਰੇਸ਼਼ਣਸਮਯੇ ਤਸ੍ਯਾਭਿਯੋਗਸ੍ਯ ਕਿਞ੍ਚਿਦਲੇਖਨਮ੍ ਅਹਮ੍ ਅਯੁਕ੍ਤੰ ਜਾਨਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","ਤਤ ਆਗ੍ਰਿੱਪਃ ਪੌਲਮ੍ ਅਵਾਦੀਤ੍, ਨਿਜਾਂ ਕਥਾਂ ਕਥਯਿਤੁੰ ਤੁਭ੍ਯਮ੍ ਅਨੁਮਤਿ ਰ੍ਦੀਯਤੇ| ਤਸ੍ਮਾਤ੍ ਪੌਲਃ ਕਰੰ ਪ੍ਰਸਾਰ੍ੱਯ ਸ੍ਵਸ੍ਮਿਨ੍ ਉੱਤਰਮ੍ ਅਵਾਦੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","ਹੇ ਆਗ੍ਰਿੱਪਰਾਜ ਯਤ੍ਕਾਰਣਾਦਹੰ ਯਿਹੂਦੀਯੈਰਪਵਾਦਿਤੋ (ਅ)ਭਵੰ ਤਸ੍ਯ ਵ੍ਰੁʼੱਤਾਨ੍ਤਮ੍ ਅਦ੍ਯ ਭਵਤਃ ਸਾਕ੍ਸ਼਼ਾਨ੍ ਨਿਵੇਦਯਿਤੁਮਨੁਮਤੋਹਮ੍ ਇਦੰ ਸ੍ਵੀਯੰ ਪਰਮੰ ਭਾਗ੍ਯੰ ਮਨ੍ਯੇ; ");
INSERT INTO sanpun_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","ਯਤੋ ਯਿਹੂਦੀਯਲੋਕਾਨਾਂ ਮਧ੍ਯੇ ਯਾ ਯਾ ਰੀਤਿਃ ਸੂਕ੍ਸ਼਼੍ਮਵਿਚਾਰਾਸ਼੍ਚ ਸਨ੍ਤਿ ਤੇਸ਼਼ੁ ਭਵਾਨ੍ ਵਿਜ੍ਞਤਮਃ; ਅਤਏਵ ਪ੍ਰਾਰ੍ਥਯੇ ਧੈਰ੍ੱਯਮਵਲਮ੍ਬ੍ਯ ਮਮ ਨਿਵੇਦਨੰ ਸ਼੍ਰੁʼਣੋਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","ਅਹੰ ਯਿਰੂਸ਼ਾਲਮ੍ਨਗਰੇ ਸ੍ਵਦੇਸ਼ੀਯਲੋਕਾਨਾਂ ਮਧ੍ਯੇ ਤਿਸ਼਼੍ਠਨ੍ ਆ ਯੌਵਨਕਾਲਾਦ੍ ਯਦ੍ਰੂਪਮ੍ ਆਚਰਿਤਵਾਨ੍ ਤਦ੍ ਯਿਹੂਦੀਯਲੋਕਾਃ ਸਰ੍ੱਵੇ ਵਿਦਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","ਅਸ੍ਮਾਕੰ ਸਰ੍ੱਵੇਭ੍ਯਃ ਸ਼ੁੱਧਤਮੰ ਯਤ੍ ਫਿਰੂਸ਼ੀਯਮਤੰ ਤਦਵਲਮ੍ਬੀ ਭੂਤ੍ਵਾਹੰ ਕਾਲੰ ਯਾਪਿਤਵਾਨ੍ ਯੇ ਜਨਾ ਆ ਬਾਲ੍ਯਕਾਲਾਨ੍ ਮਾਂ ਜਾਨਾਨ੍ਤਿ ਤੇ ਏਤਾਦ੍ਰੁʼਸ਼ੰ ਸਾਕ੍ਸ਼਼੍ਯੰ ਯਦਿ ਦਦਾਤਿ ਤਰ੍ਹਿ ਦਾਤੁੰ ਸ਼ਕ੍ਨੁਵਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","ਕਿਨ੍ਤੁ ਹੇ ਆਗ੍ਰਿੱਪਰਾਜ ਈਸ਼੍ਵਰੋ(ਅ)ਸ੍ਮਾਕੰ ਪੂਰ੍ੱਵਪੁਰੁਸ਼਼ਾਣਾਂ ਨਿਕਟੇ ਯਦ੍ ਅਙ੍ਗੀਕ੍ਰੁʼਤਵਾਨ੍ ਤਸ੍ਯ ਪ੍ਰਤ੍ਯਾਸ਼ਾਹੇਤੋਰਹਮ੍ ਇਦਾਨੀਂ ਵਿਚਾਰਸ੍ਥਾਨੇ ਦਣ੍ਡਾਯਮਾਨੋਸ੍ਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","ਤਸ੍ਯਾਙ੍ਗੀਕਾਰਸ੍ਯ ਫਲੰ ਪ੍ਰਾਪ੍ਤੁਮ੍ ਅਸ੍ਮਾਕੰ ਦ੍ਵਾਦਸ਼ਵੰਸ਼ਾ ਦਿਵਾਨਿਸ਼ੰ ਮਹਾਯਤ੍ਨਾਦ੍ ਈਸ਼੍ਵਰਸੇਵਨੰ ਕ੍ਰੁʼਤ੍ਵਾ ਯਾਂ ਪ੍ਰਤ੍ਯਾਸ਼ਾਂ ਕੁਰ੍ੱਵਨ੍ਤਿ ਤਸ੍ਯਾਃ ਪ੍ਰਤ੍ਯਾਸ਼ਾਯਾ ਹੇਤੋਰਹੰ ਯਿਹੂਦੀਯੈਰਪਵਾਦਿਤੋ(ਅ)ਭਵਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","ਈਸ਼੍ਵਰੋ ਮ੍ਰੁʼਤਾਨ੍ ਉੱਥਾਪਯਿਸ਼਼੍ਯਤੀਤਿ ਵਾਕ੍ਯੰ ਯੁਸ਼਼੍ਮਾਕੰ ਨਿਕਟੇ(ਅ)ਸਮ੍ਭਵੰ ਕੁਤੋ ਭਵੇਤ੍? ");
INSERT INTO sanpun_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","ਨਾਸਰਤੀਯਯੀਸ਼ੋ ਰ੍ਨਾਮ੍ਨੋ ਵਿਰੁੱਧੰ ਨਾਨਾਪ੍ਰਕਾਰਪ੍ਰਤਿਕੂਲਾਚਰਣਮ੍ ਉਚਿਤਮ੍ ਇਤ੍ਯਹੰ ਮਨਸਿ ਯਥਾਰ੍ਥੰ ਵਿਜ੍ਞਾਯ ");
INSERT INTO sanpun_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","ਯਿਰੂਸ਼ਾਲਮਨਗਰੇ ਤਦਕਰਵੰ ਫਲਤਃ ਪ੍ਰਧਾਨਯਾਜਕਸ੍ਯ ਨਿਕਟਾਤ੍ ਕ੍ਸ਼਼ਮਤਾਂ ਪ੍ਰਾਪ੍ਯ ਬਹੂਨ੍ ਪਵਿਤ੍ਰਲੋਕਾਨ੍ ਕਾਰਾਯਾਂ ਬੱਧਵਾਨ੍ ਵਿਸ਼ੇਸ਼਼ਤਸ੍ਤੇਸ਼਼ਾਂ ਹਨਨਸਮਯੇ ਤੇਸ਼਼ਾਂ ਵਿਰੁੱਧਾਂ ਨਿਜਾਂ ਸੰਮਤਿੰ ਪ੍ਰਕਾਸ਼ਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","ਵਾਰੰ ਵਾਰੰ ਭਜਨਭਵਨੇਸ਼਼ੁ ਤੇਭ੍ਯੋ ਦਣ੍ਡੰ ਪ੍ਰਦੱਤਵਾਨ੍ ਬਲਾਤ੍ ਤੰ ਧਰ੍ੰਮੰ ਨਿਨ੍ਦਯਿਤਵਾਂਸ਼੍ਚ ਪੁਨਸ਼੍ਚ ਤਾਨ੍ ਪ੍ਰਤਿ ਮਹਾਕ੍ਰੋਧਾਦ੍ ਉਨ੍ਮੱਤਃ ਸਨ੍ ਵਿਦੇਸ਼ੀਯਨਗਰਾਣਿ ਯਾਵਤ੍ ਤਾਨ੍ ਤਾਡਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","ਇੱਥੰ ਪ੍ਰਧਾਨਯਾਜਕਸ੍ਯ ਸਮੀਪਾਤ੍ ਸ਼ਕ੍ਤਿਮ੍ ਆਜ੍ਞਾਪਤ੍ਰਞ੍ਚ ਲਬ੍ਧ੍ਵਾ ਦੰਮੇਸ਼਼ਕ੍ਨਗਰੰ ਗਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","ਤਦਾਹੰ ਹੇ ਰਾਜਨ੍ ਮਾਰ੍ਗਮਧ੍ਯੇ ਮਧ੍ਯਾਹ੍ਨਕਾਲੇ ਮਮ ਮਦੀਯਸਙ੍ਗਿਨਾਂ ਲੋਕਾਨਾਞ੍ਚ ਚਤਸ੍ਰੁʼਸ਼਼ੁ ਦਿਕ੍ਸ਼਼ੁ ਗਗਣਾਤ੍ ਪ੍ਰਕਾਸ਼ਮਾਨਾਂ ਭਾਸ੍ਕਰਤੋਪਿ ਤੇਜਸ੍ਵਤੀਂ ਦੀਪ੍ਤਿੰ ਦ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","ਤਸ੍ਮਾਦ੍ ਅਸ੍ਮਾਸੁ ਸਰ੍ੱਵੇਸ਼਼ੁ ਭੂਮੌ ਪਤਿਤੇਸ਼਼ੁ ਸਤ੍ਸੁ ਹੇ ਸ਼ੌਲ ਹੈ ਸ਼ੌਲ ਕੁਤੋ ਮਾਂ ਤਾਡਯਸਿ? ਕਣ੍ਟਕਾਨਾਂ ਮੁਖੇ ਪਾਦਾਹਨਨੰ ਤਵ ਦੁਃਸਾਧ੍ਯਮ੍ ਇਬ੍ਰੀਯਭਾਸ਼਼ਯਾ ਗਦਿਤ ਏਤਾਦ੍ਰੁʼਸ਼ ਏਕਃ ਸ਼ਬ੍ਦੋ ਮਯਾ ਸ਼੍ਰੁਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","ਤਦਾਹੰ ਪ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍ ਹੇ ਪ੍ਰਭੋ ਕੋ ਭਵਾਨ੍? ਤਤਃ ਸ ਕਥਿਤਵਾਨ੍ ਯੰ ਯੀਸ਼ੁੰ ਤ੍ਵੰ ਤਾਡਯਸਿ ਸੋਹੰ, ");
INSERT INTO sanpun_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","ਕਿਨ੍ਤੁ ਸਮੁੱਤਿਸ਼਼੍ਠ ਤ੍ਵੰ ਯਦ੍ ਦ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍ ਇਤਃ ਪੁਨਞ੍ਚ ਯਦ੍ਯਤ੍ ਤ੍ਵਾਂ ਦਰ੍ਸ਼ਯਿਸ਼਼੍ਯਾਮਿ ਤੇਸ਼਼ਾਂ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਕਾਰ੍ੱਯਾਣਾਂ ਤ੍ਵਾਂ ਸਾਕ੍ਸ਼਼ਿਣੰ ਮਮ ਸੇਵਕਞ੍ਚ ਕਰ੍ੱਤੁਮ੍ ਦਰ੍ਸ਼ਨਮ੍ ਅਦਾਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","ਵਿਸ਼ੇਸ਼਼ਤੋ ਯਿਹੂਦੀਯਲੋਕੇਭ੍ਯੋ ਭਿੰਨਜਾਤੀਯੇਭ੍ਯਸ਼੍ਚ ਤ੍ਵਾਂ ਮਨੋਨੀਤੰ ਕ੍ਰੁʼਤ੍ਵਾ ਤੇਸ਼਼ਾਂ ਯਥਾ ਪਾਪਮੋਚਨੰ ਭਵਤਿ ");
INSERT INTO sanpun_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ਯਥਾ ਤੇ ਮਯਿ ਵਿਸ਼੍ਵਸ੍ਯ ਪਵਿਤ੍ਰੀਕ੍ਰੁʼਤਾਨਾਂ ਮਧ੍ਯੇ ਭਾਗੰ ਪ੍ਰਾਪ੍ਨੁਵਨ੍ਤਿ ਤਦਭਿਪ੍ਰਾਯੇਣ ਤੇਸ਼਼ਾਂ ਜ੍ਞਾਨਚਕ੍ਸ਼਼ੂੰਸ਼਼ਿ ਪ੍ਰਸੰਨਾਨਿ ਕਰ੍ੱਤੁੰ ਤਥਾਨ੍ਧਕਾਰਾਦ੍ ਦੀਪ੍ਤਿੰ ਪ੍ਰਤਿ ਸ਼ੈਤਾਨਾਧਿਕਾਰਾੱਚ ਈਸ਼੍ਵਰੰ ਪ੍ਰਤਿ ਮਤੀਃ ਪਰਾਵਰ੍ੱਤਯਿਤੁੰ ਤੇਸ਼਼ਾਂ ਸਮੀਪੰ ਤ੍ਵਾਂ ਪ੍ਰੇਸ਼਼੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","ਹੇ ਆਗ੍ਰਿੱਪਰਾਜ ਏਤਾਦ੍ਰੁʼਸ਼ੰ ਸ੍ਵਰ੍ਗੀਯਪ੍ਰਤ੍ਯਾਦੇਸ਼ੰ ਅਗ੍ਰਾਹ੍ਯਮ੍ ਅਕ੍ਰੁʼਤ੍ਵਾਹੰ ");
INSERT INTO sanpun_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","ਪ੍ਰਥਮਤੋ ਦੰਮੇਸ਼਼ਕ੍ਨਗਰੇ ਤਤੋ ਯਿਰੂਸ਼ਾਲਮਿ ਸਰ੍ੱਵਸ੍ਮਿਨ੍ ਯਿਹੂਦੀਯਦੇਸ਼ੇ ਅਨ੍ਯੇਸ਼਼ੁ ਦੇਸ਼ੇਸ਼਼ੁ ਚ ਯੇेਨ ਲੋਕਾ ਮਤਿੰ ਪਰਾਵਰ੍ੱਤ੍ਯ ਈਸ਼੍ਵਰੰ ਪ੍ਰਤਿ ਪਰਾਵਰ੍ੱਤਯਨ੍ਤੇ, ਮਨਃਪਰਾਵਰ੍ੱਤਨਯੋਗ੍ਯਾਨਿ ਕਰ੍ੰਮਾਣਿ ਚ ਕੁਰ੍ੱਵਨ੍ਤਿ ਤਾਦ੍ਰੁʼਸ਼ਮ੍ ਉਪਦੇਸ਼ੰ ਪ੍ਰਚਾਰਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","ਏਤਤ੍ਕਾਰਣਾਦ੍ ਯਿਹੂਦੀਯਾ ਮਧ੍ਯੇਮਨ੍ਦਿਰੰ ਮਾਂ ਧ੍ਰੁʼਤ੍ਵਾ ਹਨ੍ਤੁਮ੍ ਉਦ੍ਯਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","ਤਥਾਪਿ ਖ੍ਰੀਸ਼਼੍ਟੋ ਦੁਃਖੰ ਭੁਕ੍ਤ੍ਵਾ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਪੂਰ੍ੱਵੰ ਸ਼੍ਮਸ਼ਾਨਾਦ੍ ਉੱਥਾਯ ਨਿਜਦੇਸ਼ੀਯਾਨਾਂ ਭਿੰਨਦੇਸ਼ੀਯਾਨਾਞ੍ਚ ਸਮੀਪੇ ਦੀਪ੍ਤਿੰ ਪ੍ਰਕਾਸ਼ਯਿਸ਼਼੍ਯਤਿ ");
INSERT INTO sanpun_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਗਣੋ ਮੂਸਾਸ਼੍ਚ ਭਾਵਿਕਾਰ੍ੱਯਸ੍ਯ ਯਦਿਦੰ ਪ੍ਰਮਾਣਮ੍ ਅਦਦੁਰੇਤਦ੍ ਵਿਨਾਨ੍ਯਾਂ ਕਥਾਂ ਨ ਕਥਯਿਤ੍ਵਾ ਈਸ਼੍ਵਰਾਦ੍ ਅਨੁਗ੍ਰਹੰ ਲਬ੍ਧ੍ਵਾ ਮਹਤਾਂ ਕ੍ਸ਼਼ੁਦ੍ਰਾਣਾਞ੍ਚ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਸਮੀਪੇ ਪ੍ਰਮਾਣੰ ਦੱਤ੍ਵਾਦ੍ਯ ਯਾਵਤ੍ ਤਿਸ਼਼੍ਠਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","ਤਸ੍ਯਮਾਂ ਕਥਾਂ ਨਿਸ਼ਮ੍ਯ ਫੀਸ਼਼੍ਟ ਉੱਚੈਃ ਸ੍ਵਰੇਣ ਕਥਿਤਵਾਨ੍ ਹੇ ਪੌਲ ਤ੍ਵਮ੍ ਉਨ੍ਮੱਤੋਸਿ ਬਹੁਵਿਦ੍ਯਾਭ੍ਯਾਸੇਨ ਤ੍ਵੰ ਹਤਜ੍ਞਾਨੋ ਜਾਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","ਸ ਉਕ੍ਤਵਾਨ੍ ਹੇ ਮਹਾਮਹਿਮ ਫੀਸ਼਼੍ਟ ਨਾਹਮ੍ ਉਨ੍ਮੱਤਃ ਕਿਨ੍ਤੁ ਸਤ੍ਯੰ ਵਿਵੇਚਨੀਯਞ੍ਚ ਵਾਕ੍ਯੰ ਪ੍ਰਸ੍ਤੌਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","ਯਸ੍ਯ ਸਾਕ੍ਸ਼਼ਾਦ੍ ਅਕ੍ਸ਼਼ੋਭਃ ਸਨ੍ ਕਥਾਂ ਕਥਯਾਮਿ ਸ ਰਾਜਾ ਤਦ੍ਵ੍ਰੁʼੱਤਾਨ੍ਤੰ ਜਾਨਾਤਿ ਤਸ੍ਯ ਸਮੀਪੇ ਕਿਮਪਿ ਗੁਪ੍ਤੰ ਨੇਤਿ ਮਯਾ ਨਿਸ਼੍ਚਿਤੰ ਬੁਧ੍ਯਤੇ ਯਤਸ੍ਤਦ੍ ਵਿਜਨੇ ਨ ਕ੍ਰੁʼਤੰ| ");
INSERT INTO sanpun_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","ਹੇ ਆਗ੍ਰਿੱਪਰਾਜ ਭਵਾਨ੍ ਕਿੰ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਗਣੋਕ੍ਤਾਨਿ ਵਾਕ੍ਯਾਨਿ ਪ੍ਰਤ੍ਯੇਤਿ? ਭਵਾਨ੍ ਪ੍ਰਤ੍ਯੇਤਿ ਤਦਹੰ ਜਾਨਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","ਤਤ ਆਗ੍ਰਿੱਪਃ ਪੌਲਮ੍ ਅਭਿਹਿਤਵਾਨ੍ ਤ੍ਵੰ ਪ੍ਰਵ੍ਰੁʼੱਤਿੰ ਜਨਯਿਤ੍ਵਾ ਪ੍ਰਾਯੇਣ ਮਾਮਪਿ ਖ੍ਰੀਸ਼਼੍ਟੀਯੰ ਕਰੋਸ਼਼ਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","ਤਤਃ ਸੋ(ਅ)ਵਾਦੀਤ੍ ਭਵਾਨ੍ ਯੇ ਯੇ ਲੋਕਾਸ਼੍ਚ ਮਮ ਕਥਾਮ੍ ਅਦ੍ਯ ਸ਼੍ਰੁʼਣ੍ਵਨ੍ਤਿ ਪ੍ਰਾਯੇਣ ਇਤਿ ਨਹਿ ਕਿਨ੍ਤ੍ਵੇਤਤ੍ ਸ਼੍ਰੁʼਙ੍ਖਲਬਨ੍ਧਨੰ ਵਿਨਾ ਸਰ੍ੱਵਥਾ ਤੇ ਸਰ੍ੱਵੇ ਮਾਦ੍ਰੁʼਸ਼ਾ ਭਵਨ੍ਤ੍ਵਿਤੀਸ਼੍ਵਸ੍ਯ ਸਮੀਪੇ ਪ੍ਰਾਰ੍ਥਯੇ(ਅ)ਹਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","ਏਤਸ੍ਯਾਂ ਕਥਾਯਾਂ ਕਥਿਤਾਯਾਂ ਸ ਰਾਜਾ ਸੋ(ਅ)ਧਿਪਤਿ ਰ੍ਬਰ੍ਣੀਕੀ ਸਭਾਸ੍ਥਾ ਲੋਕਾਸ਼੍ਚ ਤਸ੍ਮਾਦ੍ ਉੱਥਾਯ ");
INSERT INTO sanpun_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ਗੋਪਨੇ ਪਰਸ੍ਪਰੰ ਵਿਵਿਚ੍ਯ ਕਥਿਤਵਨ੍ਤ ਏਸ਼਼ ਜਨੋ ਬਨ੍ਧਨਾਰ੍ਹੰ ਪ੍ਰਾਣਹਨਨਾਰ੍ਹੰ ਵਾ ਕਿਮਪਿ ਕਰ੍ੰਮ ਨਾਕਰੋਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","ਤਤ ਆਗ੍ਰਿੱਪਃ ਫੀਸ਼਼੍ਟਮ੍ ਅਵਦਤ੍, ਯਦ੍ਯੇਸ਼਼ ਮਾਨੁਸ਼਼ਃ ਕੈਸਰਸ੍ਯ ਨਿਕਟੇ ਵਿਚਾਰਿਤੋ ਭਵਿਤੁੰ ਨ ਪ੍ਰਾਰ੍ਥਯਿਸ਼਼੍ਯਤ੍ ਤਰ੍ਹਿ ਮੁਕ੍ਤੋ ਭਵਿਤੁਮ੍ ਅਸ਼ਕ੍ਸ਼਼੍ਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","ਜਲਪਥੇਨਾਸ੍ਮਾਕਮ੍ ਇਤੋਲਿਯਾਦੇਸ਼ੰ ਪ੍ਰਤਿ ਯਾਤ੍ਰਾਯਾਂ ਨਿਸ਼੍ਚਿਤਾਯਾਂ ਸਤ੍ਯਾਂ ਤੇ ਯੂਲਿਯਨਾਮ੍ਨੋ ਮਹਾਰਾਜਸ੍ਯ ਸੰਘਾਤਾਨ੍ਤਰ੍ਗਤਸ੍ਯ ਸੇਨਾਪਤੇਃ ਸਮੀਪੇ ਪੌਲੰ ਤਦਨ੍ਯਾਨ੍ ਕਤਿਨਯਜਨਾਂਸ਼੍ਚ ਸਮਾਰ੍ਪਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","ਵਯਮ੍ ਆਦ੍ਰਾਮੁੱਤੀਯੰ ਪੋਤਮੇਕਮ੍ ਆਰੁਹ੍ਯ ਆਸ਼ਿਯਾਦੇਸ਼ਸ੍ਯ ਤਟਸਮੀਪੇਨ ਯਾਤੁੰ ਮਤਿੰ ਕ੍ਰੁʼਤ੍ਵਾ ਲਙ੍ਗਰਮ੍ ਉੱਥਾਪ੍ਯ ਪੋਤਮ੍ ਅਮੋਚਯਾਮ; ਮਾਕਿਦਨਿਯਾਦੇਸ਼ਸ੍ਥਥਿਸ਼਼ਲਨੀਕੀਨਿਵਾਸ੍ਯਾਰਿਸ੍ਤਾਰ੍ਖਨਾਮਾ ਕਸ਼੍ਚਿਦ੍ ਜਨੋ(ਅ)ਸ੍ਮਾਭਿਃ ਸਾਰ੍ੱਧਮ੍ ਆਸੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","ਪਰਸ੍ਮਿਨ੍ ਦਿਵਸੇ (ਅ)ਸ੍ਮਾਭਿਃ ਸੀਦੋੰਨਗਰੇ ਪੋਤੇ ਲਾਗਿਤੇ ਤਤ੍ਰ ਯੂਲਿਯਃ ਸੇਨਾਪਤਿਃ ਪੌਲੰ ਪ੍ਰਤਿ ਸੌਜਨ੍ਯੰ ਪ੍ਰਦਰ੍ਥ੍ਯ ਸਾਨ੍ਤ੍ਵਨਾਰ੍ਥੰ ਬਨ੍ਧੁਬਾਨ੍ਧਵਾਨ੍ ਉਪਯਾਤੁਮ੍ ਅਨੁਜਜ੍ਞੌ| ");
INSERT INTO sanpun_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","ਤਸ੍ਮਾਤ੍ ਪੋਤੇ ਮੋਚਿਤੇ ਸਤਿ ਸੰਮੁਖਵਾਯੋਃ ਸਮ੍ਭਵਾਦ੍ ਵਯੰ ਕੁਪ੍ਰੋਪਦ੍ਵੀਪਸ੍ਯ ਤੀਰਸਮੀਪੇਨ ਗਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","ਕਿਲਿਕਿਯਾਯਾਃ ਪਾਮ੍ਫੂਲਿਯਾਯਾਸ਼੍ਚ ਸਮੁਦ੍ਰਸ੍ਯ ਪਾਰੰ ਗਤ੍ਵਾ ਲੂਕਿਯਾਦੇਸ਼ਾਨ੍ਤਰ੍ਗਤੰ ਮੁਰਾਨਗਰਮ੍ ਉਪਾਤਿਸ਼਼੍ਠਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","ਤਤ੍ਸ੍ਥਾਨਾਦ੍ ਇਤਾਲਿਯਾਦੇਸ਼ੰ ਗੱਛਤਿ ਯਃ ਸਿਕਨ੍ਦਰਿਯਾਨਗਰਸ੍ਯ ਪੋਤਸ੍ਤੰ ਤਤ੍ਰ ਪ੍ਰਾਪ੍ਯ ਸ਼ਤਸੇਨਾਪਤਿਸ੍ਤੰ ਪੋਤਮ੍ ਅਸ੍ਮਾਨ੍ ਆਰੋਹਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","ਤਤਃ ਪਰੰ ਬਹੂਨਿ ਦਿਨਾਨਿ ਸ਼ਨੈਃ ਸ਼ਨੈਃ ਰ੍ਗਤ੍ਵਾ ਕ੍ਨੀਦਪਾਰ੍ਸ਼੍ਵੋਪਸ੍ਥ੍ਤਿेਃ ਪੂਰ੍ੱਵੰ ਪ੍ਰਤਿਕੂਲੇਨ ਪਵਨੇਨ ਵਯੰ ਸਲ੍ਮੋਨ੍ਯਾਃ ਸੰਮੁਖਮ੍ ਉਪਸ੍ਥਾਯ ਕ੍ਰੀਤ੍ਯੁਪਦ੍ਵੀਪਸ੍ਯ ਤੀਰਸਮੀਪੇਨ ਗਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","ਕਸ਼਼੍ਟੇਨ ਤਮੁੱਤੀਰ੍ੱਯ ਲਾਸੇਯਾਨਗਰਸ੍ਯਾਧਃ ਸੁਨ੍ਦਰਨਾਮਕੰ ਖਾਤਮ੍ ਉਪਾਤਿਸ਼਼੍ਠਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","ਇੱਥੰ ਬਹੁਤਿਥਃ ਕਾਲੋ ਯਾਪਿਤ ਉਪਵਾਸਦਿਨਞ੍ਚਾਤੀਤੰ, ਤਤ੍ਕਾਰਣਾਤ੍ ਨੌਵਰ੍ਤ੍ਮਨਿ ਭਯਙ੍ਕਰੇ ਸਤਿ ਪੌਲੋ ਵਿਨਯੇਨ ਕਥਿਤਵਾਨ੍, ");
INSERT INTO sanpun_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","ਹੇ ਮਹੇੱਛਾ ਅਹੰ ਨਿਸ਼੍ਚਯੰ ਜਾਨਾਮਿ ਯਾਤ੍ਰਾਯਾਮਸ੍ਯਾਮ੍ ਅਸ੍ਮਾਕੰ ਕ੍ਲੇਸ਼ਾ ਬਹੂਨਾਮਪਚਯਾਸ਼੍ਚ ਭਵਿਸ਼਼੍ਯਨ੍ਤਿ, ਤੇ ਕੇਵਲੰ ਪੋਤਸਾਮਗ੍ਰ੍ਯੋਰਿਤਿ ਨਹਿ, ਕਿਨ੍ਤ੍ਵਸ੍ਮਾਕੰ ਪ੍ਰਾਣਾਨਾਮਪਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","ਤਦਾ ਸ਼ਤਸੇਨਾਪਤਿਃ ਪੌैेਲੋਕ੍ਤਵਾਕ੍ਯਤੋਪਿ ਕਰ੍ਣਧਾਰਸ੍ਯ ਪੋਤਵਣਿਜਸ਼੍ਚ ਵਾਕ੍ਯੰ ਬਹੁਮੰਸ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","ਤਤ੍ ਖਾਤੰ ਸ਼ੀਤਕਾਲੇ ਵਾਸਾਰ੍ਹਸ੍ਥਾਨੰ ਨ ਤਸ੍ਮਾਦ੍ ਅਵਾਚੀਪ੍ਰਤੀਚੋਰ੍ਦਿਸ਼ੋਃ ਕ੍ਰੀਤ੍ਯਾਃ ਫੈਨੀਕਿਯਖਾਤੰ ਯਾਤੁੰ ਯਦਿ ਸ਼ਕ੍ਨੁਵਨ੍ਤਸ੍ਤਰ੍ਹਿ ਤਤ੍ਰ ਸ਼ੀਤਕਾਲੰ ਯਾਪਯਿਤੁੰ ਪ੍ਰਾਯੇਣ ਸਰ੍ੱਵੇ ਮਨ੍ਤ੍ਰਯਾਮਾਸੁਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","ਤਤਃ ਪਰੰ ਦਕ੍ਸ਼਼ਿਣਵਾਯੁ ਰ੍ਮਨ੍ਦੰ ਵਹਤੀਤਿ ਵਿਲੋਕ੍ਯ ਨਿਜਾਭਿਪ੍ਰਾਯਸ੍ਯ ਸਿੱਧੇਃ ਸੁਯੋਗੋ ਭਵਤੀਤਿ ਬੁੱਧ੍ਵਾ ਪੋਤੰ ਮੋਚਯਿਤ੍ਵਾ ਕ੍ਰੀਤ੍ਯੁਪਦ੍ਵੀਪਸ੍ਯ ਤੀਰਸਮੀਪੇਨ ਚਲਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","ਕਿਨ੍ਤ੍ਵਲ੍ਪਕ੍ਸ਼਼ਣਾਤ੍ ਪਰਮੇਵ ਉਰਕ੍ਲੁਦੋੰਨਾਮਾ ਪ੍ਰਤਿਕੂਲਃ ਪ੍ਰਚਣ੍ਡੋ ਵਾਯੁ ਰ੍ਵਹਨ੍ ਪੋਤੇ(ਅ)ਲਗੀਤ੍ ");
INSERT INTO sanpun_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","ਤਸ੍ਯਾਭਿਮੁਖੰ ਗਨ੍ਤੁਮ੍ ਪੋਤਸ੍ਯਾਸ਼ਕ੍ਤਤ੍ਵਾਦ੍ ਵਯੰ ਵਾਯੁਨਾ ਸ੍ਵਯੰ ਨੀਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","ਅਨਨ੍ਤਰੰ ਕ੍ਲੌਦੀਨਾਮ੍ਨ ਉਪਦ੍ਵੀਪਸ੍ਯ ਕੂਲਸਮੀਪੇਨ ਪੋਤੰ ਗਮਯਿਤ੍ਵਾ ਬਹੁਨਾ ਕਸ਼਼੍ਟੇਨ ਕ੍ਸ਼਼ੁਦ੍ਰਨਾਵਮ੍ ਅਰਕ੍ਸ਼਼ਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","ਤੇ ਤਾਮਾਰੁਹ੍ਯ ਰੱਜ੍ਚਾ ਪੋਤਸ੍ਯਾਧੋਭਾਗਮ੍ ਅਬਧ੍ਨਨ੍ ਤਦਨਨ੍ਤਰੰ ਚੇਤ੍ ਪੋਤੋ ਸੈਕਤੇ ਲਗਤੀਤਿ ਭਯਾਦ੍ ਵਾਤਵਸਨਾਨ੍ਯਮੋਚਯਨ੍ ਤਤਃ ਪੋਤੋ ਵਾਯੁਨਾ ਚਾਲਿਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","ਕਿਨ੍ਤੁ ਕ੍ਰਮਸ਼ੋ ਵਾਯੋਃ ਪ੍ਰਬਲਤ੍ਵਾਤ੍ ਪੋਤੋ ਦੋਲਾਯਮਾਨੋ(ਅ)ਭਵਤ੍ ਪਰਸ੍ਮਿਨ੍ ਦਿਵਸੇ ਪੋਤਸ੍ਥਾਨਿ ਕਤਿਪਯਾਨਿ ਦ੍ਰਵ੍ਯਾਣਿ ਤੋਯੇ ਨਿਕ੍ਸ਼਼ਿਪ੍ਤਾਨਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","ਤ੍ਰੁʼਤੀਯਦਿਵਸੇ ਵਯੰ ਸ੍ਵਹਸ੍ਤੈਃ ਪੋਤਸੱਜਨਦ੍ਰਵ੍ਯਾਣਿ ਨਿਕ੍ਸ਼਼ਿਪ੍ਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","ਤਤੋ ਬਹੁਦਿਨਾਨਿ ਯਾਵਤ੍ ਸੂਰ੍ੱਯਨਕ੍ਸ਼਼ਤ੍ਰਾਦੀਨਿ ਸਮਾੱਛੰਨਾਨਿ ਤਤੋ (ਅ)ਤੀਵ ਵਾਤ੍ਯਾਗਮਾਦ੍ ਅਸ੍ਮਾਕੰ ਪ੍ਰਾਣਰਕ੍ਸ਼਼ਾਯਾਃ ਕਾਪਿ ਪ੍ਰਤ੍ਯਾਸ਼ਾ ਨਾਤਿਸ਼਼੍ਠਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","ਬਹੁਦਿਨੇਸ਼਼ੁ ਲੋਕੈਰਨਾਹਾਰੇਣ ਯਾਪਿਤੇਸ਼਼ੁ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਸਾਕ੍ਸ਼਼ਤ੍ ਪੌਲਸ੍ਤਿਸ਼਼੍ਠਨ੍ ਅਕਥਯਤ੍, ਹੇ ਮਹੇੱਛਾਃ ਕ੍ਰੀਤ੍ਯੁਪਦ੍ਵੀਪਾਤ੍ ਪੋਤੰ ਨ ਮੋਚਯਿਤੁਮ੍ ਅਹੰ ਪੂਰ੍ੱਵੰ ਯਦ੍ ਅਵਦੰ ਤਦ੍ਗ੍ਰਹਣੰ ਯੁਸ਼਼੍ਮਾਕਮ੍ ਉਚਿਤਮ੍ ਆਸੀਤ੍ ਤਥਾ ਕ੍ਰੁʼਤੇ ਯੁਸ਼਼੍ਮਾਕਮ੍ ਏਸ਼਼ਾ ਵਿਪਦ੍ ਏਸ਼਼ੋ(ਅ)ਪਚਯਸ਼੍ਚ ਨਾਘਟਿਸ਼਼੍ਯੇਤਾਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","ਕਿਨ੍ਤੁ ਸਾਮ੍ਪ੍ਰਤੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਵਿਨੀਯ ਬ੍ਰਵੀਮ੍ਯਹੰ, ਯੂਯੰ ਨ ਕ੍ਸ਼਼ੁਭ੍ਯਤ ਯੁਸ਼਼੍ਮਾਕਮ੍ ਏਕਸ੍ਯਾਪਿ ਪ੍ਰਾਣਿਨੋ ਹਾਨਿ ਰ੍ਨ ਭਵਿਸ਼਼੍ਯਤਿ, ਕੇਵਲਸ੍ਯ ਪੋਤਸ੍ਯ ਹਾਨਿ ਰ੍ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","ਯਤੋ ਯਸ੍ਯੇਸ਼੍ਵਰਸ੍ਯ ਲੋਕੋ(ਅ)ਹੰ ਯਞ੍ਚਾਹੰ ਪਰਿਚਰਾਮਿ ਤਦੀਯ ਏਕੋ ਦੂਤੋ ਹ੍ਯੋ ਰਾਤ੍ਰੌ ਮਮਾਨ੍ਤਿਕੇ ਤਿਸ਼਼੍ਠਨ੍ ਕਥਿਤਵਾਨ੍, ");
INSERT INTO sanpun_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ਹੇ ਪੌਲ ਮਾ ਭੈਸ਼਼ੀਃ ਕੈਸਰਸ੍ਯ ਸੰਮੁਖੇ ਤ੍ਵਯੋਪਸ੍ਥਾਤਵ੍ਯੰ; ਤਵੈਤਾਨ੍ ਸਙ੍ਗਿਨੋ ਲੋਕਾਨ੍ ਈਸ਼੍ਵਰਸ੍ਤੁਭ੍ਯੰ ਦੱਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","ਅਤਏਵ ਹੇ ਮਹੇੱਛਾ ਯੂਯੰ ਸ੍ਥਿਰਮਨਸੋ ਭਵਤ ਮਹ੍ਯੰ ਯਾ ਕਥਾਕਥਿ ਸਾਵਸ਼੍ਯੰ ਘਟਿਸ਼਼੍ਯਤੇ ਮਮੈਤਾਦ੍ਰੁʼਸ਼ੀ ਵਿਸ਼੍ਵਾਸ ਈਸ਼੍ਵਰੇ ਵਿਦ੍ਯਤੇ, ");
INSERT INTO sanpun_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","ਕਿਨ੍ਤੁ ਕਸ੍ਯਚਿਦ੍ ਉਪਦ੍ਵੀਪਸ੍ਯੋਪਰਿ ਪਤਿਤਵ੍ਯਮ੍ ਅਸ੍ਮਾਭਿਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","ਤਤਃ ਪਰਮ੍ ਆਦ੍ਰਿਯਾਸਮੁਦ੍ਰੇ ਪੋਤਸ੍ਤਥੈਵ ਦੋਲਾਯਮਾਨਃ ਸਨ੍ ਇਤਸ੍ਤਤੋ ਗੱਛਨ੍ ਚਤੁਰ੍ਦਸ਼ਦਿਵਸਸ੍ਯ ਰਾਤ੍ਰੇ ਰ੍ਦ੍ਵਿਤੀਯਪ੍ਰਹਰਸਮਯੇ ਕਸ੍ਯਚਿਤ੍ ਸ੍ਥਲਸ੍ਯ ਸਮੀਪਮੁਪਤਿਸ਼਼੍ਠਤੀਤਿ ਪੋਤੀਯਲੋਕਾ ਅਨ੍ਵਮਨ੍ਯਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","ਤਤਸ੍ਤੇ ਜਲੰ ਪਰਿਮਾਯ ਤਤ੍ਰ ਵਿੰਸ਼ਤਿ ਰ੍ਵ੍ਯਾਮਾ ਜਲਾਨੀਤਿ ਜ੍ਞਾਤਵਨ੍ਤਃ| ਕਿਞ੍ਚਿੱਦੂਰੰ ਗਤ੍ਵਾ ਪੁਨਰਪਿ ਜਲੰ ਪਰਿਮਿਤਵਨ੍ਤਃ| ਤਤ੍ਰ ਪਞ੍ਚਦਸ਼ ਵ੍ਯਾਮਾ ਜਲਾਨਿ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ");
INSERT INTO sanpun_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","ਚੇਤ੍ ਪਾਸ਼਼ਾਣੇ ਲਗਤੀਤਿ ਭਯਾਤ੍ ਪੋਤਸ੍ਯ ਪਸ਼੍ਚਾਦ੍ਭਾਗਤਸ਼੍ਚਤੁਰੋ ਲਙ੍ਗਰਾਨ੍ ਨਿਕ੍ਸ਼਼ਿਪ੍ਯ ਦਿਵਾਕਰਮ੍ ਅਪੇਕ੍ਸ਼਼੍ਯ ਸਰ੍ੱਵੇ ਸ੍ਥਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","ਕਿਨ੍ਤੁ ਪੋਤੀਯਲੋਕਾਃ ਪੋਤਾਗ੍ਰਭਾਗੇ ਲਙ੍ਗਰਨਿਕ੍ਸ਼਼ੇਪੰ ਛਲੰ ਕ੍ਰੁʼਤ੍ਵਾ ਜਲਧੌ ਕ੍ਸ਼਼ੁਦ੍ਰਨਾਵਮ੍ ਅਵਰੋਹ੍ਯ ਪਲਾਯਿਤੁਮ੍ ਅਚੇਸ਼਼੍ਟਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","ਤਤਃ ਪੌਲਃ ਸੇਨਾਪਤਯੇ ਸੈਨ੍ਯਗਣਾਯ ਚ ਕਥਿਤਵਾਨ੍, ਏਤੇ ਯਦਿ ਪੋਤਮਧ੍ਯੇ ਨ ਤਿਸ਼਼੍ਠਨ੍ਤਿ ਤਰ੍ਹਿ ਯੁਸ਼਼੍ਮਾਕੰ ਰਕ੍ਸ਼਼ਣੰ ਨ ਸ਼ਕ੍ਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","ਤਦਾ ਸੇਨਾਗਣੋ ਰੱਜੂਨ੍ ਛਿਤ੍ਵਾ ਨਾਵੰ ਜਲੇ ਪਤਿਤੁਮ੍ ਅਦਦਾਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","ਪ੍ਰਭਾਤਸਮਯੇ ਪੌਲਃ ਸਰ੍ੱਵਾਨ੍ ਜਨਾਨ੍ ਭੋਜਨਾਰ੍ਥੰ ਪ੍ਰਾਰ੍ਥ੍ਯ ਵ੍ਯਾਹਰਤ੍, ਅਦ੍ਯ ਚਤੁਰ੍ਦਸ਼ਦਿਨਾਨਿ ਯਾਵਦ੍ ਯੂਯਮ੍ ਅਪੇਕ੍ਸ਼਼ਮਾਨਾ ਅਨਾਹਾਰਾਃ ਕਾਲਮ੍ ਅਯਾਪਯਤ ਕਿਮਪਿ ਨਾਭੁੰਗ੍ਧੰ| ");
INSERT INTO sanpun_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","ਅਤੋ ਵਿਨਯੇे(ਅ)ਹੰ ਭਕ੍ਸ਼਼੍ਯੰ ਭੁਜ੍ਯਤਾਂ ਤਤੋ ਯੁਸ਼਼੍ਮਾਕੰ ਮਙ੍ਗਲੰ ਭਵਿਸ਼਼੍ਯਤਿ, ਯੁਸ਼਼੍ਮਾਕੰ ਕਸ੍ਯਚਿੱਜਨਸ੍ਯ ਸ਼ਿਰਸਃ ਕੇਸ਼ੈਕੋਪਿ ਨ ਨੰਕ੍ਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","ਇਤਿ ਵ੍ਯਾਹ੍ਰੁʼਤ੍ਯ ਪੌਲੰ ਪੂਪੰ ਗ੍ਰੁʼਹੀਤ੍ਵੇਸ਼੍ਵਰੰ ਧਨ੍ਯੰ ਭਾਸ਼਼ਮਾਣਸ੍ਤੰ ਭੰਕ੍ਤ੍ਵਾ ਭੋਕ੍ਤੁਮ੍ ਆਰਬ੍ਧਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","ਅਨਨ੍ਤਰੰ ਸਰ੍ੱਵੇ ਚ ਸੁਸ੍ਥਿਰਾਃ ਸਨ੍ਤਃ ਖਾਦ੍ਯਾਨਿ ਪਰ੍ਪ੍ਯਗ੍ਰੁʼਹ੍ਲਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","ਅਸ੍ਮਾਕੰ ਪੋਤੇ ਸ਼਼ਟ੍ਸਪ੍ਤਤ੍ਯਧਿਕਸ਼ਤਦ੍ਵਯਲੋਕਾ ਆਸਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","ਸਰ੍ੱਵੇਸ਼਼ੁ ਲੋਕੇਸ਼਼ੁ ਯਥੇਸ਼਼੍ਟੰ ਭੁਕ੍ਤਵਤ੍ਸੁ ਪੋਤਸ੍ਥਨ੍ ਗੋਧੂਮਾਨ੍ ਜਲਧੌ ਨਿਕ੍ਸ਼਼ਿਪ੍ਯ ਤੈਃ ਪੋਤਸ੍ਯ ਭਾਰੋ ਲਘੂਕ੍ਰੁʼਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","ਦਿਨੇ ਜਾਤੇ(ਅ)ਪਿ ਸ ਕੋ ਦੇਸ਼ ਇਤਿ ਤਦਾ ਨ ਪਰ੍ੱਯਚੀਯਤ; ਕਿਨ੍ਤੁ ਤਤ੍ਰ ਸਮਤਟਮ੍ ਏਕੰ ਖਾਤੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਯਦਿ ਸ਼ਕ੍ਨੁਮਸ੍ਤਰ੍ਹਿ ਵਯੰ ਤਸ੍ਯਾਭ੍ਯਨ੍ਤਰੰ ਪੋਤੰ ਗਮਯਾਮ ਇਤਿ ਮਤਿੰ ਕ੍ਰੁʼਤ੍ਵਾ ਤੇ ਲਙ੍ਗਰਾਨ੍ ਛਿੱਤ੍ਵਾ ਜਲਧੌ ਤ੍ਯਕ੍ਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","ਤਥਾ ਕਰ੍ਣਬਨ੍ਧਨੰ ਮੋਚਯਿਤ੍ਵਾ ਪ੍ਰਧਾਨੰ ਵਾਤਵਸਨਮ੍ ਉੱਤੋਲ੍ਯ ਤੀਰਸਮੀਪੰ ਗਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","ਕਿਨ੍ਤੁ ਦ੍ਵਯੋਃ ਸਮੁਦ੍ਰਯੋਃ ਸਙ੍ਗਮਸ੍ਥਾਨੇ ਸੈਕਤੋਪਰਿ ਪੋਤੇ ਨਿਕ੍ਸ਼਼ਿਪ੍ਤੇ (ਅ)ਗ੍ਰਭਾਗੇ ਬਾਧਿਤੇ ਪਸ਼੍ਚਾਦ੍ਭਾਗੇ ਪ੍ਰਬਲਤਰਙ੍ਗੋ(ਅ)ਲਗਤ੍ ਤੇਨ ਪੋਤੋ ਭਗ੍ਨਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","ਤਸ੍ਮਾਦ੍ ਬਨ੍ਦਯਸ਼੍ਚੇਦ੍ ਬਾਹੁਭਿਸ੍ਤਰਨ੍ਤਃ ਪਲਾਯਨ੍ਤੇ ਇਤ੍ਯਾਸ਼ਙ੍ਕਯਾ ਸੇਨਾਗਣਸ੍ਤਾਨ੍ ਹਨ੍ਤੁਮ੍ ਅਮਨ੍ਤ੍ਰਯਤ੍; ");
INSERT INTO sanpun_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","ਕਿਨ੍ਤੁ ਸ਼ਤਸੇਨਾਪਤਿਃ ਪੌਲੰ ਰਕ੍ਸ਼਼ਿਤੁੰ ਪ੍ਰਯਤ੍ਨੰ ਕ੍ਰੁʼਤ੍ਵਾ ਤਾਨ੍ ਤੱਚੇਸ਼਼੍ਟਾਯਾ ਨਿਵਰ੍ਤ੍ਯ ਇਤ੍ਯਾਦਿਸ਼਼੍ਟਵਾਨ੍, ਯੇ ਬਾਹੁਤਰਣੰ ਜਾਨਨ੍ਤਿ ਤੇ(ਅ)ਗ੍ਰੇ ਪ੍ਰੋੱਲਮ੍ਪ੍ਯ ਸਮੁਦ੍ਰੇ ਪਤਿਤ੍ਵਾ ਬਾਹੁਭਿਸ੍ਤੀਰ੍ੱਤ੍ਵਾ ਕੂਲੰ ਯਾਨ੍ਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","ਅਪਰਮ੍ ਅਵਸ਼ਿਸ਼਼੍ਟਾ ਜਨਾਃ ਕਾਸ਼਼੍ਠੰ ਪੋਤੀਯੰ ਦ੍ਰਵ੍ਯੰ ਵਾ ਯੇਨ ਯਤ੍ ਪ੍ਰਾਪ੍ਯਤੇ ਤਦਵਲਮ੍ਬ੍ਯ ਯਾਨ੍ਤੁ; ਇੱਥੰ ਸਰ੍ੱਵੇ ਭੂਮਿੰ ਪ੍ਰਾਪ੍ਯ ਪ੍ਰਾਣੈ ਰ੍ਜੀਵਿਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","ਇੱਥੰ ਸਰ੍ੱਵੇਸ਼਼ੁ ਰਕ੍ਸ਼਼ਾਂ ਪ੍ਰਾਪ੍ਤੇਸ਼਼ੁ ਤਤ੍ਰਤ੍ਯੋਪਦ੍ਵੀਪਸ੍ਯ ਨਾਮ ਮਿਲੀਤੇਤਿ ਤੇ ਜ੍ਞਾਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","ਅਸਭ੍ਯਲੋਕਾ ਯਥੇਸ਼਼੍ਟਮ੍ ਅਨੁਕਮ੍ਪਾਂ ਕ੍ਰੁʼਤ੍ਵਾ ਵਰ੍ੱਤਮਾਨਵ੍ਰੁʼਸ਼਼੍ਟੇਃ ਸ਼ੀਤਾੱਚ ਵਹ੍ਨਿੰ ਪ੍ਰੱਜ੍ਵਾਲ੍ਯਾਸ੍ਮਾਕਮ੍ ਆਤਿਥ੍ਯਮ੍ ਅਕੁਰ੍ੱਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","ਕਿਨ੍ਤੁ ਪੌਲ ਇਨ੍ਧਨਾਨਿ ਸੰਗ੍ਰੁʼਹ੍ਯ ਯਦਾ ਤਸ੍ਮਿਨ੍ ਅਗ੍ਰੌ ਨਿਰਕ੍ਸ਼਼ਿਪਤ੍, ਤਦਾ ਵਹ੍ਨੇਃ ਪ੍ਰਤਾਪਾਤ੍ ਏਕਃ ਕ੍ਰੁʼਸ਼਼੍ਣਸਰ੍ਪੋ ਨਿਰ੍ਗਤ੍ਯ ਤਸ੍ਯ ਹਸ੍ਤੇ ਦ੍ਰਸ਼਼੍ਟਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","ਤੇ(ਅ)ਸਭ੍ਯਲੋਕਾਸ੍ਤਸ੍ਯ ਹਸ੍ਤੇ ਸਰ੍ਪਮ੍ ਅਵਲਮ੍ਬਮਾਨੰ ਦ੍ਰੁʼਸ਼਼੍ਟ੍ਵਾ ਪਰਸ੍ਪਰਮ੍ ਉਕ੍ਤਵਨ੍ਤ ਏਸ਼਼ ਜਨੋ(ਅ)ਵਸ਼੍ਯੰ ਨਰਹਾ ਭਵਿਸ਼਼੍ਯਤਿ, ਯਤੋ ਯਦ੍ਯਪਿ ਜਲਧੇ ਰਕ੍ਸ਼਼ਾਂ ਪ੍ਰਾਪ੍ਤਵਾਨ੍ ਤਥਾਪਿ ਪ੍ਰਤਿਫਲਦਾਯਕ ਏਨੰ ਜੀਵਿਤੁੰ ਨ ਦਦਾਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","ਕਿਨ੍ਤੁ ਸ ਹਸ੍ਤੰ ਵਿਧੁਨ੍ਵਨ੍ ਤੰ ਸਰ੍ਪਮ੍ ਅਗ੍ਨਿਮਧ੍ਯੇ ਨਿਕ੍ਸ਼਼ਿਪ੍ਯ ਕਾਮਪਿ ਪੀਡਾਂ ਨਾਪ੍ਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","ਤਤੋ ਵਿਸ਼਼ਜ੍ਵਾਲਯਾ ਏਤਸ੍ਯ ਸ਼ਰੀਰੰ ਸ੍ਫੀਤੰ ਭਵਿਸ਼਼੍ਯਤਿ ਯਦ੍ਵਾ ਹਠਾਦਯੰ ਪ੍ਰਾਣਾਨ੍ ਤ੍ਯਕ੍ਸ਼਼੍ਯਤੀਤਿ ਨਿਸ਼੍ਚਿਤ੍ਯ ਲੋਕਾ ਬਹੁਕ੍ਸ਼਼ਣਾਨਿ ਯਾਵਤ੍ ਤਦ੍ ਦ੍ਰਸ਼਼੍ਟੁੰ ਸ੍ਥਿਤਵਨ੍ਤਃ ਕਿਨ੍ਤੁ ਤਸ੍ਯ ਕਸ੍ਯਾਸ਼੍ਚਿਦ੍ ਵਿਪਦੋ(ਅ)ਘਟਨਾਤ੍ ਤੇ ਤਦ੍ਵਿਪਰੀਤੰ ਵਿਜ੍ਞਾਯ ਭਾਸ਼਼ਿਤਵਨ੍ਤ ਏਸ਼਼ ਕਸ਼੍ਚਿਦ੍ ਦੇਵੋ ਭਵੇਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","ਪੁਬ੍ਲਿਯਨਾਮਾ ਜਨ ਏਕਸ੍ਤਸ੍ਯੋਪਦ੍ਵੀਪਸ੍ਯਾਧਿਪਤਿਰਾਸੀਤ੍ ਤਤ੍ਰ ਤਸ੍ਯ ਭੂਮ੍ਯਾਦਿ ਚ ਸ੍ਥਿਤੰ| ਸ ਜਨੋ(ਅ)ਸ੍ਮਾਨ੍ ਨਿਜਗ੍ਰੁʼਹੰ ਨੀਤ੍ਵਾ ਸੌਜਨ੍ਯੰ ਪ੍ਰਕਾਸ਼੍ਯ ਦਿਨਤ੍ਰਯੰ ਯਾਵਦ੍ ਅਸ੍ਮਾਕੰ ਆਤਿਥ੍ਯਮ੍ ਅਕਰੋਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","ਤਦਾ ਤਸ੍ਯ ਪੁਬ੍ਲਿਯਸ੍ਯ ਪਿਤਾ ਜ੍ਵਰਾਤਿਸਾਰੇਣ ਪੀਡ੍ਯਮਾਨਃ ਸਨ੍ ਸ਼ੱਯਾਯਾਮ੍ ਆਸੀਤ੍; ਤਤਃ ਪੌਲਸ੍ਤਸ੍ਯ ਸਮੀਪੰ ਗਤ੍ਵਾ ਪ੍ਰਾਰ੍ਥਨਾਂ ਕ੍ਰੁʼਤ੍ਵਾ ਤਸ੍ਯ ਗਾਤ੍ਰੇ ਹਸ੍ਤੰ ਸਮਰ੍ਪ੍ਯ ਤੰ ਸ੍ਵਸ੍ਥੰ ਕ੍ਰੁʼਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","ਇੱਥੰ ਭੂਤੇ ਤਦ੍ਵੀਪਨਿਵਾਸਿਨ ਇਤਰੇਪਿ ਰੋਗਿਲੋਕਾ ਆਗਤ੍ਯ ਨਿਰਾਮਯਾ ਅਭਵਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","ਤਸ੍ਮਾੱਤੇ(ਅ)ਸ੍ਮਾਕਮ੍ ਅਤੀਵ ਸਤ੍ਕਾਰੰ ਕ੍ਰੁʼਤਵਨ੍ਤਃ, ਵਿਸ਼ੇਸ਼਼ਤਃ ਪ੍ਰਸ੍ਥਾਨਸਮਯੇ ਪ੍ਰਯੋਜਨੀਯਾਨਿ ਨਾਨਦ੍ਰਵ੍ਯਾਣਿ ਦੱਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","ਇੱਥੰ ਤਤ੍ਰ ਤ੍ਰਿਸ਼਼ੁ ਮਾਸੇਸ਼਼ੁ ਗਤੇਸ਼਼ੁ ਯਸ੍ਯ ਚਿਹ੍ਨੰ ਦਿਯਸ੍ਕੂਰੀ ਤਾਦ੍ਰੁʼਸ਼ ਏਕਃ ਸਿਕਨ੍ਦਰੀਯਨਗਰਸ੍ਯ ਪੋਤਃ ਸ਼ੀਤਕਾਲੰ ਯਾਪਯਨ੍ ਤਸ੍ਮਿਨ੍ ਉਪਦ੍ਵੀਪੇ (ਅ)ਤਿਸ਼਼੍ਠਤ੍ ਤਮੇਵ ਪੋਤੰ ਵਯਮ੍ ਆਰੁਹ੍ਯ ਯਾਤ੍ਰਾਮ੍ ਅਕੁਰ੍ੰਮ| ");
INSERT INTO sanpun_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","ਤਤਃ ਪ੍ਰਥਮਤਃ ਸੁਰਾਕੂਸਨਗਰਮ੍ ਉਪਸ੍ਥਾਯ ਤਤ੍ਰ ਤ੍ਰੀਣਿ ਦਿਨਾਨਿ ਸ੍ਥਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","ਤਸ੍ਮਾਦ੍ ਆਵ੍ਰੁʼਤ੍ਯ ਰੀਗਿਯਨਗਰਮ੍ ਉਪਸ੍ਥਿਤਾਃ ਦਿਨੈਕਸ੍ਮਾਤ੍ ਪਰੰ ਦਕ੍ਸ਼਼ਿਣਵਯੌ ਸਾਨੁਕੂਲ੍ਯੇ ਸਤਿ ਪਰਸ੍ਮਿਨ੍ ਦਿਵਸੇ ਪਤਿਯਲੀਨਗਰਮ੍ ਉਪਾਤਿਸ਼਼੍ਠਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","ਤਤੋ(ਅ)ਸ੍ਮਾਸੁ ਤਤ੍ਰਤ੍ਯੰ ਭ੍ਰਾਤ੍ਰੁʼਗਣੰ ਪ੍ਰਾਪ੍ਤੇਸ਼਼ੁ ਤੇ ਸ੍ਵੈਃ ਸਾਰ੍ੱਧਮ੍ ਅਸ੍ਮਾਨ੍ ਸਪ੍ਤ ਦਿਨਾਨਿ ਸ੍ਥਾਪਯਿਤੁਮ੍ ਅਯਤਨ੍ਤ, ਇੱਥੰ ਵਯੰ ਰੋਮਾਨਗਰਮ੍ ਪ੍ਰਤ੍ਯਗੱਛਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","ਤਸ੍ਮਾਤ੍ ਤਤ੍ਰਤ੍ਯਾਃ ਭ੍ਰਾਤਰੋ(ਅ)ਸ੍ਮਾਕਮ੍ ਆਗਮਨਵਾਰ੍ੱਤਾਂ ਸ਼੍ਰੁਤ੍ਵਾ ਆੱਪਿਯਫਰੰ ਤ੍ਰਿਸ਼਼੍ਟਾਵਰ੍ਣੀਞ੍ਚ ਯਾਵਦ੍ ਅਗ੍ਰੇਸਰਾਃ ਸਨ੍ਤੋਸ੍ਮਾਨ੍ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਕਰ੍ੱਤੁਮ੍ ਆਗਮਨ੍; ਤੇਸ਼਼ਾਂ ਦਰ੍ਸ਼ਨਾਤ੍ ਪੌਲ ਈਸ਼੍ਵਰੰ ਧਨ੍ਯੰ ਵਦਨ੍ ਆਸ਼੍ਵਾਸਮ੍ ਆਪ੍ਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","ਅਸ੍ਮਾਸੁ ਰੋਮਾਨਗਰੰ ਗਤੇਸ਼਼ੁ ਸ਼ਤਸੇਨਾਪਤਿਃ ਸਰ੍ੱਵਾਨ੍ ਬਨ੍ਦੀਨ੍ ਪ੍ਰਧਾਨਸੇਨਾਪਤੇਃ ਸਮੀਪੇ ਸਮਾਰ੍ਪਯਤ੍ ਕਿਨ੍ਤੁ ਪੌਲਾਯ ਸ੍ਵਰਕ੍ਸ਼਼ਕਪਦਾਤਿਨਾ ਸਹ ਪ੍ਰੁʼਥਗ੍ ਵਸ੍ਤੁਮ੍ ਅਨੁਮਤਿੰ ਦੱਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","ਦਿਨਤ੍ਰਯਾਤ੍ ਪਰੰ ਪੌਲਸ੍ਤੱਦੇਸ਼ਸ੍ਥਾਨ੍ ਪ੍ਰਧਾਨਯਿਹੂਦਿਨ ਆਹੂਤਵਾਨ੍ ਤਤਸ੍ਤੇਸ਼਼ੁ ਸਮੁਪਸ੍ਥਿਤੇਸ਼਼ੁ ਸ ਕਥਿਤਵਾਨ੍, ਹੇ ਭ੍ਰਾਤ੍ਰੁʼਗਣ ਨਿਜਲੋਕਾਨਾਂ ਪੂਰ੍ੱਵਪੁਰੁਸ਼਼ਾਣਾਂ ਵਾ ਰੀਤੇ ਰ੍ਵਿਪਰੀਤੰ ਕਿਞ੍ਚਨ ਕਰ੍ੰਮਾਹੰ ਨਾਕਰਵੰ ਤਥਾਪਿ ਯਿਰੂਸ਼ਾਲਮਨਿਵਾਸਿਨੋ ਲੋਕਾ ਮਾਂ ਬਨ੍ਦਿੰ ਕ੍ਰੁʼਤ੍ਵਾ ਰੋਮਿਲੋਕਾਨਾਂ ਹਸ੍ਤੇਸ਼਼ੁ ਸਮਰ੍ਪਿਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","ਰੋਮਿਲੋਕਾ ਵਿਚਾਰ੍ੱਯ ਮਮ ਪ੍ਰਾਣਹਨਨਾਰ੍ਹੰ ਕਿਮਪਿ ਕਾਰਣੰ ਨ ਪ੍ਰਾਪ੍ਯ ਮਾਂ ਮੋਚਯਿਤੁਮ੍ ਐੱਛਨ੍; ");
INSERT INTO sanpun_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","ਕਿਨ੍ਤੁ ਯਿਹੂਦਿਲੋਕਾਨਾਮ੍ ਆਪੱਤ੍ਯਾ ਮਯਾ ਕੈਸਰਰਾਜਸ੍ਯ ਸਮੀਪੇ ਵਿਚਾਰਸ੍ਯ ਪ੍ਰਾਰ੍ਥਨਾ ਕਰ੍ੱਤਵ੍ਯਾ ਜਾਤਾ ਨੋਚੇਤ੍ ਨਿਜਦੇਸ਼ੀਯਲੋਕਾਨ੍ ਪ੍ਰਤਿ ਮਮ ਕੋਪ੍ਯਭਿਯੋਗੋ ਨਾਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","ਏਤਤ੍ਕਾਰਣਾਦ੍ ਅਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਦ੍ਰਸ਼਼੍ਟੁੰ ਸੰਲਪਿਤੁਞ੍ਚਾਹੂਯਮ੍ ਇਸ੍ਰਾਯੇਲ੍ਵਸ਼ੀਯਾਨਾਂ ਪ੍ਰਤ੍ਯਾਸ਼ਾਹੇਤੋਹਮ੍ ਏਤੇਨ ਸ਼ੁਙ੍ਖਲੇਨ ਬੱਧੋ(ਅ)ਭਵਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","ਤਦਾ ਤੇ ਤਮ੍ ਅਵਾਦਿਸ਼਼ੁਃ, ਯਿਹੂਦੀਯਦੇਸ਼ਾਦ੍ ਵਯੰ ਤ੍ਵਾਮਧਿ ਕਿਮਪਿ ਪਤ੍ਰੰ ਨ ਪ੍ਰਾਪ੍ਤਾ ਯੇ ਭ੍ਰਾਤਰਃ ਸਮਾਯਾਤਾਸ੍ਤੇਸ਼਼ਾਂ ਕੋਪਿ ਤਵ ਕਾਮਪਿ ਵਾਰ੍ੱਤਾਂ ਨਾਵਦਤ੍ ਅਭਦ੍ਰਮਪਿ ਨਾਕਥਯੱਚ| ");
INSERT INTO sanpun_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","ਤਵ ਮਤੰ ਕਿਮਿਤਿ ਵਯੰ ਤ੍ਵੱਤਃ ਸ਼੍ਰੋਤੁਮਿੱਛਾਮਃ| ਯਦ੍ ਇਦੰ ਨਵੀਨੰ ਮਤਮੁੱਥਿਤੰ ਤਤ੍ ਸਰ੍ੱਵਤ੍ਰ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਨਿਕਟੇ ਨਿਨ੍ਦਿਤੰ ਜਾਤਮ ਇਤਿ ਵਯੰ ਜਾਨੀਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","ਤੈਸ੍ਤਦਰ੍ਥਮ੍ ਏਕਸ੍ਮਿਨ੍ ਦਿਨੇ ਨਿਰੂਪਿਤੇ ਤਸ੍ਮਿਨ੍ ਦਿਨੇ ਬਹਵ ਏਕਤ੍ਰ ਮਿਲਿਤ੍ਵਾ ਪੌਲਸ੍ਯ ਵਾਸਗ੍ਰੁʼਹਮ੍ ਆਗੱਛਨ੍ ਤਸ੍ਮਾਤ੍ ਪੌਲ ਆ ਪ੍ਰਾਤਃਕਾਲਾਤ੍ ਸਨ੍ਧ੍ਯਾਕਾਲੰ ਯਾਵਨ੍ ਮੂਸਾਵ੍ਯਵਸ੍ਥਾਗ੍ਰਨ੍ਥਾਦ੍ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਾਂ ਗ੍ਰਨ੍ਥੇਭ੍ਯਸ਼੍ਚ ਯੀਸ਼ੋਃ ਕਥਾਮ੍ ਉੱਥਾਪ੍ਯ ਈਸ਼੍ਵਰਸ੍ਯ ਰਾਜ੍ਯੇ ਪ੍ਰਮਾਣੰ ਦਤ੍ਵਾ ਤੇਸ਼਼ਾਂ ਪ੍ਰਵ੍ਰੁʼੱਤਿੰ ਜਨਯਿਤੁੰ ਚੇਸ਼਼੍ਟਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","ਕੇਚਿੱਤੁ ਤਸ੍ਯ ਕਥਾਂ ਪ੍ਰਤ੍ਯਾਯਨ੍ ਕੇਚਿੱਤੁ ਨ ਪ੍ਰਤ੍ਯਾਯਨ੍; ");
INSERT INTO sanpun_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","ਏਤਤ੍ਕਾਰਣਾਤ੍ ਤੇਸ਼਼ਾਂ ਪਰਸ੍ਪਰਮ੍ ਅਨੈਕ੍ਯਾਤ੍ ਸਰ੍ੱਵੇ ਚਲਿਤਵਨ੍ਤਃ; ਤਥਾਪਿ ਪੌਲ ਏਤਾਂ ਕਥਾਮੇਕਾਂ ਕਥਿਤਵਾਨ੍ ਪਵਿਤ੍ਰ ਆਤ੍ਮਾ ਯਿਸ਼ਯਿਯਸ੍ਯ ਭਵਿਸ਼਼੍ਯਦ੍ਵਕ੍ਤੁ ਰ੍ਵਦਨਾਦ੍ ਅਸ੍ਮਾਕੰ ਪਿਤ੍ਰੁʼਪੁਰੁਸ਼਼ੇਭ੍ਯ ਏਤਾਂ ਕਥਾਂ ਭਦ੍ਰੰ ਕਥਯਾਮਾਸ, ਯਥਾ, ");
INSERT INTO sanpun_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","\"ਉਪਗਤ੍ਯ ਜਨਾਨੇਤਾਨ੍ ਤ੍ਵੰ ਭਾਸ਼਼ਸ੍ਵ ਵਚਸ੍ਤ੍ਵਿਦੰ| ਕਰ੍ਣੈਃ ਸ਼੍ਰੋਸ਼਼੍ਯਥ ਯੂਯੰ ਹਿ ਕਿਨ੍ਤੁ ਯੂਯੰ ਨ ਭੋਤ੍ਸ੍ਯਥ| ਨੇਤ੍ਰੈ ਰ੍ਦ੍ਰਕ੍ਸ਼਼੍ਯਥ ਯੂਯਞ੍ਚ ਜ੍ਞਾਤੁੰ ਯੂਯੰ ਨ ਸ਼ਕ੍ਸ਼਼੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","ਤੇ ਮਾਨੁਸ਼਼ਾ ਯਥਾ ਨੇਤ੍ਰੈਃ ਪਰਿਪਸ਼੍ਯਨ੍ਤਿ ਨੈਵ ਹਿ| ਕਰ੍ਣੈਃ ਰ੍ਯਥਾ ਨ ਸ਼੍ਰੁʼਣ੍ਵਨ੍ਤਿ ਬੁਧ੍ਯਨ੍ਤੇ ਨ ਚ ਮਾਨਸੈਃ| ਵ੍ਯਾਵਰ੍ੱਤਯਤ੍ਸੁ ਚਿੱਤਾਨਿ ਕਾਲੇ ਕੁਤ੍ਰਾਪਿ ਤੇਸ਼਼ੁ ਵੈ| ਮੱਤਸ੍ਤੇ ਮਨੁਜਾਃ ਸ੍ਵਸ੍ਥਾ ਯਥਾ ਨੈਵ ਭਵਨ੍ਤਿ ਚ| ਤਥਾ ਤੇਸ਼਼ਾਂ ਮਨੁਸ਼਼੍ਯਾਣਾਂ ਸਨ੍ਤਿ ਸ੍ਥੂਲਾ ਹਿ ਬੁੱਧਯਃ| ਬਧਿਰੀਭੂਤਕਰ੍ਣਾਸ਼੍ਚ ਜਾਤਾਸ਼੍ਚ ਮੁਦ੍ਰਿਤਾ ਦ੍ਰੁʼਸ਼ਃ|| ");
INSERT INTO sanpun_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","ਅਤ ਈਸ਼੍ਵਰਾਦ੍ ਯਤ੍ ਪਰਿਤ੍ਰਾਣੰ ਤਸ੍ਯ ਵਾਰ੍ੱਤਾ ਭਿੰਨਦੇਸ਼ੀਯਾਨਾਂ ਸਮੀਪੰ ਪ੍ਰੇਸ਼਼ਿਤਾ ਤਏਵ ਤਾਂ ਗ੍ਰਹੀਸ਼਼੍ਯਨ੍ਤੀਤਿ ਯੂਯੰ ਜਾਨੀਤ| ");
INSERT INTO sanpun_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","ਏਤਾਦ੍ਰੁʼਸ਼੍ਯਾਂ ਕਥਾਯਾਂ ਕਥਿਤਾਯਾਂ ਸਤ੍ਯਾਂ ਯਿਹੂਦਿਨਃ ਪਰਸ੍ਪਰੰ ਬਹੁਵਿਚਾਰੰ ਕੁਰ੍ੱਵਨ੍ਤੋ ਗਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","ਇੱਥੰ ਪੌਲਃ ਸਮ੍ਪੂਰ੍ਣੰ ਵਤ੍ਸਰਦ੍ਵਯੰ ਯਾਵਦ੍ ਭਾਟਕੀਯੇ ਵਾਸਗ੍ਰੁʼਹੇ ਵਸਨ੍ ਯੇ ਲੋਕਾਸ੍ਤਸ੍ਯ ਸੰਨਿਧਿਮ੍ ਆਗੱਛਨ੍ਤਿ ਤਾਨ੍ ਸਰ੍ੱਵਾਨੇਵ ਪਰਿਗ੍ਰੁʼਹ੍ਲਨ੍, ");
INSERT INTO sanpun_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","ਨਿਰ੍ਵਿਘ੍ਨਮ੍ ਅਤਿਸ਼ਯਨਿਃਕ੍ਸ਼਼ੋਭਮ੍ ਈਸ਼੍ਵਰੀਯਰਾਜਤ੍ਵਸ੍ਯ ਕਥਾਂ ਪ੍ਰਚਾਰਯਨ੍ ਪ੍ਰਭੌ ਯੀਸ਼ੌ ਖ੍ਰੀਸ਼਼੍ਟੇ ਕਥਾਃ ਸਮੁਪਾਦਿਸ਼ਤ੍| ਇਤਿ||");
INSERT INTO sanpun_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","ਈਸ਼੍ਵਰੋ ਨਿਜਪੁਤ੍ਰਮਧਿ ਯੰ ਸੁਸੰਵਾਦੰ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਭਿ ਰ੍ਧਰ੍ੰਮਗ੍ਰਨ੍ਥੇ ਪ੍ਰਤਿਸ਼੍ਰੁਤਵਾਨ੍ ਤੰ ਸੁਸੰਵਾਦੰ ਪ੍ਰਚਾਰਯਿਤੁੰ ਪ੍ਰੁʼਥੱਕ੍ਰੁʼਤ ਆਹੂਤਃ ਪ੍ਰੇਰਿਤਸ਼੍ਚ ਪ੍ਰਭੋ ਰ੍ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਸੇਵਕੋ ਯਃ ਪੌਲਃ ");
INSERT INTO sanpun_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","ਸ ਰੋਮਾਨਗਰਸ੍ਥਾਨ੍ ਈਸ਼੍ਵਰਪ੍ਰਿਯਾਨ੍ ਆਹੂਤਾਂਸ਼੍ਚ ਪਵਿਤ੍ਰਲੋਕਾਨ੍ ਪ੍ਰਤਿ ਪਤ੍ਰੰ ਲਿਖਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","ਅਸ੍ਮਾਕੰ ਸ ਪ੍ਰਭੁ ਰ੍ਯੀਸ਼ੁਃ ਖ੍ਰੀਸ਼਼੍ਟਃ ਸ਼ਾਰੀਰਿਕਸਮ੍ਬਨ੍ਧੇਨ ਦਾਯੂਦੋ ਵੰਸ਼ੋਦ੍ਭਵਃ ");
INSERT INTO sanpun_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","ਪਵਿਤ੍ਰਸ੍ਯਾਤ੍ਮਨਃ ਸਮ੍ਬਨ੍ਧੇਨ ਚੇਸ਼੍ਵਰਸ੍ਯ ਪ੍ਰਭਾਵਵਾਨ੍ ਪੁਤ੍ਰ ਇਤਿ ਸ਼੍ਮਸ਼ਾਨਾਤ੍ ਤਸ੍ਯੋੱਥਾਨੇਨ ਪ੍ਰਤਿਪੰਨੰ| ");
INSERT INTO sanpun_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","ਅਪਰੰ ਯੇਸ਼਼ਾਂ ਮਧ੍ਯੇ ਯੀਸ਼ੁਨਾ ਖ੍ਰੀਸ਼਼੍ਟੇਨ ਯੂਯਮਪ੍ਯਾਹੂਤਾਸ੍ਤੇ (ਅ)ਨ੍ਯਦੇਸ਼ੀਯਲੋਕਾਸ੍ਤਸ੍ਯ ਨਾਮ੍ਨਿ ਵਿਸ਼੍ਵਸ੍ਯ ਨਿਦੇਸ਼ਗ੍ਰਾਹਿਣੋ ਯਥਾ ਭਵਨ੍ਤਿ ");
INSERT INTO sanpun_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","ਤਦਭਿਪ੍ਰਾਯੇਣ ਵਯੰ ਤਸ੍ਮਾਦ੍ ਅਨੁਗ੍ਰਹੰ ਪ੍ਰੇਰਿਤਤ੍ਵਪਦਞ੍ਚ ਪ੍ਰਾਪ੍ਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","ਤਾਤੇਨਾਸ੍ਮਾਕਮ੍ ਈਸ਼੍ਵਰੇਣ ਪ੍ਰਭੁਣਾ ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟੇਨ ਚ ਯੁਸ਼਼੍ਮਭ੍ਯਮ੍ ਅਨੁਗ੍ਰਹਃ ਸ਼ਾਨ੍ਤਿਸ਼੍ਚ ਪ੍ਰਦੀਯੇਤਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","ਪ੍ਰਥਮਤਃ ਸਰ੍ੱਵਸ੍ਮਿਨ੍ ਜਗਤਿ ਯੁਸ਼਼੍ਮਾਕੰ ਵਿਸ਼੍ਵਾਸਸ੍ਯ ਪ੍ਰਕਾਸ਼ਿਤਤ੍ਵਾਦ੍ ਅਹੰ ਯੁਸ਼਼੍ਮਾਕੰ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਨਿਮਿੱਤੰ ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਨਾਮ ਗ੍ਰੁʼਹ੍ਲਨ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਧਨ੍ਯਵਾਦੰ ਕਰੋਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","ਅਪਰਮ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਪ੍ਰਸਾਦਾਦ੍ ਬਹੁਕਾਲਾਤ੍ ਪਰੰ ਸਾਮ੍ਪ੍ਰਤੰ ਯੁਸ਼਼੍ਮਾਕੰ ਸਮੀਪੰ ਯਾਤੁੰ ਕਥਮਪਿ ਯਤ੍ ਸੁਯੋਗੰ ਪ੍ਰਾਪ੍ਨੋਮਿ, ਏਤਦਰ੍ਥੰ ਨਿਰਨ੍ਤਰੰ ਨਾਮਾਨ੍ਯੁੱਚਾਰਯਨ੍ ਨਿਜਾਸੁ ਸਰ੍ੱਵਪ੍ਰਾਰ੍ਥਨਾਸੁ ਸਰ੍ੱਵਦਾ ਨਿਵੇਦਯਾਮਿ, ");
INSERT INTO sanpun_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ਏਤਸ੍ਮਿਨ੍ ਯਮਹੰ ਤਤ੍ਪੁਤ੍ਰੀਯਸੁਸੰਵਾਦਪ੍ਰਚਾਰਣੇਨ ਮਨਸਾ ਪਰਿਚਰਾਮਿ ਸ ਈਸ਼੍ਵਰੋ ਮਮ ਸਾਕ੍ਸ਼਼ੀ ਵਿਦ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","ਯਤੋ ਯੁਸ਼਼੍ਮਾਕੰ ਮਮ ਚ ਵਿਸ਼੍ਵਾਸੇਨ ਵਯਮ੍ ਉਭਯੇ ਯਥਾ ਸ਼ਾਨ੍ਤਿਯੁਕ੍ਤਾ ਭਵਾਮ ਇਤਿ ਕਾਰਣਾਦ੍ ");
INSERT INTO sanpun_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","ਯੁਸ਼਼੍ਮਾਕੰ ਸ੍ਥੈਰ੍ੱਯਕਰਣਾਰ੍ਥੰ ਯੁਸ਼਼੍ਮਭ੍ਯੰ ਕਿਞ੍ਚਿਤ੍ਪਰਮਾਰ੍ਥਦਾਨਦਾਨਾਯ ਯੁਸ਼਼੍ਮਾਨ੍ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਕਰ੍ੱਤੁੰ ਮਦੀਯਾ ਵਾਞ੍ਛਾ| ");
INSERT INTO sanpun_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","ਹੇ ਭ੍ਰਾਤ੍ਰੁʼਗਣ ਭਿੰਨਦੇਸ਼ੀਯਲੋਕਾਨਾਂ ਮਧ੍ਯੇ ਯਦ੍ਵਤ੍ ਤਦ੍ਵਦ੍ ਯੁਸ਼਼੍ਮਾਕੰ ਮਧ੍ਯੇਪਿ ਯਥਾ ਫਲੰ ਭੁਞ੍ਜੇ ਤਦਭਿਪ੍ਰਾਯੇਣ ਮੁਹੁਰ੍ਮੁਹੁ ਰ੍ਯੁਸ਼਼੍ਮਾਕੰ ਸਮੀਪੰ ਗਨ੍ਤੁਮ੍ ਉਦ੍ਯਤੋ(ਅ)ਹੰ ਕਿਨ੍ਤੁ ਯਾਵਦ੍ ਅਦ੍ਯ ਤਸ੍ਮਿਨ੍ ਗਮਨੇ ਮਮ ਵਿਘ੍ਨੋ ਜਾਤ ਇਤਿ ਯੂਯੰ ਯਦ੍ ਅਜ੍ਞਾਤਾਸ੍ਤਿਸ਼਼੍ਠਥ ਤਦਹਮ੍ ਉਚਿਤੰ ਨ ਬੁਧ੍ਯੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","ਅਹੰ ਸਭ੍ਯਾਸਭ੍ਯਾਨਾਂ ਵਿਦ੍ਵਦਵਿਦ੍ਵਤਾਞ੍ਚ ਸਰ੍ੱਵੇਸ਼਼ਾਮ੍ ਰੁʼਣੀ ਵਿਦ੍ਯੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","ਅਤਏਵ ਰੋਮਾਨਿਵਾਸਿਨਾਂ ਯੁਸ਼਼੍ਮਾਕੰ ਸਮੀਪੇ(ਅ)ਪਿ ਯਥਾਸ਼ਕ੍ਤਿ ਸੁਸੰਵਾਦੰ ਪ੍ਰਚਾਰਯਿਤੁਮ੍ ਅਹਮ੍ ਉਦ੍ਯਤੋਸ੍ਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","ਯਤਃ ਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਸੁਸੰਵਾਦੋ ਮਮ ਲੱਜਾਸ੍ਪਦੰ ਨਹਿ ਸ ਈਸ਼੍ਵਰਸ੍ਯ ਸ਼ਕ੍ਤਿਸ੍ਵਰੂਪਃ ਸਨ੍ ਆ ਯਿਹੂਦੀਯੇਭ੍ਯੋ (ਅ)ਨ੍ਯਜਾਤੀਯਾਨ੍ ਯਾਵਤ੍ ਸਰ੍ੱਵਜਾਤੀਯਾਨਾਂ ਮਧ੍ਯੇ ਯਃ ਕਸ਼੍ਚਿਦ੍ ਤਤ੍ਰ ਵਿਸ਼੍ਵਸਿਤਿ ਤਸ੍ਯੈਵ ਤ੍ਰਾਣੰ ਜਨਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","ਯਤਃ ਪ੍ਰਤ੍ਯਯਸ੍ਯ ਸਮਪਰਿਮਾਣਮ੍ ਈਸ਼੍ਵਰਦੱਤੰ ਪੁਣ੍ਯੰ ਤਤ੍ਸੁਸੰਵਾਦੇ ਪ੍ਰਕਾਸ਼ਤੇ| ਤਦਧਿ ਧਰ੍ੰਮਪੁਸ੍ਤਕੇਪਿ ਲਿਖਿਤਮਿਦੰ \"ਪੁਣ੍ਯਵਾਨ੍ ਜਨੋ ਵਿਸ਼੍ਵਾਸੇਨ ਜੀਵਿਸ਼਼੍ਯਤਿ\"| ");
INSERT INTO sanpun_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","ਅਤਏਵ ਯੇ ਮਾਨਵਾਃ ਪਾਪਕਰ੍ੰਮਣਾ ਸਤ੍ਯਤਾਂ ਰੁਨ੍ਧਨ੍ਤਿ ਤੇਸ਼਼ਾਂ ਸਰ੍ੱਵਸ੍ਯ ਦੁਰਾਚਰਣਸ੍ਯਾਧਰ੍ੰਮਸ੍ਯ ਚ ਵਿਰੁੱਧੰ ਸ੍ਵਰ੍ਗਾਦ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਕੋਪਃ ਪ੍ਰਕਾਸ਼ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","ਯਤ ਈਸ਼੍ਵਰਮਧਿ ਯਦ੍ਯਦ੍ ਜ੍ਞੇਯੰ ਤਦ੍ ਈਸ਼੍ਵਰਃ ਸ੍ਵਯੰ ਤਾਨ੍ ਪ੍ਰਤਿ ਪ੍ਰਕਾਸ਼ਿਤਵਾਨ੍ ਤਸ੍ਮਾਤ੍ ਤੇਸ਼਼ਾਮ੍ ਅਗੋਚਰੰ ਨਹਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","ਫਲਤਸ੍ਤਸ੍ਯਾਨਨ੍ਤਸ਼ਕ੍ਤੀਸ਼੍ਵਰਤ੍ਵਾਦੀਨ੍ਯਦ੍ਰੁʼਸ਼੍ਯਾਨ੍ਯਪਿ ਸ੍ਰੁʼਸ਼਼੍ਟਿਕਾਲਮ੍ ਆਰਭ੍ਯ ਕਰ੍ੰਮਸੁ ਪ੍ਰਕਾਸ਼ਮਾਨਾਨਿ ਦ੍ਰੁʼਸ਼੍ਯਨ੍ਤੇ ਤਸ੍ਮਾਤ੍ ਤੇਸ਼਼ਾਂ ਦੋਸ਼਼ਪ੍ਰਕ੍ਸ਼਼ਾਲਨਸ੍ਯ ਪਨ੍ਥਾ ਨਾਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","ਅਪਰਮ੍ ਈਸ਼੍ਵਰੰ ਜ੍ਞਾਤ੍ਵਾਪਿ ਤੇ ਤਮ੍ ਈਸ਼੍ਵਰਜ੍ਞਾਨੇਨ ਨਾਦ੍ਰਿਯਨ੍ਤ ਕ੍ਰੁʼਤਜ੍ਞਾ ਵਾ ਨ ਜਾਤਾਃ; ਤਸ੍ਮਾਤ੍ ਤੇਸ਼਼ਾਂ ਸਰ੍ੱਵੇ ਤਰ੍ਕਾ ਵਿਫਲੀਭੂਤਾਃ, ਅਪਰਞ੍ਚ ਤੇਸ਼਼ਾਂ ਵਿਵੇਕਸ਼ੂਨ੍ਯਾਨਿ ਮਨਾਂਸਿ ਤਿਮਿਰੇ ਮਗ੍ਨਾਨਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","ਤੇ ਸ੍ਵਾਨ੍ ਜ੍ਞਾਨਿਨੋ ਜ੍ਞਾਤ੍ਵਾ ਜ੍ਞਾਨਹੀਨਾ ਅਭਵਨ੍ ");
INSERT INTO sanpun_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","ਅਨਸ਼੍ਵਰਸ੍ਯੇਸ਼੍ਵਰਸ੍ਯ ਗੌਰਵੰ ਵਿਹਾਯ ਨਸ਼੍ਵਰਮਨੁਸ਼਼੍ਯਪਸ਼ੁਪਕ੍ਸ਼਼੍ਯੁਰੋਗਾਮਿਪ੍ਰਭ੍ਰੁʼਤੇਰਾਕ੍ਰੁʼਤਿਵਿਸ਼ਿਸ਼਼੍ਟਪ੍ਰਤਿਮਾਸ੍ਤੈਰਾਸ਼੍ਰਿਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","ਇੱਥੰ ਤ ਈਸ਼੍ਵਰਸ੍ਯ ਸਤ੍ਯਤਾਂ ਵਿਹਾਯ ਮ੍ਰੁʼਸ਼਼ਾਮਤਮ੍ ਆਸ਼੍ਰਿਤਵਨ੍ਤਃ ਸੱਚਿਦਾਨਨ੍ਦੰ ਸ੍ਰੁʼਸ਼਼੍ਟਿਕਰ੍ੱਤਾਰੰ ਤ੍ਯਕ੍ਤ੍ਵਾ ਸ੍ਰੁʼਸ਼਼੍ਟਵਸ੍ਤੁਨਃ ਪੂਜਾਂ ਸੇਵਾਞ੍ਚ ਕ੍ਰੁʼਤਵਨ੍ਤਃ; ");
INSERT INTO sanpun_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","ਇਤਿ ਹੇਤੋਰੀਸ਼੍ਵਰਸ੍ਤਾਨ੍ ਕੁਕ੍ਰਿਯਾਯਾਂ ਸਮਰ੍ਪ੍ਯ ਨਿਜਨਿਜਕੁਚਿਨ੍ਤਾਭਿਲਾਸ਼਼ਾਭ੍ਯਾਂ ਸ੍ਵੰ ਸ੍ਵੰ ਸ਼ਰੀਰੰ ਪਰਸ੍ਪਰਮ੍ ਅਪਮਾਨਿਤੰ ਕਰ੍ੱਤੁਮ੍ ਅਦਦਾਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","ਈਸ਼੍ਵਰੇਣ ਤੇਸ਼਼ੁ ਕ੍ਵਭਿਲਾਸ਼਼ੇ ਸਮਰ੍ਪਿਤੇਸ਼਼ੁ ਤੇਸ਼਼ਾਂ ਯੋਸ਼਼ਿਤਃ ਸ੍ਵਾਭਾਵਿਕਾਚਰਣਮ੍ ਅਪਹਾਯ ਵਿਪਰੀਤਕ੍ਰੁʼਤ੍ਯੇ ਪ੍ਰਾਵਰ੍ੱਤਨ੍ਤ; ");
INSERT INTO sanpun_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","ਤਥਾ ਪੁਰੁਸ਼਼ਾ ਅਪਿ ਸ੍ਵਾਭਾਵਿਕਯੋਸ਼਼ਿਤ੍ਸਙ੍ਗਮੰ ਵਿਹਾਯ ਪਰਸ੍ਪਰੰ ਕਾਮਕ੍ਰੁʼਸ਼ਾਨੁਨਾ ਦਗ੍ਧਾਃ ਸਨ੍ਤਃ ਪੁਮਾਂਸਃ ਪੁੰਭਿਃ ਸਾਕੰ ਕੁਕ੍ਰੁʼਤ੍ਯੇ ਸਮਾਸਜ੍ਯ ਨਿਜਨਿਜਭ੍ਰਾਨ੍ਤੇਃ ਸਮੁਚਿਤੰ ਫਲਮ੍ ਅਲਭਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","ਤੇ ਸ੍ਵੇਸ਼਼ਾਂ ਮਨਃਸ੍ਵੀਸ਼੍ਵਰਾਯ ਸ੍ਥਾਨੰ ਦਾਤੁਮ੍ ਅਨਿੱਛੁਕਾਸ੍ਤਤੋ ਹੇਤੋਰੀਸ਼੍ਵਰਸ੍ਤਾਨ੍ ਪ੍ਰਤਿ ਦੁਸ਼਼੍ਟਮਨਸ੍ਕਤ੍ਵਮ੍ ਅਵਿਹਿਤਕ੍ਰਿਯਤ੍ਵਞ੍ਚ ਦੱਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","ਅਤਏਵ ਤੇ ਸਰ੍ੱਵੇ (ਅ)ਨ੍ਯਾਯੋ ਵ੍ਯਭਿਚਾਰੋ ਦੁਸ਼਼੍ਟਤ੍ਵੰ ਲੋਭੋ ਜਿਘਾਂਸਾ ਈਰ੍ਸ਼਼੍ਯਾ ਵਧੋ ਵਿਵਾਦਸ਼੍ਚਾਤੁਰੀ ਕੁਮਤਿਰਿਤ੍ਯਾਦਿਭਿ ਰ੍ਦੁਸ਼਼੍ਕਰ੍ੰਮਭਿਃ ਪਰਿਪੂਰ੍ਣਾਃ ਸਨ੍ਤਃ ");
INSERT INTO sanpun_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","ਕਰ੍ਣੇਜਪਾ ਅਪਵਾਦਿਨ ਈਸ਼੍ਵਰਦ੍ਵੇਸ਼਼ਕਾ ਹਿੰਸਕਾ ਅਹਙ੍ਕਾਰਿਣ ਆਤ੍ਮਸ਼੍ਲਾਘਿਨਃ ਕੁਕਰ੍ੰਮੋਤ੍ਪਾਦਕਾਃ ਪਿਤ੍ਰੋਰਾਜ੍ਞਾਲਙ੍ਘਕਾ ");
INSERT INTO sanpun_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","ਅਵਿਚਾਰਕਾ ਨਿਯਮਲਙ੍ਘਿਨਃ ਸ੍ਨੇਹਰਹਿਤਾ ਅਤਿਦ੍ਵੇਸ਼਼ਿਣੋ ਨਿਰ੍ਦਯਾਸ਼੍ਚ ਜਾਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","ਯੇ ਜਨਾ ਏਤਾਦ੍ਰੁʼਸ਼ੰ ਕਰ੍ੰਮ ਕੁਰ੍ੱਵਨ੍ਤਿ ਤਏਵ ਮ੍ਰੁʼਤਿਯੋਗ੍ਯਾ ਈਸ਼੍ਵਰਸ੍ਯ ਵਿਚਾਰਮੀਦ੍ਰੁʼਸ਼ੰ ਜ੍ਞਾਤ੍ਵਾਪਿ ਤ ਏਤਾਦ੍ਰੁʼਸ਼ੰ ਕਰ੍ੰਮ ਸ੍ਵਯੰ ਕੁਰ੍ੱਵਨ੍ਤਿ ਕੇਵਲਮਿਤਿ ਨਹਿ ਕਿਨ੍ਤੁ ਤਾਦ੍ਰੁʼਸ਼ਕਰ੍ੰਮਕਾਰਿਸ਼਼ੁ ਲੋਕੇਸ਼਼੍ਵਪਿ ਪ੍ਰੀਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","ਹੇ ਪਰਦੂਸ਼਼ਕ ਮਨੁਸ਼਼੍ਯ ਯਃ ਕਸ਼੍ਚਨ ਤ੍ਵੰ ਭਵਸਿ ਤਵੋੱਤਰਦਾਨਾਯ ਪਨ੍ਥਾ ਨਾਸ੍ਤਿ ਯਤੋ ਯਸ੍ਮਾਤ੍ ਕਰ੍ੰਮਣਃ ਪਰਸ੍ਤ੍ਵਯਾ ਦੂਸ਼਼੍ਯਤੇ ਤਸ੍ਮਾਤ੍ ਤ੍ਵਮਪਿ ਦੂਸ਼਼੍ਯਸੇ, ਯਤਸ੍ਤੰ ਦੂਸ਼਼ਯੰਨਪਿ ਤ੍ਵੰ ਤਦ੍ਵਦ੍ ਆਚਰਸਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","ਕਿਨ੍ਤ੍ਵੇਤਾਦ੍ਰੁʼਗਾਚਾਰਿਭ੍ਯੋ ਯੰ ਦਣ੍ਡਮ੍ ਈਸ਼੍ਵਰੋ ਨਿਸ਼੍ਚਿਨੋਤਿ ਸ ਯਥਾਰ੍ਥ ਇਤਿ ਵਯੰ ਜਾਨੀਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","ਅਤਏਵ ਹੇ ਮਾਨੁਸ਼਼ ਤ੍ਵੰ ਯਾਦ੍ਰੁʼਗਾਚਾਰਿਣੋ ਦੂਸ਼਼ਯਸਿ ਸ੍ਵਯੰ ਯਦਿ ਤਾਦ੍ਰੁʼਗਾਚਰਸਿ ਤਰ੍ਹਿ ਤ੍ਵਮ੍ ਈਸ਼੍ਵਰਦਣ੍ਡਾਤ੍ ਪਲਾਯਿਤੁੰ ਸ਼ਕ੍ਸ਼਼੍ਯਸੀਤਿ ਕਿੰ ਬੁਧ੍ਯਸੇ? ");
INSERT INTO sanpun_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","ਅਪਰੰ ਤਵ ਮਨਸਃ ਪਰਿਵਰ੍ੱਤਨੰ ਕਰ੍ੱਤੁਮ੍ ਇਸ਼੍ਵਰਸ੍ਯਾਨੁਗ੍ਰਹੋ ਭਵਤਿ ਤੰਨ ਬੁੱਧ੍ਵਾ ਤ੍ਵੰ ਕਿੰ ਤਦੀਯਾਨੁਗ੍ਰਹਕ੍ਸ਼਼ਮਾਚਿਰਸਹਿਸ਼਼੍ਣੁਤ੍ਵਨਿਧਿੰ ਤੁੱਛੀਕਰੋਸ਼਼ਿ? ");
INSERT INTO sanpun_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","ਤਥਾ ਸ੍ਵਾਨ੍ਤਃਕਰਣਸ੍ਯ ਕਠੋਰਤ੍ਵਾਤ੍ ਖੇਦਰਾਹਿਤ੍ਯਾੱਚੇਸ਼੍ਵਰਸ੍ਯ ਨ੍ਯਾੱਯਵਿਚਾਰਪ੍ਰਕਾਸ਼ਨਸ੍ਯ ਕ੍ਰੋਧਸ੍ਯ ਚ ਦਿਨੰ ਯਾਵਤ੍ ਕਿੰ ਸ੍ਵਾਰ੍ਥੰ ਕੋਪੰ ਸਞ੍ਚਿਨੋਸ਼਼ਿ? ");
INSERT INTO sanpun_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","ਕਿਨ੍ਤੁ ਸ ਏਕੈਕਮਨੁਜਾਯ ਤਤ੍ਕਰ੍ੰਮਾਨੁਸਾਰੇਣ ਪ੍ਰਤਿਫਲੰ ਦਾਸ੍ਯਤਿ; ");
INSERT INTO sanpun_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","ਵਸ੍ਤੁਤਸ੍ਤੁ ਯੇ ਜਨਾ ਧੈਰ੍ੱਯੰ ਧ੍ਰੁʼਤ੍ਵਾ ਸਤ੍ਕਰ੍ੰਮ ਕੁਰ੍ੱਵਨ੍ਤੋ ਮਹਿਮਾ ਸਤ੍ਕਾਰੋ(ਅ)ਮਰਤ੍ਵਞ੍ਚੈਤਾਨਿ ਮ੍ਰੁʼਗਯਨ੍ਤੇ ਤੇਭ੍ਯੋ(ਅ)ਨਨ੍ਤਾਯੁ ਰ੍ਦਾਸ੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","ਅਪਰੰ ਯੇ ਜਨਾਃ ਸਤ੍ਯਧਰ੍ੰਮਮ੍ ਅਗ੍ਰੁʼਹੀਤ੍ਵਾ ਵਿਪਰੀਤਧਰ੍ੰਮਮ੍ ਗ੍ਰੁʼਹ੍ਲਨ੍ਤਿ ਤਾਦ੍ਰੁʼਸ਼ਾ ਵਿਰੋਧਿਜਨਾਃ ਕੋਪੰ ਕ੍ਰੋਧਞ੍ਚ ਭੋਕ੍ਸ਼਼੍ਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","ਆ ਯਿਹੂਦਿਨੋ(ਅ)ਨ੍ਯਦੇਸ਼ਿਨਃ ਪਰ੍ੱਯਨ੍ਤੰ ਯਾਵਨ੍ਤਃ ਕੁਕਰ੍ੰਮਕਾਰਿਣਃ ਪ੍ਰਾਣਿਨਃ ਸਨ੍ਤਿ ਤੇ ਸਰ੍ੱਵੇ ਦੁਃਖੰ ਯਾਤਨਾਞ੍ਚ ਗਮਿਸ਼਼੍ਯਨ੍ਤਿ; ");
INSERT INTO sanpun_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","ਕਿਨ੍ਤੁ ਆ ਯਿਹੂਦਿਨੋ ਭਿੰਨਦੇਸ਼ਿਪਰ੍ੱਯਨ੍ਤਾ ਯਾਵਨ੍ਤਃ ਸਤ੍ਕਰ੍ੰਮਕਾਰਿਣੋ ਲੋਕਾਃ ਸਨ੍ਤਿ ਤਾਨ੍ ਪ੍ਰਤਿ ਮਹਿਮਾ ਸਤ੍ਕਾਰਃ ਸ਼ਾਨ੍ਤਿਸ਼੍ਚ ਭਵਿਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","ਈਸ਼੍ਵਰਸ੍ਯ ਵਿਚਾਰੇ ਪਕ੍ਸ਼਼ਪਾਤੋ ਨਾਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","ਅਲਬ੍ਧਵ੍ਯਵਸ੍ਥਾਸ਼ਾਸ੍ਤ੍ਰੈ ਰ੍ਯੈਃ ਪਾਪਾਨਿ ਕ੍ਰੁʼਤਾਨਿ ਵ੍ਯਵਸ੍ਥਾਸ਼ਾਸ੍ਤ੍ਰਾਲਬ੍ਧਤ੍ਵਾਨੁਰੂਪਸ੍ਤੇਸ਼਼ਾਂ ਵਿਨਾਸ਼ੋ ਭਵਿਸ਼਼੍ਯਤਿ; ਕਿਨ੍ਤੁ ਲਬ੍ਧਵ੍ਯਵਸ੍ਥਾਸ਼ਾਸ੍ਤ੍ਰਾ ਯੇ ਪਾਪਾਨ੍ਯਕੁਰ੍ੱਵਨ੍ ਵ੍ਯਵਸ੍ਥਾਨੁਸਾਰਾਦੇਵ ਤੇਸ਼਼ਾਂ ਵਿਚਾਰੋ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","ਵ੍ਯਵਸ੍ਥਾਸ਼੍ਰੋਤਾਰ ਈਸ਼੍ਵਰਸ੍ਯ ਸਮੀਪੇ ਨਿਸ਼਼੍ਪਾਪਾ ਭਵਿਸ਼਼੍ਯਨ੍ਤੀਤਿ ਨਹਿ ਕਿਨ੍ਤੁ ਵ੍ਯਵਸ੍ਥਾਚਾਰਿਣ ਏਵ ਸਪੁਣ੍ਯਾ ਭਵਿਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","ਯਤੋ (ਅ)ਲਬ੍ਧਵ੍ਯਵਸ੍ਥਾਸ਼ਾਸ੍ਤ੍ਰਾ ਭਿੰਨਦੇਸ਼ੀਯਲੋਕਾ ਯਦਿ ਸ੍ਵਭਾਵਤੋ ਵ੍ਯਵਸ੍ਥਾਨੁਰੂਪਾਨ੍ ਆਚਾਰਾਨ੍ ਕੁਰ੍ੱਵਨ੍ਤਿ ਤਰ੍ਹ੍ਯਲਬ੍ਧਸ਼ਾਸ੍ਤ੍ਰਾਃ ਸਨ੍ਤੋ(ਅ)ਪਿ ਤੇ ਸ੍ਵੇਸ਼਼ਾਂ ਵ੍ਯਵਸ੍ਥਾਸ਼ਾਸ੍ਤ੍ਰਮਿਵ ਸ੍ਵਯਮੇਵ ਭਵਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","ਤੇਸ਼਼ਾਂ ਮਨਸਿ ਸਾਕ੍ਸ਼਼ਿਸ੍ਵਰੂਪੇ ਸਤਿ ਤੇਸ਼਼ਾਂ ਵਿਤਰ੍ਕੇਸ਼਼ੁ ਚ ਕਦਾ ਤਾਨ੍ ਦੋਸ਼਼ਿਣਃ ਕਦਾ ਵਾ ਨਿਰ੍ਦੋਸ਼਼ਾਨ੍ ਕ੍ਰੁʼਤਵਤ੍ਸੁ ਤੇ ਸ੍ਵਾਨ੍ਤਰ੍ਲਿਖਿਤਸ੍ਯ ਵ੍ਯਵਸ੍ਥਾਸ਼ਾਸ੍ਤ੍ਰਸ੍ਯ ਪ੍ਰਮਾਣੰ ਸ੍ਵਯਮੇਵ ਦਦਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","ਯਸ੍ਮਿਨ੍ ਦਿਨੇ ਮਯਾ ਪ੍ਰਕਾਸ਼ਿਤਸ੍ਯ ਸੁਸੰਵਾਦਸ੍ਯਾਨੁਸਾਰਾਦ੍ ਈਸ਼੍ਵਰੋ ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟੇਨ ਮਾਨੁਸ਼਼ਾਣਾਮ੍ ਅਨ੍ਤਃਕਰਣਾਨਾਂ ਗੂਢਾਭਿਪ੍ਰਾਯਾਨ੍ ਧ੍ਰੁʼਤ੍ਵਾ ਵਿਚਾਰਯਿਸ਼਼੍ਯਤਿ ਤਸ੍ਮਿਨ੍ ਵਿਚਾਰਦਿਨੇ ਤਤ੍ ਪ੍ਰਕਾਸ਼ਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","ਪਸ਼੍ਯ ਤ੍ਵੰ ਸ੍ਵਯੰ ਯਿਹੂਦੀਤਿ ਵਿਖ੍ਯਾਤੋ ਵ੍ਯਵਸ੍ਥੋਪਰਿ ਵਿਸ਼੍ਵਾਸੰ ਕਰੋਸ਼਼ਿ, ");
INSERT INTO sanpun_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ਈਸ਼੍ਵਰਮੁੱਦਿਸ਼੍ਯ ਸ੍ਵੰ ਸ਼੍ਲਾਘਸੇ, ਤਥਾ ਵ੍ਯਵਸ੍ਥਯਾ ਸ਼ਿਕ੍ਸ਼਼ਿਤੋ ਭੂਤ੍ਵਾ ਤਸ੍ਯਾਭਿਮਤੰ ਜਾਨਾਸਿ, ਸਰ੍ੱਵਾਸਾਂ ਕਥਾਨਾਂ ਸਾਰੰ ਵਿਵਿੰਕ੍ਸ਼਼ੇ, ");
INSERT INTO sanpun_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","ਅਪਰੰ ਜ੍ਞਾਨਸ੍ਯ ਸਤ੍ਯਤਾਯਾਸ਼੍ਚਾਕਰਸ੍ਵਰੂਪੰ ਸ਼ਾਸ੍ਤ੍ਰੰ ਮਮ ਸਮੀਪੇ ਵਿਦ੍ਯਤ ਅਤੋ (ਅ)ਨ੍ਧਲੋਕਾਨਾਂ ਮਾਰ੍ਗਦਰ੍ਸ਼ਯਿਤਾ ");
INSERT INTO sanpun_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","ਤਿਮਿਰਸ੍ਥਿਤਲੋਕਾਨਾਂ ਮਧ੍ਯੇ ਦੀਪ੍ਤਿਸ੍ਵਰੂਪੋ(ਅ)ਜ੍ਞਾਨਲੋਕੇਭ੍ਯੋ ਜ੍ਞਾਨਦਾਤਾ ਸ਼ਿਸ਼ੂਨਾਂ ਸ਼ਿਕ੍ਸ਼਼ਯਿਤਾਹਮੇਵੇਤਿ ਮਨ੍ਯਸੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","ਪਰਾਨ੍ ਸ਼ਿਕ੍ਸ਼਼ਯਨ੍ ਸ੍ਵਯੰ ਸ੍ਵੰ ਕਿੰ ਨ ਸ਼ਿਕ੍ਸ਼਼ਯਸਿ? ਵਸ੍ਤੁਤਸ਼੍ਚੌਰ੍ੱਯਨਿਸ਼਼ੇਧਵ੍ਯਵਸ੍ਥਾਂ ਪ੍ਰਚਾਰਯਨ੍ ਤ੍ਵੰ ਕਿੰ ਸ੍ਵਯਮੇਵ ਚੋਰਯਸਿ? ");
INSERT INTO sanpun_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","ਤਥਾ ਪਰਦਾਰਗਮਨੰ ਪ੍ਰਤਿਸ਼਼ੇਧਨ੍ ਸ੍ਵਯੰ ਕਿੰ ਪਰਦਾਰਾਨ੍ ਗੱਛਸਿ? ਤਥਾ ਤ੍ਵੰ ਸ੍ਵਯੰ ਪ੍ਰਤਿਮਾਦ੍ਵੇਸ਼਼ੀ ਸਨ੍ ਕਿੰ ਮਨ੍ਦਿਰਸ੍ਯ ਦ੍ਰਵ੍ਯਾਣਿ ਹਰਸਿ? ");
INSERT INTO sanpun_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","ਯਸ੍ਤ੍ਵੰ ਵ੍ਯਵਸ੍ਥਾਂ ਸ਼੍ਲਾਘਸੇ ਸ ਤ੍ਵੰ ਕਿੰ ਵ੍ਯਵਸ੍ਥਾਮ੍ ਅਵਮਤ੍ਯ ਨੇਸ਼੍ਵਰੰ ਸੰਮਨ੍ਯਸੇ? ");
INSERT INTO sanpun_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","ਸ਼ਾਸ੍ਤ੍ਰੇ ਯਥਾ ਲਿਖਤਿ \"ਭਿੰਨਦੇਸ਼ਿਨਾਂ ਸਮੀਪੇ ਯੁਸ਼਼੍ਮਾਕੰ ਦੋਸ਼਼ਾਦ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਨਾਮ੍ਨੋ ਨਿਨ੍ਦਾ ਭਵਤਿ| \" ");
INSERT INTO sanpun_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","ਯਦਿ ਵ੍ਯਵਸ੍ਥਾਂ ਪਾਲਯਸਿ ਤਰ੍ਹਿ ਤਵ ਤ੍ਵਕ੍ਛੇਦਕ੍ਰਿਯਾ ਸਫਲਾ ਭਵਤਿ; ਯਤਿ ਵ੍ਯਵਸ੍ਥਾਂ ਲਙ੍ਘਸੇ ਤਰ੍ਹਿ ਤਵ ਤ੍ਵਕ੍ਛੇਦੋ(ਅ)ਤ੍ਵਕ੍ਛੇਦੋ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","ਯਤੋ ਵ੍ਯਵਸ੍ਥਾਸ਼ਾਸ੍ਤ੍ਰਾਦਿਸ਼਼੍ਟਧਰ੍ੰਮਕਰ੍ੰਮਾਚਾਰੀ ਪੁਮਾਨ੍ ਅਤ੍ਵਕ੍ਛੇਦੀ ਸੰਨਪਿ ਕਿੰ ਤ੍ਵਕ੍ਛੇਦਿਨਾਂ ਮਧ੍ਯੇ ਨ ਗਣਯਿਸ਼਼੍ਯਤੇ? ");
INSERT INTO sanpun_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","ਕਿਨ੍ਤੁ ਲਬ੍ਧਸ਼ਾਸ੍ਤ੍ਰਸ਼੍ਛਿੰਨਤ੍ਵਕ੍ ਚ ਤ੍ਵੰ ਯਦਿ ਵ੍ਯਵਸ੍ਥਾਲਙ੍ਘਨੰ ਕਰੋਸ਼਼ਿ ਤਰ੍ਹਿ ਵ੍ਯਵਸ੍ਥਾਪਾਲਕਾਃ ਸ੍ਵਾਭਾਵਿਕਾੱਛਿੰਨਤ੍ਵਚੋ ਲੋਕਾਸ੍ਤ੍ਵਾਂ ਕਿੰ ਨ ਦੂਸ਼਼ਯਿਸ਼਼੍ਯਨ੍ਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","ਤਸ੍ਮਾਦ੍ ਯੋ ਬਾਹ੍ਯੇ ਯਿਹੂਦੀ ਸ ਯਿਹੂਦੀ ਨਹਿ ਤਥਾਙ੍ਗਸ੍ਯ ਯਸ੍ਤ੍ਵਕ੍ਛੇਦਃ ਸ ਤ੍ਵਕ੍ਛੇਦੋ ਨਹਿ; ");
INSERT INTO sanpun_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","ਕਿਨ੍ਤੁ ਯੋ ਜਨ ਆਨ੍ਤਰਿਕੋ ਯਿਹੂਦੀ ਸ ਏਵ ਯਿਹੂਦੀ ਅਪਰਞ੍ਚ ਕੇਵਲਲਿਖਿਤਯਾ ਵ੍ਯਵਸ੍ਥਯਾ ਨ ਕਿਨ੍ਤੁ ਮਾਨਸਿਕੋ ਯਸ੍ਤ੍ਵਕ੍ਛੇਦੋ ਯਸ੍ਯ ਚ ਪ੍ਰਸ਼ੰਸਾ ਮਨੁਸ਼਼੍ਯੇਭ੍ਯੋ ਨ ਭੂਤ੍ਵਾ ਈਸ਼੍ਵਰਾਦ੍ ਭਵਤਿ ਸ ਏਵ ਤ੍ਵਕ੍ਛੇਦਃ| ");
INSERT INTO sanpun_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","ਅਪਰਞ੍ਚ ਯਿਹੂਦਿਨਃ ਕਿੰ ਸ਼੍ਰੇਸ਼਼੍ਠਤ੍ਵੰ? ਤਥਾ ਤ੍ਵਕ੍ਛੇਦਸ੍ਯ ਵਾ ਕਿੰ ਫਲੰ? ");
INSERT INTO sanpun_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","ਸਰ੍ੱਵਥਾ ਬਹੂਨਿ ਫਲਾਨਿ ਸਨ੍ਤਿ, ਵਿਸ਼ੇਸ਼਼ਤ ਈਸ਼੍ਵਰਸ੍ਯ ਸ਼ਾਸ੍ਤ੍ਰੰ ਤੇਭ੍ਯੋ(ਅ)ਦੀਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","ਕੈਸ਼੍ਚਿਦ੍ ਅਵਿਸ਼੍ਵਸਨੇ ਕ੍ਰੁʼਤੇ ਤੇਸ਼਼ਾਮ੍ ਅਵਿਸ਼੍ਵਸਨਾਤ੍ ਕਿਮ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਵਿਸ਼੍ਵਾਸ੍ਯਤਾਯਾ ਹਾਨਿਰੁਤ੍ਪਤ੍ਸ੍ਯਤੇ? ");
INSERT INTO sanpun_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","ਕੇਨਾਪਿ ਪ੍ਰਕਾਰੇਣ ਨਹਿ| ਯਦ੍ਯਪਿ ਸਰ੍ੱਵੇ ਮਨੁਸ਼਼੍ਯਾ ਮਿਥ੍ਯਾਵਾਦਿਨਸ੍ਤਥਾਪੀਸ਼੍ਵਰਃ ਸਤ੍ਯਵਾਦੀ| ਸ਼ਾਸ੍ਤ੍ਰੇ ਯਥਾ ਲਿਖਿਤਮਾਸ੍ਤੇ, ਅਤਸ੍ਤ੍ਵਨ੍ਤੁ ਸ੍ਵਵਾਕ੍ਯੇਨ ਨਿਰ੍ੱਦੋਸ਼਼ੋ ਹਿ ਭਵਿਸ਼਼੍ਯਸਿ| ਵਿਚਾਰੇ ਚੈਵ ਨਿਸ਼਼੍ਪਾਪੋ ਭਵਿਸ਼਼੍ਯਸਿ ਨ ਸੰਸ਼ਯਃ| ");
INSERT INTO sanpun_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","ਅਸ੍ਮਾਕਮ੍ ਅਨ੍ਯਾਯੇਨ ਯਦੀਸ਼੍ਵਰਸ੍ਯ ਨ੍ਯਾਯਃ ਪ੍ਰਕਾਸ਼ਤੇ ਤਰ੍ਹਿ ਕਿੰ ਵਦਿਸ਼਼੍ਯਾਮਃ? ਅਹੰ ਮਾਨੁਸ਼਼ਾਣਾਂ ਕਥਾਮਿਵ ਕਥਾਂ ਕਥਯਾਮਿ, ਈਸ਼੍ਵਰਃ ਸਮੁਚਿਤੰ ਦਣ੍ਡੰ ਦੱਤ੍ਵਾ ਕਿਮ੍ ਅਨ੍ਯਾਯੀ ਭਵਿਸ਼਼੍ਯਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","ਇੱਥੰ ਨ ਭਵਤੁ, ਤਥਾ ਸਤੀਸ਼੍ਵਰਃ ਕਥੰ ਜਗਤੋ ਵਿਚਾਰਯਿਤਾ ਭਵਿਸ਼਼੍ਯਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","ਮਮ ਮਿਥ੍ਯਾਵਾਕ੍ਯਵਦਨਾਦ੍ ਯਦੀਸ਼੍ਵਰਸ੍ਯ ਸਤ੍ਯਤ੍ਵੇਨ ਤਸ੍ਯ ਮਹਿਮਾ ਵਰ੍ੱਧਤੇ ਤਰ੍ਹਿ ਕਸ੍ਮਾਦਹੰ ਵਿਚਾਰੇ(ਅ)ਪਰਾਧਿਤ੍ਵੇਨ ਗਣ੍ਯੋ ਭਵਾਮਿ? ");
INSERT INTO sanpun_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","ਮਙ੍ਗਲਾਰ੍ਥੰ ਪਾਪਮਪਿ ਕਰਣੀਯਮਿਤਿ ਵਾਕ੍ਯੰ ਤ੍ਵਯਾ ਕੁਤੋ ਨੋਚ੍ਯਤੇ? ਕਿਨ੍ਤੁ ਯੈਰੁਚ੍ਯਤੇ ਤੇ ਨਿਤਾਨ੍ਤੰ ਦਣ੍ਡਸ੍ਯ ਪਾਤ੍ਰਾਣਿ ਭਵਨ੍ਤਿ; ਤਥਾਪਿ ਤਦ੍ਵਾਕ੍ਯਮ੍ ਅਸ੍ਮਾਭਿਰਪ੍ਯੁਚ੍ਯਤ ਇਤ੍ਯਸ੍ਮਾਕੰ ਗ੍ਲਾਨਿੰ ਕੁਰ੍ੱਵਨ੍ਤਃ ਕਿਯਨ੍ਤੋ ਲੋਕਾ ਵਦਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","ਅਨ੍ਯਲੋਕੇਭ੍ਯੋ ਵਯੰ ਕਿੰ ਸ਼੍ਰੇਸ਼਼੍ਠਾਃ? ਕਦਾਚਨ ਨਹਿ ਯਤੋ ਯਿਹੂਦਿਨੋ (ਅ)ਨ੍ਯਦੇਸ਼ਿਨਸ਼੍ਚ ਸਰ੍ੱਵਏਵ ਪਾਪਸ੍ਯਾਯੱਤਾ ਇਤ੍ਯਸ੍ਯ ਪ੍ਰਮਾਣੰ ਵਯੰ ਪੂਰ੍ੱਵਮ੍ ਅਦਦਾਮ| ");
INSERT INTO sanpun_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","ਲਿਪਿ ਰ੍ਯਥਾਸ੍ਤੇ, ਨੈਕੋਪਿ ਧਾਰ੍ੰਮਿਕੋ ਜਨਃ| ");
INSERT INTO sanpun_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","ਤਥਾ ਜ੍ਞਾਨੀਸ਼੍ਵਰਜ੍ਞਾਨੀ ਮਾਨਵਃ ਕੋਪਿ ਨਾਸ੍ਤਿ ਹਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","ਵਿਮਾਰ੍ਗਗਾਮਿਨਃ ਸਰ੍ੱਵੇ ਸਰ੍ੱਵੇ ਦੁਸ਼਼੍ਕਰ੍ੰਮਕਾਰਿਣਃ| ਏਕੋ ਜਨੋਪਿ ਨੋ ਤੇਸ਼਼ਾਂ ਸਾਧੁਕਰ੍ੰਮ ਕਰੋਤਿ ਚ| ");
INSERT INTO sanpun_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","ਤਥਾ ਤੇਸ਼਼ਾਨ੍ਤੁ ਵੈ ਕਣ੍ਠਾ ਅਨਾਵ੍ਰੁʼਤਸ਼੍ਮਸ਼ਾਨਵਤ੍| ਸ੍ਤੁਤਿਵਾਦੰ ਪ੍ਰਕੁਰ੍ੱਵਨ੍ਤਿ ਜਿਹ੍ਵਾਭਿਸ੍ਤੇ ਤੁ ਕੇਵਲੰ| ਤੇਸ਼਼ਾਮੋਸ਼਼੍ਠਸ੍ਯ ਨਿਮ੍ਨੇ ਤੁ ਵਿਸ਼਼ੰ ਤਿਸ਼਼੍ਠਤਿ ਸਰ੍ੱਪਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","ਮੁਖੰ ਤੇਸ਼਼ਾਂ ਹਿ ਸ਼ਾਪੇਨ ਕਪਟੇਨ ਚ ਪੂਰ੍ੱਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","ਰਕ੍ਤਪਾਤਾਯ ਤੇਸ਼਼ਾਂ ਤੁ ਪਦਾਨਿ ਕ੍ਸ਼਼ਿਪ੍ਰਗਾਨਿ ਚ| ");
INSERT INTO sanpun_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","ਪਥਿ ਤੇਸ਼਼ਾਂ ਮਨੁਸ਼਼੍ਯਾਣਾਂ ਨਾਸ਼ਃ ਕ੍ਲੇਸ਼ਸ਼੍ਚ ਕੇਵਲਃ| ");
INSERT INTO sanpun_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","ਤੇ ਜਨਾ ਨਹਿ ਜਾਨਨ੍ਤਿ ਪਨ੍ਥਾਨੰ ਸੁਖਦਾਯਿਨੰ| ");
INSERT INTO sanpun_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","ਪਰਮੇਸ਼ਾਦ੍ ਭਯੰ ਯੱਤਤ੍ ਤੱਚਕ੍ਸ਼਼ੁਸ਼਼ੋਰਗੋਚਰੰ| ");
INSERT INTO sanpun_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","ਵ੍ਯਵਸ੍ਥਾਯਾਂ ਯਦ੍ਯੱਲਿਖਤਿ ਤਦ੍ ਵ੍ਯਵਸ੍ਥਾਧੀਨਾਨ੍ ਲੋਕਾਨ੍ ਉੱਦਿਸ਼੍ਯ ਲਿਖਤੀਤਿ ਵਯੰ ਜਾਨੀਮਃ| ਤਤੋ ਮਨੁਸ਼਼੍ਯਮਾਤ੍ਰੋ ਨਿਰੁੱਤਰਃ ਸਨ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਸਾਕ੍ਸ਼਼ਾਦ੍ ਅਪਰਾਧੀ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","ਅਤਏਵ ਵ੍ਯਵਸ੍ਥਾਨੁਰੂਪੈਃ ਕਰ੍ੰਮਭਿਃ ਕਸ਼੍ਚਿਦਪਿ ਪ੍ਰਾਣੀਸ਼੍ਵਰਸ੍ਯ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਸਪੁਣ੍ਯੀਕ੍ਰੁʼਤੋ ਭਵਿਤੁੰ ਨ ਸ਼ਕ੍ਸ਼਼੍ਯਤਿ ਯਤੋ ਵ੍ਯਵਸ੍ਥਯਾ ਪਾਪਜ੍ਞਾਨਮਾਤ੍ਰੰ ਜਾਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","ਕਿਨ੍ਤੁ ਵ੍ਯਵਸ੍ਥਾਯਾਃ ਪ੍ਰੁʼਥਗ੍ ਈਸ਼੍ਵਰੇਣ ਦੇਯੰ ਯਤ੍ ਪੁਣ੍ਯੰ ਤਦ੍ ਵ੍ਯਵਸ੍ਥਾਯਾ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਗਣਸ੍ਯ ਚ ਵਚਨੈਃ ਪ੍ਰਮਾਣੀਕ੍ਰੁʼਤੰ ਸਦ੍ ਇਦਾਨੀਂ ਪ੍ਰਕਾਸ਼ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟੇ ਵਿਸ਼੍ਵਾਸਕਰਣਾਦ੍ ਈਸ਼੍ਵਰੇਣ ਦੱਤੰ ਤਤ੍ ਪੁਣ੍ਯੰ ਸਕਲੇਸ਼਼ੁ ਪ੍ਰਕਾਸ਼ਿਤੰ ਸਤ੍ ਸਰ੍ੱਵਾਨ੍ ਵਿਸ਼੍ਵਾਸਿਨਃ ਪ੍ਰਤਿ ਵਰ੍ੱਤਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","ਤੇਸ਼਼ਾਂ ਕੋਪਿ ਪ੍ਰਭੇਦੋ ਨਾਸ੍ਤਿ, ਯਤਃ ਸਰ੍ੱਵਏਵ ਪਾਪਿਨ ਈਸ਼੍ਵਰੀਯਤੇਜੋਹੀਨਾਸ਼੍ਚ ਜਾਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","ਤ ਈਸ਼੍ਵਰਸ੍ਯਾਨੁਗ੍ਰਹਾਦ੍ ਮੂਲ੍ਯੰ ਵਿਨਾ ਖ੍ਰੀਸ਼਼੍ਟਕ੍ਰੁʼਤੇਨ ਪਰਿਤ੍ਰਾਣੇਨ ਸਪੁਣ੍ਯੀਕ੍ਰੁʼਤਾ ਭਵਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","ਯਸ੍ਮਾਤ੍ ਸ੍ਵਸ਼ੋਣਿਤੇਨ ਵਿਸ਼੍ਵਾਸਾਤ੍ ਪਾਪਨਾਸ਼ਕੋ ਬਲੀ ਭਵਿਤੁੰ ਸ ਏਵ ਪੂਰ੍ੱਵਮ੍ ਈਸ਼੍ਵਰੇਣ ਨਿਸ਼੍ਚਿਤਃ, ਇੱਥਮ੍ ਈਸ਼੍ਵਰੀਯਸਹਿਸ਼਼੍ਣੁਤ੍ਵਾਤ੍ ਪੁਰਾਕ੍ਰੁʼਤਪਾਪਾਨਾਂ ਮਾਰ੍ੱਜਨਕਰਣੇ ਸ੍ਵੀਯਯਾਥਾਰ੍ਥ੍ਯੰ ਤੇਨ ਪ੍ਰਕਾਸ਼੍ਯਤੇ, ");
INSERT INTO sanpun_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","ਵਰ੍ੱਤਮਾਨਕਾਲੀਯਮਪਿ ਸ੍ਵਯਾਥਾਰ੍ਥ੍ਯੰ ਤੇਨ ਪ੍ਰਕਾਸ਼੍ਯਤੇ, ਅਪਰੰ ਯੀਸ਼ੌ ਵਿਸ਼੍ਵਾਸਿਨੰ ਸਪੁਣ੍ਯੀਕੁਰ੍ੱਵੰਨਪਿ ਸ ਯਾਥਾਰ੍ਥਿਕਸ੍ਤਿਸ਼਼੍ਠਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","ਤਰ੍ਹਿ ਕੁਤ੍ਰਾਤ੍ਮਸ਼੍ਲਾਘਾ? ਸਾ ਦੂਰੀਕ੍ਰੁʼਤਾ; ਕਯਾ ਵ੍ਯਵਸ੍ਥਯਾ? ਕਿੰ ਕ੍ਰਿਯਾਰੂਪਵ੍ਯਵਸ੍ਥਯਾ? ਇੱਥੰ ਨਹਿ ਕਿਨ੍ਤੁ ਤਤ੍ ਕੇਵਲਵਿਸ਼੍ਵਾਸਰੂਪਯਾ ਵ੍ਯਵਸ੍ਥਯੈਵ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","ਅਤਏਵ ਵ੍ਯਵਸ੍ਥਾਨੁਰੂਪਾਃ ਕ੍ਰਿਯਾ ਵਿਨਾ ਕੇਵਲੇਨ ਵਿਸ਼੍ਵਾਸੇਨ ਮਾਨਵਃ ਸਪੁਣ੍ਯੀਕ੍ਰੁʼਤੋ ਭਵਿਤੁੰ ਸ਼ਕ੍ਨੋਤੀਤ੍ਯਸ੍ਯ ਰਾੱਧਾਨ੍ਤੰ ਦਰ੍ਸ਼ਯਾਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","ਸ ਕਿੰ ਕੇਵਲਯਿਹੂਦਿਨਾਮ੍ ਈਸ਼੍ਵਰੋ ਭਵਤਿ? ਭਿੰਨਦੇਸ਼ਿਨਾਮ੍ ਈਸ਼੍ਵਰੋ ਨ ਭਵਤਿ? ਭਿੰਨਦੇਸ਼ਿਨਾਮਪਿ ਭਵਤਿ; ");
INSERT INTO sanpun_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","ਯਸ੍ਮਾਦ੍ ਏਕ ਈਸ਼੍ਵਰੋ ਵਿਸ਼੍ਵਾਸਾਤ੍ ਤ੍ਵਕ੍ਛੇਦਿਨੋ ਵਿਸ਼੍ਵਾਸੇਨਾਤ੍ਵਕ੍ਛੇਦਿਨਸ਼੍ਚ ਸਪੁਣ੍ਯੀਕਰਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","ਤਰ੍ਹਿ ਵਿਸ਼੍ਵਾਸੇਨ ਵਯੰ ਕਿੰ ਵ੍ਯਵਸ੍ਥਾਂ ਲੁਮ੍ਪਾਮ? ਇੱਥੰ ਨ ਭਵਤੁ ਵਯੰ ਵ੍ਯਵਸ੍ਥਾਂ ਸੰਸ੍ਥਾਪਯਾਮ ਏਵ| ");
INSERT INTO sanpun_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","ਅਸ੍ਮਾਕੰ ਪੂਰ੍ੱਵਪੁਰੁਸ਼਼ ਇਬ੍ਰਾਹੀਮ੍ ਕਾਯਿਕਕ੍ਰਿਯਯਾ ਕਿੰ ਲਬ੍ਧਵਾਨ੍ ਏਤਦਧਿ ਕਿੰ ਵਦਿਸ਼਼੍ਯਾਮਃ? ");
INSERT INTO sanpun_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","ਸ ਯਦਿ ਨਿਜਕ੍ਰਿਯਾਭ੍ਯਃ ਸਪੁਣ੍ਯੋ ਭਵੇਤ੍ ਤਰ੍ਹਿ ਤਸ੍ਯਾਤ੍ਮਸ਼੍ਲਾਘਾਂ ਕਰ੍ੱਤੁੰ ਪਨ੍ਥਾ ਭਵੇਦਿਤਿ ਸਤ੍ਯੰ, ਕਿਨ੍ਤ੍ਵੀਸ਼੍ਵਰਸ੍ਯ ਸਮੀਪੇ ਨਹਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","ਸ਼ਾਸ੍ਤ੍ਰੇ ਕਿੰ ਲਿਖਤਿ? ਇਬ੍ਰਾਹੀਮ੍ ਈਸ਼੍ਵਰੇ ਵਿਸ਼੍ਵਸਨਾਤ੍ ਸ ਵਿਸ਼੍ਵਾਸਸ੍ਤਸ੍ਮੈ ਪੁਣ੍ਯਾਰ੍ਥੰ ਗਣਿਤੋ ਬਭੂਵ| ");
INSERT INTO sanpun_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","ਕਰ੍ੰਮਕਾਰਿਣੋ ਯਦ੍ ਵੇਤਨੰ ਤਦ੍ ਅਨੁਗ੍ਰਹਸ੍ਯ ਫਲੰ ਨਹਿ ਕਿਨ੍ਤੁ ਤੇਨੋਪਾਰ੍ਜਿਤੰ ਮਨ੍ਤਵ੍ਯਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","ਕਿਨ੍ਤੁ ਯਃ ਪਾਪਿਨੰ ਸਪੁਣ੍ਯੀਕਰੋਤਿ ਤਸ੍ਮਿਨ੍ ਵਿਸ਼੍ਵਾਸਿਨਃ ਕਰ੍ੰਮਹੀਨਸ੍ਯ ਜਨਸ੍ਯ ਯੋ ਵਿਸ਼੍ਵਾਸਃ ਸ ਪੁਣ੍ਯਾਰ੍ਥੰ ਗਣ੍ਯੋ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","ਅਪਰੰ ਯੰ ਕ੍ਰਿਯਾਹੀਨਮ੍ ਈਸ਼੍ਵਰਃ ਸਪੁਣ੍ਯੀਕਰੋਤਿ ਤਸ੍ਯ ਧਨ੍ਯਵਾਦੰ ਦਾਯੂਦ੍ ਵਰ੍ਣਯਾਮਾਸ, ਯਥਾ, ");
INSERT INTO sanpun_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","ਸ ਧਨ੍ਯੋ(ਅ)ਘਾਨਿ ਮ੍ਰੁʼਸ਼਼੍ਟਾਨਿ ਯਸ੍ਯਾਗਾਂਸ੍ਯਾਵ੍ਰੁʼਤਾਨਿ ਚ| ");
INSERT INTO sanpun_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","ਸ ਚ ਧਨ੍ਯਃ ਪਰੇਸ਼ੇਨ ਪਾਪੰ ਯਸ੍ਯ ਨ ਗਣ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","ਏਸ਼਼ ਧਨ੍ਯਵਾਦਸ੍ਤ੍ਵਕ੍ਛੇਦਿਨਮ੍ ਅਤ੍ਵਕ੍ਛੇਦਿਨੰ ਵਾ ਕੰ ਪ੍ਰਤਿ ਭਵਤਿ? ਇਬ੍ਰਾਹੀਮੋ ਵਿਸ਼੍ਵਾਸਃ ਪੁਣ੍ਯਾਰ੍ਥੰ ਗਣਿਤ ਇਤਿ ਵਯੰ ਵਦਾਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","ਸ ਵਿਸ਼੍ਵਾਸਸ੍ਤਸ੍ਯ ਤ੍ਵਕ੍ਛੇਦਿਤ੍ਵਾਵਸ੍ਥਾਯਾਂ ਕਿਮ੍ ਅਤ੍ਵਕ੍ਛੇਦਿਤ੍ਵਾਵਸ੍ਥਾਯਾਂ ਕਸ੍ਮਿਨ੍ ਸਮਯੇ ਪੁਣ੍ਯਮਿਵ ਗਣਿਤਃ? ਤ੍ਵਕ੍ਛੇਦਿਤ੍ਵਾਵਸ੍ਥਾਯਾਂ ਨਹਿ ਕਿਨ੍ਤ੍ਵਤ੍ਵਕ੍ਛੇਦਿਤ੍ਵਾਵਸ੍ਥਾਯਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","ਅਪਰਞ੍ਚ ਸ ਯਤ੍ ਸਰ੍ੱਵੇਸ਼਼ਾਮ੍ ਅਤ੍ਵਕ੍ਛੇਦਿਨਾਂ ਵਿਸ਼੍ਵਾਸਿਨਾਮ੍ ਆਦਿਪੁਰੁਸ਼਼ੋ ਭਵੇਤ੍, ਤੇ ਚ ਪੁਣ੍ਯਵੱਤ੍ਵੇਨ ਗਣ੍ਯੇਰਨ੍; ");
INSERT INTO sanpun_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","ਯੇ ਚ ਲੋਕਾਃ ਕੇਵਲੰ ਛਿੰਨਤ੍ਵਚੋ ਨ ਸਨ੍ਤੋ (ਅ)ਸ੍ਮਤ੍ਪੂਰ੍ੱਵਪੁਰੁਸ਼਼ ਇਬ੍ਰਾਹੀਮ੍ ਅਛਿੰਨਤ੍ਵਕ੍ ਸਨ੍ ਯੇਨ ਵਿਸ਼੍ਵਾਸਮਾਰ੍ਗੇਣ ਗਤਵਾਨ੍ ਤੇਨੈਵ ਤਸ੍ਯ ਪਾਦਚਿਹ੍ਨੇਨ ਗੱਛਨ੍ਤਿ ਤੇਸ਼਼ਾਂ ਤ੍ਵਕ੍ਛੇਦਿਨਾਮਪ੍ਯਾਦਿਪੁਰੁਸ਼਼ੋ ਭਵੇਤ੍ ਤਦਰ੍ਥਮ੍ ਅਤ੍ਵਕ੍ਛੇਦਿਨੋ ਮਾਨਵਸ੍ਯ ਵਿਸ਼੍ਵਾਸਾਤ੍ ਪੁਣ੍ਯਮ੍ ਉਤ੍ਪਦ੍ਯਤ ਇਤਿ ਪ੍ਰਮਾਣਸ੍ਵਰੂਪੰ ਤ੍ਵਕ੍ਛੇਦਚਿਹ੍ਨੰ ਸ ਪ੍ਰਾਪ੍ਨੋਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","ਇਬ੍ਰਾਹੀਮ੍ ਜਗਤੋ(ਅ)ਧਿਕਾਰੀ ਭਵਿਸ਼਼੍ਯਤਿ ਯੈਸ਼਼ਾ ਪ੍ਰਤਿਜ੍ਞਾ ਤੰ ਤਸ੍ਯ ਵੰਸ਼ਞ੍ਚ ਪ੍ਰਤਿ ਪੂਰ੍ੱਵਮ੍ ਅਕ੍ਰਿਯਤ ਸਾ ਵ੍ਯਵਸ੍ਥਾਮੂਲਿਕਾ ਨਹਿ ਕਿਨ੍ਤੁ ਵਿਸ਼੍ਵਾਸਜਨ੍ਯਪੁਣ੍ਯਮੂਲਿਕਾ| ");
INSERT INTO sanpun_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","ਯਤੋ ਵ੍ਯਵਸ੍ਥਾਵਲਮ੍ਬਿਨੋ ਯਦ੍ਯਧਿਕਾਰਿਣੋ ਭਵਨ੍ਤਿ ਤਰ੍ਹਿ ਵਿਸ਼੍ਵਾਸੋ ਵਿਫਲੋ ਜਾਯਤੇ ਸਾ ਪ੍ਰਤਿਜ੍ਞਾਪਿ ਲੁਪ੍ਤੈਵ| ");
INSERT INTO sanpun_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","ਅਧਿਕਨ੍ਤੁ ਵ੍ਯਵਸ੍ਥਾ ਕੋਪੰ ਜਨਯਤਿ ਯਤੋ (ਅ)ਵਿਦ੍ਯਮਾਨਾਯਾਂ ਵ੍ਯਵਸ੍ਥਾਯਾਮ੍ ਆਜ੍ਞਾਲਙ੍ਘਨੰ ਨ ਸਮ੍ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","ਅਤਏਵ ਸਾ ਪ੍ਰਤਿਜ੍ਞਾ ਯਦ੍ ਅਨੁਗ੍ਰਹਸ੍ਯ ਫਲੰ ਭਵੇਤ੍ ਤਦਰ੍ਥੰ ਵਿਸ਼੍ਵਾਸਮੂਲਿਕਾ ਯਤਸ੍ਤਥਾਤ੍ਵੇ ਤਦ੍ਵੰਸ਼ਸਮੁਦਾਯੰ ਪ੍ਰਤਿ ਅਰ੍ਥਤੋ ਯੇ ਵ੍ਯਵਸ੍ਥਯਾ ਤਦ੍ਵੰਸ਼ਸਮ੍ਭਵਾਃ ਕੇਵਲੰ ਤਾਨ੍ ਪ੍ਰਤਿ ਨਹਿ ਕਿਨ੍ਤੁ ਯ ਇਬ੍ਰਾਹੀਮੀਯਵਿਸ਼੍ਵਾਸੇਨ ਤਤ੍ਸਮ੍ਭਵਾਸ੍ਤਾਨਪਿ ਪ੍ਰਤਿ ਸਾ ਪ੍ਰਤਿਜ੍ਞਾ ਸ੍ਥਾਸ੍ਨੁਰ੍ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","ਯੋ ਨਿਰ੍ਜੀਵਾਨ੍ ਸਜੀਵਾਨ੍ ਅਵਿਦ੍ਯਮਾਨਾਨਿ ਵਸ੍ਤੂਨਿ ਚ ਵਿਦ੍ਯਮਾਨਾਨਿ ਕਰੋਤਿ ਇਬ੍ਰਾਹੀਮੋ ਵਿਸ਼੍ਵਾਸਭੂਮੇਸ੍ਤਸ੍ਯੇਸ਼੍ਵਰਸ੍ਯ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਸੋ(ਅ)ਸ੍ਮਾਕੰ ਸਰ੍ੱਵੇਸ਼਼ਾਮ੍ ਆਦਿਪੁਰੁਸ਼਼ ਆਸ੍ਤੇ, ਯਥਾ ਲਿਖਿਤੰ ਵਿਦ੍ਯਤੇ, ਅਹੰ ਤ੍ਵਾਂ ਬਹੁਜਾਤੀਨਾਮ੍ ਆਦਿਪੁਰੁਸ਼਼ੰ ਕ੍ਰੁʼਤ੍ਵਾ ਨਿਯੁਕ੍ਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","ਤ੍ਵਦੀਯਸ੍ਤਾਦ੍ਰੁʼਸ਼ੋ ਵੰਸ਼ੋ ਜਨਿਸ਼਼੍ਯਤੇ ਯਦਿਦੰ ਵਾਕ੍ਯੰ ਪ੍ਰਤਿਸ਼੍ਰੁਤੰ ਤਦਨੁਸਾਰਾਦ੍ ਇਬ੍ਰਾਹੀਮ੍ ਬਹੁਦੇਸ਼ੀਯਲੋਕਾਨਾਮ੍ ਆਦਿਪੁਰੁਸ਼਼ੋ ਯਦ੍ ਭਵਤਿ ਤਦਰ੍ਥੰ ਸੋ(ਅ)ਨਪੇਕ੍ਸ਼਼ਿਤਵ੍ਯਮਪ੍ਯਪੇਕ੍ਸ਼਼ਮਾਣੋ ਵਿਸ਼੍ਵਾਸੰ ਕ੍ਰੁʼਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","ਅਪਰਞ੍ਚ ਕ੍ਸ਼਼ੀਣਵਿਸ਼੍ਵਾਸੋ ਨ ਭੂਤ੍ਵਾ ਸ਼ਤਵਤ੍ਸਰਵਯਸ੍ਕਤ੍ਵਾਤ੍ ਸ੍ਵਸ਼ਰੀਰਸ੍ਯ ਜਰਾਂ ਸਾਰਾਨਾਮ੍ਨਃ ਸ੍ਵਭਾਰ੍ੱਯਾਯਾ ਰਜੋਨਿਵ੍ਰੁʼੱਤਿਞ੍ਚ ਤ੍ਰੁʼਣਾਯ ਨ ਮੇਨੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","ਅਪਰਮ੍ ਅਵਿਸ਼੍ਵਾਸਾਦ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਪ੍ਰਤਿਜ੍ਞਾਵਚਨੇ ਕਮਪਿ ਸੰਸ਼ਯੰ ਨ ਚਕਾਰ; ");
INSERT INTO sanpun_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","ਕਿਨ੍ਤ੍ਵੀਸ਼੍ਵਰੇਣ ਯਤ੍ ਪ੍ਰਤਿਸ਼੍ਰੁਤੰ ਤਤ੍ ਸਾਧਯਿਤੁੰ ਸ਼ਕ੍ਯਤ ਇਤਿ ਨਿਸ਼੍ਚਿਤੰ ਵਿਜ੍ਞਾਯ ਦ੍ਰੁʼਢਵਿਸ਼੍ਵਾਸਃ ਸਨ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਮਹਿਮਾਨੰ ਪ੍ਰਕਾਸ਼ਯਾਞ੍ਚਕਾਰ| ");
INSERT INTO sanpun_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","ਇਤਿ ਹੇਤੋਸ੍ਤਸ੍ਯ ਸ ਵਿਸ਼੍ਵਾਸਸ੍ਤਦੀਯਪੁਣ੍ਯਮਿਵ ਗਣਯਾਞ੍ਚਕ੍ਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","ਪੁਣ੍ਯਮਿਵਾਗਣ੍ਯਤ ਤਤ੍ ਕੇਵਲਸ੍ਯ ਤਸ੍ਯ ਨਿਮਿੱਤੰ ਲਿਖਿਤੰ ਨਹਿ, ਅਸ੍ਮਾਕੰ ਨਿਮਿੱਤਮਪਿ, ");
INSERT INTO sanpun_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","ਯਤੋ(ਅ)ਸ੍ਮਾਕੰ ਪਾਪਨਾਸ਼ਾਰ੍ਥੰ ਸਮਰ੍ਪਿਤੋ(ਅ)ਸ੍ਮਾਕੰ ਪੁਣ੍ਯਪ੍ਰਾਪ੍ਤ੍ਯਰ੍ਥਞ੍ਚੋੱਥਾਪਿਤੋ(ਅ)ਭਵਤ੍ ਯੋ(ਅ)ਸ੍ਮਾਕੰ ਪ੍ਰਭੁ ਰ੍ਯੀਸ਼ੁਸ੍ਤਸ੍ਯੋੱਥਾਪਯਿਤਰੀਸ਼੍ਵਰੇ ");
INSERT INTO sanpun_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","ਯਦਿ ਵਯੰ ਵਿਸ਼੍ਵਸਾਮਸ੍ਤਰ੍ਹ੍ਯਸ੍ਮਾਕਮਪਿ ਸਏਵ ਵਿਸ਼੍ਵਾਸਃ ਪੁਣ੍ਯਮਿਵ ਗਣਯਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","ਵਿਸ਼੍ਵਾਸੇਨ ਸਪੁਣ੍ਯੀਕ੍ਰੁʼਤਾ ਵਯਮ੍ ਈਸ਼੍ਵਰੇਣ ਸਾਰ੍ੱਧੰ ਪ੍ਰਭੁਣਾਸ੍ਮਾਕੰ ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟੇਨ ਮੇਲਨੰ ਪ੍ਰਾਪ੍ਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","ਅਪਰੰ ਵਯੰ ਯਸ੍ਮਿਨ੍ ਅਨੁਗ੍ਰਹਾਸ਼੍ਰਯੇ ਤਿਸ਼਼੍ਠਾਮਸ੍ਤਨ੍ਮਧ੍ਯੰ ਵਿਸ਼੍ਵਾਸਮਾਰ੍ਗੇਣ ਤੇਨੈਵਾਨੀਤਾ ਵਯਮ੍ ਈਸ਼੍ਵਰੀਯਵਿਭਵਪ੍ਰਾਪ੍ਤਿਪ੍ਰਤ੍ਯਾਸ਼ਯਾ ਸਮਾਨਨ੍ਦਾਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","ਤਤ੍ ਕੇਵਲੰ ਨਹਿ ਕਿਨ੍ਤੁ ਕ੍ਲੇਸ਼ਭੋਗੇ(ਅ)ਪ੍ਯਾਨਨ੍ਦਾਮੋ ਯਤਃ ਕ੍ਲੇਸ਼ਾाਦ੍ ਧੈਰ੍ੱਯੰ ਜਾਯਤ ਇਤਿ ਵਯੰ ਜਾਨੀਮਃ, ");
INSERT INTO sanpun_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ਧੈਰ੍ੱਯਾੱਚ ਪਰੀਕ੍ਸ਼਼ਿਤਤ੍ਵੰ ਜਾਯਤੇ, ਪਰੀਕ੍ਸ਼਼ਿਤਤ੍ਵਾਤ੍ ਪ੍ਰਤ੍ਯਾਸ਼ਾ ਜਾਯਤੇ, ");
INSERT INTO sanpun_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","ਪ੍ਰਤ੍ਯਾਸ਼ਾਤੋ ਵ੍ਰੀਡਿਤਤ੍ਵੰ ਨ ਜਾਯਤੇ, ਯਸ੍ਮਾਦ੍ ਅਸ੍ਮਭ੍ਯੰ ਦੱਤੇਨ ਪਵਿਤ੍ਰੇਣਾਤ੍ਮਨਾਸ੍ਮਾਕਮ੍ ਅਨ੍ਤਃਕਰਣਾਨੀਸ਼੍ਵਰਸ੍ਯ ਪ੍ਰੇਮਵਾਰਿਣਾ ਸਿਕ੍ਤਾਨਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","ਅਸ੍ਮਾਸੁ ਨਿਰੁਪਾਯੇਸ਼਼ੁ ਸਤ੍ਸੁ ਖ੍ਰੀਸ਼਼੍ਟ ਉਪਯੁਕ੍ਤੇ ਸਮਯੇ ਪਾਪਿਨਾਂ ਨਿਮਿੱਤੰ ਸ੍ਵੀਯਾਨ੍ ਪ੍ਰਣਾਨ੍ ਅਤ੍ਯਜਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","ਹਿਤਕਾਰਿਣੋ ਜਨਸ੍ਯ ਕ੍ਰੁʼਤੇ ਕੋਪਿ ਪ੍ਰਣਾਨ੍ ਤ੍ਯਕ੍ਤੁੰ ਸਾਹਸੰ ਕਰ੍ੱਤੁੰ ਸ਼ਕ੍ਨੋਤਿ, ਕਿਨ੍ਤੁ ਧਾਰ੍ੰਮਿਕਸ੍ਯ ਕ੍ਰੁʼਤੇ ਪ੍ਰਾਯੇਣ ਕੋਪਿ ਪ੍ਰਾਣਾਨ੍ ਨ ਤ੍ਯਜਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","ਕਿਨ੍ਤ੍ਵਸ੍ਮਾਸੁ ਪਾਪਿਸ਼਼ੁ ਸਤ੍ਸ੍ਵਪਿ ਨਿਮਿੱਤਮਸ੍ਮਾਕੰ ਖ੍ਰੀਸ਼਼੍ਟਃ ਸ੍ਵਪ੍ਰਾਣਾਨ੍ ਤ੍ਯਕ੍ਤਵਾਨ੍, ਤਤ ਈਸ਼੍ਵਰੋਸ੍ਮਾਨ੍ ਪ੍ਰਤਿ ਨਿਜੰ ਪਰਮਪ੍ਰੇਮਾਣੰ ਦਰ੍ਸ਼ਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","ਅਤਏਵ ਤਸ੍ਯ ਰਕ੍ਤਪਾਤੇਨ ਸਪੁਣ੍ਯੀਕ੍ਰੁʼਤਾ ਵਯੰ ਨਿਤਾਨ੍ਤੰ ਤੇਨ ਕੋਪਾਦ੍ ਉੱਧਾਰਿਸ਼਼੍ਯਾਮਹੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","ਫਲਤੋ ਵਯੰ ਯਦਾ ਰਿਪਵ ਆਸ੍ਮ ਤਦੇਸ਼੍ਵਰਸ੍ਯ ਪੁਤ੍ਰਸ੍ਯ ਮਰਣੇਨ ਤੇਨ ਸਾਰ੍ੱਧੰ ਯਦ੍ਯਸ੍ਮਾਕੰ ਮੇਲਨੰ ਜਾਤੰ ਤਰ੍ਹਿ ਮੇਲਨਪ੍ਰਾਪ੍ਤਾਃ ਸਨ੍ਤੋ(ਅ)ਵਸ਼੍ਯੰ ਤਸ੍ਯ ਜੀਵਨੇਨ ਰਕ੍ਸ਼਼ਾਂ ਲਪ੍ਸ੍ਯਾਮਹੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","ਤਤ੍ ਕੇਵਲੰ ਨਹਿ ਕਿਨ੍ਤੁ ਯੇਨ ਮੇਲਨਮ੍ ਅਲਭਾਮਹਿ ਤੇਨਾਸ੍ਮਾਕੰ ਪ੍ਰਭੁਣਾ ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟੇਨ ਸਾਮ੍ਪ੍ਰਤਮ੍ ਈਸ਼੍ਵਰੇ ਸਮਾਨਨ੍ਦਾਮਸ਼੍ਚ| ");
INSERT INTO sanpun_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","ਤਥਾ ਸਤਿ, ਏਕੇਨ ਮਾਨੁਸ਼਼ੇਣ ਪਾਪੰ ਪਾਪੇਨ ਚ ਮਰਣੰ ਜਗਤੀਂ ਪ੍ਰਾਵਿਸ਼ਤ੍ ਅਪਰੰ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਪਾਪਿਤ੍ਵਾਤ੍ ਸਰ੍ੱਵੇ ਮਾਨੁਸ਼਼ਾ ਮ੍ਰੁʼਤੇ ਰ੍ਨਿਘ੍ਨਾ ਅਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","ਯਤੋ ਵ੍ਯਵਸ੍ਥਾਦਾਨਸਮਯੰ ਯਾਵਤ੍ ਜਗਤਿ ਪਾਪਮ੍ ਆਸੀਤ੍ ਕਿਨ੍ਤੁ ਯਤ੍ਰ ਵ੍ਯਵਸ੍ਥਾ ਨ ਵਿਦ੍ਯਤੇ ਤਤ੍ਰ ਪਾਪਸ੍ਯਾਪਿ ਗਣਨਾ ਨ ਵਿਦ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","ਤਥਾਪ੍ਯਾਦਮਾ ਯਾਦ੍ਰੁʼਸ਼ੰ ਪਾਪੰ ਕ੍ਰੁʼਤੰ ਤਾਦ੍ਰੁʼਸ਼ੰ ਪਾਪੰ ਯੈ ਰ੍ਨਾਕਾਰਿ ਆਦਮਮ੍ ਆਰਭ੍ਯ ਮੂਸਾਂ ਯਾਵਤ੍ ਤੇਸ਼਼ਾਮਪ੍ਯੁਪਰਿ ਮ੍ਰੁʼਤ੍ਯੂ ਰਾਜਤ੍ਵਮ੍ ਅਕਰੋਤ੍ ਸ ਆਦਮ੍ ਭਾਵ੍ਯਾਦਮੋ ਨਿਦਰ੍ਸ਼ਨਮੇਵਾਸ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","ਕਿਨ੍ਤੁ ਪਾਪਕਰ੍ੰਮਣੋ ਯਾਦ੍ਰੁʼਸ਼ੋ ਭਾਵਸ੍ਤਾਦ੍ਰੁʼਗ੍ ਦਾਨਕਰ੍ੰਮਣੋ ਭਾਵੋ ਨ ਭਵਤਿ ਯਤ ਏਕਸ੍ਯ ਜਨਸ੍ਯਾਪਰਾਧੇਨ ਯਦਿ ਬਹੂਨਾਂ ਮਰਣਮ੍ ਅਘਟਤ ਤਥਾਪੀਸ਼੍ਵਰਾਨੁਗ੍ਰਹਸ੍ਤਦਨੁਗ੍ਰਹਮੂਲਕੰ ਦਾਨਞ੍ਚੈਕੇਨ ਜਨੇਨਾਰ੍ਥਾਦ੍ ਯੀਸ਼ੁਨਾ ਖ੍ਰੀਸ਼਼੍ਟੇਨ ਬਹੁਸ਼਼ੁ ਬਾਹੁਲ੍ਯਾਤਿਬਾਹੁਲ੍ਯੇਨ ਫਲਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","ਅਪਰਮ੍ ਏਕਸ੍ਯ ਜਨਸ੍ਯ ਪਾਪਕਰ੍ੰਮ ਯਾਦ੍ਰੁʼਕ੍ ਫਲਯੁਕ੍ਤੰ ਦਾਨਕਰ੍ੰਮ ਤਾਦ੍ਰੁʼਕ੍ ਨ ਭਵਤਿ ਯਤੋ ਵਿਚਾਰਕਰ੍ੰਮੈਕੰ ਪਾਪਮ੍ ਆਰਭ੍ਯ ਦਣ੍ਡਜਨਕੰ ਬਭੂਵ, ਕਿਨ੍ਤੁ ਦਾਨਕਰ੍ੰਮ ਬਹੁਪਾਪਾਨ੍ਯਾਰਭ੍ਯ ਪੁਣ੍ਯਜਨਕੰ ਬਭੂਵ| ");
INSERT INTO sanpun_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","ਯਤ ਏਕਸ੍ਯ ਜਨਸ੍ਯ ਪਾਪਕਰ੍ੰਮਤਸ੍ਤੇਨੈਕੇਨ ਯਦਿ ਮਰਣਸ੍ਯ ਰਾਜਤ੍ਵੰ ਜਾਤੰ ਤਰ੍ਹਿ ਯੇ ਜਨਾ ਅਨੁਗ੍ਰਹਸ੍ਯ ਬਾਹੁਲ੍ਯੰ ਪੁਣ੍ਯਦਾਨਞ੍ਚ ਪ੍ਰਾਪ੍ਨੁਵਨ੍ਤਿ ਤ ਏਕੇਨ ਜਨੇਨ, ਅਰ੍ਥਾਤ੍ ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟੇਨ, ਜੀਵਨੇ ਰਾਜਤ੍ਵਮ੍ ਅਵਸ਼੍ਯੰ ਕਰਿਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","ਏਕੋ(ਅ)ਪਰਾਧੋ ਯਦ੍ਵਤ੍ ਸਰ੍ੱਵਮਾਨਵਾਨਾਂ ਦਣ੍ਡਗਾਮੀ ਮਾਰ੍ਗੋ (ਅ)ਭਵਤ੍ ਤਦ੍ਵਦ੍ ਏਕੰ ਪੁਣ੍ਯਦਾਨੰ ਸਰ੍ੱਵਮਾਨਵਾਨਾਂ ਜੀਵਨਯੁਕ੍ਤਪੁਣ੍ਯਗਾਮੀ ਮਾਰ੍ਗ ਏਵ| ");
INSERT INTO sanpun_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","ਅਪਰਮ੍ ਏਕਸ੍ਯ ਜਨਸ੍ਯਾਜ੍ਞਾਲਙ੍ਘਨਾਦ੍ ਯਥਾ ਬਹਵੋ (ਅ)ਪਰਾਧਿਨੋ ਜਾਤਾਸ੍ਤਦ੍ਵਦ੍ ਏਕਸ੍ਯਾਜ੍ਞਾਚਰਣਾਦ੍ ਬਹਵਃ ਸਪੁਣ੍ਯੀਕ੍ਰੁʼਤਾ ਭਵਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","ਅਧਿਕਨ੍ਤੁ ਵ੍ਯਵਸ੍ਥਾਗਮਨਾਦ੍ ਅਪਰਾਧਸ੍ਯ ਬਾਹੁਲ੍ਯੰ ਜਾਤੰ ਕਿਨ੍ਤੁ ਯਤ੍ਰ ਪਾਪਸ੍ਯ ਬਾਹੁਲ੍ਯੰ ਤਤ੍ਰੈਵ ਤਸ੍ਮਾਦ੍ ਅਨੁਗ੍ਰਹਸ੍ਯ ਬਾਹੁਲ੍ਯਮ੍ ਅਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","ਤੇਨ ਮ੍ਰੁʼਤ੍ਯੁਨਾ ਯਦ੍ਵਤ੍ ਪਾਪਸ੍ਯ ਰਾਜਤ੍ਵਮ੍ ਅਭਵਤ੍ ਤਦ੍ਵਦ੍ ਅਸ੍ਮਾਕੰ ਪ੍ਰਭੁਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟਦ੍ਵਾਰਾਨਨ੍ਤਜੀਵਨਦਾਯਿਪੁਣ੍ਯੇਨਾਨੁਗ੍ਰਹਸ੍ਯ ਰਾਜਤ੍ਵੰ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","ਪ੍ਰਭੂਤਰੂਪੇਣ ਯਦ੍ ਅਨੁਗ੍ਰਹਃ ਪ੍ਰਕਾਸ਼ਤੇ ਤਦਰ੍ਥੰ ਪਾਪੇ ਤਿਸ਼਼੍ਠਾਮ ਇਤਿ ਵਾਕ੍ਯੰ ਕਿੰ ਵਯੰ ਵਦਿਸ਼਼੍ਯਾਮਃ? ਤੰਨ ਭਵਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","ਪਾਪੰ ਪ੍ਰਤਿ ਮ੍ਰੁʼਤਾ ਵਯੰ ਪੁਨਸ੍ਤਸ੍ਮਿਨ੍ ਕਥਮ੍ ਜੀਵਿਸ਼਼੍ਯਾਮਃ? ");
INSERT INTO sanpun_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","ਵਯੰ ਯਾਵਨ੍ਤੋ ਲੋਕਾ ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟੇ ਮੱਜਿਤਾ ਅਭਵਾਮ ਤਾਵਨ੍ਤ ਏਵ ਤਸ੍ਯ ਮਰਣੇ ਮੱਜਿਤਾ ਇਤਿ ਕਿੰ ਯੂਯੰ ਨ ਜਾਨੀਥ? ");
INSERT INTO sanpun_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","ਤਤੋ ਯਥਾ ਪਿਤੁਃ ਪਰਾਕ੍ਰਮੇਣ ਸ਼੍ਮਸ਼ਾਨਾਤ੍ ਖ੍ਰੀਸ਼਼੍ਟ ਉੱਥਾਪਿਤਸ੍ਤਥਾ ਵਯਮਪਿ ਯਤ੍ ਨੂਤਨਜੀਵਿਨ ਇਵਾਚਰਾਮਸ੍ਤਦਰ੍ਥੰ ਮੱਜਨੇਨ ਤੇਨ ਸਾਰ੍ੱਧੰ ਮ੍ਰੁʼਤ੍ਯੁਰੂਪੇ ਸ਼੍ਮਸ਼ਾਨੇ ਸੰਸ੍ਥਾਪਿਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","ਅਪਰੰ ਵਯੰ ਯਦਿ ਤੇਨ ਸੰਯੁਕ੍ਤਾਃ ਸਨ੍ਤਃ ਸ ਇਵ ਮਰਣਭਾਗਿਨੋ ਜਾਤਾਸ੍ਤਰ੍ਹਿ ਸ ਇਵੋੱਥਾਨਭਾਗਿਨੋ(ਅ)ਪਿ ਭਵਿਸ਼਼੍ਯਾਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","ਵਯੰ ਯਤ੍ ਪਾਪਸ੍ਯ ਦਾਸਾਃ ਪੁਨ ਰ੍ਨ ਭਵਾਮਸ੍ਤਦਰ੍ਥਮ੍ ਅਸ੍ਮਾਕੰ ਪਾਪਰੂਪਸ਼ਰੀਰਸ੍ਯ ਵਿਨਾਸ਼ਾਰ੍ਥਮ੍ ਅਸ੍ਮਾਕੰ ਪੁਰਾਤਨਪੁਰੁਸ਼਼ਸ੍ਤੇਨ ਸਾਕੰ ਕ੍ਰੁਸ਼ੇ(ਅ)ਹਨ੍ਯਤੇਤਿ ਵਯੰ ਜਾਨੀਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","ਯੋ ਹਤਃ ਸ ਪਾਪਾਤ੍ ਮੁਕ੍ਤ ਏਵ| ");
INSERT INTO sanpun_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","ਅਤਏਵ ਯਦਿ ਵਯੰ ਖ੍ਰੀਸ਼਼੍ਟੇਨ ਸਾਰ੍ੱਧਮ੍ ਅਹਨ੍ਯਾਮਹਿ ਤਰ੍ਹਿ ਪੁਨਰਪਿ ਤੇਨ ਸਹਿਤਾ ਜੀਵਿਸ਼਼੍ਯਾਮ ਇਤ੍ਯਤ੍ਰਾਸ੍ਮਾਕੰ ਵਿਸ਼੍ਵਾਸੋ ਵਿਦ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","ਯਤਃ ਸ਼੍ਮਸ਼ਾਨਾਦ੍ ਉੱਥਾਪਿਤਃ ਖ੍ਰੀਸ਼਼੍ਟੋ ਪੁਨ ਰ੍ਨ ਮ੍ਰਿਯਤ ਇਤਿ ਵਯੰ ਜਾਨੀਮਃ| ਤਸ੍ਮਿਨ੍ ਕੋਪ੍ਯਧਿਕਾਰੋ ਮ੍ਰੁʼਤ੍ਯੋ ਰ੍ਨਾਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","ਅਪਰਞ੍ਚ ਸ ਯਦ੍ ਅਮ੍ਰਿਯਤ ਤੇਨੈਕਦਾ ਪਾਪਮ੍ ਉੱਦਿਸ਼੍ਯਾਮ੍ਰਿਯਤ, ਯੱਚ ਜੀਵਤਿ ਤੇਨੇਸ਼੍ਵਰਮ੍ ਉੱਦਿਸ਼੍ਯ ਜੀਵਤਿ; ");
INSERT INTO sanpun_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","ਤਦ੍ਵਦ੍ ਯੂਯਮਪਿ ਸ੍ਵਾਨ੍ ਪਾਪਮ੍ ਉੱਦਿਸ਼੍ਯ ਮ੍ਰੁʼਤਾਨ੍ ਅਸ੍ਮਾਕੰ ਪ੍ਰਭੁਣਾ ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟੇਨੇਸ਼੍ਵਰਮ੍ ਉੱਦਿਸ਼੍ਯ ਜੀਵਨ੍ਤੋ ਜਾਨੀਤ| ");
INSERT INTO sanpun_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","ਅਪਰਞ੍ਚ ਕੁਤ੍ਸਿਤਾਭਿਲਾਸ਼਼ਾाਨ੍ ਪੂਰਯਿਤੁੰ ਯੁਸ਼਼੍ਮਾਕੰ ਮਰ੍ਤ੍ਯਦੇਹੇਸ਼਼ੁ ਪਾਪਮ੍ ਆਧਿਪਤ੍ਯੰ ਨ ਕਰੋਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","ਅਪਰੰ ਸ੍ਵੰ ਸ੍ਵਮ੍ ਅਙ੍ਗਮ੍ ਅਧਰ੍ੰਮਸ੍ਯਾਸ੍ਤ੍ਰੰ ਕ੍ਰੁʼਤ੍ਵਾ ਪਾਪਸੇਵਾਯਾਂ ਨ ਸਮਰ੍ਪਯਤ, ਕਿਨ੍ਤੁ ਸ਼੍ਮਸ਼ਾਨਾਦ੍ ਉੱਥਿਤਾਨਿਵ ਸ੍ਵਾਨ੍ ਈਸ਼੍ਵਰੇ ਸਮਰ੍ਪਯਤ ਸ੍ਵਾਨ੍ਯਙ੍ਗਾਨਿ ਚ ਧਰ੍ੰਮਾਸ੍ਤ੍ਰਸ੍ਵਰੂਪਾਣੀਸ਼੍ਵਰਮ੍ ਉੱਦਿਸ਼੍ਯ ਸਮਰ੍ਪਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","ਯੁਸ਼਼੍ਮਾਕਮ੍ ਉਪਰਿ ਪਾਪਸ੍ਯਾਧਿਪਤ੍ਯੰ ਪੁਨ ਰ੍ਨ ਭਵਿਸ਼਼੍ਯਤਿ, ਯਸ੍ਮਾਦ੍ ਯੂਯੰ ਵ੍ਯਵਸ੍ਥਾਯਾ ਅਨਾਯੱਤਾ ਅਨੁਗ੍ਰਹਸ੍ਯ ਚਾਯੱਤਾ ਅਭਵਤ| ");
INSERT INTO sanpun_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","ਕਿਨ੍ਤੁ ਵਯੰ ਵ੍ਯਵਸ੍ਥਾਯਾ ਅਨਾਯੱਤਾ ਅਨੁਗ੍ਰਹਸ੍ਯ ਚਾਯੱਤਾ ਅਭਵਾਮ, ਇਤਿ ਕਾਰਣਾਤ੍ ਕਿੰ ਪਾਪੰ ਕਰਿਸ਼਼੍ਯਾਮਃ? ਤੰਨ ਭਵਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","ਯਤੋ ਮ੍ਰੁʼਤਿਜਨਕੰ ਪਾਪੰ ਪੁਣ੍ਯਜਨਕੰ ਨਿਦੇਸ਼ਾਚਰਣਞ੍ਚੈਤਯੋਰ੍ਦ੍ਵਯੋ ਰ੍ਯਸ੍ਮਿਨ੍ ਆਜ੍ਞਾਪਾਲਨਾਰ੍ਥੰ ਭ੍ਰੁʼਤ੍ਯਾਨਿਵ ਸ੍ਵਾਨ੍ ਸਮਰ੍ਪਯਥ, ਤਸ੍ਯੈਵ ਭ੍ਰੁʼਤ੍ਯਾ ਭਵਥ, ਏਤਤ੍ ਕਿੰ ਯੂਯੰ ਨ ਜਾਨੀਥ? ");
INSERT INTO sanpun_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","ਅਪਰਞ੍ਚ ਪੂਰ੍ੱਵੰ ਯੂਯੰ ਪਾਪਸ੍ਯ ਭ੍ਰੁʼਤ੍ਯਾ ਆਸ੍ਤੇਤਿ ਸਤ੍ਯੰ ਕਿਨ੍ਤੁ ਯਸ੍ਯਾਂ ਸ਼ਿਕ੍ਸ਼਼ਾਰੂਪਾਯਾਂ ਮੂਸ਼਼ਾਯਾਂ ਨਿਕ੍ਸ਼਼ਿਪ੍ਤਾ ਅਭਵਤ ਤਸ੍ਯਾ ਆਕ੍ਰੁʼਤਿੰ ਮਨੋਭਿ ਰ੍ਲਬ੍ਧਵਨ੍ਤ ਇਤਿ ਕਾਰਣਾਦ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਧਨ੍ਯਵਾਦੋ ਭਵਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","ਇੱਥੰ ਯੂਯੰ ਪਾਪਸੇਵਾਤੋ ਮੁਕ੍ਤਾਃ ਸਨ੍ਤੋ ਧਰ੍ੰਮਸ੍ਯ ਭ੍ਰੁʼਤ੍ਯਾ ਜਾਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","ਯੁਸ਼਼੍ਮਾਕੰ ਸ਼ਾਰੀਰਿਕ੍ਯਾ ਦੁਰ੍ੱਬਲਤਾਯਾ ਹੇਤੋ ਰ੍ਮਾਨਵਵਦ੍ ਅਹਮ੍ ਏਤਦ੍ ਬ੍ਰਵੀਮਿ; ਪੁਨਃ ਪੁਨਰਧਰ੍ੰਮਕਰਣਾਰ੍ਥੰ ਯਦ੍ਵਤ੍ ਪੂਰ੍ੱਵੰ ਪਾਪਾਮੇਧ੍ਯਯੋ ਰ੍ਭ੍ਰੁʼਤ੍ਯਤ੍ਵੇ ਨਿਜਾਙ੍ਗਾਨਿ ਸਮਾਰ੍ਪਯਤ ਤਦ੍ਵਦ੍ ਇਦਾਨੀਂ ਸਾਧੁਕਰ੍ੰਮਕਰਣਾਰ੍ਥੰ ਧਰ੍ੰਮਸ੍ਯ ਭ੍ਰੁʼਤ੍ਯਤ੍ਵੇ ਨਿਜਾਙ੍ਗਾਨਿ ਸਮਰ੍ਪਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","ਯਦਾ ਯੂਯੰ ਪਾਪਸ੍ਯ ਭ੍ਰੁʼਤ੍ਯਾ ਆਸ੍ਤ ਤਦਾ ਧਰ੍ੰਮਸ੍ਯ ਨਾਯੱਤਾ ਆਸ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","ਤਰ੍ਹਿ ਯਾਨਿ ਕਰ੍ੰਮਾਣਿ ਯੂਯਮ੍ ਇਦਾਨੀਂ ਲੱਜਾਜਨਕਾਨਿ ਬੁਧ੍ਯਧ੍ਵੇ ਪੂਰ੍ੱਵੰ ਤੈ ਰ੍ਯੁਸ਼਼੍ਮਾਕੰ ਕੋ ਲਾਭ ਆਸੀਤ੍? ਤੇਸ਼਼ਾਂ ਕਰ੍ੰਮਣਾਂ ਫਲੰ ਮਰਣਮੇਵ| ");
INSERT INTO sanpun_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","ਕਿਨ੍ਤੁ ਸਾਮ੍ਪ੍ਰਤੰ ਯੂਯੰ ਪਾਪਸੇਵਾਤੋ ਮੁਕ੍ਤਾਃ ਸਨ੍ਤ ਈਸ਼੍ਵਰਸ੍ਯ ਭ੍ਰੁʼਤ੍ਯਾ(ਅ)ਭਵਤ ਤਸ੍ਮਾਦ੍ ਯੁਸ਼਼੍ਮਾਕੰ ਪਵਿਤ੍ਰਤ੍ਵਰੂਪੰ ਲਭ੍ਯਮ੍ ਅਨਨ੍ਤਜੀਵਨਰੂਪਞ੍ਚ ਫਲਮ੍ ਆਸ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","ਯਤਃ ਪਾਪਸ੍ਯ ਵੇਤਨੰ ਮਰਣੰ ਕਿਨ੍ਤ੍ਵਸ੍ਮਾਕੰ ਪ੍ਰਭੁਣਾ ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟੇਨਾਨਨ੍ਤਜੀਵਨਮ੍ ਈਸ਼੍ਵਰਦੱਤੰ ਪਾਰਿਤੋਸ਼਼ਿਕਮ੍ ਆਸ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","ਹੇ ਭ੍ਰਾਤ੍ਰੁʼਗਣ ਵ੍ਯਵਸ੍ਥਾਵਿਦਃ ਪ੍ਰਤਿ ਮਮੇਦੰ ਨਿਵੇਦਨੰ| ਵਿਧਿਃ ਕੇਵਲੰ ਯਾਵੱਜੀਵੰ ਮਾਨਵੋਪਰ੍ੱਯਧਿਪਤਿਤ੍ਵੰ ਕਰੋਤੀਤਿ ਯੂਯੰ ਕਿੰ ਨ ਜਾਨੀਥ? ");
INSERT INTO sanpun_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","ਯਾਵਤ੍ਕਾਲੰ ਪਤਿ ਰ੍ਜੀਵਤਿ ਤਾਵਤ੍ਕਾਲਮ੍ ਊਢਾ ਭਾਰ੍ੱਯਾ ਵ੍ਯਵਸ੍ਥਯਾ ਤਸ੍ਮਿਨ੍ ਬੱਧਾ ਤਿਸ਼਼੍ਠਤਿ ਕਿਨ੍ਤੁ ਯਦਿ ਪਤਿ ਰ੍ਮ੍ਰਿਯਤੇ ਤਰ੍ਹਿ ਸਾ ਨਾਰੀ ਪਤ੍ਯੁ ਰ੍ਵ੍ਯਵਸ੍ਥਾਤੋ ਮੁਚ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","ਏਤਤ੍ਕਾਰਣਾਤ੍ ਪਤ੍ਯੁਰ੍ਜੀਵਨਕਾਲੇ ਨਾਰੀ ਯਦ੍ਯਨ੍ਯੰ ਪੁਰੁਸ਼਼ੰ ਵਿਵਹਤਿ ਤਰ੍ਹਿ ਸਾ ਵ੍ਯਭਿਚਾਰਿਣੀ ਭਵਤਿ ਕਿਨ੍ਤੁ ਯਦਿ ਸ ਪਤਿ ਰ੍ਮ੍ਰਿਯਤੇ ਤਰ੍ਹਿ ਸਾ ਤਸ੍ਯਾ ਵ੍ਯਵਸ੍ਥਾਯਾ ਮੁਕ੍ਤਾ ਸਤੀ ਪੁਰੁਸ਼਼ਾਨ੍ਤਰੇਣ ਵ੍ਯੂਢਾਪਿ ਵ੍ਯਭਿਚਾਰਿਣੀ ਨ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","ਹੇ ਮਮ ਭ੍ਰਾਤ੍ਰੁʼਗਣ, ਈਸ਼੍ਵਰਨਿਮਿੱਤੰ ਯਦਸ੍ਮਾਕੰ ਫਲੰ ਜਾਯਤੇ ਤਦਰ੍ਥੰ ਸ਼੍ਮਸ਼ਾਨਾਦ੍ ਉੱਥਾਪਿਤੇਨ ਪੁਰੁਸ਼਼ੇਣ ਸਹ ਯੁਸ਼਼੍ਮਾਕੰ ਵਿਵਾਹੋ ਯਦ੍ ਭਵੇਤ੍ ਤਦਰ੍ਥੰ ਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਸ਼ਰੀਰੇਣ ਯੂਯੰ ਵ੍ਯਵਸ੍ਥਾਂ ਪ੍ਰਤਿ ਮ੍ਰੁʼਤਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","ਯਤੋ(ਅ)ਸ੍ਮਾਕੰ ਸ਼ਾਰੀਰਿਕਾਚਰਣਸਮਯੇ ਮਰਣਨਿਮਿੱਤੰ ਫਲਮ੍ ਉਤ੍ਪਾਦਯਿਤੁੰ ਵ੍ਯਵਸ੍ਥਯਾ ਦੂਸ਼਼ਿਤਃ ਪਾਪਾਭਿਲਾਸ਼਼ੋ(ਅ)ਸ੍ਮਾਕਮ੍ ਅਙ੍ਗੇਸ਼਼ੁ ਜੀਵਨ੍ ਆਸੀਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","ਕਿਨ੍ਤੁ ਤਦਾ ਯਸ੍ਯਾ ਵ੍ਯਵਸ੍ਥਾਯਾ ਵਸ਼ੇ ਆਸ੍ਮਹਿ ਸਾਮ੍ਪ੍ਰਤੰ ਤਾਂ ਪ੍ਰਤਿ ਮ੍ਰੁʼਤਤ੍ਵਾਦ੍ ਵਯੰ ਤਸ੍ਯਾ ਅਧੀਨਤ੍ਵਾਤ੍ ਮੁਕ੍ਤਾ ਇਤਿ ਹੇਤੋਰੀਸ਼੍ਵਰੋ(ਅ)ਸ੍ਮਾਭਿਃ ਪੁਰਾਤਨਲਿਖਿਤਾਨੁਸਾਰਾਤ੍ ਨ ਸੇਵਿਤਵ੍ਯਃ ਕਿਨ੍ਤੁ ਨਵੀਨਸ੍ਵਭਾਵੇਨੈਵ ਸੇਵਿਤਵ੍ਯਃ ");
INSERT INTO sanpun_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","ਤਰ੍ਹਿ ਵਯੰ ਕਿੰ ਬ੍ਰੂਮਃ? ਵ੍ਯਵਸ੍ਥਾ ਕਿੰ ਪਾਪਜਨਿਕਾ ਭਵਤਿ? ਨੇੱਥੰ ਭਵਤੁ| ਵ੍ਯਵਸ੍ਥਾਮ੍ ਅਵਿਦ੍ਯਮਾਨਾਯਾਂ ਪਾਪੰ ਕਿਮ੍ ਇਤ੍ਯਹੰ ਨਾਵੇਦੰ; ਕਿਞ੍ਚ ਲੋਭੰ ਮਾ ਕਾਰ੍ਸ਼਼ੀਰਿਤਿ ਚੇਦ੍ ਵ੍ਯਵਸ੍ਥਾਗ੍ਰਨ੍ਥੇ ਲਿਖਿਤੰ ਨਾਭਵਿਸ਼਼੍ਯਤ੍ ਤਰ੍ਹਿ ਲੋਭਃ ਕਿਮ੍ਭੂਤਸ੍ਤਦਹੰ ਨਾਜ੍ਞਾਸ੍ਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","ਕਿਨ੍ਤੁ ਵ੍ਯਵਸ੍ਥਯਾ ਪਾਪੰ ਛਿਦ੍ਰੰ ਪ੍ਰਾਪ੍ਯਾਸ੍ਮਾਕਮ੍ ਅਨ੍ਤਃ ਸਰ੍ੱਵਵਿਧੰ ਕੁਤ੍ਸਿਤਾਭਿਲਾਸ਼਼ਮ੍ ਅਜਨਯਤ੍; ਯਤੋ ਵ੍ਯਵਸ੍ਥਾਯਾਮ੍ ਅਵਿਦ੍ਯਮਾਨਾਯਾਂ ਪਾਪੰ ਮ੍ਰੁʼਤੰ| ");
INSERT INTO sanpun_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","ਅਪਰੰ ਪੂਰ੍ੱਵੰ ਵ੍ਯਵਸ੍ਥਾਯਾਮ੍ ਅਵਿਦ੍ਯਮਾਨਾਯਾਮ੍ ਅਹਮ੍ ਅਜੀਵੰ ਤਤਃ ਪਰਮ੍ ਆਜ੍ਞਾਯਾਮ੍ ਉਪਸ੍ਥਿਤਾਯਾਮ੍ ਪਾਪਮ੍ ਅਜੀਵਤ੍ ਤਦਾਹਮ੍ ਅਮ੍ਰਿਯੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","ਇੱਥੰ ਸਤਿ ਜੀਵਨਨਿਮਿੱਤਾ ਯਾਜ੍ਞਾ ਸਾ ਮਮ ਮ੍ਰੁʼਤ੍ਯੁਜਨਿਕਾਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","ਯਤਃ ਪਾਪੰ ਛਿਦ੍ਰੰ ਪ੍ਰਾਪ੍ਯ ਵ੍ਯਵਸ੍ਥਿਤਾਦੇਸ਼ੇਨ ਮਾਂ ਵਞ੍ਚਯਿਤ੍ਵਾ ਤੇਨ ਮਾਮ੍ ਅਹਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","ਅਤਏਵ ਵ੍ਯਵਸ੍ਥਾ ਪਵਿਤ੍ਰਾ, ਆਦੇਸ਼ਸ਼੍ਚ ਪਵਿਤ੍ਰੋ ਨ੍ਯਾੱਯੋ ਹਿਤਕਾਰੀ ਚ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","ਤਰ੍ਹਿ ਯਤ੍ ਸ੍ਵਯੰ ਹਿਤਕ੍ਰੁʼਤ੍ ਤਤ੍ ਕਿੰ ਮਮ ਮ੍ਰੁʼਤ੍ਯੁਜਨਕਮ੍ ਅਭਵਤ੍? ਨੇੱਥੰ ਭਵਤੁ; ਕਿਨ੍ਤੁ ਪਾਪੰ ਯਤ੍ ਪਾਤਕਮਿਵ ਪ੍ਰਕਾਸ਼ਤੇ ਤਥਾ ਨਿਦੇਸ਼ੇਨ ਪਾਪੰ ਯਦਤੀਵ ਪਾਤਕਮਿਵ ਪ੍ਰਕਾਸ਼ਤੇ ਤਦਰ੍ਥੰ ਹਿਤੋਪਾਯੇਨ ਮਮ ਮਰਣਮ੍ ਅਜਨਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","ਵ੍ਯਵਸ੍ਥਾਤ੍ਮਬੋਧਿਕੇਤਿ ਵਯੰ ਜਾਨੀਮਃ ਕਿਨ੍ਤ੍ਵਹੰ ਸ਼ਾਰੀਰਤਾਚਾਰੀ ਪਾਪਸ੍ਯ ਕ੍ਰੀਤਕਿਙ੍ਕਰੋ ਵਿਦ੍ਯੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","ਯਤੋ ਯਤ੍ ਕਰ੍ੰਮ ਕਰੋਮਿ ਤਤ੍ ਮਮ ਮਨੋ(ਅ)ਭਿਮਤੰ ਨਹਿ; ਅਪਰੰ ਯਨ੍ ਮਮ ਮਨੋ(ਅ)ਭਿਮਤੰ ਤੰਨ ਕਰੋਮਿ ਕਿਨ੍ਤੁ ਯਦ੍ ਰੁʼਤੀਯੇ ਤਤ੍ ਕਰੋਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","ਤਥਾਤ੍ਵੇ ਯਨ੍ ਮਮਾਨਭਿਮਤੰ ਤਦ੍ ਯਦਿ ਕਰੋਮਿ ਤਰ੍ਹਿ ਵ੍ਯਵਸ੍ਥਾ ਸੂੱਤਮੇਤਿ ਸ੍ਵੀਕਰੋਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","ਅਤਏਵ ਸਮ੍ਪ੍ਰਤਿ ਤਤ੍ ਕਰ੍ੰਮ ਮਯਾ ਕ੍ਰਿਯਤ ਇਤਿ ਨਹਿ ਕਿਨ੍ਤੁ ਮਮ ਸ਼ਰੀਰਸ੍ਥੇਨ ਪਾਪੇਨੈਵ ਕ੍ਰਿਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","ਯਤੋ ਮਯਿ, ਅਰ੍ਥਤੋ ਮਮ ਸ਼ਰੀਰੇ, ਕਿਮਪ੍ਯੁੱਤਮੰ ਨ ਵਸਤਿ, ਏਤਦ੍ ਅਹੰ ਜਾਨਾਮਿ; ਮਮੇੱਛੁਕਤਾਯਾਂ ਤਿਸ਼਼੍ਠਨ੍ਤ੍ਯਾਮਪ੍ਯਹਮ੍ ਉੱਤਮਕਰ੍ੰਮਸਾਧਨੇ ਸਮਰ੍ਥੋ ਨ ਭਵਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","ਯਤੋ ਯਾਮੁੱਤਮਾਂ ਕ੍ਰਿਯਾਂ ਕਰ੍ੱਤੁਮਹੰ ਵਾਞ੍ਛਾਮਿ ਤਾਂ ਨ ਕਰੋਮਿ ਕਿਨ੍ਤੁ ਯਤ੍ ਕੁਤ੍ਸਿਤੰ ਕਰ੍ੰਮ ਕਰ੍ੱਤੁਮ੍ ਅਨਿੱਛੁਕੋ(ਅ)ਸ੍ਮਿ ਤਦੇਵ ਕਰੋਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","ਅਤਏਵ ਯਦ੍ਯਤ੍ ਕਰ੍ੰਮ ਕਰ੍ੱਤੁੰ ਮਮੇੱਛਾ ਨ ਭਵਤਿ ਤਦ੍ ਯਦਿ ਕਰੋਮਿ ਤਰ੍ਹਿ ਤਤ੍ ਮਯਾ ਨ ਕ੍ਰਿਯਤੇ, ਮਮਾਨ੍ਤਰ੍ਵਰ੍ੱਤਿਨਾ ਪਾਪੇਨੈਵ ਕ੍ਰਿਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","ਭਦ੍ਰੰ ਕਰ੍ੱਤੁਮ੍ ਇੱਛੁਕੰ ਮਾਂ ਯੋ (ਅ)ਭਦ੍ਰੰ ਕਰ੍ੱਤੁੰ ਪ੍ਰਵਰ੍ੱਤਯਤਿ ਤਾਦ੍ਰੁʼਸ਼ੰ ਸ੍ਵਭਾਵਮੇਕੰ ਮਯਿ ਪਸ਼੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","ਅਹਮ੍ ਆਨ੍ਤਰਿਕਪੁਰੁਸ਼਼ੇਣੇਸ਼੍ਵਰਵ੍ਯਵਸ੍ਥਾਯਾਂ ਸਨ੍ਤੁਸ਼਼੍ਟ ਆਸੇ; ");
INSERT INTO sanpun_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","ਕਿਨ੍ਤੁ ਤਦ੍ਵਿਪਰੀਤੰ ਯੁਧ੍ਯਨ੍ਤੰ ਤਦਨ੍ਯਮੇਕੰ ਸ੍ਵਭਾਵੰ ਮਦੀਯਾਙ੍ਗਸ੍ਥਿਤੰ ਪ੍ਰਪਸ਼੍ਯਾਮਿ, ਸ ਮਦੀਯਾਙ੍ਗਸ੍ਥਿਤਪਾਪਸ੍ਵਭਾਵਸ੍ਯਾਯੱਤੰ ਮਾਂ ਕਰ੍ੱਤੁੰ ਚੇਸ਼਼੍ਟਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","ਹਾ ਹਾ ਯੋ(ਅ)ਹੰ ਦੁਰ੍ਭਾਗ੍ਯੋ ਮਨੁਜਸ੍ਤੰ ਮਾਮ੍ ਏਤਸ੍ਮਾਨ੍ ਮ੍ਰੁʼਤਾੱਛਰੀਰਾਤ੍ ਕੋ ਨਿਸ੍ਤਾਰਯਿਸ਼਼੍ਯਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","ਅਸ੍ਮਾਕੰ ਪ੍ਰਭੁਣਾ ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟੇਨ ਨਿਸ੍ਤਾਰਯਿਤਾਰਮ੍ ਈਸ਼੍ਵਰੰ ਧਨ੍ਯੰ ਵਦਾਮਿ| ਅਤਏਵ ਸ਼ਰੀਰੇਣ ਪਾਪਵ੍ਯਵਸ੍ਥਾਯਾ ਮਨਸਾ ਤੁ ਈਸ਼੍ਵਰਵ੍ਯਵਸ੍ਥਾਯਾਃ ਸੇਵਨੰ ਕਰੋਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","ਯੇ ਜਨਾਃ ਖ੍ਰੀਸ਼਼੍ਟੰ ਯੀਸ਼ੁਮ੍ ਆਸ਼੍ਰਿਤ੍ਯ ਸ਼ਾਰੀਰਿਕੰ ਨਾਚਰਨ੍ਤ ਆਤ੍ਮਿਕਮਾਚਰਨ੍ਤਿ ਤੇ(ਅ)ਧੁਨਾ ਦਣ੍ਡਾਰ੍ਹਾ ਨ ਭਵਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","ਜੀਵਨਦਾਯਕਸ੍ਯਾਤ੍ਮਨੋ ਵ੍ਯਵਸ੍ਥਾ ਖ੍ਰੀਸ਼਼੍ਟਯੀਸ਼ੁਨਾ ਪਾਪਮਰਣਯੋ ਰ੍ਵ੍ਯਵਸ੍ਥਾਤੋ ਮਾਮਮੋਚਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","ਯਸ੍ਮਾੱਛਾਰੀਰਸ੍ਯ ਦੁਰ੍ੱਬਲਤ੍ਵਾਦ੍ ਵ੍ਯਵਸ੍ਥਯਾ ਯਤ੍ ਕਰ੍ੰਮਾਸਾਧ੍ਯਮ੍ ਈਸ਼੍ਵਰੋ ਨਿਜਪੁਤ੍ਰੰ ਪਾਪਿਸ਼ਰੀਰਰੂਪੰ ਪਾਪਨਾਸ਼ਕਬਲਿਰੂਪਞ੍ਚ ਪ੍ਰੇਸ਼਼੍ਯ ਤਸ੍ਯ ਸ਼ਰੀਰੇ ਪਾਪਸ੍ਯ ਦਣ੍ਡੰ ਕੁਰ੍ੱਵਨ੍ ਤਤ੍ਕਰ੍ੰਮ ਸਾਧਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","ਤਤਃ ਸ਼ਾਰੀਰਿਕੰ ਨਾਚਰਿਤ੍ਵਾਸ੍ਮਾਭਿਰਾਤ੍ਮਿਕਮ੍ ਆਚਰਦ੍ਭਿਰ੍ਵ੍ਯਵਸ੍ਥਾਗ੍ਰਨ੍ਥੇ ਨਿਰ੍ੱਦਿਸ਼਼੍ਟਾਨਿ ਪੁਣ੍ਯਕਰ੍ੰਮਾਣਿ ਸਰ੍ੱਵਾਣਿ ਸਾਧ੍ਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","ਯੇ ਸ਼ਾਰੀਰਿਕਾਚਾਰਿਣਸ੍ਤੇ ਸ਼ਾਰੀਰਿਕਾਨ੍ ਵਿਸ਼਼ਯਾਨ੍ ਭਾਵਯਨ੍ਤਿ ਯੇ ਚਾਤ੍ਮਿਕਾਚਾਰਿਣਸ੍ਤੇ ਆਤ੍ਮਨੋ ਵਿਸ਼਼ਯਾਨ੍ ਭਾਵਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","ਸ਼ਾਰੀਰਿਕਭਾਵਸ੍ਯ ਫਲੰ ਮ੍ਰੁʼਤ੍ਯੁਃ ਕਿਞ੍ਚਾਤ੍ਮਿਕਭਾਵਸ੍ਯ ਫਲੇ ਜੀਵਨੰ ਸ਼ਾਨ੍ਤਿਸ਼੍ਚ| ");
INSERT INTO sanpun_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","ਯਤਃ ਸ਼ਾਰੀਰਿਕਭਾਵ ਈਸ਼੍ਵਰਸ੍ਯ ਵਿਰੁੱਧਃ ਸ਼ਤ੍ਰੁਤਾਭਾਵ ਏਵ ਸ ਈਸ਼੍ਵਰਸ੍ਯ ਵ੍ਯਵਸ੍ਥਾਯਾ ਅਧੀਨੋ ਨ ਭਵਤਿ ਭਵਿਤੁਞ੍ਚ ਨ ਸ਼ਕ੍ਨੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","ਏਤਸ੍ਮਾਤ੍ ਸ਼ਾਰੀਰਿਕਾਚਾਰਿਸ਼਼ੁ ਤੋਸ਼਼੍ਟੁਮ੍ ਈਸ਼੍ਵਰੇਣ ਨ ਸ਼ਕ੍ਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","ਕਿਨ੍ਤ੍ਵੀਸ਼੍ਵਰਸ੍ਯਾਤ੍ਮਾ ਯਦਿ ਯੁਸ਼਼੍ਮਾਕੰ ਮਧ੍ਯੇ ਵਸਤਿ ਤਰ੍ਹਿ ਯੂਯੰ ਸ਼ਾਰੀਰਿਕਾਚਾਰਿਣੋ ਨ ਸਨ੍ਤ ਆਤ੍ਮਿਕਾਚਾਰਿਣੋ ਭਵਥਃ| ਯਸ੍ਮਿਨ੍ ਤੁ ਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯਾਤ੍ਮਾ ਨ ਵਿਦ੍ਯਤੇ ਸ ਤਤ੍ਸਮ੍ਭਵੋ ਨਹਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","ਯਦਿ ਖ੍ਰੀਸ਼਼੍ਟੋ ਯੁਸ਼਼੍ਮਾਨ੍ ਅਧਿਤਿਸ਼਼੍ਠਤਿ ਤਰ੍ਹਿ ਪਾਪਮ੍ ਉੱਦਿਸ਼੍ਯ ਸ਼ਰੀਰੰ ਮ੍ਰੁʼਤੰ ਕਿਨ੍ਤੁ ਪੁਣ੍ਯਮੁੱਦਿਸ਼੍ਯਾਤ੍ਮਾ ਜੀਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","ਮ੍ਰੁʼਤਗਣਾਦ੍ ਯੀਸ਼ੁ ਰ੍ਯੇਨੋੱਥਾਪਿਤਸ੍ਤਸ੍ਯਾਤ੍ਮਾ ਯਦਿ ਯੁਸ਼਼੍ਮਨ੍ਮਧ੍ਯੇ ਵਸਤਿ ਤਰ੍ਹਿ ਮ੍ਰੁʼਤਗਣਾਤ੍ ਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਸ ਉੱਥਾਪਯਿਤਾ ਯੁਸ਼਼੍ਮਨ੍ਮਧ੍ਯਵਾਸਿਨਾ ਸ੍ਵਕੀਯਾਤ੍ਮਨਾ ਯੁਸ਼਼੍ਮਾਕੰ ਮ੍ਰੁʼਤਦੇਹਾਨਪਿ ਪੁਨ ਰ੍ਜੀਵਯਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","ਹੇ ਭ੍ਰਾਤ੍ਰੁʼਗਣ ਸ਼ਰੀਰਸ੍ਯ ਵਯਮਧਮਰ੍ਣਾ ਨ ਭਵਾਮੋ(ਅ)ਤਃ ਸ਼ਾਰੀਰਿਕਾਚਾਰੋ(ਅ)ਸ੍ਮਾਭਿ ਰ੍ਨ ਕਰ੍ੱਤਵ੍ਯਃ| ");
INSERT INTO sanpun_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","ਯਦਿ ਯੂਯੰ ਸ਼ਰੀਰਿਕਾਚਾਰਿਣੋ ਭਵੇਤ ਤਰ੍ਹਿ ਯੁਸ਼਼੍ਮਾਭਿ ਰ੍ਮਰ੍ੱਤਵ੍ਯਮੇਵ ਕਿਨ੍ਤ੍ਵਾਤ੍ਮਨਾ ਯਦਿ ਸ਼ਰੀਰਕਰ੍ੰਮਾਣਿ ਘਾਤਯੇਤ ਤਰ੍ਹਿ ਜੀਵਿਸ਼਼੍ਯਥ| ");
INSERT INTO sanpun_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","ਯਤੋ ਯਾਵਨ੍ਤੋ ਲੋਕਾ ਈਸ਼੍ਵਰਸ੍ਯਾਤ੍ਮਨਾਕ੍ਰੁʼਸ਼਼੍ਯਨ੍ਤੇ ਤੇ ਸਰ੍ੱਵ ਈਸ਼੍ਵਰਸ੍ਯ ਸਨ੍ਤਾਨਾ ਭਵਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","ਯੂਯੰ ਪੁਨਰਪਿ ਭਯਜਨਕੰ ਦਾਸ੍ਯਭਾਵੰ ਨ ਪ੍ਰਾਪ੍ਤਾਃ ਕਿਨ੍ਤੁ ਯੇਨ ਭਾਵੇਨੇਸ਼੍ਵਰੰ ਪਿਤਃ ਪਿਤਰਿਤਿ ਪ੍ਰੋਚ੍ਯ ਸਮ੍ਬੋਧਯਥ ਤਾਦ੍ਰੁʼਸ਼ੰ ਦੱਤਕਪੁਤ੍ਰਤ੍ਵਭਾਵਮ੍ ਪ੍ਰਾਪ੍ਨੁਤ| ");
INSERT INTO sanpun_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","ਅਪਰਞ੍ਚ ਵਯਮ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਸਨ੍ਤਾਨਾ ਏਤਸ੍ਮਿਨ੍ ਪਵਿਤ੍ਰ ਆਤ੍ਮਾ ਸ੍ਵਯਮ੍ ਅਸ੍ਮਾਕਮ੍ ਆਤ੍ਮਾਭਿਃ ਸਾਰ੍ੱਧੰ ਪ੍ਰਮਾਣੰ ਦਦਾਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","ਅਤਏਵ ਵਯੰ ਯਦਿ ਸਨ੍ਤਾਨਾਸ੍ਤਰ੍ਹ੍ਯਧਿਕਾਰਿਣਃ, ਅਰ੍ਥਾਦ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਸ੍ਵੱਤ੍ਵਾਧਿਕਾਰਿਣਃ ਖ੍ਰੀਸ਼਼੍ਟੇਨ ਸਹਾਧਿਕਾਰਿਣਸ਼੍ਚ ਭਵਾਮਃ; ਅਪਰੰ ਤੇਨ ਸਾਰ੍ੱਧੰ ਯਦਿ ਦੁਃਖਭਾਗਿਨੋ ਭਵਾਮਸ੍ਤਰ੍ਹਿ ਤਸ੍ਯ ਵਿਭਵਸ੍ਯਾਪਿ ਭਾਗਿਨੋ ਭਵਿਸ਼਼੍ਯਾਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","ਕਿਨ੍ਤ੍ਵਸ੍ਮਾਸੁ ਯੋ ਭਾਵੀਵਿਭਵਃ ਪ੍ਰਕਾਸ਼ਿਸ਼਼੍ਯਤੇ ਤਸ੍ਯ ਸਮੀਪੇ ਵਰ੍ੱਤਮਾਨਕਾਲੀਨੰ ਦੁਃਖਮਹੰ ਤ੍ਰੁʼਣਾਯ ਮਨ੍ਯੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","ਯਤਃ ਪ੍ਰਾਣਿਗਣ ਈਸ਼੍ਵਰਸ੍ਯ ਸਨ੍ਤਾਨਾਨਾਂ ਵਿਭਵਪ੍ਰਾਪ੍ਤਿਮ੍ ਆਕਾਙ੍ਕ੍ਸ਼਼ਨ੍ ਨਿਤਾਨ੍ਤਮ੍ ਅਪੇਕ੍ਸ਼਼ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","ਅਪਰਞ੍ਚ ਪ੍ਰਾਣਿਗਣਃ ਸ੍ਵੈਰਮ੍ ਅਲੀਕਤਾਯਾ ਵਸ਼ੀਕ੍ਰੁʼਤੋ ਨਾਭਵਤ੍ ");
INSERT INTO sanpun_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","ਕਿਨ੍ਤੁ ਪ੍ਰਾਣਿਗਣੋ(ਅ)ਪਿ ਨਸ਼੍ਵਰਤਾਧੀਨਤ੍ਵਾਤ੍ ਮੁਕ੍ਤਃ ਸਨ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਸਨ੍ਤਾਨਾਨਾਂ ਪਰਮਮੁਕ੍ਤਿੰ ਪ੍ਰਾਪ੍ਸ੍ਯਤੀਤ੍ਯਭਿਪ੍ਰਾਯੇਣ ਵਸ਼ੀਕਰ੍ਤ੍ਰਾ ਵਸ਼ੀਚਕ੍ਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","ਅਪਰਞ੍ਚ ਪ੍ਰਸੂਯਮਾਨਾਵਦ੍ ਵ੍ਯਥਿਤਃ ਸਨ੍ ਇਦਾਨੀਂ ਯਾਵਤ੍ ਕ੍ਰੁʼਤ੍ਸ੍ਨਃ ਪ੍ਰਾਣਿਗਣ ਆਰ੍ੱਤਸ੍ਵਰੰ ਕਰੋਤੀਤਿ ਵਯੰ ਜਾਨੀਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","ਕੇਵਲਃ ਸ ਇਤਿ ਨਹਿ ਕਿਨ੍ਤੁ ਪ੍ਰਥਮਜਾਤਫਲਸ੍ਵਰੂਪਮ੍ ਆਤ੍ਮਾਨੰ ਪ੍ਰਾਪ੍ਤਾ ਵਯਮਪਿ ਦੱਤਕਪੁਤ੍ਰਤ੍ਵਪਦਪ੍ਰਾਪ੍ਤਿਮ੍ ਅਰ੍ਥਾਤ੍ ਸ਼ਰੀਰਸ੍ਯ ਮੁਕ੍ਤਿੰ ਪ੍ਰਤੀਕ੍ਸ਼਼ਮਾਣਾਸ੍ਤਦ੍ਵਦ੍ ਅਨ੍ਤਰਾਰ੍ੱਤਰਾਵੰ ਕੁਰ੍ੰਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","ਵਯੰ ਪ੍ਰਤ੍ਯਾਸ਼ਯਾ ਤ੍ਰਾਣਮ੍ ਅਲਭਾਮਹਿ ਕਿਨ੍ਤੁ ਪ੍ਰਤ੍ਯਕ੍ਸ਼਼ਵਸ੍ਤੁਨੋ ਯਾ ਪ੍ਰਤ੍ਯਾਸ਼ਾ ਸਾ ਪ੍ਰਤ੍ਯਾਸ਼ਾ ਨਹਿ, ਯਤੋ ਮਨੁਸ਼਼੍ਯੋ ਯਤ੍ ਸਮੀਕ੍ਸ਼਼ਤੇ ਤਸ੍ਯ ਪ੍ਰਤ੍ਯਾਸ਼ਾਂ ਕੁਤਃ ਕਰਿਸ਼਼੍ਯਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","ਯਦ੍ ਅਪ੍ਰਤ੍ਯਕ੍ਸ਼਼ੰ ਤਸ੍ਯ ਪ੍ਰਤ੍ਯਾਸ਼ਾਂ ਯਦਿ ਵਯੰ ਕੁਰ੍ੱਵੀਮਹਿ ਤਰ੍ਹਿ ਧੈਰ੍ੱਯਮ੍ ਅਵਲਮ੍ਬ੍ਯ ਪ੍ਰਤੀਕ੍ਸ਼਼ਾਮਹੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","ਤਤ ਆਤ੍ਮਾਪਿ ਸ੍ਵਯਮ੍ ਅਸ੍ਮਾਕੰ ਦੁਰ੍ੱਬਲਤਾਯਾਃ ਸਹਾਯਤ੍ਵੰ ਕਰੋਤਿ; ਯਤਃ ਕਿੰ ਪ੍ਰਾਰ੍ਥਿਤਵ੍ਯੰ ਤਦ੍ ਬੋੱਧੁੰ ਵਯੰ ਨ ਸ਼ਕ੍ਨੁਮਃ, ਕਿਨ੍ਤ੍ਵਸ੍ਪਸ਼਼੍ਟੈਰਾਰ੍ੱਤਰਾਵੈਰਾਤ੍ਮਾ ਸ੍ਵਯਮ੍ ਅਸ੍ਮੰਨਿਮਿੱਤੰ ਨਿਵੇਦਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","ਅਪਰਮ੍ ਈਸ਼੍ਵਰਾਭਿਮਤਰੂਪੇਣ ਪਵਿਤ੍ਰਲੋਕਾਨਾਂ ਕ੍ਰੁʼਤੇ ਨਿਵੇਦਯਤਿ ਯ ਆਤ੍ਮਾ ਤਸ੍ਯਾਭਿਪ੍ਰਾਯੋ(ਅ)ਨ੍ਤਰ੍ੱਯਾਮਿਨਾ ਜ੍ਞਾਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","ਅਪਰਮ੍ ਈਸ਼੍ਵਰੀਯਨਿਰੂਪਣਾਨੁਸਾਰੇਣਾਹੂਤਾਃ ਸਨ੍ਤੋ ਯੇ ਤਸ੍ਮਿਨ੍ ਪ੍ਰੀਯਨ੍ਤੇ ਸਰ੍ੱਵਾਣਿ ਮਿਲਿਤ੍ਵਾ ਤੇਸ਼਼ਾਂ ਮਙ੍ਗਲੰ ਸਾਧਯਨ੍ਤਿ, ਏਤਦ੍ ਵਯੰ ਜਾਨੀਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","ਯਤ ਈਸ਼੍ਵਰੋ ਬਹੁਭ੍ਰਾਤ੍ਰੁʼਣਾਂ ਮਧ੍ਯੇ ਸ੍ਵਪੁਤ੍ਰੰ ਜ੍ਯੇਸ਼਼੍ਠੰ ਕਰ੍ੱਤੁਮ੍ ਇੱਛਨ੍ ਯਾਨ੍ ਪੂਰ੍ੱਵੰ ਲਕ੍ਸ਼਼੍ਯੀਕ੍ਰੁʼਤਵਾਨ੍ ਤਾਨ੍ ਤਸ੍ਯ ਪ੍ਰਤਿਮੂਰ੍ਤ੍ਯਾਃ ਸਾਦ੍ਰੁʼਸ਼੍ਯਪ੍ਰਾਪ੍ਤ੍ਯਰ੍ਥੰ ਨ੍ਯਯੁੰਕ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","ਅਪਰਞ੍ਚ ਤੇਨ ਯੇ ਨਿਯੁਕ੍ਤਾਸ੍ਤ ਆਹੂਤਾ ਅਪਿ ਯੇ ਚ ਤੇਨਾਹੂਤਾਸ੍ਤੇ ਸਪੁਣ੍ਯੀਕ੍ਰੁʼਤਾਃ, ਯੇ ਚ ਤੇਨ ਸਪੁਣ੍ਯੀਕ੍ਰੁʼਤਾਸ੍ਤੇ ਵਿਭਵਯੁਕ੍ਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","ਇਤ੍ਯਤ੍ਰ ਵਯੰ ਕਿੰ ਬ੍ਰੂਮਃ? ਈਸ਼੍ਵਰੋ ਯਦ੍ਯਸ੍ਮਾਕੰ ਸਪਕ੍ਸ਼਼ੋ ਭਵਤਿ ਤਰ੍ਹਿ ਕੋ ਵਿਪਕ੍ਸ਼਼ੋ(ਅ)ਸ੍ਮਾਕੰ? ");
INSERT INTO sanpun_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","ਆਤ੍ਮਪੁਤ੍ਰੰ ਨ ਰਕ੍ਸ਼਼ਿਤ੍ਵਾ ਯੋ(ਅ)ਸ੍ਮਾਕੰ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਕ੍ਰੁʼਤੇ ਤੰ ਪ੍ਰਦੱਤਵਾਨ੍ ਸ ਕਿੰ ਤੇਨ ਸਹਾਸ੍ਮਭ੍ਯਮ੍ ਅਨ੍ਯਾਨਿ ਸਰ੍ੱਵਾਣਿ ਨ ਦਾਸ੍ਯਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","ਈਸ਼੍ਵਰਸ੍ਯਾਭਿਰੁਚਿਤੇਸ਼਼ੁ ਕੇਨ ਦੋਸ਼਼ ਆਰੋਪਯਿਸ਼਼੍ਯਤੇ? ਯ ਈਸ਼੍ਵਰਸ੍ਤਾਨ੍ ਪੁਣ੍ਯਵਤ ਇਵ ਗਣਯਤਿ ਕਿੰ ਤੇਨ? ");
INSERT INTO sanpun_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","ਅਪਰੰ ਤੇਭ੍ਯੋ ਦਣ੍ਡਦਾਨਾਜ੍ਞਾ ਵਾ ਕੇਨ ਕਰਿਸ਼਼੍ਯਤੇ? ਯੋ(ਅ)ਸ੍ਮੰਨਿਮਿੱਤੰ ਪ੍ਰਾਣਾਨ੍ ਤ੍ਯਕ੍ਤਵਾਨ੍ ਕੇਵਲੰ ਤੰਨ ਕਿਨ੍ਤੁ ਮ੍ਰੁʼਤਗਣਮਧ੍ਯਾਦ੍ ਉੱਥਿਤਵਾਨ੍, ਅਪਿ ਚੇਸ਼੍ਵਰਸ੍ਯ ਦਕ੍ਸ਼਼ਿਣੇ ਪਾਰ੍ਸ਼੍ਵੇ ਤਿਸ਼਼੍ਠਨ੍ ਅਦ੍ਯਾਪ੍ਯਸ੍ਮਾਕੰ ਨਿਮਿੱਤੰ ਪ੍ਰਾਰ੍ਥਤ ਏਵਮ੍ਭੂਤੋ ਯਃ ਖ੍ਰੀਸ਼਼੍ਟਃ ਕਿੰ ਤੇਨ? ");
INSERT INTO sanpun_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","ਅਸ੍ਮਾਭਿਃ ਸਹ ਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਪ੍ਰੇਮਵਿੱਛੇਦੰ ਜਨਯਿਤੁੰ ਕਃ ਸ਼ਕ੍ਨੋਤਿ? ਕ੍ਲੇਸ਼ੋ ਵ੍ਯਸਨੰ ਵਾ ਤਾਡਨਾ ਵਾ ਦੁਰ੍ਭਿਕ੍ਸ਼਼ੰ ਵਾ ਵਸ੍ਤ੍ਰਹੀਨਤ੍ਵੰ ਵਾ ਪ੍ਰਾਣਸੰਸ਼ਯੋ ਵਾ ਖਙ੍ਗੋ ਵਾ ਕਿਮੇਤਾਨਿ ਸ਼ਕ੍ਨੁਵਨ੍ਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","ਕਿਨ੍ਤੁ ਲਿਖਿਤਮ੍ ਆਸ੍ਤੇ, ਯਥਾ, ਵਯੰ ਤਵ ਨਿਮਿੱਤੰ ਸ੍ਮੋ ਮ੍ਰੁʼਤ੍ਯੁਵਕ੍ਤ੍ਰੇ(ਅ)ਖਿਲੰ ਦਿਨੰ| ਬਲਿਰ੍ਦੇਯੋ ਯਥਾ ਮੇਸ਼਼ੋ ਵਯੰ ਗਣ੍ਯਾਮਹੇ ਤਥਾ| ");
INSERT INTO sanpun_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","ਅਪਰੰ ਯੋ(ਅ)ਸ੍ਮਾਸੁ ਪ੍ਰੀਯਤੇ ਤੇਨੈਤਾਸੁ ਵਿਪਤ੍ਸੁ ਵਯੰ ਸਮ੍ਯਗ੍ ਵਿਜਯਾਮਹੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","ਯਤੋ(ਅ)ਸ੍ਮਾਕੰ ਪ੍ਰਭੁਨਾ ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟੇਨੇਸ਼੍ਵਰਸ੍ਯ ਯਤ੍ ਪ੍ਰੇਮ ਤਸ੍ਮਾਦ੍ ਅਸ੍ਮਾਕੰ ਵਿੱਛੇਦੰ ਜਨਯਿਤੁੰ ਮ੍ਰੁʼਤ੍ਯੁ ਰ੍ਜੀਵਨੰ ਵਾ ਦਿਵ੍ਯਦੂਤਾ ਵਾ ਬਲਵਨ੍ਤੋ ਮੁਖ੍ਯਦੂਤਾ ਵਾ ਵਰ੍ੱਤਮਾਨੋ ਵਾ ਭਵਿਸ਼਼੍ਯਨ੍ ਕਾਲੋ ਵਾ ਉੱਚਪਦੰ ਵਾ ਨੀਚਪਦੰ ਵਾਪਰੰ ਕਿਮਪਿ ਸ੍ਰੁʼਸ਼਼੍ਟਵਸ੍ਤੁ ");
INSERT INTO sanpun_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ਵੈਤੇਸ਼਼ਾਂ ਕੇਨਾਪਿ ਨ ਸ਼ਕ੍ਯਮਿਤ੍ਯਸ੍ਮਿਨ੍ ਦ੍ਰੁʼਢਵਿਸ਼੍ਵਾਸੋ ਮਮਾਸ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","ਅਹੰ ਕਾਞ੍ਚਿਦ੍ ਕਲ੍ਪਿਤਾਂ ਕਥਾਂ ਨ ਕਥਯਾਮਿ, ਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਸਤ੍ਯਮੇਵ ਬ੍ਰਵੀਮਿ ਪਵਿਤ੍ਰਸ੍ਯਾਤ੍ਮਨਃ ਸਾਕ੍ਸ਼਼ਾਨ੍ ਮਦੀਯੰ ਮਨ ਏਤਤ੍ ਸਾਕ੍ਸ਼਼੍ਯੰ ਦਦਾਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","ਮਮਾਨ੍ਤਰਤਿਸ਼ਯਦੁਃਖੰ ਨਿਰਨ੍ਤਰੰ ਖੇਦਸ਼੍ਚ ");
INSERT INTO sanpun_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","ਤਸ੍ਮਾਦ੍ ਅਹੰ ਸ੍ਵਜਾਤੀਯਭ੍ਰਾਤ੍ਰੁʼਣਾਂ ਨਿਮਿੱਤਾਤ੍ ਸ੍ਵਯੰ ਖ੍ਰੀਸ਼਼੍ਟਾੱਛਾਪਾਕ੍ਰਾਨ੍ਤੋ ਭਵਿਤੁਮ੍ ਐੱਛਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","ਯਤਸ੍ਤ ਇਸ੍ਰਾਯੇਲਸ੍ਯ ਵੰਸ਼ਾ ਅਪਿ ਚ ਦੱਤਕਪੁਤ੍ਰਤ੍ਵੰ ਤੇਜੋ ਨਿਯਮੋ ਵ੍ਯਵਸ੍ਥਾਦਾਨੰ ਮਨ੍ਦਿਰੇ ਭਜਨੰ ਪ੍ਰਤਿਜ੍ਞਾਃ ਪਿਤ੍ਰੁʼਪੁਰੁਸ਼਼ਗਣਸ਼੍ਚੈਤੇਸ਼਼ੁ ਸਰ੍ੱਵੇਸ਼਼ੁ ਤੇਸ਼਼ਾਮ੍ ਅਧਿਕਾਰੋ(ਅ)ਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","ਤਤ੍ ਕੇਵਲੰ ਨਹਿ ਕਿਨ੍ਤੁ ਸਰ੍ੱਵਾਧ੍ਯਕ੍ਸ਼਼ਃ ਸਰ੍ੱਵਦਾ ਸੱਚਿਦਾਨਨ੍ਦ ਈਸ਼੍ਵਰੋ ਯਃ ਖ੍ਰੀਸ਼਼੍ਟਃ ਸੋ(ਅ)ਪਿ ਸ਼ਾਰੀਰਿਕਸਮ੍ਬਨ੍ਧੇਨ ਤੇਸ਼਼ਾਂ ਵੰਸ਼ਸਮ੍ਭਵਃ| ");
INSERT INTO sanpun_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","ਈਸ਼੍ਵਰਸ੍ਯ ਵਾਕ੍ਯੰ ਵਿਫਲੰ ਜਾਤਮ੍ ਇਤਿ ਨਹਿ ਯਤ੍ਕਾਰਣਾਦ੍ ਇਸ੍ਰਾਯੇਲੋ ਵੰਸ਼ੇ ਯੇ ਜਾਤਾਸ੍ਤੇ ਸਰ੍ੱਵੇ ਵਸ੍ਤੁਤ ਇਸ੍ਰਾਯੇਲੀਯਾ ਨ ਭਵਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","ਅਪਰਮ੍ ਇਬ੍ਰਾਹੀਮੋ ਵੰਸ਼ੇ ਜਾਤਾ ਅਪਿ ਸਰ੍ੱਵੇ ਤਸ੍ਯੈਵ ਸਨ੍ਤਾਨਾ ਨ ਭਵਨ੍ਤਿ ਕਿਨ੍ਤੁ ਇਸ੍ਹਾਕੋ ਨਾਮ੍ਨਾ ਤਵ ਵੰਸ਼ੋ ਵਿਖ੍ਯਾਤੋ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","ਅਰ੍ਥਾਤ੍ ਸ਼ਾਰੀਰਿਕਸੰਸਰ੍ਗਾਤ੍ ਜਾਤਾਃ ਸਨ੍ਤਾਨਾ ਯਾਵਨ੍ਤਸ੍ਤਾਵਨ੍ਤ ਏਵੇਸ਼੍ਵਰਸ੍ਯ ਸਨ੍ਤਾਨਾ ਨ ਭਵਨ੍ਤਿ ਕਿਨ੍ਤੁ ਪ੍ਰਤਿਸ਼੍ਰਵਣਾਦ੍ ਯੇ ਜਾਯਨ੍ਤੇ ਤਏਵੇਸ਼੍ਵਰਵੰਸ਼ੋ ਗਣ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","ਯਤਸ੍ਤਤ੍ਪ੍ਰਤਿਸ਼੍ਰੁਤੇ ਰ੍ਵਾਕ੍ਯਮੇਤਤ੍, ਏਤਾਦ੍ਰੁʼਸ਼ੇ ਸਮਯੇ (ਅ)ਹੰ ਪੁਨਰਾਗਮਿਸ਼਼੍ਯਾਮਿ ਤਤ੍ਪੂਰ੍ੱਵੰ ਸਾਰਾਯਾਃ ਪੁਤ੍ਰ ਏਕੋ ਜਨਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","ਅਪਰਮਪਿ ਵਦਾਮਿ ਸ੍ਵਮਨੋ(ਅ)ਭਿਲਾਸ਼਼ਤ ਈਸ਼੍ਵਰੇਣ ਯੰਨਿਰੂਪਿਤੰ ਤਤ੍ ਕਰ੍ੰਮਤੋ ਨਹਿ ਕਿਨ੍ਤ੍ਵਾਹ੍ਵਯਿਤੁ ਰ੍ਜਾਤਮੇਤਦ੍ ਯਥਾ ਸਿੱਧ੍ਯਤਿ ");
INSERT INTO sanpun_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","ਤਦਰ੍ਥੰ ਰਿਬ੍ਕਾਨਾਮਿਕਯਾ ਯੋਸ਼਼ਿਤਾ ਜਨੈਕਸ੍ਮਾਦ੍ ਅਰ੍ਥਾਦ੍ ਅਸ੍ਮਾਕਮ੍ ਇਸ੍ਹਾਕਃ ਪੂਰ੍ੱਵਪੁਰੁਸ਼਼ਾਦ੍ ਗਰ੍ਭੇ ਧ੍ਰੁʼਤੇ ਤਸ੍ਯਾਃ ਸਨ੍ਤਾਨਯੋਃ ਪ੍ਰਸਵਾਤ੍ ਪੂਰ੍ੱਵੰ ਕਿਞ੍ਚ ਤਯੋਃ ਸ਼ੁਭਾਸ਼ੁਭਕਰ੍ੰਮਣਃ ਕਰਣਾਤ੍ ਪੂਰ੍ੱਵੰ ");
INSERT INTO sanpun_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","ਤਾਂ ਪ੍ਰਤੀਦੰ ਵਾਕ੍ਯਮ੍ ਉਕ੍ਤੰ, ਜ੍ਯੇਸ਼਼੍ਠਃ ਕਨਿਸ਼਼੍ਠੰ ਸੇਵਿਸ਼਼੍ਯਤੇ, ");
INSERT INTO sanpun_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","ਯਥਾ ਲਿਖਿਤਮ੍ ਆਸ੍ਤੇ, ਤਥਾਪ੍ਯੇਸ਼਼ਾਵਿ ਨ ਪ੍ਰੀਤ੍ਵਾ ਯਾਕੂਬਿ ਪ੍ਰੀਤਵਾਨ੍ ਅਹੰ| ");
INSERT INTO sanpun_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","ਤਰ੍ਹਿ ਵਯੰ ਕਿੰ ਬ੍ਰੂਮਃ? ਈਸ਼੍ਵਰਃ ਕਿਮ੍ ਅਨ੍ਯਾਯਕਾਰੀ? ਤਥਾ ਨ ਭਵਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","ਯਤਃ ਸ ਸ੍ਵਯੰ ਮੂਸਾਮ੍ ਅਵਦਤ੍; ਅਹੰ ਯਸ੍ਮਿਨ੍ ਅਨੁਗ੍ਰਹੰ ਚਿਕੀਰ੍ਸ਼਼ਾਮਿ ਤਮੇਵਾਨੁਗ੍ਰੁʼਹ੍ਲਾਮਿ, ਯਞ੍ਚ ਦਯਿਤੁਮ੍ ਇੱਛਾਮਿ ਤਮੇਵ ਦਯੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","ਅਤਏਵੇੱਛਤਾ ਯਤਮਾਨੇਨ ਵਾ ਮਾਨਵੇਨ ਤੰਨ ਸਾਧ੍ਯਤੇ ਦਯਾਕਾਰਿਣੇਸ਼੍ਵਰੇਣੈਵ ਸਾਧ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","ਫਿਰੌਣਿ ਸ਼ਾਸ੍ਤ੍ਰੇ ਲਿਖਤਿ, ਅਹੰ ਤ੍ਵੱਦ੍ਵਾਰਾ ਮਤ੍ਪਰਾਕ੍ਰਮੰ ਦਰ੍ਸ਼ਯਿਤੁੰ ਸਰ੍ੱਵਪ੍ਰੁʼਥਿਵ੍ਯਾਂ ਨਿਜਨਾਮ ਪ੍ਰਕਾਸ਼ਯਿਤੁਞ੍ਚ ਤ੍ਵਾਂ ਸ੍ਥਾਪਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","ਅਤਃ ਸ ਯਮ੍ ਅਨੁਗ੍ਰਹੀਤੁਮ੍ ਇੱਛਤਿ ਤਮੇਵਾਨੁਗ੍ਰੁʼਹ੍ਲਾਤਿ, ਯਞ੍ਚ ਨਿਗ੍ਰਹੀਤੁਮ੍ ਇੱਛਤਿ ਤੰ ਨਿਗ੍ਰੁʼਹ੍ਲਾਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","ਯਦਿ ਵਦਸਿ ਤਰ੍ਹਿ ਸ ਦੋਸ਼਼ੰ ਕੁਤੋ ਗ੍ਰੁʼਹ੍ਲਾਤਿ? ਤਦੀਯੇੱਛਾਯਾਃ ਪ੍ਰਤਿਬਨ੍ਧਕਤ੍ਵੰ ਕਰ੍ੱਤੰ ਕਸ੍ਯ ਸਾਮਰ੍ਥ੍ਯੰ ਵਿਦ੍ਯਤੇ? ");
INSERT INTO sanpun_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","ਹੇ ਈਸ਼੍ਵਰਸ੍ਯ ਪ੍ਰਤਿਪਕ੍ਸ਼਼ ਮਰ੍ਤ੍ਯ ਤ੍ਵੰ ਕਃ? ਏਤਾਦ੍ਰੁʼਸ਼ੰ ਮਾਂ ਕੁਤਃ ਸ੍ਰੁʼਸ਼਼੍ਟਵਾਨ੍? ਇਤਿ ਕਥਾਂ ਸ੍ਰੁʼਸ਼਼੍ਟਵਸ੍ਤੁ ਸ੍ਰਸ਼਼੍ਟ੍ਰੇ ਕਿੰ ਕਥਯਿਸ਼਼੍ਯਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","ਏਕਸ੍ਮਾਨ੍ ਮ੍ਰੁʼਤ੍ਪਿਣ੍ਡਾਦ੍ ਉਤ੍ਕ੍ਰੁʼਸ਼਼੍ਟਾਪਕ੍ਰੁʼਸ਼਼੍ਟੌ ਦ੍ਵਿਵਿਧੌ ਕਲਸ਼ੌ ਕਰ੍ੱਤੁੰ ਕਿੰ ਕੁਲਾਲਸ੍ਯ ਸਾਮਰ੍ਥ੍ਯੰ ਨਾਸ੍ਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","ਈਸ਼੍ਵਰਃ ਕੋਪੰ ਪ੍ਰਕਾਸ਼ਯਿਤੁੰ ਨਿਜਸ਼ਕ੍ਤਿੰ ਜ੍ਞਾਪਯਿਤੁਞ੍ਚੇੱਛਨ੍ ਯਦਿ ਵਿਨਾਸ਼ਸ੍ਯ ਯੋਗ੍ਯਾਨਿ ਕ੍ਰੋਧਭਾਜਨਾਨਿ ਪ੍ਰਤਿ ਬਹੁਕਾਲੰ ਦੀਰ੍ਘਸਹਿਸ਼਼੍ਣੁਤਾਮ੍ ਆਸ਼੍ਰਯਤਿ; ");
INSERT INTO sanpun_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","ਅਪਰਞ੍ਚ ਵਿਭਵਪ੍ਰਾਪ੍ਤ੍ਯਰ੍ਥੰ ਪੂਰ੍ੱਵੰ ਨਿਯੁਕ੍ਤਾਨ੍ਯਨੁਗ੍ਰਹਪਾਤ੍ਰਾਣਿ ਪ੍ਰਤਿ ਨਿਜਵਿਭਵਸ੍ਯ ਬਾਹੁਲ੍ਯੰ ਪ੍ਰਕਾਸ਼ਯਿਤੁੰ ਕੇਵਲਯਿਹੂਦਿਨਾਂ ਨਹਿ ਭਿੰਨਦੇਸ਼ਿਨਾਮਪਿ ਮਧ੍ਯਾਦ੍ ");
INSERT INTO sanpun_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","ਅਸ੍ਮਾਨਿਵ ਤਾਨ੍ਯਾਹ੍ਵਯਤਿ ਤਤ੍ਰ ਤਵ ਕਿੰ? ");
INSERT INTO sanpun_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","ਹੋਸ਼ੇਯਗ੍ਰਨ੍ਥੇ ਯਥਾ ਲਿਖਿਤਮ੍ ਆਸ੍ਤੇ, ਯੋ ਲੋਕੋ ਮਮ ਨਾਸੀਤ੍ ਤੰ ਵਦਿਸ਼਼੍ਯਾਮਿ ਮਦੀਯਕੰ| ਯਾ ਜਾਤਿ ਰ੍ਮੇ(ਅ)ਪ੍ਰਿਯਾ ਚਾਸੀਤ੍ ਤਾਂ ਵਦਿਸ਼਼੍ਯਾਮ੍ਯਹੰ ਪ੍ਰਿਯਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","ਯੂਯੰ ਮਦੀਯਲੋਕਾ ਨ ਯਤ੍ਰੇਤਿ ਵਾਕ੍ਯਮੌਚ੍ਯਤ| ਅਮਰੇਸ਼ਸ੍ਯ ਸਨ੍ਤਾਨਾ ਇਤਿ ਖ੍ਯਾਸ੍ਯਨ੍ਤਿ ਤਤ੍ਰ ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","ਇਸ੍ਰਾਯੇਲੀਯਲੋਕੇਸ਼਼ੁ ਯਿਸ਼ਾਯਿਯੋ(ਅ)ਪਿ ਵਾਚਮੇਤਾਂ ਪ੍ਰਾਚਾਰਯਤ੍, ਇਸ੍ਰਾਯੇਲੀਯਵੰਸ਼ਾਨਾਂ ਯਾ ਸੰਖ੍ਯਾ ਸਾ ਤੁ ਨਿਸ਼੍ਚਿਤੰ| ਸਮੁਦ੍ਰਸਿਕਤਾਸੰਖ੍ਯਾਸਮਾਨਾ ਯਦਿ ਜਾਯਤੇ| ਤਥਾਪਿ ਕੇਵਲੰ ਲੋਕੈਰਲ੍ਪੈਸ੍ਤ੍ਰਾਣੰ ਵ੍ਰਜਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","ਯਤੋ ਨ੍ਯਾਯੇਨ ਸ੍ਵੰ ਕਰ੍ੰਮ ਪਰੇਸ਼ਃ ਸਾਧਯਿਸ਼਼੍ਯਤਿ| ਦੇਸ਼ੇ ਸਏਵ ਸੰਕ੍ਸ਼਼ੇਪਾੰਨਿਜੰ ਕਰ੍ੰਮ ਕਰਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","ਯਿਸ਼ਾਯਿਯੋ(ਅ)ਪਰਮਪਿ ਕਥਯਾਮਾਸ, ਸੈਨ੍ਯਾਧ੍ਯਕ੍ਸ਼਼ਪਰੇਸ਼ੇਨ ਚੇਤ੍ ਕਿਞ੍ਚਿੰਨੋਦਸ਼ਿਸ਼਼੍ਯਤ| ਤਦਾ ਵਯੰ ਸਿਦੋਮੇਵਾਭਵਿਸ਼਼੍ਯਾਮ ਵਿਨਿਸ਼੍ਚਿਤੰ| ਯਦ੍ਵਾ ਵਯਮ੍ ਅਮੋਰਾਯਾ ਅਗਮਿਸ਼਼੍ਯਾਮ ਤੁਲ੍ਯਤਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","ਤਰ੍ਹਿ ਵਯੰ ਕਿੰ ਵਕ੍ਸ਼਼੍ਯਾਮਃ? ਇਤਰਦੇਸ਼ੀਯਾ ਲੋਕਾ ਅਪਿ ਪੁਣ੍ਯਾਰ੍ਥਮ੍ ਅਯਤਮਾਨਾ ਵਿਸ਼੍ਵਾਸੇਨ ਪੁਣ੍ਯਮ੍ ਅਲਭਨ੍ਤ; ");
INSERT INTO sanpun_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","ਕਿਨ੍ਤ੍ਵਿਸ੍ਰਾਯੇੱਲੋਕਾ ਵ੍ਯਵਸ੍ਥਾਪਾਲਨੇਨ ਪੁਣ੍ਯਾਰ੍ਥੰ ਯਤਮਾਨਾਸ੍ਤਨ੍ ਨਾਲਭਨ੍ਤ| ");
INSERT INTO sanpun_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","ਤਸ੍ਯ ਕਿੰ ਕਾਰਣੰ? ਤੇ ਵਿਸ਼੍ਵਾਸੇਨ ਨਹਿ ਕਿਨ੍ਤੁ ਵ੍ਯਵਸ੍ਥਾਯਾਃ ਕ੍ਰਿਯਯਾ ਚੇਸ਼਼੍ਟਿਤ੍ਵਾ ਤਸ੍ਮਿਨ੍ ਸ੍ਖਲਨਜਨਕੇ ਪਾਸ਼਼ਾਣੇ ਪਾਦਸ੍ਖਲਨੰ ਪ੍ਰਾਪ੍ਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","ਲਿਖਿਤੰ ਯਾਦ੍ਰੁʼਸ਼ਮ੍ ਆਸ੍ਤੇ, ਪਸ਼੍ਯ ਪਾਦਸ੍ਖਲਾਰ੍ਥੰ ਹਿ ਸੀਯੋਨਿ ਪ੍ਰਸ੍ਤਰਨ੍ਤਥਾ| ਬਾਧਾਕਾਰਞ੍ਚ ਪਾਸ਼਼ਾਣੰ ਪਰਿਸ੍ਥਾਪਿਤਵਾਨਹਮ੍| ਵਿਸ਼੍ਵਸਿਸ਼਼੍ਯਤਿ ਯਸ੍ਤਤ੍ਰ ਸ ਜਨੋ ਨ ਤ੍ਰਪਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","ਹੇ ਭ੍ਰਾਤਰ ਇਸ੍ਰਾਯੇਲੀਯਲੋਕਾ ਯਤ੍ ਪਰਿਤ੍ਰਾਣੰ ਪ੍ਰਾਪ੍ਨੁਵਨ੍ਤਿ ਤਦਹੰ ਮਨਸਾਭਿਲਸ਼਼ਨ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਸਮੀਪੇ ਪ੍ਰਾਰ੍ਥਯੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","ਯਤ ਈਸ਼੍ਵਰੇ ਤੇਸ਼਼ਾਂ ਚੇਸ਼਼੍ਟਾ ਵਿਦ੍ਯਤ ਇਤ੍ਯਤ੍ਰਾਹੰ ਸਾਕ੍ਸ਼਼੍ਯਸ੍ਮਿ; ਕਿਨ੍ਤੁ ਤੇਸ਼਼ਾਂ ਸਾ ਚੇਸ਼਼੍ਟਾ ਸਜ੍ਞਾਨਾ ਨਹਿ, ");
INSERT INTO sanpun_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","ਯਤਸ੍ਤ ਈਸ਼੍ਵਰਦੱਤੰ ਪੁਣ੍ਯਮ੍ ਅਵਿਜ੍ਞਾਯ ਸ੍ਵਕ੍ਰੁʼਤਪੁਣ੍ਯੰ ਸ੍ਥਾਪਯਿਤੁਮ੍ ਚੇਸ਼਼੍ਟਮਾਨਾ ਈਸ਼੍ਵਰਦੱਤਸ੍ਯ ਪੁਣ੍ਯਸ੍ਯ ਨਿਘ੍ਨਤ੍ਵੰ ਨ ਸ੍ਵੀਕੁਰ੍ੱਵਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","ਖ੍ਰੀਸ਼਼੍ਟ ਏਕੈਕਵਿਸ਼੍ਵਾਸਿਜਨਾਯ ਪੁਣ੍ਯੰ ਦਾਤੁੰ ਵ੍ਯਵਸ੍ਥਾਯਾਃ ਫਲਸ੍ਵਰੂਪੋ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","ਵ੍ਯਵਸ੍ਥਾਪਾਲਨੇਨ ਯਤ੍ ਪੁਣ੍ਯੰ ਤਤ੍ ਮੂਸਾ ਵਰ੍ਣਯਾਮਾਸ, ਯਥਾ, ਯੋ ਜਨਸ੍ਤਾਂ ਪਾਲਯਿਸ਼਼੍ਯਤਿ ਸ ਤੱਦ੍ਵਾਰਾ ਜੀਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","ਕਿਨ੍ਤੁ ਪ੍ਰਤ੍ਯਯੇਨ ਯਤ੍ ਪੁਣ੍ਯੰ ਤਦ੍ ਏਤਾਦ੍ਰੁʼਸ਼ੰ ਵਾਕ੍ਯੰ ਵਦਤਿ, ਕਃ ਸ੍ਵਰ੍ਗਮ੍ ਆਰੁਹ੍ਯ ਖ੍ਰੀਸ਼਼੍ਟਮ੍ ਅਵਰੋਹਯਿਸ਼਼੍ਯਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","ਕੋ ਵਾ ਪ੍ਰੇਤਲੋਕਮ੍ ਅਵਰੁਹ੍ਯ ਖ੍ਰੀਸ਼਼੍ਟੰ ਮ੍ਰੁʼਤਗਣਮਧ੍ਯਾਦ੍ ਆਨੇਸ਼਼੍ਯਤੀਤਿ ਵਾਕ੍ ਮਨਸਿ ਤ੍ਵਯਾ ਨ ਗਦਿਤਵ੍ਯਾ| ");
INSERT INTO sanpun_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","ਤਰ੍ਹਿ ਕਿੰ ਬ੍ਰਵੀਤਿ? ਤਦ੍ ਵਾਕ੍ਯੰ ਤਵ ਸਮੀਪਸ੍ਥਮ੍ ਅਰ੍ਥਾਤ੍ ਤਵ ਵਦਨੇ ਮਨਸਿ ਚਾਸ੍ਤੇ, ਤੱਚ ਵਾਕ੍ਯਮ੍ ਅਸ੍ਮਾਭਿਃ ਪ੍ਰਚਾਰ੍ੱਯਮਾਣੰ ਵਿਸ਼੍ਵਾਸਸ੍ਯ ਵਾਕ੍ਯਮੇਵ| ");
INSERT INTO sanpun_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","ਵਸ੍ਤੁਤਃ ਪ੍ਰਭੁੰ ਯੀਸ਼ੁੰ ਯਦਿ ਵਦਨੇਨ ਸ੍ਵੀਕਰੋਸ਼਼ਿ, ਤਥੇਸ਼੍ਵਰਸ੍ਤੰ ਸ਼੍ਮਸ਼ਾਨਾਦ੍ ਉਦਸ੍ਥਾਪਯਦ੍ ਇਤਿ ਯਦ੍ਯਨ੍ਤਃਕਰਣੇਨ ਵਿਸ਼੍ਵਸਿਸ਼਼ਿ ਤਰ੍ਹਿ ਪਰਿਤ੍ਰਾਣੰ ਲਪ੍ਸ੍ਯਸੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","ਯਸ੍ਮਾਤ੍ ਪੁਣ੍ਯਪ੍ਰਾਪ੍ਤ੍ਯਰ੍ਥਮ੍ ਅਨ੍ਤਃਕਰਣੇਨ ਵਿਸ਼੍ਵਸਿਤਵ੍ਯੰ ਪਰਿਤ੍ਰਾਣਾਰ੍ਥਞ੍ਚ ਵਦਨੇਨ ਸ੍ਵੀਕਰ੍ੱਤਵ੍ਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","ਸ਼ਾਸ੍ਤ੍ਰੇ ਯਾਦ੍ਰੁʼਸ਼ੰ ਲਿਖਤਿ ਵਿਸ਼੍ਵਸਿਸ਼਼੍ਯਤਿ ਯਸ੍ਤਤ੍ਰ ਸ ਜਨੋ ਨ ਤ੍ਰਪਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","ਇਤ੍ਯਤ੍ਰ ਯਿਹੂਦਿਨਿ ਤਦਨ੍ਯਲੋਕੇ ਚ ਕੋਪਿ ਵਿਸ਼ੇਸ਼਼ੋ ਨਾਸ੍ਤਿ ਯਸ੍ਮਾਦ੍ ਯਃ ਸਰ੍ੱਵੇਸ਼਼ਾਮ੍ ਅਦ੍ਵਿਤੀਯਃ ਪ੍ਰਭੁਃ ਸ ਨਿਜਯਾਚਕਾਨ ਸਰ੍ੱਵਾਨ੍ ਪ੍ਰਤਿ ਵਦਾਨ੍ਯੋ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","ਯਤਃ, ਯਃ ਕਸ਼੍ਚਿਤ੍ ਪਰਮੇਸ਼ਸ੍ਯ ਨਾਮ੍ਨਾ ਹਿ ਪ੍ਰਾਰ੍ਥਯਿਸ਼਼੍ਯਤੇ| ਸ ਏਵ ਮਨੁਜੋ ਨੂਨੰ ਪਰਿਤ੍ਰਾਤੋ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","ਯੰ ਯੇ ਜਨਾ ਨ ਪ੍ਰਤ੍ਯਾਯਨ੍ ਤੇ ਤਮੁੱਦਿਸ਼੍ਯ ਕਥੰ ਪ੍ਰਾਰ੍ਥਯਿਸ਼਼੍ਯਨ੍ਤੇ? ਯੇ ਵਾ ਯਸ੍ਯਾਖ੍ਯਾਨੰ ਕਦਾਪਿ ਨ ਸ਼੍ਰੁਤਵਨ੍ਤਸ੍ਤੇ ਤੰ ਕਥੰ ਪ੍ਰਤ੍ਯੇਸ਼਼੍ਯਨ੍ਤਿ? ਅਪਰੰ ਯਦਿ ਪ੍ਰਚਾਰਯਿਤਾਰੋ ਨ ਤਿਸ਼਼੍ਠਨ੍ਤਿ ਤਦਾ ਕਥੰ ਤੇ ਸ਼੍ਰੋਸ਼਼੍ਯਨ੍ਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","ਯਦਿ ਵਾ ਪ੍ਰੇਰਿਤਾ ਨ ਭਵਨ੍ਤਿ ਤਦਾ ਕਥੰ ਪ੍ਰਚਾਰਯਿਸ਼਼੍ਯਨ੍ਤਿ? ਯਾਦ੍ਰੁʼਸ਼ੰ ਲਿਖਿਤਮ੍ ਆਸ੍ਤੇ, ਯਥਾ, ਮਾਙ੍ਗਲਿਕੰ ਸੁਸੰਵਾਦੰ ਦਦਤ੍ਯਾਨੀਯ ਯੇ ਨਰਾਃ| ਪ੍ਰਚਾਰਯਨ੍ਤਿ ਸ਼ਾਨ੍ਤੇਸ਼੍ਚ ਸੁਸੰਵਾਦੰ ਜਨਾਸ੍ਤੁ ਯੇ| ਤੇਸ਼਼ਾਂ ਚਰਣਪਦ੍ਮਾਨਿ ਕੀਦ੍ਰੁʼਕ੍ ਸ਼ੋਭਾਨ੍ਵਿਤਾਨਿ ਹਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","ਕਿਨ੍ਤੁ ਤੇ ਸਰ੍ੱਵੇ ਤੰ ਸੁਸੰਵਾਦੰ ਨ ਗ੍ਰੁʼਹੀਤਵਨ੍ਤਃ| ਯਿਸ਼ਾਯਿਯੋ ਯਥਾ ਲਿਖਿਤਵਾਨ੍| ਅਸ੍ਮਤ੍ਪ੍ਰਚਾਰਿਤੇ ਵਾਕ੍ਯੇ ਵਿਸ਼੍ਵਾਸਮਕਰੋੱਧਿ ਕਃ| ");
INSERT INTO sanpun_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","ਅਤਏਵ ਸ਼੍ਰਵਣਾਦ੍ ਵਿਸ਼੍ਵਾਸ ਐਸ਼੍ਵਰਵਾਕ੍ਯਪ੍ਰਚਾਰਾਤ੍ ਸ਼੍ਰਵਣਞ੍ਚ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","ਤਰ੍ਹ੍ਯਹੰ ਬ੍ਰਵੀਮਿ ਤੈਃ ਕਿੰ ਨਾਸ਼੍ਰਾਵਿ? ਅਵਸ਼੍ਯਮ੍ ਅਸ਼੍ਰਾਵਿ, ਯਸ੍ਮਾਤ੍ ਤੇਸ਼਼ਾਂ ਸ਼ਬ੍ਦੋ ਮਹੀਂ ਵ੍ਯਾਪ੍ਨੋਦ੍ ਵਾਕ੍ਯਞ੍ਚ ਨਿਖਿਲੰ ਜਗਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","ਅਪਰਮਪਿ ਵਦਾਮਿ, ਇਸ੍ਰਾਯੇਲੀਯਲੋਕਾਃ ਕਿਮ੍ ਏਤਾਂ ਕਥਾਂ ਨ ਬੁਧ੍ਯਨ੍ਤੇ? ਪ੍ਰਥਮਤੋ ਮੂਸਾ ਇਦੰ ਵਾਕ੍ਯੰ ਪ੍ਰੋਵਾਚ, ਅਹਮੁੱਤਾਪਯਿਸ਼਼੍ਯੇ ਤਾਨ੍ ਅਗਣ੍ਯਮਾਨਵੈਰਪਿ| ਕ੍ਲੇਕ੍ਸ਼਼੍ਯਾਮਿ ਜਾਤਿਮ੍ ਏਤਾਞ੍ਚ ਪ੍ਰੋਨ੍ਮੱਤਭਿੰਨਜਾਤਿਭਿਃ| ");
INSERT INTO sanpun_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","ਅਪਰਞ੍ਚ ਯਿਸ਼ਾਯਿਯੋ(ਅ)ਤਿਸ਼ਯਾਕ੍ਸ਼਼ੋਭੇਣ ਕਥਯਾਮਾਸ, ਯਥਾ, ਅਧਿ ਮਾਂ ਯੈਸ੍ਤੁ ਨਾਚੇਸ਼਼੍ਟਿ ਸਮ੍ਪ੍ਰਾਪ੍ਤਸ੍ਤੈ ਰ੍ਜਨੈਰਹੰ| ਅਧਿ ਮਾਂ ਯੈ ਰ੍ਨ ਸਮ੍ਪ੍ਰੁʼਸ਼਼੍ਟੰ ਵਿਜ੍ਞਾਤਸ੍ਤੈ ਰ੍ਜਨੈਰਹੰ|| ");
INSERT INTO sanpun_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","ਕਿਨ੍ਤ੍ਵਿਸ੍ਰਾਯੇਲੀਯਲੋਕਾਨ੍ ਅਧਿ ਕਥਯਾਞ੍ਚਕਾਰ, ਯੈਰਾਜ੍ਞਾਲਙ੍ਘਿਭਿ ਰ੍ਲੋਕੈ ਰ੍ਵਿਰੁੱਧੰ ਵਾਕ੍ਯਮੁਚ੍ਯਤੇ| ਤਾਨ੍ ਪ੍ਰਤ੍ਯੇਵ ਦਿਨੰ ਕ੍ਰੁʼਤ੍ਸ੍ਨੰ ਹਸ੍ਤੌ ਵਿਸ੍ਤਾਰਯਾਮ੍ਯਹੰ|| ");
INSERT INTO sanpun_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","ਈਸ਼੍ਵਰੇਣ ਸ੍ਵੀਕੀਯਲੋਕਾ ਅਪਸਾਰਿਤਾ ਅਹੰ ਕਿਮ੍ ਈਦ੍ਰੁʼਸ਼ੰ ਵਾਕ੍ਯੰ ਬ੍ਰਵੀਮਿ? ਤੰਨ ਭਵਤੁ ਯਤੋ(ਅ)ਹਮਪਿ ਬਿਨ੍ਯਾਮੀਨਗੋਤ੍ਰੀਯ ਇਬ੍ਰਾਹੀਮਵੰਸ਼ੀਯ ਇਸ੍ਰਾਯੇਲੀਯਲੋਕੋ(ਅ)ਸ੍ਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","ਈਸ਼੍ਵਰੇਣ ਪੂਰ੍ੱਵੰ ਯੇ ਪ੍ਰਦ੍ਰੁʼਸ਼਼੍ਟਾਸ੍ਤੇ ਸ੍ਵਕੀਯਲੋਕਾ ਅਪਸਾਰਿਤਾ ਇਤਿ ਨਹਿ| ਅਪਰਮ੍ ਏਲਿਯੋਪਾਖ੍ਯਾਨੇ ਸ਼ਾਸ੍ਤ੍ਰੇ ਯੱਲਿਖਿਤਮ੍ ਆਸ੍ਤੇ ਤਦ੍ ਯੂਯੰ ਕਿੰ ਨ ਜਾਨੀਥ? ");
INSERT INTO sanpun_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","ਹੇ ਪਰਮੇਸ਼੍ਵਰ ਲੋਕਾਸ੍ਤ੍ਵਦੀਯਾਃ ਸਰ੍ੱਵਾ ਯਜ੍ਞਵੇਦੀਰਭਞ੍ਜਨ੍ ਤਥਾ ਤਵ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਨਃ ਸਰ੍ੱਵਾਨ੍ ਅਘ੍ਨਨ੍ ਕੇਵਲ ਏਕੋ(ਅ)ਹਮ੍ ਅਵਸ਼ਿਸ਼਼੍ਟ ਆਸੇ ਤੇ ਮਮਾਪਿ ਪ੍ਰਾਣਾਨ੍ ਨਾਸ਼ਯਿਤੁੰ ਚੇਸ਼਼੍ਟਨਤੇ, ਏਤਾਂ ਕਥਾਮ੍ ਇਸ੍ਰਾਯੇਲੀਯਲੋਕਾਨਾਂ ਵਿਰੁੱਧਮ੍ ਏਲਿਯ ਈਸ਼੍ਵਰਾਯ ਨਿਵੇਦਯਾਮਾਸ| ");
INSERT INTO sanpun_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","ਤਤਸ੍ਤੰ ਪ੍ਰਤੀਸ਼੍ਵਰਸ੍ਯੋੱਤਰੰ ਕਿੰ ਜਾਤੰ? ਬਾਲ੍ਨਾਮ੍ਨੋ ਦੇਵਸ੍ਯ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਯੈ ਰ੍ਜਾਨੂਨਿ ਨ ਪਾਤਿਤਾਨਿ ਤਾਦ੍ਰੁʼਸ਼ਾਃ ਸਪ੍ਤ ਸਹਸ੍ਰਾਣਿ ਲੋਕਾ ਅਵਸ਼ੇਸ਼਼ਿਤਾ ਮਯਾ| ");
INSERT INTO sanpun_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","ਤਦ੍ਵਦ੍ ਏਤਸ੍ਮਿਨ੍ ਵਰ੍ੱਤਮਾਨਕਾਲੇ(ਅ)ਪਿ ਅਨੁਗ੍ਰਹੇਣਾਭਿਰੁਚਿਤਾਸ੍ਤੇਸ਼਼ਾਮ੍ ਅਵਸ਼ਿਸ਼਼੍ਟਾਃ ਕਤਿਪਯਾ ਲੋਕਾਃ ਸਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","ਅਤਏਵ ਤਦ੍ ਯਦ੍ਯਨੁਗ੍ਰਹੇਣ ਭਵਤਿ ਤਰ੍ਹਿ ਕ੍ਰਿਯਯਾ ਨ ਭਵਤਿ ਨੋ ਚੇਦ੍ ਅਨੁਗ੍ਰਹੋ(ਅ)ਨਨੁਗ੍ਰਹ ਏਵ, ਯਦਿ ਵਾ ਕ੍ਰਿਯਯਾ ਭਵਤਿ ਤਰ੍ਹ੍ਯਨੁਗ੍ਰਹੇਣ ਨ ਭਵਤਿ ਨੋ ਚੇਤ੍ ਕ੍ਰਿਯਾ ਕ੍ਰਿਯੈਵ ਨ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","ਤਰ੍ਹਿ ਕਿੰ? ਇਸ੍ਰਾਯੇਲੀਯਲੋਕਾ ਯਦ੍ ਅਮ੍ਰੁʼਗਯਨ੍ਤ ਤੰਨ ਪ੍ਰਾਪੁਃ| ਕਿਨ੍ਤ੍ਵਭਿਰੁਚਿਤਲੋਕਾਸ੍ਤਤ੍ ਪ੍ਰਾਪੁਸ੍ਤਦਨ੍ਯੇ ਸਰ੍ੱਵ ਅਨ੍ਧੀਭੂਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","ਯਥਾ ਲਿਖਿਤਮ੍ ਆਸ੍ਤੇ, ਘੋਰਨਿਦ੍ਰਾਲੁਤਾਭਾਵੰ ਦ੍ਰੁʼਸ਼਼੍ਟਿਹੀਨੇ ਚ ਲੋਚਨੇ| ਕਰ੍ਣੌ ਸ਼੍ਰੁਤਿਵਿਹੀਨੌ ਚ ਪ੍ਰਦਦੌ ਤੇਭ੍ਯ ਈਸ਼੍ਵਰਃ|| ");
INSERT INTO sanpun_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","ਏਤੇਸ੍ਮਿਨ੍ ਦਾਯੂਦਪਿ ਲਿਖਿਤਵਾਨ੍ ਯਥਾ, ਅਤੋ ਭੁਕ੍ਤ੍ਯਾਸਨੰ ਤੇਸ਼਼ਾਮ੍ ਉਨ੍ਮਾਥਵਦ੍ ਭਵਿਸ਼਼੍ਯਤਿ| ਵਾ ਵੰਸ਼ਯਨ੍ਤ੍ਰਵਦ੍ ਬਾਧਾ ਦਣ੍ਡਵਦ੍ ਵਾ ਭਵਿਸ਼਼੍ਯਤਿ|| ");
INSERT INTO sanpun_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","ਭਵਿਸ਼਼੍ਯਨ੍ਤਿ ਤਥਾਨ੍ਧਾਸ੍ਤੇ ਨੇਤ੍ਰੈਃ ਪਸ਼੍ਯਨ੍ਤਿ ਨੋ ਯਥਾ| ਵੇਪਥੁਃ ਕਟਿਦੇਸ਼ਸ੍ਯ ਤੇਸ਼਼ਾਂ ਨਿਤ੍ਯੰ ਭਵਿਸ਼਼੍ਯਤਿ|| ");
INSERT INTO sanpun_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","ਪਤਨਾਰ੍ਥੰ ਤੇ ਸ੍ਖਲਿਤਵਨ੍ਤ ਇਤਿ ਵਾਚੰ ਕਿਮਹੰ ਵਦਾਮਿ? ਤੰਨ ਭਵਤੁ ਕਿਨ੍ਤੁ ਤਾਨ੍ ਉਦ੍ਯੋਗਿਨਃ ਕਰ੍ੱਤੁੰ ਤੇਸ਼਼ਾਂ ਪਤਨਾਦ੍ ਇਤਰਦੇਸ਼ੀਯਲੋਕੈਃ ਪਰਿਤ੍ਰਾਣੰ ਪ੍ਰਾਪ੍ਤੰ| ");
INSERT INTO sanpun_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","ਤੇਸ਼਼ਾਂ ਪਤਨੰ ਯਦਿ ਜਗਤੋ ਲੋਕਾਨਾਂ ਲਾਭਜਨਕਮ੍ ਅਭਵਤ੍ ਤੇਸ਼਼ਾਂ ਹ੍ਰਾਸੋ(ਅ)ਪਿ ਯਦਿ ਭਿੰਨਦੇਸ਼ਿਨਾਂ ਲਾਭਜਨਕੋ(ਅ)ਭਵਤ੍ ਤਰ੍ਹਿ ਤੇਸ਼਼ਾਂ ਵ੍ਰੁʼੱਧਿਃ ਕਤਿ ਲਾਭਜਨਿਕਾ ਭਵਿਸ਼਼੍ਯਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","ਅਤੋ ਹੇ ਅਨ੍ਯਦੇਸ਼ਿਨੋ ਯੁਸ਼਼੍ਮਾਨ੍ ਸਮ੍ਬੋਧ੍ਯ ਕਥਯਾਮਿ ਨਿਜਾਨਾਂ ਜ੍ਞਾਤਿਬਨ੍ਧੂਨਾਂ ਮਨਃਸੂਦ੍ਯੋਗੰ ਜਨਯਨ੍ ਤੇਸ਼਼ਾਂ ਮਧ੍ਯੇ ਕਿਯਤਾਂ ਲੋਕਾਨਾਂ ਯਥਾ ਪਰਿਤ੍ਰਾਣੰ ਸਾਧਯਾਮਿ ");
INSERT INTO sanpun_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","ਤੰਨਿਮਿੱਤਮ੍ ਅਨ੍ਯਦੇਸ਼ਿਨਾਂ ਨਿਕਟੇ ਪ੍ਰੇਰਿਤਃ ਸਨ੍ ਅਹੰ ਸ੍ਵਪਦਸ੍ਯ ਮਹਿਮਾਨੰ ਪ੍ਰਕਾਸ਼ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","ਤੇਸ਼਼ਾਂ ਨਿਗ੍ਰਹੇਣ ਯਦੀਸ਼੍ਵਰੇਣ ਸਹ ਜਗਤੋ ਜਨਾਨਾਂ ਮੇਲਨੰ ਜਾਤੰ ਤਰ੍ਹਿ ਤੇਸ਼਼ਾਮ੍ ਅਨੁਗ੍ਰੁʼਹੀਤਤ੍ਵੰ ਮ੍ਰੁʼਤਦੇਹੇ ਯਥਾ ਜੀਵਨਲਾਭਸ੍ਤਦ੍ਵਤ੍ ਕਿੰ ਨ ਭਵਿਸ਼਼੍ਯਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","ਅਪਰੰ ਪ੍ਰਥਮਜਾਤੰ ਫਲੰ ਯਦਿ ਪਵਿਤ੍ਰੰ ਭਵਤਿ ਤਰ੍ਹਿ ਸਰ੍ੱਵਮੇਵ ਫਲੰ ਪਵਿਤ੍ਰੰ ਭਵਿਸ਼਼੍ਯਤਿ; ਤਥਾ ਮੂਲੰ ਯਦਿ ਪਵਿਤ੍ਰੰ ਭਵਤਿ ਤਰ੍ਹਿ ਸ਼ਾਖਾ ਅਪਿ ਤਥੈਵ ਭਵਿਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","ਕਿਯਤੀਨਾਂ ਸ਼ਾਖਾਨਾਂ ਛੇਦਨੇ ਕ੍ਰੁʼਤੇ ਤ੍ਵੰ ਵਨ੍ਯਜਿਤਵ੍ਰੁʼਕ੍ਸ਼਼ਸ੍ਯ ਸ਼ਾਖਾ ਭੂਤ੍ਵਾ ਯਦਿ ਤੱਛਾਖਾਨਾਂ ਸ੍ਥਾਨੇ ਰੋਪਿਤਾ ਸਤਿ ਜਿਤਵ੍ਰੁʼਕ੍ਸ਼਼ੀਯਮੂਲਸ੍ਯ ਰਸੰ ਭੁੰਕ੍ਸ਼਼ੇ, ");
INSERT INTO sanpun_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","ਤਰ੍ਹਿ ਤਾਸਾਂ ਭਿੰਨਸ਼ਾਖਾਨਾਂ ਵਿਰੁੱਧੰ ਮਾਂ ਗਰ੍ੱਵੀਃ; ਯਦਿ ਗਰ੍ੱਵਸਿ ਤਰ੍ਹਿ ਤ੍ਵੰ ਮੂਲੰ ਯੰਨ ਧਾਰਯਸਿ ਕਿਨ੍ਤੁ ਮੂਲੰ ਤ੍ਵਾਂ ਧਾਰਯਤੀਤਿ ਸੰਸ੍ਮਰ| ");
INSERT INTO sanpun_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","ਅਪਰਞ੍ਚ ਯਦਿ ਵਦਸਿ ਮਾਂ ਰੋਪਯਿਤੁੰ ਤਾਃ ਸ਼ਾਖਾ ਵਿਭੰਨਾ ਅਭਵਨ੍; ");
INSERT INTO sanpun_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","ਭਦ੍ਰਮ੍, ਅਪ੍ਰਤ੍ਯਯਕਾਰਣਾਤ੍ ਤੇ ਵਿਭਿੰਨਾ ਜਾਤਾਸ੍ਤਥਾ ਵਿਸ਼੍ਵਾਸਕਾਰਣਾਤ੍ ਤ੍ਵੰ ਰੋਪਿਤੋ ਜਾਤਸ੍ਤਸ੍ਮਾਦ੍ ਅਹਙ੍ਕਾਰਮ੍ ਅਕ੍ਰੁʼਤ੍ਵਾ ਸਸਾਧ੍ਵਸੋ ਭਵ| ");
INSERT INTO sanpun_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","ਯਤ ਈਸ਼੍ਵਰੋ ਯਦਿ ਸ੍ਵਾਭਾਵਿਕੀਃ ਸ਼ਾਖਾ ਨ ਰਕ੍ਸ਼਼ਤਿ ਤਰ੍ਹਿ ਸਾਵਧਾਨੋ ਭਵ ਚੇਤ੍ ਤ੍ਵਾਮਪਿ ਨ ਸ੍ਥਾਪਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","ਇਤ੍ਯਤ੍ਰੇਸ਼੍ਵਰਸ੍ਯ ਯਾਦ੍ਰੁʼਸ਼ੀ ਕ੍ਰੁʼਪਾ ਤਾਦ੍ਰੁʼਸ਼ੰ ਭਯਾਨਕਤ੍ਵਮਪਿ ਤ੍ਵਯਾ ਦ੍ਰੁʼਸ਼੍ਯਤਾਂ; ਯੇ ਪਤਿਤਾਸ੍ਤਾਨ੍ ਪ੍ਰਤਿ ਤਸ੍ਯ ਭਯਾਨਕਤ੍ਵੰ ਦ੍ਰੁʼਸ਼੍ਯਤਾਂ, ਤ੍ਵਞ੍ਚ ਯਦਿ ਤਤ੍ਕ੍ਰੁʼਪਾਸ਼੍ਰਿਤਸ੍ਤਿਸ਼਼੍ਠਸਿ ਤਰ੍ਹਿ ਤ੍ਵਾਂ ਪ੍ਰਤਿ ਕ੍ਰੁʼਪਾ ਦ੍ਰਕ੍ਸ਼਼੍ਯਤੇ; ਨੋ ਚੇਤ੍ ਤ੍ਵਮਪਿ ਤਦ੍ਵਤ੍ ਛਿੰਨੋ ਭਵਿਸ਼਼੍ਯਸਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","ਅਪਰਞ੍ਚ ਤੇ ਯਦ੍ਯਪ੍ਰਤ੍ਯਯੇ ਨ ਤਿਸ਼਼੍ਠਨ੍ਤਿ ਤਰ੍ਹਿ ਪੁਨਰਪਿ ਰੋਪਯਿਸ਼਼੍ਯਨ੍ਤੇ ਯਸ੍ਮਾਤ੍ ਤਾਨ੍ ਪੁਨਰਪਿ ਰੋਪਯਿਤੁਮ੍ ਇਸ਼੍ਵਰਸ੍ਯ ਸ਼ਕ੍ਤਿਰਾਸ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","ਵਨ੍ਯਜਿਤਵ੍ਰੁʼਕ੍ਸ਼਼ਸ੍ਯ ਸ਼ਾਖਾ ਸਨ੍ ਤ੍ਵੰ ਯਦਿ ਤਤਸ਼੍ਛਿੰਨੋ ਰੀਤਿਵ੍ਯਤ੍ਯਯੇਨੋੱਤਮਜਿਤਵ੍ਰੁʼਕ੍ਸ਼਼ੇ ਰੋेेਪਿਤੋ(ਅ)ਭਵਸ੍ਤਰ੍ਹਿ ਤਸ੍ਯ ਵ੍ਰੁʼਕ੍ਸ਼਼ਸ੍ਯ ਸ੍ਵੀਯਾ ਯਾਃ ਸ਼ਾਖਾਸ੍ਤਾਃ ਕਿੰ ਪੁਨਃ ਸ੍ਵਵ੍ਰੁʼਕ੍ਸ਼਼ੇ ਸੰਲਗਿਤੁੰ ਨ ਸ਼ਕ੍ਨੁਵਨ੍ਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","ਹੇ ਭ੍ਰਾਤਰੋ ਯੁਸ਼਼੍ਮਾਕਮ੍ ਆਤ੍ਮਾਭਿਮਾਨੋ ਯੰਨ ਜਾਯਤੇ ਤਦਰ੍ਥੰ ਮਮੇਦ੍ਰੁʼਸ਼ੀ ਵਾਞ੍ਛਾ ਭਵਤਿ ਯੂਯੰ ਏਤੰਨਿਗੂਢਤੱਤ੍ਵਮ੍ ਅਜਾਨਨ੍ਤੋ ਯੰਨ ਤਿਸ਼਼੍ਠਥ; ਵਸ੍ਤੁਤੋ ਯਾਵਤ੍ਕਾਲੰ ਸਮ੍ਪੂਰ੍ਣਰੂਪੇਣ ਭਿੰਨਦੇਸ਼ਿਨਾਂ ਸੰਗ੍ਰਹੋ ਨ ਭਵਿਸ਼਼੍ਯਤਿ ਤਾਵਤ੍ਕਾਲਮ੍ ਅੰਸ਼ਤ੍ਵੇਨ ਇਸ੍ਰਾਯੇਲੀਯਲੋਕਾਨਾਮ੍ ਅਨ੍ਧਤਾ ਸ੍ਥਾਸ੍ਯਤਿ; ");
INSERT INTO sanpun_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","ਪਸ਼੍ਚਾਤ੍ ਤੇ ਸਰ੍ੱਵੇ ਪਰਿਤ੍ਰਾਸ੍ਯਨ੍ਤੇ; ਏਤਾਦ੍ਰੁʼਸ਼ੰ ਲਿਖਿਤਮਪ੍ਯਾਸ੍ਤੇ, ਆਗਮਿਸ਼਼੍ਯਤਿ ਸੀਯੋਨਾਦ੍ ਏਕੋ ਯਸ੍ਤ੍ਰਾਣਦਾਯਕਃ| ਅਧਰ੍ੰਮੰ ਯਾਕੁਬੋ ਵੰਸ਼ਾਤ੍ ਸ ਤੁ ਦੂਰੀਕਰਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","ਤਥਾ ਦੂਰੀਕਰਿਸ਼਼੍ਯਾਮਿ ਤੇਸ਼਼ਾਂ ਪਾਪਾਨ੍ਯਹੰ ਯਦਾ| ਤਦਾ ਤੈਰੇਵ ਸਾਰ੍ੱਧੰ ਮੇ ਨਿਯਮੋ(ਅ)ਯੰ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","ਸੁਸੰਵਾਦਾਤ੍ ਤੇ ਯੁਸ਼਼੍ਮਾਕੰ ਵਿਪਕ੍ਸ਼਼ਾ ਅਭਵਨ੍ ਕਿਨ੍ਤ੍ਵਭਿਰੁਚਿਤਤ੍ਵਾਤ੍ ਤੇ ਪਿਤ੍ਰੁʼਲੋਕਾਨਾਂ ਕ੍ਰੁʼਤੇ ਪ੍ਰਿਯਪਾਤ੍ਰਾਣਿ ਭਵਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","ਯਤ ਈਸ਼੍ਵਰਸ੍ਯ ਦਾਨਾਦ੍ ਆਹ੍ਵਾਨਾਞ੍ਚ ਪਸ਼੍ਚਾੱਤਾਪੋ ਨ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","ਅਤਏਵ ਪੂਰ੍ੱਵਮ੍ ਈਸ਼੍ਵਰੇ(ਅ)ਵਿਸ਼੍ਵਾਸਿਨਃ ਸਨ੍ਤੋ(ਅ)ਪਿ ਯੂਯੰ ਯਦ੍ਵਤ੍ ਸਮ੍ਪ੍ਰਤਿ ਤੇਸ਼਼ਾਮ੍ ਅਵਿਸ਼੍ਵਾਸਕਾਰਣਾਦ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਕ੍ਰੁʼਪਾਪਾਤ੍ਰਾਣਿ ਜਾਤਾਸ੍ਤਦ੍ਵਦ੍ ");
INSERT INTO sanpun_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","ਇਦਾਨੀਂ ਤੇ(ਅ)ਵਿਸ਼੍ਵਾਸਿਨਃ ਸਨ੍ਤਿ ਕਿਨ੍ਤੁ ਯੁਸ਼਼੍ਮਾਭਿ ਰ੍ਲਬ੍ਧਕ੍ਰੁʼਪਾਕਾਰਣਾਤ੍ ਤੈਰਪਿ ਕ੍ਰੁʼਪਾ ਲਪ੍ਸ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","ਈਸ਼੍ਵਰਃ ਸਰ੍ੱਵਾਨ੍ ਪ੍ਰਤਿ ਕ੍ਰੁʼਪਾਂ ਪ੍ਰਕਾਸ਼ਯਿਤੁੰ ਸਰ੍ੱਵਾਨ੍ ਅਵਿਸ਼੍ਵਾਸਿਤ੍ਵੇਨ ਗਣਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","ਅਹੋ ਈਸ਼੍ਵਰਸ੍ਯ ਜ੍ਞਾਨਬੁੱਧਿਰੂਪਯੋ ਰ੍ਧਨਯੋਃ ਕੀਦ੍ਰੁʼਕ੍ ਪ੍ਰਾਚੁਰ੍ੱਯੰ| ਤਸ੍ਯ ਰਾਜਸ਼ਾਸਨਸ੍ਯ ਤੱਤ੍ਵੰ ਕੀਦ੍ਰੁʼਗ੍ ਅਪ੍ਰਾਪ੍ਯੰ| ਤਸ੍ਯ ਮਾਰ੍ਗਾਸ਼੍ਚ ਕੀਦ੍ਰੁʼਗ੍ ਅਨੁਪਲਕ੍ਸ਼਼੍ਯਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","ਪਰਮੇਸ਼੍ਵਰਸ੍ਯ ਸਙ੍ਕਲ੍ਪੰ ਕੋ ਜ੍ਞਾਤਵਾਨ੍? ਤਸ੍ਯ ਮਨ੍ਤ੍ਰੀ ਵਾ ਕੋ(ਅ)ਭਵਤ੍? ");
INSERT INTO sanpun_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","ਕੋ ਵਾ ਤਸ੍ਯੋਪਕਾਰੀ ਭ੍ਰੁʼਤ੍ਵਾ ਤਤ੍ਕ੍ਰੁʼਤੇ ਤੇਨ ਪ੍ਰਤ੍ਯੁਪਕਰ੍ੱਤਵ੍ਯਃ? ");
INSERT INTO sanpun_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","ਯਤੋ ਵਸ੍ਤੁਮਾਤ੍ਰਮੇਵ ਤਸ੍ਮਾਤ੍ ਤੇਨ ਤਸ੍ਮੈ ਚਾਭਵਤ੍ ਤਦੀਯੋ ਮਹਿਮਾ ਸਰ੍ੱਵਦਾ ਪ੍ਰਕਾਸ਼ਿਤੋ ਭਵਤੁ| ਇਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","ਹੇ ਭ੍ਰਾਤਰ ਈਸ਼੍ਵਰਸ੍ਯ ਕ੍ਰੁʼਪਯਾਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਵਿਨਯੇ ਯੂਯੰ ਸ੍ਵੰ ਸ੍ਵੰ ਸ਼ਰੀਰੰ ਸਜੀਵੰ ਪਵਿਤ੍ਰੰ ਗ੍ਰਾਹ੍ਯੰ ਬਲਿਮ੍ ਈਸ਼੍ਵਰਮੁੱਦਿਸ਼੍ਯ ਸਮੁਤ੍ਸ੍ਰੁʼਜਤ, ਏਸ਼਼ਾ ਸੇਵਾ ਯੁਸ਼਼੍ਮਾਕੰ ਯੋਗ੍ਯਾ| ");
INSERT INTO sanpun_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","ਅਪਰੰ ਯੂਯੰ ਸਾਂਸਾਰਿਕਾ ਇਵ ਮਾਚਰਤ, ਕਿਨ੍ਤੁ ਸ੍ਵੰ ਸ੍ਵੰ ਸ੍ਵਭਾਵੰ ਪਰਾਵਰ੍ਤ੍ਯ ਨੂਤਨਾਚਾਰਿਣੋ ਭਵਤ, ਤਤ ਈਸ਼੍ਵਰਸ੍ਯ ਨਿਦੇਸ਼ਃ ਕੀਦ੍ਰੁʼਗ੍ ਉੱਤਮੋ ਗ੍ਰਹਣੀਯਃ ਸਮ੍ਪੂਰ੍ਣਸ਼੍ਚੇਤਿ ਯੁਸ਼਼੍ਮਾਭਿਰਨੁਭਾਵਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","ਕਸ਼੍ਚਿਦਪਿ ਜਨੋ ਯੋਗ੍ਯਤ੍ਵਾਦਧਿਕੰ ਸ੍ਵੰ ਨ ਮਨ੍ਯਤਾਂ ਕਿਨ੍ਤੁ ਈਸ਼੍ਵਰੋ ਯਸ੍ਮੈ ਪ੍ਰਤ੍ਯਯਸ੍ਯ ਯਤ੍ਪਰਿਮਾਣਮ੍ ਅਦਦਾਤ੍ ਸ ਤਦਨੁਸਾਰਤੋ ਯੋਗ੍ਯਰੂਪੰ ਸ੍ਵੰ ਮਨੁਤਾਮ੍, ਈਸ਼੍ਵਰਾਦ੍ ਅਨੁਗ੍ਰਹੰ ਪ੍ਰਾਪ੍ਤਃ ਸਨ੍ ਯੁਸ਼਼੍ਮਾਕਮ੍ ਏਕੈਕੰ ਜਨਮ੍ ਇਤ੍ਯਾਜ੍ਞਾਪਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","ਯਤੋ ਯਦ੍ਵਦਸ੍ਮਾਕਮ੍ ਏਕਸ੍ਮਿਨ੍ ਸ਼ਰੀਰੇ ਬਹੂਨ੍ਯਙ੍ਗਾਨਿ ਸਨ੍ਤਿ ਕਿਨ੍ਤੁ ਸਰ੍ੱਵੇਸ਼਼ਾਮਙ੍ਗਾਨਾਂ ਕਾਰ੍ੱਯੰ ਸਮਾਨੰ ਨਹਿ; ");
INSERT INTO sanpun_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","ਤਦ੍ਵਦਸ੍ਮਾਕੰ ਬਹੁਤ੍ਵੇ(ਅ)ਪਿ ਸਰ੍ੱਵੇ ਵਯੰ ਖ੍ਰੀਸ਼਼੍ਟੇ ਏਕਸ਼ਰੀਰਾਃ ਪਰਸ੍ਪਰਮ੍ ਅਙ੍ਗਪ੍ਰਤ੍ਯਙ੍ਗਤ੍ਵੇਨ ਭਵਾਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","ਅਸ੍ਮਾਦ੍ ਈਸ਼੍ਵਰਾਨੁਗ੍ਰਹੇਣ ਵਿਸ਼ੇਸ਼਼ੰ ਵਿਸ਼ੇਸ਼਼ੰ ਦਾਨਮ੍ ਅਸ੍ਮਾਸੁ ਪ੍ਰਾਪ੍ਤੇਸ਼਼ੁ ਸਤ੍ਸੁ ਕੋਪਿ ਯਦਿ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਕ੍ਯੰ ਵਦਤਿ ਤਰ੍ਹਿ ਪ੍ਰਤ੍ਯਯਸ੍ਯ ਪਰਿਮਾਣਾਨੁਸਾਰਤਃ ਸ ਤਦ੍ ਵਦਤੁ; ");
INSERT INTO sanpun_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","ਯਦ੍ਵਾ ਯਦਿ ਕਸ਼੍ਚਿਤ੍ ਸੇਵਨਕਾਰੀ ਭਵਤਿ ਤਰ੍ਹਿ ਸ ਤਤ੍ਸੇਵਨੰ ਕਰੋਤੁ; ਅਥਵਾ ਯਦਿ ਕਸ਼੍ਚਿਦ੍ ਅਧ੍ਯਾਪਯਿਤਾ ਭਵਤਿ ਤਰ੍ਹਿ ਸੋ(ਅ)ਧ੍ਯਾਪਯਤੁ; ");
INSERT INTO sanpun_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","ਤਥਾ ਯ ਉਪਦੇਸ਼਼੍ਟਾ ਭਵਤਿ ਸ ਉਪਦਿਸ਼ਤੁ ਯਸ਼੍ਚ ਦਾਤਾ ਸ ਸਰਲਤਯਾ ਦਦਾਤੁ ਯਸ੍ਤ੍ਵਧਿਪਤਿਃ ਸ ਯਤ੍ਨੇਨਾਧਿਪਤਿਤ੍ਵੰ ਕਰੋਤੁ ਯਸ਼੍ਚ ਦਯਾਲੁਃ ਸ ਹ੍ਰੁʼਸ਼਼੍ਟਮਨਸਾ ਦਯਤਾਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","ਅਪਰਞ੍ਚ ਯੁਸ਼਼੍ਮਾਕੰ ਪ੍ਰੇਮ ਕਾਪਟ੍ਯਵਰ੍ਜਿਤੰ ਭਵਤੁ ਯਦ੍ ਅਭਦ੍ਰੰ ਤਦ੍ ਰੁʼਤੀਯਧ੍ਵੰ ਯੱਚ ਭਦ੍ਰੰ ਤਸ੍ਮਿਨ੍ ਅਨੁਰਜ੍ਯਧ੍ਵਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","ਅਪਰੰ ਭ੍ਰਾਤ੍ਰੁʼਤ੍ਵਪ੍ਰੇਮ੍ਨਾ ਪਰਸ੍ਪਰੰ ਪ੍ਰੀਯਧ੍ਵੰ ਸਮਾਦਰਾਦ੍ ਏਕੋ(ਅ)ਪਰਜਨੰ ਸ਼੍ਰੇਸ਼਼੍ਠੰ ਜਾਨੀਧ੍ਵਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","ਤਥਾ ਕਾਰ੍ੱਯੇ ਨਿਰਾਲਸ੍ਯਾ ਮਨਸਿ ਚ ਸੋਦ੍ਯੋਗਾਃ ਸਨ੍ਤਃ ਪ੍ਰਭੁੰ ਸੇਵਧ੍ਵਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","ਅਪਰੰ ਪ੍ਰਤ੍ਯਾਸ਼ਾਯਾਮ੍ ਆਨਨ੍ਦਿਤਾ ਦੁਃਖਸਮਯੇ ਚ ਧੈਰ੍ੱਯਯੁਕ੍ਤਾ ਭਵਤ; ਪ੍ਰਾਰ੍ਥਨਾਯਾਂ ਸਤਤੰ ਪ੍ਰਵਰ੍ੱਤਧ੍ਵੰ| ");
INSERT INTO sanpun_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","ਪਵਿਤ੍ਰਾਣਾਂ ਦੀਨਤਾਂ ਦੂਰੀਕੁਰੁਧ੍ਵਮ੍ ਅਤਿਥਿਸੇਵਾਯਾਮ੍ ਅਨੁਰਜ੍ਯਧ੍ਵਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","ਯੇ ਜਨਾ ਯੁਸ਼਼੍ਮਾਨ੍ ਤਾਡਯਨ੍ਤਿ ਤਾਨ੍ ਆਸ਼ਿਸ਼਼ੰ ਵਦਤ ਸ਼ਾਪਮ੍ ਅਦੱਤ੍ਵਾ ਦੱਧ੍ਵਮਾਸ਼ਿਸ਼਼ਮ੍| ");
INSERT INTO sanpun_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","ਯੇ ਜਨਾ ਆਨਨ੍ਦਨ੍ਤਿ ਤੈਃ ਸਾਰ੍ੱਧਮ੍ ਆਨਨ੍ਦਤ ਯੇ ਚ ਰੁਦਨ੍ਤਿ ਤੈਃ ਸਹ ਰੁਦਿਤ| ");
INSERT INTO sanpun_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","ਅਪਰਞ੍ਚ ਯੁਸ਼਼੍ਮਾਕੰ ਮਨਸਾਂ ਪਰਸ੍ਪਰਮ੍ ਏਕੋਭਾਵੋ ਭਵਤੁ; ਅਪਰਮ੍ ਉੱਚਪਦਮ੍ ਅਨਾਕਾਙ੍ਕ੍ਸ਼਼੍ਯ ਨੀਚਲੋਕੈਃ ਸਹਾਪਿ ਮਾਰ੍ਦਵਮ੍ ਆਚਰਤ; ਸ੍ਵਾਨ੍ ਜ੍ਞਾਨਿਨੋ ਨ ਮਨ੍ਯਧ੍ਵੰ| ");
INSERT INTO sanpun_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","ਪਰਸ੍ਮਾਦ੍ ਅਪਕਾਰੰ ਪ੍ਰਾਪ੍ਯਾਪਿ ਪਰੰ ਨਾਪਕੁਰੁਤ| ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਦ੍ਰੁʼਸ਼਼੍ਟਿਤੋ ਯਤ੍ ਕਰ੍ੰਮੋੱਤਮੰ ਤਦੇਵ ਕੁਰੁਤ| ");
INSERT INTO sanpun_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","ਯਦਿ ਭਵਿਤੁੰ ਸ਼ਕ੍ਯਤੇ ਤਰ੍ਹਿ ਯਥਾਸ਼ਕ੍ਤਿ ਸਰ੍ੱਵਲੋਕੈਃ ਸਹ ਨਿਰ੍ੱਵਿਰੋਧੇਨ ਕਾਲੰ ਯਾਪਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","ਹੇ ਪ੍ਰਿਯਬਨ੍ਧਵਃ, ਕਸ੍ਮੈਚਿਦ੍ ਅਪਕਾਰਸ੍ਯ ਸਮੁਚਿਤੰ ਦਣ੍ਡੰ ਸ੍ਵਯੰ ਨ ਦੱਧ੍ਵੰ, ਕਿਨ੍ਤ੍ਵੀਸ਼੍ਵਰੀਯਕ੍ਰੋਧਾਯ ਸ੍ਥਾਨੰ ਦੱਤ ਯਤੋ ਲਿਖਿਤਮਾਸ੍ਤੇ ਪਰਮੇਸ਼੍ਵਰਃ ਕਥਯਤਿ, ਦਾਨੰ ਫਲਸ੍ਯ ਮਤ੍ਕਰ੍ੰਮ ਸੂਚਿਤੰ ਪ੍ਰਦਦਾਮ੍ਯਹੰ| ");
INSERT INTO sanpun_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","ਇਤਿਕਾਰਣਾਦ੍ ਰਿਪੁ ਰ੍ਯਦਿ ਕ੍ਸ਼਼ੁਧਾਰ੍ੱਤਸ੍ਤੇ ਤਰ੍ਹਿ ਤੰ ਤ੍ਵੰ ਪ੍ਰਭੋਜਯ| ਤਥਾ ਯਦਿ ਤ੍ਰੁʼਸ਼਼ਾਰ੍ੱਤਃ ਸ੍ਯਾਤ੍ ਤਰ੍ਹਿ ਤੰ ਪਰਿਪਾਯਯ| ਤੇਨ ਤ੍ਵੰ ਮਸ੍ਤਕੇ ਤਸ੍ਯ ਜ੍ਵਲਦਗ੍ਨਿੰ ਨਿਧਾਸ੍ਯਸਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","ਕੁਕ੍ਰਿਯਯਾ ਪਰਾਜਿਤਾ ਨ ਸਨ੍ਤ ਉੱਤਮਕ੍ਰਿਯਯਾ ਕੁਕ੍ਰਿਯਾਂ ਪਰਾਜਯਤ| ");
INSERT INTO sanpun_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","ਯੁਸ਼਼੍ਮਾਕਮ੍ ਏਕੈਕਜਨਃ ਸ਼ਾਸਨਪਦਸ੍ਯ ਨਿਘ੍ਨੋ ਭਵਤੁ ਯਤੋ ਯਾਨਿ ਸ਼ਾਸਨਪਦਾਨਿ ਸਨ੍ਤਿ ਤਾਨਿ ਸਰ੍ੱਵਾਣੀਸ਼੍ਵਰੇਣ ਸ੍ਥਾਪਿਤਾਨਿ; ਈਸ਼੍ਵਰੰ ਵਿਨਾ ਪਦਸ੍ਥਾਪਨੰ ਨ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","ਇਤਿ ਹੇਤੋਃ ਸ਼ਾਸਨਪਦਸ੍ਯ ਯਤ੍ ਪ੍ਰਾਤਿਕੂਲ੍ਯੰ ਤਦ੍ ਈਸ਼੍ਵਰੀਯਨਿਰੂਪਣਸ੍ਯ ਪ੍ਰਾਤਿਕੂਲ੍ਯਮੇਵ; ਅਪਰੰ ਯੇ ਪ੍ਰਾਤਿਕੂਲ੍ਯਮ੍ ਆਚਰਨ੍ਤਿ ਤੇ ਸ੍ਵੇਸ਼਼ਾਂ ਸਮੁਚਿਤੰ ਦਣ੍ਡੰ ਸ੍ਵਯਮੇਵ ਘਟਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","ਸ਼ਾਸ੍ਤਾ ਸਦਾਚਾਰਿਣਾਂ ਭਯਪ੍ਰਦੋ ਨਹਿ ਦੁਰਾਚਾਰਿਣਾਮੇਵ ਭਯਪ੍ਰਦੋ ਭਵਤਿ; ਤ੍ਵੰ ਕਿੰ ਤਸ੍ਮਾਨ੍ ਨਿਰ੍ਭਯੋ ਭਵਿਤੁਮ੍ ਇੱਛਸਿ? ਤਰ੍ਹਿ ਸਤ੍ਕਰ੍ੰਮਾਚਰ, ਤਸ੍ਮਾਦ੍ ਯਸ਼ੋ ਲਪ੍ਸ੍ਯਸੇ, ");
INSERT INTO sanpun_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","ਯਤਸ੍ਤਵ ਸਦਾਚਰਣਾਯ ਸ ਈਸ਼੍ਵਰਸ੍ਯ ਭ੍ਰੁʼਤ੍ਯੋ(ਅ)ਸ੍ਤਿ| ਕਿਨ੍ਤੁ ਯਦਿ ਕੁਕਰ੍ੰਮਾਚਰਸਿ ਤਰ੍ਹਿ ਤ੍ਵੰ ਸ਼ਙ੍ਕਸ੍ਵ ਯਤਃ ਸ ਨਿਰਰ੍ਥਕੰ ਖਙ੍ਗੰ ਨ ਧਾਰਯਤਿ; ਕੁਕਰ੍ੰਮਾਚਾਰਿਣੰ ਸਮੁਚਿਤੰ ਦਣ੍ਡਯਿਤੁਮ੍ ਸ ਈਸ਼੍ਵਰਸ੍ਯ ਦਣ੍ਡਦਭ੍ਰੁʼਤ੍ਯ ਏਵ| ");
INSERT INTO sanpun_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","ਅਤਏਵ ਕੇਵਲਦਣ੍ਡਭਯਾੰਨਹਿ ਕਿਨ੍ਤੁ ਸਦਸਦ੍ਬੋਧਾਦਪਿ ਤਸ੍ਯ ਵਸ਼੍ਯੇਨ ਭਵਿਤਵ੍ਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","ਏਤਸ੍ਮਾਦ੍ ਯੁਸ਼਼੍ਮਾਕੰ ਰਾਜਕਰਦਾਨਮਪ੍ਯੁਚਿਤੰ ਯਸ੍ਮਾਦ੍ ਯੇ ਕਰੰ ਗ੍ਰੁʼਹ੍ਲਨ੍ਤਿ ਤ ਈਸ਼੍ਵਰਸ੍ਯ ਕਿਙ੍ਕਰਾ ਭੂਤ੍ਵਾ ਸਤਤਮ੍ ਏਤਸ੍ਮਿਨ੍ ਕਰ੍ੰਮਣਿ ਨਿਵਿਸ਼਼੍ਟਾਸ੍ਤਿਸ਼਼੍ਠਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","ਅਸ੍ਮਾਤ੍ ਕਰਗ੍ਰਾਹਿਣੇ ਕਰੰ ਦੱਤ, ਤਥਾ ਸ਼ੁਲ੍ਕਗ੍ਰਾਹਿਣੇ ਸ਼ੁਲ੍ਕੰ ਦੱਤ, ਅਪਰੰ ਯਸ੍ਮਾਦ੍ ਭੇਤਵ੍ਯੰ ਤਸ੍ਮਾਦ੍ ਬਿਭੀਤ, ਯਸ਼੍ਚ ਸਮਾਦਰਣੀਯਸ੍ਤੰ ਸਮਾਦ੍ਰਿਯਧ੍ਵਮ੍; ਇੱਥੰ ਯਸ੍ਯ ਯਤ੍ ਪ੍ਰਾਪ੍ਯੰ ਤਤ੍ ਤਸ੍ਮੈ ਦੱਤ| ");
INSERT INTO sanpun_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","ਯੁਸ਼਼੍ਮਾਕੰ ਪਰਸ੍ਪਰੰ ਪ੍ਰੇਮ ਵਿਨਾ (ਅ)ਨ੍ਯਤ੍ ਕਿਮਪਿ ਦੇਯਮ੍ ਰੁʼਣੰ ਨ ਭਵਤੁ, ਯਤੋ ਯਃ ਪਰਸ੍ਮਿਨ੍ ਪ੍ਰੇਮ ਕਰੋਤਿ ਤੇਨ ਵ੍ਯਵਸ੍ਥਾ ਸਿਧ੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","ਵਸ੍ਤੁਤਃ ਪਰਦਾਰਾਨ੍ ਮਾ ਗੱਛ, ਨਰਹਤ੍ਯਾਂ ਮਾ ਕਾਰ੍ਸ਼਼ੀਃ, ਚੈਰ੍ੱਯੰ ਮਾ ਕਾਰ੍ਸ਼਼ੀਃ, ਮਿਥ੍ਯਾਸਾਕ੍ਸ਼਼੍ਯੰ ਮਾ ਦੇਹਿ, ਲੋਭੰ ਮਾ ਕਾਰ੍ਸ਼਼ੀਃ, ਏਤਾਃ ਸਰ੍ੱਵਾ ਆਜ੍ਞਾ ਏਤਾਭ੍ਯੋ ਭਿੰਨਾ ਯਾ ਕਾਚਿਦ੍ ਆਜ੍ਞਾਸ੍ਤਿ ਸਾਪਿ ਸ੍ਵਸਮੀਪਵਾਸਿਨਿ ਸ੍ਵਵਤ੍ ਪ੍ਰੇਮ ਕੁਰ੍ੱਵਿਤ੍ਯਨੇਨ ਵਚਨੇਨ ਵੇਦਿਤਾ| ");
INSERT INTO sanpun_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","ਯਤਃ ਪ੍ਰੇਮ ਸਮੀਪਵਾਸਿਨੋ(ਅ)ਸ਼ੁਭੰ ਨ ਜਨਯਤਿ ਤਸ੍ਮਾਤ੍ ਪ੍ਰੇਮ੍ਨਾ ਸਰ੍ੱਵਾ ਵ੍ਯਵਸ੍ਥਾ ਪਾਲ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","ਪ੍ਰਤ੍ਯਯੀਭਵਨਕਾਲੇ(ਅ)ਸ੍ਮਾਕੰ ਪਰਿਤ੍ਰਾਣਸ੍ਯ ਸਾਮੀਪ੍ਯਾਦ੍ ਇਦਾਨੀਂ ਤਸ੍ਯ ਸਾਮੀਪ੍ਯਮ੍ ਅਵ੍ਯਵਹਿਤੰ; ਅਤਃ ਸਮਯੰ ਵਿਵਿਚ੍ਯਾਸ੍ਮਾਭਿਃ ਸਾਮ੍ਪ੍ਰਤਮ੍ ਅਵਸ਼੍ਯਮੇਵ ਨਿਦ੍ਰਾਤੋ ਜਾਗਰ੍ੱਤਵ੍ਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","ਬਹੁਤਰਾ ਯਾਮਿਨੀ ਗਤਾ ਪ੍ਰਭਾਤੰ ਸੰਨਿਧਿੰ ਪ੍ਰਾਪ੍ਤੰ ਤਸ੍ਮਾਤ੍ ਤਾਮਸੀਯਾਃ ਕ੍ਰਿਯਾਃ ਪਰਿਤ੍ਯਜ੍ਯਾਸ੍ਮਾਭਿ ਰ੍ਵਾਸਰੀਯਾ ਸੱਜਾ ਪਰਿਧਾਤਵ੍ਯਾ| ");
INSERT INTO sanpun_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","ਅਤੋ ਹੇਤੋ ਰ੍ਵਯੰ ਦਿਵਾ ਵਿਹਿਤੰ ਸਦਾਚਰਣਮ੍ ਆਚਰਿਸ਼਼੍ਯਾਮਃ| ਰਙ੍ਗਰਸੋ ਮੱਤਤ੍ਵੰ ਲਮ੍ਪਟਤ੍ਵੰ ਕਾਮੁਕਤ੍ਵੰ ਵਿਵਾਦ ਈਰ੍ਸ਼਼੍ਯਾ ਚੈਤਾਨਿ ਪਰਿਤ੍ਯਕ੍ਸ਼਼੍ਯਾਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","ਯੂਯੰ ਪ੍ਰਭੁਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟਰੂਪੰ ਪਰਿੱਛਦੰ ਪਰਿਧੱਧ੍ਵੰ ਸੁਖਾਭਿਲਾਸ਼਼ਪੂਰਣਾਯ ਸ਼ਾਰੀਰਿਕਾਚਰਣੰ ਮਾਚਰਤ| ");
INSERT INTO sanpun_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","ਯੋ ਜਨੋ(ਅ)ਦ੍ਰੁʼਢਵਿਸ਼੍ਵਾਸਸ੍ਤੰ ਯੁਸ਼਼੍ਮਾਕੰ ਸਙ੍ਗਿਨੰ ਕੁਰੁਤ ਕਿਨ੍ਤੁ ਸਨ੍ਦੇਹਵਿਚਾਰਾਰ੍ਥੰ ਨਹਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","ਯਤੋ ਨਿਸ਼਼ਿੱਧੰ ਕਿਮਪਿ ਖਾਦ੍ਯਦ੍ਰਵ੍ਯੰ ਨਾਸ੍ਤਿ, ਕਸ੍ਯਚਿੱਜਨਸ੍ਯ ਪ੍ਰਤ੍ਯਯ ਏਤਾਦ੍ਰੁʼਸ਼ੋ ਵਿਦ੍ਯਤੇ ਕਿਨ੍ਤ੍ਵਦ੍ਰੁʼਢਵਿਸ਼੍ਵਾਸਃ ਕਸ਼੍ਚਿਦਪਰੋ ਜਨਃ ਕੇਵਲੰ ਸ਼ਾਕੰ ਭੁਙ੍ਕ੍ਤੰ| ");
INSERT INTO sanpun_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","ਤਰ੍ਹਿ ਯੋ ਜਨਃ ਸਾਧਾਰਣੰ ਦ੍ਰਵ੍ਯੰ ਭੁਙ੍ਕ੍ਤੇ ਸ ਵਿਸ਼ੇਸ਼਼ਦ੍ਰਵ੍ਯਭੋਕ੍ਤਾਰੰ ਨਾਵਜਾਨੀਯਾਤ੍ ਤਥਾ ਵਿਸ਼ੇਸ਼਼ਦ੍ਰਵ੍ਯਭੋਕ੍ਤਾਪਿ ਸਾਧਾਰਣਦ੍ਰਵ੍ਯਭੋਕ੍ਤਾਰੰ ਦੋਸ਼਼ਿਣੰ ਨ ਕੁਰ੍ੱਯਾਤ੍, ਯਸ੍ਮਾਦ੍ ਈਸ਼੍ਵਰਸ੍ਤਮ੍ ਅਗ੍ਰੁʼਹ੍ਲਾਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","ਹੇ ਪਰਦਾਸਸ੍ਯ ਦੂਸ਼਼ਯਿਤਸ੍ਤ੍ਵੰ ਕਃ? ਨਿਜਪ੍ਰਭੋਃ ਸਮੀਪੇ ਤੇਨ ਪਦਸ੍ਥੇਨ ਪਦਚ੍ਯੁਤੇਨ ਵਾ ਭਵਿਤਵ੍ਯੰ ਸ ਚ ਪਦਸ੍ਥ ਏਵ ਭਵਿਸ਼਼੍ਯਤਿ ਯਤ ਈਸ਼੍ਵਰਸ੍ਤੰ ਪਦਸ੍ਥੰ ਕਰ੍ੱਤੁੰ ਸ਼ਕ੍ਨੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","ਅਪਰਞ੍ਚ ਕਸ਼੍ਚਿੱਜਨੋ ਦਿਨਾਦ੍ ਦਿਨੰ ਵਿਸ਼ੇਸ਼਼ੰ ਮਨ੍ਯਤੇ ਕਸ਼੍ਚਿੱਤੁु ਸਰ੍ੱਵਾਣਿ ਦਿਨਾਨਿ ਸਮਾਨਾਨਿ ਮਨ੍ਯਤੇ, ਏਕੈਕੋ ਜਨਃ ਸ੍ਵੀਯਮਨਸਿ ਵਿਵਿਚ੍ਯ ਨਿਸ਼੍ਚਿਨੋਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","ਯੋ ਜਨਃ ਕਿਞ੍ਚਨ ਦਿਨੰ ਵਿਸ਼ੇਸ਼਼ੰ ਮਨ੍ਯਤੇ ਸ ਪ੍ਰਭੁਭਕ੍ਤ੍ਯਾ ਤਨ੍ ਮਨ੍ਯਤੇ, ਯਸ਼੍ਚ ਜਨਃ ਕਿਮਪਿ ਦਿਨੰ ਵਿਸ਼ੇਸ਼਼ੰ ਨ ਮਨ੍ਯਤੇ ਸੋ(ਅ)ਪਿ ਪ੍ਰਭੁਭਕ੍ਤ੍ਯਾ ਤੰਨ ਮਨ੍ਯਤੇ; ਅਪਰਞ੍ਚ ਯਃ ਸਰ੍ੱਵਾਣਿ ਭਕ੍ਸ਼਼੍ਯਦ੍ਰਵ੍ਯਾਣਿ ਭੁਙ੍ਕ੍ਤੇ ਸ ਪ੍ਰਭੁਭਕ੍ਤਯਾ ਤਾਨਿ ਭੁਙ੍ਕ੍ਤੇ ਯਤਃ ਸ ਈਸ਼੍ਵਰੰ ਧਨ੍ਯੰ ਵਕ੍ਤਿ, ਯਸ਼੍ਚ ਨ ਭੁਙ੍ਕ੍ਤੇ ਸੋ(ਅ)ਪਿ ਪ੍ਰਭੁਭਕ੍ਤ੍ਯੈਵ ਨ ਭੁਞ੍ਜਾਨ ਈਸ਼੍ਵਰੰ ਧਨ੍ਯੰ ਬ੍ਰੂਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","ਅਪਰਮ੍ ਅਸ੍ਮਾਕੰ ਕਸ਼੍ਚਿਤ੍ ਨਿਜਨਿਮਿੱਤੰ ਪ੍ਰਾਣਾਨ੍ ਧਾਰਯਤਿ ਨਿਜਨਿਮਿੱਤੰ ਮ੍ਰਿਯਤੇ ਵਾ ਤੰਨ; ");
INSERT INTO sanpun_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","ਕਿਨ੍ਤੁ ਯਦਿ ਵਯੰ ਪ੍ਰਾਣਾਨ੍ ਧਾਰਯਾਮਸ੍ਤਰ੍ਹਿ ਪ੍ਰਭੁਨਿਮਿੱਤੰ ਧਾਰਯਾਮਃ, ਯਦਿ ਚ ਪ੍ਰਾਣਾਨ੍ ਤ੍ਯਜਾਮਸ੍ਤਰ੍ਹ੍ਯਪਿ ਪ੍ਰਭੁਨਿਮਿੱਤੰ ਤ੍ਯਜਾਮਃ, ਅਤਏਵ ਜੀਵਨੇ ਮਰਣੇ ਵਾ ਵਯੰ ਪ੍ਰਭੋਰੇਵਾਸ੍ਮਹੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","ਯਤੋ ਜੀਵਨ੍ਤੋ ਮ੍ਰੁʼਤਾਸ਼੍ਚੇਤ੍ਯੁਭਯੇਸ਼਼ਾਂ ਲੋਕਾਨਾਂ ਪ੍ਰਭੁਤ੍ਵਪ੍ਰਾਪ੍ਤ੍ਯਰ੍ਥੰ ਖ੍ਰੀਸ਼਼੍ਟੋ ਮ੍ਰੁʼਤ ਉੱਥਿਤਃ ਪੁਨਰ੍ਜੀਵਿਤਸ਼੍ਚ| ");
INSERT INTO sanpun_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","ਕਿਨ੍ਤੁ ਤ੍ਵੰ ਨਿਜੰ ਭ੍ਰਾਤਰੰ ਕੁਤੋ ਦੂਸ਼਼ਯਸਿ? ਤਥਾ ਤ੍ਵੰ ਨਿਜੰ ਭ੍ਰਾਤਰੰ ਕੁਤਸ੍ਤੁੱਛੰ ਜਾਨਾਸਿ? ਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਵਿਚਾਰਸਿੰਹਾਸਨਸ੍ਯ ਸੰਮੁਖੇ ਸਰ੍ੱਵੈਰਸ੍ਮਾਭਿਰੁਪਸ੍ਥਾਤਵ੍ਯੰ; ");
INSERT INTO sanpun_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","ਯਾਦ੍ਰੁʼਸ਼ੰ ਲਿਖਿਤਮ੍ ਆਸ੍ਤੇ, ਪਰੇਸ਼ਃ ਸ਼ਪਥੰ ਕੁਰ੍ੱਵਨ੍ ਵਾਕ੍ਯਮੇਤਤ੍ ਪੁਰਾਵਦਤ੍| ਸਰ੍ੱਵੋ ਜਨਃ ਸਮੀਪੇ ਮੇ ਜਾਨੁਪਾਤੰ ਕਰਿਸ਼਼੍ਯਤਿ| ਜਿਹ੍ਵੈਕੈਕਾ ਤਥੇਸ਼ਸ੍ਯ ਨਿਘ੍ਨਤ੍ਵੰ ਸ੍ਵੀਕਰਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","ਅਤਏਵ ਈਸ਼੍ਵਰਸਮੀਪੇ(ਅ)ਸ੍ਮਾਕਮ੍ ਏਕੈਕਜਨੇਨ ਨਿਜਾ ਕਥਾ ਕਥਯਿਤਵ੍ਯਾ| ");
INSERT INTO sanpun_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","ਇੱਥੰ ਸਤਿ ਵਯਮ੍ ਅਦ੍ਯਾਰਭ੍ਯ ਪਰਸ੍ਪਰੰ ਨ ਦੂਸ਼਼ਯਨ੍ਤਃ ਸ੍ਵਭ੍ਰਾਤੁ ਰ੍ਵਿਘ੍ਨੋ ਵ੍ਯਾਘਾਤੋ ਵਾ ਯੰਨ ਜਾਯੇਤ ਤਾਦ੍ਰੁʼਸ਼ੀਮੀਹਾਂ ਕੁਰ੍ੰਮਹੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","ਕਿਮਪਿ ਵਸ੍ਤੁ ਸ੍ਵਭਾਵਤੋ ਨਾਸ਼ੁਚਿ ਭਵਤੀਤ੍ਯਹੰ ਜਾਨੇ ਤਥਾ ਪ੍ਰਭੁਨਾ ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟੇਨਾਪਿ ਨਿਸ਼੍ਚਿਤੰ ਜਾਨੇ, ਕਿਨ੍ਤੁ ਯੋ ਜਨੋ ਯਦ੍ ਦ੍ਰਵ੍ਯਮ੍ ਅਪਵਿਤ੍ਰੰ ਜਾਨੀਤੇ ਤਸ੍ਯ ਕ੍ਰੁʼਤੇ ਤਦ੍ ਅਪਵਿਤ੍ਰਮ੍ ਆਸ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","ਅਤਏਵ ਤਵ ਭਕ੍ਸ਼਼੍ਯਦ੍ਰਵ੍ਯੇਣ ਤਵ ਭ੍ਰਾਤਾ ਸ਼ੋਕਾਨ੍ਵਿਤੋ ਭਵਤਿ ਤਰ੍ਹਿ ਤ੍ਵੰ ਭ੍ਰਾਤਰੰ ਪ੍ਰਤਿ ਪ੍ਰੇਮ੍ਨਾ ਨਾਚਰਸਿ| ਖ੍ਰੀਸ਼਼੍ਟੋ ਯਸ੍ਯ ਕ੍ਰੁʼਤੇ ਸ੍ਵਪ੍ਰਾਣਾਨ੍ ਵ੍ਯਯਿਤਵਾਨ੍ ਤ੍ਵੰ ਨਿਜੇਨ ਭਕ੍ਸ਼਼੍ਯਦ੍ਰਵ੍ਯੇਣ ਤੰ ਨ ਨਾਸ਼ਯ| ");
INSERT INTO sanpun_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","ਅਪਰੰ ਯੁਸ਼਼੍ਮਾਕਮ੍ ਉੱਤਮੰ ਕਰ੍ੰਮ ਨਿਨ੍ਦਿਤੰ ਨ ਭਵਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","ਭਕ੍ਸ਼਼੍ਯੰ ਪੇਯਞ੍ਚੇਸ਼੍ਵਰਰਾਜ੍ਯਸ੍ਯ ਸਾਰੋ ਨਹਿ, ਕਿਨ੍ਤੁ ਪੁਣ੍ਯੰ ਸ਼ਾਨ੍ਤਿਸ਼੍ਚ ਪਵਿਤ੍ਰੇਣਾਤ੍ਮਨਾ ਜਾਤ ਆਨਨ੍ਦਸ਼੍ਚ| ");
INSERT INTO sanpun_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","ਏਤੈ ਰ੍ਯੋ ਜਨਃ ਖ੍ਰੀਸ਼਼੍ਟੰ ਸੇਵਤੇ, ਸ ਏਵੇਸ਼੍ਵਰਸ੍ਯ ਤੁਸ਼਼੍ਟਿਕਰੋ ਮਨੁਸ਼਼੍ਯੈਸ਼੍ਚ ਸੁਖ੍ਯਾਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","ਅਤਏਵ ਯੇਨਾਸ੍ਮਾਕੰ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਪਰਸ੍ਪਰਮ੍ ਐਕ੍ਯੰ ਨਿਸ਼਼੍ਠਾ ਚ ਜਾਯਤੇ ਤਦੇਵਾਸ੍ਮਾਭਿ ਰ੍ਯਤਿਤਵ੍ਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","ਭਕ੍ਸ਼਼੍ਯਾਰ੍ਥਮ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਕਰ੍ੰਮਣੋ ਹਾਨਿੰ ਮਾ ਜਨਯਤ; ਸਰ੍ੱਵੰ ਵਸ੍ਤੁ ਪਵਿਤ੍ਰਮਿਤਿ ਸਤ੍ਯੰ ਤਥਾਪਿ ਯੋ ਜਨੋ ਯਦ੍ ਭੁਕ੍ਤ੍ਵਾ ਵਿਘ੍ਨੰ ਲਭਤੇ ਤਦਰ੍ਥੰ ਤਦ੍ ਭਦ੍ਰੰ ਨਹਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","ਤਵ ਮਾਂਸਭਕ੍ਸ਼਼ਣਸੁਰਾਪਾਨਾਦਿਭਿਃ ਕ੍ਰਿਯਾਭਿ ਰ੍ਯਦਿ ਤਵ ਭ੍ਰਾਤੁਃ ਪਾਦਸ੍ਖਲਨੰ ਵਿਘ੍ਨੋ ਵਾ ਚਾਞ੍ਚਲ੍ਯੰ ਵਾ ਜਾਯਤੇ ਤਰ੍ਹਿ ਤਦ੍ਭੋਜਨਪਾਨਯੋਸ੍ਤ੍ਯਾਗੋ ਭਦ੍ਰਃ| ");
INSERT INTO sanpun_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","ਯਦਿ ਤਵ ਪ੍ਰਤ੍ਯਯਸ੍ਤਿਸ਼਼੍ਠਤਿ ਤਰ੍ਹੀਸ਼੍ਵਰਸ੍ਯ ਗੋਚਰੇ ਸ੍ਵਾਨ੍ਤਰੇ ਤੰ ਗੋਪਯ; ਯੋ ਜਨਃ ਸ੍ਵਮਤੇਨ ਸ੍ਵੰ ਦੋਸ਼਼ਿਣੰ ਨ ਕਰੋਤਿ ਸ ਏਵ ਧਨ੍ਯਃ| ");
INSERT INTO sanpun_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","ਕਿਨ੍ਤੁ ਯਃ ਕਸ਼੍ਚਿਤ੍ ਸੰਸ਼ੱਯ ਭੁਙ੍ਕ੍ਤੇ(ਅ)ਰ੍ਥਾਤ੍ ਨ ਪ੍ਰਤੀਤ੍ਯ ਭੁਙ੍ਕ੍ਤੇ, ਸ ਏਵਾਵਸ਼੍ਯੰ ਦਣ੍ਡਾਰ੍ਹੋ ਭਵਿਸ਼਼੍ਯਤਿ, ਯਤੋ ਯਤ੍ ਪ੍ਰਤ੍ਯਯਜੰ ਨਹਿ ਤਦੇਵ ਪਾਪਮਯੰ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","ਬਲਵਦ੍ਭਿਰਸ੍ਮਾਭਿ ਰ੍ਦੁਰ੍ੱਬਲਾਨਾਂ ਦੌਰ੍ੱਬਲ੍ਯੰ ਸੋਢਵ੍ਯੰ ਨ ਚ ਸ੍ਵੇਸ਼਼ਾਮ੍ ਇਸ਼਼੍ਟਾਚਾਰ ਆਚਰਿਤਵ੍ਯਃ| ");
INSERT INTO sanpun_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","ਅਸ੍ਮਾਕਮ੍ ਏਕੈਕੋ ਜਨਃ ਸ੍ਵਸਮੀਪਵਾਸਿਨੋ ਹਿਤਾਰ੍ਥੰ ਨਿਸ਼਼੍ਠਾਰ੍ਥਞ੍ਚ ਤਸ੍ਯੈਵੇਸ਼਼੍ਟਾਚਾਰਮ੍ ਆਚਰਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","ਯਤਃ ਖ੍ਰੀਸ਼਼੍ਟੋ(ਅ)ਪਿ ਨਿਜੇਸ਼਼੍ਟਾਚਾਰੰ ਨਾਚਰਿਤਵਾਨ੍, ਯਥਾ ਲਿਖਿਤਮ੍ ਆਸ੍ਤੇ, ਤ੍ਵੰਨਿਨ੍ਦਕਗਣਸ੍ਯੈਵ ਨਿਨ੍ਦਾਭਿ ਰ੍ਨਿਨ੍ਦਿਤੋ(ਅ)ਸ੍ਮ੍ਯਹੰ| ");
INSERT INTO sanpun_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","ਅਪਰਞ੍ਚ ਵਯੰ ਯਤ੍ ਸਹਿਸ਼਼੍ਣੁਤਾਸਾਨ੍ਤ੍ਵਨਯੋ ਰ੍ਜਨਕੇਨ ਸ਼ਾਸ੍ਤ੍ਰੇਣ ਪ੍ਰਤ੍ਯਾਸ਼ਾਂ ਲਭੇਮਹਿ ਤੰਨਿਮਿੱਤੰ ਪੂਰ੍ੱਵਕਾਲੇ ਲਿਖਿਤਾਨਿ ਸਰ੍ੱਵਵਚਨਾਨ੍ਯਸ੍ਮਾਕਮ੍ ਉਪਦੇਸ਼ਾਰ੍ਥਮੇਵ ਲਿਲਿਖਿਰੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","ਸਹਿਸ਼਼੍ਣੁਤਾਸਾਨ੍ਤ੍ਵਨਯੋਰਾਕਰੋ ਯ ਈਸ਼੍ਵਰਃ ਸ ਏਵੰ ਕਰੋਤੁ ਯਤ੍ ਪ੍ਰਭੁ ਰ੍ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟ ਇਵ ਯੁਸ਼਼੍ਮਾਕਮ੍ ਏਕਜਨੋ(ਅ)ਨ੍ਯਜਨੇਨ ਸਾਰ੍ੱਧੰ ਮਨਸ ਐਕ੍ਯਮ੍ ਆਚਰੇਤ੍; ");
INSERT INTO sanpun_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","ਯੂਯਞ੍ਚ ਸਰ੍ੱਵ ਏਕਚਿੱਤਾ ਭੂਤ੍ਵਾ ਮੁਖੈਕੇਨੇਵਾਸ੍ਮਤ੍ਪ੍ਰਭੁਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਪਿਤੁਰੀਸ਼੍ਵਰਸ੍ਯ ਗੁਣਾਨ੍ ਕੀਰ੍ੱਤਯੇਤ| ");
INSERT INTO sanpun_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","ਅਪਰਮ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਮਹਿਮ੍ਨਃ ਪ੍ਰਕਾਸ਼ਾਰ੍ਥੰ ਖ੍ਰੀਸ਼਼੍ਟੋ ਯਥਾ ਯੁਸ਼਼੍ਮਾਨ੍ ਪ੍ਰਤ੍ਯਗ੍ਰੁʼਹ੍ਲਾਤ੍ ਤਥਾ ਯੁਸ਼਼੍ਮਾਕਮਪ੍ਯੇਕੋ ਜਨੋ(ਅ)ਨ੍ਯਜਨੰ ਪ੍ਰਤਿਗ੍ਰੁʼਹ੍ਲਾਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","ਯਥਾ ਲਿਖਿਤਮ੍ ਆਸ੍ਤੇ, ਅਤੋ(ਅ)ਹੰ ਸੰਮੁਖੇ ਤਿਸ਼਼੍ਠਨ੍ ਭਿੰਨਦੇਸ਼ਨਿਵਾਸਿਨਾਂ| ਸ੍ਤੁਵੰਸ੍ਤ੍ਵਾਂ ਪਰਿਗਾਸ੍ਯਾਮਿ ਤਵ ਨਾਮ੍ਨਿ ਪਰੇਸ਼੍ਵਰ|| ");
INSERT INTO sanpun_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","ਤਸ੍ਯ ਦਯਾਲੁਤ੍ਵਾੱਚ ਭਿੰਨਜਾਤੀਯਾ ਯਦ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਗੁਣਾਨ੍ ਕੀਰ੍ੱਤਯੇਯੁਸ੍ਤਦਰ੍ਥੰ ਯੀਸ਼ੁਃ ਖ੍ਰੀਸ਼਼੍ਟਸ੍ਤ੍ਵਕ੍ਛੇਦਨਿਯਮਸ੍ਯ ਨਿਘ੍ਨੋ(ਅ)ਭਵਦ੍ ਇਤ੍ਯਹੰ ਵਦਾਮਿ| ਯਥਾ ਲਿਖਿਤਮ੍ ਆਸ੍ਤੇ, ਅਤੋ(ਅ)ਹੰ ਸੰਮੁਖੇ ਤਿਸ਼਼੍ਠਨ੍ ਭਿੰਨਦੇਸ਼ਨਿਵਾਸਿਨਾਂ| ਸ੍ਤੁਵੰਸ੍ਤ੍ਵਾਂ ਪਰਿਗਾਸ੍ਯਾਮਿ ਤਵ ਨਾਮ੍ਨਿ ਪਰੇਸ਼੍ਵਰ|| ");
INSERT INTO sanpun_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","ਅਪਰਮਪਿ ਲਿਖਿਤਮ੍ ਆਸ੍ਤੇ, ਹੇ ਅਨ੍ਯਜਾਤਯੋ ਯੂਯੰ ਸਮੰ ਨਨ੍ਦਤ ਤੱਜਨੈਃ| ");
INSERT INTO sanpun_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","ਪੁਨਸ਼੍ਚ ਲਿਖਿਤਮ੍ ਆਸ੍ਤੇ, ਹੇ ਸਰ੍ੱਵਦੇਸ਼ਿਨੋ ਯੂਯੰ ਧਨ੍ਯੰ ਬ੍ਰੂਤ ਪਰੇਸ਼੍ਵਰੰ| ਹੇ ਤਦੀਯਨਰਾ ਯੂਯੰ ਕੁਰੁਧ੍ਵੰ ਤਤ੍ਪ੍ਰਸ਼ੰਸਨੰ|| ");
INSERT INTO sanpun_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","ਅਪਰ ਯੀਸ਼ਾਯਿਯੋ(ਅ)ਪਿ ਲਿਲੇਖ, ਯੀਸ਼ਯਸ੍ਯ ਤੁ ਯਤ੍ ਮੂਲੰ ਤਤ੍ ਪ੍ਰਕਾਸ਼ਿਸ਼਼੍ਯਤੇ ਤਦਾ| ਸਰ੍ੱਵਜਾਤੀਯਨ੍ਰੁʼਣਾਞ੍ਚ ਸ਼ਾਸਕਃ ਸਮੁਦੇਸ਼਼੍ਯਤਿ| ਤਤ੍ਰਾਨ੍ਯਦੇਸ਼ਿਲੋਕੈਸ਼੍ਚ ਪ੍ਰਤ੍ਯਾਸ਼ਾ ਪ੍ਰਕਰਿਸ਼਼੍ਯਤੇ|| ");
INSERT INTO sanpun_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","ਅਤਏਵ ਯੂਯੰ ਪਵਿਤ੍ਰਸ੍ਯਾਤ੍ਮਨਃ ਪ੍ਰਭਾਵਾਦ੍ ਯਤ੍ ਸਮ੍ਪੂਰ੍ਣਾਂ ਪ੍ਰਤ੍ਯਾਸ਼ਾਂ ਲਪ੍ਸ੍ਯਧ੍ਵੇ ਤਦਰ੍ਥੰ ਤਤ੍ਪ੍ਰਤ੍ਯਾਸ਼ਾਜਨਕ ਈਸ਼੍ਵਰਃ ਪ੍ਰਤ੍ਯਯੇਨ ਯੁਸ਼਼੍ਮਾਨ੍ ਸ਼ਾਨ੍ਤ੍ਯਾਨਨ੍ਦਾਭ੍ਯਾਂ ਸਮ੍ਪੂਰ੍ਣਾਨ੍ ਕਰੋਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","ਹੇ ਭ੍ਰਾਤਰੋ ਯੂਯੰ ਸਦ੍ਭਾਵਯੁਕ੍ਤਾਃ ਸਰ੍ੱਵਪ੍ਰਕਾਰੇਣ ਜ੍ਞਾਨੇਨ ਚ ਸਮ੍ਪੂਰ੍ਣਾਃ ਪਰਸ੍ਪਰੋਪਦੇਸ਼ੇ ਚ ਤਤ੍ਪਰਾ ਇਤ੍ਯਹੰ ਨਿਸ਼੍ਚਿਤੰ ਜਾਨਾਮਿ, ");
INSERT INTO sanpun_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","ਤਥਾਪ੍ਯਹੰ ਯਤ੍ ਪ੍ਰਗਲ੍ਭਤਰੋ ਭਵਨ੍ ਯੁਸ਼਼੍ਮਾਨ੍ ਪ੍ਰਬੋਧਯਾਮਿ ਤਸ੍ਯੈਕੰ ਕਾਰਣਮਿਦੰ| ");
INSERT INTO sanpun_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","ਭਿੰਨਜਾਤੀਯਾਃ ਪਵਿਤ੍ਰੇਣਾਤ੍ਮਨਾ ਪਾਵਿਤਨੈਵੇਦ੍ਯਰੂਪਾ ਭੂਤ੍ਵਾ ਯਦ੍ ਗ੍ਰਾਹ੍ਯਾ ਭਵੇਯੁਸ੍ਤੰਨਿਮਿੱਤਮਹਮ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਸੁਸੰਵਾਦੰ ਪ੍ਰਚਾਰਯਿਤੁੰ ਭਿੰਨਜਾਤੀਯਾਨਾਂ ਮਧ੍ਯੇ ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਸੇਵਕਤ੍ਵੰ ਦਾਨੰ ਈਸ਼੍ਵਰਾਤ੍ ਲਬ੍ਧਵਾਨਸ੍ਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","ਈਸ਼੍ਵਰੰ ਪ੍ਰਤਿ ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟੇਨ ਮਮ ਸ਼੍ਲਾਘਾਕਰਣਸ੍ਯ ਕਾਰਣਮ੍ ਆਸ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","ਭਿੰਨਦੇਸ਼ਿਨ ਆਜ੍ਞਾਗ੍ਰਾਹਿਣਃ ਕਰ੍ੱਤੁੰ ਖ੍ਰੀਸ਼਼੍ਟੋ ਵਾਕ੍ਯੇਨ ਕ੍ਰਿਯਯਾ ਚ, ਆਸ਼੍ਚਰ੍ੱਯਲਕ੍ਸ਼਼ਣੈਸ਼੍ਚਿਤ੍ਰਕ੍ਰਿਯਾਭਿਃ ਪਵਿਤ੍ਰਸ੍ਯਾਤ੍ਮਨਃ ਪ੍ਰਭਾਵੇਨ ਚ ਯਾਨਿ ਕਰ੍ੰਮਾਣਿ ਮਯਾ ਸਾਧਿਤਵਾਨ੍, ");
INSERT INTO sanpun_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","ਕੇਵਲੰ ਤਾਨ੍ਯੇਵ ਵਿਨਾਨ੍ਯਸ੍ਯ ਕਸ੍ਯਚਿਤ੍ ਕਰ੍ੰਮਣੋ ਵਰ੍ਣਨਾਂ ਕਰ੍ੱਤੁੰ ਪ੍ਰਗਲ੍ਭੋ ਨ ਭਵਾਮਿ| ਤਸ੍ਮਾਤ੍ ਆ ਯਿਰੂਸ਼ਾਲਮ ਇੱਲੂਰਿਕੰ ਯਾਵਤ੍ ਸਰ੍ੱਵਤ੍ਰ ਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਸੁਸੰਵਾਦੰ ਪ੍ਰਾਚਾਰਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","ਅਨ੍ਯੇਨ ਨਿਚਿਤਾਯਾਂ ਭਿੱਤਾਵਹੰ ਯੰਨ ਨਿਚਿਨੋਮਿ ਤੰਨਿਮਿੱਤੰ ਯਤ੍ਰ ਯਤ੍ਰ ਸ੍ਥਾਨੇ ਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਨਾਮ ਕਦਾਪਿ ਕੇਨਾਪਿ ਨ ਜ੍ਞਾਪਿਤੰ ਤਤ੍ਰ ਤਤ੍ਰ ਸੁਸੰਵਾਦੰ ਪ੍ਰਚਾਰਯਿਤੁਮ੍ ਅਹੰ ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","ਯਾਦ੍ਰੁʼਸ਼ੰ ਲਿਖਿਤਮ੍ ਆਸ੍ਤੇ, ਯੈ ਰ੍ਵਾਰ੍ੱਤਾ ਤਸ੍ਯ ਨ ਪ੍ਰਾਪ੍ਤਾ ਦਰ੍ਸ਼ਨੰ ਤੈਸ੍ਤੁ ਲਪ੍ਸ੍ਯਤੇ| ਯੈਸ਼੍ਚ ਨੈਵ ਸ਼੍ਰੁਤੰ ਕਿਞ੍ਚਿਤ੍ ਬੋੱਧੁੰ ਸ਼ਕ੍ਸ਼਼੍ਯਨ੍ਤਿ ਤੇ ਜਨਾਃ|| ");
INSERT INTO sanpun_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","ਤਸ੍ਮਾਦ੍ ਯੁਸ਼਼੍ਮਤ੍ਸਮੀਪਗਮਨਾਦ੍ ਅਹੰ ਮੁਹੁਰ੍ਮੁਹੁ ਰ੍ਨਿਵਾਰਿਤੋ(ਅ)ਭਵੰ| ");
INSERT INTO sanpun_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","ਕਿਨ੍ਤ੍ਵਿਦਾਨੀਮ੍ ਅਤ੍ਰ ਪ੍ਰਦੇਸ਼ੇਸ਼਼ੁ ਮਯਾ ਨ ਗਤੰ ਸ੍ਥਾਨੰ ਕਿਮਪਿ ਨਾਵਸ਼ਿਸ਼਼੍ਯਤੇ ਯੁਸ਼਼੍ਮਤ੍ਸਮੀਪੰ ਗਨ੍ਤੁੰ ਬਹੁਵਤ੍ਸਰਾਨਾਰਭ੍ਯ ਮਾਮਕੀਨਾਕਾਙ੍ਕ੍ਸ਼਼ਾ ਚ ਵਿਦ੍ਯਤ ਇਤਿ ਹੇਤੋਃ ");
INSERT INTO sanpun_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","ਸ੍ਪਾਨਿਯਾਦੇਸ਼ਗਮਨਕਾਲੇ(ਅ)ਹੰ ਯੁਸ਼਼੍ਮਨ੍ਮਧ੍ਯੇਨ ਗੱਛਨ੍ ਯੁਸ਼਼੍ਮਾਨ੍ ਆਲੋਕਿਸ਼਼੍ਯੇ, ਤਤਃ ਪਰੰ ਯੁਸ਼਼੍ਮਤ੍ਸਮ੍ਭਾਸ਼਼ਣੇਨ ਤ੍ਰੁʼਪ੍ਤਿੰ ਪਰਿਲਭ੍ਯ ਤੱਦੇਸ਼ਗਮਨਾਰ੍ਥੰ ਯੁਸ਼਼੍ਮਾਭਿ ਰ੍ਵਿਸਰ੍ਜਯਿਸ਼਼੍ਯੇ, ਈਦ੍ਰੁʼਸ਼ੀ ਮਦੀਯਾ ਪ੍ਰਤ੍ਯਾਸ਼ਾ ਵਿਦ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","ਕਿਨ੍ਤੁ ਸਾਮ੍ਪ੍ਰਤੰ ਪਵਿਤ੍ਰਲੋਕਾਨਾਂ ਸੇਵਨਾਯ ਯਿਰੂਸ਼ਾਲਮ੍ਨਗਰੰ ਵ੍ਰਜਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","ਯਤੋ ਯਿਰੂਸ਼ਾਲਮਸ੍ਥਪਵਿਤ੍ਰਲੋਕਾਨਾਂ ਮਧ੍ਯੇ ਯੇ ਦਰਿਦ੍ਰਾ ਅਰ੍ਥਵਿਸ਼੍ਰਾਣਨੇਨ ਤਾਨੁਪਕਰ੍ੱਤੁੰ ਮਾਕਿਦਨਿਯਾਦੇਸ਼ੀਯਾ ਆਖਾਯਾਦੇਸ਼ੀਯਾਸ਼੍ਚ ਲੋਕਾ ਐੱਛਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","ਏਸ਼਼ਾ ਤੇਸ਼਼ਾਂ ਸਦਿੱਛਾ ਯਤਸ੍ਤੇ ਤੇਸ਼਼ਾਮ੍ ਰੁʼਣਿਨਃ ਸਨ੍ਤਿ ਯਤੋ ਹੇਤੋ ਰ੍ਭਿੰਨਜਾਤੀਯਾ ਯੇਸ਼਼ਾਂ ਪਰਮਾਰ੍ਥਸ੍ਯਾਂਸ਼ਿਨੋ ਜਾਤਾ ਐਹਿਕਵਿਸ਼਼ਯੇ ਤੇਸ਼਼ਾਮੁਪਕਾਰਸ੍ਤੈਃ ਕਰ੍ੱਤਵ੍ਯਃ| ");
INSERT INTO sanpun_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","ਅਤੋ ਮਯਾ ਤਤ੍ ਕਰ੍ੰਮ ਸਾਧਯਿਤ੍ਵਾ ਤਸ੍ਮਿਨ੍ ਫਲੇ ਤੇਭ੍ਯਃ ਸਮਰ੍ਪਿਤੇ ਯੁਸ਼਼੍ਮਨ੍ਮਧ੍ਯੇਨ ਸ੍ਪਾਨਿਯਾਦੇਸ਼ੋ ਗਮਿਸ਼਼੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","ਯੁਸ਼਼੍ਮਤ੍ਸਮੀਪੇ ਮਮਾਗਮਨਸਮਯੇ ਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਸੁਸੰਵਾਦਸ੍ਯ ਪੂਰ੍ਣਵਰੇਣ ਸਮ੍ਬਲਿਤਃ ਸਨ੍ ਅਹਮ੍ ਆਗਮਿਸ਼਼੍ਯਾਮਿ ਇਤਿ ਮਯਾ ਜ੍ਞਾਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","ਹੇ ਭ੍ਰਾਤ੍ਰੁʼਗਣ ਪ੍ਰਭੋ ਰ੍ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਨਾਮ੍ਨਾ ਪਵਿਤ੍ਰਸ੍ਯਾਤ੍ਮਾਨਃ ਪ੍ਰੇਮ੍ਨਾ ਚ ਵਿਨਯੇ(ਅ)ਹੰ ");
INSERT INTO sanpun_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","ਯਿਹੂਦਾਦੇਸ਼ਸ੍ਥਾਨਾਮ੍ ਅਵਿਸ਼੍ਵਾਸਿਲੋਕਾਨਾਂ ਕਰੇਭ੍ਯੋ ਯਦਹੰ ਰਕ੍ਸ਼਼ਾਂ ਲਭੇਯ ਮਦੀਯੈਤੇਨ ਸੇਵਨਕਰ੍ੰਮਣਾ ਚ ਯਦ੍ ਯਿਰੂਸ਼ਾਲਮਸ੍ਥਾਃ ਪਵਿਤ੍ਰਲੋਕਾਸ੍ਤੁਸ਼਼੍ਯੇਯੁਃ, ");
INSERT INTO sanpun_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","ਤਦਰ੍ਥੰ ਯੂਯੰ ਮਤ੍ਕ੍ਰੁʼਤ ਈਸ਼੍ਵਰਾਯ ਪ੍ਰਾਰ੍ਥਯਮਾਣਾ ਯਤਧ੍ਵੰ ਤੇਨਾਹਮ੍ ਈਸ਼੍ਵਰੇੱਛਯਾ ਸਾਨਨ੍ਦੰ ਯੁਸ਼਼੍ਮਤ੍ਸਮੀਪੰ ਗਤ੍ਵਾ ਯੁਸ਼਼੍ਮਾਭਿਃ ਸਹਿਤਃ ਪ੍ਰਾਣਾਨ੍ ਆਪ੍ਯਾਯਿਤੁੰ ਪਾਰਯਿਸ਼਼੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","ਸ਼ਾਨ੍ਤਿਦਾਯਕ ਈਸ਼੍ਵਰੋ ਯੁਸ਼਼੍ਮਾਕੰ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਸਙ੍ਗੀ ਭੂਯਾਤ੍| ਇਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","ਕਿੰਕ੍ਰੀਯਾਨਗਰੀਯਧਰ੍ੰਮਸਮਾਜਸ੍ਯ ਪਰਿਚਾਰਿਕਾ ਯਾ ਫੈਬੀਨਾਮਿਕਾਸ੍ਮਾਕੰ ਧਰ੍ੰਮਭਗਿਨੀ ਤਸ੍ਯਾਃ ਕ੍ਰੁʼਤੇ(ਅ)ਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਨਿਵੇਦਯਾਮਿ, ");
INSERT INTO sanpun_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","ਯੂਯੰ ਤਾਂ ਪ੍ਰਭੁਮਾਸ਼੍ਰਿਤਾਂ ਵਿਜ੍ਞਾਯ ਤਸ੍ਯਾ ਆਤਿਥ੍ਯੰ ਪਵਿਤ੍ਰਲੋਕਾਰ੍ਹੰ ਕੁਰੁਧ੍ਵੰ, ਯੁਸ਼਼੍ਮੱਤਸ੍ਤਸ੍ਯਾ ਯ ਉਪਕਾਰੋ ਭਵਿਤੁੰ ਸ਼ਕ੍ਨੋਤਿ ਤੰ ਕੁਰੁਧ੍ਵੰ, ਯਸ੍ਮਾਤ੍ ਤਯਾ ਬਹੂਨਾਂ ਮਮ ਚੋਪਕਾਰਃ ਕ੍ਰੁʼਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","ਅਪਰਞ੍ਚ ਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਯੀਸ਼ੋਃ ਕਰ੍ੰਮਣਿ ਮਮ ਸਹਕਾਰਿਣੌ ਮਮ ਪ੍ਰਾਣਰਕ੍ਸ਼਼ਾਰ੍ਥਞ੍ਚ ਸ੍ਵਪ੍ਰਾਣਾਨ੍ ਪਣੀਕ੍ਰੁʼਤਵਨ੍ਤੌ ਯੌ ਪ੍ਰਿਸ਼਼੍ਕਿੱਲਾੱਕਿਲੌ ਤੌ ਮਮ ਨਮਸ੍ਕਾਰੰ ਜ੍ਞਾਪਯਧ੍ਵੰ| ");
INSERT INTO sanpun_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","ਤਾਭ੍ਯਾਮ੍ ਉਪਕਾਰਾਪ੍ਤਿਃ ਕੇਵਲੰ ਮਯਾ ਸ੍ਵੀਕਰ੍ੱਤਵ੍ਯੇਤਿ ਨਹਿ ਭਿੰਨਦੇਸ਼ੀਯੈਃ ਸਰ੍ੱਵਧਰ੍ੰਮਸਮਾਜੈਰਪਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","ਅਪਰਞ੍ਚ ਤਯੋ ਰ੍ਗ੍ਰੁʼਹੇ ਸ੍ਥਿਤਾਨ੍ ਧਰ੍ੰਮਸਮਾਜਲੋਕਾਨ੍ ਮਮ ਨਮਸ੍ਕਾਰੰ ਜ੍ਞਾਪਯਧ੍ਵੰ| ਤਦ੍ਵਤ੍ ਆਸ਼ਿਯਾਦੇਸ਼ੇ ਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਪਕ੍ਸ਼਼ੇ ਪ੍ਰਥਮਜਾਤਫਲਸ੍ਵਰੂਪੋ ਯ ਇਪੇਨਿਤਨਾਮਾ ਮਮ ਪ੍ਰਿਯਬਨ੍ਧੁਸ੍ਤਮਪਿ ਮਮ ਨਮਸ੍ਕਾਰੰ ਜ੍ਞਾਪਯਧ੍ਵੰ| ");
INSERT INTO sanpun_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","ਅਪਰੰ ਬਹੁਸ਼੍ਰਮੇਣਾਸ੍ਮਾਨ੍ ਅਸੇਵਤ ਯਾ ਮਰਿਯਮ੍ ਤਾਮਪਿ ਨਮਸ੍ਕਾਰੰ ਜ੍ਞਾਪਯਧ੍ਵੰ| ");
INSERT INTO sanpun_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","ਅਪਰਞ੍ਚ ਪ੍ਰੇਰਿਤੇਸ਼਼ੁ ਖ੍ਯਾਤਕੀਰ੍ੱਤੀ ਮਦਗ੍ਰੇ ਖ੍ਰੀਸ਼਼੍ਟਾਸ਼੍ਰਿਤੌ ਮਮ ਸ੍ਵਜਾਤੀਯੌ ਸਹਬਨ੍ਦਿਨੌ ਚ ਯਾਵਾਨ੍ਦ੍ਰਨੀਕਯੂਨਿਯੌ ਤੌ ਮਮ ਨਮਸ੍ਕਾਰੰ ਜ੍ਞਾਪਯਧ੍ਵੰ| ");
INSERT INTO sanpun_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","ਤਥਾ ਪ੍ਰਭੌ ਮਤ੍ਪ੍ਰਿਯਤਮਮ੍ ਆਮ੍ਪ੍ਲਿਯਮਪਿ ਮਮ ਨਮਸ੍ਕਾਰੰ ਜ੍ਞਾਪਯਧ੍ਵੰ| ");
INSERT INTO sanpun_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","ਅਪਰੰ ਖ੍ਰੀਸ਼਼੍ਟਸੇਵਾਯਾਂ ਮਮ ਸਹਕਾਰਿਣਮ੍ ਊਰ੍ੱਬਾਣੰ ਮਮ ਪ੍ਰਿਯਤਮੰ ਸ੍ਤਾਖੁਞ੍ਚ ਮਮ ਨਮਸ੍ਕਾਰੰ ਜ੍ਞਾਪਯਧ੍ਵੰ| ");
INSERT INTO sanpun_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","ਅਪਰੰ ਖ੍ਰੀਸ਼਼੍ਟੇਨ ਪਰੀਕ੍ਸ਼਼ਿਤਮ੍ ਆਪਿੱਲਿੰ ਮਮ ਨਮਸ੍ਕਾਰੰ ਵਦਤ, ਆਰਿਸ਼਼੍ਟਬੂਲਸ੍ਯ ਪਰਿਜਨਾਂਸ਼੍ਚ ਮਮ ਨਮਸ੍ਕਾਰੰ ਜ੍ਞਾਪਯਧ੍ਵੰ| ");
INSERT INTO sanpun_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","ਅਪਰੰ ਮਮ ਜ੍ਞਾਤਿੰ ਹੇਰੋਦਿਯੋਨੰ ਮਮ ਨਮਸ੍ਕਾਰੰ ਵਦਤ, ਤਥਾ ਨਾਰ੍ਕਿਸਸ੍ਯ ਪਰਿਵਾਰਾਣਾਂ ਮਧ੍ਯੇ ਯੇ ਪ੍ਰਭੁਮਾਸ਼੍ਰਿਤਾਸ੍ਤਾਨ੍ ਮਮ ਨਮਸ੍ਕਾਰੰ ਵਦਤ| ");
INSERT INTO sanpun_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","ਅਪਰੰ ਪ੍ਰਭੋਃ ਸੇਵਾਯਾਂ ਪਰਿਸ਼੍ਰਮਕਾਰਿਣ੍ਯੌ ਤ੍ਰੁਫੇਨਾਤ੍ਰੁਫੋਸ਼਼ੇ ਮਮ ਨਮਸ੍ਕਾਰੰ ਵਦਤ, ਤਥਾ ਪ੍ਰਭੋਃ ਸੇਵਾਯਾਮ੍ ਅਤ੍ਯਨ੍ਤੰ ਪਰਿਸ਼੍ਰਮਕਾਰਿਣੀ ਯਾ ਪ੍ਰਿਯਾ ਪਰ੍ਸ਼਼ਿਸ੍ਤਾਂ ਨਮਸ੍ਕਾਰੰ ਜ੍ਞਾਪਯਧ੍ਵੰ| ");
INSERT INTO sanpun_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","ਅਪਰੰ ਪ੍ਰਭੋਰਭਿਰੁਚਿਤੰ ਰੂਫੰ ਮਮ ਧਰ੍ੰਮਮਾਤਾ ਯਾ ਤਸ੍ਯ ਮਾਤਾ ਤਾਮਪਿ ਨਮਸ੍ਕਾਰੰ ਵਦਤ| ");
INSERT INTO sanpun_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","ਅਪਰਮ੍ ਅਸੁੰਕ੍ਰੁʼਤੰ ਫ੍ਲਿਗੋਨੰ ਹਰ੍ੰਮੰ ਪਾਤ੍ਰਬੰ ਹਰ੍ੰਮਿਮ੍ ਏਤੇਸ਼਼ਾਂ ਸਙ੍ਗਿਭ੍ਰਾਤ੍ਰੁʼਗਣਞ੍ਚ ਨਮਸ੍ਕਾਰੰ ਜ੍ਞਾਪਯਧ੍ਵੰ| ");
INSERT INTO sanpun_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","ਅਪਰੰ ਫਿਲਲਗੋ ਯੂਲਿਯਾ ਨੀਰਿਯਸ੍ਤਸ੍ਯ ਭਗਿਨ੍ਯਲੁਮ੍ਪਾ ਚੈਤਾਨ੍ ਏਤੈਃ ਸਾਰ੍ੱਧੰ ਯਾਵਨ੍ਤਃ ਪਵਿਤ੍ਰਲੋਕਾ ਆਸਤੇ ਤਾਨਪਿ ਨਮਸ੍ਕਾਰੰ ਜ੍ਞਾਪਯਧ੍ਵੰ| ");
INSERT INTO sanpun_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","ਯੂਯੰ ਪਰਸ੍ਪਰੰ ਪਵਿਤ੍ਰਚੁਮ੍ਬਨੇਨ ਨਮਸ੍ਕੁਰੁਧ੍ਵੰ| ਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਧਰ੍ੰਮਸਮਾਜਗਣੋ ਯੁਸ਼਼੍ਮਾਨ੍ ਨਮਸ੍ਕੁਰੁਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","ਹੇ ਭ੍ਰਾਤਰੋ ਯੁਸ਼਼੍ਮਾਨ੍ ਵਿਨਯੇ(ਅ)ਹੰ ਯੁਸ਼਼੍ਮਾਭਿ ਰ੍ਯਾ ਸ਼ਿਕ੍ਸ਼਼ਾ ਲਬ੍ਧਾ ਤਾਮ੍ ਅਤਿਕ੍ਰਮ੍ਯ ਯੇ ਵਿੱਛੇਦਾਨ੍ ਵਿਘ੍ਨਾਂਸ਼੍ਚ ਕੁਰ੍ੱਵਨ੍ਤਿ ਤਾਨ੍ ਨਿਸ਼੍ਚਿਨੁਤ ਤੇਸ਼਼ਾਂ ਸਙ੍ਗੰ ਵਰ੍ਜਯਤ ਚ| ");
INSERT INTO sanpun_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","ਯਤਸ੍ਤਾਦ੍ਰੁʼਸ਼ਾ ਲੋਕਾ ਅਸ੍ਮਾਕੰ ਪ੍ਰਭੋ ਰ੍ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਦਾਸਾ ਇਤਿ ਨਹਿ ਕਿਨ੍ਤੁ ਸ੍ਵੋਦਰਸ੍ਯੈਵ ਦਾਸਾਃ; ਅਪਰੰ ਪ੍ਰਣਯਵਚਨੈ ਰ੍ਮਧੁਰਵਾਕ੍ਯੈਸ਼੍ਚ ਸਰਲਲੋਕਾਨਾਂ ਮਨਾਂਸਿ ਮੋਹਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","ਯੁਸ਼਼੍ਮਾਕਮ੍ ਆਜ੍ਞਾਗ੍ਰਾਹਿਤ੍ਵੰ ਸਰ੍ੱਵਤ੍ਰ ਸਰ੍ੱਵੈ ਰ੍ਜ੍ਞਾਤੰ ਤਤੋ(ਅ)ਹੰ ਯੁਸ਼਼੍ਮਾਸੁ ਸਾਨਨ੍ਦੋ(ਅ)ਭਵੰ ਤਥਾਪਿ ਯੂਯੰ ਯਤ੍ ਸਤ੍ਜ੍ਞਾਨੇਨ ਜ੍ਞਾਨਿਨਃ ਕੁਜ੍ਞਾਨੇे ਚਾਤਤ੍ਪਰਾ ਭਵੇਤੇਤਿ ਮਮਾਭਿਲਾਸ਼਼ਃ| ");
INSERT INTO sanpun_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","ਅਧਿਕਨ੍ਤੁ ਸ਼ਾਨ੍ਤਿਦਾਯਕ ਈਸ਼੍ਵਰਃ ਸ਼ੈਤਾਨਮ੍ ਅਵਿਲਮ੍ਬੰ ਯੁਸ਼਼੍ਮਾਕੰ ਪਦਾਨਾਮ੍ ਅਧੋ ਮਰ੍ੱਦਿਸ਼਼੍ਯਤਿ| ਅਸ੍ਮਾਕੰ ਪ੍ਰਭੁ ਰ੍ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟੋ ਯੁਸ਼਼੍ਮਾਸੁ ਪ੍ਰਸਾਦੰ ਕ੍ਰਿਯਾਤ੍| ਇਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","ਮਮ ਸਹਕਾਰੀ ਤੀਮਥਿਯੋ ਮਮ ਜ੍ਞਾਤਯੋ ਲੂਕਿਯੋ ਯਾਸੋਨ੍ ਸੋਸਿਪਾਤ੍ਰਸ਼੍ਚੇਮੇ ਯੁਸ਼਼੍ਮਾਨ੍ ਨਮਸ੍ਕੁਰ੍ੱਵਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","ਅਪਰਮ੍ ਏਤਤ੍ਪਤ੍ਰਲੇਖਕਸ੍ਤਰ੍ੱਤਿਯਨਾਮਾਹਮਪਿ ਪ੍ਰਭੋ ਰ੍ਨਾਮ੍ਨਾ ਯੁਸ਼਼੍ਮਾਨ੍ ਨਮਸ੍ਕਰੋਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","ਤਥਾ ਕ੍ਰੁʼਤ੍ਸ੍ਨਧਰ੍ੰਮਸਮਾਜਸ੍ਯ ਮਮ ਚਾਤਿਥ੍ਯਕਾਰੀ ਗਾਯੋ ਯੁਸ਼਼੍ਮਾਨ੍ ਨਮਸ੍ਕਰੋਤਿ| ਅਪਰਮ੍ ਏਤੰਨਗਰਸ੍ਯ ਧਨਰਕ੍ਸ਼਼ਕ ਇਰਾਸ੍ਤਃ ੱਕਾਰ੍ੱਤਨਾਮਕਸ਼੍ਚੈਕੋ ਭ੍ਰਾਤਾ ਤਾਵਪਿ ਯੁਸ਼਼੍ਮਾਨ੍ ਨਮਸ੍ਕੁਰੁਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","ਅਸ੍ਮਾਕੰ ਪ੍ਰਭੁ ਰ੍ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟਾ ਯੁਸ਼਼੍ਮਾਸੁ ਸਰ੍ੱਵੇਸ਼਼ੁ ਪ੍ਰਸਾਦੰ ਕ੍ਰਿਯਾਤ੍| ਇਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","ਪੂਰ੍ੱਵਕਾਲਿਕਯੁਗੇਸ਼਼ੁ ਪ੍ਰੱਛੰਨਾ ਯਾ ਮਨ੍ਤ੍ਰਣਾਧੁਨਾ ਪ੍ਰਕਾਸ਼ਿਤਾ ਭੂਤ੍ਵਾ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾਦਿਲਿਖਿਤਗ੍ਰਨ੍ਥਗਣਸ੍ਯ ਪ੍ਰਮਾਣਾਦ੍ ਵਿਸ਼੍ਵਾਸੇਨ ਗ੍ਰਹਣਾਰ੍ਥੰ ਸਦਾਤਨਸ੍ਯੇਸ਼੍ਵਰਸ੍ਯਾਜ੍ਞਯਾ ਸਰ੍ੱਵਦੇਸ਼ੀਯਲੋਕਾਨ੍ ਜ੍ਞਾਪ੍ਯਤੇ, ");
INSERT INTO sanpun_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","ਤਸ੍ਯਾ ਮਨ੍ਤ੍ਰਣਾਯਾ ਜ੍ਞਾਨੰ ਲਬ੍ਧ੍ਵਾ ਮਯਾ ਯਃ ਸੁਸੰਵਾਦੋ ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟਮਧਿ ਪ੍ਰਚਾਰ੍ੱਯਤੇ, ਤਦਨੁਸਾਰਾਦ੍ ਯੁਸ਼਼੍ਮਾਨ੍ ਧਰ੍ੰਮੇ ਸੁਸ੍ਥਿਰਾਨ੍ ਕਰ੍ੱਤੁੰ ਸਮਰ੍ਥੋ ਯੋ(ਅ)ਦ੍ਵਿਤੀਯਃ ");
INSERT INTO sanpun_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","ਸਰ੍ੱਵਜ੍ਞ ਈਸ਼੍ਵਰਸ੍ਤਸ੍ਯ ਧਨ੍ਯਵਾਦੋ ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟੇਨ ਸਨ੍ਤਤੰ ਭੂਯਾਤ੍| ਇਤਿ|");
INSERT INTO sanpun_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","ਯਾਵਨ੍ਤਃ ਪਵਿਤ੍ਰਾ ਲੋਕਾਃ ਸ੍ਵੇਸ਼਼ਾਮ੍ ਅਸ੍ਮਾਕਞ੍ਚ ਵਸਤਿਸ੍ਥਾਨੇਸ਼਼੍ਵਸ੍ਮਾਕੰ ਪ੍ਰਭੋ ਰ੍ਯੀਸ਼ੋਃ ਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਨਾਮ੍ਨਾ ਪ੍ਰਾਰ੍ਥਯਨ੍ਤੇ ਤੈਃ ਸਹਾਹੂਤਾਨਾਂ ਖ੍ਰੀਸ਼਼੍ਟੇਨ ਯੀਸ਼ੁਨਾ ਪਵਿਤ੍ਰੀਕ੍ਰੁʼਤਾਨਾਂ ਲੋਕਾਨਾਂ ਯ ਈਸ਼੍ਵਰੀਯਧਰ੍ੰਮਸਮਾਜਃ ਕਰਿਨ੍ਥਨਗਰੇ ਵਿਦ੍ਯਤੇ ");
INSERT INTO sanpun_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","ਤੰ ਪ੍ਰਤੀਸ਼੍ਵਰਸ੍ਯੇੱਛਯਾਹੂਤੋ ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਪ੍ਰੇਰਿਤਃ ਪੌਲਃ ਸੋਸ੍ਥਿਨਿਨਾਮਾ ਭ੍ਰਾਤਾ ਚ ਪਤ੍ਰੰ ਲਿਖਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","ਅਸ੍ਮਾਕੰ ਪਿਤ੍ਰੇਸ਼੍ਵਰੇਣ ਪ੍ਰਭੁਨਾ ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟੇਨ ਚ ਪ੍ਰਸਾਦਃ ਸ਼ਾਨ੍ਤਿਸ਼੍ਚ ਯੁਸ਼਼੍ਮਭ੍ਯੰ ਦੀਯਤਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","ਈਸ਼੍ਵਰੋ ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟੇਨ ਯੁਸ਼਼੍ਮਾਨ੍ ਪ੍ਰਤਿ ਪ੍ਰਸਾਦੰ ਪ੍ਰਕਾਸ਼ਿਤਵਾਨ੍, ਤਸ੍ਮਾਦਹੰ ਯੁਸ਼਼੍ਮੰਨਿਮਿੱਤੰ ਸਰ੍ੱਵਦਾ ਮਦੀਯੇਸ਼੍ਵਰੰ ਧਨ੍ਯੰ ਵਦਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","ਖ੍ਰੀਸ਼਼੍ਟਸਮ੍ਬਨ੍ਧੀਯੰ ਸਾਕ੍ਸ਼਼੍ਯੰ ਯੁਸ਼਼੍ਮਾਕੰ ਮਧ੍ਯੇ ਯੇਨ ਪ੍ਰਕਾਰੇਣ ਸਪ੍ਰਮਾਣਮ੍ ਅਭਵਤ੍ ");
INSERT INTO sanpun_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","ਤੇਨ ਯੂਯੰ ਖ੍ਰੀਸ਼਼੍ਟਾਤ੍ ਸਰ੍ੱਵਵਿਧਵਕ੍ਤ੍ਰੁʼਤਾਜ੍ਞਾਨਾਦੀਨਿ ਸਰ੍ੱਵਧਨਾਨਿ ਲਬ੍ਧਵਨ੍ਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","ਤਤੋ(ਅ)ਸ੍ਮਤ੍ਪ੍ਰਭੋ ਰ੍ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਪੁਨਰਾਗਮਨੰ ਪ੍ਰਤੀਕ੍ਸ਼਼ਮਾਣਾਨਾਂ ਯੁਸ਼਼੍ਮਾਕੰ ਕਸ੍ਯਾਪਿ ਵਰਸ੍ਯਾਭਾਵੋ ਨ ਭਵਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","ਅਪਰਮ੍ ਅਸ੍ਮਾਕੰ ਪ੍ਰਭੋ ਰ੍ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਦਿਵਸੇ ਯੂਯੰ ਯੰਨਿਰ੍ੱਦੋਸ਼਼ਾ ਭਵੇਤ ਤਦਰ੍ਥੰ ਸਏਵ ਯਾਵਦਨ੍ਤੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਸੁਸ੍ਥਿਰਾਨ੍ ਕਰਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","ਯ ਈਸ਼੍ਵਰਃ ਸ੍ਵਪੁਤ੍ਰਸ੍ਯਾਸ੍ਮਤ੍ਪ੍ਰਭੋ ਰ੍ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯਾਂਸ਼ਿਨਃ ਕਰ੍ੱਤੁੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਆਹੂਤਵਾਨ੍ ਸ ਵਿਸ਼੍ਵਸਨੀਯਃ| ");
INSERT INTO sanpun_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","ਹੇ ਭ੍ਰਾਤਰਃ, ਅਸ੍ਮਾਕੰ ਪ੍ਰਭੁਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਨਾਮ੍ਨਾ ਯੁਸ਼਼੍ਮਾਨ੍ ਵਿਨਯੇ(ਅ)ਹੰ ਸਰ੍ੱਵੈ ਰ੍ਯੁਸ਼਼੍ਮਾਭਿਰੇਕਰੂਪਾਣਿ ਵਾਕ੍ਯਾਨਿ ਕਥ੍ਯਨ੍ਤਾਂ ਯੁਸ਼਼੍ਮਨ੍ਮਧ੍ਯੇ ਭਿੰਨਸਙ੍ਘਾਤਾ ਨ ਭਵਨ੍ਤੁ ਮਨੋਵਿਚਾਰਯੋਰੈਕ੍ਯੇਨ ਯੁਸ਼਼੍ਮਾਕੰ ਸਿੱਧਤ੍ਵੰ ਭਵਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","ਹੇ ਮਮ ਭ੍ਰਾਤਰੋ ਯੁਸ਼਼੍ਮਨ੍ਮਧ੍ਯੇ ਵਿਵਾਦਾ ਜਾਤਾ ਇਤਿ ਵਾਰ੍ੱਤਾਮਹੰ ਕ੍ਲੋੱਯਾਃ ਪਰਿਜਨੈ ਰ੍ਜ੍ਞਾਪਿਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","ਮਮਾਭਿਪ੍ਰੇਤਮਿਦੰ ਯੁਸ਼਼੍ਮਾਕੰ ਕਸ਼੍ਚਿਤ੍ ਕਸ਼੍ਚਿਦ੍ ਵਦਤਿ ਪੌਲਸ੍ਯ ਸ਼ਿਸ਼਼੍ਯੋ(ਅ)ਹਮ੍ ਆਪੱਲੋਃ ਸ਼ਿਸ਼਼੍ਯੋ(ਅ)ਹੰ ਕੈਫਾਃ ਸ਼ਿਸ਼਼੍ਯੋ(ਅ)ਹੰ ਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਸ਼ਿਸ਼਼੍ਯੋ(ਅ)ਹਮਿਤਿ ਚ| ");
INSERT INTO sanpun_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","ਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਕਿੰ ਵਿਭੇਦਃ ਕ੍ਰੁʼਤਃ? ਪੌਲਃ ਕਿੰ ਯੁਸ਼਼੍ਮਤ੍ਕ੍ਰੁʼਤੇ ਕ੍ਰੁਸ਼ੇ ਹਤਃ? ਪੌਲਸ੍ਯ ਨਾਮ੍ਨਾ ਵਾ ਯੂਯੰ ਕਿੰ ਮੱਜਿਤਾਃ? ");
INSERT INTO sanpun_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","ਕ੍ਰਿਸ਼਼੍ਪਗਾਯੌ ਵਿਨਾ ਯੁਸ਼਼੍ਮਾਕੰ ਮਧ੍ਯੇ(ਅ)ਨ੍ਯਃ ਕੋ(ਅ)ਪਿ ਮਯਾ ਨ ਮੱਜਿਤ ਇਤਿ ਹੇਤੋਰਹਮ੍ ਈਸ਼੍ਵਰੰ ਧਨ੍ਯੰ ਵਦਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","ਏਤੇਨ ਮਮ ਨਾਮ੍ਨਾ ਮਾਨਵਾ ਮਯਾ ਮੱਜਿਤਾ ਇਤਿ ਵਕ੍ਤੁੰ ਕੇਨਾਪਿ ਨ ਸ਼ਕ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","ਅਪਰੰ ਸ੍ਤਿਫਾਨਸ੍ਯ ਪਰਿਜਨਾ ਮਯਾ ਮੱਜਿਤਾਸ੍ਤਦਨ੍ਯਃ ਕਸ਼੍ਚਿਦ੍ ਯਨ੍ਮਯਾ ਮੱਜਿਤਸ੍ਤਦਹੰ ਨ ਵੇਦ੍ਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","ਖ੍ਰੀਸ਼਼੍ਟੇਨਾਹੰ ਮੱਜਨਾਰ੍ਥੰ ਨ ਪ੍ਰੇਰਿਤਃ ਕਿਨ੍ਤੁ ਸੁਸੰਵਾਦਸ੍ਯ ਪ੍ਰਚਾਰਾਰ੍ਥਮੇਵ; ਸੋ(ਅ)ਪਿ ਵਾਕ੍ਪਟੁਤਯਾ ਮਯਾ ਨ ਪ੍ਰਚਾਰਿਤਵ੍ਯਃ, ਯਤਸ੍ਤਥਾ ਪ੍ਰਚਾਰਿਤੇ ਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਕ੍ਰੁਸ਼ੇ ਮ੍ਰੁʼਤ੍ਯੁਃ ਫਲਹੀਨੋ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","ਯਤੋ ਹੇਤੋ ਰ੍ਯੇ ਵਿਨਸ਼੍ਯਨ੍ਤਿ ਤੇ ਤਾਂ ਕ੍ਰੁਸ਼ਸ੍ਯ ਵਾਰ੍ੱਤਾਂ ਪ੍ਰਲਾਪਮਿਵ ਮਨ੍ਯਨ੍ਤੇ ਕਿਞ੍ਚ ਪਰਿਤ੍ਰਾਣੰ ਲਭਮਾਨੇਸ਼਼੍ਵਸ੍ਮਾਸੁ ਸਾ ਈਸ਼੍ਵਰੀਯਸ਼ਕ੍ਤਿਸ੍ਵਰੂਪਾ| ");
INSERT INTO sanpun_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","ਤਸ੍ਮਾਦਿੱਥੰ ਲਿਖਿਤਮਾਸ੍ਤੇ, ਜ੍ਞਾਨਵਤਾਨ੍ਤੁ ਯਤ੍ ਜ੍ਞਾਨੰ ਤਨ੍ਮਯਾ ਨਾਸ਼ਯਿਸ਼਼੍ਯਤੇ| ਵਿਲੋਪਯਿਸ਼਼੍ਯਤੇ ਤਦ੍ਵਦ੍ ਬੁੱਧਿ ਰ੍ਬੱਧਿਮਤਾਂ ਮਯਾ|| ");
INSERT INTO sanpun_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","ਜ੍ਞਾਨੀ ਕੁਤ੍ਰ? ਸ਼ਾਸ੍ਤ੍ਰੀ ਵਾ ਕੁਤ੍ਰ? ਇਹਲੋਕਸ੍ਯ ਵਿਚਾਰਤਤ੍ਪਰੋ ਵਾ ਕੁਤ੍ਰ? ਇਹਲੋਕਸ੍ਯ ਜ੍ਞਾਨੰ ਕਿਮੀਸ਼੍ਵਰੇਣ ਮੋਹੀਕ੍ਰੁʼਤੰ ਨਹਿ? ");
INSERT INTO sanpun_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","ਈਸ਼੍ਵਰਸ੍ਯ ਜ੍ਞਾਨਾਦ੍ ਇਹਲੋਕਸ੍ਯ ਮਾਨਵਾਃ ਸ੍ਵਜ੍ਞਾਨੇਨੇਸ਼੍ਵਰਸ੍ਯ ਤੱਤ੍ਵਬੋਧੰ ਨ ਪ੍ਰਾਪ੍ਤਵਨ੍ਤਸ੍ਤਸ੍ਮਾਦ੍ ਈਸ਼੍ਵਰਃ ਪ੍ਰਚਾਰਰੂਪਿਣਾ ਪ੍ਰਲਾਪੇਨ ਵਿਸ਼੍ਵਾਸਿਨਃ ਪਰਿਤ੍ਰਾਤੁੰ ਰੋਚਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","ਯਿਹੂਦੀਯਲੋਕਾ ਲਕ੍ਸ਼਼ਣਾਨਿ ਦਿਦ੍ਰੁʼਕ੍ਸ਼਼ਨ੍ਤਿ ਭਿੰਨਦੇਸ਼ੀਯਲੋਕਾਸ੍ਤੁ ਵਿਦ੍ਯਾਂ ਮ੍ਰੁʼਗਯਨ੍ਤੇ, ");
INSERT INTO sanpun_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","ਵਯਞ੍ਚ ਕ੍ਰੁਸ਼ੇ ਹਤੰ ਖ੍ਰੀਸ਼਼੍ਟੰ ਪ੍ਰਚਾਰਯਾਮਃ| ਤਸ੍ਯ ਪ੍ਰਚਾਰੋ ਯਿਹੂਦੀਯੈ ਰ੍ਵਿਘ੍ਨ ਇਵ ਭਿੰਨਦੇਸ਼ੀਯੈਸ਼੍ਚ ਪ੍ਰਲਾਪ ਇਵ ਮਨ੍ਯਤੇ, ");
INSERT INTO sanpun_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","ਕਿਨ੍ਤੁ ਯਿਹੂਦੀਯਾਨਾਂ ਭਿੰਨਦੇਸ਼ੀਯਾਨਾਞ੍ਚ ਮਧ੍ਯੇ ਯੇ ਆਹੂਤਾਸ੍ਤੇਸ਼਼ੁ ਸ ਖ੍ਰੀਸ਼਼੍ਟ ਈਸ਼੍ਵਰੀਯਸ਼ਕ੍ਤਿਰਿਵੇਸ਼੍ਵਰੀਯਜ੍ਞਾਨਮਿਵ ਚ ਪ੍ਰਕਾਸ਼ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","ਯਤ ਈਸ਼੍ਵਰੇ ਯਃ ਪ੍ਰਲਾਪ ਆਰੋਪ੍ਯਤੇ ਸ ਮਾਨਵਾਤਿਰਿਕ੍ਤੰ ਜ੍ਞਾਨਮੇਵ ਯੱਚ ਦੌਰ੍ੱਬਲ੍ਯਮ੍ ਈਸ਼੍ਵਰ ਆਰੋਪ੍ਯਤੇ ਤਤ੍ ਮਾਨਵਾਤਿਰਿਕ੍ਤੰ ਬਲਮੇਵ| ");
INSERT INTO sanpun_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","ਹੇ ਭ੍ਰਾਤਰਃ, ਆਹੂਤਯੁਸ਼਼੍ਮਦ੍ਗਣੋ ਯਸ਼਼੍ਮਾਭਿਰਾਲੋਕ੍ਯਤਾਂ ਤਨ੍ਮਧ੍ਯੇ ਸਾਂਸਾਰਿਕਜ੍ਞਾਨੇਨ ਜ੍ਞਾਨਵਨ੍ਤਃ ਪਰਾਕ੍ਰਮਿਣੋ ਵਾ ਕੁਲੀਨਾ ਵਾ ਬਹਵੋ ਨ ਵਿਦ੍ਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","ਯਤ ਈਸ਼੍ਵਰੋ ਜ੍ਞਾਨਵਤਸ੍ਤ੍ਰਪਯਿਤੁੰ ਮੂਰ੍ਖਲੋਕਾਨ੍ ਰੋਚਿਤਵਾਨ੍ ਬਲਾਨਿ ਚ ਤ੍ਰਪਯਿਤੁਮ੍ ਈਸ਼੍ਵਰੋ ਦੁਰ੍ੱਬਲਾਨ੍ ਰੋਚਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","ਤਥਾ ਵਰ੍ੱਤਮਾਨਲੋਕਾਨ੍ ਸੰਸ੍ਥਿਤਿਭ੍ਰਸ਼਼੍ਟਾਨ੍ ਕਰ੍ੱਤੁਮ੍ ਈਸ਼੍ਵਰੋ ਜਗਤੋ(ਅ)ਪਕ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ ਹੇਯਾਨ੍ ਅਵਰ੍ੱਤਮਾਨਾਂਸ਼੍ਚਾਭਿਰੋਚਿਤਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","ਤਤ ਈਸ਼੍ਵਰਸ੍ਯ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਕੇਨਾਪ੍ਯਾਤ੍ਮਸ਼੍ਲਾਘਾ ਨ ਕਰ੍ੱਤਵ੍ਯਾ| ");
INSERT INTO sanpun_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","ਯੂਯਞ੍ਚ ਤਸ੍ਮਾਤ੍ ਖ੍ਰੀਸ਼਼੍ਟੇ ਯੀਸ਼ੌ ਸੰਸ੍ਥਿਤਿੰ ਪ੍ਰਾਪ੍ਤਵਨ੍ਤਃ ਸ ਈਸ਼੍ਵਰਾਦ੍ ਯੁਸ਼਼੍ਮਾਕੰ ਜ੍ਞਾਨੰ ਪੁਣ੍ਯੰ ਪਵਿਤ੍ਰਤ੍ਵੰ ਮੁਕ੍ਤਿਸ਼੍ਚ ਜਾਤਾ| ");
INSERT INTO sanpun_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","ਅਤਏਵ ਯਦ੍ਵਦ੍ ਲਿਖਿਤਮਾਸ੍ਤੇ ਤਦ੍ਵਤ੍, ਯਃ ਕਸ਼੍ਚਿਤ੍ ਸ਼੍ਲਾਘਮਾਨਃ ਸ੍ਯਾਤ੍ ਸ਼੍ਲਾਘਤਾਂ ਪ੍ਰਭੁਨਾ ਸ ਹਿ| ");
INSERT INTO sanpun_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","ਹੇ ਭ੍ਰਾਤਰੋ ਯੁਸ਼਼੍ਮਤ੍ਸਮੀਪੇ ਮਮਾਗਮਨਕਾਲੇ(ਅ)ਹੰ ਵਕ੍ਤ੍ਰੁʼਤਾਯਾ ਵਿਦ੍ਯਾਯਾ ਵਾ ਨੈਪੁਣ੍ਯੇਨੇਸ਼੍ਵਰਸ੍ਯ ਸਾਕ੍ਸ਼਼੍ਯੰ ਪ੍ਰਚਾਰਿਤਵਾਨ੍ ਤੰਨਹਿ; ");
INSERT INTO sanpun_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","ਯਤੋ ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟੰ ਤਸ੍ਯ ਕ੍ਰੁਸ਼ੇ ਹਤਤ੍ਵਞ੍ਚ ਵਿਨਾ ਨਾਨ੍ਯਤ੍ ਕਿਮਪਿ ਯੁਸ਼਼੍ਮਨ੍ਮਧ੍ਯੇ ਜ੍ਞਾਪਯਿਤੁੰ ਵਿਹਿਤੰ ਬੁੱਧਵਾਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","ਅਪਰਞ੍ਚਾਤੀਵ ਦੌਰ੍ੱਬਲ੍ਯਭੀਤਿਕਮ੍ਪਯੁਕ੍ਤੋ ਯੁਸ਼਼੍ਮਾਭਿਃ ਸਾਰ੍ੱਧਮਾਸੰ| ");
INSERT INTO sanpun_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","ਅਪਰੰ ਯੁਸ਼਼੍ਮਾਕੰ ਵਿਸ਼੍ਵਾਸੋ ਯਤ੍ ਮਾਨੁਸ਼਼ਿਕਜ੍ਞਾਨਸ੍ਯ ਫਲੰ ਨ ਭਵੇਤ੍ ਕਿਨ੍ਤ੍ਵੀਸ਼੍ਵਰੀਯਸ਼ਕ੍ਤੇਃ ਫਲੰ ਭਵੇਤ੍, ");
INSERT INTO sanpun_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","ਤਦਰ੍ਥੰ ਮਮ ਵਕ੍ਤ੍ਰੁʼਤਾ ਮਦੀਯਪ੍ਰਚਾਰਸ਼੍ਚ ਮਾਨੁਸ਼਼ਿਕਜ੍ਞਾਨਸ੍ਯ ਮਧੁਰਵਾਕ੍ਯਸਮ੍ਬਲਿਤੌ ਨਾਸ੍ਤਾਂ ਕਿਨ੍ਤ੍ਵਾਤ੍ਮਨਃ ਸ਼ਕ੍ਤੇਸ਼੍ਚ ਪ੍ਰਮਾਣਯੁਕ੍ਤਾਵਾਸ੍ਤਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","ਵਯੰ ਜ੍ਞਾਨੰ ਭਾਸ਼਼ਾਮਹੇ ਤੱਚ ਸਿੱਧਲੋਕੈ ਰ੍ਜ੍ਞਾਨਮਿਵ ਮਨ੍ਯਤੇ, ਤਦਿਹਲੋਕਸ੍ਯ ਜ੍ਞਾਨੰ ਨਹਿ, ਇਹਲੋਕਸ੍ਯ ਨਸ਼੍ਵਰਾਣਾਮ੍ ਅਧਿਪਤੀਨਾਂ ਵਾ ਜ੍ਞਾਨੰ ਨਹਿ; ");
INSERT INTO sanpun_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","ਕਿਨ੍ਤੁ ਕਾਲਾਵਸ੍ਥਾਯਾਃ ਪੂਰ੍ੱਵਸ੍ਮਾਦ੍ ਯਤ੍ ਜ੍ਞਾਨਮ੍ ਅਸ੍ਮਾਕੰ ਵਿਭਵਾਰ੍ਥਮ੍ ਈਸ਼੍ਵਰੇਣ ਨਿਸ਼੍ਚਿਤ੍ਯ ਪ੍ਰੱਛੰਨੰ ਤੰਨਿਗੂਢਮ੍ ਈਸ਼੍ਵਰੀਯਜ੍ਞਾਨੰ ਪ੍ਰਭਾਸ਼਼ਾਮਹੇ| ");
INSERT INTO sanpun_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","ਇਹਲੋਕਸ੍ਯਾਧਿਪਤੀਨਾਂ ਕੇਨਾਪਿ ਤਤ੍ ਜ੍ਞਾਨੰ ਨ ਲਬ੍ਧੰ, ਲਬ੍ਧੇ ਸਤਿ ਤੇ ਪ੍ਰਭਾਵਵਿਸ਼ਿਸ਼਼੍ਟੰ ਪ੍ਰਭੁੰ ਕ੍ਰੁਸ਼ੇ ਨਾਹਨਿਸ਼਼੍ਯਨ੍| ");
INSERT INTO sanpun_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","ਤਦ੍ਵੱਲਿਖਿਤਮਾਸ੍ਤੇ, ਨੇਤ੍ਰੇਣ ੱਕਾਪਿ ਨੋ ਦ੍ਰੁʼਸ਼਼੍ਟੰ ਕਰ੍ਣੇਨਾਪਿ ਚ ਨ ਸ਼੍ਰੁਤੰ| ਮਨੋਮਧ੍ਯੇ ਤੁ ਕਸ੍ਯਾਪਿ ਨ ਪ੍ਰਵਿਸ਼਼੍ਟੰ ਕਦਾਪਿ ਯਤ੍| ਈਸ਼੍ਵਰੇ ਪ੍ਰੀਯਮਾਣਾਨਾਂ ਕ੍ਰੁʼਤੇ ਤਤ੍ ਤੇਨ ਸਞ੍ਚਿਤੰ| ");
INSERT INTO sanpun_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","ਅਪਰਮੀਸ਼੍ਵਰਃ ਸ੍ਵਾਤ੍ਮਨਾ ਤਦਸ੍ਮਾਕੰ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਪ੍ਰਾਕਾਸ਼ਯਤ੍; ਯਤ ਆਤ੍ਮਾ ਸਰ੍ੱਵਮੇਵਾਨੁਸਨ੍ਧੱਤੇ ਤੇਨ ਚੇਸ਼੍ਵਰਸ੍ਯ ਮਰ੍ੰਮਤੱਤ੍ਵਮਪਿ ਬੁਧ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","ਮਨੁਜਸ੍ਯਾਨ੍ਤਃਸ੍ਥਮਾਤ੍ਮਾਨੰ ਵਿਨਾ ਕੇਨ ਮਨੁਜੇਨ ਤਸ੍ਯ ਮਨੁਜਸ੍ਯ ਤੱਤ੍ਵੰ ਬੁਧ੍ਯਤੇ? ਤਦ੍ਵਦੀਸ਼੍ਵਰਸ੍ਯਾਤ੍ਮਾਨੰ ਵਿਨਾ ਕੇਨਾਪੀਸ਼੍ਵਰਸ੍ਯ ਤੱਤ੍ਵੰ ਨ ਬੁਧ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","ਵਯਞ੍ਚੇਹਲੋਕਸ੍ਯਾਤ੍ਮਾਨੰ ਲਬ੍ਧਵਨ੍ਤਸ੍ਤੰਨਹਿ ਕਿਨ੍ਤ੍ਵੀਸ਼੍ਵਰਸ੍ਯੈਵਾਤ੍ਮਾਨੰ ਲਬ੍ਧਵਨ੍ਤਃ, ਤਤੋ ਹੇਤੋਰੀਸ਼੍ਵਰੇਣ ਸ੍ਵਪ੍ਰਸਾਦਾਦ੍ ਅਸ੍ਮਭ੍ਯੰ ਯਦ੍ ਯਦ੍ ਦੱਤੰ ਤਤ੍ਸਰ੍ੱਵਮ੍ ਅਸ੍ਮਾਭਿ ਰ੍ਜ੍ਞਾਤੁੰ ਸ਼ਕ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","ਤੱਚਾਸ੍ਮਾਭਿ ਰ੍ਮਾਨੁਸ਼਼ਿਕਜ੍ਞਾਨਸ੍ਯ ਵਾਕ੍ਯਾਨਿ ਸ਼ਿਕ੍ਸ਼਼ਿਤ੍ਵਾ ਕਥ੍ਯਤ ਇਤਿ ਨਹਿ ਕਿਨ੍ਤ੍ਵਾਤ੍ਮਤੋ ਵਾਕ੍ਯਾਨਿ ਸ਼ਿਕ੍ਸ਼਼ਿਤ੍ਵਾਤ੍ਮਿਕੈ ਰ੍ਵਾਕ੍ਯੈਰਾਤ੍ਮਿਕੰ ਭਾਵੰ ਪ੍ਰਕਾਸ਼ਯਦ੍ਭਿਃ ਕਥ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","ਪ੍ਰਾਣੀ ਮਨੁਸ਼਼੍ਯ ਈਸ਼੍ਵਰੀਯਾਤ੍ਮਨਃ ਸ਼ਿਕ੍ਸ਼਼ਾਂ ਨ ਗ੍ਰੁʼਹ੍ਲਾਤਿ ਯਤ ਆਤ੍ਮਿਕਵਿਚਾਰੇਣ ਸਾ ਵਿਚਾਰ੍ੱਯੇਤਿ ਹੇਤੋਃ ਸ ਤਾਂ ਪ੍ਰਲਾਪਮਿਵ ਮਨ੍ਯਤੇ ਬੋੱਧੁਞ੍ਚ ਨ ਸ਼ਕ੍ਨੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","ਆਤ੍ਮਿਕੋ ਮਾਨਵਃ ਸਰ੍ੱਵਾਣਿ ਵਿਚਾਰਯਤਿ ਕਿਨ੍ਤੁ ਸ੍ਵਯੰ ਕੇਨਾਪਿ ਨ ਵਿਚਾਰ੍ੱਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","ਯਤ ਈਸ਼੍ਵਰਸ੍ਯ ਮਨੋ ਜ੍ਞਾਤ੍ਵਾ ਤਮੁਪਦੇਸ਼਼੍ਟੁੰ ਕਃ ਸ਼ਕ੍ਨੋਤਿ? ਕਿਨ੍ਤੁ ਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਮਨੋ(ਅ)ਸ੍ਮਾਭਿ ਰ੍ਲਬ੍ਧੰ| ");
INSERT INTO sanpun_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","ਹੇ ਭ੍ਰਾਤਰਃ, ਅਹਮਾਤ੍ਮਿਕੈਰਿਵ ਯੁਸ਼਼੍ਮਾਭਿਃ ਸਮੰ ਸਮ੍ਭਾਸ਼਼ਿਤੁੰ ਨਾਸ਼ਕ੍ਨਵੰ ਕਿਨ੍ਤੁ ਸ਼ਾਰੀਰਿਕਾਚਾਰਿਭਿਃ ਖ੍ਰੀਸ਼਼੍ਟਧਰ੍ੰਮੇ ਸ਼ਿਸ਼ੁਤੁਲ੍ਯੈਸ਼੍ਚ ਜਨੈਰਿਵ ਯੁਸ਼਼੍ਮਾਭਿਃ ਸਹ ਸਮਭਾਸ਼਼ੇ| ");
INSERT INTO sanpun_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","ਯੁਸ਼਼੍ਮਾਨ੍ ਕਠਿਨਭਕ੍ਸ਼਼੍ਯੰ ਨ ਭੋਜਯਨ੍ ਦੁਗ੍ਧਮ੍ ਅਪਾਯਯੰ ਯਤੋ ਯੂਯੰ ਭਕ੍ਸ਼਼੍ਯੰ ਗ੍ਰਹੀਤੁੰ ਤਦਾ ਨਾਸ਼ਕ੍ਨੁਤ ਇਦਾਨੀਮਪਿ ਨ ਸ਼ਕ੍ਨੁਥ, ਯਤੋ ਹੇਤੋਰਧੁਨਾਪਿ ਸ਼ਾਰੀਰਿਕਾਚਾਰਿਣ ਆਧ੍ਵੇ| ");
INSERT INTO sanpun_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","ਯੁਸ਼਼੍ਮਨ੍ਮਧ੍ਯੇ ਮਾਤ੍ਸਰ੍ੱਯਵਿਵਾਦਭੇਦਾ ਭਵਨ੍ਤਿ ਤਤਃ ਕਿੰ ਸ਼ਾਰੀਰਿਕਾਚਾਰਿਣੋ ਨਾਧ੍ਵੇ ਮਾਨੁਸ਼਼ਿਕਮਾਰ੍ਗੇਣ ਚ ਨ ਚਰਥ? ");
INSERT INTO sanpun_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","ਪੌਲਸ੍ਯਾਹਮਿਤ੍ਯਾਪੱਲੋਰਹਮਿਤਿ ਵਾ ਯਦ੍ਵਾਕ੍ਯੰ ਯੁਸ਼਼੍ਮਾਕੰ ਕੈਸ਼੍ਚਿਤ੍ ਕੈਸ਼੍ਚਿਤ੍ ਕਥ੍ਯਤੇ ਤਸ੍ਮਾਦ੍ ਯੂਯੰ ਸ਼ਾਰੀਰਿਕਾਚਾਰਿਣ ਨ ਭਵਥ? ");
INSERT INTO sanpun_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","ਪੌਲਃ ਕਃ? ਆਪੱਲੋ ਰ੍ਵਾ ਕਃ? ਤੌ ਪਰਿਚਾਰਕਮਾਤ੍ਰੌ ਤਯੋਰੇਕੈਕਸ੍ਮੈ ਚ ਪ੍ਰਭੁ ਰ੍ਯਾਦ੍ਰੁʼਕ੍ ਫਲਮਦਦਾਤ੍ ਤਦ੍ਵਤ੍ ਤਯੋਰ੍ਦ੍ਵਾਰਾ ਯੂਯੰ ਵਿਸ਼੍ਵਾਸਿਨੋ ਜਾਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","ਅਹੰ ਰੋਪਿਤਵਾਨ੍ ਆਪੱਲੋਸ਼੍ਚ ਨਿਸ਼਼ਿਕ੍ਤਵਾਨ੍ ਈਸ਼੍ਵਰਸ਼੍ਚਾਵਰ੍ੱਧਯਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","ਅਤੋ ਰੋਪਯਿਤ੍ਰੁʼਸੇਕ੍ਤਾਰਾਵਸਾਰੌ ਵਰ੍ੱਧਯਿਤੇਸ਼੍ਵਰ ਏਵ ਸਾਰਃ| ");
INSERT INTO sanpun_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","ਰੋਪਯਿਤ੍ਰੁʼਸੇਕ੍ਤਾਰੌ ਚ ਸਮੌ ਤਯੋਰੇਕੈਕਸ਼੍ਚ ਸ੍ਵਸ਼੍ਰਮਯੋਗ੍ਯੰ ਸ੍ਵਵੇਤਨੰ ਲਪ੍ਸ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","ਆਵਾਮੀਸ਼੍ਵਰੇਣ ਸਹ ਕਰ੍ੰਮਕਾਰਿਣੌ, ਈਸ਼੍ਵਰਸ੍ਯ ਯਤ੍ ਕ੍ਸ਼਼ੇਤ੍ਰਮ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਯਾ ਨਿਰ੍ੰਮਿਤਿਃ ਸਾ ਯੂਯਮੇਵ| ");
INSERT INTO sanpun_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","ਈਸ਼੍ਵਰਸ੍ਯ ਪ੍ਰਸਾਦਾਤ੍ ਮਯਾ ਯਤ੍ ਪਦੰ ਲਬ੍ਧੰ ਤਸ੍ਮਾਤ੍ ਜ੍ਞਾਨਿਨਾ ਗ੍ਰੁʼਹਕਾਰਿਣੇਵ ਮਯਾ ਭਿੱਤਿਮੂਲੰ ਸ੍ਥਾਪਿਤੰ ਤਦੁਪਰਿ ਚਾਨ੍ਯੇਨ ਨਿਚੀਯਤੇ| ਕਿਨ੍ਤੁ ਯੇਨ ਯੰਨਿਚੀਯਤੇ ਤਤ੍ ਤੇਨ ਵਿਵਿਚ੍ਯਤਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","ਯਤੋ ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟਰੂਪੰ ਯਦ੍ ਭਿੱਤਿਮੂਲੰ ਸ੍ਥਾਪਿਤੰ ਤਦਨ੍ਯਤ੍ ਕਿਮਪਿ ਭਿੱਤਿਮੂਲੰ ਸ੍ਥਾਪਯਿਤੁੰ ਕੇਨਾਪਿ ਨ ਸ਼ਕ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","ਏਤਦ੍ਭਿੱਤਿਮੂਲਸ੍ਯੋਪਰਿ ਯਦਿ ਕੇਚਿਤ੍ ਸ੍ਵਰ੍ਣਰੂਪ੍ਯਮਣਿਕਾਸ਼਼੍ਠਤ੍ਰੁʼਣਨਲਾਨ੍ ਨਿਚਿਨ੍ਵਨ੍ਤਿ, ");
INSERT INTO sanpun_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","ਤਰ੍ਹ੍ਯੇਕੈਕਸ੍ਯ ਕਰ੍ੰਮ ਪ੍ਰਕਾਸ਼ਿਸ਼਼੍ਯਤੇ ਯਤਃ ਸ ਦਿਵਸਸ੍ਤਤ੍ ਪ੍ਰਕਾਸ਼ਯਿਸ਼਼੍ਯਤਿ| ਯਤੋ ਹਤੋਸ੍ਤਨ ਦਿਵਸੇਨ ਵਹ੍ਨਿਮਯੇਨੋਦੇਤਵ੍ਯੰ ਤਤ ਏਕੈਕਸ੍ਯ ਕਰ੍ੰਮ ਕੀਦ੍ਰੁʼਸ਼ਮੇਤਸ੍ਯ ਪਰੀਕ੍ਸ਼਼ਾ ਬਹ੍ਨਿਨਾ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","ਯਸ੍ਯ ਨਿਚਯਨਰੂਪੰ ਕਰ੍ੰਮ ਸ੍ਥਾਸ੍ਨੁ ਭਵਿਸ਼਼੍ਯਤਿ ਸ ਵੇਤਨੰ ਲਪ੍ਸ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","ਯਸ੍ਯ ਚ ਕਰ੍ੰਮ ਧਕ੍ਸ਼਼੍ਯਤੇ ਤਸ੍ਯ ਕ੍ਸ਼਼ਤਿ ਰ੍ਭਵਿਸ਼਼੍ਯਤਿ ਕਿਨ੍ਤੁ ਵਹ੍ਨੇ ਰ੍ਨਿਰ੍ਗਤਜਨ ਇਵ ਸ ਸ੍ਵਯੰ ਪਰਿਤ੍ਰਾਣੰ ਪ੍ਰਾਪ੍ਸ੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","ਯੂਯਮ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਮਨ੍ਦਿਰੰ ਯੁਸ਼਼੍ਮਨ੍ਮਧ੍ਯੇ ਚੇਸ਼੍ਵਰਸ੍ਯਾਤ੍ਮਾ ਨਿਵਸਤੀਤਿ ਕਿੰ ਨ ਜਾਨੀਥ? ");
INSERT INTO sanpun_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","ਈਸ਼੍ਵਰਸ੍ਯ ਮਨ੍ਦਿਰੰ ਯੇਨ ਵਿਨਾਸ਼੍ਯਤੇ ਸੋ(ਅ)ਪੀਸ਼੍ਵਰੇਣ ਵਿਨਾਸ਼ਯਿਸ਼਼੍ਯਤੇ ਯਤ ਈਸ਼੍ਵਰਸ੍ਯ ਮਨ੍ਦਿਰੰ ਪਵਿਤ੍ਰਮੇਵ ਯੂਯੰ ਤੁ ਤਨ੍ਮਨ੍ਦਿਰਮ੍ ਆਧ੍ਵੇ| ");
INSERT INTO sanpun_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","ਕੋਪਿ ਸ੍ਵੰ ਨ ਵਞ੍ਚਯਤਾਂ| ਯੁਸ਼਼੍ਮਾਕੰ ਕਸ਼੍ਚਨ ਚੇਦਿਹਲੋਕਸ੍ਯ ਜ੍ਞਾਨੇਨ ਜ੍ਞਾਨਵਾਨਹਮਿਤਿ ਬੁਧ੍ਯਤੇ ਤਰ੍ਹਿ ਸ ਯਤ੍ ਜ੍ਞਾਨੀ ਭਵੇਤ੍ ਤਦਰ੍ਥੰ ਮੂਢੋ ਭਵਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","ਯਸ੍ਮਾਦਿਹਲੋਕਸ੍ਯ ਜ੍ਞਾਨਮ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਮੂਢਤ੍ਵਮੇਵ| ਏਤਸ੍ਮਿਨ੍ ਲਿਖਿਤਮਪ੍ਯਾਸ੍ਤੇ, ਤੀਕ੍ਸ਼਼੍ਣਾ ਯਾ ਜ੍ਞਾਨਿਨਾਂ ਬੁੱਧਿਸ੍ਤਯਾ ਤਾਨ੍ ਧਰਤੀਸ਼੍ਵਰਃ| ");
INSERT INTO sanpun_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","ਪੁਨਸ਼੍ਚ| ਜ੍ਞਾਨਿਨਾਂ ਕਲ੍ਪਨਾ ਵੇੱਤਿ ਪਰਮੇਸ਼ੋ ਨਿਰਰ੍ਥਕਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","ਅਤਏਵ ਕੋ(ਅ)ਪਿ ਮਨੁਜੈਰਾਤ੍ਮਾਨੰ ਨ ਸ਼੍ਲਾਘਤਾਂ ਯਤਃ ਸਰ੍ੱਵਾਣਿ ਯੁਸ਼਼੍ਮਾਕਮੇਵ, ");
INSERT INTO sanpun_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","ਪੌਲ ਵਾ ਆਪੱਲੋ ਰ੍ਵਾ ਕੈਫਾ ਵਾ ਜਗਦ੍ ਵਾ ਜੀਵਨੰ ਵਾ ਮਰਣੰ ਵਾ ਵਰ੍ੱਤਮਾਨੰ ਵਾ ਭਵਿਸ਼਼੍ਯਦ੍ਵਾ ਸਰ੍ੱਵਾਣ੍ਯੇਵ ਯੁਸ਼਼੍ਮਾਕੰ, ");
INSERT INTO sanpun_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","ਯੂਯਞ੍ਚ ਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ, ਖ੍ਰੀਸ਼਼੍ਟਸ਼੍ਚੇਸ਼੍ਵਰਸ੍ਯ| ");
INSERT INTO sanpun_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","ਲੋਕਾ ਅਸ੍ਮਾਨ੍ ਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਪਰਿਚਾਰਕਾਨ੍ ਈਸ਼੍ਵਰਸ੍ਯ ਨਿਗੂਠਵਾਕ੍ਯਧਨਸ੍ਯਾਧ੍ਯਕ੍ਸ਼਼ਾਂਸ਼੍ਚ ਮਨ੍ਯਨ੍ਤਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","ਕਿਞ੍ਚ ਧਨਾਧ੍ਯਕ੍ਸ਼਼ੇਣ ਵਿਸ਼੍ਵਸਨੀਯੇਨ ਭਵਿਤਵ੍ਯਮੇਤਦੇਵ ਲੋਕੈ ਰ੍ਯਾਚ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","ਅਤੋ ਵਿਚਾਰਯਦ੍ਭਿ ਰ੍ਯੁਸ਼਼੍ਮਾਭਿਰਨ੍ਯੈਃ ਕੈਸ਼੍ਚਿਨ੍ ਮਨੁਜੈ ਰ੍ਵਾ ਮਮ ਪਰੀਕ੍ਸ਼਼ਣੰ ਮਯਾਤੀਵ ਲਘੁ ਮਨ੍ਯਤੇ (ਅ)ਹਮਪ੍ਯਾਤ੍ਮਾਨੰ ਨ ਵਿਚਾਰਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","ਮਯਾ ਕਿਮਪ੍ਯਪਰਾੱਧਮਿਤ੍ਯਹੰ ਨ ਵੇਦ੍ਮਿ ਕਿਨ੍ਤ੍ਵੇਤੇਨ ਮਮ ਨਿਰਪਰਾਧਤ੍ਵੰ ਨ ਨਿਸ਼੍ਚੀਯਤੇ ਪ੍ਰਭੁਰੇਵ ਮਮ ਵਿਚਾਰਯਿਤਾਸ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","ਅਤ ਉਪਯੁਕ੍ਤਸਮਯਾਤ੍ ਪੂਰ੍ੱਵਮ੍ ਅਰ੍ਥਤਃ ਪ੍ਰਭੋਰਾਗਮਨਾਤ੍ ਪੂਰ੍ੱਵੰ ਯੁਸ਼਼੍ਮਾਭਿ ਰ੍ਵਿਚਾਰੋ ਨ ਕ੍ਰਿਯਤਾਂ| ਪ੍ਰਭੁਰਾਗਤ੍ਯ ਤਿਮਿਰੇਣ ਪ੍ਰੱਛੰਨਾਨਿ ਸਰ੍ੱਵਾਣਿ ਦੀਪਯਿਸ਼਼੍ਯਤਿ ਮਨਸਾਂ ਮਨ੍ਤ੍ਰਣਾਸ਼੍ਚ ਪ੍ਰਕਾਸ਼ਯਿਸ਼਼੍ਯਤਿ ਤਸ੍ਮਿਨ੍ ਸਮਯ ਈਸ਼੍ਵਰਾਦ੍ ਏਕੈਕਸ੍ਯ ਪ੍ਰਸ਼ੰਸਾ ਭਵਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","ਹੇ ਭ੍ਰਾਤਰਃ ਸਰ੍ੱਵਾਣ੍ਯੇਤਾਨਿ ਮਯਾਤ੍ਮਾਨਮ੍ ਆਪੱਲਵਞ੍ਚੋੱਦਿਸ਼੍ਯ ਕਥਿਤਾਨਿ ਤਸ੍ਯੈਤਤ੍ ਕਾਰਣੰ ਯੁਯੰ ਯਥਾ ਸ਼ਾਸ੍ਤ੍ਰੀਯਵਿਧਿਮਤਿਕ੍ਰਮ੍ਯ ਮਾਨਵਮ੍ ਅਤੀਵ ਨਾਦਰਿਸ਼਼੍ਯਧ੍ਬ ਈੱਥਞ੍ਚੈਕੇਨ ਵੈਪਰੀਤ੍ਯਾਦ੍ ਅਪਰੇਣ ਨ ਸ਼੍ਲਾਘਿਸ਼਼੍ਯਧ੍ਬ ਏਤਾਦ੍ਰੁʼਸ਼ੀਂ ਸ਼ਿਕ੍ਸ਼਼ਾਮਾਵਯੋਰ੍ਦ੍ਰੁʼਸ਼਼੍ਟਾਨ੍ਤਾਤ੍ ਲਪ੍ਸ੍ਯਧ੍ਵੇ| ");
INSERT INTO sanpun_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","ਅਪਰਾਤ੍ ਕਸ੍ਤ੍ਵਾਂ ਵਿਸ਼ੇਸ਼਼ਯਤਿ? ਤੁਭ੍ਯੰ ਯੰਨ ਦੱਤ ਤਾਦ੍ਰੁʼਸ਼ੰ ਕਿੰ ਧਾਰਯਸਿ? ਅਦੱਤੇਨੇਵ ਦੱਤੇਨ ਵਸ੍ਤੁਨਾ ਕੁਤਃ ਸ਼੍ਲਾਘਸੇ? ");
INSERT INTO sanpun_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","ਇਦਾਨੀਮੇਵ ਯੂਯੰ ਕਿੰ ਤ੍ਰੁʼਪ੍ਤਾ ਲਬ੍ਧਧਨਾ ਵਾ? ਅਸ੍ਮਾਸ੍ਵਵਿਦ੍ਯਮਾਨੇਸ਼਼ੁ ਯੂਯੰ ਕਿੰ ਰਾਜਤ੍ਵਪਦੰ ਪ੍ਰਾਪ੍ਤਾਃ? ਯੁਸ਼਼੍ਮਾਕੰ ਰਾਜਤ੍ਵੰ ਮਯਾਭਿਲਸ਼਼ਿਤੰ ਯਤਸ੍ਤੇਨ ਯੁਸ਼਼੍ਮਾਭਿਃ ਸਹ ਵਯਮਪਿ ਰਾਜ੍ਯਾਂਸ਼ਿਨੋ ਭਵਿਸ਼਼੍ਯਾਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","ਪ੍ਰੇਰਿਤਾ ਵਯੰ ਸ਼ੇਸ਼਼ਾ ਹਨ੍ਤਵ੍ਯਾਸ਼੍ਚੇਵੇਸ਼੍ਵਰੇਣ ਨਿਦਰ੍ਸ਼ਿਤਾਃ| ਯਤੋ ਵਯੰ ਸਰ੍ੱਵਲੋਕਾਨਾਮ੍ ਅਰ੍ਥਤਃ ਸ੍ਵਰ੍ਗੀਯਦੂਤਾਨਾਂ ਮਾਨਵਾਨਾਞ੍ਚ ਕੌਤੁਕਾਸ੍ਪਦਾਨਿ ਜਾਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","ਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਕ੍ਰੁʼਤੇ ਵਯੰ ਮੂਢਾਃ ਕਿਨ੍ਤੁ ਯੂਯੰ ਖ੍ਰੀਸ਼਼੍ਟੇਨ ਜ੍ਞਾਨਿਨਃ, ਵਯੰ ਦੁਰ੍ੱਬਲਾ ਯੂਯਞ੍ਚ ਸਬਲਾਃ, ਯੂਯੰ ਸੰਮਾਨਿਤਾ ਵਯਞ੍ਚਾਪਮਾਨਿਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","ਵਯਮਦ੍ਯਾਪਿ ਕ੍ਸ਼਼ੁਧਾਰ੍ੱਤਾਸ੍ਤ੍ਰੁʼਸ਼਼੍ਣਾਰ੍ੱਤਾ ਵਸ੍ਤ੍ਰਹੀਨਾਸ੍ਤਾਡਿਤਾ ਆਸ਼੍ਰਮਰਹਿਤਾਸ਼੍ਚ ਸਨ੍ਤਃ ");
INSERT INTO sanpun_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","ਕਰ੍ੰਮਣਿ ਸ੍ਵਕਰਾਨ੍ ਵ੍ਯਾਪਾਰਯਨ੍ਤਸ਼੍ਚ ਦੁਃਖੈਃ ਕਾਲੰ ਯਾਪਯਾਮਃ| ਗਰ੍ਹਿਤੈਰਸ੍ਮਾਭਿਰਾਸ਼ੀਃ ਕਥ੍ਯਤੇ ਦੂਰੀਕ੍ਰੁʼਤੈਃ ਸਹ੍ਯਤੇ ਨਿਨ੍ਦਿਤੈਃ ਪ੍ਰਸਾਦ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","ਵਯਮਦ੍ਯਾਪਿ ਜਗਤਃ ਸੰਮਾਰ੍ਜਨੀਯੋਗ੍ਯਾ ਅਵਕਰਾ ਇਵ ਸਰ੍ੱਵੈ ਰ੍ਮਨ੍ਯਾਮਹੇ| ");
INSERT INTO sanpun_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","ਯੁਸ਼਼੍ਮਾਨ੍ ਤ੍ਰਪਯਿਤੁਮਹਮੇਤਾਨਿ ਲਿਖਾਮੀਤਿ ਨਹਿ ਕਿਨ੍ਤੁ ਪ੍ਰਿਯਾਤ੍ਮਜਾਨਿਵ ਯੁਸ਼਼੍ਮਾਨ੍ ਪ੍ਰਬੋਧਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","ਯਤਃ ਖ੍ਰੀਸ਼਼੍ਟਧਰ੍ੰਮੇ ਯਦ੍ਯਪਿ ਯੁਸ਼਼੍ਮਾਕੰ ਦਸ਼ਸਹਸ੍ਰਾਣਿ ਵਿਨੇਤਾਰੋ ਭਵਨ੍ਤਿ ਤਥਾਪਿ ਬਹਵੋ ਜਨਕਾ ਨ ਭਵਨ੍ਤਿ ਯਤੋ(ਅ)ਹਮੇਵ ਸੁਸੰਵਾਦੇਨ ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟੇ ਯੁਸ਼਼੍ਮਾਨ੍ ਅਜਨਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","ਅਤੋ ਯੁਸ਼਼੍ਮਾਨ੍ ਵਿਨਯੇ(ਅ)ਹੰ ਯੂਯੰ ਮਦਨੁਗਾਮਿਨੋ ਭਵਤ| ");
INSERT INTO sanpun_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","ਇਤ੍ਯਰ੍ਥੰ ਸਰ੍ੱਵੇਸ਼਼ੁ ਧਰ੍ੰਮਸਮਾਜੇਸ਼਼ੁ ਸਰ੍ੱਵਤ੍ਰ ਖ੍ਰੀਸ਼਼੍ਟਧਰ੍ੰਮਯੋਗ੍ਯਾ ਯੇ ਵਿਧਯੋ ਮਯੋਪਦਿਸ਼੍ਯਨ੍ਤੇ ਤਾਨ੍ ਯੋ ਯੁਸ਼਼੍ਮਾਨ੍ ਸ੍ਮਾਰਯਿਸ਼਼੍ਯਤ੍ਯੇਵਮ੍ਭੂਤੰ ਪ੍ਰਭੋਃ ਕ੍ਰੁʼਤੇ ਪ੍ਰਿਯੰ ਵਿਸ਼੍ਵਾਸਿਨਞ੍ਚ ਮਦੀਯਤਨਯੰ ਤੀਮਥਿਯੰ ਯੁਸ਼਼੍ਮਾਕੰ ਸਮੀਪੰ ਪ੍ਰੇਸ਼਼ਿਤਵਾਨਹੰ| ");
INSERT INTO sanpun_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","ਅਪਰਮਹੰ ਯੁਸ਼਼੍ਮਾਕੰ ਸਮੀਪੰ ਨ ਗਮਿਸ਼਼੍ਯਾਮੀਤਿ ਬੁੱਧ੍ਵਾ ਯੁਸ਼਼੍ਮਾਕੰ ਕਿਯਨ੍ਤੋ ਲੋਕਾ ਗਰ੍ੱਵਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","ਕਿਨ੍ਤੁ ਯਦਿ ਪ੍ਰਭੇਰਿੱਛਾ ਭਵਤਿ ਤਰ੍ਹ੍ਯਹਮਵਿਲਮ੍ਬੰ ਯੁਸ਼਼੍ਮਤ੍ਸਮੀਪਮੁਪਸ੍ਥਾਯ ਤੇਸ਼਼ਾਂ ਦਰ੍ਪਧ੍ਮਾਤਾਨਾਂ ਲੋਕਾਨਾਂ ਵਾਚੰ ਜ੍ਞਾਸ੍ਯਾਮੀਤਿ ਨਹਿ ਸਾਮਰ੍ਥ੍ਯਮੇਵ ਜ੍ਞਾਸ੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","ਯਸ੍ਮਾਦੀਸ਼੍ਵਰਸ੍ਯ ਰਾਜਤ੍ਵੰ ਵਾਗ੍ਯੁਕ੍ਤੰ ਨਹਿ ਕਿਨ੍ਤੁ ਸਾਮਰ੍ਥ੍ਯਯੁਕ੍ਤੰ| ");
INSERT INTO sanpun_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","ਯੁਸ਼਼੍ਮਾਕੰ ਕਾ ਵਾਞ੍ਛਾ? ਯੁਸ਼਼੍ਮਤ੍ਸਮੀਪੇ ਮਯਾ ਕਿੰ ਦਣ੍ਡਪਾਣਿਨਾ ਗਨ੍ਤਵ੍ਯਮੁਤ ਪ੍ਰੇਮਨਮ੍ਰਤਾਤ੍ਮਯੁਕ੍ਤੇਨ ਵਾ? ");
INSERT INTO sanpun_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","ਅਪਰੰ ਯੁਸ਼਼੍ਮਾਕੰ ਮਧ੍ਯੇ ਵ੍ਯਭਿਚਾਰੋ ਵਿਦ੍ਯਤੇ ਸ ਚ ਵ੍ਯਭਿਚਾਰਸ੍ਤਾਦ੍ਰੁʼਸ਼ੋ ਯਦ੍ ਦੇਵਪੂਜਕਾਨਾਂ ਮਧ੍ਯੇ(ਅ)ਪਿ ਤੱਤੁਲ੍ਯੋ ਨ ਵਿਦ੍ਯਤੇ ਫਲਤੋ ਯੁਸ਼਼੍ਮਾਕਮੇਕੋ ਜਨੋ ਵਿਮਾਤ੍ਰੁʼਗਮਨੰ ਕ੍ਰੁʼਰੁਤ ਇਤਿ ਵਾਰ੍ੱਤਾ ਸਰ੍ੱਵਤ੍ਰ ਵ੍ਯਾਪ੍ਤਾ| ");
INSERT INTO sanpun_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","ਤਥਾਚ ਯੂਯੰ ਦਰ੍ਪਧ੍ਮਾਤਾ ਆਧ੍ਬੇ, ਤਤ੍ ਕਰ੍ੰਮ ਯੇਨ ਕ੍ਰੁʼਤੰ ਸ ਯਥਾ ਯੁਸ਼਼੍ਮਨ੍ਮਧ੍ਯਾਦ੍ ਦੂਰੀਕ੍ਰਿਯਤੇ ਤਥਾ ਸ਼ੋਕੋ ਯੁਸ਼਼੍ਮਾਭਿ ਰ੍ਨ ਕ੍ਰਿਯਤੇ ਕਿਮ੍ ਏਤਤ੍? ");
INSERT INTO sanpun_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","ਅਵਿਦ੍ਯਮਾਨੇ ਮਦੀਯਸ਼ਰੀਰੇ ਮਮਾਤ੍ਮਾ ਯੁਸ਼਼੍ਮਨ੍ਮਧ੍ਯੇ ਵਿਦ੍ਯਤੇ ਅਤੋ(ਅ)ਹੰ ਵਿਦ੍ਯਮਾਨ ਇਵ ਤਤ੍ਕਰ੍ੰਮਕਾਰਿਣੋ ਵਿਚਾਰੰ ਨਿਸ਼੍ਚਿਤਵਾਨ੍, ");
INSERT INTO sanpun_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","ਅਸ੍ਮਤ੍ਪ੍ਰਭੋ ਰ੍ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਨਾਮ੍ਨਾ ਯੁਸ਼਼੍ਮਾਕੰ ਮਦੀਯਾਤ੍ਮਨਸ਼੍ਚ ਮਿਲਨੇ ਜਾਤੇ (ਅ)ਸ੍ਮਤ੍ਪ੍ਰਭੋ ਰ੍ਯੀਸ਼ੁਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਸ਼ਕ੍ਤੇਃ ਸਾਹਾੱਯੇਨ ");
INSERT INTO sanpun_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","ਸ ਨਰਃ ਸ਼ਰੀਰਨਾਸ਼ਾਰ੍ਥਮਸ੍ਮਾਭਿਃ ਸ਼ਯਤਾਨੋ ਹਸ੍ਤੇ ਸਮਰ੍ਪਯਿਤਵ੍ਯਸ੍ਤਤੋ(ਅ)ਸ੍ਮਾਕੰ ਪ੍ਰਭੋ ਰ੍ਯੀਸ਼ੋ ਰ੍ਦਿਵਸੇ ਤਸ੍ਯਾਤ੍ਮਾ ਰਕ੍ਸ਼਼ਾਂ ਗਨ੍ਤੁੰ ਸ਼ਕ੍ਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","ਯੁਸ਼਼੍ਮਾਕੰ ਦਰ੍ਪੋ ਨ ਭਦ੍ਰਾਯ ਯੂਯੰ ਕਿਮੇਤੰਨ ਜਾਨੀਥ, ਯਥਾ, ਵਿਕਾਰਃ ਕ੍ਰੁʼਤ੍ਸ੍ਨਸ਼ਕ੍ਤੂਨਾਂ ਸ੍ਵਲ੍ਪਕਿਣ੍ਵੇਨ ਜਾਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","ਯੂਯੰ ਯਤ੍ ਨਵੀਨਸ਼ਕ੍ਤੁਸ੍ਵਰੂਪਾ ਭਵੇਤ ਤਦਰ੍ਥੰ ਪੁਰਾਤਨੰ ਕਿਣ੍ਵਮ੍ ਅਵਮਾਰ੍ੱਜਤ ਯਤੋ ਯੁਸ਼਼੍ਮਾਭਿਃ ਕਿਣ੍ਵਸ਼ੂਨ੍ਯੈ ਰ੍ਭਵਿਤਵ੍ਯੰ| ਅਪਰਮ੍ ਅਸ੍ਮਾਕੰ ਨਿਸ੍ਤਾਰੋਤ੍ਸਵੀਯਮੇਸ਼਼ਸ਼ਾਵਕੋ ਯਃ ਖ੍ਰੀਸ਼਼੍ਟਃ ਸੋ(ਅ)ਸ੍ਮਦਰ੍ਥੰ ਬਲੀਕ੍ਰੁʼਤੋ (ਅ)ਭਵਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","ਅਤਃ ਪੁਰਾਤਨਕਿਣ੍ਵੇਨਾਰ੍ਥਤੋ ਦੁਸ਼਼੍ਟਤਾਜਿਘਾਂਸਾਰੂਪੇਣ ਕਿਣ੍ਵੇਨ ਤੰਨਹਿ ਕਿਨ੍ਤੁ ਸਾਰਲ੍ਯਸਤ੍ਯਤ੍ਵਰੂਪਯਾ ਕਿਣ੍ਵਸ਼ੂਨ੍ਯਤਯਾਸ੍ਮਾਭਿਰੁਤ੍ਸਵਃ ਕਰ੍ੱਤਵ੍ਯਃ| ");
INSERT INTO sanpun_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","ਵ੍ਯਾਭਿਚਾਰਿਣਾਂ ਸੰਸਰ੍ਗੋ ਯੁਸ਼਼੍ਮਾਭਿ ਰ੍ਵਿਹਾਤਵ੍ਯ ਇਤਿ ਮਯਾ ਪਤ੍ਰੇ ਲਿਖਿਤੰ| ");
INSERT INTO sanpun_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","ਕਿਨ੍ਤ੍ਵੈਹਿਕਲੋਕਾਨਾਂ ਮਧ੍ਯੇ ਯੇ ਵ੍ਯਭਿਚਾਰਿਣੋ ਲੋਭਿਨ ਉਪਦ੍ਰਾਵਿਣੋ ਦੇਵਪੂਜਕਾ ਵਾ ਤੇਸ਼਼ਾਂ ਸੰਸਰ੍ਗਃ ਸਰ੍ੱਵਥਾ ਵਿਹਾਤਵ੍ਯ ਇਤਿ ਨਹਿ, ਵਿਹਾਤਵ੍ਯੇ ਸਤਿ ਯੁਸ਼਼੍ਮਾਭਿ ਰ੍ਜਗਤੋ ਨਿਰ੍ਗਨ੍ਤਵ੍ਯਮੇਵ| ");
INSERT INTO sanpun_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","ਕਿਨ੍ਤੁ ਭ੍ਰਾਤ੍ਰੁʼਤ੍ਵੇਨ ਵਿਖ੍ਯਾਤਃ ਕਸ਼੍ਚਿੱਜਨੋ ਯਦਿ ਵ੍ਯਭਿਚਾਰੀ ਲੋਭੀ ਦੇਵਪੂਜਕੋ ਨਿਨ੍ਦਕੋ ਮਦ੍ਯਪ ਉਪਦ੍ਰਾਵੀ ਵਾ ਭਵੇਤ੍ ਤਰ੍ਹਿ ਤਾਦ੍ਰੁʼਸ਼ੇਨ ਮਾਨਵੇਨ ਸਹ ਭੋਜਨਪਾਨੇ(ਅ)ਪਿ ਯੁਸ਼਼੍ਮਾਭਿ ਰ੍ਨ ਕਰ੍ੱਤਵ੍ਯੇ ਇਤ੍ਯਧੁਨਾ ਮਯਾ ਲਿਖਿਤੰ| ");
INSERT INTO sanpun_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","ਸਮਾਜਬਹਿਃਸ੍ਥਿਤਾਨਾਂ ਲੋਕਾਨਾਂ ਵਿਚਾਰਕਰਣੇ ਮਮ ਕੋ(ਅ)ਧਿਕਾਰਃ? ਕਿਨ੍ਤੁ ਤਦਨ੍ਤਰ੍ਗਤਾਨਾਂ ਵਿਚਾਰਣੰ ਯੁਸ਼਼੍ਮਾਭਿਃ ਕਿੰ ਨ ਕਰ੍ੱਤਵ੍ਯੰ ਭਵੇਤ੍? ");
INSERT INTO sanpun_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","ਬਹਿਃਸ੍ਥਾਨਾਂ ਤੁ ਵਿਚਾਰ ਈਸ਼੍ਵਰੇਣ ਕਾਰਿਸ਼਼੍ਯਤੇ| ਅਤੋ ਯੁਸ਼਼੍ਮਾਭਿਃ ਸ ਪਾਤਕੀ ਸ੍ਵਮਧ੍ਯਾਦ੍ ਬਹਿਸ਼਼੍ਕ੍ਰਿਯਤਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","ਯੁਸ਼਼੍ਮਾਕਮੇਕਸ੍ਯ ਜਨਸ੍ਯਾਪਰੇਣ ਸਹ ਵਿਵਾਦੇ ਜਾਤੇ ਸ ਪਵਿਤ੍ਰਲੋਕੈ ਰ੍ਵਿਚਾਰਮਕਾਰਯਨ੍ ਕਿਮ੍ ਅਧਾਰ੍ੰਮਿਕਲੋਕੈ ਰ੍ਵਿਚਾਰਯਿਤੁੰ ਪ੍ਰੋਤ੍ਸਹਤੇ? ");
INSERT INTO sanpun_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","ਜਗਤੋ(ਅ)ਪਿ ਵਿਚਾਰਣੰ ਪਵਿਤ੍ਰਲੋਕੈਃ ਕਾਰਿਸ਼਼੍ਯਤ ਏਤਦ੍ ਯੂਯੰ ਕਿੰ ਨ ਜਾਨੀਥ? ਅਤੋ ਜਗਦ੍ ਯਦਿ ਯੁਸ਼਼੍ਮਾਭਿ ਰ੍ਵਿਚਾਰਯਿਤਵ੍ਯੰ ਤਰ੍ਹਿ ਕ੍ਸ਼਼ੁਦ੍ਰਤਮਵਿਚਾਰੇਸ਼਼ੁ ਯੂਯੰ ਕਿਮਸਮਰ੍ਥਾਃ? ");
INSERT INTO sanpun_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","ਦੂਤਾ ਅਪ੍ਯਸ੍ਮਾਭਿ ਰ੍ਵਿਚਾਰਯਿਸ਼਼੍ਯਨ੍ਤ ਇਤਿ ਕਿੰ ਨ ਜਾਨੀਥ? ਅਤ ਐਹਿਕਵਿਸ਼਼ਯਾਃ ਕਿਮ੍ ਅਸ੍ਮਾਭਿ ਰ੍ਨ ਵਿਚਾਰਯਿਤਵ੍ਯਾ ਭਵੇਯੁਃ? ");
INSERT INTO sanpun_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","ਐਹਿਕਵਿਸ਼਼ਯਸ੍ਯ ਵਿਚਾਰੇ ਯੁਸ਼਼੍ਮਾਭਿਃ ਕਰ੍ੱਤਵ੍ਯੇ ਯੇ ਲੋਕਾਃ ਸਮਿਤੌ ਕ੍ਸ਼਼ੁਦ੍ਰਤਮਾਸ੍ਤ ਏਵ ਨਿਯੁਜ੍ਯਨ੍ਤਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","ਅਹੰ ਯੁਸ਼਼੍ਮਾਨ੍ ਤ੍ਰਪਯਿਤੁਮਿੱਛਨ੍ ਵਦਾਮਿ ਯ੍ਰੁʼਸ਼਼੍ਮਨ੍ਮਧ੍ਯੇ ਕਿਮੇਕੋ(ਅ)ਪਿ ਮਨੁਸ਼਼੍ਯਸ੍ਤਾਦ੍ਰੁʼਗ੍ ਬੁੱਧਿਮਾੰਨਹਿ ਯੋ ਭ੍ਰਾਤ੍ਰੁʼਵਿਵਾਦਵਿਚਾਰਣੇ ਸਮਰ੍ਥਃ ਸ੍ਯਾਤ੍? ");
INSERT INTO sanpun_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","ਕਿਞ੍ਚੈਕੋ ਭ੍ਰਾਤਾ ਭ੍ਰਾਤ੍ਰਾਨ੍ਯੇਨ ਕਿਮਵਿਸ਼੍ਵਾਸਿਨਾਂ ਵਿਚਾਰਕਾਣਾਂ ਸਾਕ੍ਸ਼਼ਾਦ੍ ਵਿਵਦਤੇ? ਯਸ਼਼੍ਮਨ੍ਮਧ੍ਯੇ ਵਿਵਾਦਾ ਵਿਦ੍ਯਨ੍ਤ ਏਤਦਪਿ ਯੁਸ਼਼੍ਮਾਕੰ ਦੋਸ਼਼ਃ| ");
INSERT INTO sanpun_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","ਯੂਯੰ ਕੁਤੋ(ਅ)ਨ੍ਯਾਯਸਹਨੰ ਕ੍ਸ਼਼ਤਿਸਹਨੰ ਵਾ ਸ਼੍ਰੇਯੋ ਨ ਮਨ੍ਯਧ੍ਵੇ? ");
INSERT INTO sanpun_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","ਕਿਨ੍ਤੁ ਯੂਯਮਪਿ ਭ੍ਰਾਤ੍ਰੁʼਨੇਵ ਪ੍ਰਤ੍ਯਨ੍ਯਾਯੰ ਕ੍ਸ਼਼ਤਿਞ੍ਚ ਕੁਰੁਥ ਕਿਮੇਤਤ੍? ");
INSERT INTO sanpun_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","ਈਸ਼੍ਵਰਸ੍ਯ ਰਾਜ੍ਯੇ(ਅ)ਨ੍ਯਾਯਕਾਰਿਣਾਂ ਲੋਕਾਨਾਮਧਿਕਾਰੋ ਨਾਸ੍ਤ੍ਯੇਤਦ੍ ਯੂਯੰ ਕਿੰ ਨ ਜਾਨੀਥ? ਮਾ ਵਞ੍ਚ੍ਯਧ੍ਵੰ, ਯੇ ਵ੍ਯਭਿਚਾਰਿਣੋ ਦੇਵਾਰ੍ੱਚਿਨਃ ਪਾਰਦਾਰਿਕਾਃ ਸ੍ਤ੍ਰੀਵਦਾਚਾਰਿਣਃ ਪੁੰਮੈਥੁਨਕਾਰਿਣਸ੍ਤਸ੍ਕਰਾ ");
INSERT INTO sanpun_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","ਲੋਭਿਨੋ ਮਦ੍ਯਪਾ ਨਿਨ੍ਦਕਾ ਉਪਦ੍ਰਾਵਿਣੋ ਵਾ ਤ ਈਸ਼੍ਵਰਸ੍ਯ ਰਾਜ੍ਯਭਾਗਿਨੋ ਨ ਭਵਿਸ਼਼੍ਯਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","ਯੂਯਞ੍ਚੈਵੰਵਿਧਾ ਲੋਕਾ ਆਸ੍ਤ ਕਿਨ੍ਤੁ ਪ੍ਰਭੋ ਰ੍ਯੀਸ਼ੋ ਰ੍ਨਾਮ੍ਨਾਸ੍ਮਦੀਸ਼੍ਵਰਸ੍ਯਾਤ੍ਮਨਾ ਚ ਯੂਯੰ ਪ੍ਰਕ੍ਸ਼਼ਾਲਿਤਾਃ ਪਾਵਿਤਾਃ ਸਪੁਣ੍ਯੀਕ੍ਰੁʼਤਾਸ਼੍ਚ| ");
INSERT INTO sanpun_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","ਮਦਰ੍ਥੰ ਸਰ੍ੱਵੰ ਦ੍ਰਵ੍ਯਮ੍ ਅਪ੍ਰਤਿਸ਼਼ਿੱਧੰ ਕਿਨ੍ਤੁ ਨ ਸਰ੍ੱਵੰ ਹਿਤਜਨਕੰ| ਮਦਰ੍ਥੰ ਸਰ੍ੱਵਮਪ੍ਰਤਿਸ਼਼ਿੱਧੰ ਤਥਾਪ੍ਯਹੰ ਕਸ੍ਯਾਪਿ ਦ੍ਰਵ੍ਯਸ੍ਯ ਵਸ਼ੀਕ੍ਰੁʼਤੋ ਨ ਭਵਿਸ਼਼੍ਯਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","ਉਦਰਾਯ ਭਕ੍ਸ਼਼੍ਯਾਣਿ ਭਕ੍ਸ਼਼੍ਯੇਭ੍ਯਸ਼੍ਚੋਦਰੰ, ਕਿਨ੍ਤੁ ਭਕ੍ਸ਼਼੍ਯੋਦਰੇ ਈਸ਼੍ਵਰੇਣ ਨਾਸ਼ਯਿਸ਼਼੍ਯੇਤੇ; ਅਪਰੰ ਦੇਹੋ ਨ ਵ੍ਯਭਿਚਾਰਾਯ ਕਿਨ੍ਤੁ ਪ੍ਰਭਵੇ ਪ੍ਰਭੁਸ਼੍ਚ ਦੇਹਾਯ| ");
INSERT INTO sanpun_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","ਯਸ਼੍ਚੇਸ਼੍ਵਰਃ ਪ੍ਰਭੁਮੁੱਥਾਪਿਤਵਾਨ੍ ਸ ਸ੍ਵਸ਼ਕ੍ਤ੍ਯਾਸ੍ਮਾਨਪ੍ਯੁੱਥਾਪਯਿਸ਼਼੍ਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","ਯੁਸ਼਼੍ਮਾਕੰ ਯਾਨਿ ਸ਼ਰੀਰਾਣਿ ਤਾਨਿ ਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯਾਙ੍ਗਾਨੀਤਿ ਕਿੰ ਯੂਯੰ ਨ ਜਾਨੀਥ? ਅਤਃ ਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਯਾਨ੍ਯਙ੍ਗਾਨਿ ਤਾਨਿ ਮਯਾਪਹ੍ਰੁʼਤ੍ਯ ਵੇਸ਼੍ਯਾਯਾ ਅਙ੍ਗਾਨਿ ਕਿੰ ਕਾਰਿਸ਼਼੍ਯਨ੍ਤੇ? ਤੰਨ ਭਵਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","ਯਃ ਕਸ਼੍ਚਿਦ੍ ਵੇਸ਼੍ਯਾਯਾਮ੍ ਆਸਜ੍ਯਤੇ ਸ ਤਯਾ ਸਹੈਕਦੇਹੋ ਭਵਤਿ ਕਿੰ ਯੂਯਮੇਤੰਨ ਜਾਨੀਥ? ਯਤੋ ਲਿਖਿਤਮਾਸ੍ਤੇ, ਯਥਾ, ਤੌ ਦ੍ਵੌ ਜਨਾਵੇਕਾਙ੍ਗੌ ਭਵਿਸ਼਼੍ਯਤਃ| ");
INSERT INTO sanpun_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","ਮਾਨਵਾ ਯਾਨ੍ਯਨ੍ਯਾਨਿ ਕਲੁਸ਼਼ਾਣਿ ਕੁਰ੍ੱਵਤੇ ਤਾਨਿ ਵਪੁ ਰ੍ਨ ਸਮਾਵਿਸ਼ਨ੍ਤਿ ਕਿਨ੍ਤੁ ਵ੍ਯਭਿਚਾਰਿਣਾ ਸ੍ਵਵਿਗ੍ਰਹਸ੍ਯ ਵਿਰੁੱਧੰ ਕਲ੍ਮਸ਼਼ੰ ਕ੍ਰਿਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","ਮਾਨਵਾ ਯਾਨ੍ਯਨ੍ਯਾਨਿ ਕਲੁਸ਼਼ਾਣਿ ਕੁਰ੍ੱਵਤੇ ਤਾਨਿ ਵਪੁ ਰ੍ਨ ਸਮਾਵਿਸ਼ਨ੍ਤਿ ਕਿਨ੍ਤੁ ਵ੍ਯਭਿਚਾਰਿਣਾ ਸ੍ਵਵਿਗ੍ਰਹਸ੍ਯ ਵਿਰੁੱਧੰ ਕਲ੍ਮਸ਼਼ੰ ਕ੍ਰਿਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","ਯੁਸ਼਼੍ਮਾਕੰ ਯਾਨਿ ਵਪੂੰਸਿ ਤਾਨਿ ਯੁਸ਼਼੍ਮਦਨ੍ਤਃਸ੍ਥਿਤਸ੍ਯੇਸ਼੍ਵਰਾੱਲਬ੍ਧਸ੍ਯ ਪਵਿਤ੍ਰਸ੍ਯਾਤ੍ਮਨੋ ਮਨ੍ਦਿਰਾਣਿ ਯੂਯਞ੍ਚ ਸ੍ਵੇਸ਼਼ਾਂ ਸ੍ਵਾਮਿਨੋ ਨਾਧ੍ਵੇ ਕਿਮੇਤਦ੍ ਯੁਸ਼਼੍ਮਾਭਿ ਰ੍ਨ ਜ੍ਞਾਯਤੇ? ");
INSERT INTO sanpun_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","ਯੂਯੰ ਮੂਲ੍ਯੇਨ ਕ੍ਰੀਤਾ ਅਤੋ ਵਪੁਰ੍ਮਨੋਭ੍ਯਾਮ੍ ਈਸ਼੍ਵਰੋ ਯੁਸ਼਼੍ਮਾਭਿਃ ਪੂਜ੍ਯਤਾਂ ਯਤ ਈਸ਼੍ਵਰ ਏਵ ਤਯੋਃ ਸ੍ਵਾਮੀ| ");
INSERT INTO sanpun_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","ਅਪਰਞ੍ਚ ਯੁਸ਼਼੍ਮਾਭਿ ਰ੍ਮਾਂ ਪ੍ਰਤਿ ਯਤ੍ ਪਤ੍ਰਮਲੇਖਿ ਤਸ੍ਯੋੱਤਰਮੇਤਤ੍, ਯੋਸ਼਼ਿਤੋ(ਅ)ਸ੍ਪਰ੍ਸ਼ਨੰ ਮਨੁਜਸ੍ਯ ਵਰੰ; ");
INSERT INTO sanpun_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","ਕਿਨ੍ਤੁ ਵ੍ਯਭਿਚਾਰਭਯਾਦ੍ ਏਕੈਕਸ੍ਯ ਪੁੰਸਃ ਸ੍ਵਕੀਯਭਾਰ੍ੱਯਾ ਭਵਤੁ ਤਦ੍ਵਦ੍ ਏਕੈਕਸ੍ਯਾ ਯੋਸ਼਼ਿਤੋ (ਅ)ਪਿ ਸ੍ਵਕੀਯਭਰ੍ੱਤਾ ਭਵਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","ਭਾਰ੍ੱਯਾਯੈ ਭਰ੍ਤ੍ਰਾ ਯਦ੍ਯਦ੍ ਵਿਤਰਣੀਯੰ ਤਦ੍ ਵਿਤੀਰ੍ੱਯਤਾਂ ਤਦ੍ਵਦ੍ ਭਰ੍ਤ੍ਰੇ(ਅ)ਪਿ ਭਾਰ੍ੱਯਯਾ ਵਿਤਰਣੀਯੰ ਵਿਤੀਰ੍ੱਯਤਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","ਭਾਰ੍ੱਯਾਯਾਃ ਸ੍ਵਦੇਹੇ ਸ੍ਵਤ੍ਵੰ ਨਾਸ੍ਤਿ ਭਰ੍ੱਤੁਰੇਵ, ਤਦ੍ਵਦ੍ ਭਰ੍ੱਤੁਰਪਿ ਸ੍ਵਦੇਹੇ ਸ੍ਵਤ੍ਵੰ ਨਾਸ੍ਤਿ ਭਾਰ੍ੱਯਾਯਾ ਏਵ| ");
INSERT INTO sanpun_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","ਉਪੋਸ਼਼ਣਪ੍ਰਾਰ੍ਥਨਯੋਃ ਸੇਵਨਾਰ੍ਥਮ੍ ਏਕਮਨ੍ਤ੍ਰਣਾਨਾਂ ਯੁਸ਼਼੍ਮਾਕੰ ਕਿਯਤ੍ਕਾਲੰ ਯਾਵਦ੍ ਯਾ ਪ੍ਰੁʼਥਕ੍ਸ੍ਥਿਤਿ ਰ੍ਭਵਤਿ ਤਦਨ੍ਯੋ ਵਿੱਛੇਦੋ ਯੁਸ਼਼੍ਮਨ੍ਮਧ੍ਯੇ ਨ ਭਵਤੁ, ਤਤਃ ਪਰਮ੍ ਇਨ੍ਦ੍ਰਿਯਾਣਾਮ੍ ਅਧੈਰ੍ੱਯਾਤ੍ ਸ਼ਯਤਾਨ੍ ਯਦ੍ ਯੁਸ਼਼੍ਮਾਨ੍ ਪਰੀਕ੍ਸ਼਼ਾਂ ਨ ਨਯੇਤ੍ ਤਦਰ੍ਥੰ ਪੁਨਰੇਕਤ੍ਰ ਮਿਲਤ| ");
INSERT INTO sanpun_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","ਏਤਦ੍ ਆਦੇਸ਼ਤੋ ਨਹਿ ਕਿਨ੍ਤ੍ਵਨੁਜ੍ਞਾਤ ਏਵ ਮਯਾ ਕਥ੍ਯਤੇ, ");
INSERT INTO sanpun_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","ਯਤੋ ਮਮਾਵਸ੍ਥੇਵ ਸਰ੍ੱਵਮਾਨਵਾਨਾਮਵਸ੍ਥਾ ਭਵਤ੍ਵਿਤਿ ਮਮ ਵਾਞ੍ਛਾ ਕਿਨ੍ਤ੍ਵੀਸ਼੍ਵਰਾਦ੍ ਏਕੇਨੈਕੋ ਵਰੋ(ਅ)ਨ੍ਯੇਨ ਚਾਨ੍ਯੋ ਵਰ ਇੱਥਮੇਕੈਕੇਨ ਸ੍ਵਕੀਯਵਰੋ ਲਬ੍ਧਃ| ");
INSERT INTO sanpun_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","ਅਪਰਮ੍ ਅਕ੍ਰੁʼਤਵਿਵਾਹਾਨ੍ ਵਿਧਵਾਸ਼੍ਚ ਪ੍ਰਤਿ ਮਮੈਤੰਨਿਵੇਦਨੰ ਮਮੇਵ ਤੇਸ਼਼ਾਮਵਸ੍ਥਿਤਿ ਰ੍ਭਦ੍ਰਾ; ");
INSERT INTO sanpun_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","ਕਿਞ੍ਚ ਯਦਿ ਤੈਰਿਨ੍ਦ੍ਰਿਯਾਣਿ ਨਿਯਨ੍ਤੁੰ ਨ ਸ਼ਕ੍ਯਨ੍ਤੇ ਤਰ੍ਹਿ ਵਿਵਾਹਃ ਕ੍ਰਿਯਤਾਂ ਯਤਃ ਕਾਮਦਹਨਾਦ੍ ਵ੍ਯੂਢਤ੍ਵੰ ਭਦ੍ਰੰ| ");
INSERT INTO sanpun_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","ਯੇ ਚ ਕ੍ਰੁʼਤਵਿਵਾਹਾਸ੍ਤੇ ਮਯਾ ਨਹਿ ਪ੍ਰਭੁਨੈਵੈਤਦ੍ ਆਜ੍ਞਾਪ੍ਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","ਭਾਰ੍ੱਯਾ ਭਰ੍ੱਤ੍ਰੁʼਤਃ ਪ੍ਰੁʼਥਕ੍ ਨ ਭਵਤੁ| ਯਦਿ ਵਾ ਪ੍ਰੁʼਥਗ੍ਭੂਤਾ ਸ੍ਯਾਤ੍ ਤਰ੍ਹਿ ਨਿਰ੍ਵਿਵਾਹਾ ਤਿਸ਼਼੍ਠਤੁ ਸ੍ਵੀਯਪਤਿਨਾ ਵਾ ਸਨ੍ਦਧਾਤੁ ਭਰ੍ੱਤਾਪਿ ਭਾਰ੍ੱਯਾਂ ਨ ਤ੍ਯਜਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","ਇਤਰਾਨ੍ ਜਨਾਨ੍ ਪ੍ਰਤਿ ਪ੍ਰਭੁ ਰ੍ਨ ਬ੍ਰਵੀਤਿ ਕਿਨ੍ਤ੍ਵਹੰ ਬ੍ਰਵੀਮਿ; ਕਸ੍ਯਚਿਦ੍ ਭ੍ਰਾਤੁਰ੍ਯੋਸ਼਼ਿਦ੍ ਅਵਿਸ਼੍ਵਾਸਿਨੀ ਸਤ੍ਯਪਿ ਯਦਿ ਤੇਨ ਸਹਵਾਸੇ ਤੁਸ਼਼੍ਯਤਿ ਤਰ੍ਹਿ ਸਾ ਤੇਨ ਨ ਤ੍ਯਜ੍ਯਤਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","ਤਦ੍ਵਤ੍ ਕਸ੍ਯਾਸ਼੍ਚਿਦ੍ ਯੋਸ਼਼ਿਤਃ ਪਤਿਰਵਿਸ਼੍ਵਾਸੀ ਸੰਨਪਿ ਯਦਿ ਤਯਾ ਸਹਵਾਸੇ ਤੁਸ਼਼੍ਯਤਿ ਤਰ੍ਹਿ ਸ ਤਯਾ ਨ ਤ੍ਯਜ੍ਯਤਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","ਯਤੋ(ਅ)ਵਿਸ਼੍ਵਾਸੀ ਭਰ੍ੱਤਾ ਭਾਰ੍ੱਯਯਾ ਪਵਿਤ੍ਰੀਭੂਤਃ, ਤਦ੍ਵਦਵਿਸ਼੍ਵਾਸਿਨੀ ਭਾਰ੍ੱਯਾ ਭਰ੍ਤ੍ਰਾ ਪਵਿਤ੍ਰੀਭੂਤਾ; ਨੋਚੇਦ੍ ਯੁਸ਼਼੍ਮਾਕਮਪਤ੍ਯਾਨ੍ਯਸ਼ੁਚੀਨ੍ਯਭਵਿਸ਼਼੍ਯਨ੍ ਕਿਨ੍ਤ੍ਵਧੁਨਾ ਤਾਨਿ ਪਵਿਤ੍ਰਾਣਿ ਸਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","ਅਵਿਸ਼੍ਵਾਸੀ ਜਨੋ ਯਦਿ ਵਾ ਪ੍ਰੁʼਥਗ੍ ਭਵਤਿ ਤਰ੍ਹਿ ਪ੍ਰੁʼਥਗ੍ ਭਵਤੁ; ਏਤੇਨ ਭ੍ਰਾਤਾ ਭਗਿਨੀ ਵਾ ਨ ਨਿਬਧ੍ਯਤੇ ਤਥਾਪਿ ਵਯਮੀਸ਼੍ਵਰੇਣ ਸ਼ਾਨ੍ਤਯੇ ਸਮਾਹੂਤਾਃ| ");
INSERT INTO sanpun_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","ਹੇ ਨਾਰਿ ਤਵ ਭਰ੍ੱਤੁਃ ਪਰਿਤ੍ਰਾਣੰ ਤ੍ਵੱਤੋ ਭਵਿਸ਼਼੍ਯਤਿ ਨ ਵੇਤਿ ਤ੍ਵਯਾ ਕਿੰ ਜ੍ਞਾਯਤੇ? ਹੇ ਨਰ ਤਵ ਜਾਯਾਯਾਃ ਪਰਿਤ੍ਰਾਣੰ ਤ੍ਵੱਤੇा ਭਵਿਸ਼਼੍ਯਤਿ ਨ ਵੇਤਿ ਤ੍ਵਯਾ ਕਿੰ ਜ੍ਞਾਯਤੇ? ");
INSERT INTO sanpun_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","ਏਕੈਕੋ ਜਨਃ ਪਰਮੇਸ਼੍ਵਰਾੱਲਬ੍ਧੰ ਯਦ੍ ਭਜਤੇ ਯਸ੍ਯਾਞ੍ਚਾਵਸ੍ਥਾਯਾਮ੍ ਈਸ਼੍ਵਰੇਣਾਹ੍ਵਾਯਿ ਤਦਨੁਸਾਰੇਣੈਵਾਚਰਤੁ ਤਦਹੰ ਸਰ੍ੱਵਸਮਾਜਸ੍ਥਾਨ੍ ਆਦਿਸ਼ਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","ਛਿੰਨਤ੍ਵਗ੍ ਭ੍ਰੁʼਤ੍ਵਾ ਯ ਆਹੂਤਃ ਸ ਪ੍ਰਕ੍ਰੁʼਸ਼਼੍ਟਤ੍ਵਕ੍ ਨ ਭਵਤੁ, ਤਦ੍ਵਦ੍ ਅਛਿੰਨਤ੍ਵਗ੍ ਭੂਤ੍ਵਾ ਯ ਆਹੂਤਃ ਸ ਛਿੰਨਤ੍ਵਕ੍ ਨ ਭਵਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","ਤ੍ਵਕ੍ਛੇਦਃ ਸਾਰੋ ਨਹਿ ਤਦ੍ਵਦਤ੍ਵਕ੍ਛੇਦੋ(ਅ)ਪਿ ਸਾਰੋ ਨਹਿ ਕਿਨ੍ਤ੍ਵੀਸ਼੍ਵਰਸ੍ਯਾਜ੍ਞਾਨਾਂ ਪਾਲਨਮੇਵ| ");
INSERT INTO sanpun_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","ਯੋ ਜਨੋ ਯਸ੍ਯਾਮਵਸ੍ਥਾਯਾਮਾਹ੍ਵਾਯਿ ਸ ਤਸ੍ਯਾਮੇਵਾਵਤਿਸ਼਼੍ਠਤਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","ਦਾਸਃ ਸਨ੍ ਤ੍ਵੰ ਕਿਮਾਹੂਤੋ(ਅ)ਸਿ? ਤਨ੍ਮਾ ਚਿਨ੍ਤਯ, ਤਥਾਚ ਯਦਿ ਸ੍ਵਤਨ੍ਤ੍ਰੋ ਭਵਿਤੁੰ ਸ਼ਕ੍ਨੁਯਾਸ੍ਤਰ੍ਹਿ ਤਦੇਵ ਵ੍ਰੁʼਣੁ| ");
INSERT INTO sanpun_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","ਯਤਃ ਪ੍ਰਭੁਨਾਹੂਤੋ ਯੋ ਦਾਸਃ ਸ ਪ੍ਰਭੋ ਰ੍ਮੋਚਿਤਜਨਃ| ਤਦ੍ਵਦ੍ ਤੇਨਾਹੂਤਃ ਸ੍ਵਤਨ੍ਤ੍ਰੋ ਜਨੋ(ਅ)ਪਿ ਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਦਾਸ ਏਵ| ");
INSERT INTO sanpun_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","ਯੂਯੰ ਮੂਲ੍ਯੇਨ ਕ੍ਰੀਤਾ ਅਤੋ ਹੇਤੋ ਰ੍ਮਾਨਵਾਨਾਂ ਦਾਸਾ ਮਾ ਭਵਤ| ");
INSERT INTO sanpun_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","ਹੇ ਭ੍ਰਾਤਰੋ ਯਸ੍ਯਾਮਵਸ੍ਥਾਯਾਂ ਯਸ੍ਯਾਹ੍ਵਾਨਮਭਵਤ੍ ਤਯਾ ਸ ਈਸ਼੍ਵਰਸ੍ਯ ਸਾਕ੍ਸ਼਼ਾਤ੍ ਤਿਸ਼਼੍ਠਤੁ| ");
INSERT INTO sanpun_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","ਅਪਰਮ੍ ਅਕ੍ਰੁʼਤਵਿਵਾਹਾਨ੍ ਜਨਾਨ੍ ਪ੍ਰਤਿ ਪ੍ਰਭੋਃ ਕੋ(ਅ)ਪ੍ਯਾਦੇਸ਼ੋ ਮਯਾ ਨ ਲਬ੍ਧਃ ਕਿਨ੍ਤੁ ਪ੍ਰਭੋਰਨੁਕਮ੍ਪਯਾ ਵਿਸ਼੍ਵਾਸ੍ਯੋ ਭੂਤੋ(ਅ)ਹੰ ਯਦ੍ ਭਦ੍ਰੰ ਮਨ੍ਯੇ ਤਦ੍ ਵਦਾਮਿ| ");
INSERT INTO sanpun_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","ਵਰ੍ੱਤਮਾਨਾਤ੍ ਕ੍ਲੇਸ਼ਸਮਯਾਤ੍ ਮਨੁਸ਼਼੍ਯਸ੍ਯਾਨੂਢਤ੍ਵੰ ਭਦ੍ਰਮਿਤਿ ਮਯਾ ਬੁਧ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","ਤ੍ਵੰ ਕਿੰ ਯੋਸ਼਼ਿਤਿ ਨਿਬੱਧੋ(ਅ)ਸਿ ਤਰ੍ਹਿ ਮੋਚਨੰ ਪ੍ਰਾਪ੍ਤੁੰ ਮਾ ਯਤਸ੍ਵ| ਕਿੰ ਵਾ ਯੋਸ਼਼ਿਤੋ ਮੁਕ੍ਤੋ(ਅ)ਸਿ? ਤਰ੍ਹਿ ਜਾਯਾਂ ਮਾ ਗਵੇਸ਼਼ਯ| ");
INSERT INTO sanpun_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","ਵਿਵਾਹੰ ਕੁਰ੍ੱਵਤਾ ਤ੍ਵਯਾ ਕਿਮਪਿ ਨਾਪਾਰਾਧ੍ਯਤੇ ਤਦ੍ਵਦ੍ ਵ੍ਯੂਹ੍ਯਮਾਨਯਾ ਯੁਵਤ੍ਯਾਪਿ ਕਿਮਪਿ ਨਾਪਰਾਧ੍ਯਤੇ ਤਥਾਚ ਤਾਦ੍ਰੁʼਸ਼ੌ ਦ੍ਵੌ ਜਨੌ ਸ਼ਾਰੀਰਿਕੰ ਕ੍ਲੇਸ਼ੰ ਲਪ੍ਸ੍ਯੇਤੇ ਕਿਨ੍ਤੁ ਯੁਸ਼਼੍ਮਾਨ੍ ਪ੍ਰਤਿ ਮਮ ਕਰੁਣਾ ਵਿਦ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","ਹੇ ਭ੍ਰਾਤਰੋ(ਅ)ਹਮਿਦੰ ਬ੍ਰਵੀਮਿ, ਇਤਃ ਪਰੰ ਸਮਯੋ(ਅ)ਤੀਵ ਸੰਕ੍ਸ਼਼ਿਪ੍ਤਃ, ");
INSERT INTO sanpun_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","ਅਤਃ ਕ੍ਰੁʼਤਦਾਰੈਰਕ੍ਰੁʼਤਦਾਰੈਰਿਵ ਰੁਦਦ੍ਭਿਸ਼੍ਚਾਰੁਦਦ੍ਭਿਰਿਵ ਸਾਨਨ੍ਦੈਸ਼੍ਚ ਨਿਰਾਨਨ੍ਦੈਰਿਵ ਕ੍ਰੇਤ੍ਰੁʼਭਿਸ਼੍ਚਾਭਾਗਿਭਿਰਿਵਾਚਰਿਤਵ੍ਯੰ ");
INSERT INTO sanpun_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","ਯੇ ਚ ਸੰਸਾਰੇ ਚਰਨ੍ਤਿ ਤੈ ਰ੍ਨਾਤਿਚਰਿਤਵ੍ਯੰ ਯਤ ਇਹਲੇाਕਸ੍ਯ ਕੌਤੁਕੋ ਵਿਚਲਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","ਕਿਨ੍ਤੁ ਯੂਯੰ ਯੰਨਿਸ਼੍ਚਿਨ੍ਤਾ ਭਵੇਤੇਤਿ ਮਮ ਵਾਞ੍ਛਾ| ਅਕ੍ਰੁʼਤਵਿਵਾਹੋ ਜਨੋ ਯਥਾ ਪ੍ਰਭੁੰ ਪਰਿਤੋਸ਼਼ਯੇਤ੍ ਤਥਾ ਪ੍ਰਭੁੰ ਚਿਨ੍ਤਯਤਿ, ");
INSERT INTO sanpun_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","ਕਿਨ੍ਤੁ ਕ੍ਰੁʼਤਵਿਵਾਹੋ ਜਨੋ ਯਥਾ ਭਾਰ੍ੱਯਾਂ ਪਰਿਤੋਸ਼਼ਯੇਤ੍ ਤਥਾ ਸੰਸਾਰੰ ਚਿਨ੍ਤਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","ਤਦ੍ਵਦ੍ ਊਢਯੋਸ਼਼ਿਤੋ (ਅ)ਨੂਢਾ ਵਿਸ਼ਿਸ਼਼੍ਯਤੇ| ਯਾਨੂਢਾ ਸਾ ਯਥਾ ਕਾਯਮਨਸੋਃ ਪਵਿਤ੍ਰਾ ਭਵੇਤ੍ ਤਥਾ ਪ੍ਰਭੁੰ ਚਿਨ੍ਤਯਤਿ ਯਾ ਚੋਢਾ ਸਾ ਯਥਾ ਭਰ੍ੱਤਾਰੰ ਪਰਿਤੋਸ਼਼ਯੇਤ੍ ਤਥਾ ਸੰਸਾਰੰ ਚਿਨ੍ਤਯਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","ਅਹੰ ਯਦ੍ ਯੁਸ਼਼੍ਮਾਨ੍ ਮ੍ਰੁʼਗਬਨ੍ਧਿਨ੍ਯਾ ਪਰਿਕ੍ਸ਼਼ਿਪੇਯੰ ਤਦਰ੍ਥੰ ਨਹਿ ਕਿਨ੍ਤੁ ਯੂਯੰ ਯਦਨਿਨ੍ਦਿਤਾ ਭੂਤ੍ਵਾ ਪ੍ਰਭੋਃ ਸੇਵਨੇ(ਅ)ਬਾਧਮ੍ ਆਸਕ੍ਤਾ ਭਵੇਤ ਤਦਰ੍ਥਮੇਤਾਨਿ ਸਰ੍ੱਵਾਣਿ ਯੁਸ਼਼੍ਮਾਕੰ ਹਿਤਾਯ ਮਯਾ ਕਥ੍ਯਨ੍ਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","ਕਸ੍ਯਚਿਤ੍ ਕਨ੍ਯਾਯਾਂ ਯੌਵਨਪ੍ਰਾਪ੍ਤਾਯਾਂ ਯਦਿ ਸ ਤਸ੍ਯਾ ਅਨੂਢਤ੍ਵੰ ਨਿਨ੍ਦਨੀਯੰ ਵਿਵਾਹਸ਼੍ਚ ਸਾਧਯਿਤਵ੍ਯ ਇਤਿ ਮਨ੍ਯਤੇ ਤਰ੍ਹਿ ਯਥਾਭਿਲਾਸ਼਼ੰ ਕਰੋਤੁ, ਏਤੇਨ ਕਿਮਪਿ ਨਾਪਰਾਤ੍ਸ੍ਯਤਿ ਵਿਵਾਹਃ ਕ੍ਰਿਯਤਾਂ| ");
INSERT INTO sanpun_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","ਕਿਨ੍ਤੁ ਦੁਃਖੇਨਾਕ੍ਲਿਸ਼਼੍ਟਃ ਕਸ਼੍ਚਿਤ੍ ਪਿਤਾ ਯਦਿ ਸ੍ਥਿਰਮਨੋਗਤਃ ਸ੍ਵਮਨੋ(ਅ)ਭਿਲਾਸ਼਼ਸਾਧਨੇ ਸਮਰ੍ਥਸ਼੍ਚ ਸ੍ਯਾਤ੍ ਮਮ ਕਨ੍ਯਾ ਮਯਾ ਰਕ੍ਸ਼਼ਿਤਵ੍ਯੇਤਿ ਮਨਸਿ ਨਿਸ਼੍ਚਿਨੋਤਿ ਚ ਤਰ੍ਹਿ ਸ ਭਦ੍ਰੰ ਕਰ੍ੰਮ ਕਰੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","ਅਤੋ ਯੋ ਵਿਵਾਹੰ ਕਰੋਤਿ ਸ ਭਦ੍ਰੰ ਕਰ੍ੰਮ ਕਰੋਤਿ ਯਸ਼੍ਚ ਵਿਵਾਹੰ ਨ ਕਰੋਤਿ ਸ ਭਦ੍ਰਤਰੰ ਕਰ੍ੰਮ ਕਰੋਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","ਯਾਵਤ੍ਕਾਲੰ ਪਤਿ ਰ੍ਜੀਵਤਿ ਤਾਵਦ੍ ਭਾਰ੍ੱਯਾ ਵ੍ਯਵਸ੍ਥਯਾ ਨਿਬੱਧਾ ਤਿਸ਼਼੍ਠਤਿ ਕਿਨ੍ਤੁ ਪਤ੍ਯੌ ਮਹਾਨਿਦ੍ਰਾਂ ਗਤੇ ਸਾ ਮੁਕ੍ਤੀਭੂਯ ਯਮਭਿਲਸ਼਼ਤਿ ਤੇਨ ਸਹ ਤਸ੍ਯਾ ਵਿਵਾਹੋ ਭਵਿਤੁੰ ਸ਼ਕ੍ਨੋਤਿ, ਕਿਨ੍ਤ੍ਵੇਤਤ੍ ਕੇਵਲੰ ਪ੍ਰਭੁਭਕ੍ਤਾਨਾਂ ਮਧ੍ਯੇ| ");
INSERT INTO sanpun_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","ਤਥਾਚ ਸਾ ਯਦਿ ਨਿਸ਼਼੍ਪਤਿਕਾ ਤਿਸ਼਼੍ਠਤਿ ਤਰ੍ਹਿ ਤਸ੍ਯਾਃ ਕ੍ਸ਼਼ੇਮੰ ਭਵਿਸ਼਼੍ਯਤੀਤਿ ਮਮ ਭਾਵਃ| ਅਪਰਮ੍ ਈਸ਼੍ਵਰਸ੍ਯਾਤ੍ਮਾ ਮਮਾਪ੍ਯਨ੍ਤ ਰ੍ਵਿਦ੍ਯਤ ਇਤਿ ਮਯਾ ਬੁਧ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","ਦੇਵਪ੍ਰਸਾਦੇ ਸਰ੍ੱਵੇਸ਼਼ਾਮ੍ ਅਸ੍ਮਾਕੰ ਜ੍ਞਾਨਮਾਸ੍ਤੇ ਤਦ੍ਵਯੰ ਵਿਦ੍ਮਃ| ਤਥਾਪਿ ਜ੍ਞਾਨੰ ਗਰ੍ੱਵੰ ਜਨਯਤਿ ਕਿਨ੍ਤੁ ਪ੍ਰੇਮਤੋ ਨਿਸ਼਼੍ਠਾ ਜਾਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","ਅਤਃ ਕਸ਼੍ਚਨ ਯਦਿ ਮਨ੍ਯਤੇ ਮਮ ਜ੍ਞਾਨਮਾਸ੍ਤ ਇਤਿ ਤਰ੍ਹਿ ਤੇਨ ਯਾਦ੍ਰੁʼਸ਼ੰ ਜ੍ਞਾਨੰ ਚੇਸ਼਼੍ਟਿਤਵ੍ਯੰ ਤਾਦ੍ਰੁʼਸ਼ੰ ਕਿਮਪਿ ਜ੍ਞਾਨਮਦ੍ਯਾਪਿ ਨ ਲਬ੍ਧੰ| ");
INSERT INTO sanpun_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","ਕਿਨ੍ਤੁ ਯ ਈਸ਼੍ਵਰੇ ਪ੍ਰੀਯਤੇ ਸ ਈਸ਼੍ਵਰੇਣਾਪਿ ਜ੍ਞਾਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","ਦੇਵਤਾਬਲਿਪ੍ਰਸਾਦਭਕ੍ਸ਼਼ਣੇ ਵਯਮਿਦੰ ਵਿਦ੍ਮੋ ਯਤ੍ ਜਗਨ੍ਮਧ੍ਯੇ ਕੋ(ਅ)ਪਿ ਦੇਵੋ ਨ ਵਿਦ੍ਯਤੇ, ਏਕਸ਼੍ਚੇਸ਼੍ਵਰੋ ਦ੍ਵਿਤੀਯੋ ਨਾਸ੍ਤੀਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","ਸ੍ਵਰ੍ਗੇ ਪ੍ਰੁʼਥਿਵ੍ਯਾਂ ਵਾ ਯਦ੍ਯਪਿ ਕੇਸ਼਼ੁਚਿਦ੍ ਈਸ਼੍ਵਰ ਇਤਿ ਨਾਮਾਰੋਪ੍ਯਤੇ ਤਾਦ੍ਰੁʼਸ਼ਾਸ਼੍ਚ ਬਹਵ ਈਸ਼੍ਵਰਾ ਬਹਵਸ਼੍ਚ ਪ੍ਰਭਵੋ ਵਿਦ੍ਯਨ੍ਤੇ ");
INSERT INTO sanpun_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","ਤਥਾਪ੍ਯਸ੍ਮਾਕਮਦ੍ਵਿਤੀਯ ਈਸ਼੍ਵਰਃ ਸ ਪਿਤਾ ਯਸ੍ਮਾਤ੍ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਯਦਰ੍ਥਞ੍ਚਾਸ੍ਮਾਕੰ ਸ੍ਰੁʼਸ਼਼੍ਟਿ ਰ੍ਜਾਤਾ, ਅਸ੍ਮਾਕਞ੍ਚਾਦ੍ਵਿਤੀਯਃ ਪ੍ਰਭੁਃ ਸ ਯੀਸ਼ੁਃ ਖ੍ਰੀਸ਼਼੍ਟੋ ਯੇਨ ਸਰ੍ੱਵਵਸ੍ਤੂਨਾਂ ਯੇਨਾਸ੍ਮਾਕਮਪਿ ਸ੍ਰੁʼਸ਼਼੍ਟਿਃ ਕ੍ਰੁʼਤਾ| ");
INSERT INTO sanpun_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","ਅਧਿਕਨ੍ਤੁ ਜ੍ਞਾਨੰ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਨਾਸ੍ਤਿ ਯਤਃ ਕੇਚਿਦਦ੍ਯਾਪਿ ਦੇਵਤਾਂ ਸੰਮਨ੍ਯ ਦੇਵਪ੍ਰਸਾਦਮਿਵ ਤਦ੍ ਭਕ੍ਸ਼਼੍ਯੰ ਭੁਞ੍ਜਤੇ ਤੇਨ ਦੁਰ੍ੱਬਲਤਯਾ ਤੇਸ਼਼ਾਂ ਸ੍ਵਾਨ੍ਤਾਨਿ ਮਲੀਮਸਾਨਿ ਭਵਨ੍ਤਿ| ");
INSERT INTO sanpun_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","ਕਿਨ੍ਤੁ ਭਕ੍ਸ਼਼੍ਯਦ੍ਰਵ੍ਯਾਦ੍ ਵਯਮ੍ ਈਸ਼੍ਵਰੇਣ ਗ੍ਰਾਹ੍ਯਾ ਭਵਾਮਸ੍ਤੰਨਹਿ ਯਤੋ ਭੁਙ੍ਕ੍ਤ੍ਵਾ ਵਯਮੁਤ੍ਕ੍ਰੁʼਸ਼਼੍ਟਾ ਨ ਭਵਾਮਸ੍ਤਦ੍ਵਦਭੁਙ੍ਕ੍ਤ੍ਵਾਪ੍ਯਪਕ੍ਰੁʼਸ਼਼੍ਟਾ ਨ ਭਵਾਮਃ| ");
INSERT INTO sanpun_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","ਅਤੋ ਯੁਸ਼਼੍ਮਾਕੰ ਯਾ ਕ੍ਸ਼਼ਮਤਾ ਸਾ ਦੁਰ੍ੱਬਲਾਨਾਮ੍ ਉਨ੍ਮਾਥਸ੍ਵਰੂਪਾ ਯੰਨ ਭਵੇਤ੍ ਤਦਰ੍ਥੰ ਸਾਵਧਾਨਾ ਭਵਤ| ");
INSERT INTO sanpun_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","ਯਤੋ ਜ੍ਞਾਨਵਿਸ਼ਿਸ਼਼੍ਟਸ੍ਤ੍ਵੰ ਯਦਿ ਦੇਵਾਲਯੇ ਉਪਵਿਸ਼਼੍ਟਃ ਕੇਨਾਪਿ ਦ੍ਰੁʼਸ਼੍ਯਸੇ ਤਰ੍ਹਿ ਤਸ੍ਯ ਦੁਰ੍ੱਬਲਸ੍ਯ ਮਨਸਿ ਕਿੰ ਪ੍ਰਸਾਦਭਕ੍ਸ਼਼ਣ ਉਤ੍ਸਾਹੋ ਨ ਜਨਿਸ਼਼੍ਯਤੇ? ");
INSERT INTO sanpun_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","ਤਥਾ ਸਤਿ ਯਸ੍ਯ ਕ੍ਰੁʼਤੇ ਖ੍ਰੀਸ਼਼੍ਟੋ ਮਮਾਰ ਤਵ ਸ ਦੁਰ੍ੱਬਲੋ ਭ੍ਰਾਤਾ ਤਵ ਜ੍ਞਾਨਾਤ੍ ਕਿੰ ਨ ਵਿਨੰਕ੍ਸ਼਼੍ਯਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","ਇਤ੍ਯਨੇਨ ਪ੍ਰਕਾਰੇਣ ਭ੍ਰਾਤ੍ਰੁʼਣਾਂ ਵਿਰੁੱਧਮ੍ ਅਪਰਾਧ੍ਯਦ੍ਭਿਸ੍ਤੇਸ਼਼ਾਂ ਦੁਰ੍ੱਬਲਾਨਿ ਮਨਾਂਸਿ ਵ੍ਯਾਘਾਤਯਦ੍ਭਿਸ਼੍ਚ ਯੁਸ਼਼੍ਮਾਭਿਃ ਖ੍ਰੀਸ਼਼੍ਟਸ੍ਯ ਵੈਪਰੀਤ੍ਯੇਨਾਪਰਾਧ੍ਯਤੇ| ");
INSERT INTO sanpun_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","ਅਤੋ ਹੇਤੋਃ ਪਿਸ਼ਿਤਾਸ਼ਨੰ ਯਦਿ ਮਮ ਭ੍ਰਾਤੁ ਰ੍ਵਿਘ੍ਨਸ੍ਵਰੂਪੰ ਭਵੇਤ੍ ਤਰ੍ਹ੍ਯਹੰ ਯਤ੍ ਸ੍ਵਭ੍ਰਾਤੁ ਰ੍ਵਿਘ੍ਨਜਨਕੋ ਨ ਭਵੇਯੰ ਤਦਰ੍ਥੰ ਯਾਵੱਜੀਵਨੰ ਪਿਸ਼ਿਤੰ ਨ ਭੋਕ੍ਸ਼਼੍ਯੇ| ");
INSERT INTO sanpun_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","ਅਹੰ ਕਿਮ੍ ਏਕਃ ਪ੍ਰੇਰਿਤੋ ਨਾਸ੍ਮਿ? ਕਿਮਹੰ ਸ੍ਵਤਨ੍ਤ੍ਰੋ ਨਾਸ੍ਮਿ? ਅਸ੍ਮਾਕੰ ਪ੍ਰਭੁ ਰ੍ਯੀਸ਼ੁਃ ਖ੍ਰੀਸ਼਼੍ਟਃ ਕਿੰ ਮਯਾ ਨਾਦਰ੍ਸ਼ਿ? ਯੂਯਮਪਿ ਕਿੰ ਪ੍ਰਭੁਨਾ ਮਦੀਯਸ਼੍ਰਮਫਲਸ੍ਵਰੂਪਾ ਨ ਭਵਥ? ");
INSERT INTO sanpun_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","ਅਨ੍ਯਲੋਕਾਨਾਂ ਕ੍ਰੁʼਤੇ ਯਦ੍ਯਪ੍ਯਹੰ ਪ੍ਰੇਰਿਤੋ ਨ ਭਵੇਯੰ ਤਥਾਚ ਯੁਸ਼਼੍ਮਤ੍ਕ੍ਰੁʼਤੇ ਪ੍ਰੇਰਿਤੋ(ਅ)ਸ੍ਮਿ ਯਤਃ ਪ੍ਰਭੁਨਾ ਮਮ ਪ੍ਰੇਰਿਤਤ੍ਵਪਦਸ੍ਯ ਮੁਦ੍ਰਾਸ੍ਵਰੂਪਾ ਯੂਯਮੇਵਾਧ੍ਵੇ| ");
INSERT INTO sanpun_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","ਯੇ ਲੋਕਾ ਮਯਿ ਦੋਸ਼਼ਮਾਰੋਪਯਨ੍ਤਿ ਤਾਨ੍ ਪ੍ਰਤਿ ਮਮ ਪ੍ਰਤ੍ਯੁੱਤਰਮੇਤਤ੍| ");
INSERT INTO sanpun_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","ਭੋਜਨਪਾਨਯੋਃ ਕਿਮਸ੍ਮਾਕੰ ਕ੍ਸ਼਼ਮਤਾ ਨਾਸ੍ਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","ਅਨ੍ਯੇ ਪ੍ਰੇਰਿਤਾਃ ਪ੍ਰਭੋ ਰ੍ਭ੍ਰਾਤਰੌ ਕੈਫਾਸ਼੍ਚ ਯਤ੍ ਕੁਰ੍ੱਵਨ੍ਤਿ ਤਦ੍ਵਤ੍ ਕਾਞ੍ਚਿਤ੍ ਧਰ੍ੰਮਭਗਿਨੀਂ ਵ੍ਯੂਹ੍ਯ ਤਯਾ ਸਾਰ੍ੱਧੰ ਪਰ੍ੱਯਟਿਤੁੰ ਵਯੰ ਕਿੰ ਨ ਸ਼ਕ੍ਨੁਮਃ? ");
INSERT INTO sanpun_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","ਸਾਂਸਾਰਿਕਸ਼੍ਰਮਸ੍ਯ ਪਰਿਤ੍ਯਾਗਾਤ੍ ਕਿੰ ਕੇਵਲਮਹੰ ਬਰ੍ਣੱਬਾਸ਼੍ਚ ਨਿਵਾਰਿਤੌ? ");
INSERT INTO sanpun_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","ਨਿਜਧਨਵ੍ਯਯੇਨ ਕਃ ਸੰਗ੍ਰਾਮੰ ਕਰੋਤਿ? ਕੋ ਵਾ ਦ੍ਰਾਕ੍ਸ਼਼ਾਕ੍ਸ਼਼ੇਤ੍ਰੰ ਕ੍ਰੁʼਤ੍ਵਾ ਤਤ੍ਫਲਾਨਿ ਨ ਭੁਙ੍ਕ੍ਤੇ? ਕੋ ਵਾ ਪਸ਼ੁਵ੍ਰਜੰ ਪਾਲਯਨ੍ ਤਤ੍ਪਯੋ ਨ ਪਿਵਤਿ? ");
INSERT INTO sanpun_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","ਕਿਮਹੰ ਕੇਵਲਾਂ ਮਾਨੁਸ਼਼ਿਕਾਂ ਵਾਚੰ ਵਦਾਮਿ? ਵ੍ਯਵਸ੍ਥਾਯਾਂ ਕਿਮੇਤਾਦ੍ਰੁʼਸ਼ੰ ਵਚਨੰ ਨ ਵਿਦ੍ਯਤੇ? ");
INSERT INTO sanpun_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","ਮੂਸਾਵ੍ਯਵਸ੍ਥਾਗ੍ਰਨ੍ਥੇ ਲਿਖਿਤਮਾਸ੍ਤੇ, ਤ੍ਵੰ ਸ਼ਸ੍ਯਮਰ੍ੱਦਕਵ੍ਰੁʼਸ਼਼ਸ੍ਯਾਸ੍ਯੰ ਨ ਭੰਤ੍ਸ੍ਯਸੀਤਿ| ਈਸ਼੍ਵਰੇਣ ਬਲੀਵਰ੍ੱਦਾਨਾਮੇਵ ਚਿਨ੍ਤਾ ਕਿੰ ਕ੍ਰਿਯਤੇ? ");
INSERT INTO sanpun_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","ਕਿੰ ਵਾ ਸਰ੍ੱਵਥਾਸ੍ਮਾਕੰ ਕ੍ਰੁʼਤੇ ਤਦ੍ਵਚਨੰ ਤੇਨੋਕ੍ਤੰ? ਅਸ੍ਮਾਕਮੇਵ ਕ੍ਰੁʼਤੇ ਤੱਲਿਖਿਤੰ| ਯਃ ਕ੍ਸ਼਼ੇਤ੍ਰੰ ਕਰ੍ਸ਼਼ਤਿ ਤੇਨ ਪ੍ਰਤ੍ਯਾਸ਼ਾਯੁਕ੍ਤੇਨ ਕਰ੍ਸ਼਼੍ਟਵ੍ਯੰ, ਯਸ਼੍ਚ ਸ਼ਸ੍ਯਾਨਿ ਮਰ੍ੱਦਯਤਿ ਤੇਨ ਲਾਭਪ੍ਰਤ੍ਯਾਸ਼ਾਯੁਕ੍ਤੇਨ ਮਰ੍ੱਦਿਤਵ੍ਯੰ| ");
INSERT INTO sanpun_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","ਯੁਸ਼਼੍ਮਤ੍ਕ੍ਰੁʼਤੇ(ਅ)ਸ੍ਮਾਭਿਃ ਪਾਰਤ੍ਰਿਕਾਣਿ ਬੀਜਾਨਿ ਰੋਪਿਤਾਨਿ, ਅਤੋ ਯੁਸ਼਼੍ਮਾਕਮੈਹਿਕਫਲਾਨਾਂ ਵਯਮ੍ ਅੰਸ਼ਿਨੋ ਭਵਿਸ਼਼੍ਯਾਮਃ ਕਿਮੇਤਤ੍ ਮਹਤ੍ ਕਰ੍ੰਮ? ");
INSERT INTO sanpun_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","ਯੁਸ਼਼੍ਮਾਸੁ ਯੋ(ਅ)ਧਿਕਾਰਸ੍ਤਸ੍ਯ ਭਾਗਿਨੋ ਯਦ੍ਯਨ੍ਯੇ ਭਵੇਯੁਸ੍ਤਰ੍ਹ੍ਯਸ੍ਮਾਭਿਸ੍ਤਤੋ(ਅ)ਧਿਕੰ ਕਿੰ ਤਸ੍ਯ ਭਾਗਿਭਿ ਰ੍ਨ ਭਵਿਤਵ੍ਯੰ? ਅਧਿਕਨ੍ਤੁ ਵਯੰ ਤੇਨਾਧਿਕਾਰੇਣ ਨ ਵ੍ਯਵਹ੍ਰੁʼਤਵਨ੍ਤਃ ਕਿਨ੍ਤੁ ਖ੍ਰੀਸ਼਼੍ਟੀਯਸੁਸੰਵਾਦਸ੍ਯ ਕੋ(ਅ)ਪਿ ਵ੍ਯਾਘਾਤੋ(ਅ)ਸ੍ਮਾਭਿਰ੍ਯੰਨ ਜਾਯੇਤ ਤਦਰ੍ਥੰ ਸਰ੍ੱਵੰ ਸਹਾਮਹੇ| ");
INSERT INTO sanpun_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","ਅਪਰੰ ਯੇ ਪਵਿਤ੍ਰਵਸ੍ਤੂਨਾਂ ਪਰਿਚਰ੍ੱਯਾਂ ਕੁਰ੍ੱਵਨ੍ਤਿ ਤੇ ਪਵਿਤ੍ਰਵਸ੍ਤੁਤੋ ਭਕ੍ਸ਼਼੍ਯਾਣਿ ਲਭਨ੍ਤੇ, ਯੇ ਚ ਵੇਦ੍ਯਾਃ ਪਰਿਚਰ੍ੱਯਾਂ ਕੁਰ੍ੱਵਨ੍ਤਿ ਤੇ ਵੇਦਿਸ੍ਥਵਸ੍ਤੂਨਾਮ੍ ਅੰਸ਼ਿਨੋ ਭਵਨ੍ਤ੍ਯੇਤਦ੍ ਯੂਯੰ ਕਿੰ ਨ ਵਿਦ? ");
INSERT INTO sanpun_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","ਤਦ੍ਵਦ੍ ਯੇ ਸੁਸੰਵਾਦੰ ਘੋਸ਼਼ਯਨ੍ਤਿ ਤੈਃ ਸੁਸੰਵਾਦੇਨ ਜੀਵਿਤਵ੍ਯਮਿਤਿ ਪ੍ਰਭੁਨਾਦਿਸ਼਼੍ਟੰ| ");
INSERT INTO sanpun_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","ਅਹਮੇਤੇਸ਼਼ਾਂ ਸਰ੍ੱਵੇਸ਼਼ਾਂ ਕਿਮਪਿ ਨਾਸ਼੍ਰਿਤਵਾਨ੍ ਮਾਂ ਪ੍ਰਤਿ ਤਦਨੁਸਾਰਾਤ੍ ਆਚਰਿਤਵ੍ਯਮਿਤ੍ਯਾਸ਼ਯੇਨਾਪਿ ਪਤ੍ਰਮਿਦੰ ਮਯਾ ਨ ਲਿਖ੍ਯਤੇ ਯਤਃ ਕੇਨਾਪਿ ਜਨੇਨ ਮਮ ਯਸ਼ਸੋ ਮੁਧਾਕਰਣਾਤ੍ ਮਮ ਮਰਣੰ ਵਰੰ| ");
INSERT INTO sanpun_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","ਸੁਸੰਵਾਦਘੇਸ਼਼ਣਾਤ੍ ਮਮ ਯਸ਼ੋ ਨ ਜਾਯਤੇ ਯਤਸ੍ਤਦ੍ਘੋਸ਼਼ਣੰ ਮਮਾਵਸ਼੍ਯਕੰ ਯਦ੍ਯਹੰ ਸੁਸੰਵਾਦੰ ਨ ਘੋਸ਼਼ਯੇਯੰ ਤਰ੍ਹਿ ਮਾਂ ਧਿਕ੍| ");
INSERT INTO sanpun_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","ਇੱਛੁਕੇਨ ਤਤ੍ ਕੁਰ੍ੱਵਤਾ ਮਯਾ ਫਲੰ ਲਪ੍ਸ੍ਯਤੇ ਕਿਨ੍ਤ੍ਵਨਿੱਛੁਕੇ(ਅ)ਪ