﻿USE sofia;
DROP TABLE IF EXISTS sofia.sanori_vpl;
CREATE TABLE sanori_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sanori_vpl WRITE;
INSERT INTO sanori_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ଇବ୍ରାହୀମଃ ସନ୍ତାନୋ ଦାଯୂଦ୍ ତସ୍ୟ ସନ୍ତାନୋ ଯୀଶୁଖ୍ରୀଷ୍ଟସ୍ତସ୍ୟ ପୂର୍ୱ୍ୱପୁରୁଷୱଂଶଶ୍ରେଣୀ| ");
INSERT INTO sanori_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ଇବ୍ରାହୀମଃ ପୁତ୍ର ଇସ୍ହାକ୍ ତସ୍ୟ ପୁତ୍ରୋ ଯାକୂବ୍ ତସ୍ୟ ପୁତ୍ରୋ ଯିହୂଦାସ୍ତସ୍ୟ ଭ୍ରାତରଶ୍ଚ| ");
INSERT INTO sanori_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ତସ୍ମାଦ୍ ଯିହୂଦାତସ୍ତାମରୋ ଗର୍ଭେ ପେରସ୍ସେରହୌ ଜଜ୍ଞାତେ, ତସ୍ୟ ପେରସଃ ପୁତ୍ରୋ ହିଷ୍ରୋଣ୍ ତସ୍ୟ ପୁତ୍ରୋ ଽରାମ୍| ");
INSERT INTO sanori_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ତସ୍ୟ ପୁତ୍ରୋ ଽମ୍ମୀନାଦବ୍ ତସ୍ୟ ପୁତ୍ରୋ ନହଶୋନ୍ ତସ୍ୟ ପୁତ୍ରଃ ସଲ୍ମୋନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ତସ୍ମାଦ୍ ରାହବୋ ଗର୍ଭେ ବୋଯମ୍ ଜଜ୍ଞେ, ତସ୍ମାଦ୍ ରୂତୋ ଗର୍ଭେ ଓବେଦ୍ ଜଜ୍ଞେ, ତସ୍ୟ ପୁତ୍ରୋ ଯିଶଯଃ| ");
INSERT INTO sanori_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ତସ୍ୟ ପୁତ୍ରୋ ଦାଯୂଦ୍ ରାଜଃ ତସ୍ମାଦ୍ ମୃତୋରିଯସ୍ୟ ଜାଯାଯାଂ ସୁଲେମାନ୍ ଜଜ୍ଞେ| ");
INSERT INTO sanori_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ତସ୍ୟ ପୁତ୍ରୋ ରିହବିଯାମ୍, ତସ୍ୟ ପୁତ୍ରୋଽବିଯଃ, ତସ୍ୟ ପୁତ୍ର ଆସା:| ");
INSERT INTO sanori_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ତସ୍ୟ ସୁତୋ ଯିହୋଶାଫଟ୍ ତସ୍ୟ ସୁତୋ ଯିହୋରାମ ତସ୍ୟ ସୁତ ଉଷିଯଃ| ");
INSERT INTO sanori_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ତସ୍ୟ ସୁତୋ ଯୋଥମ୍ ତସ୍ୟ ସୁତ ଆହମ୍ ତସ୍ୟ ସୁତୋ ହିଷ୍କିଯଃ| ");
INSERT INTO sanori_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ତସ୍ୟ ସୁତୋ ମିନଶିଃ, ତସ୍ୟ ସୁତ ଆମୋନ୍ ତସ୍ୟ ସୁତୋ ଯୋଶିଯଃ| ");
INSERT INTO sanori_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ବାବିଲ୍ନଗରେ ପ୍ରୱସନାତ୍ ପୂର୍ୱ୍ୱଂ ସ ଯୋଶିଯୋ ଯିଖନିଯଂ ତସ୍ୟ ଭ୍ରାତୃଂଶ୍ଚ ଜନଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ତତୋ ବାବିଲି ପ୍ରୱସନକାଲେ ଯିଖନିଯଃ ଶଲ୍ତୀଯେଲଂ ଜନଯାମାସ, ତସ୍ୟ ସୁତଃ ସିରୁବ୍ବାୱିଲ୍| ");
INSERT INTO sanori_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ତସ୍ୟ ସୁତୋ ଽବୋହୁଦ୍ ତସ୍ୟ ସୁତ ଇଲୀଯାକୀମ୍ ତସ୍ୟ ସୁତୋଽସୋର୍| ");
INSERT INTO sanori_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ଅସୋରଃ ସୁତଃ ସାଦୋକ୍ ତସ୍ୟ ସୁତ ଆଖୀମ୍ ତସ୍ୟ ସୁତ ଇଲୀହୂଦ୍| ");
INSERT INTO sanori_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ତସ୍ୟ ସୁତ ଇଲିଯାସର୍ ତସ୍ୟ ସୁତୋ ମତ୍ତନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ତସ୍ୟ ସୁତୋ ଯାକୂବ୍ ତସ୍ୟ ସୁତୋ ଯୂଷଫ୍ ତସ୍ୟ ଜାଯା ମରିଯମ୍; ତସ୍ୟ ଗର୍ଭେ ଯୀଶୁରଜନି, ତମେୱ ଖ୍ରୀଷ୍ଟମ୍ (ଅର୍ଥାଦ୍ ଅଭିଷିକ୍ତଂ) ୱଦନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ଇତ୍ଥମ୍ ଇବ୍ରାହୀମୋ ଦାଯୂଦଂ ଯାୱତ୍ ସାକଲ୍ୟେନ ଚତୁର୍ଦଶପୁରୁଷାଃ; ଆ ଦାଯୂଦଃ କାଲାଦ୍ ବାବିଲି ପ୍ରୱସନକାଲଂ ଯାୱତ୍ ଚତୁର୍ଦଶପୁରୁଷା ଭୱନ୍ତି| ବାବିଲି ପ୍ରୱାସନକାଲାତ୍ ଖ୍ରୀଷ୍ଟସ୍ୟ କାଲଂ ଯାୱତ୍ ଚତୁର୍ଦଶପୁରୁଷା ଭୱନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","ଯୀଶୁଖ୍ରୀଷ୍ଟସ୍ୟ ଜନ୍ମ କଥ୍ଥତେ| ମରିଯମ୍ ନାମିକା କନ୍ୟା ଯୂଷଫେ ୱାଗ୍ଦତ୍ତାସୀତ୍, ତଦା ତଯୋଃ ସଙ୍ଗମାତ୍ ପ୍ରାକ୍ ସା କନ୍ୟା  ପୱିତ୍ରେଣାତ୍ମନା ଗର୍ଭୱତୀ ବଭୂୱ| ");
INSERT INTO sanori_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ତତ୍ର ତସ୍ୟାଃ ପତି ର୍ୟୂଷଫ୍ ସୌଜନ୍ୟାତ୍ ତସ୍ୟାଃ କଲଙ୍ଗଂ ପ୍ରକାଶଯିତୁମ୍ ଅନିଚ୍ଛନ୍ ଗୋପନେନେ ତାଂ ପାରିତ୍ୟକ୍ତୁଂ ମନଶ୍ଚକ୍ରେ| ");
INSERT INTO sanori_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ସ ତଥୈୱ ଭାୱଯତି, ତଦାନୀଂ ପରମେଶ୍ୱରସ୍ୟ ଦୂତଃ ସ୍ୱପ୍ନେ ତଂ ଦର୍ଶନଂ ଦତ୍ତ୍ୱା ୱ୍ୟାଜହାର, ହେ ଦାଯୂଦଃ ସନ୍ତାନ ଯୂଷଫ୍ ତ୍ୱଂ ନିଜାଂ ଜାଯାଂ ମରିଯମମ୍ ଆଦାତୁଂ ମା ଭୈଷୀଃ| ");
INSERT INTO sanori_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","ଯତସ୍ତସ୍ୟା ଗର୍ଭଃ ପୱିତ୍ରାଦାତ୍ମନୋଽଭୱତ୍, ସା ଚ ପୁତ୍ରଂ ପ୍ରସୱିଷ୍ୟତେ, ତଦା ତ୍ୱଂ ତସ୍ୟ ନାମ ଯୀଶୁମ୍ (ଅର୍ଥାତ୍ ତ୍ରାତାରଂ) କରୀଷ୍ୟସେ, ଯସ୍ମାତ୍ ସ ନିଜମନୁଜାନ୍ ତେଷାଂ କଲୁଷେଭ୍ୟ ଉଦ୍ଧରିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ଇତ୍ଥଂ ସତି, ପଶ୍ୟ ଗର୍ଭୱତୀ କନ୍ୟା ତନଯଂ ପ୍ରସୱିଷ୍ୟତେ| ଇମ୍ମାନୂଯେଲ୍ ତଦୀଯଞ୍ଚ ନାମଧେଯଂ ଭୱିଷ୍ୟତି|| ଇମ୍ମାନୂଯେଲ୍ ଅସ୍ମାକଂ ସଙ୍ଗୀଶ୍ୱରଇତ୍ୟର୍ଥଃ| ");
INSERT INTO sanori_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","ଇତି ଯଦ୍ ୱଚନଂ ପୁର୍ୱ୍ୱଂ ଭୱିଷ୍ୟଦ୍ୱକ୍ତ୍ରା ଈଶ୍ୱରଃ କଥାଯାମାସ, ତତ୍ ତଦାନୀଂ ସିଦ୍ଧମଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ଅନନ୍ତରଂ ଯୂଷଫ୍ ନିଦ୍ରାତୋ ଜାଗରିତ ଉତ୍ଥାଯ ପରମେଶ୍ୱରୀଯଦୂତସ୍ୟ ନିଦେଶାନୁସାରେଣ ନିଜାଂ ଜାଯାଂ ଜଗ୍ରାହ, ");
INSERT INTO sanori_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","କିନ୍ତୁ ଯାୱତ୍ ସା ନିଜଂ ପ୍ରଥମସୁତଂ ଅ ସୁଷୁୱେ, ତାୱତ୍ ତାଂ ନୋପାଗଚ୍ଛତ୍, ତତଃ ସୁତସ୍ୟ ନାମ ଯୀଶୁଂ ଚକ୍ରେ| ");
INSERT INTO sanori_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","ଅନନ୍ତରଂ ହେରୋଦ୍ ସଂଜ୍ଞକେ ରାଜ୍ଞି ରାଜ୍ୟଂ ଶାସତି ଯିହୂଦୀଯଦେଶସ୍ୟ ବୈତ୍ଲେହମି ନଗରେ ଯୀଶୌ ଜାତୱତି ଚ, କତିପଯା ଜ୍ୟୋତିର୍ୱ୍ୱୁଦଃ ପୂର୍ୱ୍ୱସ୍ୟା ଦିଶୋ ଯିରୂଶାଲମ୍ନଗରଂ ସମେତ୍ୟ କଥଯମାସୁଃ, ");
INSERT INTO sanori_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ଯୋ ଯିହୂଦୀଯାନାଂ ରାଜା ଜାତୱାନ୍, ସ କୁତ୍ରାସ୍ତେ? ୱଯଂ ପୂର୍ୱ୍ୱସ୍ୟାଂ ଦିଶି ତିଷ୍ଠନ୍ତସ୍ତଦୀଯାଂ ତାରକାମ୍ ଅପଶ୍ୟାମ ତସ୍ମାତ୍ ତଂ ପ୍ରଣନ୍ତୁମ୍ ଅाଗମାମ| ");
INSERT INTO sanori_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ତଦା ହେରୋଦ୍ ରାଜା କଥାମେତାଂ ନିଶମ୍ୟ ଯିରୂଶାଲମ୍ନଗରସ୍ଥିତୈଃ ସର୍ୱ୍ୱମାନୱୈଃ ସାର୍ଦ୍ଧମ୍ ଉଦ୍ୱିଜ୍ୟ ");
INSERT INTO sanori_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ସର୍ୱ୍ୱାନ୍ ପ୍ରଧାନଯାଜକାନ୍ ଅଧ୍ୟାପକାଂଶ୍ଚ ସମାହୂଯାନୀଯ ପପ୍ରଚ୍ଛ, ଖ୍ରୀଷ୍ଟଃ କୁତ୍ର ଜନିଷ୍ୟତେ? ");
INSERT INTO sanori_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ତଦା ତେ କଥଯାମାସୁଃ, ଯିହୂଦୀଯଦେଶସ୍ୟ ବୈତ୍ଲେହମି ନଗରେ, ଯତୋ ଭୱିଷ୍ୟଦ୍ୱାଦିନା ଇତ୍ଥଂ ଲିଖିତମାସ୍ତେ, ");
INSERT INTO sanori_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","ସର୍ୱ୍ୱାଭ୍ୟୋ ରାଜଧାନୀଭ୍ୟୋ ଯିହୂଦୀଯସ୍ୟ ନୀୱୃତଃ| ହେ ଯୀହୂଦୀଯଦେଶସ୍ୟେ ବୈତ୍ଲେହମ୍ ତ୍ୱଂ ନ ଚାୱରା| ଇସ୍ରାଯେଲୀଯଲୋକାନ୍ ମେ ଯତୋ ଯଃ ପାଲଯିଷ୍ୟତି| ତାଦୃଗେକୋ ମହାରାଜସ୍ତ୍ୱନ୍ମଧ୍ୟ ଉଦ୍ଭୱିଷ୍ୟତୀ|| ");
INSERT INTO sanori_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","ତଦାନୀଂ ହେରୋଦ୍ ରାଜା ତାନ୍ ଜ୍ୟୋତିର୍ୱ୍ୱିଦୋ ଗୋପନମ୍ ଆହୂଯ ସା ତାରକା କଦା ଦୃଷ୍ଟାଭୱତ୍ , ତଦ୍ ୱିନିଶ୍ଚଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ଅପରଂ ତାନ୍ ବୈତ୍ଲେହମଂ ପ୍ରହୀତ୍ୟ ଗଦିତୱାନ୍, ଯୂଯଂ ଯାତ, ଯତ୍ନାତ୍ ତଂ ଶିଶୁମ୍ ଅନ୍ୱିଷ୍ୟ ତଦୁଦ୍ଦେଶେ ପ୍ରାପ୍ତେ ମହ୍ୟଂ ୱାର୍ତ୍ତାଂ ଦାସ୍ୟଥ, ତତୋ ମଯାପି ଗତ୍ୱା ସ ପ୍ରଣଂସ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","ତଦାନୀଂ ରାଜ୍ଞ ଏତାଦୃଶୀମ୍ ଆଜ୍ଞାଂ ପ୍ରାପ୍ୟ ତେ ପ୍ରତସ୍ଥିରେ, ତତଃ ପୂର୍ୱ୍ୱର୍ସ୍ୟାଂ ଦିଶି ସ୍ଥିତୈସ୍ତୈ ର୍ୟା ତାରକା ଦୃଷ୍ଟା ସା ତାରକା ତେଷାମଗ୍ରେ ଗତ୍ୱା ଯତ୍ର ସ୍ଥାନେ ଶିଶୂରାସ୍ତେ, ତସ୍ୟ ସ୍ଥାନସ୍ୟୋପରି ସ୍ଥଗିତା ତସ୍ୟୌ| ");
INSERT INTO sanori_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ତଦ୍ ଦୃଷ୍ଟ୍ୱା ତେ ମହାନନ୍ଦିତା ବଭୂୱୁଃ, ");
INSERT INTO sanori_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ତତୋ ଗେହମଧ୍ୟ ପ୍ରୱିଶ୍ୟ ତସ୍ୟ ମାତ୍ରା ମରିଯମା ସାଦ୍ଧଂ ତଂ ଶିଶୁଂ ନିରୀକ୍ଷଯ ଦଣ୍ଡୱଦ୍ ଭୂତ୍ୱା ପ୍ରଣେମୁଃ, ଅପରଂ ସ୍ୱେଷାଂ ଘନସମ୍ପତ୍ତିଂ ମୋଚଯିତ୍ୱା ସୁୱର୍ଣଂ କୁନ୍ଦୁରୁଂ ଗନ୍ଧରମଞ୍ଚ ତସ୍ମୈ ଦର୍ଶନୀଯଂ ଦତ୍ତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ପଶ୍ଚାଦ୍ ହେରୋଦ୍ ରାଜସ୍ୟ ସମୀପଂ ପୁନରପି ଗନ୍ତୁଂ ସ୍ୱପ୍ନ ଈଶ୍ୱରେଣ ନିଷିଦ୍ଧାଃ ସନ୍ତୋ ଽନ୍ୟେନ ପଥା ତେ ନିଜଦେଶଂ ପ୍ରତି ପ୍ରତସ୍ଥିରେ| ");
INSERT INTO sanori_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","ଅନନ୍ତରଂ ତେଷୁ ଗତୱତ୍ମୁ ପରମେଶ୍ୱରସ୍ୟ ଦୂତୋ ଯୂଷଫେ ସ୍ୱପ୍ନେ ଦର୍ଶନଂ ଦତ୍ୱା ଜଗାଦ, ତ୍ୱମ୍ ଉତ୍ଥାଯ ଶିଶୁଂ ତନ୍ମାତରଞ୍ଚ ଗୃହୀତ୍ୱା ମିସର୍ଦେଶଂ ପଲାଯସ୍ୱ, ଅପରଂ ଯାୱଦହଂ ତୁଭ୍ୟଂ ୱାର୍ତ୍ତାଂ ନ କଥଯିଷ୍ୟାମି, ତାୱତ୍ ତତ୍ରୈୱ ନିୱସ, ଯତୋ ରାଜା ହେରୋଦ୍ ଶିଶୁଂ ନାଶଯିତୁଂ ମୃଗଯିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ତଦାନୀଂ ଯୂଷଫ୍ ଉତ୍ଥାଯ ରଜନ୍ୟାଂ ଶିଶୁଂ ତନ୍ମାତରଞ୍ଚ ଗୃହୀତ୍ୱା ମିସର୍ଦେଶଂ ପ୍ରତି ପ୍ରତସ୍ଥେ, ");
INSERT INTO sanori_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ଗତ୍ୱା ଚ ହେରୋଦୋ ନୃପତେ ର୍ମରଣପର୍ୟ୍ୟନ୍ତଂ ତତ୍ର ଦେଶେ ନ୍ୟୁୱାସ, ତେନ ମିସର୍ଦେଶାଦହଂ ପୁତ୍ରଂ ସ୍ୱକୀଯଂ ସମୁପାହୂଯମ୍| ଯଦେତଦ୍ୱଚନମ୍ ଈଶ୍ୱରେଣ ଭୱିଷ୍ୟଦ୍ୱାଦିନା କଥିତଂ ତତ୍ ସଫଲମଭୂତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","ଅନନ୍ତରଂ ହେରୋଦ୍ ଜ୍ୟୋତିର୍ୱିଦ୍ଭିରାତ୍ମାନଂ ପ୍ରୱଞ୍ଚିତଂ ୱିଜ୍ଞାଯ ଭୃଶଂ ଚୁକୋପ; ଅପରଂ ଜ୍ୟୋତିର୍ୱ୍ୱିଦ୍ଭ୍ୟସ୍ତେନ ୱିନିଶ୍ଚିତଂ ଯଦ୍ ଦିନଂ ତଦ୍ଦିନାଦ୍ ଗଣଯିତ୍ୱା ଦ୍ୱିତୀଯୱତ୍ସରଂ ପ୍ରୱିଷ୍ଟା ଯାୱନ୍ତୋ ବାଲକା ଅସ୍ମିନ୍ ବୈତ୍ଲେହମ୍ନଗରେ ତତ୍ସୀମମଧ୍ୟେ ଚାସନ୍, ଲୋକାନ୍ ପ୍ରହିତ୍ୟ ତାନ୍ ସର୍ୱ୍ୱାନ୍ ଘାତଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ଅତଃ ଅନେକସ୍ୟ ୱିଲାପସ୍ୟ ନିନାଦ: କ୍ରନ୍ଦନସ୍ୟ ଚ| ଶୋକେନ କୃତଶବ୍ଦଶ୍ଚ ରାମାଯାଂ ସଂନିଶମ୍ୟତେ| ସ୍ୱବାଲଗଣହେତୋର୍ୱୈ ରାହେଲ୍ ନାରୀ ତୁ ରୋଦିନୀ| ନ ମନ୍ୟତେ ପ୍ରବୋଧନ୍ତୁ ଯତସ୍ତେ ନୈୱ ମନ୍ତି ହି|| ");
INSERT INTO sanori_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","ଯଦେତଦ୍ ୱଚନଂ ଯିରୀମିଯନାମକଭୱିଷ୍ୟଦ୍ୱାଦିନା କଥିତଂ ତତ୍ ତଦାନୀଂ ସଫଲମ୍ ଅଭୂତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ତଦନନ୍ତରଂ ହେରେଦି ରାଜନି ମୃତେ ପରମେଶ୍ୱରସ୍ୟ ଦୂତୋ ମିସର୍ଦେଶେ ସ୍ୱପ୍ନେ ଦର୍ଶନଂ ଦତ୍ତ୍ୱା ଯୂଷଫେ କଥିତୱାନ୍ ");
INSERT INTO sanori_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ତ୍ୱମ୍ ଉତ୍ଥାଯ ଶିଶୁଂ ତନ୍ମାତରଞ୍ଚ ଗୃହୀତ୍ୱା ପୁନରପୀସ୍ରାଯେଲୋ ଦେଶଂ ଯାହୀ, ଯେ ଜନାଃ ଶିଶୁଂ ନାଶଯିତୁମ୍ ଅମୃଗଯନ୍ତ, ତେ ମୃତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ତଦାନୀଂ ସ ଉତ୍ଥାଯ ଶିଶୁଂ ତନ୍ମାତରଞ୍ଚ ଗୃହ୍ଲନ୍ ଇସ୍ରାଯେଲ୍ଦେଶମ୍ ଆଜଗାମ| ");
INSERT INTO sanori_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","କିନ୍ତୁ ଯିହୂଦୀଯଦେଶେ ଅର୍ଖିଲାଯନାମ ରାଜକୁମାରୋ ନିଜପିତୁ ର୍ହେରୋଦଃ ପଦଂ ପ୍ରାପ୍ୟ ରାଜତ୍ୱଂ କରୋତୀତି ନିଶମ୍ୟ ତତ୍ ସ୍ଥାନଂ ଯାତୁଂ ଶଙ୍କିତୱାନ୍, ପଶ୍ଚାତ୍ ସ୍ୱପ୍ନ ଈଶ୍ୱରାତ୍ ପ୍ରବୋଧଂ ପ୍ରାପ୍ୟ ଗାଲୀଲ୍ଦେଶସ୍ୟ ପ୍ରଦେଶୈକଂ ପ୍ରସ୍ଥାଯ ନାସରନ୍ନାମ ନଗରଂ ଗତ୍ୱା ତତ୍ର ନ୍ୟୁଷିତୱାନ୍, ");
INSERT INTO sanori_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ତେନ ତଂ ନାସରତୀଯଂ କଥଯିଷ୍ୟନ୍ତି, ଯଦେତଦ୍ୱାକ୍ୟଂ ଭୱିଷ୍ୟଦ୍ୱାଦିଭିରୁକ୍ତ୍ତଂ ତତ୍ ସଫଲମଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","ତଦାନୋଂ ଯୋହ୍ନ୍ନାମା ମଜ୍ଜଯିତା ଯିହୂଦୀଯଦେଶସ୍ୟ ପ୍ରାନ୍ତରମ୍ ଉପସ୍ଥାଯ ପ୍ରଚାରଯନ୍ କଥଯାମାସ, ");
INSERT INTO sanori_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ମନାଂସି ପରାୱର୍ତ୍ତଯତ, ସ୍ୱର୍ଗୀଯରାଜତ୍ୱଂ ସମୀପମାଗତମ୍| ");
INSERT INTO sanori_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ପରମେଶସ୍ୟ ପନ୍ଥାନଂ ପରିଷ୍କୁରୁତ ସର୍ୱ୍ୱତଃ| ତସ୍ୟ ରାଜପଥାଂଶ୍ଚୈୱ ସମୀକୁରୁତ ସର୍ୱ୍ୱଥା| ଇତ୍ୟେତତ୍ ପ୍ରାନ୍ତରେ ୱାକ୍ୟଂ ୱଦତଃ କସ୍ୟଚିଦ୍ ରୱଃ|| ");
INSERT INTO sanori_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ଏତଦ୍ୱଚନଂ ଯିଶଯିଯଭୱିଷ୍ୟଦ୍ୱାଦିନା ଯୋହନମୁଦ୍ଦିଶ୍ୟ ଭାଷିତମ୍| ଯୋହନୋ ୱସନଂ ମହାଙ୍ଗରୋମଜଂ ତସ୍ୟ କଟୌ ଚର୍ମ୍ମକଟିବନ୍ଧନଂ; ସ ଚ ଶୂକକୀଟାନ୍ ମଧୁ ଚ ଭୁକ୍ତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","ତଦାନୀଂ ଯିରୂଶାଲମ୍ନଗରନିୱାସିନଃ ସର୍ୱ୍ୱେ ଯିହୂଦିଦେଶୀଯା ଯର୍ଦ୍ଦନ୍ତଟିନ୍ୟା ଉଭଯତଟସ୍ଥାଶ୍ଚ ମାନୱା ବହିରାଗତ୍ୟ ତସ୍ୟ ସମୀପେ ");
INSERT INTO sanori_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ସ୍ୱୀଯଂ ସ୍ୱୀଯଂ ଦୁରିତମ୍ ଅଙ୍ଗୀକୃତ୍ୟ ତସ୍ୟାଂ ଯର୍ଦ୍ଦନି ତେନ ମଜ୍ଜିତା ବଭୂୱୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ଅପରଂ ବହୂନ୍ ଫିରୂଶିନଃ ସିଦୂକିନଶ୍ଚ ମନୁଜାନ୍ ମଂକ୍ତୁଂ ସ୍ୱସମୀପମ୍ ଆଗଚ୍ଛ୍ତୋ ୱିଲୋକ୍ୟ ସ ତାନ୍ ଅଭିଦଧୌ, ରେ ରେ ଭୁଜଗୱଂଶା ଆଗାମୀନଃ କୋପାତ୍ ପଲାଯିତୁଂ ଯୁଷ୍ମାନ୍ କଶ୍ଚେତିତୱାନ୍? ");
INSERT INTO sanori_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","ମନଃପରାୱର୍ତ୍ତନସ୍ୟ ସମୁଚିତଂ ଫଲଂ ଫଲତ| ");
INSERT INTO sanori_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","କିନ୍ତ୍ୱସ୍ମାକଂ ତାତ ଇବ୍ରାହୀମ୍ ଅସ୍ତୀତି ସ୍ୱେଷୁ ମନଃସୁ ଚୀନ୍ତଯନ୍ତୋ ମା ୱ୍ୟାହରତ| ଯତୋ ଯୁଷ୍ମାନ୍ ଅହଂ ୱଦାମି, ଈଶ୍ୱର ଏତେଭ୍ୟଃ ପାଷାଣେଭ୍ୟ ଇବ୍ରାହୀମଃ ସନ୍ତାନାନ୍ ଉତ୍ପାଦଯିତୁଂ ଶକ୍ନୋତି| ");
INSERT INTO sanori_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ଅପରଂ ପାଦପାନାଂ ମୂଲେ କୁଠାର ଇଦାନୀମପି ଲଗନ୍ ଆସ୍ତେ, ତସ୍ମାଦ୍ ଯସ୍ମିନ୍ ପାଦପେ ଉତ୍ତମଂ ଫଲଂ ନ ଭୱତି, ସ କୃତ୍ତୋ ମଧ୍ୟେଽଗ୍ନିଂ ନିକ୍ଷେପ୍ସ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","ଅପରମ୍ ଅହଂ ମନଃପରାୱର୍ତ୍ତନସୂଚକେନ ମଜ୍ଜନେନ ଯୁଷ୍ମାନ୍ ମଜ୍ଜଯାମୀତି ସତ୍ୟଂ, କିନ୍ତୁ ମମ ପଶ୍ଚାଦ୍ ଯ ଆଗଚ୍ଛତି, ସ ମତ୍ତୋପି ମହାନ୍, ଅହଂ ତଦୀଯୋପାନହୌ ୱୋଢୁମପି ନହି ଯୋଗ୍ୟୋସ୍ମି, ସ ଯୁଷ୍ମାନ୍ ୱହ୍ନିରୂପେ ପୱିତ୍ର ଆତ୍ମନି ସଂମଜ୍ଜଯିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ତସ୍ୟ କାରେ ସୂର୍ପ ଆସ୍ତେ, ସ ସ୍ୱୀଯଶସ୍ୟାନି ସମ୍ୟକ୍ ପ୍ରସ୍ଫୋଟ୍ୟ ନିଜାନ୍ ସକଲଗୋଧୂମାନ୍ ସଂଗୃହ୍ୟ ଭାଣ୍ଡାଗାରେ ସ୍ଥାପଯିଷ୍ୟତି, କିଂନ୍ତୁ ସର୍ୱ୍ୱାଣି ୱୁଷାଣ୍ୟନିର୍ୱ୍ୱାଣୱହ୍ନିନା ଦାହଯିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","ଅନନ୍ତରଂ ଯୀଶୁ ର୍ୟୋହନା ମଜ୍ଜିତୋ ଭୱିତୁଂ ଗାଲୀଲ୍ପ୍ରଦେଶାଦ୍ ଯର୍ଦ୍ଦନି ତସ୍ୟ ସମୀପମ୍ ଆଜଗାମ| ");
INSERT INTO sanori_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","କିନ୍ତୁ ଯୋହନ୍ ତଂ ନିଷିଧ୍ୟ ବଭାଷେ, ତ୍ୱଂ କିଂ ମମ ସମୀପମ୍ ଆଗଚ୍ଛସି? ୱରଂ ତ୍ୱଯା ମଜ୍ଜନଂ ମମ ପ୍ରଯୋଜନମ୍ ଆସ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ତଦାନୀଂ ଯୀଶୁଃ ପ୍ରତ୍ୟୱୋଚତ୍; ଈଦାନୀମ୍ ଅନୁମନ୍ୟସ୍ୱ, ଯତ ଇତ୍ଥଂ ସର୍ୱ୍ୱଧର୍ମ୍ମସାଧନମ୍ ଅସ୍ମାକଂ କର୍ତ୍ତୱ୍ୟଂ, ତତଃ ସୋଽନ୍ୱମନ୍ୟତ| ");
INSERT INTO sanori_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ଅନନ୍ତରଂ ଯୀଶୁରମ୍ମସି ମଜ୍ଜିତୁଃ ସନ୍ ତତ୍କ୍ଷଣାତ୍ ତୋଯମଧ୍ୟାଦ୍ ଉତ୍ଥାଯ ଜଗାମ, ତଦା ଜୀମୂତଦ୍ୱାରେ ମୁକ୍ତେ ଜାତେ, ସ ଈଶ୍ୱରସ୍ୟାତ୍ମାନଂ କପୋତୱଦ୍ ଅୱରୁହ୍ୟ ସ୍ୱୋପର୍ୟ୍ୟାଗଚ୍ଛନ୍ତଂ ୱୀକ୍ଷାଞ୍ଚକ୍ରେ| ");
INSERT INTO sanori_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ଅପରମ୍ ଏଷ ମମ ପ୍ରିଯଃ ପୁତ୍ର ଏତସ୍ମିନ୍ନେୱ ମମ ମହାସନ୍ତୋଷ ଏତାଦୃଶୀ ୱ୍ୟୋମଜା ୱାଗ୍ ବଭୂୱ| ");
INSERT INTO sanori_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","ତତଃ ପରଂ ଯୀଶୁଃ ପ୍ରତାରକେଣ ପରୀକ୍ଷିତୋ ଭୱିତୁମ୍ ଆତ୍ମନା ପ୍ରାନ୍ତରମ୍ ଆକୃଷ୍ଟଃ ");
INSERT INTO sanori_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ସନ୍ ଚତ୍ୱାରିଂଶଦହୋରାତ୍ରାନ୍ ଅନାହାରସ୍ତିଷ୍ଠନ୍ କ୍ଷୁଧିତୋ ବଭୂୱ| ");
INSERT INTO sanori_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ତଦାନୀଂ ପରୀକ୍ଷିତା ତତ୍ସମୀପମ୍ ଆଗତ୍ୟ ୱ୍ୟାହୃତୱାନ୍, ଯଦି ତ୍ୱମୀଶ୍ୱରାତ୍ମଜୋ ଭୱେସ୍ତର୍ହ୍ୟାଜ୍ଞଯା ପାଷାଣାନେତାନ୍ ପୂପାନ୍ ୱିଧେହି| ");
INSERT INTO sanori_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","ତତଃ ସ ପ୍ରତ୍ୟବ୍ରୱୀତ୍, ଇତ୍ଥଂ ଲିଖିତମାସ୍ତେ, \"ମନୁଜଃ କେୱଲପୂପେନ ନ ଜୀୱିଷ୍ୟତି, କିନ୍ତ୍ୱୀଶ୍ୱରସ୍ୟ ୱଦନାଦ୍ ଯାନି ଯାନି ୱଚାଂସି ନିଃସରନ୍ତି ତୈରେୱ ଜୀୱିଷ୍ୟତି| \" ");
INSERT INTO sanori_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","ତଦା ପ୍ରତାରକସ୍ତଂ ପୁଣ୍ୟନଗରଂ ନୀତ୍ୱା ମନ୍ଦିରସ୍ୟ ଚୂଡୋପରି ନିଧାଯ ଗଦିତୱାନ୍, ");
INSERT INTO sanori_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ତ୍ୱଂ ଯଦିଶ୍ୱରସ୍ୟ ତନଯୋ ଭୱେସ୍ତର୍ହୀତୋଽଧଃ ପତ, ଯତ ଇତ୍ଥଂ ଲିଖିତମାସ୍ତେ, ଆଦେକ୍ଷ୍ୟତି ନିଜାନ୍ ଦୂତାନ୍ ରକ୍ଷିତୁଂ ତ୍ୱାଂ ପରମେଶ୍ୱରଃ| ଯଥା ସର୍ୱ୍ୱେଷୁ ମାର୍ଗେଷୁ ତ୍ୱଦୀଯଚରଣଦ୍ୱଯେ| ନ ଲଗେତ୍ ପ୍ରସ୍ତରାଘାତସ୍ତ୍ୱାଂ ଘରିଷ୍ୟନ୍ତି ତେ କରୈଃ|| ");
INSERT INTO sanori_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ତଦାନୀଂ ଯୀଶୁସ୍ତସ୍ମୈ କଥିତୱାନ୍ ଏତଦପି ଲିଖିତମାସ୍ତେ, \"ତ୍ୱଂ ନିଜପ୍ରଭୁଂ ପରମେଶ୍ୱରଂ ମା ପରୀକ୍ଷସ୍ୱ| \" ");
INSERT INTO sanori_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","ଅନନ୍ତରଂ ପ୍ରତାରକଃ ପୁନରପି ତମ୍ ଅତ୍ୟୁଞ୍ଚଧରାଧରୋପରି ନୀତ୍ୱା ଜଗତଃ ସକଲରାଜ୍ୟାନି ତଦୈଶ୍ୱର୍ୟ୍ୟାଣି ଚ ଦର୍ଶଯାଶ୍ଚକାର କଥଯାଞ୍ଚକାର ଚ, ");
INSERT INTO sanori_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ଯଦି ତ୍ୱଂ ଦଣ୍ଡୱଦ୍ ଭୱନ୍ ମାଂ ପ୍ରଣମେସ୍ତର୍ହ୍ୟହମ୍ ଏତାନି ତୁଭ୍ୟଂ ପ୍ରଦାସ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ତଦାନୀଂ ଯୀଶୁସ୍ତମୱୋଚତ୍, ଦୂରୀଭୱ ପ୍ରତାରକ, ଲିଖିତମିଦମ୍ ଆସ୍ତେ, \"ତ୍ୱଯା ନିଜଃ ପ୍ରଭୁଃ ପରମେଶ୍ୱରଃ ପ୍ରଣମ୍ୟଃ କେୱଲଃ ସ ସେୱ୍ୟଶ୍ଚ| \" ");
INSERT INTO sanori_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ତତଃ ପ୍ରତାରକେଣ ସ ପର୍ୟ୍ୟତ୍ୟାଜି, ତଦା ସ୍ୱର୍ଗୀଯଦୂତୈରାଗତ୍ୟ ସ ସିଷେୱେ| ");
INSERT INTO sanori_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","ତଦନନ୍ତରଂ ଯୋହନ୍ କାରାଯାଂ ବବନ୍ଧେ, ତଦ୍ୱାର୍ତ୍ତାଂ ନିଶମ୍ୟ ଯୀଶୁନା ଗାଲୀଲ୍ ପ୍ରାସ୍ଥୀଯତ| ");
INSERT INTO sanori_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ତତଃ ପରଂ ସ ନାସରନ୍ନଗରଂ ୱିହାଯ ଜଲଘେସ୍ତଟେ ସିବୂଲୂନ୍ନପ୍ତାଲୀ ଏତଯୋରୁୱଭଯୋଃ ପ୍ରଦେଶଯୋଃ ସୀମ୍ନୋର୍ମଧ୍ୟୱର୍ତ୍ତୀ ଯ: କଫର୍ନାହୂମ୍ ତନ୍ନଗରମ୍ ଇତ୍ୱା ନ୍ୟୱସତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ତସ୍ମାତ୍, ଅନ୍ୟାଦେଶୀଯଗାଲୀଲି ଯର୍ଦ୍ଦନ୍ପାରେଽବ୍ଧିରୋଧସି| ନପ୍ତାଲିସିବୂଲୂନ୍ଦେଶୌ ଯତ୍ର ସ୍ଥାନେ ସ୍ଥିତୌ ପୁରା| ");
INSERT INTO sanori_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","ତତ୍ରତ୍ୟା ମନୁଜା ଯେ ଯେ ପର୍ୟ୍ୟଭ୍ରାମ୍ୟନ୍ ତମିସ୍ରକେ| ତୈର୍ଜନୈର୍ବୃହଦାଲୋକଃ ପରିଦର୍ଶିଷ୍ୟତେ ତଦା| ଅୱସନ୍ ଯେ ଜନା ଦେଶେ ମୃତ୍ୟୁଚ୍ଛାଯାସ୍ୱରୂପକେ| ତେଷାମୁପରି ଲୋକାନାମାଲୋକଃ ସଂପ୍ରକାଶିତଃ|| ");
INSERT INTO sanori_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ଯଦେତଦ୍ୱଚନଂ ଯିଶଯିଯଭୱିଷ୍ୟଦ୍ୱାଦିନା ପ୍ରୋକ୍ତଂ, ତତ୍ ତଦା ସଫଲମ୍ ଅଭୂତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","ଅନନ୍ତରଂ ଯୀଶୁଃ ସୁସଂୱାଦଂ ପ୍ରଚାରଯନ୍ ଏତାଂ କଥାଂ କଥଯିତୁମ୍ ଆରେଭେ, ମନାଂସି ପରାୱର୍ତ୍ତଯତ, ସ୍ୱର୍ଗୀଯରାଜତ୍ୱଂ ସୱିଧମଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ତତଃ ପରଂ ଯୀଶୁ ର୍ଗାଲୀଲୋ ଜଲଧେସ୍ତଟେନ ଗଚ୍ଛନ୍ ଗଚ୍ଛନ୍ ଆନ୍ଦ୍ରିଯସ୍ତସ୍ୟ ଭ୍ରାତା ଶିମୋନ୍ ଅର୍ଥତୋ ଯଂ ପିତରଂ ୱଦନ୍ତି ଏତାୱୁଭୌ ଜଲଘୌ ଜାଲଂ କ୍ଷିପନ୍ତୌ ଦଦର୍ଶ, ଯତସ୍ତୌ ମୀନଧାରିଣାୱାସ୍ତାମ୍| ");
INSERT INTO sanori_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ତଦା ସ ତାୱାହୂଯ ୱ୍ୟାଜହାର, ଯୁୱାଂ ମମ ପଶ୍ଚାଦ୍ ଆଗଚ୍ଛତଂ, ଯୁୱାମହଂ ମନୁଜଧାରିଣୌ କରିଷ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","ତେନୈୱ ତୌ ଜାଲଂ ୱିହାଯ ତସ୍ୟ ପଶ୍ଚାତ୍ ଆଗଚ୍ଛତାମ୍| ");
INSERT INTO sanori_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ଅନନ୍ତରଂ ତସ୍ମାତ୍ ସ୍ଥାନାତ୍ ୱ୍ରଜନ୍ ୱ୍ରଜନ୍ ସିୱଦିଯସ୍ୟ ସୁତୌ ଯାକୂବ୍ ଯୋହନ୍ନାମାନୌ ଦ୍ୱୌ ସହଜୌ ତାତେନ ସାର୍ଦ୍ଧଂ ନୌକୋପରି ଜାଲସ୍ୟ ଜୀର୍ଣୋଦ୍ଧାରଂ କୁର୍ୱ୍ୱନ୍ତୌ ୱୀକ୍ଷ୍ୟ ତାୱାହୂତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ତତ୍କ୍ଷଣାତ୍ ତୌ ନାୱଂ ସ୍ୱତାତଞ୍ଚ ୱିହାଯ ତସ୍ୟ ପଶ୍ଚାଦ୍ଗାମିନୌ ବଭୂୱତୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ଅନନ୍ତରଂ ଭଜନଭୱନେ ସମୁପଦିଶନ୍ ରାଜ୍ୟସ୍ୟ ସୁସଂୱାଦଂ ପ୍ରଚାରଯନ୍ ମନୁଜାନାଂ ସର୍ୱ୍ୱପ୍ରକାରାନ୍ ରୋଗାନ୍ ସର୍ୱ୍ୱପ୍ରକାରପୀଡାଶ୍ଚ ଶମଯନ୍ ଯୀଶୁଃ କୃତ୍ସ୍ନଂ ଗାଲୀଲ୍ଦେଶଂ ଭ୍ରମିତୁମ୍ ଆରଭତ| ");
INSERT INTO sanori_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ତେନ କୃତ୍ସ୍ନସୁରିଯାଦେଶସ୍ୟ ମଧ୍ୟଂ ତସ୍ୟ ଯଶୋ ୱ୍ୟାପ୍ନୋତ୍, ଅପରଂ ଭୂତଗ୍ରସ୍ତା ଅପସ୍ମାରର୍ଗୀଣଃ ପକ୍ଷାଧାତିପ୍ରଭୃତଯଶ୍ଚ ଯାୱନ୍ତୋ ମନୁଜା ନାନାୱିଧୱ୍ୟାଧିଭିଃ କ୍ଲିଷ୍ଟା ଆସନ୍, ତେଷୁ ସର୍ୱ୍ୱେଷୁ ତସ୍ୟ ସମୀପମ୍ ଆନୀତେଷୁ ସ ତାନ୍ ସ୍ୱସ୍ଥାନ୍ ଚକାର| ");
INSERT INTO sanori_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ଏତେନ ଗାଲୀଲ୍-ଦିକାପନି-ଯିରୂଶାଲମ୍-ଯିହୂଦୀଯଦେଶେଭ୍ୟୋ ଯର୍ଦ୍ଦନଃ ପାରାଞ୍ଚ ବହୱୋ ମନୁଜାସ୍ତସ୍ୟ ପଶ୍ଚାଦ୍ ଆଗଚ୍ଛନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ଅନନ୍ତରଂ ସ ଜନନିୱହଂ ନିରୀକ୍ଷ୍ୟ ଭୂଧରୋପରି ୱ୍ରଜିତ୍ୱା ସମୁପୱିୱେଶ| ");
INSERT INTO sanori_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ତଦାନୀଂ ଶିଷ୍ୟେଷୁ ତସ୍ୟ ସମୀପମାଗତେଷୁ ତେନ ତେଭ୍ୟ ଏଷା କଥା କଥ୍ୟାଞ୍ଚକ୍ରେ| ");
INSERT INTO sanori_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","ଅଭିମାନହୀନା ଜନା ଧନ୍ୟାଃ, ଯତସ୍ତେ ସ୍ୱର୍ଗୀଯରାଜ୍ୟମ୍ ଅଧିକରିଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ଖିଦ୍ୟମାନା ମନୁଜା ଧନ୍ୟାଃ, ଯସ୍ମାତ୍ ତେ ସାନ୍ତ୍ୱନାଂ ପ୍ରାପ୍ସନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","ନମ୍ରା ମାନୱାଶ୍ଚ ଧନ୍ୟାଃ, ଯସ୍ମାତ୍ ତେ ମେଦିନୀମ୍ ଅଧିକରିଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ଧର୍ମ୍ମାଯ ବୁଭୁକ୍ଷିତାଃ ତୃଷାର୍ତ୍ତାଶ୍ଚ ମନୁଜା ଧନ୍ୟାଃ, ଯସ୍ମାତ୍ ତେ ପରିତର୍ପ୍ସ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","କୃପାଲୱୋ ମାନୱା ଧନ୍ୟାଃ, ଯସ୍ମାତ୍ ତେ କୃପାଂ ପ୍ରାପ୍ସ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ନିର୍ମ୍ମଲହୃଦଯା ମନୁଜାଶ୍ଚ ଧନ୍ୟାଃ, ଯସ୍ମାତ୍ ତ ଈଶ୍ଚରଂ ଦ୍ରକ୍ଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","ମେଲଯିତାରୋ ମାନୱା ଧନ୍ୟାଃ, ଯସ୍ମାତ୍ ତ ଈଶ୍ଚରସ୍ୟ ସନ୍ତାନତ୍ୱେନ ୱିଖ୍ୟାସ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ଧର୍ମ୍ମକାରଣାତ୍ ତାଡିତା ମନୁଜା ଧନ୍ୟା, ଯସ୍ମାତ୍ ସ୍ୱର୍ଗୀଯରାଜ୍ୟେ ତେଷାମଧିକରୋ ୱିଦ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","ଯଦା ମନୁଜା ମମ ନାମକୃତେ ଯୁଷ୍ମାନ୍ ନିନ୍ଦନ୍ତି ତାଡଯନ୍ତି ମୃଷା ନାନାଦୁର୍ୱ୍ୱାକ୍ୟାନି ୱଦନ୍ତି ଚ, ତଦା ଯୁଯଂ ଧନ୍ୟାଃ| ");
INSERT INTO sanori_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ତଦା ଆନନ୍ଦତ, ତଥା ଭୃଶଂ ହ୍ଲାଦଧ୍ୱଞ୍ଚ, ଯତଃ ସ୍ୱର୍ଗେ ଭୂଯାଂସି ଫଲାନି ଲପ୍ସ୍ୟଧ୍ୱେ; ତେ ଯୁଷ୍ମାକଂ ପୁରାତନାନ୍ ଭୱିଷ୍ୟଦ୍ୱାଦିନୋଽପି ତାଦୃଗ୍ ଅତାଡଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","ଯୁଯଂ ମେଦିନ୍ୟାଂ ଲୱଣରୂପାଃ, କିନ୍ତୁ ଯଦି ଲୱଣସ୍ୟ ଲୱଣତ୍ୱମ୍ ଅପଯାତି, ତର୍ହି ତତ୍ କେନ ପ୍ରକାରେଣ ସ୍ୱାଦୁଯୁକ୍ତଂ ଭୱିଷ୍ୟତି? ତତ୍ କସ୍ୟାପି କାର୍ୟ୍ୟସ୍ୟାଯୋଗ୍ୟତ୍ୱାତ୍ କେୱଲଂ ବହିଃ ପ୍ରକ୍ଷେପ୍ତୁଂ ନରାଣାଂ ପଦତଲେନ ଦଲଯିତୁଞ୍ଚ ଯୋଗ୍ୟଂ ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","ଯୂଯଂ ଜଗତି ଦୀପ୍ତିରୂପାଃ, ଭୂଧରୋପରି ସ୍ଥିତଂ ନଗରଂ ଗୁପ୍ତଂ ଭୱିତୁଂ ନହି ଶକ୍ଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","ଅପରଂ ମନୁଜାଃ ପ୍ରଦୀପାନ୍ ପ୍ରଜ୍ୱାଲ୍ୟ ଦ୍ରୋଣାଧୋ ନ ସ୍ଥାପଯନ୍ତି, କିନ୍ତୁ ଦୀପାଧାରୋପର୍ୟ୍ୟେୱ ସ୍ଥାପଯନ୍ତି, ତେନ ତେ ଦୀପା ଗେହସ୍ଥିତାନ୍ ସକଲାନ୍ ପ୍ରକାଶଯନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","ଯେନ ମାନୱା ଯୁଷ୍ମାକଂ ସତ୍କର୍ମ୍ମାଣି ୱିଲୋକ୍ୟ ଯୁଷ୍ମାକଂ ସ୍ୱର୍ଗସ୍ଥଂ ପିତରଂ ଧନ୍ୟଂ ୱଦନ୍ତି, ତେଷାଂ ସମକ୍ଷଂ ଯୁଷ୍ମାକଂ ଦୀପ୍ତିସ୍ତାଦୃକ୍ ପ୍ରକାଶତାମ୍| ");
INSERT INTO sanori_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","ଅହଂ ୱ୍ୟୱସ୍ଥାଂ ଭୱିଷ୍ୟଦ୍ୱାକ୍ୟଞ୍ଚ ଲୋପ୍ତୁମ୍ ଆଗତୱାନ୍, ଇତ୍ଥଂ ମାନୁଭୱତ, ତେ ଦ୍ୱେ ଲୋପ୍ତୁଂ ନାଗତୱାନ୍, କିନ୍ତୁ ସଫଲେ କର୍ତ୍ତୁମ୍ ଆଗତୋସ୍ମି| ");
INSERT INTO sanori_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","ଅପରଂ ଯୁଷ୍ମାନ୍ ଅହଂ ତଥ୍ୟଂ ୱଦାମି ଯାୱତ୍ ୱ୍ୟୋମମେଦିନ୍ୟୋ ର୍ଧ୍ୱଂସୋ ନ ଭୱିଷ୍ୟତି, ତାୱତ୍ ସର୍ୱ୍ୱସ୍ମିନ୍ ସଫଲେ ନ ଜାତେ ୱ୍ୟୱସ୍ଥାଯା ଏକା ମାତ୍ରା ବିନ୍ଦୁରେକୋପି ୱା ନ ଲୋପ୍ସ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ତସ୍ମାତ୍ ଯୋ ଜନ ଏତାସାମ୍ ଆଜ୍ଞାନାମ୍ ଅତିକ୍ଷୁଦ୍ରାମ୍ ଏକାଜ୍ଞାମପୀ ଲଂଘତେ ମନୁଜାଂଞ୍ଚ ତଥୈୱ ଶିକ୍ଷଯତି, ସ ସ୍ୱର୍ଗୀଯରାଜ୍ୟେ ସର୍ୱ୍ୱେଭ୍ୟଃ କ୍ଷୁଦ୍ରତ୍ୱେନ ୱିଖ୍ୟାସ୍ୟତେ, କିନ୍ତୁ ଯୋ ଜନସ୍ତାଂ ପାଲଯତି, ତଥୈୱ ଶିକ୍ଷଯତି ଚ, ସ ସ୍ୱର୍ଗୀଯରାଜ୍ୟେ ପ୍ରଧାନତ୍ୱେନ ୱିଖ୍ୟାସ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","ଅପରଂ ଯୁଷ୍ମାନ୍ ଅହଂ ୱଦାମି, ଅଧ୍ୟାପକଫିରୂଶିମାନୱାନାଂ ଧର୍ମ୍ମାନୁଷ୍ଠାନାତ୍ ଯୁଷ୍ମାକଂ ଧର୍ମ୍ମାନୁଷ୍ଠାନେ ନୋତ୍ତମେ ଜାତେ ଯୂଯମ୍ ଈଶ୍ୱରୀଯରାଜ୍ୟଂ ପ୍ରୱେଷ୍ଟୁଂ ନ ଶକ୍ଷ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","ଅପରଞ୍ଚ ତ୍ୱଂ ନରଂ ମା ୱଧୀଃ, ଯସ୍ମାତ୍ ଯୋ ନରଂ ହନ୍ତି, ସ ୱିଚାରସଭାଯାଂ ଦଣ୍ଡାର୍ହୋ ଭୱିଷ୍ୟତି, ପୂର୍ୱ୍ୱକାଲୀନଜନେଭ୍ୟ ଇତି କଥିତମାସୀତ୍, ଯୁଷ୍ମାଭିରଶ୍ରାୱି| ");
INSERT INTO sanori_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","କିନ୍ତ୍ୱହଂ ଯୁଷ୍ମାନ୍ ୱଦାମି, ଯଃ କଶ୍ଚିତ୍ କାରଣଂ ୱିନା ନିଜଭ୍ରାତ୍ରେ କୁପ୍ୟତି, ସ ୱିଚାରସଭାଯାଂ ଦଣ୍ଡାର୍ହୋ ଭୱିଷ୍ୟତି; ଯଃ କଶ୍ଚିଚ୍ଚ ସ୍ୱୀଯସହଜଂ ନିର୍ବ୍ବୋଧଂ ୱଦତି, ସ ମହାସଭାଯାଂ ଦଣ୍ଡାର୍ହୋ ଭୱିଷ୍ୟତି; ପୁନଶ୍ଚ ତ୍ୱଂ ମୂଢ ଇତି ୱାକ୍ୟଂ ଯଦି କଶ୍ଚିତ୍ ସ୍ୱୀଯଭ୍ରାତରଂ ୱକ୍ତି, ତର୍ହି ନରକାଗ୍ନୌ ସ ଦଣ୍ଡାର୍ହୋ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","ଅତୋ ୱେଦ୍ୟାଃ ସମୀପଂ ନିଜନୈୱେଦ୍ୟେ ସମାନୀତେଽପି ନିଜଭ୍ରାତରଂ ପ୍ରତି କସ୍ମାଚ୍ଚିତ୍ କାରଣାତ୍ ତ୍ୱଂ ଯଦି ଦୋଷୀ ୱିଦ୍ୟସେ, ତଦାନୀଂ ତୱ ତସ୍ୟ ସ୍ମୃତି ର୍ଜାଯତେ ଚ, ");
INSERT INTO sanori_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ତର୍ହି ତସ୍ୟା ୱେଦ୍ୟାଃ ସମୀପେ ନିଜନୈୱୈଦ୍ୟଂ ନିଧାଯ ତଦୈୱ ଗତ୍ୱା ପୂର୍ୱ୍ୱଂ ତେନ ସାର୍ଦ୍ଧଂ ମିଲ, ପଶ୍ଚାତ୍ ଆଗତ୍ୟ ନିଜନୈୱେଦ୍ୟଂ ନିୱେଦଯ| ");
INSERT INTO sanori_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","ଅନ୍ୟଞ୍ଚ ଯାୱତ୍ ୱିୱାଦିନା ସାର୍ଦ୍ଧଂ ୱର୍ତ୍ମନି ତିଷ୍ଠସି, ତାୱତ୍ ତେନ ସାର୍ଦ୍ଧଂ ମେଲନଂ କୁରୁ; ନୋ ଚେତ୍ ୱିୱାଦୀ ୱିଚାରଯିତୁଃ ସମୀପେ ତ୍ୱାଂ ସମର୍ପଯତି ୱିଚାରଯିତା ଚ ରକ୍ଷିଣଃ ସନ୍ନିଧୌ ସମର୍ପଯତି ତଦା ତ୍ୱଂ କାରାଯାଂ ବଧ୍ୟେଥାଃ| ");
INSERT INTO sanori_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ତର୍ହି ତ୍ୱାମହଂ ତଥ୍ଥଂ ବ୍ରୱୀମି, ଶେଷକପର୍ଦକେଽପି ନ ପରିଶୋଧିତେ ତସ୍ମାତ୍ ସ୍ଥାନାତ୍ କଦାପି ବହିରାଗନ୍ତୁଂ ନ ଶକ୍ଷ୍ୟସି| ");
INSERT INTO sanori_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","ଅପରଂ ତ୍ୱଂ ମା ୱ୍ୟଭିଚର, ଯଦେତଦ୍ ୱଚନଂ ପୂର୍ୱ୍ୱକାଲୀନଲୋକେଭ୍ୟଃ କଥିତମାସୀତ୍, ତଦ୍ ଯୂଯଂ ଶ୍ରୁତୱନ୍ତଃ; ");
INSERT INTO sanori_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","କିନ୍ତ୍ୱହଂ ଯୁଷ୍ମାନ୍ ୱଦାମି, ଯଦି କଶ୍ଚିତ୍ କାମତଃ କାଞ୍ଚନ ଯୋଷିତଂ ପଶ୍ୟତି, ତର୍ହି ସ ମନସା ତଦୈୱ ୱ୍ୟଭିଚରିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ତସ୍ମାତ୍ ତୱ ଦକ୍ଷିଣଂ ନେତ୍ରଂ ଯଦି ତ୍ୱାଂ ବାଧତେ, ତର୍ହି ତନ୍ନେତ୍ରମ୍ ଉତ୍ପାଟ୍ୟ ଦୂରେ ନିକ୍ଷିପ, ଯସ୍ମାତ୍ ତୱ ସର୍ୱ୍ୱୱପୁଷୋ ନରକେ ନିକ୍ଷେପାତ୍ ତୱୈକାଙ୍ଗସ୍ୟ ନାଶୋ ୱରଂ| ");
INSERT INTO sanori_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","ଯଦ୍ୱା ତୱ ଦକ୍ଷିଣଃ କରୋ ଯଦି ତ୍ୱାଂ ବାଧତେ, ତର୍ହି ତଂ କରଂ ଛିତ୍ତ୍ୱା ଦୂରେ ନିକ୍ଷିପ, ଯତଃ ସର୍ୱ୍ୱୱପୁଷୋ ନରକେ ନିକ୍ଷେପାତ୍ ଏକାଙ୍ଗସ୍ୟ ନାଶୋ ୱରଂ| ");
INSERT INTO sanori_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","ଉକ୍ତମାସ୍ତେ, ଯଦି କଶ୍ଚିନ୍ ନିଜଜାଯାଂ ପରିତ୍ୟକ୍ତ୍ତୁମ୍ ଇଚ୍ଛତି, ତର୍ହି ସ ତସ୍ୟୈ ତ୍ୟାଗପତ୍ରଂ ଦଦାତୁ| ");
INSERT INTO sanori_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","କିନ୍ତ୍ୱହଂ ଯୁଷ୍ମାନ୍ ୱ୍ୟାହରାମି, ୱ୍ୟଭିଚାରଦୋଷେ ନ ଜାତେ ଯଦି କଶ୍ଚିନ୍ ନିଜଜାଯାଂ ପରିତ୍ୟଜତି, ତର୍ହି ସ ତାଂ ୱ୍ୟଭିଚାରଯତି; ଯଶ୍ଚ ତାଂ ତ୍ୟକ୍ତାଂ ସ୍ତ୍ରିଯଂ ୱିୱହତି, ସୋପି ୱ୍ୟଭିଚରତି| ");
INSERT INTO sanori_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","ପୁନଶ୍ଚ ତ୍ୱଂ ମୃଷା ଶପଥମ୍ ନ କୁର୍ୱ୍ୱନ୍ ଈଶ୍ଚରାଯ ନିଜଶପଥଂ ପାଲଯ, ପୂର୍ୱ୍ୱକାଲୀନଲୋକେଭ୍ୟୋ ଯୈଷା କଥା କଥିତା, ତାମପି ଯୂଯଂ ଶ୍ରୁତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","କିନ୍ତ୍ୱହଂ ଯୁଷ୍ମାନ୍ ୱଦାମି, କମପି ଶପଥଂ ମା କାର୍ଷ୍ଟ, ଅର୍ଥତଃ ସ୍ୱର୍ଗନାମ୍ନା ନ, ଯତଃ ସ ଈଶ୍ୱରସ୍ୟ ସିଂହାସନଂ; ");
INSERT INTO sanori_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ପୃଥିୱ୍ୟା ନାମ୍ନାପି ନ, ଯତଃ ସା ତସ୍ୟ ପାଦପୀଠଂ; ଯିରୂଶାଲମୋ ନାମ୍ନାପି ନ, ଯତଃ ସା ମହାରାଜସ୍ୟ ପୁରୀ; ");
INSERT INTO sanori_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ନିଜଶିରୋନାମ୍ନାପି ନ, ଯସ୍ମାତ୍ ତସ୍ୟୈକଂ କଚମପି ସିତମ୍ ଅସିତଂ ୱା କର୍ତ୍ତୁଂ ତ୍ୱଯା ନ ଶକ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","ଅପରଂ ଯୂଯଂ ସଂଲାପସମଯେ କେୱଲଂ ଭୱତୀତି ନ ଭୱତୀତି ଚ ୱଦତ ଯତ ଇତୋଽଧିକଂ ଯତ୍ ତତ୍ ପାପାତ୍ମନୋ ଜାଯତେ| ");
INSERT INTO sanori_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","ଅପରଂ ଲୋଚନସ୍ୟ ୱିନିମଯେନ ଲୋଚନଂ ଦନ୍ତସ୍ୟ ୱିନିମଯେନ ଦନ୍ତଃ ପୂର୍ୱ୍ୱକ୍ତମିଦଂ ୱଚନଞ୍ଚ ଯୁଷ୍ମାଭିରଶ୍ରୂଯତ| ");
INSERT INTO sanori_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","କିନ୍ତ୍ୱହଂ ଯୁଷ୍ମାନ୍ ୱଦାମି ଯୂଯଂ ହିଂସକଂ ନରଂ ମା ୱ୍ୟାଘାତଯତ| କିନ୍ତୁ କେନଚିତ୍ ତୱ ଦକ୍ଷିଣକପୋଲେ ଚପେଟାଘାତେ କୃତେ ତଂ ପ୍ରତି ୱାମଂ କପୋଲଞ୍ଚ ୱ୍ୟାଘୋଟଯ| ");
INSERT INTO sanori_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ଅପରଂ କେନଚିତ୍ ତ୍ୱଯା ସାର୍ଧ୍ଦଂ ୱିୱାଦଂ କୃତ୍ୱା ତୱ ପରିଧେଯୱସନେ ଜିଘୃତିତେ ତସ୍ମାଯୁତ୍ତରୀଯୱସନମପି ଦେହି| ");
INSERT INTO sanori_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ଯଦି କଶ୍ଚିତ୍ ତ୍ୱାଂ କ୍ରୋଶମେକଂ ନଯନାର୍ଥଂ ଅନ୍ୟାଯତୋ ଧରତି, ତଦା ତେନ ସାର୍ଧ୍ଦଂ କ୍ରୋଶଦ୍ୱଯଂ ଯାହି| ");
INSERT INTO sanori_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ଯଶ୍ଚ ମାନୱସ୍ତ୍ୱାଂ ଯାଚତେ, ତସ୍ମୈ ଦେହି, ଯଦି କଶ୍ଚିତ୍ ତୁଭ୍ୟଂ ଧାରଯିତୁମ୍ ଇଚ୍ଛତି, ତର୍ହି ତଂ ପ୍ରତି ପରାଂମୁଖୋ ମା ଭୂଃ| ");
INSERT INTO sanori_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","ନିଜସମୀପୱସିନି ପ୍ରେମ କୁରୁ, କିନ୍ତୁ ଶତ୍ରୁଂ ପ୍ରତି ଦ୍ୱେଷଂ କୁରୁ, ଯଦେତତ୍ ପୁରୋକ୍ତଂ ୱଚନଂ ଏତଦପି ଯୂଯଂ ଶ୍ରୁତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","କିନ୍ତ୍ୱହଂ ଯୁଷ୍ମାନ୍ ୱଦାମି, ଯୂଯଂ ରିପୁୱ୍ୱପି ପ୍ରେମ କୁରୁତ, ଯେ ଚ ଯୁଷ୍ମାନ୍ ଶପନ୍ତେ, ତାନ, ଆଶିଷଂ ୱଦତ, ଯେ ଚ ଯୁଷ୍ମାନ୍ ଋृତୀଯନ୍ତେ, ତେଷାଂ ମଙ୍ଗଲଂ କୁରୁତ, ଯେ ଚ ଯୁଷ୍ମାନ୍ ନିନ୍ଦନ୍ତି, ତାଡଯନ୍ତି ଚ, ତେଷାଂ କୃତେ ପ୍ରାର୍ଥଯଧ୍ୱଂ| ");
INSERT INTO sanori_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ତତ୍ର ଯଃ ସତାମସତାଞ୍ଚୋପରି ପ୍ରଭାକରମ୍ ଉଦାଯଯତି, ତଥା ଧାର୍ମ୍ମିକାନାମଧାର୍ମ୍ମିକାନାଞ୍ଚୋପରି ନୀରଂ ୱର୍ଷଯତି ତାଦୃଶୋ ଯୋ ଯୁଷ୍ମାକଂ ସ୍ୱର୍ଗସ୍ଥଃ ପିତା, ଯୂଯଂ ତସ୍ୟୈୱ ସନ୍ତାନା ଭୱିଷ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ଯେ ଯୁଷ୍ମାସୁ ପ୍ରେମ କୁର୍ୱ୍ୱନ୍ତି, ଯୂଯଂ ଯଦି କେୱଲଂ ତେୱ୍ୱେୱ ପ୍ରେମ କୁରୁଥ, ତର୍ହି ଯୁଷ୍ମାକଂ କିଂ ଫଲଂ ଭୱିଷ୍ୟତି? ଚଣ୍ଡାଲା ଅପି ତାଦୃଶଂ କିଂ ନ କୁର୍ୱ୍ୱନ୍ତି? ");
INSERT INTO sanori_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","ଅପରଂ ଯୂଯଂ ଯଦି କେୱଲଂ ସ୍ୱୀଯଭ୍ରାତୃତ୍ୱେନ ନମତ, ତର୍ହି କିଂ ମହତ୍ କର୍ମ୍ମ କୁରୁଥ? ଚଣ୍ଡାଲା ଅପି ତାଦୃଶଂ କିଂ ନ କୁର୍ୱ୍ୱନ୍ତି? ");
INSERT INTO sanori_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","ତସ୍ମାତ୍ ଯୁଷ୍ମାକଂ ସ୍ୱର୍ଗସ୍ଥଃ ପିତା ଯଥା ପୂର୍ଣୋ ଭୱତି, ଯୂଯମପି ତାଦୃଶା ଭୱତ| ");
INSERT INTO sanori_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","ସାୱଧାନା ଭୱତ, ମନୁଜାନ୍ ଦର୍ଶଯିତୁଂ ତେଷାଂ ଗୋଚରେ ଧର୍ମ୍ମକର୍ମ୍ମ ମା କୁରୁତ, ତଥା କୃତେ ଯୁଷ୍ମାକଂ ସ୍ୱର୍ଗସ୍ଥପିତୁଃ ସକାଶାତ୍ କିଞ୍ଚନ ଫଲଂ ନ ପ୍ରାପ୍ସ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","ତ୍ୱଂ ଯଦା ଦଦାସି ତଦା କପଟିନୋ ଜନା ଯଥା ମନୁଜେଭ୍ୟଃ ପ୍ରଶଂସାଂ ପ୍ରାପ୍ତୁଂ ଭଜନଭୱନେ ରାଜମାର୍ଗେ ଚ ତୂରୀଂ ୱାଦଯନ୍ତି, ତଥା ମା କୁରିु, ଅହଂ ତୁଭ୍ୟଂ ଯଥାର୍ଥଂ କଥଯାମି, ତେ ସ୍ୱକାଯଂ ଫଲମ୍ ଅଲଭନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","କିନ୍ତୁ ତ୍ୱଂ ଯଦା ଦଦାସି, ତଦା ନିଜଦକ୍ଷିଣକରୋ ଯତ୍ କରୋତି, ତଦ୍ ୱାମକରଂ ମା ଜ୍ଞାପଯ| ");
INSERT INTO sanori_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ତେନ ତୱ ଦାନଂ ଗୁପ୍ତଂ ଭୱିଷ୍ୟତି ଯସ୍ତୁ ତୱ ପିତା ଗୁପ୍ତଦର୍ଶୀ, ସ ପ୍ରକାଶ୍ୟ ତୁଭ୍ୟଂ ଫଲଂ ଦାସ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","ଅପରଂ ଯଦା ପ୍ରାର୍ଥଯସେ, ତଦା କପଟିନଇୱ ମା କୁରୁ, ଯସ୍ମାତ୍ ତେ ଭଜନଭୱନେ ରାଜମାର୍ଗସ୍ୟ କୋଣେ ତିଷ୍ଠନ୍ତୋ ଲୋକାନ୍ ଦର୍ଶଯନ୍ତଃ ପ୍ରାର୍ଥଯିତୁଂ ପ୍ରୀଯନ୍ତେ; ଅହଂ ଯୁଷ୍ମାନ୍ ତଥ୍ୟଂ ୱଦାମି, ତେ ସ୍ୱକୀଯଫଲଂ ପ୍ରାପ୍ନୁୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","ତସ୍ମାତ୍ ପ୍ରାର୍ଥନାକାଲେ ଅନ୍ତରାଗାରଂ ପ୍ରୱିଶ୍ୟ ଦ୍ୱାରଂ ରୁଦ୍ୱ୍ୱା ଗୁପ୍ତଂ ପଶ୍ୟତସ୍ତୱ ପିତୁଃ ସମୀପେ ପ୍ରାର୍ଥଯସ୍ୱ; ତେନ ତୱ ଯଃ ପିତା ଗୁପ୍ତଦର୍ଶୀ, ସ ପ୍ରକାଶ୍ୟ ତୁଭ୍ୟଂ ଫଲଂ ଦାସ୍ୟତିl ");
INSERT INTO sanori_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","ଅପରଂ ପ୍ରାର୍ଥନାକାଲେ ଦେୱପୂଜକାଇୱ ମୁଧା ପୁନରୁକ୍ତିଂ ମା କୁରୁ, ଯସ୍ମାତ୍ ତେ ବୋଧନ୍ତେ, ବହୁୱାରଂ କଥାଯାଂ କଥିତାଯାଂ ତେଷାଂ ପ୍ରାର୍ଥନା ଗ୍ରାହିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","ଯୂଯଂ ତେଷାମିୱ ମା କୁରୁତ, ଯସ୍ମାତ୍ ଯୁଷ୍ମାକଂ ଯଦ୍ ଯତ୍ ପ୍ରଯୋଜନଂ ଯାଚନାତଃ ପ୍ରାଗେୱ ଯୁଷ୍ମାକଂ ପିତା ତତ୍ ଜାନାତି| ");
INSERT INTO sanori_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","ଅତଏୱ ଯୂଯମ ଈଦୃକ୍ ପ୍ରାର୍ଥଯଧ୍ୱଂ, ହେ ଅସ୍ମାକଂ ସ୍ୱର୍ଗସ୍ଥପିତଃ, ତୱ ନାମ ପୂଜ୍ୟଂ ଭୱତୁ| ");
INSERT INTO sanori_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ତୱ ରାଜତ୍ୱଂ ଭୱତୁ; ତୱେଚ୍ଛା ସ୍ୱର୍ଗେ ଯଥା ତଥୈୱ ମେଦିନ୍ୟାମପି ସଫଲା ଭୱତୁ| ");
INSERT INTO sanori_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ଅସ୍ମାକଂ ପ୍ରଯୋଜନୀଯମ୍ ଆହାରମ୍ ଅଦ୍ୟ ଦେହି| ");
INSERT INTO sanori_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ୱଯଂ ଯଥା ନିଜାପରାଧିନଃ କ୍ଷମାମହେ, ତଥୈୱାସ୍ମାକମ୍ ଅପରାଧାନ୍ କ୍ଷମସ୍ୱ| ");
INSERT INTO sanori_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ଅସ୍ମାନ୍ ପରୀକ୍ଷାଂ ମାନଯ, କିନ୍ତୁ ପାପାତ୍ମନୋ ରକ୍ଷ; ରାଜତ୍ୱଂ ଗୌରୱଂ ପରାକ୍ରମଃ ଏତେ ସର୍ୱ୍ୱେ ସର୍ୱ୍ୱଦା ତୱ; ତଥାସ୍ତୁ| ");
INSERT INTO sanori_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","ଯଦି ଯୂଯମ୍ ଅନ୍ୟେଷାମ୍ ଅପରାଧାନ୍ କ୍ଷମଧ୍ୱେ ତର୍ହି ଯୁଷ୍ମାକଂ ସ୍ୱର୍ଗସ୍ଥପିତାପି ଯୁଷ୍ମାନ୍ କ୍ଷମିଷ୍ୟତେ; ");
INSERT INTO sanori_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","କିନ୍ତୁ ଯଦି ଯୂଯମ୍ ଅନ୍ୟେଷାମ୍ ଅପରାଧାନ୍ ନ କ୍ଷମଧ୍ୱେ, ତର୍ହି ଯୁଷ୍ମାକଂ ଜନକୋପି ଯୁଷ୍ମାକମ୍ ଅପରାଧାନ୍ ନ କ୍ଷମିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","ଅପରମ୍ ଉପୱାସକାଲେ କପଟିନୋ ଜନା ମାନୁଷାନ୍ ଉପୱାସଂ ଜ୍ଞାପଯିତୁଂ ସ୍ୱେଷାଂ ୱଦନାନି ମ୍ଲାନାନି କୁର୍ୱ୍ୱନ୍ତି, ଯୂଯଂ ତଇୱ ୱିଷଣୱଦନା ମା ଭୱତ; ଅହଂ ଯୁଷ୍ମାନ୍ ତଥ୍ୟଂ ୱଦାମି ତେ ସ୍ୱକୀଯଫଲମ୍ ଅଲଭନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","ଯଦା ତ୍ୱମ୍ ଉପୱସସି, ତଦା ଯଥା ଲୋକୈସ୍ତ୍ୱଂ ଉପୱାସୀୱ ନ ଦୃଶ୍ୟସେ, କିନ୍ତୁ ତୱ ଯୋଽଗୋଚରଃ ପିତା ତେନୈୱ ଦୃଶ୍ୟସେ, ତତ୍କୃତେ ନିଜଶିରସି ତୈଲଂ ମର୍ଦ୍ଦଯ ୱଦନଞ୍ଚ ପ୍ରକ୍ଷାଲଯ; ");
INSERT INTO sanori_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ତେନ ତୱ ଯଃ ପିତା ଗୁପ୍ତଦର୍ଶୀ ସ ପ୍ରକାଶ୍ୟ ତୁଭ୍ୟଂ ଫଲଂ ଦାସ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","ଅପରଂ ଯତ୍ର ସ୍ଥାନେ କୀଟାଃ କଲଙ୍କାଶ୍ଚ କ୍ଷଯଂ ନଯନ୍ତି, ଚୌରାଶ୍ଚ ସନ୍ଧିଂ କର୍ତ୍ତଯିତ୍ୱା ଚୋରଯିତୁଂ ଶକ୍ନୁୱନ୍ତି, ତାଦୃଶ୍ୟାଂ ମେଦିନ୍ୟାଂ ସ୍ୱାର୍ଥଂ ଧନଂ ମା ସଂଚିନୁତ| ");
INSERT INTO sanori_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","କିନ୍ତୁ ଯତ୍ର ସ୍ଥାନେ କୀଟାଃ କଲଙ୍କାଶ୍ଚ କ୍ଷଯଂ ନ ନଯନ୍ତି, ଚୌରାଶ୍ଚ ସନ୍ଧିଂ କର୍ତ୍ତଯିତ୍ୱା ଚୋରଯିତୁଂ ନ ଶକ୍ନୁୱନ୍ତି, ତାଦୃଶେ ସ୍ୱର୍ଗେ ଧନଂ ସଞ୍ଚିନୁତ| ");
INSERT INTO sanori_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ଯସ୍ମାତ୍ ଯତ୍ର ସ୍ଥାନେ ଯୁଷ୍ମାଂକ ଧନଂ ତତ୍ରୈୱ ଖାନେ ଯୁଷ୍ମାକଂ ମନାଂସି| ");
INSERT INTO sanori_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","ଲୋଚନଂ ଦେହସ୍ୟ ପ୍ରଦୀପକଂ, ତସ୍ମାତ୍ ଯଦି ତୱ ଲୋଚନଂ ପ୍ରସନ୍ନଂ ଭୱତି, ତର୍ହି ତୱ କୃତ୍ସ୍ନଂ ୱପୁ ର୍ଦୀପ୍ତିଯୁକ୍ତଂ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","କିନ୍ତୁ ଲୋଚନେଽପ୍ରସନ୍ନେ ତୱ କୃତ୍ସ୍ନଂ ୱପୁଃ ତମିସ୍ରଯୁକ୍ତଂ ଭୱିଷ୍ୟତି| ଅତଏୱ ଯା ଦୀପ୍ତିସ୍ତ୍ୱଯି ୱିଦ୍ୟତେ, ସା ଯଦି ତମିସ୍ରଯୁକ୍ତା ଭୱତି, ତର୍ହି ତତ୍ ତମିସ୍ରଂ କିଯନ୍ ମହତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","କୋପି ମନୁଜୋ ଦ୍ୱୌ ପ୍ରଭୂ ସେୱିତୁଂ ନ ଶକ୍ନୋତି, ଯସ୍ମାଦ୍ ଏକଂ ସଂମନ୍ୟ ତଦନ୍ୟଂ ନ ସମ୍ମନ୍ୟତେ, ଯଦ୍ୱା ଏକତ୍ର ମନୋ ନିଧାଯ ତଦନ୍ୟମ୍ ଅୱମନ୍ୟତେ; ତଥା ଯୂଯମପୀଶ୍ୱରଂ ଲକ୍ଷ୍ମୀଞ୍ଚେତ୍ୟୁଭେ ସେୱିତୁଂ ନ ଶକ୍ନୁଥ| ");
INSERT INTO sanori_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","ଅପରମ୍ ଅହଂ ଯୁଷ୍ମଭ୍ୟଂ ତଥ୍ୟଂ କଥଯାମି, କିଂ ଭକ୍ଷିଷ୍ୟାମଃ? କିଂ ପାସ୍ୟାମଃ? ଇତି ପ୍ରାଣଧାରଣାଯ ମା ଚିନ୍ତଯତ; କିଂ ପରିଧାସ୍ୟାମଃ? ଇତି କାଯରକ୍ଷଣାଯ ନ ଚିନ୍ତଯତ; ଭକ୍ଷ୍ୟାତ୍ ପ୍ରାଣା ୱସନାଞ୍ଚ ୱପୂଂଷି କିଂ ଶ୍ରେଷ୍ଠାଣି ନ ହି? ");
INSERT INTO sanori_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ୱିହାଯସୋ ୱିହଙ୍ଗମାନ୍ ୱିଲୋକଯତ; ତୈ ର୍ନୋପ୍ୟତେ ନ କୃତ୍ୟତେ ଭାଣ୍ଡାଗାରେ ନ ସଞ୍ଚୀଯତେଽପି; ତଥାପି ଯୁଷ୍ମାକଂ ସ୍ୱର୍ଗସ୍ଥଃ ପିତା ତେଭ୍ୟ ଆହାରଂ ୱିତରତି| ");
INSERT INTO sanori_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","ଯୂଯଂ ତେଭ୍ୟଃ କିଂ ଶ୍ରେଷ୍ଠା ନ ଭୱଥ? ଯୁଷ୍ମାକଂ କଶ୍ଚିତ୍ ମନୁଜଃ ଚିନ୍ତଯନ୍ ନିଜାଯୁଷଃ କ୍ଷଣମପି ୱର୍ଦ୍ଧଯିତୁଂ ଶକ୍ନୋତି? ");
INSERT INTO sanori_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","ଅପରଂ ୱସନାଯ କୁତଶ୍ଚିନ୍ତଯତ? କ୍ଷେତ୍ରୋତ୍ପନ୍ନାନି ପୁଷ୍ପାଣି କଥଂ ୱର୍ଦ୍ଧନ୍ତେ ତଦାଲୋଚଯତ| ତାନି ତନ୍ତୂନ୍ ନୋତ୍ପାଦଯନ୍ତି କିମପି କାର୍ୟ୍ୟଂ ନ କୁର୍ୱ୍ୱନ୍ତି; ");
INSERT INTO sanori_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ତଥାପ୍ୟହଂ ଯୁଷ୍ମାନ୍ ୱଦାମି, ସୁଲେମାନ୍ ତାଦୃଗ୍ ଐଶ୍ୱର୍ୟ୍ୟୱାନପି ତତ୍ପୁଷ୍ପମିୱ ୱିଭୂଷିତୋ ନାସୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ତସ୍ମାତ୍ କ୍ଷଦ୍ୟ ୱିଦ୍ୟମାନଂ ଶ୍ଚଃ ଚୁଲ୍ଲ୍ୟାଂ ନିକ୍ଷେପ୍ସ୍ୟତେ ତାଦୃଶଂ ଯତ୍ କ୍ଷେତ୍ରସ୍ଥିତଂ କୁସୁମଂ ତତ୍ ଯଦୀଶ୍ଚର ଇତ୍ଥଂ ବିଭୂଷଯତି, ତର୍ହି ହେ ସ୍ତୋକପ୍ରତ୍ୟଯିନୋ ଯୁଷ୍ମାନ୍ କିଂ ନ ପରିଧାପଯିଷ୍ୟତି? ");
INSERT INTO sanori_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","ତସ୍ମାତ୍ ଅସ୍ମାଭିଃ କିମତ୍ସ୍ୟତେ? କିଞ୍ଚ ପାଯିଷ୍ୟତେ? କିଂ ୱା ପରିଧାଯିଷ୍ୟତେ, ଇତି ନ ଚିନ୍ତଯତ| ");
INSERT INTO sanori_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ଯସ୍ମାତ୍ ଦେୱାର୍ଚ୍ଚକା ଅପୀତି ଚେଷ୍ଟନ୍ତେ; ଏତେଷୁ ଦ୍ରୱ୍ୟେଷୁ ପ୍ରଯୋଜନମସ୍ତୀତି ଯୁଷ୍ମାକଂ ସ୍ୱର୍ଗସ୍ଥଃ ପିତା ଜାନାତି| ");
INSERT INTO sanori_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ଅତଏୱ ପ୍ରଥମତ ଈଶ୍ୱରୀଯରାଜ୍ୟଂ ଧର୍ମ୍ମଞ୍ଚ ଚେଷ୍ଟଧ୍ୱଂ, ତତ ଏତାନି ୱସ୍ତୂନି ଯୁଷ୍ମଭ୍ୟଂ ପ୍ରଦାଯିଷ୍ୟନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","ଶ୍ୱଃ କୃତେ ମା ଚିନ୍ତଯତ, ଶ୍ୱଏୱ ସ୍ୱଯଂ ସ୍ୱମୁଦ୍ଦିଶ୍ୟ ଚିନ୍ତଯିଷ୍ୟତି; ଅଦ୍ୟତନୀ ଯା ଚିନ୍ତା ସାଦ୍ୟକୃତେ ପ୍ରଚୁରତରା| ");
INSERT INTO sanori_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","ଯଥା ଯୂଯଂ ଦୋଷୀକୃତା ନ ଭୱଥ, ତତ୍କୃତେଽନ୍ୟଂ ଦୋଷିଣଂ ମା କୁରୁତ| ");
INSERT INTO sanori_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ଯତୋ ଯାଦୃଶେନ ଦୋଷେଣ ଯୂଯଂ ପରାନ୍ ଦୋଷିଣଃ କୁରୁଥ, ତାଦୃଶେନ ଦୋଷେଣ ଯୂଯମପି ଦୋଷୀକୃତା ଭୱିଷ୍ୟଥ, ଅନ୍ୟଞ୍ଚ ଯେନ ପରିମାଣେନ ଯୁଷ୍ମାଭିଃ ପରିମୀଯତେ, ତେନୈୱ ପରିମାଣେନ ଯୁଷ୍ମତ୍କୃତେ ପରିମାଯିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","ଅପରଞ୍ଚ ନିଜନଯନେ ଯା ନାସା ୱିଦ୍ୟତେ, ତାମ୍ ଅନାଲୋଚ୍ୟ ତୱ ସହଜସ୍ୟ ଲୋଚନେ ଯତ୍ ତୃଣମ୍ ଆସ୍ତେ, ତଦେୱ କୁତୋ ୱୀକ୍ଷସେ? ");
INSERT INTO sanori_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","ତୱ ନିଜଲୋଚନେ ନାସାଯାଂ ୱିଦ୍ୟମାନାଯାଂ, ହେ ଭ୍ରାତଃ, ତୱ ନଯନାତ୍ ତୃଣଂ ବହିଷ୍ୟର୍ତୁଂ ଅନୁଜାନୀହି, କଥାମେତାଂ ନିଜସହଜାଯ କଥଂ କଥଯିତୁଂ ଶକ୍ନୋଷି? ");
INSERT INTO sanori_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ହେ କପଟିନ୍, ଆଦୌ ନିଜନଯନାତ୍ ନାସାଂ ବହିଷ୍କୁରୁ ତତୋ ନିଜଦୃଷ୍ଟୌ ସୁପ୍ରସନ୍ନାଯାଂ ତୱ ଭ୍ରାତୃ ର୍ଲୋଚନାତ୍ ତୃଣଂ ବହିଷ୍କର୍ତୁଂ ଶକ୍ଷ୍ୟସି| ");
INSERT INTO sanori_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","ଅନ୍ୟଞ୍ଚ ସାରମେଯେଭ୍ୟଃ ପୱିତ୍ରୱସ୍ତୂନି ମା ୱିତରତ, ୱରାହାଣାଂ ସମକ୍ଷଞ୍ଚ ମୁକ୍ତା ମା ନିକ୍ଷିପତ; ନିକ୍ଷେପଣାତ୍ ତେ ତାଃ ସର୍ୱ୍ୱାଃ ପଦୈ ର୍ଦଲଯିଷ୍ୟନ୍ତି, ପରାୱୃତ୍ୟ ଯୁଷ୍ମାନପି ୱିଦାରଯିଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","ଯାଚଧ୍ୱଂ ତତୋ ଯୁଷ୍ମଭ୍ୟଂ ଦାଯିଷ୍ୟତେ; ମୃଗଯଧ୍ୱଂ ତତ ଉଦ୍ଦେଶଂ ଲପ୍ସ୍ୟଧ୍ୱେ; ଦ୍ୱାରମ୍ ଆହତ, ତତୋ ଯୁଷ୍ମତ୍କୃତେ ମୁକ୍ତଂ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ଯସ୍ମାଦ୍ ଯେନ ଯାଚ୍ୟତେ, ତେନ ଲଭ୍ୟତେ; ଯେନ ମୃଗ୍ୟତେ ତେନୋଦ୍ଦେଶଃ ପ୍ରାପ୍ୟତେ; ଯେନ ଚ ଦ୍ୱାରମ୍ ଆହନ୍ୟତେ, ତତ୍କୃତେ ଦ୍ୱାରଂ ମୋଚ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","ଆତ୍ମଜେନ ପୂପେ ପ୍ରାର୍ଥିତେ ତସ୍ମୈ ପାଷାଣଂ ୱିଶ୍ରାଣଯତି, ");
INSERT INTO sanori_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","ମୀନେ ଯାଚିତେ ଚ ତସ୍ମୈ ଭୁଜଗଂ ୱିତରତି, ଏତାଦୃଶଃ ପିତା ଯୁଷ୍ମାକଂ ମଧ୍ୟେ କ ଆସ୍ତେ? ");
INSERT INTO sanori_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","ତସ୍ମାଦ୍ ଯୂଯମ୍ ଅଭଦ୍ରାଃ ସନ୍ତୋଽପି ଯଦି ନିଜବାଲକେଭ୍ୟ ଉତ୍ତମଂ ଦ୍ରୱ୍ୟଂ ଦାତୁଂ ଜାନୀଥ, ତର୍ହି ଯୁଷ୍ମାକଂ ସ୍ୱର୍ଗସ୍ଥଃ ପିତା ସ୍ୱୀଯଯାଚକେଭ୍ୟଃ କିମୁତ୍ତମାନି ୱସ୍ତୂନି ନ ଦାସ୍ୟତି? ");
INSERT INTO sanori_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","ଯୂଷ୍ମାନ୍ ପ୍ରତୀତରେଷାଂ ଯାଦୃଶୋ ୱ୍ୟୱହାରୋ ଯୁଷ୍ମାକଂ ପ୍ରିଯଃ, ଯୂଯଂ ତାନ୍ ପ୍ରତି ତାଦୃଶାନେୱ ୱ୍ୟୱହାରାନ୍ ୱିଧତ୍ତ; ଯସ୍ମାଦ୍ ୱ୍ୟୱସ୍ଥାଭୱିଷ୍ୟଦ୍ୱାଦିନାଂ ୱଚନାନାମ୍ ଇତି ସାରମ୍| ");
INSERT INTO sanori_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","ସଙ୍କୀର୍ଣଦ୍ୱାରେଣ ପ୍ରୱିଶତ; ଯତୋ ନରକଗମନାଯ ଯଦ୍ ଦ୍ୱାରଂ ତଦ୍ ୱିସ୍ତୀର୍ଣଂ ଯଚ୍ଚ ୱର୍ତ୍ମ ତଦ୍ ବୃହତ୍ ତେନ ବହୱଃ ପ୍ରୱିଶନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","ଅପରଂ ସ୍ୱର୍ଗଗମନାଯ ଯଦ୍ ଦ୍ୱାରଂ ତତ୍ କୀଦୃକ୍ ସଂକୀର୍ଣଂ| ଯଚ୍ଚ ୱର୍ତ୍ମ ତତ୍ କୀଦୃଗ୍ ଦୁର୍ଗମମ୍| ତଦୁଦ୍ଦେଷ୍ଟାରଃ କିଯନ୍ତୋଽଲ୍ପାଃ| ");
INSERT INTO sanori_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","ଅପରଞ୍ଚ ଯେ ଜନା ମେଷୱେଶେନ ଯୁଷ୍ମାକଂ ସମୀପମ୍ ଆଗଚ୍ଛନ୍ତି, କିନ୍ତ୍ୱନ୍ତର୍ଦୁରନ୍ତା ୱୃକା ଏତାଦୃଶେଭ୍ୟୋ ଭୱିଷ୍ୟଦ୍ୱାଦିଭ୍ୟଃ ସାୱଧାନା ଭୱତ, ଯୂଯଂ ଫଲେନ ତାନ୍ ପରିଚେତୁଂ ଶକ୍ନୁଥ| ");
INSERT INTO sanori_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","ମନୁଜାଃ କିଂ କଣ୍ଟକିନୋ ୱୃକ୍ଷାଦ୍ ଦ୍ରାକ୍ଷାଫଲାନି ଶୃଗାଲକୋଲିତଶ୍ଚ ଉଡୁମ୍ବରଫଲାନି ଶାତଯନ୍ତି? ");
INSERT INTO sanori_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","ତଦ୍ୱଦ୍ ଉତ୍ତମ ଏୱ ପାଦପ ଉତ୍ତମଫଲାନି ଜନଯତି, ଅଧମପାଦପଏୱାଧମଫଲାନି ଜନଯତି| ");
INSERT INTO sanori_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","କିନ୍ତୂତ୍ତମପାଦପଃ କଦାପ୍ୟଧମଫଲାନି ଜନଯିତୁଂ ନ ଶକ୍ନୋତି, ତଥାଧମୋପି ପାଦପ ଉତ୍ତମଫଲାନି ଜନଯିତୁଂ ନ ଶକ୍ନୋତି| ");
INSERT INTO sanori_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","ଅପରଂ ଯେ ଯେ ପାଦପା ଅଧମଫଲାନି ଜନଯନ୍ତି, ତେ କୃତ୍ତା ୱହ୍ନୌ କ୍ଷିପ୍ୟନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ଅତଏୱ ଯୂଯଂ ଫଲେନ ତାନ୍ ପରିଚେଷ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","ଯେ ଜନା ମାଂ ପ୍ରଭୁଂ ୱଦନ୍ତି, ତେ ସର୍ୱ୍ୱେ ସ୍ୱର୍ଗରାଜ୍ୟଂ ପ୍ରୱେକ୍ଷ୍ୟନ୍ତି ତନ୍ନ, କିନ୍ତୁ ଯୋ ମାନୱୋ ମମ ସ୍ୱର୍ଗସ୍ଥସ୍ୟ ପିତୁରିଷ୍ଟଂ କର୍ମ୍ମ କରୋତି ସ ଏୱ ପ୍ରୱେକ୍ଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","ତଦ୍ ଦିନେ ବହୱୋ ମାଂ ୱଦିଷ୍ୟନ୍ତି, ହେ ପ୍ରଭୋ ହେ ପ୍ରଭୋ, ତୱ ନାମ୍ନା କିମସ୍ମାମି ର୍ଭୱିଷ୍ୟଦ୍ୱାକ୍ୟଂ ନ ୱ୍ୟାହୃତଂ? ତୱ ନାମ୍ନା ଭୂତାଃ କିଂ ନ ତ୍ୟାଜିତାଃ? ତୱ ନାମ୍ନା କିଂ ନାନାଦ୍ଭୁତାନି କର୍ମ୍ମାଣି ନ କୃତାନି? ");
INSERT INTO sanori_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","ତଦାହଂ ୱଦିଷ୍ୟାମି, ହେ କୁକର୍ମ୍ମକାରିଣୋ ଯୁଷ୍ମାନ୍ ଅହଂ ନ ୱେଦ୍ମି, ଯୂଯଂ ମତ୍ସମୀପାଦ୍ ଦୂରୀଭୱତ| ");
INSERT INTO sanori_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","ଯଃ କଶ୍ଚିତ୍ ମମୈତାଃ କଥାଃ ଶ୍ରୁତ୍ୱା ପାଲଯତି, ସ ପାଷାଣୋପରି ଗୃହନିର୍ମ୍ମାତ୍ରା ଜ୍ଞାନିନା ସହ ମଯୋପମୀଯତେ| ");
INSERT INTO sanori_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","ଯତୋ ୱୃଷ୍ଟୌ ସତ୍ୟାମ୍ ଆପ୍ଲାୱ ଆଗତେ ୱାଯୌ ୱାତେ ଚ ତେଷୁ ତଦ୍ଗେହଂ ଲଗ୍ନେଷୁ ପାଷାଣୋପରି ତସ୍ୟ ଭିତ୍ତେସ୍ତନ୍ନ ପତତିl ");
INSERT INTO sanori_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","କିନ୍ତୁ ଯଃ କଶ୍ଚିତ୍ ମମୈତାଃ କଥାଃ ଶ୍ରୁତ୍ୱା ନ ପାଲଯତି ସ ସୈକତେ ଗେହନିର୍ମ୍ମାତ୍ରା ଽଜ୍ଞାନିନା ଉପମୀଯତେ| ");
INSERT INTO sanori_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","ଯତୋ ଜଲୱୃଷ୍ଟୌ ସତ୍ୟାମ୍ ଆପ୍ଲାୱ ଆଗତେ ପୱନେ ୱାତେ ଚ ତୈ ର୍ଗୃହେ ସମାଘାତେ ତତ୍ ପତତି ତତ୍ପତନଂ ମହଦ୍ ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","ଯୀଶୁନୈତେଷୁ ୱାକ୍ୟେଷୁ ସମାପିତେଷୁ ମାନୱାସ୍ତଦୀଯୋପଦେଶମ୍ ଆଶ୍ଚର୍ୟ୍ୟଂ ମେନିରେ| ");
INSERT INTO sanori_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ଯସ୍ମାତ୍ ସ ଉପାଧ୍ୟାଯା ଇୱ ତାନ୍ ନୋପଦିଦେଶ କିନ୍ତୁ ସମର୍ଥପୁରୁଷଇୱ ସମୁପଦିଦେଶ| ");
INSERT INTO sanori_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","ଯଦା ସ ପର୍ୱ୍ୱତାଦ୍ ଅୱାରୋହତ୍ ତଦା ବହୱୋ ମାନୱାସ୍ତତ୍ପଶ୍ଚାଦ୍ ୱୱ୍ରଜୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ଏକଃ କୁଷ୍ଠୱାନ୍ ଆଗତ୍ୟ ତଂ ପ୍ରଣମ୍ୟ ବଭାଷେ, ହେ ପ୍ରଭୋ, ଯଦି ଭୱାନ୍ ସଂମନ୍ୟତେ, ତର୍ହି ମାଂ ନିରାମଯଂ କର୍ତ୍ତୁଂ ଶକ୍ନୋତି| ");
INSERT INTO sanori_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ତତୋ ଯୀଶୁଃ କରଂ ପ୍ରସାର୍ୟ୍ୟ ତସ୍ୟାଙ୍ଗଂ ସ୍ପୃଶନ୍ ୱ୍ୟାଜହାର, ସମ୍ମନ୍ୟେଽହଂ ତ୍ୱଂ ନିରାମଯୋ ଭୱ; ତେନ ସ ତତ୍କ୍ଷଣାତ୍ କୁଷ୍ଠେନାମୋଚି| ");
INSERT INTO sanori_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ତତୋ ଯୀଶୁସ୍ତଂ ଜଗାଦ, ଅୱଧେହି କଥାମେତାଂ କଶ୍ଚିଦପି ମା ବ୍ରୂହି, କିନ୍ତୁ ଯାଜକସ୍ୟ ସନ୍ନିଧିଂ ଗତ୍ୱା ସ୍ୱାତ୍ମାନଂ ଦର୍ଶଯ ମନୁଜେଭ୍ୟୋ ନିଜନିରାମଯତ୍ୱଂ ପ୍ରମାଣଯିତୁଂ ମୂସାନିରୂପିତଂ ଦ୍ରୱ୍ୟମ୍ ଉତ୍ସୃଜ ଚ| ");
INSERT INTO sanori_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","ତଦନନ୍ତରଂ ଯୀଶୁନା କଫର୍ନାହୂମ୍ନାମନି ନଗରେ ପ୍ରୱିଷ୍ଟେ କଶ୍ଚିତ୍ ଶତସେନାପତିସ୍ତତ୍ସମୀପମ୍ ଆଗତ୍ୟ ୱିନୀଯ ବଭାଷେ, ");
INSERT INTO sanori_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ହେ ପ୍ରଭୋ, ମଦୀଯ ଏକୋ ଦାସଃ ପକ୍ଷାଘାତୱ୍ୟାଧିନା ଭୃଶଂ ୱ୍ୟଥିତଃ, ସତୁ ଶଯନୀଯ ଆସ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ତଦାନୀଂ ଯୀଶୁସ୍ତସ୍ମୈ କଥିତୱାନ୍, ଅହଂ ଗତ୍ୱା ତଂ ନିରାମଯଂ କରିଷ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ତତଃ ସ ଶତସେନାପତିଃ ପ୍ରତ୍ୟୱଦତ୍, ହେ ପ୍ରଭୋ, ଭୱାନ୍ ଯତ୍ ମମ ଗେହମଧ୍ୟଂ ଯାତି ତଦ୍ୟୋଗ୍ୟଭାଜନଂ ନାହମସ୍ମି; ୱାଙ୍ମାତ୍ରମ୍ ଆଦିଶତୁ, ତେନୈୱ ମମ ଦାସୋ ନିରାମଯୋ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","ଯତୋ ମଯି ପରନିଧ୍ନେଽପି ମମ ନିଦେଶୱଶ୍ୟାଃ କତି କତି ସେନାଃ ସନ୍ତି, ତତ ଏକସ୍ମିନ୍ ଯାହୀତ୍ୟୁକ୍ତେ ସ ଯାତି, ତଦନ୍ୟସ୍ମିନ୍ ଏହୀତ୍ୟୁକ୍ତେ ସ ଆଯାତି, ତଥା ମମ ନିଜଦାସେ କର୍ମ୍ମୈତତ୍ କୁର୍ୱ୍ୱିତ୍ୟୁକ୍ତେ ସ ତତ୍ କରୋତି| ");
INSERT INTO sanori_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ତଦାନୀଂ ଯୀଶୁସ୍ତସ୍ୟୈତତ୍ ୱଚୋ ନିଶମ୍ୟ ୱିସ୍ମଯାପନ୍ନୋଽଭୂତ୍; ନିଜପଶ୍ଚାଦ୍ଗାମିନୋ ମାନୱାନ୍ ଅୱୋଚ୍ଚ, ଯୁଷ୍ମାନ୍ ତଥ୍ୟଂ ୱଚ୍ମି, ଇସ୍ରାଯେଲୀଯଲୋକାନାଂ ମଧ୍ୟେଽପି ନୈତାଦୃଶୋ ୱିଶ୍ୱାସୋ ମଯା ପ୍ରାପ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","ଅନ୍ୟଚ୍ଚାହଂ ଯୁଷ୍ମାନ୍ ୱଦାମି, ବହୱଃ ପୂର୍ୱ୍ୱସ୍ୟାଃ ପଶ୍ଚିମାଯାଶ୍ଚ ଦିଶ ଆଗତ୍ୟ ଇବ୍ରାହୀମା ଇସ୍ହାକା ଯାକୂବା ଚ ସାକମ୍ ମିଲିତ୍ୱା ସମୁପୱେକ୍ଷ୍ୟନ୍ତି; ");
INSERT INTO sanori_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","କିନ୍ତୁ ଯତ୍ର ସ୍ଥାନେ ରୋଦନଦନ୍ତଘର୍ଷଣେ ଭୱତସ୍ତସ୍ମିନ୍ ବହିର୍ଭୂତତମିସ୍ରେ ରାଜ୍ୟସ୍ୟ ସନ୍ତାନା ନିକ୍ଷେସ୍ୟନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ତତଃ ପରଂ ଯୀଶୁସ୍ତଂ ଶତସେନାପତିଂ ଜଗାଦ, ଯାହି, ତୱ ପ୍ରତୀତ୍ୟନୁସାରତୋ ମଙ୍ଗଲଂ ଭୂଯାତ୍; ତଦା ତସ୍ମିନ୍ନେୱ ଦଣ୍ଡେ ତଦୀଯଦାସୋ ନିରାମଯୋ ବଭୂୱ| ");
INSERT INTO sanori_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ଅନନ୍ତରଂ ଯୀଶୁଃ ପିତରସ୍ୟ ଗେହମୁପସ୍ଥାଯ ଜ୍ୱରେଣ ପୀଡିତାଂ ଶଯନୀଯସ୍ଥିତାଂ ତସ୍ୟ ଶ୍ୱଶ୍ରୂଂ ୱୀକ୍ଷାଞ୍ଚକ୍ରେ| ");
INSERT INTO sanori_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ତତସ୍ତେନ ତସ୍ୟାଃ କରସ୍ୟ ସ୍ପୃଷ୍ଟତୱାତ୍ ଜ୍ୱରସ୍ତାଂ ତତ୍ୟାଜ, ତଦା ସା ସମୁତ୍ଥାଯ ତାନ୍ ସିଷେୱେ| ");
INSERT INTO sanori_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","ଅନନ୍ତରଂ ସନ୍ଧ୍ୟାଯାଂ ସତ୍ୟାଂ ବହୁଶୋ ଭୂତଗ୍ରସ୍ତମନୁଜାନ୍ ତସ୍ୟ ସମୀପମ୍ ଆନିନ୍ୟୁଃ ସ ଚ ୱାକ୍ୟେନ ଭୂତାନ୍ ତ୍ୟାଜଯାମାସ, ସର୍ୱ୍ୱପ୍ରକାରପୀଡିତଜନାଂଶ୍ଚ ନିରାମଯାନ୍ ଚକାର; ");
INSERT INTO sanori_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ତସ୍ମାତ୍, ସର୍ୱ୍ୱା ଦୁର୍ବ୍ବଲତାସ୍ମାକଂ ତେନୈୱ ପରିଧାରିତା| ଅସ୍ମାକଂ ସକଲଂ ୱ୍ୟାଧିଂ ସଏୱ ସଂଗୃହୀତୱାନ୍| ଯଦେତଦ୍ୱଚନଂ ଯିଶଯିଯଭୱିଷ୍ୟଦ୍ୱାଦିନୋକ୍ତମାସୀତ୍, ତତ୍ତଦା ସଫଲମଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","ଅନନ୍ତରଂ ଯୀଶୁଶ୍ଚତୁର୍ଦିକ୍ଷୁ ଜନନିୱହଂ ୱିଲୋକ୍ୟ ତଟିନ୍ୟାଃ ପାରଂ ଯାତୁଂ ଶିଷ୍ୟାନ୍ ଆଦିଦେଶ| ");
INSERT INTO sanori_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ତଦାନୀମ୍ ଏକ ଉପାଧ୍ୟାଯ ଆଗତ୍ୟ କଥିତୱାନ୍, ହେ ଗୁରୋ, ଭୱାନ୍ ଯତ୍ର ଯାସ୍ୟତି ତତ୍ରାହମପି ଭୱତଃ ପଶ୍ଚାଦ୍ ଯାସ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ତତୋ ଯୀଶୁ ର୍ଜଗାଦ, କ୍ରୋଷ୍ଟୁଃ ସ୍ଥାତୁଂ ସ୍ଥାନଂ ୱିଦ୍ୟତେ, ୱିହାଯସୋ ୱିହଙ୍ଗମାନାଂ ନୀଡାନି ଚ ସନ୍ତି; କିନ୍ତୁ ମନୁଷ୍ୟପୁତ୍ରସ୍ୟ ଶିରଃ ସ୍ଥାପଯିତୁଂ ସ୍ଥାନଂ ନ ୱିଦ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","ଅନନ୍ତରମ୍ ଅପର ଏକଃ ଶିଷ୍ୟସ୍ତଂ ବଭାଷେ, ହେ ପ୍ରଭୋ, ପ୍ରଥମତୋ ମମ ପିତରଂ ଶ୍ମଶାନେ ନିଧାତୁଂ ଗମନାର୍ଥଂ ମାମ୍ ଅନୁମନ୍ୟସ୍ୱ| ");
INSERT INTO sanori_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ତତୋ ଯୀଶୁରୁକ୍ତୱାନ୍ ମୃତା ମୃତାନ୍ ଶ୍ମଶାନେ ନିଦଧତୁ, ତ୍ୱଂ ମମ ପଶ୍ଚାଦ୍ ଆଗଚ୍ଛ| ");
INSERT INTO sanori_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","ଅନନ୍ତରଂ ତସ୍ମିନ୍ ନାୱମାରୂଢେ ତସ୍ୟ ଶିଷ୍ୟାସ୍ତତ୍ପଶ୍ଚାତ୍ ଜଗ୍ମୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ପଶ୍ଚାତ୍ ସାଗରସ୍ୟ ମଧ୍ୟଂ ତେଷୁ ଗତେଷୁ ତାଦୃଶଃ ପ୍ରବଲୋ ଝଞ୍ଭ୍ଶନିଲ ଉଦତିଷ୍ଠତ୍, ଯେନ ମହାତରଙ୍ଗ ଉତ୍ଥାଯ ତରଣିଂ ଛାଦିତୱାନ୍, କିନ୍ତୁ ସ ନିଦ୍ରିତ ଆସୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ତଦା ଶିଷ୍ୟା ଆଗତ୍ୟ ତସ୍ୟ ନିଦ୍ରାଭଙ୍ଗଂ କୃତ୍ୱା କଥଯାମାସୁଃ, ହେ ପ୍ରଭୋ, ୱଯଂ ମ୍ରିଯାମହେ, ଭୱାନ୍ ଅସ୍ମାକଂ ପ୍ରାଣାନ୍ ରକ୍ଷତୁ| ");
INSERT INTO sanori_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ତଦା ସ ତାନ୍ ଉକ୍ତୱାନ୍, ହେ ଅଲ୍ପୱିଶ୍ୱାସିନୋ ଯୂଯଂ କୁତୋ ୱିଭୀଥ? ତତଃ ସ ଉତ୍ଥାଯ ୱାତଂ ସାଗରଞ୍ଚ ତର୍ଜଯାମାସ, ତତୋ ନିର୍ୱ୍ୱାତମଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","ଅପରଂ ମନୁଜା ୱିସ୍ମଯଂ ୱିଲୋକ୍ୟ କଥଯାମାସୁଃ, ଅହୋ ୱାତସରିତ୍ପତୀ ଅସ୍ୟ କିମାଜ୍ଞାଗ୍ରାହିଣୌ? କୀଦୃଶୋଽଯଂ ମାନୱଃ| ");
INSERT INTO sanori_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","ଅନନ୍ତରଂ ସ ପାରଂ ଗତ୍ୱା ଗିଦେରୀଯଦେଶମ୍ ଉପସ୍ଥିତୱାନ୍; ତଦା ଦ୍ୱୌ ଭୂତଗ୍ରସ୍ତମନୁଜୌ ଶ୍ମଶାନସ୍ଥାନାଦ୍ ବହି ର୍ଭୂତ୍ୱା ତଂ ସାକ୍ଷାତ୍ କୃତୱନ୍ତୌ, ତାୱେତାଦୃଶୌ ପ୍ରଚଣ୍ଡାୱାସ୍ତାଂ ଯତ୍ ତେନ ସ୍ଥାନେନ କୋପି ଯାତୁଂ ନାଶକ୍ନୋତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ତାୱୁଚୈଃ କଥଯାମାସତୁଃ, ହେ ଈଶ୍ୱରସ୍ୟ ସୂନୋ ଯୀଶୋ, ତ୍ୱଯା ସାକମ୍ ଆୱଯୋଃ କଃ ସମ୍ବନ୍ଧଃ? ନିରୂପିତକାଲାତ୍ ପ୍ରାଗେୱ କିମାୱାଭ୍ୟାଂ ଯାତନାଂ ଦାତୁମ୍ ଅତ୍ରାଗତୋସି? ");
INSERT INTO sanori_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ତଦାନୀଂ ତାଭ୍ୟାଂ କିଞ୍ଚିଦ୍ ଦୂରେ ୱରାହାଣାମ୍ ଏକୋ ମହାୱ୍ରଜୋଽଚରତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ତତୋ ଭୂତୌ ତୌ ତସ୍ୟାନ୍ତିକେ ୱିନୀଯ କଥଯାମାସତୁଃ, ଯଦ୍ୟାୱାଂ ତ୍ୟାଜଯସି, ତର୍ହି ୱରାହାଣାଂ ମଧ୍ୟେୱ୍ରଜମ୍ ଆୱାଂ ପ୍ରେରଯ| ");
INSERT INTO sanori_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ତଦା ଯୀଶୁରୱଦତ୍ ଯାତଂ, ଅନନ୍ତରଂ ତୌ ଯଦା ମନୁଜୌ ୱିହାଯ ୱରାହାନ୍ ଆଶ୍ରିତୱନ୍ତୌ, ତଦା ତେ ସର୍ୱ୍ୱେ ୱରାହା ଉଚ୍ଚସ୍ଥାନାତ୍ ମହାଜୱେନ ଧାୱନ୍ତଃ ସାଗରୀଯତୋଯେ ମଜ୍ଜନ୍ତୋ ମମ୍ରୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ତତୋ ୱରାହରକ୍ଷକାଃ ପଲାଯମାନା ମଧ୍ୟେନଗରଂ ତୌ ଭୂତଗ୍ରସ୍ତୌ ପ୍ରତି ଯଦ୍ୟଦ୍ ଅଘଟତ, ତାଃ ସର୍ୱ୍ୱୱାର୍ତ୍ତା ଅୱଦନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ତତୋ ନାଗରିକାଃ ସର୍ୱ୍ୱେ ମନୁଜା ଯୀଶୁଂ ସାକ୍ଷାତ୍ କର୍ତ୍ତୁଂ ବହିରାଯାତାଃ ତଞ୍ଚ ୱିଲୋକ୍ୟ ପ୍ରାର୍ଥଯାଞ୍ଚକ୍ରିରେ ଭୱାନ୍ ଅସ୍ମାକଂ ସୀମାତୋ ଯାତୁ| ");
INSERT INTO sanori_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ଅନନ୍ତରଂ ଯୀଶୁ ର୍ନୌକାମାରୁହ୍ୟ ପୁନଃ ପାରମାଗତ୍ୟ ନିଜଗ୍ରାମମ୍ ଆଯଯୌ| ");
INSERT INTO sanori_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ତତଃ କତିପଯା ଜନା ଏକଂ ପକ୍ଷାଘାତିନଂ ସ୍ୱଟ୍ଟୋପରି ଶାଯଯିତ୍ୱା ତତ୍ସମୀପମ୍ ଆନଯନ୍; ତତୋ ଯୀଶୁସ୍ତେଷାଂ ପ୍ରତୀତିଂ ୱିଜ୍ଞାଯ ତଂ ପକ୍ଷାଘାତିନଂ ଜଗାଦ, ହେ ପୁତ୍ର, ସୁସ୍ଥିରୋ ଭୱ, ତୱ କଲୁଷସ୍ୟ ମର୍ଷଣଂ ଜାତମ୍| ");
INSERT INTO sanori_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ତାଂ କଥାଂ ନିଶମ୍ୟ କିଯନ୍ତ ଉପାଧ୍ୟାଯା ମନଃସୁ ଚିନ୍ତିତୱନ୍ତ ଏଷ ମନୁଜ ଈଶ୍ୱରଂ ନିନ୍ଦତି| ");
INSERT INTO sanori_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ତତଃ ସ ତେଷାମ୍ ଏତାଦୃଶୀଂ ଚିନ୍ତାଂ ୱିଜ୍ଞାଯ କଥିତୱାନ୍, ଯୂଯଂ ମନଃସୁ କୃତ ଏତାଦୃଶୀଂ କୁଚିନ୍ତାଂ କୁରୁଥ? ");
INSERT INTO sanori_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","ତୱ ପାପମର୍ଷଣଂ ଜାତଂ, ଯଦ୍ୱା ତ୍ୱମୁତ୍ଥାଯ ଗଚ୍ଛ, ଦ୍ୱଯୋରନଯୋ ର୍ୱାକ୍ୟଯୋଃ କିଂ ୱାକ୍ୟଂ ୱକ୍ତୁଂ ସୁଗମଂ? ");
INSERT INTO sanori_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","କିନ୍ତୁ ମେଦିନ୍ୟାଂ କଲୁଷଂ କ୍ଷମିତୁଂ ମନୁଜସୁତସ୍ୟ ସାମର୍ଥ୍ୟମସ୍ତୀତି ଯୂଯଂ ଯଥା ଜାନୀଥ, ତଦର୍ଥଂ ସ ତଂ ପକ୍ଷାଘାତିନଂ ଗଦିତୱାନ୍, ଉତ୍ତିଷ୍ଠ, ନିଜଶଯନୀଯଂ ଆଦାଯ ଗେହଂ ଗଚ୍ଛ| ");
INSERT INTO sanori_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ତତଃ ସ ତତ୍କ୍ଷଣାଦ୍ ଉତ୍ଥାଯ ନିଜଗେହଂ ପ୍ରସ୍ଥିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ମାନୱା ଇତ୍ଥଂ ୱିଲୋକ୍ୟ ୱିସ୍ମଯଂ ମେନିରେ, ଈଶ୍ୱରେଣ ମାନୱାଯ ସାମର୍ଥ୍ୟମ୍ ଈଦୃଶଂ ଦତ୍ତଂ ଇତି କାରଣାତ୍ ତଂ ଧନ୍ୟଂ ବଭାଷିରେ ଚ| ");
INSERT INTO sanori_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ଅନନ୍ତରଂ ଯୀଶୁସ୍ତତ୍ସ୍ଥାନାଦ୍ ଗଚ୍ଛନ୍ ଗଚ୍ଛନ୍ କରସଂଗ୍ରହସ୍ଥାନେ ସମୁପୱିଷ୍ଟଂ ମଥିନାମାନମ୍ ଏକଂ ମନୁଜଂ ୱିଲୋକ୍ୟ ତଂ ବଭାଷେ, ମମ ପଶ୍ଚାଦ୍ ଆଗଚ୍ଛ, ତତଃ ସ ଉତ୍ଥାଯ ତସ୍ୟ ପଶ୍ଚାଦ୍ ୱୱ୍ରାଜ| ");
INSERT INTO sanori_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ତତଃ ପରଂ ଯୀଶୌ ଗୃହେ ଭୋକ୍ତୁମ୍ ଉପୱିଷ୍ଟେ ବହୱଃ କରସଂଗ୍ରାହିଣଃ କଲୁଷିଣଶ୍ଚ ମାନୱା ଆଗତ୍ୟ ତେନ ସାକଂ ତସ୍ୟ ଶିଷ୍ୟୈଶ୍ଚ ସାକମ୍ ଉପୱିୱିଶୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ଫିରୂଶିନସ୍ତଦ୍ ଦୃଷ୍ଟ୍ୱା ତସ୍ୟ ଶିଷ୍ୟାନ୍ ବଭାଷିରେ, ଯୁଷ୍ମାକଂ ଗୁରୁଃ କିଂ ନିମିତ୍ତଂ କରସଂଗ୍ରାହିଭିଃ କଲୁଷିଭିଶ୍ଚ ସାକଂ ଭୁଂକ୍ତେ? ");
INSERT INTO sanori_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ଯୀଶୁସ୍ତତ୍ ଶ୍ରୁତ୍ୱା ତାନ୍ ପ୍ରତ୍ୟୱଦତ୍, ନିରାମଯଲୋକାନାଂ ଚିକିତ୍ସକେନ ପ୍ରଯୋଜନଂ ନାସ୍ତି, କିନ୍ତୁ ସାମଯଲୋକାନାଂ ପ୍ରଯୋଜନମାସ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","ଅତୋ ଯୂଯଂ ଯାତ୍ୱା ୱଚନସ୍ୟାସ୍ୟାର୍ଥଂ ଶିକ୍ଷଧ୍ୱମ୍, ଦଯାଯାଂ ମେ ଯଥା ପ୍ରୀତି ର୍ନ ତଥା ଯଜ୍ଞକର୍ମ୍ମଣି| ଯତୋଽହଂ ଧାର୍ମ୍ମିକାନ୍ ଆହ୍ୱାତୁଂ ନାଗତୋଽସ୍ମି କିନ୍ତୁ ମନଃ ପରିୱର୍ତ୍ତଯିତୁଂ ପାପିନ ଆହ୍ୱାତୁମ୍ ଆଗତୋଽସ୍ମି| ");
INSERT INTO sanori_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","ଅନନ୍ତରଂ ଯୋହନଃ ଶିଷ୍ୟାସ୍ତସ୍ୟ ସମୀପମ୍ ଆଗତ୍ୟ କଥଯାମାସୁଃ, ଫିରୂଶିନୋ ୱଯଞ୍ଚ ପୁନଃ ପୁନରୁପୱସାମଃ, କିନ୍ତୁ ତୱ ଶିଷ୍ୟା ନୋପୱସନ୍ତି, କୁତଃ? ");
INSERT INTO sanori_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ତଦା ଯୀଶୁସ୍ତାନ୍ ଅୱୋଚତ୍ ଯାୱତ୍ ସଖୀନାଂ ସଂଙ୍ଗେ କନ୍ୟାଯା ୱରସ୍ତିଷ୍ଠତି, ତାୱତ୍ କିଂ ତେ ୱିଲାପଂ କର୍ତ୍ତୁଂ ଶକ୍ଲୁୱନ୍ତି? କିନ୍ତୁ ଯଦା ତେଷାଂ ସଂଙ୍ଗାଦ୍ ୱରଂ ନଯନ୍ତି, ତାଦୃଶଃ ସମଯ ଆଗମିଷ୍ୟତି, ତଦା ତେ ଉପୱତ୍ସ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","ପୁରାତନୱସନେ କୋପି ନୱୀନୱସ୍ତ୍ରଂ ନ ଯୋଜଯତି, ଯସ୍ମାତ୍ ତେନ ଯୋଜିତେନ ପୁରାତନୱସନଂ ଛିନତ୍ତି ତଚ୍ଛିଦ୍ରଞ୍ଚ ବହୁକୁତ୍ସିତଂ ଦୃଶ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ଅନ୍ୟଞ୍ଚ ପୁରାତନକୁତ୍ୱାଂ କୋପି ନୱାନଗୋସ୍ତନୀରସଂ ନ ନିଦଧାତି, ଯସ୍ମାତ୍ ତଥା କୃତେ କୁତୂ ର୍ୱିଦୀର୍ୟ୍ୟତେ ତେନ ଗୋସ୍ତନୀରସଃ ପତତି କୁତୂଶ୍ଚ ନଶ୍ୟତି; ତସ୍ମାତ୍ ନୱୀନାଯାଂ କୁତ୍ୱାଂ ନୱୀନୋ ଗୋସ୍ତନୀରସଃ ସ୍ଥାପ୍ୟତେ, ତେନ ଦ୍ୱଯୋରୱନଂ ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","ଅପରଂ ତେନୈତତ୍କଥାକଥନକାଲେ ଏକୋଽଧିପତିସ୍ତଂ ପ୍ରଣମ୍ୟ ବଭାଷେ, ମମ ଦୁହିତା ପ୍ରାଯେଣୈତାୱତ୍କାଲେ ମୃତା, ତସ୍ମାଦ୍ ଭୱାନାଗତ୍ୟ ତସ୍ୟା ଗାତ୍ରେ ହସ୍ତମର୍ପଯତୁ, ତେନ ସା ଜୀୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ତଦାନୀଂ ଯୀଶୁଃ ଶିଷ୍ୟୈଃ ସାକମ୍ ଉତ୍ଥାଯ ତସ୍ୟ ପଶ୍ଚାଦ୍ ୱୱ୍ରାଜ| ");
INSERT INTO sanori_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ଇତ୍ୟନନ୍ତରେ ଦ୍ୱାଦଶୱତ୍ସରାନ୍ ଯାୱତ୍ ପ୍ରଦରାମଯେନ ଶୀର୍ଣୈକା ନାରୀ ତସ୍ୟ ପଶ୍ଚାଦ୍ ଆଗତ୍ୟ ତସ୍ୟ ୱସନସ୍ୟ ଗ୍ରନ୍ଥିଂ ପସ୍ପର୍ଶ; ");
INSERT INTO sanori_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ଯସ୍ମାତ୍ ମଯା କେୱଲଂ ତସ୍ୟ ୱସନଂ ସ୍ପୃଷ୍ଟ୍ୱା ସ୍ୱାସ୍ଥ୍ୟଂ ପ୍ରାପ୍ସ୍ୟତେ, ସା ନାରୀତି ମନସି ନିଶ୍ଚିତୱତୀ| ");
INSERT INTO sanori_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ତତୋ ଯୀଶୁର୍ୱଦନଂ ପରାୱର୍ତ୍ତ୍ୟ ତାଂ ଜଗାଦ, ହେ କନ୍ୟେ, ତ୍ୱଂ ସୁସ୍ଥିରା ଭୱ, ତୱ ୱିଶ୍ୱାସସ୍ତ୍ୱାଂ ସ୍ୱସ୍ଥାମକାର୍ଷୀତ୍| ଏତଦ୍ୱାକ୍ୟେ ଗଦିତଏୱ ସା ଯୋଷିତ୍ ସ୍ୱସ୍ଥାଭୂତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","ଅପରଂ ଯୀଶୁସ୍ତସ୍ୟାଧ୍ୟକ୍ଷସ୍ୟ ଗେହଂ ଗତ୍ୱା ୱାଦକପ୍ରଭୃତୀନ୍ ବହୂନ୍ ଲୋକାନ୍ ଶବ୍ଦାଯମାନାନ୍ ୱିଲୋକ୍ୟ ତାନ୍ ଅୱଦତ୍, ");
INSERT INTO sanori_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ପନ୍ଥାନଂ ତ୍ୟଜ, କନ୍ୟେଯଂ ନାମ୍ରିଯତ ନିଦ୍ରିତାସ୍ତେ; କଥାମେତାଂ ଶ୍ରୁତ୍ୱା ତେ ତମୁପଜହସୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","କିନ୍ତୁ ସର୍ୱ୍ୱେଷୁ ବହିଷ୍କୃତେଷୁ ସୋଽଭ୍ୟନ୍ତରଂ ଗତ୍ୱା କନ୍ୟାଯାଃ କରଂ ଧୃତୱାନ୍, ତେନ ସୋଦତିଷ୍ଠତ୍; ");
INSERT INTO sanori_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ତତସ୍ତତ୍କର୍ମ୍ମଣୋ ଯଶଃ କୃତ୍ସ୍ନଂ ତଂ ଦେଶଂ ୱ୍ୟାପ୍ତୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","ତତଃ ପରଂ ଯୀଶୁସ୍ତସ୍ମାତ୍ ସ୍ଥାନାଦ୍ ଯାତ୍ରାଂ ଚକାର; ତଦା ହେ ଦାଯୂଦଃ ସନ୍ତାନ, ଅସ୍ମାନ୍ ଦଯସ୍ୱ, ଇତି ୱଦନ୍ତୌ ଦ୍ୱୌ ଜନାୱନ୍ଧୌ ପ୍ରୋଚୈରାହୂଯନ୍ତୌ ତତ୍ପଶ୍ଚାଦ୍ ୱୱ୍ରଜତୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ତତୋ ଯୀଶୌ ଗେହମଧ୍ୟଂ ପ୍ରୱିଷ୍ଟଂ ତାୱପି ତସ୍ୟ ସମୀପମ୍ ଉପସ୍ଥିତୱନ୍ତୌ, ତଦାନୀଂ ସ ତୌ ପୃଷ୍ଟୱାନ୍ କର୍ମ୍ମୈତତ୍ କର୍ତ୍ତୁଂ ମମ ସାମର୍ଥ୍ୟମ୍ ଆସ୍ତେ, ଯୁୱାଂ କିମିତି ପ୍ରତୀଥଃ? ତଦା ତୌ ପ୍ରତ୍ୟୂଚତୁଃ, ସତ୍ୟଂ ପ୍ରଭୋ| ");
INSERT INTO sanori_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","ତଦାନୀଂ ସ ତଯୋ ର୍ଲୋଚନାନି ସ୍ପୃଶନ୍ ବଭାଷେ, ଯୁୱଯୋଃ ପ୍ରତୀତ୍ୟନୁସାରାଦ୍ ଯୁୱଯୋ ର୍ମଙ୍ଗଲଂ ଭୂଯାତ୍| ତେନ ତତ୍କ୍ଷଣାତ୍ ତଯୋ ର୍ନେତ୍ରାଣି ପ୍ରସନ୍ନାନ୍ୟଭୱନ୍, ");
INSERT INTO sanori_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ପଶ୍ଚାଦ୍ ଯୀଶୁସ୍ତୌ ଦୃଢମାଜ୍ଞାପ୍ୟ ଜଗାଦ, ଅୱଧତ୍ତମ୍ ଏତାଂ କଥାଂ କୋପି ମନୁଜୋ ମ ଜାନୀଯାତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","କିନ୍ତୁ ତୌ ପ୍ରସ୍ଥାଯ ତସ୍ମିନ୍ କୃତ୍ସ୍ନେ ଦେଶେ ତସ୍ୟ କୀର୍ତ୍ତିଂ ପ୍ରକାଶଯାମାସତୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ଅପରଂ ତୌ ବହିର୍ୟାତ ଏତସ୍ମିନ୍ନନ୍ତରେ ମନୁଜା ଏକଂ ଭୂତଗ୍ରସ୍ତମୂକଂ ତସ୍ୟ ସମୀପମ୍ ଆନୀତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ତେନ ଭୂତେ ତ୍ୟାଜିତେ ସ ମୂକଃ କଥାଂ କଥଯିତୁଂ ପ୍ରାରଭତ, ତେନ ଜନା ୱିସ୍ମଯଂ ୱିଜ୍ଞାଯ କଥଯାମାସୁଃ, ଇସ୍ରାଯେଲୋ ୱଂଶେ କଦାପି ନେଦୃଗଦୃଶ୍ୟତ; ");
INSERT INTO sanori_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","କିନ୍ତୁ ଫିରୂଶିନଃ କଥଯାଞ୍ଚକ୍ରୁଃ ଭୂତାଧିପତିନା ସ ଭୂତାନ୍ ତ୍ୟାଜଯତି| ");
INSERT INTO sanori_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ତତଃ ପରଂ ଯୀଶୁସ୍ତେଷାଂ ଭଜନଭୱନ ଉପଦିଶନ୍ ରାଜ୍ୟସ୍ୟ ସୁସଂୱାଦଂ ପ୍ରଚାରଯନ୍ ଲୋକାନାଂ ଯସ୍ୟ ଯ ଆମଯୋ ଯା ଚ ପୀଡାସୀତ୍, ତାନ୍ ଶମଯନ୍ ଶମଯଂଶ୍ଚ ସର୍ୱ୍ୱାଣି ନଗରାଣି ଗ୍ରାମାଂଶ୍ଚ ବଭ୍ରାମ| ");
INSERT INTO sanori_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ଅନ୍ୟଞ୍ଚ ମନୁଜାନ୍ ୱ୍ୟାକୁଲାନ୍ ଅରକ୍ଷକମେଷାନିୱ ଚ ତ୍ୟକ୍ତାନ୍ ନିରୀକ୍ଷ୍ୟ ତେଷୁ କାରୁଣିକଃ ସନ୍ ଶିଷ୍ୟାନ୍ ଅୱଦତ୍, ");
INSERT INTO sanori_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ଶସ୍ୟାନି ପ୍ରଚୁରାଣି ସନ୍ତି, କିନ୍ତୁ ଛେତ୍ତାରଃ ସ୍ତୋକାଃ| ");
INSERT INTO sanori_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","କ୍ଷେତ୍ରଂ ପ୍ରତ୍ୟପରାନ୍ ଛେଦକାନ୍ ପ୍ରହେତୁଂ ଶସ୍ୟସ୍ୱାମିନଂ ପ୍ରାର୍ଥଯଧ୍ୱମ୍| ");
INSERT INTO sanori_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","ଅନନ୍ତରଂ ଯୀଶୁ ର୍ଦ୍ୱାଦଶଶିଷ୍ୟାନ୍ ଆହୂଯାମେଧ୍ୟଭୂତାନ୍ ତ୍ୟାଜଯିତୁଂ ସର୍ୱ୍ୱପ୍ରକାରରୋଗାନ୍ ପୀଡାଶ୍ଚ ଶମଯିତୁଂ ତେଭ୍ୟଃ ସାମର୍ଥ୍ୟମଦାତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","ତେଷାଂ ଦ୍ୱାଦଶପ୍ରେଷ୍ୟାଣାଂ ନାମାନ୍ୟେତାନି| ପ୍ରଥମଂ ଶିମୋନ୍ ଯଂ ପିତରଂ ୱଦନ୍ତି, ତତଃ ପରଂ ତସ୍ୟ ସହଜ ଆନ୍ଦ୍ରିଯଃ, ସିୱଦିଯସ୍ୟ ପୁତ୍ରୋ ଯାକୂବ୍ ");
INSERT INTO sanori_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ତସ୍ୟ ସହଜୋ ଯୋହନ୍; ଫିଲିପ୍ ବର୍ଥଲମଯ୍ ଥୋମାଃ କରସଂଗ୍ରାହୀ ମଥିଃ, ଆଲ୍ଫେଯପୁତ୍ରୋ ଯାକୂବ୍, ");
INSERT INTO sanori_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","କିନାନୀଯଃ ଶିମୋନ୍, ଯ ଈଷ୍କରିଯୋତୀଯଯିହୂଦାଃ ଖ୍ରୀଷ୍ଟଂ ପରକରେଽର୍ପଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ଏତାନ୍ ଦ୍ୱାଦଶଶିଷ୍ୟାନ୍ ଯୀଶୁଃ ପ୍ରେଷଯନ୍ ଇତ୍ୟାଜ୍ଞାପଯତ୍, ଯୂଯମ୍ ଅନ୍ୟଦେଶୀଯାନାଂ ପଦୱୀଂ ଶେମିରୋଣୀଯାନାଂ କିମପି ନଗରଞ୍ଚ ନ ପ୍ରୱିଶ୍ୟେ ");
INSERT INTO sanori_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ଇସ୍ରାଯେଲ୍ଗୋତ୍ରସ୍ୟ ହାରିତା ଯେ ଯେ ମେଷାସ୍ତେଷାମେୱ ସମୀପଂ ଯାତ| ");
INSERT INTO sanori_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","ଗତ୍ୱା ଗତ୍ୱା ସ୍ୱର୍ଗସ୍ୟ ରାଜତ୍ୱଂ ସୱିଧମଭୱତ୍, ଏତାଂ କଥାଂ ପ୍ରଚାରଯତ| ");
INSERT INTO sanori_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ଆମଯଗ୍ରସ୍ତାନ୍ ସ୍ୱସ୍ଥାନ୍ କୁରୁତ, କୁଷ୍ଠିନଃ ପରିଷ୍କୁରୁତ, ମୃତଲୋକାନ୍ ଜୀୱଯତ, ଭୂତାନ୍ ତ୍ୟାଜଯତ, ୱିନା ମୂଲ୍ୟଂ ଯୂଯମ୍ ଅଲଭଧ୍ୱଂ ୱିନୈୱ ମୂଲ୍ୟଂ ୱିଶ୍ରାଣଯତ| ");
INSERT INTO sanori_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","କିନ୍ତୁ ସ୍ୱେଷାଂ କଟିବନ୍ଧେଷୁ ସ୍ୱର୍ଣରୂପ୍ୟତାମ୍ରାଣାଂ କିମପି ନ ଗୃହ୍ଲୀତ| ");
INSERT INTO sanori_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ଅନ୍ୟଚ୍ଚ ଯାତ୍ରାଯୈ ଚେଲସମ୍ପୁଟଂ ୱା ଦ୍ୱିତୀଯୱସନଂ ୱା ପାଦୁକେ ୱା ଯଷ୍ଟିଃ, ଏତାନ୍ ମା ଗୃହ୍ଲୀତ, ଯତଃ କାର୍ୟ୍ୟକୃତ୍ ଭର୍ତ୍ତୁଂ ଯୋଗ୍ୟୋ ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","ଅପରଂ ଯୂଯଂ ଯତ୍ ପୁରଂ ଯଞ୍ଚ ଗ୍ରାମଂ ପ୍ରୱିଶଥ, ତତ୍ର ଯୋ ଜନୋ ଯୋଗ୍ୟପାତ୍ରଂ ତମୱଗତ୍ୟ ଯାନକାଲଂ ଯାୱତ୍ ତତ୍ର ତିଷ୍ଠତ| ");
INSERT INTO sanori_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ଯଦା ଯୂଯଂ ତଦ୍ଗେହଂ ପ୍ରୱିଶଥ, ତଦା ତମାଶିଷଂ ୱଦତ| ");
INSERT INTO sanori_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ଯଦି ସ ଯୋଗ୍ୟପାତ୍ରଂ ଭୱତି, ତର୍ହି ତତ୍କଲ୍ୟାଣଂ ତସ୍ମୈ ଭୱିଷ୍ୟତି, ନୋଚେତ୍ ସାଶୀର୍ୟୁଷ୍ମଭ୍ୟମେୱ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","କିନ୍ତୁ ଯେ ଜନା ଯୁଷ୍ମାକମାତିଥ୍ୟଂ ନ ୱିଦଧତି ଯୁଷ୍ମାକଂ କଥାଞ୍ଚ ନ ଶୃଣ୍ୱନ୍ତି ତେଷାଂ ଗେହାତ୍ ପୁରାଦ୍ୱା ପ୍ରସ୍ଥାନକାଲେ ସ୍ୱପଦୂଲୀଃ ପାତଯତ| ");
INSERT INTO sanori_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","ଯୁଷ୍ମାନହଂ ତଥ୍ୟଂ ୱଚ୍ମି ୱିଚାରଦିନେ ତତ୍ପୁରସ୍ୟ ଦଶାତଃ ସିଦୋମମୋରାପୁରଯୋର୍ଦଶା ସହ୍ୟତରା ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","ପଶ୍ୟତ, ୱୃକଯୂଥମଧ୍ୟେ ମେଷଃ ଯଥାୱିସ୍ତଥା ଯୁଷ୍ମାନ ପ୍ରହିଣୋମି, ତସ୍ମାଦ୍ ଯୂଯମ୍ ଅହିରିୱ ସତର୍କାଃ କପୋତାଇୱାହିଂସକା ଭୱତ| ");
INSERT INTO sanori_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","ନୃଭ୍ୟଃ ସାୱଧାନା ଭୱତ; ଯତସ୍ତୈ ର୍ୟୂଯଂ ରାଜସଂସଦି ସମର୍ପିଷ୍ୟଧ୍ୱେ ତେଷାଂ ଭଜନଗେହେ ପ୍ରହାରିଷ୍ୟଧ୍ୱେ| ");
INSERT INTO sanori_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ଯୂଯଂ ମନ୍ନାମହେତୋଃ ଶାସ୍ତୃଣାଂ ରାଜ୍ଞାଞ୍ଚ ସମକ୍ଷଂ ତାନନ୍ୟଦେଶିନଶ୍ଚାଧି ସାକ୍ଷିତ୍ୱାର୍ଥମାନେଷ୍ୟଧ୍ୱେ| ");
INSERT INTO sanori_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","କିନ୍ତ୍ୱିତ୍ଥଂ ସମର୍ପିତା ଯୂଯଂ କଥଂ କିମୁତ୍ତରଂ ୱକ୍ଷ୍ୟଥ ତତ୍ର ମା ଚିନ୍ତଯତ, ଯତସ୍ତଦା ଯୁଷ୍ମାଭି ର୍ୟଦ୍ ୱକ୍ତୱ୍ୟଂ ତତ୍ ତଦ୍ଦଣ୍ଡେ ଯୁଷ୍ମନ୍ମନଃ ସୁ ସମୁପସ୍ଥାସ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ଯସ୍ମାତ୍ ତଦା ଯୋ ୱକ୍ଷ୍ୟତି ସ ନ ଯୂଯଂ କିନ୍ତୁ ଯୁଷ୍ମାକମନ୍ତରସ୍ଥଃ ପିତ୍ରାତ୍ମା| ");
INSERT INTO sanori_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","ସହଜଃ ସହଜଂ ତାତଃ ସୁତଞ୍ଚ ମୃତୌ ସମର୍ପଯିଷ୍ୟତି, ଅପତ୍ୟାଗି ସ୍ୱସ୍ୱପିତ୍ରୋे ର୍ୱିପକ୍ଷୀଭୂଯ ତୌ ଘାତଯିଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","ମନ୍ନମହେତୋଃ ସର୍ୱ୍ୱେ ଜନା ଯୁଷ୍ମାନ୍ ଋृତୀଯିଷ୍ୟନ୍ତେ, କିନ୍ତୁ ଯଃ ଶେଷଂ ଯାୱଦ୍ ଧୈର୍ୟ୍ୟଂ ଘୃତ୍ୱା ସ୍ଥାସ୍ୟତି, ସ ତ୍ରାଯିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","ତୈ ର୍ୟଦା ଯୂଯମେକପୁରେ ତାଡିଷ୍ୟଧ୍ୱେ, ତଦା ଯୂଯମନ୍ୟପୁରଂ ପଲାଯଧ୍ୱଂ ଯୁଷ୍ମାନହଂ ତଥ୍ୟଂ ୱଚ୍ମି ଯାୱନ୍ମନୁଜସୁତୋ ନୈତି ତାୱଦ୍ ଇସ୍ରାଯେଲ୍ଦେଶୀଯସର୍ୱ୍ୱନଗରଭ୍ରମଣଂ ସମାପଯିତୁଂ ନ ଶକ୍ଷ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","ଗୁରୋଃ ଶିଷ୍ୟୋ ନ ମହାନ୍, ପ୍ରଭୋର୍ଦାସୋ ନ ମହାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","ଯଦି ଶିଷ୍ୟୋ ନିଜଗୁରୋ ର୍ଦାସଶ୍ଚ ସ୍ୱପ୍ରଭୋଃ ସମାନୋ ଭୱତି ତର୍ହି ତଦ୍ ଯଥେଷ୍ଟଂ| ଚେତ୍ତୈର୍ଗୃହପତିର୍ଭୂତରାଜ ଉଚ୍ୟତେ, ତର୍ହି ପରିୱାରାଃ କିଂ ତଥା ନ ୱକ୍ଷ୍ୟନ୍ତେ? ");
INSERT INTO sanori_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","କିନ୍ତୁ ତେଭ୍ୟୋ ଯୂଯଂ ମା ବିଭୀତ, ଯତୋ ଯନ୍ନ ପ୍ରକାଶିଷ୍ୟତେ, ତାଦୃକ୍ ଛାଦିତଂ କିମପି ନାସ୍ତି, ଯଚ୍ଚ ନ ୱ୍ୟଞ୍ଚିଷ୍ୟତେ, ତାଦୃଗ୍ ଗୁପ୍ତଂ କିମପି ନାସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ଯଦହଂ ଯୁଷ୍ମାନ୍ ତମସି ୱଚ୍ମି ତଦ୍ ଯୁଷ୍ମାଭିର୍ଦୀପ୍ତୌ କଥ୍ୟତାଂ; କର୍ଣାଭ୍ୟାଂ ଯତ୍ ଶ୍ରୂଯତେ ତଦ୍ ଗେହୋପରି ପ୍ରଚାର୍ୟ୍ୟତାଂ| ");
INSERT INTO sanori_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ଯେ କାଯଂ ହନ୍ତୁଂ ଶକ୍ନୁୱନ୍ତି ନାତ୍ମାନଂ, ତେଭ୍ୟୋ ମା ଭୈଷ୍ଟ; ଯଃ କାଯାତ୍ମାନୌ ନିରଯେ ନାଶଯିତୁଂ, ଶକ୍ନୋତି, ତତୋ ବିଭୀତ| ");
INSERT INTO sanori_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ଦ୍ୱୌ ଚଟକୌ କିମେକତାମ୍ରମୁଦ୍ରଯା ନ ୱିକ୍ରୀଯେତେ? ତଥାପି ଯୁଷ୍ମତ୍ତାତାନୁମତିଂ ୱିନା ତେଷାମେକୋପି ଭୁୱି ନ ପତତି| ");
INSERT INTO sanori_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","ଯୁଷ୍ମଚ୍ଛିରସାଂ ସର୍ୱ୍ୱକଚା ଗଣିତାଂଃ ସନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ଅତୋ ମା ବିଭୀତ, ଯୂଯଂ ବହୁଚଟକେଭ୍ୟୋ ବହୁମୂଲ୍ୟାଃ| ");
INSERT INTO sanori_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","ଯୋ ମନୁଜସାକ୍ଷାନ୍ମାମଙ୍ଗୀକୁରୁତେ ତମହଂ ସ୍ୱର୍ଗସ୍ଥତାତସାକ୍ଷାଦଙ୍ଗୀକରିଷ୍ୟେ| ");
INSERT INTO sanori_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ପୃଥ୍ୱ୍ୟାମହଂ ଶାନ୍ତିଂ ଦାତୁମାଗତଇତି ମାନୁଭୱତ, ଶାନ୍ତିଂ ଦାତୁଂ ନ କିନ୍ତ୍ୱସିଂ| ");
INSERT INTO sanori_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","ପିତୃମାତୃଶ୍ଚଶ୍ରୂଭିଃ ସାକଂ ସୁତସୁତାବଧୂ ର୍ୱିରୋଧଯିତୁଞ୍ଚାଗତେाସ୍ମି| ");
INSERT INTO sanori_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ତତଃ ସ୍ୱସ୍ୱପରିୱାରଏୱ ନୃଶତ୍ରୁ ର୍ଭୱିତା| ");
INSERT INTO sanori_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ଯଃ ପିତରି ମାତରି ୱା ମତ୍ତୋଧିକଂ ପ୍ରୀଯତେ, ସ ନ ମଦର୍ହଃ; ");
INSERT INTO sanori_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","ଯଶ୍ଚ ସୁତେ ସୁତାଯାଂ ୱା ମତ୍ତୋଧିକଂ ପ୍ରୀଯତେ, ସେाପି ନ ମଦର୍ହଃ| ");
INSERT INTO sanori_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ଯଃ ସ୍ୱକ୍ରୁଶଂ ଗୃହ୍ଲନ୍ ମତ୍ପଶ୍ଚାନ୍ନୈତି, ସେाପି ନ ମଦର୍ହଃ| ");
INSERT INTO sanori_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ଯଃ ସ୍ୱପ୍ରାଣାନୱତି, ସ ତାନ୍ ହାରଯିଷ୍ୟତେ, ଯସ୍ତୁ ମତ୍କୃତେ ସ୍ୱପ୍ରାଣାନ୍ ହାରଯତି, ସ ତାନୱତି| ");
INSERT INTO sanori_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","ଯୋ ଯୁଷ୍ମାକମାତିଥ୍ୟଂ ୱିଦଧାତି, ସ ମମାତିଥ୍ୟଂ ୱିଦଧାତି, ଯଶ୍ଚ ମମାତିଥ୍ୟଂ ୱିଦଧାତି, ସ ମତ୍ପ୍ରେରକସ୍ୟାତିଥ୍ୟଂ ୱିଦଧାତି| ");
INSERT INTO sanori_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ଯୋ ଭୱିଷ୍ୟଦ୍ୱାଦୀତି ଜ୍ଞାତ୍ୱା ତସ୍ୟାତିଥ୍ୟଂ ୱିଧତ୍ତେ, ସ ଭୱିଷ୍ୟଦ୍ୱାଦିନଃ ଫଲଂ ଲପ୍ସ୍ୟତେ, ଯଶ୍ଚ ଧାର୍ମ୍ମିକ ଇତି ୱିଦିତ୍ୱା ତସ୍ୟାତିଥ୍ୟଂ ୱିଧତ୍ତେ ସ ଧାର୍ମ୍ମିକମାନୱସ୍ୟ ଫଲଂ ପ୍ରାପ୍ସ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ଯଶ୍ଚ କଶ୍ଚିତ୍ ଏତେଷାଂ କ୍ଷୁଦ୍ରନରାଣାମ୍ ଯଂ କଞ୍ଚନୈକଂ ଶିଷ୍ୟ ଇତି ୱିଦିତ୍ୱା କଂସୈକଂ ଶୀତଲସଲିଲଂ ତସ୍ମୈ ଦତ୍ତେ, ଯୁଷ୍ମାନହଂ ତଥ୍ୟଂ ୱଦାମି, ସ କେନାପି ପ୍ରକାରେଣ ଫଲେନ ନ ୱଞ୍ଚିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ଇତ୍ଥଂ ଯୀଶୁଃ ସ୍ୱଦ୍ୱାଦଶଶିଷ୍ୟାଣାମାଜ୍ଞାପନଂ ସମାପ୍ୟ ପୁରେ ପୁର ଉପଦେଷ୍ଟୁଂ ସୁସଂୱାଦଂ ପ୍ରଚାରଯିତୁଂ ତତ୍ସ୍ଥାନାତ୍ ପ୍ରତସ୍ଥେ| ");
INSERT INTO sanori_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ଅନନ୍ତରଂ ଯୋହନ୍ କାରାଯାଂ ତିଷ୍ଠନ୍ ଖ୍ରିଷ୍ଟସ୍ୟ କର୍ମ୍ମଣାଂ ୱାର୍ତ୍ତଂ ପ୍ରାପ୍ୟ ଯସ୍ୟାଗମନୱାର୍ତ୍ତାସୀତ୍ ସଏୱ କିଂ ତ୍ୱଂ? ୱା ୱଯମନ୍ୟମ୍ ଅପେକ୍ଷିଷ୍ୟାମହେ? ");
INSERT INTO sanori_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ଏତତ୍ ପ୍ରଷ୍ଟୁଂ ନିଜୌ ଦ୍ୱୌ ଶିଷ୍ୟୌ ପ୍ରାହିଣୋତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ଯୀଶୁଃ ପ୍ରତ୍ୟୱୋଚତ୍, ଅନ୍ଧା ନେତ୍ରାଣି ଲଭନ୍ତେ, ଖଞ୍ଚା ଗଚ୍ଛନ୍ତି, କୁଷ୍ଠିନଃ ସ୍ୱସ୍ଥା ଭୱନ୍ତି, ବଧିରାଃ ଶୃଣ୍ୱନ୍ତି, ମୃତା ଜୀୱନ୍ତ ଉତ୍ତିଷ୍ଠନ୍ତି, ଦରିଦ୍ରାଣାଂ ସମୀପେ ସୁସଂୱାଦଃ ପ୍ରଚାର୍ୟ୍ୟତ, ");
INSERT INTO sanori_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ଏତାନି ଯଦ୍ୟଦ୍ ଯୁୱାଂ ଶୃଣୁଥଃ ପଶ୍ୟଥଶ୍ଚ ଗତ୍ୱା ତଦ୍ୱାର୍ତ୍ତାଂ ଯୋହନଂ ଗଦତଂ| ");
INSERT INTO sanori_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ଯସ୍ୟାହଂ ନ ୱିଘ୍ନୀଭୱାମି, ସଏୱ ଧନ୍ୟଃ| ");
INSERT INTO sanori_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ଅନନ୍ତରଂ ତଯୋଃ ପ୍ରସ୍ଥିତଯୋ ର୍ୟୀଶୁ ର୍ୟୋହନମ୍ ଉଦ୍ଦିଶ୍ୟ ଜନାନ୍ ଜଗାଦ, ଯୂଯଂ କିଂ ଦ୍ରଷ୍ଟୁଂ ୱହିର୍ମଧ୍ୟେପ୍ରାନ୍ତରମ୍ ଅଗଚ୍ଛତ? କିଂ ୱାତେନ କମ୍ପିତଂ ନଲଂ? ");
INSERT INTO sanori_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","ୱା କିଂ ୱୀକ୍ଷିତୁଂ ୱହିର୍ଗତୱନ୍ତଃ? କିଂ ପରିହିତସୂକ୍ଷ୍ମୱସନଂ ମନୁଜମେକଂ? ପଶ୍ୟତ, ଯେ ସୂକ୍ଷ୍ମୱସନାନି ପରିଦଧତି, ତେ ରାଜଧାନ୍ୟାଂ ତିଷ୍ଠନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ତର୍ହି ଯୂଯଂ କିଂ ଦ୍ରଷ୍ଟୁଂ ବହିରଗମତ, କିମେକଂ ଭୱିଷ୍ୟଦ୍ୱାଦିନଂ? ତଦେୱ ସତ୍ୟଂ| ଯୁଷ୍ମାନହଂ ୱଦାମି, ସ ଭୱିଷ୍ୟଦ୍ୱାଦିନୋପି ମହାନ୍; ");
INSERT INTO sanori_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","ଯତଃ, ପଶ୍ୟ ସ୍ୱକୀଯଦୂତୋଯଂ ତ୍ୱଦଗ୍ରେ ପ୍ରେଷ୍ୟତେ ମଯା| ସ ଗତ୍ୱା ତୱ ପନ୍ଥାନଂ ସ୍ମଯକ୍ ପରିଷ୍କରିଷ୍ୟତି|| ଏତଦ୍ୱଚନଂ ଯମଧି ଲିଖିତମାସ୍ତେ ସୋଽଯଂ ଯୋହନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","ଅପରଂ ଯୁଷ୍ମାନହଂ ତଥ୍ୟଂ ବ୍ରୱୀମି, ମଜ୍ଜଯିତୁ ର୍ୟୋହନଃ ଶ୍ରେଷ୍ଠଃ କୋପି ନାରୀତୋ ନାଜାଯତ; ତଥାପି ସ୍ୱର୍ଗରାଜ୍ୟମଧ୍ୟେ ସର୍ୱ୍ୱେଭ୍ୟୋ ଯଃ କ୍ଷୁଦ୍ରଃ ସ ଯୋହନଃ ଶ୍ରେଷ୍ଠଃ| ");
INSERT INTO sanori_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","ଅପରଞ୍ଚ ଆ ଯୋହନୋଽଦ୍ୟ ଯାୱତ୍ ସ୍ୱର୍ଗରାଜ୍ୟଂ ବଲାଦାକ୍ରାନ୍ତଂ ଭୱତି ଆକ୍ରମିନଶ୍ଚ ଜନା ବଲେନ ତଦଧିକୁର୍ୱ୍ୱନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","ଯତୋ ଯୋହନଂ ଯାୱତ୍ ସର୍ୱ୍ୱଭୱିଷ୍ୟଦ୍ୱାଦିଭି ର୍ୱ୍ୟୱସ୍ଥଯା ଚ ଉପଦେଶଃ ପ୍ରାକାଶ୍ୟତ| ");
INSERT INTO sanori_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ଯଦି ଯୂଯମିଦଂ ୱାକ୍ୟଂ ଗ୍ରହୀତୁଂ ଶକ୍ନୁଥ, ତର୍ହି ଶ୍ରେଯଃ, ଯସ୍ୟାଗମନସ୍ୟ ୱଚନମାସ୍ତେ ସୋଽଯମ୍ ଏଲିଯଃ| ");
INSERT INTO sanori_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ଯସ୍ୟ ଶ୍ରୋତୁଂ କର୍ଣୌ ସ୍ତଃ ସ ଶୃଣୋତୁ| ");
INSERT INTO sanori_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","ଏତେ ୱିଦ୍ୟମାନଜନାଃ କୈ ର୍ମଯୋପମୀଯନ୍ତେ? ଯେ ବାଲକା ହଟ୍ଟ ଉପୱିଶ୍ୟ ସ୍ୱଂ ସ୍ୱଂ ବନ୍ଧୁମାହୂଯ ୱଦନ୍ତି, ");
INSERT INTO sanori_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ୱଯଂ ଯୁଷ୍ମାକଂ ସମୀପେ ୱଂଶୀରୱାଦଯାମ, କିନ୍ତୁ ଯୂଯଂ ନାନୃତ୍ୟତ; ଯୁଷ୍ମାକଂ ସମୀପେ ଚ ୱଯମରୋଦିମ, କିନ୍ତୁ ଯୂଯଂ ନ ୱ୍ୟଲପତ, ତାଦୃଶୈ ର୍ବାଲକୈସ୍ତ ଉପମାଯିଷ୍ୟନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","ଯତୋ ଯୋହନ୍ ଆଗତ୍ୟ ନ ଭୁକ୍ତୱାନ୍ ନ ପୀତୱାଂଶ୍ଚ, ତେନ ଲୋକା ୱଦନ୍ତି, ସ ଭୂତଗ୍ରସ୍ତ ଇତି| ");
INSERT INTO sanori_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","ମନୁଜସୁତ ଆଗତ୍ୟ ଭୁକ୍ତୱାନ୍ ପୀତୱାଂଶ୍ଚ, ତେନ ଲୋକା ୱଦନ୍ତି, ପଶ୍ୟତ ଏଷ ଭୋକ୍ତା ମଦ୍ୟପାତା ଚଣ୍ଡାଲପାପିନାଂ ବନ୍ଧଶ୍ଚ, କିନ୍ତୁ ଜ୍ଞାନିନୋ ଜ୍ଞାନୱ୍ୟୱହାରଂ ନିର୍ଦୋଷଂ ଜାନନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ସ ଯତ୍ର ଯତ୍ର ପୁରେ ବହ୍ୱାଶ୍ଚର୍ୟ୍ୟଂ କର୍ମ୍ମ କୃତୱାନ୍, ତନ୍ନିୱାସିନାଂ ମନଃପରାୱୃତ୍ତ୍ୟଭାୱାତ୍ ତାନି ନଗରାଣି ପ୍ରତି ହନ୍ତେତ୍ୟୁକ୍ତା କଥିତୱାନ୍, ");
INSERT INTO sanori_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","ହା କୋରାସୀନ୍, ହା ବୈତ୍ସୈଦେ, ଯୁଷ୍ମନ୍ମଧ୍ୟେ ଯଦ୍ୟଦାଶ୍ଚର୍ୟ୍ୟଂ କର୍ମ୍ମ କୃତଂ ଯଦି ତତ୍ ସୋରସୀଦୋନ୍ନଗର ଅକାରିଷ୍ୟତ, ତର୍ହି ପୂର୍ୱ୍ୱମେୱ ତନ୍ନିୱାସିନଃ ଶାଣୱସନେ ଭସ୍ମନି ଚୋପୱିଶନ୍ତୋ ମନାଂସି ପରାୱର୍ତ୍ତିଷ୍ୟନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","ତସ୍ମାଦହଂ ଯୁଷ୍ମାନ୍ ୱଦାମି, ୱିଚାରଦିନେ ଯୁଷ୍ମାକଂ ଦଶାତଃ ସୋରସୀଦୋନୋ ର୍ଦଶା ସହ୍ୟତରା ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","ଅପରଞ୍ଚ ବତ କଫର୍ନାହୂମ୍, ତ୍ୱଂ ସ୍ୱର୍ଗଂ ଯାୱଦୁନ୍ନତୋସି, କିନ୍ତୁ ନରକେ ନିକ୍ଷେପ୍ସ୍ୟସେ, ଯସ୍ମାତ୍ ତ୍ୱଯି ଯାନ୍ୟାଶ୍ଚର୍ୟ୍ୟାଣି କର୍ମ୍ମଣ୍ୟକାରିଷତ, ଯଦି ତାନି ସିଦୋମ୍ନଗର ଅକାରିଷ୍ୟନ୍ତ, ତର୍ହି ତଦଦ୍ୟ ଯାୱଦସ୍ଥାସ୍ୟତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","କିନ୍ତ୍ୱହଂ ଯୁଷ୍ମାନ୍ ୱଦାମି, ୱିଚାରଦିନେ ତୱ ଦଣ୍ଡତଃ ସିଦୋମୋ ଦଣ୍ଡୋ ସହ୍ୟତରୋ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ଏତସ୍ମିନ୍ନେୱ ସମଯେ ଯୀଶୁଃ ପୁନରୁୱାଚ, ହେ ସ୍ୱର୍ଗପୃଥିୱ୍ୟୋରେକାଧିପତେ ପିତସ୍ତ୍ୱଂ ଜ୍ଞାନୱତୋ ୱିଦୁଷଶ୍ଚ ଲୋକାନ୍ ପ୍ରତ୍ୟେତାନି ନ ପ୍ରକାଶ୍ୟ ବାଲକାନ୍ ପ୍ରତି ପ୍ରକାଶିତୱାନ୍, ଇତି ହେତୋସ୍ତ୍ୱାଂ ଧନ୍ୟଂ ୱଦାମି| ");
INSERT INTO sanori_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ହେ ପିତଃ, ଇତ୍ଥଂ ଭୱେତ୍ ଯତ ଇଦଂ ତ୍ୱଦୃଷ୍ଟାୱୁତ୍ତମଂ| ");
INSERT INTO sanori_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","ପିତ୍ରା ମଯି ସର୍ୱ୍ୱାଣି ସମର୍ପିତାନି, ପିତରଂ ୱିନା କୋପି ପୁତ୍ରଂ ନ ଜାନାତି, ଯାନ୍ ପ୍ରତି ପୁତ୍ରେଣ ପିତା ପ୍ରକାଶ୍ୟତେ ତାନ୍ ୱିନା ପୁତ୍ରାଦ୍ ଅନ୍ୟଃ କୋପି ପିତରଂ ନ ଜାନାତି| ");
INSERT INTO sanori_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","ହେ ପରିଶ୍ରାନ୍ତା ଭାରାକ୍ରାନ୍ତାଶ୍ଚ ଲୋକା ଯୂଯଂ ମତ୍ସନ୍ନିଧିମ୍ ଆଗଚ୍ଛତ, ଅହଂ ଯୁଷ୍ମାନ୍ ୱିଶ୍ରମଯିଷ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ଅହଂ କ୍ଷମଣଶୀଲୋ ନମ୍ରମନାଶ୍ଚ, ତସ୍ମାତ୍ ମମ ଯୁଗଂ ସ୍ୱେଷାମୁପରି ଧାରଯତ ମତ୍ତଃ ଶିକ୍ଷଧ୍ୱଞ୍ଚ, ତେନ ଯୂଯଂ ସ୍ୱେ ସ୍ୱେ ମନସି ୱିଶ୍ରାମଂ ଲପ୍ସ୍ୟଧ୍ବେ| ");
INSERT INTO sanori_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ଯତୋ ମମ ଯୁଗମ୍ ଅନାଯାସଂ ମମ ଭାରଶ୍ଚ ଲଘୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","ଅନନ୍ତରଂ ଯୀଶୁ ର୍ୱିଶ୍ରାମୱାରେ ଶ୍ସ୍ୟମଧ୍ୟେନ ଗଚ୍ଛତି, ତଦା ତଚ୍ଛିଷ୍ୟା ବୁଭୁକ୍ଷିତାଃ ସନ୍ତଃ ଶ୍ସ୍ୟମଞ୍ଜରୀଶ୍ଛତ୍ୱା ଛିତ୍ୱା ଖାଦିତୁମାରଭନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ତଦ୍ ୱିଲୋକ୍ୟ ଫିରୂଶିନୋ ଯୀଶୁଂ ଜଗଦୁଃ, ପଶ୍ୟ ୱିଶ୍ରାମୱାରେ ଯତ୍ କର୍ମ୍ମାକର୍ତ୍ତୱ୍ୟଂ ତଦେୱ ତୱ ଶିଷ୍ୟାଃ କୁର୍ୱ୍ୱନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ସ ତାନ୍ ପ୍ରତ୍ୟାୱଦତ, ଦାଯୂଦ୍ ତତ୍ସଙ୍ଗିନଶ୍ଚ ବୁଭୁକ୍ଷିତାଃ ସନ୍ତୋ ଯତ୍ କର୍ମ୍ମାକୁର୍ୱ୍ୱନ୍ ତତ୍ କିଂ ଯୁଷ୍ମାଭି ର୍ନାପାଠି? ");
INSERT INTO sanori_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ଯେ ଦର୍ଶନୀଯାଃ ପୂପାଃ ଯାଜକାନ୍ ୱିନା ତସ୍ୟ ତତ୍ସଙ୍ଗିମନୁଜାନାଞ୍ଚାଭୋଜନୀଯାସ୍ତ ଈଶ୍ୱରାୱାସଂ ପ୍ରୱିଷ୍ଟେନ ତେନ ଭୁକ୍ତାଃ| ");
INSERT INTO sanori_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","ଅନ୍ୟଚ୍ଚ ୱିଶ୍ରାମୱାରେ ମଧ୍ୟେମନ୍ଦିରଂ ୱିଶ୍ରାମୱାରୀଯଂ ନିଯମଂ ଲଙ୍ୱନ୍ତୋପି ଯାଜକା ନିର୍ଦୋଷା ଭୱନ୍ତି, ଶାସ୍ତ୍ରମଧ୍ୟେ କିମିଦମପି ଯୁଷ୍ମାଭି ର୍ନ ପଠିତଂ? ");
INSERT INTO sanori_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","ଯୁଷ୍ମାନହଂ ୱଦାମି, ଅତ୍ର ସ୍ଥାନେ ମନ୍ଦିରାଦପି ଗରୀଯାନ୍ ଏକ ଆସ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","କିନ୍ତୁ ଦଯାଯାଂ ମେ ଯଥା ପ୍ରୀତି ର୍ନ ତଥା ଯଜ୍ଞକର୍ମ୍ମଣି| ଏତଦ୍ୱଚନସ୍ୟାର୍ଥଂ ଯଦି ଯୁଯମ୍ ଅଜ୍ଞାସିଷ୍ଟ ତର୍ହି ନିର୍ଦୋଷାନ୍ ଦୋଷିଣୋ ନାକାର୍ଷ୍ଟ| ");
INSERT INTO sanori_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","ଅନ୍ୟଚ୍ଚ ମନୁଜସୁତୋ ୱିଶ୍ରାମୱାରସ୍ୟାପି ପତିରାସ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ଅନନ୍ତରଂ ସ ତତ୍ସ୍ଥାନାତ୍ ପ୍ରସ୍ଥାଯ ତେଷାଂ ଭଜନଭୱନଂ ପ୍ରୱିଷ୍ଟୱାନ୍, ତଦାନୀମ୍ ଏକଃ ଶୁଷ୍କକରାମଯୱାନ୍ ଉପସ୍ଥିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ତତୋ ଯୀଶୁମ୍ ଅପୱଦିତୁଂ ମାନୁଷାଃ ପପ୍ରଚ୍ଛୁଃ, ୱିଶ୍ରାମୱାରେ ନିରାମଯତ୍ୱଂ କରଣୀଯଂ ନ ୱା? ");
INSERT INTO sanori_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ତେନ ସ ପ୍ରତ୍ୟୁୱାଚ, ୱିଶ୍ରାମୱାରେ ଯଦି କସ୍ୟଚିଦ୍ ଅୱି ର୍ଗର୍ତ୍ତେ ପତତି, ତର୍ହି ଯସ୍ତଂ ଘୃତ୍ୱା ନ ତୋଲଯତି, ଏତାଦୃଶୋ ମନୁଜୋ ଯୁଷ୍ମାକଂ ମଧ୍ୟେ କ ଆସ୍ତେ? ");
INSERT INTO sanori_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ଅୱେ ର୍ମାନୱଃ କିଂ ନହି ଶ୍ରେଯାନ୍? ଅତୋ ୱିଶ୍ରାମୱାରେ ହିତକର୍ମ୍ମ କର୍ତ୍ତୱ୍ୟଂ| ");
INSERT INTO sanori_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","ଅନନ୍ତରଂ ସ ତଂ ମାନୱଂ ଗଦିତୱାନ୍, କରଂ ପ୍ରସାରଯ; ତେନ କରେ ପ୍ରସାରିତେ ସୋନ୍ୟକରୱତ୍ ସ୍ୱସ୍ଥୋଽଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ତଦା ଫିରୂଶିନୋ ବହିର୍ଭୂଯ କଥଂ ତଂ ହନିଷ୍ୟାମ ଇତି କୁମନ୍ତ୍ରଣାଂ ତତ୍ପ୍ରାତିକୂଲ୍ୟେନ ଚକ୍ରୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ତତୋ ଯୀଶୁସ୍ତଦ୍ ୱିଦିତ୍ୱା ସ୍ଥନାନ୍ତରଂ ଗତୱାନ୍; ଅନ୍ୟେଷୁ ବହୁନରେଷୁ ତତ୍ପଶ୍ଚାଦ୍ ଗତେଷୁ ତାନ୍ ସ ନିରାମଯାନ୍ କୃତ୍ୱା ଇତ୍ୟାଜ୍ଞାପଯତ୍, ");
INSERT INTO sanori_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ଯୂଯଂ ମାଂ ନ ପରିଚାଯଯତ| ");
INSERT INTO sanori_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ତସ୍ମାତ୍ ମମ ପ୍ରୀଯୋ ମନୋନୀତୋ ମନସସ୍ତୁଷ୍ଟିକାରକଃ| ମଦୀଯଃ ସେୱକୋ ଯସ୍ତୁ ୱିଦ୍ୟତେ ତଂ ସମୀକ୍ଷତାଂ| ତସ୍ୟୋପରି ସ୍ୱକୀଯାତ୍ମା ମଯା ସଂସ୍ଥାପଯିଷ୍ୟତେ| ତେନାନ୍ୟଦେଶଜାତେଷୁ ୱ୍ୟୱସ୍ଥା ସଂପ୍ରକାଶ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","କେନାପି ନ ୱିରୋଧଂ ସ ୱିୱାଦଞ୍ଚ କରିଷ୍ୟତି| ନ ଚ ରାଜପଥେ ତେନ ୱଚନଂ ଶ୍ରାୱଯିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ୱ୍ୟୱସ୍ଥା ଚଲିତା ଯାୱତ୍ ନହି ତେନ କରିଷ୍ୟତେ| ତାୱତ୍ ନଲୋ ୱିଦୀର୍ଣୋଽପି ଭଂକ୍ଷ୍ୟତେ ନହି ତେନ ଚ| ତଥା ସଧୂମୱର୍ତ୍ତିଞ୍ଚ ନ ସ ନିର୍ୱ୍ୱାପଯିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ପ୍ରତ୍ୟାଶାଞ୍ଚ କରିଷ୍ୟନ୍ତି ତନ୍ନାମ୍ନି ଭିନ୍ନଦେଶଜାଃ| ");
INSERT INTO sanori_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ଯାନ୍ୟେତାନି ୱଚନାନି ଯିଶଯିଯଭୱିଷ୍ୟଦ୍ୱାଦିନା ପ୍ରୋକ୍ତାନ୍ୟାସନ୍, ତାନି ସଫଲାନ୍ୟଭୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","ଅନନ୍ତରଂ ଲୋକୈ ସ୍ତତ୍ସମୀପମ୍ ଆନୀତୋ ଭୂତଗ୍ରସ୍ତାନ୍ଧମୂକୈକମନୁଜସ୍ତେନ ସ୍ୱସ୍ଥୀକୃତଃ, ତତଃ ସୋଽନ୍ଧୋ ମୂକୋ ଦ୍ରଷ୍ଟୁଂ ୱକ୍ତୁଞ୍ଚାରବ୍ଧୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ଅନେନ ସର୍ୱ୍ୱେ ୱିସ୍ମିତାଃ କଥଯାଞ୍ଚକ୍ରୁଃ, ଏଷଃ କିଂ ଦାଯୂଦଃ ସନ୍ତାନୋ ନହି? ");
INSERT INTO sanori_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","କିନ୍ତୁ ଫିରୂଶିନସ୍ତତ୍ ଶ୍ରୁତ୍ୱା ଗଦିତୱନ୍ତଃ, ବାଲ୍ସିବୂବ୍ନାମ୍ନୋ ଭୂତରାଜସ୍ୟ ସାହାଯ୍ୟଂ ୱିନା ନାଯଂ ଭୂତାନ୍ ତ୍ୟାଜଯତି| ");
INSERT INTO sanori_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ତଦାନୀଂ ଯୀଶୁସ୍ତେଷାମ୍ ଇତି ମାନସଂ ୱିଜ୍ଞାଯ ତାନ୍ ଅୱଦତ୍ କିଞ୍ଚନ ରାଜ୍ୟଂ ଯଦି ସ୍ୱୱିପକ୍ଷାଦ୍ ଭିଦ୍ୟତେ, ତର୍ହି ତତ୍ ଉଚ୍ଛିଦ୍ୟତେ; ଯଚ୍ଚ କିଞ୍ଚନ ନଗରଂ ୱା ଗୃହଂ ସ୍ୱୱିପକ୍ଷାଦ୍ ୱିଭିଦ୍ୟତେ, ତତ୍ ସ୍ଥାତୁଂ ନ ଶକ୍ନୋତି| ");
INSERT INTO sanori_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","ତଦ୍ୱତ୍ ଶଯତାନୋ ଯଦି ଶଯତାନଂ ବହିଃ କୃତ୍ୱା ସ୍ୱୱିପକ୍ଷାତ୍ ପୃଥକ୍ ପୃଥକ୍ ଭୱତି, ତର୍ହି ତସ୍ୟ ରାଜ୍ୟଂ କେନ ପ୍ରକାରେଣ ସ୍ଥାସ୍ୟତି? ");
INSERT INTO sanori_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ଅହଞ୍ଚ ଯଦି ବାଲ୍ସିବୂବା ଭୂତାନ୍ ତ୍ୟାଜଯାମି, ତର୍ହି ଯୁଷ୍ମାକଂ ସନ୍ତାନାଃ କେନ ଭୂତାନ୍ ତ୍ୟାଜଯନ୍ତି? ତସ୍ମାଦ୍ ଯୁଷ୍ମାକମ୍ ଏତଦ୍ୱିଚାରଯିତାରସ୍ତ ଏୱ ଭୱିଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","କିନ୍ତୱହଂ ଯଦୀଶ୍ୱରାତ୍ମନା ଭୂତାନ୍ ତ୍ୟାଜଯାମି, ତର୍ହୀଶ୍ୱରସ୍ୟ ରାଜ୍ୟଂ ଯୁଷ୍ମାକଂ ସନ୍ନିଧିମାଗତୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","ଅନ୍ୟଞ୍ଚ କୋପି ବଲୱନ୍ତ ଜନଂ ପ୍ରଥମତୋ ନ ବଦ୍ୱ୍ୱା କେନ ପ୍ରକାରେଣ ତସ୍ୟ ଗୃହଂ ପ୍ରୱିଶ୍ୟ ତଦ୍ଦ୍ରୱ୍ୟାଦି ଲୋଠଯିତୁଂ ଶକ୍ନୋତି? କିନ୍ତୁ ତତ୍ କୃତ୍ୱା ତଦୀଯଗୃସ୍ୟ ଦ୍ରୱ୍ୟାଦି ଲୋଠଯିତୁଂ ଶକ୍ନୋତି| ");
INSERT INTO sanori_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","ଯଃ କଶ୍ଚିତ୍ ମମ ସ୍ୱପକ୍ଷୀଯୋ ନହି ସ ୱିପକ୍ଷୀଯ ଆସ୍ତେ, ଯଶ୍ଚ ମଯା ସାକଂ ନ ସଂଗୃହ୍ଲାତି, ସ ୱିକିରତି| ");
INSERT INTO sanori_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ଅତଏୱ ଯୁଷ୍ମାନହଂ ୱଦାମି, ମନୁଜାନାଂ ସର୍ୱ୍ୱପ୍ରକାରପାପାନାଂ ନିନ୍ଦାଯାଶ୍ଚ ମର୍ଷଣଂ ଭୱିତୁଂ ଶକ୍ନୋତି, କିନ୍ତୁ ପୱିତ୍ରସ୍ୟାତ୍ମନୋ ୱିରୁଦ୍ଧନିନ୍ଦାଯା ମର୍ଷଣଂ ଭୱିତୁଂ ନ ଶକ୍ନୋତି| ");
INSERT INTO sanori_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","ଯୋ ମନୁଜସୁତସ୍ୟ ୱିରୁଦ୍ଧାଂ କଥାଂ କଥଯତି, ତସ୍ୟାପରାଧସ୍ୟ କ୍ଷମା ଭୱିତୁଂ ଶକ୍ନୋତି, କିନ୍ତୁ ଯଃ କଶ୍ଚିତ୍ ପୱିତ୍ରସ୍ୟାତ୍ମନୋ ୱିରୁଦ୍ଧାଂ କଥାଂ କଥଯତି ନେହଲୋକେ ନ ପ୍ରେତ୍ୟ ତସ୍ୟାପରାଧସ୍ୟ କ୍ଷମା ଭୱିତୁଂ ଶକ୍ନୋତି| ");
INSERT INTO sanori_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","ପାଦପଂ ଯଦି ଭଦ୍ରଂ ୱଦଥ, ତର୍ହି ତସ୍ୟ ଫଲମପି ସାଧୁ ୱକ୍ତୱ୍ୟଂ, ଯଦି ଚ ପାଦପଂ ଅସାଧୁଂ ୱଦଥ, ତର୍ହି ତସ୍ୟ ଫଲମପ୍ୟସାଧୁ ୱକ୍ତୱ୍ୟଂ; ଯତଃ ସ୍ୱୀଯସ୍ୱୀଯଫଲେନ ପାଦପଃ ପରିଚୀଯତେ| ");
INSERT INTO sanori_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","ରେ ଭୁଜଗୱଂଶା ଯୂଯମସାଧୱଃ ସନ୍ତଃ କଥଂ ସାଧୁ ୱାକ୍ୟଂ ୱକ୍ତୁଂ ଶକ୍ଷ୍ୟଥ? ଯସ୍ମାଦ୍ ଅନ୍ତଃକରଣସ୍ୟ ପୂର୍ଣଭାୱାନୁସାରାଦ୍ ୱଦନାଦ୍ ୱଚୋ ନିର୍ଗଚ୍ଛତି| ");
INSERT INTO sanori_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","ତେନ ସାଧୁର୍ମାନୱୋଽନ୍ତଃକରଣରୂପାତ୍ ସାଧୁଭାଣ୍ଡାଗାରାତ୍ ସାଧୁ ଦ୍ରୱ୍ୟଂ ନିର୍ଗମଯତି, ଅସାଧୁର୍ମାନୁଷସ୍ତ୍ୱସାଧୁଭାଣ୍ଡାଗାରାଦ୍ ଅସାଧୁୱସ୍ତୂନି ନିର୍ଗମଯତି| ");
INSERT INTO sanori_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","କିନ୍ତ୍ୱହଂ ଯୁଷ୍ମାନ୍ ୱଦାମି, ମନୁଜା ଯାୱନ୍ତ୍ୟାଲସ୍ୟୱଚାଂସି ୱଦନ୍ତି, ୱିଚାରଦିନେ ତଦୁତ୍ତରମୱଶ୍ୟଂ ଦାତୱ୍ୟଂ, ");
INSERT INTO sanori_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","ଯତସ୍ତ୍ୱଂ ସ୍ୱୀଯୱଚୋଭି ର୍ନିରପରାଧଃ ସ୍ୱୀଯୱଚୋଭିଶ୍ଚ ସାପରାଧୋ ଗଣିଷ୍ୟସେ| ");
INSERT INTO sanori_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","ତଦାନୀଂ କତିପଯା ଉପାଧ୍ୟାଯାଃ ଫିରୂଶିନଶ୍ଚ ଜଗଦୁଃ, ହେ ଗୁରୋ ୱଯଂ ଭୱତ୍ତଃ କିଞ୍ଚନ ଲକ୍ଷ୍ମ ଦିଦୃକ୍ଷାମଃ| ");
INSERT INTO sanori_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ତଦା ସ ପ୍ରତ୍ୟୁକ୍ତୱାନ୍, ଦୁଷ୍ଟୋ ୱ୍ୟଭିଚାରୀ ଚ ୱଂଶୋ ଲକ୍ଷ୍ମ ମୃଗଯତେ, କିନ୍ତୁ ଭୱିଷ୍ୟଦ୍ୱାଦିନୋ ଯୂନସୋ ଲକ୍ଷ୍ମ ୱିହାଯାନ୍ୟତ୍ କିମପି ଲକ୍ଷ୍ମ ତେ ନ ପ୍ରଦର୍ଶଯିଷ୍ୟନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ଯତୋ ଯୂନମ୍ ଯଥା ତ୍ର୍ୟହୋରାତ୍ରଂ ବୃହନ୍ମୀନସ୍ୟ କୁକ୍ଷାୱାସୀତ୍, ତଥା ମନୁଜପୁତ୍ରୋପି ତ୍ର୍ୟହୋରାତ୍ରଂ ମେଦିନ୍ୟା ମଧ୍ୟେ ସ୍ଥାସ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","ଅପରଂ ନୀନିୱୀଯା ମାନୱା ୱିଚାରଦିନ ଏତଦ୍ୱଂଶୀଯାନାଂ ପ୍ରତିକୂଲମ୍ ଉତ୍ଥାଯ ତାନ୍ ଦୋଷିଣଃ କରିଷ୍ୟନ୍ତି, ଯସ୍ମାତ୍ତେ ଯୂନସ ଉପଦେଶାତ୍ ମନାଂସି ପରାୱର୍ତ୍ତଯାଞ୍ଚକ୍ରିରେ, କିନ୍ତ୍ୱତ୍ର ଯୂନସୋପି ଗୁରୁତର ଏକ ଆସ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","ପୁନଶ୍ଚ ଦକ୍ଷିଣଦେଶୀଯା ରାଜ୍ଞୀ ୱିଚାରଦିନ ଏତଦ୍ୱଂଶୀଯାନାଂ ପ୍ରତିକୂଲମୁତ୍ଥାଯ ତାନ୍ ଦୋଷିଣଃ କରିଷ୍ୟତି ଯତଃ ସା ରାଜ୍ଞୀ ସୁଲେମନୋ ୱିଦ୍ୟାଯାଃ କଥାଂ ଶ୍ରୋତୁଂ ମେଦିନ୍ୟାଃ ସୀମ୍ନ ଆଗଚ୍ଛତ୍, କିନ୍ତୁ ସୁଲେମନୋପି ଗୁରୁତର ଏକୋ ଜନୋଽତ୍ର ଆସ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","ଅପରଂ ମନୁଜାଦ୍ ବହିର୍ଗତୋ ଽପୱିତ୍ରଭୂତଃ ଶୁଷ୍କସ୍ଥାନେନ ଗତ୍ୱା ୱିଶ୍ରାମଂ ଗୱେଷଯତି, କିନ୍ତୁ ତଦଲଭମାନଃ ସ ୱକ୍ତି, ଯସ୍ମା; ନିକେତନାଦ୍ ଆଗମଂ, ତଦେୱ ୱେଶ୍ମ ପକାୱୃତ୍ୟ ଯାମି| ");
INSERT INTO sanori_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ପଶ୍ଚାତ୍ ସ ତତ୍ ସ୍ଥାନମ୍ ଉପସ୍ଥାଯ ତତ୍ ଶୂନ୍ୟଂ ମାର୍ଜ୍ଜିତଂ ଶୋଭିତଞ୍ଚ ୱିଲୋକ୍ୟ ୱ୍ରଜନ୍ ସ୍ୱତୋପି ଦୁଷ୍ଟତରାନ୍ ଅନ୍ୟସପ୍ତଭୂତାନ୍ ସଙ୍ଗିନଃ କରୋତି| ");
INSERT INTO sanori_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ତତସ୍ତେ ତତ୍ ସ୍ଥାନଂ ପ୍ରୱିଶ୍ୟ ନିୱସନ୍ତି, ତେନ ତସ୍ୟ ମନୁଜସ୍ୟ ଶେଷଦଶା ପୂର୍ୱ୍ୱଦଶାତୋତୀୱାଶୁଭା ଭୱତି, ଏତେଷାଂ ଦୁଷ୍ଟୱଂଶ୍ୟାନାମପି ତଥୈୱ ଘଟିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","ମାନୱେଭ୍ୟ ଏତାସାଂ କଥନାଂ କଥନକାଲେ ତସ୍ୟ ମାତା ସହଜାଶ୍ଚ ତେନ ସାକଂ କାଞ୍ଚିତ୍ କଥାଂ କଥଯିତୁଂ ୱାଞ୍ଛନ୍ତୋ ବହିରେୱ ସ୍ଥିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ତତଃ କଶ୍ଚିତ୍ ତସ୍ମୈ କଥିତୱାନ୍, ପଶ୍ୟ ତୱ ଜନନୀ ସହଜାଶ୍ଚ ତ୍ୱଯା ସାକଂ କାଞ୍ଚନ କଥାଂ କଥଯିତୁଂ କାମଯମାନା ବହିସ୍ତିଷ୍ଠନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","କିନ୍ତୁ ସ ତଂ ପ୍ରତ୍ୟୱଦତ୍, ମମ କା ଜନନୀ? କେ ୱା ମମ ସହଜାଃ? ");
INSERT INTO sanori_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ପଶ୍ଚାତ୍ ଶିଷ୍ୟାନ୍ ପ୍ରତି କରଂ ପ୍ରସାର୍ୟ୍ୟ କଥିତୱାନ୍, ପଶ୍ୟ ମମ ଜନନୀ ମମ ସହଜାଶ୍ଚୈତେ; ");
INSERT INTO sanori_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ଯଃ କଶ୍ଚିତ୍ ମମ ସ୍ୱର୍ଗସ୍ଥସ୍ୟ ପିତୁରିଷ୍ଟଂ କର୍ମ୍ମ କୁରୁତେ, ସଏୱ ମମ ଭ୍ରାତା ଭଗିନୀ ଜନନୀ ଚ| ");
INSERT INTO sanori_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","ଅପରଞ୍ଚ ତସ୍ମିନ୍ ଦିନେ ଯୀଶୁଃ ସଦ୍ମନୋ ଗତ୍ୱା ସରିତ୍ପତେ ରୋଧସି ସମୁପୱିୱେଶ| ");
INSERT INTO sanori_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ତତ୍ର ତତ୍ସନ୍ନିଧୌ ବହୁଜନାନାଂ ନିୱହୋପସ୍ଥିତେଃ ସ ତରଣିମାରୁହ୍ୟ ସମୁପାୱିଶତ୍, ତେନ ମାନୱା ରୋଧସି ସ୍ଥିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ତଦାନୀଂ ସ ଦୃଷ୍ଟାନ୍ତୈସ୍ତାନ୍ ଇତ୍ଥଂ ବହୁଶ ଉପଦିଷ୍ଟୱାନ୍| ପଶ୍ୟତ, କଶ୍ଚିତ୍ କୃଷୀୱଲୋ ବୀଜାନି ୱପ୍ତୁଂ ବହିର୍ଜଗାମ, ");
INSERT INTO sanori_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ତସ୍ୟ ୱପନକାଲେ କତିପଯବୀଜେଷୁ ମାର୍ଗପାର୍ଶ୍ୱେ ପତିତେଷୁ ୱିହଗାସ୍ତାନି ଭକ୍ଷିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","ଅପରଂ କତିପଯବୀଜେଷୁ ସ୍ତୋକମୃଦ୍ୟୁକ୍ତପାଷାଣେ ପତିତେଷୁ ମୃଦଲ୍ପତ୍ୱାତ୍ ତତ୍କ୍ଷଣାତ୍ ତାନ୍ୟଙ୍କୁରିତାନି, ");
INSERT INTO sanori_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","କିନ୍ତୁ ରୱାୱୁଦିତେ ଦଗ୍ଧାନି ତେଷାଂ ମୂଲାପ୍ରୱିଷ୍ଟତ୍ୱାତ୍ ଶୁଷ୍କତାଂ ଗତାନି ଚ| ");
INSERT INTO sanori_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","ଅପରଂ କତିପଯବୀଜେଷୁ କଣ୍ଟକାନାଂ ମଧ୍ୟେ ପତିତେଷୁ କଣ୍ଟକାନ୍ୟେଧିତ୍ୱା ତାନି ଜଗ୍ରସୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","ଅପରଞ୍ଚ କତିପଯବୀଜାନି ଉର୍ୱ୍ୱରାଯାଂ ପତିତାନି; ତେଷାଂ ମଧ୍ୟେ କାନିଚିତ୍ ଶତଗୁଣାନି କାନିଚିତ୍ ଷଷ୍ଟିଗୁଣାନି କାନିଚିତ୍ ତ୍ରିଂଶଗୁଂଣାନି ଫଲାନି ଫଲିତୱନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ଶ୍ରୋତୁଂ ଯସ୍ୟ ଶ୍ରୁତୀ ଆସାତେ ସ ଶୃଣୁଯାତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","ଅନନ୍ତରଂ ଶିଷ୍ୟୈରାଗତ୍ୟ ସୋଽପୃଚ୍ଛ୍ୟତ, ଭୱତା ତେଭ୍ୟଃ କୁତୋ ଦୃଷ୍ଟାନ୍ତକଥା କଥ୍ୟତେ? ");
INSERT INTO sanori_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ତତଃ ସ ପ୍ରତ୍ୟୱଦତ୍, ସ୍ୱର୍ଗରାଜ୍ୟସ୍ୟ ନିଗୂଢାଂ କଥାଂ ୱେଦିତୁଂ ଯୁଷ୍ମଭ୍ୟଂ ସାମର୍ଥ୍ୟମଦାଯି, କିନ୍ତୁ ତେଭ୍ୟୋ ନାଦାଯି| ");
INSERT INTO sanori_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","ଯସ୍ମାଦ୍ ଯସ୍ୟାନ୍ତିକେ ୱର୍ଦ୍ଧତେ, ତସ୍ମାଯେୱ ଦାଯିଷ୍ୟତେ, ତସ୍ମାତ୍ ତସ୍ୟ ବାହୁଲ୍ୟଂ ଭୱିଷ୍ୟତି, କିନ୍ତୁ ଯସ୍ୟାନ୍ତିକେ ନ ୱର୍ଦ୍ଧତେ, ତସ୍ୟ ଯତ୍ କିଞ୍ଚନାସ୍ତେ, ତଦପି ତସ୍ମାଦ୍ ଆଦାଯିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","ତେ ପଶ୍ୟନ୍ତୋପି ନ ପଶ୍ୟନ୍ତି, ଶୃଣ୍ୱନ୍ତୋପି ନ ଶୃଣ୍ୱନ୍ତି, ବୁଧ୍ୟମାନା ଅପି ନ ବୁଧ୍ୟନ୍ତେ ଚ, ତସ୍ମାତ୍ ତେଭ୍ୟୋ ଦୃଷ୍ଟାନ୍ତକଥା କଥ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","ଯଥା କର୍ଣୈଃ ଶ୍ରୋଷ୍ୟଥ ଯୂଯଂ ୱୈ କିନ୍ତୁ ଯୂଯଂ ନ ଭୋତ୍ସ୍ୟଥ| ନେତ୍ରୈର୍ଦ୍ରକ୍ଷ୍ୟଥ ଯୂଯଞ୍ଚ ପରିଜ୍ଞାତୁଂ ନ ଶକ୍ଷ୍ୟଥ| ତେ ମାନୁଷା ଯଥା ନୈୱ ପରିପଶ୍ୟନ୍ତି ଲୋଚନୈଃ| କର୍ଣୈ ର୍ୟଥା ନ ଶୃଣ୍ୱନ୍ତି ନ ବୁଧ୍ୟନ୍ତେ ଚ ମାନସୈଃ| ୱ୍ୟାୱର୍ତ୍ତିତେଷୁ ଚିତ୍ତେଷୁ କାଲେ କୁତ୍ରାପି ତୈର୍ଜନୈଃ| ମତ୍ତସ୍ତେ ମନୁଜାଃ ସ୍ୱସ୍ଥା ଯଥା ନୈୱ ଭୱନ୍ତି ଚ| ତଥା ତେଷାଂ ମନୁଷ୍ୟାଣାଂ କ୍ରିଯନ୍ତେ ସ୍ଥୂଲବୁଦ୍ଧଯଃ| ବଧିରୀଭୂତକର୍ଣାଶ୍ଚ ଜାତାଶ୍ଚ ମୁଦ୍ରିତା ଦୃଶଃ| ");
INSERT INTO sanori_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ଯଦେତାନି ୱଚନାନି ଯିଶଯିଯଭୱିଷ୍ୟଦ୍ୱାଦିନା ପ୍ରୋକ୍ତାନି ତେଷୁ ତାନି ଫଲନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","କିନ୍ତୁ ଯୁଷ୍ମାକଂ ନଯନାନି ଧନ୍ୟାନି, ଯସ୍ମାତ୍ ତାନି ୱୀକ୍ଷନ୍ତେ; ଧନ୍ୟାଶ୍ଚ ଯୁଷ୍ମାକଂ ଶବ୍ଦଗ୍ରହାଃ, ଯସ୍ମାତ୍ ତୈରାକର୍ଣ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","ମଯା ଯୂଯଂ ତଥ୍ୟଂ ୱଚାମି ଯୁଷ୍ମାଭି ର୍ୟଦ୍ୟଦ୍ ୱୀକ୍ଷ୍ୟତେ, ତଦ୍ ବହୱୋ ଭୱିଷ୍ୟଦ୍ୱାଦିନୋ ଧାର୍ମ୍ମିକାଶ୍ଚ ମାନୱା ଦିଦୃକ୍ଷନ୍ତୋପି ଦ୍ରଷ୍ଟୁଂ ନାଲଭନ୍ତ, ପୁନଶ୍ଚ ଯୂଯଂ ଯଦ୍ୟତ୍ ଶୃଣୁଥ, ତତ୍ ତେ ଶୁଶ୍ରୂଷମାଣା ଅପି ଶ୍ରୋତୁଂ ନାଲଭନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","କୃଷୀୱଲୀଯଦୃଷ୍ଟାନ୍ତସ୍ୟାର୍ଥଂ ଶୃଣୁତ| ");
INSERT INTO sanori_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","ମାର୍ଗପାର୍ଶ୍ୱେ ବୀଜାନ୍ୟୁପ୍ତାନି ତସ୍ୟାର୍ଥ ଏଷଃ, ଯଦା କଶ୍ଚିତ୍ ରାଜ୍ୟସ୍ୟ କଥାଂ ନିଶମ୍ୟ ନ ବୁଧ୍ୟତେ, ତଦା ପାପାତ୍ମାଗତ୍ୟ ତଦୀଯମନସ ଉପ୍ତାଂ କଥାଂ ହରନ୍ ନଯତି| ");
INSERT INTO sanori_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","ଅପରଂ ପାଷାଣସ୍ଥଲେ ବୀଜାନ୍ୟୁପ୍ତାନି ତସ୍ୟାର୍ଥ ଏଷଃ; କଶ୍ଚିତ୍ କଥାଂ ଶ୍ରୁତ୍ୱୈୱ ହର୍ଷଚିତ୍ତେନ ଗୃହ୍ଲାତି, ");
INSERT INTO sanori_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","କିନ୍ତୁ ତସ୍ୟ ମନସି ମୂଲାପ୍ରୱିଷ୍ଟତ୍ୱାତ୍ ସ କିଞ୍ଚିତ୍କାଲମାତ୍ରଂ ସ୍ଥିରସ୍ତିଷ୍ଠତି; ପଶ୍ଚାତ ତତ୍କଥାକାରଣାତ୍ କୋପି କ୍ଲେସ୍ତାଡନା ୱା ଚେତ୍ ଜାଯତେ, ତର୍ହି ସ ତତ୍କ୍ଷଣାଦ୍ ୱିଘ୍ନମେତି| ");
INSERT INTO sanori_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","ଅପରଂ କଣ୍ଟକାନାଂ ମଧ୍ୟେ ବୀଜାନ୍ୟୁପ୍ତାନି ତଦର୍ଥ ଏଷଃ; କେନଚିତ୍ କଥାଯାଂ ଶ୍ରୁତାଯାଂ ସାଂସାରିକଚିନ୍ତାଭି ର୍ଭ୍ରାନ୍ତିଭିଶ୍ଚ ସା ଗ୍ରସ୍ୟତେ, ତେନ ସା ମା ୱିଫଲା ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ଅପରମ୍ ଉର୍ୱ୍ୱରାଯାଂ ବୀଜାନ୍ୟୁପ୍ତାନି ତଦର୍ଥ ଏଷଃ; ଯେ ତାଂ କଥାଂ ଶ୍ରୁତ୍ୱା ୱୁଧ୍ୟନ୍ତେ, ତେ ଫଲିତାଃ ସନ୍ତଃ କେଚିତ୍ ଶତଗୁଣାନି କେଚିତ ଷଷ୍ଟିଗୁଣାନି କେଚିଚ୍ଚ ତ୍ରିଂଶଦ୍ଗୁଣାନି ଫଲାନି ଜନଯନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ଅନନ୍ତରଂ ସୋପରାମେକାଂ ଦୃଷ୍ଟାନ୍ତକଥାମୁପସ୍ଥାପ୍ୟ ତେଭ୍ୟଃ କଥଯାମାସ; ସ୍ୱର୍ଗୀଯରାଜ୍ୟଂ ତାଦୃଶେନ କେନଚିଦ୍ ଗୃହସ୍ଥେନୋପମୀଯତେ, ଯେନ ସ୍ୱୀଯକ୍ଷେତ୍ରେ ପ୍ରଶସ୍ତବୀଜାନ୍ୟୌପ୍ୟନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","କିନ୍ତୁ କ୍ଷଣଦାଯାଂ ସକଲଲୋକେଷୁ ସୁପ୍ତେଷୁ ତସ୍ୟ ରିପୁରାଗତ୍ୟ ତେଷାଂ ଗୋଧୂମବୀଜାନାଂ ମଧ୍ୟେ ୱନ୍ୟଯୱମବୀଜାନ୍ୟୁପ୍ତ୍ୱା ୱୱ୍ରାଜ| ");
INSERT INTO sanori_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ତତୋ ଯଦା ବୀଜେଭ୍ୟୋଽଙ୍କରା ଜାଯମାନାଃ କଣିଶାନି ଘୃତୱନ୍ତଃ; ତଦା ୱନ୍ୟଯୱସାନ୍ୟପି ଦୃଶ୍ୟମାନାନ୍ୟଭୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ତତୋ ଗୃହସ୍ଥସ୍ୟ ଦାସେଯା ଆଗମ୍ୟ ତସ୍ମୈ କଥଯାଞ୍ଚକ୍ରୁଃ, ହେ ମହେଚ୍ଛ, ଭୱତା କିଂ କ୍ଷେତ୍ରେ ଭଦ୍ରବୀଜାନି ନୌପ୍ୟନ୍ତ? ତଥାତ୍ୱେ ୱନ୍ୟଯୱସାନି କୃତ ଆଯନ୍? ");
INSERT INTO sanori_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","ତଦାନୀଂ ତେନ ତେ ପ୍ରତିଗଦିତାଃ, କେନଚିତ୍ ରିପୁଣା କର୍ମ୍ମଦମକାରି| ଦାସେଯାଃ କଥଯାମାସୁଃ, ୱଯଂ ଗତ୍ୱା ତାନ୍ୟୁତ୍ପାଯ୍ୟ କ୍ଷିପାମୋ ଭୱତଃ କୀଦୃଶୀଚ୍ଛା ଜାଯତେ? ");
INSERT INTO sanori_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","ତେନାୱାଦି, ନହି, ଶଙ୍କେଽହଂ ୱନ୍ୟଯୱସୋତ୍ପାଟନକାଲେ ଯୁଷ୍ମାଭିସ୍ତୈଃ ସାକଂ ଗୋଧୂମା ଅପ୍ୟୁତ୍ପାଟିଷ୍ୟନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ଅତଃ ଶ୍ସ୍ୟକର୍ତ୍ତନକାଲଂ ଯାୱଦ୍ ଉଭଯାନ୍ୟପି ସହ ୱର୍ଦ୍ଧନ୍ତାଂ, ପଶ୍ଚାତ୍ କର୍ତ୍ତନକାଲେ କର୍ତ୍ତକାନ୍ ୱକ୍ଷ୍ୟାମି, ଯୂଯମାଦୌ ୱନ୍ୟଯୱସାନି ସଂଗୃହ୍ୟ ଦାହଯିତୁଂ ୱୀଟିକା ବଦ୍ୱ୍ୱା ସ୍ଥାପଯତ; କିନ୍ତୁ ସର୍ୱ୍ୱେ ଗୋଧୂମା ଯୁଷ୍ମାଭି ର୍ଭାଣ୍ଡାଗାରଂ ନୀତ୍ୱା ସ୍ଥାପ୍ୟନ୍ତାମ୍| ");
INSERT INTO sanori_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ଅନନ୍ତରଂ ସୋପରାମେକାଂ ଦୃଷ୍ଟାନ୍ତକଥାମୁତ୍ଥାପ୍ୟ ତେଭ୍ୟଃ କଥିତୱାନ୍ କଶ୍ଚିନ୍ମନୁଜଃ ସର୍ଷପବୀଜମେକଂ ନୀତ୍ୱା ସ୍ୱକ୍ଷେତ୍ର ଉୱାପ| ");
INSERT INTO sanori_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","ସର୍ଷପବୀଜଂ ସର୍ୱ୍ୱସ୍ମାଦ୍ ବୀଜାତ୍ କ୍ଷୁଦ୍ରମପି ସଦଙ୍କୁରିତଂ ସର୍ୱ୍ୱସ୍ମାତ୍ ଶାକାତ୍ ବୃହଦ୍ ଭୱତି; ସ ତାଦୃଶସ୍ତରୁ ର୍ଭୱତି, ଯସ୍ୟ ଶାଖାସୁ ନଭସଃ ଖଗା ଆଗତ୍ୟ ନିୱସନ୍ତି; ସ୍ୱର୍ଗୀଯରାଜ୍ୟଂ ତାଦୃଶସ୍ୟ ସର୍ଷପୈକସ୍ୟ ସମମ୍| ");
INSERT INTO sanori_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ପୁନରପି ସ ଉପମାକଥାମେକାଂ ତେଭ୍ୟଃ କଥଯାଞ୍ଚକାର; କାଚନ ଯୋଷିତ୍ ଯତ୍ କିଣ୍ୱମାଦାଯ ଦ୍ରୋଣତ୍ରଯମିତଗୋଧୂମଚୂର୍ଣାନାଂ ମଧ୍ୟେ ସର୍ୱ୍ୱେଷାଂ ମିଶ୍ରୀଭୱନପର୍ୟ୍ୟନ୍ତଂ ସମାଚ୍ଛାଦ୍ୟ ନିଧତ୍ତୱତୀ, ତତ୍କିଣ୍ୱମିୱ ସ୍ୱର୍ଗରାଜ୍ୟଂ| ");
INSERT INTO sanori_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ଇତ୍ଥଂ ଯୀଶୁ ର୍ମନୁଜନିୱହାନାଂ ସନ୍ନିଧାୱୁପମାକଥାଭିରେତାନ୍ୟାଖ୍ୟାନାନି କଥିତୱାନ୍ ଉପମାଂ ୱିନା ତେଭ୍ୟଃ କିମପି କଥାଂ ନାକଥଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ଏତେନ ଦୃଷ୍ଟାନ୍ତୀଯେନ ୱାକ୍ୟେନ ୱ୍ୟାଦାଯ ୱଦନଂ ନିଜଂ| ଅହଂ ପ୍ରକାଶଯିଷ୍ୟାମି ଗୁପ୍ତୱାକ୍ୟଂ ପୁରାଭୱଂ| ଯଦେତଦ୍ୱଚନଂ ଭୱିଷ୍ୟଦ୍ୱାଦିନା ପ୍ରୋକ୍ତମାସୀତ୍, ତତ୍ ସିଦ୍ଧମଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","ସର୍ୱ୍ୱାନ୍ ମନୁଜାନ୍ ୱିସୃଜ୍ୟ ଯୀଶୌ ଗୃହଂ ପ୍ରୱିଷ୍ଟେ ତଚ୍ଛିଷ୍ୟା ଆଗତ୍ୟ ଯୀଶୱେ କଥିତୱନ୍ତଃ, କ୍ଷେତ୍ରସ୍ୟ ୱନ୍ୟଯୱସୀଯଦୃଷ୍ଟାନ୍ତକଥାମ୍ ଭୱାନ ଅସ୍ମାନ୍ ସ୍ପଷ୍ଟୀକୃତ୍ୟ ୱଦତୁ| ");
INSERT INTO sanori_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ତତଃ ସ ପ୍ରତ୍ୟୁୱାଚ, ଯେନ ଭଦ୍ରବୀଜାନ୍ୟୁପ୍ୟନ୍ତେ ସ ମନୁଜପୁତ୍ରଃ, ");
INSERT INTO sanori_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","କ୍ଷେତ୍ରଂ ଜଗତ୍, ଭଦ୍ରବୀଜାନୀ ରାଜ୍ୟସ୍ୟ ସନ୍ତାନାଃ, ");
INSERT INTO sanori_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ୱନ୍ୟଯୱସାନି ପାପାତ୍ମନଃ ସନ୍ତାନାଃ| ଯେନ ରିପୁଣା ତାନ୍ୟୁପ୍ତାନି ସ ଶଯତାନଃ, କର୍ତ୍ତନସମଯଶ୍ଚ ଜଗତଃ ଶେଷଃ, କର୍ତ୍ତକାଃ ସ୍ୱର୍ଗୀଯଦୂତାଃ| ");
INSERT INTO sanori_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","ଯଥା ୱନ୍ୟଯୱସାନି ସଂଗୃହ୍ୟ ଦାହ୍ୟନ୍ତେ, ତଥା ଜଗତଃ ଶେଷେ ଭୱିଷ୍ୟତି; ");
INSERT INTO sanori_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","ଅର୍ଥାତ୍ ମନୁଜସୁତଃ ସ୍ୱାଂଯଦୂତାନ୍ ପ୍ରେଷଯିଷ୍ୟତି, ତେନ ତେ ଚ ତସ୍ୟ ରାଜ୍ୟାତ୍ ସର୍ୱ୍ୱାନ୍ ୱିଘ୍ନକାରିଣୋଽଧାର୍ମ୍ମିକଲୋକାଂଶ୍ଚ ସଂଗୃହ୍ୟ ");
INSERT INTO sanori_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ଯତ୍ର ରୋଦନଂ ଦନ୍ତଘର୍ଷଣଞ୍ଚ ଭୱତି, ତତ୍ରାଗ୍ନିକୁଣ୍ଡେ ନିକ୍ଷେପ୍ସ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","ତଦାନୀଂ ଧାର୍ମ୍ମିକଲୋକାଃ ସ୍ୱେଷାଂ ପିତୂ ରାଜ୍ୟେ ଭାସ୍କରଇୱ ତେଜସ୍ୱିନୋ ଭୱିଷ୍ୟନ୍ତି| ଶ୍ରୋତୁଂ ଯସ୍ୟ ଶ୍ରୁତୀ ଆସାତେ, ମ ଶୃଣୁଯାତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","ଅପରଞ୍ଚ କ୍ଷେତ୍ରମଧ୍ୟେ ନିଧିଂ ପଶ୍ୟନ୍ ଯୋ ଗୋପଯତି, ତତଃ ପରଂ ସାନନ୍ଦୋ ଗତ୍ୱା ସ୍ୱୀଯସର୍ୱ୍ୱସ୍ୱଂ ୱିକ୍ରୀଯ ତ୍ତକ୍ଷେତ୍ରଂ କ୍ରୀଣାତି, ସ ଇୱ ସ୍ୱର୍ଗରାଜ୍ୟଂ| ");
INSERT INTO sanori_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","ଅନ୍ୟଞ୍ଚ ଯୋ ୱଣିକ୍ ଉତ୍ତମାଂ ମୁକ୍ତାଂ ଗୱେଷଯନ୍ ");
INSERT INTO sanori_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ମହାର୍ଘାଂ ମୁକ୍ତାଂ ୱିଲୋକ୍ୟ ନିଜସର୍ୱ୍ୱସ୍ୱଂ ୱିକ୍ରୀଯ ତାଂ କ୍ରୀଣାତି, ସ ଇୱ ସ୍ୱର୍ଗରାଜ୍ୟଂ| ");
INSERT INTO sanori_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","ପୁନଶ୍ଚ ସମୁଦ୍ରୋ ନିକ୍ଷିପ୍ତଃ ସର୍ୱ୍ୱପ୍ରକାରମୀନସଂଗ୍ରାହ୍ୟାନାଯଇୱ ସ୍ୱର୍ଗରାଜ୍ୟଂ| ");
INSERT INTO sanori_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ତସ୍ମିନ୍ ଆନାଯେ ପୂର୍ଣେ ଜନା ଯଥା ରୋଧସ୍ୟୁତ୍ତୋଲ୍ୟ ସମୁପୱିଶ୍ୟ ପ୍ରଶସ୍ତମୀନାନ୍ ସଂଗ୍ରହ୍ୟ ଭାଜନେଷୁ ନିଦଧତେ, କୁତ୍ସିତାନ୍ ନିକ୍ଷିପନ୍ତି; ");
INSERT INTO sanori_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","ତଥୈୱ ଜଗତଃ ଶେଷେ ଭୱିଷ୍ୟତି, ଫଲତଃ ସ୍ୱର୍ଗୀଯଦୂତା ଆଗତ୍ୟ ପୁଣ୍ୟୱଜ୍ଜନାନାଂ ମଧ୍ୟାତ୍ ପାପିନଃ ପୃଥକ୍ କୃତ୍ୱା ୱହ୍ନିକୁଣ୍ଡେ ନିକ୍ଷେପ୍ସ୍ୟନ୍ତି, ");
INSERT INTO sanori_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ତତ୍ର ରୋଦନଂ ଦନ୍ତୈ ର୍ଦନ୍ତଘର୍ଷଣଞ୍ଚ ଭୱିଷ୍ୟତଃ| ");
INSERT INTO sanori_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","ଯୀଶୁନା ତେ ପୃଷ୍ଟା ଯୁଷ୍ମାଭିଃ କିମେତାନ୍ୟାଖ୍ୟାନାନ୍ୟବୁଧ୍ୟନ୍ତ? ତଦା ତେ ପ୍ରତ୍ୟୱଦନ୍, ସତ୍ୟଂ ପ୍ରଭୋ| ");
INSERT INTO sanori_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ତଦାନୀଂ ସ କଥିତୱାନ୍, ନିଜଭାଣ୍ଡାଗାରାତ୍ ନୱୀନପୁରାତନାନି ୱସ୍ତୂନି ନିର୍ଗମଯତି ଯୋ ଗୃହସ୍ଥଃ ସ ଇୱ ସ୍ୱର୍ଗରାଜ୍ୟମଧି ଶିକ୍ଷିତାଃ ସ୍ୱର୍ୱ ଉପଦେଷ୍ଟାରଃ| ");
INSERT INTO sanori_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","ଅନନ୍ତରଂ ଯୀଶୁରେତାଃ ସର୍ୱ୍ୱା ଦୃଷ୍ଟାନ୍ତକଥାଃ ସମାପ୍ୟ ତସ୍ମାତ୍ ସ୍ଥାନାତ୍ ପ୍ରତସ୍ଥେ| ଅପରଂ ସ୍ୱଦେଶମାଗତ୍ୟ ଜନାନ୍ ଭଜନଭୱନ ଉପଦିଷ୍ଟୱାନ୍; ");
INSERT INTO sanori_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ତେ ୱିସ୍ମଯଂ ଗତ୍ୱା କଥିତୱନ୍ତ ଏତସ୍ୟୈତାଦୃଶଂ ଜ୍ଞାନମ୍ ଆଶ୍ଚର୍ୟ୍ୟଂ କର୍ମ୍ମ ଚ କସ୍ମାଦ୍ ଅଜାଯତ? ");
INSERT INTO sanori_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","କିମଯଂ ସୂତ୍ରଧାରସ୍ୟ ପୁତ୍ରୋ ନହି? ଏତସ୍ୟ ମାତୁ ର୍ନାମ ଚ କିଂ ମରିଯମ୍ ନହି? ଯାକୁବ୍-ଯୂଷଫ୍-ଶିମୋନ୍-ଯିହୂଦାଶ୍ଚ କିମେତସ୍ୟ ଭ୍ରାତରୋ ନହି? ");
INSERT INTO sanori_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ଏତସ୍ୟ ଭଗିନ୍ୟଶ୍ଚ କିମସ୍ମାକଂ ମଧ୍ୟେ ନ ସନ୍ତି? ତର୍ହି କସ୍ମାଦଯମେତାନି ଲବ୍ଧୱାନ୍? ଇତ୍ଥଂ ସ ତେଷାଂ ୱିଘ୍ନରୂପୋ ବଭୂୱ; ");
INSERT INTO sanori_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ତତୋ ଯୀଶୁନା ନିଗଦିତଂ ସ୍ୱଦେଶୀଯଜନାନାଂ ମଧ୍ୟଂ ୱିନା ଭୱିଷ୍ୟଦ୍ୱାଦୀ କୁତ୍ରାପ୍ୟନ୍ୟତ୍ର ନାସମ୍ମାନ୍ୟୋ ଭୱତୀ| ");
INSERT INTO sanori_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","ତେଷାମୱିଶ୍ୱାସହେତୋଃ ସ ତତ୍ର ସ୍ଥାନେ ବହ୍ୱାଶ୍ଚର୍ୟ୍ୟକର୍ମ୍ମାଣି ନ କୃତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","ତଦାନୀଂ ରାଜା ହେରୋଦ୍ ଯୀଶୋ ର୍ୟଶଃ ଶ୍ରୁତ୍ୱା ନିଜଦାସେଯାନ୍ ଜଗାଦ୍, ");
INSERT INTO sanori_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ଏଷ ମଜ୍ଜଯିତା ଯୋହନ୍, ପ୍ରମିତେଭଯସ୍ତସ୍ୟୋତ୍ଥାନାତ୍ ତେନେତ୍ଥମଦ୍ଭୁତଂ କର୍ମ୍ମ ପ୍ରକାଶ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","ପୁରା ହେରୋଦ୍ ନିଜଭ୍ରାତୁ: ଫିଲିପୋ ଜାଯାଯା ହେରୋଦୀଯାଯା ଅନୁରୋଧାଦ୍ ଯୋହନଂ ଧାରଯିତ୍ୱା ବଦ୍ଧା କାରାଯାଂ ସ୍ଥାପିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ଯତୋ ଯୋହନ୍ ଉକ୍ତୱାନ୍, ଏତ୍ସଯାଃ ସଂଗ୍ରହୋ ଭୱତୋ ନୋଚିତଃ| ");
INSERT INTO sanori_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ତସ୍ମାତ୍ ନୃପତିସ୍ତଂ ହନ୍ତୁମିଚ୍ଛନ୍ନପି ଲୋକେଭ୍ୟୋ ୱିଭଯାଞ୍ଚକାର; ଯତଃ ସର୍ୱ୍ୱେ ଯୋହନଂ ଭୱିଷ୍ୟଦ୍ୱାଦିନଂ ମେନିରେ| ");
INSERT INTO sanori_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","କିନ୍ତୁ ହେରୋଦୋ ଜନ୍ମାହୀଯମହ ଉପସ୍ଥିତେ ହେରୋଦୀଯାଯା ଦୁହିତା ତେଷାଂ ସମକ୍ଷଂ ନୃତିତ୍ୱା ହେରୋଦମପ୍ରୀଣ୍ୟତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ତସ୍ମାତ୍ ଭୂପତିଃ ଶପଥଂ କୁର୍ୱ୍ୱନ୍ ଇତି ପ୍ରତ୍ୟଜ୍ଞାସୀତ୍, ତ୍ୱଯା ଯଦ୍ ଯାଚ୍ୟତେ, ତଦେୱାହଂ ଦାସ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","ସା କୁମାରୀ ସ୍ୱୀଯମାତୁଃ ଶିକ୍ଷାଂ ଲବ୍ଧା ବଭାଷେ, ମଜ୍ଜଯିତୁର୍ୟୋହନ ଉତ୍ତମାଙ୍ଗଂ ଭାଜନେ ସମାନୀଯ ମହ୍ୟଂ ୱିଶ୍ରାଣଯ| ");
INSERT INTO sanori_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ତତୋ ରାଜା ଶୁଶୋଚ, କିନ୍ତୁ ଭୋଜନାଯୋପୱିଶତାଂ ସଙ୍ଗିନାଂ ସ୍ୱକୃତଶପଥସ୍ୟ ଚାନୁରୋଧାତ୍ ତତ୍ ପ୍ରଦାତୁମ ଆଦିଦେଶ| ");
INSERT INTO sanori_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ପଶ୍ଚାତ୍ କାରାଂ ପ୍ରତି ନରଂ ପ୍ରହିତ୍ୟ ଯୋହନ ଉତ୍ତମାଙ୍ଗଂ ଛିତ୍ତ୍ୱା ");
INSERT INTO sanori_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ତତ୍ ଭାଜନ ଆନାଯ୍ୟ ତସ୍ୟୈ କୁମାର୍ୟ୍ୟୈ ୱ୍ୟଶ୍ରାଣଯତ୍, ତତଃ ସା ସ୍ୱଜନନ୍ୟାଃ ସମୀପଂ ତନ୍ନିନାଯ| ");
INSERT INTO sanori_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ପଶ୍ଚାତ୍ ଯୋହନଃ ଶିଷ୍ୟା ଆଗତ୍ୟ କାଯଂ ନୀତ୍ୱା ଶ୍ମଶାନେ ସ୍ଥାପଯାମାସୁସ୍ତତୋ ଯୀଶୋଃ ସନ୍ନିଧିଂ ୱ୍ରଜିତ୍ୱା ତଦ୍ୱାର୍ତ୍ତାଂ ବଭାଷିରେ| ");
INSERT INTO sanori_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","ଅନନ୍ତରଂ ଯୀଶୁରିତି ନିଶଭ୍ୟ ନାୱା ନିର୍ଜନସ୍ଥାନମ୍ ଏକାକୀ ଗତୱାନ୍, ପଶ୍ଚାତ୍ ମାନୱାସ୍ତତ୍ ଶ୍ରୁତ୍ୱା ନାନାନଗରେଭ୍ୟ ଆଗତ୍ୟ ପଦୈସ୍ତତ୍ପଶ୍ଚାଦ୍ ଈଯୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ତଦାନୀଂ ଯୀଶୁ ର୍ବହିରାଗତ୍ୟ ମହାନ୍ତଂ ଜନନିୱହଂ ନିରୀକ୍ଷ୍ୟ ତେଷୁ କାରୁଣିକଃ ମନ୍ ତେଷାଂ ପୀଡିତଜନାନ୍ ନିରାମଯାନ୍ ଚକାର| ");
INSERT INTO sanori_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ତତଃ ପରଂ ସନ୍ଧ୍ୟାଯାଂ ଶିଷ୍ୟାସ୍ତଦନ୍ତିକମାଗତ୍ୟ କଥଯାଞ୍ଚକ୍ରୁଃ, ଇଦଂ ନିର୍ଜନସ୍ଥାନଂ ୱେଲାପ୍ୟୱସନ୍ନା; ତସ୍ମାତ୍ ମନୁଜାନ୍ ସ୍ୱସ୍ୱଗ୍ରାମଂ ଗନ୍ତୁଂ ସ୍ୱାର୍ଥଂ ଭକ୍ଷ୍ୟାଣି କ୍ରେତୁଞ୍ଚ ଭୱାନ୍ ତାନ୍ ୱିସୃଜତୁ| ");
INSERT INTO sanori_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","କିନ୍ତୁ ଯୀଶୁସ୍ତାନୱାଦୀତ୍, ତେଷାଂ ଗମନେ ପ୍ରଯୋଜନଂ ନାସ୍ତି, ଯୂଯମେୱ ତାନ୍ ଭୋଜଯତ| ");
INSERT INTO sanori_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ତଦା ତେ ପ୍ରତ୍ୟୱଦନ୍, ଅସ୍ମାକମତ୍ର ପୂପପଞ୍ଚକଂ ମୀନଦ୍ୱଯଞ୍ଚାସ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ତଦାନୀଂ ତେନୋକ୍ତଂ ତାନି ମଦନ୍ତିକମାନଯତ| ");
INSERT INTO sanori_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ଅନନ୍ତରଂ ସ ମନୁଜାନ୍ ଯୱସୋପର୍ୟ୍ୟୁପୱେଷ୍ଟୁମ୍ ଆଜ୍ଞାପଯାମାସ; ଅପର ତତ୍ ପୂପପଞ୍ଚକଂ ମୀନଦ୍ୱଯଞ୍ଚ ଗୃହ୍ଲନ୍ ସ୍ୱର୍ଗଂ ପ୍ରତି ନିରୀକ୍ଷ୍ୟେଶ୍ୱରୀଯଗୁଣାନ୍ ଅନୂଦ୍ୟ ଭଂକ୍ତ୍ୱା ଶିଷ୍ୟେଭ୍ୟୋ ଦତ୍ତୱାନ୍, ଶିଷ୍ୟାଶ୍ଚ ଲୋକେଭ୍ୟୋ ଦଦୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ତତଃ ସର୍ୱ୍ୱେ ଭୁକ୍ତ୍ୱା ପରିତୃପ୍ତୱନ୍ତଃ, ତତସ୍ତଦୱଶିଷ୍ଟଭକ୍ଷ୍ୟୈଃ ପୂର୍ଣାନ୍ ଦ୍ୱାଦଶଡଲକାନ୍ ଗୃହୀତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","ତେ ଭୋକ୍ତାରଃ ସ୍ତ୍ରୀର୍ବାଲକାଂଶ୍ଚ ୱିହାଯ ପ୍ରାଯେଣ ପଞ୍ଚ ସହସ୍ରାଣି ପୁମାଂସ ଆସନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","ତଦନନ୍ତରଂ ଯୀଶୁ ର୍ଲୋକାନାଂ ୱିସର୍ଜନକାଲେ ଶିଷ୍ୟାନ୍ ତରଣିମାରୋଢୁଂ ସ୍ୱାଗ୍ରେ ପାରଂ ଯାତୁଞ୍ଚ ଗାଢମାଦିଷ୍ଟୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ତତୋ ଲୋକେଷୁ ୱିସୃଷ୍ଟେଷୁ ସ ୱିୱିକ୍ତେ ପ୍ରାର୍ଥଯିତୁଂ ଗିରିମେକଂ ଗତ୍ୱା ସନ୍ଧ୍ୟାଂ ଯାୱତ୍ ତତ୍ରୈକାକୀ ସ୍ଥିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","କିନ୍ତୁ ତଦାନୀଂ ସମ୍ମୁଖୱାତତ୍ୱାତ୍ ସରିତ୍ପତେ ର୍ମଧ୍ୟେ ତରଙ୍ଗୈସ୍ତରଣିର୍ଦୋଲାଯମାନାଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","ତଦା ସ ଯାମିନ୍ୟାଶ୍ଚତୁର୍ଥପ୍ରହରେ ପଦ୍ଭ୍ୟାଂ ୱ୍ରଜନ୍ ତେଷାମନ୍ତିକଂ ଗତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","କିନ୍ତୁ ଶିଷ୍ୟାସ୍ତଂ ସାଗରୋପରି ୱ୍ରଜନ୍ତଂ ୱିଲୋକ୍ୟ ସମୁଦ୍ୱିଗ୍ନା ଜଗଦୁଃ, ଏଷ ଭୂତ ଇତି ଶଙ୍କମାନା ଉଚ୍ଚୈଃ ଶବ୍ଦାଯାଞ୍ଚକ୍ରିରେ ଚ| ");
INSERT INTO sanori_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ତଦୈୱ ଯୀଶୁସ୍ତାନୱଦତ୍, ସୁସ୍ଥିରା ଭୱତ, ମା ଭୈଷ୍ଟ, ଏଷୋଽହମ୍| ");
INSERT INTO sanori_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","ତତଃ ପିତର ଇତ୍ୟୁକ୍ତୱାନ୍, ହେ ପ୍ରଭୋ, ଯଦି ଭୱାନେୱ, ତର୍ହି ମାଂ ଭୱତ୍ସମୀପଂ ଯାତୁମାଜ୍ଞାପଯତୁ| ");
INSERT INTO sanori_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ତତଃ ତେନାଦିଷ୍ଟଃ ପିତରସ୍ତରଣିତୋଽୱରୁହ୍ୟ ଯୀଶେाରନ୍ତିକଂ ପ୍ରାପ୍ତୁଂ ତୋଯୋପରି ୱୱ୍ରାଜ| ");
INSERT INTO sanori_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","କିନ୍ତୁ ପ୍ରଚଣ୍ଡଂ ପୱନଂ ୱିଲୋକ୍ୟ ଭଯାତ୍ ତୋଯେ ମଂକ୍ତୁମ୍ ଆରେଭେ, ତସ୍ମାଦ୍ ଉଚ୍ଚୈଃ ଶବ୍ଦାଯମାନଃ କଥିତୱାନ୍, ହେ ପ୍ରଭୋ, ମାମୱତୁ| ");
INSERT INTO sanori_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ଯୀଶୁସ୍ତତ୍କ୍ଷଣାତ୍ କରଂ ପ୍ରସାର୍ୟ୍ୟ ତଂ ଧରନ୍ ଉକ୍ତୱାନ୍, ହ ସ୍ତୋକପ୍ରତ୍ୟଯିନ୍ ତ୍ୱଂ କୁତଃ ସମଶେଥାଃ? ");
INSERT INTO sanori_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","ଅନନ୍ତରଂ ତଯୋସ୍ତରଣିମାରୂଢଯୋଃ ପୱନୋ ନିୱୱୃତେ| ");
INSERT INTO sanori_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ତଦାନୀଂ ଯେ ତରଣ୍ୟାମାସନ୍, ତ ଆଗତ୍ୟ ତଂ ପ୍ରଣଭ୍ୟ କଥିତୱନ୍ତଃ, ଯଥାର୍ଥସ୍ତ୍ୱମେୱେଶ୍ୱରସୁତଃ| ");
INSERT INTO sanori_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ଅନନ୍ତରଂ ପାରଂ ପ୍ରାପ୍ୟ ତେ ଗିନେଷରନ୍ନାମକଂ ନଗରମୁପତସ୍ଥୁଃ, ");
INSERT INTO sanori_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ତଦା ତତ୍ରତ୍ୟା ଜନା ଯୀଶୁଂ ପରିଚୀଯ ତଦ୍ଦେଶ୍ସ୍ୟ ଚତୁର୍ଦିଶୋ ୱାର୍ତ୍ତାଂ ପ୍ରହିତ୍ୟ ଯତ୍ର ଯାୱନ୍ତଃ ପୀଡିତା ଆସନ୍, ତାୱତଏୱ ତଦନ୍ତିକମାନଯାମାସୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ଅପରଂ ତଦୀଯୱସନସ୍ୟ ଗ୍ରନ୍ଥିମାତ୍ରଂ ସ୍ପ୍ରଷ୍ଟୁଂ ୱିନୀଯ ଯାୱନ୍ତୋ ଜନାସ୍ତତ୍ ସ୍ପର୍ଶଂ ଚକ୍ରିରେ, ତେ ସର୍ୱ୍ୱଏୱ ନିରାମଯା ବଭୂୱୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","ଅପରଂ ଯିରୂଶାଲମ୍ନଗରୀଯାଃ କତିପଯା ଅଧ୍ୟାପକାଃ ଫିରୂଶିନଶ୍ଚ ଯୀଶୋଃ ସମୀପମାଗତ୍ୟ କଥଯାମାସୁଃ, ");
INSERT INTO sanori_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","ତୱ ଶିଷ୍ୟାଃ କିମର୍ଥମ୍ ଅପ୍ରକ୍ଷାଲିତକରୈ ର୍ଭକ୍ଷିତ୍ୱା ପରମ୍ପରାଗତଂ ପ୍ରାଚୀନାନାଂ ୱ୍ୟୱହାରଂ ଲଙ୍ୱନ୍ତେ? ");
INSERT INTO sanori_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ତତୋ ଯୀଶୁଃ ପ୍ରତ୍ୟୁୱାଚ, ଯୂଯଂ ପରମ୍ପରାଗତାଚାରେଣ କୁତ ଈଶ୍ୱରାଜ୍ଞାଂ ଲଙ୍ୱଧ୍ୱେ| ");
INSERT INTO sanori_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ଈଶ୍ୱର ଇତ୍ୟାଜ୍ଞାପଯତ୍, ତ୍ୱଂ ନିଜପିତରୌ ସଂମନ୍ୟେଥାଃ, ଯେନ ଚ ନିଜପିତରୌ ନିନ୍ଦ୍ୟେତେ, ସ ନିଶ୍ଚିତଂ ମ୍ରିଯେତ; ");
INSERT INTO sanori_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","କିନ୍ତୁ ଯୂଯଂ ୱଦଥ, ଯଃ ସ୍ୱଜନକଂ ସ୍ୱଜନନୀଂ ୱା ୱାକ୍ୟମିଦଂ ୱଦତି, ଯୁୱାଂ ମତ୍ତୋ ଯଲ୍ଲଭେଥେ, ତତ୍ ନ୍ୟୱିଦ୍ୟତ, ");
INSERT INTO sanori_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ସ ନିଜପିତରୌ ପୁନ ର୍ନ ସଂମଂସ୍ୟତେ| ଇତ୍ଥଂ ଯୂଯଂ ପରମ୍ପରାଗତେନ ସ୍ୱେଷାମାଚାରେଣେଶ୍ୱରୀଯାଜ୍ଞାଂ ଲୁମ୍ପଥ| ");
INSERT INTO sanori_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ରେ କପଟିନଃ ସର୍ୱ୍ୱେ ଯିଶଯିଯୋ ଯୁଷ୍ମାନଧି ଭୱିଷ୍ୟଦ୍ୱଚନାନ୍ୟେତାନି ସମ୍ୟଗ୍ ଉକ୍ତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","ୱଦନୈ ର୍ମନୁଜା ଏତେ ସମାଯାନ୍ତି ମଦନ୍ତିକଂ| ତଥାଧରୈ ର୍ମଦୀଯଞ୍ଚ ମାନଂ କୁର୍ୱ୍ୱନ୍ତି ତେ ନରାଃ| ");
INSERT INTO sanori_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","କିନ୍ତୁ ତେଷାଂ ମନୋ ମତ୍ତୋ ୱିଦୂରଏୱ ତିଷ୍ଠତି| ଶିକ୍ଷଯନ୍ତୋ ୱିଧୀନ୍ ନ୍ରାଜ୍ଞା ଭଜନ୍ତେ ମାଂ ମୁଧୈୱ ତେ| ");
INSERT INTO sanori_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ତତୋ ଯୀଶୁ ର୍ଲୋକାନ୍ ଆହୂଯ ପ୍ରୋକ୍ତୱାନ୍, ଯୂଯଂ ଶ୍ରୁତ୍ୱା ବୁଧ୍ୟଧ୍ବଂ| ");
INSERT INTO sanori_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ଯନ୍ମୁଖଂ ପ୍ରୱିଶତି, ତତ୍ ମନୁଜମ୍ ଅମେଧ୍ୟଂ ନ କରୋତି, କିନ୍ତୁ ଯଦାସ୍ୟାତ୍ ନିର୍ଗଚ୍ଛତି, ତଦେୱ ମାନୁଷମମେଧ୍ୟୀ କରୋତୀ| ");
INSERT INTO sanori_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","ତଦାନୀଂ ଶିଷ୍ୟା ଆଗତ୍ୟ ତସ୍ମୈ କଥଯାଞ୍ଚକ୍ରୁଃ, ଏତାଂ କଥାଂ ଶ୍ରୁତ୍ୱା ଫିରୂଶିନୋ ୱ୍ୟରଜ୍ୟନ୍ତ, ତତ୍ କିଂ ଭୱତା ଜ୍ଞାଯତେ? ");
INSERT INTO sanori_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ସ ପ୍ରତ୍ୟୱଦତ୍, ମମ ସ୍ୱର୍ଗସ୍ଥଃ ପିତା ଯଂ କଞ୍ଚିଦଙ୍କୁରଂ ନାରୋପଯତ୍, ସ ଉତ୍ପାୱ୍ଦ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","ତେ ତିଷ୍ଠନ୍ତୁ, ତେ ଅନ୍ଧମନୁଜାନାମ୍ ଅନ୍ଧମାର୍ଗଦର୍ଶକା ଏୱ; ଯଦ୍ୟନ୍ଧୋଽନ୍ଧଂ ପନ୍ଥାନଂ ଦର୍ଶଯତି, ତର୍ହ୍ୟୁଭୌ ଗର୍ତ୍ତେ ପତତଃ| ");
INSERT INTO sanori_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ତଦା ପିତରସ୍ତଂ ପ୍ରତ୍ୟୱଦତ୍, ଦୃଷ୍ଟାନ୍ତମିମମସ୍ମାନ୍ ବୋଧଯତୁ| ");
INSERT INTO sanori_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ଯୀଶୁନା ପ୍ରୋକ୍ତଂ, ଯୂଯମଦ୍ୟ ଯାୱତ୍ କିମବୋଧାଃ ସ୍ଥ? ");
INSERT INTO sanori_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","କଥାମିମାଂ କିଂ ନ ବୁଧ୍ୟଧ୍ବେ ? ଯଦାସ୍ୟଂ ପ୍ରେୱିଶତି, ତଦ୍ ଉଦରେ ପତନ୍ ବହିର୍ନିର୍ୟାତି, ");
INSERT INTO sanori_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","କିନ୍ତ୍ୱାସ୍ୟାଦ୍ ଯନ୍ନିର୍ୟାତି, ତଦ୍ ଅନ୍ତଃକରଣାତ୍ ନିର୍ୟାତତ୍ୱାତ୍ ମନୁଜମମେଧ୍ୟଂ କରୋତି| ");
INSERT INTO sanori_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","ଯତୋଽନ୍ତଃକରଣାତ୍ କୁଚିନ୍ତା ବଧଃ ପାରଦାରିକତା ୱେଶ୍ୟାଗମନଂ ଚୈର୍ୟ୍ୟଂ ମିଥ୍ୟାସାକ୍ଷ୍ୟମ୍ ଈଶ୍ୱରନିନ୍ଦା ଚୈତାନି ସର୍ୱ୍ୱାଣି ନିର୍ୟ୍ୟାନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ଏତାନି ମନୁଷ୍ୟମପୱିତ୍ରୀ କୁର୍ୱ୍ୱନ୍ତି କିନ୍ତ୍ୱପ୍ରକ୍ଷାଲିତକରେଣ ଭୋଜନଂ ମନୁଜମମେଧ୍ୟଂ ନ କରୋତି| ");
INSERT INTO sanori_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ଅନନ୍ତରଂ ଯୀଶୁସ୍ତସ୍ମାତ୍ ସ୍ଥାନାତ୍ ପ୍ରସ୍ଥାଯ ସୋରସୀଦୋନ୍ନଗରଯୋଃ ସୀମାମୁପତସ୍ୟୌ| ");
INSERT INTO sanori_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ତଦା ତତ୍ସୀମାତଃ କାଚିତ୍ କିନାନୀଯା ଯୋଷିଦ୍ ଆଗତ୍ୟ ତମୁଚ୍ଚୈରୁୱାଚ, ହେ ପ୍ରଭୋ ଦାଯୂଦଃ ସନ୍ତାନ, ମମୈକା ଦୁହିତାସ୍ତେ ସା ଭୂତଗ୍ରସ୍ତା ସତୀ ମହାକ୍ଲେଶଂ ପ୍ରାପ୍ନୋତି ମମ ଦଯସ୍ୱ| ");
INSERT INTO sanori_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","କିନ୍ତୁ ଯୀଶୁସ୍ତାଂ କିମପି ନୋକ୍ତୱାନ୍, ତତଃ ଶିଷ୍ୟା ଆଗତ୍ୟ ତଂ ନିୱେଦଯାମାସୁଃ, ଏଷା ଯୋଷିଦ୍ ଅସ୍ମାକଂ ପଶ୍ଚାଦ୍ ଉଚ୍ଚୈରାହୂଯାଗଚ୍ଛତି, ଏନାଂ ୱିସୃଜତୁ| ");
INSERT INTO sanori_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ତଦା ସ ପ୍ରତ୍ୟୱଦତ୍, ଇସ୍ରାଯେଲ୍ଗୋତ୍ରସ୍ୟ ହାରିତମେଷାନ୍ ୱିନା କସ୍ୟାପ୍ୟନ୍ୟସ୍ୟ ସମୀପଂ ନାହଂ ପ୍ରେଷିତୋସ୍ମି| ");
INSERT INTO sanori_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","ତତଃ ସା ନାରୀସମାଗତ୍ୟ ତଂ ପ୍ରଣମ୍ୟ ଜଗାଦ, ହେ ପ୍ରଭୋ ମାମୁପକୁରୁ| ");
INSERT INTO sanori_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ସ ଉକ୍ତୱାନ୍, ବାଲକାନାଂ ଭକ୍ଷ୍ୟମାଦାଯ ସାରମେଯେଭ୍ୟୋ ଦାନଂ ନୋଚିତଂ| ");
INSERT INTO sanori_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ତଦା ସା ବଭାଷେ, ହେ ପ୍ରଭୋ, ତତ୍ ସତ୍ୟଂ, ତଥାପି ପ୍ରଭୋ ର୍ଭଞ୍ଚାଦ୍ ଯଦୁଚ୍ଛିଷ୍ଟଂ ପତତି, ତତ୍ ସାରମେଯାଃ ଖାଦନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ତତୋ ଯୀଶୁଃ ପ୍ରତ୍ୟୱଦତ୍, ହେ ଯୋଷିତ୍, ତୱ ୱିଶ୍ୱାସୋ ମହାନ୍ ତସ୍ମାତ୍ ତୱ ମନୋଭିଲଷିତଂ ସିଦ୍ୟ୍ୟତୁ, ତେନ ତସ୍ୟାଃ କନ୍ୟା ତସ୍ମିନ୍ନେୱ ଦଣ୍ଡେ ନିରାମଯାଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ଅନନ୍ତରଂ ଯୀଶସ୍ତସ୍ମାତ୍ ସ୍ଥାନାତ୍ ପ୍ରସ୍ଥାଯ ଗାଲୀଲ୍ସାଗରସ୍ୟ ସନ୍ନିଧିମାଗତ୍ୟ ଧରାଧରମାରୁହ୍ୟ ତତ୍ରୋପୱିୱେଶ| ");
INSERT INTO sanori_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ପଶ୍ଚାତ୍ ଜନନିୱହୋ ବହୂନ୍ ଖଞ୍ଚାନ୍ଧମୂକଶୁଷ୍କକରମାନୁଷାନ୍ ଆଦାଯ ଯୀଶୋଃ ସମୀପମାଗତ୍ୟ ତଚ୍ଚରଣାନ୍ତିକେ ସ୍ଥାପଯାମାସୁଃ, ତତଃ ସା ତାନ୍ ନିରାମଯାନ୍ ଅକରୋତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ଇତ୍ଥଂ ମୂକା ୱାକ୍ୟଂ ୱଦନ୍ତି, ଶୁଷ୍କକରାଃ ସ୍ୱାସ୍ଥ୍ୟମାଯାନ୍ତି, ପଙ୍ଗୱୋ ଗଚ୍ଛନ୍ତି, ଅନ୍ଧା ୱୀକ୍ଷନ୍ତେ, ଇତି ୱିଲୋକ୍ୟ ଲୋକା ୱିସ୍ମଯଂ ମନ୍ୟମାନା ଇସ୍ରାଯେଲ ଈଶ୍ୱରଂ ଧନ୍ୟଂ ବଭାଷିରେ| ");
INSERT INTO sanori_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","ତଦାନୀଂ ଯୀଶୁଃ ସ୍ୱଶିଷ୍ୟାନ୍ ଆହୂଯ ଗଦିତୱାନ୍, ଏତଜ୍ଜନନିୱହେଷୁ ମମ ଦଯା ଜାଯତେ, ଏତେ ଦିନତ୍ରଯଂ ମଯା ସାକଂ ସନ୍ତି, ଏଷାଂ ଭକ୍ଷ୍ୟୱସ୍ତୁ ଚ କଞ୍ଚିଦପି ନାସ୍ତି, ତସ୍ମାଦହମେତାନକୃତାହାରାନ୍ ନ ୱିସ୍ରକ୍ଷ୍ୟାମି, ତଥାତ୍ୱେ ୱର୍ତ୍ମମଧ୍ୟେ କ୍ଲାମ୍ୟେଷୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","ତଦା ଶିଷ୍ୟା ଊଚୁଃ, ଏତସ୍ମିନ୍ ପ୍ରାନ୍ତରମଧ୍ୟ ଏତାୱତୋ ମର୍ତ୍ୟାନ୍ ତର୍ପଯିତୁଂ ୱଯଂ କୁତ୍ର ପୂପାନ୍ ପ୍ରାପ୍ସ୍ୟାମଃ? ");
INSERT INTO sanori_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ଯୀଶୁରପୃଚ୍ଛତ୍, ଯୁଷ୍ମାକଂ ନିକଟେ କତି ପୂପା ଆସତେ? ତ ଊଚୁଃ, ସପ୍ତପୂପା ଅଲ୍ପାଃ କ୍ଷୁଦ୍ରମୀନାଶ୍ଚ ସନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","ତଦାନୀଂ ସ ଲୋକନିୱହଂ ଭୂମାୱୁପୱେଷ୍ଟୁମ୍ ଆଦିଶ୍ୟ ");
INSERT INTO sanori_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ତାନ୍ ସପ୍ତପୂପାନ୍ ମୀନାଂଶ୍ଚ ଗୃହ୍ଲନ୍ ଈଶ୍ୱରୀଯଗୁଣାନ୍ ଅନୂଦ୍ୟ ଭଂକ୍ତ୍ୱା ଶିଷ୍ୟେଭ୍ୟୋ ଦଦୌ, ଶିଷ୍ୟା ଲୋକେଭ୍ୟୋ ଦଦୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ତତଃ ସର୍ୱ୍ୱେ ଭୁକ୍ତ୍ୱା ତୃପ୍ତୱନ୍ତଃ; ତଦୱଶିଷ୍ଟଭକ୍ଷ୍ୟେଣ ସପ୍ତଡଲକାନ୍ ପରିପୂର୍ୟ୍ୟ ସଂଜଗୃହୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","ତେ ଭୋକ୍ତାରୋ ଯୋଷିତୋ ବାଲକାଂଶ୍ଚ ୱିହାଯ ପ୍ରାଯେଣ ଚତୁଃସହସ୍ରାଣି ପୁରୁଷା ଆସନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","ତତଃ ପରଂ ସ ଜନନିୱହଂ ୱିସୃଜ୍ୟ ତରିମାରୁହ୍ୟ ମଗ୍ଦଲାପ୍ରଦେଶଂ ଗତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ତଦାନୀଂ ଫିରୂଶିନଃ ସିଦୂକିନଶ୍ଚାଗତ୍ୟ ତଂ ପରୀକ୍ଷିତୁଂ ନଭମୀଯଂ କିଞ୍ଚନ ଲକ୍ଷ୍ମ ଦର୍ଶଯିତୁଂ ତସ୍ମୈ ନିୱେଦଯାମାସୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ତତଃ ସ ଉକ୍ତୱାନ୍, ସନ୍ଧ୍ୟାଯାଂ ନଭସୋ ରକ୍ତତ୍ୱାଦ୍ ଯୂଯଂ ୱଦଥ, ଶ୍ୱୋ ନିର୍ମ୍ମଲଂ ଦିନଂ ଭୱିଷ୍ୟତି; ");
INSERT INTO sanori_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ପ୍ରାତଃକାଲେ ଚ ନଭସୋ ରକ୍ତତ୍ୱାତ୍ ମଲିନତ୍ୱାଞ୍ଚ ୱଦଥ, ଝଞ୍ଭ୍ଶଦ୍ୟ ଭୱିଷ୍ୟତି| ହେ କପଟିନୋ ଯଦି ଯୂଯମ୍ ଅନ୍ତରୀକ୍ଷସ୍ୟ ଲକ୍ଷ୍ମ ବୋଦ୍ଧୁଂ ଶକ୍ନୁଥ, ତର୍ହି କାଲସ୍ୟୈତସ୍ୟ ଲକ୍ଷ୍ମ କଥଂ ବୋଦ୍ଧୁଂ ନ ଶକ୍ନୁଥ? ");
INSERT INTO sanori_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ଏତତ୍କାଲସ୍ୟ ଦୁଷ୍ଟୋ ୱ୍ୟଭିଚାରୀ ଚ ୱଂଶୋ ଲକ୍ଷ୍ମ ଗୱେଷଯତି, କିନ୍ତୁ ଯୂନସୋ ଭୱିଷ୍ୟଦ୍ୱାଦିନୋ ଲକ୍ଷ୍ମ ୱିନାନ୍ୟତ୍ କିମପି ଲକ୍ଷ୍ମ ତାନ୍ ନ ଦର୍ଶଯିଯ୍ୟତେ| ତଦାନୀଂ ସ ତାନ୍ ୱିହାଯ ପ୍ରତସ୍ଥେ| ");
INSERT INTO sanori_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","ଅନନ୍ତରମନ୍ୟପାରଗମନକାଲେ ତସ୍ୟ ଶିଷ୍ୟାଃ ପୂପମାନେତୁଂ ୱିସ୍ମୃତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ଯୀଶୁସ୍ତାନୱାଦୀତ୍, ଯୂଯଂ ଫିରୂଶିନାଂ ସିଦୂକିନାଞ୍ଚ କିଣ୍ୱଂ ପ୍ରତି ସାୱଧାନାଃ ସତର୍କାଶ୍ଚ ଭୱତ| ");
INSERT INTO sanori_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","ତେନ ତେ ପରସ୍ପରଂ ୱିୱିଚ୍ୟ କଥଯିତୁମାରେଭିରେ, ୱଯଂ ପୂପାନାନେତୁଂ ୱିସ୍ମୃତୱନ୍ତ ଏତତ୍କାରଣାଦ୍ ଇତି କଥଯତି| ");
INSERT INTO sanori_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","କିନ୍ତୁ ଯୀଶୁସ୍ତଦ୍ୱିଜ୍ଞାଯ ତାନୱୋଚତ୍, ହେ ସ୍ତୋକୱିଶ୍ୱାସିନୋ ଯୂଯଂ ପୂପାନାନଯନମଧି କୁତଃ ପରସ୍ପରମେତଦ୍ ୱିୱିଂକ୍ୟ? ");
INSERT INTO sanori_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","ଯୁଷ୍ମାଭିଃ କିମଦ୍ୟାପି ନ ଜ୍ଞାଯତେ? ପଞ୍ଚଭିଃ ପୂପୈଃ ପଞ୍ଚସହସ୍ରପୁରୁଷେଷୁ ଭୋଜିତେଷୁ ଭକ୍ଷ୍ୟୋଚ୍ଛିଷ୍ଟପୂର୍ଣାନ୍ କତି ଡଲକାନ୍ ସମଗୃହ୍ଲୀତଂ; ");
INSERT INTO sanori_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ତଥା ସପ୍ତଭିଃ ପୂପୈଶ୍ଚତୁଃସହସ୍ରପୁରୁଷେଷୁ ଭେଜିତେଷୁ କତି ଡଲକାନ୍ ସମଗୃହ୍ଲୀତ, ତତ୍ କିଂ ଯୁଷ୍ମାଭିର୍ନ ସ୍ମର୍ୟ୍ୟତେ? ");
INSERT INTO sanori_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","ତସ୍ମାତ୍ ଫିରୂଶିନାଂ ସିଦୂକିନାଞ୍ଚ କିଣ୍ୱଂ ପ୍ରତି ସାୱଧାନାସ୍ତିଷ୍ଠତ, କଥାମିମାମ୍ ଅହଂ ପୂପାନଧି ନାକଥଯଂ, ଏତଦ୍ ଯୂଯଂ କୁତୋ ନ ବୁଧ୍ୟଧ୍ୱେ? ");
INSERT INTO sanori_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","ତଦାନୀଂ ପୂପକିଣ୍ୱଂ ପ୍ରତି ସାୱଧାନାସ୍ତିଷ୍ଠତେତି ନୋକ୍ତ୍ୱା ଫିରୂଶିନାଂ ସିଦୂକିନାଞ୍ଚ ଉପଦେଶଂ ପ୍ରତି ସାୱଧାନାସ୍ତିଷ୍ଠତେତି କଥିତୱାନ୍, ଇତି ତୈରବୋଧି| ");
INSERT INTO sanori_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","ଅପରଞ୍ଚ ଯୀଶୁଃ କୈସରିଯା-ଫିଲିପିପ୍ରଦେଶମାଗତ୍ୟ ଶିଷ୍ୟାନ୍ ଅପୃଚ୍ଛତ୍, ଯୋଽହଂ ମନୁଜସୁତଃ ସୋଽହଂ କଃ? ଲୋକୈରହଂ କିମୁଚ୍ୟେ? ");
INSERT INTO sanori_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","ତଦାନୀଂ ତେ କଥିତୱନ୍ତଃ, କେଚିଦ୍ ୱଦନ୍ତି ତ୍ୱଂ ମଜ୍ଜଯିତା ଯୋହନ୍, କେଚିଦ୍ୱଦନ୍ତି, ତ୍ୱମ୍ ଏଲିଯଃ, କେଚିଚ୍ଚ ୱଦନ୍ତି, ତ୍ୱଂ ଯିରିମିଯୋ ୱା କଶ୍ଚିଦ୍ ଭୱିଷ୍ୟଦ୍ୱାଦୀତି| ");
INSERT INTO sanori_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ପଶ୍ଚାତ୍ ସ ତାନ୍ ପପ୍ରଚ୍ଛ, ଯୂଯଂ ମାଂ କଂ ୱଦଥ? ତତଃ ଶିମୋନ୍ ପିତର ଉୱାଚ, ");
INSERT INTO sanori_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ତ୍ୱମମରେଶ୍ୱରସ୍ୟାଭିଷିକ୍ତପୁତ୍ରଃ| ");
INSERT INTO sanori_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ତତୋ ଯୀଶୁଃ କଥିତୱାନ୍, ହେ ଯୂନସଃ ପୁତ୍ର ଶିମୋନ୍ ତ୍ୱଂ ଧନ୍ୟଃ; ଯତଃ କୋପି ଅନୁଜସ୍ତ୍ୱଯ୍ୟେତଜ୍ଜ୍ଞାନଂ ନୋଦପାଦଯତ୍, କିନ୍ତୁ ମମ ସ୍ୱର୍ଗସ୍ୟଃ ପିତୋଦପାଦଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","ଅତୋଽହଂ ତ୍ୱାଂ ୱଦାମି, ତ୍ୱଂ ପିତରଃ (ପ୍ରସ୍ତରଃ) ଅହଞ୍ଚ ତସ୍ୟ ପ୍ରସ୍ତରସ୍ୟୋପରି ସ୍ୱମଣ୍ଡଲୀଂ ନିର୍ମ୍ମାସ୍ୟାମି, ତେନ ନିରଯୋ ବଲାତ୍ ତାଂ ପରାଜେତୁଂ ନ ଶକ୍ଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","ଅହଂ ତୁଭ୍ୟଂ ସ୍ୱର୍ଗୀଯରାଜ୍ୟସ୍ୟ କୁଞ୍ଜିକାଂ ଦାସ୍ୟାମି, ତେନ ଯତ୍ କିଞ୍ଚନ ତ୍ୱଂ ପୃଥିୱ୍ୟାଂ ଭଂତ୍ସ୍ୟସି ତତ୍ସ୍ୱର୍ଗେ ଭଂତ୍ସ୍ୟତେ, ଯଚ୍ଚ କିଞ୍ଚନ ମହ୍ୟାଂ ମୋକ୍ଷ୍ୟସି ତତ୍ ସ୍ୱର୍ଗେ ମୋକ୍ଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","ପଶ୍ଚାତ୍ ସ ଶିଷ୍ୟାନାଦିଶତ୍, ଅହମଭିଷିକ୍ତୋ ଯୀଶୁରିତି କଥାଂ କସ୍ମୈଚିଦପି ଯୂଯଂ ମା କଥଯତ| ");
INSERT INTO sanori_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ଅନ୍ୟଞ୍ଚ ଯିରୂଶାଲମ୍ନଗରଂ ଗତ୍ୱା ପ୍ରାଚୀନଲୋକେଭ୍ୟଃ ପ୍ରଧାନଯାଜକେଭ୍ୟ ଉପାଧ୍ୟାଯେଭ୍ୟଶ୍ଚ ବହୁଦୁଃଖଭୋଗସ୍ତୈ ର୍ହତତ୍ୱଂ ତୃତୀଯଦିନେ ପୁନରୁତ୍ଥାନଞ୍ଚ ମମାୱଶ୍ୟକମ୍ ଏତାଃ କଥା ଯୀଶୁସ୍ତତ୍କାଲମାରଭ୍ୟ ଶିଷ୍ୟାନ୍ ଜ୍ଞାପଯିତୁମ୍ ଆରବ୍ଧୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ତଦାନୀଂ ପିତରସ୍ତସ୍ୟ କରଂ ଘୃତ୍ୱା ତର୍ଜଯିତ୍ୱା କଥଯିତୁମାରବ୍ଧୱାନ୍, ହେ ପ୍ରଭୋ, ତତ୍ ତ୍ୱତ୍ତୋ ଦୂରଂ ଯାତୁ, ତ୍ୱାଂ ପ୍ରତି କଦାପି ନ ଘଟିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","କିନ୍ତୁ ସ ୱଦନଂ ପରାୱର୍ତ୍ୟ ପିତରଂ ଜଗାଦ, ହେ ୱିଘ୍ନକାରିନ୍, ମତ୍ସମ୍ମୁଖାଦ୍ ଦୂରୀଭୱ, ତ୍ୱଂ ମାଂ ବାଧସେ, ଈଶ୍ୱରୀଯକାର୍ୟ୍ୟାତ୍ ମାନୁଷୀଯକାର୍ୟ୍ୟଂ ତୁଭ୍ୟଂ ରୋଚତେ| ");
INSERT INTO sanori_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","ଅନନ୍ତରଂ ଯୀଶୁଃ ସ୍ୱୀଯଶିଷ୍ୟାନ୍ ଉକ୍ତୱାନ୍ ଯଃ କଶ୍ଚିତ୍ ମମ ପଶ୍ଚାଦ୍ଗାମୀ ଭୱିତୁମ୍ ଇଚ୍ଛତି, ସ ସ୍ୱଂ ଦାମ୍ୟତୁ, ତଥା ସ୍ୱକ୍ରୁଶଂ ଗୃହ୍ଲନ୍ ମତ୍ପଶ୍ଚାଦାଯାତୁ| ");
INSERT INTO sanori_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","ଯତୋ ଯଃ ପ୍ରାଣାନ୍ ରକ୍ଷିତୁମିଚ୍ଛତି, ସ ତାନ୍ ହାରଯିଷ୍ୟତି, କିନ୍ତୁ ଯୋ ମଦର୍ଥଂ ନିଜପ୍ରାଣାନ୍ ହାରଯତି, ସ ତାନ୍ ପ୍ରାପ୍ସ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","ମାନୁଷୋ ଯଦି ସର୍ୱ୍ୱଂ ଜଗତ୍ ଲଭତେ ନିଜପ୍ରଣାନ୍ ହାରଯତି, ତର୍ହି ତସ୍ୟ କୋ ଲାଭଃ? ମନୁଜୋ ନିଜପ୍ରାଣାନାଂ ୱିନିମଯେନ ୱା କିଂ ଦାତୁଂ ଶକ୍ନୋତି? ");
INSERT INTO sanori_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","ମନୁଜସୁତଃ ସ୍ୱଦୂତୈଃ ସାକଂ ପିତୁଃ ପ୍ରଭାୱେଣାଗମିଷ୍ୟତି; ତଦା ପ୍ରତିମନୁଜଂ ସ୍ୱସ୍ୱକର୍ମ୍ମାନୁସାରାତ୍ ଫଲଂ ଦାସ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","ଅହଂ ଯୁଷ୍ମାନ୍ ତଥ୍ୟଂ ୱଚ୍ମି, ସରାଜ୍ୟଂ ମନୁଜସୁତମ୍ ଆଗତଂ ନ ପଶ୍ୟନ୍ତୋ ମୃତ୍ୟୁଂ ନ ସ୍ୱାଦିଷ୍ୟନ୍ତି, ଏତାଦୃଶାଃ କତିପଯଜନା ଅତ୍ରାପି ଦଣ୍ଡାଯମାନାଃ ସନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","ଅନନ୍ତରଂ ଷଡ୍ଦିନେଭ୍ୟଃ ପରଂ ଯୀଶୁଃ ପିତରଂ ଯାକୂବଂ ତତ୍ସହଜଂ ଯୋହନଞ୍ଚ ଗୃହ୍ଲନ୍ ଉଚ୍ଚାଦ୍ରେ ର୍ୱିୱିକ୍ତସ୍ଥାନମ୍ ଆଗତ୍ୟ ତେଷାଂ ସମକ୍ଷଂ ରୂପମନ୍ୟତ୍ ଦଧାର| ");
INSERT INTO sanori_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ତେନ ତଦାସ୍ୟଂ ତେଜସ୍ୱି, ତଦାଭରଣମ୍ ଆଲୋକୱତ୍ ପାଣ୍ଡରମଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ଅନ୍ୟଚ୍ଚ ତେନ ସାକଂ ସଂଲପନ୍ତୌ ମୂସା ଏଲିଯଶ୍ଚ ତେଭ୍ୟୋ ଦର୍ଶନଂ ଦଦତୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ତଦାନୀଂ ପିତରୋ ଯୀଶୁଂ ଜଗାଦ, ହେ ପ୍ରଭୋ ସ୍ଥିତିରତ୍ରାସ୍ମାକଂ ଶୁଭା, ଯଦି ଭୱତାନୁମନ୍ୟତେ, ତର୍ହି ଭୱଦର୍ଥମେକଂ ମୂସାର୍ଥମେକମ୍ ଏଲିଯାର୍ଥଞ୍ଚୈକମ୍ ଇତି ତ୍ରୀଣି ଦୂଷ୍ୟାଣି ନିର୍ମ୍ମମ| ");
INSERT INTO sanori_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ଏତତ୍କଥନକାଲ ଏକ ଉଜ୍ଜୱଲଃ ପଯୋଦସ୍ତେଷାମୁପରି ଛାଯାଂ କୃତୱାନ୍, ୱାରିଦାଦ୍ ଏଷା ନଭସୀଯା ୱାଗ୍ ବଭୂୱ, ମମାଯଂ ପ୍ରିଯଃ ପୁତ୍ରଃ, ଅସ୍ମିନ୍ ମମ ମହାସନ୍ତୋଷ ଏତସ୍ୟ ୱାକ୍ୟଂ ଯୂଯଂ ନିଶାମଯତ| ");
INSERT INTO sanori_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","କିନ୍ତୁ ୱାଚମେତାଂ ଶୃଣ୍ୱନ୍ତଏୱ ଶିଷ୍ୟା ମୃଶଂ ଶଙ୍କମାନା ନ୍ୟୁବ୍ଜା ନ୍ୟପତନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ତଦା ଯୀଶୁରାଗତ୍ୟ ତେଷାଂ ଗାତ୍ରାଣି ସ୍ପୃଶନ୍ ଉୱାଚ, ଉତ୍ତିଷ୍ଠତ, ମା ଭୈଷ୍ଟ| ");
INSERT INTO sanori_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ତଦାନୀଂ ନେତ୍ରାଣ୍ୟୁନ୍ମୀଲ୍ୟ ଯୀଶୁଂ ୱିନା କମପି ନ ଦଦୃଶୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ତତଃ ପରମ୍ ଅଦ୍ରେରୱରୋହଣକାଲେ ଯୀଶୁସ୍ତାନ୍ ଇତ୍ୟାଦିଦେଶ, ମନୁଜସୁତସ୍ୟ ମୃତାନାଂ ମଧ୍ୟାଦୁତ୍ଥାନଂ ଯାୱନ୍ନ ଜାଯତେ, ତାୱତ୍ ଯୁଷ୍ମାଭିରେତଦ୍ଦର୍ଶନଂ କସ୍ମୈଚିଦପି ନ କଥଯିତୱ୍ୟଂ| ");
INSERT INTO sanori_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","ତଦା ଶିଷ୍ୟାସ୍ତଂ ପପ୍ରଚ୍ଛୁଃ, ପ୍ରଥମମ୍ ଏଲିଯ ଆଯାସ୍ୟତୀତି କୁତ ଉପାଧ୍ୟାଯୈରୁଚ୍ୟତେ? ");
INSERT INTO sanori_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ତତୋ ଯୀଶୁଃ ପ୍ରତ୍ୟୱାଦୀତ୍, ଏଲିଯଃ ପ୍ରାଗେତ୍ୟ ସର୍ୱ୍ୱାଣି ସାଧଯିଷ୍ୟତୀତି ସତ୍ୟଂ, ");
INSERT INTO sanori_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","କିନ୍ତ୍ୱହଂ ଯୁଷ୍ମାନ୍ ୱଚ୍ମି, ଏଲିଯ ଏତ୍ୟ ଗତଃ, ତେ ତମପରିଚିତ୍ୟ ତସ୍ମିନ୍ ଯଥେଚ୍ଛଂ ୱ୍ୟୱଜହୁଃ; ମନୁଜସୁତେନାପି ତେଷାମନ୍ତିକେ ତାଦୃଗ୍ ଦୁଃଖଂ ଭୋକ୍ତୱ୍ୟଂ| ");
INSERT INTO sanori_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","ତଦାନୀଂ ସ ମଜ୍ଜଯିତାରଂ ଯୋହନମଧି କଥାମେତାଂ ୱ୍ୟାହୃତୱାନ୍, ଇତ୍ଥଂ ତଚ୍ଛିଷ୍ୟା ବୁବୁଧିରେ| ");
INSERT INTO sanori_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ପଶ୍ଚାତ୍ ତେଷୁ ଜନନିୱହସ୍ୟାନ୍ତିକମାଗତେଷୁ କଶ୍ଚିତ୍ ମନୁଜସ୍ତଦନ୍ତିକମେତ୍ୟ ଜାନୂନୀ ପାତଯିତ୍ୱା କଥିତୱାନ୍, ");
INSERT INTO sanori_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ହେ ପ୍ରଭୋ, ମତ୍ପୁତ୍ରଂ ପ୍ରତି କୃପାଂ ୱିଦଧାତୁ, ସୋପସ୍ମାରାମଯେନ ଭୃଶଂ ୱ୍ୟଥିତଃ ସନ୍ ପୁନଃ ପୁନ ର୍ୱହ୍ନୌ ମୁହୁ ର୍ଜଲମଧ୍ୟେ ପତତି| ");
INSERT INTO sanori_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","ତସ୍ମାଦ୍ ଭୱତଃ ଶିଷ୍ୟାଣାଂ ସମୀପେ ତମାନଯଂ କିନ୍ତୁ ତେ ତଂ ସ୍ୱାସ୍ଥଂ କର୍ତ୍ତୁଂ ନ ଶକ୍ତାଃ| ");
INSERT INTO sanori_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ତଦା ଯୀଶୁଃ କଥିତୱାନ୍ ରେ ଅୱିଶ୍ୱାସିନଃ, ରେ ୱିପଥଗାମିନଃ, ପୁନଃ କତିକାଲାନ୍ ଅହଂ ଯୁଷ୍ମାକଂ ସନ୍ନିଧୌ ସ୍ଥାସ୍ୟାମି? କତିକାଲାନ୍ ୱା ଯୁଷ୍ମାନ୍ ସହିଷ୍ୟେ? ତମତ୍ର ମମାନ୍ତିକମାନଯତ| ");
INSERT INTO sanori_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ପଶ୍ଚାଦ୍ ଯୀଶୁନା ତର୍ଜତଏୱ ସ ଭୂତସ୍ତଂ ୱିହାଯ ଗତୱାନ୍, ତଦ୍ଦଣ୍ଡଏୱ ସ ବାଲକୋ ନିରାମଯୋଽଭୂତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ତତଃ ଶିଷ୍ୟା ଗୁପ୍ତଂ ଯୀଶୁମୁପାଗତ୍ୟ ବଭାଷିରେ, କୁତୋ ୱଯଂ ତଂ ଭୂତଂ ତ୍ୟାଜଯିତୁଂ ନ ଶକ୍ତାଃ? ");
INSERT INTO sanori_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ଯୀଶୁନା ତେ ପ୍ରୋକ୍ତାଃ, ଯୁଷ୍ମାକମପ୍ରତ୍ୟଯାତ୍; ");
INSERT INTO sanori_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","ଯୁଷ୍ମାନହଂ ତଥ୍ୟଂ ୱଚ୍ମି ଯଦି ଯୁଷ୍ମାକଂ ସର୍ଷପୈକମାତ୍ରୋପି ୱିଶ୍ୱାସୋ ଜାଯତେ, ତର୍ହି ଯୁଷ୍ମାଭିରସ୍ମିନ୍ ଶୈଲେ ତ୍ୱମିତଃ ସ୍ଥାନାତ୍ ତତ୍ ସ୍ଥାନଂ ଯାହୀତି ବ୍ରୂତେ ସ ତଦୈୱ ଚଲିଷ୍ୟତି, ଯୁଷ୍ମାକଂ କିମପ୍ୟସାଧ୍ୟଞ୍ଚ କର୍ମ୍ମ ନ ସ୍ଥାସ୍ୟାତି| କିନ୍ତୁ ପ୍ରାର୍ଥନୋପୱାସୌ ୱିନୈତାଦୃଶୋ ଭୂତୋ ନ ତ୍ୟାଜ୍ୟେତ| ");
INSERT INTO sanori_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","ଅପରଂ ତେଷାଂ ଗାଲୀଲ୍ପ୍ରଦେଶେ ଭ୍ରମଣକାଲେ ଯୀଶୁନା ତେ ଗଦିତାଃ, ମନୁଜସୁତୋ ଜନାନାଂ କରେଷୁ ସମର୍ପଯିଷ୍ୟତେ ତୈ ର୍ହନିଷ୍ୟତେ ଚ, ");
INSERT INTO sanori_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","କିନ୍ତୁ ତୃତୀଯେଽହି्ନ ମ ଉତ୍ଥାପିଷ୍ୟତେ, ତେନ ତେ ଭୃଶଂ ଦୁଃଖିତା ବଭୂୱଃ| ");
INSERT INTO sanori_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","ତଦନନ୍ତରଂ ତେଷୁ କଫର୍ନାହୂମ୍ନଗରମାଗତେଷୁ କରସଂଗ୍ରାହିଣଃ ପିତରାନ୍ତିକମାଗତ୍ୟ ପପ୍ରଚ୍ଛୁଃ, ଯୁଷ୍ମାକଂ ଗୁରୁଃ କିଂ ମନ୍ଦିରାର୍ଥଂ କରଂ ନ ଦଦାତି? ତତଃ ପିତରଃ କଥିତୱାନ୍ ଦଦାତି| ");
INSERT INTO sanori_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ତତସ୍ତସ୍ମିନ୍ ଗୃହମଧ୍ୟମାଗତେ ତସ୍ୟ କଥାକଥନାତ୍ ପୂର୍ୱ୍ୱମେୱ ଯୀଶୁରୁୱାଚ, ହେ ଶିମୋନ୍, ମେଦିନ୍ୟା ରାଜାନଃ ସ୍ୱସ୍ୱାପତ୍ୟେଭ୍ୟଃ କିଂ ୱିଦେଶିଭ୍ୟଃ କେଭ୍ୟଃ କରଂ ଗୃହ୍ଲନ୍ତି? ଅତ୍ର ତ୍ୱଂ କିଂ ବୁଧ୍ୟସେ? ତତଃ ପିତର ଉକ୍ତୱାନ୍, ୱିଦେଶିଭ୍ୟଃ| ");
INSERT INTO sanori_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ତଦା ଯୀଶୁରୁକ୍ତୱାନ୍, ତର୍ହି ସନ୍ତାନା ମୁକ୍ତାଃ ସନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","ତଥାପି ଯଥାସ୍ମାଭିସ୍ତେଷାମନ୍ତରାଯୋ ନ ଜନ୍ୟତେ, ତତ୍କୃତେ ଜଲଧେସ୍ତୀରଂ ଗତ୍ୱା ୱଡିଶଂ କ୍ଷିପ, ତେନାଦୌ ଯୋ ମୀନ ଉତ୍ଥାସ୍ୟତି, ତଂ ଘୃତ୍ୱା ତନ୍ମୁଖେ ମୋଚିତେ ତୋଲକୈକଂ ରୂପ୍ୟଂ ପ୍ରାପ୍ସ୍ୟସି, ତଦ୍ ଗୃହୀତ୍ୱା ତୱ ମମ ଚ କୃତେ ତେଭ୍ୟୋ ଦେହି| ");
INSERT INTO sanori_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","ତଦାନୀଂ ଶିଷ୍ୟା ଯୀଶୋଃ ସମୀପମାଗତ୍ୟ ପୃଷ୍ଟୱନ୍ତଃ ସ୍ୱର୍ଗରାଜ୍ୟେ କଃ ଶ୍ରେଷ୍ଠଃ? ");
INSERT INTO sanori_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ତତୋ ଯୀଶୁଃ କ୍ଷୁଦ୍ରମେକଂ ବାଲକଂ ସ୍ୱସମୀପମାନୀଯ ତେଷାଂ ମଧ୍ୟେ ନିଧାଯ ଜଗାଦ, ");
INSERT INTO sanori_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ଯୁଷ୍ମାନହଂ ସତ୍ୟଂ ବ୍ରୱୀମି, ଯୂଯଂ ମନୋୱିନିମଯେନ କ୍ଷୁଦ୍ରବାଲୱତ୍ ନ ସନ୍ତଃ ସ୍ୱର୍ଗରାଜ୍ୟଂ ପ୍ରୱେଷ୍ଟୁଂ ନ ଶକ୍ନୁଥ| ");
INSERT INTO sanori_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","ଯଃ କଶ୍ଚିଦ୍ ଏତସ୍ୟ କ୍ଷୁଦ୍ରବାଲକସ୍ୟ ସମମାତ୍ମାନଂ ନମ୍ରୀକରୋତି, ସଏୱ ସ୍ୱର୍ଗରାଜଯେ ଶ୍ରେଷ୍ଠଃ| ");
INSERT INTO sanori_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ଯଃ କଶ୍ଚିଦ୍ ଏତାଦୃଶଂ କ୍ଷୁଦ୍ରବାଲକମେକଂ ମମ ନାମ୍ନି ଗୃହ୍ଲାତି, ସ ମାମେୱ ଗୃହ୍ଲାତି| ");
INSERT INTO sanori_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","କିନ୍ତୁ ଯୋ ଜନୋ ମଯି କୃତୱିଶ୍ୱାସାନାମେତେଷାଂ କ୍ଷୁଦ୍ରପ୍ରାଣିନାମ୍ ଏକସ୍ୟାପି ୱିଧ୍ନିଂ ଜନଯତି, କଣ୍ଠବଦ୍ଧପେଷଣୀକସ୍ୟ ତସ୍ୟ ସାଗରାଗାଧଜଲେ ମଜ୍ଜନଂ ଶ୍ରେଯଃ| ");
INSERT INTO sanori_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","ୱିଘ୍ନାତ୍ ଜଗତଃ ସନ୍ତାପୋ ଭୱିଷ୍ୟତି, ୱିଘ୍ନୋଽୱଶ୍ୟଂ ଜନଯିଷ୍ୟତେ, କିନ୍ତୁ ଯେନ ମନୁଜେନ ୱିଘ୍ନୋ ଜନିଷ୍ୟତେ ତସ୍ୟୈୱ ସନ୍ତାପୋ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","ତସ୍ମାତ୍ ତୱ କରଶ୍ଚରଣୋ ୱା ଯଦି ତ୍ୱାଂ ବାଧତେ, ତର୍ହି ତଂ ଛିତ୍ତ୍ୱା ନିକ୍ଷିପ, ଦ୍ୱିକରସ୍ୟ ଦ୍ୱିପଦସ୍ୟ ୱା ତୱାନପ୍ତୱହ୍ନୌ ନିକ୍ଷେପାତ୍, ଖଞ୍ଜସ୍ୟ ୱା ଛିନ୍ନହସ୍ତସ୍ୟ ତୱ ଜୀୱନେ ପ୍ରୱେଶୋ ୱରଂ| ");
INSERT INTO sanori_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","ଅପରଂ ତୱ ନେତ୍ରଂ ଯଦି ତ୍ୱାଂ ବାଧତେ, ତର୍ହି ତଦପ୍ୟୁତ୍ପାୱ୍ୟ ନିକ୍ଷିପ, ଦ୍ୱିନେତ୍ରସ୍ୟ ନରକାଗ୍ନୌ ନିକ୍ଷେପାତ୍ କାଣସ୍ୟ ତୱ ଜୀୱନେ ପ୍ରୱେଶୋ ୱରଂ| ");
INSERT INTO sanori_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","ତସ୍ମାଦୱଧଦ୍ଧଂ, ଏତେଷାଂ କ୍ଷୁଦ୍ରପ୍ରାଣିନାମ୍ ଏକମପି ମା ତୁଚ୍ଛୀକୁରୁତ, ");
INSERT INTO sanori_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","ଯତୋ ଯୁଷ୍ମାନହଂ ତଥ୍ୟଂ ବ୍ରୱୀମି, ସ୍ୱର୍ଗେ ତେଷାଂ ଦୂତା ମମ ସ୍ୱର୍ଗସ୍ଥସ୍ୟ ପିତୁରାସ୍ୟଂ ନିତ୍ୟଂ ପଶ୍ୟନ୍ତି| ଏୱଂ ଯେ ଯେ ହାରିତାସ୍ତାନ୍ ରକ୍ଷିତୁଂ ମନୁଜପୁତ୍ର ଆଗଚ୍ଛତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","ଯୂଯମତ୍ର କିଂ ୱିୱିଂଗ୍ଘ୍ୱେ? କସ୍ୟଚିଦ୍ ଯଦି ଶତଂ ମେଷାଃ ସନ୍ତି, ତେଷାମେକୋ ହାର୍ୟ୍ୟତେ ଚ, ତର୍ହି ସ ଏକୋନଶତଂ ମେଷାନ୍ ୱିହାଯ ପର୍ୱ୍ୱତଂ ଗତ୍ୱା ତଂ ହାରିତମେକଂ କିଂ ନ ମୃଗଯତେ? ");
INSERT INTO sanori_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ଯଦି ଚ କଦାଚିତ୍ ତନ୍ମେଷୋଦ୍ଦେଶଂ ଲମତେ, ତର୍ହି ଯୁଷ୍ମାନହଂ ସତ୍ୟଂ କଥଯାମି, ସୋଽୱିପଥଗାମିଭ୍ୟ ଏକୋନଶତମେଷେଭ୍ୟୋପି ତଦେକହେତୋରଧିକମ୍ ଆହ୍ଲାଦତେ| ");
INSERT INTO sanori_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","ତଦ୍ୱଦ୍ ଏତେଷାଂ କ୍ଷୁଦ୍ରପ୍ରାଏिନାମ୍ ଏକୋପି ନଶ୍ୟତୀତି ଯୁଷ୍ମାକଂ ସ୍ୱର୍ଗସ୍ଥପିତୁ ର୍ନାଭିମତମ୍| ");
INSERT INTO sanori_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","ଯଦ୍ୟପି ତୱ ଭ୍ରାତା ତ୍ୱଯି କିମପ୍ୟପରାଧ୍ୟତି, ତର୍ହି ଗତ୍ୱା ଯୁୱଯୋର୍ଦ୍ୱଯୋଃ ସ୍ଥିତଯୋସ୍ତସ୍ୟାପରାଧଂ ତଂ ଜ୍ଞାପଯ| ତତ୍ର ସ ଯଦି ତୱ ୱାକ୍ୟଂ ଶୃଣୋତି, ତର୍ହି ତ୍ୱଂ ସ୍ୱଭ୍ରାତରଂ ପ୍ରାପ୍ତୱାନ୍, ");
INSERT INTO sanori_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","କିନ୍ତୁ ଯଦି ନ ଶୃଣୋତି, ତର୍ହି ଦ୍ୱାଭ୍ୟାଂ ତ୍ରିଭି ର୍ୱା ସାକ୍ଷୀଭିଃ ସର୍ୱ୍ୱଂ ୱାକ୍ୟଂ ଯଥା ନିଶ୍ଚିତଂ ଜାଯତେ, ତଦର୍ଥମ୍ ଏକଂ ଦ୍ୱୌ ୱା ସାକ୍ଷିଣୌ ଗୃହୀତ୍ୱା ଯାହି| ");
INSERT INTO sanori_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","ତେନ ସ ଯଦି ତଯୋ ର୍ୱାକ୍ୟଂ ନ ମାନ୍ୟତେ, ତର୍ହି ସମାଜଂ ତଜ୍ଜ୍ଞାପଯ, କିନ୍ତୁ ଯଦି ସମାଜସ୍ୟାପି ୱାକ୍ୟଂ ନ ମାନ୍ୟତେ,ତର୍ହି ସ ତୱ ସମୀପେ ଦେୱପୂଜକଇୱ ଚଣ୍ଡାଲଇୱ ଚ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","ଅହଂ ଯୁଷ୍ମାନ୍ ସତ୍ୟଂ ୱଦାମି, ଯୁଷ୍ମାଭିଃ ପୃଥିୱ୍ୟାଂ ଯଦ୍ ବଧ୍ୟତେ ତତ୍ ସ୍ୱର୍ଗେ ଭଂତ୍ସ୍ୟତେ; ମେଦିନ୍ୟାଂ ଯତ୍ ଭୋଚ୍ୟତେ, ସ୍ୱର୍ଗେଽପି ତତ୍ ମୋକ୍ଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","ପୁନରହଂ ଯୁଷ୍ମାନ୍ ୱଦାମି, ମେଦିନ୍ୟାଂ ଯୁଷ୍ମାକଂ ଯଦି ଦ୍ୱାୱେକୱାକ୍ୟୀଭୂଯ କିଞ୍ଚିତ୍ ପ୍ରାର୍ଥଯେତେ, ତର୍ହି ମମ ସ୍ୱର୍ଗସ୍ଥପିତ୍ରା ତତ୍ ତଯୋଃ କୃତେ ସମ୍ପନ୍ନଂ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","ଯତୋ ଯତ୍ର ଦ୍ୱୌ ତ୍ରଯୋ ୱା ମମ ନାନ୍ନି ମିଲନ୍ତି, ତତ୍ରୈୱାହଂ ତେଷାଂ ମଧ୍ୟେଽସ୍ମି| ");
INSERT INTO sanori_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","ତଦାନୀଂ ପିତରସ୍ତତ୍ସମୀପମାଗତ୍ୟ କଥିତୱାନ୍ ହେ ପ୍ରଭୋ, ମମ ଭ୍ରାତା ମମ ଯଦ୍ୟପରାଧ୍ୟତି, ତର୍ହି ତଂ କତିକୃତ୍ୱଃ କ୍ଷମିଷ୍ୟେ? ");
INSERT INTO sanori_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","କିଂ ସପ୍ତକୃତ୍ୱଃ? ଯୀଶୁସ୍ତଂ ଜଗାଦ, ତ୍ୱାଂ କେୱଲଂ ସପ୍ତକୃତ୍ୱୋ ଯାୱତ୍ ନ ୱଦାମି, କିନ୍ତୁ ସପ୍ତତ୍ୟା ଗୁଣିତଂ ସପ୍ତକୃତ୍ୱୋ ଯାୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","ଅପରଂ ନିଜଦାସୈଃ ସହ ଜିଗଣଯିଷୁଃ କଶ୍ଚିଦ୍ ରାଜେୱ ସ୍ୱର୍ଗରାଜଯଂ| ");
INSERT INTO sanori_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ଆରବ୍ଧେ ତସ୍ମିନ୍ ଗଣନେ ସାର୍ଦ୍ଧସହସ୍ରମୁଦ୍ରାପୂରିତାନାଂ ଦଶସହସ୍ରପୁଟକାନାମ୍ ଏକୋଽଘମର୍ଣସ୍ତତ୍ସମକ୍ଷମାନାଯି| ");
INSERT INTO sanori_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ତସ୍ୟ ପରିଶୋଧନାଯ ଦ୍ରୱ୍ୟାଭାୱାତ୍ ପରିଶୋଧନାର୍ଥଂ ସ ତଦୀଯଭାର୍ୟ୍ୟାପୁତ୍ରାଦିସର୍ୱ୍ୱସ୍ୱଞ୍ଚ ୱିକ୍ରୀଯତାମିତି ତତ୍ପ୍ରଭୁରାଦିଦେଶ| ");
INSERT INTO sanori_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","ତେନ ସ ଦାସସ୍ତସ୍ୟ ପାଦଯୋଃ ପତନ୍ ପ୍ରଣମ୍ୟ କଥିତୱାନ୍ , ହେ ପ୍ରଭୋ ଭୱତା ଘୈର୍ୟ୍ୟେ କୃତେ ମଯା ସର୍ୱ୍ୱଂ ପରିଶୋଧିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","ତଦାନୀଂ ଦାସସ୍ୟ ପ୍ରଭୁଃ ସକରୁଣଃ ସନ୍ ସକଲର୍ଣଂ କ୍ଷମିତ୍ୱା ତଂ ତତ୍ୟାଜ| ");
INSERT INTO sanori_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","କିନ୍ତୁ ତସ୍ମିନ୍ ଦାସେ ବହି ର୍ୟାତେ, ତସ୍ୟ ଶତଂ ମୁଦ୍ରାଚତୁର୍ଥାଂଶାନ୍ ଯୋ ଧାରଯତି, ତଂ ସହଦାସଂ ଦୃଷ୍ଦ୍ୱା ତସ୍ୟ କଣ୍ଠଂ ନିଷ୍ପୀଡ୍ୟ ଗଦିତୱାନ୍, ମମ ଯତ୍ ପ୍ରାପ୍ୟଂ ତତ୍ ପରିଶୋଧଯ| ");
INSERT INTO sanori_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","ତଦା ତସ୍ୟ ସହଦାସସ୍ତତ୍ପାଦଯୋଃ ପତିତ୍ୱା ୱିନୀଯ ବଭାଷେ, ତ୍ୱଯା ଧୈର୍ୟ୍ୟେ କୃତେ ମଯା ସର୍ୱ୍ୱଂ ପରିଶୋଧିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","ତଥାପି ସ ତତ୍ ନାଙଗୀକୃତ୍ୟ ଯାୱତ୍ ସର୍ୱ୍ୱମୃଣଂ ନ ପରିଶୋଧିତୱାନ୍ ତାୱତ୍ ତଂ କାରାଯାଂ ସ୍ଥାପଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ତଦା ତସ୍ୟ ସହଦାସାସ୍ତସ୍ୟୈତାଦୃଗ୍ ଆଚରଣଂ ୱିଲୋକ୍ୟ ପ୍ରଭୋଃ ସମୀପଂ ଗତ୍ୱା ସର୍ୱ୍ୱଂ ୱୃତ୍ତାନ୍ତଂ ନିୱେଦଯାମାସୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","ତଦା ତସ୍ୟ ପ୍ରଭୁସ୍ତମାହୂଯ ଜଗାଦ, ରେ ଦୁଷ୍ଟ ଦାସ, ତ୍ୱଯା ମତ୍ସନ୍ନିଧୌ ପ୍ରାର୍ଥିତେ ମଯା ତୱ ସର୍ୱ୍ୱମୃଣଂ ତ୍ୟକ୍ତଂ; ");
INSERT INTO sanori_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ଯଥା ଚାହଂ ତ୍ୱଯି କରୁଣାଂ କୃତୱାନ୍, ତଥୈୱ ତ୍ୱତ୍ସହଦାସେ କରୁଣାକରଣଂ କିଂ ତୱ ନୋଚିତଂ? ");
INSERT INTO sanori_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ଇତି କଥଯିତ୍ୱା ତସ୍ୟ ପ୍ରଭୁଃ କ୍ରୁଦ୍ଧ୍ୟନ୍ ନିଜପ୍ରାପ୍ୟଂ ଯାୱତ୍ ସ ନ ପରିଶୋଧିତୱାନ୍, ତାୱତ୍ ପ୍ରହାରକାନାଂ କରେଷୁ ତଂ ସମର୍ପିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","ଯଦି ଯୂଯଂ ସ୍ୱାନ୍ତଃକରଣୈଃ ସ୍ୱସ୍ୱସହଜାନାମ୍ ଅପରାଧାନ୍ ନ କ୍ଷମଧ୍ୱେ, ତର୍ହି ମମ ସ୍ୱର୍ଗସ୍ୟଃ ପିତାପି ଯୁଷ୍ମାନ୍ ପ୍ରତୀତ୍ଥଂ କରିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","ଅନନ୍ତରମ୍ ଏତାସୁ କଥାସୁ ସମାପ୍ତାସୁ ଯୀଶୁ ର୍ଗାଲୀଲପ୍ରଦେଶାତ୍ ପ୍ରସ୍ଥାଯ ଯର୍ଦନ୍ତୀରସ୍ଥଂ ଯିହୂଦାପ୍ରଦେଶଂ ପ୍ରାପ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ତଦା ତତ୍ପଶ୍ଚାତ୍ ଜନନିୱହେ ଗତେ ସ ତତ୍ର ତାନ୍ ନିରାମଯାନ୍ ଅକରୋତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ତଦନନ୍ତରଂ ଫିରୂଶିନସ୍ତତ୍ସମୀପମାଗତ୍ୟ ପାରୀକ୍ଷିତୁଂ ତଂ ପପ୍ରଚ୍ଛୁଃ, କସ୍ମାଦପି କାରଣାତ୍ ନରେଣ ସ୍ୱଜାଯା ପରିତ୍ୟାଜ୍ୟା ନ ୱା? ");
INSERT INTO sanori_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ସ ପ୍ରତ୍ୟୁୱାଚ, ପ୍ରଥମମ୍ ଈଶ୍ୱରୋ ନରତ୍ୱେନ ନାରୀତ୍ୱେନ ଚ ମନୁଜାନ୍ ସସର୍ଜ, ତସ୍ମାତ୍ କଥିତୱାନ୍, ");
INSERT INTO sanori_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ମାନୁଷଃ ସ୍ୱପିତରୌ ପରିତ୍ୟଜ୍ୟ ସ୍ୱପତ୍ନ୍ୟାମ୍ ଆସକ୍ଷ୍ୟତେ, ତୌ ଦ୍ୱୌ ଜନାୱେକାଙ୍ଗୌ ଭୱିଷ୍ୟତଃ, କିମେତଦ୍ ଯୁଷ୍ମାଭି ର୍ନ ପଠିତମ୍? ");
INSERT INTO sanori_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","ଅତସ୍ତୌ ପୁନ ର୍ନ ଦ୍ୱୌ ତଯୋରେକାଙ୍ଗତ୍ୱଂ ଜାତଂ, ଈଶ୍ୱରେଣ ଯଚ୍ଚ ସମଯୁଜ୍ୟତ, ମନୁଜୋ ନ ତଦ୍ ଭିନ୍ଦ୍ୟାତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ତଦାନୀଂ ତେ ତଂ ପ୍ରତ୍ୟୱଦନ୍, ତଥାତ୍ୱେ ତ୍ୟାଜ୍ୟପତ୍ରଂ ଦତ୍ତ୍ୱା ସ୍ୱାଂ ସ୍ୱାଂ ଜାଯାଂ ତ୍ୟକ୍ତୁଂ ୱ୍ୟୱସ୍ଥାଂ ମୂସାଃ କଥଂ ଲିଲେଖ? ");
INSERT INTO sanori_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ତତଃ ସ କଥିତୱାନ୍, ଯୁଷ୍ମାକଂ ମନସାଂ କାଠିନ୍ୟାଦ୍ ଯୁଷ୍ମାନ୍ ସ୍ୱାଂ ସ୍ୱାଂ ଜାଯାଂ ତ୍ୟକ୍ତୁମ୍ ଅନ୍ୱମନ୍ୟତ କିନ୍ତୁ ପ୍ରଥମାଦ୍ ଏଷୋ ୱିଧିର୍ନାସୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","ଅତୋ ଯୁଷ୍ମାନହଂ ୱଦାମି, ୱ୍ୟଭିଚାରଂ ୱିନା ଯୋ ନିଜଜାଯାଂ ତ୍ୟଜେତ୍ ଅନ୍ୟାଞ୍ଚ ୱିୱହେତ୍, ସ ପରଦାରାନ୍ ଗଚ୍ଛତି; ଯଶ୍ଚ ତ୍ୟକ୍ତାଂ ନାରୀଂ ୱିୱହତି ସୋପି ପରଦାରେଷୁ ରମତେ| ");
INSERT INTO sanori_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ତଦା ତସ୍ୟ ଶିଷ୍ୟାସ୍ତଂ ବଭାଷିରେ, ଯଦି ସ୍ୱଜାଯଯା ସାକଂ ପୁଂସ ଏତାଦୃକ୍ ସମ୍ବନ୍ଧୋ ଜାଯତେ, ତର୍ହି ୱିୱହନମେୱ ନ ଭଦ୍ରଂ| ");
INSERT INTO sanori_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ତତଃ ସ ଉକ୍ତୱାନ୍, ଯେଭ୍ୟସ୍ତତ୍ସାମର୍ଥ୍ୟଂ ଆଦାଯି, ତାନ୍ ୱିନାନ୍ୟଃ କୋପି ମନୁଜ ଏତନ୍ମତଂ ଗ୍ରହୀତୁଂ ନ ଶକ୍ନୋତି| ");
INSERT INTO sanori_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","କତିପଯା ଜନନକ୍ଲୀବଃ କତିପଯା ନରକୃତକ୍ଲୀବଃ ସ୍ୱର୍ଗରାଜ୍ୟାଯ କତିପଯାଃ ସ୍ୱକୃତକ୍ଲୀବାଶ୍ଚ ସନ୍ତି, ଯେ ଗ୍ରହୀତୁଂ ଶକ୍ନୁୱନ୍ତି ତେ ଗୃହ୍ଲନ୍ତୁ| ");
INSERT INTO sanori_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","ଅପରମ୍ ଯଥା ସ ଶିଶୂନାଂ ଗାତ୍ରେଷୁ ହସ୍ତଂ ଦତ୍ୱା ପ୍ରାର୍ଥଯତେ, ତଦର୍ଥଂ ତତ୍ସମୀଂପଂ ଶିଶୱ ଆନୀଯନ୍ତ, ତତ ଆନଯିତୃନ୍ ଶିଷ୍ୟାସ୍ତିରସ୍କୃତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","କିନ୍ତୁ ଯୀଶୁରୁୱାଚ, ଶିଶୱୋ ମଦନ୍ତିକମ୍ ଆଗଚ୍ଛନ୍ତୁ, ତାନ୍ ମା ୱାରଯତ, ଏତାଦୃଶାଂ ଶିଶୂନାମେୱ ସ୍ୱର୍ଗରାଜ୍ୟଂ| ");
INSERT INTO sanori_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ତତଃ ସ ତେଷାଂ ଗାତ୍ରେଷୁ ହସ୍ତଂ ଦତ୍ୱା ତସ୍ମାତ୍ ସ୍ଥାନାତ୍ ପ୍ରତସ୍ଥେ| ");
INSERT INTO sanori_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","ଅପରମ୍ ଏକ ଆଗତ୍ୟ ତଂ ପପ୍ରଚ୍ଛ, ହେ ପରମଗୁରୋ, ଅନନ୍ତାଯୁଃ ପ୍ରାପ୍ତୁଂ ମଯା କିଂ କିଂ ସତ୍କର୍ମ୍ମ କର୍ତ୍ତୱ୍ୟଂ? ");
INSERT INTO sanori_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ତତଃ ସ ଉୱାଚ, ମାଂ ପରମଂ କୁତୋ ୱଦସି? ୱିନେଶ୍ଚରଂ ନ କୋପି ପରମଃ, କିନ୍ତୁ ଯଦ୍ୟନନ୍ତାଯୁଃ ପ୍ରାପ୍ତୁଂ ୱାଞ୍ଛସି, ତର୍ହ୍ୟାଜ୍ଞାଃ ପାଲଯ| ");
INSERT INTO sanori_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","ତଦା ସ ପୃଷ୍ଟୱାନ୍, କାଃ କା ଆଜ୍ଞାଃ? ତତୋ ଯୀଶୁଃ କଥିତୱାନ୍, ନରଂ ମା ହନ୍ୟାଃ, ପରଦାରାନ୍ ମା ଗଚ୍ଛେଃ, ମା ଚୋରଯେଃ, ମୃଷାସାକ୍ଷ୍ୟଂ ମା ଦଦ୍ୟାଃ, ");
INSERT INTO sanori_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ନିଜପିତରୌ ସଂମନ୍ୟସ୍ୱ, ସ୍ୱସମୀପୱାସିନି ସ୍ୱୱତ୍ ପ୍ରେମ କୁରୁ| ");
INSERT INTO sanori_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ସ ଯୁୱା କଥିତୱାନ୍, ଆ ବାଲ୍ୟାଦ୍ ଏତାଃ ପାଲଯାମି, ଇଦାନୀଂ କିଂ ନ୍ୟୂନମାସ୍ତେ? ");
INSERT INTO sanori_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ତତୋ ଯୀଶୁରୱଦତ୍, ଯଦି ସିଦ୍ଧୋ ଭୱିତୁଂ ୱାଞ୍ଛସି, ତର୍ହି ଗତ୍ୱା ନିଜସର୍ୱ୍ୱସ୍ୱଂ ୱିକ୍ରୀଯ ଦରିଦ୍ରେଭ୍ୟୋ ୱିତର, ତତଃ ସ୍ୱର୍ଗେ ୱିତ୍ତଂ ଲପ୍ସ୍ୟସେ; ଆଗଚ୍ଛ, ମତ୍ପଶ୍ଚାଦ୍ୱର୍ତ୍ତୀ ଚ ଭୱ| ");
INSERT INTO sanori_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ଏତାଂ ୱାଚଂ ଶ୍ରୁତ୍ୱା ସ ଯୁୱା ସ୍ୱୀଯବହୁସମ୍ପତ୍ତେ ର୍ୱିଷଣଃ ସନ୍ ଚଲିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ତଦା ଯୀଶୁଃ ସ୍ୱଶିଷ୍ୟାନ୍ ଅୱଦତ୍, ଧନିନାଂ ସ୍ୱର୍ଗରାଜ୍ୟପ୍ରୱେଶୋ ମହାଦୁଷ୍କର ଇତି ଯୁଷ୍ମାନହଂ ତଥ୍ୟଂ ୱଦାମି| ");
INSERT INTO sanori_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","ପୁନରପି ଯୁଷ୍ମାନହଂ ୱଦାମି, ଧନିନାଂ ସ୍ୱର୍ଗରାଜ୍ୟପ୍ରୱେଶାତ୍ ସୂଚୀଛିଦ୍ରେଣ ମହାଙ୍ଗଗମନଂ ସୁକରଂ| ");
INSERT INTO sanori_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ଇତି ୱାକ୍ୟଂ ନିଶମ୍ୟ ଶିଷ୍ୟା ଅତିଚମତ୍କୃତ୍ୟ କଥଯାମାସୁଃ; ତର୍ହି କସ୍ୟ ପରିତ୍ରାଣଂ ଭୱିତୁଂ ଶକ୍ନୋତି? ");
INSERT INTO sanori_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ତଦା ସ ତାନ୍ ଦୃଷ୍ଦ୍ୱା କଥଯାମାସ, ତତ୍ ମାନୁଷାଣାମଶକ୍ୟଂ ଭୱତି, କିନ୍ତ୍ୱୀଶ୍ୱରସ୍ୟ ସର୍ୱ୍ୱଂ ଶକ୍ୟମ୍| ");
INSERT INTO sanori_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","ତଦା ପିତରସ୍ତଂ ଗଦିତୱାନ୍, ପଶ୍ୟ, ୱଯଂ ସର୍ୱ୍ୱଂ ପରିତ୍ୟଜ୍ୟ ଭୱତଃ ପଶ୍ଚାଦ୍ୱର୍ତ୍ତିନୋ ଽଭୱାମ; ୱଯଂ କିଂ ପ୍ରାପ୍ସ୍ୟାମଃ? ");
INSERT INTO sanori_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ତତୋ ଯୀଶୁଃ କଥିତୱାନ୍, ଯୁଷ୍ମାନହଂ ତଥ୍ୟଂ ୱଦାମି, ଯୂଯଂ ମମ ପଶ୍ଚାଦ୍ୱର୍ତ୍ତିନୋ ଜାତା ଇତି କାରଣାତ୍ ନୱୀନସୃଷ୍ଟିକାଲେ ଯଦା ମନୁଜସୁତଃ ସ୍ୱୀଯୈଶ୍ଚର୍ୟ୍ୟସିଂହାସନ ଉପୱେକ୍ଷ୍ୟତି, ତଦା ଯୂଯମପି ଦ୍ୱାଦଶସିଂହାସନେଷୂପୱିଶ୍ୟ ଇସ୍ରାଯେଲୀଯଦ୍ୱାଦଶୱଂଶାନାଂ ୱିଚାରଂ କରିଷ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","ଅନ୍ୟଚ୍ଚ ଯଃ କଶ୍ଚିତ୍ ମମ ନାମକାରଣାତ୍ ଗୃହଂ ୱା ଭ୍ରାତରଂ ୱା ଭଗିନୀଂ ୱା ପିତରଂ ୱା ମାତରଂ ୱା ଜାଯାଂ ୱା ବାଲକଂ ୱା ଭୂମିଂ ପରିତ୍ୟଜତି, ସ ତେଷାଂ ଶତଗୁଣଂ ଲପ୍ସ୍ୟତେ, ଅନନ୍ତାଯୁମୋଽଧିକାରିତ୍ୱଞ୍ଚ ପ୍ରାପ୍ସ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","କିନ୍ତୁ ଅଗ୍ରୀଯା ଅନେକେ ଜନାଃ ପଶ୍ଚାତ୍, ପଶ୍ଚାତୀଯାଶ୍ଚାନେକେ ଲୋକା ଅଗ୍ରେ ଭୱିଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","ସ୍ୱର୍ଗରାଜ୍ୟମ୍ ଏତାଦୃଶା କେନଚିଦ୍ ଗୃହସ୍ୟେନ ସମଂ, ଯୋଽତିପ୍ରଭାତେ ନିଜଦ୍ରାକ୍ଷାକ୍ଷେତ୍ରେ କୃଷକାନ୍ ନିଯୋକ୍ତୁଂ ଗତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ପଶ୍ଚାତ୍ ତୈଃ ସାକଂ ଦିନୈକଭୃତିଂ ମୁଦ୍ରାଚତୁର୍ଥାଂଶଂ ନିରୂପ୍ୟ ତାନ୍ ଦ୍ରାକ୍ଷାକ୍ଷେତ୍ରଂ ପ୍ରେରଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","ଅନନ୍ତରଂ ପ୍ରହରୈକୱେଲାଯାଂ ଗତ୍ୱା ହଟ୍ଟେ କତିପଯାନ୍ ନିଷ୍କର୍ମ୍ମକାନ୍ ୱିଲୋକ୍ୟ ତାନୱଦତ୍, ");
INSERT INTO sanori_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ଯୂଯମପି ମମ ଦ୍ରାକ୍ଷାକ୍ଷେତ୍ରଂ ଯାତ, ଯୁଷ୍ମଭ୍ୟମହଂ ଯୋଗ୍ୟଭୃତିଂ ଦାସ୍ୟାମି, ତତସ୍ତେ ୱୱ୍ରଜୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","ପୁନଶ୍ଚ ସ ଦ୍ୱିତୀଯତୃତୀଯଯୋଃ ପ୍ରହରଯୋ ର୍ବହି ର୍ଗତ୍ୱା ତଥୈୱ କୃତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","ତତୋ ଦଣ୍ଡଦ୍ୱଯାୱଶିଷ୍ଟାଯାଂ ୱେଲାଯାଂ ବହି ର୍ଗତ୍ୱାପରାନ୍ କତିପଯଜନାନ୍ ନିଷ୍କର୍ମ୍ମକାନ୍ ୱିଲୋକ୍ୟ ପୃଷ୍ଟୱାନ୍, ଯୂଯଂ କିମର୍ଥମ୍ ଅତ୍ର ସର୍ୱ୍ୱଂ ଦିନଂ ନିଷ୍କର୍ମ୍ମାଣସ୍ତିଷ୍ଠଥ? ");
INSERT INTO sanori_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","ତେ ପ୍ରତ୍ୟୱଦନ୍, ଅସ୍ମାନ୍ ନ କୋପି କର୍ମମଣି ନିଯୁଂକ୍ତେ| ତଦାନୀଂ ସ କଥିତୱାନ୍, ଯୂଯମପି ମମ ଦ୍ରାକ୍ଷାକ୍ଷେତ୍ରଂ ଯାତ, ତେନ ଯୋଗ୍ୟାଂ ଭୃତିଂ ଲପ୍ସ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","ତଦନନ୍ତରଂ ସନ୍ଧ୍ୟାଯାଂ ସତ୍ୟାଂ ସଏୱ ଦ୍ରାକ୍ଷାକ୍ଷେତ୍ରପତିରଧ୍ୟକ୍ଷଂ ଗଦିୱାନ୍, କୃଷକାନ୍ ଆହୂଯ ଶେଷଜନମାରଭ୍ୟ ପ୍ରଥମଂ ଯାୱତ୍ ତେଭ୍ୟୋ ଭୃତିଂ ଦେହି| ");
INSERT INTO sanori_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","ତେନ ଯେ ଦଣ୍ଡଦ୍ୱଯାୱସ୍ଥିତେ ସମାଯାତାସ୍ତେଷାମ୍ ଏକୈକୋ ଜନୋ ମୁଦ୍ରାଚତୁର୍ଥାଂଶଂ ପ୍ରାପ୍ନୋତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ତଦାନୀଂ ପ୍ରଥମନିଯୁକ୍ତା ଜନା ଆଗତ୍ୟାନୁମିତୱନ୍ତୋ ୱଯମଧିକଂ ପ୍ରପ୍ସ୍ୟାମଃ, କିନ୍ତୁ ତୈରପି ମୁଦ୍ରାଚତୁର୍ଥାଂଶୋଽଲାଭି| ");
INSERT INTO sanori_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ତତସ୍ତେ ତଂ ଗୃହୀତ୍ୱା ତେନ କ୍ଷେତ୍ରପତିନା ସାକଂ ୱାଗ୍ୟୁଦ୍ଧଂ କୁର୍ୱ୍ୱନ୍ତଃ କଥଯାମାସୁଃ, ");
INSERT INTO sanori_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ୱଯଂ କୃତ୍ସ୍ନଂ ଦିନଂ ତାପକ୍ଲେଶୌ ସୋଢୱନ୍ତଃ, କିନ୍ତୁ ପଶ୍ଚାତାଯା ସେ ଜନା ଦଣ୍ଡଦ୍ୱଯମାତ୍ରଂ ପରିଶ୍ରାନ୍ତୱନ୍ତସ୍ତେଽସ୍ମାଭିଃ ସମାନାଂଶାଃ କୃତାଃ| ");
INSERT INTO sanori_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","ତତଃ ସ ତେଷାମେକଂ ପ୍ରତ୍ୟୁୱାଚ, ହେ ୱତ୍ସ, ମଯା ତ୍ୱାଂ ପ୍ରତି କୋପ୍ୟନ୍ୟାଯୋ ନ କୃତଃ କିଂ ତ୍ୱଯା ମତ୍ସମକ୍ଷଂ ମୁଦ୍ରାଚତୁର୍ଥାଂଶୋ ନାଙ୍ଗୀକୃତଃ? ");
INSERT INTO sanori_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ତସ୍ମାତ୍ ତୱ ଯତ୍ ପ୍ରାପ୍ୟଂ ତଦାଦାଯ ଯାହି, ତୁଭ୍ୟଂ ଯତି, ପଶ୍ଚାତୀଯନିଯୁକ୍ତଲୋକାଯାପି ତତି ଦାତୁମିଚ୍ଛାମି| ");
INSERT INTO sanori_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ସ୍ୱେଚ୍ଛଯା ନିଜଦ୍ରୱ୍ୟୱ୍ୟୱହରଣଂ କିଂ ମଯା ନ କର୍ତ୍ତୱ୍ୟଂ? ମମ ଦାତୃତ୍ୱାତ୍ ତ୍ୱଯା କିମ୍ ଈର୍ଷ୍ୟାଦୃଷ୍ଟିଃ କ୍ରିଯତେ? ");
INSERT INTO sanori_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","ଇତ୍ଥମ୍ ଅଗ୍ରୀଯଲୋକାଃ ପଶ୍ଚତୀଯା ଭୱିଷ୍ୟନ୍ତି, ପଶ୍ଚାତୀଯଜନାଶ୍ଚଗ୍ରୀଯା ଭୱିଷ୍ୟନ୍ତି, ଅହୂତା ବହୱଃ କିନ୍ତ୍ୱଲ୍ପେ ମନୋଭିଲଷିତାଃ| ");
INSERT INTO sanori_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ତଦନନ୍ତରଂ ଯୀଶୁ ର୍ୟିରୂଶାଲମ୍ନଗରଂ ଗଚ୍ଛନ୍ ମାର୍ଗମଧ୍ୟେ ଶିଷ୍ୟାନ୍ ଏକାନ୍ତେ ୱଭାଷେ, ");
INSERT INTO sanori_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","ପଶ୍ୟ ୱଯଂ ଯିରୂଶାଲମ୍ନଗରଂ ଯାମଃ, ତତ୍ର ପ୍ରଧାନଯାଜକାଧ୍ୟାପକାନାଂ କରେଷୁ ମନୁଷ୍ୟପୁତ୍ରଃ ସମର୍ପିଷ୍ୟତେ; ");
INSERT INTO sanori_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ତେ ଚ ତଂ ହନ୍ତୁମାଜ୍ଞାପ୍ୟ ତିରସ୍କୃତ୍ୟ ୱେତ୍ରେଣ ପ୍ରହର୍ତ୍ତୁଂ କ୍ରୁଶେ ଧାତଯିତୁଞ୍ଚାନ୍ୟଦେଶୀଯାନାଂ କରେଷୁ ସମର୍ପଯିଷ୍ୟନ୍ତି, କିନ୍ତୁ ସ ତୃତୀଯଦିୱସେ ଶ୍ମଶାନାଦ୍ ଉତ୍ଥାପିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","ତଦାନୀଂ ସିୱଦୀଯସ୍ୟ ନାରୀ ସ୍ୱପୁତ୍ରାୱାଦାଯ ଯୀଶୋଃ ସମୀପମ୍ ଏତ୍ୟ ପ୍ରଣମ୍ୟ କଞ୍ଚନାନୁଗ୍ରହଂ ତଂ ଯଯାଚେ| ");
INSERT INTO sanori_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ତଦା ଯୀଶୁସ୍ତାଂ ପ୍ରୋକ୍ତୱାନ୍, ତ୍ୱଂ କିଂ ଯାଚସେ? ତତଃ ସା ବଭାଷେ, ଭୱତୋ ରାଜତ୍ୱେ ମମାନଯୋଃ ସୁତଯୋରେକଂ ଭୱଦ୍ଦକ୍ଷିଣପାର୍ଶ୍ୱେ ଦ୍ୱିତୀଯଂ ୱାମପାର୍ଶ୍ୱ ଉପୱେଷ୍ଟୁମ୍ ଆଜ୍ଞାପଯତୁ| ");
INSERT INTO sanori_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ଯୀଶୁଃ ପ୍ରତ୍ୟୁୱାଚ, ଯୁୱାଭ୍ୟାଂ ଯଦ୍ ଯାଚ୍ୟତେ, ତନ୍ନ ବୁଧ୍ୟତେ, ଅହଂ ଯେନ କଂସେନ ପାସ୍ୟାମି ଯୁୱାଭ୍ୟାଂ କିଂ ତେନ ପାତୁଂ ଶକ୍ୟତେ? ଅହଞ୍ଚ ଯେନ ମଜ୍ଜେନେନ ମଜ୍ଜିଷ୍ୟେ, ଯୁୱାଭ୍ୟାଂ କିଂ ତେନ ମଜ୍ଜଯିତୁଂ ଶକ୍ୟତେ? ତେ ଜଗଦୁଃ ଶକ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ତଦା ସ ଉକ୍ତୱାନ୍, ଯୁୱାଂ ମମ କଂସେନାୱଶ୍ୟଂ ପାସ୍ୟଥଃ, ମମ ମଜ୍ଜନେନ ଚ ଯୁୱାମପି ମଜ୍ଜିଷ୍ୟେଥେ, କିନ୍ତୁ ଯେଷାଂ କୃତେ ମତ୍ତାତେନ ନିରୂପିତମ୍ ଇଦଂ ତାନ୍ ୱିହାଯାନ୍ୟଂ କମପି ମଦ୍ଦକ୍ଷିଣପାର୍ଶ୍ୱେ ୱାମପାର୍ଶ୍ୱେ ଚ ସମୁପୱେଶଯିତୁଂ ମମାଧିକାରୋ ନାସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ଏତାଂ କଥାଂ ଶ୍ରୁତ୍ୱାନ୍ୟେ ଦଶଶିଷ୍ୟାସ୍ତୌ ଭ୍ରାତରୌ ପ୍ରତି ଚୁକୁପୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","କିନ୍ତୁ ଯୀଶୁଃ ସ୍ୱସମୀପଂ ତାନାହୂଯ ଜଗାଦ, ଅନ୍ୟଦେଶୀଯଲୋକାନାଂ ନରପତଯସ୍ତାନ୍ ଅଧିକୁର୍ୱ୍ୱନ୍ତି, ଯେ ତୁ ମହାନ୍ତସ୍ତେ ତାନ୍ ଶାସତି, ଇତି ଯୂଯଂ ଜାନୀଥ| ");
INSERT INTO sanori_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","କିନ୍ତୁ ଯୁଷ୍ମାକଂ ମଧ୍ୟେ ନ ତଥା ଭୱେତ୍, ଯୁଷ୍ମାକଂ ଯଃ କଶ୍ଚିତ୍ ମହାନ୍ ବୁଭୂଷତି, ସ ଯୁଷ୍ମାନ୍ ସେୱେତ; ");
INSERT INTO sanori_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ଯଶ୍ଚ ଯୁଷ୍ମାକଂ ମଧ୍ୟେ ମୁଖ୍ୟୋ ବୁଭୂଷତି, ସ ଯୁଷ୍ମାକଂ ଦାସୋ ଭୱେତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ଇତ୍ଥଂ ମନୁଜପୁତ୍ରଃ ସେୱ୍ୟୋ ଭୱିତୁଂ ନହି, କିନ୍ତୁ ସେୱିତୁଂ ବହୂନାଂ ପରିତ୍ରାଣମୂଲ୍ୟାର୍ଥଂ ସ୍ୱପ୍ରାଣାନ୍ ଦାତୁଞ୍ଚାଗତଃ| ");
INSERT INTO sanori_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","ଅନନ୍ତରଂ ଯିରୀହୋନଗରାତ୍ ତେଷାଂ ବହିର୍ଗମନସମଯେ ତସ୍ୟ ପଶ୍ଚାଦ୍ ବହୱୋ ଲୋକା ୱୱ୍ରଜୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ଅପରଂ ୱର୍ତ୍ମପାର୍ଶ୍ୱ ଉପୱିଶନ୍ତୌ ଦ୍ୱାୱନ୍ଧୌ ତେନ ମାର୍ଗେଣ ଯୀଶୋ ର୍ଗମନଂ ନିଶମ୍ୟ ପ୍ରୋଚ୍ଚୈଃ କଥଯାମାସତୁଃ, ହେ ପ୍ରଭୋ ଦାଯୂଦଃ ସନ୍ତାନ, ଆୱଯୋ ର୍ଦଯାଂ ୱିଧେହି| ");
INSERT INTO sanori_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ତତୋ ଲୋକାଃ ସର୍ୱ୍ୱେ ତୁଷ୍ଣୀମ୍ଭୱତମିତ୍ୟୁକ୍ତ୍ୱା ତୌ ତର୍ଜଯାମାସୁଃ; ତଥାପି ତୌ ପୁନରୁଚ୍ଚୈଃ କଥଯାମାସତୁଃ ହେ ପ୍ରଭୋ ଦାଯୂଦଃ ସନ୍ତାନ, ଆୱାଂ ଦଯସ୍ୱ| ");
INSERT INTO sanori_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ତଦାନୀଂ ଯୀଶୁଃ ସ୍ଥଗିତଃ ସନ୍ ତାୱାହୂଯ ଭାଷିତୱାନ୍, ଯୁୱଯୋଃ କୃତେ ମଯା କିଂ କର୍ତ୍ତର୍ୱ୍ୟଂ? ଯୁୱାଂ କିଂ କାମଯେଥେ? ");
INSERT INTO sanori_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ତଦା ତାୱୁକ୍ତୱନ୍ତୌ, ପ୍ରଭୋ ନେତ୍ରାଣି ନୌ ପ୍ରସନ୍ନାନି ଭୱେଯୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ତଦାନୀଂ ଯୀଶୁସ୍ତୌ ପ୍ରତି ପ୍ରମନ୍ନଃ ସନ୍ ତଯୋ ର୍ନେତ୍ରାଣି ପସ୍ପର୍ଶ, ତେନୈୱ ତୌ ସୁୱୀକ୍ଷାଞ୍ଚକ୍ରାତେ ତତ୍ପଶ୍ଚାତ୍ ଜଗ୍ମୁତୁଶ୍ଚ| ");
INSERT INTO sanori_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","ଅନନ୍ତରଂ ତେଷୁ ଯିରୂଶାଲମ୍ନଗରସ୍ୟ ସମୀପୱେର୍ତ୍ତିନୋ ଜୈତୁନନାମକଧରାଧରସ୍ୟ ସମୀପସ୍ଥ୍ତିଂ ବୈତ୍ଫଗିଗ୍ରାମମ୍ ଆଗତେଷୁ, ଯୀଶୁଃ ଶିଷ୍ୟଦ୍ୱଯଂ ପ୍ରେଷଯନ୍ ଜଗାଦ, ");
INSERT INTO sanori_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ଯୁୱାଂ ସମ୍ମୁଖସ୍ଥଗ୍ରାମଂ ଗତ୍ୱା ବଦ୍ଧାଂ ଯାଂ ସୱତ୍ସାଂ ଗର୍ଦ୍ଦଭୀଂ ହଠାତ୍ ପ୍ରାପ୍ସ୍ୟଥଃ, ତାଂ ମୋଚଯିତ୍ୱା ମଦନ୍ତିକମ୍ ଆନଯତଂ| ");
INSERT INTO sanori_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","ତତ୍ର ଯଦି କଶ୍ଚିତ୍ କିଞ୍ଚିଦ୍ ୱକ୍ଷ୍ୟତି, ତର୍ହି ୱଦିଷ୍ୟଥଃ, ଏତସ୍ୟାଂ ପ୍ରଭୋଃ ପ୍ରଯୋଜନମାସ୍ତେ, ତେନ ସ ତତ୍କ୍ଷଣାତ୍ ପ୍ରହେଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ସୀଯୋନଃ କନ୍ୟକାଂ ଯୂଯଂ ଭାଷଧ୍ୱମିତି ଭାରତୀଂ| ପଶ୍ୟ ତେ ନମ୍ରଶୀଲଃ ସନ୍ ନୃପ ଆରୁହ୍ୟ ଗର୍ଦଭୀଂ| ଅର୍ଥାଦାରୁହ୍ୟ ତଦ୍ୱତ୍ସମାଯାସ୍ୟତି ତ୍ୱଦନ୍ତିକଂ| ");
INSERT INTO sanori_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","ଭୱିଷ୍ୟଦ୍ୱାଦିନୋକ୍ତଂ ୱଚନମିଦଂ ତଦା ସଫଲମଭୂତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","ଅନନ୍ତରଂ ତୌ ଶ୍ଷ୍ୟିौ ଯୀଶୋ ର୍ୟଥାନିଦେଶଂ ତଂ ଗ୍ରାମଂ ଗତ୍ୱା ");
INSERT INTO sanori_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ଗର୍ଦଭୀଂ ତଦ୍ୱତ୍ସଞ୍ଚ ସମାନୀତୱନ୍ତୌ, ପଶ୍ଚାତ୍ ତଦୁପରି ସ୍ୱୀଯୱସନାନୀ ପାତଯିତ୍ୱା ତମାରୋହଯାମାସତୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ତତୋ ବହୱୋ ଲୋକା ନିଜୱସନାନି ପଥି ପ୍ରସାରଯିତୁମାରେଭିରେ, କତିପଯା ଜନାଶ୍ଚ ପାଦପପର୍ଣାଦିକଂ ଛିତ୍ୱା ପଥି ୱିସ୍ତାରଯାମାସୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ଅଗ୍ରଗାମିନଃ ପଶ୍ଚାଦ୍ଗାମିନଶ୍ଚ ମନୁଜା ଉଚ୍ଚୈର୍ଜଯ ଜଯ ଦାଯୂଦଃ ସନ୍ତାନେତି ଜଗଦୁଃ ପରମେଶ୍ୱରସ୍ୟ ନାମ୍ନା ଯ ଆଯାତି ସ ଧନ୍ୟଃ, ସର୍ୱ୍ୱୋପରିସ୍ଥସ୍ୱର୍ଗେପି ଜଯତି| ");
INSERT INTO sanori_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ଇତ୍ଥଂ ତସ୍ମିନ୍ ଯିରୂଶାଲମଂ ପ୍ରୱିଷ୍ଟେ କୋଽଯମିତି କଥନାତ୍ କୃତ୍ସ୍ନଂ ନଗରଂ ଚଞ୍ଚଲମଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","ତତ୍ର ଲୋକୋଃ କଥଯାମାସୁଃ, ଏଷ ଗାଲୀଲ୍ପ୍ରଦେଶୀଯ-ନାସରତୀଯ-ଭୱିଷ୍ୟଦ୍ୱାଦୀ ଯୀଶୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ଅନନ୍ତରଂ ଯୀଶୁରୀଶ୍ୱରସ୍ୟ ମନ୍ଦିରଂ ପ୍ରୱିଶ୍ୟ ତନ୍ମଧ୍ୟାତ୍ କ୍ରଯୱିକ୍ରଯିଣୋ ୱହିଶ୍ଚକାର; ୱଣିଜାଂ ମୁଦ୍ରାସନାନୀ କପୋତୱିକ୍ରଯିଣାଞ୍ଚସନାନୀ ଚ ନ୍ୟୁୱ୍ଜଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ଅପରଂ ତାନୁୱାଚ, ଏଷା ଲିପିରାସ୍ତେ, \"ମମ ଗୃହଂ ପ୍ରାର୍ଥନାଗୃହମିତି ୱିଖ୍ୟାସ୍ୟତି\", କିନ୍ତୁ ଯୂଯଂ ତଦ୍ ଦସ୍ୟୂନାଂ ଗହ୍ୱରଂ କୃତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","ତଦନନ୍ତରମ୍ ଅନ୍ଧଖଞ୍ଚଲୋକାସ୍ତସ୍ୟ ସମୀପମାଗତାଃ, ସ ତାନ୍ ନିରାମଯାନ୍ କୃତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ଯଦା ପ୍ରଧାନଯାଜକା ଅଧ୍ୟାପକାଶ୍ଚ ତେନ କୃତାନ୍ୟେତାନି ଚିତ୍ରକର୍ମ୍ମାଣି ଦଦୃଶୁଃ, ଜଯ ଜଯ ଦାଯୂଦଃ ସନ୍ତାନ, ମନ୍ଦିରେ ବାଲକାନାମ୍ ଏତାଦୃଶମ୍ ଉଚ୍ଚଧ୍ୱନିଂ ଶୁଶ୍ରୁୱୁଶ୍ଚ, ତଦା ମହାକ୍ରୁଦ୍ଧା ବଭୂୱଃ, ");
INSERT INTO sanori_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ତଂ ପପ୍ରଚ୍ଛୁଶ୍ଚ, ଇମେ ଯଦ୍ ୱଦନ୍ତି, ତତ୍ କିଂ ତ୍ୱଂ ଶୃଣୋଷି? ତତୋ ଯୀଶୁସ୍ତାନ୍ ଅୱୋଚତ୍, ସତ୍ୟମ୍; ସ୍ତନ୍ୟପାଯିଶିଶୂନାଞ୍ଚ ବାଲକାନାଞ୍ଚ ୱକ୍ତ୍ରତଃ| ସ୍ୱକୀଯଂ ମହିମାନଂ ତ୍ୱଂ ସଂପ୍ରକାଶଯସି ସ୍ୱଯଂ| ଏତଦ୍ୱାକ୍ୟଂ ଯୂଯଂ କିଂ ନାପଠତ? ");
INSERT INTO sanori_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ତତସ୍ତାନ୍ ୱିହାଯ ସ ନଗରାଦ୍ ବୈଥନିଯାଗ୍ରାମଂ ଗତ୍ୱା ତତ୍ର ରଜନୀଂ ଯାପଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","ଅନନ୍ତରଂ ପ୍ରଭାତେ ସତି ଯୀଶୁଃ ପୁନରପି ନଗରମାଗଚ୍ଛନ୍ କ୍ଷୁଧାର୍ତ୍ତୋ ବଭୂୱ| ");
INSERT INTO sanori_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ତତୋ ମାର୍ଗପାର୍ଶ୍ୱ ଉଡୁମ୍ବରୱୃକ୍ଷମେକଂ ୱିଲୋକ୍ୟ ତତ୍ସମୀପଂ ଗତ୍ୱା ପତ୍ରାଣି ୱିନା କିମପି ନ ପ୍ରାପ୍ୟ ତଂ ପାଦପଂ ପ୍ରୋୱାଚ, ଅଦ୍ୟାରଭ୍ୟ କଦାପି ତ୍ୱଯି ଫଲଂ ନ ଭୱତୁ; ତେନ ତତ୍କ୍ଷଣାତ୍ ସ ଉଡୁମ୍ବରମାହୀରୁହଃ ଶୁଷ୍କତାଂ ଗତଃ| ");
INSERT INTO sanori_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ତଦ୍ ଦୃଷ୍ଟ୍ୱା ଶିଷ୍ୟା ଆଶ୍ଚର୍ୟ୍ୟଂ ୱିଜ୍ଞାଯ କଥଯାମାସୁଃ, ଆଃ, ଉଡୁମ୍ୱରପାଦପୋଽତିତୂର୍ଣଂ ଶୁଷ୍କୋଽଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ତତୋ ଯୀଶୁସ୍ତାନୁୱାଚ, ଯୁଷ୍ମାନହଂ ସତ୍ୟଂ ୱଦାମି, ଯଦି ଯୂଯମସନ୍ଦିଗ୍ଧାଃ ପ୍ରତୀଥ, ତର୍ହି ଯୂଯମପି କେୱଲୋଡୁମ୍ୱରପାଦପଂ ପ୍ରତୀତ୍ଥଂ କର୍ତ୍ତୁଂ ଶକ୍ଷ୍ୟଥ, ତନ୍ନ, ତ୍ୱଂ ଚଲିତ୍ୱା ସାଗରେ ପତେତି ୱାକ୍ୟଂ ଯୁଷ୍ମାଭିରସ୍ମିନ ଶୈଲେ ପ୍ରୋକ୍ତେପି ତଦୈୱ ତଦ୍ ଘଟିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","ତଥା ୱିଶ୍ୱସ୍ୟ ପ୍ରାର୍ଥ୍ୟ ଯୁଷ୍ମାଭି ର୍ୟଦ୍ ଯାଚିଷ୍ୟତେ, ତଦେୱ ପ୍ରାପ୍ସ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","ଅନନ୍ତରଂ ମନ୍ଦିରଂ ପ୍ରୱିଶ୍ୟୋପଦେଶନସମଯେ ତତ୍ସମୀପଂ ପ୍ରଧାନଯାଜକାଃ ପ୍ରାଚୀନଲୋକାଶ୍ଚାଗତ୍ୟ ପପ୍ରଚ୍ଛୁଃ, ତ୍ୱଯା କେନ ସାମର୍ଥ୍ୟନୈତାନି କର୍ମ୍ମାଣି କ୍ରିଯନ୍ତେ? କେନ ୱା ତୁଭ୍ୟମେତାନି ସାମର୍ଥ୍ୟାନି ଦତ୍ତାନି? ");
INSERT INTO sanori_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ତତୋ ଯୀଶୁଃ ପ୍ରତ୍ୟୱଦତ୍, ଅହମପି ଯୁଷ୍ମାନ୍ ୱାଚମେକାଂ ପୃଚ୍ଛାମି, ଯଦି ଯୂଯଂ ତଦୁତ୍ତରଂ ଦାତୁଂ ଶକ୍ଷ୍ୟଥ, ତଦା କେନ ସାମର୍ଥ୍ୟେନ କର୍ମ୍ମାଣ୍ୟେତାନି କରୋମି, ତଦହଂ ଯୁଷ୍ମାନ୍ ୱକ୍ଷ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","ଯୋହନୋ ମଜ୍ଜନଂ କସ୍ୟାଜ୍ଞଯାଭୱତ୍? କିମୀଶ୍ୱରସ୍ୟ ମନୁଷ୍ୟସ୍ୟ ୱା? ତତସ୍ତେ ପରସ୍ପରଂ ୱିୱିଚ୍ୟ କଥଯାମାସୁଃ, ଯଦୀଶ୍ୱରସ୍ୟେତି ୱଦାମସ୍ତର୍ହି ଯୂଯଂ ତଂ କୁତୋ ନ ପ୍ରତ୍ୟୈତ? ୱାଚମେତାଂ ୱକ୍ଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","ମନୁଷ୍ୟସ୍ୟେତି ୱକ୍ତୁମପି ଲୋକେଭ୍ୟୋ ବିଭୀମଃ, ଯତଃ ସର୍ୱ୍ୱୈରପି ଯୋହନ୍ ଭୱିଷ୍ୟଦ୍ୱାଦୀତି ଜ୍ଞାଯତେ| ");
INSERT INTO sanori_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","ତସ୍ମାତ୍ ତେ ଯୀଶୁଂ ପ୍ରତ୍ୟୱଦନ୍, ତଦ୍ ୱଯଂ ନ ୱିଦ୍ମଃ| ତଦା ସ ତାନୁକ୍ତୱାନ୍, ତର୍ହି କେନ ସାମରଥ୍ୟେନ କର୍ମ୍ମାଣ୍ୟେତାନ୍ୟହଂ କରୋମି, ତଦପ୍ୟହଂ ଯୁଷ୍ମାନ୍ ନ ୱକ୍ଷ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","କସ୍ୟଚିଜ୍ଜନସ୍ୟ ଦ୍ୱୌ ସୁତାୱାସ୍ତାଂ ସ ଏକସ୍ୟ ସୁତସ୍ୟ ସମୀପଂ ଗତ୍ୱା ଜଗାଦ, ହେ ସୁତ, ତ୍ୱମଦ୍ୟ ମମ ଦ୍ରାକ୍ଷାକ୍ଷେତ୍ରେ କର୍ମ୍ମ କର୍ତୁଂ ୱ୍ରଜ| ");
INSERT INTO sanori_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ତତଃ ସ ଉକ୍ତୱାନ୍, ନ ଯାସ୍ୟାମି, କିନ୍ତୁ ଶେଷେଽନୁତପ୍ୟ ଜଗାମ| ");
INSERT INTO sanori_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","ଅନନ୍ତରଂ ସୋନ୍ୟସୁତସ୍ୟ ସମୀପଂ ଗତ୍ୱା ତଥୈୱ କଥ୍ତିୱାନ୍; ତତଃ ସ ପ୍ରତ୍ୟୁୱାଚ, ମହେଚ୍ଛ ଯାମି, କିନ୍ତୁ ନ ଗତଃ| ");
INSERT INTO sanori_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","ଏତଯୋଃ ପୁତ୍ରଯୋ ର୍ମଧ୍ୟେ ପିତୁରଭିମତଂ କେନ ପାଲିତଂ? ଯୁଷ୍ମାଭିଃ କିଂ ବୁଧ୍ୟତେ? ତତସ୍ତେ ପ୍ରତ୍ୟୂଚୁଃ, ପ୍ରଥମେନ ପୁुତ୍ରେଣ| ତଦାନୀଂ ଯୀଶୁସ୍ତାନୁୱାଚ, ଅହଂ ଯୁଷ୍ମାନ୍ ତଥ୍ୟଂ ୱଦାମି, ଚଣ୍ଡାଲା ଗଣିକାଶ୍ଚ ଯୁଷ୍ମାକମଗ୍ରତ ଈଶ୍ୱରସ୍ୟ ରାଜ୍ୟଂ ପ୍ରୱିଶନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ଯତୋ ଯୁଷ୍ମାକଂ ସମୀପଂ ଯୋହନି ଧର୍ମ୍ମପଥେନାଗତେ ଯୂଯଂ ତଂ ନ ପ୍ରତୀଥ, କିନ୍ତୁ ଚଣ୍ଡାଲା ଗଣିକାଶ୍ଚ ତଂ ପ୍ରତ୍ୟାଯନ୍, ତଦ୍ ୱିଲୋକ୍ୟାପି ଯୂଯଂ ପ୍ରତ୍ୟେତୁଂ ନାଖିଦ୍ୟଧ୍ୱଂ| ");
INSERT INTO sanori_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","ଅପରମେକଂ ଦୃଷ୍ଟାନ୍ତଂ ଶୃଣୁତ, କଶ୍ଚିଦ୍ ଗୃହସ୍ଥଃ କ୍ଷେତ୍ରେ ଦ୍ରାକ୍ଷାଲତା ରୋପଯିତ୍ୱା ତଚ୍ଚତୁର୍ଦିକ୍ଷୁ ୱାରଣୀଂ ୱିଧାଯ ତନ୍ମଧ୍ୟେ ଦ୍ରାକ୍ଷାଯନ୍ତ୍ରଂ ସ୍ଥାପିତୱାନ୍, ମାଞ୍ଚଞ୍ଚ ନିର୍ମ୍ମିତୱାନ୍, ତତଃ କୃଷକେଷୁ ତତ୍ କ୍ଷେତ୍ରଂ ସମର୍ପ୍ୟ ସ୍ୱଯଂ ଦୂରଦେଶଂ ଜଗାମ| ");
INSERT INTO sanori_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","ତଦନନ୍ତରଂ ଫଲସମଯ ଉପସ୍ଥିତେ ସ ଫଲାନି ପ୍ରାପ୍ତୁଂ କୃଷୀୱଲାନାଂ ସମୀପଂ ନିଜଦାସାନ୍ ପ୍ରେଷଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","କିନ୍ତୁ କୃଷୀୱଲାସ୍ତସ୍ୟ ତାନ୍ ଦାସେଯାନ୍ ଧୃତ୍ୱା କଞ୍ଚନ ପ୍ରହୃତୱନ୍ତଃ, କଞ୍ଚନ ପାଷାଣୈରାହତୱନ୍ତଃ, କଞ୍ଚନ ଚ ହତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","ପୁନରପି ସ ପ୍ରଭୁଃ ପ୍ରଥମତୋଽଧିକଦାସେଯାନ୍ ପ୍ରେଷଯାମାସ, କିନ୍ତୁ ତେ ତାନ୍ ପ୍ରତ୍ୟପି ତଥୈୱ ଚକ୍ରୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","ଅନନ୍ତରଂ ମମ ସୁତେ ଗତେ ତଂ ସମାଦରିଷ୍ୟନ୍ତେ, ଇତ୍ୟୁକ୍ତ୍ୱା ଶେଷେ ସ ନିଜସୁତଂ ତେଷାଂ ସନ୍ନିଧିଂ ପ୍ରେଷଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","କିନ୍ତୁ ତେ କୃଷୀୱଲାଃ ସୁତଂ ୱୀକ୍ଷ୍ୟ ପରସ୍ପରମ୍ ଇତି ମନ୍ତ୍ରଯିତୁମ୍ ଆରେଭିରେ, ଅଯମୁତ୍ତରାଧିକାରୀ ୱଯମେନଂ ନିହତ୍ୟାସ୍ୟାଧିକାରଂ ସ୍ୱୱଶୀକରିଷ୍ୟାମଃ| ");
INSERT INTO sanori_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","ପଶ୍ଚାତ୍ ତେ ତଂ ଧୃତ୍ୱା ଦ୍ରାକ୍ଷାକ୍ଷେତ୍ରାଦ୍ ବହିଃ ପାତଯିତ୍ୱାବଧିଷୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","ଯଦା ସ ଦ୍ରାକ୍ଷାକ୍ଷେତ୍ରପତିରାଗମିଷ୍ୟତି, ତଦା ତାନ୍ କୃଷୀୱଲାନ୍ କିଂ କରିଷ୍ୟତି? ");
INSERT INTO sanori_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ତତସ୍ତେ ପ୍ରତ୍ୟୱଦନ୍, ତାନ୍ କଲୁଷିଣୋ ଦାରୁଣଯାତନାଭିରାହନିଷ୍ୟତି, ଯେ ଚ ସମଯାନୁକ୍ରମାତ୍ ଫଲାନି ଦାସ୍ୟନ୍ତି, ତାଦୃଶେଷୁ କୃଷୀୱଲେଷୁ କ୍ଷେତ୍ରଂ ସମର୍ପଯିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ତଦା ଯୀଶୁନା ତେ ଗଦିତାଃ, ଗ୍ରହଣଂ ନ କୃତଂ ଯସ୍ୟ ପାଷାଣସ୍ୟ ନିଚାଯକୈଃ| ପ୍ରଧାନପ୍ରସ୍ତରଃ କୋଣେ ସଏୱ ସଂଭୱିଷ୍ୟତି| ଏତତ୍ ପରେଶିତୁଃ କର୍ମ୍ମାସ୍ମଦୃଷ୍ଟାୱଦ୍ଭୁତଂ ଭୱେତ୍| ଧର୍ମ୍ମଗ୍ରନ୍ଥେ ଲିଖିତମେତଦ୍ୱଚନଂ ଯୁଷ୍ମାଭିଃ କିଂ ନାପାଠି? ");
INSERT INTO sanori_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","ତସ୍ମାଦହଂ ଯୁଷ୍ମାନ୍ ୱଦାମି, ଯୁଷ୍ମତ୍ତ ଈଶ୍ୱରୀଯରାଜ୍ୟମପନୀଯ ଫଲୋତ୍ପାଦଯିତ୍ରନ୍ୟଜାତଯେ ଦାଯିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","ଯୋ ଜନ ଏତତ୍ପାଷାଣୋପରି ପତିଷ୍ୟତି, ତଂ ସ ଭଂକ୍ଷ୍ୟତେ, କିନ୍ତ୍ୱଯଂ ପାଷାଣୋ ଯସ୍ୟୋପରି ପତିଷ୍ୟତି, ତଂ ସ ଧୂଲିୱତ୍ ଚୂର୍ଣୀକରିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","ତଦାନୀଂ ପ୍ରାଧନଯାଜକାଃ ଫିରୂଶିନଶ୍ଚ ତସ୍ୟେମାଂ ଦୃଷ୍ଟାନ୍ତକଥାଂ ଶ୍ରୁତ୍ୱା ସୋଽସ୍ମାନୁଦ୍ଦିଶ୍ୟ କଥିତୱାନ୍, ଇତି ୱିଜ୍ଞାଯ ତଂ ଧର୍ତ୍ତୁଂ ଚେଷ୍ଟିତୱନ୍ତଃ; ");
INSERT INTO sanori_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","କିନ୍ତୁ ଲୋକେଭ୍ୟୋ ବିଭ୍ୟୁଃ, ଯତୋ ଲୋକୈଃ ସ ଭୱିଷ୍ୟଦ୍ୱାଦୀତ୍ୟଜ୍ଞାଯି| ");
INSERT INTO sanori_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","ଅନନ୍ତରଂ ଯୀଶୁଃ ପୁନରପି ଦୃଷ୍ଟାନ୍ତେନ ତାନ୍ ଅୱାଦୀତ୍, ");
INSERT INTO sanori_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","ସ୍ୱର୍ଗୀଯରାଜ୍ୟମ୍ ଏତାଦୃଶସ୍ୟ ନୃପତେଃ ସମଂ, ଯୋ ନିଜ ପୁତ୍ରଂ ୱିୱାହଯନ୍ ସର୍ୱ୍ୱାନ୍ ନିମନ୍ତ୍ରିତାନ୍ ଆନେତୁଂ ଦାସେଯାନ୍ ପ୍ରହିତୱାନ୍, ");
INSERT INTO sanori_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","କିନ୍ତୁ ତେ ସମାଗନ୍ତୁଂ ନେଷ୍ଟୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ତତୋ ରାଜା ପୁନରପି ଦାସାନନ୍ୟାନ୍ ଇତ୍ୟୁକ୍ତ୍ୱା ପ୍ରେଷଯାମାସ, ନିମନ୍ତ୍ରିତାନ୍ ୱଦତ, ପଶ୍ୟତ, ମମ ଭେଜ୍ୟମାସାଦିତମାସ୍ତେ, ନିଜୱ୍ଟଷାଦିପୁଷ୍ଟଜନ୍ତୂନ୍ ମାରଯିତ୍ୱା ସର୍ୱ୍ୱଂ ଖାଦ୍ୟଦ୍ରୱ୍ୟମାସାଦିତୱାନ୍, ଯୂଯଂ ୱିୱାହମାଗଚ୍ଛତ| ");
INSERT INTO sanori_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","ତଥପି ତେ ତୁଚ୍ଛୀକୃତ୍ୟ କେଚିତ୍ ନିଜକ୍ଷେତ୍ରଂ କେଚିଦ୍ ୱାଣିଜ୍ୟଂ ପ୍ରତି ସ୍ୱସ୍ୱମାର୍ଗେଣ ଚଲିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ଅନ୍ୟେ ଲୋକାସ୍ତସ୍ୟ ଦାସେଯାନ୍ ଧୃତ୍ୱା ଦୌରାତ୍ମ୍ୟଂ ୱ୍ୟୱହୃତ୍ୟ ତାନୱଧିଷୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","ଅନନ୍ତରଂ ସ ନୃପତିସ୍ତାଂ ୱାର୍ତ୍ତାଂ ଶ୍ରୁତ୍ୱା କ୍ରୁଧ୍ୟନ୍ ସୈନ୍ୟାନି ପ୍ରହିତ୍ୟ ତାନ୍ ଘାତକାନ୍ ହତ୍ୱା ତେଷାଂ ନଗରଂ ଦାହଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","ତତଃ ସ ନିଜଦାସେଯାନ୍ ବଭାଷେ, ୱିୱାହୀଯଂ ଭୋଜ୍ୟମାସାଦିତମାସ୍ତେ, କିନ୍ତୁ ନିମନ୍ତ୍ରିତା ଜନା ଅଯୋଗ୍ୟାଃ| ");
INSERT INTO sanori_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ତସ୍ମାଦ୍ ଯୂଯଂ ରାଜମାର୍ଗଂ ଗତ୍ୱା ଯାୱତୋ ମନୁଜାନ୍ ପଶ୍ୟତ, ତାୱତଏୱ ୱିୱାହୀଯଭୋଜ୍ୟାଯ ନିମନ୍ତ୍ରଯତ| ");
INSERT INTO sanori_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","ତଦା ତେ ଦାସେଯା ରାଜମାର୍ଗଂ ଗତ୍ୱା ଭଦ୍ରାନ୍ ଅଭଦ୍ରାନ୍ ୱା ଯାୱତୋ ଜନାନ୍ ଦଦୃଶୁଃ, ତାୱତଏୱ ସଂଗୃହ୍ୟାନଯନ୍; ତତୋଽଭ୍ୟାଗତମନୁଜୈ ର୍ୱିୱାହଗୃହମ୍ ଅପୂର୍ୟ୍ୟତ| ");
INSERT INTO sanori_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","ତଦାନୀଂ ସ ରାଜା ସର୍ୱ୍ୱାନଭ୍ୟାଗତାନ୍ ଦ୍ରଷ୍ଟୁମ୍ ଅଭ୍ୟନ୍ତରମାଗତୱାନ୍; ତଦା ତତ୍ର ୱିୱାହୀଯୱସନହୀନମେକଂ ଜନଂ ୱୀକ୍ଷ୍ୟ ତଂ ଜଗାଦ୍, ");
INSERT INTO sanori_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ହେ ମିତ୍ର,ତ୍ୱଂ ୱିୱାହୀଯୱସନଂ ୱିନା କଥମତ୍ର ପ୍ରୱିଷ୍ଟୱାନ୍? ତେନ ସ ନିରୁତ୍ତରୋ ବଭୂୱ| ");
INSERT INTO sanori_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","ତଦା ରାଜା ନିଜାନୁଚରାନ୍ ଅୱଦତ୍, ଏତସ୍ୟ କରଚରଣାନ୍ ବଦ୍ଧା ଯତ୍ର ରୋଦନଂ ଦନ୍ତୈର୍ଦନ୍ତଘର୍ଷଣଞ୍ଚ ଭୱତି, ତତ୍ର ୱହିର୍ଭୂତତମିସ୍ରେ ତଂ ନିକ୍ଷିପତ| ");
INSERT INTO sanori_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","ଇତ୍ଥଂ ବହୱ ଆହୂତା ଅଲ୍ପେ ମନୋଭିମତାଃ| ");
INSERT INTO sanori_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","ଅନନ୍ତରଂ ଫିରୂଶିନଃ ପ୍ରଗତ୍ୟ ଯଥା ସଂଲାପେନ ତମ୍ ଉନ୍ମାଥେ ପାତଯେଯୁସ୍ତଥା ମନ୍ତ୍ରଯିତ୍ୱା ");
INSERT INTO sanori_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ହେରୋଦୀଯମନୁଜୈଃ ସାକଂ ନିଜଶିଷ୍ୟଗଣେନ ତଂ ପ୍ରତି କଥଯାମାସୁଃ, ହେ ଗୁରୋ, ଭୱାନ୍ ସତ୍ୟଃ ସତ୍ୟମୀଶ୍ୱରୀଯମାର୍ଗମୁପଦିଶତି, କମପି ମାନୁଷଂ ନାନୁରୁଧ୍ୟତେ, କମପି ନାପେକ୍ଷତେ ଚ, ତଦ୍ ୱଯଂ ଜାନୀମଃ| ");
INSERT INTO sanori_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","ଅତଃ କୈସରଭୂପାଯ କରୋଽସ୍ମାକଂ ଦାତୱ୍ୟୋ ନ ୱା? ଅତ୍ର ଭୱତା କିଂ ବୁଧ୍ୟତେ? ତଦ୍ ଅସ୍ମାନ୍ ୱଦତୁ| ");
INSERT INTO sanori_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ତତୋ ଯୀଶୁସ୍ତେଷାଂ ଖଲତାଂ ୱିଜ୍ଞାଯ କଥିତୱାନ୍, ରେ କପଟିନଃ ଯୁଯଂ କୁତୋ ମାଂ ପରିକ୍ଷଧ୍ୱେ? ");
INSERT INTO sanori_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","ତତ୍କରଦାନସ୍ୟ ମୁଦ୍ରାଂ ମାଂ ଦର୍ଶଯତ| ତଦାନୀଂ ତୈସ୍ତସ୍ୟ ସମୀପଂ ମୁଦ୍ରାଚତୁର୍ଥଭାଗ ଆନୀତେ ");
INSERT INTO sanori_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ସ ତାନ୍ ପପ୍ରଚ୍ଛ, ଅତ୍ର କସ୍ୟେଯଂ ମୂର୍ତ୍ତି ର୍ନାମ ଚାସ୍ତେ? ତେ ଜଗଦୁଃ, କୈସରଭୂପସ୍ୟ| ");
INSERT INTO sanori_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ତତଃ ସ ଉକ୍ତୱାନ, କୈସରସ୍ୟ ଯତ୍ ତତ୍ କୈସରାଯ ଦତ୍ତ, ଈଶ୍ୱରସ୍ୟ ଯତ୍ ତଦ୍ ଈଶ୍ୱରାଯ ଦତ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ଇତି ୱାକ୍ୟଂ ନିଶମ୍ୟ ତେ ୱିସ୍ମଯଂ ୱିଜ୍ଞାଯ ତଂ ୱିହାଯ ଚଲିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","ତସ୍ମିନ୍ନହନି ସିଦୂକିନୋଽର୍ଥାତ୍ ଶ୍ମଶାନାତ୍ ନୋତ୍ଥାସ୍ୟନ୍ତୀତି ୱାକ୍ୟଂ ଯେ ୱଦନ୍ତି, ତେ ଯୀଶେाରନ୍ତିକମ୍ ଆଗତ୍ୟ ପପ୍ରଚ୍ଛୁଃ, ");
INSERT INTO sanori_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ହେ ଗୁରୋ, କଶ୍ଚିନ୍ମନୁଜଶ୍ଚେତ୍ ନିଃସନ୍ତାନଃ ସନ୍ ପ୍ରାଣାନ୍ ତ୍ୟଜତି, ତର୍ହି ତସ୍ୟ ଭ୍ରାତା ତସ୍ୟ ଜାଯାଂ ୱ୍ୟୁହ୍ୟ ଭ୍ରାତୁଃ ସନ୍ତାନମ୍ ଉତ୍ପାଦଯିଷ୍ୟତୀତି ମୂସା ଆଦିଷ୍ଟୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","କିନ୍ତ୍ୱସ୍ମାକମତ୍ର କେଽପି ଜନାଃ ସପ୍ତସହୋଦରା ଆସନ୍, ତେଷାଂ ଜ୍ୟେଷ୍ଠ ଏକାଂ କନ୍ୟାଂ ୱ୍ୟୱହାତ୍, ଅପରଂ ପ୍ରାଣତ୍ୟାଗକାଲେ ସ୍ୱଯଂ ନିଃସନ୍ତାନଃ ସନ୍ ତାଂ ସ୍ତ୍ରିଯଂ ସ୍ୱଭ୍ରାତରି ସମର୍ପିତୱାନ୍, ");
INSERT INTO sanori_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ତତୋ ଦ୍ୱିତୀଯାଦିସପ୍ତମାନ୍ତାଶ୍ଚ ତଥୈୱ ଚକ୍ରୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ଶେଷେ ସାପୀ ନାରୀ ମମାର| ");
INSERT INTO sanori_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","ମୃତାନାମ୍ ଉତ୍ଥାନସମଯେ ତେଷାଂ ସପ୍ତାନାଂ ମଧ୍ୟେ ସା ନାରୀ କସ୍ୟ ଭାର୍ୟ୍ୟା ଭୱିଷ୍ୟତି? ଯସ୍ମାତ୍ ସର୍ୱ୍ୱଏୱ ତାଂ ୱ୍ୟୱହନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ତତୋ ଯୀଶୁଃ ପ୍ରତ୍ୟୱାଦୀତ୍, ଯୂଯଂ ଧର୍ମ୍ମପୁସ୍ତକମ୍ ଈଶ୍ୱରୀଯାଂ ଶକ୍ତିଞ୍ଚ ନ ୱିଜ୍ଞାଯ ଭ୍ରାନ୍ତିମନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","ଉତ୍ଥାନପ୍ରାପ୍ତା ଲୋକା ନ ୱିୱହନ୍ତି, ନ ଚ ୱାଚା ଦୀଯନ୍ତେ, କିନ୍ତ୍ୱୀଶ୍ୱରସ୍ୟ ସ୍ୱର୍ଗସ୍ଥଦୂତାନାଂ ସଦୃଶା ଭୱନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","ଅପରଂ ମୃତାନାମୁତ୍ଥାନମଧି ଯୁଷ୍ମାନ୍ ପ୍ରତୀଯମୀଶ୍ୱରୋକ୍ତିଃ, ");
INSERT INTO sanori_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","\"ଅହମିବ୍ରାହୀମ ଈଶ୍ୱର ଇସ୍ହାକ ଈଶ୍ୱରୋ ଯାକୂବ ଈଶ୍ୱର\" ଇତି କିଂ ଯୁଷ୍ମାଭି ର୍ନାପାଠି? କିନ୍ତ୍ୱୀଶ୍ୱରୋ ଜୀୱତାମ୍ ଈଶ୍ୱର:, ସ ମୃତାନାମୀଶ୍ୱରୋ ନହି| ");
INSERT INTO sanori_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ଇତି ଶ୍ରୁତ୍ୱା ସର୍ୱ୍ୱେ ଲୋକାସ୍ତସ୍ୟୋପଦେଶାଦ୍ ୱିସ୍ମଯଂ ଗତାଃ| ");
INSERT INTO sanori_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","ଅନନ୍ତରଂ ସିଦୂକିନାମ୍ ନିରୁତ୍ତରତ୍ୱୱାର୍ତାଂ ନିଶମ୍ୟ ଫିରୂଶିନ ଏକତ୍ର ମିଲିତୱନ୍ତଃ, ");
INSERT INTO sanori_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ତେଷାମେକୋ ୱ୍ୟୱସ୍ଥାପକୋ ଯୀଶୁଂ ପରୀକ୍ଷିତୁଂ ପପଚ୍ଛ, ");
INSERT INTO sanori_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","ହେ ଗୁରୋ ୱ୍ୟୱସ୍ଥାଶାସ୍ତ୍ରମଧ୍ୟେ କାଜ୍ଞା ଶ୍ରେଷ୍ଠା? ");
INSERT INTO sanori_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ତତୋ ଯୀଶୁରୁୱାଚ, ତ୍ୱଂ ସର୍ୱ୍ୱାନ୍ତଃକରଣୈଃ ସର୍ୱ୍ୱପ୍ରାଣୈଃ ସର୍ୱ୍ୱଚିତ୍ତୈଶ୍ଚ ସାକଂ ପ୍ରଭୌ ପରମେଶ୍ୱରେ ପ୍ରୀଯସ୍ୱ, ");
INSERT INTO sanori_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ଏଷା ପ୍ରଥମମହାଜ୍ଞା| ତସ୍ୟାଃ ସଦୃଶୀ ଦ୍ୱିତୀଯାଜ୍ଞୈଷା, ");
INSERT INTO sanori_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ତୱ ସମୀପୱାସିନି ସ୍ୱାତ୍ମନୀୱ ପ୍ରେମ କୁରୁ| ");
INSERT INTO sanori_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","ଅନଯୋ ର୍ଦ୍ୱଯୋରାଜ୍ଞଯୋଃ କୃତ୍ସ୍ନୱ୍ୟୱସ୍ଥାଯା ଭୱିଷ୍ୟଦ୍ୱକ୍ତୃଗ୍ରନ୍ଥସ୍ୟ ଚ ଭାରସ୍ତିଷ୍ଠତି| ");
INSERT INTO sanori_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ଅନନ୍ତରଂ ଫିରୂଶିନାମ୍ ଏକତ୍ର ସ୍ଥିତିକାଲେ ଯୀଶୁସ୍ତାନ୍ ପପ୍ରଚ୍ଛ, ");
INSERT INTO sanori_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","ଖ୍ରୀଷ୍ଟମଧି ଯୁଷ୍ମାକଂ କୀଦୃଗ୍ବୋଧୋ ଜାଯତେ? ସ କସ୍ୟ ସନ୍ତାନଃ? ତତସ୍ତେ ପ୍ରତ୍ୟୱଦନ୍, ଦାଯୂଦଃ ସନ୍ତାନଃ| ");
INSERT INTO sanori_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","ତଦା ସ ଉକ୍ତୱାନ୍, ତର୍ହି ଦାଯୂଦ୍ କଥମ୍ ଆତ୍ମାଧିଷ୍ଠାନେନ ତଂ ପ୍ରଭୁଂ ୱଦତି ? ");
INSERT INTO sanori_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","ଯଥା ମମ ପ୍ରଭୁମିଦଂ ୱାକ୍ୟମୱଦତ୍ ପରମେଶ୍ୱରଃ| ତୱାରୀନ୍ ପାଦପୀଠଂ ତେ ଯାୱନ୍ନହି କରୋମ୍ୟହଂ| ତାୱତ୍ କାଲଂ ମଦୀଯେ ତ୍ୱଂ ଦକ୍ଷପାର୍ଶ୍ୱ ଉପାୱିଶ| ଅତୋ ଯଦି ଦାଯୂଦ୍ ତଂ ପ୍ରଭୁଂ ୱଦତି, ର୍ତିହ ସ କଥଂ ତସ୍ୟ ସନ୍ତାନୋ ଭୱତି? ");
INSERT INTO sanori_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","ତଦାନୀଂ ତେଷାଂ କୋପି ତଦ୍ୱାକ୍ୟସ୍ୟ କିମପ୍ୟୁତ୍ତରଂ ଦାତୁଂ ନାଶକ୍ନୋତ୍; ");
INSERT INTO sanori_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ତଦ୍ଦିନମାରଭ୍ୟ ତଂ କିମପି ୱାକ୍ୟଂ ପ୍ରଷ୍ଟୁଂ କସ୍ୟାପି ସାହସୋ ନାଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","ଅନନ୍ତରଂ ଯୀଶୁ ର୍ଜନନିୱହଂ ଶିଷ୍ୟାଂଶ୍ଚାୱଦତ୍, ");
INSERT INTO sanori_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","ଅଧ୍ୟାପକାଃ ଫିରୂଶିନଶ୍ଚ ମୂସାସନେ ଉପୱିଶନ୍ତି, ");
INSERT INTO sanori_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ଅତସ୍ତେ ଯୁଷ୍ମାନ୍ ଯଦ୍ୟତ୍ ମନ୍ତୁମ୍ ଆଜ୍ଞାପଯନ୍ତି, ତତ୍ ମନ୍ୟଧ୍ୱଂ ପାଲଯଧ୍ୱଞ୍ଚ, କିନ୍ତୁ ତେଷାଂ କର୍ମ୍ମାନୁରୂପଂ କର୍ମ୍ମ ନ କୁରୁଧ୍ୱଂ; ଯତସ୍ତେଷାଂ ୱାକ୍ୟମାତ୍ରଂ ସାରଂ କାର୍ୟ୍ୟେ କିମପି ନାସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","ତେ ଦୁର୍ୱ୍ୱହାନ୍ ଗୁରୁତରାନ୍ ଭାରାନ୍ ବଦ୍ୱ୍ୱା ମନୁଷ୍ୟାଣାଂ ସ୍କନ୍ଧେପରି ସମର୍ପଯନ୍ତି, କିନ୍ତୁ ସ୍ୱଯମଙ୍ଗୁଲ୍ୟୈକଯାପି ନ ଚାଲଯନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","କେୱଲଂ ଲୋକଦର୍ଶନାଯ ସର୍ୱ୍ୱକର୍ମ୍ମାଣି କୁର୍ୱ୍ୱନ୍ତି; ଫଲତଃ ପଟ୍ଟବନ୍ଧାନ୍ ପ୍ରସାର୍ୟ୍ୟ ଧାରଯନ୍ତି, ସ୍ୱୱସ୍ତ୍ରେଷୁ ଚ ଦୀର୍ଘଗ୍ରନ୍ଥୀନ୍ ଧାରଯନ୍ତି; ");
INSERT INTO sanori_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ଭୋଜନଭୱନ ଉଚ୍ଚସ୍ଥାନଂ, ଭଜନଭୱନେ ପ୍ରଧାନମାସନଂ, ");
INSERT INTO sanori_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ହଟ୍ଠେ ନମସ୍କାରଂ ଗୁରୁରିତି ସମ୍ବୋଧନଞ୍ଚୈତାନି ସର୍ୱ୍ୱାଣି ୱାଞ୍ଛନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","କିନ୍ତୁ ଯୂଯଂ ଗୁରୱ ଇତି ସମ୍ବୋଧନୀଯା ମା ଭୱତ, ଯତୋ ଯୁଷ୍ମାକମ୍ ଏକଃ ଖ୍ରୀଷ୍ଟଏୱ ଗୁରୁ ");
INSERT INTO sanori_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ର୍ୟୂଯଂ ସର୍ୱ୍ୱେ ମିଥୋ ଭ୍ରାତରଶ୍ଚ| ପୁନଃ ପୃଥିୱ୍ୟାଂ କମପି ପିତେତି ମା ସମ୍ବୁଧ୍ୟଧ୍ୱଂ, ଯତୋ ଯୁଷ୍ମାକମେକଃ ସ୍ୱର୍ଗସ୍ଥଏୱ ପିତା| ");
INSERT INTO sanori_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ଯୂଯଂ ନାଯକେତି ସମ୍ଭାଷିତା ମା ଭୱତ, ଯତୋ ଯୁଷ୍ମାକମେକଃ ଖ୍ରୀଷ୍ଟଏୱ ନାଯକଃ| ");
INSERT INTO sanori_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","ଅପରଂ ଯୁଷ୍ମାକଂ ମଧ୍ୟେ ଯଃ ପୁମାନ୍ ଶ୍ରେଷ୍ଠଃ ସ ଯୁଷ୍ମାନ୍ ସେୱିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ଯତୋ ଯଃ ସ୍ୱମୁନ୍ନମତି, ସ ନତଃ କରିଷ୍ୟତେ; କିନ୍ତୁ ଯଃ କଶ୍ଚିତ୍ ସ୍ୱମୱନତଂ କରୋତି, ସ ଉନ୍ନତଃ କରିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","ହନ୍ତ କପଟିନ ଉପାଧ୍ୟାଯାଃ ଫିରୂଶିନଶ୍ଚ, ଯୂଯଂ ମନୁଜାନାଂ ସମକ୍ଷଂ ସ୍ୱର୍ଗଦ୍ୱାରଂ ରୁନ୍ଧ, ଯୂଯଂ ସ୍ୱଯଂ ତେନ ନ ପ୍ରୱିଶଥ, ପ୍ରୱିୱିକ୍ଷୂନପି ୱାରଯଥ| ୱତ କପଟିନ ଉପାଧ୍ୟାଯାଃ ଫିରୂଶିନଶ୍ଚ ଯୂଯଂ ଛଲାଦ୍ ଦୀର୍ଘଂ ପ୍ରାର୍ଥ୍ୟ ୱିଧୱାନାଂ ସର୍ୱ୍ୱସ୍ୱଂ ଗ୍ରସଥ, ଯୁଷ୍ମାକଂ ଘୋରତରଦଣ୍ଡୋ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","ହନ୍ତ କପଟିନ ଉପାଧ୍ୟାଯାଃ ଫିରୂଶିନଶ୍ଚ, ଯୂଯମେକଂ ସ୍ୱଧର୍ମ୍ମାୱଲମ୍ବିନଂ କର୍ତ୍ତୁଂ ସାଗରଂ ଭୂମଣ୍ଡଲଞ୍ଚ ପ୍ରଦକ୍ଷିଣୀକୁରୁଥ, ");
INSERT INTO sanori_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","କଞ୍ଚନ ପ୍ରାପ୍ୟ ସ୍ୱତୋ ଦ୍ୱିଗୁଣନରକଭାଜନଂ ତଂ କୁରୁଥ| ");
INSERT INTO sanori_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","ୱତ ଅନ୍ଧପଥଦର୍ଶକାଃ ସର୍ୱ୍ୱେ, ଯୂଯଂ ୱଦଥ, ମନ୍ଦିରସ୍ୟ ଶପଥକରଣାତ୍ କିମପି ନ ଦେଯଂ; କିନ୍ତୁ ମନ୍ଦିରସ୍ଥସୁୱର୍ଣସ୍ୟ ଶପଥକରଣାଦ୍ ଦେଯଂ| ");
INSERT INTO sanori_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ହେ ମୂଢା ହେ ଅନ୍ଧାଃ ସୁୱର୍ଣଂ ତତ୍ସୁୱର୍ଣପାୱକମନ୍ଦିରମ୍ ଏତଯୋରୁଭଯୋ ର୍ମଧ୍ୟେ କିଂ ଶ୍ରେଯଃ? ");
INSERT INTO sanori_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","ଅନ୍ୟଚ୍ଚ ୱଦଥ, ଯଜ୍ଞୱେଦ୍ୟାଃ ଶପଥକରଣାତ୍ କିମପି ନ ଦେଯଂ, କିନ୍ତୁ ତଦୁପରିସ୍ଥିତସ୍ୟ ନୈୱେଦ୍ୟସ୍ୟ ଶପଥକରଣାଦ୍ ଦେଯଂ| ");
INSERT INTO sanori_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ହେ ମୂଢା ହେ ଅନ୍ଧାଃ, ନୈୱେଦ୍ୟଂ ତନ୍ନୈୱେଦ୍ୟପାୱକୱେଦିରେତଯୋରୁଭଯୋ ର୍ମଧ୍ୟେ କିଂ ଶ୍ରେଯଃ? ");
INSERT INTO sanori_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ଅତଃ କେନଚିଦ୍ ଯଜ୍ଞୱେଦ୍ୟାଃ ଶପଥେ କୃତେ ତଦୁପରିସ୍ଥସ୍ୟ ସର୍ୱ୍ୱସ୍ୟ ଶପଥଃ କ୍ରିଯତେ| ");
INSERT INTO sanori_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","କେନଚିତ୍ ମନ୍ଦିରସ୍ୟ ଶପଥେ କୃତେ ମନ୍ଦିରତନ୍ନିୱାସିନୋଃ ଶପଥଃ କ୍ରିଯତେ| ");
INSERT INTO sanori_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","କେନଚିତ୍ ସ୍ୱର୍ଗସ୍ୟ ଶପଥେ କୃତେ ଈଶ୍ୱରୀଯସିଂହାସନତଦୁପର୍ୟ୍ୟୁପୱିଷ୍ଟଯୋଃ ଶପଥଃ କ୍ରିଯତେ| ");
INSERT INTO sanori_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","ହନ୍ତ କପଟିନ ଉପାଧ୍ୟାଯାଃ ଫିରୂଶିନଶ୍ଚ, ଯୂଯଂ ପୋଦିନାଯାଃ ସିତଚ୍ଛତ୍ରାଯା ଜୀରକସ୍ୟ ଚ ଦଶମାଂଶାନ୍ ଦତ୍ଥ, କିନ୍ତୁ ୱ୍ୟୱସ୍ଥାଯା ଗୁରୁତରାନ୍ ନ୍ୟାଯଦଯାୱିଶ୍ୱାସାନ୍ ପରିତ୍ୟଜଥ; ଇମେ ଯୁଷ୍ମାଭିରାଚରଣୀଯା ଅମୀ ଚ ନ ଲଂଘନୀଯାଃ| ");
INSERT INTO sanori_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ହେ ଅନ୍ଧପଥଦର୍ଶକା ଯୂଯଂ ମଶକାନ୍ ଅପସାରଯଥ, କିନ୍ତୁ ମହାଙ୍ଗାନ୍ ଗ୍ରସଥ| ");
INSERT INTO sanori_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","ହନ୍ତ କପଟିନ ଉପାଧ୍ୟାଯାଃ ଫିରୂଶିନଶ୍ଚ, ଯୂଯଂ ପାନପାତ୍ରାଣାଂ ଭୋଜନପାତ୍ରାଣାଞ୍ଚ ବହିଃ ପରିଷ୍କୁରୁଥ; କିନ୍ତୁ ତଦଭ୍ୟନ୍ତରଂ ଦୁରାତ୍ମତଯା କଲୁଷେଣ ଚ ପରିପୂର୍ଣମାସ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ହେ ଅନ୍ଧାଃ ଫିରୂଶିଲୋକା ଆଦୌ ପାନପାତ୍ରାଣାଂ ଭୋଜନପାତ୍ରାଣାଞ୍ଚାଭ୍ୟନ୍ତରଂ ପରିଷ୍କୁରୁତ, ତେନ ତେଷାଂ ବହିରପି ପରିଷ୍କାରିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","ହନ୍ତ କପଟିନ ଉପାଧ୍ୟାଯାଃ ଫିରୂଶିନଶ୍ଚ, ଯୂଯଂ ଶୁକ୍ଲୀକୃତଶ୍ମଶାନସ୍ୱରୂପା ଭୱଥ, ଯଥା ଶ୍ମଶାନଭୱନସ୍ୟ ବହିଶ୍ଚାରୁ, କିନ୍ତ୍ୱଭ୍ୟନ୍ତରଂ ମୃତଲୋକାନାଂ କୀକଶୈଃ ସର୍ୱ୍ୱପ୍ରକାରମଲେନ ଚ ପରିପୂର୍ଣମ୍; ");
INSERT INTO sanori_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","ତଥୈୱ ଯୂଯମପି ଲୋକାନାଂ ସମକ୍ଷଂ ବହିର୍ଧାର୍ମ୍ମିକାଃ କିନ୍ତ୍ୱନ୍ତଃକରଣେଷୁ କେୱଲକାପଟ୍ୟାଧର୍ମ୍ମାଭ୍ୟାଂ ପରିପୂର୍ଣାଃ| ");
INSERT INTO sanori_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","ହା ହା କପଟିନ ଉପାଧ୍ୟାଯାଃ ଫିରୂଶିନଶ୍ଚ, ଯୂଯଂ ଭୱିଷ୍ୟଦ୍ୱାଦିନାଂ ଶ୍ମଶାନଗେହଂ ନିର୍ମ୍ମାଥ, ସାଧୂନାଂ ଶ୍ମଶାନନିକେତନଂ ଶୋଭଯଥ ");
INSERT INTO sanori_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ୱଦଥ ଚ ଯଦି ୱଯଂ ସ୍ୱେଷାଂ ପୂର୍ୱ୍ୱପୁରୁଷାଣାଂ କାଲ ଅସ୍ଥାସ୍ୟାମ, ତର୍ହି ଭୱିଷ୍ୟଦ୍ୱାଦିନାଂ ଶୋଣିତପାତନେ ତେଷାଂ ସହଭାଗିନୋ ନାଭୱିଷ୍ୟାମ| ");
INSERT INTO sanori_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ଅତୋ ଯୂଯଂ ଭୱିଷ୍ୟଦ୍ୱାଦିଘାତକାନାଂ ସନ୍ତାନା ଇତି ସ୍ୱଯମେୱ ସ୍ୱେଷାଂ ସାକ୍ଷ୍ୟଂ ଦତ୍ଥ| ");
INSERT INTO sanori_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","ଅତୋ ଯୂଯଂ ନିଜପୂର୍ୱ୍ୱପୁରୁଷାଣାଂ ପରିମାଣପାତ୍ରଂ ପରିପୂରଯତ| ");
INSERT INTO sanori_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","ରେ ଭୁଜଗାଃ କୃଷ୍ଣଭୁଜଗୱଂଶାଃ, ଯୂଯଂ କଥଂ ନରକଦଣ୍ଡାଦ୍ ରକ୍ଷିଷ୍ୟଧ୍ୱେ| ");
INSERT INTO sanori_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","ପଶ୍ୟତ, ଯୁଷ୍ମାକମନ୍ତିକମ୍ ଅହଂ ଭୱିଷ୍ୟଦ୍ୱାଦିନୋ ବୁଦ୍ଧିମତ ଉପାଧ୍ୟାଯାଂଶ୍ଚ ପ୍ରେଷଯିଷ୍ୟାମି, କିନ୍ତୁ ତେଷାଂ କତିପଯା ଯୁଷ୍ମାଭି ର୍ଘାନିଷ୍ୟନ୍ତେ, କ୍ରୁଶେ ଚ ଘାନିଷ୍ୟନ୍ତେ, କେଚିଦ୍ ଭଜନଭୱନେ କଷାଭିରାଘାନିଷ୍ୟନ୍ତେ, ନଗରେ ନଗରେ ତାଡିଷ୍ୟନ୍ତେ ଚ; ");
INSERT INTO sanori_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","ତେନ ସତ୍ପୁରୁଷସ୍ୟ ହାବିଲୋ ରକ୍ତପାତମାରଭ୍ୟ ବେରିଖିଯଃ ପୁତ୍ରଂ ଯଂ ସିଖରିଯଂ ଯୂଯଂ ମନ୍ଦିରଯଜ୍ଞୱେଦ୍ୟୋ ର୍ମଧ୍ୟେ ହତୱନ୍ତଃ, ତଦୀଯଶୋଣିତପାତଂ ଯାୱଦ୍ ଅସ୍ମିନ୍ ଦେଶେ ଯାୱତାଂ ସାଧୁପୁରୁଷାଣାଂ ଶୋଣିତପାତୋ ଽଭୱତ୍ ତତ୍ ସର୍ୱ୍ୱେଷାମାଗସାଂ ଦଣ୍ଡା ଯୁଷ୍ମାସୁ ୱର୍ତ୍ତିଷ୍ୟନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ଅହଂ ଯୁଷ୍ମାନ୍ତ ତଥ୍ୟଂ ୱଦାମି, ୱିଦ୍ୟମାନେଽସ୍ମିନ୍ ପୁରୁଷେ ସର୍ୱ୍ୱେ ୱର୍ତ୍ତିଷ୍ୟନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","ହେ ଯିରୂଶାଲମ୍ ହେ ଯିରୂଶାଲମ୍ ନଗରି ତ୍ୱଂ ଭୱିଷ୍ୟଦ୍ୱାଦିନୋ ହତୱତୀ, ତୱ ସମୀପଂ ପ୍ରେରିତାଂଶ୍ଚ ପାଷାଣୈରାହତୱତୀ, ଯଥା କୁକ୍କୁଟୀ ଶାୱକାନ୍ ପକ୍ଷାଧଃ ସଂଗୃହ୍ଲାତି, ତଥା ତୱ ସନ୍ତାନାନ୍ ସଂଗ୍ରହୀତୁଂ ଅହଂ ବହୁୱାରମ୍ ଐଚ୍ଛଂ; କିନ୍ତୁ ତ୍ୱଂ ନ ସମମନ୍ୟଥାଃ| ");
INSERT INTO sanori_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ପଶ୍ୟତ ଯଷ୍ମାକଂ ୱାସସ୍ଥାନମ୍ ଉଚ୍ଛିନ୍ନଂ ତ୍ୟକ୍ଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ଅହଂ ଯୁଷ୍ମାନ୍ ତଥ୍ୟଂ ୱଦାମି, ଯଃ ପରମେଶ୍ୱରସ୍ୟ ନାମ୍ନାଗଚ୍ଛତି, ସ ଧନ୍ୟ ଇତି ୱାଣୀଂ ଯାୱନ୍ନ ୱଦିଷ୍ୟଥ, ତାୱତ୍ ମାଂ ପୁନ ର୍ନ ଦ୍ରକ୍ଷ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","ଅନନ୍ତରଂ ଯୀଶୁ ର୍ୟଦା ମନ୍ଦିରାଦ୍ ବହି ର୍ଗଚ୍ଛତି, ତଦାନୀଂ ଶିଷ୍ୟାସ୍ତଂ ମନ୍ଦିରନିର୍ମ୍ମାଣଂ ଦର୍ଶଯିତୁମାଗତାଃ| ");
INSERT INTO sanori_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ତତୋ ଯୀଶୁସ୍ତାନୁୱାଚ, ଯୂଯଂ କିମେତାନି ନ ପଶ୍ୟଥ? ଯୁଷ୍ମାନହଂ ସତ୍ୟଂ ୱଦାମି, ଏତନ୍ନିଚଯନସ୍ୟ ପାଷାଣୈକମପ୍ୟନ୍ୟପାଷାଣେाପରି ନ ସ୍ଥାସ୍ୟତି ସର୍ୱ୍ୱାଣି ଭୂମିସାତ୍ କାରିଷ୍ୟନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","ଅନନ୍ତରଂ ତସ୍ମିନ୍ ଜୈତୁନପର୍ୱ୍ୱତୋପରି ସମୁପୱିଷ୍ଟେ ଶିଷ୍ୟାସ୍ତସ୍ୟ ସମୀପମାଗତ୍ୟ ଗୁପ୍ତଂ ପପ୍ରଚ୍ଛୁଃ, ଏତା ଘଟନାଃ କଦା ଭୱିଷ୍ୟନ୍ତି? ଭୱତ ଆଗମନସ୍ୟ ଯୁଗାନ୍ତସ୍ୟ ଚ କିଂ ଲକ୍ଷ୍ମ? ତଦସ୍ମାନ୍ ୱଦତୁ| ");
INSERT INTO sanori_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ତଦାନୀଂ ଯୀଶୁସ୍ତାନୱୋଚତ୍, ଅୱଧଦ୍ୱ୍ୱଂ, କୋପି ଯୁଷ୍ମାନ୍ ନ ଭ୍ରମଯେତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ବହୱୋ ମମ ନାମ ଗୃହ୍ଲନ୍ତ ଆଗମିଷ୍ୟନ୍ତି, ଖ୍ରୀଷ୍ଟୋଽହମେୱେତି ୱାଚଂ ୱଦନ୍ତୋ ବହୂନ୍ ଭ୍ରମଯିଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","ଯୂଯଞ୍ଚ ସଂଗ୍ରାମସ୍ୟ ରଣସ୍ୟ ଚାଡମ୍ବରଂ ଶ୍ରୋଷ୍ୟଥ, ଅୱଧଦ୍ୱ୍ୱଂ ତେନ ଚଞ୍ଚଲା ମା ଭୱତ, ଏତାନ୍ୟୱଶ୍ୟଂ ଘଟିଷ୍ୟନ୍ତେ, କିନ୍ତୁ ତଦା ଯୁଗାନ୍ତୋ ନହି| ");
INSERT INTO sanori_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","ଅପରଂ ଦେଶସ୍ୟ ୱିପକ୍ଷୋ ଦେଶୋ ରାଜ୍ୟସ୍ୟ ୱିପକ୍ଷୋ ରାଜ୍ୟଂ ଭୱିଷ୍ୟତି, ସ୍ଥାନେ ସ୍ଥାନେ ଚ ଦୁର୍ଭିକ୍ଷଂ ମହାମାରୀ ଭୂକମ୍ପଶ୍ଚ ଭୱିଷ୍ୟନ୍ତି, ");
INSERT INTO sanori_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ଏତାନି ଦୁଃଖୋପକ୍ରମାଃ| ");
INSERT INTO sanori_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","ତଦାନୀଂ ଲୋକା ଦୁଃଖଂ ଭୋଜଯିତୁଂ ଯୁଷ୍ମାନ୍ ପରକରେଷୁ ସମର୍ପଯିଷ୍ୟନ୍ତି ହନିଷ୍ୟନ୍ତି ଚ, ତଥା ମମ ନାମକାରଣାଦ୍ ଯୂଯଂ ସର୍ୱ୍ୱଦେଶୀଯମନୁଜାନାଂ ସମୀପେ ଘୃଣାର୍ହା ଭୱିଷ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","ବହୁଷୁ ୱିଘ୍ନଂ ପ୍ରାପ୍ତୱତ୍ସୁ ପରସ୍ପରମ୍ ଋृତୀଯାଂ କୃତୱତ୍ସୁ ଚ ଏକୋଽପରଂ ପରକରେଷୁ ସମର୍ପଯିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ତଥା ବହୱୋ ମୃଷାଭୱିଷ୍ୟଦ୍ୱାଦିନ ଉପସ୍ଥାଯ ବହୂନ୍ ଭ୍ରମଯିଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","ଦୁଷ୍କର୍ମ୍ମଣାଂ ବାହୁଲ୍ୟାଞ୍ଚ ବହୂନାଂ ପ୍ରେମ ଶୀତଲଂ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","କିନ୍ତୁ ଯଃ କଶ୍ଚିତ୍ ଶେଷଂ ଯାୱଦ୍ ଧୈର୍ୟ୍ୟମାଶ୍ରଯତେ, ସଏୱ ପରିତ୍ରାଯିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","ଅପରଂ ସର୍ୱ୍ୱଦେଶୀଯଲୋକାନ୍ ପ୍ରତିମାକ୍ଷୀ ଭୱିତୁଂ ରାଜସ୍ୟ ଶୁଭସମାଚାରଃ ସର୍ୱ୍ୱଜଗତି ପ୍ରଚାରିଷ୍ୟତେ, ଏତାଦୃଶି ସତି ଯୁଗାନ୍ତ ଉପସ୍ଥାସ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","ଅତୋ ଯତ୍ ସର୍ୱ୍ୱନାଶକୃଦ୍ଘୃଣାର୍ହଂ ୱସ୍ତୁ ଦାନିଯେଲ୍ଭୱିଷ୍ୟଦ୍ୱଦିନା ପ୍ରୋକ୍ତଂ ତଦ୍ ଯଦା ପୁଣ୍ୟସ୍ଥାନେ ସ୍ଥାପିତଂ ଦ୍ରକ୍ଷ୍ୟଥ, (ଯଃ ପଠତି, ସ ବୁଧ୍ୟତାଂ) ");
INSERT INTO sanori_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ତଦାନୀଂ ଯେ ଯିହୂଦୀଯଦେଶେ ତିଷ୍ଠନ୍ତି, ତେ ପର୍ୱ୍ୱତେଷୁ ପଲାଯନ୍ତାଂ| ");
INSERT INTO sanori_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ଯଃ କଶ୍ଚିଦ୍ ଗୃହପୃଷ୍ଠେ ତିଷ୍ଠତି, ସ ଗୃହାତ୍ କିମପି ୱସ୍ତ୍ୱାନେତୁମ୍ ଅଧେा ନାୱରୋହେତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ଯଶ୍ଚ କ୍ଷେତ୍ରେ ତିଷ୍ଠତି, ସୋପି ୱସ୍ତ୍ରମାନେତୁଂ ପରାୱୃତ୍ୟ ନ ଯାଯାତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","ତଦାନୀଂ ଗର୍ଭିଣୀସ୍ତନ୍ୟପାଯଯିତ୍ରୀଣାଂ ଦୁର୍ଗତି ର୍ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ଅତୋ ଯଷ୍ମାକଂ ପଲାଯନଂ ଶୀତକାଲେ ୱିଶ୍ରାମୱାରେ ୱା ଯନ୍ନ ଭୱେତ୍, ତଦର୍ଥଂ ପ୍ରାର୍ଥଯଧ୍ୱମ୍| ");
INSERT INTO sanori_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ଆ ଜଗଦାରମ୍ଭାଦ୍ ଏତତ୍କାଲପର୍ୟ୍ୟନନ୍ତଂ ଯାଦୃଶଃ କଦାପି ନାଭୱତ୍ ନ ଚ ଭୱିଷ୍ୟତି ତାଦୃଶୋ ମହାକ୍ଲେଶସ୍ତଦାନୀମ୍ ଉପସ୍ଥାସ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","ତସ୍ୟ କ୍ଲେଶସ୍ୟ ସମଯୋ ଯଦି ହ୍ସ୍ୱୋ ନ କ୍ରିଯେତ, ତର୍ହି କସ୍ୟାପି ପ୍ରାଣିନୋ ରକ୍ଷଣଂ ଭୱିତୁଂ ନ ଶକ୍ନୁଯାତ୍, କିନ୍ତୁ ମନୋନୀତମନୁଜାନାଂ କୃତେ ସ କାଲୋ ହ୍ସ୍ୱୀକରିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","ଅପରଞ୍ଚ ପଶ୍ୟତ, ଖ୍ରୀଷ୍ଟୋଽତ୍ର ୱିଦ୍ୟତେ, ୱା ତତ୍ର ୱିଦ୍ୟତେ, ତଦାନୀଂ ଯଦୀ କଶ୍ଚିଦ୍ ଯୁଷ୍ମାନ ଇତି ୱାକ୍ୟଂ ୱଦତି, ତଥାପି ତତ୍ ନ ପ୍ରତୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","ଯତୋ ଭାକ୍ତଖ୍ରୀଷ୍ଟା ଭାକ୍ତଭୱିଷ୍ୟଦ୍ୱାଦିନଶ୍ଚ ଉପସ୍ଥାଯ ଯାନି ମହନ୍ତି ଲକ୍ଷ୍ମାଣି ଚିତ୍ରକର୍ମ୍ମାଣି ଚ ପ୍ରକାଶଯିଷ୍ୟନ୍ତି, ତୈ ର୍ୟଦି ସମ୍ଭୱେତ୍ ତର୍ହି ମନୋନୀତମାନୱା ଅପି ଭ୍ରାମିଷ୍ୟନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","ପଶ୍ୟତ, ଘଟନାତଃ ପୂର୍ୱ୍ୱଂ ଯୁଷ୍ମାନ୍ ୱାର୍ତ୍ତାମ୍ ଅୱାଦିଷମ୍| ");
INSERT INTO sanori_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","ଅତଃ ପଶ୍ୟତ, ସ ପ୍ରାନ୍ତରେ ୱିଦ୍ୟତ ଇତି ୱାକ୍ୟେ କେନଚିତ୍ କଥିତେପି ବହି ର୍ମା ଗଚ୍ଛତ, ୱା ପଶ୍ୟତ, ସୋନ୍ତଃପୁରେ ୱିଦ୍ୟତେ, ଏତଦ୍ୱାକ୍ୟ ଉକ୍ତେପି ମା ପ୍ରତୀତ| ");
INSERT INTO sanori_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","ଯତୋ ଯଥା ୱିଦ୍ୟୁତ୍ ପୂର୍ୱ୍ୱଦିଶୋ ନିର୍ଗତ୍ୟ ପଶ୍ଚିମଦିଶଂ ଯାୱତ୍ ପ୍ରକାଶତେ, ତଥା ମାନୁଷପୁତ୍ରସ୍ୟାପ୍ୟାଗମନଂ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","ଯତ୍ର ଶୱସ୍ତିଷ୍ଠତି, ତତ୍ରେୱ ଗୃଧ୍ରା ମିଲନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","ଅପରଂ ତସ୍ୟ କ୍ଲେଶସମଯସ୍ୟାୱ୍ୟୱହିତପରତ୍ର ସୂର୍ୟ୍ୟସ୍ୟ ତେଜୋ ଲୋପ୍ସ୍ୟତେ, ଚନ୍ଦ୍ରମା ଜ୍ୟୋସ୍ନାଂ ନ କରିଷ୍ୟତି, ନଭସୋ ନକ୍ଷତ୍ରାଣି ପତିଷ୍ୟନ୍ତି, ଗଗଣୀଯା ଗ୍ରହାଶ୍ଚ ୱିଚଲିଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","ତଦାନୀମ୍ ଆକାଶମଧ୍ୟେ ମନୁଜସୁତସ୍ୟ ଲକ୍ଷ୍ମ ଦର୍ଶିଷ୍ୟତେ, ତତୋ ନିଜପରାକ୍ରମେଣ ମହାତେଜସା ଚ ମେଘାରୂଢଂ ମନୁଜସୁତଂ ନଭସାଗଚ୍ଛନ୍ତଂ ୱିଲୋକ୍ୟ ପୃଥିୱ୍ୟାଃ ସର୍ୱ୍ୱୱଂଶୀଯା ୱିଲପିଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ତଦାନୀଂ ସ ମହାଶବ୍ଦାଯମାନତୂର୍ୟ୍ୟା ୱାଦକାନ୍ ନିଜଦୂତାନ୍ ପ୍ରହେଷ୍ୟତି, ତେ ୱ୍ୟୋମ୍ନ ଏକସୀମାତୋଽପରସୀମାଂ ଯାୱତ୍ ଚତୁର୍ଦିଶସ୍ତସ୍ୟ ମନୋନୀତଜନାନ୍ ଆନୀଯ ମେଲଯିଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","ଉଡୁମ୍ବରପାଦପସ୍ୟ ଦୃଷ୍ଟାନ୍ତଂ ଶିକ୍ଷଧ୍ୱଂ; ଯଦା ତସ୍ୟ ନୱୀନାଃ ଶାଖା ଜାଯନ୍ତେ, ପଲ୍ଲୱାଦିଶ୍ଚ ନିର୍ଗଚ୍ଛତି, ତଦା ନିଦାଘକାଲଃ ସୱିଧୋ ଭୱତୀତି ଯୂଯଂ ଜାନୀଥ; ");
INSERT INTO sanori_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ତଦ୍ୱଦ୍ ଏତା ଘଟନା ଦୃଷ୍ଟ୍ୱା ସ ସମଯୋ ଦ୍ୱାର ଉପାସ୍ଥାଦ୍ ଇତି ଜାନୀତ| ");
INSERT INTO sanori_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","ଯୁଷ୍ମାନହଂ ତଥ୍ୟଂ ୱଦାମି, ଇଦାନୀନ୍ତନଜନାନାଂ ଗମନାତ୍ ପୂର୍ୱ୍ୱମେୱ ତାନି ସର୍ୱ୍ୱାଣି ଘଟିଷ୍ୟନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ନଭୋମେଦିନ୍ୟୋ ର୍ଲୁପ୍ତଯୋରପି ମମ ୱାକ୍ କଦାପି ନ ଲୋପ୍ସ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","ଅପରଂ ମମ ତାତଂ ୱିନା ମାନୁଷଃ ସ୍ୱର୍ଗସ୍ଥୋ ଦୂତୋ ୱା କୋପି ତଦ୍ଦିନଂ ତଦ୍ଦଣ୍ଡଞ୍ଚ ନ ଜ୍ଞାପଯତି| ");
INSERT INTO sanori_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","ଅପରଂ ନୋହେ ୱିଦ୍ୟମାନେ ଯାଦୃଶମଭୱତ୍ ତାଦୃଶଂ ମନୁଜସୁତସ୍ୟାଗମନକାଲେପି ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ଫଲତୋ ଜଲାପ୍ଲାୱନାତ୍ ପୂର୍ୱ୍ୱଂ ଯଦ୍ଦିନଂ ଯାୱତ୍ ନୋହଃ ପୋତଂ ନାରୋହତ୍, ତାୱତ୍କାଲଂ ଯଥା ମନୁଷ୍ୟା ଭୋଜନେ ପାନେ ୱିୱହନେ ୱିୱାହନେ ଚ ପ୍ରୱୃତ୍ତା ଆସନ୍; ");
INSERT INTO sanori_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ଅପରମ୍ ଆପ୍ଲାୱିତୋଯମାଗତ୍ୟ ଯାୱତ୍ ସକଲମନୁଜାନ୍ ପ୍ଲାୱଯିତ୍ୱା ନାନଯତ୍, ତାୱତ୍ ତେ ଯଥା ନ ୱିଦାମାସୁଃ, ତଥା ମନୁଜସୁତାଗମନେପି ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","ତଦା କ୍ଷେତ୍ରସ୍ଥିତଯୋର୍ଦ୍ୱଯୋରେକୋ ଧାରିଷ୍ୟତେ, ଅପରସ୍ତ୍ୟାଜିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ତଥା ପେଷଣ୍ୟା ପିଂଷତ୍ୟୋରୁଭଯୋ ର୍ୟୋଷିତୋରେକା ଧାରିଷ୍ୟତେଽପରା ତ୍ୟାଜିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","ଯୁଷ୍ମାକଂ ପ୍ରଭୁଃ କସ୍ମିନ୍ ଦଣ୍ଡ ଆଗମିଷ୍ୟତି, ତଦ୍ ଯୁଷ୍ମାଭି ର୍ନାୱଗମ୍ୟତେ, ତସ୍ମାତ୍ ଜାଗ୍ରତଃ ସନ୍ତସ୍ତିଷ୍ଠତ| ");
INSERT INTO sanori_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","କୁତ୍ର ଯାମେ ସ୍ତେନ ଆଗମିଷ୍ୟତୀତି ଚେଦ୍ ଗୃହସ୍ଥୋ ଜ୍ଞାତୁମ୍ ଅଶକ୍ଷ୍ୟତ୍, ତର୍ହି ଜାଗରିତ୍ୱା ତଂ ସନ୍ଧିଂ କର୍ତ୍ତିତୁମ୍ ଅୱାରଯିଷ୍ୟତ୍ ତଦ୍ ଜାନୀତ| ");
INSERT INTO sanori_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","ଯୁଷ୍ମାଭିରୱଧୀଯତାଂ, ଯତୋ ଯୁଷ୍ମାଭି ର୍ୟତ୍ର ନ ବୁଧ୍ୟତେ, ତତ୍ରୈୱ ଦଣ୍ଡେ ମନୁଜସୁତ ଆଯାସ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","ପ୍ରଭୁ ର୍ନିଜପରିୱାରାନ୍ ଯଥାକାଲଂ ଭୋଜଯିତୁଂ ଯଂ ଦାସମ୍ ଅଧ୍ୟକ୍ଷୀକୃତ୍ୟ ସ୍ଥାପଯତି, ତାଦୃଶୋ ୱିଶ୍ୱାସ୍ୟୋ ଧୀମାନ୍ ଦାସଃ କଃ? ");
INSERT INTO sanori_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ପ୍ରଭୁରାଗତ୍ୟ ଯଂ ଦାସଂ ତଥାଚରନ୍ତଂ ୱୀକ୍ଷତେ, ସଏୱ ଧନ୍ୟଃ| ");
INSERT INTO sanori_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","ଯୁଷ୍ମାନହଂ ସତ୍ୟଂ ୱଦାମି, ସ ତଂ ନିଜସର୍ୱ୍ୱସ୍ୱସ୍ୟାଧିପଂ କରିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","କିନ୍ତୁ ପ୍ରଭୁରାଗନ୍ତୁଂ ୱିଲମ୍ବତ ଇତି ମନସି ଚିନ୍ତଯିତ୍ୱା ଯୋ ଦୁଷ୍ଟୋ ଦାସୋ ");
INSERT INTO sanori_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ଽପରଦାସାନ୍ ପ୍ରହର୍ତ୍ତୁଂ ମତ୍ତାନାଂ ସଙ୍ଗେ ଭୋକ୍ତୁଂ ପାତୁଞ୍ଚ ପ୍ରୱର୍ତ୍ତତେ, ");
INSERT INTO sanori_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ସ ଦାସୋ ଯଦା ନାପେକ୍ଷତେ, ଯଞ୍ଚ ଦଣ୍ଡଂ ନ ଜାନାତି, ତତ୍କାଲଏୱ ତତ୍ପ୍ରଭୁରୁପସ୍ଥାସ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ତଦା ତଂ ଦଣ୍ଡଯିତ୍ୱା ଯତ୍ର ସ୍ଥାନେ ରୋଦନଂ ଦନ୍ତଘର୍ଷଣଞ୍ଚାସାତେ, ତତ୍ର କପଟିଭିଃ ସାକଂ ତଦ୍ଦଶାଂ ନିରୂପଯିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","ଯା ଦଶ କନ୍ୟାଃ ପ୍ରଦୀପାନ୍ ଗୃହ୍ଲତ୍ୟୋ ୱରଂ ସାକ୍ଷାତ୍ କର୍ତ୍ତୁଂ ବହିରିତାଃ, ତାଭିସ୍ତଦା ସ୍ୱର୍ଗୀଯରାଜ୍ୟସ୍ୟ ସାଦୃଶ୍ୟଂ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ତାସାଂ କନ୍ୟାନାଂ ମଧ୍ୟେ ପଞ୍ଚ ସୁଧିଯଃ ପଞ୍ଚ ଦୁର୍ଧିଯ ଆସନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ଯା ଦୁର୍ଧିଯସ୍ତାଃ ପ୍ରଦୀପାନ୍ ସଙ୍ଗେ ଗୃହୀତ୍ୱା ତୈଲଂ ନ ଜଗୃହୁଃ, ");
INSERT INTO sanori_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","କିନ୍ତୁ ସୁଧିଯଃ ପ୍ରଦୀପାନ୍ ପାତ୍ରେଣ ତୈଲଞ୍ଚ ଜଗୃହୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","ଅନନ୍ତରଂ ୱରେ ୱିଲମ୍ବିତେ ତାଃ ସର୍ୱ୍ୱା ନିଦ୍ରାୱିଷ୍ଟା ନିଦ୍ରାଂ ଜଗ୍ମୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","ଅନନ୍ତରମ୍ ଅର୍ଦ୍ଧରାତ୍ରେ ପଶ୍ୟତ ୱର ଆଗଚ୍ଛତି, ତଂ ସାକ୍ଷାତ୍ କର୍ତ୍ତୁଂ ବହିର୍ୟାତେତି ଜନରୱାତ୍ ");
INSERT INTO sanori_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","ତାଃ ସର୍ୱ୍ୱାଃ କନ୍ୟା ଉତ୍ଥାଯ ପ୍ରଦୀପାନ୍ ଆସାଦଯିତୁଂ ଆରଭନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ତତୋ ଦୁର୍ଧିଯଃ ସୁଧିଯ ଊଚୁଃ, କିଞ୍ଚିତ୍ ତୈଲଂ ଦତ୍ତ, ପ୍ରଦୀପା ଅସ୍ମାକଂ ନିର୍ୱ୍ୱାଣାଃ| ");
INSERT INTO sanori_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","କିନ୍ତୁ ସୁଧିଯଃ ପ୍ରତ୍ୟୱଦନ୍, ଦତ୍ତେ ଯୁଷ୍ମାନସ୍ମାଂଶ୍ଚ ପ୍ରତି ତୈଲଂ ନ୍ୟୂନୀଭୱେତ୍, ତସ୍ମାଦ୍ ୱିକ୍ରେତୃଣାଂ ସମୀପଂ ଗତ୍ୱା ସ୍ୱାର୍ଥଂ ତୈଲଂ କ୍ରୀଣୀତ| ");
INSERT INTO sanori_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","ତଦା ତାସୁ କ୍ରେତୁଂ ଗତାସୁ ୱର ଆଜଗାମ, ତତୋ ଯାଃ ସଜ୍ଜିତା ଆସନ୍, ତାସ୍ତେନ ସାକଂ ୱିୱାହୀଯଂ ୱେଶ୍ମ ପ୍ରୱିୱିଶୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","ଅନନ୍ତରଂ ଦ୍ୱାରେ ରୁଦ୍ଧେ ଅପରାଃ କନ୍ୟା ଆଗତ୍ୟ ଜଗଦୁଃ, ହେ ପ୍ରଭୋ, ହେ ପ୍ରଭୋ, ଅସ୍ମାନ୍ ପ୍ରତି ଦ୍ୱାରଂ ମୋଚଯ| ");
INSERT INTO sanori_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","କିନ୍ତୁ ସ ଉକ୍ତୱାନ୍, ତଥ୍ୟଂ ୱଦାମି, ଯୁଷ୍ମାନହଂ ନ ୱେଦ୍ମି| ");
INSERT INTO sanori_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","ଅତୋ ଜାଗ୍ରତଃ ସନ୍ତସ୍ତିଷ୍ଠତ, ମନୁଜସୁତଃ କସ୍ମିନ୍ ଦିନେ କସ୍ମିନ୍ ଦଣ୍ଡେ ୱାଗମିଷ୍ୟତି, ତଦ୍ ଯୁଷ୍ମାଭି ର୍ନ ଜ୍ଞାଯତେ| ");
INSERT INTO sanori_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","ଅପରଂ ସ ଏତାଦୃଶଃ କସ୍ୟଚିତ୍ ପୁଂସସ୍ତୁଲ୍ୟଃ, ଯୋ ଦୂରଦେଶଂ ପ୍ରତି ଯାତ୍ରାକାଲେ ନିଜଦାସାନ୍ ଆହୂଯ ତେଷାଂ ସ୍ୱସ୍ୱସାମର୍ଥ୍ୟାନୁରୂପମ୍ ");
INSERT INTO sanori_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ଏକସ୍ମିନ୍ ମୁଦ୍ରାଣାଂ ପଞ୍ଚ ପୋଟଲିକାଃ ଅନ୍ୟସ୍ମିଂଶ୍ଚ ଦ୍ୱେ ପୋଟଲିକେ ଅପରସ୍ମିଂଶ୍ଚ ପୋଟଲିକୈକାମ୍ ଇତ୍ଥଂ ପ୍ରତିଜନଂ ସମର୍ପ୍ୟ ସ୍ୱଯଂ ପ୍ରୱାସଂ ଗତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","ଅନନ୍ତରଂ ଯୋ ଦାସଃ ପଞ୍ଚ ପୋଟଲିକାଃ ଲବ୍ଧୱାନ୍, ସ ଗତ୍ୱା ୱାଣିଜ୍ୟଂ ୱିଧାଯ ତା ଦ୍ୱିଗୁଣୀଚକାର| ");
INSERT INTO sanori_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ଯଶ୍ଚ ଦାସୋ ଦ୍ୱେ ପୋଟଲିକେ ଅଲଭତ, ସୋପି ତା ମୁଦ୍ରା ଦ୍ୱିଗୁଣୀଚକାର| ");
INSERT INTO sanori_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","କିନ୍ତୁ ଯୋ ଦାସ ଏକାଂ ପୋଟଲିକାଂ ଲବ୍ଧୱାନ୍, ସ ଗତ୍ୱା ଭୂମିଂ ଖନିତ୍ୱା ତନ୍ମଧ୍ୟେ ନିଜପ୍ରଭୋସ୍ତା ମୁଦ୍ରା ଗୋପଯାଞ୍ଚକାର| ");
INSERT INTO sanori_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","ତଦନନ୍ତରଂ ବହୁତିଥେ କାଲେ ଗତେ ତେଷାଂ ଦାସାନାଂ ପ୍ରଭୁରାଗତ୍ୟ ତୈର୍ଦାସୈଃ ସମଂ ଗଣଯାଞ୍ଚକାର| ");
INSERT INTO sanori_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","ତଦାନୀଂ ଯଃ ପଞ୍ଚ ପୋଟଲିକାଃ ପ୍ରାପ୍ତୱାନ୍ ସ ତା ଦ୍ୱିଗୁଣୀକୃତମୁଦ୍ରା ଆନୀଯ ଜଗାଦ; ହେ ପ୍ରଭୋ, ଭୱତା ମଯି ପଞ୍ଚ ପୋଟଲିକାଃ ସମର୍ପିତାଃ, ପଶ୍ୟତୁ, ତା ମଯା ଦ୍ୱିଗୁଣୀକୃତାଃ| ");
INSERT INTO sanori_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ତଦାନୀଂ ତସ୍ୟ ପ୍ରଭୁସ୍ତମୁୱାଚ, ହେ ଉତ୍ତମ ୱିଶ୍ୱାସ୍ୟ ଦାସ, ତ୍ୱଂ ଧନ୍ୟୋସି, ସ୍ତୋକେନ ୱିଶ୍ୱାସ୍ୟୋ ଜାତଃ, ତସ୍ମାତ୍ ତ୍ୱାଂ ବହୁୱିତ୍ତାଧିପଂ କରୋମି, ତ୍ୱଂ ସ୍ୱପ୍ରଭୋଃ ସୁଖସ୍ୟ ଭାଗୀ ଭୱ| ");
INSERT INTO sanori_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","ତତୋ ଯେନ ଦ୍ୱେ ପୋଟଲିକେ ଲବ୍ଧେ ସୋପ୍ୟାଗତ୍ୟ ଜଗାଦ, ହେ ପ୍ରଭୋ, ଭୱତା ମଯି ଦ୍ୱେ ପୋଟଲିକେ ସମର୍ପିତେ, ପଶ୍ୟତୁ ତେ ମଯା ଦ୍ୱିଗୁଣୀକୃତେ| ");
INSERT INTO sanori_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ତେନ ତସ୍ୟ ପ୍ରଭୁସ୍ତମୱୋଚତ୍, ହେ ଉତ୍ତମ ୱିଶ୍ୱାସ୍ୟ ଦାସ, ତ୍ୱଂ ଧନ୍ୟୋସି, ସ୍ତୋକେନ ୱିଶ୍ୱାସ୍ୟୋ ଜାତଃ, ତସ୍ମାତ୍ ତ୍ୱାଂ ବହୁଦ୍ରୱିଣାଧିପଂ କରୋମି, ତ୍ୱଂ ନିଜପ୍ରଭୋଃ ସୁଖସ୍ୟ ଭାଗୀ ଭୱ| ");
INSERT INTO sanori_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","ଅନନ୍ତରଂ ଯ ଏକାଂ ପୋଟଲିକାଂ ଲବ୍ଧୱାନ୍, ସ ଏତ୍ୟ କଥିତୱାନ୍, ହେ ପ୍ରଭୋ, ତ୍ୱାଂ କଠିନନରଂ ଜ୍ଞାତୱାନ୍, ତ୍ୱଯା ଯତ୍ର ନୋପ୍ତଂ, ତତ୍ରୈୱ କୃତ୍ୟତେ, ଯତ୍ର ଚ ନ କୀର୍ଣଂ, ତତ୍ରୈୱ ସଂଗୃହ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ଅତୋହଂ ସଶଙ୍କଃ ସନ୍ ଗତ୍ୱା ତୱ ମୁଦ୍ରା ଭୂମଧ୍ୟେ ସଂଗୋପ୍ୟ ସ୍ଥାପିତୱାନ୍, ପଶ୍ୟ, ତୱ ଯତ୍ ତଦେୱ ଗୃହାଣ| ");
INSERT INTO sanori_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","ତଦା ତସ୍ୟ ପ୍ରଭୁଃ ପ୍ରତ୍ୟୱଦତ୍ ରେ ଦୁଷ୍ଟାଲସ ଦାସ, ଯତ୍ରାହଂ ନ ୱପାମି, ତତ୍ର ଛିନଦ୍ମି, ଯତ୍ର ଚ ନ କିରାମି, ତତ୍ରେୱ ସଂଗୃହ୍ଲାମୀତି ଚେଦଜାନାସ୍ତର୍ହି ");
INSERT INTO sanori_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ୱଣିକ୍ଷୁ ମମ ୱିତ୍ତାର୍ପଣଂ ତୱୋଚିତମାସୀତ୍, ଯେନାହମାଗତ୍ୟ ୱୃଦ୍ୱ୍ୟା ସାକଂ ମୂଲମୁଦ୍ରାଃ ପ୍ରାପ୍ସ୍ୟମ୍| ");
INSERT INTO sanori_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","ଅତୋସ୍ମାତ୍ ତାଂ ପୋଟଲିକାମ୍ ଆଦାଯ ଯସ୍ୟ ଦଶ ପୋଟଲିକାଃ ସନ୍ତି ତସ୍ମିନ୍ନର୍ପଯତ| ");
INSERT INTO sanori_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ଯେନ ୱର୍ଦ୍ୱ୍ୟତେ ତସ୍ମିନ୍ନୈୱାର୍ପିଷ୍ୟତେ, ତସ୍ୟୈୱ ଚ ବାହୁଲ୍ୟଂ ଭୱିଷ୍ୟତି, କିନ୍ତୁ ଯେନ ନ ୱର୍ଦ୍ୱ୍ୟତେ, ତସ୍ୟାନ୍ତିକେ ଯତ୍ କିଞ୍ଚନ ତିଷ୍ଠତି, ତଦପି ପୁନର୍ନେଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","ଅପରଂ ଯୂଯଂ ତମକର୍ମ୍ମଣ୍ୟଂ ଦାସଂ ନୀତ୍ୱା ଯତ୍ର ସ୍ଥାନେ କ୍ରନ୍ଦନଂ ଦନ୍ତଘର୍ଷଣଞ୍ଚ ୱିଦ୍ୟେତେ, ତସ୍ମିନ୍ ବହିର୍ଭୂତତମସି ନିକ୍ଷିପତ| ");
INSERT INTO sanori_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","ଯଦା ମନୁଜସୁତଃ ପୱିତ୍ରଦୂତାନ୍ ସଙ୍ଗିନଃ କୃତ୍ୱା ନିଜପ୍ରଭାୱେନାଗତ୍ୟ ନିଜତେଜୋମଯେ ସିଂହାସନେ ନିୱେକ୍ଷ୍ୟତି, ");
INSERT INTO sanori_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ତଦା ତତ୍ସମ୍ମୁଖେ ସର୍ୱ୍ୱଜାତୀଯା ଜନା ସଂମେଲିଷ୍ୟନ୍ତି| ତତୋ ମେଷପାଲକୋ ଯଥା ଛାଗେଭ୍ୟୋଽୱୀନ୍ ପୃଥକ୍ କରୋତି ତଥା ସୋପ୍ୟେକସ୍ମାଦନ୍ୟମ୍ ଇତ୍ଥଂ ତାନ୍ ପୃଥକ କୃତ୍ୱାୱୀନ୍ ");
INSERT INTO sanori_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ଦକ୍ଷିଣେ ଛାଗାଂଶ୍ଚ ୱାମେ ସ୍ଥାପଯିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","ତତଃ ପରଂ ରାଜା ଦକ୍ଷିଣସ୍ଥିତାନ୍ ମାନୱାନ୍ ୱଦିଷ୍ୟତି, ଆଗଚ୍ଛତ ମତ୍ତାତସ୍ୟାନୁଗ୍ରହଭାଜନାନି, ଯୁଷ୍ମତ୍କୃତ ଆ ଜଗଦାରମ୍ଭତ୍ ଯଦ୍ ରାଜ୍ୟମ୍ ଆସାଦିତଂ ତଦଧିକୁରୁତ| ");
INSERT INTO sanori_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ଯତୋ ବୁଭୁକ୍ଷିତାଯ ମହ୍ୟଂ ଭୋଜ୍ୟମ୍ ଅଦତ୍ତ, ପିପାସିତାଯ ପେଯମଦତ୍ତ, ୱିଦେଶିନଂ ମାଂ ସ୍ୱସ୍ଥାନମନଯତ, ");
INSERT INTO sanori_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ୱସ୍ତ୍ରହୀନଂ ମାଂ ୱସନଂ ପର୍ୟ୍ୟଧାପଯତ, ପୀଡୀତଂ ମାଂ ଦ୍ରଷ୍ଟୁମାଗଚ୍ଛତ, କାରାସ୍ଥଞ୍ଚ ମାଂ ୱୀକ୍ଷିତୁମ ଆଗଚ୍ଛତ| ");
INSERT INTO sanori_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","ତଦା ଧାର୍ମ୍ମିକାଃ ପ୍ରତିୱଦିଷ୍ୟନ୍ତି, ହେ ପ୍ରଭୋ, କଦା ତ୍ୱାଂ କ୍ଷୁଧିତଂ ୱୀକ୍ଷ୍ୟ ୱଯମଭୋଜଯାମ? ୱା ପିପାସିତଂ ୱୀକ୍ଷ୍ୟ ଅପାଯଯାମ? ");
INSERT INTO sanori_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","କଦା ୱା ତ୍ୱାଂ ୱିଦେଶିନଂ ୱିଲୋକ୍ୟ ସ୍ୱସ୍ଥାନମନଯାମ? କଦା ୱା ତ୍ୱାଂ ନଗ୍ନଂ ୱୀକ୍ଷ୍ୟ ୱସନଂ ପର୍ୟ୍ୟଧାପଯାମ? ");
INSERT INTO sanori_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","କଦା ୱା ତ୍ୱାଂ ପୀଡିତଂ କାରାସ୍ଥଞ୍ଚ ୱୀକ୍ଷ୍ୟ ତ୍ୱଦନ୍ତିକମଗଚ୍ଛାମ? ");
INSERT INTO sanori_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","ତଦାନୀଂ ରାଜା ତାନ୍ ପ୍ରତିୱଦିଷ୍ୟତି, ଯୁଷ୍ମାନହଂ ସତ୍ୟଂ ୱଦାମି, ମମୈତେଷାଂ ଭ୍ରାତୃଣାଂ ମଧ୍ୟେ କଞ୍ଚନୈକଂ କ୍ଷୁଦ୍ରତମଂ ପ୍ରତି ଯଦ୍ ଅକୁରୁତ, ତନ୍ମାଂ ପ୍ରତ୍ୟକୁରୁତ| ");
INSERT INTO sanori_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","ପଶ୍ଚାତ୍ ସ ୱାମସ୍ଥିତାନ୍ ଜନାନ୍ ୱଦିଷ୍ୟତି, ରେ ଶାପଗ୍ରସ୍ତାଃ ସର୍ୱ୍ୱେ, ଶୈତାନେ ତସ୍ୟ ଦୂତେଭ୍ୟଶ୍ଚ ଯୋଽନନ୍ତୱହ୍ନିରାସାଦିତ ଆସ୍ତେ, ଯୂଯଂ ମଦନ୍ତିକାତ୍ ତମଗ୍ନିଂ ଗଚ୍ଛତ| ");
INSERT INTO sanori_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ଯତୋ କ୍ଷୁଧିତାଯ ମହ୍ୟମାହାରଂ ନାଦତ୍ତ, ପିପାସିତାଯ ମହ୍ୟଂ ପେଯଂ ନାଦତ୍ତ, ");
INSERT INTO sanori_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ୱିଦେଶିନଂ ମାଂ ସ୍ୱସ୍ଥାନଂ ନାନଯତ, ୱସନହୀନଂ ମାଂ ୱସନଂ ନ ପର୍ୟ୍ୟଧାପଯତ, ପୀଡିତଂ କାରାସ୍ଥଞ୍ଚ ମାଂ ୱୀକ୍ଷିତୁଂ ନାଗଚ୍ଛତ| ");
INSERT INTO sanori_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","ତଦା ତେ ପ୍ରତିୱଦିଷ୍ୟନ୍ତି, ହେ ପ୍ରଭୋ, କଦା ତ୍ୱାଂ କ୍ଷୁଧିତଂ ୱା ପିପାସିତଂ ୱା ୱିଦେଶିନଂ ୱା ନଗ୍ନଂ ୱା ପୀଡିତଂ ୱା କାରାସ୍ଥଂ ୱୀକ୍ଷ୍ୟ ତ୍ୱାଂ ନାସେୱାମହି? ");
INSERT INTO sanori_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","ତଦା ସ ତାନ୍ ୱଦିଷ୍ୟତି, ତଥ୍ୟମହଂ ଯୁଷ୍ମାନ୍ ବ୍ରୱୀମି, ଯୁଷ୍ମାଭିରେଷାଂ କଞ୍ଚନ କ୍ଷୋଦିଷ୍ଠଂ ପ୍ରତି ଯନ୍ନାକାରି, ତନ୍ମାଂ ପ୍ରତ୍ୟେୱ ନାକାରି| ");
INSERT INTO sanori_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","ପଶ୍ଚାଦମ୍ୟନନ୍ତଶାସ୍ତିଂ କିନ୍ତୁ ଧାର୍ମ୍ମିକା ଅନନ୍ତାଯୁଷଂ ଭୋକ୍ତୁଂ ଯାସ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","ଯୀଶୁରେତାନ୍ ପ୍ରସ୍ତାୱାନ୍ ସମାପ୍ୟ ଶିଷ୍ୟାନୂଚେ, ");
INSERT INTO sanori_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","ଯୁଷ୍ମାଭି ର୍ଜ୍ଞାତଂ ଦିନଦ୍ୱଯାତ୍ ପରଂ ନିସ୍ତାରମହ ଉପସ୍ଥାସ୍ୟତି, ତତ୍ର ମନୁଜସୁତଃ କ୍ରୁଶେନ ହନ୍ତୁଂ ପରକରେଷୁ ସମର୍ପିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","ତତଃ ପରଂ ପ୍ରଧାନଯାଜକାଧ୍ୟାପକପ୍ରାଞ୍ଚଃ କିଯଫାନାମ୍ନୋ ମହାଯାଜକସ୍ୟାଟ୍ଟାଲିକାଯାଂ ମିଲିତ୍ୱା ");
INSERT INTO sanori_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","କେନୋପାଯେନ ଯୀଶୁଂ ଧୃତ୍ୱା ହନ୍ତୁଂ ଶକ୍ନୁଯୁରିତି ମନ୍ତ୍ରଯାଞ୍ଚକ୍ରୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","କିନ୍ତୁ ତୈରୁକ୍ତଂ ମହକାଲେ ନ ଧର୍ତ୍ତୱ୍ୟଃ, ଧୃତେ ପ୍ରଜାନାଂ କଲହେନ ଭୱିତୁଂ ଶକ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","ତତୋ ବୈଥନିଯାପୁରେ ଶିମୋନାଖ୍ୟସ୍ୟ କୁଷ୍ଠିନୋ ୱେଶ୍ମନି ଯୀଶୌ ତିଷ୍ଠତି ");
INSERT INTO sanori_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","କାଚନ ଯୋଷା ଶ୍ୱେତୋପଲଭାଜନେନ ମହାର୍ଘ୍ୟଂ ସୁଗନ୍ଧି ତୈଲମାନୀଯ ଭୋଜନାଯୋପୱିଶତସ୍ତସ୍ୟ ଶିରୋଭ୍ୟଷେଚତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","କିନ୍ତୁ ତଦାଲୋକ୍ୟ ତଚ୍ଛିଷ୍ୟୈଃ କୁପିତୈରୁକ୍ତଂ, କୁତ ଇତ୍ଥମପୱ୍ୟଯତେ? ");
INSERT INTO sanori_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ଚେଦିଦଂ ୱ୍ୟକ୍ରେଷ୍ୟତ, ତର୍ହି ଭୂରିମୂଲ୍ୟଂ ପ୍ରାପ୍ୟ ଦରିଦ୍ରେଭ୍ୟୋ ୱ୍ୟତାରିଷ୍ୟତ| ");
INSERT INTO sanori_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","ଯୀଶୁନା ତଦୱଗତ୍ୟ ତେ ସମୁଦିତାଃ, ଯୋଷାମେନାଂ କୁତୋ ଦୁଃଖିନୀଂ କୁରୁଥ, ସା ମାଂ ପ୍ରତି ସାଧୁ କର୍ମ୍ମାକାର୍ଷୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","ଯୁଷ୍ମାକମଂ ସମୀପେ ଦରିଦ୍ରାଃ ସତତମେୱାସତେ, କିନ୍ତୁ ଯୁଷ୍ମାକମନ୍ତିକେହଂ ନାସେ ସତତଂ| ");
INSERT INTO sanori_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ସା ମମ କାଯୋପରି ସୁଗନ୍ଧିତୈଲଂ ସିକ୍ତ୍ୱା ମମ ଶ୍ମଶାନଦାନକର୍ମ୍ମାକାର୍ଷୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","ଅତୋହଂ ଯୁଷ୍ମାନ୍ ତଥ୍ୟଂ ୱଦାମି ସର୍ୱ୍ୱସ୍ମିନ୍ ଜଗତି ଯତ୍ର ଯତ୍ରୈଷ ସୁସମାଚାରଃ ପ୍ରଚାରିଷ୍ୟତେ, ତତ୍ର ତତ୍ରୈତସ୍ୟା ନାର୍ୟ୍ୟାଃ ସ୍ମରଣାର୍ଥମ୍ କର୍ମ୍ମେଦଂ ପ୍ରଚାରିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","ତତୋ ଦ୍ୱାଦଶଶିଷ୍ୟାଣାମ୍ ଈଷ୍କରିଯୋତୀଯଯିହୂଦାନାମକ ଏକଃ ଶିଷ୍ୟଃ ପ୍ରଧାନଯାଜକାନାମନ୍ତିକଂ ଗତ୍ୱା କଥିତୱାନ୍, ");
INSERT INTO sanori_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ଯଦି ଯୁଷ୍ମାକଂ କରେଷୁ ଯୀଶୁଂ ସମର୍ପଯାମି, ତର୍ହି କିଂ ଦାସ୍ୟଥ? ତଦାନୀଂ ତେ ତସ୍ମୈ ତ୍ରିଂଶନ୍ମୁଦ୍ରା ଦାତୁଂ ସ୍ଥିରୀକୃତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ସ ତଦାରଭ୍ୟ ତଂ ପରକରେଷୁ ସମର୍ପଯିତୁଂ ସୁଯୋଗଂ ଚେଷ୍ଟିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","ଅନନ୍ତରଂ କିଣ୍ୱଶୂନ୍ୟପୂପପର୍ୱ୍ୱଣଃ ପ୍ରଥମେହ୍ନି ଶିଷ୍ୟା ଯୀଶୁମ୍ ଉପଗତ୍ୟ ପପ୍ରଚ୍ଛୁଃ ଭୱତ୍କୃତେ କୁତ୍ର ୱଯଂ ନିସ୍ତାରମହଭୋଜ୍ୟମ୍ ଆଯୋଜଯିଷ୍ୟାମଃ? ଭୱତଃ କେଚ୍ଛା? ");
INSERT INTO sanori_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ତଦା ସ ଗଦିତୱାନ୍, ମଧ୍ୟେନଗରମମୁକପୁଂସଃ ସମୀପଂ ୱ୍ରଜିତ୍ୱା ୱଦତ, ଗୁରୁ ର୍ଗଦିତୱାନ୍, ମତ୍କାଲଃ ସୱିଧଃ, ସହ ଶିଷ୍ୟୈସ୍ତ୍ୱଦାଲଯେ ନିସ୍ତାରମହଭୋଜ୍ୟଂ ଭୋକ୍ଷ୍ୟେ| ");
INSERT INTO sanori_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ତଦା ଶିଷ୍ୟା ଯୀଶୋସ୍ତାଦୃଶନିଦେଶାନୁରୂପକର୍ମ୍ମ ୱିଧାଯ ତତ୍ର ନିସ୍ତାରମହଭୋଜ୍ୟମାସାଦଯାମାସୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ତତଃ ସନ୍ଧ୍ୟାଯାଂ ସତ୍ୟାଂ ଦ୍ୱାଦଶଭିଃ ଶିଷ୍ୟୈଃ ସାକଂ ସ ନ୍ୟୱିଶତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ଅପରଂ ଭୁଞ୍ଜାନ ଉକ୍ତୱାନ୍ ଯୁଷ୍ମାନ୍ ତଥ୍ୟଂ ୱଦାମି, ଯୁଷ୍ମାକମେକୋ ମାଂ ପରକରେଷୁ ସମର୍ପଯିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ତଦା ତେଽତୀୱ ଦୁଃଖିତା ଏକୈକଶୋ ୱକ୍ତୁମାରେଭିରେ, ହେ ପ୍ରଭୋ, ସ କିମହଂ? ");
INSERT INTO sanori_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ତତଃ ସ ଜଗାଦ, ମଯା ସାକଂ ଯୋ ଜନୋ ଭୋଜନପାତ୍ରେ କରଂ ସଂକ୍ଷିପତି, ସ ଏୱ ମାଂ ପରକରେଷୁ ସମର୍ପଯିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","ମନୁଜସୁତମଧି ଯାଦୃଶଂ ଲିଖିତମାସ୍ତେ, ତଦନୁରୂପା ତଦ୍ଗତି ର୍ଭୱିଷ୍ୟତି; କିନ୍ତୁ ଯେନ ପୁଂସା ସ ପରକରେଷୁ ସମର୍ପଯିଷ୍ୟତେ, ହା ହା ଚେତ୍ ସ ନାଜନିଷ୍ୟତ, ତଦା ତସ୍ୟ କ୍ଷେମମଭୱିଷ୍ୟତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ତଦା ଯିହୂଦାନାମା ଯୋ ଜନସ୍ତଂ ପରକରେଷୁ ସମର୍ପଯିଷ୍ୟତି, ସ ଉକ୍ତୱାନ୍, ହେ ଗୁରୋ, ସ କିମହଂ? ତତଃ ସ ପ୍ରତ୍ୟୁକ୍ତୱାନ୍, ତ୍ୱଯା ସତ୍ୟଂ ଗଦିତମ୍| ");
INSERT INTO sanori_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","ଅନନ୍ତରଂ ତେଷାମଶନକାଲେ ଯୀଶୁଃ ପୂପମାଦାଯେଶ୍ୱରୀଯଗୁଣାନନୂଦ୍ୟ ଭଂକ୍ତ୍ୱା ଶିଷ୍ୟେଭ୍ୟଃ ପ୍ରଦାଯ ଜଗାଦ, ମଦ୍ୱପୁଃସ୍ୱରୂପମିମଂ ଗୃହୀତ୍ୱା ଖାଦତ| ");
INSERT INTO sanori_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ପଶ୍ଚାତ୍ ସ କଂସଂ ଗୃହ୍ଲନ୍ ଈଶ୍ୱରୀଯଗୁଣାନନୂଦ୍ୟ ତେଭ୍ୟଃ ପ୍ରଦାଯ କଥିତୱାନ୍, ସର୍ୱ୍ୱୈ ର୍ୟୁଷ୍ମାଭିରନେନ ପାତୱ୍ୟଂ, ");
INSERT INTO sanori_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ଯସ୍ମାଦନେକେଷାଂ ପାପମର୍ଷଣାଯ ପାତିତଂ ଯନ୍ମନ୍ନୂତ୍ନନିଯମରୂପଶୋଣିତଂ ତଦେତତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","ଅପରମହଂ ନୂତ୍ନଗୋସ୍ତନୀରସଂ ନ ପାସ୍ୟାମି, ତାୱତ୍ ଗୋସ୍ତନୀଫଲରସଂ ପୁନଃ କଦାପି ନ ପାସ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ପଶ୍ଚାତ୍ ତେ ଗୀତମେକଂ ସଂଗୀଯ ଜୈତୁନାଖ୍ୟଗିରିଂ ଗତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","ତଦାନୀଂ ଯୀଶୁସ୍ତାନୱୋଚତ୍, ଅସ୍ୟାଂ ରଜନ୍ୟାମହଂ ଯୁଷ୍ମାକଂ ସର୍ୱ୍ୱେଷାଂ ୱିଘ୍ନରୂପୋ ଭୱିଷ୍ୟାମି, ଯତୋ ଲିଖିତମାସ୍ତେ, \"ମେଷାଣାଂ ରକ୍ଷକୋ ଯସ୍ତଂ ପ୍ରହରିଷ୍ୟାମ୍ୟହଂ ତତଃ| ମେଷାଣାଂ ନିୱହୋ ନୂନଂ ପ୍ରୱିକୀର୍ଣୋ ଭୱିଷ୍ୟତି\"|| ");
INSERT INTO sanori_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","କିନ୍ତୁ ଶ୍ମଶାନାତ୍ ସମୁତ୍ଥାଯ ଯୁଷ୍ମାକମଗ୍ରେଽହଂ ଗାଲୀଲଂ ଗମିଷ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ପିତରସ୍ତଂ ପ୍ରୋୱାଚ, ଭୱାଂଶ୍ଚେତ୍ ସର୍ୱ୍ୱେଷାଂ ୱିଘ୍ନରୂପୋ ଭୱତି, ତଥାପି ମମ ନ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ତତୋ ଯୀଶୁନା ସ ଉକ୍ତଃ, ତୁଭ୍ୟମହଂ ତଥ୍ୟଂ କଥଯାମି, ଯାମିନ୍ୟାମସ୍ୟାଂ ଚରଣାଯୁଧସ୍ୟ ରୱାତ୍ ପୂର୍ୱ୍ୱଂ ତ୍ୱଂ ମାଂ ତ୍ରି ର୍ନାଙ୍ଗୀକରିଷ୍ୟସି| ");
INSERT INTO sanori_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ତତଃ ପିତର ଉଦିତୱାନ୍, ଯଦ୍ୟପି ତ୍ୱଯା ସମଂ ମର୍ତ୍ତୱ୍ୟଂ, ତଥାପି କଦାପି ତ୍ୱାଂ ନ ନାଙ୍ଗୀକରିଷ୍ୟାମି; ତଥୈୱ ସର୍ୱ୍ୱେ ଶିଷ୍ୟାଶ୍ଚୋଚୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","ଅନନ୍ତରଂ ଯୀଶୁଃ ଶିଷ୍ୟୈଃ ସାକଂ ଗେତ୍ଶିମାନୀନାମକଂ ସ୍ଥାନଂ ପ୍ରସ୍ଥାଯ ତେଭ୍ୟଃ କଥିତୱାନ୍, ଅଦଃ ସ୍ଥାନଂ ଗତ୍ୱା ଯାୱଦହଂ ପ୍ରାର୍ଥଯିଷ୍ୟେ ତାୱଦ୍ ଯୂଯମତ୍ରୋପୱିଶତ| ");
INSERT INTO sanori_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ପଶ୍ଚାତ୍ ସ ପିତରଂ ସିୱଦିଯସୁତୌ ଚ ସଙ୍ଗିନଃ କୃତ୍ୱା ଗତୱାନ୍, ଶୋକାକୁଲୋଽତୀୱ ୱ୍ୟଥିତଶ୍ଚ ବଭୂୱ| ");
INSERT INTO sanori_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ତାନୱାଦୀଚ୍ଚ ମୃତିଯାତନେୱ ମତ୍ପ୍ରାଣାନାଂ ଯାତନା ଜାଯତେ, ଯୂଯମତ୍ର ମଯା ସାର୍ଦ୍ଧଂ ଜାଗୃତ| ");
INSERT INTO sanori_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ତତଃ ସ କିଞ୍ଚିଦ୍ଦୂରଂ ଗତ୍ୱାଧୋମୁଖଃ ପତନ୍ ପ୍ରାର୍ଥଯାଞ୍ଚକ୍ରେ, ହେ ମତ୍ପିତର୍ୟଦି ଭୱିତୁଂ ଶକ୍ନୋତି, ତର୍ହି କଂସୋଽଯଂ ମତ୍ତୋ ଦୂରଂ ଯାତୁ; କିନ୍ତୁ ମଦିଚ୍ଛାୱତ୍ ନ ଭୱତୁ, ତ୍ୱଦିଚ୍ଛାୱଦ୍ ଭୱତୁ| ");
INSERT INTO sanori_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ତତଃ ସ ଶିଷ୍ୟାନୁପେତ୍ୟ ତାନ୍ ନିଦ୍ରତୋ ନିରୀକ୍ଷ୍ୟ ପିତରାଯ କଥଯାମାସ, ଯୂଯଂ ମଯା ସାକଂ ଦଣ୍ଡମେକମପି ଜାଗରିତୁଂ ନାଶନ୍କୁତ? ");
INSERT INTO sanori_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","ପରୀକ୍ଷାଯାଂ ନ ପତିତୁଂ ଜାଗୃତ ପ୍ରାର୍ଥଯଧ୍ୱଞ୍ଚ; ଆତ୍ମା ସମୁଦ୍ୟତୋସ୍ତି, କିନ୍ତୁ ୱପୁ ର୍ଦୁର୍ବ୍ବଲଂ| ");
INSERT INTO sanori_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ସ ଦ୍ୱିତୀଯୱାରଂ ପ୍ରାର୍ଥଯାଞ୍ଚକ୍ରେ, ହେ ମତ୍ତାତ, ନ ପୀତେ ଯଦି କଂସମିଦଂ ମତ୍ତୋ ଦୂରଂ ଯାତୁଂ ନ ଶକ୍ନୋତି, ତର୍ହି ତ୍ୱଦିଚ୍ଛାୱଦ୍ ଭୱତୁ| ");
INSERT INTO sanori_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ସ ପୁନରେତ୍ୟ ତାନ୍ ନିଦ୍ରତୋ ଦଦର୍ଶ, ଯତସ୍ତେଷାଂ ନେତ୍ରାଣି ନିଦ୍ରଯା ପୂର୍ଣାନ୍ୟାସନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ପଶ୍ଚାତ୍ ସ ତାନ୍ ୱିହାଯ ୱ୍ରଜିତ୍ୱା ତୃତୀଯୱାରଂ ପୂର୍ୱ୍ୱୱତ୍ କଥଯନ୍ ପ୍ରାର୍ଥିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ତତଃ ଶିଷ୍ୟାନୁପାଗତ୍ୟ ଗଦିତୱାନ୍, ସାମ୍ପ୍ରତଂ ଶଯାନାଃ କିଂ ୱିଶ୍ରାମ୍ୟଥ? ପଶ୍ୟତ, ସମଯ ଉପାସ୍ଥାତ୍, ମନୁଜସୁତଃ ପାପିନାଂ କରେଷୁ ସମର୍ପ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ଉତ୍ତିଷ୍ଠତ, ୱଯଂ ଯାମଃ, ଯୋ ମାଂ ପରକରେଷୁ ମସର୍ପଯିଷ୍ୟତି, ପଶ୍ୟତ, ସ ସମୀପମାଯାତି| ");
INSERT INTO sanori_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ଏତତ୍କଥାକଥନକାଲେ ଦ୍ୱାଦଶଶିଷ୍ୟାଣାମେକୋ ଯିହୂଦାନାମକୋ ମୁଖ୍ୟଯାଜକଲୋକପ୍ରାଚୀନୈଃ ପ୍ରହିତାନ୍ ଅସିଧାରିଯଷ୍ଟିଧାରିଣୋ ମନୁଜାନ୍ ଗୃହୀତ୍ୱା ତତ୍ସମୀପମୁପତସ୍ଥୌ| ");
INSERT INTO sanori_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ଅସୌ ପରକରେଷ୍ୱର୍ପଯିତା ପୂର୍ୱ୍ୱଂ ତାନ୍ ଇତ୍ଥଂ ସଙ୍କେତଯାମାସ, ଯମହଂ ଚୁମ୍ବିଷ୍ୟେ, ସୋଽସୌ ମନୁଜଃ,ସଏୱ ଯୁଷ୍ମାଭି ର୍ଧାର୍ୟ୍ୟତାଂ| ");
INSERT INTO sanori_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ତଦା ସ ସପଦି ଯୀଶୁମୁପାଗତ୍ୟ ହେ ଗୁରୋ, ପ୍ରଣମାମୀତ୍ୟୁକ୍ତ୍ୱା ତଂ ଚୁଚୁମ୍ବେ| ");
INSERT INTO sanori_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ତଦା ଯୀଶୁସ୍ତମୁୱାଚ, ହେ ମିତ୍ରଂ କିମର୍ଥମାଗତୋସି? ତଦା ତୈରାଗତ୍ୟ ଯୀଶୁରାକ୍ରମ୍ୟ ଦଘ୍ରେ| ");
INSERT INTO sanori_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ତତୋ ଯୀଶୋଃ ସଙ୍ଗିନାମେକଃ କରଂ ପ୍ରସାର୍ୟ୍ୟ କୋଷାଦସିଂ ବହିଷ୍କୃତ୍ୟ ମହାଯାଜକସ୍ୟ ଦାସମେକମାହତ୍ୟ ତସ୍ୟ କର୍ଣଂ ଚିଚ୍ଛେଦ| ");
INSERT INTO sanori_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","ତତୋ ଯୀଶୁସ୍ତଂ ଜଗାଦ, ଖଡ୍ଗଂ ସ୍ୱସ୍ଥାନେे ନିଧେହି ଯତୋ ଯେ ଯେ ଜନା ଅସିଂ ଧାରଯନ୍ତି, ତଏୱାସିନା ୱିନଶ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","ଅପରଂ ପିତା ଯଥା ମଦନ୍ତିକଂ ସ୍ୱର୍ଗୀଯଦୂତାନାଂ ଦ୍ୱାଦଶୱାହିନୀତୋଽଧିକଂ ପ୍ରହିଣୁଯାତ୍ ମଯା ତମୁଦ୍ଦିଶ୍ୟେଦାନୀମେୱ ତଥା ପ୍ରାର୍ଥଯିତୁଂ ନ ଶକ୍ୟତେ, ତ୍ୱଯା କିମିତ୍ଥଂ ଜ୍ଞାଯତେ? ");
INSERT INTO sanori_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","ତଥା ସତୀତ୍ଥଂ ଘଟିଷ୍ୟତେ ଧର୍ମ୍ମପୁସ୍ତକସ୍ୟ ଯଦିଦଂ ୱାକ୍ୟଂ ତତ୍ କଥଂ ସିଧ୍ୟେତ୍? ");
INSERT INTO sanori_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","ତଦାନୀଂ ଯୀଶୁ ର୍ଜନନିୱହଂ ଜଗାଦ, ଯୂଯଂ ଖଡ୍ଗଯଷ୍ଟୀନ୍ ଆଦାଯ ମାଂ କିଂ ଚୌରଂ ଧର୍ତ୍ତୁମାଯାତାଃ? ଅହଂ ପ୍ରତ୍ୟହଂ ଯୁଷ୍ମାଭିଃ ସାକମୁପୱିଶ୍ୟ ସମୁପାଦିଶଂ, ତଦା ମାଂ ନାଧରତ; ");
INSERT INTO sanori_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","କିନ୍ତୁ ଭୱିଷ୍ୟଦ୍ୱାଦିନାଂ ୱାକ୍ୟାନାଂ ସଂସିଦ୍ଧଯେ ସର୍ୱ୍ୱମେତଦଭୂତ୍| ତଦା ସର୍ୱ୍ୱେ ଶିଷ୍ୟାସ୍ତଂ ୱିହାଯ ପଲାଯନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","ଅନନ୍ତରଂ ତେ ମନୁଜା ଯୀଶୁଂ ଧୃତ୍ୱା ଯତ୍ରାଧ୍ୟାପକପ୍ରାଞ୍ଚଃ ପରିଷଦଂ କୁର୍ୱ୍ୱନ୍ତ ଉପାୱିଶନ୍ ତତ୍ର କିଯଫାନାाମକମହାଯାଜକସ୍ୟାନ୍ତିକଂ ନିନ୍ୟୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","କିନ୍ତୁ ଶେଷେ କିଂ ଭୱିଷ୍ୟତୀତି ୱେତ୍ତୁଂ ପିତରୋ ଦୂରେ ତତ୍ପଶ୍ଚାଦ୍ ୱ୍ରଜିତ୍ୱା ମହାଯାଜକସ୍ୟାଟ୍ଟାଲିକାଂ ପ୍ରୱିଶ୍ୟ ଦାସୈଃ ସହିତ ଉପାୱିଶତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ତଦାନୀଂ ପ୍ରଧାନଯାଜକପ୍ରାଚୀନମନ୍ତ୍ରିଣଃ ସର୍ୱ୍ୱେ ଯୀଶୁଂ ହନ୍ତୁଂ ମୃଷାସାକ୍ଷ୍ୟମ୍ ଅଲିପ୍ସନ୍ତ, ");
INSERT INTO sanori_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","କିନ୍ତୁ ନ ଲେଭିରେ| ଅନେକେଷୁ ମୃଷାସାକ୍ଷିଷ୍ୱାଗତେଷ୍ୱପି ତନ୍ନ ପ୍ରାପୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ଶେଷେ ଦ୍ୱୌ ମୃଷାସାକ୍ଷିଣାୱାଗତ୍ୟ ଜଗଦତୁଃ, ପୁମାନଯମକଥଯତ୍, ଅହମୀଶ୍ୱରମନ୍ଦିରଂ ଭଂକ୍ତ୍ୱା ଦିନତ୍ରଯମଧ୍ୟେ ତନ୍ନିର୍ମ୍ମାତୁଂ ଶକ୍ନୋମି| ");
INSERT INTO sanori_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ତଦା ମହାଯାଜକ ଉତ୍ଥାଯ ଯୀଶୁମ୍ ଅୱାଦୀତ୍| ତ୍ୱଂ କିମପି ନ ପ୍ରତିୱଦସି? ତ୍ୱାମଧି କିମେତେ ସାକ୍ଷ୍ୟଂ ୱଦନ୍ତି? ");
INSERT INTO sanori_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","କିନ୍ତୁ ଯୀଶୁ ର୍ମୌନୀଭୂଯ ତସ୍ୟୌ| ତତୋ ମହାଯାଜକ ଉକ୍ତୱାନ୍, ତ୍ୱାମ୍ ଅମରେଶ୍ୱରନାମ୍ନା ଶପଯାମି, ତ୍ୱମୀଶ୍ୱରସ୍ୟ ପୁତ୍ରୋଽଭିଷିକ୍ତୋ ଭୱସି ନୱେତି ୱଦ| ");
INSERT INTO sanori_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ଯୀଶୁଃ ପ୍ରତ୍ୟୱଦତ୍, ତ୍ୱଂ ସତ୍ୟମୁକ୍ତୱାନ୍; ଅହଂ ଯୁଷ୍ମାନ୍ ତଥ୍ୟଂ ୱଦାମି, ଇତଃପରଂ ମନୁଜସୁତଂ ସର୍ୱ୍ୱଶକ୍ତିମତୋ ଦକ୍ଷିଣପାର୍ଶ୍ୱେ ସ୍ଥାତୁଂ ଗଗଣସ୍ଥଂ ଜଲଧରାନାରୁହ୍ୟାଯାନ୍ତଂ ୱୀକ୍ଷଧ୍ୱେ| ");
INSERT INTO sanori_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ତଦା ମହାଯାଜକୋ ନିଜୱସନଂ ଛିତ୍ତ୍ୱା ଜଗାଦ, ଏଷ ଈଶ୍ୱରଂ ନିନ୍ଦିତୱାନ୍, ଅସ୍ମାକମପରସାକ୍ଷ୍ୟେଣ କିଂ ପ୍ରଯୋଜନଂ? ପଶ୍ୟତ, ଯୂଯମେୱାସ୍ୟାସ୍ୟାଦ୍ ଈଶ୍ୱରନିନ୍ଦାଂ ଶ୍ରୁତୱନ୍ତଃ, ");
INSERT INTO sanori_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","ଯୁଷ୍ମାଭିଃ କିଂ ୱିୱିଚ୍ୟତେ? ତେ ପ୍ରତ୍ୟୂଚୁଃ, ୱଧାର୍ହୋଽଯଂ| ");
INSERT INTO sanori_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ତତୋ ଲୋକୈସ୍ତଦାସ୍ୟେ ନିଷ୍ଠୀୱିତଂ କେଚିତ୍ ପ୍ରତଲମାହତ୍ୟ କେଚିଚ୍ଚ ଚପେଟମାହତ୍ୟ ବଭାଷିରେ, ");
INSERT INTO sanori_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ହେ ଖ୍ରୀଷ୍ଟ ତ୍ୱାଂ କଶ୍ଚପେଟମାହତୱାନ୍? ଇତି ଗଣଯିତ୍ୱା ୱଦାସ୍ମାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ପିତରୋ ବହିରଙ୍ଗନ ଉପୱିଶତି, ତଦାନୀମେକା ଦାସୀ ତମୁପାଗତ୍ୟ ବଭାଷେ, ତ୍ୱଂ ଗାଲୀଲୀଯଯୀଶୋଃ ସହଚରଏକଃ| ");
INSERT INTO sanori_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","କିନ୍ତୁ ସ ସର୍ୱ୍ୱେଷାଂ ସମକ୍ଷମ୍ ଅନଙ୍ଗୀକୃତ୍ୟାୱାଦୀତ୍, ତ୍ୱଯା ଯଦୁଚ୍ୟତେ, ତଦର୍ଥମହଂ ନ ୱେଦ୍ମି| ");
INSERT INTO sanori_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ତଦା ତସ୍ମିନ୍ ବହିର୍ଦ୍ୱାରଂ ଗତେ ଽନ୍ୟା ଦାସୀ ତଂ ନିରୀକ୍ଷ୍ୟ ତତ୍ରତ୍ୟଜନାନୱଦତ୍, ଅଯମପି ନାସରତୀଯଯୀଶୁନା ସାର୍ଦ୍ଧମ୍ ଆସୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ତତଃ ସ ଶପଥେନ ପୁନରନଙ୍ଗୀକୃତ୍ୟ କଥିତୱାନ୍, ତଂ ନରଂ ନ ପରିଚିନୋମି| ");
INSERT INTO sanori_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","କ୍ଷଣାତ୍ ପରଂ ତିଷ୍ଠନ୍ତୋ ଜନା ଏତ୍ୟ ପିତରମ୍ ଅୱଦନ୍, ତ୍ୱମୱଶ୍ୟଂ ତେଷାମେକ ଇତି ତ୍ୱଦୁଚ୍ଚାରଣମେୱ ଦ୍ୟୋତଯତି| ");
INSERT INTO sanori_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","କିନ୍ତୁ ସୋଽଭିଶପ୍ୟ କଥିତୱାନ୍, ତଂ ଜନଂ ନାହଂ ପରିଚିନୋମି, ତଦା ସପଦି କୁକ୍କୁଟୋ ରୁରାୱ| ");
INSERT INTO sanori_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","କୁକ୍କୁଟରୱାତ୍ ପ୍ରାକ୍ ତ୍ୱଂ ମାଂ ତ୍ରିରପାହ୍ନୋଷ୍ୟସେ, ଯୈଷା ୱାଗ୍ ଯୀଶୁନାୱାଦି ତାଂ ପିତରଃ ସଂସ୍ମୃତ୍ୟ ବହିରିତ୍ୱା ଖେଦାଦ୍ ଭୃଶଂ ଚକ୍ରନ୍ଦ| ");
INSERT INTO sanori_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ପ୍ରଭାତେ ଜାତେ ପ୍ରଧାନଯାଜକଲୋକପ୍ରାଚୀନା ଯୀଶୁଂ ହନ୍ତୁଂ ତତ୍ପ୍ରତିକୂଲଂ ମନ୍ତ୍ରଯିତ୍ୱା ");
INSERT INTO sanori_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ତଂ ବଦ୍ୱ୍ୱା ନୀତ୍ୱା ପନ୍ତୀଯପୀଲାତାଖ୍ୟାଧିପେ ସମର୍ପଯାମାସୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","ତତୋ ଯୀଶୋଃ ପରକରେୱ୍ୱର୍ପଯିତା ଯିହୂଦାସ୍ତତ୍ପ୍ରାଣାଦଣ୍ଡାଜ୍ଞାଂ ୱିଦିତ୍ୱା ସନ୍ତପ୍ତମନାଃ ପ୍ରଧାନଯାଜକଲୋକପ୍ରାଚୀନାନାଂ ସମକ୍ଷଂ ତାସ୍ତ୍ରୀଂଶନ୍ମୁଦ୍ରାଃ ପ୍ରତିଦାଯାୱାଦୀତ୍, ");
INSERT INTO sanori_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ଏତନ୍ନିରାଗୋନରପ୍ରାଣପରକରାର୍ପଣାତ୍ କଲୁଷଂ କୃତୱାନହଂ| ତଦା ତ ଉଦିତୱନ୍ତଃ, ତେନାସ୍ମାକଂ କିଂ? ତ୍ୱଯା ତଦ୍ ବୁଧ୍ୟତାମ୍| ");
INSERT INTO sanori_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ତତୋ ଯିହୂଦା ମନ୍ଦିରମଧ୍ୟେ ତା ମୁଦ୍ରା ନିକ୍ଷିପ୍ୟ ପ୍ରସ୍ଥିତୱାନ୍ ଇତ୍ୱା ଚ ସ୍ୱଯମାତ୍ମାନମୁଦ୍ବବନ୍ଧ| ");
INSERT INTO sanori_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","ପଶ୍ଚାତ୍ ପ୍ରଧାନଯାଜକାସ୍ତା ମୁଦ୍ରା ଆଦାଯ କଥିତୱନ୍ତଃ, ଏତା ମୁଦ୍ରାଃ ଶୋଣିତମୂଲ୍ୟଂ ତସ୍ମାଦ୍ ଭାଣ୍ଡାଗାରେ ନ ନିଧାତୱ୍ୟାଃ| ");
INSERT INTO sanori_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ଅନନ୍ତରଂ ତେ ମନ୍ତ୍ରଯିତ୍ୱା ୱିଦେଶିନାଂ ଶ୍ମଶାନସ୍ଥାନାଯ ତାଭିଃ କୁଲାଲସ୍ୟ କ୍ଷେତ୍ରମକ୍ରୀଣନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ଅତୋଽଦ୍ୟାପି ତତ୍ସ୍ଥାନଂ ରକ୍ତକ୍ଷେତ୍ରଂ ୱଦନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ଇତ୍ଥଂ ସତି ଇସ୍ରାଯେଲୀଯସନ୍ତାନୈ ର୍ୟସ୍ୟ ମୂଲ୍ୟଂ ନିରୁପିତଂ, ତସ୍ୟ ତ୍ରିଂଶନ୍ମୁଦ୍ରାମାନଂ ମୂଲ୍ୟଂ ");
INSERT INTO sanori_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ମାଂ ପ୍ରତି ପରମେଶ୍ୱରସ୍ୟାଦେଶାତ୍ ତେଭ୍ୟ ଆଦୀଯତ, ତେନ ଚ କୁଲାଲସ୍ୟ କ୍ଷେତ୍ରଂ କ୍ରୀତମିତି ଯଦ୍ୱଚନଂ ଯିରିମିଯଭୱିଷ୍ୟଦ୍ୱାଦିନା ପ୍ରୋକ୍ତଂ ତତ୍ ତଦାସିଧ୍ୟତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ଅନନ୍ତରଂ ଯୀଶୌ ତଦଧିପତେଃ ସମ୍ମୁଖ ଉପତିଷ୍ଠତି ସ ତଂ ପପ୍ରଚ୍ଛ, ତ୍ୱଂ କିଂ ଯିହୂଦୀଯାନାଂ ରାଜା? ତଦା ଯୀଶୁସ୍ତମୱଦତ୍, ତ୍ୱଂ ସତ୍ୟମୁକ୍ତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","କିନ୍ତୁ ପ୍ରଧାନଯାଜକପ୍ରାଚୀନୈରଭିଯୁକ୍ତେନ ତେନ କିମପି ନ ପ୍ରତ୍ୟୱାଦି| ");
INSERT INTO sanori_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","ତତଃ ପୀଲାତେନ ସ ଉଦିତଃ, ଇମେ ତ୍ୱତ୍ପ୍ରତିକୂଲତଃ କତି କତି ସାକ୍ଷ୍ୟଂ ଦଦତି, ତତ୍ ତ୍ୱଂ ନ ଶୃଣୋଷି? ");
INSERT INTO sanori_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","ତଥାପି ସ ତେଷାମେକସ୍ୟାପି ୱଚସ ଉତ୍ତରଂ ନୋଦିତୱାନ୍; ତେନ ସୋଽଧିପତି ର୍ମହାଚିତ୍ରଂ ୱିଦାମାସ| ");
INSERT INTO sanori_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","ଅନ୍ୟଚ୍ଚ ତନ୍ମହକାଲେଽଧିପତେରେତାଦୃଶୀ ରାତିରାସୀତ୍, ପ୍ରଜା ଯଂ କଞ୍ଚନ ବନ୍ଧିନଂ ଯାଚନ୍ତେ, ତମେୱ ସ ମୋଚଯତୀତି| ");
INSERT INTO sanori_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ତଦାନୀଂ ବରବ୍ବାନାମା କଶ୍ଚିତ୍ ଖ୍ୟାତବନ୍ଧ୍ୟାସୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ତତଃ ପୀଲାତସ୍ତତ୍ର ମିଲିତାନ୍ ଲୋକାନ୍ ଅପୃଚ୍ଛତ୍, ଏଷ ବରବ୍ବା ବନ୍ଧୀ ଖ୍ରୀଷ୍ଟୱିଖ୍ୟାତୋ ଯୀଶୁଶ୍ଚୈତଯୋଃ କଂ ମୋଚଯିଷ୍ୟାମି? ଯୁଷ୍ମାକଂ କିମୀପ୍ସିତଂ? ");
INSERT INTO sanori_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","ତୈରୀର୍ଷ୍ୟଯା ସ ସମର୍ପିତ ଇତି ସ ଜ୍ଞାତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ଅପରଂ ୱିଚାରାସନୋପୱେଶନକାଲେ ପୀଲାତସ୍ୟ ପତ୍ନୀ ଭୃତ୍ୟଂ ପ୍ରହିତ୍ୟ ତସ୍ମୈ କଥଯାମାସ, ତଂ ଧାର୍ମ୍ମିକମନୁଜଂ ପ୍ରତି ତ୍ୱଯା କିମପି ନ କର୍ତ୍ତୱ୍ୟଂ; ଯସ୍ମାତ୍ ତତ୍କୃତେଽଦ୍ୟାହଂ ସ୍ୱପ୍ନେ ପ୍ରଭୂତକଷ୍ଟମଲଭେ| ");
INSERT INTO sanori_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","ଅନନ୍ତରଂ ପ୍ରଧାନଯାଜକପ୍ରାଚୀନା ବରବ୍ବାଂ ଯାଚିତ୍ୱାଦାତୁଂ ଯୀଶୁଞ୍ଚ ହନ୍ତୁଂ ସକଲଲୋକାନ୍ ପ୍ରାୱର୍ତ୍ତଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ତତୋଽଧିପତିସ୍ତାନ୍ ପୃଷ୍ଟୱାନ୍, ଏତଯୋଃ କମହଂ ମୋଚଯିଷ୍ୟାମି? ଯୁଷ୍ମାକଂ କେଚ୍ଛା? ତେ ପ୍ରୋଚୁ ର୍ବରବ୍ବାଂ| ");
INSERT INTO sanori_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ତଦା ପୀଲାତଃ ପପ୍ରଚ୍ଛ, ତର୍ହି ଯଂ ଖ୍ରୀଷ୍ଟଂ ୱଦନ୍ତି, ତଂ ଯୀଶୁଂ କିଂ କରିଷ୍ୟାମି? ସର୍ୱ୍ୱେ କଥଯାମାସୁଃ, ସ କ୍ରୁଶେନ ୱିଧ୍ୟତାଂ| ");
INSERT INTO sanori_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ତତୋଽଧିପତିରୱାଦୀତ୍, କୁତଃ? କିଂ ତେନାପରାଦ୍ଧଂ? କିନ୍ତୁ ତେ ପୁନରୁଚୈ ର୍ଜଗଦୁଃ, ସ କ୍ରୁଶେନ ୱିଧ୍ୟତାଂ| ");
INSERT INTO sanori_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ତଦା ନିଜୱାକ୍ୟମଗ୍ରାହ୍ୟମଭୂତ୍, କଲହଶ୍ଚାପ୍ୟଭୂତ୍, ପୀଲାତ ଇତି ୱିଲୋକ୍ୟ ଲୋକାନାଂ ସମକ୍ଷଂ ତୋଯମାଦାଯ କରୌ ପ୍ରକ୍ଷାଲ୍ୟାୱୋଚତ୍, ଏତସ୍ୟ ଧାର୍ମ୍ମିକମନୁଷ୍ୟସ୍ୟ ଶୋଣିତପାତେ ନିର୍ଦୋଷୋଽହଂ, ଯୁଷ୍ମାଭିରେୱ ତଦ୍ ବୁଧ୍ୟତାଂ| ");
INSERT INTO sanori_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ତଦା ସର୍ୱ୍ୱାଃ ପ୍ରଜାଃ ପ୍ରତ୍ୟୱୋଚନ୍, ତସ୍ୟ ଶୋଣିତପାତାପରାଧୋଽସ୍ମାକମ୍ ଅସ୍ମତ୍ସନ୍ତାନାନାଞ୍ଚୋପରି ଭୱତୁ| ");
INSERT INTO sanori_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","ତତଃ ସ ତେଷାଂ ସମୀପେ ବରବ୍ବାଂ ମୋଚଯାମାସ ଯୀଶୁନ୍ତୁ କଷାଭିରାହତ୍ୟ କ୍ରୁଶେନ ୱେଧିତୁଂ ସମର୍ପଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","ଅନନ୍ତରମ୍ ଅଧିପତେଃ ସେନା ଅଧିପତେ ର୍ଗୃହଂ ଯୀଶୁମାନୀଯ ତସ୍ୟ ସମୀପେ ସେନାସମୂହଂ ସଂଜଗୃହୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ତତସ୍ତେ ତସ୍ୟ ୱସନଂ ମୋଚଯିତ୍ୱା କୃଷ୍ଣଲୋହିତୱର୍ଣୱସନଂ ପରିଧାପଯାମାସୁଃ ");
INSERT INTO sanori_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","କଣ୍ଟକାନାଂ ମୁକୁଟଂ ନିର୍ମ୍ମାଯ ତଚ୍ଛିରସି ଦଦୁଃ, ତସ୍ୟ ଦକ୍ଷିଣକରେ ୱେତ୍ରମେକଂ ଦତ୍ତ୍ୱା ତସ୍ୟ ସମ୍ମୁଖେ ଜାନୂନି ପାତଯିତ୍ୱା, ହେ ଯିହୂଦୀଯାନାଂ ରାଜନ୍, ତୁଭ୍ୟଂ ନମ ଇତ୍ୟୁକ୍ତ୍ୱା ତଂ ତିରଶ୍ଚକ୍ରୁଃ, ");
INSERT INTO sanori_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ତତସ୍ତସ୍ୟ ଗାତ୍ରେ ନିଷ୍ଠୀୱଂ ଦତ୍ୱା ତେନ ୱେତ୍ରେଣ ଶିର ଆଜଘ୍ନୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ଇତ୍ଥଂ ତଂ ତିରସ୍କୃତ୍ୟ ତଦ୍ ୱସନଂ ମୋଚଯିତ୍ୱା ପୁନର୍ନିଜୱସନଂ ପରିଧାପଯାଞ୍ଚକ୍ରୁଃ, ତଂ କ୍ରୁଶେନ ୱେଧିତୁଂ ନୀତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ପଶ୍ଚାତ୍ତେ ବହିର୍ଭୂଯ କୁରୀଣୀଯଂ ଶିମୋନ୍ନାମକମେକଂ ୱିଲୋକ୍ୟ କ୍ରୁଶଂ ୱୋଢୁଂ ତମାଦଦିରେ| ");
INSERT INTO sanori_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ଅନନ୍ତରଂ ଗୁଲ୍ଗଲ୍ତାମ୍ ଅର୍ଥାତ୍ ଶିରସ୍କପାଲନାମକସ୍ଥାନମୁ ପସ୍ଥାଯ ତେ ଯୀଶୱେ ପିତ୍ତମିଶ୍ରିତାମ୍ଲରସଂ ପାତୁଂ ଦଦୁଃ, ");
INSERT INTO sanori_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","କିନ୍ତୁ ସ ତମାସ୍ୱାଦ୍ୟ ନ ପପୌ| ");
INSERT INTO sanori_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ତଦାନୀଂ ତେ ତଂ କ୍ରୁଶେନ ସଂୱିଧ୍ୟ ତସ୍ୟ ୱସନାନି ଗୁଟିକାପାତେନ ୱିଭଜ୍ୟ ଜଗୃହୁଃ, ତସ୍ମାତ୍, ୱିଭଜନ୍ତେଽଧରୀଯଂ ମେ ତେ ମନୁଷ୍ୟାଃ ପରସ୍ପରଂ| ମଦୁତ୍ତରୀଯୱସ୍ତ୍ରାର୍ଥଂ ଗୁଟିକାଂ ପାତଯନ୍ତି ଚ|| ଯଦେତଦ୍ୱଚନଂ ଭୱିଷ୍ୟଦ୍ୱାଦିଭିରୁକ୍ତମାସୀତ୍, ତଦା ତଦ୍ ଅସିଧ୍ୟତ୍, ");
INSERT INTO sanori_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ପଶ୍ଚାତ୍ ତେ ତତ୍ରୋପୱିଶ୍ୟ ତଦ୍ରକ୍ଷଣକର୍ୱ୍ୱଣି ନିଯୁକ୍ତାସ୍ତସ୍ଥୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ଅପରମ୍ ଏଷ ଯିହୂଦୀଯାନାଂ ରାଜା ଯୀଶୁରିତ୍ୟପୱାଦଲିପିପତ୍ରଂ ତଚ୍ଛିରସ ଊର୍ଦ୍ୱ୍ୱେ ଯୋଜଯାମାସୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ତତସ୍ତସ୍ୟ ୱାମେ ଦକ୍ଷିଣେ ଚ ଦ୍ୱୌ ଚୈରୌ ତେନ ସାକଂ କ୍ରୁଶେନ ୱିୱିଧୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","ତଦା ପାନ୍ଥା ନିଜଶିରୋ ଲାଡଯିତ୍ୱା ତଂ ନିନ୍ଦନ୍ତୋ ଜଗଦୁଃ, ");
INSERT INTO sanori_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ହେ ଈଶ୍ୱରମନ୍ଦିରଭଞ୍ଜକ ଦିନତ୍ରଯେ ତନ୍ନିର୍ମ୍ମାତଃ ସ୍ୱଂ ରକ୍ଷ, ଚେତ୍ତ୍ୱମୀଶ୍ୱରସୁତସ୍ତର୍ହି କ୍ରୁଶାଦୱରୋହ| ");
INSERT INTO sanori_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ପ୍ରଧାନଯାଜକାଧ୍ୟାପକପ୍ରାଚୀନାଶ୍ଚ ତଥା ତିରସ୍କୃତ୍ୟ ଜଗଦୁଃ, ");
INSERT INTO sanori_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","ସୋଽନ୍ୟଜନାନାୱତ୍, କିନ୍ତୁ ସ୍ୱମୱିତୁଂ ନ ଶକ୍ନୋତି| ଯଦୀସ୍ରାଯେଲୋ ରାଜା ଭୱେତ୍, ତର୍ହୀଦାନୀମେୱ କ୍ରୁଶାଦୱରୋହତୁ, ତେନ ତଂ ୱଯଂ ପ୍ରତ୍ୟେଷ୍ୟାମଃ| ");
INSERT INTO sanori_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ସ ଈଶ୍ୱରେ ପ୍ରତ୍ୟାଶାମକରୋତ୍, ଯଦୀଶ୍ୱରସ୍ତସ୍ମିନ୍ ସନ୍ତୁଷ୍ଟସ୍ତର୍ହୀଦାନୀମେୱ ତମୱେତ୍, ଯତଃ ସ ଉକ୍ତୱାନ୍ ଅହମୀଶ୍ୱରସୁତଃ| ");
INSERT INTO sanori_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ଯୌ ସ୍ତେନୌ ସାକଂ ତେନ କ୍ରୁଶେନ ୱିଦ୍ଧୌ ତୌ ତଦ୍ୱଦେୱ ତଂ ନିନିନ୍ଦତୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","ତଦା ଦ୍ୱିତୀଯଯାମାତ୍ ତୃତୀଯଯାମଂ ଯାୱତ୍ ସର୍ୱ୍ୱଦେଶେ ତମିରଂ ବଭୂୱ, ");
INSERT INTO sanori_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ତୃତୀଯଯାମେ \"ଏଲୀ ଏଲୀ ଲାମା ଶିୱକ୍ତନୀ\", ଅର୍ଥାତ୍ ମଦୀଶ୍ୱର ମଦୀଶ୍ୱର କୁତୋ ମାମତ୍ୟାକ୍ଷୀଃ? ଯୀଶୁରୁଚ୍ଚୈରିତି ଜଗାଦ| ");
INSERT INTO sanori_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ତଦା ତତ୍ର ସ୍ଥିତାଃ କେଚିତ୍ ତତ୍ ଶ୍ରୁତ୍ୱା ବଭାଷିରେ, ଅଯମ୍ ଏଲିଯମାହୂଯତି| ");
INSERT INTO sanori_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ତେଷାଂ ମଧ୍ୟାଦ୍ ଏକଃ ଶୀଘ୍ରଂ ଗତ୍ୱା ସ୍ପଞ୍ଜଂ ଗୃହୀତ୍ୱା ତତ୍ରାମ୍ଲରସଂ ଦତ୍ତ୍ୱା ନଲେନ ପାତୁଂ ତସ୍ମୈ ଦଦୌ| ");
INSERT INTO sanori_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ଇତରେଽକଥଯନ୍ ତିଷ୍ଠତ, ତଂ ରକ୍ଷିତୁମ୍ ଏଲିଯ ଆଯାତି ନୱେତି ପଶ୍ୟାମଃ| ");
INSERT INTO sanori_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","ଯୀଶୁଃ ପୁନରୁଚୈରାହୂଯ ପ୍ରାଣାନ୍ ଜହୌ| ");
INSERT INTO sanori_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","ତତୋ ମନ୍ଦିରସ୍ୟ ୱିଚ୍ଛେଦୱସନମ୍ ଊର୍ଦ୍ୱ୍ୱାଦଧୋ ଯାୱତ୍ ଛିଦ୍ୟମାନଂ ଦ୍ୱିଧାଭୱତ୍, ");
INSERT INTO sanori_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ଭୂମିଶ୍ଚକମ୍ପେ ଭୂଧରୋୱ୍ୟଦୀର୍ୟ୍ୟତ ଚ| ଶ୍ମଶାନେ ମୁକ୍ତେ ଭୂରିପୁଣ୍ୟୱତାଂ ସୁପ୍ତଦେହା ଉଦତିଷ୍ଠନ୍, ");
INSERT INTO sanori_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ଶ୍ମଶାନାଦ୍ ୱହିର୍ଭୂଯ ତଦୁତ୍ଥାନାତ୍ ପରଂ ପୁଣ୍ୟପୁରଂ ଗତ୍ୱା ବହୁଜନାନ୍ ଦର୍ଶଯାମାସୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ଯୀଶୁରକ୍ଷଣାଯ ନିଯୁକ୍ତଃ ଶତସେନାପତିସ୍ତତ୍ସଙ୍ଗିନଶ୍ଚ ତାଦୃଶୀଂ ଭୂକମ୍ପାଦିଘଟନାଂ ଦୃଷ୍ଟ୍ୱା ଭୀତା ଅୱଦନ୍, ଏଷ ଈଶ୍ୱରପୁତ୍ରୋ ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ଯା ବହୁଯୋଷିତୋ ଯୀଶୁଂ ସେୱମାନା ଗାଲୀଲସ୍ତତ୍ପଶ୍ଚାଦାଗତାସ୍ତାସାଂ ମଧ୍ୟେ ");
INSERT INTO sanori_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ମଗ୍ଦଲୀନୀ ମରିଯମ୍ ଯାକୂବ୍ୟୋଶ୍ୟୋ ର୍ମାତା ଯା ମରିଯମ୍ ସିବଦିଯପୁତ୍ରଯୋ ର୍ମାତା ଚ ଯୋଷିତ ଏତା ଦୂରେ ତିଷ୍ଠନ୍ତ୍ୟୋ ଦଦୃଶୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","ସନ୍ଧ୍ୟାଯାଂ ସତ୍ୟମ୍ ଅରିମଥିଯାନଗରସ୍ୟ ଯୂଷଫ୍ନାମା ଧନୀ ମନୁଜୋ ଯୀଶୋଃ ଶିଷ୍ୟତ୍ୱାତ୍ ");
INSERT INTO sanori_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ପୀଲାତସ୍ୟ ସମୀପଂ ଗତ୍ୱା ଯୀଶୋଃ କାଯଂ ଯଯାଚେ, ତେନ ପୀଲାତଃ କାଯଂ ଦାତୁମ୍ ଆଦିଦେଶ| ");
INSERT INTO sanori_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ଯୂଷଫ୍ ତତ୍କାଯଂ ନୀତ୍ୱା ଶୁଚିୱସ୍ତ୍ରେଣାଚ୍ଛାଦ୍ୟ ");
INSERT INTO sanori_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ସ୍ୱାର୍ଥଂ ଶୈଲେ ଯତ୍ ଶ୍ମଶାନଂ ଚଖାନ, ତନ୍ମଧ୍ୟେ ତତ୍କାଯଂ ନିଧାଯ ତସ୍ୟ ଦ୍ୱାରି ୱୃହତ୍ପାଷାଣଂ ଦଦୌ| ");
INSERT INTO sanori_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","କିନ୍ତୁ ମଗ୍ଦଲୀନୀ ମରିଯମ୍ ଅନ୍ୟମରିଯମ୍ ଏତେ ସ୍ତ୍ରିଯୌ ତତ୍ର ଶ୍ମଶାନସମ୍ମୁଖ ଉପୱିୱିଶତୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","ତଦନନ୍ତରଂ ନିସ୍ତାରୋତ୍ସୱସ୍ୟାଯୋଜନଦିନାତ୍ ପରେଽହନି ପ୍ରଧାନଯାଜକାଃ ଫିରୂଶିନଶ୍ଚ ମିଲିତ୍ୱା ପୀଲାତମୁପାଗତ୍ୟାକଥଯନ୍, ");
INSERT INTO sanori_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ହେ ମହେଚ୍ଛ ସ ପ୍ରତାରକୋ ଜୀୱନ ଅକଥଯତ୍, ଦିନତ୍ରଯାତ୍ ପରଂ ଶ୍ମଶାନାଦୁତ୍ଥାସ୍ୟାମି ତଦ୍ୱାକ୍ୟଂ ସ୍ମରାମୋ ୱଯଂ; ");
INSERT INTO sanori_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ତସ୍ମାତ୍ ତୃତୀଯଦିନଂ ଯାୱତ୍ ତତ୍ ଶ୍ମଶାନଂ ରକ୍ଷିତୁମାଦିଶତୁ, ନୋଚେତ୍ ତଚ୍ଛିଷ୍ୟା ଯାମିନ୍ୟାମାଗତ୍ୟ ତଂ ହୃତ୍ୱା ଲୋକାନ୍ ୱଦିଷ୍ୟନ୍ତି, ସ ଶ୍ମଶାନାଦୁଦତିଷ୍ଠତ୍, ତଥା ସତି ପ୍ରଥମଭ୍ରାନ୍ତେଃ ଶେଷୀଯଭ୍ରାନ୍ତି ର୍ମହତୀ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ତଦା ପୀଲାତ ଅୱାଦୀତ୍, ଯୁଷ୍ମାକଂ ସମୀପେ ରକ୍ଷିଗଣ ଆସ୍ତେ, ଯୂଯଂ ଗତ୍ୱା ଯଥା ସାଧ୍ୟଂ ରକ୍ଷଯତ| ");
INSERT INTO sanori_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ତତସ୍ତେ ଗତ୍ୱା ତଦ୍ଦୂाରପାଷାଣଂ ମୁଦ୍ରାଙ୍କିତଂ କୃତ୍ୱା ରକ୍ଷିଗଣଂ ନିଯୋଜ୍ୟ ଶ୍ମଶାନଂ ରକ୍ଷଯାମାସୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ତତଃ ପରଂ ୱିଶ୍ରାମୱାରସ୍ୟ ଶେଷେ ସପ୍ତାହପ୍ରଥମଦିନସ୍ୟ ପ୍ରଭୋତେ ଜାତେ ମଗ୍ଦଲୀନୀ ମରିଯମ୍ ଅନ୍ୟମରିଯମ୍ ଚ ଶ୍ମଶାନଂ ଦ୍ରଷ୍ଟୁମାଗତା| ");
INSERT INTO sanori_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ତଦା ମହାନ୍ ଭୂକମ୍ପୋଽଭୱତ୍; ପରମେଶ୍ୱରୀଯଦୂତଃ ସ୍ୱର୍ଗାଦୱରୁହ୍ୟ ଶ୍ମଶାନଦ୍ୱାରାତ୍ ପାଷାଣମପସାର୍ୟ୍ୟ ତଦୁପର୍ୟ୍ୟୁପୱିୱେଶ| ");
INSERT INTO sanori_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ତଦ୍ୱଦନଂ ୱିଦ୍ୟୁଦ୍ୱତ୍ ତେଜୋମଯଂ ୱସନଂ ହିମଶୁଭ୍ରଞ୍ଚ| ");
INSERT INTO sanori_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ତଦାନୀଂ ରକ୍ଷିଣସ୍ତଦ୍ଭଯାତ୍ କମ୍ପିତା ମୃତୱଦ୍ ବଭୂୱଃ| ");
INSERT INTO sanori_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ସ ଦୂତୋ ଯୋଷିତୋ ଜଗାଦ, ଯୂଯଂ ମା ଭୈଷ୍ଟ, କ୍ରୁଶହତଯୀଶୁଂ ମୃଗଯଧ୍ୱେ ତଦହଂ ୱେଦ୍ମି| ");
INSERT INTO sanori_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ସୋଽତ୍ର ନାସ୍ତି, ଯଥାୱଦତ୍ ତଥୋତ୍ଥିତୱାନ୍; ଏତତ୍ ପ୍ରଭୋଃ ଶଯନସ୍ଥାନଂ ପଶ୍ୟତ| ");
INSERT INTO sanori_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ତୂର୍ଣଂ ଗତ୍ୱା ତଚ୍ଛିଷ୍ୟାନ୍ ଇତି ୱଦତ, ସ ଶ୍ମଶାନାଦ୍ ଉଦତିଷ୍ଠତ୍, ଯୁଷ୍ମାକମଗ୍ରେ ଗାଲୀଲଂ ଯାସ୍ୟତି ଯୂଯଂ ତତ୍ର ତଂ ୱୀକ୍ଷିଷ୍ୟଧ୍ୱେ, ପଶ୍ୟତାହଂ ୱାର୍ତ୍ତାମିମାଂ ଯୁଷ୍ମାନୱାଦିଷଂ| ");
INSERT INTO sanori_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ତତସ୍ତା ଭଯାତ୍ ମହାନନ୍ଦାଞ୍ଚ ଶ୍ମଶାନାତ୍ ତୂର୍ଣଂ ବହିର୍ଭୂଯ ତଚ୍ଛିଷ୍ୟାନ୍ ୱାର୍ତ୍ତାଂ ୱକ୍ତୁଂ ଧାୱିତୱତ୍ୟଃ| କିନ୍ତୁ ଶିଷ୍ୟାନ୍ ୱାର୍ତ୍ତାଂ ୱକ୍ତୁଂ ଯାନ୍ତି, ତଦା ଯୀଶୁ ର୍ଦର୍ଶନଂ ଦତ୍ତ୍ୱା ତା ଜଗାଦ, ");
INSERT INTO sanori_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ଯୁଷ୍ମାକଂ କଲ୍ୟାଣଂ ଭୂଯାତ୍, ତତସ୍ତା ଆଗତ୍ୟ ତତ୍ପାଦଯୋଃ ପତିତ୍ୱା ପ୍ରଣେମୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","ଯୀଶୁସ୍ତା ଅୱାଦୀତ୍, ମା ବିଭୀତ, ଯୂଯଂ ଗତ୍ୱା ମମ ଭ୍ରାତୃନ୍ ଗାଲୀଲଂ ଯାତୁଂ ୱଦତ, ତତ୍ର ତେ ମାଂ ଦ୍ରକ୍ଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","ସ୍ତ୍ରିଯୋ ଗଚ୍ଛନ୍ତି, ତଦା ରକ୍ଷିଣାଂ କେଚିତ୍ ପୁରଂ ଗତ୍ୱା ଯଦ୍ୟଦ୍ ଘଟିତଂ ତତ୍ସର୍ୱ୍ୱଂ ପ୍ରଧାନଯାଜକାନ୍ ଜ୍ଞାପିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ତେ ପ୍ରାଚୀନୈଃ ସମଂ ସଂସଦଂ କୃତ୍ୱା ମନ୍ତ୍ରଯନ୍ତୋ ବହୁମୁଦ୍ରାଃ ସେନାଭ୍ୟୋ ଦତ୍ତ୍ୱାୱଦନ୍, ");
INSERT INTO sanori_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ଅସ୍ମାସୁ ନିଦ୍ରିତେଷୁ ତଚ୍ଛିଷ୍ୟା ଯାମିନ୍ୟାମାଗତ୍ୟ ତଂ ହୃତ୍ୱାନଯନ୍, ଇତି ଯୂଯଂ ପ୍ରଚାରଯତ| ");
INSERT INTO sanori_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ଯଦ୍ୟେତଦଧିପତେଃ ଶ୍ରୋତ୍ରଗୋଚରୀଭୱେତ୍, ତର୍ହି ତଂ ବୋଧଯିତ୍ୱା ଯୁଷ୍ମାନୱିଷ୍ୟାମଃ| ");
INSERT INTO sanori_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","ତତସ୍ତେ ମୁଦ୍ରା ଗୃହୀତ୍ୱା ଶିକ୍ଷାନୁରୂପଂ କର୍ମ୍ମ ଚକ୍ରୁଃ, ଯିହୂଦୀଯାନାଂ ମଧ୍ୟେ ତସ୍ୟାଦ୍ୟାପି କିଂୱଦନ୍ତୀ ୱିଦ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ଏକାଦଶ ଶିଷ୍ୟା ଯୀଶୁନିରୂପିତାଗାଲୀଲସ୍ୟାଦ୍ରିଂ ଗତ୍ୱା ");
INSERT INTO sanori_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ତତ୍ର ତଂ ସଂୱୀକ୍ଷ୍ୟ ପ୍ରଣେମୁଃ, କିନ୍ତୁ କେଚିତ୍ ସନ୍ଦିଗ୍ଧୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ଯୀଶୁସ୍ତେଷାଂ ସମୀପମାଗତ୍ୟ ୱ୍ୟାହୃତୱାନ୍, ସ୍ୱର୍ଗମେଦିନ୍ୟୋଃ ସର୍ୱ୍ୱାଧିପତିତ୍ୱଭାରୋ ମଯ୍ୟର୍ପିତ ଆସ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ଅତୋ ଯୂଯଂ ପ୍ରଯାଯ ସର୍ୱ୍ୱଦେଶୀଯାନ୍ ଶିଷ୍ୟାନ୍ କୃତ୍ୱା ପିତୁଃ ପୁତ୍ରସ୍ୟ ପୱିତ୍ରସ୍ୟାତ୍ମନଶ୍ଚ ନାମ୍ନା ତାନୱଗାହଯତ; ଅହଂ ଯୁଷ୍ମାନ୍ ଯଦ୍ୟଦାଦିଶଂ ତଦପି ପାଲଯିତୁଂ ତାନୁପାଦିଶତ| ");
INSERT INTO sanori_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ପଶ୍ୟତ, ଜଗଦନ୍ତଂ ଯାୱତ୍ ସଦାହଂ ଯୁଷ୍ମାଭିଃ ସାକଂ ତିଷ୍ଠାମି| ଇତି|");
INSERT INTO sanori_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ଈଶ୍ୱରପୁତ୍ରସ୍ୟ ଯୀଶୁଖ୍ରୀଷ୍ଟସ୍ୟ ସୁସଂୱାଦାରମ୍ଭଃ| ");
INSERT INTO sanori_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ଭୱିଷ୍ୟଦ୍ୱାଦିନାଂ ଗ୍ରନ୍ଥେଷୁ ଲିପିରିତ୍ଥମାସ୍ତେ, ପଶ୍ୟ ସ୍ୱକୀଯଦୂତନ୍ତୁ ତୱାଗ୍ରେ ପ୍ରେଷଯାମ୍ୟହମ୍| ଗତ୍ୱା ତ୍ୱଦୀଯପନ୍ଥାନଂ ସ ହି ପରିଷ୍କରିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","\"ପରମେଶସ୍ୟ ପନ୍ଥାନଂ ପରିଷ୍କୁରୁତ ସର୍ୱ୍ୱତଃ| ତସ୍ୟ ରାଜପଥଞ୍ଚୈୱ ସମାନଂ କୁରୁତାଧୁନା| \" ଇତ୍ୟେତତ୍ ପ୍ରାନ୍ତରେ ୱାକ୍ୟଂ ୱଦତଃ କସ୍ୟଚିଦ୍ରୱଃ|| ");
INSERT INTO sanori_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","ସଏୱ ଯୋହନ୍ ପ୍ରାନ୍ତରେ ମଜ୍ଜିତୱାନ୍ ତଥା ପାପମାର୍ଜନନିମିତ୍ତଂ ମନୋୱ୍ୟାୱର୍ତ୍ତକମଜ୍ଜନସ୍ୟ କଥାଞ୍ଚ ପ୍ରଚାରିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ତତୋ ଯିହୂଦାଦେଶଯିରୂଶାଲମ୍ନଗରନିୱାସିନଃ ସର୍ୱ୍ୱେ ଲୋକା ବହି ର୍ଭୂତ୍ୱା ତସ୍ୟ ସମୀପମାଗତ୍ୟ ସ୍ୱାନି ସ୍ୱାନି ପାପାନ୍ୟଙ୍ଗୀକୃତ୍ୟ ଯର୍ଦ୍ଦନନଦ୍ୟାଂ ତେନ ମଜ୍ଜିତା ବଭୂୱୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ଅସ୍ୟ ଯୋହନଃ ପରିଧେଯାନି କ୍ରମେଲକଲୋମଜାନି, ତସ୍ୟ କଟିବନ୍ଧନଂ ଚର୍ମ୍ମଜାତମ୍, ତସ୍ୟ ଭକ୍ଷ୍ୟାଣି ଚ ଶୂକକୀଟା ୱନ୍ୟମଧୂନି ଚାସନ୍| ");
INSERT INTO sanori_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ସ ପ୍ରଚାରଯନ୍ କଥଯାଞ୍ଚକ୍ରେ, ଅହଂ ନମ୍ରୀଭୂଯ ଯସ୍ୟ ପାଦୁକାବନ୍ଧନଂ ମୋଚଯିତୁମପି ନ ଯୋଗ୍ୟୋସ୍ମି, ତାଦୃଶୋ ମତ୍ତୋ ଗୁରୁତର ଏକଃ ପୁରୁଷୋ ମତ୍ପଶ୍ଚାଦାଗଚ୍ଛତି| ");
INSERT INTO sanori_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ଅହଂ ଯୁଷ୍ମାନ୍ ଜଲେ ମଜ୍ଜିତୱାନ୍ କିନ୍ତୁ ସ ପୱିତ୍ର ଆତ୍ମାନି ସଂମଜ୍ଜଯିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","ଅପରଞ୍ଚ ତସ୍ମିନ୍ନେୱ କାଲେ ଗାଲୀଲ୍ପ୍ରଦେଶସ୍ୟ ନାସରଦ୍ଗ୍ରାମାଦ୍ ଯୀଶୁରାଗତ୍ୟ ଯୋହନା ଯର୍ଦ୍ଦନନଦ୍ୟାଂ ମଜ୍ଜିତୋଽଭୂତ୍| ");
INSERT INTO sanori_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ସ ଜଲାଦୁତ୍ଥିତମାତ୍ରୋ ମେଘଦ୍ୱାରଂ ମୁକ୍ତଂ କପୋତୱତ୍ ସ୍ୱସ୍ୟୋପରି ଅୱରୋହନ୍ତମାତ୍ମାନଞ୍ଚ ଦୃଷ୍ଟୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ତ୍ୱଂ ମମ ପ୍ରିଯଃ ପୁତ୍ରସ୍ତ୍ୱଯ୍ୟେୱ ମମମହାସନ୍ତୋଷ ଇଯମାକାଶୀଯା ୱାଣୀ ବଭୂୱ| ");
INSERT INTO sanori_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","ତସ୍ମିନ୍ କାଲେ ଆତ୍ମା ତଂ ପ୍ରାନ୍ତରମଧ୍ୟଂ ନିନାଯ| ");
INSERT INTO sanori_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ଅଥ ସ ଚତ୍ୱାରିଂଶଦ୍ଦିନାନି ତସ୍ମିନ୍ ସ୍ଥାନେ ୱନ୍ୟପଶୁଭିଃ ସହ ତିଷ୍ଠନ୍ ଶୈତାନା ପରୀକ୍ଷିତଃ; ପଶ୍ଚାତ୍ ସ୍ୱର୍ଗୀଯଦୂତାସ୍ତଂ ସିଷେୱିରେ| ");
INSERT INTO sanori_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","ଅନନ୍ତରଂ ଯୋହନି ବନ୍ଧନାଲଯେ ବଦ୍ଧେ ସତି ଯୀଶୁ ର୍ଗାଲୀଲ୍ପ୍ରଦେଶମାଗତ୍ୟ ଈଶ୍ୱରରାଜ୍ୟସ୍ୟ ସୁସଂୱାଦଂ ପ୍ରଚାରଯନ୍ କଥଯାମାସ, ");
INSERT INTO sanori_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","କାଲଃ ସମ୍ପୂର୍ଣ ଈଶ୍ୱରରାଜ୍ୟଞ୍ଚ ସମୀପମାଗତଂ; ଅତୋହେତୋ ର୍ୟୂଯଂ ମନାଂସି ୱ୍ୟାୱର୍ତ୍ତଯଧ୍ୱଂ ସୁସଂୱାଦେ ଚ ୱିଶ୍ୱାସିତ| ");
INSERT INTO sanori_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ତଦନନ୍ତରଂ ସ ଗାଲୀଲୀଯସମୁଦ୍ରସ୍ୟ ତୀରେ ଗଚ୍ଛନ୍ ଶିମୋନ୍ ତସ୍ୟ ଭ୍ରାତା ଅନ୍ଦ୍ରିଯନାମା ଚ ଇମୌ ଦ୍ୱୌ ଜନୌ ମତ୍ସ୍ୟଧାରିଣୌ ସାଗରମଧ୍ୟେ ଜାଲଂ ପ୍ରକ୍ଷିପନ୍ତୌ ଦୃଷ୍ଟ୍ୱା ତାୱୱଦତ୍, ");
INSERT INTO sanori_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ଯୁୱାଂ ମମ ପଶ୍ଚାଦାଗଚ୍ଛତଂ, ଯୁୱାମହଂ ମନୁଷ୍ୟଧାରିଣୌ କରିଷ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ତତସ୍ତୌ ତତ୍କ୍ଷଣମେୱ ଜାଲାନି ପରିତ୍ୟଜ୍ୟ ତସ୍ୟ ପଶ୍ଚାତ୍ ଜଗ୍ମତୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ତତଃ ପରଂ ତତ୍ସ୍ଥାନାତ୍ କିଞ୍ଚିଦ୍ ଦୂରଂ ଗତ୍ୱା ସ ସିୱଦୀପୁତ୍ରଯାକୂବ୍ ତଦ୍ଭ୍ରାତୃଯୋହନ୍ ଚ ଇମୌ ନୌକାଯାଂ ଜାଲାନାଂ ଜୀର୍ଣମୁଦ୍ଧାରଯନ୍ତୌ ଦୃଷ୍ଟ୍ୱା ତାୱାହୂଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ତତସ୍ତୌ ନୌକାଯାଂ ୱେତନଭୁଗ୍ଭିଃ ସହିତଂ ସ୍ୱପିତରଂ ୱିହାଯ ତତ୍ପଶ୍ଚାଦୀଯତୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ତତଃ ପରଂ କଫର୍ନାହୂମ୍ନାମକଂ ନଗରମୁପସ୍ଥାଯ ସ ୱିଶ୍ରାମଦିୱସେ ଭଜନଗ୍ରହଂ ପ୍ରୱିଶ୍ୟ ସମୁପଦିଦେଶ| ");
INSERT INTO sanori_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ତସ୍ୟୋପଦେଶାଲ୍ଲୋକା ଆଶ୍ଚର୍ୟ୍ୟଂ ମେନିରେ ଯତଃ ସୋଧ୍ୟାପକାଇୱ ନୋପଦିଶନ୍ ପ୍ରଭାୱୱାନିୱ ପ୍ରୋପଦିଦେଶ| ");
INSERT INTO sanori_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","ଅପରଞ୍ଚ ତସ୍ମିନ୍ ଭଜନଗୃହେ ଅପୱିତ୍ରଭୂତେନ ଗ୍ରସ୍ତ ଏକୋ ମାନୁଷ ଆସୀତ୍| ସ ଚୀତ୍ଶବ୍ଦଂ କୃତ୍ୱା କଥଯାଞ୍ଚକେ ");
INSERT INTO sanori_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ଭୋ ନାସରତୀଯ ଯୀଶୋ ତ୍ୱମସ୍ମାନ୍ ତ୍ୟଜ, ତ୍ୱଯା ସହାସ୍ମାକଂ କଃ ସମ୍ବନ୍ଧଃ? ତ୍ୱଂ କିମସ୍ମାନ୍ ନାଶଯିତୁଂ ସମାଗତଃ? ତ୍ୱମୀଶ୍ୱରସ୍ୟ ପୱିତ୍ରଲୋକ ଇତ୍ୟହଂ ଜାନାମି| ");
INSERT INTO sanori_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ତଦା ଯୀଶୁସ୍ତଂ ତର୍ଜଯିତ୍ୱା ଜଗାଦ ତୂଷ୍ଣୀଂ ଭୱ ଇତୋ ବହିର୍ଭୱ ଚ| ");
INSERT INTO sanori_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ତତଃ ସୋଽପୱିତ୍ରଭୂତସ୍ତଂ ସମ୍ପୀଡ୍ୟ ଅତ୍ୟୁଚୈଶ୍ଚୀତ୍କୃତ୍ୟ ନିର୍ଜଗାମ| ");
INSERT INTO sanori_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ତେନୈୱ ସର୍ୱ୍ୱେ ଚମତ୍କୃତ୍ୟ ପରସ୍ପରଂ କଥଯାଞ୍ଚକ୍ରିରେ, ଅହୋ କିମିଦଂ? କୀଦୃଶୋଽଯଂ ନୱ୍ୟ ଉପଦେଶଃ? ଅନେନ ପ୍ରଭାୱେନାପୱିତ୍ରଭୂତେଷ୍ୱାଜ୍ଞାପିତେଷୁ ତେ ତଦାଜ୍ଞାନୁୱର୍ତ୍ତିନୋ ଭୱନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","ତଦା ତସ୍ୟ ଯଶୋ ଗାଲୀଲଶ୍ଚତୁର୍ଦିକ୍ସ୍ଥସର୍ୱ୍ୱଦେଶାନ୍ ୱ୍ୟାପ୍ନୋତ୍| ");
INSERT INTO sanori_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ଅପରଞ୍ଚ ତେ ଭଜନଗୃହାଦ୍ ବହି ର୍ଭୂତ୍ୱା ଯାକୂବ୍ୟୋହନ୍ଭ୍ୟାଂ ସହ ଶିମୋନ ଆନ୍ଦ୍ରିଯସ୍ୟ ଚ ନିୱେଶନଂ ପ୍ରୱିୱିଶୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ତଦା ପିତରସ୍ୟ ଶ୍ୱଶ୍ରୂର୍ଜ୍ୱରପୀଡିତା ଶଯ୍ୟାଯାମାସ୍ତ ଇତି ତେ ତଂ ଝଟିତି ୱିଜ୍ଞାପଯାଞ୍ଚକ୍ରୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ତତଃ ସ ଆଗତ୍ୟ ତସ୍ୟା ହସ୍ତଂ ଧୃତ୍ୱା ତାମୁଦସ୍ଥାପଯତ୍; ତଦୈୱ ତାଂ ଜ୍ୱରୋଽତ୍ୟାକ୍ଷୀତ୍ ତତଃ ପରଂ ସା ତାନ୍ ସିଷେୱେ| ");
INSERT INTO sanori_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","ଅଥାସ୍ତଂ ଗତେ ରୱୌ ସନ୍ଧ୍ୟାକାଲେ ସତି ଲୋକାସ୍ତତ୍ସମୀପଂ ସର୍ୱ୍ୱାନ୍ ରୋଗିଣୋ ଭୂତଧୃତାଂଶ୍ଚ ସମାନିନ୍ୟୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ସର୍ୱ୍ୱେ ନାଗରିକା ଲୋକା ଦ୍ୱାରି ସଂମିଲିତାଶ୍ଚ| ");
INSERT INTO sanori_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ତତଃ ସ ନାନାୱିଧରୋଗିଣୋ ବହୂନ୍ ମନୁଜାନରୋଗିଣଶ୍ଚକାର ତଥା ବହୂନ୍ ଭୂତାନ୍ ତ୍ୟାଜଯାଞ୍ଚକାର ତାନ୍ ଭୂତାନ୍ କିମପି ୱାକ୍ୟଂ ୱକ୍ତୁଂ ନିଷିଷେଧ ଚ ଯତୋହେତୋସ୍ତେ ତମଜାନନ୍| ");
INSERT INTO sanori_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","ଅପରଞ୍ଚ ସୋଽତିପ୍ରତ୍ୟୂଷେ ୱସ୍ତୁତସ୍ତୁ ରାତ୍ରିଶେଷେ ସମୁତ୍ଥାଯ ବହିର୍ଭୂଯ ନିର୍ଜନଂ ସ୍ଥାନଂ ଗତ୍ୱା ତତ୍ର ପ୍ରାର୍ଥଯାଞ୍ଚକ୍ରେ| ");
INSERT INTO sanori_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ଅନନ୍ତରଂ ଶିମୋନ୍ ତତ୍ସଙ୍ଗିନଶ୍ଚ ତସ୍ୟ ପଶ୍ଚାଦ୍ ଗତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ତଦୁଦ୍ଦେଶଂ ପ୍ରାପ୍ୟ ତମୱଦନ୍ ସର୍ୱ୍ୱେ ଲୋକାସ୍ତ୍ୱାଂ ମୃଗଯନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","ତଦା ସୋଽକଥଯତ୍ ଆଗଚ୍ଛତ ୱଯଂ ସମୀପସ୍ଥାନି ନଗରାଣି ଯାମଃ, ଯତୋଽହଂ ତତ୍ର କଥାଂ ପ୍ରଚାରଯିତୁଂ ବହିରାଗମମ୍| ");
INSERT INTO sanori_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","ଅଥ ସ ତେଷାଂ ଗାଲୀଲ୍ପ୍ରଦେଶସ୍ୟ ସର୍ୱ୍ୱେଷୁ ଭଜନଗୃହେଷୁ କଥାଃ ପ୍ରଚାରଯାଞ୍ଚକ୍ରେ ଭୂତାନତ୍ୟାଜଯଞ୍ଚ| ");
INSERT INTO sanori_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ଅନନ୍ତରମେକଃ କୁଷ୍ଠୀ ସମାଗତ୍ୟ ତତ୍ସମ୍ମୁଖେ ଜାନୁପାତଂ ୱିନଯଞ୍ଚ କୃତ୍ୱା କଥିତୱାନ୍ ଯଦି ଭୱାନ୍ ଇଚ୍ଛତି ତର୍ହି ମାଂ ପରିଷ୍କର୍ତ୍ତୁଂ ଶକ୍ନୋତି| ");
INSERT INTO sanori_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ତତଃ କୃପାଲୁ ର୍ୟୀଶୁଃ କରୌ ପ୍ରସାର୍ୟ୍ୟ ତଂ ସ୍ପଷ୍ଟ୍ୱା କଥଯାମାସ ");
INSERT INTO sanori_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ମମେଚ୍ଛା ୱିଦ୍ୟତେ ତ୍ୱଂ ପରିଷ୍କୃତୋ ଭୱ| ଏତତ୍କଥାଯାଃ କଥନମାତ୍ରାତ୍ ସ କୁଷ୍ଠୀ ରୋଗାନ୍ମୁକ୍ତଃ ପରିଷ୍କୃତୋଽଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","ତଦା ସ ତଂ ୱିସୃଜନ୍ ଗାଢମାଦିଶ୍ୟ ଜଗାଦ ");
INSERT INTO sanori_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ସାୱଧାନୋ ଭୱ କଥାମିମାଂ କମପି ମା ୱଦ; ସ୍ୱାତ୍ମାନଂ ଯାଜକଂ ଦର୍ଶଯ, ଲୋକେଭ୍ୟଃ ସ୍ୱପରିଷ୍କୃତେଃ ପ୍ରମାଣଦାନାଯ ମୂସାନିର୍ଣୀତଂ ଯଦ୍ଦାନଂ ତଦୁତ୍ସୃଜସ୍ୱ ଚ| ");
INSERT INTO sanori_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","କିନ୍ତୁ ସ ଗତ୍ୱା ତତ୍ କର୍ମ୍ମ ଇତ୍ଥଂ ୱିସ୍ତାର୍ୟ୍ୟ ପ୍ରଚାରଯିତୁଂ ପ୍ରାରେଭେ ତେନୈୱ ଯୀଶୁଃ ପୁନଃ ସପ୍ରକାଶଂ ନଗରଂ ପ୍ରୱେଷ୍ଟୁଂ ନାଶକ୍ନୋତ୍ ତତୋହେତୋର୍ବହିଃ କାନନସ୍ଥାନେ ତସ୍ୟୌ; ତଥାପି ଚତୁର୍ଦ୍ଦିଗ୍ଭ୍ୟୋ ଲୋକାସ୍ତସ୍ୟ ସମୀପମାଯଯୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","ତଦନନ୍ତରଂ ଯୀଶୈ କତିପଯଦିନାନି ୱିଲମ୍ବ୍ୟ ପୁନଃ କଫର୍ନାହୂମ୍ନଗରଂ ପ୍ରୱିଷ୍ଟେ ସ ଗୃହ ଆସ୍ତ ଇତି କିଂୱଦନ୍ତ୍ୟା ତତ୍କ୍ଷଣଂ ତତ୍ସମୀପଂ ବହୱୋ ଲୋକା ଆଗତ୍ୟ ସମୁପତସ୍ଥୁଃ, ");
INSERT INTO sanori_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ତସ୍ମାଦ୍ ଗୃହମଧ୍ୟେ ସର୍ୱ୍ୱେଷାଂ କୃତେ ସ୍ଥାନଂ ନାଭୱଦ୍ ଦ୍ୱାରସ୍ୟ ଚତୁର୍ଦିକ୍ଷ୍ୱପି ନାଭୱତ୍, ତତ୍କାଲେ ସ ତାନ୍ ପ୍ରତି କଥାଂ ପ୍ରଚାରଯାଞ୍ଚକ୍ରେ| ");
INSERT INTO sanori_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ତତଃ ପରଂ ଲୋକାଶ୍ଚତୁର୍ଭି ର୍ମାନୱୈରେକଂ ପକ୍ଷାଘାତିନଂ ୱାହଯିତ୍ୱା ତତ୍ସମୀପମ୍ ଆନିନ୍ୟୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","କିନ୍ତୁ ଜନାନାଂ ବହୁତ୍ୱାତ୍ ତଂ ଯୀଶୋଃ ସମ୍ମୁଖମାନେତୁଂ ନ ଶକ୍ନୁୱନ୍ତୋ ଯସ୍ମିନ୍ ସ୍ଥାନେ ସ ଆସ୍ତେ ତଦୁପରିଗୃହପୃଷ୍ଠଂ ଖନିତ୍ୱା ଛିଦ୍ରଂ କୃତ୍ୱା ତେନ ମାର୍ଗେଣ ସଶଯ୍ୟଂ ପକ୍ଷାଘାତିନମ୍ ଅୱରୋହଯାମାସୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ତତୋ ଯୀଶୁସ୍ତେଷାଂ ୱିଶ୍ୱାସଂ ଦୃଷ୍ଟ୍ୱା ତଂ ପକ୍ଷାଘାତିନଂ ବଭାଷେ ହେ ୱତ୍ସ ତୱ ପାପାନାଂ ମାର୍ଜନଂ ଭୱତୁ| ");
INSERT INTO sanori_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ତଦା କିଯନ୍ତୋଽଧ୍ୟାପକାସ୍ତତ୍ରୋପୱିଶନ୍ତୋ ମନୋଭି ର୍ୱିତର୍କଯାଞ୍ଚକ୍ରୁଃ, ଏଷ ମନୁଷ୍ୟ ଏତାଦୃଶୀମୀଶ୍ୱରନିନ୍ଦାଂ କଥାଂ କୁତଃ କଥଯତି? ");
INSERT INTO sanori_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","ଈଶ୍ୱରଂ ୱିନା ପାପାନି ମାର୍ଷ୍ଟୁଂ କସ୍ୟ ସାମର୍ଥ୍ୟମ୍ ଆସ୍ତେ? ");
INSERT INTO sanori_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ଇତ୍ଥଂ ତେ ୱିତର୍କଯନ୍ତି ଯୀଶୁସ୍ତତ୍କ୍ଷଣଂ ମନସା ତଦ୍ ବୁଦ୍ୱ୍ୱା ତାନୱଦଦ୍ ଯୂଯମନ୍ତଃକରଣୈଃ କୁତ ଏତାନି ୱିତର୍କଯଥ? ");
INSERT INTO sanori_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","ତଦନନ୍ତରଂ ଯୀଶୁସ୍ତତ୍ସ୍ଥାନାତ୍ ପୁନଃ ସମୁଦ୍ରତଟଂ ଯଯୌ; ଲୋକନିୱହେ ତତ୍ସମୀପମାଗତେ ସ ତାନ୍ ସମୁପଦିଦେଶ| ");
INSERT INTO sanori_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","କିନ୍ତୁ ପୃଥିୱ୍ୟାଂ ପାପାନି ମାର୍ଷ୍ଟୁଂ ମନୁଷ୍ୟପୁତ୍ରସ୍ୟ ସାମର୍ଥ୍ୟମସ୍ତି, ଏତଦ୍ ଯୁଷ୍ମାନ୍ ଜ୍ଞାପଯିତୁଂ (ସ ତସ୍ମୈ ପକ୍ଷାଘାତିନେ କଥଯାମାସ) ");
INSERT INTO sanori_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","ଉତ୍ତିଷ୍ଠ ତୱ ଶଯ୍ୟାଂ ଗୃହୀତ୍ୱା ସ୍ୱଗୃହଂ ଯାହି, ଅହଂ ତ୍ୱାମିଦମ୍ ଆଜ୍ଞାପଯାମି| ");
INSERT INTO sanori_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ତତଃ ସ ତତ୍କ୍ଷଣମ୍ ଉତ୍ଥାଯ ଶଯ୍ୟାଂ ଗୃହୀତ୍ୱା ସର୍ୱ୍ୱେଷାଂ ସାକ୍ଷାତ୍ ଜଗାମ; ସର୍ୱ୍ୱେ ୱିସ୍ମିତା ଏତାଦୃଶଂ କର୍ମ୍ମ ୱଯମ୍ କଦାପି ନାପଶ୍ୟାମ, ଇମାଂ କଥାଂ କଥଯିତ୍ୱେଶ୍ୱରଂ ଧନ୍ୟମବ୍ରୁୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","ତଦନନ୍ତରଂ ଯୀଶୁସ୍ତତ୍ସ୍ଥାନାତ୍ ପୁନଃ ସମୁଦ୍ରତଟଂ ଯଯୌ; ଲୋକନିୱହେ ତତ୍ସମୀପମାଗତେ ସ ତାନ୍ ସମୁପଦିଦେଶ| ");
INSERT INTO sanori_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ଅଥ ଗଚ୍ଛନ୍ କରସଞ୍ଚଯଗୃହ ଉପୱିଷ୍ଟମ୍ ଆଲ୍ଫୀଯପୁତ୍ରଂ ଲେୱିଂ ଦୃଷ୍ଟ୍ୱା ତମାହୂଯ କଥିତୱାନ୍ ମତ୍ପଶ୍ଚାତ୍ ତ୍ୱାମାମଚ୍ଛ ତତଃ ସ ଉତ୍ଥାଯ ତତ୍ପଶ୍ଚାଦ୍ ଯଯୌ| ");
INSERT INTO sanori_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","ଅନନ୍ତରଂ ଯୀଶୌ ତସ୍ୟ ଗୃହେ ଭୋକ୍ତୁମ୍ ଉପୱିଷ୍ଟେ ବହୱଃ କରମଞ୍ଚାଯିନଃ ପାପିନଶ୍ଚ ତେନ ତଚ୍ଛିଷ୍ୟୈଶ୍ଚ ସହୋପୱିୱିଶୁଃ, ଯତୋ ବହୱସ୍ତତ୍ପଶ୍ଚାଦାଜଗ୍ମୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ତଦା ସ କରମଞ୍ଚାଯିଭିଃ ପାପିଭିଶ୍ଚ ସହ ଖାଦତି, ତଦ୍ ଦୃଷ୍ଟ୍ୱାଧ୍ୟାପକାଃ ଫିରୂଶିନଶ୍ଚ ତସ୍ୟ ଶିଷ୍ୟାନୂଚୁଃ କରମଞ୍ଚାଯିଭିଃ ପାପିଭିଶ୍ଚ ସହାଯଂ କୁତୋ ଭୁଂକ୍ତେ ପିୱତି ଚ? ");
INSERT INTO sanori_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ତଦ୍ୱାକ୍ୟଂ ଶ୍ରୁତ୍ୱା ଯୀଶୁଃ ପ୍ରତ୍ୟୁୱାଚ,ଅରୋଗିଲୋକାନାଂ ଚିକିତ୍ସକେନ ପ୍ରଯୋଜନଂ ନାସ୍ତି, କିନ୍ତୁ ରୋଗିଣାମେୱ; ଅହଂ ଧାର୍ମ୍ମିକାନାହ୍ୱାତୁଂ ନାଗତଃ କିନ୍ତୁ ମନୋ ୱ୍ୟାୱର୍ତ୍ତଯିତୁଂ ପାପିନ ଏୱ| ");
INSERT INTO sanori_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ତତଃ ପରଂ ଯୋହନଃ ଫିରୂଶିନାଞ୍ଚୋପୱାସାଚାରିଶିଷ୍ୟା ଯୀଶୋଃ ସମୀପମ୍ ଆଗତ୍ୟ କଥଯାମାସୁଃ, ଯୋହନଃ ଫିରୂଶିନାଞ୍ଚ ଶିଷ୍ୟା ଉପୱସନ୍ତି କିନ୍ତୁ ଭୱତଃ ଶିଷ୍ୟା ନୋପୱସନ୍ତି କିଂ କାରଣମସ୍ୟ? ");
INSERT INTO sanori_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","ତଦା ଯୀଶୁସ୍ତାନ୍ ବଭାଷେ ଯାୱତ୍ କାଲଂ ସଖିଭିଃ ସହ କନ୍ୟାଯା ୱରସ୍ତିଷ୍ଠତି ତାୱତ୍କାଲଂ ତେ କିମୁପୱସ୍ତୁଂ ଶକ୍ନୁୱନ୍ତି? ଯାୱତ୍କାଲଂ ୱରସ୍ତୈଃ ସହ ତିଷ୍ଠତି ତାୱତ୍କାଲଂ ତ ଉପୱସ୍ତୁଂ ନ ଶକ୍ନୁୱନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","ଯସ୍ମିନ୍ କାଲେ ତେଭ୍ୟଃ ସକାଶାଦ୍ ୱରୋ ନେଷ୍ୟତେ ସ କାଲ ଆଗଚ୍ଛତି, ତସ୍ମିନ୍ କାଲେ ତେ ଜନା ଉପୱତ୍ସ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","କୋପି ଜନଃ ପୁରାତନୱସ୍ତ୍ରେ ନୂତନୱସ୍ତ୍ରଂ ନ ସୀୱ୍ୟତି, ଯତୋ ନୂତନୱସ୍ତ୍ରେଣ ସହ ସେୱନେ କୃତେ ଜୀର୍ଣଂ ୱସ୍ତ୍ରଂ ଛିଦ୍ୟତେ ତସ୍ମାତ୍ ପୁନ ର୍ମହତ୍ ଛିଦ୍ରଂ ଜାଯତେ| ");
INSERT INTO sanori_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","କୋପି ଜନଃ ପୁରାତନକୁତୂଷୁ ନୂତନଂ ଦ୍ରାକ୍ଷାରସଂ ନ ସ୍ଥାପଯତି, ଯତୋ ନୂତନଦ୍ରାକ୍ଷାରସସ୍ୟ ତେଜସା ତାଃ କୁତ୍ୱୋ ୱିଦୀର୍ୟ୍ୟନ୍ତେ ତତୋ ଦ୍ରାକ୍ଷାରସଶ୍ଚ ପତତି କୁତ୍ୱଶ୍ଚ ନଶ୍ୟନ୍ତି, ଅତଏୱ ନୂତନଦ୍ରାକ୍ଷାରସୋ ନୂତନକୁତୂଷୁ ସ୍ଥାପନୀଯଃ| ");
INSERT INTO sanori_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","ତଦନନ୍ତରଂ ଯୀଶୁ ର୍ୟଦା ୱିଶ୍ରାମୱାରେ ଶସ୍ୟକ୍ଷେତ୍ରେଣ ଗଚ୍ଛତି ତଦା ତସ୍ୟ ଶିଷ୍ୟା ଗଚ୍ଛନ୍ତଃ ଶସ୍ୟମଞ୍ଜରୀଶ୍ଛେତ୍ତୁଂ ପ୍ରୱୃତ୍ତାଃ| ");
INSERT INTO sanori_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ଅତଃ ଫିରୂଶିନୋ ଯୀଶୱେ କଥଯାମାସୁଃ ପଶ୍ୟତୁ ୱିଶ୍ରାମୱାସରେ ଯତ୍ କର୍ମ୍ମ ନ କର୍ତ୍ତୱ୍ୟଂ ତଦ୍ ଇମେ କୁତଃ କୁର୍ୱ୍ୱନ୍ତି? ");
INSERT INTO sanori_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ତଦା ସ ତେଭ୍ୟୋଽକଥଯତ୍ ଦାଯୂଦ୍ ତତ୍ସଂଙ୍ଗିନଶ୍ଚ ଭକ୍ଷ୍ୟାଭାୱାତ୍ କ୍ଷୁଧିତାଃ ସନ୍ତୋ ଯତ୍ କର୍ମ୍ମ କୃତୱନ୍ତସ୍ତତ୍ କିଂ ଯୁଷ୍ମାଭି ର୍ନ ପଠିତମ୍? ");
INSERT INTO sanori_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ଅବିଯାଥର୍ନାମକେ ମହାଯାଜକତାଂ କୁର୍ୱ୍ୱତି ସ କଥମୀଶ୍ୱରସ୍ୟାୱାସଂ ପ୍ରୱିଶ୍ୟ ଯେ ଦର୍ଶନୀଯପୂପା ଯାଜକାନ୍ ୱିନାନ୍ୟସ୍ୟ କସ୍ୟାପି ନ ଭକ୍ଷ୍ୟାସ୍ତାନେୱ ବୁଭୁଜେ ସଙ୍ଗିଲୋକେଭ୍ୟୋଽପି ଦଦୌ| ");
INSERT INTO sanori_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","ସୋଽପରମପି ଜଗାଦ, ୱିଶ୍ରାମୱାରୋ ମନୁଷ୍ୟାର୍ଥମେୱ ନିରୂପିତୋଽସ୍ତି କିନ୍ତୁ ମନୁଷ୍ୟୋ ୱିଶ୍ରାମୱାରାର୍ଥଂ ନୈୱ| ");
INSERT INTO sanori_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","ମନୁଷ୍ୟପୁତ୍ରୋ ୱିଶ୍ରାମୱାରସ୍ୟାପି ପ୍ରଭୁରାସ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ଅନନ୍ତରଂ ଯୀଶୁଃ ପୁନ ର୍ଭଜନଗୃହଂ ପ୍ରୱିଷ୍ଟସ୍ତସ୍ମିନ୍ ସ୍ଥାନେ ଶୁଷ୍କହସ୍ତ ଏକୋ ମାନୱ ଆସୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ସ ୱିଶ୍ରାମୱାରେ ତମରୋଗିଣଂ କରିଷ୍ୟତି ନୱେତ୍ୟତ୍ର ବହୱସ୍ତମ୍ ଅପୱଦିତୁଂ ଛିଦ୍ରମପେକ୍ଷିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ତଦା ସ ତଂ ଶୁଷ୍କହସ୍ତଂ ମନୁଷ୍ୟଂ ଜଗାଦ ମଧ୍ୟସ୍ଥାନେ ତ୍ୱମୁତ୍ତିଷ୍ଠ| ");
INSERT INTO sanori_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ତତଃ ପରଂ ସ ତାନ୍ ପପ୍ରଚ୍ଛ ୱିଶ୍ରାମୱାରେ ହିତମହିତଂ ତଥା ହି ପ୍ରାଣରକ୍ଷା ୱା ପ୍ରାଣନାଶ ଏଷାଂ ମଧ୍ୟେ କିଂ କରଣୀଯଂ ? କିନ୍ତୁ ତେ ନିଃଶବ୍ଦାସ୍ତସ୍ଥୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ତଦା ସ ତେଷାମନ୍ତଃକରଣାନାଂ କାଠିନ୍ୟାଦ୍ଧେତୋ ର୍ଦୁଃଖିତଃ କ୍ରୋଧାତ୍ ଚର୍ତୁिଦଶୋ ଦୃଷ୍ଟୱାନ୍ ତଂ ମାନୁଷଂ ଗଦିତୱାନ୍ ତଂ ହସ୍ତଂ ୱିସ୍ତାରଯ, ତତସ୍ତେନ ହସ୍ତେ ୱିସ୍ତୃତେ ତଦ୍ଧସ୍ତୋଽନ୍ୟହସ୍ତୱଦ୍ ଅରୋଗୋ ଜାତଃ| ");
INSERT INTO sanori_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ଅଥ ଫିରୂଶିନଃ ପ୍ରସ୍ଥାଯ ତଂ ନାଶଯିତୁଂ ହେରୋଦୀଯୈଃ ସହ ମନ୍ତ୍ରଯିତୁମାରେଭିରେ| ");
INSERT INTO sanori_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ଅତଏୱ ଯୀଶୁସ୍ତତ୍ସ୍ଥାନଂ ପରିତ୍ୟଜ୍ୟ ଶିଷ୍ୟୈଃ ସହ ପୁନଃ ସାଗରସମୀପଂ ଗତଃ; ");
INSERT INTO sanori_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ତତୋ ଗାଲୀଲ୍ୟିହୂଦା-ଯିରୂଶାଲମ୍-ଇଦୋମ୍-ଯର୍ଦନ୍ନଦୀପାରସ୍ଥାନେଭ୍ୟୋ ଲୋକସମୂହସ୍ତସ୍ୟ ପଶ୍ଚାଦ୍ ଗତଃ; ତଦନ୍ୟଃ ସୋରସୀଦନୋଃ ସମୀପୱାସିଲୋକସମୂହଶ୍ଚ ତସ୍ୟ ମହାକର୍ମ୍ମଣାଂ ୱାର୍ତ୍ତଂ ଶ୍ରୁତ୍ୱା ତସ୍ୟ ସନ୍ନିଧିମାଗତଃ| ");
INSERT INTO sanori_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","ତଦା ଲୋକସମୂହଶ୍ଚେତ୍ ତସ୍ୟୋପରି ପତତି ଇତ୍ୟାଶଙ୍କ୍ୟ ସ ନାୱମେକାଂ ନିକଟେ ସ୍ଥାପଯିତୁଂ ଶିଷ୍ୟାନାଦିଷ୍ଟୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ଯତୋଽନେକମନୁଷ୍ୟାଣାମାରୋଗ୍ୟକରଣାଦ୍ ୱ୍ୟାଧିଗ୍ରସ୍ତାଃ ସର୍ୱ୍ୱେ ତଂ ସ୍ପ୍ରଷ୍ଟୁଂ ପରସ୍ପରଂ ବଲେନ ଯତ୍ନୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ଅପରଞ୍ଚ ଅପୱିତ୍ରଭୂତାସ୍ତଂ ଦୃଷ୍ଟ୍ୱା ତଚ୍ଚରଣଯୋଃ ପତିତ୍ୱା ପ୍ରୋଚୈଃ ପ୍ରୋଚୁଃ, ତ୍ୱମୀଶ୍ୱରସ୍ୟ ପୁତ୍ରଃ| ");
INSERT INTO sanori_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","କିନ୍ତୁ ସ ତାନ୍ ଦୃଢମ୍ ଆଜ୍ଞାପ୍ୟ ସ୍ୱଂ ପରିଚାଯିତୁଂ ନିଷିଦ୍ଧୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","ଅନନ୍ତରଂ ସ ପର୍ୱ୍ୱତମାରୁହ୍ୟ ଯଂ ଯଂ ପ୍ରତିଚ୍ଛା ତଂ ତମାହୂତୱାନ୍ ତତସ୍ତେ ତତ୍ସମୀପମାଗତାଃ| ");
INSERT INTO sanori_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ତଦା ସ ଦ୍ୱାଦଶଜନାନ୍ ସ୍ୱେନ ସହ ସ୍ଥାତୁଂ ସୁସଂୱାଦପ୍ରଚାରାଯ ପ୍ରେରିତା ଭୱିତୁଂ ");
INSERT INTO sanori_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ସର୍ୱ୍ୱପ୍ରକାରୱ୍ୟାଧୀନାଂ ଶମନକରଣାଯ ପ୍ରଭାୱଂ ପ୍ରାପ୍ତୁଂ ଭୂତାନ୍ ତ୍ୟାଜଯିତୁଞ୍ଚ ନିଯୁକ୍ତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ତେଷାଂ ନାମାନୀମାନି, ଶିମୋନ୍ ସିୱଦିପୁତ୍ରୋ ");
INSERT INTO sanori_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ଯାକୂବ୍ ତସ୍ୟ ଭ୍ରାତା ଯୋହନ୍ ଚ ଆନ୍ଦ୍ରିଯଃ ଫିଲିପୋ ବର୍ଥଲମଯଃ, ");
INSERT INTO sanori_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ମଥୀ ଥୋମା ଚ ଆଲ୍ଫୀଯପୁତ୍ରୋ ଯାକୂବ୍ ଥଦ୍ଦୀଯଃ କିନାନୀଯଃ ଶିମୋନ୍ ଯସ୍ତଂ ପରହସ୍ତେଷ୍ୱର୍ପଯିଷ୍ୟତି ସ ଈଷ୍କରିଯୋତୀଯଯିହୂଦାଶ୍ଚ| ");
INSERT INTO sanori_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ସ ଶିମୋନେ ପିତର ଇତ୍ୟୁପନାମ ଦଦୌ ଯାକୂବ୍ୟୋହନ୍ଭ୍ୟାଂ ଚ ବିନେରିଗିଶ୍ ଅର୍ଥତୋ ମେଘନାଦପୁତ୍ରାୱିତ୍ୟୁପନାମ ଦଦୌ| ");
INSERT INTO sanori_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ଅନନ୍ତରଂ ତେ ନିୱେଶନଂ ଗତାଃ, କିନ୍ତୁ ତତ୍ରାପି ପୁନର୍ମହାନ୍ ଜନସମାଗମୋ ଽଭୱତ୍ ତସ୍ମାତ୍ତେ ଭୋକ୍ତୁମପ୍ୟୱକାଶଂ ନ ପ୍ରାପ୍ତାଃ| ");
INSERT INTO sanori_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ତତସ୍ତସ୍ୟ ସୁହୃଲ୍ଲୋକା ଇମାଂ ୱାର୍ତ୍ତାଂ ପ୍ରାପ୍ୟ ସ ହତଜ୍ଞାନୋଭୂଦ୍ ଇତି କଥାଂ କଥଯିତ୍ୱା ତଂ ଧୃତ୍ୱାନେତୁଂ ଗତାଃ| ");
INSERT INTO sanori_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","ଅପରଞ୍ଚ ଯିରୂଶାଲମ ଆଗତା ଯେ ଯେଽଧ୍ୟାପକାସ୍ତେ ଜଗଦୁରଯଂ ପୁରୁଷୋ ଭୂତପତ୍ୟାବିଷ୍ଟସ୍ତେନ ଭୂତପତିନା ଭୂତାନ୍ ତ୍ୟାଜଯତି| ");
INSERT INTO sanori_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","ତତସ୍ତାନାହୂଯ ଯୀଶୁ ର୍ଦୃଷ୍ଟାନ୍ତୈଃ କଥାଂ କଥିତୱାନ୍ ଶୈତାନ୍ କଥଂ ଶୈତାନଂ ତ୍ୟାଜଯିତୁଂ ଶକ୍ନୋତି? ");
INSERT INTO sanori_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","କିଞ୍ଚନ ରାଜ୍ୟଂ ଯଦି ସ୍ୱୱିରୋଧେନ ପୃଥଗ୍ ଭୱତି ତର୍ହି ତଦ୍ ରାଜ୍ୟଂ ସ୍ଥିରଂ ସ୍ଥାତୁଂ ନ ଶକ୍ନୋତି| ");
INSERT INTO sanori_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ତଥା କସ୍ୟାପି ପରିୱାରୋ ଯଦି ପରସ୍ପରଂ ୱିରୋଧୀ ଭୱତି ତର୍ହି ସୋପି ପରିୱାରଃ ସ୍ଥିରଂ ସ୍ଥାତୁଂ ନ ଶକ୍ନୋତି| ");
INSERT INTO sanori_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","ତଦ୍ୱତ୍ ଶୈତାନ୍ ଯଦି ସ୍ୱୱିପକ୍ଷତଯା ଉତ୍ତିଷ୍ଠନ୍ ଭିନ୍ନୋ ଭୱତି ତର୍ହି ସୋପି ସ୍ଥିରଂ ସ୍ଥାତୁଂ ନ ଶକ୍ନୋତି କିନ୍ତୂଚ୍ଛିନ୍ନୋ ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","ଅପରଞ୍ଚ ପ୍ରବଲଂ ଜନଂ ପ୍ରଥମଂ ନ ବଦ୍ଧା କୋପି ତସ୍ୟ ଗୃହଂ ପ୍ରୱିଶ୍ୟ ଦ୍ରୱ୍ୟାଣି ଲୁଣ୍ଠଯିତୁଂ ନ ଶକ୍ନୋତି, ତଂ ବଦ୍ୱ୍ୱୈୱ ତସ୍ୟ ଗୃହସ୍ୟ ଦ୍ରୱ୍ୟାଣି ଲୁଣ୍ଠଯିତୁଂ ଶକ୍ନୋତି| ");
INSERT INTO sanori_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","ଅତୋହେତୋ ର୍ୟୁଷ୍ମଭ୍ୟମହଂ ସତ୍ୟଂ କଥଯାମି ମନୁଷ୍ୟାଣାଂ ସନ୍ତାନା ଯାନି ଯାନି ପାପାନୀଶ୍ୱରନିନ୍ଦାଞ୍ଚ କୁର୍ୱ୍ୱନ୍ତି ତେଷାଂ ତତ୍ସର୍ୱ୍ୱେଷାମପରାଧାନାଂ କ୍ଷମା ଭୱିତୁଂ ଶକ୍ନୋତି, ");
INSERT INTO sanori_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","କିନ୍ତୁ ଯଃ କଶ୍ଚିତ୍ ପୱିତ୍ରମାତ୍ମାନଂ ନିନ୍ଦତି ତସ୍ୟାପରାଧସ୍ୟ କ୍ଷମା କଦାପି ନ ଭୱିଷ୍ୟତି ସୋନନ୍ତଦଣ୍ଡସ୍ୟାର୍ହୋ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","ତସ୍ୟାପୱିତ୍ରଭୂତୋଽସ୍ତି ତେଷାମେତତ୍କଥାହେତୋଃ ସ ଇତ୍ଥଂ କଥିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ଅଥ ତସ୍ୟ ମାତା ଭ୍ରାତୃଗଣଶ୍ଚାଗତ୍ୟ ବହିସ୍ତିଷ୍ଠନତୋ ଲୋକାନ୍ ପ୍ରେଷ୍ୟ ତମାହୂତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ତତସ୍ତତ୍ସନ୍ନିଧୌ ସମୁପୱିଷ୍ଟା ଲୋକାସ୍ତଂ ବଭାଷିରେ ପଶ୍ୟ ବହିସ୍ତୱ ମାତା ଭ୍ରାତରଶ୍ଚ ତ୍ୱାମ୍ ଅନ୍ୱିଚ୍ଛନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ତଦା ସ ତାନ୍ ପ୍ରତ୍ୟୁୱାଚ ମମ ମାତା କା ଭ୍ରାତରୋ ୱା କେ? ତତଃ ପରଂ ସ ସ୍ୱମୀପୋପୱିଷ୍ଟାନ୍ ଶିଷ୍ୟାନ୍ ପ୍ରତି ଅୱଲୋକନଂ କୃତ୍ୱା କଥଯାମାସ ");
INSERT INTO sanori_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ପଶ୍ୟତୈତେ ମମ ମାତା ଭ୍ରାତରଶ୍ଚ| ");
INSERT INTO sanori_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ଯଃ କଶ୍ଚିଦ୍ ଈଶ୍ୱରସ୍ୟେଷ୍ଟାଂ କ୍ରିଯାଂ କରୋତି ସ ଏୱ ମମ ଭ୍ରାତା ଭଗିନୀ ମାତା ଚ| ");
INSERT INTO sanori_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","ଅନନ୍ତରଂ ସ ସମୁଦ୍ରତଟେ ପୁନରୁପଦେଷ୍ଟୁଂ ପ୍ରାରେଭେ, ତତସ୍ତତ୍ର ବହୁଜନାନାଂ ସମାଗମାତ୍ ସ ସାଗରୋପରି ନୌକାମାରୁହ୍ୟ ସମୁପୱିଷ୍ଟଃ; ସର୍ୱ୍ୱେ ଲୋକାଃ ସମୁଦ୍ରକୂଲେ ତସ୍ଥୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ତଦା ସ ଦୃଷ୍ଟାନ୍ତକଥାଭି ର୍ବହୂପଦିଷ୍ଟୱାନ୍ ଉପଦିଶଂଶ୍ଚ କଥିତୱାନ୍, ");
INSERT INTO sanori_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","ଅୱଧାନଂ କୁରୁତ, ଏକୋ ବୀଜୱପ୍ତା ବୀଜାନି ୱପ୍ତୁଂ ଗତଃ; ");
INSERT INTO sanori_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ୱପନକାଲେ କିଯନ୍ତି ବୀଜାନି ମାର୍ଗପାଶ୍ୱେ ପତିତାନି, ତତ ଆକାଶୀଯପକ୍ଷିଣ ଏତ୍ୟ ତାନି ଚଖାଦୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","କିଯନ୍ତି ବୀଜାନି ସ୍ୱଲ୍ପମୃତ୍ତିକାୱତ୍ପାଷାଣଭୂମୌ ପତିତାନି ତାନି ମୃଦୋଲ୍ପତ୍ୱାତ୍ ଶୀଘ୍ରମଙ୍କୁରିତାନି; ");
INSERT INTO sanori_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","କିନ୍ତୂଦିତେ ସୂର୍ୟ୍ୟେ ଦଗ୍ଧାନି ତଥା ମୂଲାନୋ ନାଧୋଗତତ୍ୱାତ୍ ଶୁଷ୍କାଣି ଚ| ");
INSERT INTO sanori_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","କିଯନ୍ତି ବୀଜାନି କଣ୍ଟକିୱନମଧ୍ୟେ ପତିତାନି ତତଃ କଣ୍ଟକାନି ସଂୱୃଦ୍ୱ୍ୟ ତାନି ଜଗ୍ରସୁସ୍ତାନି ନ ଚ ଫଲିତାନି| ");
INSERT INTO sanori_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","ତଥା କିଯନ୍ତି ବୀଜାନ୍ୟୁତ୍ତମଭୂମୌ ପତିତାନି ତାନି ସଂୱୃଦ୍ୱ୍ୟ ଫଲାନ୍ୟୁତ୍ପାଦିତାନି କିଯନ୍ତି ବୀଜାନି ତ୍ରିଂଶଦ୍ଗୁଣାନି କିଯନ୍ତି ଷଷ୍ଟିଗୁଣାନି କିଯନ୍ତି ଶତଗୁଣାନି ଫଲାନି ଫଲିତୱନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ଅଥ ସ ତାନୱଦତ୍ ଯସ୍ୟ ଶ୍ରୋତୁଂ କର୍ଣୌ ସ୍ତଃ ସ ଶୃଣୋତୁ| ");
INSERT INTO sanori_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","ତଦନନ୍ତରଂ ନିର୍ଜନସମଯେ ତତ୍ସଙ୍ଗିନୋ ଦ୍ୱାଦଶଶିଷ୍ୟାଶ୍ଚ ତଂ ତଦ୍ଦୃଷ୍ଟାନ୍ତୱାକ୍ୟସ୍ୟାର୍ଥଂ ପପ୍ରଚ୍ଛୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ତଦା ସ ତାନୁଦିତୱାନ୍ ଈଶ୍ୱରରାଜ୍ୟସ୍ୟ ନିଗୂଢୱାକ୍ୟଂ ବୋଦ୍ଧୁଂ ଯୁଷ୍ମାକମଧିକାରୋଽସ୍ତି; ");
INSERT INTO sanori_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","କିନ୍ତୁ ଯେ ୱହିର୍ଭୂତାଃ \"ତେ ପଶ୍ୟନ୍ତଃ ପଶ୍ୟନ୍ତି କିନ୍ତୁ ନ ଜାନନ୍ତି, ଶୃଣ୍ୱନ୍ତଃ ଶୃଣ୍ୱନ୍ତି କିନ୍ତୁ ନ ବୁଧ୍ୟନ୍ତେ, ଚେତ୍ତୈ ର୍ମନଃସୁ କଦାପି ପରିୱର୍ତ୍ତିତେଷୁ ତେଷାଂ ପାପାନ୍ୟମୋଚଯିଷ୍ୟନ୍ତ,\" ଅତୋହେତୋସ୍ତାନ୍ ପ୍ରତି ଦୃଷ୍ଟାନ୍ତୈରେୱ ତାନି ମଯା କଥିତାନି| ");
INSERT INTO sanori_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","ଅଥ ସ କଥିତୱାନ୍ ଯୂଯଂ କିମେତଦ୍ ଦୃଷ୍ଟାନ୍ତୱାକ୍ୟଂ ନ ବୁଧ୍ୟଧ୍ୱେ? ତର୍ହି କଥଂ ସର୍ୱ୍ୱାନ୍ ଦୃଷ୍ଟାନ୍ତାନ ଭୋତ୍ସ୍ୟଧ୍ୱେ? ");
INSERT INTO sanori_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ବୀଜୱପ୍ତା ୱାକ୍ୟରୂପାଣି ବୀଜାନି ୱପତି; ");
INSERT INTO sanori_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ତତ୍ର ଯେ ଯେ ଲୋକା ୱାକ୍ୟଂ ଶୃଣ୍ୱନ୍ତି, କିନ୍ତୁ ଶ୍ରୁତମାତ୍ରାତ୍ ଶୈତାନ୍ ଶୀଘ୍ରମାଗତ୍ୟ ତେଷାଂ ମନଃସୂପ୍ତାନି ତାନି ୱାକ୍ୟରୂପାଣି ବୀଜାନ୍ୟପନଯତି ତଏୱ ଉପ୍ତବୀଜମାର୍ଗପାର୍ଶ୍ୱେସ୍ୱରୂପାଃ| ");
INSERT INTO sanori_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ଯେ ଜନା ୱାକ୍ୟଂ ଶ୍ରୁତ୍ୱା ସହସା ପରମାନନ୍ଦେନ ଗୃହ୍ଲନ୍ତି, କିନ୍ତୁ ହୃଦି ସ୍ଥୈର୍ୟ୍ୟାଭାୱାତ୍ କିଞ୍ଚିତ୍ କାଲମାତ୍ରଂ ତିଷ୍ଠନ୍ତି ତତ୍ପଶ୍ଚାତ୍ ତଦ୍ୱାକ୍ୟହେତୋଃ ");
INSERT INTO sanori_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","କୁତ୍ରଚିତ୍ କ୍ଲେଶେ ଉପଦ୍ରୱେ ୱା ସମୁପସ୍ଥିତେ ତଦୈୱ ୱିଘ୍ନଂ ପ୍ରାପ୍ନୁୱନ୍ତି ତଏୱ ଉପ୍ତବୀଜପାଷାଣଭୂମିସ୍ୱରୂପାଃ| ");
INSERT INTO sanori_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","ଯେ ଜନାଃ କଥାଂ ଶୃଣ୍ୱନ୍ତି କିନ୍ତୁ ସାଂସାରିକୀ ଚିନ୍ତା ଧନଭ୍ରାନ୍ତି ର୍ୱିଷଯଲୋଭଶ୍ଚ ଏତେ ସର୍ୱ୍ୱେ ଉପସ୍ଥାଯ ତାଂ କଥାଂ ଗ୍ରସନ୍ତି ତତଃ ମା ୱିଫଲା ଭୱତି ");
INSERT INTO sanori_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ତଏୱ ଉପ୍ତବୀଜସକଣ୍ଟକଭୂମିସ୍ୱରୂପାଃ| ");
INSERT INTO sanori_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ଯେ ଜନା ୱାକ୍ୟଂ ଶ୍ରୁତ୍ୱା ଗୃହ୍ଲନ୍ତି ତେଷାଂ କସ୍ୟ ୱା ତ୍ରିଂଶଦ୍ଗୁଣାନି କସ୍ୟ ୱା ଷଷ୍ଟିଗୁଣାନି କସ୍ୟ ୱା ଶତଗୁଣାନି ଫଲାନି ଭୱନ୍ତି ତଏୱ ଉପ୍ତବୀଜୋର୍ୱ୍ୱରଭୂମିସ୍ୱରୂପାଃ| ");
INSERT INTO sanori_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ତଦା ସୋଽପରମପି କଥିତୱାନ୍ କୋପି ଜନୋ ଦୀପାଧାରଂ ପରିତ୍ୟଜ୍ୟ ଦ୍ରୋଣସ୍ୟାଧଃ ଖଟ୍ୱାଯା ଅଧେ ୱା ସ୍ଥାପଯିତୁଂ ଦୀପମାନଯତି କିଂ? ");
INSERT INTO sanori_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","ଅତୋହେତୋ ର୍ୟନ୍ନ ପ୍ରକାଶଯିଷ୍ୟତେ ତାଦୃଗ୍ ଲୁକ୍କାଯିତଂ କିମପି ୱସ୍ତୁ ନାସ୍ତି; ଯଦ୍ ୱ୍ୟକ୍ତଂ ନ ଭୱିଷ୍ୟତି ତାଦୃଶଂ ଗୁପ୍ତଂ କିମପି ୱସ୍ତୁ ନାସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ଯସ୍ୟ ଶ୍ରୋତୁଂ କର୍ଣୌ ସ୍ତଃ ସ ଶୃଣୋତୁ| ");
INSERT INTO sanori_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","ଅପରମପି କଥିତୱାନ୍ ଯୂଯଂ ଯଦ୍ ଯଦ୍ ୱାକ୍ୟଂ ଶୃଣୁଥ ତତ୍ର ସାୱଧାନା ଭୱତ, ଯତୋ ଯୂଯଂ ଯେନ ପରିମାଣେନ ପରିମାଥ ତେନୈୱ ପରିମାଣେନ ଯୁଷ୍ମଦର୍ଥମପି ପରିମାସ୍ୟତେ; ଶ୍ରୋତାରୋ ଯୂଯଂ ଯୁଷ୍ମଭ୍ୟମଧିକଂ ଦାସ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","ଯସ୍ୟାଶ୍ରଯେ ୱର୍ଦ୍ଧତେ ତସ୍ମୈ ଅପରମପି ଦାସ୍ୟତେ, କିନ୍ତୁ ଯସ୍ୟାଶ୍ରଯେ ନ ୱର୍ଦ୍ଧତେ ତସ୍ୟ ଯତ୍ କିଞ୍ଚିଦସ୍ତି ତଦପି ତସ୍ମାନ୍ ନେଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","ଅନନ୍ତରଂ ସ କଥିତୱାନ୍ ଏକୋ ଲୋକଃ କ୍ଷେତ୍ରେ ବୀଜାନ୍ୟୁପ୍ତ୍ୱା ");
INSERT INTO sanori_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ଜାଗରଣନିଦ୍ରାଭ୍ୟାଂ ଦିୱାନିଶଂ ଗମଯତି, ପରନ୍ତୁ ତଦ୍ୱୀଜଂ ତସ୍ୟାଜ୍ଞାତରୂପେଣାଙ୍କୁରଯତି ୱର୍ଦ୍ଧତେ ଚ; ");
INSERT INTO sanori_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ଯତୋହେତୋଃ ପ୍ରଥମତଃ ପତ୍ରାଣି ତତଃ ପରଂ କଣିଶାନି ତତ୍ପଶ୍ଚାତ୍ କଣିଶପୂର୍ଣାନି ଶସ୍ୟାନି ଭୂମିଃ ସ୍ୱଯମୁତ୍ପାଦଯତି; ");
INSERT INTO sanori_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","କିନ୍ତୁ ଫଲେଷୁ ପକ୍କେଷୁ ଶସ୍ୟଚ୍ଛେଦନକାଲଂ ଜ୍ଞାତ୍ୱା ସ ତତ୍କ୍ଷଣଂ ଶସ୍ୟାନି ଛିନତ୍ତି, ଅନେନ ତୁଲ୍ୟମୀଶ୍ୱରରାଜ୍ୟଂ| ");
INSERT INTO sanori_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","ପୁନଃ ସୋଽକଥଯଦ୍ ଈଶ୍ୱରରାଜ୍ୟଂ କେନ ସମଂ? କେନ ୱସ୍ତୁନା ସହ ୱା ତଦୁପମାସ୍ୟାମି? ");
INSERT INTO sanori_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","ତତ୍ ସର୍ଷପୈକେନ ତୁଲ୍ୟଂ ଯତୋ ମୃଦି ୱପନକାଲେ ସର୍ଷପବୀଜଂ ସର୍ୱ୍ୱପୃଥିୱୀସ୍ଥବୀଜାତ୍ କ୍ଷୁଦ୍ରଂ ");
INSERT INTO sanori_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","କିନ୍ତୁ ୱପନାତ୍ ପରମ୍ ଅଙ୍କୁରଯିତ୍ୱା ସର୍ୱ୍ୱଶାକାଦ୍ ବୃହଦ୍ ଭୱତି, ତସ୍ୟ ବୃହତ୍ୟଃ ଶାଖାଶ୍ଚ ଜାଯନ୍ତେ ତତସ୍ତଚ୍ଛାଯାଂ ପକ୍ଷିଣ ଆଶ୍ରଯନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ଇତ୍ଥଂ ତେଷାଂ ବୋଧାନୁରୂପଂ ସୋଽନେକଦୃଷ୍ଟାନ୍ତୈସ୍ତାନୁପଦିଷ୍ଟୱାନ୍, ");
INSERT INTO sanori_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ଦୃଷ୍ଟାନ୍ତଂ ୱିନା କାମପି କଥାଂ ତେଭ୍ୟୋ ନ କଥିତୱାନ୍ ପଶ୍ଚାନ୍ ନିର୍ଜନେ ସ ଶିଷ୍ୟାନ୍ ସର୍ୱ୍ୱଦୃଷ୍ଟାନ୍ତାର୍ଥଂ ବୋଧିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","ତଦ୍ଦିନସ୍ୟ ସନ୍ଧ୍ୟାଯାଂ ସ ତେଭ୍ୟୋଽକଥଯଦ୍ ଆଗଚ୍ଛତ ୱଯଂ ପାରଂ ଯାମ| ");
INSERT INTO sanori_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ତଦା ତେ ଲୋକାନ୍ ୱିସୃଜ୍ୟ ତମୱିଲମ୍ବଂ ଗୃହୀତ୍ୱା ନୌକଯା ପ୍ରତସ୍ଥିରେ; ଅପରା ଅପି ନାୱସ୍ତଯା ସହ ସ୍ଥିତାଃ| ");
INSERT INTO sanori_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ତତଃ ପରଂ ମହାଝଞ୍ଭ୍ଶଗମାତ୍ ନୌ ର୍ଦୋଲାଯମାନା ତରଙ୍ଗେଣ ଜଲୈଃ ପୂର୍ଣାଭୱଚ୍ଚ| ");
INSERT INTO sanori_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ତଦା ସ ନୌକାଚଶ୍ଚାଦ୍ଭାଗେ ଉପଧାନେ ଶିରୋ ନିଧାଯ ନିଦ୍ରିତ ଆସୀତ୍ ତତସ୍ତେ ତଂ ଜାଗରଯିତ୍ୱା ଜଗଦୁଃ, ହେ ପ୍ରଭୋ, ଅସ୍ମାକଂ ପ୍ରାଣା ଯାନ୍ତି କିମତ୍ର ଭୱତଶ୍ଚିନ୍ତା ନାସ୍ତି? ");
INSERT INTO sanori_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ତଦା ସ ଉତ୍ଥାଯ ୱାଯୁଂ ତର୍ଜିତୱାନ୍ ସମୁଦ୍ରଞ୍ଚୋକ୍ତୱାନ୍ ଶାନ୍ତଃ ସୁସ୍ଥିରଶ୍ଚ ଭୱ; ତତୋ ୱାଯୌ ନିୱୃତ୍ତେଽବ୍ଧିର୍ନିସ୍ତରଙ୍ଗୋଭୂତ୍| ");
INSERT INTO sanori_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","ତଦା ସ ତାନୁୱାଚ ଯୂଯଂ କୁତ ଏତାଦୃକ୍ଶଙ୍କାକୁଲା ଭୱତ? କିଂ ୱୋ ୱିଶ୍ୱାସୋ ନାସ୍ତି? ");
INSERT INTO sanori_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ତସ୍ମାତ୍ତେଽତୀୱଭୀତାଃ ପରସ୍ପରଂ ୱକ୍ତୁମାରେଭିରେ, ଅହୋ ୱାଯୁଃ ସିନ୍ଧୁଶ୍ଚାସ୍ୟ ନିଦେଶଗ୍ରାହିଣୌ କୀଦୃଗଯଂ ମନୁଜଃ| ");
INSERT INTO sanori_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ଅଥ ତୂ ସିନ୍ଧୁପାରଂ ଗତ୍ୱା ଗିଦେରୀଯପ୍ରଦେଶ ଉପତସ୍ଥୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ନୌକାତୋ ନିର୍ଗତମାତ୍ରାଦ୍ ଅପୱିତ୍ରଭୂତଗ୍ରସ୍ତ ଏକଃ ଶ୍ମଶାନାଦେତ୍ୟ ତଂ ସାକ୍ଷାଚ୍ ଚକାର| ");
INSERT INTO sanori_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ସ ଶ୍ମଶାନେଽୱାତ୍ସୀତ୍ କୋପି ତଂ ଶୃଙ୍ଖଲେନ ବଦ୍ୱ୍ୱା ସ୍ଥାପଯିତୁଂ ନାଶକ୍ନୋତ୍| ");
INSERT INTO sanori_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ଜନୈର୍ୱାରଂ ନିଗଡୈଃ ଶୃଙ୍ଖଲୈଶ୍ଚ ସ ବଦ୍ଧୋପି ଶୃଙ୍ଖଲାନ୍ୟାକୃଷ୍ୟ ମୋଚିତୱାନ୍ ନିଗଡାନି ଚ ଭଂକ୍ତ୍ୱା ଖଣ୍ଡଂ ଖଣ୍ଡଂ କୃତୱାନ୍ କୋପି ତଂ ୱଶୀକର୍ତ୍ତୁଂ ନ ଶଶକ| ");
INSERT INTO sanori_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ଦିୱାନିଶଂ ସଦା ପର୍ୱ୍ୱତଂ ଶ୍ମଶାନଞ୍ଚ ଭ୍ରମିତ୍ୱା ଚୀତ୍ଶବ୍ଦଂ କୃତୱାନ୍ ଗ୍ରାୱଭିଶ୍ଚ ସ୍ୱଯଂ ସ୍ୱଂ କୃତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ସ ଯୀଶୁଂ ଦୂରାତ୍ ପଶ୍ୟନ୍ନେୱ ଧାୱନ୍ ତଂ ପ୍ରଣନାମ ଉଚୈରୁୱଂଶ୍ଚୋୱାଚ, ");
INSERT INTO sanori_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ହେ ସର୍ୱ୍ୱୋପରିସ୍ଥେଶ୍ୱରପୁତ୍ର ଯୀଶୋ ଭୱତା ସହ ମେ କଃ ସମ୍ବନ୍ଧଃ? ଅହଂ ତ୍ୱାମୀଶ୍ୱରେଣ ଶାପଯେ ମାଂ ମା ଯାତଯ| ");
INSERT INTO sanori_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","ଯତୋ ଯୀଶୁସ୍ତଂ କଥିତୱାନ୍ ରେ ଅପୱିତ୍ରଭୂତ, ଅସ୍ମାନ୍ନରାଦ୍ ବହିର୍ନିର୍ଗଚ୍ଛ| ");
INSERT INTO sanori_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","ଅଥ ସ ତଂ ପୃଷ୍ଟୱାନ୍ କିନ୍ତେ ନାମ? ତେନ ପ୍ରତ୍ୟୁକ୍ତଂ ୱଯମନେକେ ଽସ୍ମସ୍ତତୋଽସ୍ମନ୍ନାମ ବାହିନୀ| ");
INSERT INTO sanori_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ତତୋସ୍ମାନ୍ ଦେଶାନ୍ନ ପ୍ରେଷଯେତି ତେ ତଂ ପ୍ରାର୍ଥଯନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ତଦାନୀଂ ପର୍ୱ୍ୱତଂ ନିକଷା ବୃହନ୍ ୱରାହୱ୍ରଜଶ୍ଚରନ୍ନାସୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ତସ୍ମାଦ୍ ଭୂତା ୱିନଯେନ ଜଗଦୁଃ, ଅମୁଂ ୱରାହୱ୍ରଜମ୍ ଆଶ୍ରଯିତୁମ୍ ଅସ୍ମାନ୍ ପ୍ରହିଣୁ| ");
INSERT INTO sanori_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ଯୀଶୁନାନୁଜ୍ଞାତାସ୍ତେଽପୱିତ୍ରଭୂତା ବହିର୍ନିର୍ୟାଯ ୱରାହୱ୍ରଜଂ ପ୍ରାୱିଶନ୍ ତତଃ ସର୍ୱ୍ୱେ ୱରାହା ୱସ୍ତୁତସ୍ତୁ ପ୍ରାଯୋଦ୍ୱିସହସ୍ରସଂଙ୍ଖ୍ୟକାଃ କଟକେନ ମହାଜୱାଦ୍ ଧାୱନ୍ତଃ ସିନ୍ଧୌ ପ୍ରାଣାନ୍ ଜହୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ତସ୍ମାଦ୍ ୱରାହପାଲକାଃ ପଲାଯମାନାଃ ପୁରେ ଗ୍ରାମେ ଚ ତଦ୍ୱାର୍ତ୍ତଂ କଥଯାଞ୍ଚକ୍ରୁଃ| ତଦା ଲୋକା ଘଟିତଂ ତତ୍କାର୍ୟ୍ୟଂ ଦ୍ରଷ୍ଟୁଂ ବହିର୍ଜଗ୍ମୁଃ ");
INSERT INTO sanori_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ଯୀଶୋଃ ସନ୍ନିଧିଂ ଗତ୍ୱା ତଂ ଭୂତଗ୍ରସ୍ତମ୍ ଅର୍ଥାଦ୍ ବାହିନୀଭୂତଗ୍ରସ୍ତଂ ନରଂ ସୱସ୍ତ୍ରଂ ସଚେତନଂ ସମୁପୱିଷ୍ଟଞ୍ଚ ଦୃृଷ୍ଟ୍ୱା ବିଭ୍ୟୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ତତୋ ଦୃଷ୍ଟତତ୍କାର୍ୟ୍ୟଲୋକାସ୍ତସ୍ୟ ଭୂତଗ୍ରସ୍ତନରସ୍ୟ ୱରାହୱ୍ରଜସ୍ୟାପି ତାଂ ଧଟନାଂ ୱର୍ଣଯାମାସୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ତତସ୍ତେ ସ୍ୱସୀମାତୋ ବହିର୍ଗନ୍ତୁଂ ଯୀଶୁଂ ୱିନେତୁମାରେଭିରେ| ");
INSERT INTO sanori_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ଅଥ ତସ୍ୟ ନୌକାରୋହଣକାଲେ ସ ଭୂତମୁକ୍ତୋ ନା ଯୀଶୁନା ସହ ସ୍ଥାତୁଂ ପ୍ରାର୍ଥଯତେ; ");
INSERT INTO sanori_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","କିନ୍ତୁ ସ ତମନନୁମତ୍ୟ କଥିତୱାନ୍ ତ୍ୱଂ ନିଜାତ୍ମୀଯାନାଂ ସମୀପଂ ଗୃହଞ୍ଚ ଗଚ୍ଛ ପ୍ରଭୁସ୍ତ୍ୱଯି କୃପାଂ କୃତ୍ୱା ଯାନି କର୍ମ୍ମାଣି କୃତୱାନ୍ ତାନି ତାନ୍ ଜ୍ଞାପଯ| ");
INSERT INTO sanori_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ଅତଃ ସ ପ୍ରସ୍ଥାଯ ଯୀଶୁନା କୃତଂ ତତ୍ସର୍ୱ୍ୱାଶ୍ଚର୍ୟ୍ୟଂ କର୍ମ୍ମ ଦିକାପଲିଦେଶେ ପ୍ରଚାରଯିତୁଂ ପ୍ରାରବ୍ଧୱାନ୍ ତତଃ ସର୍ୱ୍ୱେ ଲୋକା ଆଶ୍ଚର୍ୟ୍ୟଂ ମେନିରେ| ");
INSERT INTO sanori_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","ଅନନ୍ତରଂ ଯୀଶୌ ନାୱା ପୁନରନ୍ୟପାର ଉତ୍ତୀର୍ଣେ ସିନ୍ଧୁତଟେ ଚ ତିଷ୍ଠତି ସତି ତତ୍ସମୀପେ ବହୁଲୋକାନାଂ ସମାଗମୋଽଭୂତ୍| ");
INSERT INTO sanori_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ଅପରଂ ଯାଯୀର୍ ନାମ୍ନା କଶ୍ଚିଦ୍ ଭଜନଗୃହସ୍ୟାଧିପ ଆଗତ୍ୟ ତଂ ଦୃଷ୍ଟ୍ୱୈୱ ଚରଣଯୋଃ ପତିତ୍ୱା ବହୁ ନିୱେଦ୍ୟ କଥିତୱାନ୍; ");
INSERT INTO sanori_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ମମ କନ୍ୟା ମୃତପ୍ରାଯାଭୂଦ୍ ଅତୋ ଭୱାନେତ୍ୟ ତଦାରୋଗ୍ୟାଯ ତସ୍ୟା ଗାତ୍ରେ ହସ୍ତମ୍ ଅର୍ପଯତୁ ତେନୈୱ ସା ଜୀୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ତଦା ଯୀଶୁସ୍ତେନ ସହ ଚଲିତଃ କିନ୍ତୁ ତତ୍ପଶ୍ଚାଦ୍ ବହୁଲୋକାଶ୍ଚଲିତ୍ୱା ତାଦ୍ଗାତ୍ରେ ପତିତାଃ| ");
INSERT INTO sanori_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","ଅଥ ଦ୍ୱାଦଶୱର୍ଷାଣି ପ୍ରଦରରୋଗେଣ ");
INSERT INTO sanori_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ଶୀର୍ଣା ଚିକିତ୍ସକାନାଂ ନାନାଚିକିତ୍ସାଭିଶ୍ଚ ଦୁଃଖଂ ଭୁକ୍ତୱତୀ ଚ ସର୍ୱ୍ୱସ୍ୱଂ ୱ୍ୟଯିତ୍ୱାପି ନାରୋଗ୍ୟଂ ପ୍ରାପ୍ତା ଚ ପୁନରପି ପୀଡିତାସୀଚ୍ଚ ");
INSERT INTO sanori_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ଯା ସ୍ତ୍ରୀ ସା ଯୀଶୋ ର୍ୱାର୍ତ୍ତାଂ ପ୍ରାପ୍ୟ ମନସାକଥଯତ୍ ଯଦ୍ୟହଂ ତସ୍ୟ ୱସ୍ତ୍ରମାତ୍ର ସ୍ପ୍ରଷ୍ଟୁଂ ଲଭେଯଂ ତଦା ରୋଗହୀନା ଭୱିଷ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ଅତୋହେତୋଃ ସା ଲୋକାରଣ୍ୟମଧ୍ୟେ ତତ୍ପଶ୍ଚାଦାଗତ୍ୟ ତସ୍ୟ ୱସ୍ତ୍ରଂ ପସ୍ପର୍ଶ| ");
INSERT INTO sanori_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ତେନୈୱ ତତ୍କ୍ଷଣଂ ତସ୍ୟା ରକ୍ତସ୍ରୋତଃ ଶୁଷ୍କଂ ସ୍ୱଯଂ ତସ୍ମାଦ୍ ରୋଗାନ୍ମୁକ୍ତା ଇତ୍ୟପି ଦେହେଽନୁଭୂତା| ");
INSERT INTO sanori_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","ଅଥ ସ୍ୱସ୍ମାତ୍ ଶକ୍ତି ର୍ନିର୍ଗତା ଯୀଶୁରେତନ୍ମନସା ଜ୍ଞାତ୍ୱା ଲୋକନିୱହଂ ପ୍ରତି ମୁଖଂ ୱ୍ୟାୱୃତ୍ୟ ପୃଷ୍ଟୱାନ୍ କେନ ମଦ୍ୱସ୍ତ୍ରଂ ସ୍ପୃଷ୍ଟଂ? ");
INSERT INTO sanori_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ତତସ୍ତସ୍ୟ ଶିଷ୍ୟା ଊଚୁଃ ଭୱତୋ ୱପୁଷି ଲୋକାଃ ସଂଘର୍ଷନ୍ତି ତଦ୍ ଦୃଷ୍ଟ୍ୱା କେନ ମଦ୍ୱସ୍ତ୍ରଂ ସ୍ପୃଷ୍ଟମିତି କୁତଃ କଥଯତି? ");
INSERT INTO sanori_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","କିନ୍ତୁ କେନ ତତ୍ କର୍ମ୍ମ କୃତଂ ତଦ୍ ଦ୍ରଷ୍ଟୁଂ ଯୀଶୁଶ୍ଚତୁର୍ଦିଶୋ ଦୃଷ୍ଟୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ତତଃ ସା ସ୍ତ୍ରୀ ଭୀତା କମ୍ପିତା ଚ ସତୀ ସ୍ୱସ୍ୟା ରୁକ୍ପ୍ରତିକ୍ରିଯା ଜାତେତି ଜ୍ଞାତ୍ୱାଗତ୍ୟ ତତ୍ସମ୍ମୁଖେ ପତିତ୍ୱା ସର୍ୱ୍ୱୱୃତ୍ତାନ୍ତଂ ସତ୍ୟଂ ତସ୍ମୈ କଥଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ତଦାନୀଂ ଯୀଶୁସ୍ତାଂ ଗଦିତୱାନ୍, ହେ କନ୍ୟେ ତୱ ପ୍ରତୀତିସ୍ତ୍ୱାମ୍ ଅରୋଗାମକରୋତ୍ ତ୍ୱଂ କ୍ଷେମେଣ ୱ୍ରଜ ସ୍ୱରୋଗାନ୍ମୁକ୍ତା ଚ ତିଷ୍ଠ| ");
INSERT INTO sanori_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ଇତିୱାକ୍ୟୱଦନକାଲେ ଭଜନଗୃହାଧିପସ୍ୟ ନିୱେଶନାଲ୍ ଲୋକା ଏତ୍ୟାଧିପଂ ବଭାଷିରେ ତୱ କନ୍ୟା ମୃତା ତସ୍ମାଦ୍ ଗୁରୁଂ ପୁନଃ କୁତଃ କ୍ଲିଶ୍ନାସି? ");
INSERT INTO sanori_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","କିନ୍ତୁ ଯୀଶୁସ୍ତଦ୍ ୱାକ୍ୟଂ ଶ୍ରୁତ୍ୱୈୱ ଭଜନଗୃହାଧିପଂ ଗଦିତୱାନ୍ ମା ଭୈଷୀଃ କେୱଲଂ ୱିଶ୍ୱାସିହି| ");
INSERT INTO sanori_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","ଅଥ ପିତରୋ ଯାକୂବ୍ ତଦ୍ଭ୍ରାତା ଯୋହନ୍ ଚ ଏତାନ୍ ୱିନା କମପି ସ୍ୱପଶ୍ଚାଦ୍ ଯାତୁଂ ନାନ୍ୱମନ୍ୟତ| ");
INSERT INTO sanori_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ତସ୍ୟ ଭଜନଗୃହାଧିପସ୍ୟ ନିୱେଶନସମୀପମ୍ ଆଗତ୍ୟ କଲହଂ ବହୁରୋଦନଂ ୱିଲାପଞ୍ଚ କୁର୍ୱ୍ୱତୋ ଲୋକାନ୍ ଦଦର୍ଶ| ");
INSERT INTO sanori_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ତସ୍ମାନ୍ ନିୱେଶନଂ ପ୍ରୱିଶ୍ୟ ପ୍ରୋକ୍ତୱାନ୍ ଯୂଯଂ କୁତ ଇତ୍ଥଂ କଲହଂ ରୋଦନଞ୍ଚ କୁରୁଥ? କନ୍ୟା ନ ମୃତା ନିଦ୍ରାତି| ");
INSERT INTO sanori_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","ତସ୍ମାତ୍ତେ ତମୁପଜହସୁଃ କିନ୍ତୁ ଯୀଶୁଃ ସର୍ୱ୍ୱାନ ବହିଷ୍କୃତ୍ୟ କନ୍ୟାଯାଃ ପିତରୌ ସ୍ୱସଙ୍ଗିନଶ୍ଚ ଗୃହୀତ୍ୱା ଯତ୍ର କନ୍ୟାସୀତ୍ ତତ୍ ସ୍ଥାନଂ ପ୍ରୱିଷ୍ଟୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","ଅଥ ସ ତସ୍ୟାଃ କନ୍ୟାଯା ହସ୍ତୌ ଧୃତ୍ୱା ତାଂ ବଭାଷେ ଟାଲୀଥା କୂମୀ, ଅର୍ଥତୋ ହେ କନ୍ୟେ ତ୍ୱମୁତ୍ତିଷ୍ଠ ଇତ୍ୟାଜ୍ଞାପଯାମି| ");
INSERT INTO sanori_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ତୁନୈୱ ତତ୍କ୍ଷଣଂ ସା ଦ୍ୱାଦଶୱର୍ଷୱଯସ୍କା କନ୍ୟା ପୋତ୍ଥାଯ ଚଲିତୁମାରେଭେ, ଇତଃ ସର୍ୱ୍ୱେ ମହାୱିସ୍ମଯଂ ଗତାଃ| ");
INSERT INTO sanori_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","ତତ ଏତସ୍ୟୈ କିଞ୍ଚିତ୍ ଖାଦ୍ୟଂ ଦତ୍ତେତି କଥଯିତ୍ୱା ଏତତ୍କର୍ମ୍ମ କମପି ନ ଜ୍ଞାପଯତେତି ଦୃଢମାଦିଷ୍ଟୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","ଅନନ୍ତରଂ ସ ତତ୍ସ୍ଥାନାତ୍ ପ୍ରସ୍ଥାଯ ସ୍ୱପ୍ରଦେଶମାଗତଃ ଶିଷ୍ୟାଶ୍ଚ ତତ୍ପଶ୍ଚାଦ୍ ଗତାଃ| ");
INSERT INTO sanori_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ଅଥ ୱିଶ୍ରାମୱାରେ ସତି ସ ଭଜନଗୃହେ ଉପଦେଷ୍ଟୁମାରବ୍ଧୱାନ୍ ତତୋଽନେକେ ଲୋକାସ୍ତତ୍କଥାଂ ଶ୍ରୁତ୍ୱା ୱିସ୍ମିତ୍ୟ ଜଗଦୁଃ, ଅସ୍ୟ ମନୁଜସ୍ୟ ଈଦୃଶୀ ଆଶ୍ଚର୍ୟ୍ୟକ୍ରିଯା କସ୍ମାଜ୍ ଜାତା? ତଥା ସ୍ୱକରାଭ୍ୟାମ୍ ଇତ୍ଥମଦ୍ଭୁତଂ କର୍ମ୍ମ କର୍ତ୍ତାुମ୍ ଏତସ୍ମୈ କଥଂ ଜ୍ଞାନଂ ଦତ୍ତମ୍? ");
INSERT INTO sanori_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","କିମଯଂ ମରିଯମଃ ପୁତ୍ରସ୍ତଜ୍ଞା ନୋ? କିମଯଂ ଯାକୂବ୍-ଯୋସି-ଯିହୁଦା-ଶିମୋନାଂ ଭ୍ରାତା ନୋ? ଅସ୍ୟ ଭଗିନ୍ୟଃ କିମିହାସ୍ମାଭିଃ ସହ ନୋ? ଇତ୍ଥଂ ତେ ତଦର୍ଥେ ପ୍ରତ୍ୟୂହଂ ଗତାଃ| ");
INSERT INTO sanori_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ତଦା ଯୀଶୁସ୍ତେଭ୍ୟୋଽକଥଯତ୍ ସ୍ୱଦେଶଂ ସ୍ୱକୁଟୁମ୍ବାନ୍ ସ୍ୱପରିଜନାଂଶ୍ଚ ୱିନା କୁତ୍ରାପି ଭୱିଷ୍ୟଦ୍ୱାଦୀ ଅସତ୍କୃତୋ ନ ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ଅପରଞ୍ଚ ତେଷାମପ୍ରତ୍ୟଯାତ୍ ସ ୱିସ୍ମିତଃ କିଯତାଂ ରୋଗିଣାଂ ୱପୁଃଷୁ ହସ୍ତମ୍ ଅର୍ପଯିତ୍ୱା କେୱଲଂ ତେଷାମାରୋଗ୍ୟକରଣାଦ୍ ଅନ୍ୟତ୍ କିମପି ଚିତ୍ରକାର୍ୟ୍ୟଂ କର୍ତ୍ତାଂ ନ ଶକ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ଅଥ ସ ଚତୁର୍ଦିକ୍ସ୍ଥ ଗ୍ରାମାନ୍ ଭ୍ରମିତ୍ୱା ଉପଦିଷ୍ଟୱାନ୍ ");
INSERT INTO sanori_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ଦ୍ୱାଦଶଶିଷ୍ୟାନ୍ ଆହୂଯ ଅମେଧ୍ୟଭୂତାନ୍ ୱଶୀକର୍ତ୍ତାଂ ଶକ୍ତିଂ ଦତ୍ତ୍ୱା ତେଷାଂ ଦ୍ୱୌ ଦ୍ୱୌ ଜନୋ ପ୍ରେଷିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ପୁନରିତ୍ୟାଦିଶଦ୍ ଯୂଯମ୍ ଏକୈକାଂ ଯଷ୍ଟିଂ ୱିନା ୱସ୍ତ୍ରସଂପୁଟଃ ପୂପଃ କଟିବନ୍ଧେ ତାମ୍ରଖଣ୍ଡଞ୍ଚ ଏଷାଂ କିମପି ମା ଗ୍ରହ୍ଲୀତ, ");
INSERT INTO sanori_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ମାର୍ଗଯାତ୍ରାଯୈ ପାଦେଷୂପାନହୌ ଦତ୍ତ୍ୱା ଦ୍ୱେ ଉତ୍ତରୀଯେ ମା ପରିଧଦ୍ୱ୍ୱଂ| ");
INSERT INTO sanori_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","ଅପରମପ୍ୟୁକ୍ତଂ ତେନ ଯୂଯଂ ଯସ୍ୟାଂ ପୁର୍ୟ୍ୟାଂ ଯସ୍ୟ ନିୱେଶନଂ ପ୍ରୱେକ୍ଷ୍ୟଥ ତାଂ ପୁରୀଂ ଯାୱନ୍ନ ତ୍ୟକ୍ଷ୍ୟଥ ତାୱତ୍ ତନ୍ନିୱେଶନେ ସ୍ଥାସ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","ତତ୍ର ଯଦି କେପି ଯୁଷ୍ମାକମାତିଥ୍ୟଂ ନ ୱିଦଧତି ଯୁଷ୍ମାକଂ କଥାଶ୍ଚ ନ ଶୃଣ୍ୱନ୍ତି ତର୍ହି ତତ୍ସ୍ଥାନାତ୍ ପ୍ରସ୍ଥାନସମଯେ ତେଷାଂ ୱିରୁଦ୍ଧଂ ସାକ୍ଷ୍ୟଂ ଦାତୁଂ ସ୍ୱପାଦାନାସ୍ଫାଲ୍ୟ ରଜଃ ସମ୍ପାତଯତ; ଅହଂ ଯୁଷ୍ମାନ୍ ଯଥାର୍ଥଂ ୱଚ୍ମି ୱିଚାରଦିନେ ତନ୍ନଗରସ୍ୟାୱସ୍ଥାତଃ ସିଦୋମାମୋରଯୋ ର୍ନଗରଯୋରୱସ୍ଥା ସହ୍ୟତରା ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","ଅଥ ତେ ଗତ୍ୱା ଲୋକାନାଂ ମନଃପରାୱର୍ତ୍ତନୀଃ କଥା ପ୍ରଚାରିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ଏୱମନେକାନ୍ ଭୂତାଂଶ୍ଚ ତ୍ୟାଜିତୱନ୍ତସ୍ତଥା ତୈଲେନ ମର୍ଦ୍ଦଯିତ୍ୱା ବହୂନ୍ ଜନାନରୋଗାନକାର୍ଷୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ଇତ୍ଥଂ ତସ୍ୟ ସୁଖ୍ୟାତିଶ୍ଚତୁର୍ଦିଶୋ ୱ୍ୟାପ୍ତା ତଦା ହେରୋଦ୍ ରାଜା ତନ୍ନିଶମ୍ୟ କଥିତୱାନ୍, ଯୋହନ୍ ମଜ୍ଜକଃ ଶ୍ମଶାନାଦ୍ ଉତ୍ଥିତ ଅତୋହେତୋସ୍ତେନ ସର୍ୱ୍ୱା ଏତା ଅଦ୍ଭୁତକ୍ରିଯାଃ ପ୍ରକାଶନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","ଅନ୍ୟେଽକଥଯନ୍ ଅଯମ୍ ଏଲିଯଃ, କେପି କଥିତୱନ୍ତ ଏଷ ଭୱିଷ୍ୟଦ୍ୱାଦୀ ଯଦ୍ୱା ଭୱିଷ୍ୟଦ୍ୱାଦିନାଂ ସଦୃଶ ଏକୋଯମ୍| ");
INSERT INTO sanori_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","କିନ୍ତୁ ହେରୋଦ୍ ଇତ୍ୟାକର୍ଣ୍ୟ ଭାଷିତୱାନ୍ ଯସ୍ୟାହଂ ଶିରଶ୍ଛିନ୍ନୱାନ୍ ସ ଏୱ ଯୋହନଯଂ ସ ଶ୍ମଶାନାଦୁଦତିଷ୍ଠତ୍| ");
INSERT INTO sanori_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","ପୂର୍ୱ୍ୱଂ ସ୍ୱଭ୍ରାତୁଃ ଫିଲିପସ୍ୟ ପତ୍ନ୍ୟା ଉଦ୍ୱାହଂ କୃତୱନ୍ତଂ ହେରୋଦଂ ଯୋହନୱାଦୀତ୍ ସ୍ୱଭାତୃୱଧୂ ର୍ନ ୱିୱାହ୍ୟା| ");
INSERT INTO sanori_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ଅତଃ କାରଣାତ୍ ହେରୋଦ୍ ଲୋକଂ ପ୍ରହିତ୍ୟ ଯୋହନଂ ଧୃତ୍ୱା ବନ୍ଧନାଲଯେ ବଦ୍ଧୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ହେରୋଦିଯା ତସ୍ମୈ ଯୋହନେ ପ୍ରକୁପ୍ୟ ତଂ ହନ୍ତୁମ୍ ଐଚ୍ଛତ୍ କିନ୍ତୁ ନ ଶକ୍ତା, ");
INSERT INTO sanori_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ଯସ୍ମାଦ୍ ହେରୋଦ୍ ତଂ ଧାର୍ମ୍ମିକଂ ସତ୍ପୁରୁଷଞ୍ଚ ଜ୍ଞାତ୍ୱା ସମ୍ମନ୍ୟ ରକ୍ଷିତୱାନ୍; ତତ୍କଥାଂ ଶ୍ରୁତ୍ୱା ତଦନୁସାରେଣ ବହୂନି କର୍ମ୍ମାଣି କୃତୱାନ୍ ହୃଷ୍ଟମନାସ୍ତଦୁପଦେଶଂ ଶ୍ରୁତୱାଂଶ୍ଚ| ");
INSERT INTO sanori_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","କିନ୍ତୁ ହେରୋଦ୍ ଯଦା ସ୍ୱଜନ୍ମଦିନେ ପ୍ରଧାନଲୋକେଭ୍ୟଃ ସେନାନୀଭ୍ୟଶ୍ଚ ଗାଲୀଲ୍ପ୍ରଦେଶୀଯଶ୍ରେଷ୍ଠଲୋକେଭ୍ୟଶ୍ଚ ରାତ୍ରୌ ଭୋଜ୍ୟମେକଂ କୃତୱାନ୍ ");
INSERT INTO sanori_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ତସ୍ମିନ୍ ଶୁଭଦିନେ ହେରୋଦିଯାଯାଃ କନ୍ୟା ସମେତ୍ୟ ତେଷାଂ ସମକ୍ଷଂ ସଂନୃତ୍ୟ ହେରୋଦସ୍ତେନ ସହୋପୱିଷ୍ଟାନାଞ୍ଚ ତୋଷମଜୀଜନତ୍ ତତା ନୃପଃ କନ୍ୟାମାହ ସ୍ମ ମତ୍ତୋ ଯଦ୍ ଯାଚସେ ତଦେୱ ତୁଭ୍ୟଂ ଦାସ୍ୟେ| ");
INSERT INTO sanori_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ଶପଥଂ କୃତ୍ୱାକଥଯତ୍ ଚେଦ୍ ରାଜ୍ୟାର୍ଦ୍ଧମପି ଯାଚସେ ତଦପି ତୁଭ୍ୟଂ ଦାସ୍ୟେ| ");
INSERT INTO sanori_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ତତଃ ସା ବହି ର୍ଗତ୍ୱା ସ୍ୱମାତରଂ ପପ୍ରଚ୍ଛ କିମହଂ ଯାଚିଷ୍ୟେ? ତଦା ସାକଥଯତ୍ ଯୋହନୋ ମଜ୍ଜକସ୍ୟ ଶିରଃ| ");
INSERT INTO sanori_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","ଅଥ ତୂର୍ଣଂ ଭୂପସମୀପମ୍ ଏତ୍ୟ ଯାଚମାନାୱଦତ୍ କ୍ଷଣେସ୍ମିନ୍ ଯୋହନୋ ମଜ୍ଜକସ୍ୟ ଶିରଃ ପାତ୍ରେ ନିଧାଯ ଦେହି, ଏତଦ୍ ଯାଚେଽହଂ| ");
INSERT INTO sanori_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ତସ୍ମାତ୍ ଭୂପୋଽତିଦୁଃଖିତଃ, ତଥାପି ସ୍ୱଶପଥସ୍ୟ ସହଭୋଜିନାଞ୍ଚାନୁରୋଧାତ୍ ତଦନଙ୍ଗୀକର୍ତ୍ତୁଂ ନ ଶକ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ତତ୍କ୍ଷଣଂ ରାଜା ଘାତକଂ ପ୍ରେଷ୍ୟ ତସ୍ୟ ଶିର ଆନେତୁମାଦିଷ୍ଟୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ତତଃ ସ କାରାଗାରଂ ଗତ୍ୱା ତଚ୍ଛିରଶ୍ଛିତ୍ୱା ପାତ୍ରେ ନିଧାଯାନୀଯ ତସ୍ୟୈ କନ୍ୟାଯୈ ଦତ୍ତୱାନ୍ କନ୍ୟା ଚ ସ୍ୱମାତ୍ରେ ଦଦୌ| ");
INSERT INTO sanori_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ଅନନତରଂ ଯୋହନଃ ଶିଷ୍ୟାସ୍ତଦ୍ୱାର୍ତ୍ତାଂ ପ୍ରାପ୍ୟାଗତ୍ୟ ତସ୍ୟ କୁଣପଂ ଶ୍ମଶାନେଽସ୍ଥାପଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","ଅଥ ପ୍ରେଷିତା ଯୀଶୋଃ ସନ୍ନିଧୌ ମିଲିତା ଯଦ୍ ଯଚ୍ ଚକ୍ରୁଃ ଶିକ୍ଷଯାମାସୁଶ୍ଚ ତତ୍ସର୍ୱ୍ୱୱାର୍ତ୍ତାସ୍ତସ୍ମୈ କଥିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ସ ତାନୁୱାଚ ଯୂଯଂ ୱିଜନସ୍ଥାନଂ ଗତ୍ୱା ୱିଶ୍ରାମ୍ୟତ ଯତସ୍ତତ୍ସନ୍ନିଧୌ ବହୁଲୋକାନାଂ ସମାଗମାତ୍ ତେ ଭୋକ୍ତୁଂ ନାୱକାଶଂ ପ୍ରାପ୍ତାଃ| ");
INSERT INTO sanori_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ତତସ୍ତେ ନାୱା ୱିଜନସ୍ଥାନଂ ଗୁପ୍ତଂ ଗଗ୍ମୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ତତୋ ଲୋକନିୱହସ୍ତେଷାଂ ସ୍ଥାନାନ୍ତରଯାନଂ ଦଦର୍ଶ, ଅନେକେ ତଂ ପରିଚିତ୍ୟ ନାନାପୁରେଭ୍ୟଃ ପଦୈର୍ୱ୍ରଜିତ୍ୱା ଜୱେନ ତୈଷାମଗ୍ରେ ଯୀଶୋଃ ସମୀପ ଉପତସ୍ଥୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","ତଦା ଯୀଶୁ ର୍ନାୱୋ ବହିର୍ଗତ୍ୟ ଲୋକାରଣ୍ୟାନୀଂ ଦୃଷ୍ଟ୍ୱା ତେଷୁ କରୁଣାଂ କୃତୱାନ୍ ଯତସ୍ତେଽରକ୍ଷକମେଷା ଇୱାସନ୍ ତଦା ସ ତାନ ନାନାପ୍ରସଙ୍ଗାନ୍ ଉପଦିଷ୍ଟୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ଅଥ ଦିୱାନ୍ତେ ସତି ଶିଷ୍ୟା ଏତ୍ୟ ଯୀଶୁମୂଚିରେ, ଇଦଂ ୱିଜନସ୍ଥାନଂ ଦିନଞ୍ଚାୱସନ୍ନଂ| ");
INSERT INTO sanori_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ଲୋକାନାଂ କିମପି ଖାଦ୍ୟଂ ନାସ୍ତି, ଅତଶ୍ଚତୁର୍ଦିକ୍ଷୁ ଗ୍ରାମାନ୍ ଗନ୍ତୁଂ ଭୋଜ୍ୟଦ୍ରୱ୍ୟାଣି କ୍ରେତୁଞ୍ଚ ଭୱାନ୍ ତାନ୍ ୱିସୃଜତୁ| ");
INSERT INTO sanori_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ତଦା ସ ତାନୁୱାଚ ଯୂଯମେୱ ତାନ୍ ଭୋଜଯତ; ତତସ୍ତେ ଜଗଦୁ ର୍ୱଯଂ ଗତ୍ୱା ଦ୍ୱିଶତସଂଖ୍ୟକୈ ର୍ମୁଦ୍ରାପାଦୈଃ ପୂପାନ୍ କ୍ରୀତ୍ୱା କିଂ ତାନ୍ ଭୋଜଯିଷ୍ୟାମଃ? ");
INSERT INTO sanori_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ତଦା ସ ତାନ୍ ପୃଷ୍ଠୱାନ୍ ଯୁଷ୍ମାକଂ ସନ୍ନିଧୌ କତି ପୂପା ଆସତେ? ଗତ୍ୱା ପଶ୍ୟତ; ତତସ୍ତେ ଦୃଷ୍ଟ୍ୱା ତମୱଦନ୍ ପଞ୍ଚ ପୂପା ଦ୍ୱୌ ମତ୍ସ୍ୟୌ ଚ ସନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","ତଦା ସ ଲୋକାନ୍ ଶସ୍ପୋପରି ପଂକ୍ତିଭିରୁପୱେଶଯିତୁମ୍ ଆଦିଷ୍ଟୱାନ୍, ");
INSERT INTO sanori_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ତତସ୍ତେ ଶତଂ ଶତଂ ଜନାଃ ପଞ୍ଚାଶତ୍ ପଞ୍ଚାଶଜ୍ଜନାଶ୍ଚ ପଂକ୍ତିଭି ର୍ଭୁୱି ସମୁପୱିୱିଶୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","ଅଥ ସ ତାନ୍ ପଞ୍ଚପୂପାନ୍ ମତ୍ସ୍ୟଦ୍ୱଯଞ୍ଚ ଧୃତ୍ୱା ସ୍ୱର୍ଗଂ ପଶ୍ୟନ୍ ଈଶ୍ୱରଗୁଣାନ୍ ଅନ୍ୱକୀର୍ତ୍ତଯତ୍ ତାନ୍ ପୂପାନ୍ ଭଂକ୍ତ୍ୱା ଲୋକେଭ୍ୟଃ ପରିୱେଷଯିତୁଂ ଶିଷ୍ୟେଭ୍ୟୋ ଦତ୍ତୱାନ୍ ଦ୍ୱା ମତ୍ସ୍ୟୌ ଚ ୱିଭଜ୍ୟ ସର୍ୱ୍ୱେଭ୍ୟୋ ଦତ୍ତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ତତଃ ସର୍ୱ୍ୱେ ଭୁକ୍ତ୍ୱାତୃପ୍ୟନ୍| ");
INSERT INTO sanori_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ଅନନ୍ତରଂ ଶିଷ୍ୟା ଅୱଶିଷ୍ଟୈଃ ପୂପୈ ର୍ମତ୍ସ୍ୟୈଶ୍ଚ ପୂର୍ଣାନ୍ ଦ୍ୱଦଶ ଡଲ୍ଲକାନ୍ ଜଗୃହୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","ତେ ଭୋକ୍ତାରଃ ପ୍ରାଯଃ ପଞ୍ଚ ସହସ୍ରାଣି ପୁରୁଷା ଆସନ୍| ");
INSERT INTO sanori_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ଅଥ ସ ଲୋକାନ୍ ୱିସୃଜନ୍ନେୱ ନାୱମାରୋଢୁଂ ସ୍ୱସ୍ମାଦଗ୍ରେ ପାରେ ବୈତ୍ସୈଦାପୁରଂ ଯାତୁଞ୍ଚ ଶ୍ଷ୍ୟିाନ୍ ୱାଢମାଦିଷ୍ଟୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ତଦା ସ ସର୍ୱ୍ୱାନ୍ ୱିସୃଜ୍ୟ ପ୍ରାର୍ଥଯିତୁଂ ପର୍ୱ୍ୱତଂ ଗତଃ| ");
INSERT INTO sanori_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ତତଃ ସନ୍ଧ୍ୟାଯାଂ ସତ୍ୟାଂ ନୌଃ ସିନ୍ଧୁମଧ୍ୟ ଉପସ୍ଥିତା କିନ୍ତୁ ସ ଏକାକୀ ସ୍ଥଲେ ସ୍ଥିତଃ| ");
INSERT INTO sanori_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ଅଥ ସମ୍ମୁଖୱାତୱହନାତ୍ ଶିଷ୍ୟା ନାୱଂ ୱାହଯିତ୍ୱା ପରିଶ୍ରାନ୍ତା ଇତି ଜ୍ଞାତ୍ୱା ସ ନିଶାଚତୁର୍ଥଯାମେ ସିନ୍ଧୂପରି ପଦ୍ଭ୍ୟାଂ ୱ୍ରଜନ୍ ତେଷାଂ ସମୀପମେତ୍ୟ ତେଷାମଗ୍ରେ ଯାତୁମ୍ ଉଦ୍ୟତଃ| ");
INSERT INTO sanori_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","କିନ୍ତୁ ଶିଷ୍ୟାଃ ସିନ୍ଧୂପରି ତଂ ୱ୍ରଜନ୍ତଂ ଦୃଷ୍ଟ୍ୱା ଭୂତମନୁମାଯ ରୁରୁୱୁଃ, ");
INSERT INTO sanori_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ଯତଃ ସର୍ୱ୍ୱେ ତଂ ଦୃଷ୍ଟ୍ୱା ୱ୍ୟାକୁଲିତାଃ| ଅତଏୱ ଯୀଶୁସ୍ତତ୍କ୍ଷଣଂ ତୈଃ ସହାଲପ୍ୟ କଥିତୱାନ୍, ସୁସ୍ଥିରା ଭୂତ, ଅଯମହଂ ମା ଭୈଷ୍ଟ| ");
INSERT INTO sanori_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ଅଥ ନୌକାମାରୁହ୍ୟ ତସ୍ମିନ୍ ତେଷାଂ ସନ୍ନିଧିଂ ଗତେ ୱାତୋ ନିୱୃତ୍ତଃ; ତସ୍ମାତ୍ତେ ମନଃସୁ ୱିସ୍ମିତା ଆଶ୍ଚର୍ୟ୍ୟଂ ମେନିରେ| ");
INSERT INTO sanori_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ଯତସ୍ତେ ମନସାଂ କାଠିନ୍ୟାତ୍ ତତ୍ ପୂପୀଯମ୍ ଆଶ୍ଚର୍ୟ୍ୟଂ କର୍ମ୍ମ ନ ୱିୱିକ୍ତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ଅଥ ତେ ପାରଂ ଗତ୍ୱା ଗିନେଷରତ୍ପ୍ରଦେଶମେତ୍ୟ ତଟ ଉପସ୍ଥିତାଃ| ");
INSERT INTO sanori_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ତେଷୁ ନୌକାତୋ ବହିର୍ଗତେଷୁ ତତ୍ପ୍ରଦେଶୀଯା ଲୋକାସ୍ତଂ ପରିଚିତ୍ୟ ");
INSERT INTO sanori_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ଚତୁର୍ଦିକ୍ଷୁ ଧାୱନ୍ତୋ ଯତ୍ର ଯତ୍ର ରୋଗିଣୋ ନରା ଆସନ୍ ତାନ୍ ସର୍ୱ୍ୱାନ ଖଟ୍ୱୋପରି ନିଧାଯ ଯତ୍ର କୁତ୍ରଚିତ୍ ତଦ୍ୱାର୍ତ୍ତାଂ ପ୍ରାପୁଃ ତତ୍ ସ୍ଥାନମ୍ ଆନେତୁମ୍ ଆରେଭିରେ| ");
INSERT INTO sanori_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","ତଥା ଯତ୍ର ଯତ୍ର ଗ୍ରାମେ ଯତ୍ର ଯତ୍ର ପୁରେ ଯତ୍ର ଯତ୍ର ପଲ୍ଲ୍ୟାଞ୍ଚ ତେନ ପ୍ରୱେଶଃ କୃତସ୍ତଦ୍ୱର୍ତ୍ମମଧ୍ୟେ ଲୋକାଃ ପୀଡିତାନ୍ ସ୍ଥାପଯିତ୍ୱା ତସ୍ୟ ଚେଲଗ୍ରନ୍ଥିମାତ୍ରଂ ସ୍ପ୍ରଷ୍ଟୁମ୍ ତେଷାମର୍ଥେ ତଦନୁଜ୍ଞାଂ ପ୍ରାର୍ଥଯନ୍ତଃ ଯାୱନ୍ତୋ ଲୋକାଃ ପସ୍ପୃଶୁସ୍ତାୱନ୍ତ ଏୱ ଗଦାନ୍ମୁକ୍ତାଃ| ");
INSERT INTO sanori_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","ଅନନ୍ତରଂ ଯିରୂଶାଲମ ଆଗତାଃ ଫିରୂଶିନୋଽଧ୍ୟାପକାଶ୍ଚ ଯୀଶୋଃ ସମୀପମ୍ ଆଗତାଃ| ");
INSERT INTO sanori_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ତେ ତସ୍ୟ କିଯତଃ ଶିଷ୍ୟାନ୍ ଅଶୁଚିକରୈରର୍ଥାଦ ଅପ୍ରକ୍ଷାଲିତହସ୍ତୈ ର୍ଭୁଞ୍ଜତୋ ଦୃଷ୍ଟ୍ୱା ତାନଦୂଷଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ଯତଃ ଫିରୂଶିନଃ ସର୍ୱ୍ୱଯିହୂଦୀଯାଶ୍ଚ ପ୍ରାଚାଂ ପରମ୍ପରାଗତୱାକ୍ୟଂ ସମ୍ମନ୍ୟ ପ୍ରତଲେନ ହସ୍ତାନ୍ ଅପ୍ରକ୍ଷାଲ୍ୟ ନ ଭୁଞ୍ଜତେ| ");
INSERT INTO sanori_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ଆପନାଦାଗତ୍ୟ ମଜ୍ଜନଂ ୱିନା ନ ଖାଦନ୍ତି; ତଥା ପାନପାତ୍ରାଣାଂ ଜଲପାତ୍ରାଣାଂ ପିତ୍ତଲପାତ୍ରାଣାମ୍ ଆସନାନାଞ୍ଚ ଜଲେ ମଜ୍ଜନମ୍ ଇତ୍ୟାଦଯୋନ୍ୟେପି ବହୱସ୍ତେଷାମାଚାରାଃ ସନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ତେ ଫିରୂଶିନୋଽଧ୍ୟାପକାଶ୍ଚ ଯୀଶୁଂ ପପ୍ରଚ୍ଛୁଃ, ତୱ ଶିଷ୍ୟାଃ ପ୍ରାଚାଂ ପରମ୍ପରାଗତୱାକ୍ୟାନୁସାରେଣ ନାଚରନ୍ତୋଽପ୍ରକ୍ଷାଲିତକରୈଃ କୁତୋ ଭୁଜଂତେ? ");
INSERT INTO sanori_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ତତଃ ସ ପ୍ରତ୍ୟୁୱାଚ କପଟିନୋ ଯୁଷ୍ମାନ୍ ଉଦ୍ଦିଶ୍ୟ ଯିଶଯିଯଭୱିଷ୍ୟଦ୍ୱାଦୀ ଯୁକ୍ତମୱାଦୀତ୍| ଯଥା ସ୍ୱକୀଯୈରଧରୈରେତେ ସମ୍ମନ୍ୟନତେ ସଦୈୱ ମାଂ| କିନ୍ତୁ ମତ୍ତୋ ୱିପ୍ରକର୍ଷେ ସନ୍ତି ତେଷାଂ ମନାଂସି ଚ| ");
INSERT INTO sanori_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ଶିକ୍ଷଯନ୍ତୋ ବିଧୀନ୍ ନ୍ନାଜ୍ଞା ଭଜନ୍ତେ ମାଂ ମୁଧୈୱ ତେ| ");
INSERT INTO sanori_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","ଯୂଯଂ ଜଲପାତ୍ରପାନପାତ୍ରାଦୀନି ମଜ୍ଜଯନ୍ତୋ ମନୁଜପରମ୍ପରାଗତୱାକ୍ୟଂ ରକ୍ଷଥ କିନ୍ତୁ ଈଶ୍ୱରାଜ୍ଞାଂ ଲଂଘଧ୍ୱେ; ଅପରା ଈଦୃଶ୍ୟୋନେକାଃ କ୍ରିଯା ଅପି କୁରୁଧ୍ୱେ| ");
INSERT INTO sanori_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","ଅନ୍ୟଞ୍ଚାକଥଯତ୍ ଯୂଯଂ ସ୍ୱପରମ୍ପରାଗତୱାକ୍ୟସ୍ୟ ରକ୍ଷାର୍ଥଂ ସ୍ପଷ୍ଟରୂପେଣ ଈଶ୍ୱରାଜ୍ଞାଂ ଲୋପଯଥ| ");
INSERT INTO sanori_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","ଯତୋ ମୂସାଦ୍ୱାରା ପ୍ରୋକ୍ତମସ୍ତି ସ୍ୱପିତରୌ ସମ୍ମନ୍ୟଧ୍ୱଂ ଯସ୍ତୁ ମାତରଂ ପିତରଂ ୱା ଦୁର୍ୱ୍ୱାକ୍ୟଂ ୱକ୍ତି ସ ନିତାନ୍ତଂ ହନ୍ୟତାଂ| ");
INSERT INTO sanori_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","କିନ୍ତୁ ମଦୀଯେନ ଯେନ ଦ୍ରୱ୍ୟେଣ ତୱୋପକାରୋଭୱତ୍ ତତ୍ କର୍ବ୍ବାଣମର୍ଥାଦ୍ ଈଶ୍ୱରାଯ ନିୱେଦିତମ୍ ଇଦଂ ୱାକ୍ୟଂ ଯଦି କୋପି ପିତରଂ ମାତରଂ ୱା ୱକ୍ତି ");
INSERT INTO sanori_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ତର୍ହି ଯୂଯଂ ମାତୁଃ ପିତୁ ର୍ୱୋପକାରଂ କର୍ତ୍ତାଂ ତଂ ୱାରଯଥ| ");
INSERT INTO sanori_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ଇତ୍ଥଂ ସ୍ୱପ୍ରଚାରିତପରମ୍ପରାଗତୱାକ୍ୟେନ ଯୂଯମ୍ ଈଶ୍ୱରାଜ୍ଞାଂ ମୁଧା ୱିଧଦ୍ୱ୍ୱେ, ଈଦୃଶାନ୍ୟନ୍ୟାନ୍ୟନେକାନି କର୍ମ୍ମାଣି କୁରୁଧ୍ୱେ| ");
INSERT INTO sanori_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","ଅଥ ସ ଲୋକାନାହୂଯ ବଭାଷେ ଯୂଯଂ ସର୍ୱ୍ୱେ ମଦ୍ୱାକ୍ୟଂ ଶୃଣୁତ ବୁଧ୍ୟଧ୍ୱଞ୍ଚ| ");
INSERT INTO sanori_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ବାହ୍ୟାଦନ୍ତରଂ ପ୍ରୱିଶ୍ୟ ନରମମେଧ୍ୟଂ କର୍ତ୍ତାଂ ଶକ୍ନୋତି ଈଦୃଶଂ କିମପି ୱସ୍ତୁ ନାସ୍ତି, ୱରମ୍ ଅନ୍ତରାଦ୍ ବହିର୍ଗତଂ ଯଦ୍ୱସ୍ତୁ ତନ୍ମନୁଜମ୍ ଅମେଧ୍ୟଂ କରୋତି| ");
INSERT INTO sanori_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","ଯସ୍ୟ ଶ୍ରୋତୁଂ ଶ୍ରୋତ୍ରେ ସ୍ତଃ ସ ଶୃଣୋତୁ| ");
INSERT INTO sanori_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ତତଃ ସ ଲୋକାନ୍ ହିତ୍ୱା ଗୃହମଧ୍ୟଂ ପ୍ରୱିଷ୍ଟସ୍ତଦା ଶିଷ୍ୟାସ୍ତଦୃଷ୍ଟାନ୍ତୱାକ୍ୟାର୍ଥଂ ପପ୍ରଚ୍ଛୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","ତସ୍ମାତ୍ ସ ତାନ୍ ଜଗାଦ ଯୂଯମପି କିମେତାଦୃଗବୋଧାଃ? କିମପି ଦ୍ରୱ୍ୟଂ ବାହ୍ୟାଦନ୍ତରଂ ପ୍ରୱିଶ୍ୟ ନରମମେଧ୍ୟଂ କର୍ତ୍ତାଂ ନ ଶକ୍ନୋତି କଥାମିମାଂ କିଂ ନ ବୁଧ୍ୟଧ୍ୱେ? ");
INSERT INTO sanori_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ତତ୍ ତଦନ୍ତର୍ନ ପ୍ରୱିଶତି କିନ୍ତୁ କୁକ୍ଷିମଧ୍ୟଂ ପ୍ରୱିଶତି ଶେଷେ ସର୍ୱ୍ୱଭୁକ୍ତୱସ୍ତୁଗ୍ରାହିଣି ବହିର୍ଦେଶେ ନିର୍ୟାତି| ");
INSERT INTO sanori_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ଅପରମପ୍ୟୱାଦୀଦ୍ ଯନ୍ନରାନ୍ନିରେତି ତଦେୱ ନରମମେଧ୍ୟଂ କରୋତି| ");
INSERT INTO sanori_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ଯତୋଽନ୍ତରାଦ୍ ଅର୍ଥାନ୍ ମାନୱାନାଂ ମନୋଭ୍ୟଃ କୁଚିନ୍ତା ପରସ୍ତ୍ରୀୱେଶ୍ୟାଗମନଂ ");
INSERT INTO sanori_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ନରୱଧଶ୍ଚୌର୍ୟ୍ୟଂ ଲୋଭୋ ଦୁଷ୍ଟତା ପ୍ରୱଞ୍ଚନା କାମୁକତା କୁଦୃଷ୍ଟିରୀଶ୍ୱରନିନ୍ଦା ଗର୍ୱ୍ୱସ୍ତମ ଇତ୍ୟାଦୀନି ନିର୍ଗଚ୍ଛନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ଏତାନି ସର୍ୱ୍ୱାଣି ଦୁରିତାନ୍ୟନ୍ତରାଦେତ୍ୟ ନରମମେଧ୍ୟଂ କୁର୍ୱ୍ୱନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","ଅଥ ସ ଉତ୍ଥାଯ ତତ୍ସ୍ଥାନାତ୍ ସୋରସୀଦୋନ୍ପୁରପ୍ରଦେଶଂ ଜଗାମ ତତ୍ର କିମପି ନିୱେଶନଂ ପ୍ରୱିଶ୍ୟ ସର୍ୱ୍ୱୈରଜ୍ଞାତଃ ସ୍ଥାତୁଂ ମତିଞ୍ଚକ୍ରେ କିନ୍ତୁ ଗୁପ୍ତଃ ସ୍ଥାତୁଂ ନ ଶଶାକ| ");
INSERT INTO sanori_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ଯତଃ ସୁରଫୈନିକୀଦେଶୀଯଯୂନାନୀୱଂଶୋଦ୍ଭୱସ୍ତ୍ରିଯାଃ କନ୍ୟା ଭୂତଗ୍ରସ୍ତାସୀତ୍| ସା ସ୍ତ୍ରୀ ତଦ୍ୱାର୍ତ୍ତାଂ ପ୍ରାପ୍ୟ ତତ୍ସମୀପମାଗତ୍ୟ ତଚ୍ଚରଣଯୋଃ ପତିତ୍ୱା ");
INSERT INTO sanori_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ସ୍ୱକନ୍ୟାତୋ ଭୂତଂ ନିରାକର୍ତ୍ତାଂ ତସ୍ମିନ୍ ୱିନଯଂ କୃତୱତୀ| ");
INSERT INTO sanori_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","କିନ୍ତୁ ଯୀଶୁସ୍ତାମୱଦତ୍ ପ୍ରଥମଂ ବାଲକାସ୍ତୃପ୍ୟନ୍ତୁ ଯତୋ ବାଲକାନାଂ ଖାଦ୍ୟଂ ଗୃହୀତ୍ୱା କୁକ୍କୁରେଭ୍ୟୋ ନିକ୍ଷେପୋଽନୁଚିତଃ| ");
INSERT INTO sanori_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","ତଦା ସା ସ୍ତ୍ରୀ ତମୱାଦୀତ୍ ଭୋଃ ପ୍ରଭୋ ତତ୍ ସତ୍ୟଂ ତଥାପି ମଞ୍ଚାଧଃସ୍ଥାଃ କୁକ୍କୁରା ବାଲାନାଂ କରପତିତାନି ଖାଦ୍ୟଖଣ୍ଡାନି ଖାଦନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ତତଃ ସୋଽକଥଯଦ୍ ଏତତ୍କଥାହେତୋଃ ସକୁଶଲା ଯାହି ତୱ କନ୍ୟାଂ ତ୍ୟକ୍ତ୍ୱା ଭୂତୋ ଗତଃ| ");
INSERT INTO sanori_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ଅଥ ସା ସ୍ତ୍ରୀ ଗୃହଂ ଗତ୍ୱା କନ୍ୟାଂ ଭୂତତ୍ୟକ୍ତାଂ ଶଯ୍ୟାସ୍ଥିତାଂ ଦଦର୍ଶ| ");
INSERT INTO sanori_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","ପୁନଶ୍ଚ ସ ସୋରସୀଦୋନ୍ପୁରପ୍ରଦେଶାତ୍ ପ୍ରସ୍ଥାଯ ଦିକାପଲିଦେଶସ୍ୟ ପ୍ରାନ୍ତରଭାଗେନ ଗାଲୀଲ୍ଜଲଧେଃ ସମୀପଂ ଗତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ତଦା ଲୋକୈରେକଂ ବଧିରଂ କଦ୍ୱଦଞ୍ଚ ନରଂ ତନ୍ନିକଟମାନୀଯ ତସ୍ୟ ଗାତ୍ରେ ହସ୍ତମର୍ପଯିତୁଂ ୱିନଯଃ କୃତଃ| ");
INSERT INTO sanori_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ତତୋ ଯୀଶୁ ର୍ଲୋକାରଣ୍ୟାତ୍ ତଂ ନିର୍ଜନମାନୀଯ ତସ୍ୟ କର୍ଣଯୋଙ୍ଗୁଲୀ ର୍ଦଦୌ ନିଷ୍ଠୀୱଂ ଦତ୍ତ୍ୱା ଚ ତଜ୍ଜିହ୍ୱାଂ ପସ୍ପର୍ଶ| ");
INSERT INTO sanori_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ଅନନ୍ତରଂ ସ୍ୱର୍ଗଂ ନିରୀକ୍ଷ୍ୟ ଦୀର୍ଘଂ ନିଶ୍ୱସ୍ୟ ତମୱଦତ୍ ଇତଫତଃ ଅର୍ଥାନ୍ ମୁକ୍ତୋ ଭୂଯାତ୍| ");
INSERT INTO sanori_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ତତସ୍ତତ୍କ୍ଷଣଂ ତସ୍ୟ କର୍ଣୌ ମୁକ୍ତୌ ଜିହ୍ୱାଯାଶ୍ଚ ଜାଡ୍ୟାପଗମାତ୍ ସ ସୁସ୍ପଷ୍ଟୱାକ୍ୟମକଥଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","ଅଥ ସ ତାନ୍ ୱାଢମିତ୍ୟାଦିଦେଶ ଯୂଯମିମାଂ କଥାଂ କସ୍ମୈଚିଦପି ମା କଥଯତ, କିନ୍ତୁ ସ ଯତି ନ୍ୟଷେଧତ୍ ତେ ତତି ବାହୁଲ୍ୟେନ ପ୍ରାଚାରଯନ୍; ");
INSERT INTO sanori_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ତେଽତିଚମତ୍କୃତ୍ୟ ପରସ୍ପରଂ କଥଯାମାସୁଃ ସ ବଧିରାଯ ଶ୍ରୱଣଶକ୍ତିଂ ମୂକାଯ ଚ କଥନଶକ୍ତିଂ ଦତ୍ତ୍ୱା ସର୍ୱ୍ୱଂ କର୍ମ୍ମୋତ୍ତମରୂପେଣ ଚକାର| ");
INSERT INTO sanori_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ତଦା ତତ୍ସମୀପଂ ବହୱୋ ଲୋକା ଆଯାତା ଅତସ୍ତେଷାଂ ଭୋଜ୍ୟଦ୍ରୱ୍ୟାଭାୱାଦ୍ ଯୀଶୁଃ ଶିଷ୍ୟାନାହୂଯ ଜଗାଦ,| ");
INSERT INTO sanori_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","ଲୋକନିୱହେ ମମ କୃପା ଜାଯତେ ତେ ଦିନତ୍ରଯଂ ମଯା ସାର୍ଦ୍ଧଂ ସନ୍ତି ତେଷାଂ ଭୋଜ୍ୟଂ କିମପି ନାସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ତେଷାଂ ମଧ୍ୟେଽନେକେ ଦୂରାଦ୍ ଆଗତାଃ, ଅଭୁକ୍ତେଷୁ ତେଷୁ ମଯା ସ୍ୱଗୃହମଭିପ୍ରହିତେଷୁ ତେ ପଥି କ୍ଲମିଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ଶିଷ୍ୟା ଅୱାଦିଷୁଃ, ଏତାୱତୋ ଲୋକାନ୍ ତର୍ପଯିତୁମ୍ ଅତ୍ର ପ୍ରନ୍ତରେ ପୂପାନ୍ ପ୍ରାପ୍ତୁଂ କେନ ଶକ୍ୟତେ? ");
INSERT INTO sanori_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ତତଃ ସ ତାନ୍ ପପ୍ରଚ୍ଛ ଯୁଷ୍ମାକଂ କତି ପୂପାଃ ସନ୍ତି? ତେଽକଥଯନ୍ ସପ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","ତତଃ ସ ତାଲ୍ଲୋକାନ୍ ଭୁୱି ସମୁପୱେଷ୍ଟୁମ୍ ଆଦିଶ୍ୟ ତାନ୍ ସପ୍ତ ପୂପାନ୍ ଧୃତ୍ୱା ଈଶ୍ୱରଗୁଣାନ୍ ଅନୁକୀର୍ତ୍ତଯାମାସ, ଭଂକ୍ତ୍ୱା ପରିୱେଷଯିତୁଂ ଶିଷ୍ୟାନ୍ ପ୍ରତି ଦଦୌ, ତତସ୍ତେ ଲୋକେଭ୍ୟଃ ପରିୱେଷଯାମାସୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ତଥା ତେଷାଂ ସମୀପେ ଯେ କ୍ଷୁଦ୍ରମତ୍ସ୍ୟା ଆସନ୍ ତାନପ୍ୟାଦାଯ ଈଶ୍ୱରଗୁଣାନ୍ ସଂକୀର୍ତ୍ୟ ପରିୱେଷଯିତୁମ୍ ଆଦିଷ୍ଟୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ତତୋ ଲୋକା ଭୁକ୍ତ୍ୱା ତୃପ୍ତିଂ ଗତା ଅୱଶିଷ୍ଟଖାଦ୍ୟୈଃ ପୂର୍ଣାଃ ସପ୍ତଡଲ୍ଲକା ଗୃହୀତାଶ୍ଚ| ");
INSERT INTO sanori_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ଏତେ ଭୋକ୍ତାରଃ ପ୍ରାଯଶ୍ଚତୁଃ ସହସ୍ରପୁରୁଷା ଆସନ୍ ତତଃ ସ ତାନ୍ ୱିସସର୍ଜ| ");
INSERT INTO sanori_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ଅଥ ସ ଶିଷ୍ୟଃ ସହ ନାୱମାରୁହ୍ୟ ଦଲ୍ମାନୂଥାସୀମାମାଗତଃ| ");
INSERT INTO sanori_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ତତଃ ପରଂ ଫିରୂଶିନ ଆଗତ୍ୟ ତେନ ସହ ୱିୱଦମାନାସ୍ତସ୍ୟ ପରୀକ୍ଷାର୍ଥମ୍ ଆକାଶୀଯଚିହ୍ନଂ ଦ୍ରଷ୍ଟୁଂ ଯାଚିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","ତଦା ସୋଽନ୍ତର୍ଦୀର୍ଘଂ ନିଶ୍ୱସ୍ୟାକଥଯତ୍, ଏତେ ୱିଦ୍ୟମାନନରାଃ କୁତଶ୍ଚିନ୍ହଂ ମୃଗଯନ୍ତେ? ଯୁଷ୍ମାନହଂ ଯଥାର୍ଥଂ ବ୍ରୱୀମି ଲୋକାନେତାନ୍ କିମପି ଚିହ୍ନଂ ନ ଦର୍ଶଯିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ଅଥ ତାନ୍ ହିତ୍ୱା ପୁନ ର୍ନାୱମ୍ ଆରୁହ୍ୟ ପାରମଗାତ୍| ");
INSERT INTO sanori_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ଏତର୍ହି ଶିଷ୍ୟୈଃ ପୂପେଷୁ ୱିସ୍ମୃତେଷୁ ନାୱି ତେଷାଂ ସନ୍ନିଧୌ ପୂପ ଏକଏୱ ସ୍ଥିତଃ| ");
INSERT INTO sanori_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ତଦାନୀଂ ଯୀଶୁସ୍ତାନ୍ ଆଦିଷ୍ଟୱାନ୍ ଫିରୂଶିନାଂ ହେରୋଦଶ୍ଚ କିଣ୍ୱଂ ପ୍ରତି ସତର୍କାଃ ସାୱଧାନାଶ୍ଚ ଭୱତ| ");
INSERT INTO sanori_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ତତସ୍ତେଽନ୍ୟୋନ୍ୟଂ ୱିୱେଚନଂ କର୍ତୁମ୍ ଆରେଭିରେ, ଅସ୍ମାକଂ ସନ୍ନିଧୌ ପୂପୋ ନାସ୍ତୀତି ହେତୋରିଦଂ କଥଯତି| ");
INSERT INTO sanori_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ତଦ୍ ବୁଦ୍ୱ୍ୱା ଯୀଶୁସ୍ତେଭ୍ୟୋଽକଥଯତ୍ ଯୁଷ୍ମାକଂ ସ୍ଥାନେ ପୂପାଭାୱାତ୍ କୁତ ଇତ୍ଥଂ ୱିତର୍କଯଥ? ଯୂଯଂ କିମଦ୍ୟାପି କିମପି ନ ଜାନୀଥ? ବୋଦ୍ଧୁଞ୍ଚ ନ ଶକ୍ନୁଥ? ଯାୱଦଦ୍ୟ କିଂ ଯୁଷ୍ମାକଂ ମନାଂସି କଠିନାନି ସନ୍ତି? ");
INSERT INTO sanori_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","ସତ୍ସୁ ନେତ୍ରେଷୁ କିଂ ନ ପଶ୍ୟଥ? ସତ୍ସୁ କର୍ଣେଷୁ କିଂ ନ ଶୃଣୁଥ? ନ ସ୍ମରଥ ଚ? ");
INSERT INTO sanori_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ଯଦାହଂ ପଞ୍ଚପୂପାନ୍ ପଞ୍ଚସହସ୍ରାଣାଂ ପୁରୁଷାଣାଂ ମଧ୍ୟେ ଭଂକ୍ତ୍ୱା ଦତ୍ତୱାନ୍ ତଦାନୀଂ ଯୂଯମ୍ ଅୱଶିଷ୍ଟପୂପୈଃ ପୂର୍ଣାନ୍ କତି ଡଲ୍ଲକାନ୍ ଗୃହୀତୱନ୍ତଃ? ତେଽକଥଯନ୍ ଦ୍ୱାଦଶଡଲ୍ଲକାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","ଅପରଞ୍ଚ ଯଦା ଚତୁଃସହସ୍ରାଣାଂ ପୁରୁଷାଣାଂ ମଧ୍ୟେ ପୂପାନ୍ ଭଂକ୍ତ୍ୱାଦଦାଂ ତଦା ଯୂଯମ୍ ଅତିରିକ୍ତପୂପାନାଂ କତି ଡଲ୍ଲକାନ୍ ଗୃହୀତୱନ୍ତଃ? ତେ କଥଯାମାସୁଃ ସପ୍ତଡଲ୍ଲକାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ତଦା ସ କଥିତୱାନ୍ ତର୍ହି ଯୂଯମ୍ ଅଧୁନାପି କୁତୋ ବୋଦ୍ୱ୍ୱୁଂ ନ ଶକ୍ନୁଥ? ");
INSERT INTO sanori_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","ଅନନ୍ତରଂ ତସ୍ମିନ୍ ବୈତ୍ସୈଦାନଗରେ ପ୍ରାପ୍ତେ ଲୋକା ଅନ୍ଧମେକଂ ନରଂ ତତ୍ସମୀପମାନୀଯ ତଂ ସ୍ପ୍ରଷ୍ଟୁଂ ତଂ ପ୍ରାର୍ଥଯାଞ୍ଚକ୍ରିରେ| ");
INSERT INTO sanori_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ତଦା ତସ୍ୟାନ୍ଧସ୍ୟ କରୌ ଗୃହୀତ୍ୱା ନଗରାଦ୍ ବହିର୍ଦେଶଂ ତଂ ନୀତୱାନ୍; ତନ୍ନେତ୍ରେ ନିଷ୍ଠୀୱଂ ଦତ୍ତ୍ୱା ତଦ୍ଗାତ୍ରେ ହସ୍ତାୱର୍ପଯିତ୍ୱା ତଂ ପପ୍ରଚ୍ଛ, କିମପି ପଶ୍ୟସି? ");
INSERT INTO sanori_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ସ ନେତ୍ରେ ଉନ୍ମୀଲ୍ୟ ଜଗାଦ, ୱୃକ୍ଷୱତ୍ ମନୁଜାନ୍ ଗଚ୍ଛତୋ ନିରୀକ୍ଷେ| ");
INSERT INTO sanori_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ତତୋ ଯୀଶୁଃ ପୁନସ୍ତସ୍ୟ ନଯନଯୋ ର୍ହସ୍ତାୱର୍ପଯିତ୍ୱା ତସ୍ୟ ନେତ୍ରେ ଉନ୍ମୀଲଯାମାସ; ତସ୍ମାତ୍ ସ ସ୍ୱସ୍ଥୋ ଭୂତ୍ୱା ସ୍ପଷ୍ଟରୂପଂ ସର୍ୱ୍ୱଲୋକାନ୍ ଦଦର୍ଶ| ");
INSERT INTO sanori_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ତତଃ ପରଂ ତ୍ୱଂ ଗ୍ରାମଂ ମା ଗଚ୍ଛ ଗ୍ରାମସ୍ଥଂ କମପି ଚ କିମପ୍ୟନୁକ୍ତ୍ୱା ନିଜଗୃହଂ ଯାହୀତ୍ୟାଦିଶ୍ୟ ଯୀଶୁସ୍ତଂ ନିଜଗୃହଂ ପ୍ରହିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","ଅନନ୍ତରଂ ଶିଷ୍ୟୈଃ ସହିତୋ ଯୀଶୁଃ କୈସରୀଯାଫିଲିପିପୁରଂ ଜଗାମ, ପଥି ଗଚ୍ଛନ୍ ତାନପୃଚ୍ଛତ୍ କୋଽହମ୍ ଅତ୍ର ଲୋକାଃ କିଂ ୱଦନ୍ତି? ");
INSERT INTO sanori_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","ତେ ପ୍ରତ୍ୟୂଚୁଃ ତ୍ୱାଂ ଯୋହନଂ ମଜ୍ଜକଂ ୱଦନ୍ତି କିନ୍ତୁ କେପି କେପି ଏଲିଯଂ ୱଦନ୍ତି; ଅପରେ କେପି କେପି ଭୱିଷ୍ୟଦ୍ୱାଦିନାମ୍ ଏକୋ ଜନ ଇତି ୱଦନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","ଅଥ ସ ତାନପୃଚ୍ଛତ୍ କିନ୍ତୁ କୋହମ୍? ଇତ୍ୟତ୍ର ଯୂଯଂ କିଂ ୱଦଥ? ତଦା ପିତରଃ ପ୍ରତ୍ୟୱଦତ୍ ଭୱାନ୍ ଅଭିଷିକ୍ତସ୍ତ୍ରାତା| ");
INSERT INTO sanori_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","ତତଃ ସ ତାନ୍ ଗାଢମାଦିଶଦ୍ ଯୂଯଂ ମମ କଥା କସ୍ମୈଚିଦପି ମା କଥଯତ| ");
INSERT INTO sanori_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","ମନୁଷ୍ୟପୁତ୍ରେଣାୱଶ୍ୟଂ ବହୱୋ ଯାତନା ଭୋକ୍ତୱ୍ୟାଃ ପ୍ରାଚୀନଲୋକୈଃ ପ୍ରଧାନଯାଜକୈରଧ୍ୟାପକୈଶ୍ଚ ସ ନିନ୍ଦିତଃ ସନ୍ ଘାତଯିଷ୍ୟତେ ତୃତୀଯଦିନେ ଉତ୍ଥାସ୍ୟତି ଚ, ଯୀଶୁଃ ଶିଷ୍ୟାନୁପଦେଷ୍ଟୁମାରଭ୍ୟ କଥାମିମାଂ ସ୍ପଷ୍ଟମାଚଷ୍ଟ| ");
INSERT INTO sanori_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ତସ୍ମାତ୍ ପିତରସ୍ତସ୍ୟ ହସ୍ତୌ ଧୃତ୍ୱା ତଂ ତର୍ଜ୍ଜିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","କିନ୍ତୁ ସ ମୁଖଂ ପରାୱର୍ତ୍ୟ ଶିଷ୍ୟଗଣଂ ନିରୀକ୍ଷ୍ୟ ପିତରଂ ତର୍ଜଯିତ୍ୱାୱାଦୀଦ୍ ଦୂରୀଭୱ ୱିଘ୍ନକାରିନ୍ ଈଶ୍ୱରୀଯକାର୍ୟ୍ୟାଦପି ମନୁଷ୍ୟକାର୍ୟ୍ୟଂ ତୁଭ୍ୟଂ ରୋଚତତରାଂ| ");
INSERT INTO sanori_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ଅଥ ସ ଲୋକାନ୍ ଶିଷ୍ୟାଂଶ୍ଚାହୂଯ ଜଗାଦ ଯଃ କଶ୍ଚିନ୍ ମାମନୁଗନ୍ତୁମ୍ ଇଚ୍ଛତି ସ ଆତ୍ମାନଂ ଦାମ୍ୟତୁ, ସ୍ୱକ୍ରୁଶଂ ଗୃହୀତ୍ୱା ମତ୍ପଶ୍ଚାଦ୍ ଆଯାତୁ| ");
INSERT INTO sanori_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ଯତୋ ଯଃ କଶ୍ଚିତ୍ ସ୍ୱପ୍ରାଣଂ ରକ୍ଷିତୁମିଚ୍ଛତି ସ ତଂ ହାରଯିଷ୍ୟତି, କିନ୍ତୁ ଯଃ କଶ୍ଚିନ୍ ମଦର୍ଥଂ ସୁସଂୱାଦାର୍ଥଞ୍ଚ ପ୍ରାଣଂ ହାରଯତି ସ ତଂ ରକ୍ଷିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","ଅପରଞ୍ଚ ମନୁଜଃ ସର୍ୱ୍ୱଂ ଜଗତ୍ ପ୍ରାପ୍ୟ ଯଦି ସ୍ୱପ୍ରାଣଂ ହାରଯତି ତର୍ହି ତସ୍ୟ କୋ ଲାଭଃ? ");
INSERT INTO sanori_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","ନରଃ ସ୍ୱପ୍ରାଣୱିନିମଯେନ କିଂ ଦାତୁଂ ଶକ୍ନୋତି? ");
INSERT INTO sanori_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ଏତେଷାଂ ୱ୍ୟଭିଚାରିଣାଂ ପାପିନାଞ୍ଚ ଲୋକାନାଂ ସାକ୍ଷାଦ୍ ଯଦି କୋପି ମାଂ ମତ୍କଥାଞ୍ଚ ଲଜ୍ଜାସ୍ପଦଂ ଜାନାତି ତର୍ହି ମନୁଜପୁତ୍ରୋ ଯଦା ଧର୍ମ୍ମଦୂତୈଃ ସହ ପିତୁଃ ପ୍ରଭାୱେଣାଗମିଷ୍ୟତି ତଦା ସୋପି ତଂ ଲଜ୍ଜାସ୍ପଦଂ ଜ୍ଞାସ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","ଅଥ ସ ତାନୱାଦୀତ୍ ଯୁଷ୍ମଭ୍ୟମହଂ ଯଥାର୍ଥଂ କଥଯାମି, ଈଶ୍ୱରରାଜ୍ୟଂ ପରାକ୍ରମେଣୋପସ୍ଥିତଂ ନ ଦୃଷ୍ଟ୍ୱା ମୃତ୍ୟୁଂ ନାସ୍ୱାଦିଷ୍ୟନ୍ତେ, ଅତ୍ର ଦଣ୍ଡାଯମାନାନାଂ ମଧ୍ୟେପି ତାଦୃଶା ଲୋକାଃ ସନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","ଅଥ ଷଡ୍ଦିନେଭ୍ୟଃ ପରଂ ଯୀଶୁଃ ପିତରଂ ଯାକୂବଂ ଯୋହନଞ୍ଚ ଗୃହୀତ୍ୱା ଗିରେରୁଚ୍ଚସ୍ୟ ନିର୍ଜନସ୍ଥାନଂ ଗତ୍ୱା ତେଷାଂ ପ୍ରତ୍ୟକ୍ଷେ ମୂର୍ତ୍ୟନ୍ତରଂ ଦଧାର| ");
INSERT INTO sanori_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ତତସ୍ତସ୍ୟ ପରିଧେଯମ୍ ଈଦୃଶମ୍ ଉଜ୍ଜ୍ୱଲହିମପାଣଡରଂ ଜାତଂ ଯଦ୍ ଜଗତି କୋପି ରଜକୋ ନ ତାଦୃକ୍ ପାଣଡରଂ କର୍ତ୍ତାଂ ଶକ୍ନୋତି| ");
INSERT INTO sanori_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","ଅପରଞ୍ଚ ଏଲିଯୋ ମୂସାଶ୍ଚ ତେଭ୍ୟୋ ଦର୍ଶନଂ ଦତ୍ତ୍ୱା ଯୀଶୁନା ସହ କଥନଂ କର୍ତ୍ତୁମାରେଭାତେ| ");
INSERT INTO sanori_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ତଦା ପିତରୋ ଯୀଶୁମୱାଦୀତ୍ ହେ ଗୁରୋଽସ୍ମାକମତ୍ର ସ୍ଥିତିରୁତ୍ତମା, ତତଏୱ ୱଯଂ ତ୍ୱତ୍କୃତେ ଏକାଂ ମୂସାକୃତେ ଏକାମ୍ ଏଲିଯକୃତେ ଚୈକାଂ, ଏତାସ୍ତିସ୍ରଃ କୁଟୀ ର୍ନିର୍ମ୍ମାମ| ");
INSERT INTO sanori_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","କିନ୍ତୁ ସ ଯଦୁକ୍ତୱାନ୍ ତତ୍ ସ୍ୱଯଂ ନ ବୁବୁଧେ ତତଃ ସର୍ୱ୍ୱେ ବିଭଯାଞ୍ଚକ୍ରୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ଏତର୍ହି ପଯୋଦସ୍ତାନ୍ ଛାଦଯାମାସ, ମମଯାଂ ପ୍ରିଯଃ ପୁତ୍ରଃ କଥାସୁ ତସ୍ୟ ମନାଂସି ନିୱେଶଯତେତି ନଭୋୱାଣୀ ତନ୍ମେଦ୍ୟାନ୍ନିର୍ୟଯୌ| ");
INSERT INTO sanori_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","ଅଥ ହଠାତ୍ତେ ଚତୁର୍ଦିଶୋ ଦୃଷ୍ଟ୍ୱା ଯୀଶୁଂ ୱିନା ସ୍ୱୈଃ ସହିତଂ କମପି ନ ଦଦୃଶୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ତତଃ ପରଂ ଗିରେରୱରୋହଣକାଲେ ସ ତାନ୍ ଗାଢମ୍ ଦୂତ୍ୟାଦିଦେଶ ଯାୱନ୍ନରସୂନୋଃ ଶ୍ମଶାନାଦୁତ୍ଥାନଂ ନ ଭୱତି, ତାୱତ୍ ଦର୍ଶନସ୍ୟାସ୍ୟ ୱାର୍ତ୍ତା ଯୁଷ୍ମାଭିଃ କସ୍ମୈଚିଦପି ନ ୱକ୍ତୱ୍ୟା| ");
INSERT INTO sanori_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ତଦା ଶ୍ମଶାନାଦୁତ୍ଥାନସ୍ୟ କୋଭିପ୍ରାଯ ଇତି ୱିଚାର୍ୟ୍ୟ ତେ ତଦ୍ୱାକ୍ୟଂ ସ୍ୱେଷୁ ଗୋପାଯାଞ୍ଚକ୍ରିରେ| ");
INSERT INTO sanori_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ଅଥ ତେ ଯୀଶୁଂ ପପ୍ରଚ୍ଛୁଃ ପ୍ରଥମତ ଏଲିଯେନାଗନ୍ତୱ୍ୟମ୍ ଇତି ୱାକ୍ୟଂ କୁତ ଉପାଧ୍ୟାଯା ଆହୁଃ? ");
INSERT INTO sanori_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","ତଦା ସ ପ୍ରତ୍ୟୁୱାଚ , ଏଲିଯଃ ପ୍ରଥମମେତ୍ୟ ସର୍ୱ୍ୱକାର୍ୟ୍ୟାଣି ସାଧଯିଷ୍ୟତି; ନରପୁତ୍ରେ ଚ ଲିପି ର୍ୟଥାସ୍ତେ ତଥୈୱ ସୋପି ବହୁଦୁଃଖଂ ପ୍ରାପ୍ୟାୱଜ୍ଞାସ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","କିନ୍ତ୍ୱହଂ ଯୁଷ୍ମାନ୍ ୱଦାମି , ଏଲିଯାର୍ଥେ ଲିପି ର୍ୟଥାସ୍ତେ ତଥୈୱ ସ ଏତ୍ୟ ଯଯୌ, ଲୋକା: ସ୍ୱେଚ୍ଛାନୁରୂପଂ ତମଭିୱ୍ୟୱହରନ୍ତି ସ୍ମ| ");
INSERT INTO sanori_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","ଅନନ୍ତରଂ ସ ଶିଷ୍ୟସମୀପମେତ୍ୟ ତେଷାଂ ଚତୁଃପାର୍ଶ୍ୱେ ତୈଃ ସହ ବହୁଜନାନ୍ ୱିୱଦମାନାନ୍ ଅଧ୍ୟାପକାଂଶ୍ଚ ଦୃଷ୍ଟୱାନ୍; ");
INSERT INTO sanori_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","କିନ୍ତୁ ସର୍ୱ୍ୱଲୋକାସ୍ତଂ ଦୃଷ୍ଟ୍ୱୈୱ ଚମତ୍କୃତ୍ୟ ତଦାସନ୍ନଂ ଧାୱନ୍ତସ୍ତଂ ପ୍ରଣେମୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ତଦା ଯୀଶୁରଧ୍ୟାପକାନପ୍ରାକ୍ଷୀଦ୍ ଏତୈଃ ସହ ଯୂଯଂ କିଂ ୱିୱଦଧ୍ୱେ? ");
INSERT INTO sanori_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ତତୋ ଲୋକାନାଂ କଶ୍ଚିଦେକଃ ପ୍ରତ୍ୟୱାଦୀତ୍ ହେ ଗୁରୋ ମମ ସୂନୁଂ ମୂକଂ ଭୂତଧୃତଞ୍ଚ ଭୱଦାସନ୍ନମ୍ ଆନଯଂ| ");
INSERT INTO sanori_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ଯଦାସୌ ଭୂତସ୍ତମାକ୍ରମତେ ତଦୈୱ ପାତସତି ତଥା ସ ଫେଣାଯତେ, ଦନ୍ତୈର୍ଦନ୍ତାନ୍ ଘର୍ଷତି କ୍ଷୀଣୋ ଭୱତି ଚ; ତତୋ ହେତୋସ୍ତଂ ଭୂତଂ ତ୍ୟାଜଯିତୁଂ ଭୱଚ୍ଛିଷ୍ୟାନ୍ ନିୱେଦିତୱାନ୍ କିନ୍ତୁ ତେ ନ ଶେକୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ତଦା ସ ତମୱାଦୀତ୍, ରେ ଅୱିଶ୍ୱାସିନଃ ସନ୍ତାନା ଯୁଷ୍ମାଭିଃ ସହ କତି କାଲାନହଂ ସ୍ଥାସ୍ୟାମି? ଅପରାନ୍ କତି କାଲାନ୍ ୱା ୱ ଆଚାରାନ୍ ସହିଷ୍ୟେ? ତଂ ମଦାସନ୍ନମାନଯତ| ");
INSERT INTO sanori_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ତତସ୍ତତ୍ସନ୍ନିଧିଂ ସ ଆନୀଯତ କିନ୍ତୁ ତଂ ଦୃଷ୍ଟ୍ୱୈୱ ଭୂତୋ ବାଲକଂ ଧୃତୱାନ୍; ସ ଚ ଭୂମୌ ପତିତ୍ୱା ଫେଣାଯମାନୋ ଲୁଲୋଠ| ");
INSERT INTO sanori_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","ତଦା ସ ତତ୍ପିତରଂ ପପ୍ରଚ୍ଛ, ଅସ୍ୟେଦୃଶୀ ଦଶା କତି ଦିନାନି ଭୂତା? ତତଃ ସୋୱାଦୀତ୍ ବାଲ୍ୟକାଲାତ୍| ");
INSERT INTO sanori_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","ଭୂତୋଯଂ ତଂ ନାଶଯିତୁଂ ବହୁୱାରାନ୍ ୱହ୍ନୌ ଜଲେ ଚ ନ୍ୟକ୍ଷିପତ୍ କିନ୍ତୁ ଯଦି ଭୱାନ କିମପି କର୍ତ୍ତାଂ ଶକ୍ନୋତି ତର୍ହି ଦଯାଂ କୃତ୍ୱାସ୍ମାନ୍ ଉପକରୋତୁ| ");
INSERT INTO sanori_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ତଦା ଯୀଶୁସ୍ତମୱଦତ୍ ଯଦି ପ୍ରତ୍ୟେତୁଂ ଶକ୍ନୋଷି ତର୍ହି ପ୍ରତ୍ୟଯିନେ ଜନାଯ ସର୍ୱ୍ୱଂ ସାଧ୍ୟମ୍| ");
INSERT INTO sanori_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ତତସ୍ତତ୍କ୍ଷଣଂ ତଦ୍ବାଲକସ୍ୟ ପିତା ପ୍ରୋଚ୍ଚୈ ରୂୱନ୍ ସାଶ୍ରୁନେତ୍ରଃ ପ୍ରୋୱାଚ, ପ୍ରଭୋ ପ୍ରତ୍ୟେମି ମମାପ୍ରତ୍ୟଯଂ ପ୍ରତିକୁରୁ| ");
INSERT INTO sanori_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","ଅଥ ଯୀଶୁ ର୍ଲୋକସଙ୍ଘଂ ଧାୱିତ୍ୱାଯାନ୍ତଂ ଦୃଷ୍ଟ୍ୱା ତମପୂତଭୂତଂ ତର୍ଜଯିତ୍ୱା ଜଗାଦ, ରେ ବଧିର ମୂକ ଭୂତ ତ୍ୱମେତସ୍ମାଦ୍ ବହିର୍ଭୱ ପୁନଃ କଦାପି ମାଶ୍ରଯୈନଂ ତ୍ୱାମହମ୍ ଇତ୍ୟାଦିଶାମି| ");
INSERT INTO sanori_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ତଦା ସ ଭୂତଶ୍ଚୀତ୍ଶବ୍ଦଂ କୃତ୍ୱା ତମାପୀଡ୍ୟ ବହିର୍ଜଜାମ, ତତୋ ବାଲକୋ ମୃତକଲ୍ପୋ ବଭୂୱ ତସ୍ମାଦଯଂ ମୃତଇତ୍ୟନେକେ କଥଯାମାସୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","କିନ୍ତୁ କରଂ ଧୃତ୍ୱା ଯୀଶୁନୋତ୍ଥାପିତଃ ସ ଉତ୍ତସ୍ଥୌ| ");
INSERT INTO sanori_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","ଅଥ ଯୀଶୌ ଗୃହଂ ପ୍ରୱିଷ୍ଟେ ଶିଷ୍ୟା ଗୁପ୍ତଂ ତଂ ପପ୍ରଚ୍ଛୁଃ, ୱଯମେନଂ ଭୂତଂ ତ୍ୟାଜଯିତୁଂ କୁତୋ ନ ଶକ୍ତାଃ? ");
INSERT INTO sanori_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ସ ଉୱାଚ, ପ୍ରାର୍ଥନୋପୱାସୌ ୱିନା କେନାପ୍ୟନ୍ୟେନ କର୍ମ୍ମଣା ଭୂତମୀଦୃଶଂ ତ୍ୟାଜଯିତୁଂ ନ ଶକ୍ୟଂ| ");
INSERT INTO sanori_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","ଅନନ୍ତରଂ ସ ତତ୍ସ୍ଥାନାଦିତ୍ୱା ଗାଲୀଲ୍ମଧ୍ୟେନ ଯଯୌ, କିନ୍ତୁ ତତ୍ କୋପି ଜାନୀଯାଦିତି ସ ନୈଚ୍ଛତ୍| ");
INSERT INTO sanori_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ଅପରଞ୍ଚ ସ ଶିଷ୍ୟାନୁପଦିଶନ୍ ବଭାଷେ, ନରପୁତ୍ରୋ ନରହସ୍ତେଷୁ ସମର୍ପଯିଷ୍ୟତେ ତେ ଚ ତଂ ହନିଷ୍ୟନ୍ତି ତୈସ୍ତସ୍ମିନ୍ ହତେ ତୃତୀଯଦିନେ ସ ଉତ୍ଥାସ୍ୟତୀତି| ");
INSERT INTO sanori_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","କିନ୍ତୁ ତତ୍କଥାଂ ତେ ନାବୁଧ୍ୟନ୍ତ ପ୍ରଷ୍ଟୁଞ୍ଚ ବିଭ୍ୟଃ| ");
INSERT INTO sanori_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","ଅଥ ଯୀଶୁଃ କଫର୍ନାହୂମ୍ପୁରମାଗତ୍ୟ ମଧ୍ୟେଗୃହଞ୍ଚେତ୍ୟ ତାନପୃଚ୍ଛଦ୍ ୱର୍ତ୍ମମଧ୍ୟେ ଯୂଯମନ୍ୟୋନ୍ୟଂ କିଂ ୱିୱଦଧ୍ୱେ ସ୍ମ? ");
INSERT INTO sanori_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","କିନ୍ତୁ ତେ ନିରୁତ୍ତରାସ୍ତସ୍ଥୁ ର୍ୟସ୍ମାତ୍ତେଷାଂ କୋ ମୁଖ୍ୟ ଇତି ୱର୍ତ୍ମାନି ତେଽନ୍ୟୋନ୍ୟଂ ୱ୍ୟୱଦନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ତତଃ ସ ଉପୱିଶ୍ୟ ଦ୍ୱାଦଶଶିଷ୍ୟାନ୍ ଆହୂଯ ବଭାଷେ ଯଃ କଶ୍ଚିତ୍ ମୁଖ୍ୟୋ ଭୱିତୁମିଚ୍ଛତି ସ ସର୍ୱ୍ୱେଭ୍ୟୋ ଗୌଣଃ ସର୍ୱ୍ୱେଷାଂ ସେୱକଶ୍ଚ ଭୱତୁ| ");
INSERT INTO sanori_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","ତଦା ସ ବାଲକମେକଂ ଗୃହୀତ୍ୱା ମଧ୍ୟେ ସମୁପାୱେଶଯତ୍ ତତସ୍ତଂ କ୍ରୋଡେ କୃତ୍ୱା ତାନୱାଦାତ୍ ");
INSERT INTO sanori_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","ଯଃ କଶ୍ଚିଦୀଦୃଶସ୍ୟ କସ୍ୟାପି ବାଲସ୍ୟାତିଥ୍ୟଂ କରୋତି ସ ମମାତିଥ୍ୟଂ କରୋତି; ଯଃ କଶ୍ଚିନ୍ମମାତିଥ୍ୟଂ କରୋତି ସ କେୱଲମ୍ ମମାତିଥ୍ୟଂ କରୋତି ତନ୍ନ ମତ୍ପ୍ରେରକସ୍ୟାପ୍ୟାତିଥ୍ୟଂ କରୋତି| ");
INSERT INTO sanori_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ଅଥ ଯୋହନ୍ ତମବ୍ରୱୀତ୍ ହେ ଗୁରୋ, ଅସ୍ମାକମନନୁଗାମିନମ୍ ଏକଂ ତ୍ୱାନ୍ନାମ୍ନା ଭୂତାନ୍ ତ୍ୟାଜଯନ୍ତଂ ୱଯଂ ଦୃଷ୍ଟୱନ୍ତଃ, ଅସ୍ମାକମପଶ୍ଚାଦ୍ଗାମିତ୍ୱାଚ୍ଚ ତଂ ନ୍ୟଷେଧାମ| ");
INSERT INTO sanori_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","କିନ୍ତୁ ଯୀଶୁରୱଦତ୍ ତଂ ମା ନିଷେଧତ୍, ଯତୋ ଯଃ କଶ୍ଚିନ୍ ମନ୍ନାମ୍ନା ଚିତ୍ରଂ କର୍ମ୍ମ କରୋତି ସ ସହସା ମାଂ ନିନ୍ଦିତୁଂ ନ ଶକ୍ନୋତି| ");
INSERT INTO sanori_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ତଥା ଯଃ କଶ୍ଚିଦ୍ ଯୁଷ୍ମାକଂ ୱିପକ୍ଷତାଂ ନ କରୋତି ସ ଯୁଷ୍ମାକମେୱ ସପକ୍ଷଃ| ");
INSERT INTO sanori_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ଯଃ କଶ୍ଚିଦ୍ ଯୁଷ୍ମାନ୍ ଖ୍ରୀଷ୍ଟଶିଷ୍ୟାନ୍ ଜ୍ଞାତ୍ୱା ମନ୍ନାମ୍ନା କଂସୈକେନ ପାନୀଯଂ ପାତୁଂ ଦଦାତି, ଯୁଷ୍ମାନହଂ ଯଥାର୍ଥଂ ୱଚ୍ମି, ସ ଫଲେନ ୱଞ୍ଚିତୋ ନ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","କିନ୍ତୁ ଯଦି କଶ୍ଚିନ୍ ମଯି ୱିଶ୍ୱାସିନାମେଷାଂ କ୍ଷୁଦ୍ରପ୍ରାଣିନାମ୍ ଏକସ୍ୟାପି ୱିଘ୍ନଂ ଜନଯତି, ତର୍ହି ତସ୍ୟୈତତ୍କର୍ମ୍ମ କରଣାତ୍ କଣ୍ଠବଦ୍ଧପେଷଣୀକସ୍ୟ ତସ୍ୟ ସାଗରାଗାଧଜଲ ମଜ୍ଜନଂ ଭଦ୍ରଂ| ");
INSERT INTO sanori_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","ଅତଃ ସ୍ୱକରୋ ଯଦି ତ୍ୱାଂ ବାଧତେ ତର୍ହି ତଂ ଛିନ୍ଧି; ");
INSERT INTO sanori_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ଯସ୍ମାତ୍ ଯତ୍ର କୀଟା ନ ମ୍ରିଯନ୍ତେ ୱହ୍ନିଶ୍ଚ ନ ନିର୍ୱ୍ୱାତି, ତସ୍ମିନ୍ ଅନିର୍ୱ୍ୱାଣାନଲନରକେ କରଦ୍ୱଯୱସ୍ତୱ ଗମନାତ୍ କରହୀନସ୍ୟ ସ୍ୱର୍ଗପ୍ରୱେଶସ୍ତୱ କ୍ଷେମଂ| ");
INSERT INTO sanori_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","ଯଦି ତୱ ପାଦୋ ୱିଘ୍ନଂ ଜନଯତି ତର୍ହି ତଂ ଛିନ୍ଧି, ");
INSERT INTO sanori_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ଯତୋ ଯତ୍ର କୀଟା ନ ମ୍ରିଯନ୍ତେ ୱହ୍ନିଶ୍ଚ ନ ନିର୍ୱ୍ୱାତି, ତସ୍ମିନ୍ ଽନିର୍ୱ୍ୱାଣୱହ୍ନୌ ନରକେ ଦ୍ୱିପାଦୱତସ୍ତୱ ନିକ୍ଷେପାତ୍ ପାଦହୀନସ୍ୟ ସ୍ୱର୍ଗପ୍ରୱେଶସ୍ତୱ କ୍ଷେମଂ| ");
INSERT INTO sanori_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","ସ୍ୱନେତ୍ରଂ ଯଦି ତ୍ୱାଂ ବାଧତେ ତର୍ହି ତଦପ୍ୟୁତ୍ପାଟଯ, ଯତୋ ଯତ୍ର କୀଟା ନ ମ୍ରିଯନ୍ତେ ୱହ୍ନିଶ୍ଚ ନ ନିର୍ୱ୍ୱାତି, ");
INSERT INTO sanori_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ତସ୍ମିନ ଽନିର୍ୱ୍ୱାଣୱହ୍ନୌ ନରକେ ଦ୍ୱିନେତ୍ରସ୍ୟ ତୱ ନିକ୍ଷେପାଦ୍ ଏକନେତ୍ରୱତ ଈଶ୍ୱରରାଜ୍ୟେ ପ୍ରୱେଶସ୍ତୱ କ୍ଷେମଂ| ");
INSERT INTO sanori_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","ଯଥା ସର୍ୱ୍ୱୋ ବଲି ର୍ଲୱଣାକ୍ତଃ କ୍ରିଯତେ ତଥା ସର୍ୱ୍ୱୋ ଜନୋ ୱହ୍ନିରୂପେଣ ଲୱଣାକ୍ତଃ କାରିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","ଲୱଣଂ ଭଦ୍ରଂ କିନ୍ତୁ ଯଦି ଲୱଣେ ସ୍ୱାଦୁତା ନ ତିଷ୍ଠତି, ତର୍ହି କଥମ୍ ଆସ୍ୱାଦ୍ୟୁକ୍ତଂ କରିଷ୍ୟଥ? ଯୂଯଂ ଲୱଣଯୁକ୍ତା ଭୱତ ପରସ୍ପରଂ ପ୍ରେମ କୁରୁତ| ");
INSERT INTO sanori_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","ଅନନ୍ତରଂ ସ ତତ୍ସ୍ଥାନାତ୍ ପ୍ରସ୍ଥାଯ ଯର୍ଦ୍ଦନନଦ୍ୟାଃ ପାରେ ଯିହୂଦାପ୍ରଦେଶ ଉପସ୍ଥିତୱାନ୍, ତତ୍ର ତଦନ୍ତିକେ ଲୋକାନାଂ ସମାଗମେ ଜାତେ ସ ନିଜରୀତ୍ୟନୁସାରେଣ ପୁନସ୍ତାନ୍ ଉପଦିଦେଶ| ");
INSERT INTO sanori_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ତଦା ଫିରୂଶିନସ୍ତତ୍ସମୀପମ୍ ଏତ୍ୟ ତଂ ପରୀକ୍ଷିତୁଂ ପପ୍ରଚ୍ଛଃ ସ୍ୱଜାଯା ମନୁଜାନାଂ ତ୍ୟଜ୍ୟା ନ ୱେତି? ");
INSERT INTO sanori_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ତତଃ ସ ପ୍ରତ୍ୟୱାଦୀତ୍, ଅତ୍ର କାର୍ୟ୍ୟେ ମୂସା ଯୁଷ୍ମାନ୍ ପ୍ରତି କିମାଜ୍ଞାପଯତ୍? ");
INSERT INTO sanori_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ତ ଊଚୁଃ ତ୍ୟାଗପତ୍ରଂ ଲେଖିତୁଂ ସ୍ୱପତ୍ନୀଂ ତ୍ୟକ୍ତୁଞ୍ଚ ମୂସାଽନୁମନ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","ତଦା ଯୀଶୁଃ ପ୍ରତ୍ୟୁୱାଚ, ଯୁଷ୍ମାକଂ ମନସାଂ କାଠିନ୍ୟାଦ୍ଧେତୋ ର୍ମୂସା ନିଦେଶମିମମ୍ ଅଲିଖତ୍| ");
INSERT INTO sanori_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","କିନ୍ତୁ ସୃଷ୍ଟେରାଦୌ ଈଶ୍ୱରୋ ନରାନ୍ ପୁଂରୂପେଣ ସ୍ତ୍ରୀରୂପେଣ ଚ ସସର୍ଜ| ");
INSERT INTO sanori_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","\"ତତଃ କାରଣାତ୍ ପୁମାନ୍ ପିତରଂ ମାତରଞ୍ଚ ତ୍ୟକ୍ତ୍ୱା ସ୍ୱଜାଯାଯାମ୍ ଆସକ୍ତୋ ଭୱିଷ୍ୟତି, ");
INSERT INTO sanori_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ତୌ ଦ୍ୱାୱ୍ ଏକାଙ୍ଗୌ ଭୱିଷ୍ୟତଃ| \" ତସ୍ମାତ୍ ତତ୍କାଲମାରଭ୍ୟ ତୌ ନ ଦ୍ୱାୱ୍ ଏକାଙ୍ଗୌ| ");
INSERT INTO sanori_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ଅତଃ କାରଣାଦ୍ ଈଶ୍ୱରୋ ଯଦଯୋଜଯତ୍ କୋପି ନରସ୍ତନ୍ନ ୱିଯେଜଯେତ୍| ");
INSERT INTO sanori_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","ଅଥ ଯୀଶୁ ର୍ଗୃହଂ ପ୍ରୱିଷ୍ଟସ୍ତଦା ଶିଷ୍ୟାଃ ପୁନସ୍ତତ୍କଥାଂ ତଂ ପପ୍ରଚ୍ଛୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ତତଃ ସୋୱଦତ୍ କଶ୍ଚିଦ୍ ଯଦି ସ୍ୱଭାର୍ୟ୍ୟାଂ ତ୍ୟକ୍ତୱାନ୍ୟାମ୍ ଉଦ୍ୱହତି ତର୍ହି ସ ସ୍ୱଭାର୍ୟ୍ୟାଯାଃ ପ୍ରାତିକୂଲ୍ୟେନ ୱ୍ୟଭିଚାରୀ ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","କାଚିନ୍ନାରୀ ଯଦି ସ୍ୱପତିଂ ହିତ୍ୱାନ୍ୟପୁଂସା ୱିୱାହିତା ଭୱତି ତର୍ହି ସାପି ୱ୍ୟଭିଚାରିଣୀ ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","ଅଥ ସ ଯଥା ଶିଶୂନ୍ ସ୍ପୃଶେତ୍, ତଦର୍ଥଂ ଲୋକୈସ୍ତଦନ୍ତିକଂ ଶିଶୱ ଆନୀଯନ୍ତ, କିନ୍ତୁ ଶିଷ୍ୟାସ୍ତାନାନୀତୱତସ୍ତର୍ଜଯାମାସୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ଯୀଶୁସ୍ତଦ୍ ଦୃଷ୍ଟ୍ୱା କ୍ରୁଧ୍ୟନ୍ ଜଗାଦ, ମନ୍ନିକଟମ୍ ଆଗନ୍ତୁଂ ଶିଶୂନ୍ ମା ୱାରଯତ, ଯତ ଏତାଦୃଶା ଈଶ୍ୱରରାଜ୍ୟାଧିକାରିଣଃ| ");
INSERT INTO sanori_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","ଯୁଷ୍ମାନହଂ ଯଥାର୍ଥଂ ୱଚ୍ମି, ଯଃ କଶ୍ଚିତ୍ ଶିଶୁୱଦ୍ ଭୂତ୍ୱା ରାଜ୍ୟମୀଶ୍ୱରସ୍ୟ ନ ଗୃହ୍ଲୀଯାତ୍ ସ କଦାପି ତଦ୍ରାଜ୍ୟଂ ପ୍ରୱେଷ୍ଟୁଂ ନ ଶକ୍ନୋତି| ");
INSERT INTO sanori_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ଅନନତରଂ ସ ଶିଶୂନଙ୍କେ ନିଧାଯ ତେଷାଂ ଗାତ୍ରେଷୁ ହସ୍ତୌ ଦତ୍ତ୍ୱାଶିଷଂ ବଭାଷେ| ");
INSERT INTO sanori_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","ଅଥ ସ ୱର୍ତ୍ମନା ଯାତି, ଏତର୍ହି ଜନ ଏକୋ ଧାୱନ୍ ଆଗତ୍ୟ ତତ୍ସମ୍ମୁଖେ ଜାନୁନୀ ପାତଯିତ୍ୱା ପୃଷ୍ଟୱାନ୍, ଭୋଃ ପରମଗୁରୋ, ଅନନ୍ତାଯୁଃ ପ୍ରାପ୍ତଯେ ମଯା କିଂ କର୍ତ୍ତୱ୍ୟଂ? ");
INSERT INTO sanori_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","ତଦା ଯୀଶୁରୁୱାଚ, ମାଂ ପରମଂ କୁତୋ ୱଦସି? ୱିନେଶ୍ୱରଂ କୋପି ପରମୋ ନ ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","ପରସ୍ତ୍ରୀଂ ନାଭିଗଚ୍ଛ; ନରଂ ମା ଘାତଯ; ସ୍ତେଯଂ ମା କୁରୁ; ମୃଷାସାକ୍ଷ୍ୟଂ ମା ଦେହି; ହିଂସାଞ୍ଚ ମା କୁରୁ; ପିତରୌ ସମ୍ମନ୍ୟସ୍ୱ; ନିଦେଶା ଏତେ ତ୍ୱଯା ଜ୍ଞାତାଃ| ");
INSERT INTO sanori_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ତତସ୍ତନ ପ୍ରତ୍ୟୁକ୍ତଂ, ହେ ଗୁରୋ ବାଲ୍ୟକାଲାଦହଂ ସର୍ୱ୍ୱାନେତାନ୍ ଆଚରାମି| ");
INSERT INTO sanori_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ତଦା ଯୀଶୁସ୍ତଂ ୱିଲୋକ୍ୟ ସ୍ନେହେନ ବଭାଷେ, ତୱୈକସ୍ୟାଭାୱ ଆସ୍ତେ; ତ୍ୱଂ ଗତ୍ୱା ସର୍ୱ୍ୱସ୍ୱଂ ୱିକ୍ରୀଯ ଦରିଦ୍ରେଭ୍ୟୋ ୱିଶ୍ରାଣଯ, ତତଃ ସ୍ୱର୍ଗେ ଧନଂ ପ୍ରାପ୍ସ୍ୟସି; ତତଃ ପରମ୍ ଏତ୍ୟ କ୍ରୁଶଂ ୱହନ୍ ମଦନୁୱର୍ତ୍ତୀ ଭୱ| ");
INSERT INTO sanori_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","କିନ୍ତୁ ତସ୍ୟ ବହୁସମ୍ପଦ୍ୱିଦ୍ୟମାନତ୍ୱାତ୍ ସ ଇମାଂ କଥାମାକର୍ଣ୍ୟ ୱିଷଣୋ ଦୁଃଖିତଶ୍ଚ ସନ୍ ଜଗାମ| ");
INSERT INTO sanori_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","ଅଥ ଯୀଶୁଶ୍ଚତୁର୍ଦିଶୋ ନିରୀକ୍ଷ୍ୟ ଶିଷ୍ୟାନ୍ ଅୱାଦୀତ୍, ଧନିଲୋକାନାମ୍ ଈଶ୍ୱରରାଜ୍ୟପ୍ରୱେଶଃ କୀଦୃଗ୍ ଦୁଷ୍କରଃ| ");
INSERT INTO sanori_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","ତସ୍ୟ କଥାତଃ ଶିଷ୍ୟାଶ୍ଚମଚ୍ଚକ୍ରୁଃ, କିନ୍ତୁ ସ ପୁନରୱଦତ୍, ହେ ବାଲକା ଯେ ଧନେ ୱିଶ୍ୱସନ୍ତି ତେଷାମ୍ ଈଶ୍ୱରରାଜ୍ୟପ୍ରୱେଶଃ କୀଦୃଗ୍ ଦୁଷ୍କରଃ| ");
INSERT INTO sanori_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ଈଶ୍ୱରରାଜ୍ୟେ ଧନିନାଂ ପ୍ରୱେଶାତ୍ ସୂଚିରନ୍ଧ୍ରେଣ ମହାଙ୍ଗସ୍ୟ ଗମନାଗମନଂ ସୁକରଂ| ");
INSERT INTO sanori_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","ତଦା ଶିଷ୍ୟା ଅତୀୱ ୱିସ୍ମିତାଃ ପରସ୍ପରଂ ପ୍ରୋଚୁଃ, ତର୍ହି କଃ ପରିତ୍ରାଣଂ ପ୍ରାପ୍ତୁଂ ଶକ୍ନୋତି? ");
INSERT INTO sanori_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ତତୋ ଯୀଶୁସ୍ତାନ୍ ୱିଲୋକ୍ୟ ବଭାଷେ, ତନ୍ ନରସ୍ୟାସାଧ୍ୟଂ କିନ୍ତୁ ନେଶ୍ୱରସ୍ୟ, ଯତୋ ହେତୋରୀଶ୍ୱରସ୍ୟ ସର୍ୱ୍ୱଂ ସାଧ୍ୟମ୍| ");
INSERT INTO sanori_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ତଦା ପିତର ଉୱାଚ, ପଶ୍ୟ ୱଯଂ ସର୍ୱ୍ୱଂ ପରିତ୍ୟଜ୍ୟ ଭୱତୋନୁଗାମିନୋ ଜାତାଃ| ");
INSERT INTO sanori_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","ତତୋ ଯୀଶୁଃ ପ୍ରତ୍ୟୱଦତ୍, ଯୁଷ୍ମାନହଂ ଯଥାର୍ଥଂ ୱଦାମି, ମଦର୍ଥଂ ସୁସଂୱାଦାର୍ଥଂ ୱା ଯୋ ଜନଃ ସଦନଂ ଭ୍ରାତରଂ ଭଗିନୀଂ ପିତରଂ ମାତରଂ ଜାଯାଂ ସନ୍ତାନାନ୍ ଭୂମି ୱା ତ୍ୟକ୍ତ୍ୱା ");
INSERT INTO sanori_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ଗୃହଭ୍ରାତୃଭଗିନୀପିତୃମାତୃପତ୍ନୀସନ୍ତାନଭୂମୀନାମିହ ଶତଗୁଣାନ୍ ପ୍ରେତ୍ୟାନନ୍ତାଯୁଶ୍ଚ ନ ପ୍ରାପ୍ନୋତି ତାଦୃଶଃ କୋପି ନାସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","କିନ୍ତ୍ୱଗ୍ରୀଯା ଅନେକେ ଲୋକାଃ ଶେଷାଃ, ଶେଷୀଯା ଅନେକେ ଲୋକାଶ୍ଚାଗ୍ରା ଭୱିଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","ଅଥ ଯିରୂଶାଲମ୍ୟାନକାଲେ ଯୀଶୁସ୍ତେଷାମ୍ ଅଗ୍ରଗାମୀ ବଭୂୱ, ତସ୍ମାତ୍ତେ ଚିତ୍ରଂ ଜ୍ଞାତ୍ୱା ପଶ୍ଚାଦ୍ଗାମିନୋ ଭୂତ୍ୱା ବିଭ୍ୟୁଃ| ତଦା ସ ପୁନ ର୍ଦ୍ୱାଦଶଶିଷ୍ୟାନ୍ ଗୃହୀତ୍ୱା ସ୍ୱୀଯଂ ଯଦ୍ୟଦ୍ ଘଟିଷ୍ୟତେ ତତ୍ତତ୍ ତେଭ୍ୟଃ କଥଯିତୁଂ ପ୍ରାରେଭେ; ");
INSERT INTO sanori_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ପଶ୍ୟତ ୱଯଂ ଯିରୂଶାଲମ୍ପୁରଂ ଯାମଃ, ତତ୍ର ମନୁଷ୍ୟପୁତ୍ରଃ ପ୍ରଧାନଯାଜକାନାମ୍ ଉପାଧ୍ୟାଯାନାଞ୍ଚ କରେଷୁ ସମର୍ପଯିଷ୍ୟତେ; ତେ ଚ ୱଧଦଣ୍ଡାଜ୍ଞାଂ ଦାପଯିତ୍ୱା ପରଦେଶୀଯାନାଂ କରେଷୁ ତଂ ସମର୍ପଯିଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ତେ ତମୁପହସ୍ୟ କଶଯା ପ୍ରହୃତ୍ୟ ତଦ୍ୱପୁଷି ନିଷ୍ଠୀୱଂ ନିକ୍ଷିପ୍ୟ ତଂ ହନିଷ୍ୟନ୍ତି, ତତଃ ସ ତୃତୀଯଦିନେ ପ୍ରୋତ୍ଥାସ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ତତଃ ସିୱଦେଃ ପୁତ୍ରୌ ଯାକୂବ୍ୟୋହନୌ ତଦନ୍ତିକମ୍ ଏତ୍ୟ ପ୍ରୋଚତୁଃ, ହେ ଗୁରୋ ଯଦ୍ ଆୱାଭ୍ୟାଂ ଯାଚିଷ୍ୟତେ ତଦସ୍ମଦର୍ଥଂ ଭୱାନ୍ କରୋତୁ ନିୱେଦନମିଦମାୱଯୋଃ| ");
INSERT INTO sanori_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ତତଃ ସ କଥିତୱାନ୍, ଯୁୱାଂ କିମିଚ୍ଛଥଃ? କିଂ ମଯା ଯୁଷ୍ମଦର୍ଥଂ କରଣୀଯଂ? ");
INSERT INTO sanori_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ତଦା ତୌ ପ୍ରୋଚତୁଃ, ଆୱଯୋରେକଂ ଦକ୍ଷିଣପାର୍ଶ୍ୱେ ୱାମପାର୍ଶ୍ୱେ ଚୈକଂ ତୱୈଶ୍ୱର୍ୟ୍ୟପଦେ ସମୁପୱେଷ୍ଟୁମ୍ ଆଜ୍ଞାପଯ| ");
INSERT INTO sanori_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","କିନ୍ତୁ ଯୀଶୁଃ ପ୍ରତ୍ୟୁୱାଚ ଯୁୱାମଜ୍ଞାତ୍ୱେଦଂ ପ୍ରାର୍ଥଯେଥେ, ଯେନ କଂସେନାହଂ ପାସ୍ୟାମି ତେନ ଯୁୱାଭ୍ୟାଂ କିଂ ପାତୁଂ ଶକ୍ଷ୍ୟତେ? ଯସ୍ମିନ୍ ମଜ୍ଜନେନାହଂ ମଜ୍ଜିଷ୍ୟେ ତନ୍ମଜ୍ଜନେ ମଜ୍ଜଯିତୁଂ କିଂ ଯୁୱାଭ୍ୟାଂ ଶକ୍ଷ୍ୟତେ? ତୌ ପ୍ରତ୍ୟୂଚତୁଃ ଶକ୍ଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","ତଦା ଯୀଶୁରୱଦତ୍ ଯେନ କଂସେନାହଂ ପାସ୍ୟାମି ତେନାୱଶ୍ୟଂ ଯୁୱାମପି ପାସ୍ୟଥଃ, ଯେନ ମଜ୍ଜନେନ ଚାହଂ ମଜ୍ଜିଯ୍ୟେ ତତ୍ର ଯୁୱାମପି ମଜ୍ଜିଷ୍ୟେଥେ| ");
INSERT INTO sanori_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","କିନ୍ତୁ ଯେଷାମର୍ଥମ୍ ଇଦଂ ନିରୂପିତଂ, ତାନ୍ ୱିହାଯାନ୍ୟଂ କମପି ମମ ଦକ୍ଷିଣପାର୍ଶ୍ୱେ ୱାମପାର୍ଶ୍ୱେ ୱା ସମୁପୱେଶଯିତୁଂ ମମାଧିକାରୋ ନାସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ଅଥାନ୍ୟଦଶଶିଷ୍ୟା ଇମାଂ କଥାଂ ଶ୍ରୁତ୍ୱା ଯାକୂବ୍ୟୋହନ୍ଭ୍ୟାଂ ଚୁକୁପୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","କିନ୍ତୁ ଯୀଶୁସ୍ତାନ୍ ସମାହୂଯ ବଭାଷେ, ଅନ୍ୟଦେଶୀଯାନାଂ ରାଜତ୍ୱଂ ଯେ କୁର୍ୱ୍ୱନ୍ତି ତେ ତେଷାମେୱ ପ୍ରଭୁତ୍ୱଂ କୁର୍ୱ୍ୱନ୍ତି, ତଥା ଯେ ମହାଲୋକାସ୍ତେ ତେଷାମ୍ ଅଧିପତିତ୍ୱଂ କୁର୍ୱ୍ୱନ୍ତୀତି ଯୂଯଂ ଜାନୀଥ| ");
INSERT INTO sanori_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","କିନ୍ତୁ ଯୁଷ୍ମାକଂ ମଧ୍ୟେ ନ ତଥା ଭୱିଷ୍ୟତି, ଯୁଷ୍ମାକଂ ମଧ୍ୟେ ଯଃ ପ୍ରାଧାନ୍ୟଂ ୱାଞ୍ଛତି ସ ଯୁଷ୍ମାକଂ ସେୱକୋ ଭୱିଷ୍ୟତି, ");
INSERT INTO sanori_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ଯୁଷ୍ମାକଂ ଯୋ ମହାନ୍ ଭୱିତୁମିଚ୍ଛତି ସ ସର୍ୱ୍ୱେଷାଂ କିଙ୍କରୋ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","ଯତୋ ମନୁଷ୍ୟପୁତ୍ରଃ ସେୱ୍ୟୋ ଭୱିତୁଂ ନାଗତଃ ସେୱାଂ କର୍ତ୍ତାଂ ତଥାନେକେଷାଂ ପରିତ୍ରାଣସ୍ୟ ମୂଲ୍ୟରୂପସ୍ୱପ୍ରାଣଂ ଦାତୁଞ୍ଚାଗତଃ| ");
INSERT INTO sanori_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ଅଥ ତେ ଯିରୀହୋନଗରଂ ପ୍ରାପ୍ତାସ୍ତସ୍ମାତ୍ ଶିଷ୍ୟୈ ର୍ଲୋକୈଶ୍ଚ ସହ ଯୀଶୋ ର୍ଗମନକାଲେ ଟୀମଯସ୍ୟ ପୁତ୍ରୋ ବର୍ଟୀମଯନାମା ଅନ୍ଧସ୍ତନ୍ମାର୍ଗପାର୍ଶ୍ୱେ ଭିକ୍ଷାର୍ଥମ୍ ଉପୱିଷ୍ଟଃ| ");
INSERT INTO sanori_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ସ ନାସରତୀଯସ୍ୟ ଯୀଶୋରାଗମନୱାର୍ତ୍ତାଂ ପ୍ରାପ୍ୟ ପ୍ରୋଚୈ ର୍ୱକ୍ତୁମାରେଭେ, ହେ ଯୀଶୋ ଦାଯୂଦଃ ସନ୍ତାନ ମାଂ ଦଯସ୍ୱ| ");
INSERT INTO sanori_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ତତୋନେକେ ଲୋକା ମୌନୀଭୱେତି ତଂ ତର୍ଜଯାମାସୁଃ, କିନ୍ତୁ ସ ପୁନରଧିକମୁଚ୍ଚୈ ର୍ଜଗାଦ, ହେ ଯୀଶୋ ଦାଯୂଦଃ ସନ୍ତାନ ମାଂ ଦଯସ୍ୱ| ");
INSERT INTO sanori_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","ତଦା ଯୀଶୁଃ ସ୍ଥିତ୍ୱା ତମାହ୍ୱାତୁଂ ସମାଦିଦେଶ, ତତୋ ଲୋକାସ୍ତମନ୍ଧମାହୂଯ ବଭାଷିରେ, ହେ ନର, ସ୍ଥିରୋ ଭୱ, ଉତ୍ତିଷ୍ଠ, ସ ତ୍ୱାମାହ୍ୱଯତି| ");
INSERT INTO sanori_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ତଦା ସ ଉତ୍ତରୀଯୱସ୍ତ୍ରଂ ନିକ୍ଷିପ୍ୟ ପ୍ରୋତ୍ଥାଯ ଯୀଶୋଃ ସମୀପଂ ଗତଃ| ");
INSERT INTO sanori_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ତତୋ ଯୀଶୁସ୍ତମୱଦତ୍ ତ୍ୱଯା କିଂ ପ୍ରାର୍ଥ୍ୟତେ? ତୁଭ୍ୟମହଂ କିଂ କରିଷ୍ୟାମୀ? ତଦା ସୋନ୍ଧସ୍ତମୁୱାଚ, ହେ ଗୁରୋ ମଦୀଯା ଦୃଷ୍ଟିର୍ଭୱେତ୍| ");
INSERT INTO sanori_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ତତୋ ଯୀଶୁସ୍ତମୁୱାଚ ଯାହି ତୱ ୱିଶ୍ୱାସସ୍ତ୍ୱାଂ ସ୍ୱସ୍ଥମକାର୍ଷୀତ୍, ତସ୍ମାତ୍ ତତ୍କ୍ଷଣଂ ସ ଦୃଷ୍ଟିଂ ପ୍ରାପ୍ୟ ପଥା ଯୀଶୋଃ ପଶ୍ଚାଦ୍ ଯଯୌ| ");
INSERT INTO sanori_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ଅନନ୍ତରଂ ତେଷୁ ଯିରୂଶାଲମଃ ସମୀପସ୍ଥଯୋ ର୍ବୈତ୍ଫଗୀବୈଥନୀଯପୁରଯୋରନ୍ତିକସ୍ଥଂ ଜୈତୁନନାମାଦ୍ରିମାଗତେଷୁ ଯୀଶୁଃ ପ୍ରେଷଣକାଲେ ଦ୍ୱୌ ଶିଷ୍ୟାୱିଦଂ ୱାକ୍ୟଂ ଜଗାଦ, ");
INSERT INTO sanori_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ଯୁୱାମମୁଂ ସମ୍ମୁଖସ୍ଥଂ ଗ୍ରାମଂ ଯାତଂ, ତତ୍ର ପ୍ରୱିଶ୍ୟ ଯୋ ନରଂ ନାୱହତ୍ ତଂ ଗର୍ଦ୍ଦଭଶାୱକଂ ଦ୍ରକ୍ଷ୍ୟଥସ୍ତଂ ମୋଚଯିତ୍ୱାନଯତଂ| ");
INSERT INTO sanori_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","କିନ୍ତୁ ଯୁୱାଂ କର୍ମ୍ମେଦଂ କୁତଃ କୁରୁଥଃ? କଥାମିମାଂ ଯଦି କୋପି ପୃଚ୍ଛତି ତର୍ହି ପ୍ରଭୋରତ୍ର ପ୍ରଯୋଜନମସ୍ତୀତି କଥିତେ ସ ଶୀଘ୍ରଂ ତମତ୍ର ପ୍ରେଷଯିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ତତସ୍ତୌ ଗତ୍ୱା ଦ୍ୱିମାର୍ଗମେଲନେ କସ୍ୟଚିଦ୍ ଦ୍ୱାରସ୍ୟ ପାର୍ଶ୍ୱେ ତଂ ଗର୍ଦ୍ଦଭଶାୱକଂ ପ୍ରାପ୍ୟ ମୋଚଯତଃ, ");
INSERT INTO sanori_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ଏତର୍ହି ତତ୍ରୋପସ୍ଥିତଲୋକାନାଂ କଶ୍ଚିଦ୍ ଅପୃଚ୍ଛତ୍, ଗର୍ଦ୍ଦଭଶିଶୁଂ କୁତୋ ମୋଚଯଥଃ? ");
INSERT INTO sanori_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ତଦା ଯୀଶୋରାଜ୍ଞାନୁସାରେଣ ତେଭ୍ୟଃ ପ୍ରତ୍ୟୁଦିତେ ତତ୍କ୍ଷଣଂ ତମାଦାତୁଂ ତେଽନୁଜଜ୍ଞୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ଅଥ ତୌ ଯୀଶୋଃ ସନ୍ନିଧିଂ ଗର୍ଦ୍ଦଭଶିଶୁମ୍ ଆନୀଯ ତଦୁପରି ସ୍ୱୱସ୍ତ୍ରାଣି ପାତଯାମାସତୁଃ; ତତଃ ସ ତଦୁପରି ସମୁପୱିଷ୍ଟଃ| ");
INSERT INTO sanori_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ତଦାନେକେ ପଥି ସ୍ୱୱାସାଂସି ପାତଯାମାସୁଃ, ପରୈଶ୍ଚ ତରୁଶାଖାଶ୍ଛିତୱା ମାର୍ଗେ ୱିକୀର୍ଣାଃ| ");
INSERT INTO sanori_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","ଅପରଞ୍ଚ ପଶ୍ଚାଦ୍ଗାମିନୋଽଗ୍ରଗାମିନଶ୍ଚ ସର୍ୱ୍ୱେ ଜନା ଉଚୈଃସ୍ୱରେଣ ୱକ୍ତୁମାରେଭିରେ, ଜଯ ଜଯ ଯଃ ପରମେଶ୍ୱରସ୍ୟ ନାମ୍ନାଗଚ୍ଛତି ସ ଧନ୍ୟ ଇତି| ");
INSERT INTO sanori_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","ତଥାସ୍ମାକମଂ ପୂର୍ୱ୍ୱପୁରୁଷସ୍ୟ ଦାଯୂଦୋ ଯଦ୍ରାଜ୍ୟଂ ପରମେଶ୍ୱରନାମ୍ନାଯାତି ତଦପି ଧନ୍ୟଂ, ସର୍ୱ୍ୱସ୍ମାଦୁଚ୍ଛ୍ରାଯେ ସ୍ୱର୍ଗେ ଈଶ୍ୱରସ୍ୟ ଜଯୋ ଭୱେତ୍| ");
INSERT INTO sanori_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ଇତ୍ଥଂ ଯୀଶୁ ର୍ୟିରୂଶାଲମି ମନ୍ଦିରଂ ପ୍ରୱିଶ୍ୟ ଚତୁର୍ଦିକ୍ସ୍ଥାନି ସର୍ୱ୍ୱାଣି ୱସ୍ତୂନି ଦୃଷ୍ଟୱାନ୍; ଅଥ ସାଯଂକାଲ ଉପସ୍ଥିତେ ଦ୍ୱାଦଶଶିଷ୍ୟସହିତୋ ବୈଥନିଯଂ ଜଗାମ| ");
INSERT INTO sanori_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","ଅପରେହନି ବୈଥନିଯାଦ୍ ଆଗମନସମଯେ କ୍ଷୁଧାର୍ତ୍ତୋ ବଭୂୱ| ");
INSERT INTO sanori_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ତତୋ ଦୂରେ ସପତ୍ରମୁଡୁମ୍ବରପାଦପଂ ୱିଲୋକ୍ୟ ତତ୍ର କିଞ୍ଚିତ୍ ଫଲଂ ପ୍ରାପ୍ତୁଂ ତସ୍ୟ ସନ୍ନିକୃଷ୍ଟଂ ଯଯୌ, ତଦାନୀଂ ଫଲପାତନସ୍ୟ ସମଯୋ ନାଗଚ୍ଛତି| ତତସ୍ତତ୍ରୋପସ୍ଥିତଃ ପତ୍ରାଣି ୱିନା କିମପ୍ୟପରଂ ନ ପ୍ରାପ୍ୟ ସ କଥିତୱାନ୍, ");
INSERT INTO sanori_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ଅଦ୍ୟାରଭ୍ୟ କୋପି ମାନୱସ୍ତ୍ୱତ୍ତଃ ଫଲଂ ନ ଭୁଞ୍ଜୀତ; ଇମାଂ କଥାଂ ତସ୍ୟ ଶିଷ୍ୟାଃ ଶୁଶ୍ରୁୱୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","ତଦନନ୍ତରଂ ତେଷୁ ଯିରୂଶାଲମମାଯାତେଷୁ ଯୀଶୁ ର୍ମନ୍ଦିରଂ ଗତ୍ୱା ତତ୍ରସ୍ଥାନାଂ ବଣିଜାଂ ମୁଦ୍ରାସନାନି ପାରାୱତୱିକ୍ରେତୃଣାମ୍ ଆସନାନି ଚ ନ୍ୟୁବ୍ଜଯାଞ୍ଚକାର ସର୍ୱ୍ୱାନ୍ କ୍ରେତୃନ୍ ୱିକ୍ରେତୃଂଶ୍ଚ ବହିଶ୍ଚକାର| ");
INSERT INTO sanori_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ଅପରଂ ମନ୍ଦିରମଧ୍ୟେନ କିମପି ପାତ୍ରଂ ୱୋଢୁଂ ସର୍ୱ୍ୱଜନଂ ନିୱାରଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ଲୋକାନୁପଦିଶନ୍ ଜଗାଦ, ମମ ଗୃହଂ ସର୍ୱ୍ୱଜାତୀଯାନାଂ ପ୍ରାର୍ଥନାଗୃହମ୍ ଇତି ନାମ୍ନା ପ୍ରଥିତଂ ଭୱିଷ୍ୟତି ଏତତ୍ କିଂ ଶାସ୍ତ୍ରେ ଲିଖିତଂ ନାସ୍ତି? କିନ୍ତୁ ଯୂଯଂ ତଦେୱ ଚୋରାଣାଂ ଗହ୍ୱରଂ କୁରୁଥ| ");
INSERT INTO sanori_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ଇମାଂ ୱାଣୀଂ ଶ୍ରୁତ୍ୱାଧ୍ୟାପକାଃ ପ୍ରଧାନଯାଜକାଶ୍ଚ ତଂ ଯଥା ନାଶଯିତୁଂ ଶକ୍ନୁୱନ୍ତି ତଥୋेପାଯଂ ମୃଗଯାମାସୁଃ, କିନ୍ତୁ ତସ୍ୟୋପଦେଶାତ୍ ସର୍ୱ୍ୱେ ଲୋକା ୱିସ୍ମଯଂ ଗତା ଅତସ୍ତେ ତସ୍ମାଦ୍ ବିଭ୍ୟୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ଅଥ ସାଯଂସମଯ ଉପସ୍ଥିତେ ଯୀଶୁର୍ନଗରାଦ୍ ବହିର୍ୱୱ୍ରାଜ| ");
INSERT INTO sanori_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","ଅନନ୍ତରଂ ପ୍ରାତଃକାଲେ ତେ ତେନ ମାର୍ଗେଣ ଗଚ୍ଛନ୍ତସ୍ତମୁଡୁମ୍ବରମହୀରୁହଂ ସମୂଲଂ ଶୁଷ୍କଂ ଦଦୃଶୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ତତଃ ପିତରଃ ପୂର୍ୱ୍ୱୱାକ୍ୟଂ ସ୍ମରନ୍ ଯୀଶୁଂ ବଭାଷଂ, ହେ ଗୁରୋ ପଶ୍ୟତୁ ଯ ଉଡୁମ୍ବରୱିଟପୀ ଭୱତା ଶପ୍ତଃ ସ ଶୁଷ୍କୋ ବଭୂୱ| ");
INSERT INTO sanori_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ତତୋ ଯୀଶୁଃ ପ୍ରତ୍ୟୱାଦୀତ୍, ଯୂଯମୀଶ୍ୱରେ ୱିଶ୍ୱସିତ| ");
INSERT INTO sanori_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ଯୁଷ୍ମାନହଂ ଯଥାର୍ଥଂ ୱଦାମି କୋପି ଯଦ୍ୟେତଦ୍ଗିରିଂ ୱଦତି, ତ୍ୱମୁତ୍ଥାଯ ଗତ୍ୱା ଜଲଧୌ ପତ, ପ୍ରୋକ୍ତମିଦଂ ୱାକ୍ୟମୱଶ୍ୟଂ ଘଟିଷ୍ୟତେ, ମନସା କିମପି ନ ସନ୍ଦିହ୍ୟ ଚେଦିଦଂ ୱିଶ୍ୱସେତ୍ ତର୍ହି ତସ୍ୟ ୱାକ୍ୟାନୁସାରେଣ ତଦ୍ ଘଟିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ଅତୋ ହେତୋରହଂ ଯୁଷ୍ମାନ୍ ୱଚ୍ମି, ପ୍ରାର୍ଥନାକାଲେ ଯଦ୍ୟଦାକାଂକ୍ଷିଷ୍ୟଧ୍ୱେ ତତ୍ତଦୱଶ୍ୟଂ ପ୍ରାପ୍ସ୍ୟଥ, ଇତ୍ଥଂ ୱିଶ୍ୱସିତ, ତତଃ ପ୍ରାପ୍ସ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","ଅପରଞ୍ଚ ଯୁଷ୍ମାସୁ ପ୍ରାର୍ଥଯିତୁଂ ସମୁତ୍ଥିତେଷୁ ଯଦି କୋପି ଯୁଷ୍ମାକମ୍ ଅପରାଧୀ ତିଷ୍ଠତି, ତର୍ହି ତଂ କ୍ଷମଧ୍ୱଂ, ତଥା କୃତେ ଯୁଷ୍ମାକଂ ସ୍ୱର୍ଗସ୍ଥଃ ପିତାପି ଯୁଷ୍ମାକମାଗାଂମି କ୍ଷମିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","କିନ୍ତୁ ଯଦି ନ କ୍ଷମଧ୍ୱେ ତର୍ହି ୱଃ ସ୍ୱର୍ଗସ୍ଥଃ ପିତାପି ଯୁଷ୍ମାକମାଗାଂସି ନ କ୍ଷମିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ଅନନ୍ତରଂ ତେ ପୁନ ର୍ୟିରୂଶାଲମଂ ପ୍ରୱିୱିଶୁଃ, ଯୀଶୁ ର୍ୟଦା ମଧ୍ୟେମନ୍ଦିରମ୍ ଇତସ୍ତତୋ ଗଚ୍ଛତି, ତଦାନୀଂ ପ୍ରଧାନଯାଜକା ଉପାଧ୍ୟାଯାଃ ପ୍ରାଞ୍ଚଶ୍ଚ ତଦନ୍ତିକମେତ୍ୟ କଥାମିମାଂ ପପ୍ରଚ୍ଛୁଃ, ");
INSERT INTO sanori_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ତ୍ୱଂ କେନାଦେଶେନ କର୍ମ୍ମାଣ୍ୟେତାନି କରୋଷି? ତଥୈତାନି କର୍ମ୍ମାଣି କର୍ତ୍ତାଂ କେନାଦିଷ୍ଟୋସି? ");
INSERT INTO sanori_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ତତୋ ଯୀଶୁଃ ପ୍ରତିଗଦିତୱାନ୍ ଅହମପି ଯୁଷ୍ମାନ୍ ଏକକଥାଂ ପୃଚ୍ଛାମି, ଯଦି ଯୂଯଂ ତସ୍ୟା ଉତ୍ତରଂ କୁରୁଥ, ତର୍ହି କଯାଜ୍ଞଯାହଂ କର୍ମ୍ମାଣ୍ୟେତାନି କରୋମି ତଦ୍ ଯୁଷ୍ମଭ୍ୟଂ କଥଯିଷ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ଯୋହନୋ ମଜ୍ଜନମ୍ ଈଶ୍ୱରାତ୍ ଜାତଂ କିଂ ମାନୱାତ୍? ତନ୍ମହ୍ୟଂ କଥଯତ| ");
INSERT INTO sanori_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","ତେ ପରସ୍ପରଂ ୱିୱେକ୍ତୁଂ ପ୍ରାରେଭିରେ, ତଦ୍ ଈଶ୍ୱରାଦ୍ ବଭୂୱେତି ଚେଦ୍ ୱଦାମସ୍ତର୍ହି କୁତସ୍ତଂ ନ ପ୍ରତ୍ୟୈତ? କଥମେତାଂ କଥଯିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","ମାନୱାଦ୍ ଅଭୱଦିତି ଚେଦ୍ ୱଦାମସ୍ତର୍ହି ଲୋକେଭ୍ୟୋ ଭଯମସ୍ତି ଯତୋ ହେତୋଃ ସର୍ୱ୍ୱେ ଯୋହନଂ ସତ୍ୟଂ ଭୱିଷ୍ୟଦ୍ୱାଦିନଂ ମନ୍ୟନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ଅତଏୱ ତେ ଯୀଶୁଂ ପ୍ରତ୍ୟୱାଦିଷୁ ର୍ୱଯଂ ତଦ୍ ୱକ୍ତୁଂ ନ ଶକ୍ନୁମଃ| ଯୀଶୁରୁୱାଚ, ତର୍ହି ଯେନାଦେଶେନ କର୍ମ୍ମାଣ୍ୟେତାନି କରୋମି, ଅହମପି ଯୁଷ୍ମଭ୍ୟଂ ତନ୍ନ କଥଯିଷ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","ଅନନ୍ତରଂ ଯୀଶୁ ର୍ଦୃଷ୍ଟାନ୍ତେନ ତେଭ୍ୟଃ କଥଯିତୁମାରେଭେ, କଶ୍ଚିଦେକୋ ଦ୍ରାକ୍ଷାକ୍ଷେତ୍ରଂ ୱିଧାଯ ତଚ୍ଚତୁର୍ଦିକ୍ଷୁ ୱାରଣୀଂ କୃତ୍ୱା ତନ୍ମଧ୍ୟେ ଦ୍ରାକ୍ଷାପେଷଣକୁଣ୍ଡମ୍ ଅଖନତ୍, ତଥା ତସ୍ୟ ଗଡମପି ନିର୍ମ୍ମିତୱାନ୍ ତତସ୍ତତ୍କ୍ଷେତ୍ରଂ କୃଷୀୱଲେଷୁ ସମର୍ପ୍ୟ ଦୂରଦେଶଂ ଜଗାମ| ");
INSERT INTO sanori_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","ତଦନନ୍ତରଂ ଫଲକାଲେ କୃଷୀୱଲେଭ୍ୟୋ ଦ୍ରାକ୍ଷାକ୍ଷେତ୍ରଫଲାନି ପ୍ରାପ୍ତୁଂ ତେଷାଂ ସୱିଧେ ଭୃତ୍ୟମ୍ ଏକଂ ପ୍ରାହିଣୋତ୍| ");
INSERT INTO sanori_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","କିନ୍ତୁ କୃଷୀୱଲାସ୍ତଂ ଧୃତ୍ୱା ପ୍ରହୃତ୍ୟ ରିକ୍ତହସ୍ତଂ ୱିସସୃଜୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ତତଃ ସ ପୁନରନ୍ୟମେକଂ ଭୃତ୍ୟଂ ପ୍ରଷଯାମାସ, କିନ୍ତୁ ତେ କୃଷୀୱଲାଃ ପାଷାଣାଘାତୈସ୍ତସ୍ୟ ଶିରୋ ଭଙ୍କ୍ତ୍ୱା ସାପମାନଂ ତଂ ୱ୍ୟସର୍ଜନ୍| ");
INSERT INTO sanori_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ତତଃ ପରଂ ସୋପରଂ ଦାସଂ ପ୍ରାହିଣୋତ୍ ତଦା ତେ ତଂ ଜଘ୍ନୁଃ, ଏୱମ୍ ଅନେକେଷାଂ କସ୍ୟଚିତ୍ ପ୍ରହାରଃ କସ୍ୟଚିଦ୍ ୱଧଶ୍ଚ ତୈଃ କୃତଃ| ");
INSERT INTO sanori_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ତତଃ ପରଂ ମଯା ସ୍ୱପୁତ୍ରେ ପ୍ରହିତେ ତେ ତମୱଶ୍ୟଂ ସମ୍ମଂସ୍ୟନ୍ତେ, ଇତ୍ୟୁକ୍ତ୍ୱାୱଶେଷେ ତେଷାଂ ସନ୍ନିଧୌ ନିଜପ୍ରିଯମ୍ ଅଦ୍ୱିତୀଯଂ ପୁତ୍ରଂ ପ୍ରେଷଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","କିନ୍ତୁ କୃଷୀୱଲାଃ ପରସ୍ପରଂ ଜଗଦୁଃ, ଏଷ ଉତ୍ତରାଧିକାରୀ, ଆଗଚ୍ଛତ ୱଯମେନଂ ହନ୍ମସ୍ତଥା କୃତେ ଽଧିକାରୋଯମ୍ ଅସ୍ମାକଂ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ତତସ୍ତଂ ଧୃତ୍ୱା ହତ୍ୱା ଦ୍ରାକ୍ଷାକ୍ଷେତ୍ରାଦ୍ ବହିଃ ପ୍ରାକ୍ଷିପନ୍| ");
INSERT INTO sanori_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","ଅନେନାସୌ ଦ୍ରାକ୍ଷାକ୍ଷେତ୍ରପତିଃ କିଂ କରିଷ୍ୟତି? ସ ଏତ୍ୟ ତାନ୍ କୃଷୀୱଲାନ୍ ସଂହତ୍ୟ ତତ୍କ୍ଷେତ୍ରମ୍ ଅନ୍ୟେଷୁ କୃଷୀୱଲେଷୁ ସମର୍ପଯିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","ଅପରଞ୍ଚ, \"ସ୍ଥପତଯଃ କରିଷ୍ୟନ୍ତି ଗ୍ରାୱାଣଂ ଯନ୍ତୁ ତୁଚ୍ଛକଂ| ପ୍ରାଧାନପ୍ରସ୍ତରଃ କୋଣେ ସ ଏୱ ସଂଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ଏତତ୍ କର୍ମ୍ମ ପରେଶସ୍ୟାଂଦ୍ଭୁତଂ ନୋ ଦୃଷ୍ଟିତୋ ଭୱେତ୍|| \" ଇମାଂ ଶାସ୍ତ୍ରୀଯାଂ ଲିପିଂ ଯୂଯଂ କିଂ ନାପାଠିଷ୍ଟ? ");
INSERT INTO sanori_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ତଦାନୀଂ ସ ତାନୁଦ୍ଦିଶ୍ୟ ତାଂ ଦୃଷ୍ଟାନ୍ତକଥାଂ କଥିତୱାନ୍, ତ ଇତ୍ଥଂ ବୁଦ୍ୱ୍ୱା ତଂ ଧର୍ତ୍ତାମୁଦ୍ୟତାଃ, କିନ୍ତୁ ଲୋକେଭ୍ୟୋ ବିଭ୍ୟୁଃ, ତଦନନ୍ତରଂ ତେ ତଂ ୱିହାଯ ୱୱ୍ରଜୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ଅପରଞ୍ଚ ତେ ତସ୍ୟ ୱାକ୍ୟଦୋଷଂ ଧର୍ତ୍ତାଂ କତିପଯାନ୍ ଫିରୂଶିନୋ ହେରୋଦୀଯାଂଶ୍ଚ ଲୋକାନ୍ ତଦନ୍ତିକଂ ପ୍ରେଷଯାମାସୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ତ ଆଗତ୍ୟ ତମୱଦନ୍, ହେ ଗୁରୋ ଭୱାନ୍ ତଥ୍ୟଭାଷୀ କସ୍ୟାପ୍ୟନୁରୋଧଂ ନ ମନ୍ୟତେ, ପକ୍ଷପାତଞ୍ଚ ନ କରୋତି, ଯଥାର୍ଥତ ଈଶ୍ୱରୀଯଂ ମାର୍ଗଂ ଦର୍ଶଯତି ୱଯମେତତ୍ ପ୍ରଜାନୀମଃ, କୈସରାଯ କରୋ ଦେଯୋ ନ ୱାଂ? ୱଯଂ ଦାସ୍ୟାମୋ ନ ୱା? ");
INSERT INTO sanori_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","କିନ୍ତୁ ସ ତେଷାଂ କପଟଂ ଜ୍ଞାତ୍ୱା ଜଗାଦ, କୁତୋ ମାଂ ପରୀକ୍ଷଧ୍ୱେ? ଏକଂ ମୁଦ୍ରାପାଦଂ ସମାନୀଯ ମାଂ ଦର୍ଶଯତ| ");
INSERT INTO sanori_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ତଦା ତୈରେକସ୍ମିନ୍ ମୁଦ୍ରାପାଦେ ସମାନୀତେ ସ ତାନ୍ ପପ୍ରଚ୍ଛ, ଅତ୍ର ଲିଖିତଂ ନାମ ମୂର୍ତ୍ତି ର୍ୱା କସ୍ୟ? ତେ ପ୍ରତ୍ୟୂଚୁଃ, କୈସରସ୍ୟ| ");
INSERT INTO sanori_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","ତଦା ଯୀଶୁରୱଦତ୍ ତର୍ହି କୈସରସ୍ୟ ଦ୍ରୱ୍ୟାଣି କୈସରାଯ ଦତ୍ତ, ଈଶ୍ୱରସ୍ୟ ଦ୍ରୱ୍ୟାଣି ତୁ ଈଶ୍ୱରାଯ ଦତ୍ତ; ତତସ୍ତେ ୱିସ୍ମଯଂ ମେନିରେ| ");
INSERT INTO sanori_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","ଅଥ ମୃତାନାମୁତ୍ଥାନଂ ଯେ ନ ମନ୍ୟନ୍ତେ ତେ ସିଦୂକିନୋ ଯୀଶୋଃ ସମୀପମାଗତ୍ୟ ତଂ ପପ୍ରଚ୍ଛୁଃ; ");
INSERT INTO sanori_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","ହେ ଗୁରୋ କଶ୍ଚିଜ୍ଜନୋ ଯଦି ନିଃସନ୍ତତିଃ ସନ୍ ଭାର୍ୟ୍ୟାଯାଂ ସତ୍ୟାଂ ମ୍ରିଯତେ ତର୍ହି ତସ୍ୟ ଭ୍ରାତା ତସ୍ୟ ଭାର୍ୟ୍ୟାଂ ଗୃହୀତ୍ୱା ଭ୍ରାତୁ ର୍ୱଂଶୋତ୍ପତ୍ତିଂ କରିଷ୍ୟତି, ୱ୍ୟୱସ୍ଥାମିମାଂ ମୂସା ଅସ୍ମାନ୍ ପ୍ରତି ୱ୍ୟଲିଖତ୍| ");
INSERT INTO sanori_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","କିନ୍ତୁ କେଚିତ୍ ସପ୍ତ ଭ୍ରାତର ଆସନ୍, ତତସ୍ତେଷାଂ ଜ୍ୟେଷ୍ଠଭ୍ରାତା ୱିୱହ୍ୟ ନିଃସନ୍ତତିଃ ସନ୍ ଅମ୍ରିଯତ| ");
INSERT INTO sanori_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ତତୋ ଦ୍ୱିତୀଯୋ ଭ୍ରାତା ତାଂ ସ୍ତ୍ରିଯମଗୃହଣତ୍ କିନ୍ତୁ ସୋପି ନିଃସନ୍ତତିଃ ସନ୍ ଅମ୍ରିଯତ; ଅଥ ତୃତୀଯୋପି ଭ୍ରାତା ତାଦୃଶୋଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ଇତ୍ଥଂ ସପ୍ତୈୱ ଭ୍ରାତରସ୍ତାଂ ସ୍ତ୍ରିଯଂ ଗୃହୀତ୍ୱା ନିଃସନ୍ତାନାଃ ସନ୍ତୋଽମ୍ରିଯନ୍ତ, ସର୍ୱ୍ୱଶେଷେ ସାପି ସ୍ତ୍ରୀ ମ୍ରିଯତେ ସ୍ମ| ");
INSERT INTO sanori_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ଅଥ ମୃତାନାମୁତ୍ଥାନକାଲେ ଯଦା ତ ଉତ୍ଥାସ୍ୟନ୍ତି ତଦା ତେଷାଂ କସ୍ୟ ଭାର୍ୟ୍ୟା ସା ଭୱିଷ୍ୟତି? ଯତସ୍ତେ ସପ୍ତୈୱ ତାଂ ୱ୍ୟୱହନ୍| ");
INSERT INTO sanori_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ତତୋ ଯୀଶୁଃ ପ୍ରତ୍ୟୁୱାଚ ଶାସ୍ତ୍ରମ୍ ଈଶ୍ୱରଶକ୍ତିଞ୍ଚ ଯୂଯମଜ୍ଞାତ୍ୱା କିମଭ୍ରାମ୍ୟତ ନ? ");
INSERT INTO sanori_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","ମୃତଲୋକାନାମୁତ୍ଥାନଂ ସତି ତେ ନ ୱିୱହନ୍ତି ୱାଗ୍ଦତ୍ତା ଅପି ନ ଭୱନ୍ତି, କିନ୍ତୁ ସ୍ୱର୍ଗୀଯଦୂତାନାଂ ସଦୃଶା ଭୱନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","ପୁନଶ୍ଚ \"ଅହମ୍ ଇବ୍ରାହୀମ ଈଶ୍ୱର ଇସ୍ହାକ ଈଶ୍ୱରୋ ଯାକୂବଶ୍ଚେଶ୍ୱରଃ\" ଯାମିମାଂ କଥାଂ ସ୍ତମ୍ବମଧ୍ୟେ ତିଷ୍ଠନ୍ ଈଶ୍ୱରୋ ମୂସାମୱାଦୀତ୍ ମୃତାନାମୁତ୍ଥାନାର୍ଥେ ସା କଥା ମୂସାଲିଖିତେ ପୁସ୍ତକେ କିଂ ଯୁଷ୍ମାଭି ର୍ନାପାଠି? ");
INSERT INTO sanori_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ଈଶ୍ୱରୋ ଜୀୱତାଂ ପ୍ରଭୁଃ କିନ୍ତୁ ମୃତାନାଂ ପ୍ରଭୁ ର୍ନ ଭୱତି, ତସ୍ମାଦ୍ଧେତୋ ର୍ୟୂଯଂ ମହାଭ୍ରମେଣ ତିଷ୍ଠଥ| ");
INSERT INTO sanori_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ଏତର୍ହି ଏକୋଧ୍ୟାପକ ଏତ୍ୟ ତେଷାମିତ୍ଥଂ ୱିଚାରଂ ଶୁଶ୍ରାୱ; ଯୀଶୁସ୍ତେଷାଂ ୱାକ୍ୟସ୍ୟ ସଦୁତ୍ତରଂ ଦତ୍ତୱାନ୍ ଇତି ବୁଦ୍ୱ୍ୱା ତଂ ପୃଷ୍ଟୱାନ୍ ସର୍ୱ୍ୱାସାମ୍ ଆଜ୍ଞାନାଂ କା ଶ୍ରେଷ୍ଠା? ତତୋ ଯୀଶୁଃ ପ୍ରତ୍ୟୁୱାଚ, ");
INSERT INTO sanori_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","\"ହେ ଇସ୍ରାଯେଲ୍ଲୋକା ଅୱଧତ୍ତ, ଅସ୍ମାକଂ ପ୍ରଭୁଃ ପରମେଶ୍ୱର ଏକ ଏୱ, ");
INSERT INTO sanori_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ଯୂଯଂ ସର୍ୱ୍ୱନ୍ତଃକରଣୈଃ ସର୍ୱ୍ୱପ୍ରାଣୈଃ ସର୍ୱ୍ୱଚିତ୍ତୈଃ ସର୍ୱ୍ୱଶକ୍ତିଭିଶ୍ଚ ତସ୍ମିନ୍ ପ୍ରଭୌ ପରମେଶ୍ୱରେ ପ୍ରୀଯଧ୍ୱଂ,\" ଇତ୍ୟାଜ୍ଞା ଶ୍ରେଷ୍ଠା| ");
INSERT INTO sanori_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ତଥା \"ସ୍ୱପ୍ରତିୱାସିନି ସ୍ୱୱତ୍ ପ୍ରେମ କୁରୁଧ୍ୱଂ,\" ଏଷା ଯା ଦ୍ୱିତୀଯାଜ୍ଞା ସା ତାଦୃଶୀ; ଏତାଭ୍ୟାଂ ଦ୍ୱାଭ୍ୟାମ୍ ଆଜ୍ଞାଭ୍ୟାମ୍ ଅନ୍ୟା କାପ୍ୟାଜ୍ଞା ଶ୍ରେଷ୍ଠା ନାସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ତଦା ସୋଧ୍ୟାପକସ୍ତମୱଦତ୍, ହେ ଗୁରୋ ସତ୍ୟଂ ଭୱାନ୍ ଯଥାର୍ଥଂ ପ୍ରୋକ୍ତୱାନ୍ ଯତ ଏକସ୍ମାଦ୍ ଈଶ୍ୱରାଦ୍ ଅନ୍ୟୋ ଦ୍ୱିତୀଯ ଈଶ୍ୱରୋ ନାସ୍ତି; ");
INSERT INTO sanori_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ଅପରଂ ସର୍ୱ୍ୱାନ୍ତଃକରଣୈଃ ସର୍ୱ୍ୱପ୍ରାଣୈଃ ସର୍ୱ୍ୱଚିତ୍ତୈଃ ସର୍ୱ୍ୱଶକ୍ତିଭିଶ୍ଚ ଈଶ୍ୱରେ ପ୍ରେମକରଣଂ ତଥା ସ୍ୱମୀପୱାସିନି ସ୍ୱୱତ୍ ପ୍ରେମକରଣଞ୍ଚ ସର୍ୱ୍ୱେଭ୍ୟୋ ହୋମବଲିଦାନାଦିଭ୍ୟଃ ଶ୍ରଷ୍ଠଂ ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","ତତୋ ଯୀଶୁଃ ସୁବୁଦ୍ଧେରିୱ ତସ୍ୟେଦମ୍ ଉତ୍ତରଂ ଶ୍ରୁତ୍ୱା ତଂ ଭାଷିତୱାନ୍ ତ୍ୱମୀଶ୍ୱରସ୍ୟ ରାଜ୍ୟାନ୍ନ ଦୂରୋସି| ଇତଃ ପରଂ ତେନ ସହ କସ୍ୟାପି ୱାକ୍ୟସ୍ୟ ୱିଚାରଂ କର୍ତ୍ତାଂ କସ୍ୟାପି ପ୍ରଗଲ୍ଭତା ନ ଜାତା| ");
INSERT INTO sanori_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","ଅନନ୍ତରଂ ମଧ୍ୟେମନ୍ଦିରମ୍ ଉପଦିଶନ୍ ଯୀଶୁରିମଂ ପ୍ରଶ୍ନଂ ଚକାର, ଅଧ୍ୟାପକା ଅଭିଷିକ୍ତଂ (ତାରକଂ) କୁତୋ ଦାଯୂଦଃ ସନ୍ତାନଂ ୱଦନ୍ତି? ");
INSERT INTO sanori_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ସ୍ୱଯଂ ଦାଯୂଦ୍ ପୱିତ୍ରସ୍ୟାତ୍ମନ ଆୱେଶେନେଦଂ କଥଯାମାସ| ଯଥା| \"ମମ ପ୍ରଭୁମିଦଂ ୱାକ୍ୟୱଦତ୍ ପରମେଶ୍ୱରଃ| ତୱ ଶତ୍ରୂନହଂ ଯାୱତ୍ ପାଦପୀଠଂ କରୋମି ନ| ତାୱତ୍ କାଲଂ ମଦୀଯେ ତ୍ୱଂ ଦକ୍ଷପାର୍ଶ୍ୱ୍ ଉପାୱିଶ| \" ");
INSERT INTO sanori_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","ଯଦି ଦାଯୂଦ୍ ତଂ ପ୍ରଭୂଂ ୱଦତି ତର୍ହି କଥଂ ସ ତସ୍ୟ ସନ୍ତାନୋ ଭୱିତୁମର୍ହତି? ଇତରେ ଲୋକାସ୍ତତ୍କଥାଂ ଶ୍ରୁତ୍ୱାନନନ୍ଦୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","ତଦାନୀଂ ସ ତାନୁପଦିଶ୍ୟ କଥିତୱାନ୍ ଯେ ନରା ଦୀର୍ଘପରିଧେଯାନି ହଟ୍ଟେ ୱିପନୌ ଚ ");
INSERT INTO sanori_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ଲୋକକୃତନମସ୍କାରାନ୍ ଭଜନଗୃହେ ପ୍ରଧାନାସନାନି ଭୋଜନକାଲେ ପ୍ରଧାନସ୍ଥାନାନି ଚ କାଙ୍କ୍ଷନ୍ତେ; ");
INSERT INTO sanori_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ୱିଧୱାନାଂ ସର୍ୱ୍ୱସ୍ୱଂ ଗ୍ରସିତ୍ୱା ଛଲାଦ୍ ଦୀର୍ଘକାଲଂ ପ୍ରାର୍ଥଯନ୍ତେ ତେଭ୍ୟ ଉପାଧ୍ୟାଯେଭ୍ୟଃ ସାୱଧାନା ଭୱତ; ତେଽଧିକତରାନ୍ ଦଣ୍ଡାନ୍ ପ୍ରାପ୍ସ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","ତଦନନ୍ତରଂ ଲୋକା ଭାଣ୍ଡାଗାରେ ମୁଦ୍ରା ଯଥା ନିକ୍ଷିପନ୍ତି ଭାଣ୍ଡାଗାରସ୍ୟ ସମ୍ମୁଖେ ସମୁପୱିଶ୍ୟ ଯୀଶୁସ୍ତଦୱଲୁଲୋକ; ତଦାନୀଂ ବହୱୋ ଧନିନସ୍ତସ୍ୟ ମଧ୍ୟେ ବହୂନି ଧନାନି ନିରକ୍ଷିପନ୍| ");
INSERT INTO sanori_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ପଶ୍ଚାଦ୍ ଏକା ଦରିଦ୍ରା ୱିଧୱା ସମାଗତ୍ୟ ଦ୍ୱିପଣମୂଲ୍ୟାଂ ମୁଦ୍ରୈକାଂ ତତ୍ର ନିରକ୍ଷିପତ୍| ");
INSERT INTO sanori_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ତଦା ଯୀଶୁଃ ଶିଷ୍ୟାନ୍ ଆହୂଯ କଥିତୱାନ୍ ଯୁଷ୍ମାନହଂ ଯଥାର୍ଥଂ ୱଦାମି ଯେ ଯେ ଭାଣ୍ଡାଗାରେଽସ୍ମିନ ଧନାନି ନିଃକ୍ଷିପନ୍ତି ସ୍ମ ତେଭ୍ୟଃ ସର୍ୱ୍ୱେଭ୍ୟ ଇଯଂ ୱିଧୱା ଦରିଦ୍ରାଧିକମ୍ ନିଃକ୍ଷିପତି ସ୍ମ| ");
INSERT INTO sanori_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ଯତସ୍ତେ ପ୍ରଭୂତଧନସ୍ୟ କିଞ୍ଚିତ୍ ନିରକ୍ଷିପନ୍ କିନ୍ତୁ ଦୀନେଯଂ ସ୍ୱଦିନଯାପନଯୋଗ୍ୟଂ କିଞ୍ଚିଦପି ନ ସ୍ଥାପଯିତ୍ୱା ସର୍ୱ୍ୱସ୍ୱଂ ନିରକ୍ଷିପତ୍| ");
INSERT INTO sanori_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","ଅନନ୍ତରଂ ମନ୍ଦିରାଦ୍ ବହିର୍ଗମନକାଲେ ତସ୍ୟ ଶିଷ୍ୟାଣାମେକସ୍ତଂ ୱ୍ୟାହୃତୱାନ୍ ହେ ଗୁରୋ ପଶ୍ୟତୁ କୀଦୃଶାଃ ପାଷାଣାଃ କୀଦୃକ୍ ଚ ନିଚଯନଂ| ");
INSERT INTO sanori_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","ତଦା ଯୀଶୁସ୍ତମ୍ ଅୱଦତ୍ ତ୍ୱଂ କିମେତଦ୍ ବୃହନ୍ନିଚଯନଂ ପଶ୍ୟସି? ଅସ୍ୟୈକପାଷାଣୋପି ଦ୍ୱିତୀଯପାଷାଣୋପରି ନ ସ୍ଥାସ୍ୟତି ସର୍ୱ୍ୱେ ଽଧଃକ୍ଷେପ୍ସ୍ୟନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","ଅଥ ଯସ୍ମିନ୍ କାଲେ ଜୈତୁନ୍ଗିରୌ ମନ୍ଦିରସ୍ୟ ସମ୍ମୁଖେ ସ ସମୁପୱିଷ୍ଟସ୍ତସ୍ମିନ୍ କାଲେ ପିତରୋ ଯାକୂବ୍ ଯୋହନ୍ ଆନ୍ଦ୍ରିଯଶ୍ଚୈତେ ତଂ ରହସି ପପ୍ରଚ୍ଛୁଃ, ");
INSERT INTO sanori_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","ଏତା ଘଟନାଃ କଦା ଭୱିଷ୍ୟନ୍ତି? ତଥୈତତ୍ସର୍ୱ୍ୱାସାଂ ସିଦ୍ଧ୍ୟୁପକ୍ରମସ୍ୟ ୱା କିଂ ଚିହ୍ନଂ? ତଦସ୍ମଭ୍ୟଂ କଥଯତୁ ଭୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ତତୋ ଯାଶୁସ୍ତାନ୍ ୱକ୍ତୁମାରେଭେ, କୋପି ଯଥା ଯୁଷ୍ମାନ୍ ନ ଭ୍ରାମଯତି ତଥାତ୍ର ଯୂଯଂ ସାୱଧାନା ଭୱତ| ");
INSERT INTO sanori_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ଯତଃ ଖ୍ରୀଷ୍ଟୋହମିତି କଥଯିତ୍ୱା ମମ ନାମ୍ନାନେକେ ସମାଗତ୍ୟ ଲୋକାନାଂ ଭ୍ରମଂ ଜନଯିଷ୍ୟନ୍ତି; ");
INSERT INTO sanori_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","କିନ୍ତୁ ଯୂଯଂ ରଣସ୍ୟ ୱାର୍ତ୍ତାଂ ରଣାଡମ୍ବରଞ୍ଚ ଶ୍ରୁତ୍ୱା ମା ୱ୍ୟାକୁଲା ଭୱତ, ଘଟନା ଏତା ଅୱଶ୍ୟମ୍ମାୱିନ୍ୟଃ; କିନ୍ତ୍ୱାପାତତୋ ନ ଯୁଗାନ୍ତୋ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","ଦେଶସ୍ୟ ୱିପକ୍ଷତଯା ଦେଶୋ ରାଜ୍ୟସ୍ୟ ୱିପକ୍ଷତଯା ଚ ରାଜ୍ୟମୁତ୍ଥାସ୍ୟତି, ତଥା ସ୍ଥାନେ ସ୍ଥାନେ ଭୂମିକମ୍ପୋ ଦୁର୍ଭିକ୍ଷଂ ମହାକ୍ଲେଶାଶ୍ଚ ସମୁପସ୍ଥାସ୍ୟନ୍ତି, ସର୍ୱ୍ୱ ଏତେ ଦୁଃଖସ୍ୟାରମ୍ଭାଃ| ");
INSERT INTO sanori_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","କିନ୍ତୁ ଯୂଯମ୍ ଆତ୍ମାର୍ଥେ ସାୱଧାନାସ୍ତିଷ୍ଠତ, ଯତୋ ଲୋକା ରାଜସଭାଯାଂ ଯୁଷ୍ମାନ୍ ସମର୍ପଯିଷ୍ୟନ୍ତି, ତଥା ଭଜନଗୃହେ ପ୍ରହରିଷ୍ୟନ୍ତି; ଯୂଯଂ ମଦର୍ଥେ ଦେଶାଧିପାନ୍ ଭୂପାଂଶ୍ଚ ପ୍ରତି ସାକ୍ଷ୍ୟଦାନାଯ ତେଷାଂ ସମ୍ମୁଖେ ଉପସ୍ଥାପଯିଷ୍ୟଧ୍ୱେ| ");
INSERT INTO sanori_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ଶେଷୀଭୱନାତ୍ ପୂର୍ୱ୍ୱଂ ସର୍ୱ୍ୱାନ୍ ଦେଶୀଯାନ୍ ପ୍ରତି ସୁସଂୱାଦଃ ପ୍ରଚାରଯିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","କିନ୍ତୁ ଯଦା ତେ ଯୁଷ୍ମାନ୍ ଧୃତ୍ୱା ସମର୍ପଯିଷ୍ୟନ୍ତି ତଦା ଯୂଯଂ ଯଦ୍ୟଦ୍ ଉତ୍ତରଂ ଦାସ୍ୟଥ, ତଦଗ୍ର ତସ୍ୟ ୱିୱେଚନଂ ମା କୁରୁତ ତଦର୍ଥଂ କିଞ୍ଚିଦପି ମା ଚିନ୍ତଯତ ଚ, ତଦାନୀଂ ଯୁଷ୍ମାକଂ ମନଃସୁ ଯଦ୍ୟଦ୍ ୱାକ୍ୟମ୍ ଉପସ୍ଥାପଯିଷ୍ୟତେ ତଦେୱ ୱଦିଷ୍ୟଥ, ଯତୋ ଯୂଯଂ ନ ତଦ୍ୱକ୍ତାରଃ କିନ୍ତୁ ପୱିତ୍ର ଆତ୍ମା ତସ୍ୟ ୱକ୍ତା| ");
INSERT INTO sanori_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","ତଦା ଭ୍ରାତା ଭ୍ରାତରଂ ପିତା ପୁତ୍ରଂ ଘାତନାର୍ଥଂ ପରହସ୍ତେଷୁ ସମର୍ପଯିଷ୍ୟତେ, ତଥା ପତ୍ୟାନି ମାତାପିତ୍ରୋ ର୍ୱିପକ୍ଷତଯା ତୌ ଘାତଯିଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","ମମ ନାମହେତୋଃ ସର୍ୱ୍ୱେଷାଂ ସୱିଧେ ଯୂଯଂ ଜୁଗୁପ୍ସିତା ଭୱିଷ୍ୟଥ, କିନ୍ତୁ ଯଃ କଶ୍ଚିତ୍ ଶେଷପର୍ୟ୍ୟନ୍ତଂ ଧୈର୍ୟ୍ୟମ୍ ଆଲମ୍ବିଷ୍ୟତେ ସଏୱ ପରିତ୍ରାସ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","ଦାନିଯେଲ୍ଭୱିଷ୍ୟଦ୍ୱାଦିନା ପ୍ରୋକ୍ତଂ ସର୍ୱ୍ୱନାଶି ଜୁଗୁପ୍ସିତଞ୍ଚ ୱସ୍ତୁ ଯଦା ତ୍ୱଯୋଗ୍ୟସ୍ଥାନେ ୱିଦ୍ୟମାନଂ ଦ୍ରକ୍ଷଥ (ଯୋ ଜନଃ ପଠତି ସ ବୁଧ୍ୟତାଂ) ତଦା ଯେ ଯିହୂଦୀଯଦେଶେ ତିଷ୍ଠନ୍ତି ତେ ମହୀଧ୍ରଂ ପ୍ରତି ପଲାଯନ୍ତାଂ; ");
INSERT INTO sanori_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ତଥା ଯୋ ନରୋ ଗୃହୋପରି ତିଷ୍ଠତି ସ ଗୃହମଧ୍ୟଂ ନାୱରୋହତୁ, ତଥା କିମପି ୱସ୍ତୁ ଗ୍ରହୀତୁଂ ମଧ୍ୟେଗୃହଂ ନ ପ୍ରୱିଶତୁ; ");
INSERT INTO sanori_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ତଥା ଚ ଯୋ ନରଃ କ୍ଷେତ୍ରେ ତିଷ୍ଠତି ସୋପି ସ୍ୱୱସ୍ତ୍ରଂ ଗ୍ରହୀତୁଂ ପରାୱୃତ୍ୟ ନ ୱ୍ରଜତୁ| ");
INSERT INTO sanori_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ତଦାନୀଂ ଗର୍ବ୍ଭୱତୀନାଂ ସ୍ତନ୍ୟଦାତ୍ରୀଣାଞ୍ଚ ଯୋଷିତାଂ ଦୁର୍ଗତି ର୍ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ଯୁଷ୍ମାକଂ ପଲାଯନଂ ଶୀତକାଲେ ଯଥା ନ ଭୱତି ତଦର୍ଥଂ ପ୍ରାର୍ଥଯଧ୍ୱଂ| ");
INSERT INTO sanori_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ଯତସ୍ତଦା ଯାଦୃଶୀ ଦୁର୍ଘଟନା ଘଟିଷ୍ୟତେ ତାଦୃଶୀ ଦୁର୍ଘଟନା ଈଶ୍ୱରସୃଷ୍ଟେଃ ପ୍ରଥମମାରଭ୍ୟାଦ୍ୟ ଯାୱତ୍ କଦାପି ନ ଜାତା ନ ଜନିଷ୍ୟତେ ଚ| ");
INSERT INTO sanori_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","ଅପରଞ୍ଚ ପରମେଶ୍ୱରୋ ଯଦି ତସ୍ୟ ସମଯସ୍ୟ ସଂକ୍ଷେପଂ ନ କରୋତି ତର୍ହି କସ୍ୟାପି ପ୍ରାଣଭୃତୋ ରକ୍ଷା ଭୱିତୁଂ ନ ଶକ୍ଷ୍ୟତି, କିନ୍ତୁ ଯାନ୍ ଜନାନ୍ ମନୋନୀତାନ୍ ଅକରୋତ୍ ତେଷାଂ ସ୍ୱମନୋନୀତାନାଂ ହେତୋଃ ସ ତଦନେହସଂ ସଂକ୍ଷେପ୍ସ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","ଅନ୍ୟଚ୍ଚ ପଶ୍ୟତ ଖ୍ରୀଷ୍ଟୋତ୍ର ସ୍ଥାନେ ୱା ତତ୍ର ସ୍ଥାନେ ୱିଦ୍ୟତେ, ତସ୍ମିନ୍କାଲେ ଯଦି କଶ୍ଚିଦ୍ ଯୁଷ୍ମାନ୍ ଏତାଦୃଶଂ ୱାକ୍ୟଂ ୱ୍ୟାହରତି, ତର୍ହି ତସ୍ମିନ୍ ୱାକ୍ୟେ ଭୈୱ ୱିଶ୍ୱସିତ| ");
INSERT INTO sanori_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ଯତୋନେକେ ମିଥ୍ୟାଖ୍ରୀଷ୍ଟା ମିଥ୍ୟାଭୱିଷ୍ୟଦ୍ୱାଦିନଶ୍ଚ ସମୁପସ୍ଥାଯ ବହୂନି ଚିହ୍ନାନ୍ୟଦ୍ଭୁତାନି କର୍ମ୍ମାଣି ଚ ଦର୍ଶଯିଷ୍ୟନ୍ତି; ତଥା ଯଦି ସମ୍ଭୱତି ତର୍ହି ମନୋନୀତଲୋକାନାମପି ମିଥ୍ୟାମତିଂ ଜନଯିଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","ପଶ୍ୟତ ଘଟନାତଃ ପୂର୍ୱ୍ୱଂ ସର୍ୱ୍ୱକାର୍ୟ୍ୟସ୍ୟ ୱାର୍ତ୍ତାଂ ଯୁଷ୍ମଭ୍ୟମଦାମ୍, ଯୂଯଂ ସାୱଧାନାସ୍ତିଷ୍ଠତ| ");
INSERT INTO sanori_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","ଅପରଞ୍ଚ ତସ୍ୟ କ୍ଲେଶକାଲସ୍ୟାୱ୍ୟୱହିତେ ପରକାଲେ ଭାସ୍କରଃ ସାନ୍ଧକାରୋ ଭୱିଷ୍ୟତି ତଥୈୱ ଚନ୍ଦ୍ରଶ୍ଚନ୍ଦ୍ରିକାଂ ନ ଦାସ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ନଭଃସ୍ଥାନି ନକ୍ଷତ୍ରାଣି ପତିଷ୍ୟନ୍ତି, ୱ୍ୟୋମମଣ୍ଡଲସ୍ଥା ଗ୍ରହାଶ୍ଚ ୱିଚଲିଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","ତଦାନୀଂ ମହାପରାକ୍ରମେଣ ମହୈଶ୍ୱର୍ୟ୍ୟେଣ ଚ ମେଘମାରୁହ୍ୟ ସମାଯାନ୍ତଂ ମାନୱସୁତଂ ମାନୱାଃ ସମୀକ୍ଷିଷ୍ୟନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ଅନ୍ୟଚ୍ଚ ସ ନିଜଦୂତାନ୍ ପ୍ରହିତ୍ୟ ନଭୋଭୂମ୍ୟୋଃ ସୀମାଂ ଯାୱଦ୍ ଜଗତଶ୍ଚତୁର୍ଦିଗ୍ଭ୍ୟଃ ସ୍ୱମନୋନୀତଲୋକାନ୍ ସଂଗ୍ରହୀଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","ଉଡୁମ୍ବରତରୋ ର୍ଦୃଷ୍ଟାନ୍ତଂ ଶିକ୍ଷଧ୍ୱଂ ଯଦୋଡୁମ୍ବରସ୍ୟ ତରୋ ର୍ନୱୀନାଃ ଶାଖା ଜାଯନ୍ତେ ପଲ୍ଲୱାଦୀନି ଚ ର୍ନିଗଚ୍ଛନ୍ତି, ତଦା ନିଦାଘକାଲଃ ସୱିଧୋ ଭୱତୀତି ଯୂଯଂ ଜ୍ଞାତୁଂ ଶକ୍ନୁଥ| ");
INSERT INTO sanori_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ତଦ୍ୱଦ୍ ଏତା ଘଟନା ଦୃଷ୍ଟ୍ୱା ସ କାଲୋ ଦ୍ୱାର୍ୟ୍ୟୁପସ୍ଥିତ ଇତି ଜାନୀତ| ");
INSERT INTO sanori_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ଯୁଷ୍ମାନହଂ ଯଥାର୍ଥଂ ୱଦାମି, ଆଧୁନିକଲୋକାନାଂ ଗମନାତ୍ ପୂର୍ୱ୍ୱଂ ତାନି ସର୍ୱ୍ୱାଣି ଘଟିଷ୍ୟନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ଦ୍ୟାୱାପୃଥିୱ୍ୟୋ ର୍ୱିଚଲିତଯୋଃ ସତ୍ୟୋ ର୍ମଦୀଯା ୱାଣୀ ନ ୱିଚଲିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","ଅପରଞ୍ଚ ସ୍ୱର୍ଗସ୍ଥଦୂତଗଣୋ ୱା ପୁତ୍ରୋ ୱା ତାତାଦନ୍ୟଃ କୋପି ତଂ ଦିୱସଂ ତଂ ଦଣ୍ଡଂ ୱା ନ ଜ୍ଞାପଯତି| ");
INSERT INTO sanori_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ଅତଃ ସ ସମଯଃ କଦା ଭୱିଷ୍ୟତି, ଏତଜ୍ଜ୍ଞାନାଭାୱାଦ୍ ଯୂଯଂ ସାୱଧାନାସ୍ତିଷ୍ଠତ, ସତର୍କାଶ୍ଚ ଭୂତ୍ୱା ପ୍ରାର୍ଥଯଧ୍ୱଂ; ");
INSERT INTO sanori_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ଯଦ୍ୱତ୍ କଶ୍ଚିତ୍ ପୁମାନ୍ ସ୍ୱନିୱେଶନାଦ୍ ଦୂରଦେଶଂ ପ୍ରତି ଯାତ୍ରାକରଣକାଲେ ଦାସେଷୁ ସ୍ୱକାର୍ୟ୍ୟସ୍ୟ ଭାରମର୍ପଯିତ୍ୱା ସର୍ୱ୍ୱାନ୍ ସ୍ୱେ ସ୍ୱେ କର୍ମ୍ମଣି ନିଯୋଜଯତି; ଅପରଂ ଦୌୱାରିକଂ ଜାଗରିତୁଂ ସମାଦିଶ୍ୟ ଯାତି, ତଦ୍ୱନ୍ ନରପୁତ୍ରଃ| ");
INSERT INTO sanori_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","ଗୃହପତିଃ ସାଯଂକାଲେ ନିଶୀଥେ ୱା ତୃତୀଯଯାମେ ୱା ପ୍ରାତଃକାଲେ ୱା କଦାଗମିଷ୍ୟତି ତଦ୍ ଯୂଯଂ ନ ଜାନୀଥ; ");
INSERT INTO sanori_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ସ ହଠାଦାଗତ୍ୟ ଯଥା ଯୁଷ୍ମାନ୍ ନିଦ୍ରିତାନ୍ ନ ପଶ୍ୟତି, ତଦର୍ଥଂ ଜାଗରିତାସ୍ତିଷ୍ଠତ| ");
INSERT INTO sanori_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","ଯୁଷ୍ମାନହଂ ଯଦ୍ ୱଦାମି ତଦେୱ ସର୍ୱ୍ୱାନ୍ ୱଦାମି, ଜାଗରିତାସ୍ତିଷ୍ଠତେତି| ");
INSERT INTO sanori_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ତଦା ନିସ୍ତାରୋତ୍ସୱକିଣ୍ୱହୀନପୂପୋତ୍ସୱଯୋରାରମ୍ଭସ୍ୟ ଦିନଦ୍ୱଯେ ଽୱଶିଷ୍ଟେ ପ୍ରଧାନଯାଜକା ଅଧ୍ୟାପକାଶ୍ଚ କେନାପି ଛଲେନ ଯୀଶୁଂ ଧର୍ତ୍ତାଂ ହନ୍ତୁଞ୍ଚ ମୃଗଯାଞ୍ଚକ୍ରିରେ; ");
INSERT INTO sanori_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","କିନ୍ତୁ ଲୋକାନାଂ କଲହଭଯାଦୂଚିରେ, ନଚୋତ୍ସୱକାଲ ଉଚିତମେତଦିତି| ");
INSERT INTO sanori_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","ଅନନ୍ତରଂ ବୈଥନିଯାପୁुରେ ଶିମୋନକୁଷ୍ଠିନୋ ଗୃହେ ଯୋଶୌ ଭୋତ୍କୁମୁପୱିଷ୍ଟେ ସତି କାଚିଦ୍ ଯୋଷିତ୍ ପାଣ୍ଡରପାଷାଣସ୍ୟ ସମ୍ପୁଟକେନ ମହାର୍ଘ୍ୟୋତ୍ତମତୈଲମ୍ ଆନୀଯ ସମ୍ପୁଟକଂ ଭଂକ୍ତ୍ୱା ତସ୍ୟୋତ୍ତମାଙ୍ଗେ ତୈଲଧାରାଂ ପାତଯାଞ୍ଚକ୍ରେ| ");
INSERT INTO sanori_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ତସ୍ମାତ୍ କେଚିତ୍ ସ୍ୱାନ୍ତେ କୁପ୍ୟନ୍ତଃ କଥିତୱଂନ୍ତଃ କୁତୋଯଂ ତୈଲାପୱ୍ୟଯଃ? ");
INSERT INTO sanori_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ଯଦ୍ୟେତତ୍ ତୈଲ ୱ୍ୟକ୍ରେଷ୍ୟତ ତର୍ହି ମୁଦ୍ରାପାଦଶତତ୍ରଯାଦପ୍ୟଧିକଂ ତସ୍ୟ ପ୍ରାପ୍ତମୂଲ୍ୟଂ ଦରିଦ୍ରଲୋକେଭ୍ୟୋ ଦାତୁମଶକ୍ଷ୍ୟତ, କଥାମେତାଂ କଥଯିତ୍ୱା ତଯା ଯୋଷିତା ସାକଂ ୱାଚାଯୁହ୍ୟନ୍| ");
INSERT INTO sanori_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","କିନ୍ତୁ ଯୀଶୁରୁୱାଚ, କୁତ ଏତସ୍ୟୈ କୃଚ୍ଛ୍ରଂ ଦଦାସି? ମହ୍ୟମିଯଂ କର୍ମ୍ମୋତ୍ତମଂ କୃତୱତୀ| ");
INSERT INTO sanori_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ଦରିଦ୍ରାଃ ସର୍ୱ୍ୱଦା ଯୁଷ୍ମାଭିଃ ସହ ତିଷ୍ଠନ୍ତି, ତସ୍ମାଦ୍ ଯୂଯଂ ଯଦେଚ୍ଛଥ ତଦୈୱ ତାନୁପକର୍ତ୍ତାଂ ଶକ୍ନୁଥ, କିନ୍ତ୍ୱହଂ ଯୁଭାଭିଃ ସହ ନିରନ୍ତରଂ ନ ତିଷ୍ଠାମି| ");
INSERT INTO sanori_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","ଅସ୍ୟା ଯଥାସାଧ୍ୟଂ ତଥୈୱାକରୋଦିଯଂ, ଶ୍ମଶାନଯାପନାତ୍ ପୂର୍ୱ୍ୱଂ ସମେତ୍ୟ ମଦ୍ୱପୁଷି ତୈଲମ୍ ଅମର୍ଦ୍ଦଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","ଅହଂ ଯୁଷ୍ମଭ୍ୟଂ ଯଥାର୍ଥଂ କଥଯାମି, ଜଗତାଂ ମଧ୍ୟେ ଯତ୍ର ଯତ୍ର ସୁସଂୱାଦୋଯଂ ପ୍ରଚାରଯିଷ୍ୟତେ ତତ୍ର ତତ୍ର ଯୋଷିତ ଏତସ୍ୟାଃ ସ୍ମରଣାର୍ଥଂ ତତ୍କୃତକର୍ମ୍ମୈତତ୍ ପ୍ରଚାରଯିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ତତଃ ପରଂ ଦ୍ୱାଦଶାନାଂ ଶିଷ୍ୟାଣାମେକ ଈଷ୍କରିଯୋତୀଯଯିହୂଦାଖ୍ୟୋ ଯୀଶୁଂ ପରକରେଷୁ ସମର୍ପଯିତୁଂ ପ୍ରଧାନଯାଜକାନାଂ ସମୀପମିଯାଯ| ");
INSERT INTO sanori_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ତେ ତସ୍ୟ ୱାକ୍ୟଂ ସମାକର୍ଣ୍ୟ ସନ୍ତୁଷ୍ଟାଃ ସନ୍ତସ୍ତସ୍ମୈ ମୁଦ୍ରା ଦାତୁଂ ପ୍ରତ୍ୟଜାନତ; ତସ୍ମାତ୍ ସ ତଂ ତେଷାଂ କରେଷୁ ସମର୍ପଣାଯୋପାଯଂ ମୃଗଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","ଅନନ୍ତରଂ କିଣ୍ୱଶୂନ୍ୟପୂପୋତ୍ସୱସ୍ୟ ପ୍ରଥମେଽହନି ନିସ୍ତାରୋତ୍ମୱାର୍ଥଂ ମେଷମାରଣାସମଯେ ଶିଷ୍ୟାସ୍ତଂ ପପ୍ରଚ୍ଛଃ କୁତ୍ର ଗତ୍ୱା ୱଯଂ ନିସ୍ତାରୋତ୍ସୱସ୍ୟ ଭୋଜ୍ୟମାସାଦଯିଷ୍ୟାମଃ? କିମିଚ୍ଛତି ଭୱାନ୍? ");
INSERT INTO sanori_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","ତଦାନୀଂ ସ ତେଷାଂ ଦ୍ୱଯଂ ପ୍ରେରଯନ୍ ବଭାଷେ ଯୁୱଯୋଃ ପୁରମଧ୍ୟଂ ଗତଯୋଃ ସତୋ ର୍ୟୋ ଜନଃ ସଜଲକୁମ୍ଭଂ ୱହନ୍ ଯୁୱାଂ ସାକ୍ଷାତ୍ କରିଷ୍ୟତି ତସ୍ୟୈୱ ପଶ୍ଚାଦ୍ ଯାତଂ; ");
INSERT INTO sanori_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ସ ଯତ୍ ସଦନଂ ପ୍ରୱେକ୍ଷ୍ୟତି ତଦ୍ଭୱନପତିଂ ୱଦତଂ, ଗୁରୁରାହ ଯତ୍ର ସଶିଷ୍ୟୋହଂ ନିସ୍ତାରୋତ୍ସୱୀଯଂ ଭୋଜନଂ କରିଷ୍ୟାମି, ସା ଭୋଜନଶାଲା କୁତ୍ରାସ୍ତି? ");
INSERT INTO sanori_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ତତଃ ସ ପରିଷ୍କୃତାଂ ସୁସଜ୍ଜିତାଂ ବୃହତୀଚଞ୍ଚ ଯାଂ ଶାଲାଂ ଦର୍ଶଯିଷ୍ୟତି ତସ୍ୟାମସ୍ମଦର୍ଥଂ ଭୋଜ୍ୟଦ୍ରୱ୍ୟାଣ୍ୟାସାଦଯତଂ| ");
INSERT INTO sanori_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ତତଃ ଶିଷ୍ୟୌ ପ୍ରସ୍ଥାଯ ପୁରଂ ପ୍ରୱିଶ୍ୟ ସ ଯଥୋକ୍ତୱାନ୍ ତଥୈୱ ପ୍ରାପ୍ୟ ନିସ୍ତାରୋତ୍ସୱସ୍ୟ ଭୋଜ୍ୟଦ୍ରୱ୍ୟାଣି ସମାସାଦଯେତାମ୍| ");
INSERT INTO sanori_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ଅନନ୍ତରଂ ଯୀଶୁଃ ସାଯଂକାଲେ ଦ୍ୱାଦଶଭିଃ ଶିଷ୍ୟୈଃ ସାର୍ଦ୍ଧଂ ଜଗାମ; ");
INSERT INTO sanori_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ସର୍ୱ୍ୱେଷୁ ଭୋଜନାଯ ପ୍ରୋପୱିଷ୍ଟେଷୁ ସ ତାନୁଦିତୱାନ୍ ଯୁଷ୍ମାନହଂ ଯଥାର୍ଥଂ ୱ୍ୟାହରାମି, ଅତ୍ର ଯୁଷ୍ମାକମେକୋ ଜନୋ ଯୋ ମଯା ସହ ଭୁଂକ୍ତେ ମାଂ ପରକେରେଷୁ ସମର୍ପଯିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","ତଦାନୀଂ ତେ ଦୁଃଖିତାଃ ସନ୍ତ ଏକୈକଶସ୍ତଂ ପ୍ରଷ୍ଟୁମାରବ୍ଧୱନ୍ତଃ ସ କିମହଂ? ପଶ୍ଚାଦ୍ ଅନ୍ୟ ଏକୋଭିଦଧେ ସ କିମହଂ? ");
INSERT INTO sanori_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ତତଃ ସ ପ୍ରତ୍ୟୱଦଦ୍ ଏତେଷାଂ ଦ୍ୱାଦଶାନାଂ ଯୋ ଜନୋ ମଯା ସମଂ ଭୋଜନାପାତ୍ରେ ପାଣିଂ ମଜ୍ଜଯିଷ୍ୟତି ସ ଏୱ| ");
INSERT INTO sanori_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","ମନୁଜତନଯମଧି ଯାଦୃଶଂ ଲିଖିତମାସ୍ତେ ତଦନୁରୂପା ଗତିସ୍ତସ୍ୟ ଭୱିଷ୍ୟତି, କିନ୍ତୁ ଯୋ ଜନୋ ମାନୱସୁତଂ ସମର୍ପଯିଷ୍ୟତେ ହନ୍ତ ତସ୍ୟ ଜନ୍ମାଭାୱେ ସତି ଭଦ୍ରମଭୱିଷ୍ୟତ୍| ");
INSERT INTO sanori_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ଅପରଞ୍ଚ ତେଷାଂ ଭୋଜନସମଯେ ଯୀଶୁଃ ପୂପଂ ଗୃହୀତ୍ୱେଶ୍ୱରଗୁଣାନ୍ ଅନୁକୀର୍ତ୍ୟ ଭଙ୍କ୍ତ୍ୱା ତେଭ୍ୟୋ ଦତ୍ତ୍ୱା ବଭାଷେ, ଏତଦ୍ ଗୃହୀତ୍ୱା ଭୁଞ୍ଜୀଧ୍ୱମ୍ ଏତନ୍ମମ ୱିଗ୍ରହରୂପଂ| ");
INSERT INTO sanori_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ଅନନ୍ତରଂ ସ କଂସଂ ଗୃହୀତ୍ୱେଶ୍ୱରସ୍ୟ ଗୁଣାନ୍ କୀର୍ତ୍ତଯିତ୍ୱା ତେଭ୍ୟୋ ଦଦୌ, ତତସ୍ତେ ସର୍ୱ୍ୱେ ପପୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ଅପରଂ ସ ତାନୱାଦୀଦ୍ ବହୂନାଂ ନିମିତ୍ତଂ ପାତିତଂ ମମ ନୱୀନନିଯମରୂପଂ ଶୋଣିତମେତତ୍| ");
INSERT INTO sanori_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","ଯୁଷ୍ମାନହଂ ଯଥାର୍ଥଂ ୱଦାମି, ଈଶ୍ୱରସ୍ୟ ରାଜ୍ୟେ ଯାୱତ୍ ସଦ୍ୟୋଜାତଂ ଦ୍ରାକ୍ଷାରସଂ ନ ପାସ୍ୟାମି,ତାୱଦହଂ ଦ୍ରାକ୍ଷାଫଲରସଂ ପୁନ ର୍ନ ପାସ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ତଦନନ୍ତରଂ ତେ ଗୀତମେକଂ ସଂଗୀଯ ବହି ର୍ଜୈତୁନଂ ଶିଖରିଣଂ ଯଯୁଃ ");
INSERT INTO sanori_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","ଅଥ ଯୀଶୁସ୍ତାନୁୱାଚ ନିଶାଯାମସ୍ୟାଂ ମଯି ଯୁଷ୍ମାକଂ ସର୍ୱ୍ୱେଷାଂ ପ୍ରତ୍ୟୂହୋ ଭୱିଷ୍ୟତି ଯତୋ ଲିଖିତମାସ୍ତେ ଯଥା, ମେଷାଣାଂ ରକ୍ଷକଞ୍ଚାହଂ ପ୍ରହରିଷ୍ୟାମି ୱୈ ତତଃ| ମେଷାଣାଂ ନିୱହୋ ନୂନଂ ପ୍ରୱିକୀର୍ଣୋ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","କନ୍ତୁ ମଦୁତ୍ଥାନେ ଜାତେ ଯୁଷ୍ମାକମଗ୍ରେଽହଂ ଗାଲୀଲଂ ୱ୍ରଜିଷ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ତଦା ପିତରଃ ପ୍ରତିବଭାଷେ, ଯଦ୍ୟପି ସର୍ୱ୍ୱେଷାଂ ପ୍ରତ୍ୟୂହୋ ଭୱତି ତଥାପି ମମ ନୈୱ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ତତୋ ଯୀଶୁରୁକ୍ତାୱାନ୍ ଅହଂ ତୁଭ୍ୟଂ ତଥ୍ୟଂ କଥଯାମି, କ୍ଷଣାଦାଯାମଦ୍ୟ କୁକ୍କୁଟସ୍ୟ ଦ୍ୱିତୀଯୱାରରୱଣାତ୍ ପୂର୍ୱ୍ୱଂ ତ୍ୱଂ ୱାରତ୍ରଯଂ ମାମପହ୍ନୋଷ୍ୟସେ| ");
INSERT INTO sanori_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","କିନ୍ତୁ ସ ଗାଢଂ ୱ୍ୟାହରଦ୍ ଯଦ୍ୟପି ତ୍ୱଯା ସାର୍ଦ୍ଧଂ ମମ ପ୍ରାଣୋ ଯାତି ତଥାପି କଥମପି ତ୍ୱାଂ ନାପହ୍ନୋଷ୍ୟେ; ସର୍ୱ୍ୱେଽପୀତରେ ତଥୈୱ ବଭାଷିରେ| ");
INSERT INTO sanori_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ଅପରଞ୍ଚ ତେଷୁ ଗେତ୍ଶିମାନୀନାମକଂ ସ୍ଥାନ ଗତେଷୁ ସ ଶିଷ୍ୟାନ୍ ଜଗାଦ, ଯାୱଦହଂ ପ୍ରାର୍ଥଯେ ତାୱଦତ୍ର ସ୍ଥାନେ ଯୂଯଂ ସମୁପୱିଶତ| ");
INSERT INTO sanori_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","ଅଥ ସ ପିତରଂ ଯାକୂବଂ ଯୋହନଞ୍ଚ ଗୃହୀତ୍ୱା ୱୱ୍ରାଜ; ଅତ୍ୟନ୍ତଂ ତ୍ରାସିତୋ ୱ୍ୟାକୁଲିତଶ୍ଚ ତେଭ୍ୟଃ କଥଯାମାସ, ");
INSERT INTO sanori_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ନିଧନକାଲୱତ୍ ପ୍ରାଣୋ ମେଽତୀୱ ଦଃଖମେତି, ଯୂଯଂ ଜାଗ୍ରତୋତ୍ର ସ୍ଥାନେ ତିଷ୍ଠତ| ");
INSERT INTO sanori_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ତତଃ ସ କିଞ୍ଚିଦ୍ଦୂରଂ ଗତ୍ୱା ଭୂମାୱଧୋମୁଖଃ ପତିତ୍ୱା ପ୍ରାର୍ଥିତୱାନେତତ୍, ଯଦି ଭୱିତୁଂ ଶକ୍ୟଂ ତର୍ହି ଦୁଃଖସମଯୋଯଂ ମତ୍ତୋ ଦୂରୀଭୱତୁ| ");
INSERT INTO sanori_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ଅପରମୁଦିତୱାନ୍ ହେ ପିତ ର୍ହେ ପିତଃ ସର୍ୱ୍ୱେଂ ତ୍ୱଯା ସାଧ୍ୟଂ, ତତୋ ହେତୋରିମଂ କଂସଂ ମତ୍ତୋ ଦୂରୀକୁରୁ, କିନ୍ତୁ ତନ୍ ମମେଚ୍ଛାତୋ ନ ତୱେଚ୍ଛାତୋ ଭୱତୁ| ");
INSERT INTO sanori_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","ତତଃ ପରଂ ସ ଏତ୍ୟ ତାନ୍ ନିଦ୍ରିତାନ୍ ନିରୀକ୍ଷ୍ୟ ପିତରଂ ପ୍ରୋୱାଚ, ଶିମୋନ୍ ତ୍ୱଂ କିଂ ନିଦ୍ରାସି? ଘଟିକାମେକାମ୍ ଅପି ଜାଗରିତୁଂ ନ ଶକ୍ନୋଷି? ");
INSERT INTO sanori_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","ପରୀକ୍ଷାଯାଂ ଯଥା ନ ପତଥ ତଦର୍ଥଂ ସଚେତନାଃ ସନ୍ତଃ ପ୍ରାର୍ଥଯଧ୍ୱଂ; ମନ ଉଦ୍ୟୁକ୍ତମିତି ସତ୍ୟଂ କିନ୍ତୁ ୱପୁରଶକ୍ତିକଂ| ");
INSERT INTO sanori_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ଅଥ ସ ପୁନର୍ୱ୍ରଜିତ୍ୱା ପୂର୍ୱ୍ୱୱତ୍ ପ୍ରାର୍ଥଯାଞ୍ଚକ୍ରେ| ");
INSERT INTO sanori_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ପରାୱୃତ୍ୟାଗତ୍ୟ ପୁନରପି ତାନ୍ ନିଦ୍ରିତାନ୍ ଦଦର୍ଶ ତଦା ତେଷାଂ ଲୋଚନାନି ନିଦ୍ରଯା ପୂର୍ଣାନି, ତସ୍ମାତ୍ତସ୍ମୈ କା କଥା କଥଯିତୱ୍ୟା ତ ଏତଦ୍ ବୋଦ୍ଧୁଂ ନ ଶେକୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ତତଃପରଂ ତୃତୀଯୱାରଂ ଆଗତ୍ୟ ତେଭ୍ୟୋ ଽକଥଯଦ୍ ଇଦାନୀମପି ଶଯିତ୍ୱା ୱିଶ୍ରାମ୍ୟଥ? ଯଥେଷ୍ଟଂ ଜାତଂ, ସମଯଶ୍ଚୋପସ୍ଥିତଃ ପଶ୍ୟତ ମାନୱତନଯଃ ପାପିଲୋକାନାଂ ପାଣିଷୁ ସମର୍ପ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ଉତ୍ତିଷ୍ଠତ, ୱଯଂ ୱ୍ରଜାମୋ ଯୋ ଜନୋ ମାଂ ପରପାଣିଷୁ ସମର୍ପଯିଷ୍ୟତେ ପଶ୍ୟତ ସ ସମୀପମାଯାତଃ| ");
INSERT INTO sanori_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ଇମାଂ କଥାଂ କଥଯତି ସ, ଏତର୍ହିଦ୍ୱାଦଶାନାମେକୋ ଯିହୂଦା ନାମା ଶିଷ୍ୟଃ ପ୍ରଧାନଯାଜକାନାମ୍ ଉପାଧ୍ୟାଯାନାଂ ପ୍ରାଚୀନଲୋକାନାଞ୍ଚ ସନ୍ନିଧେଃ ଖଙ୍ଗଲଗୁଡଧାରିଣୋ ବହୁଲୋକାନ୍ ଗୃହୀତ୍ୱା ତସ୍ୟ ସମୀପ ଉପସ୍ଥିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ଅପରଞ୍ଚାସୌ ପରପାଣିଷୁ ସମର୍ପଯିତା ପୂର୍ୱ୍ୱମିତି ସଙ୍କେତଂ କୃତୱାନ୍ ଯମହଂ ଚୁମ୍ବିଷ୍ୟାମି ସ ଏୱାସୌ ତମେୱ ଧୃତ୍ୱା ସାୱଧାନଂ ନଯତ| ");
INSERT INTO sanori_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ଅତୋ ହେତୋଃ ସ ଆଗତ୍ୟୈୱ ଯୋଶୋଃ ସୱିଧଂ ଗତ୍ୱା ହେ ଗୁରୋ ହେ ଗୁରୋ, ଇତ୍ୟୁକ୍ତ୍ୱା ତଂ ଚୁଚୁମ୍ବ| ");
INSERT INTO sanori_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ତଦା ତେ ତଦୁପରି ପାଣୀନର୍ପଯିତ୍ୱା ତଂ ଦଧ୍ନୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ତତସ୍ତସ୍ୟ ପାର୍ଶ୍ୱସ୍ଥାନାଂ ଲୋକାନାମେକଃ ଖଙ୍ଗଂ ନିଷ୍କୋଷଯନ୍ ମହାଯାଜକସ୍ୟ ଦାସମେକଂ ପ୍ରହୃତ୍ୟ ତସ୍ୟ କର୍ଣଂ ଚିଚ୍ଛେଦ| ");
INSERT INTO sanori_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","ପଶ୍ଚାଦ୍ ଯୀଶୁସ୍ତାନ୍ ୱ୍ୟାଜହାର ଖଙ୍ଗାନ୍ ଲଗୁଡାଂଶ୍ଚ ଗୃହୀତ୍ୱା ମାଂ କିଂ ଚୌରଂ ଧର୍ତ୍ତାଂ ସମାଯାତାଃ? ");
INSERT INTO sanori_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","ମଧ୍ୟେମନ୍ଦିରଂ ସମୁପଦିଶନ୍ ପ୍ରତ୍ୟହଂ ଯୁଷ୍ମାଭିଃ ସହ ସ୍ଥିତୱାନତହଂ, ତସ୍ମିନ୍ କାଲେ ଯୂଯଂ ମାଂ ନାଦୀଧରତ, କିନ୍ତ୍ୱନେନ ଶାସ୍ତ୍ରୀଯଂ ୱଚନଂ ସେଧନୀଯଂ| ");
INSERT INTO sanori_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ତଦା ସର୍ୱ୍ୱେ ଶିଷ୍ୟାସ୍ତଂ ପରିତ୍ୟଜ୍ୟ ପଲାଯାଞ୍ଚକ୍ରିରେ| ");
INSERT INTO sanori_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ଅଥୈକୋ ଯୁୱା ମାନୱୋ ନଗ୍ନକାଯେ ୱସ୍ତ୍ରମେକଂ ନିଧାଯ ତସ୍ୟ ପଶ୍ଚାଦ୍ ୱ୍ରଜନ୍ ଯୁୱଲୋକୈ ର୍ଧୃତୋ ");
INSERT INTO sanori_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ୱସ୍ତ୍ରଂ ୱିହାଯ ନଗ୍ନଃ ପଲାଯାଞ୍ଚକ୍ରେ| ");
INSERT INTO sanori_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ଅପରଞ୍ଚ ଯସ୍ମିନ୍ ସ୍ଥାନେ ପ୍ରଧାନଯାଜକା ଉପାଧ୍ୟାଯାଃ ପ୍ରାଚୀନଲୋକାଶ୍ଚ ମହାଯାଜକେନ ସହ ସଦସି ସ୍ଥିତାସ୍ତସ୍ମିନ୍ ସ୍ଥାନେ ମହାଯାଜକସ୍ୟ ସମୀପଂ ଯୀଶୁଂ ନିନ୍ୟୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ପିତରୋ ଦୂରେ ତତ୍ପଶ୍ଚାଦ୍ ଇତ୍ୱା ମହାଯାଜକସ୍ୟାଟ୍ଟାଲିକାଂ ପ୍ରୱିଶ୍ୟ କିଙ୍କରୈଃ ସହୋପୱିଶ୍ୟ ୱହ୍ନିତାପଂ ଜଗ୍ରାହ| ");
INSERT INTO sanori_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ତଦାନୀଂ ପ୍ରଧାନଯାଜକା ମନ୍ତ୍ରିଣଶ୍ଚ ଯୀଶୁଂ ଘାତଯିତୁଂ ତତ୍ପ୍ରାତିକୂଲ୍ୟେନ ସାକ୍ଷିଣୋ ମୃଗଯାଞ୍ଚକ୍ରିରେ, କିନ୍ତୁ ନ ପ୍ରାପ୍ତାଃ| ");
INSERT INTO sanori_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ଅନେକୈସ୍ତଦ୍ୱିରୁଦ୍ଧଂ ମୃଷାସାକ୍ଷ୍ୟେ ଦତ୍ତେପି ତେଷାଂ ୱାକ୍ୟାନି ନ ସମଗଚ୍ଛନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","ସର୍ୱ୍ୱଶେଷେ କିଯନ୍ତ ଉତ୍ଥାଯ ତସ୍ୟ ପ୍ରାତିକୂଲ୍ୟେନ ମୃଷାସାକ୍ଷ୍ୟଂ ଦତ୍ତ୍ୱା କଥଯାମାସୁଃ, ");
INSERT INTO sanori_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","ଇଦଂ କରକୃତମନ୍ଦିରଂ ୱିନାଶ୍ୟ ଦିନତ୍ରଯମଧ୍ୟେ ପୁନରପରମ୍ ଅକରକୃତଂ ମନ୍ଦିରଂ ନିର୍ମ୍ମାସ୍ୟାମି, ଇତି ୱାକ୍ୟମ୍ ଅସ୍ୟ ମୁଖାତ୍ ଶ୍ରୁତମସ୍ମାଭିରିତି| ");
INSERT INTO sanori_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","କିନ୍ତୁ ତତ୍ରାପି ତେଷାଂ ସାକ୍ଷ୍ୟକଥା ନ ସଙ୍ଗାତାଃ| ");
INSERT INTO sanori_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ଅଥ ମହାଯାଜକୋ ମଧ୍ୟେସଭମ୍ ଉତ୍ଥାଯ ଯୀଶୁଂ ୱ୍ୟାଜହାର, ଏତେ ଜନାସ୍ତ୍ୱଯି ଯତ୍ ସାକ୍ଷ୍ୟମଦୁଃ ତ୍ୱମେତସ୍ୟ କିମପ୍ୟୁତ୍ତରଂ କିଂ ନ ଦାସ୍ୟସି? ");
INSERT INTO sanori_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","କିନ୍ତୁ ସ କିମପ୍ୟୁତ୍ତରଂ ନ ଦତ୍ୱା ମୌନୀଭୂଯ ତସ୍ୟୌ; ତତୋ ମହାଯାଜକଃ ପୁନରପି ତଂ ପୃଷ୍ଟାୱାନ୍ ତ୍ୱଂ ସଚ୍ଚିଦାନନ୍ଦସ୍ୟ ତନଯୋ ଽଭିଷିକ୍ତସ୍ତ୍ରତା? ");
INSERT INTO sanori_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","ତଦା ଯୀଶୁସ୍ତଂ ପ୍ରୋୱାଚ ଭୱାମ୍ୟହମ୍ ଯୂଯଞ୍ଚ ସର୍ୱ୍ୱଶକ୍ତିମତୋ ଦକ୍ଷୀଣପାର୍ଶ୍ୱେ ସମୁପୱିଶନ୍ତଂ ମେଘ ମାରୁହ୍ୟ ସମାଯାନ୍ତଞ୍ଚ ମନୁଷ୍ୟପୁତ୍ରଂ ସନ୍ଦ୍ରକ୍ଷ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ତଦା ମହାଯାଜକଃ ସ୍ୱଂ ୱମନଂ ଛିତ୍ୱା ୱ୍ୟାୱହରତ୍ ");
INSERT INTO sanori_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","କିମସ୍ମାକଂ ସାକ୍ଷିଭିଃ ପ୍ରଯୋଜନମ୍? ଈଶ୍ୱରନିନ୍ଦାୱାକ୍ୟଂ ଯୁଷ୍ମାଭିରଶ୍ରାୱି କିଂ ୱିଚାରଯଥ? ତଦାନୀଂ ସର୍ୱ୍ୱେ ଜଗଦୁରଯଂ ନିଧନଦଣ୍ଡମର୍ହତି| ");
INSERT INTO sanori_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","ତତଃ କଶ୍ଚିତ୍ କଶ୍ଚିତ୍ ତଦ୍ୱପୁଷି ନିଷ୍ଠୀୱଂ ନିଚିକ୍ଷେପ ତଥା ତନ୍ମୁଖମାଚ୍ଛାଦ୍ୟ ଚପେଟେନ ହତ୍ୱା ଗଦିତୱାନ୍ ଗଣଯିତ୍ୱା ୱଦ, ଅନୁଚରାଶ୍ଚ ଚପେଟୈସ୍ତମାଜଘ୍ନୁଃ ");
INSERT INTO sanori_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ତତଃ ପରଂ ପିତରେଽଟ୍ଟାଲିକାଧଃକୋଷ୍ଠେ ତିଷ୍ଠତି ମହାଯାଜକସ୍ୟୈକା ଦାସୀ ସମେତ୍ୟ ");
INSERT INTO sanori_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ତଂ ୱିହ୍ନିତାପଂ ଗୃହ୍ଲନ୍ତଂ ୱିଲୋକ୍ୟ ତଂ ସୁନିରୀକ୍ଷ୍ୟ ବଭାଷେ ତ୍ୱମପି ନାସରତୀଯଯୀଶୋଃ ସଙ୍ଗିନାମ୍ ଏକୋ ଜନ ଆସୀଃ| ");
INSERT INTO sanori_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","କିନ୍ତୁ ସୋପହ୍ନୁତ୍ୟ ଜଗାଦ ତମହଂ ନ ୱଦ୍ମି ତ୍ୱଂ ଯତ୍ କଥଯମି ତଦପ୍ୟହଂ ନ ବୁଦ୍ଧ୍ୟେ| ତଦାନୀଂ ପିତରେ ଚତ୍ୱରଂ ଗତୱତି କୁेକ୍କୁଟୋ ରୁରାୱ| ");
INSERT INTO sanori_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ଅଥାନ୍ୟା ଦାସୀ ପିତରଂ ଦୃଷ୍ଟ୍ୱା ସମୀପସ୍ଥାନ୍ ଜନାନ୍ ଜଗାଦ ଅଯଂ ତେଷାମେକୋ ଜନଃ| ");
INSERT INTO sanori_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ତତଃ ସ ଦ୍ୱିତୀଯୱାରମ୍ ଅପହ୍ନୁତୱାନ୍ ପଶ୍ଚାତ୍ ତତ୍ରସ୍ଥା ଲୋକାଃ ପିତରଂ ପ୍ରୋଚୁସ୍ତ୍ୱମୱଶ୍ୟଂ ତେଷାମେକୋ ଜନଃ ଯତସ୍ତ୍ୱଂ ଗାଲୀଲୀଯୋ ନର ଇତି ତୱୋଚ୍ଚାରଣଂ ପ୍ରକାଶଯତି| ");
INSERT INTO sanori_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","ତଦା ସ ଶପଥାଭିଶାପୌ କୃତ୍ୱା ପ୍ରୋୱାଚ ଯୂଯଂ କଥାଂ କଥଯଥ ତଂ ନରଂ ନ ଜାନେଽହଂ| ");
INSERT INTO sanori_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ତଦାନୀଂ ଦ୍ୱିତୀଯୱାରଂ କୁକ୍କୁଟୋ ଽରାୱୀତ୍| କୁକ୍କୁଟସ୍ୟ ଦ୍ୱିତୀଯରୱାତ୍ ପୂର୍ୱ୍ୱଂ ତ୍ୱଂ ମାଂ ୱାରତ୍ରଯମ୍ ଅପହ୍ନୋଷ୍ୟସି, ଇତି ଯଦ୍ୱାକ୍ୟଂ ଯୀଶୁନା ସମୁଦିତଂ ତତ୍ ତଦା ସଂସ୍ମୃତ୍ୟ ପିତରୋ ରୋଦିତୁମ୍ ଆରଭତ| ");
INSERT INTO sanori_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","ଅଥ ପ୍ରଭାତେ ସତି ପ୍ରଧାନଯାଜକାଃ ପ୍ରାଞ୍ଚ ଉପାଧ୍ୟାଯାଃ ସର୍ୱ୍ୱେ ମନ୍ତ୍ରିଣଶ୍ଚ ସଭାଂ କୃତ୍ୱା ଯୀଶୁृଂ ବନ୍ଧଯିତ୍ୱ ପୀଲାତାଖ୍ୟସ୍ୟ ଦେଶାଧିପତେଃ ସୱିଧଂ ନୀତ୍ୱା ସମର୍ପଯାମାସୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ତଦା ପୀଲାତସ୍ତଂ ପୃଷ୍ଟୱାନ୍ ତ୍ୱଂ କିଂ ଯିହୂଦୀଯଲୋକାନାଂ ରାଜା? ତତଃ ସ ପ୍ରତ୍ୟୁକ୍ତୱାନ୍ ସତ୍ୟଂ ୱଦସି| ");
INSERT INTO sanori_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","ଅପରଂ ପ୍ରଧାନଯାଜକାସ୍ତସ୍ୟ ବହୁଷୁ ୱାକ୍ୟେଷୁ ଦୋଷମାରୋପଯାଞ୍ଚକ୍ରୁଃ କିନ୍ତୁ ସ କିମପି ନ ପ୍ରତ୍ୟୁୱାଚ| ");
INSERT INTO sanori_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ତଦାନୀଂ ପୀଲାତସ୍ତଂ ପୁନଃ ପପ୍ରଚ୍ଛ ତ୍ୱଂ କିଂ ନୋତ୍ତରଯସି? ପଶ୍ୟୈତେ ତ୍ୱଦ୍ୱିରୁଦ୍ଧଂ କତିଷୁ ସାଧ୍ୟେଷୁ ସାକ୍ଷଂ ଦଦତି| ");
INSERT INTO sanori_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","କନ୍ତୁ ଯୀଶୁସ୍ତଦାପି ନୋତ୍ତରଂ ଦଦୌ ତତଃ ପୀଲାତ ଆଶ୍ଚର୍ୟ୍ୟଂ ଜଗାମ| ");
INSERT INTO sanori_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ଅପରଞ୍ଚ କାରାବଦ୍ଧେ କସ୍ତିଂଶ୍ଚିତ୍ ଜନେ ତନ୍ମହୋତ୍ସୱକାଲେ ଲୋକୈ ର୍ୟାଚିତେ ଦେଶାଧିପତିସ୍ତଂ ମୋଚଯତି| ");
INSERT INTO sanori_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ଯେ ଚ ପୂର୍ୱ୍ୱମୁପପ୍ଲୱମକାର୍ଷୁରୁପପ୍ଲୱେ ୱଧମପି କୃତୱନ୍ତସ୍ତେଷାଂ ମଧ୍ୟେ ତଦାନୋଂ ବରବ୍ବାନାମକ ଏକୋ ବଦ୍ଧ ଆସୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ଅତୋ ହେତୋଃ ପୂର୍ୱ୍ୱାପରୀଯାଂ ରୀତିକଥାଂ କଥଯିତ୍ୱା ଲୋକା ଉଚ୍ଚୈରୁୱନ୍ତଃ ପୀଲାତସ୍ୟ ସମକ୍ଷଂ ନିୱେଦଯାମାସୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ତଦା ପୀଲାତସ୍ତାନାଚଖ୍ୟୌ ତର୍ହି କିଂ ଯିହୂଦୀଯାନାଂ ରାଜାନଂ ମୋଚଯିଷ୍ୟାମି? ଯୁଷ୍ମାଭିଃ କିମିଷ୍ୟତେ? ");
INSERT INTO sanori_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ଯତଃ ପ୍ରଧାନଯାଜକା ଈର୍ଷ୍ୟାତ ଏୱ ଯୀଶୁଂ ସମାର୍ପଯନ୍ନିତି ସ ୱିୱେଦ| ");
INSERT INTO sanori_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","କିନ୍ତୁ ଯଥା ବରବ୍ବାଂ ମୋଚଯତି ତଥା ପ୍ରାର୍ଥଯିତୁଂ ପ୍ରଧାନଯାଜକା ଲୋକାନ୍ ପ୍ରୱର୍ତ୍ତଯାମାସୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ଅଥ ପୀଲାତଃ ପୁନଃ ପୃଷ୍ଟୱାନ୍ ତର୍ହି ଯଂ ଯିହୂଦୀଯାନାଂ ରାଜେତି ୱଦଥ ତସ୍ୟ କିଂ କରିଷ୍ୟାମି ଯୁଷ୍ମାଭିଃ କିମିଷ୍ୟତେ? ");
INSERT INTO sanori_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","ତଦା ତେ ପୁନରପି ପ୍ରୋଚ୍ଚୈଃ ପ୍ରୋଚୁସ୍ତଂ କ୍ରୁଶେ ୱେଧଯ| ");
INSERT INTO sanori_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ତସ୍ମାତ୍ ପୀଲାତଃ କଥିତୱାନ୍ କୁତଃ? ସ କିଂ କୁକର୍ମ୍ମ କୃତୱାନ୍? କିନ୍ତୁ ତେ ପୁନଶ୍ଚ ରୁୱନ୍ତୋ ୱ୍ୟାଜହ୍ରୁସ୍ତଂ କ୍ରୁଶେ ୱେଧଯ| ");
INSERT INTO sanori_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ତଦା ପୀଲାତଃ ସର୍ୱ୍ୱାଲ୍ଲୋକାନ୍ ତୋଷଯିତୁମିଚ୍ଛନ୍ ବରବ୍ବାଂ ମୋଚଯିତ୍ୱା ଯୀଶୁଂ କଶାଭିଃ ପ୍ରହୃତ୍ୟ କ୍ରୁଶେ ୱେଦ୍ଧୁଂ ତଂ ସମର୍ପଯାମ୍ବଭୂୱ| ");
INSERT INTO sanori_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ଅନନ୍ତରଂ ସୈନ୍ୟଗଣୋଽଟ୍ଟାଲିକାମ୍ ଅର୍ଥାଦ୍ ଅଧିପତେ ର୍ଗୃହଂ ଯୀଶୁଂ ନୀତ୍ୱା ସେନାନିୱହଂ ସମାହୁଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ପଶ୍ଚାତ୍ ତେ ତଂ ଧୂମଲୱର୍ଣୱସ୍ତ୍ରଂ ପରିଧାପ୍ୟ କଣ୍ଟକମୁକୁଟଂ ରଚଯିତ୍ୱା ଶିରସି ସମାରୋପ୍ୟ ");
INSERT INTO sanori_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ହେ ଯିହୂଦୀଯାନାଂ ରାଜନ୍ ନମସ୍କାର ଇତ୍ୟୁକ୍ତ୍ୱା ତଂ ନମସ୍କର୍ତ୍ତାମାରେଭିରେ| ");
INSERT INTO sanori_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ତସ୍ୟୋତ୍ତମାଙ୍ଗେ ୱେତ୍ରାଘାତଂ ଚକ୍ରୁସ୍ତଦ୍ଗାତ୍ରେ ନିଷ୍ଠୀୱଞ୍ଚ ନିଚିକ୍ଷିପୁଃ, ତଥା ତସ୍ୟ ସମ୍ମୁଖେ ଜାନୁପାତଂ ପ୍ରଣୋମୁଃ ");
INSERT INTO sanori_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ଇତ୍ଥମୁପହସ୍ୟ ଧୂମ୍ରୱର୍ଣୱସ୍ତ୍ରମ୍ ଉତ୍ତାର୍ୟ୍ୟ ତସ୍ୟ ୱସ୍ତ୍ରଂ ତଂ ପର୍ୟ୍ୟଧାପଯନ୍ କ୍ରୁଶେ ୱେଦ୍ଧୁଂ ବହିର୍ନିନ୍ୟୁଶ୍ଚ| ");
INSERT INTO sanori_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","ତତଃ ପରଂ ସେକନ୍ଦରସ୍ୟ ରୁଫସ୍ୟ ଚ ପିତା ଶିମୋନ୍ନାମା କୁରୀଣୀଯଲୋକ ଏକଃ କୁତଶ୍ଚିଦ୍ ଗ୍ରାମାଦେତ୍ୟ ପଥି ଯାତି ତଂ ତେ ଯୀଶୋଃ କ୍ରୁଶଂ ୱୋଢୁଂ ବଲାଦ୍ ଦଧ୍ନୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ଅଥ ଗୁଲ୍ଗଲ୍ତା ଅର୍ଥାତ୍ ଶିରଃକପାଲନାମକଂ ସ୍ଥାନଂ ଯୀଶୁମାନୀଯ ");
INSERT INTO sanori_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ତେ ଗନ୍ଧରସମିଶ୍ରିତଂ ଦ୍ରାକ୍ଷାରସଂ ପାତୁଂ ତସ୍ମୈ ଦଦୁଃ କିନ୍ତୁ ସ ନ ଜଗ୍ରାହ| ");
INSERT INTO sanori_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ତସ୍ମିନ୍ କ୍ରୁଶେ ୱିଦ୍ଧେ ସତି ତେଷାମେକୈକଶଃ କିଂ ପ୍ରାପ୍ସ୍ୟତୀତି ନିର୍ଣଯାଯ ");
INSERT INTO sanori_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ତସ୍ୟ ପରିଧେଯାନାଂ ୱିଭାଗାର୍ଥଂ ଗୁଟିକାପାତଂ ଚକ୍ରୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ଅପରମ୍ ଏଷ ଯିହୂଦୀଯାନାଂ ରାଜେତି ଲିଖିତଂ ଦୋଷପତ୍ରଂ ତସ୍ୟ ଶିରଊର୍ଦ୍ୱ୍ୱମ୍ ଆରୋପଯାଞ୍ଚକ୍ରୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ତସ୍ୟ ୱାମଦକ୍ଷିଣଯୋ ର୍ଦ୍ୱୌ ଚୌରୌ କ୍ରୁଶଯୋ ର୍ୱିୱିଧାତେ| ");
INSERT INTO sanori_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","ତେନୈୱ \"ଅପରାଧିଜନୈଃ ସାର୍ଦ୍ଧଂ ସ ଗଣିତୋ ଭୱିଷ୍ୟତି,\" ଇତି ଶାସ୍ତ୍ରୋକ୍ତଂ ୱଚନଂ ସିଦ୍ଧମଭୂତ| ");
INSERT INTO sanori_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","ଅନନ୍ତରଂ ମାର୍ଗେ ଯେ ଯେ ଲୋକା ଗମନାଗମନେ ଚକ୍ରୁସ୍ତେ ସର୍ୱ୍ୱ ଏୱ ଶିରାଂସ୍ୟାନ୍ଦୋଲ୍ୟ ନିନ୍ଦନ୍ତୋ ଜଗଦୁଃ, ରେ ମନ୍ଦିରନାଶକ ରେ ଦିନତ୍ରଯମଧ୍ୟେ ତନ୍ନିର୍ମ୍ମାଯକ, ");
INSERT INTO sanori_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ଅଧୁନାତ୍ମାନମ୍ ଅୱିତ୍ୱା କ୍ରୁଶାଦୱରୋହ| ");
INSERT INTO sanori_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","କିଞ୍ଚ ପ୍ରଧାନଯାଜକା ଅଧ୍ୟାପକାଶ୍ଚ ତଦ୍ୱତ୍ ତିରସ୍କୃତ୍ୟ ପରସ୍ପରଂ ଚଚକ୍ଷିରେ ଏଷ ପରାନାୱତ୍ କିନ୍ତୁ ସ୍ୱମୱିତୁଂ ନ ଶକ୍ନୋତି| ");
INSERT INTO sanori_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ଯଦୀସ୍ରାଯେଲୋ ରାଜାଭିଷିକ୍ତସ୍ତ୍ରାତା ଭୱତି ତର୍ହ୍ୟଧୁନୈନ କ୍ରୁଶାଦୱରୋହତୁ ୱଯଂ ତଦ୍ ଦୃଷ୍ଟ୍ୱା ୱିଶ୍ୱସିଷ୍ୟାମଃ; କିଞ୍ଚ ଯୌ ଲୋକୌ ତେନ ସାର୍ଦ୍ଧଂ କ୍ରୁଶେ ଽୱିଧ୍ୟେତାଂ ତାୱପି ତଂ ନିର୍ଭର୍ତ୍ସଯାମାସତୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","ଅଥ ଦ୍ୱିତୀଯଯାମାତ୍ ତୃତୀଯଯାମଂ ଯାୱତ୍ ସର୍ୱ୍ୱୋ ଦେଶଃ ସାନ୍ଧକାରୋଭୂତ୍| ");
INSERT INTO sanori_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ତତସ୍ତୃତୀଯପ୍ରହରେ ଯୀଶୁରୁଚ୍ଚୈରୱଦତ୍ ଏଲୀ ଏଲୀ ଲାମା ଶିୱକ୍ତନୀ ଅର୍ଥାଦ୍ \"ହେ ମଦୀଶ ମଦୀଶ ତ୍ୱଂ ପର୍ୟ୍ୟତ୍ୟାକ୍ଷୀଃ କୁତୋ ହି ମାଂ?\" ");
INSERT INTO sanori_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ତଦା ସମୀପସ୍ଥଲୋକାନାଂ କେଚିତ୍ ତଦ୍ୱାକ୍ୟଂ ନିଶମ୍ୟାଚଖ୍ୟୁଃ ପଶ୍ୟୈଷ ଏଲିଯମ୍ ଆହୂଯତି| ");
INSERT INTO sanori_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","ତତ ଏକୋ ଜନୋ ଧାୱିତ୍ୱାଗତ୍ୟ ସ୍ପଞ୍ଜେ ଽମ୍ଲରସଂ ପୂରଯିତ୍ୱା ତଂ ନଡାଗ୍ରେ ନିଧାଯ ପାତୁଂ ତସ୍ମୈ ଦତ୍ତ୍ୱାୱଦତ୍ ତିଷ୍ଠ ଏଲିଯ ଏନମୱରୋହଯିତୁମ୍ ଏତି ନ ୱେତି ପଶ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","ଅଥ ଯୀଶୁରୁଚ୍ଚୈଃ ସମାହୂଯ ପ୍ରାଣାନ୍ ଜହୌ| ");
INSERT INTO sanori_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ତଦା ମନ୍ଦିରସ୍ୟ ଜୱନିକୋର୍ଦ୍ୱ୍ୱାଦଧଃର୍ୟ୍ୟନ୍ତା ୱିଦୀର୍ଣା ଦ୍ୱିଖଣ୍ଡାଭୂତ୍| ");
INSERT INTO sanori_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","କିଞ୍ଚ ଇତ୍ଥମୁଚ୍ଚୈରାହୂଯ ପ୍ରାଣାନ୍ ତ୍ୟଜନ୍ତଂ ତଂ ଦୃଷ୍ଦ୍ୱା ତଦ୍ରକ୍ଷଣାଯ ନିଯୁକ୍ତୋ ଯଃ ସେନାପତିରାସୀତ୍ ସୋୱଦତ୍ ନରୋଯମ୍ ଈଶ୍ୱରପୁତ୍ର ଇତି ସତ୍ୟମ୍| ");
INSERT INTO sanori_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","ତଦାନୀଂ ମଗ୍ଦଲୀନୀ ମରିସମ୍ କନିଷ୍ଠଯାକୂବୋ ଯୋସେଶ୍ଚ ମାତାନ୍ୟମରିଯମ୍ ଶାଲୋମୀ ଚ ଯାଃ ସ୍ତ୍ରିଯୋ ");
INSERT INTO sanori_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","ଗାଲୀଲ୍ପ୍ରଦେଶେ ଯୀଶୁଂ ସେୱିତ୍ୱା ତଦନୁଗାମିନ୍ୟୋ ଜାତା ଇମାସ୍ତଦନ୍ୟାଶ୍ଚ ଯା ଅନେକା ନାର୍ୟୋ ଯୀଶୁନା ସାର୍ଦ୍ଧଂ ଯିରୂଶାଲମମାଯାତାସ୍ତାଶ୍ଚ ଦୂରାତ୍ ତାନି ଦଦୃଶୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","ଅଥାସାଦନଦିନସ୍ୟାର୍ଥାଦ୍ ୱିଶ୍ରାମୱାରାତ୍ ପୂର୍ୱ୍ୱଦିନସ୍ୟ ସାଯଂକାଲ ଆଗତ ");
INSERT INTO sanori_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ଈଶ୍ୱରରାଜ୍ୟାପେକ୍ଷ୍ୟରିମଥୀଯଯୂଷଫନାମା ମାନ୍ୟମନ୍ତ୍ରୀ ସମେତ୍ୟ ପୀଲାତସୱିଧଂ ନିର୍ଭଯୋ ଗତ୍ୱା ଯୀଶୋର୍ଦେହଂ ଯଯାଚେ| ");
INSERT INTO sanori_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","କିନ୍ତୁ ସ ଇଦାନୀଂ ମୃତଃ ପୀଲାତ ଇତ୍ୟସମ୍ଭୱଂ ମତ୍ୱା ଶତସେନାପତିମାହୂଯ ସ କଦା ମୃତ ଇତି ପପ୍ରଚ୍ଛ| ");
INSERT INTO sanori_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ଶତସେମନାପତିମୁଖାତ୍ ତଜ୍ଜ୍ଞାତ୍ୱା ଯୂଷଫେ ଯୀଶୋର୍ଦେହଂ ଦଦୌ| ");
INSERT INTO sanori_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","ପଶ୍ଚାତ୍ ସ ସୂକ୍ଷ୍ମଂ ୱାସଃ କ୍ରୀତ୍ୱା ଯୀଶୋଃ କାଯମୱରୋହ୍ୟ ତେନ ୱାସସା ୱେଷ୍ଟାଯିତ୍ୱା ଗିରୌ ଖାତଶ୍ମଶାନେ ସ୍ଥାପିତୱାନ୍ ପାଷାଣଂ ଲୋଠଯିତ୍ୱା ଦ୍ୱାରି ନିଦଧେ| ");
INSERT INTO sanori_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","କିନ୍ତୁ ଯତ୍ର ସୋସ୍ଥାପ୍ୟତ ତତ ମଗ୍ଦଲୀନୀ ମରିଯମ୍ ଯୋସିମାତୃମରିଯମ୍ ଚ ଦଦୃଶତୃଃ| ");
INSERT INTO sanori_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ଅଥ ୱିଶ୍ରାମୱାରେ ଗତେ ମଗ୍ଦଲୀନୀ ମରିଯମ୍ ଯାକୂବମାତା ମରିଯମ୍ ଶାଲୋମୀ ଚେମାସ୍ତଂ ମର୍ଦ୍ଦଯିତୁଂ ସୁଗନ୍ଧିଦ୍ରୱ୍ୟାଣି କ୍ରୀତ୍ୱା ");
INSERT INTO sanori_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ସପ୍ତାହପ୍ରଥମଦିନେଽତିପ୍ରତ୍ୟୂଷେ ସୂର୍ୟ୍ୟୋଦଯକାଲେ ଶ୍ମଶାନମୁପଗତାଃ| ");
INSERT INTO sanori_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","କିନ୍ତୁ ଶ୍ମଶାନଦ୍ୱାରପାଷାଣୋଽତିବୃହନ୍ ତଂ କୋଽପସାରଯିଷ୍ୟତୀତି ତାଃ ପରସ୍ପରଂ ଗଦନ୍ତି! ");
INSERT INTO sanori_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ଏତର୍ହି ନିରୀକ୍ଷ୍ୟ ପାଷାଣୋ ଦ୍ୱାରୋ ଽପସାରିତ ଇତି ଦଦୃଶୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ପଶ୍ଚାତ୍ତାଃ ଶ୍ମଶାନଂ ପ୍ରୱିଶ୍ୟ ଶୁକ୍ଲୱର୍ଣଦୀର୍ଘପରିଚ୍ଛଦାୱୃତମେକଂ ଯୁୱାନଂ ଶ୍ମଶାନଦକ୍ଷିଣପାର୍ଶ୍ୱ ଉପୱିଷ୍ଟଂ ଦୃଷ୍ଟ୍ୱା ଚମଚ୍ଚକ୍ରୁଃ| ");
INSERT INTO sanori_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ସୋଽୱଦତ୍, ମାଭୈଷ୍ଟ ଯୂଯଂ କ୍ରୁଶେ ହତଂ ନାସରତୀଯଯୀଶୁଂ ଗୱେଷଯଥ ସୋତ୍ର ନାସ୍ତି ଶ୍ମଶାନାଦୁଦସ୍ଥାତ୍; ତୈ ର୍ୟତ୍ର ସ ସ୍ଥାପିତଃ ସ୍ଥାନଂ ତଦିଦଂ ପଶ୍ୟତ| ");
INSERT INTO sanori_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","କିନ୍ତୁ ତେନ ଯଥୋକ୍ତଂ ତଥା ଯୁଷ୍ମାକମଗ୍ରେ ଗାଲୀଲଂ ଯାସ୍ୟତେ ତତ୍ର ସ ଯୁଷ୍ମାନ୍ ସାକ୍ଷାତ୍ କରିଷ୍ୟତେ ଯୂଯଂ ଗତ୍ୱା ତସ୍ୟ ଶିଷ୍ୟେଭ୍ୟଃ ପିତରାଯ ଚ ୱାର୍ତ୍ତାମିମାଂ କଥଯତ| ");
INSERT INTO sanori_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ତାଃ କମ୍ପିତା ୱିସ୍ତିତାଶ୍ଚ ତୂର୍ଣଂ ଶ୍ମଶାନାଦ୍ ବହିର୍ଗତ୍ୱା ପଲାଯନ୍ତ ଭଯାତ୍ କମପି କିମପି ନାୱଦଂଶ୍ଚ| ");
INSERT INTO sanori_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","ଅପରଂ ଯୀଶୁଃ ସପ୍ତାହପ୍ରଥମଦିନେ ପ୍ରତ୍ୟୂଷେ ଶ୍ମଶାନାଦୁତ୍ଥାଯ ଯସ୍ୟାଃ ସପ୍ତଭୂତାସ୍ତ୍ୟାଜିତାସ୍ତସ୍ୟୈ ମଗ୍ଦଲୀନୀମରିଯମେ ପ୍ରଥମଂ ଦର୍ଶନଂ ଦଦୌ| ");
INSERT INTO sanori_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ତତଃ ସା ଗତ୍ୱା ଶୋକରୋଦନକୃଦ୍ଭ୍ୟୋଽନୁଗତଲୋକେଭ୍ୟସ୍ତାଂ ୱାର୍ତ୍ତାଂ କଥଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","କିନ୍ତୁ ଯୀଶୁଃ ପୁନର୍ଜୀୱନ୍ ତସ୍ୟୈ ଦର୍ଶନଂ ଦତ୍ତୱାନିତି ଶ୍ରୁତ୍ୱା ତେ ନ ପ୍ରତ୍ୟଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ପଶ୍ଚାତ୍ ତେଷାଂ ଦ୍ୱାଯୋ ର୍ଗ୍ରାମଯାନକାଲେ ଯୀଶୁରନ୍ୟୱେଶଂ ଧୃତ୍ୱା ତାଭ୍ୟାଂ ଦର୍ଶନ ଦଦୌ! ");
INSERT INTO sanori_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ତାୱପି ଗତ୍ୱାନ୍ୟଶିଷ୍ୟେଭ୍ୟସ୍ତାଂ କଥାଂ କଥଯାଞ୍ଚକ୍ରତୁଃ କିନ୍ତୁ ତଯୋଃ କଥାମପି ତେ ନ ପ୍ରତ୍ୟଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ଶେଷତ ଏକାଦଶଶିଷ୍ୟେଷୁ ଭୋଜନୋପୱିଷ୍ଟେଷୁ ଯୀଶୁସ୍ତେଭ୍ୟୋ ଦର୍ଶନଂ ଦଦୌ ତଥୋତ୍ଥାନାତ୍ ପରଂ ତଦ୍ଦର୍ଶନପ୍ରାପ୍ତଲୋକାନାଂ କଥାଯାମୱିଶ୍ୱାସକରଣାତ୍ ତେଷାମୱିଶ୍ୱାସମନଃକାଠିନ୍ୟାଭ୍ୟାଂ ହେତୁଭ୍ୟାଂ ସ ତାଂସ୍ତର୍ଜିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ଅଥ ତାନାଚଖ୍ୟୌ ଯୂଯଂ ସର୍ୱ୍ୱଜଗଦ୍ ଗତ୍ୱା ସର୍ୱ୍ୱଜନାନ୍ ପ୍ରତି ସୁସଂୱାଦଂ ପ୍ରଚାରଯତ| ");
INSERT INTO sanori_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ତତ୍ର ଯଃ କଶ୍ଚିଦ୍ ୱିଶ୍ୱସ୍ୟ ମଜ୍ଜିତୋ ଭୱେତ୍ ସ ପରିତ୍ରାସ୍ୟତେ କିନ୍ତୁ ଯୋ ନ ୱିଶ୍ୱସିଷ୍ୟତି ସ ଦଣ୍ଡଯିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","କିଞ୍ଚ ଯେ ପ୍ରତ୍ୟେଷ୍ୟନ୍ତି ତୈରୀଦୃଗ୍ ଆଶ୍ଚର୍ୟ୍ୟଂ କର୍ମ୍ମ ପ୍ରକାଶଯିଷ୍ୟତେ ତେ ମନ୍ନାମ୍ନା ଭୂତାନ୍ ତ୍ୟାଜଯିଷ୍ୟନ୍ତି ଭାଷା ଅନ୍ୟାଶ୍ଚ ୱଦିଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ଅପରଂ ତୈଃ ସର୍ପେଷୁ ଧୃତେଷୁ ପ୍ରାଣନାଶକୱସ୍ତୁନି ପୀତେ ଚ ତେଷାଂ କାପି କ୍ଷତି ର୍ନ ଭୱିଷ୍ୟତି; ରୋଗିଣାଂ ଗାତ୍ରେଷୁ କରାର୍ପିତେ ତେଽରୋଗା ଭୱିଷ୍ୟନ୍ତି ଚ| ");
INSERT INTO sanori_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","ଅଥ ପ୍ରଭୁସ୍ତାନିତ୍ୟାଦିଶ୍ୟ ସ୍ୱର୍ଗଂ ନୀତଃ ସନ୍ ପରମେଶ୍ୱରସ୍ୟ ଦକ୍ଷିଣ ଉପୱିୱେଶ| ");
INSERT INTO sanori_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ତତସ୍ତେ ପ୍ରସ୍ଥାଯ ସର୍ୱ୍ୱତ୍ର ସୁସଂୱାଦୀଯକଥାଂ ପ୍ରଚାରଯିତୁମାରେଭିରେ ପ୍ରଭୁସ୍ତୁ ତେଷାଂ ସହାଯଃ ସନ୍ ପ୍ରକାଶିତାଶ୍ଚର୍ୟ୍ୟକ୍ରିଯାଭିସ୍ତାଂ କଥାଂ ପ୍ରମାଣୱତୀଂ ଚକାର| ଇତି|");
INSERT INTO sanori_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","ପ୍ରଥମତୋ ଯେ ସାକ୍ଷିଣୋ ୱାକ୍ୟପ୍ରଚାରକାଶ୍ଚାସନ୍ ତେଽସ୍ମାକଂ ମଧ୍ୟେ ଯଦ୍ୟତ୍ ସପ୍ରମାଣଂ ୱାକ୍ୟମର୍ପଯନ୍ତି ସ୍ମ ");
INSERT INTO sanori_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ତଦନୁସାରତୋଽନ୍ୟେପି ବହୱସ୍ତଦ୍ୱୃତ୍ତାନ୍ତଂ ରଚଯିତୁଂ ପ୍ରୱୃତ୍ତାଃ| ");
INSERT INTO sanori_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ଅତଏୱ ହେ ମହାମହିମଥିଯଫିଲ୍ ତ୍ୱଂ ଯା ଯାଃ କଥା ଅଶିକ୍ଷ୍ୟଥାସ୍ତାସାଂ ଦୃଢପ୍ରମାଣାନି ଯଥା ପ୍ରାପ୍ନୋଷି ");
INSERT INTO sanori_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ତଦର୍ଥଂ ପ୍ରଥମମାରଭ୍ୟ ତାନି ସର୍ୱ୍ୱାଣି ଜ୍ଞାତ୍ୱାହମପି ଅନୁକ୍ରମାତ୍ ସର୍ୱ୍ୱୱୃତ୍ତାନ୍ତାନ୍ ତୁଭ୍ୟଂ ଲେଖିତୁଂ ମତିମକାର୍ଷମ୍| ");
INSERT INTO sanori_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ଯିହୂଦାଦେଶୀଯହେରୋଦ୍ନାମକେ ରାଜତ୍ୱଂ କୁର୍ୱ୍ୱତି ଅବୀଯଯାଜକସ୍ୟ ପର୍ୟ୍ୟାଯାଧିକାରୀ ସିଖରିଯନାମକ ଏକୋ ଯାଜକୋ ହାରୋଣୱଂଶୋଦ୍ଭୱା ଇଲୀଶେୱାଖ୍ୟା ");
INSERT INTO sanori_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ତସ୍ୟ ଜାଯା ଦ୍ୱାୱିମୌ ନିର୍ଦୋଷୌ ପ୍ରଭୋଃ ସର୍ୱ୍ୱାଜ୍ଞା ୱ୍ୟୱସ୍ଥାଶ୍ଚ ସଂମନ୍ୟ ଈଶ୍ୱରଦୃଷ୍ଟୌ ଧାର୍ମ୍ମିକାୱାସ୍ତାମ୍| ");
INSERT INTO sanori_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","ତଯୋଃ ସନ୍ତାନ ଏକୋପି ନାସୀତ୍, ଯତ ଇଲୀଶେୱା ବନ୍ଧ୍ୟା ତୌ ଦ୍ୱାୱେୱ ୱୃଦ୍ଧାୱଭୱତାମ୍| ");
INSERT INTO sanori_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","ଯଦା ସ୍ୱପର୍ୟ୍ୟାନୁକ୍ରମେଣ ସିଖରିଯ ଈଶ୍ୱାସ୍ୟ ସମକ୍ଷଂ ଯାଜକୀଯଂ କର୍ମ୍ମ କରୋତି ");
INSERT INTO sanori_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ତଦା ଯଜ୍ଞସ୍ୟ ଦିନପରିପାଯ୍ୟା ପରମେଶ୍ୱରସ୍ୟ ମନ୍ଦିରେ ପ୍ରୱେଶକାଲେ ଧୂପଜ୍ୱାଲନଂ କର୍ମ୍ମ ତସ୍ୟ କରଣୀଯମାସୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ତଦ୍ଧୂପଜ୍ୱାଲନକାଲେ ଲୋକନିୱହେ ପ୍ରାର୍ଥନାଂ କର୍ତୁଂ ବହିସ୍ତିଷ୍ଠତି ");
INSERT INTO sanori_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ସତି ସିଖରିଯୋ ଯସ୍ୟାଂ ୱେଦ୍ୟାଂ ଧୂପଂ ଜ୍ୱାଲଯତି ତଦ୍ଦକ୍ଷିଣପାର୍ଶ୍ୱେ ପରମେଶ୍ୱରସ୍ୟ ଦୂତ ଏକ ଉପସ୍ଥିତୋ ଦର୍ଶନଂ ଦଦୌ| ");
INSERT INTO sanori_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ତଂ ଦୃଷ୍ଟ୍ୱା ସିଖରିଯ ଉଦ୍ୱିୱିଜେ ଶଶଙ୍କେ ଚ| ");
INSERT INTO sanori_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","ତଦା ସ ଦୂତସ୍ତଂ ବଭାଷେ ହେ ସିଖରିଯ ମା ଭୈସ୍ତୱ ପ୍ରାର୍ଥନା ଗ୍ରାହ୍ୟା ଜାତା ତୱ ଭାର୍ୟ୍ୟା ଇଲୀଶେୱା ପୁତ୍ରଂ ପ୍ରସୋଷ୍ୟତେ ତସ୍ୟ ନାମ ଯୋेହନ୍ ଇତି କରିଷ୍ୟସି| ");
INSERT INTO sanori_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","କିଞ୍ଚ ତ୍ୱଂ ସାନନ୍ଦଃ ସହର୍ଷଶ୍ଚ ଭୱିଷ୍ୟସି ତସ୍ୟ ଜନ୍ମନି ବହୱ ଆନନ୍ଦିଷ୍ୟନ୍ତି ଚ| ");
INSERT INTO sanori_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ଯତୋ ହେତୋଃ ସ ପରମେଶ୍ୱରସ୍ୟ ଗୋଚରେ ମହାନ୍ ଭୱିଷ୍ୟତି ତଥା ଦ୍ରାକ୍ଷାରସଂ ସୁରାଂ ୱା କିମପି ନ ପାସ୍ୟତି, ଅପରଂ ଜନ୍ମାରଭ୍ୟ ପୱିତ୍ରେଣାତ୍ମନା ପରିପୂର୍ଣଃ ");
INSERT INTO sanori_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","ସନ୍ ଇସ୍ରାଯେଲ୍ୱଂଶୀଯାନ୍ ଅନେକାନ୍ ପ୍ରଭୋଃ ପରମେଶ୍ୱରସ୍ୟ ମାର୍ଗମାନେଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","ସନ୍ତାନାନ୍ ପ୍ରତି ପିତୃଣାଂ ମନାଂସି ଧର୍ମ୍ମଜ୍ଞାନଂ ପ୍ରତ୍ୟନାଜ୍ଞାଗ୍ରାହିଣଶ୍ଚ ପରାୱର୍ତ୍ତଯିତୁଂ, ପ୍ରଭୋଃ ପରମେଶ୍ୱରସ୍ୟ ସେୱାର୍ଥମ୍ ଏକାଂ ସଜ୍ଜିତଜାତିଂ ୱିଧାତୁଞ୍ଚ ସ ଏଲିଯରୂପାତ୍ମଶକ୍ତିପ୍ରାପ୍ତସ୍ତସ୍ୟାଗ୍ରେ ଗମିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ତଦା ସିଖରିଯୋ ଦୂତମୱାଦୀତ୍ କଥମେତଦ୍ ୱେତ୍ସ୍ୟାମି? ଯତୋହଂ ୱୃଦ୍ଧୋ ମମ ଭାର୍ୟ୍ୟା ଚ ୱୃଦ୍ଧା| ");
INSERT INTO sanori_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ତତୋ ଦୂତଃ ପ୍ରତ୍ୟୁୱାଚ ପଶ୍ୟେଶ୍ୱରସ୍ୟ ସାକ୍ଷାଦ୍ୱର୍ତ୍ତୀ ଜିବ୍ରାଯେଲ୍ନାମା ଦୂତୋହଂ ତ୍ୱଯା ସହ କଥାଂ ଗଦିତୁଂ ତୁଭ୍ୟମିମାଂ ଶୁଭୱାର୍ତ୍ତାଂ ଦାତୁଞ୍ଚ ପ୍ରେଷିତଃ| ");
INSERT INTO sanori_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","କିନ୍ତୁ ମଦୀଯଂ ୱାକ୍ୟଂ କାଲେ ଫଲିଷ୍ୟତି ତତ୍ ତ୍ୱଯା ନ ପ୍ରତୀତମ୍ ଅତଃ କାରଣାଦ୍ ଯାୱଦେୱ ତାନି ନ ସେତ୍ସ୍ୟନ୍ତି ତାୱତ୍ ତ୍ୱଂ ୱକ୍ତୁଂମଶକ୍ତୋ ମୂକୋ ଭୱ| ");
INSERT INTO sanori_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","ତଦାନୀଂ ଯେ ଯେ ଲୋକାଃ ସିଖରିଯମପୈକ୍ଷନ୍ତ ତେ ମଧ୍ୟେମନ୍ଦିରଂ ତସ୍ୟ ବହୁୱିଲମ୍ବାଦ୍ ଆଶ୍ଚର୍ୟ୍ୟଂ ମେନିରେ| ");
INSERT INTO sanori_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ସ ବହିରାଗତୋ ଯଦା କିମପି ୱାକ୍ୟଂ ୱକ୍ତୁମଶକ୍ତଃ ସଙ୍କେତଂ କୃତ୍ୱା ନିଃଶବ୍ଦସ୍ତସ୍ୟୌ ତଦା ମଧ୍ୟେମନ୍ଦିରଂ କସ୍ୟଚିଦ୍ ଦର୍ଶନଂ ତେନ ପ୍ରାପ୍ତମ୍ ଇତି ସର୍ୱ୍ୱେ ବୁବୁଧିରେ| ");
INSERT INTO sanori_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ଅନନ୍ତରଂ ତସ୍ୟ ସେୱନପର୍ୟ୍ୟାଯେ ସମ୍ପୂର୍ଣେ ସତି ସ ନିଜଗେହଂ ଜଗାମ| ");
INSERT INTO sanori_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","କତିପଯଦିନେଷୁ ଗତେଷୁ ତସ୍ୟ ଭାର୍ୟ୍ୟା ଇଲୀଶେୱା ଗର୍ବ୍ଭୱତୀ ବଭୂୱ ");
INSERT INTO sanori_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ପଶ୍ଚାତ୍ ସା ପଞ୍ଚମାସାନ୍ ସଂଗୋପ୍ୟାକଥଯତ୍ ଲୋକାନାଂ ସମକ୍ଷଂ ମମାପମାନଂ ଖଣ୍ଡଯିତୁଂ ପରମେଶ୍ୱରୋ ମଯି ଦୃଷ୍ଟିଂ ପାତଯିତ୍ୱା କର୍ମ୍ମେଦୃଶଂ କୃତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ଅପରଞ୍ଚ ତସ୍ୟା ଗର୍ବ୍ଭସ୍ୟ ଷଷ୍ଠେ ମାସେ ଜାତେ ଗାଲୀଲ୍ପ୍ରଦେଶୀଯନାସରତ୍ପୁରେ ");
INSERT INTO sanori_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ଦାଯୂଦୋ ୱଂଶୀଯାଯ ଯୂଷଫ୍ନାମ୍ନେ ପୁରୁଷାଯ ଯା ମରିଯମ୍ନାମକୁମାରୀ ୱାଗ୍ଦତ୍ତାସୀତ୍ ତସ୍ୟାଃ ସମୀପଂ ଜିବ୍ରାଯେଲ୍ ଦୂତ ଈଶ୍ୱରେଣ ପ୍ରହିତଃ| ");
INSERT INTO sanori_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ସ ଗତ୍ୱା ଜଗାଦ ହେ ଈଶ୍ୱରାନୁଗୃହୀତକନ୍ୟେ ତୱ ଶୁଭଂ ଭୂଯାତ୍ ପ୍ରଭୁଃ ପରମେଶ୍ୱରସ୍ତୱ ସହାଯୋସ୍ତି ନାରୀଣାଂ ମଧ୍ୟେ ତ୍ୱମେୱ ଧନ୍ୟା| ");
INSERT INTO sanori_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","ତଦାନୀଂ ସା ତଂ ଦୃଷ୍ଟ୍ୱା ତସ୍ୟ ୱାକ୍ୟତ ଉଦ୍ୱିଜ୍ୟ କୀଦୃଶଂ ଭାଷଣମିଦମ୍ ଇତି ମନସା ଚିନ୍ତଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ତତୋ ଦୂତୋଽୱଦତ୍ ହେ ମରିଯମ୍ ଭଯଂ ମାକାର୍ଷୀଃ, ତ୍ୱଯି ପରମେଶ୍ୱରସ୍ୟାନୁଗ୍ରହୋସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ପଶ୍ୟ ତ୍ୱଂ ଗର୍ବ୍ଭଂ ଧୃତ୍ୱା ପୁତ୍ରଂ ପ୍ରସୋଷ୍ୟସେ ତସ୍ୟ ନାମ ଯୀଶୁରିତି କରିଷ୍ୟସି| ");
INSERT INTO sanori_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ସ ମହାନ୍ ଭୱିଷ୍ୟତି ତଥା ସର୍ୱ୍ୱେଭ୍ୟଃ ଶ୍ରେଷ୍ଠସ୍ୟ ପୁତ୍ର ଇତି ଖ୍ୟାସ୍ୟତି; ଅପରଂ ପ୍ରଭୁଃ ପରମେଶ୍ୱରସ୍ତସ୍ୟ ପିତୁର୍ଦାଯୂଦଃ ସିଂହାସନଂ ତସ୍ମୈ ଦାସ୍ୟତି; ");
INSERT INTO sanori_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ତଥା ସ ଯାକୂବୋ ୱଂଶୋପରି ସର୍ୱ୍ୱଦା ରାଜତ୍ୱଂ କରିଷ୍ୟତି, ତସ୍ୟ ରାଜତ୍ୱସ୍ୟାନ୍ତୋ ନ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","ତଦା ମରିଯମ୍ ତଂ ଦୂତଂ ବଭାଷେ ନାହଂ ପୁରୁଷସଙ୍ଗଂ କରୋମି ତର୍ହି କଥମେତତ୍ ସମ୍ଭୱିଷ୍ୟତି? ");
INSERT INTO sanori_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ତତୋ ଦୂତୋଽକଥଯତ୍ ପୱିତ୍ର ଆତ୍ମା ତ୍ୱାମାଶ୍ରାଯିଷ୍ୟତି ତଥା ସର୍ୱ୍ୱଶ୍ରେଷ୍ଠସ୍ୟ ଶକ୍ତିସ୍ତୱୋପରି ଛାଯାଂ କରିଷ୍ୟତି ତତୋ ହେତୋସ୍ତୱ ଗର୍ବ୍ଭାଦ୍ ଯଃ ପୱିତ୍ରବାଲକୋ ଜନିଷ୍ୟତେ ସ ଈଶ୍ୱରପୁତ୍ର ଇତି ଖ୍ୟାତିଂ ପ୍ରାପ୍ସ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ଅପରଞ୍ଚ ପଶ୍ୟ ତୱ ଜ୍ଞାତିରିଲୀଶେୱା ଯାଂ ସର୍ୱ୍ୱେ ବନ୍ଧ୍ୟାମୱଦନ୍ ଇଦାନୀଂ ସା ୱାର୍ଦ୍ଧକ୍ୟେ ସନ୍ତାନମେକଂ ଗର୍ବ୍ଭେଽଧାରଯତ୍ ତସ୍ୟ ଷଷ୍ଠମାସୋଭୂତ୍| ");
INSERT INTO sanori_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","କିମପି କର୍ମ୍ମ ନାସାଧ୍ୟମ୍ ଈଶ୍ୱରସ୍ୟ| ");
INSERT INTO sanori_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","ତଦା ମରିଯମ୍ ଜଗାଦ, ପଶ୍ୟ ପ୍ରଭେରହଂ ଦାସୀ ମହ୍ୟଂ ତୱ ୱାକ୍ୟାନୁସାରେଣ ସର୍ୱ୍ୱମେତଦ୍ ଘଟତାମ୍; ଅନନତରଂ ଦୂତସ୍ତସ୍ୟାଃ ସମୀପାତ୍ ପ୍ରତସ୍ଥେ| ");
INSERT INTO sanori_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","ଅଥ କତିପଯଦିନାତ୍ ପରଂ ମରିଯମ୍ ତସ୍ମାତ୍ ପର୍ୱ୍ୱତମଯପ୍ରଦେଶୀଯଯିହୂଦାଯା ନଗରମେକଂ ଶୀଘ୍ରଂ ଗତ୍ୱା ");
INSERT INTO sanori_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ସିଖରିଯଯାଜକସ୍ୟ ଗୃହଂ ପ୍ରୱିଶ୍ୟ ତସ୍ୟ ଜାଯାମ୍ ଇଲୀଶେୱାଂ ସମ୍ବୋଧ୍ୟାୱଦତ୍| ");
INSERT INTO sanori_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ତତୋ ମରିଯମଃ ସମ୍ବୋଧନୱାକ୍ୟେ ଇଲୀଶେୱାଯାଃ କର୍ଣଯୋଃ ପ୍ରୱିଷ୍ଟମାତ୍ରେ ସତି ତସ୍ୟା ଗର୍ବ୍ଭସ୍ଥବାଲକୋ ନନର୍ତ୍ତ| ତତ ଇଲୀଶେୱା ପୱିତ୍ରେଣାତ୍ମନା ପରିପୂର୍ଣା ସତୀ ");
INSERT INTO sanori_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ପ୍ରୋଚ୍ଚୈର୍ଗଦିତୁମାରେଭେ, ଯୋଷିତାଂ ମଧ୍ୟେ ତ୍ୱମେୱ ଧନ୍ୟା, ତୱ ଗର୍ବ୍ଭସ୍ଥଃ ଶିଶୁଶ୍ଚ ଧନ୍ୟଃ| ");
INSERT INTO sanori_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ତ୍ୱଂ ପ୍ରଭୋର୍ମାତା, ମମ ନିୱେଶନେ ତ୍ୱଯା ଚରଣାୱର୍ପିତୌ, ମମାଦ୍ୟ ସୌଭାଗ୍ୟମେତତ୍| ");
INSERT INTO sanori_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","ପଶ୍ୟ ତୱ ୱାକ୍ୟେ ମମ କର୍ଣଯୋଃ ପ୍ରୱିଷ୍ଟମାତ୍ରେ ସତି ମମୋଦରସ୍ଥଃ ଶିଶୁରାନନ୍ଦାନ୍ ନନର୍ତ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","ଯା ସ୍ତ୍ରୀ ୱ୍ୟଶ୍ୱସୀତ୍ ସା ଧନ୍ୟା, ଯତୋ ହେତୋସ୍ତାଂ ପ୍ରତି ପରମେଶ୍ୱରୋକ୍ତଂ ୱାକ୍ୟଂ ସର୍ୱ୍ୱଂ ସିଦ୍ଧଂ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ତଦାନୀଂ ମରିଯମ୍ ଜଗାଦ| ଧନ୍ୟୱାଦଂ ପରେଶସ୍ୟ କରୋତି ମାମକଂ ମନଃ| ");
INSERT INTO sanori_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ମମାତ୍ମା ତାରକେଶେ ଚ ସମୁଲ୍ଲାସଂ ପ୍ରଗଚ୍ଛତି| ");
INSERT INTO sanori_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ଅକରୋତ୍ ସ ପ୍ରଭୁ ର୍ଦୁଷ୍ଟିଂ ସ୍ୱଦାସ୍ୟା ଦୁର୍ଗତିଂ ପ୍ରତି| ପଶ୍ୟାଦ୍ୟାରଭ୍ୟ ମାଂ ଧନ୍ୟାଂ ୱକ୍ଷ୍ୟନ୍ତି ପୁରୁଷାଃ ସଦା| ");
INSERT INTO sanori_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ଯଃ ସର୍ୱ୍ୱଶକ୍ତିମାନ୍ ଯସ୍ୟ ନାମାପି ଚ ପୱିତ୍ରକଂ| ସ ଏୱ ସୁମହତ୍କର୍ମ୍ମ କୃତୱାନ୍ ମନ୍ନିମିତ୍ତକଂ| ");
INSERT INTO sanori_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ଯେ ବିଭ୍ୟତି ଜନାସ୍ତସ୍ମାତ୍ ତେଷାଂ ସନ୍ତାନପଂକ୍ତିଷୁ| ଅନୁକମ୍ପା ତଦୀଯା ଚ ସର୍ୱ୍ୱଦୈୱ ସୁତିଷ୍ଠତି| ");
INSERT INTO sanori_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ସ୍ୱବାହୁବଲତସ୍ତେନ ପ୍ରାକାଶ୍ୟତ ପରାକ୍ରମଃ| ମନଃକୁମନ୍ତ୍ରଣାସାର୍ଦ୍ଧଂ ୱିକୀର୍ୟ୍ୟନ୍ତେଽଭିମାନିନଃ| ");
INSERT INTO sanori_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ସିଂହାସନଗତାଲ୍ଲୋକାନ୍ ବଲିନଶ୍ଚାୱରୋହ୍ୟ ସଃ| ପଦେଷୂଚ୍ଚେଷୁ ଲୋକାଂସ୍ତୁ କ୍ଷୁଦ୍ରାନ୍ ସଂସ୍ଥାପଯତ୍ୟପି| ");
INSERT INTO sanori_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","କ୍ଷୁଧିତାନ୍ ମାନୱାନ୍ ଦ୍ରୱ୍ୟୈରୁତ୍ତମୈଃ ପରିତର୍ପ୍ୟ ସଃ| ସକଲାନ୍ ଧନିନୋ ଲୋକାନ୍ ୱିସୃଜେଦ୍ ରିକ୍ତହସ୍ତକାନ୍| ");
INSERT INTO sanori_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ଇବ୍ରାହୀମି ଚ ତଦ୍ୱଂଶେ ଯା ଦଯାସ୍ତି ସଦୈୱ ତାଂ| ସ୍ମୃତ୍ୱା ପୁରା ପିତୃଣାଂ ନୋ ଯଥା ସାକ୍ଷାତ୍ ପ୍ରତିଶ୍ରୁତଂ| ");
INSERT INTO sanori_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ଇସ୍ରାଯେଲ୍ସେୱକସ୍ତେନ ତଥୋପକ୍ରିଯତେ ସ୍ୱଯଂ|| ");
INSERT INTO sanori_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","ଅନନ୍ତରଂ ମରିଯମ୍ ପ୍ରାଯେଣ ମାସତ୍ରଯମ୍ ଇଲୀଶେୱଯା ସହୋଷିତ୍ୱା ୱ୍ୟାଘୁଯ୍ୟ ନିଜନିୱେଶନଂ ଯଯୌ| ");
INSERT INTO sanori_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","ତଦନନ୍ତରମ୍ ଇଲୀଶେୱାଯାଃ ପ୍ରସୱକାଲ ଉପସ୍ଥିତେ ସତି ସା ପୁତ୍ରଂ ପ୍ରାସୋଷ୍ଟ| ");
INSERT INTO sanori_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ତତଃ ପରମେଶ୍ୱରସ୍ତସ୍ୟାଂ ମହାନୁଗ୍ରହଂ କୃତୱାନ୍ ଏତତ୍ ଶ୍ରୁତ୍ୱା ସମୀପୱାସିନଃ କୁଟୁମ୍ବାଶ୍ଚାଗତ୍ୟ ତଯା ସହ ମୁମୁଦିରେ| ");
INSERT INTO sanori_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","ତଥାଷ୍ଟମେ ଦିନେ ତେ ବାଲକସ୍ୟ ତ୍ୱଚଂ ଛେତ୍ତୁମ୍ ଏତ୍ୟ ତସ୍ୟ ପିତୃନାମାନୁରୂପଂ ତନ୍ନାମ ସିଖରିଯ ଇତି କର୍ତ୍ତୁମୀଷୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","କିନ୍ତୁ ତସ୍ୟ ମାତାକଥଯତ୍ ତନ୍ନ, ନାମାସ୍ୟ ଯୋହନ୍ ଇତି କର୍ତ୍ତୱ୍ୟମ୍| ");
INSERT INTO sanori_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ତଦା ତେ ୱ୍ୟାହରନ୍ ତୱ ୱଂଶମଧ୍ୟେ ନାମେଦୃଶଂ କସ୍ୟାପି ନାସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ତତଃ ପରଂ ତସ୍ୟ ପିତରଂ ସିଖରିଯଂ ପ୍ରତି ସଙ୍କେତ୍ୟ ପପ୍ରଚ୍ଛୁଃ ଶିଶୋଃ କିଂ ନାମ କାରିଷ୍ୟତେ? ");
INSERT INTO sanori_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ତତଃ ସ ଫଲକମେକଂ ଯାଚିତ୍ୱା ଲିଲେଖ ତସ୍ୟ ନାମ ଯୋହନ୍ ଭୱିଷ୍ୟତି| ତସ୍ମାତ୍ ସର୍ୱ୍ୱେ ଆଶ୍ଚର୍ୟ୍ୟଂ ମେନିରେ| ");
INSERT INTO sanori_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ତତ୍କ୍ଷଣଂ ସିଖରିଯସ୍ୟ ଜିହ୍ୱାଜାଡ୍ୟେଽପଗତେ ସ ମୁଖଂ ୱ୍ୟାଦାଯ ସ୍ପଷ୍ଟୱର୍ଣମୁଚ୍ଚାର୍ୟ୍ୟ ଈଶ୍ୱରସ୍ୟ ଗୁଣାନୁୱାଦଂ ଚକାର| ");
INSERT INTO sanori_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","ତସ୍ମାଚ୍ଚତୁର୍ଦିକ୍ସ୍ଥାଃ ସମୀପୱାସିଲୋକା ଭୀତା ଏୱମେତାଃ ସର୍ୱ୍ୱାଃ କଥା ଯିହୂଦାଯାଃ ପର୍ୱ୍ୱତମଯପ୍ରଦେଶସ୍ୟ ସର୍ୱ୍ୱତ୍ର ପ୍ରଚାରିତାଃ| ");
INSERT INTO sanori_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ତସ୍ମାତ୍ ଶ୍ରୋତାରୋ ମନଃସୁ ସ୍ଥାପଯିତ୍ୱା କଥଯାମ୍ବଭୂୱୁଃ କୀଦୃଶୋଯଂ ବାଲୋ ଭୱିଷ୍ୟତି? ଅଥ ପରମେଶ୍ୱରସ୍ତସ୍ୟ ସହାଯୋଭୂତ୍| ");
INSERT INTO sanori_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ତଦା ଯୋହନଃ ପିତା ସିଖରିଯଃ ପୱିତ୍ରେଣାତ୍ମନା ପରିପୂର୍ଣଃ ସନ୍ ଏତାଦୃଶଂ ଭୱିଷ୍ୟଦ୍ୱାକ୍ୟଂ କଥଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","ଇସ୍ରାଯେଲଃ ପ୍ରଭୁ ର୍ୟସ୍ତୁ ସ ଧନ୍ୟଃ ପରମେଶ୍ୱରଃ| ଅନୁଗୃହ୍ୟ ନିଜାଲ୍ଲୋକାନ୍ ସ ଏୱ ପରିମୋଚଯେତ୍| ");
INSERT INTO sanori_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ୱିପକ୍ଷଜନହସ୍ତେଭ୍ୟୋ ଯଥା ମୋଚ୍ୟାମହେ ୱଯଂ| ଯାୱଜ୍ଜୀୱଞ୍ଚ ଧର୍ମ୍ମେଣ ସାରଲ୍ୟେନ ଚ ନିର୍ଭଯାଃ| ");
INSERT INTO sanori_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ସେୱାମହୈ ତମେୱୈକମ୍ ଏତତ୍କାରଣମେୱ ଚ| ସ୍ୱକୀଯଂ ସୁପୱିତ୍ରଞ୍ଚ ସଂସ୍ମୃତ୍ୟ ନିଯମଂ ସଦା| ");
INSERT INTO sanori_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","କୃପଯା ପୁରୁଷାନ୍ ପୂର୍ୱ୍ୱାନ୍ ନିକଷାର୍ଥାତ୍ତୁ ନଃ ପିତୁଃ| ଇବ୍ରାହୀମଃ ସମୀପେ ଯଂ ଶପଥଂ କୃତୱାନ୍ ପୁରା| ");
INSERT INTO sanori_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ତମେୱ ସଫଲଂ କର୍ତ୍ତଂ ତଥା ଶତ୍ରୁଗଣସ୍ୟ ଚ| ଋृତୀଯାକାରିଣଶ୍ଚୈୱ କରେଭ୍ୟୋ ରକ୍ଷଣାଯ ନଃ| ");
INSERT INTO sanori_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ସୃଷ୍ଟେଃ ପ୍ରଥମତଃ ସ୍ୱୀଯୈଃ ପୱିତ୍ରୈ ର୍ଭାୱିୱାଦିଭିଃ| ");
INSERT INTO sanori_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ଯଥୋକ୍ତୱାନ୍ ତଥା ସ୍ୱସ୍ୟ ଦାଯୂଦଃ ସେୱକସ୍ୟ ତୁ| ");
INSERT INTO sanori_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ୱଂଶେ ତ୍ରାତାରମେକଂ ସ ସମୁତ୍ପାଦିତୱାନ୍ ସ୍ୱଯମ୍| ");
INSERT INTO sanori_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ଅତୋ ହେ ବାଲକ ତ୍ୱନ୍ତୁ ସର୍ୱ୍ୱେଭ୍ୟଃ ଶ୍ରେଷ୍ଠ ଏୱ ଯଃ| ତସ୍ୟୈୱ ଭାୱିୱାଦୀତି ପ୍ରୱିଖ୍ୟାତୋ ଭୱିଷ୍ୟସି| ଅସ୍ମାକଂ ଚରଣାନ୍ କ୍ଷେମେ ମାର୍ଗେ ଚାଲଯିତୁଂ ସଦା| ଏୱଂ ଧ୍ୱାନ୍ତେଽର୍ଥତୋ ମୃତ୍ୟୋଶ୍ଛାଯାଯାଂ ଯେ ତୁ ମାନୱାଃ| ");
INSERT INTO sanori_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ଉପୱିଷ୍ଟାସ୍ତୁ ତାନେୱ ପ୍ରକାଶଯିତୁମେୱ ହି| କୃତ୍ୱା ମହାନୁକମ୍ପାଂ ହି ଯାମେୱ ପରମେଶ୍ୱରଃ| ");
INSERT INTO sanori_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ଊର୍ଦ୍ୱ୍ୱାତ୍ ସୂର୍ୟ୍ୟମୁଦାଯ୍ୟୈୱାସ୍ମଭ୍ୟଂ ପ୍ରାଦାତ୍ତୁ ଦର୍ଶନଂ| ତଯାନୁକମ୍ପଯା ସ୍ୱସ୍ୟ ଲୋକାନାଂ ପାପମୋଚନେ| ");
INSERT INTO sanori_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ପରିତ୍ରାଣସ୍ୟ ତେଭ୍ୟୋ ହି ଜ୍ଞାନୱିଶ୍ରାଣନାଯ ଚ| ପ୍ରଭୋ ର୍ମାର୍ଗଂ ପରିଷ୍କର୍ତ୍ତୁଂ ତସ୍ୟାଗ୍ରାଯୀ ଭୱିଷ୍ୟସି|| ");
INSERT INTO sanori_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","ଅଥ ବାଲକଃ ଶରୀରେଣ ବୁଦ୍ଧ୍ୟା ଚ ୱର୍ଦ୍ଧିତୁମାରେଭେ; ଅପରଞ୍ଚ ସ ଇସ୍ରାଯେଲୋ ୱଂଶୀଯଲୋକାନାଂ ସମୀପେ ଯାୱନ୍ନ ପ୍ରକଟୀଭୂତସ୍ତାସ୍ତାୱତ୍ ପ୍ରାନ୍ତରେ ନ୍ୟୱସତ୍| ");
INSERT INTO sanori_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","ଅପରଞ୍ଚ ତସ୍ମିନ୍ କାଲେ ରାଜ୍ୟସ୍ୟ ସର୍ୱ୍ୱେଷାଂ ଲୋକାନାଂ ନାମାନି ଲେଖଯିତୁମ୍ ଅଗସ୍ତକୈସର ଆଜ୍ଞାପଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ତଦନୁସାରେଣ କୁରୀଣିଯନାମନି ସୁରିଯାଦେଶସ୍ୟ ଶାସକେ ସତି ନାମଲେଖନଂ ପ୍ରାରେଭେ| ");
INSERT INTO sanori_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","ଅତୋ ହେତୋ ର୍ନାମ ଲେଖିତୁଂ ସର୍ୱ୍ୱେ ଜନାଃ ସ୍ୱୀଯଂ ସ୍ୱୀଯଂ ନଗରଂ ଜଗ୍ମୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ତଦାନୀଂ ଯୂଷଫ୍ ନାମ ଲେଖିତୁଂ ୱାଗ୍ଦତ୍ତଯା ସ୍ୱଭାର୍ୟ୍ୟଯା ଗର୍ବ୍ଭୱତ୍ୟା ମରିଯମା ସହ ସ୍ୱଯଂ ଦାଯୂଦଃ ସଜାତିୱଂଶ ଇତି କାରଣାଦ୍ ଗାଲୀଲ୍ପ୍ରଦେଶସ୍ୟ ନାସରତ୍ନଗରାଦ୍ ");
INSERT INTO sanori_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ଯିହୂଦାପ୍ରଦେଶସ୍ୟ ବୈତ୍ଲେହମାଖ୍ୟଂ ଦାଯୂଦ୍ନଗରଂ ଜଗାମ| ");
INSERT INTO sanori_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ଅନ୍ୟଚ୍ଚ ତତ୍ର ସ୍ଥାନେ ତଯୋସ୍ତିଷ୍ଠତୋଃ ସତୋ ର୍ମରିଯମଃ ପ୍ରସୂତିକାଲ ଉପସ୍ଥିତେ ");
INSERT INTO sanori_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ସା ତଂ ପ୍ରଥମସୁତଂ ପ୍ରାସୋଷ୍ଟ କିନ୍ତୁ ତସ୍ମିନ୍ ୱାସଗୃହେ ସ୍ଥାନାଭାୱାଦ୍ ବାଲକଂ ୱସ୍ତ୍ରେଣ ୱେଷ୍ଟଯିତ୍ୱା ଗୋଶାଲାଯାଂ ସ୍ଥାପଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","ଅନନ୍ତରଂ ଯେ କିଯନ୍ତୋ ମେଷପାଲକାଃ ସ୍ୱମେଷୱ୍ରଜରକ୍ଷାଯୈ ତତ୍ପ୍ରଦେଶେ ସ୍ଥିତ୍ୱା ରଜନ୍ୟାଂ ପ୍ରାନ୍ତରେ ପ୍ରହରିଣଃ କର୍ମ୍ମ କୁର୍ୱ୍ୱନ୍ତି, ");
INSERT INTO sanori_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","ତେଷାଂ ସମୀପଂ ପରମେଶ୍ୱରସ୍ୟ ଦୂତ ଆଗତ୍ୟୋପତସ୍ଥୌ; ତଦା ଚତୁଷ୍ପାର୍ଶ୍ୱେ ପରମେଶ୍ୱରସ୍ୟ ତେଜସଃ ପ୍ରକାଶିତତ୍ୱାତ୍ ତେଽତିଶଶଙ୍କିରେ| ");
INSERT INTO sanori_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ତଦା ସ ଦୂତ ଉୱାଚ ମା ଭୈଷ୍ଟ ପଶ୍ୟତାଦ୍ୟ ଦାଯୂଦଃ ପୁରେ ଯୁଷ୍ମନ୍ନିମିତ୍ତଂ ତ୍ରାତା ପ୍ରଭୁଃ ଖ୍ରୀଷ୍ଟୋଽଜନିଷ୍ଟ, ");
INSERT INTO sanori_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ସର୍ୱ୍ୱେଷାଂ ଲୋକାନାଂ ମହାନନ୍ଦଜନକମ୍ ଇମଂ ମଙ୍ଗଲୱୃତ୍ତାନ୍ତଂ ଯୁଷ୍ମାନ୍ ଜ୍ଞାପଯାମି| ");
INSERT INTO sanori_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","ଯୂଯଂ (ତତ୍ସ୍ଥାନଂ ଗତ୍ୱା) ୱସ୍ତ୍ରୱେଷ୍ଟିତଂ ତଂ ବାଲକଂ ଗୋଶାଲାଯାଂ ଶଯନଂ ଦ୍ରକ୍ଷ୍ୟଥ ଯୁଷ୍ମାନ୍ ପ୍ରତୀଦଂ ଚିହ୍ନଂ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ଦୂତ ଇମାଂ କଥାଂ କଥିତୱତି ତତ୍ରାକସ୍ମାତ୍ ସ୍ୱର୍ଗୀଯାଃ ପୃତନା ଆଗତ୍ୟ କଥାମ୍ ଇମାଂ କଥଯିତ୍ୱେଶ୍ୱରସ୍ୟ ଗୁଣାନନ୍ୱୱାଦିଷୁଃ, ଯଥା, ");
INSERT INTO sanori_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","ସର୍ୱ୍ୱୋର୍ଦ୍ୱ୍ୱସ୍ଥୈରୀଶ୍ୱରସ୍ୟ ମହିମା ସମ୍ପ୍ରକାଶ୍ୟତାଂ| ଶାନ୍ତିର୍ଭୂଯାତ୍ ପୃଥିୱ୍ୟାସ୍ତୁ ସନ୍ତୋଷଶ୍ଚ ନରାନ୍ ପ୍ରତି|| ");
INSERT INTO sanori_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ତତଃ ପରଂ ତେଷାଂ ସନ୍ନିଧେ ର୍ଦୂତଗଣେ ସ୍ୱର୍ଗଂ ଗତେ ମେଷପାଲକାଃ ପରସ୍ପରମ୍ ଅୱେଚନ୍ ଆଗଚ୍ଛତ ପ୍ରଭୁଃ ପରମେଶ୍ୱରୋ ଯାଂ ଘଟନାଂ ଜ୍ଞାପିତୱାନ୍ ତସ୍ୟା ଯାଥର୍ୟଂ ଜ୍ଞାତୁଂ ୱଯମଧୁନା ବୈତ୍ଲେହମ୍ପୁରଂ ଯାମଃ| ");
INSERT INTO sanori_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ପଶ୍ଚାତ୍ ତେ ତୂର୍ଣଂ ୱ୍ରଜିତ୍ୱା ମରିଯମଂ ଯୂଷଫଂ ଗୋଶାଲାଯାଂ ଶଯନଂ ବାଲକଞ୍ଚ ଦଦୃଶୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ଇତ୍ଥଂ ଦୃଷ୍ଟ୍ୱା ବାଲକସ୍ୟାର୍ଥେ ପ୍ରୋକ୍ତାଂ ସର୍ୱ୍ୱକଥାଂ ତେ ପ୍ରାଚାରଯାଞ୍ଚକ୍ରୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ତତୋ ଯେ ଲୋକା ମେଷରକ୍ଷକାଣାଂ ୱଦନେଭ୍ୟସ୍ତାଂ ୱାର୍ତ୍ତାଂ ଶୁଶ୍ରୁୱୁସ୍ତେ ମହାଶ୍ଚର୍ୟ୍ୟଂ ମେନିରେ| ");
INSERT INTO sanori_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","କିନ୍ତୁ ମରିଯମ୍ ଏତତ୍ସର୍ୱ୍ୱଘଟନାନାଂ ତାତ୍ପର୍ୟ୍ୟଂ ୱିୱିଚ୍ୟ ମନସି ସ୍ଥାପଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","ତତ୍ପଶ୍ଚାଦ୍ ଦୂତୱିଜ୍ଞପ୍ତାନୁରୂପଂ ଶ୍ରୁତ୍ୱା ଦୃଷ୍ଟ୍ୱା ଚ ମେଷପାଲକା ଈଶ୍ୱରସ୍ୟ ଗୁଣାନୁୱାଦଂ ଧନ୍ୟୱାଦଞ୍ଚ କୁର୍ୱ୍ୱାଣାଃ ପରାୱୃତ୍ୟ ଯଯୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","ଅଥ ବାଲକସ୍ୟ ତ୍ୱକ୍ଛେଦନକାଲେଽଷ୍ଟମଦିୱସେ ସମୁପସ୍ଥିତେ ତସ୍ୟ ଗର୍ବ୍ଭସ୍ଥିତେଃ ପୁର୍ୱ୍ୱଂ ସ୍ୱର୍ଗୀଯଦୂତୋ ଯଥାଜ୍ଞାପଯତ୍ ତଦନୁରୂପଂ ତେ ତନ୍ନାମଧେଯଂ ଯୀଶୁରିତି ଚକ୍ରିରେ| ");
INSERT INTO sanori_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","ତତଃ ପରଂ ମୂସାଲିଖିତୱ୍ୟୱସ୍ଥାଯା ଅନୁସାରେଣ ମରିଯମଃ ଶୁଚିତ୍ୱକାଲ ଉପସ୍ଥିତେ, ");
INSERT INTO sanori_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","\"ପ୍ରଥମଜଃ ସର୍ୱ୍ୱଃ ପୁରୁଷସନ୍ତାନଃ ପରମେଶ୍ୱରେ ସମର୍ପ୍ୟତାଂ,\" ଇତି ପରମେଶ୍ୱରସ୍ୟ ୱ୍ୟୱସ୍ଥଯା ");
INSERT INTO sanori_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ଯୀଶୁଂ ପରମେଶ୍ୱରେ ସମର୍ପଯିତୁମ୍ ଶାସ୍ତ୍ରୀଯୱିଧ୍ୟୁକ୍ତଂ କପୋତଦ୍ୱଯଂ ପାରାୱତଶାୱକଦ୍ୱଯଂ ୱା ବଲିଂ ଦାତୁଂ ତେ ତଂ ଗୃହୀତ୍ୱା ଯିରୂଶାଲମମ୍ ଆଯଯୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ଯିରୂଶାଲମ୍ପୁରନିୱାସୀ ଶିମିଯୋନ୍ନାମା ଧାର୍ମ୍ମିକ ଏକ ଆସୀତ୍ ସ ଇସ୍ରାଯେଲଃ ସାନ୍ତ୍ୱନାମପେକ୍ଷ୍ୟ ତସ୍ଥୌ କିଞ୍ଚ ପୱିତ୍ର ଆତ୍ମା ତସ୍ମିନ୍ନାୱିର୍ଭୂତଃ| ");
INSERT INTO sanori_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ଅପରଂ ପ୍ରଭୁଣା ପରମେଶ୍ୱରେଣାଭିଷିକ୍ତେ ତ୍ରାତରି ତ୍ୱଯା ନ ଦୃଷ୍ଟେ ତ୍ୱଂ ନ ମରିଷ୍ୟସୀତି ୱାକ୍ୟଂ ପୱିତ୍ରେଣ ଆତ୍ମନା ତସ୍ମ ପ୍ରାକଥ୍ୟତ| ");
INSERT INTO sanori_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ଅପରଞ୍ଚ ଯଦା ଯୀଶୋଃ ପିତା ମାତା ଚ ତଦର୍ଥଂ ୱ୍ୟୱସ୍ଥାନୁରୂପଂ କର୍ମ୍ମ କର୍ତ୍ତୁଂ ତଂ ମନ୍ଦିରମ୍ ଆନିନ୍ୟତୁସ୍ତଦା ");
INSERT INTO sanori_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ଶିମିଯୋନ୍ ଆତ୍ମନ ଆକର୍ଷଣେନ ମନ୍ଦିରମାଗତ୍ୟ ତଂ କ୍ରୋଡେ ନିଧାଯ ଈଶ୍ୱରସ୍ୟ ଧନ୍ୟୱାଦଂ କୃତ୍ୱା କଥଯାମାସ, ଯଥା, ");
INSERT INTO sanori_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","ହେ ପ୍ରଭୋ ତୱ ଦାସୋଯଂ ନିଜୱାକ୍ୟାନୁସାରତଃ| ଇଦାନୀନ୍ତୁ ସକଲ୍ୟାଣୋ ଭୱତା ସଂୱିସୃଜ୍ୟତାମ୍| ");
INSERT INTO sanori_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ଯତଃ ସକଲଦେଶସ୍ୟ ଦୀପ୍ତଯେ ଦୀପ୍ତିରୂପକଂ| ");
INSERT INTO sanori_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ଇସ୍ରାଯେଲୀଯଲୋକସ୍ୟ ମହାଗୌରୱରୂପକଂ| ");
INSERT INTO sanori_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ଯଂ ତ୍ରାଯକଂ ଜନାନାନ୍ତୁ ସମ୍ମୁଖେ ତ୍ୱମଜୀଜନଃ| ସଏୱ ୱିଦ୍ୟତେଽସ୍ମାକଂ ଧ୍ରୱଂ ନଯନନଗୋଚରେ|| ");
INSERT INTO sanori_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ତଦାନୀଂ ତେନୋକ୍ତା ଏତାଃ ସକଲାଃ କଥାଃ ଶ୍ରୁତ୍ୱା ତସ୍ୟ ମାତା ଯୂଷଫ୍ ଚ ୱିସ୍ମଯଂ ମେନାତେ| ");
INSERT INTO sanori_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ତତଃ ପରଂ ଶିମିଯୋନ୍ ତେଭ୍ୟ ଆଶିଷଂ ଦତ୍ତ୍ୱା ତନ୍ମାତରଂ ମରିଯମମ୍ ଉୱାଚ, ପଶ୍ୟ ଇସ୍ରାଯେଲୋ ୱଂଶମଧ୍ୟେ ବହୂନାଂ ପାତନାଯୋତ୍ଥାପନାଯ ଚ ତଥା ୱିରୋଧପାତ୍ରଂ ଭୱିତୁଂ, ବହୂନାଂ ଗୁପ୍ତମନୋଗତାନାଂ ପ୍ରକଟୀକରଣାଯ ବାଲକୋଯଂ ନିଯୁକ୍ତୋସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ତସ୍ମାତ୍ ତୱାପି ପ୍ରାଣାଃ ଶୂଲେନ ୱ୍ୟତ୍ସ୍ୟନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","ଅପରଞ୍ଚ ଆଶେରସ୍ୟ ୱଂଶୀଯଫିନୂଯେଲୋ ଦୁହିତା ହନ୍ନାଖ୍ୟା ଅତିଜରତୀ ଭୱିଷ୍ୟଦ୍ୱାଦିନ୍ୟେକା ଯା ୱିୱାହାତ୍ ପରଂ ସପ୍ତ ୱତ୍ସରାନ୍ ପତ୍ୟା ସହ ନ୍ୟୱସତ୍ ତତୋ ୱିଧୱା ଭୂତ୍ୱା ଚତୁରଶୀତିୱର୍ଷୱଯଃପର୍ୟ୍ୟନତଂ ");
INSERT INTO sanori_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ମନ୍ଦିରେ ସ୍ଥିତ୍ୱା ପ୍ରାର୍ଥନୋପୱାସୈର୍ଦିୱାନିଶମ୍ ଈଶ୍ୱରମ୍ ଅସେୱତ ସାପି ସ୍ତ୍ରୀ ତସ୍ମିନ୍ ସମଯେ ମନ୍ଦିରମାଗତ୍ୟ ");
INSERT INTO sanori_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","ପରମେଶ୍ୱରସ୍ୟ ଧନ୍ୟୱାଦଂ ଚକାର, ଯିରୂଶାଲମ୍ପୁରୱାସିନୋ ଯାୱନ୍ତୋ ଲୋକା ମୁକ୍ତିମପେକ୍ଷ୍ୟ ସ୍ଥିତାସ୍ତାନ୍ ଯୀଶୋର୍ୱୃତ୍ତାନ୍ତଂ ଜ୍ଞାପଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ଇତ୍ଥଂ ପରମେଶ୍ୱରସ୍ୟ ୱ୍ୟୱସ୍ଥାନୁସାରେଣ ସର୍ୱ୍ୱେଷୁ କର୍ମ୍ମସୁ କୃତେଷୁ ତୌ ପୁନଶ୍ଚ ଗାଲୀଲୋ ନାସରତ୍ନାମକଂ ନିଜନଗରଂ ପ୍ରତସ୍ଥାତେ| ");
INSERT INTO sanori_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","ତତ୍ପଶ୍ଚାଦ୍ ବାଲକଃ ଶରୀରେଣ ୱୃଦ୍ଧିମେତ୍ୟ ଜ୍ଞାନେନ ପରିପୂର୍ଣ ଆତ୍ମନା ଶକ୍ତିମାଂଶ୍ଚ ଭୱିତୁମାରେଭେ ତଥା ତସ୍ମିନ୍ ଈଶ୍ୱରାନୁଗ୍ରହୋ ବଭୂୱ| ");
INSERT INTO sanori_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","ତସ୍ୟ ପିତା ମାତା ଚ ପ୍ରତିୱର୍ଷଂ ନିସ୍ତାରୋତ୍ସୱସମଯେ ଯିରୂଶାଲମମ୍ ଅଗଚ୍ଛତାମ୍| ");
INSERT INTO sanori_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","ଅପରଞ୍ଚ ଯୀଶୌ ଦ୍ୱାଦଶୱର୍ଷୱଯସ୍କେ ସତି ତୌ ପର୍ୱ୍ୱସମଯସ୍ୟ ରୀତ୍ୟନୁସାରେଣ ଯିରୂଶାଲମଂ ଗତ୍ୱା ");
INSERT INTO sanori_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ପାର୍ୱ୍ୱଣଂ ସମ୍ପାଦ୍ୟ ପୁନରପି ୱ୍ୟାଘୁଯ୍ୟ ଯାତଃ କିନ୍ତୁ ଯୀଶୁର୍ବାଲକୋ ଯିରୂଶାଲମି ତିଷ୍ଠତି| ଯୂଷଫ୍ ତନ୍ମାତା ଚ ତଦ୍ ଅୱିଦିତ୍ୱା ");
INSERT INTO sanori_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ସ ସଙ୍ଗିଭିଃ ସହ ୱିଦ୍ୟତ ଏତଚ୍ଚ ବୁଦ୍ୱ୍ୱା ଦିନୈକଗମ୍ୟମାର୍ଗଂ ଜଗ୍ମତୁଃ| କିନ୍ତୁ ଶେଷେ ଜ୍ଞାତିବନ୍ଧୂନାଂ ସମୀପେ ମୃଗଯିତ୍ୱା ତଦୁଦ୍ଦେेଶମପ୍ରାପ୍ୟ ");
INSERT INTO sanori_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ତୌ ପୁନରପି ଯିରୂଶାଲମମ୍ ପରାୱୃତ୍ୟାଗତ୍ୟ ତଂ ମୃଗଯାଞ୍ଚକ୍ରତୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ଅଥ ଦିନତ୍ରଯାତ୍ ପରଂ ପଣ୍ଡିତାନାଂ ମଧ୍ୟେ ତେଷାଂ କଥାଃ ଶୃଣ୍ୱନ୍ ତତ୍ତ୍ୱଂ ପୃଚ୍ଛଂଶ୍ଚ ମନ୍ଦିରେ ସମୁପୱିଷ୍ଟଃ ସ ତାଭ୍ୟାଂ ଦୃଷ୍ଟଃ| ");
INSERT INTO sanori_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ତଦା ତସ୍ୟ ବୁଦ୍ଧ୍ୟା ପ୍ରତ୍ୟୁତ୍ତରୈଶ୍ଚ ସର୍ୱ୍ୱେ ଶ୍ରୋତାରୋ ୱିସ୍ମଯମାପଦ୍ୟନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ତାଦୃଶଂ ଦୃଷ୍ଟ୍ୱା ତସ୍ୟ ଜନକୋ ଜନନୀ ଚ ଚମଚ୍ଚକ୍ରତୁଃ କିଞ୍ଚ ତସ୍ୟ ମାତା ତମୱଦତ୍, ହେ ପୁତ୍ର, କଥମାୱାଂ ପ୍ରତୀତ୍ଥଂ ସମାଚରସ୍ତ୍ୱମ୍? ପଶ୍ୟ ତୱ ପିତାହଞ୍ଚ ଶୋକାକୁଲୌ ସନ୍ତୌ ତ୍ୱାମନ୍ୱିଚ୍ଛାୱଃ ସ୍ମ| ");
INSERT INTO sanori_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ତତଃ ସୋୱଦତ୍ କୁତୋ ମାମ୍ ଅନ୍ୱୈଚ୍ଛତଂ? ପିତୁର୍ଗୃହେ ମଯା ସ୍ଥାତୱ୍ୟମ୍ ଏତତ୍ କିଂ ଯୁୱାଭ୍ୟାଂ ନ ଜ୍ଞାଯତେ? ");
INSERT INTO sanori_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","କିନ୍ତୁ ତୌ ତସ୍ୟୈତଦ୍ୱାକ୍ୟସ୍ୟ ତାତ୍ପର୍ୟ୍ୟଂ ବୋଦ୍ଧୁଂ ନାଶକ୍ନୁତାଂ| ");
INSERT INTO sanori_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ତତଃ ପରଂ ସ ତାଭ୍ୟାଂ ସହ ନାସରତଂ ଗତ୍ୱା ତଯୋର୍ୱଶୀଭୂତସ୍ତସ୍ଥୌ କିନ୍ତୁ ସର୍ୱ୍ୱା ଏତାଃ କଥାସ୍ତସ୍ୟ ମାତା ମନସି ସ୍ଥାପଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","ଅଥ ଯୀଶୋ ର୍ବୁଦ୍ଧିଃ ଶରୀରଞ୍ଚ ତଥା ତସ୍ମିନ୍ ଈଶ୍ୱରସ୍ୟ ମାନୱାନାଞ୍ଚାନୁଗ୍ରହୋ ୱର୍ଦ୍ଧିତୁମ୍ ଆରେଭେ| ");
INSERT INTO sanori_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","ଅନନ୍ତରଂ ତିବିରିଯକୈସରସ୍ୟ ରାଜତ୍ୱସ୍ୟ ପଞ୍ଚଦଶେ ୱତ୍ସରେ ସତି ଯଦା ପନ୍ତୀଯପୀଲାତୋ ଯିହୂଦାଦେଶାଧିପତି ର୍ହେରୋଦ୍ ତୁ ଗାଲୀଲ୍ପ୍ରଦେଶସ୍ୟ ରାଜା ଫିଲିପନାମା ତସ୍ୟ ଭ୍ରାତା ତୁ ଯିତୂରିଯାଯାସ୍ତ୍ରାଖୋନୀତିଯାପ୍ରଦେଶସ୍ୟ ଚ ରାଜାସୀତ୍ ଲୁଷାନୀଯନାମା ଅୱିଲୀନୀଦେଶସ୍ୟ ରାଜାସୀତ୍ ");
INSERT INTO sanori_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ହାନନ୍ କିଯଫାଶ୍ଚେମୌ ପ୍ରଧାନଯାଜାକାୱାସ୍ତାଂ ତଦାନୀଂ ସିଖରିଯସ୍ୟ ପୁତ୍ରାଯ ଯୋହନେ ମଧ୍ୟେପ୍ରାନ୍ତରମ୍ ଈଶ୍ୱରସ୍ୟ ୱାକ୍ୟେ ପ୍ରକାଶିତେ ସତି ");
INSERT INTO sanori_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ସ ଯର୍ଦ୍ଦନ ଉଭଯତଟପ୍ରଦେଶାନ୍ ସମେତ୍ୟ ପାପମୋଚନାର୍ଥଂ ମନଃପରାୱର୍ତ୍ତନସ୍ୟ ଚିହ୍ନରୂପଂ ଯନ୍ମଜ୍ଜନଂ ତଦୀଯାଃ କଥାଃ ସର୍ୱ୍ୱତ୍ର ପ୍ରଚାରଯିତୁମାରେଭେ| ");
INSERT INTO sanori_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ଯିଶଯିଯଭୱିଷ୍ୟଦ୍ୱକ୍ତୃଗ୍ରନ୍ଥେ ଯାଦୃଶୀ ଲିପିରାସ୍ତେ ଯଥା, ପରମେଶସ୍ୟ ପନ୍ଥାନଂ ପରିଷ୍କୁରୁତ ସର୍ୱ୍ୱତଃ| ତସ୍ୟ ରାଜପଥଞ୍ଚୈୱ ସମାନଂ କୁରୁତାଧୁନା| ");
INSERT INTO sanori_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","କାରିଷ୍ୟନ୍ତେ ସମୁଚ୍ଛ୍ରାଯାଃ ସକଲା ନିମ୍ନଭୂମଯଃ| କାରିଷ୍ୟନ୍ତେ ନତାଃ ସର୍ୱ୍ୱେ ପର୍ୱ୍ୱତାଶ୍ଚୋପପର୍ୱ୍ୱତାଃ| କାରିଷ୍ୟନ୍ତେ ଚ ଯା ୱକ୍ରାସ୍ତାଃ ସର୍ୱ୍ୱାଃ ସରଲା ଭୁୱଃ| କାରିଷ୍ୟନ୍ତେ ସମାନାସ୍ତା ଯା ଉଚ୍ଚନୀଚଭୂମଯଃ| ");
INSERT INTO sanori_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ଈଶ୍ୱରେଣ କୃତଂ ତ୍ରାଣଂ ଦ୍ରକ୍ଷ୍ୟନ୍ତି ସର୍ୱ୍ୱମାନୱାଃ| ଇତ୍ୟେତତ୍ ପ୍ରାନ୍ତରେ ୱାକ୍ୟଂ ୱଦତଃ କସ୍ୟଚିଦ୍ ରୱଃ|| ");
INSERT INTO sanori_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ଯେ ଯେ ଲୋକା ମଜ୍ଜନାର୍ଥଂ ବହିରାଯଯୁସ୍ତାନ୍ ସୋୱଦତ୍ ରେ ରେ ସର୍ପୱଂଶା ଆଗାମିନଃ କୋପାତ୍ ପଲାଯିତୁଂ ଯୁଷ୍ମାନ୍ କଶ୍ଚେତଯାମାସ? ");
INSERT INTO sanori_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","ତସ୍ମାଦ୍ ଇବ୍ରାହୀମ୍ ଅସ୍ମାକଂ ପିତା କଥାମୀଦୃଶୀଂ ମନୋଭି ର୍ନ କଥଯିତ୍ୱା ଯୂଯଂ ମନଃପରିୱର୍ତ୍ତନଯୋଗ୍ୟଂ ଫଲଂ ଫଲତ; ଯୁଷ୍ମାନହଂ ଯଥାର୍ଥଂ ୱଦାମି ପାଷାଣେଭ୍ୟ ଏତେଭ୍ୟ ଈଶ୍ୱର ଇବ୍ରାହୀମଃ ସନ୍ତାନୋତ୍ପାଦନେ ସମର୍ଥଃ| ");
INSERT INTO sanori_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ଅପରଞ୍ଚ ତରୁମୂଲେଽଧୁନାପି ପରଶୁଃ ସଂଲଗ୍ନୋସ୍ତି ଯସ୍ତରୁରୁତ୍ତମଂ ଫଲଂ ନ ଫଲତି ସ ଛିଦ୍ୟତେଽଗ୍ନୌ ନିକ୍ଷିପ୍ୟତେ ଚ| ");
INSERT INTO sanori_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","ତଦାନୀଂ ଲୋକାସ୍ତଂ ପପ୍ରଚ୍ଛୁସ୍ତର୍ହି କିଂ କର୍ତ୍ତୱ୍ୟମସ୍ମାଭିଃ? ");
INSERT INTO sanori_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ତତଃ ସୋୱାଦୀତ୍ ଯସ୍ୟ ଦ୍ୱେ ୱସନେ ୱିଦ୍ୟେତେ ସ ୱସ୍ତ୍ରହୀନାଯୈକଂ ୱିତରତୁ କିଂଞ୍ଚ ଯସ୍ୟ ଖାଦ୍ୟଦ୍ରୱ୍ୟଂ ୱିଦ୍ୟତେ ସୋପି ତଥୈୱ କରୋତୁ| ");
INSERT INTO sanori_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ତତଃ ପରଂ କରସଞ୍ଚାଯିନୋ ମଜ୍ଜନାର୍ଥମ୍ ଆଗତ୍ୟ ପପ୍ରଚ୍ଛୁଃ ହେ ଗୁରୋ କିଂ କର୍ତ୍ତୱ୍ୟମସ୍ମାଭିଃ? ");
INSERT INTO sanori_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ତତଃ ସୋକଥଯତ୍ ନିରୂପିତାଦଧିକଂ ନ ଗୃହ୍ଲିତ| ");
INSERT INTO sanori_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","ଅନନ୍ତରଂ ସେନାଗଣ ଏତ୍ୟ ପପ୍ରଚ୍ଛ କିମସ୍ମାଭି ର୍ୱା କର୍ତ୍ତୱ୍ୟମ୍? ତତଃ ସୋଭିଦଧେ କସ୍ୟ କାମପି ହାନିଂ ମା କାର୍ଷ୍ଟ ତଥା ମୃଷାପୱାଦଂ ମା କୁରୁତ ନିଜୱେତନେନ ଚ ସନ୍ତୁଷ୍ୟ ତିଷ୍ଠତ| ");
INSERT INTO sanori_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","ଅପରଞ୍ଚ ଲୋକା ଅପେକ୍ଷଯା ସ୍ଥିତ୍ୱା ସର୍ୱ୍ୱେପୀତି ମନୋଭି ର୍ୱିତର୍କଯାଞ୍ଚକ୍ରୁଃ, ଯୋହନଯମ୍ ଅଭିଷିକ୍ତସ୍ତ୍ରାତା ନ ୱେତି? ");
INSERT INTO sanori_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ତଦା ଯୋହନ୍ ସର୍ୱ୍ୱାନ୍ ୱ୍ୟାଜହାର, ଜଲେଽହଂ ଯୁଷ୍ମାନ୍ ମଜ୍ଜଯାମି ସତ୍ୟଂ କିନ୍ତୁ ଯସ୍ୟ ପାଦୁକାବନ୍ଧନଂ ମୋଚଯିତୁମପି ନ ଯୋଗ୍ୟୋସ୍ମି ତାଦୃଶ ଏକୋ ମତ୍ତୋ ଗୁରୁତରଃ ପୁମାନ୍ ଏତି, ସ ଯୁଷ୍ମାନ୍ ୱହ୍ନିରୂପେ ପୱିତ୍ର ଆତ୍ମନି ମଜ୍ଜଯିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ଅପରଞ୍ଚ ତସ୍ୟ ହସ୍ତେ ଶୂର୍ପ ଆସ୍ତେ ସ ସ୍ୱଶସ୍ୟାନି ଶୁଦ୍ଧରୂପଂ ପ୍ରସ୍ଫୋଟ୍ୟ ଗୋଧୂମାନ୍ ସର୍ୱ୍ୱାନ୍ ଭାଣ୍ଡାଗାରେ ସଂଗ୍ରହୀଷ୍ୟତି କିନ୍ତୁ ବୂଷାଣି ସର୍ୱ୍ୱାଣ୍ୟନିର୍ୱ୍ୱାଣୱହ୍ନିନା ଦାହଯିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ଯୋହନ୍ ଉପଦେଶେନେତ୍ଥଂ ନାନାକଥା ଲୋକାନାଂ ସମକ୍ଷଂ ପ୍ରଚାରଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ଅପରଞ୍ଚ ହେରୋଦ୍ ରାଜା ଫିଲିପ୍ନାମ୍ନଃ ସହୋଦରସ୍ୟ ଭାର୍ୟ୍ୟାଂ ହେରୋଦିଯାମଧି ତଥାନ୍ୟାନି ଯାନି ଯାନି କୁକର୍ମ୍ମାଣି କୃତୱାନ୍ ତଦଧି ଚ ");
INSERT INTO sanori_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ଯୋହନା ତିରସ୍କୃତୋ ଭୂତ୍ୱା କାରାଗାରେ ତସ୍ୟ ବନ୍ଧନାଦ୍ ଅପରମପି କୁକର୍ମ୍ମ ଚକାର| ");
INSERT INTO sanori_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ଇତଃ ପୂର୍ୱ୍ୱଂ ଯସ୍ମିନ୍ ସମଯେ ସର୍ୱ୍ୱେ ଯୋହନା ମଜ୍ଜିତାସ୍ତଦାନୀଂ ଯୀଶୁରପ୍ୟାଗତ୍ୟ ମଜ୍ଜିତଃ| ");
INSERT INTO sanori_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ତଦନନ୍ତରଂ ତେନ ପ୍ରାର୍ଥିତେ ମେଘଦ୍ୱାରଂ ମୁକ୍ତଂ ତସ୍ମାଚ୍ଚ ପୱିତ୍ର ଆତ୍ମା ମୂର୍ତ୍ତିମାନ୍ ଭୂତ୍ୱା କପୋତୱତ୍ ତଦୁପର୍ୟ୍ୟୱରୁରୋହ; ତଦା ତ୍ୱଂ ମମ ପ୍ରିଯଃ ପୁତ୍ରସ୍ତ୍ୱଯି ମମ ପରମଃ ସନ୍ତୋଷ ଇତ୍ୟାକାଶୱାଣୀ ବଭୂୱ| ");
INSERT INTO sanori_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","ତଦାନୀଂ ଯୀଶୁଃ ପ୍ରାଯେଣ ତ୍ରିଂଶଦ୍ୱର୍ଷୱଯସ୍କ ଆସୀତ୍| ଲୌକିକଜ୍ଞାନେ ତୁ ସ ଯୂଷଫଃ ପୁତ୍ରଃ, ");
INSERT INTO sanori_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ଯୂଷଫ୍ ଏଲେଃ ପୁତ୍ରଃ, ଏଲିର୍ମତ୍ତତଃ ପୁତ୍ରଃ, ମତ୍ତତ୍ ଲେୱେଃ ପୁତ୍ରଃ, ଲେୱି ର୍ମଲ୍କେଃ ପୁତ୍ରଃ, ମଲ୍କିର୍ୟାନ୍ନସ୍ୟ ପୁତ୍ରଃ; ଯାନ୍ନୋ ଯୂଷଫଃ ପୁତ୍ରଃ| ");
INSERT INTO sanori_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ଯୂଷଫ୍ ମତ୍ତଥିଯସ୍ୟ ପୁତ୍ରଃ, ମତ୍ତଥିଯ ଆମୋସଃ ପୁତ୍ରଃ, ଆମୋସ୍ ନହୂମଃ ପୁତ୍ରଃ, ନହୂମ୍ ଇଷ୍ଲେଃ ପୁତ୍ରଃ ଇଷ୍ଲିର୍ନଗେଃ ପୁତ୍ରଃ| ");
INSERT INTO sanori_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ନଗିର୍ମାଟଃ ପୁତ୍ରଃ, ମାଟ୍ ମତ୍ତଥିଯସ୍ୟ ପୁତ୍ରଃ, ମତ୍ତଥିଯଃ ଶିମିଯେଃ ପୁତ୍ରଃ, ଶିମିଯିର୍ୟୂଷଫଃ ପୁତ୍ରଃ, ଯୂଷଫ୍ ଯିହୂଦାଃ ପୁତ୍ରଃ| ");
INSERT INTO sanori_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ଯିହୂଦା ଯୋହାନାଃ ପୁତ୍ରଃ, ଯୋହାନା ରୀଷାଃ ପୁତ୍ରଃ, ରୀଷାଃ ସିରୁବ୍ବାବିଲଃ ପୁତ୍ରଃ, ସିରୁବ୍ବାବିଲ୍ ଶଲ୍ତୀଯେଲଃ ପୁତ୍ରଃ, ଶଲ୍ତୀଯେଲ୍ ନେରେଃ ପୁତ୍ରଃ| ");
INSERT INTO sanori_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ନେରିର୍ମଲ୍କେଃ ପୁତ୍ରଃ, ମଲ୍କିଃ ଅଦ୍ୟଃ ପୁତ୍ରଃ, ଅଦ୍ଦୀ କୋଷମଃ ପୁତ୍ରଃ, କୋଷମ୍ ଇଲ୍ମୋଦଦଃ ପୁତ୍ରଃ, ଇଲ୍ମୋଦଦ୍ ଏରଃ ପୁତ୍ରଃ| ");
INSERT INTO sanori_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ଏର୍ ଯୋଶେଃ ପୁତ୍ରଃ, ଯୋଶିଃ ଇଲୀଯେଷରଃ ପୁତ୍ରଃ, ଇଲୀଯେଷର୍ ଯୋରୀମଃ ପୁତ୍ରଃ, ଯୋରୀମ୍ ମତ୍ତତଃ ପୁତ୍ରଃ, ମତ୍ତତ ଲେୱେଃ ପୁତ୍ରଃ| ");
INSERT INTO sanori_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ଲେୱିଃ ଶିମିଯୋନଃ ପୁତ୍ରଃ, ଶିମିଯୋନ୍ ଯିହୂଦାଃ ପୁତ୍ରଃ, ଯିହୂଦା ଯୂଷୁଫଃ ପୁତ୍ରଃ, ଯୂଷୁଫ୍ ଯୋନନଃ ପୁତ୍ରଃ, ଯାନନ୍ ଇଲୀଯାକୀମଃ ପୁତ୍ରଃ| ");
INSERT INTO sanori_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ଇଲିଯାକୀମ୍ଃ ମିଲେଯାଃ ପୁତ୍ରଃ, ମିଲେଯା ମୈନନଃ ପୁତ୍ରଃ, ମୈନନ୍ ମତ୍ତତ୍ତସ୍ୟ ପୁତ୍ରଃ, ମତ୍ତତ୍ତୋ ନାଥନଃ ପୁତ୍ରଃ, ନାଥନ୍ ଦାଯୂଦଃ ପୁତ୍ରଃ| ");
INSERT INTO sanori_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ଦାଯୂଦ୍ ଯିଶଯଃ ପୁତ୍ରଃ, ଯିଶଯ ଓବେଦଃ ପୁତ୍ର, ଓବେଦ୍ ବୋଯସଃ ପୁତ୍ରଃ, ବୋଯସ୍ ସଲ୍ମୋନଃ ପୁତ୍ରଃ, ସଲ୍ମୋନ୍ ନହଶୋନଃ ପୁତ୍ରଃ| ");
INSERT INTO sanori_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ନହଶୋନ୍ ଅମ୍ମୀନାଦବଃ ପୁତ୍ରଃ, ଅମ୍ମୀନାଦବ୍ ଅରାମଃ ପୁତ୍ରଃ, ଅରାମ୍ ହିଷ୍ରୋଣଃ ପୁତ୍ରଃ, ହିଷ୍ରୋଣ୍ ପେରସଃ ପୁତ୍ରଃ, ପେରସ୍ ଯିହୂଦାଃ ପୁତ୍ରଃ| ");
INSERT INTO sanori_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ଯିହୂଦା ଯାକୂବଃ ପୁତ୍ରଃ, ଯାକୂବ୍ ଇସ୍ହାକଃ ପୁତ୍ରଃ, ଇସ୍ହାକ୍ ଇବ୍ରାହୀମଃ ପୁତ୍ରଃ, ଇବ୍ରାହୀମ୍ ତେରହଃ ପୁତ୍ରଃ, ତେରହ୍ ନାହୋରଃ ପୁତ୍ରଃ| ");
INSERT INTO sanori_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ନାହୋର୍ ସିରୁଗଃ ପୁତ୍ରଃ, ସିରୁଗ୍ ରିଯ୍ୱଃ ପୁତ୍ରଃ, ରିଯୂଃ ପେଲଗଃ ପୁତ୍ରଃ, ପେଲଗ୍ ଏୱରଃ ପୁତ୍ରଃ, ଏୱର୍ ଶେଲହଃ ପୁତ୍ରଃ| ");
INSERT INTO sanori_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ଶେଲହ୍ କୈନନଃ ପୁତ୍ରଃ, କୈନନ୍ ଅର୍ଫକ୍ଷଦଃ ପୁତ୍ରଃ, ଅର୍ଫକ୍ଷଦ୍ ଶାମଃ ପୁତ୍ରଃ, ଶାମ୍ ନୋହଃ ପୁତ୍ରଃ, ନୋହୋ ଲେମକଃ ପୁତ୍ରଃ| ");
INSERT INTO sanori_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ଲେମକ୍ ମିଥୂଶେଲହଃ ପୁତ୍ରଃ, ମିଥୂଶେଲହ୍ ହନୋକଃ ପୁତ୍ରଃ, ହନୋକ୍ ଯେରଦଃ ପୁତ୍ରଃ, ଯେରଦ୍ ମହଲଲେଲଃ ପୁତ୍ରଃ, ମହଲଲେଲ୍ କୈନନଃ ପୁତ୍ରଃ| ");
INSERT INTO sanori_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","କୈନନ୍ ଇନୋଶଃ ପୁତ୍ରଃ, ଇନୋଶ୍ ଶେତଃ ପୁତ୍ରଃ, ଶେତ୍ ଆଦମଃ ପୁତ୍ର, ଆଦମ୍ ଈଶ୍ୱରସ୍ୟ ପୁତ୍ରଃ| ");
INSERT INTO sanori_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ତତଃ ପରଂ ଯୀଶୁଃ ପୱିତ୍ରେଣାତ୍ମନା ପୂର୍ଣଃ ସନ୍ ଯର୍ଦ୍ଦନନଦ୍ୟାଃ ପରାୱୃତ୍ୟାତ୍ମନା ପ୍ରାନ୍ତରଂ ନୀତଃ ସନ୍ ଚତ୍ୱାରିଂଶଦ୍ଦିନାନି ଯାୱତ୍ ଶୈତାନା ପରୀକ୍ଷିତୋଽଭୂତ୍, ");
INSERT INTO sanori_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","କିଞ୍ଚ ତାନି ସର୍ୱ୍ୱଦିନାନି ଭୋଜନଂ ୱିନା ସ୍ଥିତତ୍ୱାତ୍ କାଲେ ପୂର୍ଣେ ସ କ୍ଷୁଧିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ତତଃ ଶୈତାନାଗତ୍ୟ ତମୱଦତ୍ ତ୍ୱଂ ଚେଦୀଶ୍ୱରସ୍ୟ ପୁତ୍ରସ୍ତର୍ହି ପ୍ରସ୍ତରାନେତାନ୍ ଆଜ୍ଞଯା ପୂପାନ୍ କୁରୁ| ");
INSERT INTO sanori_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","ତଦା ଯୀଶୁରୁୱାଚ, ଲିପିରୀଦୃଶୀ ୱିଦ୍ୟତେ ମନୁଜଃ କେୱଲେନ ପୂପେନ ନ ଜୀୱତି କିନ୍ତ୍ୱୀଶ୍ୱରସ୍ୟ ସର୍ୱ୍ୱାଭିରାଜ୍ଞାଭି ର୍ଜୀୱତି| ");
INSERT INTO sanori_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ତଦା ଶୈତାନ୍ ତମୁଚ୍ଚଂ ପର୍ୱ୍ୱତଂ ନୀତ୍ୱା ନିମିଷୈକମଧ୍ୟେ ଜଗତଃ ସର୍ୱ୍ୱରାଜ୍ୟାନି ଦର୍ଶିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ପଶ୍ଚାତ୍ ତମୱାଦୀତ୍ ସର୍ୱ୍ୱମ୍ ଏତଦ୍ ୱିଭୱଂ ପ୍ରତାପଞ୍ଚ ତୁଭ୍ୟଂ ଦାସ୍ୟାମି ତନ୍ ମଯି ସମର୍ପିତମାସ୍ତେ ଯଂ ପ୍ରତି ମମେଚ୍ଛା ଜାଯତେ ତସ୍ମୈ ଦାତୁଂ ଶକ୍ନୋମି, ");
INSERT INTO sanori_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ତ୍ୱଂ ଚେନ୍ମାଂ ଭଜସେ ତର୍ହି ସର୍ୱ୍ୱମେତତ୍ ତୱୈୱ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","ତଦା ଯୀଶୁସ୍ତଂ ପ୍ରତ୍ୟୁକ୍ତୱାନ୍ ଦୂରୀ ଭୱ ଶୈତାନ୍ ଲିପିରାସ୍ତେ, ନିଜଂ ପ୍ରଭୁଂ ପରମେଶ୍ୱରଂ ଭଜସ୍ୱ କେୱଲଂ ତମେୱ ସେୱସ୍ୱ ଚ| ");
INSERT INTO sanori_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ଅଥ ଶୈତାନ୍ ତଂ ଯିରୂଶାଲମଂ ନୀତ୍ୱା ମନ୍ଦିରସ୍ୟ ଚୂଡାଯା ଉପରି ସମୁପୱେଶ୍ୟ ଜଗାଦ ତ୍ୱଂ ଚେଦୀଶ୍ୱରସ୍ୟ ପୁତ୍ରସ୍ତର୍ହି ସ୍ଥାନାଦିତୋ ଲମ୍ଫିତ୍ୱାଧଃ ");
INSERT INTO sanori_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ପତ ଯତୋ ଲିପିରାସ୍ତେ, ଆଜ୍ଞାପଯିଷ୍ୟତି ସ୍ୱୀଯାନ୍ ଦୂତାନ୍ ସ ପରମେଶ୍ୱରଃ| ");
INSERT INTO sanori_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ରକ୍ଷିତୁଂ ସର୍ୱ୍ୱମାର୍ଗେ ତ୍ୱାଂ ତେନ ତ୍ୱଚ୍ଚରଣେ ଯଥା| ନ ଲଗେତ୍ ପ୍ରସ୍ତରାଘାତସ୍ତ୍ୱାଂ ଧରିଷ୍ୟନ୍ତି ତେ ତଥା| ");
INSERT INTO sanori_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","ତଦା ଯୀଶୁନା ପ୍ରତ୍ୟୁକ୍ତମ୍ ଇଦମପ୍ୟୁକ୍ତମସ୍ତି ତ୍ୱଂ ସ୍ୱପ୍ରଭୁଂ ପରେଶଂ ମା ପରୀକ୍ଷସ୍ୱ| ");
INSERT INTO sanori_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","ପଶ୍ଚାତ୍ ଶୈତାନ୍ ସର୍ୱ୍ୱପରୀକ୍ଷାଂ ସମାପ୍ୟ କ୍ଷଣାତ୍ତଂ ତ୍ୟକ୍ତ୍ୱା ଯଯୌ| ");
INSERT INTO sanori_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","ତଦା ଯୀଶୁରାତ୍ମପ୍ରଭାୱାତ୍ ପୁନର୍ଗାଲୀଲ୍ପ୍ରଦେଶଂ ଗତସ୍ତଦା ତତ୍ସୁଖ୍ୟାତିଶ୍ଚତୁର୍ଦିଶଂ ୱ୍ୟାନଶେ| ");
INSERT INTO sanori_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ସ ତେଷାଂ ଭଜନଗୃହେଷୁ ଉପଦିଶ୍ୟ ସର୍ୱ୍ୱୈଃ ପ୍ରଶଂସିତୋ ବଭୂୱ| ");
INSERT INTO sanori_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","ଅଥ ସ ସ୍ୱପାଲନସ୍ଥାନଂ ନାସରତ୍ପୁରମେତ୍ୟ ୱିଶ୍ରାମୱାରେ ସ୍ୱାଚାରାଦ୍ ଭଜନଗେହଂ ପ୍ରୱିଶ୍ୟ ପଠିତୁମୁତ୍ତସ୍ଥୌ| ");
INSERT INTO sanori_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ତତୋ ଯିଶଯିଯଭୱିଷ୍ୟଦ୍ୱାଦିନଃ ପୁସ୍ତକେ ତସ୍ୟ କରଦତ୍ତେ ସତି ସ ତତ୍ ପୁସ୍ତକଂ ୱିସ୍ତାର୍ୟ୍ୟ ଯତ୍ର ୱକ୍ଷ୍ୟମାଣାନି ୱଚନାନି ସନ୍ତି ତତ୍ ସ୍ଥାନଂ ପ୍ରାପ୍ୟ ପପାଠ| ");
INSERT INTO sanori_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","ଆତ୍ମା ତୁ ପରମେଶସ୍ୟ ମଦୀଯୋପରି ୱିଦ୍ୟତେ| ଦରିଦ୍ରେଷୁ ସୁସଂୱାଦଂ ୱକ୍ତୁଂ ମାଂ ସୋଭିଷିକ୍ତୱାନ୍| ଭଗ୍ନାନ୍ତଃ କରଣାଲ୍ଲୋକାନ୍ ସୁସ୍ୱସ୍ଥାନ୍ କର୍ତ୍ତୁମେୱ ଚ| ବନ୍ଦୀକୃତେଷୁ ଲୋକେଷୁ ମୁକ୍ତେ ର୍ଘୋଷଯିତୁଂ ୱଚଃ| ନେତ୍ରାଣି ଦାତୁମନ୍ଧେଭ୍ୟସ୍ତ୍ରାତୁଂ ବଦ୍ଧଜନାନପି| ");
INSERT INTO sanori_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ପରେଶାନୁଗ୍ରହେ କାଲଂ ପ୍ରଚାରଯିତୁମେୱ ଚ| ସର୍ୱ୍ୱୈତତ୍କରଣାର୍ଥାଯ ମାମେୱ ପ୍ରହିଣୋତି ସଃ|| ");
INSERT INTO sanori_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ତତଃ ପୁସ୍ତକଂ ବଦ୍ୱ୍ୱା ପରିଚାରକସ୍ୟ ହସ୍ତେ ସମର୍ପ୍ୟ ଚାସନେ ସମୁପୱିଷ୍ଟଃ, ତତୋ ଭଜନଗୃହେ ଯାୱନ୍ତୋ ଲୋକା ଆସନ୍ ତେ ସର୍ୱ୍ୱେଽନନ୍ୟଦୃଷ୍ଟ୍ୟା ତଂ ୱିଲୁଲୋକିରେ| ");
INSERT INTO sanori_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ଅନନ୍ତରମ୍ ଅଦ୍ୟୈତାନି ସର୍ୱ୍ୱାଣି ଲିଖିତୱଚନାନି ଯୁଷ୍ମାକଂ ମଧ୍ୟେ ସିଦ୍ଧାନି ସ ଇମାଂ କଥାଂ ତେଭ୍ୟଃ କଥଯିତୁମାରେଭେ| ");
INSERT INTO sanori_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ତତଃ ସର୍ୱ୍ୱେ ତସ୍ମିନ୍ ଅନ୍ୱରଜ୍ୟନ୍ତ, କିଞ୍ଚ ତସ୍ୟ ମୁଖାନ୍ନିର୍ଗତାଭିରନୁଗ୍ରହସ୍ୟ କଥାଭିଶ୍ଚମତ୍କୃତ୍ୟ କଥଯାମାସୁଃ କିମଯଂ ଯୂଷଫଃ ପୁତ୍ରୋ ନ? ");
INSERT INTO sanori_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ତଦା ସୋଽୱାଦୀଦ୍ ହେ ଚିକିତ୍ସକ ସ୍ୱମେୱ ସ୍ୱସ୍ଥଂ କୁରୁ କଫର୍ନାହୂମି ଯଦ୍ୟତ୍ କୃତୱାନ୍ ତଦଶ୍ରୌଷ୍ମ ତାଃ ସର୍ୱାଃ କ୍ରିଯା ଅତ୍ର ସ୍ୱଦେଶେ କୁରୁ କଥାମେତାଂ ଯୂଯମେୱାୱଶ୍ୟଂ ମାଂ ୱଦିଷ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ପୁନଃ ସୋୱାଦୀଦ୍ ଯୁଷ୍ମାନହଂ ଯଥାର୍ଥଂ ୱଦାମି, କୋପି ଭୱିଷ୍ୟଦ୍ୱାଦୀ ସ୍ୱଦେଶେ ସତ୍କାରଂ ନ ପ୍ରାପ୍ନୋତି| ");
INSERT INTO sanori_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","ଅପରଞ୍ଚ ଯଥାର୍ଥଂ ୱଚ୍ମି, ଏଲିଯସ୍ୟ ଜୀୱନକାଲେ ଯଦା ସାର୍ଦ୍ଧତ୍ରିତଯୱର୍ଷାଣି ଯାୱତ୍ ଜଲଦପ୍ରତିବନ୍ଧାତ୍ ସର୍ୱ୍ୱସ୍ମିନ୍ ଦେଶେ ମହାଦୁର୍ଭିକ୍ଷମ୍ ଅଜନିଷ୍ଟ ତଦାନୀମ୍ ଇସ୍ରାଯେଲୋ ଦେଶସ୍ୟ ମଧ୍ୟେ ବହ୍ୱ୍ୟୋ ୱିଧୱା ଆସନ୍, ");
INSERT INTO sanori_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","କିନ୍ତୁ ସୀଦୋନ୍ପ୍ରଦେଶୀଯସାରିଫତ୍ପୁରନିୱାସିନୀମ୍ ଏକାଂ ୱିଧୱାଂ ୱିନା କସ୍ୟାଶ୍ଚିଦପି ସମୀପେ ଏଲିଯଃ ପ୍ରେରିତୋ ନାଭୂତ୍| ");
INSERT INTO sanori_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","ଅପରଞ୍ଚ ଇଲୀଶାଯଭୱିଷ୍ୟଦ୍ୱାଦିୱିଦ୍ୟମାନତାକାଲେ ଇସ୍ରାଯେଲ୍ଦେଶେ ବହୱଃ କୁଷ୍ଠିନ ଆସନ୍ କିନ୍ତୁ ସୁରୀଯଦେଶୀଯଂ ନାମାନ୍କୁଷ୍ଠିନଂ ୱିନା କୋପ୍ୟନ୍ୟଃ ପରିଷ୍କୃତୋ ନାଭୂତ୍| ");
INSERT INTO sanori_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ଇମାଂ କଥାଂ ଶ୍ରୁତ୍ୱା ଭଜନଗେହସ୍ଥିତା ଲୋକାଃ ସକ୍ରୋଧମ୍ ଉତ୍ଥାଯ ");
INSERT INTO sanori_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ନଗରାତ୍ତଂ ବହିଷ୍କୃତ୍ୟ ଯସ୍ୟ ଶିଖରିଣ ଉପରି ତେଷାଂ ନଗରଂ ସ୍ଥାପିତମାସ୍ତେ ତସ୍ମାନ୍ନିକ୍ଷେପ୍ତୁଂ ତସ୍ୟ ଶିଖରଂ ତଂ ନିନ୍ୟୁଃ ");
INSERT INTO sanori_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","କିନ୍ତୁ ସ ତେଷାଂ ମଧ୍ୟାଦପସୃତ୍ୟ ସ୍ଥାନାନ୍ତରଂ ଜଗାମ| ");
INSERT INTO sanori_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ତତଃ ପରଂ ଯୀଶୁର୍ଗାଲୀଲ୍ପ୍ରଦେଶୀଯକଫର୍ନାହୂମ୍ନଗର ଉପସ୍ଥାଯ ୱିଶ୍ରାମୱାରେ ଲୋକାନୁପଦେଷ୍ଟୁମ୍ ଆରବ୍ଧୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ତଦୁପଦେଶାତ୍ ସର୍ୱ୍ୱେ ଚମଚ୍ଚକ୍ରୁ ର୍ୟତସ୍ତସ୍ୟ କଥା ଗୁରୁତରା ଆସନ୍| ");
INSERT INTO sanori_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","ତଦାନୀଂ ତଦ୍ଭଜନଗେହସ୍ଥିତୋଽମେଧ୍ୟଭୂତଗ୍ରସ୍ତ ଏକୋ ଜନ ଉଚ୍ଚୈଃ କଥଯାମାସ, ");
INSERT INTO sanori_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","ହେ ନାସରତୀଯଯୀଶୋଽସ୍ମାନ୍ ତ୍ୟଜ, ତ୍ୱଯା ସହାସ୍ମାକଂ କଃ ସମ୍ବନ୍ଧଃ? କିମସ୍ମାନ୍ ୱିନାଶଯିତୁମାଯାସି? ତ୍ୱମୀଶ୍ୱରସ୍ୟ ପୱିତ୍ରୋ ଜନ ଏତଦହଂ ଜାନାମି| ");
INSERT INTO sanori_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","ତଦା ଯୀଶୁସ୍ତଂ ତର୍ଜଯିତ୍ୱାୱଦତ୍ ମୌନୀ ଭୱ ଇତୋ ବହିର୍ଭୱ; ତତଃ ସୋମେଧ୍ୟଭୂତସ୍ତଂ ମଧ୍ୟସ୍ଥାନେ ପାତଯିତ୍ୱା କିଞ୍ଚିଦପ୍ୟହିଂସିତ୍ୱା ତସ୍ମାଦ୍ ବହିର୍ଗତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ତତଃ ସର୍ୱ୍ୱେ ଲୋକାଶ୍ଚମତ୍କୃତ୍ୟ ପରସ୍ପରଂ ୱକ୍ତୁମାରେଭିରେ କୋଯଂ ଚମତ୍କାରଃ| ଏଷ ପ୍ରଭାୱେଣ ପରାକ୍ରମେଣ ଚାମେଧ୍ୟଭୂତାନ୍ ଆଜ୍ଞାପଯତି ତେନୈୱ ତେ ବହିର୍ଗଚ୍ଛନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ଅନନ୍ତରଂ ଚତୁର୍ଦିକ୍ସ୍ଥଦେଶାନ୍ ତସ୍ୟ ସୁଖ୍ୟାତିର୍ୱ୍ୟାପ୍ନୋତ୍| ");
INSERT INTO sanori_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ତଦନନ୍ତରଂ ସ ଭଜନଗେହାଦ୍ ବହିରାଗତ୍ୟ ଶିମୋନୋ ନିୱେଶନଂ ପ୍ରୱିୱେଶ ତଦା ତସ୍ୟ ଶ୍ୱଶ୍ରୂର୍ଜ୍ୱରେଣାତ୍ୟନ୍ତଂ ପୀଡିତାସୀତ୍ ଶିଷ୍ୟାସ୍ତଦର୍ଥଂ ତସ୍ମିନ୍ ୱିନଯଂ ଚକ୍ରୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ତତଃ ସ ତସ୍ୟାଃ ସମୀପେ ସ୍ଥିତ୍ୱା ଜ୍ୱରଂ ତର୍ଜଯାମାସ ତେନୈୱ ତାଂ ଜ୍ୱରୋଽତ୍ୟାକ୍ଷୀତ୍ ତତଃ ସା ତତ୍କ୍ଷଣମ୍ ଉତ୍ଥାଯ ତାନ୍ ସିଷେୱେ| ");
INSERT INTO sanori_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","ଅଥ ସୂର୍ୟ୍ୟାସ୍ତକାଲେ ସ୍ୱେଷାଂ ଯେ ଯେ ଜନା ନାନାରୋଗୈଃ ପୀଡିତା ଆସନ୍ ଲୋକାସ୍ତାନ୍ ଯୀଶୋଃ ସମୀପମ୍ ଆନିନ୍ୟୁଃ, ତଦା ସ ଏକୈକସ୍ୟ ଗାତ୍ରେ କରମର୍ପଯିତ୍ୱା ତାନରୋଗାନ୍ ଚକାର| ");
INSERT INTO sanori_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ତତୋ ଭୂତା ବହୁଭ୍ୟୋ ନିର୍ଗତ୍ୟ ଚୀତ୍ଶବ୍ଦଂ କୃତ୍ୱା ଚ ବଭାଷିରେ ତ୍ୱମୀଶ୍ୱରସ୍ୟ ପୁତ୍ରୋଽଭିଷିକ୍ତତ୍ରାତା; କିନ୍ତୁ ସୋଭିଷିକ୍ତତ୍ରାତେତି ତେ ୱିୱିଦୁରେତସ୍ମାତ୍ କାରଣାତ୍ ତାନ୍ ତର୍ଜଯିତ୍ୱା ତଦ୍ୱକ୍ତୁଂ ନିଷିଷେଧ| ");
INSERT INTO sanori_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","ଅପରଞ୍ଚ ପ୍ରଭାତେ ସତି ସ ୱିଜନସ୍ଥାନଂ ପ୍ରତସ୍ଥେ ପଶ୍ଚାତ୍ ଜନାସ୍ତମନ୍ୱିଚ୍ଛନ୍ତସ୍ତନ୍ନିକଟଂ ଗତ୍ୱା ସ୍ଥାନାନ୍ତରଗମନାର୍ଥଂ ତମନ୍ୱରୁନ୍ଧନ୍| ");
INSERT INTO sanori_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","କିନ୍ତୁ ସ ତାନ୍ ଜଗାଦ, ଈଶ୍ୱରୀଯରାଜ୍ୟସ୍ୟ ସୁସଂୱାଦଂ ପ୍ରଚାରଯିତୁମ୍ ଅନ୍ୟାନି ପୁରାଣ୍ୟପି ମଯା ଯାତୱ୍ୟାନି ଯତସ୍ତଦର୍ଥମେୱ ପ୍ରେରିତୋହଂ| ");
INSERT INTO sanori_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ଅଥ ଗାଲୀଲୋ ଭଜନଗେହେଷୁ ସ ଉପଦିଦେଶ| ");
INSERT INTO sanori_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","ଅନନ୍ତରଂ ଯୀଶୁରେକଦା ଗିନେଷରଥ୍ଦସ୍ୟ ତୀର ଉତ୍ତିଷ୍ଠତି, ତଦା ଲୋକା ଈଶ୍ୱରୀଯକଥାଂ ଶ୍ରୋତୁଂ ତଦୁପରି ପ୍ରପତିତାଃ| ");
INSERT INTO sanori_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ତଦାନୀଂ ସ ହ୍ଦସ୍ୟ ତୀରସମୀପେ ନୌଦ୍ୱଯଂ ଦଦର୍ଶ କିଞ୍ଚ ମତ୍ସ୍ୟୋପଜୀୱିନୋ ନାୱଂ ୱିହାଯ ଜାଲଂ ପ୍ରକ୍ଷାଲଯନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ତତସ୍ତଯୋର୍ଦ୍ୱଯୋ ର୍ମଧ୍ୟେ ଶିମୋନୋ ନାୱମାରୁହ୍ୟ ତୀରାତ୍ କିଞ୍ଚିଦ୍ଦୂରଂ ଯାତୁଂ ତସ୍ମିନ୍ ୱିନଯଂ କୃତ୍ୱା ନୌକାଯାମୁପୱିଶ୍ୟ ଲୋକାନ୍ ପ୍ରୋପଦିଷ୍ଟୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ପଶ୍ଚାତ୍ ତଂ ପ୍ରସ୍ତାୱଂ ସମାପ୍ୟ ସ ଶିମୋନଂ ୱ୍ୟାଜହାର, ଗଭୀରଂ ଜଲଂ ଗତ୍ୱା ମତ୍ସ୍ୟାନ୍ ଧର୍ତ୍ତୁଂ ଜାଲଂ ନିକ୍ଷିପ| ");
INSERT INTO sanori_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ତତଃ ଶିମୋନ ବଭାଷେ, ହେ ଗୁରୋ ଯଦ୍ୟପି ୱଯଂ କୃତ୍ସ୍ନାଂ ଯାମିନୀଂ ପରିଶ୍ରମ୍ୟ ମତ୍ସ୍ୟୈକମପି ନ ପ୍ରାପ୍ତାସ୍ତଥାପି ଭୱତୋ ନିଦେଶତୋ ଜାଲଂ କ୍ଷିପାମଃ| ");
INSERT INTO sanori_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ଅଥ ଜାଲେ କ୍ଷିପ୍ତେ ବହୁମତ୍ସ୍ୟପତନାଦ୍ ଆନାଯଃ ପ୍ରଚ୍ଛିନ୍ନଃ| ");
INSERT INTO sanori_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ତସ୍ମାଦ୍ ଉପକର୍ତ୍ତୁମ୍ ଅନ୍ୟନୌସ୍ଥାନ୍ ସଙ୍ଗିନ ଆଯାତୁମ୍ ଇଙ୍ଗିତେନ ସମାହ୍ୱଯନ୍ ତତସ୍ତ ଆଗତ୍ୟ ମତ୍ସ୍ୟୈ ର୍ନୌଦ୍ୱଯଂ ପ୍ରପୂରଯାମାସୁ ର୍ୟୈ ର୍ନୌଦ୍ୱଯଂ ପ୍ରମଗ୍ନମ୍| ");
INSERT INTO sanori_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ତଦା ଶିମୋନ୍ପିତରସ୍ତଦ୍ ୱିଲୋକ୍ୟ ଯୀଶୋଶ୍ଚରଣଯୋଃ ପତିତ୍ୱା, ହେ ପ୍ରଭୋହଂ ପାପୀ ନରୋ ମମ ନିକଟାଦ୍ ଭୱାନ୍ ଯାତୁ, ଇତି କଥିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","ଯତୋ ଜାଲେ ପତିତାନାଂ ମତ୍ସ୍ୟାନାଂ ଯୂଥାତ୍ ଶିମୋନ୍ ତତ୍ସଙ୍ଗିନଶ୍ଚ ଚମତ୍କୃତୱନ୍ତଃ; ଶିମୋନଃ ସହକାରିଣୌ ସିୱଦେଃ ପୁତ୍ରୌ ଯାକୂବ୍ ଯୋହନ୍ ଚେମୌ ତାଦୃଶୌ ବଭୂୱତୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ତଦା ଯୀଶୁଃ ଶିମୋନଂ ଜଗାଦ ମା ଭୈଷୀରଦ୍ୟାରଭ୍ୟ ତ୍ୱଂ ମନୁଷ୍ୟଧରୋ ଭୱିଷ୍ୟସି| ");
INSERT INTO sanori_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ଅନନ୍ତରଂ ସର୍ୱ୍ୱାସୁ ନୌସୁ ତୀରମ୍ ଆନୀତାସୁ ତେ ସର୍ୱ୍ୱାନ୍ ପରିତ୍ୟଜ୍ୟ ତସ୍ୟ ପଶ୍ଚାଦ୍ଗାମିନୋ ବଭୂୱୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","ତତଃ ପରଂ ଯୀଶୌ କସ୍ମିଂଶ୍ଚିତ୍ ପୁରେ ତିଷ୍ଠତି ଜନ ଏକଃ ସର୍ୱ୍ୱାଙ୍ଗକୁଷ୍ଠସ୍ତଂ ୱିଲୋକ୍ୟ ତସ୍ୟ ସମୀପେ ନ୍ୟୁବ୍ଜଃ ପତିତ୍ୱା ସୱିନଯଂ ୱକ୍ତୁମାରେଭେ, ହେ ପ୍ରଭୋ ଯଦି ଭୱାନିଚ୍ଛତି ତର୍ହି ମାଂ ପରିଷ୍କର୍ତ୍ତୁଂ ଶକ୍ନୋତି| ");
INSERT INTO sanori_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","ତଦାନୀଂ ସ ପାଣିଂ ପ୍ରସାର୍ୟ୍ୟ ତଦଙ୍ଗଂ ସ୍ପୃଶନ୍ ବଭାଷେ ତ୍ୱଂ ପରିଷ୍କ୍ରିଯସ୍ୱେତି ମମେଚ୍ଛାସ୍ତି ତତସ୍ତତ୍କ୍ଷଣଂ ସ କୁଷ୍ଠାତ୍ ମୁକ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","ପଶ୍ଚାତ୍ ସ ତମାଜ୍ଞାପଯାମାସ କଥାମିମାଂ କସ୍ମୈଚିଦ୍ ଅକଥଯିତ୍ୱା ଯାଜକସ୍ୟ ସମୀପଞ୍ଚ ଗତ୍ୱା ସ୍ୱଂ ଦର୍ଶଯ, ଲୋକେଭ୍ୟୋ ନିଜପରିଷ୍କୃତତ୍ୱସ୍ୟ ପ୍ରମାଣଦାନାଯ ମୂସାଜ୍ଞାନୁସାରେଣ ଦ୍ରୱ୍ୟମୁତ୍ମୃଜସ୍ୱ ଚ| ");
INSERT INTO sanori_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","ତଥାପି ଯୀଶୋଃ ସୁଖ୍ୟାତି ର୍ବହୁ ୱ୍ୟାପ୍ତୁମାରେଭେ କିଞ୍ଚ ତସ୍ୟ କଥାଂ ଶ୍ରୋତୁଂ ସ୍ୱୀଯରୋଗେଭ୍ୟୋ ମୋକ୍ତୁଞ୍ଚ ଲୋକା ଆଜଗ୍ମୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","ଅଥ ସ ପ୍ରାନ୍ତରଂ ଗତ୍ୱା ପ୍ରାର୍ଥଯାଞ୍ଚକ୍ରେ| ");
INSERT INTO sanori_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","ଅପରଞ୍ଚ ଏକଦା ଯୀଶୁରୁପଦିଶତି, ଏତର୍ହି ଗାଲୀଲ୍ୟିହୂଦାପ୍ରଦେଶଯୋଃ ସର୍ୱ୍ୱନଗରେଭ୍ୟୋ ଯିରୂଶାଲମଶ୍ଚ କିଯନ୍ତଃ ଫିରୂଶିଲୋକା ୱ୍ୟୱସ୍ଥାପକାଶ୍ଚ ସମାଗତ୍ୟ ତଦନ୍ତିକେ ସମୁପୱିୱିଶୁଃ, ତସ୍ମିନ୍ କାଲେ ଲୋକାନାମାରୋଗ୍ୟକାରଣାତ୍ ପ୍ରଭୋଃ ପ୍ରଭାୱଃ ପ୍ରଚକାଶେ| ");
INSERT INTO sanori_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","ପଶ୍ଚାତ୍ କିଯନ୍ତୋ ଲୋକା ଏକଂ ପକ୍ଷାଘାତିନଂ ଖଟ୍ୱାଯାଂ ନିଧାଯ ଯୀଶୋଃ ସମୀପମାନେତୁଂ ସମ୍ମୁଖେ ସ୍ଥାପଯିତୁଞ୍ଚ ୱ୍ୟାପ୍ରିଯନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","କିନ୍ତୁ ବହୁଜନନିୱହସମ୍ୱାଧାତ୍ ନ ଶକ୍ନୁୱନ୍ତୋ ଗୃହୋପରି ଗତ୍ୱା ଗୃହପୃଷ୍ଠଂ ଖନିତ୍ୱା ତଂ ପକ୍ଷାଘାତିନଂ ସଖଟ୍ୱଂ ଗୃହମଧ୍ୟେ ଯୀଶୋଃ ସମ୍ମୁଖେ ଽୱରୋହଯାମାସୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","ତଦା ଯୀଶୁସ୍ତେଷାମ୍ ଈଦୃଶଂ ୱିଶ୍ୱାସଂ ୱିଲୋକ୍ୟ ତଂ ପକ୍ଷାଘାତିନଂ ୱ୍ୟାଜହାର, ହେ ମାନୱ ତୱ ପାପମକ୍ଷମ୍ୟତ| ");
INSERT INTO sanori_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ତସ୍ମାଦ୍ ଅଧ୍ୟାପକାଃ ଫିରୂଶିନଶ୍ଚ ଚିତ୍ତୈରିତ୍ଥଂ ପ୍ରଚିନ୍ତିତୱନ୍ତଃ, ଏଷ ଜନ ଈଶ୍ୱରଂ ନିନ୍ଦତି କୋଯଂ? କେୱଲମୀଶ୍ୱରଂ ୱିନା ପାପଂ କ୍ଷନ୍ତୁଂ କଃ ଶକ୍ନୋତି? ");
INSERT INTO sanori_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","ତଦା ଯୀଶୁସ୍ତେଷାମ୍ ଇତ୍ଥଂ ଚିନ୍ତନଂ ୱିଦିତ୍ୱା ତେଭ୍ୟୋକଥଯଦ୍ ଯୂଯଂ ମନୋଭିଃ କୁତୋ ୱିତର୍କଯଥ? ");
INSERT INTO sanori_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","ତୱ ପାପକ୍ଷମା ଜାତା ଯଦ୍ୱା ତ୍ୱମୁତ୍ଥାଯ ୱ୍ରଜ ଏତଯୋ ର୍ମଧ୍ୟେ କା କଥା ସୁକଥ୍ୟା? ");
INSERT INTO sanori_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","କିନ୍ତୁ ପୃଥିୱ୍ୟାଂ ପାପଂ କ୍ଷନ୍ତୁଂ ମାନୱସୁତସ୍ୟ ସାମର୍ଥ୍ୟମସ୍ତୀତି ଯଥା ଯୂଯଂ ଜ୍ଞାତୁଂ ଶକ୍ନୁଥ ତଦର୍ଥଂ (ସ ତଂ ପକ୍ଷାଘାତିନଂ ଜଗାଦ) ଉତ୍ତିଷ୍ଠ ସ୍ୱଶଯ୍ୟାଂ ଗୃହୀତ୍ୱା ଗୃହଂ ଯାହୀତି ତ୍ୱାମାଦିଶାମି| ");
INSERT INTO sanori_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","ତସ୍ମାତ୍ ସ ତତ୍କ୍ଷଣମ୍ ଉତ୍ଥାଯ ସର୍ୱ୍ୱେଷାଂ ସାକ୍ଷାତ୍ ନିଜଶଯନୀଯଂ ଗୃହୀତ୍ୱା ଈଶ୍ୱରଂ ଧନ୍ୟଂ ୱଦନ୍ ନିଜନିୱେଶନଂ ଯଯୌ| ");
INSERT INTO sanori_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","ତସ୍ମାତ୍ ସର୍ୱ୍ୱେ ୱିସ୍ମଯ ପ୍ରାପ୍ତା ମନଃସୁ ଭୀତାଶ୍ଚ ୱଯମଦ୍ୟାସମ୍ଭୱକାର୍ୟ୍ୟାଣ୍ୟଦର୍ଶାମ ଇତ୍ୟୁକ୍ତ୍ୱା ପରମେଶ୍ୱରଂ ଧନ୍ୟଂ ପ୍ରୋଦିତାଃ| ");
INSERT INTO sanori_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","ତତଃ ପରଂ ବହିର୍ଗଚ୍ଛନ୍ କରସଞ୍ଚଯସ୍ଥାନେ ଲେୱିନାମାନଂ କରସଞ୍ଚାଯକଂ ଦୃଷ୍ଟ୍ୱା ଯୀଶୁସ୍ତମଭିଦଧେ ମମ ପଶ୍ଚାଦେହି| ");
INSERT INTO sanori_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ତସ୍ମାତ୍ ସ ତତ୍କ୍ଷଣାତ୍ ସର୍ୱ୍ୱଂ ପରିତ୍ୟଜ୍ୟ ତସ୍ୟ ପଶ୍ଚାଦିଯାଯ| ");
INSERT INTO sanori_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","ଅନନ୍ତରଂ ଲେୱି ର୍ନିଜଗୃହେ ତଦର୍ଥଂ ମହାଭୋଜ୍ୟଂ ଚକାର, ତଦା ତୈଃ ସହାନେକେ କରସଞ୍ଚାଯିନସ୍ତଦନ୍ୟଲୋକାଶ୍ଚ ଭୋକ୍ତୁମୁପୱିୱିଶୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ତସ୍ମାତ୍ କାରଣାତ୍ ଚଣ୍ଡାଲାନାଂ ପାପିଲୋକାନାଞ୍ଚ ସଙ୍ଗେ ଯୂଯଂ କୁତୋ ଭଂଗ୍ଧ୍ୱେ ପିୱଥ ଚେତି କଥାଂ କଥଯିତ୍ୱା ଫିରୂଶିନୋଽଧ୍ୟାପକାଶ୍ଚ ତସ୍ୟ ଶିଷ୍ୟୈଃ ସହ ୱାଗ୍ୟୁଦ୍ଧଂ କର୍ତ୍ତୁମାରେଭିରେ| ");
INSERT INTO sanori_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","ତସ୍ମାଦ୍ ଯୀଶୁସ୍ତାନ୍ ପ୍ରତ୍ୟୱୋଚଦ୍ ଅରୋଗଲୋକାନାଂ ଚିକିତ୍ସକେନ ପ୍ରଯୋଜନଂ ନାସ୍ତି କିନ୍ତୁ ସରୋଗାଣାମେୱ| ");
INSERT INTO sanori_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ଅହଂ ଧାର୍ମ୍ମିକାନ୍ ଆହ୍ୱାତୁଂ ନାଗତୋସ୍ମି କିନ୍ତୁ ମନଃ ପରାୱର୍ତ୍ତଯିତୁଂ ପାପିନ ଏୱ| ");
INSERT INTO sanori_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","ତତସ୍ତେ ପ୍ରୋଚୁଃ, ଯୋହନଃ ଫିରୂଶିନାଞ୍ଚ ଶିଷ୍ୟା ୱାରଂୱାରମ୍ ଉପୱସନ୍ତି ପ୍ରାର୍ଥଯନ୍ତେ ଚ କିନ୍ତୁ ତୱ ଶିଷ୍ୟାଃ କୁତୋ ଭୁଞ୍ଜତେ ପିୱନ୍ତି ଚ? ");
INSERT INTO sanori_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","ତଦା ସ ତାନାଚଖ୍ୟୌ ୱରେ ସଙ୍ଗେ ତିଷ୍ଠତି ୱରସ୍ୟ ସଖିଗଣଂ କିମୁପୱାସଯିତୁଂ ଶକ୍ନୁଥ? ");
INSERT INTO sanori_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","କିନ୍ତୁ ଯଦା ତେଷାଂ ନିକଟାଦ୍ ୱରୋ ନେଷ୍ୟତେ ତଦା ତେ ସମୁପୱତ୍ସ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ସୋପରମପି ଦୃଷ୍ଟାନ୍ତଂ କଥଯାମ୍ବଭୂୱ ପୁରାତନୱସ୍ତ୍ରେ କୋପି ନୁତନୱସ୍ତ୍ରଂ ନ ସୀୱ୍ୟତି ଯତସ୍ତେନ ସେୱନେନ ଜୀର୍ଣୱସ୍ତ୍ରଂ ଛିଦ୍ୟତେ, ନୂତନପୁରାତନୱସ୍ତ୍ରଯୋ ର୍ମେଲଞ୍ଚ ନ ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ପୁରାତନ୍ୟାଂ କୁତ୍ୱାଂ କୋପି ନୁତନଂ ଦ୍ରାକ୍ଷାରସଂ ନ ନିଦଧାତି, ଯତୋ ନୱୀନଦ୍ରାକ୍ଷାରସସ୍ୟ ତେଜସା ପୁରାତନୀ କୁତୂ ର୍ୱିଦୀର୍ୟ୍ୟତେ ତତୋ ଦ୍ରାକ୍ଷାରସଃ ପତତି କୁତୂଶ୍ଚ ନଶ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","ତତୋ ହେତୋ ର୍ନୂତନ୍ୟାଂ କୁତ୍ୱାଂ ନୱୀନଦ୍ରାକ୍ଷାରସଃ ନିଧାତୱ୍ୟସ୍ତେନୋଭଯସ୍ୟ ରକ୍ଷା ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","ଅପରଞ୍ଚ ପୁରାତନଂ ଦ୍ରାକ୍ଷାରସଂ ପୀତ୍ୱା କୋପି ନୂତନଂ ନ ୱାଞ୍ଛତି, ଯତଃ ସ ୱକ୍ତି ନୂତନାତ୍ ପୁରାତନମ୍ ପ୍ରଶସ୍ତମ୍| ");
INSERT INTO sanori_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ଅଚରଞ୍ଚ ପର୍ୱ୍ୱଣୋ ଦ୍ୱିତୀଯଦିନାତ୍ ପରଂ ପ୍ରଥମୱିଶ୍ରାମୱାରେ ଶସ୍ୟକ୍ଷେତ୍ରେଣ ଯୀଶୋର୍ଗମନକାଲେ ତସ୍ୟ ଶିଷ୍ୟାଃ କଣିଶଂ ଛିତ୍ତ୍ୱା କରେଷୁ ମର୍ଦ୍ଦଯିତ୍ୱା ଖାଦିତୁମାରେଭିରେ| ");
INSERT INTO sanori_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ତସ୍ମାତ୍ କିଯନ୍ତଃ ଫିରୂଶିନସ୍ତାନୱଦନ୍ ୱିଶ୍ରାମୱାରେ ଯତ୍ କର୍ମ୍ମ ନ କର୍ତ୍ତୱ୍ୟଂ ତତ୍ କୁତଃ କୁରୁଥ? ");
INSERT INTO sanori_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","ଯୀଶୁଃ ପ୍ରତ୍ୟୁୱାଚ ଦାଯୂଦ୍ ତସ୍ୟ ସଙ୍ଗିନଶ୍ଚ କ୍ଷୁଧାର୍ତ୍ତାଃ କିଂ ଚକ୍ରୁଃ ସ କଥମ୍ ଈଶ୍ୱରସ୍ୟ ମନ୍ଦିରଂ ପ୍ରୱିଶ୍ୟ ");
INSERT INTO sanori_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ଯେ ଦର୍ଶନୀଯାଃ ପୂପା ଯାଜକାନ୍ ୱିନାନ୍ୟସ୍ୟ କସ୍ୟାପ୍ୟଭୋଜନୀଯାସ୍ତାନାନୀଯ ସ୍ୱଯଂ ବୁଭଜେ ସଙ୍ଗିଭ୍ୟୋପି ଦଦୌ ତତ୍ କିଂ ଯୁଷ୍ମାଭିଃ କଦାପି ନାପାଠି? ");
INSERT INTO sanori_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ପଶ୍ଚାତ୍ ସ ତାନୱଦତ୍ ମନୁଜସୁତୋ ୱିଶ୍ରାମୱାରସ୍ୟାପି ପ୍ରଭୁ ର୍ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","ଅନନ୍ତରମ୍ ଅନ୍ୟୱିଶ୍ରାମୱାରେ ସ ଭଜନଗେହଂ ପ୍ରୱିଶ୍ୟ ସମୁପଦିଶତି| ତଦା ତତ୍ସ୍ଥାନେ ଶୁଷ୍କଦକ୍ଷିଣକର ଏକଃ ପୁମାନ୍ ଉପତସ୍ଥିୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ତସ୍ମାଦ୍ ଅଧ୍ୟାପକାଃ ଫିରୂଶିନଶ୍ଚ ତସ୍ମିନ୍ ଦୋଷମାରୋପଯିତୁଂ ସ ୱିଶ୍ରାମୱାରେ ତସ୍ୟ ସ୍ୱାସ୍ଥ୍ୟଂ କରୋତି ନୱେତି ପ୍ରତୀକ୍ଷିତୁମାରେଭିରେ| ");
INSERT INTO sanori_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","ତଦା ଯୀଶୁସ୍ତେଷାଂ ଚିନ୍ତାଂ ୱିଦିତ୍ୱା ତଂ ଶୁଷ୍କକରଂ ପୁମାଂସଂ ପ୍ରୋୱାଚ, ତ୍ୱମୁତ୍ଥାଯ ମଧ୍ୟସ୍ଥାନେ ତିଷ୍ଠ| ");
INSERT INTO sanori_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ତସ୍ମାତ୍ ତସ୍ମିନ୍ ଉତ୍ଥିତୱତି ଯୀଶୁସ୍ତାନ୍ ୱ୍ୟାଜହାର, ଯୁଷ୍ମାନ୍ ଇମାଂ କଥାଂ ପୃଚ୍ଛାମି, ୱିଶ୍ରାମୱାରେ ହିତମ୍ ଅହିତଂ ୱା, ପ୍ରାଣରକ୍ଷଣଂ ପ୍ରାଣନାଶନଂ ୱା, ଏତେଷାଂ କିଂ କର୍ମ୍ମକରଣୀଯମ୍? ");
INSERT INTO sanori_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ପଶ୍ଚାତ୍ ଚତୁର୍ଦିକ୍ଷୁ ସର୍ୱ୍ୱାନ୍ ୱିଲୋକ୍ୟ ତଂ ମାନୱଂ ବଭାଷେ, ନିଜକରଂ ପ୍ରସାରଯ; ତତସ୍ତେନ ତଥା କୃତ ଇତରକରୱତ୍ ତସ୍ୟ ହସ୍ତଃ ସ୍ୱସ୍ଥୋଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","ତସ୍ମାତ୍ ତେ ପ୍ରଚଣ୍ଡକୋପାନ୍ୱିତା ଯୀଶୁଂ କିଂ କରିଷ୍ୟନ୍ତୀତି ପରସ୍ପରଂ ପ୍ରମନ୍ତ୍ରିତାଃ| ");
INSERT INTO sanori_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ତତଃ ପରଂ ସ ପର୍ୱ୍ୱତମାରୁହ୍ୟେଶ୍ୱରମୁଦ୍ଦିଶ୍ୟ ପ୍ରାର୍ଥଯମାନଃ କୃତ୍ସ୍ନାଂ ରାତ୍ରିଂ ଯାପିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ଅଥ ଦିନେ ସତି ସ ସର୍ୱ୍ୱାନ୍ ଶିଷ୍ୟାନ୍ ଆହୂତୱାନ୍ ତେଷାଂ ମଧ୍ୟେ ");
INSERT INTO sanori_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ପିତରନାମ୍ନା ଖ୍ୟାତଃ ଶିମୋନ୍ ତସ୍ୟ ଭ୍ରାତା ଆନ୍ଦ୍ରିଯଶ୍ଚ ଯାକୂବ୍ ଯୋହନ୍ ଚ ଫିଲିପ୍ ବର୍ଥଲମଯଶ୍ଚ ");
INSERT INTO sanori_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ମଥିଃ ଥୋମା ଆଲ୍ଫୀଯସ୍ୟ ପୁତ୍ରୋ ଯାକୂବ୍ ଜ୍ୱଲନ୍ତନାମ୍ନା ଖ୍ୟାତଃ ଶିମୋନ୍ ");
INSERT INTO sanori_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ଚ ଯାକୂବୋ ଭ୍ରାତା ଯିହୂଦାଶ୍ଚ ତଂ ଯଃ ପରକରେଷୁ ସମର୍ପଯିଷ୍ୟତି ସ ଈଷ୍କରୀଯୋତୀଯଯିହୂଦାଶ୍ଚୈତାନ୍ ଦ୍ୱାଦଶ ଜନାନ୍ ମନୋନୀତାନ୍ କୃତ୍ୱା ସ ଜଗ୍ରାହ ତଥା ପ୍ରେରିତ ଇତି ତେଷାଂ ନାମ ଚକାର| ");
INSERT INTO sanori_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","ତତଃ ପରଂ ସ ତୈଃ ସହ ପର୍ୱ୍ୱତାଦୱରୁହ୍ୟ ଉପତ୍ୟକାଯାଂ ତସ୍ଥୌ ତତସ୍ତସ୍ୟ ଶିଷ୍ୟସଙ୍ଘୋ ଯିହୂଦାଦେଶାଦ୍ ଯିରୂଶାଲମଶ୍ଚ ସୋରଃ ସୀଦୋନଶ୍ଚ ଜଲଧେ ରୋଧସୋ ଜନନିହାଶ୍ଚ ଏତ୍ୟ ତସ୍ୟ କଥାଶ୍ରୱଣାର୍ଥଂ ରୋଗମୁକ୍ତ୍ୟର୍ଥଞ୍ଚ ତସ୍ୟ ସମୀପେ ତସ୍ଥୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ଅମେଧ୍ୟଭୂତଗ୍ରସ୍ତାଶ୍ଚ ତନ୍ନିକଟମାଗତ୍ୟ ସ୍ୱାସ୍ଥ୍ୟଂ ପ୍ରାପୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ସର୍ୱ୍ୱେଷାଂ ସ୍ୱାସ୍ଥ୍ୟକରଣପ୍ରଭାୱସ୍ୟ ପ୍ରକାଶିତତ୍ୱାତ୍ ସର୍ୱ୍ୱେ ଲୋକା ଏତ୍ୟ ତଂ ସ୍ପ୍ରଷ୍ଟୁଂ ଯେତିରେ| ");
INSERT INTO sanori_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","ପଶ୍ଚାତ୍ ସ ଶିଷ୍ୟାନ୍ ପ୍ରତି ଦୃଷ୍ଟିଂ କୁତ୍ୱା ଜଗାଦ, ହେ ଦରିଦ୍ରା ଯୂଯଂ ଧନ୍ୟା ଯତ ଈଶ୍ୱରୀଯେ ରାଜ୍ୟେ ୱୋଽଧିକାରୋସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ହେ ଅଧୁନା କ୍ଷୁଧିତଲୋକା ଯୂଯଂ ଧନ୍ୟା ଯତୋ ଯୂଯଂ ତର୍ପ୍ସ୍ୟଥ; ହେ ଇହ ରୋଦିନୋ ଜନା ଯୂଯଂ ଧନ୍ୟା ଯତୋ ଯୂଯଂ ହସିଷ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","ଯଦା ଲୋକା ମନୁଷ୍ୟସୂନୋ ର୍ନାମହେତୋ ର୍ୟୁଷ୍ମାନ୍ ଋृତୀଯିଷ୍ୟନ୍ତେ ପୃଥକ୍ କୃତ୍ୱା ନିନ୍ଦିଷ୍ୟନ୍ତି, ଅଧମାନିୱ ଯୁଷ୍ମାନ୍ ସ୍ୱସମୀପାଦ୍ ଦୂରୀକରିଷ୍ୟନ୍ତି ଚ ତଦା ଯୂଯଂ ଧନ୍ୟାଃ| ");
INSERT INTO sanori_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ସ୍ୱର୍ଗେ ଯୁଷ୍ମାକଂ ଯଥେଷ୍ଟଂ ଫଲଂ ଭୱିଷ୍ୟତି, ଏତଦର୍ଥଂ ତସ୍ମିନ୍ ଦିନେ ପ୍ରୋଲ୍ଲସତ ଆନନ୍ଦେନ ନୃତ୍ୟତ ଚ, ତେଷାଂ ପୂର୍ୱ୍ୱପୁରୁଷାଶ୍ଚ ଭୱିଷ୍ୟଦ୍ୱାଦିନଃ ପ୍ରତି ତଥୈୱ ୱ୍ୟୱାହରନ୍| ");
INSERT INTO sanori_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","କିନ୍ତୁ ହା ହା ଧନୱନ୍ତୋ ଯୂଯଂ ସୁଖଂ ପ୍ରାପ୍ନୁତ| ହନ୍ତ ପରିତୃପ୍ତା ଯୂଯଂ କ୍ଷୁଧିତା ଭୱିଷ୍ୟଥ; ");
INSERT INTO sanori_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ଇହ ହସନ୍ତୋ ଯୂଯଂ ୱତ ଯୁଷ୍ମାଭିଃ ଶୋଚିତୱ୍ୟଂ ରୋଦିତୱ୍ୟଞ୍ଚ| ");
INSERT INTO sanori_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","ସର୍ୱ୍ୱୈଲାକୈ ର୍ୟୁଷ୍ମାକଂ ସୁଖ୍ୟାତୌ କୃତାଯାଂ ଯୁଷ୍ମାକଂ ଦୁର୍ଗତି ର୍ଭୱିଷ୍ୟତି ଯୁଷ୍ମାକଂ ପୂର୍ୱ୍ୱପୁରୁଷା ମୃଷାଭୱିଷ୍ୟଦ୍ୱାଦିନଃ ପ୍ରତି ତଦ୍ୱତ୍ କୃତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","ହେ ଶ୍ରୋତାରୋ ଯୁଷ୍ମଭ୍ୟମହଂ କଥଯାମି, ଯୂଯଂ ଶତ୍ରୁଷୁ ପ୍ରୀଯଧ୍ୱଂ ଯେ ଚ ଯୁଷ୍ମାନ୍ ଦ୍ୱିଷନ୍ତି ତେଷାମପି ହିତଂ କୁରୁତ| ");
INSERT INTO sanori_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ଯେ ଚ ଯୁଷ୍ମାନ୍ ଶପନ୍ତି ତେଭ୍ୟ ଆଶିଷଂ ଦତ୍ତ ଯେ ଚ ଯୁଷ୍ମାନ୍ ଅୱମନ୍ୟନ୍ତେ ତେଷାଂ ମଙ୍ଗଲଂ ପ୍ରାର୍ଥଯଧ୍ୱଂ| ");
INSERT INTO sanori_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","ଯଦି କଶ୍ଚିତ୍ ତୱ କପୋଲେ ଚପେଟାଘାତଂ କରୋତି ତର୍ହି ତଂ ପ୍ରତି କପୋଲମ୍ ଅନ୍ୟଂ ପରାୱର୍ତ୍ତ୍ୟ ସମ୍ମୁଖୀକୁରୁ ପୁନଶ୍ଚ ଯଦି କଶ୍ଚିତ୍ ତୱ ଗାତ୍ରୀଯୱସ୍ତ୍ରଂ ହରତି ତର୍ହି ତଂ ପରିଧେଯୱସ୍ତ୍ରମ୍ ଅପି ଗ୍ରହୀତୁଂ ମା ୱାରଯ| ");
INSERT INTO sanori_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ଯସ୍ତ୍ୱାଂ ଯାଚତେ ତସ୍ମୈ ଦେହି, ଯଶ୍ଚ ତୱ ସମ୍ପତ୍ତିଂ ହରତି ତଂ ମା ଯାଚସ୍ୱ| ");
INSERT INTO sanori_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","ପରେଭ୍ୟଃ ସ୍ୱାନ୍ ପ୍ରତି ଯଥାଚରଣମ୍ ଅପେକ୍ଷଧ୍ୱେ ପରାନ୍ ପ୍ରତି ଯୂଯମପି ତଥାଚରତ| ");
INSERT INTO sanori_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","ଯେ ଜନା ଯୁଷ୍ମାସୁ ପ୍ରୀଯନ୍ତେ କେୱଲଂ ତେଷୁ ପ୍ରୀଯମାଣେଷୁ ଯୁଷ୍ମାକଂ କିଂ ଫଲଂ? ପାପିଲୋକା ଅପି ସ୍ୱେଷୁ ପ୍ରୀଯମାଣେଷୁ ପ୍ରୀଯନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","ଯଦି ହିତକାରିଣ ଏୱ ହିତଂ କୁରୁଥ ତର୍ହି ଯୁଷ୍ମାକଂ କିଂ ଫଲଂ? ପାପିଲୋକା ଅପି ତଥା କୁର୍ୱ୍ୱନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","ଯେଭ୍ୟ ଋଣପରିଶୋଧସ୍ୟ ପ୍ରାପ୍ତିପ୍ରତ୍ୟାଶାସ୍ତେ କେୱଲଂ ତେଷୁ ଋଣେ ସମର୍ପିତେ ଯୁଷ୍ମାକଂ କିଂ ଫଲଂ? ପୁନଃ ପ୍ରାପ୍ତ୍ୟାଶଯା ପାପୀଲୋକା ଅପି ପାପିଜନେଷୁ ଋଣମ୍ ଅର୍ପଯନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","ଅତୋ ଯୂଯଂ ରିପୁଷ୍ୱପି ପ୍ରୀଯଧ୍ୱଂ, ପରହିତଂ କୁରୁତ ଚ; ପୁନଃ ପ୍ରାପ୍ତ୍ୟାଶାଂ ତ୍ୟକ୍ତ୍ୱା ଋଣମର୍ପଯତ, ତଥା କୃତେ ଯୁଷ୍ମାକଂ ମହାଫଲଂ ଭୱିଷ୍ୟତି, ଯୂଯଞ୍ଚ ସର୍ୱ୍ୱପ୍ରଧାନସ୍ୟ ସନ୍ତାନା ଇତି ଖ୍ୟାତିଂ ପ୍ରାପ୍ସ୍ୟଥ, ଯତୋ ଯୁଷ୍ମାକଂ ପିତା କୃତଘ୍ନାନାଂ ଦୁର୍ୱ୍ଟତ୍ତାନାଞ୍ଚ ହିତମାଚରତି| ");
INSERT INTO sanori_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ଅତ ଏୱ ସ ଯଥା ଦଯାଲୁ ର୍ୟୂଯମପି ତାଦୃଶା ଦଯାଲୱୋ ଭୱତ| ");
INSERT INTO sanori_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","ଅପରଞ୍ଚ ପରାନ୍ ଦୋଷିଣୋ ମା କୁରୁତ ତସ୍ମାଦ୍ ଯୂଯଂ ଦୋଷୀକୃତା ନ ଭୱିଷ୍ୟଥ; ଅଦଣ୍ଡ୍ୟାନ୍ ମା ଦଣ୍ଡଯତ ତସ୍ମାଦ୍ ଯୂଯମପି ଦଣ୍ଡଂ ନ ପ୍ରାପ୍ସ୍ୟଥ; ପରେଷାଂ ଦୋଷାନ୍ କ୍ଷମଧ୍ୱଂ ତସ୍ମାଦ୍ ଯୁଷ୍ମାକମପି ଦୋଷାଃ କ୍ଷମିଷ୍ୟନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","ଦାନାନିଦତ୍ତ ତସ୍ମାଦ୍ ଯୂଯଂ ଦାନାନି ପ୍ରାପ୍ସ୍ୟଥ, ୱରଞ୍ଚ ଲୋକାଃ ପରିମାଣପାତ୍ରଂ ପ୍ରଦଲଯ୍ୟ ସଞ୍ଚାଲ୍ୟ ପ୍ରୋଞ୍ଚାଲ୍ୟ ପରିପୂର୍ୟ୍ୟ ଯୁଷ୍ମାକଂ କ୍ରୋଡେଷୁ ସମର୍ପଯିଷ୍ୟନ୍ତି; ଯୂଯଂ ଯେନ ପରିମାଣେନ ପରିମାଥ ତେନୈୱ ପରିମାଣେନ ଯୁଷ୍ମତ୍କୃତେ ପରିମାସ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ଅଥ ସ ତେଭ୍ୟୋ ଦୃଷ୍ଟାନ୍ତକଥାମକଥଯତ୍, ଅନ୍ଧୋ ଜନଃ କିମନ୍ଧଂ ପନ୍ଥାନଂ ଦର୍ଶଯିତୁଂ ଶକ୍ନୋତି? ତସ୍ମାଦ୍ ଉଭାୱପି କିଂ ଗର୍ତ୍ତେ ନ ପତିଷ୍ୟତଃ? ");
INSERT INTO sanori_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ଗୁରୋଃ ଶିଷ୍ୟୋ ନ ଶ୍ରେଷ୍ଠଃ କିନ୍ତୁ ଶିଷ୍ୟେ ସିଦ୍ଧେ ସତି ସ ଗୁରୁତୁଲ୍ୟୋ ଭୱିତୁଂ ଶକ୍ନୋତି| ");
INSERT INTO sanori_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","ଅପରଞ୍ଚ ତ୍ୱଂ ସ୍ୱଚକ୍ଷୁुଷି ନାସାମ୍ ଅଦୃଷ୍ଟ୍ୱା ତୱ ଭ୍ରାତୁଶ୍ଚକ୍ଷୁଷି ଯତ୍ତୃଣମସ୍ତି ତଦେୱ କୁତଃ ପଶ୍ୟମି? ");
INSERT INTO sanori_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","ସ୍ୱଚକ୍ଷୁଷି ଯା ନାସା ୱିଦ୍ୟତେ ତାମ୍ ଅଜ୍ଞାତ୍ୱା, ଭ୍ରାତସ୍ତୱ ନେତ୍ରାତ୍ ତୃଣଂ ବହିଃ କରୋମୀତି ୱାକ୍ୟଂ ଭ୍ରାତରଂ କଥଂ ୱକ୍ତୁଂ ଶକ୍ନୋଷି? ହେ କପଟିନ୍ ପୂର୍ୱ୍ୱଂ ସ୍ୱନଯନାତ୍ ନାସାଂ ବହିଃ କୁରୁ ତତୋ ଭ୍ରାତୁଶ୍ଚକ୍ଷୁଷସ୍ତୃଣଂ ବହିଃ କର୍ତ୍ତୁଂ ସୁଦୃଷ୍ଟିଂ ପ୍ରାପ୍ସ୍ୟସି| ");
INSERT INTO sanori_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","ଅନ୍ୟଞ୍ଚ ଉତ୍ତମସ୍ତରୁଃ କଦାପି ଫଲମନୁତ୍ତମଂ ନ ଫଲତି, ଅନୁତ୍ତମତରୁଶ୍ଚ ଫଲମୁତ୍ତମଂ ନ ଫଲତି କାରଣାଦତଃ ଫଲୈସ୍ତରୱୋ ଜ୍ଞାଯନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","କଣ୍ଟକିପାଦପାତ୍ କୋପି ଉଡୁମ୍ବରଫଲାନି ନ ପାତଯତି ତଥା ଶୃଗାଲକୋଲିୱୃକ୍ଷାଦପି କୋପି ଦ୍ରାକ୍ଷାଫଲଂ ନ ପାତଯତି| ");
INSERT INTO sanori_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","ତଦ୍ୱତ୍ ସାଧୁଲୋକୋଽନ୍ତଃକରଣରୂପାତ୍ ସୁଭାଣ୍ଡାଗାରାଦ୍ ଉତ୍ତମାନି ଦ୍ରୱ୍ୟାଣି ବହିଃ କରୋତି, ଦୁଷ୍ଟୋ ଲୋକଶ୍ଚାନ୍ତଃକରଣରୂପାତ୍ କୁଭାଣ୍ଡାଗାରାତ୍ କୁତ୍ସିତାନି ଦ୍ରୱ୍ୟାଣି ନିର୍ଗମଯତି ଯତୋଽନ୍ତଃକରଣାନାଂ ପୂର୍ଣଭାୱାନୁରୂପାଣି ୱଚାଂସି ମୁଖାନ୍ନିର୍ଗଚ୍ଛନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","ଅପରଞ୍ଚ ମମାଜ୍ଞାନୁରୂପଂ ନାଚରିତ୍ୱା କୁତୋ ମାଂ ପ୍ରଭୋ ପ୍ରଭୋ ଇତି ୱଦଥ? ");
INSERT INTO sanori_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ଯଃ କଶ୍ଚିନ୍ ମମ ନିକଟମ୍ ଆଗତ୍ୟ ମମ କଥା ନିଶମ୍ୟ ତଦନୁରୂପଂ କର୍ମ୍ମ କରୋତି ସ କସ୍ୟ ସଦୃଶୋ ଭୱତି ତଦହଂ ଯୁଷ୍ମାନ୍ ଜ୍ଞାाପଯାମି| ");
INSERT INTO sanori_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ଯୋ ଜନୋ ଗଭୀରଂ ଖନିତ୍ୱା ପାଷାଣସ୍ଥଲେ ଭିତ୍ତିଂ ନିର୍ମ୍ମାଯ ସ୍ୱଗୃହଂ ରଚଯତି ତେନ ସହ ତସ୍ୟୋପମା ଭୱତି; ଯତ ଆପ୍ଲାୱିଜଲମେତ୍ୟ ତସ୍ୟ ମୂଲେ ୱେଗେନ ୱହଦପି ତଦ୍ଗେହଂ ଲାଡଯିତୁଂ ନ ଶକ୍ନୋତି ଯତସ୍ତସ୍ୟ ଭିତ୍ତିଃ ପାଷାଣୋପରି ତିଷ୍ଠତି| ");
INSERT INTO sanori_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","କିନ୍ତୁ ଯଃ କଶ୍ଚିନ୍ ମମ କଥାଃ ଶ୍ରୁତ୍ୱା ତଦନୁରୂପଂ ନାଚରତି ସ ଭିତ୍ତିଂ ୱିନା ମୃृଦୁପରି ଗୃହନିର୍ମ୍ମାତ୍ରା ସମାନୋ ଭୱତି; ଯତ ଆପ୍ଲାୱିଜଲମାଗତ୍ୟ ୱେଗେନ ଯଦା ୱହତି ତଦା ତଦ୍ଗୃହଂ ପତତି ତସ୍ୟ ମହତ୍ ପତନଂ ଜାଯତେ| ");
INSERT INTO sanori_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ତତଃ ପରଂ ସ ଲୋକାନାଂ କର୍ଣଗୋଚରେ ତାନ୍ ସର୍ୱ୍ୱାନ୍ ଉପଦେଶାନ୍ ସମାପ୍ୟ ଯଦା କଫର୍ନାହୂମ୍ପୁରଂ ପ୍ରୱିଶତି ");
INSERT INTO sanori_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","ତଦା ଶତସେନାପତେଃ ପ୍ରିଯଦାସ ଏକୋ ମୃତକଲ୍ପଃ ପୀଡିତ ଆସୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ଅତଃ ସେନାପତି ର୍ୟୀଶୋ ର୍ୱାର୍ତ୍ତାଂ ନିଶମ୍ୟ ଦାସସ୍ୟାରୋଗ୍ୟକରଣାଯ ତସ୍ୟାଗମନାର୍ଥଂ ୱିନଯକରଣାଯ ଯିହୂଦୀଯାନ୍ କିଯତଃ ପ୍ରାଚଃ ପ୍ରେଷଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","ତେ ଯୀଶୋରନ୍ତିକଂ ଗତ୍ୱା ୱିନଯାତିଶଯଂ ୱକ୍ତୁମାରେଭିରେ, ସ ସେନାପତି ର୍ଭୱତୋନୁଗ୍ରହଂ ପ୍ରାପ୍ତୁମ୍ ଅର୍ହତି| ");
INSERT INTO sanori_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ଯତଃ ସୋସ୍ମଜ୍ଜାତୀଯେଷୁ ଲୋକେଷୁ ପ୍ରୀଯତେ ତଥାସ୍ମତ୍କୃତେ ଭଜନଗେହଂ ନିର୍ମ୍ମିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ତସ୍ମାଦ୍ ଯୀଶୁସ୍ତୈଃ ସହ ଗତ୍ୱା ନିୱେଶନସ୍ୟ ସମୀପଂ ପ୍ରାପ, ତଦା ସ ଶତସେନାପତି ର୍ୱକ୍ଷ୍ୟମାଣୱାକ୍ୟଂ ତଂ ୱକ୍ତୁଂ ବନ୍ଧୂନ୍ ପ୍ରାହିଣୋତ୍| ହେ ପ୍ରଭୋ ସ୍ୱଯଂ ଶ୍ରମୋ ନ କର୍ତ୍ତୱ୍ୟୋ ଯଦ୍ ଭୱତା ମଦ୍ଗେହମଧ୍ୟେ ପାଦାର୍ପଣଂ କ୍ରିଯେତ ତଦପ୍ୟହଂ ନାର୍ହାମି, ");
INSERT INTO sanori_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","କିଞ୍ଚାହଂ ଭୱତ୍ସମୀପଂ ଯାତୁମପି ନାତ୍ମାନଂ ଯୋଗ୍ୟଂ ବୁଦ୍ଧୱାନ୍, ତତୋ ଭୱାନ୍ ୱାକ୍ୟମାତ୍ରଂ ୱଦତୁ ତେନୈୱ ମମ ଦାସଃ ସ୍ୱସ୍ଥୋ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","ଯସ୍ମାଦ୍ ଅହଂ ପରାଧୀନୋପି ମମାଧୀନା ଯାଃ ସେନାଃ ସନ୍ତି ତାସାମ୍ ଏକଜନଂ ପ୍ରତି ଯାହୀତି ମଯା ପ୍ରୋକ୍ତେ ସ ଯାତି; ତଦନ୍ୟଂ ପ୍ରତି ଆଯାହୀତି ପ୍ରୋକ୍ତେ ସ ଆଯାତି; ତଥା ନିଜଦାସଂ ପ୍ରତି ଏତତ୍ କୁର୍ୱ୍ୱିତି ପ୍ରୋକ୍ତେ ସ ତଦେୱ କରୋତି| ");
INSERT INTO sanori_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ଯୀଶୁରିଦଂ ୱାକ୍ୟଂ ଶ୍ରୁତ୍ୱା ୱିସ୍ମଯଂ ଯଯୌ, ମୁଖଂ ପରାୱର୍ତ୍ୟ ପଶ୍ଚାଦ୍ୱର୍ତ୍ତିନୋ ଲୋକାନ୍ ବଭାଷେ ଚ, ଯୁଷ୍ମାନହଂ ୱଦାମି ଇସ୍ରାଯେଲୋ ୱଂଶମଧ୍ୟେପି ୱିଶ୍ୱାସମୀଦୃଶଂ ନ ପ୍ରାପ୍ନୱଂ| ");
INSERT INTO sanori_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ତତସ୍ତେ ପ୍ରେଷିତା ଗୃହଂ ଗତ୍ୱା ତଂ ପୀଡିତଂ ଦାସଂ ସ୍ୱସ୍ଥଂ ଦଦୃଶୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","ପରେଽହନି ସ ନାଯୀନାଖ୍ୟଂ ନଗରଂ ଜଗାମ ତସ୍ୟାନେକେ ଶିଷ୍ୟା ଅନ୍ୟେ ଚ ଲୋକାସ୍ତେନ ସାର୍ଦ୍ଧଂ ଯଯୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ତେଷୁ ତନ୍ନଗରସ୍ୟ ଦ୍ୱାରସନ୍ନିଧିଂ ପ୍ରାପ୍ତେଷୁ କିଯନ୍ତୋ ଲୋକା ଏକଂ ମୃତମନୁଜଂ ୱହନ୍ତୋ ନଗରସ୍ୟ ବହିର୍ୟାନ୍ତି, ସ ତନ୍ମାତୁରେକପୁତ୍ରସ୍ତନ୍ମାତା ଚ ୱିଧୱା; ତଯା ସାର୍ଦ୍ଧଂ ତନ୍ନଗରୀଯା ବହୱୋ ଲୋକା ଆସନ୍| ");
INSERT INTO sanori_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ପ୍ରଭୁସ୍ତାଂ ୱିଲୋକ୍ୟ ସାନୁକମ୍ପଃ କଥଯାମାସ, ମା ରୋଦୀଃ| ସ ସମୀପମିତ୍ୱା ଖଟ୍ୱାଂ ପସ୍ପର୍ଶ ତସ୍ମାଦ୍ ୱାହକାଃ ସ୍ଥଗିତାସ୍ତମ୍ୟୁଃ; ");
INSERT INTO sanori_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ତଦା ସ ଉୱାଚ ହେ ଯୁୱମନୁଷ୍ୟ ତ୍ୱମୁତ୍ତିଷ୍ଠ, ତ୍ୱାମହମ୍ ଆଜ୍ଞାପଯାମି| ");
INSERT INTO sanori_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","ତସ୍ମାତ୍ ସ ମୃତୋ ଜନସ୍ତତ୍କ୍ଷଣମୁତ୍ଥାଯ କଥାଂ ପ୍ରକଥିତଃ; ତତୋ ଯୀଶୁସ୍ତସ୍ୟ ମାତରି ତଂ ସମର୍ପଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","ତସ୍ମାତ୍ ସର୍ୱ୍ୱେ ଲୋକାଃ ଶଶଙ୍କିରେ; ଏକୋ ମହାଭୱିଷ୍ୟଦ୍ୱାଦୀ ମଧ୍ୟେଽସ୍ମାକମ୍ ସମୁଦୈତ୍, ଈଶ୍ୱରଶ୍ଚ ସ୍ୱଲୋକାନନ୍ୱଗୃହ୍ଲାତ୍ କଥାମିମାଂ କଥଯିତ୍ୱା ଈଶ୍ୱରଂ ଧନ୍ୟଂ ଜଗଦୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ତତଃ ପରଂ ସମସ୍ତଂ ଯିହୂଦାଦେଶଂ ତସ୍ୟ ଚତୁର୍ଦିକ୍ସ୍ଥଦେଶଞ୍ଚ ତସ୍ୟୈତତ୍କୀର୍ତ୍ତି ର୍ୱ୍ୟାନଶେ| ");
INSERT INTO sanori_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ତତଃ ପରଂ ଯୋହନଃ ଶିଷ୍ୟେଷୁ ତଂ ତଦ୍ୱୃତ୍ତାନ୍ତଂ ଜ୍ଞାପିତୱତ୍ସୁ ");
INSERT INTO sanori_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ସ ସ୍ୱଶିଷ୍ୟାଣାଂ ଦ୍ୱୌ ଜନାୱାହୂଯ ଯୀଶୁଂ ପ୍ରତି ୱକ୍ଷ୍ୟମାଣଂ ୱାକ୍ୟଂ ୱକ୍ତୁଂ ପ୍ରେଷଯାମାସ, ଯସ୍ୟାଗମନମ୍ ଅପେକ୍ଷ୍ୟ ତିଷ୍ଠାମୋ ୱଯଂ କିଂ ସ ଏୱ ଜନସ୍ତ୍ୱଂ? କିଂ ୱଯମନ୍ୟମପେକ୍ଷ୍ୟ ସ୍ଥାସ୍ୟାମଃ? ");
INSERT INTO sanori_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","ପଶ୍ଚାତ୍ତୌ ମାନୱୌ ଗତ୍ୱା କଥଯାମାସତୁଃ, ଯସ୍ୟାଗମନମ୍ ଅପେକ୍ଷ୍ୟ ତିଷ୍ଠାମୋ ୱଯଂ, କିଂ ସଏୱ ଜନସ୍ତ୍ୱଂ? କିଂ ୱଯମନ୍ୟମପେକ୍ଷ୍ୟ ସ୍ଥାସ୍ୟାମଃ? କଥାମିମାଂ ତୁଭ୍ୟଂ କଥଯିତୁଂ ଯୋହନ୍ ମଜ୍ଜକ ଆୱାଂ ପ୍ରେଷିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ତସ୍ମିନ୍ ଦଣ୍ଡେ ଯୀଶୂରୋଗିଣୋ ମହାୱ୍ୟାଧିମତୋ ଦୁଷ୍ଟଭୂତଗ୍ରସ୍ତାଂଶ୍ଚ ବହୂନ୍ ସ୍ୱସ୍ଥାନ୍ କୃତ୍ୱା, ଅନେକାନ୍ଧେଭ୍ୟଶ୍ଚକ୍ଷୁଂଷି ଦତ୍ତ୍ୱା ପ୍ରତ୍ୟୁୱାଚ, ");
INSERT INTO sanori_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ଯୁୱାଂ ୱ୍ରଜତମ୍ ଅନ୍ଧା ନେତ୍ରାଣି ଖଞ୍ଜାଶ୍ଚରଣାନି ଚ ପ୍ରାପ୍ନୁୱନ୍ତି, କୁଷ୍ଠିନଃ ପରିଷ୍କ୍ରିଯନ୍ତେ, ବଧିରାଃ ଶ୍ରୱଣାନି ମୃତାଶ୍ଚ ଜୀୱନାନି ପ୍ରାପ୍ନୁୱନ୍ତି, ଦରିଦ୍ରାଣାଂ ସମୀପେଷୁ ସୁସଂୱାଦଃ ପ୍ରଚାର୍ୟ୍ୟତେ, ଯଂ ପ୍ରତି ୱିଘ୍ନସ୍ୱରୂପୋହଂ ନ ଭୱାମି ସ ଧନ୍ୟଃ, ");
INSERT INTO sanori_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ଏତାନି ଯାନି ପଶ୍ୟଥଃ ଶୃଣୁଥଶ୍ଚ ତାନି ଯୋହନଂ ଜ୍ଞାପଯତମ୍| ");
INSERT INTO sanori_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ତଯୋ ର୍ଦୂତଯୋ ର୍ଗତଯୋଃ ସତୋ ର୍ୟୋହନି ସ ଲୋକାନ୍ ୱକ୍ତୁମୁପଚକ୍ରମେ, ଯୂଯଂ ମଧ୍ୟେପ୍ରାନ୍ତରଂ କିଂ ଦ୍ରଷ୍ଟୁଂ ନିରଗମତ? କିଂ ୱାଯୁନା କମ୍ପିତଂ ନଡଂ? ");
INSERT INTO sanori_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ଯୂଯଂ କିଂ ଦ୍ରଷ୍ଟୁଂ ନିରଗମତ? କିଂ ସୂକ୍ଷ୍ମୱସ୍ତ୍ରପରିଧାଯିନଂ କମପି ନରଂ? କିନ୍ତୁ ଯେ ସୂକ୍ଷ୍ମମୃଦୁୱସ୍ତ୍ରାଣି ପରିଦଧତି ସୂତ୍ତମାନି ଦ୍ରୱ୍ୟାଣି ଭୁଞ୍ଜତେ ଚ ତେ ରାଜଧାନୀଷୁ ତିଷ୍ଠନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ତର୍ହି ଯୂଯଂ କିଂ ଦ୍ରଷ୍ଟୁଂ ନିରଗମତ? କିମେକଂ ଭୱିଷ୍ୟଦ୍ୱାଦିନଂ? ତଦେୱ ସତ୍ୟଂ କିନ୍ତୁ ସ ପୁମାନ୍ ଭୱିଷ୍ୟଦ୍ୱାଦିନୋପି ଶ୍ରେଷ୍ଠ ଇତ୍ୟହଂ ଯୁଷ୍ମାନ୍ ୱଦାମି; ");
INSERT INTO sanori_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ପଶ୍ୟ ସ୍ୱକୀଯଦୂତନ୍ତୁ ତୱାଗ୍ର ପ୍ରେଷଯାମ୍ୟହଂ| ଗତ୍ୱା ତ୍ୱଦୀଯମାର୍ଗନ୍ତୁ ସ ହି ପରିଷ୍କରିଷ୍ୟତି| ଯଦର୍ଥେ ଲିପିରିଯମ୍ ଆସ୍ତେ ସ ଏୱ ଯୋହନ୍| ");
INSERT INTO sanori_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","ଅତୋ ଯୁଷ୍ମାନହଂ ୱଦାମି ସ୍ତ୍ରିଯା ଗର୍ବ୍ଭଜାତାନାଂ ଭୱିଷ୍ୟଦ୍ୱାଦିନାଂ ମଧ୍ୟେ ଯୋହନୋ ମଜ୍ଜକାତ୍ ଶ୍ରେଷ୍ଠଃ କୋପି ନାସ୍ତି, ତତ୍ରାପି ଈଶ୍ୱରସ୍ୟ ରାଜ୍ୟେ ଯଃ ସର୍ୱ୍ୱସ୍ମାତ୍ କ୍ଷୁଦ୍ରଃ ସ ଯୋହନୋପି ଶ୍ରେଷ୍ଠଃ| ");
INSERT INTO sanori_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","ଅପରଞ୍ଚ ସର୍ୱ୍ୱେ ଲୋକାଃ କରମଞ୍ଚାଯିନଶ୍ଚ ତସ୍ୟ ୱାକ୍ୟାନି ଶ୍ରୁତ୍ୱା ଯୋହନା ମଜ୍ଜନେନ ମଜ୍ଜିତାଃ ପରମେଶ୍ୱରଂ ନିର୍ଦୋଷଂ ମେନିରେ| ");
INSERT INTO sanori_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","କିନ୍ତୁ ଫିରୂଶିନୋ ୱ୍ୟୱସ୍ଥାପକାଶ୍ଚ ତେନ ନ ମଜ୍ଜିତାଃ ସ୍ୱାନ୍ ପ୍ରତୀଶ୍ୱରସ୍ୟୋପଦେଶଂ ନିଷ୍ଫଲମ୍ ଅକୁର୍ୱ୍ୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","ଅଥ ପ୍ରଭୁଃ କଥଯାମାସ, ଇଦାନୀନ୍ତନଜନାନ୍ କେନୋପମାମି? ତେ କସ୍ୟ ସଦୃଶାଃ? ");
INSERT INTO sanori_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ଯେ ବାଲକା ୱିପଣ୍ୟାମ୍ ଉପୱିଶ୍ୟ ପରସ୍ପରମ୍ ଆହୂଯ ୱାକ୍ୟମିଦଂ ୱଦନ୍ତି, ୱଯଂ ଯୁଷ୍ମାକଂ ନିକଟେ ୱଂଶୀରୱାଦିଷ୍ମ, କିନ୍ତୁ ଯୂଯଂ ନାନର୍ତ୍ତିଷ୍ଟ, ୱଯଂ ଯୁଷ୍ମାକଂ ନିକଟ ଅରୋଦିଷ୍ମ, କିନ୍ତୁ ଯୁଯଂ ନ ୱ୍ୟଲପିଷ୍ଟ, ବାଲକୈରେତାଦୃଶୈସ୍ତେଷାମ୍ ଉପମା ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","ଯତୋ ଯୋହନ୍ ମଜ୍ଜକ ଆଗତ୍ୟ ପୂପଂ ନାଖାଦତ୍ ଦ୍ରାକ୍ଷାରସଞ୍ଚ ନାପିୱତ୍ ତସ୍ମାଦ୍ ଯୂଯଂ ୱଦଥ, ଭୂତଗ୍ରସ୍ତୋଯମ୍| ");
INSERT INTO sanori_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","ତତଃ ପରଂ ମାନୱସୁତ ଆଗତ୍ୟାଖାଦଦପିୱଞ୍ଚ ତସ୍ମାଦ୍ ଯୂଯଂ ୱଦଥ, ଖାଦକଃ ସୁରାପଶ୍ଚାଣ୍ଡାଲପାପିନାଂ ବନ୍ଧୁରେକୋ ଜନୋ ଦୃଶ୍ୟତାମ୍| ");
INSERT INTO sanori_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","କିନ୍ତୁ ଜ୍ଞାନିନୋ ଜ୍ଞାନଂ ନିର୍ଦୋଷଂ ୱିଦୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ପଶ୍ଚାଦେକଃ ଫିରୂଶୀ ଯୀଶୁଂ ଭୋଜନାଯ ନ୍ୟମନ୍ତ୍ରଯତ୍ ତତଃ ସ ତସ୍ୟ ଗୃହଂ ଗତ୍ୱା ଭୋକ୍ତୁମୁପୱିଷ୍ଟଃ| ");
INSERT INTO sanori_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ଏତର୍ହି ତତ୍ଫିରୂଶିନୋ ଗୃହେ ଯୀଶୁ ର୍ଭେକ୍ତୁମ୍ ଉପାୱେକ୍ଷୀତ୍ ତଚ୍ଛ୍ରୁତ୍ୱା ତନ୍ନଗରୱାସିନୀ କାପି ଦୁଷ୍ଟା ନାରୀ ପାଣ୍ଡରପ୍ରସ୍ତରସ୍ୟ ସମ୍ପୁଟକେ ସୁଗନ୍ଧିତୈଲମ୍ ଆନୀଯ ");
INSERT INTO sanori_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ତସ୍ୟ ପଶ୍ଚାତ୍ ପାଦଯୋଃ ସନ୍ନିଧୌ ତସ୍ୟୌ ରୁଦତୀ ଚ ନେତ୍ରାମ୍ବୁଭିସ୍ତସ୍ୟ ଚରଣୌ ପ୍ରକ୍ଷାଲ୍ୟ ନିଜକଚୈରମାର୍କ୍ଷୀତ୍, ତତସ୍ତସ୍ୟ ଚରଣୌ ଚୁମ୍ବିତ୍ୱା ତେନ ସୁଗନ୍ଧିତୈଲେନ ମମର୍ଦ| ");
INSERT INTO sanori_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ତସ୍ମାତ୍ ସ ନିମନ୍ତ୍ରଯିତା ଫିରୂଶୀ ମନସା ଚିନ୍ତଯାମାସ, ଯଦ୍ୟଯଂ ଭୱିଷ୍ୟଦ୍ୱାଦୀ ଭୱେତ୍ ତର୍ହି ଏନଂ ସ୍ପୃଶତି ଯା ସ୍ତ୍ରୀ ସା କା କୀଦୃଶୀ ଚେତି ଜ୍ଞାତୁଂ ଶକ୍ନୁଯାତ୍ ଯତଃ ସା ଦୁଷ୍ଟା| ");
INSERT INTO sanori_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ତଦା ଯାଶୁସ୍ତଂ ଜଗାଦ, ହେ ଶିମୋନ୍ ତ୍ୱାଂ ପ୍ରତି ମମ କିଞ୍ଚିଦ୍ ୱକ୍ତୱ୍ୟମସ୍ତି; ତସ୍ମାତ୍ ସ ବଭାଷେ, ହେ ଗୁରୋ ତଦ୍ ୱଦତୁ| ");
INSERT INTO sanori_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ଏକୋତ୍ତମର୍ଣସ୍ୟ ଦ୍ୱାୱଧମର୍ଣାୱାସ୍ତାଂ, ତଯୋରେକଃ ପଞ୍ଚଶତାନି ମୁଦ୍ରାପାଦାନ୍ ଅପରଶ୍ଚ ପଞ୍ଚାଶତ୍ ମୁଦ୍ରାପାଦାନ୍ ଧାରଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","ତଦନନ୍ତରଂ ତଯୋଃ ଶୋଧ୍ୟାଭାୱାତ୍ ସ ଉତ୍ତମର୍ଣସ୍ତଯୋ ରୃଣେ ଚକ୍ଷମେ; ତସ୍ମାତ୍ ତଯୋର୍ଦ୍ୱଯୋଃ କସ୍ତସ୍ମିନ୍ ପ୍ରେଷ୍ୟତେ ବହୁ? ତଦ୍ ବ୍ରୂହି| ");
INSERT INTO sanori_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ଶିମୋନ୍ ପ୍ରତ୍ୟୁୱାଚ, ମଯା ବୁଧ୍ୟତେ ଯସ୍ୟାଧିକମ୍ ଋଣଂ ଚକ୍ଷମେ ସ ଇତି; ତତୋ ଯୀଶୁସ୍ତଂ ୱ୍ୟାଜହାର, ତ୍ୱଂ ଯଥାର୍ଥଂ ୱ୍ୟଚାରଯଃ| ");
INSERT INTO sanori_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ଅଥ ତାଂ ନାରୀଂ ପ୍ରତି ୱ୍ୟାଘୁଠ୍ୟ ଶିମୋନମୱୋଚତ୍, ସ୍ତ୍ରୀମିମାଂ ପଶ୍ୟସି? ତୱ ଗୃହେ ମଯ୍ୟାଗତେ ତ୍ୱଂ ପାଦପ୍ରକ୍ଷାଲନାର୍ଥଂ ଜଲଂ ନାଦାଃ କିନ୍ତୁ ଯୋଷିଦେଷା ନଯନଜଲୈ ର୍ମମ ପାଦୌ ପ୍ରକ୍ଷାଲ୍ୟ କେଶୈରମାର୍କ୍ଷୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ତ୍ୱଂ ମାଂ ନାଚୁମ୍ବୀଃ କିନ୍ତୁ ଯୋଷିଦେଷା ସ୍ୱୀଯାଗମନାଦାରଭ୍ୟ ମଦୀଯପାଦୌ ଚୁମ୍ବିତୁଂ ନ ୱ୍ୟରଂସ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ତ୍ୱଞ୍ଚ ମଦୀଯୋତ୍ତମାଙ୍ଗେ କିଞ୍ଚିଦପି ତୈଲଂ ନାମର୍ଦୀଃ କିନ୍ତୁ ଯୋଷିଦେଷା ମମ ଚରଣୌ ସୁଗନ୍ଧିତୈଲେନାମର୍ଦ୍ଦୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","ଅତସ୍ତ୍ୱାଂ ୱ୍ୟାହରାମି, ଏତସ୍ୟା ବହୁ ପାପମକ୍ଷମ୍ୟତ ତତୋ ବହୁ ପ୍ରୀଯତେ କିନ୍ତୁ ଯସ୍ୟାଲ୍ପପାପଂ କ୍ଷମ୍ୟତେ ସୋଲ୍ପଂ ପ୍ରୀଯତେ| ");
INSERT INTO sanori_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ତତଃ ପରଂ ସ ତାଂ ବଭାଷେ, ତ୍ୱଦୀଯଂ ପାପମକ୍ଷମ୍ୟତ| ");
INSERT INTO sanori_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ତଦା ତେନ ସାର୍ଦ୍ଧଂ ଯେ ଭୋକ୍ତୁମ୍ ଉପୱିୱିଶୁସ୍ତେ ପରସ୍ପରଂ ୱକ୍ତୁମାରେଭିରେ, ଅଯଂ ପାପଂ କ୍ଷମତେ କ ଏଷଃ? ");
INSERT INTO sanori_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","କିନ୍ତୁ ସ ତାଂ ନାରୀଂ ଜଗାଦ, ତୱ ୱିଶ୍ୱାସସ୍ତ୍ୱାଂ ପର୍ୟ୍ୟତ୍ରାସ୍ତ ତ୍ୱଂ କ୍ଷେମେଣ ୱ୍ରଜ| ");
INSERT INTO sanori_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ଅପରଞ୍ଚ ଯୀଶୁ ର୍ଦ୍ୱାଦଶଭିଃ ଶିଷ୍ୟୈଃ ସାର୍ଦ୍ଧଂ ନାନାନଗରେଷୁ ନାନାଗ୍ରାମେଷୁ ଚ ଗଚ୍ଛନ୍ ଇଶ୍ୱରୀଯରାଜତ୍ୱସ୍ୟ ସୁସଂୱାଦଂ ପ୍ରଚାରଯିତୁଂ ପ୍ରାରେଭେ| ");
INSERT INTO sanori_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ତଦା ଯସ୍ୟାଃ ସପ୍ତ ଭୂତା ନିରଗଚ୍ଛନ୍ ସା ମଗ୍ଦଲୀନୀତି ୱିଖ୍ୟାତା ମରିଯମ୍ ହେରୋଦ୍ରାଜସ୍ୟ ଗୃହାଧିପତେଃ ହୋଷେ ର୍ଭାର୍ୟ୍ୟା ଯୋହନା ଶୂଶାନା ");
INSERT INTO sanori_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ପ୍ରଭୃତଯୋ ଯା ବହ୍ୱ୍ୟଃ ସ୍ତ୍ରିଯଃ ଦୁଷ୍ଟଭୂତେଭ୍ୟୋ ରୋଗେଭ୍ୟଶ୍ଚ ମୁକ୍ତାଃ ସତ୍ୟୋ ନିଜୱିଭୂତୀ ର୍ୱ୍ୟଯିତ୍ୱା ତମସେୱନ୍ତ, ତାଃ ସର୍ୱ୍ୱାସ୍ତେନ ସାର୍ଦ୍ଧମ୍ ଆସନ୍| ");
INSERT INTO sanori_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","ଅନନ୍ତରଂ ନାନାନଗରେଭ୍ୟୋ ବହୱୋ ଲୋକା ଆଗତ୍ୟ ତସ୍ୟ ସମୀପେଽମିଲନ୍, ତଦା ସ ତେଭ୍ୟ ଏକାଂ ଦୃଷ୍ଟାନ୍ତକଥାଂ କଥଯାମାସ| ଏକଃ କୃଷୀବଲୋ ବୀଜାନି ୱପ୍ତୁଂ ବହିର୍ଜଗାମ, ");
INSERT INTO sanori_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","ତତୋ ୱପନକାଲେ କତିପଯାନି ବୀଜାନି ମାର୍ଗପାର୍ଶ୍ୱେ ପେତୁଃ, ତତସ୍ତାନି ପଦତଲୈ ର୍ଦଲିତାନି ପକ୍ଷିଭି ର୍ଭକ୍ଷିତାନି ଚ| ");
INSERT INTO sanori_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","କତିପଯାନି ବୀଜାନି ପାଷାଣସ୍ଥଲେ ପତିତାନି ଯଦ୍ୟପି ତାନ୍ୟଙ୍କୁରିତାନି ତଥାପି ରସାଭାୱାତ୍ ଶୁଶୁଷୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","କତିପଯାନି ବୀଜାନି କଣ୍ଟକିୱନମଧ୍ୟେ ପତିତାନି ତତଃ କଣ୍ଟକିୱନାନି ସଂୱୃଦ୍ଧ୍ୟ ତାନି ଜଗ୍ରସୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","ତଦନ୍ୟାନି କତିପଯବୀଜାନି ଚ ଭୂମ୍ୟାମୁତ୍ତମାଯାଂ ପେତୁସ୍ତତସ୍ତାନ୍ୟଙ୍କୁରଯିତ୍ୱା ଶତଗୁଣାନି ଫଲାନି ଫେଲୁଃ| ସ ଇମା କଥାଂ କଥଯିତ୍ୱା ପ୍ରୋଚ୍ଚୈଃ ପ୍ରୋୱାଚ, ଯସ୍ୟ ଶ୍ରୋତୁଂ ଶ୍ରୋତ୍ରେ ସ୍ତଃ ସ ଶୃଣୋତୁ| ");
INSERT INTO sanori_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ତତଃ ପରଂ ଶିଷ୍ୟାସ୍ତଂ ପପ୍ରଚ୍ଛୁରସ୍ୟ ଦୃଷ୍ଟାନ୍ତସ୍ୟ କିଂ ତାତ୍ପର୍ୟ୍ୟଂ? ");
INSERT INTO sanori_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ତତଃ ସ ୱ୍ୟାଜହାର, ଈଶ୍ୱରୀଯରାଜ୍ୟସ୍ୟ ଗୁହ୍ୟାନି ଜ୍ଞାତୁଂ ଯୁଷ୍ମଭ୍ୟମଧିକାରୋ ଦୀଯତେ କିନ୍ତ୍ୱନ୍ୟେ ଯଥା ଦୃଷ୍ଟ୍ୱାପି ନ ପଶ୍ୟନ୍ତି ଶ୍ରୁତ୍ୱାପି ମ ବୁଧ୍ୟନ୍ତେ ଚ ତଦର୍ଥଂ ତେଷାଂ ପୁରସ୍ତାତ୍ ତାଃ ସର୍ୱ୍ୱାଃ କଥା ଦୃଷ୍ଟାନ୍ତେନ କଥ୍ୟନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","ଦୃଷ୍ଟାନ୍ତସ୍ୟାସ୍ୟାଭିପ୍ରାଯଃ, ଈଶ୍ୱରୀଯକଥା ବୀଜସ୍ୱରୂପା| ");
INSERT INTO sanori_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ଯେ କଥାମାତ୍ରଂ ଶୃଣ୍ୱନ୍ତି କିନ୍ତୁ ପଶ୍ଚାଦ୍ ୱିଶ୍ୱସ୍ୟ ଯଥା ପରିତ୍ରାଣଂ ନ ପ୍ରାପ୍ନୁୱନ୍ତି ତଦାଶଯେନ ଶୈତାନେତ୍ୟ ହୃଦଯାତୃ ତାଂ କଥାମ୍ ଅପହରତି ତ ଏୱ ମାର୍ଗପାର୍ଶ୍ୱସ୍ଥଭୂମିସ୍ୱରୂପାଃ| ");
INSERT INTO sanori_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ଯେ କଥଂ ଶ୍ରୁତ୍ୱା ସାନନ୍ଦଂ ଗୃହ୍ଲନ୍ତି କିନ୍ତ୍ୱବଦ୍ଧମୂଲତ୍ୱାତ୍ ସ୍ୱଲ୍ପକାଲମାତ୍ରଂ ପ୍ରତୀତ୍ୟ ପରୀକ୍ଷାକାଲେ ଭ୍ରଶ୍ୟନ୍ତି ତଏୱ ପାଷାଣଭୂମିସ୍ୱରୂପାଃ| ");
INSERT INTO sanori_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ଯେ କଥାଂ ଶ୍ରୁତ୍ୱା ଯାନ୍ତି ୱିଷଯଚିନ୍ତାଯାଂ ଧନଲୋଭେନ ଏेହିକସୁଖେ ଚ ମଜ୍ଜନ୍ତ ଉପଯୁକ୍ତଫଲାନି ନ ଫଲନ୍ତି ତ ଏୱୋପ୍ତବୀଜକଣ୍ଟକିଭୂସ୍ୱରୂପାଃ| ");
INSERT INTO sanori_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","କିନ୍ତୁ ଯେ ଶ୍ରୁତ୍ୱା ସରଲୈଃ ଶୁଦ୍ଧୈଶ୍ଚାନ୍ତଃକରଣୈଃ କଥାଂ ଗୃହ୍ଲନ୍ତି ଧୈର୍ୟ୍ୟମ୍ ଅୱଲମ୍ବ୍ୟ ଫଲାନ୍ୟୁତ୍ପାଦଯନ୍ତି ଚ ତ ଏୱୋତ୍ତମମୃତ୍ସ୍ୱରୂପାଃ| ");
INSERT INTO sanori_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","ଅପରଞ୍ଚ ପ୍ରଦୀପଂ ପ୍ରଜ୍ୱାଲ୍ୟ କୋପି ପାତ୍ରେଣ ନାଚ୍ଛାଦଯତି ତଥା ଖଟ୍ୱାଧୋପି ନ ସ୍ଥାପଯତି, କିନ୍ତୁ ଦୀପାଧାରୋପର୍ୟ୍ୟେୱ ସ୍ଥାପଯତି, ତସ୍ମାତ୍ ପ୍ରୱେଶକା ଦୀପ୍ତିଂ ପଶ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","ଯନ୍ନ ପ୍ରକାଶଯିଷ୍ୟତେ ତାଦୃଗ୍ ଅପ୍ରକାଶିତଂ ୱସ୍ତୁ କିମପି ନାସ୍ତି ଯଚ୍ଚ ନ ସୁୱ୍ୟକ୍ତଂ ପ୍ରଚାରଯିଷ୍ୟତେ ତାଦୃଗ୍ ଗୃପ୍ତଂ ୱସ୍ତୁ କିମପି ନାସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","ଅତୋ ଯୂଯଂ କେନ ପ୍ରକାରେଣ ଶୃଣୁଥ ତତ୍ର ସାୱଧାନା ଭୱତ, ଯସ୍ୟ ସମୀପେ ବର୍ଦ୍ଧତେ ତସ୍ମୈ ପୁନର୍ଦାସ୍ୟତେ କିନ୍ତୁ ଯସ୍ୟାଶ୍ରଯେ ନ ବର୍ଦ୍ଧତେ ତସ୍ୟ ଯଦ୍ୟଦସ୍ତି ତଦପି ତସ୍ମାତ୍ ନେଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ଅପରଞ୍ଚ ଯୀଶୋ ର୍ମାତା ଭ୍ରାତରଶ୍ଚ ତସ୍ୟ ସମୀପଂ ଜିଗମିଷୱଃ ");
INSERT INTO sanori_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","କିନ୍ତୁ ଜନତାସମ୍ବାଧାତ୍ ତତ୍ସନ୍ନିଧିଂ ପ୍ରାପ୍ତୁଂ ନ ଶେକୁଃ| ତତ୍ପଶ୍ଚାତ୍ ତୱ ମାତା ଭ୍ରାତରଶ୍ଚ ତ୍ୱାଂ ସାକ୍ଷାତ୍ ଚିକୀର୍ଷନ୍ତୋ ବହିସ୍ତିଷ୍ଠନତୀତି ୱାର୍ତ୍ତାଯାଂ ତସ୍ମୈ କଥିତାଯାଂ ");
INSERT INTO sanori_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ସ ପ୍ରତ୍ୟୁୱାଚ; ଯେ ଜନା ଈଶ୍ୱରସ୍ୟ କଥାଂ ଶ୍ରୁତ୍ୱା ତଦନୁରୂପମାଚରନ୍ତି ତଏୱ ମମ ମାତା ଭ୍ରାତରଶ୍ଚ| ");
INSERT INTO sanori_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","ଅନନ୍ତରଂ ଏକଦା ଯୀଶୁଃ ଶିଷ୍ୟୈଃ ସାର୍ଦ୍ଧଂ ନାୱମାରୁହ୍ୟ ଜଗାଦ, ଆଯାତ ୱଯଂ ହ୍ରଦସ୍ୟ ପାରଂ ଯାମଃ, ତତସ୍ତେ ଜଗ୍ମୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ତେଷୁ ନୌକାଂ ୱାହଯତ୍ସୁ ସ ନିଦଦ୍ରୌ; ");
INSERT INTO sanori_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ଅଥାକସ୍ମାତ୍ ପ୍ରବଲଝଞ୍ଭ୍ଶଗମାଦ୍ ହ୍ରଦେ ନୌକାଯାଂ ତରଙ୍ଗୈରାଚ୍ଛନ୍ନାଯାଂ ୱିପତ୍ ତାନ୍ ଜଗ୍ରାସ| ତସ୍ମାଦ୍ ଯୀଶୋରନ୍ତିକଂ ଗତ୍ୱା ହେ ଗୁରୋ ହେ ଗୁରୋ ପ୍ରାଣା ନୋ ଯାନ୍ତୀତି ଗଦିତ୍ୱା ତଂ ଜାଗରଯାମ୍ବଭୂୱୁଃ| ତଦା ସ ଉତ୍ଥାଯ ୱାଯୁଂ ତରଙ୍ଗାଂଶ୍ଚ ତର୍ଜଯାମାସ ତସ୍ମାଦୁଭୌ ନିୱୃତ୍ୟ ସ୍ଥିରୌ ବଭୂୱତୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ସ ତାନ୍ ବଭାଷେ ଯୁଷ୍ମାକଂ ୱିଶ୍ୱାସଃ କ? ତସ୍ମାତ୍ତେ ଭୀତା ୱିସ୍ମିତାଶ୍ଚ ପରସ୍ପରଂ ଜଗଦୁଃ, ଅହୋ କୀଦୃଗଯଂ ମନୁଜଃ ପୱନଂ ପାନୀଯଞ୍ଚାଦିଶତି ତଦୁଭଯଂ ତଦାଦେଶଂ ୱହତି| ");
INSERT INTO sanori_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ତତଃ ପରଂ ଗାଲୀଲ୍ପ୍ରଦେଶସ୍ୟ ସମ୍ମୁଖସ୍ଥଗିଦେରୀଯପ୍ରଦେଶେ ନୌକାଯାଂ ଲଗନ୍ତ୍ୟାଂ ତଟେଽୱରୋହମାୱାଦ୍ ");
INSERT INTO sanori_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ବହୁତିଥକାଲଂ ଭୂତଗ୍ରସ୍ତ ଏକୋ ମାନୁଷଃ ପୁରାଦାଗତ୍ୟ ତଂ ସାକ୍ଷାଚ୍ଚକାର| ସ ମନୁଷୋ ୱାସୋ ନ ପରିଦଧତ୍ ଗୃହେ ଚ ନ ୱସନ୍ କେୱଲଂ ଶ୍ମଶାନମ୍ ଅଧ୍ୟୁୱାସ| ");
INSERT INTO sanori_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ସ ଯୀଶୁଂ ଦୃଷ୍ଟ୍ୱୈୱ ଚୀଚ୍ଛବ୍ଦଂ ଚକାର ତସ୍ୟ ସମ୍ମୁଖେ ପତିତ୍ୱା ପ୍ରୋଚ୍ଚୈର୍ଜଗାଦ ଚ, ହେ ସର୍ୱ୍ୱପ୍ରଧାନେଶ୍ୱରସ୍ୟ ପୁତ୍ର, ମଯା ସହ ତୱ କଃ ସମ୍ବନ୍ଧଃ? ତ୍ୱଯି ୱିନଯଂ କରୋମି ମାଂ ମା ଯାତଯ| ");
INSERT INTO sanori_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","ଯତଃ ସ ତଂ ମାନୁଷଂ ତ୍ୟକ୍ତ୍ୱା ଯାତୁମ୍ ଅମେଧ୍ୟଭୂତମ୍ ଆଦିଦେଶ; ସ ଭୂତସ୍ତଂ ମାନୁଷମ୍ ଅସକୃଦ୍ ଦଧାର ତସ୍ମାଲ୍ଲୋକାଃ ଶୃଙ୍ଖଲେନ ନିଗଡେନ ଚ ବବନ୍ଧୁଃ; ସ ତଦ୍ ଭଂକ୍ତ୍ୱା ଭୂତୱଶତ୍ୱାତ୍ ମଧ୍ୟେପ୍ରାନ୍ତରଂ ଯଯୌ| ");
INSERT INTO sanori_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","ଅନନ୍ତରଂ ଯୀଶୁସ୍ତଂ ପପ୍ରଚ୍ଛ ତୱ କିନ୍ନାମ? ସ ଉୱାଚ, ମମ ନାମ ବାହିନୋ ଯତୋ ବହୱୋ ଭୂତାସ୍ତମାଶିଶ୍ରିଯୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","ଅଥ ଭୂତା ୱିନଯେନ ଜଗଦୁଃ, ଗଭୀରଂ ଗର୍ତ୍ତଂ ଗନ୍ତୁଂ ମାଜ୍ଞାପଯାସ୍ମାନ୍| ");
INSERT INTO sanori_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ତଦା ପର୍ୱ୍ୱତୋପରି ୱରାହୱ୍ରଜଶ୍ଚରତି ତସ୍ମାଦ୍ ଭୂତା ୱିନଯେନ ପ୍ରୋଚୁଃ, ଅମୁଂ ୱରାହୱ୍ରଜମ୍ ଆଶ୍ରଯିତୁମ୍ ଅସ୍ମାନ୍ ଅନୁଜାନୀହି; ତତଃ ସୋନୁଜଜ୍ଞୌ| ");
INSERT INTO sanori_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ତତଃ ପରଂ ଭୂତାସ୍ତଂ ମାନୁଷଂ ୱିହାଯ ୱରାହୱ୍ରଜମ୍ ଆଶିଶ୍ରିଯୁଃ ୱରାହୱ୍ରଜାଶ୍ଚ ତତ୍କ୍ଷଣାତ୍ କଟକେନ ଧାୱନ୍ତୋ ହ୍ରଦେ ପ୍ରାଣାନ୍ ୱିଜୃହୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ତଦ୍ ଦୃଷ୍ଟ୍ୱା ଶୂକରରକ୍ଷକାଃ ପଲାଯମାନା ନଗରଂ ଗ୍ରାମଞ୍ଚ ଗତ୍ୱା ତତ୍ସର୍ୱ୍ୱୱୃତ୍ତାନ୍ତଂ କଥଯାମାସୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","ତତଃ କିଂ ୱୃତ୍ତମ୍ ଏତଦ୍ଦର୍ଶନାର୍ଥଂ ଲୋକା ନିର୍ଗତ୍ୟ ଯୀଶୋଃ ସମୀପଂ ଯଯୁଃ, ତଂ ମାନୁଷଂ ତ୍ୟକ୍ତଭୂତଂ ପରିହିତୱସ୍ତ୍ରଂ ସ୍ୱସ୍ଥମାନୁଷୱଦ୍ ଯୀଶୋଶ୍ଚରଣସନ୍ନିଧୌ ସୂପୱିଶନ୍ତଂ ୱିଲୋକ୍ୟ ବିଭ୍ୟୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ଯେ ଲୋକାସ୍ତସ୍ୟ ଭୂତଗ୍ରସ୍ତସ୍ୟ ସ୍ୱାସ୍ଥ୍ୟକରଣଂ ଦଦୃଶୁସ୍ତେ ତେଭ୍ୟଃ ସର୍ୱ୍ୱୱୃତ୍ତାନ୍ତଂ କଥଯାମାସୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ତଦନନ୍ତରଂ ତସ୍ୟ ଗିଦେରୀଯପ୍ରଦେଶସ୍ୟ ଚତୁର୍ଦିକ୍ସ୍ଥା ବହୱୋ ଜନା ଅତିତ୍ରସ୍ତା ୱିନଯେନ ତଂ ଜଗଦୁଃ, ଭୱାନ୍ ଅସ୍ମାକଂ ନିକଟାଦ୍ ୱ୍ରଜତୁ ତସ୍ମାତ୍ ସ ନାୱମାରୁହ୍ୟ ତତୋ ୱ୍ୟାଘୁଟ୍ୟ ଜଗାମ| ");
INSERT INTO sanori_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ତଦାନୀଂ ତ୍ୟକ୍ତଭୂତମନୁଜସ୍ତେନ ସହ ସ୍ଥାତୁଂ ପ୍ରାର୍ଥଯାଞ୍ଚକ୍ରେ ");
INSERT INTO sanori_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","କିନ୍ତୁ ତଦର୍ଥମ୍ ଈଶ୍ୱରଃ କୀଦୃଙ୍ମହାକର୍ମ୍ମ କୃତୱାନ୍ ଇତି ନିୱେଶନଂ ଗତ୍ୱା ୱିଜ୍ଞାପଯ, ଯୀଶୁଃ କଥାମେତାଂ କଥଯିତ୍ୱା ତଂ ୱିସସର୍ଜ| ତତଃ ସ ୱ୍ରଜିତ୍ୱା ଯୀଶୁସ୍ତଦର୍ଥଂ ଯନ୍ମହାକର୍ମ୍ମ ଚକାର ତତ୍ ପୁରସ୍ୟ ସର୍ୱ୍ୱତ୍ର ପ୍ରକାଶଯିତୁଂ ପ୍ରାରେଭେ| ");
INSERT INTO sanori_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","ଅଥ ଯୀଶୌ ପରାୱୃତ୍ୟାଗତେ ଲୋକାସ୍ତଂ ଆଦରେଣ ଜଗୃହୁ ର୍ୟସ୍ମାତ୍ତେ ସର୍ୱ୍ୱେ ତମପେକ୍ଷାଞ୍ଚକ୍ରିରେ| ");
INSERT INTO sanori_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","ତଦନନ୍ତରଂ ଯାଯୀର୍ନାମ୍ନୋ ଭଜନଗେହସ୍ୟୈକୋଧିପ ଆଗତ୍ୟ ଯୀଶୋଶ୍ଚରଣଯୋଃ ପତିତ୍ୱା ସ୍ୱନିୱେଶନାଗମନାର୍ଥଂ ତସ୍ମିନ୍ ୱିନଯଂ ଚକାର, ");
INSERT INTO sanori_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ଯତସ୍ତସ୍ୟ ଦ୍ୱାଦଶୱର୍ଷୱଯସ୍କା କନ୍ୟୈକାସୀତ୍ ସା ମୃତକଲ୍ପାଭୱତ୍| ତତସ୍ତସ୍ୟ ଗମନକାଲେ ମାର୍ଗେ ଲୋକାନାଂ ମହାନ୍ ସମାଗମୋ ବଭୂୱ| ");
INSERT INTO sanori_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ଦ୍ୱାଦଶୱର୍ଷାଣି ପ୍ରଦରରୋଗଗ୍ରସ୍ତା ନାନା ୱୈଦ୍ୟୈଶ୍ଚିକିତ୍ସିତା ସର୍ୱ୍ୱସ୍ୱଂ ୱ୍ୟଯିତ୍ୱାପି ସ୍ୱାସ୍ଥ୍ୟଂ ନ ପ୍ରାପ୍ତା ଯା ଯୋଷିତ୍ ସା ଯୀଶୋଃ ପଶ୍ଚାଦାଗତ୍ୟ ତସ୍ୟ ୱସ୍ତ୍ରଗ୍ରନ୍ଥିଂ ପସ୍ପର୍ଶ| ");
INSERT INTO sanori_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ତସ୍ମାତ୍ ତତ୍କ୍ଷଣାତ୍ ତସ୍ୟା ରକ୍ତସ୍ରାୱୋ ରୁଦ୍ଧଃ| ");
INSERT INTO sanori_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ତଦାନୀଂ ଯୀଶୁରୱଦତ୍ କେନାହଂ ସ୍ପୃଷ୍ଟଃ? ତତୋଽନେକୈରନଙ୍ଗୀକୃତେ ପିତରସ୍ତସ୍ୟ ସଙ୍ଗିନଶ୍ଚାୱଦନ୍, ହେ ଗୁରୋ ଲୋକା ନିକଟସ୍ଥାଃ ସନ୍ତସ୍ତୱ ଦେହେ ଘର୍ଷଯନ୍ତି, ତଥାପି କେନାହଂ ସ୍ପୃଷ୍ଟଇତି ଭୱାନ୍ କୁତଃ ପୃଚ୍ଛତି? ");
INSERT INTO sanori_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","ଯୀଶୁଃ କଥଯାମାସ, କେନାପ୍ୟହଂ ସ୍ପୃଷ୍ଟୋ, ଯତୋ ମତ୍ତଃ ଶକ୍ତି ର୍ନିର୍ଗତେତି ମଯା ନିଶ୍ଚିତମଜ୍ଞାଯି| ");
INSERT INTO sanori_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ତଦା ସା ନାରୀ ସ୍ୱଯଂ ନ ଗୁପ୍ତେତି ୱିଦିତ୍ୱା କମ୍ପମାନା ସତୀ ତସ୍ୟ ସମ୍ମୁଖେ ପପାତ; ଯେନ ନିମିତ୍ତେନ ତଂ ପସ୍ପର୍ଶ ସ୍ପର୍ଶମାତ୍ରାଚ୍ଚ ଯେନ ପ୍ରକାରେଣ ସ୍ୱସ୍ଥାଭୱତ୍ ତତ୍ ସର୍ୱ୍ୱଂ ତସ୍ୟ ସାକ୍ଷାଦାଚଖ୍ୟୌ| ");
INSERT INTO sanori_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ତତଃ ସ ତାଂ ଜଗାଦ ହେ କନ୍ୟେ ସୁସ୍ଥିରା ଭୱ, ତୱ ୱିଶ୍ୱାସସ୍ତ୍ୱାଂ ସ୍ୱସ୍ଥାମ୍ ଅକାର୍ଷୀତ୍ ତ୍ୱଂ କ୍ଷେମେଣ ଯାହି| ");
INSERT INTO sanori_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","ଯୀଶୋରେତଦ୍ୱାକ୍ୟୱଦନକାଲେ ତସ୍ୟାଧିପତେ ର୍ନିୱେଶନାତ୍ କଶ୍ଚିଲ୍ଲୋକ ଆଗତ୍ୟ ତଂ ବଭାଷେ, ତୱ କନ୍ୟା ମୃତା ଗୁରୁଂ ମା କ୍ଲିଶାନ| ");
INSERT INTO sanori_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","କିନ୍ତୁ ଯୀଶୁସ୍ତଦାକର୍ଣ୍ୟାଧିପତିଂ ୱ୍ୟାଜହାର, ମା ଭୈଷୀଃ କେୱଲଂ ୱିଶ୍ୱସିହି ତସ୍ମାତ୍ ସା ଜୀୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ଅଥ ତସ୍ୟ ନିୱେଶନେ ପ୍ରାପ୍ତେ ସ ପିତରଂ ଯୋହନଂ ଯାକୂବଞ୍ଚ କନ୍ୟାଯା ମାତରଂ ପିତରଞ୍ଚ ୱିନା, ଅନ୍ୟଂ କଞ୍ଚନ ପ୍ରୱେଷ୍ଟୁଂ ୱାରଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","ଅପରଞ୍ଚ ଯେ ରୁଦନ୍ତି ୱିଲପନ୍ତି ଚ ତାନ୍ ସର୍ୱ୍ୱାନ୍ ଜନାନ୍ ଉୱାଚ, ଯୂଯଂ ମା ରୋଦିଷ୍ଟ କନ୍ୟା ନ ମୃତା ନିଦ୍ରାତି| ");
INSERT INTO sanori_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","କିନ୍ତୁ ସା ନିଶ୍ଚିତଂ ମୃତେତି ଜ୍ଞାତ୍ୱା ତେ ତମୁପଜହସୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","ପଶ୍ଚାତ୍ ସ ସର୍ୱ୍ୱାନ୍ ବହିଃ କୃତ୍ୱା କନ୍ୟାଯାଃ କରୌ ଧୃତ୍ୱାଜୁହୁୱେ, ହେ କନ୍ୟେ ତ୍ୱମୁତ୍ତିଷ୍ଠ, ");
INSERT INTO sanori_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ତସ୍ମାତ୍ ତସ୍ୟାଃ ପ୍ରାଣେଷୁ ପୁନରାଗତେଷୁ ସା ତତ୍କ୍ଷଣାଦ୍ ଉତ୍ତସ୍ୟୌ| ତଦାନୀଂ ତସ୍ୟୈ କିଞ୍ଚିଦ୍ ଭକ୍ଷ୍ୟଂ ଦାତୁମ୍ ଆଦିଦେଶ| ");
INSERT INTO sanori_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ତତସ୍ତସ୍ୟାଃ ପିତରୌ ୱିସ୍ମଯଂ ଗତୌ କିନ୍ତୁ ସ ତାୱାଦିଦେଶ ଘଟନାଯା ଏତସ୍ୟାଃ କଥାଂ କସ୍ମୈଚିଦପି ମା କଥଯତଂ| ");
INSERT INTO sanori_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","ତତଃ ପରଂ ସ ଦ୍ୱାଦଶଶିଷ୍ୟାନାହୂଯ ଭୂତାନ୍ ତ୍ୟାଜଯିତୁଂ ରୋଗାନ୍ ପ୍ରତିକର୍ତ୍ତୁଞ୍ଚ ତେଭ୍ୟଃ ଶକ୍ତିମାଧିପତ୍ୟଞ୍ଚ ଦଦୌ| ");
INSERT INTO sanori_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ଅପରଞ୍ଚ ଈଶ୍ୱରୀଯରାଜ୍ୟସ୍ୟ ସୁସଂୱାଦଂ ପ୍ରକାଶଯିତୁମ୍ ରୋଗିଣାମାରୋଗ୍ୟଂ କର୍ତ୍ତୁଞ୍ଚ ପ୍ରେରଣକାଲେ ତାନ୍ ଜଗାଦ| ");
INSERT INTO sanori_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ଯାତ୍ରାର୍ଥଂ ଯଷ୍ଟି ର୍ୱସ୍ତ୍ରପୁଟକଂ ଭକ୍ଷ୍ୟଂ ମୁଦ୍ରା ଦ୍ୱିତୀଯୱସ୍ତ୍ରମ୍, ଏଷାଂ କିମପି ମା ଗୃହ୍ଲୀତ| ");
INSERT INTO sanori_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ଯୂଯଞ୍ଚ ଯନ୍ନିୱେଶନଂ ପ୍ରୱିଶଥ ନଗରତ୍ୟାଗପର୍ୟ୍ୟନତଂ ତନ୍ନିୱେଶନେ ତିଷ୍ଠତ| ");
INSERT INTO sanori_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","ତତ୍ର ଯଦି କସ୍ୟଚିତ୍ ପୁରସ୍ୟ ଲୋକା ଯୁଷ୍ମାକମାତିଥ୍ୟଂ ନ କୁର୍ୱ୍ୱନ୍ତି ତର୍ହି ତସ୍ମାନ୍ନଗରାଦ୍ ଗମନକାଲେ ତେଷାଂ ୱିରୁଦ୍ଧଂ ସାକ୍ଷ୍ୟାର୍ଥଂ ଯୁଷ୍ମାକଂ ପଦଧୂଲୀଃ ସମ୍ପାତଯତ| ");
INSERT INTO sanori_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","ଅଥ ତେ ପ୍ରସ୍ଥାଯ ସର୍ୱ୍ୱତ୍ର ସୁସଂୱାଦଂ ପ୍ରଚାରଯିତୁଂ ପୀଡିତାନ୍ ସ୍ୱସ୍ଥାନ୍ କର୍ତ୍ତୁଞ୍ଚ ଗ୍ରାମେଷୁ ଭ୍ରମିତୁଂ ପ୍ରାରେଭିରେ| ");
INSERT INTO sanori_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ଏତର୍ହି ହେରୋଦ୍ ରାଜା ଯୀଶୋଃ ସର୍ୱ୍ୱକର୍ମ୍ମଣାଂ ୱାର୍ତ୍ତାଂ ଶ୍ରୁତ୍ୱା ଭୃଶମୁଦ୍ୱିୱିଜେ ");
INSERT INTO sanori_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ଯତଃ କେଚିଦୂଚୁର୍ୟୋହନ୍ ଶ୍ମଶାନାଦୁଦତିଷ୍ଠତ୍| କେଚିଦୂଚୁଃ, ଏଲିଯୋ ଦର୍ଶନଂ ଦତ୍ତୱାନ୍; ଏୱମନ୍ୟଲୋକା ଊଚୁଃ ପୂର୍ୱ୍ୱୀଯଃ କଶ୍ଚିଦ୍ ଭୱିଷ୍ୟଦ୍ୱାଦୀ ସମୁତ୍ଥିତଃ| ");
INSERT INTO sanori_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","କିନ୍ତୁ ହେରୋଦୁୱାଚ ଯୋହନଃ ଶିରୋଽହମଛିନଦମ୍ ଇଦାନୀଂ ଯସ୍ୟେଦୃକ୍କର୍ମ୍ମଣାଂ ୱାର୍ତ୍ତାଂ ପ୍ରାପ୍ନୋମି ସ କଃ? ଅଥ ସ ତଂ ଦ୍ରଷ୍ଟୁମ୍ ଐଚ୍ଛତ୍| ");
INSERT INTO sanori_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","ଅନନ୍ତରଂ ପ୍ରେରିତାଃ ପ୍ରତ୍ୟାଗତ୍ୟ ଯାନି ଯାନି କର୍ମ୍ମାଣି ଚକ୍ରୁସ୍ତାନି ଯୀଶୱେ କଥଯାମାସୁଃ ତତଃ ସ ତାନ୍ ବୈତ୍ସୈଦାନାମକନଗରସ୍ୟ ୱିଜନଂ ସ୍ଥାନଂ ନୀତ୍ୱା ଗୁପ୍ତଂ ଜଗାମ| ");
INSERT INTO sanori_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ପଶ୍ଚାଲ୍ ଲୋକାସ୍ତଦ୍ ୱିଦିତ୍ୱା ତସ୍ୟ ପଶ୍ଚାଦ୍ ଯଯୁଃ; ତତଃ ସ ତାନ୍ ନଯନ୍ ଈଶ୍ୱରୀଯରାଜ୍ୟସ୍ୟ ପ୍ରସଙ୍ଗମୁକ୍ତୱାନ୍, ଯେଷାଂ ଚିକିତ୍ସଯା ପ୍ରଯୋଜନମ୍ ଆସୀତ୍ ତାନ୍ ସ୍ୱସ୍ଥାନ୍ ଚକାର ଚ| ");
INSERT INTO sanori_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ଅପରଞ୍ଚ ଦିୱାୱସନ୍ନେ ସତି ଦ୍ୱାଦଶଶିଷ୍ୟା ଯୀଶୋରନ୍ତିକମ୍ ଏତ୍ୟ କଥଯାମାସୁଃ, ୱଯମତ୍ର ପ୍ରାନ୍ତରସ୍ଥାନେ ତିଷ୍ଠାମଃ, ତତୋ ନଗରାଣି ଗ୍ରାମାଣି ଗତ୍ୱା ୱାସସ୍ଥାନାନି ପ୍ରାପ୍ୟ ଭକ୍ଷ୍ୟଦ୍ରୱ୍ୟାଣି କ୍ରେତୁଂ ଜନନିୱହଂ ଭୱାନ୍ ୱିସୃଜତୁ| ");
INSERT INTO sanori_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","ତଦା ସ ଉୱାଚ, ଯୂଯମେୱ ତାନ୍ ଭେଜଯଧ୍ୱଂ; ତତସ୍ତେ ପ୍ରୋଚୁରସ୍ମାକଂ ନିକଟେ କେୱଲଂ ପଞ୍ଚ ପୂପା ଦ୍ୱୌ ମତ୍ସ୍ୟୌ ଚ ୱିଦ୍ୟନ୍ତେ, ଅତଏୱ ସ୍ଥାନାନ୍ତରମ୍ ଇତ୍ୱା ନିମିତ୍ତମେତେଷାଂ ଭକ୍ଷ୍ୟଦ୍ରୱ୍ୟେଷୁ ନ କ୍ରୀତେଷୁ ନ ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","ତତ୍ର ପ୍ରାଯେଣ ପଞ୍ଚସହସ୍ରାଣି ପୁରୁଷା ଆସନ୍| ");
INSERT INTO sanori_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","ତଦା ସ ଶିଷ୍ୟାନ୍ ଜଗାଦ ପଞ୍ଚାଶତ୍ ପଞ୍ଚାଶଜ୍ଜନୈଃ ପଂକ୍ତୀକୃତ୍ୟ ତାନୁପୱେଶଯତ, ତସ୍ମାତ୍ ତେ ତଦନୁସାରେଣ ସର୍ୱ୍ୱଲୋକାନୁପୱେଶଯାପାସୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ତତଃ ସ ତାନ୍ ପଞ୍ଚ ପୂପାନ୍ ମୀନଦ୍ୱଯଞ୍ଚ ଗୃହୀତ୍ୱା ସ୍ୱର୍ଗଂ ୱିଲୋକ୍ୟେଶ୍ୱରଗୁଣାନ୍ କୀର୍ତ୍ତଯାଞ୍ଚକ୍ରେ ଭଙ୍କ୍ତା ଚ ଲୋକେଭ୍ୟଃ ପରିୱେଷଣାର୍ଥଂ ଶିଷ୍ୟେଷୁ ସମର୍ପଯାମ୍ବଭୂୱ| ");
INSERT INTO sanori_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ତତଃ ସର୍ୱ୍ୱେ ଭୁକ୍ତ୍ୱା ତୃପ୍ତିଂ ଗତା ଅୱଶିଷ୍ଟାନାଞ୍ଚ ଦ୍ୱାଦଶ ଡଲ୍ଲକାନ୍ ସଂଜଗୃହୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","ଅଥୈକଦା ନିର୍ଜନେ ଶିଷ୍ୟୈଃ ସହ ପ୍ରାର୍ଥନାକାଲେ ତାନ୍ ପପ୍ରଚ୍ଛ, ଲୋକା ମାଂ କଂ ୱଦନ୍ତି? ");
INSERT INTO sanori_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","ତତସ୍ତେ ପ୍ରାଚୁଃ, ତ୍ୱାଂ ଯୋହନ୍ମଜ୍ଜକଂ ୱଦନ୍ତି; କେଚିତ୍ ତ୍ୱାମ୍ ଏଲିଯଂ ୱଦନ୍ତି, ପୂର୍ୱ୍ୱକାଲିକଃ କଶ୍ଚିଦ୍ ଭୱିଷ୍ୟଦ୍ୱାଦୀ ଶ୍ମଶାନାଦ୍ ଉଦତିଷ୍ଠଦ୍ ଇତ୍ୟପି କେଚିଦ୍ ୱଦନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ତଦା ସ ଉୱାଚ, ଯୂଯଂ ମାଂ କଂ ୱଦଥ? ତତଃ ପିତର ଉକ୍ତୱାନ୍ ତ୍ୱମ୍ ଈଶ୍ୱରାଭିଷିକ୍ତଃ ପୁରୁଷଃ| ");
INSERT INTO sanori_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","ତଦା ସ ତାନ୍ ଦୃଢମାଦିଦେଶ, କଥାମେତାଂ କସ୍ମୈଚିଦପି ମା କଥଯତ| ");
INSERT INTO sanori_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ସ ପୁନରୁୱାଚ, ମନୁଷ୍ୟପୁତ୍ରେଣ ୱହୁଯାତନା ଭୋକ୍ତୱ୍ୟାଃ ପ୍ରାଚୀନଲୋକୈଃ ପ୍ରଧାନଯାଜକୈରଧ୍ୟାପକୈଶ୍ଚ ସୋୱଜ୍ଞାଯ ହନ୍ତୱ୍ୟଃ କିନ୍ତୁ ତୃତୀଯଦିୱସେ ଶ୍ମଶାନାତ୍ ତେନୋତ୍ଥାତୱ୍ୟମ୍| ");
INSERT INTO sanori_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ଅପରଂ ସ ସର୍ୱ୍ୱାନୁୱାଚ, କଶ୍ଚିଦ୍ ଯଦି ମମ ପଶ୍ଚାଦ୍ ଗନ୍ତୁଂ ୱାଞ୍ଛତି ତର୍ହି ସ ସ୍ୱଂ ଦାମ୍ୟତୁ, ଦିନେ ଦିନେ କ୍ରୁଶଂ ଗୃହୀତ୍ୱା ଚ ମମ ପଶ୍ଚାଦାଗଚ୍ଛତୁ| ");
INSERT INTO sanori_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ଯତୋ ଯଃ କଶ୍ଚିତ୍ ସ୍ୱପ୍ରାଣାନ୍ ରିରକ୍ଷିଷତି ସ ତାନ୍ ହାରଯିଷ୍ୟତି, ଯଃ କଶ୍ଚିନ୍ ମଦର୍ଥଂ ପ୍ରାଣାନ୍ ହାରଯିଷ୍ୟତି ସ ତାନ୍ ରକ୍ଷିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","କଶ୍ଚିଦ୍ ଯଦି ସର୍ୱ୍ୱଂ ଜଗତ୍ ପ୍ରାପ୍ନୋତି କିନ୍ତୁ ସ୍ୱପ୍ରାଣାନ୍ ହାରଯତି ସ୍ୱଯଂ ୱିନଶ୍ୟତି ଚ ତର୍ହି ତସ୍ୟ କୋ ଲାଭଃ? ");
INSERT INTO sanori_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","ପୁନ ର୍ୟଃ କଶ୍ଚିନ୍ ମାଂ ମମ ୱାକ୍ୟଂ ୱା ଲଜ୍ଜାସ୍ପଦଂ ଜାନାତି ମନୁଷ୍ୟପୁତ୍ରୋ ଯଦା ସ୍ୱସ୍ୟ ପିତୁଶ୍ଚ ପୱିତ୍ରାଣାଂ ଦୂତାନାଞ୍ଚ ତେଜୋଭିଃ ପରିୱେଷ୍ଟିତ ଆଗମିଷ୍ୟତି ତଦା ସୋପି ତଂ ଲଜ୍ଜାସ୍ପଦଂ ଜ୍ଞାସ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","କିନ୍ତୁ ଯୁଷ୍ମାନହଂ ଯଥାର୍ଥଂ ୱଦାମି, ଈଶ୍ୱରୀଯରାଜତ୍ୱଂ ନ ଦୃଷ୍ଟୱା ମୃତ୍ୟୁଂ ନାସ୍ୱାଦିଷ୍ୟନ୍ତେ, ଏତାଦୃଶାଃ କିଯନ୍ତୋ ଲୋକା ଅତ୍ର ସ୍ଥନେଽପି ଦଣ୍ଡାଯମାନାଃ ସନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ଏତଦାଖ୍ୟାନକଥନାତ୍ ପରଂ ପ୍ରାଯେଣାଷ୍ଟସୁ ଦିନେଷୁ ଗତେଷୁ ସ ପିତରଂ ଯୋହନଂ ଯାକୂବଞ୍ଚ ଗୃହୀତ୍ୱା ପ୍ରାର୍ଥଯିତୁଂ ପର୍ୱ୍ୱତମେକଂ ସମାରୁରୋହ| ");
INSERT INTO sanori_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ଅଥ ତସ୍ୟ ପ୍ରାର୍ଥନକାଲେ ତସ୍ୟ ମୁଖାକୃତିରନ୍ୟରୂପା ଜାତା, ତଦୀଯଂ ୱସ୍ତ୍ରମୁଜ୍ଜ୍ୱଲଶୁକ୍ଲଂ ଜାତଂ| ");
INSERT INTO sanori_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","ଅପରଞ୍ଚ ମୂସା ଏଲିଯଶ୍ଚୋଭୌ ତେଜସ୍ୱିନୌ ଦୃଷ୍ଟୌ ");
INSERT INTO sanori_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ତୌ ତେନ ଯିରୂଶାଲମ୍ପୁରେ ଯୋ ମୃତ୍ୟୁଃ ସାଧିଷ୍ୟତେ ତଦୀଯାଂ କଥାଂ ତେନ ସାର୍ଦ୍ଧଂ କଥଯିତୁମ୍ ଆରେଭାତେ| ");
INSERT INTO sanori_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ତଦା ପିତରାଦଯଃ ସ୍ୱସ୍ୟ ସଙ୍ଗିନୋ ନିଦ୍ରଯାକୃଷ୍ଟା ଆସନ୍ କିନ୍ତୁ ଜାଗରିତ୍ୱା ତସ୍ୟ ତେଜସ୍ତେନ ସାର୍ଦ୍ଧମ୍ ଉତ୍ତିଷ୍ଠନ୍ତୌ ଜନୌ ଚ ଦଦୃଶୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","ଅଥ ତଯୋରୁଭଯୋ ର୍ଗମନକାଲେ ପିତରୋ ଯୀଶୁଂ ବଭାଷେ, ହେ ଗୁରୋଽସ୍ମାକଂ ସ୍ଥାନେଽସ୍ମିନ୍ ସ୍ଥିତିଃ ଶୁଭା, ତତ ଏକା ତ୍ୱଦର୍ଥା, ଏକା ମୂସାର୍ଥା, ଏକା ଏଲିଯାର୍ଥା, ଇତି ତିସ୍ରଃ କୁଟ୍ୟୋସ୍ମାଭି ର୍ନିର୍ମ୍ମୀଯନ୍ତାଂ, ଇମାଂ କଥାଂ ସ ନ ୱିୱିଚ୍ୟ କଥଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","ଅପରଞ୍ଚ ତଦ୍ୱାକ୍ୟୱଦନକାଲେ ପଯୋଦ ଏକ ଆଗତ୍ୟ ତେଷାମୁପରି ଛାଯାଂ ଚକାର, ତତସ୍ତନ୍ମଧ୍ୟେ ତଯୋଃ ପ୍ରୱେଶାତ୍ ତେ ଶଶଙ୍କିରେ| ");
INSERT INTO sanori_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ତଦା ତସ୍ମାତ୍ ପଯୋଦାଦ୍ ଇଯମାକାଶୀଯା ୱାଣୀ ନିର୍ଜଗାମ, ମମାଯଂ ପ୍ରିଯଃ ପୁତ୍ର ଏତସ୍ୟ କଥାଯାଂ ମନୋ ନିଧତ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ଇତି ଶବ୍ଦେ ଜାତେ ତେ ଯୀଶୁମେକାକିନଂ ଦଦୃଶୁଃ କିନ୍ତୁ ତେ ତଦାନୀଂ ତସ୍ୟ ଦର୍ଶନସ୍ୟ ୱାଚମେକାମପି ନୋକ୍ତ୍ୱା ମନଃସୁ ସ୍ଥାପଯାମାସୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","ପରେଽହନି ତେଷୁ ତସ୍ମାଚ୍ଛୈଲାଦ୍ ଅୱରୂଢେଷୁ ତଂ ସାକ୍ଷାତ୍ କର୍ତ୍ତୁଂ ବହୱୋ ଲୋକା ଆଜଗ୍ମୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ତେଷାଂ ମଧ୍ୟାଦ୍ ଏକୋ ଜନ ଉଚ୍ଚୈରୁୱାଚ, ହେ ଗୁରୋ ଅହଂ ୱିନଯଂ କରୋମି ମମ ପୁତ୍ରଂ ପ୍ରତି କୃପାଦୃଷ୍ଟିଂ କରୋତୁ, ମମ ସ ଏୱୈକଃ ପୁତ୍ରଃ| ");
INSERT INTO sanori_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ଭୂତେନ ଧୃତଃ ସନ୍ ସଂ ପ୍ରସଭଂ ଚୀଚ୍ଛବ୍ଦଂ କରୋତି ତନ୍ମୁଖାତ୍ ଫେଣା ନିର୍ଗଚ୍ଛନ୍ତି ଚ, ଭୂତ ଇତ୍ଥଂ ୱିଦାର୍ୟ୍ୟ କ୍ଲିଷ୍ଟ୍ୱା ପ୍ରାଯଶସ୍ତଂ ନ ତ୍ୟଜତି| ");
INSERT INTO sanori_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ତସ୍ମାତ୍ ତଂ ଭୂତଂ ତ୍ୟାଜଯିତୁଂ ତୱ ଶିଷ୍ୟସମୀପେ ନ୍ୟୱେଦଯଂ କିନ୍ତୁ ତେ ନ ଶେକୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ତଦା ଯୀଶୁରୱାଦୀତ୍, ରେ ଆୱିଶ୍ୱାସିନ୍ ୱିପଥଗାମିନ୍ ୱଂଶ କତିକାଲାନ୍ ଯୁଷ୍ମାଭିଃ ସହ ସ୍ଥାସ୍ୟାମ୍ୟହଂ ଯୁଷ୍ମାକମ୍ ଆଚରଣାନି ଚ ସହିଷ୍ୟେ? ତୱ ପୁତ୍ରମିହାନଯ| ");
INSERT INTO sanori_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ତତସ୍ତସ୍ମିନ୍ନାଗତମାତ୍ରେ ଭୂତସ୍ତଂ ଭୂମୌ ପାତଯିତ୍ୱା ୱିଦଦାର; ତଦା ଯୀଶୁସ୍ତମମେଧ୍ୟଂ ଭୂତଂ ତର୍ଜଯିତ୍ୱା ବାଲକଂ ସ୍ୱସ୍ଥଂ କୃତ୍ୱା ତସ୍ୟ ପିତରି ସମର୍ପଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ଈଶ୍ୱରସ୍ୟ ମହାଶକ୍ତିମ୍ ଇମାଂ ୱିଲୋକ୍ୟ ସର୍ୱ୍ୱେ ଚମଚ୍ଚକ୍ରୁଃ; ଇତ୍ଥଂ ଯୀଶୋଃ ସର୍ୱ୍ୱାଭିଃ କ୍ରିଯାଭିଃ ସର୍ୱ୍ୱୈର୍ଲୋକୈରାଶ୍ଚର୍ୟ୍ୟେ ମନ୍ୟମାନେ ସତି ସ ଶିଷ୍ୟାନ୍ ବଭାଷେ, ");
INSERT INTO sanori_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","କଥେଯଂ ଯୁଷ୍ମାକଂ କର୍ଣେଷୁ ପ୍ରୱିଶତୁ, ମନୁଷ୍ୟପୁତ୍ରୋ ମନୁଷ୍ୟାଣାଂ କରେଷୁ ସମର୍ପଯିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","କିନ୍ତୁ ତେ ତାଂ କଥାଂ ନ ବୁବୁଧିରେ, ସ୍ପଷ୍ଟତ୍ୱାଭାୱାତ୍ ତସ୍ୟା ଅଭିପ୍ରାଯସ୍ତେଷାଂ ବୋଧଗମ୍ୟୋ ନ ବଭୂୱ; ତସ୍ୟା ଆଶଯଃ କ ଇତ୍ୟପି ତେ ଭଯାତ୍ ପ୍ରଷ୍ଟୁଂ ନ ଶେକୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","ତଦନନ୍ତରଂ ତେଷାଂ ମଧ୍ୟେ କଃ ଶ୍ରେଷ୍ଠଃ କଥାମେତାଂ ଗୃହୀତ୍ୱା ତେ ମିଥୋ ୱିୱାଦଂ ଚକ୍ରୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ତତୋ ଯୀଶୁସ୍ତେଷାଂ ମନୋଭିପ୍ରାଯଂ ୱିଦିତ୍ୱା ବାଲକମେକଂ ଗୃହୀତ୍ୱା ସ୍ୱସ୍ୟ ନିକଟେ ସ୍ଥାପଯିତ୍ୱା ତାନ୍ ଜଗାଦ, ");
INSERT INTO sanori_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ଯୋ ଜନୋ ମମ ନାମ୍ନାସ୍ୟ ବାଲାସ୍ୟାତିଥ୍ୟଂ ୱିଦଧାତି ସ ମମାତିଥ୍ୟଂ ୱିଦଧାତି, ଯଶ୍ଚ ମମାତିଥ୍ୟଂ ୱିଦଧାତି ସ ମମ ପ୍ରେରକସ୍ୟାତିଥ୍ୟଂ ୱିଦଧାତି, ଯୁଷ୍ମାକଂ ମଧ୍ୟେଯଃ ସ୍ୱଂ ସର୍ୱ୍ୱସ୍ମାତ୍ କ୍ଷୁଦ୍ରଂ ଜାନୀତେ ସ ଏୱ ଶ୍ରେଷ୍ଠୋ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","ଅପରଞ୍ଚ ଯୋହନ୍ ୱ୍ୟାଜହାର ହେ ପ୍ରଭେा ତୱ ନାମ୍ନା ଭୂତାନ୍ ତ୍ୟାଜଯନ୍ତଂ ମାନୁଷମ୍ ଏକଂ ଦୃଷ୍ଟୱନ୍ତୋ ୱଯଂ, କିନ୍ତ୍ୱସ୍ମାକମ୍ ଅପଶ୍ଚାଦ୍ ଗାମିତ୍ୱାତ୍ ତଂ ନ୍ୟଷେଧାମ୍| ତଦାନୀଂ ଯୀଶୁରୁୱାଚ, ");
INSERT INTO sanori_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","ତଂ ମା ନିଷେଧତ, ଯତୋ ଯୋ ଜନୋସ୍ମାକଂ ନ ୱିପକ୍ଷଃ ସ ଏୱାସ୍ମାକଂ ସପକ୍ଷୋ ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","ଅନନ୍ତରଂ ତସ୍ୟାରୋହଣସମଯ ଉପସ୍ଥିତେ ସ ସ୍ଥିରଚେତା ଯିରୂଶାଲମଂ ପ୍ରତି ଯାତ୍ରାଂ କର୍ତ୍ତୁଂ ନିଶ୍ଚିତ୍ୟାଗ୍ରେ ଦୂତାନ୍ ପ୍ରେଷଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ତସ୍ମାତ୍ ତେ ଗତ୍ୱା ତସ୍ୟ ପ୍ରଯୋଜନୀଯଦ୍ରୱ୍ୟାଣି ସଂଗ୍ରହୀତୁଂ ଶୋମିରୋଣୀଯାନାଂ ଗ୍ରାମଂ ପ୍ରୱିୱିଶୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","କିନ୍ତୁ ସ ଯିରୂଶାଲମଂ ନଗରଂ ଯାତି ତତୋ ହେତୋ ର୍ଲୋକାସ୍ତସ୍ୟାତିଥ୍ୟଂ ନ ଚକ୍ରୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ଅତଏୱ ଯାକୂବ୍ୟୋହନୌ ତସ୍ୟ ଶିଷ୍ୟୌ ତଦ୍ ଦୃଷ୍ଟ୍ୱା ଜଗଦତୁଃ, ହେ ପ୍ରଭୋ ଏଲିଯୋ ଯଥା ଚକାର ତଥା ୱଯମପି କିଂ ଗଗଣାଦ୍ ଆଗନ୍ତୁମ୍ ଏତାନ୍ ଭସ୍ମୀକର୍ତ୍ତୁଞ୍ଚ ୱହ୍ନିମାଜ୍ଞାପଯାମଃ? ଭୱାନ୍ କିମିଚ୍ଛତି? ");
INSERT INTO sanori_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","କିନ୍ତୁ ସ ମୁଖଂ ପରାୱର୍ତ୍ୟ ତାନ୍ ତର୍ଜଯିତ୍ୱା ଗଦିତୱାନ୍ ଯୁଷ୍ମାକଂ ମନୋଭାୱଃ କଃ, ଇତି ଯୂଯଂ ନ ଜାନୀଥ| ");
INSERT INTO sanori_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ମନୁଜସୁତୋ ମନୁଜାନାଂ ପ୍ରାଣାନ୍ ନାଶଯିତୁଂ ନାଗଚ୍ଛତ୍, କିନ୍ତୁ ରକ୍ଷିତୁମ୍ ଆଗଚ୍ଛତ୍| ପଶ୍ଚାଦ୍ ଇତରଗ୍ରାମଂ ତେ ଯଯୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","ତଦନନ୍ତରଂ ପଥି ଗମନକାଲେ ଜନ ଏକସ୍ତଂ ବଭାଷେ, ହେ ପ୍ରଭୋ ଭୱାନ୍ ଯତ୍ର ଯାତି ଭୱତା ସହାହମପି ତତ୍ର ଯାସ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ତଦାନୀଂ ଯୀଶୁସ୍ତମୁୱାଚ, ଗୋମାଯୂନାଂ ଗର୍ତ୍ତା ଆସତେ, ୱିହାଯସୀଯୱିହଗାाନାଂ ନୀଡାନି ଚ ସନ୍ତି, କିନ୍ତୁ ମାନୱତନଯସ୍ୟ ଶିରଃ ସ୍ଥାପଯିତୁଂ ସ୍ଥାନଂ ନାସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ତତଃ ପରଂ ସ ଇତରଜନଂ ଜଗାଦ, ତ୍ୱଂ ମମ ପଶ୍ଚାଦ୍ ଏହି; ତତଃ ସ ଉୱାଚ, ହେ ପ୍ରଭୋ ପୂର୍ୱ୍ୱଂ ପିତରଂ ଶ୍ମଶାନେ ସ୍ଥାପଯିତୁଂ ମାମାଦିଶତୁ| ");
INSERT INTO sanori_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ତଦା ଯୀଶୁରୁୱାଚ, ମୃତା ମୃତାନ୍ ଶ୍ମଶାନେ ସ୍ଥାପଯନ୍ତୁ କିନ୍ତୁ ତ୍ୱଂ ଗତ୍ୱେଶ୍ୱରୀଯରାଜ୍ୟସ୍ୟ କଥାଂ ପ୍ରଚାରଯ| ");
INSERT INTO sanori_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ତତୋନ୍ୟଃ କଥଯାମାସ, ହେ ପ୍ରଭୋ ମଯାପି ଭୱତଃ ପଶ୍ଚାଦ୍ ଗଂସ୍ୟତେ, କିନ୍ତୁ ପୂର୍ୱ୍ୱଂ ମମ ନିୱେଶନସ୍ୟ ପରିଜନାନାମ୍ ଅନୁମତିଂ ଗ୍ରହୀତୁମ୍ ଅହମାଦିଶ୍ୟୈ ଭୱତା| ");
INSERT INTO sanori_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ତଦାନୀଂ ଯୀଶୁସ୍ତଂ ପ୍ରୋକ୍ତୱାନ୍, ଯୋ ଜନୋ ଲାଙ୍ଗଲେ କରମର୍ପଯିତ୍ୱା ପଶ୍ଚାତ୍ ପଶ୍ୟତି ସ ଈଶ୍ୱରୀଯରାଜ୍ୟଂ ନାର୍ହତି| ");
INSERT INTO sanori_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ତତଃ ପରଂ ପ୍ରଭୁରପରାନ୍ ସପ୍ତତିଶିଷ୍ୟାନ୍ ନିଯୁଜ୍ୟ ସ୍ୱଯଂ ଯାନି ନଗରାଣି ଯାନି ସ୍ଥାନାନି ଚ ଗମିଷ୍ୟତି ତାନି ନଗରାଣି ତାନି ସ୍ଥାନାନି ଚ ପ୍ରତି ଦ୍ୱୌ ଦ୍ୱୌ ଜନୌ ପ୍ରହିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ତେଭ୍ୟଃ କଥଯାମାସ ଚ ଶସ୍ୟାନି ବହୂନୀତି ସତ୍ୟଂ କିନ୍ତୁ ଛେଦକା ଅଲ୍ପେ; ତସ୍ମାଦ୍ଧେତୋଃ ଶସ୍ୟକ୍ଷେତ୍ରେ ଛେଦକାନ୍ ଅପରାନପି ପ୍ରେଷଯିତୁଂ କ୍ଷେତ୍ରସ୍ୱାମିନଂ ପ୍ରାର୍ଥଯଧ୍ୱଂ| ");
INSERT INTO sanori_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","ଯୂଯଂ ଯାତ, ପଶ୍ୟତ, ୱୃକାଣାଂ ମଧ୍ୟେ ମେଷଶାୱକାନିୱ ଯୁଷ୍ମାନ୍ ପ୍ରହିଣୋମି| ");
INSERT INTO sanori_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","ଯୂଯଂ କ୍ଷୁଦ୍ରଂ ମହଦ୍ ୱା ୱସନସମ୍ପୁଟକଂ ପାଦୁକାଶ୍ଚ ମା ଗୃହ୍ଲୀତ, ମାର୍ଗମଧ୍ୟେ କମପି ମା ନମତ ଚ| ");
INSERT INTO sanori_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","ଅପରଞ୍ଚ ଯୂଯଂ ଯଦ୍ ଯତ୍ ନିୱେଶନଂ ପ୍ରୱିଶଥ ତତ୍ର ନିୱେଶନସ୍ୟାସ୍ୟ ମଙ୍ଗଲଂ ଭୂଯାଦିତି ୱାକ୍ୟଂ ପ୍ରଥମଂ ୱଦତ| ");
INSERT INTO sanori_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","ତସ୍ମାତ୍ ତସ୍ମିନ୍ ନିୱେଶନେ ଯଦି ମଙ୍ଗଲପାତ୍ରଂ ସ୍ଥାସ୍ୟତି ତର୍ହି ତନ୍ମଙ୍ଗଲଂ ତସ୍ୟ ଭୱିଷ୍ୟତି, ନୋଚେତ୍ ଯୁଷ୍ମାନ୍ ପ୍ରତି ପରାୱର୍ତ୍ତିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","ଅପରଞ୍ଚ ତେ ଯତ୍କିଞ୍ଚିଦ୍ ଦାସ୍ୟନ୍ତି ତଦେୱ ଭୁକ୍ତ୍ୱା ପୀତ୍ୱା ତସ୍ମିନ୍ନିୱେଶନେ ସ୍ଥାସ୍ୟଥ; ଯତଃ କର୍ମ୍ମକାରୀ ଜନୋ ଭୃତିମ୍ ଅର୍ହତି; ଗୃହାଦ୍ ଗୃହଂ ମା ଯାସ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","ଅନ୍ୟଚ୍ଚ ଯୁଷ୍ମାସୁ କିମପି ନଗରଂ ପ୍ରୱିଷ୍ଟେଷୁ ଲୋକା ଯଦି ଯୁଷ୍ମାକମ୍ ଆତିଥ୍ୟଂ କରିଷ୍ୟନ୍ତି, ତର୍ହି ଯତ୍ ଖାଦ୍ୟମ୍ ଉପସ୍ଥାସ୍ୟନ୍ତି ତଦେୱ ଖାଦିଷ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ତନ୍ନଗରସ୍ଥାନ୍ ରୋଗିଣଃ ସ୍ୱସ୍ଥାନ୍ କରିଷ୍ୟଥ, ଈଶ୍ୱରୀଯଂ ରାଜ୍ୟଂ ଯୁଷ୍ମାକମ୍ ଅନ୍ତିକମ୍ ଆଗମତ୍ କଥାମେତାଞ୍ଚ ପ୍ରଚାରଯିଷ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","କିନ୍ତୁ କିମପି ପୁରଂ ଯୁଷ୍ମାସୁ ପ୍ରୱିଷ୍ଟେଷୁ ଲୋକା ଯଦି ଯୁଷ୍ମାକମ୍ ଆତିଥ୍ୟଂ ନ କରିଷ୍ୟନ୍ତି, ତର୍ହି ତସ୍ୟ ନଗରସ୍ୟ ପନ୍ଥାନଂ ଗତ୍ୱା କଥାମେତାଂ ୱଦିଷ୍ୟଥ, ");
INSERT INTO sanori_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","ଯୁଷ୍ମାକଂ ନଗରୀଯା ଯା ଧୂଲ୍ୟୋଽସ୍ମାସୁ ସମଲଗନ୍ ତା ଅପି ଯୁଷ୍ମାକଂ ପ୍ରାତିକୂଲ୍ୟେନ ସାକ୍ଷ୍ୟାର୍ଥଂ ସମ୍ପାତଯାମଃ; ତଥାପୀଶ୍ୱରରାଜ୍ୟଂ ଯୁଷ୍ମାକଂ ସମୀପମ୍ ଆଗତମ୍ ଇତି ନିଶ୍ଚିତଂ ଜାନୀତ| ");
INSERT INTO sanori_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","ଅହଂ ଯୁଷ୍ମଭ୍ୟଂ ଯଥାର୍ଥଂ କଥଯାମି, ୱିଚାରଦିନେ ତସ୍ୟ ନଗରସ୍ୟ ଦଶାତଃ ସିଦୋମୋ ଦଶା ସହ୍ୟା ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","ହା ହା କୋରାସୀନ୍ ନଗର, ହା ହା ବୈତ୍ସୈଦାନଗର ଯୁୱଯୋର୍ମଧ୍ୟେ ଯାଦୃଶାନି ଆଶ୍ଚର୍ୟ୍ୟାଣି କର୍ମ୍ମାଣ୍ୟକ୍ରିଯନ୍ତ, ତାନି କର୍ମ୍ମାଣି ଯଦି ସୋରସୀଦୋନୋ ର୍ନଗରଯୋରକାରିଷ୍ୟନ୍ତ, ତଦା ଇତୋ ବହୁଦିନପୂର୍ୱ୍ୱଂ ତନ୍ନିୱାସିନଃ ଶଣୱସ୍ତ୍ରାଣି ପରିଧାଯ ଗାତ୍ରେଷୁ ଭସ୍ମ ୱିଲିପ୍ୟ ସମୁପୱିଶ୍ୟ ସମଖେତ୍ସ୍ୟନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","ଅତୋ ୱିଚାରଦିୱସେ ଯୁଷ୍ମାକଂ ଦଶାତଃ ସୋରସୀଦୋନ୍ନିୱାସିନାଂ ଦଶା ସହ୍ୟା ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ହେ କଫର୍ନାହୂମ୍, ତ୍ୱଂ ସ୍ୱର୍ଗଂ ଯାୱଦ୍ ଉନ୍ନତା କିନ୍ତୁ ନରକଂ ଯାୱତ୍ ନ୍ୟଗ୍ଭୱିଷ୍ୟସି| ");
INSERT INTO sanori_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ଯୋ ଜନୋ ଯୁଷ୍ମାକଂ ୱାକ୍ୟଂ ଗୃହ୍ଲାତି ସ ମମୈୱ ୱାକ୍ୟଂ ଗୃହ୍ଲାତି; କିଞ୍ଚ ଯୋ ଜନୋ ଯୁଷ୍ମାକମ୍ ଅୱଜ୍ଞାଂ କରୋତି ସ ମମୈୱାୱଜ୍ଞାଂ କରୋତି; ଯୋ ଜନୋ ମମାୱଜ୍ଞାଂ କରୋତି ଚ ସ ମତ୍ପ୍ରେରକସ୍ୟୈୱାୱଜ୍ଞାଂ କରୋତି| ");
INSERT INTO sanori_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","ଅଥ ତେ ସପ୍ତତିଶିଷ୍ୟା ଆନନ୍ଦେନ ପ୍ରତ୍ୟାଗତ୍ୟ କଥଯାମାସୁଃ, ହେ ପ୍ରଭୋ ଭୱତୋ ନାମ୍ନା ଭୂତା ଅପ୍ୟସ୍ମାକଂ ୱଶୀଭୱନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ତଦାନୀଂ ସ ତାନ୍ ଜଗାଦ, ୱିଦ୍ୟୁତମିୱ ସ୍ୱର୍ଗାତ୍ ପତନ୍ତଂ ଶୈତାନମ୍ ଅଦର୍ଶମ୍| ");
INSERT INTO sanori_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","ପଶ୍ୟତ ସର୍ପାନ୍ ୱୃଶ୍ଚିକାନ୍ ରିପୋଃ ସର୍ୱ୍ୱପରାକ୍ରମାଂଶ୍ଚ ପଦତଲୈ ର୍ଦଲଯିତୁଂ ଯୁଷ୍ମଭ୍ୟଂ ଶକ୍ତିଂ ଦଦାମି ତସ୍ମାଦ୍ ଯୁଷ୍ମାକଂ କାପି ହାନି ର୍ନ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","ଭୂତା ଯୁଷ୍ମାକଂ ୱଶୀଭୱନ୍ତି, ଏତନ୍ନିମିତ୍ତତ୍ ମା ସମୁଲ୍ଲସତ, ସ୍ୱର୍ଗେ ଯୁଷ୍ମାକଂ ନାମାନି ଲିଖିତାନି ସନ୍ତୀତି ନିମିତ୍ତଂ ସମୁଲ୍ଲସତ| ");
INSERT INTO sanori_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","ତଦ୍ଘଟିକାଯାଂ ଯୀଶୁ ର୍ମନସି ଜାତାହ୍ଲାଦଃ କଥଯାମାସ ହେ ସ୍ୱର୍ଗପୃଥିୱ୍ୟୋରେକାଧିପତେ ପିତସ୍ତ୍ୱଂ ଜ୍ଞାନୱତାଂ ୱିଦୁଷାଞ୍ଚ ଲୋକାନାଂ ପୁରସ୍ତାତ୍ ସର୍ୱ୍ୱମେତଦ୍ ଅପ୍ରକାଶ୍ୟ ବାଲକାନାଂ ପୁରସ୍ତାତ୍ ପ୍ରାକାଶଯ ଏତସ୍ମାଦ୍ଧେତୋସ୍ତ୍ୱାଂ ଧନ୍ୟଂ ୱଦାମି, ହେ ପିତରିତ୍ଥଂ ଭୱତୁ ଯଦ୍ ଏତଦେୱ ତୱ ଗୋଚର ଉତ୍ତମମ୍| ");
INSERT INTO sanori_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","ପିତ୍ରା ସର୍ୱ୍ୱାଣି ମଯି ସମର୍ପିତାନି ପିତରଂ ୱିନା କୋପି ପୁତ୍ରଂ ନ ଜାନାତି କିଞ୍ଚ ପୁତ୍ରଂ ୱିନା ଯସ୍ମୈ ଜନାଯ ପୁତ୍ରସ୍ତଂ ପ୍ରକାଶିତୱାନ୍ ତଞ୍ଚ ୱିନା କୋପି ପିତରଂ ନ ଜାନାତି| ");
INSERT INTO sanori_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ତପଃ ପରଂ ସ ଶିଷ୍ୟାନ୍ ପ୍ରତି ପରାୱୃତ୍ୟ ଗୁପ୍ତଂ ଜଗାଦ, ଯୂଯମେତାନି ସର୍ୱ୍ୱାଣି ପଶ୍ୟଥ ତତୋ ଯୁଷ୍ମାକଂ ଚକ୍ଷୂଂଷି ଧନ୍ୟାନି| ");
INSERT INTO sanori_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ଯୁଷ୍ମାନହଂ ୱଦାମି, ଯୂଯଂ ଯାନି ସର୍ୱ୍ୱାଣି ପଶ୍ୟଥ ତାନି ବହୱୋ ଭୱିଷ୍ୟଦ୍ୱାଦିନୋ ଭୂପତଯଶ୍ଚ ଦ୍ରଷ୍ଟୁମିଚ୍ଛନ୍ତୋପି ଦ୍ରଷ୍ଟୁଂ ନ ପ୍ରାପ୍ନୁୱନ୍, ଯୁଷ୍ମାଭି ର୍ୟା ଯାଃ କଥାଶ୍ଚ ଶ୍ରୂଯନ୍ତେ ତାଃ ଶ୍ରୋତୁମିଚ୍ଛନ୍ତୋପି ଶ୍ରୋତୁଂ ନାଲଭନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","ଅନନ୍ତରମ୍ ଏକୋ ୱ୍ୟୱସ୍ଥାପକ ଉତ୍ଥାଯ ତଂ ପରୀକ୍ଷିତୁଂ ପପ୍ରଚ୍ଛ, ହେ ଉପଦେଶକ ଅନନ୍ତାଯୁଷଃ ପ୍ରାପ୍ତଯେ ମଯା କିଂ କରଣୀଯଂ? ");
INSERT INTO sanori_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ଯୀଶୁଃ ପ୍ରତ୍ୟୁୱାଚ, ଅତ୍ରାର୍ଥେ ୱ୍ୟୱସ୍ଥାଯାଂ କିଂ ଲିଖିତମସ୍ତି? ତ୍ୱଂ କୀଦୃକ୍ ପଠସି? ");
INSERT INTO sanori_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ତତଃ ସୋୱଦତ୍, ତ୍ୱଂ ସର୍ୱ୍ୱାନ୍ତଃକରଣୈଃ ସର୍ୱ୍ୱପ୍ରାଣୈଃ ସର୍ୱ୍ୱଶକ୍ତିଭିଃ ସର୍ୱ୍ୱଚିତ୍ତୈଶ୍ଚ ପ୍ରଭୌ ପରମେଶ୍ୱରେ ପ୍ରେମ କୁରୁ, ସମୀପୱାସିନି ସ୍ୱୱତ୍ ପ୍ରେମ କୁରୁ ଚ| ");
INSERT INTO sanori_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ତଦା ସ କଥଯାମାସ, ତ୍ୱଂ ଯଥାର୍ଥଂ ପ୍ରତ୍ୟୱୋଚଃ, ଇତ୍ଥମ୍ ଆଚର ତେନୈୱ ଜୀୱିଷ୍ୟସି| ");
INSERT INTO sanori_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","କିନ୍ତୁ ସ ଜନଃ ସ୍ୱଂ ନିର୍ଦ୍ଦୋଷଂ ଜ୍ଞାପଯିତୁଂ ଯୀଶୁଂ ପପ୍ରଚ୍ଛ, ମମ ସମୀପୱାସୀ କଃ? ତତୋ ଯୀଶୁଃ ପ୍ରତ୍ୟୁୱାଚ, ");
INSERT INTO sanori_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ଏକୋ ଜନୋ ଯିରୂଶାଲମ୍ପୁରାଦ୍ ଯିରୀହୋପୁରଂ ଯାତି, ଏତର୍ହି ଦସ୍ୟୂନାଂ କରେଷୁ ପତିତେ ତେ ତସ୍ୟ ୱସ୍ତ୍ରାଦିକଂ ହୃତୱନ୍ତଃ ତମାହତ୍ୟ ମୃତପ୍ରାଯଂ କୃତ୍ୱା ତ୍ୟକ୍ତ୍ୱା ଯଯୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ଅକସ୍ମାଦ୍ ଏକୋ ଯାଜକସ୍ତେନ ମାର୍ଗେଣ ଗଚ୍ଛନ୍ ତଂ ଦୃଷ୍ଟ୍ୱା ମାର୍ଗାନ୍ୟପାର୍ଶ୍ୱେନ ଜଗାମ| ");
INSERT INTO sanori_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ଇତ୍ଥମ୍ ଏକୋ ଲେୱୀଯସ୍ତତ୍ସ୍ଥାନଂ ପ୍ରାପ୍ୟ ତସ୍ୟାନ୍ତିକଂ ଗତ୍ୱା ତଂ ୱିଲୋକ୍ୟାନ୍ୟେନ ପାର୍ଶ୍ୱେନ ଜଗାମ| ");
INSERT INTO sanori_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","କିନ୍ତ୍ୱେକଃ ଶୋମିରୋଣୀଯୋ ଗଚ୍ଛନ୍ ତତ୍ସ୍ଥାନଂ ପ୍ରାପ୍ୟ ତଂ ଦୃଷ୍ଟ୍ୱାଦଯତ| ");
INSERT INTO sanori_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ତସ୍ୟାନ୍ତିକଂ ଗତ୍ୱା ତସ୍ୟ କ୍ଷତେଷୁ ତୈଲଂ ଦ୍ରାକ୍ଷାରସଞ୍ଚ ପ୍ରକ୍ଷିପ୍ୟ କ୍ଷତାନି ବଦ୍ଧ୍ୱା ନିଜୱାହନୋପରି ତମୁପୱେଶ୍ୟ ପ୍ରୱାସୀଯଗୃହମ୍ ଆନୀଯ ତଂ ସିଷେୱେ| ");
INSERT INTO sanori_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","ପରସ୍ମିନ୍ ଦିୱସେ ନିଜଗମନକାଲେ ଦ୍ୱୌ ମୁଦ୍ରାପାଦୌ ତଦ୍ଗୃହସ୍ୱାମିନେ ଦତ୍ତ୍ୱାୱଦତ୍ ଜନମେନଂ ସେୱସ୍ୱ ତତ୍ର ଯୋଽଧିକୋ ୱ୍ୟଯୋ ଭୱିଷ୍ୟତି ତମହଂ ପୁନରାଗମନକାଲେ ପରିଶୋତ୍ସ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","ଏଷାଂ ତ୍ରଯାଣାଂ ମଧ୍ୟେ ତସ୍ୟ ଦସ୍ୟୁହସ୍ତପତିତସ୍ୟ ଜନସ୍ୟ ସମୀପୱାସୀ କଃ? ତ୍ୱଯା କିଂ ବୁଧ୍ୟତେ? ");
INSERT INTO sanori_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ତତଃ ସ ୱ୍ୟୱସ୍ଥାପକଃ କଥଯାମାସ ଯସ୍ତସ୍ମିନ୍ ଦଯାଂ ଚକାର| ତଦା ଯୀଶୁଃ କଥଯାମାସ ତ୍ୱମପି ଗତ୍ୱା ତଥାଚର| ");
INSERT INTO sanori_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","ତତଃ ପରଂ ତେ ଗଚ୍ଛନ୍ତ ଏକଂ ଗ୍ରାମଂ ପ୍ରୱିୱିଶୁଃ; ତଦା ମର୍ଥାନାମା ସ୍ତ୍ରୀ ସ୍ୱଗୃହେ ତସ୍ୟାତିଥ୍ୟଂ ଚକାର| ");
INSERT INTO sanori_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","ତସ୍ମାତ୍ ମରିଯମ୍ ନାମଧେଯା ତସ୍ୟା ଭଗିନୀ ଯୀଶୋଃ ପଦସମୀପ ଉୱୱିଶ୍ୟ ତସ୍ୟୋପଦେଶକଥାଂ ଶ୍ରୋତୁମାରେଭେ| ");
INSERT INTO sanori_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","କିନ୍ତୁ ମର୍ଥା ନାନାପରିଚର୍ୟ୍ୟାଯାଂ ୱ୍ୟଗ୍ରା ବଭୂୱ ତସ୍ମାଦ୍ଧେତୋସ୍ତସ୍ୟ ସମୀପମାଗତ୍ୟ ବଭାଷେ; ହେ ପ୍ରଭୋ ମମ ଭଗିନୀ କେୱଲଂ ମମୋପରି ସର୍ୱ୍ୱକର୍ମ୍ମଣାଂ ଭାରମ୍ ଅର୍ପିତୱତୀ ତତ୍ର ଭୱତା କିଞ୍ଚିଦପି ନ ମନୋ ନିଧୀଯତେ କିମ୍? ମମ ସାହାଯ୍ୟଂ କର୍ତ୍ତୁଂ ଭୱାନ୍ ତାମାଦିଶତୁ| ");
INSERT INTO sanori_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ତତୋ ଯୀଶୁଃ ପ୍ରତ୍ୟୁୱାଚ ହେ ମର୍ଥେ ହେ ମର୍ଥେ, ତ୍ୱଂ ନାନାକାର୍ୟ୍ୟେଷୁ ଚିନ୍ତିତୱତୀ ୱ୍ୟଗ୍ରା ଚାସି, ");
INSERT INTO sanori_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","କିନ୍ତୁ ପ୍ରଯୋଜନୀଯମ୍ ଏକମାତ୍ରମ୍ ଆସ୍ତେ| ଅପରଞ୍ଚ ଯମୁତ୍ତମଂ ଭାଗଂ କୋପି ହର୍ତ୍ତୁଂ ନ ଶକ୍ନୋତି ସଏୱ ମରିଯମା ୱୃତଃ| ");
INSERT INTO sanori_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","ଅନନ୍ତରଂ ସ କସ୍ମିଂଶ୍ଚିତ୍ ସ୍ଥାନେ ପ୍ରାର୍ଥଯତ ତତ୍ସମାପ୍ତୌ ସତ୍ୟାଂ ତସ୍ୟୈକଃ ଶିଷ୍ୟସ୍ତଂ ଜଗାଦ ହେ ପ୍ରଭୋ ଯୋହନ୍ ଯଥା ସ୍ୱଶିଷ୍ୟାନ୍ ପ୍ରାର୍ଥଯିତୁମ୍ ଉପଦିଷ୍ଟୱାନ୍ ତଥା ଭୱାନପ୍ୟସ୍ମାନ୍ ଉପଦିଶତୁ| ");
INSERT INTO sanori_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","ତସ୍ମାତ୍ ସ କଥଯାମାସ, ପ୍ରାର୍ଥନକାଲେ ଯୂଯମ୍ ଇତ୍ଥଂ କଥଯଧ୍ୱଂ, ହେ ଅସ୍ମାକଂ ସ୍ୱର୍ଗସ୍ଥପିତସ୍ତୱ ନାମ ପୂଜ୍ୟଂ ଭୱତୁ; ତୱ ରାଜତ୍ୱଂ ଭୱତୁ; ସ୍ୱର୍ଗେ ଯଥା ତଥା ପୃଥିୱ୍ୟାମପି ତୱେଚ୍ଛଯା ସର୍ୱ୍ୱଂ ଭୱତୁ| ");
INSERT INTO sanori_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ପ୍ରତ୍ୟହମ୍ ଅସ୍ମାକଂ ପ୍ରଯୋଜନୀଯଂ ଭୋଜ୍ୟଂ ଦେହି| ");
INSERT INTO sanori_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ଯଥା ୱଯଂ ସର୍ୱ୍ୱାନ୍ ଅପରାଧିନଃ କ୍ଷମାମହେ ତଥା ତ୍ୱମପି ପାପାନ୍ୟସ୍ମାକଂ କ୍ଷମସ୍ୱ| ଅସ୍ମାନ୍ ପରୀକ୍ଷାଂ ମାନଯ କିନ୍ତୁ ପାପାତ୍ମନୋ ରକ୍ଷ| ");
INSERT INTO sanori_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ପଶ୍ଚାତ୍ ସୋପରମପି କଥିତୱାନ୍ ଯଦି ଯୁଷ୍ମାକଂ କସ୍ୟଚିଦ୍ ବନ୍ଧୁସ୍ତିଷ୍ଠତି ନିଶୀଥେ ଚ ତସ୍ୟ ସମୀପଂ ସ ଗତ୍ୱା ୱଦତି, ");
INSERT INTO sanori_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ହେ ବନ୍ଧୋ ପଥିକ ଏକୋ ବନ୍ଧୁ ର୍ମମ ନିୱେଶନମ୍ ଆଯାତଃ କିନ୍ତୁ ତସ୍ୟାତିଥ୍ୟଂ କର୍ତ୍ତୁଂ ମମାନ୍ତିକେ କିମପି ନାସ୍ତି, ଅତଏୱ ପୂପତ୍ରଯଂ ମହ୍ୟମ୍ ଋଣଂ ଦେହି; ");
INSERT INTO sanori_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ତଦା ସ ଯଦି ଗୃହମଧ୍ୟାତ୍ ପ୍ରତିୱଦତି ମାଂ ମା କ୍ଲିଶାନ, ଇଦାନୀଂ ଦ୍ୱାରଂ ରୁଦ୍ଧଂ ଶଯନେ ମଯା ସହ ବାଲକାଶ୍ଚ ତିଷ୍ଠନ୍ତି ତୁଭ୍ୟଂ ଦାତୁମ୍ ଉତ୍ଥାତୁଂ ନ ଶକ୍ନୋମି, ");
INSERT INTO sanori_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","ତର୍ହି ଯୁଷ୍ମାନହଂ ୱଦାମି, ସ ଯଦି ମିତ୍ରତଯା ତସ୍ମୈ କିମପି ଦାତୁଂ ନୋତ୍ତିଷ୍ଠତି ତଥାପି ୱାରଂ ୱାରଂ ପ୍ରାର୍ଥନାତ ଉତ୍ଥାପିତଃ ସନ୍ ଯସ୍ମିନ୍ ତସ୍ୟ ପ୍ରଯୋଜନଂ ତଦେୱ ଦାସ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","ଅତଃ କାରଣାତ୍ କଥଯାମି, ଯାଚଧ୍ୱଂ ତତୋ ଯୁଷ୍ମଭ୍ୟଂ ଦାସ୍ୟତେ, ମୃଗଯଧ୍ୱଂ ତତ ଉଦ୍ଦେଶଂ ପ୍ରାପ୍ସ୍ୟଥ, ଦ୍ୱାରମ୍ ଆହତ ତତୋ ଯୁଷ୍ମଭ୍ୟଂ ଦ୍ୱାରଂ ମୋକ୍ଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","ଯୋ ଯାଚତେ ସ ପ୍ରାପ୍ନୋତି, ଯୋ ମୃଗଯତେ ସ ଏୱୋଦ୍ଦେଶଂ ପ୍ରାପ୍ନୋତି, ଯୋ ଦ୍ୱାରମ୍ ଆହନ୍ତି ତଦର୍ଥଂ ଦ୍ୱାରଂ ମୋଚ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","ପୁତ୍ରେଣ ପୂପେ ଯାଚିତେ ତସ୍ମୈ ପାଷାଣଂ ଦଦାତି ୱା ମତ୍ସ୍ୟେ ଯାଚିତେ ତସ୍ମୈ ସର୍ପଂ ଦଦାତି ");
INSERT INTO sanori_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ୱା ଅଣ୍ଡେ ଯାଚିତେ ତସ୍ମୈ ୱୃଶ୍ଚିକଂ ଦଦାତି ଯୁଷ୍ମାକଂ ମଧ୍ୟେ କ ଏତାଦୃଶଃ ପିତାସ୍ତେ? ");
INSERT INTO sanori_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ତସ୍ମାଦେୱ ଯୂଯମଭଦ୍ରା ଅପି ଯଦି ସ୍ୱସ୍ୱବାଲକେଭ୍ୟ ଉତ୍ତମାନି ଦ୍ରୱ୍ୟାଣି ଦାତୁଂ ଜାନୀଥ ତର୍ହ୍ୟସ୍ମାକଂ ସ୍ୱର୍ଗସ୍ଥଃ ପିତା ନିଜଯାଚକେଭ୍ୟଃ କିଂ ପୱିତ୍ରମ୍ ଆତ୍ମାନଂ ନ ଦାସ୍ୟତି? ");
INSERT INTO sanori_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","ଅନନ୍ତରଂ ଯୀଶୁନା କସ୍ମାଚ୍ଚିଦ୍ ଏକସ୍ମିନ୍ ମୂକଭୂତେ ତ୍ୟାଜିତେ ସତି ସ ଭୂତତ୍ୟକ୍ତୋ ମାନୁଷୋ ୱାକ୍ୟଂ ୱକ୍ତୁମ୍ ଆରେଭେ; ତତୋ ଲୋକାଃ ସକଲା ଆଶ୍ଚର୍ୟ୍ୟଂ ମେନିରେ| ");
INSERT INTO sanori_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","କିନ୍ତୁ ତେଷାଂ କେଚିଦୂଚୁ ର୍ଜନୋଯଂ ବାଲସିବୂବା ଅର୍ଥାଦ୍ ଭୂତରାଜେନ ଭୂତାନ୍ ତ୍ୟାଜଯତି| ");
INSERT INTO sanori_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ତଂ ପରୀକ୍ଷିତୁଂ କେଚିଦ୍ ଆକାଶୀଯମ୍ ଏକଂ ଚିହ୍ନଂ ଦର୍ଶଯିତୁଂ ତଂ ପ୍ରାର୍ଥଯାଞ୍ଚକ୍ରିରେ| ");
INSERT INTO sanori_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","ତଦା ସ ତେଷାଂ ମନଃକଲ୍ପନାଂ ଜ୍ଞାତ୍ୱା କଥଯାମାସ, କସ୍ୟଚିଦ୍ ରାଜ୍ୟସ୍ୟ ଲୋକା ଯଦି ପରସ୍ପରଂ ୱିରୁନ୍ଧନ୍ତି ତର୍ହି ତଦ୍ ରାଜ୍ୟମ୍ ନଶ୍ୟତି; କେଚିଦ୍ ଗୃହସ୍ଥା ଯଦି ପରସ୍ପରଂ ୱିରୁନ୍ଧନ୍ତି ତର୍ହି ତେପି ନଶ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","ତଥୈୱ ଶୈତାନପି ସ୍ୱଲୋକାନ୍ ଯଦି ୱିରୁଣଦ୍ଧି ତଦା ତସ୍ୟ ରାଜ୍ୟଂ କଥଂ ସ୍ଥାସ୍ୟତି? ବାଲସିବୂବାହଂ ଭୂତାନ୍ ତ୍ୟାଜଯାମି ଯୂଯମିତି ୱଦଥ| ");
INSERT INTO sanori_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ଯଦ୍ୟହଂ ବାଲସିବୂବା ଭୂତାନ୍ ତ୍ୟାଜଯାମି ତର୍ହି ଯୁଷ୍ମାକଂ ସନ୍ତାନାଃ କେନ ତ୍ୟାଜଯନ୍ତି? ତସ୍ମାତ୍ ତଏୱ କଥାଯା ଏତସ୍ୟା ୱିଚାରଯିତାରୋ ଭୱିଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","କିନ୍ତୁ ଯଦ୍ୟହମ୍ ଈଶ୍ୱରସ୍ୟ ପରାକ୍ରମେଣ ଭୂତାନ୍ ତ୍ୟାଜଯାମି ତର୍ହି ଯୁଷ୍ମାକଂ ନିକଟମ୍ ଈଶ୍ୱରସ୍ୟ ରାଜ୍ୟମୱଶ୍ୟମ୍ ଉପତିଷ୍ଠତି| ");
INSERT INTO sanori_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","ବଲୱାନ୍ ପୁମାନ୍ ସୁସଜ୍ଜମାନୋ ଯତିକାଲଂ ନିଜାଟ୍ଟାଲିକାଂ ରକ୍ଷତି ତତିକାଲଂ ତସ୍ୟ ଦ୍ରୱ୍ୟଂ ନିରୁପଦ୍ରୱଂ ତିଷ୍ଠତି| ");
INSERT INTO sanori_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","କିନ୍ତୁ ତସ୍ମାଦ୍ ଅଧିକବଲଃ କଶ୍ଚିଦାଗତ୍ୟ ଯଦି ତଂ ଜଯତି ତର୍ହି ଯେଷୁ ଶସ୍ତ୍ରାସ୍ତ୍ରେଷୁ ତସ୍ୟ ୱିଶ୍ୱାସ ଆସୀତ୍ ତାନି ସର୍ୱ୍ୱାଣି ହୃତ୍ୱା ତସ୍ୟ ଦ୍ରୱ୍ୟାଣି ଗୃହ୍ଲାତି| ");
INSERT INTO sanori_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","ଅତଃ କାରଣାଦ୍ ଯୋ ମମ ସପକ୍ଷୋ ନ ସ ୱିପକ୍ଷଃ, ଯୋ ମଯା ସହ ନ ସଂଗୃହ୍ଲାତି ସ ୱିକିରତି| ");
INSERT INTO sanori_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","ଅପରଞ୍ଚ ଅମେଧ୍ୟଭୂତୋ ମାନୁଷସ୍ୟାନ୍ତର୍ନିର୍ଗତ୍ୟ ଶୁଷ୍କସ୍ଥାନେ ଭ୍ରାନ୍ତ୍ୱା ୱିଶ୍ରାମଂ ମୃଗଯତେ କିନ୍ତୁ ନ ପ୍ରାପ୍ୟ ୱଦତି ମମ ଯସ୍ମାଦ୍ ଗୃହାଦ୍ ଆଗତୋହଂ ପୁନସ୍ତଦ୍ ଗୃହଂ ପରାୱୃତ୍ୟ ଯାମି| ");
INSERT INTO sanori_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ତତୋ ଗତ୍ୱା ତଦ୍ ଗୃହଂ ମାର୍ଜିତଂ ଶୋଭିତଞ୍ଚ ଦୃଷ୍ଟ୍ୱା ");
INSERT INTO sanori_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ତତ୍କ୍ଷଣମ୍ ଅପଗତ୍ୟ ସ୍ୱସ୍ମାଦପି ଦୁର୍ମ୍ମତୀନ୍ ଅପରାନ୍ ସପ୍ତଭୂତାନ୍ ସହାନଯତି ତେ ଚ ତଦ୍ଗୃହଂ ପୱିଶ୍ୟ ନିୱସନ୍ତି| ତସ୍ମାତ୍ ତସ୍ୟ ମନୁଷ୍ୟସ୍ୟ ପ୍ରଥମଦଶାତଃ ଶେଷଦଶା ଦୁଃଖତରା ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","ଅସ୍ୟାଃ କଥାଯାଃ କଥନକାଲେ ଜନତାମଧ୍ୟସ୍ଥା କାଚିନ୍ନାରୀ ତମୁଚ୍ଚୈଃସ୍ୱରଂ ପ୍ରୋୱାଚ, ଯା ଯୋଷିତ୍ ତ୍ୱାଂ ଗର୍ବ୍ଭେଽଧାରଯତ୍ ସ୍ତନ୍ୟମପାଯଯଚ୍ଚ ସୈୱ ଧନ୍ୟା| ");
INSERT INTO sanori_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","କିନ୍ତୁ ସୋକଥଯତ୍ ଯେ ପରମେଶ୍ୱରସ୍ୟ କଥାଂ ଶ୍ରୁତ୍ୱା ତଦନୁରୂପମ୍ ଆଚରନ୍ତି ତଏୱ ଧନ୍ୟାଃ| ");
INSERT INTO sanori_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","ତତଃ ପରଂ ତସ୍ୟାନ୍ତିକେ ବହୁଲୋକାନାଂ ସମାଗମେ ଜାତେ ସ ୱକ୍ତୁମାରେଭେ, ଆଧୁନିକା ଦୁଷ୍ଟଲୋକାଶ୍ଚିହ୍ନଂ ଦ୍ରଷ୍ଟୁମିଚ୍ଛନ୍ତି କିନ୍ତୁ ଯୂନସ୍ଭୱିଷ୍ୟଦ୍ୱାଦିନଶ୍ଚିହ୍ନଂ ୱିନାନ୍ୟତ୍ କିଞ୍ଚିଚ୍ଚିହ୍ନଂ ତାନ୍ ନ ଦର୍ଶଯିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","ଯୂନସ୍ ତୁ ଯଥା ନୀନିୱୀଯଲୋକାନାଂ ସମୀପେ ଚିହ୍ନରୂପୋଭୱତ୍ ତଥା ୱିଦ୍ୟମାନଲୋକାନାମ୍ ଏଷାଂ ସମୀପେ ମନୁଷ୍ୟପୁତ୍ରୋପି ଚିହ୍ନରୂପୋ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ୱିଚାରସମଯେ ଇଦାନୀନ୍ତନଲୋକାନାଂ ପ୍ରାତିକୂଲ୍ୟେନ ଦକ୍ଷିଣଦେଶୀଯା ରାଜ୍ଞୀ ପ୍ରୋତ୍ଥାଯ ତାନ୍ ଦୋଷିଣଃ କରିଷ୍ୟତି, ଯତଃ ସା ରାଜ୍ଞୀ ସୁଲେମାନ ଉପଦେଶକଥାଂ ଶ୍ରୋତୁଂ ପୃଥିୱ୍ୟାଃ ସୀମାତ ଆଗଚ୍ଛତ୍ କିନ୍ତୁ ପଶ୍ୟତ ସୁଲେମାନୋପି ଗୁରୁତର ଏକୋ ଜନୋଽସ୍ମିନ୍ ସ୍ଥାନେ ୱିଦ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","ଅପରଞ୍ଚ ୱିଚାରସମଯେ ନୀନିୱୀଯଲୋକା ଅପି ୱର୍ତ୍ତମାନକାଲିକାନାଂ ଲୋକାନାଂ ୱୈପରୀତ୍ୟେନ ପ୍ରୋତ୍ଥାଯ ତାନ୍ ଦୋଷିଣଃ କରିଷ୍ୟନ୍ତି, ଯତୋ ହେତୋସ୍ତେ ଯୂନସୋ ୱାକ୍ୟାତ୍ ଚିତ୍ତାନି ପରିୱର୍ତ୍ତଯାମାସୁଃ କିନ୍ତୁ ପଶ୍ୟତ ଯୂନସୋତିଗୁରୁତର ଏକୋ ଜନୋଽସ୍ମିନ୍ ସ୍ଥାନେ ୱିଦ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","ପ୍ରଦୀପଂ ପ୍ରଜ୍ୱାଲ୍ୟ ଦ୍ରୋଣସ୍ୟାଧଃ କୁତ୍ରାପି ଗୁପ୍ତସ୍ଥାନେ ୱା କୋପି ନ ସ୍ଥାପଯତି କିନ୍ତୁ ଗୃହପ୍ରୱେଶିଭ୍ୟୋ ଦୀପ୍ତିଂ ଦାତଂ ଦୀପାଧାରୋପର୍ୟ୍ୟେୱ ସ୍ଥାପଯତି| ");
INSERT INTO sanori_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","ଦେହସ୍ୟ ପ୍ରଦୀପଶ୍ଚକ୍ଷୁସ୍ତସ୍ମାଦେୱ ଚକ୍ଷୁ ର୍ୟଦି ପ୍ରସନ୍ନଂ ଭୱତି ତର୍ହି ତୱ ସର୍ୱ୍ୱଶରୀରଂ ଦୀପ୍ତିମଦ୍ ଭୱିଷ୍ୟତି କିନ୍ତୁ ଚକ୍ଷୁ ର୍ୟଦି ମଲୀମସଂ ତିଷ୍ଠତି ତର୍ହି ସର୍ୱ୍ୱଶରୀରଂ ସାନ୍ଧକାରଂ ସ୍ଥାସ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","ଅସ୍ମାତ୍ କାରଣାତ୍ ତୱାନ୍ତଃସ୍ଥଂ ଜ୍ୟୋତି ର୍ୟଥାନ୍ଧକାରମଯଂ ନ ଭୱତି ତଦର୍ଥେ ସାୱଧାନୋ ଭୱ| ");
INSERT INTO sanori_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","ଯତଃ ଶରୀରସ୍ୟ କୁତ୍ରାପ୍ୟଂଶେ ସାନ୍ଧକାରେ ନ ଜାତେ ସର୍ୱ୍ୱଂ ଯଦି ଦୀପ୍ତିମତ୍ ତିଷ୍ଠତି ତର୍ହି ତୁଭ୍ୟଂ ଦୀପ୍ତିଦାଯିପ୍ରୋଜ୍ଜ୍ୱଲନ୍ ପ୍ରଦୀପ ଇୱ ତୱ ସୱର୍ୱଶରୀରଂ ଦୀପ୍ତିମଦ୍ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ଏତତ୍କଥାଯାଃ କଥନକାଲେ ଫିରୁଶ୍ୟେକୋ ଭେଜନାଯ ତଂ ନିମନ୍ତ୍ରଯାମାସ, ତତଃ ସ ଗତ୍ୱା ଭୋକ୍ତୁମ୍ ଉପୱିୱେଶ| ");
INSERT INTO sanori_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","କିନ୍ତୁ ଭୋଜନାତ୍ ପୂର୍ୱ୍ୱଂ ନାମାଙ୍କ୍ଷୀତ୍ ଏତଦ୍ ଦୃଷ୍ଟ୍ୱା ସ ଫିରୁଶ୍ୟାଶ୍ଚର୍ୟ୍ୟଂ ମେନେ| ");
INSERT INTO sanori_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","ତଦା ପ୍ରଭୁସ୍ତଂ ପ୍ରୋୱାଚ ଯୂଯଂ ଫିରୂଶିଲୋକାଃ ପାନପାତ୍ରାଣାଂ ଭୋଜନପାତ୍ରାଣାଞ୍ଚ ବହିଃ ପରିଷ୍କୁରୁଥ କିନ୍ତୁ ଯୁଷ୍ମାକମନ୍ତ ର୍ଦୌରାତ୍ମ୍ୟୈ ର୍ଦୁଷ୍କ୍ରିଯାଭିଶ୍ଚ ପରିପୂର୍ଣଂ ତିଷ୍ଠତି| ");
INSERT INTO sanori_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ହେ ସର୍ୱ୍ୱେ ନିର୍ବୋଧା ଯୋ ବହିଃ ସସର୍ଜ ସ ଏୱ କିମନ୍ତ ର୍ନ ସସର୍ଜ? ");
INSERT INTO sanori_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","ତତ ଏୱ ଯୁଷ୍ମାଭିରନ୍ତଃକରଣଂ (ଈଶ୍ୱରାଯ) ନିୱେଦ୍ୟତାଂ ତସ୍ମିନ୍ କୃତେ ଯୁଷ୍ମାକଂ ସର୍ୱ୍ୱାଣି ଶୁଚିତାଂ ଯାସ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","କିନ୍ତୁ ହନ୍ତ ଫିରୂଶିଗଣା ଯୂଯଂ ନ୍ୟାଯମ୍ ଈଶ୍ୱରେ ପ୍ରେମ ଚ ପରିତ୍ୟଜ୍ୟ ପୋଦିନାଯା ଅରୁଦାଦୀନାଂ ସର୍ୱ୍ୱେଷାଂ ଶାକାନାଞ୍ଚ ଦଶମାଂଶାନ୍ ଦତ୍ଥ କିନ୍ତୁ ପ୍ରଥମଂ ପାଲଯିତ୍ୱା ଶେଷସ୍ୟାଲଙ୍ଘନଂ ଯୁଷ୍ମାକମ୍ ଉଚିତମାସୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","ହା ହା ଫିରୂଶିନୋ ଯୂଯଂ ଭଜନଗେହେ ପ୍ରୋଚ୍ଚାସନେ ଆପଣେଷୁ ଚ ନମସ୍କାରେଷୁ ପ୍ରୀଯଧ୍ୱେ| ");
INSERT INTO sanori_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","ୱତ କପଟିନୋଽଧ୍ୟାପକାଃ ଫିରୂଶିନଶ୍ଚ ଲୋକାଯତ୍ ଶ୍ମଶାନମ୍ ଅନୁପଲଭ୍ୟ ତଦୁପରି ଗଚ୍ଛନ୍ତି ଯୂଯମ୍ ତାଦୃଗପ୍ରକାଶିତଶ୍ମଶାନୱାଦ୍ ଭୱଥ| ");
INSERT INTO sanori_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ତଦାନୀଂ ୱ୍ୟୱସ୍ଥାପକାନାମ୍ ଏକା ଯୀଶୁମୱଦତ୍, ହେ ଉପଦେଶକ ୱାକ୍ୟେନେଦୃଶେନାସ୍ମାସ୍ୱପି ଦୋଷମ୍ ଆରୋପଯସି| ");
INSERT INTO sanori_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ତତଃ ସ ଉୱାଚ, ହା ହା ୱ୍ୟୱସ୍ଥାପକା ଯୂଯମ୍ ମାନୁଷାଣାମ୍ ଉପରି ଦୁଃସହ୍ୟାନ୍ ଭାରାନ୍ ନ୍ୟସ୍ୟଥ କିନ୍ତୁ ସ୍ୱଯମ୍ ଏକାଙ୍ଗୁुଲ୍ୟାପି ତାନ୍ ଭାରାନ୍ ନ ସ୍ପୃଶଥ| ");
INSERT INTO sanori_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","ହନ୍ତ ଯୁଷ୍ମାକଂ ପୂର୍ୱ୍ୱପୁରୁଷା ଯାନ୍ ଭୱିଷ୍ୟଦ୍ୱାଦିନୋଽୱଧିଷୁସ୍ତେଷାଂ ଶ୍ମଶାନାନି ଯୂଯଂ ନିର୍ମ୍ମାଥ| ");
INSERT INTO sanori_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","ତେନୈୱ ଯୂଯଂ ସ୍ୱପୂର୍ୱ୍ୱପୁରୁଷାଣାଂ କର୍ମ୍ମାଣି ସଂମନ୍ୟଧ୍ୱେ ତଦେୱ ସପ୍ରମାଣଂ କୁରୁଥ ଚ, ଯତସ୍ତେ ତାନୱଧିଷୁଃ ଯୂଯଂ ତେଷାଂ ଶ୍ମଶାନାନି ନିର୍ମ୍ମାଥ| ");
INSERT INTO sanori_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ଅତଏୱ ଈଶ୍ୱରସ୍ୟ ଶାସ୍ତ୍ରେ ପ୍ରୋକ୍ତମସ୍ତି ତେଷାମନ୍ତିକେ ଭୱିଷ୍ୟଦ୍ୱାଦିନଃ ପ୍ରେରିତାଂଶ୍ଚ ପ୍ରେଷଯିଷ୍ୟାମି ତତସ୍ତେ ତେଷାଂ କାଂଶ୍ଚନ ହନିଷ୍ୟନ୍ତି କାଂଶ୍ଚନ ତାଡଶ୍ଷ୍ୟିନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ଏତସ୍ମାତ୍ କାରଣାତ୍ ହାବିଲଃ ଶୋଣିତପାତମାରଭ୍ୟ ମନ୍ଦିରଯଜ୍ଞୱେଦ୍ୟୋ ର୍ମଧ୍ୟେ ହତସ୍ୟ ସିଖରିଯସ୍ୟ ରକ୍ତପାତପର୍ୟ୍ୟନ୍ତଂ ");
INSERT INTO sanori_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ଜଗତଃ ସୃଷ୍ଟିମାରଭ୍ୟ ପୃଥିୱ୍ୟାଂ ଭୱିଷ୍ୟଦ୍ୱାଦିନାଂ ଯତିରକ୍ତପାତା ଜାତାସ୍ତତୀନାମ୍ ଅପରାଧଦଣ୍ଡା ଏଷାଂ ୱର୍ତ୍ତମାନଲୋକାନାଂ ଭୱିଷ୍ୟନ୍ତି, ଯୁଷ୍ମାନହଂ ନିଶ୍ଚିତଂ ୱଦାମି ସର୍ୱ୍ୱେ ଦଣ୍ଡା ୱଂଶସ୍ୟାସ୍ୟ ଭୱିଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","ହା ହା ୱ୍ୟୱସ୍ଥପକା ଯୂଯଂ ଜ୍ଞାନସ୍ୟ କୁଞ୍ଚିକାଂ ହୃତ୍ୱା ସ୍ୱଯଂ ନ ପ୍ରୱିଷ୍ଟା ଯେ ପ୍ରୱେଷ୍ଟୁଞ୍ଚ ପ୍ରଯାସିନସ୍ତାନପି ପ୍ରୱେଷ୍ଟୁଂ ୱାରିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ଇତ୍ଥଂ କଥାକଥନାଦ୍ ଅଧ୍ୟାପକାଃ ଫିରୂଶିନଶ୍ଚ ସତର୍କାଃ ");
INSERT INTO sanori_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ସନ୍ତସ୍ତମପୱଦିତୁଂ ତସ୍ୟ କଥାଯା ଦୋଷଂ ଧର୍ତ୍ତମିଚ୍ଛନ୍ତୋ ନାନାଖ୍ୟାନକଥନାଯ ତଂ ପ୍ରୱର୍ତ୍ତଯିତୁଂ କୋପଯିତୁଞ୍ଚ ପ୍ରାରେଭିରେ| ");
INSERT INTO sanori_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","ତଦାନୀଂ ଲୋକାଃ ସହସ୍ରଂ ସହସ୍ରମ୍ ଆଗତ୍ୟ ସମୁପସ୍ଥିତାସ୍ତତ ଏକୈକୋ ଽନ୍ୟେଷାମୁପରି ପତିତୁମ୍ ଉପଚକ୍ରମେ; ତଦା ଯୀଶୁଃ ଶିଷ୍ୟାନ୍ ବଭାଷେ, ଯୂଯଂ ଫିରୂଶିନାଂ କିଣ୍ୱରୂପକାପଟ୍ୟେ ୱିଶେଷେଣ ସାୱଧାନାସ୍ତିଷ୍ଠତ| ");
INSERT INTO sanori_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","ଯତୋ ଯନ୍ନ ପ୍ରକାଶଯିଷ୍ୟତେ ତଦାଚ୍ଛନ୍ନଂ ୱସ୍ତୁ କିମପି ନାସ୍ତି; ତଥା ଯନ୍ନ ଜ୍ଞାସ୍ୟତେ ତଦ୍ ଗୁପ୍ତଂ ୱସ୍ତୁ କିମପି ନାସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","ଅନ୍ଧକାରେ ତିଷ୍ଠନତୋ ଯାଃ କଥା ଅକଥଯତ ତାଃ ସର୍ୱ୍ୱାଃ କଥା ଦୀପ୍ତୌ ଶ୍ରୋଷ୍ୟନ୍ତେ ନିର୍ଜନେ କର୍ଣେ ଚ ଯଦକଥଯତ ଗୃହପୃଷ୍ଠାତ୍ ତତ୍ ପ୍ରଚାରଯିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","ହେ ବନ୍ଧୱୋ ଯୁଷ୍ମାନହଂ ୱଦାମି, ଯେ ଶରୀରସ୍ୟ ନାଶଂ ୱିନା କିମପ୍ୟପରଂ କର୍ତ୍ତୁଂ ନ ଶକ୍ରୁୱନ୍ତି ତେଭ୍ୟୋ ମା ଭୈଷ୍ଟ| ");
INSERT INTO sanori_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","ତର୍ହି କସ୍ମାଦ୍ ଭେତୱ୍ୟମ୍ ଇତ୍ୟହଂ ୱଦାମି, ଯଃ ଶରୀରଂ ନାଶଯିତ୍ୱା ନରକଂ ନିକ୍ଷେପ୍ତୁଂ ଶକ୍ନୋତି ତସ୍ମାଦେୱ ଭଯଂ କୁରୁତ, ପୁନରପି ୱଦାମି ତସ୍ମାଦେୱ ଭଯଂ କୁରୁତ| ");
INSERT INTO sanori_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","ପଞ୍ଚ ଚଟକପକ୍ଷିଣଃ କିଂ ଦ୍ୱାଭ୍ୟାଂ ତାମ୍ରଖଣ୍ଡାଭ୍ୟାଂ ନ ୱିକ୍ରୀଯନ୍ତେ? ତଥାପୀଶ୍ୱରସ୍ତେଷାମ୍ ଏକମପି ନ ୱିସ୍ମରତି| ");
INSERT INTO sanori_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","ଯୁଷ୍ମାକଂ ଶିରଃକେଶା ଅପି ଗଣିତାଃ ସନ୍ତି ତସ୍ମାତ୍ ମା ୱିଭୀତ ବହୁଚଟକପକ୍ଷିଭ୍ୟୋପି ଯୂଯଂ ବହୁମୂଲ୍ୟାଃ| ");
INSERT INTO sanori_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","ଅପରଂ ଯୁଷ୍ମଭ୍ୟଂ କଥଯାମି ଯଃ କଶ୍ଚିନ୍ ମାନୁଷାଣାଂ ସାକ୍ଷାନ୍ ମାଂ ସ୍ୱୀକରୋତି ମନୁଷ୍ୟପୁତ୍ର ଈଶ୍ୱରଦୂତାନାଂ ସାକ୍ଷାତ୍ ତଂ ସ୍ୱୀକରିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","କିନ୍ତୁ ଯଃ କଶ୍ଚିନ୍ମାନୁଷାଣାଂ ସାକ୍ଷାନ୍ମାମ୍ ଅସ୍ୱୀକରୋତି ତମ୍ ଈଶ୍ୱରସ୍ୟ ଦୂତାନାଂ ସାକ୍ଷାଦ୍ ଅହମ୍ ଅସ୍ୱୀକରିଷ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","ଅନ୍ୟଚ୍ଚ ଯଃ କଶ୍ଚିନ୍ ମନୁଜସୁତସ୍ୟ ନିନ୍ଦାଭାୱେନ କାଞ୍ଚିତ୍ କଥାଂ କଥଯତି ତସ୍ୟ ତତ୍ପାପସ୍ୟ ମୋଚନଂ ଭୱିଷ୍ୟତି କିନ୍ତୁ ଯଦି କଶ୍ଚିତ୍ ପୱିତ୍ରମ୍ ଆତ୍ମାନଂ ନିନ୍ଦତି ତର୍ହି ତସ୍ୟ ତତ୍ପାପସ୍ୟ ମୋଚନଂ ନ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","ଯଦା ଲୋକା ଯୁଷ୍ମାନ୍ ଭଜନଗେହଂ ୱିଚାରକର୍ତୃରାଜ୍ୟକର୍ତୃଣାଂ ସମ୍ମୁଖଞ୍ଚ ନେଷ୍ୟନ୍ତି ତଦା କେନ ପ୍ରକାରେଣ କିମୁତ୍ତରଂ ୱଦିଷ୍ୟଥ କିଂ କଥଯିଷ୍ୟଥ ଚେତ୍ୟତ୍ର ମା ଚିନ୍ତଯତ; ");
INSERT INTO sanori_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ଯତୋ ଯୁଷ୍ମାଭିର୍ୟଦ୍ ଯଦ୍ ୱକ୍ତୱ୍ୟଂ ତତ୍ ତସ୍ମିନ୍ ସମଯଏୱ ପୱିତ୍ର ଆତ୍ମା ଯୁଷ୍ମାନ୍ ଶିକ୍ଷଯିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ତତଃ ପରଂ ଜନତାମଧ୍ୟସ୍ଥଃ କଶ୍ଚିଜ୍ଜନସ୍ତଂ ଜଗାଦ ହେ ଗୁରୋ ମଯା ସହ ପୈତୃକଂ ଧନଂ ୱିଭକ୍ତୁଂ ମମ ଭ୍ରାତରମାଜ୍ଞାପଯତୁ ଭୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","କିନ୍ତୁ ସ ତମୱଦତ୍ ହେ ମନୁଷ୍ୟ ଯୁୱଯୋ ର୍ୱିଚାରଂ ୱିଭାଗଞ୍ଚ କର୍ତ୍ତୁଂ ମାଂ କୋ ନିଯୁକ୍ତୱାନ୍? ");
INSERT INTO sanori_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ଅନନ୍ତରଂ ସ ଲୋକାନୱଦତ୍ ଲୋଭେ ସାୱଧାନାଃ ସତର୍କାଶ୍ଚ ତିଷ୍ଠତ, ଯତୋ ବହୁସମ୍ପତ୍ତିପ୍ରାପ୍ତ୍ୟା ମନୁଷ୍ୟସ୍ୟାଯୁ ର୍ନ ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ପଶ୍ଚାଦ୍ ଦୃଷ୍ଟାନ୍ତକଥାମୁତ୍ଥାପ୍ୟ କଥଯାମାସ, ଏକସ୍ୟ ଧନିନୋ ଭୂମୌ ବହୂନି ଶସ୍ୟାନି ଜାତାନି| ");
INSERT INTO sanori_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ତତଃ ସ ମନସା ଚିନ୍ତଯିତ୍ୱା କଥଯାମ୍ବଭୂୱ ମମୈତାନି ସମୁତ୍ପନ୍ନାନି ଦ୍ରୱ୍ୟାଣି ସ୍ଥାପଯିତୁଂ ସ୍ଥାନଂ ନାସ୍ତି କିଂ କରିଷ୍ୟାମି? ");
INSERT INTO sanori_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ତତୋୱଦଦ୍ ଇତ୍ଥଂ କରିଷ୍ୟାମି, ମମ ସର୍ୱ୍ୱଭାଣ୍ଡାଗାରାଣି ଭଙ୍କ୍ତ୍ୱା ବୃହଦ୍ଭାଣ୍ଡାଗାରାଣି ନିର୍ମ୍ମାଯ ତନ୍ମଧ୍ୟେ ସର୍ୱ୍ୱଫଲାନି ଦ୍ରୱ୍ୟାଣି ଚ ସ୍ଥାପଯିଷ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ଅପରଂ ନିଜମନୋ ୱଦିଷ୍ୟାମି, ହେ ମନୋ ବହୁୱତ୍ସରାର୍ଥଂ ନାନାଦ୍ରୱ୍ୟାଣି ସଞ୍ଚିତାନି ସନ୍ତି ୱିଶ୍ରାମଂ କୁରୁ ଭୁକ୍ତ୍ୱା ପୀତ୍ୱା କୌତୁକଞ୍ଚ କୁରୁ| କିନ୍ତ୍ୱୀଶ୍ୱରସ୍ତମ୍ ଅୱଦତ୍, ");
INSERT INTO sanori_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","ରେ ନିର୍ବୋଧ ଅଦ୍ୟ ରାତ୍ରୌ ତୱ ପ୍ରାଣାସ୍ତ୍ୱତ୍ତୋ ନେଷ୍ୟନ୍ତେ ତତ ଏତାନି ଯାନି ଦ୍ରୱ୍ୟାଣି ତ୍ୱଯାସାଦିତାନି ତାନି କସ୍ୟ ଭୱିଷ୍ୟନ୍ତି? ");
INSERT INTO sanori_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","ଅତଏୱ ଯଃ କଶ୍ଚିଦ୍ ଈଶ୍ୱରସ୍ୟ ସମୀପେ ଧନସଞ୍ଚଯମକୃତ୍ୱା କେୱଲଂ ସ୍ୱନିକଟେ ସଞ୍ଚଯଂ କରୋତି ସୋପି ତାଦୃଶଃ| ");
INSERT INTO sanori_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","ଅଥ ସ ଶିଷ୍ୟେଭ୍ୟଃ କଥଯାମାସ, ଯୁଷ୍ମାନହଂ ୱଦାମି, କିଂ ଖାଦିଷ୍ୟାମଃ? କିଂ ପରିଧାସ୍ୟାମଃ? ଇତ୍ୟୁକ୍ତ୍ୱା ଜୀୱନସ୍ୟ ଶରୀରସ୍ୟ ଚାର୍ଥଂ ଚିନ୍ତାଂ ମା କାର୍ଷ୍ଟ| ");
INSERT INTO sanori_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ଭକ୍ଷ୍ୟାଜ୍ଜୀୱନଂ ଭୂଷଣାଚ୍ଛରୀରଞ୍ଚ ଶ୍ରେଷ୍ଠଂ ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","କାକପକ୍ଷିଣାଂ କାର୍ୟ୍ୟଂ ୱିଚାରଯତ, ତେ ନ ୱପନ୍ତି ଶସ୍ୟାନି ଚ ନ ଛିନ୍ଦନ୍ତି, ତେଷାଂ ଭାଣ୍ଡାଗାରାଣି ନ ସନ୍ତି କୋଷାଶ୍ଚ ନ ସନ୍ତି, ତଥାପୀଶ୍ୱରସ୍ତେଭ୍ୟୋ ଭକ୍ଷ୍ୟାଣି ଦଦାତି, ଯୂଯଂ ପକ୍ଷିଭ୍ୟଃ ଶ୍ରେଷ୍ଠତରା ନ କିଂ? ");
INSERT INTO sanori_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","ଅପରଞ୍ଚ ଭାୱଯିତ୍ୱା ନିଜାଯୁଷଃ କ୍ଷଣମାତ୍ରଂ ୱର୍ଦ୍ଧଯିତୁଂ ଶକ୍ନୋତି, ଏତାଦୃଶୋ ଲାକୋ ଯୁଷ୍ମାକଂ ମଧ୍ୟେ କୋସ୍ତି? ");
INSERT INTO sanori_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","ଅତଏୱ କ୍ଷୁଦ୍ରଂ କାର୍ୟ୍ୟଂ ସାଧଯିତୁମ୍ ଅସମର୍ଥା ଯୂଯମ୍ ଅନ୍ୟସ୍ମିନ୍ କାର୍ୟ୍ୟେ କୁତୋ ଭାୱଯଥ? ");
INSERT INTO sanori_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","ଅନ୍ୟଚ୍ଚ କାମ୍ପିଲପୁଷ୍ପଂ କଥଂ ୱର୍ଦ୍ଧତେ ତଦାପି ୱିଚାରଯତ, ତତ୍ କଞ୍ଚନ ଶ୍ରମଂ ନ କରୋତି ତନ୍ତୂଂଶ୍ଚ ନ ଜନଯତି କିନ୍ତୁ ଯୁଷ୍ମଭ୍ୟଂ ଯଥାର୍ଥଂ କଥଯାମି ସୁଲେମାନ୍ ବହ୍ୱୈଶ୍ୱର୍ୟ୍ୟାନ୍ୱିତୋପି ପୁଷ୍ପସ୍ୟାସ୍ୟ ସଦୃଶୋ ୱିଭୂଷିତୋ ନାସୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ଅଦ୍ୟ କ୍ଷେତ୍ରେ ୱର୍ତ୍ତମାନଂ ଶ୍ୱଶ୍ଚୂଲ୍ଲ୍ୟାଂ କ୍ଷେପ୍ସ୍ୟମାନଂ ଯତ୍ ତୃଣଂ, ତସ୍ମୈ ଯଦୀଶ୍ୱର ଇତ୍ଥଂ ଭୂଷଯତି ତର୍ହି ହେ ଅଲ୍ପପ୍ରତ୍ୟଯିନୋ ଯୁଷ୍ମାନ କିଂ ନ ପରିଧାପଯିଷ୍ୟତି? ");
INSERT INTO sanori_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","ଅତଏୱ କିଂ ଖାଦିଷ୍ୟାମଃ? କିଂ ପରିଧାସ୍ୟାମଃ? ଏତଦର୍ଥଂ ମା ଚେଷ୍ଟଧ୍ୱଂ ମା ସଂଦିଗ୍ଧ୍ୱଞ୍ଚ| ");
INSERT INTO sanori_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ଜଗତୋ ଦେୱାର୍ଚ୍ଚକା ଏତାନି ସର୍ୱ୍ୱାଣି ଚେଷ୍ଟନତେ; ଏଷୁ ୱସ୍ତୁଷୁ ଯୁଷ୍ମାକଂ ପ୍ରଯୋଜନମାସ୍ତେ ଇତି ଯୁଷ୍ମାକଂ ପିତା ଜାନାତି| ");
INSERT INTO sanori_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","ଅତଏୱେଶ୍ୱରସ୍ୟ ରାଜ୍ୟାର୍ଥଂ ସଚେଷ୍ଟା ଭୱତ ତଥା କୃତେ ସର୍ୱ୍ୱାଣ୍ୟେତାନି ଦ୍ରୱ୍ୟାଣି ଯୁଷ୍ମଭ୍ୟଂ ପ୍ରଦାଯିଷ୍ୟନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","ହେ କ୍ଷୁଦ୍ରମେଷୱ୍ରଜ ଯୂଯଂ ମା ଭୈଷ୍ଟ ଯୁଷ୍ମଭ୍ୟଂ ରାଜ୍ୟଂ ଦାତୁଂ ଯୁଷ୍ମାକଂ ପିତୁଃ ସମ୍ମତିରସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ଅତଏୱ ଯୁଷ୍ମାକଂ ଯା ଯା ସମ୍ପତ୍ତିରସ୍ତି ତାଂ ତାଂ ୱିକ୍ରୀଯ ୱିତରତ, ଯତ୍ ସ୍ଥାନଂ ଚୌରା ନାଗଚ୍ଛନ୍ତି, କୀଟାଶ୍ଚ ନ କ୍ଷାଯଯନ୍ତି ତାଦୃଶେ ସ୍ୱର୍ଗେ ନିଜାର୍ଥମ୍ ଅଜରେ ସମ୍ପୁଟକେ ଽକ୍ଷଯଂ ଧନଂ ସଞ୍ଚିନୁତ ଚ; ");
INSERT INTO sanori_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","ଯତୋ ଯତ୍ର ଯୁଷ୍ମାକଂ ଧନଂ ୱର୍ତ୍ତତେ ତତ୍ରେୱ ଯୁଷ୍ମାକଂ ମନଃ| ");
INSERT INTO sanori_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","ଅପରଞ୍ଚ ଯୂଯଂ ପ୍ରଦୀପଂ ଜ୍ୱାଲଯିତ୍ୱା ବଦ୍ଧକଟଯସ୍ତିଷ୍ଠତ; ");
INSERT INTO sanori_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ପ୍ରଭୁ ର୍ୱିୱାହାଦାଗତ୍ୟ ଯଦୈୱ ଦ୍ୱାରମାହନ୍ତି ତଦୈୱ ଦ୍ୱାରଂ ମୋଚଯିତୁଂ ଯଥା ଭୃତ୍ୟା ଅପେକ୍ଷ୍ୟ ତିଷ୍ଠନ୍ତି ତଥା ଯୂଯମପି ତିଷ୍ଠତ| ");
INSERT INTO sanori_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ଯତଃ ପ୍ରଭୁରାଗତ୍ୟ ଯାନ୍ ଦାସାନ୍ ସଚେତନାନ୍ ତିଷ୍ଠତୋ ଦ୍ରକ୍ଷ୍ୟତି ତଏୱ ଧନ୍ୟାଃ; ଅହଂ ଯୁଷ୍ମାନ୍ ଯଥାର୍ଥଂ ୱଦାମି ପ୍ରଭୁସ୍ତାନ୍ ଭୋଜନାର୍ଥମ୍ ଉପୱେଶ୍ୟ ସ୍ୱଯଂ ବଦ୍ଧକଟିଃ ସମୀପମେତ୍ୟ ପରିୱେଷଯିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ଯଦି ଦ୍ୱିତୀଯେ ତୃତୀଯେ ୱା ପ୍ରହରେ ସମାଗତ୍ୟ ତଥୈୱ ପଶ୍ୟତି, ତର୍ହି ତଏୱ ଦାସା ଧନ୍ୟାଃ| ");
INSERT INTO sanori_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","ଅପରଞ୍ଚ କସ୍ମିନ୍ କ୍ଷଣେ ଚୌରା ଆଗମିଷ୍ୟନ୍ତି ଇତି ଯଦି ଗୃହପତି ର୍ଜ୍ଞାତୁଂ ଶକ୍ନୋତି ତଦାୱଶ୍ୟଂ ଜାଗ୍ରନ୍ ନିଜଗୃହେ ସନ୍ଧିଂ କର୍ତ୍ତଯିତୁଂ ୱାରଯତି ଯୂଯମେତଦ୍ ୱିତ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","ଅତଏୱ ଯୂଯମପି ସଜ୍ଜମାନାସ୍ତିଷ୍ଠତ ଯତୋ ଯସ୍ମିନ୍ କ୍ଷଣେ ତଂ ନାପ୍ରେକ୍ଷଧ୍ୱେ ତସ୍ମିନ୍ନେୱ କ୍ଷଣେ ମନୁଷ୍ୟପୁତ୍ର ଆଗମିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ତଦା ପିତରଃ ପପ୍ରଚ୍ଛ, ହେ ପ୍ରଭୋ ଭୱାନ୍ କିମସ୍ମାନ୍ ଉଦ୍ଦିଶ୍ୟ କିଂ ସର୍ୱ୍ୱାନ୍ ଉଦ୍ଦିଶ୍ୟ ଦୃଷ୍ଟାନ୍ତକଥାମିମାଂ ୱଦତି? ");
INSERT INTO sanori_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ତତଃ ପ୍ରଭୁଃ ପ୍ରୋୱାଚ, ପ୍ରଭୁଃ ସମୁଚିତକାଲେ ନିଜପରିୱାରାର୍ଥଂ ଭୋଜ୍ୟପରିୱେଷଣାଯ ଯଂ ତତ୍ପଦେ ନିଯୋକ୍ଷ୍ୟତି ତାଦୃଶୋ ୱିଶ୍ୱାସ୍ୟୋ ବୋଦ୍ଧା କର୍ମ୍ମାଧୀଶଃ କୋସ୍ତି? ");
INSERT INTO sanori_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ପ୍ରଭୁରାଗତ୍ୟ ଯମ୍ ଏତାଦୃଶେ କର୍ମ୍ମଣି ପ୍ରୱୃତ୍ତଂ ଦ୍ରକ୍ଷ୍ୟତି ସଏୱ ଦାସୋ ଧନ୍ୟଃ| ");
INSERT INTO sanori_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ଅହଂ ଯୁଷ୍ମାନ୍ ଯଥାର୍ଥଂ ୱଦାମି ସ ତଂ ନିଜସର୍ୱ୍ୱସ୍ୱସ୍ୟାଧିପତିଂ କରିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","କିନ୍ତୁ ପ୍ରଭୁର୍ୱିଲମ୍ବେନାଗମିଷ୍ୟତି, ଇତି ୱିଚିନ୍ତ୍ୟ ସ ଦାସୋ ଯଦି ତଦନ୍ୟଦାସୀଦାସାନ୍ ପ୍ରହର୍ତ୍ତୁମ୍ ଭୋକ୍ତୁଂ ପାତୁଂ ମଦିତୁଞ୍ଚ ପ୍ରାରଭତେ, ");
INSERT INTO sanori_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ତର୍ହି ଯଦା ପ୍ରଭୁଂ ନାପେକ୍ଷିଷ୍ୟତେ ଯସ୍ମିନ୍ କ୍ଷଣେ ସୋଽଚେତନଶ୍ଚ ସ୍ଥାସ୍ୟତି ତସ୍ମିନ୍ନେୱ କ୍ଷଣେ ତସ୍ୟ ପ୍ରଭୁରାଗତ୍ୟ ତଂ ପଦଭ୍ରଷ୍ଟଂ କୃତ୍ୱା ୱିଶ୍ୱାସହୀନୈଃ ସହ ତସ୍ୟ ଅଂଶଂ ନିରୂପଯିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","ଯୋ ଦାସଃ ପ୍ରଭେाରାଜ୍ଞାଂ ଜ୍ଞାତ୍ୱାପି ସଜ୍ଜିତୋ ନ ତିଷ୍ଠତି ତଦାଜ୍ଞାନୁସାରେଣ ଚ କାର୍ୟ୍ୟଂ ନ କରୋତି ସୋନେକାନ୍ ପ୍ରହାରାନ୍ ପ୍ରାପ୍ସ୍ୟତି; ");
INSERT INTO sanori_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","କିନ୍ତୁ ଯୋ ଜନୋଽଜ୍ଞାତ୍ୱା ପ୍ରହାରାର୍ହଂ କର୍ମ୍ମ କରୋତି ସୋଲ୍ପପ୍ରହାରାନ୍ ପ୍ରାପ୍ସ୍ୟତି| ଯତୋ ଯସ୍ମୈ ବାହୁଲ୍ୟେନ ଦତ୍ତଂ ତସ୍ମାଦେୱ ବାହୁଲ୍ୟେନ ଗ୍ରହୀଷ୍ୟତେ, ମାନୁଷା ଯସ୍ୟ ନିକଟେ ବହୁ ସମର୍ପଯନ୍ତି ତସ୍ମାଦ୍ ବହୁ ଯାଚନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","ଅହଂ ପୃଥିୱ୍ୟାମ୍ ଅନୈକ୍ୟରୂପଂ ୱହ୍ନି ନିକ୍ଷେପ୍ତୁମ୍ ଆଗତୋସ୍ମି, ସ ଚେଦ୍ ଇଦାନୀମେୱ ପ୍ରଜ୍ୱଲତି ତତ୍ର ମମ କା ଚିନ୍ତା? ");
INSERT INTO sanori_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","କିନ୍ତୁ ଯେନ ମଜ୍ଜନେନାହଂ ମଗ୍ନୋ ଭୱିଷ୍ୟାମି ଯାୱତ୍କାଲଂ ତସ୍ୟ ସିଦ୍ଧି ର୍ନ ଭୱିଷ୍ୟତି ତାୱଦହଂ କତିକଷ୍ଟଂ ପ୍ରାପ୍ସ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","ମେଲନଂ କର୍ତ୍ତୁଂ ଜଗଦ୍ ଆଗତୋସ୍ମି ଯୂଯଂ କିମିତ୍ଥଂ ବୋଧଧ୍ୱେ? ଯୁଷ୍ମାନ୍ ୱଦାମି ନ ତଥା, କିନ୍ତ୍ୱହଂ ମେଲନାଭାୱଂ କର୍ତ୍ତୁଂମ୍ ଆଗତୋସ୍ମି| ");
INSERT INTO sanori_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ଯସ୍ମାଦେତତ୍କାଲମାରଭ୍ୟ ଏକତ୍ରସ୍ଥପରିଜନାନାଂ ମଧ୍ୟେ ପଞ୍ଚଜନାଃ ପୃଥଗ୍ ଭୂତ୍ୱା ତ୍ରଯୋ ଜନା ଦ୍ୱଯୋର୍ଜନଯୋଃ ପ୍ରତିକୂଲା ଦ୍ୱୌ ଜନୌ ଚ ତ୍ରଯାଣାଂ ଜନାନାଂ ପ୍ରତିକୂଲୌ ଭୱିଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","ପିତା ପୁତ୍ରସ୍ୟ ୱିପକ୍ଷଃ ପୁତ୍ରଶ୍ଚ ପିତୁ ର୍ୱିପକ୍ଷୋ ଭୱିଷ୍ୟତି ମାତା କନ୍ୟାଯା ୱିପକ୍ଷା କନ୍ୟା ଚ ମାତୁ ର୍ୱିପକ୍ଷା ଭୱିଷ୍ୟତି, ତଥା ଶ୍ୱଶ୍ରୂର୍ବଧ୍ୱା ୱିପକ୍ଷା ବଧୂଶ୍ଚ ଶ୍ୱଶ୍ର୍ୱା ୱିପକ୍ଷା ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ସ ଲୋକେଭ୍ୟୋପରମପି କଥଯାମାସ, ପଶ୍ଚିମଦିଶି ମେଘୋଦ୍ଗମଂ ଦୃଷ୍ଟ୍ୱା ଯୂଯଂ ହଠାଦ୍ ୱଦଥ ୱୃଷ୍ଟି ର୍ଭୱିଷ୍ୟତି ତତସ୍ତଥୈୱ ଜାଯତେ| ");
INSERT INTO sanori_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","ଅପରଂ ଦକ୍ଷିଣତୋ ୱାଯୌ ୱାତି ସତି ୱଦଥ ନିଦାଘୋ ଭୱିଷ୍ୟତି ତତଃ ସୋପି ଜାଯତେ| ");
INSERT INTO sanori_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ରେ ରେ କପଟିନ ଆକାଶସ୍ୟ ଭୂମ୍ୟାଶ୍ଚ ଲକ୍ଷଣଂ ବୋଦ୍ଧୁଂ ଶକ୍ନୁଥ, ");
INSERT INTO sanori_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","କିନ୍ତୁ କାଲସ୍ୟାସ୍ୟ ଲକ୍ଷଣଂ କୁତୋ ବୋଦ୍ଧୁଂ ନ ଶକ୍ନୁଥ? ଯୂଯଞ୍ଚ ସ୍ୱଯଂ କୁତୋ ନ ନ୍ୟାଷ୍ୟଂ ୱିଚାରଯଥ? ");
INSERT INTO sanori_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","ଅପରଞ୍ଚ ୱିୱାଦିନା ସାର୍ଦ୍ଧଂ ୱିଚାରଯିତୁଃ ସମୀପଂ ଗଚ୍ଛନ୍ ପଥି ତସ୍ମାଦୁଦ୍ଧାରଂ ପ୍ରାପ୍ତୁଂ ଯତସ୍ୱ ନୋଚେତ୍ ସ ତ୍ୱାଂ ଧୃତ୍ୱା ୱିଚାରଯିତୁଃ ସମୀପଂ ନଯତି| ୱିଚାରଯିତା ଯଦି ତ୍ୱାଂ ପ୍ରହର୍ତ୍ତୁଃ ସମୀପଂ ସମର୍ପଯତି ପ୍ରହର୍ତ୍ତା ତ୍ୱାଂ କାରାଯାଂ ବଧ୍ନାତି ");
INSERT INTO sanori_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","ତର୍ହି ତ୍ୱାମହଂ ୱଦାମି ତ୍ୱଯା ନିଃଶେଷଂ କପର୍ଦକେଷୁ ନ ପରିଶୋଧିତେଷୁ ତ୍ୱଂ ତତୋ ମୁକ୍ତିଂ ପ୍ରାପ୍ତୁଂ ନ ଶକ୍ଷ୍ୟସି| ");
INSERT INTO sanori_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","ଅପରଞ୍ଚ ପୀଲାତୋ ଯେଷାଂ ଗାଲୀଲୀଯାନାଂ ରକ୍ତାନି ବଲୀନାଂ ରକ୍ତୈଃ ସହାମିଶ୍ରଯତ୍ ତେଷାଂ ଗାଲୀଲୀଯାନାଂ ୱୃତ୍ତାନ୍ତଂ କତିପଯଜନା ଉପସ୍ଥାପ୍ୟ ଯୀଶୱେ କଥଯାମାସୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ତତଃ ସ ପ୍ରତ୍ୟୁୱାଚ ତେଷାଂ ଲୋକାନାମ୍ ଏତାଦୃଶୀ ଦୁର୍ଗତି ର୍ଘଟିତା ତତ୍କାରଣାଦ୍ ଯୂଯଂ କିମନ୍ୟେଭ୍ୟୋ ଗାଲୀଲୀଯେଭ୍ୟୋପ୍ୟଧିକପାପିନସ୍ତାନ୍ ବୋଧଧ୍ୱେ? ");
INSERT INTO sanori_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","ଯୁଷ୍ମାନହଂ ୱଦାମି ତଥା ନ କିନ୍ତୁ ମନଃସୁ ନ ପରାୱର୍ତ୍ତିତେଷୁ ଯୂଯମପି ତଥା ନଂକ୍ଷ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","ଅପରଞ୍ଚ ଶୀଲୋହନାମ୍ନ ଉଚ୍ଚଗୃହସ୍ୟ ପତନାଦ୍ ଯେଽଷ୍ଟାଦଶଜନା ମୃତାସ୍ତେ ଯିରୂଶାଲମି ନିୱାସିସର୍ୱ୍ୱଲୋକେଭ୍ୟୋଽଧିକାପରାଧିନଃ କିଂ ଯୂଯମିତ୍ୟଂ ବୋଧଧ୍ୱେ? ");
INSERT INTO sanori_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","ଯୁଷ୍ମାନହଂ ୱଦାମି ତଥା ନ କିନ୍ତୁ ମନଃସୁ ନ ପରିୱର୍ତ୍ତିତେଷୁ ଯୂଯମପି ତଥା ନଂକ୍ଷ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ଅନନ୍ତରଂ ସ ଇମାଂ ଦୃଷ୍ଟାନ୍ତକଥାମକଥଯଦ୍ ଏକୋ ଜନୋ ଦ୍ରାକ୍ଷାକ୍ଷେତ୍ରମଧ୍ୟ ଏକମୁଡୁମ୍ବରୱୃକ୍ଷଂ ରୋପିତୱାନ୍| ପଶ୍ଚାତ୍ ସ ଆଗତ୍ୟ ତସ୍ମିନ୍ ଫଲାନି ଗୱେଷଯାମାସ, ");
INSERT INTO sanori_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","କିନ୍ତୁ ଫଲାପ୍ରାପ୍ତେଃ କାରଣାଦ୍ ଉଦ୍ୟାନକାରଂ ଭୃତ୍ୟଂ ଜଗାଦ, ପଶ୍ୟ ୱତ୍ସରତ୍ରଯଂ ଯାୱଦାଗତ୍ୟ ଏତସ୍ମିନ୍ନୁଡୁମ୍ବରତରୌ କ୍ଷଲାନ୍ୟନ୍ୱିଚ୍ଛାମି, କିନ୍ତୁ ନୈକମପି ପ୍ରପ୍ନୋମି ତରୁରଯଂ କୁତୋ ୱୃଥା ସ୍ଥାନଂ ୱ୍ୟାପ୍ୟ ତିଷ୍ଠତି? ଏନଂ ଛିନ୍ଧି| ");
INSERT INTO sanori_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ତତୋ ଭୃତ୍ୟଃ ପ୍ରତ୍ୟୁୱାଚ, ହେ ପ୍ରଭୋ ପୁନର୍ୱର୍ଷମେକଂ ସ୍ଥାତୁମ୍ ଆଦିଶ; ଏତସ୍ୟ ମୂଲସ୍ୟ ଚତୁର୍ଦିକ୍ଷୁ ଖନିତ୍ୱାହମ୍ ଆଲୱାଲଂ ସ୍ଥାପଯାମି| ");
INSERT INTO sanori_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ତତଃ ଫଲିତୁଂ ଶକ୍ନୋତି ଯଦି ନ ଫଲତି ତର୍ହି ପଶ୍ଚାତ୍ ଛେତ୍ସ୍ୟସି| ");
INSERT INTO sanori_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","ଅଥ ୱିଶ୍ରାମୱାରେ ଭଜନଗେହେ ଯୀଶୁରୁପଦିଶତି ");
INSERT INTO sanori_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ତସ୍ମିତ୍ ସମଯେ ଭୂତଗ୍ରସ୍ତତ୍ୱାତ୍ କୁବ୍ଜୀଭୂଯାଷ୍ଟାଦଶୱର୍ଷାଣି ଯାୱତ୍ କେନାପ୍ୟୁପାଯେନ ଋଜୁ ର୍ଭୱିତୁଂ ନ ଶକ୍ନୋତି ଯା ଦୁର୍ବ୍ବଲା ସ୍ତ୍ରୀ, ");
INSERT INTO sanori_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ତାଂ ତତ୍ରୋପସ୍ଥିତାଂ ୱିଲୋକ୍ୟ ଯୀଶୁସ୍ତାମାହୂଯ କଥିତୱାନ୍ ହେ ନାରି ତୱ ଦୌର୍ବ୍ବଲ୍ୟାତ୍ ତ୍ୱଂ ମୁକ୍ତା ଭୱ| ");
INSERT INTO sanori_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ତତଃ ପରଂ ତସ୍ୟା ଗାତ୍ରେ ହସ୍ତାର୍ପଣମାତ୍ରାତ୍ ସା ଋଜୁର୍ଭୂତ୍ୱେଶ୍ୱରସ୍ୟ ଧନ୍ୟୱାଦଂ କର୍ତ୍ତୁମାରେଭେ| ");
INSERT INTO sanori_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","କିନ୍ତୁ ୱିଶ୍ରାମୱାରେ ଯୀଶୁନା ତସ୍ୟାଃ ସ୍ୱାସ୍ଥ୍ୟକରଣାଦ୍ ଭଜନଗେହସ୍ୟାଧିପତିଃ ପ୍ରକୁପ୍ୟ ଲୋକାନ୍ ଉୱାଚ, ଷଟ୍ସୁ ଦିନେଷୁ ଲୋକୈଃ କର୍ମ୍ମ କର୍ତ୍ତୱ୍ୟଂ ତସ୍ମାଦ୍ଧେତୋଃ ସ୍ୱାସ୍ଥ୍ୟାର୍ଥଂ ତେଷୁ ଦିନେଷୁ ଆଗଚ୍ଛତ, ୱିଶ୍ରାମୱାରେ ମାଗଚ୍ଛତ| ");
INSERT INTO sanori_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ତଦା ପଭୁଃ ପ୍ରତ୍ୟୁୱାଚ ରେ କପଟିନୋ ଯୁଷ୍ମାକମ୍ ଏକୈକୋ ଜନୋ ୱିଶ୍ରାମୱାରେ ସ୍ୱୀଯଂ ସ୍ୱୀଯଂ ୱୃଷଭଂ ଗର୍ଦଭଂ ୱା ବନ୍ଧନାନ୍ମୋଚଯିତ୍ୱା ଜଲଂ ପାଯଯିତୁଂ କିଂ ନ ନଯତି? ");
INSERT INTO sanori_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","ତର୍ହ୍ୟାଷ୍ଟାଦଶୱତ୍ସରାନ୍ ଯାୱତ୍ ଶୈତାନା ବଦ୍ଧା ଇବ୍ରାହୀମଃ ସନ୍ତତିରିଯଂ ନାରୀ କିଂ ୱିଶ୍ରାମୱାରେ ନ ମୋଚଯିତୱ୍ୟା? ");
INSERT INTO sanori_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ଏଷୁ ୱାକ୍ୟେଷୁ କଥିତେଷୁ ତସ୍ୟ ୱିପକ୍ଷାଃ ସଲଜ୍ଜା ଜାତାଃ କିନ୍ତୁ ତେନ କୃତସର୍ୱ୍ୱମହାକର୍ମ୍ମକାରଣାତ୍ ଲୋକନିୱହଃ ସାନନ୍ଦୋଽଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ଅନନ୍ତରଂ ସୋୱଦଦ୍ ଈଶ୍ୱରସ୍ୟ ରାଜ୍ୟଂ କସ୍ୟ ସଦୃଶଂ? କେନ ତଦୁପମାସ୍ୟାମି? ");
INSERT INTO sanori_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ଯତ୍ ସର୍ଷପବୀଜଂ ଗୃହୀତ୍ୱା କଶ୍ଚିଜ୍ଜନ ଉଦ୍ୟାନ ଉପ୍ତୱାନ୍ ତଦ୍ ବୀଜମଙ୍କୁରିତଂ ସତ୍ ମହାୱୃକ୍ଷୋଽଜାଯତ, ତତସ୍ତସ୍ୟ ଶାଖାସୁ ୱିହାଯସୀଯୱିହଗା ଆଗତ୍ୟ ନ୍ୟୂଷୁଃ, ତଦ୍ରାଜ୍ୟଂ ତାଦୃଶେନ ସର୍ଷପବୀଜେନ ତୁଲ୍ୟଂ| ");
INSERT INTO sanori_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ପୁନଃ କଥଯାମାସ, ଈଶ୍ୱରସ୍ୟ ରାଜ୍ୟଂ କସ୍ୟ ସଦୃଶଂ ୱଦିଷ୍ୟାମି? ଯତ୍ କିଣ୍ୱଂ କାଚିତ୍ ସ୍ତ୍ରୀ ଗୃହୀତ୍ୱା ଦ୍ରୋଣତ୍ରଯପରିମିତଗୋଧୂମଚୂର୍ଣେଷୁ ସ୍ଥାପଯାମାସ, ");
INSERT INTO sanori_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ତତଃ କ୍ରମେଣ ତତ୍ ସର୍ୱ୍ୱଗୋଧୂମଚୂର୍ଣଂ ୱ୍ୟାପ୍ନୋତି, ତସ୍ୟ କିଣ୍ୱସ୍ୟ ତୁଲ୍ୟମ୍ ଈଶ୍ୱରସ୍ୟ ରାଜ୍ୟଂ| ");
INSERT INTO sanori_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ତତଃ ସ ଯିରୂଶାଲମ୍ନଗରଂ ପ୍ରତି ଯାତ୍ରାଂ କୃତ୍ୱା ନଗରେ ନଗରେ ଗ୍ରାମେ ଗ୍ରାମେ ସମୁପଦିଶନ୍ ଜଗାମ| ");
INSERT INTO sanori_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ତଦା କଶ୍ଚିଜ୍ଜନସ୍ତଂ ପପ୍ରଚ୍ଛ, ହେ ପ୍ରଭୋ କିଂ କେୱଲମ୍ ଅଲ୍ପେ ଲୋକାଃ ପରିତ୍ରାସ୍ୟନ୍ତେ? ");
INSERT INTO sanori_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","ତତଃ ସ ଲୋକାନ୍ ଉୱାଚ, ସଂକୀର୍ଣଦ୍ୱାରେଣ ପ୍ରୱେଷ୍ଟୁଂ ଯତଘ୍ୱଂ, ଯତୋହଂ ଯୁଷ୍ମାନ୍ ୱଦାମି, ବହୱଃ ପ୍ରୱେଷ୍ଟୁଂ ଚେଷ୍ଟିଷ୍ୟନ୍ତେ କିନ୍ତୁ ନ ଶକ୍ଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ଗୃହପତିନୋତ୍ଥାଯ ଦ୍ୱାରେ ରୁଦ୍ଧେ ସତି ଯଦି ଯୂଯଂ ବହିଃ ସ୍ଥିତ୍ୱା ଦ୍ୱାରମାହତ୍ୟ ୱଦଥ, ହେ ପ୍ରଭୋ ହେ ପ୍ରଭୋ ଅସ୍ମତ୍କାରଣାଦ୍ ଦ୍ୱାରଂ ମୋଚଯତୁ, ତତଃ ସ ଇତି ପ୍ରତିୱକ୍ଷ୍ୟତି, ଯୂଯଂ କୁତ୍ରତ୍ୟା ଲୋକା ଇତ୍ୟହଂ ନ ଜାନାମି| ");
INSERT INTO sanori_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","ତଦା ଯୂଯଂ ୱଦିଷ୍ୟଥ, ତୱ ସାକ୍ଷାଦ୍ ୱଯଂ ଭେाଜନଂ ପାନଞ୍ଚ କୃତୱନ୍ତଃ, ତ୍ୱଞ୍ଚାସ୍ମାକଂ ନଗରସ୍ୟ ପଥି ସମୁପଦିଷ୍ଟୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","କିନ୍ତୁ ସ ୱକ୍ଷ୍ୟତି, ଯୁଷ୍ମାନହଂ ୱଦାମି, ଯୂଯଂ କୁତ୍ରତ୍ୟା ଲୋକା ଇତ୍ୟହଂ ନ ଜାନାମି; ହେ ଦୁରାଚାରିଣୋ ଯୂଯଂ ମତ୍ତୋ ଦୂରୀଭୱତ| ");
INSERT INTO sanori_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","ତଦା ଇବ୍ରାହୀମଂ ଇସ୍ହାକଂ ଯାକୂବଞ୍ଚ ସର୍ୱ୍ୱଭୱିଷ୍ୟଦ୍ୱାଦିନଶ୍ଚ ଈଶ୍ୱରସ୍ୟ ରାଜ୍ୟଂ ପ୍ରାପ୍ତାନ୍ ସ୍ୱାଂଶ୍ଚ ବହିଷ୍କୃତାନ୍ ଦୃଷ୍ଟ୍ୱା ଯୂଯଂ ରୋଦନଂ ଦନ୍ତୈର୍ଦନ୍ତଘର୍ଷଣଞ୍ଚ କରିଷ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","ଅପରଞ୍ଚ ପୂର୍ୱ୍ୱପଶ୍ଚିମଦକ୍ଷିଣୋତ୍ତରଦିଗ୍ଭ୍ୟୋ ଲୋକା ଆଗତ୍ୟ ଈଶ୍ୱରସ୍ୟ ରାଜ୍ୟେ ନିୱତ୍ସ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ପଶ୍ୟତେତ୍ଥଂ ଶେଷୀଯା ଲୋକା ଅଗ୍ରା ଭୱିଷ୍ୟନ୍ତି, ଅଗ୍ରୀଯା ଲୋକାଶ୍ଚ ଶେଷା ଭୱିଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","ଅପରଞ୍ଚ ତସ୍ମିନ୍ ଦିନେ କିଯନ୍ତଃ ଫିରୂଶିନ ଆଗତ୍ୟ ଯୀଶୁଂ ପ୍ରୋଚୁଃ, ବହିର୍ଗଚ୍ଛ, ସ୍ଥାନାଦସ୍ମାତ୍ ପ୍ରସ୍ଥାନଂ କୁରୁ, ହେରୋଦ୍ ତ୍ୱାଂ ଜିଘାଂସତି| ");
INSERT INTO sanori_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ତତଃ ସ ପ୍ରତ୍ୟୱୋଚତ୍ ପଶ୍ୟତାଦ୍ୟ ଶ୍ୱଶ୍ଚ ଭୂତାନ୍ ୱିହାପ୍ୟ ରୋଗିଣୋଽରୋଗିଣଃ କୃତ୍ୱା ତୃତୀଯେହ୍ନି ସେତ୍ସ୍ୟାମି, କଥାମେତାଂ ଯୂଯମିତ୍ୱା ତଂ ଭୂରିମାଯଂ ୱଦତ| ");
INSERT INTO sanori_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","ତତ୍ରାପ୍ୟଦ୍ୟ ଶ୍ୱଃ ପରଶ୍ୱଶ୍ଚ ମଯା ଗମନାଗମନେ କର୍ତ୍ତୱ୍ୟେ, ଯତୋ ହେତୋ ର୍ୟିରୂଶାଲମୋ ବହିଃ କୁତ୍ରାପି କୋପି ଭୱିଷ୍ୟଦ୍ୱାଦୀ ନ ଘାନିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","ହେ ଯିରୂଶାଲମ୍ ହେ ଯିରୂଶାଲମ୍ ତ୍ୱଂ ଭୱିଷ୍ୟଦ୍ୱାଦିନୋ ହଂସି ତୱାନ୍ତିକେ ପ୍ରେରିତାନ୍ ପ୍ରସ୍ତରୈର୍ମାରଯସି ଚ, ଯଥା କୁକ୍କୁଟୀ ନିଜପକ୍ଷାଧଃ ସ୍ୱଶାୱକାନ୍ ସଂଗୃହ୍ଲାତି, ତଥାହମପି ତୱ ଶିଶୂନ୍ ସଂଗ୍ରହୀତୁଂ କତିୱାରାନ୍ ଐଚ୍ଛଂ କିନ୍ତୁ ତ୍ୱଂ ନୈଚ୍ଛଃ| ");
INSERT INTO sanori_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ପଶ୍ୟତ ଯୁଷ୍ମାକଂ ୱାସସ୍ଥାନାନି ପ୍ରୋଚ୍ଛିଦ୍ୟମାନାନି ପରିତ୍ୟକ୍ତାନି ଚ ଭୱିଷ୍ୟନ୍ତି; ଯୁଷ୍ମାନହଂ ଯଥାର୍ଥଂ ୱଦାମି, ଯଃ ପ୍ରଭୋ ର୍ନାମ୍ନାଗଚ୍ଛତି ସ ଧନ୍ୟ ଇତି ୱାଚଂ ଯାୱତ୍କାଲଂ ନ ୱଦିଷ୍ୟଥ, ତାୱତ୍କାଲଂ ଯୂଯଂ ମାଂ ନ ଦ୍ରକ୍ଷ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ଅନନ୍ତରଂ ୱିଶ୍ରାମୱାରେ ଯୀଶୌ ପ୍ରଧାନସ୍ୟ ଫିରୂଶିନୋ ଗୃହେ ଭୋକ୍ତୁଂ ଗତୱତି ତେ ତଂ ୱୀକ୍ଷିତୁମ୍ ଆରେଭିରେ| ");
INSERT INTO sanori_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ତଦା ଜଲୋଦରୀ ତସ୍ୟ ସମ୍ମୁଖେ ସ୍ଥିତଃ| ");
INSERT INTO sanori_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ତତଃ ସ ୱ୍ୟୱସ୍ଥାପକାନ୍ ଫିରୂଶିନଶ୍ଚ ପପ୍ରଚ୍ଛ, ୱିଶ୍ରାମୱାରେ ସ୍ୱାସ୍ଥ୍ୟଂ କର୍ତ୍ତୱ୍ୟଂ ନ ୱା? ତତସ୍ତେ କିମପି ନ ପ୍ରତ୍ୟୂଚୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","ତଦା ସ ତଂ ରୋଗିଣଂ ସ୍ୱସ୍ଥଂ କୃତ୍ୱା ୱିସସର୍ଜ; ");
INSERT INTO sanori_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ତାନୁୱାଚ ଚ ଯୁଷ୍ମାକଂ କସ୍ୟଚିଦ୍ ଗର୍ଦ୍ଦଭୋ ୱୃଷଭୋ ୱା ଚେଦ୍ ଗର୍ତ୍ତେ ପତତି ତର୍ହି ୱିଶ୍ରାମୱାରେ ତତ୍କ୍ଷଣଂ ସ କିଂ ତଂ ନୋତ୍ଥାପଯିଷ୍ୟତି? ");
INSERT INTO sanori_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ତତସ୍ତେ କଥାଯା ଏତସ୍ୟାଃ କିମପି ପ୍ରତିୱକ୍ତୁଂ ନ ଶେକୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ଅପରଞ୍ଚ ପ୍ରଧାନସ୍ଥାନମନୋନୀତତ୍ୱକରଣଂ ୱିଲୋକ୍ୟ ସ ନିମନ୍ତ୍ରିତାନ୍ ଏତଦୁପଦେଶକଥାଂ ଜଗାଦ, ");
INSERT INTO sanori_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","ତ୍ୱଂ ୱିୱାହାଦିଭୋଜ୍ୟେଷୁ ନିମନ୍ତ୍ରିତଃ ସନ୍ ପ୍ରଧାନସ୍ଥାନେ ମୋପାୱେକ୍ଷୀଃ| ତ୍ୱତ୍ତୋ ଗୌରୱାନ୍ୱିତନିମନ୍ତ୍ରିତଜନ ଆଯାତେ ");
INSERT INTO sanori_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ନିମନ୍ତ୍ରଯିତାଗତ୍ୟ ମନୁଷ୍ୟାଯୈତସ୍ମୈ ସ୍ଥାନଂ ଦେହୀତି ୱାକ୍ୟଂ ଚେଦ୍ ୱକ୍ଷ୍ୟତି ତର୍ହି ତ୍ୱଂ ସଙ୍କୁଚିତୋ ଭୂତ୍ୱା ସ୍ଥାନ ଇତରସ୍ମିନ୍ ଉପୱେଷ୍ଟୁମ୍ ଉଦ୍ୟଂସ୍ୟସି| ");
INSERT INTO sanori_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","ଅସ୍ମାତ୍ କାରଣାଦେୱ ତ୍ୱଂ ନିମନ୍ତ୍ରିତୋ ଗତ୍ୱାଽପ୍ରଧାନସ୍ଥାନ ଉପୱିଶ, ତତୋ ନିମନ୍ତ୍ରଯିତାଗତ୍ୟ ୱଦିଷ୍ୟତି, ହେ ବନ୍ଧୋ ପ୍ରୋଚ୍ଚସ୍ଥାନଂ ଗତ୍ୱୋପୱିଶ, ତଥା ସତି ଭୋଜନୋପୱିଷ୍ଟାନାଂ ସକଲାନାଂ ସାକ୍ଷାତ୍ ତ୍ୱଂ ମାନ୍ୟୋ ଭୱିଷ୍ୟସି| ");
INSERT INTO sanori_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","ଯଃ କଶ୍ଚିତ୍ ସ୍ୱମୁନ୍ନମଯତି ସ ନମଯିଷ୍ୟତେ, କିନ୍ତୁ ଯଃ କଶ୍ଚିତ୍ ସ୍ୱଂ ନମଯତି ସ ଉନ୍ନମଯିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ତଦା ସ ନିମନ୍ତ୍ରଯିତାରଂ ଜନମପି ଜଗାଦ, ମଧ୍ୟାହ୍ନେ ରାତ୍ରୌ ୱା ଭୋଜ୍ୟେ କୃତେ ନିଜବନ୍ଧୁଗଣୋ ୱା ଭ୍ରାତୃृଗଣୋ ୱା ଜ୍ଞାତିଗଣୋ ୱା ଧନିଗଣୋ ୱା ସମୀପୱାସିଗଣୋ ୱା ଏତାନ୍ ନ ନିମନ୍ତ୍ରଯ, ତଥା କୃତେ ଚେତ୍ ତେ ତ୍ୱାଂ ନିମନ୍ତ୍ରଯିଷ୍ୟନ୍ତି, ତର୍ହି ପରିଶୋଧୋ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","କିନ୍ତୁ ଯଦା ଭେଜ୍ୟଂ କରୋଷି ତଦା ଦରିଦ୍ରଶୁଷ୍କକରଖଞ୍ଜାନ୍ଧାନ୍ ନିମନ୍ତ୍ରଯ, ");
INSERT INTO sanori_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ତତ ଆଶିଷଂ ଲପ୍ସ୍ୟସେ, ତେଷୁ ପରିଶୋଧଂ କର୍ତ୍ତୁମଶକ୍ନୁୱତ୍ସୁ ଶ୍ମଶାନାଦ୍ଧାର୍ମ୍ମିକାନାମୁତ୍ଥାନକାଲେ ତ୍ୱଂ ଫଲାଂ ଲପ୍ସ୍ୟସେ| ");
INSERT INTO sanori_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ଅନନ୍ତରଂ ତାଂ କଥାଂ ନିଶମ୍ୟ ଭୋଜନୋପୱିଷ୍ଟଃ କଶ୍ଚିତ୍ କଥଯାମାସ, ଯୋ ଜନ ଈଶ୍ୱରସ୍ୟ ରାଜ୍ୟେ ଭୋକ୍ତୁଂ ଲପ୍ସ୍ୟତେ ସଏୱ ଧନ୍ୟଃ| ");
INSERT INTO sanori_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ତତଃ ସ ଉୱାଚ, କଶ୍ଚିତ୍ ଜନୋ ରାତ୍ରୌ ଭେाଜ୍ୟଂ କୃତ୍ୱା ବହୂନ୍ ନିମନ୍ତ୍ରଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ତତୋ ଭୋଜନସମଯେ ନିମନ୍ତ୍ରିତଲୋକାନ୍ ଆହ୍ୱାତୁଂ ଦାସଦ୍ୱାରା କଥଯାମାସ, ଖଦ୍ୟଦ୍ରୱ୍ୟାଣି ସର୍ୱ୍ୱାଣି ସମାସାଦିତାନି ସନ୍ତି, ଯୂଯମାଗଚ୍ଛତ| ");
INSERT INTO sanori_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","କିନ୍ତୁ ତେ ସର୍ୱ୍ୱ ଏକୈକଂ ଛଲଂ କୃତ୍ୱା କ୍ଷମାଂ ପ୍ରାର୍ଥଯାଞ୍ଚକ୍ରିରେ| ପ୍ରଥମୋ ଜନଃ କଥଯାମାସ, କ୍ଷେତ୍ରମେକଂ କ୍ରୀତୱାନହଂ ତଦେୱ ଦ୍ରଷ୍ଟୁଂ ମଯା ଗନ୍ତୱ୍ୟମ୍, ଅତଏୱ ମାଂ କ୍ଷନ୍ତୁଂ ତଂ ନିୱେଦଯ| ");
INSERT INTO sanori_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","ଅନ୍ୟୋ ଜନଃ କଥଯାମାସ, ଦଶୱୃଷାନହଂ କ୍ରୀତୱାନ୍ ତାନ୍ ପରୀକ୍ଷିତୁଂ ଯାମି ତସ୍ମାଦେୱ ମାଂ କ୍ଷନ୍ତୁଂ ତଂ ନିୱେଦଯ| ");
INSERT INTO sanori_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","ଅପରଃ କଥଯାମାସ, ୱ୍ୟୂଢୱାନହଂ ତସ୍ମାତ୍ କାରଣାଦ୍ ଯାତୁଂ ନ ଶକ୍ନୋମି| ");
INSERT INTO sanori_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","ପଶ୍ଚାତ୍ ସ ଦାସୋ ଗତ୍ୱା ନିଜପ୍ରଭୋଃ ସାକ୍ଷାତ୍ ସର୍ୱ୍ୱୱୃତ୍ତାନ୍ତଂ ନିୱେଦଯାମାସ, ତତୋସୌ ଗୃହପତିଃ କୁପିତ୍ୱା ସ୍ୱଦାସଂ ୱ୍ୟାଜହାର, ତ୍ୱଂ ସତ୍ୱରଂ ନଗରସ୍ୟ ସନ୍ନିୱେଶାନ୍ ମାର୍ଗାଂଶ୍ଚ ଗତ୍ୱା ଦରିଦ୍ରଶୁଷ୍କକରଖଞ୍ଜାନ୍ଧାନ୍ ଅତ୍ରାନଯ| ");
INSERT INTO sanori_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","ତତୋ ଦାସୋଽୱଦତ୍, ହେ ପ୍ରଭୋ ଭୱତ ଆଜ୍ଞାନୁସାରେଣାକ୍ରିଯତ ତଥାପି ସ୍ଥାନମସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","ତଦା ପ୍ରଭୁଃ ପୁନ ର୍ଦାସାଯାକଥଯତ୍, ରାଜପଥାନ୍ ୱୃକ୍ଷମୂଲାନି ଚ ଯାତ୍ୱା ମଦୀଯଗୃହପୂରଣାର୍ଥଂ ଲୋକାନାଗନ୍ତୁଂ ପ୍ରୱର୍ତ୍ତଯ| ");
INSERT INTO sanori_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ଅହଂ ଯୁଷ୍ମଭ୍ୟଂ କଥଯାମି, ପୂର୍ୱ୍ୱନିମନ୍ତ୍ରିତାନମେକୋପି ମମାସ୍ୟ ରାତ୍ରିଭୋଜ୍ୟସ୍ୟାସ୍ୱାଦଂ ନ ପ୍ରାପ୍ସ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","ଅନନ୍ତରଂ ବହୁଷୁ ଲୋକେଷୁ ଯୀଶୋଃ ପଶ୍ଚାଦ୍ ୱ୍ରଜିତେଷୁ ସତ୍ସୁ ସ ୱ୍ୟାଘୁଟ୍ୟ ତେଭ୍ୟଃ କଥଯାମାସ, ");
INSERT INTO sanori_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","ଯଃ କଶ୍ଚିନ୍ ମମ ସମୀପମ୍ ଆଗତ୍ୟ ସ୍ୱସ୍ୟ ମାତା ପିତା ପତ୍ନୀ ସନ୍ତାନା ଭ୍ରାତରୋ ଭଗିମ୍ୟୋ ନିଜପ୍ରାଣାଶ୍ଚ, ଏତେଭ୍ୟଃ ସର୍ୱ୍ୱେଭ୍ୟୋ ମଯ୍ୟଧିକଂ ପ୍ରେମ ନ କରୋତି, ସ ମମ ଶିଷ୍ୟୋ ଭୱିତୁଂ ନ ଶକ୍ଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ଯଃ କଶ୍ଚିତ୍ ସ୍ୱୀଯଂ କ୍ରୁଶଂ ୱହନ୍ ମମ ପଶ୍ଚାନ୍ନ ଗଚ୍ଛତି, ସୋପି ମମ ଶିଷ୍ୟୋ ଭୱିତୁଂ ନ ଶକ୍ଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","ଦୁର୍ଗନିର୍ମ୍ମାଣେ କତିୱ୍ୟଯୋ ଭୱିଷ୍ୟତି, ତଥା ତସ୍ୟ ସମାପ୍ତିକରଣାର୍ଥଂ ସମ୍ପତ୍ତିରସ୍ତି ନ ୱା, ପ୍ରଥମମୁପୱିଶ୍ୟ ଏତନ୍ନ ଗଣଯତି, ଯୁଷ୍ମାକଂ ମଧ୍ୟ ଏତାଦୃଶଃ କୋସ୍ତି? ");
INSERT INTO sanori_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","ନୋଚେଦ୍ ଭିତ୍ତିଂ କୃତ୍ୱା ଶେଷେ ଯଦି ସମାପଯିତୁଂ ନ ଶକ୍ଷ୍ୟତି, ");
INSERT INTO sanori_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ତର୍ହି ମାନୁଷୋଯଂ ନିଚେତୁମ୍ ଆରଭତ ସମାପଯିତୁଂ ନାଶକ୍ନୋତ୍, ଇତି ୱ୍ୟାହୃତ୍ୟ ସର୍ୱ୍ୱେ ତମୁପହସିଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","ଅପରଞ୍ଚ ଭିନ୍ନଭୂପତିନା ସହ ଯୁଦ୍ଧଂ କର୍ତ୍ତୁମ୍ ଉଦ୍ୟମ୍ୟ ଦଶସହସ୍ରାଣି ସୈନ୍ୟାନି ଗୃହୀତ୍ୱା ୱିଂଶତିସହସ୍ରେଃ ସୈନ୍ୟୈଃ ସହିତସ୍ୟ ସମୀପୱାସିନଃ ସମ୍ମୁଖଂ ଯାତୁଂ ଶକ୍ଷ୍ୟାମି ନ ୱେତି ପ୍ରଥମଂ ଉପୱିଶ୍ୟ ନ ୱିଚାରଯତି ଏତାଦୃଶୋ ଭୂମିପତିଃ କଃ? ");
INSERT INTO sanori_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","ଯଦି ନ ଶକ୍ନୋତି ତର୍ହି ରିପାୱତିଦୂରେ ତିଷ୍ଠତି ସତି ନିଜଦୂତଂ ପ୍ରେଷ୍ୟ ସନ୍ଧିଂ କର୍ତ୍ତୁଂ ପ୍ରାର୍ଥଯେତ| ");
INSERT INTO sanori_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","ତଦ୍ୱଦ୍ ଯୁଷ୍ମାକଂ ମଧ୍ୟେ ଯଃ କଶ୍ଚିନ୍ ମଦର୍ଥଂ ସର୍ୱ୍ୱସ୍ୱଂ ହାତୁଂ ନ ଶକ୍ନୋତି ସ ମମ ଶିଷ୍ୟୋ ଭୱିତୁଂ ନ ଶକ୍ଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","ଲୱଣମ୍ ଉତ୍ତମମ୍ ଇତି ସତ୍ୟଂ, କିନ୍ତୁ ଯଦି ଲୱଣସ୍ୟ ଲୱଣତ୍ୱମ୍ ଅପଗଚ୍ଛତି ତର୍ହି ତତ୍ କଥଂ ସ୍ୱାଦୁଯୁକ୍ତଂ ଭୱିଷ୍ୟତି? ");
INSERT INTO sanori_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ତଦ ଭୂମ୍ୟର୍ଥମ୍ ଆଲୱାଲରାଶ୍ୟର୍ଥମପି ଭଦ୍ରଂ ନ ଭୱତି; ଲୋକାସ୍ତଦ୍ ବହିଃ କ୍ଷିପନ୍ତି| ଯସ୍ୟ ଶ୍ରୋତୁଂ ଶ୍ରୋତ୍ରେ ସ୍ତଃ ସ ଶୃଣୋତୁ| ");
INSERT INTO sanori_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ତଦା କରସଞ୍ଚାଯିନଃ ପାପିନଶ୍ଚ ଲୋକା ଉପଦେଶ୍କଥାଂ ଶ୍ରୋତୁଂ ଯୀଶୋଃ ସମୀପମ୍ ଆଗଚ୍ଛନ୍| ");
INSERT INTO sanori_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ତତଃ ଫିରୂଶିନ ଉପାଧ୍ୟାଯାଶ୍ଚ ୱିୱଦମାନାଃ କଥଯାମାସୁଃ ଏଷ ମାନୁଷଃ ପାପିଭିଃ ସହ ପ୍ରଣଯଂ କୃତ୍ୱା ତୈଃ ସାର୍ଦ୍ଧଂ ଭୁଂକ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ତଦା ସ ତେଭ୍ୟ ଇମାଂ ଦୃଷ୍ଟାନ୍ତକଥାଂ କଥିତୱାନ୍, ");
INSERT INTO sanori_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","କସ୍ୟଚିତ୍ ଶତମେଷେଷୁ ତିଷ୍ଠତ୍ମୁ ତେଷାମେକଂ ସ ଯଦି ହାରଯତି ତର୍ହି ମଧ୍ୟେପ୍ରାନ୍ତରମ୍ ଏକୋନଶତମେଷାନ୍ ୱିହାଯ ହାରିତମେଷସ୍ୟ ଉଦ୍ଦେଶପ୍ରାପ୍ତିପର୍ୟ୍ୟନତଂ ନ ଗୱେଷଯତି, ଏତାଦୃଶୋ ଲୋକୋ ଯୁଷ୍ମାକଂ ମଧ୍ୟେ କ ଆସ୍ତେ? ");
INSERT INTO sanori_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","ତସ୍ୟୋଦ୍ଦେଶଂ ପ୍ରାପ୍ୟ ହୃଷ୍ଟମନାସ୍ତଂ ସ୍କନ୍ଧେ ନିଧାଯ ସ୍ୱସ୍ଥାନମ୍ ଆନୀଯ ବନ୍ଧୁବାନ୍ଧୱସମୀପୱାସିନ ଆହୂଯ ୱକ୍ତି, ");
INSERT INTO sanori_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ହାରିତଂ ମେଷଂ ପ୍ରାପ୍ତୋହମ୍ ଅତୋ ହେତୋ ର୍ମଯା ସାର୍ଦ୍ଧମ୍ ଆନନ୍ଦତ| ");
INSERT INTO sanori_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","ତଦ୍ୱଦହଂ ଯୁଷ୍ମାନ୍ ୱଦାମି, ଯେଷାଂ ମନଃପରାୱର୍ତ୍ତନସ୍ୟ ପ୍ରଯୋଜନଂ ନାସ୍ତି, ତାଦୃଶୈକୋନଶତଧାର୍ମ୍ମିକକାରଣାଦ୍ ଯ ଆନନ୍ଦସ୍ତସ୍ମାଦ୍ ଏକସ୍ୟ ମନଃପରିୱର୍ତ୍ତିନଃ ପାପିନଃ କାରଣାତ୍ ସ୍ୱର୍ଗେ ଽଧିକାନନ୍ଦୋ ଜାଯତେ| ");
INSERT INTO sanori_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","ଅପରଞ୍ଚ ଦଶାନାଂ ରୂପ୍ୟଖଣ୍ଡାନାମ୍ ଏକଖଣ୍ଡେ ହାରିତେ ପ୍ରଦୀପଂ ପ୍ରଜ୍ୱାଲ୍ୟ ଗୃହଂ ସମ୍ମାର୍ଜ୍ୟ ତସ୍ୟ ପ୍ରାପ୍ତିଂ ଯାୱଦ୍ ଯତ୍ନେନ ନ ଗୱେଷଯତି, ଏତାଦୃଶୀ ଯୋଷିତ୍ କାସ୍ତେ? ");
INSERT INTO sanori_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ପ୍ରାପ୍ତେ ସତି ବନ୍ଧୁବାନ୍ଧୱସମୀପୱାସିନୀରାହୂଯ କଥଯତି, ହାରିତଂ ରୂପ୍ୟଖଣ୍ଡଂ ପ୍ରାପ୍ତାହଂ ତସ୍ମାଦେୱ ମଯା ସାର୍ଦ୍ଧମ୍ ଆନନ୍ଦତ| ");
INSERT INTO sanori_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","ତଦ୍ୱଦହଂ ଯୁଷ୍ମାନ୍ ୱ୍ୟାହରାମି, ଏକେନ ପାପିନା ମନସି ପରିୱର୍ତ୍ତିତେ, ଈଶ୍ୱରସ୍ୟ ଦୂତାନାଂ ମଧ୍ୟେପ୍ୟାନନ୍ଦୋ ଜାଯତେ| ");
INSERT INTO sanori_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","ଅପରଞ୍ଚ ସ କଥଯାମାସ, କସ୍ୟଚିଦ୍ ଦ୍ୱୌ ପୁତ୍ରାୱାସ୍ତାଂ, ");
INSERT INTO sanori_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ତଯୋଃ କନିଷ୍ଠଃ ପୁତ୍ରଃ ପିତ୍ରେ କଥଯାମାସ, ହେ ପିତସ୍ତୱ ସମ୍ପତ୍ତ୍ୟା ଯମଂଶଂ ପ୍ରାପ୍ସ୍ୟାମ୍ୟହଂ ୱିଭଜ୍ୟ ତଂ ଦେହି, ତତଃ ପିତା ନିଜାଂ ସମ୍ପତ୍ତିଂ ୱିଭଜ୍ୟ ତାଭ୍ୟାଂ ଦଦୌ| ");
INSERT INTO sanori_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","କତିପଯାତ୍ କାଲାତ୍ ପରଂ ସ କନିଷ୍ଠପୁତ୍ରଃ ସମସ୍ତଂ ଧନଂ ସଂଗୃହ୍ୟ ଦୂରଦେଶଂ ଗତ୍ୱା ଦୁଷ୍ଟାଚରଣେନ ସର୍ୱ୍ୱାଂ ସମ୍ପତ୍ତିଂ ନାଶଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ତସ୍ୟ ସର୍ୱ୍ୱଧନେ ୱ୍ୟଯଂ ଗତେ ତଦ୍ଦେଶେ ମହାଦୁର୍ଭିକ୍ଷଂ ବଭୂୱ, ତତସ୍ତସ୍ୟ ଦୈନ୍ୟଦଶା ଭୱିତୁମ୍ ଆରେଭେ| ");
INSERT INTO sanori_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ତତଃ ପରଂ ସ ଗତ୍ୱା ତଦ୍ଦେଶୀଯଂ ଗୃହସ୍ଥମେକମ୍ ଆଶ୍ରଯତ; ତତଃ ସତଂ ଶୂକରୱ୍ରଜଂ ଚାରଯିତୁଂ ପ୍ରାନ୍ତରଂ ପ୍ରେଷଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","କେନାପି ତସ୍ମୈ ଭକ୍ଷ୍ୟାଦାନାତ୍ ସ ଶୂକରଫଲୱଲ୍କଲେନ ପିଚିଣ୍ଡପୂରଣାଂ ୱୱାଞ୍ଛ| ");
INSERT INTO sanori_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ଶେଷେ ସ ମନସି ଚେତନାଂ ପ୍ରାପ୍ୟ କଥଯାମାସ, ହା ମମ ପିତୁଃ ସମୀପେ କତି କତି ୱେତନଭୁଜୋ ଦାସା ଯଥେଷ୍ଟଂ ତତୋଧିକଞ୍ଚ ଭକ୍ଷ୍ୟଂ ପ୍ରାପ୍ନୁୱନ୍ତି କିନ୍ତ୍ୱହଂ କ୍ଷୁଧା ମୁମୂର୍ଷୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ଅହମୁତ୍ଥାଯ ପିତୁଃ ସମୀପଂ ଗତ୍ୱା କଥାମେତାଂ ୱଦିଷ୍ୟାମି, ହେ ପିତର୍ ଈଶ୍ୱରସ୍ୟ ତୱ ଚ ୱିରୁଦ୍ଧଂ ପାପମକରୱମ୍ ");
INSERT INTO sanori_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ତୱ ପୁତ୍ରଇତି ୱିଖ୍ୟାତୋ ଭୱିତୁଂ ନ ଯୋଗ୍ୟୋସ୍ମି ଚ, ମାଂ ତୱ ୱୈତନିକଂ ଦାସଂ କୃତ୍ୱା ସ୍ଥାପଯ| ");
INSERT INTO sanori_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","ପଶ୍ଚାତ୍ ସ ଉତ୍ଥାଯ ପିତୁଃ ସମୀପଂ ଜଗାମ; ତତସ୍ତସ୍ୟ ପିତାତିଦୂରେ ତଂ ନିରୀକ୍ଷ୍ୟ ଦଯାଞ୍ଚକ୍ରେ, ଧାୱିତ୍ୱା ତସ୍ୟ କଣ୍ଠଂ ଗୃହୀତ୍ୱା ତଂ ଚୁଚୁମ୍ବ ଚ| ");
INSERT INTO sanori_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ତଦା ପୁତ୍ର ଉୱାଚ, ହେ ପିତର୍ ଈଶ୍ୱରସ୍ୟ ତୱ ଚ ୱିରୁଦ୍ଧଂ ପାପମକରୱଂ, ତୱ ପୁତ୍ରଇତି ୱିଖ୍ୟାତୋ ଭୱିତୁଂ ନ ଯୋଗ୍ୟୋସ୍ମି ଚ| ");
INSERT INTO sanori_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","କିନ୍ତୁ ତସ୍ୟ ପିତା ନିଜଦାସାନ୍ ଆଦିଦେଶ, ସର୍ୱ୍ୱୋତ୍ତମୱସ୍ତ୍ରାଣ୍ୟାନୀଯ ପରିଧାପଯତୈନଂ ହସ୍ତେ ଚାଙ୍ଗୁରୀଯକମ୍ ଅର୍ପଯତ ପାଦଯୋଶ୍ଚୋପାନହୌ ସମର୍ପଯତ; ");
INSERT INTO sanori_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ପୁଷ୍ଟଂ ଗୋୱତ୍ସମ୍ ଆନୀଯ ମାରଯତ ଚ ତଂ ଭୁକ୍ତ୍ୱା ୱଯମ୍ ଆନନ୍ଦାମ| ");
INSERT INTO sanori_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ଯତୋ ମମ ପୁତ୍ରୋଯମ୍ ଅମ୍ରିଯତ ପୁନରଜୀୱୀଦ୍ ହାରିତଶ୍ଚ ଲବ୍ଧୋଭୂତ୍ ତତସ୍ତ ଆନନ୍ଦିତୁମ୍ ଆରେଭିରେ| ");
INSERT INTO sanori_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","ତତ୍କାଲେ ତସ୍ୟ ଜ୍ୟେଷ୍ଠଃ ପୁତ୍ରଃ କ୍ଷେତ୍ର ଆସୀତ୍| ଅଥ ସ ନିୱେଶନସ୍ୟ ନିକଟଂ ଆଗଚ୍ଛନ୍ ନୃତ୍ୟାନାଂ ୱାଦ୍ୟାନାଞ୍ଚ ଶବ୍ଦଂ ଶ୍ରୁତ୍ୱା ");
INSERT INTO sanori_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ଦାସାନାମ୍ ଏକମ୍ ଆହୂଯ ପପ୍ରଚ୍ଛ, କିଂ କାରଣମସ୍ୟ? ");
INSERT INTO sanori_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","ତତଃ ସୋୱାଦୀତ୍, ତୱ ଭ୍ରାତାଗମତ୍, ତୱ ତାତଶ୍ଚ ତଂ ସୁଶରୀରଂ ପ୍ରାପ୍ୟ ପୁଷ୍ଟଂ ଗୋୱତ୍ସଂ ମାରିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","ତତଃ ସ ପ୍ରକୁପ୍ୟ ନିୱେଶନାନ୍ତଃ ପ୍ରୱେଷ୍ଟୁଂ ନ ସମ୍ମେନେ; ତତସ୍ତସ୍ୟ ପିତା ବହିରାଗତ୍ୟ ତଂ ସାଧଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ତତଃ ସ ପିତରଂ ପ୍ରତ୍ୟୁୱାଚ, ପଶ୍ୟ ତୱ କାଞ୍ଚିଦପ୍ୟାଜ୍ଞାଂ ନ ୱିଲଂଘ୍ୟ ବହୂନ୍ ୱତ୍ସରାନ୍ ଅହଂ ତ୍ୱାଂ ସେୱେ ତଥାପି ମିତ୍ରୈଃ ସାର୍ଦ୍ଧମ୍ ଉତ୍ସୱଂ କର୍ତ୍ତୁଂ କଦାପି ଛାଗମେକମପି ମହ୍ୟଂ ନାଦଦାଃ; ");
INSERT INTO sanori_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","କିନ୍ତୁ ତୱ ଯଃ ପୁତ୍ରୋ ୱେଶ୍ୟାଗମନାଦିଭିସ୍ତୱ ସମ୍ପତ୍ତିମ୍ ଅପୱ୍ୟଯିତୱାନ୍ ତସ୍ମିନ୍ନାଗତମାତ୍ରେ ତସ୍ୟୈୱ ନିମିତ୍ତଂ ପୁଷ୍ଟଂ ଗୋୱତ୍ସଂ ମାରିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","ତଦା ତସ୍ୟ ପିତାୱୋଚତ୍, ହେ ପୁତ୍ର ତ୍ୱଂ ସର୍ୱ୍ୱଦା ମଯା ସହାସି ତସ୍ମାନ୍ ମମ ଯଦ୍ୟଦାସ୍ତେ ତତ୍ସର୍ୱ୍ୱଂ ତୱ| ");
INSERT INTO sanori_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","କିନ୍ତୁ ତୱାଯଂ ଭ୍ରାତା ମୃତଃ ପୁନରଜୀୱୀଦ୍ ହାରିତଶ୍ଚ ଭୂତ୍ୱା ପ୍ରାପ୍ତୋଭୂତ୍, ଏତସ୍ମାତ୍ କାରଣାଦ୍ ଉତ୍ସୱାନନ୍ଦୌ କର୍ତ୍ତୁମ୍ ଉଚିତମସ୍ମାକମ୍| ");
INSERT INTO sanori_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","ଅପରଞ୍ଚ ଯୀଶୁଃ ଶିଷ୍ୟେଭ୍ୟୋନ୍ୟାମେକାଂ କଥାଂ କଥଯାମାସ କସ୍ୟଚିଦ୍ ଧନୱତୋ ମନୁଷ୍ୟସ୍ୟ ଗୃହକାର୍ୟ୍ୟାଧୀଶେ ସମ୍ପତ୍ତେରପୱ୍ୟଯେଽପୱାଦିତେ ସତି ");
INSERT INTO sanori_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","ତସ୍ୟ ପ୍ରଭୁସ୍ତମ୍ ଆହୂଯ ଜଗାଦ, ତ୍ୱଯି ଯାମିମାଂ କଥାଂ ଶୃଣୋମି ସା କୀଦୃଶୀ? ତ୍ୱଂ ଗୃହକାର୍ୟ୍ୟାଧୀଶକର୍ମ୍ମଣୋ ଗଣନାଂ ଦର୍ଶଯ ଗୃହକାର୍ୟ୍ୟାଧୀଶପଦେ ତ୍ୱଂ ନ ସ୍ଥାସ୍ୟସି| ");
INSERT INTO sanori_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","ତଦା ସ ଗୃହକାର୍ୟ୍ୟାଧୀଶୋ ମନସା ଚିନ୍ତଯାମାସ, ପ୍ରଭୁ ର୍ୟଦି ମାଂ ଗୃହକାର୍ୟ୍ୟାଧୀଶପଦାଦ୍ ଭ୍ରଂଶଯତି ତର୍ହି କିଂ କରିଷ୍ୟେଽହଂ? ମୃଦଂ ଖନିତୁଂ ମମ ଶକ୍ତି ର୍ନାସ୍ତି ଭିକ୍ଷିତୁଞ୍ଚ ଲଜ୍ଜିଷ୍ୟେଽହଂ| ");
INSERT INTO sanori_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ଅତଏୱ ମଯି ଗୃହକାର୍ୟ୍ୟାଧୀଶପଦାତ୍ ଚ୍ୟୁତେ ସତି ଯଥା ଲୋକା ମହ୍ୟମ୍ ଆଶ୍ରଯଂ ଦାସ୍ୟନ୍ତି ତଦର୍ଥଂ ଯତ୍କର୍ମ୍ମ ମଯା କରଣୀଯଂ ତନ୍ ନିର୍ଣୀଯତେ| ");
INSERT INTO sanori_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","ପଶ୍ଚାତ୍ ସ ସ୍ୱପ୍ରଭୋରେକୈକମ୍ ଅଧମର୍ଣମ୍ ଆହୂଯ ପ୍ରଥମଂ ପପ୍ରଚ୍ଛ, ତ୍ୱତ୍ତୋ ମେ ପ୍ରଭୁଣା କତି ପ୍ରାପ୍ୟମ୍? ");
INSERT INTO sanori_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ତତଃ ସ ଉୱାଚ, ଏକଶତାଢକତୈଲାନି; ତଦା ଗୃହକାର୍ୟ୍ୟାଧୀଶଃ ପ୍ରୋୱାଚ, ତୱ ପତ୍ରମାନୀଯ ଶୀଘ୍ରମୁପୱିଶ୍ୟ ତତ୍ର ପଞ୍ଚାଶତଂ ଲିଖ| ");
INSERT INTO sanori_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","ପଶ୍ଚାଦନ୍ୟମେକଂ ପପ୍ରଚ୍ଛ, ତ୍ୱତ୍ତୋ ମେ ପ୍ରଭୁଣା କତି ପ୍ରାପ୍ୟମ୍? ତତଃ ସୋୱାଦୀଦ୍ ଏକଶତାଢକଗୋଧୂମାଃ; ତଦା ସ କଥଯାମାସ, ତୱ ପତ୍ରମାନୀଯ ଅଶୀତିଂ ଲିଖ| ");
INSERT INTO sanori_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","ତେନୈୱ ପ୍ରଭୁସ୍ତମଯଥାର୍ଥକୃତମ୍ ଅଧୀଶଂ ତଦ୍ବୁଦ୍ଧିନୈପୁଣ୍ୟାତ୍ ପ୍ରଶଶଂସ; ଇତ୍ଥଂ ଦୀପ୍ତିରୂପସନ୍ତାନେଭ୍ୟ ଏତତ୍ସଂସାରସ୍ୟ ସନ୍ତାନା ୱର୍ତ୍ତମାନକାଲେଽଧିକବୁଦ୍ଧିମନ୍ତୋ ଭୱନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","ଅତୋ ୱଦାମି ଯୂଯମପ୍ୟଯଥାର୍ଥେନ ଧନେନ ମିତ୍ରାଣି ଲଭଧ୍ୱଂ ତତୋ ଯୁଷ୍ମାସୁ ପଦଭ୍ରଷ୍ଟେଷ୍ୱପି ତାନି ଚିରକାଲମ୍ ଆଶ୍ରଯଂ ଦାସ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ଯଃ କଶ୍ଚିତ୍ କ୍ଷୁଦ୍ରେ କାର୍ୟ୍ୟେ ୱିଶ୍ୱାସ୍ୟୋ ଭୱତି ସ ମହତି କାର୍ୟ୍ୟେପି ୱିଶ୍ୱାସ୍ୟୋ ଭୱତି, କିନ୍ତୁ ଯଃ କଶ୍ଚିତ୍ କ୍ଷୁଦ୍ରେ କାର୍ୟ୍ୟେଽୱିଶ୍ୱାସ୍ୟୋ ଭୱତି ସ ମହତି କାର୍ୟ୍ୟେପ୍ୟୱିଶ୍ୱାସ୍ୟୋ ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ଅତଏୱ ଅଯଥାର୍ଥେନ ଧନେନ ଯଦି ଯୂଯମୱିଶ୍ୱାସ୍ୟା ଜାତାସ୍ତର୍ହି ସତ୍ୟଂ ଧନଂ ଯୁଷ୍ମାକଂ କରେଷୁ କଃ ସମର୍ପଯିଷ୍ୟତି? ");
INSERT INTO sanori_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","ଯଦି ଚ ପରଧନେନ ଯୂଯମ୍ ଅୱିଶ୍ୱାସ୍ୟା ଭୱଥ ତର୍ହି ଯୁଷ୍ମାକଂ ସ୍ୱକୀଯଧନଂ ଯୁଷ୍ମଭ୍ୟଂ କୋ ଦାସ୍ୟତି? ");
INSERT INTO sanori_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","କୋପି ଦାସ ଉଭୌ ପ୍ରଭୂ ସେୱିତୁଂ ନ ଶକ୍ନୋତି, ଯତ ଏକସ୍ମିନ୍ ପ୍ରୀଯମାଣୋଽନ୍ୟସ୍ମିନ୍ନପ୍ରୀଯତେ ଯଦ୍ୱା ଏକଂ ଜନଂ ସମାଦୃତ୍ୟ ତଦନ୍ୟଂ ତୁଚ୍ଛୀକରୋତି ତଦ୍ୱଦ୍ ଯୂଯମପି ଧନେଶ୍ୱରୌ ସେୱିତୁଂ ନ ଶକ୍ନୁଥ| ");
INSERT INTO sanori_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ତଦୈତାଃ ସର୍ୱ୍ୱାଃ କଥାଃ ଶ୍ରୁତ୍ୱା ଲୋଭିଫିରୂଶିନସ୍ତମୁପଜହସୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ତତଃ ସ ଉୱାଚ, ଯୂଯଂ ମନୁଷ୍ୟାଣାଂ ନିକଟେ ସ୍ୱାନ୍ ନିର୍ଦୋଷାନ୍ ଦର୍ଶଯଥ କିନ୍ତୁ ଯୁଷ୍ମାକମ୍ ଅନ୍ତଃକରଣାନୀଶ୍ୱରୋ ଜାନାତି, ଯତ୍ ମନୁଷ୍ୟାଣାମ୍ ଅତି ପ୍ରଶଂସ୍ୟଂ ତଦ୍ ଈଶ୍ୱରସ୍ୟ ଘୃଣ୍ୟଂ| ");
INSERT INTO sanori_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","ଯୋହନ ଆଗମନପର୍ୟ୍ୟନତଂ ଯୁଷ୍ମାକଂ ସମୀପେ ୱ୍ୟୱସ୍ଥାଭୱିଷ୍ୟଦ୍ୱାଦିନାଂ ଲେଖନାନି ଚାସନ୍ ତତଃ ପ୍ରଭୃତି ଈଶ୍ୱରରାଜ୍ୟସ୍ୟ ସୁସଂୱାଦଃ ପ୍ରଚରତି, ଏକୈକୋ ଲୋକସ୍ତନ୍ମଧ୍ୟଂ ଯତ୍ନେନ ପ୍ରୱିଶତି ଚ| ");
INSERT INTO sanori_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ୱରଂ ନଭସଃ ପୃଥିୱ୍ୟାଶ୍ଚ ଲୋପୋ ଭୱିଷ୍ୟତି ତଥାପି ୱ୍ୟୱସ୍ଥାଯା ଏକବିନ୍ଦୋରପି ଲୋପୋ ନ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","ଯଃ କଶ୍ଚିତ୍ ସ୍ୱୀଯାଂ ଭାର୍ୟ୍ୟାଂ ୱିହାଯ ସ୍ତ୍ରିଯମନ୍ୟାଂ ୱିୱହତି ସ ପରଦାରାନ୍ ଗଚ୍ଛତି, ଯଶ୍ଚ ତା ତ୍ୟକ୍ତାଂ ନାରୀଂ ୱିୱହତି ସୋପି ପରଦାରାନ ଗଚ୍ଛତି| ");
INSERT INTO sanori_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ଏକୋ ଧନୀ ମନୁଷ୍ୟଃ ଶୁକ୍ଲାନି ସୂକ୍ଷ୍ମାଣି ୱସ୍ତ୍ରାଣି ପର୍ୟ୍ୟଦଧାତ୍ ପ୍ରତିଦିନଂ ପରିତୋଷରୂପେଣାଭୁଂକ୍ତାପିୱଚ୍ଚ| ");
INSERT INTO sanori_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","ସର୍ୱ୍ୱାଙ୍ଗେ କ୍ଷତଯୁକ୍ତ ଇଲିଯାସରନାମା କଶ୍ଚିଦ୍ ଦରିଦ୍ରସ୍ତସ୍ୟ ଧନୱତୋ ଭୋଜନପାତ୍ରାତ୍ ପତିତମ୍ ଉଚ୍ଛିଷ୍ଟଂ ଭୋକ୍ତୁଂ ୱାଞ୍ଛନ୍ ତସ୍ୟ ଦ୍ୱାରେ ପତିତ୍ୱାତିଷ୍ଠତ୍; ");
INSERT INTO sanori_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ଅଥ ଶ୍ୱାନ ଆଗତ୍ୟ ତସ୍ୟ କ୍ଷତାନ୍ୟଲିହନ୍| ");
INSERT INTO sanori_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","କିଯତ୍କାଲାତ୍ପରଂ ସ ଦରିଦ୍ରଃ ପ୍ରାଣାନ୍ ଜହୌ; ତତଃ ସ୍ୱର୍ଗୀଯଦୂତାସ୍ତଂ ନୀତ୍ୱା ଇବ୍ରାହୀମଃ କ୍ରୋଡ ଉପୱେଶଯାମାସୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ପଶ୍ଚାତ୍ ସ ଧନୱାନପି ମମାର, ତଂ ଶ୍ମଶାନେ ସ୍ଥାପଯାମାସୁଶ୍ଚ; କିନ୍ତୁ ପରଲୋକେ ସ ୱେଦନାକୁଲଃ ସନ୍ ଊର୍ଦ୍ଧ୍ୱାଂ ନିରୀକ୍ଷ୍ୟ ବହୁଦୂରାଦ୍ ଇବ୍ରାହୀମଂ ତତ୍କ୍ରୋଡ ଇଲିଯାସରଞ୍ଚ ୱିଲୋକ୍ୟ ରୁୱନ୍ନୁୱାଚ; ");
INSERT INTO sanori_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ହେ ପିତର୍ ଇବ୍ରାହୀମ୍ ଅନୁଗୃହ୍ୟ ଅଙ୍ଗୁଲ୍ୟଗ୍ରଭାଗଂ ଜଲେ ମଜ୍ଜଯିତ୍ୱା ମମ ଜିହ୍ୱାଂ ଶୀତଲାଂ କର୍ତ୍ତୁମ୍ ଇଲିଯାସରଂ ପ୍ରେରଯ, ଯତୋ ୱହ୍ନିଶିଖାତୋହଂ ୱ୍ୟଥିତୋସ୍ମି| ");
INSERT INTO sanori_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","ତଦା ଇବ୍ରାହୀମ୍ ବଭାଷେ, ହେ ପୁତ୍ର ତ୍ୱଂ ଜୀୱନ୍ ସମ୍ପଦଂ ପ୍ରାପ୍ତୱାନ୍ ଇଲିଯାସରସ୍ତୁ ୱିପଦଂ ପ୍ରାପ୍ତୱାନ୍ ଏତତ୍ ସ୍ମର, କିନ୍ତୁ ସମ୍ପ୍ରତି ତସ୍ୟ ସୁଖଂ ତୱ ଚ ଦୁଃଖଂ ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","ଅପରମପି ଯୁଷ୍ମାକମ୍ ଅସ୍ମାକଞ୍ଚ ସ୍ଥାନଯୋ ର୍ମଧ୍ୟେ ମହଦ୍ୱିଚ୍ଛେଦୋଽସ୍ତି ତତ ଏତତ୍ସ୍ଥାନସ୍ୟ ଲୋକାସ୍ତତ୍ ସ୍ଥାନଂ ଯାତୁଂ ଯଦ୍ୱା ତତ୍ସ୍ଥାନସ୍ୟ ଲୋକା ଏତତ୍ ସ୍ଥାନମାଯାତୁଂ ନ ଶକ୍ନୁୱନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","ତଦା ସ ଉକ୍ତୱାନ୍, ହେ ପିତସ୍ତର୍ହି ତ୍ୱାଂ ନିୱେଦଯାମି ମମ ପିତୁ ର୍ଗେହେ ଯେ ମମ ପଞ୍ଚ ଭ୍ରାତରଃ ସନ୍ତି ");
INSERT INTO sanori_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ତେ ଯଥୈତଦ୍ ଯାତନାସ୍ଥାନଂ ନାଯାସ୍ୟନ୍ତି ତଥା ମନ୍ତ୍ରଣାଂ ଦାତୁଂ ତେଷାଂ ସମୀପମ୍ ଇଲିଯାସରଂ ପ୍ରେରଯ| ");
INSERT INTO sanori_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","ତତ ଇବ୍ରାହୀମ୍ ଉୱାଚ, ମୂସାଭୱିଷ୍ୟଦ୍ୱାଦିନାଞ୍ଚ ପୁସ୍ତକାନି ତେଷାଂ ନିକଟେ ସନ୍ତି ତେ ତଦ୍ୱଚନାନି ମନ୍ୟନ୍ତାଂ| ");
INSERT INTO sanori_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","ତଦା ସ ନିୱେଦଯାମାସ, ହେ ପିତର୍ ଇବ୍ରାହୀମ୍ ନ ତଥା, କିନ୍ତୁ ଯଦି ମୃତଲୋକାନାଂ କଶ୍ଚିତ୍ ତେଷାଂ ସମୀପଂ ଯାତି ତର୍ହି ତେ ମନାଂସି ୱ୍ୟାଘୋଟଯିଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","ତତ ଇବ୍ରାହୀମ୍ ଜଗାଦ, ତେ ଯଦି ମୂସାଭୱିଷ୍ୟଦ୍ୱାଦିନାଞ୍ଚ ୱଚନାନି ନ ମନ୍ୟନ୍ତେ ତର୍ହି ମୃତଲୋକାନାଂ କସ୍ମିଂଶ୍ଚିଦ୍ ଉତ୍ଥିତେପି ତେ ତସ୍ୟ ମନ୍ତ୍ରଣାଂ ନ ମଂସ୍ୟନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ଇତଃ ପରଂ ଯୀଶୁଃ ଶିଷ୍ୟାନ୍ ଉୱାଚ, ୱିଘ୍ନୈରୱଶ୍ୟମ୍ ଆଗନ୍ତୱ୍ୟଂ କିନ୍ତୁ ୱିଘ୍ନା ଯେନ ଘଟିଷ୍ୟନ୍ତେ ତସ୍ୟ ଦୁର୍ଗତି ର୍ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ଏତେଷାଂ କ୍ଷୁଦ୍ରପ୍ରାଣିନାମ୍ ଏକସ୍ୟାପି ୱିଘ୍ନଜନନାତ୍ କଣ୍ଠବଦ୍ଧପେଷଣୀକସ୍ୟ ତସ୍ୟ ସାଗରାଗାଧଜଲେ ମଜ୍ଜନଂ ଭଦ୍ରଂ| ");
INSERT INTO sanori_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","ଯୂଯଂ ସ୍ୱେଷୁ ସାୱଧାନାସ୍ତିଷ୍ଠତ; ତୱ ଭ୍ରାତା ଯଦି ତୱ କିଞ୍ଚିଦ୍ ଅପରାଧ୍ୟତି ତର୍ହି ତଂ ତର୍ଜଯ, ତେନ ଯଦି ମନଃ ପରିୱର୍ତ୍ତଯତି ତର୍ହି ତଂ କ୍ଷମସ୍ୱ| ");
INSERT INTO sanori_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","ପୁନରେକଦିନମଧ୍ୟେ ଯଦି ସ ତୱ ସପ୍ତକୃତ୍ୱୋଽପରାଧ୍ୟତି କିନ୍ତୁ ସପ୍ତକୃତ୍ୱ ଆଗତ୍ୟ ମନଃ ପରିୱର୍ତ୍ୟ ମଯାପରାଦ୍ଧମ୍ ଇତି ୱଦତି ତର୍ହି ତଂ କ୍ଷମସ୍ୱ| ");
INSERT INTO sanori_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","ତଦା ପ୍ରେରିତାଃ ପ୍ରଭୁମ୍ ଅୱଦନ୍ ଅସ୍ମାକଂ ୱିଶ୍ୱାସଂ ୱର୍ଦ୍ଧଯ| ");
INSERT INTO sanori_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ପ୍ରଭୁରୁୱାଚ, ଯଦି ଯୁଷ୍ମାକଂ ସର୍ଷପୈକପ୍ରମାଣୋ ୱିଶ୍ୱାସୋସ୍ତି ତର୍ହି ତ୍ୱଂ ସମୂଲମୁତ୍ପାଟିତୋ ଭୂତ୍ୱା ସମୁଦ୍ରେ ରୋପିତୋ ଭୱ କଥାଯାମ୍ ଏତସ୍ୟାମ୍ ଏତଦୁଡୁମ୍ବରାଯ କଥିତାଯାଂ ସ ଯୁଷ୍ମାକମାଜ୍ଞାୱହୋ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","ଅପରଂ ସ୍ୱଦାସେ ହଲଂ ୱାହଯିତ୍ୱା ୱା ପଶୂନ୍ ଚାରଯିତ୍ୱା କ୍ଷେତ୍ରାଦ୍ ଆଗତେ ସତି ତଂ ୱଦତି, ଏହି ଭୋକ୍ତୁମୁପୱିଶ, ଯୁଷ୍ମାକମ୍ ଏତାଦୃଶଃ କୋସ୍ତି? ");
INSERT INTO sanori_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ୱରଞ୍ଚ ପୂର୍ୱ୍ୱଂ ମମ ଖାଦ୍ୟମାସାଦ୍ୟ ଯାୱଦ୍ ଭୁଞ୍ଜେ ପିୱାମି ଚ ତାୱଦ୍ ବଦ୍ଧକଟିଃ ପରିଚର ପଶ୍ଚାତ୍ ତ୍ୱମପି ଭୋକ୍ଷ୍ୟସେ ପାସ୍ୟସି ଚ କଥାମୀଦୃଶୀଂ କିଂ ନ ୱକ୍ଷ୍ୟତି? ");
INSERT INTO sanori_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","ତେନ ଦାସେନ ପ୍ରଭୋରାଜ୍ଞାନୁରୂପେ କର୍ମ୍ମଣି କୃତେ ପ୍ରଭୁଃ କିଂ ତସ୍ମିନ୍ ବାଧିତୋ ଜାତଃ? ନେତ୍ଥଂ ବୁଧ୍ୟତେ ମଯା| ");
INSERT INTO sanori_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ଇତ୍ଥଂ ନିରୂପିତେଷୁ ସର୍ୱ୍ୱକର୍ମ୍ମସୁ କୃତେଷୁ ସତ୍ମୁ ଯୂଯମପୀଦଂ ୱାକ୍ୟଂ ୱଦଥ, ୱଯମ୍ ଅନୁପକାରିଣୋ ଦାସା ଅସ୍ମାଭିର୍ୟଦ୍ୟତ୍କର୍ତ୍ତୱ୍ୟଂ ତନ୍ମାତ୍ରମେୱ କୃତଂ| ");
INSERT INTO sanori_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ସ ଯିରୂଶାଲମି ଯାତ୍ରାଂ କୁର୍ୱ୍ୱନ୍ ଶୋମିରୋଣ୍ଗାଲୀଲ୍ପ୍ରଦେଶମଧ୍ୟେନ ଗଚ୍ଛତି, ");
INSERT INTO sanori_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ଏତର୍ହି କୁତ୍ରଚିଦ୍ ଗ୍ରାମେ ପ୍ରୱେଶମାତ୍ରେ ଦଶକୁଷ୍ଠିନସ୍ତଂ ସାକ୍ଷାତ୍ କୃତ୍ୱା ");
INSERT INTO sanori_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ଦୂରେ ତିଷ୍ଠନତ ଉଚ୍ଚୈ ର୍ୱକ୍ତୁମାରେଭିରେ, ହେ ପ୍ରଭୋ ଯୀଶୋ ଦଯସ୍ୱାସ୍ମାନ୍| ");
INSERT INTO sanori_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ତତଃ ସ ତାନ୍ ଦୃଷ୍ଟ୍ୱା ଜଗାଦ, ଯୂଯଂ ଯାଜକାନାଂ ସମୀପେ ସ୍ୱାନ୍ ଦର୍ଶଯତ, ତତସ୍ତେ ଗଚ୍ଛନ୍ତୋ ରୋଗାତ୍ ପରିଷ୍କୃତାଃ| ");
INSERT INTO sanori_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","ତଦା ତେଷାମେକଃ ସ୍ୱଂ ସ୍ୱସ୍ଥଂ ଦୃଷ୍ଟ୍ୱା ପ୍ରୋଚ୍ଚୈରୀଶ୍ୱରଂ ଧନ୍ୟଂ ୱଦନ୍ ୱ୍ୟାଘୁଟ୍ୟାଯାତୋ ଯୀଶୋ ର୍ଗୁଣାନନୁୱଦନ୍ ତଚ୍ଚରଣାଧୋଭୂମୌ ପପାତ; ");
INSERT INTO sanori_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ସ ଚାସୀତ୍ ଶୋମିରୋଣୀ| ");
INSERT INTO sanori_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ତଦା ଯୀଶୁରୱଦତ୍, ଦଶଜନାଃ କିଂ ନ ପରିଷ୍କୃତାଃ? ତହ୍ୟନ୍ୟେ ନୱଜନାଃ କୁତ୍ର? ");
INSERT INTO sanori_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ଈଶ୍ୱରଂ ଧନ୍ୟଂ ୱଦନ୍ତମ୍ ଏନଂ ୱିଦେଶିନଂ ୱିନା କୋପ୍ୟନ୍ୟୋ ନ ପ୍ରାପ୍ୟତ| ");
INSERT INTO sanori_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ତଦା ସ ତମୁୱାଚ, ତ୍ୱମୁତ୍ଥାଯ ଯାହି ୱିଶ୍ୱାସସ୍ତେ ତ୍ୱାଂ ସ୍ୱସ୍ଥଂ କୃତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","ଅଥ କଦେଶ୍ୱରସ୍ୟ ରାଜତ୍ୱଂ ଭୱିଷ୍ୟତୀତି ଫିରୂଶିଭିଃ ପୃଷ୍ଟେ ସ ପ୍ରତ୍ୟୁୱାଚ, ଈଶ୍ୱରସ୍ୟ ରାଜତ୍ୱମ୍ ଐଶ୍ୱର୍ୟ୍ୟଦର୍ଶନେନ ନ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ଅତ ଏତସ୍ମିନ୍ ପଶ୍ୟ ତସ୍ମିନ୍ ୱା ପଶ୍ୟ, ଇତି ୱାକ୍ୟଂ ଲୋକା ୱକ୍ତୁଂ ନ ଶକ୍ଷ୍ୟନ୍ତି, ଈଶ୍ୱରସ୍ୟ ରାଜତ୍ୱଂ ଯୁଷ୍ମାକମ୍ ଅନ୍ତରେୱାସ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ତତଃ ସ ଶିଷ୍ୟାନ୍ ଜଗାଦ, ଯଦା ଯୁଷ୍ମାଭି ର୍ମନୁଜସୁତସ୍ୟ ଦିନମେକଂ ଦ୍ରଷ୍ଟୁମ୍ ୱାଞ୍ଛିଷ୍ୟତେ କିନ୍ତୁ ନ ଦର୍ଶିଷ୍ୟତେ, ଈଦୃକ୍କାଲ ଆଯାତି| ");
INSERT INTO sanori_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","ତଦାତ୍ର ପଶ୍ୟ ୱା ତତ୍ର ପଶ୍ୟେତି ୱାକ୍ୟଂ ଲୋକା ୱକ୍ଷ୍ୟନ୍ତି, କିନ୍ତୁ ତେଷାଂ ପଶ୍ଚାତ୍ ମା ଯାତ, ମାନୁଗଚ୍ଛତ ଚ| ");
INSERT INTO sanori_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","ଯତସ୍ତଡିଦ୍ ଯଥାକାଶୈକଦିଶ୍ୟୁଦିଯ ତଦନ୍ୟାମପି ଦିଶଂ ୱ୍ୟାପ୍ୟ ପ୍ରକାଶତେ ତଦ୍ୱତ୍ ନିଜଦିନେ ମନୁଜସୂନୁଃ ପ୍ରକାଶିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","କିନ୍ତୁ ତତ୍ପୂର୍ୱ୍ୱଂ ତେନାନେକାନି ଦୁଃଖାନି ଭୋକ୍ତୱ୍ୟାନ୍ୟେତଦ୍ୱର୍ତ୍ତମାନଲୋକୈଶ୍ଚ ସୋଽୱଜ୍ଞାତୱ୍ୟଃ| ");
INSERT INTO sanori_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","ନୋହସ୍ୟ ୱିଦ୍ୟମାନକାଲେ ଯଥାଭୱତ୍ ମନୁଷ୍ୟସୂନୋଃ କାଲେପି ତଥା ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ଯାୱତ୍କାଲଂ ନୋହୋ ମହାପୋତଂ ନାରୋହଦ୍ ଆପ୍ଲାୱିୱାର୍ୟ୍ୟେତ୍ୟ ସର୍ୱ୍ୱଂ ନାନାଶଯଚ୍ଚ ତାୱତ୍କାଲଂ ଯଥା ଲୋକା ଅଭୁଞ୍ଜତାପିୱନ୍ ୱ୍ୟୱହନ୍ ୱ୍ୟୱାହଯଂଶ୍ଚ; ");
INSERT INTO sanori_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ଇତ୍ଥଂ ଲୋଟୋ ୱର୍ତ୍ତମାନକାଲେପି ଯଥା ଲୋକା ଭୋଜନପାନକ୍ରଯୱିକ୍ରଯରୋପଣଗୃହନିର୍ମ୍ମାଣକର୍ମ୍ମସୁ ପ୍ରାୱର୍ତ୍ତନ୍ତ, ");
INSERT INTO sanori_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","କିନ୍ତୁ ଯଦା ଲୋଟ୍ ସିଦୋମୋ ନିର୍ଜଗାମ ତଦା ନଭସଃ ସଗନ୍ଧକାଗ୍ନିୱୃଷ୍ଟି ର୍ଭୂତ୍ୱା ସର୍ୱ୍ୱଂ ୱ୍ୟନାଶଯତ୍ ");
INSERT INTO sanori_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","ତଦ୍ୱନ୍ ମାନୱପୁତ୍ରପ୍ରକାଶଦିନେପି ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","ତଦା ଯଦି କଶ୍ଚିଦ୍ ଗୃହୋପରି ତିଷ୍ଠତି ତର୍ହି ସ ଗୃହମଧ୍ୟାତ୍ କିମପି ଦ୍ରୱ୍ୟମାନେତୁମ୍ ଅୱରୁହ୍ୟ ନୈତୁ; ଯଶ୍ଚ କ୍ଷେତ୍ରେ ତିଷ୍ଠତି ସୋପି ୱ୍ୟାଘୁଟ୍ୟ ନାଯାତୁ| ");
INSERT INTO sanori_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","ଲୋଟଃ ପତ୍ନୀଂ ସ୍ମରତ| ");
INSERT INTO sanori_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ଯଃ ପ୍ରାଣାନ୍ ରକ୍ଷିତୁଂ ଚେଷ୍ଟିଷ୍ୟତେ ସ ପ୍ରାଣାନ୍ ହାରଯିଷ୍ୟତି ଯସ୍ତୁ ପ୍ରାଣାନ୍ ହାରଯିଷ୍ୟତି ସଏୱ ପ୍ରାଣାନ୍ ରକ୍ଷିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","ଯୁଷ୍ମାନହଂ ୱଚ୍ମି ତସ୍ୟାଂ ରାତ୍ରୌ ଶଯ୍ୟୈକଗତଯୋ ର୍ଲୋକଯୋରେକୋ ଧାରିଷ୍ୟତେ ପରସ୍ତ୍ୟକ୍ଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ସ୍ତ୍ରିଯୌ ଯୁଗପତ୍ ପେଷଣୀଂ ୱ୍ୟାୱର୍ତ୍ତଯିଷ୍ୟତସ୍ତଯୋରେକା ଧାରିଷ୍ୟତେ ପରାତ୍ୟକ୍ଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","ପୁରୁଷୌ କ୍ଷେତ୍ରେ ସ୍ଥାସ୍ୟତସ୍ତଯୋରେକୋ ଧାରିଷ୍ୟତେ ପରସ୍ତ୍ୟକ୍ଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ତଦା ତେ ପପ୍ରଚ୍ଛୁଃ, ହେ ପ୍ରଭୋ କୁତ୍ରେତ୍ଥଂ ଭୱିଷ୍ୟତି? ତତଃ ସ ଉୱାଚ, ଯତ୍ର ଶୱସ୍ତିଷ୍ଠତି ତତ୍ର ଗୃଧ୍ରା ମିଲନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ଅପରଞ୍ଚ ଲୋକୈରକ୍ଲାନ୍ତୈ ର୍ନିରନ୍ତରଂ ପ୍ରାର୍ଥଯିତୱ୍ୟମ୍ ଇତ୍ୟାଶଯେନ ଯୀଶୁନା ଦୃଷ୍ଟାନ୍ତ ଏକଃ କଥିତଃ| ");
INSERT INTO sanori_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","କୁତ୍ରଚିନ୍ନଗରେ କଶ୍ଚିତ୍ ପ୍ରାଡ୍ୱିୱାକ ଆସୀତ୍ ସ ଈଶ୍ୱରାନ୍ନାବିଭେତ୍ ମାନୁଷାଂଶ୍ଚ ନାମନ୍ୟତ| ");
INSERT INTO sanori_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","ଅଥ ତତ୍ପୁରୱାସିନୀ କାଚିଦ୍ୱିଧୱା ତତ୍ସମୀପମେତ୍ୟ ୱିୱାଦିନା ସହ ମମ ୱିୱାଦଂ ପରିଷ୍କୁର୍ୱ୍ୱିତି ନିୱେଦଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ତତଃ ସ ପ୍ରାଡ୍ୱିୱାକଃ କିଯଦ୍ଦିନାନି ନ ତଦଙ୍ଗୀକୃତୱାନ୍ ପଶ୍ଚାଚ୍ଚିତ୍ତେ ଚିନ୍ତଯାମାସ, ଯଦ୍ୟପୀଶ୍ୱରାନ୍ନ ବିଭେମି ମନୁଷ୍ୟାନପି ନ ମନ୍ୟେ ");
INSERT INTO sanori_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ତଥାପ୍ୟେଷା ୱିଧୱା ମାଂ କ୍ଲିଶ୍ନାତି ତସ୍ମାଦସ୍ୟା ୱିୱାଦଂ ପରିଷ୍କରିଷ୍ୟାମି ନୋଚେତ୍ ସା ସଦାଗତ୍ୟ ମାଂ ୱ୍ୟଗ୍ରଂ କରିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ପଶ୍ଚାତ୍ ପ୍ରଭୁରୱଦଦ୍ ଅସାୱନ୍ୟାଯପ୍ରାଡ୍ୱିୱାକୋ ଯଦାହ ତତ୍ର ମନୋ ନିଧଧ୍ୱଂ| ");
INSERT INTO sanori_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ଈଶ୍ୱରସ୍ୟ ଯେ ଽଭିରୁଚିତଲୋକା ଦିୱାନିଶଂ ପ୍ରାର୍ଥଯନ୍ତେ ସ ବହୁଦିନାନି ୱିଲମ୍ବ୍ୟାପି ତେଷାଂ ୱିୱାଦାନ୍ କିଂ ନ ପରିଷ୍କରିଷ୍ୟତି? ");
INSERT INTO sanori_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","ଯୁଷ୍ମାନହଂ ୱଦାମି ତ୍ୱରଯା ପରିଷ୍କରିଷ୍ୟତି, କିନ୍ତୁ ଯଦା ମନୁଷ୍ୟପୁତ୍ର ଆଗମିଷ୍ୟତି ତଦା ପୃଥିୱ୍ୟାଂ କିମୀଦୃଶଂ ୱିଶ୍ୱାସଂ ପ୍ରାପ୍ସ୍ୟତି? ");
INSERT INTO sanori_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ଯେ ସ୍ୱାନ୍ ଧାର୍ମ୍ମିକାନ୍ ଜ୍ଞାତ୍ୱା ପରାନ୍ ତୁଚ୍ଛୀକୁର୍ୱ୍ୱନ୍ତି ଏତାଦୃଗ୍ଭ୍ୟଃ, କିଯଦ୍ଭ୍ୟ ଇମଂ ଦୃଷ୍ଟାନ୍ତଂ କଥଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","ଏକଃ ଫିରୂଶ୍ୟପରଃ କରସଞ୍ଚାଯୀ ଦ୍ୱାୱିମୌ ପ୍ରାର୍ଥଯିତୁଂ ମନ୍ଦିରଂ ଗତୌ| ");
INSERT INTO sanori_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ତତୋଽସୌ ଫିରୂଶ୍ୟେକପାର୍ଶ୍ୱେ ତିଷ୍ଠନ୍ ହେ ଈଶ୍ୱର ଅହମନ୍ୟଲୋକୱତ୍ ଲୋଠଯିତାନ୍ୟାଯୀ ପାରଦାରିକଶ୍ଚ ନ ଭୱାମି ଅସ୍ୟ କରସଞ୍ଚାଯିନସ୍ତୁଲ୍ୟଶ୍ଚ ନ, ତସ୍ମାତ୍ତ୍ୱାଂ ଧନ୍ୟଂ ୱଦାମି| ");
INSERT INTO sanori_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","ସପ୍ତସୁ ଦିନେଷୁ ଦିନଦ୍ୱଯମୁପୱସାମି ସର୍ୱ୍ୱସମ୍ପତ୍ତେ ର୍ଦଶମାଂଶଂ ଦଦାମି ଚ, ଏତତ୍କଥାଂ କଥଯନ୍ ପ୍ରାର୍ଥଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","କିନ୍ତୁ ସ କରସଞ୍ଚାଯି ଦୂରେ ତିଷ୍ଠନ୍ ସ୍ୱର୍ଗଂ ଦ୍ରଷ୍ଟୁଂ ନେଚ୍ଛନ୍ ୱକ୍ଷସି କରାଘାତଂ କୁର୍ୱ୍ୱନ୍ ହେ ଈଶ୍ୱର ପାପିଷ୍ଠଂ ମାଂ ଦଯସ୍ୱ, ଇତ୍ଥଂ ପ୍ରାର୍ଥଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","ଯୁଷ୍ମାନହଂ ୱଦାମି, ତଯୋର୍ଦ୍ୱଯୋ ର୍ମଧ୍ୟେ କେୱଲଃ କରସଞ୍ଚାଯୀ ପୁଣ୍ୟୱତ୍ତ୍ୱେନ ଗଣିତୋ ନିଜଗୃହଂ ଜଗାମ, ଯତୋ ଯଃ କଶ୍ଚିତ୍ ସ୍ୱମୁନ୍ନମଯତି ସ ନାମଯିଷ୍ୟତେ କିନ୍ତୁ ଯଃ କଶ୍ଚିତ୍ ସ୍ୱଂ ନମଯତି ସ ଉନ୍ନମଯିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","ଅଥ ଶିଶୂନାଂ ଗାତ୍ରସ୍ପର୍ଶାର୍ଥଂ ଲୋକାସ୍ତାନ୍ ତସ୍ୟ ସମୀପମାନିନ୍ୟୁଃ ଶିଷ୍ୟାସ୍ତଦ୍ ଦୃଷ୍ଟ୍ୱାନେତୃନ୍ ତର୍ଜଯାମାସୁଃ, ");
INSERT INTO sanori_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","କିନ୍ତୁ ଯୀଶୁସ୍ତାନାହୂଯ ଜଗାଦ, ମନ୍ନିକଟମ୍ ଆଗନ୍ତୁଂ ଶିଶୂନ୍ ଅନୁଜାନୀଧ୍ୱଂ ତାଂଶ୍ଚ ମା ୱାରଯତ; ଯତ ଈଶ୍ୱରରାଜ୍ୟାଧିକାରିଣ ଏଷାଂ ସଦୃଶାଃ| ");
INSERT INTO sanori_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ଅହଂ ଯୁଷ୍ମାନ୍ ଯଥାର୍ଥଂ ୱଦାମି, ଯୋ ଜନଃ ଶିଶୋଃ ସଦୃଶୋ ଭୂତ୍ୱା ଈଶ୍ୱରରାଜ୍ୟଂ ନ ଗୃହ୍ଲାତି ସ କେନାପି ପ୍ରକାରେଣ ତତ୍ ପ୍ରୱେଷ୍ଟୁଂ ନ ଶକ୍ନୋତି| ");
INSERT INTO sanori_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","ଅପରମ୍ ଏକୋଧିପତିସ୍ତଂ ପପ୍ରଚ୍ଛ, ହେ ପରମଗୁରୋ, ଅନନ୍ତାଯୁଷଃ ପ୍ରାପ୍ତଯେ ମଯା କିଂ କର୍ତ୍ତୱ୍ୟଂ? ");
INSERT INTO sanori_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ଯୀଶୁରୁୱାଚ, ମାଂ କୁତଃ ପରମଂ ୱଦସି? ଈଶ୍ୱରଂ ୱିନା କୋପି ପରମୋ ନ ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","ପରଦାରାନ୍ ମା ଗଚ୍ଛ, ନରଂ ମା ଜହି, ମା ଚୋରଯ, ମିଥ୍ୟାସାକ୍ଷ୍ୟଂ ମା ଦେହି, ମାତରଂ ପିତରଞ୍ଚ ସଂମନ୍ୟସ୍ୱ, ଏତା ଯା ଆଜ୍ଞାଃ ସନ୍ତି ତାସ୍ତ୍ୱଂ ଜାନାସି| ");
INSERT INTO sanori_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","ତଦା ସ ଉୱାଚ, ବାଲ୍ୟକାଲାତ୍ ସର୍ୱ୍ୱା ଏତା ଆଚରାମି| ");
INSERT INTO sanori_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ଇତି କଥାଂ ଶ୍ରୁତ୍ୱା ଯୀଶୁସ୍ତମୱଦତ୍, ତଥାପି ତୱୈକଂ କର୍ମ୍ମ ନ୍ୟୂନମାସ୍ତେ, ନିଜଂ ସର୍ୱ୍ୱସ୍ୱଂ ୱିକ୍ରୀଯ ଦରିଦ୍ରେଭ୍ୟୋ ୱିତର, ତସ୍ମାତ୍ ସ୍ୱର୍ଗେ ଧନଂ ପ୍ରାପ୍ସ୍ୟସି; ତତ ଆଗତ୍ୟ ମମାନୁଗାମୀ ଭୱ| ");
INSERT INTO sanori_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","କିନ୍ତ୍ୱେତାଂ କଥାଂ ଶ୍ରୁତ୍ୱା ସୋଧିପତିଃ ଶୁଶୋଚ, ଯତସ୍ତସ୍ୟ ବହୁଧନମାସୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ତଦା ଯୀଶୁସ୍ତମତିଶୋକାନ୍ୱିତଂ ଦୃଷ୍ଟ୍ୱା ଜଗାଦ, ଧନୱତାମ୍ ଈଶ୍ୱରରାଜ୍ୟପ୍ରୱେଶଃ କୀଦୃଗ୍ ଦୁଷ୍କରଃ| ");
INSERT INTO sanori_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ଈଶ୍ୱରରାଜ୍ୟେ ଧନିନଃ ପ୍ରୱେଶାତ୍ ସୂଚେଶ୍ଛିଦ୍ରେଣ ମହାଙ୍ଗସ୍ୟ ଗମନାଗମନେ ସୁକରେ| ");
INSERT INTO sanori_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ଶ୍ରୋତାରଃ ପପ୍ରଚ୍ଛୁସ୍ତର୍ହି କେନ ପରିତ୍ରାଣଂ ପ୍ରାପ୍ସ୍ୟତେ? ");
INSERT INTO sanori_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ସ ଉକ୍ତୱାନ୍, ଯନ୍ ମାନୁଷେଣାଶକ୍ୟଂ ତଦ୍ ଈଶ୍ୱରେଣ ଶକ୍ୟଂ| ");
INSERT INTO sanori_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ତଦା ପିତର ଉୱାଚ, ପଶ୍ୟ ୱଯଂ ସର୍ୱ୍ୱସ୍ୱଂ ପରିତ୍ୟଜ୍ୟ ତୱ ପଶ୍ଚାଦ୍ଗାମିନୋଽଭୱାମ| ");
INSERT INTO sanori_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ତତଃ ସ ଉୱାଚ, ଯୁଷ୍ମାନହଂ ଯଥାର୍ଥଂ ୱଦାମି, ଈଶ୍ୱରରାଜ୍ୟାର୍ଥଂ ଗୃହଂ ପିତରୌ ଭ୍ରାତୃଗଣଂ ଜାଯାଂ ସନ୍ତାନାଂଶ୍ଚ ତ୍ୟକ୍ତୱା ");
INSERT INTO sanori_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ଇହ କାଲେ ତତୋଽଧିକଂ ପରକାଲେ ଽନନ୍ତାଯୁଶ୍ଚ ନ ପ୍ରାପ୍ସ୍ୟତି ଲୋକ ଈଦୃଶଃ କୋପି ନାସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","ଅନନ୍ତରଂ ସ ଦ୍ୱାଦଶଶିଷ୍ୟାନାହୂଯ ବଭାଷେ, ପଶ୍ୟତ ୱଯଂ ଯିରୂଶାଲମ୍ନଗରଂ ଯାମଃ, ତସ୍ମାତ୍ ମନୁଷ୍ୟପୁତ୍ରେ ଭୱିଷ୍ୟଦ୍ୱାଦିଭିରୁକ୍ତଂ ଯଦସ୍ତି ତଦନୁରୂପଂ ତଂ ପ୍ରତି ଘଟିଷ୍ୟତେ; ");
INSERT INTO sanori_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","ୱସ୍ତୁତସ୍ତୁ ସୋଽନ୍ୟଦେଶୀଯାନାଂ ହସ୍ତେଷୁ ସମର୍ପଯିଷ୍ୟତେ, ତେ ତମୁପହସିଷ୍ୟନ୍ତି, ଅନ୍ୟାଯମାଚରିଷ୍ୟନ୍ତି ତଦ୍ୱପୁଷି ନିଷ୍ଠୀୱଂ ନିକ୍ଷେପ୍ସ୍ୟନ୍ତି, କଶାଭିଃ ପ୍ରହୃତ୍ୟ ତଂ ହନିଷ୍ୟନ୍ତି ଚ, ");
INSERT INTO sanori_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","କିନ୍ତୁ ତୃତୀଯଦିନେ ସ ଶ୍ମଶାନାଦ୍ ଉତ୍ଥାସ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ଏତସ୍ୟାଃ କଥାଯା ଅଭିପ୍ରାଯଂ କିଞ୍ଚିଦପି ତେ ବୋଦ୍ଧୁଂ ନ ଶେକୁଃ ତେଷାଂ ନିକଟେଽସ୍ପଷ୍ଟତୱାତ୍ ତସ୍ୟୈତାସାଂ କଥାନାମ୍ ଆଶଯଂ ତେ ଜ୍ଞାତୁଂ ନ ଶେକୁଶ୍ଚ| ");
INSERT INTO sanori_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","ଅଥ ତସ୍ମିନ୍ ଯିରୀହୋଃ ପୁରସ୍ୟାନ୍ତିକଂ ପ୍ରାପ୍ତେ କଶ୍ଚିଦନ୍ଧଃ ପଥଃ ପାର୍ଶ୍ୱ ଉପୱିଶ୍ୟ ଭିକ୍ଷାମ୍ ଅକରୋତ୍ ");
INSERT INTO sanori_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ସ ଲୋକସମୂହସ୍ୟ ଗମନଶବ୍ଦଂ ଶ୍ରୁତ୍ୱା ତତ୍କାରଣଂ ପୃଷ୍ଟୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","ନାସରତୀଯଯୀଶୁର୍ୟାତୀତି ଲୋକୈରୁକ୍ତେ ସ ଉଚ୍ଚୈର୍ୱକ୍ତୁମାରେଭେ, ");
INSERT INTO sanori_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ହେ ଦାଯୂଦଃ ସନ୍ତାନ ଯୀଶୋ ମାଂ ଦଯସ୍ୱ| ");
INSERT INTO sanori_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ତତୋଗ୍ରଗାମିନସ୍ତଂ ମୌନୀ ତିଷ୍ଠେତି ତର୍ଜଯାମାସୁଃ କିନ୍ତୁ ସ ପୁନାରୁୱନ୍ ଉୱାଚ, ହେ ଦାଯୂଦଃ ସନ୍ତାନ ମାଂ ଦଯସ୍ୱ| ");
INSERT INTO sanori_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","ତଦା ଯୀଶୁଃ ସ୍ଥଗିତୋ ଭୂତ୍ୱା ସ୍ୱାନ୍ତିକେ ତମାନେତୁମ୍ ଆଦିଦେଶ| ");
INSERT INTO sanori_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","ତତଃ ସ ତସ୍ୟାନ୍ତିକମ୍ ଆଗମତ୍, ତଦା ସ ତଂ ପପ୍ରଚ୍ଛ, ତ୍ୱଂ କିମିଚ୍ଛସି? ତ୍ୱଦର୍ଥମହଂ କିଂ କରିଷ୍ୟାମି? ସ ଉକ୍ତୱାନ୍, ହେ ପ୍ରଭୋଽହଂ ଦ୍ରଷ୍ଟୁଂ ଲଭୈ| ");
INSERT INTO sanori_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","ତଦା ଯୀଶୁରୁୱାଚ, ଦୃଷ୍ଟିଶକ୍ତିଂ ଗୃହାଣ ତୱ ପ୍ରତ୍ୟଯସ୍ତ୍ୱାଂ ସ୍ୱସ୍ଥଂ କୃତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ତତସ୍ତତ୍କ୍ଷଣାତ୍ ତସ୍ୟ ଚକ୍ଷୁଷୀ ପ୍ରସନ୍ନେ; ତସ୍ମାତ୍ ସ ଈଶ୍ୱରଂ ଧନ୍ୟଂ ୱଦନ୍ ତତ୍ପଶ୍ଚାଦ୍ ଯଯୌ, ତଦାଲୋକ୍ୟ ସର୍ୱ୍ୱେ ଲୋକା ଈଶ୍ୱରଂ ପ୍ରଶଂସିତୁମ୍ ଆରେଭିରେ| ");
INSERT INTO sanori_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","ଯଦା ଯୀଶୁ ର୍ୟିରୀହୋପୁରଂ ପ୍ରୱିଶ୍ୟ ତନ୍ମଧ୍ୟେନ ଗଚ୍ଛଂସ୍ତଦା ");
INSERT INTO sanori_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ସକ୍କେଯନାମା କରସଞ୍ଚାଯିନାଂ ପ୍ରଧାନୋ ଧନୱାନେକୋ ");
INSERT INTO sanori_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ଯୀଶୁଃ କୀଦୃଗିତି ଦ୍ରଷ୍ଟୁଂ ଚେଷ୍ଟିତୱାନ୍ କିନ୍ତୁ ଖର୍ୱ୍ୱତ୍ୱାଲ୍ଲୋକସଂଘମଧ୍ୟେ ତଦ୍ଦର୍ଶନମପ୍ରାପ୍ୟ ");
INSERT INTO sanori_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","ଯେନ ପଥା ସ ଯାସ୍ୟତି ତତ୍ପଥେଽଗ୍ରେ ଧାୱିତ୍ୱା ତଂ ଦ୍ରଷ୍ଟୁମ୍ ଉଡୁମ୍ବରତରୁମାରୁରୋହ| ");
INSERT INTO sanori_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","ପଶ୍ଚାଦ୍ ଯୀଶୁସ୍ତତ୍ସ୍ଥାନମ୍ ଇତ୍ୱା ଊର୍ଦ୍ଧ୍ୱଂ ୱିଲୋକ୍ୟ ତଂ ଦୃଷ୍ଟ୍ୱାୱାଦୀତ୍, ହେ ସକ୍କେଯ ତ୍ୱଂ ଶୀଘ୍ରମୱରୋହ ମଯାଦ୍ୟ ତ୍ୱଦ୍ଗେହେ ୱସ୍ତୱ୍ୟଂ| ");
INSERT INTO sanori_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ତତଃ ସ ଶୀଘ୍ରମୱରୁହ୍ୟ ସାହ୍ଲାଦଂ ତଂ ଜଗ୍ରାହ| ");
INSERT INTO sanori_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ତଦ୍ ଦୃଷ୍ଟ୍ୱା ସର୍ୱ୍ୱେ ୱିୱଦମାନା ୱକ୍ତୁମାରେଭିରେ, ସୋତିଥିତ୍ୱେନ ଦୁଷ୍ଟଲୋକଗୃହଂ ଗଚ୍ଛତି| ");
INSERT INTO sanori_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","କିନ୍ତୁ ସକ୍କେଯୋ ଦଣ୍ଡାଯମାନୋ ୱକ୍ତୁମାରେଭେ, ହେ ପ୍ରଭୋ ପଶ୍ୟ ମମ ଯା ସମ୍ପତ୍ତିରସ୍ତି ତଦର୍ଦ୍ଧଂ ଦରିଦ୍ରେଭ୍ୟୋ ଦଦେ, ଅପରମ୍ ଅନ୍ୟାଯଂ କୃତ୍ୱା କସ୍ମାଦପି ଯଦି କଦାପି କିଞ୍ଚିତ୍ ମଯା ଗୃହୀତଂ ତର୍ହି ତଚ୍ଚତୁର୍ଗୁଣଂ ଦଦାମି| ");
INSERT INTO sanori_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ତଦା ଯୀଶୁସ୍ତମୁକ୍ତୱାନ୍ ଅଯମପି ଇବ୍ରାହୀମଃ ସନ୍ତାନୋଽତଃ କାରଣାଦ୍ ଅଦ୍ୟାସ୍ୟ ଗୃହେ ତ୍ରାଣମୁପସ୍ଥିତଂ| ");
INSERT INTO sanori_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","ଯଦ୍ ହାରିତଂ ତତ୍ ମୃଗଯିତୁଂ ରକ୍ଷିତୁଞ୍ଚ ମନୁଷ୍ୟପୁତ୍ର ଆଗତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","ଅଥ ସ ଯିରୂଶାଲମଃ ସମୀପ ଉପାତିଷ୍ଠଦ୍ ଈଶ୍ୱରରାଜତ୍ୱସ୍ୟାନୁଷ୍ଠାନଂ ତଦୈୱ ଭୱିଷ୍ୟତୀତି ଲୋକୈରନ୍ୱଭୂଯତ, ତସ୍ମାତ୍ ସ ଶ୍ରୋତୃଭ୍ୟଃ ପୁନର୍ଦୃଷ୍ଟାନ୍ତକଥାମ୍ ଉତ୍ଥାପ୍ୟ କଥଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","କୋପି ମହାଲ୍ଲୋକୋ ନିଜାର୍ଥଂ ରାଜତ୍ୱପଦଂ ଗୃହୀତ୍ୱା ପୁନରାଗନ୍ତୁଂ ଦୂରଦେଶଂ ଜଗାମ| ");
INSERT INTO sanori_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ଯାତ୍ରାକାଲେ ନିଜାନ୍ ଦଶଦାସାନ୍ ଆହୂଯ ଦଶସ୍ୱର୍ଣମୁଦ୍ରା ଦତ୍ତ୍ୱା ମମାଗମନପର୍ୟ୍ୟନ୍ତଂ ୱାଣିଜ୍ୟଂ କୁରୁତେତ୍ୟାଦିଦେଶ| ");
INSERT INTO sanori_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","କିନ୍ତୁ ତସ୍ୟ ପ୍ରଜାସ୍ତମୱଜ୍ଞାଯ ମନୁଷ୍ୟମେନମ୍ ଅସ୍ମାକମୁପରି ରାଜତ୍ୱଂ ନ କାରଯିୱ୍ୟାମ ଇମାଂ ୱାର୍ତ୍ତାଂ ତନ୍ନିକଟେ ପ୍ରେରଯାମାସୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","ଅଥ ସ ରାଜତ୍ୱପଦଂ ପ୍ରାପ୍ୟାଗତୱାନ୍ ଏକୈକୋ ଜନୋ ବାଣିଜ୍ୟେନ କିଂ ଲବ୍ଧୱାନ୍ ଇତି ଜ୍ଞାତୁଂ ଯେଷୁ ଦାସେଷୁ ମୁଦ୍ରା ଅର୍ପଯତ୍ ତାନ୍ ଆହୂଯାନେତୁମ୍ ଆଦିଦେଶ| ");
INSERT INTO sanori_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","ତଦା ପ୍ରଥମ ଆଗତ୍ୟ କଥିତୱାନ୍, ହେ ପ୍ରଭୋ ତୱ ତଯୈକଯା ମୁଦ୍ରଯା ଦଶମୁଦ୍ରା ଲବ୍ଧାଃ| ");
INSERT INTO sanori_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","ତତଃ ସ ଉୱାଚ ତ୍ୱମୁତ୍ତମୋ ଦାସଃ ସ୍ୱଲ୍ପେନ ୱିଶ୍ୱାସ୍ୟୋ ଜାତ ଇତଃ କାରଣାତ୍ ତ୍ୱଂ ଦଶନଗରାଣାମ୍ ଅଧିପୋ ଭୱ| ");
INSERT INTO sanori_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","ଦ୍ୱିତୀଯ ଆଗତ୍ୟ କଥିତୱାନ୍, ହେ ପ୍ରଭୋ ତୱୈକଯା ମୁଦ୍ରଯା ପଞ୍ଚମୁଦ୍ରା ଲବ୍ଧାଃ| ");
INSERT INTO sanori_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ତତଃ ସ ଉୱାଚ, ତ୍ୱଂ ପଞ୍ଚାନାଂ ନଗରାଣାମଧିପତି ର୍ଭୱ| ");
INSERT INTO sanori_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","ତତୋନ୍ୟ ଆଗତ୍ୟ କଥଯାମାସ, ହେ ପ୍ରଭୋ ପଶ୍ୟ ତୱ ଯା ମୁଦ୍ରା ଅହଂ ୱସ୍ତ୍ରେ ବଦ୍ଧ୍ୱାସ୍ଥାପଯଂ ସେଯଂ| ");
INSERT INTO sanori_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ତ୍ୱଂ କୃପଣୋ ଯନ୍ନାସ୍ଥାପଯସ୍ତଦପି ଗୃହ୍ଲାସି, ଯନ୍ନାୱପସ୍ତଦେୱ ଚ ଛିନତ୍ସି ତତୋହଂ ତ୍ୱତ୍ତୋ ଭୀତଃ| ");
INSERT INTO sanori_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","ତଦା ସ ଜଗାଦ, ରେ ଦୁଷ୍ଟଦାସ ତୱ ୱାକ୍ୟେନ ତ୍ୱାଂ ଦୋଷିଣଂ କରିଷ୍ୟାମି, ଯଦହଂ ନାସ୍ଥାପଯଂ ତଦେୱ ଗୃହ୍ଲାମି, ଯଦହଂ ନାୱପଞ୍ଚ ତଦେୱ ଛିନଦ୍ମି, ଏତାଦୃଶଃ କୃପଣୋହମିତି ଯଦି ତ୍ୱଂ ଜାନାସି, ");
INSERT INTO sanori_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ତର୍ହି ମମ ମୁଦ୍ରା ବଣିଜାଂ ନିକଟେ କୁତୋ ନାସ୍ଥାପଯଃ? ତଯା କୃତେଽହମ୍ ଆଗତ୍ୟ କୁସୀଦେନ ସାର୍ଦ୍ଧଂ ନିଜମୁଦ୍ରା ଅପ୍ରାପ୍ସ୍ୟମ୍| ");
INSERT INTO sanori_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","ପଶ୍ଚାତ୍ ସ ସମୀପସ୍ଥାନ୍ ଜନାନ୍ ଆଜ୍ଞାପଯତ୍ ଅସ୍ମାତ୍ ମୁଦ୍ରା ଆନୀଯ ଯସ୍ୟ ଦଶମୁଦ୍ରାଃ ସନ୍ତି ତସ୍ମୈ ଦତ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","ତେ ପ୍ରୋଚୁଃ ପ୍ରଭୋଽସ୍ୟ ଦଶମୁଦ୍ରାଃ ସନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","ଯୁଷ୍ମାନହଂ ୱଦାମି ଯସ୍ୟାଶ୍ରଯେ ୱଦ୍ଧତେ ଽଧିକଂ ତସ୍ମୈ ଦାଯିଷ୍ୟତେ, କିନ୍ତୁ ଯସ୍ୟାଶ୍ରଯେ ନ ୱର୍ଦ୍ଧତେ ତସ୍ୟ ଯଦ୍ୟଦସ୍ତି ତଦପି ତସ୍ମାନ୍ ନାଯିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","କିନ୍ତୁ ମମାଧିପତିତ୍ୱସ୍ୟ ୱଶତ୍ୱେ ସ୍ଥାତୁମ୍ ଅସମ୍ମନ୍ୟମାନା ଯେ ମମ ରିପୱସ୍ତାନାନୀଯ ମମ ସମକ୍ଷଂ ସଂହରତ| ");
INSERT INTO sanori_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ଇତ୍ୟୁପଦେଶକଥାଂ କଥଯିତ୍ୱା ସୋଗ୍ରଗଃ ସନ୍ ଯିରୂଶାଲମପୁରଂ ଯଯୌ| ");
INSERT INTO sanori_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ତତୋ ବୈତ୍ଫଗୀବୈଥନୀଯାଗ୍ରାମଯୋଃ ସମୀପେ ଜୈତୁନାଦ୍ରେରନ୍ତିକମ୍ ଇତ୍ୱା ଶିଷ୍ୟଦ୍ୱଯମ୍ ଇତ୍ୟୁକ୍ତ୍ୱା ପ୍ରେଷଯାମାସ, ");
INSERT INTO sanori_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ଯୁୱାମମୁଂ ସମ୍ମୁଖସ୍ଥଗ୍ରାମଂ ପ୍ରୱିଶ୍ୟୈୱ ଯଂ କୋପି ମାନୁଷଃ କଦାପି ନାରୋହତ୍ ତଂ ଗର୍ଦ୍ଦଭଶାୱକଂ ବଦ୍ଧଂ ଦ୍ରକ୍ଷ୍ୟଥସ୍ତଂ ମୋଚଯିତ୍ୱାନଯତଂ| ");
INSERT INTO sanori_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","ତତ୍ର କୁତୋ ମୋଚଯଥଃ? ଇତି ଚେତ୍ କୋପି ୱକ୍ଷ୍ୟତି ତର୍ହି ୱକ୍ଷ୍ୟଥଃ ପ୍ରଭେाରତ୍ର ପ୍ରଯୋଜନମ୍ ଆସ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ତଦା ତୌ ପ୍ରରିତୌ ଗତ୍ୱା ତତ୍କଥାाନୁସାରେଣ ସର୍ୱ୍ୱଂ ପ୍ରାପ୍ତୌ| ");
INSERT INTO sanori_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ଗର୍ଦଭଶାୱକମୋଚନକାଲେ ତତ୍ୱାମିନ ଊଚୁଃ, ଗର୍ଦଭଶାୱକଂ କୁତୋ ମୋଚଯଥଃ? ");
INSERT INTO sanori_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","ତାୱୂଚତୁଃ ପ୍ରଭୋରତ୍ର ପ୍ରଯୋଜନମ୍ ଆସ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ପଶ୍ଚାତ୍ ତୌ ତଂ ଗର୍ଦଭଶାୱକଂ ଯୀଶୋରନ୍ତିକମାନୀଯ ତତ୍ପୃଷ୍ଠେ ନିଜୱସନାନି ପାତଯିତ୍ୱା ତଦୁପରି ଯୀଶୁମାରୋହଯାମାସତୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ଅଥ ଯାତ୍ରାକାଲେ ଲୋକାଃ ପଥି ସ୍ୱୱସ୍ତ୍ରାଣି ପାତଯିତୁମ୍ ଆରେଭିରେ| ");
INSERT INTO sanori_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ଅପରଂ ଜୈତୁନାଦ୍ରେରୁପତ୍ୟକାମ୍ ଇତ୍ୱା ଶିଷ୍ୟସଂଘଃ ପୂର୍ୱ୍ୱଦୃଷ୍ଟାନି ମହାକର୍ମ୍ମାଣି ସ୍ମୃତ୍ୱା, ");
INSERT INTO sanori_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ଯୋ ରାଜା ପ୍ରଭୋ ର୍ନାମ୍ନାଯାତି ସ ଧନ୍ୟଃ ସ୍ୱର୍ଗେ କୁଶଲଂ ସର୍ୱ୍ୱୋଚ୍ଚେ ଜଯଧ୍ୱନି ର୍ଭୱତୁ, କଥାମେତାଂ କଥଯିତ୍ୱା ସାନନ୍ଦମ୍ ଉଚୈରୀଶ୍ୱରଂ ଧନ୍ୟଂ ୱକ୍ତୁମାରେଭେ| ");
INSERT INTO sanori_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","ତଦା ଲୋକାରଣ୍ୟମଧ୍ୟସ୍ଥାଃ କିଯନ୍ତଃ ଫିରୂଶିନସ୍ତତ୍ ଶ୍ରୁତ୍ୱା ଯୀଶୁଂ ପ୍ରୋଚୁଃ, ହେ ଉପଦେଶକ ସ୍ୱଶିଷ୍ୟାନ୍ ତର୍ଜଯ| ");
INSERT INTO sanori_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ସ ଉୱାଚ, ଯୁଷ୍ମାନହଂ ୱଦାମି ଯଦ୍ୟମୀ ନୀରୱାସ୍ତିଷ୍ଠନ୍ତି ତର୍ହି ପାଷାଣା ଉଚୈଃ କଥାଃ କଥଯିଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","ପଶ୍ଚାତ୍ ତତ୍ପୁରାନ୍ତିକମେତ୍ୟ ତଦୱଲୋକ୍ୟ ସାଶ୍ରୁପାତଂ ଜଗାଦ, ");
INSERT INTO sanori_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ହା ହା ଚେତ୍ ତ୍ୱମଗ୍ରେଽଜ୍ଞାସ୍ୟଥାଃ, ତୱାସ୍ମିନ୍ନେୱ ଦିନେ ୱା ଯଦି ସ୍ୱମଙ୍ଗଲମ୍ ଉପାଲପ୍ସ୍ୟଥାଃ, ତର୍ହ୍ୟୁତ୍ତମମ୍ ଅଭୱିଷ୍ୟତ୍, କିନ୍ତୁ କ୍ଷଣେସ୍ମିନ୍ ତତ୍ତୱ ଦୃଷ୍ଟେରଗୋଚରମ୍ ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ତ୍ୱଂ ସ୍ୱତ୍ରାଣକାଲେ ନ ମନୋ ନ୍ୟଧତ୍ଥା ଇତି ହେତୋ ର୍ୟତ୍କାଲେ ତୱ ରିପୱସ୍ତ୍ୱାଂ ଚତୁର୍ଦିକ୍ଷୁ ପ୍ରାଚୀରେଣ ୱେଷ୍ଟଯିତ୍ୱା ରୋତ୍ସ୍ୟନ୍ତି ");
INSERT INTO sanori_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ବାଲକୈଃ ସାର୍ଦ୍ଧଂ ଭୂମିସାତ୍ କରିଷ୍ୟନ୍ତି ଚ ତ୍ୱନ୍ମଧ୍ୟେ ପାଷାଣୈକୋପି ପାଷାଣୋପରି ନ ସ୍ଥାସ୍ୟତି ଚ, କାଲ ଈଦୃଶ ଉପସ୍ଥାସ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","ଅଥ ମଧ୍ୟେମନ୍ଦିରଂ ପ୍ରୱିଶ୍ୟ ତତ୍ରତ୍ୟାନ୍ କ୍ରଯିୱିକ୍ରଯିଣୋ ବହିଷ୍କୁର୍ୱ୍ୱନ୍ ");
INSERT INTO sanori_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ଅୱଦତ୍ ମଦ୍ଗୃହଂ ପ୍ରାର୍ଥନାଗୃହମିତି ଲିପିରାସ୍ତେ କିନ୍ତୁ ଯୂଯଂ ତଦେୱ ଚୈରାଣାଂ ଗହ୍ୱରଂ କୁରୁଥ| ");
INSERT INTO sanori_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","ପଶ୍ଚାତ୍ ସ ପ୍ରତ୍ୟହଂ ମଧ୍ୟେମନ୍ଦିରମ୍ ଉପଦିଦେଶ; ତତଃ ପ୍ରଧାନଯାଜକା ଅଧ୍ୟାପକାଃ ପ୍ରାଚୀନାଶ୍ଚ ତଂ ନାଶଯିତୁଂ ଚିଚେଷ୍ଟିରେ; ");
INSERT INTO sanori_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","କିନ୍ତୁ ତଦୁପଦେଶେ ସର୍ୱ୍ୱେ ଲୋକା ନିୱିଷ୍ଟଚିତ୍ତାଃ ସ୍ଥିତାସ୍ତସ୍ମାତ୍ ତେ ତତ୍କର୍ତ୍ତୁଂ ନାୱକାଶଂ ପ୍ରାପୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","ଅଥୈକଦା ଯୀଶୁ ର୍ମନିଦରେ ସୁସଂୱାଦଂ ପ୍ରଚାରଯନ୍ ଲୋକାନୁପଦିଶତି, ଏତର୍ହି ପ୍ରଧାନଯାଜକା ଅଧ୍ୟାପକାଃ ପ୍ରାଞ୍ଚଶ୍ଚ ତନ୍ନିକଟମାଗତ୍ୟ ପପ୍ରଚ୍ଛୁଃ ");
INSERT INTO sanori_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","କଯାଜ୍ଞଯା ତ୍ୱଂ କର୍ମ୍ମାଣ୍ୟେତାନି କରୋଷି? କୋ ୱା ତ୍ୱାମାଜ୍ଞାପଯତ୍? ତଦସ୍ମାନ୍ ୱଦ| ");
INSERT INTO sanori_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ସ ପ୍ରତ୍ୟୁୱାଚ, ତର୍ହି ଯୁଷ୍ମାନପି କଥାମେକାଂ ପୃଚ୍ଛାମି ତସ୍ୟୋତ୍ତରଂ ୱଦତ| ");
INSERT INTO sanori_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ଯୋହନୋ ମଜ୍ଜନମ୍ ଈଶ୍ୱରସ୍ୟ ମାନୁଷାଣାଂ ୱାଜ୍ଞାତୋ ଜାତଂ? ");
INSERT INTO sanori_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ତତସ୍ତେ ମିଥୋ ୱିୱିଚ୍ୟ ଜଗଦୁଃ, ଯଦୀଶ୍ୱରସ୍ୟ ୱଦାମସ୍ତର୍ହି ତଂ କୁତୋ ନ ପ୍ରତ୍ୟୈତ ସ ଇତି ୱକ୍ଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","ଯଦି ମନୁଷ୍ୟସ୍ୟେତି ୱଦାମସ୍ତର୍ହି ସର୍ୱ୍ୱେ ଲୋକା ଅସ୍ମାନ୍ ପାଷାଣୈ ର୍ହନିଷ୍ୟନ୍ତି ଯତୋ ଯୋହନ୍ ଭୱିଷ୍ୟଦ୍ୱାଦୀତି ସର୍ୱ୍ୱେ ଦୃଢଂ ଜାନନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ଅତଏୱ ତେ ପ୍ରତ୍ୟୂଚୁଃ କସ୍ୟାଜ୍ଞଯା ଜାତମ୍ ଇତି ୱକ୍ତୁଂ ନ ଶକ୍ନୁମଃ| ");
INSERT INTO sanori_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","ତଦା ଯୀଶୁରୱଦତ୍ ତର୍ହି କଯାଜ୍ଞଯା କର୍ମ୍ମାଣ୍ୟେତାତି କରୋମୀତି ଚ ଯୁଷ୍ମାନ୍ ନ ୱକ୍ଷ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","ଅଥ ଲୋକାନାଂ ସାକ୍ଷାତ୍ ସ ଇମାଂ ଦୃଷ୍ଟାନ୍ତକଥାଂ ୱକ୍ତୁମାରେଭେ, କଶ୍ଚିଦ୍ ଦ୍ରାକ୍ଷାକ୍ଷେତ୍ରଂ କୃତ୍ୱା ତତ୍ କ୍ଷେତ୍ରଂ କୃଷୀୱଲାନାଂ ହସ୍ତେଷୁ ସମର୍ପ୍ୟ ବହୁକାଲାର୍ଥଂ ଦୂରଦେଶଂ ଜଗାମ| ");
INSERT INTO sanori_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","ଅଥ ଫଲକାଲେ ଫଲାନି ଗ୍ରହୀତୁ କୃଷୀୱଲାନାଂ ସମୀପେ ଦାସଂ ପ୍ରାହିଣୋତ୍ କିନ୍ତୁ କୃଷୀୱଲାସ୍ତଂ ପ୍ରହୃତ୍ୟ ରିକ୍ତହସ୍ତଂ ୱିସସର୍ଜୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ତତଃ ସୋଧିପତିଃ ପୁନରନ୍ୟଂ ଦାସଂ ପ୍ରେଷଯାମାସ, ତେ ତମପି ପ୍ରହୃତ୍ୟ କୁୱ୍ୟୱହୃତ୍ୟ ରିକ୍ତହସ୍ତଂ ୱିସସୃଜୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ତତଃ ସ ତୃତୀଯୱାରମ୍ ଅନ୍ୟଂ ପ୍ରାହିଣୋତ୍ ତେ ତମପି କ୍ଷତାଙ୍ଗଂ କୃତ୍ୱା ବହି ର୍ନିଚିକ୍ଷିପୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ତଦା କ୍ଷେତ୍ରପତି ର୍ୱିଚାରଯାମାସ, ମମେଦାନୀଂ କିଂ କର୍ତ୍ତୱ୍ୟଂ? ମମ ପ୍ରିଯେ ପୁତ୍ରେ ପ୍ରହିତେ ତେ ତମୱଶ୍ୟଂ ଦୃଷ୍ଟ୍ୱା ସମାଦରିଷ୍ୟନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","କିନ୍ତୁ କୃଷୀୱଲାସ୍ତଂ ନିରୀକ୍ଷ୍ୟ ପରସ୍ପରଂ ୱିୱିଚ୍ୟ ପ୍ରୋଚୁଃ, ଅଯମୁତ୍ତରାଧିକାରୀ ଆଗଚ୍ଛତୈନଂ ହନ୍ମସ୍ତତୋଧିକାରୋସ୍ମାକଂ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ତତସ୍ତେ ତଂ କ୍ଷେତ୍ରାଦ୍ ବହି ର୍ନିପାତ୍ୟ ଜଘ୍ନୁସ୍ତସ୍ମାତ୍ ସ କ୍ଷେତ୍ରପତିସ୍ତାନ୍ ପ୍ରତି କିଂ କରିଷ୍ୟତି? ");
INSERT INTO sanori_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ସ ଆଗତ୍ୟ ତାନ୍ କୃଷୀୱଲାନ୍ ହତ୍ୱା ପରେଷାଂ ହସ୍ତେଷୁ ତତ୍କ୍ଷେତ୍ରଂ ସମର୍ପଯିଷ୍ୟତି; ଇତି କଥାଂ ଶ୍ରୁତ୍ୱା ତେ ଽୱଦନ୍ ଏତାଦୃଶୀ ଘଟନା ନ ଭୱତୁ| ");
INSERT INTO sanori_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","କିନ୍ତୁ ଯୀଶୁସ୍ତାନୱଲୋକ୍ୟ ଜଗାଦ, ତର୍ହି, ସ୍ଥପତଯଃ କରିଷ୍ୟନ୍ତି ଗ୍ରାୱାଣଂ ଯନ୍ତୁ ତୁଚ୍ଛକଂ| ପ୍ରଧାନପ୍ରସ୍ତରଃ କୋଣେ ସ ଏୱ ହି ଭୱିଷ୍ୟତି| ଏତସ୍ୟ ଶାସ୍ତ୍ରୀଯୱଚନସ୍ୟ କିଂ ତାତ୍ପର୍ୟ୍ୟଂ? ");
INSERT INTO sanori_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","ଅପରଂ ତତ୍ପାଷାଣୋପରି ଯଃ ପତିଷ୍ୟତି ସ ଭଂକ୍ଷ୍ୟତେ କିନ୍ତୁ ଯସ୍ୟୋପରି ସ ପାଷାଣଃ ପତିଷ୍ୟତି ସ ତେନ ଧୂଲିୱଚ୍ ଚୂର୍ଣୀଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ସୋସ୍ମାକଂ ୱିରୁଦ୍ଧଂ ଦୃଷ୍ଟାନ୍ତମିମଂ କଥିତୱାନ୍ ଇତି ଜ୍ଞାତ୍ୱା ପ୍ରଧାନଯାଜକା ଅଧ୍ୟାପକାଶ୍ଚ ତଦୈୱ ତଂ ଧର୍ତୁଂ ୱୱାଞ୍ଛୁଃ କିନ୍ତୁ ଲୋକେଭ୍ୟୋ ବିଭ୍ୟୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ଅତଏୱ ତଂ ପ୍ରତି ସତର୍କାଃ ସନ୍ତଃ କଥଂ ତଦ୍ୱାକ୍ୟଦୋଷଂ ଧୃତ୍ୱା ତଂ ଦେଶାଧିପସ୍ୟ ସାଧୁୱେଶଧାରିଣଶ୍ଚରାନ୍ ତସ୍ୟ ସମୀପେ ପ୍ରେଷଯାମାସୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","ତଦା ତେ ତଂ ପପ୍ରଚ୍ଛୁଃ, ହେ ଉପଦେଶକ ଭୱାନ୍ ଯଥାର୍ଥଂ କଥଯନ୍ ଉପଦିଶତି, କମପ୍ୟନପେକ୍ଷ୍ୟ ସତ୍ୟତ୍ୱେନୈଶ୍ୱରଂ ମାର୍ଗମୁପଦିଶତି, ୱଯମେତଜ୍ଜାନୀମଃ| ");
INSERT INTO sanori_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","କୈସରରାଜାଯ କରୋସ୍ମାଭି ର୍ଦେଯୋ ନ ୱା? ");
INSERT INTO sanori_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ସ ତେଷାଂ ୱଞ୍ଚନଂ ଜ୍ଞାତ୍ୱାୱଦତ୍ କୁତୋ ମାଂ ପରୀକ୍ଷଧ୍ୱେ? ମାଂ ମୁଦ୍ରାମେକଂ ଦର୍ଶଯତ| ");
INSERT INTO sanori_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","ଇହ ଲିଖିତା ମୂର୍ତିରିଯଂ ନାମ ଚ କସ୍ୟ? ତେଽୱଦନ୍ କୈସରସ୍ୟ| ");
INSERT INTO sanori_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ତଦା ସ ଉୱାଚ, ତର୍ହି କୈସରସ୍ୟ ଦ୍ରୱ୍ୟଂ କୈସରାଯ ଦତ୍ତ; ଈଶ୍ୱରସ୍ୟ ତୁ ଦ୍ରୱ୍ୟମୀଶ୍ୱରାଯ ଦତ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ତସ୍ମାଲ୍ଲୋକାନାଂ ସାକ୍ଷାତ୍ ତତ୍କଥାଯାଃ କମପି ଦୋଷଂ ଧର୍ତୁମପ୍ରାପ୍ୟ ତେ ତସ୍ୟୋତ୍ତରାଦ୍ ଆଶ୍ଚର୍ୟ୍ୟଂ ମନ୍ୟମାନା ମୌନିନସ୍ତସ୍ଥୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","ଅପରଞ୍ଚ ଶ୍ମଶାନାଦୁତ୍ଥାନାନଙ୍ଗୀକାରିଣାଂ ସିଦୂକିନାଂ କିଯନ୍ତୋ ଜନା ଆଗତ୍ୟ ତଂ ପପ୍ରଚ୍ଛୁଃ, ");
INSERT INTO sanori_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","ହେ ଉପଦେଶକ ଶାସ୍ତ୍ରେ ମୂସା ଅସ୍ମାନ୍ ପ୍ରତୀତି ଲିଲେଖ ଯସ୍ୟ ଭ୍ରାତା ଭାର୍ୟ୍ୟାଯାଂ ସତ୍ୟାଂ ନିଃସନ୍ତାନୋ ମ୍ରିଯତେ ସ ତଜ୍ଜାଯାଂ ୱିୱହ୍ୟ ତଦ୍ୱଂଶମ୍ ଉତ୍ପାଦଯିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ତଥାଚ କେଚିତ୍ ସପ୍ତ ଭ୍ରାତର ଆସନ୍ ତେଷାଂ ଜ୍ୟେଷ୍ଠୋ ଭ୍ରାତା ୱିୱହ୍ୟ ନିରପତ୍ୟଃ ପ୍ରାଣାନ୍ ଜହୌ| ");
INSERT INTO sanori_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ଅଥ ଦ୍ୱିତୀଯସ୍ତସ୍ୟ ଜାଯାଂ ୱିୱହ୍ୟ ନିରପତ୍ୟଃ ସନ୍ ମମାର| ତୃତୀଯଶ୍ଚ ତାମେୱ ୱ୍ୟୁୱାହ; ");
INSERT INTO sanori_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ଇତ୍ଥଂ ସପ୍ତ ଭ୍ରାତରସ୍ତାମେୱ ୱିୱହ୍ୟ ନିରପତ୍ୟାଃ ସନ୍ତୋ ମମ୍ରୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ଶେଷେ ସା ସ୍ତ୍ରୀ ଚ ମମାର| ");
INSERT INTO sanori_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ଅତଏୱ ଶ୍ମଶାନାଦୁତ୍ଥାନକାଲେ ତେଷାଂ ସପ୍ତଜନାନାଂ କସ୍ୟ ସା ଭାର୍ୟ୍ୟା ଭୱିଷ୍ୟତି? ଯତଃ ସା ତେଷାଂ ସପ୍ତାନାମେୱ ଭାର୍ୟ୍ୟାସୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","ତଦା ଯୀଶୁଃ ପ୍ରତ୍ୟୁୱାଚ, ଏତସ୍ୟ ଜଗତୋ ଲୋକା ୱିୱହନ୍ତି ୱାଗ୍ଦତ୍ତାଶ୍ଚ ଭୱନ୍ତି ");
INSERT INTO sanori_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","କିନ୍ତୁ ଯେ ତଜ୍ଜଗତ୍ପ୍ରାପ୍ତିଯୋଗ୍ୟତ୍ୱେନ ଗଣିତାଂ ଭୱିଷ୍ୟନ୍ତି ଶ୍ମଶାନାଚ୍ଚୋତ୍ଥାସ୍ୟନ୍ତି ତେ ନ ୱିୱହନ୍ତି ୱାଗ୍ଦତ୍ତାଶ୍ଚ ନ ଭୱନ୍ତି, ");
INSERT INTO sanori_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ତେ ପୁନ ର୍ନ ମ୍ରିଯନ୍ତେ କିନ୍ତୁ ଶ୍ମଶାନାଦୁତ୍ଥାପିତାଃ ସନ୍ତ ଈଶ୍ୱରସ୍ୟ ସନ୍ତାନାଃ ସ୍ୱର୍ଗୀଯଦୂତାନାଂ ସଦୃଶାଶ୍ଚ ଭୱନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","ଅଧିକନ୍ତୁ ମୂସାଃ ସ୍ତମ୍ବୋପାଖ୍ୟାନେ ପରମେଶ୍ୱର ଈବ୍ରାହୀମ ଈଶ୍ୱର ଇସ୍ହାକ ଈଶ୍ୱରୋ ଯାକୂବଶ୍ଚେଶ୍ୱର ଇତ୍ୟୁକ୍ତ୍ୱା ମୃତାନାଂ ଶ୍ମଶାନାଦ୍ ଉତ୍ଥାନସ୍ୟ ପ୍ରମାଣଂ ଲିଲେଖ| ");
INSERT INTO sanori_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ଅତଏୱ ଯ ଈଶ୍ୱରଃ ସ ମୃତାନାଂ ପ୍ରଭୁ ର୍ନ କିନ୍ତୁ ଜୀୱତାମେୱ ପ୍ରଭୁଃ, ତନ୍ନିକଟେ ସର୍ୱ୍ୱେ ଜୀୱନ୍ତଃ ସନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ଇତି ଶ୍ରୁତ୍ୱା କିଯନ୍ତୋଧ୍ୟାପକା ଊଚୁଃ, ହେ ଉପଦେଶକ ଭୱାନ୍ ଭଦ୍ରଂ ପ୍ରତ୍ୟୁକ୍ତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ଇତଃ ପରଂ ତଂ କିମପି ପ୍ରଷ୍ଟଂ ତେଷାଂ ପ୍ରଗଲ୍ଭତା ନାଭୂତ୍| ");
INSERT INTO sanori_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ପଶ୍ଚାତ୍ ସ ତାନ୍ ଉୱାଚ, ଯଃ ଖ୍ରୀଷ୍ଟଃ ସ ଦାଯୂଦଃ ସନ୍ତାନ ଏତାଂ କଥାଂ ଲୋକାଃ କଥଂ କଥଯନ୍ତି? ");
INSERT INTO sanori_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","ଯତଃ ମମ ପ୍ରଭୁମିଦଂ ୱାକ୍ୟମୱଦତ୍ ପରମେଶ୍ୱରଃ| ତୱ ଶତ୍ରୂନହଂ ଯାୱତ୍ ପାଦପୀଠଂ କରୋମି ନ| ତାୱତ୍ କାଲଂ ମଦୀଯେ ତ୍ୱଂ ଦକ୍ଷପାର୍ଶ୍ୱ ଉପାୱିଶ| ");
INSERT INTO sanori_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ଇତି କଥାଂ ଦାଯୂଦ୍ ସ୍ୱଯଂ ଗୀତଗ୍ରନ୍ଥେଽୱଦତ୍| ");
INSERT INTO sanori_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","ଅତଏୱ ଯଦି ଦାଯୂଦ୍ ତଂ ପ୍ରଭୁଂ ୱଦତି, ତର୍ହି ସ କଥଂ ତସ୍ୟ ସନ୍ତାନୋ ଭୱତି? ");
INSERT INTO sanori_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","ପଶ୍ଚାଦ୍ ଯୀଶୁଃ ସର୍ୱ୍ୱଜନାନାଂ କର୍ଣଗୋଚରେ ଶିଷ୍ୟାନୁୱାଚ, ");
INSERT INTO sanori_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","ଯେଽଧ୍ୟାପକା ଦୀର୍ଘପରିଚ୍ଛଦଂ ପରିଧାଯ ଭ୍ରମନ୍ତି, ହଟ୍ଟାପଣଯୋ ର୍ନମସ୍କାରେ ଭଜନଗେହସ୍ୟ ପ୍ରୋଚ୍ଚାସନେ ଭୋଜନଗୃହସ୍ୟ ପ୍ରଧାନସ୍ଥାନେ ଚ ପ୍ରୀଯନ୍ତେ ");
INSERT INTO sanori_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ୱିଧୱାନାଂ ସର୍ୱ୍ୱସ୍ୱଂ ଗ୍ରସିତ୍ୱା ଛଲେନ ଦୀର୍ଘକାଲଂ ପ୍ରାର୍ଥଯନ୍ତେ ଚ ତେଷୁ ସାୱଧାନା ଭୱତ, ତେଷାମୁଗ୍ରଦଣ୍ଡୋ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","ଅଥ ଧନିଲୋକା ଭାଣ୍ଡାଗାରେ ଧନଂ ନିକ୍ଷିପନ୍ତି ସ ତଦେୱ ପଶ୍ୟତି, ");
INSERT INTO sanori_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ଏତର୍ହି କାଚିଦ୍ଦୀନା ୱିଧୱା ପଣଦ୍ୱଯଂ ନିକ୍ଷିପତି ତଦ୍ ଦଦର୍ଶ| ");
INSERT INTO sanori_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ତତୋ ଯୀଶୁରୁୱାଚ ଯୁଷ୍ମାନହଂ ଯଥାର୍ଥଂ ୱଦାମି, ଦରିଦ୍ରେଯଂ ୱିଧୱା ସର୍ୱ୍ୱେଭ୍ୟୋଧିକଂ ନ୍ୟକ୍ଷେପ୍ସୀତ୍, ");
INSERT INTO sanori_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ଯତୋନ୍ୟେ ସ୍ୱପ୍ରାଜ୍ୟଧନେଭ୍ୟ ଈଶ୍ୱରାଯ କିଞ୍ଚିତ୍ ନ୍ୟକ୍ଷେପ୍ସୁଃ, କିନ୍ତୁ ଦରିଦ୍ରେଯଂ ୱିଧୱା ଦିନଯାପନାର୍ଥଂ ସ୍ୱସ୍ୟ ଯତ୍ କିଞ୍ଚିତ୍ ସ୍ଥିତଂ ତତ୍ ସର୍ୱ୍ୱଂ ନ୍ୟକ୍ଷେପ୍ସୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","ଅପରଞ୍ଚ ଉତ୍ତମପ୍ରସ୍ତରୈରୁତ୍ସୃଷ୍ଟୱ୍ୟୈଶ୍ଚ ମନ୍ଦିରଂ ସୁଶୋଭତେତରାଂ କୈଶ୍ଚିଦିତ୍ୟୁକ୍ତେ ସ ପ୍ରତ୍ୟୁୱାଚ ");
INSERT INTO sanori_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","ଯୂଯଂ ଯଦିଦଂ ନିଚଯନଂ ପଶ୍ୟଥ, ଅସ୍ୟ ପାଷାଣୈକୋପ୍ୟନ୍ୟପାଷାଣୋପରି ନ ସ୍ଥାସ୍ୟତି, ସର୍ୱ୍ୱେ ଭୂସାଦ୍ଭୱିଷ୍ୟନ୍ତି କାଲୋଯମାଯାତି| ");
INSERT INTO sanori_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ତଦା ତେ ପପ୍ରଚ୍ଛୁଃ, ହେ ଗୁରୋ ଘଟନେଦୃଶୀ କଦା ଭୱିଷ୍ୟତି? ଘଟନାଯା ଏତସ୍ୟସଶ୍ଚିହ୍ନଂ ୱା କିଂ ଭୱିଷ୍ୟତି? ");
INSERT INTO sanori_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ତଦା ସ ଜଗାଦ, ସାୱଧାନା ଭୱତ ଯଥା ଯୁଷ୍ମାକଂ ଭ୍ରମଂ କୋପି ନ ଜନଯତି, ଖୀଷ୍ଟୋହମିତ୍ୟୁକ୍ତ୍ୱା ମମ ନାମ୍ରା ବହୱ ଉପସ୍ଥାସ୍ୟନ୍ତି ସ କାଲଃ ପ୍ରାଯେଣୋପସ୍ଥିତଃ, ତେଷାଂ ପଶ୍ଚାନ୍ମା ଗଚ୍ଛତ| ");
INSERT INTO sanori_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","ଯୁଦ୍ଧସ୍ୟୋପପ୍ଲୱସ୍ୟ ଚ ୱାର୍ତ୍ତାଂ ଶ୍ରୁତ୍ୱା ମା ଶଙ୍କଧ୍ୱଂ, ଯତଃ ପ୍ରଥମମ୍ ଏତା ଘଟନା ଅୱଶ୍ୟଂ ଭୱିଷ୍ୟନ୍ତି କିନ୍ତୁ ନାପାତେ ଯୁଗାନ୍ତୋ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","ଅପରଞ୍ଚ କଥଯାମାସ, ତଦା ଦେଶସ୍ୟ ୱିପକ୍ଷତ୍ୱେନ ଦେଶୋ ରାଜ୍ୟସ୍ୟ ୱିପକ୍ଷତ୍ୱେନ ରାଜ୍ୟମ୍ ଉତ୍ଥାସ୍ୟତି, ");
INSERT INTO sanori_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ନାନାସ୍ଥାନେଷୁ ମହାଭୂକମ୍ପୋ ଦୁର୍ଭିକ୍ଷଂ ମାରୀ ଚ ଭୱିଷ୍ୟନ୍ତି, ତଥା ୱ୍ୟୋମମଣ୍ଡଲସ୍ୟ ଭଯଙ୍କରଦର୍ଶନାନ୍ୟଶ୍ଚର୍ୟ୍ୟଲକ୍ଷଣାନି ଚ ପ୍ରକାଶଯିଷ୍ୟନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","କିନ୍ତୁ ସର୍ୱ୍ୱାସାମେତାସାଂ ଘଟନାନାଂ ପୂର୍ୱ୍ୱଂ ଲୋକା ଯୁଷ୍ମାନ୍ ଧୃତ୍ୱା ତାଡଯିଷ୍ୟନ୍ତି, ଭଜନାଲଯେ କାରାଯାଞ୍ଚ ସମର୍ପଯିଷ୍ୟନ୍ତି ମମ ନାମକାରଣାଦ୍ ଯୁଷ୍ମାନ୍ ଭୂପାନାଂ ଶାସକାନାଞ୍ଚ ସମ୍ମୁଖଂ ନେଷ୍ୟନ୍ତି ଚ| ");
INSERT INTO sanori_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ସାକ୍ଷ୍ୟାର୍ଥମ୍ ଏତାନି ଯୁଷ୍ମାନ୍ ପ୍ରତି ଘଟିଷ୍ୟନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ତଦା କିମୁତ୍ତରଂ ୱକ୍ତୱ୍ୟମ୍ ଏତତ୍ ନ ଚିନ୍ତଯିଷ୍ୟାମ ଇତି ମନଃସୁ ନିଶ୍ଚିତନୁତ| ");
INSERT INTO sanori_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ୱିପକ୍ଷା ଯସ୍ମାତ୍ କିମପ୍ୟୁତ୍ତରମ୍ ଆପତ୍ତିଞ୍ଚ କର୍ତ୍ତୁଂ ନ ଶକ୍ଷ୍ୟନ୍ତି ତାଦୃଶଂ ୱାକ୍ପଟୁତ୍ୱଂ ଜ୍ଞାନଞ୍ଚ ଯୁଷ୍ମଭ୍ୟଂ ଦାସ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","କିଞ୍ଚ ଯୂଯଂ ପିତ୍ରା ମାତ୍ରା ଭ୍ରାତ୍ରା ବନ୍ଧୁନା ଜ୍ଞାତ୍ୟା କୁଟୁମ୍ବେନ ଚ ପରକରେଷୁ ସମର୍ପଯିଷ୍ୟଧ୍ୱେ; ତତସ୍ତେ ଯୁଷ୍ମାକଂ କଞ୍ଚନ କଞ୍ଚନ ଘାତଯିଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","ମମ ନାମ୍ନଃ କାରଣାତ୍ ସର୍ୱ୍ୱୈ ର୍ମନୁଷ୍ୟୈ ର୍ୟୂଯମ୍ ଋତୀଯିଷ୍ୟଧ୍ୱେ| ");
INSERT INTO sanori_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","କିନ୍ତୁ ଯୁଷ୍ମାକଂ ଶିରଃକେଶୈକୋପି ନ ୱିନଂକ୍ଷ୍ୟତି, ");
INSERT INTO sanori_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ତସ୍ମାଦେୱ ଧୈର୍ୟ୍ୟମୱଲମ୍ବ୍ୟ ସ୍ୱସ୍ୱପ୍ରାଣାନ୍ ରକ୍ଷତ| ");
INSERT INTO sanori_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","ଅପରଞ୍ଚ ଯିରୂଶାଲମ୍ପୁରଂ ସୈନ୍ୟୱେଷ୍ଟିତଂ ୱିଲୋକ୍ୟ ତସ୍ୟୋଚ୍ଛିନ୍ନତାଯାଃ ସମଯଃ ସମୀପ ଇତ୍ୟୱଗମିଷ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","ତଦା ଯିହୂଦାଦେଶସ୍ଥା ଲୋକାଃ ପର୍ୱ୍ୱତଂ ପଲାଯନ୍ତାଂ, ଯେ ଚ ନଗରେ ତିଷ୍ଠନ୍ତି ତେ ଦେଶାନ୍ତରଂ ପଲାଯନ୍ତା, ଯେ ଚ ଗ୍ରାମେ ତିଷ୍ଠନ୍ତି ତେ ନଗରଂ ନ ପ୍ରୱିଶନ୍ତୁ, ");
INSERT INTO sanori_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","ଯତସ୍ତଦା ସମୁଚିତଦଣ୍ଡନାଯ ଧର୍ମ୍ମପୁସ୍ତକେ ଯାନି ସର୍ୱ୍ୱାଣି ଲିଖିତାନି ତାନି ସଫଲାନି ଭୱିଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","କିନ୍ତୁ ଯା ଯାସ୍ତଦା ଗର୍ଭୱତ୍ୟଃ ସ୍ତନ୍ୟଦାୱ୍ୟଶ୍ଚ ତାମାଂ ଦୁର୍ଗତି ର୍ଭୱିଷ୍ୟତି, ଯତ ଏତାଲ୍ଲୋକାନ୍ ପ୍ରତି କୋପୋ ଦେଶେ ଚ ୱିଷମଦୁର୍ଗତି ର୍ଘଟିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","ୱସ୍ତୁତସ୍ତୁ ତେ ଖଙ୍ଗଧାରପରିୱ୍ୱଙ୍ଗଂ ଲପ୍ସ୍ୟନ୍ତେ ବଦ୍ଧାଃ ସନ୍ତଃ ସର୍ୱ୍ୱଦେଶେଷୁ ନାଯିଷ୍ୟନ୍ତେ ଚ କିଞ୍ଚାନ୍ୟଦେଶୀଯାନାଂ ସମଯୋପସ୍ଥିତିପର୍ୟ୍ୟନ୍ତଂ ଯିରୂଶାଲମ୍ପୁରଂ ତୈଃ ପଦତଲୈ ର୍ଦଲଯିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","ସୂର୍ୟ୍ୟଚନ୍ଦ୍ରନକ୍ଷତ୍ରେଷୁ ଲକ୍ଷଣାଦି ଭୱିଷ୍ୟନ୍ତି, ଭୁୱି ସର୍ୱ୍ୱଦେଶୀଯାନାଂ ଦୁଃଖଂ ଚିନ୍ତା ଚ ସିନ୍ଧୌ ୱୀଚୀନାଂ ତର୍ଜନଂ ଗର୍ଜନଞ୍ଚ ଭୱିଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ଭୂଭୌ ଭାୱିଘଟନାଂ ଚିନ୍ତଯିତ୍ୱା ମନୁଜା ଭିଯାମୃତକଲ୍ପା ଭୱିଷ୍ୟନ୍ତି, ଯତୋ ୱ୍ୟୋମମଣ୍ଡଲେ ତେଜସ୍ୱିନୋ ଦୋଲାଯମାନା ଭୱିଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ତଦା ପରାକ୍ରମେଣା ମହାତେଜସା ଚ ମେଘାରୂଢଂ ମନୁଷ୍ୟପୁତ୍ରମ୍ ଆଯାନ୍ତଂ ଦ୍ରକ୍ଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","କିନ୍ତ୍ୱେତାସାଂ ଘଟନାନାମାରମ୍ଭେ ସତି ଯୂଯଂ ମସ୍ତକାନ୍ୟୁତ୍ତୋଲ୍ୟ ଊର୍ଦଧ୍ୱଂ ଦ୍ରକ୍ଷ୍ୟଥ, ଯତୋ ଯୁଷ୍ମାକଂ ମୁକ୍ତେଃ କାଲଃ ସୱିଧୋ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ତତସ୍ତେନୈତଦୃଷ୍ଟାନ୍ତକଥା କଥିତା, ପଶ୍ୟତ ଉଡୁମ୍ବରାଦିୱୃକ୍ଷାଣାଂ ");
INSERT INTO sanori_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ନୱୀନପତ୍ରାଣି ଜାତାନୀତି ଦୃଷ୍ଟ୍ୱା ନିଦାୱକାଲ ଉପସ୍ଥିତ ଇତି ଯଥା ଯୂଯଂ ଜ୍ଞାତୁଂ ଶକ୍ନୁଥ, ");
INSERT INTO sanori_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ତଥା ସର୍ୱ୍ୱାସାମାସାଂ ଘଟନାନାମ୍ ଆରମ୍ଭେ ଦୃଷ୍ଟେ ସତୀଶ୍ୱରସ୍ୟ ରାଜତ୍ୱଂ ନିକଟମ୍ ଇତ୍ୟପି ଜ୍ଞାସ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","ଯୁଷ୍ମାନହଂ ଯଥାର୍ଥଂ ୱଦାମି, ୱିଦ୍ୟମାନଲୋକାନାମେଷାଂ ଗମନାତ୍ ପୂର୍ୱ୍ୱମ୍ ଏତାନି ଘଟିଷ୍ୟନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ନଭୋଭୁୱୋର୍ଲୋପୋ ଭୱିଷ୍ୟତି ମମ ୱାକ୍ ତୁ କଦାପି ଲୁପ୍ତା ନ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","ଅତଏୱ ୱିଷମାଶନେନ ପାନେନ ଚ ସାଂମାରିକଚିନ୍ତାଭିଶ୍ଚ ଯୁଷ୍ମାକଂ ଚିତ୍ତେଷୁ ମତ୍ତେଷୁ ତଦ୍ଦିନମ୍ ଅକସ୍ମାଦ୍ ଯୁଷ୍ମାନ୍ ପ୍ରତି ଯଥା ନୋପତିଷ୍ଠତି ତଦର୍ଥଂ ସ୍ୱେଷୁ ସାୱଧାନାସ୍ତିଷ୍ଠତ| ");
INSERT INTO sanori_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ପୃଥିୱୀସ୍ଥସର୍ୱ୍ୱଲୋକାନ୍ ପ୍ରତି ତଦ୍ଦିନମ୍ ଉନ୍ମାଥ ଇୱ ଉପସ୍ଥାସ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ଯଥା ଯୂଯମ୍ ଏତଦ୍ଭାୱିଘଟନା ଉତ୍ତର୍ତ୍ତୁଂ ମନୁଜସୁତସ୍ୟ ସମ୍ମୁଖେ ସଂସ୍ଥାତୁଞ୍ଚ ଯୋଗ୍ୟା ଭୱଥ କାରଣାଦସ୍ମାତ୍ ସାୱଧାନାଃ ସନ୍ତୋ ନିରନ୍ତରଂ ପ୍ରାର୍ଥଯଧ୍ୱଂ| ");
INSERT INTO sanori_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ଅପରଞ୍ଚ ସ ଦିୱା ମନ୍ଦିର ଉପଦିଶ୍ୟ ରାଚୈ ଜୈତୁନାଦ୍ରିଂ ଗତ୍ୱାତିଷ୍ଠତ୍| ");
INSERT INTO sanori_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ତତଃ ପ୍ରତ୍ୟୂଷେ ଲାକାସ୍ତତ୍କଥାଂ ଶ୍ରୋତୁଂ ମନ୍ଦିରେ ତଦନ୍ତିକମ୍ ଆଗଚ୍ଛନ୍| ");
INSERT INTO sanori_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","ଅପରଞ୍ଚ କିଣ୍ୱଶୂନ୍ୟପୂପୋତ୍ସୱସ୍ୟ କାଲ ଉପସ୍ଥିତେ ");
INSERT INTO sanori_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ପ୍ରଧାନଯାଜକା ଅଧ୍ୟାଯକାଶ୍ଚ ଯଥା ତଂ ହନ୍ତୁଂ ଶକ୍ନୁୱନ୍ତି ତଥୋପାଯାମ୍ ଅଚେଷ୍ଟନ୍ତ କିନ୍ତୁ ଲୋକେଭ୍ୟୋ ବିଭ୍ୟୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ଏତସ୍ତିନ୍ ସମଯେ ଦ୍ୱାଦଶଶିଷ୍ୟେଷୁ ଗଣିତ ଈଷ୍କରିଯୋତୀଯରୂଢିମାନ୍ ଯୋ ଯିହୂଦାସ୍ତସ୍ୟାନ୍ତଃକରଣଂ ଶୈତାନାଶ୍ରିତତ୍ୱାତ୍ ");
INSERT INTO sanori_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ସ ଗତ୍ୱା ଯଥା ଯୀଶୁଂ ତେଷାଂ କରେଷୁ ସମର୍ପଯିତୁଂ ଶକ୍ନୋତି ତଥା ମନ୍ତ୍ରଣାଂ ପ୍ରଧାନଯାଜକୈଃ ସେନାପତିଭିଶ୍ଚ ସହ ଚକାର| ");
INSERT INTO sanori_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","ତେନ ତେ ତୁଷ୍ଟାସ୍ତସ୍ମୈ ମୁଦ୍ରାଂ ଦାତୁଂ ପଣଂ ଚକ୍ରୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ତତଃ ସୋଙ୍ଗୀକୃତ୍ୟ ଯଥା ଲୋକାନାମଗୋଚରେ ତଂ ପରକରେଷୁ ସମର୍ପଯିତୁଂ ଶକ୍ନୋତି ତଥାୱକାଶଂ ଚେଷ୍ଟିତୁମାରେଭେ| ");
INSERT INTO sanori_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","ଅଥ କିଣ୍ୱଶୂନ୍ୟପୂପୋତ୍ମୱଦିନେ, ଅର୍ଥାତ୍ ଯସ୍ମିନ୍ ଦିନେ ନିସ୍ତାରୋତ୍ସୱସ୍ୟ ମେଷୋ ହନ୍ତୱ୍ୟସ୍ତସ୍ମିନ୍ ଦିନେ ");
INSERT INTO sanori_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ଯୀଶୁଃ ପିତରଂ ଯୋହନଞ୍ଚାହୂଯ ଜଗାଦ, ଯୁୱାଂ ଗତ୍ୱାସ୍ମାକଂ ଭୋଜନାର୍ଥଂ ନିସ୍ତାରୋତ୍ସୱସ୍ୟ ଦ୍ରୱ୍ୟାଣ୍ୟାସାଦଯତଂ| ");
INSERT INTO sanori_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ତଦା ତୌ ପପ୍ରଚ୍ଛତୁଃ କୁଚାସାଦଯାୱୋ ଭୱତଃ କେଚ୍ଛା? ");
INSERT INTO sanori_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ତଦା ସୋୱାଦୀତ୍, ନଗରେ ପ୍ରୱିଷ୍ଟେ କଶ୍ଚିଜ୍ଜଲକୁମ୍ଭମାଦାଯ ଯୁୱାଂ ସାକ୍ଷାତ୍ କରିଷ୍ୟତି ସ ଯନ୍ନିୱେଶନଂ ପ୍ରୱିଶତି ଯୁୱାମପି ତନ୍ନିୱେଶନଂ ତତ୍ପଶ୍ଚାଦିତ୍ୱା ନିୱେଶନପତିମ୍ ଇତି ୱାକ୍ୟଂ ୱଦତଂ, ");
INSERT INTO sanori_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ଯତ୍ରାହଂ ନିସ୍ତାରୋତ୍ସୱସ୍ୟ ଭୋଜ୍ୟଂ ଶିଷ୍ୟୈଃ ସାର୍ଦ୍ଧଂ ଭୋକ୍ତୁଂ ଶକ୍ନୋମି ସାତିଥିଶାଲାा କୁତ୍ର? କଥାମିମାଂ ପ୍ରଭୁସ୍ତ୍ୱାଂ ପୃଚ୍ଛତି| ");
INSERT INTO sanori_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ତତଃ ସ ଜନୋ ଦ୍ୱିତୀଯପ୍ରକୋଷ୍ଠୀଯମ୍ ଏକଂ ଶସ୍ତଂ କୋଷ୍ଠଂ ଦର୍ଶଯିଷ୍ୟତି ତତ୍ର ଭୋଜ୍ୟମାସାଦଯତଂ| ");
INSERT INTO sanori_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ତତସ୍ତୌ ଗତ୍ୱା ତଦ୍ୱାକ୍ୟାନୁସାରେଣ ସର୍ୱ୍ୱଂ ଦୃଷ୍ଦ୍ୱା ତତ୍ର ନିସ୍ତାରୋତ୍ସୱୀଯଂ ଭୋଜ୍ୟମାସାଦଯାମାସତୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","ଅଥ କାଲ ଉପସ୍ଥିତେ ଯୀଶୁ ର୍ଦ୍ୱାଦଶଭିଃ ପ୍ରେରିତୈଃ ସହ ଭୋକ୍ତୁମୁପୱିଶ୍ୟ କଥିତୱାନ୍ ");
INSERT INTO sanori_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ମମ ଦୁଃଖଭୋଗାତ୍ ପୂର୍ୱ୍ୱଂ ଯୁଭାଭିଃ ସହ ନିସ୍ତାରୋତ୍ସୱସ୍ୟୈତସ୍ୟ ଭୋଜ୍ୟଂ ଭୋକ୍ତୁଂ ମଯାତିୱାଞ୍ଛା କୃତା| ");
INSERT INTO sanori_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","ଯୁଷ୍ମାନ୍ ୱଦାମି, ଯାୱତ୍କାଲମ୍ ଈଶ୍ୱରରାଜ୍ୟେ ଭୋଜନଂ ନ କରିଷ୍ୟେ ତାୱତ୍କାଲମ୍ ଇଦଂ ନ ଭୋକ୍ଷ୍ୟେ| ");
INSERT INTO sanori_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ତଦା ସ ପାନପାତ୍ରମାଦାଯ ଈଶ୍ୱରସ୍ୟ ଗୁଣାନ୍ କୀର୍ତ୍ତଯିତ୍ୱା ତେଭ୍ୟୋ ଦତ୍ୱାୱଦତ୍, ଇଦଂ ଗୃହ୍ଲୀତ ଯୂଯଂ ୱିଭଜ୍ୟ ପିୱତ| ");
INSERT INTO sanori_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ଯୁଷ୍ମାନ୍ ୱଦାମି ଯାୱତ୍କାଲମ୍ ଈଶ୍ୱରରାଜତ୍ୱସ୍ୟ ସଂସ୍ଥାପନଂ ନ ଭୱତି ତାୱଦ୍ ଦ୍ରାକ୍ଷାଫଲରସଂ ନ ପାସ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ତତଃ ପୂପଂ ଗୃହୀତ୍ୱା ଈଶ୍ୱରଗୁଣାନ୍ କୀର୍ତ୍ତଯିତ୍ୱା ଭଙ୍କ୍ତା ତେଭ୍ୟୋ ଦତ୍ୱାୱଦତ୍, ଯୁଷ୍ମଦର୍ଥଂ ସମର୍ପିତଂ ଯନ୍ମମ ୱପୁସ୍ତଦିଦଂ, ଏତତ୍ କର୍ମ୍ମ ମମ ସ୍ମରଣାର୍ଥଂ କୁରୁଧ୍ୱଂ| ");
INSERT INTO sanori_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","ଅଥ ଭୋଜନାନ୍ତେ ତାଦୃଶଂ ପାତ୍ରଂ ଗୃହୀତ୍ୱାୱଦତ୍, ଯୁଷ୍ମତ୍କୃତେ ପାତିତଂ ଯନ୍ମମ ରକ୍ତଂ ତେନ ନିର୍ଣୀତନୱନିଯମରୂପଂ ପାନପାତ୍ରମିଦଂ| ");
INSERT INTO sanori_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","ପଶ୍ୟତ ଯୋ ମାଂ ପରକରେଷୁ ସମର୍ପଯିଷ୍ୟତି ସ ମଯା ସହ ଭୋଜନାସନ ଉପୱିଶତି| ");
INSERT INTO sanori_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","ଯଥା ନିରୂପିତମାସ୍ତେ ତଦନୁସାରେଣା ମନୁଷ୍ୟପୁुତ୍ରସ୍ୟ ଗତି ର୍ଭୱିଷ୍ୟତି କିନ୍ତୁ ଯସ୍ତଂ ପରକରେଷୁ ସମର୍ପଯିଷ୍ୟତି ତସ୍ୟ ସନ୍ତାପୋ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ତଦା ତେଷାଂ କୋ ଜନ ଏତତ୍ କର୍ମ୍ମ କରିଷ୍ୟତି ତତ୍ ତେ ପରସ୍ପରଂ ପ୍ରଷ୍ଟୁମାରେଭିରେ| ");
INSERT INTO sanori_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","ଅପରଂ ତେଷାଂ କୋ ଜନଃ ଶ୍ରେଷ୍ଠତ୍ୱେନ ଗଣଯିଷ୍ୟତେ, ଅତ୍ରାର୍ଥେ ତେଷାଂ ୱିୱାଦୋଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","ଅସ୍ମାତ୍ କାରଣାତ୍ ସୋୱଦତ୍, ଅନ୍ୟଦେଶୀଯାନାଂ ରାଜାନଃ ପ୍ରଜାନାମୁପରି ପ୍ରଭୁତ୍ୱଂ କୁର୍ୱ୍ୱନ୍ତି ଦାରୁଣଶାସନଂ କୃତ୍ୱାପି ତେ ଭୂପତିତ୍ୱେନ ୱିଖ୍ୟାତା ଭୱନ୍ତି ଚ| ");
INSERT INTO sanori_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","କିନ୍ତୁ ଯୁଷ୍ମାକଂ ତଥା ନ ଭୱିଷ୍ୟତି, ଯୋ ଯୁଷ୍ମାକଂ ଶ୍ରେଷ୍ଠୋ ଭୱିଷ୍ୟତି ସ କନିଷ୍ଠୱଦ୍ ଭୱତୁ, ଯଶ୍ଚ ମୁଖ୍ୟୋ ଭୱିଷ୍ୟତି ସ ସେୱକୱଦ୍ଭୱତୁ| ");
INSERT INTO sanori_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","ଭୋଜନୋପୱିଷ୍ଟପରିଚାରକଯୋଃ କଃ ଶ୍ରେଷ୍ଠଃ? ଯୋ ଭୋଜନାଯୋପୱିଶତି ସ କିଂ ଶ୍ରେଷ୍ଠୋ ନ ଭୱତି? କିନ୍ତୁ ଯୁଷ୍ମାକଂ ମଧ୍ୟେଽହଂ ପରିଚାରକଇୱାସ୍ମି| ");
INSERT INTO sanori_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","ଅପରଞ୍ଚ ଯୁଯଂ ମମ ପରୀକ୍ଷାକାଲେ ପ୍ରଥମମାରଭ୍ୟ ମଯା ସହ ସ୍ଥିତା ");
INSERT INTO sanori_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ଏତତ୍କାରଣାତ୍ ପିତ୍ରା ଯଥା ମଦର୍ଥଂ ରାଜ୍ୟମେକଂ ନିରୂପିତଂ ତଥାହମପି ଯୁଷ୍ମଦର୍ଥଂ ରାଜ୍ୟଂ ନିରୂପଯାମି| ");
INSERT INTO sanori_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ତସ୍ମାନ୍ ମମ ରାଜ୍ୟେ ଭୋଜନାସନେ ଚ ଭୋଜନପାନେ କରିଷ୍ୟଧ୍ୱେ ସିଂହାସନେଷୂପୱିଶ୍ୟ ଚେସ୍ରାଯେଲୀଯାନାଂ ଦ୍ୱାଦଶୱଂଶାନାଂ ୱିଚାରଂ କରିଷ୍ୟଧ୍ୱେ| ");
INSERT INTO sanori_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","ଅପରଂ ପ୍ରଭୁରୁୱାଚ, ହେ ଶିମୋନ୍ ପଶ୍ୟ ତିତଉନା ଧାନ୍ୟାନୀୱ ଯୁଷ୍ମାନ୍ ଶୈତାନ୍ ଚାଲଯିତୁମ୍ ଐଚ୍ଛତ୍, ");
INSERT INTO sanori_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","କିନ୍ତୁ ତୱ ୱିଶ୍ୱାସସ୍ୟ ଲୋପୋ ଯଥା ନ ଭୱତି ଏତତ୍ ତ୍ୱଦର୍ଥଂ ପ୍ରାର୍ଥିତଂ ମଯା, ତ୍ୱନ୍ମନସି ପରିୱର୍ତ୍ତିତେ ଚ ଭ୍ରାତୃଣାଂ ମନାଂସି ସ୍ଥିରୀକୁରୁ| ");
INSERT INTO sanori_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ତଦା ସୋୱଦତ୍, ହେ ପ୍ରଭୋହଂ ତ୍ୱଯା ସାର୍ଦ୍ଧଂ କାରାଂ ମୃତିଞ୍ଚ ଯାତୁଂ ମଜ୍ଜିତୋସ୍ମି| ");
INSERT INTO sanori_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ତତଃ ସ ଉୱାଚ, ହେ ପିତର ତ୍ୱାଂ ୱଦାମି, ଅଦ୍ୟ କୁକ୍କୁଟରୱାତ୍ ପୂର୍ୱ୍ୱଂ ତ୍ୱଂ ମତ୍ପରିଚଯଂ ୱାରତ୍ରଯମ୍ ଅପହ୍ୱୋଷ୍ୟସେ| ");
INSERT INTO sanori_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ଅପରଂ ସ ପପ୍ରଚ୍ଛ, ଯଦା ମୁଦ୍ରାସମ୍ପୁଟଂ ଖାଦ୍ୟପାତ୍ରଂ ପାଦୁକାଞ୍ଚ ୱିନା ଯୁଷ୍ମାନ୍ ପ୍ରାହିଣୱଂ ତଦା ଯୁଷ୍ମାକଂ କସ୍ୟାପି ନ୍ୟୂନତାସୀତ୍? ତେ ପ୍ରୋଚୁଃ କସ୍ୟାପି ନ| ");
INSERT INTO sanori_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ତଦା ସୋୱଦତ୍ କିନ୍ତ୍ୱିଦାନୀଂ ମୁଦ୍ରାସମ୍ପୁଟଂ ଖାଦ୍ୟପାତ୍ରଂ ୱା ଯସ୍ୟାସ୍ତି ତେନ ତଦ୍ଗ୍ରହୀତୱ୍ୟଂ, ଯସ୍ୟ ଚ କୃପାଣୋे ନାସ୍ତି ତେନ ସ୍ୱୱସ୍ତ୍ରଂ ୱିକ୍ରୀଯ ସ କ୍ରେତୱ୍ୟଃ| ");
INSERT INTO sanori_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","ଯତୋ ଯୁଷ୍ମାନହଂ ୱଦାମି, ଅପରାଧିଜନୈଃ ସାର୍ଦ୍ଧଂ ଗଣିତଃ ସ ଭୱିଷ୍ୟତି| ଇଦଂ ଯଚ୍ଛାସ୍ତ୍ରୀଯଂ ୱଚନଂ ଲିଖିତମସ୍ତି ତନ୍ମଯି ଫଲିଷ୍ୟତି ଯତୋ ମମ ସମ୍ବନ୍ଧୀଯଂ ସର୍ୱ୍ୱଂ ସେତ୍ସ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","ତଦା ତେ ପ୍ରୋଚୁଃ ପ୍ରଭୋ ପଶ୍ୟ ଇମୌ କୃପାଣୌ| ତତଃ ସୋୱଦଦ୍ ଏତୌ ଯଥେଷ୍ଟୌ| ");
INSERT INTO sanori_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","ଅଥ ସ ତସ୍ମାଦ୍ୱହି ର୍ଗତ୍ୱା ସ୍ୱାଚାରାନୁସାରେଣ ଜୈତୁନନାମାଦ୍ରିଂ ଜଗାମ ଶିଷ୍ୟାଶ୍ଚ ତତ୍ପଶ୍ଚାଦ୍ ଯଯୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ତତ୍ରୋପସ୍ଥାଯ ସ ତାନୁୱାଚ, ଯଥା ପରୀକ୍ଷାଯାଂ ନ ପତଥ ତଦର୍ଥଂ ପ୍ରାର୍ଥଯଧ୍ୱଂ| ");
INSERT INTO sanori_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ପଶ୍ଚାତ୍ ସ ତସ୍ମାଦ୍ ଏକଶରକ୍ଷେପାଦ୍ ବହି ର୍ଗତ୍ୱା ଜାନୁନୀ ପାତଯିତ୍ୱା ଏତତ୍ ପ୍ରାର୍ଥଯାଞ୍ଚକ୍ରେ, ");
INSERT INTO sanori_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ହେ ପିତ ର୍ୟଦି ଭୱାନ୍ ସମ୍ମନ୍ୟତେ ତର୍ହି କଂସମେନଂ ମମାନ୍ତିକାଦ୍ ଦୂରଯ କିନ୍ତୁ ମଦିଚ୍ଛାନୁରୂପଂ ନ ତ୍ୱଦିଚ୍ଛାନୁରୂପଂ ଭୱତୁ| ");
INSERT INTO sanori_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ତଦା ତସ୍ମୈ ଶକ୍ତିଂ ଦାତୁଂ ସ୍ୱର୍ଗୀଯଦୂତୋ ଦର୍ଶନଂ ଦଦୌ| ");
INSERT INTO sanori_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ପଶ୍ଚାତ୍ ସୋତ୍ୟନ୍ତଂ ଯାତନଯା ୱ୍ୟାକୁଲୋ ଭୂତ୍ୱା ପୁନର୍ଦୃଢଂ ପ୍ରାର୍ଥଯାଞ୍ଚକ୍ରେ, ତସ୍ମାଦ୍ ବୃହଚ୍ଛୋଣିତବିନ୍ଦୱ ଇୱ ତସ୍ୟ ସ୍ୱେଦବିନ୍ଦୱଃ ପୃଥିୱ୍ୟାଂ ପତିତୁମାରେଭିରେ| ");
INSERT INTO sanori_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","ଅଥ ପ୍ରାର୍ଥନାତ ଉତ୍ଥାଯ ଶିଷ୍ୟାଣାଂ ସମୀପମେତ୍ୟ ତାନ୍ ମନୋଦୁଃଖିନୋ ନିଦ୍ରିତାନ୍ ଦୃଷ୍ଟ୍ୱାୱଦତ୍ ");
INSERT INTO sanori_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","କୁତୋ ନିଦ୍ରାଥ? ପରୀକ୍ଷାଯାମ୍ ଅପତନାର୍ଥଂ ପ୍ରର୍ଥଯଧ୍ୱଂ| ");
INSERT INTO sanori_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ଏତତ୍କଥାଯାଃ କଥନକାଲେ ଦ୍ୱାଦଶଶିଷ୍ୟାଣାଂ ମଧ୍ୟେ ଗଣିତୋ ଯିହୂଦାନାମା ଜନତାସହିତସ୍ତେଷାମ୍ ଅଗ୍ରେ ଚଲିତ୍ୱା ଯୀଶୋଶ୍ଚୁମ୍ବନାର୍ଥଂ ତଦନ୍ତିକମ୍ ଆଯଯୌ| ");
INSERT INTO sanori_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ତଦା ଯୀଶୁରୁୱାଚ, ହେ ଯିହୂଦା କିଂ ଚୁମ୍ବନେନ ମନୁଷ୍ୟପୁତ୍ରଂ ପରକରେଷୁ ସମର୍ପଯସି? ");
INSERT INTO sanori_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ତଦା ଯଦ୍ୟଦ୍ ଘଟିଷ୍ୟତେ ତଦନୁମାଯ ସଙ୍ଗିଭିରୁକ୍ତଂ, ହେ ପ୍ରଭୋ ୱଯଂ କି ଖଙ୍ଗେନ ଘାତଯିଷ୍ୟାମଃ? ");
INSERT INTO sanori_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ତତ ଏକଃ କରୱାଲେନାହତ୍ୟ ପ୍ରଧାନଯାଜକସ୍ୟ ଦାସସ୍ୟ ଦକ୍ଷିଣଂ କର୍ଣଂ ଚିଚ୍ଛେଦ| ");
INSERT INTO sanori_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","ଅଧୂନା ନିୱର୍ତ୍ତସ୍ୱ ଇତ୍ୟୁକ୍ତ୍ୱା ଯୀଶୁସ୍ତସ୍ୟ ଶ୍ରୁତିଂ ସ୍ପୃଷ୍ଟ୍ୱା ସ୍ୱସ୍ୟଂ ଚକାର| ");
INSERT INTO sanori_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ପଶ୍ଚାଦ୍ ଯୀଶୁଃ ସମୀପସ୍ଥାନ୍ ପ୍ରଧାନଯାଜକାନ୍ ମନ୍ଦିରସ୍ୟ ସେନାପତୀନ୍ ପ୍ରାଚୀନାଂଶ୍ଚ ଜଗାଦ, ଯୂଯଂ କୃପାଣାନ୍ ଯଷ୍ଟୀଂଶ୍ଚ ଗୃହୀତ୍ୱା ମାଂ କିଂ ଚୋରଂ ଧର୍ତ୍ତୁମାଯାତାଃ? ");
INSERT INTO sanori_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ଯଦାହଂ ଯୁଷ୍ମାଭିଃ ସହ ପ୍ରତିଦିନଂ ମନ୍ଦିରେଽତିଷ୍ଠଂ ତଦା ମାଂ ଧର୍ତ୍ତଂ ନ ପ୍ରୱୃତ୍ତାଃ, କିନ୍ତ୍ୱିଦାନୀଂ ଯୁଷ୍ମାକଂ ସମଯୋନ୍ଧକାରସ୍ୟ ଚାଧିପତ୍ୟମସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","ଅଥ ତେ ତଂ ଧୃତ୍ୱା ମହାଯାଜକସ୍ୟ ନିୱେଶନଂ ନିନ୍ୟୁଃ| ତତଃ ପିତରୋ ଦୂରେ ଦୂରେ ପଶ୍ଚାଦିତ୍ୱା ");
INSERT INTO sanori_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","ବୃହତ୍କୋଷ୍ଠସ୍ୟ ମଧ୍ୟେ ଯତ୍ରାଗ୍ନିଂ ଜ୍ୱାଲଯିତ୍ୱା ଲୋକାଃ ସମେତ୍ୟୋପୱିଷ୍ଟାସ୍ତତ୍ର ତୈଃ ସାର୍ଦ୍ଧମ୍ ଉପୱିୱେଶ| ");
INSERT INTO sanori_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ଅଥ ୱହ୍ନିସନ୍ନିଧୌ ସମୁପୱେଶକାଲେ କାଚିଦ୍ଦାସୀ ମନୋ ନିୱିଶ୍ୟ ତଂ ନିରୀକ୍ଷ୍ୟାୱଦତ୍ ପୁମାନଯଂ ତସ୍ୟ ସଙ୍ଗେଽସ୍ଥାତ୍| ");
INSERT INTO sanori_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","କିନ୍ତୁ ସ ତଦ୍ ଅପହ୍ନୁତ୍ୟାୱାଦୀତ୍ ହେ ନାରି ତମହଂ ନ ପରିଚିନୋମି| ");
INSERT INTO sanori_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","କ୍ଷଣାନ୍ତରେଽନ୍ୟଜନସ୍ତଂ ଦୃଷ୍ଟ୍ୱାବ୍ରୱୀତ୍ ତ୍ୱମପି ତେଷାଂ ନିକରସ୍ୟୈକଜନୋସି| ପିତରଃ ପ୍ରତ୍ୟୁୱାଚ ହେ ନର ନାହମସ୍ମି| ");
INSERT INTO sanori_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ତତଃ ସାର୍ଦ୍ଧଦଣ୍ଡଦ୍ୱଯାତ୍ ପରଂ ପୁନରନ୍ୟୋ ଜନୋ ନିଶ୍ଚିତ୍ୟ ବଭାଷେ, ଏଷ ତସ୍ୟ ସଙ୍ଗୀତି ସତ୍ୟଂ ଯତୋଯଂ ଗାଲୀଲୀଯୋ ଲୋକଃ| ");
INSERT INTO sanori_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","ତଦା ପିତର ଉୱାଚ ହେ ନର ତ୍ୱଂ ଯଦ୍ ୱଦମି ତଦହଂ ବୋଦ୍ଧୁଂ ନ ଶକ୍ନୋମି, ଇତି ୱାକ୍ୟେ କଥିତମାତ୍ରେ କୁକ୍କୁଟୋ ରୁରାୱ| ");
INSERT INTO sanori_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ତଦା ପ୍ରଭୁଣା ୱ୍ୟାଧୁଟ୍ୟ ପିତରେ ନିରୀକ୍ଷିତେ କୃକୱାକୁରୱାତ୍ ପୂର୍ୱ୍ୱଂ ମାଂ ତ୍ରିରପହ୍ନୋଷ୍ୟସେ ଇତି ପୂର୍ୱ୍ୱୋକ୍ତଂ ତସ୍ୟ ୱାକ୍ୟଂ ପିତରଃ ସ୍ମୃତ୍ୱା ");
INSERT INTO sanori_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ବହିର୍ଗତ୍ୱା ମହାଖେଦେନ ଚକ୍ରନ୍ଦ| ");
INSERT INTO sanori_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","ତଦା ଯୈ ର୍ୟୀଶୁର୍ଧୃତସ୍ତେ ତମୁପହସ୍ୟ ପ୍ରହର୍ତ୍ତୁମାରେଭିରେ| ");
INSERT INTO sanori_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ୱସ୍ତ୍ରେଣ ତସ୍ୟ ଦୃଶୌ ବଦ୍ଧ୍ୱା କପୋଲେ ଚପେଟାଘାତଂ କୃତ୍ୱା ପପ୍ରଚ୍ଛୁଃ, କସ୍ତେ କପୋଲେ ଚପେଟାଘାତଂ କୃତୱାନ? ଗଣଯିତ୍ୱା ତଦ୍ ୱଦ| ");
INSERT INTO sanori_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ତଦନ୍ୟତ୍ ତଦ୍ୱିରୁଦ୍ଧଂ ବହୁନିନ୍ଦାୱାକ୍ୟଂ ୱକ୍ତୁମାରେଭିରେ| ");
INSERT INTO sanori_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","ଅଥ ପ୍ରଭାତେ ସତି ଲୋକପ୍ରାଞ୍ଚଃ ପ୍ରଧାନଯାଜକା ଅଧ୍ୟାପକାଶ୍ଚ ସଭାଂ କୃତ୍ୱା ମଧ୍ୟେସଭଂ ଯୀଶୁମାନୀଯ ପପ୍ରଚ୍ଛୁଃ, ତ୍ୱମ୍ ଅଭିଷିକତୋସି ନ ୱାସ୍ମାନ୍ ୱଦ| ");
INSERT INTO sanori_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ସ ପ୍ରତ୍ୟୁୱାଚ, ମଯା ତସ୍ମିନ୍ନୁକ୍ତେଽପି ଯୂଯଂ ନ ୱିଶ୍ୱସିଷ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","କସ୍ମିଂଶ୍ଚିଦ୍ୱାକ୍ୟେ ଯୁଷ୍ମାନ୍ ପୃଷ୍ଟେଽପି ମାଂ ନ ତଦୁତ୍ତରଂ ୱକ୍ଷ୍ୟଥ ନ ମାଂ ତ୍ୟକ୍ଷ୍ୟଥ ଚ| ");
INSERT INTO sanori_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","କିନ୍ତ୍ୱିତଃ ପରଂ ମନୁଜସୁତଃ ସର୍ୱ୍ୱଶକ୍ତିମତ ଈଶ୍ୱରସ୍ୟ ଦକ୍ଷିଣେ ପାର୍ଶ୍ୱେ ସମୁପୱେକ୍ଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ତତସ୍ତେ ପପ୍ରଚ୍ଛୁଃ, ର୍ତିହ ତ୍ୱମୀଶ୍ୱରସ୍ୟ ପୁତ୍ରଃ? ସ କଥଯାମାସ, ଯୂଯଂ ଯଥାର୍ଥଂ ୱଦଥ ସ ଏୱାହଂ| ");
INSERT INTO sanori_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ତଦା ତେ ସର୍ୱ୍ୱେ କଥଯାମାସୁଃ, ର୍ତିହ ସାକ୍ଷ୍ୟେଽନ୍ସସ୍ମିନ୍ ଅସ୍ମାକଂ କିଂ ପ୍ରଯୋଜନଂ? ଅସ୍ୟ ସ୍ୱମୁଖାଦେୱ ସାକ୍ଷ୍ୟଂ ପ୍ରାପ୍ତମ୍| ");
INSERT INTO sanori_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ତତଃ ସଭାସ୍ଥାଃ ସର୍ୱ୍ୱଲୋକା ଉତ୍ଥାଯ ତଂ ପୀଲାତସମ୍ମୁଖଂ ନୀତ୍ୱାପ୍ରୋଦ୍ୟ ୱକ୍ତୁମାରେଭିରେ, ");
INSERT INTO sanori_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ସ୍ୱମଭିଷିକ୍ତଂ ରାଜାନଂ ୱଦନ୍ତଂ କୈମରରାଜାଯ କରଦାନଂ ନିଷେଧନ୍ତଂ ରାଜ୍ୟୱିପର୍ୟ୍ୟଯଂ କୁର୍ତ୍ତୁଂ ପ୍ରୱର୍ତ୍ତମାନମ୍ ଏନ ପ୍ରାପ୍ତା ୱଯଂ| ");
INSERT INTO sanori_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ତଦା ପୀଲାତସ୍ତଂ ପୃଷ୍ଟୱାନ୍ ତ୍ୱଂ କିଂ ଯିହୂଦୀଯାନାଂ ରାଜା? ସ ପ୍ରତ୍ୟୁୱାଚ ତ୍ୱଂ ସତ୍ୟମୁକ୍ତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ତଦା ପୀଲାତଃ ପ୍ରଧାନଯାଜକାଦିଲୋକାନ୍ ଜଗାଦ୍, ଅହମେତସ୍ୟ କମପ୍ୟପରାଧଂ ନାପ୍ତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","ତତସ୍ତେ ପୁନଃ ସାହମିନୋ ଭୂତ୍ୱାୱଦନ୍, ଏଷ ଗାଲୀଲ ଏତତ୍ସ୍ଥାନପର୍ୟ୍ୟନ୍ତେ ସର୍ୱ୍ୱସ୍ମିନ୍ ଯିହୂଦାଦେଶେ ସର୍ୱ୍ୱାଲ୍ଲୋକାନୁପଦିଶ୍ୟ କୁପ୍ରୱୃତ୍ତିଂ ଗ୍ରାହୀତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ତଦା ପୀଲାତୋ ଗାଲୀଲପ୍ରଦେଶସ୍ୟ ନାମ ଶ୍ରୁତ୍ୱା ପପ୍ରଚ୍ଛ, କିମଯଂ ଗାଲୀଲୀଯୋ ଲୋକଃ? ");
INSERT INTO sanori_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ତତଃ ସ ଗାଲୀଲ୍ପ୍ରଦେଶୀଯହେରୋଦ୍ରାଜସ୍ୟ ତଦା ସ୍ଥିତେସ୍ତସ୍ୟ ସମୀପେ ଯୀଶୁଂ ପ୍ରେଷଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ତଦା ହେରୋଦ୍ ଯୀଶୁଂ ୱିଲୋକ୍ୟ ସନ୍ତୁତୋଷ, ଯତଃ ସ ତସ୍ୟ ବହୁୱୃତ୍ତାନ୍ତଶ୍ରୱଣାତ୍ ତସ୍ୟ କିଞି्ଚଦାଶ୍ଚର୍ୟ୍ୟକର୍ମ୍ମ ପଶ୍ୟତି ଇତ୍ୟାଶାଂ କୃତ୍ୱା ବହୁକାଲମାରଭ୍ୟ ତଂ ଦ୍ରଷ୍ଟୁଂ ପ୍ରଯାସଂ କୃତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ତସ୍ମାତ୍ ତଂ ବହୁକଥାଃ ପପ୍ରଚ୍ଛ କିନ୍ତୁ ସ ତସ୍ୟ କସ୍ୟାପି ୱାକ୍ୟସ୍ୟ ପ୍ରତ୍ୟୁତ୍ତରଂ ନୋୱାଚ| ");
INSERT INTO sanori_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","ଅଥ ପ୍ରଧାନଯାଜକା ଅଧ୍ୟାପକାଶ୍ଚ ପ୍ରୋତ୍ତିଷ୍ଠନ୍ତଃ ସାହସେନ ତମପୱଦିତୁଂ ପ୍ରାରେଭିରେ| ");
INSERT INTO sanori_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ହେରୋଦ୍ ତସ୍ୟ ସେନାଗଣଶ୍ଚ ତମୱଜ୍ଞାଯ ଉପହାସତ୍ୱେନ ରାଜୱସ୍ତ୍ରଂ ପରିଧାପ୍ୟ ପୁନଃ ପୀଲାତଂ ପ୍ରତି ତଂ ପ୍ରାହିଣୋତ୍| ");
INSERT INTO sanori_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ପୂର୍ୱ୍ୱଂ ହେରୋଦ୍ପୀଲାତଯୋଃ ପରସ୍ପରଂ ୱୈରଭାୱ ଆସୀତ୍ କିନ୍ତୁ ତଦ୍ଦିନେ ଦ୍ୱଯୋ ର୍ମେଲନଂ ଜାତମ୍| ");
INSERT INTO sanori_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","ପଶ୍ଚାତ୍ ପୀଲାତଃ ପ୍ରଧାନଯାଜକାନ୍ ଶାସକାନ୍ ଲୋକାଂଶ୍ଚ ଯୁଗପଦାହୂଯ ବଭାଷେ, ");
INSERT INTO sanori_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ରାଜ୍ୟୱିପର୍ୟ୍ୟଯକାରକୋଯମ୍ ଇତ୍ୟୁକ୍ତ୍ୱା ମନୁଷ୍ୟମେନଂ ମମ ନିକଟମାନୈଷ୍ଟ କିନ୍ତୁ ପଶ୍ୟତ ଯୁଷ୍ମାକଂ ସମକ୍ଷମ୍ ଅସ୍ୟ ୱିଚାରଂ କୃତ୍ୱାପି ପ୍ରୋକ୍ତାପୱାଦାନୁରୂପେଣାସ୍ୟ କୋପ୍ୟପରାଧଃ ସପ୍ରମାଣୋ ନ ଜାତଃ, ");
INSERT INTO sanori_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ଯୂଯଞ୍ଚ ହେରୋଦଃ ସନ୍ନିଧୌ ପ୍ରେଷିତା ମଯା ତତ୍ରାସ୍ୟ କୋପ୍ୟପରାଧସ୍ତେନାପି ନ ପ୍ରାପ୍ତଃ| ପଶ୍ୟତାନେନ ୱଧହେेତୁକଂ କିମପି ନାପରାଦ୍ଧଂ| ");
INSERT INTO sanori_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","ତସ୍ମାଦେନଂ ତାଡଯିତ୍ୱା ୱିହାସ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","ତତ୍ରୋତ୍ସୱେ ତେଷାମେକୋ ମୋଚଯିତୱ୍ୟଃ| ");
INSERT INTO sanori_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ଇତି ହେତୋସ୍ତେ ପ୍ରୋଚ୍ଚୈରେକଦା ପ୍ରୋଚୁଃ, ଏନଂ ଦୂରୀକୃତ୍ୟ ବରବ୍ବାନାମାନଂ ମୋଚଯ| ");
INSERT INTO sanori_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","ସ ବରବ୍ବା ନଗର ଉପପ୍ଲୱୱଧାପରାଧାଭ୍ୟାଂ କାରାଯାଂ ବଦ୍ଧ ଆସୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","କିନ୍ତୁ ପୀଲାତୋ ଯୀଶୁଂ ମୋଚଯିତୁଂ ୱାଞ୍ଛନ୍ ପୁନସ୍ତାନୁୱାଚ| ");
INSERT INTO sanori_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ତଥାପ୍ୟେନଂ କ୍ରୁଶେ ୱ୍ୟଧ କ୍ରୁଶେ ୱ୍ୟଧେତି ୱଦନ୍ତସ୍ତେ ରୁରୁୱୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ତତଃ ସ ତୃତୀଯୱାରଂ ଜଗାଦ କୁତଃ? ସ କିଂ କର୍ମ୍ମ କୃତୱାନ୍? ନାହମସ୍ୟ କମପି ୱଧାପରାଧଂ ପ୍ରାପ୍ତଃ କେୱଲଂ ତାଡଯିତ୍ୱାମୁଂ ତ୍ୟଜାମି| ");
INSERT INTO sanori_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","ତଥାପି ତେ ପୁନରେନଂ କ୍ରୁଶେ ୱ୍ୟଧ ଇତ୍ୟୁକ୍ତ୍ୱା ପ୍ରୋଚ୍ଚୈର୍ଦୃଢଂ ପ୍ରାର୍ଥଯାଞ୍ଚକ୍ରିରେ; ");
INSERT INTO sanori_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ତତଃ ପ୍ରଧାନଯାଜକାଦୀନାଂ କଲରୱେ ପ୍ରବଲେ ସତି ତେଷାଂ ପ୍ରାର୍ଥନାରୂପଂ କର୍ତ୍ତୁଂ ପୀଲାତ ଆଦିଦେଶ| ");
INSERT INTO sanori_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ରାଜଦ୍ରୋହୱଧଯୋରପରାଧେନ କାରାସ୍ଥଂ ଯଂ ଜନଂ ତେ ଯଯାଚିରେ ତଂ ମୋଚଯିତ୍ୱା ଯୀଶୁଂ ତେଷାମିଚ୍ଛାଯାଂ ସମାର୍ପଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","ଅଥ ତେ ଯୀଶୁଂ ଗୃହୀତ୍ୱା ଯାନ୍ତି, ଏତର୍ହି ଗ୍ରାମାଦାଗତଂ ଶିମୋନନାମାନଂ କୁରୀଣୀଯଂ ଜନଂ ଧୃତ୍ୱା ଯୀଶୋଃ ପଶ୍ଚାନ୍ନେତୁଂ ତସ୍ୟ ସ୍କନ୍ଧେ କ୍ରୁଶମର୍ପଯାମାସୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ତତୋ ଲୋाକାରଣ୍ୟମଧ୍ୟେ ବହୁସ୍ତ୍ରିଯୋ ରୁଦତ୍ୟୋ ୱିଲପନ୍ତ୍ୟଶ୍ଚ ଯୀଶୋଃ ପଶ୍ଚାଦ୍ ଯଯୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","କିନ୍ତୁ ସ ୱ୍ୟାଘୁଟ୍ୟ ତା ଉୱାଚ, ହେ ଯିରୂଶାଲମୋ ନାର୍ୟ୍ୟୋ ଯୁଯଂ ମଦର୍ଥଂ ନ ରୁଦିତ୍ୱା ସ୍ୱାର୍ଥଂ ସ୍ୱାପତ୍ୟାର୍ଥଞ୍ଚ ରୁଦିତି; ");
INSERT INTO sanori_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ପଶ୍ୟତ ଯଃ କଦାପି ଗର୍ଭୱତ୍ୟୋ ନାଭୱନ୍ ସ୍ତନ୍ୟଞ୍ଚ ନାପାଯଯନ୍ ତାଦୃଶୀ ର୍ୱନ୍ଧ୍ୟା ଯଦା ଧନ୍ୟା ୱକ୍ଷ୍ୟନ୍ତି ସ କାଲ ଆଯାତି| ");
INSERT INTO sanori_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","ତଦା ହେ ଶୈଲା ଅସ୍ମାକମୁପରି ପତତ, ହେ ଉପଶୈଲା ଅସ୍ମାନାଚ୍ଛାଦଯତ କଥାମୀଦୃଶୀଂ ଲୋକା ୱକ୍ଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","ଯତଃ ସତେଜସି ଶାଖିନି ଚେଦେତଦ୍ ଘଟତେ ତର୍ହି ଶୁଷ୍କଶାଖିନି କିଂ ନ ଘଟିଷ୍ୟତେ? ");
INSERT INTO sanori_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ତଦା ତେ ହନ୍ତୁଂ ଦ୍ୱାୱପରାଧିନୌ ତେନ ସାର୍ଦ୍ଧଂ ନିନ୍ୟୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","ଅପରଂ ଶିରଃକପାଲନାମକସ୍ଥାନଂ ପ୍ରାପ୍ୟ ତଂ କ୍ରୁଶେ ୱିୱିଧୁଃ; ତଦ୍ଦ୍ୱଯୋରପରାଧିନୋରେକଂ ତସ୍ୟ ଦକ୍ଷିଣୋ ତଦନ୍ୟଂ ୱାମେ କ୍ରୁଶେ ୱିୱିଧୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ତଦା ଯୀଶୁରକଥଯତ୍, ହେ ପିତରେତାନ୍ କ୍ଷମସ୍ୱ ଯତ ଏତେ ଯତ୍ କର୍ମ୍ମ କୁର୍ୱ୍ୱନ୍ତି ତନ୍ ନ ୱିଦୁଃ; ପଶ୍ଚାତ୍ତେ ଗୁଟିକାପାତଂ କୃତ୍ୱା ତସ୍ୟ ୱସ୍ତ୍ରାଣି ୱିଭଜ୍ୟ ଜଗୃହୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","ତତ୍ର ଲୋକସଂଘସ୍ତିଷ୍ଠନ୍ ଦଦର୍ଶ; ତେ ତେଷାଂ ଶାସକାଶ୍ଚ ତମୁପହସ୍ୟ ଜଗଦୁଃ, ଏଷ ଇତରାନ୍ ରକ୍ଷିତୱାନ୍ ଯଦୀଶ୍ୱରେଣାଭିରୁଚିତୋ ଽଭିଷିକ୍ତସ୍ତ୍ରାତା ଭୱତି ତର୍ହି ସ୍ୱମଧୁନା ରକ୍ଷତୁ| ");
INSERT INTO sanori_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","ତଦନ୍ୟଃ ସେନାଗଣା ଏତ୍ୟ ତସ୍ମୈ ଅମ୍ଲରସଂ ଦତ୍ୱା ପରିହସ୍ୟ ପ୍ରୋୱାଚ, ");
INSERT INTO sanori_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ଚେତ୍ତ୍ୱଂ ଯିହୂଦୀଯାନାଂ ରାଜାସି ତର୍ହି ସ୍ୱଂ ରକ୍ଷ| ");
INSERT INTO sanori_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ଯିହୂଦୀଯାନାଂ ରାଜେତି ୱାକ୍ୟଂ ଯୂନାନୀଯରୋମୀଯେବ୍ରୀଯାକ୍ଷରୈ ର୍ଲିଖିତଂ ତଚ୍ଛିରସ ଊର୍ଦ୍ଧ୍ୱେଽସ୍ଥାପ୍ୟତ| ");
INSERT INTO sanori_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","ତଦୋଭଯପାର୍ଶ୍ୱଯୋ ର୍ୱିଦ୍ଧୌ ଯାୱପରାଧିନୌ ତଯୋରେକସ୍ତଂ ୱିନିନ୍ଦ୍ୟ ବଭାଷେ, ଚେତ୍ତ୍ୱମ୍ ଅଭିଷିକ୍ତୋସି ତର୍ହି ସ୍ୱମାୱାଞ୍ଚ ରକ୍ଷ| ");
INSERT INTO sanori_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","କିନ୍ତ୍ୱନ୍ୟସ୍ତଂ ତର୍ଜଯିତ୍ୱାୱଦତ୍, ଈଶ୍ୱରାତ୍ତୱ କିଞ୍ଚିଦପି ଭଯଂ ନାସ୍ତି କିଂ? ତ୍ୱମପି ସମାନଦଣ୍ଡୋସି, ");
INSERT INTO sanori_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ଯୋଗ୍ୟପାତ୍ରେ ଆୱାଂ ସ୍ୱସ୍ୱକର୍ମ୍ମଣାଂ ସମୁଚିତଫଲଂ ପ୍ରାପ୍ନୁୱଃ କିନ୍ତ୍ୱନେନ କିମପି ନାପରାଦ୍ଧଂ| ");
INSERT INTO sanori_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ଅଥ ସ ଯୀଶୁଂ ଜଗାଦ ହେ ପ୍ରଭେ ଭୱାନ୍ ସ୍ୱରାଜ୍ୟପ୍ରୱେଶକାଲେ ମାଂ ସ୍ମରତୁ| ");
INSERT INTO sanori_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ତଦା ଯୀଶୁଃ କଥିତୱାନ୍ ତ୍ୱାଂ ଯଥାର୍ଥଂ ୱଦାମି ତ୍ୱମଦ୍ୟୈୱ ମଯା ସାର୍ଦ୍ଧଂ ପରଲୋକସ୍ୟ ସୁଖସ୍ଥାନଂ ପ୍ରାପ୍ସ୍ୟସି| ");
INSERT INTO sanori_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","ଅପରଞ୍ଚ ଦ୍ୱିତୀଯଯାମାତ୍ ତୃତୀଯଯାମପର୍ୟ୍ୟନ୍ତଂ ରୱେସ୍ତେଜସୋନ୍ତର୍ହିତତ୍ୱାତ୍ ସର୍ୱ୍ୱଦେଶୋଽନ୍ଧକାରେଣାୱୃତୋ ");
INSERT INTO sanori_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ମନ୍ଦିରସ୍ୟ ଯୱନିକା ଚ ଛିଦ୍ୟମାନା ଦ୍ୱିଧା ବଭୂୱ| ");
INSERT INTO sanori_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ତତୋ ଯୀଶୁରୁଚ୍ଚୈରୁୱାଚ, ହେ ପିତ ର୍ମମାତ୍ମାନଂ ତୱ କରେ ସମର୍ପଯେ, ଇତ୍ୟୁକ୍ତ୍ୱା ସ ପ୍ରାଣାନ୍ ଜହୌ| ");
INSERT INTO sanori_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ତଦୈତା ଘଟନା ଦୃଷ୍ଟ୍ୱା ଶତସେନାପତିରୀଶ୍ୱରଂ ଧନ୍ୟମୁକ୍ତ୍ୱା କଥିତୱାନ୍ ଅଯଂ ନିତାନ୍ତଂ ସାଧୁମନୁଷ୍ୟ ଆସୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","ଅଥ ଯାୱନ୍ତୋ ଲୋକା ଦ୍ରଷ୍ଟୁମ୍ ଆଗତାସ୍ତେ ତା ଘଟନା ଦୃଷ୍ଟ୍ୱା ୱକ୍ଷଃସୁ କରାଘାତଂ କୃତ୍ୱା ୱ୍ୟାଚୁଟ୍ୟ ଗତାଃ| ");
INSERT INTO sanori_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","ଯୀଶୋ ର୍ଜ୍ଞାତଯୋ ଯା ଯା ଯୋଷିତଶ୍ଚ ଗାଲୀଲସ୍ତେନ ସାର୍ଦ୍ଧମାଯାତାସ୍ତା ଅପି ଦୂରେ ସ୍ଥିତ୍ୱା ତତ୍ ସର୍ୱ୍ୱଂ ଦଦୃଶୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","ତଦା ଯିହୂଦୀଯାନାଂ ମନ୍ତ୍ରଣାଂ କ୍ରିଯାଞ୍ଚାସମ୍ମନ୍ୟମାନ ଈଶ୍ୱରସ୍ୟ ରାଜତ୍ୱମ୍ ଅପେକ୍ଷମାଣୋ ");
INSERT INTO sanori_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ଯିହୂଦିଦେଶୀଯୋ ଽରିମଥୀଯନଗରୀଯୋ ଯୂଷଫ୍ନାମା ମନ୍ତ୍ରୀ ଭଦ୍ରୋ ଧାର୍ମ୍ମିକଶ୍ଚ ପୁମାନ୍ ");
INSERT INTO sanori_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ପୀଲାତାନ୍ତିକଂ ଗତ୍ୱା ଯୀଶୋ ର୍ଦେହଂ ଯଯାଚେ| ");
INSERT INTO sanori_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ପଶ୍ଚାଦ୍ ୱପୁରୱରୋହ୍ୟ ୱାସସା ସଂୱେଷ୍ଟ୍ୟ ଯତ୍ର କୋପି ମାନୁଷୋ ନାସ୍ଥାପ୍ୟତ ତସ୍ମିନ୍ ଶୈଲେ ସ୍ୱାତେ ଶ୍ମଶାନେ ତଦସ୍ଥାପଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ତଦ୍ଦିନମାଯୋଜନୀଯଂ ଦିନଂ ୱିଶ୍ରାମୱାରଶ୍ଚ ସମୀପଃ| ");
INSERT INTO sanori_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","ଅପରଂ ଯୀଶୁନା ସାର୍ଦ୍ଧଂ ଗାଲୀଲ ଆଗତା ଯୋଷିତଃ ପଶ୍ଚାଦିତ୍ୱା ଶ୍ମଶାନେ ତତ୍ର ଯଥା ୱପୁଃ ସ୍ଥାପିତଂ ତଚ୍ଚ ଦୃଷ୍ଟ୍ୱା ");
INSERT INTO sanori_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ୱ୍ୟାଘୁଟ୍ୟ ସୁଗନ୍ଧିଦ୍ରୱ୍ୟତୈଲାନି କୃତ୍ୱା ୱିଧିୱଦ୍ ୱିଶ୍ରାମୱାରେ ୱିଶ୍ରାମଂ ଚକ୍ରୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","ଅଥ ସପ୍ତାହପ୍ରଥମଦିନେଽତିପ୍ରତ୍ୟୂଷେ ତା ଯୋଷିତଃ ସମ୍ପାଦିତଂ ସୁଗନ୍ଧିଦ୍ରୱ୍ୟଂ ଗୃହୀତ୍ୱା ତଦନ୍ୟାଭିଃ କିଯତୀଭିଃ ସ୍ତ୍ରୀଭିଃ ସହ ଶ୍ମଶାନଂ ଯଯୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","କିନ୍ତୁ ଶ୍ମଶାନଦ୍ୱାରାତ୍ ପାଷାଣମପସାରିତଂ ଦୃଷ୍ଟ୍ୱା ");
INSERT INTO sanori_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ତାଃ ପ୍ରୱିଶ୍ୟ ପ୍ରଭୋ ର୍ଦେହମପ୍ରାପ୍ୟ ");
INSERT INTO sanori_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ୱ୍ୟାକୁଲା ଭୱନ୍ତି ଏତର୍ହି ତେଜୋମଯୱସ୍ତ୍ରାନ୍ୱିତୌ ଦ୍ୱୌ ପୁରୁଷୌ ତାସାଂ ସମୀପେ ସମୁପସ୍ଥିତୌ ");
INSERT INTO sanori_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ତସ୍ମାତ୍ତାଃ ଶଙ୍କାଯୁକ୍ତା ଭୂମାୱଧୋମୁଖ୍ୟସ୍ୟସ୍ଥୁଃ| ତଦା ତୌ ତା ଊଚତୁ ର୍ମୃତାନାଂ ମଧ୍ୟେ ଜୀୱନ୍ତଂ କୁତୋ ମୃଗଯଥ? ");
INSERT INTO sanori_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","ସୋତ୍ର ନାସ୍ତି ସ ଉଦସ୍ଥାତ୍| ");
INSERT INTO sanori_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ପାପିନାଂ କରେଷୁ ସମର୍ପିତେନ କ୍ରୁଶେ ହତେନ ଚ ମନୁଷ୍ୟପୁତ୍ରେଣ ତୃତୀଯଦିୱସେ ଶ୍ମଶାନାଦୁତ୍ଥାତୱ୍ୟମ୍ ଇତି କଥାଂ ସ ଗଲୀଲି ତିଷ୍ଠନ୍ ଯୁଷ୍ମଭ୍ୟଂ କଥିତୱାନ୍ ତାଂ ସ୍ମରତ| ");
INSERT INTO sanori_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","ତଦା ତସ୍ୟ ସା କଥା ତାସାଂ ମନଃସୁ ଜାତା| ");
INSERT INTO sanori_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ଅନନ୍ତରଂ ଶ୍ମଶାନାଦ୍ ଗତ୍ୱା ତା ଏକାଦଶଶିଷ୍ୟାଦିଭ୍ୟଃ ସର୍ୱ୍ୱେଭ୍ୟସ୍ତାଂ ୱାର୍ତ୍ତାଂ କଥଯାମାସୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","ମଗ୍ଦଲୀନୀମରିଯମ୍, ଯୋହନା, ଯାକୂବୋ ମାତା ମରିଯମ୍ ତଦନ୍ୟାଃ ସଙ୍ଗିନ୍ୟୋ ଯୋଷିତଶ୍ଚ ପ୍ରେରିତେଭ୍ୟ ଏତାଃ ସର୍ୱ୍ୱା ୱାର୍ତ୍ତାଃ କଥଯାମାସୁଃ ");
INSERT INTO sanori_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","କିନ୍ତୁ ତାସାଂ କଥାମ୍ ଅନର୍ଥକାଖ୍ୟାନମାତ୍ରଂ ବୁଦ୍ଧ୍ୱା କୋପି ନ ପ୍ରତ୍ୟୈତ୍| ");
INSERT INTO sanori_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","ତଦା ପିତର ଉତ୍ଥାଯ ଶ୍ମଶାନାନ୍ତିକଂ ଦଧାୱ, ତତ୍ର ଚ ପ୍ରହ୍ୱୋ ଭୂତ୍ୱା ପାର୍ଶ୍ୱୈକସ୍ଥାପିତଂ କେୱଲଂ ୱସ୍ତ୍ରଂ ଦଦର୍ଶ; ତସ୍ମାଦାଶ୍ଚର୍ୟ୍ୟଂ ମନ୍ୟମାନୋ ଯଦଘଟତ ତନ୍ମନସି ୱିଚାରଯନ୍ ପ୍ରତସ୍ଥେ| ");
INSERT INTO sanori_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","ତସ୍ମିନ୍ନେୱ ଦିନେ ଦ୍ୱୌ ଶିଯ୍ୟୌ ଯିରୂଶାଲମଶ୍ଚତୁଷ୍କ୍ରୋଶାନ୍ତରିତମ୍ ଇମ୍ମାଯୁଗ୍ରାମଂ ଗଚ୍ଛନ୍ତୌ ");
INSERT INTO sanori_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ତାସାଂ ଘଟନାନାଂ କଥାମକଥଯତାଂ ");
INSERT INTO sanori_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ତଯୋରାଲାପୱିଚାରଯୋଃ କାଲେ ଯୀଶୁରାଗତ୍ୟ ତାଭ୍ୟାଂ ସହ ଜଗାମ ");
INSERT INTO sanori_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","କିନ୍ତୁ ଯଥା ତୌ ତଂ ନ ପରିଚିନୁତସ୍ତଦର୍ଥଂ ତଯୋ ର୍ଦୃଷ୍ଟିଃ ସଂରୁଦ୍ଧା| ");
INSERT INTO sanori_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ସ ତୌ ପୃଷ୍ଟୱାନ୍ ଯୁୱାଂ ୱିଷଣ୍ଣୌ କିଂ ୱିଚାରଯନ୍ତୌ ଗଚ୍ଛଥଃ? ");
INSERT INTO sanori_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ତତସ୍ତଯୋଃ କ୍ଲିଯପାନାମା ପ୍ରତ୍ୟୁୱାଚ ଯିରୂଶାଲମପୁରେଽଧୁନା ଯାନ୍ୟଘଟନ୍ତ ତ୍ୱଂ କେୱଲୱିଦେଶୀ କିଂ ତଦ୍ୱୃତ୍ତାନ୍ତଂ ନ ଜାନାସି? ");
INSERT INTO sanori_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ସ ପପ୍ରଚ୍ଛ କା ଘଟନାଃ? ତଦା ତୌ ୱକ୍ତୁମାରେଭାତେ ଯୀଶୁନାମା ଯୋ ନାସରତୀଯୋ ଭୱିଷ୍ୟଦ୍ୱାଦୀ ଈଶ୍ୱରସ୍ୟ ମାନୁଷାଣାଞ୍ଚ ସାକ୍ଷାତ୍ ୱାକ୍ୟେ କର୍ମ୍ମଣି ଚ ଶକ୍ତିମାନାସୀତ୍ ");
INSERT INTO sanori_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ତମ୍ ଅସ୍ମାକଂ ପ୍ରଧାନଯାଜକା ୱିଚାରକାଶ୍ଚ କେନାପି ପ୍ରକାରେଣ କ୍ରୁଶେ ୱିଦ୍ଧ୍ୱା ତସ୍ୟ ପ୍ରାଣାନନାଶଯନ୍ ତଦୀଯା ଘଟନାଃ; ");
INSERT INTO sanori_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","କିନ୍ତୁ ଯ ଇସ୍ରାଯେଲୀଯଲୋକାନ୍ ଉଦ୍ଧାରଯିଷ୍ୟତି ସ ଏୱାଯମ୍ ଇତ୍ୟାଶାସ୍ମାଭିଃ କୃତା| ତଦ୍ୟଥା ତଥାସ୍ତୁ ତସ୍ୟା ଘଟନାଯା ଅଦ୍ୟ ଦିନତ୍ରଯଂ ଗତଂ| ");
INSERT INTO sanori_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ଅଧିକନ୍ତ୍ୱସ୍ମାକଂ ସଙ୍ଗିନୀନାଂ କିଯତ୍ସ୍ତ୍ରୀଣାଂ ମୁଖେଭ୍ୟୋଽସମ୍ଭୱୱାକ୍ୟମିଦଂ ଶ୍ରୁତଂ; ");
INSERT INTO sanori_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ତାଃ ପ୍ରତ୍ୟୂଷେ ଶ୍ମଶାନଂ ଗତ୍ୱା ତତ୍ର ତସ୍ୟ ଦେହମ୍ ଅପ୍ରାପ୍ୟ ୱ୍ୟାଘୁଟ୍ୟେତ୍ୱା ପ୍ରୋକ୍ତୱତ୍ୟଃ ସ୍ୱର୍ଗୀସଦୂତୌ ଦୃଷ୍ଟାୱସ୍ମାଭିସ୍ତୌ ଚାୱାଦିଷ୍ଟାଂ ସ ଜୀୱିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ତତୋସ୍ମାକଂ କୈଶ୍ଚିତ୍ ଶ୍ମଶାନମଗମ୍ୟତ ତେଽପି ସ୍ତ୍ରୀଣାଂ ୱାକ୍ୟାନୁରୂପଂ ଦୃଷ୍ଟୱନ୍ତଃ କିନ୍ତୁ ତଂ ନାପଶ୍ୟନ୍| ");
INSERT INTO sanori_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ତଦା ସ ତାୱୁୱାଚ, ହେ ଅବୋଧୌ ହେ ଭୱିଷ୍ୟଦ୍ୱାଦିଭିରୁକ୍ତୱାକ୍ୟଂ ପ୍ରତ୍ୟେତୁଂ ୱିଲମ୍ବମାନୌ; ");
INSERT INTO sanori_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ଏତତ୍ସର୍ୱ୍ୱଦୁଃଖଂ ଭୁକ୍ତ୍ୱା ସ୍ୱଭୂତିପ୍ରାପ୍ତିଃ କିଂ ଖ୍ରୀଷ୍ଟସ୍ୟ ନ ନ୍ୟାଯ୍ୟା? ");
INSERT INTO sanori_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ତତଃ ସ ମୂସାଗ୍ରନ୍ଥମାରଭ୍ୟ ସର୍ୱ୍ୱଭୱିଷ୍ୟଦ୍ୱାଦିନାଂ ସର୍ୱ୍ୱଶାସ୍ତ୍ରେ ସ୍ୱସ୍ମିନ୍ ଲିଖିତାଖ୍ୟାନାଭିପ୍ରାଯଂ ବୋଧଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","ଅଥ ଗମ୍ୟଗ୍ରାମାଭ୍ୟର୍ଣଂ ପ୍ରାପ୍ୟ ତେନାଗ୍ରେ ଗମନଲକ୍ଷଣେ ଦର୍ଶିତେ ");
INSERT INTO sanori_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ତୌ ସାଧଯିତ୍ୱାୱଦତାଂ ସହାୱାଭ୍ୟାଂ ତିଷ୍ଠ ଦିନେ ଗତେ ସତି ରାତ୍ରିରଭୂତ୍; ତତଃ ସ ତାଭ୍ୟାଂ ସାର୍ଦ୍ଧଂ ସ୍ଥାତୁଂ ଗୃହଂ ଯଯୌ| ");
INSERT INTO sanori_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","ପଶ୍ଚାଦ୍ଭୋଜନୋପୱେଶକାଲେ ସ ପୂପଂ ଗୃହୀତ୍ୱା ଈଶ୍ୱରଗୁଣାନ୍ ଜଗାଦ ତଞ୍ଚ ଭଂକ୍ତ୍ୱା ତାଭ୍ୟାଂ ଦଦୌ| ");
INSERT INTO sanori_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ତଦା ତଯୋ ର୍ଦୃଷ୍ଟୌ ପ୍ରସନ୍ନାଯାଂ ତଂ ପ୍ରତ୍ୟଭିଜ୍ଞତୁଃ କିନ୍ତୁ ସ ତଯୋଃ ସାକ୍ଷାଦନ୍ତର୍ଦଧେ| ");
INSERT INTO sanori_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ତତସ୍ତୌ ମିଥୋଭିଧାତୁମ୍ ଆରବ୍ଧୱନ୍ତୌ ଗମନକାଲେ ଯଦା କଥାମକଥଯତ୍ ଶାସ୍ତ୍ରାର୍ଥଞ୍ଚବୋଧଯତ୍ ତଦାୱଯୋ ର୍ବୁଦ୍ଧିଃ କିଂ ନ ପ୍ରାଜ୍ୱଲତ୍? ");
INSERT INTO sanori_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","ତୌ ତତ୍କ୍ଷଣାଦୁତ୍ଥାଯ ଯିରୂଶାଲମପୁରଂ ପ୍ରତ୍ୟାଯଯତୁଃ, ତତ୍ସ୍ଥାନେ ଶିଷ୍ୟାଣାମ୍ ଏକାଦଶାନାଂ ସଙ୍ଗିନାଞ୍ଚ ଦର୍ଶନଂ ଜାତଂ| ");
INSERT INTO sanori_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ତେ ପ୍ରୋଚୁଃ ପ୍ରଭୁରୁଦତିଷ୍ଠଦ୍ ଇତି ସତ୍ୟଂ ଶିମୋନେ ଦର୍ଶନମଦାଚ୍ଚ| ");
INSERT INTO sanori_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","ତତଃ ପଥଃ ସର୍ୱ୍ୱଘଟନାଯାଃ ପୂପଭଞ୍ଜନେନ ତତ୍ପରିଚଯସ୍ୟ ଚ ସର୍ୱ୍ୱୱୃତ୍ତାନ୍ତଂ ତୌ ୱକ୍ତୁମାରେଭାତେ| ");
INSERT INTO sanori_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ଇତ୍ଥଂ ତେ ପରସ୍ପରଂ ୱଦନ୍ତି ତତ୍କାଲେ ଯୀଶୁଃ ସ୍ୱଯଂ ତେଷାଂ ମଧ୍ୟ ପ୍ରୋତ୍ଥଯ ଯୁଷ୍ମାକଂ କଲ୍ୟାଣଂ ଭୂଯାଦ୍ ଇତ୍ୟୁୱାଚ, ");
INSERT INTO sanori_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","କିନ୍ତୁ ଭୂତଂ ପଶ୍ୟାମ ଇତ୍ୟନୁମାଯ ତେ ସମୁଦ୍ୱିୱିଜିରେ ତ୍ରେଷୁଶ୍ଚ| ");
INSERT INTO sanori_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","ସ ଉୱାଚ, କୁତୋ ଦୁଃଖିତା ଭୱଥ? ଯୁଷ୍ମାକଂ ମନଃସୁ ସନ୍ଦେହ ଉଦେତି ଚ କୁତଃ? ");
INSERT INTO sanori_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ଏଷୋହଂ, ମମ କରୌ ପଶ୍ୟତ ୱରଂ ସ୍ପୃଷ୍ଟ୍ୱା ପଶ୍ୟତ, ମମ ଯାଦୃଶାନି ପଶ୍ୟଥ ତାଦୃଶାନି ଭୂତସ୍ୟ ମାଂସାସ୍ଥୀନି ନ ସନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ଇତ୍ୟୁକ୍ତ୍ୱା ସ ହସ୍ତପାଦାନ୍ ଦର୍ଶଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ତେଽସମ୍ଭୱଂ ଜ୍ଞାତ୍ୱା ସାନନ୍ଦା ନ ପ୍ରତ୍ୟଯନ୍| ତତଃ ସ ତାନ୍ ପପ୍ରଚ୍ଛ, ଅତ୍ର ଯୁଷ୍ମାକଂ ସମୀପେ ଖାଦ୍ୟଂ କିଞ୍ଚିଦସ୍ତି? ");
INSERT INTO sanori_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ତତସ୍ତେ କିଯଦ୍ଦଗ୍ଧମତ୍ସ୍ୟଂ ମଧୁ ଚ ଦଦୁଃ ");
INSERT INTO sanori_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ସ ତଦାଦାଯ ତେଷାଂ ସାକ୍ଷାଦ୍ ବୁଭୁଜେ ");
INSERT INTO sanori_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","କଥଯାମାସ ଚ ମୂସାୱ୍ୟୱସ୍ଥାଯାଂ ଭୱିଷ୍ୟଦ୍ୱାଦିନାଂ ଗ୍ରନ୍ଥେଷୁ ଗୀତପୁସ୍ତକେ ଚ ମଯି ଯାନି ସର୍ୱ୍ୱାଣି ୱଚନାନି ଲିଖିତାନି ତଦନୁରୂପାଣି ଘଟିଷ୍ୟନ୍ତେ ଯୁଷ୍ମାଭିଃ ସାର୍ଦ୍ଧଂ ସ୍ଥିତ୍ୱାହଂ ଯଦେତଦ୍ୱାକ୍ୟମ୍ ଅୱଦଂ ତଦିଦାନୀଂ ପ୍ରତ୍ୟକ୍ଷମଭୂତ୍| ");
INSERT INTO sanori_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","ଅଥ ତେଭ୍ୟଃ ଶାସ୍ତ୍ରବୋଧାଧିକାରଂ ଦତ୍ୱାୱଦତ୍, ");
INSERT INTO sanori_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ଖ୍ରୀଷ୍ଟେନେତ୍ଥଂ ମୃତିଯାତନା ଭୋକ୍ତୱ୍ୟା ତୃତୀଯଦିନେ ଚ ଶ୍ମଶାନାଦୁତ୍ଥାତୱ୍ୟଞ୍ଚେତି ଲିପିରସ୍ତି; ");
INSERT INTO sanori_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ତନ୍ନାମ୍ନା ଯିରୂଶାଲମମାରଭ୍ୟ ସର୍ୱ୍ୱଦେଶେ ମନଃପରାୱର୍ତ୍ତନସ୍ୟ ପାପମୋଚନସ୍ୟ ଚ ସୁସଂୱାଦଃ ପ୍ରଚାରଯିତୱ୍ୟଃ, ");
INSERT INTO sanori_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ଏଷୁ ସର୍ୱ୍ୱେଷୁ ଯୂଯଂ ସାକ୍ଷିଣଃ| ");
INSERT INTO sanori_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ଅପରଞ୍ଚ ପଶ୍ୟତ ପିତ୍ରା ଯତ୍ ପ୍ରତିଜ୍ଞାତଂ ତତ୍ ପ୍ରେଷଯିଷ୍ୟାମି, ଅତଏୱ ଯାୱତ୍କାଲଂ ଯୂଯଂ ସ୍ୱର୍ଗୀଯାଂ ଶକ୍ତିଂ ନ ପ୍ରାପ୍ସ୍ୟଥ ତାୱତ୍କାଲଂ ଯିରୂଶାଲମ୍ନଗରେ ତିଷ୍ଠତ| ");
INSERT INTO sanori_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","ଅଥ ସ ତାନ୍ ବୈଥନୀଯାପର୍ୟ୍ୟନ୍ତଂ ନୀତ୍ୱା ହସ୍ତାୱୁତ୍ତୋଲ୍ୟ ଆଶିଷ ୱକ୍ତୁମାରେଭେ ");
INSERT INTO sanori_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ଆଶିଷଂ ୱଦନ୍ନେୱ ଚ ତେଭ୍ୟଃ ପୃଥଗ୍ ଭୂତ୍ୱା ସ୍ୱର୍ଗାଯ ନୀତୋଽଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","ତଦା ତେ ତଂ ଭଜମାନା ମହାନନ୍ଦେନ ଯିରୂଶାଲମଂ ପ୍ରତ୍ୟାଜଗ୍ମୁଃ| ");
INSERT INTO sanori_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ତତୋ ନିରନ୍ତରଂ ମନ୍ଦିରେ ତିଷ୍ଠନ୍ତ ଈଶ୍ୱରସ୍ୟ ପ୍ରଶଂସାଂ ଧନ୍ୟୱାଦଞ୍ଚ କର୍ତ୍ତମ୍ ଆରେଭିରେ| ଇତି||");
INSERT INTO sanori_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ଆଦୌ ୱାଦ ଆସୀତ୍ ସ ଚ ୱାଦ ଈଶ୍ୱରେଣ ସାର୍ଧମାସୀତ୍ ସ ୱାଦଃ ସ୍ୱଯମୀଶ୍ୱର ଏୱ| ");
INSERT INTO sanori_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ସ ଆଦାୱୀଶ୍ୱରେଣ ସହାସୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ତେନ ସର୍ୱ୍ୱଂ ୱସ୍ତୁ ସସୃଜେ ସର୍ୱ୍ୱେଷୁ ସୃଷ୍ଟୱସ୍ତୁଷୁ କିମପି ୱସ୍ତୁ ତେନାସୃଷ୍ଟଂ ନାସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ସ ଜୀୱନସ୍ୟାକାରଃ, ତଚ୍ଚ ଜୀୱନଂ ମନୁଷ୍ୟାଣାଂ ଜ୍ୟୋତିଃ ");
INSERT INTO sanori_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","ତଜ୍ଜ୍ୟୋତିରନ୍ଧକାରେ ପ୍ରଚକାଶେ କିନ୍ତ୍ୱନ୍ଧକାରସ୍ତନ୍ନ ଜଗ୍ରାହ| ");
INSERT INTO sanori_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","ଯୋହନ୍ ନାମକ ଏକୋ ମନୁଜ ଈଶ୍ୱରେଣ ପ୍ରେଷଯାଞ୍ଚକ୍ରେ| ");
INSERT INTO sanori_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ତଦ୍ୱାରା ଯଥା ସର୍ୱ୍ୱେ ୱିଶ୍ୱସନ୍ତି ତଦର୍ଥଂ ସ ତଜ୍ଜ୍ୟୋତିଷି ପ୍ରମାଣଂ ଦାତୁଂ ସାକ୍ଷିସ୍ୱରୂପୋ ଭୂତ୍ୱାଗମତ୍, ");
INSERT INTO sanori_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ସ ସ୍ୱଯଂ ତଜ୍ଜ୍ୟୋତି ର୍ନ କିନ୍ତୁ ତଜ୍ଜ୍ୟୋତିଷି ପ୍ରମାଣଂ ଦାତୁମାଗମତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ଜଗତ୍ୟାଗତ୍ୟ ଯଃ ସର୍ୱ୍ୱମନୁଜେଭ୍ୟୋ ଦୀପ୍ତିଂ ଦଦାତି ତଦେୱ ସତ୍ୟଜ୍ୟୋତିଃ| ");
INSERT INTO sanori_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ସ ଯଜ୍ଜଗଦସୃଜତ୍ ତନ୍ମଦ୍ୟ ଏୱ ସ ଆସୀତ୍ କିନ୍ତୁ ଜଗତୋ ଲୋକାସ୍ତଂ ନାଜାନନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","ନିଜାଧିକାରଂ ସ ଆଗଚ୍ଛତ୍ କିନ୍ତୁ ପ୍ରଜାସ୍ତଂ ନାଗୃହ୍ଲନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","ତଥାପି ଯେ ଯେ ତମଗୃହ୍ଲନ୍ ଅର୍ଥାତ୍ ତସ୍ୟ ନାମ୍ନି ୱ୍ୟଶ୍ୱସନ୍ ତେଭ୍ୟ ଈଶ୍ୱରସ୍ୟ ପୁତ୍ରା ଭୱିତୁମ୍ ଅଧିକାରମ୍ ଅଦଦାତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ତେଷାଂ ଜନିଃ ଶୋଣିତାନ୍ନ ଶାରୀରିକାଭିଲାଷାନ୍ନ ମାନୱାନାମିଚ୍ଛାତୋ ନ କିନ୍ତ୍ୱୀଶ୍ୱରାଦଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","ସ ୱାଦୋ ମନୁଷ୍ୟରୂପେଣାୱତୀର୍ୟ୍ୟ ସତ୍ୟତାନୁଗ୍ରହାଭ୍ୟାଂ ପରିପୂର୍ଣଃ ସନ୍ ସାର୍ଧମ୍ ଅସ୍ମାଭି ର୍ନ୍ୟୱସତ୍ ତତଃ ପିତୁରଦ୍ୱିତୀଯପୁତ୍ରସ୍ୟ ଯୋଗ୍ୟୋ ଯୋ ମହିମା ତଂ ମହିମାନଂ ତସ୍ୟାପଶ୍ୟାମ| ");
INSERT INTO sanori_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ତତୋ ଯୋହନପି ପ୍ରଚାର୍ୟ୍ୟ ସାକ୍ଷ୍ୟମିଦଂ ଦତ୍ତୱାନ୍ ଯୋ ମମ ପଶ୍ଚାଦ୍ ଆଗମିଷ୍ୟତି ସ ମତ୍ତୋ ଗୁରୁତରଃ; ଯତୋ ମତ୍ପୂର୍ୱ୍ୱଂ ସ ୱିଦ୍ୟମାନ ଆସୀତ୍; ଯଦର୍ଥମ୍ ଅହଂ ସାକ୍ଷ୍ୟମିଦମ୍ ଅଦାଂ ସ ଏଷଃ| ");
INSERT INTO sanori_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ଅପରଞ୍ଚ ତସ୍ୟ ପୂର୍ଣତାଯା ୱଯଂ ସର୍ୱ୍ୱେ କ୍ରମଶଃ କ୍ରମଶୋନୁଗ୍ରହଂ ପ୍ରାପ୍ତାଃ| ");
INSERT INTO sanori_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","ମୂସାଦ୍ୱାରା ୱ୍ୟୱସ୍ଥା ଦତ୍ତା କିନ୍ତ୍ୱନୁଗ୍ରହଃ ସତ୍ୟତ୍ୱଞ୍ଚ ଯୀଶୁଖ୍ରୀଷ୍ଟଦ୍ୱାରା ସମୁପାତିଷ୍ଠତାଂ| ");
INSERT INTO sanori_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","କୋପି ମନୁଜ ଈଶ୍ୱରଂ କଦାପି ନାପଶ୍ୟତ୍ କିନ୍ତୁ ପିତୁଃ କ୍ରୋଡସ୍ଥୋଽଦ୍ୱିତୀଯଃ ପୁତ୍ରସ୍ତଂ ପ୍ରକାଶଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","ତ୍ୱଂ କଃ? ଇତି ୱାକ୍ୟଂ ପ୍ରେଷ୍ଟୁଂ ଯଦା ଯିହୂଦୀଯଲୋକା ଯାଜକାନ୍ ଲେୱିଲୋକାଂଶ୍ଚ ଯିରୂଶାଲମୋ ଯୋହନଃ ସମୀପେ ପ୍ରେଷଯାମାସୁଃ, ");
INSERT INTO sanori_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ତଦା ସ ସ୍ୱୀକୃତୱାନ୍ ନାପହ୍ନୂତୱାନ୍ ନାହମ୍ ଅଭିଷିକ୍ତ ଇତ୍ୟଙ୍ଗୀକୃତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","ତଦା ତେଽପୃଚ୍ଛନ୍ ତର୍ହି କୋ ଭୱାନ୍? କିଂ ଏଲିଯଃ? ସୋୱଦତ୍ ନ; ତତସ୍ତେଽପୃଚ୍ଛନ୍ ତର୍ହି ଭୱାନ୍ ସ ଭୱିଷ୍ୟଦ୍ୱାଦୀ? ସୋୱଦତ୍ ନାହଂ ସଃ| ");
INSERT INTO sanori_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","ତଦା ତେଽପୃଚ୍ଛନ୍ ତର୍ହି ଭୱାନ୍ କଃ? ୱଯଂ ଗତ୍ୱା ପ୍ରେରକାନ୍ ତ୍ୱଯି କିଂ ୱକ୍ଷ୍ୟାମଃ? ସ୍ୱସ୍ମିନ୍ କିଂ ୱଦସି? ");
INSERT INTO sanori_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ତଦା ସୋୱଦତ୍| ପରମେଶସ୍ୟ ପନ୍ଥାନଂ ପରିଷ୍କୁରୁତ ସର୍ୱ୍ୱତଃ| ଇତୀଦଂ ପ୍ରାନ୍ତରେ ୱାକ୍ୟଂ ୱଦତଃ କସ୍ୟଚିଦ୍ରୱଃ| କଥାମିମାଂ ଯସ୍ମିନ୍ ଯିଶଯିଯୋ ଭୱିଷ୍ୟଦ୍ୱାଦୀ ଲିଖିତୱାନ୍ ସୋହମ୍| ");
INSERT INTO sanori_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ଯେ ପ୍ରେଷିତାସ୍ତେ ଫିରୂଶିଲୋକାଃ| ");
INSERT INTO sanori_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ତଦା ତେଽପୃଚ୍ଛନ୍ ଯଦି ନାଭିଷିକ୍ତୋସି ଏଲିଯୋସି ନ ସ ଭୱିଷ୍ୟଦ୍ୱାଦ୍ୟପି ନାସି ଚ, ତର୍ହି ଲୋକାନ୍ ମଜ୍ଜଯସି କୁତଃ? ");
INSERT INTO sanori_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ତତୋ ଯୋହନ୍ ପ୍ରତ୍ୟୱୋଚତ୍, ତୋଯେଽହଂ ମଜ୍ଜଯାମୀତି ସତ୍ୟଂ କିନ୍ତୁ ଯଂ ଯୂଯଂ ନ ଜାନୀଥ ତାଦୃଶ ଏକୋ ଜନୋ ଯୁଷ୍ମାକଂ ମଧ୍ୟ ଉପତିଷ୍ଠତି| ");
INSERT INTO sanori_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ସ ମତ୍ପଶ୍ଚାଦ୍ ଆଗତୋପି ମତ୍ପୂର୍ୱ୍ୱଂ ୱର୍ତ୍ତମାନ ଆସୀତ୍ ତସ୍ୟ ପାଦୁକାବନ୍ଧନଂ ମୋଚଯିତୁମପି ନାହଂ ଯୋଗ୍ୟୋସ୍ମି| ");
INSERT INTO sanori_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ଯର୍ଦ୍ଦନନଦ୍ୟାଃ ପାରସ୍ଥବୈଥବାରାଯାଂ ଯସ୍ମିନ୍ସ୍ଥାନେ ଯୋହନମଜ୍ଜଯତ୍ ତସ୍ମିନ ସ୍ଥାନେ ସର୍ୱ୍ୱମେତଦ୍ ଅଘଟତ| ");
INSERT INTO sanori_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","ପରେଽହନି ଯୋହନ୍ ସ୍ୱନିକଟମାଗଚ୍ଛନ୍ତଂ ଯିଶୁଂ ୱିଲୋକ୍ୟ ପ୍ରାୱୋଚତ୍ ଜଗତଃ ପାପମୋଚକମ୍ ଈଶ୍ୱରସ୍ୟ ମେଷଶାୱକଂ ପଶ୍ୟତ| ");
INSERT INTO sanori_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","ଯୋ ମମ ପଶ୍ଚାଦାଗମିଷ୍ୟତି ସ ମତ୍ତୋ ଗୁରୁତରଃ, ଯତୋ ହେତୋର୍ମତ୍ପୂର୍ୱ୍ୱଂ ସୋଽୱର୍ତ୍ତତ ଯସ୍ମିନ୍ନହଂ କଥାମିମାଂ କଥିତୱାନ୍ ସ ଏୱାଯଂ| ");
INSERT INTO sanori_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","ଅପରଂ ନାହମେନଂ ପ୍ରତ୍ୟଭିଜ୍ଞାତୱାନ୍ କିନ୍ତୁ ଇସ୍ରାଯେଲ୍ଲୋକା ଏନଂ ଯଥା ପରିଚିନ୍ୱନ୍ତି ତଦଭିପ୍ରାଯେଣାହଂ ଜଲେ ମଜ୍ଜଯିତୁମାଗଚ୍ଛମ୍| ");
INSERT INTO sanori_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","ପୁନଶ୍ଚ ଯୋହନପରମେକଂ ପ୍ରମାଣଂ ଦତ୍ୱା କଥିତୱାନ୍ ୱିହାଯସଃ କପୋତୱଦ୍ ଅୱତରନ୍ତମାତ୍ମାନମ୍ ଅସ୍ୟୋପର୍ୟ୍ୟୱତିଷ୍ଠନ୍ତଂ ଚ ଦୃଷ୍ଟୱାନହମ୍| ");
INSERT INTO sanori_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","ନାହମେନଂ ପ୍ରତ୍ୟଭିଜ୍ଞାତୱାନ୍ ଇତି ସତ୍ୟଂ କିନ୍ତୁ ଯୋ ଜଲେ ମଜ୍ଜଯିତୁଂ ମାଂ ପ୍ରୈରଯତ୍ ସ ଏୱେମାଂ କଥାମକଥଯତ୍ ଯସ୍ୟୋପର୍ୟ୍ୟାତ୍ମାନମ୍ ଅୱତରନ୍ତମ୍ ଅୱତିଷ୍ଠନ୍ତଞ୍ଚ ଦ୍ରକ୍ଷଯସି ସଏୱ ପୱିତ୍ରେ ଆତ୍ମନି ମଜ୍ଜଯିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","ଅୱସ୍ତନ୍ନିରୀକ୍ଷ୍ୟାଯମ୍ ଈଶ୍ୱରସ୍ୟ ତନଯ ଇତି ପ୍ରମାଣଂ ଦଦାମି| ");
INSERT INTO sanori_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","ପରେଽହନି ଯୋହନ୍ ଦ୍ୱାଭ୍ୟାଂ ଶିଷ୍ୟାଭ୍ୟାଂ ସାର୍ଦ୍ଧେଂ ତିଷ୍ଠନ୍ ");
INSERT INTO sanori_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ଯିଶୁଂ ଗଚ୍ଛନ୍ତଂ ୱିଲୋକ୍ୟ ଗଦିତୱାନ୍, ଈଶ୍ୱରସ୍ୟ ମେଷଶାୱକଂ ପଶ୍ୟତଂ| ");
INSERT INTO sanori_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ଇମାଂ କଥାଂ ଶ୍ରୁତ୍ୱା ଦ୍ୱୌ ଶିଷ୍ୟୌ ଯୀଶୋଃ ପଶ୍ଚାଦ୍ ଈଯତୁଃ| ");
INSERT INTO sanori_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ତତୋ ଯୀଶୁଃ ପରାୱୃତ୍ୟ ତୌ ପଶ୍ଚାଦ୍ ଆଗଚ୍ଛନ୍ତୌ ଦୃଷ୍ଟ୍ୱା ପୃଷ୍ଟୱାନ୍ ଯୁୱାଂ କିଂ ଗୱେଶଯଥଃ? ତାୱପୃଚ୍ଛତାଂ ହେ ରବ୍ବି ଅର୍ଥାତ୍ ହେ ଗୁରୋ ଭୱାନ୍ କୁତ୍ର ତିଷ୍ଠତି? ");
INSERT INTO sanori_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ତତଃ ସୋୱାଦିତ୍ ଏତ୍ୟ ପଶ୍ୟତଂ| ତତୋ ଦିୱସସ୍ୟ ତୃତୀଯପ୍ରହରସ୍ୟ ଗତତ୍ୱାତ୍ ତୌ ତଦ୍ଦିନଂ ତସ୍ୟ ସଙ୍ଗେଽସ୍ଥାତାଂ| ");
INSERT INTO sanori_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ଯୌ ଦ୍ୱୌ ଯୋହନୋ ୱାକ୍ୟଂ ଶ୍ରୁତ୍ୱା ଯିଶୋଃ ପଶ୍ଚାଦ୍ ଆଗମତାଂ ତଯୋଃ ଶିମୋନ୍ପିତରସ୍ୟ ଭ୍ରାତା ଆନ୍ଦ୍ରିଯଃ ");
INSERT INTO sanori_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ସ ଇତ୍ୱା ପ୍ରଥମଂ ନିଜସୋଦରଂ ଶିମୋନଂ ସାକ୍ଷାତ୍ପ୍ରାପ୍ୟ କଥିତୱାନ୍ ୱଯଂ ଖ୍ରୀଷ୍ଟମ୍ ଅର୍ଥାତ୍ ଅଭିଷିକ୍ତପୁରୁଷଂ ସାକ୍ଷାତ୍କୃତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","ପଶ୍ଚାତ୍ ସ ତଂ ଯିଶୋଃ ସମୀପମ୍ ଆନଯତ୍| ତଦା ଯୀଶୁସ୍ତଂ ଦୃଷ୍ଟ୍ୱାୱଦତ୍ ତ୍ୱଂ ଯୂନସଃ ପୁତ୍ରଃ ଶିମୋନ୍ କିନ୍ତୁ ତ୍ୱନ୍ନାମଧେଯଂ କୈଫାଃ ୱା ପିତରଃ ଅର୍ଥାତ୍ ପ୍ରସ୍ତରୋ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","ପରେଽହନି ଯୀଶୌ ଗାଲୀଲଂ ଗନ୍ତୁଂ ନିଶ୍ଚିତଚେତସି ସତି ଫିଲିପନାମାନଂ ଜନଂ ସାକ୍ଷାତ୍ପ୍ରାପ୍ୟାୱୋଚତ୍ ମମ ପଶ୍ଚାଦ୍ ଆଗଚ୍ଛ| ");
INSERT INTO sanori_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ବୈତ୍ସୈଦାନାମ୍ନି ଯସ୍ମିନ୍ ଗ୍ରାମେ ପିତରାନ୍ଦ୍ରିଯଯୋର୍ୱାସ ଆସୀତ୍ ତସ୍ମିନ୍ ଗ୍ରାମେ ତସ୍ୟ ଫିଲିପସ୍ୟ ୱସତିରାସୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ପଶ୍ଚାତ୍ ଫିଲିପୋ ନିଥନେଲଂ ସାକ୍ଷାତ୍ପ୍ରାପ୍ୟାୱଦତ୍ ମୂସା ୱ୍ୟୱସ୍ଥା ଗ୍ରନ୍ଥେ ଭୱିଷ୍ୟଦ୍ୱାଦିନାଂ ଗ୍ରନ୍ଥେଷୁ ଚ ଯସ୍ୟାଖ୍ୟାନଂ ଲିଖିତମାସ୍ତେ ତଂ ଯୂଷଫଃ ପୁତ୍ରଂ ନାସରତୀଯଂ ଯୀଶୁଂ ସାକ୍ଷାଦ୍ ଅକାର୍ଷ୍ମ ୱଯଂ| ");
INSERT INTO sanori_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","ତଦା ନିଥନେଲ୍ କଥିତୱାନ୍ ନାସରନ୍ନଗରାତ କିଂ କଶ୍ଚିଦୁତ୍ତମ ଉତ୍ପନ୍ତୁଂ ଶକ୍ନୋତି? ତତଃ ଫିଲିପୋ ଽୱୋଚତ୍ ଏତ୍ୟ ପଶ୍ୟ| ");
INSERT INTO sanori_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ଅପରଞ୍ଚ ଯୀଶୁଃ ସ୍ୱସ୍ୟ ସମୀପଂ ତମ୍ ଆଗଚ୍ଛନ୍ତଂ ଦୃଷ୍ଟ୍ୱା ୱ୍ୟାହୃତୱାନ୍, ପଶ୍ୟାଯଂ ନିଷ୍କପଟଃ ସତ୍ୟ ଇସ୍ରାଯେଲ୍ଲୋକଃ| ");
INSERT INTO sanori_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","ତତଃ ସୋୱଦଦ୍, ଭୱାନ୍ ମାଂ କଥଂ ପ୍ରତ୍ୟଭିଜାନାତି? ଯୀଶୁରୱାଦୀତ୍ ଫିଲିପସ୍ୟ ଆହ୍ୱାନାତ୍ ପୂର୍ୱ୍ୱଂ ଯଦା ତ୍ୱମୁଡୁମ୍ବରସ୍ୟ ତରୋର୍ମୂଲେଽସ୍ଥାସ୍ତଦା ତ୍ୱାମଦର୍ଶମ୍| ");
INSERT INTO sanori_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","ନିଥନେଲ୍ ଅଚକଥତ୍, ହେ ଗୁରୋ ଭୱାନ୍ ନିତାନ୍ତମ୍ ଈଶ୍ୱରସ୍ୟ ପୁତ୍ରୋସି, ଭୱାନ୍ ଇସ୍ରାଯେଲ୍ୱଂଶସ୍ୟ ରାଜା| ");
INSERT INTO sanori_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ତତୋ ଯୀଶୁ ର୍ୱ୍ୟାହରତ୍, ତ୍ୱାମୁଡୁମ୍ବରସ୍ୟ ପାଦପସ୍ୟ ମୂଲେ ଦୃଷ୍ଟୱାନାହଂ ମମୈତସ୍ମାଦ୍ୱାକ୍ୟାତ୍ କିଂ ତ୍ୱଂ ୱ୍ୟଶ୍ୱସୀଃ? ଏତସ୍ମାଦପ୍ୟାଶ୍ଚର୍ୟ୍ୟାଣି କାର୍ୟ୍ୟାଣି ଦ୍ରକ୍ଷ୍ୟସି| ");
INSERT INTO sanori_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","ଅନ୍ୟଚ୍ଚାୱାଦୀଦ୍ ଯୁଷ୍ମାନହଂ ଯଥାର୍ଥଂ ୱଦାମି, ଇତଃ ପରଂ ମୋଚିତେ ମେଘଦ୍ୱାରେ ତସ୍ମାନ୍ମନୁଜସୂନୁନା ଈଶ୍ୱରସ୍ୟ ଦୂତଗଣମ୍ ଅୱରୋହନ୍ତମାରୋହନ୍ତଞ୍ଚ ଦ୍ରକ୍ଷ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","ଅନନ୍ତରଂ ତ୍ରୁତୀଯଦିୱସେ ଗାଲୀଲ୍ ପ୍ରଦେଶିଯେ କାନ୍ନାନାମ୍ନି ନଗରେ ୱିୱାହ ଆସୀତ୍ ତତ୍ର ଚ ଯୀଶୋର୍ମାତା ତିଷ୍ଠତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ତସ୍ମୈ ୱିୱାହାଯ ଯୀଶୁସ୍ତସ୍ୟ ଶିଷ୍ୟାଶ୍ଚ ନିମନ୍ତ୍ରିତା ଆସନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ତଦନନ୍ତରଂ ଦ୍ରାକ୍ଷାରସସ୍ୟ ନ୍ୟୂନତ୍ୱାଦ୍ ଯୀଶୋର୍ମାତା ତମୱଦତ୍ ଏତେଷାଂ ଦ୍ରାକ୍ଷାରସୋ ନାସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","ତଦା ସ ତାମୱୋଚତ୍ ହେ ନାରି ମଯା ସହ ତୱ କିଂ କାର୍ୟ୍ୟଂ? ମମ ସମଯ ଇଦାନୀଂ ନୋପତିଷ୍ଠତି| ");
INSERT INTO sanori_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ତତସ୍ତସ୍ୟ ମାତା ଦାସାନୱୋଚଦ୍ ଅଯଂ ଯଦ୍ ୱଦତି ତଦେୱ କୁରୁତ| ");
INSERT INTO sanori_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ତସ୍ମିନ୍ ସ୍ଥାନେ ଯିହୂଦୀଯାନାଂ ଶୁଚିତ୍ୱକରଣୱ୍ୟୱହାରାନୁସାରେଣାଢକୈକଜଲଧରାଣି ପାଷାଣମଯାନି ଷଡ୍ୱୃହତ୍ପାତ୍ରାଣିଆସନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ତଦା ଯୀଶୁସ୍ତାନ୍ ସର୍ୱ୍ୱକଲଶାନ୍ ଜଲୈଃ ପୂରଯିତୁଂ ତାନାଜ୍ଞାପଯତ୍, ତତସ୍ତେ ସର୍ୱ୍ୱାନ୍ କୁମ୍ଭାନାକର୍ଣଂ ଜଲୈଃ ପର୍ୟ୍ୟପୂରଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ଅଥ ତେଭ୍ୟଃ କିଞ୍ଚିଦୁତ୍ତାର୍ୟ୍ୟ ଭୋଜ୍ୟାଧିପାତେଃସମୀପଂ ନେତୁଂ ସ ତାନାଦିଶତ୍, ତେ ତଦନଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ଅପରଞ୍ଚ ତଜ୍ଜଲଂ କଥଂ ଦ୍ରାକ୍ଷାରସୋଽଭୱତ୍ ତଜ୍ଜଲୱାହକାଦାସା ଜ୍ଞାତୁଂ ଶକ୍ତାଃ କିନ୍ତୁ ତଦ୍ଭୋଜ୍ୟାଧିପୋ ଜ୍ଞାତୁଂ ନାଶକ୍ନୋତ୍ ତଦୱଲିହ୍ୟ ୱରଂ ସଂମ୍ବୋଦ୍ୟାୱଦତ, ");
INSERT INTO sanori_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ଲୋକାଃ ପ୍ରଥମଂ ଉତ୍ତମଦ୍ରାକ୍ଷାରସଂ ଦଦତି ତଷୁ ଯଥେଷ୍ଟଂ ପିତୱତ୍ସୁ ତସ୍ମା କିଞ୍ଚିଦନୁତ୍ତମଞ୍ଚ ଦଦତି କିନ୍ତୁ ତ୍ୱମିଦାନୀଂ ଯାୱତ୍ ଉତ୍ତମଦ୍ରାକ୍ଷାରସଂ ସ୍ଥାପଯସି| ");
INSERT INTO sanori_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ଇତ୍ଥଂ ଯୀଶୁର୍ଗାଲୀଲପ୍ରଦେଶେ ଆଶ୍ଚର୍ୟ୍ୟକାର୍ମ୍ମ ପ୍ରାରମ୍ଭ ନିଜମହିମାନଂ ପ୍ରାକାଶଯତ୍ ତତଃ ଶିଷ୍ୟାସ୍ତସ୍ମିନ୍ ୱ୍ୟଶ୍ୱସନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ତତଃ ପରମ୍ ସ ନିଜମାତ୍ରୁଭ୍ରାତ୍ରୁସ୍ଶିଷ୍ୟୈଃ ସାର୍ଦ୍ଧ୍ଂ କଫର୍ନାହୂମମ୍ ଆଗମତ୍ କିନ୍ତୁ ତତ୍ର ବହୂଦିନାନି ଆତିଷ୍ଠତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","ତଦନନ୍ତରଂ ଯିହୂଦିଯାନାଂ ନିସ୍ତାରୋତ୍ସୱେ ନିକଟମାଗତେ ଯୀଶୁ ର୍ୟିରୂଶାଲମ୍ ନଗରମ୍ ଆଗଚ୍ଛତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ତତୋ ମନ୍ଦିରସ୍ୟ ମଧ୍ୟେ ଗୋମେଷପାରାୱତୱିକ୍ରଯିଣୋ ୱାଣିଜକ୍ଷ୍ଚୋପୱିଷ୍ଟାନ୍ ୱିଲୋକ୍ୟ ");
INSERT INTO sanori_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ରଜ୍ଜୁଭିଃ କଶାଂ ନିର୍ମ୍ମାଯ ସର୍ୱ୍ୱଗୋମେଷାଦିଭିଃ ସାର୍ଦ୍ଧଂ ତାନ୍ ମନ୍ଦିରାଦ୍ ଦୂରୀକୃତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ୱଣିଜାଂ ମୁଦ୍ରାଦି ୱିକୀର୍ୟ୍ୟ ଆସନାନି ନ୍ୟୂବ୍ଜୀକୃତ୍ୟ ପାରାୱତୱିକ୍ରଯିଭ୍ୟୋଽକଥଯଦ୍ ଅସ୍ମାତ୍ ସ୍ଥାନାତ୍ ସର୍ୱାଣ୍ୟେତାନି ନଯତ, ମମ ପିତୁଗୃହଂ ୱାଣିଜ୍ୟଗୃହଂ ମା କାର୍ଷ୍ଟ| ");
INSERT INTO sanori_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","ତସ୍ମାତ୍ ତନ୍ମନ୍ଦିରାର୍ଥ ଉଦ୍ୟୋଗୋ ଯସ୍ତୁ ସ ଗ୍ରସତୀୱ ମାମ୍| ଇମାଂ ଶାସ୍ତ୍ରୀଯଲିପିଂ ଶିଷ୍ୟାଃସମସ୍ମରନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ତତଃ ପରମ୍ ଯିହୂଦୀଯଲୋକା ଯୀଷିମୱଦନ୍ ତୱମିଦୃଶକର୍ମ୍ମକରଣାତ୍ କିଂ ଚିହ୍ନମସ୍ମାନ୍ ଦର୍ଶଯସି? ");
INSERT INTO sanori_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ତତୋ ଯୀଶୁସ୍ତାନୱୋଚଦ୍ ଯୁଷ୍ମାଭିରେ ତସ୍ମିନ୍ ମନ୍ଦିରେ ନାଶିତେ ଦିନତ୍ରଯମଧ୍ୟେଽହଂ ତଦ୍ ଉତ୍ଥାପଯିଷ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","ତଦା ଯିହୂଦିଯା ୱ୍ୟାହାର୍ଷୁଃ, ଏତସ୍ୟ ମନ୍ଦିରସ ନିର୍ମ୍ମାଣେନ ଷଟ୍ଚତ୍ୱାରିଂଶଦ୍ ୱତ୍ସରା ଗତାଃ, ତ୍ୱଂ କିଂ ଦିନତ୍ରଯମଧ୍ୟେ ତଦ୍ ଉତ୍ଥାପଯିଷ୍ୟସି? ");
INSERT INTO sanori_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","କିନ୍ତୁ ସ ନିଜଦେହରୂପମନ୍ଦିରେ କଥାମିମାଂ କଥିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ସ ଯଦେତାଦୃଶଂ ଗଦିତୱାନ୍ ତଚ୍ଛିଷ୍ୟାଃ ଶ୍ମଶାନାତ୍ ତଦୀଯୋତ୍ଥାନେ ସତି ସ୍ମୃତ୍ୱା ଧର୍ମ୍ମଗ୍ରନ୍ଥେ ଯୀଶୁନୋକ୍ତକଥାଯାଂ ଚ ୱ୍ୟଶ୍ୱସିଷୁଃ| ");
INSERT INTO sanori_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","ଅନନ୍ତରଂ ନିସ୍ତାରୋତ୍ସୱସ୍ୟ ଭୋଜ୍ୟସମଯେ ଯିରୂଶାଲମ୍ ନଗରେ ତତ୍କ୍ରୁତାଶ୍ଚର୍ୟ୍ୟକର୍ମ୍ମାଣି ୱିଲୋକ୍ୟ ବହୁଭିସ୍ତସ୍ୟ ନାମନି ୱିଶ୍ୱସିତଂ| ");
INSERT INTO sanori_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","କିନ୍ତୁ ସ ତେଷାଂ କରେଷୁ ସ୍ୱଂ ନ ସମର୍ପଯତ୍, ଯତଃ ସ ସର୍ୱ୍ୱାନୱୈତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ସ ମାନୱେଷୁ କସ୍ୟଚିତ୍ ପ୍ରମାଣଂ ନାପେକ୍ଷତ ଯତୋ ମନୁଜାନାଂ ମଧ୍ୟେ ଯଦ୍ୟଦସ୍ତି ତତ୍ତତ୍ ସୋଜାନାତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","ନିକଦିମନାମା ଯିହୂଦୀଯାନାମ୍ ଅଧିପତିଃ ଫିରୂଶୀ କ୍ଷଣଦାଯାଂ ");
INSERT INTO sanori_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ଯୀଶୌରଭ୍ୟର୍ଣମ୍ ଆୱ୍ରଜ୍ୟ ୱ୍ୟାହାର୍ଷୀତ୍, ହେ ଗୁରୋ ଭୱାନ୍ ଈଶ୍ୱରାଦ୍ ଆଗତ୍ ଏକ ଉପଦେଷ୍ଟା, ଏତଦ୍ ଅସ୍ମାଭିର୍ଜ୍ଞାଯତେ; ଯତୋ ଭୱତା ଯାନ୍ୟାଶ୍ଚର୍ୟ୍ୟକର୍ମ୍ମାଣି କ୍ରିଯନ୍ତେ ପରମେଶ୍ୱରସ୍ୟ ସାହାଯ୍ୟଂ ୱିନା କେନାପି ତତ୍ତତ୍କର୍ମ୍ମାଣି କର୍ତ୍ତୁଂ ନ ଶକ୍ୟନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","ତଦା ଯୀଶୁରୁତ୍ତରଂ ଦତ୍ତୱାନ୍ ତୱାହଂ ଯଥାର୍ଥତରଂ ୱ୍ୟାହରାମି ପୁନର୍ଜନ୍ମନି ନ ସତି କୋପି ମାନୱ ଈଶ୍ୱରସ୍ୟ ରାଜ୍ୟଂ ଦ୍ରଷ୍ଟୁଂ ନ ଶକ୍ନୋତି| ");
INSERT INTO sanori_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ତତୋ ନିକଦୀମଃ ପ୍ରତ୍ୟୱୋଚତ୍ ମନୁଜୋ ୱୃଦ୍ଧୋ ଭୂତ୍ୱା କଥଂ ଜନିଷ୍ୟତେ? ସ କିଂ ପୁନ ର୍ମାତୃର୍ଜଠରଂ ପ୍ରୱିଶ୍ୟ ଜନିତୁଂ ଶକ୍ନୋତି? ");
INSERT INTO sanori_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","ଯୀଶୁରୱାଦୀଦ୍ ଯଥାର୍ଥତରମ୍ ଅହଂ କଥଯାମି ମନୁଜେ ତୋଯାତ୍ମଭ୍ୟାଂ ପୁନ ର୍ନ ଜାତେ ସ ଈଶ୍ୱରସ୍ୟ ରାଜ୍ୟଂ ପ୍ରୱେଷ୍ଟୁଂ ନ ଶକ୍ନୋତି| ");
INSERT INTO sanori_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","ମାଂସାଦ୍ ଯତ୍ ଜାଯତେ ତନ୍ ମାଂସମେୱ ତଥାତ୍ମନୋ ଯୋ ଜାଯତେ ସ ଆତ୍ମୈୱ| ");
INSERT INTO sanori_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","ଯୁଷ୍ମାଭିଃ ପୁନ ର୍ଜନିତୱ୍ୟଂ ମମୈତସ୍ୟାଂ କଥାଯାମ୍ ଆଶ୍ଚର୍ୟଂ ମା ମଂସ୍ଥାଃ| ");
INSERT INTO sanori_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","ସଦାଗତିର୍ୟାଂ ଦିଶମିଚ୍ଛତି ତସ୍ୟାମେୱ ଦିଶି ୱାତି, ତ୍ୱଂ ତସ୍ୟ ସ୍ୱନଂ ଶୁଣୋଷି କିନ୍ତୁ ସ କୁତ ଆଯାତି କୁତ୍ର ଯାତି ୱା କିମପି ନ ଜାନାସି ତଦ୍ୱାଦ୍ ଆତ୍ମନଃ ସକାଶାତ୍ ସର୍ୱ୍ୱେଷାଂ ମନୁଜାନାଂ ଜନ୍ମ ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","ତଦା ନିକଦୀମଃ ପୃଷ୍ଟୱାନ୍ ଏତତ୍ କଥଂ ଭୱିତୁଂ ଶକ୍ନୋତି? ");
INSERT INTO sanori_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","ଯୀଶୁଃ ପ୍ରତ୍ୟକ୍ତୱାନ୍ ତ୍ୱମିସ୍ରାଯେଲୋ ଗୁରୁର୍ଭୂତ୍ୱାପି କିମେତାଂ କଥାଂ ନ ୱେତ୍ସି? ");
INSERT INTO sanori_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","ତୁଭ୍ୟଂ ଯଥାର୍ଥଂ କଥଯାମି, ୱଯଂ ଯଦ୍ ୱିଦ୍ମସ୍ତଦ୍ ୱଚ୍ମଃ ଯଂଚ୍ଚ ପଶ୍ୟାମସ୍ତସ୍ୟୈୱ ସାକ୍ଷ୍ୟଂ ଦଦ୍ମଃ କିନ୍ତୁ ଯୁଷ୍ମାଭିରସ୍ମାକଂ ସାକ୍ଷିତ୍ୱଂ ନ ଗୃହ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ଏତସ୍ୟ ସଂସାରସ୍ୟ କଥାଯାଂ କଥିତାଯାଂ ଯଦି ଯୂଯଂ ନ ୱିଶ୍ୱସିଥ ତର୍ହି ସ୍ୱର୍ଗୀଯାଯାଂ କଥାଯାଂ କଥଂ ୱିଶ୍ୱସିଷ୍ୟଥ? ");
INSERT INTO sanori_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ଯଃ ସ୍ୱର୍ଗେଽସ୍ତି ଯଂ ଚ ସ୍ୱର୍ଗାଦ୍ ଅୱାରୋହତ୍ ତଂ ମାନୱତନଯଂ ୱିନା କୋପି ସ୍ୱର୍ଗଂ ନାରୋହତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","ଅପରଞ୍ଚ ମୂସା ଯଥା ପ୍ରାନ୍ତରେ ସର୍ପଂ ପ୍ରୋତ୍ଥାପିତୱାନ୍ ମନୁଷ୍ୟପୁତ୍ରୋଽପି ତଥୈୱୋତ୍ଥାପିତୱ୍ୟଃ; ");
INSERT INTO sanori_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ତସ୍ମାଦ୍ ଯଃ କଶ୍ଚିତ୍ ତସ୍ମିନ୍ ୱିଶ୍ୱସିଷ୍ୟତି ସୋଽୱିନାଶ୍ୟଃ ସନ୍ ଅନନ୍ତାଯୁଃ ପ୍ରାପ୍ସ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ଈଶ୍ୱର ଇତ୍ଥଂ ଜଗଦଦଯତ ଯତ୍ ସ୍ୱମଦ୍ୱିତୀଯଂ ତନଯଂ ପ୍ରାଦଦାତ୍ ତତୋ ଯଃ କଶ୍ଚିତ୍ ତସ୍ମିନ୍ ୱିଶ୍ୱସିଷ୍ୟତି ସୋଽୱିନାଶ୍ୟଃ ସନ୍ ଅନନ୍ତାଯୁଃ ପ୍ରାପ୍ସ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ଈଶ୍ୱରୋ ଜଗତୋ ଲୋକାନ୍ ଦଣ୍ଡଯିତୁଂ ସ୍ୱପୁତ୍ରଂ ନ ପ୍ରେଷ୍ୟ ତାନ୍ ପରିତ୍ରାତୁଂ ପ୍ରେଷିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ଅତଏୱ ଯଃ କଶ୍ଚିତ୍ ତସ୍ମିନ୍ ୱିଶ୍ୱସିତି ସ ଦଣ୍ଡାର୍ହୋ ନ ଭୱତି କିନ୍ତୁ ଯଃ କଶ୍ଚିତ୍ ତସ୍ମିନ୍ ନ ୱିଶ୍ୱସିତି ସ ଇଦାନୀମେୱ ଦଣ୍ଡାର୍ହୋ ଭୱତି,ଯତଃ ସ ଈଶ୍ୱରସ୍ୟାଦ୍ୱିତୀଯପୁତ୍ରସ୍ୟ ନାମନି ପ୍ରତ୍ୟଯଂ ନ କରୋତି| ");
INSERT INTO sanori_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","ଜଗତୋ ମଧ୍ୟେ ଜ୍ୟୋତିଃ ପ୍ରାକାଶତ କିନ୍ତୁ ମନୁଷ୍ୟାଣାଂ କର୍ମ୍ମଣାଂ ଦୃଷ୍ଟତ୍ୱାତ୍ ତେ ଜ୍ୟୋତିଷୋପି ତିମିରେ ପ୍ରୀଯନ୍ତେ ଏତଦେୱ ଦଣ୍ଡସ୍ୟ କାରଣାଂ ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ଯଃ କୁକର୍ମ୍ମ କରୋତି ତସ୍ୟାଚାରସ୍ୟ ଦୃଷ୍ଟତ୍ୱାତ୍ ସ ଜ୍ୟୋତିରୄତୀଯିତ୍ୱା ତନ୍ନିକଟଂ ନାଯାତି; ");
INSERT INTO sanori_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","କିନ୍ତୁ ଯଃ ସତ୍କର୍ମ୍ମ କରୋତି ତସ୍ୟ ସର୍ୱ୍ୱାଣି କର୍ମ୍ମାଣୀଶ୍ୱରେଣ କୃତାନୀତି ସଥା ପ୍ରକାଶତେ ତଦଭିପ୍ରାଯେଣ ସ ଜ୍ୟୋତିଷଃ ସନ୍ନିଧିମ୍ ଆଯାତି| ");
INSERT INTO sanori_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ତତଃ ପରମ୍ ଯୀଶୁଃ ଶିଷ୍ୟୈଃ ସାର୍ଦ୍ଧଂ ଯିହୂଦୀଯଦେଶଂ ଗତ୍ୱା ତତ୍ର ସ୍ଥିତ୍ୱା ମଜ୍ଜଯିତୁମ୍ ଆରଭତ| ");
INSERT INTO sanori_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","ତଦା ଶାଲମ୍ ନଗରସ୍ୟ ସମୀପସ୍ଥାଯିନି ଐନନ୍ ଗ୍ରାମେ ବହୁତରତୋଯସ୍ଥିତେସ୍ତତ୍ର ଯୋହନ୍ ଅମଜ୍ଜଯତ୍ ତଥା ଚ ଲୋକା ଆଗତ୍ୟ ତେନ ମଜ୍ଜିତା ଅଭୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ତଦା ଯୋହନ୍ କାରାଯାଂ ନ ବଦ୍ଧଃ| ");
INSERT INTO sanori_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","ଅପରଞ୍ଚ ଶାଚକର୍ମ୍ମଣି ଯୋହାନଃ ଶିଷ୍ୟୈଃ ସହ ଯିହୂଦୀଯଲୋକାନାଂ ୱିୱାଦେ ଜାତେ, ତେ ଯୋହନଃ ସଂନ୍ନିଧିଂ ଗତ୍ୱାକଥଯନ୍, ");
INSERT INTO sanori_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ହେ ଗୁରୋ ଯର୍ଦ୍ଦନନଦ୍ୟାଃ ପାରେ ଭୱତା ସାର୍ଦ୍ଧଂ ଯ ଆସୀତ୍ ଯସ୍ମିଂଶ୍ଚ ଭୱାନ୍ ସାକ୍ଷ୍ୟଂ ପ୍ରଦଦାତ୍ ପଶ୍ୟତୁ ସୋପି ମଜ୍ଜଯତି ସର୍ୱ୍ୱେ ତସ୍ୟ ସମୀପଂ ଯାନ୍ତି ଚ| ");
INSERT INTO sanori_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ତଦା ଯୋହନ୍ ପ୍ରତ୍ୟୱୋଚଦ୍ ଈଶ୍ୱରେଣ ନ ଦତ୍ତେ କୋପି ମନୁଜଃ କିମପି ପ୍ରାପ୍ତୁଂ ନ ଶକ୍ନୋତି| ");
INSERT INTO sanori_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","ଅହଂ ଅଭିଷିକ୍ତୋ ନ ଭୱାମି କିନ୍ତୁ ତଦଗ୍ରେ ପ୍ରେଷିତୋସ୍ମି ଯାମିମାଂ କଥାଂ କଥିତୱାନାହଂ ତତ୍ର ଯୂଯଂ ସର୍ୱ୍ୱେ ସାକ୍ଷିଣଃ ସ୍ଥ| ");
INSERT INTO sanori_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","ଯୋ ଜନଃ କନ୍ୟାଂ ଲଭତେ ସ ଏୱ ୱରଃ କିନ୍ତୁ ୱରସ୍ୟ ସନ୍ନିଧୌ ଦଣ୍ଡାଯମାନଂ ତସ୍ୟ ଯନ୍ମିତ୍ରଂ ତେନ ୱରସ୍ୟ ଶବ୍ଦେ ଶ୍ରୁତେଽତୀୱାହ୍ଲାଦ୍ୟତେ ମମାପି ତଦ୍ୱଦ୍ ଆନନ୍ଦସିଦ୍ଧିର୍ଜାତା| ");
INSERT INTO sanori_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ତେନ କ୍ରମଶୋ ୱର୍ଦ୍ଧିତୱ୍ୟଂ କିନ୍ତୁ ମଯା ହ୍ସିତୱ୍ୟଂ| ");
INSERT INTO sanori_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ଯ ଊର୍ଧ୍ୱାଦାଗଚ୍ଛତ୍ ସ ସର୍ୱ୍ୱେଷାଂ ମୁଖ୍ୟୋ ଯଶ୍ଚ ସଂସାରାଦ୍ ଉଦପଦ୍ୟତ ସ ସାଂସାରିକଃ ସଂସାରୀଯାଂ କଥାଞ୍ଚ କଥଯତି ଯସ୍ତୁ ସ୍ୱର୍ଗାଦାଗଚ୍ଛତ୍ ସ ସର୍ୱ୍ୱେଷାଂ ମୁଖ୍ୟଃ| ");
INSERT INTO sanori_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ସ ଯଦପଶ୍ୟଦଶୃଣୋଚ୍ଚ ତସ୍ମିନ୍ନେୱ ସାକ୍ଷ୍ୟଂ ଦଦାତି ତଥାପି ପ୍ରାଯଶଃ କଶ୍ଚିତ୍ ତସ୍ୟ ସାକ୍ଷ୍ୟଂ ନ ଗୃହ୍ଲାତି; ");
INSERT INTO sanori_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","କିନ୍ତୁ ଯୋ ଗୃହ୍ଲାତି ସ ଈଶ୍ୱରସ୍ୟ ସତ୍ୟୱାଦିତ୍ୱଂ ମୁଦ୍ରାଙ୍ଗିତଂ କରୋତି| ");
INSERT INTO sanori_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ଈଶ୍ୱରେଣ ଯଃ ପ୍ରେରିତଃ ସଏୱ ଈଶ୍ୱରୀଯକଥାଂ କଥଯତି ଯତ ଈଶ୍ୱର ଆତ୍ମାନଂ ତସ୍ମୈ ଅପରିମିତମ୍ ଅଦଦାତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","ପିତା ପୁତ୍ରେ ସ୍ନେହଂ କୃତ୍ୱା ତସ୍ୟ ହସ୍ତେ ସର୍ୱ୍ୱାଣି ସମର୍ପିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ଯଃ କଶ୍ଚିତ୍ ପୁତ୍ରେ ୱିଶ୍ୱସିତି ସ ଏୱାନନ୍ତମ୍ ପରମାଯୁଃ ପ୍ରାପ୍ନୋତି କିନ୍ତୁ ଯଃ କଶ୍ଚିତ୍ ପୁତ୍ରେ ନ ୱିଶ୍ୱସିତି ସ ପରମାଯୁଷୋ ଦର୍ଶନଂ ନ ପ୍ରାପ୍ନୋତି କିନ୍ତ୍ୱୀଶ୍ୱରସ୍ୟ କୋପଭାଜନଂ ଭୂତ୍ୱା ତିଷ୍ଠତି| ");
INSERT INTO sanori_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","ଯୀଶୁଃ ସ୍ୱଯଂ ନାମଜ୍ଜଯତ୍ କେୱଲଂ ତସ୍ୟ ଶିଷ୍ୟା ଅମଜ୍ଜଯତ୍ କିନ୍ତୁ ଯୋହନୋଽଧିକଶିଷ୍ୟାନ୍ ସ କରୋତି ମଜ୍ଜଯତି ଚ, ");
INSERT INTO sanori_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ଫିରୂଶିନ ଇମାଂ ୱାର୍ତ୍ତାମଶୃଣ୍ୱନ୍ ଇତି ପ୍ରଭୁରୱଗତ୍ୟ ");
INSERT INTO sanori_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ଯିହୂଦୀଯଦେଶଂ ୱିହାଯ ପୁନ ର୍ଗାଲୀଲମ୍ ଆଗତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ତତଃ ଶୋମିରୋଣପ୍ରଦେଶସ୍ୟ ମଦ୍ୟେନ ତେନ ଗନ୍ତୱ୍ୟେ ସତି ");
INSERT INTO sanori_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ଯାକୂବ୍ ନିଜପୁତ୍ରାଯ ଯୂଷଫେ ଯାଂ ଭୂମିମ୍ ଅଦଦାତ୍ ତତ୍ସମୀପସ୍ଥାଯି ଶୋମିରୋଣପ୍ରଦେଶସ୍ୟ ସୁଖାର୍ ନାମ୍ନା ୱିଖ୍ୟାତସ୍ୟ ନଗରସ୍ୟ ସନ୍ନିଧାୱୁପାସ୍ଥାତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ତତ୍ର ଯାକୂବଃ ପ୍ରହିରାସୀତ୍; ତଦା ଦ୍ୱିତୀଯଯାମୱେଲାଯାଂ ଜାତାଯାଂ ସ ମାର୍ଗେ ଶ୍ରମାପନ୍ନସ୍ତସ୍ୟ ପ୍ରହେଃ ପାର୍ଶ୍ୱେ ଉପାୱିଶତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ଏତର୍ହି କାଚିତ୍ ଶୋମିରୋଣୀଯା ଯୋଷିତ୍ ତୋଯୋତ୍ତୋଲନାର୍ଥମ୍ ତତ୍ରାଗମତ୍ ");
INSERT INTO sanori_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","ତଦା ଶିଷ୍ୟାଃ ଖାଦ୍ୟଦ୍ରୱ୍ୟାଣି କ୍ରେତୁଂ ନଗରମ୍ ଅଗଚ୍ଛନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","ଯୀଶୁଃ ଶୋମିରୋଣୀଯାଂ ତାଂ ଯୋଷିତମ୍ ୱ୍ୟାହାର୍ଷୀତ୍ ମହ୍ୟଂ କିଞ୍ଚିତ୍ ପାନୀଯଂ ପାତୁଂ ଦେହି| କିନ୍ତୁ ଶୋମିରୋଣୀଯୈଃ ସାକଂ ଯିହୂଦୀଯଲୋକା ନ ୱ୍ୟୱାହରନ୍ ତସ୍ମାଦ୍ଧେତୋଃ ସାକଥଯତ୍ ଶୋମିରୋଣୀଯା ଯୋଷିତଦହଂ ତ୍ୱଂ ଯିହୂଦୀଯୋସି କଥଂ ମତ୍ତଃ ପାନୀଯଂ ପାତୁମ୍ ଇଚ୍ଛସି? ");
INSERT INTO sanori_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ତତୋ ଯୀଶୁରୱଦଦ୍ ଈଶ୍ୱରସ୍ୟ ଯଦ୍ଦାନଂ ତତ୍କୀଦୃକ୍ ପାନୀଯଂ ପାତୁଂ ମହ୍ୟଂ ଦେହି ଯ ଇତ୍ଥଂ ତ୍ୱାଂ ଯାଚତେ ସ ୱା କ ଇତି ଚେଦଜ୍ଞାସ୍ୟଥାସ୍ତର୍ହି ତମଯାଚିଷ୍ୟଥାଃ ସ ଚ ତୁଭ୍ୟମମୃତଂ ତୋଯମଦାସ୍ୟତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","ତଦା ସା ସୀମନ୍ତିନୀ ଭାଷିତୱତି, ହେ ମହେଚ୍ଛ ପ୍ରହିର୍ଗମ୍ଭୀରୋ ଭୱତୋ ନୀରୋତ୍ତୋଲନପାତ୍ରଂ ନାସ୍ତୀ ଚ ତସ୍ମାତ୍ ତଦମୃତଂ କୀଲାଲଂ କୁତଃ ପ୍ରାପ୍ସ୍ୟସି? ");
INSERT INTO sanori_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","ଯୋସ୍ମଭ୍ୟମ୍ ଇମମନ୍ଧୂଂ ଦଦୌ, ଯସ୍ୟ ଚ ପରିଜନା ଗୋମେଷାଦଯଶ୍ଚ ସର୍ୱ୍ୱେଽସ୍ୟ ପ୍ରହେଃ ପାନୀଯଂ ପପୁରେତାଦୃଶୋ ଯୋସ୍ମାକଂ ପୂର୍ୱ୍ୱପୁରୁଷୋ ଯାକୂବ୍ ତସ୍ମାଦପି ଭୱାନ୍ ମହାନ୍ କିଂ? ");
INSERT INTO sanori_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ତତୋ ଯୀଶୁରକଥଯଦ୍ ଇଦଂ ପାନୀଯଂ ସଃ ପିୱତି ସ ପୁନସ୍ତୃଷାର୍ତ୍ତୋ ଭୱିଷ୍ୟତି, ");
INSERT INTO sanori_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","କିନ୍ତୁ ମଯା ଦତ୍ତଂ ପାନୀଯଂ ଯଃ ପିୱତି ସ ପୁନଃ କଦାପି ତୃଷାର୍ତ୍ତୋ ନ ଭୱିଷ୍ୟତି| ମଯା ଦତ୍ତମ୍ ଇଦଂ ତୋଯଂ ତସ୍ୟାନ୍ତଃ ପ୍ରସ୍ରୱଣରୂପଂ ଭୂତ୍ୱା ଅନନ୍ତାଯୁର୍ୟାୱତ୍ ସ୍ରୋଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","ତଦା ସା ୱନିତାକଥଯତ୍ ହେ ମହେଚ୍ଛ ତର୍ହି ମମ ପୁନଃ ପୀପାସା ଯଥା ନ ଜାଯତେ ତୋଯୋତ୍ତୋଲନାଯ ଯଥାତ୍ରାଗମନଂ ନ ଭୱତି ଚ ତଦର୍ଥଂ ମହ୍ୟଂ ତତ୍ତୋଯଂ ଦେହୀ| ");
INSERT INTO sanori_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ତତୋ ଯୀଶୂରୱଦଦ୍ୟାହି ତୱ ପତିମାହୂଯ ସ୍ଥାନେଽତ୍ରାଗଚ୍ଛ| ");
INSERT INTO sanori_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","ସା ୱାମାୱଦତ୍ ମମ ପତିର୍ନାସ୍ତି| ଯୀଶୁରୱଦତ୍ ମମ ପତିର୍ନାସ୍ତୀତି ୱାକ୍ୟଂ ଭଦ୍ରମୱୋଚଃ| ");
INSERT INTO sanori_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ଯତସ୍ତୱ ପଞ୍ଚ ପତଯୋଭୱନ୍ ଅଧୁନା ତୁ ତ୍ୱଯା ସାର୍ଦ୍ଧଂ ଯସ୍ତିଷ୍ଠତି ସ ତୱ ଭର୍ତ୍ତା ନ ୱାକ୍ୟମିଦଂ ସତ୍ୟମୱାଦିଃ| ");
INSERT INTO sanori_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","ତଦା ସା ମହିଲା ଗଦିତୱତି ହେ ମହେଚ୍ଛ ଭୱାନ୍ ଏକୋ ଭୱିଷ୍ୟଦ୍ୱାଦୀତି ବୁଦ୍ଧଂ ମଯା| ");
INSERT INTO sanori_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","ଅସ୍ମାକଂ ପିତୃଲୋକା ଏତସ୍ମିନ୍ ଶିଲୋଚ୍ଚଯେଽଭଜନ୍ତ, କିନ୍ତୁ ଭୱଦ୍ଭିରୁଚ୍ୟତେ ଯିରୂଶାଲମ୍ ନଗରେ ଭଜନଯୋଗ୍ୟଂ ସ୍ଥାନମାସ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","ଯୀଶୁରୱୋଚତ୍ ହେ ଯୋଷିତ୍ ମମ ୱାକ୍ୟେ ୱିଶ୍ୱସିହି ଯଦା ଯୂଯଂ କେୱଲଶୈଲେଽସ୍ମିନ୍ ୱା ଯିରୂଶାଲମ୍ ନଗରେ ପିତୁର୍ଭଜନଂ ନ କରିଷ୍ୟଧ୍ୱେ କାଲ ଏତାଦୃଶ ଆଯାତି| ");
INSERT INTO sanori_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ଯୂଯଂ ଯଂ ଭଜଧ୍ୱେ ତଂ ନ ଜାନୀଥ, କିନ୍ତୁ ୱଯଂ ଯଂ ଭଜାମହେ ତଂ ଜାନୀମହେ, ଯତୋ ଯିହୂଦୀଯଲୋକାନାଂ ମଧ୍ୟାତ୍ ପରିତ୍ରାଣଂ ଜାଯତେ| ");
INSERT INTO sanori_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","କିନ୍ତୁ ଯଦା ସତ୍ୟଭକ୍ତା ଆତ୍ମନା ସତ୍ୟରୂପେଣ ଚ ପିତୁର୍ଭଜନଂ କରିଷ୍ୟନ୍ତେ ସମଯ ଏତାଦୃଶ ଆଯାତି, ୱରମ୍ ଇଦାନୀମପି ୱିଦ୍ୟତେ ; ଯତ ଏତାଦୃଶୋ ଭତ୍କାନ୍ ପିତା ଚେଷ୍ଟତେ| ");
INSERT INTO sanori_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ଈଶ୍ୱର ଆତ୍ମା; ତତସ୍ତସ୍ୟ ଯେ ଭକ୍ତାସ୍ତୈଃ ସ ଆତ୍ମନା ସତ୍ୟରୂପେଣ ଚ ଭଜନୀଯଃ| ");
INSERT INTO sanori_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","ତଦା ସା ମହିଲାୱାଦୀତ୍ ଖ୍ରୀଷ୍ଟନାମ୍ନା ୱିଖ୍ୟାତୋଽଭିଷିକ୍ତଃ ପୁରୁଷ ଆଗମିଷ୍ୟତୀତି ଜାନାମି ସ ଚ ସର୍ୱ୍ୱାଃ କଥା ଅସ୍ମାନ୍ ଜ୍ଞାପଯିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ତତୋ ଯୀଶୁରୱଦତ୍ ତ୍ୱଯା ସାର୍ଦ୍ଧଂ କଥନଂ କରୋମି ଯୋଽହମ୍ ଅହମେୱ ସ ପୁରୁଷଃ| ");
INSERT INTO sanori_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ଏତସ୍ମିନ୍ ସମଯେ ଶିଷ୍ୟା ଆଗତ୍ୟ ତଥା ସ୍ତ୍ରିଯା ସାର୍ଦ୍ଧଂ ତସ୍ୟ କଥୋପକଥନେ ମହାଶ୍ଚର୍ୟ୍ୟମ୍ ଅମନ୍ୟନ୍ତ ତଥାପି ଭୱାନ୍ କିମିଚ୍ଛତି? ଯଦ୍ୱା କିମର୍ଥମ୍ ଏତଯା ସାର୍ଦ୍ଧଂ କଥାଂ କଥଯତି? ଇତି କୋପି ନାପୃଚ୍ଛତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","ତତଃ ପରଂ ସା ନାରୀ କଲଶଂ ସ୍ଥାପଯିତ୍ୱା ନଗରମଧ୍ୟଂ ଗତ୍ୱା ଲୋକେଭ୍ୟୋକଥାଯଦ୍ ");
INSERT INTO sanori_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","ଅହଂ ଯଦ୍ୟତ୍ କର୍ମ୍ମାକରୱଂ ତତ୍ସର୍ୱ୍ୱଂ ମହ୍ୟମକଥଯଦ୍ ଏତାଦୃଶଂ ମାନୱମେକମ୍ ଆଗତ୍ୟ ପଶ୍ୟତ ରୁ କିମ୍ ଅଭିଷିକ୍ତୋ ନ ଭୱତି ? ");
INSERT INTO sanori_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ତତସ୍ତେ ନଗରାଦ୍ ବହିରାଗତ୍ୟ ତାତସ୍ୟ ସମୀପମ୍ ଆଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ଏତର୍ହି ଶିଷ୍ୟାଃ ସାଧଯିତ୍ୱା ତଂ ୱ୍ୟାହାର୍ଷୁଃ ହେ ଗୁରୋ ଭୱାନ୍ କିଞ୍ଚିଦ୍ ଭୂକ୍ତାଂ| ");
INSERT INTO sanori_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ତତଃ ସୋୱଦଦ୍ ଯୁଷ୍ମାଭିର୍ୟନ୍ନ ଜ୍ଞାଯତେ ତାଦୃଶଂ ଭକ୍ଷ୍ୟଂ ମମାସ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","ତଦା ଶିଷ୍ୟାଃ ପରସ୍ପରଂ ପ୍ରଷ୍ଟୁମ୍ ଆରମ୍ଭନ୍ତ, କିମସ୍ମୈ କୋପି କିମପି ଭକ୍ଷ୍ୟମାନୀଯ ଦତ୍ତୱାନ୍? ");
INSERT INTO sanori_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","ଯୀଶୁରୱୋଚତ୍ ମତ୍ପ୍ରେରକସ୍ୟାଭିମତାନୁରୂପକରଣଂ ତସ୍ୟୈୱ କର୍ମ୍ମସିଦ୍ଧିକାରଣଞ୍ଚ ମମ ଭକ୍ଷ୍ୟଂ| ");
INSERT INTO sanori_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","ମାସଚତୁଷ୍ଟଯେ ଜାତେ ଶସ୍ୟକର୍ତ୍ତନସମଯୋ ଭୱିଷ୍ୟତୀତି ୱାକ୍ୟଂ ଯୁଷ୍ମାଭିଃ କିଂ ନୋଦ୍ୟତେ? କିନ୍ତ୍ୱହଂ ୱଦାମି, ଶିର ଉତ୍ତୋଲ୍ୟ କ୍ଷେତ୍ରାଣି ପ୍ରତି ନିରୀକ୍ଷ୍ୟ ପଶ୍ୟତ, ଇଦାନୀଂ କର୍ତ୍ତନଯୋଗ୍ୟାନି ଶୁକ୍ଲୱର୍ଣାନ୍ୟଭୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","ଯଶ୍ଛିନତ୍ତି ସ ୱେତନଂ ଲଭତେ ଅନନ୍ତାଯୁଃସ୍ୱରୂପଂ ଶସ୍ୟଂ ସ ଗୃହ୍ଲାତି ଚ, ତେନୈୱ ୱପ୍ତା ଛେତ୍ତା ଚ ଯୁଗପଦ୍ ଆନନ୍ଦତଃ| ");
INSERT INTO sanori_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ଇତ୍ଥଂ ସତି ୱପତ୍ୟେକଶ୍ଛିନତ୍ୟନ୍ୟ ଇତି ୱଚନଂ ସିଦ୍ଧ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","ଯତ୍ର ଯୂଯଂ ନ ପର୍ୟ୍ୟଶ୍ରାମ୍ୟତ ତାଦୃଶଂ ଶସ୍ୟଂ ଛେତ୍ତୁଂ ଯୁଷ୍ମାନ୍ ପ୍ରୈରଯମ୍ ଅନ୍ୟେ ଜନାଃପର୍ୟ୍ୟଶ୍ରାମ୍ୟନ୍ ଯୂଯଂ ତେଷାଂ ଶ୍ରଗସ୍ୟ ଫଲମ୍ ଅଲଭଧ୍ୱମ୍| ");
INSERT INTO sanori_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ଯସ୍ମିନ୍ କାଲେ ଯଦ୍ୟତ୍ କର୍ମ୍ମାକାର୍ଷଂ ତତ୍ସର୍ୱ୍ୱଂ ସ ମହ୍ୟମ୍ ଅକଥଯତ୍ ତସ୍ୟା ୱନିତାଯା ଇଦଂ ସାକ୍ଷ୍ୟୱାକ୍ୟଂ ଶ୍ରୁତ୍ୱା ତନ୍ନଗରନିୱାସିନୋ ବହୱଃ ଶୋମିରୋଣୀଯଲୋକା ୱ୍ୟଶ୍ୱସନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ତଥା ଚ ତସ୍ୟାନ୍ତିକେ ସମୁପସ୍ଥାଯ ସ୍ୱେଷାଂ ସନ୍ନିଧୌ କତିଚିଦ୍ ଦିନାନି ସ୍ଥାତୁଂ ତସ୍ମିନ୍ ୱିନଯମ୍ ଅକୁର୍ୱ୍ୱାନ ତସ୍ମାତ୍ ସ ଦିନଦ୍ୱଯଂ ତତ୍ସ୍ଥାନେ ନ୍ୟୱଷ୍ଟତ୍ ");
INSERT INTO sanori_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ତତସ୍ତସ୍ୟୋପଦେଶେନ ବହୱୋଽପରେ ୱିଶ୍ୱସ୍ୟ ");
INSERT INTO sanori_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ତାଂ ଯୋଷାମୱଦନ୍ କେୱଲଂ ତୱ ୱାକ୍ୟେନ ପ୍ରତୀମ ଇତି ନ, କିନ୍ତୁ ସ ଜଗତୋଽଭିଷିକ୍ତସ୍ତ୍ରାତେତି ତସ୍ୟ କଥାଂ ଶ୍ରୁତ୍ୱା ୱଯଂ ସ୍ୱଯମେୱାଜ୍ଞାସମହି| ");
INSERT INTO sanori_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","ସ୍ୱଦେଶେ ଭୱିଷ୍ୟଦ୍ୱକ୍ତୁଃ ସତ୍କାରୋ ନାସ୍ତୀତି ଯଦ୍ୟପି ଯୀଶୁଃ ପ୍ରମାଣଂ ଦତ୍ୱାକଥଯତ୍ ");
INSERT INTO sanori_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","ତଥାପି ଦିୱସଦ୍ୱଯାତ୍ ପରଂ ସ ତସ୍ମାତ୍ ସ୍ଥାନାଦ୍ ଗାଲୀଲଂ ଗତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ଅନନ୍ତରଂ ଯେ ଗାଲୀଲୀ ଲିଯଲୋକା ଉତ୍ସୱେ ଗତା ଉତ୍ସୱସମଯେ ଯିରୂଶଲମ୍ ନଗରେ ତସ୍ୟ ସର୍ୱ୍ୱାଃ କ୍ରିଯା ଅପଶ୍ୟନ୍ ତେ ଗାଲୀଲମ୍ ଆଗତଂ ତମ୍ ଆଗୃହ୍ଲନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ତତଃ ପରମ୍ ଯୀଶୁ ର୍ୟସ୍ମିନ୍ କାନ୍ନାନଗରେ ଜଲଂ ଦ୍ରାକ୍ଷାରସମ୍ ଆକରୋତ୍ ତତ୍ ସ୍ଥାନଂ ପୁନରଗାତ୍| ତସ୍ମିନ୍ନେୱ ସମଯେ କସ୍ୟଚିଦ୍ ରାଜସଭାସ୍ତାରସ୍ୟ ପୁତ୍ରଃ କଫର୍ନାହୂମପୁରୀ ରୋଗଗ୍ରସ୍ତ ଆସୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ସ ଯେହୂଦୀଯଦେଶାଦ୍ ଯୀଶୋ ର୍ଗାଲୀଲାଗମନୱାର୍ତ୍ତାଂ ନିଶମ୍ୟ ତସ୍ୟ ସମୀପଂ ଗତ୍ୱା ପ୍ରାର୍ଥ୍ୟ ୱ୍ୟାହୃତୱାନ୍ ମମ ପୁତ୍ରସ୍ୟ ପ୍ରାଯେଣ କାଲ ଆସନ୍ନଃ ଭୱାନ୍ ଆଗତ୍ୟ ତଂ ସ୍ୱସ୍ଥଂ କରୋତୁ| ");
INSERT INTO sanori_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","ତଦା ଯୀଶୁରକଥଯଦ୍ ଆଶ୍ଚର୍ୟ୍ୟଂ କର୍ମ୍ମ ଚିତ୍ରଂ ଚିହ୍ନଂ ଚ ନ ଦୃଷ୍ଟା ଯୂଯଂ ନ ପ୍ରତ୍ୟେଷ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ତତଃ ସ ସଭାସଦୱଦତ୍ ହେ ମହେଚ୍ଛ ମମ ପୁତ୍ରେ ନ ମୃତେ ଭୱାନାଗଚ୍ଛତୁ| ");
INSERT INTO sanori_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","ଯୀଶୁସ୍ତମୱଦଦ୍ ଗଚ୍ଛ ତୱ ପୁତ୍ରୋଽଜୀୱୀତ୍ ତଦା ଯୀଶୁନୋକ୍ତୱାକ୍ୟେ ସ ୱିଶ୍ୱସ୍ୟ ଗତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ଗମନକାଲେ ମାର୍ଗମଧ୍ୟେ ଦାସାସ୍ତଂ ସାକ୍ଷାତ୍ପ୍ରାପ୍ୟାୱଦନ୍ ଭୱତଃ ପୁତ୍ରୋଽଜୀୱୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ତତଃ କଂ କାଲମାରଭ୍ୟ ରୋଗପ୍ରତୀକାରାରମ୍ଭୋ ଜାତା ଇତି ପୃଷ୍ଟେ ତୈରୁକ୍ତଂ ହ୍ୟଃ ସାର୍ଦ୍ଧଦଣ୍ଡଦ୍ୱଯାଧିକଦ୍ୱିତୀଯଯାମେ ତସ୍ୟ ଜ୍ୱରତ୍ୟାଗୋଽଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","ତଦା ଯୀଶୁସ୍ତସ୍ମିନ୍ କ୍ଷଣେ ପ୍ରୋକ୍ତୱାନ୍ ତୱ ପୁତ୍ରୋଽଜୀୱୀତ୍ ପିତା ତଦ୍ବୁଦ୍ଧ୍ୱା ସପରିୱାରୋ ୱ୍ୟଶ୍ୱସୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ଯିହୂଦୀଯଦେଶାଦ୍ ଆଗତ୍ୟ ଗାଲୀଲି ଯୀଶୁରେତଦ୍ ଦ୍ୱିତୀଯମ୍ ଆଶ୍ଚର୍ୟ୍ୟକର୍ମ୍ମାକରୋତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ତତଃ ପରଂ ଯିହୂଦୀଯାନାମ୍ ଉତ୍ସୱ ଉପସ୍ଥିତେ ଯୀଶୁ ର୍ୟିରୂଶାଲମଂ ଗତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","ତସ୍ମିନ୍ନଗରେ ମେଷନାମ୍ନୋ ଦ୍ୱାରସ୍ୟ ସମୀପେ ଇବ୍ରୀଯଭାଷଯା ବୈଥେସ୍ଦା ନାମ୍ନା ପିଷ୍କରିଣୀ ପଞ୍ଚଘଟ୍ଟଯୁକ୍ତାସୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ତସ୍ୟାସ୍ତେଷୁ ଘଟ୍ଟେଷୁ କିଲାଲକମ୍ପନମ୍ ଅପେକ୍ଷ୍ୟ ଅନ୍ଧଖଞ୍ଚଶୁଷ୍କାଙ୍ଗାଦଯୋ ବହୱୋ ରୋଗିଣଃ ପତନ୍ତସ୍ତିଷ୍ଠନ୍ତି ସ୍ମ| ");
INSERT INTO sanori_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ଯତୋ ୱିଶେଷକାଲେ ତସ୍ୟ ସରସୋ ୱାରି ସ୍ୱର୍ଗୀଯଦୂତ ଏତ୍ୟାକମ୍ପଯତ୍ ତତ୍କୀଲାଲକମ୍ପନାତ୍ ପରଂ ଯଃ କଶ୍ଚିଦ୍ ରୋଗୀ ପ୍ରଥମଂ ପାନୀଯମୱାରୋହତ୍ ସ ଏୱ ତତ୍କ୍ଷଣାଦ୍ ରୋଗମୁକ୍ତୋଽଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","ତଦାଷ୍ଟାତ୍ରିଂଶଦ୍ୱର୍ଷାଣି ଯାୱଦ୍ ରୋଗଗ୍ରସ୍ତ ଏକଜନସ୍ତସ୍ମିନ୍ ସ୍ଥାନେ ସ୍ଥିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ଯୀଶୁସ୍ତଂ ଶଯିତଂ ଦୃଷ୍ଟ୍ୱା ବହୁକାଲିକରୋଗୀତି ଜ୍ଞାତ୍ୱା ୱ୍ୟାହୃତୱାନ୍ ତ୍ୱଂ କିଂ ସ୍ୱସ୍ଥୋ ବୁଭୂଷସି? ");
INSERT INTO sanori_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ତତୋ ରୋଗୀ କଥିତୱାନ୍ ହେ ମହେଚ୍ଛ ଯଦା କୀଲାଲଂ କମ୍ପତେ ତଦା ମାଂ ପୁଷ୍କରିଣୀମ୍ ଅୱରୋହଯିତୁଂ ମମ କୋପି ନାସ୍ତି, ତସ୍ମାନ୍ ମମ ଗମନକାଲେ କଶ୍ଚିଦନ୍ୟୋଽଗ୍ରୋ ଗତ୍ୱା ଅୱରୋହତି| ");
INSERT INTO sanori_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","ତଦା ଯୀଶୁରକଥଯଦ୍ ଉତ୍ତିଷ୍ଠ, ତୱ ଶଯ୍ୟାମୁତ୍ତୋଲ୍ୟ ଗୃହୀତ୍ୱା ଯାହି| ");
INSERT INTO sanori_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","ସ ତତ୍କ୍ଷଣାତ୍ ସ୍ୱସ୍ଥୋ ଭୂତ୍ୱା ଶଯ୍ୟାମୁତ୍ତୋଲ୍ୟାଦାଯ ଗତୱାନ୍ କିନ୍ତୁ ତଦ୍ଦିନଂ ୱିଶ୍ରାମୱାରଃ| ");
INSERT INTO sanori_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ତସ୍ମାଦ୍ ଯିହୂଦୀଯାଃ ସ୍ୱସ୍ଥଂ ନରଂ ୱ୍ୟାହରନ୍ ଅଦ୍ୟ ୱିଶ୍ରାମୱାରେ ଶଯନୀଯମାଦାଯ ନ ଯାତୱ୍ୟମ୍| ");
INSERT INTO sanori_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","ତତଃ ସ ପ୍ରତ୍ୟୱୋଚଦ୍ ଯୋ ମାଂ ସ୍ୱସ୍ଥମ୍ ଅକାର୍ଷୀତ୍ ଶଯନୀଯମ୍ ଉତ୍ତୋଲ୍ୟାଦାଯ ଯାତୁଂ ମାଂ ସ ଏୱାଦିଶତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ତଦା ତେଽପୃଚ୍ଛନ୍ ଶଯନୀଯମ୍ ଉତ୍ତୋଲ୍ୟାଦାଯ ଯାତୁଂ ଯ ଆଜ୍ଞାପଯତ୍ ସ କଃ? ");
INSERT INTO sanori_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","କିନ୍ତୁ ସ କ ଇତି ସ୍ୱସ୍ଥୀଭୂତୋ ନାଜାନାଦ୍ ଯତସ୍ତସ୍ମିନ୍ ସ୍ଥାନେ ଜନତାସତ୍ତ୍ୱାଦ୍ ଯୀଶୁଃ ସ୍ଥାନାନ୍ତରମ୍ ଆଗମତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","ତତଃ ପରଂ ଯେଶୁ ର୍ମନ୍ଦିରେ ତଂ ନରଂ ସାକ୍ଷାତ୍ପ୍ରାପ୍ୟାକଥଯତ୍ ପଶ୍ୟେଦାନୀମ୍ ଅନାମଯୋ ଜାତୋସି ଯଥାଧିକା ଦୁର୍ଦଶା ନ ଘଟତେ ତଦ୍ଧେତୋଃ ପାପଂ କର୍ମ୍ମ ପୁନର୍ମାକାର୍ଷୀଃ| ");
INSERT INTO sanori_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ତତଃ ସ ଗତ୍ୱା ଯିହୂଦୀଯାନ୍ ଅୱଦଦ୍ ଯୀଶୁ ର୍ମାମ୍ ଅରୋଗିଣମ୍ ଅକାର୍ଷୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","ତତୋ ଯୀଶୁ ର୍ୱିଶ୍ରାମୱାରେ କର୍ମ୍ମେଦୃଶଂ କୃତୱାନ୍ ଇତି ହେତୋ ର୍ୟିହୂଦୀଯାସ୍ତଂ ତାଡଯିତ୍ୱା ହନ୍ତୁମ୍ ଅଚେଷ୍ଟନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","ଯୀଶୁସ୍ତାନାଖ୍ୟତ୍ ମମ ପିତା ଯତ୍ କାର୍ୟ୍ୟଂ କରୋତି ତଦନୁରୂପମ୍ ଅହମପି କରୋତି| ");
INSERT INTO sanori_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","ତତୋ ଯିହୂଦୀଯାସ୍ତଂ ହନ୍ତୁଂ ପୁନରଯତନ୍ତ ଯତୋ ୱିଶ୍ରାମୱାରଂ ନାମନ୍ୟତ ତଦେୱ କେୱଲଂ ନ ଅଧିକନ୍ତୁ ଈଶ୍ୱରଂ ସ୍ୱପିତରଂ ପ୍ରୋଚ୍ୟ ସ୍ୱମପୀଶ୍ୱରତୁଲ୍ୟଂ କୃତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","ପଶ୍ଚାଦ୍ ଯୀଶୁରୱଦଦ୍ ଯୁଷ୍ମାନହଂ ଯଥାର୍ଥତରଂ ୱଦାମି ପୁତ୍ରଃ ପିତରଂ ଯଦ୍ୟତ୍ କର୍ମ୍ମ କୁର୍ୱ୍ୱନ୍ତଂ ପଶ୍ୟତି ତଦତିରିକ୍ତଂ ସ୍ୱେଚ୍ଛାତଃ କିମପି କର୍ମ୍ମ କର୍ତ୍ତୁଂ ନ ଶକ୍ନୋତି| ପିତା ଯତ୍ କରୋତି ପୁତ୍ରୋପି ତଦେୱ କରୋତି| ");
INSERT INTO sanori_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ପିତା ପୁତ୍ରେ ସ୍ନେହଂ କରୋତି ତସ୍ମାତ୍ ସ୍ୱଯଂ ଯଦ୍ୟତ୍ କର୍ମ୍ମ କରୋତି ତତ୍ସର୍ୱ୍ୱଂ ପୁତ୍ରଂ ଦର୍ଶଯତି ; ଯଥା ଚ ଯୁଷ୍ମାକଂ ଆଶ୍ଚର୍ୟ୍ୟଜ୍ଞାନଂ ଜନିଷ୍ୟତେ ତଦର୍ଥମ୍ ଇତୋପି ମହାକର୍ମ୍ମ ତଂ ଦର୍ଶଯିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","ୱସ୍ତୁତସ୍ତୁ ପିତା ଯଥା ପ୍ରମିତାନ୍ ଉତ୍ଥାପ୍ୟ ସଜିୱାନ୍ କରୋତି ତଦ୍ୱତ୍ ପୁତ୍ରୋପି ଯଂ ଯଂ ଇଚ୍ଛତି ତଂ ତଂ ସଜୀୱଂ କରୋତି| ");
INSERT INTO sanori_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","ସର୍ୱ୍ୱେ ପିତରଂ ଯଥା ସତ୍କୁର୍ୱ୍ୱନ୍ତି ତଥା ପୁତ୍ରମପି ସତ୍କାରଯିତୁଂ ପିତା ସ୍ୱଯଂ କସ୍ୟାପି ୱିଚାରମକୃତ୍ୱା ସର୍ୱ୍ୱୱିଚାରାଣାଂ ଭାରଂ ପୁତ୍ରେ ସମର୍ପିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ଯଃ ପୁତ୍ରଂ ସତ୍ କରୋତି ସ ତସ୍ୟ ପ୍ରେରକମପି ସତ୍ କରୋତି| ");
INSERT INTO sanori_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","ଯୁଷ୍ମାନାହଂ ଯଥାର୍ଥତରଂ ୱଦାମି ଯୋ ଜନୋ ମମ ୱାକ୍ୟଂ ଶ୍ରୁତ୍ୱା ମତ୍ପ୍ରେରକେ ୱିଶ୍ୱସିତି ସୋନନ୍ତାଯୁଃ ପ୍ରାପ୍ନୋତି କଦାପି ଦଣ୍ଡବାଜନଂ ନ ଭୱତି ନିଧନାଦୁତ୍ଥାଯ ପରମାଯୁଃ ପ୍ରାପ୍ନୋତି| ");
INSERT INTO sanori_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","ଅହଂ ଯୁଷ୍ମାନତିଯଥାର୍ଥଂ ୱଦାମି ଯଦା ମୃତା ଈଶ୍ୱରପୁତ୍ରସ୍ୟ ନିନାଦଂ ଶ୍ରୋଷ୍ୟନ୍ତି ଯେ ଚ ଶ୍ରୋଷ୍ୟନ୍ତି ତେ ସଜୀୱା ଭୱିଷ୍ୟନ୍ତି ସମଯ ଏତାଦୃଶ ଆଯାତି ୱରମ୍ ଇଦାନୀମପ୍ୟୁପତିଷ୍ଠତି| ");
INSERT INTO sanori_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","ପିତା ଯଥା ସ୍ୱଯଞ୍ଜୀୱୀ ତଥା ପୁତ୍ରାଯ ସ୍ୱଯଞ୍ଜୀୱିତ୍ୱାଧିକାରଂ ଦତ୍ତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ସ ମନୁଷ୍ୟପୁତ୍ରଃ ଏତସ୍ମାତ୍ କାରଣାତ୍ ପିତା ଦଣ୍ଡକରଣାଧିକାରମପି ତସ୍ମିନ୍ ସମର୍ପିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","ଏତଦର୍ଥେ ଯୂଯମ୍ ଆଶ୍ଚର୍ୟ୍ୟଂ ନ ମନ୍ୟଧ୍ୱଂ ଯତୋ ଯସ୍ମିନ୍ ସମଯେ ତସ୍ୟ ନିନାଦଂ ଶ୍ରୁତ୍ୱା ଶ୍ମଶାନସ୍ଥାଃ ସର୍ୱ୍ୱେ ବହିରାଗମିଷ୍ୟନ୍ତି ସମଯ ଏତାଦୃଶ ଉପସ୍ଥାସ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ତସ୍ମାଦ୍ ଯେ ସତ୍କର୍ମ୍ମାଣି କୃତୱନ୍ତସ୍ତ ଉତ୍ଥାଯ ଆଯୁଃ ପ୍ରାପ୍ସ୍ୟନ୍ତି ଯେ ଚ କୁକର୍ମାଣି କୃତୱନ୍ତସ୍ତ ଉତ୍ଥାଯ ଦଣ୍ଡଂ ପ୍ରାପ୍ସ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","ଅହଂ ସ୍ୱଯଂ କିମପି କର୍ତ୍ତୁଂ ନ ଶକ୍ନୋମି ଯଥା ଶୁଣୋମି ତଥା ୱିଚାରଯାମି ମମ ୱିଚାରଞ୍ଚ ନ୍ୟାଯ୍ୟଃ ଯତୋହଂ ସ୍ୱୀଯାଭୀଷ୍ଟଂ ନେହିତ୍ୱା ମତ୍ପ୍ରେରଯିତୁଃ ପିତୁରିଷ୍ଟମ୍ ଈହେ| ");
INSERT INTO sanori_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","ଯଦି ସ୍ୱସ୍ମିନ୍ ସ୍ୱଯଂ ସାକ୍ଷ୍ୟଂ ଦଦାମି ତର୍ହି ତତ୍ସାକ୍ଷ୍ୟମ୍ ଆଗ୍ରାହ୍ୟଂ ଭୱତି ; ");
INSERT INTO sanori_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","କିନ୍ତୁ ମଦର୍ଥେଽପରୋ ଜନଃ ସାକ୍ଷ୍ୟଂ ଦଦାତି ମଦର୍ଥେ ତସ୍ୟ ଯତ୍ ସାକ୍ଷ୍ୟଂ ତତ୍ ସତ୍ୟମ୍ ଏତଦପ୍ୟହଂ ଜାନାମି| ");
INSERT INTO sanori_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","ଯୁଷ୍ମାଭି ର୍ୟୋହନଂ ପ୍ରତି ଲୋକେଷୁ ପ୍ରେରିତେଷୁ ସ ସତ୍ୟକଥାଯାଂ ସାକ୍ଷ୍ୟମଦଦାତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","ମାନୁଷାଦହଂ ସାକ୍ଷ୍ୟଂ ନୋପେକ୍ଷେ ତଥାପି ଯୂଯଂ ଯଥା ପରିତ୍ରଯଧ୍ୱେ ତଦର୍ଥମ୍ ଇଦଂ ୱାକ୍ୟଂ ୱଦାମି| ");
INSERT INTO sanori_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","ଯୋହନ୍ ଦେଦୀପ୍ୟମାନୋ ଦୀପ ଇୱ ତେଜସ୍ୱୀ ସ୍ଥିତୱାନ୍ ଯୂଯମ୍ ଅଲ୍ପକାଲଂ ତସ୍ୟ ଦୀପ୍ତ୍ୟାନନ୍ଦିତୁଂ ସମମନ୍ୟଧ୍ୱଂ| ");
INSERT INTO sanori_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","କିନ୍ତୁ ତତ୍ପ୍ରମାଣାଦପି ମମ ଗୁରୁତରଂ ପ୍ରମାଣଂ ୱିଦ୍ୟତେ ପିତା ମାଂ ପ୍ରେଷ୍ୟ ଯଦ୍ୟତ୍ କର୍ମ୍ମ ସମାପଯିତୁଂ ଶକ୍ତ୍ତିମଦଦାତ୍ ମଯା କୃତଂ ତତ୍ତତ୍ କର୍ମ୍ମ ମଦର୍ଥେ ପ୍ରମାଣଂ ଦଦାତି| ");
INSERT INTO sanori_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ଯଃ ପିତା ମାଂ ପ୍ରେରିତୱାନ୍ ମୋପି ମଦର୍ଥେ ପ୍ରମାଣଂ ଦଦାତି| ତସ୍ୟ ୱାକ୍ୟଂ ଯୁଷ୍ମାଭିଃ କଦାପି ନ ଶ୍ରୁତଂ ତସ୍ୟ ରୂପଞ୍ଚ ନ ଦୃଷ୍ଟଂ ");
INSERT INTO sanori_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ତସ୍ୟ ୱାକ୍ୟଞ୍ଚ ଯୁଷ୍ମାକମ୍ ଅନ୍ତଃ କଦାପି ସ୍ଥାନଂ ନାପ୍ନୋତି ଯତଃ ସ ଯଂ ପ୍ରେଷିତୱାନ୍ ଯୂଯଂ ତସ୍ମିନ୍ ନ ୱିଶ୍ୱସିଥ| ");
INSERT INTO sanori_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","ଧର୍ମ୍ମପୁସ୍ତକାନି ଯୂଯମ୍ ଆଲୋଚଯଧ୍ୱଂ ତୈ ର୍ୱାକ୍ୟୈରନନ୍ତାଯୁଃ ପ୍ରାପ୍ସ୍ୟାମ ଇତି ଯୂଯଂ ବୁଧ୍ୟଧ୍ୱେ ତଦ୍ଧର୍ମ୍ମପୁସ୍ତକାନି ମଦର୍ଥେ ପ୍ରମାଣଂ ଦଦତି| ");
INSERT INTO sanori_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ତଥାପି ଯୂଯଂ ପରମାଯୁଃପ୍ରାପ୍ତଯେ ମମ ସଂନିଧିମ୍ ନ ଜିଗମିଷଥ| ");
INSERT INTO sanori_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","ଅହଂ ମାନୁଷେଭ୍ୟଃ ସତ୍କାରଂ ନ ଗୃହ୍ଲାମି| ");
INSERT INTO sanori_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ଅହଂ ଯୁଷ୍ମାନ୍ ଜାନାମି; ଯୁଷ୍ମାକମନ୍ତର ଈଶ୍ୱରପ୍ରେମ ନାସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ଅହଂ ନିଜପିତୁ ର୍ନାମ୍ନାଗତୋସ୍ମି ତଥାପି ମାଂ ନ ଗୃହ୍ଲୀଥ କିନ୍ତୁ କଶ୍ଚିଦ୍ ଯଦି ସ୍ୱନାମ୍ନା ସମାଗମିଷ୍ୟତି ତର୍ହି ତଂ ଗ୍ରହୀଷ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","ଯୂଯମ୍ ଈଶ୍ୱରାତ୍ ସତ୍କାରଂ ନ ଚିଷ୍ଟତ୍ୱା କେୱଲଂ ପରସ୍ପରଂ ସତ୍କାରମ୍ ଚେଦ୍ ଆଦଧ୍ୱ୍ୱେ ତର୍ହି କଥଂ ୱିଶ୍ୱସିତୁଂ ଶକ୍ନୁଥ? ");
INSERT INTO sanori_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","ପୁତୁଃ ସମୀପେଽହଂ ଯୁଷ୍ମାନ୍ ଅପୱଦିଷ୍ୟାମୀତି ମା ଚିନ୍ତଯତ ଯସ୍ମିନ୍ , ଯସ୍ମିନ୍ ଯୁଷ୍ମାକଂ ୱିଶ୍ୱସଃ ସଏୱ ମୂସା ଯୁଷ୍ମାନ୍ ଅପୱଦତି| ");
INSERT INTO sanori_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","ଯଦି ଯୂଯଂ ତସ୍ମିନ୍ ୱ୍ୟଶ୍ୱସିଷ୍ୟତ ତର୍ହି ମଯ୍ୟପି ୱ୍ୟଶ୍ୱସିଷ୍ୟତ, ଯତ୍ ସ ମଯି ଲିଖିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","ତତୋ ଯଦି ତେନ ଲିଖିତୱାନି ନ ପ୍ରତିଥ ତର୍ହି ମମ ୱାକ୍ୟାନି କଥଂ ପ୍ରତ୍ୟେଷ୍ୟଥ? ");
INSERT INTO sanori_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","ତତଃ ପରଂ ଯୀଶୁ ର୍ଗାଲୀଲ୍ ପ୍ରଦେଶୀଯସ୍ୟ ତିୱିରିଯାନାମ୍ନଃ ସିନ୍ଧୋଃ ପାରଂ ଗତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ତତୋ ୱ୍ୟାଧିମଲ୍ଲୋକସ୍ୱାସ୍ଥ୍ୟକରଣରୂପାଣି ତସ୍ୟାଶ୍ଚର୍ୟ୍ୟାଣି କର୍ମ୍ମାଣି ଦୃଷ୍ଟ୍ୱା ବହୱୋ ଜନାସ୍ତତ୍ପଶ୍ଚାଦ୍ ଅଗଚ୍ଛନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ତତୋ ଯୀଶୁଃ ପର୍ୱ୍ୱତମାରୁହ୍ୟ ତତ୍ର ଶିଷ୍ୟୈଃ ସାକମ୍| ");
INSERT INTO sanori_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","ତସ୍ମିନ୍ ସମଯ ନିସ୍ତାରୋତ୍ସୱନାମ୍ନି ଯିହୂଦୀଯାନାମ ଉତ୍ସୱ ଉପସ୍ଥିତେ ");
INSERT INTO sanori_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","ଯୀଶୁ ର୍ନେତ୍ରେ ଉତ୍ତୋଲ୍ୟ ବହୁଲୋକାନ୍ ସ୍ୱସମୀପାଗତାନ୍ ୱିଲୋକ୍ୟ ଫିଲିପଂ ପୃଷ୍ଟୱାନ୍ ଏତେଷାଂ ଭୋଜନାଯ ଭୋଜଦ୍ରୱ୍ୟାଣି ୱଯଂ କୁତ୍ର କ୍ରେତୁଂ ଶକ୍ରୁମଃ? ");
INSERT INTO sanori_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ୱାକ୍ୟମିଦଂ ତସ୍ୟ ପରୀକ୍ଷାର୍ଥମ୍ ଅୱାଦୀତ୍ କିନ୍ତୁ ଯତ୍ କରିଷ୍ୟତି ତତ୍ ସ୍ୱଯମ୍ ଅଜାନାତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ଫିଲିପଃ ପ୍ରତ୍ୟୱୋଚତ୍ ଏତେଷାମ୍ ଏକୈକୋ ଯଦ୍ୟଲ୍ପମ୍ ଅଲ୍ପଂ ପ୍ରାପ୍ନୋତି ତର୍ହି ମୁଦ୍ରାପାଦଦ୍ୱିଶତେନ କ୍ରୀତପୂପା ଅପି ନ୍ୟୂନା ଭୱିଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ଶିମୋନ୍ ପିତରସ୍ୟ ଭ୍ରାତା ଆନ୍ଦ୍ରିଯାଖ୍ୟଃ ଶିଷ୍ୟାଣାମେକୋ ୱ୍ୟାହୃତୱାନ୍ ");
INSERT INTO sanori_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","ଅତ୍ର କସ୍ୟଚିଦ୍ ବାଲକସ୍ୟ ସମୀପେ ପଞ୍ଚ ଯାୱପୂପାଃ କ୍ଷୁଦ୍ରମତ୍ସ୍ୟଦ୍ୱଯଞ୍ଚ ସନ୍ତି କିନ୍ତୁ ଲୋକାନାଂ ଏତାୱାତାଂ ମଧ୍ୟେ ତୈଃ କିଂ ଭୱିଷ୍ୟତି? ");
INSERT INTO sanori_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","ପଶ୍ଚାଦ୍ ଯୀଶୁରୱଦତ୍ ଲୋକାନୁପୱେଶଯତ ତତ୍ର ବହୁଯୱସସତ୍ତ୍ୱାତ୍ ପଞ୍ଚସହସ୍ତ୍ରେଭ୍ୟୋ ନ୍ୟୂନା ଅଧିକା ୱା ପୁରୁଷା ଭୂମ୍ୟାମ୍ ଉପାୱିଶନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ତତୋ ଯୀଶୁସ୍ତାନ୍ ପୂପାନାଦାଯ ଈଶ୍ୱରସ୍ୟ ଗୁଣାନ୍ କୀର୍ତ୍ତଯିତ୍ୱା ଶିଷ୍ୟେଷୁ ସମାର୍ପଯତ୍ ତତସ୍ତେ ତେଭ୍ୟ ଉପୱିଷ୍ଟଲୋକେଭ୍ୟଃ ପୂପାନ୍ ଯଥେଷ୍ଟମତ୍ସ୍ୟଞ୍ଚ ପ୍ରାଦୁଃ| ");
INSERT INTO sanori_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ତେଷୁ ତୃପ୍ତେଷୁ ସ ତାନୱୋଚଦ୍ ଏତେଷାଂ କିଞ୍ଚିଦପି ଯଥା ନାପଚୀଯତେ ତଥା ସର୍ୱ୍ୱାଣ୍ୟୱଶିଷ୍ଟାନି ସଂଗୃହ୍ଲୀତ| ");
INSERT INTO sanori_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ତତଃ ସର୍ୱ୍ୱେଷାଂ ଭୋଜନାତ୍ ପରଂ ତେ ତେଷାଂ ପଞ୍ଚାନାଂ ଯାୱପୂପାନାଂ ଅୱଶିଷ୍ଟାନ୍ୟଖିଲାନି ସଂଗୃହ୍ୟ ଦ୍ୱାଦଶଡଲ୍ଲକାନ୍ ଅପୂରଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","ଅପରଂ ଯୀଶୋରେତାଦୃଶୀମ୍ ଆଶ୍ଚର୍ୟ୍ୟକ୍ରିଯାଂ ଦୃଷ୍ଟ୍ୱା ଲୋକା ମିଥୋ ୱକ୍ତୁମାରେଭିରେ ଜଗତି ଯସ୍ୟାଗମନଂ ଭୱିଷ୍ୟତି ସ ଏୱାଯମ୍ ଅୱଶ୍ୟଂ ଭୱିଷ୍ୟଦ୍ୱକ୍ତ୍ତା| ");
INSERT INTO sanori_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ଅତଏୱ ଲୋକା ଆଗତ୍ୟ ତମାକ୍ରମ୍ୟ ରାଜାନଂ କରିଷ୍ୟନ୍ତି ଯୀଶୁସ୍ତେଷାମ୍ ଈଦୃଶଂ ମାନସଂ ୱିଜ୍ଞାଯ ପୁନଶ୍ଚ ପର୍ୱ୍ୱତମ୍ ଏକାକୀ ଗତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ସାଯଂକାଲ ଉପସ୍ଥିତେ ଶିଷ୍ୟା ଜଲଧିତଟଂ ୱ୍ରଜିତ୍ୱା ନାୱମାରୁହ୍ୟ ନଗରଦିଶି ସିନ୍ଧୌ ୱାହଯିତ୍ୱାଗମନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ତସ୍ମିନ୍ ସମଯେ ତିମିର ଉପାତିଷ୍ଠତ୍ କିନ୍ତୁ ଯୀଷୁସ୍ତେଷାଂ ସମୀପଂ ନାଗଚ୍ଛତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ତଦା ପ୍ରବଲପୱନୱହନାତ୍ ସାଗରେ ମହାତରଙ୍ଗୋ ଭୱିତୁମ୍ ଆରେଭେ| ");
INSERT INTO sanori_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ତତସ୍ତେ ୱାହଯିତ୍ୱା ଦ୍ୱିତ୍ରାନ୍ କ୍ରୋଶାନ୍ ଗତାଃ ପଶ୍ଚାଦ୍ ଯୀଶୁଂ ଜଲଧେରୁପରି ପଦ୍ଭ୍ୟାଂ ୱ୍ରଜନ୍ତଂ ନୌକାନ୍ତିକମ୍ ଆଗଚ୍ଛନ୍ତଂ ୱିଲୋକ୍ୟ ତ୍ରାସଯୁକ୍ତା ଅଭୱନ୍ ");
INSERT INTO sanori_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","କିନ୍ତୁ ସ ତାନୁକ୍ତ୍ତୱାନ୍ ଅଯମହଂ ମା ଭୈଷ୍ଟ| ");
INSERT INTO sanori_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ତଦା ତେ ତଂ ସ୍ୱୈରଂ ନାୱି ଗୃହୀତୱନ୍ତଃ ତଦା ତତ୍କ୍ଷଣାଦ୍ ଉଦ୍ଦିଷ୍ଟସ୍ଥାନେ ନୌରୁପାସ୍ଥାତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","ଯଯା ନାୱା ଶିଷ୍ୟା ଅଗଚ୍ଛନ୍ ତଦନ୍ୟା କାପି ନୌକା ତସ୍ମିନ୍ ସ୍ଥାନେ ନାସୀତ୍ ତତୋ ଯୀଶୁଃ ଶିଷ୍ୟୈଃ ସାକଂ ନାଗମତ୍ କେୱଲାଃ ଶିଷ୍ୟା ଅଗମନ୍ ଏତତ୍ ପାରସ୍ଥା ଲୋକା ଜ୍ଞାତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","କିନ୍ତୁ ତତଃ ପରଂ ପ୍ରଭୁ ର୍ୟତ୍ର ଈଶ୍ୱରସ୍ୟ ଗୁଣାନ୍ ଅନୁକୀର୍ତ୍ତ୍ୟ ଲୋକାନ୍ ପୂପାନ୍ ଅଭୋଜଯତ୍ ତତ୍ସ୍ଥାନସ୍ୟ ସମୀପସ୍ଥତିୱିରିଯାଯା ଅପରାସ୍ତରଣଯ ଆଗମନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","ଯୀଶୁସ୍ତତ୍ର ନାସ୍ତି ଶିଷ୍ୟା ଅପି ତତ୍ର ନା ସନ୍ତି ଲୋକା ଇତି ୱିଜ୍ଞାଯ ଯୀଶୁଂ ଗୱେଷଯିତୁଂ ତରଣିଭିଃ କଫର୍ନାହୂମ୍ ପୁରଂ ଗତାଃ| ");
INSERT INTO sanori_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","ତତସ୍ତେ ସରିତ୍ପତେଃ ପାରେ ତଂ ସାକ୍ଷାତ୍ ପ୍ରାପ୍ୟ ପ୍ରାୱୋଚନ୍ ହେ ଗୁରୋ ଭୱାନ୍ ଅତ୍ର ସ୍ଥାନେ କଦାଗମତ୍? ");
INSERT INTO sanori_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","ତଦା ଯୀଶୁସ୍ତାନ୍ ପ୍ରତ୍ୟୱାଦୀଦ୍ ଯୁଷ୍ମାନହଂ ଯଥାର୍ଥତରଂ ୱଦାମି ଆଶ୍ଚର୍ୟ୍ୟକର୍ମ୍ମଦର୍ଶନାଦ୍ଧେତୋ ର୍ନ କିନ୍ତୁ ପୂପଭୋଜନାତ୍ ତେନ ତୃପ୍ତତ୍ୱାଞ୍ଚ ମାଂ ଗୱେଷଯଥ| ");
INSERT INTO sanori_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","କ୍ଷଯଣୀଯଭକ୍ଷ୍ୟାର୍ଥଂ ମା ଶ୍ରାମିଷ୍ଟ କିନ୍ତ୍ୱନ୍ତାଯୁର୍ଭକ୍ଷ୍ୟାର୍ଥଂ ଶ୍ରାମ୍ୟତ, ତସ୍ମାତ୍ ତାଦୃଶଂ ଭକ୍ଷ୍ୟଂ ମନୁଜପୁତ୍ରୋ ଯୁଷ୍ମାଭ୍ୟଂ ଦାସ୍ୟତି; ତସ୍ମିନ୍ ତାତ ଈଶ୍ୱରଃ ପ୍ରମାଣଂ ପ୍ରାଦାତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","ତଦା ତେଽପୃଚ୍ଛନ୍ ଈଶ୍ୱରାଭିମତଂ କର୍ମ୍ମ କର୍ତ୍ତୁମ୍ ଅସ୍ମାଭିଃ କିଂ କର୍ତ୍ତୱ୍ୟଂ? ");
INSERT INTO sanori_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","ତତୋ ଯୀଶୁରୱଦଦ୍ ଈଶ୍ୱରୋ ଯଂ ପ୍ରୈରଯତ୍ ତସ୍ମିନ୍ ୱିଶ୍ୱସନମ୍ ଈଶ୍ୱରାଭିମତଂ କର୍ମ୍ମ| ");
INSERT INTO sanori_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","ତଦା ତେ ୱ୍ୟାହରନ୍ ଭୱତା କିଂ ଲକ୍ଷଣଂ ଦର୍ଶିତଂ ଯଦ୍ଦୃଷ୍ଟ୍ୱା ଭୱତି ୱିଶ୍ୱସିଷ୍ୟାମଃ? ତ୍ୱଯା କିଂ କର୍ମ୍ମ କୃତଂ? ");
INSERT INTO sanori_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","ଅସ୍ମାକଂ ପୂର୍ୱ୍ୱପୁରୁଷା ମହାପ୍ରାନ୍ତରେ ମାନ୍ନାଂ ଭୋକ୍ତ୍ତୁଂ ପ୍ରାପୁଃ ଯଥା ଲିପିରାସ୍ତେ| ସ୍ୱର୍ଗୀଯାଣି ତୁ ଭକ୍ଷ୍ୟାଣି ପ୍ରଦଦୌ ପରମେଶ୍ୱରଃ| ");
INSERT INTO sanori_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","ତଦା ଯୀଶୁରୱଦଦ୍ ଅହଂ ଯୁଷ୍ମାନତିଯଥାର୍ଥଂ ୱଦାମି ମୂସା ଯୁଷ୍ମାଭ୍ୟଂ ସ୍ୱର୍ଗୀଯଂ ଭକ୍ଷ୍ୟଂ ନାଦାତ୍ କିନ୍ତୁ ମମ ପିତା ଯୁଷ୍ମାଭ୍ୟଂ ସ୍ୱର୍ଗୀଯଂ ପରମଂ ଭକ୍ଷ୍ୟଂ ଦଦାତି| ");
INSERT INTO sanori_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ଯଃ ସ୍ୱର୍ଗାଦୱରୁହ୍ୟ ଜଗତେ ଜୀୱନଂ ଦଦାତି ସ ଈଶ୍ୱରଦତ୍ତଭକ୍ଷ୍ୟରୂପଃ| ");
INSERT INTO sanori_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","ତଦା ତେ ପ୍ରାୱୋଚନ୍ ହେ ପ୍ରଭୋ ଭକ୍ଷ୍ୟମିଦଂ ନିତ୍ୟମସ୍ମଭ୍ୟଂ ଦଦାତୁ| ");
INSERT INTO sanori_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","ଯୀଶୁରୱଦଦ୍ ଅହମେୱ ଜୀୱନରୂପଂ ଭକ୍ଷ୍ୟଂ ଯୋ ଜନୋ ମମ ସନ୍ନିଧିମ୍ ଆଗଚ୍ଛତି ସ ଜାତୁ କ୍ଷୁଧାର୍ତ୍ତୋ ନ ଭୱିଷ୍ୟତି, ତଥା ଯୋ ଜନୋ ମାଂ ପ୍ରତ୍ୟେତି ସ ଜାତୁ ତୃଷାର୍ତ୍ତୋ ନ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","ମାଂ ଦୃଷ୍ଟ୍ୱାପି ଯୂଯଂ ନ ୱିଶ୍ୱସିଥ ଯୁଷ୍ମାନହମ୍ ଇତ୍ୟୱୋଚଂ| ");
INSERT INTO sanori_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","ପିତା ମହ୍ୟଂ ଯାୱତୋ ଲୋକାନଦଦାତ୍ ତେ ସର୍ୱ୍ୱ ଏୱ ମମାନ୍ତିକମ୍ ଆଗମିଷ୍ୟନ୍ତି ଯଃ କଶ୍ଚିଚ୍ଚ ମମ ସନ୍ନିଧିମ୍ ଆଯାସ୍ୟତି ତଂ କେନାପି ପ୍ରକାରେଣ ନ ଦୂରୀକରିଷ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ନିଜାଭିମତଂ ସାଧଯିତୁଂ ନ ହି କିନ୍ତୁ ପ୍ରେରଯିତୁରଭିମତଂ ସାଧଯିତୁଂ ସ୍ୱର୍ଗାଦ୍ ଆଗତୋସ୍ମି| ");
INSERT INTO sanori_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ସ ଯାନ୍ ଯାନ୍ ଲୋକାନ୍ ମହ୍ୟମଦଦାତ୍ ତେଷାମେକମପି ନ ହାରଯିତ୍ୱା ଶେଷଦିନେ ସର୍ୱ୍ୱାନହମ୍ ଉତ୍ଥାପଯାମି ଇଦଂ ମତ୍ପ୍ରେରଯିତୁଃ ପିତୁରଭିମତଂ| ");
INSERT INTO sanori_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","ଯଃ କଶ୍ଚିନ୍ ମାନୱସୁତଂ ୱିଲୋକ୍ୟ ୱିଶ୍ୱସିତି ସ ଶେଷଦିନେ ମଯୋତ୍ଥାପିତଃ ସନ୍ ଅନନ୍ତାଯୁଃ ପ୍ରାପ୍ସ୍ୟତି ଇତି ମତ୍ପ୍ରେରକସ୍ୟାଭିମତଂ| ");
INSERT INTO sanori_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","ତଦା ସ୍ୱର୍ଗାଦ୍ ଯଦ୍ ଭକ୍ଷ୍ୟମ୍ ଅୱାରୋହତ୍ ତଦ୍ ଭକ୍ଷ୍ୟମ୍ ଅହମେୱ ଯିହୂଦୀଯଲୋକାସ୍ତସ୍ୟୈତଦ୍ ୱାକ୍ୟେ ୱିୱଦମାନା ୱକ୍ତ୍ତୁମାରେଭିରେ ");
INSERT INTO sanori_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ଯୂଷଫଃ ପୁତ୍ରୋ ଯୀଶୁ ର୍ୟସ୍ୟ ମାତାପିତରୌ ୱଯଂ ଜାନୀମ ଏଷ କିଂ ସଏୱ ନ? ତର୍ହି ସ୍ୱର୍ଗାଦ୍ ଅୱାରୋହମ୍ ଇତି ୱାକ୍ୟଂ କଥଂ ୱକ୍ତ୍ତି? ");
INSERT INTO sanori_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","ତଦା ଯୀଶୁସ୍ତାନ୍ ପ୍ରତ୍ୟୱଦତ୍ ପରସ୍ପରଂ ମା ୱିୱଦଧ୍ୱଂ ");
INSERT INTO sanori_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","ମତ୍ପ୍ରେରକେଣ ପିତ୍ରା ନାକୃଷ୍ଟଃ କୋପି ଜନୋ ମମାନ୍ତିକମ୍ ଆଯାତୁଂ ନ ଶକ୍ନୋତି କିନ୍ତ୍ୱାଗତଂ ଜନଂ ଚରମେଽହ୍ନି ପ୍ରୋତ୍ଥାପଯିଷ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","ତେ ସର୍ୱ୍ୱ ଈଶ୍ୱରେଣ ଶିକ୍ଷିତା ଭୱିଷ୍ୟନ୍ତି ଭୱିଷ୍ୟଦ୍ୱାଦିନାଂ ଗ୍ରନ୍ଥେଷୁ ଲିପିରିତ୍ଥମାସ୍ତେ ଅତୋ ଯଃ କଶ୍ଚିତ୍ ପିତୁଃ ସକାଶାତ୍ ଶ୍ରୁତ୍ୱା ଶିକ୍ଷତେ ସ ଏୱ ମମ ସମୀପମ୍ ଆଗମିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ଯ ଈଶ୍ୱରାଦ୍ ଅଜାଯତ ତଂ ୱିନା କୋପି ମନୁଷ୍ୟୋ ଜନକଂ ନାଦର୍ଶତ୍ କେୱଲଃ ସଏୱ ତାତମ୍ ଅଦ୍ରାକ୍ଷୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","ଅହଂ ଯୁଷ୍ମାନ୍ ଯଥାର୍ଥତରଂ ୱଦାମି ଯୋ ଜନୋ ମଯି ୱିଶ୍ୱାସଂ କରୋତି ସୋନନ୍ତାଯୁଃ ପ୍ରାପ୍ନୋତି| ");
INSERT INTO sanori_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ଅହମେୱ ତଜ୍ଜୀୱନଭକ୍ଷ୍ୟଂ| ");
INSERT INTO sanori_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","ଯୁଷ୍ମାକଂ ପୂର୍ୱ୍ୱପୁରୁଷା ମହାପ୍ରାନ୍ତରେ ମନ୍ନାଭକ୍ଷ୍ୟଂ ଭୂକ୍ତ୍ତାପି ମୃତାଃ ");
INSERT INTO sanori_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","କିନ୍ତୁ ଯଦ୍ଭକ୍ଷ୍ୟଂ ସ୍ୱର୍ଗାଦାଗଚ୍ଛତ୍ ତଦ୍ ଯଦି କଶ୍ଚିଦ୍ ଭୁଙ୍କ୍ତ୍ତେ ତର୍ହି ସ ନ ମ୍ରିଯତେ| ");
INSERT INTO sanori_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","ଯଜ୍ଜୀୱନଭକ୍ଷ୍ୟଂ ସ୍ୱର୍ଗାଦାଗଚ୍ଛତ୍ ସୋହମେୱ ଇଦଂ ଭକ୍ଷ୍ୟଂ ଯୋ ଜନୋ ଭୁଙ୍କ୍ତ୍ତେ ସ ନିତ୍ୟଜୀୱୀ ଭୱିଷ୍ୟତି| ପୁନଶ୍ଚ ଜଗତୋ ଜୀୱନାର୍ଥମହଂ ଯତ୍ ସ୍ୱକୀଯପିଶିତଂ ଦାସ୍ୟାମି ତଦେୱ ମଯା ୱିତରିତଂ ଭକ୍ଷ୍ୟମ୍| ");
INSERT INTO sanori_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","ତସ୍ମାଦ୍ ଯିହୂଦୀଯାଃ ପରସ୍ପରଂ ୱିୱଦମାନା ୱକ୍ତ୍ତୁମାରେଭିରେ ଏଷ ଭୋଜନାର୍ଥଂ ସ୍ୱୀଯଂ ପଲଲଂ କଥମ୍ ଅସ୍ମଭ୍ୟଂ ଦାସ୍ୟତି? ");
INSERT INTO sanori_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ତଦା ଯୀଶୁସ୍ତାନ୍ ଆୱୋଚଦ୍ ଯୁଷ୍ମାନହଂ ଯଥାର୍ଥତରଂ ୱଦାମି ମନୁଷ୍ୟପୁତ୍ରସ୍ୟାମିଷେ ଯୁଷ୍ମାଭି ର୍ନ ଭୁକ୍ତ୍ତେ ତସ୍ୟ ରୁଧିରେ ଚ ନ ପୀତେ ଜୀୱନେନ ସାର୍ଦ୍ଧଂ ଯୁଷ୍ମାକଂ ସମ୍ବନ୍ଧୋ ନାସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ଯୋ ମମାମିଷଂ ସ୍ୱାଦତି ମମ ସୁଧିରଞ୍ଚ ପିୱତି ସୋନନ୍ତାଯୁଃ ପ୍ରାପ୍ନୋତି ତତଃ ଶେଷେଽହ୍ନି ତମହମ୍ ଉତ୍ଥାପଯିଷ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","ଯତୋ ମଦୀଯମାମିଷଂ ପରମଂ ଭକ୍ଷ୍ୟଂ ତଥା ମଦୀଯଂ ଶୋଣିତଂ ପରମଂ ପେଯଂ| ");
INSERT INTO sanori_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ଯୋ ଜନୋ ମଦୀଯଂ ପଲଲଂ ସ୍ୱାଦତି ମଦୀଯଂ ରୁଧିରଞ୍ଚ ପିୱତି ସ ମଯି ୱସତି ତସ୍ମିନ୍ନହଞ୍ଚ ୱସାମି| ");
INSERT INTO sanori_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","ମତ୍ପ୍ରେରଯିତ୍ରା ଜୀୱତା ତାତେନ ଯଥାହଂ ଜୀୱାମି ତଦ୍ୱଦ୍ ଯଃ କଶ୍ଚିନ୍ ମାମତ୍ତି ସୋପି ମଯା ଜୀୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","ଯଦ୍ଭକ୍ଷ୍ୟଂ ସ୍ୱର୍ଗାଦାଗଚ୍ଛତ୍ ତଦିଦଂ ଯନ୍ମାନ୍ନାଂ ସ୍ୱାଦିତ୍ୱା ଯୁଷ୍ମାକଂ ପିତରୋଽମ୍ରିଯନ୍ତ ତାଦୃଶମ୍ ଇଦଂ ଭକ୍ଷ୍ୟଂ ନ ଭୱତି ଇଦଂ ଭକ୍ଷ୍ୟଂ ଯୋ ଭକ୍ଷତି ସ ନିତ୍ୟଂ ଜୀୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ଯଦା କଫର୍ନାହୂମ୍ ପୁର୍ୟ୍ୟାଂ ଭଜନଗେହେ ଉପାଦିଶତ୍ ତଦା କଥା ଏତା ଅକଥଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","ତଦେତ୍ଥଂ ଶ୍ରୁତ୍ୱା ତସ୍ୟ ଶିଷ୍ୟାଣାମ୍ ଅନେକେ ପରସ୍ପରମ୍ ଅକଥଯନ୍ ଇଦଂ ଗାଢଂ ୱାକ୍ୟଂ ୱାକ୍ୟମୀଦୃଶଂ କଃ ଶ୍ରୋତୁଂ ଶକ୍ରୁଯାତ୍? ");
INSERT INTO sanori_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","କିନ୍ତୁ ଯୀଶୁଃ ଶିଷ୍ୟାଣାମ୍ ଇତ୍ଥଂ ୱିୱାଦଂ ସ୍ୱଚିତ୍ତେ ୱିଜ୍ଞାଯ କଥିତୱାନ୍ ଇଦଂ ୱାକ୍ୟଂ କିଂ ଯୁଷ୍ମାକଂ ୱିଘ୍ନଂ ଜନଯତି? ");
INSERT INTO sanori_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","ଯଦି ମନୁଜସୁତଂ ପୂର୍ୱ୍ୱୱାସସ୍ଥାନମ୍ ଊର୍ଦ୍ୱ୍ୱଂ ଗଚ୍ଛନ୍ତଂ ପଶ୍ୟଥ ତର୍ହି କିଂ ଭୱିଷ୍ୟତି? ");
INSERT INTO sanori_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","ଆତ୍ମୈୱ ଜୀୱନଦାଯକଃ ୱପୁ ର୍ନିଷ୍ଫଲଂ ଯୁଷ୍ମଭ୍ୟମହଂ ଯାନି ୱଚାଂସି କଥଯାମି ତାନ୍ୟାତ୍ମା ଜୀୱନଞ୍ଚ| ");
INSERT INTO sanori_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","କିନ୍ତୁ ଯୁଷ୍ମାକଂ ମଧ୍ୟେ କେଚନ ଅୱିଶ୍ୱାସିନଃ ସନ୍ତି କେ କେ ନ ୱିଶ୍ୱସନ୍ତି କୋ ୱା ତଂ ପରକରେଷୁ ସମର୍ପଯିଷ୍ୟତି ତାନ୍ ଯୀଶୁରାପ୍ରଥମାଦ୍ ୱେତ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","ଅପରମପି କଥିତୱାନ୍ ଅସ୍ମାତ୍ କାରଣାଦ୍ ଅକଥଯଂ ପିତୁଃ ସକାଶାତ୍ ଶକ୍ତ୍ତିମପ୍ରାପ୍ୟ କୋପି ମମାନ୍ତିକମ୍ ଆଗନ୍ତୁଂ ନ ଶକ୍ନୋତି| ");
INSERT INTO sanori_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","ତତ୍କାଲେଽନେକେ ଶିଷ୍ୟା ୱ୍ୟାଘୁଟ୍ୟ ତେନ ସାର୍ଦ୍ଧଂ ପୁନ ର୍ନାଗଚ୍ଛନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","ତଦା ଯୀଶୁ ର୍ଦ୍ୱାଦଶଶିଷ୍ୟାନ୍ ଉକ୍ତ୍ତୱାନ୍ ଯୂଯମପି କିଂ ଯାସ୍ୟଥ? ");
INSERT INTO sanori_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ତତଃ ଶିମୋନ୍ ପିତରଃ ପ୍ରତ୍ୟୱୋଚତ୍ ହେ ପ୍ରଭୋ କସ୍ୟାଭ୍ୟର୍ଣଂ ଗମିଷ୍ୟାମଃ? ");
INSERT INTO sanori_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ଅନନ୍ତଜୀୱନଦାଯିନ୍ୟୋ ଯାଃ କଥାସ୍ତାସ୍ତୱୈୱ| ଭୱାନ୍ ଅମରେଶ୍ୱରସ୍ୟାଭିଷିକ୍ତ୍ତପୁତ୍ର ଇତି ୱିଶ୍ୱସ୍ୟ ନିଶ୍ଚିତଂ ଜାନୀମଃ| ");
INSERT INTO sanori_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","ତଦା ଯୀଶୁରୱଦତ୍ କିମହଂ ଯୁଷ୍ମାକଂ ଦ୍ୱାଦଶଜନାନ୍ ମନୋନୀତାନ୍ ନ କୃତୱାନ୍? କିନ୍ତୁ ଯୁଷ୍ମାକଂ ମଧ୍ୟେପି କଶ୍ଚିଦେକୋ ୱିଘ୍ନକାରୀ ୱିଦ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ଇମାଂ କଥଂ ସ ଶିମୋନଃ ପୁତ୍ରମ୍ ଈଷ୍କରୀଯୋତୀଯଂ ଯିହୂଦାମ୍ ଉଦ୍ଦିଶ୍ୟ କଥିତୱାନ୍ ଯତୋ ଦ୍ୱାଦଶାନାଂ ମଧ୍ୟେ ଗଣିତଃ ସ ତଂ ପରକରେଷୁ ସମର୍ପଯିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ତତଃ ପରଂ ଯିହୂଦୀଯଲୋକାସ୍ତଂ ହନ୍ତୁଂ ସମୈହନ୍ତ ତସ୍ମାଦ୍ ଯୀଶୁ ର୍ୟିହୂଦାପ୍ରଦେଶେ ପର୍ୟ୍ୟଟିତୁଂ ନେଚ୍ଛନ୍ ଗାଲୀଲ୍ ପ୍ରଦେଶେ ପର୍ୟ୍ୟଟିତୁଂ ପ୍ରାରଭତ| ");
INSERT INTO sanori_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","କିନ୍ତୁ ତସ୍ମିନ୍ ସମଯେ ଯିହୂଦୀଯାନାଂ ଦୂଷ୍ୟୱାସନାମୋତ୍ସୱ ଉପସ୍ଥିତେ ");
INSERT INTO sanori_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ତସ୍ୟ ଭ୍ରାତରସ୍ତମ୍ ଅୱଦନ୍ ଯାନି କର୍ମ୍ମାଣି ତ୍ୱଯା କ୍ରିଯନ୍ତେ ତାନି ଯଥା ତୱ ଶିଷ୍ୟାଃ ପଶ୍ୟନ୍ତି ତଦର୍ଥଂ ତ୍ୱମିତଃ ସ୍ଥାନାଦ୍ ଯିହୂଦୀଯଦେଶଂ ୱ୍ରଜ| ");
INSERT INTO sanori_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ଯଃ କଶ୍ଚିତ୍ ସ୍ୱଯଂ ପ୍ରଚିକାଶିଷତି ସ କଦାପି ଗୁପ୍ତଂ କର୍ମ୍ମ ନ କରୋତି ଯଦୀଦୃଶଂ କର୍ମ୍ମ କରୋଷି ତର୍ହି ଜଗତି ନିଜଂ ପରିଚାଯଯ| ");
INSERT INTO sanori_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ଯତସ୍ତସ୍ୟ ଭ୍ରାତରୋପି ତଂ ନ ୱିଶ୍ୱସନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","ତଦା ଯୀଶୁସ୍ତାନ୍ ଅୱୋଚତ୍ ମମ ସମଯ ଇଦାନୀଂ ନୋପତିଷ୍ଠତି କିନ୍ତୁ ଯୁଷ୍ମାକଂ ସମଯଃ ସତତମ୍ ଉପତିଷ୍ଠତି| ");
INSERT INTO sanori_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","ଜଗତୋ ଲୋକା ଯୁଷ୍ମାନ୍ ଋତୀଯିତୁଂ ନ ଶକ୍ରୁୱନ୍ତି କିନ୍ତୁ ମାମେୱ ଋତୀଯନ୍ତେ ଯତସ୍ତେଷାଂ କର୍ମାଣି ଦୁଷ୍ଟାନି ତତ୍ର ସାକ୍ଷ୍ୟମିଦମ୍ ଅହଂ ଦଦାମି| ");
INSERT INTO sanori_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","ଅତଏୱ ଯୂଯମ୍ ଉତ୍ସୱେଽସ୍ମିନ୍ ଯାତ ନାହମ୍ ଇଦାନୀମ୍ ଅସ୍ମିନ୍ନୁତ୍ସୱେ ଯାମି ଯତୋ ମମ ସମଯ ଇଦାନୀଂ ନ ସମ୍ପୂର୍ଣଃ| ");
INSERT INTO sanori_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ଇତି ୱାକ୍ୟମ୍ ଉକ୍ତ୍ତ୍ୱା ସ ଗାଲୀଲି ସ୍ଥିତୱାନ୍ ");
INSERT INTO sanori_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","କିନ୍ତୁ ତସ୍ୟ ଭ୍ରାତୃଷୁ ତତ୍ର ପ୍ରସ୍ଥିତେଷୁ ସତ୍ସୁ ସୋଽପ୍ରକଟ ଉତ୍ସୱମ୍ ଅଗଚ୍ଛତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","ଅନନ୍ତରମ୍ ଉତ୍ସୱମ୍ ଉପସ୍ଥିତା ଯିହୂଦୀଯାସ୍ତଂ ମୃଗଯିତ୍ୱାପୃଚ୍ଛନ୍ ସ କୁତ୍ର? ");
INSERT INTO sanori_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","ତତୋ ଲୋକାନାଂ ମଧ୍ୟେ ତସ୍ମିନ୍ ନାନାୱିଧା ୱିୱାଦା ଭୱିତୁମ୍ ଆରବ୍ଧୱନ୍ତଃ| କେଚିଦ୍ ଅୱୋଚନ୍ ସ ଉତ୍ତମଃ ପୁରୁଷଃ କେଚିଦ୍ ଅୱୋଚନ୍ ନ ତଥା ୱରଂ ଲୋକାନାଂ ଭ୍ରମଂ ଜନଯତି| ");
INSERT INTO sanori_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","କିନ୍ତୁ ଯିହୂଦୀଯାନାଂ ଭଯାତ୍ କୋପି ତସ୍ୟ ପକ୍ଷେ ସ୍ପଷ୍ଟଂ ନାକଥଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ତତଃ ପରମ୍ ଉତ୍ସୱସ୍ୟ ମଧ୍ୟସମଯେ ଯୀଶୁ ର୍ମନ୍ଦିରଂ ଗତ୍ୱା ସମୁପଦିଶତି ସ୍ମ| ");
INSERT INTO sanori_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ତତୋ ଯିହୂଦୀଯା ଲୋକା ଆଶ୍ଚର୍ୟ୍ୟଂ ଜ୍ଞାତ୍ୱାକଥଯନ୍ ଏଷା ମାନୁଷୋ ନାଧୀତ୍ୟା କଥମ୍ ଏତାଦୃଶୋ ୱିଦ୍ୱାନଭୂତ୍? ");
INSERT INTO sanori_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","ତଦା ଯୀଶୁଃ ପ୍ରତ୍ୟୱୋଚଦ୍ ଉପଦେଶୋଯଂ ନ ମମ କିନ୍ତୁ ଯୋ ମାଂ ପ୍ରେଷିତୱାନ୍ ତସ୍ୟ| ");
INSERT INTO sanori_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","ଯୋ ଜନୋ ନିଦେଶଂ ତସ୍ୟ ଗ୍ରହୀଷ୍ୟତି ମମୋପଦେଶୋ ମତ୍ତୋ ଭୱତି କିମ୍ ଈଶ୍ୱରାଦ୍ ଭୱତି ସ ଗନସ୍ତଜ୍ଜ୍ଞାତୁଂ ଶକ୍ଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","ଯୋ ଜନଃ ସ୍ୱତଃ କଥଯତି ସ ସ୍ୱୀଯଂ ଗୌରୱମ୍ ଈହତେ କିନ୍ତୁ ଯଃ ପ୍ରେରଯିତୁ ର୍ଗୌରୱମ୍ ଈହତେ ସ ସତ୍ୟୱାଦୀ ତସ୍ମିନ୍ କୋପ୍ୟଧର୍ମ୍ମୋ ନାସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","ମୂସା ଯୁଷ୍ମଭ୍ୟଂ ୱ୍ୟୱସ୍ଥାଗ୍ରନ୍ଥଂ କିଂ ନାଦଦାତ୍? କିନ୍ତୁ ଯୁଷ୍ମାକଂ କୋପି ତାଂ ୱ୍ୟୱସ୍ଥାଂ ନ ସମାଚରତି| ମାଂ ହନ୍ତୁଂ କୁତୋ ଯତଧ୍ୱେ? ");
INSERT INTO sanori_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","ତଦା ଲୋକା ଅୱଦନ୍ ତ୍ୱଂ ଭୂତଗ୍ରସ୍ତସ୍ତ୍ୱାଂ ହନ୍ତୁଂ କୋ ଯତତେ? ");
INSERT INTO sanori_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ତତୋ ଯୀଶୁରୱୋଚଦ୍ ଏକଂ କର୍ମ୍ମ ମଯାକାରି ତସ୍ମାଦ୍ ଯୂଯଂ ସର୍ୱ୍ୱ ମହାଶ୍ଚର୍ୟ୍ୟଂ ମନ୍ୟଧ୍ୱେ| ");
INSERT INTO sanori_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","ମୂସା ଯୁଷ୍ମଭ୍ୟଂ ତ୍ୱକ୍ଛେଦୱିଧିଂ ପ୍ରଦଦୌ ସ ମୂସାତୋ ନ ଜାତଃ କିନ୍ତୁ ପିତୃପୁରୁଷେଭ୍ୟୋ ଜାତଃ ତେନ ୱିଶ୍ରାମୱାରେଽପି ମାନୁଷାଣାଂ ତ୍ୱକ୍ଛେଦଂ କୁରୁଥ| ");
INSERT INTO sanori_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ଅତଏୱ ୱିଶ୍ରାମୱାରେ ମନୁଷ୍ୟାଣାଂ ତ୍ୱକ୍ଛେଦେ କୃତେ ଯଦି ମୂସାୱ୍ୟୱସ୍ଥାମଙ୍ଗନଂ ନ ଭୱତି ତର୍ହି ମଯା ୱିଶ୍ରାମୱାରେ ମାନୁଷଃ ସମ୍ପୂର୍ଣରୂପେଣ ସ୍ୱସ୍ଥୋଽକାରି ତତ୍କାରଣାଦ୍ ଯୂଯଂ କିଂ ମହ୍ୟଂ କୁପ୍ୟଥ? ");
INSERT INTO sanori_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","ସପକ୍ଷପାତଂ ୱିଚାରମକୃତ୍ୱା ନ୍ୟାଯ୍ୟଂ ୱିଚାରଂ କୁରୁତ| ");
INSERT INTO sanori_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","ତଦା ଯିରୂଶାଲମ୍ ନିୱାସିନଃ କତିପଯଜନା ଅକଥଯନ୍ ଇମେ ଯଂ ହନ୍ତୁଂ ଚେଷ୍ଟନ୍ତେ ସ ଏୱାଯଂ କିଂ ନ? ");
INSERT INTO sanori_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","କିନ୍ତୁ ପଶ୍ୟତ ନିର୍ଭଯଃ ସନ୍ କଥାଂ କଥଯତି ତଥାପି କିମପି ଅ ୱଦନ୍ତ୍ୟେତେ ଅଯମେୱାଭିଷିକ୍ତ୍ତୋ ଭୱତୀତି ନିଶ୍ଚିତଂ କିମଧିପତଯୋ ଜାନନ୍ତି? ");
INSERT INTO sanori_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","ମନୁଜୋଯଂ କସ୍ମାଦାଗମଦ୍ ଇତି ୱଯଂ ଜାନୋମଃ କିନ୍ତ୍ୱଭିଷିକ୍ତ୍ତ ଆଗତେ ସ କସ୍ମାଦାଗତୱାନ୍ ଇତି କୋପି ଜ୍ଞାତୁଂ ନ ଶକ୍ଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","ତଦା ଯୀଶୁ ର୍ମଧ୍ୟେମନ୍ଦିରମ୍ ଉପଦିଶନ୍ ଉଚ୍ଚୈଃକାରମ୍ ଉକ୍ତ୍ତୱାନ୍ ଯୂଯଂ କିଂ ମାଂ ଜାନୀଥ? କସ୍ମାଚ୍ଚାଗତୋସ୍ମି ତଦପି କିଂ ଜାନୀଥ? ନାହଂ ସ୍ୱତ ଆଗତୋସ୍ମି କିନ୍ତୁ ଯଃ ସତ୍ୟୱାଦୀ ସଏୱ ମାଂ ପ୍ରେଷିତୱାନ୍ ଯୂଯଂ ତଂ ନ ଜାନୀଥ| ");
INSERT INTO sanori_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ତମହଂ ଜାନେ ତେନାହଂ ପ୍ରେରିତ ଅଗତୋସ୍ମି| ");
INSERT INTO sanori_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","ତସ୍ମାଦ୍ ଯିହୂଦୀଯାସ୍ତଂ ଧର୍ତ୍ତୁମ୍ ଉଦ୍ୟତାସ୍ତଥାପି କୋପି ତସ୍ୟ ଗାତ୍ରେ ହସ୍ତଂ ନାର୍ପଯଦ୍ ଯତୋ ହେତୋସ୍ତଦା ତସ୍ୟ ସମଯୋ ନୋପତିଷ୍ଠତି| ");
INSERT INTO sanori_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","କିନ୍ତୁ ବହୱୋ ଲୋକାସ୍ତସ୍ମିନ୍ ୱିଶ୍ୱସ୍ୟ କଥିତୱାନ୍ତୋଽଭିଷିକ୍ତ୍ତପୁରୁଷ ଆଗତ୍ୟ ମାନୁଷସ୍ୟାସ୍ୟ କ୍ରିଯାଭ୍ୟଃ କିମ୍ ଅଧିକା ଆଶ୍ଚର୍ୟ୍ୟାଃ କ୍ରିଯାଃ କରିଷ୍ୟତି? ");
INSERT INTO sanori_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","ତତଃ ପରଂ ଲୋକାସ୍ତସ୍ମିନ୍ ଇତ୍ଥଂ ୱିୱଦନ୍ତେ ଫିରୂଶିନଃ ପ୍ରଧାନଯାଜକାଞ୍ଚେତି ଶ୍ରୁତୱନ୍ତସ୍ତଂ ଧୃତ୍ୱା ନେତୁଂ ପଦାତିଗଣଂ ପ୍ରେଷଯାମାସୁଃ| ");
INSERT INTO sanori_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ତତୋ ଯୀଶୁରୱଦଦ୍ ଅହମ୍ ଅଲ୍ପଦିନାନି ଯୁଷ୍ମାଭିଃ ସାର୍ଦ୍ଧଂ ସ୍ଥିତ୍ୱା ମତ୍ପ୍ରେରଯିତୁଃ ସମୀପଂ ଯାସ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","ମାଂ ମୃଗଯିଷ୍ୟଧ୍ୱେ କିନ୍ତୂଦ୍ଦେଶଂ ନ ଲପ୍ସ୍ୟଧ୍ୱେ ରତ୍ର ସ୍ଥାସ୍ୟାମି ତତ୍ର ଯୂଯଂ ଗନ୍ତୁଂ ନ ଶକ୍ଷ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","ତଦା ଯିହୂଦୀଯାଃ ପରସ୍ପରଂ ୱକ୍ତ୍ତୁମାରେଭିରେ ଅସ୍ୟୋଦ୍ଦେଶଂ ନ ପ୍ରାପ୍ସ୍ୟାମ ଏତାଦୃଶଂ କିଂ ସ୍ଥାନଂ ଯାସ୍ୟତି? ଭିନ୍ନଦେଶେ ୱିକୀର୍ଣାନାଂ ଯିହୂଦୀଯାନାଂ ସନ୍ନିଧିମ୍ ଏଷ ଗତ୍ୱା ତାନ୍ ଉପଦେକ୍ଷ୍ୟତି କିଂ? ");
INSERT INTO sanori_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","ନୋ ଚେତ୍ ମାଂ ଗୱେଷଯିଷ୍ୟଥ କିନ୍ତୂଦ୍ଦେଶଂ ନ ପ୍ରାପ୍ସ୍ୟଥ ଏଷ କୋଦୃଶଂ ୱାକ୍ୟମିଦଂ ୱଦତି? ");
INSERT INTO sanori_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","ଅନନ୍ତରମ୍ ଉତ୍ସୱସ୍ୟ ଚରମେଽହନି ଅର୍ଥାତ୍ ପ୍ରଧାନଦିନେ ଯୀଶୁରୁତ୍ତିଷ୍ଠନ୍ ଉଚ୍ଚୈଃକାରମ୍ ଆହ୍ୱଯନ୍ ଉଦିତୱାନ୍ ଯଦି କଶ୍ଚିତ୍ ତୃଷାର୍ତ୍ତୋ ଭୱତି ତର୍ହି ମମାନ୍ତିକମ୍ ଆଗତ୍ୟ ପିୱତୁ| ");
INSERT INTO sanori_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ଯଃ କଶ୍ଚିନ୍ମଯି ୱିଶ୍ୱସିତି ଧର୍ମ୍ମଗ୍ରନ୍ଥସ୍ୟ ୱଚନାନୁସାରେଣ ତସ୍ୟାଭ୍ୟନ୍ତରତୋଽମୃତତୋଯସ୍ୟ ସ୍ରୋତାଂସି ନିର୍ଗମିଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ଯେ ତସ୍ମିନ୍ ୱିଶ୍ୱସନ୍ତି ତ ଆତ୍ମାନଂ ପ୍ରାପ୍ସ୍ୟନ୍ତୀତ୍ୟର୍ଥେ ସ ଇଦଂ ୱାକ୍ୟଂ ୱ୍ୟାହୃତୱାନ୍ ଏତତ୍କାଲଂ ଯାୱଦ୍ ଯୀଶୁ ର୍ୱିଭୱଂ ନ ପ୍ରାପ୍ତସ୍ତସ୍ମାତ୍ ପୱିତ୍ର ଆତ୍ମା ନାଦୀଯତ| ");
INSERT INTO sanori_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ଏତାଂ ୱାଣୀଂ ଶ୍ରୁତ୍ୱା ବହୱୋ ଲୋକା ଅୱଦନ୍ ଅଯମେୱ ନିଶ୍ଚିତଂ ସ ଭୱିଷ୍ୟଦ୍ୱାଦୀ| ");
INSERT INTO sanori_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","କେଚିଦ୍ ଅକଥଯନ୍ ଏଷଏୱ ସୋଭିଷିକ୍ତ୍ତଃ କିନ୍ତୁ କେଚିଦ୍ ଅୱଦନ୍ ସୋଭିଷିକ୍ତ୍ତଃ କିଂ ଗାଲୀଲ୍ ପ୍ରଦେଶେ ଜନିଷ୍ୟତେ? ");
INSERT INTO sanori_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","ସୋଭିଷିକ୍ତ୍ତୋ ଦାଯୂଦୋ ୱଂଶେ ଦାଯୂଦୋ ଜନ୍ମସ୍ଥାନେ ବୈତ୍ଲେହମି ପତ୍ତନେ ଜନିଷ୍ୟତେ ଧର୍ମ୍ମଗ୍ରନ୍ଥେ କିମିତ୍ଥଂ ଲିଖିତଂ ନାସ୍ତି? ");
INSERT INTO sanori_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ଇତ୍ଥଂ ତସ୍ମିନ୍ ଲୋକାନାଂ ଭିନ୍ନୱାକ୍ୟତା ଜାତା| ");
INSERT INTO sanori_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","କତିପଯଲୋକାସ୍ତଂ ଧର୍ତ୍ତୁମ୍ ଐଚ୍ଛନ୍ ତଥାପି ତଦ୍ୱପୁଷି କୋପି ହସ୍ତଂ ନାର୍ପଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","ଅନନ୍ତରଂ ପାଦାତିଗଣେ ପ୍ରଧାନଯାଜକାନାଂ ଫିରୂଶିନାଞ୍ଚ ସମୀପମାଗତୱତି ତେ ତାନ୍ ଅପୃଚ୍ଛନ୍ କୁତୋ ହେତୋସ୍ତଂ ନାନଯତ? ");
INSERT INTO sanori_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","ତଦା ପଦାତଯଃ ପ୍ରତ୍ୟୱଦନ୍ ସ ମାନୱ ଇୱ କୋପି କଦାପି ନୋପାଦିଶତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ତତଃ ଫିରୂଶିନଃ ପ୍ରାୱୋଚନ୍ ଯୂଯମପି କିମଭ୍ରାମିଷ୍ଟ? ");
INSERT INTO sanori_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","ଅଧିପତୀନାଂ ଫିରୂଶିନାଞ୍ଚ କୋପି କିଂ ତସ୍ମିନ୍ ୱ୍ୟଶ୍ୱସୀତ୍? ");
INSERT INTO sanori_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ଯେ ଶାସ୍ତ୍ରଂ ନ ଜାନନ୍ତି ତ ଇମେଽଧମଲୋକାଏୱ ଶାପଗ୍ରସ୍ତାଃ| ");
INSERT INTO sanori_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ତଦା ନିକଦୀମନାମା ତେଷାମେକୋ ଯଃ କ୍ଷଣଦାଯାଂ ଯୀଶୋଃ ସନ୍ନିଧିମ୍ ଅଗାତ୍ ସ ଉକ୍ତ୍ତୱାନ୍ ");
INSERT INTO sanori_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","ତସ୍ୟ ୱାକ୍ୟେ ନ ଶ୍ରୁତେ କର୍ମ୍ମଣି ଚ ନ ୱିଦିତେ ଽସ୍ମାକଂ ୱ୍ୟୱସ୍ଥା କିଂ କଞ୍ଚନ ମନୁଜଂ ଦୋଷୀକରୋତି? ");
INSERT INTO sanori_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ତତସ୍ତେ ୱ୍ୟାହରନ୍ ତ୍ୱମପି କିଂ ଗାଲୀଲୀଯଲୋକଃ? ୱିୱିଚ୍ୟ ପଶ୍ୟ ଗଲୀଲି କୋପି ଭୱିଷ୍ୟଦ୍ୱାଦୀ ନୋତ୍ପଦ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","ତତଃ ପରଂ ସର୍ୱ୍ୱେ ସ୍ୱଂ ସ୍ୱଂ ଗୃହଂ ଗତାଃ କିନ୍ତୁ ଯୀଶୁ ର୍ଜୈତୁନନାମାନଂ ଶିଲୋଚ୍ଚଯଂ ଗତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ପ୍ରତ୍ୟୂଷେ ଯୀଶୁଃ ପନର୍ମନ୍ଦିରମ୍ ଆଗଚ୍ଛତ୍ ");
INSERT INTO sanori_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ତତଃ ସର୍ୱ୍ୱେଷୁ ଲୋକେଷୁ ତସ୍ୟ ସମୀପ ଆଗତେଷୁ ସ ଉପୱିଶ୍ୟ ତାନ୍ ଉପଦେଷ୍ଟୁମ୍ ଆରଭତ| ");
INSERT INTO sanori_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ତଦା ଅଧ୍ୟାପକାଃ ଫିରୂଶିନଞ୍ଚ ୱ୍ୟଭିଚାରକର୍ମ୍ମଣି ଧୃତଂ ସ୍ତ୍ରିଯମେକାମ୍ ଆନିଯ ସର୍ୱ୍ୱେଷାଂ ମଧ୍ୟେ ସ୍ଥାପଯିତ୍ୱା ୱ୍ୟାହରନ୍ ");
INSERT INTO sanori_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ହେ ଗୁରୋ ଯୋଷିତମ୍ ଇମାଂ ୱ୍ୟଭିଚାରକର୍ମ୍ମ କୁର୍ୱ୍ୱାଣାଂ ଲୋକା ଧୃତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ଏତାଦୃଶଲୋକାଃ ପାଷାଣାଘାତେନ ହନ୍ତୱ୍ୟା ଇତି ୱିଧିର୍ମୂସାୱ୍ୟୱସ୍ଥାଗ୍ରନ୍ଥେ ଲିଖିତୋସ୍ତି କିନ୍ତୁ ଭୱାନ୍ କିମାଦିଶତି? ");
INSERT INTO sanori_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","ତେ ତମପୱଦିତୁଂ ପରୀକ୍ଷାଭିପ୍ରାଯେଣ ୱାକ୍ୟମିଦମ୍ ଅପୃଚ୍ଛନ୍ କିନ୍ତୁ ସ ପ୍ରହ୍ୱୀଭୂଯ ଭୂମାୱଙ୍ଗଲ୍ୟା ଲେଖିତୁମ୍ ଆରଭତ| ");
INSERT INTO sanori_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ତତସ୍ତୈଃ ପୁନଃ ପୁନଃ ପୃଷ୍ଟ ଉତ୍ଥାଯ କଥିତୱାନ୍ ଯୁଷ୍ମାକଂ ମଧ୍ୟେ ଯୋ ଜନୋ ନିରପରାଧୀ ସଏୱ ପ୍ରଥମମ୍ ଏନାଂ ପାଷାଣେନାହନ୍ତୁ| ");
INSERT INTO sanori_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ପଶ୍ଚାତ୍ ସ ପୁନଶ୍ଚ ପ୍ରହ୍ୱୀଭୂଯ ଭୂମୌ ଲେଖିତୁମ୍ ଆରଭତ| ");
INSERT INTO sanori_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ତାଂ କଥଂ ଶ୍ରୁତ୍ୱା ତେ ସ୍ୱସ୍ୱମନସି ପ୍ରବୋଧଂ ପ୍ରାପ୍ୟ ଜ୍ୟେଷ୍ଠାନୁକ୍ରମଂ ଏକୈକଶଃ ସର୍ୱ୍ୱେ ବହିରଗଚ୍ଛନ୍ ତତୋ ଯୀଶୁରେକାକୀ ତଯକ୍ତ୍ତୋଭୱତ୍ ମଧ୍ୟସ୍ଥାନେ ଦଣ୍ଡାଯମାନା ସା ଯୋଷା ଚ ସ୍ଥିତା| ");
INSERT INTO sanori_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ତତ୍ପଶ୍ଚାଦ୍ ଯୀଶୁରୁତ୍ଥାଯ ତାଂ ୱନିତାଂ ୱିନା କମପ୍ୟପରଂ ନ ୱିଲୋକ୍ୟ ପୃଷ୍ଟୱାନ୍ ହେ ୱାମେ ତୱାପୱାଦକାଃ କୁତ୍ର? କୋପି ତ୍ୱାଂ କିଂ ନ ଦଣ୍ଡଯତି? ");
INSERT INTO sanori_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","ସାୱଦତ୍ ହେ ମହେଚ୍ଛ କୋପି ନ ତଦା ଯୀଶୁରୱୋଚତ୍ ନାହମପି ଦଣ୍ଡଯାମି ଯାହି ପୁନଃ ପାପଂ ମାକାର୍ଷୀଃ| ");
INSERT INTO sanori_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ତତୋ ଯୀଶୁଃ ପୁନରପି ଲୋକେଭ୍ୟ ଇତ୍ଥଂ କଥଯିତୁମ୍ ଆରଭତ ଜଗତୋହଂ ଜ୍ୟୋତିଃସ୍ୱରୂପୋ ଯଃ କଶ୍ଚିନ୍ ମତ୍ପଶ୍ଚାଦ ଗଚ୍ଛତି ସ ତିମିରେ ନ ଭ୍ରମିତ୍ୱା ଜୀୱନରୂପାଂ ଦୀପ୍ତିଂ ପ୍ରାପ୍ସ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ତତଃ ଫିରୂଶିନୋଽୱାଦିଷୁସ୍ତ୍ୱଂ ସ୍ୱାର୍ଥେ ସ୍ୱଯଂ ସାକ୍ଷ୍ୟଂ ଦଦାସି ତସ୍ମାତ୍ ତୱ ସାକ୍ଷ୍ୟଂ ଗ୍ରାହ୍ୟଂ ନ ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","ତଦା ଯୀଶୁଃ ପ୍ରତ୍ୟୁଦିତୱାନ୍ ଯଦ୍ୟପି ସ୍ୱାର୍ଥେଽହଂ ସ୍ୱଯଂ ସାକ୍ଷ୍ୟଂ ଦଦାମି ତଥାପି ମତ୍ ସାକ୍ଷ୍ୟଂ ଗ୍ରାହ୍ୟଂ ଯସ୍ମାଦ୍ ଅହଂ କୁତ ଆଗତୋସ୍ମି କ୍ୱ ଯାମି ଚ ତଦହଂ ଜାନାମି କିନ୍ତୁ କୁତ ଆଗତୋସ୍ମି କୁତ୍ର ଗଚ୍ଛାମି ଚ ତଦ୍ ଯୂଯଂ ନ ଜାନୀଥ| ");
INSERT INTO sanori_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","ଯୂଯଂ ଲୌକିକଂ ୱିଚାରଯଥ ନାହଂ କିମପି ୱିଚାରଯାମି| ");
INSERT INTO sanori_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","କିନ୍ତୁ ଯଦି ୱିଚାରଯାମି ତର୍ହି ମମ ୱିଚାରୋ ଗ୍ରହୀତୱ୍ୟୋ ଯତୋହମ୍ ଏକାକୀ ନାସ୍ମି ପ୍ରେରଯିତା ପିତା ମଯା ସହ ୱିଦ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","ଦ୍ୱଯୋ ର୍ଜନଯୋଃ ସାକ୍ଷ୍ୟଂ ଗ୍ରହଣୀଯଂ ଭୱତୀତି ଯୁଷ୍ମାକଂ ୱ୍ୟୱସ୍ଥାଗ୍ରନ୍ଥେ ଲିଖିତମସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ଅହଂ ସ୍ୱାର୍ଥେ ସ୍ୱଯଂ ସାକ୍ଷିତ୍ୱଂ ଦଦାମି ଯଶ୍ଚ ମମ ତାତୋ ମାଂ ପ୍ରେରିତୱାନ୍ ସୋପି ମଦର୍ଥେ ସାକ୍ଷ୍ୟଂ ଦଦାତି| ");
INSERT INTO sanori_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ତଦା ତେଽପୃଚ୍ଛନ୍ ତୱ ତାତଃ କୁତ୍ର? ତତୋ ଯୀଶୁଃ ପ୍ରତ୍ୟୱାଦୀଦ୍ ଯୂଯଂ ମାଂ ନ ଜାନୀଥ ମତ୍ପିତରଞ୍ଚ ନ ଜାନୀଥ ଯଦି ମାମ୍ ଅକ୍ଷାସ୍ୟତ ତର୍ହି ମମ ତାତମପ୍ୟକ୍ଷାସ୍ୟତ| ");
INSERT INTO sanori_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ଯୀଶୁ ର୍ମନ୍ଦିର ଉପଦିଶ୍ୟ ଭଣ୍ଡାଗାରେ କଥା ଏତା ଅକଥଯତ୍ ତଥାପି ତଂ ପ୍ରତି କୋପି କରଂ ନୋଦତୋଲଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ତତଃ ପରଂ ଯୀଶୁଃ ପୁନରୁଦିତୱାନ୍ ଅଧୁନାହଂ ଗଚ୍ଛାମି ଯୂଯଂ ମାଂ ଗୱେଷଯିଷ୍ୟଥ କିନ୍ତୁ ନିଜୈଃ ପାପୈ ର୍ମରିଷ୍ୟଥ ଯତ୍ ସ୍ଥାନମ୍ ଅହଂ ଯାସ୍ୟାମି ତତ୍ ସ୍ଥାନମ୍ ଯୂଯଂ ଯାତୁଂ ନ ଶକ୍ଷ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","ତଦା ଯିହୂଦୀଯାଃ ପ୍ରାୱୋଚନ୍ କିମଯମ୍ ଆତ୍ମଘାତଂ କରିଷ୍ୟତି? ଯତୋ ଯତ୍ ସ୍ଥାନମ୍ ଅହଂ ଯାସ୍ୟାମି ତତ୍ ସ୍ଥାନମ୍ ଯୂଯଂ ଯାତୁଂ ନ ଶକ୍ଷ୍ୟଥ ଇତି ୱାକ୍ୟଂ ବ୍ରୱୀତି| ");
INSERT INTO sanori_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ତତୋ ଯୀଶୁସ୍ତେଭ୍ୟଃ କଥିତୱାନ୍ ଯୂଯମ୍ ଅଧଃସ୍ଥାନୀଯା ଲୋକା ଅହମ୍ ଊର୍ଦ୍ୱ୍ୱସ୍ଥାନୀଯଃ ଯୂଯମ୍ ଏତଜ୍ଜଗତ୍ସମ୍ବନ୍ଧୀଯା ଅହମ୍ ଏତଜ୍ଜଗତ୍ସମ୍ବନ୍ଧୀଯୋ ନ| ");
INSERT INTO sanori_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","ତସ୍ମାତ୍ କଥିତୱାନ୍ ଯୂଯଂ ନିଜୈଃ ପାପୈ ର୍ମରିଷ୍ୟଥ ଯତୋହଂ ସ ପୁମାନ୍ ଇତି ଯଦି ନ ୱିଶ୍ୱସିଥ ତର୍ହି ନିଜୈଃ ପାପୈ ର୍ମରିଷ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ତଦା ତେ ଽପୃଚ୍ଛନ୍ କସ୍ତ୍ୱଂ? ତତୋ ଯୀଶୁଃ କଥିତୱାନ୍ ଯୁଷ୍ମାକଂ ସନ୍ନିଧୌ ଯସ୍ୟ ପ୍ରସ୍ତାୱମ୍ ଆ ପ୍ରଥମାତ୍ କରୋମି ସଏୱ ପୁରୁଷୋହଂ| ");
INSERT INTO sanori_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","ଯୁଷ୍ମାସୁ ମଯା ବହୁୱାକ୍ୟଂ ୱକ୍ତ୍ତୱ୍ୟଂ ୱିଚାରଯିତୱ୍ୟଞ୍ଚ କିନ୍ତୁ ମତ୍ପ୍ରେରଯିତା ସତ୍ୟୱାଦୀ ତସ୍ୟ ସମୀପେ ଯଦହଂ ଶ୍ରୁତୱାନ୍ ତଦେୱ ଜଗତେ କଥଯାମି| ");
INSERT INTO sanori_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","କିନ୍ତୁ ସ ଜନକେ ୱାକ୍ୟମିଦଂ ପ୍ରୋକ୍ତ୍ତୱାନ୍ ଇତି ତେ ନାବୁଧ୍ୟନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ତତୋ ଯୀଶୁରକଥଯଦ୍ ଯଦା ମନୁଷ୍ୟପୁତ୍ରମ୍ ଊର୍ଦ୍ୱ୍ୱ ଉତ୍ଥାପଯିଷ୍ୟଥ ତଦାହଂ ସ ପୁମାନ୍ କେୱଲଃ ସ୍ୱଯଂ କିମପି କର୍ମ୍ମ ନ କରୋମି କିନ୍ତୁ ତାତୋ ଯଥା ଶିକ୍ଷଯତି ତଦନୁସାରେଣ ୱାକ୍ୟମିଦଂ ୱଦାମୀତି ଚ ଯୂଯଂ ଜ୍ଞାତୁଂ ଶକ୍ଷ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","ମତ୍ପ୍ରେରଯିତା ପିତା ମାମ୍ ଏକାକିନଂ ନ ତ୍ୟଜତି ସ ମଯା ସାର୍ଦ୍ଧଂ ତିଷ୍ଠତି ଯତୋହଂ ତଦଭିମତଂ କର୍ମ୍ମ ସଦା କରୋମି| ");
INSERT INTO sanori_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","ତଦା ତସ୍ୟୈତାନି ୱାକ୍ୟାନି ଶ୍ରୁତ୍ୱା ବହୁୱସ୍ତାସ୍ମିନ୍ ୱ୍ୟଶ୍ୱସନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","ଯେ ଯିହୂଦୀଯା ୱ୍ୟଶ୍ୱସନ୍ ଯୀଶୁସ୍ତେଭ୍ୟୋଽକଥଯତ୍ ");
INSERT INTO sanori_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ମମ ୱାକ୍ୟେ ଯଦି ଯୂଯମ୍ ଆସ୍ଥାଂ କୁରୁଥ ତର୍ହି ମମ ଶିଷ୍ୟା ଭୂତ୍ୱା ସତ୍ୟତ୍ୱଂ ଜ୍ଞାସ୍ୟଥ ତତଃ ସତ୍ୟତଯା ଯୁଷ୍ମାକଂ ମୋକ୍ଷୋ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","ତଦା ତେ ପ୍ରତ୍ୟୱାଦିଷୁଃ ୱଯମ୍ ଇବ୍ରାହୀମୋ ୱଂଶଃ କଦାପି କସ୍ୟାପି ଦାସା ନ ଜାତାସ୍ତର୍ହି ଯୁଷ୍ମାକଂ ମୁକ୍ତ୍ତି ର୍ଭୱିଷ୍ୟତୀତି ୱାକ୍ୟଂ କଥଂ ବ୍ରୱୀଷି? ");
INSERT INTO sanori_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","ତଦା ଯୀଶୁଃ ପ୍ରତ୍ୟୱଦଦ୍ ଯୁଷ୍ମାନହଂ ଯଥାର୍ଥତରଂ ୱଦାମି ଯଃ ପାପଂ କରୋତି ସ ପାପସ୍ୟ ଦାସଃ| ");
INSERT INTO sanori_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","ଦାସଶ୍ଚ ନିରନ୍ତରଂ ନିୱେଶନେ ନ ତିଷ୍ଠତି କିନ୍ତୁ ପୁତ୍ରୋ ନିରନ୍ତରଂ ତିଷ୍ଠତି| ");
INSERT INTO sanori_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","ଅତଃ ପୁତ୍ରୋ ଯଦି ଯୁଷ୍ମାନ୍ ମୋଚଯତି ତର୍ହି ନିତାନ୍ତମେୱ ମୁକ୍ତ୍ତା ଭୱିଷ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","ଯୁଯମ୍ ଇବ୍ରାହୀମୋ ୱଂଶ ଇତ୍ୟହଂ ଜାନାମି କିନ୍ତୁ ମମ କଥା ଯୁଷ୍ମାକମ୍ ଅନ୍ତଃକରଣେଷୁ ସ୍ଥାନଂ ନ ପ୍ରାପ୍ନୁୱନ୍ତି ତସ୍ମାଦ୍ଧେତୋ ର୍ମାଂ ହନ୍ତୁମ୍ ଈହଧ୍ୱେ| ");
INSERT INTO sanori_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ଅହଂ ସ୍ୱପିତୁଃ ସମୀପେ ଯଦପଶ୍ୟଂ ତଦେୱ କଥଯାମି ତଥା ଯୂଯମପି ସ୍ୱପିତୁଃ ସମୀପେ ଯଦପଶ୍ୟତ ତଦେୱ କୁରୁଧ୍ୱେ| ");
INSERT INTO sanori_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","ତଦା ତେ ପ୍ରତ୍ୟୱୋଚନ୍ ଇବ୍ରାହୀମ୍ ଅସ୍ମାକଂ ପିତା ତତୋ ଯୀଶୁରକଥଯଦ୍ ଯଦି ଯୂଯମ୍ ଇବ୍ରାହୀମଃ ସନ୍ତାନା ଅଭୱିଷ୍ୟତ ତର୍ହି ଇବ୍ରାହୀମ ଆଚାରଣୱଦ୍ ଆଚରିଷ୍ୟତ| ");
INSERT INTO sanori_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ଈଶ୍ୱରସ୍ୟ ମୁଖାତ୍ ସତ୍ୟଂ ୱାକ୍ୟଂ ଶ୍ରୁତ୍ୱା ଯୁଷ୍ମାନ୍ ଜ୍ଞାପଯାମି ଯୋହଂ ତଂ ମାଂ ହନ୍ତୁଂ ଚେଷ୍ଟଧ୍ୱେ ଇବ୍ରାହୀମ୍ ଏତାଦୃଶଂ କର୍ମ୍ମ ନ ଚକାର| ");
INSERT INTO sanori_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","ଯୂଯଂ ସ୍ୱସ୍ୱପିତୁଃ କର୍ମ୍ମାଣି କୁରୁଥ ତଦା ତୈରୁକ୍ତ୍ତଂ ନ ୱଯଂ ଜାରଜାତା ଅସ୍ମାକମ୍ ଏକଏୱ ପିତାସ୍ତି ସ ଏୱେଶ୍ୱରଃ ");
INSERT INTO sanori_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ତତୋ ଯୀଶୁନା କଥିତମ୍ ଈଶ୍ୱରୋ ଯଦି ଯୁଷ୍ମାକଂ ତାତୋଭୱିଷ୍ୟତ୍ ତର୍ହି ଯୂଯଂ ମଯି ପ୍ରେମାକରିଷ୍ୟତ ଯତୋହମ୍ ଈଶ୍ୱରାନ୍ନିର୍ଗତ୍ୟାଗତୋସ୍ମି ସ୍ୱତୋ ନାଗତୋହଂ ସ ମାଂ ପ୍ରାହିଣୋତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","ଯୂଯଂ ମମ ୱାକ୍ୟମିଦଂ ନ ବୁଧ୍ୟଧ୍ୱେ କୁତଃ? ଯତୋ ଯୂଯଂ ମମୋପଦେଶଂ ସୋଢୁଂ ନ ଶକ୍ନୁଥ| ");
INSERT INTO sanori_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","ଯୂଯଂ ଶୈତାନ୍ ପିତୁଃ ସନ୍ତାନା ଏତସ୍ମାଦ୍ ଯୁଷ୍ମାକଂ ପିତୁରଭିଲାଷଂ ପୂରଯଥ ସ ଆ ପ୍ରଥମାତ୍ ନରଘାତୀ ତଦନ୍ତଃ ସତ୍ୟତ୍ୱସ୍ୟ ଲେଶୋପି ନାସ୍ତି କାରଣାଦତଃ ସ ସତ୍ୟତାଯାଂ ନାତିଷ୍ଠତ୍ ସ ଯଦା ମୃଷା କଥଯତି ତଦା ନିଜସ୍ୱଭାୱାନୁସାରେଣୈୱ କଥଯତି ଯତୋ ସ ମୃଷାଭାଷୀ ମୃଷୋତ୍ପାଦକଶ୍ଚ| ");
INSERT INTO sanori_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","ଅହଂ ତଥ୍ୟୱାକ୍ୟଂ ୱଦାମି କାରଣାଦସ୍ମାଦ୍ ଯୂଯଂ ମାଂ ନ ପ୍ରତୀଥ| ");
INSERT INTO sanori_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","ମଯି ପାପମସ୍ତୀତି ପ୍ରମାଣଂ ଯୁଷ୍ମାକଂ କୋ ଦାତୁଂ ଶକ୍ନୋତି? ଯଦ୍ୟହଂ ତଥ୍ୟୱାକ୍ୟଂ ୱଦାମି ତର୍ହି କୁତୋ ମାଂ ନ ପ୍ରତିଥ? ");
INSERT INTO sanori_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ଯଃ କଶ୍ଚନ ଈଶ୍ୱରୀଯୋ ଲୋକଃ ସ ଈଶ୍ୱରୀଯକଥାଯାଂ ମନୋ ନିଧତ୍ତେ ଯୂଯମ୍ ଈଶ୍ୱରୀଯଲୋକା ନ ଭୱଥ ତନ୍ନିଦାନାତ୍ ତତ୍ର ନ ମନାଂସି ନିଧଦ୍ୱେ| ");
INSERT INTO sanori_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","ତଦା ଯିହୂଦୀଯାଃ ପ୍ରତ୍ୟୱାଦିଷୁଃ ତ୍ୱମେକଃ ଶୋମିରୋଣୀଯୋ ଭୂତଗ୍ରସ୍ତଶ୍ଚ ୱଯଂ କିମିଦଂ ଭଦ୍ରଂ ନାୱାଦିଷ୍ମ? ");
INSERT INTO sanori_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ତତୋ ଯୀଶୁଃ ପ୍ରତ୍ୟୱାଦୀତ୍ ନାହଂ ଭୂତଗ୍ରସ୍ତଃ କିନ୍ତୁ ନିଜତାତଂ ସମ୍ମନ୍ୟେ ତସ୍ମାଦ୍ ଯୂଯଂ ମାମ୍ ଅପମନ୍ୟଧ୍ୱେ| ");
INSERT INTO sanori_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","ଅହଂ ସ୍ୱସୁଖ୍ୟାତିଂ ନ ଚେଷ୍ଟେ କିନ୍ତୁ ଚେଷ୍ଟିତା ୱିଚାରଯିତା ଚାପର ଏକ ଆସ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ଅହଂ ଯୁଷ୍ମଭ୍ୟମ୍ ଅତୀୱ ଯଥାର୍ଥଂ କଥଯାମି ଯୋ ନରୋ ମଦୀଯଂ ୱାଚଂ ମନ୍ୟତେ ସ କଦାଚନ ନିଧନଂ ନ ଦ୍ରକ୍ଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","ଯିହୂଦୀଯାସ୍ତମୱଦନ୍ ତ୍ୱଂ ଭୂତଗ୍ରସ୍ତ ଇତୀଦାନୀମ୍ ଅୱୈଷ୍ମ| ଇବ୍ରାହୀମ୍ ଭୱିଷ୍ୟଦ୍ୱାଦିନଞ୍ଚ ସର୍ୱ୍ୱେ ମୃତାଃ କିନ୍ତୁ ତ୍ୱଂ ଭାଷସେ ଯୋ ନରୋ ମମ ଭାରତୀଂ ଗୃହ୍ଲାତି ସ ଜାତୁ ନିଧାନାସ୍ୱାଦଂ ନ ଲପ୍ସ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","ତର୍ହି ତ୍ୱଂ କିମ୍ ଅସ୍ମାକଂ ପୂର୍ୱ୍ୱପୁରୁଷାଦ୍ ଇବ୍ରାହୀମୋପି ମହାନ୍? ଯସ୍ମାତ୍ ସୋପି ମୃତଃ ଭୱିଷ୍ୟଦ୍ୱାଦିନୋପି ମୃତାଃ ତ୍ୱଂ ସ୍ୱଂ କଂ ପୁମାଂସଂ ମନୁଷେ? ");
INSERT INTO sanori_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","ଯୀଶୁଃ ପ୍ରତ୍ୟୱୋଚଦ୍ ଯଦ୍ୟହଂ ସ୍ୱଂ ସ୍ୱଯଂ ସମ୍ମନ୍ୟେ ତର୍ହି ମମ ତତ୍ ସମ୍ମନନଂ କିମପି ନ କିନ୍ତୁ ମମ ତାତୋ ଯଂ ଯୂଯଂ ସ୍ୱୀଯମ୍ ଈଶ୍ୱରଂ ଭାଷଧ୍ୱେ ସଏୱ ମାଂ ସମ୍ମନୁତେ| ");
INSERT INTO sanori_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ଯୂଯଂ ତଂ ନାୱଗଚ୍ଛଥ କିନ୍ତ୍ୱହଂ ତମୱଗଚ୍ଛାମି ତଂ ନାୱଗଚ୍ଛାମୀତି ୱାକ୍ୟଂ ଯଦି ୱଦାମି ତର୍ହି ଯୂଯମିୱ ମୃଷାଭାଷୀ ଭୱାମି କିନ୍ତ୍ୱହଂ ତମୱଗଚ୍ଛାମି ତଦାକ୍ଷାମପି ଗୃହ୍ଲାମି| ");
INSERT INTO sanori_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","ଯୁଷ୍ମାକଂ ପୂର୍ୱ୍ୱପୁରୁଷ ଇବ୍ରାହୀମ୍ ମମ ସମଯଂ ଦ୍ରଷ୍ଟୁମ୍ ଅତୀୱାୱାଞ୍ଛତ୍ ତନ୍ନିରୀକ୍ଷ୍ୟାନନ୍ଦଚ୍ଚ| ");
INSERT INTO sanori_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","ତଦା ଯିହୂଦୀଯା ଅପୃଚ୍ଛନ୍ ତୱ ୱଯଃ ପଞ୍ଚାଶଦ୍ୱତ୍ସରା ନ ତ୍ୱଂ କିମ୍ ଇବ୍ରାହୀମମ୍ ଅଦ୍ରାକ୍ଷୀଃ? ");
INSERT INTO sanori_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","ଯୀଶୁଃ ପ୍ରତ୍ୟୱାଦୀଦ୍ ଯୁଷ୍ମାନହଂ ଯଥାର୍ଥତରଂ ୱଦାମି ଇବ୍ରାହୀମୋ ଜନ୍ମନଃ ପୂର୍ୱ୍ୱକାଲମାରଭ୍ୟାହଂ ୱିଦ୍ୟେ| ");
INSERT INTO sanori_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ତଦା ତେ ପାଷାଣାନ୍ ଉତ୍ତୋଲ୍ୟ ତମାହନ୍ତୁମ୍ ଉଦଯଚ୍ଛନ୍ କିନ୍ତୁ ଯୀଶୁ ର୍ଗୁପ୍ତୋ ମନ୍ତିରାଦ୍ ବହିର୍ଗତ୍ୟ ତେଷାଂ ମଧ୍ୟେନ ପ୍ରସ୍ଥିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","ତତଃ ପରଂ ଯୀଶୁର୍ଗଚ୍ଛନ୍ ମାର୍ଗମଧ୍ୟେ ଜନ୍ମାନ୍ଧଂ ନରମ୍ ଅପଶ୍ୟତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ତତଃ ଶିଷ୍ୟାସ୍ତମ୍ ଅପୃଚ୍ଛନ୍ ହେ ଗୁରୋ ନରୋଯଂ ସ୍ୱପାପେନ ୱା ସ୍ୱପିତ୍ରାଃ ପାପେନାନ୍ଧୋଽଜାଯତ? ");
INSERT INTO sanori_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ତତଃ ସ ପ୍ରତ୍ୟୁଦିତୱାନ୍ ଏତସ୍ୟ ୱାସ୍ୟ ପିତ୍ରୋଃ ପାପାଦ୍ ଏତାଦୃଶୋଭୂଦ ଇତି ନହି କିନ୍ତ୍ୱନେନ ଯଥେଶ୍ୱରସ୍ୟ କର୍ମ୍ମ ପ୍ରକାଶ୍ୟତେ ତଦ୍ଧେତୋରେୱ| ");
INSERT INTO sanori_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","ଦିନେ ତିଷ୍ଠତି ମତ୍ପ୍ରେରଯିତୁଃ କର୍ମ୍ମ ମଯା କର୍ତ୍ତୱ୍ୟଂ ଯଦା କିମପି କର୍ମ୍ମ ନ କ୍ରିଯତେ ତାଦୃଶୀ ନିଶାଗଚ୍ଛତି| ");
INSERT INTO sanori_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ଅହଂ ଯାୱତ୍କାଲଂ ଜଗତି ତିଷ୍ଠାମି ତାୱତ୍କାଲଂ ଜଗତୋ ଜ୍ୟୋତିଃସ୍ୱରୂପୋସ୍ମି| ");
INSERT INTO sanori_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ଇତ୍ୟୁକ୍ତ୍ତା ଭୂମୌ ନିଷ୍ଠୀୱଂ ନିକ୍ଷିପ୍ୟ ତେନ ପଙ୍କଂ କୃତୱାନ୍ ");
INSERT INTO sanori_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ପଶ୍ଚାତ୍ ତତ୍ପଙ୍କେନ ତସ୍ୟାନ୍ଧସ୍ୟ ନେତ୍ରେ ପ୍ରଲିପ୍ୟ ତମିତ୍ୟାଦିଶତ୍ ଗତ୍ୱା ଶିଲୋହେ ଽର୍ଥାତ୍ ପ୍ରେରିତନାମ୍ନି ସରସି ସ୍ନାହି| ତତୋନ୍ଧୋ ଗତ୍ୱା ତତ୍ରାସ୍ନାତ୍ ତତଃ ପ୍ରନ୍ନଚକ୍ଷୁ ର୍ଭୂତ୍ୱା ୱ୍ୟାଘୁଟ୍ୟାଗାତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","ଅପରଞ୍ଚ ସମୀପୱାସିନୋ ଲୋକା ଯେ ଚ ତଂ ପୂର୍ୱ୍ୱମନ୍ଧମ୍ ଅପଶ୍ୟନ୍ ତେ ବକ୍ତ୍ତୁମ୍ ଆରଭନ୍ତ ଯୋନ୍ଧଲୋକୋ ୱର୍ତ୍ମନ୍ୟୁପୱିଶ୍ୟାଭିକ୍ଷତ ସ ଏୱାଯଂ ଜନଃ କିଂ ନ ଭୱତି? ");
INSERT INTO sanori_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","କେଚିଦୱଦନ୍ ସ ଏୱ କେଚିଦୱୋଚନ୍ ତାଦୃଶୋ ଭୱତି କିନ୍ତୁ ସ ସ୍ୱଯମବ୍ରୱୀତ୍ ସ ଏୱାହଂ ଭୱାମି| ");
INSERT INTO sanori_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ଅତଏୱ ତେ ଽପୃଚ୍ଛନ୍ ତ୍ୱଂ କଥଂ ଦୃଷ୍ଟିଂ ପାପ୍ତୱାନ୍? ");
INSERT INTO sanori_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ତତଃ ସୋୱଦଦ୍ ଯୀଶନାମକ ଏକୋ ଜନୋ ମମ ନଯନେ ପଙ୍କେନ ପ୍ରଲିପ୍ୟ ଇତ୍ୟାଜ୍ଞାପଯତ୍ ଶିଲୋହକାସାରଂ ଗତ୍ୱା ତତ୍ର ସ୍ନାହି| ତତସ୍ତତ୍ର ଗତ୍ୱା ମଯି ସ୍ନାତେ ଦୃଷ୍ଟିମହଂ ଲବ୍ଧୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","ତଦା ତେ ଽୱଦନ୍ ସ ପୁମାନ୍ କୁତ୍ର? ତେନୋକ୍ତ୍ତଂ ନାହଂ ଜାନାମି| ");
INSERT INTO sanori_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","ଅପରଂ ତସ୍ମିନ୍ ପୂର୍ୱ୍ୱାନ୍ଧେ ଜନେ ଫିରୂଶିନାଂ ନିକଟମ୍ ଆନୀତେ ସତି ଫିରୂଶିନୋପି ତମପୃଚ୍ଛନ୍ କଥଂ ଦୃଷ୍ଟିଂ ପ୍ରାପ୍ତୋସି? ");
INSERT INTO sanori_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ତତଃ ସ କଥିତୱାନ୍ ସ ପଙ୍କେନ ମମ ନେତ୍ରେ ଽଲିମ୍ପତ୍ ପଶ୍ଚାଦ୍ ସ୍ନାତ୍ୱା ଦୃଷ୍ଟିମଲଭେ| ");
INSERT INTO sanori_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","କିନ୍ତୁ ଯୀଶୁ ର୍ୱିଶ୍ରାମୱାରେ କର୍ଦ୍ଦମଂ କୃତ୍ୱା ତସ୍ୟ ନଯନେ ପ୍ରସନ୍ନେଽକରୋଦ୍ ଇତିକାରଣାତ୍ କତିପଯଫିରୂଶିନୋଽୱଦନ୍ ");
INSERT INTO sanori_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ସ ପୁମାନ୍ ଈଶ୍ୱରାନ୍ନ ଯତଃ ସ ୱିଶ୍ରାମୱାରଂ ନ ମନ୍ୟତେ| ତତୋନ୍ୟେ କେଚିତ୍ ପ୍ରତ୍ୟୱଦନ୍ ପାପୀ ପୁମାନ୍ କିମ୍ ଏତାଦୃଶମ୍ ଆଶ୍ଚର୍ୟ୍ୟଂ କର୍ମ୍ମ କର୍ତ୍ତୁଂ ଶକ୍ନୋତି? ");
INSERT INTO sanori_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ଇତ୍ଥଂ ତେଷାଂ ପରସ୍ପରଂ ଭିନ୍ନୱାକ୍ୟତ୍ୱମ୍ ଅଭୱତ୍| ପଶ୍ଚାତ୍ ତେ ପୁନରପି ତଂ ପୂର୍ୱ୍ୱାନ୍ଧଂ ମାନୁଷମ୍ ଅପ୍ରାକ୍ଷୁଃ ଯୋ ଜନସ୍ତୱ ଚକ୍ଷୁଷୀ ପ୍ରସନ୍ନେ କୃତୱାନ୍ ତସ୍ମିନ୍ ତ୍ୱଂ କିଂ ୱଦସି? ସ ଉକ୍ତ୍ତୱାନ୍ ସ ଭୱିଶଦ୍ୱାଦୀ| ");
INSERT INTO sanori_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","ସ ଦୃଷ୍ଟିମ୍ ଆପ୍ତୱାନ୍ ଇତି ଯିହୂଦୀଯାସ୍ତସ୍ୟ ଦୃଷ୍ଟିଂ ପ୍ରାପ୍ତସ୍ୟ ଜନସ୍ୟ ପିତ୍ରୋ ର୍ମୁଖାଦ୍ ଅଶ୍ରୁତ୍ୱା ନ ପ୍ରତ୍ୟଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ଅତଏୱ ତେ ତାୱପୃଚ୍ଛନ୍ ଯୁୱଯୋ ର୍ୟଂ ପୁତ୍ରଂ ଜନ୍ମାନ୍ଧଂ ୱଦଥଃ ସ କିମଯଂ? ତର୍ହୀଦାନୀଂ କଥଂ ଦ୍ରଷ୍ଟୁଂ ଶକ୍ନୋତି? ");
INSERT INTO sanori_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ତତସ୍ତସ୍ୟ ପିତରୌ ପ୍ରତ୍ୟୱୋଚତାମ୍ ଅଯମ୍ ଆୱଯୋଃ ପୁତ୍ର ଆ ଜନେରନ୍ଧଶ୍ଚ ତଦପ୍ୟାୱାଂ ଜାନୀୱଃ ");
INSERT INTO sanori_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","କିନ୍ତ୍ୱଧୁନା କଥଂ ଦୃଷ୍ଟିଂ ପ୍ରାପ୍ତୱାନ୍ ତଦାୱାଂ ନ୍ ଜାନୀୱଃ କୋସ୍ୟ ଚକ୍ଷୁଷୀ ପ୍ରସନ୍ନେ କୃତୱାନ୍ ତଦପି ନ ଜାନୀୱ ଏଷ ୱଯଃପ୍ରାପ୍ତ ଏନଂ ପୃଚ୍ଛତ ସ୍ୱକଥାଂ ସ୍ୱଯଂ ୱକ୍ଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ଯିହୂଦୀଯାନାଂ ଭଯାତ୍ ତସ୍ୟ ପିତରୌ ୱାକ୍ୟମିଦମ୍ ଅୱଦତାଂ ଯତଃ କୋପି ମନୁଷ୍ୟୋ ଯଦି ଯୀଶୁମ୍ ଅଭିଷିକ୍ତଂ ୱଦତି ତର୍ହି ସ ଭଜନଗୃହାଦ୍ ଦୂରୀକାରିଷ୍ୟତେ ଯିହୂଦୀଯା ଇତି ମନ୍ତ୍ରଣାମ୍ ଅକୁର୍ୱ୍ୱନ୍ ");
INSERT INTO sanori_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","ଅତସ୍ତସ୍ୟ ପିତରୌ ୱ୍ୟାହରତାମ୍ ଏଷ ୱଯଃପ୍ରାପ୍ତ ଏନଂ ପୃଚ୍ଛତ| ");
INSERT INTO sanori_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","ତଦା ତେ ପୁନଶ୍ଚ ତଂ ପୂର୍ୱ୍ୱାନ୍ଧମ୍ ଆହୂଯ ୱ୍ୟାହରନ୍ ଈଶ୍ୱରସ୍ୟ ଗୁଣାନ୍ ୱଦ ଏଷ ମନୁଷ୍ୟଃ ପାପୀତି ୱଯଂ ଜାନୀମଃ| ");
INSERT INTO sanori_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","ତଦା ସ ଉକ୍ତ୍ତୱାନ୍ ସ ପାପୀ ନ ୱେତି ନାହଂ ଜାନେ ପୂର୍ୱାମନ୍ଧ ଆସମହମ୍ ଅଧୁନା ପଶ୍ୟାମୀତି ମାତ୍ରଂ ଜାନାମି| ");
INSERT INTO sanori_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ତେ ପୁନରପୃଚ୍ଛନ୍ ସ ତ୍ୱାଂ ପ୍ରତି କିମକରୋତ୍? କଥଂ ନେତ୍ରେ ପ୍ରସନ୍ନେ ଽକରୋତ୍? ");
INSERT INTO sanori_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","ତତଃ ସୋୱାଦୀଦ୍ ଏକକୃତ୍ୱୋକଥଯଂ ଯୂଯଂ ନ ଶୃଣୁଥ ତର୍ହି କୁତଃ ପୁନଃ ଶ୍ରୋତୁମ୍ ଇଚ୍ଛଥ? ଯୂଯମପି କିଂ ତସ୍ୟ ଶିଷ୍ୟା ଭୱିତୁମ୍ ଇଚ୍ଛଥ? ");
INSERT INTO sanori_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","ତଦା ତେ ତଂ ତିରସ୍କୃତ୍ୟ ୱ୍ୟାହରନ୍ ତ୍ୱଂ ତସ୍ୟ ଶିଷ୍ୟୋ ୱଯଂ ମୂସାଃ ଶିଷ୍ୟାଃ| ");
INSERT INTO sanori_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","ମୂସାୱକ୍ତ୍ରେଣେଶ୍ୱରୋ ଜଗାଦ ତଜ୍ଜାନୀମଃ କିନ୍ତ୍ୱେଷ କୁତ୍ରତ୍ୟଲୋକ ଇତି ନ ଜାନୀମଃ| ");
INSERT INTO sanori_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","ସୋୱଦଦ୍ ଏଷ ମମ ଲୋଚନେ ପ୍ରସନ୍ନେ ଽକରୋତ୍ ତଥାପି କୁତ୍ରତ୍ୟଲୋକ ଇତି ଯୂଯଂ ନ ଜାନୀଥ ଏତଦ୍ ଆଶ୍ଚର୍ୟ୍ୟଂ ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ଈଶ୍ୱରଃ ପାପିନାଂ କଥାଂ ନ ଶୃଣୋତି କିନ୍ତୁ ଯୋ ଜନସ୍ତସ୍ମିନ୍ ଭକ୍ତିଂ କୃତ୍ୱା ତଦିଷ୍ଟକ୍ରିଯାଂ କରୋତି ତସ୍ୟୈୱ କଥାଂ ଶୃଣୋତି ଏତଦ୍ ୱଯଂ ଜାନୀମଃ| ");
INSERT INTO sanori_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","କୋପି ମନୁଷ୍ୟୋ ଜନ୍ମାନ୍ଧାଯ ଚକ୍ଷୁଷୀ ଅଦଦାତ୍ ଜଗଦାରମ୍ଭାଦ୍ ଏତାଦୃଶୀଂ କଥାଂ କୋପି କଦାପି ନାଶୃଣୋତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","ଅସ୍ମାଦ୍ ଏଷ ମନୁଷ୍ୟୋ ଯଦୀଶ୍ୱରାନ୍ନାଜାଯତ ତର୍ହି କିଞ୍ଚିଦପୀଦୃଶଂ କର୍ମ୍ମ କର୍ତ୍ତୁଂ ନାଶକ୍ନୋତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","ତେ ୱ୍ୟାହରନ୍ ତ୍ୱଂ ପାପାଦ୍ ଅଜାଯଥାଃ କିମସ୍ମାନ୍ ତ୍ୱଂ ଶିକ୍ଷଯସି? ପଶ୍ଚାତ୍ତେ ତଂ ବହିରକୁର୍ୱ୍ୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","ତଦନନ୍ତରଂ ଯିହୂଦୀଯୈଃ ସ ବହିରକ୍ରିଯତ ଯୀଶୁରିତି ୱାର୍ତ୍ତାଂ ଶ୍ରୁତ୍ୱା ତଂ ସାକ୍ଷାତ୍ ପ୍ରାପ୍ୟ ପୃଷ୍ଟୱାନ୍ ଈଶ୍ୱରସ୍ୟ ପୁତ୍ରେ ତ୍ୱଂ ୱିଶ୍ୱସିଷି? ");
INSERT INTO sanori_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","ତଦା ସ ପ୍ରତ୍ୟୱୋଚତ୍ ହେ ପ୍ରଭୋ ସ କୋ ଯତ୍ ତସ୍ମିନ୍ନହଂ ୱିଶ୍ୱସିମି? ");
INSERT INTO sanori_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ତତୋ ଯୀଶୁଃ କଥିତୱାନ୍ ତ୍ୱଂ ତଂ ଦୃଷ୍ଟୱାନ୍ ତ୍ୱଯା ସାକଂ ଯଃ କଥଂ କଥଯତି ସଏୱ ସଃ| ");
INSERT INTO sanori_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","ତଦା ହେ ପ୍ରଭୋ ୱିଶ୍ୱସିମୀତ୍ୟୁକ୍ତ୍ୱା ସ ତଂ ପ୍ରଣାମତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","ପଶ୍ଚାଦ୍ ଯୀଶୁଃ କଥିତୱାନ୍ ନଯନହୀନା ନଯନାନି ପ୍ରାପ୍ନୁୱନ୍ତି ନଯନୱନ୍ତଶ୍ଚାନ୍ଧା ଭୱନ୍ତୀତ୍ୟଭିପ୍ରାଯେଣ ଜଗଦାହମ୍ ଆଗଚ୍ଛମ୍| ");
INSERT INTO sanori_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ଏତତ୍ ଶ୍ରୁତ୍ୱା ନିକଟସ୍ଥାଃ କତିପଯାଃ ଫିରୂଶିନୋ ୱ୍ୟାହରନ୍ ୱଯମପି କିମନ୍ଧାଃ? ");
INSERT INTO sanori_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","ତଦା ଯୀଶୁରୱାଦୀଦ୍ ଯଦ୍ୟନ୍ଧା ଅଭୱତ ତର୍ହି ପାପାନି ନାତିଷ୍ଠନ୍ କିନ୍ତୁ ପଶ୍ୟାମୀତି ୱାକ୍ୟୱଦନାଦ୍ ଯୁଷ୍ମାକଂ ପାପାନି ତିଷ୍ଠନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ଅହଂ ଯୁଷ୍ମାନତିଯଥାର୍ଥଂ ୱଦାମି, ଯୋ ଜନୋ ଦ୍ୱାରେଣ ନ ପ୍ରୱିଶ୍ୟ କେନାପ୍ୟନ୍ୟେନ ମେଷଗୃହଂ ପ୍ରୱିଶତି ସ ଏୱ ସ୍ତେନୋ ଦସ୍ୟୁଶ୍ଚ| ");
INSERT INTO sanori_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","ଯୋ ଦ୍ୱାରେଣ ପ୍ରୱିଶତି ସ ଏୱ ମେଷପାଲକଃ| ");
INSERT INTO sanori_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ଦୌୱାରିକସ୍ତସ୍ମୈ ଦ୍ୱାରଂ ମୋଚଯତି ମେଷଗଣଶ୍ଚ ତସ୍ୟ ୱାକ୍ୟଂ ଶୃଣୋତି ସ ନିଜାନ୍ ମେଷାନ୍ ସ୍ୱସ୍ୱନାମ୍ନାହୂଯ ବହିଃ କୃତ୍ୱା ନଯତି| ");
INSERT INTO sanori_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","ତଥା ନିଜାନ୍ ମେଷାନ୍ ବହିଃ କୃତ୍ୱା ସ୍ୱଯଂ ତେଷାମ୍ ଅଗ୍ରେ ଗଚ୍ଛତି, ତତୋ ମେଷାସ୍ତସ୍ୟ ଶବ୍ଦଂ ବୁଧ୍ୟନ୍ତେ, ତସ୍ମାତ୍ ତସ୍ୟ ପଶ୍ଚାଦ୍ ୱ୍ରଜନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","କିନ୍ତୁ ପରସ୍ୟ ଶବ୍ଦଂ ନ ବୁଧ୍ୟନ୍ତେ ତସ୍ମାତ୍ ତସ୍ୟ ପଶ୍ଚାଦ୍ ୱ୍ରଜିଷ୍ୟନ୍ତି ୱରଂ ତସ୍ୟ ସମୀପାତ୍ ପଲାଯିଷ୍ୟନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","ଯୀଶୁସ୍ତେଭ୍ୟ ଇମାଂ ଦୃଷ୍ଟାନ୍ତକଥାମ୍ ଅକଥଯତ୍ କିନ୍ତୁ ତେନ କଥିତକଥାଯାସ୍ତାତ୍ପର୍ୟ୍ୟଂ ତେ ନାବୁଧ୍ୟନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","ଅତୋ ଯୀଶୁଃ ପୁନରକଥଯତ୍, ଯୁଷ୍ମାନାହଂ ଯଥାର୍ଥତରଂ ୱ୍ୟାହରାମି, ମେଷଗୃହସ୍ୟ ଦ୍ୱାରମ୍ ଅହମେୱ| ");
INSERT INTO sanori_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ମଯା ନ ପ୍ରୱିଶ୍ୟ ଯ ଆଗଚ୍ଛନ୍ ତେ ସ୍ତେନା ଦସ୍ୟୱଶ୍ଚ କିନ୍ତୁ ମେଷାସ୍ତେଷାଂ କଥା ନାଶୃଣ୍ୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","ଅହମେୱ ଦ୍ୱାରସ୍ୱରୂପଃ, ମଯା ଯଃ କଶ୍ଚିତ ପ୍ରୱିଶତି ସ ରକ୍ଷାଂ ପ୍ରାପ୍ସ୍ୟତି ତଥା ବହିରନ୍ତଶ୍ଚ ଗମନାଗମନେ କୃତ୍ୱା ଚରଣସ୍ଥାନଂ ପ୍ରାପ୍ସ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","ଯୋ ଜନସ୍ତେନଃ ସ କେୱଲଂ ସ୍ତୈନ୍ୟବଧୱିନାଶାନ୍ କର୍ତ୍ତୁମେୱ ସମାଯାତି କିନ୍ତ୍ୱହମ୍ ଆଯୁ ର୍ଦାତୁମ୍ ଅର୍ଥାତ୍ ବାହୂଲ୍ୟେନ ତଦେୱ ଦାତୁମ୍ ଆଗଚ୍ଛମ୍| ");
INSERT INTO sanori_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","ଅହମେୱ ସତ୍ୟମେଷପାଲକୋ ଯସ୍ତୁ ସତ୍ୟୋ ମେଷପାଲକଃ ସ ମେଷାର୍ଥଂ ପ୍ରାଣତ୍ୟାଗଂ କରୋତି; ");
INSERT INTO sanori_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","କିନ୍ତୁ ଯୋ ଜନୋ ମେଷପାଲକୋ ନ, ଅର୍ଥାଦ୍ ଯସ୍ୟ ମେଷା ନିଜା ନ ଭୱନ୍ତି, ଯ ଏତାଦୃଶୋ ୱୈତନିକଃ ସ ୱୃକମ୍ ଆଗଚ୍ଛନ୍ତଂ ଦୃଷ୍ଟ୍ୱା ମେଜୱ୍ରଜଂ ୱିହାଯ ପଲାଯତେ, ତସ୍ମାଦ୍ ୱୃକସ୍ତଂ ୱ୍ରଜଂ ଧୃତ୍ୱା ୱିକିରତି| ");
INSERT INTO sanori_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ୱୈତନିକଃ ପଲାଯତେ ଯତଃ ସ ୱେତନାର୍ଥୀ ମେଷାର୍ଥଂ ନ ଚିନ୍ତଯତି| ");
INSERT INTO sanori_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","ଅହମେୱ ସତ୍ୟୋ ମେଷପାଲକଃ, ପିତା ମାଂ ଯଥା ଜାନାତି, ଅହଞ୍ଚ ଯଥା ପିତରଂ ଜାନାମି, ");
INSERT INTO sanori_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ତଥା ନିଜାନ୍ ମେଷାନପି ଜାନାମି, ମେଷାଶ୍ଚ ମାଂ ଜାନାନ୍ତି, ଅହଞ୍ଚ ମେଷାର୍ଥଂ ପ୍ରାଣତ୍ୟାଗଂ କରୋମି| ");
INSERT INTO sanori_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","ଅପରଞ୍ଚ ଏତଦ୍ ଗୃହୀଯ ମେଷେଭ୍ୟୋ ଭିନ୍ନା ଅପି ମେଷା ମମ ସନ୍ତି ତେ ସକଲା ଆନଯିତୱ୍ୟାଃ; ତେ ମମ ଶବ୍ଦଂ ଶ୍ରୋଷ୍ୟନ୍ତି ତତ ଏକୋ ୱ୍ରଜ ଏକୋ ରକ୍ଷକୋ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","ପ୍ରାଣାନହଂ ତ୍ୟକ୍ତ୍ୱା ପୁନଃ ପ୍ରାଣାନ୍ ଗ୍ରହୀଷ୍ୟାମି, ତସ୍ମାତ୍ ପିତା ମଯି ସ୍ନେହଂ କରୋତି| ");
INSERT INTO sanori_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","କଶ୍ଚିଜ୍ଜନୋ ମମ ପ୍ରାଣାନ୍ ହନ୍ତୁଂ ନ ଶକ୍ନୋତି କିନ୍ତୁ ସ୍ୱଯଂ ତାନ୍ ସମର୍ପଯାମି ତାନ୍ ସମର୍ପଯିତୁଂ ପୁନର୍ଗ୍ରହୀତୁଞ୍ଚ ମମ ଶକ୍ତିରାସ୍ତେ ଭାରମିମଂ ସ୍ୱପିତୁଃ ସକାଶାତ୍ ପ୍ରାପ୍ତୋହମ୍| ");
INSERT INTO sanori_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","ଅସ୍ମାଦୁପଦେଶାତ୍ ପୁନଶ୍ଚ ଯିହୂଦୀଯାନାଂ ମଧ୍ୟେ ଭିନ୍ନୱାକ୍ୟତା ଜାତା| ");
INSERT INTO sanori_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ତତୋ ବହୱୋ ୱ୍ୟାହରନ୍ ଏଷ ଭୂତଗ୍ରସ୍ତ ଉନ୍ମତ୍ତଶ୍ଚ, କୁତ ଏତସ୍ୟ କଥାଂ ଶୃଣୁଥ? ");
INSERT INTO sanori_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","କେଚିଦ୍ ଅୱଦନ୍ ଏତସ୍ୟ କଥା ଭୂତଗ୍ରସ୍ତସ୍ୟ କଥାୱନ୍ନ ଭୱନ୍ତି, ଭୂତଃ କିମ୍ ଅନ୍ଧାଯ ଚକ୍ଷୁଷୀ ଦାତୁଂ ଶକ୍ନୋତି? ");
INSERT INTO sanori_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","ଶୀତକାଲେ ଯିରୂଶାଲମି ମନ୍ଦିରୋତ୍ସର୍ଗପର୍ୱ୍ୱଣ୍ୟୁପସ୍ଥିତେ ");
INSERT INTO sanori_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ଯୀଶୁଃ ସୁଲେମାନୋ ନିଃସାରେଣ ଗମନାଗମନେ କରୋତି, ");
INSERT INTO sanori_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ଏତସ୍ମିନ୍ ସମଯେ ଯିହୂଦୀଯାସ୍ତଂ ୱେଷ୍ଟଯିତ୍ୱା ୱ୍ୟାହରନ୍ କତି କାଲାନ୍ ଅସ୍ମାକଂ ୱିଚିକିତ୍ସାଂ ସ୍ଥାପଯିଷ୍ୟାମି? ଯଦ୍ୟଭିଷିକ୍ତୋ ଭୱତି ତର୍ହି ତତ୍ ସ୍ପଷ୍ଟଂ ୱଦ| ");
INSERT INTO sanori_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","ତଦା ଯୀଶୁଃ ପ୍ରତ୍ୟୱଦଦ୍ ଅହମ୍ ଅଚକଥଂ କିନ୍ତୁ ଯୂଯଂ ନ ପ୍ରତୀଥ, ନିଜପିତୁ ର୍ନାମ୍ନା ଯାଂ ଯାଂ କ୍ରିଯାଂ କରୋମି ସା କ୍ରିଯୈୱ ମମ ସାକ୍ଷିସ୍ୱରୂପା| ");
INSERT INTO sanori_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","କିନ୍ତ୍ୱହଂ ପୂର୍ୱ୍ୱମକଥଯଂ ଯୂଯଂ ମମ ମେଷା ନ ଭୱଥ, କାରଣାଦସ୍ମାନ୍ ନ ୱିଶ୍ୱସିଥ| ");
INSERT INTO sanori_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","ମମ ମେଷା ମମ ଶବ୍ଦଂ ଶୃଣ୍ୱନ୍ତି ତାନହଂ ଜାନାମି ତେ ଚ ମମ ପଶ୍ଚାଦ୍ ଗଚ୍ଛନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ଅହଂ ତେଭ୍ୟୋଽନନ୍ତାଯୁ ର୍ଦଦାମି, ତେ କଦାପି ନ ନଂକ୍ଷ୍ୟନ୍ତି କୋପି ମମ କରାତ୍ ତାନ୍ ହର୍ତ୍ତୁଂ ନ ଶକ୍ଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","ଯୋ ମମ ପିତା ତାନ୍ ମହ୍ୟଂ ଦତ୍ତୱାନ୍ ସ ସର୍ୱ୍ୱସ୍ମାତ୍ ମହାନ୍, କୋପି ମମ ପିତୁଃ କରାତ୍ ତାନ୍ ହର୍ତ୍ତୁଂ ନ ଶକ୍ଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ଅହଂ ପିତା ଚ ଦ୍ୱଯୋରେକତ୍ୱମ୍| ");
INSERT INTO sanori_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","ତତୋ ଯିହୂଦୀଯାଃ ପୁନରପି ତଂ ହନ୍ତୁଂ ପାଷାଣାନ୍ ଉଦତୋଲଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ଯୀଶୁଃ କଥିତୱାନ୍ ପିତୁଃ ସକାଶାଦ୍ ବହୂନ୍ୟୁତ୍ତମକର୍ମ୍ମାଣି ଯୁଷ୍ମାକଂ ପ୍ରାକାଶଯଂ ତେଷାଂ କସ୍ୟ କର୍ମ୍ମଣଃ କାରଣାନ୍ ମାଂ ପାଷାଣୈରାହନ୍ତୁମ୍ ଉଦ୍ୟତାଃ ସ୍ଥ? ");
INSERT INTO sanori_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","ଯିହୂଦୀଯାଃ ପ୍ରତ୍ୟୱଦନ୍ ପ୍ରଶସ୍ତକର୍ମ୍ମହେତୋ ର୍ନ କିନ୍ତୁ ତ୍ୱଂ ମାନୁଷଃ ସ୍ୱମୀଶ୍ୱରମ୍ ଉକ୍ତ୍ୱେଶ୍ୱରଂ ନିନ୍ଦସି କାରଣାଦସ୍ମାତ୍ ତ୍ୱାଂ ପାଷାଣୈର୍ହନ୍ମଃ| ");
INSERT INTO sanori_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","ତଦା ଯୀଶୁଃ ପ୍ରତ୍ୟୁକ୍ତୱାନ୍ ମଯା କଥିତଂ ଯୂଯମ୍ ଈଶ୍ୱରା ଏତଦ୍ୱଚନଂ ଯୁଷ୍ମାକଂ ଶାସ୍ତ୍ରେ ଲିଖିତଂ ନାସ୍ତି କିଂ? ");
INSERT INTO sanori_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","ତସ୍ମାଦ୍ ଯେଷାମ୍ ଉଦ୍ଦେଶେ ଈଶ୍ୱରସ୍ୟ କଥା କଥିତା ତେ ଯଦୀଶ୍ୱରଗଣା ଉଚ୍ୟନ୍ତେ ଧର୍ମ୍ମଗ୍ରନ୍ଥସ୍ୟାପ୍ୟନ୍ୟଥା ଭୱିତୁଂ ନ ଶକ୍ୟଂ, ");
INSERT INTO sanori_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ତର୍ହ୍ୟାହମ୍ ଈଶ୍ୱରସ୍ୟ ପୁତ୍ର ଇତି ୱାକ୍ୟସ୍ୟ କଥନାତ୍ ଯୂଯଂ ପିତ୍ରାଭିଷିକ୍ତଂ ଜଗତି ପ୍ରେରିତଞ୍ଚ ପୁମାଂସଂ କଥମ୍ ଈଶ୍ୱରନିନ୍ଦକଂ ୱାଦଯ? ");
INSERT INTO sanori_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","ଯଦ୍ୟହଂ ପିତୁଃ କର୍ମ୍ମ ନ କରୋମି ତର୍ହି ମାଂ ନ ପ୍ରତୀତ; ");
INSERT INTO sanori_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","କିନ୍ତୁ ଯଦି କରୋମି ତର୍ହି ମଯି ଯୁଷ୍ମାଭିଃ ପ୍ରତ୍ୟଯେ ନ କୃତେଽପି କାର୍ୟ୍ୟେ ପ୍ରତ୍ୟଯଃ କ୍ରିଯତାଂ, ତତୋ ମଯି ପିତାସ୍ତୀତି ପିତର୍ୟ୍ୟହମ୍ ଅସ୍ମୀତି ଚ କ୍ଷାତ୍ୱା ୱିଶ୍ୱସିଷ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ତଦା ତେ ପୁନରପି ତଂ ଧର୍ତ୍ତୁମ୍ ଅଚେଷ୍ଟନ୍ତ କିନ୍ତୁ ସ ତେଷାଂ କରେଭ୍ୟୋ ନିସ୍ତୀର୍ୟ୍ୟ ");
INSERT INTO sanori_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ପୁନ ର୍ୟର୍ଦ୍ଦନ୍ ଅଦ୍ୟାସ୍ତଟେ ଯତ୍ର ପୁର୍ୱ୍ୱଂ ଯୋହନ୍ ଅମଜ୍ଜଯତ୍ ତତ୍ରାଗତ୍ୟ ନ୍ୟୱସତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ତତୋ ବହୱୋ ଲୋକାସ୍ତତ୍ସମୀପମ୍ ଆଗତ୍ୟ ୱ୍ୟାହରନ୍ ଯୋହନ୍ କିମପ୍ୟାଶ୍ଚର୍ୟ୍ୟଂ କର୍ମ୍ମ ନାକରୋତ୍ କିନ୍ତ୍ୱସ୍ମିନ୍ ମନୁଷ୍ୟେ ଯା ଯଃ କଥା ଅକଥଯତ୍ ତାଃ ସର୍ୱ୍ୱାଃ ସତ୍ୟାଃ; ");
INSERT INTO sanori_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ତତ୍ର ଚ ବହୱୋ ଲୋକାସ୍ତସ୍ମିନ୍ ୱ୍ୟଶ୍ୱସନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","ଅନନ୍ତରଂ ମରିଯମ୍ ତସ୍ୟା ଭଗିନୀ ମର୍ଥା ଚ ଯସ୍ମିନ୍ ୱୈଥନୀଯାଗ୍ରାମେ ୱସତସ୍ତସ୍ମିନ୍ ଗ୍ରାମେ ଇଲିଯାସର୍ ନାମା ପୀଡିତ ଏକ ଆସୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ଯା ମରିଯମ୍ ପ୍ରଭୁଂ ସୁଗନ୍ଧିତେଲୈନ ମର୍ଦ୍ଦଯିତ୍ୱା ସ୍ୱକେଶୈସ୍ତସ୍ୟ ଚରଣୌ ସମମାର୍ଜତ୍ ତସ୍ୟା ଭ୍ରାତା ସ ଇଲିଯାସର୍ ରୋଗୀ| ");
INSERT INTO sanori_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ଅପରଞ୍ଚ ହେ ପ୍ରଭୋ ଭୱାନ୍ ଯସ୍ମିନ୍ ପ୍ରୀଯତେ ସ ଏୱ ପୀଡିତୋସ୍ତୀତି କଥାଂ କଥଯିତ୍ୱା ତସ୍ୟ ଭଗିନ୍ୟୌ ପ୍ରେଷିତୱତ୍ୟୌ| ");
INSERT INTO sanori_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ତଦା ଯୀଶୁରିମାଂ ୱାର୍ତ୍ତାଂ ଶ୍ରୁତ୍ୱାକଥଯତ ପୀଡେଯଂ ମରଣାର୍ଥଂ ନ କିନ୍ତ୍ୱୀଶ୍ୱରସ୍ୟ ମହିମାର୍ଥମ୍ ଈଶ୍ୱରପୁତ୍ରସ୍ୟ ମହିମପ୍ରକାଶାର୍ଥଞ୍ଚ ଜାତା| ");
INSERT INTO sanori_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","ଯୀଶୁ ର୍ୟଦ୍ୟପିମର୍ଥାଯାଂ ତଦ୍ଭଗିନ୍ୟାମ୍ ଇଲିଯାସରି ଚାପ୍ରୀଯତ, ");
INSERT INTO sanori_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ତଥାପି ଇଲିଯାସରଃ ପୀଡାଯାଃ କଥଂ ଶ୍ରୁତ୍ୱା ଯତ୍ର ଆସୀତ୍ ତତ୍ରୈୱ ଦିନଦ୍ୱଯମତିଷ୍ଠତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ତତଃ ପରମ୍ ସ ଶିଷ୍ୟାନକଥଯଦ୍ ୱଯଂ ପୁନ ର୍ୟିହୂଦୀଯପ୍ରଦେଶଂ ଯାମଃ| ");
INSERT INTO sanori_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","ତତସ୍ତେ ପ୍ରତ୍ୟୱଦନ୍, ହେ ଗୁରୋ ସ୍ୱଲ୍ପଦିନାନି ଗତାନି ଯିହୂଦୀଯାସ୍ତ୍ୱାଂ ପାଷାଣୈ ର୍ହନ୍ତୁମ୍ ଉଦ୍ୟତାସ୍ତଥାପି କିଂ ପୁନସ୍ତତ୍ର ଯାସ୍ୟସି? ");
INSERT INTO sanori_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","ଯୀଶୁଃ ପ୍ରତ୍ୟୱଦତ୍, ଏକସ୍ମିନ୍ ଦିନେ କିଂ ଦ୍ୱାଦଶଘଟିକା ନ ଭୱନ୍ତି? କୋପି ଦିୱା ଗଚ୍ଛନ୍ ନ ସ୍ଖଲତି ଯତଃ ସ ଏତଜ୍ଜଗତୋ ଦୀପ୍ତିଂ ପ୍ରାପ୍ନୋତି| ");
INSERT INTO sanori_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","କିନ୍ତୁ ରାତ୍ରୌ ଗଚ୍ଛନ୍ ସ୍ଖଲତି ଯତୋ ହେତୋସ୍ତତ୍ର ଦୀପ୍ତି ର୍ନାସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ଇମାଂ କଥାଂ କଥଯିତ୍ୱା ସ ତାନୱଦଦ୍, ଅସ୍ମାକଂ ବନ୍ଧୁଃ ଇଲିଯାସର୍ ନିଦ୍ରିତୋଭୂଦ୍ ଇଦାନୀଂ ତଂ ନିଦ୍ରାତୋ ଜାଗରଯିତୁଂ ଗଚ୍ଛାମି| ");
INSERT INTO sanori_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","ଯୀଶୁ ର୍ମୃତୌ କଥାମିମାଂ କଥିତୱାନ୍ କିନ୍ତୁ ୱିଶ୍ରାମାର୍ଥଂ ନିଦ୍ରାଯାଂ କଥିତୱାନ୍ ଇତି ଜ୍ଞାତ୍ୱା ଶିଷ୍ୟା ଅକଥଯନ୍, ");
INSERT INTO sanori_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ହେ ଗୁରୋ ସ ଯଦି ନିଦ୍ରାତି ତର୍ହି ଭଦ୍ରମେୱ| ");
INSERT INTO sanori_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","ତଦା ଯୀଶୁଃ ସ୍ପଷ୍ଟଂ ତାନ୍ ୱ୍ୟାହରତ୍, ଇଲିଯାସର୍ ଅମ୍ରିଯତ; ");
INSERT INTO sanori_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","କିନ୍ତୁ ଯୂଯଂ ଯଥା ପ୍ରତୀଥ ତଦର୍ଥମହଂ ତତ୍ର ନ ସ୍ଥିତୱାନ୍ ଇତ୍ୟସ୍ମାଦ୍ ଯୁଷ୍ମନ୍ନିମିତ୍ତମ୍ ଆହ୍ଲାଦିତୋହଂ, ତଥାପି ତସ୍ୟ ସମୀପେ ଯାମ| ");
INSERT INTO sanori_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","ତଦା ଥୋମା ଯଂ ଦିଦୁମଂ ୱଦନ୍ତି ସ ସଙ୍ଗିନଃ ଶିଷ୍ୟାନ୍ ଅୱଦଦ୍ ୱଯମପି ଗତ୍ୱା ତେନ ସାର୍ଦ୍ଧଂ ମ୍ରିଯାମହୈ| ");
INSERT INTO sanori_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","ଯୀଶୁସ୍ତତ୍ରୋପସ୍ଥାଯ ଇଲିଯାସରଃ ଶ୍ମଶାନେ ସ୍ଥାପନାତ୍ ଚତ୍ୱାରି ଦିନାନି ଗତାନୀତି ୱାର୍ତ୍ତାଂ ଶ୍ରୁତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","ୱୈଥନୀଯା ଯିରୂଶାଲମଃ ସମୀପସ୍ଥା କ୍ରୋଶୈକମାତ୍ରାନ୍ତରିତା; ");
INSERT INTO sanori_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ତସ୍ମାଦ୍ ବହୱୋ ଯିହୂଦୀଯା ମର୍ଥାଂ ମରିଯମଞ୍ଚ ଭ୍ୟାତୃଶୋକାପନ୍ନାଂ ସାନ୍ତ୍ୱଯିତୁଂ ତଯୋଃ ସମୀପମ୍ ଆଗଚ୍ଛନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","ମର୍ଥା ଯୀଶୋରାଗମନୱାର୍ତାଂ ଶ୍ରୁତ୍ୱୈୱ ତଂ ସାକ୍ଷାଦ୍ ଅକରୋତ୍ କିନ୍ତୁ ମରିଯମ୍ ଗେହ ଉପୱିଶ୍ୟ ସ୍ଥିତା| ");
INSERT INTO sanori_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","ତଦା ମର୍ଥା ଯୀଶୁମୱାଦତ୍, ହେ ପ୍ରଭୋ ଯଦି ଭୱାନ୍ ଅତ୍ରାସ୍ଥାସ୍ୟତ୍ ତର୍ହି ମମ ଭ୍ରାତା ନାମରିଷ୍ୟତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","କିନ୍ତ୍ୱିଦାନୀମପି ଯଦ୍ ଈଶ୍ୱରେ ପ୍ରାର୍ଥଯିଷ୍ୟତେ ଈଶ୍ୱରସ୍ତଦ୍ ଦାସ୍ୟତୀତି ଜାନେଽହଂ| ");
INSERT INTO sanori_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","ଯୀଶୁରୱାଦୀତ୍ ତୱ ଭ୍ରାତା ସମୁତ୍ଥାସ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","ମର୍ଥା ୱ୍ୟାହରତ୍ ଶେଷଦିୱସେ ସ ଉତ୍ଥାନସମଯେ ପ୍ରୋତ୍ଥାସ୍ୟତୀତି ଜାନେଽହଂ| ");
INSERT INTO sanori_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","ତଦା ଯୀଶୁଃ କଥିତୱାନ୍ ଅହମେୱ ଉତ୍ଥାପଯିତା ଜୀୱଯିତା ଚ ଯଃ କଶ୍ଚନ ମଯି ୱିଶ୍ୱସିତି ସ ମୃତ୍ୱାପି ଜୀୱିଷ୍ୟତି; ");
INSERT INTO sanori_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ଯଃ କଶ୍ଚନ ଚ ଜୀୱନ୍ ମଯି ୱିଶ୍ୱସିତି ସ କଦାପି ନ ମରିଷ୍ୟତି, ଅସ୍ୟାଂ କଥାଯାଂ କିଂ ୱିଶ୍ୱସିଷି? ");
INSERT INTO sanori_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ସାୱଦତ୍ ପ୍ରଭୋ ଯସ୍ୟାୱତରଣାପେକ୍ଷାସ୍ତି ଭୱାନ୍ ସଏୱାଭିଷିକ୍ତ୍ତ ଈଶ୍ୱରପୁତ୍ର ଇତି ୱିଶ୍ୱସିମି| ");
INSERT INTO sanori_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ଇତି କଥାଂ କଥଯିତ୍ୱା ସା ଗତ୍ୱା ସ୍ୱାଂ ଭଗିନୀଂ ମରିଯମଂ ଗୁପ୍ତମାହୂଯ ୱ୍ୟାହରତ୍ ଗୁରୁରୁପତିଷ୍ଠତି ତ୍ୱାମାହୂଯତି ଚ| ");
INSERT INTO sanori_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","କଥାମିମାଂ ଶ୍ରୁତ୍ୱା ସା ତୂର୍ଣମ୍ ଉତ୍ଥାଯ ତସ୍ୟ ସମୀପମ୍ ଅଗଚ୍ଛତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ଯୀଶୁ ର୍ଗ୍ରାମମଧ୍ୟଂ ନ ପ୍ରୱିଶ୍ୟ ଯତ୍ର ମର୍ଥା ତଂ ସାକ୍ଷାଦ୍ ଅକରୋତ୍ ତତ୍ର ସ୍ଥିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","ଯେ ଯିହୂଦୀଯା ମରିଯମା ସାକଂ ଗୃହେ ତିଷ୍ଠନ୍ତସ୍ତାମ୍ ଅସାନ୍ତ୍ୱଯନ ତେ ତାଂ କ୍ଷିପ୍ରମ୍ ଉତ୍ଥାଯ ଗଚ୍ଛନ୍ତିଂ ୱିଲୋକ୍ୟ ୱ୍ୟାହରନ୍, ସ ଶ୍ମଶାନେ ରୋଦିତୁଂ ଯାତି, ଇତ୍ୟୁକ୍ତ୍ୱା ତେ ତସ୍ୟାଃ ପଶ୍ଚାଦ୍ ଅଗଚ୍ଛନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","ଯତ୍ର ଯୀଶୁରତିଷ୍ଠତ୍ ତତ୍ର ମରିଯମ୍ ଉପସ୍ଥାଯ ତଂ ଦୃଷ୍ଟ୍ୱା ତସ୍ୟ ଚରଣଯୋଃ ପତିତ୍ୱା ୱ୍ୟାହରତ୍ ହେ ପ୍ରଭୋ ଯଦି ଭୱାନ୍ ଅତ୍ରାସ୍ଥାସ୍ୟତ୍ ତର୍ହି ମମ ଭ୍ରାତା ନାମରିଷ୍ୟତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","ଯୀଶୁସ୍ତାଂ ତସ୍ୟାଃ ସଙ୍ଗିନୋ ଯିହୂଦୀଯାଂଶ୍ଚ ରୁଦତୋ ୱିଲୋକ୍ୟ ଶୋକାର୍ତ୍ତଃ ସନ୍ ଦୀର୍ଘଂ ନିଶ୍ୱସ୍ୟ କଥିତୱାନ୍ ତଂ କୁତ୍ରାସ୍ଥାପଯତ? ");
INSERT INTO sanori_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ତେ ୱ୍ୟାହରନ୍, ହେ ପ୍ରଭୋ ଭୱାନ୍ ଆଗତ୍ୟ ପଶ୍ୟତୁ| ");
INSERT INTO sanori_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","ଯୀଶୁନା କ୍ରନ୍ଦିତଂ| ");
INSERT INTO sanori_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ଅତଏୱ ଯିହୂଦୀଯା ଅୱଦନ୍, ପଶ୍ୟତାଯଂ ତସ୍ମିନ୍ କିଦୃଗ୍ ଅପ୍ରିଯତ| ");
INSERT INTO sanori_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","ତେଷାଂ କେଚିଦ୍ ଅୱଦନ୍ ଯୋନ୍ଧାଯ ଚକ୍ଷୁଷୀ ଦତ୍ତୱାନ୍ ସ କିମ୍ ଅସ୍ୟ ମୃତ୍ୟୁଂ ନିୱାରଯିତୁଂ ନାଶକ୍ନୋତ୍? ");
INSERT INTO sanori_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","ତତୋ ଯୀଶୁଃ ପୁନରନ୍ତର୍ଦୀର୍ଘଂ ନିଶ୍ୱସ୍ୟ ଶ୍ମଶାନାନ୍ତିକମ୍ ଅଗଚ୍ଛତ୍| ତତ୍ ଶ୍ମଶାନମ୍ ଏକଂ ଗହ୍ୱରଂ ତନ୍ମୁଖେ ପାଷାଣ ଏକ ଆସୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","ତଦା ଯୀଶୁରୱଦଦ୍ ଏନଂ ପାଷାଣମ୍ ଅପସାରଯତ, ତତଃ ପ୍ରମୀତସ୍ୟ ଭଗିନୀ ମର୍ଥାୱଦତ୍ ପ୍ରଭୋ, ଅଧୁନା ତତ୍ର ଦୁର୍ଗନ୍ଧୋ ଜାତଃ, ଯତୋଦ୍ୟ ଚତ୍ୱାରି ଦିନାନି ଶ୍ମଶାନେ ସ ତିଷ୍ଠତି| ");
INSERT INTO sanori_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","ତଦା ଯୀଶୁରୱାଦୀତ୍, ଯଦି ୱିଶ୍ୱସିଷି ତର୍ହୀଶ୍ୱରସ୍ୟ ମହିମପ୍ରକାଶଂ ଦ୍ରକ୍ଷ୍ୟସି କଥାମିମାଂ କିଂ ତୁଭ୍ୟଂ ନାକଥଯଂ? ");
INSERT INTO sanori_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","ତଦା ମୃତସ୍ୟ ଶ୍ମଶାନାତ୍ ପାଷାଣୋଽପସାରିତେ ଯୀଶୁରୂର୍ଦ୍ୱ୍ୱଂ ପଶ୍ୟନ୍ ଅକଥଯତ୍, ହେ ପିତ ର୍ମମ ନେୱେସନମ୍ ଅଶୃଣୋଃ କାରଣାଦସ୍ମାତ୍ ତ୍ୱାଂ ଧନ୍ୟଂ ୱଦାମି| ");
INSERT INTO sanori_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ତ୍ୱଂ ସତତଂ ଶୃଣୋଷି ତଦପ୍ୟହଂ ଜାନାମି, କିନ୍ତୁ ତ୍ୱଂ ମାଂ ଯତ୍ ପ୍ରୈରଯସ୍ତଦ୍ ଯଥାସ୍ମିନ୍ ସ୍ଥାନେ ସ୍ଥିତା ଲୋକା ୱିଶ୍ୱସନ୍ତି ତଦର୍ଥମ୍ ଇଦଂ ୱାକ୍ୟଂ ୱଦାମି| ");
INSERT INTO sanori_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ଇମାଂ କଥାଂ କଥଯିତ୍ୱା ସ ପ୍ରୋଚ୍ଚୈରାହ୍ୱଯତ୍, ହେ ଇଲିଯାସର୍ ବହିରାଗଚ୍ଛ| ");
INSERT INTO sanori_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","ତତଃ ସ ପ୍ରମୀତଃ ଶ୍ମଶାନୱସ୍ତ୍ରୈ ର୍ବଦ୍ଧହସ୍ତପାଦୋ ଗାତ୍ରମାର୍ଜନୱାସସା ବଦ୍ଧମୁଖଶ୍ଚ ବହିରାଗଚ୍ଛତ୍| ଯୀଶୁରୁଦିତୱାନ୍ ବନ୍ଧନାନି ମୋଚଯିତ୍ୱା ତ୍ୟଜତୈନଂ| ");
INSERT INTO sanori_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","ମରିଯମଃ ସମୀପମ୍ ଆଗତା ଯେ ଯିହୂଦୀଯଲୋକାସ୍ତଦା ଯୀଶୋରେତତ୍ କର୍ମ୍ମାପଶ୍ୟନ୍ ତେଷାଂ ବହୱୋ ୱ୍ୟଶ୍ୱସନ୍, ");
INSERT INTO sanori_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","କିନ୍ତୁ କେଚିଦନ୍ୟେ ଫିରୂଶିନାଂ ସମୀପଂ ଗତ୍ୱା ଯୀଶୋରେତସ୍ୟ କର୍ମ୍ମଣୋ ୱାର୍ତ୍ତାମ୍ ଅୱଦନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","ତତଃ ପରଂ ପ୍ରଧାନଯାଜକାଃ ଫିରୂଶିନାଶ୍ଚ ସଭାଂ କୃତ୍ୱା ୱ୍ୟାହରନ୍ ୱଯଂ କିଂ କୁର୍ମ୍ମଃ? ଏଷ ମାନୱୋ ବହୂନ୍ୟାଶ୍ଚର୍ୟ୍ୟକର୍ମ୍ମାଣି କରୋତି| ");
INSERT INTO sanori_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","ଯଦୀଦୃଶଂ କର୍ମ୍ମ କର୍ତ୍ତୁଂ ନ ୱାରଯାମସ୍ତର୍ହି ସର୍ୱ୍ୱେ ଲୋକାସ୍ତସ୍ମିନ୍ ୱିଶ୍ୱସିଷ୍ୟନ୍ତି ରୋମିଲୋକାଶ୍ଚାଗତ୍ୟାସ୍ମାକମ୍ ଅନଯା ରାଜଧାନ୍ୟା ସାର୍ଦ୍ଧଂ ରାଜ୍ୟମ୍ ଆଛେତ୍ସ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","ତଦା ତେଷାଂ କିଯଫାନାମା ଯସ୍ତସ୍ମିନ୍ ୱତ୍ସରେ ମହାଯାଜକପଦେ ନ୍ୟଯୁଜ୍ୟତ ସ ପ୍ରତ୍ୟୱଦଦ୍ ଯୂଯଂ କିମପି ନ ଜାନୀଥ; ");
INSERT INTO sanori_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ସମଗ୍ରଦେଶସ୍ୟ ୱିନାଶତୋପି ସର୍ୱ୍ୱଲୋକାର୍ଥମ୍ ଏକସ୍ୟ ଜନସ୍ୟ ମରଣମ୍ ଅସ୍ମାକଂ ମଙ୍ଗଲହେତୁକମ୍ ଏତସ୍ୟ ୱିୱେଚନାମପି ନ କୁରୁଥ| ");
INSERT INTO sanori_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","ଏତାଂ କଥାଂ ସ ନିଜବୁଦ୍ଧ୍ୟା ୱ୍ୟାହରଦ୍ ଇତି ନ, ");
INSERT INTO sanori_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","କିନ୍ତୁ ଯୀଶୂସ୍ତଦ୍ଦେଶୀଯାନାଂ କାରଣାତ୍ ପ୍ରାଣାନ୍ ତ୍ୟକ୍ଷ୍ୟତି, ଦିଶି ଦିଶି ୱିକୀର୍ଣାନ୍ ଈଶ୍ୱରସ୍ୟ ସନ୍ତାନାନ୍ ସଂଗୃହ୍ୟୈକଜାତିଂ କରିଷ୍ୟତି ଚ, ତସ୍ମିନ୍ ୱତ୍ସରେ କିଯଫା ମହାଯାଜକତ୍ୱପଦେ ନିଯୁକ୍ତଃ ସନ୍ ଇଦଂ ଭୱିଷ୍ୟଦ୍ୱାକ୍ୟଂ କଥିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","ତଦ୍ଦିନମାରଭ୍ୟ ତେ କଥଂ ତଂ ହନ୍ତୁଂ ଶକ୍ନୁୱନ୍ତୀତି ମନ୍ତ୍ରଣାଂ କର୍ତ୍ତୁଂ ପ୍ରାରେଭିରେ| ");
INSERT INTO sanori_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ଅତଏୱ ଯିହୂଦୀଯାନାଂ ମଧ୍ୟେ ଯୀଶୁଃ ସପ୍ରକାଶଂ ଗମନାଗମନେ ଅକୃତ୍ୱା ତସ୍ମାଦ୍ ଗତ୍ୱା ପ୍ରାନ୍ତରସ୍ୟ ସମୀପସ୍ଥାଯିପ୍ରଦେଶସ୍ୟେଫ୍ରାଯିମ୍ ନାମ୍ନି ନଗରେ ଶିଷ୍ୟୈଃ ସାକଂ କାଲଂ ଯାପଯିତୁଂ ପ୍ରାରେଭେ| ");
INSERT INTO sanori_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","ଅନନ୍ତରଂ ଯିହୂଦୀଯାନାଂ ନିସ୍ତାରୋତ୍ସୱେ ନିକଟୱର୍ତ୍ତିନି ସତି ତଦୁତ୍ସୱାତ୍ ପୂର୍ୱ୍ୱଂ ସ୍ୱାନ୍ ଶୁଚୀନ୍ କର୍ତ୍ତୁଂ ବହୱୋ ଜନା ଗ୍ରାମେଭ୍ୟୋ ଯିରୂଶାଲମ୍ ନଗରମ୍ ଆଗଚ୍ଛନ୍, ");
INSERT INTO sanori_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ଯୀଶୋରନ୍ୱେଷଣଂ କୃତ୍ୱା ମନ୍ଦିରେ ଦଣ୍ଡାଯମାନାଃ ସନ୍ତଃ ପରସ୍ପରଂ ୱ୍ୟାହରନ୍, ଯୁଷ୍ମାକଂ କୀଦୃଶୋ ବୋଧୋ ଜାଯତେ? ସ କିମ୍ ଉତ୍ସୱେଽସ୍ମିନ୍ ଅତ୍ରାଗମିଷ୍ୟତି? ");
INSERT INTO sanori_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","ସ ଚ କୁତ୍ରାସ୍ତି ଯଦ୍ୟେତତ୍ କଶ୍ଚିଦ୍ ୱେତ୍ତି ତର୍ହି ଦର୍ଶଯତୁ ପ୍ରଧାନଯାଜକାଃ ଫିରୂଶିନଶ୍ଚ ତଂ ଧର୍ତ୍ତୁଂ ପୂର୍ୱ୍ୱମ୍ ଇମାମ୍ ଆଜ୍ଞାଂ ପ୍ରାଚାରଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","ନିସ୍ତାରୋତ୍ସୱାତ୍ ପୂର୍ୱ୍ୱଂ ଦିନଷଟ୍କେ ସ୍ଥିତେ ଯୀଶୁ ର୍ୟଂ ପ୍ରମୀତମ୍ ଇଲିଯାସରଂ ଶ୍ମଶାନାଦ୍ ଉଦସ୍ଥାପରତ୍ ତସ୍ୟ ନିୱାସସ୍ଥାନଂ ବୈଥନିଯାଗ୍ରାମମ୍ ଆଗଚ୍ଛତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","ତତ୍ର ତଦର୍ଥଂ ରଜନ୍ୟାଂ ଭୋଜ୍ୟେ କୃତେ ମର୍ଥା ପର୍ୟ୍ୟୱେଷଯଦ୍ ଇଲିଯାସର୍ ଚ ତସ୍ୟ ସଙ୍ଗିଭିଃ ସାର୍ଦ୍ଧଂ ଭୋଜନାସନ ଉପାୱିଶତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","ତଦା ମରିଯମ୍ ଅର୍ଦ୍ଧସେଟକଂ ବହୁମୂଲ୍ୟଂ ଜଟାମାଂସୀଯଂ ତୈଲମ୍ ଆନୀଯ ଯୀଶୋଶ୍ଚରଣଯୋ ର୍ମର୍ଦ୍ଦଯିତ୍ୱା ନିଜକେଶ ର୍ମାର୍ଷ୍ଟୁମ୍ ଆରଭତ; ତଦା ତୈଲସ୍ୟ ପରିମଲେନ ଗୃହମ୍ ଆମୋଦିତମ୍ ଅଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ଯଃ ଶିମୋନଃ ପୁତ୍ର ରିଷ୍କରିଯୋତୀଯୋ ଯିହୂଦାନାମା ଯୀଶୁଂ ପରକରେଷୁ ସମର୍ପଯିଷ୍ୟତି ସ ଶିଷ୍ୟସ୍ତଦା କଥିତୱାନ୍, ");
INSERT INTO sanori_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","ଏତତ୍ତୈଲଂ ତ୍ରିଭିଃ ଶତୈ ର୍ମୁଦ୍ରାପଦୈ ର୍ୱିକ୍ରୀତଂ ସଦ୍ ଦରିଦ୍ରେଭ୍ୟଃ କୁତୋ ନାଦୀଯତ? ");
INSERT INTO sanori_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ସ ଦରିଦ୍ରଲୋକାର୍ଥମ୍ ଅଚିନ୍ତଯଦ୍ ଇତି ନ, କିନ୍ତୁ ସ ଚୌର ଏୱଂ ତନ୍ନିକଟେ ମୁଦ୍ରାସମ୍ପୁଟକସ୍ଥିତ୍ୟା ତନ୍ମଧ୍ୟେ ଯଦତିଷ୍ଠତ୍ ତଦପାହରତ୍ ତସ୍ମାତ୍ କାରଣାଦ୍ ଇମାଂ କଥାମକଥଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","ତଦା ଯୀଶୁରକଥଯଦ୍ ଏନାଂ ମା ୱାରଯ ସା ମମ ଶ୍ମଶାନସ୍ଥାପନଦିନାର୍ଥଂ ତଦରକ୍ଷଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","ଦରିଦ୍ରା ଯୁଷ୍ମାକଂ ସନ୍ନିଧୌ ସର୍ୱ୍ୱଦା ତିଷ୍ଠନ୍ତି କିନ୍ତ୍ୱହଂ ସର୍ୱ୍ୱଦା ଯୁଷ୍ମାକଂ ସନ୍ନିଧୌ ନ ତିଷ୍ଠାମି| ");
INSERT INTO sanori_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","ତତଃ ପରଂ ଯୀଶୁସ୍ତତ୍ରାସ୍ତୀତି ୱାର୍ତ୍ତାଂ ଶ୍ରୁତ୍ୱା ବହୱୋ ଯିହୂଦୀଯାସ୍ତଂ ଶ୍ମଶାନାଦୁତ୍ଥାପିତମ୍ ଇଲିଯାସରଞ୍ଚ ଦ୍ରଷ୍ଟୁଂ ତତ୍ ସ୍ଥାନମ୍ ଆଗଚ୍ଛନ| ");
INSERT INTO sanori_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","ତଦା ପ୍ରଧାନଯାଜକାସ୍ତମ୍ ଇଲିଯାସରମପି ସଂହର୍ତ୍ତୁମ୍ ଅମନ୍ତ୍ରଯନ୍ ; ");
INSERT INTO sanori_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ଯତସ୍ତେନ ବହୱୋ ଯିହୂଦୀଯା ଗତ୍ୱା ଯୀଶୌ ୱ୍ୟଶ୍ୱସନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","ଅନନ୍ତରଂ ଯୀଶୁ ର୍ୟିରୂଶାଲମ୍ ନଗରମ୍ ଆଗଚ୍ଛତୀତି ୱାର୍ତ୍ତାଂ ଶ୍ରୁତ୍ୱା ପରେଽହନି ଉତ୍ସୱାଗତା ବହୱୋ ଲୋକାଃ ");
INSERT INTO sanori_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ଖର୍ଜ୍ଜୂରପତ୍ରାଦ୍ୟାନୀଯ ତଂ ସାକ୍ଷାତ୍ କର୍ତ୍ତୁଂ ବହିରାଗତ୍ୟ ଜଯ ଜଯେତି ୱାଚଂ ପ୍ରୋଚ୍ଚୈ ର୍ୱକ୍ତୁମ୍ ଆରଭନ୍ତ, ଇସ୍ରାଯେଲୋ ଯୋ ରାଜା ପରମେଶ୍ୱରସ୍ୟ ନାମ୍ନାଗଚ୍ଛତି ସ ଧନ୍ୟଃ| ");
INSERT INTO sanori_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","ତଦା \"ହେ ସିଯୋନଃ କନ୍ୟେ ମା ଭୈଷୀଃ ପଶ୍ୟାଯଂ ତୱ ରାଜା ଗର୍ଦ୍ଦଭଶାୱକମ୍ ଆରୁହ୍ୟାଗଚ୍ଛତି\" ");
INSERT INTO sanori_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","ଇତି ଶାସ୍ତ୍ରୀଯୱଚନାନୁସାରେଣ ଯୀଶୁରେକଂ ଯୁୱଗର୍ଦ୍ଦଭଂ ପ୍ରାପ୍ୟ ତଦୁପର୍ୟ୍ୟାରୋହତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","ଅସ୍ୟାଃ ଘଟନାଯାସ୍ତାତ୍ପର୍ୟ୍ୟଂ ଶିଷ୍ୟାଃ ପ୍ରଥମଂ ନାବୁଧ୍ୟନ୍ତ, କିନ୍ତୁ ଯୀଶୌ ମହିମାନଂ ପ୍ରାପ୍ତେ ସତି ୱାକ୍ୟମିଦଂ ତସ୍ମିନ ଅକଥ୍ୟତ ଲୋକାଶ୍ଚ ତମ୍ପ୍ରତୀତ୍ଥମ୍ ଅକୁର୍ୱ୍ୱନ୍ ଇତି ତେ ସ୍ମୃତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","ସ ଇଲିଯାସରଂ ଶ୍ମଶାନାଦ୍ ଆଗନ୍ତୁମ୍ ଆହ୍ୱତୱାନ୍ ଶ୍ମଶାନାଞ୍ଚ ଉଦସ୍ଥାପଯଦ୍ ଯେ ଯେ ଲୋକାସ୍ତତ୍କର୍ମ୍ୟ ସାକ୍ଷାଦ୍ ଅପଶ୍ୟନ୍ ତେ ପ୍ରମାଣଂ ଦାତୁମ୍ ଆରଭନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ସ ଏତାଦୃଶମ୍ ଅଦ୍ଭୁତଂ କର୍ମ୍ମକରୋତ୍ ତସ୍ୟ ଜନଶ୍ରୁତେ ର୍ଲୋକାସ୍ତଂ ସାକ୍ଷାତ୍ କର୍ତ୍ତୁମ୍ ଆଗଚ୍ଛନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ତତଃ ଫିରୂଶିନଃ ପରସ୍ପରଂ ୱକ୍ତୁମ୍ ଆରଭନ୍ତ ଯୁଷ୍ମାକଂ ସର୍ୱ୍ୱାଶ୍ଚେଷ୍ଟା ୱୃଥା ଜାତାଃ, ଇତି କିଂ ଯୂଯଂ ନ ବୁଧ୍ୟଧ୍ୱେ? ପଶ୍ୟତ ସର୍ୱ୍ୱେ ଲୋକାସ୍ତସ୍ୟ ପଶ୍ଚାଦ୍ୱର୍ତ୍ତିନୋଭୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ଭଜନଂ କର୍ତ୍ତୁମ୍ ଉତ୍ସୱାଗତାନାଂ ଲୋକାନାଂ କତିପଯା ଜନା ଅନ୍ୟଦେଶୀଯା ଆସନ୍ , ");
INSERT INTO sanori_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ତେ ଗାଲୀଲୀଯବୈତ୍ସୈଦାନିୱାସିନଃ ଫିଲିପସ୍ୟ ସମୀପମ୍ ଆଗତ୍ୟ ୱ୍ୟାହରନ୍ ହେ ମହେଚ୍ଛ ୱଯଂ ଯୀଶୁଂ ଦ୍ରଷ୍ଟୁମ୍ ଇଚ୍ଛାମଃ| ");
INSERT INTO sanori_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ତତଃ ଫିଲିପୋ ଗତ୍ୱା ଆନ୍ଦ୍ରିଯମ୍ ଅୱଦତ୍ ପଶ୍ଚାଦ୍ ଆନ୍ଦ୍ରିଯଫିଲିପୌ ଯୀଶୱେ ୱାର୍ତ୍ତାମ୍ ଅକଥଯତାଂ| ");
INSERT INTO sanori_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","ତଦା ଯୀଶୁଃ ପ୍ରତ୍ୟୁଦିତୱାନ୍ ମାନୱସୁତସ୍ୟ ମହିମପ୍ରାପ୍ତିସମଯ ଉପସ୍ଥିତଃ| ");
INSERT INTO sanori_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ଅହଂ ଯୁଷ୍ମାନତିଯଥାର୍ଥଂ ୱଦାମି, ଧାନ୍ୟବୀଜଂ ମୃତ୍ତିକାଯାଂ ପତିତ୍ୱା ଯଦି ନ ମୃଯତେ ତର୍ହ୍ୟେକାକୀ ତିଷ୍ଠତି କିନ୍ତୁ ଯଦି ମୃଯତେ ତର୍ହି ବହୁଗୁଣଂ ଫଲଂ ଫଲତି| ");
INSERT INTO sanori_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ଯୋ ଜନେा ନିଜପ୍ରାଣାନ୍ ପ୍ରିଯାନ୍ ଜାନାତି ସ ତାନ୍ ହାରଯିଷ୍ୟତି କିନ୍ତୁ ଯେा ଜନ ଇହଲୋକେ ନିଜପ୍ରାଣାନ୍ ଅପ୍ରିଯାନ୍ ଜାନାତି ସେाନନ୍ତାଯୁଃ ପ୍ରାପ୍ତୁଂ ତାନ୍ ରକ୍ଷିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","କଶ୍ଚିଦ୍ ଯଦି ମମ ସେୱକୋ ଭୱିତୁଂ ୱାଞ୍ଛତି ତର୍ହି ସ ମମ ପଶ୍ଚାଦ୍ଗାମୀ ଭୱତୁ, ତସ୍ମାଦ୍ ଅହଂ ଯତ୍ର ତିଷ୍ଠାମି ମମ ସେୱକେाପି ତତ୍ର ସ୍ଥାସ୍ୟତି; ଯୋ ଜନୋ ମାଂ ସେୱତେ ମମ ପିତାପି ତଂ ସମ୍ମଂସ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","ସାମ୍ପ୍ରତଂ ମମ ପ୍ରାଣା ୱ୍ୟାକୁଲା ଭୱନ୍ତି, ତସ୍ମାଦ୍ ହେ ପିତର ଏତସ୍ମାତ୍ ସମଯାନ୍ ମାଂ ରକ୍ଷ, ଇତ୍ୟହଂ କିଂ ପ୍ରାର୍ଥଯିଷ୍ୟେ? କିନ୍ତ୍ୱହମ୍ ଏତତ୍ସମଯାର୍ଥମ୍ ଅୱତୀର୍ଣୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ହେ ପିତ: ସ୍ୱନାମ୍ନୋ ମହିମାନଂ ପ୍ରକାଶଯ; ତନୈୱ ସ୍ୱନାମ୍ନୋ ମହିମାନମ୍ ଅହଂ ପ୍ରାକାଶଯଂ ପୁନରପି ପ୍ରକାଶଯିଷ୍ୟାମି, ଏଷା ଗଗଣୀଯା ୱାଣୀ ତସ୍ମିନ୍ ସମଯେଽଜାଯତ| ");
INSERT INTO sanori_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","ତଚ୍ଶ୍ରୁତ୍ୱା ସମୀପସ୍ଥଲୋକାନାଂ କେଚିଦ୍ ଅୱଦନ୍ ମେଘୋଽଗର୍ଜୀତ୍, କେଚିଦ୍ ଅୱଦନ୍ ସ୍ୱର୍ଗୀଯଦୂତୋଽନେନ ସହ କଥାମଚକଥତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","ତଦା ଯୀଶୁଃ ପ୍ରତ୍ୟୱାଦୀତ୍, ମଦର୍ଥଂ ଶବ୍ଦୋଯଂ ନାଭୂତ୍ ଯୁଷ୍ମଦର୍ଥମେୱାଭୂତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","ଅଧୁନା ଜଗତୋସ୍ୟ ୱିଚାର: ସମ୍ପତ୍ସ୍ୟତେ, ଅଧୁନାସ୍ୟ ଜଗତ: ପତୀ ରାଜ୍ୟାତ୍ ଚ୍ୟୋଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","ଯଦ୍ୟଈ ପୃଥିୱ୍ୟା ଊର୍ଦ୍ୱ୍ୱେ ପ୍ରୋତ୍ଥାପିତୋସ୍ମି ତର୍ହି ସର୍ୱ୍ୱାନ୍ ମାନୱାନ୍ ସ୍ୱସମୀପମ୍ ଆକର୍ଷିଷ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","କଥଂ ତସ୍ୟ ମୃତି ର୍ଭୱିଷ୍ୟତି, ଏତଦ୍ ବୋଧଯିତୁଂ ସ ଇମାଂ କଥାମ୍ ଅକଥଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","ତଦା ଲୋକା ଅକଥଯନ୍ ସୋଭିଷିକ୍ତଃ ସର୍ୱ୍ୱଦା ତିଷ୍ଠତୀତି ୱ୍ୟୱସ୍ଥାଗ୍ରନ୍ଥେ ଶ୍ରୁତମ୍ ଅସ୍ମାଭିଃ, ତର୍ହି ମନୁଷ୍ୟପୁତ୍ରଃ ପ୍ରୋତ୍ଥାପିତୋ ଭୱିଷ୍ୟତୀତି ୱାକ୍ୟଂ କଥଂ ୱଦସି? ମନୁଷ୍ୟପୁତ୍ରୋଯଂ କଃ? ");
INSERT INTO sanori_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","ତଦା ଯୀଶୁରକଥାଯଦ୍ ଯୁଷ୍ମାଭିଃ ସାର୍ଦ୍ଧମ୍ ଅଲ୍ପଦିନାନି ଜ୍ୟୋତିରାସ୍ତେ, ଯଥା ଯୁଷ୍ମାନ୍ ଅନ୍ଧକାରୋ ନାଚ୍ଛାଦଯତି ତଦର୍ଥଂ ଯାୱତ୍କାଲଂ ଯୁଷ୍ମାଭିଃ ସାର୍ଦ୍ଧଂ ଜ୍ୟୋତିସ୍ତିଷ୍ଠତି ତାୱତ୍କାଲଂ ଗଚ୍ଛତ; ଯୋ ଜନୋଽନ୍ଧକାରେ ଗଚ୍ଛତି ସ କୁତ୍ର ଯାତୀତି ନ ଜାନାତି| ");
INSERT INTO sanori_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ଅତଏୱ ଯାୱତ୍କାଲଂ ଯୁଷ୍ମାକଂ ନିକଟେ ଜ୍ୟୋତିରାସ୍ତେ ତାୱତ୍କାଲଂ ଜ୍ୟୋତୀରୂପସନ୍ତାନା ଭୱିତୁଂ ଜ୍ୟୋତିଷି ୱିଶ୍ୱସିତ; ଇମାଂ କଥାଂ କଥଯିତ୍ୱା ଯୀଶୁଃ ପ୍ରସ୍ଥାଯ ତେଭ୍ୟଃ ସ୍ୱଂ ଗୁପ୍ତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","ଯଦ୍ୟପି ଯୀଶୁସ୍ତେଷାଂ ସମକ୍ଷମ୍ ଏତାୱଦାଶ୍ଚର୍ୟ୍ୟକର୍ମ୍ମାଣି କୃତୱାନ୍ ତଥାପି ତେ ତସ୍ମିନ୍ ନ ୱ୍ୟଶ୍ୱସନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ଅତଏୱ କଃ ପ୍ରତ୍ୟେତି ସୁସଂୱାଦଂ ପରେଶାସ୍ମତ୍ ପ୍ରଚାରିତଂ? ପ୍ରକାଶତେ ପରେଶସ୍ୟ ହସ୍ତଃ କସ୍ୟ ଚ ସନ୍ନିଧୌ? ଯିଶଯିଯଭୱିଷ୍ୟଦ୍ୱାଦିନା ଯଦେତଦ୍ ୱାକ୍ୟମୁକ୍ତଂ ତତ୍ ସଫଲମ୍ ଅଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","ତେ ପ୍ରତ୍ୟେତୁଂ ନାଶନ୍କୁୱନ୍ ତସ୍ମିନ୍ ଯିଶଯିଯଭୱିଷ୍ୟଦ୍ୱାଦି ପୁନରୱାଦୀଦ୍, ");
INSERT INTO sanori_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","ଯଦା, \"ତେ ନଯନୈ ର୍ନ ପଶ୍ୟନ୍ତି ବୁଦ୍ଧିଭିଶ୍ଚ ନ ବୁଧ୍ୟନ୍ତେ ତୈ ର୍ମନଃସୁ ପରିୱର୍ତ୍ତିତେଷୁ ଚ ତାନହଂ ଯଥା ସ୍ୱସ୍ଥାନ୍ ନ କରୋମି ତଥା ସ ତେଷାଂ ଲୋଚନାନ୍ୟନ୍ଧାନି କୃତ୍ୱା ତେଷାମନ୍ତଃକରଣାନି ଗାଢାନି କରିଷ୍ୟତି| \" ");
INSERT INTO sanori_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","ଯିଶଯିଯୋ ଯଦା ଯୀଶୋ ର୍ମହିମାନଂ ୱିଲୋକ୍ୟ ତସ୍ମିନ୍ କଥାମକଥଯତ୍ ତଦା ଭୱିଷ୍ୟଦ୍ୱାକ୍ୟମ୍ ଈଦୃଶଂ ପ୍ରକାଶଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ତଥାପ୍ୟଧିପତିନାଂ ବହୱସ୍ତସ୍ମିନ୍ ପ୍ରତ୍ୟାଯନ୍| କିନ୍ତୁ ଫିରୂଶିନସ୍ତାନ୍ ଭଜନଗୃହାଦ୍ ଦୂରୀକୁର୍ୱ୍ୱନ୍ତୀତି ଭଯାତ୍ ତେ ତଂ ନ ସ୍ୱୀକୃତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ଯତ ଈଶ୍ୱରସ୍ୟ ପ୍ରଶଂସାତୋ ମାନୱାନାଂ ପ୍ରଶଂସାଯାଂ ତେଽପ୍ରିଯନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","ତଦା ଯୀଶୁରୁଚ୍ଚୈଃକାରମ୍ ଅକଥଯଦ୍ ଯୋ ଜନୋ ମଯି ୱିଶ୍ୱସିତି ସ କେୱଲେ ମଯି ୱିଶ୍ୱସିତୀତି ନ, ସ ମତ୍ପ୍ରେରକେଽପି ୱିଶ୍ୱସିତି| ");
INSERT INTO sanori_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ଯୋ ଜନୋ ମାଂ ପଶ୍ୟତି ସ ମତ୍ପ୍ରେରକମପି ପଶ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","ଯୋ ଜନୋ ମାଂ ପ୍ରତ୍ୟେତି ସ ଯଥାନ୍ଧକାରେ ନ ତିଷ୍ଠତି ତଦର୍ଥମ୍ ଅହଂ ଜ୍ୟୋତିଃସ୍ୱରୂପୋ ଭୂତ୍ୱା ଜଗତ୍ୟସ୍ମିନ୍ ଅୱତୀର୍ଣୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","ମମ କଥାଂ ଶ୍ରୁତ୍ୱା ଯଦି କଶ୍ଚିନ୍ ନ ୱିଶ୍ୱସିତି ତର୍ହି ତମହଂ ଦୋଷିଣଂ ନ କରୋମି, ଯତୋ ହେତୋ ର୍ଜଗତୋ ଜନାନାଂ ଦୋଷାନ୍ ନିଶ୍ଚିତାନ୍ କର୍ତ୍ତୁଂ ନାଗତ୍ୟ ତାନ୍ ପରିଚାତୁମ୍ ଆଗତୋସ୍ମି| ");
INSERT INTO sanori_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ଯଃ କଶ୍ଚିନ୍ ମାଂ ନ ଶ୍ରଦ୍ଧାଯ ମମ କଥଂ ନ ଗୃହ୍ଲାତି, ଅନ୍ୟସ୍ତଂ ଦୋଷିଣଂ କରିଷ୍ୟତି ୱସ୍ତୁତସ୍ତୁ ଯାଂ କଥାମହମ୍ ଅଚକଥଂ ସା କଥା ଚରମେଽନ୍ହି ତଂ ଦୋଷିଣଂ କରିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","ଯତୋ ହେତୋରହଂ ସ୍ୱତଃ କିମପି ନ କଥଯାମି, କିଂ କିଂ ମଯା କଥଯିତୱ୍ୟଂ କିଂ ସମୁପଦେଷ୍ଟୱ୍ୟଞ୍ଚ ଇତି ମତ୍ପ୍ରେରଯିତା ପିତା ମାମାଜ୍ଞାପଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ତସ୍ୟ ସାଜ୍ଞା ଅନନ୍ତାଯୁରିତ୍ୟହଂ ଜାନାମି, ଅତଏୱାହଂ ଯତ୍ କଥଯାମି ତତ୍ ପିତା ଯଥାଜ୍ଞାପଯତ୍ ତଥୈୱ କଥଯାମ୍ୟହମ୍| ");
INSERT INTO sanori_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","ନିସ୍ତାରୋତ୍ସୱସ୍ୟ କିଞ୍ଚିତ୍କାଲାତ୍ ପୂର୍ୱ୍ୱଂ ପୃଥିୱ୍ୟାଃ ପିତୁଃ ସମୀପଗମନସ୍ୟ ସମଯଃ ସନ୍ନିକର୍ଷୋଭୂଦ୍ ଇତି ଜ୍ଞାତ୍ୱା ଯୀଶୁରାପ୍ରଥମାଦ୍ ଯେଷୁ ଜଗତ୍ପ୍ରୱାସିଷ୍ୱାତ୍ମୀଯଲୋକେଷ ପ୍ରେମ କରୋତି ସ୍ମ ତେଷୁ ଶେଷଂ ଯାୱତ୍ ପ୍ରେମ କୃତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","ପିତା ତସ୍ୟ ହସ୍ତେ ସର୍ୱ୍ୱଂ ସମର୍ପିତୱାନ୍ ସ୍ୱଯମ୍ ଈଶ୍ୱରସ୍ୟ ସମୀପାଦ୍ ଆଗଚ୍ଛଦ୍ ଈଶ୍ୱରସ୍ୟ ସମୀପଂ ଯାସ୍ୟତି ଚ, ସର୍ୱ୍ୱାଣ୍ୟେତାନି ଜ୍ଞାତ୍ୱା ରଜନ୍ୟାଂ ଭୋଜନେ ସମ୍ପୂର୍ଣେ ସତି, ");
INSERT INTO sanori_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ଯଦା ଶୈତାନ୍ ତଂ ପରହସ୍ତେଷୁ ସମର୍ପଯିତୁଂ ଶିମୋନଃ ପୁତ୍ରସ୍ୟ ଈଷ୍କାରିଯୋତିଯସ୍ୟ ଯିହୂଦା ଅନ୍ତଃକରଣେ କୁପ୍ରୱୃତ୍ତିଂ ସମାର୍ପଯତ୍, ");
INSERT INTO sanori_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ତଦା ଯୀଶୁ ର୍ଭୋଜନାସନାଦ୍ ଉତ୍ଥାଯ ଗାତ୍ରୱସ୍ତ୍ରଂ ମୋଚଯିତ୍ୱା ଗାତ୍ରମାର୍ଜନୱସ୍ତ୍ରଂ ଗୃହୀତ୍ୱା ତେନ ସ୍ୱକଟିମ୍ ଅବଧ୍ନାତ୍, ");
INSERT INTO sanori_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ପଶ୍ଚାଦ୍ ଏକପାତ୍ରେ ଜଲମ୍ ଅଭିଷିଚ୍ୟ ଶିଷ୍ୟାଣାଂ ପାଦାନ୍ ପ୍ରକ୍ଷାଲ୍ୟ ତେନ କଟିବଦ୍ଧଗାତ୍ରମାର୍ଜନୱାସସା ମାର୍ଷ୍ଟୁଂ ପ୍ରାରଭତ| ");
INSERT INTO sanori_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ତତଃ ଶିମୋନ୍ପିତରସ୍ୟ ସମୀପମାଗତେ ସ ଉକ୍ତୱାନ୍ ହେ ପ୍ରଭୋ ଭୱାନ୍ କିଂ ମମ ପାଦୌ ପ୍ରକ୍ଷାଲଯିଷ୍ୟତି? ");
INSERT INTO sanori_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ଯୀଶୁରୁଦିତୱାନ୍ ଅହଂ ଯତ୍ କରୋମି ତତ୍ ସମ୍ପ୍ରତି ନ ଜାନାସି କିନ୍ତୁ ପଶ୍ଚାଜ୍ ଜ୍ଞାସ୍ୟସି| ");
INSERT INTO sanori_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","ତତଃ ପିତରଃ କଥିତୱାନ୍ ଭୱାନ୍ କଦାପି ମମ ପାଦୌ ନ ପ୍ରକ୍ଷାଲଯିଷ୍ୟତି| ଯୀଶୁରକଥଯଦ୍ ଯଦି ତ୍ୱାଂ ନ ପ୍ରକ୍ଷାଲଯେ ତର୍ହି ମଯି ତୱ କୋପ୍ୟଂଶୋ ନାସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ତଦା ଶିମୋନ୍ପିତରଃ କଥିତୱାନ୍ ହେ ପ୍ରଭୋ ତର୍ହି କେୱଲପାଦୌ ନ, ମମ ହସ୍ତୌ ଶିରଶ୍ଚ ପ୍ରକ୍ଷାଲଯତୁ| ");
INSERT INTO sanori_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ତତୋ ଯୀଶୁରୱଦଦ୍ ଯୋ ଜନୋ ଧୌତସ୍ତସ୍ୟ ସର୍ୱ୍ୱାଙ୍ଗପରିଷ୍କୃତତ୍ୱାତ୍ ପାଦୌ ୱିନାନ୍ୟାଙ୍ଗସ୍ୟ ପ୍ରକ୍ଷାଲନାପେକ୍ଷା ନାସ୍ତି| ଯୂଯଂ ପରିଷ୍କୃତା ଇତି ସତ୍ୟଂ କିନ୍ତୁ ନ ସର୍ୱ୍ୱେ, ");
INSERT INTO sanori_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","ଯତୋ ଯୋ ଜନସ୍ତଂ ପରକରେଷୁ ସମର୍ପଯିଷ୍ୟତି ତଂ ସ ଜ୍ଞାତୱାନ; ଅତଏୱ ଯୂଯଂ ସର୍ୱ୍ୱେ ନ ପରିଷ୍କୃତା ଇମାଂ କଥାଂ କଥିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ଇତ୍ଥଂ ଯୀଶୁସ୍ତେଷାଂ ପାଦାନ୍ ପ୍ରକ୍ଷାଲ୍ୟ ୱସ୍ତ୍ରଂ ପରିଧାଯାସନେ ସମୁପୱିଶ୍ୟ କଥିତୱାନ୍ ଅହଂ ଯୁଷ୍ମାନ୍ ପ୍ରତି କିଂ କର୍ମ୍ମାକାର୍ଷଂ ଜାନୀଥ? ");
INSERT INTO sanori_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","ଯୂଯଂ ମାଂ ଗୁରୁଂ ପ୍ରଭୁଞ୍ଚ ୱଦଥ ତତ୍ ସତ୍ୟମେୱ ୱଦଥ ଯତୋହଂ ସଏୱ ଭୱାମି| ");
INSERT INTO sanori_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ଯଦ୍ୟହଂ ପ୍ରଭୁ ର୍ଗୁରୁଶ୍ଚ ସନ୍ ଯୁଷ୍ମାକଂ ପାଦାନ୍ ପ୍ରକ୍ଷାଲିତୱାନ୍ ତର୍ହି ଯୁଷ୍ମାକମପି ପରସ୍ପରଂ ପାଦପ୍ରକ୍ଷାଲନମ୍ ଉଚିତମ୍| ");
INSERT INTO sanori_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","ଅହଂ ଯୁଷ୍ମାନ୍ ପ୍ରତି ଯଥା ୱ୍ୟୱାହରଂ ଯୁଷ୍ମାନ୍ ତଥା ୱ୍ୟୱହର୍ତ୍ତୁମ୍ ଏକଂ ପନ୍ଥାନଂ ଦର୍ଶିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","ଅହଂ ଯୁଷ୍ମାନତିଯଥାର୍ଥଂ ୱଦାମି, ପ୍ରଭୋ ର୍ଦାସୋ ନ ମହାନ୍ ପ୍ରେରକାଚ୍ଚ ପ୍ରେରିତୋ ନ ମହାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ଇମାଂ କଥାଂ ୱିଦିତ୍ୱା ଯଦି ତଦନୁସାରତଃ କର୍ମ୍ମାଣି କୁରୁଥ ତର୍ହି ଯୂଯଂ ଧନ୍ୟା ଭୱିଷ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","ସର୍ୱ୍ୱେଷୁ ଯୁଷ୍ମାସୁ କଥାମିମାଂ କଥଯାମି ଇତି ନ, ଯେ ମମ ମନୋନୀତାସ୍ତାନହଂ ଜାନାମି, କିନ୍ତୁ ମମ ଭକ୍ଷ୍ୟାଣି ଯୋ ଭୁଙ୍କ୍ତେ ମତ୍ପ୍ରାଣପ୍ରାତିକୂଲ୍ୟତଃ| ଉତ୍ଥାପଯତି ପାଦସ୍ୟ ମୂଲଂ ସ ଏଷ ମାନୱଃ| ଯଦେତଦ୍ ଧର୍ମ୍ମପୁସ୍ତକସ୍ୟ ୱଚନଂ ତଦନୁସାରେଣାୱଶ୍ୟଂ ଘଟିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","ଅହଂ ସ ଜନ ଇତ୍ୟତ୍ର ଯଥା ଯୁଷ୍ମାକଂ ୱିଶ୍ୱାସୋ ଜାଯତେ ତଦର୍ଥଂ ଏତାଦୃଶଘଟନାତ୍ ପୂର୍ୱ୍ୱମ୍ ଅହମିଦାନୀଂ ଯୁଷ୍ମଭ୍ୟମକଥଯମ୍| ");
INSERT INTO sanori_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","ଅହଂ ଯୁଷ୍ମାନତୀୱ ଯଥାର୍ଥଂ ୱଦାମି, ମଯା ପ୍ରେରିତଂ ଜନଂ ଯୋ ଗୃହ୍ଲାତି ସ ମାମେୱ ଗୃହ୍ଲାତି ଯଶ୍ଚ ମାଂ ଗୃହ୍ଲାତି ସ ମତ୍ପ୍ରେରକଂ ଗୃହ୍ଲାତି| ");
INSERT INTO sanori_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ଏତାଂ କଥାଂ କଥଯିତ୍ୱା ଯୀଶୁ ର୍ଦୁଃଖୀ ସନ୍ ପ୍ରମାଣଂ ଦତ୍ତ୍ୱା କଥିତୱାନ୍ ଅହଂ ଯୁଷ୍ମାନତିଯଥାର୍ଥଂ ୱଦାମି ଯୁଷ୍ମାକମ୍ ଏକୋ ଜନୋ ମାଂ ପରକରେଷୁ ସମର୍ପଯିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ତତଃ ସ କମୁଦ୍ଦିଶ୍ୟ କଥାମେତାଂ କଥିତୱାନ୍ ଇତ୍ୟତ୍ର ସନ୍ଦିଗ୍ଧାଃ ଶିଷ୍ୟାଃ ପରସ୍ପରଂ ମୁଖମାଲୋକଯିତୁଂ ପ୍ରାରଭନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ତସ୍ମିନ୍ ସମଯେ ଯୀଶୁ ର୍ୟସ୍ମିନ୍ ଅପ୍ରୀଯତ ସ ଶିଷ୍ୟସ୍ତସ୍ୟ ୱକ୍ଷଃସ୍ଥଲମ୍ ଅୱାଲମ୍ବତ| ");
INSERT INTO sanori_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ଶିମୋନ୍ପିତରସ୍ତଂ ସଙ୍କେତେନାୱଦତ୍, ଅଯଂ କମୁଦ୍ଦିଶ୍ୟ କଥାମେତାମ୍ କଥଯତୀତି ପୃଚ୍ଛ| ");
INSERT INTO sanori_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ତଦା ସ ଯୀଶୋ ର୍ୱକ୍ଷଃସ୍ଥଲମ୍ ଅୱଲମ୍ବ୍ୟ ପୃଷ୍ଠୱାନ୍, ହେ ପ୍ରଭୋ ସ ଜନଃ କଃ? ");
INSERT INTO sanori_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ତତୋ ଯୀଶୁଃ ପ୍ରତ୍ୟୱଦଦ୍ ଏକଖଣ୍ଡଂ ପୂପଂ ମଜ୍ଜଯିତ୍ୱା ଯସ୍ମୈ ଦାସ୍ୟାମି ସଏୱ ସଃ; ପଶ୍ଚାତ୍ ପୂପଖଣ୍ଡମେକଂ ମଜ୍ଜଯିତ୍ୱା ଶିମୋନଃ ପୁତ୍ରାଯ ଈଷ୍କରିଯୋତୀଯାଯ ଯିହୂଦୈ ଦତ୍ତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","ତସ୍ମିନ୍ ଦତ୍ତେ ସତି ଶୈତାନ୍ ତମାଶ୍ରଯତ୍; ତଦା ଯୀଶୁସ୍ତମ୍ ଅୱଦତ୍ ତ୍ୱଂ ଯତ୍ କରିଷ୍ୟସି ତତ୍ କ୍ଷିପ୍ରଂ କୁରୁ| ");
INSERT INTO sanori_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","କିନ୍ତୁ ସ ଯେନାଶଯେନ ତାଂ କଥାମକଥାଯତ୍ ତମ୍ ଉପୱିଷ୍ଟଲୋକାନାଂ କୋପି ନାବୁଧ୍ୟତ; ");
INSERT INTO sanori_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","କିନ୍ତୁ ଯିହୂଦାଃ ସମୀପେ ମୁଦ୍ରାସମ୍ପୁଟକସ୍ଥିତେଃ କେଚିଦ୍ ଇତ୍ଥମ୍ ଅବୁଧ୍ୟନ୍ତ ପାର୍ୱ୍ୱଣାସାଦନାର୍ଥଂ କିମପି ଦ୍ରୱ୍ୟଂ କ୍ରେତୁଂ ୱା ଦରିଦ୍ରେଭ୍ୟଃ କିଞ୍ଚିଦ୍ ୱିତରିତୁଂ କଥିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ତଦା ପୂପଖଣ୍ଡଗ୍ରହଣାତ୍ ପରଂ ସ ତୂର୍ଣଂ ବହିରଗଚ୍ଛତ୍; ରାତ୍ରିଶ୍ଚ ସମୁପସ୍ୟିତା| ");
INSERT INTO sanori_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","ଯିହୂଦେ ବହିର୍ଗତେ ଯୀଶୁରକଥଯଦ୍ ଇଦାନୀଂ ମାନୱସୁତସ୍ୟ ମହିମା ପ୍ରକାଶତେ ତେନେଶ୍ୱରସ୍ୟାପି ମହିମା ପ୍ରକାଶତେ| ");
INSERT INTO sanori_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ଯଦି ତେନେଶ୍ୱରସ୍ୟ ମହିମା ପ୍ରକାଶତେ ତର୍ହୀଶ୍ୱରୋପି ସ୍ୱେନ ତସ୍ୟ ମହିମାନଂ ପ୍ରକାଶଯିଷ୍ୟତି ତୂର୍ଣମେୱ ପ୍ରକାଶଯିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ହେ ୱତ୍ସା ଅହଂ ଯୁଷ୍ମାଭିଃ ସାର୍ଦ୍ଧଂ କିଞ୍ଚିତ୍କାଲମାତ୍ରମ୍ ଆସେ, ତତଃ ପରଂ ମାଂ ମୃଗଯିଷ୍ୟଧ୍ୱେ କିନ୍ତ୍ୱହଂ ଯତ୍ସ୍ଥାନଂ ଯାମି ତତ୍ସ୍ଥାନଂ ଯୂଯଂ ଗନ୍ତୁଂ ନ ଶକ୍ଷ୍ୟଥ, ଯାମିମାଂ କଥାଂ ଯିହୂଦୀଯେଭ୍ୟଃ କଥିତୱାନ୍ ତଥାଧୁନା ଯୁଷ୍ମଭ୍ୟମପି କଥଯାମି| ");
INSERT INTO sanori_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","ଯୂଯଂ ପରସ୍ପରଂ ପ୍ରୀଯଧ୍ୱମ୍ ଅହଂ ଯୁଷ୍ମାସୁ ଯଥା ପ୍ରୀଯେ ଯୂଯମପି ପରସ୍ପରମ୍ ତଥୈୱ ପ୍ରୀଯଧ୍ୱଂ, ଯୁଷ୍ମାନ୍ ଇମାଂ ନୱୀନାମ୍ ଆଜ୍ଞାମ୍ ଆଦିଶାମି| ");
INSERT INTO sanori_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","ତେନୈୱ ଯଦି ପରସ୍ପରଂ ପ୍ରୀଯଧ୍ୱେ ତର୍ହି ଲକ୍ଷଣେନାନେନ ଯୂଯଂ ମମ ଶିଷ୍ୟା ଇତି ସର୍ୱ୍ୱେ ଜ୍ଞାତୁଂ ଶକ୍ଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ଶିମୋନପିତରଃ ପୃଷ୍ଠୱାନ୍ ହେ ପ୍ରଭୋ ଭୱାନ୍ କୁତ୍ର ଯାସ୍ୟତି? ତତୋ ଯୀଶୁଃ ପ୍ରତ୍ୟୱଦତ୍, ଅହଂ ଯତ୍ସ୍ଥାନଂ ଯାମି ତତ୍ସ୍ଥାନଂ ସାମ୍ପ୍ରତଂ ମମ ପଶ୍ଚାଦ୍ ଗନ୍ତୁଂ ନ ଶକ୍ନୋଷି କିନ୍ତୁ ପଶ୍ଚାଦ୍ ଗମିଷ୍ୟସି| ");
INSERT INTO sanori_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","ତଦା ପିତରଃ ପ୍ରତ୍ୟୁଦିତୱାନ୍, ହେ ପ୍ରଭୋ ସାମ୍ପ୍ରତଂ କୁତୋ ହେତୋସ୍ତୱ ପଶ୍ଚାଦ୍ ଗନ୍ତୁଂ ନ ଶକ୍ନୋମି? ତ୍ୱଦର୍ଥଂ ପ୍ରାଣାନ୍ ଦାତୁଂ ଶକ୍ନୋମି| ");
INSERT INTO sanori_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ତତୋ ଯୀଶୁଃ ପ୍ରତ୍ୟୁକ୍ତୱାନ୍ ମନ୍ନିମିତ୍ତଂ କିଂ ପ୍ରାଣାନ୍ ଦାତୁଂ ଶକ୍ନୋଷି? ତ୍ୱାମହଂ ଯଥାର୍ଥଂ ୱଦାମି, କୁକ୍କୁଟରୱଣାତ୍ ପୂର୍ୱ୍ୱଂ ତ୍ୱଂ ତ୍ରି ର୍ମାମ୍ ଅପହ୍ନୋଷ୍ୟସେ| ");
INSERT INTO sanori_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","ମନୋଦୁଃଖିନୋ ମା ଭୂତ; ଈଶ୍ୱରେ ୱିଶ୍ୱସିତ ମଯି ଚ ୱିଶ୍ୱସିତ| ");
INSERT INTO sanori_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","ମମ ପିତୁ ଗୃହେ ବହୂନି ୱାସସ୍ଥାନି ସନ୍ତି ନୋ ଚେତ୍ ପୂର୍ୱ୍ୱଂ ଯୁଷ୍ମାନ୍ ଅଜ୍ଞାପଯିଷ୍ୟଂ ଯୁଷ୍ମଦର୍ଥଂ ସ୍ଥାନଂ ସଜ୍ଜଯିତୁଂ ଗଚ୍ଛାମି| ");
INSERT INTO sanori_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","ଯଦି ଗତ୍ୱାହଂ ଯୁଷ୍ମନ୍ନିମିତ୍ତଂ ସ୍ଥାନଂ ସଜ୍ଜଯାମି ତର୍ହି ପନରାଗତ୍ୟ ଯୁଷ୍ମାନ୍ ସ୍ୱସମୀପଂ ନେଷ୍ୟାମି, ତତୋ ଯତ୍ରାହଂ ତିଷ୍ଠାମି ତତ୍ର ଯୂଯମପି ସ୍ଥାସ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ଅହଂ ଯତ୍ସ୍ଥାନଂ ବ୍ରଜାମି ତତ୍ସ୍ଥାନଂ ଯୂଯଂ ଜାନୀଥ ତସ୍ୟ ପନ୍ଥାନମପି ଜାନୀଥ| ");
INSERT INTO sanori_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","ତଦା ଥୋମା ଅୱଦତ୍, ହେ ପ୍ରଭୋ ଭୱାନ୍ କୁତ୍ର ଯାତି ତଦ୍ୱଯଂ ନ ଜାନୀମଃ, ତର୍ହି କଥଂ ପନ୍ଥାନଂ ଜ୍ଞାତୁଂ ଶକ୍ନୁମଃ? ");
INSERT INTO sanori_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","ଯୀଶୁରକଥଯଦ୍ ଅହମେୱ ସତ୍ୟଜୀୱନରୂପପଥୋ ମଯା ନ ଗନ୍ତା କୋପି ପିତୁଃ ସମୀପଂ ଗନ୍ତୁଂ ନ ଶକ୍ନୋତି| ");
INSERT INTO sanori_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","ଯଦି ମାମ୍ ଅଜ୍ଞାସ୍ୟତ ତର୍ହି ମମ ପିତରମପ୍ୟଜ୍ଞାସ୍ୟତ କିନ୍ତ୍ୱଧୁନାତସ୍ତଂ ଜାନୀଥ ପଶ୍ୟଥ ଚ| ");
INSERT INTO sanori_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ତଦା ଫିଲିପଃ କଥିତୱାନ୍, ହେ ପ୍ରଭୋ ପିତରଂ ଦର୍ଶଯ ତସ୍ମାଦସ୍ମାକଂ ଯଥେଷ୍ଟଂ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ତତୋ ଯୀଶୁଃ ପ୍ରତ୍ୟାୱାଦୀତ୍, ହେ ଫିଲିପ ଯୁଷ୍ମାଭିଃ ସାର୍ଦ୍ଧମ୍ ଏତାୱଦ୍ଦିନାନି ସ୍ଥିତମପି ମାଂ କିଂ ନ ପ୍ରତ୍ୟଭିଜାନାସି? ଯୋ ଜନୋ ମାମ୍ ଅପଶ୍ୟତ୍ ସ ପିତରମପ୍ୟପଶ୍ୟତ୍ ତର୍ହି ପିତରମ୍ ଅସ୍ମାନ୍ ଦର୍ଶଯେତି କଥାଂ କଥଂ କଥଯସି? ");
INSERT INTO sanori_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ଅହଂ ପିତରି ତିଷ୍ଠାମି ପିତା ମଯି ତିଷ୍ଠତୀତି କିଂ ତ୍ୱଂ ନ ପ୍ରତ୍ୟଷି? ଅହଂ ଯଦ୍ୱାକ୍ୟଂ ୱଦାମି ତତ୍ ସ୍ୱତୋ ନ ୱଦାମି କିନ୍ତୁ ଯଃ ପିତା ମଯି ୱିରାଜତେ ସ ଏୱ ସର୍ୱ୍ୱକର୍ମ୍ମାଣି କରାତି| ");
INSERT INTO sanori_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ଅତଏୱ ପିତର୍ୟ୍ୟହଂ ତିଷ୍ଠାମି ପିତା ଚ ମଯି ତିଷ୍ଠତି ମମାସ୍ୟାଂ କଥାଯାଂ ପ୍ରତ୍ୟଯଂ କୁରୁତ, ନୋ ଚେତ୍ କର୍ମ୍ମହେତୋଃ ପ୍ରତ୍ୟଯଂ କୁରୁତ| ");
INSERT INTO sanori_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","ଅହଂ ଯୁଷ୍ମାନତିଯଥାର୍ଥଂ ୱଦାମି, ଯୋ ଜନୋ ମଯି ୱିଶ୍ୱସିତି ସୋହମିୱ କର୍ମ୍ମାଣି କରିଷ୍ୟତି ୱରଂ ତତୋପି ମହାକର୍ମ୍ମାଣି କରିଷ୍ୟତି ଯତୋ ହେତୋରହଂ ପିତୁଃ ସମୀପଂ ଗଚ୍ଛାମି| ");
INSERT INTO sanori_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","ଯଥା ପୁତ୍ରେଣ ପିତୁ ର୍ମହିମା ପ୍ରକାଶତେ ତଦର୍ଥଂ ମମ ନାମ ପ୍ରୋଚ୍ୟ ଯତ୍ ପ୍ରାର୍ଥଯିଷ୍ୟଧ୍ୱେ ତତ୍ ସଫଲଂ କରିଷ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","ଯଦି ମମ ନାମ୍ନା ଯତ୍ କିଞ୍ଚିଦ୍ ଯାଚଧ୍ୱେ ତର୍ହି ତଦହଂ ସାଧଯିଷ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","ଯଦି ମଯି ପ୍ରୀଯଧ୍ୱେ ତର୍ହି ମମାଜ୍ଞାଃ ସମାଚରତ| ");
INSERT INTO sanori_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ତତୋ ମଯା ପିତୁଃ ସମୀପେ ପ୍ରାର୍ଥିତେ ପିତା ନିରନ୍ତରଂ ଯୁଷ୍ମାଭିଃ ସାର୍ଦ୍ଧଂ ସ୍ଥାତୁମ୍ ଇତରମେକଂ ସହାଯମ୍ ଅର୍ଥାତ୍ ସତ୍ୟମଯମ୍ ଆତ୍ମାନଂ ଯୁଷ୍ମାକଂ ନିକଟଂ ପ୍ରେଷଯିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ଏତଜ୍ଜଗତୋ ଲୋକାସ୍ତଂ ଗ୍ରହୀତୁଂ ନ ଶକ୍ନୁୱନ୍ତି ଯତସ୍ତେ ତଂ ନାପଶ୍ୟନ୍ ନାଜନଂଶ୍ଚ କିନ୍ତୁ ଯୂଯଂ ଜାନୀଥ ଯତୋ ହେତୋଃ ସ ଯୁଷ୍ମାକମନ୍ତ ର୍ନିୱସତି ଯୁଷ୍ମାକଂ ମଧ୍ୟେ ସ୍ଥାସ୍ୟତି ଚ| ");
INSERT INTO sanori_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","ଅହଂ ଯୁଷ୍ମାନ୍ ଅନାଥାନ୍ କୃତ୍ୱା ନ ଯାସ୍ୟାମି ପୁନରପି ଯୁଷ୍ମାକଂ ସମୀପମ୍ ଆଗମିଷ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","କିଯତ୍କାଲରତ୍ ପରମ୍ ଅସ୍ୟ ଜଗତୋ ଲୋକା ମାଂ ପୁନ ର୍ନ ଦ୍ରକ୍ଷ୍ୟନ୍ତି କିନ୍ତୁ ଯୂଯଂ ଦ୍ରକ୍ଷ୍ୟଥ;ଅହଂ ଜୀୱିଷ୍ୟାମି ତସ୍ମାତ୍ କାରଣାଦ୍ ଯୂଯମପି ଜୀୱିଷ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","ପିତର୍ୟ୍ୟହମସ୍ମି ମଯି ଚ ଯୂଯଂ ସ୍ଥ, ତଥାହଂ ଯୁଷ୍ମାସ୍ୱସ୍ମି ତଦପି ତଦା ଜ୍ଞାସ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","ଯୋ ଜନୋ ମମାଜ୍ଞା ଗୃହୀତ୍ୱା ତା ଆଚରତି ସଏୱ ମଯି ପ୍ରୀଯତେ; ଯୋ ଜନଶ୍ଚ ମଯି ପ୍ରୀଯତେ ସଏୱ ମମ ପିତୁଃ ପ୍ରିଯପାତ୍ରଂ ଭୱିଷ୍ୟତି, ତଥାହମପି ତସ୍ମିନ୍ ପ୍ରୀତ୍ୱା ତସ୍ମୈ ସ୍ୱଂ ପ୍ରକାଶଯିଷ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","ତଦା ଈଷ୍କରିଯୋତୀଯାଦ୍ ଅନ୍ୟୋ ଯିହୂଦାସ୍ତମୱଦତ୍, ହେ ପ୍ରଭୋ ଭୱାନ୍ ଜଗତୋ ଲୋକାନାଂ ସନ୍ନିଧୌ ପ୍ରକାଶିତୋ ନ ଭୂତ୍ୱାସ୍ମାକଂ ସନ୍ନିଧୌ କୁତଃ ପ୍ରକାଶିତୋ ଭୱିଷ୍ୟତି? ");
INSERT INTO sanori_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ତତୋ ଯୀଶୁଃ ପ୍ରତ୍ୟୁଦିତୱାନ୍, ଯୋ ଜନୋ ମଯି ପ୍ରୀଯତେ ସ ମମାଜ୍ଞା ଅପି ଗୃହ୍ଲାତି, ତେନ ମମ ପିତାପି ତସ୍ମିନ୍ ପ୍ରେଷ୍ୟତେ, ଆୱାଞ୍ଚ ତନ୍ନିକଟମାଗତ୍ୟ ତେନ ସହ ନିୱତ୍ସ୍ୟାୱଃ| ");
INSERT INTO sanori_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ଯୋ ଜନୋ ମଯି ନ ପ୍ରୀଯତେ ସ ମମ କଥା ଅପି ନ ଗୃହ୍ଲାତି ପୁନଶ୍ଚ ଯାମିମାଂ କଥାଂ ଯୂଯଂ ଶୃଣୁଥ ସା କଥା କେୱଲସ୍ୟ ମମ ନ କିନ୍ତୁ ମମ ପ୍ରେରକୋ ଯଃ ପିତା ତସ୍ୟାପି କଥା| ");
INSERT INTO sanori_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","ଇଦାନୀଂ ଯୁଷ୍ମାକଂ ନିକଟେ ୱିଦ୍ୟମାନୋହମ୍ ଏତାଃ ସକଲାଃ କଥାଃ କଥଯାମି| ");
INSERT INTO sanori_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","କିନ୍ତ୍ୱିତଃ ପରଂ ପିତ୍ରା ଯଃ ସହାଯୋଽର୍ଥାତ୍ ପୱିତ୍ର ଆତ୍ମା ମମ ନାମ୍ନି ପ୍ରେରଯିଷ୍ୟତି ସ ସର୍ୱ୍ୱଂ ଶିକ୍ଷଯିତ୍ୱା ମଯୋକ୍ତାଃ ସମସ୍ତାଃ କଥା ଯୁଷ୍ମାନ୍ ସ୍ମାରଯିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","ଅହଂ ଯୁଷ୍ମାକଂ ନିକଟେ ଶାନ୍ତିଂ ସ୍ଥାପଯିତ୍ୱା ଯାମି, ନିଜାଂ ଶାନ୍ତିଂ ଯୁଷ୍ମଭ୍ୟଂ ଦଦାମି, ଜଗତୋ ଲୋକା ଯଥା ଦଦାତି ତଥାହଂ ନ ଦଦାମି; ଯୁଷ୍ମାକମ୍ ଅନ୍ତଃକରଣାନି ଦୁଃଖିତାନି ଭୀତାନି ଚ ନ ଭୱନ୍ତୁ| ");
INSERT INTO sanori_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","ଅହଂ ଗତ୍ୱା ପୁନରପି ଯୁଷ୍ମାକଂ ସମୀପମ୍ ଆଗମିଷ୍ୟାମି ମଯୋକ୍ତଂ ୱାକ୍ୟମିଦଂ ଯୂଯମ୍ ଅଶ୍ରୌଷ୍ଟ; ଯଦି ମଯ୍ୟପ୍ରେଷ୍ୟଧ୍ୱଂ ତର୍ହ୍ୟହଂ ପିତୁଃ ସମୀପଂ ଗଚ୍ଛାମି ମମାସ୍ୟାଂ କଥାଯାଂ ଯୂଯମ୍ ଅହ୍ଲାଦିଷ୍ୟଧ୍ୱଂ ଯତୋ ମମ ପିତା ମତ୍ତୋପି ମହାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","ତସ୍ୟା ଘଟନାଯାଃ ସମଯେ ଯଥା ଯୁଷ୍ମାକଂ ଶ୍ରଦ୍ଧା ଜାଯତେ ତଦର୍ଥମ୍ ଅହଂ ତସ୍ୟା ଘଟନାଯାଃ ପୂର୍ୱ୍ୱମ୍ ଇଦାନୀଂ ଯୁଷ୍ମାନ୍ ଏତାଂ ୱାର୍ତ୍ତାଂ ୱଦାମି| ");
INSERT INTO sanori_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ଇତଃ ପରଂ ଯୁଷ୍ମାଭିଃ ସହ ମମ ବହୱ ଆଲାପା ନ ଭୱିଷ୍ୟନ୍ତି ଯତଃ କାରଣାଦ୍ ଏତସ୍ୟ ଜଗତଃ ପତିରାଗଚ୍ଛତି କିନ୍ତୁ ମଯା ସହ ତସ୍ୟ କୋପି ସମ୍ବନ୍ଧୋ ନାସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ଅହଂ ପିତରି ପ୍ରେମ କରୋମି ତଥା ପିତୁ ର୍ୱିଧିୱତ୍ କର୍ମ୍ମାଣି କରୋମୀତି ଯେନ ଜଗତୋ ଲୋକା ଜାନନ୍ତି ତଦର୍ଥମ୍ ଉତ୍ତିଷ୍ଠତ ୱଯଂ ସ୍ଥାନାଦସ୍ମାଦ୍ ଗଚ୍ଛାମ| ");
INSERT INTO sanori_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","ଅହଂ ସତ୍ୟଦ୍ରାକ୍ଷାଲତାସ୍ୱରୂପୋ ମମ ପିତା ତୂଦ୍ୟାନପରିଚାରକସ୍ୱରୂପଞ୍ଚ| ");
INSERT INTO sanori_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","ମମ ଯାସୁ ଶାଖାସୁ ଫଲାନି ନ ଭୱନ୍ତି ତାଃ ସ ଛିନତ୍ତି ତଥା ଫଲୱତ୍ୟଃ ଶାଖା ଯଥାଧିକଫଲାନି ଫଲନ୍ତି ତଦର୍ଥଂ ତାଃ ପରିଷ୍କରୋତି| ");
INSERT INTO sanori_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ଇଦାନୀଂ ମଯୋକ୍ତୋପଦେଶେନ ଯୂଯଂ ପରିଷ୍କୃତାଃ| ");
INSERT INTO sanori_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ଅତଃ କାରଣାତ୍ ମଯି ତିଷ୍ଠତ ତେନାହମପି ଯୁଷ୍ମାସୁ ତିଷ୍ଠାମି, ଯତୋ ହେତୋ ର୍ଦ୍ରାକ୍ଷାଲତାଯାମ୍ ଅସଂଲଗ୍ନା ଶାଖା ଯଥା ଫଲୱତୀ ଭୱିତୁଂ ନ ଶକ୍ନୋତି ତଥା ଯୂଯମପି ମଯ୍ୟତିଷ୍ଠନ୍ତଃ ଫଲୱନ୍ତୋ ଭୱିତୁଂ ନ ଶକ୍ନୁଥ| ");
INSERT INTO sanori_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","ଅହଂ ଦ୍ରାକ୍ଷାଲତାସ୍ୱରୂପୋ ଯୂଯଞ୍ଚ ଶାଖାସ୍ୱରୂପୋଃ; ଯୋ ଜନୋ ମଯି ତିଷ୍ଠତି ଯତ୍ର ଚାହଂ ତିଷ୍ଠାମି, ସ ପ୍ରଚୂରଫଲୈଃ ଫଲୱାନ୍ ଭୱତି, କିନ୍ତୁ ମାଂ ୱିନା ଯୂଯଂ କିମପି କର୍ତ୍ତୁଂ ନ ଶକ୍ନୁଥ| ");
INSERT INTO sanori_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ଯଃ କଶ୍ଚିନ୍ ମଯି ନ ତିଷ୍ଠତି ସ ଶୁଷ୍କଶାଖେୱ ବହି ର୍ନିକ୍ଷିପ୍ୟତେ ଲୋକାଶ୍ଚ ତା ଆହୃତ୍ୟ ୱହ୍ନୌ ନିକ୍ଷିପ୍ୟ ଦାହଯନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","ଯଦି ଯୂଯଂ ମଯି ତିଷ୍ଠଥ ମମ କଥା ଚ ଯୁଷ୍ମାସୁ ତିଷ୍ଠତି ତର୍ହି ଯଦ୍ ୱାଞ୍ଛିତ୍ୱା ଯାଚିଷ୍ୟଧ୍ୱେ ଯୁଷ୍ମାକଂ ତଦେୱ ସଫଲଂ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","ଯଦି ଯୂଯଂ ପ୍ରଚୂରଫଲୱନ୍ତୋ ଭୱଥ ତର୍ହି ତଦ୍ୱାରା ମମ ପିତୁ ର୍ମହିମା ପ୍ରକାଶିଷ୍ୟତେ ତଥା ଯୂଯଂ ମମ ଶିଷ୍ୟା ଇତି ପରିକ୍ଷାଯିଷ୍ୟଧ୍ୱେ| ");
INSERT INTO sanori_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","ପିତା ଯଥା ମଯି ପ୍ରୀତୱାନ୍ ଅହମପି ଯୁଷ୍ମାସୁ ତଥା ପ୍ରୀତୱାନ୍ ଅତୋ ହେତୋ ର୍ୟୂଯଂ ନିରନ୍ତରଂ ମମ ପ୍ରେମପାତ୍ରାଣି ଭୂତ୍ୱା ତିଷ୍ଠତ| ");
INSERT INTO sanori_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ଅହଂ ଯଥା ପିତୁରାଜ୍ଞା ଗୃହୀତ୍ୱା ତସ୍ୟ ପ୍ରେମଭାଜନଂ ତିଷ୍ଠାମି ତଥୈୱ ଯୂଯମପି ଯଦି ମମାଜ୍ଞା ଗୁହ୍ଲୀଥ ତର୍ହି ମମ ପ୍ରେମଭାଜନାନି ସ୍ଥାସ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","ଯୁଷ୍ମନ୍ନିମିତ୍ତଂ ମମ ଯ ଆହ୍ଲାଦଃ ସ ଯଥା ଚିରଂ ତିଷ୍ଠତି ଯୁଷ୍ମାକମ୍ ଆନନ୍ଦଶ୍ଚ ଯଥା ପୂର୍ୟ୍ୟତେ ତଦର୍ଥଂ ଯୁଷ୍ମଭ୍ୟମ୍ ଏତାଃ କଥା ଅତ୍ରକଥମ୍| ");
INSERT INTO sanori_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","ଅହଂ ଯୁଷ୍ମାସୁ ଯଥା ପ୍ରୀଯେ ଯୂଯମପି ପରସ୍ପରଂ ତଥା ପ୍ରୀଯଧ୍ୱମ୍ ଏଷା ମମାଜ୍ଞା| ");
INSERT INTO sanori_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","ମିତ୍ରାଣାଂ କାରଣାତ୍ ସ୍ୱପ୍ରାଣଦାନପର୍ୟ୍ୟନ୍ତଂ ଯତ୍ ପ୍ରେମ ତସ୍ମାନ୍ ମହାପ୍ରେମ କସ୍ୟାପି ନାସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","ଅହଂ ଯଦ୍ୟଦ୍ ଆଦିଶାମି ତତ୍ତଦେୱ ଯଦି ଯୂଯମ୍ ଆଚରତ ତର୍ହି ଯୂଯମେୱ ମମ ମିତ୍ରାଣି| ");
INSERT INTO sanori_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","ଅଦ୍ୟାରଭ୍ୟ ଯୁଷ୍ମାନ୍ ଦାସାନ୍ ନ ୱଦିଷ୍ୟାମି ଯତ୍ ପ୍ରଭୁ ର୍ୟତ୍ କରୋତି ଦାସସ୍ତଦ୍ ନ ଜାନାତି; କିନ୍ତୁ ପିତୁଃ ସମୀପେ ଯଦ୍ୟଦ୍ ଅଶୃଣୱଂ ତତ୍ ସର୍ୱ୍ୱଂ ଯୂଷ୍ମାନ୍ ଅଜ୍ଞାପଯମ୍ ତତ୍କାରଣାଦ୍ ଯୁଷ୍ମାନ୍ ମିତ୍ରାଣି ପ୍ରୋକ୍ତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","ଯୂଯଂ ମାଂ ରୋଚିତୱନ୍ତ ଇତି ନ, କିନ୍ତ୍ୱହମେୱ ଯୁଷ୍ମାନ୍ ରୋଚିତୱାନ୍ ଯୂଯଂ ଗତ୍ୱା ଯଥା ଫଲାନ୍ୟୁତ୍ପାଦଯଥ ତାନି ଫଲାନି ଚାକ୍ଷଯାଣି ଭୱନ୍ତି, ତଦର୍ଥଂ ଯୁଷ୍ମାନ୍ ନ୍ୟଜୁନଜଂ ତସ୍ମାନ୍ ମମ ନାମ ପ୍ରୋଚ୍ୟ ପିତରଂ ଯତ୍ କିଞ୍ଚିଦ୍ ଯାଚିଷ୍ୟଧ୍ୱେ ତଦେୱ ସ ଯୁଷ୍ମଭ୍ୟଂ ଦାସ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","ଯୂଯଂ ପରସ୍ପରଂ ପ୍ରୀଯଧ୍ୱମ୍ ଅହମ୍ ଇତ୍ୟାଜ୍ଞାପଯାମି| ");
INSERT INTO sanori_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","ଜଗତୋ ଲୋକୈ ର୍ୟୁଷ୍ମାସୁ ଋତୀଯିତେଷୁ ତେ ପୂର୍ୱ୍ୱଂ ମାମେୱାର୍ତ୍ତୀଯନ୍ତ ଇତି ଯୂଯଂ ଜାନୀଥ| ");
INSERT INTO sanori_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","ଯଦି ଯୂଯଂ ଜଗତୋ ଲୋକା ଅଭୱିଷ୍ୟତ ତର୍ହି ଜଗତୋ ଲୋକା ଯୁଷ୍ମାନ୍ ଆତ୍ମୀଯାନ୍ ବୁଦ୍ଧ୍ୱାପ୍ରେଷ୍ୟନ୍ତ; କିନ୍ତୁ ଯୂଯଂ ଜଗତୋ ଲୋକା ନ ଭୱଥ, ଅହଂ ଯୁଷ୍ମାନ୍ ଅସ୍ମାଜ୍ଜଗତୋଽରୋଚଯମ୍ ଏତସ୍ମାତ୍ କାରଣାଜ୍ଜଗତୋ ଲୋକା ଯୁଷ୍ମାନ୍ ଋତୀଯନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","ଦାସଃ ପ୍ରଭୋ ର୍ମହାନ୍ ନ ଭୱତି ମମୈତତ୍ ପୂର୍ୱ୍ୱୀଯଂ ୱାକ୍ୟଂ ସ୍ମରତ; ତେ ଯଦି ମାମେୱାତାଡଯନ୍ ତର୍ହି ଯୁଷ୍ମାନପି ତାଡଯିଷ୍ୟନ୍ତି, ଯଦି ମମ ୱାକ୍ୟଂ ଗୃହ୍ଲନ୍ତି ତର୍ହି ଯୁଷ୍ମାକମପି ୱାକ୍ୟଂ ଗ୍ରହୀଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","କିନ୍ତୁ ତେ ମମ ନାମକାରଣାଦ୍ ଯୁଷ୍ମାନ୍ ପ୍ରତି ତାଦୃଶଂ ୱ୍ୟୱହରିଷ୍ୟନ୍ତି ଯତୋ ଯୋ ମାଂ ପ୍ରେରିତୱାନ୍ ତଂ ତେ ନ ଜାନନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","ତେଷାଂ ସନ୍ନିଧିମ୍ ଆଗତ୍ୟ ଯଦ୍ୟହଂ ନାକଥଯିଷ୍ୟଂ ତର୍ହି ତେଷାଂ ପାପଂ ନାଭୱିଷ୍ୟତ୍ କିନ୍ତ୍ୱଧୁନା ତେଷାଂ ପାପମାଚ୍ଛାଦଯିତୁମ୍ ଉପାଯୋ ନାସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","ଯୋ ଜନୋ ମାମ୍ ଋତୀଯତେ ସ ମମ ପିତରମପି ଋତୀଯତେ| ");
INSERT INTO sanori_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","ଯାଦୃଶାନି କର୍ମ୍ମାଣି କେନାପି କଦାପି ନାକ୍ରିଯନ୍ତ ତାଦୃଶାନି କର୍ମ୍ମାଣି ଯଦି ତେଷାଂ ସାକ୍ଷାଦ୍ ଅହଂ ନାକରିଷ୍ୟଂ ତର୍ହି ତେଷାଂ ପାପଂ ନାଭୱିଷ୍ୟତ୍ କିନ୍ତ୍ୱଧୁନା ତେ ଦୃଷ୍ଟ୍ୱାପି ମାଂ ମମ ପିତରଞ୍ଚାର୍ତ୍ତୀଯନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","ତସ୍ମାତ୍ ତେଽକାରଣଂ ମାମ୍ ଋତୀଯନ୍ତେ ଯଦେତଦ୍ ୱଚନଂ ତେଷାଂ ଶାସ୍ତ୍ରେ ଲିଖିତମାସ୍ତେ ତତ୍ ସଫଲମ୍ ଅଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","କିନ୍ତୁ ପିତୁ ର୍ନିର୍ଗତଂ ଯଂ ସହାଯମର୍ଥାତ୍ ସତ୍ୟମଯମ୍ ଆତ୍ମାନଂ ପିତୁଃ ସମୀପାଦ୍ ଯୁଷ୍ମାକଂ ସମୀପେ ପ୍ରେଷଯିଷ୍ୟାମି ସ ଆଗତ୍ୟ ମଯି ପ୍ରମାଣଂ ଦାସ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ଯୂଯଂ ପ୍ରଥମମାରଭ୍ୟ ମଯା ସାର୍ଦ୍ଧଂ ତିଷ୍ଠଥ ତସ୍ମାଦ୍ଧେତୋ ର୍ୟୂଯମପି ପ୍ରମାଣଂ ଦାସ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","ଯୁଷ୍ମାକଂ ଯଥା ୱାଧା ନ ଜାଯତେ ତଦର୍ଥଂ ଯୁଷ୍ମାନ୍ ଏତାନି ସର୍ୱ୍ୱୱାକ୍ୟାନି ୱ୍ୟାହରଂ| ");
INSERT INTO sanori_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ଲୋକା ଯୁଷ୍ମାନ୍ ଭଜନଗୃହେଭ୍ୟୋ ଦୂରୀକରିଷ୍ୟନ୍ତି ତଥା ଯସ୍ମିନ୍ ସମଯେ ଯୁଷ୍ମାନ୍ ହତ୍ୱା ଈଶ୍ୱରସ୍ୟ ତୁଷ୍ଟି ଜନକଂ କର୍ମ୍ମାକୁର୍ମ୍ମ ଇତି ମଂସ୍ୟନ୍ତେ ସ ସମଯ ଆଗଚ୍ଛନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","ତେ ପିତରଂ ମାଞ୍ଚ ନ ଜାନନ୍ତି, ତସ୍ମାଦ୍ ଯୁଷ୍ମାନ୍ ପ୍ରତୀଦୃଶମ୍ ଆଚରିଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","ଅତୋ ହେତାଃ ସମଯେ ସମୁପସ୍ଥିତେ ଯଥା ମମ କଥା ଯୁଷ୍ମାକଂ ମନଃସୁଃ ସମୁପତିଷ୍ଠତି ତଦର୍ଥଂ ଯୁଷ୍ମାଭ୍ୟମ୍ ଏତାଂ କଥାଂ କଥଯାମି ଯୁଷ୍ମାଭିଃ ସାର୍ଦ୍ଧମ୍ ଅହଂ ତିଷ୍ଠନ୍ ପ୍ରଥମଂ ତାଂ ଯୁଷ୍ମଭ୍ୟଂ ନାକଥଯଂ| ");
INSERT INTO sanori_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","ସାମ୍ପ୍ରତଂ ସ୍ୱସ୍ୟ ପ୍ରେରଯିତୁଃ ସମୀପଂ ଗଚ୍ଛାମି ତଥାପି ତ୍ୱଂ କ୍କ ଗଚ୍ଛସି କଥାମେତାଂ ଯୁଷ୍ମାକଂ କୋପି ମାଂ ନ ପୃଚ୍ଛତି| ");
INSERT INTO sanori_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","କିନ୍ତୁ ମଯୋକ୍ତାଭିରାଭିଃ କଥାଭି ର୍ୟୂଷ୍ମାକମ୍ ଅନ୍ତଃକରଣାନି ଦୁଃଖେନ ପୂର୍ଣାନ୍ୟଭୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","ତଥାପ୍ୟହଂ ଯଥାର୍ଥଂ କଥଯାମି ମମ ଗମନଂ ଯୁଷ୍ମାକଂ ହିତାର୍ଥମେୱ, ଯତୋ ହେତୋ ର୍ଗମନେ ନ କୃତେ ସହାଯୋ ଯୁଷ୍ମାକଂ ସମୀପଂ ନାଗମିଷ୍ୟତି କିନ୍ତୁ ଯଦି ଗଚ୍ଛାମି ତର୍ହି ଯୁଷ୍ମାକଂ ସମୀପେ ତଂ ପ୍ରେଷଯିଷ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","ତତଃ ସ ଆଗତ୍ୟ ପାପପୁଣ୍ୟଦଣ୍ଡେଷୁ ଜଗତୋ ଲୋକାନାଂ ପ୍ରବୋଧଂ ଜନଯିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ତେ ମଯି ନ ୱିଶ୍ୱସନ୍ତି ତସ୍ମାଦ୍ଧେତୋଃ ପାପପ୍ରବୋଧଂ ଜନଯିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ଯୁଷ୍ମାକମ୍ ଅଦୃଶ୍ୟଃ ସନ୍ନହଂ ପିତୁଃ ସମୀପଂ ଗଚ୍ଛାମି ତସ୍ମାଦ୍ ପୁଣ୍ୟେ ପ୍ରବୋଧଂ ଜନଯିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ଏତଜ୍ଜଗତୋଽଧିପତି ର୍ଦଣ୍ଡାଜ୍ଞାଂ ପ୍ରାପ୍ନୋତି ତସ୍ମାଦ୍ ଦଣ୍ଡେ ପ୍ରବୋଧଂ ଜନଯିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","ଯୁଷ୍ମଭ୍ୟଂ କଥଯିତୁଂ ମମାନେକାଃ କଥା ଆସତେ, ତାଃ କଥା ଇଦାନୀଂ ଯୂଯଂ ସୋଢୁଂ ନ ଶକ୍ନୁଥ; ");
INSERT INTO sanori_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","କିନ୍ତୁ ସତ୍ୟମଯ ଆତ୍ମା ଯଦା ସମାଗମିଷ୍ୟତି ତଦା ସର୍ୱ୍ୱଂ ସତ୍ୟଂ ଯୁଷ୍ମାନ୍ ନେଷ୍ୟତି, ସ ସ୍ୱତଃ କିମପି ନ ୱଦିଷ୍ୟତି କିନ୍ତୁ ଯଚ୍ଛ୍ରୋଷ୍ୟତି ତଦେୱ କଥଯିତ୍ୱା ଭାୱିକାର୍ୟ୍ୟଂ ଯୁଷ୍ମାନ୍ ଜ୍ଞାପଯିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","ମମ ମହିମାନଂ ପ୍ରକାଶଯିଷ୍ୟତି ଯତୋ ମଦୀଯାଂ କଥାଂ ଗୃହୀତ୍ୱା ଯୁଷ୍ମାନ୍ ବୋଧଯିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","ପିତୁ ର୍ୟଦ୍ୟଦ୍ ଆସ୍ତେ ତତ୍ ସର୍ୱ୍ୱଂ ମମ ତସ୍ମାଦ୍ କାରଣାଦ୍ ଅୱାଦିଷଂ ସ ମଦୀଯାଂ କଥାଂ ଗୃହୀତ୍ୱା ଯୁଷ୍ମାନ୍ ବୋଧଯିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","କିଯତ୍କାଲାତ୍ ପରଂ ଯୂଯଂ ମାଂ ଦ୍ରଷ୍ଟୁଂ ନ ଲପ୍ସ୍ୟଧ୍ୱେ କିନ୍ତୁ କିଯତ୍କାଲାତ୍ ପରଂ ପୁନ ର୍ଦ୍ରଷ୍ଟୁଂ ଲପ୍ସ୍ୟଧ୍ୱେ ଯତୋହଂ ପିତୁଃ ସମୀପଂ ଗଚ୍ଛାମି| ");
INSERT INTO sanori_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ତତଃ ଶିଷ୍ୟାଣାଂ କିଯନ୍ତୋ ଜନାଃ ପରସ୍ପରଂ ୱଦିତୁମ୍ ଆରଭନ୍ତ, କିଯତ୍କାଲାତ୍ ପରଂ ମାଂ ଦ୍ରଷ୍ଟୁଂ ନ ଲପ୍ସ୍ୟଧ୍ୱେ କିନ୍ତୁ କିଯତ୍କାଲାତ୍ ପରଂ ପୁନ ର୍ଦ୍ରଷ୍ଟୁଂ ଲପ୍ସ୍ୟଧ୍ୱେ ଯତୋହଂ ପିତୁଃ ସମୀପଂ ଗଚ୍ଛାମି, ଇତି ଯଦ୍ ୱାକ୍ୟମ୍ ଅଯଂ ୱଦତି ତତ୍ କିଂ? ");
INSERT INTO sanori_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","ତତଃ କିଯତ୍କାଲାତ୍ ପରମ୍ ଇତି ତସ୍ୟ ୱାକ୍ୟଂ କିଂ? ତସ୍ୟ ୱାକ୍ୟସ୍ୟାଭିପ୍ରାଯଂ ୱଯଂ ବୋଦ୍ଧୁଂ ନ ଶକ୍ନୁମସ୍ତୈରିତି ");
INSERT INTO sanori_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","ନିଗଦିତେ ଯୀଶୁସ୍ତେଷାଂ ପ୍ରଶ୍ନେଚ୍ଛାଂ ଜ୍ଞାତ୍ୱା ତେଭ୍ୟୋଽକଥଯତ୍ କିଯତ୍କାଲାତ୍ ପରଂ ମାଂ ଦ୍ରଷ୍ଟୁଂ ନ ଲପ୍ସ୍ୟଧ୍ୱେ, କିନ୍ତୁ କିଯତ୍କାଲାତ୍ ପରଂ ପୂନ ର୍ଦ୍ରଷ୍ଟୁଂ ଲପ୍ସ୍ୟଧ୍ୱେ, ଯାମିମାଂ କଥାମକଥଯଂ ତସ୍ୟା ଅଭିପ୍ରାଯଂ କିଂ ଯୂଯଂ ପରସ୍ପରଂ ମୃଗଯଧ୍ୱେ? ");
INSERT INTO sanori_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","ଯୁଷ୍ମାନହମ୍ ଅତିଯଥାର୍ଥଂ ୱଦାମି ଯୂଯଂ କ୍ରନ୍ଦିଷ୍ୟଥ ୱିଲପିଷ୍ୟଥ ଚ, କିନ୍ତୁ ଜଗତୋ ଲୋକା ଆନନ୍ଦିଷ୍ୟନ୍ତି; ଯୂଯଂ ଶୋକାକୁଲା ଭୱିଷ୍ୟଥ କିନ୍ତୁ ଶୋକାତ୍ ପରଂ ଆନନ୍ଦଯୁକ୍ତା ଭୱିଷ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","ପ୍ରସୱକାଲ ଉପସ୍ଥିତେ ନାରୀ ଯଥା ପ୍ରସୱୱେଦନଯା ୱ୍ୟାକୁଲା ଭୱତି କିନ୍ତୁ ପୁତ୍ରେ ଭୂମିଷ୍ଠେ ସତି ମନୁଷ୍ୟୈକୋ ଜନ୍ମନା ନରଲୋକେ ପ୍ରୱିଷ୍ଟ ଇତ୍ୟାନନ୍ଦାତ୍ ତସ୍ୟାସ୍ତତ୍ସର୍ୱ୍ୱଂ ଦୁଃଖଂ ମନସି ନ ତିଷ୍ଠତି, ");
INSERT INTO sanori_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","ତଥା ଯୂଯମପି ସାମ୍ପ୍ରତଂ ଶୋକାକୁଲା ଭୱଥ କିନ୍ତୁ ପୁନରପି ଯୁଷ୍ମଭ୍ୟଂ ଦର୍ଶନଂ ଦାସ୍ୟାମି ତେନ ଯୁଷ୍ମାକମ୍ ଅନ୍ତଃକରଣାନି ସାନନ୍ଦାନି ଭୱିଷ୍ୟନ୍ତି, ଯୁଷ୍ମାକଂ ତମ୍ ଆନନ୍ଦଞ୍ଚ କୋପି ହର୍ତ୍ତୁଂ ନ ଶକ୍ଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","ତସ୍ମିନ୍ ଦିୱସେ କାମପି କଥାଂ ମାଂ ନ ପ୍ରକ୍ଷ୍ୟଥ| ଯୁଷ୍ମାନହମ୍ ଅତିଯଥାର୍ଥଂ ୱଦାମି, ମମ ନାମ୍ନା ଯତ୍ କିଞ୍ଚିଦ୍ ପିତରଂ ଯାଚିଷ୍ୟଧ୍ୱେ ତଦେୱ ସ ଦାସ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","ପୂର୍ୱ୍ୱେ ମମ ନାମ୍ନା କିମପି ନାଯାଚଧ୍ୱଂ, ଯାଚଧ୍ୱଂ ତତଃ ପ୍ରାପ୍ସ୍ୟଥ ତସ୍ମାଦ୍ ଯୁଷ୍ମାକଂ ସମ୍ପୂର୍ଣାନନ୍ଦୋ ଜନିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","ଉପମାକଥାଭିଃ ସର୍ୱ୍ୱାଣ୍ୟେତାନି ଯୁଷ୍ମାନ୍ ଜ୍ଞାପିତୱାନ୍ କିନ୍ତୁ ଯସ୍ମିନ୍ ସମଯେ ଉପମଯା ନୋକ୍ତ୍ୱା ପିତୁଃ କଥାଂ ସ୍ପଷ୍ଟଂ ଜ୍ଞାପଯିଷ୍ୟାମି ସମଯ ଏତାଦୃଶ ଆଗଚ୍ଛତି| ");
INSERT INTO sanori_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ତଦା ମମ ନାମ୍ନା ପ୍ରାର୍ଥଯିଷ୍ୟଧ୍ୱେ ଽହଂ ଯୁଷ୍ମନ୍ନିମିତ୍ତଂ ପିତରଂ ୱିନେଷ୍ୟେ କଥାମିମାଂ ନ ୱଦାମି; ");
INSERT INTO sanori_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ଯତୋ ଯୂଯଂ ମଯି ପ୍ରେମ କୁରୁଥ, ତଥାହମ୍ ଈଶ୍ୱରସ୍ୟ ସମୀପାଦ୍ ଆଗତୱାନ୍ ଇତ୍ୟପି ପ୍ରତୀଥ, ତସ୍ମାଦ୍ କାରଣାତ୍ କାରଣାତ୍ ପିତା ସ୍ୱଯଂ ଯୁଷ୍ମାସୁ ପ୍ରୀଯତେ| ");
INSERT INTO sanori_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","ପିତୁଃ ସମୀପାଜ୍ଜଜଦ୍ ଆଗତୋସ୍ମି ଜଗତ୍ ପରିତ୍ୟଜ୍ୟ ଚ ପୁନରପି ପିତୁଃ ସମୀପଂ ଗଚ୍ଛାମି| ");
INSERT INTO sanori_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ତଦା ଶିଷ୍ୟା ଅୱଦନ୍, ହେ ପ୍ରଭୋ ଭୱାନ୍ ଉପମଯା ନୋକ୍ତ୍ୱାଧୁନା ସ୍ପଷ୍ଟଂ ୱଦତି| ");
INSERT INTO sanori_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ଭୱାନ୍ ସର୍ୱ୍ୱଜ୍ଞଃ କେନଚିତ୍ ପୃଷ୍ଟୋ ଭୱିତୁମପି ଭୱତଃ ପ୍ରଯୋଜନଂ ନାସ୍ତୀତ୍ୟଧୁନାସ୍ମାକଂ ସ୍ଥିରଜ୍ଞାନଂ ଜାତଂ ତସ୍ମାଦ୍ ଭୱାନ୍ ଈଶ୍ୱରସ୍ୟ ସମୀପାଦ୍ ଆଗତୱାନ୍ ଇତ୍ୟତ୍ର ୱଯଂ ୱିଶ୍ୱସିମଃ| ");
INSERT INTO sanori_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ତତୋ ଯୀଶୁଃ ପ୍ରତ୍ୟୱାଦୀଦ୍ ଇଦାନୀଂ କିଂ ଯୂଯଂ ୱିଶ୍ୱସିଥ? ");
INSERT INTO sanori_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ପଶ୍ୟତ ସର୍ୱ୍ୱେ ଯୂଯଂ ୱିକୀର୍ଣାଃ ସନ୍ତୋ ମାମ୍ ଏକାକିନଂ ପୀରତ୍ୟଜ୍ୟ ସ୍ୱଂ ସ୍ୱଂ ସ୍ଥାନଂ ଗମିଷ୍ୟଥ, ଏତାଦୃଶଃ ସମଯ ଆଗଚ୍ଛତି ୱରଂ ପ୍ରାଯେଣୋପସ୍ଥିତୱାନ୍; ତଥାପ୍ୟହଂ ନୈକାକୀ ଭୱାମି ଯତଃ ପିତା ମଯା ସାର୍ଦ୍ଧମ୍ ଆସ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","ଯଥା ମଯା ଯୁଷ୍ମାକଂ ଶାନ୍ତି ର୍ଜାଯତେ ତଦର୍ଥମ୍ ଏତାଃ କଥା ଯୁଷ୍ମଭ୍ୟମ୍ ଅଚକଥଂ; ଅସ୍ମିନ୍ ଜଗତି ଯୁଷ୍ମାକଂ କ୍ଲେଶୋ ଘଟିଷ୍ୟତେ କିନ୍ତ୍ୱକ୍ଷୋଭା ଭୱତ ଯତୋ ମଯା ଜଗଜ୍ଜିତଂ| ");
INSERT INTO sanori_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","ତତଃ ପରଂ ଯୀଶୁରେତାଃ କଥାଃ କଥଯିତ୍ୱା ସ୍ୱର୍ଗଂ ୱିଲୋକ୍ୟୈତତ୍ ପ୍ରାର୍ଥଯତ୍, ହେ ପିତଃ ସମଯ ଉପସ୍ଥିତୱାନ୍; ଯଥା ତୱ ପୁତ୍ରସ୍ତୱ ମହିମାନଂ ପ୍ରକାଶଯତି ତଦର୍ଥଂ ତ୍ୱଂ ନିଜପୁତ୍ରସ୍ୟ ମହିମାନଂ ପ୍ରକାଶଯ| ");
INSERT INTO sanori_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ତ୍ୱଂ ଯୋଲ୍ଲୋକାନ୍ ତସ୍ୟ ହସ୍ତେ ସମର୍ପିତୱାନ୍ ସ ଯଥା ତେଭ୍ୟୋଽନନ୍ତାଯୁ ର୍ଦଦାତି ତଦର୍ଥଂ ତ୍ୱଂ ପ୍ରାଣିମାତ୍ରାଣାମ୍ ଅଧିପତିତ୍ୱଭାରଂ ତସ୍ମୈ ଦତ୍ତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","ଯସ୍ତ୍ୱମ୍ ଅଦ୍ୱିତୀଯଃ ସତ୍ୟ ଈଶ୍ୱରସ୍ତ୍ୱଯା ପ୍ରେରିତଶ୍ଚ ଯୀଶୁଃ ଖ୍ରୀଷ୍ଟ ଏତଯୋରୁଭଯୋଃ ପରିଚଯେ ପ୍ରାପ୍ତେଽନନ୍ତାଯୁ ର୍ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ତ୍ୱଂ ଯସ୍ୟ କର୍ମ୍ମଣୋ ଭାରଂ ମହ୍ୟଂ ଦତ୍ତୱାନ୍, ତତ୍ ସମ୍ପନ୍ନଂ କୃତ୍ୱା ଜଗତ୍ୟସ୍ମିନ୍ ତୱ ମହିମାନଂ ପ୍ରାକାଶଯଂ| ");
INSERT INTO sanori_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ଅତଏୱ ହେ ପିତ ର୍ଜଗତ୍ୟୱିଦ୍ୟମାନେ ତ୍ୱଯା ସହ ତିଷ୍ଠତୋ ମମ ଯୋ ମହିମାସୀତ୍ ସମ୍ପ୍ରତି ତୱ ସମୀପେ ମାଂ ତଂ ମହିମାନଂ ପ୍ରାପଯ| ");
INSERT INTO sanori_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","ଅନ୍ୟଚ୍ଚ ତ୍ୱମ୍ ଏତଜ୍ଜଗତୋ ଯାଲ୍ଲୋକାନ୍ ମହ୍ୟମ୍ ଅଦଦା ଅହଂ ତେଭ୍ୟସ୍ତୱ ନାମ୍ନସ୍ତତ୍ତ୍ୱଜ୍ଞାନମ୍ ଅଦଦାଂ, ତେ ତୱୈୱାସନ୍, ତ୍ୱଂ ତାନ୍ ମହ୍ୟମଦଦାଃ, ତସ୍ମାତ୍ତେ ତୱୋପଦେଶମ୍ ଅଗୃହ୍ଲନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ତ୍ୱଂ ମହ୍ୟଂ ଯତ୍ କିଞ୍ଚିଦ୍ ଅଦଦାସ୍ତତ୍ସର୍ୱ୍ୱଂ ତ୍ୱତ୍ତୋ ଜାଯତେ ଇତ୍ୟଧୁନାଜାନନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ମହ୍ୟଂ ଯମୁପଦେଶମ୍ ଅଦଦା ଅହମପି ତେଭ୍ୟସ୍ତମୁପଦେଶମ୍ ଅଦଦାଂ ତେପି ତମଗୃହ୍ଲନ୍ ତ୍ୱତ୍ତୋହଂ ନିର୍ଗତ୍ୟ ତ୍ୱଯା ପ୍ରେରିତୋଭୱମ୍ ଅତ୍ର ଚ ୱ୍ୟଶ୍ୱସନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","ତେଷାମେୱ ନିମିତ୍ତଂ ପ୍ରାର୍ଥଯେଽହଂ ଜଗତୋ ଲୋକନିମିତ୍ତଂ ନ ପ୍ରାର୍ଥଯେ କିନ୍ତୁ ଯାଲ୍ଲୋକାନ୍ ମହ୍ୟମ୍ ଅଦଦାସ୍ତେଷାମେୱ ନିମିତ୍ତଂ ପ୍ରାର୍ଥଯେଽହଂ ଯତସ୍ତେ ତୱୈୱାସତେ| ");
INSERT INTO sanori_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ଯେ ମମ ତେ ତୱ ଯେ ଚ ତୱ ତେ ମମ ତଥା ତୈ ର୍ମମ ମହିମା ପ୍ରକାଶ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","ସାମ୍ପ୍ରତମ୍ ଅସ୍ମିନ୍ ଜଗତି ମମାୱସ୍ଥିତେଃ ଶେଷମ୍ ଅଭୱତ୍ ଅହଂ ତୱ ସମୀପଂ ଗଚ୍ଛାମି କିନ୍ତୁ ତେ ଜଗତି ସ୍ଥାସ୍ୟନ୍ତି; ହେ ପୱିତ୍ର ପିତରାୱଯୋ ର୍ୟଥୈକତ୍ୱମାସ୍ତେ ତଥା ତେଷାମପ୍ୟେକତ୍ୱଂ ଭୱତି ତଦର୍ଥଂ ଯାଲ୍ଲୋକାନ୍ ମହ୍ୟମ୍ ଅଦଦାସ୍ତାନ୍ ସ୍ୱନାମ୍ନା ରକ୍ଷ| ");
INSERT INTO sanori_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","ଯାୱନ୍ତି ଦିନାନି ଜଗତ୍ୟସ୍ମିନ୍ ତୈଃ ସହାହମାସଂ ତାୱନ୍ତି ଦିନାନି ତାନ୍ ତୱ ନାମ୍ନାହଂ ରକ୍ଷିତୱାନ୍; ଯାଲ୍ଲୋକାନ୍ ମହ୍ୟମ୍ ଅଦଦାସ୍ତାନ୍ ସର୍ୱ୍ୱାନ୍ ଅହମରକ୍ଷଂ, ତେଷାଂ ମଧ୍ୟେ କେୱଲଂ ୱିନାଶପାତ୍ରଂ ହାରିତଂ ତେନ ଧର୍ମ୍ମପୁସ୍ତକସ୍ୟ ୱଚନଂ ପ୍ରତ୍ୟକ୍ଷଂ ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","କିନ୍ତ୍ୱଧୁନା ତୱ ସନ୍ନିଧିଂ ଗଚ୍ଛାମି ମଯା ଯଥା ତେଷାଂ ସମ୍ପୂର୍ଣାନନ୍ଦୋ ଭୱତି ତଦର୍ଥମହଂ ଜଗତି ତିଷ୍ଠନ୍ ଏତାଃ କଥା ଅକଥଯମ୍| ");
INSERT INTO sanori_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","ତୱୋପଦେଶଂ ତେଭ୍ୟୋଽଦଦାଂ ଜଗତା ସହ ଯଥା ମମ ସମ୍ବନ୍ଧୋ ନାସ୍ତି ତଥା ଜଜତା ସହ ତେଷାମପି ସମ୍ବନ୍ଧାଭାୱାଜ୍ ଜଗତୋ ଲୋକାସ୍ତାନ୍ ଋତୀଯନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ତ୍ୱଂ ଜଗତସ୍ତାନ୍ ଗୃହାଣେତି ନ ପ୍ରାର୍ଥଯେ କିନ୍ତ୍ୱଶୁଭାଦ୍ ରକ୍ଷେତି ପ୍ରାର୍ଥଯେହମ୍| ");
INSERT INTO sanori_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ଅହଂ ଯଥା ଜଗତ୍ସମ୍ବନ୍ଧୀଯୋ ନ ଭୱାମି ତଥା ତେପି ଜଗତ୍ସମ୍ବନ୍ଧୀଯା ନ ଭୱନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","ତୱ ସତ୍ୟକଥଯା ତାନ୍ ପୱିତ୍ରୀକୁରୁ ତୱ ୱାକ୍ୟମେୱ ସତ୍ୟଂ| ");
INSERT INTO sanori_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ତ୍ୱଂ ଯଥା ମାଂ ଜଗତି ପ୍ରୈରଯସ୍ତଥାହମପି ତାନ୍ ଜଗତି ପ୍ରୈରଯଂ| ");
INSERT INTO sanori_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","ତେଷାଂ ହିତାର୍ଥଂ ଯଥାହଂ ସ୍ୱଂ ପୱିତ୍ରୀକରୋମି ତଥା ସତ୍ୟକଥଯା ତେପି ପୱିତ୍ରୀଭୱନ୍ତୁ| ");
INSERT INTO sanori_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","କେୱଲଂ ଏତେଷାମର୍ଥେ ପ୍ରାର୍ଥଯେଽହମ୍ ଇତି ନ କିନ୍ତ୍ୱେତେଷାମୁପଦେଶେନ ଯେ ଜନା ମଯି ୱିଶ୍ୱସିଷ୍ୟନ୍ତି ତେଷାମପ୍ୟର୍ଥେ ପ୍ରାର୍ଥେଯେଽହମ୍| ");
INSERT INTO sanori_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ହେ ପିତସ୍ତେଷାଂ ସର୍ୱ୍ୱେଷାମ୍ ଏକତ୍ୱଂ ଭୱତୁ ତୱ ଯଥା ମଯି ମମ ଚ ଯଥା ତ୍ୱଯ୍ୟେକତ୍ୱଂ ତଥା ତେଷାମପ୍ୟାୱଯୋରେକତ୍ୱଂ ଭୱତୁ ତେନ ତ୍ୱଂ ମାଂ ପ୍ରେରିତୱାନ୍ ଇତି ଜଗତୋ ଲୋକାଃ ପ୍ରତିଯନ୍ତୁ| ");
INSERT INTO sanori_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","ଯଥାୱଯୋରେକତ୍ୱଂ ତଥା ତେଷାମପ୍ୟେକତ୍ୱଂ ଭୱତୁ ତେଷ୍ୱହଂ ମଯି ଚ ତ୍ୱମ୍ ଇତ୍ଥଂ ତେଷାଂ ସମ୍ପୂର୍ଣମେକତ୍ୱଂ ଭୱତୁ, ତ୍ୱଂ ପ୍ରେରିତୱାନ୍ ତ୍ୱଂ ମଯି ଯଥା ପ୍ରୀଯସେ ଚ ତଥା ତେଷ୍ୱପି ପ୍ରୀତୱାନ୍ ଏତଦ୍ୟଥା ଜଗତୋ ଲୋକା ଜାନନ୍ତି ");
INSERT INTO sanori_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ତଦର୍ଥଂ ତ୍ୱଂ ଯଂ ମହିମାନଂ ମହ୍ୟମ୍ ଅଦଦାସ୍ତଂ ମହିମାନମ୍ ଅହମପି ତେଭ୍ୟୋ ଦତ୍ତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","ହେ ପିତ ର୍ଜଗତୋ ନିର୍ମ୍ମାଣାତ୍ ପୂର୍ୱ୍ୱଂ ମଯି ସ୍ନେହଂ କୃତ୍ୱା ଯଂ ମହିମାନଂ ଦତ୍ତୱାନ୍ ମମ ତଂ ମହିମାନଂ ଯଥା ତେ ପଶ୍ୟନ୍ତି ତଦର୍ଥଂ ଯାଲ୍ଲୋକାନ୍ ମହ୍ୟଂ ଦତ୍ତୱାନ୍ ଅହଂ ଯତ୍ର ତିଷ୍ଠାମି ତେପି ଯଥା ତତ୍ର ତିଷ୍ଠନ୍ତି ମମୈଷା ୱାଞ୍ଛା| ");
INSERT INTO sanori_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ହେ ଯଥାର୍ଥିକ ପିତ ର୍ଜଗତୋ ଲୋକୈସ୍ତ୍ୱଯ୍ୟଜ୍ଞାତେପି ତ୍ୱାମହଂ ଜାନେ ତ୍ୱଂ ମାଂ ପ୍ରେରିତୱାନ୍ ଇତୀମେ ଶିଷ୍ୟା ଜାନନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","ଯଥାହଂ ତେଷୁ ତିଷ୍ଠାମି ତଥା ମଯି ଯେନ ପ୍ରେମ୍ନା ପ୍ରେମାକରୋସ୍ତତ୍ ତେଷୁ ତିଷ୍ଠତି ତଦର୍ଥଂ ତୱ ନାମାହଂ ତାନ୍ ଜ୍ଞାପିତୱାନ୍ ପୁନରପି ଜ୍ଞାପଯିଷ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","ତାଃ କଥାଃ କଥଯିତ୍ୱା ଯୀଶୁଃ ଶିଷ୍ୟାନାଦାଯ କିଦ୍ରୋନ୍ନାମକଂ ସ୍ରୋତ ଉତ୍ତୀର୍ୟ୍ୟ ଶିଷ୍ୟୈଃ ସହ ତତ୍ରତ୍ୟୋଦ୍ୟାନଂ ପ୍ରାୱିଶତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","କିନ୍ତୁ ୱିଶ୍ୱାସଘାତିଯିହୂଦାସ୍ତତ୍ ସ୍ଥାନଂ ପରିଚୀଯତେ ଯତୋ ଯୀଶୁଃ ଶିଷ୍ୟୈଃ ସାର୍ଦ୍ଧଂ କଦାଚିତ୍ ତତ୍ ସ୍ଥାନମ୍ ଅଗଚ୍ଛତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ତଦା ସ ଯିହୂଦାଃ ସୈନ୍ୟଗଣଂ ପ୍ରଧାନଯାଜକାନାଂ ଫିରୂଶିନାଞ୍ଚ ପଦାତିଗଣଞ୍ଚ ଗୃହୀତ୍ୱା ପ୍ରଦୀପାନ୍ ଉଲ୍କାନ୍ ଅସ୍ତ୍ରାଣି ଚାଦାଯ ତସ୍ମିନ୍ ସ୍ଥାନ ଉପସ୍ଥିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","ସ୍ୱଂ ପ୍ରତି ଯଦ୍ ଘଟିଷ୍ୟତେ ତଜ୍ ଜ୍ଞାତ୍ୱା ଯୀଶୁରଗ୍ରେସରଃ ସନ୍ ତାନପୃଚ୍ଛତ୍ କଂ ଗୱେଷଯଥ? ");
INSERT INTO sanori_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","ତେ ପ୍ରତ୍ୟୱଦନ୍, ନାସରତୀଯଂ ଯୀଶୁଂ; ତତୋ ଯୀଶୁରୱାଦୀଦ୍ ଅହମେୱ ସଃ; ତୈଃ ସହ ୱିଶ୍ୱାସଘାତୀ ଯିହୂଦାଶ୍ଚାତିଷ୍ଠତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ତଦାହମେୱ ସ ତସ୍ୟୈତାଂ କଥାଂ ଶ୍ରୁତ୍ୱୈୱ ତେ ପଶ୍ଚାଦେତ୍ୟ ଭୂମୌ ପତିତାଃ| ");
INSERT INTO sanori_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","ତତୋ ଯୀଶୁଃ ପୁନରପି ପୃଷ୍ଠୱାନ୍ କଂ ଗୱେଷଯଥ? ତତସ୍ତେ ପ୍ରତ୍ୟୱଦନ୍ ନାସରତୀଯଂ ଯୀଶୁଂ| ");
INSERT INTO sanori_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ତଦା ଯୀଶୁଃ ପ୍ରତ୍ୟୁଦିତୱାନ୍ ଅହମେୱ ସ ଇମାଂ କଥାମଚକଥମ୍; ଯଦି ମାମନ୍ୱିଚ୍ଛଥ ତର୍ହୀମାନ୍ ଗନ୍ତୁଂ ମା ୱାରଯତ| ");
INSERT INTO sanori_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ଇତ୍ଥଂ ଭୂତେ ମହ୍ୟଂ ଯାଲ୍ଲୋକାନ୍ ଅଦଦାସ୍ତେଷାମ୍ ଏକମପି ନାହାରଯମ୍ ଇମାଂ ଯାଂ କଥାଂ ସ ସ୍ୱଯମକଥଯତ୍ ସା କଥା ସଫଲା ଜାତା| ");
INSERT INTO sanori_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","ତଦା ଶିମୋନ୍ପିତରସ୍ୟ ନିକଟେ ଖଙ୍ଗଲ୍ସ୍ଥିତେଃ ସ ତଂ ନିଷ୍କୋଷଂ କୃତ୍ୱା ମହାଯାଜକସ୍ୟ ମାଲ୍ଖନାମାନଂ ଦାସମ୍ ଆହତ୍ୟ ତସ୍ୟ ଦକ୍ଷିଣକର୍ଣଂ ଛିନ୍ନୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ତତୋ ଯୀଶୁଃ ପିତରମ୍ ଅୱଦତ୍, ଖଙ୍ଗଂ କୋଷେ ସ୍ଥାପଯ ମମ ପିତା ମହ୍ୟଂ ପାତୁଂ ଯଂ କଂସମ୍ ଅଦଦାତ୍ ତେନାହଂ କିଂ ନ ପାସ୍ୟାମି? ");
INSERT INTO sanori_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","ତଦା ସୈନ୍ୟଗଣଃ ସେନାପତି ର୍ୟିହୂଦୀଯାନାଂ ପଦାତଯଶ୍ଚ ଯୀଶୁଂ ଘୃତ୍ୱା ବଦ୍ଧ୍ୱା ହାନନ୍ନାମ୍ନଃ କିଯଫାଃ ଶ୍ୱଶୁରସ୍ୟ ସମୀପଂ ପ୍ରଥମମ୍ ଅନଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ସ କିଯଫାସ୍ତସ୍ମିନ୍ ୱତ୍ସରେ ମହାଯାଜତ୍ୱପଦେ ନିଯୁକ୍ତଃ ");
INSERT INTO sanori_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ସନ୍ ସାଧାରଣଲୋକାନାଂ ମଙ୍ଗଲାର୍ଥମ୍ ଏକଜନସ୍ୟ ମରଣମୁଚିତମ୍ ଇତି ଯିହୂଦୀଯୈଃ ସାର୍ଦ୍ଧମ୍ ଅମନ୍ତ୍ରଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","ତଦା ଶିମୋନ୍ପିତରୋଽନ୍ୟୈକଶିଷ୍ୟଶ୍ଚ ଯୀଶୋଃ ପଶ୍ଚାଦ୍ ଅଗଚ୍ଛତାଂ ତସ୍ୟାନ୍ୟଶିଷ୍ୟସ୍ୟ ମହାଯାଜକେନ ପରିଚିତତ୍ୱାତ୍ ସ ଯୀଶୁନା ସହ ମହାଯାଜକସ୍ୟାଟ୍ଟାଲିକାଂ ପ୍ରାୱିଶତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","କିନ୍ତୁ ପିତରୋ ବହିର୍ଦ୍ୱାରସ୍ୟ ସମୀପେଽତିଷ୍ଠଦ୍ ଅତଏୱ ମହାଯାଜକେନ ପରିଚିତଃ ସ ଶିଷ୍ୟଃ ପୁନର୍ବହିର୍ଗତ୍ୱା ଦୌୱାଯିକାଯୈ କଥଯିତ୍ୱା ପିତରମ୍ ଅଭ୍ୟନ୍ତରମ୍ ଆନଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ତଦା ସ ଦ୍ୱାରରକ୍ଷିକା ପିତରମ୍ ଅୱଦତ୍ ତ୍ୱଂ କିଂ ନ ତସ୍ୟ ମାନୱସ୍ୟ ଶିଷ୍ୟଃ? ତତଃ ସୋୱଦଦ୍ ଅହଂ ନ ଭୱାମି| ");
INSERT INTO sanori_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ତତଃ ପରଂ ଯତ୍ସ୍ଥାନେ ଦାସାଃ ପଦାତଯଶ୍ଚ ଶୀତହେତୋରଙ୍ଗାରୈ ର୍ୱହ୍ନିଂ ପ୍ରଜ୍ୱାଲ୍ୟ ତାପଂ ସେୱିତୱନ୍ତସ୍ତତ୍ସ୍ଥାନେ ପିତରସ୍ତିଷ୍ଠନ୍ ତୈଃ ସହ ୱହ୍ନିତାପଂ ସେୱିତୁମ୍ ଆରଭତ| ");
INSERT INTO sanori_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","ତଦା ଶିଷ୍ୟେଷୂପଦେଶେ ଚ ମହାଯାଜକେନ ଯୀଶୁଃ ପୃଷ୍ଟଃ ");
INSERT INTO sanori_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","ସନ୍ ପ୍ରତ୍ୟୁକ୍ତୱାନ୍ ସର୍ୱ୍ୱଲୋକାନାଂ ସମକ୍ଷଂ କଥାମକଥଯଂ ଗୁପ୍ତଂ କାମପି କଥାଂ ନ କଥଯିତ୍ୱା ଯତ୍ ସ୍ଥାନଂ ଯିହୂଦୀଯାଃ ସତତଂ ଗଚ୍ଛନ୍ତି ତତ୍ର ଭଜନଗେହେ ମନ୍ଦିରେ ଚାଶିକ୍ଷଯଂ| ");
INSERT INTO sanori_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","ମତ୍ତଃ କୁତଃ ପୃଚ୍ଛସି? ଯେ ଜନା ମଦୁପଦେଶମ୍ ଅଶୃଣ୍ୱନ୍ ତାନେୱ ପୃଚ୍ଛ ଯଦ୍ୟଦ୍ ଅୱଦଂ ତେ ତତ୍ ଜାନିନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","ତଦେତ୍ଥଂ ପ୍ରତ୍ୟୁଦିତତ୍ୱାତ୍ ନିକଟସ୍ଥପଦାତି ର୍ୟୀଶୁଂ ଚପେଟେନାହତ୍ୟ ୱ୍ୟାହରତ୍ ମହାଯାଜକମ୍ ଏୱଂ ପ୍ରତିୱଦସି? ");
INSERT INTO sanori_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ତତୋ ଯୀଶୁଃ ପ୍ରତିଗଦିତୱାନ୍ ଯଦ୍ୟଯଥାର୍ଥମ୍ ଅଚକଥଂ ତର୍ହି ତସ୍ୟାଯଥାର୍ଥସ୍ୟ ପ୍ରମାଣଂ ଦେହି, କିନ୍ତୁ ଯଦି ଯଥାର୍ଥଂ ତର୍ହି କୁତୋ ହେତୋ ର୍ମାମ୍ ଅତାଡଯଃ? ");
INSERT INTO sanori_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","ପୂର୍ୱ୍ୱଂ ହାନନ୍ ସବନ୍ଧନଂ ତଂ କିଯଫାମହାଯାଜକସ୍ୟ ସମୀପଂ ପ୍ରୈଷଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ଶିମୋନ୍ପିତରସ୍ତିଷ୍ଠନ୍ ୱହ୍ନିତାପଂ ସେୱତେ, ଏତସ୍ମିନ୍ ସମଯେ କିଯନ୍ତସ୍ତମ୍ ଅପୃଚ୍ଛନ୍ ତ୍ୱଂ କିମ୍ ଏତସ୍ୟ ଜନସ୍ୟ ଶିଷ୍ୟୋ ନ? ତତଃ ସୋପହ୍ନୁତ୍ୟାବ୍ରୱୀଦ୍ ଅହଂ ନ ଭୱାମି| ");
INSERT INTO sanori_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","ତଦା ମହାଯାଜକସ୍ୟ ଯସ୍ୟ ଦାସସ୍ୟ ପିତରଃ କର୍ଣମଚ୍ଛିନତ୍ ତସ୍ୟ କୁଟୁମ୍ବଃ ପ୍ରତ୍ୟୁଦିତୱାନ୍ ଉଦ୍ୟାନେ ତେନ ସହ ତିଷ୍ଠନ୍ତଂ ତ୍ୱାଂ କିଂ ନାପଶ୍ୟଂ? ");
INSERT INTO sanori_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","କିନ୍ତୁ ପିତରଃ ପୁନରପହ୍ନୁତ୍ୟ କଥିତୱାନ୍; ତଦାନୀଂ କୁକ୍କୁଟୋଽରୌତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","ତଦନନ୍ତରଂ ପ୍ରତ୍ୟୂଷେ ତେ କିଯଫାଗୃହାଦ୍ ଅଧିପତେ ର୍ଗୃହଂ ଯୀଶୁମ୍ ଅନଯନ୍ କିନ୍ତୁ ଯସ୍ମିନ୍ ଅଶୁଚିତ୍ୱେ ଜାତେ ତୈ ର୍ନିସ୍ତାରୋତ୍ସୱେ ନ ଭୋକ୍ତୱ୍ୟଂ, ତସ୍ୟ ଭଯାଦ୍ ଯିହୂଦୀଯାସ୍ତଦ୍ଗୃହଂ ନାୱିଶନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","ଅପରଂ ପୀଲାତୋ ବହିରାଗତ୍ୟ ତାନ୍ ପୃଷ୍ଠୱାନ୍ ଏତସ୍ୟ ମନୁଷ୍ୟସ୍ୟ କଂ ଦୋଷଂ ୱଦଥ? ");
INSERT INTO sanori_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ତଦା ତେ ପେତ୍ୟୱଦନ୍ ଦୁଷ୍କର୍ମ୍ମକାରିଣି ନ ସତି ଭୱତଃ ସମୀପେ ନୈନଂ ସମାର୍ପଯିଷ୍ୟାମଃ| ");
INSERT INTO sanori_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ତତଃ ପୀଲାତୋଽୱଦଦ୍ ଯୂଯମେନଂ ଗୃହୀତ୍ୱା ସ୍ୱେଷାଂ ୱ୍ୟୱସ୍ଥଯା ୱିଚାରଯତ| ତଦା ଯିହୂଦୀଯାଃ ପ୍ରତ୍ୟୱଦନ୍ କସ୍ୟାପି ମନୁଷ୍ୟସ୍ୟ ପ୍ରାଣଦଣ୍ଡଂ କର୍ତ୍ତୁଂ ନାସ୍ମାକମ୍ ଅଧିକାରୋଽସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ଏୱଂ ସତି ଯୀଶୁଃ ସ୍ୱସ୍ୟ ମୃତ୍ୟୌ ଯାଂ କଥାଂ କଥିତୱାନ୍ ସା ସଫଲାଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","ତଦନନ୍ତରଂ ପୀଲାତଃ ପୁନରପି ତଦ୍ ରାଜଗୃହଂ ଗତ୍ୱା ଯୀଶୁମାହୂଯ ପୃଷ୍ଟୱାନ୍ ତ୍ୱଂ କିଂ ଯିହୂଦୀଯାନାଂ ରାଜା? ");
INSERT INTO sanori_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","ଯୀଶୁଃ ପ୍ରତ୍ୟୱଦତ୍ ତ୍ୱମ୍ ଏତାଂ କଥାଂ ସ୍ୱତଃ କଥଯସି କିମନ୍ୟଃ କଶ୍ଚିନ୍ ମଯି କଥିତୱାନ୍? ");
INSERT INTO sanori_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ପୀଲାତୋଽୱଦଦ୍ ଅହଂ କିଂ ଯିହୂଦୀଯଃ? ତୱ ସ୍ୱଦେଶୀଯା ୱିଶେଷତଃ ପ୍ରଧାନଯାଜକା ମମ ନିକଟେ ତ୍ୱାଂ ସମାର୍ପଯନ, ତ୍ୱଂ କିଂ କୃତୱାନ୍? ");
INSERT INTO sanori_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","ଯୀଶୁଃ ପ୍ରତ୍ୟୱଦତ୍ ମମ ରାଜ୍ୟମ୍ ଏତଜ୍ଜଗତ୍ସମ୍ବନ୍ଧୀଯଂ ନ ଭୱତି ଯଦି ମମ ରାଜ୍ୟଂ ଜଗତ୍ସମ୍ବନ୍ଧୀଯମ୍ ଅଭୱିଷ୍ୟତ୍ ତର୍ହି ଯିହୂଦୀଯାନାଂ ହସ୍ତେଷୁ ଯଥା ସମର୍ପିତୋ ନାଭୱଂ ତଦର୍ଥଂ ମମ ସେୱକା ଅଯୋତ୍ସ୍ୟନ୍ କିନ୍ତୁ ମମ ରାଜ୍ୟମ୍ ଐହିକଂ ନ| ");
INSERT INTO sanori_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","ତଦା ପୀଲାତଃ କଥିତୱାନ୍, ତର୍ହି ତ୍ୱଂ ରାଜା ଭୱସି? ଯୀଶୁଃ ପ୍ରତ୍ୟୁକ୍ତୱାନ୍ ତ୍ୱଂ ସତ୍ୟଂ କଥଯସି, ରାଜାହଂ ଭୱାମି; ସତ୍ୟତାଯାଂ ସାକ୍ଷ୍ୟଂ ଦାତୁଂ ଜନିଂ ଗୃହୀତ୍ୱା ଜଗତ୍ୟସ୍ମିନ୍ ଅୱତୀର୍ଣୱାନ୍, ତସ୍ମାତ୍ ସତ୍ୟଧର୍ମ୍ମପକ୍ଷପାତିନୋ ମମ କଥାଂ ଶୃଣ୍ୱନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","ତଦା ସତ୍ୟଂ କିଂ? ଏତାଂ କଥାଂ ପଷ୍ଟ୍ୱା ପୀଲାତଃ ପୁନରପି ବହିର୍ଗତ୍ୱା ଯିହୂଦୀଯାନ୍ ଅଭାଷତ, ଅହଂ ତସ୍ୟ କମପ୍ୟପରାଧଂ ନ ପ୍ରାପ୍ନୋମି| ");
INSERT INTO sanori_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","ନିସ୍ତାରୋତ୍ସୱସମଯେ ଯୁଷ୍ମାଭିରଭିରୁଚିତ ଏକୋ ଜନୋ ମଯା ମୋଚଯିତୱ୍ୟ ଏଷା ଯୁଷ୍ମାକଂ ରୀତିରସ୍ତି, ଅତଏୱ ଯୁଷ୍ମାକଂ ନିକଟେ ଯିହୂଦୀଯାନାଂ ରାଜାନଂ କିଂ ମୋଚଯାମି, ଯୁଷ୍ମାକମ୍ ଇଚ୍ଛା କା? ");
INSERT INTO sanori_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","ତଦା ତେ ସର୍ୱ୍ୱେ ରୁୱନ୍ତୋ ୱ୍ୟାହରନ୍ ଏନଂ ମାନୁଷଂ ନହି ବରବ୍ବାଂ ମୋଚଯ| କିନ୍ତୁ ସ ବରବ୍ବା ଦସ୍ୟୁରାସୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","ପୀଲାତୋ ଯୀଶୁମ୍ ଆନୀଯ କଶଯା ପ୍ରାହାରଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ପଶ୍ଚାତ୍ ସେନାଗଣଃ କଣ୍ଟକନିର୍ମ୍ମିତଂ ମୁକୁଟଂ ତସ୍ୟ ମସ୍ତକେ ସମର୍ପ୍ୟ ୱାର୍ତ୍ତାକୀୱର୍ଣଂ ରାଜପରିଚ୍ଛଦଂ ପରିଧାପ୍ୟ, ");
INSERT INTO sanori_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ହେ ଯିହୂଦୀଯାନାଂ ରାଜନ୍ ନମସ୍କାର ଇତ୍ୟୁକ୍ତ୍ୱା ତଂ ଚପେଟେନାହନ୍ତୁମ୍ ଆରଭତ| ");
INSERT INTO sanori_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","ତଦା ପୀଲାତଃ ପୁନରପି ବହିର୍ଗତ୍ୱା ଲୋକାନ୍ ଅୱଦତ୍, ଅସ୍ୟ କମପ୍ୟପରାଧଂ ନ ଲଭେଽହଂ, ପଶ୍ୟତ ତଦ୍ ଯୁଷ୍ମାନ୍ ଜ୍ଞାପଯିତୁଂ ଯୁଷ୍ମାକଂ ସନ୍ନିଧୌ ବହିରେନମ୍ ଆନଯାମି| ");
INSERT INTO sanori_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","ତତଃ ପରଂ ଯୀଶୁଃ କଣ୍ଟକମୁକୁଟୱାନ୍ ୱାର୍ତ୍ତାକୀୱର୍ଣୱସନୱାଂଶ୍ଚ ବହିରାଗଚ୍ଛତ୍| ତତଃ ପୀଲାତ ଉକ୍ତୱାନ୍ ଏନଂ ମନୁଷ୍ୟଂ ପଶ୍ୟତ| ");
INSERT INTO sanori_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ତଦା ପ୍ରଧାନଯାଜକାଃ ପଦାତଯଶ୍ଚ ତଂ ଦୃଷ୍ଟ୍ୱା, ଏନଂ କ୍ରୁଶେ ୱିଧ, ଏନଂ କ୍ରୁଶେ ୱିଧ, ଇତ୍ୟୁକ୍ତ୍ୱା ରୱିତୁଂ ଆରଭନ୍ତ| ତତଃ ପୀଲାତଃ କଥିତୱାନ୍ ଯୂଯଂ ସ୍ୱଯମ୍ ଏନଂ ନୀତ୍ୱା କ୍ରୁଶେ ୱିଧତ, ଅହମ୍ ଏତସ୍ୟ କମପ୍ୟପରାଧଂ ନ ପ୍ରାପ୍ତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","ଯିହୂଦୀଯାଃ ପ୍ରତ୍ୟୱଦନ୍ ଅସ୍ମାକଂ ଯା ୱ୍ୟୱସ୍ଥାସ୍ତେ ତଦନୁସାରେଣାସ୍ୟ ପ୍ରାଣହନନମ୍ ଉଚିତଂ ଯତୋଯଂ ସ୍ୱମ୍ ଈଶ୍ୱରସ୍ୟ ପୁତ୍ରମୱଦତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ପୀଲାତ ଇମାଂ କଥାଂ ଶ୍ରୁତ୍ୱା ମହାତ୍ରାସଯୁକ୍ତଃ ");
INSERT INTO sanori_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ସନ୍ ପୁନରପି ରାଜଗୃହ ଆଗତ୍ୟ ଯୀଶୁଂ ପୃଷ୍ଟୱାନ୍ ତ୍ୱଂ କୁତ୍ରତ୍ୟୋ ଲୋକଃ? କିନ୍ତୁ ଯୀଶସ୍ତସ୍ୟ କିମପି ପ୍ରତ୍ୟୁତ୍ତରଂ ନାୱଦତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","୧॰ ତତଃ ପୀଲାତ୍ କଥିତୱାନ ତ୍ୱଂ କିଂ ମଯା ସାର୍ଦ୍ଧଂ ନ ସଂଲପିଷ୍ୟସି ? ତ୍ୱାଂ କ୍ରୁଶେ ୱେଧିତୁଂ ୱା ମୋଚଯିତୁଂ ଶକ୍ତି ର୍ମମାସ୍ତେ ଇତି କିଂ ତ୍ୱଂ ନ ଜାନାସି ? ତଦା ଯୀଶୁଃ ପ୍ରତ୍ୟୱଦଦ୍ ଈଶ୍ୱରେଣାଦŸाଂ ମମୋପରି ତୱ କିମପ୍ୟଧିପତିତ୍ୱଂ ନ ୱିଦ୍ୟତେ, ତଥାପି ଯୋ ଜନୋ ମାଂ ତୱ ହସ୍ତେ ସମାର୍ପଯତ୍ ତସ୍ୟ ମହାପାତକଂ ଜାତମ୍| ");
INSERT INTO sanori_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ତଦା ଯୀଶୁଃ ପ୍ରତ୍ୟୱଦଦ୍ ଈଶ୍ୱରେଣାଦତ୍ତଂ ମମୋପରି ତୱ କିମପ୍ୟଧିପତିତ୍ୱଂ ନ ୱିଦ୍ୟତେ, ତଥାପି ଯୋ ଜନୋ ମାଂ ତୱ ହସ୍ତେ ସମାର୍ପଯତ୍ ତସ୍ୟ ମହାପାତକଂ ଜାତମ୍| ");
INSERT INTO sanori_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ତଦାରଭ୍ୟ ପୀଲାତସ୍ତଂ ମୋଚଯିତୁଂ ଚେଷ୍ଟିତୱାନ୍ କିନ୍ତୁ ଯିହୂଦୀଯା ରୁୱନ୍ତୋ ୱ୍ୟାହରନ୍ ଯଦୀମଂ ମାନୱଂ ତ୍ୟଜସି ତର୍ହି ତ୍ୱଂ କୈସରସ୍ୟ ମିତ୍ରଂ ନ ଭୱସି, ଯୋ ଜନଃ ସ୍ୱଂ ରାଜାନଂ ୱକ୍ତି ସଏୱ କୈମରସ୍ୟ ୱିରୁଦ୍ଧାଂ କଥାଂ କଥଯତି| ");
INSERT INTO sanori_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ଏତାଂ କଥାଂ ଶ୍ରୁତ୍ୱା ପୀଲାତୋ ଯୀଶୁଂ ବହିରାନୀଯ ନିସ୍ତାରୋତ୍ସୱସ୍ୟ ଆସାଦନଦିନସ୍ୟ ଦ୍ୱିତୀଯପ୍ରହରାତ୍ ପୂର୍ୱ୍ୱଂ ପ୍ରସ୍ତରବନ୍ଧନନାମ୍ନି ସ୍ଥାନେ ଽର୍ଥାତ୍ ଇବ୍ରୀଯଭାଷଯା ଯଦ୍ ଗବ୍ବିଥା କଥ୍ୟତେ ତସ୍ମିନ୍ ସ୍ଥାନେ ୱିଚାରାସନ ଉପାୱିଶତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ଅନନ୍ତରଂ ପୀଲାତୋ ଯିହୂଦୀଯାନ୍ ଅୱଦତ୍, ଯୁଷ୍ମାକଂ ରାଜାନଂ ପଶ୍ୟତ| ");
INSERT INTO sanori_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","କିନ୍ତୁ ଏନଂ ଦୂରୀକୁରୁ, ଏନଂ ଦୂରୀକୁରୁ, ଏନଂ କ୍ରୁଶେ ୱିଧ, ଇତି କଥାଂ କଥଯିତ୍ୱା ତେ ରୱିତୁମ୍ ଆରଭନ୍ତ; ତଦା ପୀଲାତଃ କଥିତୱାନ୍ ଯୁଷ୍ମାକଂ ରାଜାନଂ କିଂ କ୍ରୁଶେ ୱେଧିଷ୍ୟାମି? ପ୍ରଧାନଯାଜକା ଉତ୍ତରମ୍ ଅୱଦନ୍ କୈସରଂ ୱିନା କୋପି ରାଜାସ୍ମାକଂ ନାସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","ତତଃ ପୀଲାତୋ ଯୀଶୁଂ କ୍ରୁଶେ ୱେଧିତୁଂ ତେଷାଂ ହସ୍ତେଷୁ ସମାର୍ପଯତ୍, ତତସ୍ତେ ତଂ ଧୃତ୍ୱା ନୀତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ତତଃ ପରଂ ଯୀଶୁଃ କ୍ରୁଶଂ ୱହନ୍ ଶିରଃକପାଲମ୍ ଅର୍ଥାଦ୍ ଯଦ୍ ଇବ୍ରୀଯଭାଷଯା ଗୁଲ୍ଗଲ୍ତାଂ ୱଦନ୍ତି ତସ୍ମିନ୍ ସ୍ଥାନ ଉପସ୍ଥିତଃ| ");
INSERT INTO sanori_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ତତସ୍ତେ ମଧ୍ୟସ୍ଥାନେ ତଂ ତସ୍ୟୋଭଯପାର୍ଶ୍ୱେ ଦ୍ୱାୱପରୌ କ୍ରୁଶେଽୱିଧନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","ଅପରମ୍ ଏଷ ଯିହୂଦୀଯାନାଂ ରାଜା ନାସରତୀଯଯୀଶୁଃ, ଇତି ୱିଜ୍ଞାପନଂ ଲିଖିତ୍ୱା ପୀଲାତସ୍ତସ୍ୟ କ୍ରୁଶୋପରି ସମଯୋଜଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","ସା ଲିପିଃ ଇବ୍ରୀଯଯୂନାନୀଯରୋମୀଯଭାଷାଭି ର୍ଲିଖିତା; ଯୀଶୋଃ କ୍ରୁଶୱେଧନସ୍ଥାନଂ ନଗରସ୍ୟ ସମୀପଂ, ତସ୍ମାଦ୍ ବହୱୋ ଯିହୂଦୀଯାସ୍ତାଂ ପଠିତୁମ୍ ଆରଭନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","ଯିହୂଦୀଯାନାଂ ପ୍ରଧାନଯାଜକାଃ ପୀଲାତମିତି ନ୍ୟୱେଦଯନ୍ ଯିହୂଦୀଯାନାଂ ରାଜେତି ୱାକ୍ୟଂ ନ କିନ୍ତୁ ଏଷ ସ୍ୱଂ ଯିହୂଦୀଯାନାଂ ରାଜାନମ୍ ଅୱଦଦ୍ ଇତ୍ଥଂ ଲିଖତୁ| ");
INSERT INTO sanori_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ତତଃ ପୀଲାତ ଉତ୍ତରଂ ଦତ୍ତୱାନ୍ ଯଲ୍ଲେଖନୀଯଂ ତଲ୍ଲିଖିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ଇତ୍ଥଂ ସେନାଗଣୋ ଯୀଶୁଂ କ୍ରୁଶେ ୱିଧିତ୍ୱା ତସ୍ୟ ପରିଧେଯୱସ୍ତ୍ରଂ ଚତୁରୋ ଭାଗାନ୍ କୃତ୍ୱା ଏକୈକସେନା ଏକୈକଭାଗମ୍ ଅଗୃହ୍ଲତ୍ ତସ୍ୟୋତ୍ତରୀଯୱସ୍ତ୍ରଞ୍ଚାଗୃହ୍ଲତ୍| କିନ୍ତୂତ୍ତରୀଯୱସ୍ତ୍ରଂ ସୂଚିସେୱନଂ ୱିନା ସର୍ୱ୍ୱମ୍ ଊତଂ| ");
INSERT INTO sanori_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ତସ୍ମାତ୍ତେ ୱ୍ୟାହରନ୍ ଏତତ୍ କଃ ପ୍ରାପ୍ସ୍ୟତି? ତନ୍ନ ଖଣ୍ଡଯିତ୍ୱା ତତ୍ର ଗୁଟିକାପାତଂ କରୱାମ| ୱିଭଜନ୍ତେଽଧରୀଯଂ ମେ ୱସନଂ ତେ ପରସ୍ପରଂ| ମମୋତ୍ତରୀଯୱସ୍ତ୍ରାର୍ଥଂ ଗୁଟିକାଂ ପାତଯନ୍ତି ଚ| ଇତି ଯଦ୍ୱାକ୍ୟଂ ଧର୍ମ୍ମପୁସ୍ତକେ ଲିଖିତମାସ୍ତେ ତତ୍ ସେନାଗଣେନେତ୍ଥଂ ୱ୍ୟୱହରଣାତ୍ ସିଦ୍ଧମଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ତଦାନୀଂ ଯୀଶୋ ର୍ମାତା ମାତୁ ର୍ଭଗିନୀ ଚ ଯା କ୍ଲିଯପା ଭାର୍ୟ୍ୟା ମରିଯମ୍ ମଗ୍ଦଲୀନୀ ମରିଯମ୍ ଚ ଏତାସ୍ତସ୍ୟ କ୍ରୁଶସ୍ୟ ସନ୍ନିଧୌ ସମତିଷ୍ଠନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ତତୋ ଯୀଶୁଃ ସ୍ୱମାତରଂ ପ୍ରିଯତମଶିଷ୍ୟଞ୍ଚ ସମୀପେ ଦଣ୍ଡାଯମାନୌ ୱିଲୋକ୍ୟ ମାତରମ୍ ଅୱଦତ୍, ହେ ଯୋଷିଦ୍ ଏନଂ ତୱ ପୁତ୍ରଂ ପଶ୍ୟ, ");
INSERT INTO sanori_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ଶିଷ୍ୟନ୍ତ୍ୱୱଦତ୍, ଏନାଂ ତୱ ମାତରଂ ପଶ୍ୟ| ତତଃ ସ ଶିଷ୍ୟସ୍ତଦ୍ଘଟିକାଯାଂ ତାଂ ନିଜଗୃହଂ ନୀତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","ଅନନ୍ତରଂ ସର୍ୱ୍ୱଂ କର୍ମ୍ମାଧୁନା ସମ୍ପନ୍ନମଭୂତ୍ ଯୀଶୁରିତି ଜ୍ଞାତ୍ୱା ଧର୍ମ୍ମପୁସ୍ତକସ୍ୟ ୱଚନଂ ଯଥା ସିଦ୍ଧଂ ଭୱତି ତଦର୍ଥମ୍ ଅକଥଯତ୍ ମମ ପିପାସା ଜାତା| ");
INSERT INTO sanori_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ତତସ୍ତସ୍ମିନ୍ ସ୍ଥାନେ ଅମ୍ଲରସେନ ପୂର୍ଣପାତ୍ରସ୍ଥିତ୍ୟା ତେ ସ୍ପଞ୍ଜମେକଂ ତଦମ୍ଲରସେନାର୍ଦ୍ରୀକୃତ୍ୟ ଏସୋବ୍ନଲେ ତଦ୍ ଯୋଜଯିତ୍ୱା ତସ୍ୟ ମୁଖସ୍ୟ ସନ୍ନିଧାୱସ୍ଥାପଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ତଦା ଯୀଶୁରମ୍ଲରସଂ ଗୃହୀତ୍ୱା ସର୍ୱ୍ୱଂ ସିଦ୍ଧମ୍ ଇତି କଥାଂ କଥଯିତ୍ୱା ମସ୍ତକଂ ନମଯନ୍ ପ୍ରାଣାନ୍ ପର୍ୟ୍ୟତ୍ୟଜତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","ତଦ୍ୱିନମ୍ ଆସାଦନଦିନଂ ତସ୍ମାତ୍ ପରେଽହନି ୱିଶ୍ରାମୱାରେ ଦେହା ଯଥା କ୍ରୁଶୋପରି ନ ତିଷ୍ଠନ୍ତି, ଯତଃ ସ ୱିଶ୍ରାମୱାରୋ ମହାଦିନମାସୀତ୍, ତସ୍ମାଦ୍ ଯିହୂଦୀଯାଃ ପୀଲାତନିକଟଂ ଗତ୍ୱା ତେଷାଂ ପାଦଭଞ୍ଜନସ୍ୟ ସ୍ଥାନାନ୍ତରନଯନସ୍ୟ ଚାନୁମତିଂ ପ୍ରାର୍ଥଯନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ଅତଃ ସେନା ଆଗତ୍ୟ ଯୀଶୁନା ସହ କ୍ରୁଶେ ହତଯୋଃ ପ୍ରଥମଦ୍ୱିତୀଯଚୋରଯୋଃ ପାଦାନ୍ ଅଭଞ୍ଜନ୍; ");
INSERT INTO sanori_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","କିନ୍ତୁ ଯୀଶୋଃ ସନ୍ନିଧିଂ ଗତ୍ୱା ସ ମୃତ ଇତି ଦୃଷ୍ଟ୍ୱା ତସ୍ୟ ପାଦୌ ନାଭଞ୍ଜନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","ପଶ୍ଚାଦ୍ ଏକୋ ଯୋଦ୍ଧା ଶୂଲାଘାତେନ ତସ୍ୟ କୁକ୍ଷିମ୍ ଅୱିଧତ୍ ତତ୍କ୍ଷଣାତ୍ ତସ୍ମାଦ୍ ରକ୍ତଂ ଜଲଞ୍ଚ ନିରଗଚ୍ଛତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","ଯୋ ଜନୋଽସ୍ୟ ସାକ୍ଷ୍ୟଂ ଦଦାତି ସ ସ୍ୱଯଂ ଦୃଷ୍ଟୱାନ୍ ତସ୍ୟେଦଂ ସାକ୍ଷ୍ୟଂ ସତ୍ୟଂ ତସ୍ୟ କଥା ଯୁଷ୍ମାକଂ ୱିଶ୍ୱାସଂ ଜନଯିତୁଂ ଯୋଗ୍ୟା ତତ୍ ସ ଜାନାତି| ");
INSERT INTO sanori_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","ତସ୍ୟୈକମ୍ ଅସ୍ଧ୍ୟପି ନ ଭଂକ୍ଷ୍ୟତେ, ");
INSERT INTO sanori_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ତଦ୍ୱଦ୍ ଅନ୍ୟଶାସ୍ତ୍ରେପି ଲିଖ୍ୟତେ, ଯଥା, \"ଦୃଷ୍ଟିପାତଂ କରିଷ୍ୟନ୍ତି ତେଽୱିଧନ୍ ଯନ୍ତୁ ତମ୍ପ୍ରତି| \" ");
INSERT INTO sanori_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","ଅରିମଥୀଯନଗରସ୍ୟ ଯୂଷଫ୍ନାମା ଶିଷ୍ୟ ଏକ ଆସୀତ୍ କିନ୍ତୁ ଯିହୂଦୀଯେଭ୍ୟୋ ଭଯାତ୍ ପ୍ରକାଶିତୋ ନ ଭୱତି; ସ ଯୀଶୋ ର୍ଦେହଂ ନେତୁଂ ପୀଲାତସ୍ୟାନୁମତିଂ ପ୍ରାର୍ଥଯତ, ତତଃ ପୀଲାତେନାନୁମତେ ସତି ସ ଗତ୍ୱା ଯୀଶୋ ର୍ଦେହମ୍ ଅନଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ଅପରଂ ଯୋ ନିକଦୀମୋ ରାତ୍ରୌ ଯୀଶୋଃ ସମୀପମ୍ ଅଗଚ୍ଛତ୍ ସୋପି ଗନ୍ଧରସେନ ମିଶ୍ରିତଂ ପ୍ରାଯେଣ ପଞ୍ଚାଶତ୍ସେଟକମଗୁରୁଂ ଗୃହୀତ୍ୱାଗଚ୍ଛତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ତତସ୍ତେ ଯିହୂଦୀଯାନାଂ ଶ୍ମଶାନେ ସ୍ଥାପନରୀତ୍ୟନୁସାରେଣ ତତ୍ସୁଗନ୍ଧିଦ୍ରୱ୍ୟେଣ ସହିତଂ ତସ୍ୟ ଦେହଂ ୱସ୍ତ୍ରେଣାୱେଷ୍ଟଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","ଅପରଞ୍ଚ ଯତ୍ର ସ୍ଥାନେ ତଂ କ୍ରୁଶେଽୱିଧନ୍ ତସ୍ୟ ନିକଟସ୍ଥୋଦ୍ୟାନେ ଯତ୍ର କିମପି ମୃତଦେହଂ କଦାପି ନାସ୍ଥାପ୍ୟତ ତାଦୃଶମ୍ ଏକଂ ନୂତନଂ ଶ୍ମଶାନମ୍ ଆସୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","ଯିହୂଦୀଯାନାମ୍ ଆସାଦନଦିନାଗମନାତ୍ ତେ ତସ୍ମିନ୍ ସମୀପସ୍ଥଶ୍ମଶାନେ ଯୀଶୁମ୍ ଅଶାଯଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","ଅନନ୍ତରଂ ସପ୍ତାହସ୍ୟ ପ୍ରଥମଦିନେ ଽତିପ୍ରତ୍ୟୂଷେ ଽନ୍ଧକାରେ ତିଷ୍ଠତି ମଗ୍ଦଲୀନୀ ମରିଯମ୍ ତସ୍ୟ ଶ୍ମଶାନସ୍ୟ ନିକଟଂ ଗତ୍ୱା ଶ୍ମଶାନସ୍ୟ ମୁଖାତ୍ ପ୍ରସ୍ତରମପସାରିତମ୍ ଅପଶ୍ୟତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","ପଶ୍ଚାଦ୍ ଧାୱିତ୍ୱା ଶିମୋନ୍ପିତରାଯ ଯୀଶୋଃ ପ୍ରିଯତମଶିଷ୍ୟାଯ ଚେଦମ୍ ଅକଥଯତ୍, ଲୋକାଃ ଶ୍ମଶାନାତ୍ ପ୍ରଭୁଂ ନୀତ୍ୱା କୁତ୍ରାସ୍ଥାପଯନ୍ ତଦ୍ ୱକ୍ତୁଂ ନ ଶକ୍ନୋମି| ");
INSERT INTO sanori_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","ଅତଃ ପିତରଃ ସୋନ୍ୟଶିଷ୍ୟଶ୍ଚ ବର୍ହି ର୍ଭୁତ୍ୱା ଶ୍ମଶାନସ୍ଥାନଂ ଗନ୍ତୁମ୍ ଆରଭେତାଂ| ");
INSERT INTO sanori_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ଉଭଯୋର୍ଧାୱତୋଃ ସୋନ୍ୟଶିଷ୍ୟଃ ପିତରଂ ପଶ୍ଚାତ୍ ତ୍ୟକ୍ତ୍ୱା ପୂର୍ୱ୍ୱଂ ଶ୍ମଶାନସ୍ଥାନ ଉପସ୍ଥିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ତଦା ପ୍ରହ୍ୱୀଭୂଯ ସ୍ଥାପିତୱସ୍ତ୍ରାଣି ଦୃଷ୍ଟୱାନ୍ କିନ୍ତୁ ନ ପ୍ରାୱିଶତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","ଅପରଂ ଶିମୋନ୍ପିତର ଆଗତ୍ୟ ଶ୍ମଶାନସ୍ଥାନଂ ପ୍ରୱିଶ୍ୟ ");
INSERT INTO sanori_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ସ୍ଥାପିତୱସ୍ତ୍ରାଣି ମସ୍ତକସ୍ୟ ୱସ୍ତ୍ରଞ୍ଚ ପୃଥକ୍ ସ୍ଥାନାନ୍ତରେ ସ୍ଥାପିତଂ ଦୃଷ୍ଟୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","ତତଃ ଶ୍ମଶାନସ୍ଥାନଂ ପୂର୍ୱ୍ୱମ୍ ଆଗତୋ ଯୋନ୍ୟଶିଷ୍ୟଃ ସୋପି ପ୍ରୱିଶ୍ୟ ତାଦୃଶଂ ଦୃଷ୍ଟା ୱ୍ୟଶ୍ୱସୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","ଯତଃ ଶ୍ମଶାନାତ୍ ସ ଉତ୍ଥାପଯିତୱ୍ୟ ଏତସ୍ୟ ଧର୍ମ୍ମପୁସ୍ତକୱଚନସ୍ୟ ଭାୱଂ ତେ ତଦା ୱୋଦ୍ଧୁଂ ନାଶନ୍କୁୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","ଅନନ୍ତରଂ ତୌ ଦ୍ୱୌ ଶିଷ୍ୟୌ ସ୍ୱଂ ସ୍ୱଂ ଗୃହଂ ପରାୱୃତ୍ୟାଗଚ୍ଛତାମ୍| ");
INSERT INTO sanori_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","ତତଃ ପରଂ ମରିଯମ୍ ଶ୍ମଶାନଦ୍ୱାରସ୍ୟ ବହିଃ ସ୍ଥିତ୍ୱା ରୋଦିତୁମ୍ ଆରଭତ ତତୋ ରୁଦତୀ ପ୍ରହ୍ୱୀଭୂଯ ଶ୍ମଶାନଂ ୱିଲୋକ୍ୟ ");
INSERT INTO sanori_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ଯୀଶୋଃ ଶଯନସ୍ଥାନସ୍ୟ ଶିରଃସ୍ଥାନେ ପଦତଲେ ଚ ଦ୍ୱଯୋ ର୍ଦିଶୋ ଦ୍ୱୌ ସ୍ୱର୍ଗୀଯଦୂତାୱୁପୱିଷ୍ଟୌ ସମପଶ୍ୟତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","ତୌ ପୃଷ୍ଟୱନ୍ତୌ ହେ ନାରି କୁତୋ ରୋଦିଷି? ସାୱଦତ୍ ଲୋକା ମମ ପ୍ରଭୁଂ ନୀତ୍ୱା କୁତ୍ରାସ୍ଥାପଯନ୍ ଇତି ନ ଜାନାମି| ");
INSERT INTO sanori_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ଇତ୍ୟୁକ୍ତ୍ୱା ମୁଖଂ ପରାୱୃତ୍ୟ ଯୀଶୁଂ ଦଣ୍ଡାଯମାନମ୍ ଅପଶ୍ୟତ୍ କିନ୍ତୁ ସ ଯୀଶୁରିତି ସା ଜ୍ଞାତୁଂ ନାଶକ୍ନୋତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","ତଦା ଯୀଶୁସ୍ତାମ୍ ଅପୃଚ୍ଛତ୍ ହେ ନାରି କୁତୋ ରୋଦିଷି? କଂ ୱା ମୃଗଯସେ? ତତଃ ସା ତମ୍ ଉଦ୍ୟାନସେୱକଂ ଜ୍ଞାତ୍ୱା ୱ୍ୟାହରତ୍, ହେ ମହେଚ୍ଛ ତ୍ୱଂ ଯଦୀତଃ ସ୍ଥାନାତ୍ ତଂ ନୀତୱାନ୍ ତର୍ହି କୁତ୍ରାସ୍ଥାପଯସ୍ତଦ୍ ୱଦ ତତ୍ସ୍ଥାନାତ୍ ତମ୍ ଆନଯାମି| ");
INSERT INTO sanori_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","ତଦା ଯୀଶୁସ୍ତାମ୍ ଅୱଦତ୍ ହେ ମରିଯମ୍| ତତଃ ସା ପରାୱୃତ୍ୟ ପ୍ରତ୍ୟୱଦତ୍ ହେ ରବ୍ବୂନୀ ଅର୍ଥାତ୍ ହେ ଗୁରୋ| ");
INSERT INTO sanori_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","ତଦା ଯୀଶୁରୱଦତ୍ ମାଂ ମା ଧର, ଇଦାନୀଂ ପିତୁଃ ସମୀପେ ଊର୍ଦ୍ଧ୍ୱଗମନଂ ନ କରୋମି କିନ୍ତୁ ଯୋ ମମ ଯୁଷ୍ମାକଞ୍ଚ ପିତା ମମ ଯୁଷ୍ମାକଞ୍ଚେଶ୍ୱରସ୍ତସ୍ୟ ନିକଟ ଊର୍ଦ୍ଧ୍ୱଗମନଂ କର୍ତ୍ତୁମ୍ ଉଦ୍ୟତୋସ୍ମି, ଇମାଂ କଥାଂ ତ୍ୱଂ ଗତ୍ୱା ମମ ଭ୍ରାତୃଗଣଂ ଜ୍ଞାପଯ| ");
INSERT INTO sanori_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","ତତୋ ମଗ୍ଦଲୀନୀମରିଯମ୍ ତତ୍କ୍ଷଣାଦ୍ ଗତ୍ୱା ପ୍ରଭୁସ୍ତସ୍ୟୈ ଦର୍ଶନଂ ଦତ୍ତ୍ୱା କଥା ଏତା ଅକଥଯଦ୍ ଇତି ୱାର୍ତ୍ତାଂ ଶିଷ୍ୟେଭ୍ୟୋଽକଥଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ତତଃ ପରଂ ସପ୍ତାହସ୍ୟ ପ୍ରଥମଦିନସ୍ୟ ସନ୍ଧ୍ୟାସମଯେ ଶିଷ୍ୟା ଏକତ୍ର ମିଲିତ୍ୱା ଯିହୂଦୀଯେଭ୍ୟୋ ଭିଯା ଦ୍ୱାରରୁଦ୍ଧମ୍ ଅକୁର୍ୱ୍ୱନ୍, ଏତସ୍ମିନ୍ କାଲେ ଯୀଶୁସ୍ତେଷାଂ ମଧ୍ୟସ୍ଥାନେ ତିଷ୍ଠନ୍ ଅକଥଯଦ୍ ଯୁଷ୍ମାକଂ କଲ୍ୟାଣଂ ଭୂଯାତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ଇତ୍ୟୁକ୍ତ୍ୱା ନିଜହସ୍ତଂ କୁକ୍ଷିଞ୍ଚ ଦର୍ଶିତୱାନ୍, ତତଃ ଶିଷ୍ୟାଃ ପ୍ରଭୁଂ ଦୃଷ୍ଟ୍ୱା ହୃଷ୍ଟା ଅଭୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ଯୀଶୁଃ ପୁନରୱଦଦ୍ ଯୁଷ୍ମାକଂ କଲ୍ୟାଣଂ ଭୂଯାତ୍ ପିତା ଯଥା ମାଂ ପ୍ରୈଷଯତ୍ ତଥାହମପି ଯୁଷ୍ମାନ୍ ପ୍ରେଷଯାମି| ");
INSERT INTO sanori_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ଇତ୍ୟୁକ୍ତ୍ୱା ସ ତେଷାମୁପରି ଦୀର୍ଘପ୍ରଶ୍ୱାସଂ ଦତ୍ତ୍ୱା କଥିତୱାନ୍ ପୱିତ୍ରମ୍ ଆତ୍ମାନଂ ଗୃହ୍ଲୀତ| ");
INSERT INTO sanori_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","ଯୂଯଂ ଯେଷାଂ ପାପାନି ମୋଚଯିଷ୍ୟଥ ତେ ମୋଚଯିଷ୍ୟନ୍ତେ ଯେଷାଞ୍ଚ ପାପାତି ନ ମୋଚଯିଷ୍ୟଥ ତେ ନ ମୋଚଯିଷ୍ୟନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","ଦ୍ୱାଦଶମଧ୍ୟେ ଗଣିତୋ ଯମଜୋ ଥୋମାନାମା ଶିଷ୍ୟୋ ଯୀଶୋରାଗମନକାଲୈ ତୈଃ ସାର୍ଦ୍ଧଂ ନାସୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","ଅତୋ ୱଯଂ ପ୍ରଭୂମ୍ ଅପଶ୍ୟାମେତି ୱାକ୍ୟେଽନ୍ୟଶିଷ୍ୟୈରୁକ୍ତେ ସୋୱଦତ୍, ତସ୍ୟ ହସ୍ତଯୋ ର୍ଲୌହକୀଲକାନାଂ ଚିହ୍ନଂ ନ ୱିଲୋକ୍ୟ ତଚ୍ଚିହ୍ନମ୍ ଅଙ୍ଗୁଲ୍ୟା ନ ସ୍ପୃଷ୍ଟ୍ୱା ତସ୍ୟ କୁକ୍ଷୌ ହସ୍ତଂ ନାରୋପ୍ୟ ଚାହଂ ନ ୱିଶ୍ୱସିଷ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","ଅପରମ୍ ଅଷ୍ଟମେଽହ୍ନି ଗତେ ସତି ଥୋମାସହିତଃ ଶିଷ୍ୟଗଣ ଏକତ୍ର ମିଲିତ୍ୱା ଦ୍ୱାରଂ ରୁଦ୍ଧ୍ୱାଭ୍ୟନ୍ତର ଆସୀତ୍, ଏତର୍ହି ଯୀଶୁସ୍ତେଷାଂ ମଧ୍ୟସ୍ଥାନେ ତିଷ୍ଠନ୍ ଅକଥଯତ୍, ଯୁଷ୍ମାକଂ କୁଶଲଂ ଭୂଯାତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","ପଶ୍ଚାତ୍ ଥାମୈ କଥିତୱାନ୍ ତ୍ୱମ୍ ଅଙ୍ଗୁଲୀମ୍ ଅତ୍ରାର୍ପଯିତ୍ୱା ମମ କରୌ ପଶ୍ୟ କରଂ ପ୍ରସାର୍ୟ୍ୟ ମମ କୁକ୍ଷାୱର୍ପଯ ନାୱିଶ୍ୱସ୍ୟ| ");
INSERT INTO sanori_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ତଦା ଥୋମା ଅୱଦତ୍, ହେ ମମ ପ୍ରଭୋ ହେ ମଦୀଶ୍ୱର| ");
INSERT INTO sanori_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","ଯୀଶୁରକଥଯତ୍, ହେ ଥୋମା ମାଂ ନିରୀକ୍ଷ୍ୟ ୱିଶ୍ୱସିଷି ଯେ ନ ଦୃଷ୍ଟ୍ୱା ୱିଶ୍ୱସନ୍ତି ତଏୱ ଧନ୍ୟାଃ| ");
INSERT INTO sanori_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ଏତଦନ୍ୟାନି ପୁସ୍ତକେଽସ୍ମିନ୍ ଅଲିଖିତାନି ବହୂନ୍ୟାଶ୍ଚର୍ୟ୍ୟକର୍ମ୍ମାଣି ଯୀଶୁଃ ଶିଷ୍ୟାଣାଂ ପୁରସ୍ତାଦ୍ ଅକରୋତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","କିନ୍ତୁ ଯୀଶୁରୀଶ୍ୱରସ୍ୟାଭିଷିକ୍ତଃ ସୁତ ଏୱେତି ଯଥା ଯୂଯଂ ୱିଶ୍ୱସିଥ ୱିଶ୍ୱସ୍ୟ ଚ ତସ୍ୟ ନାମ୍ନା ପରମାଯୁଃ ପ୍ରାପ୍ନୁଥ ତଦର୍ଥମ୍ ଏତାନି ସର୍ୱ୍ୱାଣ୍ୟଲିଖ୍ୟନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","ତତଃ ପରଂ ତିବିରିଯାଜଲଧେସ୍ତଟେ ଯୀଶୁଃ ପୁନରପି ଶିଷ୍ୟେଭ୍ୟୋ ଦର୍ଶନଂ ଦତ୍ତୱାନ୍ ଦର୍ଶନସ୍ୟାଖ୍ୟାନମିଦମ୍| ");
INSERT INTO sanori_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ଶିମୋନ୍ପିତରଃ ଯମଜଥୋମା ଗାଲୀଲୀଯକାନ୍ନାନଗରନିୱାସୀ ନିଥନେଲ୍ ସିୱଦେଃ ପୁତ୍ରାୱନ୍ୟୌ ଦ୍ୱୌ ଶିଷ୍ୟୌ ଚୈତେଷ୍ୱେକତ୍ର ମିଲିତେଷୁ ଶିମୋନ୍ପିତରୋଽକଥଯତ୍ ମତ୍ସ୍ୟାନ୍ ଧର୍ତୁଂ ଯାମି| ");
INSERT INTO sanori_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ତତସ୍ତେ ୱ୍ୟାହରନ୍ ତର୍ହି ୱଯମପି ତ୍ୱଯା ସାର୍ଦ୍ଧଂ ଯାମଃ ତଦା ତେ ବହିର୍ଗତାଃ ସନ୍ତଃ କ୍ଷିପ୍ରଂ ନାୱମ୍ ଆରୋହନ୍ କିନ୍ତୁ ତସ୍ୟାଂ ରଜନ୍ୟାମ୍ ଏକମପି ନ ପ୍ରାପ୍ନୁୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","ପ୍ରଭାତେ ସତି ଯୀଶୁସ୍ତଟେ ସ୍ଥିତୱାନ୍ କିନ୍ତୁ ସ ଯୀଶୁରିତି ଶିଷ୍ୟା ଜ୍ଞାତୁଂ ନାଶକ୍ନୁୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","ତଦା ଯୀଶୁରପୃଚ୍ଛତ୍, ହେ ୱତ୍ସା ସନ୍ନିଧୌ କିଞ୍ଚିତ୍ ଖାଦ୍ୟଦ୍ରୱ୍ୟମ୍ ଆସ୍ତେ? ତେଽୱଦନ୍ କିମପି ନାସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ତଦା ସୋଽୱଦତ୍ ନୌକାଯା ଦକ୍ଷିଣପାର୍ଶ୍ୱେ ଜାଲଂ ନିକ୍ଷିପତ ତତୋ ଲପ୍ସ୍ୟଧ୍ୱେ, ତସ୍ମାତ୍ ତୈ ର୍ନିକ୍ଷିପ୍ତେ ଜାଲେ ମତ୍ସ୍ୟା ଏତାୱନ୍ତୋଽପତନ୍ ଯେନ ତେ ଜାଲମାକୃଷ୍ୟ ନୋତ୍ତୋଲଯିତୁଂ ଶକ୍ତାଃ| ");
INSERT INTO sanori_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","ତସ୍ମାଦ୍ ଯୀଶୋଃ ପ୍ରିଯତମଶିଷ୍ୟଃ ପିତରାଯାକଥଯତ୍ ଏଷ ପ୍ରଭୁ ର୍ଭୱେତ୍, ଏଷ ପ୍ରଭୁରିତି ୱାଚଂ ଶ୍ରୁତ୍ୱୈୱ ଶିମୋନ୍ ନଗ୍ନତାହେତୋ ର୍ମତ୍ସ୍ୟଧାରିଣ ଉତ୍ତରୀଯୱସ୍ତ୍ରଂ ପରିଧାଯ ହ୍ରଦଂ ପ୍ରତ୍ୟୁଦଲମ୍ଫଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","ଅପରେ ଶିଷ୍ୟା ମତ୍ସ୍ୟୈଃ ସାର୍ଦ୍ଧଂ ଜାଲମ୍ ଆକର୍ଷନ୍ତଃ କ୍ଷୁଦ୍ରନୌକାଂ ୱାହଯିତ୍ୱା କୂଲମାନଯନ୍ ତେ କୂଲାଦ୍ ଅତିଦୂରେ ନାସନ୍ ଦ୍ୱିଶତହସ୍ତେଭ୍ୟୋ ଦୂର ଆସନ୍ ଇତ୍ୟନୁମୀଯତେ| ");
INSERT INTO sanori_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","ତୀରଂ ପ୍ରାପ୍ତୈସ୍ତୈସ୍ତତ୍ର ପ୍ରଜ୍ୱଲିତାଗ୍ନିସ୍ତଦୁପରି ମତ୍ସ୍ୟାଃ ପୂପାଶ୍ଚ ଦୃଷ୍ଟାଃ| ");
INSERT INTO sanori_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ତତୋ ଯୀଶୁରକଥଯଦ୍ ଯାନ୍ ମତ୍ସ୍ୟାନ୍ ଅଧରତ ତେଷାଂ କତିପଯାନ୍ ଆନଯତ| ");
INSERT INTO sanori_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ଅତଃ ଶିମୋନ୍ପିତରଃ ପରାୱୃତ୍ୟ ଗତ୍ୱା ବୃହଦ୍ଭିସ୍ତ୍ରିପଞ୍ଚାଶଦଧିକଶତମତ୍ସ୍ୟୈଃ ପରିପୂର୍ଣଂ ତଜ୍ଜାଲମ୍ ଆକୃଷ୍ୟୋଦତୋଲଯତ୍ କିନ୍ତ୍ୱେତାୱଦ୍ଭି ର୍ମତ୍ସ୍ୟୈରପି ଜାଲଂ ନାଛିଦ୍ୟତ| ");
INSERT INTO sanori_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","ଅନନ୍ତରଂ ଯୀଶୁସ୍ତାନ୍ ଅୱାଦୀତ୍ ଯୂଯମାଗତ୍ୟ ଭୁଂଗ୍ଧ୍ୱଂ; ତଦା ସଏୱ ପ୍ରଭୁରିତି ଜ୍ଞାତତ୍ୱାତ୍ ତ୍ୱଂ କଃ? ଇତି ପ୍ରଷ୍ଟୁଂ ଶିଷ୍ୟାଣାଂ କସ୍ୟାପି ପ୍ରଗଲ୍ଭତା ନାଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ତତୋ ଯୀଶୁରାଗତ୍ୟ ପୂପାନ୍ ମତ୍ସ୍ୟାଂଶ୍ଚ ଗୃହୀତ୍ୱା ତେଭ୍ୟଃ ପର୍ୟ୍ୟୱେଷଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ଇତ୍ଥଂ ଶ୍ମଶାନାଦୁତ୍ଥାନାତ୍ ପରଂ ଯୀଶୁଃ ଶିଷ୍ୟେଭ୍ୟସ୍ତୃତୀଯୱାରଂ ଦର୍ଶନଂ ଦତ୍ତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ଭୋଜନେ ସମାପ୍ତେ ସତି ଯୀଶୁଃ ଶିମୋନ୍ପିତରଂ ପୃଷ୍ଟୱାନ୍, ହେ ଯୂନସଃ ପୁତ୍ର ଶିମୋନ୍ ତ୍ୱଂ କିମ୍ ଏତେଭ୍ୟୋଧିକଂ ମଯି ପ୍ରୀଯସେ? ତତଃ ସ ଉଦିତୱାନ୍ ସତ୍ୟଂ ପ୍ରଭୋ ତ୍ୱଯି ପ୍ରୀଯେଽହଂ ତଦ୍ ଭୱାନ୍ ଜାନାତି; ତଦା ଯୀଶୁରକଥଯତ୍ ତର୍ହି ମମ ମେଷଶାୱକଗଣଂ ପାଲଯ| ");
INSERT INTO sanori_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ତତଃ ସ ଦ୍ୱିତୀଯୱାରଂ ପୃଷ୍ଟୱାନ୍ ହେ ଯୂନସଃ ପୁତ୍ର ଶିମୋନ୍ ତ୍ୱଂ କିଂ ମଯି ପ୍ରୀଯସେ? ତତଃ ସ ଉକ୍ତୱାନ୍ ସତ୍ୟଂ ପ୍ରଭୋ ତ୍ୱଯି ପ୍ରୀଯେଽହଂ ତଦ୍ ଭୱାନ୍ ଜାନାତି; ତଦା ଯୀଶୁରକଥଯତ ତର୍ହି ମମ ମେଷଗଣଂ ପାଲଯ| ");
INSERT INTO sanori_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ପଶ୍ଚାତ୍ ସ ତୃତୀଯୱାରଂ ପୃଷ୍ଟୱାନ୍, ହେ ଯୂନସଃ ପୁତ୍ର ଶିମୋନ୍ ତ୍ୱଂ କିଂ ମଯି ପ୍ରୀଯସେ? ଏତଦ୍ୱାକ୍ୟଂ ତୃତୀଯୱାରଂ ପୃଷ୍ଟୱାନ୍ ତସ୍ମାତ୍ ପିତରୋ ଦୁଃଖିତୋ ଭୂତ୍ୱାଽକଥଯତ୍ ହେ ପ୍ରଭୋ ଭୱତଃ କିମପ୍ୟଗୋଚରଂ ନାସ୍ତି ତ୍ୱଯ୍ୟହଂ ପ୍ରୀଯେ ତଦ୍ ଭୱାନ୍ ଜାନାତି; ତତୋ ଯୀଶୁରୱଦତ୍ ତର୍ହି ମମ ମେଷଗଣଂ ପାଲଯ| ");
INSERT INTO sanori_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","ଅହଂ ତୁଭ୍ୟଂ ଯଥାର୍ଥଂ କଥଯାମି ଯୌୱନକାଲେ ସ୍ୱଯଂ ବଦ୍ଧକଟି ର୍ୟତ୍ରେଚ୍ଛା ତତ୍ର ଯାତୱାନ୍ କିନ୍ତ୍ୱିତଃ ପରଂ ୱୃଦ୍ଧେ ୱଯସି ହସ୍ତଂ ୱିସ୍ତାରଯିଷ୍ୟସି, ଅନ୍ୟଜନସ୍ତ୍ୱାଂ ବଦ୍ଧ୍ୱା ଯତ୍ର ଗନ୍ତୁଂ ତୱେଚ୍ଛା ନ ଭୱତି ତ୍ୱାଂ ଧୃତ୍ୱା ତତ୍ର ନେଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ଫଲତଃ କୀଦୃଶେନ ମରଣେନ ସ ଈଶ୍ୱରସ୍ୟ ମହିମାନଂ ପ୍ରକାଶଯିଷ୍ୟତି ତଦ୍ ବୋଧଯିତୁଂ ସ ଇତି ୱାକ୍ୟଂ ପ୍ରୋକ୍ତୱାନ୍| ଇତ୍ୟୁକ୍ତେ ସତି ସ ତମୱୋଚତ୍ ମମ ପଶ୍ଚାଦ୍ ଆଗଚ୍ଛ| ");
INSERT INTO sanori_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","ଯୋ ଜନୋ ରାତ୍ରିକାଲେ ଯୀଶୋ ର୍ୱକ୍ଷୋଽୱଲମ୍ବ୍ୟ, ହେ ପ୍ରଭୋ କୋ ଭୱନ୍ତଂ ପରକରେଷୁ ସମର୍ପଯିଷ୍ୟତୀତି ୱାକ୍ୟଂ ପୃଷ୍ଟୱାନ୍, ତଂ ଯୀଶୋଃ ପ୍ରିଯତମଶିଷ୍ୟଂ ପଶ୍ଚାଦ୍ ଆଗଚ୍ଛନ୍ତଂ ");
INSERT INTO sanori_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ପିତରୋ ମୁଖଂ ପରାୱର୍ତ୍ତ୍ୟ ୱିଲୋକ୍ୟ ଯୀଶୁଂ ପୃଷ୍ଟୱାନ୍, ହେ ପ୍ରଭୋ ଏତସ୍ୟ ମାନୱସ୍ୟ କୀଦୃଶୀ ଗତି ର୍ଭୱିଷ୍ୟତି? ");
INSERT INTO sanori_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","ସ ପ୍ରତ୍ୟୱଦତ୍, ମମ ପୁନରାଗମନପର୍ୟ୍ୟନ୍ତଂ ଯଦି ତଂ ସ୍ଥାପଯିତୁମ୍ ଇଚ୍ଛାମି ତତ୍ର ତୱ କିଂ? ତ୍ୱଂ ମମ ପଶ୍ଚାଦ୍ ଆଗଚ୍ଛ| ");
INSERT INTO sanori_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","ତସ୍ମାତ୍ ସ ଶିଷ୍ୟୋ ନ ମରିଷ୍ୟତୀତି ଭ୍ରାତୃଗଣମଧ୍ୟେ କିଂୱଦନ୍ତୀ ଜାତା କିନ୍ତୁ ସ ନ ମରିଷ୍ୟତୀତି ୱାକ୍ୟଂ ଯୀଶୁ ର୍ନାୱଦତ୍ କେୱଲଂ ମମ ପୁନରାଗମନପର୍ୟ୍ୟନ୍ତଂ ଯଦି ତଂ ସ୍ଥାପଯିତୁମ୍ ଇଚ୍ଛାମି ତତ୍ର ତୱ କିଂ? ଇତି ୱାକ୍ୟମ୍ ଉକ୍ତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","ଯୋ ଜନ ଏତାନି ସର୍ୱ୍ୱାଣି ଲିଖିତୱାନ୍ ଅତ୍ର ସାକ୍ଷ୍ୟଞ୍ଚ ଦତ୍ତୱାନ୍ ସଏୱ ସ ଶିଷ୍ୟଃ, ତସ୍ୟ ସାକ୍ଷ୍ୟଂ ପ୍ରମାଣମିତି ୱଯଂ ଜାନୀମଃ| ");
INSERT INTO sanori_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","ଯୀଶୁରେତେଭ୍ୟୋଽପରାଣ୍ୟପି ବହୂନି କର୍ମ୍ମାଣି କୃତୱାନ୍ ତାନି ସର୍ୱ୍ୱାଣି ଯଦ୍ୟେକୈକଂ କୃତ୍ୱା ଲିଖ୍ୟନ୍ତେ ତର୍ହି ଗ୍ରନ୍ଥା ଏତାୱନ୍ତୋ ଭୱନ୍ତି ତେଷାଂ ଧାରଣେ ପୃଥିୱ୍ୟାଂ ସ୍ଥାନଂ ନ ଭୱତି| ଇତି||");
INSERT INTO sanori_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","ହେ ଥିଯଫିଲ, ଯୀଶୁଃ ସ୍ୱମନୋନୀତାନ୍ ପ୍ରେରିତାନ୍ ପୱିତ୍ରେଣାତ୍ମନା ସମାଦିଶ୍ୟ ଯସ୍ମିନ୍ ଦିନେ ସ୍ୱର୍ଗମାରୋହତ୍ ଯାଂ ଯାଂ କ୍ରିଯାମକରୋତ୍ ଯଦ୍ୟଦ୍ ଉପାଦିଶଚ୍ଚ ତାନି ସର୍ୱ୍ୱାଣି ପୂର୍ୱ୍ୱଂ ମଯା ଲିଖିତାନି| ");
INSERT INTO sanori_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ସ ସ୍ୱନିଧନଦୁଃଖଭୋଗାତ୍ ପରମ୍ ଅନେକପ୍ରତ୍ୟଯକ୍ଷପ୍ରମାଣୌଃ ସ୍ୱଂ ସଜୀୱଂ ଦର୍ଶଯିତ୍ୱା ");
INSERT INTO sanori_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ଚତ୍ୱାରିଂଶଦ୍ଦିନାନି ଯାୱତ୍ ତେଭ୍ୟଃ ପ୍ରେରିତେଭ୍ୟୋ ଦର୍ଶନଂ ଦତ୍ତ୍ୱେଶ୍ୱରୀଯରାଜ୍ୟସ୍ୟ ୱର୍ଣନମ ଅକରୋତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","ଅନନ୍ତରଂ ତେଷାଂ ସଭାଂ କୃତ୍ୱା ଇତ୍ୟାଜ୍ଞାପଯତ୍, ଯୂଯଂ ଯିରୂଶାଲମୋଽନ୍ୟତ୍ର ଗମନମକୃତ୍ୱା ଯସ୍ତିନ୍ ପିତ୍ରାଙ୍ଗୀକୃତେ ମମ ୱଦନାତ୍ କଥା ଅଶୃଣୁତ ତତ୍ପ୍ରାପ୍ତିମ୍ ଅପେକ୍ଷ୍ୟ ତିଷ୍ଠତ| ");
INSERT INTO sanori_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","ଯୋହନ୍ ଜଲେ ମଜ୍ଜିତାୱାନ୍ କିନ୍ତ୍ୱଲ୍ପଦିନମଧ୍ୟେ ଯୂଯଂ ପୱିତ୍ର ଆତ୍ମନି ମଜ୍ଜିତା ଭୱିଷ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","ପଶ୍ଚାତ୍ ତେ ସର୍ୱ୍ୱେ ମିଲିତ୍ୱା ତମ୍ ଅପୃଚ୍ଛନ୍ ହେ ପ୍ରଭୋ ଭୱାନ୍ କିମିଦାନୀଂ ପୁନରପି ରାଜ୍ୟମ୍ ଇସ୍ରାଯେଲୀଯଲୋକାନାଂ କରେଷୁ ସମର୍ପଯିଷ୍ୟତି? ");
INSERT INTO sanori_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ତତଃ ସୋୱଦତ୍ ଯାନ୍ ସର୍ୱ୍ୱାନ୍ କାଲାନ୍ ସମଯାଂଶ୍ଚ ପିତା ସ୍ୱୱଶେଽସ୍ଥାପଯତ୍ ତାନ୍ ଜ୍ଞାତୃଂ ଯୁଷ୍ମାକମ୍ ଅଧିକାରୋ ନ ଜାଯତେ| ");
INSERT INTO sanori_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","କିନ୍ତୁ ଯୁଷ୍ମାସୁ ପୱିତ୍ରସ୍ୟାତ୍ମନ ଆୱିର୍ଭାୱେ ସତି ଯୂଯଂ ଶକ୍ତିଂ ପ୍ରାପ୍ୟ ଯିରୂଶାଲମି ସମସ୍ତଯିହୂଦାଶୋମିରୋଣଦେଶଯୋଃ ପୃଥିୱ୍ୟାଃ ସୀମାଂ ଯାୱଦ୍ ଯାୱନ୍ତୋ ଦେଶାସ୍ତେଷୁ ଯର୍ୱ୍ୱେଷୁ ଚ ମଯି ସାକ୍ଷ୍ୟଂ ଦାସ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ଇତି ୱାକ୍ୟମୁକ୍ତ୍ୱା ସ ତେଷାଂ ସମକ୍ଷଂ ସ୍ୱର୍ଗଂ ନୀତୋଽଭୱତ୍, ତତୋ ମେଘମାରୁହ୍ୟ ତେଷାଂ ଦୃଷ୍ଟେରଗୋଚରୋଽଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ଯସ୍ମିନ୍ ସମଯେ ତେ ୱିହାଯସଂ ପ୍ରତ୍ୟନନ୍ୟଦୃଷ୍ଟ୍ୟା ତସ୍ୟ ତାଦୃଶମ୍ ଊର୍ଦ୍ୱ୍ୱଗମନମ୍ ଅପଶ୍ୟନ୍ ତସ୍ମିନ୍ନେୱ ସମଯେ ଶୁକ୍ଲୱସ୍ତ୍ରୌ ଦ୍ୱୌ ଜନୌ ତେଷାଂ ସନ୍ନିଧୌ ଦଣ୍ଡାଯମାନୌ କଥିତୱନ୍ତୌ, ");
INSERT INTO sanori_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ହେ ଗାଲୀଲୀଯଲୋକା ଯୂଯଂ କିମର୍ଥଂ ଗଗଣଂ ପ୍ରତି ନିରୀକ୍ଷ୍ୟ ଦଣ୍ଡାଯମାନାସ୍ତିଷ୍ଠଥ? ଯୁଷ୍ମାକଂ ସମୀପାତ୍ ସ୍ୱର୍ଗଂ ନୀତୋ ଯୋ ଯୀଶୁସ୍ତଂ ଯୂଯଂ ଯଥା ସ୍ୱର୍ଗମ୍ ଆରୋହନ୍ତମ୍ ଅଦର୍ଶମ୍ ତଥା ସ ପୁନଶ୍ଚାଗମିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ତତଃ ପରଂ ତେ ଜୈତୁନନାମ୍ନଃ ପର୍ୱ୍ୱତାଦ୍ ୱିଶ୍ରାମୱାରସ୍ୟ ପଥଃ ପରିମାଣମ୍ ଅର୍ଥାତ୍ ପ୍ରାଯେଣାର୍ଦ୍ଧକ୍ରୋଶଂ ଦୁରସ୍ଥଂ ଯିରୂଶାଲମ୍ନଗରଂ ପରାୱୃତ୍ୟାଗଚ୍ଛନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","ନଗରଂ ପ୍ରୱିଶ୍ୟ ପିତରୋ ଯାକୂବ୍ ଯୋହନ୍ ଆନ୍ଦ୍ରିଯଃ ଫିଲିପଃ ଥୋମା ବର୍ଥଜମଯୋ ମଥିରାଲ୍ଫୀଯପୁତ୍ରୋ ଯାକୂବ୍ ଉଦ୍ୟୋଗାी ଶିମୋନ୍ ଯାକୂବୋ ଭ୍ରାତା ଯିହୂଦା ଏତେ ସର୍ୱ୍ୱେ ଯତ୍ର ସ୍ଥାନେ ପ୍ରୱସନ୍ତି ତସ୍ମିନ୍ ଉପରିତନପ୍ରକୋଷ୍ଠେ ପ୍ରାୱିଶନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ପଶ୍ଚାଦ୍ ଇମେ କିଯତ୍ୟଃ ସ୍ତ୍ରିଯଶ୍ଚ ଯୀଶୋ ର୍ମାତା ମରିଯମ୍ ତସ୍ୟ ଭ୍ରାତରଶ୍ଚୈତେ ସର୍ୱ୍ୱ ଏକଚିତ୍ତୀଭୂତ ସତତଂ ୱିନଯେନ ୱିନଯେନ ପ୍ରାର୍ଥଯନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","ତସ୍ମିନ୍ ସମଯେ ତତ୍ର ସ୍ଥାନେ ସାକଲ୍ୟେନ ୱିଂଶତ୍ୟଧିକଶତଂ ଶିଷ୍ୟା ଆସନ୍| ତତଃ ପିତରସ୍ତେଷାଂ ମଧ୍ୟେ ତିଷ୍ଠନ୍ ଉକ୍ତୱାନ୍ ");
INSERT INTO sanori_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","ହେ ଭ୍ରାତୃଗଣ ଯୀଶୁଧାରିଣାଂ ଲୋକାନାଂ ପଥଦର୍ଶକୋ ଯୋ ଯିହୂଦାସ୍ତସ୍ମିନ୍ ଦାଯୂଦା ପୱିତ୍ର ଆତ୍ମା ଯାଂ କଥାଂ କଥଯାମାସ ତସ୍ୟାଃ ପ୍ରତ୍ୟକ୍ଷୀଭୱନସ୍ୟାୱଶ୍ୟକତ୍ୱମ୍ ଆସୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ସ ଜନୋଽସ୍ମାକଂ ମଧ୍ୟୱର୍ତ୍ତୀ ସନ୍ ଅସ୍ୟାଃ ସେୱାଯା ଅଂଶମ୍ ଅଲଭତ| ");
INSERT INTO sanori_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","ତଦନନ୍ତରଂ କୁକର୍ମ୍ମଣା ଲବ୍ଧଂ ଯନ୍ମୂଲ୍ୟଂ ତେନ କ୍ଷେତ୍ରମେକଂ କ୍ରୀତମ୍ ଅପରଂ ତସ୍ମିନ୍ ଅଧୋମୁଖେ ଭୃମୌ ପତିତେ ସତି ତସ୍ୟୋଦରସ୍ୟ ୱିଦୀର୍ଣତ୍ୱାତ୍ ସର୍ୱ୍ୱା ନାଡ୍ୟୋ ନିରଗଚ୍ଛନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ଏତାଂ କଥାଂ ଯିରୂଶାଲମ୍ନିୱାସିନଃ ସର୍ୱ୍ୱେ ଲୋକା ୱିଦାନ୍ତି; ତେଷାଂ ନିଜଭାଷଯା ତତ୍କ୍ଷେତ୍ରଞ୍ଚ ହକଲ୍ଦାମା, ଅର୍ଥାତ୍ ରକ୍ତକ୍ଷେତ୍ରମିତି ୱିଖ୍ୟାତମାସ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","ଅନ୍ୟଚ୍ଚ, ନିକେତନଂ ତଦୀଯନ୍ତୁ ଶୁନ୍ୟମେୱ ଭୱିଷ୍ୟତି| ତସ୍ୟ ଦୂଷ୍ୟେ ନିୱାସାର୍ଥଂ କୋପି ସ୍ଥାସ୍ୟତି ନୈୱ ହି| ଅନ୍ୟ ଏୱ ଜନସ୍ତସ୍ୟ ପଦଂ ସଂପ୍ରାପ୍ସ୍ୟତି ଧ୍ରୁୱଂ| ଇତ୍ଥଂ ଗୀତପୁସ୍ତକେ ଲିଖିତମାସ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","ଅତୋ ଯୋହନୋ ମଜ୍ଜନମ୍ ଆରଭ୍ୟାସ୍ମାକଂ ସମୀପାତ୍ ପ୍ରଭୋ ର୍ୟୀଶୋଃ ସ୍ୱର୍ଗାରୋହଣଦିନଂ ଯାୱତ୍ ସୋସ୍ମାକଂ ମଧ୍ୟେ ଯାୱନ୍ତି ଦିନାନି ଯାପିତୱାନ୍ ");
INSERT INTO sanori_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ତାୱନ୍ତି ଦିନାନି ଯେ ମାନୱା ଅସ୍ମାଭିଃ ସାର୍ଦ୍ଧଂ ତିଷ୍ଠନ୍ତି ତେଷାମ୍ ଏକେନ ଜନେନାସ୍ମାଭିଃ ସାର୍ଦ୍ଧଂ ଯୀଶୋରୁତ୍ଥାନେ ସାକ୍ଷିଣା ଭୱିତୱ୍ୟଂ| ");
INSERT INTO sanori_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","ଅତୋ ଯସ୍ୟ ରୂଢି ର୍ୟୁଷ୍ଟୋ ଯଂ ବର୍ଶବ୍ବେତ୍ୟୁକ୍ତ୍ୱାହୂଯନ୍ତି ସ ଯୂଷଫ୍ ମତଥିଶ୍ଚ ଦ୍ୱାୱେତୌ ପୃଥକ୍ କୃତ୍ୱା ତ ଈଶ୍ୱରସ୍ୟ ସନ୍ନିଧୌ ପ୍ରାର୍ୟ୍ୟ କଥିତୱନ୍ତଃ, ");
INSERT INTO sanori_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","ହେ ସର୍ୱ୍ୱାନ୍ତର୍ୟ୍ୟାମିନ୍ ପରମେଶ୍ୱର, ଯିହୂଦାଃ ସେୱନପ୍ରେରିତତ୍ୱପଦଚ୍ୟୁତଃ ");
INSERT INTO sanori_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ସନ୍ ନିଜସ୍ଥାନମ୍ ଅଗଚ୍ଛତ୍, ତତ୍ପଦଂ ଲବ୍ଧୁମ୍ ଏନଯୋ ର୍ଜନଯୋ ର୍ମଧ୍ୟେ ଭୱତା କୋଽଭିରୁଚିତସ୍ତଦସ୍ମାନ୍ ଦର୍ଶ୍ୟତାଂ| ");
INSERT INTO sanori_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ତତୋ ଗୁଟିକାପାଟେ କୃତେ ମତଥିର୍ନିରଚୀଯତ ତସ୍ମାତ୍ ସୋନ୍ୟେଷାମ୍ ଏକାଦଶାନାଂ ପ୍ରରିତାନାଂ ମଧ୍ୟେ ଗଣିତୋଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","ଅପରଞ୍ଚ ନିସ୍ତାରୋତ୍ସୱାତ୍ ପରଂ ପଞ୍ଚାଶତ୍ତମେ ଦିନେ ସମୁପସ୍ଥିତେ ସତି ତେ ସର୍ୱ୍ୱେ ଏକାଚିତ୍ତୀଭୂଯ ସ୍ଥାନ ଏକସ୍ମିନ୍ ମିଲିତା ଆସନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ଏତସ୍ମିନ୍ନେୱ ସମଯେଽକସ୍ମାଦ୍ ଆକାଶାତ୍ ପ୍ରଚଣ୍ଡାତ୍ୟୁଗ୍ରୱାଯୋଃ ଶବ୍ଦୱଦ୍ ଏକଃ ଶବ୍ଦ ଆଗତ୍ୟ ଯସ୍ମିନ୍ ଗୃହେ ତ ଉପାୱିଶନ୍ ତଦ୍ ଗୃହଂ ସମସ୍ତଂ ୱ୍ୟାପ୍ନୋତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ତତଃ ପରଂ ୱହ୍ନିଶିଖାସ୍ୱରୂପା ଜିହ୍ୱାଃ ପ୍ରତ୍ୟକ୍ଷୀଭୂଯ ୱିଭକ୍ତାଃ ସତ୍ୟଃ ପ୍ରତିଜନୋର୍ଦ୍ଧ୍ୱେ ସ୍ଥଗିତା ଅଭୂୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","ତସ୍ମାତ୍ ସର୍ୱ୍ୱେ ପୱିତ୍ରେଣାତ୍ମନା ପରିପୂର୍ଣାଃ ସନ୍ତ ଆତ୍ମା ଯଥା ୱାଚିତୱାନ୍ ତଦନୁସାରେଣାନ୍ୟଦେଶୀଯାନାଂ ଭାଷା ଉକ୍ତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","ତସ୍ମିନ୍ ସମଯେ ପୃଥିୱୀସ୍ଥସର୍ୱ୍ୱଦେଶେଭ୍ୟୋ ଯିହୂଦୀଯମତାୱଲମ୍ବିନୋ ଭକ୍ତଲୋକା ଯିରୂଶାଲମି ପ୍ରାୱସନ୍; ");
INSERT INTO sanori_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ତସ୍ୟାଃ କଥାଯାଃ କିଂୱଦନ୍ତ୍ୟା ଜାତତ୍ୱାତ୍ ସର୍ୱ୍ୱେ ଲୋକା ମିଲିତ୍ୱା ନିଜନିଜଭାଷଯା ଶିଷ୍ୟାଣାଂ କଥାକଥନଂ ଶ୍ରୁତ୍ୱା ସମୁଦ୍ୱିଗ୍ନା ଅଭୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ସର୍ୱ୍ୱଏୱ ୱିସ୍ମଯାପନ୍ନା ଆଶ୍ଚର୍ୟ୍ୟାନ୍ୱିତାଶ୍ଚ ସନ୍ତଃ ପରସ୍ପରଂ ଉକ୍ତୱନ୍ତଃ ପଶ୍ୟତ ଯେ କଥାଂ କଥଯନ୍ତି ତେ ସର୍ୱ୍ୱେ ଗାଲୀଲୀଯଲୋକାଃ କିଂ ନ ଭୱନ୍ତି? ");
INSERT INTO sanori_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ତର୍ହି ୱଯଂ ପ୍ରତ୍ୟେକଶଃ ସ୍ୱସ୍ୱଜନ୍ମଦେଶୀଯଭାଷାଭିଃ କଥା ଏତେଷାଂ ଶୃଣୁମଃ କିମିଦଂ? ");
INSERT INTO sanori_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","ପାର୍ଥୀ-ମାଦୀ-ଅରାମ୍ନହରଯିମ୍ଦେଶନିୱାସିମନୋ ଯିହୂଦା-କପ୍ପଦକିଯା-ପନ୍ତ-ଆଶିଯା- ");
INSERT INTO sanori_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ଫ୍ରୁଗିଯା-ପମ୍ଫୁଲିଯା-ମିସରନିୱାସିନଃ କୁରୀଣୀନିକଟୱର୍ତ୍ତିଲୂବୀଯପ୍ରଦେଶନିୱାସିନୋ ରୋମନଗରାଦ୍ ଆଗତା ଯିହୂଦୀଯଲୋକା ଯିହୂଦୀଯମତଗ୍ରାହିଣଃ କ୍ରୀତୀଯା ଅରାବୀଯାଦଯୋ ଲୋକାଶ୍ଚ ଯେ ୱଯମ୍ ");
INSERT INTO sanori_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ଅସ୍ମାକଂ ନିଜନିଜଭାଷାଭିରେତେଷାମ୍ ଈଶ୍ୱରୀଯମହାକର୍ମ୍ମୱ୍ୟାଖ୍ୟାନଂ ଶୃଣୁମଃ| ");
INSERT INTO sanori_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ଇତ୍ଥଂ ତେ ସର୍ୱ୍ୱଏୱ ୱିସ୍ମଯାପନ୍ନାଃ ସନ୍ଦିଗ୍ଧଚିତ୍ତାଃ ସନ୍ତଃ ପରସ୍ପରମୂଚୁଃ, ଅସ୍ୟ କୋ ଭାୱଃ? ");
INSERT INTO sanori_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","ଅପରେ କେଚିତ୍ ପରିହସ୍ୟ କଥିତୱନ୍ତ ଏତେ ନୱୀନଦ୍ରାକ୍ଷାରସେନ ମତ୍ତା ଅଭୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","ତଦା ପିତର ଏକାଦଶଭି ର୍ଜନୈଃ ସାକଂ ତିଷ୍ଠନ୍ ତାଲ୍ଲୋକାନ୍ ଉଚ୍ଚୈଃକାରମ୍ ଅୱଦତ୍, ହେ ଯିହୂଦୀଯା ହେ ଯିରୂଶାଲମ୍ନିୱାସିନଃ ସର୍ୱ୍ୱେ, ଅୱଧାନଂ କୃତ୍ୱା ମଦୀଯୱାକ୍ୟଂ ବୁଧ୍ୟଧ୍ୱଂ| ");
INSERT INTO sanori_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ଇଦାନୀମ୍ ଏକଯାମାଦ୍ ଅଧିକା ୱେଲା ନାସ୍ତି ତସ୍ମାଦ୍ ଯୂଯଂ ଯଦ୍ ଅନୁମାଥ ମାନୱା ଇମେ ମଦ୍ୟପାନେନ ମତ୍ତାସ୍ତନ୍ନ| ");
INSERT INTO sanori_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","କିନ୍ତୁ ଯୋଯେଲ୍ଭୱିଷ୍ୟଦ୍ୱକ୍ତ୍ରୈତଦ୍ୱାକ୍ୟମୁକ୍ତଂ ଯଥା, ");
INSERT INTO sanori_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","ଈଶ୍ୱରଃ କଥଯାମାସ ଯୁଗାନ୍ତସମଯେ ତ୍ୱହମ୍| ୱର୍ଷିଷ୍ୟାମି ସ୍ୱମାତ୍ମାନଂ ସର୍ୱ୍ୱପ୍ରାଣ୍ୟୁପରି ଧ୍ରୁୱମ୍| ଭାୱିୱାକ୍ୟଂ ୱଦିଷ୍ୟନ୍ତି କନ୍ୟାଃ ପୁତ୍ରାଶ୍ଚ ୱସ୍ତୁତଃ| ପ୍ରତ୍ୟାଦେଶଞ୍ଚ ପ୍ରାପ୍ସ୍ୟନ୍ତି ଯୁଷ୍ମାକଂ ଯୁୱମାନୱାଃ| ତଥା ପ୍ରାଚୀନଲୋକାସ୍ତୁ ସ୍ୱପ୍ନାନ୍ ଦ୍ରକ୍ଷ୍ୟନ୍ତି ନିଶ୍ଚିତଂ| ");
INSERT INTO sanori_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","ୱର୍ଷିଷ୍ୟାମି ତଦାତ୍ମାନଂ ଦାସଦାସୀଜନୋପିରି| ତେନୈୱ ଭାୱିୱାକ୍ୟଂ ତେ ୱଦିଷ୍ୟନ୍ତି ହି ସର୍ୱ୍ୱଶଃ| ");
INSERT INTO sanori_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ଊର୍ଦ୍ଧ୍ୱସ୍ଥେ ଗଗଣେ ଚୈୱ ନୀଚସ୍ଥେ ପୃଥିୱୀତଲେ| ଶୋଣିତାନି ବୃହଦ୍ଭାନୂନ୍ ଘନଧୂମାଦିକାନି ଚ| ଚିହ୍ନାନି ଦର୍ଶଯିଷ୍ୟାମି ମହାଶ୍ଚର୍ୟ୍ୟକ୍ରିଯାସ୍ତଥା| ");
INSERT INTO sanori_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","ମହାଭଯାନକସ୍ୟୈୱ ତଦ୍ଦିନସ୍ୟ ପରେଶିତୁଃ| ପୁରାଗମାଦ୍ ରୱିଃ କୃଷ୍ଣୋ ରକ୍ତଶ୍ଚନ୍ଦ୍ରୋ ଭୱିଷ୍ୟତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","କିନ୍ତୁ ଯଃ ପରମେଶସ୍ୟ ନାମ୍ନି ସମ୍ପ୍ରାର୍ଥଯିଷ୍ୟତେ| ସଏୱ ମନୁଜୋ ନୂନଂ ପରିତ୍ରାତୋ ଭୱିଷ୍ୟତି|| ");
INSERT INTO sanori_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","ଅତୋ ହେ ଇସ୍ରାଯେଲ୍ୱଂଶୀଯଲୋକାଃ ସର୍ୱ୍ୱେ କଥାଯାମେତସ୍ୟାମ୍ ମନୋ ନିଧଦ୍ଧ୍ୱଂ ନାସରତୀଯୋ ଯୀଶୁରୀଶ୍ୱରସ୍ୟ ମନୋନୀତଃ ପୁମାନ୍ ଏତଦ୍ ଈଶ୍ୱରସ୍ତତ୍କୃତୈରାଶ୍ଚର୍ୟ୍ୟାଦ୍ଭୁତକର୍ମ୍ମଭି ର୍ଲକ୍ଷଣୈଶ୍ଚ ଯୁଷ୍ମାକଂ ସାକ୍ଷାଦେୱ ପ୍ରତିପାଦିତୱାନ୍ ଇତି ଯୂଯଂ ଜାନୀଥ| ");
INSERT INTO sanori_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","ତସ୍ମିନ୍ ଯୀଶୌ ଈଶ୍ୱରସ୍ୟ ପୂର୍ୱ୍ୱନିଶ୍ଚିତମନ୍ତ୍ରଣାନିରୂପଣାନୁସାରେଣ ମୃତ୍ୟୌ ସମର୍ପିତେ ସତି ଯୂଯଂ ତଂ ଧୃତ୍ୱା ଦୁଷ୍ଟଲୋକାନାଂ ହସ୍ତୈଃ କ୍ରୁଶେ ୱିଧିତ୍ୱାହତ| ");
INSERT INTO sanori_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","କିନ୍ତ୍ୱୀଶ୍ୱରସ୍ତଂ ନିଧନସ୍ୟ ବନ୍ଧନାନ୍ମୋଚଯିତ୍ୱା ଉଦସ୍ଥାପଯତ୍ ଯତଃ ସ ମୃତ୍ୟୁନା ବଦ୍ଧସ୍ତିଷ୍ଠତୀତି ନ ସମ୍ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ଏତସ୍ତିନ୍ ଦାଯୂଦପି କଥିତୱାନ୍ ଯଥା, ସର୍ୱ୍ୱଦା ମମ ସାକ୍ଷାତ୍ତଂ ସ୍ଥାପଯ ପରମେଶ୍ୱରଂ| ସ୍ଥିତେ ମଦ୍ଦକ୍ଷିଣେ ତସ୍ମିନ୍ ସ୍ଖଲିଷ୍ୟାମି ତ୍ୱହଂ ନହି| ");
INSERT INTO sanori_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ଆନନ୍ଦିଷ୍ୟତି ତଦ୍ଧେତୋ ର୍ମାମକୀନଂ ମନସ୍ତୁ ୱୈ| ଆହ୍ଲାଦିଷ୍ୟତି ଜିହ୍ୱାପି ମଦୀଯା ତୁ ତଥୈୱ ଚ| ପ୍ରତ୍ୟାଶଯା ଶରୀରନ୍ତୁ ମଦୀଯଂ ୱୈଶଯିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ପରଲୋକେ ଯତୋ ହେତୋସ୍ତ୍ୱଂ ମାଂ ନୈୱ ହି ତ୍ୟକ୍ଷ୍ୟସି| ସ୍ୱକୀଯଂ ପୁଣ୍ୟୱନ୍ତଂ ତ୍ୱଂ କ୍ଷଯିତୁଂ ନୈୱ ଦାସ୍ୟସି| ଏୱଂ ଜୀୱନମାର୍ଗଂ ତ୍ୱଂ ମାମେୱ ଦର୍ଶଯିଷ୍ୟସି| ");
INSERT INTO sanori_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","ସ୍ୱସମ୍ମୁଖେ ଯ ଆନନ୍ଦୋ ଦକ୍ଷିଣେ ସ୍ୱସ୍ୟ ଯତ୍ ସୁଖଂ| ଅନନ୍ତଂ ତେନ ମାଂ ପୂର୍ଣଂ କରିଷ୍ୟସି ନ ସଂଶଯଃ|| ");
INSERT INTO sanori_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","ହେ ଭ୍ରାତରୋଽସ୍ମାକଂ ତସ୍ୟ ପୂର୍ୱ୍ୱପୁରୁଷସ୍ୟ ଦାଯୂଦଃ କଥାଂ ସ୍ପଷ୍ଟଂ କଥଯିତୁଂ ମାମ୍ ଅନୁମନ୍ୟଧ୍ୱଂ, ସ ପ୍ରାଣାନ୍ ତ୍ୟକ୍ତ୍ୱା ଶ୍ମଶାନେ ସ୍ଥାପିତୋଭୱଦ୍ ଅଦ୍ୟାପି ତତ୍ ଶ୍ମଶାନମ୍ ଅସ୍ମାକଂ ସନ୍ନିଧୌ ୱିଦ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","ଫଲତୋ ଲୌକିକଭାୱେନ ଦାଯୂଦୋ ୱଂଶେ ଖ୍ରୀଷ୍ଟଂ ଜନ୍ମ ଗ୍ରାହଯିତ୍ୱା ତସ୍ୟୈୱ ସିଂହାସନେ ସମୁୱେଷ୍ଟୁଂ ତମୁତ୍ଥାପଯିଷ୍ୟତି ପରମେଶ୍ୱରଃ ଶପଥଂ କୁତ୍ୱା ଦାଯୂଦଃ ସମୀପ ଇମମ୍ ଅଙ୍ଗୀକାରଂ କୃତୱାନ୍, ");
INSERT INTO sanori_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ଇତି ଜ୍ଞାତ୍ୱା ଦାଯୂଦ୍ ଭୱିଷ୍ୟଦ୍ୱାଦୀ ସନ୍ ଭୱିଷ୍ୟତ୍କାଲୀଯଜ୍ଞାନେନ ଖ୍ରୀଷ୍ଟୋତ୍ଥାନେ କଥାମିମାଂ କଥଯାମାସ ଯଥା ତସ୍ୟାତ୍ମା ପରଲୋକେ ନ ତ୍ୟକ୍ଷ୍ୟତେ ତସ୍ୟ ଶରୀରଞ୍ଚ ନ କ୍ଷେଷ୍ୟତି; ");
INSERT INTO sanori_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","ଅତଃ ପରମେଶ୍ୱର ଏନଂ ଯୀଶୁଂ ଶ୍ମଶାନାଦ୍ ଉଦସ୍ଥାପଯତ୍ ତତ୍ର ୱଯଂ ସର୍ୱ୍ୱେ ସାକ୍ଷିଣ ଆସ୍ମହେ| ");
INSERT INTO sanori_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ସ ଈଶ୍ୱରସ୍ୟ ଦକ୍ଷିଣକରେଣୋନ୍ନତିଂ ପ୍ରାପ୍ୟ ପୱିତ୍ର ଆତ୍ମିନ ପିତା ଯମଙ୍ଗୀକାରଂ କୃତୱାନ୍ ତସ୍ୟ ଫଲଂ ପ୍ରାପ୍ୟ ଯତ୍ ପଶ୍ୟଥ ଶୃଣୁଥ ଚ ତଦୱର୍ଷତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","ଯତୋ ଦାଯୂଦ୍ ସ୍ୱର୍ଗଂ ନାରୁରୋହ କିନ୍ତୁ ସ୍ୱଯମ୍ ଇମାଂ କଥାମ୍ ଅକଥଯଦ୍ ଯଥା, ମମ ପ୍ରଭୁମିଦଂ ୱାକ୍ୟମୱଦତ୍ ପରମେଶ୍ୱରଃ| ");
INSERT INTO sanori_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ତୱ ଶତ୍ରୂନହଂ ଯାୱତ୍ ପାଦପୀଠଂ କରୋମି ନ| ତାୱତ୍ କାଲଂ ମଦୀଯେ ତ୍ୱଂ ଦକ୍ଷୱାର୍ଶ୍ୱ ଉପାୱିଶ| ");
INSERT INTO sanori_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","ଅତୋ ଯଂ ଯୀଶୁଂ ଯୂଯଂ କ୍ରୁଶେଽହତ ପରମେଶ୍ୱରସ୍ତଂ ପ୍ରଭୁତ୍ୱାଭିଷିକ୍ତତ୍ୱପଦେ ନ୍ୟଯୁଂକ୍ତେତି ଇସ୍ରାଯେଲୀଯା ଲୋକା ନିଶ୍ଚିତଂ ଜାନନ୍ତୁ| ");
INSERT INTO sanori_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ଏତାଦୃଶୀଂ କଥାଂ ଶ୍ରୁତ୍ୱା ତେଷାଂ ହୃଦଯାନାଂ ୱିଦୀର୍ଣତ୍ୱାତ୍ ତେ ପିତରାଯ ତଦନ୍ୟପ୍ରେରିତେଭ୍ୟଶ୍ଚ କଥିତୱନ୍ତଃ, ହେ ଭ୍ରାତୃଗଣ ୱଯଂ କିଂ କରିଷ୍ୟାମଃ? ");
INSERT INTO sanori_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","ତତଃ ପିତରଃ ପ୍ରତ୍ୟୱଦଦ୍ ଯୂଯଂ ସର୍ୱ୍ୱେ ସ୍ୱଂ ସ୍ୱଂ ମନଃ ପରିୱର୍ତ୍ତଯଧ୍ୱଂ ତଥା ପାପମୋଚନାର୍ଥଂ ଯୀଶୁଖ୍ରୀଷ୍ଟସ୍ୟ ନାମ୍ନା ମଜ୍ଜିତାଶ୍ଚ ଭୱତ, ତସ୍ମାଦ୍ ଦାନରୂପଂ ପରିତ୍ରମ୍ ଆତ୍ମାନଂ ଲପ୍ସ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","ଯତୋ ଯୁଷ୍ମାକଂ ଯୁଷ୍ମତ୍ସନ୍ତାନାନାଞ୍ଚ ଦୂରସ୍ଥସର୍ୱ୍ୱଲୋକାନାଞ୍ଚ ନିମିତ୍ତମ୍ ଅର୍ଥାଦ୍ ଅସ୍ମାକଂ ପ୍ରଭୁଃ ପରମେଶ୍ୱରୋ ଯାୱତୋ ଲାକାନ୍ ଆହ୍ୱାସ୍ୟତି ତେଷାଂ ସର୍ୱ୍ୱେଷାଂ ନିମିତ୍ତମ୍ ଅଯମଙ୍ଗୀକାର ଆସ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ଏତଦନ୍ୟାଭି ର୍ବହୁକଥାଭିଃ ପ୍ରମାଣଂ ଦତ୍ୱାକଥଯତ୍ ଏତେଭ୍ୟୋ ୱିପଥଗାମିଭ୍ୟୋ ୱର୍ତ୍ତମାନଲୋକେଭ୍ୟଃ ସ୍ୱାନ୍ ରକ୍ଷତ| ");
INSERT INTO sanori_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ତତଃ ପରଂ ଯେ ସାନନ୍ଦାସ୍ତାଂ କଥାମ୍ ଅଗୃହ୍ଲନ୍ ତେ ମଜ୍ଜିତା ଅଭୱନ୍| ତସ୍ମିନ୍ ଦିୱସେ ପ୍ରାଯେଣ ତ୍ରୀଣି ସହସ୍ରାଣି ଲୋକାସ୍ତେଷାଂ ସପକ୍ଷାଃ ସନ୍ତଃ ");
INSERT INTO sanori_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ପ୍ରେରିତାନାମ୍ ଉପଦେଶେ ସଙ୍ଗତୌ ପୂପଭଞ୍ଜନେ ପ୍ରାର୍ଥନାସୁ ଚ ମନଃସଂଯୋଗଂ କୃତ୍ୱାତିଷ୍ଠନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","ପ୍ରେରିତୈ ର୍ନାନାପ୍ରକାରଲକ୍ଷଣେଷୁ ମହାଶ୍ଚର୍ୟ୍ୟକର୍ମମସୁ ଚ ଦର୍ଶିତେଷୁ ସର୍ୱ୍ୱଲୋକାନାଂ ଭଯମୁପସ୍ଥିତଂ| ");
INSERT INTO sanori_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","ୱିଶ୍ୱାସକାରିଣଃ ସର୍ୱ୍ୱ ଚ ସହ ତିଷ୍ଠନତଃ| ସ୍ୱେଷାଂ ସର୍ୱ୍ୱାଃ ସମ୍ପତ୍ତୀଃ ସାଧାରଣ୍ୟେନ ସ୍ଥାପଯିତ୍ୱାଭୁଞ୍ଜତ| ");
INSERT INTO sanori_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ଫଲତୋ ଗୃହାଣି ଦ୍ରୱ୍ୟାଣି ଚ ସର୍ୱ୍ୱାଣି ୱିକ୍ରୀଯ ସର୍ୱ୍ୱେଷାଂ ସ୍ୱସ୍ୱପ୍ରଯୋଜନାନୁସାରେଣ ୱିଭଜ୍ୟ ସର୍ୱ୍ୱେଭ୍ୟୋଽଦଦନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","ସର୍ୱ୍ୱ ଏକଚିତ୍ତୀଭୂଯ ଦିନେ ଦିନେ ମନ୍ଦିରେ ସନ୍ତିଷ୍ଠମାନା ଗୃହେ ଗୃହେ ଚ ପୂପାନଭଞ୍ଜନ୍ତ ଈଶ୍ୱରସ୍ୟ ଧନ୍ୟୱାଦଂ କୁର୍ୱ୍ୱନ୍ତୋ ଲୋକୈଃ ସମାଦୃତାଃ ପରମାନନ୍ଦେନ ସରଲାନ୍ତଃକରଣେନ ଭୋଜନଂ ପାନଞ୍ଚକୁର୍ୱ୍ୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ପରମେଶ୍ୱରୋ ଦିନେ ଦିନେ ପରିତ୍ରାଣଭାଜନୈ ର୍ମଣ୍ଡଲୀମ୍ ଅୱର୍ଦ୍ଧଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","ତୃତୀଯଯାମୱେଲାଯାଂ ସତ୍ୟାଂ ପ୍ରାର୍ଥନାଯାଃ ସମଯେ ପିତରଯୋହନୌ ସମ୍ଭୂଯ ମନ୍ଦିରଂ ଗଚ୍ଛତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ତସ୍ମିନ୍ନେୱ ସମଯେ ମନ୍ଦିରପ୍ରୱେଶକାନାଂ ସମୀପେ ଭିକ୍ଷାରଣାର୍ଥଂ ଯଂ ଜନ୍ମଖଞ୍ଜମାନୁଷଂ ଲୋକା ମନ୍ଦିରସ୍ୟ ସୁନ୍ଦରନାମ୍ନି ଦ୍ୱାରେ ପ୍ରତିଦିନମ୍ ଅସ୍ଥାପଯନ୍ ତଂ ୱହନ୍ତସ୍ତଦ୍ୱାରଂ ଆନଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ତଦା ପିତରଯୋହନୌ ମନ୍ତିରଂ ପ୍ରୱେଷ୍ଟୁମ୍ ଉଦ୍ୟତୌ ୱିଲୋକ୍ୟ ସ ଖଞ୍ଜସ୍ତୌ କିଞ୍ଚିଦ୍ ଭିକ୍ଷିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","ତସ୍ମାଦ୍ ଯୋହନା ସହିତଃ ପିତରସ୍ତମ୍ ଅନନ୍ୟଦୃଷ୍ଟ୍ୟା ନିରୀକ୍ଷ୍ୟ ପ୍ରୋକ୍ତୱାନ୍ ଆୱାଂ ପ୍ରତି ଦୃଷ୍ଟିଂ କୁରୁ| ");
INSERT INTO sanori_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ତତଃ ସ କିଞ୍ଚିତ୍ ପ୍ରାପ୍ତ୍ୟାଶଯା ତୌ ପ୍ରତି ଦୃଷ୍ଟିଂ କୃତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","ତଦା ପିତରୋ ଗଦିତୱାନ୍ ମମ ନିକଟେ ସ୍ୱର୍ଣରୂପ୍ୟାଦି କିମପି ନାସ୍ତି କିନ୍ତୁ ଯଦାସ୍ତେ ତଦ୍ ଦଦାମି ନାସରତୀଯସ୍ୟ ଯୀଶୁଖ୍ରୀଷ୍ଟସ୍ୟ ନାମ୍ନା ତ୍ୱମୁତ୍ଥାଯ ଗମନାଗମନେ କୁରୁ| ");
INSERT INTO sanori_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ତତଃ ପରଂ ସ ତସ୍ୟ ଦକ୍ଷିଣକରଂ ଧୃତ୍ୱା ତମ୍ ଉଦତୋଲଯତ୍; ତେନ ତତ୍କ୍ଷଣାତ୍ ତସ୍ୟ ଜନସ୍ୟ ପାଦଗୁଲ୍ଫଯୋଃ ସବଲତ୍ୱାତ୍ ସ ଉଲ୍ଲମ୍ଫ୍ୟ ପ୍ରୋତ୍ଥାଯ ଗମନାଗମନେ ଽକରୋତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ତତୋ ଗମନାଗମନେ କୁର୍ୱ୍ୱନ୍ ଉଲ୍ଲମ୍ଫନ୍ ଈଶ୍ୱରଂ ଧନ୍ୟଂ ୱଦନ୍ ତାଭ୍ୟାଂ ସାର୍ଦ୍ଧଂ ମନ୍ଦିରଂ ପ୍ରାୱିଶତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ତତଃ ସର୍ୱ୍ୱେ ଲୋକାସ୍ତଂ ଗମନାଗମନେ କୁର୍ୱ୍ୱନ୍ତମ୍ ଈଶ୍ୱରଂ ଧନ୍ୟଂ ୱଦନ୍ତଞ୍ଚ ୱିଲୋକ୍ୟ ");
INSERT INTO sanori_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ମନ୍ଦିରସ୍ୟ ସୁନ୍ଦରେ ଦ୍ୱାରେ ଯ ଉପୱିଶ୍ୟ ଭିକ୍ଷିତୱାନ୍ ସଏୱାଯମ୍ ଇତି ଜ୍ଞାତ୍ୱା ତଂ ପ୍ରତି ତଯା ଘଟନଯା ଚମତ୍କୃତା ୱିସ୍ମଯାପନ୍ନାଶ୍ଚାଭୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","ଯଃ ଖଞ୍ଜଃ ସ୍ୱସ୍ଥୋଭୱତ୍ ତେନ ପିତରଯୋହନୋଃ କରଯୋର୍ଧ୍ଟତଯୋଃ ସତୋଃ ସର୍ୱ୍ୱେ ଲୋକା ସନ୍ନିଧିମ୍ ଆଗଚ୍ଛନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ତଦ୍ ଦୃଷ୍ଟ୍ୱା ପିତରସ୍ତେଭ୍ୟୋଽକଥଯତ୍, ହେ ଇସ୍ରାଯେଲୀଯଲୋକା ଯୂଯଂ କୁତୋ ଽନେନାଶ୍ଚର୍ୟ୍ୟଂ ମନ୍ୟଧ୍ୱେ? ଆୱାଂ ନିଜଶକ୍ତ୍ୟା ଯଦ୍ୱା ନିଜପୁଣ୍ୟେନ ଖଞ୍ଜମନୁଷ୍ୟମେନଂ ଗମିତୱନ୍ତାୱିତି ଚିନ୍ତଯିତ୍ୱା ଆୱାଂ ପ୍ରତି କୁତୋଽନନ୍ୟଦୃଷ୍ଟିଂ କୁରୁଥ? ");
INSERT INTO sanori_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","ଯଂ ଯୀଶୁଂ ଯୂଯଂ ପରକରେଷୁ ସମାର୍ପଯତ ତତୋ ଯଂ ପୀଲାତୋ ମୋଚଯିତୁମ୍ ଏैଚ୍ଛତ୍ ତଥାପି ଯୂଯଂ ତସ୍ୟ ସାକ୍ଷାନ୍ ନାଙ୍ଗୀକୃତୱନ୍ତ ଇବ୍ରାହୀମ ଇସ୍ହାକୋ ଯାକୂବଶ୍ଚେଶ୍ୱରୋଽର୍ଥାଦ୍ ଅସ୍ମାକଂ ପୂର୍ୱ୍ୱପୁରୁଷାଣାମ୍ ଈଶ୍ୱରଃ ସ୍ୱପୁତ୍ରସ୍ୟ ତସ୍ୟ ଯୀଶୋ ର୍ମହିମାନଂ ପ୍ରାକାଶଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","କିନ୍ତୁ ଯୂଯଂ ତଂ ପୱିତ୍ରଂ ଧାର୍ମ୍ମିକଂ ପୁମାଂସଂ ନାଙ୍ଗୀକୃତ୍ୟ ହତ୍ୟାକାରିଣମେକଂ ସ୍ୱେଭ୍ୟୋ ଦାତୁମ୍ ଅଯାଚଧ୍ୱଂ| ");
INSERT INTO sanori_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ପଶ୍ଚାତ୍ ତଂ ଜୀୱନସ୍ୟାଧିପତିମ୍ ଅହତ କିନ୍ତ୍ୱୀଶ୍ୱରଃ ଶ୍ମଶାନାତ୍ ତମ୍ ଉଦସ୍ଥାପଯତ ତତ୍ର ୱଯଂ ସାକ୍ଷିଣ ଆସ୍ମହେ| ");
INSERT INTO sanori_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ଇମଂ ଯଂ ମାନୁଷଂ ଯୂଯଂ ପଶ୍ୟଥ ପରିଚିନୁଥ ଚ ସ ତସ୍ୟ ନାମ୍ନି ୱିଶ୍ୱାସକରଣାତ୍ ଚଲନଶକ୍ତିଂ ଲବ୍ଧୱାନ୍ ତସ୍ମିନ୍ ତସ୍ୟ ଯୋ ୱିଶ୍ୱାସଃ ସ ତଂ ଯୁଷ୍ମାକଂ ସର୍ୱ୍ୱେଷାଂ ସାକ୍ଷାତ୍ ସମ୍ପୂର୍ଣରୂପେଣ ସ୍ୱସ୍ଥମ୍ ଅକାର୍ଷୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","ହେ ଭ୍ରାତରୋ ଯୂଯଂ ଯୁଷ୍ମାକମ୍ ଅଧିପତଯଶ୍ଚ ଅଜ୍ଞାତ୍ୱା କର୍ମ୍ମାଣ୍ୟେତାନି କୃତୱନ୍ତ ଇଦାନୀଂ ମମୈଷ ବୋଧୋ ଜାଯତେ| ");
INSERT INTO sanori_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","କିନ୍ତ୍ୱୀଶ୍ୱରଃ ଖ୍ରୀଷ୍ଟସ୍ୟ ଦୁଃଖଭୋଗେ ଭୱିଷ୍ୟଦ୍ୱାଦିନାଂ ମୁଖେଭ୍ୟୋ ଯାଂ ଯାଂ କଥାଂ ପୂର୍ୱ୍ୱମକଥଯତ୍ ତାଃ କଥା ଇତ୍ଥଂ ସିଦ୍ଧା ଅକରୋତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","ଅତଃ ସ୍ୱେଷାଂ ପାପମୋଚନାର୍ଥଂ ଖେଦଂ କୃତ୍ୱା ମନାଂସି ପରିୱର୍ତ୍ତଯଧ୍ୱଂ, ତସ୍ମାଦ୍ ଈଶ୍ୱରାତ୍ ସାନ୍ତ୍ୱନାପ୍ରାପ୍ତେଃ ସମଯ ଉପସ୍ଥାସ୍ୟତି; ");
INSERT INTO sanori_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ପୁନଶ୍ଚ ପୂର୍ୱ୍ୱକାଲମ୍ ଆରଭ୍ୟ ପ୍ରଚାରିତୋ ଯୋ ଯୀଶୁଖ୍ରୀଷ୍ଟସ୍ତମ୍ ଈଶ୍ୱରୋ ଯୁଷ୍ମାନ୍ ପ୍ରତି ପ୍ରେଷଯିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","କିନ୍ତୁ ଜଗତଃ ସୃଷ୍ଟିମାରଭ୍ୟ ଈଶ୍ୱରୋ ନିଜପୱିତ୍ରଭୱିଷ୍ୟଦ୍ୱାଦିଗଣୋନ ଯଥା କଥିତୱାନ୍ ତଦନୁସାରେଣ ସର୍ୱ୍ୱେଷାଂ କାର୍ୟ୍ୟାଣାଂ ସିଦ୍ଧିପର୍ୟ୍ୟନ୍ତଂ ତେନ ସ୍ୱର୍ଗେ ୱାସଃ କର୍ତ୍ତୱ୍ୟଃ| ");
INSERT INTO sanori_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","ଯୁଷ୍ମାକଂ ପ୍ରଭୁଃ ପରମେଶ୍ୱରୋ ଯୁଷ୍ମାକଂ ଭ୍ରାତୃଗଣମଧ୍ୟାତ୍ ମତ୍ସଦୃଶଂ ଭୱିଷ୍ୟଦ୍ୱକ୍ତାରମ୍ ଉତ୍ପାଦଯିଷ୍ୟତି, ତତଃ ସ ଯତ୍ କିଞ୍ଚିତ୍ କଥଯିଷ୍ୟତି ତତ୍ର ଯୂଯଂ ମନାଂସି ନିଧଦ୍ଧ୍ୱଂ| ");
INSERT INTO sanori_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","କିନ୍ତୁ ଯଃ କଶ୍ଚିତ୍ ପ୍ରାଣୀ ତସ୍ୟ ଭୱିଷ୍ୟଦ୍ୱାଦିନଃ କଥାଂ ନ ଗ୍ରହୀଷ୍ୟତି ସ ନିଜଲୋକାନାଂ ମଧ୍ୟାଦ୍ ଉଚ୍ଛେତ୍ସ୍ୟତେ,\" ଇମାଂ କଥାମ୍ ଅସ୍ମାକଂ ପୂର୍ୱ୍ୱପୁରୁଷେଭ୍ୟଃ କେୱଲୋ ମୂସାଃ କଥଯାମାସ ଇତି ନହି, ");
INSERT INTO sanori_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","ଶିମୂଯେଲ୍ଭୱିଷ୍ୟଦ୍ୱାଦିନମ୍ ଆରଭ୍ୟ ଯାୱନ୍ତୋ ଭୱିଷ୍ୟଦ୍ୱାକ୍ୟମ୍ ଅକଥଯନ୍ ତେ ସର୍ୱ୍ୱଏୱ ସମଯସ୍ୟୈତସ୍ୟ କଥାମ୍ ଅକଥଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","ଯୂଯମପି ତେଷାଂ ଭୱିଷ୍ୟଦ୍ୱାଦିନାଂ ସନ୍ତାନାଃ, \"ତୱ ୱଂଶୋଦ୍ଭୱପୁଂସା ସର୍ୱ୍ୱଦେଶୀଯା ଲୋକା ଆଶିଷଂ ପ୍ରାପ୍ତା ଭୱିଷ୍ୟନ୍ତି\", ଇବ୍ରାହୀମେ କଥାମେତାଂ କଥଯିତ୍ୱା ଈଶ୍ୱରୋସ୍ମାକଂ ପୂର୍ୱ୍ୱପୁରୁଷୈଃ ସାର୍ଦ୍ଧଂ ଯଂ ନିଯମଂ ସ୍ଥିରୀକୃତୱାନ୍ ତସ୍ୟ ନିଯମସ୍ୟାଧିକାରିଣୋପି ଯୂଯଂ ଭୱଥ| ");
INSERT INTO sanori_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ଅତ ଈଶ୍ୱରୋ ନିଜପୁତ୍ରଂ ଯୀଶୁମ୍ ଉତ୍ଥାପ୍ୟ ଯୁଷ୍ମାକଂ ସର୍ୱ୍ୱେଷାଂ ସ୍ୱସ୍ୱପାପାତ୍ ପରାୱର୍ତ୍ତ୍ୟ ଯୁଷ୍ମଭ୍ୟମ୍ ଆଶିଷଂ ଦାତୁଂ ପ୍ରଥମତସ୍ତଂ ଯୁଷ୍ମାକଂ ନିକଟଂ ପ୍ରେଷିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","ଯସ୍ମିନ୍ ସମଯେ ପିତରଯୋହନୌ ଲୋକାନ୍ ଉପଦିଶତସ୍ତସ୍ମିନ୍ ସମଯେ ଯାଜକା ମନ୍ଦିରସ୍ୟ ସେନାପତଯଃ ସିଦୂକୀଗଣଶ୍ଚ ");
INSERT INTO sanori_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ତଯୋର୍ ଉପଦେଶକରଣେ ଖ୍ରୀଷ୍ଟସ୍ୟୋତ୍ଥାନମ୍ ଉପଲକ୍ଷ୍ୟ ସର୍ୱ୍ୱେଷାଂ ମୃତାନାମ୍ ଉତ୍ଥାନପ୍ରସ୍ତାୱେ ଚ ୱ୍ୟଗ୍ରାଃ ସନ୍ତସ୍ତାୱୁପାଗମନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","ତୌ ଧୃତ୍ୱା ଦିନାୱସାନକାରଣାତ୍ ପରଦିନପର୍ୟ୍ୟନନ୍ତଂ ରୁଦ୍ଧ୍ୱା ସ୍ଥାପିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","ତଥାପି ଯେ ଲୋକାସ୍ତଯୋରୁପଦେଶମ୍ ଅଶୃଣ୍ୱନ୍ ତେଷାଂ ପ୍ରାଯେଣ ପଞ୍ଚସହସ୍ରାଣି ଜନା ୱ୍ୟଶ୍ୱସନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","ପରେଽହନି ଅଧିପତଯଃ ପ୍ରାଚୀନା ଅଧ୍ୟାପକାଶ୍ଚ ହାନନନାମା ମହାଯାଜକଃ ");
INSERT INTO sanori_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","କିଯଫା ଯୋହନ୍ ସିକନ୍ଦର ଇତ୍ୟାଦଯୋ ମହାଯାଜକସ୍ୟ ଜ୍ଞାତଯଃ ସର୍ୱ୍ୱେ ଯିରୂଶାଲମ୍ନଗରେ ମିଲିତାଃ| ");
INSERT INTO sanori_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","ଅନନ୍ତରଂ ପ୍ରେରିତୌ ମଧ୍ୟେ ସ୍ଥାପଯିତ୍ୱାପୃଚ୍ଛନ୍ ଯୁୱାଂ କଯା ଶକ୍ତଯା ୱା କେନ ନାମ୍ନା କର୍ମ୍ମାଣ୍ୟେତାନି କୁରୁଥଃ? ");
INSERT INTO sanori_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","ତଦା ପିତରଃ ପୱିତ୍ରେଣାତ୍ମନା ପରିପୂର୍ଣଃ ସନ୍ ପ୍ରତ୍ୟୱାଦୀତ୍, ହେ ଲୋକାନାମ୍ ଅଧିପତିଗଣ ହେ ଇସ୍ରାଯେଲୀଯପ୍ରାଚୀନାଃ, ");
INSERT INTO sanori_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ଏତସ୍ୟ ଦୁର୍ବ୍ବଲମାନୁଷସ୍ୟ ହିତଂ ଯତ୍ କର୍ମ୍ମାକ୍ରିଯତ, ଅର୍ଥାତ୍, ସ ଯେନ ପ୍ରକାରେଣ ସ୍ୱସ୍ଥୋଭୱତ୍ ତଚ୍ଚେଦ୍ ଅଦ୍ୟାୱାଂ ପୃଚ୍ଛଥ, ");
INSERT INTO sanori_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ତର୍ହି ସର୍ୱ୍ୱ ଇସ୍ରାଯେेଲୀଯଲୋକା ଯୂଯଂ ଜାନୀତ ନାସରତୀଯୋ ଯୋ ଯୀଶୁଖ୍ରୀଷ୍ଟଃ କ୍ରୁଶେ ଯୁଷ୍ମାଭିରୱିଧ୍ୟତ ଯଶ୍ଚେଶ୍ୱରେଣ ଶ୍ମଶାନାଦ୍ ଉତ୍ଥାପିତଃ, ତସ୍ୟ ନାମ୍ନା ଜନୋଯଂ ସ୍ୱସ୍ଥଃ ସନ୍ ଯୁଷ୍ମାକଂ ସମ୍ମୁଖେ ପ୍ରୋତ୍ତିଷ୍ଠତି| ");
INSERT INTO sanori_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","ନିଚେତୃଭି ର୍ୟୁଷ୍ମାଭିରଯଂ ଯଃ ପ୍ରସ୍ତରୋଽୱଜ୍ଞାତୋଽଭୱତ୍ ସ ପ୍ରଧାନକୋଣସ୍ୟ ପ୍ରସ୍ତରୋଽଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","ତଦ୍ଭିନ୍ନାଦପରାତ୍ କସ୍ମାଦପି ପରିତ୍ରାଣଂ ଭୱିତୁଂ ନ ଶକ୍ନୋତି, ଯେନ ତ୍ରାଣଂ ପ୍ରାପ୍ୟେତ ଭୂମଣ୍ଡଲସ୍ୟଲୋକାନାଂ ମଧ୍ୟେ ତାଦୃଶଂ କିମପି ନାମ ନାସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ତଦା ପିତରଯୋହନୋରେତାଦୃଶୀମ୍ ଅକ୍ଷେଭତାଂ ଦୃଷ୍ଟ୍ୱା ତାୱୱିଦ୍ୱାଂସୌ ନୀଚଲୋକାୱିତି ବୁଦ୍ଧ୍ୱା ଆଶ୍ଚର୍ୟ୍ୟମ୍ ଅମନ୍ୟନ୍ତ ତୌ ଚ ଯୀଶୋଃ ସଙ୍ଗିନୌ ଜାତାୱିତି ଜ୍ଞାତୁମ୍ ଅଶକ୍ନୁୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","କିନ୍ତୁ ତାଭ୍ୟାଂ ସାର୍ଦ୍ଧଂ ତଂ ସ୍ୱସ୍ଥମାନୁଷଂ ତିଷ୍ଠନ୍ତଂ ଦୃଷ୍ଟ୍ୱା ତେ କାମପ୍ୟପରାମ୍ ଆପତ୍ତିଂ କର୍ତ୍ତଂ ନାଶକ୍ନୁନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","ତଦା ତେ ସଭାତଃ ସ୍ଥାନାନ୍ତରଂ ଗନ୍ତୁଂ ତାନ୍ ଆଜ୍ଞାପ୍ୟ ସ୍ୱଯଂ ପରସ୍ପରମ୍ ଇତି ମନ୍ତ୍ରଣାମକୁର୍ୱ୍ୱନ୍ ");
INSERT INTO sanori_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ତୌ ମାନୱୌ ପ୍ରତି କିଂ କର୍ତ୍ତୱ୍ୟଂ? ତାୱେକଂ ପ୍ରସିଦ୍ଧମ୍ ଆଶ୍ଚର୍ୟ୍ୟଂ କର୍ମ୍ମ କୃତୱନ୍ତୌ ତଦ୍ ଯିରୂଶାଲମ୍ନିୱାସିନାଂ ସର୍ୱ୍ୱେଷାଂ ଲୋକାନାଂ ସମୀପେ ପ୍ରାକାଶତ ତଚ୍ଚ ୱଯମପହ୍ନୋତୁଂ ନ ଶକ୍ନୁମଃ| ");
INSERT INTO sanori_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","କିନ୍ତୁ ଲୋକାନାଂ ମଧ୍ୟମ୍ ଏତଦ୍ ଯଥା ନ ୱ୍ୟାପ୍ନୋତି ତଦର୍ଥଂ ତୌ ଭଯଂ ପ୍ରଦର୍ଶ୍ୟ ତେନ ନାମ୍ନା କମପି ମନୁଷ୍ୟଂ ନୋପଦିଶତମ୍ ଇତି ଦୃଢଂ ନିଷେଧାମଃ| ");
INSERT INTO sanori_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ତତସ୍ତେ ପ୍ରେରିତାୱାହୂଯ ଏତଦାଜ୍ଞାପଯନ୍ ଇତଃ ପରଂ ଯୀଶୋ ର୍ନାମ୍ନା କଦାପି କାମପି କଥାଂ ମା କଥଯତଂ କିମପି ନୋପଦିଶଞ୍ଚ| ");
INSERT INTO sanori_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","ତତଃ ପିତରଯୋହନୌ ପ୍ରତ୍ୟୱଦତାମ୍ ଈଶ୍ୱରସ୍ୟାଜ୍ଞାଗ୍ରହଣଂ ୱା ଯୁଷ୍ମାକମ୍ ଆଜ୍ଞାଗ୍ରହଣମ୍ ଏତଯୋ ର୍ମଧ୍ୟେ ଈଶ୍ୱରସ୍ୟ ଗୋଚରେ କିଂ ୱିହିତଂ? ଯୂଯଂ ତସ୍ୟ ୱିୱେଚନାଂ କୁରୁତ| ");
INSERT INTO sanori_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","ୱଯଂ ଯଦ୍ ଅପଶ୍ୟାମ ଯଦଶୃଣୁମ ଚ ତନ୍ନ ପ୍ରଚାରଯିଷ୍ୟାମ ଏତତ୍ କଦାପି ଭୱିତୁଂ ନ ଶକ୍ନୋତି| ");
INSERT INTO sanori_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","ଯଦଘଟତ ତଦ୍ ଦୃଷ୍ଟା ସର୍ୱ୍ୱେ ଲୋକା ଈଶ୍ୱରସ୍ୟ ଗୁଣାନ୍ ଅନ୍ୱୱଦନ୍ ତସ୍ମାତ୍ ଲୋକଭଯାତ୍ ତୌ ଦଣ୍ଡଯିତୁଂ କମପ୍ୟୁପାଯଂ ନ ପ୍ରାପ୍ୟ ତେ ପୁନରପି ତର୍ଜଯିତ୍ୱା ତାୱତ୍ୟଜନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ଯସ୍ୟ ମାନୁଷସ୍ୟୈତତ୍ ସ୍ୱାସ୍ଥ୍ୟକରଣମ୍ ଆଶ୍ଚର୍ୟ୍ୟଂ କର୍ମ୍ମାକ୍ରିଯତ ତସ୍ୟ ୱଯଶ୍ଚତ୍ୱାରିଂଶଦ୍ୱତ୍ସରା ୱ୍ୟତୀତାଃ| ");
INSERT INTO sanori_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ତତଃ ପରଂ ତୌ ୱିସୃଷ୍ଟୌ ସନ୍ତୌ ସ୍ୱସଙ୍ଗିନାଂ ସନ୍ନିଧିଂ ଗତ୍ୱା ପ୍ରଧାନଯାଜକୈଃ ପ୍ରାଚୀନଲୋକୈଶ୍ଚ ପ୍ରୋକ୍ତାଃ ସର୍ୱ୍ୱାଃ କଥା ଜ୍ଞାପିତୱନ୍ତୌ| ");
INSERT INTO sanori_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ତଚ୍ଛ୍ରୁତ୍ୱା ସର୍ୱ୍ୱ ଏକଚିତ୍ତୀଭୂଯ ଈଶ୍ୱରମୁଦ୍ଦିଶ୍ୟ ପ୍ରୋଚ୍ଚୈରେତତ୍ ପ୍ରାର୍ଥଯନ୍ତ, ହେ ପ୍ରଭୋ ଗଗଣପୃଥିୱୀପଯୋଧୀନାଂ ତେଷୁ ଚ ଯଦ୍ୟଦ୍ ଆସ୍ତେ ତେଷାଂ ସ୍ରଷ୍ଟେଶ୍ୱରସ୍ତ୍ୱଂ| ");
INSERT INTO sanori_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ତ୍ୱଂ ନିଜସେୱକେନ ଦାଯୂଦା ୱାକ୍ୟମିଦମ୍ ଉୱଚିଥ, ମନୁଷ୍ୟା ଅନ୍ୟଦେଶୀଯାଃ କୁର୍ୱ୍ୱନ୍ତି କଲହଂ କୁତଃ| ଲୋକାଃ ସର୍ୱ୍ୱେ କିମର୍ଥଂ ୱା ଚିନ୍ତାଂ କୁର୍ୱ୍ୱନ୍ତି ନିଷ୍ଫଲାଂ| ");
INSERT INTO sanori_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ପରମେଶସ୍ୟ ତେନୈୱାଭିଷିକ୍ତସ୍ୟ ଜନସ୍ୟ ଚ| ୱିରୁଦ୍ଧମଭିତିଷ୍ଠନ୍ତି ପୃଥିୱ୍ୟାଃ ପତଯଃ କୁତଃ|| ");
INSERT INTO sanori_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","ଫଲତସ୍ତୱ ହସ୍ତେନ ମନ୍ତ୍ରଣଯା ଚ ପୂର୍ୱ୍ୱ ଯଦ୍ୟତ୍ ସ୍ଥିରୀକୃତଂ ତଦ୍ ଯଥା ସିଦ୍ଧଂ ଭୱତି ତଦର୍ଥଂ ତ୍ୱଂ ଯମ୍ ଅଥିଷିକ୍ତୱାନ୍ ସ ଏୱ ପୱିତ୍ରୋ ଯୀଶୁସ୍ତସ୍ୟ ପ୍ରାତିକୂଲ୍ୟେନ ହେରୋଦ୍ ପନ୍ତୀଯପୀଲାତୋ ");
INSERT INTO sanori_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ଽନ୍ୟଦେଶୀଯଲୋକା ଇସ୍ରାଯେଲ୍ଲୋକାଶ୍ଚ ସର୍ୱ୍ୱ ଏତେ ସଭାଯାମ୍ ଅତିଷ୍ଠନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ହେ ପରମେଶ୍ୱର ଅଧୁନା ତେଷାଂ ତର୍ଜନଂ ଗର୍ଜନଞ୍ଚ ଶୃଣୁ; ");
INSERT INTO sanori_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ତଥା ସ୍ୱାସ୍ଥ୍ୟକରଣକର୍ମ୍ମଣା ତୱ ବାହୁବଲପ୍ରକାଶପୂର୍ୱ୍ୱକଂ ତୱ ସେୱକାନ୍ ନିର୍ଭଯେନ ତୱ ୱାକ୍ୟଂ ପ୍ରଚାରଯିତୁଂ ତୱ ପୱିତ୍ରପୁତ୍ରସ୍ୟ ଯୀଶୋ ର୍ନାମ୍ନା ଆଶ୍ଚର୍ୟ୍ୟାଣ୍ୟସମ୍ଭୱାନି ଚ କର୍ମ୍ମାଣି କର୍ତ୍ତୁଞ୍ଚାଜ୍ଞାପଯ| ");
INSERT INTO sanori_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ଇତ୍ଥଂ ପ୍ରାର୍ଥନଯା ଯତ୍ର ସ୍ଥାନେ ତେ ସଭାଯାମ୍ ଆସନ୍ ତତ୍ ସ୍ଥାନଂ ପ୍ରାକମ୍ପତ; ତତଃ ସର୍ୱ୍ୱେ ପୱିତ୍ରେଣାତ୍ମନା ପରିପୂର୍ଣାଃ ସନ୍ତ ଈଶ୍ୱରସ୍ୟ କଥାମ୍ ଅକ୍ଷୋଭେଣ ପ୍ରାଚାରଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","ଅପରଞ୍ଚ ପ୍ରତ୍ୟଯକାରିଲୋକସମୂହା ଏକମନସ ଏକଚିତ୍ତୀଭୂଯ ସ୍ଥିତାଃ| ତେଷାଂ କେପି ନିଜସମ୍ପତ୍ତିଂ ସ୍ୱୀଯାଂ ନାଜାନନ୍ କିନ୍ତୁ ତେଷାଂ ସର୍ୱ୍ୱାଃ ସମ୍ପତ୍ତ୍ୟଃ ସାଧାରଣ୍ୟେନ ସ୍ଥିତାଃ| ");
INSERT INTO sanori_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","ଅନ୍ୟଚ୍ଚ ପ୍ରେରିତା ମହାଶକ୍ତିପ୍ରକାଶପୂର୍ୱ୍ୱକଂ ପ୍ରଭୋ ର୍ୟୀଶୋରୁତ୍ଥାନେ ସାକ୍ଷ୍ୟମ୍ ଅଦଦୁଃ, ତେଷୁ ସର୍ୱ୍ୱେଷୁ ମହାନୁଗ୍ରହୋଽଭୱଚ୍ଚ| ");
INSERT INTO sanori_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","ତେଷାଂ ମଧ୍ୟେ କସ୍ୟାପି ଦ୍ରୱ୍ୟନ୍ୟୂନତା ନାଭୱଦ୍ ଯତସ୍ତେଷାଂ ଗୃହଭୂମ୍ୟାଦ୍ୟା ଯାଃ ସମ୍ପତ୍ତଯ ଆସନ୍ ତା ୱିକ୍ରୀଯ ");
INSERT INTO sanori_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ତନ୍ମୂଲ୍ୟମାନୀଯ ପ୍ରେରିତାନାଂ ଚରଣେଷୁ ତୈଃ ସ୍ଥାପିତଂ; ତତଃ ପ୍ରତ୍ୟେକଶଃ ପ୍ରଯୋଜନାନୁସାରେଣ ଦତ୍ତମଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","ୱିଶେଷତଃ କୁପ୍ରୋପଦ୍ୱୀପୀଯୋ ଯୋସିନାମକୋ ଲେୱିୱଂଶଜାତ ଏକୋ ଜନୋ ଭୂମ୍ୟଧିକାରୀ, ଯଂ ପ୍ରେରିତା ବର୍ଣବ୍ବା ଅର୍ଥାତ୍ ସାନ୍ତ୍ୱନାଦାଯକ ଇତ୍ୟୁକ୍ତ୍ୱା ସମାହୂଯନ୍, ");
INSERT INTO sanori_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ସ ଜନୋ ନିଜଭୂମିଂ ୱିକ୍ରୀଯ ତନ୍ମୂଲ୍ୟମାନୀଯ ପ୍ରେରିତାନାଂ ଚରଣେଷୁ ସ୍ଥାପିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","ତଦା ଅନାନିଯନାମକ ଏକୋ ଜନୋ ଯସ୍ୟ ଭାର୍ୟ୍ୟାଯା ନାମ ସଫୀରା ସ ସ୍ୱାଧିକାରଂ ୱିକ୍ରୀଯ ");
INSERT INTO sanori_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ସ୍ୱଭାର୍ୟ୍ୟାଂ ଜ୍ଞାପଯିତ୍ୱା ତନ୍ମୂଲ୍ୟସ୍ୟୈକାଂଶଂ ସଙ୍ଗୋପ୍ୟ ସ୍ଥାପଯିତ୍ୱା ତଦନ୍ୟାଂଶମାତ୍ରମାନୀଯ ପ୍ରେରିତାନାଂ ଚରଣେଷୁ ସମର୍ପିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ତସ୍ମାତ୍ ପିତରୋକଥଯତ୍ ହେ ଅନାନିଯ ଭୂମେ ର୍ମୂଲ୍ୟଂ କିଞ୍ଚିତ୍ ସଙ୍ଗୋପ୍ୟ ସ୍ଥାପଯିତୁଂ ପୱିତ୍ରସ୍ୟାତ୍ମନଃ ସନ୍ନିଧୌ ମୃଷାୱାକ୍ୟଂ କଥଯିତୁଞ୍ଚ ଶୈତାନ୍ କୁତସ୍ତୱାନ୍ତଃକରଣେ ପ୍ରୱୃତ୍ତିମଜନଯତ୍? ");
INSERT INTO sanori_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","ସା ଭୂମି ର୍ୟଦା ତୱ ହସ୍ତଗତା ତଦା କିଂ ତୱ ସ୍ୱୀଯା ନାସୀତ୍? ତର୍ହି ସ୍ୱାନ୍ତଃକରଣେ କୁତ ଏତାଦୃଶୀ କୁକଲ୍ପନା ତ୍ୱଯା କୃତା? ତ୍ୱଂ କେୱଲମନୁଷ୍ୟସ୍ୟ ନିକଟେ ମୃଷାୱାକ୍ୟଂ ନାୱାଦୀଃ କିନ୍ତ୍ୱୀଶ୍ୱରସ୍ୟ ନିକଟେଽପି| ");
INSERT INTO sanori_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ଏତାଂ କଥାଂ ଶ୍ରୁତ୍ୱୈୱ ସୋଽନାନିଯୋ ଭୂମୌ ପତନ୍ ପ୍ରାଣାନ୍ ଅତ୍ୟଜତ୍, ତଦ୍ୱୃତ୍ତାନ୍ତଂ ଯାୱନ୍ତୋ ଲୋକା ଅଶୃଣ୍ୱନ୍ ତେଷାଂ ସର୍ୱ୍ୱେଷାଂ ମହାଭଯମ୍ ଅଜାଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","ତଦା ଯୁୱଲୋକାସ୍ତଂ ୱସ୍ତ୍ରେଣାଚ୍ଛାଦ୍ୟ ବହି ର୍ନୀତ୍ୱା ଶ୍ମଶାନେଽସ୍ଥାପଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","ତତଃ ପ୍ରହରୈକାନନ୍ତରଂ କିଂ ୱୃତ୍ତଂ ତନ୍ନାୱଗତ୍ୟ ତସ୍ୟ ଭାର୍ୟ୍ୟାପି ତତ୍ର ସମୁପସ୍ଥିତା| ");
INSERT INTO sanori_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ତତଃ ପିତରସ୍ତାମ୍ ଅପୃଚ୍ଛତ୍, ଯୁୱାଭ୍ୟାମ୍ ଏତାୱନ୍ମୁଦ୍ରାଭ୍ୟୋ ଭୂମି ର୍ୱିକ୍ରୀତା ନ ୱା? ଏତତ୍ୱଂ ୱଦ; ତଦା ସା ପ୍ରତ୍ୟୱାଦୀତ୍ ସତ୍ୟମ୍ ଏତାୱଦ୍ଭ୍ୟୋ ମୁଦ୍ରାଭ୍ୟ ଏୱ| ");
INSERT INTO sanori_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ତତଃ ପିତରୋକଥଯତ୍ ଯୁୱାଂ କଥଂ ପରମେଶ୍ୱରସ୍ୟାତ୍ମାନଂ ପରୀକ୍ଷିତୁମ୍ ଏକମନ୍ତ୍ରଣାୱଭୱତାଂ? ପଶ୍ୟ ଯେ ତୱ ପତିଂ ଶ୍ମଶାନେ ସ୍ଥାପିତୱନ୍ତସ୍ତେ ଦ୍ୱାରସ୍ୟ ସମୀପେ ସମୁପତିଷ୍ଠନ୍ତି ତ୍ୱାମପି ବହିର୍ନେଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ତତଃ ସାପି ତସ୍ୟ ଚରଣସନ୍ନିଧୌ ପତିତ୍ୱା ପ୍ରାଣାନ୍ ଅତ୍ୟାକ୍ଷୀତ୍| ପଶ୍ଚାତ୍ ତେ ଯୁୱାନୋଽଭ୍ୟନ୍ତରମ୍ ଆଗତ୍ୟ ତାମପି ମୃତାଂ ଦୃଷ୍ଟ୍ୱା ବହି ର୍ନୀତ୍ୱା ତସ୍ୟାଃ ପତ୍ୟୁଃ ପାର୍ଶ୍ୱେ ଶ୍ମଶାନେ ସ୍ଥାପିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","ତସ୍ମାତ୍ ମଣ୍ଡଲ୍ୟାଃ ସର୍ୱ୍ୱେ ଲୋକା ଅନ୍ୟଲୋକାଶ୍ଚ ତାଂ ୱାର୍ତ୍ତାଂ ଶ୍ରୁତ୍ୱା ସାଧ୍ୱସଂ ଗତାଃ| ");
INSERT INTO sanori_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","ତତଃ ପରଂ ପ୍ରେରିତାନାଂ ହସ୍ତୈ ର୍ଲୋକାନାଂ ମଧ୍ୟେ ବହ୍ୱାଶ୍ଚର୍ୟ୍ୟାଣ୍ୟଦ୍ଭୁତାନି କର୍ମ୍ମାଣ୍ୟକ୍ରିଯନ୍ତ; ତଦା ଶିଷ୍ୟାଃ ସର୍ୱ୍ୱ ଏକଚିତ୍ତୀଭୂଯ ସୁଲେମାନୋ ଽଲିନ୍ଦେ ସମ୍ଭୂଯାସନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","ତେଷାଂ ସଙ୍ଘାନ୍ତର୍ଗୋ ଭୱିତୁଂ କୋପି ପ୍ରଗଲ୍ଭତାଂ ନାଗମତ୍ କିନ୍ତୁ ଲୋକାସ୍ତାନ୍ ସମାଦ୍ରିଯନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","ସ୍ତ୍ରିଯଃ ପୁରୁଷାଶ୍ଚ ବହୱୋ ଲୋକା ୱିଶ୍ୱାସ୍ୟ ପ୍ରଭୁଂ ଶରଣମାପନ୍ନାଃ| ");
INSERT INTO sanori_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","ପିତରସ୍ୟ ଗମନାଗମନାଭ୍ୟାଂ କେନାପି ପ୍ରକାରେଣ ତସ୍ୟ ଛାଯା କସ୍ମିଂଶ୍ଚିଜ୍ଜନେ ଲଗିଷ୍ୟତୀତ୍ୟାଶଯା ଲୋକା ରୋଗିଣଃ ଶିୱିକଯା ଖଟ୍ୱଯା ଚାନୀଯ ପଥି ପଥି ସ୍ଥାପିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","ଚତୁର୍ଦିକ୍ସ୍ଥନଗରେଭ୍ୟୋ ବହୱୋ ଲୋକାଃ ସମ୍ଭୂଯ ରୋଗିଣୋଽପୱିତ୍ରଭୁତଗ୍ରସ୍ତାଂଶ୍ଚ ଯିରୂଶାଲମମ୍ ଆନଯନ୍ ତତଃ ସର୍ୱ୍ୱେ ସ୍ୱସ୍ଥା ଅକ୍ରିଯନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","ଅନନ୍ତରଂ ମହାଯାଜକଃ ସିଦୂକିନାଂ ମତଗ୍ରାହିଣସ୍ତେଷାଂ ସହଚରାଶ୍ଚ ");
INSERT INTO sanori_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ମହାକ୍ରୋଧାନ୍ତ୍ୱିତାଃ ସନ୍ତଃ ପ୍ରେରିତାନ୍ ଧୃତ୍ୱା ନୀଚଲୋକାନାଂ କାରାଯାଂ ବଦ୍ଧ୍ୱା ସ୍ଥାପିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","କିନ୍ତୁ ରାତ୍ରୌ ପରମେଶ୍ୱରସ୍ୟ ଦୂତଃ କାରାଯା ଦ୍ୱାରଂ ମୋଚଯିତ୍ୱା ତାନ୍ ବହିରାନୀଯାକଥଯତ୍, ");
INSERT INTO sanori_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","ଯୂଯଂ ଗତ୍ୱା ମନ୍ଦିରେ ଦଣ୍ଡାଯମାନାଃ ସନ୍ତୋ ଲୋକାନ୍ ପ୍ରତୀମାଂ ଜୀୱନଦାଯିକାଂ ସର୍ୱ୍ୱାଂ କଥାଂ ପ୍ରଚାରଯତ| ");
INSERT INTO sanori_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ଇତି ଶ୍ରୁତ୍ୱା ତେ ପ୍ରତ୍ୟୂଷେ ମନ୍ଦିର ଉପସ୍ଥାଯ ଉପଦିଷ୍ଟୱନ୍ତଃ| ତଦା ସହଚରଗଣେନ ସହିତୋ ମହାଯାଜକ ଆଗତ୍ୟ ମନ୍ତ୍ରିଗଣମ୍ ଇସ୍ରାଯେଲ୍ୱଂଶସ୍ୟ ସର୍ୱ୍ୱାନ୍ ରାଜସଭାସଦଃ ସଭାସ୍ଥାନ୍ କୃତ୍ୱା କାରାଯାସ୍ତାନ୍ ଆପଯିତୁଂ ପଦାତିଗଣଂ ପ୍ରେରିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","ତତସ୍ତେ ଗତ୍ୱା କାରାଯାଂ ତାନ୍ ଅପ୍ରାପ୍ୟ ପ୍ରତ୍ୟାଗତ୍ୟ ଇତି ୱାର୍ତ୍ତାମ୍ ଅୱାଦିଷୁଃ, ");
INSERT INTO sanori_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ୱଯଂ ତତ୍ର ଗତ୍ୱା ନିର୍ୱ୍ୱିଘ୍ନଂ କାରାଯା ଦ୍ୱାରଂ ରୁଦ୍ଧଂ ରକ୍ଷକାଂଶ୍ଚ ଦ୍ୱାରସ୍ୟ ବହିର୍ଦଣ୍ଡାଯମାନାନ୍ ଅଦର୍ଶାମ ଏୱ କିନ୍ତୁ ଦ୍ୱାରଂ ମୋଚଯିତ୍ୱା ତନ୍ମଧ୍ୟେ କମପି ଦ୍ରଷ୍ଟୁଂ ନ ପ୍ରାପ୍ତାଃ| ");
INSERT INTO sanori_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ଏତାଂ କଥାଂ ଶ୍ରୁତ୍ୱା ମହାଯାଜକୋ ମନ୍ଦିରସ୍ୟ ସେନାପତିଃ ପ୍ରଧାନଯାଜକାଶ୍ଚ, ଇତ ପରଂ କିମପରଂ ଭୱିଷ୍ୟତୀତି ଚିନ୍ତଯିତ୍ୱା ସନ୍ଦିଗ୍ଧଚିତ୍ତା ଅଭୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ଏତସ୍ମିନ୍ନେୱ ସମଯେ କଶ୍ଚିତ୍ ଜନ ଆଗତ୍ୟ ୱାର୍ତ୍ତାମେତାମ୍ ଅୱଦତ୍ ପଶ୍ୟତ ଯୂଯଂ ଯାନ୍ ମାନୱାନ୍ କାରାଯାମ୍ ଅସ୍ଥାପଯତ ତେ ମନ୍ଦିରେ ତିଷ୍ଠନ୍ତୋ ଲୋକାନ୍ ଉପଦିଶନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","ତଦା ମନ୍ଦିରସ୍ୟ ସେନାପତିଃ ପଦାତଯଶ୍ଚ ତତ୍ର ଗତ୍ୱା ଚେଲ୍ଲୋକାଃ ପାଷାଣାନ୍ ନିକ୍ଷିପ୍ୟାସ୍ମାନ୍ ମାରଯନ୍ତୀତି ଭିଯା ୱିନତ୍ୟାଚାରଂ ତାନ୍ ଆନଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","ତେ ମହାସଭାଯା ମଧ୍ୟେ ତାନ୍ ଅସ୍ଥାପଯନ୍ ତତଃ ପରଂ ମହାଯାଜକସ୍ତାନ୍ ଅପୃଚ୍ଛତ୍, ");
INSERT INTO sanori_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","ଅନେନ ନାମ୍ନା ସମୁପଦେଷ୍ଟୁଂ ୱଯଂ କିଂ ଦୃଢଂ ନ ନ୍ୟଷେଧାମ? ତଥାପି ପଶ୍ୟତ ଯୂଯଂ ସ୍ୱେଷାଂ ତେନୋପଦେଶେନେ ଯିରୂଶାଲମଂ ପରିପୂର୍ଣଂ କୃତ୍ୱା ତସ୍ୟ ଜନସ୍ୟ ରକ୍ତପାତଜନିତାପରାଧମ୍ ଅସ୍ମାନ୍ ପ୍ରତ୍ୟାନେତୁଂ ଚେଷ୍ଟଧ୍ୱେ| ");
INSERT INTO sanori_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","ତତଃ ପିତରୋନ୍ୟପ୍ରେରିତାଶ୍ଚ ପ୍ରତ୍ୟୱଦନ୍ ମାନୁଷସ୍ୟାଜ୍ଞାଗ୍ରହଣାଦ୍ ଈଶ୍ୱରସ୍ୟାଜ୍ଞାଗ୍ରହଣମ୍ ଅସ୍ମାକମୁଚିତମ୍| ");
INSERT INTO sanori_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","ଯଂ ଯୀଶୁଂ ଯୂଯଂ କ୍ରୁଶେ ୱେଧିତ୍ୱାହତ ତମ୍ ଅସ୍ମାକଂ ପୈତୃକ ଈଶ୍ୱର ଉତ୍ଥାପ୍ୟ ");
INSERT INTO sanori_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ଇସ୍ରାଯେଲ୍ୱଂଶାନାଂ ମନଃପରିୱର୍ତ୍ତନଂ ପାପକ୍ଷମାଞ୍ଚ କର୍ତ୍ତୁଂ ରାଜାନଂ ପରିତ୍ରାତାରଞ୍ଚ କୃତ୍ୱା ସ୍ୱଦକ୍ଷିଣପାର୍ଶ୍ୱେ ତସ୍ୟାନ୍ନତିମ୍ ଅକରୋତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ଏତସ୍ମିନ୍ ୱଯମପି ସାକ୍ଷିଣ ଆସ୍ମହେ, ତତ୍ କେୱଲଂ ନହି, ଈଶ୍ୱର ଆଜ୍ଞାଗ୍ରାହିଭ୍ୟୋ ଯଂ ପୱିତ୍ରମ୍ ଆତ୍ମନଂ ଦତ୍ତୱାନ୍ ସୋପି ସାକ୍ଷ୍ୟସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","ଏତଦ୍ୱାକ୍ୟେ ଶ୍ରୁତେ ତେଷାଂ ହୃଦଯାନି ୱିଦ୍ଧାନ୍ୟଭୱନ୍ ତତସ୍ତେ ତାନ୍ ହନ୍ତୁଂ ମନ୍ତ୍ରିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ଏତସ୍ମିନ୍ନେୱ ସମଯେ ତତ୍ସଭାସ୍ଥାନାଂ ସର୍ୱ୍ୱଲୋକାନାଂ ମଧ୍ୟେ ସୁଖ୍ୟାତୋ ଗମିଲୀଯେଲ୍ନାମକ ଏକୋ ଜନୋ ୱ୍ୟୱସ୍ଥାପକଃ ଫିରୂଶିଲୋକ ଉତ୍ଥାଯ ପ୍ରେରିତାନ୍ କ୍ଷଣାର୍ଥଂ ସ୍ଥାନାନ୍ତରଂ ଗନ୍ତୁମ୍ ଆଦିଶ୍ୟ କଥିତୱାନ୍, ");
INSERT INTO sanori_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ହେ ଇସ୍ରାଯେଲ୍ୱଂଶୀଯାଃ ସର୍ୱ୍ୱେ ଯୂଯମ୍ ଏତାନ୍ ମାନୁଷାନ୍ ପ୍ରତି ଯତ୍ କର୍ତ୍ତୁମ୍ ଉଦ୍ୟତାସ୍ତସ୍ମିନ୍ ସାୱଧାନା ଭୱତ| ");
INSERT INTO sanori_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","ଇତଃ ପୂର୍ୱ୍ୱଂ ଥୂଦାନାମୈକୋ ଜନ ଉପସ୍ଥାଯ ସ୍ୱଂ କମପି ମହାପୁରୁଷମ୍ ଅୱଦତ୍, ତତଃ ପ୍ରାଯେଣ ଚତୁଃଶତଲୋକାସ୍ତସ୍ୟ ମତଗ୍ରାହିଣୋଭୱନ୍ ପଶ୍ଚାତ୍ ସ ହତୋଭୱତ୍ ତସ୍ୟାଜ୍ଞାଗ୍ରାହିଣୋ ଯାୱନ୍ତୋ ଲୋକାସ୍ତେ ସର୍ୱ୍ୱେ ୱିର୍କୀର୍ଣାଃ ସନ୍ତୋ ଽକୃତକାର୍ୟ୍ୟା ଅଭୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","ତସ୍ମାଜ୍ଜନାତ୍ ପରଂ ନାମଲେଖନସମଯେ ଗାଲୀଲୀଯଯିହୂଦାନାମୈକୋ ଜନ ଉପସ୍ଥାଯ ବହୂଲ୍ଲୋକାନ୍ ସ୍ୱମତଂ ଗ୍ରାହୀତୱାନ୍ ତତଃ ସୋପି ୱ୍ୟନଶ୍ୟତ୍ ତସ୍ୟାଜ୍ଞାଗ୍ରାହିଣୋ ଯାୱନ୍ତୋ ଲୋକା ଆସନ୍ ତେ ସର୍ୱ୍ୱେ ୱିକୀର୍ଣା ଅଭୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","ଅଧୁନା ୱଦାମି, ଯୂଯମ୍ ଏତାନ୍ ମନୁଷ୍ୟାନ୍ ପ୍ରତି କିମପି ନ କୃତ୍ୱା କ୍ଷାନ୍ତା ଭୱତ, ଯତ ଏଷ ସଙ୍କଲ୍ପ ଏତତ୍ କର୍ମ୍ମ ଚ ଯଦି ମନୁଷ୍ୟାଦଭୱତ୍ ତର୍ହି ୱିଫଲଂ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ଯଦୀଶ୍ୱରାଦଭୱତ୍ ତର୍ହି ଯୂଯଂ ତସ୍ୟାନ୍ୟଥା କର୍ତ୍ତୁଂ ନ ଶକ୍ଷ୍ୟଥ, ୱରମ୍ ଈଶ୍ୱରରୋଧକା ଭୱିଷ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ତଦା ତସ୍ୟ ମନ୍ତ୍ରଣାଂ ସ୍ୱୀକୃତ୍ୟ ତେ ପ୍ରେରିତାନ୍ ଆହୂଯ ପ୍ରହୃତ୍ୟ ଯୀଶୋ ର୍ନାମ୍ନା କାମପି କଥାଂ କଥଯିତୁଂ ନିଷିଧ୍ୟ ୱ୍ୟସର୍ଜନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","କିନ୍ତୁ ତସ୍ୟ ନାମାର୍ଥଂ ୱଯଂ ଲଜ୍ଜାଭୋଗସ୍ୟ ଯୋଗ୍ୟତ୍ୱେନ ଗଣିତା ଇତ୍ୟତ୍ର ତେ ସାନନ୍ଦାଃ ସନ୍ତଃ ସଭାସ୍ଥାନାଂ ସାକ୍ଷାଦ୍ ଅଗଚ୍ଛନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ତତଃ ପରଂ ପ୍ରତିଦିନଂ ମନ୍ଦିରେ ଗୃହେ ଗୃହେ ଚାୱିଶ୍ରାମମ୍ ଉପଦିଶ୍ୟ ଯୀଶୁଖ୍ରୀଷ୍ଟସ୍ୟ ସୁସଂୱାଦଂ ପ୍ରଚାରିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","ତସ୍ମିନ୍ ସମଯେ ଶିଷ୍ୟାଣାଂ ବାହୁଲ୍ୟାତ୍ ପ୍ରାତ୍ୟହିକଦାନସ୍ୟ ୱିଶ୍ରାଣନୈ ର୍ଭିନ୍ନଦେଶୀଯାନାଂ ୱିଧୱାସ୍ତ୍ରୀଗଣ ଉପେକ୍ଷିତେ ସତି ଇବ୍ରୀଯଲୋକୈଃ ସହାନ୍ୟଦେଶୀଯାନାଂ ୱିୱାଦ ଉପାତିଷ୍ଠତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","ତଦା ଦ୍ୱାଦଶପ୍ରେରିତାଃ ସର୍ୱ୍ୱାନ୍ ଶିଷ୍ୟାନ୍ ସଂଗୃହ୍ୟାକଥଯନ୍ ଈଶ୍ୱରସ୍ୟ କଥାପ୍ରଚାରଂ ପରିତ୍ୟଜ୍ୟ ଭୋଜନଗୱେଷଣମ୍ ଅସ୍ମାକମ୍ ଉଚିତଂ ନହି| ");
INSERT INTO sanori_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ଅତୋ ହେ ଭ୍ରାତୃଗଣ ୱଯମ୍ ଏତତ୍କର୍ମ୍ମଣୋ ଭାରଂ ଯେଭ୍ୟୋ ଦାତୁଂ ଶକ୍ନୁମ ଏତାଦୃଶାନ୍ ସୁଖ୍ୟାତ୍ୟାପନ୍ନାନ୍ ପୱିତ୍ରେଣାତ୍ମନା ଜ୍ଞାନେନ ଚ ପୂର୍ଣାନ୍ ସପ୍ପ୍ରଜନାନ୍ ଯୂଯଂ ସ୍ୱେଷାଂ ମଧ୍ୟେ ମନୋନୀତାନ୍ କୁରୁତ, ");
INSERT INTO sanori_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","କିନ୍ତୁ ୱଯଂ ପ୍ରାର୍ଥନାଯାଂ କଥାପ୍ରଚାରକର୍ମ୍ମଣି ଚ ନିତ୍ୟପ୍ରୱୃତ୍ତାଃ ସ୍ଥାସ୍ୟାମଃ| ");
INSERT INTO sanori_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ଏତସ୍ୟାଂ କଥାଯାଂ ସର୍ୱ୍ୱେ ଲୋକାଃ ସନ୍ତୁଷ୍ଟାଃ ସନ୍ତଃ ସ୍ୱେଷାଂ ମଧ୍ୟାତ୍ ସ୍ତିଫାନଃ ଫିଲିପଃ ପ୍ରଖରୋ ନିକାନୋର୍ ତୀମନ୍ ପର୍ମ୍ମିଣା ଯିହୂଦିମତଗ୍ରାହୀ-ଆନ୍ତିଯଖିଯାନଗରୀଯୋ ନିକଲା ଏତାନ୍ ପରମଭକ୍ତାନ୍ ପୱିତ୍ରେଣାତ୍ମନା ପରିପୂର୍ଣାନ୍ ସପ୍ତ ଜନାନ୍ ");
INSERT INTO sanori_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ପ୍ରେରିତାନାଂ ସମକ୍ଷମ୍ ଆନଯନ୍, ତତସ୍ତେ ପ୍ରାର୍ଥନାଂ କୃତ୍ୱା ତେଷାଂ ଶିରଃସୁ ହସ୍ତାନ୍ ଆର୍ପଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","ଅପରଞ୍ଚ ଈଶ୍ୱରସ୍ୟ କଥା ଦେଶଂ ୱ୍ୟାପ୍ନୋତ୍ ୱିଶେଷତୋ ଯିରୂଶାଲମି ନଗରେ ଶିଷ୍ୟାଣାଂ ସଂଖ୍ୟା ପ୍ରଭୂତରୂପେଣାୱର୍ଦ୍ଧତ ଯାଜକାନାଂ ମଧ୍ୟେପି ବହୱଃ ଖ୍ରୀଷ୍ଟମତଗ୍ରାହିଣୋଽଭୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","ସ୍ତିଫାନୋे ୱିଶ୍ୱାସେନ ପରାକ୍ରମେଣ ଚ ପରିପୂର୍ଣଃ ସନ୍ ଲୋକାନାଂ ମଧ୍ୟେ ବହୁୱିଧମ୍ ଅଦ୍ଭୁତମ୍ ଆଶ୍ଚର୍ୟ୍ୟଂ କର୍ମ୍ମାକରୋତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","ତେନ ଲିବର୍ତ୍ତିନୀଯନାମ୍ନା ୱିଖ୍ୟାତସଙ୍ଘସ୍ୟ କତିପଯଜନାଃ କୁରୀଣୀଯସିକନ୍ଦରୀଯ-କିଲିକୀଯାଶୀଯାଦେଶୀଯାଃ କିଯନ୍ତୋ ଜନାଶ୍ଚୋତ୍ଥାଯ ସ୍ତିଫାନେନ ସାର୍ଦ୍ଧଂ ୱ୍ୟୱଦନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","କିନ୍ତୁ ସ୍ତିଫାନୋ ଜ୍ଞାନେନ ପୱିତ୍ରେଣାତ୍ମନା ଚ ଈଦୃଶୀଂ କଥାଂ କଥିତୱାନ୍ ଯସ୍ୟାସ୍ତେ ଆପତ୍ତିଂ କର୍ତ୍ତୁଂ ନାଶକ୍ନୁୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","ପଶ୍ଚାତ୍ ତୈ ର୍ଲୋଭିତାଃ କତିପଯଜନାଃ କଥାମେନାମ୍ ଅକଥଯନ୍, ୱଯଂ ତସ୍ୟ ମୁଖତୋ ମୂସା ଈଶ୍ୱରସ୍ୟ ଚ ନିନ୍ଦାୱାକ୍ୟମ୍ ଅଶ୍ରୌଷ୍ମ| ");
INSERT INTO sanori_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ତେ ଲୋକାନାଂ ଲୋକପ୍ରାଚୀନାନାମ୍ ଅଧ୍ୟାପକାନାଞ୍ଚ ପ୍ରୱୃତ୍ତିଂ ଜନଯିତ୍ୱା ସ୍ତିଫାନସ୍ୟ ସନ୍ନିଧିମ୍ ଆଗତ୍ୟ ତଂ ଧୃତ୍ୱା ମହାସଭାମଧ୍ୟମ୍ ଆନଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ତଦନନ୍ତରଂ କତିପଯଜନେଷୁ ମିଥ୍ୟାସାକ୍ଷିଷୁ ସମାନୀତେଷୁ ତେଽକଥଯନ୍ ଏଷ ଜନ ଏତତ୍ପୁଣ୍ୟସ୍ଥାନୱ୍ୟୱସ୍ଥଯୋ ର୍ନିନ୍ଦାତଃ କଦାପି ନ ନିୱର୍ତ୍ତତେ| ");
INSERT INTO sanori_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ଫଲତୋ ନାସରତୀଯଯୀଶୁଃ ସ୍ଥାନମେତଦ୍ ଉଚ୍ଛିନ୍ନଂ କରିଷ୍ୟତି ମୂସାସମର୍ପିତମ୍ ଅସ୍ମାକଂ ୱ୍ୟୱହରଣମ୍ ଅନ୍ୟରୂପଂ କରିଷ୍ୟତି ତସ୍ୟୈତାଦୃଶୀଂ କଥାଂ ୱଯମ୍ ଅଶୃଣୁମ| ");
INSERT INTO sanori_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","ତଦା ମହାସଭାସ୍ଥାଃ ସର୍ୱ୍ୱେ ତଂ ପ୍ରତି ସ୍ଥିରାଂ ଦୃଷ୍ଟିଂ କୃତ୍ୱା ସ୍ୱର୍ଗଦୂତମୁଖସଦୃଶଂ ତସ୍ୟ ମୁଖମ୍ ଅପଶ୍ୟନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ତତଃ ପରଂ ମହାଯାଜକଃ ପୃଷ୍ଟୱାନ୍, ଏଷା କଥାଂ କିଂ ସତ୍ୟା? ");
INSERT INTO sanori_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","ତତଃ ସ ପ୍ରତ୍ୟୱଦତ୍, ହେ ପିତରୋ ହେ ଭ୍ରାତରଃ ସର୍ୱ୍ୱେ ଲାକା ମନାଂସି ନିଧଦ୍ଧ୍ୱଂ| ଅସ୍ମାକଂ ପୂର୍ୱ୍ୱପୁରୁଷ ଇବ୍ରାହୀମ୍ ହାରଣ୍ନଗରେ ୱାସକରଣାତ୍ ପୂର୍ୱ୍ୱଂ ଯଦା ଅରାମ୍-ନହରଯିମଦେଶେ ଆସୀତ୍ ତଦା ତେଜୋମଯ ଈଶ୍ୱରୋ ଦର୍ଶନଂ ଦତ୍ୱା ");
INSERT INTO sanori_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ତମୱଦତ୍ ତ୍ୱଂ ସ୍ୱଦେଶଜ୍ଞାତିମିତ୍ରାଣି ପରିତ୍ୟଜ୍ୟ ଯଂ ଦେଶମହଂ ଦର୍ଶଯିଷ୍ୟାମି ତଂ ଦେଶଂ ୱ୍ରଜ| ");
INSERT INTO sanori_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","ଅତଃ ସ କସ୍ଦୀଯଦେଶଂ ୱିହାଯ ହାରଣ୍ନଗରେ ନ୍ୟୱସତ୍, ତଦନନ୍ତରଂ ତସ୍ୟ ପିତରି ମୃତେ ଯତ୍ର ଦେଶେ ଯୂଯଂ ନିୱସଥ ସ ଏନଂ ଦେଶମାଗଚ୍ଛତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","କିନ୍ତ୍ୱୀଶ୍ୱରସ୍ତସ୍ମୈ କମପ୍ୟଧିକାରମ୍ ଅର୍ଥାଦ୍ ଏକପଦପରିମିତାଂ ଭୂମିମପି ନାଦଦାତ୍; ତଦା ତସ୍ୟ କୋପି ସନ୍ତାନୋ ନାସୀତ୍ ତଥାପି ସନ୍ତାନୈଃ ସାର୍ଦ୍ଧମ୍ ଏତସ୍ୟ ଦେଶସ୍ୟାଧିକାରୀ ତ୍ୱଂ ଭୱିଷ୍ୟସୀତି ତମ୍ପ୍ରତ୍ୟଙ୍ଗୀକୃତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ଈଶ୍ୱର ଇତ୍ଥମ୍ ଅପରମପି କଥିତୱାନ୍ ତୱ ସନ୍ତାନାଃ ପରଦେଶେ ନିୱତ୍ସ୍ୟନ୍ତି ତତସ୍ତଦ୍ଦେଶୀଯଲୋକାଶ୍ଚତୁଃଶତୱତ୍ସରାନ୍ ଯାୱତ୍ ତାନ୍ ଦାସତ୍ୱେ ସ୍ଥାପଯିତ୍ୱା ତାନ୍ ପ୍ରତି କୁୱ୍ୟୱହାରଂ କରିଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","ଅପରମ୍ ଈଶ୍ୱର ଏନାଂ କଥାମପି କଥିତୱାନ୍, ଯେ ଲୋକାସ୍ତାନ୍ ଦାସତ୍ୱେ ସ୍ଥାପଯିଷ୍ୟନ୍ତି ତାଲ୍ଲୋକାନ୍ ଅହଂ ଦଣ୍ଡଯିଷ୍ୟାମି, ତତଃ ପରଂ ତେ ବହିର୍ଗତାଃ ସନ୍ତୋ ମାମ୍ ଅତ୍ର ସ୍ଥାନେ ସେୱିଷ୍ୟନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","ପଶ୍ଚାତ୍ ସ ତସ୍ମୈ ତ୍ୱକ୍ଛେଦସ୍ୟ ନିଯମଂ ଦତ୍ତୱାନ୍, ଅତ ଇସ୍ହାକନାମ୍ନି ଇବ୍ରାହୀମ ଏକପୁତ୍ରେ ଜାତେ, ଅଷ୍ଟମଦିନେ ତସ୍ୟ ତ୍ୱକ୍ଛେଦମ୍ ଅକରୋତ୍| ତସ୍ୟ ଇସ୍ହାକଃ ପୁତ୍ରୋ ଯାକୂବ୍, ତତସ୍ତସ୍ୟ ଯାକୂବୋଽସ୍ମାକଂ ଦ୍ୱାଦଶ ପୂର୍ୱ୍ୱପୁରୁଷା ଅଜାଯନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","ତେ ପୂର୍ୱ୍ୱପୁରୁଷା ଈର୍ଷ୍ୟଯା ପରିପୂର୍ଣା ମିସରଦେଶଂ ପ୍ରେଷଯିତୁଂ ଯୂଷଫଂ ୱ୍ୟକ୍ରୀଣନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","କିନ୍ତ୍ୱୀଶ୍ୱରସ୍ତସ୍ୟ ସହାଯୋ ଭୂତ୍ୱା ସର୍ୱ୍ୱସ୍ୟା ଦୁର୍ଗତେ ରକ୍ଷିତ୍ୱା ତସ୍ମୈ ବୁଦ୍ଧିଂ ଦତ୍ତ୍ୱା ମିସରଦେଶସ୍ୟ ରାଜ୍ଞଃ ଫିରୌଣଃ ପ୍ରିଯପାତ୍ରଂ କୃତୱାନ୍ ତତୋ ରାଜା ମିସରଦେଶସ୍ୟ ସ୍ୱୀଯସର୍ୱ୍ୱପରିୱାରସ୍ୟ ଚ ଶାସନପଦଂ ତସ୍ମୈ ଦତ୍ତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","ତସ୍ମିନ୍ ସମଯେ ମିସର-କିନାନଦେଶଯୋ ର୍ଦୁର୍ଭିକ୍ଷହେତୋରତିକ୍ଲିଷ୍ଟତ୍ୱାତ୍ ନଃ ପୂର୍ୱ୍ୱପୁରୁଷା ଭକ୍ଷ୍ୟଦ୍ରୱ୍ୟଂ ନାଲଭନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","କିନ୍ତୁ ମିସରଦେଶେ ଶସ୍ୟାନି ସନ୍ତି, ଯାକୂବ୍ ଇମାଂ ୱାର୍ତ୍ତାଂ ଶ୍ରୁତ୍ୱା ପ୍ରଥମମ୍ ଅସ୍ମାକଂ ପୂର୍ୱ୍ୱପୁରୁଷାନ୍ ମିସରଂ ପ୍ରେଷିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ତତୋ ଦ୍ୱିତୀଯୱାରଗମନେ ଯୂଷଫ୍ ସ୍ୱଭ୍ରାତୃଭିଃ ପରିଚିତୋଽଭୱତ୍; ଯୂଷଫୋ ଭ୍ରାତରଃ ଫିରୌଣ୍ ରାଜେନ ପରିଚିତା ଅଭୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","ଅନନ୍ତରଂ ଯୂଷଫ୍ ଭ୍ରାତୃଗଣଂ ପ୍ରେଷ୍ୟ ନିଜପିତରଂ ଯାକୂବଂ ନିଜାନ୍ ପଞ୍ଚାଧିକସପ୍ତତିସଂଖ୍ୟକାନ୍ ଜ୍ଞାତିଜନାଂଶ୍ଚ ସମାହୂତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","ତସ୍ମାଦ୍ ଯାକୂବ୍ ମିସରଦେଶଂ ଗତ୍ୱା ସ୍ୱଯମ୍ ଅସ୍ମାକଂ ପୂର୍ୱ୍ୱପୁରୁଷାଶ୍ଚ ତସ୍ମିନ୍ ସ୍ଥାନେଽମ୍ରିଯନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ତତସ୍ତେ ଶିଖିମଂ ନୀତା ଯତ୍ ଶ୍ମଶାନମ୍ ଇବ୍ରାହୀମ୍ ମୁଦ୍ରାଦତ୍ୱା ଶିଖିମଃ ପିତୁ ର୍ହମୋରଃ ପୁତ୍ରେଭ୍ୟଃ କ୍ରୀତୱାନ୍ ତତ୍ଶ୍ମଶାନେ ସ୍ଥାପଯାଞ୍ଚକ୍ରିରେ| ");
INSERT INTO sanori_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","ତତଃ ପରମ୍ ଈଶ୍ୱର ଇବ୍ରାହୀମଃ ସନ୍ନିଧୌ ଶପଥଂ କୃତ୍ୱା ଯାଂ ପ୍ରତିଜ୍ଞାଂ କୃତୱାନ୍ ତସ୍ୟାଃ ପ୍ରତିଜ୍ଞାଯାଃ ଫଲନସମଯେ ନିକଟେ ସତି ଇସ୍ରାଯେଲ୍ଲୋକା ସିମରଦେଶେ ୱର୍ଦ୍ଧମାନା ବହୁସଂଖ୍ୟା ଅଭୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ଶେଷେ ଯୂଷଫଂ ଯୋ ନ ପରିଚିନୋତି ତାଦୃଶ ଏକୋ ନରପତିରୁପସ୍ଥାଯ ");
INSERT INTO sanori_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ଅସ୍ମାକଂ ଜ୍ଞାତିଭିଃ ସାର୍ଦ୍ଧଂ ଧୂର୍ତ୍ତତାଂ ୱିଧାଯ ପୂର୍ୱ୍ୱପୁରୁଷାନ୍ ପ୍ରତି କୁୱ୍ୟୱହରଣପୂର୍ୱ୍ୱକଂ ତେଷାଂ ୱଂଶନାଶନାଯ ତେଷାଂ ନୱଜାତାନ୍ ଶିଶୂନ୍ ବହି ର୍ନିରକ୍ଷେପଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","ଏତସ୍ମିନ୍ ସମଯେ ମୂସା ଜଜ୍ଞେ, ସ ତୁ ପରମସୁନ୍ଦରୋଽଭୱତ୍ ତଥା ପିତୃଗୃହେ ମାସତ୍ରଯପର୍ୟ୍ୟନ୍ତଂ ପାଲିତୋଽଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","କିନ୍ତୁ ତସ୍ମିନ୍ ବହିର୍ନିକ୍ଷିପ୍ତେ ସତି ଫିରୌଣରାଜସ୍ୟ କନ୍ୟା ତମ୍ ଉତ୍ତୋଲ୍ୟ ନୀତ୍ୱା ଦତ୍ତକପୁତ୍ରଂ କୃତ୍ୱା ପାଲିତୱତୀ| ");
INSERT INTO sanori_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","ତସ୍ମାତ୍ ସ ମୂସା ମିସରଦେଶୀଯାଯାଃ ସର୍ୱ୍ୱୱିଦ୍ୟାଯାଃ ପାରଦୃଷ୍ୱା ସନ୍ ୱାକ୍ୟେ କ୍ରିଯାଯାଞ୍ଚ ଶକ୍ତିମାନ୍ ଅଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","ସ ସମ୍ପୂର୍ଣଚତ୍ୱାରିଂଶଦ୍ୱତ୍ସରୱଯସ୍କୋ ଭୂତ୍ୱା ଇସ୍ରାଯେଲୀଯୱଂଶନିଜଭ୍ରାତୃନ୍ ସାକ୍ଷାତ୍ କର୍ତୁଂ ମତିଂ ଚକ୍ରେ| ");
INSERT INTO sanori_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","ତେଷାଂ ଜନମେକଂ ହିଂସିତଂ ଦୃଷ୍ଟ୍ୱା ତସ୍ୟ ସପକ୍ଷଃ ସନ୍ ହିଂସିତଜନମ୍ ଉପକୃତ୍ୟ ମିସରୀଯଜନଂ ଜଘାନ| ");
INSERT INTO sanori_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ତସ୍ୟ ହସ୍ତେନେଶ୍ୱରସ୍ତାନ୍ ଉଦ୍ଧରିଷ୍ୟତି ତସ୍ୟ ଭ୍ରାତୃଗଣ ଇତି ଜ୍ଞାସ୍ୟତି ସ ଇତ୍ୟନୁମାନଂ ଚକାର, କିନ୍ତୁ ତେ ନ ବୁବୁଧିରେ| ");
INSERT INTO sanori_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","ତତ୍ପରେ ଽହନି ତେଷାମ୍ ଉଭଯୋ ର୍ଜନଯୋ ର୍ୱାକ୍କଲହ ଉପସ୍ଥିତେ ସତି ମୂସାଃ ସମୀପଂ ଗତ୍ୱା ତଯୋ ର୍ମେଲନଂ କର୍ତ୍ତୁଂ ମତିଂ କୃତ୍ୱା କଥଯାମାସ, ହେ ମହାଶଯୌ ଯୁୱାଂ ଭ୍ରାତରୌ ପରସ୍ପରମ୍ ଅନ୍ୟାଯଂ କୁତଃ କୁରୁଥଃ? ");
INSERT INTO sanori_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","ତତଃ ସମୀପୱାସିନଂ ପ୍ରତି ଯୋ ଜନୋଽନ୍ୟାଯଂ ଚକାର ସ ତଂ ଦୂରୀକୃତ୍ୟ କଥଯାମାସ, ଅସ୍ମାକମୁପରି ଶାସ୍ତୃତ୍ୱୱିଚାରଯିତୃତ୍ୱପଦଯୋଃ କସ୍ତ୍ୱାଂ ନିଯୁକ୍ତୱାନ୍? ");
INSERT INTO sanori_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","ହ୍ୟୋ ଯଥା ମିସରୀଯଂ ହତୱାନ୍ ତଥା କିଂ ମାମପି ହନିଷ୍ୟସି? ");
INSERT INTO sanori_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ତଦା ମୂସା ଏତାଦୃଶୀଂ କଥାଂ ଶ୍ରୁତ୍ୱା ପଲାଯନଂ ଚକ୍ରେ, ତତୋ ମିଦିଯନଦେଶଂ ଗତ୍ୱା ପ୍ରୱାସୀ ସନ୍ ତସ୍ଥୌ, ତତସ୍ତତ୍ର ଦ୍ୱୌ ପୁତ୍ରୌ ଜଜ୍ଞାତେ| ");
INSERT INTO sanori_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","ଅନନ୍ତରଂ ଚତ୍ୱାରିଂଶଦ୍ୱତ୍ସରେଷୁ ଗତେଷୁ ସୀନଯପର୍ୱ୍ୱତସ୍ୟ ପ୍ରାନ୍ତରେ ପ୍ରଜ୍ୱଲିତସ୍ତମ୍ବସ୍ୟ ୱହ୍ନିଶିଖାଯାଂ ପରମେଶ୍ୱରଦୂତସ୍ତସ୍ମୈ ଦର୍ଶନଂ ଦଦୌ| ");
INSERT INTO sanori_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","ମୂସାସ୍ତସ୍ମିନ୍ ଦର୍ଶନେ ୱିସ୍ମଯଂ ମତ୍ୱା ୱିଶେଷଂ ଜ୍ଞାତୁଂ ନିକଟଂ ଗଚ୍ଛତି, ");
INSERT INTO sanori_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","ଏତସ୍ମିନ୍ ସମଯେ, ଅହଂ ତୱ ପୂର୍ୱ୍ୱପୁରୁଷାଣାମ୍ ଈଶ୍ୱରୋଽର୍ଥାଦ୍ ଇବ୍ରାହୀମ ଈଶ୍ୱର ଇସ୍ହାକ ଈଶ୍ୱରୋ ଯାକୂବ ଈଶ୍ୱରଶ୍ଚ, ମୂସାମୁଦ୍ଦିଶ୍ୟ ପରମେଶ୍ୱରସ୍ୟୈତାଦୃଶୀ ୱିହାଯସୀଯା ୱାଣୀ ବଭୂୱ, ତତଃ ସ କମ୍ପାନ୍ୱିତଃ ସନ୍ ପୁନ ର୍ନିରୀକ୍ଷିତୁଂ ପ୍ରଗଲ୍ଭୋ ନ ବଭୂୱ| ");
INSERT INTO sanori_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","ପରମେଶ୍ୱରସ୍ତଂ ଜଗାଦ, ତୱ ପାଦଯୋଃ ପାଦୁକେ ମୋଚଯ ଯତ୍ର ତିଷ୍ଠସି ସା ପୱିତ୍ରଭୂମିଃ| ");
INSERT INTO sanori_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ଅହଂ ମିସରଦେଶସ୍ଥାନାଂ ନିଜଲୋକାନାଂ ଦୁର୍ଦ୍ଦଶାଂ ନିତାନ୍ତମ୍ ଅପଶ୍ୟଂ, ତେଷାଂ କାତର୍ୟ୍ୟୋକ୍ତିଞ୍ଚ ଶ୍ରୁତୱାନ୍ ତସ୍ମାତ୍ ତାନ୍ ଉଦ୍ଧର୍ତ୍ତୁମ୍ ଅୱରୁହ୍ୟାଗମମ୍; ଇଦାନୀମ୍ ଆଗଚ୍ଛ ମିସରଦେଶଂ ତ୍ୱାଂ ପ୍ରେଷଯାମି| ");
INSERT INTO sanori_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","କସ୍ତ୍ୱାଂ ଶାସ୍ତୃତ୍ୱୱିଚାରଯିତୃତ୍ୱପଦଯୋ ର୍ନିଯୁକ୍ତୱାନ୍, ଇତି ୱାକ୍ୟମୁକ୍ତ୍ୱା ତୈ ର୍ୟୋ ମୂସା ଅୱଜ୍ଞାତସ୍ତମେୱ ଈଶ୍ୱରଃ ସ୍ତମ୍ବମଧ୍ୟେ ଦର୍ଶନଦାତ୍ରା ତେନ ଦୂତେନ ଶାସ୍ତାରଂ ମୁକ୍ତିଦାତାରଞ୍ଚ କୃତ୍ୱା ପ୍ରେଷଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","ସ ଚ ମିସରଦେଶେ ସୂଫ୍ନାମ୍ନି ସମୁଦ୍ରେ ଚ ପଶ୍ଚାତ୍ ଚତ୍ୱାରିଂଶଦ୍ୱତ୍ସରାନ୍ ଯାୱତ୍ ମହାପ୍ରାନ୍ତରେ ନାନାପ୍ରକାରାଣ୍ୟଦ୍ଭୁତାନି କର୍ମ୍ମାଣି ଲକ୍ଷଣାନି ଚ ଦର୍ଶଯିତ୍ୱା ତାନ୍ ବହିଃ କୃତ୍ୱା ସମାନିନାଯ| ");
INSERT INTO sanori_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","ପ୍ରଭୁଃ ପରମେଶ୍ୱରୋ ଯୁଷ୍ମାକଂ ଭ୍ରାତୃଗଣସ୍ୟ ମଧ୍ୟେ ମାଦୃଶମ୍ ଏକଂ ଭୱିଷ୍ୟଦ୍ୱକ୍ତାରମ୍ ଉତ୍ପାଦଯିଷ୍ୟତି ତସ୍ୟ କଥାଯାଂ ଯୂଯଂ ମନୋ ନିଧାସ୍ୟଥ, ଯୋ ଜନ ଇସ୍ରାଯେଲଃ ସନ୍ତାନେଭ୍ୟ ଏନାଂ କଥାଂ କଥଯାମାସ ସ ଏଷ ମୂସାଃ| ");
INSERT INTO sanori_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","ମହାପ୍ରାନ୍ତରସ୍ଥମଣ୍ଡଲୀମଧ୍ୟେଽପି ସ ଏୱ ସୀନଯପର୍ୱ୍ୱତୋପରି ତେନ ସାର୍ଦ୍ଧଂ ସଂଲାପିନୋ ଦୂତସ୍ୟ ଚାସ୍ମତ୍ପିତୃଗଣସ୍ୟ ମଧ୍ୟସ୍ଥଃ ସନ୍ ଅସ୍ମଭ୍ୟଂ ଦାତୱ୍ୟନି ଜୀୱନଦାଯକାନି ୱାକ୍ୟାନି ଲେଭେ| ");
INSERT INTO sanori_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","ଅସ୍ମାକଂ ପୂର୍ୱ୍ୱପୁରୁଷାସ୍ତମ୍ ଅମାନ୍ୟଂ କତ୍ୱା ସ୍ୱେଭ୍ୟୋ ଦୂରୀକୃତ୍ୟ ମିସରଦେଶଂ ପରାୱୃତ୍ୟ ଗନ୍ତୁଂ ମନୋଭିରଭିଲଷ୍ୟ ହାରୋଣଂ ଜଗଦୁଃ, ");
INSERT INTO sanori_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ଅସ୍ମାକମ୍ ଅଗ୍ରେଽଗ୍ରେ ଗନ୍ତୁुମ୍ ଅସ୍ମଦର୍ଥଂ ଦେୱଗଣଂ ନିର୍ମ୍ମାହି ଯତୋ ଯୋ ମୂସା ଅସ୍ମାନ୍ ମିସରଦେଶାଦ୍ ବହିଃ କୃତ୍ୱାନୀତୱାନ୍ ତସ୍ୟ କିଂ ଜାତଂ ତଦସ୍ମାଭି ର୍ନ ଜ୍ଞାଯତେ| ");
INSERT INTO sanori_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","ତସ୍ମିନ୍ ସମଯେ ତେ ଗୋୱତ୍ସାକୃତିଂ ପ୍ରତିମାଂ ନିର୍ମ୍ମାଯ ତାମୁଦ୍ଦିଶ୍ୟ ନୈୱେଦ୍ୟମୁତ୍ମୃଜ୍ୟ ସ୍ୱହସ୍ତକୃତୱସ୍ତୁନା ଆନନ୍ଦିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","ତସ୍ମାଦ୍ ଈଶ୍ୱରସ୍ତେଷାଂ ପ୍ରତି ୱିମୁଖଃ ସନ୍ ଆକାଶସ୍ଥଂ ଜ୍ୟୋତିର୍ଗଣଂ ପୂଜଯିତୁଂ ତେଭ୍ୟୋଽନୁମତିଂ ଦଦୌ, ଯାଦୃଶଂ ଭୱିଷ୍ୟଦ୍ୱାଦିନାଂ ଗ୍ରନ୍ଥେଷୁ ଲିଖିତମାସ୍ତେ, ଯଥା, ଇସ୍ରାଯେଲୀଯୱଂଶା ରେ ଚତ୍ୱାରିଂଶତ୍ସମାନ୍ ପୁରା| ମହତି ପ୍ରାନ୍ତରେ ସଂସ୍ଥା ଯୂଯନ୍ତୁ ଯାନି ଚ| ବଲିହୋମାଦିକର୍ମ୍ମାଣି କୃତୱନ୍ତସ୍ତୁ ତାନି କିଂ| ମାଂ ସମୁଦ୍ଦିଶ୍ୟ ଯୁଷ୍ମାଭିଃ ପ୍ରକୃତାନୀତି ନୈୱ ଚ| ");
INSERT INTO sanori_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","କିନ୍ତୁ ୱୋ ମୋଲକାଖ୍ୟସ୍ୟ ଦେୱସ୍ୟ ଦୂଷ୍ୟମେୱ ଚ| ଯୁଷ୍ମାକଂ ରିମ୍ଫନାଖ୍ୟାଯା ଦେୱତାଯାଶ୍ଚ ତାରକା| ଏତଯୋରୁଭଯୋ ର୍ମୂର୍ତୀ ଯୁଷ୍ମାଭିଃ ପରିପୂଜିତେ| ଅତୋ ଯୁଷ୍ମାଂସ୍ତୁ ବାବେଲଃ ପାରଂ ନେଷ୍ୟାମି ନିଶ୍ଚିତଂ| ");
INSERT INTO sanori_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","ଅପରଞ୍ଚ ଯନ୍ନିଦର୍ଶନମ୍ ଅପଶ୍ୟସ୍ତଦନୁସାରେଣ ଦୂଷ୍ୟଂ ନିର୍ମ୍ମାହି ଯସ୍ମିନ୍ ଈଶ୍ୱରୋ ମୂସାମ୍ ଏତଦ୍ୱାକ୍ୟଂ ବଭାଷେ ତତ୍ ତସ୍ୟ ନିରୂପିତଂ ସାକ୍ଷ୍ୟସ୍ୱରୂପଂ ଦୂଷ୍ୟମ୍ ଅସ୍ମାକଂ ପୂର୍ୱ୍ୱପୁରୁଷୈଃ ସହ ପ୍ରାନ୍ତରେ ତସ୍ଥୌ| ");
INSERT INTO sanori_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","ପଶ୍ଚାତ୍ ଯିହୋଶୂଯେନ ସହିତୈସ୍ତେଷାଂ ୱଂଶଜାତୈରସ୍ମତ୍ପୂର୍ୱ୍ୱପୁରୁଷୈଃ ସ୍ୱେଷାଂ ସମ୍ମୁଖାଦ୍ ଈଶ୍ୱରେଣ ଦୂରୀକୃତାନାମ୍ ଅନ୍ୟଦେଶୀଯାନାଂ ଦେଶାଧିକୃତିକାଲେ ସମାନୀତଂ ତଦ୍ ଦୂଷ୍ୟଂ ଦାଯୂଦୋଧିକାରଂ ଯାୱତ୍ ତତ୍ର ସ୍ଥାନ ଆସୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ସ ଦାଯୂଦ୍ ପରମେଶ୍ୱରସ୍ୟାନୁଗ୍ରହଂ ପ୍ରାପ୍ୟ ଯାକୂବ୍ ଈଶ୍ୱରାର୍ଥମ୍ ଏକଂ ଦୂଷ୍ୟଂ ନିର୍ମ୍ମାତୁଂ ୱୱାଞ୍ଛ; ");
INSERT INTO sanori_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","କିନ୍ତୁ ସୁଲେମାନ୍ ତଦର୍ଥଂ ମନ୍ଦିରମ୍ ଏକଂ ନିର୍ମ୍ମିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","ତଥାପି ଯଃ ସର୍ୱ୍ୱୋପରିସ୍ଥଃ ସ କସ୍ମିଂଶ୍ଚିଦ୍ ହସ୍ତକୃତେ ମନ୍ଦିରେ ନିୱସତୀତି ନହି, ଭୱିଷ୍ୟଦ୍ୱାଦୀ କଥାମେତାଂ କଥଯତି, ଯଥା, ");
INSERT INTO sanori_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","ପରେଶୋ ୱଦତି ସ୍ୱର୍ଗୋ ରାଜସିଂହାସନଂ ମମ| ମଦୀଯଂ ପାଦପୀଠଞ୍ଚ ପୃଥିୱୀ ଭୱତି ଧ୍ରୁୱଂ| ତର୍ହି ଯୂଯଂ କୃତେ ମେ କିଂ ପ୍ରନିର୍ମ୍ମାସ୍ୟଥ ମନ୍ଦିରଂ| ୱିଶ୍ରାମାଯ ମଦୀଯଂ ୱା ସ୍ଥାନଂ କିଂ ୱିଦ୍ୟତେ ତ୍ୱିହ| ");
INSERT INTO sanori_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","ସର୍ୱ୍ୱାଣ୍ୟେତାନି ୱସ୍ତୂନି କିଂ ମେ ହସ୍ତକୃତାନି ନ|| ");
INSERT INTO sanori_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","ହେ ଅନାଜ୍ଞାଗ୍ରାହକା ଅନ୍ତଃକରଣେ ଶ୍ରୱଣେ ଚାପୱିତ୍ରଲୋକାଃ ଯୂଯମ୍ ଅନୱରତଂ ପୱିତ୍ରସ୍ୟାତ୍ମନଃ ପ୍ରାତିକୂଲ୍ୟମ୍ ଆଚରଥ, ଯୁଷ୍ମାକଂ ପୂର୍ୱ୍ୱପୁରୁଷା ଯାଦୃଶା ଯୂଯମପି ତାଦୃଶାଃ| ");
INSERT INTO sanori_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","ଯୁଷ୍ମାକଂ ପୂର୍ୱ୍ୱପୁରୁଷାଃ କଂ ଭୱିଷ୍ୟଦ୍ୱାଦିନଂ ନାତାଡଯନ୍? ଯେ ତସ୍ୟ ଧାର୍ମ୍ମିକସ୍ୟ ଜନସ୍ୟାଗମନକଥାଂ କଥିତୱନ୍ତସ୍ତାନ୍ ଅଘ୍ନନ୍ ଯୂଯମ୍ ଅଧୂନା ୱିଶ୍ୱାସଘାତିନୋ ଭୂତ୍ୱା ତଂ ଧାର୍ମ୍ମିକଂ ଜନମ୍ ଅହତ| ");
INSERT INTO sanori_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","ଯୂଯଂ ସ୍ୱର୍ଗୀଯଦୂତଗଣେନ ୱ୍ୟୱସ୍ଥାଂ ପ୍ରାପ୍ୟାପି ତାଂ ନାଚରଥ| ");
INSERT INTO sanori_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ଇମାଂ କଥାଂ ଶ୍ରୁତ୍ୱା ତେ ମନଃସୁ ବିଦ୍ଧାଃ ସନ୍ତସ୍ତଂ ପ୍ରତି ଦନ୍ତଘର୍ଷଣମ୍ ଅକୁର୍ୱ୍ୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","କିନ୍ତୁ ସ୍ତିଫାନଃ ପୱିତ୍ରେଣାତ୍ମନା ପୂର୍ଣୋ ଭୂତ୍ୱା ଗଗଣଂ ପ୍ରତି ସ୍ଥିରଦୃଷ୍ଟିଂ କୃତ୍ୱା ଈଶ୍ୱରସ୍ୟ ଦକ୍ଷିଣେ ଦଣ୍ଡାଯମାନଂ ଯୀଶୁଞ୍ଚ ୱିଲୋକ୍ୟ କଥିତୱାନ୍; ");
INSERT INTO sanori_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","ପଶ୍ୟ,ମେଘଦ୍ୱାରଂ ମୁକ୍ତମ୍ ଈଶ୍ୱରସ୍ୟ ଦକ୍ଷିଣେ ସ୍ଥିତଂ ମାନୱସୁତଞ୍ଚ ପଶ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","ତଦା ତେ ପ୍ରୋଚ୍ଚୈଃ ଶବ୍ଦଂ କୃତ୍ୱା କର୍ଣେଷ୍ୱଙ୍ଗୁଲୀ ର୍ନିଧାଯ ଏକଚିତ୍ତୀଭୂଯ ତମ୍ ଆକ୍ରମନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ପଶ୍ଚାତ୍ ତଂ ନଗରାଦ୍ ବହିଃ କୃତ୍ୱା ପ୍ରସ୍ତରୈରାଘ୍ନନ୍ ସାକ୍ଷିଣୋ ଲାକାଃ ଶୌଲନାମ୍ନୋ ଯୂନଶ୍ଚରଣସନ୍ନିଧୌ ନିଜୱସ୍ତ୍ରାଣି ସ୍ଥାପିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","ଅନନ୍ତରଂ ହେ ପ୍ରଭୋ ଯୀଶେ ମଦୀଯମାତ୍ମାନଂ ଗୃହାଣ ସ୍ତିଫାନସ୍ୟେତି ପ୍ରାର୍ଥନୱାକ୍ୟୱଦନସମଯେ ତେ ତଂ ପ୍ରସ୍ତରୈରାଘ୍ନନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ତସ୍ମାତ୍ ସ ଜାନୁନୀ ପାତଯିତ୍ୱା ପ୍ରୋଚ୍ଚୈଃ ଶବ୍ଦଂ କୃତ୍ୱା, ହେ ପ୍ରଭେ ପାପମେତଦ୍ ଏତେଷୁ ମା ସ୍ଥାପଯ, ଇତ୍ୟୁକ୍ତ୍ୱା ମହାନିଦ୍ରାଂ ପ୍ରାପ୍ନୋତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","ତସ୍ୟ ହତ୍ୟାକରଣଂ ଶୌଲୋପି ସମମନ୍ୟତ| ତସ୍ମିନ୍ ସମଯେ ଯିରୂଶାଲମ୍ନଗରସ୍ଥାଂ ମଣ୍ଡଲୀଂ ପ୍ରତି ମହାତାଡନାଯାଂ ଜାତାଯାଂ ପ୍ରେରିତଲୋକାନ୍ ହିତ୍ୱା ସର୍ୱ୍ୱେଽପରେ ଯିହୂଦାଶୋମିରୋଣଦେଶଯୋ ର୍ନାନାସ୍ଥାନେ ୱିକୀର୍ଣାଃ ସନ୍ତୋ ଗତାଃ| ");
INSERT INTO sanori_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","ଅନ୍ୟଚ୍ଚ ଭକ୍ତଲୋକାସ୍ତଂ ସ୍ତିଫାନଂ ଶ୍ମଶାନେ ସ୍ଥାପଯିତ୍ୱା ବହୁ ୱ୍ୟଲପନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","କିନ୍ତୁ ଶୌଲୋ ଗୃହେ ଗୃହେ ଭ୍ରମିତ୍ୱା ସ୍ତ୍ରିଯଃ ପୁରୁଷାଂଶ୍ଚ ଧୃତ୍ୱା କାରାଯାଂ ବଦ୍ଧ୍ୱା ମଣ୍ଡଲ୍ୟା ମହୋତ୍ପାତଂ କୃତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","ଅନ୍ୟଚ୍ଚ ଯେ ୱିକୀର୍ଣା ଅଭୱନ୍ ତେ ସର୍ୱ୍ୱତ୍ର ଭ୍ରମିତ୍ୱା ସୁସଂୱାଦଂ ପ୍ରାଚାରଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ତଦା ଫିଲିପଃ ଶୋମିରୋଣ୍ନଗରଂ ଗତ୍ୱା ଖ୍ରୀଷ୍ଟାଖ୍ୟାନଂ ପ୍ରାଚାରଯତ୍; ");
INSERT INTO sanori_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ତତୋଽଶୁଚି-ଭୃତଗ୍ରସ୍ତଲୋକେଭ୍ୟୋ ଭୂତାଶ୍ଚୀତ୍କୃତ୍ୟାଗଚ୍ଛନ୍ ତଥା ବହୱଃ ପକ୍ଷାଘାତିନଃ ଖଞ୍ଜା ଲୋକାଶ୍ଚ ସ୍ୱସ୍ଥା ଅଭୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","ତସ୍ମାତ୍ ଲାକା ଈଦୃଶଂ ତସ୍ୟାଶ୍ଚର୍ୟ୍ୟଂ କର୍ମ୍ମ ୱିଲୋକ୍ୟ ନିଶମ୍ୟ ଚ ସର୍ୱ୍ୱ ଏକଚିତ୍ତୀଭୂଯ ତେନୋକ୍ତାଖ୍ୟାନେ ମନାଂସି ନ୍ୟଦଧୁଃ| ");
INSERT INTO sanori_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","ତସ୍ମିନ୍ନଗରେ ମହାନନ୍ଦଶ୍ଚାଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ତତଃ ପୂର୍ୱ୍ୱଂ ତସ୍ମିନ୍ନଗରେ ଶିମୋନ୍ନାମା କଶ୍ଚିଜ୍ଜନୋ ବହ୍ୱୀ ର୍ମାଯାକ୍ରିଯାଃ କୃତ୍ୱା ସ୍ୱଂ କଞ୍ଚନ ମହାପୁରୁଷଂ ପ୍ରୋଚ୍ୟ ଶୋମିରୋଣୀଯାନାଂ ମୋହଂ ଜନଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ତସ୍ମାତ୍ ସ ମାନୁଷ ଈଶ୍ୱରସ୍ୟ ମହାଶକ୍ତିସ୍ୱରୂପ ଇତ୍ୟୁକ୍ତ୍ୱା ବାଲୱୃଦ୍ଧୱନିତାଃ ସର୍ୱ୍ୱେ ଲାକାସ୍ତସ୍ମିନ୍ ମନାଂସି ନ୍ୟଦଧୁଃ| ");
INSERT INTO sanori_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ସ ବହୁକାଲାନ୍ ମାଯାୱିକ୍ରିଯଯା ସର୍ୱ୍ୱାନ୍ ଅତୀୱ ମୋହଯାଞ୍ଚକାର, ତସ୍ମାତ୍ ତେ ତଂ ମେନିରେ| ");
INSERT INTO sanori_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","କିନ୍ତ୍ୱୀଶ୍ୱରସ୍ୟ ରାଜ୍ୟସ୍ୟ ଯୀଶୁଖ୍ରୀଷ୍ଟସ୍ୟ ନାମ୍ନଶ୍ଚାଖ୍ୟାନପ୍ରଚାରିଣଃ ଫିଲିପସ୍ୟ କଥାଯାଂ ୱିଶ୍ୱସ୍ୟ ତେଷାଂ ସ୍ତ୍ରୀପୁରୁଷୋଭଯଲୋକା ମଜ୍ଜିତା ଅଭୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ଶେଷେ ସ ଶିମୋନପି ସ୍ୱଯଂ ପ୍ରତ୍ୟୈତ୍ ତତୋ ମଜ୍ଜିତଃ ସନ୍ ଫିଲିପେନ କୃତାମ୍ ଆଶ୍ଚର୍ୟ୍ୟକ୍ରିଯାଂ ଲକ୍ଷଣଞ୍ଚ ୱିଲୋକ୍ୟାସମ୍ଭୱଂ ମନ୍ୟମାନସ୍ତେନ ସହ ସ୍ଥିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ଇତ୍ଥଂ ଶୋମିରୋଣ୍ଦେଶୀଯଲୋକା ଈଶ୍ୱରସ୍ୟ କଥାମ୍ ଅଗୃହ୍ଲନ୍ ଇତି ୱାର୍ତ୍ତାଂ ଯିରୂଶାଲମ୍ନଗରସ୍ଥପ୍ରେରିତାଃ ପ୍ରାପ୍ୟ ପିତରଂ ଯୋହନଞ୍ଚ ତେଷାଂ ନିକଟେ ପ୍ରେଷିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ତତସ୍ତୌ ତତ୍ ସ୍ଥାନମ୍ ଉପସ୍ଥାଯ ଲୋକା ଯଥା ପୱିତ୍ରମ୍ ଆତ୍ମାନଂ ପ୍ରାପ୍ନୁୱନ୍ତି ତଦର୍ଥଂ ପ୍ରାର୍ଥଯେତାଂ| ");
INSERT INTO sanori_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ଯତସ୍ତେ ପୁରା କେୱଲପ୍ରଭୁଯୀଶୋ ର୍ନାମ୍ନା ମଜ୍ଜିତମାତ୍ରା ଅଭୱନ୍, ନ ତୁ ତେଷାଂ ମଧ୍ୟେ କମପି ପ୍ରତି ପୱିତ୍ରସ୍ୟାତ୍ମନ ଆୱିର୍ଭାୱୋ ଜାତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","କିନ୍ତୁ ପ୍ରେରିତାଭ୍ୟାଂ ତେଷାଂ ଗାତ୍ରେଷୁ କରେଷ୍ୱର୍ପିତେଷୁ ସତ୍ସୁ ତେ ପୱିତ୍ରମ୍ ଆତ୍ମାନମ୍ ପ୍ରାପ୍ନୁୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","ଇତ୍ଥଂ ଲୋକାନାଂ ଗାତ୍ରେଷୁ ପ୍ରେରିତଯୋଃ କରାର୍ପଣେନ ତାନ୍ ପୱିତ୍ରମ୍ ଆତ୍ମାନଂ ପ୍ରାପ୍ତାନ୍ ଦୃଷ୍ଟ୍ୱା ସ ଶିମୋନ୍ ତଯୋଃ ସମୀପେ ମୁଦ୍ରା ଆନୀଯ କଥିତୱାନ୍; ");
INSERT INTO sanori_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ଅହଂ ଯସ୍ୟ ଗାତ୍ରେ ହସ୍ତମ୍ ଅର୍ପଯିଷ୍ୟାମି ତସ୍ୟାପି ଯଥେତ୍ଥଂ ପୱିତ୍ରାତ୍ମପ୍ରାପ୍ତି ର୍ଭୱତି ତାଦୃଶୀଂ ଶକ୍ତିଂ ମହ୍ୟଂ ଦତ୍ତଂ| ");
INSERT INTO sanori_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","କିନ୍ତୁ ପିତରସ୍ତଂ ପ୍ରତ୍ୟୱଦତ୍ ତୱ ମୁଦ୍ରାସ୍ତ୍ୱଯା ୱିନଶ୍ୟନ୍ତୁ ଯତ ଈଶ୍ୱରସ୍ୟ ଦାନଂ ମୁଦ୍ରାଭିଃ କ୍ରୀଯତେ ତ୍ୱମିତ୍ଥଂ ବୁଦ୍ଧୱାନ୍; ");
INSERT INTO sanori_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ଈଶ୍ୱରାଯ ତାୱନ୍ତଃକରଣଂ ସରଲଂ ନହି, ତସ୍ମାଦ୍ ଅତ୍ର ତୱାଂଶୋଽଧିକାରଶ୍ଚ କୋପି ନାସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ଅତ ଏତତ୍ପାପହେତୋଃ ଖେଦାନ୍ୱିତଃ ସନ୍ କେନାପି ପ୍ରକାରେଣ ତୱ ମନସ ଏତସ୍ୟାଃ କୁକଲ୍ପନାଯାଃ କ୍ଷମା ଭୱତି, ଏତଦର୍ଥମ୍ ଈଶ୍ୱରେ ପ୍ରାର୍ଥନାଂ କୁରୁ; ");
INSERT INTO sanori_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","ଯତସ୍ତ୍ୱଂ ତିକ୍ତପିତ୍ତେ ପାପସ୍ୟ ବନ୍ଧନେ ଚ ଯଦସି ତନ୍ମଯା ବୁଦ୍ଧମ୍| ");
INSERT INTO sanori_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","ତଦା ଶିମୋନ୍ ଅକଥଯତ୍ ତର୍ହି ଯୁୱାଭ୍ୟାମୁଦିତା କଥା ମଯି ଯଥା ନ ଫଲତି ତଦର୍ଥଂ ଯୁୱାଂ ମନ୍ନିମିତ୍ତଂ ପ୍ରଭୌ ପ୍ରାର୍ଥନାଂ କୁରୁତଂ| ");
INSERT INTO sanori_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","ଅନେନ ପ୍ରକାରେଣ ତୌ ସାକ୍ଷ୍ୟଂ ଦତ୍ତ୍ୱା ପ୍ରଭୋଃ କଥାଂ ପ୍ରଚାରଯନ୍ତୌ ଶୋମିରୋଣୀଯାନାମ୍ ଅନେକଗ୍ରାମେଷୁ ସୁସଂୱାଦଞ୍ଚ ପ୍ରଚାରଯନ୍ତୌ ଯିରୂଶାଲମ୍ନଗରଂ ପରାୱୃତ୍ୟ ଗତୌ| ");
INSERT INTO sanori_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ତତଃ ପରମ୍ ଈଶ୍ୱରସ୍ୟ ଦୂତଃ ଫିଲିପମ୍ ଇତ୍ୟାଦିଶତ୍, ତ୍ୱମୁତ୍ଥାଯ ଦକ୍ଷିଣସ୍ୟାଂ ଦିଶି ଯୋ ମାର୍ଗୋ ପ୍ରାନ୍ତରସ୍ୟ ମଧ୍ୟେନ ଯିରୂଶାଲମୋ ଽସାନଗରଂ ଯାତି ତଂ ମାର୍ଗଂ ଗଚ୍ଛ| ");
INSERT INTO sanori_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ତତଃ ସ ଉତ୍ଥାଯ ଗତୱାନ୍; ତଦା କନ୍ଦାକୀନାମ୍ନଃ କୂଶ୍ଲୋକାନାଂ ରାଜ୍ଞ୍ୟାଃ ସର୍ୱ୍ୱସମ୍ପତ୍ତେରଧୀଶଃ କୂଶଦେଶୀଯ ଏକଃ ଷଣ୍ଡୋ ଭଜନାର୍ଥଂ ଯିରୂଶାଲମ୍ନଗରମ୍ ଆଗତ୍ୟ ");
INSERT INTO sanori_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ପୁନରପି ରଥମାରୁହ୍ୟ ଯିଶଯିଯନାମ୍ନୋ ଭୱିଷ୍ୟଦ୍ୱାଦିନୋ ଗ୍ରନ୍ଥଂ ପଠନ୍ ପ୍ରତ୍ୟାଗଚ୍ଛତି| ");
INSERT INTO sanori_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ଏତସ୍ମିନ୍ ସମଯେ ଆତ୍ମା ଫିଲିପମ୍ ଅୱଦତ୍, ତ୍ୱମ୍ ରଥସ୍ୟ ସମୀପଂ ଗତ୍ୱା ତେନ ସାର୍ଦ୍ଧଂ ମିଲ| ");
INSERT INTO sanori_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","ତସ୍ମାତ୍ ସ ଧାୱନ୍ ତସ୍ୟ ସନ୍ନିଧାୱୁପସ୍ଥାଯ ତେନ ପଠ୍ୟମାନଂ ଯିଶଯିଯଥୱିଷ୍ୟଦ୍ୱାଦିନୋ ୱାକ୍ୟଂ ଶ୍ରୁତ୍ୱା ପୃଷ୍ଟୱାନ୍ ଯତ୍ ପଠସି ତତ୍ କିଂ ବୁଧ୍ୟସେ? ");
INSERT INTO sanori_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","ତତଃ ସ କଥିତୱାନ୍ କେନଚିନ୍ନ ବୋଧିତୋହଂ କଥଂ ବୁଧ୍ୟେଯ? ତତଃ ସ ଫିଲିପଂ ରଥମାରୋଢୁଂ ସ୍ୱେନ ସାର୍ଦ୍ଧମ୍ ଉପୱେଷ୍ଟୁଞ୍ଚ ନ୍ୟୱେଦଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ସ ଶାସ୍ତ୍ରସ୍ୟେତଦ୍ୱାକ୍ୟଂ ପଠିତୱାନ୍ ଯଥା, ସମାନୀଯତ ଘାତାଯ ସ ଯଥା ମେଷଶାୱକଃ| ଲୋମଚ୍ଛେଦକସାକ୍ଷାଚ୍ଚ ମେଷଶ୍ଚ ନୀରୱୋ ଯଥା| ଆବଧ୍ୟ ୱଦନଂ ସ୍ୱୀଯଂ ତଥା ସ ସମତିଷ୍ଠତ| ");
INSERT INTO sanori_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ଅନ୍ୟାଯେନ ୱିଚାରେଣ ସ ଉଚ୍ଛିନ୍ନୋ ଽଭୱତ୍ ତଦା| ତତ୍କାଲୀନମନୁଷ୍ୟାନ୍ କୋ ଜନୋ ୱର୍ଣଯିତୁଂ କ୍ଷମଃ| ଯତୋ ଜୀୱନ୍ନୃଣାଂ ଦେଶାତ୍ ସ ଉଚ୍ଛିନ୍ନୋ ଽଭୱତ୍ ଧ୍ରୁୱଂ| ");
INSERT INTO sanori_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","ଅନନ୍ତରଂ ସ ଫିଲିପମ୍ ଅୱଦତ୍ ନିୱେଦଯାମି, ଭୱିଷ୍ୟଦ୍ୱାଦୀ ଯାମିମାଂ କଥାଂ କଥଯାମାସ ସ କିଂ ସ୍ୱସ୍ମିନ୍ ୱା କସ୍ମିଂଶ୍ଚିଦ୍ ଅନ୍ୟସ୍ମିନ୍? ");
INSERT INTO sanori_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ତତଃ ଫିଲିପସ୍ତତ୍ପ୍ରକରଣମ୍ ଆରଭ୍ୟ ଯୀଶୋରୁପାଖ୍ୟାନଂ ତସ୍ୟାଗ୍ରେ ପ୍ରାସ୍ତୌତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ଇତ୍ଥଂ ମାର୍ଗେଣ ଗଚ୍ଛନ୍ତୌ ଜଲାଶଯସ୍ୟ ସମୀପ ଉପସ୍ଥିତୌ; ତଦା କ୍ଲୀବୋଽୱାଦୀତ୍ ପଶ୍ୟାତ୍ର ସ୍ଥାନେ ଜଲମାସ୍ତେ ମମ ମଜ୍ଜନେ କା ବାଧା? ");
INSERT INTO sanori_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","ତତଃ ଫିଲିପ ଉତ୍ତରଂ ୱ୍ୟାହରତ୍ ସ୍ୱାନ୍ତଃକରଣେନ ସାକଂ ଯଦି ପ୍ରତ୍ୟେଷି ତର୍ହି ବାଧା ନାସ୍ତି| ତତଃ ସ କଥିତୱାନ୍ ଯୀଶୁଖ୍ରୀଷ୍ଟ ଈଶ୍ୱରସ୍ୟ ପୁତ୍ର ଇତ୍ୟହଂ ପ୍ରତ୍ୟେମି| ");
INSERT INTO sanori_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","ତଦା ରଥଂ ସ୍ଥଗିତଂ କର୍ତ୍ତୁମ୍ ଆଦିଷ୍ଟେ ଫିଲିପକ୍ଲୀବୌ ଦ୍ୱୌ ଜଲମ୍ ଅୱାରୁହତାଂ; ତଦା ଫିଲିପସ୍ତମ୍ ମଜ୍ଜଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","ତତ୍ପଶ୍ଚାତ୍ ଜଲମଧ୍ୟାଦ୍ ଉତ୍ଥିତଯୋଃ ସତୋଃ ପରମେଶ୍ୱରସ୍ୟାତ୍ମା ଫିଲିପଂ ହୃତ୍ୱା ନୀତୱାନ୍, ତସ୍ମାତ୍ କ୍ଲୀବଃ ପୁନସ୍ତଂ ନ ଦୃଷ୍ଟୱାନ୍ ତଥାପି ହୃଷ୍ଟଚିତ୍ତଃ ସନ୍ ସ୍ୱମାର୍ଗେଣ ଗତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ଫିଲିପଶ୍ଚାସ୍ଦୋଦ୍ନଗରମ୍ ଉପସ୍ଥାଯ ତସ୍ମାତ୍ କୈସରିଯାନଗର ଉପସ୍ଥିତିକାଲପର୍ୟ୍ୟନତଂ ସର୍ୱ୍ୱସ୍ମିନ୍ନଗରେ ସୁସଂୱାଦଂ ପ୍ରଚାରଯନ୍ ଗତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","ତତ୍କାଲପର୍ୟ୍ୟନତଂ ଶୌଲଃ ପ୍ରଭୋଃ ଶିଷ୍ୟାଣାଂ ପ୍ରାତିକୂଲ୍ୟେନ ତାଡନାବଧଯୋଃ କଥାଂ ନିଃସାରଯନ୍ ମହାଯାଜକସ୍ୟ ସନ୍ନିଧିଂ ଗତ୍ୱା ");
INSERT INTO sanori_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ସ୍ତ୍ରିଯଂ ପୁରୁଷଞ୍ଚ ତନ୍ମତଗ୍ରାହିଣଂ ଯଂ କଞ୍ଚିତ୍ ପଶ୍ୟତି ତାନ୍ ଧୃତ୍ୱା ବଦ୍ଧ୍ୱା ଯିରୂଶାଲମମ୍ ଆନଯତୀତ୍ୟାଶଯେନ ଦମ୍ମେଷକ୍ନଗରୀଯଂ ଧର୍ମ୍ମସମାଜାନ୍ ପ୍ରତି ପତ୍ରଂ ଯାଚିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","ଗଚ୍ଛନ୍ ତୁ ଦମ୍ମେଷକ୍ନଗରନିକଟ ଉପସ୍ଥିତୱାନ୍; ତତୋଽକସ୍ମାଦ୍ ଆକାଶାତ୍ ତସ୍ୟ ଚତୁର୍ଦିକ୍ଷୁ ତେଜସଃ ପ୍ରକାଶନାତ୍ ସ ଭୂମାୱପତତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ପଶ୍ଚାତ୍ ହେ ଶୌଲ ହେ ଶୌଲ କୁତୋ ମାଂ ତାଡଯସି? ସ୍ୱଂ ପ୍ରତି ପ୍ରୋକ୍ତମ୍ ଏତଂ ଶବ୍ଦଂ ଶ୍ରୁତ୍ୱା ");
INSERT INTO sanori_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ସ ପୃଷ୍ଟୱାନ୍, ହେ ପ୍ରଭୋ ଭୱାନ୍ କଃ? ତଦା ପ୍ରଭୁରକଥଯତ୍ ଯଂ ଯୀଶୁଂ ତ୍ୱଂ ତାଡଯସି ସ ଏୱାହଂ; କଣ୍ଟକସ୍ୟ ମୁଖେ ପଦାଘାତକରଣଂ ତୱ କଷ୍ଟମ୍| ");
INSERT INTO sanori_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","ତଦା କମ୍ପମାନୋ ୱିସ୍ମଯାପନ୍ନଶ୍ଚ ସୋୱଦତ୍ ହେ ପ୍ରଭୋ ମଯା କିଂ କର୍ତ୍ତୱ୍ୟଂ? ଭୱତ ଇଚ୍ଛା କା? ତତଃ ପ୍ରଭୁରାଜ୍ଞାପଯଦ୍ ଉତ୍ଥାଯ ନଗରଂ ଗଚ୍ଛ ତତ୍ର ତ୍ୱଯା ଯତ୍ କର୍ତ୍ତୱ୍ୟଂ ତଦ୍ ୱଦିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","ତସ୍ୟ ସଙ୍ଗିନୋ ଲୋକା ଅପି ତଂ ଶବ୍ଦଂ ଶ୍ରୁତୱନ୍ତଃ କିନ୍ତୁ କମପି ନ ଦୃଷ୍ଟ୍ୱା ସ୍ତବ୍ଧାଃ ସନ୍ତଃ ସ୍ଥିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","ଅନନ୍ତରଂ ଶୌଲୋ ଭୂମିତ ଉତ୍ଥାଯ ଚକ୍ଷୁଷୀ ଉନ୍ମୀଲ୍ୟ କମପି ନ ଦୃଷ୍ଟୱାନ୍| ତଦା ଲୋକାସ୍ତସ୍ୟ ହସ୍ତୌ ଧୃତ୍ୱା ଦମ୍ମେଷକ୍ନଗରମ୍ ଆନଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ତତଃ ସ ଦିନତ୍ରଯଂ ଯାୱଦ୍ ଅନ୍ଧୋ ଭୂତ୍ୱା ନ ଭୁକ୍ତୱାନ୍ ପୀତୱାଂଶ୍ଚ| ");
INSERT INTO sanori_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","ତଦନନ୍ତରଂ ପ୍ରଭୁସ୍ତଦ୍ଦମ୍ମେଷକ୍ନଗରୱାସିନ ଏକସ୍ମୈ ଶିଷ୍ୟାଯ ଦର୍ଶନଂ ଦତ୍ୱା ଆହୂତୱାନ୍ ହେ ଅନନିଯ| ତତଃ ସ ପ୍ରତ୍ୟୱାଦୀତ୍, ହେ ପ୍ରଭୋ ପଶ୍ୟ ଶୃଣୋମି| ");
INSERT INTO sanori_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ତଦା ପ୍ରଭୁସ୍ତମାଜ୍ଞାପଯତ୍ ତ୍ୱମୁତ୍ଥାଯ ସରଲନାମାନଂ ମାର୍ଗଂ ଗତ୍ୱା ଯିହୂଦାନିୱେଶନେ ତାର୍ଷନଗରୀଯଂ ଶୌଲନାମାନଂ ଜନଂ ଗୱେଷଯନ୍ ପୃଚ୍ଛ; ");
INSERT INTO sanori_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ପଶ୍ୟ ସ ପ୍ରାର୍ଥଯତେ, ତଥା ଅନନିଯନାମକ ଏକୋ ଜନସ୍ତସ୍ୟ ସମୀପମ୍ ଆଗତ୍ୟ ତସ୍ୟ ଗାତ୍ରେ ହସ୍ତାର୍ପଣଂ କୃତ୍ୱା ଦୃଷ୍ଟିଂ ଦଦାତୀତ୍ଥଂ ସ୍ୱପ୍ନେ ଦୃଷ୍ଟୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","ତସ୍ମାଦ୍ ଅନନିଯଃ ପ୍ରତ୍ୟୱଦତ୍ ହେ ପ୍ରଭୋ ଯିରୂଶାଲମି ପୱିତ୍ରଲୋକାନ୍ ପ୍ରତି ସୋଽନେକହିଂସାଂ କୃତୱାନ୍; ");
INSERT INTO sanori_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","ଅତ୍ର ସ୍ଥାନେ ଚ ଯେ ଲୋକାସ୍ତୱ ନାମ୍ନି ପ୍ରାର୍ଥଯନ୍ତି ତାନପି ବଦ୍ଧୁଂ ସ ପ୍ରଧାନଯାଜକେଭ୍ୟଃ ଶକ୍ତିଂ ପ୍ରାପ୍ତୱାନ୍, ଇମାଂ କଥାମ୍ ଅହମ୍ ଅନେକେଷାଂ ମୁଖେଭ୍ୟଃ ଶ୍ରୁତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","କିନ୍ତୁ ପ୍ରଭୁରକଥଯତ୍, ଯାହି ଭିନ୍ନଦେଶୀଯଲୋକାନାଂ ଭୂପତୀନାମ୍ ଇସ୍ରାଯେଲ୍ଲୋକାନାଞ୍ଚ ନିକଟେ ମମ ନାମ ପ୍ରଚାରଯିତୁଂ ସ ଜନୋ ମମ ମନୋନୀତପାତ୍ରମାସ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","ମମ ନାମନିମିତ୍ତଞ୍ଚ ତେନ କିଯାନ୍ ମହାନ୍ କ୍ଲେଶୋ ଭୋକ୍ତୱ୍ୟ ଏତତ୍ ତଂ ଦର୍ଶଯିଷ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ତତୋ ଽନନିଯୋ ଗତ୍ୱା ଗୃହଂ ପ୍ରୱିଶ୍ୟ ତସ୍ୟ ଗାତ୍ରେ ହସ୍ତାର୍ପ୍ରଣଂ କୃତ୍ୱା କଥିତୱାନ୍, ହେ ଭ୍ରାତଃ ଶୌଲ ତ୍ୱଂ ଯଥା ଦୃଷ୍ଟିଂ ପ୍ରାପ୍ନୋଷି ପୱିତ୍ରେଣାତ୍ମନା ପରିପୂର୍ଣୋ ଭୱସି ଚ, ତଦର୍ଥଂ ତୱାଗମନକାଲେ ଯଃ ପ୍ରଭୁଯୀଶୁସ୍ତୁଭ୍ୟଂ ଦର୍ଶନମ୍ ଅଦଦାତ୍ ସ ମାଂ ପ୍ରେଷିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ଇତ୍ୟୁକ୍ତମାତ୍ରେ ତସ୍ୟ ଚକ୍ଷୁର୍ଭ୍ୟାମ୍ ମୀନଶଲ୍କୱଦ୍ ୱସ୍ତୁନି ନିର୍ଗତେ ତତ୍କ୍ଷଣାତ୍ ସ ପ୍ରସନ୍ନଚକ୍ଷୁ ର୍ଭୂତ୍ୱା ପ୍ରୋତ୍ଥାଯ ମଜ୍ଜିତୋଽଭୱତ୍ ଭୁକ୍ତ୍ୱା ପୀତ୍ୱା ସବଲୋଭୱଚ୍ଚ| ");
INSERT INTO sanori_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ତତଃ ପରଂ ଶୌଲଃ ଶିଷ୍ୟୈଃ ସହ କତିପଯଦିୱସାନ୍ ତସ୍ମିନ୍ ଦମ୍ମେଷକନଗରେ ସ୍ଥିତ୍ୱାଽୱିଲମ୍ବଂ ");
INSERT INTO sanori_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ସର୍ୱ୍ୱଭଜନଭୱନାନି ଗତ୍ୱା ଯୀଶୁରୀଶ୍ୱରସ୍ୟ ପୁତ୍ର ଇମାଂ କଥାଂ ପ୍ରାଚାରଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","ତସ୍ମାତ୍ ସର୍ୱ୍ୱେ ଶ୍ରୋତାରଶ୍ଚମତ୍କୃତ୍ୟ କଥିତୱନ୍ତୋ ଯୋ ଯିରୂଶାଲମ୍ନଗର ଏତନ୍ନାମ୍ନା ପ୍ରାର୍ଥଯିତୃଲୋକାନ୍ ୱିନାଶିତୱାନ୍ ଏୱମ୍ ଏତାଦୃଶଲୋକାନ୍ ବଦ୍ଧ୍ୱା ପ୍ରଧାନଯାଜକନିକଟଂ ନଯତୀତ୍ୟାଶଯା ଏତତ୍ସ୍ଥାନମପ୍ୟାଗଚ୍ଛତ୍ ସଏୱ କିମଯଂ ନ ଭୱତି? ");
INSERT INTO sanori_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","କିନ୍ତୁ ଶୌଲଃ କ୍ରମଶ ଉତ୍ସାହୱାନ୍ ଭୂତ୍ୱା ଯୀଶୁରୀଶ୍ୱରେଣାଭିଷିକ୍ତୋ ଜନ ଏତସ୍ମିନ୍ ପ୍ରମାଣଂ ଦତ୍ୱା ଦମ୍ମେଷକ୍-ନିୱାସିଯିହୂଦୀଯଲୋକାନ୍ ନିରୁତ୍ତରାନ୍ ଅକରୋତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ଇତ୍ଥଂ ବହୁତିଥେ କାଲେ ଗତେ ଯିହୂଦୀଯଲୋକାସ୍ତଂ ହନ୍ତୁଂ ମନ୍ତ୍ରଯାମାସୁଃ ");
INSERT INTO sanori_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","କିନ୍ତୁ ଶୌଲସ୍ତେଷାମେତସ୍ୟା ମନ୍ତ୍ରଣାଯା ୱାର୍ତ୍ତାଂ ପ୍ରାପ୍ତୱାନ୍| ତେ ତଂ ହନ୍ତୁଂ ତୁ ଦିୱାନିଶଂ ଗୁପ୍ତାଃ ସନ୍ତୋ ନଗରସ୍ୟ ଦ୍ୱାରେଽତିଷ୍ଠନ୍; ");
INSERT INTO sanori_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ତସ୍ମାତ୍ ଶିଷ୍ୟାସ୍ତଂ ନୀତ୍ୱା ରାତ୍ରୌ ପିଟକେ ନିଧାଯ ପ୍ରାଚୀରେଣାୱାରୋହଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","ତତଃ ପରଂ ଶୌଲୋ ଯିରୂଶାଲମଂ ଗତ୍ୱା ଶିଷ୍ୟଗଣେନ ସାର୍ଦ୍ଧଂ ସ୍ଥାତୁମ୍ ଐହତ୍, କିନ୍ତୁ ସର୍ୱ୍ୱେ ତସ୍ମାଦବିଭଯୁଃ ସ ଶିଷ୍ୟ ଇତି ଚ ନ ପ୍ରତ୍ୟଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","ଏତସ୍ମାଦ୍ ବର୍ଣବ୍ବାସ୍ତଂ ଗୃହୀତ୍ୱା ପ୍ରେରିତାନାଂ ସମୀପମାନୀଯ ମାର୍ଗମଧ୍ୟେ ପ୍ରଭୁଃ କଥଂ ତସ୍ମୈ ଦର୍ଶନଂ ଦତ୍ତୱାନ୍ ଯାଃ କଥାଶ୍ଚ କଥିତୱାନ୍ ସ ଚ ଯଥାକ୍ଷୋଭଃ ସନ୍ ଦମ୍ମେଷକ୍ନଗରେ ଯୀଶୋ ର୍ନାମ ପ୍ରାଚାରଯତ୍ ଏତାନ୍ ସର୍ୱ୍ୱୱୃତ୍ତାନ୍ତାନ୍ ତାନ୍ ଜ୍ଞାପିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","ତତଃ ଶୌଲସ୍ତୈଃ ସହ ଯିରୂଶାଲମି କାଲଂ ଯାପଯନ୍ ନିର୍ଭଯଂ ପ୍ରଭୋ ର୍ୟୀଶୋ ର୍ନାମ ପ୍ରାଚାରଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ତସ୍ମାଦ୍ ଅନ୍ୟଦେଶୀଯଲୋକୈଃ ସାର୍ଦ୍ଧଂ ୱିୱାଦସ୍ୟୋପସ୍ଥିତତ୍ୱାତ୍ ତେ ତଂ ହନ୍ତୁମ୍ ଅଚେଷ୍ଟନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","କିନ୍ତୁ ଭ୍ରାତୃଗଣସ୍ତଜ୍ଜ୍ଞାତ୍ୱା ତଂ କୈସରିଯାନଗରଂ ନୀତ୍ୱା ତାର୍ଷନଗରଂ ପ୍ରେଷିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ଇତ୍ଥଂ ସତି ଯିହୂଦିଯାଗାଲୀଲ୍ଶୋମିରୋଣଦେଶୀଯାଃ ସର୍ୱ୍ୱା ମଣ୍ଡଲ୍ୟୋ ୱିଶ୍ରାମଂ ପ୍ରାପ୍ତାସ୍ତତସ୍ତାସାଂ ନିଷ୍ଠାଭୱତ୍ ପ୍ରଭୋ ର୍ଭିଯା ପୱିତ୍ରସ୍ୟାତ୍ମନଃ ସାନ୍ତ୍ୱନଯା ଚ କାଲଂ କ୍ଷେପଯିତ୍ୱା ବହୁସଂଖ୍ୟା ଅଭୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","ତତଃ ପରଂ ପିତରଃ ସ୍ଥାନେ ସ୍ଥାନେ ଭ୍ରମିତ୍ୱା ଶେଷେ ଲୋଦ୍ନଗରନିୱାସିପୱିତ୍ରଲୋକାନାଂ ସମୀପେ ସ୍ଥିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ତଦା ତତ୍ର ପକ୍ଷାଘାତୱ୍ୟାଧିନାଷ୍ଟୌ ୱତ୍ସରାନ୍ ଶଯ୍ୟାଗତମ୍ ଐନେଯନାମାନଂ ମନୁଷ୍ୟଂ ସାକ୍ଷତ୍ ପ୍ରାପ୍ୟ ତମୱଦତ୍, ");
INSERT INTO sanori_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ହେ ଐନେଯ ଯୀଶୁଖ୍ରୀଷ୍ଟସ୍ତ୍ୱାଂ ସ୍ୱସ୍ଥମ୍ ଅକାର୍ଷୀତ୍, ତ୍ୱମୁତ୍ଥାଯ ସ୍ୱଶଯ୍ୟାଂ ନିକ୍ଷିପ, ଇତ୍ୟୁକ୍ତମାତ୍ରେ ସ ଉଦତିଷ୍ଠତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ଏତାଦୃଶଂ ଦୃଷ୍ଟ୍ୱା ଲୋଦ୍ଶାରୋଣନିୱାସିନୋ ଲୋକାଃ ପ୍ରଭୁଂ ପ୍ରତି ପରାୱର୍ତ୍ତନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","ଅପରଞ୍ଚ ଭିକ୍ଷାଦାନାଦିଷୁ ନାନକ୍ରିଯାସୁ ନିତ୍ୟଂ ପ୍ରୱୃତ୍ତା ଯା ଯାଫୋନଗରନିୱାସିନୀ ଟାବିଥାନାମା ଶିଷ୍ୟା ଯାଂ ଦର୍କ୍କାଂ ଅର୍ଥାଦ୍ ହରିଣୀମଯୁକ୍ତ୍ୱା ଆହ୍ୱଯନ୍ ସା ନାରୀ ");
INSERT INTO sanori_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","ତସ୍ମିନ୍ ସମଯେ ରୁଗ୍ନା ସତୀ ପ୍ରାଣାନ୍ ଅତ୍ୟଜତ୍, ତତୋ ଲୋକାସ୍ତାଂ ପ୍ରକ୍ଷାଲ୍ୟୋପରିସ୍ଥପ୍ରକୋଷ୍ଠେ ଶାଯଯିତ୍ୱାସ୍ଥାପଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","ଲୋଦ୍ନଗରଂ ଯାଫୋନଗରସ୍ୟ ସମୀପସ୍ଥଂ ତସ୍ମାତ୍ତତ୍ର ପିତର ଆସ୍ତେ, ଇତି ୱାର୍ତ୍ତାଂ ଶ୍ରୁତ୍ୱା ତୂର୍ଣଂ ତସ୍ୟାଗମନାର୍ଥଂ ତସ୍ମିନ୍ ୱିନଯମୁକ୍ତ୍ୱା ଶିଷ୍ୟଗଣୋ ଦ୍ୱୌ ମନୁଜୌ ପ୍ରେଷିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","ତସ୍ମାତ୍ ପିତର ଉତ୍ଥାଯ ତାଭ୍ୟାଂ ସାର୍ଦ୍ଧମ୍ ଆଗଚ୍ଛତ୍, ତତ୍ର ତସ୍ମିନ୍ ଉପସ୍ଥିତ ଉପରିସ୍ଥପ୍ରକୋଷ୍ଠଂ ସମାନୀତେ ଚ ୱିଧୱାଃ ସ୍ୱାଭିଃ ସହ ସ୍ଥିତିକାଲେ ଦର୍କ୍କଯା କୃତାନି ଯାନ୍ୟୁତ୍ତରୀଯାଣି ପରିଧେଯାନି ଚ ତାନି ସର୍ୱ୍ୱାଣି ତଂ ଦର୍ଶଯିତ୍ୱା ରୁଦତ୍ୟଶ୍ଚତସୃଷୁ ଦିକ୍ଷ୍ୱତିଷ୍ଠନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","କିନ୍ତୁ ପିତରସ୍ତାଃ ସର୍ୱ୍ୱା ବହିଃ କୃତ୍ୱା ଜାନୁନୀ ପାତଯିତ୍ୱା ପ୍ରାର୍ଥିତୱାନ୍; ପଶ୍ଚାତ୍ ଶୱଂ ପ୍ରତି ଦୃଷ୍ଟିଂ କୃତ୍ୱା କଥିତୱାନ୍, ହେ ଟାବୀଥେ ତ୍ୱମୁତ୍ତିଷ୍ଠ, ଇତି ୱାକ୍ୟ ଉକ୍ତେ ସା ସ୍ତ୍ରୀ ଚକ୍ଷୁଷୀ ପ୍ରୋନ୍ମୀଲ୍ୟ ପିତରମ୍ ଅୱଲୋକ୍ୟୋତ୍ଥାଯୋପାୱିଶତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","ତତଃ ପିତରସ୍ତସ୍ୟାଃ କରୌ ଧୃତ୍ୱା ଉତ୍ତୋଲ୍ୟ ପୱିତ୍ରଲୋକାନ୍ ୱିଧୱାଶ୍ଚାହୂଯ ତେଷାଂ ନିକଟେ ସଜୀୱାଂ ତାଂ ସମାର୍ପଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ଏଷା କଥା ସମସ୍ତଯାଫୋନଗରଂ ୱ୍ୟାପ୍ତା ତସ୍ମାଦ୍ ଅନେକେ ଲୋକାଃ ପ୍ରଭୌ ୱ୍ୟଶ୍ୱସନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","ଅପରଞ୍ଚ ପିତରସ୍ତଦ୍ୟାଫୋନଗରୀଯସ୍ୟ କସ୍ୟଚିତ୍ ଶିମୋନ୍ନାମ୍ନଶ୍ଚର୍ମ୍ମକାରସ୍ୟ ଗୃହେ ବହୁଦିନାନି ନ୍ୟୱସତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","କୈସରିଯାନଗର ଇତାଲିଯାଖ୍ୟସୈନ୍ୟାନ୍ତର୍ଗତଃ କର୍ଣୀଲିଯନାମା ସେନାପତିରାସୀତ୍ ");
INSERT INTO sanori_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ସ ସପରିୱାରୋ ଭକ୍ତ ଈଶ୍ୱରପରାଯଣଶ୍ଚାସୀତ୍; ଲୋକେଭ୍ୟୋ ବହୂନି ଦାନାଦୀନି ଦତ୍ୱା ନିରନ୍ତରମ୍ ଈଶ୍ୱରେ ପ୍ରାର୍ଥଯାଞ୍ଚକ୍ରେ| ");
INSERT INTO sanori_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ଏକଦା ତୃତୀଯପ୍ରହରୱେଲାଯାଂ ସ ଦୃଷ୍ଟୱାନ୍ ଈଶ୍ୱରସ୍ୟୈକୋ ଦୂତଃ ସପ୍ରକାଶଂ ତତ୍ସମୀପମ୍ ଆଗତ୍ୟ କଥିତୱାନ୍, ହେ କର୍ଣୀଲିଯ| ");
INSERT INTO sanori_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","କିନ୍ତୁ ସ ତଂ ଦୃଷ୍ଟ୍ୱା ଭୀତୋଽକଥଯତ୍, ହେ ପ୍ରଭୋ କିଂ? ତଦା ତମୱଦତ୍ ତୱ ପ୍ରାର୍ଥନା ଦାନାଦି ଚ ସାକ୍ଷିସ୍ୱରୂପଂ ଭୂତ୍ୱେଶ୍ୱରସ୍ୟ ଗୋଚରମଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ଇଦାନୀଂ ଯାଫୋନଗରଂ ପ୍ରତି ଲୋକାନ୍ ପ୍ରେଷ୍ୟ ସମୁଦ୍ରତୀରେ ଶିମୋନ୍ନାମ୍ନଶ୍ଚର୍ମ୍ମକାରସ୍ୟ ଗୃହେ ପ୍ରୱାସକାରୀ ପିତରନାମ୍ନା ୱିଖ୍ୟାତୋ ଯଃ ଶିମୋନ୍ ତମ୍ ଆହ୍ୱାଯଯ; ");
INSERT INTO sanori_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ତସ୍ମାତ୍ ତ୍ୱଯା ଯଦ୍ୟତ୍ କର୍ତ୍ତୱ୍ୟଂ ତତ୍ତତ୍ ସ ୱଦିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ଇତ୍ୟୁପଦିଶ୍ୟ ଦୂତେ ପ୍ରସ୍ଥିତେ ସତି କର୍ଣୀଲିଯଃ ସ୍ୱଗୃହସ୍ଥାନାଂ ଦାସାନାଂ ଦ୍ୱୌ ଜନୌ ନିତ୍ୟଂ ସ୍ୱସଙ୍ଗିନାଂ ସୈନ୍ୟାନାମ୍ ଏକାଂ ଭକ୍ତସେନାଞ୍ଚାହୂଯ ");
INSERT INTO sanori_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ସକଲମେତଂ ୱୃତ୍ତାନ୍ତଂ ୱିଜ୍ଞାପ୍ୟ ଯାଫୋନଗରଂ ତାନ୍ ପ୍ରାହିଣୋତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","ପରସ୍ମିନ୍ ଦିନେ ତେ ଯାତ୍ରାଂ କୃତ୍ୱା ଯଦା ନଗରସ୍ୟ ସମୀପ ଉପାତିଷ୍ଠନ୍, ତଦା ପିତରୋ ଦ୍ୱିତୀଯପ୍ରହରୱେଲାଯାଂ ପ୍ରାର୍ଥଯିତୁଂ ଗୃହପୃଷ୍ଠମ୍ ଆରୋହତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ଏତସ୍ମିନ୍ ସମଯେ କ୍ଷୁଧାର୍ତ୍ତଃ ସନ୍ କିଞ୍ଚିଦ୍ ଭୋକ୍ତୁମ୍ ଐଚ୍ଛତ୍ କିନ୍ତୁ ତେଷାମ୍ ଅନ୍ନାସାଦନସମଯେ ସ ମୂର୍ଚ୍ଛିତଃ ସନ୍ନପତତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ତତୋ ମେଘଦ୍ୱାରଂ ମୁକ୍ତଂ ଚତୁର୍ଭିଃ କୋଣୈ ର୍ଲମ୍ବିତଂ ବୃହଦ୍ୱସ୍ତ୍ରମିୱ କିଞ୍ଚନ ଭାଜନମ୍ ଆକାଶାତ୍ ପୃଥିୱୀମ୍ ଅୱାରୋହତୀତି ଦୃଷ୍ଟୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ତନ୍ମଧ୍ୟେ ନାନପ୍ରକାରା ଗ୍ରାମ୍ୟୱନ୍ୟପଶୱଃ ଖେଚରୋରୋଗାମିପ୍ରଭୃତଯୋ ଜନ୍ତୱଶ୍ଚାସନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","ଅନନ୍ତରଂ ହେ ପିତର ଉତ୍ଥାଯ ହତ୍ୱା ଭୁଂକ୍ଷ୍ୱ ତମ୍ପ୍ରତୀଯଂ ଗଗଣୀଯା ୱାଣୀ ଜାତା| ");
INSERT INTO sanori_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","ତଦା ପିତରଃ ପ୍ରତ୍ୟୱଦତ୍, ହେ ପ୍ରଭୋ ଈଦୃଶଂ ମା ଭୱତୁ, ଅହମ୍ ଏତତ୍ କାଲଂ ଯାୱତ୍ ନିଷିଦ୍ଧମ୍ ଅଶୁଚି ୱା ଦ୍ରୱ୍ୟଂ କିଞ୍ଚିଦପି ନ ଭୁକ୍ତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ତତଃ ପୁନରପି ତାଦୃଶୀ ୱିହଯସୀଯା ୱାଣୀ ଜାତା ଯଦ୍ ଈଶ୍ୱରଃ ଶୁଚି କୃତୱାନ୍ ତତ୍ ତ୍ୱଂ ନିଷିଦ୍ଧଂ ନ ଜାନୀହି| ");
INSERT INTO sanori_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ଇତ୍ଥଂ ତ୍ରିଃ ସତି ତତ୍ ପାତ୍ରଂ ପୁନରାକୃଷ୍ଟଂ ଆକାଶମ୍ ଅଗଚ୍ଛତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ତତଃ ପରଂ ଯଦ୍ ଦର୍ଶନଂ ପ୍ରାପ୍ତୱାନ୍ ତସ୍ୟ କୋ ଭାୱ ଇତ୍ୟତ୍ର ପିତରୋ ମନସା ସନ୍ଦେଗ୍ଧି, ଏତସ୍ମିନ୍ ସମଯେ କର୍ଣୀଲିଯସ୍ୟ ତେ ପ୍ରେଷିତା ମନୁଷ୍ୟା ଦ୍ୱାରସ୍ୟ ସନ୍ନିଧାୱୁପସ୍ଥାଯ, ");
INSERT INTO sanori_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ଶିମୋନୋ ଗୃହମନ୍ୱିଚ୍ଛନ୍ତଃ ସମ୍ପୃଛ୍ୟାହୂଯ କଥିତୱନ୍ତଃ ପିତରନାମ୍ନା ୱିଖ୍ୟାତୋ ଯଃ ଶିମୋନ୍ ସ କିମତ୍ର ପ୍ରୱସତି? ");
INSERT INTO sanori_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","ଯଦା ପିତରସ୍ତଦ୍ଦର୍ଶନସ୍ୟ ଭାୱଂ ମନସାନ୍ଦୋଲଯତି ତଦାତ୍ମା ତମୱଦତ୍, ପଶ୍ୟ ତ୍ରଯୋ ଜନାସ୍ତ୍ୱାଂ ମୃଗଯନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ତ୍ୱମ୍ ଉତ୍ଥାଯାୱରୁହ୍ୟ ନିଃସନ୍ଦେହଂ ତୈଃ ସହ ଗଚ୍ଛ ମଯୈୱ ତେ ପ୍ରେଷିତାଃ| ");
INSERT INTO sanori_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","ତସ୍ମାତ୍ ପିତରୋଽୱରୁହ୍ୟ କର୍ଣୀଲିଯପ୍ରେରିତଲୋକାନାଂ ନିକଟମାଗତ୍ୟ କଥିତୱାନ୍ ପଶ୍ୟତ ଯୂଯଂ ଯଂ ମୃଗଯଧ୍ୱେ ସ ଜନୋହଂ, ଯୂଯଂ କିନ୍ନିମିତ୍ତମ୍ ଆଗତାଃ? ");
INSERT INTO sanori_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ତତସ୍ତେ ପ୍ରତ୍ୟୱଦନ୍ କର୍ଣୀଲିଯନାମା ଶୁଦ୍ଧସତ୍ତ୍ୱ ଈଶ୍ୱରପରାଯଣୋ ଯିହୂଦୀଯଦେଶସ୍ଥାନାଂ ସର୍ୱ୍ୱେଷାଂ ସନ୍ନିଧୌ ସୁଖ୍ୟାତ୍ୟାପନ୍ନ ଏକଃ ସେନାପତି ର୍ନିଜଗୃହଂ ତ୍ୱାମାହୂଯ ନେତୁଂ ତ୍ୱତ୍ତଃ କଥା ଶ୍ରୋତୁଞ୍ଚ ପୱିତ୍ରଦୂତେନ ସମାଦିଷ୍ଟଃ| ");
INSERT INTO sanori_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","ତଦା ପିତରସ୍ତାନଭ୍ୟନ୍ତରଂ ନୀତ୍ୱା ତେଷାମାତିଥ୍ୟଂ କୃତୱାନ୍, ପରେଽହନି ତୈଃ ସାର୍ଦ୍ଧଂ ଯାତ୍ରାମକରୋତ୍, ଯାଫୋନିୱାସିନାଂ ଭ୍ରାତୃଣାଂ କିଯନ୍ତୋ ଜନାଶ୍ଚ ତେନ ସହ ଗତାଃ| ");
INSERT INTO sanori_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","ପରସ୍ମିନ୍ ଦିୱସେ କୈସରିଯାନଗରମଧ୍ୟପ୍ରୱେଶସମଯେ କର୍ଣୀଲିଯୋ ଜ୍ଞାତିବନ୍ଧୂନ୍ ଆହୂଯାନୀଯ ତାନ୍ ଅପେକ୍ଷ୍ୟ ସ୍ଥିତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","ପିତରେ ଗୃହ ଉପସ୍ଥିତେ କର୍ଣୀଲିଯସ୍ତଂ ସାକ୍ଷାତ୍କୃତ୍ୟ ଚରଣଯୋଃ ପତିତ୍ୱା ପ୍ରାଣମତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","ପିତରସ୍ତମୁତ୍ଥାପ୍ୟ କଥିତୱାନ୍, ଉତ୍ତିଷ୍ଠାହମପି ମାନୁଷଃ| ");
INSERT INTO sanori_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ତଦା କର୍ଣୀଲିଯେନ ସାକମ୍ ଆଲପନ୍ ଗୃହଂ ପ୍ରାୱିଶତ୍ ତନ୍ମଧ୍ୟେ ଚ ବହୁଲୋକାନାଂ ସମାଗମଂ ଦୃଷ୍ଟ୍ୱା ତାନ୍ ଅୱଦତ୍, ");
INSERT INTO sanori_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ଅନ୍ୟଜାତୀଯଲୋକୈଃ ମହାଲପନଂ ୱା ତେଷାଂ ଗୃହମଧ୍ୟେ ପ୍ରୱେଶନଂ ଯିହୂଦୀଯାନାଂ ନିଷିଦ୍ଧମ୍ ଅସ୍ତୀତି ଯୂଯମ୍ ଅୱଗଚ୍ଛଥ; କିନ୍ତୁ କମପି ମାନୁଷମ୍ ଅୱ୍ୟୱହାର୍ୟ୍ୟମ୍ ଅଶୁଚିଂ ୱା ଜ୍ଞାତୁଂ ମମ ନୋଚିତମ୍ ଇତି ପରମେଶ୍ୱରୋ ମାଂ ଜ୍ଞାପିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ଇତି ହେତୋରାହ୍ୱାନଶ୍ରୱଣମାତ୍ରାତ୍ କାଞ୍ଚନାପତ୍ତିମ୍ ଅକୃତ୍ୱା ଯୁଷ୍ମାକଂ ସମୀପମ୍ ଆଗତୋସ୍ମି; ପୃଚ୍ଛାମି ଯୂଯଂ କିନ୍ନିମିତ୍ତଂ ମାମ୍ ଆହୂଯତ? ");
INSERT INTO sanori_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","ତଦା କର୍ଣୀଲିଯଃ କଥିତୱାନ୍, ଅଦ୍ୟ ଚତ୍ୱାରି ଦିନାନି ଜାତାନି ଏତାୱଦ୍ୱେଲାଂ ଯାୱଦ୍ ଅହମ୍ ଅନାହାର ଆସନ୍ ତତସ୍ତୃତୀଯପ୍ରହରେ ସତି ଗୃହେ ପ୍ରାର୍ଥନସମଯେ ତେଜୋମଯୱସ୍ତ୍ରଭୃଦ୍ ଏକୋ ଜନୋ ମମ ସମକ୍ଷଂ ତିଷ୍ଠନ୍ ଏତାଂ କଥାମ୍ ଅକଥଯତ୍, ");
INSERT INTO sanori_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ହେ କର୍ଣୀଲିଯ ତ୍ୱଦୀଯା ପ୍ରାର୍ଥନା ଈଶ୍ୱରସ୍ୟ କର୍ଣଗୋଚରୀଭୂତା ତୱ ଦାନାଦି ଚ ସାକ୍ଷିସ୍ୱରୂପଂ ଭୂତ୍ୱା ତସ୍ୟ ଦୃଷ୍ଟିଗୋଚରମଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ଅତୋ ଯାଫୋନଗରଂ ପ୍ରତି ଲୋକାନ୍ ପ୍ରହିତ୍ୟ ତତ୍ର ସମୁଦ୍ରତୀରେ ଶିମୋନ୍ନାମ୍ନଃ କସ୍ୟଚିଚ୍ଚର୍ମ୍ମକାରସ୍ୟ ଗୃହେ ପ୍ରୱାସକାରୀ ପିତରନାମ୍ନା ୱିଖ୍ୟାତୋ ଯଃ ଶିମୋନ୍ ତମାହୂाଯଯ; ତତଃ ସ ଆଗତ୍ୟ ତ୍ୱାମ୍ ଉପଦେକ୍ଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ଇତି କାରଣାତ୍ ତତ୍କ୍ଷଣାତ୍ ତୱ ନିକଟେ ଲୋକାନ୍ ପ୍ରେଷିତୱାନ୍, ତ୍ୱମାଗତୱାନ୍ ଇତି ଭଦ୍ରଂ କୃତୱାନ୍| ଈଶ୍ୱରୋ ଯାନ୍ୟାଖ୍ୟାନାନି କଥଯିତୁମ୍ ଆଦିଶତ୍ ତାନି ଶ୍ରୋତୁଂ ୱଯଂ ସର୍ୱ୍ୱେ ସାମ୍ପ୍ରତମ୍ ଈଶ୍ୱରସ୍ୟ ସାକ୍ଷାଦ୍ ଉପସ୍ଥିତାଃ ସ୍ମଃ| ");
INSERT INTO sanori_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","ତଦା ପିତର ଇମାଂ କଥାଂ କଥଯିତୁମ୍ ଆରବ୍ଧୱାନ୍, ଈଶ୍ୱରୋ ମନୁଷ୍ୟାଣାମ୍ ଅପକ୍ଷପାତୀ ସନ୍ ");
INSERT INTO sanori_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ଯସ୍ୟ କସ୍ୟଚିଦ୍ ଦେଶସ୍ୟ ଯୋ ଲୋକାସ୍ତସ୍ମାଦ୍ଭୀତ୍ୱା ସତ୍କର୍ମ୍ମ କରୋତି ସ ତସ୍ୟ ଗ୍ରାହ୍ୟୋ ଭୱତି, ଏତସ୍ୟ ନିଶ୍ଚଯମ୍ ଉପଲବ୍ଧୱାନହମ୍| ");
INSERT INTO sanori_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","ସର୍ୱ୍ୱେଷାଂ ପ୍ରଭୁ ର୍ୟୋ ଯୀଶୁଖ୍ରୀଷ୍ଟସ୍ତେନ ଈଶ୍ୱର ଇସ୍ରାଯେଲ୍ୱଂଶାନାଂ ନିକଟେ ସୁସଂୱାଦଂ ପ୍ରେଷ୍ୟ ସମ୍ମେଲନସ୍ୟ ଯଂ ସଂୱାଦଂ ପ୍ରାଚାରଯତ୍ ତଂ ସଂୱାଦଂ ଯୂଯଂ ଶ୍ରୁତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","ଯତୋ ଯୋହନା ମଜ୍ଜନେ ପ୍ରଚାରିତେ ସତି ସ ଗାଲୀଲଦେଶମାରଭ୍ୟ ସମସ୍ତଯିହୂଦୀଯଦେଶଂ ୱ୍ୟାପ୍ନୋତ୍; ");
INSERT INTO sanori_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ଫଲତ ଈଶ୍ୱରେଣ ପୱିତ୍ରେଣାତ୍ମନା ଶକ୍ତ୍ୟା ଚାଭିଷିକ୍ତୋ ନାସରତୀଯଯୀଶୁଃ ସ୍ଥାନେ ସ୍ଥାନେ ଭ୍ରମନ୍ ସୁକ୍ରିଯାଂ କୁର୍ୱ୍ୱନ୍ ଶୈତାନା କ୍ଲିଷ୍ଟାନ୍ ସର୍ୱ୍ୱଲୋକାନ୍ ସ୍ୱସ୍ଥାନ୍ ଅକରୋତ୍, ଯତ ଈଶ୍ୱରସ୍ତସ୍ୟ ସହାଯ ଆସୀତ୍; ");
INSERT INTO sanori_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","ୱଯଞ୍ଚ ଯିହୂଦୀଯଦେଶେ ଯିରୂଶାଲମ୍ନଗରେ ଚ ତେନ କୃତାନାଂ ସର୍ୱ୍ୱେଷାଂ କର୍ମ୍ମଣାଂ ସାକ୍ଷିଣୋ ଭୱାମଃ| ଲୋକାସ୍ତଂ କ୍ରୁଶେ ୱିଦ୍ଧ୍ୱା ହତୱନ୍ତଃ, ");
INSERT INTO sanori_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","କିନ୍ତୁ ତୃତୀଯଦିୱସେ ଈଶ୍ୱରସ୍ତମୁତ୍ଥାପ୍ୟ ସପ୍ରକାଶମ୍ ଅଦର୍ଶଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ସର୍ୱ୍ୱଲୋକାନାଂ ନିକଟ ଇତି ନ ହି, କିନ୍ତୁ ତସ୍ମିନ୍ ଶ୍ମଶାନାଦୁତ୍ଥିତେ ସତି ତେନ ସାର୍ଦ୍ଧଂ ଭୋଜନଂ ପାନଞ୍ଚ କୃତୱନ୍ତ ଏତାଦୃଶା ଈଶ୍ୱରସ୍ୟ ମନୋନୀତାଃ ସାକ୍ଷିଣୋ ଯେ ୱଯମ୍ ଅସ୍ମାକଂ ନିକଟେ ତମଦର୍ଶଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ଜୀୱିତମୃତୋଭଯଲୋକାନାଂ ୱିଚାରଂ କର୍ତ୍ତୁମ୍ ଈଶ୍ୱରୋ ଯଂ ନିଯୁକ୍ତୱାନ୍ ସ ଏୱ ସ ଜନଃ, ଇମାଂ କଥାଂ ପ୍ରଚାରଯିତୁଂ ତସ୍ମିନ୍ ପ୍ରମାଣଂ ଦାତୁଞ୍ଚ ସୋଽସ୍ମାନ୍ ଆଜ୍ଞାପଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ଯସ୍ତସ୍ମିନ୍ ୱିଶ୍ୱସିତି ସ ତସ୍ୟ ନାମ୍ନା ପାପାନ୍ମୁକ୍ତୋ ଭୱିଷ୍ୟତି ତସ୍ମିନ୍ ସର୍ୱ୍ୱେ ଭୱିଷ୍ୟଦ୍ୱାଦିନୋପି ଏତାଦୃଶଂ ସାକ୍ଷ୍ୟଂ ଦଦତି| ");
INSERT INTO sanori_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","ପିତରସ୍ୟୈତତ୍କଥାକଥନକାଲେ ସର୍ୱ୍ୱେଷାଂ ଶ୍ରୋତୃଣାମୁପରି ପୱିତ୍ର ଆତ୍ମାୱାରୋହତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ତତଃ ପିତରେଣ ସାର୍ଦ୍ଧମ୍ ଆଗତାସ୍ତ୍ୱକ୍ଛେଦିନୋ ୱିଶ୍ୱାସିନୋ ଲୋକା ଅନ୍ୟଦେଶୀଯେଭ୍ୟଃ ପୱିତ୍ର ଆତ୍ମନି ଦତ୍ତେ ସତି ");
INSERT INTO sanori_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ତେ ନାନାଜାତୀଯଭାଷାଭିଃ କଥାଂ କଥଯନ୍ତ ଈଶ୍ୱରଂ ପ୍ରଶଂସନ୍ତି, ଇତି ଦୃଷ୍ଟ୍ୱା ଶ୍ରୁତ୍ୱା ଚ ୱିସ୍ମଯମ୍ ଆପଦ୍ୟନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","ତଦା ପିତରଃ କଥିତୱାନ୍, ୱଯମିୱ ଯେ ପୱିତ୍ରମ୍ ଆତ୍ମାନଂ ପ୍ରାପ୍ତାସ୍ତେଷାଂ ଜଲମଜ୍ଜନଂ କିଂ କୋପି ନିଷେଦ୍ଧୁଂ ଶକ୍ନୋତି? ");
INSERT INTO sanori_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","ତତଃ ପ୍ରଭୋ ର୍ନାମ୍ନା ମଜ୍ଜିତା ଭୱତେତି ତାନାଜ୍ଞାପଯତ୍| ଅନନ୍ତରଂ ତେ ସ୍ୱୈଃ ସାର୍ଦ୍ଧଂ କତିପଯଦିନାନି ସ୍ଥାତୁଂ ପ୍ରାର୍ଥଯନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ଇତ୍ଥଂ ଭିନ୍ନଦେଶୀଯଲୋକା ଅପୀଶ୍ୱରସ୍ୟ ୱାକ୍ୟମ୍ ଅଗୃହ୍ଲନ୍ ଇମାଂ ୱାର୍ତ୍ତାଂ ଯିହୂଦୀଯଦେଶସ୍ଥପ୍ରେରିତା ଭ୍ରାତୃଗଣଶ୍ଚ ଶ୍ରୁତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ତତଃ ପିତରେ ଯିରୂଶାଲମ୍ନଗରଂ ଗତୱତି ତ୍ୱକ୍ଛେଦିନୋ ଲୋକାସ୍ତେନ ସହ ୱିୱଦମାନା ଅୱଦନ୍, ");
INSERT INTO sanori_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ତ୍ୱମ୍ ଅତ୍ୱକ୍ଛେଦିଲୋକାନାଂ ଗୃହଂ ଗତ୍ୱା ତୈଃ ସାର୍ଦ୍ଧଂ ଭୁକ୍ତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","ତତଃ ପିତର ଆଦିତଃ କ୍ରମଶସ୍ତତ୍କାର୍ୟ୍ୟସ୍ୟ ସର୍ୱ୍ୱୱୃତ୍ତାନ୍ତମାଖ୍ୟାତୁମ୍ ଆରବ୍ଧୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","ଯାଫୋନଗର ଏକଦାହଂ ପ୍ରାର୍ଥଯମାନୋ ମୂର୍ଚ୍ଛିତଃ ସନ୍ ଦର୍ଶନେନ ଚତୁର୍ଷୁ କୋଣେଷୁ ଲମ୍ବନମାନଂ ୱୃହଦ୍ୱସ୍ତ୍ରମିୱ ପାତ୍ରମେକମ୍ ଆକାଶଦୱରୁହ୍ୟ ମନ୍ନିକଟମ୍ ଆଗଚ୍ଛଦ୍ ଅପଶ୍ୟମ୍| ");
INSERT INTO sanori_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ପଶ୍ଚାତ୍ ତଦ୍ ଅନନ୍ୟଦୃଷ୍ଟ୍ୟା ଦୃଷ୍ଟ୍ୱା ୱିୱିଚ୍ୟ ତସ୍ୟ ମଧ୍ୟେ ନାନାପ୍ରକାରାନ୍ ଗ୍ରାମ୍ୟୱନ୍ୟପଶୂନ୍ ଉରୋଗାମିଖେଚରାଂଶ୍ଚ ଦୃଷ୍ଟୱାନ୍; ");
INSERT INTO sanori_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","ହେ ପିତର ତ୍ୱମୁତ୍ଥାଯ ଗତ୍ୱା ଭୁଂକ୍ଷ୍ୱ ମାଂ ସମ୍ବୋଧ୍ୟ କଥଯନ୍ତଂ ଶବ୍ଦମେକଂ ଶ୍ରୁତୱାଂଶ୍ଚ| ");
INSERT INTO sanori_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","ତତୋହଂ ପ୍ରତ୍ୟୱଦଂ, ହେ ପ୍ରଭୋ ନେତ୍ଥଂ ଭୱତୁ, ଯତଃ କିଞ୍ଚନ ନିଷିଦ୍ଧମ୍ ଅଶୁଚି ଦ୍ରୱ୍ୟଂ ୱା ମମ ମୁଖମଧ୍ୟଂ କଦାପି ନ ପ୍ରାୱିଶତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","ଅପରମ୍ ଈଶ୍ୱରୋ ଯତ୍ ଶୁଚି କୃତୱାନ୍ ତନ୍ନିଷିଦ୍ଧଂ ନ ଜାନୀହି ଦ୍ୱି ର୍ମାମ୍ପ୍ରତୀଦୃଶୀ ୱିହାଯସୀଯା ୱାଣୀ ଜାତା| ");
INSERT INTO sanori_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","ତ୍ରିରିତ୍ଥଂ ସତି ତତ୍ ସର୍ୱ୍ୱଂ ପୁନରାକାଶମ୍ ଆକୃଷ୍ଟଂ| ");
INSERT INTO sanori_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","ପଶ୍ଚାତ୍ କୈସରିଯାନଗରାତ୍ ତ୍ରଯୋ ଜନା ମନ୍ନିକଟଂ ପ୍ରେଷିତା ଯତ୍ର ନିୱେଶନେ ସ୍ଥିତୋହଂ ତସ୍ମିନ୍ ସମଯେ ତତ୍ରୋପାତିଷ୍ଠନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","ତଦା ନିଃସନ୍ଦେହଂ ତୈଃ ସାର୍ଦ୍ଧଂ ଯାତୁମ୍ ଆତ୍ମା ମାମାଦିଷ୍ଟୱାନ୍; ତତଃ ପରଂ ମଯା ସହୈତେଷୁ ଷଡ୍ଭ୍ରାତୃଷୁ ଗତେଷୁ ୱଯଂ ତସ୍ୟ ମନୁଜସ୍ୟ ଗୃହଂ ପ୍ରାୱିଶାମ| ");
INSERT INTO sanori_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ସୋସ୍ମାକଂ ନିକଟେ କଥାମେତାମ୍ ଅକଥଯତ୍ ଏକଦା ଦୂତ ଏକଃ ପ୍ରତ୍ୟକ୍ଷୀଭୂଯ ମମ ଗୃହମଧ୍ୟେ ତିଷ୍ଟନ୍ ମାମିତ୍ୟାଜ୍ଞାପିତୱାନ୍, ଯାଫୋନଗରଂ ପ୍ରତି ଲୋକାନ୍ ପ୍ରହିତ୍ୟ ପିତରନାମ୍ନା ୱିଖ୍ୟାତଂ ଶିମୋନମ୍ ଆହୂଯଯ; ");
INSERT INTO sanori_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ତତସ୍ତୱ ତ୍ୱଦୀଯପରିୱାରାଣାଞ୍ଚ ଯେନ ପରିତ୍ରାଣଂ ଭୱିଷ୍ୟତି ତତ୍ ସ ଉପଦେକ୍ଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","ଅହଂ ତାଂ କଥାମୁତ୍ଥାପ୍ୟ କଥିତୱାନ୍ ତେନ ପ୍ରଥମମ୍ ଅସ୍ମାକମ୍ ଉପରି ଯଥା ପୱିତ୍ର ଆତ୍ମାୱରୂଢୱାନ୍ ତଥା ତେଷାମପ୍ୟୁପରି ସମୱରୂଢୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","ତେନ ଯୋହନ୍ ଜଲେ ମଜ୍ଜିତୱାନ୍ ଇତି ସତ୍ୟଂ କିନ୍ତୁ ଯୂଯଂ ପୱିତ୍ର ଆତ୍ମନି ମଜ୍ଜିତା ଭୱିଷ୍ୟଥ, ଇତି ଯଦ୍ୱାକ୍ୟଂ ପ୍ରଭୁରୁଦିତୱାନ୍ ତତ୍ ତଦା ମଯା ସ୍ମୃତମ୍| ");
INSERT INTO sanori_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","ଅତଃ ପ୍ରଭା ଯୀଶୁଖ୍ରୀଷ୍ଟେ ପ୍ରତ୍ୟଯକାରିଣୋ ଯେ ୱଯମ୍ ଅସ୍ମଭ୍ୟମ୍ ଈଶ୍ୱରୋ ଯଦ୍ ଦତ୍ତୱାନ୍ ତତ୍ ତେଭ୍ୟୋ ଲୋକେଭ୍ୟୋପି ଦତ୍ତୱାନ୍ ତତଃ କୋହଂ? କିମହମ୍ ଈଶ୍ୱରଂ ୱାରଯିତୁଂ ଶକ୍ନୋମି? ");
INSERT INTO sanori_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","କଥାମେତାଂ ଶ୍ରୁୱା ତେ କ୍ଷାନ୍ତା ଈଶ୍ୱରସ୍ୟ ଗୁଣାନ୍ ଅନୁକୀର୍ତ୍ତ୍ୟ କଥିତୱନ୍ତଃ, ତର୍ହି ପରମାଯୁଃପ୍ରାପ୍ତିନିମିତ୍ତମ୍ ଈଶ୍ୱରୋନ୍ୟଦେଶୀଯଲୋକେଭ୍ୟୋପି ମନଃପରିୱର୍ତ୍ତନରୂପଂ ଦାନମ୍ ଅଦାତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","ସ୍ତିଫାନଂ ପ୍ରତି ଉପଦ୍ରୱେ ଘଟିତେ ଯେ ୱିକୀର୍ଣା ଅଭୱନ୍ ତୈ ଫୈନୀକୀକୁପ୍ରାନ୍ତିଯଖିଯାସୁ ଭ୍ରମିତ୍ୱା କେୱଲଯିହୂଦୀଯଲୋକାନ୍ ୱିନା କସ୍ୟାପ୍ୟନ୍ୟସ୍ୟ ସମୀପ ଈଶ୍ୱରସ୍ୟ କଥାଂ ନ ପ୍ରାଚାରଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","ଅପରଂ ତେଷାଂ କୁପ୍ରୀଯାଃ କୁରୀନୀଯାଶ୍ଚ କିଯନ୍ତୋ ଜନା ଆନ୍ତିଯଖିଯାନଗରଂ ଗତ୍ୱା ଯୂନାନୀଯଲୋକାନାଂ ସମୀପେପି ପ୍ରଭୋର୍ୟୀଶୋଃ କଥାଂ ପ୍ରାଚାରଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ପ୍ରଭୋଃ କରସ୍ତେଷାଂ ସହାଯ ଆସୀତ୍ ତସ୍ମାଦ୍ ଅନେକେ ଲୋକା ୱିଶ୍ୱସ୍ୟ ପ୍ରଭୁଂ ପ୍ରତି ପରାୱର୍ତ୍ତନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ଇତି ୱାର୍ତ୍ତାଯାଂ ଯିରୂଶାଲମସ୍ଥମଣ୍ଡଲୀଯଲୋକାନାଂ କର୍ଣଗୋଚରୀଭୂତାଯାମ୍ ଆନ୍ତିଯଖିଯାନଗରଂ ଗନ୍ତୁ ତେ ବର୍ଣବ୍ବାଂ ପ୍ରୈରଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ତତୋ ବର୍ଣବ୍ବାସ୍ତତ୍ର ଉପସ୍ଥିତଃ ସନ୍ ଈଶ୍ୱରସ୍ୟାନୁଗ୍ରହସ୍ୟ ଫଲଂ ଦୃଷ୍ଟ୍ୱା ସାନନ୍ଦୋ ଜାତଃ, ");
INSERT INTO sanori_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ସ ସ୍ୱଯଂ ସାଧୁ ର୍ୱିଶ୍ୱାସେନ ପୱିତ୍ରେଣାତ୍ମନା ଚ ପରିପୂର୍ଣଃ ସନ୍ ଗନୋନିଷ୍ଟଯା ପ୍ରଭାୱାସ୍ଥାଂ କର୍ତ୍ତୁଂ ସର୍ୱ୍ୱାନ୍ ଉପଦିଷ୍ଟୱାନ୍ ତେନ ପ୍ରଭୋଃ ଶିଷ୍ୟା ଅନେକେ ବଭୂୱୁଃ| ");
INSERT INTO sanori_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","ଶେଷେ ଶୌଲଂ ମୃଗଯିତୁଂ ବର୍ଣବ୍ବାସ୍ତାର୍ଷନଗରଂ ପ୍ରସ୍ଥିତୱାନ୍| ତତ୍ର ତସ୍ୟୋଦ୍ଦେଶଂ ପ୍ରାପ୍ୟ ତମ୍ ଆନ୍ତିଯଖିଯାନଗରମ୍ ଆନଯତ୍; ");
INSERT INTO sanori_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ତତସ୍ତୌ ମଣ୍ଡଲୀସ୍ଥଲୋକୈଃ ସଭାଂ କୃତ୍ୱା ସଂୱତ୍ସରମେକଂ ଯାୱଦ୍ ବହୁଲୋକାନ୍ ଉପାଦିଶତାଂ; ତସ୍ମିନ୍ ଆନ୍ତିଯଖିଯାନଗରେ ଶିଷ୍ୟାଃ ପ୍ରଥମଂ ଖ୍ରୀଷ୍ଟୀଯନାମ୍ନା ୱିଖ୍ୟାତା ଅଭୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","ତତଃ ପରଂ ଭୱିଷ୍ୟଦ୍ୱାଦିଗଣେ ଯିରୂଶାଲମ ଆନ୍ତିଯଖିଯାନଗରମ୍ ଆଗତେ ସତି ");
INSERT INTO sanori_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ଆଗାବନାମା ତେଷାମେକ ଉତ୍ଥାଯ ଆତ୍ମନଃ ଶିକ୍ଷଯା ସର୍ୱ୍ୱଦେଶେ ଦୁର୍ଭିକ୍ଷଂ ଭୱିଷ୍ୟତୀତି ଜ୍ଞାପିତୱାନ୍; ତତଃ କ୍ଲୌଦିଯକୈସରସ୍ୟାଧିକାରେ ସତି ତତ୍ ପ୍ରତ୍ୟକ୍ଷମ୍ ଅଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","ତସ୍ମାତ୍ ଶିଷ୍ୟା ଏକୈକଶଃ ସ୍ୱସ୍ୱଶକ୍ତ୍ୟନୁସାରତୋ ଯିହୂଦୀଯଦେଶନିୱାସିନାଂ ଭ୍ରତୃଣାଂ ଦିନଯାପନାର୍ଥଂ ଧନଂ ପ୍ରେଷଯିତୁଂ ନିଶ୍ଚିତ୍ୟ ");
INSERT INTO sanori_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ବର୍ଣବ୍ବାଶୌଲଯୋ ର୍ଦ୍ୱାରା ପ୍ରାଚୀନଲୋକାନାଂ ସମୀପଂ ତତ୍ ପ୍ରେଷିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","ତସ୍ମିନ୍ ସମଯେ ହେରୋଦ୍‌ରାଜୋ ମଣ୍ଡଲ୍ୟାଃ କିଯଜ୍ଜନେଭ୍ୟୋ ଦୁଃଖଂ ଦାତୁଂ ପ୍ରାରଭତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ୱିଶେଷତୋ ଯୋହନଃ ସୋଦରଂ ଯାକୂବଂ କରୱାଲାଘାତେନ୍ ହତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ତସ୍ମାଦ୍ ଯିହୂଦୀଯାଃ ସନ୍ତୁଷ୍ଟା ଅଭୱନ୍ ଇତି ୱିଜ୍ଞାଯ ସ ପିତରମପି ଧର୍ତ୍ତୁଂ ଗତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ତଦା କିଣ୍ୱଶୂନ୍ୟପୂପୋତ୍ସୱସମଯ ଉପାତିଷ୍ଟତ୍; ଅତ ଉତ୍ସୱେ ଗତେ ସତି ଲୋକାନାଂ ସମକ୍ଷଂ ତଂ ବହିରାନେଯ୍ୟାମୀତି ମନସି ସ୍ଥିରୀକୃତ୍ୟ ସ ତଂ ଧାରଯିତ୍ୱା ରକ୍ଷ୍ଣାର୍ଥମ୍ ଯେଷାମ୍ ଏକୈକସଂଘେ ଚତ୍ୱାରୋ ଜନାଃ ସନ୍ତି ତେଷାଂ ଚତୁର୍ଣାଂ ରକ୍ଷକସଂଘାନାଂ ସମୀପେ ତଂ ସମର୍ପ୍ୟ କାରାଯାଂ ସ୍ଥାପିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","କିନ୍ତୁଂ ପିତରସ୍ୟ କାରାସ୍ଥିତିକାରଣାତ୍ ମଣ୍ଡଲ୍ୟା ଲୋକା ଅୱିଶ୍ରାମମ୍ ଈଶ୍ୱରସ୍ୟ ସମୀପେ ପ୍ରାର୍ଥଯନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","ଅନନ୍ତରଂ ହେରୋଦି ତଂ ବହିରାନାଯିତୁଂ ଉଦ୍ୟତେ ସତି ତସ୍ୟାଂ ରାତ୍ରୌ ପିତରୋ ରକ୍ଷକଦ୍ୱଯମଧ୍ୟସ୍ଥାନେ ଶୃଙ୍ଖଲଦ୍ୱଯେନ ବଦ୍ଧ୍ୱଃ ସନ୍ ନିଦ୍ରିତ ଆସୀତ୍, ଦୌୱାରିକାଶ୍ଚ କାରାଯାଃ ସମ୍ମୁଖେ ତିଷ୍ଠନତୋ ଦ୍ୱାରମ୍ ଅରକ୍ଷିଷୁଃ| ");
INSERT INTO sanori_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ଏତସ୍ମିନ୍ ସମଯେ ପରମେଶ୍ୱରସ୍ୟ ଦୂତେ ସମୁପସ୍ଥିତେ କାରା ଦୀପ୍ତିମତୀ ଜାତା; ତତଃ ସ ଦୂତଃ ପିତରସ୍ୟ କୁକ୍ଷାୱାୱାତଂ କୃତ୍ୱା ତଂ ଜାଗରଯିତ୍ୱା ଭାଷିତୱାନ୍ ତୂର୍ଣମୁତ୍ତିଷ୍ଠ; ତତସ୍ତସ୍ୟ ହସ୍ତସ୍ଥଶୃଙ୍ଖଲଦ୍ୱଯଂ ଗଲତ୍ ପତିତଂ| ");
INSERT INTO sanori_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ସ ଦୂତସ୍ତମୱଦତ୍, ବଦ୍ଧକଟିଃ ସନ୍ ପାଦଯୋଃ ପାଦୁକେ ଅର୍ପଯ; ତେନ ତଥା କୃତେ ସତି ଦୂତସ୍ତମ୍ ଉକ୍ତୱାନ୍ ଗାତ୍ରୀଯୱସ୍ତ୍ରଂ ଗାତ୍ରେ ନିଧାଯ ମମ ପଶ୍ଚାଦ୍ ଏହି| ");
INSERT INTO sanori_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ତତଃ ପିତରସ୍ତସ୍ୟ ପଶ୍ଚାଦ୍ ୱ୍ରଜନ ବହିରଗଚ୍ଛତ୍, କିନ୍ତୁ ଦୂତେନ କର୍ମ୍ମୈତତ୍ କୃତମିତି ସତ୍ୟମଜ୍ଞାତ୍ୱା ସ୍ୱପ୍ନଦର୍ଶନଂ ଜ୍ଞାତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ଇତ୍ଥଂ ତୌ ପ୍ରଥମାଂ ଦ୍ୱିତୀଯାଞ୍ଚ କାରାଂ ଲଙ୍ଘିତ୍ୱା ଯେନ ଲୌହନିର୍ମ୍ମିତଦ୍ୱାରେଣ ନଗରଂ ଗମ୍ୟତେ ତତ୍ସମୀପଂ ପ୍ରାପ୍ନୁତାଂ; ତତସ୍ତସ୍ୟ କୱାଟଂ ସ୍ୱଯଂ ମୁକ୍ତମଭୱତ୍ ତତସ୍ତୌ ତତ୍ସ୍ଥାନାଦ୍ ବହି ର୍ଭୂତ୍ୱା ମାର୍ଗୈକସ୍ୟ ସୀମାଂ ଯାୱଦ୍ ଗତୌ; ତତୋଽକସ୍ମାତ୍ ସ ଦୂତଃ ପିତରଂ ତ୍ୟକ୍ତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","ତଦା ସ ଚେତନାଂ ପ୍ରାପ୍ୟ କଥିତୱାନ୍ ନିଜଦୂତଂ ପ୍ରହିତ୍ୟ ପରମେଶ୍ୱରୋ ହେରୋଦୋ ହସ୍ତାଦ୍ ଯିହୂଦୀଯଲୋକାନାଂ ସର୍ୱ୍ୱାଶାଯାଶ୍ଚ ମାଂ ସମୁଦ୍ଧୃତୱାନ୍ ଇତ୍ୟହଂ ନିଶ୍ଚଯଂ ଜ୍ଞାତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ସ ୱିୱିଚ୍ୟ ମାର୍କନାମ୍ରା ୱିଖ୍ୟାତସ୍ୟ ଯୋହନୋ ମାତୁ ର୍ମରିଯମୋ ଯସ୍ମିନ୍ ଗୃହେ ବହୱଃ ସମ୍ଭୂଯ ପ୍ରାର୍ଥଯନ୍ତ ତନ୍ନିୱେଶନଂ ଗତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","ପିତରେଣ ବହିର୍ଦ୍ୱାର ଆହତେ ସତି ରୋଦାନାମା ବାଲିକା ଦ୍ରଷ୍ଟୁଂ ଗତା| ");
INSERT INTO sanori_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","ତତଃ ପିତରସ୍ୟ ସ୍ୱରଂ ଶ୍ରୁୱା ସା ହର୍ଷଯୁକ୍ତା ସତୀ ଦ୍ୱାରଂ ନ ମୋଚଯିତ୍ୱା ପିତରୋ ଦ୍ୱାରେ ତିଷ୍ଠତୀତି ୱାର୍ତ୍ତାଂ ୱକ୍ତୁମ୍ ଅଭ୍ୟନ୍ତରଂ ଧାୱିତ୍ୱା ଗତୱତୀ| ");
INSERT INTO sanori_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","ତେ ପ୍ରାୱୋଚନ୍ ତ୍ୱମୁନ୍ମତ୍ତା ଜାତାସି କିନ୍ତୁ ସା ମୁହୁର୍ମୁହୁରୁକ୍ତୱତୀ ସତ୍ୟମେୱୈତତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","ତଦା ତେ କଥିତୱନ୍ତସ୍ତର୍ହି ତସ୍ୟ ଦୂତୋ ଭୱେତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","ପିତରୋ ଦ୍ୱାରମାହତୱାନ୍ ଏତସ୍ମିନ୍ନନ୍ତରେ ଦ୍ୱାରଂ ମୋଚଯିତ୍ୱା ପିତରଂ ଦୃଷ୍ଟ୍ୱା ୱିସ୍ମଯଂ ପ୍ରାପ୍ତାଃ| ");
INSERT INTO sanori_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","ତତଃ ପିତରୋ ନିଃଶବ୍ଦଂ ସ୍ଥାତୁଂ ତାନ୍ ପ୍ରତି ହସ୍ତେନ ସଙ୍କେତଂ କୃତ୍ୱା ପରମେଶ୍ୱରୋ ଯେନ ପ୍ରକାରେଣ ତଂ କାରାଯା ଉଦ୍ଧୃତ୍ୟାନୀତୱାନ୍ ତସ୍ୟ ୱୃତ୍ତାନ୍ତଂ ତାନଜ୍ଞାପଯତ୍, ଯୂଯଂ ଗତ୍ୱା ଯାକୁବଂ ଭ୍ରାତୃଗଣଞ୍ଚ ୱାର୍ତ୍ତାମେତାଂ ୱଦତେତ୍ୟୁକ୍ତା ସ୍ଥାନାନ୍ତରଂ ପ୍ରସ୍ଥିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ପ୍ରଭାତେ ସତି ପିତରଃ କ୍ୱ ଗତ ଇତ୍ୟତ୍ର ରକ୍ଷକାଣାଂ ମଧ୍ୟେ ମହାନ୍ କଲହୋ ଜାତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ହେରୋଦ୍ ବହୁ ମୃଗଯିତ୍ୱା ତସ୍ୟୋଦ୍ଦେଶେ ନ ପ୍ରାପ୍ତେ ସତି ରକ୍ଷକାନ୍ ସଂପୃଚ୍ଛ୍ୟ ତେଷାଂ ପ୍ରାଣାନ୍ ହନ୍ତୁମ୍ ଆଦିଷ୍ଟୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ପଶ୍ଚାତ୍ ସ ଯିହୂଦୀଯପ୍ରଦେଶାତ୍ କୈସରିଯାନଗରଂ ଗତ୍ୱା ତତ୍ରାୱାତିଷ୍ଠତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","ସୋରସୀଦୋନଦେଶଯୋ ର୍ଲୋକେଭ୍ୟୋ ହେରୋଦି ଯୁଯୁତ୍ସୌ ସତି ତେ ସର୍ୱ୍ୱ ଏକମନ୍ତ୍ରଣାଃ ସନ୍ତସ୍ତସ୍ୟ ସମୀପ ଉପସ୍ଥାଯ ଲ୍ୱାସ୍ତନାମାନଂ ତସ୍ୟ ୱସ୍ତ୍ରଗୃହାଧୀଶଂ ସହାଯଂ କୃତ୍ୱା ହେରୋଦା ସାର୍ଦ୍ଧଂ ସନ୍ଧିଂ ପ୍ରାର୍ଥଯନ୍ତ ଯତସ୍ତସ୍ୟ ରାଜ୍ଞୋ ଦେଶେନ ତେଷାଂ ଦେଶୀଯାନାଂ ଭରଣମ୍ ଅଭୱତ୍ଂ ");
INSERT INTO sanori_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","ଅତଃ କୁତ୍ରଚିନ୍ ନିରୁପିତଦିନେ ହେରୋଦ୍ ରାଜକୀଯଂ ପରିଚ୍ଛଦଂ ପରିଧାଯ ସିଂହାସନେ ସମୁପୱିଶ୍ୟ ତାନ୍ ପ୍ରତି କଥାମ୍ ଉକ୍ତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","ତତୋ ଲୋକା ଉଚ୍ଚୈଃକାରଂ ପ୍ରତ୍ୟୱଦନ୍, ଏଷ ମନୁଜରୱୋ ନ ହି, ଈଶ୍ୱରୀଯରୱଃ| ");
INSERT INTO sanori_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","ତଦା ହେରୋଦ୍ ଈଶ୍ୱରସ୍ୟ ସମ୍ମାନଂ ନାକରୋତ୍; ତସ୍ମାଦ୍ଧେତୋଃ ପରମେଶ୍ୱରସ୍ୟ ଦୂତୋ ହଠାତ୍ ତଂ ପ୍ରାହରତ୍ ତେନୈୱ ସ କୀଟୈଃ କ୍ଷୀଣଃ ସନ୍ ପ୍ରାଣାନ୍ ଅଜହାତ୍| କିନ୍ତ୍ୱୀଶ୍ୱରସ୍ୟ କଥା ଦେଶଂ ୱ୍ୟାପ୍ୟ ପ୍ରବଲାଭୱତ୍| ତତଃ ପରଂ ବର୍ଣବ୍ବାଶୌଲୌ ଯସ୍ୟ କର୍ମ୍ମଣୋ ଭାରଂ ପ୍ରାପ୍ନୁତାଂ ତାଭ୍ୟାଂ ତସ୍ମିନ୍ ସମ୍ପାଦିତେ ସତି ମାର୍କନାମ୍ନା ୱିଖ୍ୟାତୋ ଯୋ ଯୋହନ୍ ତଂ ସଙ୍ଗିନଂ କୃତ୍ୱା ଯିରୂଶାଲମ୍ନଗରାତ୍ ପ୍ରତ୍ୟାଗତୌ| ");
INSERT INTO sanori_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","ଅପରଞ୍ଚ ବର୍ଣବ୍ବାଃ, ଶିମୋନ୍ ଯଂ ନିଗ୍ରଂ ୱଦନ୍ତି, କୁରୀନୀଯଲୂକିଯୋ ହେରୋଦା ରାଜ୍ଞା ସହ କୃତୱିଦ୍ୟାाଭ୍ୟାସୋ ମିନହେମ୍, ଶୌଲଶ୍ଚୈତେ ଯେ କିଯନ୍ତୋ ଜନା ଭୱିଷ୍ୟଦ୍ୱାଦିନ ଉପଦେଷ୍ଟାରଶ୍ଚାନ୍ତିଯଖିଯାନଗରସ୍ଥମଣ୍ଡଲ୍ୟାମ୍ ଆସନ୍, ");
INSERT INTO sanori_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","ତେ ଯଦୋପୱାସଂ କୃତ୍ୱେଶ୍ୱରମ୍ ଅସେୱନ୍ତ ତସ୍ମିନ୍ ସମଯେ ପୱିତ୍ର ଆତ୍ମା କଥିତୱାନ୍ ଅହଂ ଯସ୍ମିନ୍ କର୍ମ୍ମଣି ବର୍ଣବ୍ବାଶୈଲୌ ନିଯୁକ୍ତୱାନ୍ ତତ୍କର୍ମ୍ମ କର୍ତ୍ତୁଂ ତୌ ପୃଥକ୍ କୁରୁତ| ");
INSERT INTO sanori_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","ତତସ୍ତୈରୁପୱାସପ୍ରାର୍ଥନଯୋଃ କୃତଯୋଃ ସତୋସ୍ତେ ତଯୋ ର୍ଗାତ୍ରଯୋ ର୍ହସ୍ତାର୍ପଣଂ କୃତ୍ୱା ତୌ ୱ୍ୟସୃଜନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","ତତଃ ପରଂ ତୌ ପୱିତ୍ରେଣାତ୍ମନା ପ୍ରେରିତୌ ସନ୍ତୌ ସିଲୂକିଯାନଗରମ୍ ଉପସ୍ଥାଯ ସମୁଦ୍ରପଥେନ କୁପ୍ରୋପଦ୍ୱୀପମ୍ ଅଗଚ୍ଛତାଂ| ");
INSERT INTO sanori_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ତତଃ ସାଲାମୀନଗରମ୍ ଉପସ୍ଥାଯ ତତ୍ର ଯିହୂଦୀଯାନାଂ ଭଜନଭୱନାନି ଗତ୍ୱେଶ୍ୱରସ୍ୟ କଥାଂ ପ୍ରାଚାରଯତାଂ; ଯୋହନପି ତତ୍ସହଚରୋଽଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ଇତ୍ଥଂ ତେ ତସ୍ୟୋପଦ୍ୱୀପସ୍ୟ ସର୍ୱ୍ୱତ୍ର ଭ୍ରମନ୍ତଃ ପାଫନଗରମ୍ ଉପସ୍ଥିତାଃ; ତତ୍ର ସୁୱିୱେଚକେନ ସର୍ଜିଯପୌଲନାମ୍ନା ତଦ୍ଦେଶାଧିପତିନା ସହ ଭୱିଷ୍ୟଦ୍ୱାଦିନୋ ୱେଶଧାରୀ ବର୍ୟୀଶୁନାମା ଯୋ ମାଯାୱୀ ଯିହୂଦୀ ଆସୀତ୍ ତଂ ସାକ୍ଷାତ୍ ପ୍ରାପ୍ତୱତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","ତଦ୍ଦେଶାଧିପ ଈଶ୍ୱରସ୍ୟ କଥାଂ ଶ୍ରୋତୁଂ ୱାଞ୍ଛନ୍ ପୌଲବର୍ଣବ୍ବୌ ନ୍ୟମନ୍ତ୍ରଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","କିନ୍ତ୍ୱିଲୁମା ଯଂ ମାଯାୱିନଂ ୱଦନ୍ତି ସ ଦେଶାଧିପତିଂ ଧର୍ମ୍ମମାର୍ଗାଦ୍ ବହିର୍ଭୂତଂ କର୍ତ୍ତୁମ୍ ଅଯତତ| ");
INSERT INTO sanori_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","ତସ୍ମାତ୍ ଶୋଲୋଽର୍ଥାତ୍ ପୌଲଃ ପୱିତ୍ରେଣାତ୍ମନା ପରିପୂର୍ଣଃ ସନ୍ ତଂ ମାଯାୱିନଂ ପ୍ରତ୍ୟନନ୍ୟଦୃଷ୍ଟିଂ କୃତ୍ୱାକଥଯତ୍, ");
INSERT INTO sanori_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ହେ ନରକିନ୍ ଧର୍ମ୍ମଦ୍ୱେଷିନ୍ କୌଟିଲ୍ୟଦୁଷ୍କର୍ମ୍ମପରିପୂର୍ଣ, ତ୍ୱଂ କିଂ ପ୍ରଭୋଃ ସତ୍ୟପଥସ୍ୟ ୱିପର୍ୟ୍ୟଯକରଣାତ୍ କଦାପି ନ ନିୱର୍ତ୍ତିଷ୍ୟସେ? ");
INSERT INTO sanori_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","ଅଧୁନା ପରମେଶ୍ୱରସ୍ତୱ ସମୁଚିତଂ କରିଷ୍ୟତି ତେନ କତିପଯଦିନାନି ତ୍ୱମ୍ ଅନ୍ଧଃ ସନ୍ ସୂର୍ୟ୍ୟମପି ନ ଦ୍ରକ୍ଷ୍ୟସି| ତତ୍କ୍ଷଣାଦ୍ ରାତ୍ରିୱଦ୍ ଅନ୍ଧକାରସ୍ତସ୍ୟ ଦୃଷ୍ଟିମ୍ ଆଚ୍ଛାଦିତୱାନ୍; ତସ୍ମାତ୍ ତସ୍ୟ ହସ୍ତଂ ଧର୍ତ୍ତୁଂ ସ ଲୋକମନ୍ୱିଚ୍ଛନ୍ ଇତସ୍ତତୋ ଭ୍ରମଣଂ କୃତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ଏନାଂ ଘଟନାଂ ଦୃଷ୍ଟ୍ୱା ସ ଦେଶାଧିପତିଃ ପ୍ରଭୂପଦେଶାଦ୍ ୱିସ୍ମିତ୍ୟ ୱିଶ୍ୱାସଂ କୃତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","ତଦନନ୍ତରଂ ପୌଲସ୍ତତ୍ସଙ୍ଗିନୌ ଚ ପାଫନଗରାତ୍ ପ୍ରୋତଂ ଚାଲଯିତ୍ୱା ପମ୍ଫୁଲିଯାଦେଶସ୍ୟ ପର୍ଗୀନଗରମ୍ ଅଗଚ୍ଛନ୍ କିନ୍ତୁ ଯୋହନ୍ ତଯୋଃ ସମୀପାଦ୍ ଏତ୍ୟ ଯିରୂଶାଲମଂ ପ୍ରତ୍ୟାଗଚ୍ଛତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","ପଶ୍ଚାତ୍ ତୌ ପର୍ଗୀତୋ ଯାତ୍ରାଂ କୃତ୍ୱା ପିସିଦିଯାଦେଶସ୍ୟ ଆନ୍ତିଯଖିଯାନଗରମ୍ ଉପସ୍ଥାଯ ୱିଶ୍ରାମୱାରେ ଭଜନଭୱନଂ ପ୍ରୱିଶ୍ୟ ସମୁପାୱିଶତାଂ| ");
INSERT INTO sanori_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ୱ୍ୟୱସ୍ଥାଭୱିଷ୍ୟଦ୍ୱାକ୍ୟଯୋଃ ପଠିତଯୋଃ ସତୋ ର୍ହେ ଭ୍ରାତରୌ ଲୋକାନ୍ ପ୍ରତି ଯୁୱଯୋଃ କାଚିଦ୍ ଉପଦେଶକଥା ଯଦ୍ୟସ୍ତି ତର୍ହି ତାଂ ୱଦତଂ ତୌ ପ୍ରତି ତସ୍ୟ ଭଜନଭୱନସ୍ୟାଧିପତଯଃ କଥାମ୍ ଏତାଂ କଥଯିତ୍ୱା ପ୍ରୈଷଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ଅତଃ ପୌଲ ଉତ୍ତିଷ୍ଠନ୍ ହସ୍ତେନ ସଙ୍କେତଂ କୁର୍ୱ୍ୱନ୍ କଥିତୱାନ୍ ହେ ଇସ୍ରାଯେଲୀଯମନୁଷ୍ୟା ଈଶ୍ୱରପରାଯଣାଃ ସର୍ୱ୍ୱେ ଲୋକା ଯୂଯମ୍ ଅୱଧଦ୍ଧଂ| ");
INSERT INTO sanori_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ଏତେଷାମିସ୍ରାଯେଲ୍ଲୋକାନାମ୍ ଈଶ୍ୱରୋଽସ୍ମାକଂ ପୂର୍ୱ୍ୱପରୁଷାନ୍ ମନୋନୀତାନ୍ କତ୍ୱା ଗୃହୀତୱାନ୍ ତତୋ ମିସରି ଦେଶେ ପ୍ରୱସନକାଲେ ତେଷାମୁନ୍ନତିଂ କୃତ୍ୱା ତସ୍ମାତ୍ ସ୍ୱୀଯବାହୁବଲେନ ତାନ୍ ବହିଃ କୃତ୍ୱା ସମାନଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ଚତ୍ୱାରିଂଶଦ୍ୱତ୍ସରାନ୍ ଯାୱଚ୍ଚ ମହାପ୍ରାନ୍ତରେ ତେଷାଂ ଭରଣଂ କୃତ୍ୱା ");
INSERT INTO sanori_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","କିନାନ୍ଦେଶାନ୍ତର୍ୱ୍ୱର୍ତ୍ତୀଣି ସପ୍ତରାଜ୍ୟାନି ନାଶଯିତ୍ୱା ଗୁଟିକାପାତେନ ତେଷୁ ସର୍ୱ୍ୱଦେଶେଷୁ ତେଭ୍ୟୋଽଧିକାରଂ ଦତ୍ତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ପଞ୍ଚାଶଦଧିକଚତୁଃଶତେଷୁ ୱତ୍ସରେଷୁ ଗତେଷୁ ଚ ଶିମୂଯେଲ୍ଭୱିଷ୍ୟଦ୍ୱାଦିପର୍ୟ୍ୟନ୍ତଂ ତେଷାମୁପରି ୱିଚାରଯିତୃନ୍ ନିଯୁକ୍ତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","ତୈଶ୍ଚ ରାଜ୍ଞି ପ୍ରାର୍ଥିତେ, ଈଶ୍ୱରୋ ବିନ୍ୟାମୀନୋ ୱଂଶଜାତସ୍ୟ କୀଶଃ ପୁତ୍ରଂ ଶୌଲଂ ଚତ୍ୱାରିଂଶଦ୍ୱର୍ଷପର୍ୟ୍ୟନ୍ତଂ ତେଷାମୁପରି ରାଜାନଂ କୃତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","ପଶ୍ଚାତ୍ ତଂ ପଦଚ୍ୟୁତଂ କୃତ୍ୱା ଯୋ ମଦିଷ୍ଟକ୍ରିଯାଃ ସର୍ୱ୍ୱାଃ କରିଷ୍ୟତି ତାଦୃଶଂ ମମ ମନୋଭିମତମ୍ ଏକଂ ଜନଂ ଯିଶଯଃ ପୁତ୍ରଂ ଦାଯୂଦଂ ପ୍ରାପ୍ତୱାନ୍ ଇଦଂ ପ୍ରମାଣଂ ଯସ୍ମିନ୍ ଦାଯୂଦି ସ ଦତ୍ତୱାନ୍ ତଂ ଦାଯୂଦଂ ତେଷାମୁପରି ରାଜତ୍ୱଂ କର୍ତ୍ତୁମ୍ ଉତ୍ପାଦିତୱାନ| ");
INSERT INTO sanori_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","ତସ୍ୟ ସ୍ୱପ୍ରତିଶ୍ରୁତସ୍ୟ ୱାକ୍ୟସ୍ୟାନୁସାରେଣ ଇସ୍ରାଯେଲ୍ଲୋକାନାଂ ନିମିତ୍ତଂ ତେଷାଂ ମନୁଷ୍ୟାଣାଂ ୱଂଶାଦ୍ ଈଶ୍ୱର ଏକଂ ଯୀଶୁଂ (ତ୍ରାତାରମ୍) ଉଦପାଦଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","ତସ୍ୟ ପ୍ରକାଶନାତ୍ ପୂର୍ୱ୍ୱଂ ଯୋହନ୍ ଇସ୍ରାଯେଲ୍ଲୋକାନାଂ ସନ୍ନିଧୌ ମନଃପରାୱର୍ତ୍ତନରୂପଂ ମଜ୍ଜନଂ ପ୍ରାଚାରଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ଯସ୍ୟ ଚ କର୍ମ୍ମଣୋे ଭାରଂ ପ୍ରପ୍ତୱାନ୍ ଯୋହନ୍ ତନ୍ ନିଷ୍ପାଦଯନ୍ ଏତାଂ କଥାଂ କଥିତୱାନ୍, ଯୂଯଂ ମାଂ କଂ ଜନଂ ଜାନୀଥ? ଅହମ୍ ଅଭିଷିକ୍ତତ୍ରାତା ନହି, କିନ୍ତୁ ପଶ୍ୟତ ଯସ୍ୟ ପାଦଯୋଃ ପାଦୁକଯୋ ର୍ବନ୍ଧନେ ମୋଚଯିତୁମପି ଯୋଗ୍ୟୋ ନ ଭୱାମି ତାଦୃଶ ଏକୋ ଜନୋ ମମ ପଶ୍ଚାଦ୍ ଉପତିଷ୍ଠତି| ");
INSERT INTO sanori_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","ହେ ଇବ୍ରାହୀମୋ ୱଂଶଜାତା ଭ୍ରାତରୋ ହେ ଈଶ୍ୱରଭୀତାଃ ସର୍ୱ୍ୱଲୋକା ଯୁଷ୍ମାନ୍ ପ୍ରତି ପରିତ୍ରାଣସ୍ୟ କଥୈଷା ପ୍ରେରିତା| ");
INSERT INTO sanori_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","ଯିରୂଶାଲମ୍ନିୱାସିନସ୍ତେଷାମ୍ ଅଧିପତଯଶ୍ଚ ତସ୍ୟ ଯୀଶୋଃ ପରିଚଯଂ ନ ପ୍ରାପ୍ୟ ପ୍ରତିୱିଶ୍ରାମୱାରଂ ପଠ୍ୟମାନାନାଂ ଭୱିଷ୍ୟଦ୍ୱାଦିକଥାନାମ୍ ଅଭିପ୍ରାଯମ୍ ଅବୁଦ୍ଧ୍ୱା ଚ ତସ୍ୟ ୱଧେନ ତାଃ କଥାଃ ସଫଲା ଅକୁର୍ୱ୍ୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","ପ୍ରାଣହନନସ୍ୟ କମପି ହେତୁମ୍ ଅପ୍ରାପ୍ୟାପି ପୀଲାତସ୍ୟ ନିକଟେ ତସ୍ୟ ୱଧଂ ପ୍ରାର୍ଥଯନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","ତସ୍ମିନ୍ ଯାଃ କଥା ଲିଖିତାଃ ସନ୍ତି ତଦନୁସାରେଣ କର୍ମ୍ମ ସମ୍ପାଦ୍ୟ ତଂ କ୍ରୁଶାଦ୍ ଅୱତାର୍ୟ୍ୟ ଶ୍ମଶାନେ ଶାଯିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","କିନ୍ତ୍ୱୀଶ୍ୱରଃ ଶ୍ମଶାନାତ୍ ତମୁଦସ୍ଥାପଯତ୍, ");
INSERT INTO sanori_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ପୁନଶ୍ଚ ଗାଲୀଲପ୍ରଦେଶାଦ୍ ଯିରୂଶାଲମନଗରଂ ତେନ ସାର୍ଦ୍ଧଂ ଯେ ଲୋକା ଆଗଚ୍ଛନ୍ ସ ବହୁଦିନାନି ତେଭ୍ୟୋ ଦର୍ଶନଂ ଦତ୍ତୱାନ୍, ଅତସ୍ତ ଇଦାନୀଂ ଲୋକାନ୍ ପ୍ରତି ତସ୍ୟ ସାକ୍ଷିଣଃ ସନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","ଅସ୍ମାକଂ ପୂର୍ୱ୍ୱପୁରୁଷାଣାଂ ସମକ୍ଷମ୍ ଈଶ୍ୱରୋ ଯସ୍ମିନ୍ ପ୍ରତିଜ୍ଞାତୱାନ୍ ଯଥା, ତ୍ୱଂ ମେ ପୁତ୍ରୋସି ଚାଦ୍ୟ ତ୍ୱାଂ ସମୁତ୍ଥାପିତୱାନହମ୍| ");
INSERT INTO sanori_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ଇଦଂ ଯଦ୍ୱଚନଂ ଦ୍ୱିତୀଯଗୀତେ ଲିଖିତମାସ୍ତେ ତଦ୍ ଯୀଶୋରୁତ୍ଥାନେନ ତେଷାଂ ସନ୍ତାନା ଯେ ୱଯମ୍ ଅସ୍ମାକଂ ସନ୍ନିଧୌ ତେନ ପ୍ରତ୍ୟକ୍ଷୀ କୃତଂ, ଯୁଷ୍ମାନ୍ ଇମଂ ସୁସଂୱାଦଂ ଜ୍ଞାପଯାମି| ");
INSERT INTO sanori_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","ପରମେଶ୍ୱରେଣ ଶ୍ମଶାନାଦ୍ ଉତ୍ଥାପିତଂ ତଦୀଯଂ ଶରୀରଂ କଦାପି ନ କ୍ଷେଷ୍ୟତେ, ଏତସ୍ମିନ୍ ସ ସ୍ୱଯଂ କଥିତୱାନ୍ ଯଥା ଦାଯୂଦଂ ପ୍ରତି ପ୍ରତିଜ୍ଞାତୋ ଯୋ ୱରସ୍ତମହଂ ତୁଭ୍ୟଂ ଦାସ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","ଏତଦନ୍ୟସ୍ମିନ୍ ଗୀତେଽପି କଥିତୱାନ୍| ସ୍ୱକୀଯଂ ପୁଣ୍ୟୱନ୍ତଂ ତ୍ୱଂ କ୍ଷଯିତୁଂ ନ ଚ ଦାସ୍ୟସି| ");
INSERT INTO sanori_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","ଦାଯୂଦା ଈଶ୍ୱରାଭିମତସେୱାଯୈ ନିଜାଯୁଷି ୱ୍ୟଯିତେ ସତି ସ ମହାନିଦ୍ରାଂ ପ୍ରାପ୍ୟ ନିଜୈଃ ପୂର୍ୱ୍ୱପୁରୁଷୈଃ ସହ ମିଲିତଃ ସନ୍ ଅକ୍ଷୀଯତ; ");
INSERT INTO sanori_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","କିନ୍ତୁ ଯମୀଶ୍ୱରଃ ଶ୍ମଶାନାଦ୍ ଉଦସ୍ଥାପଯତ୍ ସ ନାକ୍ଷୀଯତ| ");
INSERT INTO sanori_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","ଅତୋ ହେ ଭ୍ରାତରଃ, ଅନେନ ଜନେନ ପାପମୋଚନଂ ଭୱତୀତି ଯୁଷ୍ମାନ୍ ପ୍ରତି ପ୍ରଚାରିତମ୍ ଆସ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ଫଲତୋ ମୂସାୱ୍ୟୱସ୍ଥଯା ଯୂଯଂ ଯେଭ୍ୟୋ ଦୋଷେଭ୍ୟୋ ମୁକ୍ତା ଭୱିତୁଂ ନ ଶକ୍ଷ୍ୟଥ ତେଭ୍ୟଃ ସର୍ୱ୍ୱଦୋଷେଭ୍ୟ ଏତସ୍ମିନ୍ ଜନେ ୱିଶ୍ୱାସିନଃ ସର୍ୱ୍ୱେ ମୁକ୍ତା ଭୱିଷ୍ୟନ୍ତୀତି ଯୁଷ୍ମାଭି ର୍ଜ୍ଞାଯତାଂ| ");
INSERT INTO sanori_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","ଅପରଞ୍ଚ| ଅୱଜ୍ଞାକାରିଣୋ ଲୋକାଶ୍ଚକ୍ଷୁରୁନ୍ମୀଲ୍ୟ ପଶ୍ୟତ| ତଥୈୱାସମ୍ଭୱଂ ଜ୍ଞାତ୍ୱା ସ୍ୟାତ ଯୂଯଂ ୱିଲଜ୍ଜିତାଃ| ଯତୋ ଯୁଷ୍ମାସୁ ତିଷ୍ଠତ୍ସୁ କରିଷ୍ୟେ କର୍ମ୍ମ ତାଦୃଶଂ| ଯେନୈୱ ତସ୍ୟ ୱୃତ୍ତାନ୍ତେ ଯୁଷ୍ମଭ୍ୟଂ କଥିତେଽପି ହି| ଯୂଯଂ ନ ତନ୍ତୁ ୱୃତ୍ତାନ୍ତଂ ପ୍ରତ୍ୟେଷ୍ୟଥ କଦାଚନ|| ");
INSERT INTO sanori_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","ଯେଯଂ କଥା ଭୱିଷ୍ୟଦ୍ୱାଦିନାଂ ଗ୍ରନ୍ଥେଷୁ ଲିଖିତାସ୍ତେ ସାୱଧାନା ଭୱତ ସ କଥା ଯଥା ଯୁଷ୍ମାନ୍ ପ୍ରତି ନ ଘଟତେ| ");
INSERT INTO sanori_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ଯିହୂଦୀଯଭଜନଭୱନାନ୍ ନିର୍ଗତଯୋସ୍ତଯୋ ର୍ଭିନ୍ନଦେଶୀଯୈ ର୍ୱକ୍ଷ୍ୟମାଣା ପ୍ରାର୍ଥନା କୃତା, ଆଗାମିନି ୱିଶ୍ରାମୱାରେଽପି କଥେଯମ୍ ଅସ୍ମାନ୍ ପ୍ରତି ପ୍ରଚାରିତା ଭୱତ୍ୱିତି| ");
INSERT INTO sanori_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","ସଭାଯା ଭଙ୍ଗେ ସତି ବହୱୋ ଯିହୂଦୀଯଲୋକା ଯିହୂଦୀଯମତଗ୍ରାହିଣୋ ଭକ୍ତଲୋକାଶ୍ଚ ବର୍ଣବ୍ବାପୌଲଯୋଃ ପଶ୍ଚାଦ୍ ଆଗଚ୍ଛନ୍, ତେନ ତୌ ତୈଃ ସହ ନାନାକଥାଃ କଥଯିତ୍ୱେଶ୍ୱରାନୁଗ୍ରହାଶ୍ରଯେ ସ୍ଥାତୁଂ ତାନ୍ ପ୍ରାୱର୍ତ୍ତଯତାଂ| ");
INSERT INTO sanori_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","ପରୱିଶ୍ରାମୱାରେ ନଗରସ୍ୟ ପ୍ରାଯେଣ ସର୍ୱ୍ୱେ ଲାକା ଈଶ୍ୱରୀଯାଂ କଥାଂ ଶ୍ରୋତୁଂ ମିଲିତାଃ, ");
INSERT INTO sanori_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","କିନ୍ତୁ ଯିହୂଦୀଯଲୋକା ଜନନିୱହଂ ୱିଲୋକ୍ୟ ଈର୍ଷ୍ୟଯା ପରିପୂର୍ଣାଃ ସନ୍ତୋ ୱିପରୀତକଥାକଥନେନେଶ୍ୱରନିନ୍ଦଯା ଚ ପୌଲେନୋକ୍ତାଂ କଥାଂ ଖଣ୍ଡଯିତୁଂ ଚେଷ୍ଟିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","ତତଃ ପୌैଲବର୍ଣବ୍ବାୱକ୍ଷୋଭୌ କଥିତୱନ୍ତୌ ପ୍ରଥମଂ ଯୁଷ୍ମାକଂ ସନ୍ନିଧାୱୀଶ୍ୱରୀଯକଥାଯାଃ ପ୍ରଚାରଣମ୍ ଉଚିତମାସୀତ୍ କିନ୍ତୁଂ ତଦଗ୍ରାହ୍ୟତ୍ୱକରଣେନ ଯୂଯଂ ସ୍ୱାନ୍ ଅନନ୍ତାଯୁଷୋଽଯୋଗ୍ୟାନ୍ ଦର୍ଶଯଥ, ଏତତ୍କାରଣାଦ୍ ୱଯମ୍ ଅନ୍ୟଦେଶୀଯଲୋକାନାଂ ସମୀପଂ ଗଚ୍ଛାମଃ| ");
INSERT INTO sanori_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ପ୍ରଭୁରସ୍ମାନ୍ ଇତ୍ଥମ୍ ଆଦିଷ୍ଟୱାନ୍ ଯଥା, ଯାୱଚ୍ଚ ଜଗତଃ ସୀମାଂ ଲୋକାନାଂ ତ୍ରାଣକାରଣାତ୍| ମଯାନ୍ୟଦେଶମଧ୍ୟେ ତ୍ୱଂ ସ୍ଥାପିତୋ ଭୂଃ ପ୍ରଦୀପୱତ୍|| ");
INSERT INTO sanori_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","ତଦା କଥାମୀଦୃଶୀଂ ଶ୍ରୁତ୍ୱା ଭିନ୍ନଦେଶୀଯା ଆହ୍ଲାଦିତାଃ ସନ୍ତଃ ପ୍ରଭୋଃ କଥାଂ ଧନ୍ୟାଂ ଧନ୍ୟାମ୍ ଅୱଦନ୍, ଯାୱନ୍ତୋ ଲୋକାଶ୍ଚ ପରମାଯୁଃ ପ୍ରାପ୍ତିନିମିତ୍ତଂ ନିରୂପିତା ଆସନ୍ ତେे ୱ୍ୟଶ୍ୱସନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ଇତ୍ଥଂ ପ୍ରଭୋଃ କଥା ସର୍ୱ୍ୱେଦେଶଂ ୱ୍ୟାପ୍ନୋତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","କିନ୍ତୁ ଯିହୂଦୀଯା ନଗରସ୍ୟ ପ୍ରଧାନପୁରୁଷାନ୍ ସମ୍ମାନ୍ୟାଃ କଥିପଯା ଭକ୍ତା ଯୋଷିତଶ୍ଚ କୁପ୍ରୱୃତ୍ତିଂ ଗ୍ରାହଯିତ୍ୱା ପୌଲବର୍ଣବ୍ବୌ ତାଡଯିତ୍ୱା ତସ୍ମାତ୍ ପ୍ରଦେଶାଦ୍ ଦୂରୀକୃତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","ଅତଃ କାରଣାତ୍ ତୌ ନିଜପଦଧୂଲୀସ୍ତେଷାଂ ପ୍ରାତିକୂଲ୍ୟେନ ପାତଯିତ୍ୱେेକନିଯଂ ନଗରଂ ଗତୌ| ");
INSERT INTO sanori_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","ତତଃ ଶିଷ୍ୟଗଣ ଆନନ୍ଦେନ ପୱିତ୍ରେଣାତ୍ମନା ଚ ପରିପୂର୍ଣୋଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","ତୌ ଦ୍ୱୌ ଜନୌ ଯୁଗପଦ୍ ଇକନିଯନଗରସ୍ଥଯିହୂଦୀଯାନାଂ ଭଜନଭୱନଂ ଗତ୍ୱା ଯଥା ବହୱୋ ଯିହୂଦୀଯା ଅନ୍ୟଦେेଶୀଯଲୋକାଶ୍ଚ ୱ୍ୟଶ୍ୱସନ୍ ତାଦୃଶୀଂ କଥାଂ କଥିତୱନ୍ତୌ| ");
INSERT INTO sanori_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","କିନ୍ତୁ ୱିଶ୍ୱାସହୀନା ଯିହୂଦୀଯା ଅନ୍ୟଦେଶୀଯଲୋକାନ୍ କୁପ୍ରୱୃତ୍ତିଂ ଗ୍ରାହଯିତ୍ୱା ଭ୍ରାତୃଗଣଂ ପ୍ରତି ତେଷାଂ ୱୈରଂ ଜନିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ଅତଃ ସ୍ୱାନୁଗ୍ରହକଥାଯାଃ ପ୍ରମାଣଂ ଦତ୍ୱା ତଯୋ ର୍ହସ୍ତୈ ର୍ବହୁଲକ୍ଷଣମ୍ ଅଦ୍ଭୁତକର୍ମ୍ମ ଚ ପ୍ରାକାଶଯଦ୍ ଯଃ ପ୍ରଭୁସ୍ତସ୍ୟ କଥା ଅକ୍ଷୋଭେନ ପ୍ରଚାର୍ୟ୍ୟ ତୌ ତତ୍ର ବହୁଦିନାନି ସମୱାତିଷ୍ଠେତାଂ| ");
INSERT INTO sanori_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","କିନ୍ତୁ କିଯନ୍ତୋ ଲୋକା ଯିହୂଦୀଯାନାଂ ସପକ୍ଷାଃ କିଯନ୍ତୋ ଲୋକାଃ ପ୍ରେରିତାନାଂ ସପକ୍ଷା ଜାତାଃ, ଅତୋ ନାଗରିକଜନନିୱହମଧ୍ୟେ ଭିନ୍ନୱାକ୍ୟତ୍ୱମ୍ ଅଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","ଅନ୍ୟଦେଶୀଯା ଯିହୂଦୀଯାସ୍ତେଷାମ୍ ଅଧିପତଯଶ୍ଚ ଦୌରାତ୍ମ୍ୟଂ କୁତ୍ୱା ତୌ ପ୍ରସ୍ତରୈରାହନ୍ତୁମ୍ ଉଦ୍ୟତାଃ| ");
INSERT INTO sanori_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ତୌ ତଦ୍ୱାର୍ତ୍ତାଂ ପ୍ରାପ୍ୟ ପଲାଯିତ୍ୱା ଲୁକାଯନିଯାଦେଶସ୍ୟାନ୍ତର୍ୱ୍ୱର୍ତ୍ତିଲୁସ୍ତ୍ରାଦର୍ବ୍ବୋ ");
INSERT INTO sanori_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ତତ୍ସମୀପସ୍ଥଦେଶଞ୍ଚ ଗତ୍ୱା ତତ୍ର ସୁସଂୱାଦଂ ପ୍ରଚାରଯତାଂ| ");
INSERT INTO sanori_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","ତତ୍ରୋଭଯପାଦଯୋଶ୍ଚଲନଶକ୍ତିହୀନୋ ଜନ୍ମାରଭ୍ୟ ଖଞ୍ଜଃ କଦାପି ଗମନଂ ନାକରୋତ୍ ଏତାଦୃଶ ଏକୋ ମାନୁଷୋ ଲୁସ୍ତ୍ରାନଗର ଉପୱିଶ୍ୟ ପୌଲସ୍ୟ କଥାଂ ଶ୍ରୁତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ଏତସ୍ମିନ୍ ସମଯେ ପୌଲସ୍ତମ୍ପ୍ରତି ଦୃଷ୍ଟିଂ କୃତ୍ୱା ତସ୍ୟ ସ୍ୱାସ୍ଥ୍ୟେ ୱିଶ୍ୱାସଂ ୱିଦିତ୍ୱା ପ୍ରୋଚ୍ଚୈଃ କଥିତୱାନ୍ ");
INSERT INTO sanori_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ପଦ୍ଭ୍ୟାମୁତ୍ତିଷ୍ଠନ୍ ଋଜୁ ର୍ଭୱ| ତତଃ ସ ଉଲ୍ଲମ୍ଫଂ କୃତ୍ୱା ଗମନାଗମନେ କୁତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","ତଦା ଲୋକାଃ ପୌଲସ୍ୟ ତତ୍ କାର୍ୟ୍ୟଂ ୱିଲୋକ୍ୟ ଲୁକାଯନୀଯଭାଷଯା ପ୍ରୋଚ୍ଚୈଃ କଥାମେତାଂ କଥିତୱନ୍ତଃ, ଦେୱା ମନୁଷ୍ୟରୂପଂ ଧୃତ୍ୱାସ୍ମାକଂ ସମୀପମ୍ ଅୱାରୋହନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","ତେ ବର୍ଣବ୍ବାଂ ଯୂପିତରମ୍ ଅୱଦନ୍ ପୌଲଶ୍ଚ ମୁଖ୍ୟୋ ୱକ୍ତା ତସ୍ମାତ୍ ତଂ ମର୍କୁରିଯମ୍ ଅୱଦନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ତସ୍ୟ ନଗରସ୍ୟ ସମ୍ମୁଖେ ସ୍ଥାପିତସ୍ୟ ଯୂପିତରୱିଗ୍ରହସ୍ୟ ଯାଜକୋ ୱୃଷାନ୍ ପୁଷ୍ପମାଲାଶ୍ଚ ଦ୍ୱାରସମୀପମ୍ ଆନୀଯ ଲୋକୈଃ ସର୍ଦ୍ଧଂ ତାୱୁଦ୍ଦିଶ୍ୟ ସମୁତ୍ସୃଜ୍ୟ ଦାତୁମ୍ ଉଦ୍ୟତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","ତଦ୍ୱାର୍ତ୍ତାଂ ଶ୍ରୁତ୍ୱା ବର୍ଣବ୍ବାପୌଲୌ ସ୍ୱୀଯୱସ୍ତ୍ରାଣି ଛିତ୍ୱା ଲୋକାନାଂ ମଧ୍ୟଂ ୱେଗେନ ପ୍ରୱିଶ୍ୟ ପ୍ରୋଚ୍ଚୈଃ କଥିତୱନ୍ତୌ, ");
INSERT INTO sanori_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","ହେ ମହେଚ୍ଛାଃ କୁତ ଏତାଦୃଶଂ କର୍ମ୍ମ କୁରୁଥ? ଆୱାମପି ଯୁଷ୍ମାଦୃଶୌ ସୁଖଦୁଃଖଭୋଗିନୌ ମନୁଷ୍ୟୌ, ଯୁଯମ୍ ଏତାଃ ସର୍ୱ୍ୱା ୱୃଥାକଲ୍ପନାଃ ପରିତ୍ୟଜ୍ୟ ଯଥା ଗଗଣୱସୁନ୍ଧରାଜଲନିଧୀନାଂ ତନ୍ମଧ୍ୟସ୍ଥାନାଂ ସର୍ୱ୍ୱେଷାଞ୍ଚ ସ୍ରଷ୍ଟାରମମରମ୍ ଈଶ୍ୱରଂ ପ୍ରତି ପରାୱର୍ତ୍ତଧ୍ୱେ ତଦର୍ଥମ୍ ଆୱାଂ ଯୁଷ୍ମାକଂ ସନ୍ନିଧୌ ସୁସଂୱାଦଂ ପ୍ରଚାରଯାୱଃ| ");
INSERT INTO sanori_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ସ ଈଶ୍ୱରଃ ପୂର୍ୱ୍ୱକାଲେ ସର୍ୱ୍ୱଦେଶୀଯଲୋକାନ୍ ସ୍ୱସ୍ୱମାର୍ଗେ ଚଲିତୁମନୁମତିଂ ଦତ୍ତୱାନ୍, ");
INSERT INTO sanori_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ତଥାପି ଆକାଶାତ୍ ତୋଯୱର୍ଷଣେନ ନାନାପ୍ରକାରଶସ୍ୟୋତ୍ପତ୍ୟା ଚ ଯୁଷ୍ମାକଂ ହିତୈଷୀ ସନ୍ ଭକ୍ଷ୍ୟୈରାନନଦେନ ଚ ଯୁଷ୍ମାକମ୍ ଅନ୍ତଃକରଣାନି ତର୍ପଯନ୍ ତାନି ଦାନାନି ନିଜସାକ୍ଷିସ୍ୱରୂପାଣି ସ୍ଥପିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","କିନ୍ତୁ ତାଦୃଶାଯାଂ କଥାଯାଂ କଥିତାଯାମପି ତଯୋଃ ସମୀପ ଉତ୍ସର୍ଜନାତ୍ ଲୋକନିୱହଂ ପ୍ରାଯେଣ ନିୱର୍ତ୍ତଯିତୁଂ ନାଶକ୍ନୁତାମ୍| ");
INSERT INTO sanori_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","ଆନ୍ତିଯଖିଯା-ଇକନିଯନଗରାଭ୍ୟାଂ କତିପଯଯିହୂଦୀଯଲୋକା ଆଗତ୍ୟ ଲୋକାନ୍ ପ୍ରାୱର୍ତ୍ତଯନ୍ତ ତସ୍ମାତ୍ ତୈ ପୌଲଂ ପ୍ରସ୍ତରୈରାଘ୍ନନ୍ ତେନ ସ ମୃତ ଇତି ୱିଜ୍ଞାଯ ନଗରସ୍ୟ ବହିସ୍ତମ୍ ଆକୃଷ୍ୟ ନୀତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","କିନ୍ତୁ ଶିଷ୍ୟଗଣେ ତସ୍ୟ ଚତୁର୍ଦିଶି ତିଷ୍ଠତି ସତି ସ ସ୍ୱଯମ୍ ଉତ୍ଥାଯ ପୁନରପି ନଗରମଧ୍ୟଂ ପ୍ରାୱିଶତ୍ ତତ୍ପରେଽହନି ବର୍ଣବ୍ବାସହିତୋ ଦର୍ବ୍ବୀନଗରଂ ଗତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","ତତ୍ର ସୁସଂୱାଦଂ ପ୍ରଚାର୍ୟ୍ୟ ବହୁଲୋକାନ୍ ଶିଷ୍ୟାନ୍ କୃତ୍ୱା ତୌ ଲୁସ୍ତ୍ରାମ୍ ଇକନିଯମ୍ ଆନ୍ତିଯଖିଯାଞ୍ଚ ପରାୱୃତ୍ୟ ଗତୌ| ");
INSERT INTO sanori_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ବହୁଦୁଃଖାନି ଭୁକ୍ତ୍ୱାପୀଶ୍ୱରରାଜ୍ୟଂ ପ୍ରୱେଷ୍ଟୱ୍ୟମ୍ ଇତି କାରଣାଦ୍ ଧର୍ମ୍ମମାର୍ଗେ ସ୍ଥାତୁଂ ୱିନଯଂ କୃତ୍ୱା ଶିଷ୍ୟଗଣସ୍ୟ ମନଃସ୍ଥୈର୍ୟ୍ୟମ୍ ଅକୁରୁତାଂ| ");
INSERT INTO sanori_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","ମଣ୍ଡଲୀନାଂ ପ୍ରାଚୀନୱର୍ଗାନ୍ ନିଯୁଜ୍ୟ ପ୍ରାର୍ଥନୋପୱାସୌ କୃତ୍ୱା ଯତ୍ପ୍ରଭୌ ତେ ୱ୍ୟଶ୍ୱସନ୍ ତସ୍ୟ ହସ୍ତେ ତାନ୍ ସମର୍ପ୍ୟ ");
INSERT INTO sanori_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","ପିସିଦିଯାମଧ୍ୟେନ ପାମ୍ଫୁଲିଯାଦେଶଂ ଗତୱନ୍ତୌ| ");
INSERT INTO sanori_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ପଶ୍ଚାତ୍ ପର୍ଗାନଗରଂ ଗତ୍ୱା ସୁସଂୱାଦଂ ପ୍ରଚାର୍ୟ୍ୟ ଅତ୍ତାଲିଯାନଗରଂ ପ୍ରସ୍ଥିତୱନ୍ତୌ| ");
INSERT INTO sanori_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ତସ୍ମାତ୍ ସମୁଦ୍ରପଥେନ ଗତ୍ୱା ତାଭ୍ୟାଂ ଯତ୍ କର୍ମ୍ମ ସମ୍ପନ୍ନଂ ତତ୍କର୍ମ୍ମ ସାଧଯିତୁଂ ଯନ୍ନଗରେ ଦଯାଲୋରୀଶ୍ୱରସ୍ୟ ହସ୍ତେ ସମର୍ପିତୌ ଜାତୌ ତଦ୍ ଆନ୍ତିଯଖିଯାନଗରଂ ଗତୱନ୍ତା| ");
INSERT INTO sanori_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","ତତ୍ରୋପସ୍ଥାଯ ତନ୍ନଗରସ୍ଥମଣ୍ଡଲୀଂ ସଂଗୃହ୍ୟ ସ୍ୱାଭ୍ୟାମ ଈଶ୍ୱରୋ ଯଦ୍ୟତ୍ କର୍ମ୍ମକରୋତ୍ ତଥା ଯେନ ପ୍ରକାରେଣ ଭିନ୍ନଦେଶୀଯଲୋକାନ୍ ପ୍ରତି ୱିଶ୍ୱାସରୂପଦ୍ୱାରମ୍ ଅମୋଚଯଦ୍ ଏତାନ୍ ସର୍ୱ୍ୱୱୃତ୍ତାନ୍ତାନ୍ ତାନ୍ ଜ୍ଞାପିତୱନ୍ତୌ| ");
INSERT INTO sanori_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ତତସ୍ତୌ ଶିର୍ୟ୍ୟୈଃ ସାର୍ଦ୍ଧଂ ତତ୍ର ବହୁଦିନାନି ନ୍ୟୱସତାମ୍| ");
INSERT INTO sanori_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","ଯିହୂଦାଦେଶାତ୍ କିଯନ୍ତୋ ଜନା ଆଗତ୍ୟ ଭ୍ରାତୃଗଣମିତ୍ଥଂ ଶିକ୍ଷିତୱନ୍ତୋ ମୂସାୱ୍ୟୱସ୍ଥଯା ଯଦି ଯୁଷ୍ମାକଂ ତ୍ୱକ୍ଛେଦୋ ନ ଭୱତି ତର୍ହି ଯୂଯଂ ପରିତ୍ରାଣଂ ପ୍ରାପ୍ତୁଂ ନ ଶକ୍ଷ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","ପୌଲବର୍ଣବ୍ବୌ ତୈଃ ସହ ବହୂନ୍ ୱିଚାରାନ୍ ୱିୱାଦାଂଶ୍ଚ କୃତୱନ୍ତୌ, ତତୋ ମଣ୍ଡଲୀଯନୋକା ଏତସ୍ୟାଃ କଥାଯାସ୍ତତ୍ତ୍ୱଂ ଜ୍ଞାତୁଂ ଯିରୂଶାଲମ୍ନଗରସ୍ଥାନ୍ ପ୍ରେରିତାନ୍ ପ୍ରାଚୀନାଂଶ୍ଚ ପ୍ରତି ପୌଲବର୍ଣବ୍ବାପ୍ରଭୃତୀନ୍ କତିପଯଜନାନ୍ ପ୍ରେଷଯିତୁଂ ନିଶ୍ଚଯଂ କୃତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","ତେ ମଣ୍ଡଲ୍ୟା ପ୍ରେରିତାଃ ସନ୍ତଃ ଫୈଣୀକୀଶୋମିରୋନ୍ଦେଶାଭ୍ୟାଂ ଗତ୍ୱା ଭିନ୍ନଦେଶୀଯାନାଂ ମନଃପରିୱର୍ତ୍ତନସ୍ୟ ୱାର୍ତ୍ତଯା ଭ୍ରାତୃଣାଂ ପରମାହ୍ଲାଦମ୍ ଅଜନଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","ଯିରୂଶାଲମ୍ୟୁପସ୍ଥାଯ ପ୍ରେରିତଗଣେନ ଲୋକପ୍ରାଚୀନଗଣେନ ସମାଜେନ ଚ ସମୁପଗୃହୀତାଃ ସନ୍ତଃ ସ୍ୱୈରୀଶ୍ୱରୋ ଯାନି କର୍ମ୍ମାଣି କୃତୱାନ୍ ତେଷାଂ ସର୍ୱ୍ୱୱୃତ୍ତାନ୍ତାନ୍ ତେଷାଂ ସମକ୍ଷମ୍ ଅକଥଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","କିନ୍ତୁ ୱିଶ୍ୱାସିନଃ କିଯନ୍ତଃ ଫିରୂଶିମତଗ୍ରାହିଣୋ ଲୋକା ଉତ୍ଥାଯ କଥାମେତାଂ କଥିତୱନ୍ତୋ ଭିନ୍ନଦେଶୀଯାନାଂ ତ୍ୱକ୍ଛେଦଂ କର୍ତ୍ତୁଂ ମୂସାୱ୍ୟୱସ୍ଥାଂ ପାଲଯିତୁଞ୍ଚ ସମାଦେଷ୍ଟୱ୍ୟମ୍| ");
INSERT INTO sanori_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","ତତଃ ପ୍ରେରିତା ଲୋକପ୍ରାଚୀନାଶ୍ଚ ତସ୍ୟ ୱିୱେଚନାଂ କର୍ତ୍ତୁଂ ସଭାଯାଂ ସ୍ଥିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","ବହୁୱିଚାରେଷୁ ଜାତଷୁ ପିତର ଉତ୍ଥାଯ କଥିତୱାନ୍, ହେ ଭ୍ରାତରୋ ଯଥା ଭିନ୍ନଦେଶୀଯଲୋକା ମମ ମୁଖାତ୍ ସୁସଂୱାଦଂ ଶ୍ରୁତ୍ୱା ୱିଶ୍ୱସନ୍ତି ତଦର୍ଥଂ ବହୁଦିନାତ୍ ପୂର୍ୱ୍ୱମ୍ ଈଶ୍ୱରୋସ୍ମାକଂ ମଧ୍ୟେ ମାଂ ୱୃତ୍ୱା ନିଯୁକ୍ତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","ଅନ୍ତର୍ୟ୍ୟାମୀଶ୍ୱରୋ ଯଥାସ୍ମଭ୍ୟଂ ତଥା ଭିନ୍ନଦେଶୀଯେଭ୍ୟଃ ପୱିତ୍ରମାତ୍ମାନଂ ପ୍ରଦାଯ ୱିଶ୍ୱାସେନ ତେଷାମ୍ ଅନ୍ତଃକରଣାନି ପୱିତ୍ରାଣି କୃତ୍ୱା ");
INSERT INTO sanori_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ତେଷାମ୍ ଅସ୍ମାକଞ୍ଚ ମଧ୍ୟେ କିମପି ୱିଶେଷଂ ନ ସ୍ଥାପଯିତ୍ୱା ତାନଧି ସ୍ୱଯଂ ପ୍ରମାଣଂ ଦତ୍ତୱାନ୍ ଇତି ଯୂଯଂ ଜାନୀଥ| ");
INSERT INTO sanori_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","ଅତଏୱାସ୍ମାକଂ ପୂର୍ୱ୍ୱପୁରୁଷା ୱଯଞ୍ଚ ସ୍ୱଯଂ ଯଦ୍ୟୁଗସ୍ୟ ଭାରଂ ସୋଢୁଂ ନ ଶକ୍ତାଃ ସମ୍ପ୍ରତି ତଂ ଶିଷ୍ୟଗଣସ୍ୟ ସ୍କନ୍ଧେଷୁ ନ୍ୟସିତୁଂ କୁତ ଈଶ୍ୱରସ୍ୟ ପରୀକ୍ଷାଂ କରିଷ୍ୟଥ? ");
INSERT INTO sanori_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","ପ୍ରଭୋ ର୍ୟୀଶୁଖ୍ରୀଷ୍ଟସ୍ୟାନୁଗ୍ରହେଣ ତେ ଯଥା ୱଯମପି ତଥା ପରିତ୍ରାଣଂ ପ୍ରାପ୍ତୁମ୍ ଆଶାଂ କୁର୍ମ୍ମଃ| ");
INSERT INTO sanori_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","ଅନନ୍ତରଂ ବର୍ଣବ୍ବାପୌଲାଭ୍ୟାମ୍ ଈଶ୍ୱରୋ ଭିନ୍ନଦେଶୀଯାନାଂ ମଧ୍ୟେ ଯଦ୍ୟଦ୍ ଆଶ୍ଚର୍ୟ୍ୟମ୍ ଅଦ୍ଭୁତଞ୍ଚ କର୍ମ୍ମ କୃତୱାନ୍ ତଦ୍ୱୃତ୍ତାନ୍ତଂ ତୌ ସ୍ୱମୁଖାଭ୍ୟାମ୍ ଅୱର୍ଣଯତାଂ ସଭାସ୍ଥାଃ ସର୍ୱ୍ୱେ ନୀରୱାଃ ସନ୍ତଃ ଶ୍ରୁତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","ତଯୋଃ କଥାଯାଂ ସମାପ୍ତାଯାଂ ସତ୍ୟାଂ ଯାକୂବ୍ କଥଯିତୁମ୍ ଆରବ୍ଧୱାନ୍ ");
INSERT INTO sanori_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ହେ ଭ୍ରାତରୋ ମମ କଥାଯାମ୍ ମନୋ ନିଧତ୍ତ| ଈଶ୍ୱରଃ ସ୍ୱନାମାର୍ଥଂ ଭିନ୍ନଦେଶୀଯଲୋକାନାମ୍ ମଧ୍ୟାଦ୍ ଏକଂ ଲୋକସଂଘଂ ଗ୍ରହୀତୁଂ ମତିଂ କୃତ୍ୱା ଯେନ ପ୍ରକାରେଣ ପ୍ରଥମଂ ତାନ୍ ପ୍ରତି କୃପାୱଲେକନଂ କୃତୱାନ୍ ତଂ ଶିମୋନ୍ ୱର୍ଣିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ଭୱିଷ୍ୟଦ୍ୱାଦିଭିରୁକ୍ତାନି ଯାନି ୱାକ୍ୟାନି ତୈଃ ସାର୍ଦ୍ଧମ୍ ଏତସ୍ୟୈକ୍ୟଂ ଭୱତି ଯଥା ଲିଖିତମାସ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","ସର୍ୱ୍ୱେଷାଂ କର୍ମ୍ମଣାଂ ଯସ୍ତୁ ସାଧକଃ ପରମେଶ୍ୱରଃ| ସ ଏୱେଦଂ ୱଦେଦ୍ୱାକ୍ୟଂ ଶେଷାଃ ସକଲମାନୱାଃ| ଭିନ୍ନଦେଶୀଯଲୋକାଶ୍ଚ ଯାୱନ୍ତୋ ମମ ନାମତଃ| ଭୱନ୍ତି ହି ସୁୱିଖ୍ୟାତାସ୍ତେ ଯଥା ପରମେଶିତୁଃ| ");
INSERT INTO sanori_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ତତ୍ୱଂ ସମ୍ୟକ୍ ସମୀହନ୍ତେ ତନ୍ନିମିତ୍ତମହଂ କିଲ| ପରାୱୃତ୍ୟ ସମାଗତ୍ୟ ଦାଯୂଦଃ ପତିତଂ ପୁନଃ| ଦୂଷ୍ୟମୁତ୍ଥାପଯିଷ୍ୟାମି ତଦୀଯଂ ସର୍ୱ୍ୱୱସ୍ତୁ ଚ| ପତିତଂ ପୁନରୁଥାପ୍ୟ ସଜ୍ଜଯିଷ୍ୟାମି ସର୍ୱ୍ୱଥା|| ");
INSERT INTO sanori_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ଆ ପ୍ରଥମାଦ୍ ଈଶ୍ୱରଃ ସ୍ୱୀଯାନି ସର୍ୱ୍ୱକର୍ମ୍ମାଣି ଜାନାତି| ");
INSERT INTO sanori_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","ଅତଏୱ ମମ ନିୱେଦନମିଦଂ ଭିନ୍ନଦେଶୀଯଲୋକାନାଂ ମଧ୍ୟେ ଯେ ଜନା ଈଶ୍ୱରଂ ପ୍ରତି ପରାୱର୍ତ୍ତନ୍ତ ତେଷାମୁପରି ଅନ୍ୟଂ କମପି ଭାରଂ ନ ନ୍ୟସ୍ୟ ");
INSERT INTO sanori_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ଦେୱତାପ୍ରସାଦାଶୁଚିଭକ୍ଷ୍ୟଂ ୱ୍ୟଭିଚାରକର୍ମ୍ମ କଣ୍ଠସମ୍ପୀଡନମାରିତପ୍ରାଣିଭକ୍ଷ୍ୟଂ ରକ୍ତଭକ୍ଷ୍ୟଞ୍ଚ ଏତାନି ପରିତ୍ୟକ୍ତୁଂ ଲିଖାମଃ| ");
INSERT INTO sanori_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","ଯତଃ ପୂର୍ୱ୍ୱକାଲତୋ ମୂସାୱ୍ୟୱସ୍ଥାପ୍ରଚାରିଣୋ ଲୋକା ନଗରେ ନଗରେ ସନ୍ତି ପ୍ରତିୱିଶ୍ରାମୱାରଞ୍ଚ ଭଜନଭୱନେ ତସ୍ୟାଃ ପାଠୋ ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","ତତଃ ପରଂ ପ୍ରେରିତଗଣୋ ଲୋକପ୍ରାଚୀନଗଣଃ ସର୍ୱ୍ୱା ମଣ୍ଡଲୀ ଚ ସ୍ୱେଷାଂ ମଧ୍ୟେ ବର୍ଶବ୍ବା ନାମ୍ନା ୱିଖ୍ୟାତୋ ମନୋନୀତୌ କୃତ୍ୱା ପୌଲବର୍ଣବ୍ବାଭ୍ୟାଂ ସାର୍ଦ୍ଧମ୍ ଆନ୍ତିଯଖିଯାନଗରଂ ପ୍ରତି ପ୍ରେଷଣମ୍ ଉଚିତଂ ବୁଦ୍ଧ୍ୱା ତାଭ୍ୟାଂ ପତ୍ରଂ ପ୍ରୈଷଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ତସ୍ମିନ୍ ପତ୍ରେ ଲିଖିତମିଂଦ, ଆନ୍ତିଯଖିଯା-ସୁରିଯା-କିଲିକିଯାଦେଶସ୍ଥଭିନ୍ନଦେଶୀଯଭ୍ରାତୃଗଣାଯ ପ୍ରେରିତଗଣସ୍ୟ ଲୋକପ୍ରାଚୀନଗଣସ୍ୟ ଭ୍ରାତୃଗଣସ୍ୟ ଚ ନମସ୍କାରଃ| ");
INSERT INTO sanori_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","ୱିଶେଷତୋଽସ୍ମାକମ୍ ଆଜ୍ଞାମ୍ ଅପ୍ରାପ୍ୟାପି କିଯନ୍ତୋ ଜନା ଅସ୍ମାକଂ ମଧ୍ୟାଦ୍ ଗତ୍ୱା ତ୍ୱକ୍ଛେଦୋ ମୂସାୱ୍ୟୱସ୍ଥା ଚ ପାଲଯିତୱ୍ୟାୱିତି ଯୁଷ୍ମାନ୍ ଶିକ୍ଷଯିତ୍ୱା ଯୁଷ୍ମାକଂ ମନସାମସ୍ଥୈର୍ୟ୍ୟଂ କୃତ୍ୱା ଯୁଷ୍ମାନ୍ ସସନ୍ଦେହାନ୍ ଅକୁର୍ୱ୍ୱନ୍ ଏତାଂ କଥାଂ ୱଯମ୍ ଅଶୃନ୍ମ| ");
INSERT INTO sanori_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","ତତ୍କାରଣାଦ୍ ୱଯମ୍ ଏକମନ୍ତ୍ରଣାଃ ସନ୍ତଃ ସଭାଯାଂ ସ୍ଥିତ୍ୱା ପ୍ରଭୋ ର୍ୟୀଶୁଖ୍ରୀଷ୍ଟସ୍ୟ ନାମନିମିତ୍ତଂ ମୃତ୍ୟୁମୁଖଗତାଭ୍ୟାମସ୍ମାକଂ ");
INSERT INTO sanori_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ପ୍ରିଯବର୍ଣବ୍ବାପୌଲାଭ୍ୟାଂ ସାର୍ଦ୍ଧଂ ମନୋନୀତଲୋକାନାଂ କେଷାଞ୍ଚିଦ୍ ଯୁଷ୍ମାକଂ ସନ୍ନିଧୌ ପ୍ରେଷଣମ୍ ଉଚିତଂ ବୁଦ୍ଧୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","ଅତୋ ଯିହୂଦାସୀଲୌ ଯୁଷ୍ମାନ୍ ପ୍ରତି ପ୍ରେଷିତୱନ୍ତଃ, ଏତଯୋ ର୍ମୁଖାଭ୍ୟାଂ ସର୍ୱ୍ୱାଂ କଥାଂ ଜ୍ଞାସ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","ଦେୱତାପ୍ରସାଦଭକ୍ଷ୍ୟଂ ରକ୍ତଭକ୍ଷ୍ୟଂ ଗଲପୀଡନମାରିତପ୍ରାଣିଭକ୍ଷ୍ୟଂ ୱ୍ୟଭିଚାରକର୍ମ୍ମ ଚେମାନି ସର୍ୱ୍ୱାଣି ଯୁଷ୍ମାଭିସ୍ତ୍ୟାଜ୍ୟାନି; ଏତତ୍ପ୍ରଯୋଜନୀଯାଜ୍ଞାୱ୍ୟତିରେକେନ ଯୁଷ୍ମାକମ୍ ଉପରି ଭାରମନ୍ୟଂ ନ ନ୍ୟସିତୁଂ ପୱିତ୍ରସ୍ୟାତ୍ମନୋଽସ୍ମାକଞ୍ଚ ଉଚିତଜ୍ଞାନମ୍ ଅଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ଅତଏୱ ତେଭ୍ୟଃ ସର୍ୱ୍ୱେଭ୍ୟଃ ସ୍ୱେଷୁ ରକ୍ଷିତେଷୁ ଯୂଯଂ ଭଦ୍ରଂ କର୍ମ୍ମ କରିଷ୍ୟଥ| ଯୁଷ୍ମାକଂ ମଙ୍ଗଲଂ ଭୂଯାତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","ତେे ୱିସୃଷ୍ଟାଃ ସନ୍ତ ଆନ୍ତିଯଖିଯାନଗର ଉପସ୍ଥାଯ ଲୋକନିୱହଂ ସଂଗୃହ୍ୟ ପତ୍ରମ୍ ଅଦଦନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ତତସ୍ତେ ତତ୍ପତ୍ରଂ ପଠିତ୍ୱା ସାନ୍ତ୍ୱନାଂ ପ୍ରାପ୍ୟ ସାନନ୍ଦା ଅଭୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ଯିହୂଦାସୀଲୌ ଚ ସ୍ୱଯଂ ପ୍ରଚାରକୌ ଭୂତ୍ୱା ଭ୍ରାତୃଗଣଂ ନାନୋପଦିଶ୍ୟ ତାନ୍ ସୁସ୍ଥିରାନ୍ ଅକୁରୁତାମ୍| ");
INSERT INTO sanori_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ଇତ୍ଥଂ ତୌ ତତ୍ର ତୈଃ ସାକଂ କତିପଯଦିନାନି ଯାପଯିତ୍ୱା ପଶ୍ଚାତ୍ ପ୍ରେରିତାନାଂ ସମୀପେ ପ୍ରତ୍ୟାଗମନାର୍ଥଂ ତେଷାଂ ସନ୍ନିଧେଃ କଲ୍ୟାଣେନ ୱିସୃଷ୍ଟାୱଭୱତାଂ| ");
INSERT INTO sanori_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","କିନ୍ତୁ ସୀଲସ୍ତତ୍ର ସ୍ଥାତୁଂ ୱାଞ୍ଛିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","ଅପରଂ ପୌଲବର୍ଣବ୍ବୌ ବହୱଃ ଶିଷ୍ୟାଶ୍ଚ ଲୋକାନ୍ ଉପଦିଶ୍ୟ ପ୍ରଭୋଃ ସୁସଂୱାଦଂ ପ୍ରଚାରଯନ୍ତ ଆନ୍ତିଯଖିଯାଯାଂ କାଲଂ ଯାପିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","କତିପଯଦିନେଷୁ ଗତେଷୁ ପୌଲୋ ବର୍ଣବ୍ବାମ୍ ଅୱଦତ୍ ଆଗଚ୍ଛାୱାଂ ଯେଷୁ ନଗରେଷ୍ୱୀଶ୍ୱରସ୍ୟ ସୁସଂୱାଦଂ ପ୍ରଚାରିତୱନ୍ତୌ ତାନି ସର୍ୱ୍ୱନଗରାଣି ପୁନର୍ଗତ୍ୱା ଭ୍ରାତରଃ କୀଦୃଶାଃ ସନ୍ତୀତି ଦ୍ରଷ୍ଟୁଂ ତାନ୍ ସାକ୍ଷାତ୍ କୁର୍ୱ୍ୱଃ| ");
INSERT INTO sanori_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","ତେନ ମାର୍କନାମ୍ନା ୱିଖ୍ୟାତଂ ଯୋହନଂ ସଙ୍ଗିନଂ କର୍ତ୍ତୁଂ ବର୍ଣବ୍ବା ମତିମକରୋତ୍, ");
INSERT INTO sanori_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","କିନ୍ତୁ ସ ପୂର୍ୱ୍ୱଂ ତାଭ୍ୟାଂ ସହ କାର୍ୟ୍ୟାର୍ଥଂ ନ ଗତ୍ୱା ପାମ୍ଫୂଲିଯାଦେଶେ ତୌ ତ୍ୟକ୍ତୱାନ୍ ତତ୍କାରଣାତ୍ ପୌଲସ୍ତଂ ସଙ୍ଗିନଂ କର୍ତ୍ତୁମ୍ ଅନୁଚିତଂ ଜ୍ଞାତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ଇତ୍ଥଂ ତଯୋରତିଶଯୱିରୋଧସ୍ୟୋପସ୍ଥିତତ୍ୱାତ୍ ତୌ ପରସ୍ପରଂ ପୃଥଗଭୱତାଂ ତତୋ ବର୍ଣବ୍ବା ମାର୍କଂ ଗୃହୀତ୍ୱା ପୋତେନ କୁପ୍ରୋପଦ୍ୱୀପଂ ଗତୱାନ୍; ");
INSERT INTO sanori_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","କିନ୍ତୁ ପୌଲଃ ସୀଲଂ ମନୋନୀତଂ କୃତ୍ୱା ଭ୍ରାତୃଭିରୀଶ୍ୱରାନୁଗ୍ରହେ ସମର୍ପିତଃ ସନ୍ ପ୍ରସ୍ଥାଯ ");
INSERT INTO sanori_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","ସୁରିଯାକିଲିକିଯାଦେଶାଭ୍ୟାଂ ମଣ୍ଡଲୀଃ ସ୍ଥିରୀକୁର୍ୱ୍ୱନ୍ ଅଗଚ୍ଛତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","ପୌଲୋ ଦର୍ବ୍ବୀଲୁସ୍ତ୍ରାନଗରଯୋରୁପସ୍ଥିତୋଭୱତ୍ ତତ୍ର ତୀମଥିଯନାମା ଶିଷ୍ୟ ଏକ ଆସୀତ୍; ସ ୱିଶ୍ୱାସିନ୍ୟା ଯିହୂଦୀଯାଯା ଯୋଷିତୋ ଗର୍ବ୍ଭଜାତଃ କିନ୍ତୁ ତସ୍ୟ ପିତାନ୍ୟଦେଶୀଯଲୋକଃ| ");
INSERT INTO sanori_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","ସ ଜନୋ ଲୁସ୍ତ୍ରା-ଇକନିଯନଗରସ୍ଥାନାଂ ଭ୍ରାତୃଣାଂ ସମୀପେପି ସୁଖ୍ୟାତିମାନ୍ ଆସୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","ପୌଲସ୍ତଂ ସ୍ୱସଙ୍ଗିନଂ କର୍ତ୍ତୁଂ ମତିଂ କୃତ୍ୱା ତଂ ଗୃହୀତ୍ୱା ତଦ୍ଦେଶନିୱାସିନାଂ ଯିହୂଦୀଯାନାମ୍ ଅନୁରୋଧାତ୍ ତସ୍ୟ ତ୍ୱକ୍ଛେଦଂ କୃତୱାନ୍ ଯତସ୍ତସ୍ୟ ପିତା ଭିନ୍ନଦେଶୀଯଲୋକ ଇତି ସର୍ୱ୍ୱୈରଜ୍ଞାଯତ| ");
INSERT INTO sanori_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","ତତଃ ପରଂ ତେ ନଗରେ ନଗରେ ଭ୍ରମିତ୍ୱା ଯିରୂଶାଲମସ୍ଥୈଃ ପ୍ରେରିତୈ ର୍ଲୋକପ୍ରାଚୀନୈଶ୍ଚ ନିରୂପିତଂ ଯଦ୍ ୱ୍ୟୱସ୍ଥାପତ୍ରଂ ତଦନୁସାରେଣାଚରିତୁଂ ଲୋକେଭ୍ୟସ୍ତଦ୍ ଦତ୍ତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","ତେନୈୱ ସର୍ୱ୍ୱେ ଧର୍ମ୍ମସମାଜାଃ ଖ୍ରୀଷ୍ଟଧର୍ମ୍ମେ ସୁସ୍ଥିରାଃ ସନ୍ତଃ ପ୍ରତିଦିନଂ ୱର୍ଦ୍ଧିତା ଅଭୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","ତେଷୁ ଫ୍ରୁଗିଯାଗାଲାତିଯାଦେଶମଧ୍ୟେନ ଗତେଷୁ ସତ୍ସୁ ପୱିତ୍ର ଆତ୍ମା ତାନ୍ ଆଶିଯାଦେଶେ କଥାଂ ପ୍ରକାଶଯିତୁଂ ପ୍ରତିଷିଦ୍ଧୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ତଥା ମୁସିଯାଦେଶ ଉପସ୍ଥାଯ ବିଥୁନିଯାଂ ଗନ୍ତୁଂ ତୈରୁଦ୍ୟୋଗେ କୃତେ ଆତ୍ମା ତାନ୍ ନାନ୍ୱମନ୍ୟତ| ");
INSERT INTO sanori_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","ତସ୍ମାତ୍ ତେ ମୁସିଯାଦେଶଂ ପରିତ୍ୟଜ୍ୟ ତ୍ରୋଯାନଗରଂ ଗତ୍ୱା ସମୁପସ୍ଥିତାଃ| ");
INSERT INTO sanori_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ରାତ୍ରୌ ପୌଲଃ ସ୍ୱପ୍ନେ ଦୃଷ୍ଟୱାନ୍ ଏକୋ ମାକିଦନିଯଲୋକସ୍ତିଷ୍ଠନ୍ ୱିନଯଂ କୃତ୍ୱା ତସ୍ମୈ କଥଯତି, ମାକିଦନିଯାଦେଶମ୍ ଆଗତ୍ୟାସ୍ମାନ୍ ଉପକୁର୍ୱ୍ୱିତି| ");
INSERT INTO sanori_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ତସ୍ୟେତ୍ଥଂ ସ୍ୱପ୍ନଦର୍ଶନାତ୍ ପ୍ରଭୁସ୍ତଦ୍ଦେଶୀଯଲୋକାନ୍ ପ୍ରତି ସୁସଂୱାଦଂ ପ୍ରଚାରଯିତୁମ୍ ଅସ୍ମାନ୍ ଆହୂଯତୀତି ନିଶ୍ଚିତଂ ବୁଦ୍ଧ୍ୱା ୱଯଂ ତୂର୍ଣଂ ମାକିଦନିଯାଦେଶଂ ଗନ୍ତୁମ୍ ଉଦ୍ୟୋଗମ୍ ଅକୁର୍ମ୍ମ| ");
INSERT INTO sanori_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","ତତଃ ପରଂ ୱଯଂ ତ୍ରୋଯାନଗରାଦ୍ ପ୍ରସ୍ଥାଯ ଋଜୁମାର୍ଗେଣ ସାମଥ୍ରାକିଯୋପଦ୍ୱୀପେନ ଗତ୍ୱା ପରେଽହନି ନିଯାପଲିନଗର ଉପସ୍ଥିତାଃ| ");
INSERT INTO sanori_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ତସ୍ମାଦ୍ ଗତ୍ୱା ମାକିଦନିଯାନ୍ତର୍ୱ୍ୱର୍ତ୍ତି ରୋମୀଯୱସତିସ୍ଥାନଂ ଯତ୍ ଫିଲିପୀନାମପ୍ରଧାନନଗରଂ ତତ୍ରୋପସ୍ଥାଯ କତିପଯଦିନାନି ତତ୍ର ସ୍ଥିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","ୱିଶ୍ରାମୱାରେ ନଗରାଦ୍ ବହି ର୍ଗତ୍ୱା ନଦୀତଟେ ଯତ୍ର ପ୍ରାର୍ଥନାଚାର ଆସୀତ୍ ତତ୍ରୋପୱିଶ୍ୟ ସମାଗତା ନାରୀଃ ପ୍ରତି କଥାଂ ପ୍ରାଚାରଯାମ| ");
INSERT INTO sanori_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","ତତଃ ଥୁଯାତୀରାନଗରୀଯା ଧୂଷରାମ୍ବରୱିକ୍ରାଯିଣୀ ଲୁଦିଯାନାମିକା ଯା ଈଶ୍ୱରସେୱିକା ଯୋଷିତ୍ ଶ୍ରୋତ୍ରୀଣାଂ ମଧ୍ୟ ଆସୀତ୍ ତଯା ପୌଲୋକ୍ତୱାକ୍ୟାନି ଯଦ୍ ଗୃହ୍ୟନ୍ତେ ତଦର୍ଥଂ ପ୍ରଭୁସ୍ତସ୍ୟା ମନୋଦ୍ୱାରଂ ମୁକ୍ତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ଅତଃ ସା ଯୋଷିତ୍ ସପରିୱାରା ମଜ୍ଜିତା ସତୀ ୱିନଯଂ କୃତ୍ୱା କଥିତୱତୀ, ଯୁଷ୍ମାକଂ ୱିଚାରାଦ୍ ଯଦି ପ୍ରଭୌ ୱିଶ୍ୱାସିନୀ ଜାତାହଂ ତର୍ହି ମମ ଗୃହମ୍ ଆଗତ୍ୟ ତିଷ୍ଠତ| ଇତ୍ଥଂ ସା ଯତ୍ନେନାସ୍ମାନ୍ ଅସ୍ଥାପଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","ଯସ୍ୟା ଗଣନଯା ତଦଧିପତୀନାଂ ବହୁଧନୋପାର୍ଜନଂ ଜାତଂ ତାଦୃଶୀ ଗଣକଭୂତଗ୍ରସ୍ତା କାଚନ ଦାସୀ ପ୍ରାର୍ଥନାସ୍ଥାନଗମନକାଲ ଆଗତ୍ୟାସ୍ମାନ୍ ସାକ୍ଷାତ୍ କୃତୱତୀ| ");
INSERT INTO sanori_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","ସାସ୍ମାକଂ ପୌଲସ୍ୟ ଚ ପଶ୍ଚାଦ୍ ଏତ୍ୟ ପ୍ରୋଚ୍ଚୈଃ କଥାମିମାଂ କଥିତୱତୀ, ମନୁଷ୍ୟା ଏତେ ସର୍ୱ୍ୱୋପରିସ୍ଥସ୍ୟେଶ୍ୱରସ୍ୟ ସେୱକାଃ ସନ୍ତୋଽସ୍ମାନ୍ ପ୍ରତି ପରିତ୍ରାଣସ୍ୟ ମାର୍ଗଂ ପ୍ରକାଶଯନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","ସା କନ୍ୟା ବହୁଦିନାନି ତାଦୃଶମ୍ ଅକରୋତ୍ ତସ୍ମାତ୍ ପୌଲୋ ଦୁଃଖିତଃ ସନ୍ ମୁଖଂ ପରାୱର୍ତ୍ୟ ତଂ ଭୂତମୱଦଦ୍, ଅହଂ ଯୀଶୁଖ୍ରୀଷ୍ଟସ୍ୟ ନାମ୍ନା ତ୍ୱାମାଜ୍ଞାପଯାମି ତ୍ୱମସ୍ୟା ବହିର୍ଗଚ୍ଛ; ତେନୈୱ ତତ୍କ୍ଷଣାତ୍ ସ ଭୂତସ୍ତସ୍ୟା ବହିର୍ଗତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","ତତଃ ସ୍ୱେଷାଂ ଲାଭସ୍ୟ ପ୍ରତ୍ୟାଶା ୱିଫଲା ଜାତେତି ୱିଲୋକ୍ୟ ତସ୍ୟାଃ ପ୍ରଭୱଃ ପୌଲଂ ସୀଲଞ୍ଚ ଧୃତ୍ୱାକୃଷ୍ୟ ୱିଚାରସ୍ଥାନେଽଧିପତୀନାଂ ସମୀପମ୍ ଆନଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ତତଃ ଶାସକାନାଂ ନିକଟଂ ନୀତ୍ୱା ରୋମିଲୋକା ୱଯମ୍ ଅସ୍ମାକଂ ଯଦ୍ ୱ୍ୟୱହରଣଂ ଗ୍ରହୀତୁମ୍ ଆଚରିତୁଞ୍ଚ ନିଷିଦ୍ଧଂ, ");
INSERT INTO sanori_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ଇମେ ଯିହୂଦୀଯଲୋକାଃ ସନ୍ତୋପି ତଦେୱ ଶିକ୍ଷଯିତ୍ୱା ନଗରେଽସ୍ମାକମ୍ ଅତୀୱ କଲହଂ କୁର୍ୱ୍ୱନ୍ତି, ");
INSERT INTO sanori_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","ଇତି କଥିତେ ସତି ଲୋକନିୱହସ୍ତଯୋଃ ପ୍ରାତିକୂଲ୍ୟେନୋଦତିଷ୍ଠତ୍ ତଥା ଶାସକାସ୍ତଯୋ ର୍ୱସ୍ତ୍ରାଣି ଛିତ୍ୱା ୱେତ୍ରାଘାତଂ କର୍ତ୍ତୁମ୍ ଆଜ୍ଞାପଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","ଅପରଂ ତେ ତୌ ବହୁ ପ୍ରହାର୍ୟ୍ୟ ତ୍ୱମେତୌ କାରାଂ ନୀତ୍ୱା ସାୱଧାନଂ ରକ୍ଷଯେତି କାରାରକ୍ଷକମ୍ ଆଦିଶନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ଇତ୍ଥମ୍ ଆଜ୍ଞାଂ ପ୍ରାପ୍ୟ ସ ତାୱଭ୍ୟନ୍ତରସ୍ଥକାରାଂ ନୀତ୍ୱା ପାଦେଷୁ ପାଦପାଶୀଭି ର୍ବଦ୍ଧ୍ୱା ସ୍ଥାପିତାୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","ଅଥ ନିଶୀଥସମଯେ ପୌଲସୀଲାୱୀଶ୍ୱରମୁଦ୍ଦିଶ୍ୟ ପ୍ରାଥନାଂ ଗାନଞ୍ଚ କୃତୱନ୍ତୌ, କାରାସ୍ଥିତା ଲୋକାଶ୍ଚ ତଦଶୃଣ୍ୱନ୍ ");
INSERT INTO sanori_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ତଦାକସ୍ମାତ୍ ମହାନ୍ ଭୂମିକମ୍ପୋଽଭୱତ୍ ତେନ ଭିତ୍ତିମୂଲେନ ସହ କାରା କମ୍ପିତାଭୂତ୍ ତତ୍କ୍ଷଣାତ୍ ସର୍ୱ୍ୱାଣି ଦ୍ୱାରାଣି ମୁକ୍ତାନି ଜାତାନି ସର୍ୱ୍ୱେଷାଂ ବନ୍ଧନାନି ଚ ମୁକ୍ତାନି| ");
INSERT INTO sanori_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","ଅତଏୱ କାରାରକ୍ଷକୋ ନିଦ୍ରାତୋ ଜାଗରିତ୍ୱା କାରାଯା ଦ୍ୱାରାଣି ମୁକ୍ତାନି ଦୃଷ୍ଟ୍ୱା ବନ୍ଦିଲୋକାଃ ପଲାଯିତା ଇତ୍ୟନୁମାଯ କୋଷାତ୍ ଖଙ୍ଗଂ ବହିଃ କୃତ୍ୱାତ୍ମଘାତଂ କର୍ତ୍ତୁମ୍ ଉଦ୍ୟତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","କିନ୍ତୁ ପୌଲଃ ପ୍ରୋଚ୍ଚୈସ୍ତମାହୂଯ କଥିତୱାନ୍ ପଶ୍ୟ ୱଯଂ ସର୍ୱ୍ୱେଽତ୍ରାସ୍ମହେ, ତ୍ୱଂ ନିଜପ୍ରାଣହିଂସାଂ ମାକାର୍ଷୀଃ| ");
INSERT INTO sanori_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","ତଦା ପ୍ରଦୀପମ୍ ଆନେତୁମ୍ ଉକ୍ତ୍ୱା ସ କମ୍ପମାନଃ ସନ୍ ଉଲ୍ଲମ୍ପ୍ୟାଭ୍ୟନ୍ତରମ୍ ଆଗତ୍ୟ ପୌଲସୀଲଯୋଃ ପାଦେଷୁ ପତିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ପଶ୍ଚାତ୍ ସ ତୌ ବହିରାନୀଯ ପୃଷ୍ଟୱାନ୍ ହେ ମହେଚ୍ଛୌ ପରିତ୍ରାଣଂ ପ୍ରାପ୍ତୁଂ ମଯା କିଂ କର୍ତ୍ତୱ୍ୟଂ? ");
INSERT INTO sanori_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","ପଶ୍ଚାତ୍ ତୌ ସ୍ୱଗୃହମାନୀଯ ତଯୋଃ ସମ୍ମୁଖେ ଖାଦ୍ୟଦ୍ରୱ୍ୟାଣି ସ୍ଥାପିତୱାନ୍ ତଥା ସ ସ୍ୱଯଂ ତଦୀଯାଃ ସର୍ୱ୍ୱେ ପରିୱାରାଶ୍ଚେଶ୍ୱରେ ୱିଶ୍ୱସନ୍ତଃ ସାନନ୍ଦିତା ଅଭୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ତସ୍ମୈ ତସ୍ୟ ଗୃହସ୍ଥିତସର୍ୱ୍ୱଲୋକେଭ୍ୟଶ୍ଚ ପ୍ରଭୋଃ କଥାଂ କଥିତୱନ୍ତୌ| ");
INSERT INTO sanori_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","ତଥା ରାତ୍ରେସ୍ତସ୍ମିନ୍ନେୱ ଦଣ୍ଡେ ସ ତୌ ଗୃହୀତ୍ୱା ତଯୋଃ ପ୍ରହାରାଣାଂ କ୍ଷତାନି ପ୍ରକ୍ଷାଲିତୱାନ୍ ତତଃ ସ ସ୍ୱଯଂ ତସ୍ୟ ସର୍ୱ୍ୱେ ପରିଜନାଶ୍ଚ ମଜ୍ଜିତା ଅଭୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","ପଶ୍ଚାତ୍ ତୌ ସ୍ୱଗୃହମାନୀଯ ତଯୋଃ ସମ୍ମୁଖେ ଖାଦ୍ୟଦ୍ରୱ୍ୟାଣି ସ୍ଥାପିତୱାନ୍ ତଥା ସ ସ୍ୱଯଂ ତଦୀଯାଃ ସର୍ୱ୍ୱେ ପରିୱାରାଶ୍ଚେଶ୍ୱରେ ୱିଶ୍ୱସନ୍ତଃ ସାନନ୍ଦିତା ଅଭୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","ଦିନ ଉପସ୍ଥିତେ ତୌ ଲୋକୌ ମୋଚଯେତି କଥାଂ କଥଯିତୁଂ ଶାସକାଃ ପଦାତିଗଣଂ ପ୍ରେଷିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","ତତଃ କାରାରକ୍ଷକଃ ପୌଲାଯ ତାଂ ୱାର୍ତ୍ତାଂ କଥିତୱାନ୍ ଯୁୱାଂ ତ୍ୟାଜଯିତୁଂ ଶାସକା ଲୋକାନ ପ୍ରେଷିତୱନ୍ତ ଇଦାନୀଂ ଯୁୱାଂ ବହି ର୍ଭୂତ୍ୱା କୁଶଲେନ ପ୍ରତିଷ୍ଠେତାଂ| ");
INSERT INTO sanori_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","କିନ୍ତୁ ପୌଲସ୍ତାନ୍ ଅୱଦତ୍ ରୋମିଲୋକଯୋରାୱଯୋଃ କମପି ଦୋଷମ୍ ନ ନିଶ୍ଚିତ୍ୟ ସର୍ୱ୍ୱେଷାଂ ସମକ୍ଷମ୍ ଆୱାଂ କଶଯା ତାଡଯିତ୍ୱା କାରାଯାଂ ବଦ୍ଧୱନ୍ତ ଇଦାନୀଂ କିମାୱାଂ ଗୁପ୍ତଂ ୱିସ୍ତ୍ରକ୍ଷ୍ୟନ୍ତି? ତନ୍ନ ଭୱିଷ୍ୟତି, ସ୍ୱଯମାଗତ୍ୟାୱାଂ ବହିଃ କୃତ୍ୱା ନଯନ୍ତୁ| ");
INSERT INTO sanori_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","ତଦା ପଦାତିଭିଃ ଶାସକେଭ୍ୟ ଏତଦ୍ୱାର୍ତ୍ତାଯାଂ କଥିତାଯାଂ ତୌ ରୋମିଲୋକାୱିତି କଥାଂ ଶ୍ରୁତ୍ୱା ତେ ଭୀତାଃ ");
INSERT INTO sanori_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","ସନ୍ତସ୍ତଯୋଃ ସନ୍ନିଧିମାଗତ୍ୟ ୱିନଯମ୍ ଅକୁର୍ୱ୍ୱନ୍ ଅପରଂ ବହିଃ କୃତ୍ୱା ନଗରାତ୍ ପ୍ରସ୍ଥାତୁଂ ପ୍ରାର୍ଥିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ତତସ୍ତୌ କାରାଯା ନିର୍ଗତ୍ୟ ଲୁଦିଯାଯା ଗୃହଂ ଗତୱନ୍ତୌ ତତ୍ର ଭ୍ରାତୃଗଣଂ ସାକ୍ଷାତ୍କୃତ୍ୟ ତାନ୍ ସାନ୍ତ୍ୱଯିତ୍ୱା ତସ୍ମାତ୍ ସ୍ଥାନାତ୍ ପ୍ରସ୍ଥିତୌ| ");
INSERT INTO sanori_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","ପୌଲସୀଲୌ ଆମ୍ଫିପଲ୍ୟାପଲ୍ଲୋନିଯାନଗରାଭ୍ୟାଂ ଗତ୍ୱା ଯତ୍ର ଯିହୂଦୀଯାନାଂ ଭଜନଭୱନମେକମ୍ ଆସ୍ତେ ତତ୍ର ଥିଷଲନୀକୀନଗର ଉପସ୍ଥିତୌ| ");
INSERT INTO sanori_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","ତଦା ପୌଲଃ ସ୍ୱାଚାରାନୁସାରେଣ ତେଷାଂ ସମୀପଂ ଗତ୍ୱା ୱିଶ୍ରାମୱାରତ୍ରଯେ ତୈଃ ସାର୍ଦ୍ଧଂ ଧର୍ମ୍ମପୁସ୍ତକୀଯକଥାଯା ୱିଚାରଂ କୃତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ଫଲତଃ ଖ୍ରୀଷ୍ଟେନ ଦୁଃଖଭୋଗଃ କର୍ତ୍ତୱ୍ୟଃ ଶ୍ମଶାନଦୁତ୍ଥାନଞ୍ଚ କର୍ତ୍ତୱ୍ୟଂ ଯୁଷ୍ମାକଂ ସନ୍ନିଧୌ ଯସ୍ୟ ଯୀଶୋଃ ପ୍ରସ୍ତାୱଂ କରୋମି ସ ଈଶ୍ୱରେଣାଭିଷିକ୍ତଃ ସ ଏତାଃ କଥାଃ ପ୍ରକାଶ୍ୟ ପ୍ରମାଣଂ ଦତ୍ୱା ସ୍ଥିରୀକୃତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","ତସ୍ମାତ୍ ତେଷାଂ କତିପଯଜନା ଅନ୍ୟଦେଶୀଯା ବହୱୋ ଭକ୍ତଲୋକା ବହ୍ୟଃ ପ୍ରଧାନନାର୍ୟ୍ୟଶ୍ଚ ୱିଶ୍ୱସ୍ୟ ପୌଲସୀଲଯୋଃ ପଶ୍ଚାଦ୍ଗାମିନୋ ଜାତାଃ| ");
INSERT INTO sanori_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","କିନ୍ତୁ ୱିଶ୍ୱାସହୀନା ଯିହୂଦୀଯଲୋକା ଈର୍ଷ୍ୟଯା ପରିପୂର୍ଣାଃ ସନ୍ତୋ ହଟଟ୍ସ୍ୟ କତିନଯଲମ୍ପଟଲୋକାନ୍ ସଙ୍ଗିନଃ କୃତ୍ୱା ଜନତଯା ନଗରମଧ୍ୟେ ମହାକଲହଂ କୃତ୍ୱା ଯାସୋନୋ ଗୃହମ୍ ଆକ୍ରମ୍ୟ ପ୍ରେରିତାନ୍ ଧୃତ୍ୱା ଲୋକନିୱହସ୍ୟ ସମୀପମ୍ ଆନେତୁଂ ଚେଷ୍ଟିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","ତେଷାମୁଦ୍ଦେଶମ୍ ଅପ୍ରାପ୍ୟ ଚ ଯାସୋନଂ କତିପଯାନ୍ ଭ୍ରାତୃଂଶ୍ଚ ଧୃତ୍ୱା ନଗରାଧିପତୀନାଂ ନିକଟମାନୀଯ ପ୍ରୋଚ୍ଚୈଃ କଥିତୱନ୍ତୋ ଯେ ମନୁଷ୍ୟା ଜଗଦୁଦ୍ୱାଟିତୱନ୍ତସ୍ତେ ଽତ୍ରାପ୍ୟୁପସ୍ଥିତାଃ ସନ୍ତି, ");
INSERT INTO sanori_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ଏଷ ଯାସୋନ୍ ଆତିଥ୍ୟଂ କୃତ୍ୱା ତାନ୍ ଗୃହୀତୱାନ୍| ଯୀଶୁନାମକ ଏକୋ ରାଜସ୍ତୀତି କଥଯନ୍ତସ୍ତେ କୈସରସ୍ୟାଜ୍ଞାୱିରୁଦ୍ଧଂ କର୍ମ୍ମ କୁର୍ୱ୍ୱତି| ");
INSERT INTO sanori_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","ତେଷାଂ କଥାମିମାଂ ଶ୍ରୁତ୍ୱା ଲୋକନିୱହୋ ନଗରାଧିପତଯଶ୍ଚ ସମୁଦ୍ୱିଗ୍ନା ଅଭୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ତଦା ଯାସୋନସ୍ତଦନ୍ୟେଷାଞ୍ଚ ଧନଦଣ୍ଡଂ ଗୃହୀତ୍ୱା ତାନ୍ ପରିତ୍ୟକ୍ତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","ତତଃ ପରଂ ଭ୍ରାତୃଗଣୋ ରଜନ୍ୟାଂ ପୌଲସୀଲୌ ଶୀଘ୍ରଂ ବିରଯାନଗରଂ ପ୍ରେଷିତୱାନ୍ ତୌ ତତ୍ରୋପସ୍ଥାଯ ଯିହୂଦୀଯାନାଂ ଭଜନଭୱନଂ ଗତୱନ୍ତୌ| ");
INSERT INTO sanori_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","ତତ୍ରସ୍ଥା ଲୋକାଃ ଥିଷଲନୀକୀସ୍ଥଲୋକେଭ୍ୟୋ ମହାତ୍ମାନ ଆସନ୍ ଯତ ଇତ୍ଥଂ ଭୱତି ନ ୱେତି ଜ୍ଞାତୁଂ ଦିନେ ଦିନେ ଧର୍ମ୍ମଗ୍ରନ୍ଥସ୍ୟାଲୋଚନାଂ କୃତ୍ୱା ସ୍ୱୈରଂ କଥାମ୍ ଅଗୃହ୍ଲନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ତସ୍ମାଦ୍ ଅନେକେ ଯିହୂଦୀଯା ଅନ୍ୟଦେଶୀଯାନାଂ ମାନ୍ୟା ସ୍ତ୍ରିଯଃ ପୁରୁଷାଶ୍ଚାନେକେ ୱ୍ୟଶ୍ୱସନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","କିନ୍ତୁ ବିରଯାନଗରେ ପୌଲେନେଶ୍ୱରୀଯା କଥା ପ୍ରଚାର୍ୟ୍ୟତ ଇତି ଥିଷଲନୀକୀସ୍ଥା ଯିହୂଦୀଯା ଜ୍ଞାତ୍ୱା ତତ୍ସ୍ଥାନମପ୍ୟାଗତ୍ୟ ଲୋକାନାଂ କୁପ୍ରୱୃତ୍ତିମ୍ ଅଜନଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","ଅତଏୱ ତସ୍ମାତ୍ ସ୍ଥାନାତ୍ ସମୁଦ୍ରେଣ ଯାନ୍ତୀତି ଦର୍ଶଯିତ୍ୱା ଭ୍ରାତରଃ କ୍ଷିପ୍ରଂ ପୌଲଂ ପ୍ରାହିଣ୍ୱନ୍ କିନ୍ତୁ ସୀଲତୀମଥିଯୌ ତତ୍ର ସ୍ଥିତୱନ୍ତୌ| ");
INSERT INTO sanori_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","ତତଃ ପରଂ ପୌଲସ୍ୟ ମାର୍ଗଦର୍ଶକାସ୍ତମ୍ ଆଥୀନୀନଗର ଉପସ୍ଥାପଯନ୍ ପଶ୍ଚାଦ୍ ଯୁୱାଂ ତୂର୍ଣମ୍ ଏତତ୍ ସ୍ଥାନଂ ଆଗମିଷ୍ୟଥଃ ସୀଲତୀମଥିଯୌ ପ୍ରତୀମାମ୍ ଆଜ୍ଞାଂ ପ୍ରାପ୍ୟ ତେ ପ୍ରତ୍ୟାଗତାଃ| ");
INSERT INTO sanori_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","ପୌଲ ଆଥୀନୀନଗରେ ତାୱପେକ୍ଷ୍ୟ ତିଷ୍ଠନ୍ ତନ୍ନଗରଂ ପ୍ରତିମାଭିଃ ପରିପୂର୍ଣଂ ଦୃଷ୍ଟ୍ୱା ସନ୍ତପ୍ତହୃଦଯୋ ଽଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","ତତଃ ସ ଭଜନଭୱନେ ଯାନ୍ ଯିହୂଦୀଯାନ୍ ଭକ୍ତଲୋକାଂଶ୍ଚ ହଟ୍ଟେ ଚ ଯାନ୍ ଅପଶ୍ୟତ୍ ତୈଃ ସହ ପ୍ରତିଦିନଂ ୱିଚାରିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","କିନ୍ତ୍ୱିପିକୂରୀଯମତଗ୍ରହିଣଃ ସ୍ତୋଯିକୀଯମତଗ୍ରାହିଣଶ୍ଚ କିଯନ୍ତୋ ଜନାସ୍ତେନ ସାର୍ଦ୍ଧଂ ୱ୍ୟୱଦନ୍ତ| ତତ୍ର କେଚିଦ୍ ଅକଥଯନ୍ ଏଷ ୱାଚାଲଃ କିଂ ୱକ୍ତୁମ୍ ଇଚ୍ଛତି? ଅପରେ କେଚିଦ୍ ଏଷ ଜନଃ କେଷାଞ୍ଚିଦ୍ ୱିଦେଶୀଯଦେୱାନାଂ ପ୍ରଚାରକ ଇତ୍ୟନୁମୀଯତେ ଯତଃ ସ ଯୀଶୁମ୍ ଉତ୍ଥିତିଞ୍ଚ ପ୍ରଚାରଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","ତେ ତମ୍ ଅରେଯପାଗନାମ ୱିଚାରସ୍ଥାନମ୍ ଆନୀଯ ପ୍ରାୱୋଚନ୍ ଇଦଂ ଯନ୍ନୱୀନଂ ମତଂ ତ୍ୱଂ ପ୍ରାଚୀକଶ ଇଦଂ କୀଦୃଶଂ ଏତଦ୍ ଅସ୍ମାନ୍ ଶ୍ରାୱଯ; ");
INSERT INTO sanori_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","ଯାମିମାମ୍ ଅସମ୍ଭୱକଥାମ୍ ଅସ୍ମାକଂ କର୍ଣଗୋଚରୀକୃତୱାନ୍ ଅସ୍ୟା ଭାୱାର୍ଥଃ କ ଇତି ୱଯଂ ଜ୍ଞାତୁମ୍ ଇଚ୍ଛାମଃ| ");
INSERT INTO sanori_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","ତଦାଥୀନୀନିୱାସିନସ୍ତନ୍ନଗରପ୍ରୱାସିନଶ୍ଚ କେୱଲଂ କସ୍ୟାଶ୍ଚନ ନୱୀନକଥାଯାଃ ଶ୍ରୱଣେନ ପ୍ରଚାରଣେନ ଚ କାଲମ୍ ଅଯାପଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","ପୌଲୋଽରେଯପାଗସ୍ୟ ମଧ୍ୟେ ତିଷ୍ଠନ୍ ଏତାଂ କଥାଂ ପ୍ରଚାରିତୱାନ୍, ହେ ଆଥୀନୀଯଲୋକା ଯୂଯଂ ସର୍ୱ୍ୱଥା ଦେୱପୂଜାଯାମ୍ ଆସକ୍ତା ଇତ୍ୟହ ପ୍ରତ୍ୟକ୍ଷଂ ପଶ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","ଯତଃ ପର୍ୟ୍ୟଟନକାଲେ ଯୁଷ୍ମାକଂ ପୂଜନୀଯାନି ପଶ୍ୟନ୍ ‘ଅୱିଜ୍ଞାତେଶ୍ୱରାଯ’ ଏତଲ୍ଲିପିଯୁକ୍ତାଂ ଯଜ୍ଞୱେଦୀମେକାଂ ଦୃଷ୍ଟୱାନ୍; ଅତୋ ନ ୱିଦିତ୍ୱା ଯଂ ପୂଜଯଧ୍ୱେ ତସ୍ୟୈୱ ତତ୍ୱଂ ଯୁଷ୍ମାନ୍ ପ୍ରତି ପ୍ରଚାରଯାମି| ");
INSERT INTO sanori_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ଜଗତୋ ଜଗତ୍ସ୍ଥାନାଂ ସର୍ୱ୍ୱୱସ୍ତୂନାଞ୍ଚ ସ୍ରଷ୍ଟା ଯ ଈଶ୍ୱରଃ ସ ସ୍ୱର୍ଗପୃଥିୱ୍ୟୋରେକାଧିପତିଃ ସନ୍ କରନିର୍ମ୍ମିତମନ୍ଦିରେଷୁ ନ ନିୱସତି; ");
INSERT INTO sanori_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ସ ଏୱ ସର୍ୱ୍ୱେଭ୍ୟୋ ଜୀୱନଂ ପ୍ରାଣାନ୍ ସର୍ୱ୍ୱସାମଗ୍ରୀଶ୍ଚ ପ୍ରଦଦାତି; ଅତଏୱ ସ କସ୍ୟାଶ୍ଚିତ୍ ସାମଗ୍ୟ୍ରା ଅଭାୱହେତୋ ର୍ମନୁଷ୍ୟାଣାଂ ହସ୍ତୈଃ ସେୱିତୋ ଭୱତୀତି ନ| ");
INSERT INTO sanori_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ସ ଭୂମଣ୍ଡଲେ ନିୱାସାର୍ଥମ୍ ଏକସ୍ମାତ୍ ଶୋଣିତାତ୍ ସର୍ୱ୍ୱାନ୍ ମନୁଷ୍ୟାନ୍ ସୃଷ୍ଟ୍ୱା ତେଷାଂ ପୂର୍ୱ୍ୱନିରୂପିତସମଯଂ ୱସତିସୀମାଞ୍ଚ ନିରଚିନୋତ୍; ");
INSERT INTO sanori_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ତସ୍ମାତ୍ ଲୋକୈଃ କେନାପି ପ୍ରକାରେଣ ମୃଗଯିତ୍ୱା ପରମେଶ୍ୱରସ୍ୟ ତତ୍ୱଂ ପ୍ରାପ୍ତୁଂ ତସ୍ୟ ଗୱେଷଣଂ କରଣୀଯମ୍| ");
INSERT INTO sanori_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","କିନ୍ତୁ ସୋଽସ୍ମାକଂ କସ୍ମାଚ୍ଚିଦପି ଦୂରେ ତିଷ୍ଠତୀତି ନହି, ୱଯଂ ତେନ ନିଶ୍ୱସନପ୍ରଶ୍ୱସନଗମନାଗମନପ୍ରାଣଧାରଣାନି କୁର୍ମ୍ମଃ, ପୁुନଶ୍ଚ ଯୁଷ୍ମାକମେୱ କତିପଯାଃ କୱଯଃ କଥଯନ୍ତି ‘ତସ୍ୟ ୱଂଶା ୱଯଂ ସ୍ମୋ ହି’ ଇତି| ");
INSERT INTO sanori_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","ଅତଏୱ ଯଦି ୱଯମ୍ ଈଶ୍ୱରସ୍ୟ ୱଂଶା ଭୱାମସ୍ତର୍ହି ମନୁଷ୍ୟୈ ର୍ୱିଦ୍ୟଯା କୌଶଲେନ ଚ ତକ୍ଷିତଂ ସ୍ୱର୍ଣଂ ରୂପ୍ୟଂ ଦୃଷଦ୍ ୱୈତେଷାମୀଶ୍ୱରତ୍ୱମ୍ ଅସ୍ମାଭି ର୍ନ ଜ୍ଞାତୱ୍ୟଂ| ");
INSERT INTO sanori_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","ତେଷାଂ ପୂର୍ୱ୍ୱୀଯଲୋକାନାମ୍ ଅଜ୍ଞାନତାଂ ପ୍ରତୀଶ୍ୱରୋ ଯଦ୍ୟପି ନାୱାଧତ୍ତ ତଥାପୀଦାନୀଂ ସର୍ୱ୍ୱତ୍ର ସର୍ୱ୍ୱାନ୍ ମନଃ ପରିୱର୍ତ୍ତଯିତୁମ୍ ଆଜ୍ଞାପଯତି, ");
INSERT INTO sanori_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","ଯତଃ ସ୍ୱନିଯୁକ୍ତେନ ପୁରୁଷେଣ ଯଦା ସ ପୃଥିୱୀସ୍ଥାନାଂ ସର୍ୱ୍ୱଲୋକାନାଂ ୱିଚାରଂ କରିଷ୍ୟତି ତଦ୍ଦିନଂ ନ୍ୟରୂପଯତ୍; ତସ୍ୟ ଶ୍ମଶାନୋତ୍ଥାପନେନ ତସ୍ମିନ୍ ସର୍ୱ୍ୱେଭ୍ୟଃ ପ୍ରମାଣଂ ପ୍ରାଦାତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","ତଦା ଶ୍ମଶାନାଦ୍ ଉତ୍ଥାନସ୍ୟ କଥାଂ ଶ୍ରୁତ୍ୱା କେଚିଦ୍ ଉପାହମନ୍, କେଚିଦୱଦନ୍ ଏନାଂ କଥାଂ ପୁନରପି ତ୍ୱତ୍ତଃ ଶ୍ରୋଷ୍ୟାମଃ| ");
INSERT INTO sanori_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","ତତଃ ପୌଲସ୍ତେଷାଂ ସମୀପାତ୍ ପ୍ରସ୍ଥିाତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","ତଥାପି କେଚିଲ୍ଲୋକାସ୍ତେନ ସାର୍ଦ୍ଧଂ ମିଲିତ୍ୱା ୱ୍ୟଶ୍ୱସନ୍ ତେଷାଂ ମଧ୍ୟେ ଽରେଯପାଗୀଯଦିଯନୁସିଯୋ ଦାମାରୀନାମା କାଚିନ୍ନାରୀ କିଯନ୍ତୋ ନରାଶ୍ଚାସନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","ତଦ୍ଘଟନାତଃ ପରଂ ପୌଲ ଆଥୀନୀନଗରାଦ୍ ଯାତ୍ରାଂ କୃତ୍ୱା କରିନ୍ଥନଗରମ୍ ଆଗଚ୍ଛତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","ତସ୍ମିନ୍ ସମଯେ କ୍ଲୌଦିଯଃ ସର୍ୱ୍ୱାନ୍ ଯିହୂଦୀଯାନ୍ ରୋମାନଗରଂ ୱିହାଯ ଗନ୍ତୁମ୍ ଆଜ୍ଞାପଯତ୍, ତସ୍ମାତ୍ ପ୍ରିସ୍କିଲ୍ଲାନାମ୍ନା ଜାଯଯା ସାର୍ଦ୍ଧମ୍ ଇତାଲିଯାଦେଶାତ୍ କିଞ୍ଚିତ୍ପୂର୍ୱ୍ୱମ୍ ଆଗମତ୍ ଯଃ ପନ୍ତଦେଶେ ଜାତ ଆକ୍କିଲନାମା ଯିହୂଦୀଯଲୋକଃ ପୌଲସ୍ତଂ ସାକ୍ଷାତ୍ ପ୍ରାପ୍ୟ ତଯୋଃ ସମୀପମିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ତୌ ଦୂଷ୍ୟନିର୍ମ୍ମାଣଜୀୱିନୌ, ତସ୍ମାତ୍ ପରସ୍ପରମ୍ ଏକୱୃତ୍ତିକତ୍ୱାତ୍ ସ ତାଭ୍ୟାଂ ସହ ଉଷିତ୍ୱା ତତ୍ କର୍ମ୍ମାକରୋତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","ପୌଲଃ ପ୍ରତିୱିଶ୍ରାମୱାରଂ ଭଜନଭୱନଂ ଗତ୍ୱା ୱିଚାରଂ କୃତ୍ୱା ଯିହୂଦୀଯାନ୍ ଅନ୍ୟଦେଶୀଯାଂଶ୍ଚ ପ୍ରୱୃତ୍ତିଂ ଗ୍ରାହିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","ସୀଲତୀମଥିଯଯୋ ର୍ମାକିଦନିଯାଦେଶାତ୍ ସମେତଯୋଃ ସତୋଃ ପୌଲ ଉତ୍ତପ୍ତମନା ଭୂତ୍ୱା ଯୀଶୁରୀଶ୍ୱରେଣାଭିଷିକ୍ତୋ ଭୱତୀତି ପ୍ରମାଣଂ ଯିହୂଦୀଯାନାଂ ସମୀପେ ପ୍ରାଦାତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","କିନ୍ତୁ ତେ ଽତୀୱ ୱିରୋଧଂ ୱିଧାଯ ପାଷଣ୍ଡୀଯକଥାଂ କଥିତୱନ୍ତସ୍ତତଃ ପୌଲୋ ୱସ୍ତ୍ରଂ ଧୁନ୍ୱନ୍ ଏତାଂ କଥାଂ କଥିତୱାନ୍, ଯୁଷ୍ମାକଂ ଶୋଣିତପାତାପରାଧୋ ଯୁଷ୍ମାନ୍ ପ୍ରତ୍ୟେୱ ଭୱତୁ, ତେନାହଂ ନିରପରାଧୋ ଽଦ୍ୟାରଭ୍ୟ ଭିନ୍ନଦେଶୀଯାନାଂ ସମୀପଂ ଯାମି| ");
INSERT INTO sanori_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","ସ ତସ୍ମାତ୍ ପ୍ରସ୍ଥାଯ ଭଜନଭୱନସମୀପସ୍ଥସ୍ୟ ଯୁସ୍ତନାମ୍ନ ଈଶ୍ୱରଭକ୍ତସ୍ୟ ଭିନ୍ନଦେଶୀଯସ୍ୟ ନିୱେଶନଂ ପ୍ରାୱିଶତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","ତତଃ କ୍ରୀଷ୍ପନାମା ଭଜନଭୱନାଧିପତିଃ ସପରିୱାରଃ ପ୍ରଭୌ ୱ୍ୟଶ୍ୱସୀତ୍, କରିନ୍ଥନଗରୀଯା ବହୱୋ ଲୋକାଶ୍ଚ ସମାକର୍ଣ୍ୟ ୱିଶ୍ୱସ୍ୟ ମଜ୍ଜିତା ଅଭୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","କ୍ଷଣଦାଯାଂ ପ୍ରଭୁଃ ପୌଲଂ ଦର୍ଶନଂ ଦତ୍ୱା ଭାଷିତୱାନ୍, ମା ଭୈଷୀଃ, ମା ନିରସୀଃ କଥାଂ ପ୍ରଚାରଯ| ");
INSERT INTO sanori_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ଅହଂ ତ୍ୱଯା ସାର୍ଦ୍ଧମ୍ ଆସ ହିଂସାର୍ଥଂ କୋପି ତ୍ୱାଂ ସ୍ପ୍ରଷ୍ଟୁଂ ନ ଶକ୍ଷ୍ୟତି ନଗରେଽସ୍ମିନ୍ ମଦୀଯା ଲୋକା ବହୱ ଆସତେ| ");
INSERT INTO sanori_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","ତସ୍ମାତ୍ ପୌଲସ୍ତନ୍ନଗରେ ପ୍ରାଯେଣ ସାର୍ଦ୍ଧୱତ୍ସରପର୍ୟ୍ୟନ୍ତଂ ସଂସ୍ଥାଯେଶ୍ୱରସ୍ୟ କଥାମ୍ ଉପାଦିଶତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","ଗାଲ୍ଲିଯନାମା କଶ୍ଚିଦ୍ ଆଖାଯାଦେଶସ୍ୟ ପ୍ରାଡ୍ୱିୱାକଃ ସମଭୱତ୍, ତତୋ ଯିହୂଦୀଯା ଏକୱାକ୍ୟାଃ ସନ୍ତଃ ପୌଲମ୍ ଆକ୍ରମ୍ୟ ୱିଚାରସ୍ଥାନଂ ନୀତ୍ୱା ");
INSERT INTO sanori_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","ମାନୁଷ ଏଷ ୱ୍ୟୱସ୍ଥାଯ ୱିରୁଦ୍ଧମ୍ ଈଶ୍ୱରଭଜନଂ କର୍ତ୍ତୁଂ ଲୋକାନ୍ କୁପ୍ରୱୃତ୍ତିଂ ଗ୍ରାହଯତୀତି ନିୱେଦିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","ତତଃ ପୌଲେ ପ୍ରତ୍ୟୁତ୍ତରଂ ଦାତୁମ୍ ଉଦ୍ୟତେ ସତି ଗାଲ୍ଲିଯା ଯିହୂଦୀଯାନ୍ ୱ୍ୟାହରତ୍, ଯଦି କସ୍ୟଚିଦ୍ ଅନ୍ୟାଯସ୍ୟ ୱାତିଶଯଦୁଷ୍ଟତାଚରଣସ୍ୟ ୱିଚାରୋଽଭୱିଷ୍ୟତ୍ ତର୍ହି ଯୁଷ୍ମାକଂ କଥା ମଯା ସହନୀଯାଭୱିଷ୍ୟତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","କିନ୍ତୁ ଯଦି କେୱଲଂ କଥାଯା ୱା ନାମ୍ନୋ ୱା ଯୁଷ୍ମାକଂ ୱ୍ୟୱସ୍ଥାଯା ୱିୱାଦୋ ଭୱତି ତର୍ହି ତସ୍ୟ ୱିଚାରମହଂ ନ କରିଷ୍ୟାମି, ଯୂଯଂ ତସ୍ୟ ମୀମାଂସାଂ କୁରୁତ| ");
INSERT INTO sanori_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","ତତଃ ସ ତାନ୍ ୱିଚାରସ୍ଥାନାଦ୍ ଦୂରୀକୃତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","ତଦା ଭିନ୍ନଦେଶୀଯାଃ ସୋସ୍ଥିନିନାମାନଂ ଭଜନଭୱନସ୍ୟ ପ୍ରଧାନାଧିପତିଂ ଧୃତ୍ୱା ୱିଚାରସ୍ଥାନସ୍ୟ ସମ୍ମୁଖେ ପ୍ରାହରନ୍ ତଥାପି ଗାଲ୍ଲିଯା ତେଷୁ ସର୍ୱ୍ୱକର୍ମ୍ମସୁ ନ ମନୋ ନ୍ୟଦଧାତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","ପୌଲସ୍ତତ୍ର ପୁନର୍ବହୁଦିନାନି ନ୍ୟୱସତ୍, ତତୋ ଭ୍ରାତୃଗଣାଦ୍ ୱିସର୍ଜନଂ ପ୍ରାପ୍ୟ କିଞ୍ଚନୱ୍ରତନିମିତ୍ତଂ କିଂକ୍ରିଯାନଗରେ ଶିରୋ ମୁଣ୍ଡଯିତ୍ୱା ପ୍ରିସ୍କିଲ୍ଲାକ୍କିଲାଭ୍ୟାଂ ସହିତୋ ଜଲପଥେନ ସୁରିଯାଦେଶଂ ଗତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","ତତ ଇଫିଷନଗର ଉପସ୍ଥାଯ ତତ୍ର ତୌ ୱିସୃଜ୍ୟ ସ୍ୱଯଂ ଭଜନଭ୍ୱନଂ ପ୍ରୱିଶ୍ୟ ଯିହୂଦୀଯୈଃ ସହ ୱିଚାରିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","ତେ ସ୍ୱୈଃ ସାର୍ଦ୍ଧଂ ପୁନଃ କତିପଯଦିନାନି ସ୍ଥାତୁଂ ତଂ ୱ୍ୟନଯନ୍, ସ ତଦନୁରରୀକୃତ୍ୟ କଥାମେତାଂ କଥିତୱାନ୍, ");
INSERT INTO sanori_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ଯିରୂଶାଲମି ଆଗାମ୍ୟୁତ୍ସୱପାଲନାର୍ଥଂ ମଯା ଗମନୀଯଂ; ପଶ୍ଚାଦ୍ ଈଶ୍ୱରେଚ୍ଛାଯାଂ ଜାତାଯାଂ ଯୁଷ୍ମାକଂ ସମୀପଂ ପ୍ରତ୍ୟାଗମିଷ୍ୟାମି| ତତଃ ପରଂ ସ ତୈ ର୍ୱିସୃଷ୍ଟଃ ସନ୍ ଜଲପଥେନ ଇଫିଷନଗରାତ୍ ପ୍ରସ୍ଥିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","ତତଃ କୈସରିଯାମ୍ ଉପସ୍ଥିତଃ ସନ୍ ନଗରଂ ଗତ୍ୱା ସମାଜଂ ନମସ୍କୃତ୍ୟ ତସ୍ମାଦ୍ ଆନ୍ତିଯଖିଯାନଗରଂ ପ୍ରସ୍ଥିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","ତତ୍ର କିଯତ୍କାଲଂ ଯାପଯିତ୍ୱା ତସ୍ମାତ୍ ପ୍ରସ୍ଥାଯ ସର୍ୱ୍ୱେଷାଂ ଶିଷ୍ୟାଣାଂ ମନାଂସି ସୁସ୍ଥିରାଣି କୃତ୍ୱା କ୍ରମଶୋ ଗଲାତିଯାଫ୍ରୁଗିଯାଦେଶଯୋ ର୍ଭ୍ରମିତ୍ୱା ଗତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","ତସ୍ମିନ୍ନେୱ ସମଯେ ସିକନ୍ଦରିଯାନଗରେ ଜାତ ଆପଲ୍ଲୋନାମା ଶାସ୍ତ୍ରୱିତ୍ ସୁୱକ୍ତା ଯିହୂଦୀଯ ଏକୋ ଜନ ଇଫିଷନଗରମ୍ ଆଗତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","ସ ଶିକ୍ଷିତପ୍ରଭୁମାର୍ଗୋ ମନସୋଦ୍ୟୋଗୀ ଚ ସନ୍ ଯୋହନୋ ମଜ୍ଜନମାତ୍ରଂ ଜ୍ଞାତ୍ୱା ଯଥାର୍ଥତଯା ପ୍ରଭୋଃ କଥାଂ କଥଯନ୍ ସମୁପାଦିଶତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ଏଷ ଜନୋ ନିର୍ଭଯତ୍ୱେନ ଭଜନଭୱନେ କଥଯିତୁମ୍ ଆରବ୍ଧୱାନ୍, ତତଃ ପ୍ରିସ୍କିଲ୍ଲାକ୍କିଲୌ ତସ୍ୟୋପଦେଶକଥାଂ ନିଶମ୍ୟ ତଂ ସ୍ୱଯୋଃ ସମୀପମ୍ ଆନୀଯ ଶୁଦ୍ଧରୂପେଣେଶ୍ୱରସ୍ୟ କଥାମ୍ ଅବୋଧଯତାମ୍| ");
INSERT INTO sanori_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","ପଶ୍ଚାତ୍ ସ ଆଖାଯାଦେଶଂ ଗନ୍ତୁଂ ମତିଂ କୃତୱାନ୍, ତଦା ତତ୍ରତ୍ୟଃ ଶିଷ୍ୟଗଣୋ ଯଥା ତଂ ଗୃହ୍ଲାତି ତଦର୍ଥଂ ଭ୍ରାତୃଗଣେନ ସମାଶ୍ୱସ୍ୟ ପତ୍ରେ ଲିଖିତେ ସତି, ଆପଲ୍ଲାସ୍ତତ୍ରୋପସ୍ଥିତଃ ସନ୍ ଅନୁଗ୍ରହେଣ ପ୍ରତ୍ୟଯିନାଂ ବହୂପକାରାନ୍ ଅକରୋତ୍, ");
INSERT INTO sanori_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ଫଲତୋ ଯୀଶୁରଭିଷିକ୍ତସ୍ତ୍ରାତେତି ଶାସ୍ତ୍ରପ୍ରମାଣଂ ଦତ୍ୱା ପ୍ରକାଶରୂପେଣ ପ୍ରତିପନ୍ନଂ କୃତ୍ୱା ଯିହୂଦୀଯାନ୍ ନିରୁତ୍ତରାନ୍ କୃତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","କରିନ୍ଥନଗର ଆପଲ୍ଲସଃ ସ୍ଥିତିକାଲେ ପୌଲ ଉତ୍ତରପ୍ରଦେଶୈରାଗଚ୍ଛନ୍ ଇଫିଷନଗରମ୍ ଉପସ୍ଥିତୱାନ୍| ତତ୍ର କତିପଯଶିଷ୍ୟାନ୍ ସାକ୍ଷତ୍ ପ୍ରାପ୍ୟ ତାନ୍ ଅପୃଚ୍ଛତ୍, ");
INSERT INTO sanori_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ଯୂଯଂ ୱିଶ୍ୱସ୍ୟ ପୱିତ୍ରମାତ୍ମାନଂ ପ୍ରାପ୍ତା ନ ୱା? ତତସ୍ତେ ପ୍ରତ୍ୟୱଦନ୍ ପୱିତ୍ର ଆତ୍ମା ଦୀଯତେ ଇତ୍ୟସ୍ମାଭିଃ ଶ୍ରୁତମପି ନହି| ");
INSERT INTO sanori_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","ତଦା ସାଽୱଦତ୍ ତର୍ହି ଯୂଯଂ କେନ ମଜ୍ଜିତା ଅଭୱତ? ତେଽକଥଯନ୍ ଯୋହନୋ ମଜ୍ଜନେନ| ");
INSERT INTO sanori_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","ତଦା ପୌଲ ଉକ୍ତୱାନ୍ ଇତଃ ପରଂ ଯ ଉପସ୍ଥାସ୍ୟତି ତସ୍ମିନ୍ ଅର୍ଥତ ଯୀଶୁଖ୍ରୀଷ୍ଟେ ୱିଶ୍ୱସିତୱ୍ୟମିତ୍ୟୁକ୍ତ୍ୱା ଯୋହନ୍ ମନଃପରିୱର୍ତ୍ତନସୂଚକେନ ମଜ୍ଜନେନ ଜଲେ ଲୋକାନ୍ ଅମଜ୍ଜଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ତାଦୃଶୀଂ କଥାଂ ଶ୍ରୁତ୍ୱା ତେ ପ୍ରଭୋ ର୍ୟୀଶୁଖ୍ରୀଷ୍ଟସ୍ୟ ନାମ୍ନା ମଜ୍ଜିତା ଅଭୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ତତଃ ପୌଲେନ ତେଷାଂ ଗାତ୍ରେଷୁ କରେଽର୍ପିତେ ତେଷାମୁପରି ପୱିତ୍ର ଆତ୍ମାୱରୂଢୱାନ୍, ତସ୍ମାତ୍ ତେ ନାନାଦେଶୀଯା ଭାଷା ଭୱିଷ୍ୟତ୍କଥାଶ୍ଚ କଥିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","ତେ ପ୍ରାଯେଣ ଦ୍ୱାଦଶଜନା ଆସନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","ପୌଲୋ ଭଜନଭୱନଂ ଗତ୍ୱା ପ୍ରାଯେଣ ମାସତ୍ରଯମ୍ ଈଶ୍ୱରସ୍ୟ ରାଜ୍ୟସ୍ୟ ୱିଚାରଂ କୃତ୍ୱା ଲୋକାନ୍ ପ୍ରୱର୍ତ୍ୟ ସାହସେନ କଥାମକଥଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","କିନ୍ତୁ କଠିନାନ୍ତଃକରଣତ୍ୱାତ୍ କିଯନ୍ତୋ ଜନା ନ ୱିଶ୍ୱସ୍ୟ ସର୍ୱ୍ୱେଷାଂ ସମକ୍ଷମ୍ ଏତତ୍ପଥସ୍ୟ ନିନ୍ଦାଂ କର୍ତ୍ତୁଂ ପ୍ରୱୃତ୍ତାଃ, ଅତଃ ପୌଲସ୍ତେଷାଂ ସମୀପାତ୍ ପ୍ରସ୍ଥାଯ ଶିଷ୍ୟଗଣଂ ପୃଥକ୍କୃତ୍ୱା ପ୍ରତ୍ୟହଂ ତୁରାନ୍ନନାମ୍ନଃ କସ୍ୟଚିତ୍ ଜନସ୍ୟ ପାଠଶାଲାଯାଂ ୱିଚାରଂ କୃତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ଇତ୍ଥଂ ୱତ୍ସରଦ୍ୱଯଂ ଗତଂ ତସ୍ମାଦ୍ ଆଶିଯାଦେଶନିୱାସିନଃ ସର୍ୱ୍ୱେ ଯିହୂଦୀଯା ଅନ୍ୟଦେଶୀଯଲୋକାଶ୍ଚ ପ୍ରଭୋ ର୍ୟୀଶୋଃ କଥାମ୍ ଅଶ୍ରୌଷନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","ପୌଲେନ ଚ ଈଶ୍ୱର ଏତାଦୃଶାନ୍ୟଦ୍ଭୁତାନି କର୍ମ୍ମାଣି କୃତୱାନ୍ ");
INSERT INTO sanori_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ଯତ୍ ପରିଧେଯେ ଗାତ୍ରମାର୍ଜନୱସ୍ତ୍ରେ ୱା ତସ୍ୟ ଦେହାତ୍ ପୀଡିତଲୋକାନାମ୍ ସମୀପମ୍ ଆନୀତେ ତେ ନିରାମଯା ଜାତା ଅପୱିତ୍ରା ଭୂତାଶ୍ଚ ତେଭ୍ୟୋ ବହିର୍ଗତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","ତଦା ଦେଶାଟନକାରିଣଃ କିଯନ୍ତୋ ଯିହୂଦୀଯା ଭୂତାପସାରିଣୋ ଭୂତଗ୍ରସ୍ତନୋକାନାଂ ସନ୍ନିଧୌ ପ୍ରଭେ ର୍ୟୀଶୋ ର୍ନାମ ଜପ୍ତ୍ୱା ୱାକ୍ୟମିଦମ୍ ଅୱଦନ୍, ଯସ୍ୟ କଥାଂ ପୌଲଃ ପ୍ରଚାରଯତି ତସ୍ୟ ଯୀଶୋ ର୍ନାମ୍ନା ଯୁଷ୍ମାନ୍ ଆଜ୍ଞାପଯାମଃ| ");
INSERT INTO sanori_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","ସ୍କିୱନାମ୍ନୋ ଯିହୂଦୀଯାନାଂ ପ୍ରଧାନଯାଜକସ୍ୟ ସପ୍ତଭିଃ ପୁତ୍ତୈସ୍ତଥା କୃତେ ସତି ");
INSERT INTO sanori_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","କଶ୍ଚିଦ୍ ଅପୱିତ୍ରୋ ଭୂତଃ ପ୍ରତ୍ୟୁଦିତୱାନ୍, ଯୀଶୁଂ ଜାନାମି ପୌଲଞ୍ଚ ପରିଚିନୋମି କିନ୍ତୁ କେ ଯୂଯଂ? ");
INSERT INTO sanori_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ଇତ୍ୟୁକ୍ତ୍ୱା ସୋପୱିତ୍ରଭୂତଗ୍ରସ୍ତୋ ମନୁଷ୍ୟୋ ଲମ୍ଫଂ କୃତ୍ୱା ତେଷାମୁପରି ପତିତ୍ୱା ବଲେନ ତାନ୍ ଜିତୱାନ୍, ତସ୍ମାତ୍ତେ ନଗ୍ନାଃ କ୍ଷତାଙ୍ଗାଶ୍ଚ ସନ୍ତସ୍ତସ୍ମାଦ୍ ଗେହାତ୍ ପଲାଯନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","ସା ୱାଗ୍ ଇଫିଷନଗରନିୱାସିନସଂ ସର୍ୱ୍ୱେଷାଂ ଯିହୂଦୀଯାନାଂ ଭିନ୍ନଦେଶୀଯାନାଂ ଲୋକାନାଞ୍ଚ ଶ୍ରୱୋଗୋଚରୀଭୂତା; ତତଃ ସର୍ୱ୍ୱେ ଭଯଂ ଗତାଃ ପ୍ରଭୋ ର୍ୟୀଶୋ ର୍ନାମ୍ନୋ ଯଶୋ ଽୱର୍ଦ୍ଧତ| ");
INSERT INTO sanori_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","ଯେଷାମନେକେଷାଂ ଲୋକାନାଂ ପ୍ରତୀତିରଜାଯତ ତ ଆଗତ୍ୟ ସ୍ୱୈଃ କୃତାଃ କ୍ରିଯାଃ ପ୍ରକାଶରୂପେଣାଙ୍ଗୀକୃତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","ବହୱୋ ମାଯାକର୍ମ୍ମକାରିଣଃ ସ୍ୱସ୍ୱଗ୍ରନ୍ଥାନ୍ ଆନୀଯ ରାଶୀକୃତ୍ୟ ସର୍ୱ୍ୱେଷାଂ ସମକ୍ଷମ୍ ଅଦାହଯନ୍, ତତୋ ଗଣନାଂ କୃତ୍ୱାବୁଧ୍ୟନ୍ତ ପଞ୍ଚାଯୁତରୂପ୍ୟମୁଦ୍ରାମୂଲ୍ୟପୁସ୍ତକାନି ଦଗ୍ଧାନି| ");
INSERT INTO sanori_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ଇତ୍ଥଂ ପ୍ରଭୋଃ କଥା ସର୍ୱ୍ୱଦେଶଂ ୱ୍ୟାପ୍ୟ ପ୍ରବଲା ଜାତା| ");
INSERT INTO sanori_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","ସର୍ୱ୍ୱେଷ୍ୱେତେଷୁ କର୍ମ୍ମସୁ ସମ୍ପନ୍ନେଷୁ ସତ୍ସୁ ପୌଲୋ ମାକିଦନିଯାଖାଯାଦେଶାଭ୍ୟାଂ ଯିରୂଶାଲମଂ ଗନ୍ତୁଂ ମତିଂ କୃତ୍ୱା କଥିତୱାନ୍ ତତ୍ସ୍ଥାନଂ ଯାତ୍ରାଯାଂ କୃତାଯାଂ ସତ୍ୟାଂ ମଯା ରୋମାନଗରଂ ଦ୍ରଷ୍ଟୱ୍ୟଂ| ");
INSERT INTO sanori_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","ସ୍ୱାନୁଗତଲୋକାନାଂ ତୀମଥିଯେରାସ୍ତୌ ଦ୍ୱୌ ଜନୌ ମାକିଦନିଯାଦେଶଂ ପ୍ରତି ପ୍ରହିତ୍ୟ ସ୍ୱଯମ୍ ଆଶିଯାଦେଶେ କତିପଯଦିନାନି ସ୍ଥିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","କିନ୍ତୁ ତସ୍ମିନ୍ ସମଯେ ମତେଽସ୍ମିନ୍ କଲହୋ ଜାତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","ତତ୍କାରଣମିଦଂ, ଅର୍ତ୍ତିମୀଦେୱ୍ୟା ରୂପ୍ୟମନ୍ଦିରନିର୍ମ୍ମାଣେନ ସର୍ୱ୍ୱେଷାଂ ଶିଲ୍ପିନାଂ ଯଥେଷ୍ଟଲାଭମ୍ ଅଜନଯତ୍ ଯୋ ଦୀମୀତ୍ରିଯନାମା ନାଡୀନ୍ଧମଃ ");
INSERT INTO sanori_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ସ ତାନ୍ ତତ୍କର୍ମ୍ମଜୀୱିନଃ ସର୍ୱ୍ୱଲୋକାଂଶ୍ଚ ସମାହୂଯ ଭାଷିତୱାନ୍ ହେ ମହେଚ୍ଛା ଏତେନ ମନ୍ଦିରନିର୍ମ୍ମାଣେନାସ୍ମାକଂ ଜୀୱିକା ଭୱତି, ଏତଦ୍ ଯୂଯଂ ୱିତ୍ଥ; ");
INSERT INTO sanori_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","କିନ୍ତୁ ହସ୍ତନିର୍ମ୍ମିତେଶ୍ୱରା ଈଶ୍ୱରା ନହି ପୌଲନାମ୍ନା କେନଚିଜ୍ଜନେନ କଥାମିମାଂ ୱ୍ୟାହୃତ୍ୟ କେୱଲେଫିଷନଗରେ ନହି ପ୍ରାଯେଣ ସର୍ୱ୍ୱସ୍ମିନ୍ ଆଶିଯାଦେଶେ ପ୍ରୱୃତ୍ତିଂ ଗ୍ରାହଯିତ୍ୱା ବହୁଲୋକାନାଂ ଶେମୁଷୀ ପରାୱର୍ତ୍ତିତା, ଏତଦ୍ ଯୁଷ୍ମାଭି ର୍ଦୃଶ୍ୟତେ ଶ୍ରୂଯତେ ଚ| ");
INSERT INTO sanori_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","ତେନାସ୍ମାକଂ ୱାଣିଜ୍ୟସ୍ୟ ସର୍ୱ୍ୱଥା ହାନେଃ ସମ୍ଭୱନଂ କେୱଲମିତି ନହି, ଆଶିଯାଦେଶସ୍ଥୈ ର୍ୱା ସର୍ୱ୍ୱଜଗତ୍ସ୍ଥୈ ର୍ଲୋକୈଃ ପୂଜ୍ୟା ଯାର୍ତିମୀ ମହାଦେୱୀ ତସ୍ୟା ମନ୍ଦିରସ୍ୟାୱଜ୍ଞାନସ୍ୟ ତସ୍ୟା ଐଶ୍ୱର୍ୟ୍ୟସ୍ୟ ନାଶସ୍ୟ ଚ ସମ୍ଭାୱନା ୱିଦ୍ୟତେे| ");
INSERT INTO sanori_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","ଏତାଦୃଶୀଂ କଥାଂ ଶ୍ରୁତ୍ୱା ତେ ମହାକ୍ରୋଧାନ୍ୱିତାଃ ସନ୍ତ ଉଚ୍ଚୈଃକାରଂ କଥିତୱନ୍ତ ଇଫିଷୀଯାନାମ୍ ଅର୍ତ୍ତିମୀ ଦେୱୀ ମହତୀ ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","ତତଃ ସର୍ୱ୍ୱନଗରଂ କଲହେନ ପରିପୂର୍ଣମଭୱତ୍, ତତଃ ପରଂ ତେ ମାକିଦନୀଯଗାଯାରିସ୍ତାର୍ଖନାମାନୌ ପୌଲସ୍ୟ ଦ୍ୱୌ ସହଚରୌ ଧୃତ୍ୱୈକଚିତ୍ତା ରଙ୍ଗଭୂମିଂ ଜୱେନ ଧାୱିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","ତତଃ ପୌଲୋ ଲୋକାନାଂ ସନ୍ନିଧିଂ ଯାତୁମ୍ ଉଦ୍ୟତୱାନ୍ କିନ୍ତୁ ଶିଷ୍ୟଗଣସ୍ତଂ ୱାରିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","ପୌଲସ୍ୟତ୍ମୀଯା ଆଶିଯାଦେଶସ୍ଥାଃ କତିପଯାଃ ପ୍ରଧାନଲୋକାସ୍ତସ୍ୟ ସମୀପଂ ନରମେକଂ ପ୍ରେଷ୍ୟ ତ୍ୱଂ ରଙ୍ଗଭୂମିଂ ମାଗା ଇତି ନ୍ୟୱେଦଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","ତତୋ ନାନାଲୋକାନାଂ ନାନାକଥାକଥନାତ୍ ସଭା ୱ୍ୟାକୁଲା ଜାତା କିଂ କାରଣାଦ୍ ଏତାୱତୀ ଜନତାଭୱତ୍ ଏତଦ୍ ଅଧିକୈ ର୍ଲୋକୈ ର୍ନାଜ୍ଞାଯି| ");
INSERT INTO sanori_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","ତତଃ ପରଂ ଜନତାମଧ୍ୟାଦ୍ ଯିହୂଦୀଯୈର୍ବହିଷ୍କୃତଃ ସିକନ୍ଦରୋ ହସ୍ତେନ ସଙ୍କେତଂ କୃତ୍ୱା ଲୋକେଭ୍ୟ ଉତ୍ତରଂ ଦାତୁମୁଦ୍ୟତୱାନ୍, ");
INSERT INTO sanori_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","କିନ୍ତୁ ସ ଯିହୂଦୀଯଲୋକ ଇତି ନିଶ୍ଚିତେ ସତି ଇଫିଷୀଯାନାମ୍ ଅର୍ତ୍ତିମୀ ଦେୱୀ ମହତୀତି ୱାକ୍ୟଂ ପ୍ରାଯେଣ ପଞ୍ଚ ଦଣ୍ଡାନ୍ ଯାୱଦ୍ ଏକସ୍ୱରେଣ ଲୋକନିୱହୈଃ ପ୍ରୋକ୍ତଂ| ");
INSERT INTO sanori_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","ତତୋ ନଗରାଧିପତିସ୍ତାନ୍ ସ୍ଥିରାନ୍ କୃତ୍ୱା କଥିତୱାନ୍ ହେ ଇଫିଷାଯାଃ ସର୍ୱ୍ୱେ ଲୋକା ଆକର୍ଣଯତ, ଅର୍ତିମୀମହାଦେୱ୍ୟା ମହାଦେୱାତ୍ ପତିତାଯାସ୍ତତ୍ପ୍ରତିମାଯାଶ୍ଚ ପୂଜନମ ଇଫିଷନଗରସ୍ଥାଃ ସର୍ୱ୍ୱେ ଲୋକାଃ କୁର୍ୱ୍ୱନ୍ତି, ଏତତ୍ କେ ନ ଜାନନ୍ତି? ");
INSERT INTO sanori_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","ତସ୍ମାଦ୍ ଏତତ୍ପ୍ରତିକୂଲଂ କେପି କଥଯିତୁଂ ନ ଶକ୍ନୁୱନ୍ତି, ଇତି ଜ୍ଞାତ୍ୱା ଯୁଷ୍ମାଭିଃ ସୁସ୍ଥିରତ୍ୱେନ ସ୍ଥାତୱ୍ୟମ୍ ଅୱିୱିଚ୍ୟ କିମପି କର୍ମ୍ମ ନ କର୍ତ୍ତୱ୍ୟଞ୍ଚ| ");
INSERT INTO sanori_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","ଯାନ୍ ଏତାନ୍ ମନୁଷ୍ୟାନ୍ ଯୂଯମତ୍ର ସମାନଯତ ତେ ମନ୍ଦିରଦ୍ରୱ୍ୟାପହାରକା ଯୁଷ୍ମାକଂ ଦେୱ୍ୟା ନିନ୍ଦକାଶ୍ଚ ନ ଭୱନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","ଯଦି କଞ୍ଚନ ପ୍ରତି ଦୀମୀତ୍ରିଯସ୍ୟ ତସ୍ୟ ସହାଯାନାଞ୍ଚ କାଚିଦ୍ ଆପତ୍ତି ର୍ୱିଦ୍ୟତେ ତର୍ହି ପ୍ରତିନିଧିଲୋକା ୱିଚାରସ୍ଥାନଞ୍ଚ ସନ୍ତି, ତେ ତତ୍ ସ୍ଥାନଂ ଗତ୍ୱା ଉତ୍ତରପ୍ରତ୍ୟୁତ୍ତରେ କୁର୍ୱ୍ୱନ୍ତୁ| ");
INSERT INTO sanori_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","କିନ୍ତୁ ଯୁଷ୍ମାକଂ କାଚିଦପରା କଥା ଯଦି ତିଷ୍ଠତି ତର୍ହି ନିଯମିତାଯାଂ ସଭାଯାଂ ତସ୍ୟା ନିଷ୍ପତ୍ତି ର୍ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","କିନ୍ତ୍ୱେତସ୍ୟ ୱିରୋଧସ୍ୟୋତ୍ତରଂ ଯେନ ଦାତୁଂ ଶକ୍ନୁମ୍ ଏତାଦୃଶସ୍ୟ କସ୍ୟଚିତ୍ କାରଣସ୍ୟାଭାୱାଦ୍ ଅଦ୍ୟତନଘଟନାହେତୋ ରାଜଦ୍ରୋହିଣାମିୱାସ୍ମାକମ୍ ଅଭିଯୋଗୋ ଭୱିଷ୍ୟତୀତି ଶଙ୍କା ୱିଦ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","ଇତି କଥଯିତ୍ୱା ସ ସଭାସ୍ଥଲୋକାନ୍ ୱିସୃଷ୍ଟୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ଇତ୍ଥଂ କଲହେ ନିୱୃତ୍ତେ ସତି ପୌଲଃ ଶିଷ୍ୟଗଣମ୍ ଆହୂଯ ୱିସର୍ଜନଂ ପ୍ରାପ୍ୟ ମାକିଦନିଯାଦେଶଂ ପ୍ରସ୍ଥିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","ତେନ ସ୍ଥାନେନ ଗଚ୍ଛନ୍ ତଦ୍ଦେଶୀଯାନ୍ ଶିଷ୍ୟାନ୍ ବହୂପଦିଶ୍ୟ ଯୂନାନୀଯଦେଶମ୍ ଉପସ୍ଥିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ତତ୍ର ମାସତ୍ରଯଂ ସ୍ଥିତ୍ୱା ତସ୍ମାତ୍ ସୁରିଯାଦେଶଂ ଯାତୁମ୍ ଉଦ୍ୟତଃ, କିନ୍ତୁ ଯିହୂଦୀଯାସ୍ତଂ ହନ୍ତୁଂ ଗୁପ୍ତା ଅତିଷ୍ଠନ୍ ତସ୍ମାତ୍ ସ ପୁନରପି ମାକିଦନିଯାମାର୍ଗେଣ ପ୍ରତ୍ୟାଗନ୍ତୁଂ ମତିଂ କୃତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","ବିରଯାନଗରୀଯସୋପାତ୍ରଃ ଥିଷଲନୀକୀଯାରିସ୍ତାର୍ଖସିକୁନ୍ଦୌ ଦର୍ବ୍ବୋନଗରୀଯଗାଯତୀମଥିଯୌ ଆଶିଯାଦେଶୀଯତୁଖିକତ୍ରଫିମୌ ଚ ତେନ ସାର୍ଦ୍ଧଂ ଆଶିଯାଦେଶଂ ଯାୱଦ୍ ଗତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ଏତେ ସର୍ୱ୍ୱେ ଽଗ୍ରସରାଃ ସନ୍ତୋ ଽସ୍ମାନ୍ ଅପେକ୍ଷ୍ୟ ତ୍ରୋଯାନଗରେ ସ୍ଥିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","କିଣ୍ୱଶୂନ୍ୟପୂପୋତ୍ସୱଦିନେ ଚ ଗତେ ସତି ୱଯଂ ଫିଲିପୀନଗରାତ୍ ତୋଯପଥେନ ଗତ୍ୱା ପଞ୍ଚଭି ର୍ଦିନୈସ୍ତ୍ରୋଯାନଗରମ୍ ଉପସ୍ଥାଯ ତତ୍ର ସପ୍ତଦିନାନ୍ୟୱାତିଷ୍ଠାମ| ");
INSERT INTO sanori_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","ସପ୍ତାହସ୍ୟ ପ୍ରଥମଦିନେ ପୂପାନ୍ ଭଂକ୍ତୁ ଶିଷ୍ୟେଷୁ ମିଲିତେଷୁ ପୌଲଃ ପରଦିନେ ତସ୍ମାତ୍ ପ୍ରସ୍ଥାତୁମ୍ ଉଦ୍ୟତଃ ସନ୍ ତଦହ୍ନି ପ୍ରାଯେଣ କ୍ଷପାଯା ଯାମଦ୍ୱଯଂ ଯାୱତ୍ ଶିଷ୍ୟେଭ୍ୟୋ ଧର୍ମ୍ମକଥାମ୍ ଅକଥଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ଉପରିସ୍ଥେ ଯସ୍ମିନ୍ ପ୍ରକୋଷ୍ଠେ ସଭାଂ କୃତ୍ୱାସନ୍ ତତ୍ର ବହୱଃ ପ୍ରଦୀପାଃ ପ୍ରାଜ୍ୱଲନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ଉତୁଖନାମା କଶ୍ଚନ ଯୁୱା ଚ ୱାତାଯନ ଉପୱିଶନ୍ ଘୋରତରନିଦ୍ରାଗ୍ରସ୍ତୋ ଽଭୂତ୍ ତଦା ପୌଲେନ ବହୁକ୍ଷଣଂ କଥାଯାଂ ପ୍ରଚାରିତାଯାଂ ନିଦ୍ରାମଗ୍ନଃ ସ ତସ୍ମାଦ୍ ଉପରିସ୍ଥତୃତୀଯପ୍ରକୋଷ୍ଠାଦ୍ ଅପତତ୍, ତତୋ ଲୋକାସ୍ତଂ ମୃତକଲ୍ପଂ ଧୃତ୍ୱୋଦତୋଲଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","ତତଃ ପୌଲୋଽୱରୁହ୍ୟ ତସ୍ୟ ଗାତ୍ରେ ପତିତ୍ୱା ତଂ କ୍ରୋଡେ ନିଧାଯ କଥିତୱାନ୍, ଯୂଯଂ ୱ୍ୟାକୁଲା ମା ଭୂତ ନାଯଂ ପ୍ରାଣୈ ର୍ୱିଯୁକ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","ପଶ୍ଚାତ୍ ସ ପୁନଶ୍ଚୋପରି ଗତ୍ୱା ପୂପାନ୍ ଭଂକ୍ତ୍ୱା ପ୍ରଭାତଂ ଯାୱତ୍ କଥୋପକଥନେ କୃତ୍ୱା ପ୍ରସ୍ଥିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","ତେ ଚ ତଂ ଜୀୱନ୍ତଂ ଯୁୱାନଂ ଗୃହୀତ୍ୱା ଗତ୍ୱା ପରମାପ୍ୟାଯିତା ଜାତାଃ| ");
INSERT INTO sanori_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","ଅନନ୍ତରଂ ୱଯଂ ପୋତେନାଗ୍ରସରା ଭୂତ୍ୱାସ୍ମନଗରମ୍ ଉତ୍ତୀର୍ୟ୍ୟ ପୌଲଂ ଗ୍ରହୀତୁଂ ମତିମ୍ ଅକୁର୍ମ୍ମ ଯତଃ ସ ତତ୍ର ପଦ୍ଭ୍ୟାଂ ୱ୍ରଜିତୁଂ ମତିଂ କୃତ୍ୱେତି ନିରୂପିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","ତସ୍ମାତ୍ ତତ୍ରାସ୍ମାଭିଃ ସାର୍ଦ୍ଧଂ ତସ୍ମିନ୍ ମିଲିତେ ସତି ୱଯଂ ତଂ ନୀତ୍ୱା ମିତୁଲୀନ୍ୟୁପଦ୍ୱୀପଂ ପ୍ରାପ୍ତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","ତସ୍ମାତ୍ ପୋତଂ ମୋଚଯିତ୍ୱା ପରେଽହନି ଖୀଯୋପଦ୍ୱୀପସ୍ୟ ସମ୍ମୁଖଂ ଲବ୍ଧୱନ୍ତସ୍ତସ୍ମାଦ୍ ଏକେନାହ୍ନା ସାମୋପଦ୍ୱୀପଂ ଗତ୍ୱା ପୋତଂ ଲାଗଯିତ୍ୱା ତ୍ରୋଗୁଲ୍ଲିଯେ ସ୍ଥିତ୍ୱା ପରସ୍ମିନ୍ ଦିୱସେे ମିଲୀତନଗରମ୍ ଉପାତିଷ୍ଠାମ| ");
INSERT INTO sanori_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","ଯତଃ ପୌଲ ଆଶିଯାଦେଶେ କାଲଂ ଯାପଯିତୁମ୍ ନାଭିଲଷନ୍ ଇଫିଷନଗରଂ ତ୍ୟକ୍ତ୍ୱା ଯାତୁଂ ମନ୍ତ୍ରଣାଂ ସ୍ଥିରୀକୃତୱାନ୍; ଯସ୍ମାଦ୍ ଯଦି ସାଧ୍ୟଂ ଭୱତି ତର୍ହି ନିସ୍ତାରୋତ୍ସୱସ୍ୟ ପଞ୍ଚାଶତ୍ତମଦିନେ ସ ଯିରୂଶାଲମ୍ୟୁପସ୍ଥାତୁଂ ମତିଂ କୃତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","ପୌଲୋ ମିଲୀତାଦ୍ ଇଫିଷଂ ପ୍ରତି ଲୋକଂ ପ୍ରହିତ୍ୟ ସମାଜସ୍ୟ ପ୍ରାଚୀନାନ୍ ଆହୂଯାନୀତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","ତେଷୁ ତସ୍ୟ ସମୀପମ୍ ଉପସ୍ଥିତେଷୁ ସ ତେଭ୍ୟ ଇମାଂ କଥାଂ କଥିତୱାନ୍, ଅହମ୍ ଆଶିଯାଦେଶେ ପ୍ରଥମାଗମନମ୍ ଆରଭ୍ୟାଦ୍ୟ ଯାୱଦ୍ ଯୁଷ୍ମାକଂ ସନ୍ନିଧୌ ସ୍ଥିତ୍ୱା ସର୍ୱ୍ୱସମଯେ ଯଥାଚରିତୱାନ୍ ତଦ୍ ଯୂଯଂ ଜାନୀଥ; ");
INSERT INTO sanori_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ଫଲତଃ ସର୍ୱ୍ୱଥା ନମ୍ରମନାଃ ସନ୍ ବହୁଶ୍ରୁପାତେନ ଯିହୁଦୀଯାନାମ୍ କୁମନ୍ତ୍ରଣାଜାତନାନାପରୀକ୍ଷାଭିଃ ପ୍ରଭୋଃ ସେୱାମକରୱଂ| ");
INSERT INTO sanori_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","କାମପି ହିତକଥାाଂ ନ ଗୋପାଯିତୱାନ୍ ତାଂ ପ୍ରଚାର୍ୟ୍ୟ ସପ୍ରକାଶଂ ଗୃହେ ଗୃହେ ସମୁପଦିଶ୍ୟେଶ୍ୱରଂ ପ୍ରତି ମନଃ ପରାୱର୍ତ୍ତନୀଯଂ ପ୍ରଭୌ ଯୀଶୁଖ୍ରୀଷ୍ଟେ ୱିଶ୍ୱସନୀଯଂ ");
INSERT INTO sanori_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","ଯିହୂଦୀଯାନାମ୍ ଅନ୍ୟଦେଶୀଯଲୋକାନାଞ୍ଚ ସମୀପ ଏତାଦୃଶଂ ସାକ୍ଷ୍ୟଂ ଦଦାମି| ");
INSERT INTO sanori_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","ପଶ୍ୟତ ସାମ୍ପ୍ରତମ୍ ଆତ୍ମନାକୃଷ୍ଟଃ ସନ୍ ଯିରୂଶାଲମ୍ନଗରେ ଯାତ୍ରାଂ କରୋମି, ତତ୍ର ମାମ୍ପ୍ରତି ଯଦ୍ୟଦ୍ ଘଟିଷ୍ୟତେ ତାନ୍ୟହଂ ନ ଜାନାମି; ");
INSERT INTO sanori_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","କିନ୍ତୁ ମଯା ବନ୍ଧନଂ କ୍ଲେଶଶ୍ଚ ଭୋକ୍ତୱ୍ୟ ଇତି ପୱିତ୍ର ଆତ୍ମା ନଗରେ ନଗରେ ପ୍ରମାଣଂ ଦଦାତି| ");
INSERT INTO sanori_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","ତଥାପି ତଂ କ୍ଲେଶମହଂ ତୃଣାଯ ନ ମନ୍ୟେ; ଈଶ୍ୱରସ୍ୟାନୁଗ୍ରହୱିଷଯକସ୍ୟ ସୁସଂୱାଦସ୍ୟ ପ୍ରମାଣଂ ଦାତୁଂ, ପ୍ରଭୋ ର୍ୟୀଶୋଃ ସକାଶାଦ ଯସ୍ୟାଃ ସେୱାଯାଃ ଭାରଂ ପ୍ରାପ୍ନୱଂ ତାଂ ସେୱାଂ ସାଧଯିତୁଂ ସାନନ୍ଦଂ ସ୍ୱମାର୍ଗଂ ସମାପଯିତୁुଞ୍ଚ ନିଜପ୍ରାଣାନପି ପ୍ରିଯାନ୍ ନ ମନ୍ୟେ| ");
INSERT INTO sanori_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","ଅଧୁନା ପଶ୍ୟତ ଯେଷାଂ ସମୀପେଽହମ୍ ଈଶ୍ୱରୀଯରାଜ୍ୟସ୍ୟ ସୁସଂୱାଦଂ ପ୍ରଚାର୍ୟ୍ୟ ଭ୍ରମଣଂ କୃତୱାନ୍ ଏତାଦୃଶା ଯୂଯଂ ମମ ୱଦନଂ ପୁନ ର୍ଦ୍ରଷ୍ଟୁଂ ନ ପ୍ରାପ୍ସ୍ୟଥ ଏତଦପ୍ୟହଂ ଜାନାମି| ");
INSERT INTO sanori_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","ଯୁଷ୍ମଭ୍ୟମ୍ ଅହମ୍ ଈଶ୍ୱରସ୍ୟ ସର୍ୱ୍ୱାନ୍ ଆଦେଶାନ୍ ପ୍ରକାଶଯିତୁଂ ନ ନ୍ୟୱର୍ତ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","ଅହଂ ସର୍ୱ୍ୱେଷାଂ ଲୋକାନାଂ ରକ୍ତପାତଦୋଷାଦ୍ ଯନ୍ନିର୍ଦୋଷ ଆସେ ତସ୍ୟାଦ୍ୟ ଯୁଷ୍ମାନ୍ ସାକ୍ଷିଣଃ କରୋମି| ");
INSERT INTO sanori_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","ଯୂଯଂ ସ୍ୱେଷୁ ତଥା ଯସ୍ୟ ୱ୍ରଜସ୍ୟାଧ୍ୟକ୍ଷନ୍ ଆତ୍ମା ଯୁଷ୍ମାନ୍ ୱିଧାଯ ନ୍ୟଯୁଙ୍କ୍ତ ତତ୍ସର୍ୱ୍ୱସ୍ମିନ୍ ସାୱଧାନା ଭୱତ, ଯ ସମାଜଞ୍ଚ ପ୍ରଭୁ ର୍ନିଜରକ୍ତମୂଲ୍ୟେନ କ୍ରୀତୱାନ ତମ୍ ଅୱତ, ");
INSERT INTO sanori_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","ଯତୋ ମଯା ଗମନେ କୃତଏୱ ଦୁର୍ଜଯା ୱୃକା ଯୁଷ୍ମାକଂ ମଧ୍ୟଂ ପ୍ରୱିଶ୍ୟ ୱ୍ରଜଂ ପ୍ରତି ନିର୍ଦଯତାମ୍ ଆଚରିଷ୍ୟନ୍ତି, ");
INSERT INTO sanori_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","ଯୁଷ୍ମାକମେୱ ମଧ୍ୟାଦପି ଲୋକା ଉତ୍ଥାଯ ଶିଷ୍ୟଗଣମ୍ ଅପହନ୍ତୁଂ ୱିପରୀତମ୍ ଉପଦେକ୍ଷ୍ୟନ୍ତୀତ୍ୟହଂ ଜାନାମି| ");
INSERT INTO sanori_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","ଇତି ହେତୋ ର୍ୟୂଯଂ ସଚୈତନ୍ୟାଃ ସନ୍ତସ୍ତିଷ୍ଟତ, ଅହଞ୍ଚ ସାଶ୍ରୁପାତଃ ସନ୍ ୱତ୍ସରତ୍ରଯଂ ଯାୱଦ୍ ଦିୱାନିଶଂ ପ୍ରତିଜନଂ ବୋଧଯିତୁଂ ନ ନ୍ୟୱର୍ତ୍ତେ ତଦପି ସ୍ମରତ| ");
INSERT INTO sanori_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","ଇଦାନୀଂ ହେ ଭ୍ରାତରୋ ଯୁଷ୍ମାକଂ ନିଷ୍ଠାଂ ଜନଯିତୁଂ ପୱିତ୍ରୀକୃତଲୋକାନାଂ ମଧ୍ୟେଽଧିକାରଞ୍ଚ ଦାତୁଂ ସମର୍ଥୋ ଯ ଈଶ୍ୱରସ୍ତସ୍ୟାନୁଗ୍ରହସ୍ୟ ଯୋ ୱାଦଶ୍ଚ ତଯୋରୁଭଯୋ ର୍ୟୁଷ୍ମାନ୍ ସମାର୍ପଯମ୍| ");
INSERT INTO sanori_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","କସ୍ୟାପି ସ୍ୱର୍ଣଂ ରୂପ୍ୟଂ ୱସ୍ତ୍ରଂ ୱା ପ୍ରତି ମଯା ଲୋଭୋ ନ କୃତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","କିନ୍ତୁ ମମ ମତ୍ସହଚରଲୋକାନାଞ୍ଚାୱଶ୍ୟକୱ୍ୟଯାଯ ମଦୀଯମିଦଂ କରଦ୍ୱଯମ୍ ଅଶ୍ରାମ୍ୟଦ୍ ଏତଦ୍ ଯୂଯଂ ଜାନୀଥ| ");
INSERT INTO sanori_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","ଅନେନ ପ୍ରକାରେଣ ଗ୍ରହଣଦ୍ ଦାନଂ ଭଦ୍ରମିତି ଯଦ୍ୱାକ୍ୟଂ ପ୍ରଭୁ ର୍ୟୀଶୁଃ କଥିତୱାନ୍ ତତ୍ ସ୍ମର୍ତ୍ତୁଂ ଦରିଦ୍ରଲୋକାନାମୁପକାରାର୍ଥଂ ଶ୍ରମଂ କର୍ତ୍ତୁଞ୍ଚ ଯୁଷ୍ମାକମ୍ ଉଚିତମ୍ ଏତତ୍ସର୍ୱ୍ୱଂ ଯୁଷ୍ମାନହମ୍ ଉପଦିଷ୍ଟୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ଏତାଂ କଥାଂ କଥଯିତ୍ୱା ସ ଜାନୁନୀ ପାତଯିତ୍ୱା ସର୍ୱୈଃ ସହ ପ୍ରାର୍ଥଯତ| ");
INSERT INTO sanori_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","ତେନ ତେ କ୍ରନ୍ଦ୍ରନ୍ତଃ ");
INSERT INTO sanori_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ପୁନ ର୍ମମ ମୁଖଂ ନ ଦ୍ରକ୍ଷ୍ୟଥ ୱିଶେଷତ ଏଷା ଯା କଥା ତେନାକଥି ତତ୍କାରଣାତ୍ ଶୋକଂ ୱିଲାପଞ୍ଚ କୃତ୍ୱା କଣ୍ଠଂ ଧୃତ୍ୱା ଚୁମ୍ବିତୱନ୍ତଃ| ପଶ୍ଚାତ୍ ତେ ତଂ ପୋତଂ ନୀତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","ତୈ ର୍ୱିସୃଷ୍ଟାଃ ସନ୍ତୋ ୱଯଂ ପୋତଂ ବାହଯିତ୍ୱା ଋଜୁମାର୍ଗେଣ କୋଷମ୍ ଉପଦ୍ୱୀପମ୍ ଆଗତ୍ୟ ପରେଽହନି ରୋଦିଯୋପଦ୍ୱୀପମ୍ ଆଗଚ୍ଛାମ ତତସ୍ତସ୍ମାତ୍ ପାତାରାଯାମ୍ ଉପାତିଷ୍ଠାମ| ");
INSERT INTO sanori_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","ତତ୍ର ଫୈନୀକିଯାଦେଶଗାମିନମ୍ ପୋତମେକଂ ପ୍ରାପ୍ୟ ତମାରୁହ୍ୟ ଗତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","କୁପ୍ରୋପଦ୍ୱୀପଂ ଦୃଷ୍ଟ୍ୱା ତଂ ସୱ୍ୟଦିଶି ସ୍ଥାପଯିତ୍ୱା ସୁରିଯାଦେଶଂ ଗତ୍ୱା ପୋତସ୍ଥଦ୍ରୱ୍ୟାଣ୍ୟୱରୋହଯିତୁଂ ସୋରନଗରେ ଲାଗିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","ତତ୍ର ଶିଷ୍ୟଗଣସ୍ୟ ସାକ୍ଷାତ୍କରଣାଯ ୱଯଂ ତତ୍ର ସପ୍ତଦିନାନି ସ୍ଥିତୱନ୍ତଃ ପଶ୍ଚାତ୍ତେ ପୱିତ୍ରେଣାତ୍ମନା ପୌଲଂ ୱ୍ୟାହରନ୍ ତ୍ୱଂ ଯିରୂଶାଲମ୍ନଗରଂ ମା ଗମଃ| ");
INSERT INTO sanori_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","ତତସ୍ତେଷୁ ସପ୍ତସୁ ଦିନେଷୁ ଯାପିତେଷୁ ସତ୍ସୁ ୱଯଂ ତସ୍ମାତ୍ ସ୍ଥାନାତ୍ ନିଜୱର୍ତ୍ମନା ଗତୱନ୍ତଃ, ତସ୍ମାତ୍ ତେ ସବାଲୱୃଦ୍ଧୱନିତା ଅସ୍ମାଭିଃ ସହ ନଗରସ୍ୟ ପରିସରପର୍ୟ୍ୟନ୍ତମ୍ ଆଗତାଃ ପଶ୍ଚାଦ୍ୱଯଂ ଜଲଧିତଟେ ଜାନୁପାତଂ ପ୍ରାର୍ଥଯାମହି| ");
INSERT INTO sanori_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ତତଃ ପରସ୍ପରଂ ୱିସୃଷ୍ଟାଃ ସନ୍ତୋ ୱଯଂ ପୋତଂ ଗତାସ୍ତେ ତୁ ସ୍ୱସ୍ୱଗୃହଂ ପ୍ରତ୍ୟାଗତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","ୱଯଂ ସୋରନଗରାତ୍ ନାୱା ପ୍ରସ୍ଥାଯ ତଲିମାଯିନଗରମ୍ ଉପାତିଷ୍ଠାମ ତତ୍ରାସ୍ମାକଂ ସମୁଦ୍ରୀଯମାର୍ଗସ୍ୟାନ୍ତୋଽଭୱତ୍ ତତ୍ର ଭ୍ରାତୃଗଣଂ ନମସ୍କୃତ୍ୟ ଦିନମେକଂ ତୈଃ ସାର୍ଦ୍ଧମ୍ ଉଷତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","ପରେ ଽହନି ପୌଲସ୍ତସ୍ୟ ସଙ୍ଗିନୋ ୱଯଞ୍ଚ ପ୍ରତିଷ୍ଠମାନାଃ କୈସରିଯାନଗରମ୍ ଆଗତ୍ୟ ସୁସଂୱାଦପ୍ରଚାରକାନାଂ ସପ୍ତଜନାନାଂ ଫିଲିପନାମ୍ନ ଏକସ୍ୟ ଗୃହଂ ପ୍ରୱିଶ୍ୟାୱତିଷ୍ଠାମ| ");
INSERT INTO sanori_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","ତସ୍ୟ ଚତସ୍ରୋ ଦୁହିତରୋଽନୂଢା ଭୱିଷ୍ୟଦ୍ୱାଦିନ୍ୟ ଆସନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","ତତ୍ରାସ୍ମାସୁ ବହୁଦିନାନି ପ୍ରୋଷିତେଷୁ ଯିହୂଦୀଯଦେଶାଦ୍ ଆଗତ୍ୟାଗାବନାମା ଭୱିଷ୍ୟଦ୍ୱାଦୀ ସମୁପସ୍ଥିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ସୋସ୍ମାକଂ ସମୀପମେତ୍ୟ ପୌଲସ୍ୟ କଟିବନ୍ଧନଂ ଗୃହୀତ୍ୱା ନିଜହସ୍ତାପାଦାନ୍ ବଦ୍ଧ୍ୱା ଭାଷିତୱାନ୍ ଯସ୍ୟେଦଂ କଟିବନ୍ଧନଂ ତଂ ଯିହୂଦୀଯଲୋକା ଯିରୂଶାଲମନଗର ଇତ୍ଥଂ ବଦ୍ଧ୍ୱା ଭିନ୍ନଦେଶୀଯାନାଂ କରେଷୁ ସମର୍ପଯିଷ୍ୟନ୍ତୀତି ୱାକ୍ୟଂ ପୱିତ୍ର ଆତ୍ମା କଥଯତି| ");
INSERT INTO sanori_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ଏତାଦୃଶୀଂ କଥାଂ ଶ୍ରୁତ୍ୱା ୱଯଂ ତନ୍ନଗରୱାସିନୋ ଭ୍ରାତରଶ୍ଚ ଯିରୂଶାଲମଂ ନ ଯାତୁଂ ପୌଲଂ ୱ୍ୟନଯାମହି; ");
INSERT INTO sanori_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","କିନ୍ତୁ ସ ପ୍ରତ୍ୟାୱାଦୀତ୍, ଯୂଯଂ କିଂ କୁରୁଥ? କିଂ କ୍ରନ୍ଦନେନ ମମାନ୍ତଃକରଣଂ ୱିଦୀର୍ଣଂ କରିଷ୍ୟଥ? ପ୍ରଭୋ ର୍ୟୀଶୋ ର୍ନାମ୍ନୋ ନିମିତ୍ତଂ ଯିରୂଶାଲମି ବଦ୍ଧୋ ଭୱିତୁଂ କେୱଲ ତନ୍ନ ପ୍ରାଣାନ୍ ଦାତୁମପି ସସଜ୍ଜୋସ୍ମି| ");
INSERT INTO sanori_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","ତେନାସ୍ମାକଂ କଥାଯାମ୍ ଅଗୃହୀତାଯାମ୍ ଈଶ୍ୱରସ୍ୟ ଯଥେଚ୍ଛା ତଥୈୱ ଭୱତ୍ୱିତ୍ୟୁକ୍ତ୍ୱା ୱଯଂ ନିରସ୍ୟାମ| ");
INSERT INTO sanori_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","ପରେଽହନି ପାଥେଯଦ୍ରୱ୍ୟାଣି ଗୃହୀତ୍ୱା ଯିରୂଶାଲମଂ ପ୍ରତି ଯାତ୍ରାମ୍ ଅକୁର୍ମ୍ମ| ");
INSERT INTO sanori_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","ତତଃ କୈସରିଯାନଗରନିୱାସିନଃ କତିପଯାଃ ଶିଷ୍ୟା ଅସ୍ମାଭିଃ ସାର୍ଦ୍ଧମ୍ ଇତ୍ୱା କୃପ୍ରୀଯେନ ମ୍ନାସନ୍ନାମ୍ନା ଯେନ ପ୍ରାଚୀନଶିଷ୍ୟେନ ସାର୍ଦ୍ଧମ୍ ଅସ୍ମାଭି ର୍ୱସ୍ତୱ୍ୟଂ ତସ୍ୟ ସମୀପମ୍ ଅସ୍ମାନ୍ ନୀତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","ଅସ୍ମାସୁ ଯିରୂଶାଲମ୍ୟୁପସ୍ଥିତେଷୁ ତତ୍ରସ୍ଥଭ୍ରାତୃଗଣୋଽସ୍ମାନ୍ ଆହ୍ଲାଦେନ ଗୃହୀତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","ପରସ୍ମିନ୍ ଦିୱସେ ପୌଲେଽସ୍ମାଭିଃ ସହ ଯାକୂବୋ ଗୃହଂ ପ୍ରୱିଷ୍ଟେ ଲୋକପ୍ରାଚୀନାଃ ସର୍ୱ୍ୱେ ତତ୍ର ପରିଷଦି ସଂସ୍ଥିତାଃ| ");
INSERT INTO sanori_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","ଅନନ୍ତରଂ ସ ତାନ୍ ନତ୍ୱା ସ୍ୱୀଯପ୍ରଚାରଣେନ ଭିନ୍ନଦେଶୀଯାନ୍ ପ୍ରତୀଶ୍ୱରୋ ଯାନି କର୍ମ୍ମାଣି ସାଧିତୱାନ୍ ତଦୀଯାଂ କଥାମ୍ ଅନୁକ୍ରମାତ୍ କଥିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ଇତି ଶ୍ରୁତ୍ୱା ତେ ପ୍ରଭୁଂ ଧନ୍ୟଂ ପ୍ରୋଚ୍ୟ ୱାକ୍ୟମିଦମ୍ ଅଭାଷନ୍ତ, ହେ ଭ୍ରାତ ର୍ୟିହୂଦୀଯାନାଂ ମଧ୍ୟେ ବହୁସହସ୍ରାଣି ଲୋକା ୱିଶ୍ୱାସିନ ଆସତେ କିନ୍ତୁ ତେ ସର୍ୱ୍ୱେ ୱ୍ୟୱସ୍ଥାମତାଚାରିଣ ଏତତ୍ ପ୍ରତ୍ୟକ୍ଷଂ ପଶ୍ୟସି| ");
INSERT INTO sanori_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","ଶିଶୂନାଂ ତ୍ୱକ୍ଛେଦନାଦ୍ୟାଚରଣଂ ପ୍ରତିଷିଧ୍ୟ ତ୍ୱଂ ଭିନ୍ନଦେଶନିୱାସିନୋ ଯିହୂଦୀଯଲୋକାନ୍ ମୂସାୱାକ୍ୟମ୍ ଅଶ୍ରଦ୍ଧାତୁମ୍ ଉପଦିଶସୀତି ତୈଃ ଶ୍ରୁତମସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","ତ୍ୱମତ୍ରାଗତୋସୀତି ୱାର୍ତ୍ତାଂ ସମାକର୍ଣ୍ୟ ଜନନିୱହୋ ମିଲିତ୍ୱାୱଶ୍ୟମେୱାଗମିଷ୍ୟତି; ଅତଏୱ କିଂ କରଣୀଯମ୍? ଅତ୍ର ୱଯଂ ମନ୍ତ୍ରଯିତ୍ୱା ସମୁପାଯଂ ତ୍ୱାଂ ୱଦାମସ୍ତଂ ତ୍ୱମାଚର| ");
INSERT INTO sanori_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","ୱ୍ରତଂ କର୍ତ୍ତୁଂ କୃତସଙ୍କଲ୍ପା ଯେଽସ୍ମାଂକ ଚତ୍ୱାରୋ ମାନୱାଃ ସନ୍ତି ");
INSERT INTO sanori_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","ତାନ୍ ଗୃହୀତ୍ୱା ତୈଃ ସହିତଃ ସ୍ୱଂ ଶୁଚିଂ କୁରୁ ତଥା ତେଷାଂ ଶିରୋମୁଣ୍ଡନେ ଯୋ ୱ୍ୟଯୋ ଭୱତି ତଂ ତ୍ୱଂ ଦେହି| ତଥା କୃତେ ତ୍ୱଦୀଯାଚାରେ ଯା ଜନଶ୍ରୁତି ର୍ଜାଯତେ ସାଲୀକା କିନ୍ତୁ ତ୍ୱଂ ୱିଧିଂ ପାଲଯନ୍ ୱ୍ୟୱସ୍ଥାନୁସାରେଣେୱାଚରସୀତି ତେ ଭୋତ୍ସନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","ଭିନ୍ନଦେଶୀଯାନାଂ ୱିଶ୍ୱାସିଲୋକାନାଂ ନିକଟେ ୱଯଂ ପତ୍ରଂ ଲିଖିତ୍ୱେତ୍ଥଂ ସ୍ଥିରୀକୃତୱନ୍ତଃ, ଦେୱପ୍ରସାଦଭୋଜନଂ ରକ୍ତଂ ଗଲପୀଡନମାରିତପ୍ରାଣିଭୋଜନଂ ୱ୍ୟଭିଚାରଶ୍ଚୈତେଭ୍ୟଃ ସ୍ୱରକ୍ଷଣୱ୍ୟତିରେକେଣ ତେଷାମନ୍ୟୱିଧିପାଲନଂ କରଣୀଯଂ ନ| ");
INSERT INTO sanori_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","ତତଃ ପୌଲସ୍ତାନ୍ ମାନୁଷାନାଦାଯ ପରସ୍ମିନ୍ ଦିୱସେ ତୈଃ ସହ ଶୁଚି ର୍ଭୂତ୍ୱା ମନ୍ଦିରଂ ଗତ୍ୱା ଶୌଚକର୍ମ୍ମଣୋ ଦିନେଷୁ ସମ୍ପୂର୍ଣେଷୁ ତେଷାମ୍ ଏକୈକାର୍ଥଂ ନୈୱେଦ୍ୟାଦ୍ୟୁତ୍ସର୍ଗୋ ଭୱିଷ୍ୟତୀତି ଜ୍ଞାପିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","ତେଷୁ ସପ୍ତସୁ ଦିନେଷୁ ସମାପ୍ତକଲ୍ପେଷୁ ଆଶିଯାଦେଶନିୱାସିନୋ ଯିହୂଦୀଯାସ୍ତଂ ମଧ୍ୟେମନ୍ଦିରଂ ୱିଲୋକ୍ୟ ଜନନିୱହସ୍ୟ ମନଃସୁ କୁପ୍ରୱୃତ୍ତିଂ ଜନଯିତ୍ୱା ତଂ ଧୃତ୍ୱା ");
INSERT INTO sanori_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ପ୍ରୋଚ୍ଚୈଃ ପ୍ରାୱୋଚନ୍, ହେ ଇସ୍ରାଯେଲ୍ଲୋକାଃ ସର୍ୱ୍ୱେ ସାହାଯ୍ୟଂ କୁରୁତ| ଯୋ ମନୁଜ ଏତେଷାଂ ଲୋକାନାଂ ମୂସାୱ୍ୟୱସ୍ଥାଯା ଏତସ୍ୟ ସ୍ଥାନସ୍ୟାପି ୱିପରୀତଂ ସର୍ୱ୍ୱତ୍ର ସର୍ୱ୍ୱାନ୍ ଶିକ୍ଷଯତି ସ ଏଷଃ; ୱିଶେଷତଃ ସ ଭିନ୍ନଦେଶୀଯଲୋକାନ୍ ମନ୍ଦିରମ୍ ଆନୀଯ ପୱିତ୍ରସ୍ଥାନମେତଦ୍ ଅପୱିତ୍ରମକରୋତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","ପୂର୍ୱ୍ୱଂ ତେ ମଧ୍ୟେନଗରମ୍ ଇଫିଷନଗରୀଯଂ ତ୍ରଫିମଂ ପୌଲେନ ସହିତଂ ଦୃଷ୍ଟୱନ୍ତ ଏତସ୍ମାତ୍ ପୌଲସ୍ତଂ ମନ୍ଦିରମଧ୍ୟମ୍ ଆନଯଦ୍ ଇତ୍ୟନ୍ୱମିମତ| ");
INSERT INTO sanori_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","ଅତଏୱ ସର୍ୱ୍ୱସ୍ମିନ୍ ନଗରେ କଲହୋତ୍ପନ୍ନତ୍ୱାତ୍ ଧାୱନ୍ତୋ ଲୋକା ଆଗତ୍ୟ ପୌଲଂ ଧୃତ୍ୱା ମନ୍ଦିରସ୍ୟ ବହିରାକୃଷ୍ୟାନଯନ୍ ତତ୍କ୍ଷଣାଦ୍ ଦ୍ୱାରାଣି ସର୍ୱ୍ୱାଣି ଚ ରୁଦ୍ଧାନି| ");
INSERT INTO sanori_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","ତେଷୁ ତଂ ହନ୍ତୁମୁଦ୍ୟତେेଷୁ ଯିରୂଶାଲମ୍ନଗରେ ମହାନୁପଦ୍ରୱୋ ଜାତ ଇତି ୱାର୍ତ୍ତାଯାଂ ସହସ୍ରସେନାପତେଃ କର୍ଣଗୋଚରୀଭୂତାଯାଂ ସତ୍ୟାଂ ସ ତତ୍କ୍ଷଣାତ୍ ସୈନ୍ୟାନି ସେନାପତିଗଣଞ୍ଚ ଗୃହୀତ୍ୱା ଜୱେନାଗତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","ତତୋ ଲୋକାଃ ସେନାଗଣେନ ସହ ସହସ୍ରସେନାପତିମ୍ ଆଗଚ୍ଛନ୍ତଂ ଦୃଷ୍ଟ୍ୱା ପୌଲତାଡନାତୋ ନ୍ୟୱର୍ତ୍ତନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","ସ ସହସ୍ରସେନାପତିଃ ସନ୍ନିଧାୱାଗମ୍ୟ ପୌଲଂ ଧୃତ୍ୱା ଶୃଙ୍ଖଲଦ୍ୱଯେନ ବଦ୍ଧମ୍ ଆଦିଶ୍ୟ ତାନ୍ ପୃଷ୍ଟୱାନ୍ ଏଷ କଃ? କିଂ କର୍ମ୍ମ ଚାଯଂ କୃତୱାନ୍? ");
INSERT INTO sanori_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","ତତୋ ଜନସମୂହସ୍ୟ କଶ୍ଚିଦ୍ ଏକପ୍ରକାରଂ କଶ୍ଚିଦ୍ ଅନ୍ୟପ୍ରକାରଂ ୱାକ୍ୟମ୍ ଅରୌତ୍ ସ ତତ୍ର ସତ୍ୟଂ ଜ୍ଞାତୁମ୍ କଲହକାରଣାଦ୍ ଅଶକ୍ତଃ ସନ୍ ତଂ ଦୁର୍ଗଂ ନେତୁମ୍ ଆଜ୍ଞାପଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","ତେଷୁ ସୋପାନସ୍ୟୋପରି ପ୍ରାପ୍ତେଷୁ ଲୋକାନାଂ ସାହସକାରଣାତ୍ ସେନାଗଣଃ ପୌଲମୁତ୍ତୋଲ୍ୟ ନୀତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ତତଃ ସର୍ୱ୍ୱେ ଲୋକାଃ ପଶ୍ଚାଦ୍ଗାମିନଃ ସନ୍ତ ଏନଂ ଦୁରୀକୁରୁତେତି ୱାକ୍ୟମ୍ ଉଚ୍ଚୈରୱଦନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","ପୌଲସ୍ୟ ଦୁର୍ଗାନଯନସମଯେ ସ ତସ୍ମୈ ସହସ୍ରସେନାପତଯେ କଥିତୱାନ୍, ଭୱତଃ ପୁରସ୍ତାତ୍ କଥାଂ କଥଯିତୁଂ କିମ୍ ଅନୁମନ୍ୟତେ? ସ ତମପୃଚ୍ଛତ୍ ତ୍ୱଂ କିଂ ଯୂନାନୀଯାଂ ଭାଷାଂ ଜାନାସି? ");
INSERT INTO sanori_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","ଯୋ ମିସରୀଯୋ ଜନଃ ପୂର୍ୱ୍ୱଂ ୱିରୋଧଂ କୃତ୍ୱା ଚତ୍ୱାରି ସହସ୍ରାଣି ଘାତକାନ୍ ସଙ୍ଗିନଃ କୃତ୍ୱା ୱିପିନଂ ଗତୱାନ୍ ତ୍ୱଂ କିଂ ସଏୱ ନ ଭୱସି? ");
INSERT INTO sanori_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","ତଦା ପୌଲୋଽକଥଯତ୍ ଅହଂ କିଲିକିଯାଦେଶସ୍ୟ ତାର୍ଷନଗରୀଯୋ ଯିହୂଦୀଯୋ, ନାହଂ ସାମାନ୍ୟନଗରୀଯୋ ମାନୱଃ; ଅତଏୱ ୱିନଯେଽହଂ ଲାକାନାଂ ସମକ୍ଷଂ କଥାଂ କଥଯିତୁଂ ମାମନୁଜାନୀଷ୍ୱ| ");
INSERT INTO sanori_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","ତେନାନୁଜ୍ଞାତଃ ପୌଲଃ ସୋପାନୋପରି ତିଷ୍ଠନ୍ ହସ୍ତେନେଙ୍ଗିତଂ କୃତୱାନ୍, ତସ୍ମାତ୍ ସର୍ୱ୍ୱେ ସୁସ୍ଥିରା ଅଭୱନ୍| ତଦା ପୌଲ ଇବ୍ରୀଯଭାଷଯା କଥଯିତୁମ୍ ଆରଭତ, ");
INSERT INTO sanori_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","ହେ ପିତୃଗଣା ହେ ଭ୍ରାତୃଗଣାଃ, ଇଦାନୀଂ ମମ ନିୱେଦନେ ସମୱଧତ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","ତଦା ସ ଇବ୍ରୀଯଭାଷଯା କଥାଂ କଥଯତୀତି ଶ୍ରୁତ୍ୱା ସର୍ୱ୍ୱେ ଲୋକା ଅତୀୱ ନିଃଶବ୍ଦା ସନ୍ତୋଽତିଷ୍ଠନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","ପଶ୍ଚାତ୍ ସୋଽକଥଯଦ୍ ଅହଂ ଯିହୂଦୀଯ ଇତି ନିଶ୍ଚଯଃ କିଲିକିଯାଦେଶସ୍ୟ ତାର୍ଷନଗରଂ ମମ ଜନ୍ମଭୂମିଃ,ଏତନ୍ନଗରୀଯସ୍ୟ ଗମିଲୀଯେଲନାମ୍ନୋଽଧ୍ୟାପକସ୍ୟ ଶିଷ୍ୟୋ ଭୂତ୍ୱା ପୂର୍ୱ୍ୱପୁରୁଷାଣାଂ ୱିଧିୱ୍ୟୱସ୍ଥାନୁସାରେଣ ସମ୍ପୂର୍ଣରୂପେଣ ଶିକ୍ଷିତୋଽଭୱମ୍ ଇଦାନୀନ୍ତନା ଯୂଯଂ ଯାଦୃଶା ଭୱଥ ତାଦୃଶୋଽହମପୀଶ୍ୱରସେୱାଯାମ୍ ଉଦ୍ୟୋଗୀ ଜାତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","ମତମେତଦ୍ ଦ୍ୱିଷ୍ଟ୍ୱା ତଦ୍ଗ୍ରାହିନାରୀପୁରୁଷାନ୍ କାରାଯାଂ ବଦ୍ଧ୍ୱା ତେଷାଂ ପ୍ରାଣନାଶପର୍ୟ୍ୟନ୍ତାଂ ୱିପକ୍ଷତାମ୍ ଅକରୱମ୍| ");
INSERT INTO sanori_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","ମହାଯାଜକଃ ସଭାସଦଃ ପ୍ରାଚୀନଲୋକାଶ୍ଚ ମମୈତସ୍ୟାଃ କଥାଯାଃ ପ୍ରମାଣଂ ଦାତୁଂ ଶକ୍ନୁୱନ୍ତି, ଯସ୍ମାତ୍ ତେଷାଂ ସମୀପାଦ୍ ଦମ୍ମେଷକନଗରନିୱାସିଭ୍ରାତୃଗଣାର୍ଥମ୍ ଆଜ୍ଞାପତ୍ରାଣି ଗୃହୀତ୍ୱା ଯେ ତତ୍ର ସ୍ଥିତାସ୍ତାନ୍ ଦଣ୍ଡଯିତୁଂ ଯିରୂଶାଲମମ୍ ଆନଯନାର୍ଥଂ ଦମ୍ମେଷକନଗରଂ ଗତୋସ୍ମି| ");
INSERT INTO sanori_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","କିନ୍ତୁ ଗଚ୍ଛନ୍ ତନ୍ନଗରସ୍ୟ ସମୀପଂ ପ୍ରାପ୍ତୱାନ୍ ତଦା ଦ୍ୱିତୀଯପ୍ରହରୱେଲାଯାଂ ସତ୍ୟାମ୍ ଅକସ୍ମାଦ୍ ଗଗଣାନ୍ନିର୍ଗତ୍ୟ ମହତୀ ଦୀପ୍ତି ର୍ମମ ଚତୁର୍ଦିଶି ପ୍ରକାଶିତୱତୀ| ");
INSERT INTO sanori_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ତତୋ ମଯି ଭୂମୌै ପତିତେ ସତି, ହେ ଶୌଲ ହେ ଶୌଲ କୁତୋ ମାଂ ତାଡଯସି? ମାମ୍ପ୍ରତି ଭାଷିତ ଏତାଦୃଶ ଏକୋ ରୱୋପି ମଯା ଶ୍ରୁତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","ତଦାହଂ ପ୍ରତ୍ୟୱଦଂ, ହେ ପ୍ରଭେ କୋ ଭୱାନ୍? ତତଃ ସୋଽୱାଦୀତ୍ ଯଂ ତ୍ୱଂ ତାଡଯସି ସ ନାସରତୀଯୋ ଯୀଶୁରହଂ| ");
INSERT INTO sanori_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","ମମ ସଙ୍ଗିନୋ ଲୋକାସ୍ତାଂ ଦୀପ୍ତିଂ ଦୃଷ୍ଟ୍ୱା ଭିଯଂ ପ୍ରାପ୍ତାଃ, କିନ୍ତୁ ମାମ୍ପ୍ରତ୍ୟୁଦିତଂ ତଦ୍ୱାକ୍ୟଂ ତେे ନାବୁଧ୍ୟନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","ତତଃ ପରଂ ପୃଷ୍ଟୱାନହଂ, ହେ ପ୍ରଭୋ ମଯା କିଂ କର୍ତ୍ତୱ୍ୟଂ? ତତଃ ପ୍ରଭୁରକଥଯତ୍, ଉତ୍ଥାଯ ଦମ୍ମେଷକନଗରଂ ଯାହି ତ୍ୱଯା ଯଦ୍ୟତ୍ କର୍ତ୍ତୱ୍ୟଂ ନିରୂପିତମାସ୍ତେ ତତ୍ ତତ୍ର ତ୍ୱଂ ଜ୍ଞାପଯିଷ୍ୟସେ| ");
INSERT INTO sanori_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","ଅନନ୍ତରଂ ତସ୍ୟାଃ ଖରତରଦୀପ୍ତେଃ କାରଣାତ୍ କିମପି ନ ଦୃଷ୍ଟ୍ୱା ସଙ୍ଗିଗଣେନ ଧୃତହସ୍ତଃ ସନ୍ ଦମ୍ମେଷକନଗରଂ ୱ୍ରଜିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","ତନ୍ନଗରନିୱାସିନାଂ ସର୍ୱ୍ୱେଷାଂ ଯିହୂଦୀଯାନାଂ ମାନ୍ୟୋ ୱ୍ୟୱସ୍ଥାନୁସାରେଣ ଭକ୍ତଶ୍ଚ ହନାନୀଯନାମା ମାନୱ ଏକୋ ");
INSERT INTO sanori_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","ମମ ସନ୍ନିଧିମ୍ ଏତ୍ୟ ତିଷ୍ଠନ୍ ଅକଥଯତ୍, ହେ ଭ୍ରାତଃ ଶୌଲ ସୁଦୃଷ୍ଟି ର୍ଭୱ ତସ୍ମିନ୍ ଦଣ୍ଡେଽହଂ ସମ୍ୟକ୍ ତଂ ଦୃଷ୍ଟୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","ତତଃ ସ ମହ୍ୟଂ କଥିତୱାନ୍ ଯଥା ତ୍ୱମ୍ ଈଶ୍ୱରସ୍ୟାଭିପ୍ରାଯଂ ୱେତ୍ସି ତସ୍ୟ ଶୁଦ୍ଧସତ୍ତ୍ୱଜନସ୍ୟ ଦର୍ଶନଂ ପ୍ରାପ୍ୟ ତସ୍ୟ ଶ୍ରୀମୁଖସ୍ୟ ୱାକ୍ୟଂ ଶୃଣୋଷି ତନ୍ନିମିତ୍ତମ୍ ଅସ୍ମାକଂ ପୂର୍ୱ୍ୱପୁରୁଷାଣାମ୍ ଈଶ୍ୱରସ୍ତ୍ୱାଂ ମନୋନୀତଂ କୃତୱାନଂ| ");
INSERT INTO sanori_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","ଯତୋ ଯଦ୍ୟଦ୍ ଅଦ୍ରାକ୍ଷୀରଶ୍ରୌଷୀଶ୍ଚ ସର୍ୱ୍ୱେଷାଂ ମାନୱାନାଂ ସମୀପେ ତ୍ୱଂ ତେଷାଂ ସାକ୍ଷୀ ଭୱିଷ୍ୟସି| ");
INSERT INTO sanori_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","ଅତଏୱ କୁତୋ ୱିଲମ୍ବସେ? ପ୍ରଭୋ ର୍ନାମ୍ନା ପ୍ରାର୍ଥ୍ୟ ନିଜପାପପ୍ରକ୍ଷାଲନାର୍ଥଂ ମଜ୍ଜନାଯ ସମୁତ୍ତିଷ୍ଠ| ");
INSERT INTO sanori_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","ତତଃ ପରଂ ଯିରୂଶାଲମ୍ନଗରଂ ପ୍ରତ୍ୟାଗତ୍ୟ ମନ୍ଦିରେଽହମ୍ ଏକଦା ପ୍ରାର୍ଥଯେ, ତସ୍ମିନ୍ ସମଯେଽହମ୍ ଅଭିଭୂତଃ ସନ୍ ପ୍ରଭୂଂ ସାକ୍ଷାତ୍ ପଶ୍ୟନ୍, ");
INSERT INTO sanori_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ତ୍ୱଂ ତ୍ୱରଯା ଯିରୂଶାଲମଃ ପ୍ରତିଷ୍ଠସ୍ୱ ଯତୋ ଲୋକାମଯି ତୱ ସାକ୍ଷ୍ୟଂ ନ ଗ୍ରହୀଷ୍ୟନ୍ତି, ମାମ୍ପ୍ରତ୍ୟୁଦିତଂ ତସ୍ୟେଦଂ ୱାକ୍ୟମ୍ ଅଶ୍ରୌଷମ୍| ");
INSERT INTO sanori_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","ତତୋହଂ ପ୍ରତ୍ୟୱାଦିଷମ୍ ହେ ପ୍ରଭୋ ପ୍ରତିଭଜନଭୱନଂ ତ୍ୱଯି ୱିଶ୍ୱାସିନୋ ଲୋକାନ୍ ବଦ୍ଧ୍ୱା ପ୍ରହୃତୱାନ୍, ");
INSERT INTO sanori_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","ତଥା ତୱ ସାକ୍ଷିଣଃ ସ୍ତିଫାନସ୍ୟ ରକ୍ତପାତନସମଯେ ତସ୍ୟ ୱିନାଶଂ ସମ୍ମନ୍ୟ ସନ୍ନିଧୌ ତିଷ୍ଠନ୍ ହନ୍ତୃଲୋକାନାଂ ୱାସାଂସି ରକ୍ଷିତୱାନ୍, ଏତତ୍ ତେ ୱିଦୁଃ| ");
INSERT INTO sanori_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","ତତଃ ସୋଽକଥଯତ୍ ପ୍ରତିଷ୍ଠସ୍ୱ ତ୍ୱାଂ ଦୂରସ୍ଥଭିନ୍ନଦେଶୀଯାନାଂ ସମୀପଂ ପ୍ରେଷଯିଷ୍ୟେ| ");
INSERT INTO sanori_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","ତଦା ଲୋକା ଏତାୱତ୍ପର୍ୟ୍ୟନ୍ତାଂ ତଦୀଯାଂ କଥାଂ ଶ୍ରୁତ୍ୱା ପ୍ରୋଚ୍ଚୈରକଥଯନ୍, ଏନଂ ଭୂମଣ୍ଡଲାଦ୍ ଦୂରୀକୁରୁତ, ଏତାଦୃଶଜନସ୍ୟ ଜୀୱନଂ ନୋଚିତମ୍| ");
INSERT INTO sanori_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ଇତ୍ୟୁଚ୍ଚୈଃ କଥଯିତ୍ୱା ୱସନାନି ପରିତ୍ୟଜ୍ୟ ଗଗଣଂ ପ୍ରତି ଧୂଲୀରକ୍ଷିପନ୍ ");
INSERT INTO sanori_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ତତଃ ସହସ୍ରସେନାପତିଃ ପୌଲଂ ଦୁର୍ଗାଭ୍ୟନ୍ତର ନେତୁଂ ସମାଦିଶତ୍| ଏତସ୍ୟ ପ୍ରତିକୂଲାଃ ସନ୍ତୋ ଲୋକାଃ କିନ୍ନିମିତ୍ତମ୍ ଏତାୱଦୁଚ୍ଚୈଃସ୍ୱରମ୍ ଅକୁର୍ୱ୍ୱନ୍, ଏତଦ୍ ୱେତ୍ତୁଂ ତଂ କଶଯା ପ୍ରହୃତ୍ୟ ତସ୍ୟ ପରୀକ୍ଷାଂ କର୍ତ୍ତୁମାଦିଶତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","ପଦାତଯଶ୍ଚର୍ମ୍ମନିର୍ମ୍ମିତରଜ୍ଜୁଭିସ୍ତସ୍ୟ ବନ୍ଧନଂ କର୍ତ୍ତୁମୁଦ୍ୟତାସ୍ତାସ୍ତଦାନୀଂ ପୌଲଃ ସମ୍ମୁଖସ୍ଥିତଂ ଶତସେନାପତିମ୍ ଉକ୍ତୱାନ୍ ଦଣ୍ଡାଜ୍ଞାଯାମ୍ ଅପ୍ରାପ୍ତାଯାଂ କିଂ ରୋମିଲୋକଂ ପ୍ରହର୍ତ୍ତୁଂ ଯୁଷ୍ମାକମ୍ ଅଧିକାରୋସ୍ତି? ");
INSERT INTO sanori_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","ଏନାଂ କଥାଂ ଶ୍ରୁତ୍ୱା ସ ସହସ୍ରସେନାପତେଃ ସନ୍ନିଧିଂ ଗତ୍ୱା ତାଂ ୱାର୍ତ୍ତାମୱଦତ୍ ସ ରୋମିଲୋକ ଏତସ୍ମାତ୍ ସାୱଧାନଃ ସନ୍ କର୍ମ୍ମ କୁରୁ| ");
INSERT INTO sanori_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","ତସ୍ମାତ୍ ସହସ୍ରସେନାପତି ର୍ଗତ୍ୱା ତମପ୍ରାକ୍ଷୀତ୍ ତ୍ୱଂ କିଂ ରୋମିଲୋକଃ? ଇତି ମାଂ ବ୍ରୂହି| ସୋଽକଥଯତ୍ ସତ୍ୟମ୍| ");
INSERT INTO sanori_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","ତତଃ ସହସ୍ରସେନାପତିଃ କଥିତୱାନ୍ ବହୁଦ୍ରୱିଣଂ ଦତ୍ତ୍ୱାହଂ ତତ୍ ପୌରସଖ୍ୟଂ ପ୍ରାପ୍ତୱାନ୍; କିନ୍ତୁ ପୌଲଃ କଥିତୱାନ୍ ଅହଂ ଜନୁନା ତତ୍ ପ୍ରାପ୍ତୋଽସ୍ମି| ");
INSERT INTO sanori_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","ଇତ୍ଥଂ ସତି ଯେ ପ୍ରହାରେଣ ତଂ ପରୀକ୍ଷିତୁଂ ସମୁଦ୍ୟତା ଆସନ୍ ତେ ତସ୍ୟ ସମୀପାତ୍ ପ୍ରାତିଷ୍ଠନ୍ତ; ସହସ୍ରସେନାପତିସ୍ତଂ ରୋମିଲୋକଂ ୱିଜ୍ଞାଯ ସ୍ୱଯଂ ଯତ୍ ତସ୍ୟ ବନ୍ଧନମ୍ ଅକାର୍ଷୀତ୍ ତତ୍କାରଣାଦ୍ ଅବିଭେତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","ଯିହୂଦୀଯଲୋକାଃ ପୌଲଂ କୁତୋଽପୱଦନ୍ତେ ତସ୍ୟ ୱୃତ୍ତାନ୍ତଂ ଜ୍ଞାତୁଂ ୱାଞ୍ଛନ୍ ସହସ୍ରସେନାପତିଃ ପରେଽହନି ପୌଲଂ ବନ୍ଧନାତ୍ ମୋଚଯିତ୍ୱା ପ୍ରଧାନଯାଜକାନ୍ ମହାସଭାଯାଃ ସର୍ୱ୍ୱଲୋକାଶ୍ଚ ସମୁପସ୍ଥାତୁମ୍ ଆଦିଶ୍ୟ ତେଷାଂ ସନ୍ନିଧୌ ପୌଲମ୍ ଅୱରୋହ୍ୟ ସ୍ଥାପିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","ସଭାସଦ୍ଲୋକାନ୍ ପ୍ରତି ପୌଲୋଽନନ୍ୟଦୃଷ୍ଟ୍ୟା ପଶ୍ୟନ୍ ଅକଥଯତ୍, ହେ ଭ୍ରାତୃଗଣା ଅଦ୍ୟ ଯାୱତ୍ ସରଲେନ ସର୍ୱ୍ୱାନ୍ତଃକରଣେନେଶ୍ୱରସ୍ୟ ସାକ୍ଷାଦ୍ ଆଚରାମି| ");
INSERT INTO sanori_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","ଅନେନ ହନାନୀଯନାମା ମହାଯାଜକସ୍ତଂ କପୋଲେ ଚପେଟେନାହନ୍ତୁଂ ସମୀପସ୍ଥଲୋକାନ୍ ଆଦିଷ୍ଟୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","ତଦା ପୌଲସ୍ତମୱଦତ୍, ହେ ବହିଷ୍ପରିଷ୍କୃତ, ଈଶ୍ୱରସ୍ତ୍ୱାଂ ପ୍ରହର୍ତ୍ତୁମ୍ ଉଦ୍ୟତୋସ୍ତି, ଯତୋ ୱ୍ୟୱସ୍ଥାନୁସାରେଣ ୱିଚାରଯିତୁମ୍ ଉପୱିଶ୍ୟ ୱ୍ୟୱସ୍ଥାଂ ଲଙ୍ଘିତ୍ୱା ମାଂ ପ୍ରହର୍ତ୍ତୁମ୍ ଆଜ୍ଞାପଯସି| ");
INSERT INTO sanori_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","ତତୋ ନିକଟସ୍ଥା ଲୋକା ଅକଥଯନ୍, ତ୍ୱଂ କିମ୍ ଈଶ୍ୱରସ୍ୟ ମହାଯାଜକଂ ନିନ୍ଦସି? ");
INSERT INTO sanori_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","ତତଃ ପୌଲଃ ପ୍ରତିଭାଷିତୱାନ୍ ହେ ଭ୍ରାତୃଗଣ ମହାଯାଜକ ଏଷ ଇତି ନ ବୁଦ୍ଧଂ ମଯା ତଦନ୍ୟଚ୍ଚ ସ୍ୱଲୋକାନାମ୍ ଅଧିପତିଂ ପ୍ରତି ଦୁର୍ୱ୍ୱାକ୍ୟଂ ମା କଥଯ, ଏତାଦୃଶୀ ଲିପିରସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","ଅନନ୍ତରଂ ପୌଲସ୍ତେଷାମ୍ ଅର୍ଦ୍ଧଂ ସିଦୂକିଲୋକା ଅର୍ଦ୍ଧଂ ଫିରୂଶିଲୋକା ଇତି ଦୃଷ୍ଟ୍ୱା ପ୍ରୋଚ୍ଚୈଃ ସଭାସ୍ଥଲୋକାନ୍ ଅୱଦତ୍ ହେ ଭ୍ରାତୃଗଣ ଅହଂ ଫିରୂଶିମତାୱଲମ୍ବୀ ଫିରୂଶିନଃ ସତ୍ନାନଶ୍ଚ, ମୃତଲୋକାନାମ୍ ଉତ୍ଥାନେ ପ୍ରତ୍ୟାଶାକରଣାଦ୍ ଅହମପୱାଦିତୋସ୍ମି| ");
INSERT INTO sanori_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ଇତି କଥାଯାଂ କଥିତାଯାଂ ଫିରୂଶିସିଦୂକିନୋଃ ପରସ୍ପରଂ ଭିନ୍ନୱାକ୍ୟତ୍ୱାତ୍ ସଭାଯା ମଧ୍ୟେ ଦ୍ୱୌ ସଂଘୌ ଜାତୌ| ");
INSERT INTO sanori_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","ଯତଃ ସିଦୂକିଲୋକା ଉତ୍ଥାନଂ ସ୍ୱର୍ଗୀଯଦୂତା ଆତ୍ମାନଶ୍ଚ ସର୍ୱ୍ୱେଷାମ୍ ଏତେଷାଂ କମପି ନ ମନ୍ୟନ୍ତେ, କିନ୍ତୁ ଫିରୂଶିନଃ ସର୍ୱ୍ୱମ୍ ଅଙ୍ଗୀକୁର୍ୱ୍ୱନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","ତତଃ ପରସ୍ପରମ୍ ଅତିଶଯକୋଲାହଲେ ସମୁପସ୍ଥିତେ ଫିରୂଶିନାଂ ପକ୍ଷୀଯାଃ ସଭାସ୍ଥା ଅଧ୍ୟାପକାଃ ପ୍ରତିପକ୍ଷା ଉତ୍ତିଷ୍ଠନ୍ତୋ ଽକଥଯନ୍, ଏତସ୍ୟ ମାନୱସ୍ୟ କମପି ଦୋଷଂ ନ ପଶ୍ୟାମଃ; ଯଦି କଶ୍ଚିଦ୍ ଆତ୍ମା ୱା କଶ୍ଚିଦ୍ ଦୂତ ଏନଂ ପ୍ରତ୍ୟାଦିଶତ୍ ତର୍ହି ୱଯମ୍ ଈଶ୍ୱରସ୍ୟ ପ୍ରାତିକୂଲ୍ୟେନ ନ ଯୋତ୍ସ୍ୟାମଃ| ");
INSERT INTO sanori_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","ତସ୍ମାଦ୍ ଅତୀୱ ଭିନ୍ନୱାକ୍ୟତ୍ୱେ ସତି ତେ ପୌଲଂ ଖଣ୍ଡଂ ଖଣ୍ଡଂ କରିଷ୍ୟନ୍ତୀତ୍ୟାଶଙ୍କଯା ସହସ୍ରସେନାପତିଃ ସେନାଗଣଂ ତତ୍ସ୍ଥାନଂ ଯାତୁଂ ସଭାତୋ ବଲାତ୍ ପୌଲଂ ଧୃତ୍ୱା ଦୁର୍ଗଂ ନେତଞ୍ଚାଜ୍ଞାପଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","ରାତ୍ରୋ ପ୍ରଭୁସ୍ତସ୍ୟ ସମୀପେ ତିଷ୍ଠନ୍ କଥିତୱାନ୍ ହେ ପୌଲ ନିର୍ଭଯୋ ଭୱ ଯଥା ଯିରୂଶାଲମ୍ନଗରେ ମଯି ସାକ୍ଷ୍ୟଂ ଦତ୍ତୱାନ୍ ତଥା ରୋମାନଗରେପି ତ୍ୱଯା ଦାତୱ୍ୟମ୍| ");
INSERT INTO sanori_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","ଦିନେ ସମୁପସ୍ଥିତେ ସତି କିଯନ୍ତୋ ଯିହୂଦୀଯଲୋକା ଏକମନ୍ତ୍ରଣାଃ ସନ୍ତଃ ପୌଲଂ ନ ହତ୍ୱା ଭୋଜନପାନେ କରିଷ୍ୟାମ ଇତି ଶପଥେନ ସ୍ୱାନ୍ ଅବଧ୍ନନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","ଚତ୍ୱାରିଂଶଜ୍ଜନେଭ୍ୟୋଽଧିକା ଲୋକା ଇତି ପଣମ୍ ଅକୁର୍ୱ୍ୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","ତେ ମହାଯାଜକାନାଂ ପ୍ରାଚୀନଲୋକାନାଞ୍ଚ ସମୀପଂ ଗତ୍ୱା କଥଯନ୍, ୱଯଂ ପୌଲଂ ନ ହତ୍ୱା କିମପି ନ ଭୋକ୍ଷ୍ୟାମହେ ଦୃଢେନାନେନ ଶପଥେନ ବଦ୍ଧ୍ୱା ଅଭୱାମ| ");
INSERT INTO sanori_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","ଅତଏୱ ସାମ୍ପ୍ରତଂ ସଭାସଦ୍ଲୋକୈଃ ସହ ୱଯଂ ତସ୍ମିନ୍ କଞ୍ଚିଦ୍ ୱିଶେଷୱିଚାରଂ କରିଷ୍ୟାମସ୍ତଦର୍ଥଂ ଭୱାନ୍ ଶ୍ୱୋ ଽସ୍ମାକଂ ସମୀପଂ ତମ୍ ଆନଯତ୍ୱିତି ସହସ୍ରସେନାପତଯେ ନିୱେଦନଂ କୁରୁତ ତେନ ଯୁଷ୍ମାକଂ ସମୀପଂ ଉପସ୍ଥିତେଃ ପୂର୍ୱ୍ୱଂ ୱଯଂ ତଂ ହନ୍ତୁ ସଜ୍ଜିଷ୍ୟାମ| ");
INSERT INTO sanori_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","ତଦା ପୌଲସ୍ୟ ଭାଗିନେଯସ୍ତେଷାମିତି ମନ୍ତ୍ରଣାଂ ୱିଜ୍ଞାଯ ଦୁର୍ଗଂ ଗତ୍ୱା ତାଂ ୱାର୍ତ୍ତାଂ ପୌଲମ୍ ଉକ୍ତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","ତସ୍ମାତ୍ ପୌଲ ଏକଂ ଶତସେନାପତିମ୍ ଆହୂଯ ୱାକ୍ୟମିଦମ୍ ଭାଷିତୱାନ୍ ସହସ୍ରସେନାପତେଃ ସମୀପେଽସ୍ୟ ଯୁୱମନୁଷ୍ୟସ୍ୟ କିଞ୍ଚିନ୍ନିୱେଦନମ୍ ଆସ୍ତେ, ତସ୍ମାତ୍ ତତ୍ସୱିଧମ୍ ଏନଂ ନଯ| ");
INSERT INTO sanori_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","ତତଃ ସ ତମାଦାଯ ସହସ୍ରସେନାପତେଃ ସମୀପମ୍ ଉପସ୍ଥାଯ କଥିତୱାନ୍, ଭୱତଃ ସମୀପେଽସ୍ୟ କିମପି ନିୱେଦନମାସ୍ତେ ତସ୍ମାତ୍ ବନ୍ଦିଃ ପୌଲୋ ମାମାହୂଯ ଭୱତଃ ସମୀପମ୍ ଏନମ୍ ଆନେତୁଂ ପ୍ରାର୍ଥିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","ତଦା ସହସ୍ରସେନାପତିସ୍ତସ୍ୟ ହସ୍ତଂ ଧୃତ୍ୱା ନିର୍ଜନସ୍ଥାନଂ ନୀତ୍ୱା ପୃଷ୍ଠୱାନ୍ ତୱ କିଂ ନିୱେଦନଂ? ତତ୍ କଥଯ| ");
INSERT INTO sanori_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","ତତଃ ସୋକଥଯତ୍, ଯିହୂଦୀଯଲାକାଃ ପୌଲେ କମପି ୱିଶେଷୱିଚାରଂ ଛଲଂ କୃତ୍ୱା ତଂ ସଭାଂ ନେତୁଂ ଭୱତଃ ସମୀପେ ନିୱେଦଯିତୁଂ ଅମନ୍ତ୍ରଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","କିନ୍ତୁ ମୱତା ତନ୍ନ ସ୍ୱୀକର୍ତ୍ତୱ୍ୟଂ ଯତସ୍ତେଷାଂ ମଧ୍ୟେୱର୍ତ୍ତିନଶ୍ଚତ୍ୱାରିଂଶଜ୍ଜନେଭ୍ୟୋ ଽଧିକଲୋକା ଏକମନ୍ତ୍ରଣା ଭୂତ୍ୱା ପୌଲଂ ନ ହତ୍ୱା ଭୋଜନଂ ପାନଞ୍ଚ ନ କରିଷ୍ୟାମ ଇତି ଶପଥେନ ବଦ୍ଧାଃ ସନ୍ତୋ ଘାତକା ଇୱ ସଜ୍ଜିତା ଇଦାନୀଂ କେୱଲଂ ଭୱତୋ ଽନୁମତିମ୍ ଅପେକ୍ଷନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","ଯାମିମାଂ କଥାଂ ତ୍ୱଂ ନିୱେଦିତୱାନ୍ ତାଂ କସ୍ମୈଚିଦପି ମା କଥଯେତ୍ୟୁକ୍ତ୍ୱା ସହସ୍ରସେନାପତିସ୍ତଂ ଯୁୱାନଂ ୱିସୃଷ୍ଟୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","ଅନନ୍ତରଂ ସହସ୍ରସେନାପତି ର୍ଦ୍ୱୌ ଶତସେନାପତୀ ଆହୂଯେଦମ୍ ଆଦିଶତ୍, ଯୁୱାଂ ରାତ୍ରୌ ପ୍ରହରୈକାୱଶିଷ୍ଟାଯାଂ ସତ୍ୟାଂ କୈସରିଯାନଗରଂ ଯାତୁଂ ପଦାତିସୈନ୍ୟାନାଂ ଦ୍ୱେ ଶତେ ଘୋଟକାରୋହିସୈନ୍ୟାନାଂ ସପ୍ତତିଂ ଶକ୍ତିଧାରିସୈନ୍ୟାନାଂ ଦ୍ୱେ ଶତେ ଚ ଜନାନ୍ ସଜ୍ଜିତାନ୍ କୁରୁତଂ| ");
INSERT INTO sanori_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","ପୌଲମ୍ ଆରୋହଯିତୁଂ ଫୀଲିକ୍ଷାଧିପତେଃ ସମୀପଂ ନିର୍ୱ୍ୱିଘ୍ନଂ ନେତୁଞ୍ଚ ୱାହନାନି ସମୁପସ୍ଥାପଯତଂ| ");
INSERT INTO sanori_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","ଅପରଂ ସ ପତ୍ରଂ ଲିଖିତ୍ୱା ଦତ୍ତୱାନ୍ ତଲ୍ଲିଖିତମେତତ୍, ");
INSERT INTO sanori_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","ମହାମହିମଶ୍ରୀଯୁକ୍ତଫୀଲିକ୍ଷାଧିପତଯେ କ୍ଲୌଦିଯଲୁଷିଯସ୍ୟ ନମସ୍କାରଃ| ");
INSERT INTO sanori_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","ଯିହୂଦୀଯଲୋକାଃ ପୂର୍ୱ୍ୱମ୍ ଏନଂ ମାନୱଂ ଧୃତ୍ୱା ସ୍ୱହସ୍ତୈ ର୍ହନ୍ତୁମ୍ ଉଦ୍ୟତା ଏତସ୍ମିନ୍ନନ୍ତରେ ସସୈନ୍ୟୋହଂ ତତ୍ରୋପସ୍ଥାଯ ଏଷ ଜନୋ ରୋମୀଯ ଇତି ୱିଜ୍ଞାଯ ତଂ ରକ୍ଷିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","କିନ୍ନିମିତ୍ତଂ ତେ ତମପୱଦନ୍ତେ ତଜ୍ଜ୍ଞାତୁଂ ତେଷା ସଭାଂ ତମାନାଯିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","ତତସ୍ତେଷାଂ ୱ୍ୟୱସ୍ଥାଯା ୱିରୁଦ୍ଧଯା କଯାଚନ କଥଯା ସୋଽପୱାଦିତୋଽଭୱତ୍, କିନ୍ତୁ ସ ଶୃଙ୍ଖଲବନ୍ଧନାର୍ହୋ ୱା ପ୍ରାଣନାଶାର୍ହୋ ଭୱତୀଦୃଶଃ କୋପ୍ୟପରାଧୋ ମଯାସ୍ୟ ନ ଦୃଷ୍ଟଃ| ");
INSERT INTO sanori_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","ତଥାପି ମନୁଷ୍ୟସ୍ୟାସ୍ୟ ୱଧାର୍ଥଂ ଯିହୂଦୀଯା ଘାତକାଇୱ ସଜ୍ଜିତା ଏତାଂ ୱାର୍ତ୍ତାଂ ଶ୍ରୁତ୍ୱା ତତ୍କ୍ଷଣାତ୍ ତୱ ସମୀପମେନଂ ପ୍ରେଷିତୱାନ୍ ଅସ୍ୟାପୱାଦକାଂଶ୍ଚ ତୱ ସମୀପଂ ଗତ୍ୱାପୱଦିତୁମ୍ ଆଜ୍ଞାପଯମ୍| ଭୱତଃ କୁଶଲଂ ଭୂଯାତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","ସୈନ୍ୟଗଣ ଆଜ୍ଞାନୁସାରେଣ ପୌଲଂ ଗୃହୀତ୍ୱା ତସ୍ୟାଂ ରଜନ୍ୟାମ୍ ଆନ୍ତିପାତ୍ରିନଗରମ୍ ଆନଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","ପରେଽହନି ତେନ ସହ ଯାତୁଂ ଘୋଟକାରୂଢସୈନ୍ୟଗଣଂ ସ୍ଥାପଯିତ୍ୱା ପରାୱୃତ୍ୟ ଦୁର୍ଗଂ ଗତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","ତତଃ ପରେ ଘୋଟକାରୋହିସୈନ୍ୟଗଣଃ କୈସରିଯାନଗରମ୍ ଉପସ୍ଥାଯ ତତ୍ପତ୍ରମ୍ ଅଧିପତେଃ କରେ ସମର୍ପ୍ୟ ତସ୍ୟ ସମୀପେ ପୌଲମ୍ ଉପସ୍ଥାପିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","ତଦାଧିପତିସ୍ତତ୍ପତ୍ରଂ ପଠିତ୍ୱା ପୃଷ୍ଠୱାନ୍ ଏଷ କିମ୍ପ୍ରଦେଶୀଯୋ ଜନଃ? ସ କିଲିକିଯାପ୍ରଦେଶୀଯ ଏକୋ ଜନ ଇତି ଜ୍ଞାତ୍ୱା କଥିତୱାନ୍, ");
INSERT INTO sanori_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ତୱାପୱାଦକଗଣ ଆଗତେ ତୱ କଥାଂ ଶ୍ରୋଷ୍ୟାମି| ହେରୋଦ୍ରାଜଗୃହେ ତଂ ସ୍ଥାପଯିତୁମ୍ ଆଦିଷ୍ଟୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","ପଞ୍ଚଭ୍ୟୋ ଦିନେଭ୍ୟଃ ପରଂ ହନାନୀଯନାମା ମହାଯାଜକୋଽଧିପତେଃ ସମକ୍ଷଂ ପୌଲସ୍ୟ ପ୍ରାତିକୂଲ୍ୟେନ ନିୱେଦଯିତୁଂ ତର୍ତୁଲ୍ଲନାମାନଂ କଞ୍ଚନ ୱକ୍ତାରଂ ପ୍ରାଚୀନଜନାଂଶ୍ଚ ସଙ୍ଗିନଃ କୃତ୍ୱା କୈସରିଯାନଗରମ୍ ଆଗଚ୍ଛତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","ତତଃ ପୌଲେ ସମାନୀତେ ସତି ତର୍ତୁଲ୍ଲସ୍ତସ୍ୟାପୱାଦକଥାଂ କଥଯିତୁମ୍ ଆରଭତ ହେ ମହାମହିମଫୀଲିକ୍ଷ ଭୱତୋ ୱଯମ୍ ଅତିନିର୍ୱ୍ୱିଘ୍ନଂ କାଲଂ ଯାପଯାମୋ ଭୱତଃ ପରିଣାମଦର୍ଶିତଯା ଏତଦ୍ଦେଶୀଯାନାଂ ବହୂନି ମଙ୍ଗଲାନି ଘଟିତାନି, ");
INSERT INTO sanori_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","ଇତି ହେତୋ ର୍ୱଯମତିକୃତଜ୍ଞାଃ ସନ୍ତଃ ସର୍ୱ୍ୱତ୍ର ସର୍ୱ୍ୱଦା ଭୱତୋ ଗୁଣାନ୍ ଗାଯମଃ| ");
INSERT INTO sanori_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","କିନ୍ତୁ ବହୁଭିଃ କଥାଭି ର୍ଭୱନ୍ତଂ ଯେନ ନ ୱିରଞ୍ଜଯାମି ତସ୍ମାଦ୍ ୱିନଯେ ଭୱାନ୍ ବନୁକମ୍ପ୍ୟ ମଦଲ୍ପକଥାଂ ଶୃଣୋତୁ| ");
INSERT INTO sanori_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","ଏଷ ମହାମାରୀସ୍ୱରୂପୋ ନାସରତୀଯମତଗ୍ରାହିସଂଘାତସ୍ୟ ମୁଖ୍ୟୋ ଭୂତ୍ୱା ସର୍ୱ୍ୱଦେଶେଷୁ ସର୍ୱ୍ୱେଷାଂ ଯିହୂଦୀଯାନାଂ ରାଜଦ୍ରୋହାଚରଣପ୍ରୱୃତ୍ତିଂ ଜନଯତୀତ୍ୟସ୍ମାଭି ର୍ନିଶ୍ଚିତଂ| ");
INSERT INTO sanori_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","ସ ମନ୍ଦିରମପି ଅଶୁଚି କର୍ତ୍ତୁଂ ଚେଷ୍ଟିତୱାନ୍; ଇତି କାରଣାଦ୍ ୱଯମ୍ ଏନଂ ଧୃତ୍ୱା ସ୍ୱୱ୍ୟୱସ୍ଥାନୁସାରେଣ ୱିଚାରଯିତୁଂ ପ୍ରାୱର୍ତ୍ତାମହି; ");
INSERT INTO sanori_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","କିନ୍ତୁ ଲୁଷିଯଃ ସହସ୍ରସେନାପତିରାଗତ୍ୟ ବଲାଦ୍ ଅସ୍ମାକଂ କରେଭ୍ୟ ଏନଂ ଗୃହୀତ୍ୱା ");
INSERT INTO sanori_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ଏତସ୍ୟାପୱାଦକାନ୍ ଭୱତଃ ସମୀପମ୍ ଆଗନ୍ତୁମ୍ ଆଜ୍ଞାପଯତ୍| ୱଯଂ ଯସ୍ମିନ୍ ତମପୱାଦାମୋ ଭୱତା ପଦପୱାଦକଥାଯାଂ ୱିଚାରିତାଯାଂ ସତ୍ୟାଂ ସର୍ୱ୍ୱଂ ୱୃତ୍ତାନ୍ତଂ ୱେଦିତୁଂ ଶକ୍ଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","ତତୋ ଯିହୂଦୀଯା ଅପି ସ୍ୱୀକୃତ୍ୟ କଥିତୱନ୍ତ ଏଷା କଥା ପ୍ରମାଣମ୍| ");
INSERT INTO sanori_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","ଅଧିପତୌ କଥାଂ କଥଯିତୁଂ ପୌଲଂ ପ୍ରତୀଙ୍ଗିତଂ କୃତୱତି ସ କଥିତୱାନ୍ ଭୱାନ୍ ବହୂନ୍ ୱତ୍ସରାନ୍ ଯାୱଦ୍ ଏତଦ୍ଦେଶସ୍ୟ ଶାସନଂ କରୋତୀତି ୱିଜ୍ଞାଯ ପ୍ରତ୍ୟୁତ୍ତରଂ ଦାତୁମ୍ ଅକ୍ଷୋଭୋଽଭୱମ୍| ");
INSERT INTO sanori_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","ଅଦ୍ୟ କେୱଲଂ ଦ୍ୱାଦଶ ଦିନାନି ଯାତାନି, ଅହମ୍ ଆରାଧନାଂ କର୍ତ୍ତୁଂ ଯିରୂଶାଲମନଗରଂ ଗତୱାନ୍ ଏଷା କଥା ଭୱତା ଜ୍ଞାତୁଂ ଶକ୍ୟତେ; ");
INSERT INTO sanori_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","କିନ୍ତ୍ୱିଭେ ମାଂ ମଧ୍ୟେମନ୍ଦିରଂ କେନାପି ସହ ୱିତଣ୍ଡାଂ କୁର୍ୱ୍ୱନ୍ତଂ କୁତ୍ରାପି ଭଜନଭୱନେ ନଗରେ ୱା ଲୋକାନ୍ କୁପ୍ରୱୃତ୍ତିଂ ଜନଯନ୍ତୁଂ ନ ଦୃଷ୍ଟୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","ଇଦାନୀଂ ଯସ୍ମିନ୍ ଯସ୍ମିନ୍ ମାମ୍ ଅପୱଦନ୍ତେ ତସ୍ୟ କିମପି ପ୍ରମାଣଂ ଦାତୁଂ ନ ଶକ୍ନୁୱନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","କିନ୍ତୁ ଭୱିଷ୍ୟଦ୍ୱାକ୍ୟଗ୍ରନ୍ଥେ ୱ୍ୟୱସ୍ଥାଗ୍ରନ୍ଥେ ଚ ଯା ଯା କଥା ଲିଖିତାସ୍ତେ ତାସୁ ସର୍ୱ୍ୱାସୁ ୱିଶ୍ୱସ୍ୟ ଯନ୍ମତମ୍ ଇମେ ୱିଧର୍ମ୍ମଂ ଜାନନ୍ତି ତନ୍ମତାନୁସାରେଣାହଂ ନିଜପିତୃପୁରୁଷାଣାମ୍ ଈଶ୍ୱରମ୍ ଆରାଧଯାମୀତ୍ୟହଂ ଭୱତଃ ସମକ୍ଷମ୍ ଅଙ୍ଗୀକରୋମି| ");
INSERT INTO sanori_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","ଧାର୍ମ୍ମିକାଣାମ୍ ଅଧାର୍ମ୍ମିକାଣାଞ୍ଚ ପ୍ରମୀତଲୋକାନାମେୱୋତ୍ଥାନଂ ଭୱିଷ୍ୟତୀତି କଥାମିମେ ସ୍ୱୀକୁର୍ୱ୍ୱନ୍ତି ତଥାହମପି ତସ୍ମିନ୍ ଈଶ୍ୱରେ ପ୍ରତ୍ୟାଶାଂ କରୋମି; ");
INSERT INTO sanori_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","ଈଶ୍ୱରସ୍ୟ ମାନୱାନାଞ୍ଚ ସମୀପେ ଯଥା ନିର୍ଦୋଷୋ ଭୱାମି ତଦର୍ଥଂ ସତତଂ ଯତ୍ନୱାନ୍ ଅସ୍ମି| ");
INSERT INTO sanori_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","ବହୁଷୁ ୱତ୍ସରେଷୁ ଗତେଷୁ ସ୍ୱଦେଶୀଯଲୋକାନାଂ ନିମିତ୍ତଂ ଦାନୀଯଦ୍ରୱ୍ୟାଣି ନୈୱେଦ୍ୟାନି ଚ ସମାଦାଯ ପୁନରାଗମନଂ କୃତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","ତତୋହଂ ଶୁଚି ର୍ଭୂତ୍ୱା ଲୋକାନାଂ ସମାଗମଂ କଲହଂ ୱା ନ କାରିତୱାନ୍ ତଥାପ୍ୟାଶିଯାଦେଶୀଯାଃ କିଯନ୍ତୋ ଯିହୁଦୀଯଲୋକା ମଧ୍ୟେମନ୍ଦିରଂ ମାଂ ଧୃତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","ମମୋପରି ଯଦି କାଚିଦପୱାଦକଥାସ୍ତି ତର୍ହି ଭୱତଃ ସମୀପମ୍ ଉପସ୍ଥାଯ ତେଷାମେୱ ସାକ୍ଷ୍ୟଦାନମ୍ ଉଚିତମ୍| ");
INSERT INTO sanori_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","ନୋଚେତ୍ ପୂର୍ୱ୍ୱେ ମହାସଭାସ୍ଥାନାଂ ଲୋକାନାଂ ସନ୍ନିଧୌ ମମ ଦଣ୍ଡାଯମାନତ୍ୱସମଯେ, ଅହମଦ୍ୟ ମୃତାନାମୁତ୍ଥାନେ ଯୁଷ୍ମାଭି ର୍ୱିଚାରିତୋସ୍ମି, ");
INSERT INTO sanori_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","ତେଷାଂ ମଧ୍ୟେ ତିଷ୍ଠନ୍ନହଂ ଯାମିମାଂ କଥାମୁଚ୍ଚୈଃ ସ୍ୱରେଣ କଥିତୱାନ୍ ତଦନ୍ୟୋ ମମ କୋପି ଦୋଷୋଽଲଭ୍ୟତ ନ ୱେତି ୱରମ୍ ଏତେ ସମୁପସ୍ଥିତଲୋକା ୱଦନ୍ତୁ| ");
INSERT INTO sanori_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","ତଦା ଫୀଲିକ୍ଷ ଏତାଂ କଥାଂ ଶ୍ରୁତ୍ୱା ତନ୍ମତସ୍ୟ ୱିଶେଷୱୃତ୍ତାନ୍ତଂ ୱିଜ୍ଞାତୁଂ ୱିଚାରଂ ସ୍ଥଗିତଂ କୃତ୍ୱା କଥିତୱାନ୍ ଲୁଷିଯେ ସହସ୍ରସେନାପତୌ ସମାଯାତେ ସତି ଯୁଷ୍ମାକଂ ୱିଚାରମ୍ ଅହଂ ନିଷ୍ପାଦଯିଷ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","ଅନନ୍ତରଂ ବନ୍ଧନଂ ୱିନା ପୌଲଂ ରକ୍ଷିତୁଂ ତସ୍ୟ ସେୱନାଯ ସାକ୍ଷାତ୍କରଣାଯ ୱା ତଦୀଯାତ୍ମୀଯବନ୍ଧୁଜନାନ୍ ନ ୱାରଯିତୁଞ୍ଚ ଶମସେନାପତିମ୍ ଆଦିଷ୍ଟୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","ଅଲ୍ପଦିନାତ୍ ପରଂ ଫୀଲିକ୍ଷୋଽଧିପତି ର୍ଦ୍ରୁଷିଲ୍ଲାନାମ୍ନା ଯିହୂଦୀଯଯା ସ୍ୱଭାର୍ୟ୍ୟଯା ସହାଗତ୍ୟ ପୌଲମାହୂଯ ତସ୍ୟ ମୁଖାତ୍ ଖ୍ରୀଷ୍ଟଧର୍ମ୍ମସ୍ୟ ୱୃତ୍ତାନ୍ତମ୍ ଅଶ୍ରୌଷୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","ପୌଲେନ ନ୍ୟାଯସ୍ୟ ପରିମିତଭୋଗସ୍ୟ ଚରମୱିଚାରସ୍ୟ ଚ କଥାଯାଂ କଥିତାଯାଂ ସତ୍ୟାଂ ଫୀଲିକ୍ଷଃ କମ୍ପମାନଃ ସନ୍ ୱ୍ୟାହରଦ୍ ଇଦାନୀଂ ଯାହି, ଅହମ୍ ଅୱକାଶଂ ପ୍ରାପ୍ୟ ତ୍ୱାମ୍ ଆହୂସ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","ମୁକ୍ତିପ୍ରପ୍ତ୍ୟର୍ଥଂ ପୌଲେନ ମହ୍ୟଂ ମୁଦ୍ରାଦାସ୍ୟନ୍ତେ ଇତି ପତ୍ୟାଶାଂ କୃତ୍ୱା ସ ପୁନଃ ପୁନସ୍ତମାହୂଯ ତେନ ସାକଂ କଥୋପକଥନଂ କୃତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","କିନ୍ତୁ ୱତ୍ସରଦ୍ୱଯାତ୍ ପରଂ ପର୍କିଯଫୀଷ୍ଟ ଫାଲିକ୍ଷସ୍ୟ ପଦଂ ପ୍ରାପ୍ତେ ସତି ଫୀଲିକ୍ଷୋ ଯିହୂଦୀଯାନ୍ ସନ୍ତୁଷ୍ଟାନ୍ ଚିକୀର୍ଷନ୍ ପୌଲଂ ବଦ୍ଧଂ ସଂସ୍ଥାପ୍ୟ ଗତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","ଅନନ୍ତରଂ ଫୀଷ୍ଟୋ ନିଜରାଜ୍ୟମ୍ ଆଗତ୍ୟ ଦିନତ୍ରଯାତ୍ ପରଂ କୈସରିଯାତୋ ଯିରୂଶାଲମ୍ନଗରମ୍ ଆଗମତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","ତଦା ମହାଯାଜକୋ ଯିହୂଦୀଯାନାଂ ପ୍ରଧାନଲୋକାଶ୍ଚ ତସ୍ୟ ସମକ୍ଷଂ ପୌଲମ୍ ଅପାୱଦନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ଭୱାନ୍ ତଂ ଯିରୂଶାଲମମ୍ ଆନେତୁମ୍ ଆଜ୍ଞାପଯତ୍ୱିତି ୱିନୀଯ ତେ ତସ୍ମାଦ୍ ଅନୁଗ୍ରହଂ ୱାଞ୍ଛିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","ଯତଃ ପଥିମଧ୍ୟେ ଗୋପନେନ ପୌଲଂ ହନ୍ତୁଂ ତୈ ର୍ଘାତକା ନିଯୁକ୍ତାଃ| ଫୀଷ୍ଟ ଉତ୍ତରଂ ଦତ୍ତୱାନ୍ ପୌଲଃ କୈସରିଯାଯାଂ ସ୍ଥାସ୍ୟତି ପୁନରଲ୍ପଦିନାତ୍ ପରମ୍ ଅହଂ ତତ୍ର ଯାସ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","ତତସ୍ତସ୍ୟ ମାନୁଷସ୍ୟ ଯଦି କଶ୍ଚିଦ୍ ଅପରାଧସ୍ତିଷ୍ଠତି ତର୍ହି ଯୁଷ୍ମାକଂ ଯେ ଶକ୍ନୁୱନ୍ତି ତେ ମଯା ସହ ତତ୍ର ଗତ୍ୱା ତମପୱଦନ୍ତୁ ସ ଏତାଂ କଥାଂ କଥିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","ଦଶଦିୱସେଭ୍ୟୋଽଧିକଂ ୱିଲମ୍ବ୍ୟ ଫୀଷ୍ଟସ୍ତସ୍ମାତ୍ କୈସରିଯାନଗରଂ ଗତ୍ୱା ପରସ୍ମିନ୍ ଦିୱସେ ୱିଚାରାସନ ଉପଦିଶ୍ୟ ପୌଲମ୍ ଆନେତୁମ୍ ଆଜ୍ଞାପଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","ପୌଲେ ସମୁପସ୍ଥିତେ ସତି ଯିରୂଶାଲମ୍ନଗରାଦ୍ ଆଗତା ଯିହୂଦୀଯଲୋକାସ୍ତଂ ଚତୁର୍ଦିଶି ସଂୱେଷ୍ଟ୍ୟ ତସ୍ୟ ୱିରୁଦ୍ଧଂ ବହୂନ୍ ମହାଦୋଷାନ୍ ଉତ୍ଥାପିତୱନ୍ତଃ କିନ୍ତୁ ତେଷାଂ କିମପି ପ୍ରମାଣଂ ଦାତୁଂ ନ ଶକ୍ନୁୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","ତତଃ ପୌଲଃ ସ୍ୱସ୍ମିନ୍ ଉତ୍ତରମିଦମ୍ ଉଦିତୱାନ୍, ଯିହୂଦୀଯାନାଂ ୱ୍ୟୱସ୍ଥାଯା ମନ୍ଦିରସ୍ୟ କୈସରସ୍ୟ ୱା ପ୍ରତିକୂଲଂ କିମପି କର୍ମ୍ମ ନାହଂ କୃତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","କିନ୍ତୁ ଫୀଷ୍ଟୋ ଯିହୂଦୀଯାନ୍ ସନ୍ତୁଷ୍ଟାନ୍ କର୍ତ୍ତୁମ୍ ଅଭିଲଷନ୍ ପୌଲମ୍ ଅଭାଷତ ତ୍ୱଂ କିଂ ଯିରୂଶାଲମଂ ଗତ୍ୱାସ୍ମିନ୍ ଅଭିଯୋଗେ ମମ ସାକ୍ଷାଦ୍ ୱିଚାରିତୋ ଭୱିଷ୍ୟସି? ");
INSERT INTO sanori_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","ତତଃ ପୌଲ ଉତ୍ତରଂ ପ୍ରୋକ୍ତୱାନ୍, ଯତ୍ର ମମ ୱିଚାରୋ ଭୱିତୁଂ ଯୋଗ୍ୟଃ କୈସରସ୍ୟ ତତ୍ର ୱିଚାରାସନ ଏୱ ସମୁପସ୍ଥିତୋସ୍ମି; ଅହଂ ଯିହୂଦୀଯାନାଂ କାମପି ହାନିଂ ନାକାର୍ଷମ୍ ଇତି ଭୱାନ୍ ଯଥାର୍ଥତୋ ୱିଜାନାତି| ");
INSERT INTO sanori_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","କଞ୍ଚିଦପରାଧଂ କିଞ୍ଚନ ୱଧାର୍ହଂ କର୍ମ୍ମ ୱା ଯଦ୍ୟହମ୍ ଅକରିଷ୍ୟଂ ତର୍ହି ପ୍ରାଣହନନଦଣ୍ଡମପି ଭୋକ୍ତୁମ୍ ଉଦ୍ୟତୋଽଭୱିଷ୍ୟଂ, କିନ୍ତୁ ତେ ମମ ସମପୱାଦଂ କୁର୍ୱ୍ୱନ୍ତି ସ ଯଦି କଲ୍ପିତମାତ୍ରୋ ଭୱତି ତର୍ହି ତେଷାଂ କରେଷୁ ମାଂ ସମର୍ପଯିତୁଂ କସ୍ୟାପ୍ୟଧିକାରୋ ନାସ୍ତି, କୈସରସ୍ୟ ନିକଟେ ମମ ୱିଚାରୋ ଭୱତୁ| ");
INSERT INTO sanori_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","ତଦା ଫୀଷ୍ଟୋ ମନ୍ତ୍ରିଭିଃ ସାର୍ଦ୍ଧଂ ସଂମନ୍ତ୍ର୍ୟ ପୌଲାଯ କଥିତୱାନ୍, କୈସରସ୍ୟ ନିକଟେ କିଂ ତୱ ୱିଚାରୋ ଭୱିଷ୍ୟତି? କୈସରସ୍ୟ ସମୀପଂ ଗମିଷ୍ୟସି| ");
INSERT INTO sanori_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","କିଯଦ୍ଦିନେଭ୍ୟଃ ପରମ୍ ଆଗ୍ରିପ୍ପରାଜା ବର୍ଣୀକୀ ଚ ଫୀଷ୍ଟଂ ସାକ୍ଷାତ୍ କର୍ତ୍ତୁଂ କୈସରିଯାନଗରମ୍ ଆଗତୱନ୍ତୌ| ");
INSERT INTO sanori_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","ତଦା ତୌ ବହୁଦିନାନି ତତ୍ର ସ୍ଥିତୌ ତତଃ ଫୀଷ୍ଟସ୍ତଂ ରାଜାନଂ ପୌଲସ୍ୟ କଥାଂ ୱିଜ୍ଞାପ୍ୟ କଥଯିତୁମ୍ ଆରଭତ ପୌଲନାମାନମ୍ ଏକଂ ବନ୍ଦି ଫୀଲିକ୍ଷୋ ବଦ୍ଧଂ ସଂସ୍ଥାପ୍ୟ ଗତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","ଯିରୂଶାଲମି ମମ ସ୍ଥିତିକାଲେ ମହାଯାଜକୋ ଯିହୂଦୀଯାନାଂ ପ୍ରାଚୀନଲୋକାଶ୍ଚ ତମ୍ ଅପୋଦ୍ୟ ତମ୍ପ୍ରତି ଦଣ୍ଡାଜ୍ଞାଂ ପ୍ରାର୍ଥଯନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","ତତୋହମ୍ ଇତ୍ୟୁତ୍ତରମ୍ ଅୱଦଂ ଯାୱଦ୍ ଅପୋଦିତୋ ଜନଃ ସ୍ୱାପୱାଦକାନ୍ ସାକ୍ଷାତ୍ କୃତ୍ୱା ସ୍ୱସ୍ମିନ୍ ଯୋଽପରାଧ ଆରୋପିତସ୍ତସ୍ୟ ପ୍ରତ୍ୟୁତ୍ତରଂ ଦାତୁଂ ସୁଯୋଗଂ ନ ପ୍ରାପ୍ନୋତି, ତାୱତ୍କାଲଂ କସ୍ୟାପି ମାନୁଷସ୍ୟ ପ୍ରାଣନାଶାଜ୍ଞାପନଂ ରୋମିଲୋକାନାଂ ରୀତି ର୍ନହି| ");
INSERT INTO sanori_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","ତତସ୍ତେଷ୍ୱତ୍ରାଗତେଷୁ ପରସ୍ମିନ୍ ଦିୱସେଽହମ୍ ଅୱିଲମ୍ବଂ ୱିଚାରାସନ ଉପୱିଶ୍ୟ ତଂ ମାନୁଷମ୍ ଆନେତୁମ୍ ଆଜ୍ଞାପଯମ୍| ");
INSERT INTO sanori_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","ତଦନନ୍ତରଂ ତସ୍ୟାପୱାଦକା ଉପସ୍ଥାଯ ଯାଦୃଶମ୍ ଅହଂ ଚିନ୍ତିତୱାନ୍ ତାଦୃଶଂ କଞ୍ଚନ ମହାପୱାଦଂ ନୋତ୍ଥାପ୍ୟ ");
INSERT INTO sanori_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","ସ୍ୱେଷାଂ ମତେ ତଥା ପୌଲୋ ଯଂ ସଜୀୱଂ ୱଦତି ତସ୍ମିନ୍ ଯୀଶୁନାମନି ମୃତଜନେ ଚ ତସ୍ୟ ୱିରୁଦ୍ଧଂ କଥିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","ତତୋହଂ ତାଦୃଗ୍ୱିଚାରେ ସଂଶଯାନଃ ସନ୍ କଥିତୱାନ୍ ତ୍ୱଂ ଯିରୂଶାଲମଂ ଗତ୍ୱା କିଂ ତତ୍ର ୱିଚାରିତୋ ଭୱିତୁମ୍ ଇଚ୍ଛସି? ");
INSERT INTO sanori_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","ତଦା ପୌଲୋ ମହାରାଜସ୍ୟ ନିକଟେ ୱିଚାରିତୋ ଭୱିତୁଂ ପ୍ରାର୍ଥଯତ, ତସ୍ମାଦ୍ ଯାୱତ୍କାଲଂ ତଂ କୈସରସ୍ୟ ସମୀପଂ ପ୍ରେଷଯିତୁଂ ନ ଶକ୍ନୋମି ତାୱତ୍କାଲଂ ତମତ୍ର ସ୍ଥାପଯିତୁମ୍ ଆଦିଷ୍ଟୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","ତତ ଆଗ୍ରିପ୍ପଃ ଫୀଷ୍ଟମ୍ ଉକ୍ତୱାନ୍, ଅହମପି ତସ୍ୟ ମାନୁଷସ୍ୟ କଥାଂ ଶ୍ରୋତୁମ୍ ଅଭିଲଷାମି| ତଦା ଫୀଷ୍ଟୋ ୱ୍ୟାହରତ୍ ଶ୍ୱସ୍ତଦୀଯାଂ କଥାଂ ତ୍ୱଂ ଶ୍ରୋଷ୍ୟସି| ");
INSERT INTO sanori_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","ପରସ୍ମିନ୍ ଦିୱସେ ଆଗ୍ରିପ୍ପୋ ବର୍ଣୀକୀ ଚ ମହାସମାଗମଂ କୃତ୍ୱା ପ୍ରଧାନୱାହିନୀପତିଭି ର୍ନଗରସ୍ଥପ୍ରଧାନଲୋକୈଶ୍ଚ ସହ ମିଲିତ୍ୱା ରାଜଗୃହମାଗତ୍ୟ ସମୁପସ୍ଥିତୌ ତଦା ଫୀଷ୍ଟସ୍ୟାଜ୍ଞଯା ପୌଲ ଆନୀତୋଽଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","ତଦା ଫୀଷ୍ଟଃ କଥିତୱାନ୍ ହେ ରାଜନ୍ ଆଗ୍ରିପ୍ପ ହେ ଉପସ୍ଥିତାଃ ସର୍ୱ୍ୱେ ଲୋକା ଯିରୂଶାଲମ୍ନଗରେ ଯିହୂଦୀଯଲୋକସମୂହୋ ଯସ୍ମିନ୍ ମାନୁଷେ ମମ ସମୀପେ ନିୱେଦନଂ କୃତ୍ୱା ପ୍ରୋଚ୍ଚୈଃ କଥାମିମାଂ କଥିତୱାନ୍ ପୁନରଲ୍ପକାଲମପି ତସ୍ୟ ଜୀୱନଂ ନୋଚିତଂ ତମେତଂ ମାନୁଷଂ ପଶ୍ୟତ| ");
INSERT INTO sanori_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","କିନ୍ତ୍ୱେଷ ଜନଃ ପ୍ରାଣନାଶର୍ହଂ କିମପି କର୍ମ୍ମ ନ କୃତୱାନ୍ ଇତ୍ୟଜାନାଂ ତଥାପି ସ ମହାରାଜସ୍ୟ ସନ୍ନିଧୌ ୱିଚାରିତୋ ଭୱିତୁଂ ପ୍ରାର୍ଥଯତ ତସ୍ମାତ୍ ତସ୍ୟ ସମୀପଂ ତଂ ପ୍ରେଷଯିତୁଂ ମତିମକରୱମ୍| ");
INSERT INTO sanori_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","କିନ୍ତୁ ଶ୍ରୀଯୁକ୍ତସ୍ୟ ସମୀପମ୍ ଏତସ୍ମିନ୍ କିଂ ଲେଖନୀଯମ୍ ଇତ୍ୟସ୍ୟ କସ୍ୟଚିନ୍ ନିର୍ଣଯସ୍ୟ ନ ଜାତତ୍ୱାଦ୍ ଏତସ୍ୟ ୱିଚାରେ ସତି ଯଥାହଂ ଲେଖିତୁଂ କିଞ୍ଚନ ନିଶ୍ଚିତଂ ପ୍ରାପ୍ନୋମି ତଦର୍ଥଂ ଯୁଷ୍ମାକଂ ସମକ୍ଷଂ ୱିଶେଷତୋ ହେ ଆଗ୍ରିପ୍ପରାଜ ଭୱତଃ ସମକ୍ଷମ୍ ଏତମ୍ ଆନଯେ| ");
INSERT INTO sanori_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","ଯତୋ ବନ୍ଦିପ୍ରେଷଣସମଯେ ତସ୍ୟାଭିଯୋଗସ୍ୟ କିଞ୍ଚିଦଲେଖନମ୍ ଅହମ୍ ଅଯୁକ୍ତଂ ଜାନାମି| ");
INSERT INTO sanori_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","ତତ ଆଗ୍ରିପ୍ପଃ ପୌଲମ୍ ଅୱାଦୀତ୍, ନିଜାଂ କଥାଂ କଥଯିତୁଂ ତୁଭ୍ୟମ୍ ଅନୁମତି ର୍ଦୀଯତେ| ତସ୍ମାତ୍ ପୌଲଃ କରଂ ପ୍ରସାର୍ୟ୍ୟ ସ୍ୱସ୍ମିନ୍ ଉତ୍ତରମ୍ ଅୱାଦୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","ହେ ଆଗ୍ରିପ୍ପରାଜ ଯତ୍କାରଣାଦହଂ ଯିହୂଦୀଯୈରପୱାଦିତୋ ଽଭୱଂ ତସ୍ୟ ୱୃତ୍ତାନ୍ତମ୍ ଅଦ୍ୟ ଭୱତଃ ସାକ୍ଷାନ୍ ନିୱେଦଯିତୁମନୁମତୋହମ୍ ଇଦଂ ସ୍ୱୀଯଂ ପରମଂ ଭାଗ୍ୟଂ ମନ୍ୟେ; ");
INSERT INTO sanori_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","ଯତୋ ଯିହୂଦୀଯଲୋକାନାଂ ମଧ୍ୟେ ଯା ଯା ରୀତିଃ ସୂକ୍ଷ୍ମୱିଚାରାଶ୍ଚ ସନ୍ତି ତେଷୁ ଭୱାନ୍ ୱିଜ୍ଞତମଃ; ଅତଏୱ ପ୍ରାର୍ଥଯେ ଧୈର୍ୟ୍ୟମୱଲମ୍ବ୍ୟ ମମ ନିୱେଦନଂ ଶୃଣୋତୁ| ");
INSERT INTO sanori_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","ଅହଂ ଯିରୂଶାଲମ୍ନଗରେ ସ୍ୱଦେଶୀଯଲୋକାନାଂ ମଧ୍ୟେ ତିଷ୍ଠନ୍ ଆ ଯୌୱନକାଲାଦ୍ ଯଦ୍ରୂପମ୍ ଆଚରିତୱାନ୍ ତଦ୍ ଯିହୂଦୀଯଲୋକାଃ ସର୍ୱ୍ୱେ ୱିଦନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","ଅସ୍ମାକଂ ସର୍ୱ୍ୱେଭ୍ୟଃ ଶୁଦ୍ଧତମଂ ଯତ୍ ଫିରୂଶୀଯମତଂ ତଦୱଲମ୍ବୀ ଭୂତ୍ୱାହଂ କାଲଂ ଯାପିତୱାନ୍ ଯେ ଜନା ଆ ବାଲ୍ୟକାଲାନ୍ ମାଂ ଜାନାନ୍ତି ତେ ଏତାଦୃଶଂ ସାକ୍ଷ୍ୟଂ ଯଦି ଦଦାତି ତର୍ହି ଦାତୁଂ ଶକ୍ନୁୱନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","କିନ୍ତୁ ହେ ଆଗ୍ରିପ୍ପରାଜ ଈଶ୍ୱରୋଽସ୍ମାକଂ ପୂର୍ୱ୍ୱପୁରୁଷାଣାଂ ନିକଟେ ଯଦ୍ ଅଙ୍ଗୀକୃତୱାନ୍ ତସ୍ୟ ପ୍ରତ୍ୟାଶାହେତୋରହମ୍ ଇଦାନୀଂ ୱିଚାରସ୍ଥାନେ ଦଣ୍ଡାଯମାନୋସ୍ମି| ");
INSERT INTO sanori_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","ତସ୍ୟାଙ୍ଗୀକାରସ୍ୟ ଫଲଂ ପ୍ରାପ୍ତୁମ୍ ଅସ୍ମାକଂ ଦ୍ୱାଦଶୱଂଶା ଦିୱାନିଶଂ ମହାଯତ୍ନାଦ୍ ଈଶ୍ୱରସେୱନଂ କୃତ୍ୱା ଯାଂ ପ୍ରତ୍ୟାଶାଂ କୁର୍ୱ୍ୱନ୍ତି ତସ୍ୟାଃ ପ୍ରତ୍ୟାଶାଯା ହେତୋରହଂ ଯିହୂଦୀଯୈରପୱାଦିତୋଽଭୱମ୍| ");
INSERT INTO sanori_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","ଈଶ୍ୱରୋ ମୃତାନ୍ ଉତ୍ଥାପଯିଷ୍ୟତୀତି ୱାକ୍ୟଂ ଯୁଷ୍ମାକଂ ନିକଟେଽସମ୍ଭୱଂ କୁତୋ ଭୱେତ୍? ");
INSERT INTO sanori_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","ନାସରତୀଯଯୀଶୋ ର୍ନାମ୍ନୋ ୱିରୁଦ୍ଧଂ ନାନାପ୍ରକାରପ୍ରତିକୂଲାଚରଣମ୍ ଉଚିତମ୍ ଇତ୍ୟହଂ ମନସି ଯଥାର୍ଥଂ ୱିଜ୍ଞାଯ ");
INSERT INTO sanori_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","ଯିରୂଶାଲମନଗରେ ତଦକରୱଂ ଫଲତଃ ପ୍ରଧାନଯାଜକସ୍ୟ ନିକଟାତ୍ କ୍ଷମତାଂ ପ୍ରାପ୍ୟ ବହୂନ୍ ପୱିତ୍ରଲୋକାନ୍ କାରାଯାଂ ବଦ୍ଧୱାନ୍ ୱିଶେଷତସ୍ତେଷାଂ ହନନସମଯେ ତେଷାଂ ୱିରୁଦ୍ଧାଂ ନିଜାଂ ସମ୍ମତିଂ ପ୍ରକାଶିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","ୱାରଂ ୱାରଂ ଭଜନଭୱନେଷୁ ତେଭ୍ୟୋ ଦଣ୍ଡଂ ପ୍ରଦତ୍ତୱାନ୍ ବଲାତ୍ ତଂ ଧର୍ମ୍ମଂ ନିନ୍ଦଯିତୱାଂଶ୍ଚ ପୁନଶ୍ଚ ତାନ୍ ପ୍ରତି ମହାକ୍ରୋଧାଦ୍ ଉନ୍ମତ୍ତଃ ସନ୍ ୱିଦେଶୀଯନଗରାଣି ଯାୱତ୍ ତାନ୍ ତାଡିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","ଇତ୍ଥଂ ପ୍ରଧାନଯାଜକସ୍ୟ ସମୀପାତ୍ ଶକ୍ତିମ୍ ଆଜ୍ଞାପତ୍ରଞ୍ଚ ଲବ୍ଧ୍ୱା ଦମ୍ମେଷକ୍ନଗରଂ ଗତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","ତଦାହଂ ହେ ରାଜନ୍ ମାର୍ଗମଧ୍ୟେ ମଧ୍ୟାହ୍ନକାଲେ ମମ ମଦୀଯସଙ୍ଗିନାଂ ଲୋକାନାଞ୍ଚ ଚତସୃଷୁ ଦିକ୍ଷୁ ଗଗଣାତ୍ ପ୍ରକାଶମାନାଂ ଭାସ୍କରତୋପି ତେଜସ୍ୱତୀଂ ଦୀପ୍ତିଂ ଦୃଷ୍ଟୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","ତସ୍ମାଦ୍ ଅସ୍ମାସୁ ସର୍ୱ୍ୱେଷୁ ଭୂମୌ ପତିତେଷୁ ସତ୍ସୁ ହେ ଶୌଲ ହୈ ଶୌଲ କୁତୋ ମାଂ ତାଡଯସି? କଣ୍ଟକାନାଂ ମୁଖେ ପାଦାହନନଂ ତୱ ଦୁଃସାଧ୍ୟମ୍ ଇବ୍ରୀଯଭାଷଯା ଗଦିତ ଏତାଦୃଶ ଏକଃ ଶବ୍ଦୋ ମଯା ଶ୍ରୁତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","ତଦାହଂ ପୃଷ୍ଟୱାନ୍ ହେ ପ୍ରଭୋ କୋ ଭୱାନ୍? ତତଃ ସ କଥିତୱାନ୍ ଯଂ ଯୀଶୁଂ ତ୍ୱଂ ତାଡଯସି ସୋହଂ, ");
INSERT INTO sanori_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","କିନ୍ତୁ ସମୁତ୍ତିଷ୍ଠ ତ୍ୱଂ ଯଦ୍ ଦୃଷ୍ଟୱାନ୍ ଇତଃ ପୁନଞ୍ଚ ଯଦ୍ୟତ୍ ତ୍ୱାଂ ଦର୍ଶଯିଷ୍ୟାମି ତେଷାଂ ସର୍ୱ୍ୱେଷାଂ କାର୍ୟ୍ୟାଣାଂ ତ୍ୱାଂ ସାକ୍ଷିଣଂ ମମ ସେୱକଞ୍ଚ କର୍ତ୍ତୁମ୍ ଦର୍ଶନମ୍ ଅଦାମ୍| ");
INSERT INTO sanori_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","ୱିଶେଷତୋ ଯିହୂଦୀଯଲୋକେଭ୍ୟୋ ଭିନ୍ନଜାତୀଯେଭ୍ୟଶ୍ଚ ତ୍ୱାଂ ମନୋନୀତଂ କୃତ୍ୱା ତେଷାଂ ଯଥା ପାପମୋଚନଂ ଭୱତି ");
INSERT INTO sanori_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ଯଥା ତେ ମଯି ୱିଶ୍ୱସ୍ୟ ପୱିତ୍ରୀକୃତାନାଂ ମଧ୍ୟେ ଭାଗଂ ପ୍ରାପ୍ନୁୱନ୍ତି ତଦଭିପ୍ରାଯେଣ ତେଷାଂ ଜ୍ଞାନଚକ୍ଷୂଂଷି ପ୍ରସନ୍ନାନି କର୍ତ୍ତୁଂ ତଥାନ୍ଧକାରାଦ୍ ଦୀପ୍ତିଂ ପ୍ରତି ଶୈତାନାଧିକାରାଚ୍ଚ ଈଶ୍ୱରଂ ପ୍ରତି ମତୀଃ ପରାୱର୍ତ୍ତଯିତୁଂ ତେଷାଂ ସମୀପଂ ତ୍ୱାଂ ପ୍ରେଷ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","ହେ ଆଗ୍ରିପ୍ପରାଜ ଏତାଦୃଶଂ ସ୍ୱର୍ଗୀଯପ୍ରତ୍ୟାଦେଶଂ ଅଗ୍ରାହ୍ୟମ୍ ଅକୃତ୍ୱାହଂ ");
INSERT INTO sanori_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","ପ୍ରଥମତୋ ଦମ୍ମେଷକ୍ନଗରେ ତତୋ ଯିରୂଶାଲମି ସର୍ୱ୍ୱସ୍ମିନ୍ ଯିହୂଦୀଯଦେଶେ ଅନ୍ୟେଷୁ ଦେଶେଷୁ ଚ ଯେेନ ଲୋକା ମତିଂ ପରାୱର୍ତ୍ତ୍ୟ ଈଶ୍ୱରଂ ପ୍ରତି ପରାୱର୍ତ୍ତଯନ୍ତେ, ମନଃପରାୱର୍ତ୍ତନଯୋଗ୍ୟାନି କର୍ମ୍ମାଣି ଚ କୁର୍ୱ୍ୱନ୍ତି ତାଦୃଶମ୍ ଉପଦେଶଂ ପ୍ରଚାରିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","ଏତତ୍କାରଣାଦ୍ ଯିହୂଦୀଯା ମଧ୍ୟେମନ୍ଦିରଂ ମାଂ ଧୃତ୍ୱା ହନ୍ତୁମ୍ ଉଦ୍ୟତାଃ| ");
INSERT INTO sanori_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","ତଥାପି ଖ୍ରୀଷ୍ଟୋ ଦୁଃଖଂ ଭୁକ୍ତ୍ୱା ସର୍ୱ୍ୱେଷାଂ ପୂର୍ୱ୍ୱଂ ଶ୍ମଶାନାଦ୍ ଉତ୍ଥାଯ ନିଜଦେଶୀଯାନାଂ ଭିନ୍ନଦେଶୀଯାନାଞ୍ଚ ସମୀପେ ଦୀପ୍ତିଂ ପ୍ରକାଶଯିଷ୍ୟତି ");
INSERT INTO sanori_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","ଭୱିଷ୍ୟଦ୍ୱାଦିଗଣୋ ମୂସାଶ୍ଚ ଭାୱିକାର୍ୟ୍ୟସ୍ୟ ଯଦିଦଂ ପ୍ରମାଣମ୍ ଅଦଦୁରେତଦ୍ ୱିନାନ୍ୟାଂ କଥାଂ ନ କଥଯିତ୍ୱା ଈଶ୍ୱରାଦ୍ ଅନୁଗ୍ରହଂ ଲବ୍ଧ୍ୱା ମହତାଂ କ୍ଷୁଦ୍ରାଣାଞ୍ଚ ସର୍ୱ୍ୱେଷାଂ ସମୀପେ ପ୍ରମାଣଂ ଦତ୍ତ୍ୱାଦ୍ୟ ଯାୱତ୍ ତିଷ୍ଠାମି| ");
INSERT INTO sanori_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","ତସ୍ୟମାଂ କଥାଂ ନିଶମ୍ୟ ଫୀଷ୍ଟ ଉଚ୍ଚୈଃ ସ୍ୱରେଣ କଥିତୱାନ୍ ହେ ପୌଲ ତ୍ୱମ୍ ଉନ୍ମତ୍ତୋସି ବହୁୱିଦ୍ୟାଭ୍ୟାସେନ ତ୍ୱଂ ହତଜ୍ଞାନୋ ଜାତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","ସ ଉକ୍ତୱାନ୍ ହେ ମହାମହିମ ଫୀଷ୍ଟ ନାହମ୍ ଉନ୍ମତ୍ତଃ କିନ୍ତୁ ସତ୍ୟଂ ୱିୱେଚନୀଯଞ୍ଚ ୱାକ୍ୟଂ ପ୍ରସ୍ତୌମି| ");
INSERT INTO sanori_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","ଯସ୍ୟ ସାକ୍ଷାଦ୍ ଅକ୍ଷୋଭଃ ସନ୍ କଥାଂ କଥଯାମି ସ ରାଜା ତଦ୍ୱୃତ୍ତାନ୍ତଂ ଜାନାତି ତସ୍ୟ ସମୀପେ କିମପି ଗୁପ୍ତଂ ନେତି ମଯା ନିଶ୍ଚିତଂ ବୁଧ୍ୟତେ ଯତସ୍ତଦ୍ ୱିଜନେ ନ କୃତଂ| ");
INSERT INTO sanori_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","ହେ ଆଗ୍ରିପ୍ପରାଜ ଭୱାନ୍ କିଂ ଭୱିଷ୍ୟଦ୍ୱାଦିଗଣୋକ୍ତାନି ୱାକ୍ୟାନି ପ୍ରତ୍ୟେତି? ଭୱାନ୍ ପ୍ରତ୍ୟେତି ତଦହଂ ଜାନାମି| ");
INSERT INTO sanori_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","ତତ ଆଗ୍ରିପ୍ପଃ ପୌଲମ୍ ଅଭିହିତୱାନ୍ ତ୍ୱଂ ପ୍ରୱୃତ୍ତିଂ ଜନଯିତ୍ୱା ପ୍ରାଯେଣ ମାମପି ଖ୍ରୀଷ୍ଟୀଯଂ କରୋଷି| ");
INSERT INTO sanori_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","ତତଃ ସୋଽୱାଦୀତ୍ ଭୱାନ୍ ଯେ ଯେ ଲୋକାଶ୍ଚ ମମ କଥାମ୍ ଅଦ୍ୟ ଶୃଣ୍ୱନ୍ତି ପ୍ରାଯେଣ ଇତି ନହି କିନ୍ତ୍ୱେତତ୍ ଶୃଙ୍ଖଲବନ୍ଧନଂ ୱିନା ସର୍ୱ୍ୱଥା ତେ ସର୍ୱ୍ୱେ ମାଦୃଶା ଭୱନ୍ତ୍ୱିତୀଶ୍ୱସ୍ୟ ସମୀପେ ପ୍ରାର୍ଥଯେଽହମ୍| ");
INSERT INTO sanori_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","ଏତସ୍ୟାଂ କଥାଯାଂ କଥିତାଯାଂ ସ ରାଜା ସୋଽଧିପତି ର୍ବର୍ଣୀକୀ ସଭାସ୍ଥା ଲୋକାଶ୍ଚ ତସ୍ମାଦ୍ ଉତ୍ଥାଯ ");
INSERT INTO sanori_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ଗୋପନେ ପରସ୍ପରଂ ୱିୱିଚ୍ୟ କଥିତୱନ୍ତ ଏଷ ଜନୋ ବନ୍ଧନାର୍ହଂ ପ୍ରାଣହନନାର୍ହଂ ୱା କିମପି କର୍ମ୍ମ ନାକରୋତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","ତତ ଆଗ୍ରିପ୍ପଃ ଫୀଷ୍ଟମ୍ ଅୱଦତ୍, ଯଦ୍ୟେଷ ମାନୁଷଃ କୈସରସ୍ୟ ନିକଟେ ୱିଚାରିତୋ ଭୱିତୁଂ ନ ପ୍ରାର୍ଥଯିଷ୍ୟତ୍ ତର୍ହି ମୁକ୍ତୋ ଭୱିତୁମ୍ ଅଶକ୍ଷ୍ୟତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","ଜଲପଥେନାସ୍ମାକମ୍ ଇତୋଲିଯାଦେଶଂ ପ୍ରତି ଯାତ୍ରାଯାଂ ନିଶ୍ଚିତାଯାଂ ସତ୍ୟାଂ ତେ ଯୂଲିଯନାମ୍ନୋ ମହାରାଜସ୍ୟ ସଂଘାତାନ୍ତର୍ଗତସ୍ୟ ସେନାପତେଃ ସମୀପେ ପୌଲଂ ତଦନ୍ୟାନ୍ କତିନଯଜନାଂଶ୍ଚ ସମାର୍ପଯନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","ୱଯମ୍ ଆଦ୍ରାମୁତ୍ତୀଯଂ ପୋତମେକମ୍ ଆରୁହ୍ୟ ଆଶିଯାଦେଶସ୍ୟ ତଟସମୀପେନ ଯାତୁଂ ମତିଂ କୃତ୍ୱା ଲଙ୍ଗରମ୍ ଉତ୍ଥାପ୍ୟ ପୋତମ୍ ଅମୋଚଯାମ; ମାକିଦନିଯାଦେଶସ୍ଥଥିଷଲନୀକୀନିୱାସ୍ୟାରିସ୍ତାର୍ଖନାମା କଶ୍ଚିଦ୍ ଜନୋଽସ୍ମାଭିଃ ସାର୍ଦ୍ଧମ୍ ଆସୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","ପରସ୍ମିନ୍ ଦିୱସେ ଽସ୍ମାଭିଃ ସୀଦୋନ୍ନଗରେ ପୋତେ ଲାଗିତେ ତତ୍ର ଯୂଲିଯଃ ସେନାପତିଃ ପୌଲଂ ପ୍ରତି ସୌଜନ୍ୟଂ ପ୍ରଦର୍ଥ୍ୟ ସାନ୍ତ୍ୱନାର୍ଥଂ ବନ୍ଧୁବାନ୍ଧୱାନ୍ ଉପଯାତୁମ୍ ଅନୁଜଜ୍ଞୌ| ");
INSERT INTO sanori_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","ତସ୍ମାତ୍ ପୋତେ ମୋଚିତେ ସତି ସମ୍ମୁଖୱାଯୋଃ ସମ୍ଭୱାଦ୍ ୱଯଂ କୁପ୍ରୋପଦ୍ୱୀପସ୍ୟ ତୀରସମୀପେନ ଗତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","କିଲିକିଯାଯାଃ ପାମ୍ଫୂଲିଯାଯାଶ୍ଚ ସମୁଦ୍ରସ୍ୟ ପାରଂ ଗତ୍ୱା ଲୂକିଯାଦେଶାନ୍ତର୍ଗତଂ ମୁରାନଗରମ୍ ଉପାତିଷ୍ଠାମ| ");
INSERT INTO sanori_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","ତତ୍ସ୍ଥାନାଦ୍ ଇତାଲିଯାଦେଶଂ ଗଚ୍ଛତି ଯଃ ସିକନ୍ଦରିଯାନଗରସ୍ୟ ପୋତସ୍ତଂ ତତ୍ର ପ୍ରାପ୍ୟ ଶତସେନାପତିସ୍ତଂ ପୋତମ୍ ଅସ୍ମାନ୍ ଆରୋହଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","ତତଃ ପରଂ ବହୂନି ଦିନାନି ଶନୈଃ ଶନୈଃ ର୍ଗତ୍ୱା କ୍ନୀଦପାର୍ଶ୍ୱୋପସ୍ଥ୍ତିेଃ ପୂର୍ୱ୍ୱଂ ପ୍ରତିକୂଲେନ ପୱନେନ ୱଯଂ ସଲ୍ମୋନ୍ୟାଃ ସମ୍ମୁଖମ୍ ଉପସ୍ଥାଯ କ୍ରୀତ୍ୟୁପଦ୍ୱୀପସ୍ୟ ତୀରସମୀପେନ ଗତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","କଷ୍ଟେନ ତମୁତ୍ତୀର୍ୟ୍ୟ ଲାସେଯାନଗରସ୍ୟାଧଃ ସୁନ୍ଦରନାମକଂ ଖାତମ୍ ଉପାତିଷ୍ଠାମ| ");
INSERT INTO sanori_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","ଇତ୍ଥଂ ବହୁତିଥଃ କାଲୋ ଯାପିତ ଉପୱାସଦିନଞ୍ଚାତୀତଂ, ତତ୍କାରଣାତ୍ ନୌୱର୍ତ୍ମନି ଭଯଙ୍କରେ ସତି ପୌଲୋ ୱିନଯେନ କଥିତୱାନ୍, ");
INSERT INTO sanori_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","ହେ ମହେଚ୍ଛା ଅହଂ ନିଶ୍ଚଯଂ ଜାନାମି ଯାତ୍ରାଯାମସ୍ୟାମ୍ ଅସ୍ମାକଂ କ୍ଲେଶା ବହୂନାମପଚଯାଶ୍ଚ ଭୱିଷ୍ୟନ୍ତି, ତେ କେୱଲଂ ପୋତସାମଗ୍ର୍ୟୋରିତି ନହି, କିନ୍ତ୍ୱସ୍ମାକଂ ପ୍ରାଣାନାମପି| ");
INSERT INTO sanori_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","ତଦା ଶତସେନାପତିଃ ପୌैेଲୋକ୍ତୱାକ୍ୟତୋପି କର୍ଣଧାରସ୍ୟ ପୋତୱଣିଜଶ୍ଚ ୱାକ୍ୟଂ ବହୁମଂସ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","ତତ୍ ଖାତଂ ଶୀତକାଲେ ୱାସାର୍ହସ୍ଥାନଂ ନ ତସ୍ମାଦ୍ ଅୱାଚୀପ୍ରତୀଚୋର୍ଦିଶୋଃ କ୍ରୀତ୍ୟାଃ ଫୈନୀକିଯଖାତଂ ଯାତୁଂ ଯଦି ଶକ୍ନୁୱନ୍ତସ୍ତର୍ହି ତତ୍ର ଶୀତକାଲଂ ଯାପଯିତୁଂ ପ୍ରାଯେଣ ସର୍ୱ୍ୱେ ମନ୍ତ୍ରଯାମାସୁଃ| ");
INSERT INTO sanori_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","ତତଃ ପରଂ ଦକ୍ଷିଣୱାଯୁ ର୍ମନ୍ଦଂ ୱହତୀତି ୱିଲୋକ୍ୟ ନିଜାଭିପ୍ରାଯସ୍ୟ ସିଦ୍ଧେଃ ସୁଯୋଗୋ ଭୱତୀତି ବୁଦ୍ଧ୍ୱା ପୋତଂ ମୋଚଯିତ୍ୱା କ୍ରୀତ୍ୟୁପଦ୍ୱୀପସ୍ୟ ତୀରସମୀପେନ ଚଲିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","କିନ୍ତ୍ୱଲ୍ପକ୍ଷଣାତ୍ ପରମେୱ ଉରକ୍ଲୁଦୋନ୍ନାମା ପ୍ରତିକୂଲଃ ପ୍ରଚଣ୍ଡୋ ୱାଯୁ ର୍ୱହନ୍ ପୋତେଽଲଗୀତ୍ ");
INSERT INTO sanori_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","ତସ୍ୟାଭିମୁଖଂ ଗନ୍ତୁମ୍ ପୋତସ୍ୟାଶକ୍ତତ୍ୱାଦ୍ ୱଯଂ ୱାଯୁନା ସ୍ୱଯଂ ନୀତାଃ| ");
INSERT INTO sanori_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","ଅନନ୍ତରଂ କ୍ଲୌଦୀନାମ୍ନ ଉପଦ୍ୱୀପସ୍ୟ କୂଲସମୀପେନ ପୋତଂ ଗମଯିତ୍ୱା ବହୁନା କଷ୍ଟେନ କ୍ଷୁଦ୍ରନାୱମ୍ ଅରକ୍ଷାମ| ");
INSERT INTO sanori_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","ତେ ତାମାରୁହ୍ୟ ରଜ୍ଜ୍ଚା ପୋତସ୍ୟାଧୋଭାଗମ୍ ଅବଧ୍ନନ୍ ତଦନନ୍ତରଂ ଚେତ୍ ପୋତୋ ସୈକତେ ଲଗତୀତି ଭଯାଦ୍ ୱାତୱସନାନ୍ୟମୋଚଯନ୍ ତତଃ ପୋତୋ ୱାଯୁନା ଚାଲିତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","କିନ୍ତୁ କ୍ରମଶୋ ୱାଯୋଃ ପ୍ରବଲତ୍ୱାତ୍ ପୋତୋ ଦୋଲାଯମାନୋଽଭୱତ୍ ପରସ୍ମିନ୍ ଦିୱସେ ପୋତସ୍ଥାନି କତିପଯାନି ଦ୍ରୱ୍ୟାଣି ତୋଯେ ନିକ୍ଷିପ୍ତାନି| ");
INSERT INTO sanori_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","ତୃତୀଯଦିୱସେ ୱଯଂ ସ୍ୱହସ୍ତୈଃ ପୋତସଜ୍ଜନଦ୍ରୱ୍ୟାଣି ନିକ୍ଷିପ୍ତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","ତତୋ ବହୁଦିନାନି ଯାୱତ୍ ସୂର୍ୟ୍ୟନକ୍ଷତ୍ରାଦୀନି ସମାଚ୍ଛନ୍ନାନି ତତୋ ଽତୀୱ ୱାତ୍ୟାଗମାଦ୍ ଅସ୍ମାକଂ ପ୍ରାଣରକ୍ଷାଯାଃ କାପି ପ୍ରତ୍ୟାଶା ନାତିଷ୍ଠତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","ବହୁଦିନେଷୁ ଲୋକୈରନାହାରେଣ ଯାପିତେଷୁ ସର୍ୱ୍ୱେଷାଂ ସାକ୍ଷତ୍ ପୌଲସ୍ତିଷ୍ଠନ୍ ଅକଥଯତ୍, ହେ ମହେଚ୍ଛାଃ କ୍ରୀତ୍ୟୁପଦ୍ୱୀପାତ୍ ପୋତଂ ନ ମୋଚଯିତୁମ୍ ଅହଂ ପୂର୍ୱ୍ୱଂ ଯଦ୍ ଅୱଦଂ ତଦ୍ଗ୍ରହଣଂ ଯୁଷ୍ମାକମ୍ ଉଚିତମ୍ ଆସୀତ୍ ତଥା କୃତେ ଯୁଷ୍ମାକମ୍ ଏଷା ୱିପଦ୍ ଏଷୋଽପଚଯଶ୍ଚ ନାଘଟିଷ୍ୟେତାମ୍| ");
INSERT INTO sanori_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","କିନ୍ତୁ ସାମ୍ପ୍ରତଂ ଯୁଷ୍ମାନ୍ ୱିନୀଯ ବ୍ରୱୀମ୍ୟହଂ, ଯୂଯଂ ନ କ୍ଷୁଭ୍ୟତ ଯୁଷ୍ମାକମ୍ ଏକସ୍ୟାପି ପ୍ରାଣିନୋ ହାନି ର୍ନ ଭୱିଷ୍ୟତି, କେୱଲସ୍ୟ ପୋତସ୍ୟ ହାନି ର୍ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","ଯତୋ ଯସ୍ୟେଶ୍ୱରସ୍ୟ ଲୋକୋଽହଂ ଯଞ୍ଚାହଂ ପରିଚରାମି ତଦୀଯ ଏକୋ ଦୂତୋ ହ୍ୟୋ ରାତ୍ରୌ ମମାନ୍ତିକେ ତିଷ୍ଠନ୍ କଥିତୱାନ୍, ");
INSERT INTO sanori_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ହେ ପୌଲ ମା ଭୈଷୀଃ କୈସରସ୍ୟ ସମ୍ମୁଖେ ତ୍ୱଯୋପସ୍ଥାତୱ୍ୟଂ; ତୱୈତାନ୍ ସଙ୍ଗିନୋ ଲୋକାନ୍ ଈଶ୍ୱରସ୍ତୁଭ୍ୟଂ ଦତ୍ତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","ଅତଏୱ ହେ ମହେଚ୍ଛା ଯୂଯଂ ସ୍ଥିରମନସୋ ଭୱତ ମହ୍ୟଂ ଯା କଥାକଥି ସାୱଶ୍ୟଂ ଘଟିଷ୍ୟତେ ମମୈତାଦୃଶୀ ୱିଶ୍ୱାସ ଈଶ୍ୱରେ ୱିଦ୍ୟତେ, ");
INSERT INTO sanori_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","କିନ୍ତୁ କସ୍ୟଚିଦ୍ ଉପଦ୍ୱୀପସ୍ୟୋପରି ପତିତୱ୍ୟମ୍ ଅସ୍ମାଭିଃ| ");
INSERT INTO sanori_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","ତତଃ ପରମ୍ ଆଦ୍ରିଯାସମୁଦ୍ରେ ପୋତସ୍ତଥୈୱ ଦୋଲାଯମାନଃ ସନ୍ ଇତସ୍ତତୋ ଗଚ୍ଛନ୍ ଚତୁର୍ଦଶଦିୱସସ୍ୟ ରାତ୍ରେ ର୍ଦ୍ୱିତୀଯପ୍ରହରସମଯେ କସ୍ୟଚିତ୍ ସ୍ଥଲସ୍ୟ ସମୀପମୁପତିଷ୍ଠତୀତି ପୋତୀଯଲୋକା ଅନ୍ୱମନ୍ୟନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","ତତସ୍ତେ ଜଲଂ ପରିମାଯ ତତ୍ର ୱିଂଶତି ର୍ୱ୍ୟାମା ଜଲାନୀତି ଜ୍ଞାତୱନ୍ତଃ| କିଞ୍ଚିଦ୍ଦୂରଂ ଗତ୍ୱା ପୁନରପି ଜଲଂ ପରିମିତୱନ୍ତଃ| ତତ୍ର ପଞ୍ଚଦଶ ୱ୍ୟାମା ଜଲାନି ଦୃଷ୍ଟ୍ୱା ");
INSERT INTO sanori_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","ଚେତ୍ ପାଷାଣେ ଲଗତୀତି ଭଯାତ୍ ପୋତସ୍ୟ ପଶ୍ଚାଦ୍ଭାଗତଶ୍ଚତୁରୋ ଲଙ୍ଗରାନ୍ ନିକ୍ଷିପ୍ୟ ଦିୱାକରମ୍ ଅପେକ୍ଷ୍ୟ ସର୍ୱ୍ୱେ ସ୍ଥିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","କିନ୍ତୁ ପୋତୀଯଲୋକାଃ ପୋତାଗ୍ରଭାଗେ ଲଙ୍ଗରନିକ୍ଷେପଂ ଛଲଂ କୃତ୍ୱା ଜଲଧୌ କ୍ଷୁଦ୍ରନାୱମ୍ ଅୱରୋହ୍ୟ ପଲାଯିତୁମ୍ ଅଚେଷ୍ଟନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","ତତଃ ପୌଲଃ ସେନାପତଯେ ସୈନ୍ୟଗଣାଯ ଚ କଥିତୱାନ୍, ଏତେ ଯଦି ପୋତମଧ୍ୟେ ନ ତିଷ୍ଠନ୍ତି ତର୍ହି ଯୁଷ୍ମାକଂ ରକ୍ଷଣଂ ନ ଶକ୍ୟଂ| ");
INSERT INTO sanori_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","ତଦା ସେନାଗଣୋ ରଜ୍ଜୂନ୍ ଛିତ୍ୱା ନାୱଂ ଜଲେ ପତିତୁମ୍ ଅଦଦାତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","ପ୍ରଭାତସମଯେ ପୌଲଃ ସର୍ୱ୍ୱାନ୍ ଜନାନ୍ ଭୋଜନାର୍ଥଂ ପ୍ରାର୍ଥ୍ୟ ୱ୍ୟାହରତ୍, ଅଦ୍ୟ ଚତୁର୍ଦଶଦିନାନି ଯାୱଦ୍ ଯୂଯମ୍ ଅପେକ୍ଷମାନା ଅନାହାରାଃ କାଲମ୍ ଅଯାପଯତ କିମପି ନାଭୁଂଗ୍ଧଂ| ");
INSERT INTO sanori_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","ଅତୋ ୱିନଯେेଽହଂ ଭକ୍ଷ୍ୟଂ ଭୁଜ୍ୟତାଂ ତତୋ ଯୁଷ୍ମାକଂ ମଙ୍ଗଲଂ ଭୱିଷ୍ୟତି, ଯୁଷ୍ମାକଂ କସ୍ୟଚିଜ୍ଜନସ୍ୟ ଶିରସଃ କେଶୈକୋପି ନ ନଂକ୍ଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","ଇତି ୱ୍ୟାହୃତ୍ୟ ପୌଲଂ ପୂପଂ ଗୃହୀତ୍ୱେଶ୍ୱରଂ ଧନ୍ୟଂ ଭାଷମାଣସ୍ତଂ ଭଂକ୍ତ୍ୱା ଭୋକ୍ତୁମ୍ ଆରବ୍ଧୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","ଅନନ୍ତରଂ ସର୍ୱ୍ୱେ ଚ ସୁସ୍ଥିରାଃ ସନ୍ତଃ ଖାଦ୍ୟାନି ପର୍ପ୍ୟଗୃହ୍ଲନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","ଅସ୍ମାକଂ ପୋତେ ଷଟ୍ସପ୍ତତ୍ୟଧିକଶତଦ୍ୱଯଲୋକା ଆସନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","ସର୍ୱ୍ୱେଷୁ ଲୋକେଷୁ ଯଥେଷ୍ଟଂ ଭୁକ୍ତୱତ୍ସୁ ପୋତସ୍ଥନ୍ ଗୋଧୂମାନ୍ ଜଲଧୌ ନିକ୍ଷିପ୍ୟ ତୈଃ ପୋତସ୍ୟ ଭାରୋ ଲଘୂକୃତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","ଦିନେ ଜାତେଽପି ସ କୋ ଦେଶ ଇତି ତଦା ନ ପର୍ୟ୍ୟଚୀଯତ; କିନ୍ତୁ ତତ୍ର ସମତଟମ୍ ଏକଂ ଖାତଂ ଦୃଷ୍ଟ୍ୱା ଯଦି ଶକ୍ନୁମସ୍ତର୍ହି ୱଯଂ ତସ୍ୟାଭ୍ୟନ୍ତରଂ ପୋତଂ ଗମଯାମ ଇତି ମତିଂ କୃତ୍ୱା ତେ ଲଙ୍ଗରାନ୍ ଛିତ୍ତ୍ୱା ଜଲଧୌ ତ୍ୟକ୍ତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","ତଥା କର୍ଣବନ୍ଧନଂ ମୋଚଯିତ୍ୱା ପ୍ରଧାନଂ ୱାତୱସନମ୍ ଉତ୍ତୋଲ୍ୟ ତୀରସମୀପଂ ଗତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","କିନ୍ତୁ ଦ୍ୱଯୋଃ ସମୁଦ୍ରଯୋଃ ସଙ୍ଗମସ୍ଥାନେ ସୈକତୋପରି ପୋତେ ନିକ୍ଷିପ୍ତେ ଽଗ୍ରଭାଗେ ବାଧିତେ ପଶ୍ଚାଦ୍ଭାଗେ ପ୍ରବଲତରଙ୍ଗୋଽଲଗତ୍ ତେନ ପୋତୋ ଭଗ୍ନଃ| ");
INSERT INTO sanori_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","ତସ୍ମାଦ୍ ବନ୍ଦଯଶ୍ଚେଦ୍ ବାହୁଭିସ୍ତରନ୍ତଃ ପଲାଯନ୍ତେ ଇତ୍ୟାଶଙ୍କଯା ସେନାଗଣସ୍ତାନ୍ ହନ୍ତୁମ୍ ଅମନ୍ତ୍ରଯତ୍; ");
INSERT INTO sanori_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","କିନ୍ତୁ ଶତସେନାପତିଃ ପୌଲଂ ରକ୍ଷିତୁଂ ପ୍ରଯତ୍ନଂ କୃତ୍ୱା ତାନ୍ ତଚ୍ଚେଷ୍ଟାଯା ନିୱର୍ତ୍ୟ ଇତ୍ୟାଦିଷ୍ଟୱାନ୍, ଯେ ବାହୁତରଣଂ ଜାନନ୍ତି ତେଽଗ୍ରେ ପ୍ରୋଲ୍ଲମ୍ପ୍ୟ ସମୁଦ୍ରେ ପତିତ୍ୱା ବାହୁଭିସ୍ତୀର୍ତ୍ତ୍ୱା କୂଲଂ ଯାନ୍ତୁ| ");
INSERT INTO sanori_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","ଅପରମ୍ ଅୱଶିଷ୍ଟା ଜନାଃ କାଷ୍ଠଂ ପୋତୀଯଂ ଦ୍ରୱ୍ୟଂ ୱା ଯେନ ଯତ୍ ପ୍ରାପ୍ୟତେ ତଦୱଲମ୍ବ୍ୟ ଯାନ୍ତୁ; ଇତ୍ଥଂ ସର୍ୱ୍ୱେ ଭୂମିଂ ପ୍ରାପ୍ୟ ପ୍ରାଣୈ ର୍ଜୀୱିତାଃ| ");
INSERT INTO sanori_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","ଇତ୍ଥଂ ସର୍ୱ୍ୱେଷୁ ରକ୍ଷାଂ ପ୍ରାପ୍ତେଷୁ ତତ୍ରତ୍ୟୋପଦ୍ୱୀପସ୍ୟ ନାମ ମିଲୀତେତି ତେ ଜ୍ଞାତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","ଅସଭ୍ୟଲୋକା ଯଥେଷ୍ଟମ୍ ଅନୁକମ୍ପାଂ କୃତ୍ୱା ୱର୍ତ୍ତମାନୱୃଷ୍ଟେଃ ଶୀତାଚ୍ଚ ୱହ୍ନିଂ ପ୍ରଜ୍ଜ୍ୱାଲ୍ୟାସ୍ମାକମ୍ ଆତିଥ୍ୟମ୍ ଅକୁର୍ୱ୍ୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","କିନ୍ତୁ ପୌଲ ଇନ୍ଧନାନି ସଂଗୃହ୍ୟ ଯଦା ତସ୍ମିନ୍ ଅଗ୍ରୌ ନିରକ୍ଷିପତ୍, ତଦା ୱହ୍ନେଃ ପ୍ରତାପାତ୍ ଏକଃ କୃଷ୍ଣସର୍ପୋ ନିର୍ଗତ୍ୟ ତସ୍ୟ ହସ୍ତେ ଦ୍ରଷ୍ଟୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","ତେଽସଭ୍ୟଲୋକାସ୍ତସ୍ୟ ହସ୍ତେ ସର୍ପମ୍ ଅୱଲମ୍ବମାନଂ ଦୃଷ୍ଟ୍ୱା ପରସ୍ପରମ୍ ଉକ୍ତୱନ୍ତ ଏଷ ଜନୋଽୱଶ୍ୟଂ ନରହା ଭୱିଷ୍ୟତି, ଯତୋ ଯଦ୍ୟପି ଜଲଧେ ରକ୍ଷାଂ ପ୍ରାପ୍ତୱାନ୍ ତଥାପି ପ୍ରତିଫଲଦାଯକ ଏନଂ ଜୀୱିତୁଂ ନ ଦଦାତି| ");
INSERT INTO sanori_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","କିନ୍ତୁ ସ ହସ୍ତଂ ୱିଧୁନ୍ୱନ୍ ତଂ ସର୍ପମ୍ ଅଗ୍ନିମଧ୍ୟେ ନିକ୍ଷିପ୍ୟ କାମପି ପୀଡାଂ ନାପ୍ତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","ତତୋ ୱିଷଜ୍ୱାଲଯା ଏତସ୍ୟ ଶରୀରଂ ସ୍ଫୀତଂ ଭୱିଷ୍ୟତି ଯଦ୍ୱା ହଠାଦଯଂ ପ୍ରାଣାନ୍ ତ୍ୟକ୍ଷ୍ୟତୀତି ନିଶ୍ଚିତ୍ୟ ଲୋକା ବହୁକ୍ଷଣାନି ଯାୱତ୍ ତଦ୍ ଦ୍ରଷ୍ଟୁଂ ସ୍ଥିତୱନ୍ତଃ କିନ୍ତୁ ତସ୍ୟ କସ୍ୟାଶ୍ଚିଦ୍ ୱିପଦୋଽଘଟନାତ୍ ତେ ତଦ୍ୱିପରୀତଂ ୱିଜ୍ଞାଯ ଭାଷିତୱନ୍ତ ଏଷ କଶ୍ଚିଦ୍ ଦେୱୋ ଭୱେତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","ପୁବ୍ଲିଯନାମା ଜନ ଏକସ୍ତସ୍ୟୋପଦ୍ୱୀପସ୍ୟାଧିପତିରାସୀତ୍ ତତ୍ର ତସ୍ୟ ଭୂମ୍ୟାଦି ଚ ସ୍ଥିତଂ| ସ ଜନୋଽସ୍ମାନ୍ ନିଜଗୃହଂ ନୀତ୍ୱା ସୌଜନ୍ୟଂ ପ୍ରକାଶ୍ୟ ଦିନତ୍ରଯଂ ଯାୱଦ୍ ଅସ୍ମାକଂ ଆତିଥ୍ୟମ୍ ଅକରୋତ୍| ");
INSERT INTO sanori_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","ତଦା ତସ୍ୟ ପୁବ୍ଲିଯସ୍ୟ ପିତା ଜ୍ୱରାତିସାରେଣ ପୀଡ୍ୟମାନଃ ସନ୍ ଶଯ୍ୟାଯାମ୍ ଆସୀତ୍; ତତଃ ପୌଲସ୍ତସ୍ୟ ସମୀପଂ ଗତ୍ୱା ପ୍ରାର୍ଥନାଂ କୃତ୍ୱା ତସ୍ୟ ଗାତ୍ରେ ହସ୍ତଂ ସମର୍ପ୍ୟ ତଂ ସ୍ୱସ୍ଥଂ କୃତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","ଇତ୍ଥଂ ଭୂତେ ତଦ୍ୱୀପନିୱାସିନ ଇତରେପି ରୋଗିଲୋକା ଆଗତ୍ୟ ନିରାମଯା ଅଭୱନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","ତସ୍ମାତ୍ତେଽସ୍ମାକମ୍ ଅତୀୱ ସତ୍କାରଂ କୃତୱନ୍ତଃ, ୱିଶେଷତଃ ପ୍ରସ୍ଥାନସମଯେ ପ୍ରଯୋଜନୀଯାନି ନାନଦ୍ରୱ୍ୟାଣି ଦତ୍ତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","ଇତ୍ଥଂ ତତ୍ର ତ୍ରିଷୁ ମାସେଷୁ ଗତେଷୁ ଯସ୍ୟ ଚିହ୍ନଂ ଦିଯସ୍କୂରୀ ତାଦୃଶ ଏକଃ ସିକନ୍ଦରୀଯନଗରସ୍ୟ ପୋତଃ ଶୀତକାଲଂ ଯାପଯନ୍ ତସ୍ମିନ୍ ଉପଦ୍ୱୀପେ ଽତିଷ୍ଠତ୍ ତମେୱ ପୋତଂ ୱଯମ୍ ଆରୁହ୍ୟ ଯାତ୍ରାମ୍ ଅକୁର୍ମ୍ମ| ");
INSERT INTO sanori_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","ତତଃ ପ୍ରଥମତଃ ସୁରାକୂସନଗରମ୍ ଉପସ୍ଥାଯ ତତ୍ର ତ୍ରୀଣି ଦିନାନି ସ୍ଥିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","ତସ୍ମାଦ୍ ଆୱୃତ୍ୟ ରୀଗିଯନଗରମ୍ ଉପସ୍ଥିତାଃ ଦିନୈକସ୍ମାତ୍ ପରଂ ଦକ୍ଷିଣୱଯୌ ସାନୁକୂଲ୍ୟେ ସତି ପରସ୍ମିନ୍ ଦିୱସେ ପତିଯଲୀନଗରମ୍ ଉପାତିଷ୍ଠାମ| ");
INSERT INTO sanori_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","ତତୋଽସ୍ମାସୁ ତତ୍ରତ୍ୟଂ ଭ୍ରାତୃଗଣଂ ପ୍ରାପ୍ତେଷୁ ତେ ସ୍ୱୈଃ ସାର୍ଦ୍ଧମ୍ ଅସ୍ମାନ୍ ସପ୍ତ ଦିନାନି ସ୍ଥାପଯିତୁମ୍ ଅଯତନ୍ତ, ଇତ୍ଥଂ ୱଯଂ ରୋମାନଗରମ୍ ପ୍ରତ୍ୟଗଚ୍ଛାମ| ");
INSERT INTO sanori_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","ତସ୍ମାତ୍ ତତ୍ରତ୍ୟାଃ ଭ୍ରାତରୋଽସ୍ମାକମ୍ ଆଗମନୱାର୍ତ୍ତାଂ ଶ୍ରୁତ୍ୱା ଆପ୍ପିଯଫରଂ ତ୍ରିଷ୍ଟାୱର୍ଣୀଞ୍ଚ ଯାୱଦ୍ ଅଗ୍ରେସରାଃ ସନ୍ତୋସ୍ମାନ୍ ସାକ୍ଷାତ୍ କର୍ତ୍ତୁମ୍ ଆଗମନ୍; ତେଷାଂ ଦର୍ଶନାତ୍ ପୌଲ ଈଶ୍ୱରଂ ଧନ୍ୟଂ ୱଦନ୍ ଆଶ୍ୱାସମ୍ ଆପ୍ତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","ଅସ୍ମାସୁ ରୋମାନଗରଂ ଗତେଷୁ ଶତସେନାପତିଃ ସର୍ୱ୍ୱାନ୍ ବନ୍ଦୀନ୍ ପ୍ରଧାନସେନାପତେଃ ସମୀପେ ସମାର୍ପଯତ୍ କିନ୍ତୁ ପୌଲାଯ ସ୍ୱରକ୍ଷକପଦାତିନା ସହ ପୃଥଗ୍ ୱସ୍ତୁମ୍ ଅନୁମତିଂ ଦତ୍ତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","ଦିନତ୍ରଯାତ୍ ପରଂ ପୌଲସ୍ତଦ୍ଦେଶସ୍ଥାନ୍ ପ୍ରଧାନଯିହୂଦିନ ଆହୂତୱାନ୍ ତତସ୍ତେଷୁ ସମୁପସ୍ଥିତେଷୁ ସ କଥିତୱାନ୍, ହେ ଭ୍ରାତୃଗଣ ନିଜଲୋକାନାଂ ପୂର୍ୱ୍ୱପୁରୁଷାଣାଂ ୱା ରୀତେ ର୍ୱିପରୀତଂ କିଞ୍ଚନ କର୍ମ୍ମାହଂ ନାକରୱଂ ତଥାପି ଯିରୂଶାଲମନିୱାସିନୋ ଲୋକା ମାଂ ବନ୍ଦିଂ କୃତ୍ୱା ରୋମିଲୋକାନାଂ ହସ୍ତେଷୁ ସମର୍ପିତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","ରୋମିଲୋକା ୱିଚାର୍ୟ୍ୟ ମମ ପ୍ରାଣହନନାର୍ହଂ କିମପି କାରଣଂ ନ ପ୍ରାପ୍ୟ ମାଂ ମୋଚଯିତୁମ୍ ଐଚ୍ଛନ୍; ");
INSERT INTO sanori_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","କିନ୍ତୁ ଯିହୂଦିଲୋକାନାମ୍ ଆପତ୍ତ୍ୟା ମଯା କୈସରରାଜସ୍ୟ ସମୀପେ ୱିଚାରସ୍ୟ ପ୍ରାର୍ଥନା କର୍ତ୍ତୱ୍ୟା ଜାତା ନୋଚେତ୍ ନିଜଦେଶୀଯଲୋକାନ୍ ପ୍ରତି ମମ କୋପ୍ୟଭିଯୋଗୋ ନାସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","ଏତତ୍କାରଣାଦ୍ ଅହଂ ଯୁଷ୍ମାନ୍ ଦ୍ରଷ୍ଟୁଂ ସଂଲପିତୁଞ୍ଚାହୂଯମ୍ ଇସ୍ରାଯେଲ୍ୱଶୀଯାନାଂ ପ୍ରତ୍ୟାଶାହେତୋହମ୍ ଏତେନ ଶୁଙ୍ଖଲେନ ବଦ୍ଧୋଽଭୱମ୍| ");
INSERT INTO sanori_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","ତଦା ତେ ତମ୍ ଅୱାଦିଷୁଃ, ଯିହୂଦୀଯଦେଶାଦ୍ ୱଯଂ ତ୍ୱାମଧି କିମପି ପତ୍ରଂ ନ ପ୍ରାପ୍ତା ଯେ ଭ୍ରାତରଃ ସମାଯାତାସ୍ତେଷାଂ କୋପି ତୱ କାମପି ୱାର୍ତ୍ତାଂ ନାୱଦତ୍ ଅଭଦ୍ରମପି ନାକଥଯଚ୍ଚ| ");
INSERT INTO sanori_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","ତୱ ମତଂ କିମିତି ୱଯଂ ତ୍ୱତ୍ତଃ ଶ୍ରୋତୁମିଚ୍ଛାମଃ| ଯଦ୍ ଇଦଂ ନୱୀନଂ ମତମୁତ୍ଥିତଂ ତତ୍ ସର୍ୱ୍ୱତ୍ର ସର୍ୱ୍ୱେଷାଂ ନିକଟେ ନିନ୍ଦିତଂ ଜାତମ ଇତି ୱଯଂ ଜାନୀମଃ| ");
INSERT INTO sanori_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","ତୈସ୍ତଦର୍ଥମ୍ ଏକସ୍ମିନ୍ ଦିନେ ନିରୂପିତେ ତସ୍ମିନ୍ ଦିନେ ବହୱ ଏକତ୍ର ମିଲିତ୍ୱା ପୌଲସ୍ୟ ୱାସଗୃହମ୍ ଆଗଚ୍ଛନ୍ ତସ୍ମାତ୍ ପୌଲ ଆ ପ୍ରାତଃକାଲାତ୍ ସନ୍ଧ୍ୟାକାଲଂ ଯାୱନ୍ ମୂସାୱ୍ୟୱସ୍ଥାଗ୍ରନ୍ଥାଦ୍ ଭୱିଷ୍ୟଦ୍ୱାଦିନାଂ ଗ୍ରନ୍ଥେଭ୍ୟଶ୍ଚ ଯୀଶୋଃ କଥାମ୍ ଉତ୍ଥାପ୍ୟ ଈଶ୍ୱରସ୍ୟ ରାଜ୍ୟେ ପ୍ରମାଣଂ ଦତ୍ୱା ତେଷାଂ ପ୍ରୱୃତ୍ତିଂ ଜନଯିତୁଂ ଚେଷ୍ଟିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","କେଚିତ୍ତୁ ତସ୍ୟ କଥାଂ ପ୍ରତ୍ୟାଯନ୍ କେଚିତ୍ତୁ ନ ପ୍ରତ୍ୟାଯନ୍; ");
INSERT INTO sanori_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","ଏତତ୍କାରଣାତ୍ ତେଷାଂ ପରସ୍ପରମ୍ ଅନୈକ୍ୟାତ୍ ସର୍ୱ୍ୱେ ଚଲିତୱନ୍ତଃ; ତଥାପି ପୌଲ ଏତାଂ କଥାମେକାଂ କଥିତୱାନ୍ ପୱିତ୍ର ଆତ୍ମା ଯିଶଯିଯସ୍ୟ ଭୱିଷ୍ୟଦ୍ୱକ୍ତୁ ର୍ୱଦନାଦ୍ ଅସ୍ମାକଂ ପିତୃପୁରୁଷେଭ୍ୟ ଏତାଂ କଥାଂ ଭଦ୍ରଂ କଥଯାମାସ, ଯଥା, ");
INSERT INTO sanori_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","\"ଉପଗତ୍ୟ ଜନାନେତାନ୍ ତ୍ୱଂ ଭାଷସ୍ୱ ୱଚସ୍ତ୍ୱିଦଂ| କର୍ଣୈଃ ଶ୍ରୋଷ୍ୟଥ ଯୂଯଂ ହି କିନ୍ତୁ ଯୂଯଂ ନ ଭୋତ୍ସ୍ୟଥ| ନେତ୍ରୈ ର୍ଦ୍ରକ୍ଷ୍ୟଥ ଯୂଯଞ୍ଚ ଜ୍ଞାତୁଂ ଯୂଯଂ ନ ଶକ୍ଷ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","ତେ ମାନୁଷା ଯଥା ନେତ୍ରୈଃ ପରିପଶ୍ୟନ୍ତି ନୈୱ ହି| କର୍ଣୈଃ ର୍ୟଥା ନ ଶୃଣ୍ୱନ୍ତି ବୁଧ୍ୟନ୍ତେ ନ ଚ ମାନସୈଃ| ୱ୍ୟାୱର୍ତ୍ତଯତ୍ସୁ ଚିତ୍ତାନି କାଲେ କୁତ୍ରାପି ତେଷୁ ୱୈ| ମତ୍ତସ୍ତେ ମନୁଜାଃ ସ୍ୱସ୍ଥା ଯଥା ନୈୱ ଭୱନ୍ତି ଚ| ତଥା ତେଷାଂ ମନୁଷ୍ୟାଣାଂ ସନ୍ତି ସ୍ଥୂଲା ହି ବୁଦ୍ଧଯଃ| ବଧିରୀଭୂତକର୍ଣାଶ୍ଚ ଜାତାଶ୍ଚ ମୁଦ୍ରିତା ଦୃଶଃ|| ");
INSERT INTO sanori_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","ଅତ ଈଶ୍ୱରାଦ୍ ଯତ୍ ପରିତ୍ରାଣଂ ତସ୍ୟ ୱାର୍ତ୍ତା ଭିନ୍ନଦେଶୀଯାନାଂ ସମୀପଂ ପ୍ରେଷିତା ତଏୱ ତାଂ ଗ୍ରହୀଷ୍ୟନ୍ତୀତି ଯୂଯଂ ଜାନୀତ| ");
INSERT INTO sanori_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","ଏତାଦୃଶ୍ୟାଂ କଥାଯାଂ କଥିତାଯାଂ ସତ୍ୟାଂ ଯିହୂଦିନଃ ପରସ୍ପରଂ ବହୁୱିଚାରଂ କୁର୍ୱ୍ୱନ୍ତୋ ଗତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","ଇତ୍ଥଂ ପୌଲଃ ସମ୍ପୂର୍ଣଂ ୱତ୍ସରଦ୍ୱଯଂ ଯାୱଦ୍ ଭାଟକୀଯେ ୱାସଗୃହେ ୱସନ୍ ଯେ ଲୋକାସ୍ତସ୍ୟ ସନ୍ନିଧିମ୍ ଆଗଚ୍ଛନ୍ତି ତାନ୍ ସର୍ୱ୍ୱାନେୱ ପରିଗୃହ୍ଲନ୍, ");
INSERT INTO sanori_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","ନିର୍ୱିଘ୍ନମ୍ ଅତିଶଯନିଃକ୍ଷୋଭମ୍ ଈଶ୍ୱରୀଯରାଜତ୍ୱସ୍ୟ କଥାଂ ପ୍ରଚାରଯନ୍ ପ୍ରଭୌ ଯୀଶୌ ଖ୍ରୀଷ୍ଟେ କଥାଃ ସମୁପାଦିଶତ୍| ଇତି||");
INSERT INTO sanori_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","ଈଶ୍ୱରୋ ନିଜପୁତ୍ରମଧି ଯଂ ସୁସଂୱାଦଂ ଭୱିଷ୍ୟଦ୍ୱାଦିଭି ର୍ଧର୍ମ୍ମଗ୍ରନ୍ଥେ ପ୍ରତିଶ୍ରୁତୱାନ୍ ତଂ ସୁସଂୱାଦଂ ପ୍ରଚାରଯିତୁଂ ପୃଥକ୍କୃତ ଆହୂତଃ ପ୍ରେରିତଶ୍ଚ ପ୍ରଭୋ ର୍ୟୀଶୁଖ୍ରୀଷ୍ଟସ୍ୟ ସେୱକୋ ଯଃ ପୌଲଃ ");
INSERT INTO sanori_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","ସ ରୋମାନଗରସ୍ଥାନ୍ ଈଶ୍ୱରପ୍ରିଯାନ୍ ଆହୂତାଂଶ୍ଚ ପୱିତ୍ରଲୋକାନ୍ ପ୍ରତି ପତ୍ରଂ ଲିଖତି| ");
INSERT INTO sanori_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","ଅସ୍ମାକଂ ସ ପ୍ରଭୁ ର୍ୟୀଶୁଃ ଖ୍ରୀଷ୍ଟଃ ଶାରୀରିକସମ୍ବନ୍ଧେନ ଦାଯୂଦୋ ୱଂଶୋଦ୍ଭୱଃ ");
INSERT INTO sanori_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","ପୱିତ୍ରସ୍ୟାତ୍ମନଃ ସମ୍ବନ୍ଧେନ ଚେଶ୍ୱରସ୍ୟ ପ୍ରଭାୱୱାନ୍ ପୁତ୍ର ଇତି ଶ୍ମଶାନାତ୍ ତସ୍ୟୋତ୍ଥାନେନ ପ୍ରତିପନ୍ନଂ| ");
INSERT INTO sanori_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","ଅପରଂ ଯେଷାଂ ମଧ୍ୟେ ଯୀଶୁନା ଖ୍ରୀଷ୍ଟେନ ଯୂଯମପ୍ୟାହୂତାସ୍ତେ ଽନ୍ୟଦେଶୀଯଲୋକାସ୍ତସ୍ୟ ନାମ୍ନି ୱିଶ୍ୱସ୍ୟ ନିଦେଶଗ୍ରାହିଣୋ ଯଥା ଭୱନ୍ତି ");
INSERT INTO sanori_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","ତଦଭିପ୍ରାଯେଣ ୱଯଂ ତସ୍ମାଦ୍ ଅନୁଗ୍ରହଂ ପ୍ରେରିତତ୍ୱପଦଞ୍ଚ ପ୍ରାପ୍ତାଃ| ");
INSERT INTO sanori_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","ତାତେନାସ୍ମାକମ୍ ଈଶ୍ୱରେଣ ପ୍ରଭୁଣା ଯୀଶୁଖ୍ରୀଷ୍ଟେନ ଚ ଯୁଷ୍ମଭ୍ୟମ୍ ଅନୁଗ୍ରହଃ ଶାନ୍ତିଶ୍ଚ ପ୍ରଦୀଯେତାଂ| ");
INSERT INTO sanori_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","ପ୍ରଥମତଃ ସର୍ୱ୍ୱସ୍ମିନ୍ ଜଗତି ଯୁଷ୍ମାକଂ ୱିଶ୍ୱାସସ୍ୟ ପ୍ରକାଶିତତ୍ୱାଦ୍ ଅହଂ ଯୁଷ୍ମାକଂ ସର୍ୱ୍ୱେଷାଂ ନିମିତ୍ତଂ ଯୀଶୁଖ୍ରୀଷ୍ଟସ୍ୟ ନାମ ଗୃହ୍ଲନ୍ ଈଶ୍ୱରସ୍ୟ ଧନ୍ୟୱାଦଂ କରୋମି| ");
INSERT INTO sanori_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","ଅପରମ୍ ଈଶ୍ୱରସ୍ୟ ପ୍ରସାଦାଦ୍ ବହୁକାଲାତ୍ ପରଂ ସାମ୍ପ୍ରତଂ ଯୁଷ୍ମାକଂ ସମୀପଂ ଯାତୁଂ କଥମପି ଯତ୍ ସୁଯୋଗଂ ପ୍ରାପ୍ନୋମି, ଏତଦର୍ଥଂ ନିରନ୍ତରଂ ନାମାନ୍ୟୁଚ୍ଚାରଯନ୍ ନିଜାସୁ ସର୍ୱ୍ୱପ୍ରାର୍ଥନାସୁ ସର୍ୱ୍ୱଦା ନିୱେଦଯାମି, ");
INSERT INTO sanori_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ଏତସ୍ମିନ୍ ଯମହଂ ତତ୍ପୁତ୍ରୀଯସୁସଂୱାଦପ୍ରଚାରଣେନ ମନସା ପରିଚରାମି ସ ଈଶ୍ୱରୋ ମମ ସାକ୍ଷୀ ୱିଦ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","ଯତୋ ଯୁଷ୍ମାକଂ ମମ ଚ ୱିଶ୍ୱାସେନ ୱଯମ୍ ଉଭଯେ ଯଥା ଶାନ୍ତିଯୁକ୍ତା ଭୱାମ ଇତି କାରଣାଦ୍ ");
INSERT INTO sanori_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","ଯୁଷ୍ମାକଂ ସ୍ଥୈର୍ୟ୍ୟକରଣାର୍ଥଂ ଯୁଷ୍ମଭ୍ୟଂ କିଞ୍ଚିତ୍ପରମାର୍ଥଦାନଦାନାଯ ଯୁଷ୍ମାନ୍ ସାକ୍ଷାତ୍ କର୍ତ୍ତୁଂ ମଦୀଯା ୱାଞ୍ଛା| ");
INSERT INTO sanori_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","ହେ ଭ୍ରାତୃଗଣ ଭିନ୍ନଦେଶୀଯଲୋକାନାଂ ମଧ୍ୟେ ଯଦ୍ୱତ୍ ତଦ୍ୱଦ୍ ଯୁଷ୍ମାକଂ ମଧ୍ୟେପି ଯଥା ଫଲଂ ଭୁଞ୍ଜେ ତଦଭିପ୍ରାଯେଣ ମୁହୁର୍ମୁହୁ ର୍ୟୁଷ୍ମାକଂ ସମୀପଂ ଗନ୍ତୁମ୍ ଉଦ୍ୟତୋଽହଂ କିନ୍ତୁ ଯାୱଦ୍ ଅଦ୍ୟ ତସ୍ମିନ୍ ଗମନେ ମମ ୱିଘ୍ନୋ ଜାତ ଇତି ଯୂଯଂ ଯଦ୍ ଅଜ୍ଞାତାସ୍ତିଷ୍ଠଥ ତଦହମ୍ ଉଚିତଂ ନ ବୁଧ୍ୟେ| ");
INSERT INTO sanori_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","ଅହଂ ସଭ୍ୟାସଭ୍ୟାନାଂ ୱିଦ୍ୱଦୱିଦ୍ୱତାଞ୍ଚ ସର୍ୱ୍ୱେଷାମ୍ ଋଣୀ ୱିଦ୍ୟେ| ");
INSERT INTO sanori_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","ଅତଏୱ ରୋମାନିୱାସିନାଂ ଯୁଷ୍ମାକଂ ସମୀପେଽପି ଯଥାଶକ୍ତି ସୁସଂୱାଦଂ ପ୍ରଚାରଯିତୁମ୍ ଅହମ୍ ଉଦ୍ୟତୋସ୍ମି| ");
INSERT INTO sanori_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","ଯତଃ ଖ୍ରୀଷ୍ଟସ୍ୟ ସୁସଂୱାଦୋ ମମ ଲଜ୍ଜାସ୍ପଦଂ ନହି ସ ଈଶ୍ୱରସ୍ୟ ଶକ୍ତିସ୍ୱରୂପଃ ସନ୍ ଆ ଯିହୂଦୀଯେଭ୍ୟୋ ଽନ୍ୟଜାତୀଯାନ୍ ଯାୱତ୍ ସର୍ୱ୍ୱଜାତୀଯାନାଂ ମଧ୍ୟେ ଯଃ କଶ୍ଚିଦ୍ ତତ୍ର ୱିଶ୍ୱସିତି ତସ୍ୟୈୱ ତ୍ରାଣଂ ଜନଯତି| ");
INSERT INTO sanori_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","ଯତଃ ପ୍ରତ୍ୟଯସ୍ୟ ସମପରିମାଣମ୍ ଈଶ୍ୱରଦତ୍ତଂ ପୁଣ୍ୟଂ ତତ୍ସୁସଂୱାଦେ ପ୍ରକାଶତେ| ତଦଧି ଧର୍ମ୍ମପୁସ୍ତକେପି ଲିଖିତମିଦଂ \"ପୁଣ୍ୟୱାନ୍ ଜନୋ ୱିଶ୍ୱାସେନ ଜୀୱିଷ୍ୟତି\"| ");
INSERT INTO sanori_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","ଅତଏୱ ଯେ ମାନୱାଃ ପାପକର୍ମ୍ମଣା ସତ୍ୟତାଂ ରୁନ୍ଧନ୍ତି ତେଷାଂ ସର୍ୱ୍ୱସ୍ୟ ଦୁରାଚରଣସ୍ୟାଧର୍ମ୍ମସ୍ୟ ଚ ୱିରୁଦ୍ଧଂ ସ୍ୱର୍ଗାଦ୍ ଈଶ୍ୱରସ୍ୟ କୋପଃ ପ୍ରକାଶତେ| ");
INSERT INTO sanori_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","ଯତ ଈଶ୍ୱରମଧି ଯଦ୍ୟଦ୍ ଜ୍ଞେଯଂ ତଦ୍ ଈଶ୍ୱରଃ ସ୍ୱଯଂ ତାନ୍ ପ୍ରତି ପ୍ରକାଶିତୱାନ୍ ତସ୍ମାତ୍ ତେଷାମ୍ ଅଗୋଚରଂ ନହି| ");
INSERT INTO sanori_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","ଫଲତସ୍ତସ୍ୟାନନ୍ତଶକ୍ତୀଶ୍ୱରତ୍ୱାଦୀନ୍ୟଦୃଶ୍ୟାନ୍ୟପି ସୃଷ୍ଟିକାଲମ୍ ଆରଭ୍ୟ କର୍ମ୍ମସୁ ପ୍ରକାଶମାନାନି ଦୃଶ୍ୟନ୍ତେ ତସ୍ମାତ୍ ତେଷାଂ ଦୋଷପ୍ରକ୍ଷାଲନସ୍ୟ ପନ୍ଥା ନାସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","ଅପରମ୍ ଈଶ୍ୱରଂ ଜ୍ଞାତ୍ୱାପି ତେ ତମ୍ ଈଶ୍ୱରଜ୍ଞାନେନ ନାଦ୍ରିଯନ୍ତ କୃତଜ୍ଞା ୱା ନ ଜାତାଃ; ତସ୍ମାତ୍ ତେଷାଂ ସର୍ୱ୍ୱେ ତର୍କା ୱିଫଲୀଭୂତାଃ, ଅପରଞ୍ଚ ତେଷାଂ ୱିୱେକଶୂନ୍ୟାନି ମନାଂସି ତିମିରେ ମଗ୍ନାନି| ");
INSERT INTO sanori_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","ତେ ସ୍ୱାନ୍ ଜ୍ଞାନିନୋ ଜ୍ଞାତ୍ୱା ଜ୍ଞାନହୀନା ଅଭୱନ୍ ");
INSERT INTO sanori_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","ଅନଶ୍ୱରସ୍ୟେଶ୍ୱରସ୍ୟ ଗୌରୱଂ ୱିହାଯ ନଶ୍ୱରମନୁଷ୍ୟପଶୁପକ୍ଷ୍ୟୁରୋଗାମିପ୍ରଭୃତେରାକୃତିୱିଶିଷ୍ଟପ୍ରତିମାସ୍ତୈରାଶ୍ରିତାଃ| ");
INSERT INTO sanori_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","ଇତ୍ଥଂ ତ ଈଶ୍ୱରସ୍ୟ ସତ୍ୟତାଂ ୱିହାଯ ମୃଷାମତମ୍ ଆଶ୍ରିତୱନ୍ତଃ ସଚ୍ଚିଦାନନ୍ଦଂ ସୃଷ୍ଟିକର୍ତ୍ତାରଂ ତ୍ୟକ୍ତ୍ୱା ସୃଷ୍ଟୱସ୍ତୁନଃ ପୂଜାଂ ସେୱାଞ୍ଚ କୃତୱନ୍ତଃ; ");
INSERT INTO sanori_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","ଇତି ହେତୋରୀଶ୍ୱରସ୍ତାନ୍ କୁକ୍ରିଯାଯାଂ ସମର୍ପ୍ୟ ନିଜନିଜକୁଚିନ୍ତାଭିଲାଷାଭ୍ୟାଂ ସ୍ୱଂ ସ୍ୱଂ ଶରୀରଂ ପରସ୍ପରମ୍ ଅପମାନିତଂ କର୍ତ୍ତୁମ୍ ଅଦଦାତ୍| ");
INSERT INTO sanori_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","ଈଶ୍ୱରେଣ ତେଷୁ କ୍ୱଭିଲାଷେ ସମର୍ପିତେଷୁ ତେଷାଂ ଯୋଷିତଃ ସ୍ୱାଭାୱିକାଚରଣମ୍ ଅପହାଯ ୱିପରୀତକୃତ୍ୟେ ପ୍ରାୱର୍ତ୍ତନ୍ତ; ");
INSERT INTO sanori_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","ତଥା ପୁରୁଷା ଅପି ସ୍ୱାଭାୱିକଯୋଷିତ୍ସଙ୍ଗମଂ ୱିହାଯ ପରସ୍ପରଂ କାମକୃଶାନୁନା ଦଗ୍ଧାଃ ସନ୍ତଃ ପୁମାଂସଃ ପୁଂଭିଃ ସାକଂ କୁକୃତ୍ୟେ ସମାସଜ୍ୟ ନିଜନିଜଭ୍ରାନ୍ତେଃ ସମୁଚିତଂ ଫଲମ୍ ଅଲଭନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","ତେ ସ୍ୱେଷାଂ ମନଃସ୍ୱୀଶ୍ୱରାଯ ସ୍ଥାନଂ ଦାତୁମ୍ ଅନିଚ୍ଛୁକାସ୍ତତୋ ହେତୋରୀଶ୍ୱରସ୍ତାନ୍ ପ୍ରତି ଦୁଷ୍ଟମନସ୍କତ୍ୱମ୍ ଅୱିହିତକ୍ରିଯତ୍ୱଞ୍ଚ ଦତ୍ତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","ଅତଏୱ ତେ ସର୍ୱ୍ୱେ ଽନ୍ୟାଯୋ ୱ୍ୟଭିଚାରୋ ଦୁଷ୍ଟତ୍ୱଂ ଲୋଭୋ ଜିଘାଂସା ଈର୍ଷ୍ୟା ୱଧୋ ୱିୱାଦଶ୍ଚାତୁରୀ କୁମତିରିତ୍ୟାଦିଭି ର୍ଦୁଷ୍କର୍ମ୍ମଭିଃ ପରିପୂର୍ଣାଃ ସନ୍ତଃ ");
INSERT INTO sanori_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","କର୍ଣେଜପା ଅପୱାଦିନ ଈଶ୍ୱରଦ୍ୱେଷକା ହିଂସକା ଅହଙ୍କାରିଣ ଆତ୍ମଶ୍ଲାଘିନଃ କୁକର୍ମ୍ମୋତ୍ପାଦକାଃ ପିତ୍ରୋରାଜ୍ଞାଲଙ୍ଘକା ");
INSERT INTO sanori_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","ଅୱିଚାରକା ନିଯମଲଙ୍ଘିନଃ ସ୍ନେହରହିତା ଅତିଦ୍ୱେଷିଣୋ ନିର୍ଦଯାଶ୍ଚ ଜାତାଃ| ");
INSERT INTO sanori_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","ଯେ ଜନା ଏତାଦୃଶଂ କର୍ମ୍ମ କୁର୍ୱ୍ୱନ୍ତି ତଏୱ ମୃତିଯୋଗ୍ୟା ଈଶ୍ୱରସ୍ୟ ୱିଚାରମୀଦୃଶଂ ଜ୍ଞାତ୍ୱାପି ତ ଏତାଦୃଶଂ କର୍ମ୍ମ ସ୍ୱଯଂ କୁର୍ୱ୍ୱନ୍ତି କେୱଲମିତି ନହି କିନ୍ତୁ ତାଦୃଶକର୍ମ୍ମକାରିଷୁ ଲୋକେଷ୍ୱପି ପ୍ରୀଯନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","ହେ ପରଦୂଷକ ମନୁଷ୍ୟ ଯଃ କଶ୍ଚନ ତ୍ୱଂ ଭୱସି ତୱୋତ୍ତରଦାନାଯ ପନ୍ଥା ନାସ୍ତି ଯତୋ ଯସ୍ମାତ୍ କର୍ମ୍ମଣଃ ପରସ୍ତ୍ୱଯା ଦୂଷ୍ୟତେ ତସ୍ମାତ୍ ତ୍ୱମପି ଦୂଷ୍ୟସେ, ଯତସ୍ତଂ ଦୂଷଯନ୍ନପି ତ୍ୱଂ ତଦ୍ୱଦ୍ ଆଚରସି| ");
INSERT INTO sanori_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","କିନ୍ତ୍ୱେତାଦୃଗାଚାରିଭ୍ୟୋ ଯଂ ଦଣ୍ଡମ୍ ଈଶ୍ୱରୋ ନିଶ୍ଚିନୋତି ସ ଯଥାର୍ଥ ଇତି ୱଯଂ ଜାନୀମଃ| ");
INSERT INTO sanori_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","ଅତଏୱ ହେ ମାନୁଷ ତ୍ୱଂ ଯାଦୃଗାଚାରିଣୋ ଦୂଷଯସି ସ୍ୱଯଂ ଯଦି ତାଦୃଗାଚରସି ତର୍ହି ତ୍ୱମ୍ ଈଶ୍ୱରଦଣ୍ଡାତ୍ ପଲାଯିତୁଂ ଶକ୍ଷ୍ୟସୀତି କିଂ ବୁଧ୍ୟସେ? ");
INSERT INTO sanori_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","ଅପରଂ ତୱ ମନସଃ ପରିୱର୍ତ୍ତନଂ କର୍ତ୍ତୁମ୍ ଇଶ୍ୱରସ୍ୟାନୁଗ୍ରହୋ ଭୱତି ତନ୍ନ ବୁଦ୍ଧ୍ୱା ତ୍ୱଂ କିଂ ତଦୀଯାନୁଗ୍ରହକ୍ଷମାଚିରସହିଷ୍ଣୁତ୍ୱନିଧିଂ ତୁଚ୍ଛୀକରୋଷି? ");
INSERT INTO sanori_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","ତଥା ସ୍ୱାନ୍ତଃକରଣସ୍ୟ କଠୋରତ୍ୱାତ୍ ଖେଦରାହିତ୍ୟାଚ୍ଚେଶ୍ୱରସ୍ୟ ନ୍ୟାଯ୍ୟୱିଚାରପ୍ରକାଶନସ୍ୟ କ୍ରୋଧସ୍ୟ ଚ ଦିନଂ ଯାୱତ୍ କିଂ ସ୍ୱାର୍ଥଂ କୋପଂ ସଞ୍ଚିନୋଷି? ");
INSERT INTO sanori_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","କିନ୍ତୁ ସ ଏକୈକମନୁଜାଯ ତତ୍କର୍ମ୍ମାନୁସାରେଣ ପ୍ରତିଫଲଂ ଦାସ୍ୟତି; ");
INSERT INTO sanori_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","ୱସ୍ତୁତସ୍ତୁ ଯେ ଜନା ଧୈର୍ୟ୍ୟଂ ଧୃତ୍ୱା ସତ୍କର୍ମ୍ମ କୁର୍ୱ୍ୱନ୍ତୋ ମହିମା ସତ୍କାରୋଽମରତ୍ୱଞ୍ଚୈତାନି ମୃଗଯନ୍ତେ ତେଭ୍ୟୋଽନନ୍ତାଯୁ ର୍ଦାସ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","ଅପରଂ ଯେ ଜନାଃ ସତ୍ୟଧର୍ମ୍ମମ୍ ଅଗୃହୀତ୍ୱା ୱିପରୀତଧର୍ମ୍ମମ୍ ଗୃହ୍ଲନ୍ତି ତାଦୃଶା ୱିରୋଧିଜନାଃ କୋପଂ କ୍ରୋଧଞ୍ଚ ଭୋକ୍ଷ୍ୟନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","ଆ ଯିହୂଦିନୋଽନ୍ୟଦେଶିନଃ ପର୍ୟ୍ୟନ୍ତଂ ଯାୱନ୍ତଃ କୁକର୍ମ୍ମକାରିଣଃ ପ୍ରାଣିନଃ ସନ୍ତି ତେ ସର୍ୱ୍ୱେ ଦୁଃଖଂ ଯାତନାଞ୍ଚ ଗମିଷ୍ୟନ୍ତି; ");
INSERT INTO sanori_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","କିନ୍ତୁ ଆ ଯିହୂଦିନୋ ଭିନ୍ନଦେଶିପର୍ୟ୍ୟନ୍ତା ଯାୱନ୍ତଃ ସତ୍କର୍ମ୍ମକାରିଣୋ ଲୋକାଃ ସନ୍ତି ତାନ୍ ପ୍ରତି ମହିମା ସତ୍କାରଃ ଶାନ୍ତିଶ୍ଚ ଭୱିଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","ଈଶ୍ୱରସ୍ୟ ୱିଚାରେ ପକ୍ଷପାତୋ ନାସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","ଅଲବ୍ଧୱ୍ୟୱସ୍ଥାଶାସ୍ତ୍ରୈ ର୍ୟୈଃ ପାପାନି କୃତାନି ୱ୍ୟୱସ୍ଥାଶାସ୍ତ୍ରାଲବ୍ଧତ୍ୱାନୁରୂପସ୍ତେଷାଂ ୱିନାଶୋ ଭୱିଷ୍ୟତି; କିନ୍ତୁ ଲବ୍ଧୱ୍ୟୱସ୍ଥାଶାସ୍ତ୍ରା ଯେ ପାପାନ୍ୟକୁର୍ୱ୍ୱନ୍ ୱ୍ୟୱସ୍ଥାନୁସାରାଦେୱ ତେଷାଂ ୱିଚାରୋ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","ୱ୍ୟୱସ୍ଥାଶ୍ରୋତାର ଈଶ୍ୱରସ୍ୟ ସମୀପେ ନିଷ୍ପାପା ଭୱିଷ୍ୟନ୍ତୀତି ନହି କିନ୍ତୁ ୱ୍ୟୱସ୍ଥାଚାରିଣ ଏୱ ସପୁଣ୍ୟା ଭୱିଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","ଯତୋ ଽଲବ୍ଧୱ୍ୟୱସ୍ଥାଶାସ୍ତ୍ରା ଭିନ୍ନଦେଶୀଯଲୋକା ଯଦି ସ୍ୱଭାୱତୋ ୱ୍ୟୱସ୍ଥାନୁରୂପାନ୍ ଆଚାରାନ୍ କୁର୍ୱ୍ୱନ୍ତି ତର୍ହ୍ୟଲବ୍ଧଶାସ୍ତ୍ରାଃ ସନ୍ତୋଽପି ତେ ସ୍ୱେଷାଂ ୱ୍ୟୱସ୍ଥାଶାସ୍ତ୍ରମିୱ ସ୍ୱଯମେୱ ଭୱନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","ତେଷାଂ ମନସି ସାକ୍ଷିସ୍ୱରୂପେ ସତି ତେଷାଂ ୱିତର୍କେଷୁ ଚ କଦା ତାନ୍ ଦୋଷିଣଃ କଦା ୱା ନିର୍ଦୋଷାନ୍ କୃତୱତ୍ସୁ ତେ ସ୍ୱାନ୍ତର୍ଲିଖିତସ୍ୟ ୱ୍ୟୱସ୍ଥାଶାସ୍ତ୍ରସ୍ୟ ପ୍ରମାଣଂ ସ୍ୱଯମେୱ ଦଦତି| ");
INSERT INTO sanori_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","ଯସ୍ମିନ୍ ଦିନେ ମଯା ପ୍ରକାଶିତସ୍ୟ ସୁସଂୱାଦସ୍ୟାନୁସାରାଦ୍ ଈଶ୍ୱରୋ ଯୀଶୁଖ୍ରୀଷ୍ଟେନ ମାନୁଷାଣାମ୍ ଅନ୍ତଃକରଣାନାଂ ଗୂଢାଭିପ୍ରାଯାନ୍ ଧୃତ୍ୱା ୱିଚାରଯିଷ୍ୟତି ତସ୍ମିନ୍ ୱିଚାରଦିନେ ତତ୍ ପ୍ରକାଶିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","ପଶ୍ୟ ତ୍ୱଂ ସ୍ୱଯଂ ଯିହୂଦୀତି ୱିଖ୍ୟାତୋ ୱ୍ୟୱସ୍ଥୋପରି ୱିଶ୍ୱାସଂ କରୋଷି, ");
INSERT INTO sanori_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ଈଶ୍ୱରମୁଦ୍ଦିଶ୍ୟ ସ୍ୱଂ ଶ୍ଲାଘସେ, ତଥା ୱ୍ୟୱସ୍ଥଯା ଶିକ୍ଷିତୋ ଭୂତ୍ୱା ତସ୍ୟାଭିମତଂ ଜାନାସି, ସର୍ୱ୍ୱାସାଂ କଥାନାଂ ସାରଂ ୱିୱିଂକ୍ଷେ, ");
INSERT INTO sanori_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","ଅପରଂ ଜ୍ଞାନସ୍ୟ ସତ୍ୟତାଯାଶ୍ଚାକରସ୍ୱରୂପଂ ଶାସ୍ତ୍ରଂ ମମ ସମୀପେ ୱିଦ୍ୟତ ଅତୋ ଽନ୍ଧଲୋକାନାଂ ମାର୍ଗଦର୍ଶଯିତା ");
INSERT INTO sanori_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","ତିମିରସ୍ଥିତଲୋକାନାଂ ମଧ୍ୟେ ଦୀପ୍ତିସ୍ୱରୂପୋଽଜ୍ଞାନଲୋକେଭ୍ୟୋ ଜ୍ଞାନଦାତା ଶିଶୂନାଂ ଶିକ୍ଷଯିତାହମେୱେତି ମନ୍ୟସେ| ");
INSERT INTO sanori_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","ପରାନ୍ ଶିକ୍ଷଯନ୍ ସ୍ୱଯଂ ସ୍ୱଂ କିଂ ନ ଶିକ୍ଷଯସି? ୱସ୍ତୁତଶ୍ଚୌର୍ୟ୍ୟନିଷେଧୱ୍ୟୱସ୍ଥାଂ ପ୍ରଚାରଯନ୍ ତ୍ୱଂ କିଂ ସ୍ୱଯମେୱ ଚୋରଯସି? ");
INSERT INTO sanori_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","ତଥା ପରଦାରଗମନଂ ପ୍ରତିଷେଧନ୍ ସ୍ୱଯଂ କିଂ ପରଦାରାନ୍ ଗଚ୍ଛସି? ତଥା ତ୍ୱଂ ସ୍ୱଯଂ ପ୍ରତିମାଦ୍ୱେଷୀ ସନ୍ କିଂ ମନ୍ଦିରସ୍ୟ ଦ୍ରୱ୍ୟାଣି ହରସି? ");
INSERT INTO sanori_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","ଯସ୍ତ୍ୱଂ ୱ୍ୟୱସ୍ଥାଂ ଶ୍ଲାଘସେ ସ ତ୍ୱଂ କିଂ ୱ୍ୟୱସ୍ଥାମ୍ ଅୱମତ୍ୟ ନେଶ୍ୱରଂ ସମ୍ମନ୍ୟସେ? ");
INSERT INTO sanori_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","ଶାସ୍ତ୍ରେ ଯଥା ଲିଖତି \"ଭିନ୍ନଦେଶିନାଂ ସମୀପେ ଯୁଷ୍ମାକଂ ଦୋଷାଦ୍ ଈଶ୍ୱରସ୍ୟ ନାମ୍ନୋ ନିନ୍ଦା ଭୱତି| \" ");
INSERT INTO sanori_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","ଯଦି ୱ୍ୟୱସ୍ଥାଂ ପାଲଯସି ତର୍ହି ତୱ ତ୍ୱକ୍ଛେଦକ୍ରିଯା ସଫଲା ଭୱତି; ଯତି ୱ୍ୟୱସ୍ଥାଂ ଲଙ୍ଘସେ ତର୍ହି ତୱ ତ୍ୱକ୍ଛେଦୋଽତ୍ୱକ୍ଛେଦୋ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","ଯତୋ ୱ୍ୟୱସ୍ଥାଶାସ୍ତ୍ରାଦିଷ୍ଟଧର୍ମ୍ମକର୍ମ୍ମାଚାରୀ ପୁମାନ୍ ଅତ୍ୱକ୍ଛେଦୀ ସନ୍ନପି କିଂ ତ୍ୱକ୍ଛେଦିନାଂ ମଧ୍ୟେ ନ ଗଣଯିଷ୍ୟତେ? ");
INSERT INTO sanori_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","କିନ୍ତୁ ଲବ୍ଧଶାସ୍ତ୍ରଶ୍ଛିନ୍ନତ୍ୱକ୍ ଚ ତ୍ୱଂ ଯଦି ୱ୍ୟୱସ୍ଥାଲଙ୍ଘନଂ କରୋଷି ତର୍ହି ୱ୍ୟୱସ୍ଥାପାଲକାଃ ସ୍ୱାଭାୱିକାଚ୍ଛିନ୍ନତ୍ୱଚୋ ଲୋକାସ୍ତ୍ୱାଂ କିଂ ନ ଦୂଷଯିଷ୍ୟନ୍ତି? ");
INSERT INTO sanori_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","ତସ୍ମାଦ୍ ଯୋ ବାହ୍ୟେ ଯିହୂଦୀ ସ ଯିହୂଦୀ ନହି ତଥାଙ୍ଗସ୍ୟ ଯସ୍ତ୍ୱକ୍ଛେଦଃ ସ ତ୍ୱକ୍ଛେଦୋ ନହି; ");
INSERT INTO sanori_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","କିନ୍ତୁ ଯୋ ଜନ ଆନ୍ତରିକୋ ଯିହୂଦୀ ସ ଏୱ ଯିହୂଦୀ ଅପରଞ୍ଚ କେୱଲଲିଖିତଯା ୱ୍ୟୱସ୍ଥଯା ନ କିନ୍ତୁ ମାନସିକୋ ଯସ୍ତ୍ୱକ୍ଛେଦୋ ଯସ୍ୟ ଚ ପ୍ରଶଂସା ମନୁଷ୍ୟେଭ୍ୟୋ ନ ଭୂତ୍ୱା ଈଶ୍ୱରାଦ୍ ଭୱତି ସ ଏୱ ତ୍ୱକ୍ଛେଦଃ| ");
INSERT INTO sanori_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","ଅପରଞ୍ଚ ଯିହୂଦିନଃ କିଂ ଶ୍ରେଷ୍ଠତ୍ୱଂ? ତଥା ତ୍ୱକ୍ଛେଦସ୍ୟ ୱା କିଂ ଫଲଂ? ");
INSERT INTO sanori_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","ସର୍ୱ୍ୱଥା ବହୂନି ଫଲାନି ସନ୍ତି, ୱିଶେଷତ ଈଶ୍ୱରସ୍ୟ ଶାସ୍ତ୍ରଂ ତେଭ୍ୟୋଽଦୀଯତ| ");
INSERT INTO sanori_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","କୈଶ୍ଚିଦ୍ ଅୱିଶ୍ୱସନେ କୃତେ ତେଷାମ୍ ଅୱିଶ୍ୱସନାତ୍ କିମ୍ ଈଶ୍ୱରସ୍ୟ ୱିଶ୍ୱାସ୍ୟତାଯା ହାନିରୁତ୍ପତ୍ସ୍ୟତେ? ");
INSERT INTO sanori_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","କେନାପି ପ୍ରକାରେଣ ନହି| ଯଦ୍ୟପି ସର୍ୱ୍ୱେ ମନୁଷ୍ୟା ମିଥ୍ୟାୱାଦିନସ୍ତଥାପୀଶ୍ୱରଃ ସତ୍ୟୱାଦୀ| ଶାସ୍ତ୍ରେ ଯଥା ଲିଖିତମାସ୍ତେ, ଅତସ୍ତ୍ୱନ୍ତୁ ସ୍ୱୱାକ୍ୟେନ ନିର୍ଦ୍ଦୋଷୋ ହି ଭୱିଷ୍ୟସି| ୱିଚାରେ ଚୈୱ ନିଷ୍ପାପୋ ଭୱିଷ୍ୟସି ନ ସଂଶଯଃ| ");
INSERT INTO sanori_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","ଅସ୍ମାକମ୍ ଅନ୍ୟାଯେନ ଯଦୀଶ୍ୱରସ୍ୟ ନ୍ୟାଯଃ ପ୍ରକାଶତେ ତର୍ହି କିଂ ୱଦିଷ୍ୟାମଃ? ଅହଂ ମାନୁଷାଣାଂ କଥାମିୱ କଥାଂ କଥଯାମି, ଈଶ୍ୱରଃ ସମୁଚିତଂ ଦଣ୍ଡଂ ଦତ୍ତ୍ୱା କିମ୍ ଅନ୍ୟାଯୀ ଭୱିଷ୍ୟତି? ");
INSERT INTO sanori_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","ଇତ୍ଥଂ ନ ଭୱତୁ, ତଥା ସତୀଶ୍ୱରଃ କଥଂ ଜଗତୋ ୱିଚାରଯିତା ଭୱିଷ୍ୟତି? ");
INSERT INTO sanori_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","ମମ ମିଥ୍ୟାୱାକ୍ୟୱଦନାଦ୍ ଯଦୀଶ୍ୱରସ୍ୟ ସତ୍ୟତ୍ୱେନ ତସ୍ୟ ମହିମା ୱର୍ଦ୍ଧତେ ତର୍ହି କସ୍ମାଦହଂ ୱିଚାରେଽପରାଧିତ୍ୱେନ ଗଣ୍ୟୋ ଭୱାମି? ");
INSERT INTO sanori_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","ମଙ୍ଗଲାର୍ଥଂ ପାପମପି କରଣୀଯମିତି ୱାକ୍ୟଂ ତ୍ୱଯା କୁତୋ ନୋଚ୍ୟତେ? କିନ୍ତୁ ଯୈରୁଚ୍ୟତେ ତେ ନିତାନ୍ତଂ ଦଣ୍ଡସ୍ୟ ପାତ୍ରାଣି ଭୱନ୍ତି; ତଥାପି ତଦ୍ୱାକ୍ୟମ୍ ଅସ୍ମାଭିରପ୍ୟୁଚ୍ୟତ ଇତ୍ୟସ୍ମାକଂ ଗ୍ଲାନିଂ କୁର୍ୱ୍ୱନ୍ତଃ କିଯନ୍ତୋ ଲୋକା ୱଦନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","ଅନ୍ୟଲୋକେଭ୍ୟୋ ୱଯଂ କିଂ ଶ୍ରେଷ୍ଠାଃ? କଦାଚନ ନହି ଯତୋ ଯିହୂଦିନୋ ଽନ୍ୟଦେଶିନଶ୍ଚ ସର୍ୱ୍ୱଏୱ ପାପସ୍ୟାଯତ୍ତା ଇତ୍ୟସ୍ୟ ପ୍ରମାଣଂ ୱଯଂ ପୂର୍ୱ୍ୱମ୍ ଅଦଦାମ| ");
INSERT INTO sanori_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","ଲିପି ର୍ୟଥାସ୍ତେ, ନୈକୋପି ଧାର୍ମ୍ମିକୋ ଜନଃ| ");
INSERT INTO sanori_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","ତଥା ଜ୍ଞାନୀଶ୍ୱରଜ୍ଞାନୀ ମାନୱଃ କୋପି ନାସ୍ତି ହି| ");
INSERT INTO sanori_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","ୱିମାର୍ଗଗାମିନଃ ସର୍ୱ୍ୱେ ସର୍ୱ୍ୱେ ଦୁଷ୍କର୍ମ୍ମକାରିଣଃ| ଏକୋ ଜନୋପି ନୋ ତେଷାଂ ସାଧୁକର୍ମ୍ମ କରୋତି ଚ| ");
INSERT INTO sanori_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","ତଥା ତେଷାନ୍ତୁ ୱୈ କଣ୍ଠା ଅନାୱୃତଶ୍ମଶାନୱତ୍| ସ୍ତୁତିୱାଦଂ ପ୍ରକୁର୍ୱ୍ୱନ୍ତି ଜିହ୍ୱାଭିସ୍ତେ ତୁ କେୱଲଂ| ତେଷାମୋଷ୍ଠସ୍ୟ ନିମ୍ନେ ତୁ ୱିଷଂ ତିଷ୍ଠତି ସର୍ପ୍ପୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","ମୁଖଂ ତେଷାଂ ହି ଶାପେନ କପଟେନ ଚ ପୂର୍ୟ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","ରକ୍ତପାତାଯ ତେଷାଂ ତୁ ପଦାନି କ୍ଷିପ୍ରଗାନି ଚ| ");
INSERT INTO sanori_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","ପଥି ତେଷାଂ ମନୁଷ୍ୟାଣାଂ ନାଶଃ କ୍ଲେଶଶ୍ଚ କେୱଲଃ| ");
INSERT INTO sanori_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","ତେ ଜନା ନହି ଜାନନ୍ତି ପନ୍ଥାନଂ ସୁଖଦାଯିନଂ| ");
INSERT INTO sanori_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","ପରମେଶାଦ୍ ଭଯଂ ଯତ୍ତତ୍ ତଚ୍ଚକ୍ଷୁଷୋରଗୋଚରଂ| ");
INSERT INTO sanori_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","ୱ୍ୟୱସ୍ଥାଯାଂ ଯଦ୍ୟଲ୍ଲିଖତି ତଦ୍ ୱ୍ୟୱସ୍ଥାଧୀନାନ୍ ଲୋକାନ୍ ଉଦ୍ଦିଶ୍ୟ ଲିଖତୀତି ୱଯଂ ଜାନୀମଃ| ତତୋ ମନୁଷ୍ୟମାତ୍ରୋ ନିରୁତ୍ତରଃ ସନ୍ ଈଶ୍ୱରସ୍ୟ ସାକ୍ଷାଦ୍ ଅପରାଧୀ ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","ଅତଏୱ ୱ୍ୟୱସ୍ଥାନୁରୂପୈଃ କର୍ମ୍ମଭିଃ କଶ୍ଚିଦପି ପ୍ରାଣୀଶ୍ୱରସ୍ୟ ସାକ୍ଷାତ୍ ସପୁଣ୍ୟୀକୃତୋ ଭୱିତୁଂ ନ ଶକ୍ଷ୍ୟତି ଯତୋ ୱ୍ୟୱସ୍ଥଯା ପାପଜ୍ଞାନମାତ୍ରଂ ଜାଯତେ| ");
INSERT INTO sanori_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","କିନ୍ତୁ ୱ୍ୟୱସ୍ଥାଯାଃ ପୃଥଗ୍ ଈଶ୍ୱରେଣ ଦେଯଂ ଯତ୍ ପୁଣ୍ୟଂ ତଦ୍ ୱ୍ୟୱସ୍ଥାଯା ଭୱିଷ୍ୟଦ୍ୱାଦିଗଣସ୍ୟ ଚ ୱଚନୈଃ ପ୍ରମାଣୀକୃତଂ ସଦ୍ ଇଦାନୀଂ ପ୍ରକାଶତେ| ");
INSERT INTO sanori_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","ଯୀଶୁଖ୍ରୀଷ୍ଟେ ୱିଶ୍ୱାସକରଣାଦ୍ ଈଶ୍ୱରେଣ ଦତ୍ତଂ ତତ୍ ପୁଣ୍ୟଂ ସକଲେଷୁ ପ୍ରକାଶିତଂ ସତ୍ ସର୍ୱ୍ୱାନ୍ ୱିଶ୍ୱାସିନଃ ପ୍ରତି ୱର୍ତ୍ତତେ| ");
INSERT INTO sanori_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","ତେଷାଂ କୋପି ପ୍ରଭେଦୋ ନାସ୍ତି, ଯତଃ ସର୍ୱ୍ୱଏୱ ପାପିନ ଈଶ୍ୱରୀଯତେଜୋହୀନାଶ୍ଚ ଜାତାଃ| ");
INSERT INTO sanori_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","ତ ଈଶ୍ୱରସ୍ୟାନୁଗ୍ରହାଦ୍ ମୂଲ୍ୟଂ ୱିନା ଖ୍ରୀଷ୍ଟକୃତେନ ପରିତ୍ରାଣେନ ସପୁଣ୍ୟୀକୃତା ଭୱନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","ଯସ୍ମାତ୍ ସ୍ୱଶୋଣିତେନ ୱିଶ୍ୱାସାତ୍ ପାପନାଶକୋ ବଲୀ ଭୱିତୁଂ ସ ଏୱ ପୂର୍ୱ୍ୱମ୍ ଈଶ୍ୱରେଣ ନିଶ୍ଚିତଃ, ଇତ୍ଥମ୍ ଈଶ୍ୱରୀଯସହିଷ୍ଣୁତ୍ୱାତ୍ ପୁରାକୃତପାପାନାଂ ମାର୍ଜ୍ଜନକରଣେ ସ୍ୱୀଯଯାଥାର୍ଥ୍ୟଂ ତେନ ପ୍ରକାଶ୍ୟତେ, ");
INSERT INTO sanori_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","ୱର୍ତ୍ତମାନକାଲୀଯମପି ସ୍ୱଯାଥାର୍ଥ୍ୟଂ ତେନ ପ୍ରକାଶ୍ୟତେ, ଅପରଂ ଯୀଶୌ ୱିଶ୍ୱାସିନଂ ସପୁଣ୍ୟୀକୁର୍ୱ୍ୱନ୍ନପି ସ ଯାଥାର୍ଥିକସ୍ତିଷ୍ଠତି| ");
INSERT INTO sanori_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","ତର୍ହି କୁତ୍ରାତ୍ମଶ୍ଲାଘା? ସା ଦୂରୀକୃତା; କଯା ୱ୍ୟୱସ୍ଥଯା? କିଂ କ୍ରିଯାରୂପୱ୍ୟୱସ୍ଥଯା? ଇତ୍ଥଂ ନହି କିନ୍ତୁ ତତ୍ କେୱଲୱିଶ୍ୱାସରୂପଯା ୱ୍ୟୱସ୍ଥଯୈୱ ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","ଅତଏୱ ୱ୍ୟୱସ୍ଥାନୁରୂପାଃ କ୍ରିଯା ୱିନା କେୱଲେନ ୱିଶ୍ୱାସେନ ମାନୱଃ ସପୁଣ୍ୟୀକୃତୋ ଭୱିତୁଂ ଶକ୍ନୋତୀତ୍ୟସ୍ୟ ରାଦ୍ଧାନ୍ତଂ ଦର୍ଶଯାମଃ| ");
INSERT INTO sanori_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","ସ କିଂ କେୱଲଯିହୂଦିନାମ୍ ଈଶ୍ୱରୋ ଭୱତି? ଭିନ୍ନଦେଶିନାମ୍ ଈଶ୍ୱରୋ ନ ଭୱତି? ଭିନ୍ନଦେଶିନାମପି ଭୱତି; ");
INSERT INTO sanori_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","ଯସ୍ମାଦ୍ ଏକ ଈଶ୍ୱରୋ ୱିଶ୍ୱାସାତ୍ ତ୍ୱକ୍ଛେଦିନୋ ୱିଶ୍ୱାସେନାତ୍ୱକ୍ଛେଦିନଶ୍ଚ ସପୁଣ୍ୟୀକରିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","ତର୍ହି ୱିଶ୍ୱାସେନ ୱଯଂ କିଂ ୱ୍ୟୱସ୍ଥାଂ ଲୁମ୍ପାମ? ଇତ୍ଥଂ ନ ଭୱତୁ ୱଯଂ ୱ୍ୟୱସ୍ଥାଂ ସଂସ୍ଥାପଯାମ ଏୱ| ");
INSERT INTO sanori_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","ଅସ୍ମାକଂ ପୂର୍ୱ୍ୱପୁରୁଷ ଇବ୍ରାହୀମ୍ କାଯିକକ୍ରିଯଯା କିଂ ଲବ୍ଧୱାନ୍ ଏତଦଧି କିଂ ୱଦିଷ୍ୟାମଃ? ");
INSERT INTO sanori_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","ସ ଯଦି ନିଜକ୍ରିଯାଭ୍ୟଃ ସପୁଣ୍ୟୋ ଭୱେତ୍ ତର୍ହି ତସ୍ୟାତ୍ମଶ୍ଲାଘାଂ କର୍ତ୍ତୁଂ ପନ୍ଥା ଭୱେଦିତି ସତ୍ୟଂ, କିନ୍ତ୍ୱୀଶ୍ୱରସ୍ୟ ସମୀପେ ନହି| ");
INSERT INTO sanori_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","ଶାସ୍ତ୍ରେ କିଂ ଲିଖତି? ଇବ୍ରାହୀମ୍ ଈଶ୍ୱରେ ୱିଶ୍ୱସନାତ୍ ସ ୱିଶ୍ୱାସସ୍ତସ୍ମୈ ପୁଣ୍ୟାର୍ଥଂ ଗଣିତୋ ବଭୂୱ| ");
INSERT INTO sanori_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","କର୍ମ୍ମକାରିଣୋ ଯଦ୍ ୱେତନଂ ତଦ୍ ଅନୁଗ୍ରହସ୍ୟ ଫଲଂ ନହି କିନ୍ତୁ ତେନୋପାର୍ଜିତଂ ମନ୍ତୱ୍ୟମ୍| ");
INSERT INTO sanori_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","କିନ୍ତୁ ଯଃ ପାପିନଂ ସପୁଣ୍ୟୀକରୋତି ତସ୍ମିନ୍ ୱିଶ୍ୱାସିନଃ କର୍ମ୍ମହୀନସ୍ୟ ଜନସ୍ୟ ଯୋ ୱିଶ୍ୱାସଃ ସ ପୁଣ୍ୟାର୍ଥଂ ଗଣ୍ୟୋ ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","ଅପରଂ ଯଂ କ୍ରିଯାହୀନମ୍ ଈଶ୍ୱରଃ ସପୁଣ୍ୟୀକରୋତି ତସ୍ୟ ଧନ୍ୟୱାଦଂ ଦାଯୂଦ୍ ୱର୍ଣଯାମାସ, ଯଥା, ");
INSERT INTO sanori_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","ସ ଧନ୍ୟୋଽଘାନି ମୃଷ୍ଟାନି ଯସ୍ୟାଗାଂସ୍ୟାୱୃତାନି ଚ| ");
INSERT INTO sanori_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","ସ ଚ ଧନ୍ୟଃ ପରେଶେନ ପାପଂ ଯସ୍ୟ ନ ଗଣ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","ଏଷ ଧନ୍ୟୱାଦସ୍ତ୍ୱକ୍ଛେଦିନମ୍ ଅତ୍ୱକ୍ଛେଦିନଂ ୱା କଂ ପ୍ରତି ଭୱତି? ଇବ୍ରାହୀମୋ ୱିଶ୍ୱାସଃ ପୁଣ୍ୟାର୍ଥଂ ଗଣିତ ଇତି ୱଯଂ ୱଦାମଃ| ");
INSERT INTO sanori_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","ସ ୱିଶ୍ୱାସସ୍ତସ୍ୟ ତ୍ୱକ୍ଛେଦିତ୍ୱାୱସ୍ଥାଯାଂ କିମ୍ ଅତ୍ୱକ୍ଛେଦିତ୍ୱାୱସ୍ଥାଯାଂ କସ୍ମିନ୍ ସମଯେ ପୁଣ୍ୟମିୱ ଗଣିତଃ? ତ୍ୱକ୍ଛେଦିତ୍ୱାୱସ୍ଥାଯାଂ ନହି କିନ୍ତ୍ୱତ୍ୱକ୍ଛେଦିତ୍ୱାୱସ୍ଥାଯାଂ| ");
INSERT INTO sanori_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","ଅପରଞ୍ଚ ସ ଯତ୍ ସର୍ୱ୍ୱେଷାମ୍ ଅତ୍ୱକ୍ଛେଦିନାଂ ୱିଶ୍ୱାସିନାମ୍ ଆଦିପୁରୁଷୋ ଭୱେତ୍, ତେ ଚ ପୁଣ୍ୟୱତ୍ତ୍ୱେନ ଗଣ୍ୟେରନ୍; ");
INSERT INTO sanori_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","ଯେ ଚ ଲୋକାଃ କେୱଲଂ ଛିନ୍ନତ୍ୱଚୋ ନ ସନ୍ତୋ ଽସ୍ମତ୍ପୂର୍ୱ୍ୱପୁରୁଷ ଇବ୍ରାହୀମ୍ ଅଛିନ୍ନତ୍ୱକ୍ ସନ୍ ଯେନ ୱିଶ୍ୱାସମାର୍ଗେଣ ଗତୱାନ୍ ତେନୈୱ ତସ୍ୟ ପାଦଚିହ୍ନେନ ଗଚ୍ଛନ୍ତି ତେଷାଂ ତ୍ୱକ୍ଛେଦିନାମପ୍ୟାଦିପୁରୁଷୋ ଭୱେତ୍ ତଦର୍ଥମ୍ ଅତ୍ୱକ୍ଛେଦିନୋ ମାନୱସ୍ୟ ୱିଶ୍ୱାସାତ୍ ପୁଣ୍ୟମ୍ ଉତ୍ପଦ୍ୟତ ଇତି ପ୍ରମାଣସ୍ୱରୂପଂ ତ୍ୱକ୍ଛେଦଚିହ୍ନଂ ସ ପ୍ରାପ୍ନୋତ୍| ");
INSERT INTO sanori_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","ଇବ୍ରାହୀମ୍ ଜଗତୋଽଧିକାରୀ ଭୱିଷ୍ୟତି ଯୈଷା ପ୍ରତିଜ୍ଞା ତଂ ତସ୍ୟ ୱଂଶଞ୍ଚ ପ୍ରତି ପୂର୍ୱ୍ୱମ୍ ଅକ୍ରିଯତ ସା ୱ୍ୟୱସ୍ଥାମୂଲିକା ନହି କିନ୍ତୁ ୱିଶ୍ୱାସଜନ୍ୟପୁଣ୍ୟମୂଲିକା| ");
INSERT INTO sanori_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","ଯତୋ ୱ୍ୟୱସ୍ଥାୱଲମ୍ବିନୋ ଯଦ୍ୟଧିକାରିଣୋ ଭୱନ୍ତି ତର୍ହି ୱିଶ୍ୱାସୋ ୱିଫଲୋ ଜାଯତେ ସା ପ୍ରତିଜ୍ଞାପି ଲୁପ୍ତୈୱ| ");
INSERT INTO sanori_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","ଅଧିକନ୍ତୁ ୱ୍ୟୱସ୍ଥା କୋପଂ ଜନଯତି ଯତୋ ଽୱିଦ୍ୟମାନାଯାଂ ୱ୍ୟୱସ୍ଥାଯାମ୍ ଆଜ୍ଞାଲଙ୍ଘନଂ ନ ସମ୍ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","ଅତଏୱ ସା ପ୍ରତିଜ୍ଞା ଯଦ୍ ଅନୁଗ୍ରହସ୍ୟ ଫଲଂ ଭୱେତ୍ ତଦର୍ଥଂ ୱିଶ୍ୱାସମୂଲିକା ଯତସ୍ତଥାତ୍ୱେ ତଦ୍ୱଂଶସମୁଦାଯଂ ପ୍ରତି ଅର୍ଥତୋ ଯେ ୱ୍ୟୱସ୍ଥଯା ତଦ୍ୱଂଶସମ୍ଭୱାଃ କେୱଲଂ ତାନ୍ ପ୍ରତି ନହି କିନ୍ତୁ ଯ ଇବ୍ରାହୀମୀଯୱିଶ୍ୱାସେନ ତତ୍ସମ୍ଭୱାସ୍ତାନପି ପ୍ରତି ସା ପ୍ରତିଜ୍ଞା ସ୍ଥାସ୍ନୁର୍ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","ଯୋ ନିର୍ଜୀୱାନ୍ ସଜୀୱାନ୍ ଅୱିଦ୍ୟମାନାନି ୱସ୍ତୂନି ଚ ୱିଦ୍ୟମାନାନି କରୋତି ଇବ୍ରାହୀମୋ ୱିଶ୍ୱାସଭୂମେସ୍ତସ୍ୟେଶ୍ୱରସ୍ୟ ସାକ୍ଷାତ୍ ସୋଽସ୍ମାକଂ ସର୍ୱ୍ୱେଷାମ୍ ଆଦିପୁରୁଷ ଆସ୍ତେ, ଯଥା ଲିଖିତଂ ୱିଦ୍ୟତେ, ଅହଂ ତ୍ୱାଂ ବହୁଜାତୀନାମ୍ ଆଦିପୁରୁଷଂ କୃତ୍ୱା ନିଯୁକ୍ତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","ତ୍ୱଦୀଯସ୍ତାଦୃଶୋ ୱଂଶୋ ଜନିଷ୍ୟତେ ଯଦିଦଂ ୱାକ୍ୟଂ ପ୍ରତିଶ୍ରୁତଂ ତଦନୁସାରାଦ୍ ଇବ୍ରାହୀମ୍ ବହୁଦେଶୀଯଲୋକାନାମ୍ ଆଦିପୁରୁଷୋ ଯଦ୍ ଭୱତି ତଦର୍ଥଂ ସୋଽନପେକ୍ଷିତୱ୍ୟମପ୍ୟପେକ୍ଷମାଣୋ ୱିଶ୍ୱାସଂ କୃତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","ଅପରଞ୍ଚ କ୍ଷୀଣୱିଶ୍ୱାସୋ ନ ଭୂତ୍ୱା ଶତୱତ୍ସରୱଯସ୍କତ୍ୱାତ୍ ସ୍ୱଶରୀରସ୍ୟ ଜରାଂ ସାରାନାମ୍ନଃ ସ୍ୱଭାର୍ୟ୍ୟାଯା ରଜୋନିୱୃତ୍ତିଞ୍ଚ ତୃଣାଯ ନ ମେନେ| ");
INSERT INTO sanori_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","ଅପରମ୍ ଅୱିଶ୍ୱାସାଦ୍ ଈଶ୍ୱରସ୍ୟ ପ୍ରତିଜ୍ଞାୱଚନେ କମପି ସଂଶଯଂ ନ ଚକାର; ");
INSERT INTO sanori_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","କିନ୍ତ୍ୱୀଶ୍ୱରେଣ ଯତ୍ ପ୍ରତିଶ୍ରୁତଂ ତତ୍ ସାଧଯିତୁଂ ଶକ୍ୟତ ଇତି ନିଶ୍ଚିତଂ ୱିଜ୍ଞାଯ ଦୃଢୱିଶ୍ୱାସଃ ସନ୍ ଈଶ୍ୱରସ୍ୟ ମହିମାନଂ ପ୍ରକାଶଯାଞ୍ଚକାର| ");
INSERT INTO sanori_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","ଇତି ହେତୋସ୍ତସ୍ୟ ସ ୱିଶ୍ୱାସସ୍ତଦୀଯପୁଣ୍ୟମିୱ ଗଣଯାଞ୍ଚକ୍ରେ| ");
INSERT INTO sanori_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","ପୁଣ୍ୟମିୱାଗଣ୍ୟତ ତତ୍ କେୱଲସ୍ୟ ତସ୍ୟ ନିମିତ୍ତଂ ଲିଖିତଂ ନହି, ଅସ୍ମାକଂ ନିମିତ୍ତମପି, ");
INSERT INTO sanori_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","ଯତୋଽସ୍ମାକଂ ପାପନାଶାର୍ଥଂ ସମର୍ପିତୋଽସ୍ମାକଂ ପୁଣ୍ୟପ୍ରାପ୍ତ୍ୟର୍ଥଞ୍ଚୋତ୍ଥାପିତୋଽଭୱତ୍ ଯୋଽସ୍ମାକଂ ପ୍ରଭୁ ର୍ୟୀଶୁସ୍ତସ୍ୟୋତ୍ଥାପଯିତରୀଶ୍ୱରେ ");
INSERT INTO sanori_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","ଯଦି ୱଯଂ ୱିଶ୍ୱସାମସ୍ତର୍ହ୍ୟସ୍ମାକମପି ସଏୱ ୱିଶ୍ୱାସଃ ପୁଣ୍ୟମିୱ ଗଣଯିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","ୱିଶ୍ୱାସେନ ସପୁଣ୍ୟୀକୃତା ୱଯମ୍ ଈଶ୍ୱରେଣ ସାର୍ଦ୍ଧଂ ପ୍ରଭୁଣାସ୍ମାକଂ ଯୀଶୁଖ୍ରୀଷ୍ଟେନ ମେଲନଂ ପ୍ରାପ୍ତାଃ| ");
INSERT INTO sanori_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","ଅପରଂ ୱଯଂ ଯସ୍ମିନ୍ ଅନୁଗ୍ରହାଶ୍ରଯେ ତିଷ୍ଠାମସ୍ତନ୍ମଧ୍ୟଂ ୱିଶ୍ୱାସମାର୍ଗେଣ ତେନୈୱାନୀତା ୱଯମ୍ ଈଶ୍ୱରୀଯୱିଭୱପ୍ରାପ୍ତିପ୍ରତ୍ୟାଶଯା ସମାନନ୍ଦାମଃ| ");
INSERT INTO sanori_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","ତତ୍ କେୱଲଂ ନହି କିନ୍ତୁ କ୍ଲେଶଭୋଗେଽପ୍ୟାନନ୍ଦାମୋ ଯତଃ କ୍ଲେଶାाଦ୍ ଧୈର୍ୟ୍ୟଂ ଜାଯତ ଇତି ୱଯଂ ଜାନୀମଃ, ");
INSERT INTO sanori_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ଧୈର୍ୟ୍ୟାଚ୍ଚ ପରୀକ୍ଷିତତ୍ୱଂ ଜାଯତେ, ପରୀକ୍ଷିତତ୍ୱାତ୍ ପ୍ରତ୍ୟାଶା ଜାଯତେ, ");
INSERT INTO sanori_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","ପ୍ରତ୍ୟାଶାତୋ ୱ୍ରୀଡିତତ୍ୱଂ ନ ଜାଯତେ, ଯସ୍ମାଦ୍ ଅସ୍ମଭ୍ୟଂ ଦତ୍ତେନ ପୱିତ୍ରେଣାତ୍ମନାସ୍ମାକମ୍ ଅନ୍ତଃକରଣାନୀଶ୍ୱରସ୍ୟ ପ୍ରେମୱାରିଣା ସିକ୍ତାନି| ");
INSERT INTO sanori_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","ଅସ୍ମାସୁ ନିରୁପାଯେଷୁ ସତ୍ସୁ ଖ୍ରୀଷ୍ଟ ଉପଯୁକ୍ତେ ସମଯେ ପାପିନାଂ ନିମିତ୍ତଂ ସ୍ୱୀଯାନ୍ ପ୍ରଣାନ୍ ଅତ୍ୟଜତ୍| ");
INSERT INTO sanori_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","ହିତକାରିଣୋ ଜନସ୍ୟ କୃତେ କୋପି ପ୍ରଣାନ୍ ତ୍ୟକ୍ତୁଂ ସାହସଂ କର୍ତ୍ତୁଂ ଶକ୍ନୋତି, କିନ୍ତୁ ଧାର୍ମ୍ମିକସ୍ୟ କୃତେ ପ୍ରାଯେଣ କୋପି ପ୍ରାଣାନ୍ ନ ତ୍ୟଜତି| ");
INSERT INTO sanori_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","କିନ୍ତ୍ୱସ୍ମାସୁ ପାପିଷୁ ସତ୍ସ୍ୱପି ନିମିତ୍ତମସ୍ମାକଂ ଖ୍ରୀଷ୍ଟଃ ସ୍ୱପ୍ରାଣାନ୍ ତ୍ୟକ୍ତୱାନ୍, ତତ ଈଶ୍ୱରୋସ୍ମାନ୍ ପ୍ରତି ନିଜଂ ପରମପ୍ରେମାଣଂ ଦର୍ଶିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","ଅତଏୱ ତସ୍ୟ ରକ୍ତପାତେନ ସପୁଣ୍ୟୀକୃତା ୱଯଂ ନିତାନ୍ତଂ ତେନ କୋପାଦ୍ ଉଦ୍ଧାରିଷ୍ୟାମହେ| ");
INSERT INTO sanori_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","ଫଲତୋ ୱଯଂ ଯଦା ରିପୱ ଆସ୍ମ ତଦେଶ୍ୱରସ୍ୟ ପୁତ୍ରସ୍ୟ ମରଣେନ ତେନ ସାର୍ଦ୍ଧଂ ଯଦ୍ୟସ୍ମାକଂ ମେଲନଂ ଜାତଂ ତର୍ହି ମେଲନପ୍ରାପ୍ତାଃ ସନ୍ତୋଽୱଶ୍ୟଂ ତସ୍ୟ ଜୀୱନେନ ରକ୍ଷାଂ ଲପ୍ସ୍ୟାମହେ| ");
INSERT INTO sanori_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","ତତ୍ କେୱଲଂ ନହି କିନ୍ତୁ ଯେନ ମେଲନମ୍ ଅଲଭାମହି ତେନାସ୍ମାକଂ ପ୍ରଭୁଣା ଯୀଶୁଖ୍ରୀଷ୍ଟେନ ସାମ୍ପ୍ରତମ୍ ଈଶ୍ୱରେ ସମାନନ୍ଦାମଶ୍ଚ| ");
INSERT INTO sanori_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","ତଥା ସତି, ଏକେନ ମାନୁଷେଣ ପାପଂ ପାପେନ ଚ ମରଣଂ ଜଗତୀଂ ପ୍ରାୱିଶତ୍ ଅପରଂ ସର୍ୱ୍ୱେଷାଂ ପାପିତ୍ୱାତ୍ ସର୍ୱ୍ୱେ ମାନୁଷା ମୃତେ ର୍ନିଘ୍ନା ଅଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","ଯତୋ ୱ୍ୟୱସ୍ଥାଦାନସମଯଂ ଯାୱତ୍ ଜଗତି ପାପମ୍ ଆସୀତ୍ କିନ୍ତୁ ଯତ୍ର ୱ୍ୟୱସ୍ଥା ନ ୱିଦ୍ୟତେ ତତ୍ର ପାପସ୍ୟାପି ଗଣନା ନ ୱିଦ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","ତଥାପ୍ୟାଦମା ଯାଦୃଶଂ ପାପଂ କୃତଂ ତାଦୃଶଂ ପାପଂ ଯୈ ର୍ନାକାରି ଆଦମମ୍ ଆରଭ୍ୟ ମୂସାଂ ଯାୱତ୍ ତେଷାମପ୍ୟୁପରି ମୃତ୍ୟୂ ରାଜତ୍ୱମ୍ ଅକରୋତ୍ ସ ଆଦମ୍ ଭାୱ୍ୟାଦମୋ ନିଦର୍ଶନମେୱାସ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","କିନ୍ତୁ ପାପକର୍ମ୍ମଣୋ ଯାଦୃଶୋ ଭାୱସ୍ତାଦୃଗ୍ ଦାନକର୍ମ୍ମଣୋ ଭାୱୋ ନ ଭୱତି ଯତ ଏକସ୍ୟ ଜନସ୍ୟାପରାଧେନ ଯଦି ବହୂନାଂ ମରଣମ୍ ଅଘଟତ ତଥାପୀଶ୍ୱରାନୁଗ୍ରହସ୍ତଦନୁଗ୍ରହମୂଲକଂ ଦାନଞ୍ଚୈକେନ ଜନେନାର୍ଥାଦ୍ ଯୀଶୁନା ଖ୍ରୀଷ୍ଟେନ ବହୁଷୁ ବାହୁଲ୍ୟାତିବାହୁଲ୍ୟେନ ଫଲତି| ");
INSERT INTO sanori_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","ଅପରମ୍ ଏକସ୍ୟ ଜନସ୍ୟ ପାପକର୍ମ୍ମ ଯାଦୃକ୍ ଫଲଯୁକ୍ତଂ ଦାନକର୍ମ୍ମ ତାଦୃକ୍ ନ ଭୱତି ଯତୋ ୱିଚାରକର୍ମ୍ମୈକଂ ପାପମ୍ ଆରଭ୍ୟ ଦଣ୍ଡଜନକଂ ବଭୂୱ, କିନ୍ତୁ ଦାନକର୍ମ୍ମ ବହୁପାପାନ୍ୟାରଭ୍ୟ ପୁଣ୍ୟଜନକଂ ବଭୂୱ| ");
INSERT INTO sanori_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","ଯତ ଏକସ୍ୟ ଜନସ୍ୟ ପାପକର୍ମ୍ମତସ୍ତେନୈକେନ ଯଦି ମରଣସ୍ୟ ରାଜତ୍ୱଂ ଜାତଂ ତର୍ହି ଯେ ଜନା ଅନୁଗ୍ରହସ୍ୟ ବାହୁଲ୍ୟଂ ପୁଣ୍ୟଦାନଞ୍ଚ ପ୍ରାପ୍ନୁୱନ୍ତି ତ ଏକେନ ଜନେନ, ଅର୍ଥାତ୍ ଯୀଶୁଖ୍ରୀଷ୍ଟେନ, ଜୀୱନେ ରାଜତ୍ୱମ୍ ଅୱଶ୍ୟଂ କରିଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","ଏକୋଽପରାଧୋ ଯଦ୍ୱତ୍ ସର୍ୱ୍ୱମାନୱାନାଂ ଦଣ୍ଡଗାମୀ ମାର୍ଗୋ ଽଭୱତ୍ ତଦ୍ୱଦ୍ ଏକଂ ପୁଣ୍ୟଦାନଂ ସର୍ୱ୍ୱମାନୱାନାଂ ଜୀୱନଯୁକ୍ତପୁଣ୍ୟଗାମୀ ମାର୍ଗ ଏୱ| ");
INSERT INTO sanori_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","ଅପରମ୍ ଏକସ୍ୟ ଜନସ୍ୟାଜ୍ଞାଲଙ୍ଘନାଦ୍ ଯଥା ବହୱୋ ଽପରାଧିନୋ ଜାତାସ୍ତଦ୍ୱଦ୍ ଏକସ୍ୟାଜ୍ଞାଚରଣାଦ୍ ବହୱଃ ସପୁଣ୍ୟୀକୃତା ଭୱନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","ଅଧିକନ୍ତୁ ୱ୍ୟୱସ୍ଥାଗମନାଦ୍ ଅପରାଧସ୍ୟ ବାହୁଲ୍ୟଂ ଜାତଂ କିନ୍ତୁ ଯତ୍ର ପାପସ୍ୟ ବାହୁଲ୍ୟଂ ତତ୍ରୈୱ ତସ୍ମାଦ୍ ଅନୁଗ୍ରହସ୍ୟ ବାହୁଲ୍ୟମ୍ ଅଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","ତେନ ମୃତ୍ୟୁନା ଯଦ୍ୱତ୍ ପାପସ୍ୟ ରାଜତ୍ୱମ୍ ଅଭୱତ୍ ତଦ୍ୱଦ୍ ଅସ୍ମାକଂ ପ୍ରଭୁଯୀଶୁଖ୍ରୀଷ୍ଟଦ୍ୱାରାନନ୍ତଜୀୱନଦାଯିପୁଣ୍ୟେନାନୁଗ୍ରହସ୍ୟ ରାଜତ୍ୱଂ ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","ପ୍ରଭୂତରୂପେଣ ଯଦ୍ ଅନୁଗ୍ରହଃ ପ୍ରକାଶତେ ତଦର୍ଥଂ ପାପେ ତିଷ୍ଠାମ ଇତି ୱାକ୍ୟଂ କିଂ ୱଯଂ ୱଦିଷ୍ୟାମଃ? ତନ୍ନ ଭୱତୁ| ");
INSERT INTO sanori_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","ପାପଂ ପ୍ରତି ମୃତା ୱଯଂ ପୁନସ୍ତସ୍ମିନ୍ କଥମ୍ ଜୀୱିଷ୍ୟାମଃ? ");
INSERT INTO sanori_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","ୱଯଂ ଯାୱନ୍ତୋ ଲୋକା ଯୀଶୁଖ୍ରୀଷ୍ଟେ ମଜ୍ଜିତା ଅଭୱାମ ତାୱନ୍ତ ଏୱ ତସ୍ୟ ମରଣେ ମଜ୍ଜିତା ଇତି କିଂ ଯୂଯଂ ନ ଜାନୀଥ? ");
INSERT INTO sanori_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","ତତୋ ଯଥା ପିତୁଃ ପରାକ୍ରମେଣ ଶ୍ମଶାନାତ୍ ଖ୍ରୀଷ୍ଟ ଉତ୍ଥାପିତସ୍ତଥା ୱଯମପି ଯତ୍ ନୂତନଜୀୱିନ ଇୱାଚରାମସ୍ତଦର୍ଥଂ ମଜ୍ଜନେନ ତେନ ସାର୍ଦ୍ଧଂ ମୃତ୍ୟୁରୂପେ ଶ୍ମଶାନେ ସଂସ୍ଥାପିତାଃ| ");
INSERT INTO sanori_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","ଅପରଂ ୱଯଂ ଯଦି ତେନ ସଂଯୁକ୍ତାଃ ସନ୍ତଃ ସ ଇୱ ମରଣଭାଗିନୋ ଜାତାସ୍ତର୍ହି ସ ଇୱୋତ୍ଥାନଭାଗିନୋଽପି ଭୱିଷ୍ୟାମଃ| ");
INSERT INTO sanori_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","ୱଯଂ ଯତ୍ ପାପସ୍ୟ ଦାସାଃ ପୁନ ର୍ନ ଭୱାମସ୍ତଦର୍ଥମ୍ ଅସ୍ମାକଂ ପାପରୂପଶରୀରସ୍ୟ ୱିନାଶାର୍ଥମ୍ ଅସ୍ମାକଂ ପୁରାତନପୁରୁଷସ୍ତେନ ସାକଂ କ୍ରୁଶେଽହନ୍ୟତେତି ୱଯଂ ଜାନୀମଃ| ");
INSERT INTO sanori_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","ଯୋ ହତଃ ସ ପାପାତ୍ ମୁକ୍ତ ଏୱ| ");
INSERT INTO sanori_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","ଅତଏୱ ଯଦି ୱଯଂ ଖ୍ରୀଷ୍ଟେନ ସାର୍ଦ୍ଧମ୍ ଅହନ୍ୟାମହି ତର୍ହି ପୁନରପି ତେନ ସହିତା ଜୀୱିଷ୍ୟାମ ଇତ୍ୟତ୍ରାସ୍ମାକଂ ୱିଶ୍ୱାସୋ ୱିଦ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","ଯତଃ ଶ୍ମଶାନାଦ୍ ଉତ୍ଥାପିତଃ ଖ୍ରୀଷ୍ଟୋ ପୁନ ର୍ନ ମ୍ରିଯତ ଇତି ୱଯଂ ଜାନୀମଃ| ତସ୍ମିନ୍ କୋପ୍ୟଧିକାରୋ ମୃତ୍ୟୋ ର୍ନାସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","ଅପରଞ୍ଚ ସ ଯଦ୍ ଅମ୍ରିଯତ ତେନୈକଦା ପାପମ୍ ଉଦ୍ଦିଶ୍ୟାମ୍ରିଯତ, ଯଚ୍ଚ ଜୀୱତି ତେନେଶ୍ୱରମ୍ ଉଦ୍ଦିଶ୍ୟ ଜୀୱତି; ");
INSERT INTO sanori_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","ତଦ୍ୱଦ୍ ଯୂଯମପି ସ୍ୱାନ୍ ପାପମ୍ ଉଦ୍ଦିଶ୍ୟ ମୃତାନ୍ ଅସ୍ମାକଂ ପ୍ରଭୁଣା ଯୀଶୁଖ୍ରୀଷ୍ଟେନେଶ୍ୱରମ୍ ଉଦ୍ଦିଶ୍ୟ ଜୀୱନ୍ତୋ ଜାନୀତ| ");
INSERT INTO sanori_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","ଅପରଞ୍ଚ କୁତ୍ସିତାଭିଲାଷାाନ୍ ପୂରଯିତୁଂ ଯୁଷ୍ମାକଂ ମର୍ତ୍ୟଦେହେଷୁ ପାପମ୍ ଆଧିପତ୍ୟଂ ନ କରୋତୁ| ");
INSERT INTO sanori_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","ଅପରଂ ସ୍ୱଂ ସ୍ୱମ୍ ଅଙ୍ଗମ୍ ଅଧର୍ମ୍ମସ୍ୟାସ୍ତ୍ରଂ କୃତ୍ୱା ପାପସେୱାଯାଂ ନ ସମର୍ପଯତ, କିନ୍ତୁ ଶ୍ମଶାନାଦ୍ ଉତ୍ଥିତାନିୱ ସ୍ୱାନ୍ ଈଶ୍ୱରେ ସମର୍ପଯତ ସ୍ୱାନ୍ୟଙ୍ଗାନି ଚ ଧର୍ମ୍ମାସ୍ତ୍ରସ୍ୱରୂପାଣୀଶ୍ୱରମ୍ ଉଦ୍ଦିଶ୍ୟ ସମର୍ପଯତ| ");
INSERT INTO sanori_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","ଯୁଷ୍ମାକମ୍ ଉପରି ପାପସ୍ୟାଧିପତ୍ୟଂ ପୁନ ର୍ନ ଭୱିଷ୍ୟତି, ଯସ୍ମାଦ୍ ଯୂଯଂ ୱ୍ୟୱସ୍ଥାଯା ଅନାଯତ୍ତା ଅନୁଗ୍ରହସ୍ୟ ଚାଯତ୍ତା ଅଭୱତ| ");
INSERT INTO sanori_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","କିନ୍ତୁ ୱଯଂ ୱ୍ୟୱସ୍ଥାଯା ଅନାଯତ୍ତା ଅନୁଗ୍ରହସ୍ୟ ଚାଯତ୍ତା ଅଭୱାମ, ଇତି କାରଣାତ୍ କିଂ ପାପଂ କରିଷ୍ୟାମଃ? ତନ୍ନ ଭୱତୁ| ");
INSERT INTO sanori_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","ଯତୋ ମୃତିଜନକଂ ପାପଂ ପୁଣ୍ୟଜନକଂ ନିଦେଶାଚରଣଞ୍ଚୈତଯୋର୍ଦ୍ୱଯୋ ର୍ୟସ୍ମିନ୍ ଆଜ୍ଞାପାଲନାର୍ଥଂ ଭୃତ୍ୟାନିୱ ସ୍ୱାନ୍ ସମର୍ପଯଥ, ତସ୍ୟୈୱ ଭୃତ୍ୟା ଭୱଥ, ଏତତ୍ କିଂ ଯୂଯଂ ନ ଜାନୀଥ? ");
INSERT INTO sanori_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","ଅପରଞ୍ଚ ପୂର୍ୱ୍ୱଂ ଯୂଯଂ ପାପସ୍ୟ ଭୃତ୍ୟା ଆସ୍ତେତି ସତ୍ୟଂ କିନ୍ତୁ ଯସ୍ୟାଂ ଶିକ୍ଷାରୂପାଯାଂ ମୂଷାଯାଂ ନିକ୍ଷିପ୍ତା ଅଭୱତ ତସ୍ୟା ଆକୃତିଂ ମନୋଭି ର୍ଲବ୍ଧୱନ୍ତ ଇତି କାରଣାଦ୍ ଈଶ୍ୱରସ୍ୟ ଧନ୍ୟୱାଦୋ ଭୱତୁ| ");
INSERT INTO sanori_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","ଇତ୍ଥଂ ଯୂଯଂ ପାପସେୱାତୋ ମୁକ୍ତାଃ ସନ୍ତୋ ଧର୍ମ୍ମସ୍ୟ ଭୃତ୍ୟା ଜାତାଃ| ");
INSERT INTO sanori_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","ଯୁଷ୍ମାକଂ ଶାରୀରିକ୍ୟା ଦୁର୍ବ୍ବଲତାଯା ହେତୋ ର୍ମାନୱୱଦ୍ ଅହମ୍ ଏତଦ୍ ବ୍ରୱୀମି; ପୁନଃ ପୁନରଧର୍ମ୍ମକରଣାର୍ଥଂ ଯଦ୍ୱତ୍ ପୂର୍ୱ୍ୱଂ ପାପାମେଧ୍ୟଯୋ ର୍ଭୃତ୍ୟତ୍ୱେ ନିଜାଙ୍ଗାନି ସମାର୍ପଯତ ତଦ୍ୱଦ୍ ଇଦାନୀଂ ସାଧୁକର୍ମ୍ମକରଣାର୍ଥଂ ଧର୍ମ୍ମସ୍ୟ ଭୃତ୍ୟତ୍ୱେ ନିଜାଙ୍ଗାନି ସମର୍ପଯତ| ");
INSERT INTO sanori_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","ଯଦା ଯୂଯଂ ପାପସ୍ୟ ଭୃତ୍ୟା ଆସ୍ତ ତଦା ଧର୍ମ୍ମସ୍ୟ ନାଯତ୍ତା ଆସ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","ତର୍ହି ଯାନି କର୍ମ୍ମାଣି ଯୂଯମ୍ ଇଦାନୀଂ ଲଜ୍ଜାଜନକାନି ବୁଧ୍ୟଧ୍ୱେ ପୂର୍ୱ୍ୱଂ ତୈ ର୍ୟୁଷ୍ମାକଂ କୋ ଲାଭ ଆସୀତ୍? ତେଷାଂ କର୍ମ୍ମଣାଂ ଫଲଂ ମରଣମେୱ| ");
INSERT INTO sanori_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","କିନ୍ତୁ ସାମ୍ପ୍ରତଂ ଯୂଯଂ ପାପସେୱାତୋ ମୁକ୍ତାଃ ସନ୍ତ ଈଶ୍ୱରସ୍ୟ ଭୃତ୍ୟାଽଭୱତ ତସ୍ମାଦ୍ ଯୁଷ୍ମାକଂ ପୱିତ୍ରତ୍ୱରୂପଂ ଲଭ୍ୟମ୍ ଅନନ୍ତଜୀୱନରୂପଞ୍ଚ ଫଲମ୍ ଆସ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","ଯତଃ ପାପସ୍ୟ ୱେତନଂ ମରଣଂ କିନ୍ତ୍ୱସ୍ମାକଂ ପ୍ରଭୁଣା ଯୀଶୁଖ୍ରୀଷ୍ଟେନାନନ୍ତଜୀୱନମ୍ ଈଶ୍ୱରଦତ୍ତଂ ପାରିତୋଷିକମ୍ ଆସ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","ହେ ଭ୍ରାତୃଗଣ ୱ୍ୟୱସ୍ଥାୱିଦଃ ପ୍ରତି ମମେଦଂ ନିୱେଦନଂ| ୱିଧିଃ କେୱଲଂ ଯାୱଜ୍ଜୀୱଂ ମାନୱୋପର୍ୟ୍ୟଧିପତିତ୍ୱଂ କରୋତୀତି ଯୂଯଂ କିଂ ନ ଜାନୀଥ? ");
INSERT INTO sanori_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","ଯାୱତ୍କାଲଂ ପତି ର୍ଜୀୱତି ତାୱତ୍କାଲମ୍ ଊଢା ଭାର୍ୟ୍ୟା ୱ୍ୟୱସ୍ଥଯା ତସ୍ମିନ୍ ବଦ୍ଧା ତିଷ୍ଠତି କିନ୍ତୁ ଯଦି ପତି ର୍ମ୍ରିଯତେ ତର୍ହି ସା ନାରୀ ପତ୍ୟୁ ର୍ୱ୍ୟୱସ୍ଥାତୋ ମୁଚ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","ଏତତ୍କାରଣାତ୍ ପତ୍ୟୁର୍ଜୀୱନକାଲେ ନାରୀ ଯଦ୍ୟନ୍ୟଂ ପୁରୁଷଂ ୱିୱହତି ତର୍ହି ସା ୱ୍ୟଭିଚାରିଣୀ ଭୱତି କିନ୍ତୁ ଯଦି ସ ପତି ର୍ମ୍ରିଯତେ ତର୍ହି ସା ତସ୍ୟା ୱ୍ୟୱସ୍ଥାଯା ମୁକ୍ତା ସତୀ ପୁରୁଷାନ୍ତରେଣ ୱ୍ୟୂଢାପି ୱ୍ୟଭିଚାରିଣୀ ନ ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","ହେ ମମ ଭ୍ରାତୃଗଣ, ଈଶ୍ୱରନିମିତ୍ତଂ ଯଦସ୍ମାକଂ ଫଲଂ ଜାଯତେ ତଦର୍ଥଂ ଶ୍ମଶାନାଦ୍ ଉତ୍ଥାପିତେନ ପୁରୁଷେଣ ସହ ଯୁଷ୍ମାକଂ ୱିୱାହୋ ଯଦ୍ ଭୱେତ୍ ତଦର୍ଥଂ ଖ୍ରୀଷ୍ଟସ୍ୟ ଶରୀରେଣ ଯୂଯଂ ୱ୍ୟୱସ୍ଥାଂ ପ୍ରତି ମୃତୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","ଯତୋଽସ୍ମାକଂ ଶାରୀରିକାଚରଣସମଯେ ମରଣନିମିତ୍ତଂ ଫଲମ୍ ଉତ୍ପାଦଯିତୁଂ ୱ୍ୟୱସ୍ଥଯା ଦୂଷିତଃ ପାପାଭିଲାଷୋଽସ୍ମାକମ୍ ଅଙ୍ଗେଷୁ ଜୀୱନ୍ ଆସୀତ୍| ");
INSERT INTO sanori_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","କିନ୍ତୁ ତଦା ଯସ୍ୟା ୱ୍ୟୱସ୍ଥାଯା ୱଶେ ଆସ୍ମହି ସାମ୍ପ୍ରତଂ ତାଂ ପ୍ରତି ମୃତତ୍ୱାଦ୍ ୱଯଂ ତସ୍ୟା ଅଧୀନତ୍ୱାତ୍ ମୁକ୍ତା ଇତି ହେତୋରୀଶ୍ୱରୋଽସ୍ମାଭିଃ ପୁରାତନଲିଖିତାନୁସାରାତ୍ ନ ସେୱିତୱ୍ୟଃ କିନ୍ତୁ ନୱୀନସ୍ୱଭାୱେନୈୱ ସେୱିତୱ୍ୟଃ ");
INSERT INTO sanori_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","ତର୍ହି ୱଯଂ କିଂ ବ୍ରୂମଃ? ୱ୍ୟୱସ୍ଥା କିଂ ପାପଜନିକା ଭୱତି? ନେତ୍ଥଂ ଭୱତୁ| ୱ୍ୟୱସ୍ଥାମ୍ ଅୱିଦ୍ୟମାନାଯାଂ ପାପଂ କିମ୍ ଇତ୍ୟହଂ ନାୱେଦଂ; କିଞ୍ଚ ଲୋଭଂ ମା କାର୍ଷୀରିତି ଚେଦ୍ ୱ୍ୟୱସ୍ଥାଗ୍ରନ୍ଥେ ଲିଖିତଂ ନାଭୱିଷ୍ୟତ୍ ତର୍ହି ଲୋଭଃ କିମ୍ଭୂତସ୍ତଦହଂ ନାଜ୍ଞାସ୍ୟଂ| ");
INSERT INTO sanori_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","କିନ୍ତୁ ୱ୍ୟୱସ୍ଥଯା ପାପଂ ଛିଦ୍ରଂ ପ୍ରାପ୍ୟାସ୍ମାକମ୍ ଅନ୍ତଃ ସର୍ୱ୍ୱୱିଧଂ କୁତ୍ସିତାଭିଲାଷମ୍ ଅଜନଯତ୍; ଯତୋ ୱ୍ୟୱସ୍ଥାଯାମ୍ ଅୱିଦ୍ୟମାନାଯାଂ ପାପଂ ମୃତଂ| ");
INSERT INTO sanori_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","ଅପରଂ ପୂର୍ୱ୍ୱଂ ୱ୍ୟୱସ୍ଥାଯାମ୍ ଅୱିଦ୍ୟମାନାଯାମ୍ ଅହମ୍ ଅଜୀୱଂ ତତଃ ପରମ୍ ଆଜ୍ଞାଯାମ୍ ଉପସ୍ଥିତାଯାମ୍ ପାପମ୍ ଅଜୀୱତ୍ ତଦାହମ୍ ଅମ୍ରିଯେ| ");
INSERT INTO sanori_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","ଇତ୍ଥଂ ସତି ଜୀୱନନିମିତ୍ତା ଯାଜ୍ଞା ସା ମମ ମୃତ୍ୟୁଜନିକାଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","ଯତଃ ପାପଂ ଛିଦ୍ରଂ ପ୍ରାପ୍ୟ ୱ୍ୟୱସ୍ଥିତାଦେଶେନ ମାଂ ୱଞ୍ଚଯିତ୍ୱା ତେନ ମାମ୍ ଅହନ୍| ");
INSERT INTO sanori_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","ଅତଏୱ ୱ୍ୟୱସ୍ଥା ପୱିତ୍ରା, ଆଦେଶଶ୍ଚ ପୱିତ୍ରୋ ନ୍ୟାଯ୍ୟୋ ହିତକାରୀ ଚ ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","ତର୍ହି ଯତ୍ ସ୍ୱଯଂ ହିତକୃତ୍ ତତ୍ କିଂ ମମ ମୃତ୍ୟୁଜନକମ୍ ଅଭୱତ୍? ନେତ୍ଥଂ ଭୱତୁ; କିନ୍ତୁ ପାପଂ ଯତ୍ ପାତକମିୱ ପ୍ରକାଶତେ ତଥା ନିଦେଶେନ ପାପଂ ଯଦତୀୱ ପାତକମିୱ ପ୍ରକାଶତେ ତଦର୍ଥଂ ହିତୋପାଯେନ ମମ ମରଣମ୍ ଅଜନଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","ୱ୍ୟୱସ୍ଥାତ୍ମବୋଧିକେତି ୱଯଂ ଜାନୀମଃ କିନ୍ତ୍ୱହଂ ଶାରୀରତାଚାରୀ ପାପସ୍ୟ କ୍ରୀତକିଙ୍କରୋ ୱିଦ୍ୟେ| ");
INSERT INTO sanori_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","ଯତୋ ଯତ୍ କର୍ମ୍ମ କରୋମି ତତ୍ ମମ ମନୋଽଭିମତଂ ନହି; ଅପରଂ ଯନ୍ ମମ ମନୋଽଭିମତଂ ତନ୍ନ କରୋମି କିନ୍ତୁ ଯଦ୍ ଋତୀଯେ ତତ୍ କରୋମି| ");
INSERT INTO sanori_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","ତଥାତ୍ୱେ ଯନ୍ ମମାନଭିମତଂ ତଦ୍ ଯଦି କରୋମି ତର୍ହି ୱ୍ୟୱସ୍ଥା ସୂତ୍ତମେତି ସ୍ୱୀକରୋମି| ");
INSERT INTO sanori_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","ଅତଏୱ ସମ୍ପ୍ରତି ତତ୍ କର୍ମ୍ମ ମଯା କ୍ରିଯତ ଇତି ନହି କିନ୍ତୁ ମମ ଶରୀରସ୍ଥେନ ପାପେନୈୱ କ୍ରିଯତେ| ");
INSERT INTO sanori_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","ଯତୋ ମଯି, ଅର୍ଥତୋ ମମ ଶରୀରେ, କିମପ୍ୟୁତ୍ତମଂ ନ ୱସତି, ଏତଦ୍ ଅହଂ ଜାନାମି; ମମେଚ୍ଛୁକତାଯାଂ ତିଷ୍ଠନ୍ତ୍ୟାମପ୍ୟହମ୍ ଉତ୍ତମକର୍ମ୍ମସାଧନେ ସମର୍ଥୋ ନ ଭୱାମି| ");
INSERT INTO sanori_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","ଯତୋ ଯାମୁତ୍ତମାଂ କ୍ରିଯାଂ କର୍ତ୍ତୁମହଂ ୱାଞ୍ଛାମି ତାଂ ନ କରୋମି କିନ୍ତୁ ଯତ୍ କୁତ୍ସିତଂ କର୍ମ୍ମ କର୍ତ୍ତୁମ୍ ଅନିଚ୍ଛୁକୋଽସ୍ମି ତଦେୱ କରୋମି| ");
INSERT INTO sanori_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","ଅତଏୱ ଯଦ୍ୟତ୍ କର୍ମ୍ମ କର୍ତ୍ତୁଂ ମମେଚ୍ଛା ନ ଭୱତି ତଦ୍ ଯଦି କରୋମି ତର୍ହି ତତ୍ ମଯା ନ କ୍ରିଯତେ, ମମାନ୍ତର୍ୱର୍ତ୍ତିନା ପାପେନୈୱ କ୍ରିଯତେ| ");
INSERT INTO sanori_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","ଭଦ୍ରଂ କର୍ତ୍ତୁମ୍ ଇଚ୍ଛୁକଂ ମାଂ ଯୋ ଽଭଦ୍ରଂ କର୍ତ୍ତୁଂ ପ୍ରୱର୍ତ୍ତଯତି ତାଦୃଶଂ ସ୍ୱଭାୱମେକଂ ମଯି ପଶ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","ଅହମ୍ ଆନ୍ତରିକପୁରୁଷେଣେଶ୍ୱରୱ୍ୟୱସ୍ଥାଯାଂ ସନ୍ତୁଷ୍ଟ ଆସେ; ");
INSERT INTO sanori_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","କିନ୍ତୁ ତଦ୍ୱିପରୀତଂ ଯୁଧ୍ୟନ୍ତଂ ତଦନ୍ୟମେକଂ ସ୍ୱଭାୱଂ ମଦୀଯାଙ୍ଗସ୍ଥିତଂ ପ୍ରପଶ୍ୟାମି, ସ ମଦୀଯାଙ୍ଗସ୍ଥିତପାପସ୍ୱଭାୱସ୍ୟାଯତ୍ତଂ ମାଂ କର୍ତ୍ତୁଂ ଚେଷ୍ଟତେ| ");
INSERT INTO sanori_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","ହା ହା ଯୋଽହଂ ଦୁର୍ଭାଗ୍ୟୋ ମନୁଜସ୍ତଂ ମାମ୍ ଏତସ୍ମାନ୍ ମୃତାଚ୍ଛରୀରାତ୍ କୋ ନିସ୍ତାରଯିଷ୍ୟତି? ");
INSERT INTO sanori_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","ଅସ୍ମାକଂ ପ୍ରଭୁଣା ଯୀଶୁଖ୍ରୀଷ୍ଟେନ ନିସ୍ତାରଯିତାରମ୍ ଈଶ୍ୱରଂ ଧନ୍ୟଂ ୱଦାମି| ଅତଏୱ ଶରୀରେଣ ପାପୱ୍ୟୱସ୍ଥାଯା ମନସା ତୁ ଈଶ୍ୱରୱ୍ୟୱସ୍ଥାଯାଃ ସେୱନଂ କରୋମି| ");
INSERT INTO sanori_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","ଯେ ଜନାଃ ଖ୍ରୀଷ୍ଟଂ ଯୀଶୁମ୍ ଆଶ୍ରିତ୍ୟ ଶାରୀରିକଂ ନାଚରନ୍ତ ଆତ୍ମିକମାଚରନ୍ତି ତେଽଧୁନା ଦଣ୍ଡାର୍ହା ନ ଭୱନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","ଜୀୱନଦାଯକସ୍ୟାତ୍ମନୋ ୱ୍ୟୱସ୍ଥା ଖ୍ରୀଷ୍ଟଯୀଶୁନା ପାପମରଣଯୋ ର୍ୱ୍ୟୱସ୍ଥାତୋ ମାମମୋଚଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","ଯସ୍ମାଚ୍ଛାରୀରସ୍ୟ ଦୁର୍ବ୍ବଲତ୍ୱାଦ୍ ୱ୍ୟୱସ୍ଥଯା ଯତ୍ କର୍ମ୍ମାସାଧ୍ୟମ୍ ଈଶ୍ୱରୋ ନିଜପୁତ୍ରଂ ପାପିଶରୀରରୂପଂ ପାପନାଶକବଲିରୂପଞ୍ଚ ପ୍ରେଷ୍ୟ ତସ୍ୟ ଶରୀରେ ପାପସ୍ୟ ଦଣ୍ଡଂ କୁର୍ୱ୍ୱନ୍ ତତ୍କର୍ମ୍ମ ସାଧିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","ତତଃ ଶାରୀରିକଂ ନାଚରିତ୍ୱାସ୍ମାଭିରାତ୍ମିକମ୍ ଆଚରଦ୍ଭିର୍ୱ୍ୟୱସ୍ଥାଗ୍ରନ୍ଥେ ନିର୍ଦ୍ଦିଷ୍ଟାନି ପୁଣ୍ୟକର୍ମ୍ମାଣି ସର୍ୱ୍ୱାଣି ସାଧ୍ୟନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","ଯେ ଶାରୀରିକାଚାରିଣସ୍ତେ ଶାରୀରିକାନ୍ ୱିଷଯାନ୍ ଭାୱଯନ୍ତି ଯେ ଚାତ୍ମିକାଚାରିଣସ୍ତେ ଆତ୍ମନୋ ୱିଷଯାନ୍ ଭାୱଯନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","ଶାରୀରିକଭାୱସ୍ୟ ଫଲଂ ମୃତ୍ୟୁଃ କିଞ୍ଚାତ୍ମିକଭାୱସ୍ୟ ଫଲେ ଜୀୱନଂ ଶାନ୍ତିଶ୍ଚ| ");
INSERT INTO sanori_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","ଯତଃ ଶାରୀରିକଭାୱ ଈଶ୍ୱରସ୍ୟ ୱିରୁଦ୍ଧଃ ଶତ୍ରୁତାଭାୱ ଏୱ ସ ଈଶ୍ୱରସ୍ୟ ୱ୍ୟୱସ୍ଥାଯା ଅଧୀନୋ ନ ଭୱତି ଭୱିତୁଞ୍ଚ ନ ଶକ୍ନୋତି| ");
INSERT INTO sanori_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","ଏତସ୍ମାତ୍ ଶାରୀରିକାଚାରିଷୁ ତୋଷ୍ଟୁମ୍ ଈଶ୍ୱରେଣ ନ ଶକ୍ୟଂ| ");
INSERT INTO sanori_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","କିନ୍ତ୍ୱୀଶ୍ୱରସ୍ୟାତ୍ମା ଯଦି ଯୁଷ୍ମାକଂ ମଧ୍ୟେ ୱସତି ତର୍ହି ଯୂଯଂ ଶାରୀରିକାଚାରିଣୋ ନ ସନ୍ତ ଆତ୍ମିକାଚାରିଣୋ ଭୱଥଃ| ଯସ୍ମିନ୍ ତୁ ଖ୍ରୀଷ୍ଟସ୍ୟାତ୍ମା ନ ୱିଦ୍ୟତେ ସ ତତ୍ସମ୍ଭୱୋ ନହି| ");
INSERT INTO sanori_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","ଯଦି ଖ୍ରୀଷ୍ଟୋ ଯୁଷ୍ମାନ୍ ଅଧିତିଷ୍ଠତି ତର୍ହି ପାପମ୍ ଉଦ୍ଦିଶ୍ୟ ଶରୀରଂ ମୃତଂ କିନ୍ତୁ ପୁଣ୍ୟମୁଦ୍ଦିଶ୍ୟାତ୍ମା ଜୀୱତି| ");
INSERT INTO sanori_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","ମୃତଗଣାଦ୍ ଯୀଶୁ ର୍ୟେନୋତ୍ଥାପିତସ୍ତସ୍ୟାତ୍ମା ଯଦି ଯୁଷ୍ମନ୍ମଧ୍ୟେ ୱସତି ତର୍ହି ମୃତଗଣାତ୍ ଖ୍ରୀଷ୍ଟସ୍ୟ ସ ଉତ୍ଥାପଯିତା ଯୁଷ୍ମନ୍ମଧ୍ୟୱାସିନା ସ୍ୱକୀଯାତ୍ମନା ଯୁଷ୍ମାକଂ ମୃତଦେହାନପି ପୁନ ର୍ଜୀୱଯିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","ହେ ଭ୍ରାତୃଗଣ ଶରୀରସ୍ୟ ୱଯମଧମର୍ଣା ନ ଭୱାମୋଽତଃ ଶାରୀରିକାଚାରୋଽସ୍ମାଭି ର୍ନ କର୍ତ୍ତୱ୍ୟଃ| ");
INSERT INTO sanori_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","ଯଦି ଯୂଯଂ ଶରୀରିକାଚାରିଣୋ ଭୱେତ ତର୍ହି ଯୁଷ୍ମାଭି ର୍ମର୍ତ୍ତୱ୍ୟମେୱ କିନ୍ତ୍ୱାତ୍ମନା ଯଦି ଶରୀରକର୍ମ୍ମାଣି ଘାତଯେତ ତର୍ହି ଜୀୱିଷ୍ୟଥ| ");
INSERT INTO sanori_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","ଯତୋ ଯାୱନ୍ତୋ ଲୋକା ଈଶ୍ୱରସ୍ୟାତ୍ମନାକୃଷ୍ୟନ୍ତେ ତେ ସର୍ୱ୍ୱ ଈଶ୍ୱରସ୍ୟ ସନ୍ତାନା ଭୱନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","ଯୂଯଂ ପୁନରପି ଭଯଜନକଂ ଦାସ୍ୟଭାୱଂ ନ ପ୍ରାପ୍ତାଃ କିନ୍ତୁ ଯେନ ଭାୱେନେଶ୍ୱରଂ ପିତଃ ପିତରିତି ପ୍ରୋଚ୍ୟ ସମ୍ବୋଧଯଥ ତାଦୃଶଂ ଦତ୍ତକପୁତ୍ରତ୍ୱଭାୱମ୍ ପ୍ରାପ୍ନୁତ| ");
INSERT INTO sanori_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","ଅପରଞ୍ଚ ୱଯମ୍ ଈଶ୍ୱରସ୍ୟ ସନ୍ତାନା ଏତସ୍ମିନ୍ ପୱିତ୍ର ଆତ୍ମା ସ୍ୱଯମ୍ ଅସ୍ମାକମ୍ ଆତ୍ମାଭିଃ ସାର୍ଦ୍ଧଂ ପ୍ରମାଣଂ ଦଦାତି| ");
INSERT INTO sanori_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","ଅତଏୱ ୱଯଂ ଯଦି ସନ୍ତାନାସ୍ତର୍ହ୍ୟଧିକାରିଣଃ, ଅର୍ଥାଦ୍ ଈଶ୍ୱରସ୍ୟ ସ୍ୱତ୍ତ୍ୱାଧିକାରିଣଃ ଖ୍ରୀଷ୍ଟେନ ସହାଧିକାରିଣଶ୍ଚ ଭୱାମଃ; ଅପରଂ ତେନ ସାର୍ଦ୍ଧଂ ଯଦି ଦୁଃଖଭାଗିନୋ ଭୱାମସ୍ତର୍ହି ତସ୍ୟ ୱିଭୱସ୍ୟାପି ଭାଗିନୋ ଭୱିଷ୍ୟାମଃ| ");
INSERT INTO sanori_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","କିନ୍ତ୍ୱସ୍ମାସୁ ଯୋ ଭାୱୀୱିଭୱଃ ପ୍ରକାଶିଷ୍ୟତେ ତସ୍ୟ ସମୀପେ ୱର୍ତ୍ତମାନକାଲୀନଂ ଦୁଃଖମହଂ ତୃଣାଯ ମନ୍ୟେ| ");
INSERT INTO sanori_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","ଯତଃ ପ୍ରାଣିଗଣ ଈଶ୍ୱରସ୍ୟ ସନ୍ତାନାନାଂ ୱିଭୱପ୍ରାପ୍ତିମ୍ ଆକାଙ୍କ୍ଷନ୍ ନିତାନ୍ତମ୍ ଅପେକ୍ଷତେ| ");
INSERT INTO sanori_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","ଅପରଞ୍ଚ ପ୍ରାଣିଗଣଃ ସ୍ୱୈରମ୍ ଅଲୀକତାଯା ୱଶୀକୃତୋ ନାଭୱତ୍ ");
INSERT INTO sanori_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","କିନ୍ତୁ ପ୍ରାଣିଗଣୋଽପି ନଶ୍ୱରତାଧୀନତ୍ୱାତ୍ ମୁକ୍ତଃ ସନ୍ ଈଶ୍ୱରସ୍ୟ ସନ୍ତାନାନାଂ ପରମମୁକ୍ତିଂ ପ୍ରାପ୍ସ୍ୟତୀତ୍ୟଭିପ୍ରାଯେଣ ୱଶୀକର୍ତ୍ରା ୱଶୀଚକ୍ରେ| ");
INSERT INTO sanori_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","ଅପରଞ୍ଚ ପ୍ରସୂଯମାନାୱଦ୍ ୱ୍ୟଥିତଃ ସନ୍ ଇଦାନୀଂ ଯାୱତ୍ କୃତ୍ସ୍ନଃ ପ୍ରାଣିଗଣ ଆର୍ତ୍ତସ୍ୱରଂ କରୋତୀତି ୱଯଂ ଜାନୀମଃ| ");
INSERT INTO sanori_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","କେୱଲଃ ସ ଇତି ନହି କିନ୍ତୁ ପ୍ରଥମଜାତଫଲସ୍ୱରୂପମ୍ ଆତ୍ମାନଂ ପ୍ରାପ୍ତା ୱଯମପି ଦତ୍ତକପୁତ୍ରତ୍ୱପଦପ୍ରାପ୍ତିମ୍ ଅର୍ଥାତ୍ ଶରୀରସ୍ୟ ମୁକ୍ତିଂ ପ୍ରତୀକ୍ଷମାଣାସ୍ତଦ୍ୱଦ୍ ଅନ୍ତରାର୍ତ୍ତରାୱଂ କୁର୍ମ୍ମଃ| ");
INSERT INTO sanori_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","ୱଯଂ ପ୍ରତ୍ୟାଶଯା ତ୍ରାଣମ୍ ଅଲଭାମହି କିନ୍ତୁ ପ୍ରତ୍ୟକ୍ଷୱସ୍ତୁନୋ ଯା ପ୍ରତ୍ୟାଶା ସା ପ୍ରତ୍ୟାଶା ନହି, ଯତୋ ମନୁଷ୍ୟୋ ଯତ୍ ସମୀକ୍ଷତେ ତସ୍ୟ ପ୍ରତ୍ୟାଶାଂ କୁତଃ କରିଷ୍ୟତି? ");
INSERT INTO sanori_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","ଯଦ୍ ଅପ୍ରତ୍ୟକ୍ଷଂ ତସ୍ୟ ପ୍ରତ୍ୟାଶାଂ ଯଦି ୱଯଂ କୁର୍ୱ୍ୱୀମହି ତର୍ହି ଧୈର୍ୟ୍ୟମ୍ ଅୱଲମ୍ବ୍ୟ ପ୍ରତୀକ୍ଷାମହେ| ");
INSERT INTO sanori_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","ତତ ଆତ୍ମାପି ସ୍ୱଯମ୍ ଅସ୍ମାକଂ ଦୁର୍ବ୍ବଲତାଯାଃ ସହାଯତ୍ୱଂ କରୋତି; ଯତଃ କିଂ ପ୍ରାର୍ଥିତୱ୍ୟଂ ତଦ୍ ବୋଦ୍ଧୁଂ ୱଯଂ ନ ଶକ୍ନୁମଃ, କିନ୍ତ୍ୱସ୍ପଷ୍ଟୈରାର୍ତ୍ତରାୱୈରାତ୍ମା ସ୍ୱଯମ୍ ଅସ୍ମନ୍ନିମିତ୍ତଂ ନିୱେଦଯତି| ");
INSERT INTO sanori_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","ଅପରମ୍ ଈଶ୍ୱରାଭିମତରୂପେଣ ପୱିତ୍ରଲୋକାନାଂ କୃତେ ନିୱେଦଯତି ଯ ଆତ୍ମା ତସ୍ୟାଭିପ୍ରାଯୋଽନ୍ତର୍ୟ୍ୟାମିନା ଜ୍ଞାଯତେ| ");
INSERT INTO sanori_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","ଅପରମ୍ ଈଶ୍ୱରୀଯନିରୂପଣାନୁସାରେଣାହୂତାଃ ସନ୍ତୋ ଯେ ତସ୍ମିନ୍ ପ୍ରୀଯନ୍ତେ ସର୍ୱ୍ୱାଣି ମିଲିତ୍ୱା ତେଷାଂ ମଙ୍ଗଲଂ ସାଧଯନ୍ତି, ଏତଦ୍ ୱଯଂ ଜାନୀମଃ| ");
INSERT INTO sanori_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","ଯତ ଈଶ୍ୱରୋ ବହୁଭ୍ରାତୃଣାଂ ମଧ୍ୟେ ସ୍ୱପୁତ୍ରଂ ଜ୍ୟେଷ୍ଠଂ କର୍ତ୍ତୁମ୍ ଇଚ୍ଛନ୍ ଯାନ୍ ପୂର୍ୱ୍ୱଂ ଲକ୍ଷ୍ୟୀକୃତୱାନ୍ ତାନ୍ ତସ୍ୟ ପ୍ରତିମୂର୍ତ୍ୟାଃ ସାଦୃଶ୍ୟପ୍ରାପ୍ତ୍ୟର୍ଥଂ ନ୍ୟଯୁଂକ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","ଅପରଞ୍ଚ ତେନ ଯେ ନିଯୁକ୍ତାସ୍ତ ଆହୂତା ଅପି ଯେ ଚ ତେନାହୂତାସ୍ତେ ସପୁଣ୍ୟୀକୃତାଃ, ଯେ ଚ ତେନ ସପୁଣ୍ୟୀକୃତାସ୍ତେ ୱିଭୱଯୁକ୍ତାଃ| ");
INSERT INTO sanori_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","ଇତ୍ୟତ୍ର ୱଯଂ କିଂ ବ୍ରୂମଃ? ଈଶ୍ୱରୋ ଯଦ୍ୟସ୍ମାକଂ ସପକ୍ଷୋ ଭୱତି ତର୍ହି କୋ ୱିପକ୍ଷୋଽସ୍ମାକଂ? ");
INSERT INTO sanori_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","ଆତ୍ମପୁତ୍ରଂ ନ ରକ୍ଷିତ୍ୱା ଯୋଽସ୍ମାକଂ ସର୍ୱ୍ୱେଷାଂ କୃତେ ତଂ ପ୍ରଦତ୍ତୱାନ୍ ସ କିଂ ତେନ ସହାସ୍ମଭ୍ୟମ୍ ଅନ୍ୟାନି ସର୍ୱ୍ୱାଣି ନ ଦାସ୍ୟତି? ");
INSERT INTO sanori_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","ଈଶ୍ୱରସ୍ୟାଭିରୁଚିତେଷୁ କେନ ଦୋଷ ଆରୋପଯିଷ୍ୟତେ? ଯ ଈଶ୍ୱରସ୍ତାନ୍ ପୁଣ୍ୟୱତ ଇୱ ଗଣଯତି କିଂ ତେନ? ");
INSERT INTO sanori_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","ଅପରଂ ତେଭ୍ୟୋ ଦଣ୍ଡଦାନାଜ୍ଞା ୱା କେନ କରିଷ୍ୟତେ? ଯୋଽସ୍ମନ୍ନିମିତ୍ତଂ ପ୍ରାଣାନ୍ ତ୍ୟକ୍ତୱାନ୍ କେୱଲଂ ତନ୍ନ କିନ୍ତୁ ମୃତଗଣମଧ୍ୟାଦ୍ ଉତ୍ଥିତୱାନ୍, ଅପି ଚେଶ୍ୱରସ୍ୟ ଦକ୍ଷିଣେ ପାର୍ଶ୍ୱେ ତିଷ୍ଠନ୍ ଅଦ୍ୟାପ୍ୟସ୍ମାକଂ ନିମିତ୍ତଂ ପ୍ରାର୍ଥତ ଏୱମ୍ଭୂତୋ ଯଃ ଖ୍ରୀଷ୍ଟଃ କିଂ ତେନ? ");
INSERT INTO sanori_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","ଅସ୍ମାଭିଃ ସହ ଖ୍ରୀଷ୍ଟସ୍ୟ ପ୍ରେମୱିଚ୍ଛେଦଂ ଜନଯିତୁଂ କଃ ଶକ୍ନୋତି? କ୍ଲେଶୋ ୱ୍ୟସନଂ ୱା ତାଡନା ୱା ଦୁର୍ଭିକ୍ଷଂ ୱା ୱସ୍ତ୍ରହୀନତ୍ୱଂ ୱା ପ୍ରାଣସଂଶଯୋ ୱା ଖଙ୍ଗୋ ୱା କିମେତାନି ଶକ୍ନୁୱନ୍ତି? ");
INSERT INTO sanori_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","କିନ୍ତୁ ଲିଖିତମ୍ ଆସ୍ତେ, ଯଥା, ୱଯଂ ତୱ ନିମିତ୍ତଂ ସ୍ମୋ ମୃତ୍ୟୁୱକ୍ତ୍ରେଽଖିଲଂ ଦିନଂ| ବଲିର୍ଦେଯୋ ଯଥା ମେଷୋ ୱଯଂ ଗଣ୍ୟାମହେ ତଥା| ");
INSERT INTO sanori_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","ଅପରଂ ଯୋଽସ୍ମାସୁ ପ୍ରୀଯତେ ତେନୈତାସୁ ୱିପତ୍ସୁ ୱଯଂ ସମ୍ୟଗ୍ ୱିଜଯାମହେ| ");
INSERT INTO sanori_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","ଯତୋଽସ୍ମାକଂ ପ୍ରଭୁନା ଯୀଶୁଖ୍ରୀଷ୍ଟେନେଶ୍ୱରସ୍ୟ ଯତ୍ ପ୍ରେମ ତସ୍ମାଦ୍ ଅସ୍ମାକଂ ୱିଚ୍ଛେଦଂ ଜନଯିତୁଂ ମୃତ୍ୟୁ ର୍ଜୀୱନଂ ୱା ଦିୱ୍ୟଦୂତା ୱା ବଲୱନ୍ତୋ ମୁଖ୍ୟଦୂତା ୱା ୱର୍ତ୍ତମାନୋ ୱା ଭୱିଷ୍ୟନ୍ କାଲୋ ୱା ଉଚ୍ଚପଦଂ ୱା ନୀଚପଦଂ ୱାପରଂ କିମପି ସୃଷ୍ଟୱସ୍ତୁ ");
INSERT INTO sanori_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ୱୈତେଷାଂ କେନାପି ନ ଶକ୍ୟମିତ୍ୟସ୍ମିନ୍ ଦୃଢୱିଶ୍ୱାସୋ ମମାସ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","ଅହଂ କାଞ୍ଚିଦ୍ କଲ୍ପିତାଂ କଥାଂ ନ କଥଯାମି, ଖ୍ରୀଷ୍ଟସ୍ୟ ସାକ୍ଷାତ୍ ସତ୍ୟମେୱ ବ୍ରୱୀମି ପୱିତ୍ରସ୍ୟାତ୍ମନଃ ସାକ୍ଷାନ୍ ମଦୀଯଂ ମନ ଏତତ୍ ସାକ୍ଷ୍ୟଂ ଦଦାତି| ");
INSERT INTO sanori_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","ମମାନ୍ତରତିଶଯଦୁଃଖଂ ନିରନ୍ତରଂ ଖେଦଶ୍ଚ ");
INSERT INTO sanori_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","ତସ୍ମାଦ୍ ଅହଂ ସ୍ୱଜାତୀଯଭ୍ରାତୃଣାଂ ନିମିତ୍ତାତ୍ ସ୍ୱଯଂ ଖ୍ରୀଷ୍ଟାଚ୍ଛାପାକ୍ରାନ୍ତୋ ଭୱିତୁମ୍ ଐଚ୍ଛମ୍| ");
INSERT INTO sanori_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","ଯତସ୍ତ ଇସ୍ରାଯେଲସ୍ୟ ୱଂଶା ଅପି ଚ ଦତ୍ତକପୁତ୍ରତ୍ୱଂ ତେଜୋ ନିଯମୋ ୱ୍ୟୱସ୍ଥାଦାନଂ ମନ୍ଦିରେ ଭଜନଂ ପ୍ରତିଜ୍ଞାଃ ପିତୃପୁରୁଷଗଣଶ୍ଚୈତେଷୁ ସର୍ୱ୍ୱେଷୁ ତେଷାମ୍ ଅଧିକାରୋଽସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","ତତ୍ କେୱଲଂ ନହି କିନ୍ତୁ ସର୍ୱ୍ୱାଧ୍ୟକ୍ଷଃ ସର୍ୱ୍ୱଦା ସଚ୍ଚିଦାନନ୍ଦ ଈଶ୍ୱରୋ ଯଃ ଖ୍ରୀଷ୍ଟଃ ସୋଽପି ଶାରୀରିକସମ୍ବନ୍ଧେନ ତେଷାଂ ୱଂଶସମ୍ଭୱଃ| ");
INSERT INTO sanori_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","ଈଶ୍ୱରସ୍ୟ ୱାକ୍ୟଂ ୱିଫଲଂ ଜାତମ୍ ଇତି ନହି ଯତ୍କାରଣାଦ୍ ଇସ୍ରାଯେଲୋ ୱଂଶେ ଯେ ଜାତାସ୍ତେ ସର୍ୱ୍ୱେ ୱସ୍ତୁତ ଇସ୍ରାଯେଲୀଯା ନ ଭୱନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","ଅପରମ୍ ଇବ୍ରାହୀମୋ ୱଂଶେ ଜାତା ଅପି ସର୍ୱ୍ୱେ ତସ୍ୟୈୱ ସନ୍ତାନା ନ ଭୱନ୍ତି କିନ୍ତୁ ଇସ୍ହାକୋ ନାମ୍ନା ତୱ ୱଂଶୋ ୱିଖ୍ୟାତୋ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","ଅର୍ଥାତ୍ ଶାରୀରିକସଂସର୍ଗାତ୍ ଜାତାଃ ସନ୍ତାନା ଯାୱନ୍ତସ୍ତାୱନ୍ତ ଏୱେଶ୍ୱରସ୍ୟ ସନ୍ତାନା ନ ଭୱନ୍ତି କିନ୍ତୁ ପ୍ରତିଶ୍ରୱଣାଦ୍ ଯେ ଜାଯନ୍ତେ ତଏୱେଶ୍ୱରୱଂଶୋ ଗଣ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","ଯତସ୍ତତ୍ପ୍ରତିଶ୍ରୁତେ ର୍ୱାକ୍ୟମେତତ୍, ଏତାଦୃଶେ ସମଯେ ଽହଂ ପୁନରାଗମିଷ୍ୟାମି ତତ୍ପୂର୍ୱ୍ୱଂ ସାରାଯାଃ ପୁତ୍ର ଏକୋ ଜନିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","ଅପରମପି ୱଦାମି ସ୍ୱମନୋଽଭିଲାଷତ ଈଶ୍ୱରେଣ ଯନ୍ନିରୂପିତଂ ତତ୍ କର୍ମ୍ମତୋ ନହି କିନ୍ତ୍ୱାହ୍ୱଯିତୁ ର୍ଜାତମେତଦ୍ ଯଥା ସିଦ୍ଧ୍ୟତି ");
INSERT INTO sanori_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","ତଦର୍ଥଂ ରିବ୍କାନାମିକଯା ଯୋଷିତା ଜନୈକସ୍ମାଦ୍ ଅର୍ଥାଦ୍ ଅସ୍ମାକମ୍ ଇସ୍ହାକଃ ପୂର୍ୱ୍ୱପୁରୁଷାଦ୍ ଗର୍ଭେ ଧୃତେ ତସ୍ୟାଃ ସନ୍ତାନଯୋଃ ପ୍ରସୱାତ୍ ପୂର୍ୱ୍ୱଂ କିଞ୍ଚ ତଯୋଃ ଶୁଭାଶୁଭକର୍ମ୍ମଣଃ କରଣାତ୍ ପୂର୍ୱ୍ୱଂ ");
INSERT INTO sanori_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","ତାଂ ପ୍ରତୀଦଂ ୱାକ୍ୟମ୍ ଉକ୍ତଂ, ଜ୍ୟେଷ୍ଠଃ କନିଷ୍ଠଂ ସେୱିଷ୍ୟତେ, ");
INSERT INTO sanori_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","ଯଥା ଲିଖିତମ୍ ଆସ୍ତେ, ତଥାପ୍ୟେଷାୱି ନ ପ୍ରୀତ୍ୱା ଯାକୂବି ପ୍ରୀତୱାନ୍ ଅହଂ| ");
INSERT INTO sanori_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","ତର୍ହି ୱଯଂ କିଂ ବ୍ରୂମଃ? ଈଶ୍ୱରଃ କିମ୍ ଅନ୍ୟାଯକାରୀ? ତଥା ନ ଭୱତୁ| ");
INSERT INTO sanori_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","ଯତଃ ସ ସ୍ୱଯଂ ମୂସାମ୍ ଅୱଦତ୍; ଅହଂ ଯସ୍ମିନ୍ ଅନୁଗ୍ରହଂ ଚିକୀର୍ଷାମି ତମେୱାନୁଗୃହ୍ଲାମି, ଯଞ୍ଚ ଦଯିତୁମ୍ ଇଚ୍ଛାମି ତମେୱ ଦଯେ| ");
INSERT INTO sanori_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","ଅତଏୱେଚ୍ଛତା ଯତମାନେନ ୱା ମାନୱେନ ତନ୍ନ ସାଧ୍ୟତେ ଦଯାକାରିଣେଶ୍ୱରେଣୈୱ ସାଧ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","ଫିରୌଣି ଶାସ୍ତ୍ରେ ଲିଖତି, ଅହଂ ତ୍ୱଦ୍ଦ୍ୱାରା ମତ୍ପରାକ୍ରମଂ ଦର୍ଶଯିତୁଂ ସର୍ୱ୍ୱପୃଥିୱ୍ୟାଂ ନିଜନାମ ପ୍ରକାଶଯିତୁଞ୍ଚ ତ୍ୱାଂ ସ୍ଥାପିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","ଅତଃ ସ ଯମ୍ ଅନୁଗ୍ରହୀତୁମ୍ ଇଚ୍ଛତି ତମେୱାନୁଗୃହ୍ଲାତି, ଯଞ୍ଚ ନିଗ୍ରହୀତୁମ୍ ଇଚ୍ଛତି ତଂ ନିଗୃହ୍ଲାତି| ");
INSERT INTO sanori_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","ଯଦି ୱଦସି ତର୍ହି ସ ଦୋଷଂ କୁତୋ ଗୃହ୍ଲାତି? ତଦୀଯେଚ୍ଛାଯାଃ ପ୍ରତିବନ୍ଧକତ୍ୱଂ କର୍ତ୍ତଂ କସ୍ୟ ସାମର୍ଥ୍ୟଂ ୱିଦ୍ୟତେ? ");
INSERT INTO sanori_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","ହେ ଈଶ୍ୱରସ୍ୟ ପ୍ରତିପକ୍ଷ ମର୍ତ୍ୟ ତ୍ୱଂ କଃ? ଏତାଦୃଶଂ ମାଂ କୁତଃ ସୃଷ୍ଟୱାନ୍? ଇତି କଥାଂ ସୃଷ୍ଟୱସ୍ତୁ ସ୍ରଷ୍ଟ୍ରେ କିଂ କଥଯିଷ୍ୟତି? ");
INSERT INTO sanori_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","ଏକସ୍ମାନ୍ ମୃତ୍ପିଣ୍ଡାଦ୍ ଉତ୍କୃଷ୍ଟାପକୃଷ୍ଟୌ ଦ୍ୱିୱିଧୌ କଲଶୌ କର୍ତ୍ତୁଂ କିଂ କୁଲାଲସ୍ୟ ସାମର୍ଥ୍ୟଂ ନାସ୍ତି? ");
INSERT INTO sanori_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","ଈଶ୍ୱରଃ କୋପଂ ପ୍ରକାଶଯିତୁଂ ନିଜଶକ୍ତିଂ ଜ୍ଞାପଯିତୁଞ୍ଚେଚ୍ଛନ୍ ଯଦି ୱିନାଶସ୍ୟ ଯୋଗ୍ୟାନି କ୍ରୋଧଭାଜନାନି ପ୍ରତି ବହୁକାଲଂ ଦୀର୍ଘସହିଷ୍ଣୁତାମ୍ ଆଶ୍ରଯତି; ");
INSERT INTO sanori_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","ଅପରଞ୍ଚ ୱିଭୱପ୍ରାପ୍ତ୍ୟର୍ଥଂ ପୂର୍ୱ୍ୱଂ ନିଯୁକ୍ତାନ୍ୟନୁଗ୍ରହପାତ୍ରାଣି ପ୍ରତି ନିଜୱିଭୱସ୍ୟ ବାହୁଲ୍ୟଂ ପ୍ରକାଶଯିତୁଂ କେୱଲଯିହୂଦିନାଂ ନହି ଭିନ୍ନଦେଶିନାମପି ମଧ୍ୟାଦ୍ ");
INSERT INTO sanori_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","ଅସ୍ମାନିୱ ତାନ୍ୟାହ୍ୱଯତି ତତ୍ର ତୱ କିଂ? ");
INSERT INTO sanori_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","ହୋଶେଯଗ୍ରନ୍ଥେ ଯଥା ଲିଖିତମ୍ ଆସ୍ତେ, ଯୋ ଲୋକୋ ମମ ନାସୀତ୍ ତଂ ୱଦିଷ୍ୟାମି ମଦୀଯକଂ| ଯା ଜାତି ର୍ମେଽପ୍ରିଯା ଚାସୀତ୍ ତାଂ ୱଦିଷ୍ୟାମ୍ୟହଂ ପ୍ରିଯାଂ| ");
INSERT INTO sanori_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","ଯୂଯଂ ମଦୀଯଲୋକା ନ ଯତ୍ରେତି ୱାକ୍ୟମୌଚ୍ୟତ| ଅମରେଶସ୍ୟ ସନ୍ତାନା ଇତି ଖ୍ୟାସ୍ୟନ୍ତି ତତ୍ର ତେ| ");
INSERT INTO sanori_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","ଇସ୍ରାଯେଲୀଯଲୋକେଷୁ ଯିଶାଯିଯୋଽପି ୱାଚମେତାଂ ପ୍ରାଚାରଯତ୍, ଇସ୍ରାଯେଲୀଯୱଂଶାନାଂ ଯା ସଂଖ୍ୟା ସା ତୁ ନିଶ୍ଚିତଂ| ସମୁଦ୍ରସିକତାସଂଖ୍ୟାସମାନା ଯଦି ଜାଯତେ| ତଥାପି କେୱଲଂ ଲୋକୈରଲ୍ପୈସ୍ତ୍ରାଣଂ ୱ୍ରଜିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","ଯତୋ ନ୍ୟାଯେନ ସ୍ୱଂ କର୍ମ୍ମ ପରେଶଃ ସାଧଯିଷ୍ୟତି| ଦେଶେ ସଏୱ ସଂକ୍ଷେପାନ୍ନିଜଂ କର୍ମ୍ମ କରିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","ଯିଶାଯିଯୋଽପରମପି କଥଯାମାସ, ସୈନ୍ୟାଧ୍ୟକ୍ଷପରେଶେନ ଚେତ୍ କିଞ୍ଚିନ୍ନୋଦଶିଷ୍ୟତ| ତଦା ୱଯଂ ସିଦୋମେୱାଭୱିଷ୍ୟାମ ୱିନିଶ୍ଚିତଂ| ଯଦ୍ୱା ୱଯମ୍ ଅମୋରାଯା ଅଗମିଷ୍ୟାମ ତୁଲ୍ୟତାଂ| ");
INSERT INTO sanori_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","ତର୍ହି ୱଯଂ କିଂ ୱକ୍ଷ୍ୟାମଃ? ଇତରଦେଶୀଯା ଲୋକା ଅପି ପୁଣ୍ୟାର୍ଥମ୍ ଅଯତମାନା ୱିଶ୍ୱାସେନ ପୁଣ୍ୟମ୍ ଅଲଭନ୍ତ; ");
INSERT INTO sanori_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","କିନ୍ତ୍ୱିସ୍ରାଯେଲ୍ଲୋକା ୱ୍ୟୱସ୍ଥାପାଲନେନ ପୁଣ୍ୟାର୍ଥଂ ଯତମାନାସ୍ତନ୍ ନାଲଭନ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","ତସ୍ୟ କିଂ କାରଣଂ? ତେ ୱିଶ୍ୱାସେନ ନହି କିନ୍ତୁ ୱ୍ୟୱସ୍ଥାଯାଃ କ୍ରିଯଯା ଚେଷ୍ଟିତ୍ୱା ତସ୍ମିନ୍ ସ୍ଖଲନଜନକେ ପାଷାଣେ ପାଦସ୍ଖଲନଂ ପ୍ରାପ୍ତାଃ| ");
INSERT INTO sanori_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","ଲିଖିତଂ ଯାଦୃଶମ୍ ଆସ୍ତେ, ପଶ୍ୟ ପାଦସ୍ଖଲାର୍ଥଂ ହି ସୀଯୋନି ପ୍ରସ୍ତରନ୍ତଥା| ବାଧାକାରଞ୍ଚ ପାଷାଣଂ ପରିସ୍ଥାପିତୱାନହମ୍| ୱିଶ୍ୱସିଷ୍ୟତି ଯସ୍ତତ୍ର ସ ଜନୋ ନ ତ୍ରପିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","ହେ ଭ୍ରାତର ଇସ୍ରାଯେଲୀଯଲୋକା ଯତ୍ ପରିତ୍ରାଣଂ ପ୍ରାପ୍ନୁୱନ୍ତି ତଦହଂ ମନସାଭିଲଷନ୍ ଈଶ୍ୱରସ୍ୟ ସମୀପେ ପ୍ରାର୍ଥଯେ| ");
INSERT INTO sanori_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","ଯତ ଈଶ୍ୱରେ ତେଷାଂ ଚେଷ୍ଟା ୱିଦ୍ୟତ ଇତ୍ୟତ୍ରାହଂ ସାକ୍ଷ୍ୟସ୍ମି; କିନ୍ତୁ ତେଷାଂ ସା ଚେଷ୍ଟା ସଜ୍ଞାନା ନହି, ");
INSERT INTO sanori_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","ଯତସ୍ତ ଈଶ୍ୱରଦତ୍ତଂ ପୁଣ୍ୟମ୍ ଅୱିଜ୍ଞାଯ ସ୍ୱକୃତପୁଣ୍ୟଂ ସ୍ଥାପଯିତୁମ୍ ଚେଷ୍ଟମାନା ଈଶ୍ୱରଦତ୍ତସ୍ୟ ପୁଣ୍ୟସ୍ୟ ନିଘ୍ନତ୍ୱଂ ନ ସ୍ୱୀକୁର୍ୱ୍ୱନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","ଖ୍ରୀଷ୍ଟ ଏକୈକୱିଶ୍ୱାସିଜନାଯ ପୁଣ୍ୟଂ ଦାତୁଂ ୱ୍ୟୱସ୍ଥାଯାଃ ଫଲସ୍ୱରୂପୋ ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","ୱ୍ୟୱସ୍ଥାପାଲନେନ ଯତ୍ ପୁଣ୍ୟଂ ତତ୍ ମୂସା ୱର୍ଣଯାମାସ, ଯଥା, ଯୋ ଜନସ୍ତାଂ ପାଲଯିଷ୍ୟତି ସ ତଦ୍ଦ୍ୱାରା ଜୀୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","କିନ୍ତୁ ପ୍ରତ୍ୟଯେନ ଯତ୍ ପୁଣ୍ୟଂ ତଦ୍ ଏତାଦୃଶଂ ୱାକ୍ୟଂ ୱଦତି, କଃ ସ୍ୱର୍ଗମ୍ ଆରୁହ୍ୟ ଖ୍ରୀଷ୍ଟମ୍ ଅୱରୋହଯିଷ୍ୟତି? ");
INSERT INTO sanori_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","କୋ ୱା ପ୍ରେତଲୋକମ୍ ଅୱରୁହ୍ୟ ଖ୍ରୀଷ୍ଟଂ ମୃତଗଣମଧ୍ୟାଦ୍ ଆନେଷ୍ୟତୀତି ୱାକ୍ ମନସି ତ୍ୱଯା ନ ଗଦିତୱ୍ୟା| ");
INSERT INTO sanori_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","ତର୍ହି କିଂ ବ୍ରୱୀତି? ତଦ୍ ୱାକ୍ୟଂ ତୱ ସମୀପସ୍ଥମ୍ ଅର୍ଥାତ୍ ତୱ ୱଦନେ ମନସି ଚାସ୍ତେ, ତଚ୍ଚ ୱାକ୍ୟମ୍ ଅସ୍ମାଭିଃ ପ୍ରଚାର୍ୟ୍ୟମାଣଂ ୱିଶ୍ୱାସସ୍ୟ ୱାକ୍ୟମେୱ| ");
INSERT INTO sanori_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","ୱସ୍ତୁତଃ ପ୍ରଭୁଂ ଯୀଶୁଂ ଯଦି ୱଦନେନ ସ୍ୱୀକରୋଷି, ତଥେଶ୍ୱରସ୍ତଂ ଶ୍ମଶାନାଦ୍ ଉଦସ୍ଥାପଯଦ୍ ଇତି ଯଦ୍ୟନ୍ତଃକରଣେନ ୱିଶ୍ୱସିଷି ତର୍ହି ପରିତ୍ରାଣଂ ଲପ୍ସ୍ୟସେ| ");
INSERT INTO sanori_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","ଯସ୍ମାତ୍ ପୁଣ୍ୟପ୍ରାପ୍ତ୍ୟର୍ଥମ୍ ଅନ୍ତଃକରଣେନ ୱିଶ୍ୱସିତୱ୍ୟଂ ପରିତ୍ରାଣାର୍ଥଞ୍ଚ ୱଦନେନ ସ୍ୱୀକର୍ତ୍ତୱ୍ୟଂ| ");
INSERT INTO sanori_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","ଶାସ୍ତ୍ରେ ଯାଦୃଶଂ ଲିଖତି ୱିଶ୍ୱସିଷ୍ୟତି ଯସ୍ତତ୍ର ସ ଜନୋ ନ ତ୍ରପିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","ଇତ୍ୟତ୍ର ଯିହୂଦିନି ତଦନ୍ୟଲୋକେ ଚ କୋପି ୱିଶେଷୋ ନାସ୍ତି ଯସ୍ମାଦ୍ ଯଃ ସର୍ୱ୍ୱେଷାମ୍ ଅଦ୍ୱିତୀଯଃ ପ୍ରଭୁଃ ସ ନିଜଯାଚକାନ ସର୍ୱ୍ୱାନ୍ ପ୍ରତି ୱଦାନ୍ୟୋ ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","ଯତଃ, ଯଃ କଶ୍ଚିତ୍ ପରମେଶସ୍ୟ ନାମ୍ନା ହି ପ୍ରାର୍ଥଯିଷ୍ୟତେ| ସ ଏୱ ମନୁଜୋ ନୂନଂ ପରିତ୍ରାତୋ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","ଯଂ ଯେ ଜନା ନ ପ୍ରତ୍ୟାଯନ୍ ତେ ତମୁଦ୍ଦିଶ୍ୟ କଥଂ ପ୍ରାର୍ଥଯିଷ୍ୟନ୍ତେ? ଯେ ୱା ଯସ୍ୟାଖ୍ୟାନଂ କଦାପି ନ ଶ୍ରୁତୱନ୍ତସ୍ତେ ତଂ କଥଂ ପ୍ରତ୍ୟେଷ୍ୟନ୍ତି? ଅପରଂ ଯଦି ପ୍ରଚାରଯିତାରୋ ନ ତିଷ୍ଠନ୍ତି ତଦା କଥଂ ତେ ଶ୍ରୋଷ୍ୟନ୍ତି? ");
INSERT INTO sanori_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","ଯଦି ୱା ପ୍ରେରିତା ନ ଭୱନ୍ତି ତଦା କଥଂ ପ୍ରଚାରଯିଷ୍ୟନ୍ତି? ଯାଦୃଶଂ ଲିଖିତମ୍ ଆସ୍ତେ, ଯଥା, ମାଙ୍ଗଲିକଂ ସୁସଂୱାଦଂ ଦଦତ୍ୟାନୀଯ ଯେ ନରାଃ| ପ୍ରଚାରଯନ୍ତି ଶାନ୍ତେଶ୍ଚ ସୁସଂୱାଦଂ ଜନାସ୍ତୁ ଯେ| ତେଷାଂ ଚରଣପଦ୍ମାନି କୀଦୃକ୍ ଶୋଭାନ୍ୱିତାନି ହି| ");
INSERT INTO sanori_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","କିନ୍ତୁ ତେ ସର୍ୱ୍ୱେ ତଂ ସୁସଂୱାଦଂ ନ ଗୃହୀତୱନ୍ତଃ| ଯିଶାଯିଯୋ ଯଥା ଲିଖିତୱାନ୍| ଅସ୍ମତ୍ପ୍ରଚାରିତେ ୱାକ୍ୟେ ୱିଶ୍ୱାସମକରୋଦ୍ଧି କଃ| ");
INSERT INTO sanori_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","ଅତଏୱ ଶ୍ରୱଣାଦ୍ ୱିଶ୍ୱାସ ଐଶ୍ୱରୱାକ୍ୟପ୍ରଚାରାତ୍ ଶ୍ରୱଣଞ୍ଚ ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","ତର୍ହ୍ୟହଂ ବ୍ରୱୀମି ତୈଃ କିଂ ନାଶ୍ରାୱି? ଅୱଶ୍ୟମ୍ ଅଶ୍ରାୱି, ଯସ୍ମାତ୍ ତେଷାଂ ଶବ୍ଦୋ ମହୀଂ ୱ୍ୟାପ୍ନୋଦ୍ ୱାକ୍ୟଞ୍ଚ ନିଖିଲଂ ଜଗତ୍| ");
INSERT INTO sanori_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","ଅପରମପି ୱଦାମି, ଇସ୍ରାଯେଲୀଯଲୋକାଃ କିମ୍ ଏତାଂ କଥାଂ ନ ବୁଧ୍ୟନ୍ତେ? ପ୍ରଥମତୋ ମୂସା ଇଦଂ ୱାକ୍ୟଂ ପ୍ରୋୱାଚ, ଅହମୁତ୍ତାପଯିଷ୍ୟେ ତାନ୍ ଅଗଣ୍ୟମାନୱୈରପି| କ୍ଲେକ୍ଷ୍ୟାମି ଜାତିମ୍ ଏତାଞ୍ଚ ପ୍ରୋନ୍ମତ୍ତଭିନ୍ନଜାତିଭିଃ| ");
INSERT INTO sanori_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","ଅପରଞ୍ଚ ଯିଶାଯିଯୋଽତିଶଯାକ୍ଷୋଭେଣ କଥଯାମାସ, ଯଥା, ଅଧି ମାଂ ଯୈସ୍ତୁ ନାଚେଷ୍ଟି ସମ୍ପ୍ରାପ୍ତସ୍ତୈ ର୍ଜନୈରହଂ| ଅଧି ମାଂ ଯୈ ର୍ନ ସମ୍ପୃଷ୍ଟଂ ୱିଜ୍ଞାତସ୍ତୈ ର୍ଜନୈରହଂ|| ");
INSERT INTO sanori_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","କିନ୍ତ୍ୱିସ୍ରାଯେଲୀଯଲୋକାନ୍ ଅଧି କଥଯାଞ୍ଚକାର, ଯୈରାଜ୍ଞାଲଙ୍ଘିଭି ର୍ଲୋକୈ ର୍ୱିରୁଦ୍ଧଂ ୱାକ୍ୟମୁଚ୍ୟତେ| ତାନ୍ ପ୍ରତ୍ୟେୱ ଦିନଂ କୃତ୍ସ୍ନଂ ହସ୍ତୌ ୱିସ୍ତାରଯାମ୍ୟହଂ|| ");
INSERT INTO sanori_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","ଈଶ୍ୱରେଣ ସ୍ୱୀକୀଯଲୋକା ଅପସାରିତା ଅହଂ କିମ୍ ଈଦୃଶଂ ୱାକ୍ୟଂ ବ୍ରୱୀମି? ତନ୍ନ ଭୱତୁ ଯତୋଽହମପି ବିନ୍ୟାମୀନଗୋତ୍ରୀଯ ଇବ୍ରାହୀମୱଂଶୀଯ ଇସ୍ରାଯେଲୀଯଲୋକୋଽସ୍ମି| ");
INSERT INTO sanori_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","ଈଶ୍ୱରେଣ ପୂର୍ୱ୍ୱଂ ଯେ ପ୍ରଦୃଷ୍ଟାସ୍ତେ ସ୍ୱକୀଯଲୋକା ଅପସାରିତା ଇତି ନହି| ଅପରମ୍ ଏଲିଯୋପାଖ୍ୟାନେ ଶାସ୍ତ୍ରେ ଯଲ୍ଲିଖିତମ୍ ଆସ୍ତେ ତଦ୍ ଯୂଯଂ କିଂ ନ ଜାନୀଥ? ");
INSERT INTO sanori_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","ହେ ପରମେଶ୍ୱର ଲୋକାସ୍ତ୍ୱଦୀଯାଃ ସର୍ୱ୍ୱା ଯଜ୍ଞୱେଦୀରଭଞ୍ଜନ୍ ତଥା ତୱ ଭୱିଷ୍ୟଦ୍ୱାଦିନଃ ସର୍ୱ୍ୱାନ୍ ଅଘ୍ନନ୍ କେୱଲ ଏକୋଽହମ୍ ଅୱଶିଷ୍ଟ ଆସେ ତେ ମମାପି ପ୍ରାଣାନ୍ ନାଶଯିତୁଂ ଚେଷ୍ଟନତେ, ଏତାଂ କଥାମ୍ ଇସ୍ରାଯେଲୀଯଲୋକାନାଂ ୱିରୁଦ୍ଧମ୍ ଏଲିଯ ଈଶ୍ୱରାଯ ନିୱେଦଯାମାସ| ");
INSERT INTO sanori_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","ତତସ୍ତଂ ପ୍ରତୀଶ୍ୱରସ୍ୟୋତ୍ତରଂ କିଂ ଜାତଂ? ବାଲ୍ନାମ୍ନୋ ଦେୱସ୍ୟ ସାକ୍ଷାତ୍ ଯୈ ର୍ଜାନୂନି ନ ପାତିତାନି ତାଦୃଶାଃ ସପ୍ତ ସହସ୍ରାଣି ଲୋକା ଅୱଶେଷିତା ମଯା| ");
INSERT INTO sanori_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","ତଦ୍ୱଦ୍ ଏତସ୍ମିନ୍ ୱର୍ତ୍ତମାନକାଲେଽପି ଅନୁଗ୍ରହେଣାଭିରୁଚିତାସ୍ତେଷାମ୍ ଅୱଶିଷ୍ଟାଃ କତିପଯା ଲୋକାଃ ସନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","ଅତଏୱ ତଦ୍ ଯଦ୍ୟନୁଗ୍ରହେଣ ଭୱତି ତର୍ହି କ୍ରିଯଯା ନ ଭୱତି ନୋ ଚେଦ୍ ଅନୁଗ୍ରହୋଽନନୁଗ୍ରହ ଏୱ, ଯଦି ୱା କ୍ରିଯଯା ଭୱତି ତର୍ହ୍ୟନୁଗ୍ରହେଣ ନ ଭୱତି ନୋ ଚେତ୍ କ୍ରିଯା କ୍ରିଯୈୱ ନ ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","ତର୍ହି କିଂ? ଇସ୍ରାଯେଲୀଯଲୋକା ଯଦ୍ ଅମୃଗଯନ୍ତ ତନ୍ନ ପ୍ରାପୁଃ| କିନ୍ତ୍ୱଭିରୁଚିତଲୋକାସ୍ତତ୍ ପ୍ରାପୁସ୍ତଦନ୍ୟେ ସର୍ୱ୍ୱ ଅନ୍ଧୀଭୂତାଃ| ");
INSERT INTO sanori_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","ଯଥା ଲିଖିତମ୍ ଆସ୍ତେ, ଘୋରନିଦ୍ରାଲୁତାଭାୱଂ ଦୃଷ୍ଟିହୀନେ ଚ ଲୋଚନେ| କର୍ଣୌ ଶ୍ରୁତିୱିହୀନୌ ଚ ପ୍ରଦଦୌ ତେଭ୍ୟ ଈଶ୍ୱରଃ|| ");
INSERT INTO sanori_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","ଏତେସ୍ମିନ୍ ଦାଯୂଦପି ଲିଖିତୱାନ୍ ଯଥା, ଅତୋ ଭୁକ୍ତ୍ୟାସନଂ ତେଷାମ୍ ଉନ୍ମାଥୱଦ୍ ଭୱିଷ୍ୟତି| ୱା ୱଂଶଯନ୍ତ୍ରୱଦ୍ ବାଧା ଦଣ୍ଡୱଦ୍ ୱା ଭୱିଷ୍ୟତି|| ");
INSERT INTO sanori_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","ଭୱିଷ୍ୟନ୍ତି ତଥାନ୍ଧାସ୍ତେ ନେତ୍ରୈଃ ପଶ୍ୟନ୍ତି ନୋ ଯଥା| ୱେପଥୁଃ କଟିଦେଶସ୍ୟ ତେଷାଂ ନିତ୍ୟଂ ଭୱିଷ୍ୟତି|| ");
INSERT INTO sanori_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","ପତନାର୍ଥଂ ତେ ସ୍ଖଲିତୱନ୍ତ ଇତି ୱାଚଂ କିମହଂ ୱଦାମି? ତନ୍ନ ଭୱତୁ କିନ୍ତୁ ତାନ୍ ଉଦ୍ୟୋଗିନଃ କର୍ତ୍ତୁଂ ତେଷାଂ ପତନାଦ୍ ଇତରଦେଶୀଯଲୋକୈଃ ପରିତ୍ରାଣଂ ପ୍ରାପ୍ତଂ| ");
INSERT INTO sanori_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","ତେଷାଂ ପତନଂ ଯଦି ଜଗତୋ ଲୋକାନାଂ ଲାଭଜନକମ୍ ଅଭୱତ୍ ତେଷାଂ ହ୍ରାସୋଽପି ଯଦି ଭିନ୍ନଦେଶିନାଂ ଲାଭଜନକୋଽଭୱତ୍ ତର୍ହି ତେଷାଂ ୱୃଦ୍ଧିଃ କତି ଲାଭଜନିକା ଭୱିଷ୍ୟତି? ");
INSERT INTO sanori_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","ଅତୋ ହେ ଅନ୍ୟଦେଶିନୋ ଯୁଷ୍ମାନ୍ ସମ୍ବୋଧ୍ୟ କଥଯାମି ନିଜାନାଂ ଜ୍ଞାତିବନ୍ଧୂନାଂ ମନଃସୂଦ୍ୟୋଗଂ ଜନଯନ୍ ତେଷାଂ ମଧ୍ୟେ କିଯତାଂ ଲୋକାନାଂ ଯଥା ପରିତ୍ରାଣଂ ସାଧଯାମି ");
INSERT INTO sanori_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","ତନ୍ନିମିତ୍ତମ୍ ଅନ୍ୟଦେଶିନାଂ ନିକଟେ ପ୍ରେରିତଃ ସନ୍ ଅହଂ ସ୍ୱପଦସ୍ୟ ମହିମାନଂ ପ୍ରକାଶଯାମି| ");
INSERT INTO sanori_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","ତେଷାଂ ନିଗ୍ରହେଣ ଯଦୀଶ୍ୱରେଣ ସହ ଜଗତୋ ଜନାନାଂ ମେଲନଂ ଜାତଂ ତର୍ହି ତେଷାମ୍ ଅନୁଗୃହୀତତ୍ୱଂ ମୃତଦେହେ ଯଥା ଜୀୱନଲାଭସ୍ତଦ୍ୱତ୍ କିଂ ନ ଭୱିଷ୍ୟତି? ");
INSERT INTO sanori_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","ଅପରଂ ପ୍ରଥମଜାତଂ ଫଲଂ ଯଦି ପୱିତ୍ରଂ ଭୱତି ତର୍ହି ସର୍ୱ୍ୱମେୱ ଫଲଂ ପୱିତ୍ରଂ ଭୱିଷ୍ୟତି; ତଥା ମୂଲଂ ଯଦି ପୱିତ୍ରଂ ଭୱତି ତର୍ହି ଶାଖା ଅପି ତଥୈୱ ଭୱିଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","କିଯତୀନାଂ ଶାଖାନାଂ ଛେଦନେ କୃତେ ତ୍ୱଂ ୱନ୍ୟଜିତୱୃକ୍ଷସ୍ୟ ଶାଖା ଭୂତ୍ୱା ଯଦି ତଚ୍ଛାଖାନାଂ ସ୍ଥାନେ ରୋପିତା ସତି ଜିତୱୃକ୍ଷୀଯମୂଲସ୍ୟ ରସଂ ଭୁଂକ୍ଷେ, ");
INSERT INTO sanori_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","ତର୍ହି ତାସାଂ ଭିନ୍ନଶାଖାନାଂ ୱିରୁଦ୍ଧଂ ମାଂ ଗର୍ୱ୍ୱୀଃ; ଯଦି ଗର୍ୱ୍ୱସି ତର୍ହି ତ୍ୱଂ ମୂଲଂ ଯନ୍ନ ଧାରଯସି କିନ୍ତୁ ମୂଲଂ ତ୍ୱାଂ ଧାରଯତୀତି ସଂସ୍ମର| ");
INSERT INTO sanori_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","ଅପରଞ୍ଚ ଯଦି ୱଦସି ମାଂ ରୋପଯିତୁଂ ତାଃ ଶାଖା ୱିଭନ୍ନା ଅଭୱନ୍; ");
INSERT INTO sanori_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","ଭଦ୍ରମ୍, ଅପ୍ରତ୍ୟଯକାରଣାତ୍ ତେ ୱିଭିନ୍ନା ଜାତାସ୍ତଥା ୱିଶ୍ୱାସକାରଣାତ୍ ତ୍ୱଂ ରୋପିତୋ ଜାତସ୍ତସ୍ମାଦ୍ ଅହଙ୍କାରମ୍ ଅକୃତ୍ୱା ସସାଧ୍ୱସୋ ଭୱ| ");
INSERT INTO sanori_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","ଯତ ଈଶ୍ୱରୋ ଯଦି ସ୍ୱାଭାୱିକୀଃ ଶାଖା ନ ରକ୍ଷତି ତର୍ହି ସାୱଧାନୋ ଭୱ ଚେତ୍ ତ୍ୱାମପି ନ ସ୍ଥାପଯତି| ");
INSERT INTO sanori_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","ଇତ୍ୟତ୍ରେଶ୍ୱରସ୍ୟ ଯାଦୃଶୀ କୃପା ତାଦୃଶଂ ଭଯାନକତ୍ୱମପି ତ୍ୱଯା ଦୃଶ୍ୟତାଂ; ଯେ ପତିତାସ୍ତାନ୍ ପ୍ରତି ତସ୍ୟ ଭଯାନକତ୍ୱଂ ଦୃଶ୍ୟତାଂ, ତ୍ୱଞ୍ଚ ଯଦି ତତ୍କୃପାଶ୍ରିତସ୍ତିଷ୍ଠସି ତର୍ହି ତ୍ୱାଂ ପ୍ରତି କୃପା ଦ୍ରକ୍ଷ୍ୟତେ; ନୋ ଚେତ୍ ତ୍ୱମପି ତଦ୍ୱତ୍ ଛିନ୍ନୋ ଭୱିଷ୍ୟସି| ");
INSERT INTO sanori_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","ଅପରଞ୍ଚ ତେ ଯଦ୍ୟପ୍ରତ୍ୟଯେ ନ ତିଷ୍ଠନ୍ତି ତର୍ହି ପୁନରପି ରୋପଯିଷ୍ୟନ୍ତେ ଯସ୍ମାତ୍ ତାନ୍ ପୁନରପି ରୋପଯିତୁମ୍ ଇଶ୍ୱରସ୍ୟ ଶକ୍ତିରାସ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","ୱନ୍ୟଜିତୱୃକ୍ଷସ୍ୟ ଶାଖା ସନ୍ ତ୍ୱଂ ଯଦି ତତଶ୍ଛିନ୍ନୋ ରୀତିୱ୍ୟତ୍ୟଯେନୋତ୍ତମଜିତୱୃକ୍ଷେ ରୋेेପିତୋଽଭୱସ୍ତର୍ହି ତସ୍ୟ ୱୃକ୍ଷସ୍ୟ ସ୍ୱୀଯା ଯାଃ ଶାଖାସ୍ତାଃ କିଂ ପୁନଃ ସ୍ୱୱୃକ୍ଷେ ସଂଲଗିତୁଂ ନ ଶକ୍ନୁୱନ୍ତି? ");
INSERT INTO sanori_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","ହେ ଭ୍ରାତରୋ ଯୁଷ୍ମାକମ୍ ଆତ୍ମାଭିମାନୋ ଯନ୍ନ ଜାଯତେ ତଦର୍ଥଂ ମମେଦୃଶୀ ୱାଞ୍ଛା ଭୱତି ଯୂଯଂ ଏତନ୍ନିଗୂଢତତ୍ତ୍ୱମ୍ ଅଜାନନ୍ତୋ ଯନ୍ନ ତିଷ୍ଠଥ; ୱସ୍ତୁତୋ ଯାୱତ୍କାଲଂ ସମ୍ପୂର୍ଣରୂପେଣ ଭିନ୍ନଦେଶିନାଂ ସଂଗ୍ରହୋ ନ ଭୱିଷ୍ୟତି ତାୱତ୍କାଲମ୍ ଅଂଶତ୍ୱେନ ଇସ୍ରାଯେଲୀଯଲୋକାନାମ୍ ଅନ୍ଧତା ସ୍ଥାସ୍ୟତି; ");
INSERT INTO sanori_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","ପଶ୍ଚାତ୍ ତେ ସର୍ୱ୍ୱେ ପରିତ୍ରାସ୍ୟନ୍ତେ; ଏତାଦୃଶଂ ଲିଖିତମପ୍ୟାସ୍ତେ, ଆଗମିଷ୍ୟତି ସୀଯୋନାଦ୍ ଏକୋ ଯସ୍ତ୍ରାଣଦାଯକଃ| ଅଧର୍ମ୍ମଂ ଯାକୁବୋ ୱଂଶାତ୍ ସ ତୁ ଦୂରୀକରିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","ତଥା ଦୂରୀକରିଷ୍ୟାମି ତେଷାଂ ପାପାନ୍ୟହଂ ଯଦା| ତଦା ତୈରେୱ ସାର୍ଦ୍ଧଂ ମେ ନିଯମୋଽଯଂ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","ସୁସଂୱାଦାତ୍ ତେ ଯୁଷ୍ମାକଂ ୱିପକ୍ଷା ଅଭୱନ୍ କିନ୍ତ୍ୱଭିରୁଚିତତ୍ୱାତ୍ ତେ ପିତୃଲୋକାନାଂ କୃତେ ପ୍ରିଯପାତ୍ରାଣି ଭୱନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","ଯତ ଈଶ୍ୱରସ୍ୟ ଦାନାଦ୍ ଆହ୍ୱାନାଞ୍ଚ ପଶ୍ଚାତ୍ତାପୋ ନ ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","ଅତଏୱ ପୂର୍ୱ୍ୱମ୍ ଈଶ୍ୱରେଽୱିଶ୍ୱାସିନଃ ସନ୍ତୋଽପି ଯୂଯଂ ଯଦ୍ୱତ୍ ସମ୍ପ୍ରତି ତେଷାମ୍ ଅୱିଶ୍ୱାସକାରଣାଦ୍ ଈଶ୍ୱରସ୍ୟ କୃପାପାତ୍ରାଣି ଜାତାସ୍ତଦ୍ୱଦ୍ ");
INSERT INTO sanori_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","ଇଦାନୀଂ ତେଽୱିଶ୍ୱାସିନଃ ସନ୍ତି କିନ୍ତୁ ଯୁଷ୍ମାଭି ର୍ଲବ୍ଧକୃପାକାରଣାତ୍ ତୈରପି କୃପା ଲପ୍ସ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","ଈଶ୍ୱରଃ ସର୍ୱ୍ୱାନ୍ ପ୍ରତି କୃପାଂ ପ୍ରକାଶଯିତୁଂ ସର୍ୱ୍ୱାନ୍ ଅୱିଶ୍ୱାସିତ୍ୱେନ ଗଣଯତି| ");
INSERT INTO sanori_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","ଅହୋ ଈଶ୍ୱରସ୍ୟ ଜ୍ଞାନବୁଦ୍ଧିରୂପଯୋ ର୍ଧନଯୋଃ କୀଦୃକ୍ ପ୍ରାଚୁର୍ୟ୍ୟଂ| ତସ୍ୟ ରାଜଶାସନସ୍ୟ ତତ୍ତ୍ୱଂ କୀଦୃଗ୍ ଅପ୍ରାପ୍ୟଂ| ତସ୍ୟ ମାର୍ଗାଶ୍ଚ କୀଦୃଗ୍ ଅନୁପଲକ୍ଷ୍ୟାଃ| ");
INSERT INTO sanori_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","ପରମେଶ୍ୱରସ୍ୟ ସଙ୍କଲ୍ପଂ କୋ ଜ୍ଞାତୱାନ୍? ତସ୍ୟ ମନ୍ତ୍ରୀ ୱା କୋଽଭୱତ୍? ");
INSERT INTO sanori_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","କୋ ୱା ତସ୍ୟୋପକାରୀ ଭୃତ୍ୱା ତତ୍କୃତେ ତେନ ପ୍ରତ୍ୟୁପକର୍ତ୍ତୱ୍ୟଃ? ");
INSERT INTO sanori_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","ଯତୋ ୱସ୍ତୁମାତ୍ରମେୱ ତସ୍ମାତ୍ ତେନ ତସ୍ମୈ ଚାଭୱତ୍ ତଦୀଯୋ ମହିମା ସର୍ୱ୍ୱଦା ପ୍ରକାଶିତୋ ଭୱତୁ| ଇତି| ");
INSERT INTO sanori_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","ହେ ଭ୍ରାତର ଈଶ୍ୱରସ୍ୟ କୃପଯାହଂ ଯୁଷ୍ମାନ୍ ୱିନଯେ ଯୂଯଂ ସ୍ୱଂ ସ୍ୱଂ ଶରୀରଂ ସଜୀୱଂ ପୱିତ୍ରଂ ଗ୍ରାହ୍ୟଂ ବଲିମ୍ ଈଶ୍ୱରମୁଦ୍ଦିଶ୍ୟ ସମୁତ୍ସୃଜତ, ଏଷା ସେୱା ଯୁଷ୍ମାକଂ ଯୋଗ୍ୟା| ");
INSERT INTO sanori_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","ଅପରଂ ଯୂଯଂ ସାଂସାରିକା ଇୱ ମାଚରତ, କିନ୍ତୁ ସ୍ୱଂ ସ୍ୱଂ ସ୍ୱଭାୱଂ ପରାୱର୍ତ୍ୟ ନୂତନାଚାରିଣୋ ଭୱତ, ତତ ଈଶ୍ୱରସ୍ୟ ନିଦେଶଃ କୀଦୃଗ୍ ଉତ୍ତମୋ ଗ୍ରହଣୀଯଃ ସମ୍ପୂର୍ଣଶ୍ଚେତି ଯୁଷ୍ମାଭିରନୁଭାୱିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","କଶ୍ଚିଦପି ଜନୋ ଯୋଗ୍ୟତ୍ୱାଦଧିକଂ ସ୍ୱଂ ନ ମନ୍ୟତାଂ କିନ୍ତୁ ଈଶ୍ୱରୋ ଯସ୍ମୈ ପ୍ରତ୍ୟଯସ୍ୟ ଯତ୍ପରିମାଣମ୍ ଅଦଦାତ୍ ସ ତଦନୁସାରତୋ ଯୋଗ୍ୟରୂପଂ ସ୍ୱଂ ମନୁତାମ୍, ଈଶ୍ୱରାଦ୍ ଅନୁଗ୍ରହଂ ପ୍ରାପ୍ତଃ ସନ୍ ଯୁଷ୍ମାକମ୍ ଏକୈକଂ ଜନମ୍ ଇତ୍ୟାଜ୍ଞାପଯାମି| ");
INSERT INTO sanori_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","ଯତୋ ଯଦ୍ୱଦସ୍ମାକମ୍ ଏକସ୍ମିନ୍ ଶରୀରେ ବହୂନ୍ୟଙ୍ଗାନି ସନ୍ତି କିନ୍ତୁ ସର୍ୱ୍ୱେଷାମଙ୍ଗାନାଂ କାର୍ୟ୍ୟଂ ସମାନଂ ନହି; ");
INSERT INTO sanori_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","ତଦ୍ୱଦସ୍ମାକଂ ବହୁତ୍ୱେଽପି ସର୍ୱ୍ୱେ ୱଯଂ ଖ୍ରୀଷ୍ଟେ ଏକଶରୀରାଃ ପରସ୍ପରମ୍ ଅଙ୍ଗପ୍ରତ୍ୟଙ୍ଗତ୍ୱେନ ଭୱାମଃ| ");
INSERT INTO sanori_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","ଅସ୍ମାଦ୍ ଈଶ୍ୱରାନୁଗ୍ରହେଣ ୱିଶେଷଂ ୱିଶେଷଂ ଦାନମ୍ ଅସ୍ମାସୁ ପ୍ରାପ୍ତେଷୁ ସତ୍ସୁ କୋପି ଯଦି ଭୱିଷ୍ୟଦ୍ୱାକ୍ୟଂ ୱଦତି ତର୍ହି ପ୍ରତ୍ୟଯସ୍ୟ ପରିମାଣାନୁସାରତଃ ସ ତଦ୍ ୱଦତୁ; ");
INSERT INTO sanori_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","ଯଦ୍ୱା ଯଦି କଶ୍ଚିତ୍ ସେୱନକାରୀ ଭୱତି ତର୍ହି ସ ତତ୍ସେୱନଂ କରୋତୁ; ଅଥୱା ଯଦି କଶ୍ଚିଦ୍ ଅଧ୍ୟାପଯିତା ଭୱତି ତର୍ହି ସୋଽଧ୍ୟାପଯତୁ; ");
INSERT INTO sanori_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","ତଥା ଯ ଉପଦେଷ୍ଟା ଭୱତି ସ ଉପଦିଶତୁ ଯଶ୍ଚ ଦାତା ସ ସରଲତଯା ଦଦାତୁ ଯସ୍ତ୍ୱଧିପତିଃ ସ ଯତ୍ନେନାଧିପତିତ୍ୱଂ କରୋତୁ ଯଶ୍ଚ ଦଯାଲୁଃ ସ ହୃଷ୍ଟମନସା ଦଯତାମ୍| ");
INSERT INTO sanori_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","ଅପରଞ୍ଚ ଯୁଷ୍ମାକଂ ପ୍ରେମ କାପଟ୍ୟୱର୍ଜିତଂ ଭୱତୁ ଯଦ୍ ଅଭଦ୍ରଂ ତଦ୍ ଋତୀଯଧ୍ୱଂ ଯଚ୍ଚ ଭଦ୍ରଂ ତସ୍ମିନ୍ ଅନୁରଜ୍ୟଧ୍ୱମ୍| ");
INSERT INTO sanori_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","ଅପରଂ ଭ୍ରାତୃତ୍ୱପ୍ରେମ୍ନା ପରସ୍ପରଂ ପ୍ରୀଯଧ୍ୱଂ ସମାଦରାଦ୍ ଏକୋଽପରଜନଂ ଶ୍ରେଷ୍ଠଂ ଜାନୀଧ୍ୱମ୍| ");
INSERT INTO sanori_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","ତଥା କାର୍ୟ୍ୟେ ନିରାଲସ୍ୟା ମନସି ଚ ସୋଦ୍ୟୋଗାଃ ସନ୍ତଃ ପ୍ରଭୁଂ ସେୱଧ୍ୱମ୍| ");
INSERT INTO sanori_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","ଅପରଂ ପ୍ରତ୍ୟାଶାଯାମ୍ ଆନନ୍ଦିତା ଦୁଃଖସମଯେ ଚ ଧୈର୍ୟ୍ୟଯୁକ୍ତା ଭୱତ; ପ୍ରାର୍ଥନାଯାଂ ସତତଂ ପ୍ରୱର୍ତ୍ତଧ୍ୱଂ| ");
INSERT INTO sanori_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","ପୱିତ୍ରାଣାଂ ଦୀନତାଂ ଦୂରୀକୁରୁଧ୍ୱମ୍ ଅତିଥିସେୱାଯାମ୍ ଅନୁରଜ୍ୟଧ୍ୱମ୍| ");
INSERT INTO sanori_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","ଯେ ଜନା ଯୁଷ୍ମାନ୍ ତାଡଯନ୍ତି ତାନ୍ ଆଶିଷଂ ୱଦତ ଶାପମ୍ ଅଦତ୍ତ୍ୱା ଦଦ୍ଧ୍ୱମାଶିଷମ୍| ");
INSERT INTO sanori_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","ଯେ ଜନା ଆନନ୍ଦନ୍ତି ତୈଃ ସାର୍ଦ୍ଧମ୍ ଆନନ୍ଦତ ଯେ ଚ ରୁଦନ୍ତି ତୈଃ ସହ ରୁଦିତ| ");
INSERT INTO sanori_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","ଅପରଞ୍ଚ ଯୁଷ୍ମାକଂ ମନସାଂ ପରସ୍ପରମ୍ ଏକୋଭାୱୋ ଭୱତୁ; ଅପରମ୍ ଉଚ୍ଚପଦମ୍ ଅନାକାଙ୍କ୍ଷ୍ୟ ନୀଚଲୋକୈଃ ସହାପି ମାର୍ଦୱମ୍ ଆଚରତ; ସ୍ୱାନ୍ ଜ୍ଞାନିନୋ ନ ମନ୍ୟଧ୍ୱଂ| ");
INSERT INTO sanori_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","ପରସ୍ମାଦ୍ ଅପକାରଂ ପ୍ରାପ୍ୟାପି ପରଂ ନାପକୁରୁତ| ସର୍ୱ୍ୱେଷାଂ ଦୃଷ୍ଟିତୋ ଯତ୍ କର୍ମ୍ମୋତ୍ତମଂ ତଦେୱ କୁରୁତ| ");
INSERT INTO sanori_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","ଯଦି ଭୱିତୁଂ ଶକ୍ୟତେ ତର୍ହି ଯଥାଶକ୍ତି ସର୍ୱ୍ୱଲୋକୈଃ ସହ ନିର୍ୱ୍ୱିରୋଧେନ କାଲଂ ଯାପଯତ| ");
INSERT INTO sanori_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","ହେ ପ୍ରିଯବନ୍ଧୱଃ, କସ୍ମୈଚିଦ୍ ଅପକାରସ୍ୟ ସମୁଚିତଂ ଦଣ୍ଡଂ ସ୍ୱଯଂ ନ ଦଦ୍ଧ୍ୱଂ, କିନ୍ତ୍ୱୀଶ୍ୱରୀଯକ୍ରୋଧାଯ ସ୍ଥାନଂ ଦତ୍ତ ଯତୋ ଲିଖିତମାସ୍ତେ ପରମେଶ୍ୱରଃ କଥଯତି, ଦାନଂ ଫଲସ୍ୟ ମତ୍କର୍ମ୍ମ ସୂଚିତଂ ପ୍ରଦଦାମ୍ୟହଂ| ");
INSERT INTO sanori_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","ଇତିକାରଣାଦ୍ ରିପୁ ର୍ୟଦି କ୍ଷୁଧାର୍ତ୍ତସ୍ତେ ତର୍ହି ତଂ ତ୍ୱଂ ପ୍ରଭୋଜଯ| ତଥା ଯଦି ତୃଷାର୍ତ୍ତଃ ସ୍ୟାତ୍ ତର୍ହି ତଂ ପରିପାଯଯ| ତେନ ତ୍ୱଂ ମସ୍ତକେ ତସ୍ୟ ଜ୍ୱଲଦଗ୍ନିଂ ନିଧାସ୍ୟସି| ");
INSERT INTO sanori_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","କୁକ୍ରିଯଯା ପରାଜିତା ନ ସନ୍ତ ଉତ୍ତମକ୍ରିଯଯା କୁକ୍ରିଯାଂ ପରାଜଯତ| ");
INSERT INTO sanori_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","ଯୁଷ୍ମାକମ୍ ଏକୈକଜନଃ ଶାସନପଦସ୍ୟ ନିଘ୍ନୋ ଭୱତୁ ଯତୋ ଯାନି ଶାସନପଦାନି ସନ୍ତି ତାନି ସର୍ୱ୍ୱାଣୀଶ୍ୱରେଣ ସ୍ଥାପିତାନି; ଈଶ୍ୱରଂ ୱିନା ପଦସ୍ଥାପନଂ ନ ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","ଇତି ହେତୋଃ ଶାସନପଦସ୍ୟ ଯତ୍ ପ୍ରାତିକୂଲ୍ୟଂ ତଦ୍ ଈଶ୍ୱରୀଯନିରୂପଣସ୍ୟ ପ୍ରାତିକୂଲ୍ୟମେୱ; ଅପରଂ ଯେ ପ୍ରାତିକୂଲ୍ୟମ୍ ଆଚରନ୍ତି ତେ ସ୍ୱେଷାଂ ସମୁଚିତଂ ଦଣ୍ଡଂ ସ୍ୱଯମେୱ ଘଟଯନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","ଶାସ୍ତା ସଦାଚାରିଣାଂ ଭଯପ୍ରଦୋ ନହି ଦୁରାଚାରିଣାମେୱ ଭଯପ୍ରଦୋ ଭୱତି; ତ୍ୱଂ କିଂ ତସ୍ମାନ୍ ନିର୍ଭଯୋ ଭୱିତୁମ୍ ଇଚ୍ଛସି? ତର୍ହି ସତ୍କର୍ମ୍ମାଚର, ତସ୍ମାଦ୍ ଯଶୋ ଲପ୍ସ୍ୟସେ, ");
INSERT INTO sanori_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","ଯତସ୍ତୱ ସଦାଚରଣାଯ ସ ଈଶ୍ୱରସ୍ୟ ଭୃତ୍ୟୋଽସ୍ତି| କିନ୍ତୁ ଯଦି କୁକର୍ମ୍ମାଚରସି ତର୍ହି ତ୍ୱଂ ଶଙ୍କସ୍ୱ ଯତଃ ସ ନିରର୍ଥକଂ ଖଙ୍ଗଂ ନ ଧାରଯତି; କୁକର୍ମ୍ମାଚାରିଣଂ ସମୁଚିତଂ ଦଣ୍ଡଯିତୁମ୍ ସ ଈଶ୍ୱରସ୍ୟ ଦଣ୍ଡଦଭୃତ୍ୟ ଏୱ| ");
INSERT INTO sanori_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","ଅତଏୱ କେୱଲଦଣ୍ଡଭଯାନ୍ନହି କିନ୍ତୁ ସଦସଦ୍ବୋଧାଦପି ତସ୍ୟ ୱଶ୍ୟେନ ଭୱିତୱ୍ୟଂ| ");
INSERT INTO sanori_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","ଏତସ୍ମାଦ୍ ଯୁଷ୍ମାକଂ ରାଜକରଦାନମପ୍ୟୁଚିତଂ ଯସ୍ମାଦ୍ ଯେ କରଂ ଗୃହ୍ଲନ୍ତି ତ ଈଶ୍ୱରସ୍ୟ କିଙ୍କରା ଭୂତ୍ୱା ସତତମ୍ ଏତସ୍ମିନ୍ କର୍ମ୍ମଣି ନିୱିଷ୍ଟାସ୍ତିଷ୍ଠନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","ଅସ୍ମାତ୍ କରଗ୍ରାହିଣେ କରଂ ଦତ୍ତ, ତଥା ଶୁଲ୍କଗ୍ରାହିଣେ ଶୁଲ୍କଂ ଦତ୍ତ, ଅପରଂ ଯସ୍ମାଦ୍ ଭେତୱ୍ୟଂ ତସ୍ମାଦ୍ ବିଭୀତ, ଯଶ୍ଚ ସମାଦରଣୀଯସ୍ତଂ ସମାଦ୍ରିଯଧ୍ୱମ୍; ଇତ୍ଥଂ ଯସ୍ୟ ଯତ୍ ପ୍ରାପ୍ୟଂ ତତ୍ ତସ୍ମୈ ଦତ୍ତ| ");
INSERT INTO sanori_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","ଯୁଷ୍ମାକଂ ପରସ୍ପରଂ ପ୍ରେମ ୱିନା ଽନ୍ୟତ୍ କିମପି ଦେଯମ୍ ଋଣଂ ନ ଭୱତୁ, ଯତୋ ଯଃ ପରସ୍ମିନ୍ ପ୍ରେମ କରୋତି ତେନ ୱ୍ୟୱସ୍ଥା ସିଧ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","ୱସ୍ତୁତଃ ପରଦାରାନ୍ ମା ଗଚ୍ଛ, ନରହତ୍ୟାଂ ମା କାର୍ଷୀଃ, ଚୈର୍ୟ୍ୟଂ ମା କାର୍ଷୀଃ, ମିଥ୍ୟାସାକ୍ଷ୍ୟଂ ମା ଦେହି, ଲୋଭଂ ମା କାର୍ଷୀଃ, ଏତାଃ ସର୍ୱ୍ୱା ଆଜ୍ଞା ଏତାଭ୍ୟୋ ଭିନ୍ନା ଯା କାଚିଦ୍ ଆଜ୍ଞାସ୍ତି ସାପି ସ୍ୱସମୀପୱାସିନି ସ୍ୱୱତ୍ ପ୍ରେମ କୁର୍ୱ୍ୱିତ୍ୟନେନ ୱଚନେନ ୱେଦିତା| ");
INSERT INTO sanori_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","ଯତଃ ପ୍ରେମ ସମୀପୱାସିନୋଽଶୁଭଂ ନ ଜନଯତି ତସ୍ମାତ୍ ପ୍ରେମ୍ନା ସର୍ୱ୍ୱା ୱ୍ୟୱସ୍ଥା ପାଲ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","ପ୍ରତ୍ୟଯୀଭୱନକାଲେଽସ୍ମାକଂ ପରିତ୍ରାଣସ୍ୟ ସାମୀପ୍ୟାଦ୍ ଇଦାନୀଂ ତସ୍ୟ ସାମୀପ୍ୟମ୍ ଅୱ୍ୟୱହିତଂ; ଅତଃ ସମଯଂ ୱିୱିଚ୍ୟାସ୍ମାଭିଃ ସାମ୍ପ୍ରତମ୍ ଅୱଶ୍ୟମେୱ ନିଦ୍ରାତୋ ଜାଗର୍ତ୍ତୱ୍ୟଂ| ");
INSERT INTO sanori_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","ବହୁତରା ଯାମିନୀ ଗତା ପ୍ରଭାତଂ ସନ୍ନିଧିଂ ପ୍ରାପ୍ତଂ ତସ୍ମାତ୍ ତାମସୀଯାଃ କ୍ରିଯାଃ ପରିତ୍ୟଜ୍ୟାସ୍ମାଭି ର୍ୱାସରୀଯା ସଜ୍ଜା ପରିଧାତୱ୍ୟା| ");
INSERT INTO sanori_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","ଅତୋ ହେତୋ ର୍ୱଯଂ ଦିୱା ୱିହିତଂ ସଦାଚରଣମ୍ ଆଚରିଷ୍ୟାମଃ| ରଙ୍ଗରସୋ ମତ୍ତତ୍ୱଂ ଲମ୍ପଟତ୍ୱଂ କାମୁକତ୍ୱଂ ୱିୱାଦ ଈର୍ଷ୍ୟା ଚୈତାନି ପରିତ୍ୟକ୍ଷ୍ୟାମଃ| ");
INSERT INTO sanori_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","ଯୂଯଂ ପ୍ରଭୁଯୀଶୁଖ୍ରୀଷ୍ଟରୂପଂ ପରିଚ୍ଛଦଂ ପରିଧଦ୍ଧ୍ୱଂ ସୁଖାଭିଲାଷପୂରଣାଯ ଶାରୀରିକାଚରଣଂ ମାଚରତ| ");
INSERT INTO sanori_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","ଯୋ ଜନୋଽଦୃଢୱିଶ୍ୱାସସ୍ତଂ ଯୁଷ୍ମାକଂ ସଙ୍ଗିନଂ କୁରୁତ କିନ୍ତୁ ସନ୍ଦେହୱିଚାରାର୍ଥଂ ନହି| ");
INSERT INTO sanori_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","ଯତୋ ନିଷିଦ୍ଧଂ କିମପି ଖାଦ୍ୟଦ୍ରୱ୍ୟଂ ନାସ୍ତି, କସ୍ୟଚିଜ୍ଜନସ୍ୟ ପ୍ରତ୍ୟଯ ଏତାଦୃଶୋ ୱିଦ୍ୟତେ କିନ୍ତ୍ୱଦୃଢୱିଶ୍ୱାସଃ କଶ୍ଚିଦପରୋ ଜନଃ କେୱଲଂ ଶାକଂ ଭୁଙ୍କ୍ତଂ| ");
INSERT INTO sanori_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","ତର୍ହି ଯୋ ଜନଃ ସାଧାରଣଂ ଦ୍ରୱ୍ୟଂ ଭୁଙ୍କ୍ତେ ସ ୱିଶେଷଦ୍ରୱ୍ୟଭୋକ୍ତାରଂ ନାୱଜାନୀଯାତ୍ ତଥା ୱିଶେଷଦ୍ରୱ୍ୟଭୋକ୍ତାପି ସାଧାରଣଦ୍ରୱ୍ୟଭୋକ୍ତାରଂ ଦୋଷିଣଂ ନ କୁର୍ୟ୍ୟାତ୍, ଯସ୍ମାଦ୍ ଈଶ୍ୱରସ୍ତମ୍ ଅଗୃହ୍ଲାତ୍| ");
INSERT INTO sanori_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","ହେ ପରଦାସସ୍ୟ ଦୂଷଯିତସ୍ତ୍ୱଂ କଃ? ନିଜପ୍ରଭୋଃ ସମୀପେ ତେନ ପଦସ୍ଥେନ ପଦଚ୍ୟୁତେନ ୱା ଭୱିତୱ୍ୟଂ ସ ଚ ପଦସ୍ଥ ଏୱ ଭୱିଷ୍ୟତି ଯତ ଈଶ୍ୱରସ୍ତଂ ପଦସ୍ଥଂ କର୍ତ୍ତୁଂ ଶକ୍ନୋତି| ");
INSERT INTO sanori_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","ଅପରଞ୍ଚ କଶ୍ଚିଜ୍ଜନୋ ଦିନାଦ୍ ଦିନଂ ୱିଶେଷଂ ମନ୍ୟତେ କଶ୍ଚିତ୍ତୁु ସର୍ୱ୍ୱାଣି ଦିନାନି ସମାନାନି ମନ୍ୟତେ, ଏକୈକୋ ଜନଃ ସ୍ୱୀଯମନସି ୱିୱିଚ୍ୟ ନିଶ୍ଚିନୋତୁ| ");
INSERT INTO sanori_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","ଯୋ ଜନଃ କିଞ୍ଚନ ଦିନଂ ୱିଶେଷଂ ମନ୍ୟତେ ସ ପ୍ରଭୁଭକ୍ତ୍ୟା ତନ୍ ମନ୍ୟତେ, ଯଶ୍ଚ ଜନଃ କିମପି ଦିନଂ ୱିଶେଷଂ ନ ମନ୍ୟତେ ସୋଽପି ପ୍ରଭୁଭକ୍ତ୍ୟା ତନ୍ନ ମନ୍ୟତେ; ଅପରଞ୍ଚ ଯଃ ସର୍ୱ୍ୱାଣି ଭକ୍ଷ୍ୟଦ୍ରୱ୍ୟାଣି ଭୁଙ୍କ୍ତେ ସ ପ୍ରଭୁଭକ୍ତଯା ତାନି ଭୁଙ୍କ୍ତେ ଯତଃ ସ ଈଶ୍ୱରଂ ଧନ୍ୟଂ ୱକ୍ତି, ଯଶ୍ଚ ନ ଭୁଙ୍କ୍ତେ ସୋଽପି ପ୍ରଭୁଭକ୍ତ୍ୟୈୱ ନ ଭୁଞ୍ଜାନ ଈଶ୍ୱରଂ ଧନ୍ୟଂ ବ୍ରୂତେ| ");
INSERT INTO sanori_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","ଅପରମ୍ ଅସ୍ମାକଂ କଶ୍ଚିତ୍ ନିଜନିମିତ୍ତଂ ପ୍ରାଣାନ୍ ଧାରଯତି ନିଜନିମିତ୍ତଂ ମ୍ରିଯତେ ୱା ତନ୍ନ; ");
INSERT INTO sanori_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","କିନ୍ତୁ ଯଦି ୱଯଂ ପ୍ରାଣାନ୍ ଧାରଯାମସ୍ତର୍ହି ପ୍ରଭୁନିମିତ୍ତଂ ଧାରଯାମଃ, ଯଦି ଚ ପ୍ରାଣାନ୍ ତ୍ୟଜାମସ୍ତର୍ହ୍ୟପି ପ୍ରଭୁନିମିତ୍ତଂ ତ୍ୟଜାମଃ, ଅତଏୱ ଜୀୱନେ ମରଣେ ୱା ୱଯଂ ପ୍ରଭୋରେୱାସ୍ମହେ| ");
INSERT INTO sanori_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","ଯତୋ ଜୀୱନ୍ତୋ ମୃତାଶ୍ଚେତ୍ୟୁଭଯେଷାଂ ଲୋକାନାଂ ପ୍ରଭୁତ୍ୱପ୍ରାପ୍ତ୍ୟର୍ଥଂ ଖ୍ରୀଷ୍ଟୋ ମୃତ ଉତ୍ଥିତଃ ପୁନର୍ଜୀୱିତଶ୍ଚ| ");
INSERT INTO sanori_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","କିନ୍ତୁ ତ୍ୱଂ ନିଜଂ ଭ୍ରାତରଂ କୁତୋ ଦୂଷଯସି? ତଥା ତ୍ୱଂ ନିଜଂ ଭ୍ରାତରଂ କୁତସ୍ତୁଚ୍ଛଂ ଜାନାସି? ଖ୍ରୀଷ୍ଟସ୍ୟ ୱିଚାରସିଂହାସନସ୍ୟ ସମ୍ମୁଖେ ସର୍ୱ୍ୱୈରସ୍ମାଭିରୁପସ୍ଥାତୱ୍ୟଂ; ");
INSERT INTO sanori_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","ଯାଦୃଶଂ ଲିଖିତମ୍ ଆସ୍ତେ, ପରେଶଃ ଶପଥଂ କୁର୍ୱ୍ୱନ୍ ୱାକ୍ୟମେତତ୍ ପୁରାୱଦତ୍| ସର୍ୱ୍ୱୋ ଜନଃ ସମୀପେ ମେ ଜାନୁପାତଂ କରିଷ୍ୟତି| ଜିହ୍ୱୈକୈକା ତଥେଶସ୍ୟ ନିଘ୍ନତ୍ୱଂ ସ୍ୱୀକରିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","ଅତଏୱ ଈଶ୍ୱରସମୀପେଽସ୍ମାକମ୍ ଏକୈକଜନେନ ନିଜା କଥା କଥଯିତୱ୍ୟା| ");
INSERT INTO sanori_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","ଇତ୍ଥଂ ସତି ୱଯମ୍ ଅଦ୍ୟାରଭ୍ୟ ପରସ୍ପରଂ ନ ଦୂଷଯନ୍ତଃ ସ୍ୱଭ୍ରାତୁ ର୍ୱିଘ୍ନୋ ୱ୍ୟାଘାତୋ ୱା ଯନ୍ନ ଜାଯେତ ତାଦୃଶୀମୀହାଂ କୁର୍ମ୍ମହେ| ");
INSERT INTO sanori_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","କିମପି ୱସ୍ତୁ ସ୍ୱଭାୱତୋ ନାଶୁଚି ଭୱତୀତ୍ୟହଂ ଜାନେ ତଥା ପ୍ରଭୁନା ଯୀଶୁଖ୍ରୀଷ୍ଟେନାପି ନିଶ୍ଚିତଂ ଜାନେ, କିନ୍ତୁ ଯୋ ଜନୋ ଯଦ୍ ଦ୍ରୱ୍ୟମ୍ ଅପୱିତ୍ରଂ ଜାନୀତେ ତସ୍ୟ କୃତେ ତଦ୍ ଅପୱିତ୍ରମ୍ ଆସ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","ଅତଏୱ ତୱ ଭକ୍ଷ୍ୟଦ୍ରୱ୍ୟେଣ ତୱ ଭ୍ରାତା ଶୋକାନ୍ୱିତୋ ଭୱତି ତର୍ହି ତ୍ୱଂ ଭ୍ରାତରଂ ପ୍ରତି ପ୍ରେମ୍ନା ନାଚରସି| ଖ୍ରୀଷ୍ଟୋ ଯସ୍ୟ କୃତେ ସ୍ୱପ୍ରାଣାନ୍ ୱ୍ୟଯିତୱାନ୍ ତ୍ୱଂ ନିଜେନ ଭକ୍ଷ୍ୟଦ୍ରୱ୍ୟେଣ ତଂ ନ ନାଶଯ| ");
INSERT INTO sanori_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","ଅପରଂ ଯୁଷ୍ମାକମ୍ ଉତ୍ତମଂ କର୍ମ୍ମ ନିନ୍ଦିତଂ ନ ଭୱତୁ| ");
INSERT INTO sanori_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","ଭକ୍ଷ୍ୟଂ ପେଯଞ୍ଚେଶ୍ୱରରାଜ୍ୟସ୍ୟ ସାରୋ ନହି, କିନ୍ତୁ ପୁଣ୍ୟଂ ଶାନ୍ତିଶ୍ଚ ପୱିତ୍ରେଣାତ୍ମନା ଜାତ ଆନନ୍ଦଶ୍ଚ| ");
INSERT INTO sanori_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","ଏତୈ ର୍ୟୋ ଜନଃ ଖ୍ରୀଷ୍ଟଂ ସେୱତେ, ସ ଏୱେଶ୍ୱରସ୍ୟ ତୁଷ୍ଟିକରୋ ମନୁଷ୍ୟୈଶ୍ଚ ସୁଖ୍ୟାତଃ| ");
INSERT INTO sanori_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","ଅତଏୱ ଯେନାସ୍ମାକଂ ସର୍ୱ୍ୱେଷାଂ ପରସ୍ପରମ୍ ଐକ୍ୟଂ ନିଷ୍ଠା ଚ ଜାଯତେ ତଦେୱାସ୍ମାଭି ର୍ୟତିତୱ୍ୟଂ| ");
INSERT INTO sanori_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","ଭକ୍ଷ୍ୟାର୍ଥମ୍ ଈଶ୍ୱରସ୍ୟ କର୍ମ୍ମଣୋ ହାନିଂ ମା ଜନଯତ; ସର୍ୱ୍ୱଂ ୱସ୍ତୁ ପୱିତ୍ରମିତି ସତ୍ୟଂ ତଥାପି ଯୋ ଜନୋ ଯଦ୍ ଭୁକ୍ତ୍ୱା ୱିଘ୍ନଂ ଲଭତେ ତଦର୍ଥଂ ତଦ୍ ଭଦ୍ରଂ ନହି| ");
INSERT INTO sanori_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","ତୱ ମାଂସଭକ୍ଷଣସୁରାପାନାଦିଭିଃ କ୍ରିଯାଭି ର୍ୟଦି ତୱ ଭ୍ରାତୁଃ ପାଦସ୍ଖଲନଂ ୱିଘ୍ନୋ ୱା ଚାଞ୍ଚଲ୍ୟଂ ୱା ଜାଯତେ ତର୍ହି ତଦ୍ଭୋଜନପାନଯୋସ୍ତ୍ୟାଗୋ ଭଦ୍ରଃ| ");
INSERT INTO sanori_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","ଯଦି ତୱ ପ୍ରତ୍ୟଯସ୍ତିଷ୍ଠତି ତର୍ହୀଶ୍ୱରସ୍ୟ ଗୋଚରେ ସ୍ୱାନ୍ତରେ ତଂ ଗୋପଯ; ଯୋ ଜନଃ ସ୍ୱମତେନ ସ୍ୱଂ ଦୋଷିଣଂ ନ କରୋତି ସ ଏୱ ଧନ୍ୟଃ| ");
INSERT INTO sanori_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","କିନ୍ତୁ ଯଃ କଶ୍ଚିତ୍ ସଂଶଯ୍ୟ ଭୁଙ୍କ୍ତେଽର୍ଥାତ୍ ନ ପ୍ରତୀତ୍ୟ ଭୁଙ୍କ୍ତେ, ସ ଏୱାୱଶ୍ୟଂ ଦଣ୍ଡାର୍ହୋ ଭୱିଷ୍ୟତି, ଯତୋ ଯତ୍ ପ୍ରତ୍ୟଯଜଂ ନହି ତଦେୱ ପାପମଯଂ ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","ବଲୱଦ୍ଭିରସ୍ମାଭି ର୍ଦୁର୍ବ୍ବଲାନାଂ ଦୌର୍ବ୍ବଲ୍ୟଂ ସୋଢୱ୍ୟଂ ନ ଚ ସ୍ୱେଷାମ୍ ଇଷ୍ଟାଚାର ଆଚରିତୱ୍ୟଃ| ");
INSERT INTO sanori_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","ଅସ୍ମାକମ୍ ଏକୈକୋ ଜନଃ ସ୍ୱସମୀପୱାସିନୋ ହିତାର୍ଥଂ ନିଷ୍ଠାର୍ଥଞ୍ଚ ତସ୍ୟୈୱେଷ୍ଟାଚାରମ୍ ଆଚରତୁ| ");
INSERT INTO sanori_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","ଯତଃ ଖ୍ରୀଷ୍ଟୋଽପି ନିଜେଷ୍ଟାଚାରଂ ନାଚରିତୱାନ୍, ଯଥା ଲିଖିତମ୍ ଆସ୍ତେ, ତ୍ୱନ୍ନିନ୍ଦକଗଣସ୍ୟୈୱ ନିନ୍ଦାଭି ର୍ନିନ୍ଦିତୋଽସ୍ମ୍ୟହଂ| ");
INSERT INTO sanori_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","ଅପରଞ୍ଚ ୱଯଂ ଯତ୍ ସହିଷ୍ଣୁତାସାନ୍ତ୍ୱନଯୋ ର୍ଜନକେନ ଶାସ୍ତ୍ରେଣ ପ୍ରତ୍ୟାଶାଂ ଲଭେମହି ତନ୍ନିମିତ୍ତଂ ପୂର୍ୱ୍ୱକାଲେ ଲିଖିତାନି ସର୍ୱ୍ୱୱଚନାନ୍ୟସ୍ମାକମ୍ ଉପଦେଶାର୍ଥମେୱ ଲିଲିଖିରେ| ");
INSERT INTO sanori_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","ସହିଷ୍ଣୁତାସାନ୍ତ୍ୱନଯୋରାକରୋ ଯ ଈଶ୍ୱରଃ ସ ଏୱଂ କରୋତୁ ଯତ୍ ପ୍ରଭୁ ର୍ୟୀଶୁଖ୍ରୀଷ୍ଟ ଇୱ ଯୁଷ୍ମାକମ୍ ଏକଜନୋଽନ୍ୟଜନେନ ସାର୍ଦ୍ଧଂ ମନସ ଐକ୍ୟମ୍ ଆଚରେତ୍; ");
INSERT INTO sanori_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","ଯୂଯଞ୍ଚ ସର୍ୱ୍ୱ ଏକଚିତ୍ତା ଭୂତ୍ୱା ମୁଖୈକେନେୱାସ୍ମତ୍ପ୍ରଭୁଯୀଶୁଖ୍ରୀଷ୍ଟସ୍ୟ ପିତୁରୀଶ୍ୱରସ୍ୟ ଗୁଣାନ୍ କୀର୍ତ୍ତଯେତ| ");
INSERT INTO sanori_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","ଅପରମ୍ ଈଶ୍ୱରସ୍ୟ ମହିମ୍ନଃ ପ୍ରକାଶାର୍ଥଂ ଖ୍ରୀଷ୍ଟୋ ଯଥା ଯୁଷ୍ମାନ୍ ପ୍ରତ୍ୟଗୃହ୍ଲାତ୍ ତଥା ଯୁଷ୍ମାକମପ୍ୟେକୋ ଜନୋଽନ୍ୟଜନଂ ପ୍ରତିଗୃହ୍ଲାତୁ| ");
INSERT INTO sanori_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","ଯଥା ଲିଖିତମ୍ ଆସ୍ତେ, ଅତୋଽହଂ ସମ୍ମୁଖେ ତିଷ୍ଠନ୍ ଭିନ୍ନଦେଶନିୱାସିନାଂ| ସ୍ତୁୱଂସ୍ତ୍ୱାଂ ପରିଗାସ୍ୟାମି ତୱ ନାମ୍ନି ପରେଶ୍ୱର|| ");
INSERT INTO sanori_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","ତସ୍ୟ ଦଯାଲୁତ୍ୱାଚ୍ଚ ଭିନ୍ନଜାତୀଯା ଯଦ୍ ଈଶ୍ୱରସ୍ୟ ଗୁଣାନ୍ କୀର୍ତ୍ତଯେଯୁସ୍ତଦର୍ଥଂ ଯୀଶୁଃ ଖ୍ରୀଷ୍ଟସ୍ତ୍ୱକ୍ଛେଦନିଯମସ୍ୟ ନିଘ୍ନୋଽଭୱଦ୍ ଇତ୍ୟହଂ ୱଦାମି| ଯଥା ଲିଖିତମ୍ ଆସ୍ତେ, ଅତୋଽହଂ ସମ୍ମୁଖେ ତିଷ୍ଠନ୍ ଭିନ୍ନଦେଶନିୱାସିନାଂ| ସ୍ତୁୱଂସ୍ତ୍ୱାଂ ପରିଗାସ୍ୟାମି ତୱ ନାମ୍ନି ପରେଶ୍ୱର|| ");
INSERT INTO sanori_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","ଅପରମପି ଲିଖିତମ୍ ଆସ୍ତେ, ହେ ଅନ୍ୟଜାତଯୋ ଯୂଯଂ ସମଂ ନନ୍ଦତ ତଜ୍ଜନୈଃ| ");
INSERT INTO sanori_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","ପୁନଶ୍ଚ ଲିଖିତମ୍ ଆସ୍ତେ, ହେ ସର୍ୱ୍ୱଦେଶିନୋ ଯୂଯଂ ଧନ୍ୟଂ ବ୍ରୂତ ପରେଶ୍ୱରଂ| ହେ ତଦୀଯନରା ଯୂଯଂ କୁରୁଧ୍ୱଂ ତତ୍ପ୍ରଶଂସନଂ|| ");
INSERT INTO sanori_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","ଅପର ଯୀଶାଯିଯୋଽପି ଲିଲେଖ, ଯୀଶଯସ୍ୟ ତୁ ଯତ୍ ମୂଲଂ ତତ୍ ପ୍ରକାଶିଷ୍ୟତେ ତଦା| ସର୍ୱ୍ୱଜାତୀଯନୃଣାଞ୍ଚ ଶାସକଃ ସମୁଦେଷ୍ୟତି| ତତ୍ରାନ୍ୟଦେଶିଲୋକୈଶ୍ଚ ପ୍ରତ୍ୟାଶା ପ୍ରକରିଷ୍ୟତେ|| ");
INSERT INTO sanori_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","ଅତଏୱ ଯୂଯଂ ପୱିତ୍ରସ୍ୟାତ୍ମନଃ ପ୍ରଭାୱାଦ୍ ଯତ୍ ସମ୍ପୂର୍ଣାଂ ପ୍ରତ୍ୟାଶାଂ ଲପ୍ସ୍ୟଧ୍ୱେ ତଦର୍ଥଂ ତତ୍ପ୍ରତ୍ୟାଶାଜନକ ଈଶ୍ୱରଃ ପ୍ରତ୍ୟଯେନ ଯୁଷ୍ମାନ୍ ଶାନ୍ତ୍ୟାନନ୍ଦାଭ୍ୟାଂ ସମ୍ପୂର୍ଣାନ୍ କରୋତୁ| ");
INSERT INTO sanori_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","ହେ ଭ୍ରାତରୋ ଯୂଯଂ ସଦ୍ଭାୱଯୁକ୍ତାଃ ସର୍ୱ୍ୱପ୍ରକାରେଣ ଜ୍ଞାନେନ ଚ ସମ୍ପୂର୍ଣାଃ ପରସ୍ପରୋପଦେଶେ ଚ ତତ୍ପରା ଇତ୍ୟହଂ ନିଶ୍ଚିତଂ ଜାନାମି, ");
INSERT INTO sanori_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","ତଥାପ୍ୟହଂ ଯତ୍ ପ୍ରଗଲ୍ଭତରୋ ଭୱନ୍ ଯୁଷ୍ମାନ୍ ପ୍ରବୋଧଯାମି ତସ୍ୟୈକଂ କାରଣମିଦଂ| ");
INSERT INTO sanori_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","ଭିନ୍ନଜାତୀଯାଃ ପୱିତ୍ରେଣାତ୍ମନା ପାୱିତନୈୱେଦ୍ୟରୂପା ଭୂତ୍ୱା ଯଦ୍ ଗ୍ରାହ୍ୟା ଭୱେଯୁସ୍ତନ୍ନିମିତ୍ତମହମ୍ ଈଶ୍ୱରସ୍ୟ ସୁସଂୱାଦଂ ପ୍ରଚାରଯିତୁଂ ଭିନ୍ନଜାତୀଯାନାଂ ମଧ୍ୟେ ଯୀଶୁଖ୍ରୀଷ୍ଟସ୍ୟ ସେୱକତ୍ୱଂ ଦାନଂ ଈଶ୍ୱରାତ୍ ଲବ୍ଧୱାନସ୍ମି| ");
INSERT INTO sanori_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","ଈଶ୍ୱରଂ ପ୍ରତି ଯୀଶୁଖ୍ରୀଷ୍ଟେନ ମମ ଶ୍ଲାଘାକରଣସ୍ୟ କାରଣମ୍ ଆସ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","ଭିନ୍ନଦେଶିନ ଆଜ୍ଞାଗ୍ରାହିଣଃ କର୍ତ୍ତୁଂ ଖ୍ରୀଷ୍ଟୋ ୱାକ୍ୟେନ କ୍ରିଯଯା ଚ, ଆଶ୍ଚର୍ୟ୍ୟଲକ୍ଷଣୈଶ୍ଚିତ୍ରକ୍ରିଯାଭିଃ ପୱିତ୍ରସ୍ୟାତ୍ମନଃ ପ୍ରଭାୱେନ ଚ ଯାନି କର୍ମ୍ମାଣି ମଯା ସାଧିତୱାନ୍, ");
INSERT INTO sanori_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","କେୱଲଂ ତାନ୍ୟେୱ ୱିନାନ୍ୟସ୍ୟ କସ୍ୟଚିତ୍ କର୍ମ୍ମଣୋ ୱର୍ଣନାଂ କର୍ତ୍ତୁଂ ପ୍ରଗଲ୍ଭୋ ନ ଭୱାମି| ତସ୍ମାତ୍ ଆ ଯିରୂଶାଲମ ଇଲ୍ଲୂରିକଂ ଯାୱତ୍ ସର୍ୱ୍ୱତ୍ର ଖ୍ରୀଷ୍ଟସ୍ୟ ସୁସଂୱାଦଂ ପ୍ରାଚାରଯଂ| ");
INSERT INTO sanori_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","ଅନ୍ୟେନ ନିଚିତାଯାଂ ଭିତ୍ତାୱହଂ ଯନ୍ନ ନିଚିନୋମି ତନ୍ନିମିତ୍ତଂ ଯତ୍ର ଯତ୍ର ସ୍ଥାନେ ଖ୍ରୀଷ୍ଟସ୍ୟ ନାମ କଦାପି କେନାପି ନ ଜ୍ଞାପିତଂ ତତ୍ର ତତ୍ର ସୁସଂୱାଦଂ ପ୍ରଚାରଯିତୁମ୍ ଅହଂ ଯତେ| ");
INSERT INTO sanori_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","ଯାଦୃଶଂ ଲିଖିତମ୍ ଆସ୍ତେ, ଯୈ ର୍ୱାର୍ତ୍ତା ତସ୍ୟ ନ ପ୍ରାପ୍ତା ଦର୍ଶନଂ ତୈସ୍ତୁ ଲପ୍ସ୍ୟତେ| ଯୈଶ୍ଚ ନୈୱ ଶ୍ରୁତଂ କିଞ୍ଚିତ୍ ବୋଦ୍ଧୁଂ ଶକ୍ଷ୍ୟନ୍ତି ତେ ଜନାଃ|| ");
INSERT INTO sanori_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","ତସ୍ମାଦ୍ ଯୁଷ୍ମତ୍ସମୀପଗମନାଦ୍ ଅହଂ ମୁହୁର୍ମୁହୁ ର୍ନିୱାରିତୋଽଭୱଂ| ");
INSERT INTO sanori_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","କିନ୍ତ୍ୱିଦାନୀମ୍ ଅତ୍ର ପ୍ରଦେଶେଷୁ ମଯା ନ ଗତଂ ସ୍ଥାନଂ କିମପି ନାୱଶିଷ୍ୟତେ ଯୁଷ୍ମତ୍ସମୀପଂ ଗନ୍ତୁଂ ବହୁୱତ୍ସରାନାରଭ୍ୟ ମାମକୀନାକାଙ୍କ୍ଷା ଚ ୱିଦ୍ୟତ ଇତି ହେତୋଃ ");
INSERT INTO sanori_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","ସ୍ପାନିଯାଦେଶଗମନକାଲେଽହଂ ଯୁଷ୍ମନ୍ମଧ୍ୟେନ ଗଚ୍ଛନ୍ ଯୁଷ୍ମାନ୍ ଆଲୋକିଷ୍ୟେ, ତତଃ ପରଂ ଯୁଷ୍ମତ୍ସମ୍ଭାଷଣେନ ତୃପ୍ତିଂ ପରିଲଭ୍ୟ ତଦ୍ଦେଶଗମନାର୍ଥଂ ଯୁଷ୍ମାଭି ର୍ୱିସର୍ଜଯିଷ୍ୟେ, ଈଦୃଶୀ ମଦୀଯା ପ୍ରତ୍ୟାଶା ୱିଦ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","କିନ୍ତୁ ସାମ୍ପ୍ରତଂ ପୱିତ୍ରଲୋକାନାଂ ସେୱନାଯ ଯିରୂଶାଲମ୍ନଗରଂ ୱ୍ରଜାମି| ");
INSERT INTO sanori_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","ଯତୋ ଯିରୂଶାଲମସ୍ଥପୱିତ୍ରଲୋକାନାଂ ମଧ୍ୟେ ଯେ ଦରିଦ୍ରା ଅର୍ଥୱିଶ୍ରାଣନେନ ତାନୁପକର୍ତ୍ତୁଂ ମାକିଦନିଯାଦେଶୀଯା ଆଖାଯାଦେଶୀଯାଶ୍ଚ ଲୋକା ଐଚ୍ଛନ୍| ");
INSERT INTO sanori_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","ଏଷା ତେଷାଂ ସଦିଚ୍ଛା ଯତସ୍ତେ ତେଷାମ୍ ଋଣିନଃ ସନ୍ତି ଯତୋ ହେତୋ ର୍ଭିନ୍ନଜାତୀଯା ଯେଷାଂ ପରମାର୍ଥସ୍ୟାଂଶିନୋ ଜାତା ଐହିକୱିଷଯେ ତେଷାମୁପକାରସ୍ତୈଃ କର୍ତ୍ତୱ୍ୟଃ| ");
INSERT INTO sanori_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","ଅତୋ ମଯା ତତ୍ କର୍ମ୍ମ ସାଧଯିତ୍ୱା ତସ୍ମିନ୍ ଫଲେ ତେଭ୍ୟଃ ସମର୍ପିତେ ଯୁଷ୍ମନ୍ମଧ୍ୟେନ ସ୍ପାନିଯାଦେଶୋ ଗମିଷ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","ଯୁଷ୍ମତ୍ସମୀପେ ମମାଗମନସମଯେ ଖ୍ରୀଷ୍ଟସ୍ୟ ସୁସଂୱାଦସ୍ୟ ପୂର୍ଣୱରେଣ ସମ୍ବଲିତଃ ସନ୍ ଅହମ୍ ଆଗମିଷ୍ୟାମି ଇତି ମଯା ଜ୍ଞାଯତେ| ");
INSERT INTO sanori_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","ହେ ଭ୍ରାତୃଗଣ ପ୍ରଭୋ ର୍ୟୀଶୁଖ୍ରୀଷ୍ଟସ୍ୟ ନାମ୍ନା ପୱିତ୍ରସ୍ୟାତ୍ମାନଃ ପ୍ରେମ୍ନା ଚ ୱିନଯେଽହଂ ");
INSERT INTO sanori_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","ଯିହୂଦାଦେଶସ୍ଥାନାମ୍ ଅୱିଶ୍ୱାସିଲୋକାନାଂ କରେଭ୍ୟୋ ଯଦହଂ ରକ୍ଷାଂ ଲଭେଯ ମଦୀଯୈତେନ ସେୱନକର୍ମ୍ମଣା ଚ ଯଦ୍ ଯିରୂଶାଲମସ୍ଥାଃ ପୱିତ୍ରଲୋକାସ୍ତୁଷ୍ୟେଯୁଃ, ");
INSERT INTO sanori_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","ତଦର୍ଥଂ ଯୂଯଂ ମତ୍କୃତ ଈଶ୍ୱରାଯ ପ୍ରାର୍ଥଯମାଣା ଯତଧ୍ୱଂ ତେନାହମ୍ ଈଶ୍ୱରେଚ୍ଛଯା ସାନନ୍ଦଂ ଯୁଷ୍ମତ୍ସମୀପଂ ଗତ୍ୱା ଯୁଷ୍ମାଭିଃ ସହିତଃ ପ୍ରାଣାନ୍ ଆପ୍ୟାଯିତୁଂ ପାରଯିଷ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","ଶାନ୍ତିଦାଯକ ଈଶ୍ୱରୋ ଯୁଷ୍ମାକଂ ସର୍ୱ୍ୱେଷାଂ ସଙ୍ଗୀ ଭୂଯାତ୍| ଇତି| ");
INSERT INTO sanori_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","କିଂକ୍ରୀଯାନଗରୀଯଧର୍ମ୍ମସମାଜସ୍ୟ ପରିଚାରିକା ଯା ଫୈବୀନାମିକାସ୍ମାକଂ ଧର୍ମ୍ମଭଗିନୀ ତସ୍ୟାଃ କୃତେଽହଂ ଯୁଷ୍ମାନ୍ ନିୱେଦଯାମି, ");
INSERT INTO sanori_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","ଯୂଯଂ ତାଂ ପ୍ରଭୁମାଶ୍ରିତାଂ ୱିଜ୍ଞାଯ ତସ୍ୟା ଆତିଥ୍ୟଂ ପୱିତ୍ରଲୋକାର୍ହଂ କୁରୁଧ୍ୱଂ, ଯୁଷ୍ମତ୍ତସ୍ତସ୍ୟା ଯ ଉପକାରୋ ଭୱିତୁଂ ଶକ୍ନୋତି ତଂ କୁରୁଧ୍ୱଂ, ଯସ୍ମାତ୍ ତଯା ବହୂନାଂ ମମ ଚୋପକାରଃ କୃତଃ| ");
INSERT INTO sanori_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","ଅପରଞ୍ଚ ଖ୍ରୀଷ୍ଟସ୍ୟ ଯୀଶୋଃ କର୍ମ୍ମଣି ମମ ସହକାରିଣୌ ମମ ପ୍ରାଣରକ୍ଷାର୍ଥଞ୍ଚ ସ୍ୱପ୍ରାଣାନ୍ ପଣୀକୃତୱନ୍ତୌ ଯୌ ପ୍ରିଷ୍କିଲ୍ଲାକ୍କିଲୌ ତୌ ମମ ନମସ୍କାରଂ ଜ୍ଞାପଯଧ୍ୱଂ| ");
INSERT INTO sanori_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","ତାଭ୍ୟାମ୍ ଉପକାରାପ୍ତିଃ କେୱଲଂ ମଯା ସ୍ୱୀକର୍ତ୍ତୱ୍ୟେତି ନହି ଭିନ୍ନଦେଶୀଯୈଃ ସର୍ୱ୍ୱଧର୍ମ୍ମସମାଜୈରପି| ");
INSERT INTO sanori_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","ଅପରଞ୍ଚ ତଯୋ ର୍ଗୃହେ ସ୍ଥିତାନ୍ ଧର୍ମ୍ମସମାଜଲୋକାନ୍ ମମ ନମସ୍କାରଂ ଜ୍ଞାପଯଧ୍ୱଂ| ତଦ୍ୱତ୍ ଆଶିଯାଦେଶେ ଖ୍ରୀଷ୍ଟସ୍ୟ ପକ୍ଷେ ପ୍ରଥମଜାତଫଲସ୍ୱରୂପୋ ଯ ଇପେନିତନାମା ମମ ପ୍ରିଯବନ୍ଧୁସ୍ତମପି ମମ ନମସ୍କାରଂ ଜ୍ଞାପଯଧ୍ୱଂ| ");
INSERT INTO sanori_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","ଅପରଂ ବହୁଶ୍ରମେଣାସ୍ମାନ୍ ଅସେୱତ ଯା ମରିଯମ୍ ତାମପି ନମସ୍କାରଂ ଜ୍ଞାପଯଧ୍ୱଂ| ");
INSERT INTO sanori_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","ଅପରଞ୍ଚ ପ୍ରେରିତେଷୁ ଖ୍ୟାତକୀର୍ତ୍ତୀ ମଦଗ୍ରେ ଖ୍ରୀଷ୍ଟାଶ୍ରିତୌ ମମ ସ୍ୱଜାତୀଯୌ ସହବନ୍ଦିନୌ ଚ ଯାୱାନ୍ଦ୍ରନୀକଯୂନିଯୌ ତୌ ମମ ନମସ୍କାରଂ ଜ୍ଞାପଯଧ୍ୱଂ| ");
INSERT INTO sanori_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","ତଥା ପ୍ରଭୌ ମତ୍ପ୍ରିଯତମମ୍ ଆମ୍ପ୍ଲିଯମପି ମମ ନମସ୍କାରଂ ଜ୍ଞାପଯଧ୍ୱଂ| ");
INSERT INTO sanori_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","ଅପରଂ ଖ୍ରୀଷ୍ଟସେୱାଯାଂ ମମ ସହକାରିଣମ୍ ଊର୍ବ୍ବାଣଂ ମମ ପ୍ରିଯତମଂ ସ୍ତାଖୁଞ୍ଚ ମମ ନମସ୍କାରଂ ଜ୍ଞାପଯଧ୍ୱଂ| ");
INSERT INTO sanori_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","ଅପରଂ ଖ୍ରୀଷ୍ଟେନ ପରୀକ୍ଷିତମ୍ ଆପିଲ୍ଲିଂ ମମ ନମସ୍କାରଂ ୱଦତ, ଆରିଷ୍ଟବୂଲସ୍ୟ ପରିଜନାଂଶ୍ଚ ମମ ନମସ୍କାରଂ ଜ୍ଞାପଯଧ୍ୱଂ| ");
INSERT INTO sanori_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","ଅପରଂ ମମ ଜ୍ଞାତିଂ ହେରୋଦିଯୋନଂ ମମ ନମସ୍କାରଂ ୱଦତ, ତଥା ନାର୍କିସସ୍ୟ ପରିୱାରାଣାଂ ମଧ୍ୟେ ଯେ ପ୍ରଭୁମାଶ୍ରିତାସ୍ତାନ୍ ମମ ନମସ୍କାରଂ ୱଦତ| ");
INSERT INTO sanori_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","ଅପରଂ ପ୍ରଭୋଃ ସେୱାଯାଂ ପରିଶ୍ରମକାରିଣ୍ୟୌ ତ୍ରୁଫେନାତ୍ରୁଫୋଷେ ମମ ନମସ୍କାରଂ ୱଦତ, ତଥା ପ୍ରଭୋଃ ସେୱାଯାମ୍ ଅତ୍ୟନ୍ତଂ ପରିଶ୍ରମକାରିଣୀ ଯା ପ୍ରିଯା ପର୍ଷିସ୍ତାଂ ନମସ୍କାରଂ ଜ୍ଞାପଯଧ୍ୱଂ| ");
INSERT INTO sanori_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","ଅପରଂ ପ୍ରଭୋରଭିରୁଚିତଂ ରୂଫଂ ମମ ଧର୍ମ୍ମମାତା ଯା ତସ୍ୟ ମାତା ତାମପି ନମସ୍କାରଂ ୱଦତ| ");
INSERT INTO sanori_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","ଅପରମ୍ ଅସୁଂକୃତଂ ଫ୍ଲିଗୋନଂ ହର୍ମ୍ମଂ ପାତ୍ରବଂ ହର୍ମ୍ମିମ୍ ଏତେଷାଂ ସଙ୍ଗିଭ୍ରାତୃଗଣଞ୍ଚ ନମସ୍କାରଂ ଜ୍ଞାପଯଧ୍ୱଂ| ");
INSERT INTO sanori_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","ଅପରଂ ଫିଲଲଗୋ ଯୂଲିଯା ନୀରିଯସ୍ତସ୍ୟ ଭଗିନ୍ୟଲୁମ୍ପା ଚୈତାନ୍ ଏତୈଃ ସାର୍ଦ୍ଧଂ ଯାୱନ୍ତଃ ପୱିତ୍ରଲୋକା ଆସତେ ତାନପି ନମସ୍କାରଂ ଜ୍ଞାପଯଧ୍ୱଂ| ");
INSERT INTO sanori_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","ଯୂଯଂ ପରସ୍ପରଂ ପୱିତ୍ରଚୁମ୍ବନେନ ନମସ୍କୁରୁଧ୍ୱଂ| ଖ୍ରୀଷ୍ଟସ୍ୟ ଧର୍ମ୍ମସମାଜଗଣୋ ଯୁଷ୍ମାନ୍ ନମସ୍କୁରୁତେ| ");
INSERT INTO sanori_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","ହେ ଭ୍ରାତରୋ ଯୁଷ୍ମାନ୍ ୱିନଯେଽହଂ ଯୁଷ୍ମାଭି ର୍ୟା ଶିକ୍ଷା ଲବ୍ଧା ତାମ୍ ଅତିକ୍ରମ୍ୟ ଯେ ୱିଚ୍ଛେଦାନ୍ ୱିଘ୍ନାଂଶ୍ଚ କୁର୍ୱ୍ୱନ୍ତି ତାନ୍ ନିଶ୍ଚିନୁତ ତେଷାଂ ସଙ୍ଗଂ ୱର୍ଜଯତ ଚ| ");
INSERT INTO sanori_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","ଯତସ୍ତାଦୃଶା ଲୋକା ଅସ୍ମାକଂ ପ୍ରଭୋ ର୍ୟୀଶୁଖ୍ରୀଷ୍ଟସ୍ୟ ଦାସା ଇତି ନହି କିନ୍ତୁ ସ୍ୱୋଦରସ୍ୟୈୱ ଦାସାଃ; ଅପରଂ ପ୍ରଣଯୱଚନୈ ର୍ମଧୁରୱାକ୍ୟୈଶ୍ଚ ସରଲଲୋକାନାଂ ମନାଂସି ମୋହଯନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","ଯୁଷ୍ମାକମ୍ ଆଜ୍ଞାଗ୍ରାହିତ୍ୱଂ ସର୍ୱ୍ୱତ୍ର ସର୍ୱ୍ୱୈ ର୍ଜ୍ଞାତଂ ତତୋଽହଂ ଯୁଷ୍ମାସୁ ସାନନ୍ଦୋଽଭୱଂ ତଥାପି ଯୂଯଂ ଯତ୍ ସତ୍ଜ୍ଞାନେନ ଜ୍ଞାନିନଃ କୁଜ୍ଞାନେे ଚାତତ୍ପରା ଭୱେତେତି ମମାଭିଲାଷଃ| ");
INSERT INTO sanori_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","ଅଧିକନ୍ତୁ ଶାନ୍ତିଦାଯକ ଈଶ୍ୱରଃ ଶୈତାନମ୍ ଅୱିଲମ୍ବଂ ଯୁଷ୍ମାକଂ ପଦାନାମ୍ ଅଧୋ ମର୍ଦ୍ଦିଷ୍ୟତି| ଅସ୍ମାକଂ ପ୍ରଭୁ ର୍ୟୀଶୁଖ୍ରୀଷ୍ଟୋ ଯୁଷ୍ମାସୁ ପ୍ରସାଦଂ କ୍ରିଯାତ୍| ଇତି| ");
INSERT INTO sanori_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","ମମ ସହକାରୀ ତୀମଥିଯୋ ମମ ଜ୍ଞାତଯୋ ଲୂକିଯୋ ଯାସୋନ୍ ସୋସିପାତ୍ରଶ୍ଚେମେ ଯୁଷ୍ମାନ୍ ନମସ୍କୁର୍ୱ୍ୱନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","ଅପରମ୍ ଏତତ୍ପତ୍ରଲେଖକସ୍ତର୍ତ୍ତିଯନାମାହମପି ପ୍ରଭୋ ର୍ନାମ୍ନା ଯୁଷ୍ମାନ୍ ନମସ୍କରୋମି| ");
INSERT INTO sanori_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","ତଥା କୃତ୍ସ୍ନଧର୍ମ୍ମସମାଜସ୍ୟ ମମ ଚାତିଥ୍ୟକାରୀ ଗାଯୋ ଯୁଷ୍ମାନ୍ ନମସ୍କରୋତି| ଅପରମ୍ ଏତନ୍ନଗରସ୍ୟ ଧନରକ୍ଷକ ଇରାସ୍ତଃ କ୍କାର୍ତ୍ତନାମକଶ୍ଚୈକୋ ଭ୍ରାତା ତାୱପି ଯୁଷ୍ମାନ୍ ନମସ୍କୁରୁତଃ| ");
INSERT INTO sanori_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","ଅସ୍ମାକଂ ପ୍ରଭୁ ର୍ୟୀଶୁଖ୍ରୀଷ୍ଟା ଯୁଷ୍ମାସୁ ସର୍ୱ୍ୱେଷୁ ପ୍ରସାଦଂ କ୍ରିଯାତ୍| ଇତି| ");
INSERT INTO sanori_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","ପୂର୍ୱ୍ୱକାଲିକଯୁଗେଷୁ ପ୍ରଚ୍ଛନ୍ନା ଯା ମନ୍ତ୍ରଣାଧୁନା ପ୍ରକାଶିତା ଭୂତ୍ୱା ଭୱିଷ୍ୟଦ୍ୱାଦିଲିଖିତଗ୍ରନ୍ଥଗଣସ୍ୟ ପ୍ରମାଣାଦ୍ ୱିଶ୍ୱାସେନ ଗ୍ରହଣାର୍ଥଂ ସଦାତନସ୍ୟେଶ୍ୱରସ୍ୟାଜ୍ଞଯା ସର୍ୱ୍ୱଦେଶୀଯଲୋକାନ୍ ଜ୍ଞାପ୍ୟତେ, ");
INSERT INTO sanori_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","ତସ୍ୟା ମନ୍ତ୍ରଣାଯା ଜ୍ଞାନଂ ଲବ୍ଧ୍ୱା ମଯା ଯଃ ସୁସଂୱାଦୋ ଯୀଶୁଖ୍ରୀଷ୍ଟମଧି ପ୍ରଚାର୍ୟ୍ୟତେ, ତଦନୁସାରାଦ୍ ଯୁଷ୍ମାନ୍ ଧର୍ମ୍ମେ ସୁସ୍ଥିରାନ୍ କର୍ତ୍ତୁଂ ସମର୍ଥୋ ଯୋଽଦ୍ୱିତୀଯଃ ");
INSERT INTO sanori_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","ସର୍ୱ୍ୱଜ୍ଞ ଈଶ୍ୱରସ୍ତସ୍ୟ ଧନ୍ୟୱାଦୋ ଯୀଶୁଖ୍ରୀଷ୍ଟେନ ସନ୍ତତଂ ଭୂଯାତ୍| ଇତି|");
INSERT INTO sanori_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","ଯାୱନ୍ତଃ ପୱିତ୍ରା ଲୋକାଃ ସ୍ୱେଷାମ୍ ଅସ୍ମାକଞ୍ଚ ୱସତିସ୍ଥାନେଷ୍ୱସ୍ମାକଂ ପ୍ରଭୋ ର୍ୟୀଶୋଃ ଖ୍ରୀଷ୍ଟସ୍ୟ ନାମ୍ନା ପ୍ରାର୍ଥଯନ୍ତେ ତୈଃ ସହାହୂତାନାଂ ଖ୍ରୀଷ୍ଟେନ ଯୀଶୁନା ପୱିତ୍ରୀକୃତାନାଂ ଲୋକାନାଂ ଯ ଈଶ୍ୱରୀଯଧର୍ମ୍ମସମାଜଃ କରିନ୍ଥନଗରେ ୱିଦ୍ୟତେ ");
INSERT INTO sanori_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","ତଂ ପ୍ରତୀଶ୍ୱରସ୍ୟେଚ୍ଛଯାହୂତୋ ଯୀଶୁଖ୍ରୀଷ୍ଟସ୍ୟ ପ୍ରେରିତଃ ପୌଲଃ ସୋସ୍ଥିନିନାମା ଭ୍ରାତା ଚ ପତ୍ରଂ ଲିଖତି| ");
INSERT INTO sanori_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","ଅସ୍ମାକଂ ପିତ୍ରେଶ୍ୱରେଣ ପ୍ରଭୁନା ଯୀଶୁଖ୍ରୀଷ୍ଟେନ ଚ ପ୍ରସାଦଃ ଶାନ୍ତିଶ୍ଚ ଯୁଷ୍ମଭ୍ୟଂ ଦୀଯତାଂ| ");
INSERT INTO sanori_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","ଈଶ୍ୱରୋ ଯୀଶୁଖ୍ରୀଷ୍ଟେନ ଯୁଷ୍ମାନ୍ ପ୍ରତି ପ୍ରସାଦଂ ପ୍ରକାଶିତୱାନ୍, ତସ୍ମାଦହଂ ଯୁଷ୍ମନ୍ନିମିତ୍ତଂ ସର୍ୱ୍ୱଦା ମଦୀଯେଶ୍ୱରଂ ଧନ୍ୟଂ ୱଦାମି| ");
INSERT INTO sanori_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","ଖ୍ରୀଷ୍ଟସମ୍ବନ୍ଧୀଯଂ ସାକ୍ଷ୍ୟଂ ଯୁଷ୍ମାକଂ ମଧ୍ୟେ ଯେନ ପ୍ରକାରେଣ ସପ୍ରମାଣମ୍ ଅଭୱତ୍ ");
INSERT INTO sanori_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","ତେନ ଯୂଯଂ ଖ୍ରୀଷ୍ଟାତ୍ ସର୍ୱ୍ୱୱିଧୱକ୍ତୃତାଜ୍ଞାନାଦୀନି ସର୍ୱ୍ୱଧନାନି ଲବ୍ଧୱନ୍ତଃ| ");
INSERT INTO sanori_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","ତତୋଽସ୍ମତ୍ପ୍ରଭୋ ର୍ୟୀଶୁଖ୍ରୀଷ୍ଟସ୍ୟ ପୁନରାଗମନଂ ପ୍ରତୀକ୍ଷମାଣାନାଂ ଯୁଷ୍ମାକଂ କସ୍ୟାପି ୱରସ୍ୟାଭାୱୋ ନ ଭୱତି| ");
INSERT INTO sanori_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","ଅପରମ୍ ଅସ୍ମାକଂ ପ୍ରଭୋ ର୍ୟୀଶୁଖ୍ରୀଷ୍ଟସ୍ୟ ଦିୱସେ ଯୂଯଂ ଯନ୍ନିର୍ଦ୍ଦୋଷା ଭୱେତ ତଦର୍ଥଂ ସଏୱ ଯାୱଦନ୍ତଂ ଯୁଷ୍ମାନ୍ ସୁସ୍ଥିରାନ୍ କରିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","ଯ ଈଶ୍ୱରଃ ସ୍ୱପୁତ୍ରସ୍ୟାସ୍ମତ୍ପ୍ରଭୋ ର୍ୟୀଶୁଖ୍ରୀଷ୍ଟସ୍ୟାଂଶିନଃ କର୍ତ୍ତୁଂ ଯୁଷ୍ମାନ୍ ଆହୂତୱାନ୍ ସ ୱିଶ୍ୱସନୀଯଃ| ");
INSERT INTO sanori_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","ହେ ଭ୍ରାତରଃ, ଅସ୍ମାକଂ ପ୍ରଭୁଯୀଶୁଖ୍ରୀଷ୍ଟସ୍ୟ ନାମ୍ନା ଯୁଷ୍ମାନ୍ ୱିନଯେଽହଂ ସର୍ୱ୍ୱୈ ର୍ୟୁଷ୍ମାଭିରେକରୂପାଣି ୱାକ୍ୟାନି କଥ୍ୟନ୍ତାଂ ଯୁଷ୍ମନ୍ମଧ୍ୟେ ଭିନ୍ନସଙ୍ଘାତା ନ ଭୱନ୍ତୁ ମନୋୱିଚାରଯୋରୈକ୍ୟେନ ଯୁଷ୍ମାକଂ ସିଦ୍ଧତ୍ୱଂ ଭୱତୁ| ");
INSERT INTO sanori_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","ହେ ମମ ଭ୍ରାତରୋ ଯୁଷ୍ମନ୍ମଧ୍ୟେ ୱିୱାଦା ଜାତା ଇତି ୱାର୍ତ୍ତାମହଂ କ୍ଲୋଯ୍ୟାଃ ପରିଜନୈ ର୍ଜ୍ଞାପିତଃ| ");
INSERT INTO sanori_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","ମମାଭିପ୍ରେତମିଦଂ ଯୁଷ୍ମାକଂ କଶ୍ଚିତ୍ କଶ୍ଚିଦ୍ ୱଦତି ପୌଲସ୍ୟ ଶିଷ୍ୟୋଽହମ୍ ଆପଲ୍ଲୋଃ ଶିଷ୍ୟୋଽହଂ କୈଫାଃ ଶିଷ୍ୟୋଽହଂ ଖ୍ରୀଷ୍ଟସ୍ୟ ଶିଷ୍ୟୋଽହମିତି ଚ| ");
INSERT INTO sanori_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","ଖ୍ରୀଷ୍ଟସ୍ୟ କିଂ ୱିଭେଦଃ କୃତଃ? ପୌଲଃ କିଂ ଯୁଷ୍ମତ୍କୃତେ କ୍ରୁଶେ ହତଃ? ପୌଲସ୍ୟ ନାମ୍ନା ୱା ଯୂଯଂ କିଂ ମଜ୍ଜିତାଃ? ");
INSERT INTO sanori_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","କ୍ରିଷ୍ପଗାଯୌ ୱିନା ଯୁଷ୍ମାକଂ ମଧ୍ୟେଽନ୍ୟଃ କୋଽପି ମଯା ନ ମଜ୍ଜିତ ଇତି ହେତୋରହମ୍ ଈଶ୍ୱରଂ ଧନ୍ୟଂ ୱଦାମି| ");
INSERT INTO sanori_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","ଏତେନ ମମ ନାମ୍ନା ମାନୱା ମଯା ମଜ୍ଜିତା ଇତି ୱକ୍ତୁଂ କେନାପି ନ ଶକ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","ଅପରଂ ସ୍ତିଫାନସ୍ୟ ପରିଜନା ମଯା ମଜ୍ଜିତାସ୍ତଦନ୍ୟଃ କଶ୍ଚିଦ୍ ଯନ୍ମଯା ମଜ୍ଜିତସ୍ତଦହଂ ନ ୱେଦ୍ମି| ");
INSERT INTO sanori_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","ଖ୍ରୀଷ୍ଟେନାହଂ ମଜ୍ଜନାର୍ଥଂ ନ ପ୍ରେରିତଃ କିନ୍ତୁ ସୁସଂୱାଦସ୍ୟ ପ୍ରଚାରାର୍ଥମେୱ; ସୋଽପି ୱାକ୍ପଟୁତଯା ମଯା ନ ପ୍ରଚାରିତୱ୍ୟଃ, ଯତସ୍ତଥା ପ୍ରଚାରିତେ ଖ୍ରୀଷ୍ଟସ୍ୟ କ୍ରୁଶେ ମୃତ୍ୟୁଃ ଫଲହୀନୋ ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","ଯତୋ ହେତୋ ର୍ୟେ ୱିନଶ୍ୟନ୍ତି ତେ ତାଂ କ୍ରୁଶସ୍ୟ ୱାର୍ତ୍ତାଂ ପ୍ରଲାପମିୱ ମନ୍ୟନ୍ତେ କିଞ୍ଚ ପରିତ୍ରାଣଂ ଲଭମାନେଷ୍ୱସ୍ମାସୁ ସା ଈଶ୍ୱରୀଯଶକ୍ତିସ୍ୱରୂପା| ");
INSERT INTO sanori_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","ତସ୍ମାଦିତ୍ଥଂ ଲିଖିତମାସ୍ତେ, ଜ୍ଞାନୱତାନ୍ତୁ ଯତ୍ ଜ୍ଞାନଂ ତନ୍ମଯା ନାଶଯିଷ୍ୟତେ| ୱିଲୋପଯିଷ୍ୟତେ ତଦ୍ୱଦ୍ ବୁଦ୍ଧି ର୍ବଦ୍ଧିମତାଂ ମଯା|| ");
INSERT INTO sanori_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","ଜ୍ଞାନୀ କୁତ୍ର? ଶାସ୍ତ୍ରୀ ୱା କୁତ୍ର? ଇହଲୋକସ୍ୟ ୱିଚାରତତ୍ପରୋ ୱା କୁତ୍ର? ଇହଲୋକସ୍ୟ ଜ୍ଞାନଂ କିମୀଶ୍ୱରେଣ ମୋହୀକୃତଂ ନହି? ");
INSERT INTO sanori_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","ଈଶ୍ୱରସ୍ୟ ଜ୍ଞାନାଦ୍ ଇହଲୋକସ୍ୟ ମାନୱାଃ ସ୍ୱଜ୍ଞାନେନେଶ୍ୱରସ୍ୟ ତତ୍ତ୍ୱବୋଧଂ ନ ପ୍ରାପ୍ତୱନ୍ତସ୍ତସ୍ମାଦ୍ ଈଶ୍ୱରଃ ପ୍ରଚାରରୂପିଣା ପ୍ରଲାପେନ ୱିଶ୍ୱାସିନଃ ପରିତ୍ରାତୁଂ ରୋଚିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","ଯିହୂଦୀଯଲୋକା ଲକ୍ଷଣାନି ଦିଦୃକ୍ଷନ୍ତି ଭିନ୍ନଦେଶୀଯଲୋକାସ୍ତୁ ୱିଦ୍ୟାଂ ମୃଗଯନ୍ତେ, ");
INSERT INTO sanori_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","ୱଯଞ୍ଚ କ୍ରୁଶେ ହତଂ ଖ୍ରୀଷ୍ଟଂ ପ୍ରଚାରଯାମଃ| ତସ୍ୟ ପ୍ରଚାରୋ ଯିହୂଦୀଯୈ ର୍ୱିଘ୍ନ ଇୱ ଭିନ୍ନଦେଶୀଯୈଶ୍ଚ ପ୍ରଲାପ ଇୱ ମନ୍ୟତେ, ");
INSERT INTO sanori_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","କିନ୍ତୁ ଯିହୂଦୀଯାନାଂ ଭିନ୍ନଦେଶୀଯାନାଞ୍ଚ ମଧ୍ୟେ ଯେ ଆହୂତାସ୍ତେଷୁ ସ ଖ୍ରୀଷ୍ଟ ଈଶ୍ୱରୀଯଶକ୍ତିରିୱେଶ୍ୱରୀଯଜ୍ଞାନମିୱ ଚ ପ୍ରକାଶତେ| ");
INSERT INTO sanori_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","ଯତ ଈଶ୍ୱରେ ଯଃ ପ୍ରଲାପ ଆରୋପ୍ୟତେ ସ ମାନୱାତିରିକ୍ତଂ ଜ୍ଞାନମେୱ ଯଚ୍ଚ ଦୌର୍ବ୍ବଲ୍ୟମ୍ ଈଶ୍ୱର ଆରୋପ୍ୟତେ ତତ୍ ମାନୱାତିରିକ୍ତଂ ବଲମେୱ| ");
INSERT INTO sanori_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","ହେ ଭ୍ରାତରଃ, ଆହୂତଯୁଷ୍ମଦ୍ଗଣୋ ଯଷ୍ମାଭିରାଲୋକ୍ୟତାଂ ତନ୍ମଧ୍ୟେ ସାଂସାରିକଜ୍ଞାନେନ ଜ୍ଞାନୱନ୍ତଃ ପରାକ୍ରମିଣୋ ୱା କୁଲୀନା ୱା ବହୱୋ ନ ୱିଦ୍ୟନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","ଯତ ଈଶ୍ୱରୋ ଜ୍ଞାନୱତସ୍ତ୍ରପଯିତୁଂ ମୂର୍ଖଲୋକାନ୍ ରୋଚିତୱାନ୍ ବଲାନି ଚ ତ୍ରପଯିତୁମ୍ ଈଶ୍ୱରୋ ଦୁର୍ବ୍ବଲାନ୍ ରୋଚିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","ତଥା ୱର୍ତ୍ତମାନଲୋକାନ୍ ସଂସ୍ଥିତିଭ୍ରଷ୍ଟାନ୍ କର୍ତ୍ତୁମ୍ ଈଶ୍ୱରୋ ଜଗତୋଽପକୃଷ୍ଟାନ୍ ହେଯାନ୍ ଅୱର୍ତ୍ତମାନାଂଶ୍ଚାଭିରୋଚିତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","ତତ ଈଶ୍ୱରସ୍ୟ ସାକ୍ଷାତ୍ କେନାପ୍ୟାତ୍ମଶ୍ଲାଘା ନ କର୍ତ୍ତୱ୍ୟା| ");
INSERT INTO sanori_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","ଯୂଯଞ୍ଚ ତସ୍ମାତ୍ ଖ୍ରୀଷ୍ଟେ ଯୀଶୌ ସଂସ୍ଥିତିଂ ପ୍ରାପ୍ତୱନ୍ତଃ ସ ଈଶ୍ୱରାଦ୍ ଯୁଷ୍ମାକଂ ଜ୍ଞାନଂ ପୁଣ୍ୟଂ ପୱିତ୍ରତ୍ୱଂ ମୁକ୍ତିଶ୍ଚ ଜାତା| ");
INSERT INTO sanori_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","ଅତଏୱ ଯଦ୍ୱଦ୍ ଲିଖିତମାସ୍ତେ ତଦ୍ୱତ୍, ଯଃ କଶ୍ଚିତ୍ ଶ୍ଲାଘମାନଃ ସ୍ୟାତ୍ ଶ୍ଲାଘତାଂ ପ୍ରଭୁନା ସ ହି| ");
INSERT INTO sanori_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","ହେ ଭ୍ରାତରୋ ଯୁଷ୍ମତ୍ସମୀପେ ମମାଗମନକାଲେଽହଂ ୱକ୍ତୃତାଯା ୱିଦ୍ୟାଯା ୱା ନୈପୁଣ୍ୟେନେଶ୍ୱରସ୍ୟ ସାକ୍ଷ୍ୟଂ ପ୍ରଚାରିତୱାନ୍ ତନ୍ନହି; ");
INSERT INTO sanori_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","ଯତୋ ଯୀଶୁଖ୍ରୀଷ୍ଟଂ ତସ୍ୟ କ୍ରୁଶେ ହତତ୍ୱଞ୍ଚ ୱିନା ନାନ୍ୟତ୍ କିମପି ଯୁଷ୍ମନ୍ମଧ୍ୟେ ଜ୍ଞାପଯିତୁଂ ୱିହିତଂ ବୁଦ୍ଧୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","ଅପରଞ୍ଚାତୀୱ ଦୌର୍ବ୍ବଲ୍ୟଭୀତିକମ୍ପଯୁକ୍ତୋ ଯୁଷ୍ମାଭିଃ ସାର୍ଦ୍ଧମାସଂ| ");
INSERT INTO sanori_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","ଅପରଂ ଯୁଷ୍ମାକଂ ୱିଶ୍ୱାସୋ ଯତ୍ ମାନୁଷିକଜ୍ଞାନସ୍ୟ ଫଲଂ ନ ଭୱେତ୍ କିନ୍ତ୍ୱୀଶ୍ୱରୀଯଶକ୍ତେଃ ଫଲଂ ଭୱେତ୍, ");
INSERT INTO sanori_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","ତଦର୍ଥଂ ମମ ୱକ୍ତୃତା ମଦୀଯପ୍ରଚାରଶ୍ଚ ମାନୁଷିକଜ୍ଞାନସ୍ୟ ମଧୁରୱାକ୍ୟସମ୍ବଲିତୌ ନାସ୍ତାଂ କିନ୍ତ୍ୱାତ୍ମନଃ ଶକ୍ତେଶ୍ଚ ପ୍ରମାଣଯୁକ୍ତାୱାସ୍ତାଂ| ");
INSERT INTO sanori_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","ୱଯଂ ଜ୍ଞାନଂ ଭାଷାମହେ ତଚ୍ଚ ସିଦ୍ଧଲୋକୈ ର୍ଜ୍ଞାନମିୱ ମନ୍ୟତେ, ତଦିହଲୋକସ୍ୟ ଜ୍ଞାନଂ ନହି, ଇହଲୋକସ୍ୟ ନଶ୍ୱରାଣାମ୍ ଅଧିପତୀନାଂ ୱା ଜ୍ଞାନଂ ନହି; ");
INSERT INTO sanori_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","କିନ୍ତୁ କାଲାୱସ୍ଥାଯାଃ ପୂର୍ୱ୍ୱସ୍ମାଦ୍ ଯତ୍ ଜ୍ଞାନମ୍ ଅସ୍ମାକଂ ୱିଭୱାର୍ଥମ୍ ଈଶ୍ୱରେଣ ନିଶ୍ଚିତ୍ୟ ପ୍ରଚ୍ଛନ୍ନଂ ତନ୍ନିଗୂଢମ୍ ଈଶ୍ୱରୀଯଜ୍ଞାନଂ ପ୍ରଭାଷାମହେ| ");
INSERT INTO sanori_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","ଇହଲୋକସ୍ୟାଧିପତୀନାଂ କେନାପି ତତ୍ ଜ୍ଞାନଂ ନ ଲବ୍ଧଂ, ଲବ୍ଧେ ସତି ତେ ପ୍ରଭାୱୱିଶିଷ୍ଟଂ ପ୍ରଭୁଂ କ୍ରୁଶେ ନାହନିଷ୍ୟନ୍| ");
INSERT INTO sanori_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","ତଦ୍ୱଲ୍ଲିଖିତମାସ୍ତେ, ନେତ୍ରେଣ କ୍କାପି ନୋ ଦୃଷ୍ଟଂ କର୍ଣେନାପି ଚ ନ ଶ୍ରୁତଂ| ମନୋମଧ୍ୟେ ତୁ କସ୍ୟାପି ନ ପ୍ରୱିଷ୍ଟଂ କଦାପି ଯତ୍| ଈଶ୍ୱରେ ପ୍ରୀଯମାଣାନାଂ କୃତେ ତତ୍ ତେନ ସଞ୍ଚିତଂ| ");
INSERT INTO sanori_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","ଅପରମୀଶ୍ୱରଃ ସ୍ୱାତ୍ମନା ତଦସ୍ମାକଂ ସାକ୍ଷାତ୍ ପ୍ରାକାଶଯତ୍; ଯତ ଆତ୍ମା ସର୍ୱ୍ୱମେୱାନୁସନ୍ଧତ୍ତେ ତେନ ଚେଶ୍ୱରସ୍ୟ ମର୍ମ୍ମତତ୍ତ୍ୱମପି ବୁଧ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","ମନୁଜସ୍ୟାନ୍ତଃସ୍ଥମାତ୍ମାନଂ ୱିନା କେନ ମନୁଜେନ ତସ୍ୟ ମନୁଜସ୍ୟ ତତ୍ତ୍ୱଂ ବୁଧ୍ୟତେ? ତଦ୍ୱଦୀଶ୍ୱରସ୍ୟାତ୍ମାନଂ ୱିନା କେନାପୀଶ୍ୱରସ୍ୟ ତତ୍ତ୍ୱଂ ନ ବୁଧ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","ୱଯଞ୍ଚେହଲୋକସ୍ୟାତ୍ମାନଂ ଲବ୍ଧୱନ୍ତସ୍ତନ୍ନହି କିନ୍ତ୍ୱୀଶ୍ୱରସ୍ୟୈୱାତ୍ମାନଂ ଲବ୍ଧୱନ୍ତଃ, ତତୋ ହେତୋରୀଶ୍ୱରେଣ ସ୍ୱପ୍ରସାଦାଦ୍ ଅସ୍ମଭ୍ୟଂ ଯଦ୍ ଯଦ୍ ଦତ୍ତଂ ତତ୍ସର୍ୱ୍ୱମ୍ ଅସ୍ମାଭି ର୍ଜ୍ଞାତୁଂ ଶକ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","ତଚ୍ଚାସ୍ମାଭି ର୍ମାନୁଷିକଜ୍ଞାନସ୍ୟ ୱାକ୍ୟାନି ଶିକ୍ଷିତ୍ୱା କଥ୍ୟତ ଇତି ନହି କିନ୍ତ୍ୱାତ୍ମତୋ ୱାକ୍ୟାନି ଶିକ୍ଷିତ୍ୱାତ୍ମିକୈ ର୍ୱାକ୍ୟୈରାତ୍ମିକଂ ଭାୱଂ ପ୍ରକାଶଯଦ୍ଭିଃ କଥ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","ପ୍ରାଣୀ ମନୁଷ୍ୟ ଈଶ୍ୱରୀଯାତ୍ମନଃ ଶିକ୍ଷାଂ ନ ଗୃହ୍ଲାତି ଯତ ଆତ୍ମିକୱିଚାରେଣ ସା ୱିଚାର୍ୟ୍ୟେତି ହେତୋଃ ସ ତାଂ ପ୍ରଲାପମିୱ ମନ୍ୟତେ ବୋଦ୍ଧୁଞ୍ଚ ନ ଶକ୍ନୋତି| ");
INSERT INTO sanori_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","ଆତ୍ମିକୋ ମାନୱଃ ସର୍ୱ୍ୱାଣି ୱିଚାରଯତି କିନ୍ତୁ ସ୍ୱଯଂ କେନାପି ନ ୱିଚାର୍ୟ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","ଯତ ଈଶ୍ୱରସ୍ୟ ମନୋ ଜ୍ଞାତ୍ୱା ତମୁପଦେଷ୍ଟୁଂ କଃ ଶକ୍ନୋତି? କିନ୍ତୁ ଖ୍ରୀଷ୍ଟସ୍ୟ ମନୋଽସ୍ମାଭି ର୍ଲବ୍ଧଂ| ");
INSERT INTO sanori_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","ହେ ଭ୍ରାତରଃ, ଅହମାତ୍ମିକୈରିୱ ଯୁଷ୍ମାଭିଃ ସମଂ ସମ୍ଭାଷିତୁଂ ନାଶକ୍ନୱଂ କିନ୍ତୁ ଶାରୀରିକାଚାରିଭିଃ ଖ୍ରୀଷ୍ଟଧର୍ମ୍ମେ ଶିଶୁତୁଲ୍ୟୈଶ୍ଚ ଜନୈରିୱ ଯୁଷ୍ମାଭିଃ ସହ ସମଭାଷେ| ");
INSERT INTO sanori_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","ଯୁଷ୍ମାନ୍ କଠିନଭକ୍ଷ୍ୟଂ ନ ଭୋଜଯନ୍ ଦୁଗ୍ଧମ୍ ଅପାଯଯଂ ଯତୋ ଯୂଯଂ ଭକ୍ଷ୍ୟଂ ଗ୍ରହୀତୁଂ ତଦା ନାଶକ୍ନୁତ ଇଦାନୀମପି ନ ଶକ୍ନୁଥ, ଯତୋ ହେତୋରଧୁନାପି ଶାରୀରିକାଚାରିଣ ଆଧ୍ୱେ| ");
INSERT INTO sanori_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","ଯୁଷ୍ମନ୍ମଧ୍ୟେ ମାତ୍ସର୍ୟ୍ୟୱିୱାଦଭେଦା ଭୱନ୍ତି ତତଃ କିଂ ଶାରୀରିକାଚାରିଣୋ ନାଧ୍ୱେ ମାନୁଷିକମାର୍ଗେଣ ଚ ନ ଚରଥ? ");
INSERT INTO sanori_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","ପୌଲସ୍ୟାହମିତ୍ୟାପଲ୍ଲୋରହମିତି ୱା ଯଦ୍ୱାକ୍ୟଂ ଯୁଷ୍ମାକଂ କୈଶ୍ଚିତ୍ କୈଶ୍ଚିତ୍ କଥ୍ୟତେ ତସ୍ମାଦ୍ ଯୂଯଂ ଶାରୀରିକାଚାରିଣ ନ ଭୱଥ? ");
INSERT INTO sanori_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","ପୌଲଃ କଃ? ଆପଲ୍ଲୋ ର୍ୱା କଃ? ତୌ ପରିଚାରକମାତ୍ରୌ ତଯୋରେକୈକସ୍ମୈ ଚ ପ୍ରଭୁ ର୍ୟାଦୃକ୍ ଫଲମଦଦାତ୍ ତଦ୍ୱତ୍ ତଯୋର୍ଦ୍ୱାରା ଯୂଯଂ ୱିଶ୍ୱାସିନୋ ଜାତାଃ| ");
INSERT INTO sanori_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","ଅହଂ ରୋପିତୱାନ୍ ଆପଲ୍ଲୋଶ୍ଚ ନିଷିକ୍ତୱାନ୍ ଈଶ୍ୱରଶ୍ଚାୱର୍ଦ୍ଧଯତ୍| ");
INSERT INTO sanori_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","ଅତୋ ରୋପଯିତୃସେକ୍ତାରାୱସାରୌ ୱର୍ଦ୍ଧଯିତେଶ୍ୱର ଏୱ ସାରଃ| ");
INSERT INTO sanori_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","ରୋପଯିତୃସେକ୍ତାରୌ ଚ ସମୌ ତଯୋରେକୈକଶ୍ଚ ସ୍ୱଶ୍ରମଯୋଗ୍ୟଂ ସ୍ୱୱେତନଂ ଲପ୍ସ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","ଆୱାମୀଶ୍ୱରେଣ ସହ କର୍ମ୍ମକାରିଣୌ, ଈଶ୍ୱରସ୍ୟ ଯତ୍ କ୍ଷେତ୍ରମ୍ ଈଶ୍ୱରସ୍ୟ ଯା ନିର୍ମ୍ମିତିଃ ସା ଯୂଯମେୱ| ");
INSERT INTO sanori_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","ଈଶ୍ୱରସ୍ୟ ପ୍ରସାଦାତ୍ ମଯା ଯତ୍ ପଦଂ ଲବ୍ଧଂ ତସ୍ମାତ୍ ଜ୍ଞାନିନା ଗୃହକାରିଣେୱ ମଯା ଭିତ୍ତିମୂଲଂ ସ୍ଥାପିତଂ ତଦୁପରି ଚାନ୍ୟେନ ନିଚୀଯତେ| କିନ୍ତୁ ଯେନ ଯନ୍ନିଚୀଯତେ ତତ୍ ତେନ ୱିୱିଚ୍ୟତାଂ| ");
INSERT INTO sanori_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","ଯତୋ ଯୀଶୁଖ୍ରୀଷ୍ଟରୂପଂ ଯଦ୍ ଭିତ୍ତିମୂଲଂ ସ୍ଥାପିତଂ ତଦନ୍ୟତ୍ କିମପି ଭିତ୍ତିମୂଲଂ ସ୍ଥାପଯିତୁଂ କେନାପି ନ ଶକ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","ଏତଦ୍ଭିତ୍ତିମୂଲସ୍ୟୋପରି ଯଦି କେଚିତ୍ ସ୍ୱର୍ଣରୂପ୍ୟମଣିକାଷ୍ଠତୃଣନଲାନ୍ ନିଚିନ୍ୱନ୍ତି, ");
INSERT INTO sanori_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","ତର୍ହ୍ୟେକୈକସ୍ୟ କର୍ମ୍ମ ପ୍ରକାଶିଷ୍ୟତେ ଯତଃ ସ ଦିୱସସ୍ତତ୍ ପ୍ରକାଶଯିଷ୍ୟତି| ଯତୋ ହତୋସ୍ତନ ଦିୱସେନ ୱହ୍ନିମଯେନୋଦେତୱ୍ୟଂ ତତ ଏକୈକସ୍ୟ କର୍ମ୍ମ କୀଦୃଶମେତସ୍ୟ ପରୀକ୍ଷା ବହ୍ନିନା ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","ଯସ୍ୟ ନିଚଯନରୂପଂ କର୍ମ୍ମ ସ୍ଥାସ୍ନୁ ଭୱିଷ୍ୟତି ସ ୱେତନଂ ଲପ୍ସ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","ଯସ୍ୟ ଚ କର୍ମ୍ମ ଧକ୍ଷ୍ୟତେ ତସ୍ୟ କ୍ଷତି ର୍ଭୱିଷ୍ୟତି କିନ୍ତୁ ୱହ୍ନେ ର୍ନିର୍ଗତଜନ ଇୱ ସ ସ୍ୱଯଂ ପରିତ୍ରାଣଂ ପ୍ରାପ୍ସ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","ଯୂଯମ୍ ଈଶ୍ୱରସ୍ୟ ମନ୍ଦିରଂ ଯୁଷ୍ମନ୍ମଧ୍ୟେ ଚେଶ୍ୱରସ୍ୟାତ୍ମା ନିୱସତୀତି କିଂ ନ ଜାନୀଥ? ");
INSERT INTO sanori_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","ଈଶ୍ୱରସ୍ୟ ମନ୍ଦିରଂ ଯେନ ୱିନାଶ୍ୟତେ ସୋଽପୀଶ୍ୱରେଣ ୱିନାଶଯିଷ୍ୟତେ ଯତ ଈଶ୍ୱରସ୍ୟ ମନ୍ଦିରଂ ପୱିତ୍ରମେୱ ଯୂଯଂ ତୁ ତନ୍ମନ୍ଦିରମ୍ ଆଧ୍ୱେ| ");
INSERT INTO sanori_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","କୋପି ସ୍ୱଂ ନ ୱଞ୍ଚଯତାଂ| ଯୁଷ୍ମାକଂ କଶ୍ଚନ ଚେଦିହଲୋକସ୍ୟ ଜ୍ଞାନେନ ଜ୍ଞାନୱାନହମିତି ବୁଧ୍ୟତେ ତର୍ହି ସ ଯତ୍ ଜ୍ଞାନୀ ଭୱେତ୍ ତଦର୍ଥଂ ମୂଢୋ ଭୱତୁ| ");
INSERT INTO sanori_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","ଯସ୍ମାଦିହଲୋକସ୍ୟ ଜ୍ଞାନମ୍ ଈଶ୍ୱରସ୍ୟ ସାକ୍ଷାତ୍ ମୂଢତ୍ୱମେୱ| ଏତସ୍ମିନ୍ ଲିଖିତମପ୍ୟାସ୍ତେ, ତୀକ୍ଷ୍ଣା ଯା ଜ୍ଞାନିନାଂ ବୁଦ୍ଧିସ୍ତଯା ତାନ୍ ଧରତୀଶ୍ୱରଃ| ");
INSERT INTO sanori_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","ପୁନଶ୍ଚ| ଜ୍ଞାନିନାଂ କଲ୍ପନା ୱେତ୍ତି ପରମେଶୋ ନିରର୍ଥକାଃ| ");
INSERT INTO sanori_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","ଅତଏୱ କୋଽପି ମନୁଜୈରାତ୍ମାନଂ ନ ଶ୍ଲାଘତାଂ ଯତଃ ସର୍ୱ୍ୱାଣି ଯୁଷ୍ମାକମେୱ, ");
INSERT INTO sanori_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","ପୌଲ ୱା ଆପଲ୍ଲୋ ର୍ୱା କୈଫା ୱା ଜଗଦ୍ ୱା ଜୀୱନଂ ୱା ମରଣଂ ୱା ୱର୍ତ୍ତମାନଂ ୱା ଭୱିଷ୍ୟଦ୍ୱା ସର୍ୱ୍ୱାଣ୍ୟେୱ ଯୁଷ୍ମାକଂ, ");
INSERT INTO sanori_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","ଯୂଯଞ୍ଚ ଖ୍ରୀଷ୍ଟସ୍ୟ, ଖ୍ରୀଷ୍ଟଶ୍ଚେଶ୍ୱରସ୍ୟ| ");
INSERT INTO sanori_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","ଲୋକା ଅସ୍ମାନ୍ ଖ୍ରୀଷ୍ଟସ୍ୟ ପରିଚାରକାନ୍ ଈଶ୍ୱରସ୍ୟ ନିଗୂଠୱାକ୍ୟଧନସ୍ୟାଧ୍ୟକ୍ଷାଂଶ୍ଚ ମନ୍ୟନ୍ତାଂ| ");
INSERT INTO sanori_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","କିଞ୍ଚ ଧନାଧ୍ୟକ୍ଷେଣ ୱିଶ୍ୱସନୀଯେନ ଭୱିତୱ୍ୟମେତଦେୱ ଲୋକୈ ର୍ୟାଚ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","ଅତୋ ୱିଚାରଯଦ୍ଭି ର୍ୟୁଷ୍ମାଭିରନ୍ୟୈଃ କୈଶ୍ଚିନ୍ ମନୁଜୈ ର୍ୱା ମମ ପରୀକ୍ଷଣଂ ମଯାତୀୱ ଲଘୁ ମନ୍ୟତେ ଽହମପ୍ୟାତ୍ମାନଂ ନ ୱିଚାରଯାମି| ");
INSERT INTO sanori_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","ମଯା କିମପ୍ୟପରାଦ୍ଧମିତ୍ୟହଂ ନ ୱେଦ୍ମି କିନ୍ତ୍ୱେତେନ ମମ ନିରପରାଧତ୍ୱଂ ନ ନିଶ୍ଚୀଯତେ ପ୍ରଭୁରେୱ ମମ ୱିଚାରଯିତାସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","ଅତ ଉପଯୁକ୍ତସମଯାତ୍ ପୂର୍ୱ୍ୱମ୍ ଅର୍ଥତଃ ପ୍ରଭୋରାଗମନାତ୍ ପୂର୍ୱ୍ୱଂ ଯୁଷ୍ମାଭି ର୍ୱିଚାରୋ ନ କ୍ରିଯତାଂ| ପ୍ରଭୁରାଗତ୍ୟ ତିମିରେଣ ପ୍ରଚ୍ଛନ୍ନାନି ସର୍ୱ୍ୱାଣି ଦୀପଯିଷ୍ୟତି ମନସାଂ ମନ୍ତ୍ରଣାଶ୍ଚ ପ୍ରକାଶଯିଷ୍ୟତି ତସ୍ମିନ୍ ସମଯ ଈଶ୍ୱରାଦ୍ ଏକୈକସ୍ୟ ପ୍ରଶଂସା ଭୱିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","ହେ ଭ୍ରାତରଃ ସର୍ୱ୍ୱାଣ୍ୟେତାନି ମଯାତ୍ମାନମ୍ ଆପଲ୍ଲୱଞ୍ଚୋଦ୍ଦିଶ୍ୟ କଥିତାନି ତସ୍ୟୈତତ୍ କାରଣଂ ଯୁଯଂ ଯଥା ଶାସ୍ତ୍ରୀଯୱିଧିମତିକ୍ରମ୍ୟ ମାନୱମ୍ ଅତୀୱ ନାଦରିଷ୍ୟଧ୍ବ ଈତ୍ଥଞ୍ଚୈକେନ ୱୈପରୀତ୍ୟାଦ୍ ଅପରେଣ ନ ଶ୍ଲାଘିଷ୍ୟଧ୍ବ ଏତାଦୃଶୀଂ ଶିକ୍ଷାମାୱଯୋର୍ଦୃଷ୍ଟାନ୍ତାତ୍ ଲପ୍ସ୍ୟଧ୍ୱେ| ");
INSERT INTO sanori_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","ଅପରାତ୍ କସ୍ତ୍ୱାଂ ୱିଶେଷଯତି? ତୁଭ୍ୟଂ ଯନ୍ନ ଦତ୍ତ ତାଦୃଶଂ କିଂ ଧାରଯସି? ଅଦତ୍ତେନେୱ ଦତ୍ତେନ ୱସ୍ତୁନା କୁତଃ ଶ୍ଲାଘସେ? ");
INSERT INTO sanori_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","ଇଦାନୀମେୱ ଯୂଯଂ କିଂ ତୃପ୍ତା ଲବ୍ଧଧନା ୱା? ଅସ୍ମାସ୍ୱୱିଦ୍ୟମାନେଷୁ ଯୂଯଂ କିଂ ରାଜତ୍ୱପଦଂ ପ୍ରାପ୍ତାଃ? ଯୁଷ୍ମାକଂ ରାଜତ୍ୱଂ ମଯାଭିଲଷିତଂ ଯତସ୍ତେନ ଯୁଷ୍ମାଭିଃ ସହ ୱଯମପି ରାଜ୍ୟାଂଶିନୋ ଭୱିଷ୍ୟାମଃ| ");
INSERT INTO sanori_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","ପ୍ରେରିତା ୱଯଂ ଶେଷା ହନ୍ତୱ୍ୟାଶ୍ଚେୱେଶ୍ୱରେଣ ନିଦର୍ଶିତାଃ| ଯତୋ ୱଯଂ ସର୍ୱ୍ୱଲୋକାନାମ୍ ଅର୍ଥତଃ ସ୍ୱର୍ଗୀଯଦୂତାନାଂ ମାନୱାନାଞ୍ଚ କୌତୁକାସ୍ପଦାନି ଜାତାଃ| ");
INSERT INTO sanori_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","ଖ୍ରୀଷ୍ଟସ୍ୟ କୃତେ ୱଯଂ ମୂଢାଃ କିନ୍ତୁ ଯୂଯଂ ଖ୍ରୀଷ୍ଟେନ ଜ୍ଞାନିନଃ, ୱଯଂ ଦୁର୍ବ୍ବଲା ଯୂଯଞ୍ଚ ସବଲାଃ, ଯୂଯଂ ସମ୍ମାନିତା ୱଯଞ୍ଚାପମାନିତାଃ| ");
INSERT INTO sanori_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","ୱଯମଦ୍ୟାପି କ୍ଷୁଧାର୍ତ୍ତାସ୍ତୃଷ୍ଣାର୍ତ୍ତା ୱସ୍ତ୍ରହୀନାସ୍ତାଡିତା ଆଶ୍ରମରହିତାଶ୍ଚ ସନ୍ତଃ ");
INSERT INTO sanori_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","କର୍ମ୍ମଣି ସ୍ୱକରାନ୍ ୱ୍ୟାପାରଯନ୍ତଶ୍ଚ ଦୁଃଖୈଃ କାଲଂ ଯାପଯାମଃ| ଗର୍ହିତୈରସ୍ମାଭିରାଶୀଃ କଥ୍ୟତେ ଦୂରୀକୃତୈଃ ସହ୍ୟତେ ନିନ୍ଦିତୈଃ ପ୍ରସାଦ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","ୱଯମଦ୍ୟାପି ଜଗତଃ ସମ୍ମାର୍ଜନୀଯୋଗ୍ୟା ଅୱକରା ଇୱ ସର୍ୱ୍ୱୈ ର୍ମନ୍ୟାମହେ| ");
INSERT INTO sanori_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","ଯୁଷ୍ମାନ୍ ତ୍ରପଯିତୁମହମେତାନି ଲିଖାମୀତି ନହି କିନ୍ତୁ ପ୍ରିଯାତ୍ମଜାନିୱ ଯୁଷ୍ମାନ୍ ପ୍ରବୋଧଯାମି| ");
INSERT INTO sanori_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","ଯତଃ ଖ୍ରୀଷ୍ଟଧର୍ମ୍ମେ ଯଦ୍ୟପି ଯୁଷ୍ମାକଂ ଦଶସହସ୍ରାଣି ୱିନେତାରୋ ଭୱନ୍ତି ତଥାପି ବହୱୋ ଜନକା ନ ଭୱନ୍ତି ଯତୋଽହମେୱ ସୁସଂୱାଦେନ ଯୀଶୁଖ୍ରୀଷ୍ଟେ ଯୁଷ୍ମାନ୍ ଅଜନଯଂ| ");
INSERT INTO sanori_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","ଅତୋ ଯୁଷ୍ମାନ୍ ୱିନଯେଽହଂ ଯୂଯଂ ମଦନୁଗାମିନୋ ଭୱତ| ");
INSERT INTO sanori_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","ଇତ୍ୟର୍ଥଂ ସର୍ୱ୍ୱେଷୁ ଧର୍ମ୍ମସମାଜେଷୁ ସର୍ୱ୍ୱତ୍ର ଖ୍ରୀଷ୍ଟଧର୍ମ୍ମଯୋଗ୍ୟା ଯେ ୱିଧଯୋ ମଯୋପଦିଶ୍ୟନ୍ତେ ତାନ୍ ଯୋ ଯୁଷ୍ମାନ୍ ସ୍ମାରଯିଷ୍ୟତ୍ୟେୱମ୍ଭୂତଂ ପ୍ରଭୋଃ କୃତେ ପ୍ରିଯଂ ୱିଶ୍ୱାସିନଞ୍ଚ ମଦୀଯତନଯଂ ତୀମଥିଯଂ ଯୁଷ୍ମାକଂ ସମୀପଂ ପ୍ରେଷିତୱାନହଂ| ");
INSERT INTO sanori_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","ଅପରମହଂ ଯୁଷ୍ମାକଂ ସମୀପଂ ନ ଗମିଷ୍ୟାମୀତି ବୁଦ୍ଧ୍ୱା ଯୁଷ୍ମାକଂ କିଯନ୍ତୋ ଲୋକା ଗର୍ୱ୍ୱନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","କିନ୍ତୁ ଯଦି ପ୍ରଭେରିଚ୍ଛା ଭୱତି ତର୍ହ୍ୟହମୱିଲମ୍ବଂ ଯୁଷ୍ମତ୍ସମୀପମୁପସ୍ଥାଯ ତେଷାଂ ଦର୍ପଧ୍ମାତାନାଂ ଲୋକାନାଂ ୱାଚଂ ଜ୍ଞାସ୍ୟାମୀତି ନହି ସାମର୍ଥ୍ୟମେୱ ଜ୍ଞାସ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","ଯସ୍ମାଦୀଶ୍ୱରସ୍ୟ ରାଜତ୍ୱଂ ୱାଗ୍ୟୁକ୍ତଂ ନହି କିନ୍ତୁ ସାମର୍ଥ୍ୟଯୁକ୍ତଂ| ");
INSERT INTO sanori_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","ଯୁଷ୍ମାକଂ କା ୱାଞ୍ଛା? ଯୁଷ୍ମତ୍ସମୀପେ ମଯା କିଂ ଦଣ୍ଡପାଣିନା ଗନ୍ତୱ୍ୟମୁତ ପ୍ରେମନମ୍ରତାତ୍ମଯୁକ୍ତେନ ୱା? ");
INSERT INTO sanori_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","ଅପରଂ ଯୁଷ୍ମାକଂ ମଧ୍ୟେ ୱ୍ୟଭିଚାରୋ ୱିଦ୍ୟତେ ସ ଚ ୱ୍ୟଭିଚାରସ୍ତାଦୃଶୋ ଯଦ୍ ଦେୱପୂଜକାନାଂ ମଧ୍ୟେଽପି ତତ୍ତୁଲ୍ୟୋ ନ ୱିଦ୍ୟତେ ଫଲତୋ ଯୁଷ୍ମାକମେକୋ ଜନୋ ୱିମାତୃଗମନଂ କୃରୁତ ଇତି ୱାର୍ତ୍ତା ସର୍ୱ୍ୱତ୍ର ୱ୍ୟାପ୍ତା| ");
INSERT INTO sanori_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","ତଥାଚ ଯୂଯଂ ଦର୍ପଧ୍ମାତା ଆଧ୍ବେ, ତତ୍ କର୍ମ୍ମ ଯେନ କୃତଂ ସ ଯଥା ଯୁଷ୍ମନ୍ମଧ୍ୟାଦ୍ ଦୂରୀକ୍ରିଯତେ ତଥା ଶୋକୋ ଯୁଷ୍ମାଭି ର୍ନ କ୍ରିଯତେ କିମ୍ ଏତତ୍? ");
INSERT INTO sanori_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","ଅୱିଦ୍ୟମାନେ ମଦୀଯଶରୀରେ ମମାତ୍ମା ଯୁଷ୍ମନ୍ମଧ୍ୟେ ୱିଦ୍ୟତେ ଅତୋଽହଂ ୱିଦ୍ୟମାନ ଇୱ ତତ୍କର୍ମ୍ମକାରିଣୋ ୱିଚାରଂ ନିଶ୍ଚିତୱାନ୍, ");
INSERT INTO sanori_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","ଅସ୍ମତ୍ପ୍ରଭୋ ର୍ୟୀଶୁଖ୍ରୀଷ୍ଟସ୍ୟ ନାମ୍ନା ଯୁଷ୍ମାକଂ ମଦୀଯାତ୍ମନଶ୍ଚ ମିଲନେ ଜାତେ ଽସ୍ମତ୍ପ୍ରଭୋ ର୍ୟୀଶୁଖ୍ରୀଷ୍ଟସ୍ୟ ଶକ୍ତେଃ ସାହାଯ୍ୟେନ ");
INSERT INTO sanori_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","ସ ନରଃ ଶରୀରନାଶାର୍ଥମସ୍ମାଭିଃ ଶଯତାନୋ ହସ୍ତେ ସମର୍ପଯିତୱ୍ୟସ୍ତତୋଽସ୍ମାକଂ ପ୍ରଭୋ ର୍ୟୀଶୋ ର୍ଦିୱସେ ତସ୍ୟାତ୍ମା ରକ୍ଷାଂ ଗନ୍ତୁଂ ଶକ୍ଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","ଯୁଷ୍ମାକଂ ଦର୍ପୋ ନ ଭଦ୍ରାଯ ଯୂଯଂ କିମେତନ୍ନ ଜାନୀଥ, ଯଥା, ୱିକାରଃ କୃତ୍ସ୍ନଶକ୍ତୂନାଂ ସ୍ୱଲ୍ପକିଣ୍ୱେନ ଜାଯତେ| ");
INSERT INTO sanori_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","ଯୂଯଂ ଯତ୍ ନୱୀନଶକ୍ତୁସ୍ୱରୂପା ଭୱେତ ତଦର୍ଥଂ ପୁରାତନଂ କିଣ୍ୱମ୍ ଅୱମାର୍ଜ୍ଜତ ଯତୋ ଯୁଷ୍ମାଭିଃ କିଣ୍ୱଶୂନ୍ୟୈ ର୍ଭୱିତୱ୍ୟଂ| ଅପରମ୍ ଅସ୍ମାକଂ ନିସ୍ତାରୋତ୍ସୱୀଯମେଷଶାୱକୋ ଯଃ ଖ୍ରୀଷ୍ଟଃ ସୋଽସ୍ମଦର୍ଥଂ ବଲୀକୃତୋ ଽଭୱତ୍| ");
INSERT INTO sanori_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","ଅତଃ ପୁରାତନକିଣ୍ୱେନାର୍ଥତୋ ଦୁଷ୍ଟତାଜିଘାଂସାରୂପେଣ କିଣ୍ୱେନ ତନ୍ନହି କିନ୍ତୁ ସାରଲ୍ୟସତ୍ୟତ୍ୱରୂପଯା କିଣ୍ୱଶୂନ୍ୟତଯାସ୍ମାଭିରୁତ୍ସୱଃ କର୍ତ୍ତୱ୍ୟଃ| ");
INSERT INTO sanori_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","ୱ୍ୟାଭିଚାରିଣାଂ ସଂସର୍ଗୋ ଯୁଷ୍ମାଭି ର୍ୱିହାତୱ୍ୟ ଇତି ମଯା ପତ୍ରେ ଲିଖିତଂ| ");
INSERT INTO sanori_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","କିନ୍ତ୍ୱୈହିକଲୋକାନାଂ ମଧ୍ୟେ ଯେ ୱ୍ୟଭିଚାରିଣୋ ଲୋଭିନ ଉପଦ୍ରାୱିଣୋ ଦେୱପୂଜକା ୱା ତେଷାଂ ସଂସର୍ଗଃ ସର୍ୱ୍ୱଥା ୱିହାତୱ୍ୟ ଇତି ନହି, ୱିହାତୱ୍ୟେ ସତି ଯୁଷ୍ମାଭି ର୍ଜଗତୋ ନିର୍ଗନ୍ତୱ୍ୟମେୱ| ");
INSERT INTO sanori_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","କିନ୍ତୁ ଭ୍ରାତୃତ୍ୱେନ ୱିଖ୍ୟାତଃ କଶ୍ଚିଜ୍ଜନୋ ଯଦି ୱ୍ୟଭିଚାରୀ ଲୋଭୀ ଦେୱପୂଜକୋ ନିନ୍ଦକୋ ମଦ୍ୟପ ଉପଦ୍ରାୱୀ ୱା ଭୱେତ୍ ତର୍ହି ତାଦୃଶେନ ମାନୱେନ ସହ ଭୋଜନପାନେଽପି ଯୁଷ୍ମାଭି ର୍ନ କର୍ତ୍ତୱ୍ୟେ ଇତ୍ୟଧୁନା ମଯା ଲିଖିତଂ| ");
INSERT INTO sanori_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","ସମାଜବହିଃସ୍ଥିତାନାଂ ଲୋକାନାଂ ୱିଚାରକରଣେ ମମ କୋଽଧିକାରଃ? କିନ୍ତୁ ତଦନ୍ତର୍ଗତାନାଂ ୱିଚାରଣଂ ଯୁଷ୍ମାଭିଃ କିଂ ନ କର୍ତ୍ତୱ୍ୟଂ ଭୱେତ୍? ");
INSERT INTO sanori_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","ବହିଃସ୍ଥାନାଂ ତୁ ୱିଚାର ଈଶ୍ୱରେଣ କାରିଷ୍ୟତେ| ଅତୋ ଯୁଷ୍ମାଭିଃ ସ ପାତକୀ ସ୍ୱମଧ୍ୟାଦ୍ ବହିଷ୍କ୍ରିଯତାଂ| ");
INSERT INTO sanori_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","ଯୁଷ୍ମାକମେକସ୍ୟ ଜନସ୍ୟାପରେଣ ସହ ୱିୱାଦେ ଜାତେ ସ ପୱିତ୍ରଲୋକୈ ର୍ୱିଚାରମକାରଯନ୍ କିମ୍ ଅଧାର୍ମ୍ମିକଲୋକୈ ର୍ୱିଚାରଯିତୁଂ ପ୍ରୋତ୍ସହତେ? ");
INSERT INTO sanori_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","ଜଗତୋଽପି ୱିଚାରଣଂ ପୱିତ୍ରଲୋକୈଃ କାରିଷ୍ୟତ ଏତଦ୍ ଯୂଯଂ କିଂ ନ ଜାନୀଥ? ଅତୋ ଜଗଦ୍ ଯଦି ଯୁଷ୍ମାଭି ର୍ୱିଚାରଯିତୱ୍ୟଂ ତର୍ହି କ୍ଷୁଦ୍ରତମୱିଚାରେଷୁ ଯୂଯଂ କିମସମର୍ଥାଃ? ");
INSERT INTO sanori_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","ଦୂତା ଅପ୍ୟସ୍ମାଭି ର୍ୱିଚାରଯିଷ୍ୟନ୍ତ ଇତି କିଂ ନ ଜାନୀଥ? ଅତ ଐହିକୱିଷଯାଃ କିମ୍ ଅସ୍ମାଭି ର୍ନ ୱିଚାରଯିତୱ୍ୟା ଭୱେଯୁଃ? ");
INSERT INTO sanori_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","ଐହିକୱିଷଯସ୍ୟ ୱିଚାରେ ଯୁଷ୍ମାଭିଃ କର୍ତ୍ତୱ୍ୟେ ଯେ ଲୋକାଃ ସମିତୌ କ୍ଷୁଦ୍ରତମାସ୍ତ ଏୱ ନିଯୁଜ୍ୟନ୍ତାଂ| ");
INSERT INTO sanori_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","ଅହଂ ଯୁଷ୍ମାନ୍ ତ୍ରପଯିତୁମିଚ୍ଛନ୍ ୱଦାମି ଯୃଷ୍ମନ୍ମଧ୍ୟେ କିମେକୋଽପି ମନୁଷ୍ୟସ୍ତାଦୃଗ୍ ବୁଦ୍ଧିମାନ୍ନହି ଯୋ ଭ୍ରାତୃୱିୱାଦୱିଚାରଣେ ସମର୍ଥଃ ସ୍ୟାତ୍? ");
INSERT INTO sanori_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","କିଞ୍ଚୈକୋ ଭ୍ରାତା ଭ୍ରାତ୍ରାନ୍ୟେନ କିମୱିଶ୍ୱାସିନାଂ ୱିଚାରକାଣାଂ ସାକ୍ଷାଦ୍ ୱିୱଦତେ? ଯଷ୍ମନ୍ମଧ୍ୟେ ୱିୱାଦା ୱିଦ୍ୟନ୍ତ ଏତଦପି ଯୁଷ୍ମାକଂ ଦୋଷଃ| ");
INSERT INTO sanori_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","ଯୂଯଂ କୁତୋଽନ୍ୟାଯସହନଂ କ୍ଷତିସହନଂ ୱା ଶ୍ରେଯୋ ନ ମନ୍ୟଧ୍ୱେ? ");
INSERT INTO sanori_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","କିନ୍ତୁ ଯୂଯମପି ଭ୍ରାତୃନେୱ ପ୍ରତ୍ୟନ୍ୟାଯଂ କ୍ଷତିଞ୍ଚ କୁରୁଥ କିମେତତ୍? ");
INSERT INTO sanori_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","ଈଶ୍ୱରସ୍ୟ ରାଜ୍ୟେଽନ୍ୟାଯକାରିଣାଂ ଲୋକାନାମଧିକାରୋ ନାସ୍ତ୍ୟେତଦ୍ ଯୂଯଂ କିଂ ନ ଜାନୀଥ? ମା ୱଞ୍ଚ୍ୟଧ୍ୱଂ, ଯେ ୱ୍ୟଭିଚାରିଣୋ ଦେୱାର୍ଚ୍ଚିନଃ ପାରଦାରିକାଃ ସ୍ତ୍ରୀୱଦାଚାରିଣଃ ପୁଂମୈଥୁନକାରିଣସ୍ତସ୍କରା ");
INSERT INTO sanori_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","ଲୋଭିନୋ ମଦ୍ୟପା ନିନ୍ଦକା ଉପଦ୍ରାୱିଣୋ ୱା ତ ଈଶ୍ୱରସ୍ୟ ରାଜ୍ୟଭାଗିନୋ ନ ଭୱିଷ୍ୟନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","ଯୂଯଞ୍ଚୈୱଂୱିଧା ଲୋକା ଆସ୍ତ କିନ୍ତୁ ପ୍ରଭୋ ର୍ୟୀଶୋ ର୍ନାମ୍ନାସ୍ମଦୀଶ୍ୱରସ୍ୟାତ୍ମନା ଚ ଯୂଯଂ ପ୍ରକ୍ଷାଲିତାଃ ପାୱିତାଃ ସପୁଣ୍ୟୀକୃତାଶ୍ଚ| ");
INSERT INTO sanori_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","ମଦର୍ଥଂ ସର୍ୱ୍ୱଂ ଦ୍ରୱ୍ୟମ୍ ଅପ୍ରତିଷିଦ୍ଧଂ କିନ୍ତୁ ନ ସର୍ୱ୍ୱଂ ହିତଜନକଂ| ମଦର୍ଥଂ ସର୍ୱ୍ୱମପ୍ରତିଷିଦ୍ଧଂ ତଥାପ୍ୟହଂ କସ୍ୟାପି ଦ୍ରୱ୍ୟସ୍ୟ ୱଶୀକୃତୋ ନ ଭୱିଷ୍ୟାମି| ");
INSERT INTO sanori_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","ଉଦରାଯ ଭକ୍ଷ୍ୟାଣି ଭକ୍ଷ୍ୟେଭ୍ୟଶ୍ଚୋଦରଂ, କିନ୍ତୁ ଭକ୍ଷ୍ୟୋଦରେ ଈଶ୍ୱରେଣ ନାଶଯିଷ୍ୟେତେ; ଅପରଂ ଦେହୋ ନ ୱ୍ୟଭିଚାରାଯ କିନ୍ତୁ ପ୍ରଭୱେ ପ୍ରଭୁଶ୍ଚ ଦେହାଯ| ");
INSERT INTO sanori_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","ଯଶ୍ଚେଶ୍ୱରଃ ପ୍ରଭୁମୁତ୍ଥାପିତୱାନ୍ ସ ସ୍ୱଶକ୍ତ୍ୟାସ୍ମାନପ୍ୟୁତ୍ଥାପଯିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","ଯୁଷ୍ମାକଂ ଯାନି ଶରୀରାଣି ତାନି ଖ୍ରୀଷ୍ଟସ୍ୟାଙ୍ଗାନୀତି କିଂ ଯୂଯଂ ନ ଜାନୀଥ? ଅତଃ ଖ୍ରୀଷ୍ଟସ୍ୟ ଯାନ୍ୟଙ୍ଗାନି ତାନି ମଯାପହୃତ୍ୟ ୱେଶ୍ୟାଯା ଅଙ୍ଗାନି କିଂ କାରିଷ୍ୟନ୍ତେ? ତନ୍ନ ଭୱତୁ| ");
INSERT INTO sanori_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","ଯଃ କଶ୍ଚିଦ୍ ୱେଶ୍ୟାଯାମ୍ ଆସଜ୍ୟତେ ସ ତଯା ସହୈକଦେହୋ ଭୱତି କିଂ ଯୂଯମେତନ୍ନ ଜାନୀଥ? ଯତୋ ଲିଖିତମାସ୍ତେ, ଯଥା, ତୌ ଦ୍ୱୌ ଜନାୱେକାଙ୍ଗୌ ଭୱିଷ୍ୟତଃ| ");
INSERT INTO sanori_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","ମାନୱା ଯାନ୍ୟନ୍ୟାନି କଲୁଷାଣି କୁର୍ୱ୍ୱତେ ତାନି ୱପୁ ର୍ନ ସମାୱିଶନ୍ତି କିନ୍ତୁ ୱ୍ୟଭିଚାରିଣା ସ୍ୱୱିଗ୍ରହସ୍ୟ ୱିରୁଦ୍ଧଂ କଲ୍ମଷଂ କ୍ରିଯତେ| ");
INSERT INTO sanori_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","ମାନୱା ଯାନ୍ୟନ୍ୟାନି କଲୁଷାଣି କୁର୍ୱ୍ୱତେ ତାନି ୱପୁ ର୍ନ ସମାୱିଶନ୍ତି କିନ୍ତୁ ୱ୍ୟଭିଚାରିଣା ସ୍ୱୱିଗ୍ରହସ୍ୟ ୱିରୁଦ୍ଧଂ କଲ୍ମଷଂ କ୍ରିଯତେ| ");
INSERT INTO sanori_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","ଯୁଷ୍ମାକଂ ଯାନି ୱପୂଂସି ତାନି ଯୁଷ୍ମଦନ୍ତଃସ୍ଥିତସ୍ୟେଶ୍ୱରାଲ୍ଲବ୍ଧସ୍ୟ ପୱିତ୍ରସ୍ୟାତ୍ମନୋ ମନ୍ଦିରାଣି ଯୂଯଞ୍ଚ ସ୍ୱେଷାଂ ସ୍ୱାମିନୋ ନାଧ୍ୱେ କିମେତଦ୍ ଯୁଷ୍ମାଭି ର୍ନ ଜ୍ଞାଯତେ? ");
INSERT INTO sanori_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","ଯୂଯଂ ମୂଲ୍ୟେନ କ୍ରୀତା ଅତୋ ୱପୁର୍ମନୋଭ୍ୟାମ୍ ଈଶ୍ୱରୋ ଯୁଷ୍ମାଭିଃ ପୂଜ୍ୟତାଂ ଯତ ଈଶ୍ୱର ଏୱ ତଯୋଃ ସ୍ୱାମୀ| ");
INSERT INTO sanori_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","ଅପରଞ୍ଚ ଯୁଷ୍ମାଭି ର୍ମାଂ ପ୍ରତି ଯତ୍ ପତ୍ରମଲେଖି ତସ୍ୟୋତ୍ତରମେତତ୍, ଯୋଷିତୋଽସ୍ପର୍ଶନଂ ମନୁଜସ୍ୟ ୱରଂ; ");
INSERT INTO sanori_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","କିନ୍ତୁ ୱ୍ୟଭିଚାରଭଯାଦ୍ ଏକୈକସ୍ୟ ପୁଂସଃ ସ୍ୱକୀଯଭାର୍ୟ୍ୟା ଭୱତୁ ତଦ୍ୱଦ୍ ଏକୈକସ୍ୟା ଯୋଷିତୋ ଽପି ସ୍ୱକୀଯଭର୍ତ୍ତା ଭୱତୁ| ");
INSERT INTO sanori_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","ଭାର୍ୟ୍ୟାଯୈ ଭର୍ତ୍ରା ଯଦ୍ୟଦ୍ ୱିତରଣୀଯଂ ତଦ୍ ୱିତୀର୍ୟ୍ୟତାଂ ତଦ୍ୱଦ୍ ଭର୍ତ୍ରେଽପି ଭାର୍ୟ୍ୟଯା ୱିତରଣୀଯଂ ୱିତୀର୍ୟ୍ୟତାଂ| ");
INSERT INTO sanori_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","ଭାର୍ୟ୍ୟାଯାଃ ସ୍ୱଦେହେ ସ୍ୱତ୍ୱଂ ନାସ୍ତି ଭର୍ତ୍ତୁରେୱ, ତଦ୍ୱଦ୍ ଭର୍ତ୍ତୁରପି ସ୍ୱଦେହେ ସ୍ୱତ୍ୱଂ ନାସ୍ତି ଭାର୍ୟ୍ୟାଯା ଏୱ| ");
INSERT INTO sanori_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","ଉପୋଷଣପ୍ରାର୍ଥନଯୋଃ ସେୱନାର୍ଥମ୍ ଏକମନ୍ତ୍ରଣାନାଂ ଯୁଷ୍ମାକଂ କିଯତ୍କାଲଂ ଯାୱଦ୍ ଯା ପୃଥକ୍ସ୍ଥିତି ର୍ଭୱତି ତଦନ୍ୟୋ ୱିଚ୍ଛେଦୋ ଯୁଷ୍ମନ୍ମଧ୍ୟେ ନ ଭୱତୁ, ତତଃ ପରମ୍ ଇନ୍ଦ୍ରିଯାଣାମ୍ ଅଧୈର୍ୟ୍ୟାତ୍ ଶଯତାନ୍ ଯଦ୍ ଯୁଷ୍ମାନ୍ ପରୀକ୍ଷାଂ ନ ନଯେତ୍ ତଦର୍ଥଂ ପୁନରେକତ୍ର ମିଲତ| ");
INSERT INTO sanori_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","ଏତଦ୍ ଆଦେଶତୋ ନହି କିନ୍ତ୍ୱନୁଜ୍ଞାତ ଏୱ ମଯା କଥ୍ୟତେ, ");
INSERT INTO sanori_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","ଯତୋ ମମାୱସ୍ଥେୱ ସର୍ୱ୍ୱମାନୱାନାମୱସ୍ଥା ଭୱତ୍ୱିତି ମମ ୱାଞ୍ଛା କିନ୍ତ୍ୱୀଶ୍ୱରାଦ୍ ଏକେନୈକୋ ୱରୋଽନ୍ୟେନ ଚାନ୍ୟୋ ୱର ଇତ୍ଥମେକୈକେନ ସ୍ୱକୀଯୱରୋ ଲବ୍ଧଃ| ");
INSERT INTO sanori_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","ଅପରମ୍ ଅକୃତୱିୱାହାନ୍ ୱିଧୱାଶ୍ଚ ପ୍ରତି ମମୈତନ୍ନିୱେଦନଂ ମମେୱ ତେଷାମୱସ୍ଥିତି ର୍ଭଦ୍ରା; ");
INSERT INTO sanori_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","କିଞ୍ଚ ଯଦି ତୈରିନ୍ଦ୍ରିଯାଣି ନିଯନ୍ତୁଂ ନ ଶକ୍ୟନ୍ତେ ତର୍ହି ୱିୱାହଃ କ୍ରିଯତାଂ ଯତଃ କାମଦହନାଦ୍ ୱ୍ୟୂଢତ୍ୱଂ ଭଦ୍ରଂ| ");
INSERT INTO sanori_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","ଯେ ଚ କୃତୱିୱାହାସ୍ତେ ମଯା ନହି ପ୍ରଭୁନୈୱୈତଦ୍ ଆଜ୍ଞାପ୍ୟନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","ଭାର୍ୟ୍ୟା ଭର୍ତ୍ତୃତଃ ପୃଥକ୍ ନ ଭୱତୁ| ଯଦି ୱା ପୃଥଗ୍ଭୂତା ସ୍ୟାତ୍ ତର୍ହି ନିର୍ୱିୱାହା ତିଷ୍ଠତୁ ସ୍ୱୀଯପତିନା ୱା ସନ୍ଦଧାତୁ ଭର୍ତ୍ତାପି ଭାର୍ୟ୍ୟାଂ ନ ତ୍ୟଜତୁ| ");
INSERT INTO sanori_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","ଇତରାନ୍ ଜନାନ୍ ପ୍ରତି ପ୍ରଭୁ ର୍ନ ବ୍ରୱୀତି କିନ୍ତ୍ୱହଂ ବ୍ରୱୀମି; କସ୍ୟଚିଦ୍ ଭ୍ରାତୁର୍ୟୋଷିଦ୍ ଅୱିଶ୍ୱାସିନୀ ସତ୍ୟପି ଯଦି ତେନ ସହୱାସେ ତୁଷ୍ୟତି ତର୍ହି ସା ତେନ ନ ତ୍ୟଜ୍ୟତାଂ| ");
INSERT INTO sanori_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","ତଦ୍ୱତ୍ କସ୍ୟାଶ୍ଚିଦ୍ ଯୋଷିତଃ ପତିରୱିଶ୍ୱାସୀ ସନ୍ନପି ଯଦି ତଯା ସହୱାସେ ତୁଷ୍ୟତି ତର୍ହି ସ ତଯା ନ ତ୍ୟଜ୍ୟତାଂ| ");
INSERT INTO sanori_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","ଯତୋଽୱିଶ୍ୱାସୀ ଭର୍ତ୍ତା ଭାର୍ୟ୍ୟଯା ପୱିତ୍ରୀଭୂତଃ, ତଦ୍ୱଦୱିଶ୍ୱାସିନୀ ଭାର୍ୟ୍ୟା ଭର୍ତ୍ରା ପୱିତ୍ରୀଭୂତା; ନୋଚେଦ୍ ଯୁଷ୍ମାକମପତ୍ୟାନ୍ୟଶୁଚୀନ୍ୟଭୱିଷ୍ୟନ୍ କିନ୍ତ୍ୱଧୁନା ତାନି ପୱିତ୍ରାଣି ସନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","ଅୱିଶ୍ୱାସୀ ଜନୋ ଯଦି ୱା ପୃଥଗ୍ ଭୱତି ତର୍ହି ପୃଥଗ୍ ଭୱତୁ; ଏତେନ ଭ୍ରାତା ଭଗିନୀ ୱା ନ ନିବଧ୍ୟତେ ତଥାପି ୱଯମୀଶ୍ୱରେଣ ଶାନ୍ତଯେ ସମାହୂତାଃ| ");
INSERT INTO sanori_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","ହେ ନାରି ତୱ ଭର୍ତ୍ତୁଃ ପରିତ୍ରାଣଂ ତ୍ୱତ୍ତୋ ଭୱିଷ୍ୟତି ନ ୱେତି ତ୍ୱଯା କିଂ ଜ୍ଞାଯତେ? ହେ ନର ତୱ ଜାଯାଯାଃ ପରିତ୍ରାଣଂ ତ୍ୱତ୍ତେा ଭୱିଷ୍ୟତି ନ ୱେତି ତ୍ୱଯା କିଂ ଜ୍ଞାଯତେ? ");
INSERT INTO sanori_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","ଏକୈକୋ ଜନଃ ପରମେଶ୍ୱରାଲ୍ଲବ୍ଧଂ ଯଦ୍ ଭଜତେ ଯସ୍ୟାଞ୍ଚାୱସ୍ଥାଯାମ୍ ଈଶ୍ୱରେଣାହ୍ୱାଯି ତଦନୁସାରେଣୈୱାଚରତୁ ତଦହଂ ସର୍ୱ୍ୱସମାଜସ୍ଥାନ୍ ଆଦିଶାମି| ");
INSERT INTO sanori_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","ଛିନ୍ନତ୍ୱଗ୍ ଭୃତ୍ୱା ଯ ଆହୂତଃ ସ ପ୍ରକୃଷ୍ଟତ୍ୱକ୍ ନ ଭୱତୁ, ତଦ୍ୱଦ୍ ଅଛିନ୍ନତ୍ୱଗ୍ ଭୂତ୍ୱା ଯ ଆହୂତଃ ସ ଛିନ୍ନତ୍ୱକ୍ ନ ଭୱତୁ| ");
INSERT INTO sanori_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","ତ୍ୱକ୍ଛେଦଃ ସାରୋ ନହି ତଦ୍ୱଦତ୍ୱକ୍ଛେଦୋଽପି ସାରୋ ନହି କିନ୍ତ୍ୱୀଶ୍ୱରସ୍ୟାଜ୍ଞାନାଂ ପାଲନମେୱ| ");
INSERT INTO sanori_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","ଯୋ ଜନୋ ଯସ୍ୟାମୱସ୍ଥାଯାମାହ୍ୱାଯି ସ ତସ୍ୟାମେୱାୱତିଷ୍ଠତାଂ| ");
INSERT INTO sanori_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","ଦାସଃ ସନ୍ ତ୍ୱଂ କିମାହୂତୋଽସି? ତନ୍ମା ଚିନ୍ତଯ, ତଥାଚ ଯଦି ସ୍ୱତନ୍ତ୍ରୋ ଭୱିତୁଂ ଶକ୍ନୁଯାସ୍ତର୍ହି ତଦେୱ ୱୃଣୁ| ");
INSERT INTO sanori_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","ଯତଃ ପ୍ରଭୁନାହୂତୋ ଯୋ ଦାସଃ ସ ପ୍ରଭୋ ର୍ମୋଚିତଜନଃ| ତଦ୍ୱଦ୍ ତେନାହୂତଃ ସ୍ୱତନ୍ତ୍ରୋ ଜନୋଽପି ଖ୍ରୀଷ୍ଟସ୍ୟ ଦାସ ଏୱ| ");
INSERT INTO sanori_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","ଯୂଯଂ ମୂଲ୍ୟେନ କ୍ରୀତା ଅତୋ ହେତୋ ର୍ମାନୱାନାଂ ଦାସା ମା ଭୱତ| ");
INSERT INTO sanori_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","ହେ ଭ୍ରାତରୋ ଯସ୍ୟାମୱସ୍ଥାଯାଂ ଯସ୍ୟାହ୍ୱାନମଭୱତ୍ ତଯା ସ ଈଶ୍ୱରସ୍ୟ ସାକ୍ଷାତ୍ ତିଷ୍ଠତୁ| ");
INSERT INTO sanori_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","ଅପରମ୍ ଅକୃତୱିୱାହାନ୍ ଜନାନ୍ ପ୍ରତି ପ୍ରଭୋଃ କୋଽପ୍ୟାଦେଶୋ ମଯା ନ ଲବ୍ଧଃ କିନ୍ତୁ ପ୍ରଭୋରନୁକମ୍ପଯା ୱିଶ୍ୱାସ୍ୟୋ ଭୂତୋଽହଂ ଯଦ୍ ଭଦ୍ରଂ ମନ୍ୟେ ତଦ୍ ୱଦାମି| ");
INSERT INTO sanori_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","ୱର୍ତ୍ତମାନାତ୍ କ୍ଲେଶସମଯାତ୍ ମନୁଷ୍ୟସ୍ୟାନୂଢତ୍ୱଂ ଭଦ୍ରମିତି ମଯା ବୁଧ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","ତ୍ୱଂ କିଂ ଯୋଷିତି ନିବଦ୍ଧୋଽସି ତର୍ହି ମୋଚନଂ ପ୍ରାପ୍ତୁଂ ମା ଯତସ୍ୱ| କିଂ ୱା ଯୋଷିତୋ ମୁକ୍ତୋଽସି? ତର୍ହି ଜାଯାଂ ମା ଗୱେଷଯ| ");
INSERT INTO sanori_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","ୱିୱାହଂ କୁର୍ୱ୍ୱତା ତ୍ୱଯା କିମପି ନାପାରାଧ୍ୟତେ ତଦ୍ୱଦ୍ ୱ୍ୟୂହ୍ୟମାନଯା ଯୁୱତ୍ୟାପି କିମପି ନାପରାଧ୍ୟତେ ତଥାଚ ତାଦୃଶୌ ଦ୍ୱୌ ଜନୌ ଶାରୀରିକଂ କ୍ଲେଶଂ ଲପ୍ସ୍ୟେତେ କିନ୍ତୁ ଯୁଷ୍ମାନ୍ ପ୍ରତି ମମ କରୁଣା ୱିଦ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","ହେ ଭ୍ରାତରୋଽହମିଦଂ ବ୍ରୱୀମି, ଇତଃ ପରଂ ସମଯୋଽତୀୱ ସଂକ୍ଷିପ୍ତଃ, ");
INSERT INTO sanori_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","ଅତଃ କୃତଦାରୈରକୃତଦାରୈରିୱ ରୁଦଦ୍ଭିଶ୍ଚାରୁଦଦ୍ଭିରିୱ ସାନନ୍ଦୈଶ୍ଚ ନିରାନନ୍ଦୈରିୱ କ୍ରେତୃଭିଶ୍ଚାଭାଗିଭିରିୱାଚରିତୱ୍ୟଂ ");
INSERT INTO sanori_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","ଯେ ଚ ସଂସାରେ ଚରନ୍ତି ତୈ ର୍ନାତିଚରିତୱ୍ୟଂ ଯତ ଇହଲେाକସ୍ୟ କୌତୁକୋ ୱିଚଲତି| ");
INSERT INTO sanori_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","କିନ୍ତୁ ଯୂଯଂ ଯନ୍ନିଶ୍ଚିନ୍ତା ଭୱେତେତି ମମ ୱାଞ୍ଛା| ଅକୃତୱିୱାହୋ ଜନୋ ଯଥା ପ୍ରଭୁଂ ପରିତୋଷଯେତ୍ ତଥା ପ୍ରଭୁଂ ଚିନ୍ତଯତି, ");
INSERT INTO sanori_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","କିନ୍ତୁ କୃତୱିୱାହୋ ଜନୋ ଯଥା ଭାର୍ୟ୍ୟାଂ ପରିତୋଷଯେତ୍ ତଥା ସଂସାରଂ ଚିନ୍ତଯତି| ");
INSERT INTO sanori_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","ତଦ୍ୱଦ୍ ଊଢଯୋଷିତୋ ଽନୂଢା ୱିଶିଷ୍ୟତେ| ଯାନୂଢା ସା ଯଥା କାଯମନସୋଃ ପୱିତ୍ରା ଭୱେତ୍ ତଥା ପ୍ରଭୁଂ ଚିନ୍ତଯତି ଯା ଚୋଢା ସା ଯଥା ଭର୍ତ୍ତାରଂ ପରିତୋଷଯେତ୍ ତଥା ସଂସାରଂ ଚିନ୍ତଯତି| ");
INSERT INTO sanori_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","ଅହଂ ଯଦ୍ ଯୁଷ୍ମାନ୍ ମୃଗବନ୍ଧିନ୍ୟା ପରିକ୍ଷିପେଯଂ ତଦର୍ଥଂ ନହି କିନ୍ତୁ ଯୂଯଂ ଯଦନିନ୍ଦିତା ଭୂତ୍ୱା ପ୍ରଭୋଃ ସେୱନେଽବାଧମ୍ ଆସକ୍ତା ଭୱେତ ତଦର୍ଥମେତାନି ସର୍ୱ୍ୱାଣି ଯୁଷ୍ମାକଂ ହିତାଯ ମଯା କଥ୍ୟନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","କସ୍ୟଚିତ୍ କନ୍ୟାଯାଂ ଯୌୱନପ୍ରାପ୍ତାଯାଂ ଯଦି ସ ତସ୍ୟା ଅନୂଢତ୍ୱଂ ନିନ୍ଦନୀଯଂ ୱିୱାହଶ୍ଚ ସାଧଯିତୱ୍ୟ ଇତି ମନ୍ୟତେ ତର୍ହି ଯଥାଭିଲାଷଂ କରୋତୁ, ଏତେନ କିମପି ନାପରାତ୍ସ୍ୟତି ୱିୱାହଃ କ୍ରିଯତାଂ| ");
INSERT INTO sanori_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","କିନ୍ତୁ ଦୁଃଖେନାକ୍ଲିଷ୍ଟଃ କଶ୍ଚିତ୍ ପିତା ଯଦି ସ୍ଥିରମନୋଗତଃ ସ୍ୱମନୋଽଭିଲାଷସାଧନେ ସମର୍ଥଶ୍ଚ ସ୍ୟାତ୍ ମମ କନ୍ୟା ମଯା ରକ୍ଷିତୱ୍ୟେତି ମନସି ନିଶ୍ଚିନୋତି ଚ ତର୍ହି ସ ଭଦ୍ରଂ କର୍ମ୍ମ କରୋତି| ");
INSERT INTO sanori_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","ଅତୋ ଯୋ ୱିୱାହଂ କରୋତି ସ ଭଦ୍ରଂ କର୍ମ୍ମ କରୋତି ଯଶ୍ଚ ୱିୱାହଂ ନ କରୋତି ସ ଭଦ୍ରତରଂ କର୍ମ୍ମ କରୋତି| ");
INSERT INTO sanori_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","ଯାୱତ୍କାଲଂ ପତି ର୍ଜୀୱତି ତାୱଦ୍ ଭାର୍ୟ୍ୟା ୱ୍ୟୱସ୍ଥଯା ନିବଦ୍ଧା ତିଷ୍ଠତି କିନ୍ତୁ ପତ୍ୟୌ ମହାନିଦ୍ରାଂ ଗତେ ସା ମୁକ୍ତୀଭୂଯ ଯମଭିଲଷତି ତେନ ସହ ତସ୍ୟା ୱିୱାହୋ ଭୱିତୁଂ ଶକ୍ନୋତି, କିନ୍ତ୍ୱେତତ୍ କେୱଲଂ ପ୍ରଭୁଭକ୍ତାନାଂ ମଧ୍ୟେ| ");
INSERT INTO sanori_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","ତଥାଚ ସା ଯଦି ନିଷ୍ପତିକା ତିଷ୍ଠତି ତର୍ହି ତସ୍ୟାଃ କ୍ଷେମଂ ଭୱିଷ୍ୟତୀତି ମମ ଭାୱଃ| ଅପରମ୍ ଈଶ୍ୱରସ୍ୟାତ୍ମା ମମାପ୍ୟନ୍ତ ର୍ୱିଦ୍ୟତ ଇତି ମଯା ବୁଧ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","ଦେୱପ୍ରସାଦେ ସର୍ୱ୍ୱେଷାମ୍ ଅସ୍ମାକଂ ଜ୍ଞାନମାସ୍ତେ ତଦ୍ୱଯଂ ୱିଦ୍ମଃ| ତଥାପି ଜ୍ଞାନଂ ଗର୍ୱ୍ୱଂ ଜନଯତି କିନ୍ତୁ ପ୍ରେମତୋ ନିଷ୍ଠା ଜାଯତେ| ");
INSERT INTO sanori_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","ଅତଃ କଶ୍ଚନ ଯଦି ମନ୍ୟତେ ମମ ଜ୍ଞାନମାସ୍ତ ଇତି ତର୍ହି ତେନ ଯାଦୃଶଂ ଜ୍ଞାନଂ ଚେଷ୍ଟିତୱ୍ୟଂ ତାଦୃଶଂ କିମପି ଜ୍ଞାନମଦ୍ୟାପି ନ ଲବ୍ଧଂ| ");
INSERT INTO sanori_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","କିନ୍ତୁ ଯ ଈଶ୍ୱରେ ପ୍ରୀଯତେ ସ ଈଶ୍ୱରେଣାପି ଜ୍ଞାଯତେ| ");
INSERT INTO sanori_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","ଦେୱତାବଲିପ୍ରସାଦଭକ୍ଷଣେ ୱଯମିଦଂ ୱିଦ୍ମୋ ଯତ୍ ଜଗନ୍ମଧ୍ୟେ କୋଽପି ଦେୱୋ ନ ୱିଦ୍ୟତେ, ଏକଶ୍ଚେଶ୍ୱରୋ ଦ୍ୱିତୀଯୋ ନାସ୍ତୀତି| ");
INSERT INTO sanori_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","ସ୍ୱର୍ଗେ ପୃଥିୱ୍ୟାଂ ୱା ଯଦ୍ୟପି କେଷୁଚିଦ୍ ଈଶ୍ୱର ଇତି ନାମାରୋପ୍ୟତେ ତାଦୃଶାଶ୍ଚ ବହୱ ଈଶ୍ୱରା ବହୱଶ୍ଚ ପ୍ରଭୱୋ ୱିଦ୍ୟନ୍ତେ ");
INSERT INTO sanori_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","ତଥାପ୍ୟସ୍ମାକମଦ୍ୱିତୀଯ ଈଶ୍ୱରଃ ସ ପିତା ଯସ୍ମାତ୍ ସର୍ୱ୍ୱେଷାଂ ଯଦର୍ଥଞ୍ଚାସ୍ମାକଂ ସୃଷ୍ଟି ର୍ଜାତା, ଅସ୍ମାକଞ୍ଚାଦ୍ୱିତୀଯଃ ପ୍ରଭୁଃ ସ ଯୀଶୁଃ ଖ୍ରୀଷ୍ଟୋ ଯେନ ସର୍ୱ୍ୱୱସ୍ତୂନାଂ ଯେନାସ୍ମାକମପି ସୃଷ୍ଟିଃ କୃତା| ");
INSERT INTO sanori_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","ଅଧିକନ୍ତୁ ଜ୍ଞାନଂ ସର୍ୱ୍ୱେଷାଂ ନାସ୍ତି ଯତଃ କେଚିଦଦ୍ୟାପି ଦେୱତାଂ ସମ୍ମନ୍ୟ ଦେୱପ୍ରସାଦମିୱ ତଦ୍ ଭକ୍ଷ୍ୟଂ ଭୁଞ୍ଜତେ ତେନ ଦୁର୍ବ୍ବଲତଯା ତେଷାଂ ସ୍ୱାନ୍ତାନି ମଲୀମସାନି ଭୱନ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","କିନ୍ତୁ ଭକ୍ଷ୍ୟଦ୍ରୱ୍ୟାଦ୍ ୱଯମ୍ ଈଶ୍ୱରେଣ ଗ୍ରାହ୍ୟା ଭୱାମସ୍ତନ୍ନହି ଯତୋ ଭୁଙ୍କ୍ତ୍ୱା ୱଯମୁତ୍କୃଷ୍ଟା ନ ଭୱାମସ୍ତଦ୍ୱଦଭୁଙ୍କ୍ତ୍ୱାପ୍ୟପକୃଷ୍ଟା ନ ଭୱାମଃ| ");
INSERT INTO sanori_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","ଅତୋ ଯୁଷ୍ମାକଂ ଯା କ୍ଷମତା ସା ଦୁର୍ବ୍ବଲାନାମ୍ ଉନ୍ମାଥସ୍ୱରୂପା ଯନ୍ନ ଭୱେତ୍ ତଦର୍ଥଂ ସାୱଧାନା ଭୱତ| ");
INSERT INTO sanori_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","ଯତୋ ଜ୍ଞାନୱିଶିଷ୍ଟସ୍ତ୍ୱଂ ଯଦି ଦେୱାଲଯେ ଉପୱିଷ୍ଟଃ କେନାପି ଦୃଶ୍ୟସେ ତର୍ହି ତସ୍ୟ ଦୁର୍ବ୍ବଲସ୍ୟ ମନସି କିଂ ପ୍ରସାଦଭକ୍ଷଣ ଉତ୍ସାହୋ ନ ଜନିଷ୍ୟତେ? ");
INSERT INTO sanori_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","ତଥା ସତି ଯସ୍ୟ କୃତେ ଖ୍ରୀଷ୍ଟୋ ମମାର ତୱ ସ ଦୁର୍ବ୍ବଲୋ ଭ୍ରାତା ତୱ ଜ୍ଞାନାତ୍ କିଂ ନ ୱିନଂକ୍ଷ୍ୟତି? ");
INSERT INTO sanori_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","ଇତ୍ୟନେନ ପ୍ରକାରେଣ ଭ୍ରାତୃଣାଂ ୱିରୁଦ୍ଧମ୍ ଅପରାଧ୍ୟଦ୍ଭିସ୍ତେଷାଂ ଦୁର୍ବ୍ବଲାନି ମନାଂସି ୱ୍ୟାଘାତଯଦ୍ଭିଶ୍ଚ ଯୁଷ୍ମାଭିଃ ଖ୍ରୀଷ୍ଟସ୍ୟ ୱୈପରୀତ୍ୟେନାପରାଧ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","ଅତୋ ହେତୋଃ ପିଶିତାଶନଂ ଯଦି ମମ ଭ୍ରାତୁ ର୍ୱିଘ୍ନସ୍ୱରୂପଂ ଭୱେତ୍ ତର୍ହ୍ୟହଂ ଯତ୍ ସ୍ୱଭ୍ରାତୁ ର୍ୱିଘ୍ନଜନକୋ ନ ଭୱେଯଂ ତଦର୍ଥଂ ଯାୱଜ୍ଜୀୱନଂ ପିଶିତଂ ନ ଭୋକ୍ଷ୍ୟେ| ");
INSERT INTO sanori_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","ଅହଂ କିମ୍ ଏକଃ ପ୍ରେରିତୋ ନାସ୍ମି? କିମହଂ ସ୍ୱତନ୍ତ୍ରୋ ନାସ୍ମି? ଅସ୍ମାକଂ ପ୍ରଭୁ ର୍ୟୀଶୁଃ ଖ୍ରୀଷ୍ଟଃ କିଂ ମଯା ନାଦର୍ଶି? ଯୂଯମପି କିଂ ପ୍ରଭୁନା ମଦୀଯଶ୍ରମଫଲସ୍ୱରୂପା ନ ଭୱଥ? ");
INSERT INTO sanori_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","ଅନ୍ୟଲୋକାନାଂ କୃତେ ଯଦ୍ୟପ୍ୟହଂ ପ୍ରେରିତୋ ନ ଭୱେଯଂ ତଥାଚ ଯୁଷ୍ମତ୍କୃତେ ପ୍ରେରିତୋଽସ୍ମି ଯତଃ ପ୍ରଭୁନା ମମ ପ୍ରେରିତତ୍ୱପଦସ୍ୟ ମୁଦ୍ରାସ୍ୱରୂପା ଯୂଯମେୱାଧ୍ୱେ| ");
INSERT INTO sanori_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","ଯେ ଲୋକା ମଯି ଦୋଷମାରୋପଯନ୍ତି ତାନ୍ ପ୍ରତି ମମ ପ୍ରତ୍ୟୁତ୍ତରମେତତ୍| ");
INSERT INTO sanori_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","ଭୋଜନପାନଯୋଃ କିମସ୍ମାକଂ କ୍ଷମତା ନାସ୍ତି? ");
INSERT INTO sanori_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","ଅନ୍ୟେ ପ୍ରେରିତାଃ ପ୍ରଭୋ ର୍ଭ୍ରାତରୌ କୈଫାଶ୍ଚ ଯତ୍ କୁର୍ୱ୍ୱନ୍ତି ତଦ୍ୱତ୍ କାଞ୍ଚିତ୍ ଧର୍ମ୍ମଭଗିନୀଂ ୱ୍ୟୂହ୍ୟ ତଯା ସାର୍ଦ୍ଧଂ ପର୍ୟ୍ୟଟିତୁଂ ୱଯଂ କିଂ ନ ଶକ୍ନୁମଃ? ");
INSERT INTO sanori_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","ସାଂସାରିକଶ୍ରମସ୍ୟ ପରିତ୍ୟାଗାତ୍ କିଂ କେୱଲମହଂ ବର୍ଣବ୍ବାଶ୍ଚ ନିୱାରିତୌ? ");
INSERT INTO sanori_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","ନିଜଧନୱ୍ୟଯେନ କଃ ସଂଗ୍ରାମଂ କରୋତି? କୋ ୱା ଦ୍ରାକ୍ଷାକ୍ଷେତ୍ରଂ କୃତ୍ୱା ତତ୍ଫଲାନି ନ ଭୁଙ୍କ୍ତେ? କୋ ୱା ପଶୁୱ୍ରଜଂ ପାଲଯନ୍ ତତ୍ପଯୋ ନ ପିୱତି? ");
INSERT INTO sanori_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","କିମହଂ କେୱଲାଂ ମାନୁଷିକାଂ ୱାଚଂ ୱଦାମି? ୱ୍ୟୱସ୍ଥାଯାଂ କିମେତାଦୃଶଂ ୱଚନଂ ନ ୱିଦ୍ୟତେ? ");
INSERT INTO sanori_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","ମୂସାୱ୍ୟୱସ୍ଥାଗ୍ରନ୍ଥେ ଲିଖିତମାସ୍ତେ, ତ୍ୱଂ ଶସ୍ୟମର୍ଦ୍ଦକୱୃଷସ୍ୟାସ୍ୟଂ ନ ଭଂତ୍ସ୍ୟସୀତି| ଈଶ୍ୱରେଣ ବଲୀୱର୍ଦ୍ଦାନାମେୱ ଚିନ୍ତା କିଂ କ୍ରିଯତେ? ");
INSERT INTO sanori_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","କିଂ ୱା ସର୍ୱ୍ୱଥାସ୍ମାକଂ କୃତେ ତଦ୍ୱଚନଂ ତେନୋକ୍ତଂ? ଅସ୍ମାକମେୱ କୃତେ ତଲ୍ଲିଖିତଂ| ଯଃ କ୍ଷେତ୍ରଂ କର୍ଷତି ତେନ ପ୍ରତ୍ୟାଶାଯୁକ୍ତେନ କର୍ଷ୍ଟୱ୍ୟଂ, ଯଶ୍ଚ ଶସ୍ୟାନି ମର୍ଦ୍ଦଯତି ତେନ ଲାଭପ୍ରତ୍ୟାଶାଯୁକ୍ତେନ ମର୍ଦ୍ଦିତୱ୍ୟଂ| ");
INSERT INTO sanori_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","ଯୁଷ୍ମତ୍କୃତେଽସ୍ମାଭିଃ ପାରତ୍ରିକାଣି ବୀଜାନି ରୋପିତାନି, ଅତୋ ଯୁଷ୍ମାକମୈହିକଫଲାନାଂ ୱଯମ୍ ଅଂଶିନୋ ଭୱିଷ୍ୟାମଃ କିମେତତ୍ ମହତ୍ କର୍ମ୍ମ? ");
INSERT INTO sanori_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","ଯୁଷ୍ମାସୁ ଯୋଽଧିକାରସ୍ତସ୍ୟ ଭାଗିନୋ ଯଦ୍ୟନ୍ୟେ ଭୱେଯୁସ୍ତର୍ହ୍ୟସ୍ମାଭିସ୍ତତୋଽଧିକଂ କିଂ ତସ୍ୟ ଭାଗିଭି ର୍ନ ଭୱିତୱ୍ୟଂ? ଅଧିକନ୍ତୁ ୱଯଂ ତେନାଧିକାରେଣ ନ ୱ୍ୟୱହୃତୱନ୍ତଃ କିନ୍ତୁ ଖ୍ରୀଷ୍ଟୀଯସୁସଂୱାଦସ୍ୟ କୋଽପି ୱ୍ୟାଘାତୋଽସ୍ମାଭିର୍ୟନ୍ନ ଜାଯେତ ତଦର୍ଥଂ ସର୍ୱ୍ୱଂ ସହାମହେ| ");
INSERT INTO sanori_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","ଅପରଂ ଯେ ପୱିତ୍ରୱସ୍ତୂନାଂ ପରିଚର୍ୟ୍ୟାଂ କୁର୍ୱ୍ୱନ୍ତି ତେ ପୱିତ୍ରୱସ୍ତୁତୋ ଭକ୍ଷ୍ୟାଣି ଲଭନ୍ତେ, ଯେ ଚ ୱେଦ୍ୟାଃ ପରିଚର୍ୟ୍ୟାଂ କୁର୍ୱ୍ୱନ୍ତି ତେ ୱେଦିସ୍ଥୱସ୍ତୂନାମ୍ ଅଂଶିନୋ ଭୱନ୍ତ୍ୟେତଦ୍ ଯୂଯଂ କିଂ ନ ୱିଦ? ");
INSERT INTO sanori_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","ତଦ୍ୱଦ୍ ଯେ ସୁସଂୱାଦଂ ଘୋଷଯନ୍ତି ତୈଃ ସୁସଂୱାଦେନ ଜୀୱିତୱ୍ୟମିତି ପ୍ରଭୁନାଦିଷ୍ଟଂ| ");
INSERT INTO sanori_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","ଅହମେତେଷାଂ ସର୍ୱ୍ୱେଷାଂ କିମପି ନାଶ୍ରିତୱାନ୍ ମାଂ ପ୍ରତି ତଦନୁସାରାତ୍ ଆଚରିତୱ୍ୟମିତ୍ୟାଶଯେନାପି ପତ୍ରମିଦଂ ମଯା ନ ଲିଖ୍ୟତେ ଯତଃ କେନାପି ଜନେନ ମମ ଯଶସୋ ମୁଧାକରଣାତ୍ ମମ ମରଣଂ ୱରଂ| ");
INSERT INTO sanori_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","ସୁସଂୱାଦଘେଷଣାତ୍ ମମ ଯଶୋ ନ ଜାଯତେ ଯତସ୍ତଦ୍ଘୋଷଣଂ ମମାୱଶ୍ୟକଂ ଯଦ୍ୟହଂ ସୁସଂୱାଦଂ ନ ଘୋଷଯେଯଂ ତର୍ହି ମାଂ ଧିକ୍| ");
INSERT INTO sanori_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","ଇଚ୍ଛୁକେନ ତତ୍ କୁର୍ୱ୍ୱତା ମଯା ଫଲଂ ଲପ୍ସ୍ୟତେ କିନ୍ତ୍ୱନିଚ୍ଛୁକେଽପି ମଯି ତତ୍କର୍ମ୍ମଣୋ ଭାରୋଽର୍ପିତୋଽସ୍ତି| ");
INSERT INTO sanori_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","ଏତେନ ମଯା ଲଭ୍ୟଂ ଫଲଂ କିଂ? ସୁସଂୱାଦେନ ମମ ଯୋଽଧିକାର ଆସ୍ତେ ତଂ ଯଦଭଦ୍ରଭାୱେନ ନାଚରେଯଂ ତଦର୍ଥଂ ସୁସଂୱାଦଘୋଷଣସମଯେ ତସ୍ୟ ଖ୍ରୀଷ୍ଟୀଯସୁସଂୱାଦସ୍ୟ ନିର୍ୱ୍ୟଯୀକରଣମେୱ ମମ ଫଲଂ| ");
INSERT INTO sanori_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","ସର୍ୱ୍ୱେଷାମ୍ ଅନାଯତ୍ତୋଽହଂ ଯଦ୍ ଭୂରିଶୋ ଲୋକାନ୍ ପ୍ରତିପଦ୍ୟେ ତଦର୍ଥଂ ସର୍ୱ୍ୱେଷାଂ ଦାସତ୍ୱମଙ୍ଗୀକୃତୱାନ୍| ");
INSERT INTO sanori_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","ଯିହୂଦୀଯାନ୍ ଯତ୍ ପ୍ରତିପଦ୍ୟେ ତଦର୍ଥଂ ଯିହୂଦୀଯାନାଂ କୃତେ ଯିହୂଦୀଯଇୱାଭୱଂ| ଯେ ଚ ୱ୍ୟୱସ୍ଥାଯତ୍ତାସ୍ତାନ୍ ଯତ୍ ପ୍ରତିପଦ୍ୟେ ତଦର୍ଥଂ ୱ୍ୟୱସ୍ଥାନାଯତ୍ତୋ ଯୋଽହଂ ସୋଽହଂ ୱ୍ୟୱସ୍ଥାଯତ୍ତାନାଂ କୃତେ ୱ୍ୟୱସ୍ଥାଯତ୍ତଇୱାଭୱଂ| ");
INSERT INTO sanori_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","ଯେ ଚାଲବ୍ଧୱ୍ୟୱସ୍ଥାସ୍ତାନ୍ ଯତ୍ ପ୍ରତିପଦ୍ୟେ ତଦର୍ଥମ୍ ଈଶ୍ୱରସ୍ୟ ସାକ୍ଷାଦ୍ ଅଲବ୍ଧୱ୍ୟୱସ୍ଥୋ ନ ଭୂତ୍ୱା ଖ୍ରୀଷ୍ଟେନ ଲବ୍ଧୱ୍ୟୱସ୍ଥୋ ଯୋଽହଂ ସୋଽହମ୍ ଅଲବ୍ଧୱ୍ୟୱସ୍ଥାନାଂ କୃତେଽଲବ୍ଧୱ୍ୟୱସ୍ଥ ଇୱାଭୱଂ| ");
INSERT INTO sanori_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","ଦୁର୍ବ୍ବଲାନ୍ ଯତ୍ ପ୍ରତିପଦ୍ୟେ ତଦର୍ଥମହଂ ଦୁର୍ବ୍ବଲାନାଂ କୃତେ ଦୁର୍ବ୍ବଲଇୱାଭୱଂ| ଇତ୍ଥଂ କେନାପି ପ୍ରକାରେଣ କତିପଯା ଲୋକା ଯନ୍ମଯା ପରିତ୍ରାଣଂ ପ୍ରାପ୍ନୁଯୁସ୍ତଦର୍ଥଂ ଯୋ ଯାଦୃଶ ଆସୀତ୍ ତସ୍ୟ କୃତେ ଽହଂ ତାଦୃଶଇୱାଭୱଂ| ");
INSERT INTO sanori_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","ଇଦୃଶ ଆଚାରଃ ସୁସଂୱାଦାର୍ଥଂ ମଯା କ୍ରିଯତେ ଯତୋଽହଂ ତସ୍ୟ ଫଲାନାଂ ସହଭାଗୀ ଭୱିତୁମିଚ୍ଛାମି| ");
INSERT INTO sanori_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","ପଣ୍ୟଲାଭାର୍ଥଂ ଯେ ଧାୱନ୍ତି ଧାୱତାଂ ତେଷାଂ ସର୍ୱ୍ୱେଷାଂ କେୱଲ ଏକଃ ପଣ୍ୟଂ ଲଭତେ ଯୁଷ୍ମାଭିଃ କିମେତନ୍ନ ଜ୍ଞାଯତେ? ଅତୋ ଯୂଯଂ ଯଥା ପଣ୍ୟଂ ଲପ୍ସ୍ୟଧ୍ୱେ ତଥୈୱ ଧାୱତ| ");
INSERT INTO sanori_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","ମଲ୍ଲା ଅପି ସର୍ୱ୍ୱଭୋଗେ ପରିମିତଭୋଗିନୋ ଭୱନ୍ତି ତେ ତୁ ମ୍ଲାନାଂ ସ୍ରଜଂ ଲିପ୍ସନ୍ତେ କିନ୍ତୁ ୱଯମ୍ ଅମ୍ଲାନାଂ ଲିପ୍ସାମହେ| ");
INSERT INTO sanori_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","ତସ୍ମାଦ୍ ଅହମପି ଧାୱାମି କିନ୍ତୁ ଲକ୍ଷ୍ୟମନୁଦ୍ଦିଶ୍ୟ ଧାୱାମି ତନ୍ନହି| ଅହଂ ମଲ୍ଲଇୱ ଯୁଧ୍ୟାମି ଚ କିନ୍ତୁ ଛାଯାମାଘାତଯନ୍ନିୱ ଯୁଧ୍ୟାମି ତନ୍ନହି| ");
INSERT INTO sanori_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","ଇତରାନ୍ ପ୍ରତି ସୁସଂୱାଦଂ ଘୋଷଯିତ୍ୱାହଂ ଯତ୍ ସ୍ୱଯମଗ୍ରାହ୍ୟୋ ନ ଭୱାମି ତଦର୍ଥଂ ଦେହମ୍ ଆହନ୍ମି ୱଶୀକୁର୍ୱ୍ୱେ ଚ| ");
INSERT INTO sanori_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","ହେ ଭ୍ରାତରଃ, ଅସ୍ମତ୍ପିତୃପୁରୁଷାନଧି ଯୂଯଂ ଯଦଜ୍ଞାତା ନ ତିଷ୍ଠତେତି ମମ ୱାଞ୍ଛା, ତେ ସର୍ୱ୍ୱେ ମେଘାଧଃସ୍ଥିତା ବଭୂୱୁଃ ସର୍ୱ୍ୱେ ସମୁଦ୍ରମଧ୍ୟେନ ୱୱ୍ରଜୁଃ, ");
INSERT INTO sanori_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","ସର୍ୱ୍ୱେ ମୂସାମୁଦ୍ଦିଶ୍ୟ ମେଘସମୁଦ୍ରଯୋ ର୍ମଜ୍ଜିତା ବଭୂୱୁଃ ");
INSERT INTO sanori_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","ସର୍ୱ୍ୱ ଏକମ୍ ଆତ୍ମିକଂ ଭକ୍ଷ୍ୟଂ ବୁଭୁଜିର ଏକମ୍ ଆତ୍ମିକଂ ପେଯଂ ପପୁଶ୍ଚ ");
INSERT INTO sanori_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","ଯତସ୍ତେଽନୁଚରତ ଆତ୍ମିକାଦ୍ ଅଚଲାତ୍ ଲବ୍ଧଂ ତୋଯଂ ପପୁଃ ସୋଽଚଲଃ ଖ୍ରୀଷ୍ଟଏୱ| ");
INSERT INTO sanori_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","ତଥା ସତ୍ୟପି ତେଷାଂ ମଧ୍ୟେଽଧିକେଷୁ ଲୋକେଷ୍ୱୀଶ୍ୱରୋ ନ ସନ୍ତୁତୋଷେତି ହେତୋସ୍ତେ ପ୍ରନ୍ତରେ ନିପାତିତାଃ| ");
INSERT INTO sanori_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","ଏତସ୍ମିନ୍ ତେ ଽସ୍ମାକଂ ନିଦର୍ଶନସ୍ୱରୂପା ବଭୂୱୁଃ; ଅତସ୍ତେ ଯଥା କୁତ୍ସିତାଭିଲାଷିଣୋ ବଭୂୱୁରସ୍ମାଭିସ୍ତଥା କୁତ୍ସିତାଭିଲାଷିଭି ର୍ନ ଭୱିତୱ୍ୟଂ| ");
INSERT INTO sanori_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","ଲିଖିତମାସ୍ତେ, ଲୋକା ଭୋକ୍ତୁଂ ପାତୁଞ୍ଚୋପୱିୱିଶୁସ୍ତତଃ କ୍ରୀଡିତୁମୁତ୍ଥିତା ଇତଯନେନ ପ୍ରକାରେଣ ତେଷାଂ କୈଶ୍ଚିଦ୍ ଯଦ୍ୱଦ୍ ଦେୱପୂଜା କୃତା ଯୁଷ୍ମାଭିସ୍ତଦ୍ୱତ୍ ନ କ୍ରିଯତାଂ| ");
INSERT INTO sanori_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","ଅପରଂ ତେଷାଂ କୈଶ୍ଚିଦ୍ ଯଦ୍ୱଦ୍ ୱ୍ୟଭିଚାରଃ କୃତସ୍ତେନ ଚୈକସ୍ମିନ୍ ଦିନେ ତ୍ରଯୋୱିଂଶତିସହସ୍ରାଣି ଲୋକା ନିପାତିତାସ୍ତଦ୍ୱଦ୍ ଅସ୍ମାଭି ର୍ୱ୍ୟଭିଚାରୋ ନ କର୍ତ୍ତୱ୍ୟଃ| ");
INSERT INTO sanori_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","ତେଷାଂ କେଚିଦ୍ ଯଦ୍ୱତ୍ ଖ୍ରୀଷ୍ଟଂ ପରୀକ୍ଷିତୱନ୍ତସ୍ତସ୍ମାଦ୍ ଭୁଜଙ୍ଗୈ ର୍ନଷ୍ଟାଶ୍ଚ ତଦ୍ୱଦ୍ ଅସ୍ମାଭିଃ ଖ୍ରୀଷ୍ଟୋ ନ ପରୀକ୍ଷିତୱ୍ୟଃ| ");
INSERT INTO sanori_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","ତେଷାଂ କେଚିଦ୍ ଯଥା ୱାକ୍କଲହଂ କୃତୱନ୍ତସ୍ତତ୍କାରଣାତ୍ ହନ୍ତ୍ରା ୱିନାଶିତାଶ୍ଚ ଯୁଷ୍ମାଭିସ୍ତଦ୍ୱଦ୍ ୱାକ୍କଲହୋ ନ କ୍ରିଯତାଂ| ");
INSERT INTO sanori_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","ତାନ୍ ପ୍ରତି ଯାନ୍ୟେତାନି ଜଘଟିରେ ତାନ୍ୟସ୍ମାକଂ ନିଦର୍ଶନାନି ଜଗତଃ ଶେଷଯୁଗେ ୱର୍ତ୍ତମାନାନାମ୍ ଅସ୍ମାକଂ ଶିକ୍ଷାର୍ଥଂ ଲିଖିତାନି ଚ ବଭୂୱୁଃ| ");
INSERT INTO sanori_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","ଅତଏୱ ଯଃ କଶ୍ଚିଦ୍ ସୁସ୍ଥିରଂମନ୍ୟଃ ସ ଯନ୍ନ ପତେତ୍ ତତ୍ର ସାୱଧାନୋ ଭୱତୁ| ");
INSERT INTO sanori_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","ମାନୁଷିକପରୀକ୍ଷାତିରିକ୍ତା କାପି ପରୀକ୍ଷା ଯୁଷ୍ମାନ୍ ନାକ୍ରାମତ୍, ଈଶ୍ୱରଶ୍ଚ ୱିଶ୍ୱାସ୍ୟଃ ସୋଽତିଶକ୍ତ୍ୟାଂ ପରୀକ୍ଷାଯାଂ ପତନାତ୍ ଯୁଷ୍ମାନ୍ ରକ୍ଷିଷ୍ୟତି, ପରୀକ୍ଷା ଚ ଯଦ୍ ଯୁଷ୍ମାଭିଃ ସୋଢୁଂ ଶକ୍ୟତେ ତଦର୍ଥଂ ତଯା ସହ ନିସ୍ତାରସ୍ୟ ପନ୍ଥାନଂ ନିରୂପଯିଷ୍ୟତି| ");
INSERT INTO sanori_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","ହେ ପ୍ରିଯଭ୍ରାତରଃ, ଦେୱପୂଜାତୋ ଦୂରମ୍ ଅପସରତ| ");
INSERT INTO sanori_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","ଅହଂ ଯୁଷ୍ମାନ୍ ୱିଜ୍ଞାନ୍ ମତ୍ୱା ପ୍ରଭାଷେ ମଯା ଯତ୍ କଥ୍ୟତେ ତଦ୍ ଯୁଷ୍ମାଭି ର୍ୱିୱିଚ୍ୟତାଂ| ");
INSERT INTO sanori_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","ଯଦ୍ ଧନ୍ୟୱାଦପାତ୍ରମ୍ ଅସ୍ମାଭି ର୍ଧନ୍ୟଂ ଗଦ୍ୟତେ ତତ୍ କିଂ ଖ୍ରୀଷ୍ଟସ୍ୟ ଶୋଣିତସ୍ୟ ସହଭାଗିତ୍ୱଂ ନହି? ଯଶ୍ଚ ପୂପୋଽସ୍ମାଭି ର୍ଭଜ୍ୟତେ ସ କିଂ ଖ୍ରୀଷ୍ଟସ୍ୟ ୱପୁଷଃ ସହଭାଗିତ୍ୱଂ ନହି? ");
INSERT INTO sanori_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","ୱଯଂ ବହୱଃ ସନ୍ତୋଽପ୍ୟେକପୂପସ୍ୱରୂପା ଏକୱପୁଃସ୍ୱରୂପାଶ୍ଚ ଭୱାମଃ, ଯତୋ ୱଯଂ ସର୍ୱ୍ୱ ଏକପୂପସ୍ୟ ସହଭାଗିନଃ| ");
INSERT INTO sanori_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","ଯୂଯଂ ଶାରୀରିକମ୍ ଇସ୍ରାଯେଲୀଯୱଂଶଂ ନିରୀକ୍ଷଧ୍ୱଂ| ଯେ ବଲୀନାଂ ମାଂସାନି ଭୁଞ୍ଜତେ ତେ କିଂ ଯଜ୍ଞୱେଦ୍ୟାଃ ସହଭାଗିନୋ ନ ଭୱନ୍ତି? ");
INSERT INTO sanori_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","ଇତ୍ୟନେନ ମଯା କିଂ କଥ୍ୟତେ? ଦେୱତା ୱାସ୍ତୱିକୀ ଦେୱତାଯୈ ବଲିଦାନଂ ୱା ୱାସ୍ତୱିକଂ କିଂ ଭୱେତ୍? ");
INSERT INTO sanori_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","ତନ୍ନହି କିନ୍ତୁ ଭିନ୍ନଜାତିଭି ର୍ୟେ ବଲଯୋ ଦୀଯନ୍ତେ ତ ଈଶ୍ୱରାଯ ତନ୍ନହି ଭୂତେଭ୍ୟଏୱ ଦୀଯନ୍ତେ ତସ୍ମାଦ୍ ଯୂଯଂ ଯଦ୍ ଭୂତାନାଂ ସହଭାଗିନୋ ଭୱଥେତ୍ୟହଂ ନାଭିଲଷାମି| ");
INSERT INTO sanori_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","ପ୍ରଭୋଃ କଂସେନ ଭୂତାନାମପି କଂସେନ ପାନଂ ଯୁଷ୍ମାଭିରସାଧ୍ୟଂ; ଯୂଯଂ ପ୍ରଭୋ ର୍ଭୋଜ୍ୟସ୍ୟ ଭୂତାନାମପି ଭୋଜ୍ୟସ୍ୟ ସହଭାଗିନୋ ଭୱିତୁଂ ନ ଶକ୍ନୁଥ| ");
INSERT INTO sanori_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","ୱଯଂ କିଂ ପ୍ରଭୁଂ ସ୍ପର୍ଦ୍ଧିଷ୍ୟାମହେ? ୱଯଂ କିଂ ତସ୍ମାଦ୍ ବଲୱନ୍ତଃ? ");
INSERT INTO sanori_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","ମାଂ ପ୍ରତି ସର୍ୱ୍ୱଂ କର୍ମ୍ମାପ୍ରତିଷିଦ୍ଧଂ କିନ୍ତୁ ନ ସର୍ୱ୍ୱଂ ହିତଜନକଂ ସର୍ୱ୍ୱମ୍ ଅପ୍ରତିଷିଦ୍ଧଂ କିନ୍ତୁ ନ ସର୍ୱ୍ୱଂ ନିଷ୍ଠାଜନକଂ| ");
INSERT INTO sanori_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","ଆତ୍ମହିତଃ କେନାପି ନ ଚେଷ୍ଟିତୱ୍ୟଃ କିନ୍ତୁ ସର୍ୱ୍ୱୈଃ ପରହିତଶ୍ଚେଷ୍ଟିତୱ୍ୟଃ| ");
INSERT INTO sanori_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","ଆପଣେ ଯତ୍ କ୍ରଯ୍ୟଂ ତଦ୍ ଯୁଷ୍ମାଭିଃ ସଂୱେଦସ୍ୟାର୍ଥଂ କିମପି ନ ପୃଷ୍ଟ୍ୱା ଭୁଜ୍ୟତାଂ ");
INSERT INTO sanori_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","ଯତଃ ପୃଥିୱୀ ତନ୍ମଧ୍ୟସ୍ଥଞ୍ଚ ସର୍ୱ୍ୱଂ ପରମେଶ୍ୱରସ୍ୟ| ");
INSERT INTO sanori_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","ଅପରମ୍ ଅୱିଶ୍ୱାସିଲୋକାନାଂ କେନଚିତ୍ ନିମନ୍ତ୍ରିତା ଯୂଯଂ ଯଦି ତତ୍ର ଜିଗମିଷଥ ତର୍ହି ତେନ ଯଦ୍ ଯଦ୍ ଉପସ୍ଥାପ୍ୟତେ ତଦ୍ ଯୁଷ୍ମାଭିଃ ସଂୱେଦସ୍ୟାର୍ଥଂ କିମପି ନ ପୃଷ୍ଟ୍ୱା ଭୁଜ୍ୟତାଂ| ");
INSERT INTO sanori_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","କିନ୍ତୁ ତତ୍ର ଯଦି କଶ୍ଚିଦ୍ ଯୁଷ୍ମାନ୍ ୱଦେତ୍ ଭକ୍ଷ୍ୟମେତଦ୍ ଦେୱତାଯାଃ ପ୍ରସାଦ ଇତି ତର୍ହି ତସ୍ୟ ଜ୍ଞାପଯିତୁରନୁରୋଧାତ୍ ସଂୱେଦସ୍ୟାର୍ଥଞ୍ଚ ତଦ୍ ଯୁଷ୍ମାଭି ର୍ନ ଭୋକ୍ତୱ୍ୟଂ| ପୃଥିୱୀ ତନ୍ମଧ୍ୟସ୍ଥଞ୍ଚ ସର୍ୱ୍ୱଂ ପରମେଶ୍ୱରସ୍ୟ, ");
INSERT INTO sanori_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","ସତ୍ୟମେତତ୍, କିନ୍ତୁ ମଯା ଯଃ ସଂୱେଦୋ ନିର୍ଦ୍ଦିଶ୍ୟତେ ସ ତୱ ନହି ପରସ୍ୟୈୱ| ");
INSERT INTO sanori_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","ଅନୁଗ୍ରହପାତ୍ରେଣ ମଯା ଧନ୍ୟୱାଦଂ କୃତ୍ୱା ଯଦ୍ ଭୁଜ୍ୟତେ ତତ୍କାରଣାଦ୍ ଅହଂ କୁତୋ ନିନ୍ଦିଷ୍ୟେ? ");
INSERT INTO sanori_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","ତସ୍ମାଦ୍ ଭୋଜନଂ ପାନମ୍ ଅନ୍ୟଦ୍ୱା କର୍ମ୍ମ କୁର୍ୱ୍ୱଦ୍ଭି ର୍ୟୁଷ୍ମାଭିଃ ସର୍ୱ୍ୱମେୱେଶ୍ୱରସ୍ୟ ମହିମ୍ନଃ ପ୍ରକାଶାର୍ଥଂ କ୍ରିଯତାଂ| ");
INSERT INTO sanori_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","ଯିହୂଦୀଯାନାଂ ଭିନ୍ନଜାତୀଯାନାମ୍ ଈଶ୍ୱରସ୍ୟ ସମାଜସ୍ୟ ୱା ୱିଘ୍ନଜନକୈ ର୍ୟୁଷ୍ମାଭି ର୍ନ ଭୱିତୱ୍ୟଂ| ");
INSERT INTO sanori_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","ଅହମପ୍ୟାତ୍ମହିତମ୍ ଅଚେଷ୍ଟମାନୋ ବହୂନାଂ ପରିତ୍ରାଣାର୍ଥଂ ତେଷାଂ ହିତଂ ଚେଷ୍ଟମାନଃ ସର୍ୱ୍ୱୱିଷଯେ ସର୍ୱ୍ୱେଷାଂ ତୁଷ୍ଟିକରୋ ଭୱାମୀତ୍ୟନେନାହଂ ଯଦ୍ୱତ୍ ଖ୍ରୀଷ୍ଟସ୍ୟାନୁଗାମୀ ତଦ୍ୱଦ୍ ଯୂଯଂ ମମାନୁଗାମିନୋ ଭୱତ| ");
INSERT INTO sanori_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","ହେ ଭ୍ରାତରଃ, ଯୂଯଂ ସର୍ୱ୍ୱସ୍ମିନ୍ କାର୍ୟ୍ୟେ ମାଂ ସ୍ମରଥ ମଯା ଚ ଯାଦୃଗୁପଦିଷ୍ଟାସ୍ତାଦୃଗାଚରଥୈତତ୍କାରଣାତ୍ ମଯା ପ୍ରଶଂସନୀଯା ଆଧ୍ବେ| ");
INSERT INTO sanori_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","ତଥାପି ମମୈଷା ୱାଞ୍ଛା ଯଦ୍ ଯୂଯମିଦମ୍ ଅୱଗତା ଭୱଥ, ");
INSERT INTO sanori_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","ଏକୈକସ୍ୟ ପୁରୁଷସ୍ୟୋତ୍ତମାଙ୍ଗସ୍ୱରୂପଃ ଖ୍ରୀଷ୍ଟଃ, ଯୋଷିତଶ୍ଚୋତ୍ତମାଙ୍ଗସ୍ୱରୂପଃ ପୁମାନ୍, ଖ୍ରୀଷ୍ଟସ୍ୟ ଚୋତ୍ତମାଙ୍ଗସ୍ୱରୂପ ଈଶ୍ୱରଃ| ");
INSERT INTO sanori_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","ଅପରମ୍ ଆଚ୍ଛାଦିତୋତ୍ତମାଙ୍ଗେନ ଯେନ ପୁଂସା ପ୍ରାର୍ଥନା କ୍ରିଯତ ଈଶ୍ୱରୀଯୱାଣୀ କଥ୍ୟତେ ୱା ତେନ ସ୍ୱୀଯୋତ୍ତମାଙ୍ଗମ୍ ଅୱଜ୍ଞାଯତେ| ");
INSERT INTO sanori_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","ଅନାଚ୍ଛାଦିତୋତ୍ତମାଙ୍ଗଯା ଯଯା ଯୋଷିତା ଚ ପ୍ରାର୍ଥନା କ୍ରିଯତ ଈଶ୍ୱରୀଯୱାଣୀ କଥ୍ୟତେ ୱା ତଯାପି ସ୍ୱୀଯୋତ୍ତମାଙ୍ଗମ୍ ଅୱଜ୍ଞାଯତେ ଯତଃ ସା ମୁଣ୍ଡିତଶିରଃସଦୃଶା| ");
INSERT INTO sanori_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","ଅନାଚ୍ଛାଦିତମସ୍ତକା ଯା ଯୋଷିତ୍ ତସ୍ୟାଃ ଶିରଃ ମୁଣ୍ଡନୀଯମେୱ କିନ୍ତୁ ଯୋଷିତଃ କେଶଚ୍ଛେଦନଂ ଶିରୋମୁଣ୍ଡନଂ ୱା ଯଦି ଲଜ୍ଜାଜନକଂ ଭୱେତ୍ ତର୍ହି ତଯା ସ୍ୱଶିର ଆଚ୍ଛାଦ୍ୟତାଂ| ");
INSERT INTO sanori_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","ପୁମାନ୍ ଈଶ୍ୱରସ୍ୟ ପ୍ରତିମୂର୍ତ୍ତିଃ ପ୍ରତିତେଜଃସ୍ୱରୂପଶ୍ଚ ତସ୍ମାତ୍ ତେନ ଶିରୋ ନାଚ୍ଛାଦନୀଯଂ କିନ୍ତୁ ସୀମନ୍ତିନୀ ପୁଂସଃ ପ୍ରତିବିମ୍ବସ୍ୱରୂପା| ");
INSERT INTO sanori_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","ଯତୋ ଯୋଷାତଃ ପୁମାନ୍ ନୋଦପାଦି କିନ୍ତୁ ପୁଂସୋ ଯୋଷିଦ୍ ଉଦପାଦି| ");
INSERT INTO sanori_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","ଅଧିକନ୍ତୁ ଯୋଷିତଃ କୃତେ ପୁଂସଃ ସୃଷ୍ଟି ର୍ନ ବଭୂୱ କିନ୍ତୁ ପୁଂସଃ କୃତେ ଯୋଷିତଃ ସୃଷ୍ଟି ର୍ବଭୂୱ| ");
INSERT INTO sanori_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","ଇତି ହେତୋ ର୍ଦୂତାନାମ୍ ଆଦରାଦ୍ ଯୋଷିତା ଶିରସ୍ୟଧୀନତାସୂଚକମ୍ ଆୱରଣଂ ଧର୍ତ୍ତୱ୍ୟଂ| ");
INSERT INTO sanori_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","ତଥାପି ପ୍ରଭୋ ର୍ୱିଧିନା ପୁମାଂସଂ ୱିନା ଯୋଷିନ୍ନ ଜାଯତେ ଯୋଷିତଞ୍ଚ ୱିନା ପୁମାନ୍ ନ ଜାଯତେ| ");
INSERT INTO sanori_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","ଯତୋ ଯଥା ପୁଂସୋ ଯୋଷିଦ୍ ଉଦପାଦି ତଥା ଯୋଷିତଃ ପୁମାନ୍ ଜାଯତେ, ସର୍ୱ୍ୱୱସ୍ତୂନି ଚେଶ୍ୱରାଦ୍ ଉତ୍ପଦ୍ୟନ୍ତେ| ");
INSERT INTO sanori_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","ଯୁଷ୍ମାଭିରେୱୈତଦ୍ ୱିୱିଚ୍ୟତାଂ, ଅନାୱୃତଯା ଯୋଷିତା ପ୍ରାର୍ଥନଂ କିଂ ସୁଦୃଶ୍ୟଂ ଭୱେତ୍? ");
INSERT INTO sanori_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","ପୁରୁଷସ୍ୟ ଦୀର୍ଘକେଶତ୍ୱଂ ତସ୍ୟ ଲଜ୍ଜାଜନକଂ, କିନ୍ତୁ ଯୋଷିତୋ ଦୀର୍ଘକେଶତ୍ୱଂ ତସ୍ୟା ଗୌରୱଜନକଂ ");
INSERT INTO sanori_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","ଯତ ଆଚ୍ଛାଦନାଯ ତସ୍ୟୈ କେଶା ଦତ୍ତା ଇତି କିଂ ଯୁଷ୍ମାଭିଃ ସ୍ୱଭାୱତୋ ନ ଶିକ୍ଷ୍ୟତେ? ");
INSERT INTO sanori_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","ଅତ୍ର ଯଦି କଶ୍ଚିଦ୍ ୱିୱଦିତୁମ୍ ଇଚ୍ଛେତ୍ ତର୍ହ୍ୟସ୍ମାକମ୍ ଈଶ୍ୱରୀଯସମିତୀନାଞ୍ଚ ତାଦୃଶୀ ରୀତି ର୍ନ ୱିଦ୍ୟତେ| ");
INSERT INTO sanori_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","ଯୁଷ୍ମାଭି ର୍ନ ଭଦ୍ରାଯ କିନ୍ତୁ କୁତ୍ସିତାଯ ସମାଗମ୍ୟତେ ତସ୍ମାଦ୍ ଏତାନି ଭାଷମାଣେନ ମଯା ଯୂଯଂ ନ ପ୍ରଶଂସନୀଯାଃ| ");
INSERT INTO sanori_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","ପ୍ରଥମତଃ ସମିତୌ ସମାଗତାନାଂ ଯୁଷ୍ମାକଂ ମଧ୍ୟେ ଭେଦାଃ ସନ୍ତୀତି ୱାର୍ତ୍ତା ମଯା ଶ୍ରୂଯତେ ତନ୍ମଧ୍ୟେ କିଞ୍ଚିତ୍ ସତ୍ୟଂ ମନ୍ୟତେ ଚ| ");
INSERT INTO sanori_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","ଯତୋ ହେତୋ ର୍ୟୁଷ୍ମନ୍ମଧ୍ୟେ ଯେ ପରୀକ୍ଷିତାସ୍ତେ ଯତ୍ ପ୍ରକାଶ୍ୟନ୍ତେ ତଦର୍ଥଂ ଭେଦୈ ର୍ଭୱିତୱ୍ୟମେୱ| ");
INSERT INTO sanori_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","ଏକତ୍ର ସମାଗତୈ ର୍ୟୁଷ୍ମାଭିଃ ପ୍ରଭାୱଂ ଭେाଜ୍ୟଂ ଭୁଜ୍ୟତ ଇତି ନହି; ");
INSERT INTO sanori_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","ଯତୋ ଭୋଜନକାଲେ ଯୁଷ୍ମାକମେକୈକେନ ସ୍ୱକୀଯଂ ଭକ୍ଷ୍ୟଂ ତୂର୍ଣଂ ଗ୍ରସ୍ୟତେ ତସ୍ମାଦ୍ ଏକୋ ଜନୋ ବୁଭୁକ୍ଷିତସ୍ତିଷ୍ଠତି, ଅନ୍ୟଶ୍ଚ ପରିତୃପ୍ତୋ ଭୱତି| ");
INSERT INTO sanor