﻿USE sofia;
DROP TABLE IF EXISTS sofia.sanmal_vpl;
CREATE TABLE sanmal_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sanmal_vpl WRITE;
INSERT INTO sanmal_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ഇബ്രാഹീമഃ സന്താനോ ദായൂദ് തസ്യ സന്താനോ യീശുഖ്രീഷ്ടസ്തസ്യ പൂർവ്വപുരുഷവംശശ്രേണീ| ");
INSERT INTO sanmal_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ഇബ്രാഹീമഃ പുത്ര ഇസ്ഹാക് തസ്യ പുത്രോ യാകൂബ് തസ്യ പുത്രോ യിഹൂദാസ്തസ്യ ഭ്രാതരശ്ച| ");
INSERT INTO sanmal_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","തസ്മാദ് യിഹൂദാതസ്താമരോ ഗർഭേ പേരസ്സേരഹൗ ജജ്ഞാതേ, തസ്യ പേരസഃ പുത്രോ ഹിഷ്രോൺ തസ്യ പുത്രോ ഽരാമ്| ");
INSERT INTO sanmal_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","തസ്യ പുത്രോ ഽമ്മീനാദബ് തസ്യ പുത്രോ നഹശോൻ തസ്യ പുത്രഃ സൽമോൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","തസ്മാദ് രാഹബോ ഗർഭേ ബോയമ് ജജ്ഞേ, തസ്മാദ് രൂതോ ഗർഭേ ഓബേദ് ജജ്ഞേ, തസ്യ പുത്രോ യിശയഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","തസ്യ പുത്രോ ദായൂദ് രാജഃ തസ്മാദ് മൃതോരിയസ്യ ജായായാം സുലേമാൻ ജജ്ഞേ| ");
INSERT INTO sanmal_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","തസ്യ പുത്രോ രിഹബിയാമ്, തസ്യ പുത്രോഽബിയഃ, തസ്യ പുത്ര ആസാ:| ");
INSERT INTO sanmal_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","തസ്യ സുതോ യിഹോശാഫട് തസ്യ സുതോ യിഹോരാമ തസ്യ സുത ഉഷിയഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","തസ്യ സുതോ യോഥമ് തസ്യ സുത ആഹമ് തസ്യ സുതോ ഹിഷ്കിയഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","തസ്യ സുതോ മിനശിഃ, തസ്യ സുത ആമോൻ തസ്യ സുതോ യോശിയഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ബാബിൽനഗരേ പ്രവസനാത് പൂർവ്വം സ യോശിയോ യിഖനിയം തസ്യ ഭ്രാതൃംശ്ച ജനയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","തതോ ബാബിലി പ്രവസനകാലേ യിഖനിയഃ ശൽതീയേലം ജനയാമാസ, തസ്യ സുതഃ സിരുബ്ബാവിൽ| ");
INSERT INTO sanmal_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","തസ്യ സുതോ ഽബോഹുദ് തസ്യ സുത ഇലീയാകീമ് തസ്യ സുതോഽസോർ| ");
INSERT INTO sanmal_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","അസോരഃ സുതഃ സാദോക് തസ്യ സുത ആഖീമ് തസ്യ സുത ഇലീഹൂദ്| ");
INSERT INTO sanmal_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","തസ്യ സുത ഇലിയാസർ തസ്യ സുതോ മത്തൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","തസ്യ സുതോ യാകൂബ് തസ്യ സുതോ യൂഷഫ് തസ്യ ജായാ മരിയമ്; തസ്യ ഗർഭേ യീശുരജനി, തമേവ ഖ്രീഷ്ടമ് (അർഥാദ് അഭിഷിക്തം) വദന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ഇത്ഥമ് ഇബ്രാഹീമോ ദായൂദം യാവത് സാകല്യേന ചതുർദശപുരുഷാഃ; ആ ദായൂദഃ കാലാദ് ബാബിലി പ്രവസനകാലം യാവത് ചതുർദശപുരുഷാ ഭവന്തി| ബാബിലി പ്രവാസനകാലാത് ഖ്രീഷ്ടസ്യ കാലം യാവത് ചതുർദശപുരുഷാ ഭവന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","യീശുഖ്രീഷ്ടസ്യ ജന്മ കഥ്ഥതേ| മരിയമ് നാമികാ കന്യാ യൂഷഫേ വാഗ്ദത്താസീത്, തദാ തയോഃ സങ്ഗമാത് പ്രാക് സാ കന്യാ  പവിത്രേണാത്മനാ ഗർഭവതീ ബഭൂവ| ");
INSERT INTO sanmal_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","തത്ര തസ്യാഃ പതി ര്യൂഷഫ് സൗജന്യാത് തസ്യാഃ കലങ്ഗം പ്രകാശയിതുമ് അനിച്ഛൻ ഗോപനേനേ താം പാരിത്യക്തും മനശ്ചക്രേ| ");
INSERT INTO sanmal_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","സ തഥൈവ ഭാവയതി, തദാനീം പരമേശ്വരസ്യ ദൂതഃ സ്വപ്നേ തം ദർശനം ദത്ത്വാ വ്യാജഹാര, ഹേ ദായൂദഃ സന്താന യൂഷഫ് ത്വം നിജാം ജായാം മരിയമമ് ആദാതും മാ ഭൈഷീഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","യതസ്തസ്യാ ഗർഭഃ പവിത്രാദാത്മനോഽഭവത്, സാ ച പുത്രം പ്രസവിഷ്യതേ, തദാ ത്വം തസ്യ നാമ യീശുമ് (അർഥാത് ത്രാതാരം) കരീഷ്യസേ, യസ്മാത് സ നിജമനുജാൻ തേഷാം കലുഷേഭ്യ ഉദ്ധരിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ഇത്ഥം സതി, പശ്യ ഗർഭവതീ കന്യാ തനയം പ്രസവിഷ്യതേ| ഇമ്മാനൂയേൽ തദീയഞ്ച നാമധേയം ഭവിഷ്യതി|| ഇമ്മാനൂയേൽ അസ്മാകം സങ്ഗീശ്വരഇത്യർഥഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","ഇതി യദ് വചനം പുർവ്വം ഭവിഷ്യദ്വക്ത്രാ ഈശ്വരഃ കഥായാമാസ, തത് തദാനീം സിദ്ധമഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","അനന്തരം യൂഷഫ് നിദ്രാതോ ജാഗരിത ഉത്ഥായ പരമേശ്വരീയദൂതസ്യ നിദേശാനുസാരേണ നിജാം ജായാം ജഗ്രാഹ, ");
INSERT INTO sanmal_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","കിന്തു യാവത് സാ നിജം പ്രഥമസുതം അ സുഷുവേ, താവത് താം നോപാഗച്ഛത്, തതഃ സുതസ്യ നാമ യീശും ചക്രേ| ");
INSERT INTO sanmal_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","അനന്തരം ഹേരോദ് സംജ്ഞകേ രാജ്ഞി രാജ്യം ശാസതി യിഹൂദീയദേശസ്യ ബൈത്ലേഹമി നഗരേ യീശൗ ജാതവതി ച, കതിപയാ ജ്യോതിർവ്വുദഃ പൂർവ്വസ്യാ ദിശോ യിരൂശാലമ്നഗരം സമേത്യ കഥയമാസുഃ, ");
INSERT INTO sanmal_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","യോ യിഹൂദീയാനാം രാജാ ജാതവാൻ, സ കുത്രാസ്തേ? വയം പൂർവ്വസ്യാം ദിശി തിഷ്ഠന്തസ്തദീയാം താരകാമ് അപശ്യാമ തസ്മാത് തം പ്രണന്തുമ് അाഗമാമ| ");
INSERT INTO sanmal_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","തദാ ഹേരോദ് രാജാ കഥാമേതാം നിശമ്യ യിരൂശാലമ്നഗരസ്ഥിതൈഃ സർവ്വമാനവൈഃ സാർദ്ധമ് ഉദ്വിജ്യ ");
INSERT INTO sanmal_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","സർവ്വാൻ പ്രധാനയാജകാൻ അധ്യാപകാംശ്ച സമാഹൂയാനീയ പപ്രച്ഛ, ഖ്രീഷ്ടഃ കുത്ര ജനിഷ്യതേ? ");
INSERT INTO sanmal_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","തദാ തേ കഥയാമാസുഃ, യിഹൂദീയദേശസ്യ ബൈത്ലേഹമി നഗരേ, യതോ ഭവിഷ്യദ്വാദിനാ ഇത്ഥം ലിഖിതമാസ്തേ, ");
INSERT INTO sanmal_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","സർവ്വാഭ്യോ രാജധാനീഭ്യോ യിഹൂദീയസ്യ നീവൃതഃ| ഹേ യീഹൂദീയദേശസ്യേ ബൈത്ലേഹമ് ത്വം ന ചാവരാ| ഇസ്രായേലീയലോകാൻ മേ യതോ യഃ പാലയിഷ്യതി| താദൃഗേകോ മഹാരാജസ്ത്വന്മധ്യ ഉദ്ഭവിഷ്യതീ|| ");
INSERT INTO sanmal_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","തദാനീം ഹേരോദ് രാജാ താൻ ജ്യോതിർവ്വിദോ ഗോപനമ് ആഹൂയ സാ താരകാ കദാ ദൃഷ്ടാഭവത് , തദ് വിനിശ്ചയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","അപരം താൻ ബൈത്ലേഹമം പ്രഹീത്യ ഗദിതവാൻ, യൂയം യാത, യത്നാത് തം ശിശുമ് അന്വിഷ്യ തദുദ്ദേശേ പ്രാപ്തേ മഹ്യം വാർത്താം ദാസ്യഥ, തതോ മയാപി ഗത്വാ സ പ്രണംസ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","തദാനീം രാജ്ഞ ഏതാദൃശീമ് ആജ്ഞാം പ്രാപ്യ തേ പ്രതസ്ഥിരേ, തതഃ പൂർവ്വർസ്യാം ദിശി സ്ഥിതൈസ്തൈ ര്യാ താരകാ ദൃഷ്ടാ സാ താരകാ തേഷാമഗ്രേ ഗത്വാ യത്ര സ്ഥാനേ ശിശൂരാസ്തേ, തസ്യ സ്ഥാനസ്യോപരി സ്ഥഗിതാ തസ്യൗ| ");
INSERT INTO sanmal_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","തദ് ദൃഷ്ട്വാ തേ മഹാനന്ദിതാ ബഭൂവുഃ, ");
INSERT INTO sanmal_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","തതോ ഗേഹമധ്യ പ്രവിശ്യ തസ്യ മാത്രാ മരിയമാ സാദ്ധം തം ശിശും നിരീക്ഷയ ദണ്ഡവദ് ഭൂത്വാ പ്രണേമുഃ, അപരം സ്വേഷാം ഘനസമ്പത്തിം മോചയിത്വാ സുവർണം കുന്ദുരും ഗന്ധരമഞ്ച തസ്മൈ ദർശനീയം ദത്തവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","പശ്ചാദ് ഹേരോദ് രാജസ്യ സമീപം പുനരപി ഗന്തും സ്വപ്ന ഈശ്വരേണ നിഷിദ്ധാഃ സന്തോ ഽന്യേന പഥാ തേ നിജദേശം പ്രതി പ്രതസ്ഥിരേ| ");
INSERT INTO sanmal_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","അനന്തരം തേഷു ഗതവത്മു പരമേശ്വരസ്യ ദൂതോ യൂഷഫേ സ്വപ്നേ ദർശനം ദത്വാ ജഗാദ, ത്വമ് ഉത്ഥായ ശിശും തന്മാതരഞ്ച ഗൃഹീത്വാ മിസർദേശം പലായസ്വ, അപരം യാവദഹം തുഭ്യം വാർത്താം ന കഥയിഷ്യാമി, താവത് തത്രൈവ നിവസ, യതോ രാജാ ഹേരോദ് ശിശും നാശയിതും മൃഗയിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","തദാനീം യൂഷഫ് ഉത്ഥായ രജന്യാം ശിശും തന്മാതരഞ്ച ഗൃഹീത്വാ മിസർദേശം പ്രതി പ്രതസ്ഥേ, ");
INSERT INTO sanmal_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ഗത്വാ ച ഹേരോദോ നൃപതേ ർമരണപര്യ്യന്തം തത്ര ദേശേ ന്യുവാസ, തേന മിസർദേശാദഹം പുത്രം സ്വകീയം സമുപാഹൂയമ്| യദേതദ്വചനമ് ഈശ്വരേണ ഭവിഷ്യദ്വാദിനാ കഥിതം തത് സഫലമഭൂത്| ");
INSERT INTO sanmal_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","അനന്തരം ഹേരോദ് ജ്യോതിർവിദ്ഭിരാത്മാനം പ്രവഞ്ചിതം വിജ്ഞായ ഭൃശം ചുകോപ; അപരം ജ്യോതിർവ്വിദ്ഭ്യസ്തേന വിനിശ്ചിതം യദ് ദിനം തദ്ദിനാദ് ഗണയിത്വാ ദ്വിതീയവത്സരം പ്രവിഷ്ടാ യാവന്തോ ബാലകാ അസ്മിൻ ബൈത്ലേഹമ്നഗരേ തത്സീമമധ്യേ ചാസൻ, ലോകാൻ പ്രഹിത്യ താൻ സർവ്വാൻ ഘാതയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","അതഃ അനേകസ്യ വിലാപസ്യ നിനാദ: ക്രന്ദനസ്യ ച| ശോകേന കൃതശബ്ദശ്ച രാമായാം സംനിശമ്യതേ| സ്വബാലഗണഹേതോർവൈ രാഹേൽ നാരീ തു രോദിനീ| ന മന്യതേ പ്രബോധന്തു യതസ്തേ നൈവ മന്തി ഹി|| ");
INSERT INTO sanmal_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","യദേതദ് വചനം യിരീമിയനാമകഭവിഷ്യദ്വാദിനാ കഥിതം തത് തദാനീം സഫലമ് അഭൂത്| ");
INSERT INTO sanmal_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","തദനന്തരം ഹേരേദി രാജനി മൃതേ പരമേശ്വരസ്യ ദൂതോ മിസർദേശേ സ്വപ്നേ ദർശനം ദത്ത്വാ യൂഷഫേ കഥിതവാൻ ");
INSERT INTO sanmal_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ത്വമ് ഉത്ഥായ ശിശും തന്മാതരഞ്ച ഗൃഹീത്വാ പുനരപീസ്രായേലോ ദേശം യാഹീ, യേ ജനാഃ ശിശും നാശയിതുമ് അമൃഗയന്ത, തേ മൃതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","തദാനീം സ ഉത്ഥായ ശിശും തന്മാതരഞ്ച ഗൃഹ്ലൻ ഇസ്രായേൽദേശമ് ആജഗാമ| ");
INSERT INTO sanmal_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","കിന്തു യിഹൂദീയദേശേ അർഖിലായനാമ രാജകുമാരോ നിജപിതു ർഹേരോദഃ പദം പ്രാപ്യ രാജത്വം കരോതീതി നിശമ്യ തത് സ്ഥാനം യാതും ശങ്കിതവാൻ, പശ്ചാത് സ്വപ്ന ഈശ്വരാത് പ്രബോധം പ്രാപ്യ ഗാലീൽദേശസ്യ പ്രദേശൈകം പ്രസ്ഥായ നാസരന്നാമ നഗരം ഗത്വാ തത്ര ന്യുഷിതവാൻ, ");
INSERT INTO sanmal_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","തേന തം നാസരതീയം കഥയിഷ്യന്തി, യദേതദ്വാക്യം ഭവിഷ്യദ്വാദിഭിരുക്ത്തം തത് സഫലമഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","തദാനോം യോഹ്ന്നാമാ മജ്ജയിതാ യിഹൂദീയദേശസ്യ പ്രാന്തരമ് ഉപസ്ഥായ പ്രചാരയൻ കഥയാമാസ, ");
INSERT INTO sanmal_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","മനാംസി പരാവർത്തയത, സ്വർഗീയരാജത്വം സമീപമാഗതമ്| ");
INSERT INTO sanmal_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","പരമേശസ്യ പന്ഥാനം പരിഷ്കുരുത സർവ്വതഃ| തസ്യ രാജപഥാംശ്ചൈവ സമീകുരുത സർവ്വഥാ| ഇത്യേതത് പ്രാന്തരേ വാക്യം വദതഃ കസ്യചിദ് രവഃ|| ");
INSERT INTO sanmal_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ഏതദ്വചനം യിശയിയഭവിഷ്യദ്വാദിനാ യോഹനമുദ്ദിശ്യ ഭാഷിതമ്| യോഹനോ വസനം മഹാങ്ഗരോമജം തസ്യ കടൗ ചർമ്മകടിബന്ധനം; സ ച ശൂകകീടാൻ മധു ച ഭുക്തവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","തദാനീം യിരൂശാലമ്നഗരനിവാസിനഃ സർവ്വേ യിഹൂദിദേശീയാ യർദ്ദന്തടിന്യാ ഉഭയതടസ്ഥാശ്ച മാനവാ ബഹിരാഗത്യ തസ്യ സമീപേ ");
INSERT INTO sanmal_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","സ്വീയം സ്വീയം ദുരിതമ് അങ്ഗീകൃത്യ തസ്യാം യർദ്ദനി തേന മജ്ജിതാ ബഭൂവുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","അപരം ബഹൂൻ ഫിരൂശിനഃ സിദൂകിനശ്ച മനുജാൻ മംക്തും സ്വസമീപമ് ആഗച്ഛ്തോ വിലോക്യ സ താൻ അഭിദധൗ, രേ രേ ഭുജഗവംശാ ആഗാമീനഃ കോപാത് പലായിതും യുഷ്മാൻ കശ്ചേതിതവാൻ? ");
INSERT INTO sanmal_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","മനഃപരാവർത്തനസ്യ സമുചിതം ഫലം ഫലത| ");
INSERT INTO sanmal_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","കിന്ത്വസ്മാകം താത ഇബ്രാഹീമ് അസ്തീതി സ്വേഷു മനഃസു ചീന്തയന്തോ മാ വ്യാഹരത| യതോ യുഷ്മാൻ അഹം വദാമി, ഈശ്വര ഏതേഭ്യഃ പാഷാണേഭ്യ ഇബ്രാഹീമഃ സന്താനാൻ ഉത്പാദയിതും ശക്നോതി| ");
INSERT INTO sanmal_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","അപരം പാദപാനാം മൂലേ കുഠാര ഇദാനീമപി ലഗൻ ആസ്തേ, തസ്മാദ് യസ്മിൻ പാദപേ ഉത്തമം ഫലം ന ഭവതി, സ കൃത്തോ മധ്യേഽഗ്നിം നിക്ഷേപ്സ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","അപരമ് അഹം മനഃപരാവർത്തനസൂചകേന മജ്ജനേന യുഷ്മാൻ മജ്ജയാമീതി സത്യം, കിന്തു മമ പശ്ചാദ് യ ആഗച്ഛതി, സ മത്തോപി മഹാൻ, അഹം തദീയോപാനഹൗ വോഢുമപി നഹി യോഗ്യോസ്മി, സ യുഷ്മാൻ വഹ്നിരൂപേ പവിത്ര ആത്മനി സംമജ്ജയിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","തസ്യ കാരേ സൂർപ ആസ്തേ, സ സ്വീയശസ്യാനി സമ്യക് പ്രസ്ഫോട്യ നിജാൻ സകലഗോധൂമാൻ സംഗൃഹ്യ ഭാണ്ഡാഗാരേ സ്ഥാപയിഷ്യതി, കിംന്തു സർവ്വാണി വുഷാണ്യനിർവ്വാണവഹ്നിനാ ദാഹയിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","അനന്തരം യീശു ര്യോഹനാ മജ്ജിതോ ഭവിതും ഗാലീൽപ്രദേശാദ് യർദ്ദനി തസ്യ സമീപമ് ആജഗാമ| ");
INSERT INTO sanmal_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","കിന്തു യോഹൻ തം നിഷിധ്യ ബഭാഷേ, ത്വം കിം മമ സമീപമ് ആഗച്ഛസി? വരം ത്വയാ മജ്ജനം മമ പ്രയോജനമ് ആസ്തേ| ");
INSERT INTO sanmal_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","തദാനീം യീശുഃ പ്രത്യവോചത്; ഈദാനീമ് അനുമന്യസ്വ, യത ഇത്ഥം സർവ്വധർമ്മസാധനമ് അസ്മാകം കർത്തവ്യം, തതഃ സോഽന്വമന്യത| ");
INSERT INTO sanmal_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","അനന്തരം യീശുരമ്മസി മജ്ജിതുഃ സൻ തത്ക്ഷണാത് തോയമധ്യാദ് ഉത്ഥായ ജഗാമ, തദാ ജീമൂതദ്വാരേ മുക്തേ ജാതേ, സ ഈശ്വരസ്യാത്മാനം കപോതവദ് അവരുഹ്യ സ്വോപര്യ്യാഗച്ഛന്തം വീക്ഷാഞ്ചക്രേ| ");
INSERT INTO sanmal_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","അപരമ് ഏഷ മമ പ്രിയഃ പുത്ര ഏതസ്മിന്നേവ മമ മഹാസന്തോഷ ഏതാദൃശീ വ്യോമജാ വാഗ് ബഭൂവ| ");
INSERT INTO sanmal_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","തതഃ പരം യീശുഃ പ്രതാരകേണ പരീക്ഷിതോ ഭവിതുമ് ആത്മനാ പ്രാന്തരമ് ആകൃഷ്ടഃ ");
INSERT INTO sanmal_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","സൻ ചത്വാരിംശദഹോരാത്രാൻ അനാഹാരസ്തിഷ്ഠൻ ക്ഷുധിതോ ബഭൂവ| ");
INSERT INTO sanmal_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","തദാനീം പരീക്ഷിതാ തത്സമീപമ് ആഗത്യ വ്യാഹൃതവാൻ, യദി ത്വമീശ്വരാത്മജോ ഭവേസ്തർഹ്യാജ്ഞയാ പാഷാണാനേതാൻ പൂപാൻ വിധേഹി| ");
INSERT INTO sanmal_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","തതഃ സ പ്രത്യബ്രവീത്, ഇത്ഥം ലിഖിതമാസ്തേ, \"മനുജഃ കേവലപൂപേന ന ജീവിഷ്യതി, കിന്ത്വീശ്വരസ്യ വദനാദ് യാനി യാനി വചാംസി നിഃസരന്തി തൈരേവ ജീവിഷ്യതി| \" ");
INSERT INTO sanmal_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","തദാ പ്രതാരകസ്തം പുണ്യനഗരം നീത്വാ മന്ദിരസ്യ ചൂഡോപരി നിധായ ഗദിതവാൻ, ");
INSERT INTO sanmal_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ത്വം യദിശ്വരസ്യ തനയോ ഭവേസ്തർഹീതോഽധഃ പത, യത ഇത്ഥം ലിഖിതമാസ്തേ, ആദേക്ഷ്യതി നിജാൻ ദൂതാൻ രക്ഷിതും ത്വാം പരമേശ്വരഃ| യഥാ സർവ്വേഷു മാർഗേഷു ത്വദീയചരണദ്വയേ| ന ലഗേത് പ്രസ്തരാഘാതസ്ത്വാം ഘരിഷ്യന്തി തേ കരൈഃ|| ");
INSERT INTO sanmal_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","തദാനീം യീശുസ്തസ്മൈ കഥിതവാൻ ഏതദപി ലിഖിതമാസ്തേ, \"ത്വം നിജപ്രഭും പരമേശ്വരം മാ പരീക്ഷസ്വ| \" ");
INSERT INTO sanmal_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","അനന്തരം പ്രതാരകഃ പുനരപി തമ് അത്യുഞ്ചധരാധരോപരി നീത്വാ ജഗതഃ സകലരാജ്യാനി തദൈശ്വര്യ്യാണി ച ദർശയാശ്ചകാര കഥയാഞ്ചകാര ച, ");
INSERT INTO sanmal_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","യദി ത്വം ദണ്ഡവദ് ഭവൻ മാം പ്രണമേസ്തർഹ്യഹമ് ഏതാനി തുഭ്യം പ്രദാസ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","തദാനീം യീശുസ്തമവോചത്, ദൂരീഭവ പ്രതാരക, ലിഖിതമിദമ് ആസ്തേ, \"ത്വയാ നിജഃ പ്രഭുഃ പരമേശ്വരഃ പ്രണമ്യഃ കേവലഃ സ സേവ്യശ്ച| \" ");
INSERT INTO sanmal_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","തതഃ പ്രതാരകേണ സ പര്യ്യത്യാജി, തദാ സ്വർഗീയദൂതൈരാഗത്യ സ സിഷേവേ| ");
INSERT INTO sanmal_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","തദനന്തരം യോഹൻ കാരായാം ബബന്ധേ, തദ്വാർത്താം നിശമ്യ യീശുനാ ഗാലീൽ പ്രാസ്ഥീയത| ");
INSERT INTO sanmal_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","തതഃ പരം സ നാസരന്നഗരം വിഹായ ജലഘേസ്തടേ സിബൂലൂന്നപ്താലീ ഏതയോരുവഭയോഃ പ്രദേശയോഃ സീമ്നോർമധ്യവർത്തീ യ: കഫർനാഹൂമ് തന്നഗരമ് ഇത്വാ ന്യവസത്| ");
INSERT INTO sanmal_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","തസ്മാത്, അന്യാദേശീയഗാലീലി യർദ്ദൻപാരേഽബ്ധിരോധസി| നപ്താലിസിബൂലൂന്ദേശൗ യത്ര സ്ഥാനേ സ്ഥിതൗ പുരാ| ");
INSERT INTO sanmal_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","തത്രത്യാ മനുജാ യേ യേ പര്യ്യഭ്രാമ്യൻ തമിസ്രകേ| തൈർജനൈർബൃഹദാലോകഃ പരിദർശിഷ്യതേ തദാ| അവസൻ യേ ജനാ ദേശേ മൃത്യുച്ഛായാസ്വരൂപകേ| തേഷാമുപരി ലോകാനാമാലോകഃ സംപ്രകാശിതഃ|| ");
INSERT INTO sanmal_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","യദേതദ്വചനം യിശയിയഭവിഷ്യദ്വാദിനാ പ്രോക്തം, തത് തദാ സഫലമ് അഭൂത്| ");
INSERT INTO sanmal_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","അനന്തരം യീശുഃ സുസംവാദം പ്രചാരയൻ ഏതാം കഥാം കഥയിതുമ് ആരേഭേ, മനാംസി പരാവർത്തയത, സ്വർഗീയരാജത്വം സവിധമഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","തതഃ പരം യീശു ർഗാലീലോ ജലധേസ്തടേന ഗച്ഛൻ ഗച്ഛൻ ആന്ദ്രിയസ്തസ്യ ഭ്രാതാ ശിമോൻ അർഥതോ യം പിതരം വദന്തി ഏതാവുഭൗ ജലഘൗ ജാലം ക്ഷിപന്തൗ ദദർശ, യതസ്തൗ മീനധാരിണാവാസ്താമ്| ");
INSERT INTO sanmal_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","തദാ സ താവാഹൂയ വ്യാജഹാര, യുവാം മമ പശ്ചാദ് ആഗച്ഛതം, യുവാമഹം മനുജധാരിണൗ കരിഷ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","തേനൈവ തൗ ജാലം വിഹായ തസ്യ പശ്ചാത് ആഗച്ഛതാമ്| ");
INSERT INTO sanmal_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","അനന്തരം തസ്മാത് സ്ഥാനാത് വ്രജൻ വ്രജൻ സിവദിയസ്യ സുതൗ യാകൂബ് യോഹന്നാമാനൗ ദ്വൗ സഹജൗ താതേന സാർദ്ധം നൗകോപരി ജാലസ്യ ജീർണോദ്ധാരം കുർവ്വന്തൗ വീക്ഷ്യ താവാഹൂതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","തത്ക്ഷണാത് തൗ നാവം സ്വതാതഞ്ച വിഹായ തസ്യ പശ്ചാദ്ഗാമിനൗ ബഭൂവതുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","അനന്തരം ഭജനഭവനേ സമുപദിശൻ രാജ്യസ്യ സുസംവാദം പ്രചാരയൻ മനുജാനാം സർവ്വപ്രകാരാൻ രോഗാൻ സർവ്വപ്രകാരപീഡാശ്ച ശമയൻ യീശുഃ കൃത്സ്നം ഗാലീൽദേശം ഭ്രമിതുമ് ആരഭത| ");
INSERT INTO sanmal_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","തേന കൃത്സ്നസുരിയാദേശസ്യ മധ്യം തസ്യ യശോ വ്യാപ്നോത്, അപരം ഭൂതഗ്രസ്താ അപസ്മാരർഗീണഃ പക്ഷാധാതിപ്രഭൃതയശ്ച യാവന്തോ മനുജാ നാനാവിധവ്യാധിഭിഃ ക്ലിഷ്ടാ ആസൻ, തേഷു സർവ്വേഷു തസ്യ സമീപമ് ആനീതേഷു സ താൻ സ്വസ്ഥാൻ ചകാര| ");
INSERT INTO sanmal_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ഏതേന ഗാലീൽ-ദികാപനി-യിരൂശാലമ്-യിഹൂദീയദേശേഭ്യോ യർദ്ദനഃ പാരാഞ്ച ബഹവോ മനുജാസ്തസ്യ പശ്ചാദ് ആഗച്ഛൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","അനന്തരം സ ജനനിവഹം നിരീക്ഷ്യ ഭൂധരോപരി വ്രജിത്വാ സമുപവിവേശ| ");
INSERT INTO sanmal_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","തദാനീം ശിഷ്യേഷു തസ്യ സമീപമാഗതേഷു തേന തേഭ്യ ഏഷാ കഥാ കഥ്യാഞ്ചക്രേ| ");
INSERT INTO sanmal_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","അഭിമാനഹീനാ ജനാ ധന്യാഃ, യതസ്തേ സ്വർഗീയരാജ്യമ് അധികരിഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ഖിദ്യമാനാ മനുജാ ധന്യാഃ, യസ്മാത് തേ സാന്ത്വനാം പ്രാപ്സന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","നമ്രാ മാനവാശ്ച ധന്യാഃ, യസ്മാത് തേ മേദിനീമ് അധികരിഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ധർമ്മായ ബുഭുക്ഷിതാഃ തൃഷാർത്താശ്ച മനുജാ ധന്യാഃ, യസ്മാത് തേ പരിതർപ്സ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","കൃപാലവോ മാനവാ ധന്യാഃ, യസ്മാത് തേ കൃപാം പ്രാപ്സ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","നിർമ്മലഹൃദയാ മനുജാശ്ച ധന്യാഃ, യസ്മാത് ത ഈശ്ചരം ദ്രക്ഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","മേലയിതാരോ മാനവാ ധന്യാഃ, യസ്മാത് ത ഈശ്ചരസ്യ സന്താനത്വേന വിഖ്യാസ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ധർമ്മകാരണാത് താഡിതാ മനുജാ ധന്യാ, യസ്മാത് സ്വർഗീയരാജ്യേ തേഷാമധികരോ വിദ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","യദാ മനുജാ മമ നാമകൃതേ യുഷ്മാൻ നിന്ദന്തി താഡയന്തി മൃഷാ നാനാദുർവ്വാക്യാനി വദന്തി ച, തദാ യുയം ധന്യാഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","തദാ ആനന്ദത, തഥാ ഭൃശം ഹ്ലാദധ്വഞ്ച, യതഃ സ്വർഗേ ഭൂയാംസി ഫലാനി ലപ്സ്യധ്വേ; തേ യുഷ്മാകം പുരാതനാൻ ഭവിഷ്യദ്വാദിനോഽപി താദൃഗ് അതാഡയൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","യുയം മേദിന്യാം ലവണരൂപാഃ, കിന്തു യദി ലവണസ്യ ലവണത്വമ് അപയാതി, തർഹി തത് കേന പ്രകാരേണ സ്വാദുയുക്തം ഭവിഷ്യതി? തത് കസ്യാപി കാര്യ്യസ്യായോഗ്യത്വാത് കേവലം ബഹിഃ പ്രക്ഷേപ്തും നരാണാം പദതലേന ദലയിതുഞ്ച യോഗ്യം ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","യൂയം ജഗതി ദീപ്തിരൂപാഃ, ഭൂധരോപരി സ്ഥിതം നഗരം ഗുപ്തം ഭവിതും നഹി ശക്ഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","അപരം മനുജാഃ പ്രദീപാൻ പ്രജ്വാല്യ ദ്രോണാധോ ന സ്ഥാപയന്തി, കിന്തു ദീപാധാരോപര്യ്യേവ സ്ഥാപയന്തി, തേന തേ ദീപാ ഗേഹസ്ഥിതാൻ സകലാൻ പ്രകാശയന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","യേന മാനവാ യുഷ്മാകം സത്കർമ്മാണി വിലോക്യ യുഷ്മാകം സ്വർഗസ്ഥം പിതരം ധന്യം വദന്തി, തേഷാം സമക്ഷം യുഷ്മാകം ദീപ്തിസ്താദൃക് പ്രകാശതാമ്| ");
INSERT INTO sanmal_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","അഹം വ്യവസ്ഥാം ഭവിഷ്യദ്വാക്യഞ്ച ലോപ്തുമ് ആഗതവാൻ, ഇത്ഥം മാനുഭവത, തേ ദ്വേ ലോപ്തും നാഗതവാൻ, കിന്തു സഫലേ കർത്തുമ് ആഗതോസ്മി| ");
INSERT INTO sanmal_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","അപരം യുഷ്മാൻ അഹം തഥ്യം വദാമി യാവത് വ്യോമമേദിന്യോ ർധ്വംസോ ന ഭവിഷ്യതി, താവത് സർവ്വസ്മിൻ സഫലേ ന ജാതേ വ്യവസ്ഥായാ ഏകാ മാത്രാ ബിന്ദുരേകോപി വാ ന ലോപ്സ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","തസ്മാത് യോ ജന ഏതാസാമ് ആജ്ഞാനാമ് അതിക്ഷുദ്രാമ് ഏകാജ്ഞാമപീ ലംഘതേ മനുജാംഞ്ച തഥൈവ ശിക്ഷയതി, സ സ്വർഗീയരാജ്യേ സർവ്വേഭ്യഃ ക്ഷുദ്രത്വേന വിഖ്യാസ്യതേ, കിന്തു യോ ജനസ്താം പാലയതി, തഥൈവ ശിക്ഷയതി ച, സ സ്വർഗീയരാജ്യേ പ്രധാനത്വേന വിഖ്യാസ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","അപരം യുഷ്മാൻ അഹം വദാമി, അധ്യാപകഫിരൂശിമാനവാനാം ധർമ്മാനുഷ്ഠാനാത് യുഷ്മാകം ധർമ്മാനുഷ്ഠാനേ നോത്തമേ ജാതേ യൂയമ് ഈശ്വരീയരാജ്യം പ്രവേഷ്ടും ന ശക്ഷ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","അപരഞ്ച ത്വം നരം മാ വധീഃ, യസ്മാത് യോ നരം ഹന്തി, സ വിചാരസഭായാം ദണ്ഡാർഹോ ഭവിഷ്യതി, പൂർവ്വകാലീനജനേഭ്യ ഇതി കഥിതമാസീത്, യുഷ്മാഭിരശ്രാവി| ");
INSERT INTO sanmal_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","കിന്ത്വഹം യുഷ്മാൻ വദാമി, യഃ കശ്ചിത് കാരണം വിനാ നിജഭ്രാത്രേ കുപ്യതി, സ വിചാരസഭായാം ദണ്ഡാർഹോ ഭവിഷ്യതി; യഃ കശ്ചിച്ച സ്വീയസഹജം നിർബ്ബോധം വദതി, സ മഹാസഭായാം ദണ്ഡാർഹോ ഭവിഷ്യതി; പുനശ്ച ത്വം മൂഢ ഇതി വാക്യം യദി കശ്ചിത് സ്വീയഭ്രാതരം വക്തി, തർഹി നരകാഗ്നൗ സ ദണ്ഡാർഹോ ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","അതോ വേദ്യാഃ സമീപം നിജനൈവേദ്യേ സമാനീതേഽപി നിജഭ്രാതരം പ്രതി കസ്മാച്ചിത് കാരണാത് ത്വം യദി ദോഷീ വിദ്യസേ, തദാനീം തവ തസ്യ സ്മൃതി ർജായതേ ച, ");
INSERT INTO sanmal_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","തർഹി തസ്യാ വേദ്യാഃ സമീപേ നിജനൈവൈദ്യം നിധായ തദൈവ ഗത്വാ പൂർവ്വം തേന സാർദ്ധം മില, പശ്ചാത് ആഗത്യ നിജനൈവേദ്യം നിവേദയ| ");
INSERT INTO sanmal_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","അന്യഞ്ച യാവത് വിവാദിനാ സാർദ്ധം വർത്മനി തിഷ്ഠസി, താവത് തേന സാർദ്ധം മേലനം കുരു; നോ ചേത് വിവാദീ വിചാരയിതുഃ സമീപേ ത്വാം സമർപയതി വിചാരയിതാ ച രക്ഷിണഃ സന്നിധൗ സമർപയതി തദാ ത്വം കാരായാം ബധ്യേഥാഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","തർഹി ത്വാമഹം തഥ്ഥം ബ്രവീമി, ശേഷകപർദകേഽപി ന പരിശോധിതേ തസ്മാത് സ്ഥാനാത് കദാപി ബഹിരാഗന്തും ന ശക്ഷ്യസി| ");
INSERT INTO sanmal_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","അപരം ത്വം മാ വ്യഭിചര, യദേതദ് വചനം പൂർവ്വകാലീനലോകേഭ്യഃ കഥിതമാസീത്, തദ് യൂയം ശ്രുതവന്തഃ; ");
INSERT INTO sanmal_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","കിന്ത്വഹം യുഷ്മാൻ വദാമി, യദി കശ്ചിത് കാമതഃ കാഞ്ചന യോഷിതം പശ്യതി, തർഹി സ മനസാ തദൈവ വ്യഭിചരിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","തസ്മാത് തവ ദക്ഷിണം നേത്രം യദി ത്വാം ബാധതേ, തർഹി തന്നേത്രമ് ഉത്പാട്യ ദൂരേ നിക്ഷിപ, യസ്മാത് തവ സർവ്വവപുഷോ നരകേ നിക്ഷേപാത് തവൈകാങ്ഗസ്യ നാശോ വരം| ");
INSERT INTO sanmal_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","യദ്വാ തവ ദക്ഷിണഃ കരോ യദി ത്വാം ബാധതേ, തർഹി തം കരം ഛിത്ത്വാ ദൂരേ നിക്ഷിപ, യതഃ സർവ്വവപുഷോ നരകേ നിക്ഷേപാത് ഏകാങ്ഗസ്യ നാശോ വരം| ");
INSERT INTO sanmal_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","ഉക്തമാസ്തേ, യദി കശ്ചിൻ നിജജായാം പരിത്യക്ത്തുമ് ഇച്ഛതി, തർഹി സ തസ്യൈ ത്യാഗപത്രം ദദാതു| ");
INSERT INTO sanmal_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","കിന്ത്വഹം യുഷ്മാൻ വ്യാഹരാമി, വ്യഭിചാരദോഷേ ന ജാതേ യദി കശ്ചിൻ നിജജായാം പരിത്യജതി, തർഹി സ താം വ്യഭിചാരയതി; യശ്ച താം ത്യക്താം സ്ത്രിയം വിവഹതി, സോപി വ്യഭിചരതി| ");
INSERT INTO sanmal_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","പുനശ്ച ത്വം മൃഷാ ശപഥമ് ന കുർവ്വൻ ഈശ്ചരായ നിജശപഥം പാലയ, പൂർവ്വകാലീനലോകേഭ്യോ യൈഷാ കഥാ കഥിതാ, താമപി യൂയം ശ്രുതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","കിന്ത്വഹം യുഷ്മാൻ വദാമി, കമപി ശപഥം മാ കാർഷ്ട, അർഥതഃ സ്വർഗനാമ്നാ ന, യതഃ സ ഈശ്വരസ്യ സിംഹാസനം; ");
INSERT INTO sanmal_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","പൃഥിവ്യാ നാമ്നാപി ന, യതഃ സാ തസ്യ പാദപീഠം; യിരൂശാലമോ നാമ്നാപി ന, യതഃ സാ മഹാരാജസ്യ പുരീ; ");
INSERT INTO sanmal_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","നിജശിരോനാമ്നാപി ന, യസ്മാത് തസ്യൈകം കചമപി സിതമ് അസിതം വാ കർത്തും ത്വയാ ന ശക്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","അപരം യൂയം സംലാപസമയേ കേവലം ഭവതീതി ന ഭവതീതി ച വദത യത ഇതോഽധികം യത് തത് പാപാത്മനോ ജായതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","അപരം ലോചനസ്യ വിനിമയേന ലോചനം ദന്തസ്യ വിനിമയേന ദന്തഃ പൂർവ്വക്തമിദം വചനഞ്ച യുഷ്മാഭിരശ്രൂയത| ");
INSERT INTO sanmal_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","കിന്ത്വഹം യുഷ്മാൻ വദാമി യൂയം ഹിംസകം നരം മാ വ്യാഘാതയത| കിന്തു കേനചിത് തവ ദക്ഷിണകപോലേ ചപേടാഘാതേ കൃതേ തം പ്രതി വാമം കപോലഞ്ച വ്യാഘോടയ| ");
INSERT INTO sanmal_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","അപരം കേനചിത് ത്വയാ സാർധ്ദം വിവാദം കൃത്വാ തവ പരിധേയവസനേ ജിഘൃതിതേ തസ്മായുത്തരീയവസനമപി ദേഹി| ");
INSERT INTO sanmal_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","യദി കശ്ചിത് ത്വാം ക്രോശമേകം നയനാർഥം അന്യായതോ ധരതി, തദാ തേന സാർധ്ദം ക്രോശദ്വയം യാഹി| ");
INSERT INTO sanmal_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","യശ്ച മാനവസ്ത്വാം യാചതേ, തസ്മൈ ദേഹി, യദി കശ്ചിത് തുഭ്യം ധാരയിതുമ് ഇച്ഛതി, തർഹി തം പ്രതി പരാംമുഖോ മാ ഭൂഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","നിജസമീപവസിനി പ്രേമ കുരു, കിന്തു ശത്രും പ്രതി ദ്വേഷം കുരു, യദേതത് പുരോക്തം വചനം ഏതദപി യൂയം ശ്രുതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","കിന്ത്വഹം യുഷ്മാൻ വദാമി, യൂയം രിപുവ്വപി പ്രേമ കുരുത, യേ ച യുഷ്മാൻ ശപന്തേ, താന, ആശിഷം വദത, യേ ച യുഷ്മാൻ ഋृതീയന്തേ, തേഷാം മങ്ഗലം കുരുത, യേ ച യുഷ്മാൻ നിന്ദന്തി, താഡയന്തി ച, തേഷാം കൃതേ പ്രാർഥയധ്വം| ");
INSERT INTO sanmal_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","തത്ര യഃ സതാമസതാഞ്ചോപരി പ്രഭാകരമ് ഉദായയതി, തഥാ ധാർമ്മികാനാമധാർമ്മികാനാഞ്ചോപരി നീരം വർഷയതി താദൃശോ യോ യുഷ്മാകം സ്വർഗസ്ഥഃ പിതാ, യൂയം തസ്യൈവ സന്താനാ ഭവിഷ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","യേ യുഷ്മാസു പ്രേമ കുർവ്വന്തി, യൂയം യദി കേവലം തേവ്വേവ പ്രേമ കുരുഥ, തർഹി യുഷ്മാകം കിം ഫലം ഭവിഷ്യതി? ചണ്ഡാലാ അപി താദൃശം കിം ന കുർവ്വന്തി? ");
INSERT INTO sanmal_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","അപരം യൂയം യദി കേവലം സ്വീയഭ്രാതൃത്വേന നമത, തർഹി കിം മഹത് കർമ്മ കുരുഥ? ചണ്ഡാലാ അപി താദൃശം കിം ന കുർവ്വന്തി? ");
INSERT INTO sanmal_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","തസ്മാത് യുഷ്മാകം സ്വർഗസ്ഥഃ പിതാ യഥാ പൂർണോ ഭവതി, യൂയമപി താദൃശാ ഭവത| ");
INSERT INTO sanmal_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","സാവധാനാ ഭവത, മനുജാൻ ദർശയിതും തേഷാം ഗോചരേ ധർമ്മകർമ്മ മാ കുരുത, തഥാ കൃതേ യുഷ്മാകം സ്വർഗസ്ഥപിതുഃ സകാശാത് കിഞ്ചന ഫലം ന പ്രാപ്സ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","ത്വം യദാ ദദാസി തദാ കപടിനോ ജനാ യഥാ മനുജേഭ്യഃ പ്രശംസാം പ്രാപ്തും ഭജനഭവനേ രാജമാർഗേ ച തൂരീം വാദയന്തി, തഥാ മാ കുരിु, അഹം തുഭ്യം യഥാർഥം കഥയാമി, തേ സ്വകായം ഫലമ് അലഭന്ത| ");
INSERT INTO sanmal_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","കിന്തു ത്വം യദാ ദദാസി, തദാ നിജദക്ഷിണകരോ യത് കരോതി, തദ് വാമകരം മാ ജ്ഞാപയ| ");
INSERT INTO sanmal_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","തേന തവ ദാനം ഗുപ്തം ഭവിഷ്യതി യസ്തു തവ പിതാ ഗുപ്തദർശീ, സ പ്രകാശ്യ തുഭ്യം ഫലം ദാസ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","അപരം യദാ പ്രാർഥയസേ, തദാ കപടിനഇവ മാ കുരു, യസ്മാത് തേ ഭജനഭവനേ രാജമാർഗസ്യ കോണേ തിഷ്ഠന്തോ ലോകാൻ ദർശയന്തഃ പ്രാർഥയിതും പ്രീയന്തേ; അഹം യുഷ്മാൻ തഥ്യം വദാമി, തേ സ്വകീയഫലം പ്രാപ്നുവൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","തസ്മാത് പ്രാർഥനാകാലേ അന്തരാഗാരം പ്രവിശ്യ ദ്വാരം രുദ്വ്വാ ഗുപ്തം പശ്യതസ്തവ പിതുഃ സമീപേ പ്രാർഥയസ്വ; തേന തവ യഃ പിതാ ഗുപ്തദർശീ, സ പ്രകാശ്യ തുഭ്യം ഫലം ദാസ്യതിl ");
INSERT INTO sanmal_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","അപരം പ്രാർഥനാകാലേ ദേവപൂജകാഇവ മുധാ പുനരുക്തിം മാ കുരു, യസ്മാത് തേ ബോധന്തേ, ബഹുവാരം കഥായാം കഥിതായാം തേഷാം പ്രാർഥനാ ഗ്രാഹിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","യൂയം തേഷാമിവ മാ കുരുത, യസ്മാത് യുഷ്മാകം യദ് യത് പ്രയോജനം യാചനാതഃ പ്രാഗേവ യുഷ്മാകം പിതാ തത് ജാനാതി| ");
INSERT INTO sanmal_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","അതഏവ യൂയമ ഈദൃക് പ്രാർഥയധ്വം, ഹേ അസ്മാകം സ്വർഗസ്ഥപിതഃ, തവ നാമ പൂജ്യം ഭവതു| ");
INSERT INTO sanmal_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","തവ രാജത്വം ഭവതു; തവേച്ഛാ സ്വർഗേ യഥാ തഥൈവ മേദിന്യാമപി സഫലാ ഭവതു| ");
INSERT INTO sanmal_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","അസ്മാകം പ്രയോജനീയമ് ആഹാരമ് അദ്യ ദേഹി| ");
INSERT INTO sanmal_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","വയം യഥാ നിജാപരാധിനഃ ക്ഷമാമഹേ, തഥൈവാസ്മാകമ് അപരാധാൻ ക്ഷമസ്വ| ");
INSERT INTO sanmal_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","അസ്മാൻ പരീക്ഷാം മാനയ, കിന്തു പാപാത്മനോ രക്ഷ; രാജത്വം ഗൗരവം പരാക്രമഃ ഏതേ സർവ്വേ സർവ്വദാ തവ; തഥാസ്തു| ");
INSERT INTO sanmal_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","യദി യൂയമ് അന്യേഷാമ് അപരാധാൻ ക്ഷമധ്വേ തർഹി യുഷ്മാകം സ്വർഗസ്ഥപിതാപി യുഷ്മാൻ ക്ഷമിഷ്യതേ; ");
INSERT INTO sanmal_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","കിന്തു യദി യൂയമ് അന്യേഷാമ് അപരാധാൻ ന ക്ഷമധ്വേ, തർഹി യുഷ്മാകം ജനകോപി യുഷ്മാകമ് അപരാധാൻ ന ക്ഷമിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","അപരമ് ഉപവാസകാലേ കപടിനോ ജനാ മാനുഷാൻ ഉപവാസം ജ്ഞാപയിതും സ്വേഷാം വദനാനി മ്ലാനാനി കുർവ്വന്തി, യൂയം തഇവ വിഷണവദനാ മാ ഭവത; അഹം യുഷ്മാൻ തഥ്യം വദാമി തേ സ്വകീയഫലമ് അലഭന്ത| ");
INSERT INTO sanmal_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","യദാ ത്വമ് ഉപവസസി, തദാ യഥാ ലോകൈസ്ത്വം ഉപവാസീവ ന ദൃശ്യസേ, കിന്തു തവ യോഽഗോചരഃ പിതാ തേനൈവ ദൃശ്യസേ, തത്കൃതേ നിജശിരസി തൈലം മർദ്ദയ വദനഞ്ച പ്രക്ഷാലയ; ");
INSERT INTO sanmal_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","തേന തവ യഃ പിതാ ഗുപ്തദർശീ സ പ്രകാശ്യ തുഭ്യം ഫലം ദാസ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","അപരം യത്ര സ്ഥാനേ കീടാഃ കലങ്കാശ്ച ക്ഷയം നയന്തി, ചൗരാശ്ച സന്ധിം കർത്തയിത്വാ ചോരയിതും ശക്നുവന്തി, താദൃശ്യാം മേദിന്യാം സ്വാർഥം ധനം മാ സംചിനുത| ");
INSERT INTO sanmal_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","കിന്തു യത്ര സ്ഥാനേ കീടാഃ കലങ്കാശ്ച ക്ഷയം ന നയന്തി, ചൗരാശ്ച സന്ധിം കർത്തയിത്വാ ചോരയിതും ന ശക്നുവന്തി, താദൃശേ സ്വർഗേ ധനം സഞ്ചിനുത| ");
INSERT INTO sanmal_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","യസ്മാത് യത്ര സ്ഥാനേ യുഷ്മാംക ധനം തത്രൈവ ഖാനേ യുഷ്മാകം മനാംസി| ");
INSERT INTO sanmal_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","ലോചനം ദേഹസ്യ പ്രദീപകം, തസ്മാത് യദി തവ ലോചനം പ്രസന്നം ഭവതി, തർഹി തവ കൃത്സ്നം വപു ർദീപ്തിയുക്തം ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","കിന്തു ലോചനേഽപ്രസന്നേ തവ കൃത്സ്നം വപുഃ തമിസ്രയുക്തം ഭവിഷ്യതി| അതഏവ യാ ദീപ്തിസ്ത്വയി വിദ്യതേ, സാ യദി തമിസ്രയുക്താ ഭവതി, തർഹി തത് തമിസ്രം കിയൻ മഹത്| ");
INSERT INTO sanmal_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","കോപി മനുജോ ദ്വൗ പ്രഭൂ സേവിതും ന ശക്നോതി, യസ്മാദ് ഏകം സംമന്യ തദന്യം ന സമ്മന്യതേ, യദ്വാ ഏകത്ര മനോ നിധായ തദന്യമ് അവമന്യതേ; തഥാ യൂയമപീശ്വരം ലക്ഷ്മീഞ്ചേത്യുഭേ സേവിതും ന ശക്നുഥ| ");
INSERT INTO sanmal_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","അപരമ് അഹം യുഷ്മഭ്യം തഥ്യം കഥയാമി, കിം ഭക്ഷിഷ്യാമഃ? കിം പാസ്യാമഃ? ഇതി പ്രാണധാരണായ മാ ചിന്തയത; കിം പരിധാസ്യാമഃ? ഇതി കായരക്ഷണായ ന ചിന്തയത; ഭക്ഷ്യാത് പ്രാണാ വസനാഞ്ച വപൂംഷി കിം ശ്രേഷ്ഠാണി ന ഹി? ");
INSERT INTO sanmal_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","വിഹായസോ വിഹങ്ഗമാൻ വിലോകയത; തൈ ർനോപ്യതേ ന കൃത്യതേ ഭാണ്ഡാഗാരേ ന സഞ്ചീയതേഽപി; തഥാപി യുഷ്മാകം സ്വർഗസ്ഥഃ പിതാ തേഭ്യ ആഹാരം വിതരതി| ");
INSERT INTO sanmal_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","യൂയം തേഭ്യഃ കിം ശ്രേഷ്ഠാ ന ഭവഥ? യുഷ്മാകം കശ്ചിത് മനുജഃ ചിന്തയൻ നിജായുഷഃ ക്ഷണമപി വർദ്ധയിതും ശക്നോതി? ");
INSERT INTO sanmal_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","അപരം വസനായ കുതശ്ചിന്തയത? ക്ഷേത്രോത്പന്നാനി പുഷ്പാണി കഥം വർദ്ധന്തേ തദാലോചയത| താനി തന്തൂൻ നോത്പാദയന്തി കിമപി കാര്യ്യം ന കുർവ്വന്തി; ");
INSERT INTO sanmal_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","തഥാപ്യഹം യുഷ്മാൻ വദാമി, സുലേമാൻ താദൃഗ് ഐശ്വര്യ്യവാനപി തത്പുഷ്പമിവ വിഭൂഷിതോ നാസീത്| ");
INSERT INTO sanmal_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","തസ്മാത് ക്ഷദ്യ വിദ്യമാനം ശ്ചഃ ചുല്ല്യാം നിക്ഷേപ്സ്യതേ താദൃശം യത് ക്ഷേത്രസ്ഥിതം കുസുമം തത് യദീശ്ചര ഇത്ഥം ബിഭൂഷയതി, തർഹി ഹേ സ്തോകപ്രത്യയിനോ യുഷ്മാൻ കിം ന പരിധാപയിഷ്യതി? ");
INSERT INTO sanmal_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","തസ്മാത് അസ്മാഭിഃ കിമത്സ്യതേ? കിഞ്ച പായിഷ്യതേ? കിം വാ പരിധായിഷ്യതേ, ഇതി ന ചിന്തയത| ");
INSERT INTO sanmal_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","യസ്മാത് ദേവാർച്ചകാ അപീതി ചേഷ്ടന്തേ; ഏതേഷു ദ്രവ്യേഷു പ്രയോജനമസ്തീതി യുഷ്മാകം സ്വർഗസ്ഥഃ പിതാ ജാനാതി| ");
INSERT INTO sanmal_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","അതഏവ പ്രഥമത ഈശ്വരീയരാജ്യം ധർമ്മഞ്ച ചേഷ്ടധ്വം, തത ഏതാനി വസ്തൂനി യുഷ്മഭ്യം പ്രദായിഷ്യന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","ശ്വഃ കൃതേ മാ ചിന്തയത, ശ്വഏവ സ്വയം സ്വമുദ്ദിശ്യ ചിന്തയിഷ്യതി; അദ്യതനീ യാ ചിന്താ സാദ്യകൃതേ പ്രചുരതരാ| ");
INSERT INTO sanmal_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","യഥാ യൂയം ദോഷീകൃതാ ന ഭവഥ, തത്കൃതേഽന്യം ദോഷിണം മാ കുരുത| ");
INSERT INTO sanmal_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","യതോ യാദൃശേന ദോഷേണ യൂയം പരാൻ ദോഷിണഃ കുരുഥ, താദൃശേന ദോഷേണ യൂയമപി ദോഷീകൃതാ ഭവിഷ്യഥ, അന്യഞ്ച യേന പരിമാണേന യുഷ്മാഭിഃ പരിമീയതേ, തേനൈവ പരിമാണേന യുഷ്മത്കൃതേ പരിമായിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","അപരഞ്ച നിജനയനേ യാ നാസാ വിദ്യതേ, താമ് അനാലോച്യ തവ സഹജസ്യ ലോചനേ യത് തൃണമ് ആസ്തേ, തദേവ കുതോ വീക്ഷസേ? ");
INSERT INTO sanmal_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","തവ നിജലോചനേ നാസായാം വിദ്യമാനായാം, ഹേ ഭ്രാതഃ, തവ നയനാത് തൃണം ബഹിഷ്യർതും അനുജാനീഹി, കഥാമേതാം നിജസഹജായ കഥം കഥയിതും ശക്നോഷി? ");
INSERT INTO sanmal_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ഹേ കപടിൻ, ആദൗ നിജനയനാത് നാസാം ബഹിഷ്കുരു തതോ നിജദൃഷ്ടൗ സുപ്രസന്നായാം തവ ഭ്രാതൃ ർലോചനാത് തൃണം ബഹിഷ്കർതും ശക്ഷ്യസി| ");
INSERT INTO sanmal_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","അന്യഞ്ച സാരമേയേഭ്യഃ പവിത്രവസ്തൂനി മാ വിതരത, വരാഹാണാം സമക്ഷഞ്ച മുക്താ മാ നിക്ഷിപത; നിക്ഷേപണാത് തേ താഃ സർവ്വാഃ പദൈ ർദലയിഷ്യന്തി, പരാവൃത്യ യുഷ്മാനപി വിദാരയിഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","യാചധ്വം തതോ യുഷ്മഭ്യം ദായിഷ്യതേ; മൃഗയധ്വം തത ഉദ്ദേശം ലപ്സ്യധ്വേ; ദ്വാരമ് ആഹത, തതോ യുഷ്മത്കൃതേ മുക്തം ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","യസ്മാദ് യേന യാച്യതേ, തേന ലഭ്യതേ; യേന മൃഗ്യതേ തേനോദ്ദേശഃ പ്രാപ്യതേ; യേന ച ദ്വാരമ് ആഹന്യതേ, തത്കൃതേ ദ്വാരം മോച്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","ആത്മജേന പൂപേ പ്രാർഥിതേ തസ്മൈ പാഷാണം വിശ്രാണയതി, ");
INSERT INTO sanmal_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","മീനേ യാചിതേ ച തസ്മൈ ഭുജഗം വിതരതി, ഏതാദൃശഃ പിതാ യുഷ്മാകം മധ്യേ ക ആസ്തേ? ");
INSERT INTO sanmal_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","തസ്മാദ് യൂയമ് അഭദ്രാഃ സന്തോഽപി യദി നിജബാലകേഭ്യ ഉത്തമം ദ്രവ്യം ദാതും ജാനീഥ, തർഹി യുഷ്മാകം സ്വർഗസ്ഥഃ പിതാ സ്വീയയാചകേഭ്യഃ കിമുത്തമാനി വസ്തൂനി ന ദാസ്യതി? ");
INSERT INTO sanmal_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","യൂഷ്മാൻ പ്രതീതരേഷാം യാദൃശോ വ്യവഹാരോ യുഷ്മാകം പ്രിയഃ, യൂയം താൻ പ്രതി താദൃശാനേവ വ്യവഹാരാൻ വിധത്ത; യസ്മാദ് വ്യവസ്ഥാഭവിഷ്യദ്വാദിനാം വചനാനാമ് ഇതി സാരമ്| ");
INSERT INTO sanmal_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","സങ്കീർണദ്വാരേണ പ്രവിശത; യതോ നരകഗമനായ യദ് ദ്വാരം തദ് വിസ്തീർണം യച്ച വർത്മ തദ് ബൃഹത് തേന ബഹവഃ പ്രവിശന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","അപരം സ്വർഗഗമനായ യദ് ദ്വാരം തത് കീദൃക് സംകീർണം| യച്ച വർത്മ തത് കീദൃഗ് ദുർഗമമ്| തദുദ്ദേഷ്ടാരഃ കിയന്തോഽൽപാഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","അപരഞ്ച യേ ജനാ മേഷവേശേന യുഷ്മാകം സമീപമ് ആഗച്ഛന്തി, കിന്ത്വന്തർദുരന്താ വൃകാ ഏതാദൃശേഭ്യോ ഭവിഷ്യദ്വാദിഭ്യഃ സാവധാനാ ഭവത, യൂയം ഫലേന താൻ പരിചേതും ശക്നുഥ| ");
INSERT INTO sanmal_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","മനുജാഃ കിം കണ്ടകിനോ വൃക്ഷാദ് ദ്രാക്ഷാഫലാനി ശൃഗാലകോലിതശ്ച ഉഡുമ്ബരഫലാനി ശാതയന്തി? ");
INSERT INTO sanmal_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","തദ്വദ് ഉത്തമ ഏവ പാദപ ഉത്തമഫലാനി ജനയതി, അധമപാദപഏവാധമഫലാനി ജനയതി| ");
INSERT INTO sanmal_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","കിന്തൂത്തമപാദപഃ കദാപ്യധമഫലാനി ജനയിതും ന ശക്നോതി, തഥാധമോപി പാദപ ഉത്തമഫലാനി ജനയിതും ന ശക്നോതി| ");
INSERT INTO sanmal_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","അപരം യേ യേ പാദപാ അധമഫലാനി ജനയന്തി, തേ കൃത്താ വഹ്നൗ ക്ഷിപ്യന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","അതഏവ യൂയം ഫലേന താൻ പരിചേഷ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","യേ ജനാ മാം പ്രഭും വദന്തി, തേ സർവ്വേ സ്വർഗരാജ്യം പ്രവേക്ഷ്യന്തി തന്ന, കിന്തു യോ മാനവോ മമ സ്വർഗസ്ഥസ്യ പിതുരിഷ്ടം കർമ്മ കരോതി സ ഏവ പ്രവേക്ഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","തദ് ദിനേ ബഹവോ മാം വദിഷ്യന്തി, ഹേ പ്രഭോ ഹേ പ്രഭോ, തവ നാമ്നാ കിമസ്മാമി ർഭവിഷ്യദ്വാക്യം ന വ്യാഹൃതം? തവ നാമ്നാ ഭൂതാഃ കിം ന ത്യാജിതാഃ? തവ നാമ്നാ കിം നാനാദ്ഭുതാനി കർമ്മാണി ന കൃതാനി? ");
INSERT INTO sanmal_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","തദാഹം വദിഷ്യാമി, ഹേ കുകർമ്മകാരിണോ യുഷ്മാൻ അഹം ന വേദ്മി, യൂയം മത്സമീപാദ് ദൂരീഭവത| ");
INSERT INTO sanmal_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","യഃ കശ്ചിത് മമൈതാഃ കഥാഃ ശ്രുത്വാ പാലയതി, സ പാഷാണോപരി ഗൃഹനിർമ്മാത്രാ ജ്ഞാനിനാ സഹ മയോപമീയതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","യതോ വൃഷ്ടൗ സത്യാമ് ആപ്ലാവ ആഗതേ വായൗ വാതേ ച തേഷു തദ്ഗേഹം ലഗ്നേഷു പാഷാണോപരി തസ്യ ഭിത്തേസ്തന്ന പതതിl ");
INSERT INTO sanmal_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","കിന്തു യഃ കശ്ചിത് മമൈതാഃ കഥാഃ ശ്രുത്വാ ന പാലയതി സ സൈകതേ ഗേഹനിർമ്മാത്രാ ഽജ്ഞാനിനാ ഉപമീയതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","യതോ ജലവൃഷ്ടൗ സത്യാമ് ആപ്ലാവ ആഗതേ പവനേ വാതേ ച തൈ ർഗൃഹേ സമാഘാതേ തത് പതതി തത്പതനം മഹദ് ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","യീശുനൈതേഷു വാക്യേഷു സമാപിതേഷു മാനവാസ്തദീയോപദേശമ് ആശ്ചര്യ്യം മേനിരേ| ");
INSERT INTO sanmal_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","യസ്മാത് സ ഉപാധ്യായാ ഇവ താൻ നോപദിദേശ കിന്തു സമർഥപുരുഷഇവ സമുപദിദേശ| ");
INSERT INTO sanmal_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","യദാ സ പർവ്വതാദ് അവാരോഹത് തദാ ബഹവോ മാനവാസ്തത്പശ്ചാദ് വവ്രജുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ഏകഃ കുഷ്ഠവാൻ ആഗത്യ തം പ്രണമ്യ ബഭാഷേ, ഹേ പ്രഭോ, യദി ഭവാൻ സംമന്യതേ, തർഹി മാം നിരാമയം കർത്തും ശക്നോതി| ");
INSERT INTO sanmal_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","തതോ യീശുഃ കരം പ്രസാര്യ്യ തസ്യാങ്ഗം സ്പൃശൻ വ്യാജഹാര, സമ്മന്യേഽഹം ത്വം നിരാമയോ ഭവ; തേന സ തത്ക്ഷണാത് കുഷ്ഠേനാമോചി| ");
INSERT INTO sanmal_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","തതോ യീശുസ്തം ജഗാദ, അവധേഹി കഥാമേതാം കശ്ചിദപി മാ ബ്രൂഹി, കിന്തു യാജകസ്യ സന്നിധിം ഗത്വാ സ്വാത്മാനം ദർശയ മനുജേഭ്യോ നിജനിരാമയത്വം പ്രമാണയിതും മൂസാനിരൂപിതം ദ്രവ്യമ് ഉത്സൃജ ച| ");
INSERT INTO sanmal_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","തദനന്തരം യീശുനാ കഫർനാഹൂമ്നാമനി നഗരേ പ്രവിഷ്ടേ കശ്ചിത് ശതസേനാപതിസ്തത്സമീപമ് ആഗത്യ വിനീയ ബഭാഷേ, ");
INSERT INTO sanmal_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ഹേ പ്രഭോ, മദീയ ഏകോ ദാസഃ പക്ഷാഘാതവ്യാധിനാ ഭൃശം വ്യഥിതഃ, സതു ശയനീയ ആസ്തേ| ");
INSERT INTO sanmal_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","തദാനീം യീശുസ്തസ്മൈ കഥിതവാൻ, അഹം ഗത്വാ തം നിരാമയം കരിഷ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","തതഃ സ ശതസേനാപതിഃ പ്രത്യവദത്, ഹേ പ്രഭോ, ഭവാൻ യത് മമ ഗേഹമധ്യം യാതി തദ്യോഗ്യഭാജനം നാഹമസ്മി; വാങ്മാത്രമ് ആദിശതു, തേനൈവ മമ ദാസോ നിരാമയോ ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","യതോ മയി പരനിധ്നേഽപി മമ നിദേശവശ്യാഃ കതി കതി സേനാഃ സന്തി, തത ഏകസ്മിൻ യാഹീത്യുക്തേ സ യാതി, തദന്യസ്മിൻ ഏഹീത്യുക്തേ സ ആയാതി, തഥാ മമ നിജദാസേ കർമ്മൈതത് കുർവ്വിത്യുക്തേ സ തത് കരോതി| ");
INSERT INTO sanmal_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","തദാനീം യീശുസ്തസ്യൈതത് വചോ നിശമ്യ വിസ്മയാപന്നോഽഭൂത്; നിജപശ്ചാദ്ഗാമിനോ മാനവാൻ അവോച്ച, യുഷ്മാൻ തഥ്യം വച്മി, ഇസ്രായേലീയലോകാനാം മധ്യേഽപി നൈതാദൃശോ വിശ്വാസോ മയാ പ്രാപ്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","അന്യച്ചാഹം യുഷ്മാൻ വദാമി, ബഹവഃ പൂർവ്വസ്യാഃ പശ്ചിമായാശ്ച ദിശ ആഗത്യ ഇബ്രാഹീമാ ഇസ്ഹാകാ യാകൂബാ ച സാകമ് മിലിത്വാ സമുപവേക്ഷ്യന്തി; ");
INSERT INTO sanmal_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","കിന്തു യത്ര സ്ഥാനേ രോദനദന്തഘർഷണേ ഭവതസ്തസ്മിൻ ബഹിർഭൂതതമിസ്രേ രാജ്യസ്യ സന്താനാ നിക്ഷേസ്യന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","തതഃ പരം യീശുസ്തം ശതസേനാപതിം ജഗാദ, യാഹി, തവ പ്രതീത്യനുസാരതോ മങ്ഗലം ഭൂയാത്; തദാ തസ്മിന്നേവ ദണ്ഡേ തദീയദാസോ നിരാമയോ ബഭൂവ| ");
INSERT INTO sanmal_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","അനന്തരം യീശുഃ പിതരസ്യ ഗേഹമുപസ്ഥായ ജ്വരേണ പീഡിതാം ശയനീയസ്ഥിതാം തസ്യ ശ്വശ്രൂം വീക്ഷാഞ്ചക്രേ| ");
INSERT INTO sanmal_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","തതസ്തേന തസ്യാഃ കരസ്യ സ്പൃഷ്ടതവാത് ജ്വരസ്താം തത്യാജ, തദാ സാ സമുത്ഥായ താൻ സിഷേവേ| ");
INSERT INTO sanmal_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","അനന്തരം സന്ധ്യായാം സത്യാം ബഹുശോ ഭൂതഗ്രസ്തമനുജാൻ തസ്യ സമീപമ് ആനിന്യുഃ സ ച വാക്യേന ഭൂതാൻ ത്യാജയാമാസ, സർവ്വപ്രകാരപീഡിതജനാംശ്ച നിരാമയാൻ ചകാര; ");
INSERT INTO sanmal_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","തസ്മാത്, സർവ്വാ ദുർബ്ബലതാസ്മാകം തേനൈവ പരിധാരിതാ| അസ്മാകം സകലം വ്യാധിം സഏവ സംഗൃഹീതവാൻ| യദേതദ്വചനം യിശയിയഭവിഷ്യദ്വാദിനോക്തമാസീത്, തത്തദാ സഫലമഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","അനന്തരം യീശുശ്ചതുർദിക്ഷു ജനനിവഹം വിലോക്യ തടിന്യാഃ പാരം യാതും ശിഷ്യാൻ ആദിദേശ| ");
INSERT INTO sanmal_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","തദാനീമ് ഏക ഉപാധ്യായ ആഗത്യ കഥിതവാൻ, ഹേ ഗുരോ, ഭവാൻ യത്ര യാസ്യതി തത്രാഹമപി ഭവതഃ പശ്ചാദ് യാസ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","തതോ യീശു ർജഗാദ, ക്രോഷ്ടുഃ സ്ഥാതും സ്ഥാനം വിദ്യതേ, വിഹായസോ വിഹങ്ഗമാനാം നീഡാനി ച സന്തി; കിന്തു മനുഷ്യപുത്രസ്യ ശിരഃ സ്ഥാപയിതും സ്ഥാനം ന വിദ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","അനന്തരമ് അപര ഏകഃ ശിഷ്യസ്തം ബഭാഷേ, ഹേ പ്രഭോ, പ്രഥമതോ മമ പിതരം ശ്മശാനേ നിധാതും ഗമനാർഥം മാമ് അനുമന്യസ്വ| ");
INSERT INTO sanmal_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","തതോ യീശുരുക്തവാൻ മൃതാ മൃതാൻ ശ്മശാനേ നിദധതു, ത്വം മമ പശ്ചാദ് ആഗച്ഛ| ");
INSERT INTO sanmal_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","അനന്തരം തസ്മിൻ നാവമാരൂഢേ തസ്യ ശിഷ്യാസ്തത്പശ്ചാത് ജഗ്മുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","പശ്ചാത് സാഗരസ്യ മധ്യം തേഷു ഗതേഷു താദൃശഃ പ്രബലോ ഝഞ്ഭ്ശനില ഉദതിഷ്ഠത്, യേന മഹാതരങ്ഗ ഉത്ഥായ തരണിം ഛാദിതവാൻ, കിന്തു സ നിദ്രിത ആസീത്| ");
INSERT INTO sanmal_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","തദാ ശിഷ്യാ ആഗത്യ തസ്യ നിദ്രാഭങ്ഗം കൃത്വാ കഥയാമാസുഃ, ഹേ പ്രഭോ, വയം മ്രിയാമഹേ, ഭവാൻ അസ്മാകം പ്രാണാൻ രക്ഷതു| ");
INSERT INTO sanmal_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","തദാ സ താൻ ഉക്തവാൻ, ഹേ അൽപവിശ്വാസിനോ യൂയം കുതോ വിഭീഥ? തതഃ സ ഉത്ഥായ വാതം സാഗരഞ്ച തർജയാമാസ, തതോ നിർവ്വാതമഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","അപരം മനുജാ വിസ്മയം വിലോക്യ കഥയാമാസുഃ, അഹോ വാതസരിത്പതീ അസ്യ കിമാജ്ഞാഗ്രാഹിണൗ? കീദൃശോഽയം മാനവഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","അനന്തരം സ പാരം ഗത്വാ ഗിദേരീയദേശമ് ഉപസ്ഥിതവാൻ; തദാ ദ്വൗ ഭൂതഗ്രസ്തമനുജൗ ശ്മശാനസ്ഥാനാദ് ബഹി ർഭൂത്വാ തം സാക്ഷാത് കൃതവന്തൗ, താവേതാദൃശൗ പ്രചണ്ഡാവാസ്താം യത് തേന സ്ഥാനേന കോപി യാതും നാശക്നോത്| ");
INSERT INTO sanmal_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","താവുചൈഃ കഥയാമാസതുഃ, ഹേ ഈശ്വരസ്യ സൂനോ യീശോ, ത്വയാ സാകമ് ആവയോഃ കഃ സമ്ബന്ധഃ? നിരൂപിതകാലാത് പ്രാഗേവ കിമാവാഭ്യാം യാതനാം ദാതുമ് അത്രാഗതോസി? ");
INSERT INTO sanmal_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","തദാനീം താഭ്യാം കിഞ്ചിദ് ദൂരേ വരാഹാണാമ് ഏകോ മഹാവ്രജോഽചരത്| ");
INSERT INTO sanmal_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","തതോ ഭൂതൗ തൗ തസ്യാന്തികേ വിനീയ കഥയാമാസതുഃ, യദ്യാവാം ത്യാജയസി, തർഹി വരാഹാണാം മധ്യേവ്രജമ് ആവാം പ്രേരയ| ");
INSERT INTO sanmal_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","തദാ യീശുരവദത് യാതം, അനന്തരം തൗ യദാ മനുജൗ വിഹായ വരാഹാൻ ആശ്രിതവന്തൗ, തദാ തേ സർവ്വേ വരാഹാ ഉച്ചസ്ഥാനാത് മഹാജവേന ധാവന്തഃ സാഗരീയതോയേ മജ്ജന്തോ മമ്രുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","തതോ വരാഹരക്ഷകാഃ പലായമാനാ മധ്യേനഗരം തൗ ഭൂതഗ്രസ്തൗ പ്രതി യദ്യദ് അഘടത, താഃ സർവ്വവാർത്താ അവദൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","തതോ നാഗരികാഃ സർവ്വേ മനുജാ യീശും സാക്ഷാത് കർത്തും ബഹിരായാതാഃ തഞ്ച വിലോക്യ പ്രാർഥയാഞ്ചക്രിരേ ഭവാൻ അസ്മാകം സീമാതോ യാതു| ");
INSERT INTO sanmal_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","അനന്തരം യീശു ർനൗകാമാരുഹ്യ പുനഃ പാരമാഗത്യ നിജഗ്രാമമ് ആയയൗ| ");
INSERT INTO sanmal_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","തതഃ കതിപയാ ജനാ ഏകം പക്ഷാഘാതിനം സ്വട്ടോപരി ശായയിത്വാ തത്സമീപമ് ആനയൻ; തതോ യീശുസ്തേഷാം പ്രതീതിം വിജ്ഞായ തം പക്ഷാഘാതിനം ജഗാദ, ഹേ പുത്ര, സുസ്ഥിരോ ഭവ, തവ കലുഷസ്യ മർഷണം ജാതമ്| ");
INSERT INTO sanmal_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","താം കഥാം നിശമ്യ കിയന്ത ഉപാധ്യായാ മനഃസു ചിന്തിതവന്ത ഏഷ മനുജ ഈശ്വരം നിന്ദതി| ");
INSERT INTO sanmal_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","തതഃ സ തേഷാമ് ഏതാദൃശീം ചിന്താം വിജ്ഞായ കഥിതവാൻ, യൂയം മനഃസു കൃത ഏതാദൃശീം കുചിന്താം കുരുഥ? ");
INSERT INTO sanmal_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","തവ പാപമർഷണം ജാതം, യദ്വാ ത്വമുത്ഥായ ഗച്ഛ, ദ്വയോരനയോ ർവാക്യയോഃ കിം വാക്യം വക്തും സുഗമം? ");
INSERT INTO sanmal_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","കിന്തു മേദിന്യാം കലുഷം ക്ഷമിതും മനുജസുതസ്യ സാമർഥ്യമസ്തീതി യൂയം യഥാ ജാനീഥ, തദർഥം സ തം പക്ഷാഘാതിനം ഗദിതവാൻ, ഉത്തിഷ്ഠ, നിജശയനീയം ആദായ ഗേഹം ഗച്ഛ| ");
INSERT INTO sanmal_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","തതഃ സ തത്ക്ഷണാദ് ഉത്ഥായ നിജഗേഹം പ്രസ്ഥിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","മാനവാ ഇത്ഥം വിലോക്യ വിസ്മയം മേനിരേ, ഈശ്വരേണ മാനവായ സാമർഥ്യമ് ഈദൃശം ദത്തം ഇതി കാരണാത് തം ധന്യം ബഭാഷിരേ ച| ");
INSERT INTO sanmal_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","അനന്തരം യീശുസ്തത്സ്ഥാനാദ് ഗച്ഛൻ ഗച്ഛൻ കരസംഗ്രഹസ്ഥാനേ സമുപവിഷ്ടം മഥിനാമാനമ് ഏകം മനുജം വിലോക്യ തം ബഭാഷേ, മമ പശ്ചാദ് ആഗച്ഛ, തതഃ സ ഉത്ഥായ തസ്യ പശ്ചാദ് വവ്രാജ| ");
INSERT INTO sanmal_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","തതഃ പരം യീശൗ ഗൃഹേ ഭോക്തുമ് ഉപവിഷ്ടേ ബഹവഃ കരസംഗ്രാഹിണഃ കലുഷിണശ്ച മാനവാ ആഗത്യ തേന സാകം തസ്യ ശിഷ്യൈശ്ച സാകമ് ഉപവിവിശുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ഫിരൂശിനസ്തദ് ദൃഷ്ട്വാ തസ്യ ശിഷ്യാൻ ബഭാഷിരേ, യുഷ്മാകം ഗുരുഃ കിം നിമിത്തം കരസംഗ്രാഹിഭിഃ കലുഷിഭിശ്ച സാകം ഭുംക്തേ? ");
INSERT INTO sanmal_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","യീശുസ്തത് ശ്രുത്വാ താൻ പ്രത്യവദത്, നിരാമയലോകാനാം ചികിത്സകേന പ്രയോജനം നാസ്തി, കിന്തു സാമയലോകാനാം പ്രയോജനമാസ്തേ| ");
INSERT INTO sanmal_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","അതോ യൂയം യാത്വാ വചനസ്യാസ്യാർഥം ശിക്ഷധ്വമ്, ദയായാം മേ യഥാ പ്രീതി ർന തഥാ യജ്ഞകർമ്മണി| യതോഽഹം ധാർമ്മികാൻ ആഹ്വാതും നാഗതോഽസ്മി കിന്തു മനഃ പരിവർത്തയിതും പാപിന ആഹ്വാതുമ് ആഗതോഽസ്മി| ");
INSERT INTO sanmal_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","അനന്തരം യോഹനഃ ശിഷ്യാസ്തസ്യ സമീപമ് ആഗത്യ കഥയാമാസുഃ, ഫിരൂശിനോ വയഞ്ച പുനഃ പുനരുപവസാമഃ, കിന്തു തവ ശിഷ്യാ നോപവസന്തി, കുതഃ? ");
INSERT INTO sanmal_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","തദാ യീശുസ്താൻ അവോചത് യാവത് സഖീനാം സംങ്ഗേ കന്യായാ വരസ്തിഷ്ഠതി, താവത് കിം തേ വിലാപം കർത്തും ശക്ലുവന്തി? കിന്തു യദാ തേഷാം സംങ്ഗാദ് വരം നയന്തി, താദൃശഃ സമയ ആഗമിഷ്യതി, തദാ തേ ഉപവത്സ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","പുരാതനവസനേ കോപി നവീനവസ്ത്രം ന യോജയതി, യസ്മാത് തേന യോജിതേന പുരാതനവസനം ഛിനത്തി തച്ഛിദ്രഞ്ച ബഹുകുത്സിതം ദൃശ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","അന്യഞ്ച പുരാതനകുത്വാം കോപി നവാനഗോസ്തനീരസം ന നിദധാതി, യസ്മാത് തഥാ കൃതേ കുതൂ ർവിദീര്യ്യതേ തേന ഗോസ്തനീരസഃ പതതി കുതൂശ്ച നശ്യതി; തസ്മാത് നവീനായാം കുത്വാം നവീനോ ഗോസ്തനീരസഃ സ്ഥാപ്യതേ, തേന ദ്വയോരവനം ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","അപരം തേനൈതത്കഥാകഥനകാലേ ഏകോഽധിപതിസ്തം പ്രണമ്യ ബഭാഷേ, മമ ദുഹിതാ പ്രായേണൈതാവത്കാലേ മൃതാ, തസ്മാദ് ഭവാനാഗത്യ തസ്യാ ഗാത്രേ ഹസ്തമർപയതു, തേന സാ ജീവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","തദാനീം യീശുഃ ശിഷ്യൈഃ സാകമ് ഉത്ഥായ തസ്യ പശ്ചാദ് വവ്രാജ| ");
INSERT INTO sanmal_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ഇത്യനന്തരേ ദ്വാദശവത്സരാൻ യാവത് പ്രദരാമയേന ശീർണൈകാ നാരീ തസ്യ പശ്ചാദ് ആഗത്യ തസ്യ വസനസ്യ ഗ്രന്ഥിം പസ്പർശ; ");
INSERT INTO sanmal_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","യസ്മാത് മയാ കേവലം തസ്യ വസനം സ്പൃഷ്ട്വാ സ്വാസ്ഥ്യം പ്രാപ്സ്യതേ, സാ നാരീതി മനസി നിശ്ചിതവതീ| ");
INSERT INTO sanmal_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","തതോ യീശുർവദനം പരാവർത്ത്യ താം ജഗാദ, ഹേ കന്യേ, ത്വം സുസ്ഥിരാ ഭവ, തവ വിശ്വാസസ്ത്വാം സ്വസ്ഥാമകാർഷീത്| ഏതദ്വാക്യേ ഗദിതഏവ സാ യോഷിത് സ്വസ്ഥാഭൂത്| ");
INSERT INTO sanmal_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","അപരം യീശുസ്തസ്യാധ്യക്ഷസ്യ ഗേഹം ഗത്വാ വാദകപ്രഭൃതീൻ ബഹൂൻ ലോകാൻ ശബ്ദായമാനാൻ വിലോക്യ താൻ അവദത്, ");
INSERT INTO sanmal_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","പന്ഥാനം ത്യജ, കന്യേയം നാമ്രിയത നിദ്രിതാസ്തേ; കഥാമേതാം ശ്രുത്വാ തേ തമുപജഹസുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","കിന്തു സർവ്വേഷു ബഹിഷ്കൃതേഷു സോഽഭ്യന്തരം ഗത്വാ കന്യായാഃ കരം ധൃതവാൻ, തേന സോദതിഷ്ഠത്; ");
INSERT INTO sanmal_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","തതസ്തത്കർമ്മണോ യശഃ കൃത്സ്നം തം ദേശം വ്യാപ്തവത്| ");
INSERT INTO sanmal_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","തതഃ പരം യീശുസ്തസ്മാത് സ്ഥാനാദ് യാത്രാം ചകാര; തദാ ഹേ ദായൂദഃ സന്താന, അസ്മാൻ ദയസ്വ, ഇതി വദന്തൗ ദ്വൗ ജനാവന്ധൗ പ്രോചൈരാഹൂയന്തൗ തത്പശ്ചാദ് വവ്രജതുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","തതോ യീശൗ ഗേഹമധ്യം പ്രവിഷ്ടം താവപി തസ്യ സമീപമ് ഉപസ്ഥിതവന്തൗ, തദാനീം സ തൗ പൃഷ്ടവാൻ കർമ്മൈതത് കർത്തും മമ സാമർഥ്യമ് ആസ്തേ, യുവാം കിമിതി പ്രതീഥഃ? തദാ തൗ പ്രത്യൂചതുഃ, സത്യം പ്രഭോ| ");
INSERT INTO sanmal_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","തദാനീം സ തയോ ർലോചനാനി സ്പൃശൻ ബഭാഷേ, യുവയോഃ പ്രതീത്യനുസാരാദ് യുവയോ ർമങ്ഗലം ഭൂയാത്| തേന തത്ക്ഷണാത് തയോ ർനേത്രാണി പ്രസന്നാന്യഭവൻ, ");
INSERT INTO sanmal_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","പശ്ചാദ് യീശുസ്തൗ ദൃഢമാജ്ഞാപ്യ ജഗാദ, അവധത്തമ് ഏതാം കഥാം കോപി മനുജോ മ ജാനീയാത്| ");
INSERT INTO sanmal_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","കിന്തു തൗ പ്രസ്ഥായ തസ്മിൻ കൃത്സ്നേ ദേശേ തസ്യ കീർത്തിം പ്രകാശയാമാസതുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","അപരം തൗ ബഹിര്യാത ഏതസ്മിന്നന്തരേ മനുജാ ഏകം ഭൂതഗ്രസ്തമൂകം തസ്യ സമീപമ് ആനീതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","തേന ഭൂതേ ത്യാജിതേ സ മൂകഃ കഥാം കഥയിതും പ്രാരഭത, തേന ജനാ വിസ്മയം വിജ്ഞായ കഥയാമാസുഃ, ഇസ്രായേലോ വംശേ കദാപി നേദൃഗദൃശ്യത; ");
INSERT INTO sanmal_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","കിന്തു ഫിരൂശിനഃ കഥയാഞ്ചക്രുഃ ഭൂതാധിപതിനാ സ ഭൂതാൻ ത്യാജയതി| ");
INSERT INTO sanmal_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","തതഃ പരം യീശുസ്തേഷാം ഭജനഭവന ഉപദിശൻ രാജ്യസ്യ സുസംവാദം പ്രചാരയൻ ലോകാനാം യസ്യ യ ആമയോ യാ ച പീഡാസീത്, താൻ ശമയൻ ശമയംശ്ച സർവ്വാണി നഗരാണി ഗ്രാമാംശ്ച ബഭ്രാമ| ");
INSERT INTO sanmal_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","അന്യഞ്ച മനുജാൻ വ്യാകുലാൻ അരക്ഷകമേഷാനിവ ച ത്യക്താൻ നിരീക്ഷ്യ തേഷു കാരുണികഃ സൻ ശിഷ്യാൻ അവദത്, ");
INSERT INTO sanmal_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ശസ്യാനി പ്രചുരാണി സന്തി, കിന്തു ഛേത്താരഃ സ്തോകാഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ക്ഷേത്രം പ്രത്യപരാൻ ഛേദകാൻ പ്രഹേതും ശസ്യസ്വാമിനം പ്രാർഥയധ്വമ്| ");
INSERT INTO sanmal_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","അനന്തരം യീശു ർദ്വാദശശിഷ്യാൻ ആഹൂയാമേധ്യഭൂതാൻ ത്യാജയിതും സർവ്വപ്രകാരരോഗാൻ പീഡാശ്ച ശമയിതും തേഭ്യഃ സാമർഥ്യമദാത്| ");
INSERT INTO sanmal_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","തേഷാം ദ്വാദശപ്രേഷ്യാണാം നാമാന്യേതാനി| പ്രഥമം ശിമോൻ യം പിതരം വദന്തി, തതഃ പരം തസ്യ സഹജ ആന്ദ്രിയഃ, സിവദിയസ്യ പുത്രോ യാകൂബ് ");
INSERT INTO sanmal_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","തസ്യ സഹജോ യോഹൻ; ഫിലിപ് ബർഥലമയ് ഥോമാഃ കരസംഗ്രാഹീ മഥിഃ, ആൽഫേയപുത്രോ യാകൂബ്, ");
INSERT INTO sanmal_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","കിനാനീയഃ ശിമോൻ, യ ഈഷ്കരിയോതീയയിഹൂദാഃ ഖ്രീഷ്ടം പരകരേഽർപയത്| ");
INSERT INTO sanmal_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ഏതാൻ ദ്വാദശശിഷ്യാൻ യീശുഃ പ്രേഷയൻ ഇത്യാജ്ഞാപയത്, യൂയമ് അന്യദേശീയാനാം പദവീം ശേമിരോണീയാനാം കിമപി നഗരഞ്ച ന പ്രവിശ്യേ ");
INSERT INTO sanmal_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ഇസ്രായേൽഗോത്രസ്യ ഹാരിതാ യേ യേ മേഷാസ്തേഷാമേവ സമീപം യാത| ");
INSERT INTO sanmal_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","ഗത്വാ ഗത്വാ സ്വർഗസ്യ രാജത്വം സവിധമഭവത്, ഏതാം കഥാം പ്രചാരയത| ");
INSERT INTO sanmal_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ആമയഗ്രസ്താൻ സ്വസ്ഥാൻ കുരുത, കുഷ്ഠിനഃ പരിഷ്കുരുത, മൃതലോകാൻ ജീവയത, ഭൂതാൻ ത്യാജയത, വിനാ മൂല്യം യൂയമ് അലഭധ്വം വിനൈവ മൂല്യം വിശ്രാണയത| ");
INSERT INTO sanmal_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","കിന്തു സ്വേഷാം കടിബന്ധേഷു സ്വർണരൂപ്യതാമ്രാണാം കിമപി ന ഗൃഹ്ലീത| ");
INSERT INTO sanmal_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","അന്യച്ച യാത്രായൈ ചേലസമ്പുടം വാ ദ്വിതീയവസനം വാ പാദുകേ വാ യഷ്ടിഃ, ഏതാൻ മാ ഗൃഹ്ലീത, യതഃ കാര്യ്യകൃത് ഭർത്തും യോഗ്യോ ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","അപരം യൂയം യത് പുരം യഞ്ച ഗ്രാമം പ്രവിശഥ, തത്ര യോ ജനോ യോഗ്യപാത്രം തമവഗത്യ യാനകാലം യാവത് തത്ര തിഷ്ഠത| ");
INSERT INTO sanmal_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","യദാ യൂയം തദ്ഗേഹം പ്രവിശഥ, തദാ തമാശിഷം വദത| ");
INSERT INTO sanmal_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","യദി സ യോഗ്യപാത്രം ഭവതി, തർഹി തത്കല്യാണം തസ്മൈ ഭവിഷ്യതി, നോചേത് സാശീര്യുഷ്മഭ്യമേവ ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","കിന്തു യേ ജനാ യുഷ്മാകമാതിഥ്യം ന വിദധതി യുഷ്മാകം കഥാഞ്ച ന ശൃണ്വന്തി തേഷാം ഗേഹാത് പുരാദ്വാ പ്രസ്ഥാനകാലേ സ്വപദൂലീഃ പാതയത| ");
INSERT INTO sanmal_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","യുഷ്മാനഹം തഥ്യം വച്മി വിചാരദിനേ തത്പുരസ്യ ദശാതഃ സിദോമമോരാപുരയോർദശാ സഹ്യതരാ ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","പശ്യത, വൃകയൂഥമധ്യേ മേഷഃ യഥാവിസ്തഥാ യുഷ്മാന പ്രഹിണോമി, തസ്മാദ് യൂയമ് അഹിരിവ സതർകാഃ കപോതാഇവാഹിംസകാ ഭവത| ");
INSERT INTO sanmal_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","നൃഭ്യഃ സാവധാനാ ഭവത; യതസ്തൈ ര്യൂയം രാജസംസദി സമർപിഷ്യധ്വേ തേഷാം ഭജനഗേഹേ പ്രഹാരിഷ്യധ്വേ| ");
INSERT INTO sanmal_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","യൂയം മന്നാമഹേതോഃ ശാസ്തൃണാം രാജ്ഞാഞ്ച സമക്ഷം താനന്യദേശിനശ്ചാധി സാക്ഷിത്വാർഥമാനേഷ്യധ്വേ| ");
INSERT INTO sanmal_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","കിന്ത്വിത്ഥം സമർപിതാ യൂയം കഥം കിമുത്തരം വക്ഷ്യഥ തത്ര മാ ചിന്തയത, യതസ്തദാ യുഷ്മാഭി ര്യദ് വക്തവ്യം തത് തദ്ദണ്ഡേ യുഷ്മന്മനഃ സു സമുപസ്ഥാസ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","യസ്മാത് തദാ യോ വക്ഷ്യതി സ ന യൂയം കിന്തു യുഷ്മാകമന്തരസ്ഥഃ പിത്രാത്മാ| ");
INSERT INTO sanmal_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","സഹജഃ സഹജം താതഃ സുതഞ്ച മൃതൗ സമർപയിഷ്യതി, അപത്യാഗി സ്വസ്വപിത്രോे ർവിപക്ഷീഭൂയ തൗ ഘാതയിഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","മന്നമഹേതോഃ സർവ്വേ ജനാ യുഷ്മാൻ ഋृതീയിഷ്യന്തേ, കിന്തു യഃ ശേഷം യാവദ് ധൈര്യ്യം ഘൃത്വാ സ്ഥാസ്യതി, സ ത്രായിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","തൈ ര്യദാ യൂയമേകപുരേ താഡിഷ്യധ്വേ, തദാ യൂയമന്യപുരം പലായധ്വം യുഷ്മാനഹം തഥ്യം വച്മി യാവന്മനുജസുതോ നൈതി താവദ് ഇസ്രായേൽദേശീയസർവ്വനഗരഭ്രമണം സമാപയിതും ന ശക്ഷ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","ഗുരോഃ ശിഷ്യോ ന മഹാൻ, പ്രഭോർദാസോ ന മഹാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","യദി ശിഷ്യോ നിജഗുരോ ർദാസശ്ച സ്വപ്രഭോഃ സമാനോ ഭവതി തർഹി തദ് യഥേഷ്ടം| ചേത്തൈർഗൃഹപതിർഭൂതരാജ ഉച്യതേ, തർഹി പരിവാരാഃ കിം തഥാ ന വക്ഷ്യന്തേ? ");
INSERT INTO sanmal_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","കിന്തു തേഭ്യോ യൂയം മാ ബിഭീത, യതോ യന്ന പ്രകാശിഷ്യതേ, താദൃക് ഛാദിതം കിമപി നാസ്തി, യച്ച ന വ്യഞ്ചിഷ്യതേ, താദൃഗ് ഗുപ്തം കിമപി നാസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","യദഹം യുഷ്മാൻ തമസി വച്മി തദ് യുഷ്മാഭിർദീപ്തൗ കഥ്യതാം; കർണാഭ്യാം യത് ശ്രൂയതേ തദ് ഗേഹോപരി പ്രചാര്യ്യതാം| ");
INSERT INTO sanmal_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","യേ കായം ഹന്തും ശക്നുവന്തി നാത്മാനം, തേഭ്യോ മാ ഭൈഷ്ട; യഃ കായാത്മാനൗ നിരയേ നാശയിതും, ശക്നോതി, തതോ ബിഭീത| ");
INSERT INTO sanmal_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ദ്വൗ ചടകൗ കിമേകതാമ്രമുദ്രയാ ന വിക്രീയേതേ? തഥാപി യുഷ്മത്താതാനുമതിം വിനാ തേഷാമേകോപി ഭുവി ന പതതി| ");
INSERT INTO sanmal_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","യുഷ്മച്ഛിരസാം സർവ്വകചാ ഗണിതാംഃ സന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","അതോ മാ ബിഭീത, യൂയം ബഹുചടകേഭ്യോ ബഹുമൂല്യാഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","യോ മനുജസാക്ഷാന്മാമങ്ഗീകുരുതേ തമഹം സ്വർഗസ്ഥതാതസാക്ഷാദങ്ഗീകരിഷ്യേ| ");
INSERT INTO sanmal_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","പൃഥ്വ്യാമഹം ശാന്തിം ദാതുമാഗതഇതി മാനുഭവത, ശാന്തിം ദാതും ന കിന്ത്വസിം| ");
INSERT INTO sanmal_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","പിതൃമാതൃശ്ചശ്രൂഭിഃ സാകം സുതസുതാബധൂ ർവിരോധയിതുഞ്ചാഗതേाസ്മി| ");
INSERT INTO sanmal_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","തതഃ സ്വസ്വപരിവാരഏവ നൃശത്രു ർഭവിതാ| ");
INSERT INTO sanmal_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","യഃ പിതരി മാതരി വാ മത്തോധികം പ്രീയതേ, സ ന മദർഹഃ; ");
INSERT INTO sanmal_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","യശ്ച സുതേ സുതായാം വാ മത്തോധികം പ്രീയതേ, സേाപി ന മദർഹഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","യഃ സ്വക്രുശം ഗൃഹ്ലൻ മത്പശ്ചാന്നൈതി, സേाപി ന മദർഹഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","യഃ സ്വപ്രാണാനവതി, സ താൻ ഹാരയിഷ്യതേ, യസ്തു മത്കൃതേ സ്വപ്രാണാൻ ഹാരയതി, സ താനവതി| ");
INSERT INTO sanmal_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","യോ യുഷ്മാകമാതിഥ്യം വിദധാതി, സ മമാതിഥ്യം വിദധാതി, യശ്ച മമാതിഥ്യം വിദധാതി, സ മത്പ്രേരകസ്യാതിഥ്യം വിദധാതി| ");
INSERT INTO sanmal_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","യോ ഭവിഷ്യദ്വാദീതി ജ്ഞാത്വാ തസ്യാതിഥ്യം വിധത്തേ, സ ഭവിഷ്യദ്വാദിനഃ ഫലം ലപ്സ്യതേ, യശ്ച ധാർമ്മിക ഇതി വിദിത്വാ തസ്യാതിഥ്യം വിധത്തേ സ ധാർമ്മികമാനവസ്യ ഫലം പ്രാപ്സ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","യശ്ച കശ്ചിത് ഏതേഷാം ക്ഷുദ്രനരാണാമ് യം കഞ്ചനൈകം ശിഷ്യ ഇതി വിദിത്വാ കംസൈകം ശീതലസലിലം തസ്മൈ ദത്തേ, യുഷ്മാനഹം തഥ്യം വദാമി, സ കേനാപി പ്രകാരേണ ഫലേന ന വഞ്ചിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ഇത്ഥം യീശുഃ സ്വദ്വാദശശിഷ്യാണാമാജ്ഞാപനം സമാപ്യ പുരേ പുര ഉപദേഷ്ടും സുസംവാദം പ്രചാരയിതും തത്സ്ഥാനാത് പ്രതസ്ഥേ| ");
INSERT INTO sanmal_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","അനന്തരം യോഹൻ കാരായാം തിഷ്ഠൻ ഖ്രിഷ്ടസ്യ കർമ്മണാം വാർത്തം പ്രാപ്യ യസ്യാഗമനവാർത്താസീത് സഏവ കിം ത്വം? വാ വയമന്യമ് അപേക്ഷിഷ്യാമഹേ? ");
INSERT INTO sanmal_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ഏതത് പ്രഷ്ടും നിജൗ ദ്വൗ ശിഷ്യൗ പ്രാഹിണോത്| ");
INSERT INTO sanmal_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","യീശുഃ പ്രത്യവോചത്, അന്ധാ നേത്രാണി ലഭന്തേ, ഖഞ്ചാ ഗച്ഛന്തി, കുഷ്ഠിനഃ സ്വസ്ഥാ ഭവന്തി, ബധിരാഃ ശൃണ്വന്തി, മൃതാ ജീവന്ത ഉത്തിഷ്ഠന്തി, ദരിദ്രാണാം സമീപേ സുസംവാദഃ പ്രചാര്യ്യത, ");
INSERT INTO sanmal_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ഏതാനി യദ്യദ് യുവാം ശൃണുഥഃ പശ്യഥശ്ച ഗത്വാ തദ്വാർത്താം യോഹനം ഗദതം| ");
INSERT INTO sanmal_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","യസ്യാഹം ന വിഘ്നീഭവാമി, സഏവ ധന്യഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","അനന്തരം തയോഃ പ്രസ്ഥിതയോ ര്യീശു ര്യോഹനമ് ഉദ്ദിശ്യ ജനാൻ ജഗാദ, യൂയം കിം ദ്രഷ്ടും വഹിർമധ്യേപ്രാന്തരമ് അഗച്ഛത? കിം വാതേന കമ്പിതം നലം? ");
INSERT INTO sanmal_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","വാ കിം വീക്ഷിതും വഹിർഗതവന്തഃ? കിം പരിഹിതസൂക്ഷ്മവസനം മനുജമേകം? പശ്യത, യേ സൂക്ഷ്മവസനാനി പരിദധതി, തേ രാജധാന്യാം തിഷ്ഠന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","തർഹി യൂയം കിം ദ്രഷ്ടും ബഹിരഗമത, കിമേകം ഭവിഷ്യദ്വാദിനം? തദേവ സത്യം| യുഷ്മാനഹം വദാമി, സ ഭവിഷ്യദ്വാദിനോപി മഹാൻ; ");
INSERT INTO sanmal_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","യതഃ, പശ്യ സ്വകീയദൂതോയം ത്വദഗ്രേ പ്രേഷ്യതേ മയാ| സ ഗത്വാ തവ പന്ഥാനം സ്മയക് പരിഷ്കരിഷ്യതി|| ഏതദ്വചനം യമധി ലിഖിതമാസ്തേ സോഽയം യോഹൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","അപരം യുഷ്മാനഹം തഥ്യം ബ്രവീമി, മജ്ജയിതു ര്യോഹനഃ ശ്രേഷ്ഠഃ കോപി നാരീതോ നാജായത; തഥാപി സ്വർഗരാജ്യമധ്യേ സർവ്വേഭ്യോ യഃ ക്ഷുദ്രഃ സ യോഹനഃ ശ്രേഷ്ഠഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","അപരഞ്ച ആ യോഹനോഽദ്യ യാവത് സ്വർഗരാജ്യം ബലാദാക്രാന്തം ഭവതി ആക്രമിനശ്ച ജനാ ബലേന തദധികുർവ്വന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","യതോ യോഹനം യാവത് സർവ്വഭവിഷ്യദ്വാദിഭി ർവ്യവസ്ഥയാ ച ഉപദേശഃ പ്രാകാശ്യത| ");
INSERT INTO sanmal_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","യദി യൂയമിദം വാക്യം ഗ്രഹീതും ശക്നുഥ, തർഹി ശ്രേയഃ, യസ്യാഗമനസ്യ വചനമാസ്തേ സോഽയമ് ഏലിയഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","യസ്യ ശ്രോതും കർണൗ സ്തഃ സ ശൃണോതു| ");
INSERT INTO sanmal_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","ഏതേ വിദ്യമാനജനാഃ കൈ ർമയോപമീയന്തേ? യേ ബാലകാ ഹട്ട ഉപവിശ്യ സ്വം സ്വം ബന്ധുമാഹൂയ വദന്തി, ");
INSERT INTO sanmal_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","വയം യുഷ്മാകം സമീപേ വംശീരവാദയാമ, കിന്തു യൂയം നാനൃത്യത; യുഷ്മാകം സമീപേ ച വയമരോദിമ, കിന്തു യൂയം ന വ്യലപത, താദൃശൈ ർബാലകൈസ്ത ഉപമായിഷ്യന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","യതോ യോഹൻ ആഗത്യ ന ഭുക്തവാൻ ന പീതവാംശ്ച, തേന ലോകാ വദന്തി, സ ഭൂതഗ്രസ്ത ഇതി| ");
INSERT INTO sanmal_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","മനുജസുത ആഗത്യ ഭുക്തവാൻ പീതവാംശ്ച, തേന ലോകാ വദന്തി, പശ്യത ഏഷ ഭോക്താ മദ്യപാതാ ചണ്ഡാലപാപിനാം ബന്ധശ്ച, കിന്തു ജ്ഞാനിനോ ജ്ഞാനവ്യവഹാരം നിർദോഷം ജാനന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","സ യത്ര യത്ര പുരേ ബഹ്വാശ്ചര്യ്യം കർമ്മ കൃതവാൻ, തന്നിവാസിനാം മനഃപരാവൃത്ത്യഭാവാത് താനി നഗരാണി പ്രതി ഹന്തേത്യുക്താ കഥിതവാൻ, ");
INSERT INTO sanmal_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","ഹാ കോരാസീൻ, ഹാ ബൈത്സൈദേ, യുഷ്മന്മധ്യേ യദ്യദാശ്ചര്യ്യം കർമ്മ കൃതം യദി തത് സോരസീദോന്നഗര അകാരിഷ്യത, തർഹി പൂർവ്വമേവ തന്നിവാസിനഃ ശാണവസനേ ഭസ്മനി ചോപവിശന്തോ മനാംസി പരാവർത്തിഷ്യന്ത| ");
INSERT INTO sanmal_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","തസ്മാദഹം യുഷ്മാൻ വദാമി, വിചാരദിനേ യുഷ്മാകം ദശാതഃ സോരസീദോനോ ർദശാ സഹ്യതരാ ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","അപരഞ്ച ബത കഫർനാഹൂമ്, ത്വം സ്വർഗം യാവദുന്നതോസി, കിന്തു നരകേ നിക്ഷേപ്സ്യസേ, യസ്മാത് ത്വയി യാന്യാശ്ചര്യ്യാണി കർമ്മണ്യകാരിഷത, യദി താനി സിദോമ്നഗര അകാരിഷ്യന്ത, തർഹി തദദ്യ യാവദസ്ഥാസ്യത്| ");
INSERT INTO sanmal_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","കിന്ത്വഹം യുഷ്മാൻ വദാമി, വിചാരദിനേ തവ ദണ്ഡതഃ സിദോമോ ദണ്ഡോ സഹ്യതരോ ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ഏതസ്മിന്നേവ സമയേ യീശുഃ പുനരുവാച, ഹേ സ്വർഗപൃഥിവ്യോരേകാധിപതേ പിതസ്ത്വം ജ്ഞാനവതോ വിദുഷശ്ച ലോകാൻ പ്രത്യേതാനി ന പ്രകാശ്യ ബാലകാൻ പ്രതി പ്രകാശിതവാൻ, ഇതി ഹേതോസ്ത്വാം ധന്യം വദാമി| ");
INSERT INTO sanmal_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ഹേ പിതഃ, ഇത്ഥം ഭവേത് യത ഇദം ത്വദൃഷ്ടാവുത്തമം| ");
INSERT INTO sanmal_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","പിത്രാ മയി സർവ്വാണി സമർപിതാനി, പിതരം വിനാ കോപി പുത്രം ന ജാനാതി, യാൻ പ്രതി പുത്രേണ പിതാ പ്രകാശ്യതേ താൻ വിനാ പുത്രാദ് അന്യഃ കോപി പിതരം ന ജാനാതി| ");
INSERT INTO sanmal_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","ഹേ പരിശ്രാന്താ ഭാരാക്രാന്താശ്ച ലോകാ യൂയം മത്സന്നിധിമ് ആഗച്ഛത, അഹം യുഷ്മാൻ വിശ്രമയിഷ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","അഹം ക്ഷമണശീലോ നമ്രമനാശ്ച, തസ്മാത് മമ യുഗം സ്വേഷാമുപരി ധാരയത മത്തഃ ശിക്ഷധ്വഞ്ച, തേന യൂയം സ്വേ സ്വേ മനസി വിശ്രാമം ലപ്സ്യധ്ബേ| ");
INSERT INTO sanmal_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","യതോ മമ യുഗമ് അനായാസം മമ ഭാരശ്ച ലഘുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","അനന്തരം യീശു ർവിശ്രാമവാരേ ശ്സ്യമധ്യേന ഗച്ഛതി, തദാ തച്ഛിഷ്യാ ബുഭുക്ഷിതാഃ സന്തഃ ശ്സ്യമഞ്ജരീശ്ഛത്വാ ഛിത്വാ ഖാദിതുമാരഭന്ത| ");
INSERT INTO sanmal_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","തദ് വിലോക്യ ഫിരൂശിനോ യീശും ജഗദുഃ, പശ്യ വിശ്രാമവാരേ യത് കർമ്മാകർത്തവ്യം തദേവ തവ ശിഷ്യാഃ കുർവ്വന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","സ താൻ പ്രത്യാവദത, ദായൂദ് തത്സങ്ഗിനശ്ച ബുഭുക്ഷിതാഃ സന്തോ യത് കർമ്മാകുർവ്വൻ തത് കിം യുഷ്മാഭി ർനാപാഠി? ");
INSERT INTO sanmal_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","യേ ദർശനീയാഃ പൂപാഃ യാജകാൻ വിനാ തസ്യ തത്സങ്ഗിമനുജാനാഞ്ചാഭോജനീയാസ്ത ഈശ്വരാവാസം പ്രവിഷ്ടേന തേന ഭുക്താഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","അന്യച്ച വിശ്രാമവാരേ മധ്യേമന്ദിരം വിശ്രാമവാരീയം നിയമം ലങ്വന്തോപി യാജകാ നിർദോഷാ ഭവന്തി, ശാസ്ത്രമധ്യേ കിമിദമപി യുഷ്മാഭി ർന പഠിതം? ");
INSERT INTO sanmal_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","യുഷ്മാനഹം വദാമി, അത്ര സ്ഥാനേ മന്ദിരാദപി ഗരീയാൻ ഏക ആസ്തേ| ");
INSERT INTO sanmal_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","കിന്തു ദയായാം മേ യഥാ പ്രീതി ർന തഥാ യജ്ഞകർമ്മണി| ഏതദ്വചനസ്യാർഥം യദി യുയമ് അജ്ഞാസിഷ്ട തർഹി നിർദോഷാൻ ദോഷിണോ നാകാർഷ്ട| ");
INSERT INTO sanmal_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","അന്യച്ച മനുജസുതോ വിശ്രാമവാരസ്യാപി പതിരാസ്തേ| ");
INSERT INTO sanmal_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","അനന്തരം സ തത്സ്ഥാനാത് പ്രസ്ഥായ തേഷാം ഭജനഭവനം പ്രവിഷ്ടവാൻ, തദാനീമ് ഏകഃ ശുഷ്കകരാമയവാൻ ഉപസ്ഥിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","തതോ യീശുമ് അപവദിതും മാനുഷാഃ പപ്രച്ഛുഃ, വിശ്രാമവാരേ നിരാമയത്വം കരണീയം ന വാ? ");
INSERT INTO sanmal_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","തേന സ പ്രത്യുവാച, വിശ്രാമവാരേ യദി കസ്യചിദ് അവി ർഗർത്തേ പതതി, തർഹി യസ്തം ഘൃത്വാ ന തോലയതി, ഏതാദൃശോ മനുജോ യുഷ്മാകം മധ്യേ ക ആസ്തേ? ");
INSERT INTO sanmal_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","അവേ ർമാനവഃ കിം നഹി ശ്രേയാൻ? അതോ വിശ്രാമവാരേ ഹിതകർമ്മ കർത്തവ്യം| ");
INSERT INTO sanmal_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","അനന്തരം സ തം മാനവം ഗദിതവാൻ, കരം പ്രസാരയ; തേന കരേ പ്രസാരിതേ സോന്യകരവത് സ്വസ്ഥോഽഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","തദാ ഫിരൂശിനോ ബഹിർഭൂയ കഥം തം ഹനിഷ്യാമ ഇതി കുമന്ത്രണാം തത്പ്രാതികൂല്യേന ചക്രുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","തതോ യീശുസ്തദ് വിദിത്വാ സ്ഥനാന്തരം ഗതവാൻ; അന്യേഷു ബഹുനരേഷു തത്പശ്ചാദ് ഗതേഷു താൻ സ നിരാമയാൻ കൃത്വാ ഇത്യാജ്ഞാപയത്, ");
INSERT INTO sanmal_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","യൂയം മാം ന പരിചായയത| ");
INSERT INTO sanmal_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","തസ്മാത് മമ പ്രീയോ മനോനീതോ മനസസ്തുഷ്ടികാരകഃ| മദീയഃ സേവകോ യസ്തു വിദ്യതേ തം സമീക്ഷതാം| തസ്യോപരി സ്വകീയാത്മാ മയാ സംസ്ഥാപയിഷ്യതേ| തേനാന്യദേശജാതേഷു വ്യവസ്ഥാ സംപ്രകാശ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","കേനാപി ന വിരോധം സ വിവാദഞ്ച കരിഷ്യതി| ന ച രാജപഥേ തേന വചനം ശ്രാവയിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","വ്യവസ്ഥാ ചലിതാ യാവത് നഹി തേന കരിഷ്യതേ| താവത് നലോ വിദീർണോഽപി ഭംക്ഷ്യതേ നഹി തേന ച| തഥാ സധൂമവർത്തിഞ്ച ന സ നിർവ്വാപയിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","പ്രത്യാശാഞ്ച കരിഷ്യന്തി തന്നാമ്നി ഭിന്നദേശജാഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","യാന്യേതാനി വചനാനി യിശയിയഭവിഷ്യദ്വാദിനാ പ്രോക്താന്യാസൻ, താനി സഫലാന്യഭവൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","അനന്തരം ലോകൈ സ്തത്സമീപമ് ആനീതോ ഭൂതഗ്രസ്താന്ധമൂകൈകമനുജസ്തേന സ്വസ്ഥീകൃതഃ, തതഃ സോഽന്ധോ മൂകോ ദ്രഷ്ടും വക്തുഞ്ചാരബ്ധവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","അനേന സർവ്വേ വിസ്മിതാഃ കഥയാഞ്ചക്രുഃ, ഏഷഃ കിം ദായൂദഃ സന്താനോ നഹി? ");
INSERT INTO sanmal_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","കിന്തു ഫിരൂശിനസ്തത് ശ്രുത്വാ ഗദിതവന്തഃ, ബാൽസിബൂബ്നാമ്നോ ഭൂതരാജസ്യ സാഹായ്യം വിനാ നായം ഭൂതാൻ ത്യാജയതി| ");
INSERT INTO sanmal_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","തദാനീം യീശുസ്തേഷാമ് ഇതി മാനസം വിജ്ഞായ താൻ അവദത് കിഞ്ചന രാജ്യം യദി സ്വവിപക്ഷാദ് ഭിദ്യതേ, തർഹി തത് ഉച്ഛിദ്യതേ; യച്ച കിഞ്ചന നഗരം വാ ഗൃഹം സ്വവിപക്ഷാദ് വിഭിദ്യതേ, തത് സ്ഥാതും ന ശക്നോതി| ");
INSERT INTO sanmal_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","തദ്വത് ശയതാനോ യദി ശയതാനം ബഹിഃ കൃത്വാ സ്വവിപക്ഷാത് പൃഥക് പൃഥക് ഭവതി, തർഹി തസ്യ രാജ്യം കേന പ്രകാരേണ സ്ഥാസ്യതി? ");
INSERT INTO sanmal_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","അഹഞ്ച യദി ബാൽസിബൂബാ ഭൂതാൻ ത്യാജയാമി, തർഹി യുഷ്മാകം സന്താനാഃ കേന ഭൂതാൻ ത്യാജയന്തി? തസ്മാദ് യുഷ്മാകമ് ഏതദ്വിചാരയിതാരസ്ത ഏവ ഭവിഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","കിന്തവഹം യദീശ്വരാത്മനാ ഭൂതാൻ ത്യാജയാമി, തർഹീശ്വരസ്യ രാജ്യം യുഷ്മാകം സന്നിധിമാഗതവത്| ");
INSERT INTO sanmal_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","അന്യഞ്ച കോപി ബലവന്ത ജനം പ്രഥമതോ ന ബദ്വ്വാ കേന പ്രകാരേണ തസ്യ ഗൃഹം പ്രവിശ്യ തദ്ദ്രവ്യാദി ലോഠയിതും ശക്നോതി? കിന്തു തത് കൃത്വാ തദീയഗൃസ്യ ദ്രവ്യാദി ലോഠയിതും ശക്നോതി| ");
INSERT INTO sanmal_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","യഃ കശ്ചിത് മമ സ്വപക്ഷീയോ നഹി സ വിപക്ഷീയ ആസ്തേ, യശ്ച മയാ സാകം ന സംഗൃഹ്ലാതി, സ വികിരതി| ");
INSERT INTO sanmal_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","അതഏവ യുഷ്മാനഹം വദാമി, മനുജാനാം സർവ്വപ്രകാരപാപാനാം നിന്ദായാശ്ച മർഷണം ഭവിതും ശക്നോതി, കിന്തു പവിത്രസ്യാത്മനോ വിരുദ്ധനിന്ദായാ മർഷണം ഭവിതും ന ശക്നോതി| ");
INSERT INTO sanmal_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","യോ മനുജസുതസ്യ വിരുദ്ധാം കഥാം കഥയതി, തസ്യാപരാധസ്യ ക്ഷമാ ഭവിതും ശക്നോതി, കിന്തു യഃ കശ്ചിത് പവിത്രസ്യാത്മനോ വിരുദ്ധാം കഥാം കഥയതി നേഹലോകേ ന പ്രേത്യ തസ്യാപരാധസ്യ ക്ഷമാ ഭവിതും ശക്നോതി| ");
INSERT INTO sanmal_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","പാദപം യദി ഭദ്രം വദഥ, തർഹി തസ്യ ഫലമപി സാധു വക്തവ്യം, യദി ച പാദപം അസാധും വദഥ, തർഹി തസ്യ ഫലമപ്യസാധു വക്തവ്യം; യതഃ സ്വീയസ്വീയഫലേന പാദപഃ പരിചീയതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","രേ ഭുജഗവംശാ യൂയമസാധവഃ സന്തഃ കഥം സാധു വാക്യം വക്തും ശക്ഷ്യഥ? യസ്മാദ് അന്തഃകരണസ്യ പൂർണഭാവാനുസാരാദ് വദനാദ് വചോ നിർഗച്ഛതി| ");
INSERT INTO sanmal_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","തേന സാധുർമാനവോഽന്തഃകരണരൂപാത് സാധുഭാണ്ഡാഗാരാത് സാധു ദ്രവ്യം നിർഗമയതി, അസാധുർമാനുഷസ്ത്വസാധുഭാണ്ഡാഗാരാദ് അസാധുവസ്തൂനി നിർഗമയതി| ");
INSERT INTO sanmal_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","കിന്ത്വഹം യുഷ്മാൻ വദാമി, മനുജാ യാവന്ത്യാലസ്യവചാംസി വദന്തി, വിചാരദിനേ തദുത്തരമവശ്യം ദാതവ്യം, ");
INSERT INTO sanmal_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","യതസ്ത്വം സ്വീയവചോഭി ർനിരപരാധഃ സ്വീയവചോഭിശ്ച സാപരാധോ ഗണിഷ്യസേ| ");
INSERT INTO sanmal_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","തദാനീം കതിപയാ ഉപാധ്യായാഃ ഫിരൂശിനശ്ച ജഗദുഃ, ഹേ ഗുരോ വയം ഭവത്തഃ കിഞ്ചന ലക്ഷ്മ ദിദൃക്ഷാമഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","തദാ സ പ്രത്യുക്തവാൻ, ദുഷ്ടോ വ്യഭിചാരീ ച വംശോ ലക്ഷ്മ മൃഗയതേ, കിന്തു ഭവിഷ്യദ്വാദിനോ യൂനസോ ലക്ഷ്മ വിഹായാന്യത് കിമപി ലക്ഷ്മ തേ ന പ്രദർശയിഷ്യന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","യതോ യൂനമ് യഥാ ത്ര്യഹോരാത്രം ബൃഹന്മീനസ്യ കുക്ഷാവാസീത്, തഥാ മനുജപുത്രോപി ത്ര്യഹോരാത്രം മേദിന്യാ മധ്യേ സ്ഥാസ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","അപരം നീനിവീയാ മാനവാ വിചാരദിന ഏതദ്വംശീയാനാം പ്രതികൂലമ് ഉത്ഥായ താൻ ദോഷിണഃ കരിഷ്യന്തി, യസ്മാത്തേ യൂനസ ഉപദേശാത് മനാംസി പരാവർത്തയാഞ്ചക്രിരേ, കിന്ത്വത്ര യൂനസോപി ഗുരുതര ഏക ആസ്തേ| ");
INSERT INTO sanmal_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","പുനശ്ച ദക്ഷിണദേശീയാ രാജ്ഞീ വിചാരദിന ഏതദ്വംശീയാനാം പ്രതികൂലമുത്ഥായ താൻ ദോഷിണഃ കരിഷ്യതി യതഃ സാ രാജ്ഞീ സുലേമനോ വിദ്യായാഃ കഥാം ശ്രോതും മേദിന്യാഃ സീമ്ന ആഗച്ഛത്, കിന്തു സുലേമനോപി ഗുരുതര ഏകോ ജനോഽത്ര ആസ്തേ| ");
INSERT INTO sanmal_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","അപരം മനുജാദ് ബഹിർഗതോ ഽപവിത്രഭൂതഃ ശുഷ്കസ്ഥാനേന ഗത്വാ വിശ്രാമം ഗവേഷയതി, കിന്തു തദലഭമാനഃ സ വക്തി, യസ്മാ; നികേതനാദ് ആഗമം, തദേവ വേശ്മ പകാവൃത്യ യാമി| ");
INSERT INTO sanmal_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","പശ്ചാത് സ തത് സ്ഥാനമ് ഉപസ്ഥായ തത് ശൂന്യം മാർജ്ജിതം ശോഭിതഞ്ച വിലോക്യ വ്രജൻ സ്വതോപി ദുഷ്ടതരാൻ അന്യസപ്തഭൂതാൻ സങ്ഗിനഃ കരോതി| ");
INSERT INTO sanmal_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","തതസ്തേ തത് സ്ഥാനം പ്രവിശ്യ നിവസന്തി, തേന തസ്യ മനുജസ്യ ശേഷദശാ പൂർവ്വദശാതോതീവാശുഭാ ഭവതി, ഏതേഷാം ദുഷ്ടവംശ്യാനാമപി തഥൈവ ഘടിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","മാനവേഭ്യ ഏതാസാം കഥനാം കഥനകാലേ തസ്യ മാതാ സഹജാശ്ച തേന സാകം കാഞ്ചിത് കഥാം കഥയിതും വാഞ്ഛന്തോ ബഹിരേവ സ്ഥിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","തതഃ കശ്ചിത് തസ്മൈ കഥിതവാൻ, പശ്യ തവ ജനനീ സഹജാശ്ച ത്വയാ സാകം കാഞ്ചന കഥാം കഥയിതും കാമയമാനാ ബഹിസ്തിഷ്ഠന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","കിന്തു സ തം പ്രത്യവദത്, മമ കാ ജനനീ? കേ വാ മമ സഹജാഃ? ");
INSERT INTO sanmal_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","പശ്ചാത് ശിഷ്യാൻ പ്രതി കരം പ്രസാര്യ്യ കഥിതവാൻ, പശ്യ മമ ജനനീ മമ സഹജാശ്ചൈതേ; ");
INSERT INTO sanmal_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","യഃ കശ്ചിത് മമ സ്വർഗസ്ഥസ്യ പിതുരിഷ്ടം കർമ്മ കുരുതേ, സഏവ മമ ഭ്രാതാ ഭഗിനീ ജനനീ ച| ");
INSERT INTO sanmal_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","അപരഞ്ച തസ്മിൻ ദിനേ യീശുഃ സദ്മനോ ഗത്വാ സരിത്പതേ രോധസി സമുപവിവേശ| ");
INSERT INTO sanmal_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","തത്ര തത്സന്നിധൗ ബഹുജനാനാം നിവഹോപസ്ഥിതേഃ സ തരണിമാരുഹ്യ സമുപാവിശത്, തേന മാനവാ രോധസി സ്ഥിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","തദാനീം സ ദൃഷ്ടാന്തൈസ്താൻ ഇത്ഥം ബഹുശ ഉപദിഷ്ടവാൻ| പശ്യത, കശ്ചിത് കൃഷീവലോ ബീജാനി വപ്തും ബഹിർജഗാമ, ");
INSERT INTO sanmal_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","തസ്യ വപനകാലേ കതിപയബീജേഷു മാർഗപാർശ്വേ പതിതേഷു വിഹഗാസ്താനി ഭക്ഷിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","അപരം കതിപയബീജേഷു സ്തോകമൃദ്യുക്തപാഷാണേ പതിതേഷു മൃദൽപത്വാത് തത്ക്ഷണാത് താന്യങ്കുരിതാനി, ");
INSERT INTO sanmal_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","കിന്തു രവാവുദിതേ ദഗ്ധാനി തേഷാം മൂലാപ്രവിഷ്ടത്വാത് ശുഷ്കതാം ഗതാനി ച| ");
INSERT INTO sanmal_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","അപരം കതിപയബീജേഷു കണ്ടകാനാം മധ്യേ പതിതേഷു കണ്ടകാന്യേധിത്വാ താനി ജഗ്രസുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","അപരഞ്ച കതിപയബീജാനി ഉർവ്വരായാം പതിതാനി; തേഷാം മധ്യേ കാനിചിത് ശതഗുണാനി കാനിചിത് ഷഷ്ടിഗുണാനി കാനിചിത് ത്രിംശഗുംണാനി ഫലാനി ഫലിതവന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ശ്രോതും യസ്യ ശ്രുതീ ആസാതേ സ ശൃണുയാത്| ");
INSERT INTO sanmal_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","അനന്തരം ശിഷ്യൈരാഗത്യ സോഽപൃച്ഛ്യത, ഭവതാ തേഭ്യഃ കുതോ ദൃഷ്ടാന്തകഥാ കഥ്യതേ? ");
INSERT INTO sanmal_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","തതഃ സ പ്രത്യവദത്, സ്വർഗരാജ്യസ്യ നിഗൂഢാം കഥാം വേദിതും യുഷ്മഭ്യം സാമർഥ്യമദായി, കിന്തു തേഭ്യോ നാദായി| ");
INSERT INTO sanmal_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","യസ്മാദ് യസ്യാന്തികേ വർദ്ധതേ, തസ്മായേവ ദായിഷ്യതേ, തസ്മാത് തസ്യ ബാഹുല്യം ഭവിഷ്യതി, കിന്തു യസ്യാന്തികേ ന വർദ്ധതേ, തസ്യ യത് കിഞ്ചനാസ്തേ, തദപി തസ്മാദ് ആദായിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","തേ പശ്യന്തോപി ന പശ്യന്തി, ശൃണ്വന്തോപി ന ശൃണ്വന്തി, ബുധ്യമാനാ അപി ന ബുധ്യന്തേ ച, തസ്മാത് തേഭ്യോ ദൃഷ്ടാന്തകഥാ കഥ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","യഥാ കർണൈഃ ശ്രോഷ്യഥ യൂയം വൈ കിന്തു യൂയം ന ഭോത്സ്യഥ| നേത്രൈർദ്രക്ഷ്യഥ യൂയഞ്ച പരിജ്ഞാതും ന ശക്ഷ്യഥ| തേ മാനുഷാ യഥാ നൈവ പരിപശ്യന്തി ലോചനൈഃ| കർണൈ ര്യഥാ ന ശൃണ്വന്തി ന ബുധ്യന്തേ ച മാനസൈഃ| വ്യാവർത്തിതേഷു ചിത്തേഷു കാലേ കുത്രാപി തൈർജനൈഃ| മത്തസ്തേ മനുജാഃ സ്വസ്ഥാ യഥാ നൈവ ഭവന്തി ച| തഥാ തേഷാം മനുഷ്യാണാം ക്രിയന്തേ സ്ഥൂലബുദ്ധയഃ| ബധിരീഭൂതകർണാശ്ച ജാതാശ്ച മുദ്രിതാ ദൃശഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","യദേതാനി വചനാനി യിശയിയഭവിഷ്യദ്വാദിനാ പ്രോക്താനി തേഷു താനി ഫലന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","കിന്തു യുഷ്മാകം നയനാനി ധന്യാനി, യസ്മാത് താനി വീക്ഷന്തേ; ധന്യാശ്ച യുഷ്മാകം ശബ്ദഗ്രഹാഃ, യസ്മാത് തൈരാകർണ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","മയാ യൂയം തഥ്യം വചാമി യുഷ്മാഭി ര്യദ്യദ് വീക്ഷ്യതേ, തദ് ബഹവോ ഭവിഷ്യദ്വാദിനോ ധാർമ്മികാശ്ച മാനവാ ദിദൃക്ഷന്തോപി ദ്രഷ്ടും നാലഭന്ത, പുനശ്ച യൂയം യദ്യത് ശൃണുഥ, തത് തേ ശുശ്രൂഷമാണാ അപി ശ്രോതും നാലഭന്ത| ");
INSERT INTO sanmal_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","കൃഷീവലീയദൃഷ്ടാന്തസ്യാർഥം ശൃണുത| ");
INSERT INTO sanmal_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","മാർഗപാർശ്വേ ബീജാന്യുപ്താനി തസ്യാർഥ ഏഷഃ, യദാ കശ്ചിത് രാജ്യസ്യ കഥാം നിശമ്യ ന ബുധ്യതേ, തദാ പാപാത്മാഗത്യ തദീയമനസ ഉപ്താം കഥാം ഹരൻ നയതി| ");
INSERT INTO sanmal_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","അപരം പാഷാണസ്ഥലേ ബീജാന്യുപ്താനി തസ്യാർഥ ഏഷഃ; കശ്ചിത് കഥാം ശ്രുത്വൈവ ഹർഷചിത്തേന ഗൃഹ്ലാതി, ");
INSERT INTO sanmal_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","കിന്തു തസ്യ മനസി മൂലാപ്രവിഷ്ടത്വാത് സ കിഞ്ചിത്കാലമാത്രം സ്ഥിരസ്തിഷ്ഠതി; പശ്ചാത തത്കഥാകാരണാത് കോപി ക്ലേസ്താഡനാ വാ ചേത് ജായതേ, തർഹി സ തത്ക്ഷണാദ് വിഘ്നമേതി| ");
INSERT INTO sanmal_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","അപരം കണ്ടകാനാം മധ്യേ ബീജാന്യുപ്താനി തദർഥ ഏഷഃ; കേനചിത് കഥായാം ശ്രുതായാം സാംസാരികചിന്താഭി ർഭ്രാന്തിഭിശ്ച സാ ഗ്രസ്യതേ, തേന സാ മാ വിഫലാ ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","അപരമ് ഉർവ്വരായാം ബീജാന്യുപ്താനി തദർഥ ഏഷഃ; യേ താം കഥാം ശ്രുത്വാ വുധ്യന്തേ, തേ ഫലിതാഃ സന്തഃ കേചിത് ശതഗുണാനി കേചിത ഷഷ്ടിഗുണാനി കേചിച്ച ത്രിംശദ്ഗുണാനി ഫലാനി ജനയന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","അനന്തരം സോപരാമേകാം ദൃഷ്ടാന്തകഥാമുപസ്ഥാപ്യ തേഭ്യഃ കഥയാമാസ; സ്വർഗീയരാജ്യം താദൃശേന കേനചിദ് ഗൃഹസ്ഥേനോപമീയതേ, യേന സ്വീയക്ഷേത്രേ പ്രശസ്തബീജാന്യൗപ്യന്ത| ");
INSERT INTO sanmal_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","കിന്തു ക്ഷണദായാം സകലലോകേഷു സുപ്തേഷു തസ്യ രിപുരാഗത്യ തേഷാം ഗോധൂമബീജാനാം മധ്യേ വന്യയവമബീജാന്യുപ്ത്വാ വവ്രാജ| ");
INSERT INTO sanmal_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","തതോ യദാ ബീജേഭ്യോഽങ്കരാ ജായമാനാഃ കണിശാനി ഘൃതവന്തഃ; തദാ വന്യയവസാന്യപി ദൃശ്യമാനാന്യഭവൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","തതോ ഗൃഹസ്ഥസ്യ ദാസേയാ ആഗമ്യ തസ്മൈ കഥയാഞ്ചക്രുഃ, ഹേ മഹേച്ഛ, ഭവതാ കിം ക്ഷേത്രേ ഭദ്രബീജാനി നൗപ്യന്ത? തഥാത്വേ വന്യയവസാനി കൃത ആയൻ? ");
INSERT INTO sanmal_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","തദാനീം തേന തേ പ്രതിഗദിതാഃ, കേനചിത് രിപുണാ കർമ്മദമകാരി| ദാസേയാഃ കഥയാമാസുഃ, വയം ഗത്വാ താന്യുത്പായ്യ ക്ഷിപാമോ ഭവതഃ കീദൃശീച്ഛാ ജായതേ? ");
INSERT INTO sanmal_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","തേനാവാദി, നഹി, ശങ്കേഽഹം വന്യയവസോത്പാടനകാലേ യുഷ്മാഭിസ്തൈഃ സാകം ഗോധൂമാ അപ്യുത്പാടിഷ്യന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","അതഃ ശ്സ്യകർത്തനകാലം യാവദ് ഉഭയാന്യപി സഹ വർദ്ധന്താം, പശ്ചാത് കർത്തനകാലേ കർത്തകാൻ വക്ഷ്യാമി, യൂയമാദൗ വന്യയവസാനി സംഗൃഹ്യ ദാഹയിതും വീടികാ ബദ്വ്വാ സ്ഥാപയത; കിന്തു സർവ്വേ ഗോധൂമാ യുഷ്മാഭി ർഭാണ്ഡാഗാരം നീത്വാ സ്ഥാപ്യന്താമ്| ");
INSERT INTO sanmal_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","അനന്തരം സോപരാമേകാം ദൃഷ്ടാന്തകഥാമുത്ഥാപ്യ തേഭ്യഃ കഥിതവാൻ കശ്ചിന്മനുജഃ സർഷപബീജമേകം നീത്വാ സ്വക്ഷേത്ര ഉവാപ| ");
INSERT INTO sanmal_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","സർഷപബീജം സർവ്വസ്മാദ് ബീജാത് ക്ഷുദ്രമപി സദങ്കുരിതം സർവ്വസ്മാത് ശാകാത് ബൃഹദ് ഭവതി; സ താദൃശസ്തരു ർഭവതി, യസ്യ ശാഖാസു നഭസഃ ഖഗാ ആഗത്യ നിവസന്തി; സ്വർഗീയരാജ്യം താദൃശസ്യ സർഷപൈകസ്യ സമമ്| ");
INSERT INTO sanmal_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","പുനരപി സ ഉപമാകഥാമേകാം തേഭ്യഃ കഥയാഞ്ചകാര; കാചന യോഷിത് യത് കിണ്വമാദായ ദ്രോണത്രയമിതഗോധൂമചൂർണാനാം മധ്യേ സർവ്വേഷാം മിശ്രീഭവനപര്യ്യന്തം സമാച്ഛാദ്യ നിധത്തവതീ, തത്കിണ്വമിവ സ്വർഗരാജ്യം| ");
INSERT INTO sanmal_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ഇത്ഥം യീശു ർമനുജനിവഹാനാം സന്നിധാവുപമാകഥാഭിരേതാന്യാഖ്യാനാനി കഥിതവാൻ ഉപമാം വിനാ തേഭ്യഃ കിമപി കഥാം നാകഥയത്| ");
INSERT INTO sanmal_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ഏതേന ദൃഷ്ടാന്തീയേന വാക്യേന വ്യാദായ വദനം നിജം| അഹം പ്രകാശയിഷ്യാമി ഗുപ്തവാക്യം പുരാഭവം| യദേതദ്വചനം ഭവിഷ്യദ്വാദിനാ പ്രോക്തമാസീത്, തത് സിദ്ധമഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","സർവ്വാൻ മനുജാൻ വിസൃജ്യ യീശൗ ഗൃഹം പ്രവിഷ്ടേ തച്ഛിഷ്യാ ആഗത്യ യീശവേ കഥിതവന്തഃ, ക്ഷേത്രസ്യ വന്യയവസീയദൃഷ്ടാന്തകഥാമ് ഭവാന അസ്മാൻ സ്പഷ്ടീകൃത്യ വദതു| ");
INSERT INTO sanmal_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","തതഃ സ പ്രത്യുവാച, യേന ഭദ്രബീജാന്യുപ്യന്തേ സ മനുജപുത്രഃ, ");
INSERT INTO sanmal_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ക്ഷേത്രം ജഗത്, ഭദ്രബീജാനീ രാജ്യസ്യ സന്താനാഃ, ");
INSERT INTO sanmal_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","വന്യയവസാനി പാപാത്മനഃ സന്താനാഃ| യേന രിപുണാ താന്യുപ്താനി സ ശയതാനഃ, കർത്തനസമയശ്ച ജഗതഃ ശേഷഃ, കർത്തകാഃ സ്വർഗീയദൂതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","യഥാ വന്യയവസാനി സംഗൃഹ്യ ദാഹ്യന്തേ, തഥാ ജഗതഃ ശേഷേ ഭവിഷ്യതി; ");
INSERT INTO sanmal_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","അർഥാത് മനുജസുതഃ സ്വാംയദൂതാൻ പ്രേഷയിഷ്യതി, തേന തേ ച തസ്യ രാജ്യാത് സർവ്വാൻ വിഘ്നകാരിണോഽധാർമ്മികലോകാംശ്ച സംഗൃഹ്യ ");
INSERT INTO sanmal_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","യത്ര രോദനം ദന്തഘർഷണഞ്ച ഭവതി, തത്രാഗ്നികുണ്ഡേ നിക്ഷേപ്സ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","തദാനീം ധാർമ്മികലോകാഃ സ്വേഷാം പിതൂ രാജ്യേ ഭാസ്കരഇവ തേജസ്വിനോ ഭവിഷ്യന്തി| ശ്രോതും യസ്യ ശ്രുതീ ആസാതേ, മ ശൃണുയാത്| ");
INSERT INTO sanmal_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","അപരഞ്ച ക്ഷേത്രമധ്യേ നിധിം പശ്യൻ യോ ഗോപയതി, തതഃ പരം സാനന്ദോ ഗത്വാ സ്വീയസർവ്വസ്വം വിക്രീയ ത്തക്ഷേത്രം ക്രീണാതി, സ ഇവ സ്വർഗരാജ്യം| ");
INSERT INTO sanmal_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","അന്യഞ്ച യോ വണിക് ഉത്തമാം മുക്താം ഗവേഷയൻ ");
INSERT INTO sanmal_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","മഹാർഘാം മുക്താം വിലോക്യ നിജസർവ്വസ്വം വിക്രീയ താം ക്രീണാതി, സ ഇവ സ്വർഗരാജ്യം| ");
INSERT INTO sanmal_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","പുനശ്ച സമുദ്രോ നിക്ഷിപ്തഃ സർവ്വപ്രകാരമീനസംഗ്രാഹ്യാനായഇവ സ്വർഗരാജ്യം| ");
INSERT INTO sanmal_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","തസ്മിൻ ആനായേ പൂർണേ ജനാ യഥാ രോധസ്യുത്തോല്യ സമുപവിശ്യ പ്രശസ്തമീനാൻ സംഗ്രഹ്യ ഭാജനേഷു നിദധതേ, കുത്സിതാൻ നിക്ഷിപന്തി; ");
INSERT INTO sanmal_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","തഥൈവ ജഗതഃ ശേഷേ ഭവിഷ്യതി, ഫലതഃ സ്വർഗീയദൂതാ ആഗത്യ പുണ്യവജ്ജനാനാം മധ്യാത് പാപിനഃ പൃഥക് കൃത്വാ വഹ്നികുണ്ഡേ നിക്ഷേപ്സ്യന്തി, ");
INSERT INTO sanmal_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","തത്ര രോദനം ദന്തൈ ർദന്തഘർഷണഞ്ച ഭവിഷ്യതഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","യീശുനാ തേ പൃഷ്ടാ യുഷ്മാഭിഃ കിമേതാന്യാഖ്യാനാന്യബുധ്യന്ത? തദാ തേ പ്രത്യവദൻ, സത്യം പ്രഭോ| ");
INSERT INTO sanmal_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","തദാനീം സ കഥിതവാൻ, നിജഭാണ്ഡാഗാരാത് നവീനപുരാതനാനി വസ്തൂനി നിർഗമയതി യോ ഗൃഹസ്ഥഃ സ ഇവ സ്വർഗരാജ്യമധി ശിക്ഷിതാഃ സ്വർവ ഉപദേഷ്ടാരഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","അനന്തരം യീശുരേതാഃ സർവ്വാ ദൃഷ്ടാന്തകഥാഃ സമാപ്യ തസ്മാത് സ്ഥാനാത് പ്രതസ്ഥേ| അപരം സ്വദേശമാഗത്യ ജനാൻ ഭജനഭവന ഉപദിഷ്ടവാൻ; ");
INSERT INTO sanmal_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","തേ വിസ്മയം ഗത്വാ കഥിതവന്ത ഏതസ്യൈതാദൃശം ജ്ഞാനമ് ആശ്ചര്യ്യം കർമ്മ ച കസ്മാദ് അജായത? ");
INSERT INTO sanmal_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","കിമയം സൂത്രധാരസ്യ പുത്രോ നഹി? ഏതസ്യ മാതു ർനാമ ച കിം മരിയമ് നഹി? യാകുബ്-യൂഷഫ്-ശിമോൻ-യിഹൂദാശ്ച കിമേതസ്യ ഭ്രാതരോ നഹി? ");
INSERT INTO sanmal_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ഏതസ്യ ഭഗിന്യശ്ച കിമസ്മാകം മധ്യേ ന സന്തി? തർഹി കസ്മാദയമേതാനി ലബ്ധവാൻ? ഇത്ഥം സ തേഷാം വിഘ്നരൂപോ ബഭൂവ; ");
INSERT INTO sanmal_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","തതോ യീശുനാ നിഗദിതം സ്വദേശീയജനാനാം മധ്യം വിനാ ഭവിഷ്യദ്വാദീ കുത്രാപ്യന്യത്ര നാസമ്മാന്യോ ഭവതീ| ");
INSERT INTO sanmal_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","തേഷാമവിശ്വാസഹേതോഃ സ തത്ര സ്ഥാനേ ബഹ്വാശ്ചര്യ്യകർമ്മാണി ന കൃതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","തദാനീം രാജാ ഹേരോദ് യീശോ ര്യശഃ ശ്രുത്വാ നിജദാസേയാൻ ജഗാദ്, ");
INSERT INTO sanmal_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ഏഷ മജ്ജയിതാ യോഹൻ, പ്രമിതേഭയസ്തസ്യോത്ഥാനാത് തേനേത്ഥമദ്ഭുതം കർമ്മ പ്രകാശ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","പുരാ ഹേരോദ് നിജഭ്രാതു: ഫിലിപോ ജായായാ ഹേരോദീയായാ അനുരോധാദ് യോഹനം ധാരയിത്വാ ബദ്ധാ കാരായാം സ്ഥാപിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","യതോ യോഹൻ ഉക്തവാൻ, ഏത്സയാഃ സംഗ്രഹോ ഭവതോ നോചിതഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","തസ്മാത് നൃപതിസ്തം ഹന്തുമിച്ഛന്നപി ലോകേഭ്യോ വിഭയാഞ്ചകാര; യതഃ സർവ്വേ യോഹനം ഭവിഷ്യദ്വാദിനം മേനിരേ| ");
INSERT INTO sanmal_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","കിന്തു ഹേരോദോ ജന്മാഹീയമഹ ഉപസ്ഥിതേ ഹേരോദീയായാ ദുഹിതാ തേഷാം സമക്ഷം നൃതിത്വാ ഹേരോദമപ്രീണ്യത്| ");
INSERT INTO sanmal_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","തസ്മാത് ഭൂപതിഃ ശപഥം കുർവ്വൻ ഇതി പ്രത്യജ്ഞാസീത്, ത്വയാ യദ് യാച്യതേ, തദേവാഹം ദാസ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","സാ കുമാരീ സ്വീയമാതുഃ ശിക്ഷാം ലബ്ധാ ബഭാഷേ, മജ്ജയിതുര്യോഹന ഉത്തമാങ്ഗം ഭാജനേ സമാനീയ മഹ്യം വിശ്രാണയ| ");
INSERT INTO sanmal_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","തതോ രാജാ ശുശോച, കിന്തു ഭോജനായോപവിശതാം സങ്ഗിനാം സ്വകൃതശപഥസ്യ ചാനുരോധാത് തത് പ്രദാതുമ ആദിദേശ| ");
INSERT INTO sanmal_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","പശ്ചാത് കാരാം പ്രതി നരം പ്രഹിത്യ യോഹന ഉത്തമാങ്ഗം ഛിത്ത്വാ ");
INSERT INTO sanmal_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","തത് ഭാജന ആനായ്യ തസ്യൈ കുമാര്യ്യൈ വ്യശ്രാണയത്, തതഃ സാ സ്വജനന്യാഃ സമീപം തന്നിനായ| ");
INSERT INTO sanmal_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","പശ്ചാത് യോഹനഃ ശിഷ്യാ ആഗത്യ കായം നീത്വാ ശ്മശാനേ സ്ഥാപയാമാസുസ്തതോ യീശോഃ സന്നിധിം വ്രജിത്വാ തദ്വാർത്താം ബഭാഷിരേ| ");
INSERT INTO sanmal_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","അനന്തരം യീശുരിതി നിശഭ്യ നാവാ നിർജനസ്ഥാനമ് ഏകാകീ ഗതവാൻ, പശ്ചാത് മാനവാസ്തത് ശ്രുത്വാ നാനാനഗരേഭ്യ ആഗത്യ പദൈസ്തത്പശ്ചാദ് ഈയുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","തദാനീം യീശു ർബഹിരാഗത്യ മഹാന്തം ജനനിവഹം നിരീക്ഷ്യ തേഷു കാരുണികഃ മൻ തേഷാം പീഡിതജനാൻ നിരാമയാൻ ചകാര| ");
INSERT INTO sanmal_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","തതഃ പരം സന്ധ്യായാം ശിഷ്യാസ്തദന്തികമാഗത്യ കഥയാഞ്ചക്രുഃ, ഇദം നിർജനസ്ഥാനം വേലാപ്യവസന്നാ; തസ്മാത് മനുജാൻ സ്വസ്വഗ്രാമം ഗന്തും സ്വാർഥം ഭക്ഷ്യാണി ക്രേതുഞ്ച ഭവാൻ താൻ വിസൃജതു| ");
INSERT INTO sanmal_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","കിന്തു യീശുസ്താനവാദീത്, തേഷാം ഗമനേ പ്രയോജനം നാസ്തി, യൂയമേവ താൻ ഭോജയത| ");
INSERT INTO sanmal_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","തദാ തേ പ്രത്യവദൻ, അസ്മാകമത്ര പൂപപഞ്ചകം മീനദ്വയഞ്ചാസ്തേ| ");
INSERT INTO sanmal_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","തദാനീം തേനോക്തം താനി മദന്തികമാനയത| ");
INSERT INTO sanmal_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","അനന്തരം സ മനുജാൻ യവസോപര്യ്യുപവേഷ്ടുമ് ആജ്ഞാപയാമാസ; അപര തത് പൂപപഞ്ചകം മീനദ്വയഞ്ച ഗൃഹ്ലൻ സ്വർഗം പ്രതി നിരീക്ഷ്യേശ്വരീയഗുണാൻ അനൂദ്യ ഭംക്ത്വാ ശിഷ്യേഭ്യോ ദത്തവാൻ, ശിഷ്യാശ്ച ലോകേഭ്യോ ദദുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","തതഃ സർവ്വേ ഭുക്ത്വാ പരിതൃപ്തവന്തഃ, തതസ്തദവശിഷ്ടഭക്ഷ്യൈഃ പൂർണാൻ ദ്വാദശഡലകാൻ ഗൃഹീതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","തേ ഭോക്താരഃ സ്ത്രീർബാലകാംശ്ച വിഹായ പ്രായേണ പഞ്ച സഹസ്രാണി പുമാംസ ആസൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","തദനന്തരം യീശു ർലോകാനാം വിസർജനകാലേ ശിഷ്യാൻ തരണിമാരോഢും സ്വാഗ്രേ പാരം യാതുഞ്ച ഗാഢമാദിഷ്ടവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","തതോ ലോകേഷു വിസൃഷ്ടേഷു സ വിവിക്തേ പ്രാർഥയിതും ഗിരിമേകം ഗത്വാ സന്ധ്യാം യാവത് തത്രൈകാകീ സ്ഥിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","കിന്തു തദാനീം സമ്മുഖവാതത്വാത് സരിത്പതേ ർമധ്യേ തരങ്ഗൈസ്തരണിർദോലായമാനാഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","തദാ സ യാമിന്യാശ്ചതുർഥപ്രഹരേ പദ്ഭ്യാം വ്രജൻ തേഷാമന്തികം ഗതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","കിന്തു ശിഷ്യാസ്തം സാഗരോപരി വ്രജന്തം വിലോക്യ സമുദ്വിഗ്നാ ജഗദുഃ, ഏഷ ഭൂത ഇതി ശങ്കമാനാ ഉച്ചൈഃ ശബ്ദായാഞ്ചക്രിരേ ച| ");
INSERT INTO sanmal_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","തദൈവ യീശുസ്താനവദത്, സുസ്ഥിരാ ഭവത, മാ ഭൈഷ്ട, ഏഷോഽഹമ്| ");
INSERT INTO sanmal_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","തതഃ പിതര ഇത്യുക്തവാൻ, ഹേ പ്രഭോ, യദി ഭവാനേവ, തർഹി മാം ഭവത്സമീപം യാതുമാജ്ഞാപയതു| ");
INSERT INTO sanmal_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","തതഃ തേനാദിഷ്ടഃ പിതരസ്തരണിതോഽവരുഹ്യ യീശേाരന്തികം പ്രാപ്തും തോയോപരി വവ്രാജ| ");
INSERT INTO sanmal_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","കിന്തു പ്രചണ്ഡം പവനം വിലോക്യ ഭയാത് തോയേ മംക്തുമ് ആരേഭേ, തസ്മാദ് ഉച്ചൈഃ ശബ്ദായമാനഃ കഥിതവാൻ, ഹേ പ്രഭോ, മാമവതു| ");
INSERT INTO sanmal_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","യീശുസ്തത്ക്ഷണാത് കരം പ്രസാര്യ്യ തം ധരൻ ഉക്തവാൻ, ഹ സ്തോകപ്രത്യയിൻ ത്വം കുതഃ സമശേഥാഃ? ");
INSERT INTO sanmal_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","അനന്തരം തയോസ്തരണിമാരൂഢയോഃ പവനോ നിവവൃതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","തദാനീം യേ തരണ്യാമാസൻ, ത ആഗത്യ തം പ്രണഭ്യ കഥിതവന്തഃ, യഥാർഥസ്ത്വമേവേശ്വരസുതഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","അനന്തരം പാരം പ്രാപ്യ തേ ഗിനേഷരന്നാമകം നഗരമുപതസ്ഥുഃ, ");
INSERT INTO sanmal_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","തദാ തത്രത്യാ ജനാ യീശും പരിചീയ തദ്ദേശ്സ്യ ചതുർദിശോ വാർത്താം പ്രഹിത്യ യത്ര യാവന്തഃ പീഡിതാ ആസൻ, താവതഏവ തദന്തികമാനയാമാസുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","അപരം തദീയവസനസ്യ ഗ്രന്ഥിമാത്രം സ്പ്രഷ്ടും വിനീയ യാവന്തോ ജനാസ്തത് സ്പർശം ചക്രിരേ, തേ സർവ്വഏവ നിരാമയാ ബഭൂവുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","അപരം യിരൂശാലമ്നഗരീയാഃ കതിപയാ അധ്യാപകാഃ ഫിരൂശിനശ്ച യീശോഃ സമീപമാഗത്യ കഥയാമാസുഃ, ");
INSERT INTO sanmal_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","തവ ശിഷ്യാഃ കിമർഥമ് അപ്രക്ഷാലിതകരൈ ർഭക്ഷിത്വാ പരമ്പരാഗതം പ്രാചീനാനാം വ്യവഹാരം ലങ്വന്തേ? ");
INSERT INTO sanmal_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","തതോ യീശുഃ പ്രത്യുവാച, യൂയം പരമ്പരാഗതാചാരേണ കുത ഈശ്വരാജ്ഞാം ലങ്വധ്വേ| ");
INSERT INTO sanmal_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ഈശ്വര ഇത്യാജ്ഞാപയത്, ത്വം നിജപിതരൗ സംമന്യേഥാഃ, യേന ച നിജപിതരൗ നിന്ദ്യേതേ, സ നിശ്ചിതം മ്രിയേത; ");
INSERT INTO sanmal_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","കിന്തു യൂയം വദഥ, യഃ സ്വജനകം സ്വജനനീം വാ വാക്യമിദം വദതി, യുവാം മത്തോ യല്ലഭേഥേ, തത് ന്യവിദ്യത, ");
INSERT INTO sanmal_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","സ നിജപിതരൗ പുന ർന സംമംസ്യതേ| ഇത്ഥം യൂയം പരമ്പരാഗതേന സ്വേഷാമാചാരേണേശ്വരീയാജ്ഞാം ലുമ്പഥ| ");
INSERT INTO sanmal_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","രേ കപടിനഃ സർവ്വേ യിശയിയോ യുഷ്മാനധി ഭവിഷ്യദ്വചനാന്യേതാനി സമ്യഗ് ഉക്തവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","വദനൈ ർമനുജാ ഏതേ സമായാന്തി മദന്തികം| തഥാധരൈ ർമദീയഞ്ച മാനം കുർവ്വന്തി തേ നരാഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","കിന്തു തേഷാം മനോ മത്തോ വിദൂരഏവ തിഷ്ഠതി| ശിക്ഷയന്തോ വിധീൻ ന്രാജ്ഞാ ഭജന്തേ മാം മുധൈവ തേ| ");
INSERT INTO sanmal_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","തതോ യീശു ർലോകാൻ ആഹൂയ പ്രോക്തവാൻ, യൂയം ശ്രുത്വാ ബുധ്യധ്ബം| ");
INSERT INTO sanmal_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","യന്മുഖം പ്രവിശതി, തത് മനുജമ് അമേധ്യം ന കരോതി, കിന്തു യദാസ്യാത് നിർഗച്ഛതി, തദേവ മാനുഷമമേധ്യീ കരോതീ| ");
INSERT INTO sanmal_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","തദാനീം ശിഷ്യാ ആഗത്യ തസ്മൈ കഥയാഞ്ചക്രുഃ, ഏതാം കഥാം ശ്രുത്വാ ഫിരൂശിനോ വ്യരജ്യന്ത, തത് കിം ഭവതാ ജ്ഞായതേ? ");
INSERT INTO sanmal_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","സ പ്രത്യവദത്, മമ സ്വർഗസ്ഥഃ പിതാ യം കഞ്ചിദങ്കുരം നാരോപയത്, സ ഉത്പാവ്ദ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","തേ തിഷ്ഠന്തു, തേ അന്ധമനുജാനാമ് അന്ധമാർഗദർശകാ ഏവ; യദ്യന്ധോഽന്ധം പന്ഥാനം ദർശയതി, തർഹ്യുഭൗ ഗർത്തേ പതതഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","തദാ പിതരസ്തം പ്രത്യവദത്, ദൃഷ്ടാന്തമിമമസ്മാൻ ബോധയതു| ");
INSERT INTO sanmal_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","യീശുനാ പ്രോക്തം, യൂയമദ്യ യാവത് കിമബോധാഃ സ്ഥ? ");
INSERT INTO sanmal_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","കഥാമിമാം കിം ന ബുധ്യധ്ബേ ? യദാസ്യം പ്രേവിശതി, തദ് ഉദരേ പതൻ ബഹിർനിര്യാതി, ");
INSERT INTO sanmal_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","കിന്ത്വാസ്യാദ് യന്നിര്യാതി, തദ് അന്തഃകരണാത് നിര്യാതത്വാത് മനുജമമേധ്യം കരോതി| ");
INSERT INTO sanmal_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","യതോഽന്തഃകരണാത് കുചിന്താ ബധഃ പാരദാരികതാ വേശ്യാഗമനം ചൈര്യ്യം മിഥ്യാസാക്ഷ്യമ് ഈശ്വരനിന്ദാ ചൈതാനി സർവ്വാണി നിര്യ്യാന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ഏതാനി മനുഷ്യമപവിത്രീ കുർവ്വന്തി കിന്ത്വപ്രക്ഷാലിതകരേണ ഭോജനം മനുജമമേധ്യം ന കരോതി| ");
INSERT INTO sanmal_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","അനന്തരം യീശുസ്തസ്മാത് സ്ഥാനാത് പ്രസ്ഥായ സോരസീദോന്നഗരയോഃ സീമാമുപതസ്യൗ| ");
INSERT INTO sanmal_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","തദാ തത്സീമാതഃ കാചിത് കിനാനീയാ യോഷിദ് ആഗത്യ തമുച്ചൈരുവാച, ഹേ പ്രഭോ ദായൂദഃ സന്താന, മമൈകാ ദുഹിതാസ്തേ സാ ഭൂതഗ്രസ്താ സതീ മഹാക്ലേശം പ്രാപ്നോതി മമ ദയസ്വ| ");
INSERT INTO sanmal_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","കിന്തു യീശുസ്താം കിമപി നോക്തവാൻ, തതഃ ശിഷ്യാ ആഗത്യ തം നിവേദയാമാസുഃ, ഏഷാ യോഷിദ് അസ്മാകം പശ്ചാദ് ഉച്ചൈരാഹൂയാഗച്ഛതി, ഏനാം വിസൃജതു| ");
INSERT INTO sanmal_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","തദാ സ പ്രത്യവദത്, ഇസ്രായേൽഗോത്രസ്യ ഹാരിതമേഷാൻ വിനാ കസ്യാപ്യന്യസ്യ സമീപം നാഹം പ്രേഷിതോസ്മി| ");
INSERT INTO sanmal_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","തതഃ സാ നാരീസമാഗത്യ തം പ്രണമ്യ ജഗാദ, ഹേ പ്രഭോ മാമുപകുരു| ");
INSERT INTO sanmal_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","സ ഉക്തവാൻ, ബാലകാനാം ഭക്ഷ്യമാദായ സാരമേയേഭ്യോ ദാനം നോചിതം| ");
INSERT INTO sanmal_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","തദാ സാ ബഭാഷേ, ഹേ പ്രഭോ, തത് സത്യം, തഥാപി പ്രഭോ ർഭഞ്ചാദ് യദുച്ഛിഷ്ടം പതതി, തത് സാരമേയാഃ ഖാദന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","തതോ യീശുഃ പ്രത്യവദത്, ഹേ യോഷിത്, തവ വിശ്വാസോ മഹാൻ തസ്മാത് തവ മനോഭിലഷിതം സിദ്യ്യതു, തേന തസ്യാഃ കന്യാ തസ്മിന്നേവ ദണ്ഡേ നിരാമയാഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","അനന്തരം യീശസ്തസ്മാത് സ്ഥാനാത് പ്രസ്ഥായ ഗാലീൽസാഗരസ്യ സന്നിധിമാഗത്യ ധരാധരമാരുഹ്യ തത്രോപവിവേശ| ");
INSERT INTO sanmal_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","പശ്ചാത് ജനനിവഹോ ബഹൂൻ ഖഞ്ചാന്ധമൂകശുഷ്കകരമാനുഷാൻ ആദായ യീശോഃ സമീപമാഗത്യ തച്ചരണാന്തികേ സ്ഥാപയാമാസുഃ, തതഃ സാ താൻ നിരാമയാൻ അകരോത്| ");
INSERT INTO sanmal_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ഇത്ഥം മൂകാ വാക്യം വദന്തി, ശുഷ്കകരാഃ സ്വാസ്ഥ്യമായാന്തി, പങ്ഗവോ ഗച്ഛന്തി, അന്ധാ വീക്ഷന്തേ, ഇതി വിലോക്യ ലോകാ വിസ്മയം മന്യമാനാ ഇസ്രായേല ഈശ്വരം ധന്യം ബഭാഷിരേ| ");
INSERT INTO sanmal_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","തദാനീം യീശുഃ സ്വശിഷ്യാൻ ആഹൂയ ഗദിതവാൻ, ഏതജ്ജനനിവഹേഷു മമ ദയാ ജായതേ, ഏതേ ദിനത്രയം മയാ സാകം സന്തി, ഏഷാം ഭക്ഷ്യവസ്തു ച കഞ്ചിദപി നാസ്തി, തസ്മാദഹമേതാനകൃതാഹാരാൻ ന വിസ്രക്ഷ്യാമി, തഥാത്വേ വർത്മമധ്യേ ക്ലാമ്യേഷുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","തദാ ശിഷ്യാ ഊചുഃ, ഏതസ്മിൻ പ്രാന്തരമധ്യ ഏതാവതോ മർത്യാൻ തർപയിതും വയം കുത്ര പൂപാൻ പ്രാപ്സ്യാമഃ? ");
INSERT INTO sanmal_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","യീശുരപൃച്ഛത്, യുഷ്മാകം നികടേ കതി പൂപാ ആസതേ? ത ഊചുഃ, സപ്തപൂപാ അൽപാഃ ക്ഷുദ്രമീനാശ്ച സന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","തദാനീം സ ലോകനിവഹം ഭൂമാവുപവേഷ്ടുമ് ആദിശ്യ ");
INSERT INTO sanmal_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","താൻ സപ്തപൂപാൻ മീനാംശ്ച ഗൃഹ്ലൻ ഈശ്വരീയഗുണാൻ അനൂദ്യ ഭംക്ത്വാ ശിഷ്യേഭ്യോ ദദൗ, ശിഷ്യാ ലോകേഭ്യോ ദദുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","തതഃ സർവ്വേ ഭുക്ത്വാ തൃപ്തവന്തഃ; തദവശിഷ്ടഭക്ഷ്യേണ സപ്തഡലകാൻ പരിപൂര്യ്യ സംജഗൃഹുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","തേ ഭോക്താരോ യോഷിതോ ബാലകാംശ്ച വിഹായ പ്രായേണ ചതുഃസഹസ്രാണി പുരുഷാ ആസൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","തതഃ പരം സ ജനനിവഹം വിസൃജ്യ തരിമാരുഹ്യ മഗ്ദലാപ്രദേശം ഗതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","തദാനീം ഫിരൂശിനഃ സിദൂകിനശ്ചാഗത്യ തം പരീക്ഷിതും നഭമീയം കിഞ്ചന ലക്ഷ്മ ദർശയിതും തസ്മൈ നിവേദയാമാസുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","തതഃ സ ഉക്തവാൻ, സന്ധ്യായാം നഭസോ രക്തത്വാദ് യൂയം വദഥ, ശ്വോ നിർമ്മലം ദിനം ഭവിഷ്യതി; ");
INSERT INTO sanmal_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","പ്രാതഃകാലേ ച നഭസോ രക്തത്വാത് മലിനത്വാഞ്ച വദഥ, ഝഞ്ഭ്ശദ്യ ഭവിഷ്യതി| ഹേ കപടിനോ യദി യൂയമ് അന്തരീക്ഷസ്യ ലക്ഷ്മ ബോദ്ധും ശക്നുഥ, തർഹി കാലസ്യൈതസ്യ ലക്ഷ്മ കഥം ബോദ്ധും ന ശക്നുഥ? ");
INSERT INTO sanmal_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ഏതത്കാലസ്യ ദുഷ്ടോ വ്യഭിചാരീ ച വംശോ ലക്ഷ്മ ഗവേഷയതി, കിന്തു യൂനസോ ഭവിഷ്യദ്വാദിനോ ലക്ഷ്മ വിനാന്യത് കിമപി ലക്ഷ്മ താൻ ന ദർശയിയ്യതേ| തദാനീം സ താൻ വിഹായ പ്രതസ്ഥേ| ");
INSERT INTO sanmal_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","അനന്തരമന്യപാരഗമനകാലേ തസ്യ ശിഷ്യാഃ പൂപമാനേതും വിസ്മൃതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","യീശുസ്താനവാദീത്, യൂയം ഫിരൂശിനാം സിദൂകിനാഞ്ച കിണ്വം പ്രതി സാവധാനാഃ സതർകാശ്ച ഭവത| ");
INSERT INTO sanmal_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","തേന തേ പരസ്പരം വിവിച്യ കഥയിതുമാരേഭിരേ, വയം പൂപാനാനേതും വിസ്മൃതവന്ത ഏതത്കാരണാദ് ഇതി കഥയതി| ");
INSERT INTO sanmal_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","കിന്തു യീശുസ്തദ്വിജ്ഞായ താനവോചത്, ഹേ സ്തോകവിശ്വാസിനോ യൂയം പൂപാനാനയനമധി കുതഃ പരസ്പരമേതദ് വിവിംക്യ? ");
INSERT INTO sanmal_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","യുഷ്മാഭിഃ കിമദ്യാപി ന ജ്ഞായതേ? പഞ്ചഭിഃ പൂപൈഃ പഞ്ചസഹസ്രപുരുഷേഷു ഭോജിതേഷു ഭക്ഷ്യോച്ഛിഷ്ടപൂർണാൻ കതി ഡലകാൻ സമഗൃഹ്ലീതം; ");
INSERT INTO sanmal_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","തഥാ സപ്തഭിഃ പൂപൈശ്ചതുഃസഹസ്രപുരുഷേഷു ഭേജിതേഷു കതി ഡലകാൻ സമഗൃഹ്ലീത, തത് കിം യുഷ്മാഭിർന സ്മര്യ്യതേ? ");
INSERT INTO sanmal_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","തസ്മാത് ഫിരൂശിനാം സിദൂകിനാഞ്ച കിണ്വം പ്രതി സാവധാനാസ്തിഷ്ഠത, കഥാമിമാമ് അഹം പൂപാനധി നാകഥയം, ഏതദ് യൂയം കുതോ ന ബുധ്യധ്വേ? ");
INSERT INTO sanmal_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","തദാനീം പൂപകിണ്വം പ്രതി സാവധാനാസ്തിഷ്ഠതേതി നോക്ത്വാ ഫിരൂശിനാം സിദൂകിനാഞ്ച ഉപദേശം പ്രതി സാവധാനാസ്തിഷ്ഠതേതി കഥിതവാൻ, ഇതി തൈരബോധി| ");
INSERT INTO sanmal_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","അപരഞ്ച യീശുഃ കൈസരിയാ-ഫിലിപിപ്രദേശമാഗത്യ ശിഷ്യാൻ അപൃച്ഛത്, യോഽഹം മനുജസുതഃ സോഽഹം കഃ? ലോകൈരഹം കിമുച്യേ? ");
INSERT INTO sanmal_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","തദാനീം തേ കഥിതവന്തഃ, കേചിദ് വദന്തി ത്വം മജ്ജയിതാ യോഹൻ, കേചിദ്വദന്തി, ത്വമ് ഏലിയഃ, കേചിച്ച വദന്തി, ത്വം യിരിമിയോ വാ കശ്ചിദ് ഭവിഷ്യദ്വാദീതി| ");
INSERT INTO sanmal_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","പശ്ചാത് സ താൻ പപ്രച്ഛ, യൂയം മാം കം വദഥ? തതഃ ശിമോൻ പിതര ഉവാച, ");
INSERT INTO sanmal_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ത്വമമരേശ്വരസ്യാഭിഷിക്തപുത്രഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","തതോ യീശുഃ കഥിതവാൻ, ഹേ യൂനസഃ പുത്ര ശിമോൻ ത്വം ധന്യഃ; യതഃ കോപി അനുജസ്ത്വയ്യേതജ്ജ്ഞാനം നോദപാദയത്, കിന്തു മമ സ്വർഗസ്യഃ പിതോദപാദയത്| ");
INSERT INTO sanmal_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","അതോഽഹം ത്വാം വദാമി, ത്വം പിതരഃ (പ്രസ്തരഃ) അഹഞ്ച തസ്യ പ്രസ്തരസ്യോപരി സ്വമണ്ഡലീം നിർമ്മാസ്യാമി, തേന നിരയോ ബലാത് താം പരാജേതും ന ശക്ഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","അഹം തുഭ്യം സ്വർഗീയരാജ്യസ്യ കുഞ്ജികാം ദാസ്യാമി, തേന യത് കിഞ്ചന ത്വം പൃഥിവ്യാം ഭംത്സ്യസി തത്സ്വർഗേ ഭംത്സ്യതേ, യച്ച കിഞ്ചന മഹ്യാം മോക്ഷ്യസി തത് സ്വർഗേ മോക്ഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","പശ്ചാത് സ ശിഷ്യാനാദിശത്, അഹമഭിഷിക്തോ യീശുരിതി കഥാം കസ്മൈചിദപി യൂയം മാ കഥയത| ");
INSERT INTO sanmal_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","അന്യഞ്ച യിരൂശാലമ്നഗരം ഗത്വാ പ്രാചീനലോകേഭ്യഃ പ്രധാനയാജകേഭ്യ ഉപാധ്യായേഭ്യശ്ച ബഹുദുഃഖഭോഗസ്തൈ ർഹതത്വം തൃതീയദിനേ പുനരുത്ഥാനഞ്ച മമാവശ്യകമ് ഏതാഃ കഥാ യീശുസ്തത്കാലമാരഭ്യ ശിഷ്യാൻ ജ്ഞാപയിതുമ് ആരബ്ധവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","തദാനീം പിതരസ്തസ്യ കരം ഘൃത്വാ തർജയിത്വാ കഥയിതുമാരബ്ധവാൻ, ഹേ പ്രഭോ, തത് ത്വത്തോ ദൂരം യാതു, ത്വാം പ്രതി കദാപി ന ഘടിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","കിന്തു സ വദനം പരാവർത്യ പിതരം ജഗാദ, ഹേ വിഘ്നകാരിൻ, മത്സമ്മുഖാദ് ദൂരീഭവ, ത്വം മാം ബാധസേ, ഈശ്വരീയകാര്യ്യാത് മാനുഷീയകാര്യ്യം തുഭ്യം രോചതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","അനന്തരം യീശുഃ സ്വീയശിഷ്യാൻ ഉക്തവാൻ യഃ കശ്ചിത് മമ പശ്ചാദ്ഗാമീ ഭവിതുമ് ഇച്ഛതി, സ സ്വം ദാമ്യതു, തഥാ സ്വക്രുശം ഗൃഹ്ലൻ മത്പശ്ചാദായാതു| ");
INSERT INTO sanmal_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","യതോ യഃ പ്രാണാൻ രക്ഷിതുമിച്ഛതി, സ താൻ ഹാരയിഷ്യതി, കിന്തു യോ മദർഥം നിജപ്രാണാൻ ഹാരയതി, സ താൻ പ്രാപ്സ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","മാനുഷോ യദി സർവ്വം ജഗത് ലഭതേ നിജപ്രണാൻ ഹാരയതി, തർഹി തസ്യ കോ ലാഭഃ? മനുജോ നിജപ്രാണാനാം വിനിമയേന വാ കിം ദാതും ശക്നോതി? ");
INSERT INTO sanmal_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","മനുജസുതഃ സ്വദൂതൈഃ സാകം പിതുഃ പ്രഭാവേണാഗമിഷ്യതി; തദാ പ്രതിമനുജം സ്വസ്വകർമ്മാനുസാരാത് ഫലം ദാസ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","അഹം യുഷ്മാൻ തഥ്യം വച്മി, സരാജ്യം മനുജസുതമ് ആഗതം ന പശ്യന്തോ മൃത്യും ന സ്വാദിഷ്യന്തി, ഏതാദൃശാഃ കതിപയജനാ അത്രാപി ദണ്ഡായമാനാഃ സന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","അനന്തരം ഷഡ്ദിനേഭ്യഃ പരം യീശുഃ പിതരം യാകൂബം തത്സഹജം യോഹനഞ്ച ഗൃഹ്ലൻ ഉച്ചാദ്രേ ർവിവിക്തസ്ഥാനമ് ആഗത്യ തേഷാം സമക്ഷം രൂപമന്യത് ദധാര| ");
INSERT INTO sanmal_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","തേന തദാസ്യം തേജസ്വി, തദാഭരണമ് ആലോകവത് പാണ്ഡരമഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","അന്യച്ച തേന സാകം സംലപന്തൗ മൂസാ ഏലിയശ്ച തേഭ്യോ ദർശനം ദദതുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","തദാനീം പിതരോ യീശും ജഗാദ, ഹേ പ്രഭോ സ്ഥിതിരത്രാസ്മാകം ശുഭാ, യദി ഭവതാനുമന്യതേ, തർഹി ഭവദർഥമേകം മൂസാർഥമേകമ് ഏലിയാർഥഞ്ചൈകമ് ഇതി ത്രീണി ദൂഷ്യാണി നിർമ്മമ| ");
INSERT INTO sanmal_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ഏതത്കഥനകാല ഏക ഉജ്ജവലഃ പയോദസ്തേഷാമുപരി ഛായാം കൃതവാൻ, വാരിദാദ് ഏഷാ നഭസീയാ വാഗ് ബഭൂവ, മമായം പ്രിയഃ പുത്രഃ, അസ്മിൻ മമ മഹാസന്തോഷ ഏതസ്യ വാക്യം യൂയം നിശാമയത| ");
INSERT INTO sanmal_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","കിന്തു വാചമേതാം ശൃണ്വന്തഏവ ശിഷ്യാ മൃശം ശങ്കമാനാ ന്യുബ്ജാ ന്യപതൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","തദാ യീശുരാഗത്യ തേഷാം ഗാത്രാണി സ്പൃശൻ ഉവാച, ഉത്തിഷ്ഠത, മാ ഭൈഷ്ട| ");
INSERT INTO sanmal_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","തദാനീം നേത്രാണ്യുന്മീല്യ യീശും വിനാ കമപി ന ദദൃശുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","തതഃ പരമ് അദ്രേരവരോഹണകാലേ യീശുസ്താൻ ഇത്യാദിദേശ, മനുജസുതസ്യ മൃതാനാം മധ്യാദുത്ഥാനം യാവന്ന ജായതേ, താവത് യുഷ്മാഭിരേതദ്ദർശനം കസ്മൈചിദപി ന കഥയിതവ്യം| ");
INSERT INTO sanmal_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","തദാ ശിഷ്യാസ്തം പപ്രച്ഛുഃ, പ്രഥമമ് ഏലിയ ആയാസ്യതീതി കുത ഉപാധ്യായൈരുച്യതേ? ");
INSERT INTO sanmal_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","തതോ യീശുഃ പ്രത്യവാദീത്, ഏലിയഃ പ്രാഗേത്യ സർവ്വാണി സാധയിഷ്യതീതി സത്യം, ");
INSERT INTO sanmal_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","കിന്ത്വഹം യുഷ്മാൻ വച്മി, ഏലിയ ഏത്യ ഗതഃ, തേ തമപരിചിത്യ തസ്മിൻ യഥേച്ഛം വ്യവജഹുഃ; മനുജസുതേനാപി തേഷാമന്തികേ താദൃഗ് ദുഃഖം ഭോക്തവ്യം| ");
INSERT INTO sanmal_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","തദാനീം സ മജ്ജയിതാരം യോഹനമധി കഥാമേതാം വ്യാഹൃതവാൻ, ഇത്ഥം തച്ഛിഷ്യാ ബുബുധിരേ| ");
INSERT INTO sanmal_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","പശ്ചാത് തേഷു ജനനിവഹസ്യാന്തികമാഗതേഷു കശ്ചിത് മനുജസ്തദന്തികമേത്യ ജാനൂനീ പാതയിത്വാ കഥിതവാൻ, ");
INSERT INTO sanmal_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ഹേ പ്രഭോ, മത്പുത്രം പ്രതി കൃപാം വിദധാതു, സോപസ്മാരാമയേന ഭൃശം വ്യഥിതഃ സൻ പുനഃ പുന ർവഹ്നൗ മുഹു ർജലമധ്യേ പതതി| ");
INSERT INTO sanmal_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","തസ്മാദ് ഭവതഃ ശിഷ്യാണാം സമീപേ തമാനയം കിന്തു തേ തം സ്വാസ്ഥം കർത്തും ന ശക്താഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","തദാ യീശുഃ കഥിതവാൻ രേ അവിശ്വാസിനഃ, രേ വിപഥഗാമിനഃ, പുനഃ കതികാലാൻ അഹം യുഷ്മാകം സന്നിധൗ സ്ഥാസ്യാമി? കതികാലാൻ വാ യുഷ്മാൻ സഹിഷ്യേ? തമത്ര മമാന്തികമാനയത| ");
INSERT INTO sanmal_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","പശ്ചാദ് യീശുനാ തർജതഏവ സ ഭൂതസ്തം വിഹായ ഗതവാൻ, തദ്ദണ്ഡഏവ സ ബാലകോ നിരാമയോഽഭൂത്| ");
INSERT INTO sanmal_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","തതഃ ശിഷ്യാ ഗുപ്തം യീശുമുപാഗത്യ ബഭാഷിരേ, കുതോ വയം തം ഭൂതം ത്യാജയിതും ന ശക്താഃ? ");
INSERT INTO sanmal_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","യീശുനാ തേ പ്രോക്താഃ, യുഷ്മാകമപ്രത്യയാത്; ");
INSERT INTO sanmal_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","യുഷ്മാനഹം തഥ്യം വച്മി യദി യുഷ്മാകം സർഷപൈകമാത്രോപി വിശ്വാസോ ജായതേ, തർഹി യുഷ്മാഭിരസ്മിൻ ശൈലേ ത്വമിതഃ സ്ഥാനാത് തത് സ്ഥാനം യാഹീതി ബ്രൂതേ സ തദൈവ ചലിഷ്യതി, യുഷ്മാകം കിമപ്യസാധ്യഞ്ച കർമ്മ ന സ്ഥാസ്യാതി| കിന്തു പ്രാർഥനോപവാസൗ വിനൈതാദൃശോ ഭൂതോ ന ത്യാജ്യേത| ");
INSERT INTO sanmal_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","അപരം തേഷാം ഗാലീൽപ്രദേശേ ഭ്രമണകാലേ യീശുനാ തേ ഗദിതാഃ, മനുജസുതോ ജനാനാം കരേഷു സമർപയിഷ്യതേ തൈ ർഹനിഷ്യതേ ച, ");
INSERT INTO sanmal_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","കിന്തു തൃതീയേഽഹി्ന മ ഉത്ഥാപിഷ്യതേ, തേന തേ ഭൃശം ദുഃഖിതാ ബഭൂവഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","തദനന്തരം തേഷു കഫർനാഹൂമ്നഗരമാഗതേഷു കരസംഗ്രാഹിണഃ പിതരാന്തികമാഗത്യ പപ്രച്ഛുഃ, യുഷ്മാകം ഗുരുഃ കിം മന്ദിരാർഥം കരം ന ദദാതി? തതഃ പിതരഃ കഥിതവാൻ ദദാതി| ");
INSERT INTO sanmal_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","തതസ്തസ്മിൻ ഗൃഹമധ്യമാഗതേ തസ്യ കഥാകഥനാത് പൂർവ്വമേവ യീശുരുവാച, ഹേ ശിമോൻ, മേദിന്യാ രാജാനഃ സ്വസ്വാപത്യേഭ്യഃ കിം വിദേശിഭ്യഃ കേഭ്യഃ കരം ഗൃഹ്ലന്തി? അത്ര ത്വം കിം ബുധ്യസേ? തതഃ പിതര ഉക്തവാൻ, വിദേശിഭ്യഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","തദാ യീശുരുക്തവാൻ, തർഹി സന്താനാ മുക്താഃ സന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","തഥാപി യഥാസ്മാഭിസ്തേഷാമന്തരായോ ന ജന്യതേ, തത്കൃതേ ജലധേസ്തീരം ഗത്വാ വഡിശം ക്ഷിപ, തേനാദൗ യോ മീന ഉത്ഥാസ്യതി, തം ഘൃത്വാ തന്മുഖേ മോചിതേ തോലകൈകം രൂപ്യം പ്രാപ്സ്യസി, തദ് ഗൃഹീത്വാ തവ മമ ച കൃതേ തേഭ്യോ ദേഹി| ");
INSERT INTO sanmal_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","തദാനീം ശിഷ്യാ യീശോഃ സമീപമാഗത്യ പൃഷ്ടവന്തഃ സ്വർഗരാജ്യേ കഃ ശ്രേഷ്ഠഃ? ");
INSERT INTO sanmal_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","തതോ യീശുഃ ക്ഷുദ്രമേകം ബാലകം സ്വസമീപമാനീയ തേഷാം മധ്യേ നിധായ ജഗാദ, ");
INSERT INTO sanmal_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","യുഷ്മാനഹം സത്യം ബ്രവീമി, യൂയം മനോവിനിമയേന ക്ഷുദ്രബാലവത് ന സന്തഃ സ്വർഗരാജ്യം പ്രവേഷ്ടും ന ശക്നുഥ| ");
INSERT INTO sanmal_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","യഃ കശ്ചിദ് ഏതസ്യ ക്ഷുദ്രബാലകസ്യ സമമാത്മാനം നമ്രീകരോതി, സഏവ സ്വർഗരാജയേ ശ്രേഷ്ഠഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","യഃ കശ്ചിദ് ഏതാദൃശം ക്ഷുദ്രബാലകമേകം മമ നാമ്നി ഗൃഹ്ലാതി, സ മാമേവ ഗൃഹ്ലാതി| ");
INSERT INTO sanmal_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","കിന്തു യോ ജനോ മയി കൃതവിശ്വാസാനാമേതേഷാം ക്ഷുദ്രപ്രാണിനാമ് ഏകസ്യാപി വിധ്നിം ജനയതി, കണ്ഠബദ്ധപേഷണീകസ്യ തസ്യ സാഗരാഗാധജലേ മജ്ജനം ശ്രേയഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","വിഘ്നാത് ജഗതഃ സന്താപോ ഭവിഷ്യതി, വിഘ്നോഽവശ്യം ജനയിഷ്യതേ, കിന്തു യേന മനുജേന വിഘ്നോ ജനിഷ്യതേ തസ്യൈവ സന്താപോ ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","തസ്മാത് തവ കരശ്ചരണോ വാ യദി ത്വാം ബാധതേ, തർഹി തം ഛിത്ത്വാ നിക്ഷിപ, ദ്വികരസ്യ ദ്വിപദസ്യ വാ തവാനപ്തവഹ്നൗ നിക്ഷേപാത്, ഖഞ്ജസ്യ വാ ഛിന്നഹസ്തസ്യ തവ ജീവനേ പ്രവേശോ വരം| ");
INSERT INTO sanmal_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","അപരം തവ നേത്രം യദി ത്വാം ബാധതേ, തർഹി തദപ്യുത്പാവ്യ നിക്ഷിപ, ദ്വിനേത്രസ്യ നരകാഗ്നൗ നിക്ഷേപാത് കാണസ്യ തവ ജീവനേ പ്രവേശോ വരം| ");
INSERT INTO sanmal_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","തസ്മാദവധദ്ധം, ഏതേഷാം ക്ഷുദ്രപ്രാണിനാമ് ഏകമപി മാ തുച്ഛീകുരുത, ");
INSERT INTO sanmal_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","യതോ യുഷ്മാനഹം തഥ്യം ബ്രവീമി, സ്വർഗേ തേഷാം ദൂതാ മമ സ്വർഗസ്ഥസ്യ പിതുരാസ്യം നിത്യം പശ്യന്തി| ഏവം യേ യേ ഹാരിതാസ്താൻ രക്ഷിതും മനുജപുത്ര ആഗച്ഛത്| ");
INSERT INTO sanmal_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","യൂയമത്ര കിം വിവിംഗ്ഘ്വേ? കസ്യചിദ് യദി ശതം മേഷാഃ സന്തി, തേഷാമേകോ ഹാര്യ്യതേ ച, തർഹി സ ഏകോനശതം മേഷാൻ വിഹായ പർവ്വതം ഗത്വാ തം ഹാരിതമേകം കിം ന മൃഗയതേ? ");
INSERT INTO sanmal_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","യദി ച കദാചിത് തന്മേഷോദ്ദേശം ലമതേ, തർഹി യുഷ്മാനഹം സത്യം കഥയാമി, സോഽവിപഥഗാമിഭ്യ ഏകോനശതമേഷേഭ്യോപി തദേകഹേതോരധികമ് ആഹ്ലാദതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","തദ്വദ് ഏതേഷാം ക്ഷുദ്രപ്രാഏिനാമ് ഏകോപി നശ്യതീതി യുഷ്മാകം സ്വർഗസ്ഥപിതു ർനാഭിമതമ്| ");
INSERT INTO sanmal_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","യദ്യപി തവ ഭ്രാതാ ത്വയി കിമപ്യപരാധ്യതി, തർഹി ഗത്വാ യുവയോർദ്വയോഃ സ്ഥിതയോസ്തസ്യാപരാധം തം ജ്ഞാപയ| തത്ര സ യദി തവ വാക്യം ശൃണോതി, തർഹി ത്വം സ്വഭ്രാതരം പ്രാപ്തവാൻ, ");
INSERT INTO sanmal_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","കിന്തു യദി ന ശൃണോതി, തർഹി ദ്വാഭ്യാം ത്രിഭി ർവാ സാക്ഷീഭിഃ സർവ്വം വാക്യം യഥാ നിശ്ചിതം ജായതേ, തദർഥമ് ഏകം ദ്വൗ വാ സാക്ഷിണൗ ഗൃഹീത്വാ യാഹി| ");
INSERT INTO sanmal_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","തേന സ യദി തയോ ർവാക്യം ന മാന്യതേ, തർഹി സമാജം തജ്ജ്ഞാപയ, കിന്തു യദി സമാജസ്യാപി വാക്യം ന മാന്യതേ,തർഹി സ തവ സമീപേ ദേവപൂജകഇവ ചണ്ഡാലഇവ ച ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","അഹം യുഷ്മാൻ സത്യം വദാമി, യുഷ്മാഭിഃ പൃഥിവ്യാം യദ് ബധ്യതേ തത് സ്വർഗേ ഭംത്സ്യതേ; മേദിന്യാം യത് ഭോച്യതേ, സ്വർഗേഽപി തത് മോക്ഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","പുനരഹം യുഷ്മാൻ വദാമി, മേദിന്യാം യുഷ്മാകം യദി ദ്വാവേകവാക്യീഭൂയ കിഞ്ചിത് പ്രാർഥയേതേ, തർഹി മമ സ്വർഗസ്ഥപിത്രാ തത് തയോഃ കൃതേ സമ്പന്നം ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","യതോ യത്ര ദ്വൗ ത്രയോ വാ മമ നാന്നി മിലന്തി, തത്രൈവാഹം തേഷാം മധ്യേഽസ്മി| ");
INSERT INTO sanmal_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","തദാനീം പിതരസ്തത്സമീപമാഗത്യ കഥിതവാൻ ഹേ പ്രഭോ, മമ ഭ്രാതാ മമ യദ്യപരാധ്യതി, തർഹി തം കതികൃത്വഃ ക്ഷമിഷ്യേ? ");
INSERT INTO sanmal_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","കിം സപ്തകൃത്വഃ? യീശുസ്തം ജഗാദ, ത്വാം കേവലം സപ്തകൃത്വോ യാവത് ന വദാമി, കിന്തു സപ്തത്യാ ഗുണിതം സപ്തകൃത്വോ യാവത്| ");
INSERT INTO sanmal_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","അപരം നിജദാസൈഃ സഹ ജിഗണയിഷുഃ കശ്ചിദ് രാജേവ സ്വർഗരാജയം| ");
INSERT INTO sanmal_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ആരബ്ധേ തസ്മിൻ ഗണനേ സാർദ്ധസഹസ്രമുദ്രാപൂരിതാനാം ദശസഹസ്രപുടകാനാമ് ഏകോഽഘമർണസ്തത്സമക്ഷമാനായി| ");
INSERT INTO sanmal_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","തസ്യ പരിശോധനായ ദ്രവ്യാഭാവാത് പരിശോധനാർഥം സ തദീയഭാര്യ്യാപുത്രാദിസർവ്വസ്വഞ്ച വിക്രീയതാമിതി തത്പ്രഭുരാദിദേശ| ");
INSERT INTO sanmal_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","തേന സ ദാസസ്തസ്യ പാദയോഃ പതൻ പ്രണമ്യ കഥിതവാൻ , ഹേ പ്രഭോ ഭവതാ ഘൈര്യ്യേ കൃതേ മയാ സർവ്വം പരിശോധിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","തദാനീം ദാസസ്യ പ്രഭുഃ സകരുണഃ സൻ സകലർണം ക്ഷമിത്വാ തം തത്യാജ| ");
INSERT INTO sanmal_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","കിന്തു തസ്മിൻ ദാസേ ബഹി ര്യാതേ, തസ്യ ശതം മുദ്രാചതുർഥാംശാൻ യോ ധാരയതി, തം സഹദാസം ദൃഷ്ദ്വാ തസ്യ കണ്ഠം നിഷ്പീഡ്യ ഗദിതവാൻ, മമ യത് പ്രാപ്യം തത് പരിശോധയ| ");
INSERT INTO sanmal_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","തദാ തസ്യ സഹദാസസ്തത്പാദയോഃ പതിത്വാ വിനീയ ബഭാഷേ, ത്വയാ ധൈര്യ്യേ കൃതേ മയാ സർവ്വം പരിശോധിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","തഥാപി സ തത് നാങഗീകൃത്യ യാവത് സർവ്വമൃണം ന പരിശോധിതവാൻ താവത് തം കാരായാം സ്ഥാപയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","തദാ തസ്യ സഹദാസാസ്തസ്യൈതാദൃഗ് ആചരണം വിലോക്യ പ്രഭോഃ സമീപം ഗത്വാ സർവ്വം വൃത്താന്തം നിവേദയാമാസുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","തദാ തസ്യ പ്രഭുസ്തമാഹൂയ ജഗാദ, രേ ദുഷ്ട ദാസ, ത്വയാ മത്സന്നിധൗ പ്രാർഥിതേ മയാ തവ സർവ്വമൃണം ത്യക്തം; ");
INSERT INTO sanmal_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","യഥാ ചാഹം ത്വയി കരുണാം കൃതവാൻ, തഥൈവ ത്വത്സഹദാസേ കരുണാകരണം കിം തവ നോചിതം? ");
INSERT INTO sanmal_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ഇതി കഥയിത്വാ തസ്യ പ്രഭുഃ ക്രുദ്ധ്യൻ നിജപ്രാപ്യം യാവത് സ ന പരിശോധിതവാൻ, താവത് പ്രഹാരകാനാം കരേഷു തം സമർപിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","യദി യൂയം സ്വാന്തഃകരണൈഃ സ്വസ്വസഹജാനാമ് അപരാധാൻ ന ക്ഷമധ്വേ, തർഹി മമ സ്വർഗസ്യഃ പിതാപി യുഷ്മാൻ പ്രതീത്ഥം കരിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","അനന്തരമ് ഏതാസു കഥാസു സമാപ്താസു യീശു ർഗാലീലപ്രദേശാത് പ്രസ്ഥായ യർദന്തീരസ്ഥം യിഹൂദാപ്രദേശം പ്രാപ്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","തദാ തത്പശ്ചാത് ജനനിവഹേ ഗതേ സ തത്ര താൻ നിരാമയാൻ അകരോത്| ");
INSERT INTO sanmal_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","തദനന്തരം ഫിരൂശിനസ്തത്സമീപമാഗത്യ പാരീക്ഷിതും തം പപ്രച്ഛുഃ, കസ്മാദപി കാരണാത് നരേണ സ്വജായാ പരിത്യാജ്യാ ന വാ? ");
INSERT INTO sanmal_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","സ പ്രത്യുവാച, പ്രഥമമ് ഈശ്വരോ നരത്വേന നാരീത്വേന ച മനുജാൻ സസർജ, തസ്മാത് കഥിതവാൻ, ");
INSERT INTO sanmal_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","മാനുഷഃ സ്വപിതരൗ പരിത്യജ്യ സ്വപത്ന്യാമ് ആസക്ഷ്യതേ, തൗ ദ്വൗ ജനാവേകാങ്ഗൗ ഭവിഷ്യതഃ, കിമേതദ് യുഷ്മാഭി ർന പഠിതമ്? ");
INSERT INTO sanmal_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","അതസ്തൗ പുന ർന ദ്വൗ തയോരേകാങ്ഗത്വം ജാതം, ഈശ്വരേണ യച്ച സമയുജ്യത, മനുജോ ന തദ് ഭിന്ദ്യാത്| ");
INSERT INTO sanmal_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","തദാനീം തേ തം പ്രത്യവദൻ, തഥാത്വേ ത്യാജ്യപത്രം ദത്ത്വാ സ്വാം സ്വാം ജായാം ത്യക്തും വ്യവസ്ഥാം മൂസാഃ കഥം ലിലേഖ? ");
INSERT INTO sanmal_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","തതഃ സ കഥിതവാൻ, യുഷ്മാകം മനസാം കാഠിന്യാദ് യുഷ്മാൻ സ്വാം സ്വാം ജായാം ത്യക്തുമ് അന്വമന്യത കിന്തു പ്രഥമാദ് ഏഷോ വിധിർനാസീത്| ");
INSERT INTO sanmal_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","അതോ യുഷ്മാനഹം വദാമി, വ്യഭിചാരം വിനാ യോ നിജജായാം ത്യജേത് അന്യാഞ്ച വിവഹേത്, സ പരദാരാൻ ഗച്ഛതി; യശ്ച ത്യക്താം നാരീം വിവഹതി സോപി പരദാരേഷു രമതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","തദാ തസ്യ ശിഷ്യാസ്തം ബഭാഷിരേ, യദി സ്വജായയാ സാകം പുംസ ഏതാദൃക് സമ്ബന്ധോ ജായതേ, തർഹി വിവഹനമേവ ന ഭദ്രം| ");
INSERT INTO sanmal_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","തതഃ സ ഉക്തവാൻ, യേഭ്യസ്തത്സാമർഥ്യം ആദായി, താൻ വിനാന്യഃ കോപി മനുജ ഏതന്മതം ഗ്രഹീതും ന ശക്നോതി| ");
INSERT INTO sanmal_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","കതിപയാ ജനനക്ലീബഃ കതിപയാ നരകൃതക്ലീബഃ സ്വർഗരാജ്യായ കതിപയാഃ സ്വകൃതക്ലീബാശ്ച സന്തി, യേ ഗ്രഹീതും ശക്നുവന്തി തേ ഗൃഹ്ലന്തു| ");
INSERT INTO sanmal_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","അപരമ് യഥാ സ ശിശൂനാം ഗാത്രേഷു ഹസ്തം ദത്വാ പ്രാർഥയതേ, തദർഥം തത്സമീംപം ശിശവ ആനീയന്ത, തത ആനയിതൃൻ ശിഷ്യാസ്തിരസ്കൃതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","കിന്തു യീശുരുവാച, ശിശവോ മദന്തികമ് ആഗച്ഛന്തു, താൻ മാ വാരയത, ഏതാദൃശാം ശിശൂനാമേവ സ്വർഗരാജ്യം| ");
INSERT INTO sanmal_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","തതഃ സ തേഷാം ഗാത്രേഷു ഹസ്തം ദത്വാ തസ്മാത് സ്ഥാനാത് പ്രതസ്ഥേ| ");
INSERT INTO sanmal_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","അപരമ് ഏക ആഗത്യ തം പപ്രച്ഛ, ഹേ പരമഗുരോ, അനന്തായുഃ പ്രാപ്തും മയാ കിം കിം സത്കർമ്മ കർത്തവ്യം? ");
INSERT INTO sanmal_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","തതഃ സ ഉവാച, മാം പരമം കുതോ വദസി? വിനേശ്ചരം ന കോപി പരമഃ, കിന്തു യദ്യനന്തായുഃ പ്രാപ്തും വാഞ്ഛസി, തർഹ്യാജ്ഞാഃ പാലയ| ");
INSERT INTO sanmal_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","തദാ സ പൃഷ്ടവാൻ, കാഃ കാ ആജ്ഞാഃ? തതോ യീശുഃ കഥിതവാൻ, നരം മാ ഹന്യാഃ, പരദാരാൻ മാ ഗച്ഛേഃ, മാ ചോരയേഃ, മൃഷാസാക്ഷ്യം മാ ദദ്യാഃ, ");
INSERT INTO sanmal_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","നിജപിതരൗ സംമന്യസ്വ, സ്വസമീപവാസിനി സ്വവത് പ്രേമ കുരു| ");
INSERT INTO sanmal_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","സ യുവാ കഥിതവാൻ, ആ ബാല്യാദ് ഏതാഃ പാലയാമി, ഇദാനീം കിം ന്യൂനമാസ്തേ? ");
INSERT INTO sanmal_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","തതോ യീശുരവദത്, യദി സിദ്ധോ ഭവിതും വാഞ്ഛസി, തർഹി ഗത്വാ നിജസർവ്വസ്വം വിക്രീയ ദരിദ്രേഭ്യോ വിതര, തതഃ സ്വർഗേ വിത്തം ലപ്സ്യസേ; ആഗച്ഛ, മത്പശ്ചാദ്വർത്തീ ച ഭവ| ");
INSERT INTO sanmal_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ഏതാം വാചം ശ്രുത്വാ സ യുവാ സ്വീയബഹുസമ്പത്തേ ർവിഷണഃ സൻ ചലിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","തദാ യീശുഃ സ്വശിഷ്യാൻ അവദത്, ധനിനാം സ്വർഗരാജ്യപ്രവേശോ മഹാദുഷ്കര ഇതി യുഷ്മാനഹം തഥ്യം വദാമി| ");
INSERT INTO sanmal_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","പുനരപി യുഷ്മാനഹം വദാമി, ധനിനാം സ്വർഗരാജ്യപ്രവേശാത് സൂചീഛിദ്രേണ മഹാങ്ഗഗമനം സുകരം| ");
INSERT INTO sanmal_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ഇതി വാക്യം നിശമ്യ ശിഷ്യാ അതിചമത്കൃത്യ കഥയാമാസുഃ; തർഹി കസ്യ പരിത്രാണം ഭവിതും ശക്നോതി? ");
INSERT INTO sanmal_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","തദാ സ താൻ ദൃഷ്ദ്വാ കഥയാമാസ, തത് മാനുഷാണാമശക്യം ഭവതി, കിന്ത്വീശ്വരസ്യ സർവ്വം ശക്യമ്| ");
INSERT INTO sanmal_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","തദാ പിതരസ്തം ഗദിതവാൻ, പശ്യ, വയം സർവ്വം പരിത്യജ്യ ഭവതഃ പശ്ചാദ്വർത്തിനോ ഽഭവാമ; വയം കിം പ്രാപ്സ്യാമഃ? ");
INSERT INTO sanmal_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","തതോ യീശുഃ കഥിതവാൻ, യുഷ്മാനഹം തഥ്യം വദാമി, യൂയം മമ പശ്ചാദ്വർത്തിനോ ജാതാ ഇതി കാരണാത് നവീനസൃഷ്ടികാലേ യദാ മനുജസുതഃ സ്വീയൈശ്ചര്യ്യസിംഹാസന ഉപവേക്ഷ്യതി, തദാ യൂയമപി ദ്വാദശസിംഹാസനേഷൂപവിശ്യ ഇസ്രായേലീയദ്വാദശവംശാനാം വിചാരം കരിഷ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","അന്യച്ച യഃ കശ്ചിത് മമ നാമകാരണാത് ഗൃഹം വാ ഭ്രാതരം വാ ഭഗിനീം വാ പിതരം വാ മാതരം വാ ജായാം വാ ബാലകം വാ ഭൂമിം പരിത്യജതി, സ തേഷാം ശതഗുണം ലപ്സ്യതേ, അനന്തായുമോഽധികാരിത്വഞ്ച പ്രാപ്സ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","കിന്തു അഗ്രീയാ അനേകേ ജനാഃ പശ്ചാത്, പശ്ചാതീയാശ്ചാനേകേ ലോകാ അഗ്രേ ഭവിഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","സ്വർഗരാജ്യമ് ഏതാദൃശാ കേനചിദ് ഗൃഹസ്യേന സമം, യോഽതിപ്രഭാതേ നിജദ്രാക്ഷാക്ഷേത്രേ കൃഷകാൻ നിയോക്തും ഗതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","പശ്ചാത് തൈഃ സാകം ദിനൈകഭൃതിം മുദ്രാചതുർഥാംശം നിരൂപ്യ താൻ ദ്രാക്ഷാക്ഷേത്രം പ്രേരയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","അനന്തരം പ്രഹരൈകവേലായാം ഗത്വാ ഹട്ടേ കതിപയാൻ നിഷ്കർമ്മകാൻ വിലോക്യ താനവദത്, ");
INSERT INTO sanmal_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","യൂയമപി മമ ദ്രാക്ഷാക്ഷേത്രം യാത, യുഷ്മഭ്യമഹം യോഗ്യഭൃതിം ദാസ്യാമി, തതസ്തേ വവ്രജുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","പുനശ്ച സ ദ്വിതീയതൃതീയയോഃ പ്രഹരയോ ർബഹി ർഗത്വാ തഥൈവ കൃതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","തതോ ദണ്ഡദ്വയാവശിഷ്ടായാം വേലായാം ബഹി ർഗത്വാപരാൻ കതിപയജനാൻ നിഷ്കർമ്മകാൻ വിലോക്യ പൃഷ്ടവാൻ, യൂയം കിമർഥമ് അത്ര സർവ്വം ദിനം നിഷ്കർമ്മാണസ്തിഷ്ഠഥ? ");
INSERT INTO sanmal_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","തേ പ്രത്യവദൻ, അസ്മാൻ ന കോപി കർമമണി നിയുംക്തേ| തദാനീം സ കഥിതവാൻ, യൂയമപി മമ ദ്രാക്ഷാക്ഷേത്രം യാത, തേന യോഗ്യാം ഭൃതിം ലപ്സ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","തദനന്തരം സന്ധ്യായാം സത്യാം സഏവ ദ്രാക്ഷാക്ഷേത്രപതിരധ്യക്ഷം ഗദിവാൻ, കൃഷകാൻ ആഹൂയ ശേഷജനമാരഭ്യ പ്രഥമം യാവത് തേഭ്യോ ഭൃതിം ദേഹി| ");
INSERT INTO sanmal_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","തേന യേ ദണ്ഡദ്വയാവസ്ഥിതേ സമായാതാസ്തേഷാമ് ഏകൈകോ ജനോ മുദ്രാചതുർഥാംശം പ്രാപ്നോത്| ");
INSERT INTO sanmal_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","തദാനീം പ്രഥമനിയുക്താ ജനാ ആഗത്യാനുമിതവന്തോ വയമധികം പ്രപ്സ്യാമഃ, കിന്തു തൈരപി മുദ്രാചതുർഥാംശോഽലാഭി| ");
INSERT INTO sanmal_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","തതസ്തേ തം ഗൃഹീത്വാ തേന ക്ഷേത്രപതിനാ സാകം വാഗ്യുദ്ധം കുർവ്വന്തഃ കഥയാമാസുഃ, ");
INSERT INTO sanmal_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","വയം കൃത്സ്നം ദിനം താപക്ലേശൗ സോഢവന്തഃ, കിന്തു പശ്ചാതായാ സേ ജനാ ദണ്ഡദ്വയമാത്രം പരിശ്രാന്തവന്തസ്തേഽസ്മാഭിഃ സമാനാംശാഃ കൃതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","തതഃ സ തേഷാമേകം പ്രത്യുവാച, ഹേ വത്സ, മയാ ത്വാം പ്രതി കോപ്യന്യായോ ന കൃതഃ കിം ത്വയാ മത്സമക്ഷം മുദ്രാചതുർഥാംശോ നാങ്ഗീകൃതഃ? ");
INSERT INTO sanmal_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","തസ്മാത് തവ യത് പ്രാപ്യം തദാദായ യാഹി, തുഭ്യം യതി, പശ്ചാതീയനിയുക്തലോകായാപി തതി ദാതുമിച്ഛാമി| ");
INSERT INTO sanmal_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","സ്വേച്ഛയാ നിജദ്രവ്യവ്യവഹരണം കിം മയാ ന കർത്തവ്യം? മമ ദാതൃത്വാത് ത്വയാ കിമ് ഈർഷ്യാദൃഷ്ടിഃ ക്രിയതേ? ");
INSERT INTO sanmal_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","ഇത്ഥമ് അഗ്രീയലോകാഃ പശ്ചതീയാ ഭവിഷ്യന്തി, പശ്ചാതീയജനാശ്ചഗ്രീയാ ഭവിഷ്യന്തി, അഹൂതാ ബഹവഃ കിന്ത്വൽപേ മനോഭിലഷിതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","തദനന്തരം യീശു ര്യിരൂശാലമ്നഗരം ഗച്ഛൻ മാർഗമധ്യേ ശിഷ്യാൻ ഏകാന്തേ വഭാഷേ, ");
INSERT INTO sanmal_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","പശ്യ വയം യിരൂശാലമ്നഗരം യാമഃ, തത്ര പ്രധാനയാജകാധ്യാപകാനാം കരേഷു മനുഷ്യപുത്രഃ സമർപിഷ്യതേ; ");
INSERT INTO sanmal_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","തേ ച തം ഹന്തുമാജ്ഞാപ്യ തിരസ്കൃത്യ വേത്രേണ പ്രഹർത്തും ക്രുശേ ധാതയിതുഞ്ചാന്യദേശീയാനാം കരേഷു സമർപയിഷ്യന്തി, കിന്തു സ തൃതീയദിവസേ ശ്മശാനാദ് ഉത്ഥാപിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","തദാനീം സിവദീയസ്യ നാരീ സ്വപുത്രാവാദായ യീശോഃ സമീപമ് ഏത്യ പ്രണമ്യ കഞ്ചനാനുഗ്രഹം തം യയാചേ| ");
INSERT INTO sanmal_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","തദാ യീശുസ്താം പ്രോക്തവാൻ, ത്വം കിം യാചസേ? തതഃ സാ ബഭാഷേ, ഭവതോ രാജത്വേ മമാനയോഃ സുതയോരേകം ഭവദ്ദക്ഷിണപാർശ്വേ ദ്വിതീയം വാമപാർശ്വ ഉപവേഷ്ടുമ് ആജ്ഞാപയതു| ");
INSERT INTO sanmal_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","യീശുഃ പ്രത്യുവാച, യുവാഭ്യാം യദ് യാച്യതേ, തന്ന ബുധ്യതേ, അഹം യേന കംസേന പാസ്യാമി യുവാഭ്യാം കിം തേന പാതും ശക്യതേ? അഹഞ്ച യേന മജ്ജേനേന മജ്ജിഷ്യേ, യുവാഭ്യാം കിം തേന മജ്ജയിതും ശക്യതേ? തേ ജഗദുഃ ശക്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","തദാ സ ഉക്തവാൻ, യുവാം മമ കംസേനാവശ്യം പാസ്യഥഃ, മമ മജ്ജനേന ച യുവാമപി മജ്ജിഷ്യേഥേ, കിന്തു യേഷാം കൃതേ മത്താതേന നിരൂപിതമ് ഇദം താൻ വിഹായാന്യം കമപി മദ്ദക്ഷിണപാർശ്വേ വാമപാർശ്വേ ച സമുപവേശയിതും മമാധികാരോ നാസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ഏതാം കഥാം ശ്രുത്വാന്യേ ദശശിഷ്യാസ്തൗ ഭ്രാതരൗ പ്രതി ചുകുപുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","കിന്തു യീശുഃ സ്വസമീപം താനാഹൂയ ജഗാദ, അന്യദേശീയലോകാനാം നരപതയസ്താൻ അധികുർവ്വന്തി, യേ തു മഹാന്തസ്തേ താൻ ശാസതി, ഇതി യൂയം ജാനീഥ| ");
INSERT INTO sanmal_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","കിന്തു യുഷ്മാകം മധ്യേ ന തഥാ ഭവേത്, യുഷ്മാകം യഃ കശ്ചിത് മഹാൻ ബുഭൂഷതി, സ യുഷ്മാൻ സേവേത; ");
INSERT INTO sanmal_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","യശ്ച യുഷ്മാകം മധ്യേ മുഖ്യോ ബുഭൂഷതി, സ യുഷ്മാകം ദാസോ ഭവേത്| ");
INSERT INTO sanmal_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ഇത്ഥം മനുജപുത്രഃ സേവ്യോ ഭവിതും നഹി, കിന്തു സേവിതും ബഹൂനാം പരിത്രാണമൂല്യാർഥം സ്വപ്രാണാൻ ദാതുഞ്ചാഗതഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","അനന്തരം യിരീഹോനഗരാത് തേഷാം ബഹിർഗമനസമയേ തസ്യ പശ്ചാദ് ബഹവോ ലോകാ വവ്രജുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","അപരം വർത്മപാർശ്വ ഉപവിശന്തൗ ദ്വാവന്ധൗ തേന മാർഗേണ യീശോ ർഗമനം നിശമ്യ പ്രോച്ചൈഃ കഥയാമാസതുഃ, ഹേ പ്രഭോ ദായൂദഃ സന്താന, ആവയോ ർദയാം വിധേഹി| ");
INSERT INTO sanmal_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","തതോ ലോകാഃ സർവ്വേ തുഷ്ണീമ്ഭവതമിത്യുക്ത്വാ തൗ തർജയാമാസുഃ; തഥാപി തൗ പുനരുച്ചൈഃ കഥയാമാസതുഃ ഹേ പ്രഭോ ദായൂദഃ സന്താന, ആവാം ദയസ്വ| ");
INSERT INTO sanmal_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","തദാനീം യീശുഃ സ്ഥഗിതഃ സൻ താവാഹൂയ ഭാഷിതവാൻ, യുവയോഃ കൃതേ മയാ കിം കർത്തർവ്യം? യുവാം കിം കാമയേഥേ? ");
INSERT INTO sanmal_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","തദാ താവുക്തവന്തൗ, പ്രഭോ നേത്രാണി നൗ പ്രസന്നാനി ഭവേയുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","തദാനീം യീശുസ്തൗ പ്രതി പ്രമന്നഃ സൻ തയോ ർനേത്രാണി പസ്പർശ, തേനൈവ തൗ സുവീക്ഷാഞ്ചക്രാതേ തത്പശ്ചാത് ജഗ്മുതുശ്ച| ");
INSERT INTO sanmal_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","അനന്തരം തേഷു യിരൂശാലമ്നഗരസ്യ സമീപവേർത്തിനോ ജൈതുനനാമകധരാധരസ്യ സമീപസ്ഥ്തിം ബൈത്ഫഗിഗ്രാമമ് ആഗതേഷു, യീശുഃ ശിഷ്യദ്വയം പ്രേഷയൻ ജഗാദ, ");
INSERT INTO sanmal_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","യുവാം സമ്മുഖസ്ഥഗ്രാമം ഗത്വാ ബദ്ധാം യാം സവത്സാം ഗർദ്ദഭീം ഹഠാത് പ്രാപ്സ്യഥഃ, താം മോചയിത്വാ മദന്തികമ് ആനയതം| ");
INSERT INTO sanmal_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","തത്ര യദി കശ്ചിത് കിഞ്ചിദ് വക്ഷ്യതി, തർഹി വദിഷ്യഥഃ, ഏതസ്യാം പ്രഭോഃ പ്രയോജനമാസ്തേ, തേന സ തത്ക്ഷണാത് പ്രഹേഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","സീയോനഃ കന്യകാം യൂയം ഭാഷധ്വമിതി ഭാരതീം| പശ്യ തേ നമ്രശീലഃ സൻ നൃപ ആരുഹ്യ ഗർദഭീം| അർഥാദാരുഹ്യ തദ്വത്സമായാസ്യതി ത്വദന്തികം| ");
INSERT INTO sanmal_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","ഭവിഷ്യദ്വാദിനോക്തം വചനമിദം തദാ സഫലമഭൂത്| ");
INSERT INTO sanmal_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","അനന്തരം തൗ ശ്ഷ്യിौ യീശോ ര്യഥാനിദേശം തം ഗ്രാമം ഗത്വാ ");
INSERT INTO sanmal_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ഗർദഭീം തദ്വത്സഞ്ച സമാനീതവന്തൗ, പശ്ചാത് തദുപരി സ്വീയവസനാനീ പാതയിത്വാ തമാരോഹയാമാസതുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","തതോ ബഹവോ ലോകാ നിജവസനാനി പഥി പ്രസാരയിതുമാരേഭിരേ, കതിപയാ ജനാശ്ച പാദപപർണാദികം ഛിത്വാ പഥി വിസ്താരയാമാസുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","അഗ്രഗാമിനഃ പശ്ചാദ്ഗാമിനശ്ച മനുജാ ഉച്ചൈർജയ ജയ ദായൂദഃ സന്താനേതി ജഗദുഃ പരമേശ്വരസ്യ നാമ്നാ യ ആയാതി സ ധന്യഃ, സർവ്വോപരിസ്ഥസ്വർഗേപി ജയതി| ");
INSERT INTO sanmal_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ഇത്ഥം തസ്മിൻ യിരൂശാലമം പ്രവിഷ്ടേ കോഽയമിതി കഥനാത് കൃത്സ്നം നഗരം ചഞ്ചലമഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","തത്ര ലോകോഃ കഥയാമാസുഃ, ഏഷ ഗാലീൽപ്രദേശീയ-നാസരതീയ-ഭവിഷ്യദ്വാദീ യീശുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","അനന്തരം യീശുരീശ്വരസ്യ മന്ദിരം പ്രവിശ്യ തന്മധ്യാത് ക്രയവിക്രയിണോ വഹിശ്ചകാര; വണിജാം മുദ്രാസനാനീ കപോതവിക്രയിണാഞ്ചസനാനീ ച ന്യുവ്ജയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","അപരം താനുവാച, ഏഷാ ലിപിരാസ്തേ, \"മമ ഗൃഹം പ്രാർഥനാഗൃഹമിതി വിഖ്യാസ്യതി\", കിന്തു യൂയം തദ് ദസ്യൂനാം ഗഹ്വരം കൃതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","തദനന്തരമ് അന്ധഖഞ്ചലോകാസ്തസ്യ സമീപമാഗതാഃ, സ താൻ നിരാമയാൻ കൃതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","യദാ പ്രധാനയാജകാ അധ്യാപകാശ്ച തേന കൃതാന്യേതാനി ചിത്രകർമ്മാണി ദദൃശുഃ, ജയ ജയ ദായൂദഃ സന്താന, മന്ദിരേ ബാലകാനാമ് ഏതാദൃശമ് ഉച്ചധ്വനിം ശുശ്രുവുശ്ച, തദാ മഹാക്രുദ്ധാ ബഭൂവഃ, ");
INSERT INTO sanmal_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","തം പപ്രച്ഛുശ്ച, ഇമേ യദ് വദന്തി, തത് കിം ത്വം ശൃണോഷി? തതോ യീശുസ്താൻ അവോചത്, സത്യമ്; സ്തന്യപായിശിശൂനാഞ്ച ബാലകാനാഞ്ച വക്ത്രതഃ| സ്വകീയം മഹിമാനം ത്വം സംപ്രകാശയസി സ്വയം| ഏതദ്വാക്യം യൂയം കിം നാപഠത? ");
INSERT INTO sanmal_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","തതസ്താൻ വിഹായ സ നഗരാദ് ബൈഥനിയാഗ്രാമം ഗത്വാ തത്ര രജനീം യാപയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","അനന്തരം പ്രഭാതേ സതി യീശുഃ പുനരപി നഗരമാഗച്ഛൻ ക്ഷുധാർത്തോ ബഭൂവ| ");
INSERT INTO sanmal_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","തതോ മാർഗപാർശ്വ ഉഡുമ്ബരവൃക്ഷമേകം വിലോക്യ തത്സമീപം ഗത്വാ പത്രാണി വിനാ കിമപി ന പ്രാപ്യ തം പാദപം പ്രോവാച, അദ്യാരഭ്യ കദാപി ത്വയി ഫലം ന ഭവതു; തേന തത്ക്ഷണാത് സ ഉഡുമ്ബരമാഹീരുഹഃ ശുഷ്കതാം ഗതഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","തദ് ദൃഷ്ട്വാ ശിഷ്യാ ആശ്ചര്യ്യം വിജ്ഞായ കഥയാമാസുഃ, ആഃ, ഉഡുമ്വരപാദപോഽതിതൂർണം ശുഷ്കോഽഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","തതോ യീശുസ്താനുവാച, യുഷ്മാനഹം സത്യം വദാമി, യദി യൂയമസന്ദിഗ്ധാഃ പ്രതീഥ, തർഹി യൂയമപി കേവലോഡുമ്വരപാദപം പ്രതീത്ഥം കർത്തും ശക്ഷ്യഥ, തന്ന, ത്വം ചലിത്വാ സാഗരേ പതേതി വാക്യം യുഷ്മാഭിരസ്മിന ശൈലേ പ്രോക്തേപി തദൈവ തദ് ഘടിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","തഥാ വിശ്വസ്യ പ്രാർഥ്യ യുഷ്മാഭി ര്യദ് യാചിഷ്യതേ, തദേവ പ്രാപ്സ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","അനന്തരം മന്ദിരം പ്രവിശ്യോപദേശനസമയേ തത്സമീപം പ്രധാനയാജകാഃ പ്രാചീനലോകാശ്ചാഗത്യ പപ്രച്ഛുഃ, ത്വയാ കേന സാമർഥ്യനൈതാനി കർമ്മാണി ക്രിയന്തേ? കേന വാ തുഭ്യമേതാനി സാമർഥ്യാനി ദത്താനി? ");
INSERT INTO sanmal_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","തതോ യീശുഃ പ്രത്യവദത്, അഹമപി യുഷ്മാൻ വാചമേകാം പൃച്ഛാമി, യദി യൂയം തദുത്തരം ദാതും ശക്ഷ്യഥ, തദാ കേന സാമർഥ്യേന കർമ്മാണ്യേതാനി കരോമി, തദഹം യുഷ്മാൻ വക്ഷ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","യോഹനോ മജ്ജനം കസ്യാജ്ഞയാഭവത്? കിമീശ്വരസ്യ മനുഷ്യസ്യ വാ? തതസ്തേ പരസ്പരം വിവിച്യ കഥയാമാസുഃ, യദീശ്വരസ്യേതി വദാമസ്തർഹി യൂയം തം കുതോ ന പ്രത്യൈത? വാചമേതാം വക്ഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","മനുഷ്യസ്യേതി വക്തുമപി ലോകേഭ്യോ ബിഭീമഃ, യതഃ സർവ്വൈരപി യോഹൻ ഭവിഷ്യദ്വാദീതി ജ്ഞായതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","തസ്മാത് തേ യീശും പ്രത്യവദൻ, തദ് വയം ന വിദ്മഃ| തദാ സ താനുക്തവാൻ, തർഹി കേന സാമരഥ്യേന കർമ്മാണ്യേതാന്യഹം കരോമി, തദപ്യഹം യുഷ്മാൻ ന വക്ഷ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","കസ്യചിജ്ജനസ്യ ദ്വൗ സുതാവാസ്താം സ ഏകസ്യ സുതസ്യ സമീപം ഗത്വാ ജഗാദ, ഹേ സുത, ത്വമദ്യ മമ ദ്രാക്ഷാക്ഷേത്രേ കർമ്മ കർതും വ്രജ| ");
INSERT INTO sanmal_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","തതഃ സ ഉക്തവാൻ, ന യാസ്യാമി, കിന്തു ശേഷേഽനുതപ്യ ജഗാമ| ");
INSERT INTO sanmal_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","അനന്തരം സോന്യസുതസ്യ സമീപം ഗത്വാ തഥൈവ കഥ്തിവാൻ; തതഃ സ പ്രത്യുവാച, മഹേച്ഛ യാമി, കിന്തു ന ഗതഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","ഏതയോഃ പുത്രയോ ർമധ്യേ പിതുരഭിമതം കേന പാലിതം? യുഷ്മാഭിഃ കിം ബുധ്യതേ? തതസ്തേ പ്രത്യൂചുഃ, പ്രഥമേന പുुത്രേണ| തദാനീം യീശുസ്താനുവാച, അഹം യുഷ്മാൻ തഥ്യം വദാമി, ചണ്ഡാലാ ഗണികാശ്ച യുഷ്മാകമഗ്രത ഈശ്വരസ്യ രാജ്യം പ്രവിശന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","യതോ യുഷ്മാകം സമീപം യോഹനി ധർമ്മപഥേനാഗതേ യൂയം തം ന പ്രതീഥ, കിന്തു ചണ്ഡാലാ ഗണികാശ്ച തം പ്രത്യായൻ, തദ് വിലോക്യാപി യൂയം പ്രത്യേതും നാഖിദ്യധ്വം| ");
INSERT INTO sanmal_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","അപരമേകം ദൃഷ്ടാന്തം ശൃണുത, കശ്ചിദ് ഗൃഹസ്ഥഃ ക്ഷേത്രേ ദ്രാക്ഷാലതാ രോപയിത്വാ തച്ചതുർദിക്ഷു വാരണീം വിധായ തന്മധ്യേ ദ്രാക്ഷായന്ത്രം സ്ഥാപിതവാൻ, മാഞ്ചഞ്ച നിർമ്മിതവാൻ, തതഃ കൃഷകേഷു തത് ക്ഷേത്രം സമർപ്യ സ്വയം ദൂരദേശം ജഗാമ| ");
INSERT INTO sanmal_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","തദനന്തരം ഫലസമയ ഉപസ്ഥിതേ സ ഫലാനി പ്രാപ്തും കൃഷീവലാനാം സമീപം നിജദാസാൻ പ്രേഷയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","കിന്തു കൃഷീവലാസ്തസ്യ താൻ ദാസേയാൻ ധൃത്വാ കഞ്ചന പ്രഹൃതവന്തഃ, കഞ്ചന പാഷാണൈരാഹതവന്തഃ, കഞ്ചന ച ഹതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","പുനരപി സ പ്രഭുഃ പ്രഥമതോഽധികദാസേയാൻ പ്രേഷയാമാസ, കിന്തു തേ താൻ പ്രത്യപി തഥൈവ ചക്രുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","അനന്തരം മമ സുതേ ഗതേ തം സമാദരിഷ്യന്തേ, ഇത്യുക്ത്വാ ശേഷേ സ നിജസുതം തേഷാം സന്നിധിം പ്രേഷയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","കിന്തു തേ കൃഷീവലാഃ സുതം വീക്ഷ്യ പരസ്പരമ് ഇതി മന്ത്രയിതുമ് ആരേഭിരേ, അയമുത്തരാധികാരീ വയമേനം നിഹത്യാസ്യാധികാരം സ്വവശീകരിഷ്യാമഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","പശ്ചാത് തേ തം ധൃത്വാ ദ്രാക്ഷാക്ഷേത്രാദ് ബഹിഃ പാതയിത്വാബധിഷുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","യദാ സ ദ്രാക്ഷാക്ഷേത്രപതിരാഗമിഷ്യതി, തദാ താൻ കൃഷീവലാൻ കിം കരിഷ്യതി? ");
INSERT INTO sanmal_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","തതസ്തേ പ്രത്യവദൻ, താൻ കലുഷിണോ ദാരുണയാതനാഭിരാഹനിഷ്യതി, യേ ച സമയാനുക്രമാത് ഫലാനി ദാസ്യന്തി, താദൃശേഷു കൃഷീവലേഷു ക്ഷേത്രം സമർപയിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","തദാ യീശുനാ തേ ഗദിതാഃ, ഗ്രഹണം ന കൃതം യസ്യ പാഷാണസ്യ നിചായകൈഃ| പ്രധാനപ്രസ്തരഃ കോണേ സഏവ സംഭവിഷ്യതി| ഏതത് പരേശിതുഃ കർമ്മാസ്മദൃഷ്ടാവദ്ഭുതം ഭവേത്| ധർമ്മഗ്രന്ഥേ ലിഖിതമേതദ്വചനം യുഷ്മാഭിഃ കിം നാപാഠി? ");
INSERT INTO sanmal_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","തസ്മാദഹം യുഷ്മാൻ വദാമി, യുഷ്മത്ത ഈശ്വരീയരാജ്യമപനീയ ഫലോത്പാദയിത്രന്യജാതയേ ദായിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","യോ ജന ഏതത്പാഷാണോപരി പതിഷ്യതി, തം സ ഭംക്ഷ്യതേ, കിന്ത്വയം പാഷാണോ യസ്യോപരി പതിഷ്യതി, തം സ ധൂലിവത് ചൂർണീകരിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","തദാനീം പ്രാധനയാജകാഃ ഫിരൂശിനശ്ച തസ്യേമാം ദൃഷ്ടാന്തകഥാം ശ്രുത്വാ സോഽസ്മാനുദ്ദിശ്യ കഥിതവാൻ, ഇതി വിജ്ഞായ തം ധർത്തും ചേഷ്ടിതവന്തഃ; ");
INSERT INTO sanmal_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","കിന്തു ലോകേഭ്യോ ബിഭ്യുഃ, യതോ ലോകൈഃ സ ഭവിഷ്യദ്വാദീത്യജ്ഞായി| ");
INSERT INTO sanmal_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","അനന്തരം യീശുഃ പുനരപി ദൃഷ്ടാന്തേന താൻ അവാദീത്, ");
INSERT INTO sanmal_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","സ്വർഗീയരാജ്യമ് ഏതാദൃശസ്യ നൃപതേഃ സമം, യോ നിജ പുത്രം വിവാഹയൻ സർവ്വാൻ നിമന്ത്രിതാൻ ആനേതും ദാസേയാൻ പ്രഹിതവാൻ, ");
INSERT INTO sanmal_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","കിന്തു തേ സമാഗന്തും നേഷ്ടവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","തതോ രാജാ പുനരപി ദാസാനന്യാൻ ഇത്യുക്ത്വാ പ്രേഷയാമാസ, നിമന്ത്രിതാൻ വദത, പശ്യത, മമ ഭേജ്യമാസാദിതമാസ്തേ, നിജവ്ടഷാദിപുഷ്ടജന്തൂൻ മാരയിത്വാ സർവ്വം ഖാദ്യദ്രവ്യമാസാദിതവാൻ, യൂയം വിവാഹമാഗച്ഛത| ");
INSERT INTO sanmal_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","തഥപി തേ തുച്ഛീകൃത്യ കേചിത് നിജക്ഷേത്രം കേചിദ് വാണിജ്യം പ്രതി സ്വസ്വമാർഗേണ ചലിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","അന്യേ ലോകാസ്തസ്യ ദാസേയാൻ ധൃത്വാ ദൗരാത്മ്യം വ്യവഹൃത്യ താനവധിഷുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","അനന്തരം സ നൃപതിസ്താം വാർത്താം ശ്രുത്വാ ക്രുധ്യൻ സൈന്യാനി പ്രഹിത്യ താൻ ഘാതകാൻ ഹത്വാ തേഷാം നഗരം ദാഹയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","തതഃ സ നിജദാസേയാൻ ബഭാഷേ, വിവാഹീയം ഭോജ്യമാസാദിതമാസ്തേ, കിന്തു നിമന്ത്രിതാ ജനാ അയോഗ്യാഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","തസ്മാദ് യൂയം രാജമാർഗം ഗത്വാ യാവതോ മനുജാൻ പശ്യത, താവതഏവ വിവാഹീയഭോജ്യായ നിമന്ത്രയത| ");
INSERT INTO sanmal_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","തദാ തേ ദാസേയാ രാജമാർഗം ഗത്വാ ഭദ്രാൻ അഭദ്രാൻ വാ യാവതോ ജനാൻ ദദൃശുഃ, താവതഏവ സംഗൃഹ്യാനയൻ; തതോഽഭ്യാഗതമനുജൈ ർവിവാഹഗൃഹമ് അപൂര്യ്യത| ");
INSERT INTO sanmal_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","തദാനീം സ രാജാ സർവ്വാനഭ്യാഗതാൻ ദ്രഷ്ടുമ് അഭ്യന്തരമാഗതവാൻ; തദാ തത്ര വിവാഹീയവസനഹീനമേകം ജനം വീക്ഷ്യ തം ജഗാദ്, ");
INSERT INTO sanmal_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ഹേ മിത്ര,ത്വം വിവാഹീയവസനം വിനാ കഥമത്ര പ്രവിഷ്ടവാൻ? തേന സ നിരുത്തരോ ബഭൂവ| ");
INSERT INTO sanmal_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","തദാ രാജാ നിജാനുചരാൻ അവദത്, ഏതസ്യ കരചരണാൻ ബദ്ധാ യത്ര രോദനം ദന്തൈർദന്തഘർഷണഞ്ച ഭവതി, തത്ര വഹിർഭൂതതമിസ്രേ തം നിക്ഷിപത| ");
INSERT INTO sanmal_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","ഇത്ഥം ബഹവ ആഹൂതാ അൽപേ മനോഭിമതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","അനന്തരം ഫിരൂശിനഃ പ്രഗത്യ യഥാ സംലാപേന തമ് ഉന്മാഥേ പാതയേയുസ്തഥാ മന്ത്രയിത്വാ ");
INSERT INTO sanmal_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ഹേരോദീയമനുജൈഃ സാകം നിജശിഷ്യഗണേന തം പ്രതി കഥയാമാസുഃ, ഹേ ഗുരോ, ഭവാൻ സത്യഃ സത്യമീശ്വരീയമാർഗമുപദിശതി, കമപി മാനുഷം നാനുരുധ്യതേ, കമപി നാപേക്ഷതേ ച, തദ് വയം ജാനീമഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","അതഃ കൈസരഭൂപായ കരോഽസ്മാകം ദാതവ്യോ ന വാ? അത്ര ഭവതാ കിം ബുധ്യതേ? തദ് അസ്മാൻ വദതു| ");
INSERT INTO sanmal_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","തതോ യീശുസ്തേഷാം ഖലതാം വിജ്ഞായ കഥിതവാൻ, രേ കപടിനഃ യുയം കുതോ മാം പരിക്ഷധ്വേ? ");
INSERT INTO sanmal_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","തത്കരദാനസ്യ മുദ്രാം മാം ദർശയത| തദാനീം തൈസ്തസ്യ സമീപം മുദ്രാചതുർഥഭാഗ ആനീതേ ");
INSERT INTO sanmal_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","സ താൻ പപ്രച്ഛ, അത്ര കസ്യേയം മൂർത്തി ർനാമ ചാസ്തേ? തേ ജഗദുഃ, കൈസരഭൂപസ്യ| ");
INSERT INTO sanmal_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","തതഃ സ ഉക്തവാന, കൈസരസ്യ യത് തത് കൈസരായ ദത്ത, ഈശ്വരസ്യ യത് തദ് ഈശ്വരായ ദത്ത| ");
INSERT INTO sanmal_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ഇതി വാക്യം നിശമ്യ തേ വിസ്മയം വിജ്ഞായ തം വിഹായ ചലിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","തസ്മിന്നഹനി സിദൂകിനോഽർഥാത് ശ്മശാനാത് നോത്ഥാസ്യന്തീതി വാക്യം യേ വദന്തി, തേ യീശേाരന്തികമ് ആഗത്യ പപ്രച്ഛുഃ, ");
INSERT INTO sanmal_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ഹേ ഗുരോ, കശ്ചിന്മനുജശ്ചേത് നിഃസന്താനഃ സൻ പ്രാണാൻ ത്യജതി, തർഹി തസ്യ ഭ്രാതാ തസ്യ ജായാം വ്യുഹ്യ ഭ്രാതുഃ സന്താനമ് ഉത്പാദയിഷ്യതീതി മൂസാ ആദിഷ്ടവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","കിന്ത്വസ്മാകമത്ര കേഽപി ജനാഃ സപ്തസഹോദരാ ആസൻ, തേഷാം ജ്യേഷ്ഠ ഏകാം കന്യാം വ്യവഹാത്, അപരം പ്രാണത്യാഗകാലേ സ്വയം നിഃസന്താനഃ സൻ താം സ്ത്രിയം സ്വഭ്രാതരി സമർപിതവാൻ, ");
INSERT INTO sanmal_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","തതോ ദ്വിതീയാദിസപ്തമാന്താശ്ച തഥൈവ ചക്രുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ശേഷേ സാപീ നാരീ മമാര| ");
INSERT INTO sanmal_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","മൃതാനാമ് ഉത്ഥാനസമയേ തേഷാം സപ്താനാം മധ്യേ സാ നാരീ കസ്യ ഭാര്യ്യാ ഭവിഷ്യതി? യസ്മാത് സർവ്വഏവ താം വ്യവഹൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","തതോ യീശുഃ പ്രത്യവാദീത്, യൂയം ധർമ്മപുസ്തകമ് ഈശ്വരീയാം ശക്തിഞ്ച ന വിജ്ഞായ ഭ്രാന്തിമന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","ഉത്ഥാനപ്രാപ്താ ലോകാ ന വിവഹന്തി, ന ച വാചാ ദീയന്തേ, കിന്ത്വീശ്വരസ്യ സ്വർഗസ്ഥദൂതാനാം സദൃശാ ഭവന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","അപരം മൃതാനാമുത്ഥാനമധി യുഷ്മാൻ പ്രതീയമീശ്വരോക്തിഃ, ");
INSERT INTO sanmal_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","\"അഹമിബ്രാഹീമ ഈശ്വര ഇസ്ഹാക ഈശ്വരോ യാകൂബ ഈശ്വര\" ഇതി കിം യുഷ്മാഭി ർനാപാഠി? കിന്ത്വീശ്വരോ ജീവതാമ് ഈശ്വര:, സ മൃതാനാമീശ്വരോ നഹി| ");
INSERT INTO sanmal_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ഇതി ശ്രുത്വാ സർവ്വേ ലോകാസ്തസ്യോപദേശാദ് വിസ്മയം ഗതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","അനന്തരം സിദൂകിനാമ് നിരുത്തരത്വവാർതാം നിശമ്യ ഫിരൂശിന ഏകത്ര മിലിതവന്തഃ, ");
INSERT INTO sanmal_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","തേഷാമേകോ വ്യവസ്ഥാപകോ യീശും പരീക്ഷിതും പപച്ഛ, ");
INSERT INTO sanmal_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","ഹേ ഗുരോ വ്യവസ്ഥാശാസ്ത്രമധ്യേ കാജ്ഞാ ശ്രേഷ്ഠാ? ");
INSERT INTO sanmal_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","തതോ യീശുരുവാച, ത്വം സർവ്വാന്തഃകരണൈഃ സർവ്വപ്രാണൈഃ സർവ്വചിത്തൈശ്ച സാകം പ്രഭൗ പരമേശ്വരേ പ്രീയസ്വ, ");
INSERT INTO sanmal_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ഏഷാ പ്രഥമമഹാജ്ഞാ| തസ്യാഃ സദൃശീ ദ്വിതീയാജ്ഞൈഷാ, ");
INSERT INTO sanmal_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","തവ സമീപവാസിനി സ്വാത്മനീവ പ്രേമ കുരു| ");
INSERT INTO sanmal_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","അനയോ ർദ്വയോരാജ്ഞയോഃ കൃത്സ്നവ്യവസ്ഥായാ ഭവിഷ്യദ്വക്തൃഗ്രന്ഥസ്യ ച ഭാരസ്തിഷ്ഠതി| ");
INSERT INTO sanmal_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","അനന്തരം ഫിരൂശിനാമ് ഏകത്ര സ്ഥിതികാലേ യീശുസ്താൻ പപ്രച്ഛ, ");
INSERT INTO sanmal_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","ഖ്രീഷ്ടമധി യുഷ്മാകം കീദൃഗ്ബോധോ ജായതേ? സ കസ്യ സന്താനഃ? തതസ്തേ പ്രത്യവദൻ, ദായൂദഃ സന്താനഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","തദാ സ ഉക്തവാൻ, തർഹി ദായൂദ് കഥമ് ആത്മാധിഷ്ഠാനേന തം പ്രഭും വദതി ? ");
INSERT INTO sanmal_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","യഥാ മമ പ്രഭുമിദം വാക്യമവദത് പരമേശ്വരഃ| തവാരീൻ പാദപീഠം തേ യാവന്നഹി കരോമ്യഹം| താവത് കാലം മദീയേ ത്വം ദക്ഷപാർശ്വ ഉപാവിശ| അതോ യദി ദായൂദ് തം പ്രഭും വദതി, ർതിഹ സ കഥം തസ്യ സന്താനോ ഭവതി? ");
INSERT INTO sanmal_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","തദാനീം തേഷാം കോപി തദ്വാക്യസ്യ കിമപ്യുത്തരം ദാതും നാശക്നോത്; ");
INSERT INTO sanmal_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","തദ്ദിനമാരഭ്യ തം കിമപി വാക്യം പ്രഷ്ടും കസ്യാപി സാഹസോ നാഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","അനന്തരം യീശു ർജനനിവഹം ശിഷ്യാംശ്ചാവദത്, ");
INSERT INTO sanmal_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","അധ്യാപകാഃ ഫിരൂശിനശ്ച മൂസാസനേ ഉപവിശന്തി, ");
INSERT INTO sanmal_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","അതസ്തേ യുഷ്മാൻ യദ്യത് മന്തുമ് ആജ്ഞാപയന്തി, തത് മന്യധ്വം പാലയധ്വഞ്ച, കിന്തു തേഷാം കർമ്മാനുരൂപം കർമ്മ ന കുരുധ്വം; യതസ്തേഷാം വാക്യമാത്രം സാരം കാര്യ്യേ കിമപി നാസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","തേ ദുർവ്വഹാൻ ഗുരുതരാൻ ഭാരാൻ ബദ്വ്വാ മനുഷ്യാണാം സ്കന്ധേപരി സമർപയന്തി, കിന്തു സ്വയമങ്ഗുല്യൈകയാപി ന ചാലയന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","കേവലം ലോകദർശനായ സർവ്വകർമ്മാണി കുർവ്വന്തി; ഫലതഃ പട്ടബന്ധാൻ പ്രസാര്യ്യ ധാരയന്തി, സ്വവസ്ത്രേഷു ച ദീർഘഗ്രന്ഥീൻ ധാരയന്തി; ");
INSERT INTO sanmal_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ഭോജനഭവന ഉച്ചസ്ഥാനം, ഭജനഭവനേ പ്രധാനമാസനം, ");
INSERT INTO sanmal_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ഹട്ഠേ നമസ്കാരം ഗുരുരിതി സമ്ബോധനഞ്ചൈതാനി സർവ്വാണി വാഞ്ഛന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","കിന്തു യൂയം ഗുരവ ഇതി സമ്ബോധനീയാ മാ ഭവത, യതോ യുഷ്മാകമ് ഏകഃ ഖ്രീഷ്ടഏവ ഗുരു ");
INSERT INTO sanmal_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ര്യൂയം സർവ്വേ മിഥോ ഭ്രാതരശ്ച| പുനഃ പൃഥിവ്യാം കമപി പിതേതി മാ സമ്ബുധ്യധ്വം, യതോ യുഷ്മാകമേകഃ സ്വർഗസ്ഥഏവ പിതാ| ");
INSERT INTO sanmal_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","യൂയം നായകേതി സമ്ഭാഷിതാ മാ ഭവത, യതോ യുഷ്മാകമേകഃ ഖ്രീഷ്ടഏവ നായകഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","അപരം യുഷ്മാകം മധ്യേ യഃ പുമാൻ ശ്രേഷ്ഠഃ സ യുഷ്മാൻ സേവിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","യതോ യഃ സ്വമുന്നമതി, സ നതഃ കരിഷ്യതേ; കിന്തു യഃ കശ്ചിത് സ്വമവനതം കരോതി, സ ഉന്നതഃ കരിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","ഹന്ത കപടിന ഉപാധ്യായാഃ ഫിരൂശിനശ്ച, യൂയം മനുജാനാം സമക്ഷം സ്വർഗദ്വാരം രുന്ധ, യൂയം സ്വയം തേന ന പ്രവിശഥ, പ്രവിവിക്ഷൂനപി വാരയഥ| വത കപടിന ഉപാധ്യായാഃ ഫിരൂശിനശ്ച യൂയം ഛലാദ് ദീർഘം പ്രാർഥ്യ വിധവാനാം സർവ്വസ്വം ഗ്രസഥ, യുഷ്മാകം ഘോരതരദണ്ഡോ ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","ഹന്ത കപടിന ഉപാധ്യായാഃ ഫിരൂശിനശ്ച, യൂയമേകം സ്വധർമ്മാവലമ്ബിനം കർത്തും സാഗരം ഭൂമണ്ഡലഞ്ച പ്രദക്ഷിണീകുരുഥ, ");
INSERT INTO sanmal_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","കഞ്ചന പ്രാപ്യ സ്വതോ ദ്വിഗുണനരകഭാജനം തം കുരുഥ| ");
INSERT INTO sanmal_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","വത അന്ധപഥദർശകാഃ സർവ്വേ, യൂയം വദഥ, മന്ദിരസ്യ ശപഥകരണാത് കിമപി ന ദേയം; കിന്തു മന്ദിരസ്ഥസുവർണസ്യ ശപഥകരണാദ് ദേയം| ");
INSERT INTO sanmal_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ഹേ മൂഢാ ഹേ അന്ധാഃ സുവർണം തത്സുവർണപാവകമന്ദിരമ് ഏതയോരുഭയോ ർമധ്യേ കിം ശ്രേയഃ? ");
INSERT INTO sanmal_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","അന്യച്ച വദഥ, യജ്ഞവേദ്യാഃ ശപഥകരണാത് കിമപി ന ദേയം, കിന്തു തദുപരിസ്ഥിതസ്യ നൈവേദ്യസ്യ ശപഥകരണാദ് ദേയം| ");
INSERT INTO sanmal_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ഹേ മൂഢാ ഹേ അന്ധാഃ, നൈവേദ്യം തന്നൈവേദ്യപാവകവേദിരേതയോരുഭയോ ർമധ്യേ കിം ശ്രേയഃ? ");
INSERT INTO sanmal_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","അതഃ കേനചിദ് യജ്ഞവേദ്യാഃ ശപഥേ കൃതേ തദുപരിസ്ഥസ്യ സർവ്വസ്യ ശപഥഃ ക്രിയതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","കേനചിത് മന്ദിരസ്യ ശപഥേ കൃതേ മന്ദിരതന്നിവാസിനോഃ ശപഥഃ ക്രിയതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","കേനചിത് സ്വർഗസ്യ ശപഥേ കൃതേ ഈശ്വരീയസിംഹാസനതദുപര്യ്യുപവിഷ്ടയോഃ ശപഥഃ ക്രിയതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","ഹന്ത കപടിന ഉപാധ്യായാഃ ഫിരൂശിനശ്ച, യൂയം പോദിനായാഃ സിതച്ഛത്രായാ ജീരകസ്യ ച ദശമാംശാൻ ദത്ഥ, കിന്തു വ്യവസ്ഥായാ ഗുരുതരാൻ ന്യായദയാവിശ്വാസാൻ പരിത്യജഥ; ഇമേ യുഷ്മാഭിരാചരണീയാ അമീ ച ന ലംഘനീയാഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ഹേ അന്ധപഥദർശകാ യൂയം മശകാൻ അപസാരയഥ, കിന്തു മഹാങ്ഗാൻ ഗ്രസഥ| ");
INSERT INTO sanmal_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","ഹന്ത കപടിന ഉപാധ്യായാഃ ഫിരൂശിനശ്ച, യൂയം പാനപാത്രാണാം ഭോജനപാത്രാണാഞ്ച ബഹിഃ പരിഷ്കുരുഥ; കിന്തു തദഭ്യന്തരം ദുരാത്മതയാ കലുഷേണ ച പരിപൂർണമാസ്തേ| ");
INSERT INTO sanmal_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ഹേ അന്ധാഃ ഫിരൂശിലോകാ ആദൗ പാനപാത്രാണാം ഭോജനപാത്രാണാഞ്ചാഭ്യന്തരം പരിഷ്കുരുത, തേന തേഷാം ബഹിരപി പരിഷ്കാരിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","ഹന്ത കപടിന ഉപാധ്യായാഃ ഫിരൂശിനശ്ച, യൂയം ശുക്ലീകൃതശ്മശാനസ്വരൂപാ ഭവഥ, യഥാ ശ്മശാനഭവനസ്യ ബഹിശ്ചാരു, കിന്ത്വഭ്യന്തരം മൃതലോകാനാം കീകശൈഃ സർവ്വപ്രകാരമലേന ച പരിപൂർണമ്; ");
INSERT INTO sanmal_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","തഥൈവ യൂയമപി ലോകാനാം സമക്ഷം ബഹിർധാർമ്മികാഃ കിന്ത്വന്തഃകരണേഷു കേവലകാപട്യാധർമ്മാഭ്യാം പരിപൂർണാഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","ഹാ ഹാ കപടിന ഉപാധ്യായാഃ ഫിരൂശിനശ്ച, യൂയം ഭവിഷ്യദ്വാദിനാം ശ്മശാനഗേഹം നിർമ്മാഥ, സാധൂനാം ശ്മശാനനികേതനം ശോഭയഥ ");
INSERT INTO sanmal_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","വദഥ ച യദി വയം സ്വേഷാം പൂർവ്വപുരുഷാണാം കാല അസ്ഥാസ്യാമ, തർഹി ഭവിഷ്യദ്വാദിനാം ശോണിതപാതനേ തേഷാം സഹഭാഗിനോ നാഭവിഷ്യാമ| ");
INSERT INTO sanmal_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","അതോ യൂയം ഭവിഷ്യദ്വാദിഘാതകാനാം സന്താനാ ഇതി സ്വയമേവ സ്വേഷാം സാക്ഷ്യം ദത്ഥ| ");
INSERT INTO sanmal_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","അതോ യൂയം നിജപൂർവ്വപുരുഷാണാം പരിമാണപാത്രം പരിപൂരയത| ");
INSERT INTO sanmal_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","രേ ഭുജഗാഃ കൃഷ്ണഭുജഗവംശാഃ, യൂയം കഥം നരകദണ്ഡാദ് രക്ഷിഷ്യധ്വേ| ");
INSERT INTO sanmal_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","പശ്യത, യുഷ്മാകമന്തികമ് അഹം ഭവിഷ്യദ്വാദിനോ ബുദ്ധിമത ഉപാധ്യായാംശ്ച പ്രേഷയിഷ്യാമി, കിന്തു തേഷാം കതിപയാ യുഷ്മാഭി ർഘാനിഷ്യന്തേ, ക്രുശേ ച ഘാനിഷ്യന്തേ, കേചിദ് ഭജനഭവനേ കഷാഭിരാഘാനിഷ്യന്തേ, നഗരേ നഗരേ താഡിഷ്യന്തേ ച; ");
INSERT INTO sanmal_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","തേന സത്പുരുഷസ്യ ഹാബിലോ രക്തപാതമാരഭ്യ ബേരിഖിയഃ പുത്രം യം സിഖരിയം യൂയം മന്ദിരയജ്ഞവേദ്യോ ർമധ്യേ ഹതവന്തഃ, തദീയശോണിതപാതം യാവദ് അസ്മിൻ ദേശേ യാവതാം സാധുപുരുഷാണാം ശോണിതപാതോ ഽഭവത് തത് സർവ്വേഷാമാഗസാം ദണ്ഡാ യുഷ്മാസു വർത്തിഷ്യന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","അഹം യുഷ്മാന്ത തഥ്യം വദാമി, വിദ്യമാനേഽസ്മിൻ പുരുഷേ സർവ്വേ വർത്തിഷ്യന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","ഹേ യിരൂശാലമ് ഹേ യിരൂശാലമ് നഗരി ത്വം ഭവിഷ്യദ്വാദിനോ ഹതവതീ, തവ സമീപം പ്രേരിതാംശ്ച പാഷാണൈരാഹതവതീ, യഥാ കുക്കുടീ ശാവകാൻ പക്ഷാധഃ സംഗൃഹ്ലാതി, തഥാ തവ സന്താനാൻ സംഗ്രഹീതും അഹം ബഹുവാരമ് ഐച്ഛം; കിന്തു ത്വം ന സമമന്യഥാഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","പശ്യത യഷ്മാകം വാസസ്ഥാനമ് ഉച്ഛിന്നം ത്യക്ഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","അഹം യുഷ്മാൻ തഥ്യം വദാമി, യഃ പരമേശ്വരസ്യ നാമ്നാഗച്ഛതി, സ ധന്യ ഇതി വാണീം യാവന്ന വദിഷ്യഥ, താവത് മാം പുന ർന ദ്രക്ഷ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","അനന്തരം യീശു ര്യദാ മന്ദിരാദ് ബഹി ർഗച്ഛതി, തദാനീം ശിഷ്യാസ്തം മന്ദിരനിർമ്മാണം ദർശയിതുമാഗതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","തതോ യീശുസ്താനുവാച, യൂയം കിമേതാനി ന പശ്യഥ? യുഷ്മാനഹം സത്യം വദാമി, ഏതന്നിചയനസ്യ പാഷാണൈകമപ്യന്യപാഷാണേाപരി ന സ്ഥാസ്യതി സർവ്വാണി ഭൂമിസാത് കാരിഷ്യന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","അനന്തരം തസ്മിൻ ജൈതുനപർവ്വതോപരി സമുപവിഷ്ടേ ശിഷ്യാസ്തസ്യ സമീപമാഗത്യ ഗുപ്തം പപ്രച്ഛുഃ, ഏതാ ഘടനാഃ കദാ ഭവിഷ്യന്തി? ഭവത ആഗമനസ്യ യുഗാന്തസ്യ ച കിം ലക്ഷ്മ? തദസ്മാൻ വദതു| ");
INSERT INTO sanmal_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","തദാനീം യീശുസ്താനവോചത്, അവധദ്വ്വം, കോപി യുഷ്മാൻ ന ഭ്രമയേത്| ");
INSERT INTO sanmal_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ബഹവോ മമ നാമ ഗൃഹ്ലന്ത ആഗമിഷ്യന്തി, ഖ്രീഷ്ടോഽഹമേവേതി വാചം വദന്തോ ബഹൂൻ ഭ്രമയിഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","യൂയഞ്ച സംഗ്രാമസ്യ രണസ്യ ചാഡമ്ബരം ശ്രോഷ്യഥ, അവധദ്വ്വം തേന ചഞ്ചലാ മാ ഭവത, ഏതാന്യവശ്യം ഘടിഷ്യന്തേ, കിന്തു തദാ യുഗാന്തോ നഹി| ");
INSERT INTO sanmal_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","അപരം ദേശസ്യ വിപക്ഷോ ദേശോ രാജ്യസ്യ വിപക്ഷോ രാജ്യം ഭവിഷ്യതി, സ്ഥാനേ സ്ഥാനേ ച ദുർഭിക്ഷം മഹാമാരീ ഭൂകമ്പശ്ച ഭവിഷ്യന്തി, ");
INSERT INTO sanmal_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ഏതാനി ദുഃഖോപക്രമാഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","തദാനീം ലോകാ ദുഃഖം ഭോജയിതും യുഷ്മാൻ പരകരേഷു സമർപയിഷ്യന്തി ഹനിഷ്യന്തി ച, തഥാ മമ നാമകാരണാദ് യൂയം സർവ്വദേശീയമനുജാനാം സമീപേ ഘൃണാർഹാ ഭവിഷ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","ബഹുഷു വിഘ്നം പ്രാപ്തവത്സു പരസ്പരമ് ഋृതീയാം കൃതവത്സു ച ഏകോഽപരം പരകരേഷു സമർപയിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","തഥാ ബഹവോ മൃഷാഭവിഷ്യദ്വാദിന ഉപസ്ഥായ ബഹൂൻ ഭ്രമയിഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","ദുഷ്കർമ്മണാം ബാഹുല്യാഞ്ച ബഹൂനാം പ്രേമ ശീതലം ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","കിന്തു യഃ കശ്ചിത് ശേഷം യാവദ് ധൈര്യ്യമാശ്രയതേ, സഏവ പരിത്രായിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","അപരം സർവ്വദേശീയലോകാൻ പ്രതിമാക്ഷീ ഭവിതും രാജസ്യ ശുഭസമാചാരഃ സർവ്വജഗതി പ്രചാരിഷ്യതേ, ഏതാദൃശി സതി യുഗാന്ത ഉപസ്ഥാസ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","അതോ യത് സർവ്വനാശകൃദ്ഘൃണാർഹം വസ്തു ദാനിയേൽഭവിഷ്യദ്വദിനാ പ്രോക്തം തദ് യദാ പുണ്യസ്ഥാനേ സ്ഥാപിതം ദ്രക്ഷ്യഥ, (യഃ പഠതി, സ ബുധ്യതാം) ");
INSERT INTO sanmal_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","തദാനീം യേ യിഹൂദീയദേശേ തിഷ്ഠന്തി, തേ പർവ്വതേഷു പലായന്താം| ");
INSERT INTO sanmal_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","യഃ കശ്ചിദ് ഗൃഹപൃഷ്ഠേ തിഷ്ഠതി, സ ഗൃഹാത് കിമപി വസ്ത്വാനേതുമ് അധേा നാവരോഹേത്| ");
INSERT INTO sanmal_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","യശ്ച ക്ഷേത്രേ തിഷ്ഠതി, സോപി വസ്ത്രമാനേതും പരാവൃത്യ ന യായാത്| ");
INSERT INTO sanmal_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","തദാനീം ഗർഭിണീസ്തന്യപായയിത്രീണാം ദുർഗതി ർഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","അതോ യഷ്മാകം പലായനം ശീതകാലേ വിശ്രാമവാരേ വാ യന്ന ഭവേത്, തദർഥം പ്രാർഥയധ്വമ്| ");
INSERT INTO sanmal_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ആ ജഗദാരമ്ഭാദ് ഏതത്കാലപര്യ്യനന്തം യാദൃശഃ കദാപി നാഭവത് ന ച ഭവിഷ്യതി താദൃശോ മഹാക്ലേശസ്തദാനീമ് ഉപസ്ഥാസ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","തസ്യ ക്ലേശസ്യ സമയോ യദി ഹ്സ്വോ ന ക്രിയേത, തർഹി കസ്യാപി പ്രാണിനോ രക്ഷണം ഭവിതും ന ശക്നുയാത്, കിന്തു മനോനീതമനുജാനാം കൃതേ സ കാലോ ഹ്സ്വീകരിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","അപരഞ്ച പശ്യത, ഖ്രീഷ്ടോഽത്ര വിദ്യതേ, വാ തത്ര വിദ്യതേ, തദാനീം യദീ കശ്ചിദ് യുഷ്മാന ഇതി വാക്യം വദതി, തഥാപി തത് ന പ്രതീത്| ");
INSERT INTO sanmal_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","യതോ ഭാക്തഖ്രീഷ്ടാ ഭാക്തഭവിഷ്യദ്വാദിനശ്ച ഉപസ്ഥായ യാനി മഹന്തി ലക്ഷ്മാണി ചിത്രകർമ്മാണി ച പ്രകാശയിഷ്യന്തി, തൈ ര്യദി സമ്ഭവേത് തർഹി മനോനീതമാനവാ അപി ഭ്രാമിഷ്യന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","പശ്യത, ഘടനാതഃ പൂർവ്വം യുഷ്മാൻ വാർത്താമ് അവാദിഷമ്| ");
INSERT INTO sanmal_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","അതഃ പശ്യത, സ പ്രാന്തരേ വിദ്യത ഇതി വാക്യേ കേനചിത് കഥിതേപി ബഹി ർമാ ഗച്ഛത, വാ പശ്യത, സോന്തഃപുരേ വിദ്യതേ, ഏതദ്വാക്യ ഉക്തേപി മാ പ്രതീത| ");
INSERT INTO sanmal_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","യതോ യഥാ വിദ്യുത് പൂർവ്വദിശോ നിർഗത്യ പശ്ചിമദിശം യാവത് പ്രകാശതേ, തഥാ മാനുഷപുത്രസ്യാപ്യാഗമനം ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","യത്ര ശവസ്തിഷ്ഠതി, തത്രേവ ഗൃധ്രാ മിലന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","അപരം തസ്യ ക്ലേശസമയസ്യാവ്യവഹിതപരത്ര സൂര്യ്യസ്യ തേജോ ലോപ്സ്യതേ, ചന്ദ്രമാ ജ്യോസ്നാം ന കരിഷ്യതി, നഭസോ നക്ഷത്രാണി പതിഷ്യന്തി, ഗഗണീയാ ഗ്രഹാശ്ച വിചലിഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","തദാനീമ് ആകാശമധ്യേ മനുജസുതസ്യ ലക്ഷ്മ ദർശിഷ്യതേ, തതോ നിജപരാക്രമേണ മഹാതേജസാ ച മേഘാരൂഢം മനുജസുതം നഭസാഗച്ഛന്തം വിലോക്യ പൃഥിവ്യാഃ സർവ്വവംശീയാ വിലപിഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","തദാനീം സ മഹാശബ്ദായമാനതൂര്യ്യാ വാദകാൻ നിജദൂതാൻ പ്രഹേഷ്യതി, തേ വ്യോമ്ന ഏകസീമാതോഽപരസീമാം യാവത് ചതുർദിശസ്തസ്യ മനോനീതജനാൻ ആനീയ മേലയിഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","ഉഡുമ്ബരപാദപസ്യ ദൃഷ്ടാന്തം ശിക്ഷധ്വം; യദാ തസ്യ നവീനാഃ ശാഖാ ജായന്തേ, പല്ലവാദിശ്ച നിർഗച്ഛതി, തദാ നിദാഘകാലഃ സവിധോ ഭവതീതി യൂയം ജാനീഥ; ");
INSERT INTO sanmal_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","തദ്വദ് ഏതാ ഘടനാ ദൃഷ്ട്വാ സ സമയോ ദ്വാര ഉപാസ്ഥാദ് ഇതി ജാനീത| ");
INSERT INTO sanmal_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","യുഷ്മാനഹം തഥ്യം വദാമി, ഇദാനീന്തനജനാനാം ഗമനാത് പൂർവ്വമേവ താനി സർവ്വാണി ഘടിഷ്യന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","നഭോമേദിന്യോ ർലുപ്തയോരപി മമ വാക് കദാപി ന ലോപ്സ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","അപരം മമ താതം വിനാ മാനുഷഃ സ്വർഗസ്ഥോ ദൂതോ വാ കോപി തദ്ദിനം തദ്ദണ്ഡഞ്ച ന ജ്ഞാപയതി| ");
INSERT INTO sanmal_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","അപരം നോഹേ വിദ്യമാനേ യാദൃശമഭവത് താദൃശം മനുജസുതസ്യാഗമനകാലേപി ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ഫലതോ ജലാപ്ലാവനാത് പൂർവ്വം യദ്ദിനം യാവത് നോഹഃ പോതം നാരോഹത്, താവത്കാലം യഥാ മനുഷ്യാ ഭോജനേ പാനേ വിവഹനേ വിവാഹനേ ച പ്രവൃത്താ ആസൻ; ");
INSERT INTO sanmal_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","അപരമ് ആപ്ലാവിതോയമാഗത്യ യാവത് സകലമനുജാൻ പ്ലാവയിത്വാ നാനയത്, താവത് തേ യഥാ ന വിദാമാസുഃ, തഥാ മനുജസുതാഗമനേപി ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","തദാ ക്ഷേത്രസ്ഥിതയോർദ്വയോരേകോ ധാരിഷ്യതേ, അപരസ്ത്യാജിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","തഥാ പേഷണ്യാ പിംഷത്യോരുഭയോ ര്യോഷിതോരേകാ ധാരിഷ്യതേഽപരാ ത്യാജിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","യുഷ്മാകം പ്രഭുഃ കസ്മിൻ ദണ്ഡ ആഗമിഷ്യതി, തദ് യുഷ്മാഭി ർനാവഗമ്യതേ, തസ്മാത് ജാഗ്രതഃ സന്തസ്തിഷ്ഠത| ");
INSERT INTO sanmal_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","കുത്ര യാമേ സ്തേന ആഗമിഷ്യതീതി ചേദ് ഗൃഹസ്ഥോ ജ്ഞാതുമ് അശക്ഷ്യത്, തർഹി ജാഗരിത്വാ തം സന്ധിം കർത്തിതുമ് അവാരയിഷ്യത് തദ് ജാനീത| ");
INSERT INTO sanmal_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","യുഷ്മാഭിരവധീയതാം, യതോ യുഷ്മാഭി ര്യത്ര ന ബുധ്യതേ, തത്രൈവ ദണ്ഡേ മനുജസുത ആയാസ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","പ്രഭു ർനിജപരിവാരാൻ യഥാകാലം ഭോജയിതും യം ദാസമ് അധ്യക്ഷീകൃത്യ സ്ഥാപയതി, താദൃശോ വിശ്വാസ്യോ ധീമാൻ ദാസഃ കഃ? ");
INSERT INTO sanmal_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","പ്രഭുരാഗത്യ യം ദാസം തഥാചരന്തം വീക്ഷതേ, സഏവ ധന്യഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","യുഷ്മാനഹം സത്യം വദാമി, സ തം നിജസർവ്വസ്വസ്യാധിപം കരിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","കിന്തു പ്രഭുരാഗന്തും വിലമ്ബത ഇതി മനസി ചിന്തയിത്വാ യോ ദുഷ്ടോ ദാസോ ");
INSERT INTO sanmal_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ഽപരദാസാൻ പ്രഹർത്തും മത്താനാം സങ്ഗേ ഭോക്തും പാതുഞ്ച പ്രവർത്തതേ, ");
INSERT INTO sanmal_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","സ ദാസോ യദാ നാപേക്ഷതേ, യഞ്ച ദണ്ഡം ന ജാനാതി, തത്കാലഏവ തത്പ്രഭുരുപസ്ഥാസ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","തദാ തം ദണ്ഡയിത്വാ യത്ര സ്ഥാനേ രോദനം ദന്തഘർഷണഞ്ചാസാതേ, തത്ര കപടിഭിഃ സാകം തദ്ദശാം നിരൂപയിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","യാ ദശ കന്യാഃ പ്രദീപാൻ ഗൃഹ്ലത്യോ വരം സാക്ഷാത് കർത്തും ബഹിരിതാഃ, താഭിസ്തദാ സ്വർഗീയരാജ്യസ്യ സാദൃശ്യം ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","താസാം കന്യാനാം മധ്യേ പഞ്ച സുധിയഃ പഞ്ച ദുർധിയ ആസൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","യാ ദുർധിയസ്താഃ പ്രദീപാൻ സങ്ഗേ ഗൃഹീത്വാ തൈലം ന ജഗൃഹുഃ, ");
INSERT INTO sanmal_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","കിന്തു സുധിയഃ പ്രദീപാൻ പാത്രേണ തൈലഞ്ച ജഗൃഹുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","അനന്തരം വരേ വിലമ്ബിതേ താഃ സർവ്വാ നിദ്രാവിഷ്ടാ നിദ്രാം ജഗ്മുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","അനന്തരമ് അർദ്ധരാത്രേ പശ്യത വര ആഗച്ഛതി, തം സാക്ഷാത് കർത്തും ബഹിര്യാതേതി ജനരവാത് ");
INSERT INTO sanmal_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","താഃ സർവ്വാഃ കന്യാ ഉത്ഥായ പ്രദീപാൻ ആസാദയിതും ആരഭന്ത| ");
INSERT INTO sanmal_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","തതോ ദുർധിയഃ സുധിയ ഊചുഃ, കിഞ്ചിത് തൈലം ദത്ത, പ്രദീപാ അസ്മാകം നിർവ്വാണാഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","കിന്തു സുധിയഃ പ്രത്യവദൻ, ദത്തേ യുഷ്മാനസ്മാംശ്ച പ്രതി തൈലം ന്യൂനീഭവേത്, തസ്മാദ് വിക്രേതൃണാം സമീപം ഗത്വാ സ്വാർഥം തൈലം ക്രീണീത| ");
INSERT INTO sanmal_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","തദാ താസു ക്രേതും ഗതാസു വര ആജഗാമ, തതോ യാഃ സജ്ജിതാ ആസൻ, താസ്തേന സാകം വിവാഹീയം വേശ്മ പ്രവിവിശുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","അനന്തരം ദ്വാരേ രുദ്ധേ അപരാഃ കന്യാ ആഗത്യ ജഗദുഃ, ഹേ പ്രഭോ, ഹേ പ്രഭോ, അസ്മാൻ പ്രതി ദ്വാരം മോചയ| ");
INSERT INTO sanmal_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","കിന്തു സ ഉക്തവാൻ, തഥ്യം വദാമി, യുഷ്മാനഹം ന വേദ്മി| ");
INSERT INTO sanmal_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","അതോ ജാഗ്രതഃ സന്തസ്തിഷ്ഠത, മനുജസുതഃ കസ്മിൻ ദിനേ കസ്മിൻ ദണ്ഡേ വാഗമിഷ്യതി, തദ് യുഷ്മാഭി ർന ജ്ഞായതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","അപരം സ ഏതാദൃശഃ കസ്യചിത് പുംസസ്തുല്യഃ, യോ ദൂരദേശം പ്രതി യാത്രാകാലേ നിജദാസാൻ ആഹൂയ തേഷാം സ്വസ്വസാമർഥ്യാനുരൂപമ് ");
INSERT INTO sanmal_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ഏകസ്മിൻ മുദ്രാണാം പഞ്ച പോടലികാഃ അന്യസ്മിംശ്ച ദ്വേ പോടലികേ അപരസ്മിംശ്ച പോടലികൈകാമ് ഇത്ഥം പ്രതിജനം സമർപ്യ സ്വയം പ്രവാസം ഗതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","അനന്തരം യോ ദാസഃ പഞ്ച പോടലികാഃ ലബ്ധവാൻ, സ ഗത്വാ വാണിജ്യം വിധായ താ ദ്വിഗുണീചകാര| ");
INSERT INTO sanmal_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","യശ്ച ദാസോ ദ്വേ പോടലികേ അലഭത, സോപി താ മുദ്രാ ദ്വിഗുണീചകാര| ");
INSERT INTO sanmal_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","കിന്തു യോ ദാസ ഏകാം പോടലികാം ലബ്ധവാൻ, സ ഗത്വാ ഭൂമിം ഖനിത്വാ തന്മധ്യേ നിജപ്രഭോസ്താ മുദ്രാ ഗോപയാഞ്ചകാര| ");
INSERT INTO sanmal_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","തദനന്തരം ബഹുതിഥേ കാലേ ഗതേ തേഷാം ദാസാനാം പ്രഭുരാഗത്യ തൈർദാസൈഃ സമം ഗണയാഞ്ചകാര| ");
INSERT INTO sanmal_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","തദാനീം യഃ പഞ്ച പോടലികാഃ പ്രാപ്തവാൻ സ താ ദ്വിഗുണീകൃതമുദ്രാ ആനീയ ജഗാദ; ഹേ പ്രഭോ, ഭവതാ മയി പഞ്ച പോടലികാഃ സമർപിതാഃ, പശ്യതു, താ മയാ ദ്വിഗുണീകൃതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","തദാനീം തസ്യ പ്രഭുസ്തമുവാച, ഹേ ഉത്തമ വിശ്വാസ്യ ദാസ, ത്വം ധന്യോസി, സ്തോകേന വിശ്വാസ്യോ ജാതഃ, തസ്മാത് ത്വാം ബഹുവിത്താധിപം കരോമി, ത്വം സ്വപ്രഭോഃ സുഖസ്യ ഭാഗീ ഭവ| ");
INSERT INTO sanmal_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","തതോ യേന ദ്വേ പോടലികേ ലബ്ധേ സോപ്യാഗത്യ ജഗാദ, ഹേ പ്രഭോ, ഭവതാ മയി ദ്വേ പോടലികേ സമർപിതേ, പശ്യതു തേ മയാ ദ്വിഗുണീകൃതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","തേന തസ്യ പ്രഭുസ്തമവോചത്, ഹേ ഉത്തമ വിശ്വാസ്യ ദാസ, ത്വം ധന്യോസി, സ്തോകേന വിശ്വാസ്യോ ജാതഃ, തസ്മാത് ത്വാം ബഹുദ്രവിണാധിപം കരോമി, ത്വം നിജപ്രഭോഃ സുഖസ്യ ഭാഗീ ഭവ| ");
INSERT INTO sanmal_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","അനന്തരം യ ഏകാം പോടലികാം ലബ്ധവാൻ, സ ഏത്യ കഥിതവാൻ, ഹേ പ്രഭോ, ത്വാം കഠിനനരം ജ്ഞാതവാൻ, ത്വയാ യത്ര നോപ്തം, തത്രൈവ കൃത്യതേ, യത്ര ച ന കീർണം, തത്രൈവ സംഗൃഹ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","അതോഹം സശങ്കഃ സൻ ഗത്വാ തവ മുദ്രാ ഭൂമധ്യേ സംഗോപ്യ സ്ഥാപിതവാൻ, പശ്യ, തവ യത് തദേവ ഗൃഹാണ| ");
INSERT INTO sanmal_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","തദാ തസ്യ പ്രഭുഃ പ്രത്യവദത് രേ ദുഷ്ടാലസ ദാസ, യത്രാഹം ന വപാമി, തത്ര ഛിനദ്മി, യത്ര ച ന കിരാമി, തത്രേവ സംഗൃഹ്ലാമീതി ചേദജാനാസ്തർഹി ");
INSERT INTO sanmal_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","വണിക്ഷു മമ വിത്താർപണം തവോചിതമാസീത്, യേനാഹമാഗത്യ വൃദ്വ്യാ സാകം മൂലമുദ്രാഃ പ്രാപ്സ്യമ്| ");
INSERT INTO sanmal_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","അതോസ്മാത് താം പോടലികാമ് ആദായ യസ്യ ദശ പോടലികാഃ സന്തി തസ്മിന്നർപയത| ");
INSERT INTO sanmal_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","യേന വർദ്വ്യതേ തസ്മിന്നൈവാർപിഷ്യതേ, തസ്യൈവ ച ബാഹുല്യം ഭവിഷ്യതി, കിന്തു യേന ന വർദ്വ്യതേ, തസ്യാന്തികേ യത് കിഞ്ചന തിഷ്ഠതി, തദപി പുനർനേഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","അപരം യൂയം തമകർമ്മണ്യം ദാസം നീത്വാ യത്ര സ്ഥാനേ ക്രന്ദനം ദന്തഘർഷണഞ്ച വിദ്യേതേ, തസ്മിൻ ബഹിർഭൂതതമസി നിക്ഷിപത| ");
INSERT INTO sanmal_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","യദാ മനുജസുതഃ പവിത്രദൂതാൻ സങ്ഗിനഃ കൃത്വാ നിജപ്രഭാവേനാഗത്യ നിജതേജോമയേ സിംഹാസനേ നിവേക്ഷ്യതി, ");
INSERT INTO sanmal_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","തദാ തത്സമ്മുഖേ സർവ്വജാതീയാ ജനാ സംമേലിഷ്യന്തി| തതോ മേഷപാലകോ യഥാ ഛാഗേഭ്യോഽവീൻ പൃഥക് കരോതി തഥാ സോപ്യേകസ്മാദന്യമ് ഇത്ഥം താൻ പൃഥക കൃത്വാവീൻ ");
INSERT INTO sanmal_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ദക്ഷിണേ ഛാഗാംശ്ച വാമേ സ്ഥാപയിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","തതഃ പരം രാജാ ദക്ഷിണസ്ഥിതാൻ മാനവാൻ വദിഷ്യതി, ആഗച്ഛത മത്താതസ്യാനുഗ്രഹഭാജനാനി, യുഷ്മത്കൃത ആ ജഗദാരമ്ഭത് യദ് രാജ്യമ് ആസാദിതം തദധികുരുത| ");
INSERT INTO sanmal_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","യതോ ബുഭുക്ഷിതായ മഹ്യം ഭോജ്യമ് അദത്ത, പിപാസിതായ പേയമദത്ത, വിദേശിനം മാം സ്വസ്ഥാനമനയത, ");
INSERT INTO sanmal_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","വസ്ത്രഹീനം മാം വസനം പര്യ്യധാപയത, പീഡീതം മാം ദ്രഷ്ടുമാഗച്ഛത, കാരാസ്ഥഞ്ച മാം വീക്ഷിതുമ ആഗച്ഛത| ");
INSERT INTO sanmal_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","തദാ ധാർമ്മികാഃ പ്രതിവദിഷ്യന്തി, ഹേ പ്രഭോ, കദാ ത്വാം ക്ഷുധിതം വീക്ഷ്യ വയമഭോജയാമ? വാ പിപാസിതം വീക്ഷ്യ അപായയാമ? ");
INSERT INTO sanmal_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","കദാ വാ ത്വാം വിദേശിനം വിലോക്യ സ്വസ്ഥാനമനയാമ? കദാ വാ ത്വാം നഗ്നം വീക്ഷ്യ വസനം പര്യ്യധാപയാമ? ");
INSERT INTO sanmal_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","കദാ വാ ത്വാം പീഡിതം കാരാസ്ഥഞ്ച വീക്ഷ്യ ത്വദന്തികമഗച്ഛാമ? ");
INSERT INTO sanmal_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","തദാനീം രാജാ താൻ പ്രതിവദിഷ്യതി, യുഷ്മാനഹം സത്യം വദാമി, മമൈതേഷാം ഭ്രാതൃണാം മധ്യേ കഞ്ചനൈകം ക്ഷുദ്രതമം പ്രതി യദ് അകുരുത, തന്മാം പ്രത്യകുരുത| ");
INSERT INTO sanmal_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","പശ്ചാത് സ വാമസ്ഥിതാൻ ജനാൻ വദിഷ്യതി, രേ ശാപഗ്രസ്താഃ സർവ്വേ, ശൈതാനേ തസ്യ ദൂതേഭ്യശ്ച യോഽനന്തവഹ്നിരാസാദിത ആസ്തേ, യൂയം മദന്തികാത് തമഗ്നിം ഗച്ഛത| ");
INSERT INTO sanmal_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","യതോ ക്ഷുധിതായ മഹ്യമാഹാരം നാദത്ത, പിപാസിതായ മഹ്യം പേയം നാദത്ത, ");
INSERT INTO sanmal_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","വിദേശിനം മാം സ്വസ്ഥാനം നാനയത, വസനഹീനം മാം വസനം ന പര്യ്യധാപയത, പീഡിതം കാരാസ്ഥഞ്ച മാം വീക്ഷിതും നാഗച്ഛത| ");
INSERT INTO sanmal_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","തദാ തേ പ്രതിവദിഷ്യന്തി, ഹേ പ്രഭോ, കദാ ത്വാം ക്ഷുധിതം വാ പിപാസിതം വാ വിദേശിനം വാ നഗ്നം വാ പീഡിതം വാ കാരാസ്ഥം വീക്ഷ്യ ത്വാം നാസേവാമഹി? ");
INSERT INTO sanmal_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","തദാ സ താൻ വദിഷ്യതി, തഥ്യമഹം യുഷ്മാൻ ബ്രവീമി, യുഷ്മാഭിരേഷാം കഞ്ചന ക്ഷോദിഷ്ഠം പ്രതി യന്നാകാരി, തന്മാം പ്രത്യേവ നാകാരി| ");
INSERT INTO sanmal_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","പശ്ചാദമ്യനന്തശാസ്തിം കിന്തു ധാർമ്മികാ അനന്തായുഷം ഭോക്തും യാസ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","യീശുരേതാൻ പ്രസ്താവാൻ സമാപ്യ ശിഷ്യാനൂചേ, ");
INSERT INTO sanmal_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","യുഷ്മാഭി ർജ്ഞാതം ദിനദ്വയാത് പരം നിസ്താരമഹ ഉപസ്ഥാസ്യതി, തത്ര മനുജസുതഃ ക്രുശേന ഹന്തും പരകരേഷു സമർപിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","തതഃ പരം പ്രധാനയാജകാധ്യാപകപ്രാഞ്ചഃ കിയഫാനാമ്നോ മഹായാജകസ്യാട്ടാലികായാം മിലിത്വാ ");
INSERT INTO sanmal_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","കേനോപായേന യീശും ധൃത്വാ ഹന്തും ശക്നുയുരിതി മന്ത്രയാഞ്ചക്രുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","കിന്തു തൈരുക്തം മഹകാലേ ന ധർത്തവ്യഃ, ധൃതേ പ്രജാനാം കലഹേന ഭവിതും ശക്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","തതോ ബൈഥനിയാപുരേ ശിമോനാഖ്യസ്യ കുഷ്ഠിനോ വേശ്മനി യീശൗ തിഷ്ഠതി ");
INSERT INTO sanmal_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","കാചന യോഷാ ശ്വേതോപലഭാജനേന മഹാർഘ്യം സുഗന്ധി തൈലമാനീയ ഭോജനായോപവിശതസ്തസ്യ ശിരോഭ്യഷേചത്| ");
INSERT INTO sanmal_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","കിന്തു തദാലോക്യ തച്ഛിഷ്യൈഃ കുപിതൈരുക്തം, കുത ഇത്ഥമപവ്യയതേ? ");
INSERT INTO sanmal_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ചേദിദം വ്യക്രേഷ്യത, തർഹി ഭൂരിമൂല്യം പ്രാപ്യ ദരിദ്രേഭ്യോ വ്യതാരിഷ്യത| ");
INSERT INTO sanmal_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","യീശുനാ തദവഗത്യ തേ സമുദിതാഃ, യോഷാമേനാം കുതോ ദുഃഖിനീം കുരുഥ, സാ മാം പ്രതി സാധു കർമ്മാകാർഷീത്| ");
INSERT INTO sanmal_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","യുഷ്മാകമം സമീപേ ദരിദ്രാഃ സതതമേവാസതേ, കിന്തു യുഷ്മാകമന്തികേഹം നാസേ സതതം| ");
INSERT INTO sanmal_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","സാ മമ കായോപരി സുഗന്ധിതൈലം സിക്ത്വാ മമ ശ്മശാനദാനകർമ്മാകാർഷീത്| ");
INSERT INTO sanmal_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","അതോഹം യുഷ്മാൻ തഥ്യം വദാമി സർവ്വസ്മിൻ ജഗതി യത്ര യത്രൈഷ സുസമാചാരഃ പ്രചാരിഷ്യതേ, തത്ര തത്രൈതസ്യാ നാര്യ്യാഃ സ്മരണാർഥമ് കർമ്മേദം പ്രചാരിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","തതോ ദ്വാദശശിഷ്യാണാമ് ഈഷ്കരിയോതീയയിഹൂദാനാമക ഏകഃ ശിഷ്യഃ പ്രധാനയാജകാനാമന്തികം ഗത്വാ കഥിതവാൻ, ");
INSERT INTO sanmal_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","യദി യുഷ്മാകം കരേഷു യീശും സമർപയാമി, തർഹി കിം ദാസ്യഥ? തദാനീം തേ തസ്മൈ ത്രിംശന്മുദ്രാ ദാതും സ്ഥിരീകൃതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","സ തദാരഭ്യ തം പരകരേഷു സമർപയിതും സുയോഗം ചേഷ്ടിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","അനന്തരം കിണ്വശൂന്യപൂപപർവ്വണഃ പ്രഥമേഹ്നി ശിഷ്യാ യീശുമ് ഉപഗത്യ പപ്രച്ഛുഃ ഭവത്കൃതേ കുത്ര വയം നിസ്താരമഹഭോജ്യമ് ആയോജയിഷ്യാമഃ? ഭവതഃ കേച്ഛാ? ");
INSERT INTO sanmal_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","തദാ സ ഗദിതവാൻ, മധ്യേനഗരമമുകപുംസഃ സമീപം വ്രജിത്വാ വദത, ഗുരു ർഗദിതവാൻ, മത്കാലഃ സവിധഃ, സഹ ശിഷ്യൈസ്ത്വദാലയേ നിസ്താരമഹഭോജ്യം ഭോക്ഷ്യേ| ");
INSERT INTO sanmal_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","തദാ ശിഷ്യാ യീശോസ്താദൃശനിദേശാനുരൂപകർമ്മ വിധായ തത്ര നിസ്താരമഹഭോജ്യമാസാദയാമാസുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","തതഃ സന്ധ്യായാം സത്യാം ദ്വാദശഭിഃ ശിഷ്യൈഃ സാകം സ ന്യവിശത്| ");
INSERT INTO sanmal_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","അപരം ഭുഞ്ജാന ഉക്തവാൻ യുഷ്മാൻ തഥ്യം വദാമി, യുഷ്മാകമേകോ മാം പരകരേഷു സമർപയിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","തദാ തേഽതീവ ദുഃഖിതാ ഏകൈകശോ വക്തുമാരേഭിരേ, ഹേ പ്രഭോ, സ കിമഹം? ");
INSERT INTO sanmal_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","തതഃ സ ജഗാദ, മയാ സാകം യോ ജനോ ഭോജനപാത്രേ കരം സംക്ഷിപതി, സ ഏവ മാം പരകരേഷു സമർപയിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","മനുജസുതമധി യാദൃശം ലിഖിതമാസ്തേ, തദനുരൂപാ തദ്ഗതി ർഭവിഷ്യതി; കിന്തു യേന പുംസാ സ പരകരേഷു സമർപയിഷ്യതേ, ഹാ ഹാ ചേത് സ നാജനിഷ്യത, തദാ തസ്യ ക്ഷേമമഭവിഷ്യത്| ");
INSERT INTO sanmal_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","തദാ യിഹൂദാനാമാ യോ ജനസ്തം പരകരേഷു സമർപയിഷ്യതി, സ ഉക്തവാൻ, ഹേ ഗുരോ, സ കിമഹം? തതഃ സ പ്രത്യുക്തവാൻ, ത്വയാ സത്യം ഗദിതമ്| ");
INSERT INTO sanmal_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","അനന്തരം തേഷാമശനകാലേ യീശുഃ പൂപമാദായേശ്വരീയഗുണാനനൂദ്യ ഭംക്ത്വാ ശിഷ്യേഭ്യഃ പ്രദായ ജഗാദ, മദ്വപുഃസ്വരൂപമിമം ഗൃഹീത്വാ ഖാദത| ");
INSERT INTO sanmal_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","പശ്ചാത് സ കംസം ഗൃഹ്ലൻ ഈശ്വരീയഗുണാനനൂദ്യ തേഭ്യഃ പ്രദായ കഥിതവാൻ, സർവ്വൈ ര്യുഷ്മാഭിരനേന പാതവ്യം, ");
INSERT INTO sanmal_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","യസ്മാദനേകേഷാം പാപമർഷണായ പാതിതം യന്മന്നൂത്നനിയമരൂപശോണിതം തദേതത്| ");
INSERT INTO sanmal_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","അപരമഹം നൂത്നഗോസ്തനീരസം ന പാസ്യാമി, താവത് ഗോസ്തനീഫലരസം പുനഃ കദാപി ന പാസ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","പശ്ചാത് തേ ഗീതമേകം സംഗീയ ജൈതുനാഖ്യഗിരിം ഗതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","തദാനീം യീശുസ്താനവോചത്, അസ്യാം രജന്യാമഹം യുഷ്മാകം സർവ്വേഷാം വിഘ്നരൂപോ ഭവിഷ്യാമി, യതോ ലിഖിതമാസ്തേ, \"മേഷാണാം രക്ഷകോ യസ്തം പ്രഹരിഷ്യാമ്യഹം തതഃ| മേഷാണാം നിവഹോ നൂനം പ്രവികീർണോ ഭവിഷ്യതി\"|| ");
INSERT INTO sanmal_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","കിന്തു ശ്മശാനാത് സമുത്ഥായ യുഷ്മാകമഗ്രേഽഹം ഗാലീലം ഗമിഷ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","പിതരസ്തം പ്രോവാച, ഭവാംശ്ചേത് സർവ്വേഷാം വിഘ്നരൂപോ ഭവതി, തഥാപി മമ ന ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","തതോ യീശുനാ സ ഉക്തഃ, തുഭ്യമഹം തഥ്യം കഥയാമി, യാമിന്യാമസ്യാം ചരണായുധസ്യ രവാത് പൂർവ്വം ത്വം മാം ത്രി ർനാങ്ഗീകരിഷ്യസി| ");
INSERT INTO sanmal_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","തതഃ പിതര ഉദിതവാൻ, യദ്യപി ത്വയാ സമം മർത്തവ്യം, തഥാപി കദാപി ത്വാം ന നാങ്ഗീകരിഷ്യാമി; തഥൈവ സർവ്വേ ശിഷ്യാശ്ചോചുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","അനന്തരം യീശുഃ ശിഷ്യൈഃ സാകം ഗേത്ശിമാനീനാമകം സ്ഥാനം പ്രസ്ഥായ തേഭ്യഃ കഥിതവാൻ, അദഃ സ്ഥാനം ഗത്വാ യാവദഹം പ്രാർഥയിഷ്യേ താവദ് യൂയമത്രോപവിശത| ");
INSERT INTO sanmal_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","പശ്ചാത് സ പിതരം സിവദിയസുതൗ ച സങ്ഗിനഃ കൃത്വാ ഗതവാൻ, ശോകാകുലോഽതീവ വ്യഥിതശ്ച ബഭൂവ| ");
INSERT INTO sanmal_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","താനവാദീച്ച മൃതിയാതനേവ മത്പ്രാണാനാം യാതനാ ജായതേ, യൂയമത്ര മയാ സാർദ്ധം ജാഗൃത| ");
INSERT INTO sanmal_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","തതഃ സ കിഞ്ചിദ്ദൂരം ഗത്വാധോമുഖഃ പതൻ പ്രാർഥയാഞ്ചക്രേ, ഹേ മത്പിതര്യദി ഭവിതും ശക്നോതി, തർഹി കംസോഽയം മത്തോ ദൂരം യാതു; കിന്തു മദിച്ഛാവത് ന ഭവതു, ത്വദിച്ഛാവദ് ഭവതു| ");
INSERT INTO sanmal_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","തതഃ സ ശിഷ്യാനുപേത്യ താൻ നിദ്രതോ നിരീക്ഷ്യ പിതരായ കഥയാമാസ, യൂയം മയാ സാകം ദണ്ഡമേകമപി ജാഗരിതും നാശൻകുത? ");
INSERT INTO sanmal_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","പരീക്ഷായാം ന പതിതും ജാഗൃത പ്രാർഥയധ്വഞ്ച; ആത്മാ സമുദ്യതോസ്തി, കിന്തു വപു ർദുർബ്ബലം| ");
INSERT INTO sanmal_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","സ ദ്വിതീയവാരം പ്രാർഥയാഞ്ചക്രേ, ഹേ മത്താത, ന പീതേ യദി കംസമിദം മത്തോ ദൂരം യാതും ന ശക്നോതി, തർഹി ത്വദിച്ഛാവദ് ഭവതു| ");
INSERT INTO sanmal_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","സ പുനരേത്യ താൻ നിദ്രതോ ദദർശ, യതസ്തേഷാം നേത്രാണി നിദ്രയാ പൂർണാന്യാസൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","പശ്ചാത് സ താൻ വിഹായ വ്രജിത്വാ തൃതീയവാരം പൂർവ്വവത് കഥയൻ പ്രാർഥിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","തതഃ ശിഷ്യാനുപാഗത്യ ഗദിതവാൻ, സാമ്പ്രതം ശയാനാഃ കിം വിശ്രാമ്യഥ? പശ്യത, സമയ ഉപാസ്ഥാത്, മനുജസുതഃ പാപിനാം കരേഷു സമർപ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ഉത്തിഷ്ഠത, വയം യാമഃ, യോ മാം പരകരേഷു മസർപയിഷ്യതി, പശ്യത, സ സമീപമായാതി| ");
INSERT INTO sanmal_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ഏതത്കഥാകഥനകാലേ ദ്വാദശശിഷ്യാണാമേകോ യിഹൂദാനാമകോ മുഖ്യയാജകലോകപ്രാചീനൈഃ പ്രഹിതാൻ അസിധാരിയഷ്ടിധാരിണോ മനുജാൻ ഗൃഹീത്വാ തത്സമീപമുപതസ്ഥൗ| ");
INSERT INTO sanmal_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","അസൗ പരകരേഷ്വർപയിതാ പൂർവ്വം താൻ ഇത്ഥം സങ്കേതയാമാസ, യമഹം ചുമ്ബിഷ്യേ, സോഽസൗ മനുജഃ,സഏവ യുഷ്മാഭി ർധാര്യ്യതാം| ");
INSERT INTO sanmal_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","തദാ സ സപദി യീശുമുപാഗത്യ ഹേ ഗുരോ, പ്രണമാമീത്യുക്ത്വാ തം ചുചുമ്ബേ| ");
INSERT INTO sanmal_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","തദാ യീശുസ്തമുവാച, ഹേ മിത്രം കിമർഥമാഗതോസി? തദാ തൈരാഗത്യ യീശുരാക്രമ്യ ദഘ്രേ| ");
INSERT INTO sanmal_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","തതോ യീശോഃ സങ്ഗിനാമേകഃ കരം പ്രസാര്യ്യ കോഷാദസിം ബഹിഷ്കൃത്യ മഹായാജകസ്യ ദാസമേകമാഹത്യ തസ്യ കർണം ചിച്ഛേദ| ");
INSERT INTO sanmal_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","തതോ യീശുസ്തം ജഗാദ, ഖഡ്ഗം സ്വസ്ഥാനേे നിധേഹി യതോ യേ യേ ജനാ അസിം ധാരയന്തി, തഏവാസിനാ വിനശ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","അപരം പിതാ യഥാ മദന്തികം സ്വർഗീയദൂതാനാം ദ്വാദശവാഹിനീതോഽധികം പ്രഹിണുയാത് മയാ തമുദ്ദിശ്യേദാനീമേവ തഥാ പ്രാർഥയിതും ന ശക്യതേ, ത്വയാ കിമിത്ഥം ജ്ഞായതേ? ");
INSERT INTO sanmal_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","തഥാ സതീത്ഥം ഘടിഷ്യതേ ധർമ്മപുസ്തകസ്യ യദിദം വാക്യം തത് കഥം സിധ്യേത്? ");
INSERT INTO sanmal_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","തദാനീം യീശു ർജനനിവഹം ജഗാദ, യൂയം ഖഡ്ഗയഷ്ടീൻ ആദായ മാം കിം ചൗരം ധർത്തുമായാതാഃ? അഹം പ്രത്യഹം യുഷ്മാഭിഃ സാകമുപവിശ്യ സമുപാദിശം, തദാ മാം നാധരത; ");
INSERT INTO sanmal_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","കിന്തു ഭവിഷ്യദ്വാദിനാം വാക്യാനാം സംസിദ്ധയേ സർവ്വമേതദഭൂത്| തദാ സർവ്വേ ശിഷ്യാസ്തം വിഹായ പലായന്ത| ");
INSERT INTO sanmal_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","അനന്തരം തേ മനുജാ യീശും ധൃത്വാ യത്രാധ്യാപകപ്രാഞ്ചഃ പരിഷദം കുർവ്വന്ത ഉപാവിശൻ തത്ര കിയഫാനാाമകമഹായാജകസ്യാന്തികം നിന്യുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","കിന്തു ശേഷേ കിം ഭവിഷ്യതീതി വേത്തും പിതരോ ദൂരേ തത്പശ്ചാദ് വ്രജിത്വാ മഹായാജകസ്യാട്ടാലികാം പ്രവിശ്യ ദാസൈഃ സഹിത ഉപാവിശത്| ");
INSERT INTO sanmal_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","തദാനീം പ്രധാനയാജകപ്രാചീനമന്ത്രിണഃ സർവ്വേ യീശും ഹന്തും മൃഷാസാക്ഷ്യമ് അലിപ്സന്ത, ");
INSERT INTO sanmal_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","കിന്തു ന ലേഭിരേ| അനേകേഷു മൃഷാസാക്ഷിഷ്വാഗതേഷ്വപി തന്ന പ്രാപുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ശേഷേ ദ്വൗ മൃഷാസാക്ഷിണാവാഗത്യ ജഗദതുഃ, പുമാനയമകഥയത്, അഹമീശ്വരമന്ദിരം ഭംക്ത്വാ ദിനത്രയമധ്യേ തന്നിർമ്മാതും ശക്നോമി| ");
INSERT INTO sanmal_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","തദാ മഹായാജക ഉത്ഥായ യീശുമ് അവാദീത്| ത്വം കിമപി ന പ്രതിവദസി? ത്വാമധി കിമേതേ സാക്ഷ്യം വദന്തി? ");
INSERT INTO sanmal_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","കിന്തു യീശു ർമൗനീഭൂയ തസ്യൗ| തതോ മഹായാജക ഉക്തവാൻ, ത്വാമ് അമരേശ്വരനാമ്നാ ശപയാമി, ത്വമീശ്വരസ്യ പുത്രോഽഭിഷിക്തോ ഭവസി നവേതി വദ| ");
INSERT INTO sanmal_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","യീശുഃ പ്രത്യവദത്, ത്വം സത്യമുക്തവാൻ; അഹം യുഷ്മാൻ തഥ്യം വദാമി, ഇതഃപരം മനുജസുതം സർവ്വശക്തിമതോ ദക്ഷിണപാർശ്വേ സ്ഥാതും ഗഗണസ്ഥം ജലധരാനാരുഹ്യായാന്തം വീക്ഷധ്വേ| ");
INSERT INTO sanmal_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","തദാ മഹായാജകോ നിജവസനം ഛിത്ത്വാ ജഗാദ, ഏഷ ഈശ്വരം നിന്ദിതവാൻ, അസ്മാകമപരസാക്ഷ്യേണ കിം പ്രയോജനം? പശ്യത, യൂയമേവാസ്യാസ്യാദ് ഈശ്വരനിന്ദാം ശ്രുതവന്തഃ, ");
INSERT INTO sanmal_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","യുഷ്മാഭിഃ കിം വിവിച്യതേ? തേ പ്രത്യൂചുഃ, വധാർഹോഽയം| ");
INSERT INTO sanmal_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","തതോ ലോകൈസ്തദാസ്യേ നിഷ്ഠീവിതം കേചിത് പ്രതലമാഹത്യ കേചിച്ച ചപേടമാഹത്യ ബഭാഷിരേ, ");
INSERT INTO sanmal_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ഹേ ഖ്രീഷ്ട ത്വാം കശ്ചപേടമാഹതവാൻ? ഇതി ഗണയിത്വാ വദാസ്മാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","പിതരോ ബഹിരങ്ഗന ഉപവിശതി, തദാനീമേകാ ദാസീ തമുപാഗത്യ ബഭാഷേ, ത്വം ഗാലീലീയയീശോഃ സഹചരഏകഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","കിന്തു സ സർവ്വേഷാം സമക്ഷമ് അനങ്ഗീകൃത്യാവാദീത്, ത്വയാ യദുച്യതേ, തദർഥമഹം ന വേദ്മി| ");
INSERT INTO sanmal_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","തദാ തസ്മിൻ ബഹിർദ്വാരം ഗതേ ഽന്യാ ദാസീ തം നിരീക്ഷ്യ തത്രത്യജനാനവദത്, അയമപി നാസരതീയയീശുനാ സാർദ്ധമ് ആസീത്| ");
INSERT INTO sanmal_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","തതഃ സ ശപഥേന പുനരനങ്ഗീകൃത്യ കഥിതവാൻ, തം നരം ന പരിചിനോമി| ");
INSERT INTO sanmal_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ക്ഷണാത് പരം തിഷ്ഠന്തോ ജനാ ഏത്യ പിതരമ് അവദൻ, ത്വമവശ്യം തേഷാമേക ഇതി ത്വദുച്ചാരണമേവ ദ്യോതയതി| ");
INSERT INTO sanmal_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","കിന്തു സോഽഭിശപ്യ കഥിതവാൻ, തം ജനം നാഹം പരിചിനോമി, തദാ സപദി കുക്കുടോ രുരാവ| ");
INSERT INTO sanmal_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","കുക്കുടരവാത് പ്രാക് ത്വം മാം ത്രിരപാഹ്നോഷ്യസേ, യൈഷാ വാഗ് യീശുനാവാദി താം പിതരഃ സംസ്മൃത്യ ബഹിരിത്വാ ഖേദാദ് ഭൃശം ചക്രന്ദ| ");
INSERT INTO sanmal_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","പ്രഭാതേ ജാതേ പ്രധാനയാജകലോകപ്രാചീനാ യീശും ഹന്തും തത്പ്രതികൂലം മന്ത്രയിത്വാ ");
INSERT INTO sanmal_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","തം ബദ്വ്വാ നീത്വാ പന്തീയപീലാതാഖ്യാധിപേ സമർപയാമാസുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","തതോ യീശോഃ പരകരേവ്വർപയിതാ യിഹൂദാസ്തത്പ്രാണാദണ്ഡാജ്ഞാം വിദിത്വാ സന്തപ്തമനാഃ പ്രധാനയാജകലോകപ്രാചീനാനാം സമക്ഷം താസ്ത്രീംശന്മുദ്രാഃ പ്രതിദായാവാദീത്, ");
INSERT INTO sanmal_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ഏതന്നിരാഗോനരപ്രാണപരകരാർപണാത് കലുഷം കൃതവാനഹം| തദാ ത ഉദിതവന്തഃ, തേനാസ്മാകം കിം? ത്വയാ തദ് ബുധ്യതാമ്| ");
INSERT INTO sanmal_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","തതോ യിഹൂദാ മന്ദിരമധ്യേ താ മുദ്രാ നിക്ഷിപ്യ പ്രസ്ഥിതവാൻ ഇത്വാ ച സ്വയമാത്മാനമുദ്ബബന്ധ| ");
INSERT INTO sanmal_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","പശ്ചാത് പ്രധാനയാജകാസ്താ മുദ്രാ ആദായ കഥിതവന്തഃ, ഏതാ മുദ്രാഃ ശോണിതമൂല്യം തസ്മാദ് ഭാണ്ഡാഗാരേ ന നിധാതവ്യാഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","അനന്തരം തേ മന്ത്രയിത്വാ വിദേശിനാം ശ്മശാനസ്ഥാനായ താഭിഃ കുലാലസ്യ ക്ഷേത്രമക്രീണൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","അതോഽദ്യാപി തത്സ്ഥാനം രക്തക്ഷേത്രം വദന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ഇത്ഥം സതി ഇസ്രായേലീയസന്താനൈ ര്യസ്യ മൂല്യം നിരുപിതം, തസ്യ ത്രിംശന്മുദ്രാമാനം മൂല്യം ");
INSERT INTO sanmal_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","മാം പ്രതി പരമേശ്വരസ്യാദേശാത് തേഭ്യ ആദീയത, തേന ച കുലാലസ്യ ക്ഷേത്രം ക്രീതമിതി യദ്വചനം യിരിമിയഭവിഷ്യദ്വാദിനാ പ്രോക്തം തത് തദാസിധ്യത്| ");
INSERT INTO sanmal_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","അനന്തരം യീശൗ തദധിപതേഃ സമ്മുഖ ഉപതിഷ്ഠതി സ തം പപ്രച്ഛ, ത്വം കിം യിഹൂദീയാനാം രാജാ? തദാ യീശുസ്തമവദത്, ത്വം സത്യമുക്തവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","കിന്തു പ്രധാനയാജകപ്രാചീനൈരഭിയുക്തേന തേന കിമപി ന പ്രത്യവാദി| ");
INSERT INTO sanmal_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","തതഃ പീലാതേന സ ഉദിതഃ, ഇമേ ത്വത്പ്രതികൂലതഃ കതി കതി സാക്ഷ്യം ദദതി, തത് ത്വം ന ശൃണോഷി? ");
INSERT INTO sanmal_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","തഥാപി സ തേഷാമേകസ്യാപി വചസ ഉത്തരം നോദിതവാൻ; തേന സോഽധിപതി ർമഹാചിത്രം വിദാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","അന്യച്ച തന്മഹകാലേഽധിപതേരേതാദൃശീ രാതിരാസീത്, പ്രജാ യം കഞ്ചന ബന്ധിനം യാചന്തേ, തമേവ സ മോചയതീതി| ");
INSERT INTO sanmal_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","തദാനീം ബരബ്ബാനാമാ കശ്ചിത് ഖ്യാതബന്ധ്യാസീത്| ");
INSERT INTO sanmal_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","തതഃ പീലാതസ്തത്ര മിലിതാൻ ലോകാൻ അപൃച്ഛത്, ഏഷ ബരബ്ബാ ബന്ധീ ഖ്രീഷ്ടവിഖ്യാതോ യീശുശ്ചൈതയോഃ കം മോചയിഷ്യാമി? യുഷ്മാകം കിമീപ്സിതം? ");
INSERT INTO sanmal_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","തൈരീർഷ്യയാ സ സമർപിത ഇതി സ ജ്ഞാതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","അപരം വിചാരാസനോപവേശനകാലേ പീലാതസ്യ പത്നീ ഭൃത്യം പ്രഹിത്യ തസ്മൈ കഥയാമാസ, തം ധാർമ്മികമനുജം പ്രതി ത്വയാ കിമപി ന കർത്തവ്യം; യസ്മാത് തത്കൃതേഽദ്യാഹം സ്വപ്നേ പ്രഭൂതകഷ്ടമലഭേ| ");
INSERT INTO sanmal_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","അനന്തരം പ്രധാനയാജകപ്രാചീനാ ബരബ്ബാം യാചിത്വാദാതും യീശുഞ്ച ഹന്തും സകലലോകാൻ പ്രാവർത്തയൻ| ");
INSERT INTO sanmal_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","തതോഽധിപതിസ്താൻ പൃഷ്ടവാൻ, ഏതയോഃ കമഹം മോചയിഷ്യാമി? യുഷ്മാകം കേച്ഛാ? തേ പ്രോചു ർബരബ്ബാം| ");
INSERT INTO sanmal_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","തദാ പീലാതഃ പപ്രച്ഛ, തർഹി യം ഖ്രീഷ്ടം വദന്തി, തം യീശും കിം കരിഷ്യാമി? സർവ്വേ കഥയാമാസുഃ, സ ക്രുശേന വിധ്യതാം| ");
INSERT INTO sanmal_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","തതോഽധിപതിരവാദീത്, കുതഃ? കിം തേനാപരാദ്ധം? കിന്തു തേ പുനരുചൈ ർജഗദുഃ, സ ക്രുശേന വിധ്യതാം| ");
INSERT INTO sanmal_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","തദാ നിജവാക്യമഗ്രാഹ്യമഭൂത്, കലഹശ്ചാപ്യഭൂത്, പീലാത ഇതി വിലോക്യ ലോകാനാം സമക്ഷം തോയമാദായ കരൗ പ്രക്ഷാല്യാവോചത്, ഏതസ്യ ധാർമ്മികമനുഷ്യസ്യ ശോണിതപാതേ നിർദോഷോഽഹം, യുഷ്മാഭിരേവ തദ് ബുധ്യതാം| ");
INSERT INTO sanmal_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","തദാ സർവ്വാഃ പ്രജാഃ പ്രത്യവോചൻ, തസ്യ ശോണിതപാതാപരാധോഽസ്മാകമ് അസ്മത്സന്താനാനാഞ്ചോപരി ഭവതു| ");
INSERT INTO sanmal_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","തതഃ സ തേഷാം സമീപേ ബരബ്ബാം മോചയാമാസ യീശുന്തു കഷാഭിരാഹത്യ ക്രുശേന വേധിതും സമർപയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","അനന്തരമ് അധിപതേഃ സേനാ അധിപതേ ർഗൃഹം യീശുമാനീയ തസ്യ സമീപേ സേനാസമൂഹം സംജഗൃഹുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","തതസ്തേ തസ്യ വസനം മോചയിത്വാ കൃഷ്ണലോഹിതവർണവസനം പരിധാപയാമാസുഃ ");
INSERT INTO sanmal_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","കണ്ടകാനാം മുകുടം നിർമ്മായ തച്ഛിരസി ദദുഃ, തസ്യ ദക്ഷിണകരേ വേത്രമേകം ദത്ത്വാ തസ്യ സമ്മുഖേ ജാനൂനി പാതയിത്വാ, ഹേ യിഹൂദീയാനാം രാജൻ, തുഭ്യം നമ ഇത്യുക്ത്വാ തം തിരശ്ചക്രുഃ, ");
INSERT INTO sanmal_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","തതസ്തസ്യ ഗാത്രേ നിഷ്ഠീവം ദത്വാ തേന വേത്രേണ ശിര ആജഘ്നുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ഇത്ഥം തം തിരസ്കൃത്യ തദ് വസനം മോചയിത്വാ പുനർനിജവസനം പരിധാപയാഞ്ചക്രുഃ, തം ക്രുശേന വേധിതും നീതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","പശ്ചാത്തേ ബഹിർഭൂയ കുരീണീയം ശിമോന്നാമകമേകം വിലോക്യ ക്രുശം വോഢും തമാദദിരേ| ");
INSERT INTO sanmal_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","അനന്തരം ഗുൽഗൽതാമ് അർഥാത് ശിരസ്കപാലനാമകസ്ഥാനമു പസ്ഥായ തേ യീശവേ പിത്തമിശ്രിതാമ്ലരസം പാതും ദദുഃ, ");
INSERT INTO sanmal_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","കിന്തു സ തമാസ്വാദ്യ ന പപൗ| ");
INSERT INTO sanmal_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","തദാനീം തേ തം ക്രുശേന സംവിധ്യ തസ്യ വസനാനി ഗുടികാപാതേന വിഭജ്യ ജഗൃഹുഃ, തസ്മാത്, വിഭജന്തേഽധരീയം മേ തേ മനുഷ്യാഃ പരസ്പരം| മദുത്തരീയവസ്ത്രാർഥം ഗുടികാം പാതയന്തി ച|| യദേതദ്വചനം ഭവിഷ്യദ്വാദിഭിരുക്തമാസീത്, തദാ തദ് അസിധ്യത്, ");
INSERT INTO sanmal_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","പശ്ചാത് തേ തത്രോപവിശ്യ തദ്രക്ഷണകർവ്വണി നിയുക്താസ്തസ്ഥുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","അപരമ് ഏഷ യിഹൂദീയാനാം രാജാ യീശുരിത്യപവാദലിപിപത്രം തച്ഛിരസ ഊർദ്വ്വേ യോജയാമാസുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","തതസ്തസ്യ വാമേ ദക്ഷിണേ ച ദ്വൗ ചൈരൗ തേന സാകം ക്രുശേന വിവിധുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","തദാ പാന്ഥാ നിജശിരോ ലാഡയിത്വാ തം നിന്ദന്തോ ജഗദുഃ, ");
INSERT INTO sanmal_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ഹേ ഈശ്വരമന്ദിരഭഞ്ജക ദിനത്രയേ തന്നിർമ്മാതഃ സ്വം രക്ഷ, ചേത്ത്വമീശ്വരസുതസ്തർഹി ക്രുശാദവരോഹ| ");
INSERT INTO sanmal_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","പ്രധാനയാജകാധ്യാപകപ്രാചീനാശ്ച തഥാ തിരസ്കൃത്യ ജഗദുഃ, ");
INSERT INTO sanmal_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","സോഽന്യജനാനാവത്, കിന്തു സ്വമവിതും ന ശക്നോതി| യദീസ്രായേലോ രാജാ ഭവേത്, തർഹീദാനീമേവ ക്രുശാദവരോഹതു, തേന തം വയം പ്രത്യേഷ്യാമഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","സ ഈശ്വരേ പ്രത്യാശാമകരോത്, യദീശ്വരസ്തസ്മിൻ സന്തുഷ്ടസ്തർഹീദാനീമേവ തമവേത്, യതഃ സ ഉക്തവാൻ അഹമീശ്വരസുതഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","യൗ സ്തേനൗ സാകം തേന ക്രുശേന വിദ്ധൗ തൗ തദ്വദേവ തം നിനിന്ദതുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","തദാ ദ്വിതീയയാമാത് തൃതീയയാമം യാവത് സർവ്വദേശേ തമിരം ബഭൂവ, ");
INSERT INTO sanmal_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","തൃതീയയാമേ \"ഏലീ ഏലീ ലാമാ ശിവക്തനീ\", അർഥാത് മദീശ്വര മദീശ്വര കുതോ മാമത്യാക്ഷീഃ? യീശുരുച്ചൈരിതി ജഗാദ| ");
INSERT INTO sanmal_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","തദാ തത്ര സ്ഥിതാഃ കേചിത് തത് ശ്രുത്വാ ബഭാഷിരേ, അയമ് ഏലിയമാഹൂയതി| ");
INSERT INTO sanmal_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","തേഷാം മധ്യാദ് ഏകഃ ശീഘ്രം ഗത്വാ സ്പഞ്ജം ഗൃഹീത്വാ തത്രാമ്ലരസം ദത്ത്വാ നലേന പാതും തസ്മൈ ദദൗ| ");
INSERT INTO sanmal_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ഇതരേഽകഥയൻ തിഷ്ഠത, തം രക്ഷിതുമ് ഏലിയ ആയാതി നവേതി പശ്യാമഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","യീശുഃ പുനരുചൈരാഹൂയ പ്രാണാൻ ജഹൗ| ");
INSERT INTO sanmal_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","തതോ മന്ദിരസ്യ വിച്ഛേദവസനമ് ഊർദ്വ്വാദധോ യാവത് ഛിദ്യമാനം ദ്വിധാഭവത്, ");
INSERT INTO sanmal_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ഭൂമിശ്ചകമ്പേ ഭൂധരോവ്യദീര്യ്യത ച| ശ്മശാനേ മുക്തേ ഭൂരിപുണ്യവതാം സുപ്തദേഹാ ഉദതിഷ്ഠൻ, ");
INSERT INTO sanmal_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ശ്മശാനാദ് വഹിർഭൂയ തദുത്ഥാനാത് പരം പുണ്യപുരം ഗത്വാ ബഹുജനാൻ ദർശയാമാസുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","യീശുരക്ഷണായ നിയുക്തഃ ശതസേനാപതിസ്തത്സങ്ഗിനശ്ച താദൃശീം ഭൂകമ്പാദിഘടനാം ദൃഷ്ട്വാ ഭീതാ അവദൻ, ഏഷ ഈശ്വരപുത്രോ ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","യാ ബഹുയോഷിതോ യീശും സേവമാനാ ഗാലീലസ്തത്പശ്ചാദാഗതാസ്താസാം മധ്യേ ");
INSERT INTO sanmal_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","മഗ്ദലീനീ മരിയമ് യാകൂബ്യോശ്യോ ർമാതാ യാ മരിയമ് സിബദിയപുത്രയോ ർമാതാ ച യോഷിത ഏതാ ദൂരേ തിഷ്ഠന്ത്യോ ദദൃശുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","സന്ധ്യായാം സത്യമ് അരിമഥിയാനഗരസ്യ യൂഷഫ്നാമാ ധനീ മനുജോ യീശോഃ ശിഷ്യത്വാത് ");
INSERT INTO sanmal_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","പീലാതസ്യ സമീപം ഗത്വാ യീശോഃ കായം യയാചേ, തേന പീലാതഃ കായം ദാതുമ് ആദിദേശ| ");
INSERT INTO sanmal_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","യൂഷഫ് തത്കായം നീത്വാ ശുചിവസ്ത്രേണാച്ഛാദ്യ ");
INSERT INTO sanmal_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","സ്വാർഥം ശൈലേ യത് ശ്മശാനം ചഖാന, തന്മധ്യേ തത്കായം നിധായ തസ്യ ദ്വാരി വൃഹത്പാഷാണം ദദൗ| ");
INSERT INTO sanmal_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","കിന്തു മഗ്ദലീനീ മരിയമ് അന്യമരിയമ് ഏതേ സ്ത്രിയൗ തത്ര ശ്മശാനസമ്മുഖ ഉപവിവിശതുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","തദനന്തരം നിസ്താരോത്സവസ്യായോജനദിനാത് പരേഽഹനി പ്രധാനയാജകാഃ ഫിരൂശിനശ്ച മിലിത്വാ പീലാതമുപാഗത്യാകഥയൻ, ");
INSERT INTO sanmal_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ഹേ മഹേച്ഛ സ പ്രതാരകോ ജീവന അകഥയത്, ദിനത്രയാത് പരം ശ്മശാനാദുത്ഥാസ്യാമി തദ്വാക്യം സ്മരാമോ വയം; ");
INSERT INTO sanmal_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","തസ്മാത് തൃതീയദിനം യാവത് തത് ശ്മശാനം രക്ഷിതുമാദിശതു, നോചേത് തച്ഛിഷ്യാ യാമിന്യാമാഗത്യ തം ഹൃത്വാ ലോകാൻ വദിഷ്യന്തി, സ ശ്മശാനാദുദതിഷ്ഠത്, തഥാ സതി പ്രഥമഭ്രാന്തേഃ ശേഷീയഭ്രാന്തി ർമഹതീ ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","തദാ പീലാത അവാദീത്, യുഷ്മാകം സമീപേ രക്ഷിഗണ ആസ്തേ, യൂയം ഗത്വാ യഥാ സാധ്യം രക്ഷയത| ");
INSERT INTO sanmal_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","തതസ്തേ ഗത്വാ തദ്ദൂाരപാഷാണം മുദ്രാങ്കിതം കൃത്വാ രക്ഷിഗണം നിയോജ്യ ശ്മശാനം രക്ഷയാമാസുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","തതഃ പരം വിശ്രാമവാരസ്യ ശേഷേ സപ്താഹപ്രഥമദിനസ്യ പ്രഭോതേ ജാതേ മഗ്ദലീനീ മരിയമ് അന്യമരിയമ് ച ശ്മശാനം ദ്രഷ്ടുമാഗതാ| ");
INSERT INTO sanmal_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","തദാ മഹാൻ ഭൂകമ്പോഽഭവത്; പരമേശ്വരീയദൂതഃ സ്വർഗാദവരുഹ്യ ശ്മശാനദ്വാരാത് പാഷാണമപസാര്യ്യ തദുപര്യ്യുപവിവേശ| ");
INSERT INTO sanmal_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","തദ്വദനം വിദ്യുദ്വത് തേജോമയം വസനം ഹിമശുഭ്രഞ്ച| ");
INSERT INTO sanmal_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","തദാനീം രക്ഷിണസ്തദ്ഭയാത് കമ്പിതാ മൃതവദ് ബഭൂവഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","സ ദൂതോ യോഷിതോ ജഗാദ, യൂയം മാ ഭൈഷ്ട, ക്രുശഹതയീശും മൃഗയധ്വേ തദഹം വേദ്മി| ");
INSERT INTO sanmal_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","സോഽത്ര നാസ്തി, യഥാവദത് തഥോത്ഥിതവാൻ; ഏതത് പ്രഭോഃ ശയനസ്ഥാനം പശ്യത| ");
INSERT INTO sanmal_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","തൂർണം ഗത്വാ തച്ഛിഷ്യാൻ ഇതി വദത, സ ശ്മശാനാദ് ഉദതിഷ്ഠത്, യുഷ്മാകമഗ്രേ ഗാലീലം യാസ്യതി യൂയം തത്ര തം വീക്ഷിഷ്യധ്വേ, പശ്യതാഹം വാർത്താമിമാം യുഷ്മാനവാദിഷം| ");
INSERT INTO sanmal_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","തതസ്താ ഭയാത് മഹാനന്ദാഞ്ച ശ്മശാനാത് തൂർണം ബഹിർഭൂയ തച്ഛിഷ്യാൻ വാർത്താം വക്തും ധാവിതവത്യഃ| കിന്തു ശിഷ്യാൻ വാർത്താം വക്തും യാന്തി, തദാ യീശു ർദർശനം ദത്ത്വാ താ ജഗാദ, ");
INSERT INTO sanmal_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","യുഷ്മാകം കല്യാണം ഭൂയാത്, തതസ്താ ആഗത്യ തത്പാദയോഃ പതിത്വാ പ്രണേമുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","യീശുസ്താ അവാദീത്, മാ ബിഭീത, യൂയം ഗത്വാ മമ ഭ്രാതൃൻ ഗാലീലം യാതും വദത, തത്ര തേ മാം ദ്രക്ഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","സ്ത്രിയോ ഗച്ഛന്തി, തദാ രക്ഷിണാം കേചിത് പുരം ഗത്വാ യദ്യദ് ഘടിതം തത്സർവ്വം പ്രധാനയാജകാൻ ജ്ഞാപിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","തേ പ്രാചീനൈഃ സമം സംസദം കൃത്വാ മന്ത്രയന്തോ ബഹുമുദ്രാഃ സേനാഭ്യോ ദത്ത്വാവദൻ, ");
INSERT INTO sanmal_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","അസ്മാസു നിദ്രിതേഷു തച്ഛിഷ്യാ യാമിന്യാമാഗത്യ തം ഹൃത്വാനയൻ, ഇതി യൂയം പ്രചാരയത| ");
INSERT INTO sanmal_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","യദ്യേതദധിപതേഃ ശ്രോത്രഗോചരീഭവേത്, തർഹി തം ബോധയിത്വാ യുഷ്മാനവിഷ്യാമഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","തതസ്തേ മുദ്രാ ഗൃഹീത്വാ ശിക്ഷാനുരൂപം കർമ്മ ചക്രുഃ, യിഹൂദീയാനാം മധ്യേ തസ്യാദ്യാപി കിംവദന്തീ വിദ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ഏകാദശ ശിഷ്യാ യീശുനിരൂപിതാഗാലീലസ്യാദ്രിം ഗത്വാ ");
INSERT INTO sanmal_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","തത്ര തം സംവീക്ഷ്യ പ്രണേമുഃ, കിന്തു കേചിത് സന്ദിഗ്ധവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","യീശുസ്തേഷാം സമീപമാഗത്യ വ്യാഹൃതവാൻ, സ്വർഗമേദിന്യോഃ സർവ്വാധിപതിത്വഭാരോ മയ്യർപിത ആസ്തേ| ");
INSERT INTO sanmal_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","അതോ യൂയം പ്രയായ സർവ്വദേശീയാൻ ശിഷ്യാൻ കൃത്വാ പിതുഃ പുത്രസ്യ പവിത്രസ്യാത്മനശ്ച നാമ്നാ താനവഗാഹയത; അഹം യുഷ്മാൻ യദ്യദാദിശം തദപി പാലയിതും താനുപാദിശത| ");
INSERT INTO sanmal_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","പശ്യത, ജഗദന്തം യാവത് സദാഹം യുഷ്മാഭിഃ സാകം തിഷ്ഠാമി| ഇതി|");
INSERT INTO sanmal_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ഈശ്വരപുത്രസ്യ യീശുഖ്രീഷ്ടസ്യ സുസംവാദാരമ്ഭഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ഭവിഷ്യദ്വാദിനാം ഗ്രന്ഥേഷു ലിപിരിത്ഥമാസ്തേ, പശ്യ സ്വകീയദൂതന്തു തവാഗ്രേ പ്രേഷയാമ്യഹമ്| ഗത്വാ ത്വദീയപന്ഥാനം സ ഹി പരിഷ്കരിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","\"പരമേശസ്യ പന്ഥാനം പരിഷ്കുരുത സർവ്വതഃ| തസ്യ രാജപഥഞ്ചൈവ സമാനം കുരുതാധുനാ| \" ഇത്യേതത് പ്രാന്തരേ വാക്യം വദതഃ കസ്യചിദ്രവഃ|| ");
INSERT INTO sanmal_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","സഏവ യോഹൻ പ്രാന്തരേ മജ്ജിതവാൻ തഥാ പാപമാർജനനിമിത്തം മനോവ്യാവർത്തകമജ്ജനസ്യ കഥാഞ്ച പ്രചാരിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","തതോ യിഹൂദാദേശയിരൂശാലമ്നഗരനിവാസിനഃ സർവ്വേ ലോകാ ബഹി ർഭൂത്വാ തസ്യ സമീപമാഗത്യ സ്വാനി സ്വാനി പാപാന്യങ്ഗീകൃത്യ യർദ്ദനനദ്യാം തേന മജ്ജിതാ ബഭൂവുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","അസ്യ യോഹനഃ പരിധേയാനി ക്രമേലകലോമജാനി, തസ്യ കടിബന്ധനം ചർമ്മജാതമ്, തസ്യ ഭക്ഷ്യാണി ച ശൂകകീടാ വന്യമധൂനി ചാസൻ| ");
INSERT INTO sanmal_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","സ പ്രചാരയൻ കഥയാഞ്ചക്രേ, അഹം നമ്രീഭൂയ യസ്യ പാദുകാബന്ധനം മോചയിതുമപി ന യോഗ്യോസ്മി, താദൃശോ മത്തോ ഗുരുതര ഏകഃ പുരുഷോ മത്പശ്ചാദാഗച്ഛതി| ");
INSERT INTO sanmal_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","അഹം യുഷ്മാൻ ജലേ മജ്ജിതവാൻ കിന്തു സ പവിത്ര ആത്മാനി സംമജ്ജയിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","അപരഞ്ച തസ്മിന്നേവ കാലേ ഗാലീൽപ്രദേശസ്യ നാസരദ്ഗ്രാമാദ് യീശുരാഗത്യ യോഹനാ യർദ്ദനനദ്യാം മജ്ജിതോഽഭൂത്| ");
INSERT INTO sanmal_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","സ ജലാദുത്ഥിതമാത്രോ മേഘദ്വാരം മുക്തം കപോതവത് സ്വസ്യോപരി അവരോഹന്തമാത്മാനഞ്ച ദൃഷ്ടവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ത്വം മമ പ്രിയഃ പുത്രസ്ത്വയ്യേവ മമമഹാസന്തോഷ ഇയമാകാശീയാ വാണീ ബഭൂവ| ");
INSERT INTO sanmal_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","തസ്മിൻ കാലേ ആത്മാ തം പ്രാന്തരമധ്യം നിനായ| ");
INSERT INTO sanmal_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","അഥ സ ചത്വാരിംശദ്ദിനാനി തസ്മിൻ സ്ഥാനേ വന്യപശുഭിഃ സഹ തിഷ്ഠൻ ശൈതാനാ പരീക്ഷിതഃ; പശ്ചാത് സ്വർഗീയദൂതാസ്തം സിഷേവിരേ| ");
INSERT INTO sanmal_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","അനന്തരം യോഹനി ബന്ധനാലയേ ബദ്ധേ സതി യീശു ർഗാലീൽപ്രദേശമാഗത്യ ഈശ്വരരാജ്യസ്യ സുസംവാദം പ്രചാരയൻ കഥയാമാസ, ");
INSERT INTO sanmal_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","കാലഃ സമ്പൂർണ ഈശ്വരരാജ്യഞ്ച സമീപമാഗതം; അതോഹേതോ ര്യൂയം മനാംസി വ്യാവർത്തയധ്വം സുസംവാദേ ച വിശ്വാസിത| ");
INSERT INTO sanmal_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","തദനന്തരം സ ഗാലീലീയസമുദ്രസ്യ തീരേ ഗച്ഛൻ ശിമോൻ തസ്യ ഭ്രാതാ അന്ദ്രിയനാമാ ച ഇമൗ ദ്വൗ ജനൗ മത്സ്യധാരിണൗ സാഗരമധ്യേ ജാലം പ്രക്ഷിപന്തൗ ദൃഷ്ട്വാ താവവദത്, ");
INSERT INTO sanmal_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","യുവാം മമ പശ്ചാദാഗച്ഛതം, യുവാമഹം മനുഷ്യധാരിണൗ കരിഷ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","തതസ്തൗ തത്ക്ഷണമേവ ജാലാനി പരിത്യജ്യ തസ്യ പശ്ചാത് ജഗ്മതുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","തതഃ പരം തത്സ്ഥാനാത് കിഞ്ചിദ് ദൂരം ഗത്വാ സ സിവദീപുത്രയാകൂബ് തദ്ഭ്രാതൃയോഹൻ ച ഇമൗ നൗകായാം ജാലാനാം ജീർണമുദ്ധാരയന്തൗ ദൃഷ്ട്വാ താവാഹൂയത്| ");
INSERT INTO sanmal_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","തതസ്തൗ നൗകായാം വേതനഭുഗ്ഭിഃ സഹിതം സ്വപിതരം വിഹായ തത്പശ്ചാദീയതുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","തതഃ പരം കഫർനാഹൂമ്നാമകം നഗരമുപസ്ഥായ സ വിശ്രാമദിവസേ ഭജനഗ്രഹം പ്രവിശ്യ സമുപദിദേശ| ");
INSERT INTO sanmal_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","തസ്യോപദേശാല്ലോകാ ആശ്ചര്യ്യം മേനിരേ യതഃ സോധ്യാപകാഇവ നോപദിശൻ പ്രഭാവവാനിവ പ്രോപദിദേശ| ");
INSERT INTO sanmal_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","അപരഞ്ച തസ്മിൻ ഭജനഗൃഹേ അപവിത്രഭൂതേന ഗ്രസ്ത ഏകോ മാനുഷ ആസീത്| സ ചീത്ശബ്ദം കൃത്വാ കഥയാഞ്ചകേ ");
INSERT INTO sanmal_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ഭോ നാസരതീയ യീശോ ത്വമസ്മാൻ ത്യജ, ത്വയാ സഹാസ്മാകം കഃ സമ്ബന്ധഃ? ത്വം കിമസ്മാൻ നാശയിതും സമാഗതഃ? ത്വമീശ്വരസ്യ പവിത്രലോക ഇത്യഹം ജാനാമി| ");
INSERT INTO sanmal_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","തദാ യീശുസ്തം തർജയിത്വാ ജഗാദ തൂഷ്ണീം ഭവ ഇതോ ബഹിർഭവ ച| ");
INSERT INTO sanmal_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","തതഃ സോഽപവിത്രഭൂതസ്തം സമ്പീഡ്യ അത്യുചൈശ്ചീത്കൃത്യ നിർജഗാമ| ");
INSERT INTO sanmal_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","തേനൈവ സർവ്വേ ചമത്കൃത്യ പരസ്പരം കഥയാഞ്ചക്രിരേ, അഹോ കിമിദം? കീദൃശോഽയം നവ്യ ഉപദേശഃ? അനേന പ്രഭാവേനാപവിത്രഭൂതേഷ്വാജ്ഞാപിതേഷു തേ തദാജ്ഞാനുവർത്തിനോ ഭവന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","തദാ തസ്യ യശോ ഗാലീലശ്ചതുർദിക്സ്ഥസർവ്വദേശാൻ വ്യാപ്നോത്| ");
INSERT INTO sanmal_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","അപരഞ്ച തേ ഭജനഗൃഹാദ് ബഹി ർഭൂത്വാ യാകൂബ്യോഹൻഭ്യാം സഹ ശിമോന ആന്ദ്രിയസ്യ ച നിവേശനം പ്രവിവിശുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","തദാ പിതരസ്യ ശ്വശ്രൂർജ്വരപീഡിതാ ശയ്യായാമാസ്ത ഇതി തേ തം ഝടിതി വിജ്ഞാപയാഞ്ചക്രുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","തതഃ സ ആഗത്യ തസ്യാ ഹസ്തം ധൃത്വാ താമുദസ്ഥാപയത്; തദൈവ താം ജ്വരോഽത്യാക്ഷീത് തതഃ പരം സാ താൻ സിഷേവേ| ");
INSERT INTO sanmal_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","അഥാസ്തം ഗതേ രവൗ സന്ധ്യാകാലേ സതി ലോകാസ്തത്സമീപം സർവ്വാൻ രോഗിണോ ഭൂതധൃതാംശ്ച സമാനിന്യുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","സർവ്വേ നാഗരികാ ലോകാ ദ്വാരി സംമിലിതാശ്ച| ");
INSERT INTO sanmal_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","തതഃ സ നാനാവിധരോഗിണോ ബഹൂൻ മനുജാനരോഗിണശ്ചകാര തഥാ ബഹൂൻ ഭൂതാൻ ത്യാജയാഞ്ചകാര താൻ ഭൂതാൻ കിമപി വാക്യം വക്തും നിഷിഷേധ ച യതോഹേതോസ്തേ തമജാനൻ| ");
INSERT INTO sanmal_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","അപരഞ്ച സോഽതിപ്രത്യൂഷേ വസ്തുതസ്തു രാത്രിശേഷേ സമുത്ഥായ ബഹിർഭൂയ നിർജനം സ്ഥാനം ഗത്വാ തത്ര പ്രാർഥയാഞ്ചക്രേ| ");
INSERT INTO sanmal_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","അനന്തരം ശിമോൻ തത്സങ്ഗിനശ്ച തസ്യ പശ്ചാദ് ഗതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","തദുദ്ദേശം പ്രാപ്യ തമവദൻ സർവ്വേ ലോകാസ്ത്വാം മൃഗയന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","തദാ സോഽകഥയത് ആഗച്ഛത വയം സമീപസ്ഥാനി നഗരാണി യാമഃ, യതോഽഹം തത്ര കഥാം പ്രചാരയിതും ബഹിരാഗമമ്| ");
INSERT INTO sanmal_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","അഥ സ തേഷാം ഗാലീൽപ്രദേശസ്യ സർവ്വേഷു ഭജനഗൃഹേഷു കഥാഃ പ്രചാരയാഞ്ചക്രേ ഭൂതാനത്യാജയഞ്ച| ");
INSERT INTO sanmal_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","അനന്തരമേകഃ കുഷ്ഠീ സമാഗത്യ തത്സമ്മുഖേ ജാനുപാതം വിനയഞ്ച കൃത്വാ കഥിതവാൻ യദി ഭവാൻ ഇച്ഛതി തർഹി മാം പരിഷ്കർത്തും ശക്നോതി| ");
INSERT INTO sanmal_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","തതഃ കൃപാലു ര്യീശുഃ കരൗ പ്രസാര്യ്യ തം സ്പഷ്ട്വാ കഥയാമാസ ");
INSERT INTO sanmal_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","മമേച്ഛാ വിദ്യതേ ത്വം പരിഷ്കൃതോ ഭവ| ഏതത്കഥായാഃ കഥനമാത്രാത് സ കുഷ്ഠീ രോഗാന്മുക്തഃ പരിഷ്കൃതോഽഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","തദാ സ തം വിസൃജൻ ഗാഢമാദിശ്യ ജഗാദ ");
INSERT INTO sanmal_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","സാവധാനോ ഭവ കഥാമിമാം കമപി മാ വദ; സ്വാത്മാനം യാജകം ദർശയ, ലോകേഭ്യഃ സ്വപരിഷ്കൃതേഃ പ്രമാണദാനായ മൂസാനിർണീതം യദ്ദാനം തദുത്സൃജസ്വ ച| ");
INSERT INTO sanmal_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","കിന്തു സ ഗത്വാ തത് കർമ്മ ഇത്ഥം വിസ്താര്യ്യ പ്രചാരയിതും പ്രാരേഭേ തേനൈവ യീശുഃ പുനഃ സപ്രകാശം നഗരം പ്രവേഷ്ടും നാശക്നോത് തതോഹേതോർബഹിഃ കാനനസ്ഥാനേ തസ്യൗ; തഥാപി ചതുർദ്ദിഗ്ഭ്യോ ലോകാസ്തസ്യ സമീപമായയുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","തദനന്തരം യീശൈ കതിപയദിനാനി വിലമ്ബ്യ പുനഃ കഫർനാഹൂമ്നഗരം പ്രവിഷ്ടേ സ ഗൃഹ ആസ്ത ഇതി കിംവദന്ത്യാ തത്ക്ഷണം തത്സമീപം ബഹവോ ലോകാ ആഗത്യ സമുപതസ്ഥുഃ, ");
INSERT INTO sanmal_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","തസ്മാദ് ഗൃഹമധ്യേ സർവ്വേഷാം കൃതേ സ്ഥാനം നാഭവദ് ദ്വാരസ്യ ചതുർദിക്ഷ്വപി നാഭവത്, തത്കാലേ സ താൻ പ്രതി കഥാം പ്രചാരയാഞ്ചക്രേ| ");
INSERT INTO sanmal_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","തതഃ പരം ലോകാശ്ചതുർഭി ർമാനവൈരേകം പക്ഷാഘാതിനം വാഹയിത്വാ തത്സമീപമ് ആനിന്യുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","കിന്തു ജനാനാം ബഹുത്വാത് തം യീശോഃ സമ്മുഖമാനേതും ന ശക്നുവന്തോ യസ്മിൻ സ്ഥാനേ സ ആസ്തേ തദുപരിഗൃഹപൃഷ്ഠം ഖനിത്വാ ഛിദ്രം കൃത്വാ തേന മാർഗേണ സശയ്യം പക്ഷാഘാതിനമ് അവരോഹയാമാസുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","തതോ യീശുസ്തേഷാം വിശ്വാസം ദൃഷ്ട്വാ തം പക്ഷാഘാതിനം ബഭാഷേ ഹേ വത്സ തവ പാപാനാം മാർജനം ഭവതു| ");
INSERT INTO sanmal_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","തദാ കിയന്തോഽധ്യാപകാസ്തത്രോപവിശന്തോ മനോഭി ർവിതർകയാഞ്ചക്രുഃ, ഏഷ മനുഷ്യ ഏതാദൃശീമീശ്വരനിന്ദാം കഥാം കുതഃ കഥയതി? ");
INSERT INTO sanmal_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","ഈശ്വരം വിനാ പാപാനി മാർഷ്ടും കസ്യ സാമർഥ്യമ് ആസ്തേ? ");
INSERT INTO sanmal_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ഇത്ഥം തേ വിതർകയന്തി യീശുസ്തത്ക്ഷണം മനസാ തദ് ബുദ്വ്വാ താനവദദ് യൂയമന്തഃകരണൈഃ കുത ഏതാനി വിതർകയഥ? ");
INSERT INTO sanmal_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","തദനന്തരം യീശുസ്തത്സ്ഥാനാത് പുനഃ സമുദ്രതടം യയൗ; ലോകനിവഹേ തത്സമീപമാഗതേ സ താൻ സമുപദിദേശ| ");
INSERT INTO sanmal_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","കിന്തു പൃഥിവ്യാം പാപാനി മാർഷ്ടും മനുഷ്യപുത്രസ്യ സാമർഥ്യമസ്തി, ഏതദ് യുഷ്മാൻ ജ്ഞാപയിതും (സ തസ്മൈ പക്ഷാഘാതിനേ കഥയാമാസ) ");
INSERT INTO sanmal_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","ഉത്തിഷ്ഠ തവ ശയ്യാം ഗൃഹീത്വാ സ്വഗൃഹം യാഹി, അഹം ത്വാമിദമ് ആജ്ഞാപയാമി| ");
INSERT INTO sanmal_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","തതഃ സ തത്ക്ഷണമ് ഉത്ഥായ ശയ്യാം ഗൃഹീത്വാ സർവ്വേഷാം സാക്ഷാത് ജഗാമ; സർവ്വേ വിസ്മിതാ ഏതാദൃശം കർമ്മ വയമ് കദാപി നാപശ്യാമ, ഇമാം കഥാം കഥയിത്വേശ്വരം ധന്യമബ്രുവൻ| ");
INSERT INTO sanmal_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","തദനന്തരം യീശുസ്തത്സ്ഥാനാത് പുനഃ സമുദ്രതടം യയൗ; ലോകനിവഹേ തത്സമീപമാഗതേ സ താൻ സമുപദിദേശ| ");
INSERT INTO sanmal_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","അഥ ഗച്ഛൻ കരസഞ്ചയഗൃഹ ഉപവിഷ്ടമ് ആൽഫീയപുത്രം ലേവിം ദൃഷ്ട്വാ തമാഹൂയ കഥിതവാൻ മത്പശ്ചാത് ത്വാമാമച്ഛ തതഃ സ ഉത്ഥായ തത്പശ്ചാദ് യയൗ| ");
INSERT INTO sanmal_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","അനന്തരം യീശൗ തസ്യ ഗൃഹേ ഭോക്തുമ് ഉപവിഷ്ടേ ബഹവഃ കരമഞ്ചായിനഃ പാപിനശ്ച തേന തച്ഛിഷ്യൈശ്ച സഹോപവിവിശുഃ, യതോ ബഹവസ്തത്പശ്ചാദാജഗ്മുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","തദാ സ കരമഞ്ചായിഭിഃ പാപിഭിശ്ച സഹ ഖാദതി, തദ് ദൃഷ്ട്വാധ്യാപകാഃ ഫിരൂശിനശ്ച തസ്യ ശിഷ്യാനൂചുഃ കരമഞ്ചായിഭിഃ പാപിഭിശ്ച സഹായം കുതോ ഭുംക്തേ പിവതി ച? ");
INSERT INTO sanmal_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","തദ്വാക്യം ശ്രുത്വാ യീശുഃ പ്രത്യുവാച,അരോഗിലോകാനാം ചികിത്സകേന പ്രയോജനം നാസ്തി, കിന്തു രോഗിണാമേവ; അഹം ധാർമ്മികാനാഹ്വാതും നാഗതഃ കിന്തു മനോ വ്യാവർത്തയിതും പാപിന ഏവ| ");
INSERT INTO sanmal_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","തതഃ പരം യോഹനഃ ഫിരൂശിനാഞ്ചോപവാസാചാരിശിഷ്യാ യീശോഃ സമീപമ് ആഗത്യ കഥയാമാസുഃ, യോഹനഃ ഫിരൂശിനാഞ്ച ശിഷ്യാ ഉപവസന്തി കിന്തു ഭവതഃ ശിഷ്യാ നോപവസന്തി കിം കാരണമസ്യ? ");
INSERT INTO sanmal_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","തദാ യീശുസ്താൻ ബഭാഷേ യാവത് കാലം സഖിഭിഃ സഹ കന്യായാ വരസ്തിഷ്ഠതി താവത്കാലം തേ കിമുപവസ്തും ശക്നുവന്തി? യാവത്കാലം വരസ്തൈഃ സഹ തിഷ്ഠതി താവത്കാലം ത ഉപവസ്തും ന ശക്നുവന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","യസ്മിൻ കാലേ തേഭ്യഃ സകാശാദ് വരോ നേഷ്യതേ സ കാല ആഗച്ഛതി, തസ്മിൻ കാലേ തേ ജനാ ഉപവത്സ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","കോപി ജനഃ പുരാതനവസ്ത്രേ നൂതനവസ്ത്രം ന സീവ്യതി, യതോ നൂതനവസ്ത്രേണ സഹ സേവനേ കൃതേ ജീർണം വസ്ത്രം ഛിദ്യതേ തസ്മാത് പുന ർമഹത് ഛിദ്രം ജായതേ| ");
INSERT INTO sanmal_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","കോപി ജനഃ പുരാതനകുതൂഷു നൂതനം ദ്രാക്ഷാരസം ന സ്ഥാപയതി, യതോ നൂതനദ്രാക്ഷാരസസ്യ തേജസാ താഃ കുത്വോ വിദീര്യ്യന്തേ തതോ ദ്രാക്ഷാരസശ്ച പതതി കുത്വശ്ച നശ്യന്തി, അതഏവ നൂതനദ്രാക്ഷാരസോ നൂതനകുതൂഷു സ്ഥാപനീയഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","തദനന്തരം യീശു ര്യദാ വിശ്രാമവാരേ ശസ്യക്ഷേത്രേണ ഗച്ഛതി തദാ തസ്യ ശിഷ്യാ ഗച്ഛന്തഃ ശസ്യമഞ്ജരീശ്ഛേത്തും പ്രവൃത്താഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","അതഃ ഫിരൂശിനോ യീശവേ കഥയാമാസുഃ പശ്യതു വിശ്രാമവാസരേ യത് കർമ്മ ന കർത്തവ്യം തദ് ഇമേ കുതഃ കുർവ്വന്തി? ");
INSERT INTO sanmal_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","തദാ സ തേഭ്യോഽകഥയത് ദായൂദ് തത്സംങ്ഗിനശ്ച ഭക്ഷ്യാഭാവാത് ക്ഷുധിതാഃ സന്തോ യത് കർമ്മ കൃതവന്തസ്തത് കിം യുഷ്മാഭി ർന പഠിതമ്? ");
INSERT INTO sanmal_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","അബിയാഥർനാമകേ മഹായാജകതാം കുർവ്വതി സ കഥമീശ്വരസ്യാവാസം പ്രവിശ്യ യേ ദർശനീയപൂപാ യാജകാൻ വിനാന്യസ്യ കസ്യാപി ന ഭക്ഷ്യാസ്താനേവ ബുഭുജേ സങ്ഗിലോകേഭ്യോഽപി ദദൗ| ");
INSERT INTO sanmal_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","സോഽപരമപി ജഗാദ, വിശ്രാമവാരോ മനുഷ്യാർഥമേവ നിരൂപിതോഽസ്തി കിന്തു മനുഷ്യോ വിശ്രാമവാരാർഥം നൈവ| ");
INSERT INTO sanmal_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","മനുഷ്യപുത്രോ വിശ്രാമവാരസ്യാപി പ്രഭുരാസ്തേ| ");
INSERT INTO sanmal_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","അനന്തരം യീശുഃ പുന ർഭജനഗൃഹം പ്രവിഷ്ടസ്തസ്മിൻ സ്ഥാനേ ശുഷ്കഹസ്ത ഏകോ മാനവ ആസീത്| ");
INSERT INTO sanmal_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","സ വിശ്രാമവാരേ തമരോഗിണം കരിഷ്യതി നവേത്യത്ര ബഹവസ്തമ് അപവദിതും ഛിദ്രമപേക്ഷിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","തദാ സ തം ശുഷ്കഹസ്തം മനുഷ്യം ജഗാദ മധ്യസ്ഥാനേ ത്വമുത്തിഷ്ഠ| ");
INSERT INTO sanmal_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","തതഃ പരം സ താൻ പപ്രച്ഛ വിശ്രാമവാരേ ഹിതമഹിതം തഥാ ഹി പ്രാണരക്ഷാ വാ പ്രാണനാശ ഏഷാം മധ്യേ കിം കരണീയം ? കിന്തു തേ നിഃശബ്ദാസ്തസ്ഥുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","തദാ സ തേഷാമന്തഃകരണാനാം കാഠിന്യാദ്ധേതോ ർദുഃഖിതഃ ക്രോധാത് ചർതുिദശോ ദൃഷ്ടവാൻ തം മാനുഷം ഗദിതവാൻ തം ഹസ്തം വിസ്താരയ, തതസ്തേന ഹസ്തേ വിസ്തൃതേ തദ്ധസ്തോഽന്യഹസ്തവദ് അരോഗോ ജാതഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","അഥ ഫിരൂശിനഃ പ്രസ്ഥായ തം നാശയിതും ഹേരോദീയൈഃ സഹ മന്ത്രയിതുമാരേഭിരേ| ");
INSERT INTO sanmal_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","അതഏവ യീശുസ്തത്സ്ഥാനം പരിത്യജ്യ ശിഷ്യൈഃ സഹ പുനഃ സാഗരസമീപം ഗതഃ; ");
INSERT INTO sanmal_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","തതോ ഗാലീല്യിഹൂദാ-യിരൂശാലമ്-ഇദോമ്-യർദന്നദീപാരസ്ഥാനേഭ്യോ ലോകസമൂഹസ്തസ്യ പശ്ചാദ് ഗതഃ; തദന്യഃ സോരസീദനോഃ സമീപവാസിലോകസമൂഹശ്ച തസ്യ മഹാകർമ്മണാം വാർത്തം ശ്രുത്വാ തസ്യ സന്നിധിമാഗതഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","തദാ ലോകസമൂഹശ്ചേത് തസ്യോപരി പതതി ഇത്യാശങ്ക്യ സ നാവമേകാം നികടേ സ്ഥാപയിതും ശിഷ്യാനാദിഷ്ടവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","യതോഽനേകമനുഷ്യാണാമാരോഗ്യകരണാദ് വ്യാധിഗ്രസ്താഃ സർവ്വേ തം സ്പ്രഷ്ടും പരസ്പരം ബലേന യത്നവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","അപരഞ്ച അപവിത്രഭൂതാസ്തം ദൃഷ്ട്വാ തച്ചരണയോഃ പതിത്വാ പ്രോചൈഃ പ്രോചുഃ, ത്വമീശ്വരസ്യ പുത്രഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","കിന്തു സ താൻ ദൃഢമ് ആജ്ഞാപ്യ സ്വം പരിചായിതും നിഷിദ്ധവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","അനന്തരം സ പർവ്വതമാരുഹ്യ യം യം പ്രതിച്ഛാ തം തമാഹൂതവാൻ തതസ്തേ തത്സമീപമാഗതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","തദാ സ ദ്വാദശജനാൻ സ്വേന സഹ സ്ഥാതും സുസംവാദപ്രചാരായ പ്രേരിതാ ഭവിതും ");
INSERT INTO sanmal_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","സർവ്വപ്രകാരവ്യാധീനാം ശമനകരണായ പ്രഭാവം പ്രാപ്തും ഭൂതാൻ ത്യാജയിതുഞ്ച നിയുക്തവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","തേഷാം നാമാനീമാനി, ശിമോൻ സിവദിപുത്രോ ");
INSERT INTO sanmal_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","യാകൂബ് തസ്യ ഭ്രാതാ യോഹൻ ച ആന്ദ്രിയഃ ഫിലിപോ ബർഥലമയഃ, ");
INSERT INTO sanmal_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","മഥീ ഥോമാ ച ആൽഫീയപുത്രോ യാകൂബ് ഥദ്ദീയഃ കിനാനീയഃ ശിമോൻ യസ്തം പരഹസ്തേഷ്വർപയിഷ്യതി സ ഈഷ്കരിയോതീയയിഹൂദാശ്ച| ");
INSERT INTO sanmal_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","സ ശിമോനേ പിതര ഇത്യുപനാമ ദദൗ യാകൂബ്യോഹൻഭ്യാം ച ബിനേരിഗിശ് അർഥതോ മേഘനാദപുത്രാവിത്യുപനാമ ദദൗ| ");
INSERT INTO sanmal_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","അനന്തരം തേ നിവേശനം ഗതാഃ, കിന്തു തത്രാപി പുനർമഹാൻ ജനസമാഗമോ ഽഭവത് തസ്മാത്തേ ഭോക്തുമപ്യവകാശം ന പ്രാപ്താഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","തതസ്തസ്യ സുഹൃല്ലോകാ ഇമാം വാർത്താം പ്രാപ്യ സ ഹതജ്ഞാനോഭൂദ് ഇതി കഥാം കഥയിത്വാ തം ധൃത്വാനേതും ഗതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","അപരഞ്ച യിരൂശാലമ ആഗതാ യേ യേഽധ്യാപകാസ്തേ ജഗദുരയം പുരുഷോ ഭൂതപത്യാബിഷ്ടസ്തേന ഭൂതപതിനാ ഭൂതാൻ ത്യാജയതി| ");
INSERT INTO sanmal_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","തതസ്താനാഹൂയ യീശു ർദൃഷ്ടാന്തൈഃ കഥാം കഥിതവാൻ ശൈതാൻ കഥം ശൈതാനം ത്യാജയിതും ശക്നോതി? ");
INSERT INTO sanmal_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","കിഞ്ചന രാജ്യം യദി സ്വവിരോധേന പൃഥഗ് ഭവതി തർഹി തദ് രാജ്യം സ്ഥിരം സ്ഥാതും ന ശക്നോതി| ");
INSERT INTO sanmal_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","തഥാ കസ്യാപി പരിവാരോ യദി പരസ്പരം വിരോധീ ഭവതി തർഹി സോപി പരിവാരഃ സ്ഥിരം സ്ഥാതും ന ശക്നോതി| ");
INSERT INTO sanmal_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","തദ്വത് ശൈതാൻ യദി സ്വവിപക്ഷതയാ ഉത്തിഷ്ഠൻ ഭിന്നോ ഭവതി തർഹി സോപി സ്ഥിരം സ്ഥാതും ന ശക്നോതി കിന്തൂച്ഛിന്നോ ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","അപരഞ്ച പ്രബലം ജനം പ്രഥമം ന ബദ്ധാ കോപി തസ്യ ഗൃഹം പ്രവിശ്യ ദ്രവ്യാണി ലുണ്ഠയിതും ന ശക്നോതി, തം ബദ്വ്വൈവ തസ്യ ഗൃഹസ്യ ദ്രവ്യാണി ലുണ്ഠയിതും ശക്നോതി| ");
INSERT INTO sanmal_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","അതോഹേതോ ര്യുഷ്മഭ്യമഹം സത്യം കഥയാമി മനുഷ്യാണാം സന്താനാ യാനി യാനി പാപാനീശ്വരനിന്ദാഞ്ച കുർവ്വന്തി തേഷാം തത്സർവ്വേഷാമപരാധാനാം ക്ഷമാ ഭവിതും ശക്നോതി, ");
INSERT INTO sanmal_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","കിന്തു യഃ കശ്ചിത് പവിത്രമാത്മാനം നിന്ദതി തസ്യാപരാധസ്യ ക്ഷമാ കദാപി ന ഭവിഷ്യതി സോനന്തദണ്ഡസ്യാർഹോ ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","തസ്യാപവിത്രഭൂതോഽസ്തി തേഷാമേതത്കഥാഹേതോഃ സ ഇത്ഥം കഥിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","അഥ തസ്യ മാതാ ഭ്രാതൃഗണശ്ചാഗത്യ ബഹിസ്തിഷ്ഠനതോ ലോകാൻ പ്രേഷ്യ തമാഹൂതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","തതസ്തത്സന്നിധൗ സമുപവിഷ്ടാ ലോകാസ്തം ബഭാഷിരേ പശ്യ ബഹിസ്തവ മാതാ ഭ്രാതരശ്ച ത്വാമ് അന്വിച്ഛന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","തദാ സ താൻ പ്രത്യുവാച മമ മാതാ കാ ഭ്രാതരോ വാ കേ? തതഃ പരം സ സ്വമീപോപവിഷ്ടാൻ ശിഷ്യാൻ പ്രതി അവലോകനം കൃത്വാ കഥയാമാസ ");
INSERT INTO sanmal_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","പശ്യതൈതേ മമ മാതാ ഭ്രാതരശ്ച| ");
INSERT INTO sanmal_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","യഃ കശ്ചിദ് ഈശ്വരസ്യേഷ്ടാം ക്രിയാം കരോതി സ ഏവ മമ ഭ്രാതാ ഭഗിനീ മാതാ ച| ");
INSERT INTO sanmal_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","അനന്തരം സ സമുദ്രതടേ പുനരുപദേഷ്ടും പ്രാരേഭേ, തതസ്തത്ര ബഹുജനാനാം സമാഗമാത് സ സാഗരോപരി നൗകാമാരുഹ്യ സമുപവിഷ്ടഃ; സർവ്വേ ലോകാഃ സമുദ്രകൂലേ തസ്ഥുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","തദാ സ ദൃഷ്ടാന്തകഥാഭി ർബഹൂപദിഷ്ടവാൻ ഉപദിശംശ്ച കഥിതവാൻ, ");
INSERT INTO sanmal_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","അവധാനം കുരുത, ഏകോ ബീജവപ്താ ബീജാനി വപ്തും ഗതഃ; ");
INSERT INTO sanmal_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","വപനകാലേ കിയന്തി ബീജാനി മാർഗപാശ്വേ പതിതാനി, തത ആകാശീയപക്ഷിണ ഏത്യ താനി ചഖാദുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","കിയന്തി ബീജാനി സ്വൽപമൃത്തികാവത്പാഷാണഭൂമൗ പതിതാനി താനി മൃദോൽപത്വാത് ശീഘ്രമങ്കുരിതാനി; ");
INSERT INTO sanmal_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","കിന്തൂദിതേ സൂര്യ്യേ ദഗ്ധാനി തഥാ മൂലാനോ നാധോഗതത്വാത് ശുഷ്കാണി ച| ");
INSERT INTO sanmal_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","കിയന്തി ബീജാനി കണ്ടകിവനമധ്യേ പതിതാനി തതഃ കണ്ടകാനി സംവൃദ്വ്യ താനി ജഗ്രസുസ്താനി ന ച ഫലിതാനി| ");
INSERT INTO sanmal_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","തഥാ കിയന്തി ബീജാന്യുത്തമഭൂമൗ പതിതാനി താനി സംവൃദ്വ്യ ഫലാന്യുത്പാദിതാനി കിയന്തി ബീജാനി ത്രിംശദ്ഗുണാനി കിയന്തി ഷഷ്ടിഗുണാനി കിയന്തി ശതഗുണാനി ഫലാനി ഫലിതവന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","അഥ സ താനവദത് യസ്യ ശ്രോതും കർണൗ സ്തഃ സ ശൃണോതു| ");
INSERT INTO sanmal_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","തദനന്തരം നിർജനസമയേ തത്സങ്ഗിനോ ദ്വാദശശിഷ്യാശ്ച തം തദ്ദൃഷ്ടാന്തവാക്യസ്യാർഥം പപ്രച്ഛുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","തദാ സ താനുദിതവാൻ ഈശ്വരരാജ്യസ്യ നിഗൂഢവാക്യം ബോദ്ധും യുഷ്മാകമധികാരോഽസ്തി; ");
INSERT INTO sanmal_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","കിന്തു യേ വഹിർഭൂതാഃ \"തേ പശ്യന്തഃ പശ്യന്തി കിന്തു ന ജാനന്തി, ശൃണ്വന്തഃ ശൃണ്വന്തി കിന്തു ന ബുധ്യന്തേ, ചേത്തൈ ർമനഃസു കദാപി പരിവർത്തിതേഷു തേഷാം പാപാന്യമോചയിഷ്യന്ത,\" അതോഹേതോസ്താൻ പ്രതി ദൃഷ്ടാന്തൈരേവ താനി മയാ കഥിതാനി| ");
INSERT INTO sanmal_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","അഥ സ കഥിതവാൻ യൂയം കിമേതദ് ദൃഷ്ടാന്തവാക്യം ന ബുധ്യധ്വേ? തർഹി കഥം സർവ്വാൻ ദൃഷ്ടാന്താന ഭോത്സ്യധ്വേ? ");
INSERT INTO sanmal_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ബീജവപ്താ വാക്യരൂപാണി ബീജാനി വപതി; ");
INSERT INTO sanmal_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","തത്ര യേ യേ ലോകാ വാക്യം ശൃണ്വന്തി, കിന്തു ശ്രുതമാത്രാത് ശൈതാൻ ശീഘ്രമാഗത്യ തേഷാം മനഃസൂപ്താനി താനി വാക്യരൂപാണി ബീജാന്യപനയതി തഏവ ഉപ്തബീജമാർഗപാർശ്വേസ്വരൂപാഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","യേ ജനാ വാക്യം ശ്രുത്വാ സഹസാ പരമാനന്ദേന ഗൃഹ്ലന്തി, കിന്തു ഹൃദി സ്ഥൈര്യ്യാഭാവാത് കിഞ്ചിത് കാലമാത്രം തിഷ്ഠന്തി തത്പശ്ചാത് തദ്വാക്യഹേതോഃ ");
INSERT INTO sanmal_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","കുത്രചിത് ക്ലേശേ ഉപദ്രവേ വാ സമുപസ്ഥിതേ തദൈവ വിഘ്നം പ്രാപ്നുവന്തി തഏവ ഉപ്തബീജപാഷാണഭൂമിസ്വരൂപാഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","യേ ജനാഃ കഥാം ശൃണ്വന്തി കിന്തു സാംസാരികീ ചിന്താ ധനഭ്രാന്തി ർവിഷയലോഭശ്ച ഏതേ സർവ്വേ ഉപസ്ഥായ താം കഥാം ഗ്രസന്തി തതഃ മാ വിഫലാ ഭവതി ");
INSERT INTO sanmal_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","തഏവ ഉപ്തബീജസകണ്ടകഭൂമിസ്വരൂപാഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","യേ ജനാ വാക്യം ശ്രുത്വാ ഗൃഹ്ലന്തി തേഷാം കസ്യ വാ ത്രിംശദ്ഗുണാനി കസ്യ വാ ഷഷ്ടിഗുണാനി കസ്യ വാ ശതഗുണാനി ഫലാനി ഭവന്തി തഏവ ഉപ്തബീജോർവ്വരഭൂമിസ്വരൂപാഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","തദാ സോഽപരമപി കഥിതവാൻ കോപി ജനോ ദീപാധാരം പരിത്യജ്യ ദ്രോണസ്യാധഃ ഖട്വായാ അധേ വാ സ്ഥാപയിതും ദീപമാനയതി കിം? ");
INSERT INTO sanmal_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","അതോഹേതോ ര്യന്ന പ്രകാശയിഷ്യതേ താദൃഗ് ലുക്കായിതം കിമപി വസ്തു നാസ്തി; യദ് വ്യക്തം ന ഭവിഷ്യതി താദൃശം ഗുപ്തം കിമപി വസ്തു നാസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","യസ്യ ശ്രോതും കർണൗ സ്തഃ സ ശൃണോതു| ");
INSERT INTO sanmal_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","അപരമപി കഥിതവാൻ യൂയം യദ് യദ് വാക്യം ശൃണുഥ തത്ര സാവധാനാ ഭവത, യതോ യൂയം യേന പരിമാണേന പരിമാഥ തേനൈവ പരിമാണേന യുഷ്മദർഥമപി പരിമാസ്യതേ; ശ്രോതാരോ യൂയം യുഷ്മഭ്യമധികം ദാസ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","യസ്യാശ്രയേ വർദ്ധതേ തസ്മൈ അപരമപി ദാസ്യതേ, കിന്തു യസ്യാശ്രയേ ന വർദ്ധതേ തസ്യ യത് കിഞ്ചിദസ്തി തദപി തസ്മാൻ നേഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","അനന്തരം സ കഥിതവാൻ ഏകോ ലോകഃ ക്ഷേത്രേ ബീജാന്യുപ്ത്വാ ");
INSERT INTO sanmal_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ജാഗരണനിദ്രാഭ്യാം ദിവാനിശം ഗമയതി, പരന്തു തദ്വീജം തസ്യാജ്ഞാതരൂപേണാങ്കുരയതി വർദ്ധതേ ച; ");
INSERT INTO sanmal_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","യതോഹേതോഃ പ്രഥമതഃ പത്രാണി തതഃ പരം കണിശാനി തത്പശ്ചാത് കണിശപൂർണാനി ശസ്യാനി ഭൂമിഃ സ്വയമുത്പാദയതി; ");
INSERT INTO sanmal_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","കിന്തു ഫലേഷു പക്കേഷു ശസ്യച്ഛേദനകാലം ജ്ഞാത്വാ സ തത്ക്ഷണം ശസ്യാനി ഛിനത്തി, അനേന തുല്യമീശ്വരരാജ്യം| ");
INSERT INTO sanmal_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","പുനഃ സോഽകഥയദ് ഈശ്വരരാജ്യം കേന സമം? കേന വസ്തുനാ സഹ വാ തദുപമാസ്യാമി? ");
INSERT INTO sanmal_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","തത് സർഷപൈകേന തുല്യം യതോ മൃദി വപനകാലേ സർഷപബീജം സർവ്വപൃഥിവീസ്ഥബീജാത് ക്ഷുദ്രം ");
INSERT INTO sanmal_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","കിന്തു വപനാത് പരമ് അങ്കുരയിത്വാ സർവ്വശാകാദ് ബൃഹദ് ഭവതി, തസ്യ ബൃഹത്യഃ ശാഖാശ്ച ജായന്തേ തതസ്തച്ഛായാം പക്ഷിണ ആശ്രയന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ഇത്ഥം തേഷാം ബോധാനുരൂപം സോഽനേകദൃഷ്ടാന്തൈസ്താനുപദിഷ്ടവാൻ, ");
INSERT INTO sanmal_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ദൃഷ്ടാന്തം വിനാ കാമപി കഥാം തേഭ്യോ ന കഥിതവാൻ പശ്ചാൻ നിർജനേ സ ശിഷ്യാൻ സർവ്വദൃഷ്ടാന്താർഥം ബോധിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","തദ്ദിനസ്യ സന്ധ്യായാം സ തേഭ്യോഽകഥയദ് ആഗച്ഛത വയം പാരം യാമ| ");
INSERT INTO sanmal_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","തദാ തേ ലോകാൻ വിസൃജ്യ തമവിലമ്ബം ഗൃഹീത്വാ നൗകയാ പ്രതസ്ഥിരേ; അപരാ അപി നാവസ്തയാ സഹ സ്ഥിതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","തതഃ പരം മഹാഝഞ്ഭ്ശഗമാത് നൗ ർദോലായമാനാ തരങ്ഗേണ ജലൈഃ പൂർണാഭവച്ച| ");
INSERT INTO sanmal_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","തദാ സ നൗകാചശ്ചാദ്ഭാഗേ ഉപധാനേ ശിരോ നിധായ നിദ്രിത ആസീത് തതസ്തേ തം ജാഗരയിത്വാ ജഗദുഃ, ഹേ പ്രഭോ, അസ്മാകം പ്രാണാ യാന്തി കിമത്ര ഭവതശ്ചിന്താ നാസ്തി? ");
INSERT INTO sanmal_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","തദാ സ ഉത്ഥായ വായും തർജിതവാൻ സമുദ്രഞ്ചോക്തവാൻ ശാന്തഃ സുസ്ഥിരശ്ച ഭവ; തതോ വായൗ നിവൃത്തേഽബ്ധിർനിസ്തരങ്ഗോഭൂത്| ");
INSERT INTO sanmal_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","തദാ സ താനുവാച യൂയം കുത ഏതാദൃക്ശങ്കാകുലാ ഭവത? കിം വോ വിശ്വാസോ നാസ്തി? ");
INSERT INTO sanmal_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","തസ്മാത്തേഽതീവഭീതാഃ പരസ്പരം വക്തുമാരേഭിരേ, അഹോ വായുഃ സിന്ധുശ്ചാസ്യ നിദേശഗ്രാഹിണൗ കീദൃഗയം മനുജഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","അഥ തൂ സിന്ധുപാരം ഗത്വാ ഗിദേരീയപ്രദേശ ഉപതസ്ഥുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","നൗകാതോ നിർഗതമാത്രാദ് അപവിത്രഭൂതഗ്രസ്ത ഏകഃ ശ്മശാനാദേത്യ തം സാക്ഷാച് ചകാര| ");
INSERT INTO sanmal_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","സ ശ്മശാനേഽവാത്സീത് കോപി തം ശൃങ്ഖലേന ബദ്വ്വാ സ്ഥാപയിതും നാശക്നോത്| ");
INSERT INTO sanmal_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ജനൈർവാരം നിഗഡൈഃ ശൃങ്ഖലൈശ്ച സ ബദ്ധോപി ശൃങ്ഖലാന്യാകൃഷ്യ മോചിതവാൻ നിഗഡാനി ച ഭംക്ത്വാ ഖണ്ഡം ഖണ്ഡം കൃതവാൻ കോപി തം വശീകർത്തും ന ശശക| ");
INSERT INTO sanmal_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ദിവാനിശം സദാ പർവ്വതം ശ്മശാനഞ്ച ഭ്രമിത്വാ ചീത്ശബ്ദം കൃതവാൻ ഗ്രാവഭിശ്ച സ്വയം സ്വം കൃതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","സ യീശും ദൂരാത് പശ്യന്നേവ ധാവൻ തം പ്രണനാമ ഉചൈരുവംശ്ചോവാച, ");
INSERT INTO sanmal_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ഹേ സർവ്വോപരിസ്ഥേശ്വരപുത്ര യീശോ ഭവതാ സഹ മേ കഃ സമ്ബന്ധഃ? അഹം ത്വാമീശ്വരേണ ശാപയേ മാം മാ യാതയ| ");
INSERT INTO sanmal_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","യതോ യീശുസ്തം കഥിതവാൻ രേ അപവിത്രഭൂത, അസ്മാന്നരാദ് ബഹിർനിർഗച്ഛ| ");
INSERT INTO sanmal_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","അഥ സ തം പൃഷ്ടവാൻ കിന്തേ നാമ? തേന പ്രത്യുക്തം വയമനേകേ ഽസ്മസ്തതോഽസ്മന്നാമ ബാഹിനീ| ");
INSERT INTO sanmal_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","തതോസ്മാൻ ദേശാന്ന പ്രേഷയേതി തേ തം പ്രാർഥയന്ത| ");
INSERT INTO sanmal_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","തദാനീം പർവ്വതം നികഷാ ബൃഹൻ വരാഹവ്രജശ്ചരന്നാസീത്| ");
INSERT INTO sanmal_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","തസ്മാദ് ഭൂതാ വിനയേന ജഗദുഃ, അമും വരാഹവ്രജമ് ആശ്രയിതുമ് അസ്മാൻ പ്രഹിണു| ");
INSERT INTO sanmal_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","യീശുനാനുജ്ഞാതാസ്തേഽപവിത്രഭൂതാ ബഹിർനിര്യായ വരാഹവ്രജം പ്രാവിശൻ തതഃ സർവ്വേ വരാഹാ വസ്തുതസ്തു പ്രായോദ്വിസഹസ്രസംങ്ഖ്യകാഃ കടകേന മഹാജവാദ് ധാവന്തഃ സിന്ധൗ പ്രാണാൻ ജഹുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","തസ്മാദ് വരാഹപാലകാഃ പലായമാനാഃ പുരേ ഗ്രാമേ ച തദ്വാർത്തം കഥയാഞ്ചക്രുഃ| തദാ ലോകാ ഘടിതം തത്കാര്യ്യം ദ്രഷ്ടും ബഹിർജഗ്മുഃ ");
INSERT INTO sanmal_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","യീശോഃ സന്നിധിം ഗത്വാ തം ഭൂതഗ്രസ്തമ് അർഥാദ് ബാഹിനീഭൂതഗ്രസ്തം നരം സവസ്ത്രം സചേതനം സമുപവിഷ്ടഞ്ച ദൃृഷ്ട്വാ ബിഭ്യുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","തതോ ദൃഷ്ടതത്കാര്യ്യലോകാസ്തസ്യ ഭൂതഗ്രസ്തനരസ്യ വരാഹവ്രജസ്യാപി താം ധടനാം വർണയാമാസുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","തതസ്തേ സ്വസീമാതോ ബഹിർഗന്തും യീശും വിനേതുമാരേഭിരേ| ");
INSERT INTO sanmal_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","അഥ തസ്യ നൗകാരോഹണകാലേ സ ഭൂതമുക്തോ നാ യീശുനാ സഹ സ്ഥാതും പ്രാർഥയതേ; ");
INSERT INTO sanmal_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","കിന്തു സ തമനനുമത്യ കഥിതവാൻ ത്വം നിജാത്മീയാനാം സമീപം ഗൃഹഞ്ച ഗച്ഛ പ്രഭുസ്ത്വയി കൃപാം കൃത്വാ യാനി കർമ്മാണി കൃതവാൻ താനി താൻ ജ്ഞാപയ| ");
INSERT INTO sanmal_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","അതഃ സ പ്രസ്ഥായ യീശുനാ കൃതം തത്സർവ്വാശ്ചര്യ്യം കർമ്മ ദികാപലിദേശേ പ്രചാരയിതും പ്രാരബ്ധവാൻ തതഃ സർവ്വേ ലോകാ ആശ്ചര്യ്യം മേനിരേ| ");
INSERT INTO sanmal_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","അനന്തരം യീശൗ നാവാ പുനരന്യപാര ഉത്തീർണേ സിന്ധുതടേ ച തിഷ്ഠതി സതി തത്സമീപേ ബഹുലോകാനാം സമാഗമോഽഭൂത്| ");
INSERT INTO sanmal_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","അപരം യായീർ നാമ്നാ കശ്ചിദ് ഭജനഗൃഹസ്യാധിപ ആഗത്യ തം ദൃഷ്ട്വൈവ ചരണയോഃ പതിത്വാ ബഹു നിവേദ്യ കഥിതവാൻ; ");
INSERT INTO sanmal_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","മമ കന്യാ മൃതപ്രായാഭൂദ് അതോ ഭവാനേത്യ തദാരോഗ്യായ തസ്യാ ഗാത്രേ ഹസ്തമ് അർപയതു തേനൈവ സാ ജീവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","തദാ യീശുസ്തേന സഹ ചലിതഃ കിന്തു തത്പശ്ചാദ് ബഹുലോകാശ്ചലിത്വാ താദ്ഗാത്രേ പതിതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","അഥ ദ്വാദശവർഷാണി പ്രദരരോഗേണ ");
INSERT INTO sanmal_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ശീർണാ ചികിത്സകാനാം നാനാചികിത്സാഭിശ്ച ദുഃഖം ഭുക്തവതീ ച സർവ്വസ്വം വ്യയിത്വാപി നാരോഗ്യം പ്രാപ്താ ച പുനരപി പീഡിതാസീച്ച ");
INSERT INTO sanmal_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","യാ സ്ത്രീ സാ യീശോ ർവാർത്താം പ്രാപ്യ മനസാകഥയത് യദ്യഹം തസ്യ വസ്ത്രമാത്ര സ്പ്രഷ്ടും ലഭേയം തദാ രോഗഹീനാ ഭവിഷ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","അതോഹേതോഃ സാ ലോകാരണ്യമധ്യേ തത്പശ്ചാദാഗത്യ തസ്യ വസ്ത്രം പസ്പർശ| ");
INSERT INTO sanmal_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","തേനൈവ തത്ക്ഷണം തസ്യാ രക്തസ്രോതഃ ശുഷ്കം സ്വയം തസ്മാദ് രോഗാന്മുക്താ ഇത്യപി ദേഹേഽനുഭൂതാ| ");
INSERT INTO sanmal_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","അഥ സ്വസ്മാത് ശക്തി ർനിർഗതാ യീശുരേതന്മനസാ ജ്ഞാത്വാ ലോകനിവഹം പ്രതി മുഖം വ്യാവൃത്യ പൃഷ്ടവാൻ കേന മദ്വസ്ത്രം സ്പൃഷ്ടം? ");
INSERT INTO sanmal_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","തതസ്തസ്യ ശിഷ്യാ ഊചുഃ ഭവതോ വപുഷി ലോകാഃ സംഘർഷന്തി തദ് ദൃഷ്ട്വാ കേന മദ്വസ്ത്രം സ്പൃഷ്ടമിതി കുതഃ കഥയതി? ");
INSERT INTO sanmal_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","കിന്തു കേന തത് കർമ്മ കൃതം തദ് ദ്രഷ്ടും യീശുശ്ചതുർദിശോ ദൃഷ്ടവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","തതഃ സാ സ്ത്രീ ഭീതാ കമ്പിതാ ച സതീ സ്വസ്യാ രുക്പ്രതിക്രിയാ ജാതേതി ജ്ഞാത്വാഗത്യ തത്സമ്മുഖേ പതിത്വാ സർവ്വവൃത്താന്തം സത്യം തസ്മൈ കഥയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","തദാനീം യീശുസ്താം ഗദിതവാൻ, ഹേ കന്യേ തവ പ്രതീതിസ്ത്വാമ് അരോഗാമകരോത് ത്വം ക്ഷേമേണ വ്രജ സ്വരോഗാന്മുക്താ ച തിഷ്ഠ| ");
INSERT INTO sanmal_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ഇതിവാക്യവദനകാലേ ഭജനഗൃഹാധിപസ്യ നിവേശനാൽ ലോകാ ഏത്യാധിപം ബഭാഷിരേ തവ കന്യാ മൃതാ തസ്മാദ് ഗുരും പുനഃ കുതഃ ക്ലിശ്നാസി? ");
INSERT INTO sanmal_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","കിന്തു യീശുസ്തദ് വാക്യം ശ്രുത്വൈവ ഭജനഗൃഹാധിപം ഗദിതവാൻ മാ ഭൈഷീഃ കേവലം വിശ്വാസിഹി| ");
INSERT INTO sanmal_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","അഥ പിതരോ യാകൂബ് തദ്ഭ്രാതാ യോഹൻ ച ഏതാൻ വിനാ കമപി സ്വപശ്ചാദ് യാതും നാന്വമന്യത| ");
INSERT INTO sanmal_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","തസ്യ ഭജനഗൃഹാധിപസ്യ നിവേശനസമീപമ് ആഗത്യ കലഹം ബഹുരോദനം വിലാപഞ്ച കുർവ്വതോ ലോകാൻ ദദർശ| ");
INSERT INTO sanmal_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","തസ്മാൻ നിവേശനം പ്രവിശ്യ പ്രോക്തവാൻ യൂയം കുത ഇത്ഥം കലഹം രോദനഞ്ച കുരുഥ? കന്യാ ന മൃതാ നിദ്രാതി| ");
INSERT INTO sanmal_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","തസ്മാത്തേ തമുപജഹസുഃ കിന്തു യീശുഃ സർവ്വാന ബഹിഷ്കൃത്യ കന്യായാഃ പിതരൗ സ്വസങ്ഗിനശ്ച ഗൃഹീത്വാ യത്ര കന്യാസീത് തത് സ്ഥാനം പ്രവിഷ്ടവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","അഥ സ തസ്യാഃ കന്യായാ ഹസ്തൗ ധൃത്വാ താം ബഭാഷേ ടാലീഥാ കൂമീ, അർഥതോ ഹേ കന്യേ ത്വമുത്തിഷ്ഠ ഇത്യാജ്ഞാപയാമി| ");
INSERT INTO sanmal_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","തുനൈവ തത്ക്ഷണം സാ ദ്വാദശവർഷവയസ്കാ കന്യാ പോത്ഥായ ചലിതുമാരേഭേ, ഇതഃ സർവ്വേ മഹാവിസ്മയം ഗതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","തത ഏതസ്യൈ കിഞ്ചിത് ഖാദ്യം ദത്തേതി കഥയിത്വാ ഏതത്കർമ്മ കമപി ന ജ്ഞാപയതേതി ദൃഢമാദിഷ്ടവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","അനന്തരം സ തത്സ്ഥാനാത് പ്രസ്ഥായ സ്വപ്രദേശമാഗതഃ ശിഷ്യാശ്ച തത്പശ്ചാദ് ഗതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","അഥ വിശ്രാമവാരേ സതി സ ഭജനഗൃഹേ ഉപദേഷ്ടുമാരബ്ധവാൻ തതോഽനേകേ ലോകാസ്തത്കഥാം ശ്രുത്വാ വിസ്മിത്യ ജഗദുഃ, അസ്യ മനുജസ്യ ഈദൃശീ ആശ്ചര്യ്യക്രിയാ കസ്മാജ് ജാതാ? തഥാ സ്വകരാഭ്യാമ് ഇത്ഥമദ്ഭുതം കർമ്മ കർത്താुമ് ഏതസ്മൈ കഥം ജ്ഞാനം ദത്തമ്? ");
INSERT INTO sanmal_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","കിമയം മരിയമഃ പുത്രസ്തജ്ഞാ നോ? കിമയം യാകൂബ്-യോസി-യിഹുദാ-ശിമോനാം ഭ്രാതാ നോ? അസ്യ ഭഗിന്യഃ കിമിഹാസ്മാഭിഃ സഹ നോ? ഇത്ഥം തേ തദർഥേ പ്രത്യൂഹം ഗതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","തദാ യീശുസ്തേഭ്യോഽകഥയത് സ്വദേശം സ്വകുടുമ്ബാൻ സ്വപരിജനാംശ്ച വിനാ കുത്രാപി ഭവിഷ്യദ്വാദീ അസത്കൃതോ ന ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","അപരഞ്ച തേഷാമപ്രത്യയാത് സ വിസ്മിതഃ കിയതാം രോഗിണാം വപുഃഷു ഹസ്തമ് അർപയിത്വാ കേവലം തേഷാമാരോഗ്യകരണാദ് അന്യത് കിമപി ചിത്രകാര്യ്യം കർത്താം ന ശക്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","അഥ സ ചതുർദിക്സ്ഥ ഗ്രാമാൻ ഭ്രമിത്വാ ഉപദിഷ്ടവാൻ ");
INSERT INTO sanmal_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ദ്വാദശശിഷ്യാൻ ആഹൂയ അമേധ്യഭൂതാൻ വശീകർത്താം ശക്തിം ദത്ത്വാ തേഷാം ദ്വൗ ദ്വൗ ജനോ പ്രേഷിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","പുനരിത്യാദിശദ് യൂയമ് ഏകൈകാം യഷ്ടിം വിനാ വസ്ത്രസംപുടഃ പൂപഃ കടിബന്ധേ താമ്രഖണ്ഡഞ്ച ഏഷാം കിമപി മാ ഗ്രഹ്ലീത, ");
INSERT INTO sanmal_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","മാർഗയാത്രായൈ പാദേഷൂപാനഹൗ ദത്ത്വാ ദ്വേ ഉത്തരീയേ മാ പരിധദ്വ്വം| ");
INSERT INTO sanmal_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","അപരമപ്യുക്തം തേന യൂയം യസ്യാം പുര്യ്യാം യസ്യ നിവേശനം പ്രവേക്ഷ്യഥ താം പുരീം യാവന്ന ത്യക്ഷ്യഥ താവത് തന്നിവേശനേ സ്ഥാസ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","തത്ര യദി കേപി യുഷ്മാകമാതിഥ്യം ന വിദധതി യുഷ്മാകം കഥാശ്ച ന ശൃണ്വന്തി തർഹി തത്സ്ഥാനാത് പ്രസ്ഥാനസമയേ തേഷാം വിരുദ്ധം സാക്ഷ്യം ദാതും സ്വപാദാനാസ്ഫാല്യ രജഃ സമ്പാതയത; അഹം യുഷ്മാൻ യഥാർഥം വച്മി വിചാരദിനേ തന്നഗരസ്യാവസ്ഥാതഃ സിദോമാമോരയോ ർനഗരയോരവസ്ഥാ സഹ്യതരാ ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","അഥ തേ ഗത്വാ ലോകാനാം മനഃപരാവർത്തനീഃ കഥാ പ്രചാരിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ഏവമനേകാൻ ഭൂതാംശ്ച ത്യാജിതവന്തസ്തഥാ തൈലേന മർദ്ദയിത്വാ ബഹൂൻ ജനാനരോഗാനകാർഷുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ഇത്ഥം തസ്യ സുഖ്യാതിശ്ചതുർദിശോ വ്യാപ്താ തദാ ഹേരോദ് രാജാ തന്നിശമ്യ കഥിതവാൻ, യോഹൻ മജ്ജകഃ ശ്മശാനാദ് ഉത്ഥിത അതോഹേതോസ്തേന സർവ്വാ ഏതാ അദ്ഭുതക്രിയാഃ പ്രകാശന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","അന്യേഽകഥയൻ അയമ് ഏലിയഃ, കേപി കഥിതവന്ത ഏഷ ഭവിഷ്യദ്വാദീ യദ്വാ ഭവിഷ്യദ്വാദിനാം സദൃശ ഏകോയമ്| ");
INSERT INTO sanmal_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","കിന്തു ഹേരോദ് ഇത്യാകർണ്യ ഭാഷിതവാൻ യസ്യാഹം ശിരശ്ഛിന്നവാൻ സ ഏവ യോഹനയം സ ശ്മശാനാദുദതിഷ്ഠത്| ");
INSERT INTO sanmal_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","പൂർവ്വം സ്വഭ്രാതുഃ ഫിലിപസ്യ പത്ന്യാ ഉദ്വാഹം കൃതവന്തം ഹേരോദം യോഹനവാദീത് സ്വഭാതൃവധൂ ർന വിവാഹ്യാ| ");
INSERT INTO sanmal_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","അതഃ കാരണാത് ഹേരോദ് ലോകം പ്രഹിത്യ യോഹനം ധൃത്വാ ബന്ധനാലയേ ബദ്ധവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ഹേരോദിയാ തസ്മൈ യോഹനേ പ്രകുപ്യ തം ഹന്തുമ് ഐച്ഛത് കിന്തു ന ശക്താ, ");
INSERT INTO sanmal_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","യസ്മാദ് ഹേരോദ് തം ധാർമ്മികം സത്പുരുഷഞ്ച ജ്ഞാത്വാ സമ്മന്യ രക്ഷിതവാൻ; തത്കഥാം ശ്രുത്വാ തദനുസാരേണ ബഹൂനി കർമ്മാണി കൃതവാൻ ഹൃഷ്ടമനാസ്തദുപദേശം ശ്രുതവാംശ്ച| ");
INSERT INTO sanmal_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","കിന്തു ഹേരോദ് യദാ സ്വജന്മദിനേ പ്രധാനലോകേഭ്യഃ സേനാനീഭ്യശ്ച ഗാലീൽപ്രദേശീയശ്രേഷ്ഠലോകേഭ്യശ്ച രാത്രൗ ഭോജ്യമേകം കൃതവാൻ ");
INSERT INTO sanmal_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","തസ്മിൻ ശുഭദിനേ ഹേരോദിയായാഃ കന്യാ സമേത്യ തേഷാം സമക്ഷം സംനൃത്യ ഹേരോദസ്തേന സഹോപവിഷ്ടാനാഞ്ച തോഷമജീജനത് തതാ നൃപഃ കന്യാമാഹ സ്മ മത്തോ യദ് യാചസേ തദേവ തുഭ്യം ദാസ്യേ| ");
INSERT INTO sanmal_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ശപഥം കൃത്വാകഥയത് ചേദ് രാജ്യാർദ്ധമപി യാചസേ തദപി തുഭ്യം ദാസ്യേ| ");
INSERT INTO sanmal_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","തതഃ സാ ബഹി ർഗത്വാ സ്വമാതരം പപ്രച്ഛ കിമഹം യാചിഷ്യേ? തദാ സാകഥയത് യോഹനോ മജ്ജകസ്യ ശിരഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","അഥ തൂർണം ഭൂപസമീപമ് ഏത്യ യാചമാനാവദത് ക്ഷണേസ്മിൻ യോഹനോ മജ്ജകസ്യ ശിരഃ പാത്രേ നിധായ ദേഹി, ഏതദ് യാചേഽഹം| ");
INSERT INTO sanmal_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","തസ്മാത് ഭൂപോഽതിദുഃഖിതഃ, തഥാപി സ്വശപഥസ്യ സഹഭോജിനാഞ്ചാനുരോധാത് തദനങ്ഗീകർത്തും ന ശക്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","തത്ക്ഷണം രാജാ ഘാതകം പ്രേഷ്യ തസ്യ ശിര ആനേതുമാദിഷ്ടവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","തതഃ സ കാരാഗാരം ഗത്വാ തച്ഛിരശ്ഛിത്വാ പാത്രേ നിധായാനീയ തസ്യൈ കന്യായൈ ദത്തവാൻ കന്യാ ച സ്വമാത്രേ ദദൗ| ");
INSERT INTO sanmal_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","അനനതരം യോഹനഃ ശിഷ്യാസ്തദ്വാർത്താം പ്രാപ്യാഗത്യ തസ്യ കുണപം ശ്മശാനേഽസ്ഥാപയൻ| ");
INSERT INTO sanmal_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","അഥ പ്രേഷിതാ യീശോഃ സന്നിധൗ മിലിതാ യദ് യച് ചക്രുഃ ശിക്ഷയാമാസുശ്ച തത്സർവ്വവാർത്താസ്തസ്മൈ കഥിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","സ താനുവാച യൂയം വിജനസ്ഥാനം ഗത്വാ വിശ്രാമ്യത യതസ്തത്സന്നിധൗ ബഹുലോകാനാം സമാഗമാത് തേ ഭോക്തും നാവകാശം പ്രാപ്താഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","തതസ്തേ നാവാ വിജനസ്ഥാനം ഗുപ്തം ഗഗ്മുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","തതോ ലോകനിവഹസ്തേഷാം സ്ഥാനാന്തരയാനം ദദർശ, അനേകേ തം പരിചിത്യ നാനാപുരേഭ്യഃ പദൈർവ്രജിത്വാ ജവേന തൈഷാമഗ്രേ യീശോഃ സമീപ ഉപതസ്ഥുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","തദാ യീശു ർനാവോ ബഹിർഗത്യ ലോകാരണ്യാനീം ദൃഷ്ട്വാ തേഷു കരുണാം കൃതവാൻ യതസ്തേഽരക്ഷകമേഷാ ഇവാസൻ തദാ സ താന നാനാപ്രസങ്ഗാൻ ഉപദിഷ്ടവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","അഥ ദിവാന്തേ സതി ശിഷ്യാ ഏത്യ യീശുമൂചിരേ, ഇദം വിജനസ്ഥാനം ദിനഞ്ചാവസന്നം| ");
INSERT INTO sanmal_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ലോകാനാം കിമപി ഖാദ്യം നാസ്തി, അതശ്ചതുർദിക്ഷു ഗ്രാമാൻ ഗന്തും ഭോജ്യദ്രവ്യാണി ക്രേതുഞ്ച ഭവാൻ താൻ വിസൃജതു| ");
INSERT INTO sanmal_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","തദാ സ താനുവാച യൂയമേവ താൻ ഭോജയത; തതസ്തേ ജഗദു ർവയം ഗത്വാ ദ്വിശതസംഖ്യകൈ ർമുദ്രാപാദൈഃ പൂപാൻ ക്രീത്വാ കിം താൻ ഭോജയിഷ്യാമഃ? ");
INSERT INTO sanmal_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","തദാ സ താൻ പൃഷ്ഠവാൻ യുഷ്മാകം സന്നിധൗ കതി പൂപാ ആസതേ? ഗത്വാ പശ്യത; തതസ്തേ ദൃഷ്ട്വാ തമവദൻ പഞ്ച പൂപാ ദ്വൗ മത്സ്യൗ ച സന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","തദാ സ ലോകാൻ ശസ്പോപരി പംക്തിഭിരുപവേശയിതുമ് ആദിഷ്ടവാൻ, ");
INSERT INTO sanmal_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","തതസ്തേ ശതം ശതം ജനാഃ പഞ്ചാശത് പഞ്ചാശജ്ജനാശ്ച പംക്തിഭി ർഭുവി സമുപവിവിശുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","അഥ സ താൻ പഞ്ചപൂപാൻ മത്സ്യദ്വയഞ്ച ധൃത്വാ സ്വർഗം പശ്യൻ ഈശ്വരഗുണാൻ അന്വകീർത്തയത് താൻ പൂപാൻ ഭംക്ത്വാ ലോകേഭ്യഃ പരിവേഷയിതും ശിഷ്യേഭ്യോ ദത്തവാൻ ദ്വാ മത്സ്യൗ ച വിഭജ്യ സർവ്വേഭ്യോ ദത്തവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","തതഃ സർവ്വേ ഭുക്ത്വാതൃപ്യൻ| ");
INSERT INTO sanmal_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","അനന്തരം ശിഷ്യാ അവശിഷ്ടൈഃ പൂപൈ ർമത്സ്യൈശ്ച പൂർണാൻ ദ്വദശ ഡല്ലകാൻ ജഗൃഹുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","തേ ഭോക്താരഃ പ്രായഃ പഞ്ച സഹസ്രാണി പുരുഷാ ആസൻ| ");
INSERT INTO sanmal_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","അഥ സ ലോകാൻ വിസൃജന്നേവ നാവമാരോഢും സ്വസ്മാദഗ്രേ പാരേ ബൈത്സൈദാപുരം യാതുഞ്ച ശ്ഷ്യിाൻ വാഢമാദിഷ്ടവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","തദാ സ സർവ്വാൻ വിസൃജ്യ പ്രാർഥയിതും പർവ്വതം ഗതഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","തതഃ സന്ധ്യായാം സത്യാം നൗഃ സിന്ധുമധ്യ ഉപസ്ഥിതാ കിന്തു സ ഏകാകീ സ്ഥലേ സ്ഥിതഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","അഥ സമ്മുഖവാതവഹനാത് ശിഷ്യാ നാവം വാഹയിത്വാ പരിശ്രാന്താ ഇതി ജ്ഞാത്വാ സ നിശാചതുർഥയാമേ സിന്ധൂപരി പദ്ഭ്യാം വ്രജൻ തേഷാം സമീപമേത്യ തേഷാമഗ്രേ യാതുമ് ഉദ്യതഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","കിന്തു ശിഷ്യാഃ സിന്ധൂപരി തം വ്രജന്തം ദൃഷ്ട്വാ ഭൂതമനുമായ രുരുവുഃ, ");
INSERT INTO sanmal_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","യതഃ സർവ്വേ തം ദൃഷ്ട്വാ വ്യാകുലിതാഃ| അതഏവ യീശുസ്തത്ക്ഷണം തൈഃ സഹാലപ്യ കഥിതവാൻ, സുസ്ഥിരാ ഭൂത, അയമഹം മാ ഭൈഷ്ട| ");
INSERT INTO sanmal_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","അഥ നൗകാമാരുഹ്യ തസ്മിൻ തേഷാം സന്നിധിം ഗതേ വാതോ നിവൃത്തഃ; തസ്മാത്തേ മനഃസു വിസ്മിതാ ആശ്ചര്യ്യം മേനിരേ| ");
INSERT INTO sanmal_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","യതസ്തേ മനസാം കാഠിന്യാത് തത് പൂപീയമ് ആശ്ചര്യ്യം കർമ്മ ന വിവിക്തവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","അഥ തേ പാരം ഗത്വാ ഗിനേഷരത്പ്രദേശമേത്യ തട ഉപസ്ഥിതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","തേഷു നൗകാതോ ബഹിർഗതേഷു തത്പ്രദേശീയാ ലോകാസ്തം പരിചിത്യ ");
INSERT INTO sanmal_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ചതുർദിക്ഷു ധാവന്തോ യത്ര യത്ര രോഗിണോ നരാ ആസൻ താൻ സർവ്വാന ഖട്വോപരി നിധായ യത്ര കുത്രചിത് തദ്വാർത്താം പ്രാപുഃ തത് സ്ഥാനമ് ആനേതുമ് ആരേഭിരേ| ");
INSERT INTO sanmal_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","തഥാ യത്ര യത്ര ഗ്രാമേ യത്ര യത്ര പുരേ യത്ര യത്ര പല്ല്യാഞ്ച തേന പ്രവേശഃ കൃതസ്തദ്വർത്മമധ്യേ ലോകാഃ പീഡിതാൻ സ്ഥാപയിത്വാ തസ്യ ചേലഗ്രന്ഥിമാത്രം സ്പ്രഷ്ടുമ് തേഷാമർഥേ തദനുജ്ഞാം പ്രാർഥയന്തഃ യാവന്തോ ലോകാഃ പസ്പൃശുസ്താവന്ത ഏവ ഗദാന്മുക്താഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","അനന്തരം യിരൂശാലമ ആഗതാഃ ഫിരൂശിനോഽധ്യാപകാശ്ച യീശോഃ സമീപമ് ആഗതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","തേ തസ്യ കിയതഃ ശിഷ്യാൻ അശുചികരൈരർഥാദ അപ്രക്ഷാലിതഹസ്തൈ ർഭുഞ്ജതോ ദൃഷ്ട്വാ താനദൂഷയൻ| ");
INSERT INTO sanmal_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","യതഃ ഫിരൂശിനഃ സർവ്വയിഹൂദീയാശ്ച പ്രാചാം പരമ്പരാഗതവാക്യം സമ്മന്യ പ്രതലേന ഹസ്താൻ അപ്രക്ഷാല്യ ന ഭുഞ്ജതേ| ");
INSERT INTO sanmal_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ആപനാദാഗത്യ മജ്ജനം വിനാ ന ഖാദന്തി; തഥാ പാനപാത്രാണാം ജലപാത്രാണാം പിത്തലപാത്രാണാമ് ആസനാനാഞ്ച ജലേ മജ്ജനമ് ഇത്യാദയോന്യേപി ബഹവസ്തേഷാമാചാരാഃ സന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","തേ ഫിരൂശിനോഽധ്യാപകാശ്ച യീശും പപ്രച്ഛുഃ, തവ ശിഷ്യാഃ പ്രാചാം പരമ്പരാഗതവാക്യാനുസാരേണ നാചരന്തോഽപ്രക്ഷാലിതകരൈഃ കുതോ ഭുജംതേ? ");
INSERT INTO sanmal_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","തതഃ സ പ്രത്യുവാച കപടിനോ യുഷ്മാൻ ഉദ്ദിശ്യ യിശയിയഭവിഷ്യദ്വാദീ യുക്തമവാദീത്| യഥാ സ്വകീയൈരധരൈരേതേ സമ്മന്യനതേ സദൈവ മാം| കിന്തു മത്തോ വിപ്രകർഷേ സന്തി തേഷാം മനാംസി ച| ");
INSERT INTO sanmal_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ശിക്ഷയന്തോ ബിധീൻ ന്നാജ്ഞാ ഭജന്തേ മാം മുധൈവ തേ| ");
INSERT INTO sanmal_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","യൂയം ജലപാത്രപാനപാത്രാദീനി മജ്ജയന്തോ മനുജപരമ്പരാഗതവാക്യം രക്ഷഥ കിന്തു ഈശ്വരാജ്ഞാം ലംഘധ്വേ; അപരാ ഈദൃശ്യോനേകാഃ ക്രിയാ അപി കുരുധ്വേ| ");
INSERT INTO sanmal_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","അന്യഞ്ചാകഥയത് യൂയം സ്വപരമ്പരാഗതവാക്യസ്യ രക്ഷാർഥം സ്പഷ്ടരൂപേണ ഈശ്വരാജ്ഞാം ലോപയഥ| ");
INSERT INTO sanmal_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","യതോ മൂസാദ്വാരാ പ്രോക്തമസ്തി സ്വപിതരൗ സമ്മന്യധ്വം യസ്തു മാതരം പിതരം വാ ദുർവ്വാക്യം വക്തി സ നിതാന്തം ഹന്യതാം| ");
INSERT INTO sanmal_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","കിന്തു മദീയേന യേന ദ്രവ്യേണ തവോപകാരോഭവത് തത് കർബ്ബാണമർഥാദ് ഈശ്വരായ നിവേദിതമ് ഇദം വാക്യം യദി കോപി പിതരം മാതരം വാ വക്തി ");
INSERT INTO sanmal_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","തർഹി യൂയം മാതുഃ പിതു ർവോപകാരം കർത്താം തം വാരയഥ| ");
INSERT INTO sanmal_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ഇത്ഥം സ്വപ്രചാരിതപരമ്പരാഗതവാക്യേന യൂയമ് ഈശ്വരാജ്ഞാം മുധാ വിധദ്വ്വേ, ഈദൃശാന്യന്യാന്യനേകാനി കർമ്മാണി കുരുധ്വേ| ");
INSERT INTO sanmal_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","അഥ സ ലോകാനാഹൂയ ബഭാഷേ യൂയം സർവ്വേ മദ്വാക്യം ശൃണുത ബുധ്യധ്വഞ്ച| ");
INSERT INTO sanmal_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ബാഹ്യാദന്തരം പ്രവിശ്യ നരമമേധ്യം കർത്താം ശക്നോതി ഈദൃശം കിമപി വസ്തു നാസ്തി, വരമ് അന്തരാദ് ബഹിർഗതം യദ്വസ്തു തന്മനുജമ് അമേധ്യം കരോതി| ");
INSERT INTO sanmal_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","യസ്യ ശ്രോതും ശ്രോത്രേ സ്തഃ സ ശൃണോതു| ");
INSERT INTO sanmal_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","തതഃ സ ലോകാൻ ഹിത്വാ ഗൃഹമധ്യം പ്രവിഷ്ടസ്തദാ ശിഷ്യാസ്തദൃഷ്ടാന്തവാക്യാർഥം പപ്രച്ഛുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","തസ്മാത് സ താൻ ജഗാദ യൂയമപി കിമേതാദൃഗബോധാഃ? കിമപി ദ്രവ്യം ബാഹ്യാദന്തരം പ്രവിശ്യ നരമമേധ്യം കർത്താം ന ശക്നോതി കഥാമിമാം കിം ന ബുധ്യധ്വേ? ");
INSERT INTO sanmal_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","തത് തദന്തർന പ്രവിശതി കിന്തു കുക്ഷിമധ്യം പ്രവിശതി ശേഷേ സർവ്വഭുക്തവസ്തുഗ്രാഹിണി ബഹിർദേശേ നിര്യാതി| ");
INSERT INTO sanmal_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","അപരമപ്യവാദീദ് യന്നരാന്നിരേതി തദേവ നരമമേധ്യം കരോതി| ");
INSERT INTO sanmal_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","യതോഽന്തരാദ് അർഥാൻ മാനവാനാം മനോഭ്യഃ കുചിന്താ പരസ്ത്രീവേശ്യാഗമനം ");
INSERT INTO sanmal_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","നരവധശ്ചൗര്യ്യം ലോഭോ ദുഷ്ടതാ പ്രവഞ്ചനാ കാമുകതാ കുദൃഷ്ടിരീശ്വരനിന്ദാ ഗർവ്വസ്തമ ഇത്യാദീനി നിർഗച്ഛന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ഏതാനി സർവ്വാണി ദുരിതാന്യന്തരാദേത്യ നരമമേധ്യം കുർവ്വന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","അഥ സ ഉത്ഥായ തത്സ്ഥാനാത് സോരസീദോൻപുരപ്രദേശം ജഗാമ തത്ര കിമപി നിവേശനം പ്രവിശ്യ സർവ്വൈരജ്ഞാതഃ സ്ഥാതും മതിഞ്ചക്രേ കിന്തു ഗുപ്തഃ സ്ഥാതും ന ശശാക| ");
INSERT INTO sanmal_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","യതഃ സുരഫൈനികീദേശീയയൂനാനീവംശോദ്ഭവസ്ത്രിയാഃ കന്യാ ഭൂതഗ്രസ്താസീത്| സാ സ്ത്രീ തദ്വാർത്താം പ്രാപ്യ തത്സമീപമാഗത്യ തച്ചരണയോഃ പതിത്വാ ");
INSERT INTO sanmal_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","സ്വകന്യാതോ ഭൂതം നിരാകർത്താം തസ്മിൻ വിനയം കൃതവതീ| ");
INSERT INTO sanmal_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","കിന്തു യീശുസ്താമവദത് പ്രഥമം ബാലകാസ്തൃപ്യന്തു യതോ ബാലകാനാം ഖാദ്യം ഗൃഹീത്വാ കുക്കുരേഭ്യോ നിക്ഷേപോഽനുചിതഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","തദാ സാ സ്ത്രീ തമവാദീത് ഭോഃ പ്രഭോ തത് സത്യം തഥാപി മഞ്ചാധഃസ്ഥാഃ കുക്കുരാ ബാലാനാം കരപതിതാനി ഖാദ്യഖണ്ഡാനി ഖാദന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","തതഃ സോഽകഥയദ് ഏതത്കഥാഹേതോഃ സകുശലാ യാഹി തവ കന്യാം ത്യക്ത്വാ ഭൂതോ ഗതഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","അഥ സാ സ്ത്രീ ഗൃഹം ഗത്വാ കന്യാം ഭൂതത്യക്താം ശയ്യാസ്ഥിതാം ദദർശ| ");
INSERT INTO sanmal_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","പുനശ്ച സ സോരസീദോൻപുരപ്രദേശാത് പ്രസ്ഥായ ദികാപലിദേശസ്യ പ്രാന്തരഭാഗേന ഗാലീൽജലധേഃ സമീപം ഗതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","തദാ ലോകൈരേകം ബധിരം കദ്വദഞ്ച നരം തന്നികടമാനീയ തസ്യ ഗാത്രേ ഹസ്തമർപയിതും വിനയഃ കൃതഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","തതോ യീശു ർലോകാരണ്യാത് തം നിർജനമാനീയ തസ്യ കർണയോങ്ഗുലീ ർദദൗ നിഷ്ഠീവം ദത്ത്വാ ച തജ്ജിഹ്വാം പസ്പർശ| ");
INSERT INTO sanmal_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","അനന്തരം സ്വർഗം നിരീക്ഷ്യ ദീർഘം നിശ്വസ്യ തമവദത് ഇതഫതഃ അർഥാൻ മുക്തോ ഭൂയാത്| ");
INSERT INTO sanmal_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","തതസ്തത്ക്ഷണം തസ്യ കർണൗ മുക്തൗ ജിഹ്വായാശ്ച ജാഡ്യാപഗമാത് സ സുസ്പഷ്ടവാക്യമകഥയത്| ");
INSERT INTO sanmal_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","അഥ സ താൻ വാഢമിത്യാദിദേശ യൂയമിമാം കഥാം കസ്മൈചിദപി മാ കഥയത, കിന്തു സ യതി ന്യഷേധത് തേ തതി ബാഹുല്യേന പ്രാചാരയൻ; ");
INSERT INTO sanmal_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","തേഽതിചമത്കൃത്യ പരസ്പരം കഥയാമാസുഃ സ ബധിരായ ശ്രവണശക്തിം മൂകായ ച കഥനശക്തിം ദത്ത്വാ സർവ്വം കർമ്മോത്തമരൂപേണ ചകാര| ");
INSERT INTO sanmal_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","തദാ തത്സമീപം ബഹവോ ലോകാ ആയാതാ അതസ്തേഷാം ഭോജ്യദ്രവ്യാഭാവാദ് യീശുഃ ശിഷ്യാനാഹൂയ ജഗാദ,| ");
INSERT INTO sanmal_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","ലോകനിവഹേ മമ കൃപാ ജായതേ തേ ദിനത്രയം മയാ സാർദ്ധം സന്തി തേഷാം ഭോജ്യം കിമപി നാസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","തേഷാം മധ്യേഽനേകേ ദൂരാദ് ആഗതാഃ, അഭുക്തേഷു തേഷു മയാ സ്വഗൃഹമഭിപ്രഹിതേഷു തേ പഥി ക്ലമിഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ശിഷ്യാ അവാദിഷുഃ, ഏതാവതോ ലോകാൻ തർപയിതുമ് അത്ര പ്രന്തരേ പൂപാൻ പ്രാപ്തും കേന ശക്യതേ? ");
INSERT INTO sanmal_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","തതഃ സ താൻ പപ്രച്ഛ യുഷ്മാകം കതി പൂപാഃ സന്തി? തേഽകഥയൻ സപ്ത| ");
INSERT INTO sanmal_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","തതഃ സ താല്ലോകാൻ ഭുവി സമുപവേഷ്ടുമ് ആദിശ്യ താൻ സപ്ത പൂപാൻ ധൃത്വാ ഈശ്വരഗുണാൻ അനുകീർത്തയാമാസ, ഭംക്ത്വാ പരിവേഷയിതും ശിഷ്യാൻ പ്രതി ദദൗ, തതസ്തേ ലോകേഭ്യഃ പരിവേഷയാമാസുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","തഥാ തേഷാം സമീപേ യേ ക്ഷുദ്രമത്സ്യാ ആസൻ താനപ്യാദായ ഈശ്വരഗുണാൻ സംകീർത്യ പരിവേഷയിതുമ് ആദിഷ്ടവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","തതോ ലോകാ ഭുക്ത്വാ തൃപ്തിം ഗതാ അവശിഷ്ടഖാദ്യൈഃ പൂർണാഃ സപ്തഡല്ലകാ ഗൃഹീതാശ്ച| ");
INSERT INTO sanmal_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ഏതേ ഭോക്താരഃ പ്രായശ്ചതുഃ സഹസ്രപുരുഷാ ആസൻ തതഃ സ താൻ വിസസർജ| ");
INSERT INTO sanmal_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","അഥ സ ശിഷ്യഃ സഹ നാവമാരുഹ്യ ദൽമാനൂഥാസീമാമാഗതഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","തതഃ പരം ഫിരൂശിന ആഗത്യ തേന സഹ വിവദമാനാസ്തസ്യ പരീക്ഷാർഥമ് ആകാശീയചിഹ്നം ദ്രഷ്ടും യാചിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","തദാ സോഽന്തർദീർഘം നിശ്വസ്യാകഥയത്, ഏതേ വിദ്യമാനനരാഃ കുതശ്ചിൻഹം മൃഗയന്തേ? യുഷ്മാനഹം യഥാർഥം ബ്രവീമി ലോകാനേതാൻ കിമപി ചിഹ്നം ന ദർശയിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","അഥ താൻ ഹിത്വാ പുന ർനാവമ് ആരുഹ്യ പാരമഗാത്| ");
INSERT INTO sanmal_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ഏതർഹി ശിഷ്യൈഃ പൂപേഷു വിസ്മൃതേഷു നാവി തേഷാം സന്നിധൗ പൂപ ഏകഏവ സ്ഥിതഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","തദാനീം യീശുസ്താൻ ആദിഷ്ടവാൻ ഫിരൂശിനാം ഹേരോദശ്ച കിണ്വം പ്രതി സതർകാഃ സാവധാനാശ്ച ഭവത| ");
INSERT INTO sanmal_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","തതസ്തേഽന്യോന്യം വിവേചനം കർതുമ് ആരേഭിരേ, അസ്മാകം സന്നിധൗ പൂപോ നാസ്തീതി ഹേതോരിദം കഥയതി| ");
INSERT INTO sanmal_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","തദ് ബുദ്വ്വാ യീശുസ്തേഭ്യോഽകഥയത് യുഷ്മാകം സ്ഥാനേ പൂപാഭാവാത് കുത ഇത്ഥം വിതർകയഥ? യൂയം കിമദ്യാപി കിമപി ന ജാനീഥ? ബോദ്ധുഞ്ച ന ശക്നുഥ? യാവദദ്യ കിം യുഷ്മാകം മനാംസി കഠിനാനി സന്തി? ");
INSERT INTO sanmal_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","സത്സു നേത്രേഷു കിം ന പശ്യഥ? സത്സു കർണേഷു കിം ന ശൃണുഥ? ന സ്മരഥ ച? ");
INSERT INTO sanmal_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","യദാഹം പഞ്ചപൂപാൻ പഞ്ചസഹസ്രാണാം പുരുഷാണാം മധ്യേ ഭംക്ത്വാ ദത്തവാൻ തദാനീം യൂയമ് അവശിഷ്ടപൂപൈഃ പൂർണാൻ കതി ഡല്ലകാൻ ഗൃഹീതവന്തഃ? തേഽകഥയൻ ദ്വാദശഡല്ലകാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","അപരഞ്ച യദാ ചതുഃസഹസ്രാണാം പുരുഷാണാം മധ്യേ പൂപാൻ ഭംക്ത്വാദദാം തദാ യൂയമ് അതിരിക്തപൂപാനാം കതി ഡല്ലകാൻ ഗൃഹീതവന്തഃ? തേ കഥയാമാസുഃ സപ്തഡല്ലകാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","തദാ സ കഥിതവാൻ തർഹി യൂയമ് അധുനാപി കുതോ ബോദ്വ്വും ന ശക്നുഥ? ");
INSERT INTO sanmal_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","അനന്തരം തസ്മിൻ ബൈത്സൈദാനഗരേ പ്രാപ്തേ ലോകാ അന്ധമേകം നരം തത്സമീപമാനീയ തം സ്പ്രഷ്ടും തം പ്രാർഥയാഞ്ചക്രിരേ| ");
INSERT INTO sanmal_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","തദാ തസ്യാന്ധസ്യ കരൗ ഗൃഹീത്വാ നഗരാദ് ബഹിർദേശം തം നീതവാൻ; തന്നേത്രേ നിഷ്ഠീവം ദത്ത്വാ തദ്ഗാത്രേ ഹസ്താവർപയിത്വാ തം പപ്രച്ഛ, കിമപി പശ്യസി? ");
INSERT INTO sanmal_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","സ നേത്രേ ഉന്മീല്യ ജഗാദ, വൃക്ഷവത് മനുജാൻ ഗച്ഛതോ നിരീക്ഷേ| ");
INSERT INTO sanmal_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","തതോ യീശുഃ പുനസ്തസ്യ നയനയോ ർഹസ്താവർപയിത്വാ തസ്യ നേത്രേ ഉന്മീലയാമാസ; തസ്മാത് സ സ്വസ്ഥോ ഭൂത്വാ സ്പഷ്ടരൂപം സർവ്വലോകാൻ ദദർശ| ");
INSERT INTO sanmal_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","തതഃ പരം ത്വം ഗ്രാമം മാ ഗച്ഛ ഗ്രാമസ്ഥം കമപി ച കിമപ്യനുക്ത്വാ നിജഗൃഹം യാഹീത്യാദിശ്യ യീശുസ്തം നിജഗൃഹം പ്രഹിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","അനന്തരം ശിഷ്യൈഃ സഹിതോ യീശുഃ കൈസരീയാഫിലിപിപുരം ജഗാമ, പഥി ഗച്ഛൻ താനപൃച്ഛത് കോഽഹമ് അത്ര ലോകാഃ കിം വദന്തി? ");
INSERT INTO sanmal_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","തേ പ്രത്യൂചുഃ ത്വാം യോഹനം മജ്ജകം വദന്തി കിന്തു കേപി കേപി ഏലിയം വദന്തി; അപരേ കേപി കേപി ഭവിഷ്യദ്വാദിനാമ് ഏകോ ജന ഇതി വദന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","അഥ സ താനപൃച്ഛത് കിന്തു കോഹമ്? ഇത്യത്ര യൂയം കിം വദഥ? തദാ പിതരഃ പ്രത്യവദത് ഭവാൻ അഭിഷിക്തസ്ത്രാതാ| ");
INSERT INTO sanmal_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","തതഃ സ താൻ ഗാഢമാദിശദ് യൂയം മമ കഥാ കസ്മൈചിദപി മാ കഥയത| ");
INSERT INTO sanmal_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","മനുഷ്യപുത്രേണാവശ്യം ബഹവോ യാതനാ ഭോക്തവ്യാഃ പ്രാചീനലോകൈഃ പ്രധാനയാജകൈരധ്യാപകൈശ്ച സ നിന്ദിതഃ സൻ ഘാതയിഷ്യതേ തൃതീയദിനേ ഉത്ഥാസ്യതി ച, യീശുഃ ശിഷ്യാനുപദേഷ്ടുമാരഭ്യ കഥാമിമാം സ്പഷ്ടമാചഷ്ട| ");
INSERT INTO sanmal_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","തസ്മാത് പിതരസ്തസ്യ ഹസ്തൗ ധൃത്വാ തം തർജ്ജിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","കിന്തു സ മുഖം പരാവർത്യ ശിഷ്യഗണം നിരീക്ഷ്യ പിതരം തർജയിത്വാവാദീദ് ദൂരീഭവ വിഘ്നകാരിൻ ഈശ്വരീയകാര്യ്യാദപി മനുഷ്യകാര്യ്യം തുഭ്യം രോചതതരാം| ");
INSERT INTO sanmal_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","അഥ സ ലോകാൻ ശിഷ്യാംശ്ചാഹൂയ ജഗാദ യഃ കശ്ചിൻ മാമനുഗന്തുമ് ഇച്ഛതി സ ആത്മാനം ദാമ്യതു, സ്വക്രുശം ഗൃഹീത്വാ മത്പശ്ചാദ് ആയാതു| ");
INSERT INTO sanmal_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","യതോ യഃ കശ്ചിത് സ്വപ്രാണം രക്ഷിതുമിച്ഛതി സ തം ഹാരയിഷ്യതി, കിന്തു യഃ കശ്ചിൻ മദർഥം സുസംവാദാർഥഞ്ച പ്രാണം ഹാരയതി സ തം രക്ഷിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","അപരഞ്ച മനുജഃ സർവ്വം ജഗത് പ്രാപ്യ യദി സ്വപ്രാണം ഹാരയതി തർഹി തസ്യ കോ ലാഭഃ? ");
INSERT INTO sanmal_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","നരഃ സ്വപ്രാണവിനിമയേന കിം ദാതും ശക്നോതി? ");
INSERT INTO sanmal_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ഏതേഷാം വ്യഭിചാരിണാം പാപിനാഞ്ച ലോകാനാം സാക്ഷാദ് യദി കോപി മാം മത്കഥാഞ്ച ലജ്ജാസ്പദം ജാനാതി തർഹി മനുജപുത്രോ യദാ ധർമ്മദൂതൈഃ സഹ പിതുഃ പ്രഭാവേണാഗമിഷ്യതി തദാ സോപി തം ലജ്ജാസ്പദം ജ്ഞാസ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","അഥ സ താനവാദീത് യുഷ്മഭ്യമഹം യഥാർഥം കഥയാമി, ഈശ്വരരാജ്യം പരാക്രമേണോപസ്ഥിതം ന ദൃഷ്ട്വാ മൃത്യും നാസ്വാദിഷ്യന്തേ, അത്ര ദണ്ഡായമാനാനാം മധ്യേപി താദൃശാ ലോകാഃ സന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","അഥ ഷഡ്ദിനേഭ്യഃ പരം യീശുഃ പിതരം യാകൂബം യോഹനഞ്ച ഗൃഹീത്വാ ഗിരേരുച്ചസ്യ നിർജനസ്ഥാനം ഗത്വാ തേഷാം പ്രത്യക്ഷേ മൂർത്യന്തരം ദധാര| ");
INSERT INTO sanmal_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","തതസ്തസ്യ പരിധേയമ് ഈദൃശമ് ഉജ്ജ്വലഹിമപാണഡരം ജാതം യദ് ജഗതി കോപി രജകോ ന താദൃക് പാണഡരം കർത്താം ശക്നോതി| ");
INSERT INTO sanmal_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","അപരഞ്ച ഏലിയോ മൂസാശ്ച തേഭ്യോ ദർശനം ദത്ത്വാ യീശുനാ സഹ കഥനം കർത്തുമാരേഭാതേ| ");
INSERT INTO sanmal_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","തദാ പിതരോ യീശുമവാദീത് ഹേ ഗുരോഽസ്മാകമത്ര സ്ഥിതിരുത്തമാ, തതഏവ വയം ത്വത്കൃതേ ഏകാം മൂസാകൃതേ ഏകാമ് ഏലിയകൃതേ ചൈകാം, ഏതാസ്തിസ്രഃ കുടീ ർനിർമ്മാമ| ");
INSERT INTO sanmal_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","കിന്തു സ യദുക്തവാൻ തത് സ്വയം ന ബുബുധേ തതഃ സർവ്വേ ബിഭയാഞ്ചക്രുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ഏതർഹി പയോദസ്താൻ ഛാദയാമാസ, മമയാം പ്രിയഃ പുത്രഃ കഥാസു തസ്യ മനാംസി നിവേശയതേതി നഭോവാണീ തന്മേദ്യാന്നിര്യയൗ| ");
INSERT INTO sanmal_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","അഥ ഹഠാത്തേ ചതുർദിശോ ദൃഷ്ട്വാ യീശും വിനാ സ്വൈഃ സഹിതം കമപി ന ദദൃശുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","തതഃ പരം ഗിരേരവരോഹണകാലേ സ താൻ ഗാഢമ് ദൂത്യാദിദേശ യാവന്നരസൂനോഃ ശ്മശാനാദുത്ഥാനം ന ഭവതി, താവത് ദർശനസ്യാസ്യ വാർത്താ യുഷ്മാഭിഃ കസ്മൈചിദപി ന വക്തവ്യാ| ");
INSERT INTO sanmal_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","തദാ ശ്മശാനാദുത്ഥാനസ്യ കോഭിപ്രായ ഇതി വിചാര്യ്യ തേ തദ്വാക്യം സ്വേഷു ഗോപായാഞ്ചക്രിരേ| ");
INSERT INTO sanmal_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","അഥ തേ യീശും പപ്രച്ഛുഃ പ്രഥമത ഏലിയേനാഗന്തവ്യമ് ഇതി വാക്യം കുത ഉപാധ്യായാ ആഹുഃ? ");
INSERT INTO sanmal_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","തദാ സ പ്രത്യുവാച , ഏലിയഃ പ്രഥമമേത്യ സർവ്വകാര്യ്യാണി സാധയിഷ്യതി; നരപുത്രേ ച ലിപി ര്യഥാസ്തേ തഥൈവ സോപി ബഹുദുഃഖം പ്രാപ്യാവജ്ഞാസ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","കിന്ത്വഹം യുഷ്മാൻ വദാമി , ഏലിയാർഥേ ലിപി ര്യഥാസ്തേ തഥൈവ സ ഏത്യ യയൗ, ലോകാ: സ്വേച്ഛാനുരൂപം തമഭിവ്യവഹരന്തി സ്മ| ");
INSERT INTO sanmal_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","അനന്തരം സ ശിഷ്യസമീപമേത്യ തേഷാം ചതുഃപാർശ്വേ തൈഃ സഹ ബഹുജനാൻ വിവദമാനാൻ അധ്യാപകാംശ്ച ദൃഷ്ടവാൻ; ");
INSERT INTO sanmal_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","കിന്തു സർവ്വലോകാസ്തം ദൃഷ്ട്വൈവ ചമത്കൃത്യ തദാസന്നം ധാവന്തസ്തം പ്രണേമുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","തദാ യീശുരധ്യാപകാനപ്രാക്ഷീദ് ഏതൈഃ സഹ യൂയം കിം വിവദധ്വേ? ");
INSERT INTO sanmal_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","തതോ ലോകാനാം കശ്ചിദേകഃ പ്രത്യവാദീത് ഹേ ഗുരോ മമ സൂനും മൂകം ഭൂതധൃതഞ്ച ഭവദാസന്നമ് ആനയം| ");
INSERT INTO sanmal_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","യദാസൗ ഭൂതസ്തമാക്രമതേ തദൈവ പാതസതി തഥാ സ ഫേണായതേ, ദന്തൈർദന്താൻ ഘർഷതി ക്ഷീണോ ഭവതി ച; തതോ ഹേതോസ്തം ഭൂതം ത്യാജയിതും ഭവച്ഛിഷ്യാൻ നിവേദിതവാൻ കിന്തു തേ ന ശേകുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","തദാ സ തമവാദീത്, രേ അവിശ്വാസിനഃ സന്താനാ യുഷ്മാഭിഃ സഹ കതി കാലാനഹം സ്ഥാസ്യാമി? അപരാൻ കതി കാലാൻ വാ വ ആചാരാൻ സഹിഷ്യേ? തം മദാസന്നമാനയത| ");
INSERT INTO sanmal_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","തതസ്തത്സന്നിധിം സ ആനീയത കിന്തു തം ദൃഷ്ട്വൈവ ഭൂതോ ബാലകം ധൃതവാൻ; സ ച ഭൂമൗ പതിത്വാ ഫേണായമാനോ ലുലോഠ| ");
INSERT INTO sanmal_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","തദാ സ തത്പിതരം പപ്രച്ഛ, അസ്യേദൃശീ ദശാ കതി ദിനാനി ഭൂതാ? തതഃ സോവാദീത് ബാല്യകാലാത്| ");
INSERT INTO sanmal_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","ഭൂതോയം തം നാശയിതും ബഹുവാരാൻ വഹ്നൗ ജലേ ച ന്യക്ഷിപത് കിന്തു യദി ഭവാന കിമപി കർത്താം ശക്നോതി തർഹി ദയാം കൃത്വാസ്മാൻ ഉപകരോതു| ");
INSERT INTO sanmal_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","തദാ യീശുസ്തമവദത് യദി പ്രത്യേതും ശക്നോഷി തർഹി പ്രത്യയിനേ ജനായ സർവ്വം സാധ്യമ്| ");
INSERT INTO sanmal_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","തതസ്തത്ക്ഷണം തദ്ബാലകസ്യ പിതാ പ്രോച്ചൈ രൂവൻ സാശ്രുനേത്രഃ പ്രോവാച, പ്രഭോ പ്രത്യേമി മമാപ്രത്യയം പ്രതികുരു| ");
INSERT INTO sanmal_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","അഥ യീശു ർലോകസങ്ഘം ധാവിത്വായാന്തം ദൃഷ്ട്വാ തമപൂതഭൂതം തർജയിത്വാ ജഗാദ, രേ ബധിര മൂക ഭൂത ത്വമേതസ്മാദ് ബഹിർഭവ പുനഃ കദാപി മാശ്രയൈനം ത്വാമഹമ് ഇത്യാദിശാമി| ");
INSERT INTO sanmal_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","തദാ സ ഭൂതശ്ചീത്ശബ്ദം കൃത്വാ തമാപീഡ്യ ബഹിർജജാമ, തതോ ബാലകോ മൃതകൽപോ ബഭൂവ തസ്മാദയം മൃതഇത്യനേകേ കഥയാമാസുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","കിന്തു കരം ധൃത്വാ യീശുനോത്ഥാപിതഃ സ ഉത്തസ്ഥൗ| ");
INSERT INTO sanmal_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","അഥ യീശൗ ഗൃഹം പ്രവിഷ്ടേ ശിഷ്യാ ഗുപ്തം തം പപ്രച്ഛുഃ, വയമേനം ഭൂതം ത്യാജയിതും കുതോ ന ശക്താഃ? ");
INSERT INTO sanmal_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","സ ഉവാച, പ്രാർഥനോപവാസൗ വിനാ കേനാപ്യന്യേന കർമ്മണാ ഭൂതമീദൃശം ത്യാജയിതും ന ശക്യം| ");
INSERT INTO sanmal_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","അനന്തരം സ തത്സ്ഥാനാദിത്വാ ഗാലീൽമധ്യേന യയൗ, കിന്തു തത് കോപി ജാനീയാദിതി സ നൈച്ഛത്| ");
INSERT INTO sanmal_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","അപരഞ്ച സ ശിഷ്യാനുപദിശൻ ബഭാഷേ, നരപുത്രോ നരഹസ്തേഷു സമർപയിഷ്യതേ തേ ച തം ഹനിഷ്യന്തി തൈസ്തസ്മിൻ ഹതേ തൃതീയദിനേ സ ഉത്ഥാസ്യതീതി| ");
INSERT INTO sanmal_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","കിന്തു തത്കഥാം തേ നാബുധ്യന്ത പ്രഷ്ടുഞ്ച ബിഭ്യഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","അഥ യീശുഃ കഫർനാഹൂമ്പുരമാഗത്യ മധ്യേഗൃഹഞ്ചേത്യ താനപൃച്ഛദ് വർത്മമധ്യേ യൂയമന്യോന്യം കിം വിവദധ്വേ സ്മ? ");
INSERT INTO sanmal_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","കിന്തു തേ നിരുത്തരാസ്തസ്ഥു ര്യസ്മാത്തേഷാം കോ മുഖ്യ ഇതി വർത്മാനി തേഽന്യോന്യം വ്യവദന്ത| ");
INSERT INTO sanmal_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","തതഃ സ ഉപവിശ്യ ദ്വാദശശിഷ്യാൻ ആഹൂയ ബഭാഷേ യഃ കശ്ചിത് മുഖ്യോ ഭവിതുമിച്ഛതി സ സർവ്വേഭ്യോ ഗൗണഃ സർവ്വേഷാം സേവകശ്ച ഭവതു| ");
INSERT INTO sanmal_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","തദാ സ ബാലകമേകം ഗൃഹീത്വാ മധ്യേ സമുപാവേശയത് തതസ്തം ക്രോഡേ കൃത്വാ താനവാദാത് ");
INSERT INTO sanmal_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","യഃ കശ്ചിദീദൃശസ്യ കസ്യാപി ബാലസ്യാതിഥ്യം കരോതി സ മമാതിഥ്യം കരോതി; യഃ കശ്ചിന്മമാതിഥ്യം കരോതി സ കേവലമ് മമാതിഥ്യം കരോതി തന്ന മത്പ്രേരകസ്യാപ്യാതിഥ്യം കരോതി| ");
INSERT INTO sanmal_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","അഥ യോഹൻ തമബ്രവീത് ഹേ ഗുരോ, അസ്മാകമനനുഗാമിനമ് ഏകം ത്വാന്നാമ്നാ ഭൂതാൻ ത്യാജയന്തം വയം ദൃഷ്ടവന്തഃ, അസ്മാകമപശ്ചാദ്ഗാമിത്വാച്ച തം ന്യഷേധാമ| ");
INSERT INTO sanmal_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","കിന്തു യീശുരവദത് തം മാ നിഷേധത്, യതോ യഃ കശ്ചിൻ മന്നാമ്നാ ചിത്രം കർമ്മ കരോതി സ സഹസാ മാം നിന്ദിതും ന ശക്നോതി| ");
INSERT INTO sanmal_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","തഥാ യഃ കശ്ചിദ് യുഷ്മാകം വിപക്ഷതാം ന കരോതി സ യുഷ്മാകമേവ സപക്ഷഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","യഃ കശ്ചിദ് യുഷ്മാൻ ഖ്രീഷ്ടശിഷ്യാൻ ജ്ഞാത്വാ മന്നാമ്നാ കംസൈകേന പാനീയം പാതും ദദാതി, യുഷ്മാനഹം യഥാർഥം വച്മി, സ ഫലേന വഞ്ചിതോ ന ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","കിന്തു യദി കശ്ചിൻ മയി വിശ്വാസിനാമേഷാം ക്ഷുദ്രപ്രാണിനാമ് ഏകസ്യാപി വിഘ്നം ജനയതി, തർഹി തസ്യൈതത്കർമ്മ കരണാത് കണ്ഠബദ്ധപേഷണീകസ്യ തസ്യ സാഗരാഗാധജല മജ്ജനം ഭദ്രം| ");
INSERT INTO sanmal_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","അതഃ സ്വകരോ യദി ത്വാം ബാധതേ തർഹി തം ഛിന്ധി; ");
INSERT INTO sanmal_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","യസ്മാത് യത്ര കീടാ ന മ്രിയന്തേ വഹ്നിശ്ച ന നിർവ്വാതി, തസ്മിൻ അനിർവ്വാണാനലനരകേ കരദ്വയവസ്തവ ഗമനാത് കരഹീനസ്യ സ്വർഗപ്രവേശസ്തവ ക്ഷേമം| ");
INSERT INTO sanmal_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","യദി തവ പാദോ വിഘ്നം ജനയതി തർഹി തം ഛിന്ധി, ");
INSERT INTO sanmal_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","യതോ യത്ര കീടാ ന മ്രിയന്തേ വഹ്നിശ്ച ന നിർവ്വാതി, തസ്മിൻ ഽനിർവ്വാണവഹ്നൗ നരകേ ദ്വിപാദവതസ്തവ നിക്ഷേപാത് പാദഹീനസ്യ സ്വർഗപ്രവേശസ്തവ ക്ഷേമം| ");
INSERT INTO sanmal_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","സ്വനേത്രം യദി ത്വാം ബാധതേ തർഹി തദപ്യുത്പാടയ, യതോ യത്ര കീടാ ന മ്രിയന്തേ വഹ്നിശ്ച ന നിർവ്വാതി, ");
INSERT INTO sanmal_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","തസ്മിന ഽനിർവ്വാണവഹ്നൗ നരകേ ദ്വിനേത്രസ്യ തവ നിക്ഷേപാദ് ഏകനേത്രവത ഈശ്വരരാജ്യേ പ്രവേശസ്തവ ക്ഷേമം| ");
INSERT INTO sanmal_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","യഥാ സർവ്വോ ബലി ർലവണാക്തഃ ക്രിയതേ തഥാ സർവ്വോ ജനോ വഹ്നിരൂപേണ ലവണാക്തഃ കാരിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","ലവണം ഭദ്രം കിന്തു യദി ലവണേ സ്വാദുതാ ന തിഷ്ഠതി, തർഹി കഥമ് ആസ്വാദ്യുക്തം കരിഷ്യഥ? യൂയം ലവണയുക്താ ഭവത പരസ്പരം പ്രേമ കുരുത| ");
INSERT INTO sanmal_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","അനന്തരം സ തത്സ്ഥാനാത് പ്രസ്ഥായ യർദ്ദനനദ്യാഃ പാരേ യിഹൂദാപ്രദേശ ഉപസ്ഥിതവാൻ, തത്ര തദന്തികേ ലോകാനാം സമാഗമേ ജാതേ സ നിജരീത്യനുസാരേണ പുനസ്താൻ ഉപദിദേശ| ");
INSERT INTO sanmal_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","തദാ ഫിരൂശിനസ്തത്സമീപമ് ഏത്യ തം പരീക്ഷിതും പപ്രച്ഛഃ സ്വജായാ മനുജാനാം ത്യജ്യാ ന വേതി? ");
INSERT INTO sanmal_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","തതഃ സ പ്രത്യവാദീത്, അത്ര കാര്യ്യേ മൂസാ യുഷ്മാൻ പ്രതി കിമാജ്ഞാപയത്? ");
INSERT INTO sanmal_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ത ഊചുഃ ത്യാഗപത്രം ലേഖിതും സ്വപത്നീം ത്യക്തുഞ്ച മൂസാഽനുമന്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","തദാ യീശുഃ പ്രത്യുവാച, യുഷ്മാകം മനസാം കാഠിന്യാദ്ധേതോ ർമൂസാ നിദേശമിമമ് അലിഖത്| ");
INSERT INTO sanmal_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","കിന്തു സൃഷ്ടേരാദൗ ഈശ്വരോ നരാൻ പുംരൂപേണ സ്ത്രീരൂപേണ ച സസർജ| ");
INSERT INTO sanmal_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","\"തതഃ കാരണാത് പുമാൻ പിതരം മാതരഞ്ച ത്യക്ത്വാ സ്വജായായാമ് ആസക്തോ ഭവിഷ്യതി, ");
INSERT INTO sanmal_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","തൗ ദ്വാവ് ഏകാങ്ഗൗ ഭവിഷ്യതഃ| \" തസ്മാത് തത്കാലമാരഭ്യ തൗ ന ദ്വാവ് ഏകാങ്ഗൗ| ");
INSERT INTO sanmal_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","അതഃ കാരണാദ് ഈശ്വരോ യദയോജയത് കോപി നരസ്തന്ന വിയേജയേത്| ");
INSERT INTO sanmal_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","അഥ യീശു ർഗൃഹം പ്രവിഷ്ടസ്തദാ ശിഷ്യാഃ പുനസ്തത്കഥാം തം പപ്രച്ഛുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","തതഃ സോവദത് കശ്ചിദ് യദി സ്വഭാര്യ്യാം ത്യക്തവാന്യാമ് ഉദ്വഹതി തർഹി സ സ്വഭാര്യ്യായാഃ പ്രാതികൂല്യേന വ്യഭിചാരീ ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","കാചിന്നാരീ യദി സ്വപതിം ഹിത്വാന്യപുംസാ വിവാഹിതാ ഭവതി തർഹി സാപി വ്യഭിചാരിണീ ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","അഥ സ യഥാ ശിശൂൻ സ്പൃശേത്, തദർഥം ലോകൈസ്തദന്തികം ശിശവ ആനീയന്ത, കിന്തു ശിഷ്യാസ്താനാനീതവതസ്തർജയാമാസുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","യീശുസ്തദ് ദൃഷ്ട്വാ ക്രുധ്യൻ ജഗാദ, മന്നികടമ് ആഗന്തും ശിശൂൻ മാ വാരയത, യത ഏതാദൃശാ ഈശ്വരരാജ്യാധികാരിണഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","യുഷ്മാനഹം യഥാർഥം വച്മി, യഃ കശ്ചിത് ശിശുവദ് ഭൂത്വാ രാജ്യമീശ്വരസ്യ ന ഗൃഹ്ലീയാത് സ കദാപി തദ്രാജ്യം പ്രവേഷ്ടും ന ശക്നോതി| ");
INSERT INTO sanmal_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","അനനതരം സ ശിശൂനങ്കേ നിധായ തേഷാം ഗാത്രേഷു ഹസ്തൗ ദത്ത്വാശിഷം ബഭാഷേ| ");
INSERT INTO sanmal_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","അഥ സ വർത്മനാ യാതി, ഏതർഹി ജന ഏകോ ധാവൻ ആഗത്യ തത്സമ്മുഖേ ജാനുനീ പാതയിത്വാ പൃഷ്ടവാൻ, ഭോഃ പരമഗുരോ, അനന്തായുഃ പ്രാപ്തയേ മയാ കിം കർത്തവ്യം? ");
INSERT INTO sanmal_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","തദാ യീശുരുവാച, മാം പരമം കുതോ വദസി? വിനേശ്വരം കോപി പരമോ ന ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","പരസ്ത്രീം നാഭിഗച്ഛ; നരം മാ ഘാതയ; സ്തേയം മാ കുരു; മൃഷാസാക്ഷ്യം മാ ദേഹി; ഹിംസാഞ്ച മാ കുരു; പിതരൗ സമ്മന്യസ്വ; നിദേശാ ഏതേ ത്വയാ ജ്ഞാതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","തതസ്തന പ്രത്യുക്തം, ഹേ ഗുരോ ബാല്യകാലാദഹം സർവ്വാനേതാൻ ആചരാമി| ");
INSERT INTO sanmal_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","തദാ യീശുസ്തം വിലോക്യ സ്നേഹേന ബഭാഷേ, തവൈകസ്യാഭാവ ആസ്തേ; ത്വം ഗത്വാ സർവ്വസ്വം വിക്രീയ ദരിദ്രേഭ്യോ വിശ്രാണയ, തതഃ സ്വർഗേ ധനം പ്രാപ്സ്യസി; തതഃ പരമ് ഏത്യ ക്രുശം വഹൻ മദനുവർത്തീ ഭവ| ");
INSERT INTO sanmal_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","കിന്തു തസ്യ ബഹുസമ്പദ്വിദ്യമാനത്വാത് സ ഇമാം കഥാമാകർണ്യ വിഷണോ ദുഃഖിതശ്ച സൻ ജഗാമ| ");
INSERT INTO sanmal_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","അഥ യീശുശ്ചതുർദിശോ നിരീക്ഷ്യ ശിഷ്യാൻ അവാദീത്, ധനിലോകാനാമ് ഈശ്വരരാജ്യപ്രവേശഃ കീദൃഗ് ദുഷ്കരഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","തസ്യ കഥാതഃ ശിഷ്യാശ്ചമച്ചക്രുഃ, കിന്തു സ പുനരവദത്, ഹേ ബാലകാ യേ ധനേ വിശ്വസന്തി തേഷാമ് ഈശ്വരരാജ്യപ്രവേശഃ കീദൃഗ് ദുഷ്കരഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ഈശ്വരരാജ്യേ ധനിനാം പ്രവേശാത് സൂചിരന്ധ്രേണ മഹാങ്ഗസ്യ ഗമനാഗമനം സുകരം| ");
INSERT INTO sanmal_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","തദാ ശിഷ്യാ അതീവ വിസ്മിതാഃ പരസ്പരം പ്രോചുഃ, തർഹി കഃ പരിത്രാണം പ്രാപ്തും ശക്നോതി? ");
INSERT INTO sanmal_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","തതോ യീശുസ്താൻ വിലോക്യ ബഭാഷേ, തൻ നരസ്യാസാധ്യം കിന്തു നേശ്വരസ്യ, യതോ ഹേതോരീശ്വരസ്യ സർവ്വം സാധ്യമ്| ");
INSERT INTO sanmal_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","തദാ പിതര ഉവാച, പശ്യ വയം സർവ്വം പരിത്യജ്യ ഭവതോനുഗാമിനോ ജാതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","തതോ യീശുഃ പ്രത്യവദത്, യുഷ്മാനഹം യഥാർഥം വദാമി, മദർഥം സുസംവാദാർഥം വാ യോ ജനഃ സദനം ഭ്രാതരം ഭഗിനീം പിതരം മാതരം ജായാം സന്താനാൻ ഭൂമി വാ ത്യക്ത്വാ ");
INSERT INTO sanmal_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ഗൃഹഭ്രാതൃഭഗിനീപിതൃമാതൃപത്നീസന്താനഭൂമീനാമിഹ ശതഗുണാൻ പ്രേത്യാനന്തായുശ്ച ന പ്രാപ്നോതി താദൃശഃ കോപി നാസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","കിന്ത്വഗ്രീയാ അനേകേ ലോകാഃ ശേഷാഃ, ശേഷീയാ അനേകേ ലോകാശ്ചാഗ്രാ ഭവിഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","അഥ യിരൂശാലമ്യാനകാലേ യീശുസ്തേഷാമ് അഗ്രഗാമീ ബഭൂവ, തസ്മാത്തേ ചിത്രം ജ്ഞാത്വാ പശ്ചാദ്ഗാമിനോ ഭൂത്വാ ബിഭ്യുഃ| തദാ സ പുന ർദ്വാദശശിഷ്യാൻ ഗൃഹീത്വാ സ്വീയം യദ്യദ് ഘടിഷ്യതേ തത്തത് തേഭ്യഃ കഥയിതും പ്രാരേഭേ; ");
INSERT INTO sanmal_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","പശ്യത വയം യിരൂശാലമ്പുരം യാമഃ, തത്ര മനുഷ്യപുത്രഃ പ്രധാനയാജകാനാമ് ഉപാധ്യായാനാഞ്ച കരേഷു സമർപയിഷ്യതേ; തേ ച വധദണ്ഡാജ്ഞാം ദാപയിത്വാ പരദേശീയാനാം കരേഷു തം സമർപയിഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","തേ തമുപഹസ്യ കശയാ പ്രഹൃത്യ തദ്വപുഷി നിഷ്ഠീവം നിക്ഷിപ്യ തം ഹനിഷ്യന്തി, തതഃ സ തൃതീയദിനേ പ്രോത്ഥാസ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","തതഃ സിവദേഃ പുത്രൗ യാകൂബ്യോഹനൗ തദന്തികമ് ഏത്യ പ്രോചതുഃ, ഹേ ഗുരോ യദ് ആവാഭ്യാം യാചിഷ്യതേ തദസ്മദർഥം ഭവാൻ കരോതു നിവേദനമിദമാവയോഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","തതഃ സ കഥിതവാൻ, യുവാം കിമിച്ഛഥഃ? കിം മയാ യുഷ്മദർഥം കരണീയം? ");
INSERT INTO sanmal_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","തദാ തൗ പ്രോചതുഃ, ആവയോരേകം ദക്ഷിണപാർശ്വേ വാമപാർശ്വേ ചൈകം തവൈശ്വര്യ്യപദേ സമുപവേഷ്ടുമ് ആജ്ഞാപയ| ");
INSERT INTO sanmal_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","കിന്തു യീശുഃ പ്രത്യുവാച യുവാമജ്ഞാത്വേദം പ്രാർഥയേഥേ, യേന കംസേനാഹം പാസ്യാമി തേന യുവാഭ്യാം കിം പാതും ശക്ഷ്യതേ? യസ്മിൻ മജ്ജനേനാഹം മജ്ജിഷ്യേ തന്മജ്ജനേ മജ്ജയിതും കിം യുവാഭ്യാം ശക്ഷ്യതേ? തൗ പ്രത്യൂചതുഃ ശക്ഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","തദാ യീശുരവദത് യേന കംസേനാഹം പാസ്യാമി തേനാവശ്യം യുവാമപി പാസ്യഥഃ, യേന മജ്ജനേന ചാഹം മജ്ജിയ്യേ തത്ര യുവാമപി മജ്ജിഷ്യേഥേ| ");
INSERT INTO sanmal_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","കിന്തു യേഷാമർഥമ് ഇദം നിരൂപിതം, താൻ വിഹായാന്യം കമപി മമ ദക്ഷിണപാർശ്വേ വാമപാർശ്വേ വാ സമുപവേശയിതും മമാധികാരോ നാസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","അഥാന്യദശശിഷ്യാ ഇമാം കഥാം ശ്രുത്വാ യാകൂബ്യോഹൻഭ്യാം ചുകുപുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","കിന്തു യീശുസ്താൻ സമാഹൂയ ബഭാഷേ, അന്യദേശീയാനാം രാജത്വം യേ കുർവ്വന്തി തേ തേഷാമേവ പ്രഭുത്വം കുർവ്വന്തി, തഥാ യേ മഹാലോകാസ്തേ തേഷാമ് അധിപതിത്വം കുർവ്വന്തീതി യൂയം ജാനീഥ| ");
INSERT INTO sanmal_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","കിന്തു യുഷ്മാകം മധ്യേ ന തഥാ ഭവിഷ്യതി, യുഷ്മാകം മധ്യേ യഃ പ്രാധാന്യം വാഞ്ഛതി സ യുഷ്മാകം സേവകോ ഭവിഷ്യതി, ");
INSERT INTO sanmal_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","യുഷ്മാകം യോ മഹാൻ ഭവിതുമിച്ഛതി സ സർവ്വേഷാം കിങ്കരോ ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","യതോ മനുഷ്യപുത്രഃ സേവ്യോ ഭവിതും നാഗതഃ സേവാം കർത്താം തഥാനേകേഷാം പരിത്രാണസ്യ മൂല്യരൂപസ്വപ്രാണം ദാതുഞ്ചാഗതഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","അഥ തേ യിരീഹോനഗരം പ്രാപ്താസ്തസ്മാത് ശിഷ്യൈ ർലോകൈശ്ച സഹ യീശോ ർഗമനകാലേ ടീമയസ്യ പുത്രോ ബർടീമയനാമാ അന്ധസ്തന്മാർഗപാർശ്വേ ഭിക്ഷാർഥമ് ഉപവിഷ്ടഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","സ നാസരതീയസ്യ യീശോരാഗമനവാർത്താം പ്രാപ്യ പ്രോചൈ ർവക്തുമാരേഭേ, ഹേ യീശോ ദായൂദഃ സന്താന മാം ദയസ്വ| ");
INSERT INTO sanmal_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","തതോനേകേ ലോകാ മൗനീഭവേതി തം തർജയാമാസുഃ, കിന്തു സ പുനരധികമുച്ചൈ ർജഗാദ, ഹേ യീശോ ദായൂദഃ സന്താന മാം ദയസ്വ| ");
INSERT INTO sanmal_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","തദാ യീശുഃ സ്ഥിത്വാ തമാഹ്വാതും സമാദിദേശ, തതോ ലോകാസ്തമന്ധമാഹൂയ ബഭാഷിരേ, ഹേ നര, സ്ഥിരോ ഭവ, ഉത്തിഷ്ഠ, സ ത്വാമാഹ്വയതി| ");
INSERT INTO sanmal_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","തദാ സ ഉത്തരീയവസ്ത്രം നിക്ഷിപ്യ പ്രോത്ഥായ യീശോഃ സമീപം ഗതഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","തതോ യീശുസ്തമവദത് ത്വയാ കിം പ്രാർഥ്യതേ? തുഭ്യമഹം കിം കരിഷ്യാമീ? തദാ സോന്ധസ്തമുവാച, ഹേ ഗുരോ മദീയാ ദൃഷ്ടിർഭവേത്| ");
INSERT INTO sanmal_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","തതോ യീശുസ്തമുവാച യാഹി തവ വിശ്വാസസ്ത്വാം സ്വസ്ഥമകാർഷീത്, തസ്മാത് തത്ക്ഷണം സ ദൃഷ്ടിം പ്രാപ്യ പഥാ യീശോഃ പശ്ചാദ് യയൗ| ");
INSERT INTO sanmal_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","അനന്തരം തേഷു യിരൂശാലമഃ സമീപസ്ഥയോ ർബൈത്ഫഗീബൈഥനീയപുരയോരന്തികസ്ഥം ജൈതുനനാമാദ്രിമാഗതേഷു യീശുഃ പ്രേഷണകാലേ ദ്വൗ ശിഷ്യാവിദം വാക്യം ജഗാദ, ");
INSERT INTO sanmal_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","യുവാമമും സമ്മുഖസ്ഥം ഗ്രാമം യാതം, തത്ര പ്രവിശ്യ യോ നരം നാവഹത് തം ഗർദ്ദഭശാവകം ദ്രക്ഷ്യഥസ്തം മോചയിത്വാനയതം| ");
INSERT INTO sanmal_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","കിന്തു യുവാം കർമ്മേദം കുതഃ കുരുഥഃ? കഥാമിമാം യദി കോപി പൃച്ഛതി തർഹി പ്രഭോരത്ര പ്രയോജനമസ്തീതി കഥിതേ സ ശീഘ്രം തമത്ര പ്രേഷയിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","തതസ്തൗ ഗത്വാ ദ്വിമാർഗമേലനേ കസ്യചിദ് ദ്വാരസ്യ പാർശ്വേ തം ഗർദ്ദഭശാവകം പ്രാപ്യ മോചയതഃ, ");
INSERT INTO sanmal_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ഏതർഹി തത്രോപസ്ഥിതലോകാനാം കശ്ചിദ് അപൃച്ഛത്, ഗർദ്ദഭശിശും കുതോ മോചയഥഃ? ");
INSERT INTO sanmal_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","തദാ യീശോരാജ്ഞാനുസാരേണ തേഭ്യഃ പ്രത്യുദിതേ തത്ക്ഷണം തമാദാതും തേഽനുജജ്ഞുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","അഥ തൗ യീശോഃ സന്നിധിം ഗർദ്ദഭശിശുമ് ആനീയ തദുപരി സ്വവസ്ത്രാണി പാതയാമാസതുഃ; തതഃ സ തദുപരി സമുപവിഷ്ടഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","തദാനേകേ പഥി സ്വവാസാംസി പാതയാമാസുഃ, പരൈശ്ച തരുശാഖാശ്ഛിതവാ മാർഗേ വികീർണാഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","അപരഞ്ച പശ്ചാദ്ഗാമിനോഽഗ്രഗാമിനശ്ച സർവ്വേ ജനാ ഉചൈഃസ്വരേണ വക്തുമാരേഭിരേ, ജയ ജയ യഃ പരമേശ്വരസ്യ നാമ്നാഗച്ഛതി സ ധന്യ ഇതി| ");
INSERT INTO sanmal_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","തഥാസ്മാകമം പൂർവ്വപുരുഷസ്യ ദായൂദോ യദ്രാജ്യം പരമേശ്വരനാമ്നായാതി തദപി ധന്യം, സർവ്വസ്മാദുച്ഛ്രായേ സ്വർഗേ ഈശ്വരസ്യ ജയോ ഭവേത്| ");
INSERT INTO sanmal_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ഇത്ഥം യീശു ര്യിരൂശാലമി മന്ദിരം പ്രവിശ്യ ചതുർദിക്സ്ഥാനി സർവ്വാണി വസ്തൂനി ദൃഷ്ടവാൻ; അഥ സായംകാല ഉപസ്ഥിതേ ദ്വാദശശിഷ്യസഹിതോ ബൈഥനിയം ജഗാമ| ");
INSERT INTO sanmal_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","അപരേഹനി ബൈഥനിയാദ് ആഗമനസമയേ ക്ഷുധാർത്തോ ബഭൂവ| ");
INSERT INTO sanmal_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","തതോ ദൂരേ സപത്രമുഡുമ്ബരപാദപം വിലോക്യ തത്ര കിഞ്ചിത് ഫലം പ്രാപ്തും തസ്യ സന്നികൃഷ്ടം യയൗ, തദാനീം ഫലപാതനസ്യ സമയോ നാഗച്ഛതി| തതസ്തത്രോപസ്ഥിതഃ പത്രാണി വിനാ കിമപ്യപരം ന പ്രാപ്യ സ കഥിതവാൻ, ");
INSERT INTO sanmal_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","അദ്യാരഭ്യ കോപി മാനവസ്ത്വത്തഃ ഫലം ന ഭുഞ്ജീത; ഇമാം കഥാം തസ്യ ശിഷ്യാഃ ശുശ്രുവുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","തദനന്തരം തേഷു യിരൂശാലമമായാതേഷു യീശു ർമന്ദിരം ഗത്വാ തത്രസ്ഥാനാം ബണിജാം മുദ്രാസനാനി പാരാവതവിക്രേതൃണാമ് ആസനാനി ച ന്യുബ്ജയാഞ്ചകാര സർവ്വാൻ ക്രേതൃൻ വിക്രേതൃംശ്ച ബഹിശ്ചകാര| ");
INSERT INTO sanmal_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","അപരം മന്ദിരമധ്യേന കിമപി പാത്രം വോഢും സർവ്വജനം നിവാരയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ലോകാനുപദിശൻ ജഗാദ, മമ ഗൃഹം സർവ്വജാതീയാനാം പ്രാർഥനാഗൃഹമ് ഇതി നാമ്നാ പ്രഥിതം ഭവിഷ്യതി ഏതത് കിം ശാസ്ത്രേ ലിഖിതം നാസ്തി? കിന്തു യൂയം തദേവ ചോരാണാം ഗഹ്വരം കുരുഥ| ");
INSERT INTO sanmal_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ഇമാം വാണീം ശ്രുത്വാധ്യാപകാഃ പ്രധാനയാജകാശ്ച തം യഥാ നാശയിതും ശക്നുവന്തി തഥോेപായം മൃഗയാമാസുഃ, കിന്തു തസ്യോപദേശാത് സർവ്വേ ലോകാ വിസ്മയം ഗതാ അതസ്തേ തസ്മാദ് ബിഭ്യുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","അഥ സായംസമയ ഉപസ്ഥിതേ യീശുർനഗരാദ് ബഹിർവവ്രാജ| ");
INSERT INTO sanmal_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","അനന്തരം പ്രാതഃകാലേ തേ തേന മാർഗേണ ഗച്ഛന്തസ്തമുഡുമ്ബരമഹീരുഹം സമൂലം ശുഷ്കം ദദൃശുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","തതഃ പിതരഃ പൂർവ്വവാക്യം സ്മരൻ യീശും ബഭാഷം, ഹേ ഗുരോ പശ്യതു യ ഉഡുമ്ബരവിടപീ ഭവതാ ശപ്തഃ സ ശുഷ്കോ ബഭൂവ| ");
INSERT INTO sanmal_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","തതോ യീശുഃ പ്രത്യവാദീത്, യൂയമീശ്വരേ വിശ്വസിത| ");
INSERT INTO sanmal_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","യുഷ്മാനഹം യഥാർഥം വദാമി കോപി യദ്യേതദ്ഗിരിം വദതി, ത്വമുത്ഥായ ഗത്വാ ജലധൗ പത, പ്രോക്തമിദം വാക്യമവശ്യം ഘടിഷ്യതേ, മനസാ കിമപി ന സന്ദിഹ്യ ചേദിദം വിശ്വസേത് തർഹി തസ്യ വാക്യാനുസാരേണ തദ് ഘടിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","അതോ ഹേതോരഹം യുഷ്മാൻ വച്മി, പ്രാർഥനാകാലേ യദ്യദാകാംക്ഷിഷ്യധ്വേ തത്തദവശ്യം പ്രാപ്സ്യഥ, ഇത്ഥം വിശ്വസിത, തതഃ പ്രാപ്സ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","അപരഞ്ച യുഷ്മാസു പ്രാർഥയിതും സമുത്ഥിതേഷു യദി കോപി യുഷ്മാകമ് അപരാധീ തിഷ്ഠതി, തർഹി തം ക്ഷമധ്വം, തഥാ കൃതേ യുഷ്മാകം സ്വർഗസ്ഥഃ പിതാപി യുഷ്മാകമാഗാംമി ക്ഷമിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","കിന്തു യദി ന ക്ഷമധ്വേ തർഹി വഃ സ്വർഗസ്ഥഃ പിതാപി യുഷ്മാകമാഗാംസി ന ക്ഷമിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","അനന്തരം തേ പുന ര്യിരൂശാലമം പ്രവിവിശുഃ, യീശു ര്യദാ മധ്യേമന്ദിരമ് ഇതസ്തതോ ഗച്ഛതി, തദാനീം പ്രധാനയാജകാ ഉപാധ്യായാഃ പ്രാഞ്ചശ്ച തദന്തികമേത്യ കഥാമിമാം പപ്രച്ഛുഃ, ");
INSERT INTO sanmal_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ത്വം കേനാദേശേന കർമ്മാണ്യേതാനി കരോഷി? തഥൈതാനി കർമ്മാണി കർത്താം കേനാദിഷ്ടോസി? ");
INSERT INTO sanmal_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","തതോ യീശുഃ പ്രതിഗദിതവാൻ അഹമപി യുഷ്മാൻ ഏകകഥാം പൃച്ഛാമി, യദി യൂയം തസ്യാ ഉത്തരം കുരുഥ, തർഹി കയാജ്ഞയാഹം കർമ്മാണ്യേതാനി കരോമി തദ് യുഷ്മഭ്യം കഥയിഷ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","യോഹനോ മജ്ജനമ് ഈശ്വരാത് ജാതം കിം മാനവാത്? തന്മഹ്യം കഥയത| ");
INSERT INTO sanmal_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","തേ പരസ്പരം വിവേക്തും പ്രാരേഭിരേ, തദ് ഈശ്വരാദ് ബഭൂവേതി ചേദ് വദാമസ്തർഹി കുതസ്തം ന പ്രത്യൈത? കഥമേതാം കഥയിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","മാനവാദ് അഭവദിതി ചേദ് വദാമസ്തർഹി ലോകേഭ്യോ ഭയമസ്തി യതോ ഹേതോഃ സർവ്വേ യോഹനം സത്യം ഭവിഷ്യദ്വാദിനം മന്യന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","അതഏവ തേ യീശും പ്രത്യവാദിഷു ർവയം തദ് വക്തും ന ശക്നുമഃ| യീശുരുവാച, തർഹി യേനാദേശേന കർമ്മാണ്യേതാനി കരോമി, അഹമപി യുഷ്മഭ്യം തന്ന കഥയിഷ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","അനന്തരം യീശു ർദൃഷ്ടാന്തേന തേഭ്യഃ കഥയിതുമാരേഭേ, കശ്ചിദേകോ ദ്രാക്ഷാക്ഷേത്രം വിധായ തച്ചതുർദിക്ഷു വാരണീം കൃത്വാ തന്മധ്യേ ദ്രാക്ഷാപേഷണകുണ്ഡമ് അഖനത്, തഥാ തസ്യ ഗഡമപി നിർമ്മിതവാൻ തതസ്തത്ക്ഷേത്രം കൃഷീവലേഷു സമർപ്യ ദൂരദേശം ജഗാമ| ");
INSERT INTO sanmal_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","തദനന്തരം ഫലകാലേ കൃഷീവലേഭ്യോ ദ്രാക്ഷാക്ഷേത്രഫലാനി പ്രാപ്തും തേഷാം സവിധേ ഭൃത്യമ് ഏകം പ്രാഹിണോത്| ");
INSERT INTO sanmal_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","കിന്തു കൃഷീവലാസ്തം ധൃത്വാ പ്രഹൃത്യ രിക്തഹസ്തം വിസസൃജുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","തതഃ സ പുനരന്യമേകം ഭൃത്യം പ്രഷയാമാസ, കിന്തു തേ കൃഷീവലാഃ പാഷാണാഘാതൈസ്തസ്യ ശിരോ ഭങ്ക്ത്വാ സാപമാനം തം വ്യസർജൻ| ");
INSERT INTO sanmal_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","തതഃ പരം സോപരം ദാസം പ്രാഹിണോത് തദാ തേ തം ജഘ്നുഃ, ഏവമ് അനേകേഷാം കസ്യചിത് പ്രഹാരഃ കസ്യചിദ് വധശ്ച തൈഃ കൃതഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","തതഃ പരം മയാ സ്വപുത്രേ പ്രഹിതേ തേ തമവശ്യം സമ്മംസ്യന്തേ, ഇത്യുക്ത്വാവശേഷേ തേഷാം സന്നിധൗ നിജപ്രിയമ് അദ്വിതീയം പുത്രം പ്രേഷയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","കിന്തു കൃഷീവലാഃ പരസ്പരം ജഗദുഃ, ഏഷ ഉത്തരാധികാരീ, ആഗച്ഛത വയമേനം ഹന്മസ്തഥാ കൃതേ ഽധികാരോയമ് അസ്മാകം ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","തതസ്തം ധൃത്വാ ഹത്വാ ദ്രാക്ഷാക്ഷേത്രാദ് ബഹിഃ പ്രാക്ഷിപൻ| ");
INSERT INTO sanmal_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","അനേനാസൗ ദ്രാക്ഷാക്ഷേത്രപതിഃ കിം കരിഷ്യതി? സ ഏത്യ താൻ കൃഷീവലാൻ സംഹത്യ തത്ക്ഷേത്രമ് അന്യേഷു കൃഷീവലേഷു സമർപയിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","അപരഞ്ച, \"സ്ഥപതയഃ കരിഷ്യന്തി ഗ്രാവാണം യന്തു തുച്ഛകം| പ്രാധാനപ്രസ്തരഃ കോണേ സ ഏവ സംഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ഏതത് കർമ്മ പരേശസ്യാംദ്ഭുതം നോ ദൃഷ്ടിതോ ഭവേത്|| \" ഇമാം ശാസ്ത്രീയാം ലിപിം യൂയം കിം നാപാഠിഷ്ട? ");
INSERT INTO sanmal_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","തദാനീം സ താനുദ്ദിശ്യ താം ദൃഷ്ടാന്തകഥാം കഥിതവാൻ, ത ഇത്ഥം ബുദ്വ്വാ തം ധർത്താമുദ്യതാഃ, കിന്തു ലോകേഭ്യോ ബിഭ്യുഃ, തദനന്തരം തേ തം വിഹായ വവ്രജുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","അപരഞ്ച തേ തസ്യ വാക്യദോഷം ധർത്താം കതിപയാൻ ഫിരൂശിനോ ഹേരോദീയാംശ്ച ലോകാൻ തദന്തികം പ്രേഷയാമാസുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ത ആഗത്യ തമവദൻ, ഹേ ഗുരോ ഭവാൻ തഥ്യഭാഷീ കസ്യാപ്യനുരോധം ന മന്യതേ, പക്ഷപാതഞ്ച ന കരോതി, യഥാർഥത ഈശ്വരീയം മാർഗം ദർശയതി വയമേതത് പ്രജാനീമഃ, കൈസരായ കരോ ദേയോ ന വാം? വയം ദാസ്യാമോ ന വാ? ");
INSERT INTO sanmal_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","കിന്തു സ തേഷാം കപടം ജ്ഞാത്വാ ജഗാദ, കുതോ മാം പരീക്ഷധ്വേ? ഏകം മുദ്രാപാദം സമാനീയ മാം ദർശയത| ");
INSERT INTO sanmal_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","തദാ തൈരേകസ്മിൻ മുദ്രാപാദേ സമാനീതേ സ താൻ പപ്രച്ഛ, അത്ര ലിഖിതം നാമ മൂർത്തി ർവാ കസ്യ? തേ പ്രത്യൂചുഃ, കൈസരസ്യ| ");
INSERT INTO sanmal_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","തദാ യീശുരവദത് തർഹി കൈസരസ്യ ദ്രവ്യാണി കൈസരായ ദത്ത, ഈശ്വരസ്യ ദ്രവ്യാണി തു ഈശ്വരായ ദത്ത; തതസ്തേ വിസ്മയം മേനിരേ| ");
INSERT INTO sanmal_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","അഥ മൃതാനാമുത്ഥാനം യേ ന മന്യന്തേ തേ സിദൂകിനോ യീശോഃ സമീപമാഗത്യ തം പപ്രച്ഛുഃ; ");
INSERT INTO sanmal_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","ഹേ ഗുരോ കശ്ചിജ്ജനോ യദി നിഃസന്തതിഃ സൻ ഭാര്യ്യായാം സത്യാം മ്രിയതേ തർഹി തസ്യ ഭ്രാതാ തസ്യ ഭാര്യ്യാം ഗൃഹീത്വാ ഭ്രാതു ർവംശോത്പത്തിം കരിഷ്യതി, വ്യവസ്ഥാമിമാം മൂസാ അസ്മാൻ പ്രതി വ്യലിഖത്| ");
INSERT INTO sanmal_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","കിന്തു കേചിത് സപ്ത ഭ്രാതര ആസൻ, തതസ്തേഷാം ജ്യേഷ്ഠഭ്രാതാ വിവഹ്യ നിഃസന്തതിഃ സൻ അമ്രിയത| ");
INSERT INTO sanmal_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","തതോ ദ്വിതീയോ ഭ്രാതാ താം സ്ത്രിയമഗൃഹണത് കിന്തു സോപി നിഃസന്തതിഃ സൻ അമ്രിയത; അഥ തൃതീയോപി ഭ്രാതാ താദൃശോഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ഇത്ഥം സപ്തൈവ ഭ്രാതരസ്താം സ്ത്രിയം ഗൃഹീത്വാ നിഃസന്താനാഃ സന്തോഽമ്രിയന്ത, സർവ്വശേഷേ സാപി സ്ത്രീ മ്രിയതേ സ്മ| ");
INSERT INTO sanmal_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","അഥ മൃതാനാമുത്ഥാനകാലേ യദാ ത ഉത്ഥാസ്യന്തി തദാ തേഷാം കസ്യ ഭാര്യ്യാ സാ ഭവിഷ്യതി? യതസ്തേ സപ്തൈവ താം വ്യവഹൻ| ");
INSERT INTO sanmal_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","തതോ യീശുഃ പ്രത്യുവാച ശാസ്ത്രമ് ഈശ്വരശക്തിഞ്ച യൂയമജ്ഞാത്വാ കിമഭ്രാമ്യത ന? ");
INSERT INTO sanmal_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","മൃതലോകാനാമുത്ഥാനം സതി തേ ന വിവഹന്തി വാഗ്ദത്താ അപി ന ഭവന്തി, കിന്തു സ്വർഗീയദൂതാനാം സദൃശാ ഭവന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","പുനശ്ച \"അഹമ് ഇബ്രാഹീമ ഈശ്വര ഇസ്ഹാക ഈശ്വരോ യാകൂബശ്ചേശ്വരഃ\" യാമിമാം കഥാം സ്തമ്ബമധ്യേ തിഷ്ഠൻ ഈശ്വരോ മൂസാമവാദീത് മൃതാനാമുത്ഥാനാർഥേ സാ കഥാ മൂസാലിഖിതേ പുസ്തകേ കിം യുഷ്മാഭി ർനാപാഠി? ");
INSERT INTO sanmal_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ഈശ്വരോ ജീവതാം പ്രഭുഃ കിന്തു മൃതാനാം പ്രഭു ർന ഭവതി, തസ്മാദ്ധേതോ ര്യൂയം മഹാഭ്രമേണ തിഷ്ഠഥ| ");
INSERT INTO sanmal_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ഏതർഹി ഏകോധ്യാപക ഏത്യ തേഷാമിത്ഥം വിചാരം ശുശ്രാവ; യീശുസ്തേഷാം വാക്യസ്യ സദുത്തരം ദത്തവാൻ ഇതി ബുദ്വ്വാ തം പൃഷ്ടവാൻ സർവ്വാസാമ് ആജ്ഞാനാം കാ ശ്രേഷ്ഠാ? തതോ യീശുഃ പ്രത്യുവാച, ");
INSERT INTO sanmal_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","\"ഹേ ഇസ്രായേല്ലോകാ അവധത്ത, അസ്മാകം പ്രഭുഃ പരമേശ്വര ഏക ഏവ, ");
INSERT INTO sanmal_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","യൂയം സർവ്വന്തഃകരണൈഃ സർവ്വപ്രാണൈഃ സർവ്വചിത്തൈഃ സർവ്വശക്തിഭിശ്ച തസ്മിൻ പ്രഭൗ പരമേശ്വരേ പ്രീയധ്വം,\" ഇത്യാജ്ഞാ ശ്രേഷ്ഠാ| ");
INSERT INTO sanmal_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","തഥാ \"സ്വപ്രതിവാസിനി സ്വവത് പ്രേമ കുരുധ്വം,\" ഏഷാ യാ ദ്വിതീയാജ്ഞാ സാ താദൃശീ; ഏതാഭ്യാം ദ്വാഭ്യാമ് ആജ്ഞാഭ്യാമ് അന്യാ കാപ്യാജ്ഞാ ശ്രേഷ്ഠാ നാസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","തദാ സോധ്യാപകസ്തമവദത്, ഹേ ഗുരോ സത്യം ഭവാൻ യഥാർഥം പ്രോക്തവാൻ യത ഏകസ്മാദ് ഈശ്വരാദ് അന്യോ ദ്വിതീയ ഈശ്വരോ നാസ്തി; ");
INSERT INTO sanmal_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","അപരം സർവ്വാന്തഃകരണൈഃ സർവ്വപ്രാണൈഃ സർവ്വചിത്തൈഃ സർവ്വശക്തിഭിശ്ച ഈശ്വരേ പ്രേമകരണം തഥാ സ്വമീപവാസിനി സ്വവത് പ്രേമകരണഞ്ച സർവ്വേഭ്യോ ഹോമബലിദാനാദിഭ്യഃ ശ്രഷ്ഠം ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","തതോ യീശുഃ സുബുദ്ധേരിവ തസ്യേദമ് ഉത്തരം ശ്രുത്വാ തം ഭാഷിതവാൻ ത്വമീശ്വരസ്യ രാജ്യാന്ന ദൂരോസി| ഇതഃ പരം തേന സഹ കസ്യാപി വാക്യസ്യ വിചാരം കർത്താം കസ്യാപി പ്രഗൽഭതാ ന ജാതാ| ");
INSERT INTO sanmal_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","അനന്തരം മധ്യേമന്ദിരമ് ഉപദിശൻ യീശുരിമം പ്രശ്നം ചകാര, അധ്യാപകാ അഭിഷിക്തം (താരകം) കുതോ ദായൂദഃ സന്താനം വദന്തി? ");
INSERT INTO sanmal_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","സ്വയം ദായൂദ് പവിത്രസ്യാത്മന ആവേശേനേദം കഥയാമാസ| യഥാ| \"മമ പ്രഭുമിദം വാക്യവദത് പരമേശ്വരഃ| തവ ശത്രൂനഹം യാവത് പാദപീഠം കരോമി ന| താവത് കാലം മദീയേ ത്വം ദക്ഷപാർശ്വ് ഉപാവിശ| \" ");
INSERT INTO sanmal_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","യദി ദായൂദ് തം പ്രഭൂം വദതി തർഹി കഥം സ തസ്യ സന്താനോ ഭവിതുമർഹതി? ഇതരേ ലോകാസ്തത്കഥാം ശ്രുത്വാനനന്ദുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","തദാനീം സ താനുപദിശ്യ കഥിതവാൻ യേ നരാ ദീർഘപരിധേയാനി ഹട്ടേ വിപനൗ ച ");
INSERT INTO sanmal_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ലോകകൃതനമസ്കാരാൻ ഭജനഗൃഹേ പ്രധാനാസനാനി ഭോജനകാലേ പ്രധാനസ്ഥാനാനി ച കാങ്ക്ഷന്തേ; ");
INSERT INTO sanmal_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","വിധവാനാം സർവ്വസ്വം ഗ്രസിത്വാ ഛലാദ് ദീർഘകാലം പ്രാർഥയന്തേ തേഭ്യ ഉപാധ്യായേഭ്യഃ സാവധാനാ ഭവത; തേഽധികതരാൻ ദണ്ഡാൻ പ്രാപ്സ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","തദനന്തരം ലോകാ ഭാണ്ഡാഗാരേ മുദ്രാ യഥാ നിക്ഷിപന്തി ഭാണ്ഡാഗാരസ്യ സമ്മുഖേ സമുപവിശ്യ യീശുസ്തദവലുലോക; തദാനീം ബഹവോ ധനിനസ്തസ്യ മധ്യേ ബഹൂനി ധനാനി നിരക്ഷിപൻ| ");
INSERT INTO sanmal_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","പശ്ചാദ് ഏകാ ദരിദ്രാ വിധവാ സമാഗത്യ ദ്വിപണമൂല്യാം മുദ്രൈകാം തത്ര നിരക്ഷിപത്| ");
INSERT INTO sanmal_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","തദാ യീശുഃ ശിഷ്യാൻ ആഹൂയ കഥിതവാൻ യുഷ്മാനഹം യഥാർഥം വദാമി യേ യേ ഭാണ്ഡാഗാരേഽസ്മിന ധനാനി നിഃക്ഷിപന്തി സ്മ തേഭ്യഃ സർവ്വേഭ്യ ഇയം വിധവാ ദരിദ്രാധികമ് നിഃക്ഷിപതി സ്മ| ");
INSERT INTO sanmal_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","യതസ്തേ പ്രഭൂതധനസ്യ കിഞ്ചിത് നിരക്ഷിപൻ കിന്തു ദീനേയം സ്വദിനയാപനയോഗ്യം കിഞ്ചിദപി ന സ്ഥാപയിത്വാ സർവ്വസ്വം നിരക്ഷിപത്| ");
INSERT INTO sanmal_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","അനന്തരം മന്ദിരാദ് ബഹിർഗമനകാലേ തസ്യ ശിഷ്യാണാമേകസ്തം വ്യാഹൃതവാൻ ഹേ ഗുരോ പശ്യതു കീദൃശാഃ പാഷാണാഃ കീദൃക് ച നിചയനം| ");
INSERT INTO sanmal_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","തദാ യീശുസ്തമ് അവദത് ത്വം കിമേതദ് ബൃഹന്നിചയനം പശ്യസി? അസ്യൈകപാഷാണോപി ദ്വിതീയപാഷാണോപരി ന സ്ഥാസ്യതി സർവ്വേ ഽധഃക്ഷേപ്സ്യന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","അഥ യസ്മിൻ കാലേ ജൈതുൻഗിരൗ മന്ദിരസ്യ സമ്മുഖേ സ സമുപവിഷ്ടസ്തസ്മിൻ കാലേ പിതരോ യാകൂബ് യോഹൻ ആന്ദ്രിയശ്ചൈതേ തം രഹസി പപ്രച്ഛുഃ, ");
INSERT INTO sanmal_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","ഏതാ ഘടനാഃ കദാ ഭവിഷ്യന്തി? തഥൈതത്സർവ്വാസാം സിദ്ധ്യുപക്രമസ്യ വാ കിം ചിഹ്നം? തദസ്മഭ്യം കഥയതു ഭവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","തതോ യാശുസ്താൻ വക്തുമാരേഭേ, കോപി യഥാ യുഷ്മാൻ ന ഭ്രാമയതി തഥാത്ര യൂയം സാവധാനാ ഭവത| ");
INSERT INTO sanmal_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","യതഃ ഖ്രീഷ്ടോഹമിതി കഥയിത്വാ മമ നാമ്നാനേകേ സമാഗത്യ ലോകാനാം ഭ്രമം ജനയിഷ്യന്തി; ");
INSERT INTO sanmal_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","കിന്തു യൂയം രണസ്യ വാർത്താം രണാഡമ്ബരഞ്ച ശ്രുത്വാ മാ വ്യാകുലാ ഭവത, ഘടനാ ഏതാ അവശ്യമ്മാവിന്യഃ; കിന്ത്വാപാതതോ ന യുഗാന്തോ ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","ദേശസ്യ വിപക്ഷതയാ ദേശോ രാജ്യസ്യ വിപക്ഷതയാ ച രാജ്യമുത്ഥാസ്യതി, തഥാ സ്ഥാനേ സ്ഥാനേ ഭൂമികമ്പോ ദുർഭിക്ഷം മഹാക്ലേശാശ്ച സമുപസ്ഥാസ്യന്തി, സർവ്വ ഏതേ ദുഃഖസ്യാരമ്ഭാഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","കിന്തു യൂയമ് ആത്മാർഥേ സാവധാനാസ്തിഷ്ഠത, യതോ ലോകാ രാജസഭായാം യുഷ്മാൻ സമർപയിഷ്യന്തി, തഥാ ഭജനഗൃഹേ പ്രഹരിഷ്യന്തി; യൂയം മദർഥേ ദേശാധിപാൻ ഭൂപാംശ്ച പ്രതി സാക്ഷ്യദാനായ തേഷാം സമ്മുഖേ ഉപസ്ഥാപയിഷ്യധ്വേ| ");
INSERT INTO sanmal_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ശേഷീഭവനാത് പൂർവ്വം സർവ്വാൻ ദേശീയാൻ പ്രതി സുസംവാദഃ പ്രചാരയിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","കിന്തു യദാ തേ യുഷ്മാൻ ധൃത്വാ സമർപയിഷ്യന്തി തദാ യൂയം യദ്യദ് ഉത്തരം ദാസ്യഥ, തദഗ്ര തസ്യ വിവേചനം മാ കുരുത തദർഥം കിഞ്ചിദപി മാ ചിന്തയത ച, തദാനീം യുഷ്മാകം മനഃസു യദ്യദ് വാക്യമ് ഉപസ്ഥാപയിഷ്യതേ തദേവ വദിഷ്യഥ, യതോ യൂയം ന തദ്വക്താരഃ കിന്തു പവിത്ര ആത്മാ തസ്യ വക്താ| ");
INSERT INTO sanmal_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","തദാ ഭ്രാതാ ഭ്രാതരം പിതാ പുത്രം ഘാതനാർഥം പരഹസ്തേഷു സമർപയിഷ്യതേ, തഥാ പത്യാനി മാതാപിത്രോ ർവിപക്ഷതയാ തൗ ഘാതയിഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","മമ നാമഹേതോഃ സർവ്വേഷാം സവിധേ യൂയം ജുഗുപ്സിതാ ഭവിഷ്യഥ, കിന്തു യഃ കശ്ചിത് ശേഷപര്യ്യന്തം ധൈര്യ്യമ് ആലമ്ബിഷ്യതേ സഏവ പരിത്രാസ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","ദാനിയേൽഭവിഷ്യദ്വാദിനാ പ്രോക്തം സർവ്വനാശി ജുഗുപ്സിതഞ്ച വസ്തു യദാ ത്വയോഗ്യസ്ഥാനേ വിദ്യമാനം ദ്രക്ഷഥ (യോ ജനഃ പഠതി സ ബുധ്യതാം) തദാ യേ യിഹൂദീയദേശേ തിഷ്ഠന്തി തേ മഹീധ്രം പ്രതി പലായന്താം; ");
INSERT INTO sanmal_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","തഥാ യോ നരോ ഗൃഹോപരി തിഷ്ഠതി സ ഗൃഹമധ്യം നാവരോഹതു, തഥാ കിമപി വസ്തു ഗ്രഹീതും മധ്യേഗൃഹം ന പ്രവിശതു; ");
INSERT INTO sanmal_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","തഥാ ച യോ നരഃ ക്ഷേത്രേ തിഷ്ഠതി സോപി സ്വവസ്ത്രം ഗ്രഹീതും പരാവൃത്യ ന വ്രജതു| ");
INSERT INTO sanmal_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","തദാനീം ഗർബ്ഭവതീനാം സ്തന്യദാത്രീണാഞ്ച യോഷിതാം ദുർഗതി ർഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","യുഷ്മാകം പലായനം ശീതകാലേ യഥാ ന ഭവതി തദർഥം പ്രാർഥയധ്വം| ");
INSERT INTO sanmal_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","യതസ്തദാ യാദൃശീ ദുർഘടനാ ഘടിഷ്യതേ താദൃശീ ദുർഘടനാ ഈശ്വരസൃഷ്ടേഃ പ്രഥമമാരഭ്യാദ്യ യാവത് കദാപി ന ജാതാ ന ജനിഷ്യതേ ച| ");
INSERT INTO sanmal_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","അപരഞ്ച പരമേശ്വരോ യദി തസ്യ സമയസ്യ സംക്ഷേപം ന കരോതി തർഹി കസ്യാപി പ്രാണഭൃതോ രക്ഷാ ഭവിതും ന ശക്ഷ്യതി, കിന്തു യാൻ ജനാൻ മനോനീതാൻ അകരോത് തേഷാം സ്വമനോനീതാനാം ഹേതോഃ സ തദനേഹസം സംക്ഷേപ്സ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","അന്യച്ച പശ്യത ഖ്രീഷ്ടോത്ര സ്ഥാനേ വാ തത്ര സ്ഥാനേ വിദ്യതേ, തസ്മിൻകാലേ യദി കശ്ചിദ് യുഷ്മാൻ ഏതാദൃശം വാക്യം വ്യാഹരതി, തർഹി തസ്മിൻ വാക്യേ ഭൈവ വിശ്വസിത| ");
INSERT INTO sanmal_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","യതോനേകേ മിഥ്യാഖ്രീഷ്ടാ മിഥ്യാഭവിഷ്യദ്വാദിനശ്ച സമുപസ്ഥായ ബഹൂനി ചിഹ്നാന്യദ്ഭുതാനി കർമ്മാണി ച ദർശയിഷ്യന്തി; തഥാ യദി സമ്ഭവതി തർഹി മനോനീതലോകാനാമപി മിഥ്യാമതിം ജനയിഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","പശ്യത ഘടനാതഃ പൂർവ്വം സർവ്വകാര്യ്യസ്യ വാർത്താം യുഷ്മഭ്യമദാമ്, യൂയം സാവധാനാസ്തിഷ്ഠത| ");
INSERT INTO sanmal_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","അപരഞ്ച തസ്യ ക്ലേശകാലസ്യാവ്യവഹിതേ പരകാലേ ഭാസ്കരഃ സാന്ധകാരോ ഭവിഷ്യതി തഥൈവ ചന്ദ്രശ്ചന്ദ്രികാം ന ദാസ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","നഭഃസ്ഥാനി നക്ഷത്രാണി പതിഷ്യന്തി, വ്യോമമണ്ഡലസ്ഥാ ഗ്രഹാശ്ച വിചലിഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","തദാനീം മഹാപരാക്രമേണ മഹൈശ്വര്യ്യേണ ച മേഘമാരുഹ്യ സമായാന്തം മാനവസുതം മാനവാഃ സമീക്ഷിഷ്യന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","അന്യച്ച സ നിജദൂതാൻ പ്രഹിത്യ നഭോഭൂമ്യോഃ സീമാം യാവദ് ജഗതശ്ചതുർദിഗ്ഭ്യഃ സ്വമനോനീതലോകാൻ സംഗ്രഹീഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","ഉഡുമ്ബരതരോ ർദൃഷ്ടാന്തം ശിക്ഷധ്വം യദോഡുമ്ബരസ്യ തരോ ർനവീനാഃ ശാഖാ ജായന്തേ പല്ലവാദീനി ച ർനിഗച്ഛന്തി, തദാ നിദാഘകാലഃ സവിധോ ഭവതീതി യൂയം ജ്ഞാതും ശക്നുഥ| ");
INSERT INTO sanmal_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","തദ്വദ് ഏതാ ഘടനാ ദൃഷ്ട്വാ സ കാലോ ദ്വാര്യ്യുപസ്ഥിത ഇതി ജാനീത| ");
INSERT INTO sanmal_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","യുഷ്മാനഹം യഥാർഥം വദാമി, ആധുനികലോകാനാം ഗമനാത് പൂർവ്വം താനി സർവ്വാണി ഘടിഷ്യന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ദ്യാവാപൃഥിവ്യോ ർവിചലിതയോഃ സത്യോ ർമദീയാ വാണീ ന വിചലിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","അപരഞ്ച സ്വർഗസ്ഥദൂതഗണോ വാ പുത്രോ വാ താതാദന്യഃ കോപി തം ദിവസം തം ദണ്ഡം വാ ന ജ്ഞാപയതി| ");
INSERT INTO sanmal_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","അതഃ സ സമയഃ കദാ ഭവിഷ്യതി, ഏതജ്ജ്ഞാനാഭാവാദ് യൂയം സാവധാനാസ്തിഷ്ഠത, സതർകാശ്ച ഭൂത്വാ പ്രാർഥയധ്വം; ");
INSERT INTO sanmal_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","യദ്വത് കശ്ചിത് പുമാൻ സ്വനിവേശനാദ് ദൂരദേശം പ്രതി യാത്രാകരണകാലേ ദാസേഷു സ്വകാര്യ്യസ്യ ഭാരമർപയിത്വാ സർവ്വാൻ സ്വേ സ്വേ കർമ്മണി നിയോജയതി; അപരം ദൗവാരികം ജാഗരിതും സമാദിശ്യ യാതി, തദ്വൻ നരപുത്രഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","ഗൃഹപതിഃ സായംകാലേ നിശീഥേ വാ തൃതീയയാമേ വാ പ്രാതഃകാലേ വാ കദാഗമിഷ്യതി തദ് യൂയം ന ജാനീഥ; ");
INSERT INTO sanmal_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","സ ഹഠാദാഗത്യ യഥാ യുഷ്മാൻ നിദ്രിതാൻ ന പശ്യതി, തദർഥം ജാഗരിതാസ്തിഷ്ഠത| ");
INSERT INTO sanmal_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","യുഷ്മാനഹം യദ് വദാമി തദേവ സർവ്വാൻ വദാമി, ജാഗരിതാസ്തിഷ്ഠതേതി| ");
INSERT INTO sanmal_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","തദാ നിസ്താരോത്സവകിണ്വഹീനപൂപോത്സവയോരാരമ്ഭസ്യ ദിനദ്വയേ ഽവശിഷ്ടേ പ്രധാനയാജകാ അധ്യാപകാശ്ച കേനാപി ഛലേന യീശും ധർത്താം ഹന്തുഞ്ച മൃഗയാഞ്ചക്രിരേ; ");
INSERT INTO sanmal_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","കിന്തു ലോകാനാം കലഹഭയാദൂചിരേ, നചോത്സവകാല ഉചിതമേതദിതി| ");
INSERT INTO sanmal_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","അനന്തരം ബൈഥനിയാപുुരേ ശിമോനകുഷ്ഠിനോ ഗൃഹേ യോശൗ ഭോത്കുമുപവിഷ്ടേ സതി കാചിദ് യോഷിത് പാണ്ഡരപാഷാണസ്യ സമ്പുടകേന മഹാർഘ്യോത്തമതൈലമ് ആനീയ സമ്പുടകം ഭംക്ത്വാ തസ്യോത്തമാങ്ഗേ തൈലധാരാം പാതയാഞ്ചക്രേ| ");
INSERT INTO sanmal_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","തസ്മാത് കേചിത് സ്വാന്തേ കുപ്യന്തഃ കഥിതവംന്തഃ കുതോയം തൈലാപവ്യയഃ? ");
INSERT INTO sanmal_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","യദ്യേതത് തൈല വ്യക്രേഷ്യത തർഹി മുദ്രാപാദശതത്രയാദപ്യധികം തസ്യ പ്രാപ്തമൂല്യം ദരിദ്രലോകേഭ്യോ ദാതുമശക്ഷ്യത, കഥാമേതാം കഥയിത്വാ തയാ യോഷിതാ സാകം വാചായുഹ്യൻ| ");
INSERT INTO sanmal_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","കിന്തു യീശുരുവാച, കുത ഏതസ്യൈ കൃച്ഛ്രം ദദാസി? മഹ്യമിയം കർമ്മോത്തമം കൃതവതീ| ");
INSERT INTO sanmal_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ദരിദ്രാഃ സർവ്വദാ യുഷ്മാഭിഃ സഹ തിഷ്ഠന്തി, തസ്മാദ് യൂയം യദേച്ഛഥ തദൈവ താനുപകർത്താം ശക്നുഥ, കിന്ത്വഹം യുഭാഭിഃ സഹ നിരന്തരം ന തിഷ്ഠാമി| ");
INSERT INTO sanmal_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","അസ്യാ യഥാസാധ്യം തഥൈവാകരോദിയം, ശ്മശാനയാപനാത് പൂർവ്വം സമേത്യ മദ്വപുഷി തൈലമ് അമർദ്ദയത്| ");
INSERT INTO sanmal_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","അഹം യുഷ്മഭ്യം യഥാർഥം കഥയാമി, ജഗതാം മധ്യേ യത്ര യത്ര സുസംവാദോയം പ്രചാരയിഷ്യതേ തത്ര തത്ര യോഷിത ഏതസ്യാഃ സ്മരണാർഥം തത്കൃതകർമ്മൈതത് പ്രചാരയിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","തതഃ പരം ദ്വാദശാനാം ശിഷ്യാണാമേക ഈഷ്കരിയോതീയയിഹൂദാഖ്യോ യീശും പരകരേഷു സമർപയിതും പ്രധാനയാജകാനാം സമീപമിയായ| ");
INSERT INTO sanmal_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","തേ തസ്യ വാക്യം സമാകർണ്യ സന്തുഷ്ടാഃ സന്തസ്തസ്മൈ മുദ്രാ ദാതും പ്രത്യജാനത; തസ്മാത് സ തം തേഷാം കരേഷു സമർപണായോപായം മൃഗയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","അനന്തരം കിണ്വശൂന്യപൂപോത്സവസ്യ പ്രഥമേഽഹനി നിസ്താരോത്മവാർഥം മേഷമാരണാസമയേ ശിഷ്യാസ്തം പപ്രച്ഛഃ കുത്ര ഗത്വാ വയം നിസ്താരോത്സവസ്യ ഭോജ്യമാസാദയിഷ്യാമഃ? കിമിച്ഛതി ഭവാൻ? ");
INSERT INTO sanmal_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","തദാനീം സ തേഷാം ദ്വയം പ്രേരയൻ ബഭാഷേ യുവയോഃ പുരമധ്യം ഗതയോഃ സതോ ര്യോ ജനഃ സജലകുമ്ഭം വഹൻ യുവാം സാക്ഷാത് കരിഷ്യതി തസ്യൈവ പശ്ചാദ് യാതം; ");
INSERT INTO sanmal_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","സ യത് സദനം പ്രവേക്ഷ്യതി തദ്ഭവനപതിം വദതം, ഗുരുരാഹ യത്ര സശിഷ്യോഹം നിസ്താരോത്സവീയം ഭോജനം കരിഷ്യാമി, സാ ഭോജനശാലാ കുത്രാസ്തി? ");
INSERT INTO sanmal_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","തതഃ സ പരിഷ്കൃതാം സുസജ്ജിതാം ബൃഹതീചഞ്ച യാം ശാലാം ദർശയിഷ്യതി തസ്യാമസ്മദർഥം ഭോജ്യദ്രവ്യാണ്യാസാദയതം| ");
INSERT INTO sanmal_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","തതഃ ശിഷ്യൗ പ്രസ്ഥായ പുരം പ്രവിശ്യ സ യഥോക്തവാൻ തഥൈവ പ്രാപ്യ നിസ്താരോത്സവസ്യ ഭോജ്യദ്രവ്യാണി സമാസാദയേതാമ്| ");
INSERT INTO sanmal_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","അനന്തരം യീശുഃ സായംകാലേ ദ്വാദശഭിഃ ശിഷ്യൈഃ സാർദ്ധം ജഗാമ; ");
INSERT INTO sanmal_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","സർവ്വേഷു ഭോജനായ പ്രോപവിഷ്ടേഷു സ താനുദിതവാൻ യുഷ്മാനഹം യഥാർഥം വ്യാഹരാമി, അത്ര യുഷ്മാകമേകോ ജനോ യോ മയാ സഹ ഭുംക്തേ മാം പരകേരേഷു സമർപയിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","തദാനീം തേ ദുഃഖിതാഃ സന്ത ഏകൈകശസ്തം പ്രഷ്ടുമാരബ്ധവന്തഃ സ കിമഹം? പശ്ചാദ് അന്യ ഏകോഭിദധേ സ കിമഹം? ");
INSERT INTO sanmal_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","തതഃ സ പ്രത്യവദദ് ഏതേഷാം ദ്വാദശാനാം യോ ജനോ മയാ സമം ഭോജനാപാത്രേ പാണിം മജ്ജയിഷ്യതി സ ഏവ| ");
INSERT INTO sanmal_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","മനുജതനയമധി യാദൃശം ലിഖിതമാസ്തേ തദനുരൂപാ ഗതിസ്തസ്യ ഭവിഷ്യതി, കിന്തു യോ ജനോ മാനവസുതം സമർപയിഷ്യതേ ഹന്ത തസ്യ ജന്മാഭാവേ സതി ഭദ്രമഭവിഷ്യത്| ");
INSERT INTO sanmal_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","അപരഞ്ച തേഷാം ഭോജനസമയേ യീശുഃ പൂപം ഗൃഹീത്വേശ്വരഗുണാൻ അനുകീർത്യ ഭങ്ക്ത്വാ തേഭ്യോ ദത്ത്വാ ബഭാഷേ, ഏതദ് ഗൃഹീത്വാ ഭുഞ്ജീധ്വമ് ഏതന്മമ വിഗ്രഹരൂപം| ");
INSERT INTO sanmal_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","അനന്തരം സ കംസം ഗൃഹീത്വേശ്വരസ്യ ഗുണാൻ കീർത്തയിത്വാ തേഭ്യോ ദദൗ, തതസ്തേ സർവ്വേ പപുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","അപരം സ താനവാദീദ് ബഹൂനാം നിമിത്തം പാതിതം മമ നവീനനിയമരൂപം ശോണിതമേതത്| ");
INSERT INTO sanmal_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","യുഷ്മാനഹം യഥാർഥം വദാമി, ഈശ്വരസ്യ രാജ്യേ യാവത് സദ്യോജാതം ദ്രാക്ഷാരസം ന പാസ്യാമി,താവദഹം ദ്രാക്ഷാഫലരസം പുന ർന പാസ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","തദനന്തരം തേ ഗീതമേകം സംഗീയ ബഹി ർജൈതുനം ശിഖരിണം യയുഃ ");
INSERT INTO sanmal_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","അഥ യീശുസ്താനുവാച നിശായാമസ്യാം മയി യുഷ്മാകം സർവ്വേഷാം പ്രത്യൂഹോ ഭവിഷ്യതി യതോ ലിഖിതമാസ്തേ യഥാ, മേഷാണാം രക്ഷകഞ്ചാഹം പ്രഹരിഷ്യാമി വൈ തതഃ| മേഷാണാം നിവഹോ നൂനം പ്രവികീർണോ ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","കന്തു മദുത്ഥാനേ ജാതേ യുഷ്മാകമഗ്രേഽഹം ഗാലീലം വ്രജിഷ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","തദാ പിതരഃ പ്രതിബഭാഷേ, യദ്യപി സർവ്വേഷാം പ്രത്യൂഹോ ഭവതി തഥാപി മമ നൈവ ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","തതോ യീശുരുക്താവാൻ അഹം തുഭ്യം തഥ്യം കഥയാമി, ക്ഷണാദായാമദ്യ കുക്കുടസ്യ ദ്വിതീയവാരരവണാത് പൂർവ്വം ത്വം വാരത്രയം മാമപഹ്നോഷ്യസേ| ");
INSERT INTO sanmal_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","കിന്തു സ ഗാഢം വ്യാഹരദ് യദ്യപി ത്വയാ സാർദ്ധം മമ പ്രാണോ യാതി തഥാപി കഥമപി ത്വാം നാപഹ്നോഷ്യേ; സർവ്വേഽപീതരേ തഥൈവ ബഭാഷിരേ| ");
INSERT INTO sanmal_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","അപരഞ്ച തേഷു ഗേത്ശിമാനീനാമകം സ്ഥാന ഗതേഷു സ ശിഷ്യാൻ ജഗാദ, യാവദഹം പ്രാർഥയേ താവദത്ര സ്ഥാനേ യൂയം സമുപവിശത| ");
INSERT INTO sanmal_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","അഥ സ പിതരം യാകൂബം യോഹനഞ്ച ഗൃഹീത്വാ വവ്രാജ; അത്യന്തം ത്രാസിതോ വ്യാകുലിതശ്ച തേഭ്യഃ കഥയാമാസ, ");
INSERT INTO sanmal_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","നിധനകാലവത് പ്രാണോ മേഽതീവ ദഃഖമേതി, യൂയം ജാഗ്രതോത്ര സ്ഥാനേ തിഷ്ഠത| ");
INSERT INTO sanmal_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","തതഃ സ കിഞ്ചിദ്ദൂരം ഗത്വാ ഭൂമാവധോമുഖഃ പതിത്വാ പ്രാർഥിതവാനേതത്, യദി ഭവിതും ശക്യം തർഹി ദുഃഖസമയോയം മത്തോ ദൂരീഭവതു| ");
INSERT INTO sanmal_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","അപരമുദിതവാൻ ഹേ പിത ർഹേ പിതഃ സർവ്വേം ത്വയാ സാധ്യം, തതോ ഹേതോരിമം കംസം മത്തോ ദൂരീകുരു, കിന്തു തൻ മമേച്ഛാതോ ന തവേച്ഛാതോ ഭവതു| ");
INSERT INTO sanmal_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","തതഃ പരം സ ഏത്യ താൻ നിദ്രിതാൻ നിരീക്ഷ്യ പിതരം പ്രോവാച, ശിമോൻ ത്വം കിം നിദ്രാസി? ഘടികാമേകാമ് അപി ജാഗരിതും ന ശക്നോഷി? ");
INSERT INTO sanmal_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","പരീക്ഷായാം യഥാ ന പതഥ തദർഥം സചേതനാഃ സന്തഃ പ്രാർഥയധ്വം; മന ഉദ്യുക്തമിതി സത്യം കിന്തു വപുരശക്തികം| ");
INSERT INTO sanmal_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","അഥ സ പുനർവ്രജിത്വാ പൂർവ്വവത് പ്രാർഥയാഞ്ചക്രേ| ");
INSERT INTO sanmal_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","പരാവൃത്യാഗത്യ പുനരപി താൻ നിദ്രിതാൻ ദദർശ തദാ തേഷാം ലോചനാനി നിദ്രയാ പൂർണാനി, തസ്മാത്തസ്മൈ കാ കഥാ കഥയിതവ്യാ ത ഏതദ് ബോദ്ധും ന ശേകുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","തതഃപരം തൃതീയവാരം ആഗത്യ തേഭ്യോ ഽകഥയദ് ഇദാനീമപി ശയിത്വാ വിശ്രാമ്യഥ? യഥേഷ്ടം ജാതം, സമയശ്ചോപസ്ഥിതഃ പശ്യത മാനവതനയഃ പാപിലോകാനാം പാണിഷു സമർപ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ഉത്തിഷ്ഠത, വയം വ്രജാമോ യോ ജനോ മാം പരപാണിഷു സമർപയിഷ്യതേ പശ്യത സ സമീപമായാതഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ഇമാം കഥാം കഥയതി സ, ഏതർഹിദ്വാദശാനാമേകോ യിഹൂദാ നാമാ ശിഷ്യഃ പ്രധാനയാജകാനാമ് ഉപാധ്യായാനാം പ്രാചീനലോകാനാഞ്ച സന്നിധേഃ ഖങ്ഗലഗുഡധാരിണോ ബഹുലോകാൻ ഗൃഹീത്വാ തസ്യ സമീപ ഉപസ്ഥിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","അപരഞ്ചാസൗ പരപാണിഷു സമർപയിതാ പൂർവ്വമിതി സങ്കേതം കൃതവാൻ യമഹം ചുമ്ബിഷ്യാമി സ ഏവാസൗ തമേവ ധൃത്വാ സാവധാനം നയത| ");
INSERT INTO sanmal_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","അതോ ഹേതോഃ സ ആഗത്യൈവ യോശോഃ സവിധം ഗത്വാ ഹേ ഗുരോ ഹേ ഗുരോ, ഇത്യുക്ത്വാ തം ചുചുമ്ബ| ");
INSERT INTO sanmal_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","തദാ തേ തദുപരി പാണീനർപയിത്വാ തം ദധ്നുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","തതസ്തസ്യ പാർശ്വസ്ഥാനാം ലോകാനാമേകഃ ഖങ്ഗം നിഷ്കോഷയൻ മഹായാജകസ്യ ദാസമേകം പ്രഹൃത്യ തസ്യ കർണം ചിച്ഛേദ| ");
INSERT INTO sanmal_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","പശ്ചാദ് യീശുസ്താൻ വ്യാജഹാര ഖങ്ഗാൻ ലഗുഡാംശ്ച ഗൃഹീത്വാ മാം കിം ചൗരം ധർത്താം സമായാതാഃ? ");
INSERT INTO sanmal_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","മധ്യേമന്ദിരം സമുപദിശൻ പ്രത്യഹം യുഷ്മാഭിഃ സഹ സ്ഥിതവാനതഹം, തസ്മിൻ കാലേ യൂയം മാം നാദീധരത, കിന്ത്വനേന ശാസ്ത്രീയം വചനം സേധനീയം| ");
INSERT INTO sanmal_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","തദാ സർവ്വേ ശിഷ്യാസ്തം പരിത്യജ്യ പലായാഞ്ചക്രിരേ| ");
INSERT INTO sanmal_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","അഥൈകോ യുവാ മാനവോ നഗ്നകായേ വസ്ത്രമേകം നിധായ തസ്യ പശ്ചാദ് വ്രജൻ യുവലോകൈ ർധൃതോ ");
INSERT INTO sanmal_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","വസ്ത്രം വിഹായ നഗ്നഃ പലായാഞ്ചക്രേ| ");
INSERT INTO sanmal_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","അപരഞ്ച യസ്മിൻ സ്ഥാനേ പ്രധാനയാജകാ ഉപാധ്യായാഃ പ്രാചീനലോകാശ്ച മഹായാജകേന സഹ സദസി സ്ഥിതാസ്തസ്മിൻ സ്ഥാനേ മഹായാജകസ്യ സമീപം യീശും നിന്യുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","പിതരോ ദൂരേ തത്പശ്ചാദ് ഇത്വാ മഹായാജകസ്യാട്ടാലികാം പ്രവിശ്യ കിങ്കരൈഃ സഹോപവിശ്യ വഹ്നിതാപം ജഗ്രാഹ| ");
INSERT INTO sanmal_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","തദാനീം പ്രധാനയാജകാ മന്ത്രിണശ്ച യീശും ഘാതയിതും തത്പ്രാതികൂല്യേന സാക്ഷിണോ മൃഗയാഞ്ചക്രിരേ, കിന്തു ന പ്രാപ്താഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","അനേകൈസ്തദ്വിരുദ്ധം മൃഷാസാക്ഷ്യേ ദത്തേപി തേഷാം വാക്യാനി ന സമഗച്ഛന്ത| ");
INSERT INTO sanmal_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","സർവ്വശേഷേ കിയന്ത ഉത്ഥായ തസ്യ പ്രാതികൂല്യേന മൃഷാസാക്ഷ്യം ദത്ത്വാ കഥയാമാസുഃ, ");
INSERT INTO sanmal_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","ഇദം കരകൃതമന്ദിരം വിനാശ്യ ദിനത്രയമധ്യേ പുനരപരമ് അകരകൃതം മന്ദിരം നിർമ്മാസ്യാമി, ഇതി വാക്യമ് അസ്യ മുഖാത് ശ്രുതമസ്മാഭിരിതി| ");
INSERT INTO sanmal_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","കിന്തു തത്രാപി തേഷാം സാക്ഷ്യകഥാ ന സങ്ഗാതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","അഥ മഹായാജകോ മധ്യേസഭമ് ഉത്ഥായ യീശും വ്യാജഹാര, ഏതേ ജനാസ്ത്വയി യത് സാക്ഷ്യമദുഃ ത്വമേതസ്യ കിമപ്യുത്തരം കിം ന ദാസ്യസി? ");
INSERT INTO sanmal_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","കിന്തു സ കിമപ്യുത്തരം ന ദത്വാ മൗനീഭൂയ തസ്യൗ; തതോ മഹായാജകഃ പുനരപി തം പൃഷ്ടാവാൻ ത്വം സച്ചിദാനന്ദസ്യ തനയോ ഽഭിഷിക്തസ്ത്രതാ? ");
INSERT INTO sanmal_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","തദാ യീശുസ്തം പ്രോവാച ഭവാമ്യഹമ് യൂയഞ്ച സർവ്വശക്തിമതോ ദക്ഷീണപാർശ്വേ സമുപവിശന്തം മേഘ മാരുഹ്യ സമായാന്തഞ്ച മനുഷ്യപുത്രം സന്ദ്രക്ഷ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","തദാ മഹായാജകഃ സ്വം വമനം ഛിത്വാ വ്യാവഹരത് ");
INSERT INTO sanmal_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","കിമസ്മാകം സാക്ഷിഭിഃ പ്രയോജനമ്? ഈശ്വരനിന്ദാവാക്യം യുഷ്മാഭിരശ്രാവി കിം വിചാരയഥ? തദാനീം സർവ്വേ ജഗദുരയം നിധനദണ്ഡമർഹതി| ");
INSERT INTO sanmal_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","തതഃ കശ്ചിത് കശ്ചിത് തദ്വപുഷി നിഷ്ഠീവം നിചിക്ഷേപ തഥാ തന്മുഖമാച്ഛാദ്യ ചപേടേന ഹത്വാ ഗദിതവാൻ ഗണയിത്വാ വദ, അനുചരാശ്ച ചപേടൈസ്തമാജഘ്നുഃ ");
INSERT INTO sanmal_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","തതഃ പരം പിതരേഽട്ടാലികാധഃകോഷ്ഠേ തിഷ്ഠതി മഹായാജകസ്യൈകാ ദാസീ സമേത്യ ");
INSERT INTO sanmal_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","തം വിഹ്നിതാപം ഗൃഹ്ലന്തം വിലോക്യ തം സുനിരീക്ഷ്യ ബഭാഷേ ത്വമപി നാസരതീയയീശോഃ സങ്ഗിനാമ് ഏകോ ജന ആസീഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","കിന്തു സോപഹ്നുത്യ ജഗാദ തമഹം ന വദ്മി ത്വം യത് കഥയമി തദപ്യഹം ന ബുദ്ധ്യേ| തദാനീം പിതരേ ചത്വരം ഗതവതി കുेക്കുടോ രുരാവ| ");
INSERT INTO sanmal_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","അഥാന്യാ ദാസീ പിതരം ദൃഷ്ട്വാ സമീപസ്ഥാൻ ജനാൻ ജഗാദ അയം തേഷാമേകോ ജനഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","തതഃ സ ദ്വിതീയവാരമ് അപഹ്നുതവാൻ പശ്ചാത് തത്രസ്ഥാ ലോകാഃ പിതരം പ്രോചുസ്ത്വമവശ്യം തേഷാമേകോ ജനഃ യതസ്ത്വം ഗാലീലീയോ നര ഇതി തവോച്ചാരണം പ്രകാശയതി| ");
INSERT INTO sanmal_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","തദാ സ ശപഥാഭിശാപൗ കൃത്വാ പ്രോവാച യൂയം കഥാം കഥയഥ തം നരം ന ജാനേഽഹം| ");
INSERT INTO sanmal_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","തദാനീം ദ്വിതീയവാരം കുക്കുടോ ഽരാവീത്| കുക്കുടസ്യ ദ്വിതീയരവാത് പൂർവ്വം ത്വം മാം വാരത്രയമ് അപഹ്നോഷ്യസി, ഇതി യദ്വാക്യം യീശുനാ സമുദിതം തത് തദാ സംസ്മൃത്യ പിതരോ രോദിതുമ് ആരഭത| ");
INSERT INTO sanmal_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","അഥ പ്രഭാതേ സതി പ്രധാനയാജകാഃ പ്രാഞ്ച ഉപാധ്യായാഃ സർവ്വേ മന്ത്രിണശ്ച സഭാം കൃത്വാ യീശുृം ബന്ധയിത്വ പീലാതാഖ്യസ്യ ദേശാധിപതേഃ സവിധം നീത്വാ സമർപയാമാസുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","തദാ പീലാതസ്തം പൃഷ്ടവാൻ ത്വം കിം യിഹൂദീയലോകാനാം രാജാ? തതഃ സ പ്രത്യുക്തവാൻ സത്യം വദസി| ");
INSERT INTO sanmal_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","അപരം പ്രധാനയാജകാസ്തസ്യ ബഹുഷു വാക്യേഷു ദോഷമാരോപയാഞ്ചക്രുഃ കിന്തു സ കിമപി ന പ്രത്യുവാച| ");
INSERT INTO sanmal_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","തദാനീം പീലാതസ്തം പുനഃ പപ്രച്ഛ ത്വം കിം നോത്തരയസി? പശ്യൈതേ ത്വദ്വിരുദ്ധം കതിഷു സാധ്യേഷു സാക്ഷം ദദതി| ");
INSERT INTO sanmal_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","കന്തു യീശുസ്തദാപി നോത്തരം ദദൗ തതഃ പീലാത ആശ്ചര്യ്യം ജഗാമ| ");
INSERT INTO sanmal_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","അപരഞ്ച കാരാബദ്ധേ കസ്തിംശ്ചിത് ജനേ തന്മഹോത്സവകാലേ ലോകൈ ര്യാചിതേ ദേശാധിപതിസ്തം മോചയതി| ");
INSERT INTO sanmal_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","യേ ച പൂർവ്വമുപപ്ലവമകാർഷുരുപപ്ലവേ വധമപി കൃതവന്തസ്തേഷാം മധ്യേ തദാനോം ബരബ്ബാനാമക ഏകോ ബദ്ധ ആസീത്| ");
INSERT INTO sanmal_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","അതോ ഹേതോഃ പൂർവ്വാപരീയാം രീതികഥാം കഥയിത്വാ ലോകാ ഉച്ചൈരുവന്തഃ പീലാതസ്യ സമക്ഷം നിവേദയാമാസുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","തദാ പീലാതസ്താനാചഖ്യൗ തർഹി കിം യിഹൂദീയാനാം രാജാനം മോചയിഷ്യാമി? യുഷ്മാഭിഃ കിമിഷ്യതേ? ");
INSERT INTO sanmal_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","യതഃ പ്രധാനയാജകാ ഈർഷ്യാത ഏവ യീശും സമാർപയന്നിതി സ വിവേദ| ");
INSERT INTO sanmal_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","കിന്തു യഥാ ബരബ്ബാം മോചയതി തഥാ പ്രാർഥയിതും പ്രധാനയാജകാ ലോകാൻ പ്രവർത്തയാമാസുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","അഥ പീലാതഃ പുനഃ പൃഷ്ടവാൻ തർഹി യം യിഹൂദീയാനാം രാജേതി വദഥ തസ്യ കിം കരിഷ്യാമി യുഷ്മാഭിഃ കിമിഷ്യതേ? ");
INSERT INTO sanmal_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","തദാ തേ പുനരപി പ്രോച്ചൈഃ പ്രോചുസ്തം ക്രുശേ വേധയ| ");
INSERT INTO sanmal_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","തസ്മാത് പീലാതഃ കഥിതവാൻ കുതഃ? സ കിം കുകർമ്മ കൃതവാൻ? കിന്തു തേ പുനശ്ച രുവന്തോ വ്യാജഹ്രുസ്തം ക്രുശേ വേധയ| ");
INSERT INTO sanmal_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","തദാ പീലാതഃ സർവ്വാല്ലോകാൻ തോഷയിതുമിച്ഛൻ ബരബ്ബാം മോചയിത്വാ യീശും കശാഭിഃ പ്രഹൃത്യ ക്രുശേ വേദ്ധും തം സമർപയാമ്ബഭൂവ| ");
INSERT INTO sanmal_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","അനന്തരം സൈന്യഗണോഽട്ടാലികാമ് അർഥാദ് അധിപതേ ർഗൃഹം യീശും നീത്വാ സേനാനിവഹം സമാഹുയത്| ");
INSERT INTO sanmal_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","പശ്ചാത് തേ തം ധൂമലവർണവസ്ത്രം പരിധാപ്യ കണ്ടകമുകുടം രചയിത്വാ ശിരസി സമാരോപ്യ ");
INSERT INTO sanmal_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ഹേ യിഹൂദീയാനാം രാജൻ നമസ്കാര ഇത്യുക്ത്വാ തം നമസ്കർത്താമാരേഭിരേ| ");
INSERT INTO sanmal_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","തസ്യോത്തമാങ്ഗേ വേത്രാഘാതം ചക്രുസ്തദ്ഗാത്രേ നിഷ്ഠീവഞ്ച നിചിക്ഷിപുഃ, തഥാ തസ്യ സമ്മുഖേ ജാനുപാതം പ്രണോമുഃ ");
INSERT INTO sanmal_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ഇത്ഥമുപഹസ്യ ധൂമ്രവർണവസ്ത്രമ് ഉത്താര്യ്യ തസ്യ വസ്ത്രം തം പര്യ്യധാപയൻ ക്രുശേ വേദ്ധും ബഹിർനിന്യുശ്ച| ");
INSERT INTO sanmal_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","തതഃ പരം സേകന്ദരസ്യ രുഫസ്യ ച പിതാ ശിമോന്നാമാ കുരീണീയലോക ഏകഃ കുതശ്ചിദ് ഗ്രാമാദേത്യ പഥി യാതി തം തേ യീശോഃ ക്രുശം വോഢും ബലാദ് ദധ്നുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","അഥ ഗുൽഗൽതാ അർഥാത് ശിരഃകപാലനാമകം സ്ഥാനം യീശുമാനീയ ");
INSERT INTO sanmal_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","തേ ഗന്ധരസമിശ്രിതം ദ്രാക്ഷാരസം പാതും തസ്മൈ ദദുഃ കിന്തു സ ന ജഗ്രാഹ| ");
INSERT INTO sanmal_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","തസ്മിൻ ക്രുശേ വിദ്ധേ സതി തേഷാമേകൈകശഃ കിം പ്രാപ്സ്യതീതി നിർണയായ ");
INSERT INTO sanmal_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","തസ്യ പരിധേയാനാം വിഭാഗാർഥം ഗുടികാപാതം ചക്രുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","അപരമ് ഏഷ യിഹൂദീയാനാം രാജേതി ലിഖിതം ദോഷപത്രം തസ്യ ശിരഊർദ്വ്വമ് ആരോപയാഞ്ചക്രുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","തസ്യ വാമദക്ഷിണയോ ർദ്വൗ ചൗരൗ ക്രുശയോ ർവിവിധാതേ| ");
INSERT INTO sanmal_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","തേനൈവ \"അപരാധിജനൈഃ സാർദ്ധം സ ഗണിതോ ഭവിഷ്യതി,\" ഇതി ശാസ്ത്രോക്തം വചനം സിദ്ധമഭൂത| ");
INSERT INTO sanmal_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","അനന്തരം മാർഗേ യേ യേ ലോകാ ഗമനാഗമനേ ചക്രുസ്തേ സർവ്വ ഏവ ശിരാംസ്യാന്ദോല്യ നിന്ദന്തോ ജഗദുഃ, രേ മന്ദിരനാശക രേ ദിനത്രയമധ്യേ തന്നിർമ്മായക, ");
INSERT INTO sanmal_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","അധുനാത്മാനമ് അവിത്വാ ക്രുശാദവരോഹ| ");
INSERT INTO sanmal_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","കിഞ്ച പ്രധാനയാജകാ അധ്യാപകാശ്ച തദ്വത് തിരസ്കൃത്യ പരസ്പരം ചചക്ഷിരേ ഏഷ പരാനാവത് കിന്തു സ്വമവിതും ന ശക്നോതി| ");
INSERT INTO sanmal_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","യദീസ്രായേലോ രാജാഭിഷിക്തസ്ത്രാതാ ഭവതി തർഹ്യധുനൈന ക്രുശാദവരോഹതു വയം തദ് ദൃഷ്ട്വാ വിശ്വസിഷ്യാമഃ; കിഞ്ച യൗ ലോകൗ തേന സാർദ്ധം ക്രുശേ ഽവിധ്യേതാം താവപി തം നിർഭർത്സയാമാസതുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","അഥ ദ്വിതീയയാമാത് തൃതീയയാമം യാവത് സർവ്വോ ദേശഃ സാന്ധകാരോഭൂത്| ");
INSERT INTO sanmal_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","തതസ്തൃതീയപ്രഹരേ യീശുരുച്ചൈരവദത് ഏലീ ഏലീ ലാമാ ശിവക്തനീ അർഥാദ് \"ഹേ മദീശ മദീശ ത്വം പര്യ്യത്യാക്ഷീഃ കുതോ ഹി മാം?\" ");
INSERT INTO sanmal_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","തദാ സമീപസ്ഥലോകാനാം കേചിത് തദ്വാക്യം നിശമ്യാചഖ്യുഃ പശ്യൈഷ ഏലിയമ് ആഹൂയതി| ");
INSERT INTO sanmal_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","തത ഏകോ ജനോ ധാവിത്വാഗത്യ സ്പഞ്ജേ ഽമ്ലരസം പൂരയിത്വാ തം നഡാഗ്രേ നിധായ പാതും തസ്മൈ ദത്ത്വാവദത് തിഷ്ഠ ഏലിയ ഏനമവരോഹയിതുമ് ഏതി ന വേതി പശ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","അഥ യീശുരുച്ചൈഃ സമാഹൂയ പ്രാണാൻ ജഹൗ| ");
INSERT INTO sanmal_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","തദാ മന്ദിരസ്യ ജവനികോർദ്വ്വാദധഃര്യ്യന്താ വിദീർണാ ദ്വിഖണ്ഡാഭൂത്| ");
INSERT INTO sanmal_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","കിഞ്ച ഇത്ഥമുച്ചൈരാഹൂയ പ്രാണാൻ ത്യജന്തം തം ദൃഷ്ദ്വാ തദ്രക്ഷണായ നിയുക്തോ യഃ സേനാപതിരാസീത് സോവദത് നരോയമ് ഈശ്വരപുത്ര ഇതി സത്യമ്| ");
INSERT INTO sanmal_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","തദാനീം മഗ്ദലീനീ മരിസമ് കനിഷ്ഠയാകൂബോ യോസേശ്ച മാതാന്യമരിയമ് ശാലോമീ ച യാഃ സ്ത്രിയോ ");
INSERT INTO sanmal_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","ഗാലീൽപ്രദേശേ യീശും സേവിത്വാ തദനുഗാമിന്യോ ജാതാ ഇമാസ്തദന്യാശ്ച യാ അനേകാ നാര്യോ യീശുനാ സാർദ്ധം യിരൂശാലമമായാതാസ്താശ്ച ദൂരാത് താനി ദദൃശുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","അഥാസാദനദിനസ്യാർഥാദ് വിശ്രാമവാരാത് പൂർവ്വദിനസ്യ സായംകാല ആഗത ");
INSERT INTO sanmal_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ഈശ്വരരാജ്യാപേക്ഷ്യരിമഥീയയൂഷഫനാമാ മാന്യമന്ത്രീ സമേത്യ പീലാതസവിധം നിർഭയോ ഗത്വാ യീശോർദേഹം യയാചേ| ");
INSERT INTO sanmal_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","കിന്തു സ ഇദാനീം മൃതഃ പീലാത ഇത്യസമ്ഭവം മത്വാ ശതസേനാപതിമാഹൂയ സ കദാ മൃത ഇതി പപ്രച്ഛ| ");
INSERT INTO sanmal_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ശതസേമനാപതിമുഖാത് തജ്ജ്ഞാത്വാ യൂഷഫേ യീശോർദേഹം ദദൗ| ");
INSERT INTO sanmal_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","പശ്ചാത് സ സൂക്ഷ്മം വാസഃ ക്രീത്വാ യീശോഃ കായമവരോഹ്യ തേന വാസസാ വേഷ്ടായിത്വാ ഗിരൗ ഖാതശ്മശാനേ സ്ഥാപിതവാൻ പാഷാണം ലോഠയിത്വാ ദ്വാരി നിദധേ| ");
INSERT INTO sanmal_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","കിന്തു യത്ര സോസ്ഥാപ്യത തത മഗ്ദലീനീ മരിയമ് യോസിമാതൃമരിയമ് ച ദദൃശതൃഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","അഥ വിശ്രാമവാരേ ഗതേ മഗ്ദലീനീ മരിയമ് യാകൂബമാതാ മരിയമ് ശാലോമീ ചേമാസ്തം മർദ്ദയിതും സുഗന്ധിദ്രവ്യാണി ക്രീത്വാ ");
INSERT INTO sanmal_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","സപ്താഹപ്രഥമദിനേഽതിപ്രത്യൂഷേ സൂര്യ്യോദയകാലേ ശ്മശാനമുപഗതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","കിന്തു ശ്മശാനദ്വാരപാഷാണോഽതിബൃഹൻ തം കോഽപസാരയിഷ്യതീതി താഃ പരസ്പരം ഗദന്തി! ");
INSERT INTO sanmal_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ഏതർഹി നിരീക്ഷ്യ പാഷാണോ ദ്വാരോ ഽപസാരിത ഇതി ദദൃശുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","പശ്ചാത്താഃ ശ്മശാനം പ്രവിശ്യ ശുക്ലവർണദീർഘപരിച്ഛദാവൃതമേകം യുവാനം ശ്മശാനദക്ഷിണപാർശ്വ ഉപവിഷ്ടം ദൃഷ്ട്വാ ചമച്ചക്രുഃ| ");
INSERT INTO sanmal_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","സോഽവദത്, മാഭൈഷ്ട യൂയം ക്രുശേ ഹതം നാസരതീയയീശും ഗവേഷയഥ സോത്ര നാസ്തി ശ്മശാനാദുദസ്ഥാത്; തൈ ര്യത്ര സ സ്ഥാപിതഃ സ്ഥാനം തദിദം പശ്യത| ");
INSERT INTO sanmal_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","കിന്തു തേന യഥോക്തം തഥാ യുഷ്മാകമഗ്രേ ഗാലീലം യാസ്യതേ തത്ര സ യുഷ്മാൻ സാക്ഷാത് കരിഷ്യതേ യൂയം ഗത്വാ തസ്യ ശിഷ്യേഭ്യഃ പിതരായ ച വാർത്താമിമാം കഥയത| ");
INSERT INTO sanmal_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","താഃ കമ്പിതാ വിസ്തിതാശ്ച തൂർണം ശ്മശാനാദ് ബഹിർഗത്വാ പലായന്ത ഭയാത് കമപി കിമപി നാവദംശ്ച| ");
INSERT INTO sanmal_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","അപരം യീശുഃ സപ്താഹപ്രഥമദിനേ പ്രത്യൂഷേ ശ്മശാനാദുത്ഥായ യസ്യാഃ സപ്തഭൂതാസ്ത്യാജിതാസ്തസ്യൈ മഗ്ദലീനീമരിയമേ പ്രഥമം ദർശനം ദദൗ| ");
INSERT INTO sanmal_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","തതഃ സാ ഗത്വാ ശോകരോദനകൃദ്ഭ്യോഽനുഗതലോകേഭ്യസ്താം വാർത്താം കഥയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","കിന്തു യീശുഃ പുനർജീവൻ തസ്യൈ ദർശനം ദത്തവാനിതി ശ്രുത്വാ തേ ന പ്രത്യയൻ| ");
INSERT INTO sanmal_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","പശ്ചാത് തേഷാം ദ്വായോ ർഗ്രാമയാനകാലേ യീശുരന്യവേശം ധൃത്വാ താഭ്യാം ദർശന ദദൗ! ");
INSERT INTO sanmal_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","താവപി ഗത്വാന്യശിഷ്യേഭ്യസ്താം കഥാം കഥയാഞ്ചക്രതുഃ കിന്തു തയോഃ കഥാമപി തേ ന പ്രത്യയൻ| ");
INSERT INTO sanmal_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ശേഷത ഏകാദശശിഷ്യേഷു ഭോജനോപവിഷ്ടേഷു യീശുസ്തേഭ്യോ ദർശനം ദദൗ തഥോത്ഥാനാത് പരം തദ്ദർശനപ്രാപ്തലോകാനാം കഥായാമവിശ്വാസകരണാത് തേഷാമവിശ്വാസമനഃകാഠിന്യാഭ്യാം ഹേതുഭ്യാം സ താംസ്തർജിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","അഥ താനാചഖ്യൗ യൂയം സർവ്വജഗദ് ഗത്വാ സർവ്വജനാൻ പ്രതി സുസംവാദം പ്രചാരയത| ");
INSERT INTO sanmal_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","തത്ര യഃ കശ്ചിദ് വിശ്വസ്യ മജ്ജിതോ ഭവേത് സ പരിത്രാസ്യതേ കിന്തു യോ ന വിശ്വസിഷ്യതി സ ദണ്ഡയിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","കിഞ്ച യേ പ്രത്യേഷ്യന്തി തൈരീദൃഗ് ആശ്ചര്യ്യം കർമ്മ പ്രകാശയിഷ്യതേ തേ മന്നാമ്നാ ഭൂതാൻ ത്യാജയിഷ്യന്തി ഭാഷാ അന്യാശ്ച വദിഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","അപരം തൈഃ സർപേഷു ധൃതേഷു പ്രാണനാശകവസ്തുനി പീതേ ച തേഷാം കാപി ക്ഷതി ർന ഭവിഷ്യതി; രോഗിണാം ഗാത്രേഷു കരാർപിതേ തേഽരോഗാ ഭവിഷ്യന്തി ച| ");
INSERT INTO sanmal_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","അഥ പ്രഭുസ്താനിത്യാദിശ്യ സ്വർഗം നീതഃ സൻ പരമേശ്വരസ്യ ദക്ഷിണ ഉപവിവേശ| ");
INSERT INTO sanmal_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","തതസ്തേ പ്രസ്ഥായ സർവ്വത്ര സുസംവാദീയകഥാം പ്രചാരയിതുമാരേഭിരേ പ്രഭുസ്തു തേഷാം സഹായഃ സൻ പ്രകാശിതാശ്ചര്യ്യക്രിയാഭിസ്താം കഥാം പ്രമാണവതീം ചകാര| ഇതി|");
INSERT INTO sanmal_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","പ്രഥമതോ യേ സാക്ഷിണോ വാക്യപ്രചാരകാശ്ചാസൻ തേഽസ്മാകം മധ്യേ യദ്യത് സപ്രമാണം വാക്യമർപയന്തി സ്മ ");
INSERT INTO sanmal_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","തദനുസാരതോഽന്യേപി ബഹവസ്തദ്വൃത്താന്തം രചയിതും പ്രവൃത്താഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","അതഏവ ഹേ മഹാമഹിമഥിയഫിൽ ത്വം യാ യാഃ കഥാ അശിക്ഷ്യഥാസ്താസാം ദൃഢപ്രമാണാനി യഥാ പ്രാപ്നോഷി ");
INSERT INTO sanmal_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","തദർഥം പ്രഥമമാരഭ്യ താനി സർവ്വാണി ജ്ഞാത്വാഹമപി അനുക്രമാത് സർവ്വവൃത്താന്താൻ തുഭ്യം ലേഖിതും മതിമകാർഷമ്| ");
INSERT INTO sanmal_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","യിഹൂദാദേശീയഹേരോദ്നാമകേ രാജത്വം കുർവ്വതി അബീയയാജകസ്യ പര്യ്യായാധികാരീ സിഖരിയനാമക ഏകോ യാജകോ ഹാരോണവംശോദ്ഭവാ ഇലീശേവാഖ്യാ ");
INSERT INTO sanmal_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","തസ്യ ജായാ ദ്വാവിമൗ നിർദോഷൗ പ്രഭോഃ സർവ്വാജ്ഞാ വ്യവസ്ഥാശ്ച സംമന്യ ഈശ്വരദൃഷ്ടൗ ധാർമ്മികാവാസ്താമ്| ");
INSERT INTO sanmal_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","തയോഃ സന്താന ഏകോപി നാസീത്, യത ഇലീശേവാ ബന്ധ്യാ തൗ ദ്വാവേവ വൃദ്ധാവഭവതാമ്| ");
INSERT INTO sanmal_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","യദാ സ്വപര്യ്യാനുക്രമേണ സിഖരിയ ഈശ്വാസ്യ സമക്ഷം യാജകീയം കർമ്മ കരോതി ");
INSERT INTO sanmal_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","തദാ യജ്ഞസ്യ ദിനപരിപായ്യാ പരമേശ്വരസ്യ മന്ദിരേ പ്രവേശകാലേ ധൂപജ്വാലനം കർമ്മ തസ്യ കരണീയമാസീത്| ");
INSERT INTO sanmal_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","തദ്ധൂപജ്വാലനകാലേ ലോകനിവഹേ പ്രാർഥനാം കർതും ബഹിസ്തിഷ്ഠതി ");
INSERT INTO sanmal_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","സതി സിഖരിയോ യസ്യാം വേദ്യാം ധൂപം ജ്വാലയതി തദ്ദക്ഷിണപാർശ്വേ പരമേശ്വരസ്യ ദൂത ഏക ഉപസ്ഥിതോ ദർശനം ദദൗ| ");
INSERT INTO sanmal_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","തം ദൃഷ്ട്വാ സിഖരിയ ഉദ്വിവിജേ ശശങ്കേ ച| ");
INSERT INTO sanmal_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","തദാ സ ദൂതസ്തം ബഭാഷേ ഹേ സിഖരിയ മാ ഭൈസ്തവ പ്രാർഥനാ ഗ്രാഹ്യാ ജാതാ തവ ഭാര്യ്യാ ഇലീശേവാ പുത്രം പ്രസോഷ്യതേ തസ്യ നാമ യോेഹൻ ഇതി കരിഷ്യസി| ");
INSERT INTO sanmal_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","കിഞ്ച ത്വം സാനന്ദഃ സഹർഷശ്ച ഭവിഷ്യസി തസ്യ ജന്മനി ബഹവ ആനന്ദിഷ്യന്തി ച| ");
INSERT INTO sanmal_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","യതോ ഹേതോഃ സ പരമേശ്വരസ്യ ഗോചരേ മഹാൻ ഭവിഷ്യതി തഥാ ദ്രാക്ഷാരസം സുരാം വാ കിമപി ന പാസ്യതി, അപരം ജന്മാരഭ്യ പവിത്രേണാത്മനാ പരിപൂർണഃ ");
INSERT INTO sanmal_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","സൻ ഇസ്രായേല്വംശീയാൻ അനേകാൻ പ്രഭോഃ പരമേശ്വരസ്യ മാർഗമാനേഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","സന്താനാൻ പ്രതി പിതൃണാം മനാംസി ധർമ്മജ്ഞാനം പ്രത്യനാജ്ഞാഗ്രാഹിണശ്ച പരാവർത്തയിതും, പ്രഭോഃ പരമേശ്വരസ്യ സേവാർഥമ് ഏകാം സജ്ജിതജാതിം വിധാതുഞ്ച സ ഏലിയരൂപാത്മശക്തിപ്രാപ്തസ്തസ്യാഗ്രേ ഗമിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","തദാ സിഖരിയോ ദൂതമവാദീത് കഥമേതദ് വേത്സ്യാമി? യതോഹം വൃദ്ധോ മമ ഭാര്യ്യാ ച വൃദ്ധാ| ");
INSERT INTO sanmal_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","തതോ ദൂതഃ പ്രത്യുവാച പശ്യേശ്വരസ്യ സാക്ഷാദ്വർത്തീ ജിബ്രായേൽനാമാ ദൂതോഹം ത്വയാ സഹ കഥാം ഗദിതും തുഭ്യമിമാം ശുഭവാർത്താം ദാതുഞ്ച പ്രേഷിതഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","കിന്തു മദീയം വാക്യം കാലേ ഫലിഷ്യതി തത് ത്വയാ ന പ്രതീതമ് അതഃ കാരണാദ് യാവദേവ താനി ന സേത്സ്യന്തി താവത് ത്വം വക്തുംമശക്തോ മൂകോ ഭവ| ");
INSERT INTO sanmal_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","തദാനീം യേ യേ ലോകാഃ സിഖരിയമപൈക്ഷന്ത തേ മധ്യേമന്ദിരം തസ്യ ബഹുവിലമ്ബാദ് ആശ്ചര്യ്യം മേനിരേ| ");
INSERT INTO sanmal_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","സ ബഹിരാഗതോ യദാ കിമപി വാക്യം വക്തുമശക്തഃ സങ്കേതം കൃത്വാ നിഃശബ്ദസ്തസ്യൗ തദാ മധ്യേമന്ദിരം കസ്യചിദ് ദർശനം തേന പ്രാപ്തമ് ഇതി സർവ്വേ ബുബുധിരേ| ");
INSERT INTO sanmal_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","അനന്തരം തസ്യ സേവനപര്യ്യായേ സമ്പൂർണേ സതി സ നിജഗേഹം ജഗാമ| ");
INSERT INTO sanmal_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","കതിപയദിനേഷു ഗതേഷു തസ്യ ഭാര്യ്യാ ഇലീശേവാ ഗർബ്ഭവതീ ബഭൂവ ");
INSERT INTO sanmal_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","പശ്ചാത് സാ പഞ്ചമാസാൻ സംഗോപ്യാകഥയത് ലോകാനാം സമക്ഷം മമാപമാനം ഖണ്ഡയിതും പരമേശ്വരോ മയി ദൃഷ്ടിം പാതയിത്വാ കർമ്മേദൃശം കൃതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","അപരഞ്ച തസ്യാ ഗർബ്ഭസ്യ ഷഷ്ഠേ മാസേ ജാതേ ഗാലീൽപ്രദേശീയനാസരത്പുരേ ");
INSERT INTO sanmal_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ദായൂദോ വംശീയായ യൂഷഫ്നാമ്നേ പുരുഷായ യാ മരിയമ്നാമകുമാരീ വാഗ്ദത്താസീത് തസ്യാഃ സമീപം ജിബ്രായേൽ ദൂത ഈശ്വരേണ പ്രഹിതഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","സ ഗത്വാ ജഗാദ ഹേ ഈശ്വരാനുഗൃഹീതകന്യേ തവ ശുഭം ഭൂയാത് പ്രഭുഃ പരമേശ്വരസ്തവ സഹായോസ്തി നാരീണാം മധ്യേ ത്വമേവ ധന്യാ| ");
INSERT INTO sanmal_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","തദാനീം സാ തം ദൃഷ്ട്വാ തസ്യ വാക്യത ഉദ്വിജ്യ കീദൃശം ഭാഷണമിദമ് ഇതി മനസാ ചിന്തയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","തതോ ദൂതോഽവദത് ഹേ മരിയമ് ഭയം മാകാർഷീഃ, ത്വയി പരമേശ്വരസ്യാനുഗ്രഹോസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","പശ്യ ത്വം ഗർബ്ഭം ധൃത്വാ പുത്രം പ്രസോഷ്യസേ തസ്യ നാമ യീശുരിതി കരിഷ്യസി| ");
INSERT INTO sanmal_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","സ മഹാൻ ഭവിഷ്യതി തഥാ സർവ്വേഭ്യഃ ശ്രേഷ്ഠസ്യ പുത്ര ഇതി ഖ്യാസ്യതി; അപരം പ്രഭുഃ പരമേശ്വരസ്തസ്യ പിതുർദായൂദഃ സിംഹാസനം തസ്മൈ ദാസ്യതി; ");
INSERT INTO sanmal_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","തഥാ സ യാകൂബോ വംശോപരി സർവ്വദാ രാജത്വം കരിഷ്യതി, തസ്യ രാജത്വസ്യാന്തോ ന ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","തദാ മരിയമ് തം ദൂതം ബഭാഷേ നാഹം പുരുഷസങ്ഗം കരോമി തർഹി കഥമേതത് സമ്ഭവിഷ്യതി? ");
INSERT INTO sanmal_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","തതോ ദൂതോഽകഥയത് പവിത്ര ആത്മാ ത്വാമാശ്രായിഷ്യതി തഥാ സർവ്വശ്രേഷ്ഠസ്യ ശക്തിസ്തവോപരി ഛായാം കരിഷ്യതി തതോ ഹേതോസ്തവ ഗർബ്ഭാദ് യഃ പവിത്രബാലകോ ജനിഷ്യതേ സ ഈശ്വരപുത്ര ഇതി ഖ്യാതിം പ്രാപ്സ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","അപരഞ്ച പശ്യ തവ ജ്ഞാതിരിലീശേവാ യാം സർവ്വേ ബന്ധ്യാമവദൻ ഇദാനീം സാ വാർദ്ധക്യേ സന്താനമേകം ഗർബ്ഭേഽധാരയത് തസ്യ ഷഷ്ഠമാസോഭൂത്| ");
INSERT INTO sanmal_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","കിമപി കർമ്മ നാസാധ്യമ് ഈശ്വരസ്യ| ");
INSERT INTO sanmal_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","തദാ മരിയമ് ജഗാദ, പശ്യ പ്രഭേരഹം ദാസീ മഹ്യം തവ വാക്യാനുസാരേണ സർവ്വമേതദ് ഘടതാമ്; അനനതരം ദൂതസ്തസ്യാഃ സമീപാത് പ്രതസ്ഥേ| ");
INSERT INTO sanmal_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","അഥ കതിപയദിനാത് പരം മരിയമ് തസ്മാത് പർവ്വതമയപ്രദേശീയയിഹൂദായാ നഗരമേകം ശീഘ്രം ഗത്വാ ");
INSERT INTO sanmal_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","സിഖരിയയാജകസ്യ ഗൃഹം പ്രവിശ്യ തസ്യ ജായാമ് ഇലീശേവാം സമ്ബോധ്യാവദത്| ");
INSERT INTO sanmal_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","തതോ മരിയമഃ സമ്ബോധനവാക്യേ ഇലീശേവായാഃ കർണയോഃ പ്രവിഷ്ടമാത്രേ സതി തസ്യാ ഗർബ്ഭസ്ഥബാലകോ നനർത്ത| തത ഇലീശേവാ പവിത്രേണാത്മനാ പരിപൂർണാ സതീ ");
INSERT INTO sanmal_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","പ്രോച്ചൈർഗദിതുമാരേഭേ, യോഷിതാം മധ്യേ ത്വമേവ ധന്യാ, തവ ഗർബ്ഭസ്ഥഃ ശിശുശ്ച ധന്യഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ത്വം പ്രഭോർമാതാ, മമ നിവേശനേ ത്വയാ ചരണാവർപിതൗ, മമാദ്യ സൗഭാഗ്യമേതത്| ");
INSERT INTO sanmal_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","പശ്യ തവ വാക്യേ മമ കർണയോഃ പ്രവിഷ്ടമാത്രേ സതി മമോദരസ്ഥഃ ശിശുരാനന്ദാൻ നനർത്ത| ");
INSERT INTO sanmal_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","യാ സ്ത്രീ വ്യശ്വസീത് സാ ധന്യാ, യതോ ഹേതോസ്താം പ്രതി പരമേശ്വരോക്തം വാക്യം സർവ്വം സിദ്ധം ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","തദാനീം മരിയമ് ജഗാദ| ധന്യവാദം പരേശസ്യ കരോതി മാമകം മനഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","മമാത്മാ താരകേശേ ച സമുല്ലാസം പ്രഗച്ഛതി| ");
INSERT INTO sanmal_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","അകരോത് സ പ്രഭു ർദുഷ്ടിം സ്വദാസ്യാ ദുർഗതിം പ്രതി| പശ്യാദ്യാരഭ്യ മാം ധന്യാം വക്ഷ്യന്തി പുരുഷാഃ സദാ| ");
INSERT INTO sanmal_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","യഃ സർവ്വശക്തിമാൻ യസ്യ നാമാപി ച പവിത്രകം| സ ഏവ സുമഹത്കർമ്മ കൃതവാൻ മന്നിമിത്തകം| ");
INSERT INTO sanmal_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","യേ ബിഭ്യതി ജനാസ്തസ്മാത് തേഷാം സന്താനപംക്തിഷു| അനുകമ്പാ തദീയാ ച സർവ്വദൈവ സുതിഷ്ഠതി| ");
INSERT INTO sanmal_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","സ്വബാഹുബലതസ്തേന പ്രാകാശ്യത പരാക്രമഃ| മനഃകുമന്ത്രണാസാർദ്ധം വികീര്യ്യന്തേഽഭിമാനിനഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","സിംഹാസനഗതാല്ലോകാൻ ബലിനശ്ചാവരോഹ്യ സഃ| പദേഷൂച്ചേഷു ലോകാംസ്തു ക്ഷുദ്രാൻ സംസ്ഥാപയത്യപി| ");
INSERT INTO sanmal_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ക്ഷുധിതാൻ മാനവാൻ ദ്രവ്യൈരുത്തമൈഃ പരിതർപ്യ സഃ| സകലാൻ ധനിനോ ലോകാൻ വിസൃജേദ് രിക്തഹസ്തകാൻ| ");
INSERT INTO sanmal_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ഇബ്രാഹീമി ച തദ്വംശേ യാ ദയാസ്തി സദൈവ താം| സ്മൃത്വാ പുരാ പിതൃണാം നോ യഥാ സാക്ഷാത് പ്രതിശ്രുതം| ");
INSERT INTO sanmal_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ഇസ്രായേൽസേവകസ്തേന തഥോപക്രിയതേ സ്വയം|| ");
INSERT INTO sanmal_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","അനന്തരം മരിയമ് പ്രായേണ മാസത്രയമ് ഇലീശേവയാ സഹോഷിത്വാ വ്യാഘുയ്യ നിജനിവേശനം യയൗ| ");
INSERT INTO sanmal_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","തദനന്തരമ് ഇലീശേവായാഃ പ്രസവകാല ഉപസ്ഥിതേ സതി സാ പുത്രം പ്രാസോഷ്ട| ");
INSERT INTO sanmal_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","തതഃ പരമേശ്വരസ്തസ്യാം മഹാനുഗ്രഹം കൃതവാൻ ഏതത് ശ്രുത്വാ സമീപവാസിനഃ കുടുമ്ബാശ്ചാഗത്യ തയാ സഹ മുമുദിരേ| ");
INSERT INTO sanmal_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","തഥാഷ്ടമേ ദിനേ തേ ബാലകസ്യ ത്വചം ഛേത്തുമ് ഏത്യ തസ്യ പിതൃനാമാനുരൂപം തന്നാമ സിഖരിയ ഇതി കർത്തുമീഷുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","കിന്തു തസ്യ മാതാകഥയത് തന്ന, നാമാസ്യ യോഹൻ ഇതി കർത്തവ്യമ്| ");
INSERT INTO sanmal_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","തദാ തേ വ്യാഹരൻ തവ വംശമധ്യേ നാമേദൃശം കസ്യാപി നാസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","തതഃ പരം തസ്യ പിതരം സിഖരിയം പ്രതി സങ്കേത്യ പപ്രച്ഛുഃ ശിശോഃ കിം നാമ കാരിഷ്യതേ? ");
INSERT INTO sanmal_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","തതഃ സ ഫലകമേകം യാചിത്വാ ലിലേഖ തസ്യ നാമ യോഹൻ ഭവിഷ്യതി| തസ്മാത് സർവ്വേ ആശ്ചര്യ്യം മേനിരേ| ");
INSERT INTO sanmal_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","തത്ക്ഷണം സിഖരിയസ്യ ജിഹ്വാജാഡ്യേഽപഗതേ സ മുഖം വ്യാദായ സ്പഷ്ടവർണമുച്ചാര്യ്യ ഈശ്വരസ്യ ഗുണാനുവാദം ചകാര| ");
INSERT INTO sanmal_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","തസ്മാച്ചതുർദിക്സ്ഥാഃ സമീപവാസിലോകാ ഭീതാ ഏവമേതാഃ സർവ്വാഃ കഥാ യിഹൂദായാഃ പർവ്വതമയപ്രദേശസ്യ സർവ്വത്ര പ്രചാരിതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","തസ്മാത് ശ്രോതാരോ മനഃസു സ്ഥാപയിത്വാ കഥയാമ്ബഭൂവുഃ കീദൃശോയം ബാലോ ഭവിഷ്യതി? അഥ പരമേശ്വരസ്തസ്യ സഹായോഭൂത്| ");
INSERT INTO sanmal_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","തദാ യോഹനഃ പിതാ സിഖരിയഃ പവിത്രേണാത്മനാ പരിപൂർണഃ സൻ ഏതാദൃശം ഭവിഷ്യദ്വാക്യം കഥയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","ഇസ്രായേലഃ പ്രഭു ര്യസ്തു സ ധന്യഃ പരമേശ്വരഃ| അനുഗൃഹ്യ നിജാല്ലോകാൻ സ ഏവ പരിമോചയേത്| ");
INSERT INTO sanmal_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","വിപക്ഷജനഹസ്തേഭ്യോ യഥാ മോച്യാമഹേ വയം| യാവജ്ജീവഞ്ച ധർമ്മേണ സാരല്യേന ച നിർഭയാഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","സേവാമഹൈ തമേവൈകമ് ഏതത്കാരണമേവ ച| സ്വകീയം സുപവിത്രഞ്ച സംസ്മൃത്യ നിയമം സദാ| ");
INSERT INTO sanmal_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","കൃപയാ പുരുഷാൻ പൂർവ്വാൻ നികഷാർഥാത്തു നഃ പിതുഃ| ഇബ്രാഹീമഃ സമീപേ യം ശപഥം കൃതവാൻ പുരാ| ");
INSERT INTO sanmal_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","തമേവ സഫലം കർത്തം തഥാ ശത്രുഗണസ്യ ച| ഋृതീയാകാരിണശ്ചൈവ കരേഭ്യോ രക്ഷണായ നഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","സൃഷ്ടേഃ പ്രഥമതഃ സ്വീയൈഃ പവിത്രൈ ർഭാവിവാദിഭിഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","യഥോക്തവാൻ തഥാ സ്വസ്യ ദായൂദഃ സേവകസ്യ തു| ");
INSERT INTO sanmal_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","വംശേ ത്രാതാരമേകം സ സമുത്പാദിതവാൻ സ്വയമ്| ");
INSERT INTO sanmal_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","അതോ ഹേ ബാലക ത്വന്തു സർവ്വേഭ്യഃ ശ്രേഷ്ഠ ഏവ യഃ| തസ്യൈവ ഭാവിവാദീതി പ്രവിഖ്യാതോ ഭവിഷ്യസി| അസ്മാകം ചരണാൻ ക്ഷേമേ മാർഗേ ചാലയിതും സദാ| ഏവം ധ്വാന്തേഽർഥതോ മൃത്യോശ്ഛായായാം യേ തു മാനവാഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ഉപവിഷ്ടാസ്തു താനേവ പ്രകാശയിതുമേവ ഹി| കൃത്വാ മഹാനുകമ്പാം ഹി യാമേവ പരമേശ്വരഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ഊർദ്വ്വാത് സൂര്യ്യമുദായ്യൈവാസ്മഭ്യം പ്രാദാത്തു ദർശനം| തയാനുകമ്പയാ സ്വസ്യ ലോകാനാം പാപമോചനേ| ");
INSERT INTO sanmal_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","പരിത്രാണസ്യ തേഭ്യോ ഹി ജ്ഞാനവിശ്രാണനായ ച| പ്രഭോ ർമാർഗം പരിഷ്കർത്തും തസ്യാഗ്രായീ ഭവിഷ്യസി|| ");
INSERT INTO sanmal_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","അഥ ബാലകഃ ശരീരേണ ബുദ്ധ്യാ ച വർദ്ധിതുമാരേഭേ; അപരഞ്ച സ ഇസ്രായേലോ വംശീയലോകാനാം സമീപേ യാവന്ന പ്രകടീഭൂതസ്താസ്താവത് പ്രാന്തരേ ന്യവസത്| ");
INSERT INTO sanmal_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","അപരഞ്ച തസ്മിൻ കാലേ രാജ്യസ്യ സർവ്വേഷാം ലോകാനാം നാമാനി ലേഖയിതുമ് അഗസ്തകൈസര ആജ്ഞാപയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","തദനുസാരേണ കുരീണിയനാമനി സുരിയാദേശസ്യ ശാസകേ സതി നാമലേഖനം പ്രാരേഭേ| ");
INSERT INTO sanmal_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","അതോ ഹേതോ ർനാമ ലേഖിതും സർവ്വേ ജനാഃ സ്വീയം സ്വീയം നഗരം ജഗ്മുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","തദാനീം യൂഷഫ് നാമ ലേഖിതും വാഗ്ദത്തയാ സ്വഭാര്യ്യയാ ഗർബ്ഭവത്യാ മരിയമാ സഹ സ്വയം ദായൂദഃ സജാതിവംശ ഇതി കാരണാദ് ഗാലീൽപ്രദേശസ്യ നാസരത്നഗരാദ് ");
INSERT INTO sanmal_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","യിഹൂദാപ്രദേശസ്യ ബൈത്ലേഹമാഖ്യം ദായൂദ്നഗരം ജഗാമ| ");
INSERT INTO sanmal_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","അന്യച്ച തത്ര സ്ഥാനേ തയോസ്തിഷ്ഠതോഃ സതോ ർമരിയമഃ പ്രസൂതികാല ഉപസ്ഥിതേ ");
INSERT INTO sanmal_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","സാ തം പ്രഥമസുതം പ്രാസോഷ്ട കിന്തു തസ്മിൻ വാസഗൃഹേ സ്ഥാനാഭാവാദ് ബാലകം വസ്ത്രേണ വേഷ്ടയിത്വാ ഗോശാലായാം സ്ഥാപയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","അനന്തരം യേ കിയന്തോ മേഷപാലകാഃ സ്വമേഷവ്രജരക്ഷായൈ തത്പ്രദേശേ സ്ഥിത്വാ രജന്യാം പ്രാന്തരേ പ്രഹരിണഃ കർമ്മ കുർവ്വന്തി, ");
INSERT INTO sanmal_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","തേഷാം സമീപം പരമേശ്വരസ്യ ദൂത ആഗത്യോപതസ്ഥൗ; തദാ ചതുഷ്പാർശ്വേ പരമേശ്വരസ്യ തേജസഃ പ്രകാശിതത്വാത് തേഽതിശശങ്കിരേ| ");
INSERT INTO sanmal_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","തദാ സ ദൂത ഉവാച മാ ഭൈഷ്ട പശ്യതാദ്യ ദായൂദഃ പുരേ യുഷ്മന്നിമിത്തം ത്രാതാ പ്രഭുഃ ഖ്രീഷ്ടോഽജനിഷ്ട, ");
INSERT INTO sanmal_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","സർവ്വേഷാം ലോകാനാം മഹാനന്ദജനകമ് ഇമം മങ്ഗലവൃത്താന്തം യുഷ്മാൻ ജ്ഞാപയാമി| ");
INSERT INTO sanmal_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","യൂയം (തത്സ്ഥാനം ഗത്വാ) വസ്ത്രവേഷ്ടിതം തം ബാലകം ഗോശാലായാം ശയനം ദ്രക്ഷ്യഥ യുഷ്മാൻ പ്രതീദം ചിഹ്നം ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ദൂത ഇമാം കഥാം കഥിതവതി തത്രാകസ്മാത് സ്വർഗീയാഃ പൃതനാ ആഗത്യ കഥാമ് ഇമാം കഥയിത്വേശ്വരസ്യ ഗുണാനന്വവാദിഷുഃ, യഥാ, ");
INSERT INTO sanmal_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","സർവ്വോർദ്വ്വസ്ഥൈരീശ്വരസ്യ മഹിമാ സമ്പ്രകാശ്യതാം| ശാന്തിർഭൂയാത് പൃഥിവ്യാസ്തു സന്തോഷശ്ച നരാൻ പ്രതി|| ");
INSERT INTO sanmal_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","തതഃ പരം തേഷാം സന്നിധേ ർദൂതഗണേ സ്വർഗം ഗതേ മേഷപാലകാഃ പരസ്പരമ് അവേചൻ ആഗച്ഛത പ്രഭുഃ പരമേശ്വരോ യാം ഘടനാം ജ്ഞാപിതവാൻ തസ്യാ യാഥര്യം ജ്ഞാതും വയമധുനാ ബൈത്ലേഹമ്പുരം യാമഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","പശ്ചാത് തേ തൂർണം വ്രജിത്വാ മരിയമം യൂഷഫം ഗോശാലായാം ശയനം ബാലകഞ്ച ദദൃശുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ഇത്ഥം ദൃഷ്ട്വാ ബാലകസ്യാർഥേ പ്രോക്താം സർവ്വകഥാം തേ പ്രാചാരയാഞ്ചക്രുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","തതോ യേ ലോകാ മേഷരക്ഷകാണാം വദനേഭ്യസ്താം വാർത്താം ശുശ്രുവുസ്തേ മഹാശ്ചര്യ്യം മേനിരേ| ");
INSERT INTO sanmal_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","കിന്തു മരിയമ് ഏതത്സർവ്വഘടനാനാം താത്പര്യ്യം വിവിച്യ മനസി സ്ഥാപയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","തത്പശ്ചാദ് ദൂതവിജ്ഞപ്താനുരൂപം ശ്രുത്വാ ദൃഷ്ട്വാ ച മേഷപാലകാ ഈശ്വരസ്യ ഗുണാനുവാദം ധന്യവാദഞ്ച കുർവ്വാണാഃ പരാവൃത്യ യയുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","അഥ ബാലകസ്യ ത്വക്ഛേദനകാലേഽഷ്ടമദിവസേ സമുപസ്ഥിതേ തസ്യ ഗർബ്ഭസ്ഥിതേഃ പുർവ്വം സ്വർഗീയദൂതോ യഥാജ്ഞാപയത് തദനുരൂപം തേ തന്നാമധേയം യീശുരിതി ചക്രിരേ| ");
INSERT INTO sanmal_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","തതഃ പരം മൂസാലിഖിതവ്യവസ്ഥായാ അനുസാരേണ മരിയമഃ ശുചിത്വകാല ഉപസ്ഥിതേ, ");
INSERT INTO sanmal_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","\"പ്രഥമജഃ സർവ്വഃ പുരുഷസന്താനഃ പരമേശ്വരേ സമർപ്യതാം,\" ഇതി പരമേശ്വരസ്യ വ്യവസ്ഥയാ ");
INSERT INTO sanmal_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","യീശും പരമേശ്വരേ സമർപയിതുമ് ശാസ്ത്രീയവിധ്യുക്തം കപോതദ്വയം പാരാവതശാവകദ്വയം വാ ബലിം ദാതും തേ തം ഗൃഹീത്വാ യിരൂശാലമമ് ആയയുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","യിരൂശാലമ്പുരനിവാസീ ശിമിയോന്നാമാ ധാർമ്മിക ഏക ആസീത് സ ഇസ്രായേലഃ സാന്ത്വനാമപേക്ഷ്യ തസ്ഥൗ കിഞ്ച പവിത്ര ആത്മാ തസ്മിന്നാവിർഭൂതഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","അപരം പ്രഭുണാ പരമേശ്വരേണാഭിഷിക്തേ ത്രാതരി ത്വയാ ന ദൃഷ്ടേ ത്വം ന മരിഷ്യസീതി വാക്യം പവിത്രേണ ആത്മനാ തസ്മ പ്രാകഥ്യത| ");
INSERT INTO sanmal_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","അപരഞ്ച യദാ യീശോഃ പിതാ മാതാ ച തദർഥം വ്യവസ്ഥാനുരൂപം കർമ്മ കർത്തും തം മന്ദിരമ് ആനിന്യതുസ്തദാ ");
INSERT INTO sanmal_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ശിമിയോൻ ആത്മന ആകർഷണേന മന്ദിരമാഗത്യ തം ക്രോഡേ നിധായ ഈശ്വരസ്യ ധന്യവാദം കൃത്വാ കഥയാമാസ, യഥാ, ");
INSERT INTO sanmal_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","ഹേ പ്രഭോ തവ ദാസോയം നിജവാക്യാനുസാരതഃ| ഇദാനീന്തു സകല്യാണോ ഭവതാ സംവിസൃജ്യതാമ്| ");
INSERT INTO sanmal_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","യതഃ സകലദേശസ്യ ദീപ്തയേ ദീപ്തിരൂപകം| ");
INSERT INTO sanmal_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ഇസ്രായേലീയലോകസ്യ മഹാഗൗരവരൂപകം| ");
INSERT INTO sanmal_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","യം ത്രായകം ജനാനാന്തു സമ്മുഖേ ത്വമജീജനഃ| സഏവ വിദ്യതേഽസ്മാകം ധ്രവം നയനനഗോചരേ|| ");
INSERT INTO sanmal_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","തദാനീം തേനോക്താ ഏതാഃ സകലാഃ കഥാഃ ശ്രുത്വാ തസ്യ മാതാ യൂഷഫ് ച വിസ്മയം മേനാതേ| ");
INSERT INTO sanmal_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","തതഃ പരം ശിമിയോൻ തേഭ്യ ആശിഷം ദത്ത്വാ തന്മാതരം മരിയമമ് ഉവാച, പശ്യ ഇസ്രായേലോ വംശമധ്യേ ബഹൂനാം പാതനായോത്ഥാപനായ ച തഥാ വിരോധപാത്രം ഭവിതും, ബഹൂനാം ഗുപ്തമനോഗതാനാം പ്രകടീകരണായ ബാലകോയം നിയുക്തോസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","തസ്മാത് തവാപി പ്രാണാഃ ശൂലേന വ്യത്സ്യന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","അപരഞ്ച ആശേരസ്യ വംശീയഫിനൂയേലോ ദുഹിതാ ഹന്നാഖ്യാ അതിജരതീ ഭവിഷ്യദ്വാദിന്യേകാ യാ വിവാഹാത് പരം സപ്ത വത്സരാൻ പത്യാ സഹ ന്യവസത് തതോ വിധവാ ഭൂത്വാ ചതുരശീതിവർഷവയഃപര്യ്യനതം ");
INSERT INTO sanmal_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","മന്ദിരേ സ്ഥിത്വാ പ്രാർഥനോപവാസൈർദിവാനിശമ് ഈശ്വരമ് അസേവത സാപി സ്ത്രീ തസ്മിൻ സമയേ മന്ദിരമാഗത്യ ");
INSERT INTO sanmal_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","പരമേശ്വരസ്യ ധന്യവാദം ചകാര, യിരൂശാലമ്പുരവാസിനോ യാവന്തോ ലോകാ മുക്തിമപേക്ഷ്യ സ്ഥിതാസ്താൻ യീശോർവൃത്താന്തം ജ്ഞാപയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ഇത്ഥം പരമേശ്വരസ്യ വ്യവസ്ഥാനുസാരേണ സർവ്വേഷു കർമ്മസു കൃതേഷു തൗ പുനശ്ച ഗാലീലോ നാസരത്നാമകം നിജനഗരം പ്രതസ്ഥാതേ| ");
INSERT INTO sanmal_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","തത്പശ്ചാദ് ബാലകഃ ശരീരേണ വൃദ്ധിമേത്യ ജ്ഞാനേന പരിപൂർണ ആത്മനാ ശക്തിമാംശ്ച ഭവിതുമാരേഭേ തഥാ തസ്മിൻ ഈശ്വരാനുഗ്രഹോ ബഭൂവ| ");
INSERT INTO sanmal_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","തസ്യ പിതാ മാതാ ച പ്രതിവർഷം നിസ്താരോത്സവസമയേ യിരൂശാലമമ് അഗച്ഛതാമ്| ");
INSERT INTO sanmal_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","അപരഞ്ച യീശൗ ദ്വാദശവർഷവയസ്കേ സതി തൗ പർവ്വസമയസ്യ രീത്യനുസാരേണ യിരൂശാലമം ഗത്വാ ");
INSERT INTO sanmal_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","പാർവ്വണം സമ്പാദ്യ പുനരപി വ്യാഘുയ്യ യാതഃ കിന്തു യീശുർബാലകോ യിരൂശാലമി തിഷ്ഠതി| യൂഷഫ് തന്മാതാ ച തദ് അവിദിത്വാ ");
INSERT INTO sanmal_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","സ സങ്ഗിഭിഃ സഹ വിദ്യത ഏതച്ച ബുദ്വ്വാ ദിനൈകഗമ്യമാർഗം ജഗ്മതുഃ| കിന്തു ശേഷേ ജ്ഞാതിബന്ധൂനാം സമീപേ മൃഗയിത്വാ തദുദ്ദേेശമപ്രാപ്യ ");
INSERT INTO sanmal_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","തൗ പുനരപി യിരൂശാലമമ് പരാവൃത്യാഗത്യ തം മൃഗയാഞ്ചക്രതുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","അഥ ദിനത്രയാത് പരം പണ്ഡിതാനാം മധ്യേ തേഷാം കഥാഃ ശൃണ്വൻ തത്ത്വം പൃച്ഛംശ്ച മന്ദിരേ സമുപവിഷ്ടഃ സ താഭ്യാം ദൃഷ്ടഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","തദാ തസ്യ ബുദ്ധ്യാ പ്രത്യുത്തരൈശ്ച സർവ്വേ ശ്രോതാരോ വിസ്മയമാപദ്യന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","താദൃശം ദൃഷ്ട്വാ തസ്യ ജനകോ ജനനീ ച ചമച്ചക്രതുഃ കിഞ്ച തസ്യ മാതാ തമവദത്, ഹേ പുത്ര, കഥമാവാം പ്രതീത്ഥം സമാചരസ്ത്വമ്? പശ്യ തവ പിതാഹഞ്ച ശോകാകുലൗ സന്തൗ ത്വാമന്വിച്ഛാവഃ സ്മ| ");
INSERT INTO sanmal_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","തതഃ സോവദത് കുതോ മാമ് അന്വൈച്ഛതം? പിതുർഗൃഹേ മയാ സ്ഥാതവ്യമ് ഏതത് കിം യുവാഭ്യാം ന ജ്ഞായതേ? ");
INSERT INTO sanmal_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","കിന്തു തൗ തസ്യൈതദ്വാക്യസ്യ താത്പര്യ്യം ബോദ്ധും നാശക്നുതാം| ");
INSERT INTO sanmal_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","തതഃ പരം സ താഭ്യാം സഹ നാസരതം ഗത്വാ തയോർവശീഭൂതസ്തസ്ഥൗ കിന്തു സർവ്വാ ഏതാഃ കഥാസ്തസ്യ മാതാ മനസി സ്ഥാപയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","അഥ യീശോ ർബുദ്ധിഃ ശരീരഞ്ച തഥാ തസ്മിൻ ഈശ്വരസ്യ മാനവാനാഞ്ചാനുഗ്രഹോ വർദ്ധിതുമ് ആരേഭേ| ");
INSERT INTO sanmal_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","അനന്തരം തിബിരിയകൈസരസ്യ രാജത്വസ്യ പഞ്ചദശേ വത്സരേ സതി യദാ പന്തീയപീലാതോ യിഹൂദാദേശാധിപതി ർഹേരോദ് തു ഗാലീൽപ്രദേശസ്യ രാജാ ഫിലിപനാമാ തസ്യ ഭ്രാതാ തു യിതൂരിയായാസ്ത്രാഖോനീതിയാപ്രദേശസ്യ ച രാജാസീത് ലുഷാനീയനാമാ അവിലീനീദേശസ്യ രാജാസീത് ");
INSERT INTO sanmal_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ഹാനൻ കിയഫാശ്ചേമൗ പ്രധാനയാജാകാവാസ്താം തദാനീം സിഖരിയസ്യ പുത്രായ യോഹനേ മധ്യേപ്രാന്തരമ് ഈശ്വരസ്യ വാക്യേ പ്രകാശിതേ സതി ");
INSERT INTO sanmal_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","സ യർദ്ദന ഉഭയതടപ്രദേശാൻ സമേത്യ പാപമോചനാർഥം മനഃപരാവർത്തനസ്യ ചിഹ്നരൂപം യന്മജ്ജനം തദീയാഃ കഥാഃ സർവ്വത്ര പ്രചാരയിതുമാരേഭേ| ");
INSERT INTO sanmal_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","യിശയിയഭവിഷ്യദ്വക്തൃഗ്രന്ഥേ യാദൃശീ ലിപിരാസ്തേ യഥാ, പരമേശസ്യ പന്ഥാനം പരിഷ്കുരുത സർവ്വതഃ| തസ്യ രാജപഥഞ്ചൈവ സമാനം കുരുതാധുനാ| ");
INSERT INTO sanmal_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","കാരിഷ്യന്തേ സമുച്ഛ്രായാഃ സകലാ നിമ്നഭൂമയഃ| കാരിഷ്യന്തേ നതാഃ സർവ്വേ പർവ്വതാശ്ചോപപർവ്വതാഃ| കാരിഷ്യന്തേ ച യാ വക്രാസ്താഃ സർവ്വാഃ സരലാ ഭുവഃ| കാരിഷ്യന്തേ സമാനാസ്താ യാ ഉച്ചനീചഭൂമയഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ഈശ്വരേണ കൃതം ത്രാണം ദ്രക്ഷ്യന്തി സർവ്വമാനവാഃ| ഇത്യേതത് പ്രാന്തരേ വാക്യം വദതഃ കസ്യചിദ് രവഃ|| ");
INSERT INTO sanmal_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","യേ യേ ലോകാ മജ്ജനാർഥം ബഹിരായയുസ്താൻ സോവദത് രേ രേ സർപവംശാ ആഗാമിനഃ കോപാത് പലായിതും യുഷ്മാൻ കശ്ചേതയാമാസ? ");
INSERT INTO sanmal_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","തസ്മാദ് ഇബ്രാഹീമ് അസ്മാകം പിതാ കഥാമീദൃശീം മനോഭി ർന കഥയിത്വാ യൂയം മനഃപരിവർത്തനയോഗ്യം ഫലം ഫലത; യുഷ്മാനഹം യഥാർഥം വദാമി പാഷാണേഭ്യ ഏതേഭ്യ ഈശ്വര ഇബ്രാഹീമഃ സന്താനോത്പാദനേ സമർഥഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","അപരഞ്ച തരുമൂലേഽധുനാപി പരശുഃ സംലഗ്നോസ്തി യസ്തരുരുത്തമം ഫലം ന ഫലതി സ ഛിദ്യതേഽഗ്നൗ നിക്ഷിപ്യതേ ച| ");
INSERT INTO sanmal_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","തദാനീം ലോകാസ്തം പപ്രച്ഛുസ്തർഹി കിം കർത്തവ്യമസ്മാഭിഃ? ");
INSERT INTO sanmal_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","തതഃ സോവാദീത് യസ്യ ദ്വേ വസനേ വിദ്യേതേ സ വസ്ത്രഹീനായൈകം വിതരതു കിംഞ്ച യസ്യ ഖാദ്യദ്രവ്യം വിദ്യതേ സോപി തഥൈവ കരോതു| ");
INSERT INTO sanmal_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","തതഃ പരം കരസഞ്ചായിനോ മജ്ജനാർഥമ് ആഗത്യ പപ്രച്ഛുഃ ഹേ ഗുരോ കിം കർത്തവ്യമസ്മാഭിഃ? ");
INSERT INTO sanmal_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","തതഃ സോകഥയത് നിരൂപിതാദധികം ന ഗൃഹ്ലിത| ");
INSERT INTO sanmal_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","അനന്തരം സേനാഗണ ഏത്യ പപ്രച്ഛ കിമസ്മാഭി ർവാ കർത്തവ്യമ്? തതഃ സോഭിദധേ കസ്യ കാമപി ഹാനിം മാ കാർഷ്ട തഥാ മൃഷാപവാദം മാ കുരുത നിജവേതനേന ച സന്തുഷ്യ തിഷ്ഠത| ");
INSERT INTO sanmal_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","അപരഞ്ച ലോകാ അപേക്ഷയാ സ്ഥിത്വാ സർവ്വേപീതി മനോഭി ർവിതർകയാഞ്ചക്രുഃ, യോഹനയമ് അഭിഷിക്തസ്ത്രാതാ ന വേതി? ");
INSERT INTO sanmal_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","തദാ യോഹൻ സർവ്വാൻ വ്യാജഹാര, ജലേഽഹം യുഷ്മാൻ മജ്ജയാമി സത്യം കിന്തു യസ്യ പാദുകാബന്ധനം മോചയിതുമപി ന യോഗ്യോസ്മി താദൃശ ഏകോ മത്തോ ഗുരുതരഃ പുമാൻ ഏതി, സ യുഷ്മാൻ വഹ്നിരൂപേ പവിത്ര ആത്മനി മജ്ജയിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","അപരഞ്ച തസ്യ ഹസ്തേ ശൂർപ ആസ്തേ സ സ്വശസ്യാനി ശുദ്ധരൂപം പ്രസ്ഫോട്യ ഗോധൂമാൻ സർവ്വാൻ ഭാണ്ഡാഗാരേ സംഗ്രഹീഷ്യതി കിന്തു ബൂഷാണി സർവ്വാണ്യനിർവ്വാണവഹ്നിനാ ദാഹയിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","യോഹൻ ഉപദേശേനേത്ഥം നാനാകഥാ ലോകാനാം സമക്ഷം പ്രചാരയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","അപരഞ്ച ഹേരോദ് രാജാ ഫിലിപ്നാമ്നഃ സഹോദരസ്യ ഭാര്യ്യാം ഹേരോദിയാമധി തഥാന്യാനി യാനി യാനി കുകർമ്മാണി കൃതവാൻ തദധി ച ");
INSERT INTO sanmal_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","യോഹനാ തിരസ്കൃതോ ഭൂത്വാ കാരാഗാരേ തസ്യ ബന്ധനാദ് അപരമപി കുകർമ്മ ചകാര| ");
INSERT INTO sanmal_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ഇതഃ പൂർവ്വം യസ്മിൻ സമയേ സർവ്വേ യോഹനാ മജ്ജിതാസ്തദാനീം യീശുരപ്യാഗത്യ മജ്ജിതഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","തദനന്തരം തേന പ്രാർഥിതേ മേഘദ്വാരം മുക്തം തസ്മാച്ച പവിത്ര ആത്മാ മൂർത്തിമാൻ ഭൂത്വാ കപോതവത് തദുപര്യ്യവരുരോഹ; തദാ ത്വം മമ പ്രിയഃ പുത്രസ്ത്വയി മമ പരമഃ സന്തോഷ ഇത്യാകാശവാണീ ബഭൂവ| ");
INSERT INTO sanmal_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","തദാനീം യീശുഃ പ്രായേണ ത്രിംശദ്വർഷവയസ്ക ആസീത്| ലൗകികജ്ഞാനേ തു സ യൂഷഫഃ പുത്രഃ, ");
INSERT INTO sanmal_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","യൂഷഫ് ഏലേഃ പുത്രഃ, ഏലിർമത്തതഃ പുത്രഃ, മത്തത് ലേവേഃ പുത്രഃ, ലേവി ർമൽകേഃ പുത്രഃ, മൽകിര്യാന്നസ്യ പുത്രഃ; യാന്നോ യൂഷഫഃ പുത്രഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","യൂഷഫ് മത്തഥിയസ്യ പുത്രഃ, മത്തഥിയ ആമോസഃ പുത്രഃ, ആമോസ് നഹൂമഃ പുത്രഃ, നഹൂമ് ഇഷ്ലേഃ പുത്രഃ ഇഷ്ലിർനഗേഃ പുത്രഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","നഗിർമാടഃ പുത്രഃ, മാട് മത്തഥിയസ്യ പുത്രഃ, മത്തഥിയഃ ശിമിയേഃ പുത്രഃ, ശിമിയിര്യൂഷഫഃ പുത്രഃ, യൂഷഫ് യിഹൂദാഃ പുത്രഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","യിഹൂദാ യോഹാനാഃ പുത്രഃ, യോഹാനാ രീഷാഃ പുത്രഃ, രീഷാഃ സിരുബ്ബാബിലഃ പുത്രഃ, സിരുബ്ബാബിൽ ശൽതീയേലഃ പുത്രഃ, ശൽതീയേൽ നേരേഃ പുത്രഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","നേരിർമൽകേഃ പുത്രഃ, മൽകിഃ അദ്യഃ പുത്രഃ, അദ്ദീ കോഷമഃ പുത്രഃ, കോഷമ് ഇൽമോദദഃ പുത്രഃ, ഇൽമോദദ് ഏരഃ പുത്രഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ഏർ യോശേഃ പുത്രഃ, യോശിഃ ഇലീയേഷരഃ പുത്രഃ, ഇലീയേഷർ യോരീമഃ പുത്രഃ, യോരീമ് മത്തതഃ പുത്രഃ, മത്തത ലേവേഃ പുത്രഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ലേവിഃ ശിമിയോനഃ പുത്രഃ, ശിമിയോൻ യിഹൂദാഃ പുത്രഃ, യിഹൂദാ യൂഷുഫഃ പുത്രഃ, യൂഷുഫ് യോനനഃ പുത്രഃ, യാനൻ ഇലീയാകീമഃ പുത്രഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ഇലിയാകീമ്ഃ മിലേയാഃ പുത്രഃ, മിലേയാ മൈനനഃ പുത്രഃ, മൈനൻ മത്തത്തസ്യ പുത്രഃ, മത്തത്തോ നാഥനഃ പുത്രഃ, നാഥൻ ദായൂദഃ പുത്രഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ദായൂദ് യിശയഃ പുത്രഃ, യിശയ ഓബേദഃ പുത്ര, ഓബേദ് ബോയസഃ പുത്രഃ, ബോയസ് സൽമോനഃ പുത്രഃ, സൽമോൻ നഹശോനഃ പുത്രഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","നഹശോൻ അമ്മീനാദബഃ പുത്രഃ, അമ്മീനാദബ് അരാമഃ പുത്രഃ, അരാമ് ഹിഷ്രോണഃ പുത്രഃ, ഹിഷ്രോൺ പേരസഃ പുത്രഃ, പേരസ് യിഹൂദാഃ പുത്രഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","യിഹൂദാ യാകൂബഃ പുത്രഃ, യാകൂബ് ഇസ്ഹാകഃ പുത്രഃ, ഇസ്ഹാക് ഇബ്രാഹീമഃ പുത്രഃ, ഇബ്രാഹീമ് തേരഹഃ പുത്രഃ, തേരഹ് നാഹോരഃ പുത്രഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","നാഹോർ സിരുഗഃ പുത്രഃ, സിരുഗ് രിയ്വഃ പുത്രഃ, രിയൂഃ പേലഗഃ പുത്രഃ, പേലഗ് ഏവരഃ പുത്രഃ, ഏവർ ശേലഹഃ പുത്രഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ശേലഹ് കൈനനഃ പുത്രഃ, കൈനൻ അർഫക്ഷദഃ പുത്രഃ, അർഫക്ഷദ് ശാമഃ പുത്രഃ, ശാമ് നോഹഃ പുത്രഃ, നോഹോ ലേമകഃ പുത്രഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ലേമക് മിഥൂശേലഹഃ പുത്രഃ, മിഥൂശേലഹ് ഹനോകഃ പുത്രഃ, ഹനോക് യേരദഃ പുത്രഃ, യേരദ് മഹലലേലഃ പുത്രഃ, മഹലലേൽ കൈനനഃ പുത്രഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","കൈനൻ ഇനോശഃ പുത്രഃ, ഇനോശ് ശേതഃ പുത്രഃ, ശേത് ആദമഃ പുത്ര, ആദമ് ഈശ്വരസ്യ പുത്രഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","തതഃ പരം യീശുഃ പവിത്രേണാത്മനാ പൂർണഃ സൻ യർദ്ദനനദ്യാഃ പരാവൃത്യാത്മനാ പ്രാന്തരം നീതഃ സൻ ചത്വാരിംശദ്ദിനാനി യാവത് ശൈതാനാ പരീക്ഷിതോഽഭൂത്, ");
INSERT INTO sanmal_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","കിഞ്ച താനി സർവ്വദിനാനി ഭോജനം വിനാ സ്ഥിതത്വാത് കാലേ പൂർണേ സ ക്ഷുധിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","തതഃ ശൈതാനാഗത്യ തമവദത് ത്വം ചേദീശ്വരസ്യ പുത്രസ്തർഹി പ്രസ്തരാനേതാൻ ആജ്ഞയാ പൂപാൻ കുരു| ");
INSERT INTO sanmal_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","തദാ യീശുരുവാച, ലിപിരീദൃശീ വിദ്യതേ മനുജഃ കേവലേന പൂപേന ന ജീവതി കിന്ത്വീശ്വരസ്യ സർവ്വാഭിരാജ്ഞാഭി ർജീവതി| ");
INSERT INTO sanmal_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","തദാ ശൈതാൻ തമുച്ചം പർവ്വതം നീത്വാ നിമിഷൈകമധ്യേ ജഗതഃ സർവ്വരാജ്യാനി ദർശിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","പശ്ചാത് തമവാദീത് സർവ്വമ് ഏതദ് വിഭവം പ്രതാപഞ്ച തുഭ്യം ദാസ്യാമി തൻ മയി സമർപിതമാസ്തേ യം പ്രതി മമേച്ഛാ ജായതേ തസ്മൈ ദാതും ശക്നോമി, ");
INSERT INTO sanmal_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ത്വം ചേന്മാം ഭജസേ തർഹി സർവ്വമേതത് തവൈവ ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","തദാ യീശുസ്തം പ്രത്യുക്തവാൻ ദൂരീ ഭവ ശൈതാൻ ലിപിരാസ്തേ, നിജം പ്രഭും പരമേശ്വരം ഭജസ്വ കേവലം തമേവ സേവസ്വ ച| ");
INSERT INTO sanmal_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","അഥ ശൈതാൻ തം യിരൂശാലമം നീത്വാ മന്ദിരസ്യ ചൂഡായാ ഉപരി സമുപവേശ്യ ജഗാദ ത്വം ചേദീശ്വരസ്യ പുത്രസ്തർഹി സ്ഥാനാദിതോ ലമ്ഫിത്വാധഃ ");
INSERT INTO sanmal_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","പത യതോ ലിപിരാസ്തേ, ആജ്ഞാപയിഷ്യതി സ്വീയാൻ ദൂതാൻ സ പരമേശ്വരഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","രക്ഷിതും സർവ്വമാർഗേ ത്വാം തേന ത്വച്ചരണേ യഥാ| ന ലഗേത് പ്രസ്തരാഘാതസ്ത്വാം ധരിഷ്യന്തി തേ തഥാ| ");
INSERT INTO sanmal_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","തദാ യീശുനാ പ്രത്യുക്തമ് ഇദമപ്യുക്തമസ്തി ത്വം സ്വപ്രഭും പരേശം മാ പരീക്ഷസ്വ| ");
INSERT INTO sanmal_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","പശ്ചാത് ശൈതാൻ സർവ്വപരീക്ഷാം സമാപ്യ ക്ഷണാത്തം ത്യക്ത്വാ യയൗ| ");
INSERT INTO sanmal_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","തദാ യീശുരാത്മപ്രഭാവാത് പുനർഗാലീൽപ്രദേശം ഗതസ്തദാ തത്സുഖ്യാതിശ്ചതുർദിശം വ്യാനശേ| ");
INSERT INTO sanmal_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","സ തേഷാം ഭജനഗൃഹേഷു ഉപദിശ്യ സർവ്വൈഃ പ്രശംസിതോ ബഭൂവ| ");
INSERT INTO sanmal_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","അഥ സ സ്വപാലനസ്ഥാനം നാസരത്പുരമേത്യ വിശ്രാമവാരേ സ്വാചാരാദ് ഭജനഗേഹം പ്രവിശ്യ പഠിതുമുത്തസ്ഥൗ| ");
INSERT INTO sanmal_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","തതോ യിശയിയഭവിഷ്യദ്വാദിനഃ പുസ്തകേ തസ്യ കരദത്തേ സതി സ തത് പുസ്തകം വിസ്താര്യ്യ യത്ര വക്ഷ്യമാണാനി വചനാനി സന്തി തത് സ്ഥാനം പ്രാപ്യ പപാഠ| ");
INSERT INTO sanmal_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","ആത്മാ തു പരമേശസ്യ മദീയോപരി വിദ്യതേ| ദരിദ്രേഷു സുസംവാദം വക്തും മാം സോഭിഷിക്തവാൻ| ഭഗ്നാന്തഃ കരണാല്ലോകാൻ സുസ്വസ്ഥാൻ കർത്തുമേവ ച| ബന്ദീകൃതേഷു ലോകേഷു മുക്തേ ർഘോഷയിതും വചഃ| നേത്രാണി ദാതുമന്ധേഭ്യസ്ത്രാതും ബദ്ധജനാനപി| ");
INSERT INTO sanmal_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","പരേശാനുഗ്രഹേ കാലം പ്രചാരയിതുമേവ ച| സർവ്വൈതത്കരണാർഥായ മാമേവ പ്രഹിണോതി സഃ|| ");
INSERT INTO sanmal_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","തതഃ പുസ്തകം ബദ്വ്വാ പരിചാരകസ്യ ഹസ്തേ സമർപ്യ ചാസനേ സമുപവിഷ്ടഃ, തതോ ഭജനഗൃഹേ യാവന്തോ ലോകാ ആസൻ തേ സർവ്വേഽനന്യദൃഷ്ട്യാ തം വിലുലോകിരേ| ");
INSERT INTO sanmal_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","അനന്തരമ് അദ്യൈതാനി സർവ്വാണി ലിഖിതവചനാനി യുഷ്മാകം മധ്യേ സിദ്ധാനി സ ഇമാം കഥാം തേഭ്യഃ കഥയിതുമാരേഭേ| ");
INSERT INTO sanmal_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","തതഃ സർവ്വേ തസ്മിൻ അന്വരജ്യന്ത, കിഞ്ച തസ്യ മുഖാന്നിർഗതാഭിരനുഗ്രഹസ്യ കഥാഭിശ്ചമത്കൃത്യ കഥയാമാസുഃ കിമയം യൂഷഫഃ പുത്രോ ന? ");
INSERT INTO sanmal_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","തദാ സോഽവാദീദ് ഹേ ചികിത്സക സ്വമേവ സ്വസ്ഥം കുരു കഫർനാഹൂമി യദ്യത് കൃതവാൻ തദശ്രൗഷ്മ താഃ സർവാഃ ക്രിയാ അത്ര സ്വദേശേ കുരു കഥാമേതാം യൂയമേവാവശ്യം മാം വദിഷ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","പുനഃ സോവാദീദ് യുഷ്മാനഹം യഥാർഥം വദാമി, കോപി ഭവിഷ്യദ്വാദീ സ്വദേശേ സത്കാരം ന പ്രാപ്നോതി| ");
INSERT INTO sanmal_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","അപരഞ്ച യഥാർഥം വച്മി, ഏലിയസ്യ ജീവനകാലേ യദാ സാർദ്ധത്രിതയവർഷാണി യാവത് ജലദപ്രതിബന്ധാത് സർവ്വസ്മിൻ ദേശേ മഹാദുർഭിക്ഷമ് അജനിഷ്ട തദാനീമ് ഇസ്രായേലോ ദേശസ്യ മധ്യേ ബഹ്വ്യോ വിധവാ ആസൻ, ");
INSERT INTO sanmal_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","കിന്തു സീദോൻപ്രദേശീയസാരിഫത്പുരനിവാസിനീമ് ഏകാം വിധവാം വിനാ കസ്യാശ്ചിദപി സമീപേ ഏലിയഃ പ്രേരിതോ നാഭൂത്| ");
INSERT INTO sanmal_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","അപരഞ്ച ഇലീശായഭവിഷ്യദ്വാദിവിദ്യമാനതാകാലേ ഇസ്രായേൽദേശേ ബഹവഃ കുഷ്ഠിന ആസൻ കിന്തു സുരീയദേശീയം നാമാൻകുഷ്ഠിനം വിനാ കോപ്യന്യഃ പരിഷ്കൃതോ നാഭൂത്| ");
INSERT INTO sanmal_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ഇമാം കഥാം ശ്രുത്വാ ഭജനഗേഹസ്ഥിതാ ലോകാഃ സക്രോധമ് ഉത്ഥായ ");
INSERT INTO sanmal_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","നഗരാത്തം ബഹിഷ്കൃത്യ യസ്യ ശിഖരിണ ഉപരി തേഷാം നഗരം സ്ഥാപിതമാസ്തേ തസ്മാന്നിക്ഷേപ്തും തസ്യ ശിഖരം തം നിന്യുഃ ");
INSERT INTO sanmal_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","കിന്തു സ തേഷാം മധ്യാദപസൃത്യ സ്ഥാനാന്തരം ജഗാമ| ");
INSERT INTO sanmal_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","തതഃ പരം യീശുർഗാലീൽപ്രദേശീയകഫർനാഹൂമ്നഗര ഉപസ്ഥായ വിശ്രാമവാരേ ലോകാനുപദേഷ്ടുമ് ആരബ്ധവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","തദുപദേശാത് സർവ്വേ ചമച്ചക്രു ര്യതസ്തസ്യ കഥാ ഗുരുതരാ ആസൻ| ");
INSERT INTO sanmal_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","തദാനീം തദ്ഭജനഗേഹസ്ഥിതോഽമേധ്യഭൂതഗ്രസ്ത ഏകോ ജന ഉച്ചൈഃ കഥയാമാസ, ");
INSERT INTO sanmal_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","ഹേ നാസരതീയയീശോഽസ്മാൻ ത്യജ, ത്വയാ സഹാസ്മാകം കഃ സമ്ബന്ധഃ? കിമസ്മാൻ വിനാശയിതുമായാസി? ത്വമീശ്വരസ്യ പവിത്രോ ജന ഏതദഹം ജാനാമി| ");
INSERT INTO sanmal_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","തദാ യീശുസ്തം തർജയിത്വാവദത് മൗനീ ഭവ ഇതോ ബഹിർഭവ; തതഃ സോമേധ്യഭൂതസ്തം മധ്യസ്ഥാനേ പാതയിത്വാ കിഞ്ചിദപ്യഹിംസിത്വാ തസ്മാദ് ബഹിർഗതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","തതഃ സർവ്വേ ലോകാശ്ചമത്കൃത്യ പരസ്പരം വക്തുമാരേഭിരേ കോയം ചമത്കാരഃ| ഏഷ പ്രഭാവേണ പരാക്രമേണ ചാമേധ്യഭൂതാൻ ആജ്ഞാപയതി തേനൈവ തേ ബഹിർഗച്ഛന്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","അനന്തരം ചതുർദിക്സ്ഥദേശാൻ തസ്യ സുഖ്യാതിർവ്യാപ്നോത്| ");
INSERT INTO sanmal_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","തദനന്തരം സ ഭജനഗേഹാദ് ബഹിരാഗത്യ ശിമോനോ നിവേശനം പ്രവിവേശ തദാ തസ്യ ശ്വശ്രൂർജ്വരേണാത്യന്തം പീഡിതാസീത് ശിഷ്യാസ്തദർഥം തസ്മിൻ വിനയം ചക്രുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","തതഃ സ തസ്യാഃ സമീപേ സ്ഥിത്വാ ജ്വരം തർജയാമാസ തേനൈവ താം ജ്വരോഽത്യാക്ഷീത് തതഃ സാ തത്ക്ഷണമ് ഉത്ഥായ താൻ സിഷേവേ| ");
INSERT INTO sanmal_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","അഥ സൂര്യ്യാസ്തകാലേ സ്വേഷാം യേ യേ ജനാ നാനാരോഗൈഃ പീഡിതാ ആസൻ ലോകാസ്താൻ യീശോഃ സമീപമ് ആനിന്യുഃ, തദാ സ ഏകൈകസ്യ ഗാത്രേ കരമർപയിത്വാ താനരോഗാൻ ചകാര| ");
INSERT INTO sanmal_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","തതോ ഭൂതാ ബഹുഭ്യോ നിർഗത്യ ചീത്ശബ്ദം കൃത്വാ ച ബഭാഷിരേ ത്വമീശ്വരസ്യ പുത്രോഽഭിഷിക്തത്രാതാ; കിന്തു സോഭിഷിക്തത്രാതേതി തേ വിവിദുരേതസ്മാത് കാരണാത് താൻ തർജയിത്വാ തദ്വക്തും നിഷിഷേധ| ");
INSERT INTO sanmal_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","അപരഞ്ച പ്രഭാതേ സതി സ വിജനസ്ഥാനം പ്രതസ്ഥേ പശ്ചാത് ജനാസ്തമന്വിച്ഛന്തസ്തന്നികടം ഗത്വാ സ്ഥാനാന്തരഗമനാർഥം തമന്വരുന്ധൻ| ");
INSERT INTO sanmal_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","കിന്തു സ താൻ ജഗാദ, ഈശ്വരീയരാജ്യസ്യ സുസംവാദം പ്രചാരയിതുമ് അന്യാനി പുരാണ്യപി മയാ യാതവ്യാനി യതസ്തദർഥമേവ പ്രേരിതോഹം| ");
INSERT INTO sanmal_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","അഥ ഗാലീലോ ഭജനഗേഹേഷു സ ഉപദിദേശ| ");
INSERT INTO sanmal_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","അനന്തരം യീശുരേകദാ ഗിനേഷരഥ്ദസ്യ തീര ഉത്തിഷ്ഠതി, തദാ ലോകാ ഈശ്വരീയകഥാം ശ്രോതും തദുപരി പ്രപതിതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","തദാനീം സ ഹ്ദസ്യ തീരസമീപേ നൗദ്വയം ദദർശ കിഞ്ച മത്സ്യോപജീവിനോ നാവം വിഹായ ജാലം പ്രക്ഷാലയന്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","തതസ്തയോർദ്വയോ ർമധ്യേ ശിമോനോ നാവമാരുഹ്യ തീരാത് കിഞ്ചിദ്ദൂരം യാതും തസ്മിൻ വിനയം കൃത്വാ നൗകായാമുപവിശ്യ ലോകാൻ പ്രോപദിഷ്ടവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","പശ്ചാത് തം പ്രസ്താവം സമാപ്യ സ ശിമോനം വ്യാജഹാര, ഗഭീരം ജലം ഗത്വാ മത്സ്യാൻ ധർത്തും ജാലം നിക്ഷിപ| ");
INSERT INTO sanmal_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","തതഃ ശിമോന ബഭാഷേ, ഹേ ഗുരോ യദ്യപി വയം കൃത്സ്നാം യാമിനീം പരിശ്രമ്യ മത്സ്യൈകമപി ന പ്രാപ്താസ്തഥാപി ഭവതോ നിദേശതോ ജാലം ക്ഷിപാമഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","അഥ ജാലേ ക്ഷിപ്തേ ബഹുമത്സ്യപതനാദ് ആനായഃ പ്രച്ഛിന്നഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","തസ്മാദ് ഉപകർത്തുമ് അന്യനൗസ്ഥാൻ സങ്ഗിന ആയാതുമ് ഇങ്ഗിതേന സമാഹ്വയൻ തതസ്ത ആഗത്യ മത്സ്യൈ ർനൗദ്വയം പ്രപൂരയാമാസു ര്യൈ ർനൗദ്വയം പ്രമഗ്നമ്| ");
INSERT INTO sanmal_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","തദാ ശിമോൻപിതരസ്തദ് വിലോക്യ യീശോശ്ചരണയോഃ പതിത്വാ, ഹേ പ്രഭോഹം പാപീ നരോ മമ നികടാദ് ഭവാൻ യാതു, ഇതി കഥിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","യതോ ജാലേ പതിതാനാം മത്സ്യാനാം യൂഥാത് ശിമോൻ തത്സങ്ഗിനശ്ച ചമത്കൃതവന്തഃ; ശിമോനഃ സഹകാരിണൗ സിവദേഃ പുത്രൗ യാകൂബ് യോഹൻ ചേമൗ താദൃശൗ ബഭൂവതുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","തദാ യീശുഃ ശിമോനം ജഗാദ മാ ഭൈഷീരദ്യാരഭ്യ ത്വം മനുഷ്യധരോ ഭവിഷ്യസി| ");
INSERT INTO sanmal_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","അനന്തരം സർവ്വാസു നൗസു തീരമ് ആനീതാസു തേ സർവ്വാൻ പരിത്യജ്യ തസ്യ പശ്ചാദ്ഗാമിനോ ബഭൂവുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","തതഃ പരം യീശൗ കസ്മിംശ്ചിത് പുരേ തിഷ്ഠതി ജന ഏകഃ സർവ്വാങ്ഗകുഷ്ഠസ്തം വിലോക്യ തസ്യ സമീപേ ന്യുബ്ജഃ പതിത്വാ സവിനയം വക്തുമാരേഭേ, ഹേ പ്രഭോ യദി ഭവാനിച്ഛതി തർഹി മാം പരിഷ്കർത്തും ശക്നോതി| ");
INSERT INTO sanmal_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","തദാനീം സ പാണിം പ്രസാര്യ്യ തദങ്ഗം സ്പൃശൻ ബഭാഷേ ത്വം പരിഷ്ക്രിയസ്വേതി മമേച്ഛാസ്തി തതസ്തത്ക്ഷണം സ കുഷ്ഠാത് മുക്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","പശ്ചാത് സ തമാജ്ഞാപയാമാസ കഥാമിമാം കസ്മൈചിദ് അകഥയിത്വാ യാജകസ്യ സമീപഞ്ച ഗത്വാ സ്വം ദർശയ, ലോകേഭ്യോ നിജപരിഷ്കൃതത്വസ്യ പ്രമാണദാനായ മൂസാജ്ഞാനുസാരേണ ദ്രവ്യമുത്മൃജസ്വ ച| ");
INSERT INTO sanmal_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","തഥാപി യീശോഃ സുഖ്യാതി ർബഹു വ്യാപ്തുമാരേഭേ കിഞ്ച തസ്യ കഥാം ശ്രോതും സ്വീയരോഗേഭ്യോ മോക്തുഞ്ച ലോകാ ആജഗ്മുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","അഥ സ പ്രാന്തരം ഗത്വാ പ്രാർഥയാഞ്ചക്രേ| ");
INSERT INTO sanmal_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","അപരഞ്ച ഏകദാ യീശുരുപദിശതി, ഏതർഹി ഗാലീല്യിഹൂദാപ്രദേശയോഃ സർവ്വനഗരേഭ്യോ യിരൂശാലമശ്ച കിയന്തഃ ഫിരൂശിലോകാ വ്യവസ്ഥാപകാശ്ച സമാഗത്യ തദന്തികേ സമുപവിവിശുഃ, തസ്മിൻ കാലേ ലോകാനാമാരോഗ്യകാരണാത് പ്രഭോഃ പ്രഭാവഃ പ്രചകാശേ| ");
INSERT INTO sanmal_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","പശ്ചാത് കിയന്തോ ലോകാ ഏകം പക്ഷാഘാതിനം ഖട്വായാം നിധായ യീശോഃ സമീപമാനേതും സമ്മുഖേ സ്ഥാപയിതുഞ്ച വ്യാപ്രിയന്ത| ");
INSERT INTO sanmal_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","കിന്തു ബഹുജനനിവഹസമ്വാധാത് ന ശക്നുവന്തോ ഗൃഹോപരി ഗത്വാ ഗൃഹപൃഷ്ഠം ഖനിത്വാ തം പക്ഷാഘാതിനം സഖട്വം ഗൃഹമധ്യേ യീശോഃ സമ്മുഖേ ഽവരോഹയാമാസുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","തദാ യീശുസ്തേഷാമ് ഈദൃശം വിശ്വാസം വിലോക്യ തം പക്ഷാഘാതിനം വ്യാജഹാര, ഹേ മാനവ തവ പാപമക്ഷമ്യത| ");
INSERT INTO sanmal_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","തസ്മാദ് അധ്യാപകാഃ ഫിരൂശിനശ്ച ചിത്തൈരിത്ഥം പ്രചിന്തിതവന്തഃ, ഏഷ ജന ഈശ്വരം നിന്ദതി കോയം? കേവലമീശ്വരം വിനാ പാപം ക്ഷന്തും കഃ ശക്നോതി? ");
INSERT INTO sanmal_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","തദാ യീശുസ്തേഷാമ് ഇത്ഥം ചിന്തനം വിദിത്വാ തേഭ്യോകഥയദ് യൂയം മനോഭിഃ കുതോ വിതർകയഥ? ");
INSERT INTO sanmal_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","തവ പാപക്ഷമാ ജാതാ യദ്വാ ത്വമുത്ഥായ വ്രജ ഏതയോ ർമധ്യേ കാ കഥാ സുകഥ്യാ? ");
INSERT INTO sanmal_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","കിന്തു പൃഥിവ്യാം പാപം ക്ഷന്തും മാനവസുതസ്യ സാമർഥ്യമസ്തീതി യഥാ യൂയം ജ്ഞാതും ശക്നുഥ തദർഥം (സ തം പക്ഷാഘാതിനം ജഗാദ) ഉത്തിഷ്ഠ സ്വശയ്യാം ഗൃഹീത്വാ ഗൃഹം യാഹീതി ത്വാമാദിശാമി| ");
INSERT INTO sanmal_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","തസ്മാത് സ തത്ക്ഷണമ് ഉത്ഥായ സർവ്വേഷാം സാക്ഷാത് നിജശയനീയം ഗൃഹീത്വാ ഈശ്വരം ധന്യം വദൻ നിജനിവേശനം യയൗ| ");
INSERT INTO sanmal_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","തസ്മാത് സർവ്വേ വിസ്മയ പ്രാപ്താ മനഃസു ഭീതാശ്ച വയമദ്യാസമ്ഭവകാര്യ്യാണ്യദർശാമ ഇത്യുക്ത്വാ പരമേശ്വരം ധന്യം പ്രോദിതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","തതഃ പരം ബഹിർഗച്ഛൻ കരസഞ്ചയസ്ഥാനേ ലേവിനാമാനം കരസഞ്ചായകം ദൃഷ്ട്വാ യീശുസ്തമഭിദധേ മമ പശ്ചാദേഹി| ");
INSERT INTO sanmal_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","തസ്മാത് സ തത്ക്ഷണാത് സർവ്വം പരിത്യജ്യ തസ്യ പശ്ചാദിയായ| ");
INSERT INTO sanmal_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","അനന്തരം ലേവി ർനിജഗൃഹേ തദർഥം മഹാഭോജ്യം ചകാര, തദാ തൈഃ സഹാനേകേ കരസഞ്ചായിനസ്തദന്യലോകാശ്ച ഭോക്തുമുപവിവിശുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","തസ്മാത് കാരണാത് ചണ്ഡാലാനാം പാപിലോകാനാഞ്ച സങ്ഗേ യൂയം കുതോ ഭംഗ്ധ്വേ പിവഥ ചേതി കഥാം കഥയിത്വാ ഫിരൂശിനോഽധ്യാപകാശ്ച തസ്യ ശിഷ്യൈഃ സഹ വാഗ്യുദ്ധം കർത്തുമാരേഭിരേ| ");
INSERT INTO sanmal_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","തസ്മാദ് യീശുസ്താൻ പ്രത്യവോചദ് അരോഗലോകാനാം ചികിത്സകേന പ്രയോജനം നാസ്തി കിന്തു സരോഗാണാമേവ| ");
INSERT INTO sanmal_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","അഹം ധാർമ്മികാൻ ആഹ്വാതും നാഗതോസ്മി കിന്തു മനഃ പരാവർത്തയിതും പാപിന ഏവ| ");
INSERT INTO sanmal_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","തതസ്തേ പ്രോചുഃ, യോഹനഃ ഫിരൂശിനാഞ്ച ശിഷ്യാ വാരംവാരമ് ഉപവസന്തി പ്രാർഥയന്തേ ച കിന്തു തവ ശിഷ്യാഃ കുതോ ഭുഞ്ജതേ പിവന്തി ച? ");
INSERT INTO sanmal_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","തദാ സ താനാചഖ്യൗ വരേ സങ്ഗേ തിഷ്ഠതി വരസ്യ സഖിഗണം കിമുപവാസയിതും ശക്നുഥ? ");
INSERT INTO sanmal_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","കിന്തു യദാ തേഷാം നികടാദ് വരോ നേഷ്യതേ തദാ തേ സമുപവത്സ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","സോപരമപി ദൃഷ്ടാന്തം കഥയാമ്ബഭൂവ പുരാതനവസ്ത്രേ കോപി നുതനവസ്ത്രം ന സീവ്യതി യതസ്തേന സേവനേന ജീർണവസ്ത്രം ഛിദ്യതേ, നൂതനപുരാതനവസ്ത്രയോ ർമേലഞ്ച ന ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","പുരാതന്യാം കുത്വാം കോപി നുതനം ദ്രാക്ഷാരസം ന നിദധാതി, യതോ നവീനദ്രാക്ഷാരസസ്യ തേജസാ പുരാതനീ കുതൂ ർവിദീര്യ്യതേ തതോ ദ്രാക്ഷാരസഃ പതതി കുതൂശ്ച നശ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","തതോ ഹേതോ ർനൂതന്യാം കുത്വാം നവീനദ്രാക്ഷാരസഃ നിധാതവ്യസ്തേനോഭയസ്യ രക്ഷാ ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","അപരഞ്ച പുരാതനം ദ്രാക്ഷാരസം പീത്വാ കോപി നൂതനം ന വാഞ്ഛതി, യതഃ സ വക്തി നൂതനാത് പുരാതനമ് പ്രശസ്തമ്| ");
INSERT INTO sanmal_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","അചരഞ്ച പർവ്വണോ ദ്വിതീയദിനാത് പരം പ്രഥമവിശ്രാമവാരേ ശസ്യക്ഷേത്രേണ യീശോർഗമനകാലേ തസ്യ ശിഷ്യാഃ കണിശം ഛിത്ത്വാ കരേഷു മർദ്ദയിത്വാ ഖാദിതുമാരേഭിരേ| ");
INSERT INTO sanmal_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","തസ്മാത് കിയന്തഃ ഫിരൂശിനസ്താനവദൻ വിശ്രാമവാരേ യത് കർമ്മ ന കർത്തവ്യം തത് കുതഃ കുരുഥ? ");
INSERT INTO sanmal_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","യീശുഃ പ്രത്യുവാച ദായൂദ് തസ്യ സങ്ഗിനശ്ച ക്ഷുധാർത്താഃ കിം ചക്രുഃ സ കഥമ് ഈശ്വരസ്യ മന്ദിരം പ്രവിശ്യ ");
INSERT INTO sanmal_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","യേ ദർശനീയാഃ പൂപാ യാജകാൻ വിനാന്യസ്യ കസ്യാപ്യഭോജനീയാസ്താനാനീയ സ്വയം ബുഭജേ സങ്ഗിഭ്യോപി ദദൗ തത് കിം യുഷ്മാഭിഃ കദാപി നാപാഠി? ");
INSERT INTO sanmal_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","പശ്ചാത് സ താനവദത് മനുജസുതോ വിശ്രാമവാരസ്യാപി പ്രഭു ർഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","അനന്തരമ് അന്യവിശ്രാമവാരേ സ ഭജനഗേഹം പ്രവിശ്യ സമുപദിശതി| തദാ തത്സ്ഥാനേ ശുഷ്കദക്ഷിണകര ഏകഃ പുമാൻ ഉപതസ്ഥിവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","തസ്മാദ് അധ്യാപകാഃ ഫിരൂശിനശ്ച തസ്മിൻ ദോഷമാരോപയിതും സ വിശ്രാമവാരേ തസ്യ സ്വാസ്ഥ്യം കരോതി നവേതി പ്രതീക്ഷിതുമാരേഭിരേ| ");
INSERT INTO sanmal_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","തദാ യീശുസ്തേഷാം ചിന്താം വിദിത്വാ തം ശുഷ്കകരം പുമാംസം പ്രോവാച, ത്വമുത്ഥായ മധ്യസ്ഥാനേ തിഷ്ഠ| ");
INSERT INTO sanmal_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","തസ്മാത് തസ്മിൻ ഉത്ഥിതവതി യീശുസ്താൻ വ്യാജഹാര, യുഷ്മാൻ ഇമാം കഥാം പൃച്ഛാമി, വിശ്രാമവാരേ ഹിതമ് അഹിതം വാ, പ്രാണരക്ഷണം പ്രാണനാശനം വാ, ഏതേഷാം കിം കർമ്മകരണീയമ്? ");
INSERT INTO sanmal_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","പശ്ചാത് ചതുർദിക്ഷു സർവ്വാൻ വിലോക്യ തം മാനവം ബഭാഷേ, നിജകരം പ്രസാരയ; തതസ്തേന തഥാ കൃത ഇതരകരവത് തസ്യ ഹസ്തഃ സ്വസ്ഥോഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","തസ്മാത് തേ പ്രചണ്ഡകോപാന്വിതാ യീശും കിം കരിഷ്യന്തീതി പരസ്പരം പ്രമന്ത്രിതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","തതഃ പരം സ പർവ്വതമാരുഹ്യേശ്വരമുദ്ദിശ്യ പ്രാർഥയമാനഃ കൃത്സ്നാം രാത്രിം യാപിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","അഥ ദിനേ സതി സ സർവ്വാൻ ശിഷ്യാൻ ആഹൂതവാൻ തേഷാം മധ്യേ ");
INSERT INTO sanmal_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","പിതരനാമ്നാ ഖ്യാതഃ ശിമോൻ തസ്യ ഭ്രാതാ ആന്ദ്രിയശ്ച യാകൂബ് യോഹൻ ച ഫിലിപ് ബർഥലമയശ്ച ");
INSERT INTO sanmal_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","മഥിഃ ഥോമാ ആൽഫീയസ്യ പുത്രോ യാകൂബ് ജ്വലന്തനാമ്നാ ഖ്യാതഃ ശിമോൻ ");
INSERT INTO sanmal_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ച യാകൂബോ ഭ്രാതാ യിഹൂദാശ്ച തം യഃ പരകരേഷു സമർപയിഷ്യതി സ ഈഷ്കരീയോതീയയിഹൂദാശ്ചൈതാൻ ദ്വാദശ ജനാൻ മനോനീതാൻ കൃത്വാ സ ജഗ്രാഹ തഥാ പ്രേരിത ഇതി തേഷാം നാമ ചകാര| ");
INSERT INTO sanmal_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","തതഃ പരം സ തൈഃ സഹ പർവ്വതാദവരുഹ്യ ഉപത്യകായാം തസ്ഥൗ തതസ്തസ്യ ശിഷ്യസങ്ഘോ യിഹൂദാദേശാദ് യിരൂശാലമശ്ച സോരഃ സീദോനശ്ച ജലധേ രോധസോ ജനനിഹാശ്ച ഏത്യ തസ്യ കഥാശ്രവണാർഥം രോഗമുക്ത്യർഥഞ്ച തസ്യ സമീപേ തസ്ഥുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","അമേധ്യഭൂതഗ്രസ്താശ്ച തന്നികടമാഗത്യ സ്വാസ്ഥ്യം പ്രാപുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","സർവ്വേഷാം സ്വാസ്ഥ്യകരണപ്രഭാവസ്യ പ്രകാശിതത്വാത് സർവ്വേ ലോകാ ഏത്യ തം സ്പ്രഷ്ടും യേതിരേ| ");
INSERT INTO sanmal_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","പശ്ചാത് സ ശിഷ്യാൻ പ്രതി ദൃഷ്ടിം കുത്വാ ജഗാദ, ഹേ ദരിദ്രാ യൂയം ധന്യാ യത ഈശ്വരീയേ രാജ്യേ വോഽധികാരോസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ഹേ അധുനാ ക്ഷുധിതലോകാ യൂയം ധന്യാ യതോ യൂയം തർപ്സ്യഥ; ഹേ ഇഹ രോദിനോ ജനാ യൂയം ധന്യാ യതോ യൂയം ഹസിഷ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","യദാ ലോകാ മനുഷ്യസൂനോ ർനാമഹേതോ ര്യുഷ്മാൻ ഋृതീയിഷ്യന്തേ പൃഥക് കൃത്വാ നിന്ദിഷ്യന്തി, അധമാനിവ യുഷ്മാൻ സ്വസമീപാദ് ദൂരീകരിഷ്യന്തി ച തദാ യൂയം ധന്യാഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","സ്വർഗേ യുഷ്മാകം യഥേഷ്ടം ഫലം ഭവിഷ്യതി, ഏതദർഥം തസ്മിൻ ദിനേ പ്രോല്ലസത ആനന്ദേന നൃത്യത ച, തേഷാം പൂർവ്വപുരുഷാശ്ച ഭവിഷ്യദ്വാദിനഃ പ്രതി തഥൈവ വ്യവാഹരൻ| ");
INSERT INTO sanmal_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","കിന്തു ഹാ ഹാ ധനവന്തോ യൂയം സുഖം പ്രാപ്നുത| ഹന്ത പരിതൃപ്താ യൂയം ക്ഷുധിതാ ഭവിഷ്യഥ; ");
INSERT INTO sanmal_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ഇഹ ഹസന്തോ യൂയം വത യുഷ്മാഭിഃ ശോചിതവ്യം രോദിതവ്യഞ്ച| ");
INSERT INTO sanmal_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","സർവ്വൈലാകൈ ര്യുഷ്മാകം സുഖ്യാതൗ കൃതായാം യുഷ്മാകം ദുർഗതി ർഭവിഷ്യതി യുഷ്മാകം പൂർവ്വപുരുഷാ മൃഷാഭവിഷ്യദ്വാദിനഃ പ്രതി തദ്വത് കൃതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","ഹേ ശ്രോതാരോ യുഷ്മഭ്യമഹം കഥയാമി, യൂയം ശത്രുഷു പ്രീയധ്വം യേ ച യുഷ്മാൻ ദ്വിഷന്തി തേഷാമപി ഹിതം കുരുത| ");
INSERT INTO sanmal_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","യേ ച യുഷ്മാൻ ശപന്തി തേഭ്യ ആശിഷം ദത്ത യേ ച യുഷ്മാൻ അവമന്യന്തേ തേഷാം മങ്ഗലം പ്രാർഥയധ്വം| ");
INSERT INTO sanmal_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","യദി കശ്ചിത് തവ കപോലേ ചപേടാഘാതം കരോതി തർഹി തം പ്രതി കപോലമ് അന്യം പരാവർത്ത്യ സമ്മുഖീകുരു പുനശ്ച യദി കശ്ചിത് തവ ഗാത്രീയവസ്ത്രം ഹരതി തർഹി തം പരിധേയവസ്ത്രമ് അപി ഗ്രഹീതും മാ വാരയ| ");
INSERT INTO sanmal_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","യസ്ത്വാം യാചതേ തസ്മൈ ദേഹി, യശ്ച തവ സമ്പത്തിം ഹരതി തം മാ യാചസ്വ| ");
INSERT INTO sanmal_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","പരേഭ്യഃ സ്വാൻ പ്രതി യഥാചരണമ് അപേക്ഷധ്വേ പരാൻ പ്രതി യൂയമപി തഥാചരത| ");
INSERT INTO sanmal_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","യേ ജനാ യുഷ്മാസു പ്രീയന്തേ കേവലം തേഷു പ്രീയമാണേഷു യുഷ്മാകം കിം ഫലം? പാപിലോകാ അപി സ്വേഷു പ്രീയമാണേഷു പ്രീയന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","യദി ഹിതകാരിണ ഏവ ഹിതം കുരുഥ തർഹി യുഷ്മാകം കിം ഫലം? പാപിലോകാ അപി തഥാ കുർവ്വന്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","യേഭ്യ ഋണപരിശോധസ്യ പ്രാപ്തിപ്രത്യാശാസ്തേ കേവലം തേഷു ഋണേ സമർപിതേ യുഷ്മാകം കിം ഫലം? പുനഃ പ്രാപ്ത്യാശയാ പാപീലോകാ അപി പാപിജനേഷു ഋണമ് അർപയന്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","അതോ യൂയം രിപുഷ്വപി പ്രീയധ്വം, പരഹിതം കുരുത ച; പുനഃ പ്രാപ്ത്യാശാം ത്യക്ത്വാ ഋണമർപയത, തഥാ കൃതേ യുഷ്മാകം മഹാഫലം ഭവിഷ്യതി, യൂയഞ്ച സർവ്വപ്രധാനസ്യ സന്താനാ ഇതി ഖ്യാതിം പ്രാപ്സ്യഥ, യതോ യുഷ്മാകം പിതാ കൃതഘ്നാനാം ദുർവ്ടത്താനാഞ്ച ഹിതമാചരതി| ");
INSERT INTO sanmal_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","അത ഏവ സ യഥാ ദയാലു ര്യൂയമപി താദൃശാ ദയാലവോ ഭവത| ");
INSERT INTO sanmal_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","അപരഞ്ച പരാൻ ദോഷിണോ മാ കുരുത തസ്മാദ് യൂയം ദോഷീകൃതാ ന ഭവിഷ്യഥ; അദണ്ഡ്യാൻ മാ ദണ്ഡയത തസ്മാദ് യൂയമപി ദണ്ഡം ന പ്രാപ്സ്യഥ; പരേഷാം ദോഷാൻ ക്ഷമധ്വം തസ്മാദ് യുഷ്മാകമപി ദോഷാഃ ക്ഷമിഷ്യന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","ദാനാനിദത്ത തസ്മാദ് യൂയം ദാനാനി പ്രാപ്സ്യഥ, വരഞ്ച ലോകാഃ പരിമാണപാത്രം പ്രദലയ്യ സഞ്ചാല്യ പ്രോഞ്ചാല്യ പരിപൂര്യ്യ യുഷ്മാകം ക്രോഡേഷു സമർപയിഷ്യന്തി; യൂയം യേന പരിമാണേന പരിമാഥ തേനൈവ പരിമാണേന യുഷ്മത്കൃതേ പരിമാസ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","അഥ സ തേഭ്യോ ദൃഷ്ടാന്തകഥാമകഥയത്, അന്ധോ ജനഃ കിമന്ധം പന്ഥാനം ദർശയിതും ശക്നോതി? തസ്മാദ് ഉഭാവപി കിം ഗർത്തേ ന പതിഷ്യതഃ? ");
INSERT INTO sanmal_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ഗുരോഃ ശിഷ്യോ ന ശ്രേഷ്ഠഃ കിന്തു ശിഷ്യേ സിദ്ധേ സതി സ ഗുരുതുല്യോ ഭവിതും ശക്നോതി| ");
INSERT INTO sanmal_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","അപരഞ്ച ത്വം സ്വചക്ഷുुഷി നാസാമ് അദൃഷ്ട്വാ തവ ഭ്രാതുശ്ചക്ഷുഷി യത്തൃണമസ്തി തദേവ കുതഃ പശ്യമി? ");
INSERT INTO sanmal_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","സ്വചക്ഷുഷി യാ നാസാ വിദ്യതേ താമ് അജ്ഞാത്വാ, ഭ്രാതസ്തവ നേത്രാത് തൃണം ബഹിഃ കരോമീതി വാക്യം ഭ്രാതരം കഥം വക്തും ശക്നോഷി? ഹേ കപടിൻ പൂർവ്വം സ്വനയനാത് നാസാം ബഹിഃ കുരു തതോ ഭ്രാതുശ്ചക്ഷുഷസ്തൃണം ബഹിഃ കർത്തും സുദൃഷ്ടിം പ്രാപ്സ്യസി| ");
INSERT INTO sanmal_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","അന്യഞ്ച ഉത്തമസ്തരുഃ കദാപി ഫലമനുത്തമം ന ഫലതി, അനുത്തമതരുശ്ച ഫലമുത്തമം ന ഫലതി കാരണാദതഃ ഫലൈസ്തരവോ ജ്ഞായന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","കണ്ടകിപാദപാത് കോപി ഉഡുമ്ബരഫലാനി ന പാതയതി തഥാ ശൃഗാലകോലിവൃക്ഷാദപി കോപി ദ്രാക്ഷാഫലം ന പാതയതി| ");
INSERT INTO sanmal_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","തദ്വത് സാധുലോകോഽന്തഃകരണരൂപാത് സുഭാണ്ഡാഗാരാദ് ഉത്തമാനി ദ്രവ്യാണി ബഹിഃ കരോതി, ദുഷ്ടോ ലോകശ്ചാന്തഃകരണരൂപാത് കുഭാണ്ഡാഗാരാത് കുത്സിതാനി ദ്രവ്യാണി നിർഗമയതി യതോഽന്തഃകരണാനാം പൂർണഭാവാനുരൂപാണി വചാംസി മുഖാന്നിർഗച്ഛന്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","അപരഞ്ച മമാജ്ഞാനുരൂപം നാചരിത്വാ കുതോ മാം പ്രഭോ പ്രഭോ ഇതി വദഥ? ");
INSERT INTO sanmal_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","യഃ കശ്ചിൻ മമ നികടമ് ആഗത്യ മമ കഥാ നിശമ്യ തദനുരൂപം കർമ്മ കരോതി സ കസ്യ സദൃശോ ഭവതി തദഹം യുഷ്മാൻ ജ്ഞാाപയാമി| ");
INSERT INTO sanmal_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","യോ ജനോ ഗഭീരം ഖനിത്വാ പാഷാണസ്ഥലേ ഭിത്തിം നിർമ്മായ സ്വഗൃഹം രചയതി തേന സഹ തസ്യോപമാ ഭവതി; യത ആപ്ലാവിജലമേത്യ തസ്യ മൂലേ വേഗേന വഹദപി തദ്ഗേഹം ലാഡയിതും ന ശക്നോതി യതസ്തസ്യ ഭിത്തിഃ പാഷാണോപരി തിഷ്ഠതി| ");
INSERT INTO sanmal_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","കിന്തു യഃ കശ്ചിൻ മമ കഥാഃ ശ്രുത്വാ തദനുരൂപം നാചരതി സ ഭിത്തിം വിനാ മൃृദുപരി ഗൃഹനിർമ്മാത്രാ സമാനോ ഭവതി; യത ആപ്ലാവിജലമാഗത്യ വേഗേന യദാ വഹതി തദാ തദ്ഗൃഹം പതതി തസ്യ മഹത് പതനം ജായതേ| ");
INSERT INTO sanmal_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","തതഃ പരം സ ലോകാനാം കർണഗോചരേ താൻ സർവ്വാൻ ഉപദേശാൻ സമാപ്യ യദാ കഫർനാഹൂമ്പുരം പ്രവിശതി ");
INSERT INTO sanmal_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","തദാ ശതസേനാപതേഃ പ്രിയദാസ ഏകോ മൃതകൽപഃ പീഡിത ആസീത്| ");
INSERT INTO sanmal_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","അതഃ സേനാപതി ര്യീശോ ർവാർത്താം നിശമ്യ ദാസസ്യാരോഗ്യകരണായ തസ്യാഗമനാർഥം വിനയകരണായ യിഹൂദീയാൻ കിയതഃ പ്രാചഃ പ്രേഷയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","തേ യീശോരന്തികം ഗത്വാ വിനയാതിശയം വക്തുമാരേഭിരേ, സ സേനാപതി ർഭവതോനുഗ്രഹം പ്രാപ്തുമ് അർഹതി| ");
INSERT INTO sanmal_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","യതഃ സോസ്മജ്ജാതീയേഷു ലോകേഷു പ്രീയതേ തഥാസ്മത്കൃതേ ഭജനഗേഹം നിർമ്മിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","തസ്മാദ് യീശുസ്തൈഃ സഹ ഗത്വാ നിവേശനസ്യ സമീപം പ്രാപ, തദാ സ ശതസേനാപതി ർവക്ഷ്യമാണവാക്യം തം വക്തും ബന്ധൂൻ പ്രാഹിണോത്| ഹേ പ്രഭോ സ്വയം ശ്രമോ ന കർത്തവ്യോ യദ് ഭവതാ മദ്ഗേഹമധ്യേ പാദാർപണം ക്രിയേത തദപ്യഹം നാർഹാമി, ");
INSERT INTO sanmal_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","കിഞ്ചാഹം ഭവത്സമീപം യാതുമപി നാത്മാനം യോഗ്യം ബുദ്ധവാൻ, തതോ ഭവാൻ വാക്യമാത്രം വദതു തേനൈവ മമ ദാസഃ സ്വസ്ഥോ ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","യസ്മാദ് അഹം പരാധീനോപി മമാധീനാ യാഃ സേനാഃ സന്തി താസാമ് ഏകജനം പ്രതി യാഹീതി മയാ പ്രോക്തേ സ യാതി; തദന്യം പ്രതി ആയാഹീതി പ്രോക്തേ സ ആയാതി; തഥാ നിജദാസം പ്രതി ഏതത് കുർവ്വിതി പ്രോക്തേ സ തദേവ കരോതി| ");
INSERT INTO sanmal_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","യീശുരിദം വാക്യം ശ്രുത്വാ വിസ്മയം യയൗ, മുഖം പരാവർത്യ പശ്ചാദ്വർത്തിനോ ലോകാൻ ബഭാഷേ ച, യുഷ്മാനഹം വദാമി ഇസ്രായേലോ വംശമധ്യേപി വിശ്വാസമീദൃശം ന പ്രാപ്നവം| ");
INSERT INTO sanmal_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","തതസ്തേ പ്രേഷിതാ ഗൃഹം ഗത്വാ തം പീഡിതം ദാസം സ്വസ്ഥം ദദൃശുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","പരേഽഹനി സ നായീനാഖ്യം നഗരം ജഗാമ തസ്യാനേകേ ശിഷ്യാ അന്യേ ച ലോകാസ്തേന സാർദ്ധം യയുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","തേഷു തന്നഗരസ്യ ദ്വാരസന്നിധിം പ്രാപ്തേഷു കിയന്തോ ലോകാ ഏകം മൃതമനുജം വഹന്തോ നഗരസ്യ ബഹിര്യാന്തി, സ തന്മാതുരേകപുത്രസ്തന്മാതാ ച വിധവാ; തയാ സാർദ്ധം തന്നഗരീയാ ബഹവോ ലോകാ ആസൻ| ");
INSERT INTO sanmal_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","പ്രഭുസ്താം വിലോക്യ സാനുകമ്പഃ കഥയാമാസ, മാ രോദീഃ| സ സമീപമിത്വാ ഖട്വാം പസ്പർശ തസ്മാദ് വാഹകാഃ സ്ഥഗിതാസ്തമ്യുഃ; ");
INSERT INTO sanmal_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","തദാ സ ഉവാച ഹേ യുവമനുഷ്യ ത്വമുത്തിഷ്ഠ, ത്വാമഹമ് ആജ്ഞാപയാമി| ");
INSERT INTO sanmal_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","തസ്മാത് സ മൃതോ ജനസ്തത്ക്ഷണമുത്ഥായ കഥാം പ്രകഥിതഃ; തതോ യീശുസ്തസ്യ മാതരി തം സമർപയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","തസ്മാത് സർവ്വേ ലോകാഃ ശശങ്കിരേ; ഏകോ മഹാഭവിഷ്യദ്വാദീ മധ്യേഽസ്മാകമ് സമുദൈത്, ഈശ്വരശ്ച സ്വലോകാനന്വഗൃഹ്ലാത് കഥാമിമാം കഥയിത്വാ ഈശ്വരം ധന്യം ജഗദുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","തതഃ പരം സമസ്തം യിഹൂദാദേശം തസ്യ ചതുർദിക്സ്ഥദേശഞ്ച തസ്യൈതത്കീർത്തി ർവ്യാനശേ| ");
INSERT INTO sanmal_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","തതഃ പരം യോഹനഃ ശിഷ്യേഷു തം തദ്വൃത്താന്തം ജ്ഞാപിതവത്സു ");
INSERT INTO sanmal_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","സ സ്വശിഷ്യാണാം ദ്വൗ ജനാവാഹൂയ യീശും പ്രതി വക്ഷ്യമാണം വാക്യം വക്തും പ്രേഷയാമാസ, യസ്യാഗമനമ് അപേക്ഷ്യ തിഷ്ഠാമോ വയം കിം സ ഏവ ജനസ്ത്വം? കിം വയമന്യമപേക്ഷ്യ സ്ഥാസ്യാമഃ? ");
INSERT INTO sanmal_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","പശ്ചാത്തൗ മാനവൗ ഗത്വാ കഥയാമാസതുഃ, യസ്യാഗമനമ് അപേക്ഷ്യ തിഷ്ഠാമോ വയം, കിം സഏവ ജനസ്ത്വം? കിം വയമന്യമപേക്ഷ്യ സ്ഥാസ്യാമഃ? കഥാമിമാം തുഭ്യം കഥയിതും യോഹൻ മജ്ജക ആവാം പ്രേഷിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","തസ്മിൻ ദണ്ഡേ യീശൂരോഗിണോ മഹാവ്യാധിമതോ ദുഷ്ടഭൂതഗ്രസ്താംശ്ച ബഹൂൻ സ്വസ്ഥാൻ കൃത്വാ, അനേകാന്ധേഭ്യശ്ചക്ഷുംഷി ദത്ത്വാ പ്രത്യുവാച, ");
INSERT INTO sanmal_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","യുവാം വ്രജതമ് അന്ധാ നേത്രാണി ഖഞ്ജാശ്ചരണാനി ച പ്രാപ്നുവന്തി, കുഷ്ഠിനഃ പരിഷ്ക്രിയന്തേ, ബധിരാഃ ശ്രവണാനി മൃതാശ്ച ജീവനാനി പ്രാപ്നുവന്തി, ദരിദ്രാണാം സമീപേഷു സുസംവാദഃ പ്രചാര്യ്യതേ, യം പ്രതി വിഘ്നസ്വരൂപോഹം ന ഭവാമി സ ധന്യഃ, ");
INSERT INTO sanmal_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ഏതാനി യാനി പശ്യഥഃ ശൃണുഥശ്ച താനി യോഹനം ജ്ഞാപയതമ്| ");
INSERT INTO sanmal_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","തയോ ർദൂതയോ ർഗതയോഃ സതോ ര്യോഹനി സ ലോകാൻ വക്തുമുപചക്രമേ, യൂയം മധ്യേപ്രാന്തരം കിം ദ്രഷ്ടും നിരഗമത? കിം വായുനാ കമ്പിതം നഡം? ");
INSERT INTO sanmal_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","യൂയം കിം ദ്രഷ്ടും നിരഗമത? കിം സൂക്ഷ്മവസ്ത്രപരിധായിനം കമപി നരം? കിന്തു യേ സൂക്ഷ്മമൃദുവസ്ത്രാണി പരിദധതി സൂത്തമാനി ദ്രവ്യാണി ഭുഞ്ജതേ ച തേ രാജധാനീഷു തിഷ്ഠന്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","തർഹി യൂയം കിം ദ്രഷ്ടും നിരഗമത? കിമേകം ഭവിഷ്യദ്വാദിനം? തദേവ സത്യം കിന്തു സ പുമാൻ ഭവിഷ്യദ്വാദിനോപി ശ്രേഷ്ഠ ഇത്യഹം യുഷ്മാൻ വദാമി; ");
INSERT INTO sanmal_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","പശ്യ സ്വകീയദൂതന്തു തവാഗ്ര പ്രേഷയാമ്യഹം| ഗത്വാ ത്വദീയമാർഗന്തു സ ഹി പരിഷ്കരിഷ്യതി| യദർഥേ ലിപിരിയമ് ആസ്തേ സ ഏവ യോഹൻ| ");
INSERT INTO sanmal_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","അതോ യുഷ്മാനഹം വദാമി സ്ത്രിയാ ഗർബ്ഭജാതാനാം ഭവിഷ്യദ്വാദിനാം മധ്യേ യോഹനോ മജ്ജകാത് ശ്രേഷ്ഠഃ കോപി നാസ്തി, തത്രാപി ഈശ്വരസ്യ രാജ്യേ യഃ സർവ്വസ്മാത് ക്ഷുദ്രഃ സ യോഹനോപി ശ്രേഷ്ഠഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","അപരഞ്ച സർവ്വേ ലോകാഃ കരമഞ്ചായിനശ്ച തസ്യ വാക്യാനി ശ്രുത്വാ യോഹനാ മജ്ജനേന മജ്ജിതാഃ പരമേശ്വരം നിർദോഷം മേനിരേ| ");
INSERT INTO sanmal_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","കിന്തു ഫിരൂശിനോ വ്യവസ്ഥാപകാശ്ച തേന ന മജ്ജിതാഃ സ്വാൻ പ്രതീശ്വരസ്യോപദേശം നിഷ്ഫലമ് അകുർവ്വൻ| ");
INSERT INTO sanmal_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","അഥ പ്രഭുഃ കഥയാമാസ, ഇദാനീന്തനജനാൻ കേനോപമാമി? തേ കസ്യ സദൃശാഃ? ");
INSERT INTO sanmal_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","യേ ബാലകാ വിപണ്യാമ് ഉപവിശ്യ പരസ്പരമ് ആഹൂയ വാക്യമിദം വദന്തി, വയം യുഷ്മാകം നികടേ വംശീരവാദിഷ്മ, കിന്തു യൂയം നാനർത്തിഷ്ട, വയം യുഷ്മാകം നികട അരോദിഷ്മ, കിന്തു യുയം ന വ്യലപിഷ്ട, ബാലകൈരേതാദൃശൈസ്തേഷാമ് ഉപമാ ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","യതോ യോഹൻ മജ്ജക ആഗത്യ പൂപം നാഖാദത് ദ്രാക്ഷാരസഞ്ച നാപിവത് തസ്മാദ് യൂയം വദഥ, ഭൂതഗ്രസ്തോയമ്| ");
INSERT INTO sanmal_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","തതഃ പരം മാനവസുത ആഗത്യാഖാദദപിവഞ്ച തസ്മാദ് യൂയം വദഥ, ഖാദകഃ സുരാപശ്ചാണ്ഡാലപാപിനാം ബന്ധുരേകോ ജനോ ദൃശ്യതാമ്| ");
INSERT INTO sanmal_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","കിന്തു ജ്ഞാനിനോ ജ്ഞാനം നിർദോഷം വിദുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","പശ്ചാദേകഃ ഫിരൂശീ യീശും ഭോജനായ ന്യമന്ത്രയത് തതഃ സ തസ്യ ഗൃഹം ഗത്വാ ഭോക്തുമുപവിഷ്ടഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ഏതർഹി തത്ഫിരൂശിനോ ഗൃഹേ യീശു ർഭേക്തുമ് ഉപാവേക്ഷീത് തച്ഛ്രുത്വാ തന്നഗരവാസിനീ കാപി ദുഷ്ടാ നാരീ പാണ്ഡരപ്രസ്തരസ്യ സമ്പുടകേ സുഗന്ധിതൈലമ് ആനീയ ");
INSERT INTO sanmal_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","തസ്യ പശ്ചാത് പാദയോഃ സന്നിധൗ തസ്യൗ രുദതീ ച നേത്രാമ്ബുഭിസ്തസ്യ ചരണൗ പ്രക്ഷാല്യ നിജകചൈരമാർക്ഷീത്, തതസ്തസ്യ ചരണൗ ചുമ്ബിത്വാ തേന സുഗന്ധിതൈലേന മമർദ| ");
INSERT INTO sanmal_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","തസ്മാത് സ നിമന്ത്രയിതാ ഫിരൂശീ മനസാ ചിന്തയാമാസ, യദ്യയം ഭവിഷ്യദ്വാദീ ഭവേത് തർഹി ഏനം സ്പൃശതി യാ സ്ത്രീ സാ കാ കീദൃശീ ചേതി ജ്ഞാതും ശക്നുയാത് യതഃ സാ ദുഷ്ടാ| ");
INSERT INTO sanmal_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","തദാ യാശുസ്തം ജഗാദ, ഹേ ശിമോൻ ത്വാം പ്രതി മമ കിഞ്ചിദ് വക്തവ്യമസ്തി; തസ്മാത് സ ബഭാഷേ, ഹേ ഗുരോ തദ് വദതു| ");
INSERT INTO sanmal_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ഏകോത്തമർണസ്യ ദ്വാവധമർണാവാസ്താം, തയോരേകഃ പഞ്ചശതാനി മുദ്രാപാദാൻ അപരശ്ച പഞ്ചാശത് മുദ്രാപാദാൻ ധാരയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","തദനന്തരം തയോഃ ശോധ്യാഭാവാത് സ ഉത്തമർണസ്തയോ രൃണേ ചക്ഷമേ; തസ്മാത് തയോർദ്വയോഃ കസ്തസ്മിൻ പ്രേഷ്യതേ ബഹു? തദ് ബ്രൂഹി| ");
INSERT INTO sanmal_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ശിമോൻ പ്രത്യുവാച, മയാ ബുധ്യതേ യസ്യാധികമ് ഋണം ചക്ഷമേ സ ഇതി; തതോ യീശുസ്തം വ്യാജഹാര, ത്വം യഥാർഥം വ്യചാരയഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","അഥ താം നാരീം പ്രതി വ്യാഘുഠ്യ ശിമോനമവോചത്, സ്ത്രീമിമാം പശ്യസി? തവ ഗൃഹേ മയ്യാഗതേ ത്വം പാദപ്രക്ഷാലനാർഥം ജലം നാദാഃ കിന്തു യോഷിദേഷാ നയനജലൈ ർമമ പാദൗ പ്രക്ഷാല്യ കേശൈരമാർക്ഷീത്| ");
INSERT INTO sanmal_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ത്വം മാം നാചുമ്ബീഃ കിന്തു യോഷിദേഷാ സ്വീയാഗമനാദാരഭ്യ മദീയപാദൗ ചുമ്ബിതും ന വ്യരംസ്ത| ");
INSERT INTO sanmal_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ത്വഞ്ച മദീയോത്തമാങ്ഗേ കിഞ്ചിദപി തൈലം നാമർദീഃ കിന്തു യോഷിദേഷാ മമ ചരണൗ സുഗന്ധിതൈലേനാമർദ്ദീത്| ");
INSERT INTO sanmal_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","അതസ്ത്വാം വ്യാഹരാമി, ഏതസ്യാ ബഹു പാപമക്ഷമ്യത തതോ ബഹു പ്രീയതേ കിന്തു യസ്യാൽപപാപം ക്ഷമ്യതേ സോൽപം പ്രീയതേ| ");
INSERT INTO sanmal_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","തതഃ പരം സ താം ബഭാഷേ, ത്വദീയം പാപമക്ഷമ്യത| ");
INSERT INTO sanmal_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","തദാ തേന സാർദ്ധം യേ ഭോക്തുമ് ഉപവിവിശുസ്തേ പരസ്പരം വക്തുമാരേഭിരേ, അയം പാപം ക്ഷമതേ ക ഏഷഃ? ");
INSERT INTO sanmal_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","കിന്തു സ താം നാരീം ജഗാദ, തവ വിശ്വാസസ്ത്വാം പര്യ്യത്രാസ്ത ത്വം ക്ഷേമേണ വ്രജ| ");
INSERT INTO sanmal_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","അപരഞ്ച യീശു ർദ്വാദശഭിഃ ശിഷ്യൈഃ സാർദ്ധം നാനാനഗരേഷു നാനാഗ്രാമേഷു ച ഗച്ഛൻ ഇശ്വരീയരാജത്വസ്യ സുസംവാദം പ്രചാരയിതും പ്രാരേഭേ| ");
INSERT INTO sanmal_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","തദാ യസ്യാഃ സപ്ത ഭൂതാ നിരഗച്ഛൻ സാ മഗ്ദലീനീതി വിഖ്യാതാ മരിയമ് ഹേരോദ്രാജസ്യ ഗൃഹാധിപതേഃ ഹോഷേ ർഭാര്യ്യാ യോഹനാ ശൂശാനാ ");
INSERT INTO sanmal_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","പ്രഭൃതയോ യാ ബഹ്വ്യഃ സ്ത്രിയഃ ദുഷ്ടഭൂതേഭ്യോ രോഗേഭ്യശ്ച മുക്താഃ സത്യോ നിജവിഭൂതീ ർവ്യയിത്വാ തമസേവന്ത, താഃ സർവ്വാസ്തേന സാർദ്ധമ് ആസൻ| ");
INSERT INTO sanmal_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","അനന്തരം നാനാനഗരേഭ്യോ ബഹവോ ലോകാ ആഗത്യ തസ്യ സമീപേഽമിലൻ, തദാ സ തേഭ്യ ഏകാം ദൃഷ്ടാന്തകഥാം കഥയാമാസ| ഏകഃ കൃഷീബലോ ബീജാനി വപ്തും ബഹിർജഗാമ, ");
INSERT INTO sanmal_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","തതോ വപനകാലേ കതിപയാനി ബീജാനി മാർഗപാർശ്വേ പേതുഃ, തതസ്താനി പദതലൈ ർദലിതാനി പക്ഷിഭി ർഭക്ഷിതാനി ച| ");
INSERT INTO sanmal_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","കതിപയാനി ബീജാനി പാഷാണസ്ഥലേ പതിതാനി യദ്യപി താന്യങ്കുരിതാനി തഥാപി രസാഭാവാത് ശുശുഷുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","കതിപയാനി ബീജാനി കണ്ടകിവനമധ്യേ പതിതാനി തതഃ കണ്ടകിവനാനി സംവൃദ്ധ്യ താനി ജഗ്രസുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","തദന്യാനി കതിപയബീജാനി ച ഭൂമ്യാമുത്തമായാം പേതുസ്തതസ്താന്യങ്കുരയിത്വാ ശതഗുണാനി ഫലാനി ഫേലുഃ| സ ഇമാ കഥാം കഥയിത്വാ പ്രോച്ചൈഃ പ്രോവാച, യസ്യ ശ്രോതും ശ്രോത്രേ സ്തഃ സ ശൃണോതു| ");
INSERT INTO sanmal_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","തതഃ പരം ശിഷ്യാസ്തം പപ്രച്ഛുരസ്യ ദൃഷ്ടാന്തസ്യ കിം താത്പര്യ്യം? ");
INSERT INTO sanmal_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","തതഃ സ വ്യാജഹാര, ഈശ്വരീയരാജ്യസ്യ ഗുഹ്യാനി ജ്ഞാതും യുഷ്മഭ്യമധികാരോ ദീയതേ കിന്ത്വന്യേ യഥാ ദൃഷ്ട്വാപി ന പശ്യന്തി ശ്രുത്വാപി മ ബുധ്യന്തേ ച തദർഥം തേഷാം പുരസ്താത് താഃ സർവ്വാഃ കഥാ ദൃഷ്ടാന്തേന കഥ്യന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","ദൃഷ്ടാന്തസ്യാസ്യാഭിപ്രായഃ, ഈശ്വരീയകഥാ ബീജസ്വരൂപാ| ");
INSERT INTO sanmal_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","യേ കഥാമാത്രം ശൃണ്വന്തി കിന്തു പശ്ചാദ് വിശ്വസ്യ യഥാ പരിത്രാണം ന പ്രാപ്നുവന്തി തദാശയേന ശൈതാനേത്യ ഹൃദയാതൃ താം കഥാമ് അപഹരതി ത ഏവ മാർഗപാർശ്വസ്ഥഭൂമിസ്വരൂപാഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","യേ കഥം ശ്രുത്വാ സാനന്ദം ഗൃഹ്ലന്തി കിന്ത്വബദ്ധമൂലത്വാത് സ്വൽപകാലമാത്രം പ്രതീത്യ പരീക്ഷാകാലേ ഭ്രശ്യന്തി തഏവ പാഷാണഭൂമിസ്വരൂപാഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","യേ കഥാം ശ്രുത്വാ യാന്തി വിഷയചിന്തായാം ധനലോഭേന ഏेഹികസുഖേ ച മജ്ജന്ത ഉപയുക്തഫലാനി ന ഫലന്തി ത ഏവോപ്തബീജകണ്ടകിഭൂസ്വരൂപാഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","കിന്തു യേ ശ്രുത്വാ സരലൈഃ ശുദ്ധൈശ്ചാന്തഃകരണൈഃ കഥാം ഗൃഹ്ലന്തി ധൈര്യ്യമ് അവലമ്ബ്യ ഫലാന്യുത്പാദയന്തി ച ത ഏവോത്തമമൃത്സ്വരൂപാഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","അപരഞ്ച പ്രദീപം പ്രജ്വാല്യ കോപി പാത്രേണ നാച്ഛാദയതി തഥാ ഖട്വാധോപി ന സ്ഥാപയതി, കിന്തു ദീപാധാരോപര്യ്യേവ സ്ഥാപയതി, തസ്മാത് പ്രവേശകാ ദീപ്തിം പശ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","യന്ന പ്രകാശയിഷ്യതേ താദൃഗ് അപ്രകാശിതം വസ്തു കിമപി നാസ്തി യച്ച ന സുവ്യക്തം പ്രചാരയിഷ്യതേ താദൃഗ് ഗൃപ്തം വസ്തു കിമപി നാസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","അതോ യൂയം കേന പ്രകാരേണ ശൃണുഥ തത്ര സാവധാനാ ഭവത, യസ്യ സമീപേ ബർദ്ധതേ തസ്മൈ പുനർദാസ്യതേ കിന്തു യസ്യാശ്രയേ ന ബർദ്ധതേ തസ്യ യദ്യദസ്തി തദപി തസ്മാത് നേഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","അപരഞ്ച യീശോ ർമാതാ ഭ്രാതരശ്ച തസ്യ സമീപം ജിഗമിഷവഃ ");
INSERT INTO sanmal_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","കിന്തു ജനതാസമ്ബാധാത് തത്സന്നിധിം പ്രാപ്തും ന ശേകുഃ| തത്പശ്ചാത് തവ മാതാ ഭ്രാതരശ്ച ത്വാം സാക്ഷാത് ചികീർഷന്തോ ബഹിസ്തിഷ്ഠനതീതി വാർത്തായാം തസ്മൈ കഥിതായാം ");
INSERT INTO sanmal_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","സ പ്രത്യുവാച; യേ ജനാ ഈശ്വരസ്യ കഥാം ശ്രുത്വാ തദനുരൂപമാചരന്തി തഏവ മമ മാതാ ഭ്രാതരശ്ച| ");
INSERT INTO sanmal_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","അനന്തരം ഏകദാ യീശുഃ ശിഷ്യൈഃ സാർദ്ധം നാവമാരുഹ്യ ജഗാദ, ആയാത വയം ഹ്രദസ്യ പാരം യാമഃ, തതസ്തേ ജഗ്മുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","തേഷു നൗകാം വാഹയത്സു സ നിദദ്രൗ; ");
INSERT INTO sanmal_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","അഥാകസ്മാത് പ്രബലഝഞ്ഭ്ശഗമാദ് ഹ്രദേ നൗകായാം തരങ്ഗൈരാച്ഛന്നായാം വിപത് താൻ ജഗ്രാസ| തസ്മാദ് യീശോരന്തികം ഗത്വാ ഹേ ഗുരോ ഹേ ഗുരോ പ്രാണാ നോ യാന്തീതി ഗദിത്വാ തം ജാഗരയാമ്ബഭൂവുഃ| തദാ സ ഉത്ഥായ വായും തരങ്ഗാംശ്ച തർജയാമാസ തസ്മാദുഭൗ നിവൃത്യ സ്ഥിരൗ ബഭൂവതുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","സ താൻ ബഭാഷേ യുഷ്മാകം വിശ്വാസഃ ക? തസ്മാത്തേ ഭീതാ വിസ്മിതാശ്ച പരസ്പരം ജഗദുഃ, അഹോ കീദൃഗയം മനുജഃ പവനം പാനീയഞ്ചാദിശതി തദുഭയം തദാദേശം വഹതി| ");
INSERT INTO sanmal_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","തതഃ പരം ഗാലീൽപ്രദേശസ്യ സമ്മുഖസ്ഥഗിദേരീയപ്രദേശേ നൗകായാം ലഗന്ത്യാം തടേഽവരോഹമാവാദ് ");
INSERT INTO sanmal_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ബഹുതിഥകാലം ഭൂതഗ്രസ്ത ഏകോ മാനുഷഃ പുരാദാഗത്യ തം സാക്ഷാച്ചകാര| സ മനുഷോ വാസോ ന പരിദധത് ഗൃഹേ ച ന വസൻ കേവലം ശ്മശാനമ് അധ്യുവാസ| ");
INSERT INTO sanmal_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","സ യീശും ദൃഷ്ട്വൈവ ചീച്ഛബ്ദം ചകാര തസ്യ സമ്മുഖേ പതിത്വാ പ്രോച്ചൈർജഗാദ ച, ഹേ സർവ്വപ്രധാനേശ്വരസ്യ പുത്ര, മയാ സഹ തവ കഃ സമ്ബന്ധഃ? ത്വയി വിനയം കരോമി മാം മാ യാതയ| ");
INSERT INTO sanmal_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","യതഃ സ തം മാനുഷം ത്യക്ത്വാ യാതുമ് അമേധ്യഭൂതമ് ആദിദേശ; സ ഭൂതസ്തം മാനുഷമ് അസകൃദ് ദധാര തസ്മാല്ലോകാഃ ശൃങ്ഖലേന നിഗഡേന ച ബബന്ധുഃ; സ തദ് ഭംക്ത്വാ ഭൂതവശത്വാത് മധ്യേപ്രാന്തരം യയൗ| ");
INSERT INTO sanmal_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","അനന്തരം യീശുസ്തം പപ്രച്ഛ തവ കിന്നാമ? സ ഉവാച, മമ നാമ ബാഹിനോ യതോ ബഹവോ ഭൂതാസ്തമാശിശ്രിയുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","അഥ ഭൂതാ വിനയേന ജഗദുഃ, ഗഭീരം ഗർത്തം ഗന്തും മാജ്ഞാപയാസ്മാൻ| ");
INSERT INTO sanmal_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","തദാ പർവ്വതോപരി വരാഹവ്രജശ്ചരതി തസ്മാദ് ഭൂതാ വിനയേന പ്രോചുഃ, അമും വരാഹവ്രജമ് ആശ്രയിതുമ് അസ്മാൻ അനുജാനീഹി; തതഃ സോനുജജ്ഞൗ| ");
INSERT INTO sanmal_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","തതഃ പരം ഭൂതാസ്തം മാനുഷം വിഹായ വരാഹവ്രജമ് ആശിശ്രിയുഃ വരാഹവ്രജാശ്ച തത്ക്ഷണാത് കടകേന ധാവന്തോ ഹ്രദേ പ്രാണാൻ വിജൃഹുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","തദ് ദൃഷ്ട്വാ ശൂകരരക്ഷകാഃ പലായമാനാ നഗരം ഗ്രാമഞ്ച ഗത്വാ തത്സർവ്വവൃത്താന്തം കഥയാമാസുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","തതഃ കിം വൃത്തമ് ഏതദ്ദർശനാർഥം ലോകാ നിർഗത്യ യീശോഃ സമീപം യയുഃ, തം മാനുഷം ത്യക്തഭൂതം പരിഹിതവസ്ത്രം സ്വസ്ഥമാനുഷവദ് യീശോശ്ചരണസന്നിധൗ സൂപവിശന്തം വിലോക്യ ബിഭ്യുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","യേ ലോകാസ്തസ്യ ഭൂതഗ്രസ്തസ്യ സ്വാസ്ഥ്യകരണം ദദൃശുസ്തേ തേഭ്യഃ സർവ്വവൃത്താന്തം കഥയാമാസുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","തദനന്തരം തസ്യ ഗിദേരീയപ്രദേശസ്യ ചതുർദിക്സ്ഥാ ബഹവോ ജനാ അതിത്രസ്താ വിനയേന തം ജഗദുഃ, ഭവാൻ അസ്മാകം നികടാദ് വ്രജതു തസ്മാത് സ നാവമാരുഹ്യ തതോ വ്യാഘുട്യ ജഗാമ| ");
INSERT INTO sanmal_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","തദാനീം ത്യക്തഭൂതമനുജസ്തേന സഹ സ്ഥാതും പ്രാർഥയാഞ്ചക്രേ ");
INSERT INTO sanmal_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","കിന്തു തദർഥമ് ഈശ്വരഃ കീദൃങ്മഹാകർമ്മ കൃതവാൻ ഇതി നിവേശനം ഗത്വാ വിജ്ഞാപയ, യീശുഃ കഥാമേതാം കഥയിത്വാ തം വിസസർജ| തതഃ സ വ്രജിത്വാ യീശുസ്തദർഥം യന്മഹാകർമ്മ ചകാര തത് പുരസ്യ സർവ്വത്ര പ്രകാശയിതും പ്രാരേഭേ| ");
INSERT INTO sanmal_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","അഥ യീശൗ പരാവൃത്യാഗതേ ലോകാസ്തം ആദരേണ ജഗൃഹു ര്യസ്മാത്തേ സർവ്വേ തമപേക്ഷാഞ്ചക്രിരേ| ");
INSERT INTO sanmal_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","തദനന്തരം യായീർനാമ്നോ ഭജനഗേഹസ്യൈകോധിപ ആഗത്യ യീശോശ്ചരണയോഃ പതിത്വാ സ്വനിവേശനാഗമനാർഥം തസ്മിൻ വിനയം ചകാര, ");
INSERT INTO sanmal_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","യതസ്തസ്യ ദ്വാദശവർഷവയസ്കാ കന്യൈകാസീത് സാ മൃതകൽപാഭവത്| തതസ്തസ്യ ഗമനകാലേ മാർഗേ ലോകാനാം മഹാൻ സമാഗമോ ബഭൂവ| ");
INSERT INTO sanmal_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ദ്വാദശവർഷാണി പ്രദരരോഗഗ്രസ്താ നാനാ വൈദ്യൈശ്ചികിത്സിതാ സർവ്വസ്വം വ്യയിത്വാപി സ്വാസ്ഥ്യം ന പ്രാപ്താ യാ യോഷിത് സാ യീശോഃ പശ്ചാദാഗത്യ തസ്യ വസ്ത്രഗ്രന്ഥിം പസ്പർശ| ");
INSERT INTO sanmal_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","തസ്മാത് തത്ക്ഷണാത് തസ്യാ രക്തസ്രാവോ രുദ്ധഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","തദാനീം യീശുരവദത് കേനാഹം സ്പൃഷ്ടഃ? തതോഽനേകൈരനങ്ഗീകൃതേ പിതരസ്തസ്യ സങ്ഗിനശ്ചാവദൻ, ഹേ ഗുരോ ലോകാ നികടസ്ഥാഃ സന്തസ്തവ ദേഹേ ഘർഷയന്തി, തഥാപി കേനാഹം സ്പൃഷ്ടഇതി ഭവാൻ കുതഃ പൃച്ഛതി? ");
INSERT INTO sanmal_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","യീശുഃ കഥയാമാസ, കേനാപ്യഹം സ്പൃഷ്ടോ, യതോ മത്തഃ ശക്തി ർനിർഗതേതി മയാ നിശ്ചിതമജ്ഞായി| ");
INSERT INTO sanmal_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","തദാ സാ നാരീ സ്വയം ന ഗുപ്തേതി വിദിത്വാ കമ്പമാനാ സതീ തസ്യ സമ്മുഖേ പപാത; യേന നിമിത്തേന തം പസ്പർശ സ്പർശമാത്രാച്ച യേന പ്രകാരേണ സ്വസ്ഥാഭവത് തത് സർവ്വം തസ്യ സാക്ഷാദാചഖ്യൗ| ");
INSERT INTO sanmal_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","തതഃ സ താം ജഗാദ ഹേ കന്യേ സുസ്ഥിരാ ഭവ, തവ വിശ്വാസസ്ത്വാം സ്വസ്ഥാമ് അകാർഷീത് ത്വം ക്ഷേമേണ യാഹി| ");
INSERT INTO sanmal_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","യീശോരേതദ്വാക്യവദനകാലേ തസ്യാധിപതേ ർനിവേശനാത് കശ്ചില്ലോക ആഗത്യ തം ബഭാഷേ, തവ കന്യാ മൃതാ ഗുരും മാ ക്ലിശാന| ");
INSERT INTO sanmal_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","കിന്തു യീശുസ്തദാകർണ്യാധിപതിം വ്യാജഹാര, മാ ഭൈഷീഃ കേവലം വിശ്വസിഹി തസ്മാത് സാ ജീവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","അഥ തസ്യ നിവേശനേ പ്രാപ്തേ സ പിതരം യോഹനം യാകൂബഞ്ച കന്യായാ മാതരം പിതരഞ്ച വിനാ, അന്യം കഞ്ചന പ്രവേഷ്ടും വാരയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","അപരഞ്ച യേ രുദന്തി വിലപന്തി ച താൻ സർവ്വാൻ ജനാൻ ഉവാച, യൂയം മാ രോദിഷ്ട കന്യാ ന മൃതാ നിദ്രാതി| ");
INSERT INTO sanmal_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","കിന്തു സാ നിശ്ചിതം മൃതേതി ജ്ഞാത്വാ തേ തമുപജഹസുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","പശ്ചാത് സ സർവ്വാൻ ബഹിഃ കൃത്വാ കന്യായാഃ കരൗ ധൃത്വാജുഹുവേ, ഹേ കന്യേ ത്വമുത്തിഷ്ഠ, ");
INSERT INTO sanmal_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","തസ്മാത് തസ്യാഃ പ്രാണേഷു പുനരാഗതേഷു സാ തത്ക്ഷണാദ് ഉത്തസ്യൗ| തദാനീം തസ്യൈ കിഞ്ചിദ് ഭക്ഷ്യം ദാതുമ് ആദിദേശ| ");
INSERT INTO sanmal_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","തതസ്തസ്യാഃ പിതരൗ വിസ്മയം ഗതൗ കിന്തു സ താവാദിദേശ ഘടനായാ ഏതസ്യാഃ കഥാം കസ്മൈചിദപി മാ കഥയതം| ");
INSERT INTO sanmal_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","തതഃ പരം സ ദ്വാദശശിഷ്യാനാഹൂയ ഭൂതാൻ ത്യാജയിതും രോഗാൻ പ്രതികർത്തുഞ്ച തേഭ്യഃ ശക്തിമാധിപത്യഞ്ച ദദൗ| ");
INSERT INTO sanmal_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","അപരഞ്ച ഈശ്വരീയരാജ്യസ്യ സുസംവാദം പ്രകാശയിതുമ് രോഗിണാമാരോഗ്യം കർത്തുഞ്ച പ്രേരണകാലേ താൻ ജഗാദ| ");
INSERT INTO sanmal_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","യാത്രാർഥം യഷ്ടി ർവസ്ത്രപുടകം ഭക്ഷ്യം മുദ്രാ ദ്വിതീയവസ്ത്രമ്, ഏഷാം കിമപി മാ ഗൃഹ്ലീത| ");
INSERT INTO sanmal_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","യൂയഞ്ച യന്നിവേശനം പ്രവിശഥ നഗരത്യാഗപര്യ്യനതം തന്നിവേശനേ തിഷ്ഠത| ");
INSERT INTO sanmal_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","തത്ര യദി കസ്യചിത് പുരസ്യ ലോകാ യുഷ്മാകമാതിഥ്യം ന കുർവ്വന്തി തർഹി തസ്മാന്നഗരാദ് ഗമനകാലേ തേഷാം വിരുദ്ധം സാക്ഷ്യാർഥം യുഷ്മാകം പദധൂലീഃ സമ്പാതയത| ");
INSERT INTO sanmal_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","അഥ തേ പ്രസ്ഥായ സർവ്വത്ര സുസംവാദം പ്രചാരയിതും പീഡിതാൻ സ്വസ്ഥാൻ കർത്തുഞ്ച ഗ്രാമേഷു ഭ്രമിതും പ്രാരേഭിരേ| ");
INSERT INTO sanmal_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ഏതർഹി ഹേരോദ് രാജാ യീശോഃ സർവ്വകർമ്മണാം വാർത്താം ശ്രുത്വാ ഭൃശമുദ്വിവിജേ ");
INSERT INTO sanmal_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","യതഃ കേചിദൂചുര്യോഹൻ ശ്മശാനാദുദതിഷ്ഠത്| കേചിദൂചുഃ, ഏലിയോ ദർശനം ദത്തവാൻ; ഏവമന്യലോകാ ഊചുഃ പൂർവ്വീയഃ കശ്ചിദ് ഭവിഷ്യദ്വാദീ സമുത്ഥിതഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","കിന്തു ഹേരോദുവാച യോഹനഃ ശിരോഽഹമഛിനദമ് ഇദാനീം യസ്യേദൃക്കർമ്മണാം വാർത്താം പ്രാപ്നോമി സ കഃ? അഥ സ തം ദ്രഷ്ടുമ് ഐച്ഛത്| ");
INSERT INTO sanmal_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","അനന്തരം പ്രേരിതാഃ പ്രത്യാഗത്യ യാനി യാനി കർമ്മാണി ചക്രുസ്താനി യീശവേ കഥയാമാസുഃ തതഃ സ താൻ ബൈത്സൈദാനാമകനഗരസ്യ വിജനം സ്ഥാനം നീത്വാ ഗുപ്തം ജഗാമ| ");
INSERT INTO sanmal_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","പശ്ചാൽ ലോകാസ്തദ് വിദിത്വാ തസ്യ പശ്ചാദ് യയുഃ; തതഃ സ താൻ നയൻ ഈശ്വരീയരാജ്യസ്യ പ്രസങ്ഗമുക്തവാൻ, യേഷാം ചികിത്സയാ പ്രയോജനമ് ആസീത് താൻ സ്വസ്ഥാൻ ചകാര ച| ");
INSERT INTO sanmal_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","അപരഞ്ച ദിവാവസന്നേ സതി ദ്വാദശശിഷ്യാ യീശോരന്തികമ് ഏത്യ കഥയാമാസുഃ, വയമത്ര പ്രാന്തരസ്ഥാനേ തിഷ്ഠാമഃ, തതോ നഗരാണി ഗ്രാമാണി ഗത്വാ വാസസ്ഥാനാനി പ്രാപ്യ ഭക്ഷ്യദ്രവ്യാണി ക്രേതും ജനനിവഹം ഭവാൻ വിസൃജതു| ");
INSERT INTO sanmal_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","തദാ സ ഉവാച, യൂയമേവ താൻ ഭേജയധ്വം; തതസ്തേ പ്രോചുരസ്മാകം നികടേ കേവലം പഞ്ച പൂപാ ദ്വൗ മത്സ്യൗ ച വിദ്യന്തേ, അതഏവ സ്ഥാനാന്തരമ് ഇത്വാ നിമിത്തമേതേഷാം ഭക്ഷ്യദ്രവ്യേഷു ന ക്രീതേഷു ന ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","തത്ര പ്രായേണ പഞ്ചസഹസ്രാണി പുരുഷാ ആസൻ| ");
INSERT INTO sanmal_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","തദാ സ ശിഷ്യാൻ ജഗാദ പഞ്ചാശത് പഞ്ചാശജ്ജനൈഃ പംക്തീകൃത്യ താനുപവേശയത, തസ്മാത് തേ തദനുസാരേണ സർവ്വലോകാനുപവേശയാപാസുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","തതഃ സ താൻ പഞ്ച പൂപാൻ മീനദ്വയഞ്ച ഗൃഹീത്വാ സ്വർഗം വിലോക്യേശ്വരഗുണാൻ കീർത്തയാഞ്ചക്രേ ഭങ്ക്താ ച ലോകേഭ്യഃ പരിവേഷണാർഥം ശിഷ്യേഷു സമർപയാമ്ബഭൂവ| ");
INSERT INTO sanmal_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","തതഃ സർവ്വേ ഭുക്ത്വാ തൃപ്തിം ഗതാ അവശിഷ്ടാനാഞ്ച ദ്വാദശ ഡല്ലകാൻ സംജഗൃഹുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","അഥൈകദാ നിർജനേ ശിഷ്യൈഃ സഹ പ്രാർഥനാകാലേ താൻ പപ്രച്ഛ, ലോകാ മാം കം വദന്തി? ");
INSERT INTO sanmal_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","തതസ്തേ പ്രാചുഃ, ത്വാം യോഹന്മജ്ജകം വദന്തി; കേചിത് ത്വാമ് ഏലിയം വദന്തി, പൂർവ്വകാലികഃ കശ്ചിദ് ഭവിഷ്യദ്വാദീ ശ്മശാനാദ് ഉദതിഷ്ഠദ് ഇത്യപി കേചിദ് വദന്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","തദാ സ ഉവാച, യൂയം മാം കം വദഥ? തതഃ പിതര ഉക്തവാൻ ത്വമ് ഈശ്വരാഭിഷിക്തഃ പുരുഷഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","തദാ സ താൻ ദൃഢമാദിദേശ, കഥാമേതാം കസ്മൈചിദപി മാ കഥയത| ");
INSERT INTO sanmal_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","സ പുനരുവാച, മനുഷ്യപുത്രേണ വഹുയാതനാ ഭോക്തവ്യാഃ പ്രാചീനലോകൈഃ പ്രധാനയാജകൈരധ്യാപകൈശ്ച സോവജ്ഞായ ഹന്തവ്യഃ കിന്തു തൃതീയദിവസേ ശ്മശാനാത് തേനോത്ഥാതവ്യമ്| ");
INSERT INTO sanmal_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","അപരം സ സർവ്വാനുവാച, കശ്ചിദ് യദി മമ പശ്ചാദ് ഗന്തും വാഞ്ഛതി തർഹി സ സ്വം ദാമ്യതു, ദിനേ ദിനേ ക്രുശം ഗൃഹീത്വാ ച മമ പശ്ചാദാഗച്ഛതു| ");
INSERT INTO sanmal_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","യതോ യഃ കശ്ചിത് സ്വപ്രാണാൻ രിരക്ഷിഷതി സ താൻ ഹാരയിഷ്യതി, യഃ കശ്ചിൻ മദർഥം പ്രാണാൻ ഹാരയിഷ്യതി സ താൻ രക്ഷിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","കശ്ചിദ് യദി സർവ്വം ജഗത് പ്രാപ്നോതി കിന്തു സ്വപ്രാണാൻ ഹാരയതി സ്വയം വിനശ്യതി ച തർഹി തസ്യ കോ ലാഭഃ? ");
INSERT INTO sanmal_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","പുന ര്യഃ കശ്ചിൻ മാം മമ വാക്യം വാ ലജ്ജാസ്പദം ജാനാതി മനുഷ്യപുത്രോ യദാ സ്വസ്യ പിതുശ്ച പവിത്രാണാം ദൂതാനാഞ്ച തേജോഭിഃ പരിവേഷ്ടിത ആഗമിഷ്യതി തദാ സോപി തം ലജ്ജാസ്പദം ജ്ഞാസ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","കിന്തു യുഷ്മാനഹം യഥാർഥം വദാമി, ഈശ്വരീയരാജത്വം ന ദൃഷ്ടവാ മൃത്യും നാസ്വാദിഷ്യന്തേ, ഏതാദൃശാഃ കിയന്തോ ലോകാ അത്ര സ്ഥനേഽപി ദണ്ഡായമാനാഃ സന്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ഏതദാഖ്യാനകഥനാത് പരം പ്രായേണാഷ്ടസു ദിനേഷു ഗതേഷു സ പിതരം യോഹനം യാകൂബഞ്ച ഗൃഹീത്വാ പ്രാർഥയിതും പർവ്വതമേകം സമാരുരോഹ| ");
INSERT INTO sanmal_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","അഥ തസ്യ പ്രാർഥനകാലേ തസ്യ മുഖാകൃതിരന്യരൂപാ ജാതാ, തദീയം വസ്ത്രമുജ്ജ്വലശുക്ലം ജാതം| ");
INSERT INTO sanmal_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","അപരഞ്ച മൂസാ ഏലിയശ്ചോഭൗ തേജസ്വിനൗ ദൃഷ്ടൗ ");
INSERT INTO sanmal_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","തൗ തേന യിരൂശാലമ്പുരേ യോ മൃത്യുഃ സാധിഷ്യതേ തദീയാം കഥാം തേന സാർദ്ധം കഥയിതുമ് ആരേഭാതേ| ");
INSERT INTO sanmal_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","തദാ പിതരാദയഃ സ്വസ്യ സങ്ഗിനോ നിദ്രയാകൃഷ്ടാ ആസൻ കിന്തു ജാഗരിത്വാ തസ്യ തേജസ്തേന സാർദ്ധമ് ഉത്തിഷ്ഠന്തൗ ജനൗ ച ദദൃശുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","അഥ തയോരുഭയോ ർഗമനകാലേ പിതരോ യീശും ബഭാഷേ, ഹേ ഗുരോഽസ്മാകം സ്ഥാനേഽസ്മിൻ സ്ഥിതിഃ ശുഭാ, തത ഏകാ ത്വദർഥാ, ഏകാ മൂസാർഥാ, ഏകാ ഏലിയാർഥാ, ഇതി തിസ്രഃ കുട്യോസ്മാഭി ർനിർമ്മീയന്താം, ഇമാം കഥാം സ ന വിവിച്യ കഥയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","അപരഞ്ച തദ്വാക്യവദനകാലേ പയോദ ഏക ആഗത്യ തേഷാമുപരി ഛായാം ചകാര, തതസ്തന്മധ്യേ തയോഃ പ്രവേശാത് തേ ശശങ്കിരേ| ");
INSERT INTO sanmal_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","തദാ തസ്മാത് പയോദാദ് ഇയമാകാശീയാ വാണീ നിർജഗാമ, മമായം പ്രിയഃ പുത്ര ഏതസ്യ കഥായാം മനോ നിധത്ത| ");
INSERT INTO sanmal_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ഇതി ശബ്ദേ ജാതേ തേ യീശുമേകാകിനം ദദൃശുഃ കിന്തു തേ തദാനീം തസ്യ ദർശനസ്യ വാചമേകാമപി നോക്ത്വാ മനഃസു സ്ഥാപയാമാസുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","പരേഽഹനി തേഷു തസ്മാച്ഛൈലാദ് അവരൂഢേഷു തം സാക്ഷാത് കർത്തും ബഹവോ ലോകാ ആജഗ്മുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","തേഷാം മധ്യാദ് ഏകോ ജന ഉച്ചൈരുവാച, ഹേ ഗുരോ അഹം വിനയം കരോമി മമ പുത്രം പ്രതി കൃപാദൃഷ്ടിം കരോതു, മമ സ ഏവൈകഃ പുത്രഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ഭൂതേന ധൃതഃ സൻ സം പ്രസഭം ചീച്ഛബ്ദം കരോതി തന്മുഖാത് ഫേണാ നിർഗച്ഛന്തി ച, ഭൂത ഇത്ഥം വിദാര്യ്യ ക്ലിഷ്ട്വാ പ്രായശസ്തം ന ത്യജതി| ");
INSERT INTO sanmal_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","തസ്മാത് തം ഭൂതം ത്യാജയിതും തവ ശിഷ്യസമീപേ ന്യവേദയം കിന്തു തേ ന ശേകുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","തദാ യീശുരവാദീത്, രേ ആവിശ്വാസിൻ വിപഥഗാമിൻ വംശ കതികാലാൻ യുഷ്മാഭിഃ സഹ സ്ഥാസ്യാമ്യഹം യുഷ്മാകമ് ആചരണാനി ച സഹിഷ്യേ? തവ പുത്രമിഹാനയ| ");
INSERT INTO sanmal_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","തതസ്തസ്മിന്നാഗതമാത്രേ ഭൂതസ്തം ഭൂമൗ പാതയിത്വാ വിദദാര; തദാ യീശുസ്തമമേധ്യം ഭൂതം തർജയിത്വാ ബാലകം സ്വസ്ഥം കൃത്വാ തസ്യ പിതരി സമർപയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ഈശ്വരസ്യ മഹാശക്തിമ് ഇമാം വിലോക്യ സർവ്വേ ചമച്ചക്രുഃ; ഇത്ഥം യീശോഃ സർവ്വാഭിഃ ക്രിയാഭിഃ സർവ്വൈർലോകൈരാശ്ചര്യ്യേ മന്യമാനേ സതി സ ശിഷ്യാൻ ബഭാഷേ, ");
INSERT INTO sanmal_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","കഥേയം യുഷ്മാകം കർണേഷു പ്രവിശതു, മനുഷ്യപുത്രോ മനുഷ്യാണാം കരേഷു സമർപയിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","കിന്തു തേ താം കഥാം ന ബുബുധിരേ, സ്പഷ്ടത്വാഭാവാത് തസ്യാ അഭിപ്രായസ്തേഷാം ബോധഗമ്യോ ന ബഭൂവ; തസ്യാ ആശയഃ ക ഇത്യപി തേ ഭയാത് പ്രഷ്ടും ന ശേകുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","തദനന്തരം തേഷാം മധ്യേ കഃ ശ്രേഷ്ഠഃ കഥാമേതാം ഗൃഹീത്വാ തേ മിഥോ വിവാദം ചക്രുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","തതോ യീശുസ്തേഷാം മനോഭിപ്രായം വിദിത്വാ ബാലകമേകം ഗൃഹീത്വാ സ്വസ്യ നികടേ സ്ഥാപയിത്വാ താൻ ജഗാദ, ");
INSERT INTO sanmal_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","യോ ജനോ മമ നാമ്നാസ്യ ബാലാസ്യാതിഥ്യം വിദധാതി സ മമാതിഥ്യം വിദധാതി, യശ്ച മമാതിഥ്യം വിദധാതി സ മമ പ്രേരകസ്യാതിഥ്യം വിദധാതി, യുഷ്മാകം മധ്യേയഃ സ്വം സർവ്വസ്മാത് ക്ഷുദ്രം ജാനീതേ സ ഏവ ശ്രേഷ്ഠോ ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","അപരഞ്ച യോഹൻ വ്യാജഹാര ഹേ പ്രഭേा തവ നാമ്നാ ഭൂതാൻ ത്യാജയന്തം മാനുഷമ് ഏകം ദൃഷ്ടവന്തോ വയം, കിന്ത്വസ്മാകമ് അപശ്ചാദ് ഗാമിത്വാത് തം ന്യഷേധാമ്| തദാനീം യീശുരുവാച, ");
INSERT INTO sanmal_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","തം മാ നിഷേധത, യതോ യോ ജനോസ്മാകം ന വിപക്ഷഃ സ ഏവാസ്മാകം സപക്ഷോ ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","അനന്തരം തസ്യാരോഹണസമയ ഉപസ്ഥിതേ സ സ്ഥിരചേതാ യിരൂശാലമം പ്രതി യാത്രാം കർത്തും നിശ്ചിത്യാഗ്രേ ദൂതാൻ പ്രേഷയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","തസ്മാത് തേ ഗത്വാ തസ്യ പ്രയോജനീയദ്രവ്യാണി സംഗ്രഹീതും ശോമിരോണീയാനാം ഗ്രാമം പ്രവിവിശുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","കിന്തു സ യിരൂശാലമം നഗരം യാതി തതോ ഹേതോ ർലോകാസ്തസ്യാതിഥ്യം ന ചക്രുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","അതഏവ യാകൂബ്യോഹനൗ തസ്യ ശിഷ്യൗ തദ് ദൃഷ്ട്വാ ജഗദതുഃ, ഹേ പ്രഭോ ഏലിയോ യഥാ ചകാര തഥാ വയമപി കിം ഗഗണാദ് ആഗന്തുമ് ഏതാൻ ഭസ്മീകർത്തുഞ്ച വഹ്നിമാജ്ഞാപയാമഃ? ഭവാൻ കിമിച്ഛതി? ");
INSERT INTO sanmal_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","കിന്തു സ മുഖം പരാവർത്യ താൻ തർജയിത്വാ ഗദിതവാൻ യുഷ്മാകം മനോഭാവഃ കഃ, ഇതി യൂയം ന ജാനീഥ| ");
INSERT INTO sanmal_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","മനുജസുതോ മനുജാനാം പ്രാണാൻ നാശയിതും നാഗച്ഛത്, കിന്തു രക്ഷിതുമ് ആഗച്ഛത്| പശ്ചാദ് ഇതരഗ്രാമം തേ യയുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","തദനന്തരം പഥി ഗമനകാലേ ജന ഏകസ്തം ബഭാഷേ, ഹേ പ്രഭോ ഭവാൻ യത്ര യാതി ഭവതാ സഹാഹമപി തത്ര യാസ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","തദാനീം യീശുസ്തമുവാച, ഗോമായൂനാം ഗർത്താ ആസതേ, വിഹായസീയവിഹഗാाനാം നീഡാനി ച സന്തി, കിന്തു മാനവതനയസ്യ ശിരഃ സ്ഥാപയിതും സ്ഥാനം നാസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","തതഃ പരം സ ഇതരജനം ജഗാദ, ത്വം മമ പശ്ചാദ് ഏഹി; തതഃ സ ഉവാച, ഹേ പ്രഭോ പൂർവ്വം പിതരം ശ്മശാനേ സ്ഥാപയിതും മാമാദിശതു| ");
INSERT INTO sanmal_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","തദാ യീശുരുവാച, മൃതാ മൃതാൻ ശ്മശാനേ സ്ഥാപയന്തു കിന്തു ത്വം ഗത്വേശ്വരീയരാജ്യസ്യ കഥാം പ്രചാരയ| ");
INSERT INTO sanmal_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","തതോന്യഃ കഥയാമാസ, ഹേ പ്രഭോ മയാപി ഭവതഃ പശ്ചാദ് ഗംസ്യതേ, കിന്തു പൂർവ്വം മമ നിവേശനസ്യ പരിജനാനാമ് അനുമതിം ഗ്രഹീതുമ് അഹമാദിശ്യൈ ഭവതാ| ");
INSERT INTO sanmal_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","തദാനീം യീശുസ്തം പ്രോക്തവാൻ, യോ ജനോ ലാങ്ഗലേ കരമർപയിത്വാ പശ്ചാത് പശ്യതി സ ഈശ്വരീയരാജ്യം നാർഹതി| ");
INSERT INTO sanmal_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","തതഃ പരം പ്രഭുരപരാൻ സപ്തതിശിഷ്യാൻ നിയുജ്യ സ്വയം യാനി നഗരാണി യാനി സ്ഥാനാനി ച ഗമിഷ്യതി താനി നഗരാണി താനി സ്ഥാനാനി ച പ്രതി ദ്വൗ ദ്വൗ ജനൗ പ്രഹിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","തേഭ്യഃ കഥയാമാസ ച ശസ്യാനി ബഹൂനീതി സത്യം കിന്തു ഛേദകാ അൽപേ; തസ്മാദ്ധേതോഃ ശസ്യക്ഷേത്രേ ഛേദകാൻ അപരാനപി പ്രേഷയിതും ക്ഷേത്രസ്വാമിനം പ്രാർഥയധ്വം| ");
INSERT INTO sanmal_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","യൂയം യാത, പശ്യത, വൃകാണാം മധ്യേ മേഷശാവകാനിവ യുഷ്മാൻ പ്രഹിണോമി| ");
INSERT INTO sanmal_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","യൂയം ക്ഷുദ്രം മഹദ് വാ വസനസമ്പുടകം പാദുകാശ്ച മാ ഗൃഹ്ലീത, മാർഗമധ്യേ കമപി മാ നമത ച| ");
INSERT INTO sanmal_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","അപരഞ്ച യൂയം യദ് യത് നിവേശനം പ്രവിശഥ തത്ര നിവേശനസ്യാസ്യ മങ്ഗലം ഭൂയാദിതി വാക്യം പ്രഥമം വദത| ");
INSERT INTO sanmal_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","തസ്മാത് തസ്മിൻ നിവേശനേ യദി മങ്ഗലപാത്രം സ്ഥാസ്യതി തർഹി തന്മങ്ഗലം തസ്യ ഭവിഷ്യതി, നോചേത് യുഷ്മാൻ പ്രതി പരാവർത്തിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","അപരഞ്ച തേ യത്കിഞ്ചിദ് ദാസ്യന്തി തദേവ ഭുക്ത്വാ പീത്വാ തസ്മിന്നിവേശനേ സ്ഥാസ്യഥ; യതഃ കർമ്മകാരീ ജനോ ഭൃതിമ് അർഹതി; ഗൃഹാദ് ഗൃഹം മാ യാസ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","അന്യച്ച യുഷ്മാസു കിമപി നഗരം പ്രവിഷ്ടേഷു ലോകാ യദി യുഷ്മാകമ് ആതിഥ്യം കരിഷ്യന്തി, തർഹി യത് ഖാദ്യമ് ഉപസ്ഥാസ്യന്തി തദേവ ഖാദിഷ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","തന്നഗരസ്ഥാൻ രോഗിണഃ സ്വസ്ഥാൻ കരിഷ്യഥ, ഈശ്വരീയം രാജ്യം യുഷ്മാകമ് അന്തികമ് ആഗമത് കഥാമേതാഞ്ച പ്രചാരയിഷ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","കിന്തു കിമപി പുരം യുഷ്മാസു പ്രവിഷ്ടേഷു ലോകാ യദി യുഷ്മാകമ് ആതിഥ്യം ന കരിഷ്യന്തി, തർഹി തസ്യ നഗരസ്യ പന്ഥാനം ഗത്വാ കഥാമേതാം വദിഷ്യഥ, ");
INSERT INTO sanmal_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","യുഷ്മാകം നഗരീയാ യാ ധൂല്യോഽസ്മാസു സമലഗൻ താ അപി യുഷ്മാകം പ്രാതികൂല്യേന സാക്ഷ്യാർഥം സമ്പാതയാമഃ; തഥാപീശ്വരരാജ്യം യുഷ്മാകം സമീപമ് ആഗതമ് ഇതി നിശ്ചിതം ജാനീത| ");
INSERT INTO sanmal_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","അഹം യുഷ്മഭ്യം യഥാർഥം കഥയാമി, വിചാരദിനേ തസ്യ നഗരസ്യ ദശാതഃ സിദോമോ ദശാ സഹ്യാ ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","ഹാ ഹാ കോരാസീൻ നഗര, ഹാ ഹാ ബൈത്സൈദാനഗര യുവയോർമധ്യേ യാദൃശാനി ആശ്ചര്യ്യാണി കർമ്മാണ്യക്രിയന്ത, താനി കർമ്മാണി യദി സോരസീദോനോ ർനഗരയോരകാരിഷ്യന്ത, തദാ ഇതോ ബഹുദിനപൂർവ്വം തന്നിവാസിനഃ ശണവസ്ത്രാണി പരിധായ ഗാത്രേഷു ഭസ്മ വിലിപ്യ സമുപവിശ്യ സമഖേത്സ്യന്ത| ");
INSERT INTO sanmal_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","അതോ വിചാരദിവസേ യുഷ്മാകം ദശാതഃ സോരസീദോന്നിവാസിനാം ദശാ സഹ്യാ ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ഹേ കഫർനാഹൂമ്, ത്വം സ്വർഗം യാവദ് ഉന്നതാ കിന്തു നരകം യാവത് ന്യഗ്ഭവിഷ്യസി| ");
INSERT INTO sanmal_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","യോ ജനോ യുഷ്മാകം വാക്യം ഗൃഹ്ലാതി സ മമൈവ വാക്യം ഗൃഹ്ലാതി; കിഞ്ച യോ ജനോ യുഷ്മാകമ് അവജ്ഞാം കരോതി സ മമൈവാവജ്ഞാം കരോതി; യോ ജനോ മമാവജ്ഞാം കരോതി ച സ മത്പ്രേരകസ്യൈവാവജ്ഞാം കരോതി| ");
INSERT INTO sanmal_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","അഥ തേ സപ്തതിശിഷ്യാ ആനന്ദേന പ്രത്യാഗത്യ കഥയാമാസുഃ, ഹേ പ്രഭോ ഭവതോ നാമ്നാ ഭൂതാ അപ്യസ്മാകം വശീഭവന്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","തദാനീം സ താൻ ജഗാദ, വിദ്യുതമിവ സ്വർഗാത് പതന്തം ശൈതാനമ് അദർശമ്| ");
INSERT INTO sanmal_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","പശ്യത സർപാൻ വൃശ്ചികാൻ രിപോഃ സർവ്വപരാക്രമാംശ്ച പദതലൈ ർദലയിതും യുഷ്മഭ്യം ശക്തിം ദദാമി തസ്മാദ് യുഷ്മാകം കാപി ഹാനി ർന ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","ഭൂതാ യുഷ്മാകം വശീഭവന്തി, ഏതന്നിമിത്തത് മാ സമുല്ലസത, സ്വർഗേ യുഷ്മാകം നാമാനി ലിഖിതാനി സന്തീതി നിമിത്തം സമുല്ലസത| ");
INSERT INTO sanmal_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","തദ്ഘടികായാം യീശു ർമനസി ജാതാഹ്ലാദഃ കഥയാമാസ ഹേ സ്വർഗപൃഥിവ്യോരേകാധിപതേ പിതസ്ത്വം ജ്ഞാനവതാം വിദുഷാഞ്ച ലോകാനാം പുരസ്താത് സർവ്വമേതദ് അപ്രകാശ്യ ബാലകാനാം പുരസ്താത് പ്രാകാശയ ഏതസ്മാദ്ധേതോസ്ത്വാം ധന്യം വദാമി, ഹേ പിതരിത്ഥം ഭവതു യദ് ഏതദേവ തവ ഗോചര ഉത്തമമ്| ");
INSERT INTO sanmal_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","പിത്രാ സർവ്വാണി മയി സമർപിതാനി പിതരം വിനാ കോപി പുത്രം ന ജാനാതി കിഞ്ച പുത്രം വിനാ യസ്മൈ ജനായ പുത്രസ്തം പ്രകാശിതവാൻ തഞ്ച വിനാ കോപി പിതരം ന ജാനാതി| ");
INSERT INTO sanmal_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","തപഃ പരം സ ശിഷ്യാൻ പ്രതി പരാവൃത്യ ഗുപ്തം ജഗാദ, യൂയമേതാനി സർവ്വാണി പശ്യഥ തതോ യുഷ്മാകം ചക്ഷൂംഷി ധന്യാനി| ");
INSERT INTO sanmal_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","യുഷ്മാനഹം വദാമി, യൂയം യാനി സർവ്വാണി പശ്യഥ താനി ബഹവോ ഭവിഷ്യദ്വാദിനോ ഭൂപതയശ്ച ദ്രഷ്ടുമിച്ഛന്തോപി ദ്രഷ്ടും ന പ്രാപ്നുവൻ, യുഷ്മാഭി ര്യാ യാഃ കഥാശ്ച ശ്രൂയന്തേ താഃ ശ്രോതുമിച്ഛന്തോപി ശ്രോതും നാലഭന്ത| ");
INSERT INTO sanmal_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","അനന്തരമ് ഏകോ വ്യവസ്ഥാപക ഉത്ഥായ തം പരീക്ഷിതും പപ്രച്ഛ, ഹേ ഉപദേശക അനന്തായുഷഃ പ്രാപ്തയേ മയാ കിം കരണീയം? ");
INSERT INTO sanmal_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","യീശുഃ പ്രത്യുവാച, അത്രാർഥേ വ്യവസ്ഥായാം കിം ലിഖിതമസ്തി? ത്വം കീദൃക് പഠസി? ");
INSERT INTO sanmal_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","തതഃ സോവദത്, ത്വം സർവ്വാന്തഃകരണൈഃ സർവ്വപ്രാണൈഃ സർവ്വശക്തിഭിഃ സർവ്വചിത്തൈശ്ച പ്രഭൗ പരമേശ്വരേ പ്രേമ കുരു, സമീപവാസിനി സ്വവത് പ്രേമ കുരു ച| ");
INSERT INTO sanmal_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","തദാ സ കഥയാമാസ, ത്വം യഥാർഥം പ്രത്യവോചഃ, ഇത്ഥമ് ആചര തേനൈവ ജീവിഷ്യസി| ");
INSERT INTO sanmal_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","കിന്തു സ ജനഃ സ്വം നിർദ്ദോഷം ജ്ഞാപയിതും യീശും പപ്രച്ഛ, മമ സമീപവാസീ കഃ? തതോ യീശുഃ പ്രത്യുവാച, ");
INSERT INTO sanmal_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ഏകോ ജനോ യിരൂശാലമ്പുരാദ് യിരീഹോപുരം യാതി, ഏതർഹി ദസ്യൂനാം കരേഷു പതിതേ തേ തസ്യ വസ്ത്രാദികം ഹൃതവന്തഃ തമാഹത്യ മൃതപ്രായം കൃത്വാ ത്യക്ത്വാ യയുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","അകസ്മാദ് ഏകോ യാജകസ്തേന മാർഗേണ ഗച്ഛൻ തം ദൃഷ്ട്വാ മാർഗാന്യപാർശ്വേന ജഗാമ| ");
INSERT INTO sanmal_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ഇത്ഥമ് ഏകോ ലേവീയസ്തത്സ്ഥാനം പ്രാപ്യ തസ്യാന്തികം ഗത്വാ തം വിലോക്യാന്യേന പാർശ്വേന ജഗാമ| ");
INSERT INTO sanmal_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","കിന്ത്വേകഃ ശോമിരോണീയോ ഗച്ഛൻ തത്സ്ഥാനം പ്രാപ്യ തം ദൃഷ്ട്വാദയത| ");
INSERT INTO sanmal_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","തസ്യാന്തികം ഗത്വാ തസ്യ ക്ഷതേഷു തൈലം ദ്രാക്ഷാരസഞ്ച പ്രക്ഷിപ്യ ക്ഷതാനി ബദ്ധ്വാ നിജവാഹനോപരി തമുപവേശ്യ പ്രവാസീയഗൃഹമ് ആനീയ തം സിഷേവേ| ");
INSERT INTO sanmal_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","പരസ്മിൻ ദിവസേ നിജഗമനകാലേ ദ്വൗ മുദ്രാപാദൗ തദ്ഗൃഹസ്വാമിനേ ദത്ത്വാവദത് ജനമേനം സേവസ്വ തത്ര യോഽധികോ വ്യയോ ഭവിഷ്യതി തമഹം പുനരാഗമനകാലേ പരിശോത്സ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","ഏഷാം ത്രയാണാം മധ്യേ തസ്യ ദസ്യുഹസ്തപതിതസ്യ ജനസ്യ സമീപവാസീ കഃ? ത്വയാ കിം ബുധ്യതേ? ");
INSERT INTO sanmal_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","തതഃ സ വ്യവസ്ഥാപകഃ കഥയാമാസ യസ്തസ്മിൻ ദയാം ചകാര| തദാ യീശുഃ കഥയാമാസ ത്വമപി ഗത്വാ തഥാചര| ");
INSERT INTO sanmal_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","തതഃ പരം തേ ഗച്ഛന്ത ഏകം ഗ്രാമം പ്രവിവിശുഃ; തദാ മർഥാനാമാ സ്ത്രീ സ്വഗൃഹേ തസ്യാതിഥ്യം ചകാര| ");
INSERT INTO sanmal_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","തസ്മാത് മരിയമ് നാമധേയാ തസ്യാ ഭഗിനീ യീശോഃ പദസമീപ ഉവവിശ്യ തസ്യോപദേശകഥാം ശ്രോതുമാരേഭേ| ");
INSERT INTO sanmal_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","കിന്തു മർഥാ നാനാപരിചര്യ്യായാം വ്യഗ്രാ ബഭൂവ തസ്മാദ്ധേതോസ്തസ്യ സമീപമാഗത്യ ബഭാഷേ; ഹേ പ്രഭോ മമ ഭഗിനീ കേവലം മമോപരി സർവ്വകർമ്മണാം ഭാരമ് അർപിതവതീ തത്ര ഭവതാ കിഞ്ചിദപി ന മനോ നിധീയതേ കിമ്? മമ സാഹായ്യം കർത്തും ഭവാൻ താമാദിശതു| ");
INSERT INTO sanmal_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","തതോ യീശുഃ പ്രത്യുവാച ഹേ മർഥേ ഹേ മർഥേ, ത്വം നാനാകാര്യ്യേഷു ചിന്തിതവതീ വ്യഗ്രാ ചാസി, ");
INSERT INTO sanmal_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","കിന്തു പ്രയോജനീയമ് ഏകമാത്രമ് ആസ്തേ| അപരഞ്ച യമുത്തമം ഭാഗം കോപി ഹർത്തും ന ശക്നോതി സഏവ മരിയമാ വൃതഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","അനന്തരം സ കസ്മിംശ്ചിത് സ്ഥാനേ പ്രാർഥയത തത്സമാപ്തൗ സത്യാം തസ്യൈകഃ ശിഷ്യസ്തം ജഗാദ ഹേ പ്രഭോ യോഹൻ യഥാ സ്വശിഷ്യാൻ പ്രാർഥയിതുമ് ഉപദിഷ്ടവാൻ തഥാ ഭവാനപ്യസ്മാൻ ഉപദിശതു| ");
INSERT INTO sanmal_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","തസ്മാത് സ കഥയാമാസ, പ്രാർഥനകാലേ യൂയമ് ഇത്ഥം കഥയധ്വം, ഹേ അസ്മാകം സ്വർഗസ്ഥപിതസ്തവ നാമ പൂജ്യം ഭവതു; തവ രാജത്വം ഭവതു; സ്വർഗേ യഥാ തഥാ പൃഥിവ്യാമപി തവേച്ഛയാ സർവ്വം ഭവതു| ");
INSERT INTO sanmal_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","പ്രത്യഹമ് അസ്മാകം പ്രയോജനീയം ഭോജ്യം ദേഹി| ");
INSERT INTO sanmal_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","യഥാ വയം സർവ്വാൻ അപരാധിനഃ ക്ഷമാമഹേ തഥാ ത്വമപി പാപാന്യസ്മാകം ക്ഷമസ്വ| അസ്മാൻ പരീക്ഷാം മാനയ കിന്തു പാപാത്മനോ രക്ഷ| ");
INSERT INTO sanmal_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","പശ്ചാത് സോപരമപി കഥിതവാൻ യദി യുഷ്മാകം കസ്യചിദ് ബന്ധുസ്തിഷ്ഠതി നിശീഥേ ച തസ്യ സമീപം സ ഗത്വാ വദതി, ");
INSERT INTO sanmal_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ഹേ ബന്ധോ പഥിക ഏകോ ബന്ധു ർമമ നിവേശനമ് ആയാതഃ കിന്തു തസ്യാതിഥ്യം കർത്തും മമാന്തികേ കിമപി നാസ്തി, അതഏവ പൂപത്രയം മഹ്യമ് ഋണം ദേഹി; ");
INSERT INTO sanmal_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","തദാ സ യദി ഗൃഹമധ്യാത് പ്രതിവദതി മാം മാ ക്ലിശാന, ഇദാനീം ദ്വാരം രുദ്ധം ശയനേ മയാ സഹ ബാലകാശ്ച തിഷ്ഠന്തി തുഭ്യം ദാതുമ് ഉത്ഥാതും ന ശക്നോമി, ");
INSERT INTO sanmal_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","തർഹി യുഷ്മാനഹം വദാമി, സ യദി മിത്രതയാ തസ്മൈ കിമപി ദാതും നോത്തിഷ്ഠതി തഥാപി വാരം വാരം പ്രാർഥനാത ഉത്ഥാപിതഃ സൻ യസ്മിൻ തസ്യ പ്രയോജനം തദേവ ദാസ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","അതഃ കാരണാത് കഥയാമി, യാചധ്വം തതോ യുഷ്മഭ്യം ദാസ്യതേ, മൃഗയധ്വം തത ഉദ്ദേശം പ്രാപ്സ്യഥ, ദ്വാരമ് ആഹത തതോ യുഷ്മഭ്യം ദ്വാരം മോക്ഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","യോ യാചതേ സ പ്രാപ്നോതി, യോ മൃഗയതേ സ ഏവോദ്ദേശം പ്രാപ്നോതി, യോ ദ്വാരമ് ആഹന്തി തദർഥം ദ്വാരം മോച്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","പുത്രേണ പൂപേ യാചിതേ തസ്മൈ പാഷാണം ദദാതി വാ മത്സ്യേ യാചിതേ തസ്മൈ സർപം ദദാതി ");
INSERT INTO sanmal_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","വാ അണ്ഡേ യാചിതേ തസ്മൈ വൃശ്ചികം ദദാതി യുഷ്മാകം മധ്യേ ക ഏതാദൃശഃ പിതാസ്തേ? ");
INSERT INTO sanmal_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","തസ്മാദേവ യൂയമഭദ്രാ അപി യദി സ്വസ്വബാലകേഭ്യ ഉത്തമാനി ദ്രവ്യാണി ദാതും ജാനീഥ തർഹ്യസ്മാകം സ്വർഗസ്ഥഃ പിതാ നിജയാചകേഭ്യഃ കിം പവിത്രമ് ആത്മാനം ന ദാസ്യതി? ");
INSERT INTO sanmal_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","അനന്തരം യീശുനാ കസ്മാച്ചിദ് ഏകസ്മിൻ മൂകഭൂതേ ത്യാജിതേ സതി സ ഭൂതത്യക്തോ മാനുഷോ വാക്യം വക്തുമ് ആരേഭേ; തതോ ലോകാഃ സകലാ ആശ്ചര്യ്യം മേനിരേ| ");
INSERT INTO sanmal_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","കിന്തു തേഷാം കേചിദൂചു ർജനോയം ബാലസിബൂബാ അർഥാദ് ഭൂതരാജേന ഭൂതാൻ ത്യാജയതി| ");
INSERT INTO sanmal_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","തം പരീക്ഷിതും കേചിദ് ആകാശീയമ് ഏകം ചിഹ്നം ദർശയിതും തം പ്രാർഥയാഞ്ചക്രിരേ| ");
INSERT INTO sanmal_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","തദാ സ തേഷാം മനഃകൽപനാം ജ്ഞാത്വാ കഥയാമാസ, കസ്യചിദ് രാജ്യസ്യ ലോകാ യദി പരസ്പരം വിരുന്ധന്തി തർഹി തദ് രാജ്യമ് നശ്യതി; കേചിദ് ഗൃഹസ്ഥാ യദി പരസ്പരം വിരുന്ധന്തി തർഹി തേപി നശ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","തഥൈവ ശൈതാനപി സ്വലോകാൻ യദി വിരുണദ്ധി തദാ തസ്യ രാജ്യം കഥം സ്ഥാസ്യതി? ബാലസിബൂബാഹം ഭൂതാൻ ത്യാജയാമി യൂയമിതി വദഥ| ");
INSERT INTO sanmal_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","യദ്യഹം ബാലസിബൂബാ ഭൂതാൻ ത്യാജയാമി തർഹി യുഷ്മാകം സന്താനാഃ കേന ത്യാജയന്തി? തസ്മാത് തഏവ കഥായാ ഏതസ്യാ വിചാരയിതാരോ ഭവിഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","കിന്തു യദ്യഹമ് ഈശ്വരസ്യ പരാക്രമേണ ഭൂതാൻ ത്യാജയാമി തർഹി യുഷ്മാകം നികടമ് ഈശ്വരസ്യ രാജ്യമവശ്യമ് ഉപതിഷ്ഠതി| ");
INSERT INTO sanmal_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","ബലവാൻ പുമാൻ സുസജ്ജമാനോ യതികാലം നിജാട്ടാലികാം രക്ഷതി തതികാലം തസ്യ ദ്രവ്യം നിരുപദ്രവം തിഷ്ഠതി| ");
INSERT INTO sanmal_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","കിന്തു തസ്മാദ് അധികബലഃ കശ്ചിദാഗത്യ യദി തം ജയതി തർഹി യേഷു ശസ്ത്രാസ്ത്രേഷു തസ്യ വിശ്വാസ ആസീത് താനി സർവ്വാണി ഹൃത്വാ തസ്യ ദ്രവ്യാണി ഗൃഹ്ലാതി| ");
INSERT INTO sanmal_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","അതഃ കാരണാദ് യോ മമ സപക്ഷോ ന സ വിപക്ഷഃ, യോ മയാ സഹ ന സംഗൃഹ്ലാതി സ വികിരതി| ");
INSERT INTO sanmal_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","അപരഞ്ച അമേധ്യഭൂതോ മാനുഷസ്യാന്തർനിർഗത്യ ശുഷ്കസ്ഥാനേ ഭ്രാന്ത്വാ വിശ്രാമം മൃഗയതേ കിന്തു ന പ്രാപ്യ വദതി മമ യസ്മാദ് ഗൃഹാദ് ആഗതോഹം പുനസ്തദ് ഗൃഹം പരാവൃത്യ യാമി| ");
INSERT INTO sanmal_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","തതോ ഗത്വാ തദ് ഗൃഹം മാർജിതം ശോഭിതഞ്ച ദൃഷ്ട്വാ ");
INSERT INTO sanmal_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","തത്ക്ഷണമ് അപഗത്യ സ്വസ്മാദപി ദുർമ്മതീൻ അപരാൻ സപ്തഭൂതാൻ സഹാനയതി തേ ച തദ്ഗൃഹം പവിശ്യ നിവസന്തി| തസ്മാത് തസ്യ മനുഷ്യസ്യ പ്രഥമദശാതഃ ശേഷദശാ ദുഃഖതരാ ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","അസ്യാഃ കഥായാഃ കഥനകാലേ ജനതാമധ്യസ്ഥാ കാചിന്നാരീ തമുച്ചൈഃസ്വരം പ്രോവാച, യാ യോഷിത് ത്വാം ഗർബ്ഭേഽധാരയത് സ്തന്യമപായയച്ച സൈവ ധന്യാ| ");
INSERT INTO sanmal_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","കിന്തു സോകഥയത് യേ പരമേശ്വരസ്യ കഥാം ശ്രുത്വാ തദനുരൂപമ് ആചരന്തി തഏവ ധന്യാഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","തതഃ പരം തസ്യാന്തികേ ബഹുലോകാനാം സമാഗമേ ജാതേ സ വക്തുമാരേഭേ, ആധുനികാ ദുഷ്ടലോകാശ്ചിഹ്നം ദ്രഷ്ടുമിച്ഛന്തി കിന്തു യൂനസ്ഭവിഷ്യദ്വാദിനശ്ചിഹ്നം വിനാന്യത് കിഞ്ചിച്ചിഹ്നം താൻ ന ദർശയിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","യൂനസ് തു യഥാ നീനിവീയലോകാനാം സമീപേ ചിഹ്നരൂപോഭവത് തഥാ വിദ്യമാനലോകാനാമ് ഏഷാം സമീപേ മനുഷ്യപുത്രോപി ചിഹ്നരൂപോ ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","വിചാരസമയേ ഇദാനീന്തനലോകാനാം പ്രാതികൂല്യേന ദക്ഷിണദേശീയാ രാജ്ഞീ പ്രോത്ഥായ താൻ ദോഷിണഃ കരിഷ്യതി, യതഃ സാ രാജ്ഞീ സുലേമാന ഉപദേശകഥാം ശ്രോതും പൃഥിവ്യാഃ സീമാത ആഗച്ഛത് കിന്തു പശ്യത സുലേമാനോപി ഗുരുതര ഏകോ ജനോഽസ്മിൻ സ്ഥാനേ വിദ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","അപരഞ്ച വിചാരസമയേ നീനിവീയലോകാ അപി വർത്തമാനകാലികാനാം ലോകാനാം വൈപരീത്യേന പ്രോത്ഥായ താൻ ദോഷിണഃ കരിഷ്യന്തി, യതോ ഹേതോസ്തേ യൂനസോ വാക്യാത് ചിത്താനി പരിവർത്തയാമാസുഃ കിന്തു പശ്യത യൂനസോതിഗുരുതര ഏകോ ജനോഽസ്മിൻ സ്ഥാനേ വിദ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","പ്രദീപം പ്രജ്വാല്യ ദ്രോണസ്യാധഃ കുത്രാപി ഗുപ്തസ്ഥാനേ വാ കോപി ന സ്ഥാപയതി കിന്തു ഗൃഹപ്രവേശിഭ്യോ ദീപ്തിം ദാതം ദീപാധാരോപര്യ്യേവ സ്ഥാപയതി| ");
INSERT INTO sanmal_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","ദേഹസ്യ പ്രദീപശ്ചക്ഷുസ്തസ്മാദേവ ചക്ഷു ര്യദി പ്രസന്നം ഭവതി തർഹി തവ സർവ്വശരീരം ദീപ്തിമദ് ഭവിഷ്യതി കിന്തു ചക്ഷു ര്യദി മലീമസം തിഷ്ഠതി തർഹി സർവ്വശരീരം സാന്ധകാരം സ്ഥാസ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","അസ്മാത് കാരണാത് തവാന്തഃസ്ഥം ജ്യോതി ര്യഥാന്ധകാരമയം ന ഭവതി തദർഥേ സാവധാനോ ഭവ| ");
INSERT INTO sanmal_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","യതഃ ശരീരസ്യ കുത്രാപ്യംശേ സാന്ധകാരേ ന ജാതേ സർവ്വം യദി ദീപ്തിമത് തിഷ്ഠതി തർഹി തുഭ്യം ദീപ്തിദായിപ്രോജ്ജ്വലൻ പ്രദീപ ഇവ തവ സവർവശരീരം ദീപ്തിമദ് ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ഏതത്കഥായാഃ കഥനകാലേ ഫിരുശ്യേകോ ഭേജനായ തം നിമന്ത്രയാമാസ, തതഃ സ ഗത്വാ ഭോക്തുമ് ഉപവിവേശ| ");
INSERT INTO sanmal_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","കിന്തു ഭോജനാത് പൂർവ്വം നാമാങ്ക്ഷീത് ഏതദ് ദൃഷ്ട്വാ സ ഫിരുശ്യാശ്ചര്യ്യം മേനേ| ");
INSERT INTO sanmal_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","തദാ പ്രഭുസ്തം പ്രോവാച യൂയം ഫിരൂശിലോകാഃ പാനപാത്രാണാം ഭോജനപാത്രാണാഞ്ച ബഹിഃ പരിഷ്കുരുഥ കിന്തു യുഷ്മാകമന്ത ർദൗരാത്മ്യൈ ർദുഷ്ക്രിയാഭിശ്ച പരിപൂർണം തിഷ്ഠതി| ");
INSERT INTO sanmal_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ഹേ സർവ്വേ നിർബോധാ യോ ബഹിഃ സസർജ സ ഏവ കിമന്ത ർന സസർജ? ");
INSERT INTO sanmal_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","തത ഏവ യുഷ്മാഭിരന്തഃകരണം (ഈശ്വരായ) നിവേദ്യതാം തസ്മിൻ കൃതേ യുഷ്മാകം സർവ്വാണി ശുചിതാം യാസ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","കിന്തു ഹന്ത ഫിരൂശിഗണാ യൂയം ന്യായമ് ഈശ്വരേ പ്രേമ ച പരിത്യജ്യ പോദിനായാ അരുദാദീനാം സർവ്വേഷാം ശാകാനാഞ്ച ദശമാംശാൻ ദത്ഥ കിന്തു പ്രഥമം പാലയിത്വാ ശേഷസ്യാലങ്ഘനം യുഷ്മാകമ് ഉചിതമാസീത്| ");
INSERT INTO sanmal_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","ഹാ ഹാ ഫിരൂശിനോ യൂയം ഭജനഗേഹേ പ്രോച്ചാസനേ ആപണേഷു ച നമസ്കാരേഷു പ്രീയധ്വേ| ");
INSERT INTO sanmal_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","വത കപടിനോഽധ്യാപകാഃ ഫിരൂശിനശ്ച ലോകായത് ശ്മശാനമ് അനുപലഭ്യ തദുപരി ഗച്ഛന്തി യൂയമ് താദൃഗപ്രകാശിതശ്മശാനവാദ് ഭവഥ| ");
INSERT INTO sanmal_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","തദാനീം വ്യവസ്ഥാപകാനാമ് ഏകാ യീശുമവദത്, ഹേ ഉപദേശക വാക്യേനേദൃശേനാസ്മാസ്വപി ദോഷമ് ആരോപയസി| ");
INSERT INTO sanmal_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","തതഃ സ ഉവാച, ഹാ ഹാ വ്യവസ്ഥാപകാ യൂയമ് മാനുഷാണാമ് ഉപരി ദുഃസഹ്യാൻ ഭാരാൻ ന്യസ്യഥ കിന്തു സ്വയമ് ഏകാങ്ഗുुല്യാപി താൻ ഭാരാൻ ന സ്പൃശഥ| ");
INSERT INTO sanmal_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","ഹന്ത യുഷ്മാകം പൂർവ്വപുരുഷാ യാൻ ഭവിഷ്യദ്വാദിനോഽവധിഷുസ്തേഷാം ശ്മശാനാനി യൂയം നിർമ്മാഥ| ");
INSERT INTO sanmal_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","തേനൈവ യൂയം സ്വപൂർവ്വപുരുഷാണാം കർമ്മാണി സംമന്യധ്വേ തദേവ സപ്രമാണം കുരുഥ ച, യതസ്തേ താനവധിഷുഃ യൂയം തേഷാം ശ്മശാനാനി നിർമ്മാഥ| ");
INSERT INTO sanmal_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","അതഏവ ഈശ്വരസ്യ ശാസ്ത്രേ പ്രോക്തമസ്തി തേഷാമന്തികേ ഭവിഷ്യദ്വാദിനഃ പ്രേരിതാംശ്ച പ്രേഷയിഷ്യാമി തതസ്തേ തേഷാം കാംശ്ചന ഹനിഷ്യന്തി കാംശ്ചന താഡശ്ഷ്യിന്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ഏതസ്മാത് കാരണാത് ഹാബിലഃ ശോണിതപാതമാരഭ്യ മന്ദിരയജ്ഞവേദ്യോ ർമധ്യേ ഹതസ്യ സിഖരിയസ്യ രക്തപാതപര്യ്യന്തം ");
INSERT INTO sanmal_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ജഗതഃ സൃഷ്ടിമാരഭ്യ പൃഥിവ്യാം ഭവിഷ്യദ്വാദിനാം യതിരക്തപാതാ ജാതാസ്തതീനാമ് അപരാധദണ്ഡാ ഏഷാം വർത്തമാനലോകാനാം ഭവിഷ്യന്തി, യുഷ്മാനഹം നിശ്ചിതം വദാമി സർവ്വേ ദണ്ഡാ വംശസ്യാസ്യ ഭവിഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","ഹാ ഹാ വ്യവസ്ഥപകാ യൂയം ജ്ഞാനസ്യ കുഞ്ചികാം ഹൃത്വാ സ്വയം ന പ്രവിഷ്ടാ യേ പ്രവേഷ്ടുഞ്ച പ്രയാസിനസ്താനപി പ്രവേഷ്ടും വാരിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ഇത്ഥം കഥാകഥനാദ് അധ്യാപകാഃ ഫിരൂശിനശ്ച സതർകാഃ ");
INSERT INTO sanmal_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","സന്തസ്തമപവദിതും തസ്യ കഥായാ ദോഷം ധർത്തമിച്ഛന്തോ നാനാഖ്യാനകഥനായ തം പ്രവർത്തയിതും കോപയിതുഞ്ച പ്രാരേഭിരേ| ");
INSERT INTO sanmal_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","തദാനീം ലോകാഃ സഹസ്രം സഹസ്രമ് ആഗത്യ സമുപസ്ഥിതാസ്തത ഏകൈകോ ഽന്യേഷാമുപരി പതിതുമ് ഉപചക്രമേ; തദാ യീശുഃ ശിഷ്യാൻ ബഭാഷേ, യൂയം ഫിരൂശിനാം കിണ്വരൂപകാപട്യേ വിശേഷേണ സാവധാനാസ്തിഷ്ഠത| ");
INSERT INTO sanmal_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","യതോ യന്ന പ്രകാശയിഷ്യതേ തദാച്ഛന്നം വസ്തു കിമപി നാസ്തി; തഥാ യന്ന ജ്ഞാസ്യതേ തദ് ഗുപ്തം വസ്തു കിമപി നാസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","അന്ധകാരേ തിഷ്ഠനതോ യാഃ കഥാ അകഥയത താഃ സർവ്വാഃ കഥാ ദീപ്തൗ ശ്രോഷ്യന്തേ നിർജനേ കർണേ ച യദകഥയത ഗൃഹപൃഷ്ഠാത് തത് പ്രചാരയിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","ഹേ ബന്ധവോ യുഷ്മാനഹം വദാമി, യേ ശരീരസ്യ നാശം വിനാ കിമപ്യപരം കർത്തും ന ശക്രുവന്തി തേഭ്യോ മാ ഭൈഷ്ട| ");
INSERT INTO sanmal_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","തർഹി കസ്മാദ് ഭേതവ്യമ് ഇത്യഹം വദാമി, യഃ ശരീരം നാശയിത്വാ നരകം നിക്ഷേപ്തും ശക്നോതി തസ്മാദേവ ഭയം കുരുത, പുനരപി വദാമി തസ്മാദേവ ഭയം കുരുത| ");
INSERT INTO sanmal_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","പഞ്ച ചടകപക്ഷിണഃ കിം ദ്വാഭ്യാം താമ്രഖണ്ഡാഭ്യാം ന വിക്രീയന്തേ? തഥാപീശ്വരസ്തേഷാമ് ഏകമപി ന വിസ്മരതി| ");
INSERT INTO sanmal_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","യുഷ്മാകം ശിരഃകേശാ അപി ഗണിതാഃ സന്തി തസ്മാത് മാ വിഭീത ബഹുചടകപക്ഷിഭ്യോപി യൂയം ബഹുമൂല്യാഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","അപരം യുഷ്മഭ്യം കഥയാമി യഃ കശ്ചിൻ മാനുഷാണാം സാക്ഷാൻ മാം സ്വീകരോതി മനുഷ്യപുത്ര ഈശ്വരദൂതാനാം സാക്ഷാത് തം സ്വീകരിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","കിന്തു യഃ കശ്ചിന്മാനുഷാണാം സാക്ഷാന്മാമ് അസ്വീകരോതി തമ് ഈശ്വരസ്യ ദൂതാനാം സാക്ഷാദ് അഹമ് അസ്വീകരിഷ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","അന്യച്ച യഃ കശ്ചിൻ മനുജസുതസ്യ നിന്ദാഭാവേന കാഞ്ചിത് കഥാം കഥയതി തസ്യ തത്പാപസ്യ മോചനം ഭവിഷ്യതി കിന്തു യദി കശ്ചിത് പവിത്രമ് ആത്മാനം നിന്ദതി തർഹി തസ്യ തത്പാപസ്യ മോചനം ന ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","യദാ ലോകാ യുഷ്മാൻ ഭജനഗേഹം വിചാരകർതൃരാജ്യകർതൃണാം സമ്മുഖഞ്ച നേഷ്യന്തി തദാ കേന പ്രകാരേണ കിമുത്തരം വദിഷ്യഥ കിം കഥയിഷ്യഥ ചേത്യത്ര മാ ചിന്തയത; ");
INSERT INTO sanmal_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","യതോ യുഷ്മാഭിര്യദ് യദ് വക്തവ്യം തത് തസ്മിൻ സമയഏവ പവിത്ര ആത്മാ യുഷ്മാൻ ശിക്ഷയിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","തതഃ പരം ജനതാമധ്യസ്ഥഃ കശ്ചിജ്ജനസ്തം ജഗാദ ഹേ ഗുരോ മയാ സഹ പൈതൃകം ധനം വിഭക്തും മമ ഭ്രാതരമാജ്ഞാപയതു ഭവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","കിന്തു സ തമവദത് ഹേ മനുഷ്യ യുവയോ ർവിചാരം വിഭാഗഞ്ച കർത്തും മാം കോ നിയുക്തവാൻ? ");
INSERT INTO sanmal_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","അനന്തരം സ ലോകാനവദത് ലോഭേ സാവധാനാഃ സതർകാശ്ച തിഷ്ഠത, യതോ ബഹുസമ്പത്തിപ്രാപ്ത്യാ മനുഷ്യസ്യായു ർന ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","പശ്ചാദ് ദൃഷ്ടാന്തകഥാമുത്ഥാപ്യ കഥയാമാസ, ഏകസ്യ ധനിനോ ഭൂമൗ ബഹൂനി ശസ്യാനി ജാതാനി| ");
INSERT INTO sanmal_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","തതഃ സ മനസാ ചിന്തയിത്വാ കഥയാമ്ബഭൂവ മമൈതാനി സമുത്പന്നാനി ദ്രവ്യാണി സ്ഥാപയിതും സ്ഥാനം നാസ്തി കിം കരിഷ്യാമി? ");
INSERT INTO sanmal_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","തതോവദദ് ഇത്ഥം കരിഷ്യാമി, മമ സർവ്വഭാണ്ഡാഗാരാണി ഭങ്ക്ത്വാ ബൃഹദ്ഭാണ്ഡാഗാരാണി നിർമ്മായ തന്മധ്യേ സർവ്വഫലാനി ദ്രവ്യാണി ച സ്ഥാപയിഷ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","അപരം നിജമനോ വദിഷ്യാമി, ഹേ മനോ ബഹുവത്സരാർഥം നാനാദ്രവ്യാണി സഞ്ചിതാനി സന്തി വിശ്രാമം കുരു ഭുക്ത്വാ പീത്വാ കൗതുകഞ്ച കുരു| കിന്ത്വീശ്വരസ്തമ് അവദത്, ");
INSERT INTO sanmal_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","രേ നിർബോധ അദ്യ രാത്രൗ തവ പ്രാണാസ്ത്വത്തോ നേഷ്യന്തേ തത ഏതാനി യാനി ദ്രവ്യാണി ത്വയാസാദിതാനി താനി കസ്യ ഭവിഷ്യന്തി? ");
INSERT INTO sanmal_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","അതഏവ യഃ കശ്ചിദ് ഈശ്വരസ്യ സമീപേ ധനസഞ്ചയമകൃത്വാ കേവലം സ്വനികടേ സഞ്ചയം കരോതി സോപി താദൃശഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","അഥ സ ശിഷ്യേഭ്യഃ കഥയാമാസ, യുഷ്മാനഹം വദാമി, കിം ഖാദിഷ്യാമഃ? കിം പരിധാസ്യാമഃ? ഇത്യുക്ത്വാ ജീവനസ്യ ശരീരസ്യ ചാർഥം ചിന്താം മാ കാർഷ്ട| ");
INSERT INTO sanmal_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ഭക്ഷ്യാജ്ജീവനം ഭൂഷണാച്ഛരീരഞ്ച ശ്രേഷ്ഠം ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","കാകപക്ഷിണാം കാര്യ്യം വിചാരയത, തേ ന വപന്തി ശസ്യാനി ച ന ഛിന്ദന്തി, തേഷാം ഭാണ്ഡാഗാരാണി ന സന്തി കോഷാശ്ച ന സന്തി, തഥാപീശ്വരസ്തേഭ്യോ ഭക്ഷ്യാണി ദദാതി, യൂയം പക്ഷിഭ്യഃ ശ്രേഷ്ഠതരാ ന കിം? ");
INSERT INTO sanmal_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","അപരഞ്ച ഭാവയിത്വാ നിജായുഷഃ ക്ഷണമാത്രം വർദ്ധയിതും ശക്നോതി, ഏതാദൃശോ ലാകോ യുഷ്മാകം മധ്യേ കോസ്തി? ");
INSERT INTO sanmal_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","അതഏവ ക്ഷുദ്രം കാര്യ്യം സാധയിതുമ് അസമർഥാ യൂയമ് അന്യസ്മിൻ കാര്യ്യേ കുതോ ഭാവയഥ? ");
INSERT INTO sanmal_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","അന്യച്ച കാമ്പിലപുഷ്പം കഥം വർദ്ധതേ തദാപി വിചാരയത, തത് കഞ്ചന ശ്രമം ന കരോതി തന്തൂംശ്ച ന ജനയതി കിന്തു യുഷ്മഭ്യം യഥാർഥം കഥയാമി സുലേമാൻ ബഹ്വൈശ്വര്യ്യാന്വിതോപി പുഷ്പസ്യാസ്യ സദൃശോ വിഭൂഷിതോ നാസീത്| ");
INSERT INTO sanmal_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","അദ്യ ക്ഷേത്രേ വർത്തമാനം ശ്വശ്ചൂല്ല്യാം ക്ഷേപ്സ്യമാനം യത് തൃണം, തസ്മൈ യദീശ്വര ഇത്ഥം ഭൂഷയതി തർഹി ഹേ അൽപപ്രത്യയിനോ യുഷ്മാന കിം ന പരിധാപയിഷ്യതി? ");
INSERT INTO sanmal_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","അതഏവ കിം ഖാദിഷ്യാമഃ? കിം പരിധാസ്യാമഃ? ഏതദർഥം മാ ചേഷ്ടധ്വം മാ സംദിഗ്ധ്വഞ്ച| ");
INSERT INTO sanmal_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ജഗതോ ദേവാർച്ചകാ ഏതാനി സർവ്വാണി ചേഷ്ടനതേ; ഏഷു വസ്തുഷു യുഷ്മാകം പ്രയോജനമാസ്തേ ഇതി യുഷ്മാകം പിതാ ജാനാതി| ");
INSERT INTO sanmal_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","അതഏവേശ്വരസ്യ രാജ്യാർഥം സചേഷ്ടാ ഭവത തഥാ കൃതേ സർവ്വാണ്യേതാനി ദ്രവ്യാണി യുഷ്മഭ്യം പ്രദായിഷ്യന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","ഹേ ക്ഷുദ്രമേഷവ്രജ യൂയം മാ ഭൈഷ്ട യുഷ്മഭ്യം രാജ്യം ദാതും യുഷ്മാകം പിതുഃ സമ്മതിരസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","അതഏവ യുഷ്മാകം യാ യാ സമ്പത്തിരസ്തി താം താം വിക്രീയ വിതരത, യത് സ്ഥാനം ചൗരാ നാഗച്ഛന്തി, കീടാശ്ച ന ക്ഷായയന്തി താദൃശേ സ്വർഗേ നിജാർഥമ് അജരേ സമ്പുടകേ ഽക്ഷയം ധനം സഞ്ചിനുത ച; ");
INSERT INTO sanmal_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","യതോ യത്ര യുഷ്മാകം ധനം വർത്തതേ തത്രേവ യുഷ്മാകം മനഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","അപരഞ്ച യൂയം പ്രദീപം ജ്വാലയിത്വാ ബദ്ധകടയസ്തിഷ്ഠത; ");
INSERT INTO sanmal_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","പ്രഭു ർവിവാഹാദാഗത്യ യദൈവ ദ്വാരമാഹന്തി തദൈവ ദ്വാരം മോചയിതും യഥാ ഭൃത്യാ അപേക്ഷ്യ തിഷ്ഠന്തി തഥാ യൂയമപി തിഷ്ഠത| ");
INSERT INTO sanmal_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","യതഃ പ്രഭുരാഗത്യ യാൻ ദാസാൻ സചേതനാൻ തിഷ്ഠതോ ദ്രക്ഷ്യതി തഏവ ധന്യാഃ; അഹം യുഷ്മാൻ യഥാർഥം വദാമി പ്രഭുസ്താൻ ഭോജനാർഥമ് ഉപവേശ്യ സ്വയം ബദ്ധകടിഃ സമീപമേത്യ പരിവേഷയിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","യദി ദ്വിതീയേ തൃതീയേ വാ പ്രഹരേ സമാഗത്യ തഥൈവ പശ്യതി, തർഹി തഏവ ദാസാ ധന്യാഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","അപരഞ്ച കസ്മിൻ ക്ഷണേ ചൗരാ ആഗമിഷ്യന്തി ഇതി യദി ഗൃഹപതി ർജ്ഞാതും ശക്നോതി തദാവശ്യം ജാഗ്രൻ നിജഗൃഹേ സന്ധിം കർത്തയിതും വാരയതി യൂയമേതദ് വിത്ത| ");
INSERT INTO sanmal_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","അതഏവ യൂയമപി സജ്ജമാനാസ്തിഷ്ഠത യതോ യസ്മിൻ ക്ഷണേ തം നാപ്രേക്ഷധ്വേ തസ്മിന്നേവ ക്ഷണേ മനുഷ്യപുത്ര ആഗമിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","തദാ പിതരഃ പപ്രച്ഛ, ഹേ പ്രഭോ ഭവാൻ കിമസ്മാൻ ഉദ്ദിശ്യ കിം സർവ്വാൻ ഉദ്ദിശ്യ ദൃഷ്ടാന്തകഥാമിമാം വദതി? ");
INSERT INTO sanmal_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","തതഃ പ്രഭുഃ പ്രോവാച, പ്രഭുഃ സമുചിതകാലേ നിജപരിവാരാർഥം ഭോജ്യപരിവേഷണായ യം തത്പദേ നിയോക്ഷ്യതി താദൃശോ വിശ്വാസ്യോ ബോദ്ധാ കർമ്മാധീശഃ കോസ്തി? ");
INSERT INTO sanmal_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","പ്രഭുരാഗത്യ യമ് ഏതാദൃശേ കർമ്മണി പ്രവൃത്തം ദ്രക്ഷ്യതി സഏവ ദാസോ ധന്യഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","അഹം യുഷ്മാൻ യഥാർഥം വദാമി സ തം നിജസർവ്വസ്വസ്യാധിപതിം കരിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","കിന്തു പ്രഭുർവിലമ്ബേനാഗമിഷ്യതി, ഇതി വിചിന്ത്യ സ ദാസോ യദി തദന്യദാസീദാസാൻ പ്രഹർത്തുമ് ഭോക്തും പാതും മദിതുഞ്ച പ്രാരഭതേ, ");
INSERT INTO sanmal_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","തർഹി യദാ പ്രഭും നാപേക്ഷിഷ്യതേ യസ്മിൻ ക്ഷണേ സോഽചേതനശ്ച സ്ഥാസ്യതി തസ്മിന്നേവ ക്ഷണേ തസ്യ പ്രഭുരാഗത്യ തം പദഭ്രഷ്ടം കൃത്വാ വിശ്വാസഹീനൈഃ സഹ തസ്യ അംശം നിരൂപയിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","യോ ദാസഃ പ്രഭേाരാജ്ഞാം ജ്ഞാത്വാപി സജ്ജിതോ ന തിഷ്ഠതി തദാജ്ഞാനുസാരേണ ച കാര്യ്യം ന കരോതി സോനേകാൻ പ്രഹാരാൻ പ്രാപ്സ്യതി; ");
INSERT INTO sanmal_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","കിന്തു യോ ജനോഽജ്ഞാത്വാ പ്രഹാരാർഹം കർമ്മ കരോതി സോൽപപ്രഹാരാൻ പ്രാപ്സ്യതി| യതോ യസ്മൈ ബാഹുല്യേന ദത്തം തസ്മാദേവ ബാഹുല്യേന ഗ്രഹീഷ്യതേ, മാനുഷാ യസ്യ നികടേ ബഹു സമർപയന്തി തസ്മാദ് ബഹു യാചന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","അഹം പൃഥിവ്യാമ് അനൈക്യരൂപം വഹ്നി നിക്ഷേപ്തുമ് ആഗതോസ്മി, സ ചേദ് ഇദാനീമേവ പ്രജ്വലതി തത്ര മമ കാ ചിന്താ? ");
INSERT INTO sanmal_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","കിന്തു യേന മജ്ജനേനാഹം മഗ്നോ ഭവിഷ്യാമി യാവത്കാലം തസ്യ സിദ്ധി ർന ഭവിഷ്യതി താവദഹം കതികഷ്ടം പ്രാപ്സ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","മേലനം കർത്തും ജഗദ് ആഗതോസ്മി യൂയം കിമിത്ഥം ബോധധ്വേ? യുഷ്മാൻ വദാമി ന തഥാ, കിന്ത്വഹം മേലനാഭാവം കർത്തുംമ് ആഗതോസ്മി| ");
INSERT INTO sanmal_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","യസ്മാദേതത്കാലമാരഭ്യ ഏകത്രസ്ഥപരിജനാനാം മധ്യേ പഞ്ചജനാഃ പൃഥഗ് ഭൂത്വാ ത്രയോ ജനാ ദ്വയോർജനയോഃ പ്രതികൂലാ ദ്വൗ ജനൗ ച ത്രയാണാം ജനാനാം പ്രതികൂലൗ ഭവിഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","പിതാ പുത്രസ്യ വിപക്ഷഃ പുത്രശ്ച പിതു ർവിപക്ഷോ ഭവിഷ്യതി മാതാ കന്യായാ വിപക്ഷാ കന്യാ ച മാതു ർവിപക്ഷാ ഭവിഷ്യതി, തഥാ ശ്വശ്രൂർബധ്വാ വിപക്ഷാ ബധൂശ്ച ശ്വശ്ര്വാ വിപക്ഷാ ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","സ ലോകേഭ്യോപരമപി കഥയാമാസ, പശ്ചിമദിശി മേഘോദ്ഗമം ദൃഷ്ട്വാ യൂയം ഹഠാദ് വദഥ വൃഷ്ടി ർഭവിഷ്യതി തതസ്തഥൈവ ജായതേ| ");
INSERT INTO sanmal_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","അപരം ദക്ഷിണതോ വായൗ വാതി സതി വദഥ നിദാഘോ ഭവിഷ്യതി തതഃ സോപി ജായതേ| ");
INSERT INTO sanmal_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","രേ രേ കപടിന ആകാശസ്യ ഭൂമ്യാശ്ച ലക്ഷണം ബോദ്ധും ശക്നുഥ, ");
INSERT INTO sanmal_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","കിന്തു കാലസ്യാസ്യ ലക്ഷണം കുതോ ബോദ്ധും ന ശക്നുഥ? യൂയഞ്ച സ്വയം കുതോ ന ന്യാഷ്യം വിചാരയഥ? ");
INSERT INTO sanmal_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","അപരഞ്ച വിവാദിനാ സാർദ്ധം വിചാരയിതുഃ സമീപം ഗച്ഛൻ പഥി തസ്മാദുദ്ധാരം പ്രാപ്തും യതസ്വ നോചേത് സ ത്വാം ധൃത്വാ വിചാരയിതുഃ സമീപം നയതി| വിചാരയിതാ യദി ത്വാം പ്രഹർത്തുഃ സമീപം സമർപയതി പ്രഹർത്താ ത്വാം കാരായാം ബധ്നാതി ");
INSERT INTO sanmal_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","തർഹി ത്വാമഹം വദാമി ത്വയാ നിഃശേഷം കപർദകേഷു ന പരിശോധിതേഷു ത്വം തതോ മുക്തിം പ്രാപ്തും ന ശക്ഷ്യസി| ");
INSERT INTO sanmal_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","അപരഞ്ച പീലാതോ യേഷാം ഗാലീലീയാനാം രക്താനി ബലീനാം രക്തൈഃ സഹാമിശ്രയത് തേഷാം ഗാലീലീയാനാം വൃത്താന്തം കതിപയജനാ ഉപസ്ഥാപ്യ യീശവേ കഥയാമാസുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","തതഃ സ പ്രത്യുവാച തേഷാം ലോകാനാമ് ഏതാദൃശീ ദുർഗതി ർഘടിതാ തത്കാരണാദ് യൂയം കിമന്യേഭ്യോ ഗാലീലീയേഭ്യോപ്യധികപാപിനസ്താൻ ബോധധ്വേ? ");
INSERT INTO sanmal_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","യുഷ്മാനഹം വദാമി തഥാ ന കിന്തു മനഃസു ന പരാവർത്തിതേഷു യൂയമപി തഥാ നംക്ഷ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","അപരഞ്ച ശീലോഹനാമ്ന ഉച്ചഗൃഹസ്യ പതനാദ് യേഽഷ്ടാദശജനാ മൃതാസ്തേ യിരൂശാലമി നിവാസിസർവ്വലോകേഭ്യോഽധികാപരാധിനഃ കിം യൂയമിത്യം ബോധധ്വേ? ");
INSERT INTO sanmal_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","യുഷ്മാനഹം വദാമി തഥാ ന കിന്തു മനഃസു ന പരിവർത്തിതേഷു യൂയമപി തഥാ നംക്ഷ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","അനന്തരം സ ഇമാം ദൃഷ്ടാന്തകഥാമകഥയദ് ഏകോ ജനോ ദ്രാക്ഷാക്ഷേത്രമധ്യ ഏകമുഡുമ്ബരവൃക്ഷം രോപിതവാൻ| പശ്ചാത് സ ആഗത്യ തസ്മിൻ ഫലാനി ഗവേഷയാമാസ, ");
INSERT INTO sanmal_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","കിന്തു ഫലാപ്രാപ്തേഃ കാരണാദ് ഉദ്യാനകാരം ഭൃത്യം ജഗാദ, പശ്യ വത്സരത്രയം യാവദാഗത്യ ഏതസ്മിന്നുഡുമ്ബരതരൗ ക്ഷലാന്യന്വിച്ഛാമി, കിന്തു നൈകമപി പ്രപ്നോമി തരുരയം കുതോ വൃഥാ സ്ഥാനം വ്യാപ്യ തിഷ്ഠതി? ഏനം ഛിന്ധി| ");
INSERT INTO sanmal_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","തതോ ഭൃത്യഃ പ്രത്യുവാച, ഹേ പ്രഭോ പുനർവർഷമേകം സ്ഥാതുമ് ആദിശ; ഏതസ്യ മൂലസ്യ ചതുർദിക്ഷു ഖനിത്വാഹമ് ആലവാലം സ്ഥാപയാമി| ");
INSERT INTO sanmal_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","തതഃ ഫലിതും ശക്നോതി യദി ന ഫലതി തർഹി പശ്ചാത് ഛേത്സ്യസി| ");
INSERT INTO sanmal_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","അഥ വിശ്രാമവാരേ ഭജനഗേഹേ യീശുരുപദിശതി ");
INSERT INTO sanmal_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","തസ്മിത് സമയേ ഭൂതഗ്രസ്തത്വാത് കുബ്ജീഭൂയാഷ്ടാദശവർഷാണി യാവത് കേനാപ്യുപായേന ഋജു ർഭവിതും ന ശക്നോതി യാ ദുർബ്ബലാ സ്ത്രീ, ");
INSERT INTO sanmal_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","താം തത്രോപസ്ഥിതാം വിലോക്യ യീശുസ്താമാഹൂയ കഥിതവാൻ ഹേ നാരി തവ ദൗർബ്ബല്യാത് ത്വം മുക്താ ഭവ| ");
INSERT INTO sanmal_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","തതഃ പരം തസ്യാ ഗാത്രേ ഹസ്താർപണമാത്രാത് സാ ഋജുർഭൂത്വേശ്വരസ്യ ധന്യവാദം കർത്തുമാരേഭേ| ");
INSERT INTO sanmal_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","കിന്തു വിശ്രാമവാരേ യീശുനാ തസ്യാഃ സ്വാസ്ഥ്യകരണാദ് ഭജനഗേഹസ്യാധിപതിഃ പ്രകുപ്യ ലോകാൻ ഉവാച, ഷട്സു ദിനേഷു ലോകൈഃ കർമ്മ കർത്തവ്യം തസ്മാദ്ധേതോഃ സ്വാസ്ഥ്യാർഥം തേഷു ദിനേഷു ആഗച്ഛത, വിശ്രാമവാരേ മാഗച്ഛത| ");
INSERT INTO sanmal_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","തദാ പഭുഃ പ്രത്യുവാച രേ കപടിനോ യുഷ്മാകമ് ഏകൈകോ ജനോ വിശ്രാമവാരേ സ്വീയം സ്വീയം വൃഷഭം ഗർദഭം വാ ബന്ധനാന്മോചയിത്വാ ജലം പായയിതും കിം ന നയതി? ");
INSERT INTO sanmal_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","തർഹ്യാഷ്ടാദശവത്സരാൻ യാവത് ശൈതാനാ ബദ്ധാ ഇബ്രാഹീമഃ സന്തതിരിയം നാരീ കിം വിശ്രാമവാരേ ന മോചയിതവ്യാ? ");
INSERT INTO sanmal_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ഏഷു വാക്യേഷു കഥിതേഷു തസ്യ വിപക്ഷാഃ സലജ്ജാ ജാതാഃ കിന്തു തേന കൃതസർവ്വമഹാകർമ്മകാരണാത് ലോകനിവഹഃ സാനന്ദോഽഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","അനന്തരം സോവദദ് ഈശ്വരസ്യ രാജ്യം കസ്യ സദൃശം? കേന തദുപമാസ്യാമി? ");
INSERT INTO sanmal_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","യത് സർഷപബീജം ഗൃഹീത്വാ കശ്ചിജ്ജന ഉദ്യാന ഉപ്തവാൻ തദ് ബീജമങ്കുരിതം സത് മഹാവൃക്ഷോഽജായത, തതസ്തസ്യ ശാഖാസു വിഹായസീയവിഹഗാ ആഗത്യ ന്യൂഷുഃ, തദ്രാജ്യം താദൃശേന സർഷപബീജേന തുല്യം| ");
INSERT INTO sanmal_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","പുനഃ കഥയാമാസ, ഈശ്വരസ്യ രാജ്യം കസ്യ സദൃശം വദിഷ്യാമി? യത് കിണ്വം കാചിത് സ്ത്രീ ഗൃഹീത്വാ ദ്രോണത്രയപരിമിതഗോധൂമചൂർണേഷു സ്ഥാപയാമാസ, ");
INSERT INTO sanmal_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","തതഃ ക്രമേണ തത് സർവ്വഗോധൂമചൂർണം വ്യാപ്നോതി, തസ്യ കിണ്വസ്യ തുല്യമ് ഈശ്വരസ്യ രാജ്യം| ");
INSERT INTO sanmal_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","തതഃ സ യിരൂശാലമ്നഗരം പ്രതി യാത്രാം കൃത്വാ നഗരേ നഗരേ ഗ്രാമേ ഗ്രാമേ സമുപദിശൻ ജഗാമ| ");
INSERT INTO sanmal_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","തദാ കശ്ചിജ്ജനസ്തം പപ്രച്ഛ, ഹേ പ്രഭോ കിം കേവലമ് അൽപേ ലോകാഃ പരിത്രാസ്യന്തേ? ");
INSERT INTO sanmal_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","തതഃ സ ലോകാൻ ഉവാച, സംകീർണദ്വാരേണ പ്രവേഷ്ടും യതഘ്വം, യതോഹം യുഷ്മാൻ വദാമി, ബഹവഃ പ്രവേഷ്ടും ചേഷ്ടിഷ്യന്തേ കിന്തു ന ശക്ഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ഗൃഹപതിനോത്ഥായ ദ്വാരേ രുദ്ധേ സതി യദി യൂയം ബഹിഃ സ്ഥിത്വാ ദ്വാരമാഹത്യ വദഥ, ഹേ പ്രഭോ ഹേ പ്രഭോ അസ്മത്കാരണാദ് ദ്വാരം മോചയതു, തതഃ സ ഇതി പ്രതിവക്ഷ്യതി, യൂയം കുത്രത്യാ ലോകാ ഇത്യഹം ന ജാനാമി| ");
INSERT INTO sanmal_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","തദാ യൂയം വദിഷ്യഥ, തവ സാക്ഷാദ് വയം ഭേाജനം പാനഞ്ച കൃതവന്തഃ, ത്വഞ്ചാസ്മാകം നഗരസ്യ പഥി സമുപദിഷ്ടവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","കിന്തു സ വക്ഷ്യതി, യുഷ്മാനഹം വദാമി, യൂയം കുത്രത്യാ ലോകാ ഇത്യഹം ന ജാനാമി; ഹേ ദുരാചാരിണോ യൂയം മത്തോ ദൂരീഭവത| ");
INSERT INTO sanmal_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","തദാ ഇബ്രാഹീമം ഇസ്ഹാകം യാകൂബഞ്ച സർവ്വഭവിഷ്യദ്വാദിനശ്ച ഈശ്വരസ്യ രാജ്യം പ്രാപ്താൻ സ്വാംശ്ച ബഹിഷ്കൃതാൻ ദൃഷ്ട്വാ യൂയം രോദനം ദന്തൈർദന്തഘർഷണഞ്ച കരിഷ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","അപരഞ്ച പൂർവ്വപശ്ചിമദക്ഷിണോത്തരദിഗ്ഭ്യോ ലോകാ ആഗത്യ ഈശ്വരസ്യ രാജ്യേ നിവത്സ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","പശ്യതേത്ഥം ശേഷീയാ ലോകാ അഗ്രാ ഭവിഷ്യന്തി, അഗ്രീയാ ലോകാശ്ച ശേഷാ ഭവിഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","അപരഞ്ച തസ്മിൻ ദിനേ കിയന്തഃ ഫിരൂശിന ആഗത്യ യീശും പ്രോചുഃ, ബഹിർഗച്ഛ, സ്ഥാനാദസ്മാത് പ്രസ്ഥാനം കുരു, ഹേരോദ് ത്വാം ജിഘാംസതി| ");
INSERT INTO sanmal_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","തതഃ സ പ്രത്യവോചത് പശ്യതാദ്യ ശ്വശ്ച ഭൂതാൻ വിഹാപ്യ രോഗിണോഽരോഗിണഃ കൃത്വാ തൃതീയേഹ്നി സേത്സ്യാമി, കഥാമേതാം യൂയമിത്വാ തം ഭൂരിമായം വദത| ");
INSERT INTO sanmal_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","തത്രാപ്യദ്യ ശ്വഃ പരശ്വശ്ച മയാ ഗമനാഗമനേ കർത്തവ്യേ, യതോ ഹേതോ ര്യിരൂശാലമോ ബഹിഃ കുത്രാപി കോപി ഭവിഷ്യദ്വാദീ ന ഘാനിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","ഹേ യിരൂശാലമ് ഹേ യിരൂശാലമ് ത്വം ഭവിഷ്യദ്വാദിനോ ഹംസി തവാന്തികേ പ്രേരിതാൻ പ്രസ്തരൈർമാരയസി ച, യഥാ കുക്കുടീ നിജപക്ഷാധഃ സ്വശാവകാൻ സംഗൃഹ്ലാതി, തഥാഹമപി തവ ശിശൂൻ സംഗ്രഹീതും കതിവാരാൻ ഐച്ഛം കിന്തു ത്വം നൈച്ഛഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","പശ്യത യുഷ്മാകം വാസസ്ഥാനാനി പ്രോച്ഛിദ്യമാനാനി പരിത്യക്താനി ച ഭവിഷ്യന്തി; യുഷ്മാനഹം യഥാർഥം വദാമി, യഃ പ്രഭോ ർനാമ്നാഗച്ഛതി സ ധന്യ ഇതി വാചം യാവത്കാലം ന വദിഷ്യഥ, താവത്കാലം യൂയം മാം ന ദ്രക്ഷ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","അനന്തരം വിശ്രാമവാരേ യീശൗ പ്രധാനസ്യ ഫിരൂശിനോ ഗൃഹേ ഭോക്തും ഗതവതി തേ തം വീക്ഷിതുമ് ആരേഭിരേ| ");
INSERT INTO sanmal_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","തദാ ജലോദരീ തസ്യ സമ്മുഖേ സ്ഥിതഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","തതഃ സ വ്യവസ്ഥാപകാൻ ഫിരൂശിനശ്ച പപ്രച്ഛ, വിശ്രാമവാരേ സ്വാസ്ഥ്യം കർത്തവ്യം ന വാ? തതസ്തേ കിമപി ന പ്രത്യൂചുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","തദാ സ തം രോഗിണം സ്വസ്ഥം കൃത്വാ വിസസർജ; ");
INSERT INTO sanmal_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","താനുവാച ച യുഷ്മാകം കസ്യചിദ് ഗർദ്ദഭോ വൃഷഭോ വാ ചേദ് ഗർത്തേ പതതി തർഹി വിശ്രാമവാരേ തത്ക്ഷണം സ കിം തം നോത്ഥാപയിഷ്യതി? ");
INSERT INTO sanmal_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","തതസ്തേ കഥായാ ഏതസ്യാഃ കിമപി പ്രതിവക്തും ന ശേകുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","അപരഞ്ച പ്രധാനസ്ഥാനമനോനീതത്വകരണം വിലോക്യ സ നിമന്ത്രിതാൻ ഏതദുപദേശകഥാം ജഗാദ, ");
INSERT INTO sanmal_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","ത്വം വിവാഹാദിഭോജ്യേഷു നിമന്ത്രിതഃ സൻ പ്രധാനസ്ഥാനേ മോപാവേക്ഷീഃ| ത്വത്തോ ഗൗരവാന്വിതനിമന്ത്രിതജന ആയാതേ ");
INSERT INTO sanmal_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","നിമന്ത്രയിതാഗത്യ മനുഷ്യായൈതസ്മൈ സ്ഥാനം ദേഹീതി വാക്യം ചേദ് വക്ഷ്യതി തർഹി ത്വം സങ്കുചിതോ ഭൂത്വാ സ്ഥാന ഇതരസ്മിൻ ഉപവേഷ്ടുമ് ഉദ്യംസ്യസി| ");
INSERT INTO sanmal_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","അസ്മാത് കാരണാദേവ ത്വം നിമന്ത്രിതോ ഗത്വാഽപ്രധാനസ്ഥാന ഉപവിശ, തതോ നിമന്ത്രയിതാഗത്യ വദിഷ്യതി, ഹേ ബന്ധോ പ്രോച്ചസ്ഥാനം ഗത്വോപവിശ, തഥാ സതി ഭോജനോപവിഷ്ടാനാം സകലാനാം സാക്ഷാത് ത്വം മാന്യോ ഭവിഷ്യസി| ");
INSERT INTO sanmal_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","യഃ കശ്ചിത് സ്വമുന്നമയതി സ നമയിഷ്യതേ, കിന്തു യഃ കശ്ചിത് സ്വം നമയതി സ ഉന്നമയിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","തദാ സ നിമന്ത്രയിതാരം ജനമപി ജഗാദ, മധ്യാഹ്നേ രാത്രൗ വാ ഭോജ്യേ കൃതേ നിജബന്ധുഗണോ വാ ഭ്രാതൃृഗണോ വാ ജ്ഞാതിഗണോ വാ ധനിഗണോ വാ സമീപവാസിഗണോ വാ ഏതാൻ ന നിമന്ത്രയ, തഥാ കൃതേ ചേത് തേ ത്വാം നിമന്ത്രയിഷ്യന്തി, തർഹി പരിശോധോ ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","കിന്തു യദാ ഭേജ്യം കരോഷി തദാ ദരിദ്രശുഷ്കകരഖഞ്ജാന്ധാൻ നിമന്ത്രയ, ");
INSERT INTO sanmal_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","തത ആശിഷം ലപ്സ്യസേ, തേഷു പരിശോധം കർത്തുമശക്നുവത്സു ശ്മശാനാദ്ധാർമ്മികാനാമുത്ഥാനകാലേ ത്വം ഫലാം ലപ്സ്യസേ| ");
INSERT INTO sanmal_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","അനന്തരം താം കഥാം നിശമ്യ ഭോജനോപവിഷ്ടഃ കശ്ചിത് കഥയാമാസ, യോ ജന ഈശ്വരസ്യ രാജ്യേ ഭോക്തും ലപ്സ്യതേ സഏവ ധന്യഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","തതഃ സ ഉവാച, കശ്ചിത് ജനോ രാത്രൗ ഭേाജ്യം കൃത്വാ ബഹൂൻ നിമന്ത്രയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","തതോ ഭോജനസമയേ നിമന്ത്രിതലോകാൻ ആഹ്വാതും ദാസദ്വാരാ കഥയാമാസ, ഖദ്യദ്രവ്യാണി സർവ്വാണി സമാസാദിതാനി സന്തി, യൂയമാഗച്ഛത| ");
INSERT INTO sanmal_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","കിന്തു തേ സർവ്വ ഏകൈകം ഛലം കൃത്വാ ക്ഷമാം പ്രാർഥയാഞ്ചക്രിരേ| പ്രഥമോ ജനഃ കഥയാമാസ, ക്ഷേത്രമേകം ക്രീതവാനഹം തദേവ ദ്രഷ്ടും മയാ ഗന്തവ്യമ്, അതഏവ മാം ക്ഷന്തും തം നിവേദയ| ");
INSERT INTO sanmal_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","അന്യോ ജനഃ കഥയാമാസ, ദശവൃഷാനഹം ക്രീതവാൻ താൻ പരീക്ഷിതും യാമി തസ്മാദേവ മാം ക്ഷന്തും തം നിവേദയ| ");
INSERT INTO sanmal_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","അപരഃ കഥയാമാസ, വ്യൂഢവാനഹം തസ്മാത് കാരണാദ് യാതും ന ശക്നോമി| ");
INSERT INTO sanmal_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","പശ്ചാത് സ ദാസോ ഗത്വാ നിജപ്രഭോഃ സാക്ഷാത് സർവ്വവൃത്താന്തം നിവേദയാമാസ, തതോസൗ ഗൃഹപതിഃ കുപിത്വാ സ്വദാസം വ്യാജഹാര, ത്വം സത്വരം നഗരസ്യ സന്നിവേശാൻ മാർഗാംശ്ച ഗത്വാ ദരിദ്രശുഷ്കകരഖഞ്ജാന്ധാൻ അത്രാനയ| ");
INSERT INTO sanmal_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","തതോ ദാസോഽവദത്, ഹേ പ്രഭോ ഭവത ആജ്ഞാനുസാരേണാക്രിയത തഥാപി സ്ഥാനമസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","തദാ പ്രഭുഃ പുന ർദാസായാകഥയത്, രാജപഥാൻ വൃക്ഷമൂലാനി ച യാത്വാ മദീയഗൃഹപൂരണാർഥം ലോകാനാഗന്തും പ്രവർത്തയ| ");
INSERT INTO sanmal_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","അഹം യുഷ്മഭ്യം കഥയാമി, പൂർവ്വനിമന്ത്രിതാനമേകോപി മമാസ്യ രാത്രിഭോജ്യസ്യാസ്വാദം ന പ്രാപ്സ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","അനന്തരം ബഹുഷു ലോകേഷു യീശോഃ പശ്ചാദ് വ്രജിതേഷു സത്സു സ വ്യാഘുട്യ തേഭ്യഃ കഥയാമാസ, ");
INSERT INTO sanmal_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","യഃ കശ്ചിൻ മമ സമീപമ് ആഗത്യ സ്വസ്യ മാതാ പിതാ പത്നീ സന്താനാ ഭ്രാതരോ ഭഗിമ്യോ നിജപ്രാണാശ്ച, ഏതേഭ്യഃ സർവ്വേഭ്യോ മയ്യധികം പ്രേമ ന കരോതി, സ മമ ശിഷ്യോ ഭവിതും ന ശക്ഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","യഃ കശ്ചിത് സ്വീയം ക്രുശം വഹൻ മമ പശ്ചാന്ന ഗച്ഛതി, സോപി മമ ശിഷ്യോ ഭവിതും ന ശക്ഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","ദുർഗനിർമ്മാണേ കതിവ്യയോ ഭവിഷ്യതി, തഥാ തസ്യ സമാപ്തികരണാർഥം സമ്പത്തിരസ്തി ന വാ, പ്രഥമമുപവിശ്യ ഏതന്ന ഗണയതി, യുഷ്മാകം മധ്യ ഏതാദൃശഃ കോസ്തി? ");
INSERT INTO sanmal_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","നോചേദ് ഭിത്തിം കൃത്വാ ശേഷേ യദി സമാപയിതും ന ശക്ഷ്യതി, ");
INSERT INTO sanmal_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","തർഹി മാനുഷോയം നിചേതുമ് ആരഭത സമാപയിതും നാശക്നോത്, ഇതി വ്യാഹൃത്യ സർവ്വേ തമുപഹസിഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","അപരഞ്ച ഭിന്നഭൂപതിനാ സഹ യുദ്ധം കർത്തുമ് ഉദ്യമ്യ ദശസഹസ്രാണി സൈന്യാനി ഗൃഹീത്വാ വിംശതിസഹസ്രേഃ സൈന്യൈഃ സഹിതസ്യ സമീപവാസിനഃ സമ്മുഖം യാതും ശക്ഷ്യാമി ന വേതി പ്രഥമം ഉപവിശ്യ ന വിചാരയതി ഏതാദൃശോ ഭൂമിപതിഃ കഃ? ");
INSERT INTO sanmal_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","യദി ന ശക്നോതി തർഹി രിപാവതിദൂരേ തിഷ്ഠതി സതി നിജദൂതം പ്രേഷ്യ സന്ധിം കർത്തും പ്രാർഥയേത| ");
INSERT INTO sanmal_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","തദ്വദ് യുഷ്മാകം മധ്യേ യഃ കശ്ചിൻ മദർഥം സർവ്വസ്വം ഹാതും ന ശക്നോതി സ മമ ശിഷ്യോ ഭവിതും ന ശക്ഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","ലവണമ് ഉത്തമമ് ഇതി സത്യം, കിന്തു യദി ലവണസ്യ ലവണത്വമ് അപഗച്ഛതി തർഹി തത് കഥം സ്വാദുയുക്തം ഭവിഷ്യതി? ");
INSERT INTO sanmal_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","തദ ഭൂമ്യർഥമ് ആലവാലരാശ്യർഥമപി ഭദ്രം ന ഭവതി; ലോകാസ്തദ് ബഹിഃ ക്ഷിപന്തി| യസ്യ ശ്രോതും ശ്രോത്രേ സ്തഃ സ ശൃണോതു| ");
INSERT INTO sanmal_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","തദാ കരസഞ്ചായിനഃ പാപിനശ്ച ലോകാ ഉപദേശ്കഥാം ശ്രോതും യീശോഃ സമീപമ് ആഗച്ഛൻ| ");
INSERT INTO sanmal_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","തതഃ ഫിരൂശിന ഉപാധ്യായാശ്ച വിവദമാനാഃ കഥയാമാസുഃ ഏഷ മാനുഷഃ പാപിഭിഃ സഹ പ്രണയം കൃത്വാ തൈഃ സാർദ്ധം ഭുംക്തേ| ");
INSERT INTO sanmal_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","തദാ സ തേഭ്യ ഇമാം ദൃഷ്ടാന്തകഥാം കഥിതവാൻ, ");
INSERT INTO sanmal_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","കസ്യചിത് ശതമേഷേഷു തിഷ്ഠത്മു തേഷാമേകം സ യദി ഹാരയതി തർഹി മധ്യേപ്രാന്തരമ് ഏകോനശതമേഷാൻ വിഹായ ഹാരിതമേഷസ്യ ഉദ്ദേശപ്രാപ്തിപര്യ്യനതം ന ഗവേഷയതി, ഏതാദൃശോ ലോകോ യുഷ്മാകം മധ്യേ ക ആസ്തേ? ");
INSERT INTO sanmal_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","തസ്യോദ്ദേശം പ്രാപ്യ ഹൃഷ്ടമനാസ്തം സ്കന്ധേ നിധായ സ്വസ്ഥാനമ് ആനീയ ബന്ധുബാന്ധവസമീപവാസിന ആഹൂയ വക്തി, ");
INSERT INTO sanmal_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ഹാരിതം മേഷം പ്രാപ്തോഹമ് അതോ ഹേതോ ർമയാ സാർദ്ധമ് ആനന്ദത| ");
INSERT INTO sanmal_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","തദ്വദഹം യുഷ്മാൻ വദാമി, യേഷാം മനഃപരാവർത്തനസ്യ പ്രയോജനം നാസ്തി, താദൃശൈകോനശതധാർമ്മികകാരണാദ് യ ആനന്ദസ്തസ്മാദ് ഏകസ്യ മനഃപരിവർത്തിനഃ പാപിനഃ കാരണാത് സ്വർഗേ ഽധികാനന്ദോ ജായതേ| ");
INSERT INTO sanmal_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","അപരഞ്ച ദശാനാം രൂപ്യഖണ്ഡാനാമ് ഏകഖണ്ഡേ ഹാരിതേ പ്രദീപം പ്രജ്വാല്യ ഗൃഹം സമ്മാർജ്യ തസ്യ പ്രാപ്തിം യാവദ് യത്നേന ന ഗവേഷയതി, ഏതാദൃശീ യോഷിത് കാസ്തേ? ");
INSERT INTO sanmal_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","പ്രാപ്തേ സതി ബന്ധുബാന്ധവസമീപവാസിനീരാഹൂയ കഥയതി, ഹാരിതം രൂപ്യഖണ്ഡം പ്രാപ്താഹം തസ്മാദേവ മയാ സാർദ്ധമ് ആനന്ദത| ");
INSERT INTO sanmal_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","തദ്വദഹം യുഷ്മാൻ വ്യാഹരാമി, ഏകേന പാപിനാ മനസി പരിവർത്തിതേ, ഈശ്വരസ്യ ദൂതാനാം മധ്യേപ്യാനന്ദോ ജായതേ| ");
INSERT INTO sanmal_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","അപരഞ്ച സ കഥയാമാസ, കസ്യചിദ് ദ്വൗ പുത്രാവാസ്താം, ");
INSERT INTO sanmal_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","തയോഃ കനിഷ്ഠഃ പുത്രഃ പിത്രേ കഥയാമാസ, ഹേ പിതസ്തവ സമ്പത്ത്യാ യമംശം പ്രാപ്സ്യാമ്യഹം വിഭജ്യ തം ദേഹി, തതഃ പിതാ നിജാം സമ്പത്തിം വിഭജ്യ താഭ്യാം ദദൗ| ");
INSERT INTO sanmal_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","കതിപയാത് കാലാത് പരം സ കനിഷ്ഠപുത്രഃ സമസ്തം ധനം സംഗൃഹ്യ ദൂരദേശം ഗത്വാ ദുഷ്ടാചരണേന സർവ്വാം സമ്പത്തിം നാശയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","തസ്യ സർവ്വധനേ വ്യയം ഗതേ തദ്ദേശേ മഹാദുർഭിക്ഷം ബഭൂവ, തതസ്തസ്യ ദൈന്യദശാ ഭവിതുമ് ആരേഭേ| ");
INSERT INTO sanmal_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","തതഃ പരം സ ഗത്വാ തദ്ദേശീയം ഗൃഹസ്ഥമേകമ് ആശ്രയത; തതഃ സതം ശൂകരവ്രജം ചാരയിതും പ്രാന്തരം പ്രേഷയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","കേനാപി തസ്മൈ ഭക്ഷ്യാദാനാത് സ ശൂകരഫലവൽകലേന പിചിണ്ഡപൂരണാം വവാഞ്ഛ| ");
INSERT INTO sanmal_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ശേഷേ സ മനസി ചേതനാം പ്രാപ്യ കഥയാമാസ, ഹാ മമ പിതുഃ സമീപേ കതി കതി വേതനഭുജോ ദാസാ യഥേഷ്ടം തതോധികഞ്ച ഭക്ഷ്യം പ്രാപ്നുവന്തി കിന്ത്വഹം ക്ഷുധാ മുമൂർഷുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","അഹമുത്ഥായ പിതുഃ സമീപം ഗത്വാ കഥാമേതാം വദിഷ്യാമി, ഹേ പിതർ ഈശ്വരസ്യ തവ ച വിരുദ്ധം പാപമകരവമ് ");
INSERT INTO sanmal_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","തവ പുത്രഇതി വിഖ്യാതോ ഭവിതും ന യോഗ്യോസ്മി ച, മാം തവ വൈതനികം ദാസം കൃത്വാ സ്ഥാപയ| ");
INSERT INTO sanmal_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","പശ്ചാത് സ ഉത്ഥായ പിതുഃ സമീപം ജഗാമ; തതസ്തസ്യ പിതാതിദൂരേ തം നിരീക്ഷ്യ ദയാഞ്ചക്രേ, ധാവിത്വാ തസ്യ കണ്ഠം ഗൃഹീത്വാ തം ചുചുമ്ബ ച| ");
INSERT INTO sanmal_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","തദാ പുത്ര ഉവാച, ഹേ പിതർ ഈശ്വരസ്യ തവ ച വിരുദ്ധം പാപമകരവം, തവ പുത്രഇതി വിഖ്യാതോ ഭവിതും ന യോഗ്യോസ്മി ച| ");
INSERT INTO sanmal_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","കിന്തു തസ്യ പിതാ നിജദാസാൻ ആദിദേശ, സർവ്വോത്തമവസ്ത്രാണ്യാനീയ പരിധാപയതൈനം ഹസ്തേ ചാങ്ഗുരീയകമ് അർപയത പാദയോശ്ചോപാനഹൗ സമർപയത; ");
INSERT INTO sanmal_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","പുഷ്ടം ഗോവത്സമ് ആനീയ മാരയത ച തം ഭുക്ത്വാ വയമ് ആനന്ദാമ| ");
INSERT INTO sanmal_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","യതോ മമ പുത്രോയമ് അമ്രിയത പുനരജീവീദ് ഹാരിതശ്ച ലബ്ധോഭൂത് തതസ്ത ആനന്ദിതുമ് ആരേഭിരേ| ");
INSERT INTO sanmal_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","തത്കാലേ തസ്യ ജ്യേഷ്ഠഃ പുത്രഃ ക്ഷേത്ര ആസീത്| അഥ സ നിവേശനസ്യ നികടം ആഗച്ഛൻ നൃത്യാനാം വാദ്യാനാഞ്ച ശബ്ദം ശ്രുത്വാ ");
INSERT INTO sanmal_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ദാസാനാമ് ഏകമ് ആഹൂയ പപ്രച്ഛ, കിം കാരണമസ്യ? ");
INSERT INTO sanmal_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","തതഃ സോവാദീത്, തവ ഭ്രാതാഗമത്, തവ താതശ്ച തം സുശരീരം പ്രാപ്യ പുഷ്ടം ഗോവത്സം മാരിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","തതഃ സ പ്രകുപ്യ നിവേശനാന്തഃ പ്രവേഷ്ടും ന സമ്മേനേ; തതസ്തസ്യ പിതാ ബഹിരാഗത്യ തം സാധയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","തതഃ സ പിതരം പ്രത്യുവാച, പശ്യ തവ കാഞ്ചിദപ്യാജ്ഞാം ന വിലംഘ്യ ബഹൂൻ വത്സരാൻ അഹം ത്വാം സേവേ തഥാപി മിത്രൈഃ സാർദ്ധമ് ഉത്സവം കർത്തും കദാപി ഛാഗമേകമപി മഹ്യം നാദദാഃ; ");
INSERT INTO sanmal_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","കിന്തു തവ യഃ പുത്രോ വേശ്യാഗമനാദിഭിസ്തവ സമ്പത്തിമ് അപവ്യയിതവാൻ തസ്മിന്നാഗതമാത്രേ തസ്യൈവ നിമിത്തം പുഷ്ടം ഗോവത്സം മാരിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","തദാ തസ്യ പിതാവോചത്, ഹേ പുത്ര ത്വം സർവ്വദാ മയാ സഹാസി തസ്മാൻ മമ യദ്യദാസ്തേ തത്സർവ്വം തവ| ");
INSERT INTO sanmal_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","കിന്തു തവായം ഭ്രാതാ മൃതഃ പുനരജീവീദ് ഹാരിതശ്ച ഭൂത്വാ പ്രാപ്തോഭൂത്, ഏതസ്മാത് കാരണാദ് ഉത്സവാനന്ദൗ കർത്തുമ് ഉചിതമസ്മാകമ്| ");
INSERT INTO sanmal_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","അപരഞ്ച യീശുഃ ശിഷ്യേഭ്യോന്യാമേകാം കഥാം കഥയാമാസ കസ്യചിദ് ധനവതോ മനുഷ്യസ്യ ഗൃഹകാര്യ്യാധീശേ സമ്പത്തേരപവ്യയേഽപവാദിതേ സതി ");
INSERT INTO sanmal_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","തസ്യ പ്രഭുസ്തമ് ആഹൂയ ജഗാദ, ത്വയി യാമിമാം കഥാം ശൃണോമി സാ കീദൃശീ? ത്വം ഗൃഹകാര്യ്യാധീശകർമ്മണോ ഗണനാം ദർശയ ഗൃഹകാര്യ്യാധീശപദേ ത്വം ന സ്ഥാസ്യസി| ");
INSERT INTO sanmal_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","തദാ സ ഗൃഹകാര്യ്യാധീശോ മനസാ ചിന്തയാമാസ, പ്രഭു ര്യദി മാം ഗൃഹകാര്യ്യാധീശപദാദ് ഭ്രംശയതി തർഹി കിം കരിഷ്യേഽഹം? മൃദം ഖനിതും മമ ശക്തി ർനാസ്തി ഭിക്ഷിതുഞ്ച ലജ്ജിഷ്യേഽഹം| ");
INSERT INTO sanmal_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","അതഏവ മയി ഗൃഹകാര്യ്യാധീശപദാത് ച്യുതേ സതി യഥാ ലോകാ മഹ്യമ് ആശ്രയം ദാസ്യന്തി തദർഥം യത്കർമ്മ മയാ കരണീയം തൻ നിർണീയതേ| ");
INSERT INTO sanmal_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","പശ്ചാത് സ സ്വപ്രഭോരേകൈകമ് അധമർണമ് ആഹൂയ പ്രഥമം പപ്രച്ഛ, ത്വത്തോ മേ പ്രഭുണാ കതി പ്രാപ്യമ്? ");
INSERT INTO sanmal_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","തതഃ സ ഉവാച, ഏകശതാഢകതൈലാനി; തദാ ഗൃഹകാര്യ്യാധീശഃ പ്രോവാച, തവ പത്രമാനീയ ശീഘ്രമുപവിശ്യ തത്ര പഞ്ചാശതം ലിഖ| ");
INSERT INTO sanmal_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","പശ്ചാദന്യമേകം പപ്രച്ഛ, ത്വത്തോ മേ പ്രഭുണാ കതി പ്രാപ്യമ്? തതഃ സോവാദീദ് ഏകശതാഢകഗോധൂമാഃ; തദാ സ കഥയാമാസ, തവ പത്രമാനീയ അശീതിം ലിഖ| ");
INSERT INTO sanmal_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","തേനൈവ പ്രഭുസ്തമയഥാർഥകൃതമ് അധീശം തദ്ബുദ്ധിനൈപുണ്യാത് പ്രശശംസ; ഇത്ഥം ദീപ്തിരൂപസന്താനേഭ്യ ഏതത്സംസാരസ്യ സന്താനാ വർത്തമാനകാലേഽധികബുദ്ധിമന്തോ ഭവന്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","അതോ വദാമി യൂയമപ്യയഥാർഥേന ധനേന മിത്രാണി ലഭധ്വം തതോ യുഷ്മാസു പദഭ്രഷ്ടേഷ്വപി താനി ചിരകാലമ് ആശ്രയം ദാസ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","യഃ കശ്ചിത് ക്ഷുദ്രേ കാര്യ്യേ വിശ്വാസ്യോ ഭവതി സ മഹതി കാര്യ്യേപി വിശ്വാസ്യോ ഭവതി, കിന്തു യഃ കശ്ചിത് ക്ഷുദ്രേ കാര്യ്യേഽവിശ്വാസ്യോ ഭവതി സ മഹതി കാര്യ്യേപ്യവിശ്വാസ്യോ ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","അതഏവ അയഥാർഥേന ധനേന യദി യൂയമവിശ്വാസ്യാ ജാതാസ്തർഹി സത്യം ധനം യുഷ്മാകം കരേഷു കഃ സമർപയിഷ്യതി? ");
INSERT INTO sanmal_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","യദി ച പരധനേന യൂയമ് അവിശ്വാസ്യാ ഭവഥ തർഹി യുഷ്മാകം സ്വകീയധനം യുഷ്മഭ്യം കോ ദാസ്യതി? ");
INSERT INTO sanmal_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","കോപി ദാസ ഉഭൗ പ്രഭൂ സേവിതും ന ശക്നോതി, യത ഏകസ്മിൻ പ്രീയമാണോഽന്യസ്മിന്നപ്രീയതേ യദ്വാ ഏകം ജനം സമാദൃത്യ തദന്യം തുച്ഛീകരോതി തദ്വദ് യൂയമപി ധനേശ്വരൗ സേവിതും ന ശക്നുഥ| ");
INSERT INTO sanmal_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","തദൈതാഃ സർവ്വാഃ കഥാഃ ശ്രുത്വാ ലോഭിഫിരൂശിനസ്തമുപജഹസുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","തതഃ സ ഉവാച, യൂയം മനുഷ്യാണാം നികടേ സ്വാൻ നിർദോഷാൻ ദർശയഥ കിന്തു യുഷ്മാകമ് അന്തഃകരണാനീശ്വരോ ജാനാതി, യത് മനുഷ്യാണാമ് അതി പ്രശംസ്യം തദ് ഈശ്വരസ്യ ഘൃണ്യം| ");
INSERT INTO sanmal_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","യോഹന ആഗമനപര്യ്യനതം യുഷ്മാകം സമീപേ വ്യവസ്ഥാഭവിഷ്യദ്വാദിനാം ലേഖനാനി ചാസൻ തതഃ പ്രഭൃതി ഈശ്വരരാജ്യസ്യ സുസംവാദഃ പ്രചരതി, ഏകൈകോ ലോകസ്തന്മധ്യം യത്നേന പ്രവിശതി ച| ");
INSERT INTO sanmal_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","വരം നഭസഃ പൃഥിവ്യാശ്ച ലോപോ ഭവിഷ്യതി തഥാപി വ്യവസ്ഥായാ ഏകബിന്ദോരപി ലോപോ ന ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","യഃ കശ്ചിത് സ്വീയാം ഭാര്യ്യാം വിഹായ സ്ത്രിയമന്യാം വിവഹതി സ പരദാരാൻ ഗച്ഛതി, യശ്ച താ ത്യക്താം നാരീം വിവഹതി സോപി പരദാരാന ഗച്ഛതി| ");
INSERT INTO sanmal_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ഏകോ ധനീ മനുഷ്യഃ ശുക്ലാനി സൂക്ഷ്മാണി വസ്ത്രാണി പര്യ്യദധാത് പ്രതിദിനം പരിതോഷരൂപേണാഭുംക്താപിവച്ച| ");
INSERT INTO sanmal_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","സർവ്വാങ്ഗേ ക്ഷതയുക്ത ഇലിയാസരനാമാ കശ്ചിദ് ദരിദ്രസ്തസ്യ ധനവതോ ഭോജനപാത്രാത് പതിതമ് ഉച്ഛിഷ്ടം ഭോക്തും വാഞ്ഛൻ തസ്യ ദ്വാരേ പതിത്വാതിഷ്ഠത്; ");
INSERT INTO sanmal_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","അഥ ശ്വാന ആഗത്യ തസ്യ ക്ഷതാന്യലിഹൻ| ");
INSERT INTO sanmal_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","കിയത്കാലാത്പരം സ ദരിദ്രഃ പ്രാണാൻ ജഹൗ; തതഃ സ്വർഗീയദൂതാസ്തം നീത്വാ ഇബ്രാഹീമഃ ക്രോഡ ഉപവേശയാമാസുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","പശ്ചാത് സ ധനവാനപി മമാര, തം ശ്മശാനേ സ്ഥാപയാമാസുശ്ച; കിന്തു പരലോകേ സ വേദനാകുലഃ സൻ ഊർദ്ധ്വാം നിരീക്ഷ്യ ബഹുദൂരാദ് ഇബ്രാഹീമം തത്ക്രോഡ ഇലിയാസരഞ്ച വിലോക്യ രുവന്നുവാച; ");
INSERT INTO sanmal_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ഹേ പിതർ ഇബ്രാഹീമ് അനുഗൃഹ്യ അങ്ഗുല്യഗ്രഭാഗം ജലേ മജ്ജയിത്വാ മമ ജിഹ്വാം ശീതലാം കർത്തുമ് ഇലിയാസരം പ്രേരയ, യതോ വഹ്നിശിഖാതോഹം വ്യഥിതോസ്മി| ");
INSERT INTO sanmal_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","തദാ ഇബ്രാഹീമ് ബഭാഷേ, ഹേ പുത്ര ത്വം ജീവൻ സമ്പദം പ്രാപ്തവാൻ ഇലിയാസരസ്തു വിപദം പ്രാപ്തവാൻ ഏതത് സ്മര, കിന്തു സമ്പ്രതി തസ്യ സുഖം തവ ച ദുഃഖം ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","അപരമപി യുഷ്മാകമ് അസ്മാകഞ്ച സ്ഥാനയോ ർമധ്യേ മഹദ്വിച്ഛേദോഽസ്തി തത ഏതത്സ്ഥാനസ്യ ലോകാസ്തത് സ്ഥാനം യാതും യദ്വാ തത്സ്ഥാനസ്യ ലോകാ ഏതത് സ്ഥാനമായാതും ന ശക്നുവന്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","തദാ സ ഉക്തവാൻ, ഹേ പിതസ്തർഹി ത്വാം നിവേദയാമി മമ പിതു ർഗേഹേ യേ മമ പഞ്ച ഭ്രാതരഃ സന്തി ");
INSERT INTO sanmal_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","തേ യഥൈതദ് യാതനാസ്ഥാനം നായാസ്യന്തി തഥാ മന്ത്രണാം ദാതും തേഷാം സമീപമ് ഇലിയാസരം പ്രേരയ| ");
INSERT INTO sanmal_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","തത ഇബ്രാഹീമ് ഉവാച, മൂസാഭവിഷ്യദ്വാദിനാഞ്ച പുസ്തകാനി തേഷാം നികടേ സന്തി തേ തദ്വചനാനി മന്യന്താം| ");
INSERT INTO sanmal_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","തദാ സ നിവേദയാമാസ, ഹേ പിതർ ഇബ്രാഹീമ് ന തഥാ, കിന്തു യദി മൃതലോകാനാം കശ്ചിത് തേഷാം സമീപം യാതി തർഹി തേ മനാംസി വ്യാഘോടയിഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","തത ഇബ്രാഹീമ് ജഗാദ, തേ യദി മൂസാഭവിഷ്യദ്വാദിനാഞ്ച വചനാനി ന മന്യന്തേ തർഹി മൃതലോകാനാം കസ്മിംശ്ചിദ് ഉത്ഥിതേപി തേ തസ്യ മന്ത്രണാം ന മംസ്യന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ഇതഃ പരം യീശുഃ ശിഷ്യാൻ ഉവാച, വിഘ്നൈരവശ്യമ് ആഗന്തവ്യം കിന്തു വിഘ്നാ യേന ഘടിഷ്യന്തേ തസ്യ ദുർഗതി ർഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ഏതേഷാം ക്ഷുദ്രപ്രാണിനാമ് ഏകസ്യാപി വിഘ്നജനനാത് കണ്ഠബദ്ധപേഷണീകസ്യ തസ്യ സാഗരാഗാധജലേ മജ്ജനം ഭദ്രം| ");
INSERT INTO sanmal_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","യൂയം സ്വേഷു സാവധാനാസ്തിഷ്ഠത; തവ ഭ്രാതാ യദി തവ കിഞ്ചിദ് അപരാധ്യതി തർഹി തം തർജയ, തേന യദി മനഃ പരിവർത്തയതി തർഹി തം ക്ഷമസ്വ| ");
INSERT INTO sanmal_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","പുനരേകദിനമധ്യേ യദി സ തവ സപ്തകൃത്വോഽപരാധ്യതി കിന്തു സപ്തകൃത്വ ആഗത്യ മനഃ പരിവർത്യ മയാപരാദ്ധമ് ഇതി വദതി തർഹി തം ക്ഷമസ്വ| ");
INSERT INTO sanmal_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","തദാ പ്രേരിതാഃ പ്രഭുമ് അവദൻ അസ്മാകം വിശ്വാസം വർദ്ധയ| ");
INSERT INTO sanmal_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","പ്രഭുരുവാച, യദി യുഷ്മാകം സർഷപൈകപ്രമാണോ വിശ്വാസോസ്തി തർഹി ത്വം സമൂലമുത്പാടിതോ ഭൂത്വാ സമുദ്രേ രോപിതോ ഭവ കഥായാമ് ഏതസ്യാമ് ഏതദുഡുമ്ബരായ കഥിതായാം സ യുഷ്മാകമാജ്ഞാവഹോ ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","അപരം സ്വദാസേ ഹലം വാഹയിത്വാ വാ പശൂൻ ചാരയിത്വാ ക്ഷേത്രാദ് ആഗതേ സതി തം വദതി, ഏഹി ഭോക്തുമുപവിശ, യുഷ്മാകമ് ഏതാദൃശഃ കോസ്തി? ");
INSERT INTO sanmal_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","വരഞ്ച പൂർവ്വം മമ ഖാദ്യമാസാദ്യ യാവദ് ഭുഞ്ജേ പിവാമി ച താവദ് ബദ്ധകടിഃ പരിചര പശ്ചാത് ത്വമപി ഭോക്ഷ്യസേ പാസ്യസി ച കഥാമീദൃശീം കിം ന വക്ഷ്യതി? ");
INSERT INTO sanmal_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","തേന ദാസേന പ്രഭോരാജ്ഞാനുരൂപേ കർമ്മണി കൃതേ പ്രഭുഃ കിം തസ്മിൻ ബാധിതോ ജാതഃ? നേത്ഥം ബുധ്യതേ മയാ| ");
INSERT INTO sanmal_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ഇത്ഥം നിരൂപിതേഷു സർവ്വകർമ്മസു കൃതേഷു സത്മു യൂയമപീദം വാക്യം വദഥ, വയമ് അനുപകാരിണോ ദാസാ അസ്മാഭിര്യദ്യത്കർത്തവ്യം തന്മാത്രമേവ കൃതം| ");
INSERT INTO sanmal_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","സ യിരൂശാലമി യാത്രാം കുർവ്വൻ ശോമിരോൺഗാലീൽപ്രദേശമധ്യേന ഗച്ഛതി, ");
INSERT INTO sanmal_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ഏതർഹി കുത്രചിദ് ഗ്രാമേ പ്രവേശമാത്രേ ദശകുഷ്ഠിനസ്തം സാക്ഷാത് കൃത്വാ ");
INSERT INTO sanmal_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ദൂരേ തിഷ്ഠനത ഉച്ചൈ ർവക്തുമാരേഭിരേ, ഹേ പ്രഭോ യീശോ ദയസ്വാസ്മാൻ| ");
INSERT INTO sanmal_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","തതഃ സ താൻ ദൃഷ്ട്വാ ജഗാദ, യൂയം യാജകാനാം സമീപേ സ്വാൻ ദർശയത, തതസ്തേ ഗച്ഛന്തോ രോഗാത് പരിഷ്കൃതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","തദാ തേഷാമേകഃ സ്വം സ്വസ്ഥം ദൃഷ്ട്വാ പ്രോച്ചൈരീശ്വരം ധന്യം വദൻ വ്യാഘുട്യായാതോ യീശോ ർഗുണാനനുവദൻ തച്ചരണാധോഭൂമൗ പപാത; ");
INSERT INTO sanmal_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","സ ചാസീത് ശോമിരോണീ| ");
INSERT INTO sanmal_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","തദാ യീശുരവദത്, ദശജനാഃ കിം ന പരിഷ്കൃതാഃ? തഹ്യന്യേ നവജനാഃ കുത്ര? ");
INSERT INTO sanmal_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ഈശ്വരം ധന്യം വദന്തമ് ഏനം വിദേശിനം വിനാ കോപ്യന്യോ ന പ്രാപ്യത| ");
INSERT INTO sanmal_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","തദാ സ തമുവാച, ത്വമുത്ഥായ യാഹി വിശ്വാസസ്തേ ത്വാം സ്വസ്ഥം കൃതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","അഥ കദേശ്വരസ്യ രാജത്വം ഭവിഷ്യതീതി ഫിരൂശിഭിഃ പൃഷ്ടേ സ പ്രത്യുവാച, ഈശ്വരസ്യ രാജത്വമ് ഐശ്വര്യ്യദർശനേന ന ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","അത ഏതസ്മിൻ പശ്യ തസ്മിൻ വാ പശ്യ, ഇതി വാക്യം ലോകാ വക്തും ന ശക്ഷ്യന്തി, ഈശ്വരസ്യ രാജത്വം യുഷ്മാകമ് അന്തരേവാസ്തേ| ");
INSERT INTO sanmal_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","തതഃ സ ശിഷ്യാൻ ജഗാദ, യദാ യുഷ്മാഭി ർമനുജസുതസ്യ ദിനമേകം ദ്രഷ്ടുമ് വാഞ്ഛിഷ്യതേ കിന്തു ന ദർശിഷ്യതേ, ഈദൃക്കാല ആയാതി| ");
INSERT INTO sanmal_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","തദാത്ര പശ്യ വാ തത്ര പശ്യേതി വാക്യം ലോകാ വക്ഷ്യന്തി, കിന്തു തേഷാം പശ്ചാത് മാ യാത, മാനുഗച്ഛത ച| ");
INSERT INTO sanmal_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","യതസ്തഡിദ് യഥാകാശൈകദിശ്യുദിയ തദന്യാമപി ദിശം വ്യാപ്യ പ്രകാശതേ തദ്വത് നിജദിനേ മനുജസൂനുഃ പ്രകാശിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","കിന്തു തത്പൂർവ്വം തേനാനേകാനി ദുഃഖാനി ഭോക്തവ്യാന്യേതദ്വർത്തമാനലോകൈശ്ച സോഽവജ്ഞാതവ്യഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","നോഹസ്യ വിദ്യമാനകാലേ യഥാഭവത് മനുഷ്യസൂനോഃ കാലേപി തഥാ ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","യാവത്കാലം നോഹോ മഹാപോതം നാരോഹദ് ആപ്ലാവിവാര്യ്യേത്യ സർവ്വം നാനാശയച്ച താവത്കാലം യഥാ ലോകാ അഭുഞ്ജതാപിവൻ വ്യവഹൻ വ്യവാഹയംശ്ച; ");
INSERT INTO sanmal_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ഇത്ഥം ലോടോ വർത്തമാനകാലേപി യഥാ ലോകാ ഭോജനപാനക്രയവിക്രയരോപണഗൃഹനിർമ്മാണകർമ്മസു പ്രാവർത്തന്ത, ");
INSERT INTO sanmal_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","കിന്തു യദാ ലോട് സിദോമോ നിർജഗാമ തദാ നഭസഃ സഗന്ധകാഗ്നിവൃഷ്ടി ർഭൂത്വാ സർവ്വം വ്യനാശയത് ");
INSERT INTO sanmal_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","തദ്വൻ മാനവപുത്രപ്രകാശദിനേപി ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","തദാ യദി കശ്ചിദ് ഗൃഹോപരി തിഷ്ഠതി തർഹി സ ഗൃഹമധ്യാത് കിമപി ദ്രവ്യമാനേതുമ് അവരുഹ്യ നൈതു; യശ്ച ക്ഷേത്രേ തിഷ്ഠതി സോപി വ്യാഘുട്യ നായാതു| ");
INSERT INTO sanmal_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","ലോടഃ പത്നീം സ്മരത| ");
INSERT INTO sanmal_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","യഃ പ്രാണാൻ രക്ഷിതും ചേഷ്ടിഷ്യതേ സ പ്രാണാൻ ഹാരയിഷ്യതി യസ്തു പ്രാണാൻ ഹാരയിഷ്യതി സഏവ പ്രാണാൻ രക്ഷിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","യുഷ്മാനഹം വച്മി തസ്യാം രാത്രൗ ശയ്യൈകഗതയോ ർലോകയോരേകോ ധാരിഷ്യതേ പരസ്ത്യക്ഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","സ്ത്രിയൗ യുഗപത് പേഷണീം വ്യാവർത്തയിഷ്യതസ്തയോരേകാ ധാരിഷ്യതേ പരാത്യക്ഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","പുരുഷൗ ക്ഷേത്രേ സ്ഥാസ്യതസ്തയോരേകോ ധാരിഷ്യതേ പരസ്ത്യക്ഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","തദാ തേ പപ്രച്ഛുഃ, ഹേ പ്രഭോ കുത്രേത്ഥം ഭവിഷ്യതി? തതഃ സ ഉവാച, യത്ര ശവസ്തിഷ്ഠതി തത്ര ഗൃധ്രാ മിലന്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","അപരഞ്ച ലോകൈരക്ലാന്തൈ ർനിരന്തരം പ്രാർഥയിതവ്യമ് ഇത്യാശയേന യീശുനാ ദൃഷ്ടാന്ത ഏകഃ കഥിതഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","കുത്രചിന്നഗരേ കശ്ചിത് പ്രാഡ്വിവാക ആസീത് സ ഈശ്വരാന്നാബിഭേത് മാനുഷാംശ്ച നാമന്യത| ");
INSERT INTO sanmal_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","അഥ തത്പുരവാസിനീ കാചിദ്വിധവാ തത്സമീപമേത്യ വിവാദിനാ സഹ മമ വിവാദം പരിഷ്കുർവ്വിതി നിവേദയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","തതഃ സ പ്രാഡ്വിവാകഃ കിയദ്ദിനാനി ന തദങ്ഗീകൃതവാൻ പശ്ചാച്ചിത്തേ ചിന്തയാമാസ, യദ്യപീശ്വരാന്ന ബിഭേമി മനുഷ്യാനപി ന മന്യേ ");
INSERT INTO sanmal_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","തഥാപ്യേഷാ വിധവാ മാം ക്ലിശ്നാതി തസ്മാദസ്യാ വിവാദം പരിഷ്കരിഷ്യാമി നോചേത് സാ സദാഗത്യ മാം വ്യഗ്രം കരിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","പശ്ചാത് പ്രഭുരവദദ് അസാവന്യായപ്രാഡ്വിവാകോ യദാഹ തത്ര മനോ നിധധ്വം| ");
INSERT INTO sanmal_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ഈശ്വരസ്യ യേ ഽഭിരുചിതലോകാ ദിവാനിശം പ്രാർഥയന്തേ സ ബഹുദിനാനി വിലമ്ബ്യാപി തേഷാം വിവാദാൻ കിം ന പരിഷ്കരിഷ്യതി? ");
INSERT INTO sanmal_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","യുഷ്മാനഹം വദാമി ത്വരയാ പരിഷ്കരിഷ്യതി, കിന്തു യദാ മനുഷ്യപുത്ര ആഗമിഷ്യതി തദാ പൃഥിവ്യാം കിമീദൃശം വിശ്വാസം പ്രാപ്സ്യതി? ");
INSERT INTO sanmal_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","യേ സ്വാൻ ധാർമ്മികാൻ ജ്ഞാത്വാ പരാൻ തുച്ഛീകുർവ്വന്തി ഏതാദൃഗ്ഭ്യഃ, കിയദ്ഭ്യ ഇമം ദൃഷ്ടാന്തം കഥയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","ഏകഃ ഫിരൂശ്യപരഃ കരസഞ്ചായീ ദ്വാവിമൗ പ്രാർഥയിതും മന്ദിരം ഗതൗ| ");
INSERT INTO sanmal_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","തതോഽസൗ ഫിരൂശ്യേകപാർശ്വേ തിഷ്ഠൻ ഹേ ഈശ്വര അഹമന്യലോകവത് ലോഠയിതാന്യായീ പാരദാരികശ്ച ന ഭവാമി അസ്യ കരസഞ്ചായിനസ്തുല്യശ്ച ന, തസ്മാത്ത്വാം ധന്യം വദാമി| ");
INSERT INTO sanmal_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","സപ്തസു ദിനേഷു ദിനദ്വയമുപവസാമി സർവ്വസമ്പത്തേ ർദശമാംശം ദദാമി ച, ഏതത്കഥാം കഥയൻ പ്രാർഥയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","കിന്തു സ കരസഞ്ചായി ദൂരേ തിഷ്ഠൻ സ്വർഗം ദ്രഷ്ടും നേച്ഛൻ വക്ഷസി കരാഘാതം കുർവ്വൻ ഹേ ഈശ്വര പാപിഷ്ഠം മാം ദയസ്വ, ഇത്ഥം പ്രാർഥയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","യുഷ്മാനഹം വദാമി, തയോർദ്വയോ ർമധ്യേ കേവലഃ കരസഞ്ചായീ പുണ്യവത്ത്വേന ഗണിതോ നിജഗൃഹം ജഗാമ, യതോ യഃ കശ്ചിത് സ്വമുന്നമയതി സ നാമയിഷ്യതേ കിന്തു യഃ കശ്ചിത് സ്വം നമയതി സ ഉന്നമയിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","അഥ ശിശൂനാം ഗാത്രസ്പർശാർഥം ലോകാസ്താൻ തസ്യ സമീപമാനിന്യുഃ ശിഷ്യാസ്തദ് ദൃഷ്ട്വാനേതൃൻ തർജയാമാസുഃ, ");
INSERT INTO sanmal_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","കിന്തു യീശുസ്താനാഹൂയ ജഗാദ, മന്നികടമ് ആഗന്തും ശിശൂൻ അനുജാനീധ്വം താംശ്ച മാ വാരയത; യത ഈശ്വരരാജ്യാധികാരിണ ഏഷാം സദൃശാഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","അഹം യുഷ്മാൻ യഥാർഥം വദാമി, യോ ജനഃ ശിശോഃ സദൃശോ ഭൂത്വാ ഈശ്വരരാജ്യം ന ഗൃഹ്ലാതി സ കേനാപി പ്രകാരേണ തത് പ്രവേഷ്ടും ന ശക്നോതി| ");
INSERT INTO sanmal_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","അപരമ് ഏകോധിപതിസ്തം പപ്രച്ഛ, ഹേ പരമഗുരോ, അനന്തായുഷഃ പ്രാപ്തയേ മയാ കിം കർത്തവ്യം? ");
INSERT INTO sanmal_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","യീശുരുവാച, മാം കുതഃ പരമം വദസി? ഈശ്വരം വിനാ കോപി പരമോ ന ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","പരദാരാൻ മാ ഗച്ഛ, നരം മാ ജഹി, മാ ചോരയ, മിഥ്യാസാക്ഷ്യം മാ ദേഹി, മാതരം പിതരഞ്ച സംമന്യസ്വ, ഏതാ യാ ആജ്ഞാഃ സന്തി താസ്ത്വം ജാനാസി| ");
INSERT INTO sanmal_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","തദാ സ ഉവാച, ബാല്യകാലാത് സർവ്വാ ഏതാ ആചരാമി| ");
INSERT INTO sanmal_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ഇതി കഥാം ശ്രുത്വാ യീശുസ്തമവദത്, തഥാപി തവൈകം കർമ്മ ന്യൂനമാസ്തേ, നിജം സർവ്വസ്വം വിക്രീയ ദരിദ്രേഭ്യോ വിതര, തസ്മാത് സ്വർഗേ ധനം പ്രാപ്സ്യസി; തത ആഗത്യ മമാനുഗാമീ ഭവ| ");
INSERT INTO sanmal_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","കിന്ത്വേതാം കഥാം ശ്രുത്വാ സോധിപതിഃ ശുശോച, യതസ്തസ്യ ബഹുധനമാസീത്| ");
INSERT INTO sanmal_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","തദാ യീശുസ്തമതിശോകാന്വിതം ദൃഷ്ട്വാ ജഗാദ, ധനവതാമ് ഈശ്വരരാജ്യപ്രവേശഃ കീദൃഗ് ദുഷ്കരഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ഈശ്വരരാജ്യേ ധനിനഃ പ്രവേശാത് സൂചേശ്ഛിദ്രേണ മഹാങ്ഗസ്യ ഗമനാഗമനേ സുകരേ| ");
INSERT INTO sanmal_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ശ്രോതാരഃ പപ്രച്ഛുസ്തർഹി കേന പരിത്രാണം പ്രാപ്സ്യതേ? ");
INSERT INTO sanmal_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","സ ഉക്തവാൻ, യൻ മാനുഷേണാശക്യം തദ് ഈശ്വരേണ ശക്യം| ");
INSERT INTO sanmal_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","തദാ പിതര ഉവാച, പശ്യ വയം സർവ്വസ്വം പരിത്യജ്യ തവ പശ്ചാദ്ഗാമിനോഽഭവാമ| ");
INSERT INTO sanmal_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","തതഃ സ ഉവാച, യുഷ്മാനഹം യഥാർഥം വദാമി, ഈശ്വരരാജ്യാർഥം ഗൃഹം പിതരൗ ഭ്രാതൃഗണം ജായാം സന്താനാംശ്ച ത്യക്തവാ ");
INSERT INTO sanmal_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ഇഹ കാലേ തതോഽധികം പരകാലേ ഽനന്തായുശ്ച ന പ്രാപ്സ്യതി ലോക ഈദൃശഃ കോപി നാസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","അനന്തരം സ ദ്വാദശശിഷ്യാനാഹൂയ ബഭാഷേ, പശ്യത വയം യിരൂശാലമ്നഗരം യാമഃ, തസ്മാത് മനുഷ്യപുത്രേ ഭവിഷ്യദ്വാദിഭിരുക്തം യദസ്തി തദനുരൂപം തം പ്രതി ഘടിഷ്യതേ; ");
INSERT INTO sanmal_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","വസ്തുതസ്തു സോഽന്യദേശീയാനാം ഹസ്തേഷു സമർപയിഷ്യതേ, തേ തമുപഹസിഷ്യന്തി, അന്യായമാചരിഷ്യന്തി തദ്വപുഷി നിഷ്ഠീവം നിക്ഷേപ്സ്യന്തി, കശാഭിഃ പ്രഹൃത്യ തം ഹനിഷ്യന്തി ച, ");
INSERT INTO sanmal_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","കിന്തു തൃതീയദിനേ സ ശ്മശാനാദ് ഉത്ഥാസ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ഏതസ്യാഃ കഥായാ അഭിപ്രായം കിഞ്ചിദപി തേ ബോദ്ധും ന ശേകുഃ തേഷാം നികടേഽസ്പഷ്ടതവാത് തസ്യൈതാസാം കഥാനാമ് ആശയം തേ ജ്ഞാതും ന ശേകുശ്ച| ");
INSERT INTO sanmal_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","അഥ തസ്മിൻ യിരീഹോഃ പുരസ്യാന്തികം പ്രാപ്തേ കശ്ചിദന്ധഃ പഥഃ പാർശ്വ ഉപവിശ്യ ഭിക്ഷാമ് അകരോത് ");
INSERT INTO sanmal_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","സ ലോകസമൂഹസ്യ ഗമനശബ്ദം ശ്രുത്വാ തത്കാരണം പൃഷ്ടവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","നാസരതീയയീശുര്യാതീതി ലോകൈരുക്തേ സ ഉച്ചൈർവക്തുമാരേഭേ, ");
INSERT INTO sanmal_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ഹേ ദായൂദഃ സന്താന യീശോ മാം ദയസ്വ| ");
INSERT INTO sanmal_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","തതോഗ്രഗാമിനസ്തം മൗനീ തിഷ്ഠേതി തർജയാമാസുഃ കിന്തു സ പുനാരുവൻ ഉവാച, ഹേ ദായൂദഃ സന്താന മാം ദയസ്വ| ");
INSERT INTO sanmal_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","തദാ യീശുഃ സ്ഥഗിതോ ഭൂത്വാ സ്വാന്തികേ തമാനേതുമ് ആദിദേശ| ");
INSERT INTO sanmal_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","തതഃ സ തസ്യാന്തികമ് ആഗമത്, തദാ സ തം പപ്രച്ഛ, ത്വം കിമിച്ഛസി? ത്വദർഥമഹം കിം കരിഷ്യാമി? സ ഉക്തവാൻ, ഹേ പ്രഭോഽഹം ദ്രഷ്ടും ലഭൈ| ");
INSERT INTO sanmal_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","തദാ യീശുരുവാച, ദൃഷ്ടിശക്തിം ഗൃഹാണ തവ പ്രത്യയസ്ത്വാം സ്വസ്ഥം കൃതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","തതസ്തത്ക്ഷണാത് തസ്യ ചക്ഷുഷീ പ്രസന്നേ; തസ്മാത് സ ഈശ്വരം ധന്യം വദൻ തത്പശ്ചാദ് യയൗ, തദാലോക്യ സർവ്വേ ലോകാ ഈശ്വരം പ്രശംസിതുമ് ആരേഭിരേ| ");
INSERT INTO sanmal_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","യദാ യീശു ര്യിരീഹോപുരം പ്രവിശ്യ തന്മധ്യേന ഗച്ഛംസ്തദാ ");
INSERT INTO sanmal_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","സക്കേയനാമാ കരസഞ്ചായിനാം പ്രധാനോ ധനവാനേകോ ");
INSERT INTO sanmal_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","യീശുഃ കീദൃഗിതി ദ്രഷ്ടും ചേഷ്ടിതവാൻ കിന്തു ഖർവ്വത്വാല്ലോകസംഘമധ്യേ തദ്ദർശനമപ്രാപ്യ ");
INSERT INTO sanmal_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","യേന പഥാ സ യാസ്യതി തത്പഥേഽഗ്രേ ധാവിത്വാ തം ദ്രഷ്ടുമ് ഉഡുമ്ബരതരുമാരുരോഹ| ");
INSERT INTO sanmal_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","പശ്ചാദ് യീശുസ്തത്സ്ഥാനമ് ഇത്വാ ഊർദ്ധ്വം വിലോക്യ തം ദൃഷ്ട്വാവാദീത്, ഹേ സക്കേയ ത്വം ശീഘ്രമവരോഹ മയാദ്യ ത്വദ്ഗേഹേ വസ്തവ്യം| ");
INSERT INTO sanmal_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","തതഃ സ ശീഘ്രമവരുഹ്യ സാഹ്ലാദം തം ജഗ്രാഹ| ");
INSERT INTO sanmal_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","തദ് ദൃഷ്ട്വാ സർവ്വേ വിവദമാനാ വക്തുമാരേഭിരേ, സോതിഥിത്വേന ദുഷ്ടലോകഗൃഹം ഗച്ഛതി| ");
INSERT INTO sanmal_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","കിന്തു സക്കേയോ ദണ്ഡായമാനോ വക്തുമാരേഭേ, ഹേ പ്രഭോ പശ്യ മമ യാ സമ്പത്തിരസ്തി തദർദ്ധം ദരിദ്രേഭ്യോ ദദേ, അപരമ് അന്യായം കൃത്വാ കസ്മാദപി യദി കദാപി കിഞ്ചിത് മയാ ഗൃഹീതം തർഹി തച്ചതുർഗുണം ദദാമി| ");
INSERT INTO sanmal_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","തദാ യീശുസ്തമുക്തവാൻ അയമപി ഇബ്രാഹീമഃ സന്താനോഽതഃ കാരണാദ് അദ്യാസ്യ ഗൃഹേ ത്രാണമുപസ്ഥിതം| ");
INSERT INTO sanmal_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","യദ് ഹാരിതം തത് മൃഗയിതും രക്ഷിതുഞ്ച മനുഷ്യപുത്ര ആഗതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","അഥ സ യിരൂശാലമഃ സമീപ ഉപാതിഷ്ഠദ് ഈശ്വരരാജത്വസ്യാനുഷ്ഠാനം തദൈവ ഭവിഷ്യതീതി ലോകൈരന്വഭൂയത, തസ്മാത് സ ശ്രോതൃഭ്യഃ പുനർദൃഷ്ടാന്തകഥാമ് ഉത്ഥാപ്യ കഥയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","കോപി മഹാല്ലോകോ നിജാർഥം രാജത്വപദം ഗൃഹീത്വാ പുനരാഗന്തും ദൂരദേശം ജഗാമ| ");
INSERT INTO sanmal_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","യാത്രാകാലേ നിജാൻ ദശദാസാൻ ആഹൂയ ദശസ്വർണമുദ്രാ ദത്ത്വാ മമാഗമനപര്യ്യന്തം വാണിജ്യം കുരുതേത്യാദിദേശ| ");
INSERT INTO sanmal_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","കിന്തു തസ്യ പ്രജാസ്തമവജ്ഞായ മനുഷ്യമേനമ് അസ്മാകമുപരി രാജത്വം ന കാരയിവ്യാമ ഇമാം വാർത്താം തന്നികടേ പ്രേരയാമാസുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","അഥ സ രാജത്വപദം പ്രാപ്യാഗതവാൻ ഏകൈകോ ജനോ ബാണിജ്യേന കിം ലബ്ധവാൻ ഇതി ജ്ഞാതും യേഷു ദാസേഷു മുദ്രാ അർപയത് താൻ ആഹൂയാനേതുമ് ആദിദേശ| ");
INSERT INTO sanmal_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","തദാ പ്രഥമ ആഗത്യ കഥിതവാൻ, ഹേ പ്രഭോ തവ തയൈകയാ മുദ്രയാ ദശമുദ്രാ ലബ്ധാഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","തതഃ സ ഉവാച ത്വമുത്തമോ ദാസഃ സ്വൽപേന വിശ്വാസ്യോ ജാത ഇതഃ കാരണാത് ത്വം ദശനഗരാണാമ് അധിപോ ഭവ| ");
INSERT INTO sanmal_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","ദ്വിതീയ ആഗത്യ കഥിതവാൻ, ഹേ പ്രഭോ തവൈകയാ മുദ്രയാ പഞ്ചമുദ്രാ ലബ്ധാഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","തതഃ സ ഉവാച, ത്വം പഞ്ചാനാം നഗരാണാമധിപതി ർഭവ| ");
INSERT INTO sanmal_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","തതോന്യ ആഗത്യ കഥയാമാസ, ഹേ പ്രഭോ പശ്യ തവ യാ മുദ്രാ അഹം വസ്ത്രേ ബദ്ധ്വാസ്ഥാപയം സേയം| ");
INSERT INTO sanmal_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ത്വം കൃപണോ യന്നാസ്ഥാപയസ്തദപി ഗൃഹ്ലാസി, യന്നാവപസ്തദേവ ച ഛിനത്സി തതോഹം ത്വത്തോ ഭീതഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","തദാ സ ജഗാദ, രേ ദുഷ്ടദാസ തവ വാക്യേന ത്വാം ദോഷിണം കരിഷ്യാമി, യദഹം നാസ്ഥാപയം തദേവ ഗൃഹ്ലാമി, യദഹം നാവപഞ്ച തദേവ ഛിനദ്മി, ഏതാദൃശഃ കൃപണോഹമിതി യദി ത്വം ജാനാസി, ");
INSERT INTO sanmal_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","തർഹി മമ മുദ്രാ ബണിജാം നികടേ കുതോ നാസ്ഥാപയഃ? തയാ കൃതേഽഹമ് ആഗത്യ കുസീദേന സാർദ്ധം നിജമുദ്രാ അപ്രാപ്സ്യമ്| ");
INSERT INTO sanmal_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","പശ്ചാത് സ സമീപസ്ഥാൻ ജനാൻ ആജ്ഞാപയത് അസ്മാത് മുദ്രാ ആനീയ യസ്യ ദശമുദ്രാഃ സന്തി തസ്മൈ ദത്ത| ");
INSERT INTO sanmal_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","തേ പ്രോചുഃ പ്രഭോഽസ്യ ദശമുദ്രാഃ സന്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","യുഷ്മാനഹം വദാമി യസ്യാശ്രയേ വദ്ധതേ ഽധികം തസ്മൈ ദായിഷ്യതേ, കിന്തു യസ്യാശ്രയേ ന വർദ്ധതേ തസ്യ യദ്യദസ്തി തദപി തസ്മാൻ നായിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","കിന്തു മമാധിപതിത്വസ്യ വശത്വേ സ്ഥാതുമ് അസമ്മന്യമാനാ യേ മമ രിപവസ്താനാനീയ മമ സമക്ഷം സംഹരത| ");
INSERT INTO sanmal_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ഇത്യുപദേശകഥാം കഥയിത്വാ സോഗ്രഗഃ സൻ യിരൂശാലമപുരം യയൗ| ");
INSERT INTO sanmal_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","തതോ ബൈത്ഫഗീബൈഥനീയാഗ്രാമയോഃ സമീപേ ജൈതുനാദ്രേരന്തികമ് ഇത്വാ ശിഷ്യദ്വയമ് ഇത്യുക്ത്വാ പ്രേഷയാമാസ, ");
INSERT INTO sanmal_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","യുവാമമും സമ്മുഖസ്ഥഗ്രാമം പ്രവിശ്യൈവ യം കോപി മാനുഷഃ കദാപി നാരോഹത് തം ഗർദ്ദഭശാവകം ബദ്ധം ദ്രക്ഷ്യഥസ്തം മോചയിത്വാനയതം| ");
INSERT INTO sanmal_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","തത്ര കുതോ മോചയഥഃ? ഇതി ചേത് കോപി വക്ഷ്യതി തർഹി വക്ഷ്യഥഃ പ്രഭേाരത്ര പ്രയോജനമ് ആസ്തേ| ");
INSERT INTO sanmal_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","തദാ തൗ പ്രരിതൗ ഗത്വാ തത്കഥാाനുസാരേണ സർവ്വം പ്രാപ്തൗ| ");
INSERT INTO sanmal_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ഗർദഭശാവകമോചനകാലേ തത്വാമിന ഊചുഃ, ഗർദഭശാവകം കുതോ മോചയഥഃ? ");
INSERT INTO sanmal_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","താവൂചതുഃ പ്രഭോരത്ര പ്രയോജനമ് ആസ്തേ| ");
INSERT INTO sanmal_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","പശ്ചാത് തൗ തം ഗർദഭശാവകം യീശോരന്തികമാനീയ തത്പൃഷ്ഠേ നിജവസനാനി പാതയിത്വാ തദുപരി യീശുമാരോഹയാമാസതുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","അഥ യാത്രാകാലേ ലോകാഃ പഥി സ്വവസ്ത്രാണി പാതയിതുമ് ആരേഭിരേ| ");
INSERT INTO sanmal_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","അപരം ജൈതുനാദ്രേരുപത്യകാമ് ഇത്വാ ശിഷ്യസംഘഃ പൂർവ്വദൃഷ്ടാനി മഹാകർമ്മാണി സ്മൃത്വാ, ");
INSERT INTO sanmal_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","യോ രാജാ പ്രഭോ ർനാമ്നായാതി സ ധന്യഃ സ്വർഗേ കുശലം സർവ്വോച്ചേ ജയധ്വനി ർഭവതു, കഥാമേതാം കഥയിത്വാ സാനന്ദമ് ഉചൈരീശ്വരം ധന്യം വക്തുമാരേഭേ| ");
INSERT INTO sanmal_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","തദാ ലോകാരണ്യമധ്യസ്ഥാഃ കിയന്തഃ ഫിരൂശിനസ്തത് ശ്രുത്വാ യീശും പ്രോചുഃ, ഹേ ഉപദേശക സ്വശിഷ്യാൻ തർജയ| ");
INSERT INTO sanmal_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","സ ഉവാച, യുഷ്മാനഹം വദാമി യദ്യമീ നീരവാസ്തിഷ്ഠന്തി തർഹി പാഷാണാ ഉചൈഃ കഥാഃ കഥയിഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","പശ്ചാത് തത്പുരാന്തികമേത്യ തദവലോക്യ സാശ്രുപാതം ജഗാദ, ");
INSERT INTO sanmal_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ഹാ ഹാ ചേത് ത്വമഗ്രേഽജ്ഞാസ്യഥാഃ, തവാസ്മിന്നേവ ദിനേ വാ യദി സ്വമങ്ഗലമ് ഉപാലപ്സ്യഥാഃ, തർഹ്യുത്തമമ് അഭവിഷ്യത്, കിന്തു ക്ഷണേസ്മിൻ തത്തവ ദൃഷ്ടേരഗോചരമ് ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ത്വം സ്വത്രാണകാലേ ന മനോ ന്യധത്ഥാ ഇതി ഹേതോ ര്യത്കാലേ തവ രിപവസ്ത്വാം ചതുർദിക്ഷു പ്രാചീരേണ വേഷ്ടയിത്വാ രോത്സ്യന്തി ");
INSERT INTO sanmal_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ബാലകൈഃ സാർദ്ധം ഭൂമിസാത് കരിഷ്യന്തി ച ത്വന്മധ്യേ പാഷാണൈകോപി പാഷാണോപരി ന സ്ഥാസ്യതി ച, കാല ഈദൃശ ഉപസ്ഥാസ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","അഥ മധ്യേമന്ദിരം പ്രവിശ്യ തത്രത്യാൻ ക്രയിവിക്രയിണോ ബഹിഷ്കുർവ്വൻ ");
INSERT INTO sanmal_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","അവദത് മദ്ഗൃഹം പ്രാർഥനാഗൃഹമിതി ലിപിരാസ്തേ കിന്തു യൂയം തദേവ ചൈരാണാം ഗഹ്വരം കുരുഥ| ");
INSERT INTO sanmal_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","പശ്ചാത് സ പ്രത്യഹം മധ്യേമന്ദിരമ് ഉപദിദേശ; തതഃ പ്രധാനയാജകാ അധ്യാപകാഃ പ്രാചീനാശ്ച തം നാശയിതും ചിചേഷ്ടിരേ; ");
INSERT INTO sanmal_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","കിന്തു തദുപദേശേ സർവ്വേ ലോകാ നിവിഷ്ടചിത്താഃ സ്ഥിതാസ്തസ്മാത് തേ തത്കർത്തും നാവകാശം പ്രാപുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","അഥൈകദാ യീശു ർമനിദരേ സുസംവാദം പ്രചാരയൻ ലോകാനുപദിശതി, ഏതർഹി പ്രധാനയാജകാ അധ്യാപകാഃ പ്രാഞ്ചശ്ച തന്നികടമാഗത്യ പപ്രച്ഛുഃ ");
INSERT INTO sanmal_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","കയാജ്ഞയാ ത്വം കർമ്മാണ്യേതാനി കരോഷി? കോ വാ ത്വാമാജ്ഞാപയത്? തദസ്മാൻ വദ| ");
INSERT INTO sanmal_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","സ പ്രത്യുവാച, തർഹി യുഷ്മാനപി കഥാമേകാം പൃച്ഛാമി തസ്യോത്തരം വദത| ");
INSERT INTO sanmal_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","യോഹനോ മജ്ജനമ് ഈശ്വരസ്യ മാനുഷാണാം വാജ്ഞാതോ ജാതം? ");
INSERT INTO sanmal_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","തതസ്തേ മിഥോ വിവിച്യ ജഗദുഃ, യദീശ്വരസ്യ വദാമസ്തർഹി തം കുതോ ന പ്രത്യൈത സ ഇതി വക്ഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","യദി മനുഷ്യസ്യേതി വദാമസ്തർഹി സർവ്വേ ലോകാ അസ്മാൻ പാഷാണൈ ർഹനിഷ്യന്തി യതോ യോഹൻ ഭവിഷ്യദ്വാദീതി സർവ്വേ ദൃഢം ജാനന്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","അതഏവ തേ പ്രത്യൂചുഃ കസ്യാജ്ഞയാ ജാതമ് ഇതി വക്തും ന ശക്നുമഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","തദാ യീശുരവദത് തർഹി കയാജ്ഞയാ കർമ്മാണ്യേതാതി കരോമീതി ച യുഷ്മാൻ ന വക്ഷ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","അഥ ലോകാനാം സാക്ഷാത് സ ഇമാം ദൃഷ്ടാന്തകഥാം വക്തുമാരേഭേ, കശ്ചിദ് ദ്രാക്ഷാക്ഷേത്രം കൃത്വാ തത് ക്ഷേത്രം കൃഷീവലാനാം ഹസ്തേഷു സമർപ്യ ബഹുകാലാർഥം ദൂരദേശം ജഗാമ| ");
INSERT INTO sanmal_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","അഥ ഫലകാലേ ഫലാനി ഗ്രഹീതു കൃഷീവലാനാം സമീപേ ദാസം പ്രാഹിണോത് കിന്തു കൃഷീവലാസ്തം പ്രഹൃത്യ രിക്തഹസ്തം വിസസർജുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","തതഃ സോധിപതിഃ പുനരന്യം ദാസം പ്രേഷയാമാസ, തേ തമപി പ്രഹൃത്യ കുവ്യവഹൃത്യ രിക്തഹസ്തം വിസസൃജുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","തതഃ സ തൃതീയവാരമ് അന്യം പ്രാഹിണോത് തേ തമപി ക്ഷതാങ്ഗം കൃത്വാ ബഹി ർനിചിക്ഷിപുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","തദാ ക്ഷേത്രപതി ർവിചാരയാമാസ, മമേദാനീം കിം കർത്തവ്യം? മമ പ്രിയേ പുത്രേ പ്രഹിതേ തേ തമവശ്യം ദൃഷ്ട്വാ സമാദരിഷ്യന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","കിന്തു കൃഷീവലാസ്തം നിരീക്ഷ്യ പരസ്പരം വിവിച്യ പ്രോചുഃ, അയമുത്തരാധികാരീ ആഗച്ഛതൈനം ഹന്മസ്തതോധികാരോസ്മാകം ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","തതസ്തേ തം ക്ഷേത്രാദ് ബഹി ർനിപാത്യ ജഘ്നുസ്തസ്മാത് സ ക്ഷേത്രപതിസ്താൻ പ്രതി കിം കരിഷ്യതി? ");
INSERT INTO sanmal_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","സ ആഗത്യ താൻ കൃഷീവലാൻ ഹത്വാ പരേഷാം ഹസ്തേഷു തത്ക്ഷേത്രം സമർപയിഷ്യതി; ഇതി കഥാം ശ്രുത്വാ തേ ഽവദൻ ഏതാദൃശീ ഘടനാ ന ഭവതു| ");
INSERT INTO sanmal_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","കിന്തു യീശുസ്താനവലോക്യ ജഗാദ, തർഹി, സ്ഥപതയഃ കരിഷ്യന്തി ഗ്രാവാണം യന്തു തുച്ഛകം| പ്രധാനപ്രസ്തരഃ കോണേ സ ഏവ ഹി ഭവിഷ്യതി| ഏതസ്യ ശാസ്ത്രീയവചനസ്യ കിം താത്പര്യ്യം? ");
INSERT INTO sanmal_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","അപരം തത്പാഷാണോപരി യഃ പതിഷ്യതി സ ഭംക്ഷ്യതേ കിന്തു യസ്യോപരി സ പാഷാണഃ പതിഷ്യതി സ തേന ധൂലിവച് ചൂർണീഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","സോസ്മാകം വിരുദ്ധം ദൃഷ്ടാന്തമിമം കഥിതവാൻ ഇതി ജ്ഞാത്വാ പ്രധാനയാജകാ അധ്യാപകാശ്ച തദൈവ തം ധർതും വവാഞ്ഛുഃ കിന്തു ലോകേഭ്യോ ബിഭ്യുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","അതഏവ തം പ്രതി സതർകാഃ സന്തഃ കഥം തദ്വാക്യദോഷം ധൃത്വാ തം ദേശാധിപസ്യ സാധുവേശധാരിണശ്ചരാൻ തസ്യ സമീപേ പ്രേഷയാമാസുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","തദാ തേ തം പപ്രച്ഛുഃ, ഹേ ഉപദേശക ഭവാൻ യഥാർഥം കഥയൻ ഉപദിശതി, കമപ്യനപേക്ഷ്യ സത്യത്വേനൈശ്വരം മാർഗമുപദിശതി, വയമേതജ്ജാനീമഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","കൈസരരാജായ കരോസ്മാഭി ർദേയോ ന വാ? ");
INSERT INTO sanmal_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","സ തേഷാം വഞ്ചനം ജ്ഞാത്വാവദത് കുതോ മാം പരീക്ഷധ്വേ? മാം മുദ്രാമേകം ദർശയത| ");
INSERT INTO sanmal_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","ഇഹ ലിഖിതാ മൂർതിരിയം നാമ ച കസ്യ? തേഽവദൻ കൈസരസ്യ| ");
INSERT INTO sanmal_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","തദാ സ ഉവാച, തർഹി കൈസരസ്യ ദ്രവ്യം കൈസരായ ദത്ത; ഈശ്വരസ്യ തു ദ്രവ്യമീശ്വരായ ദത്ത| ");
INSERT INTO sanmal_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","തസ്മാല്ലോകാനാം സാക്ഷാത് തത്കഥായാഃ കമപി ദോഷം ധർതുമപ്രാപ്യ തേ തസ്യോത്തരാദ് ആശ്ചര്യ്യം മന്യമാനാ മൗനിനസ്തസ്ഥുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","അപരഞ്ച ശ്മശാനാദുത്ഥാനാനങ്ഗീകാരിണാം സിദൂകിനാം കിയന്തോ ജനാ ആഗത്യ തം പപ്രച്ഛുഃ, ");
INSERT INTO sanmal_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","ഹേ ഉപദേശക ശാസ്ത്രേ മൂസാ അസ്മാൻ പ്രതീതി ലിലേഖ യസ്യ ഭ്രാതാ ഭാര്യ്യായാം സത്യാം നിഃസന്താനോ മ്രിയതേ സ തജ്ജായാം വിവഹ്യ തദ്വംശമ് ഉത്പാദയിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","തഥാച കേചിത് സപ്ത ഭ്രാതര ആസൻ തേഷാം ജ്യേഷ്ഠോ ഭ്രാതാ വിവഹ്യ നിരപത്യഃ പ്രാണാൻ ജഹൗ| ");
INSERT INTO sanmal_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","അഥ ദ്വിതീയസ്തസ്യ ജായാം വിവഹ്യ നിരപത്യഃ സൻ മമാര| തൃതീയശ്ച താമേവ വ്യുവാഹ; ");
INSERT INTO sanmal_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ഇത്ഥം സപ്ത ഭ്രാതരസ്താമേവ വിവഹ്യ നിരപത്യാഃ സന്തോ മമ്രുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ശേഷേ സാ സ്ത്രീ ച മമാര| ");
INSERT INTO sanmal_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","അതഏവ ശ്മശാനാദുത്ഥാനകാലേ തേഷാം സപ്തജനാനാം കസ്യ സാ ഭാര്യ്യാ ഭവിഷ്യതി? യതഃ സാ തേഷാം സപ്താനാമേവ ഭാര്യ്യാസീത്| ");
INSERT INTO sanmal_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","തദാ യീശുഃ പ്രത്യുവാച, ഏതസ്യ ജഗതോ ലോകാ വിവഹന്തി വാഗ്ദത്താശ്ച ഭവന്തി ");
INSERT INTO sanmal_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","കിന്തു യേ തജ്ജഗത്പ്രാപ്തിയോഗ്യത്വേന ഗണിതാം ഭവിഷ്യന്തി ശ്മശാനാച്ചോത്ഥാസ്യന്തി തേ ന വിവഹന്തി വാഗ്ദത്താശ്ച ന ഭവന്തി, ");
INSERT INTO sanmal_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","തേ പുന ർന മ്രിയന്തേ കിന്തു ശ്മശാനാദുത്ഥാപിതാഃ സന്ത ഈശ്വരസ്യ സന്താനാഃ സ്വർഗീയദൂതാനാം സദൃശാശ്ച ഭവന്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","അധികന്തു മൂസാഃ സ്തമ്ബോപാഖ്യാനേ പരമേശ്വര ഈബ്രാഹീമ ഈശ്വര ഇസ്ഹാക ഈശ്വരോ യാകൂബശ്ചേശ്വര ഇത്യുക്ത്വാ മൃതാനാം ശ്മശാനാദ് ഉത്ഥാനസ്യ പ്രമാണം ലിലേഖ| ");
INSERT INTO sanmal_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","അതഏവ യ ഈശ്വരഃ സ മൃതാനാം പ്രഭു ർന കിന്തു ജീവതാമേവ പ്രഭുഃ, തന്നികടേ സർവ്വേ ജീവന്തഃ സന്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ഇതി ശ്രുത്വാ കിയന്തോധ്യാപകാ ഊചുഃ, ഹേ ഉപദേശക ഭവാൻ ഭദ്രം പ്രത്യുക്തവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ഇതഃ പരം തം കിമപി പ്രഷ്ടം തേഷാം പ്രഗൽഭതാ നാഭൂത്| ");
INSERT INTO sanmal_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","പശ്ചാത് സ താൻ ഉവാച, യഃ ഖ്രീഷ്ടഃ സ ദായൂദഃ സന്താന ഏതാം കഥാം ലോകാഃ കഥം കഥയന്തി? ");
INSERT INTO sanmal_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","യതഃ മമ പ്രഭുമിദം വാക്യമവദത് പരമേശ്വരഃ| തവ ശത്രൂനഹം യാവത് പാദപീഠം കരോമി ന| താവത് കാലം മദീയേ ത്വം ദക്ഷപാർശ്വ ഉപാവിശ| ");
INSERT INTO sanmal_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ഇതി കഥാം ദായൂദ് സ്വയം ഗീതഗ്രന്ഥേഽവദത്| ");
INSERT INTO sanmal_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","അതഏവ യദി ദായൂദ് തം പ്രഭും വദതി, തർഹി സ കഥം തസ്യ സന്താനോ ഭവതി? ");
INSERT INTO sanmal_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","പശ്ചാദ് യീശുഃ സർവ്വജനാനാം കർണഗോചരേ ശിഷ്യാനുവാച, ");
INSERT INTO sanmal_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","യേഽധ്യാപകാ ദീർഘപരിച്ഛദം പരിധായ ഭ്രമന്തി, ഹട്ടാപണയോ ർനമസ്കാരേ ഭജനഗേഹസ്യ പ്രോച്ചാസനേ ഭോജനഗൃഹസ്യ പ്രധാനസ്ഥാനേ ച പ്രീയന്തേ ");
INSERT INTO sanmal_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","വിധവാനാം സർവ്വസ്വം ഗ്രസിത്വാ ഛലേന ദീർഘകാലം പ്രാർഥയന്തേ ച തേഷു സാവധാനാ ഭവത, തേഷാമുഗ്രദണ്ഡോ ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","അഥ ധനിലോകാ ഭാണ്ഡാഗാരേ ധനം നിക്ഷിപന്തി സ തദേവ പശ്യതി, ");
INSERT INTO sanmal_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ഏതർഹി കാചിദ്ദീനാ വിധവാ പണദ്വയം നിക്ഷിപതി തദ് ദദർശ| ");
INSERT INTO sanmal_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","തതോ യീശുരുവാച യുഷ്മാനഹം യഥാർഥം വദാമി, ദരിദ്രേയം വിധവാ സർവ്വേഭ്യോധികം ന്യക്ഷേപ്സീത്, ");
INSERT INTO sanmal_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","യതോന്യേ സ്വപ്രാജ്യധനേഭ്യ ഈശ്വരായ കിഞ്ചിത് ന്യക്ഷേപ്സുഃ, കിന്തു ദരിദ്രേയം വിധവാ ദിനയാപനാർഥം സ്വസ്യ യത് കിഞ്ചിത് സ്ഥിതം തത് സർവ്വം ന്യക്ഷേപ്സീത്| ");
INSERT INTO sanmal_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","അപരഞ്ച ഉത്തമപ്രസ്തരൈരുത്സൃഷ്ടവ്യൈശ്ച മന്ദിരം സുശോഭതേതരാം കൈശ്ചിദിത്യുക്തേ സ പ്രത്യുവാച ");
INSERT INTO sanmal_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","യൂയം യദിദം നിചയനം പശ്യഥ, അസ്യ പാഷാണൈകോപ്യന്യപാഷാണോപരി ന സ്ഥാസ്യതി, സർവ്വേ ഭൂസാദ്ഭവിഷ്യന്തി കാലോയമായാതി| ");
INSERT INTO sanmal_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","തദാ തേ പപ്രച്ഛുഃ, ഹേ ഗുരോ ഘടനേദൃശീ കദാ ഭവിഷ്യതി? ഘടനായാ ഏതസ്യസശ്ചിഹ്നം വാ കിം ഭവിഷ്യതി? ");
INSERT INTO sanmal_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","തദാ സ ജഗാദ, സാവധാനാ ഭവത യഥാ യുഷ്മാകം ഭ്രമം കോപി ന ജനയതി, ഖീഷ്ടോഹമിത്യുക്ത്വാ മമ നാമ്രാ ബഹവ ഉപസ്ഥാസ്യന്തി സ കാലഃ പ്രായേണോപസ്ഥിതഃ, തേഷാം പശ്ചാന്മാ ഗച്ഛത| ");
INSERT INTO sanmal_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","യുദ്ധസ്യോപപ്ലവസ്യ ച വാർത്താം ശ്രുത്വാ മാ ശങ്കധ്വം, യതഃ പ്രഥമമ് ഏതാ ഘടനാ അവശ്യം ഭവിഷ്യന്തി കിന്തു നാപാതേ യുഗാന്തോ ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","അപരഞ്ച കഥയാമാസ, തദാ ദേശസ്യ വിപക്ഷത്വേന ദേശോ രാജ്യസ്യ വിപക്ഷത്വേന രാജ്യമ് ഉത്ഥാസ്യതി, ");
INSERT INTO sanmal_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","നാനാസ്ഥാനേഷു മഹാഭൂകമ്പോ ദുർഭിക്ഷം മാരീ ച ഭവിഷ്യന്തി, തഥാ വ്യോമമണ്ഡലസ്യ ഭയങ്കരദർശനാന്യശ്ചര്യ്യലക്ഷണാനി ച പ്രകാശയിഷ്യന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","കിന്തു സർവ്വാസാമേതാസാം ഘടനാനാം പൂർവ്വം ലോകാ യുഷ്മാൻ ധൃത്വാ താഡയിഷ്യന്തി, ഭജനാലയേ കാരായാഞ്ച സമർപയിഷ്യന്തി മമ നാമകാരണാദ് യുഷ്മാൻ ഭൂപാനാം ശാസകാനാഞ്ച സമ്മുഖം നേഷ്യന്തി ച| ");
INSERT INTO sanmal_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","സാക്ഷ്യാർഥമ് ഏതാനി യുഷ്മാൻ പ്രതി ഘടിഷ്യന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","തദാ കിമുത്തരം വക്തവ്യമ് ഏതത് ന ചിന്തയിഷ്യാമ ഇതി മനഃസു നിശ്ചിതനുത| ");
INSERT INTO sanmal_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","വിപക്ഷാ യസ്മാത് കിമപ്യുത്തരമ് ആപത്തിഞ്ച കർത്തും ന ശക്ഷ്യന്തി താദൃശം വാക്പടുത്വം ജ്ഞാനഞ്ച യുഷ്മഭ്യം ദാസ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","കിഞ്ച യൂയം പിത്രാ മാത്രാ ഭ്രാത്രാ ബന്ധുനാ ജ്ഞാത്യാ കുടുമ്ബേന ച പരകരേഷു സമർപയിഷ്യധ്വേ; തതസ്തേ യുഷ്മാകം കഞ്ചന കഞ്ചന ഘാതയിഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","മമ നാമ്നഃ കാരണാത് സർവ്വൈ ർമനുഷ്യൈ ര്യൂയമ് ഋതീയിഷ്യധ്വേ| ");
INSERT INTO sanmal_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","കിന്തു യുഷ്മാകം ശിരഃകേശൈകോപി ന വിനംക്ഷ്യതി, ");
INSERT INTO sanmal_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","തസ്മാദേവ ധൈര്യ്യമവലമ്ബ്യ സ്വസ്വപ്രാണാൻ രക്ഷത| ");
INSERT INTO sanmal_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","അപരഞ്ച യിരൂശാലമ്പുരം സൈന്യവേഷ്ടിതം വിലോക്യ തസ്യോച്ഛിന്നതായാഃ സമയഃ സമീപ ഇത്യവഗമിഷ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","തദാ യിഹൂദാദേശസ്ഥാ ലോകാഃ പർവ്വതം പലായന്താം, യേ ച നഗരേ തിഷ്ഠന്തി തേ ദേശാന്തരം പലായന്താ, യേ ച ഗ്രാമേ തിഷ്ഠന്തി തേ നഗരം ന പ്രവിശന്തു, ");
INSERT INTO sanmal_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","യതസ്തദാ സമുചിതദണ്ഡനായ ധർമ്മപുസ്തകേ യാനി സർവ്വാണി ലിഖിതാനി താനി സഫലാനി ഭവിഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","കിന്തു യാ യാസ്തദാ ഗർഭവത്യഃ സ്തന്യദാവ്യശ്ച താമാം ദുർഗതി ർഭവിഷ്യതി, യത ഏതാല്ലോകാൻ പ്രതി കോപോ ദേശേ ച വിഷമദുർഗതി ർഘടിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","വസ്തുതസ്തു തേ ഖങ്ഗധാരപരിവ്വങ്ഗം ലപ്സ്യന്തേ ബദ്ധാഃ സന്തഃ സർവ്വദേശേഷു നായിഷ്യന്തേ ച കിഞ്ചാന്യദേശീയാനാം സമയോപസ്ഥിതിപര്യ്യന്തം യിരൂശാലമ്പുരം തൈഃ പദതലൈ ർദലയിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","സൂര്യ്യചന്ദ്രനക്ഷത്രേഷു ലക്ഷണാദി ഭവിഷ്യന്തി, ഭുവി സർവ്വദേശീയാനാം ദുഃഖം ചിന്താ ച സിന്ധൗ വീചീനാം തർജനം ഗർജനഞ്ച ഭവിഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ഭൂഭൗ ഭാവിഘടനാം ചിന്തയിത്വാ മനുജാ ഭിയാമൃതകൽപാ ഭവിഷ്യന്തി, യതോ വ്യോമമണ്ഡലേ തേജസ്വിനോ ദോലായമാനാ ഭവിഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","തദാ പരാക്രമേണാ മഹാതേജസാ ച മേഘാരൂഢം മനുഷ്യപുത്രമ് ആയാന്തം ദ്രക്ഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","കിന്ത്വേതാസാം ഘടനാനാമാരമ്ഭേ സതി യൂയം മസ്തകാന്യുത്തോല്യ ഊർദധ്വം ദ്രക്ഷ്യഥ, യതോ യുഷ്മാകം മുക്തേഃ കാലഃ സവിധോ ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","തതസ്തേനൈതദൃഷ്ടാന്തകഥാ കഥിതാ, പശ്യത ഉഡുമ്ബരാദിവൃക്ഷാണാം ");
INSERT INTO sanmal_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","നവീനപത്രാണി ജാതാനീതി ദൃഷ്ട്വാ നിദാവകാല ഉപസ്ഥിത ഇതി യഥാ യൂയം ജ്ഞാതും ശക്നുഥ, ");
INSERT INTO sanmal_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","തഥാ സർവ്വാസാമാസാം ഘടനാനാമ് ആരമ്ഭേ ദൃഷ്ടേ സതീശ്വരസ്യ രാജത്വം നികടമ് ഇത്യപി ജ്ഞാസ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","യുഷ്മാനഹം യഥാർഥം വദാമി, വിദ്യമാനലോകാനാമേഷാം ഗമനാത് പൂർവ്വമ് ഏതാനി ഘടിഷ്യന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","നഭോഭുവോർലോപോ ഭവിഷ്യതി മമ വാക് തു കദാപി ലുപ്താ ന ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","അതഏവ വിഷമാശനേന പാനേന ച സാംമാരികചിന്താഭിശ്ച യുഷ്മാകം ചിത്തേഷു മത്തേഷു തദ്ദിനമ് അകസ്മാദ് യുഷ്മാൻ പ്രതി യഥാ നോപതിഷ്ഠതി തദർഥം സ്വേഷു സാവധാനാസ്തിഷ്ഠത| ");
INSERT INTO sanmal_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","പൃഥിവീസ്ഥസർവ്വലോകാൻ പ്രതി തദ്ദിനമ് ഉന്മാഥ ഇവ ഉപസ്ഥാസ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","യഥാ യൂയമ് ഏതദ്ഭാവിഘടനാ ഉത്തർത്തും മനുജസുതസ്യ സമ്മുഖേ സംസ്ഥാതുഞ്ച യോഗ്യാ ഭവഥ കാരണാദസ്മാത് സാവധാനാഃ സന്തോ നിരന്തരം പ്രാർഥയധ്വം| ");
INSERT INTO sanmal_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","അപരഞ്ച സ ദിവാ മന്ദിര ഉപദിശ്യ രാചൈ ജൈതുനാദ്രിം ഗത്വാതിഷ്ഠത്| ");
INSERT INTO sanmal_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","തതഃ പ്രത്യൂഷേ ലാകാസ്തത്കഥാം ശ്രോതും മന്ദിരേ തദന്തികമ് ആഗച്ഛൻ| ");
INSERT INTO sanmal_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","അപരഞ്ച കിണ്വശൂന്യപൂപോത്സവസ്യ കാല ഉപസ്ഥിതേ ");
INSERT INTO sanmal_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","പ്രധാനയാജകാ അധ്യായകാശ്ച യഥാ തം ഹന്തും ശക്നുവന്തി തഥോപായാമ് അചേഷ്ടന്ത കിന്തു ലോകേഭ്യോ ബിഭ്യുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ഏതസ്തിൻ സമയേ ദ്വാദശശിഷ്യേഷു ഗണിത ഈഷ്കരിയോതീയരൂഢിമാൻ യോ യിഹൂദാസ്തസ്യാന്തഃകരണം ശൈതാനാശ്രിതത്വാത് ");
INSERT INTO sanmal_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","സ ഗത്വാ യഥാ യീശും തേഷാം കരേഷു സമർപയിതും ശക്നോതി തഥാ മന്ത്രണാം പ്രധാനയാജകൈഃ സേനാപതിഭിശ്ച സഹ ചകാര| ");
INSERT INTO sanmal_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","തേന തേ തുഷ്ടാസ്തസ്മൈ മുദ്രാം ദാതും പണം ചക്രുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","തതഃ സോങ്ഗീകൃത്യ യഥാ ലോകാനാമഗോചരേ തം പരകരേഷു സമർപയിതും ശക്നോതി തഥാവകാശം ചേഷ്ടിതുമാരേഭേ| ");
INSERT INTO sanmal_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","അഥ കിണ്വശൂന്യപൂപോത്മവദിനേ, അർഥാത് യസ്മിൻ ദിനേ നിസ്താരോത്സവസ്യ മേഷോ ഹന്തവ്യസ്തസ്മിൻ ദിനേ ");
INSERT INTO sanmal_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","യീശുഃ പിതരം യോഹനഞ്ചാഹൂയ ജഗാദ, യുവാം ഗത്വാസ്മാകം ഭോജനാർഥം നിസ്താരോത്സവസ്യ ദ്രവ്യാണ്യാസാദയതം| ");
INSERT INTO sanmal_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","തദാ തൗ പപ്രച്ഛതുഃ കുചാസാദയാവോ ഭവതഃ കേച്ഛാ? ");
INSERT INTO sanmal_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","തദാ സോവാദീത്, നഗരേ പ്രവിഷ്ടേ കശ്ചിജ്ജലകുമ്ഭമാദായ യുവാം സാക്ഷാത് കരിഷ്യതി സ യന്നിവേശനം പ്രവിശതി യുവാമപി തന്നിവേശനം തത്പശ്ചാദിത്വാ നിവേശനപതിമ് ഇതി വാക്യം വദതം, ");
INSERT INTO sanmal_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","യത്രാഹം നിസ്താരോത്സവസ്യ ഭോജ്യം ശിഷ്യൈഃ സാർദ്ധം ഭോക്തും ശക്നോമി സാതിഥിശാലാा കുത്ര? കഥാമിമാം പ്രഭുസ്ത്വാം പൃച്ഛതി| ");
INSERT INTO sanmal_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","തതഃ സ ജനോ ദ്വിതീയപ്രകോഷ്ഠീയമ് ഏകം ശസ്തം കോഷ്ഠം ദർശയിഷ്യതി തത്ര ഭോജ്യമാസാദയതം| ");
INSERT INTO sanmal_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","തതസ്തൗ ഗത്വാ തദ്വാക്യാനുസാരേണ സർവ്വം ദൃഷ്ദ്വാ തത്ര നിസ്താരോത്സവീയം ഭോജ്യമാസാദയാമാസതുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","അഥ കാല ഉപസ്ഥിതേ യീശു ർദ്വാദശഭിഃ പ്രേരിതൈഃ സഹ ഭോക്തുമുപവിശ്യ കഥിതവാൻ ");
INSERT INTO sanmal_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","മമ ദുഃഖഭോഗാത് പൂർവ്വം യുഭാഭിഃ സഹ നിസ്താരോത്സവസ്യൈതസ്യ ഭോജ്യം ഭോക്തും മയാതിവാഞ്ഛാ കൃതാ| ");
INSERT INTO sanmal_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","യുഷ്മാൻ വദാമി, യാവത്കാലമ് ഈശ്വരരാജ്യേ ഭോജനം ന കരിഷ്യേ താവത്കാലമ് ഇദം ന ഭോക്ഷ്യേ| ");
INSERT INTO sanmal_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","തദാ സ പാനപാത്രമാദായ ഈശ്വരസ്യ ഗുണാൻ കീർത്തയിത്വാ തേഭ്യോ ദത്വാവദത്, ഇദം ഗൃഹ്ലീത യൂയം വിഭജ്യ പിവത| ");
INSERT INTO sanmal_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","യുഷ്മാൻ വദാമി യാവത്കാലമ് ഈശ്വരരാജത്വസ്യ സംസ്ഥാപനം ന ഭവതി താവദ് ദ്രാക്ഷാഫലരസം ന പാസ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","തതഃ പൂപം ഗൃഹീത്വാ ഈശ്വരഗുണാൻ കീർത്തയിത്വാ ഭങ്ക്താ തേഭ്യോ ദത്വാവദത്, യുഷ്മദർഥം സമർപിതം യന്മമ വപുസ്തദിദം, ഏതത് കർമ്മ മമ സ്മരണാർഥം കുരുധ്വം| ");
INSERT INTO sanmal_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","അഥ ഭോജനാന്തേ താദൃശം പാത്രം ഗൃഹീത്വാവദത്, യുഷ്മത്കൃതേ പാതിതം യന്മമ രക്തം തേന നിർണീതനവനിയമരൂപം പാനപാത്രമിദം| ");
INSERT INTO sanmal_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","പശ്യത യോ മാം പരകരേഷു സമർപയിഷ്യതി സ മയാ സഹ ഭോജനാസന ഉപവിശതി| ");
INSERT INTO sanmal_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","യഥാ നിരൂപിതമാസ്തേ തദനുസാരേണാ മനുഷ്യപുुത്രസ്യ ഗതി ർഭവിഷ്യതി കിന്തു യസ്തം പരകരേഷു സമർപയിഷ്യതി തസ്യ സന്താപോ ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","തദാ തേഷാം കോ ജന ഏതത് കർമ്മ കരിഷ്യതി തത് തേ പരസ്പരം പ്രഷ്ടുമാരേഭിരേ| ");
INSERT INTO sanmal_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","അപരം തേഷാം കോ ജനഃ ശ്രേഷ്ഠത്വേന ഗണയിഷ്യതേ, അത്രാർഥേ തേഷാം വിവാദോഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","അസ്മാത് കാരണാത് സോവദത്, അന്യദേശീയാനാം രാജാനഃ പ്രജാനാമുപരി പ്രഭുത്വം കുർവ്വന്തി ദാരുണശാസനം കൃത്വാപി തേ ഭൂപതിത്വേന വിഖ്യാതാ ഭവന്തി ച| ");
INSERT INTO sanmal_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","കിന്തു യുഷ്മാകം തഥാ ന ഭവിഷ്യതി, യോ യുഷ്മാകം ശ്രേഷ്ഠോ ഭവിഷ്യതി സ കനിഷ്ഠവദ് ഭവതു, യശ്ച മുഖ്യോ ഭവിഷ്യതി സ സേവകവദ്ഭവതു| ");
INSERT INTO sanmal_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","ഭോജനോപവിഷ്ടപരിചാരകയോഃ കഃ ശ്രേഷ്ഠഃ? യോ ഭോജനായോപവിശതി സ കിം ശ്രേഷ്ഠോ ന ഭവതി? കിന്തു യുഷ്മാകം മധ്യേഽഹം പരിചാരകഇവാസ്മി| ");
INSERT INTO sanmal_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","അപരഞ്ച യുയം മമ പരീക്ഷാകാലേ പ്രഥമമാരഭ്യ മയാ സഹ സ്ഥിതാ ");
INSERT INTO sanmal_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ഏതത്കാരണാത് പിത്രാ യഥാ മദർഥം രാജ്യമേകം നിരൂപിതം തഥാഹമപി യുഷ്മദർഥം രാജ്യം നിരൂപയാമി| ");
INSERT INTO sanmal_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","തസ്മാൻ മമ രാജ്യേ ഭോജനാസനേ ച ഭോജനപാനേ കരിഷ്യധ്വേ സിംഹാസനേഷൂപവിശ്യ ചേസ്രായേലീയാനാം ദ്വാദശവംശാനാം വിചാരം കരിഷ്യധ്വേ| ");
INSERT INTO sanmal_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","അപരം പ്രഭുരുവാച, ഹേ ശിമോൻ പശ്യ തിതഉനാ ധാന്യാനീവ യുഷ്മാൻ ശൈതാൻ ചാലയിതുമ് ഐച്ഛത്, ");
INSERT INTO sanmal_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","കിന്തു തവ വിശ്വാസസ്യ ലോപോ യഥാ ന ഭവതി ഏതത് ത്വദർഥം പ്രാർഥിതം മയാ, ത്വന്മനസി പരിവർത്തിതേ ച ഭ്രാതൃണാം മനാംസി സ്ഥിരീകുരു| ");
INSERT INTO sanmal_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","തദാ സോവദത്, ഹേ പ്രഭോഹം ത്വയാ സാർദ്ധം കാരാം മൃതിഞ്ച യാതും മജ്ജിതോസ്മി| ");
INSERT INTO sanmal_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","തതഃ സ ഉവാച, ഹേ പിതര ത്വാം വദാമി, അദ്യ കുക്കുടരവാത് പൂർവ്വം ത്വം മത്പരിചയം വാരത്രയമ് അപഹ്വോഷ്യസേ| ");
INSERT INTO sanmal_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","അപരം സ പപ്രച്ഛ, യദാ മുദ്രാസമ്പുടം ഖാദ്യപാത്രം പാദുകാഞ്ച വിനാ യുഷ്മാൻ പ്രാഹിണവം തദാ യുഷ്മാകം കസ്യാപി ന്യൂനതാസീത്? തേ പ്രോചുഃ കസ്യാപി ന| ");
INSERT INTO sanmal_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","തദാ സോവദത് കിന്ത്വിദാനീം മുദ്രാസമ്പുടം ഖാദ്യപാത്രം വാ യസ്യാസ്തി തേന തദ്ഗ്രഹീതവ്യം, യസ്യ ച കൃപാണോे നാസ്തി തേന സ്വവസ്ത്രം വിക്രീയ സ ക്രേതവ്യഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","യതോ യുഷ്മാനഹം വദാമി, അപരാധിജനൈഃ സാർദ്ധം ഗണിതഃ സ ഭവിഷ്യതി| ഇദം യച്ഛാസ്ത്രീയം വചനം ലിഖിതമസ്തി തന്മയി ഫലിഷ്യതി യതോ മമ സമ്ബന്ധീയം സർവ്വം സേത്സ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","തദാ തേ പ്രോചുഃ പ്രഭോ പശ്യ ഇമൗ കൃപാണൗ| തതഃ സോവദദ് ഏതൗ യഥേഷ്ടൗ| ");
INSERT INTO sanmal_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","അഥ സ തസ്മാദ്വഹി ർഗത്വാ സ്വാചാരാനുസാരേണ ജൈതുനനാമാദ്രിം ജഗാമ ശിഷ്യാശ്ച തത്പശ്ചാദ് യയുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","തത്രോപസ്ഥായ സ താനുവാച, യഥാ പരീക്ഷായാം ന പതഥ തദർഥം പ്രാർഥയധ്വം| ");
INSERT INTO sanmal_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","പശ്ചാത് സ തസ്മാദ് ഏകശരക്ഷേപാദ് ബഹി ർഗത്വാ ജാനുനീ പാതയിത്വാ ഏതത് പ്രാർഥയാഞ്ചക്രേ, ");
INSERT INTO sanmal_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ഹേ പിത ര്യദി ഭവാൻ സമ്മന്യതേ തർഹി കംസമേനം മമാന്തികാദ് ദൂരയ കിന്തു മദിച്ഛാനുരൂപം ന ത്വദിച്ഛാനുരൂപം ഭവതു| ");
INSERT INTO sanmal_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","തദാ തസ്മൈ ശക്തിം ദാതും സ്വർഗീയദൂതോ ദർശനം ദദൗ| ");
INSERT INTO sanmal_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","പശ്ചാത് സോത്യന്തം യാതനയാ വ്യാകുലോ ഭൂത്വാ പുനർദൃഢം പ്രാർഥയാഞ്ചക്രേ, തസ്മാദ് ബൃഹച്ഛോണിതബിന്ദവ ഇവ തസ്യ സ്വേദബിന്ദവഃ പൃഥിവ്യാം പതിതുമാരേഭിരേ| ");
INSERT INTO sanmal_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","അഥ പ്രാർഥനാത ഉത്ഥായ ശിഷ്യാണാം സമീപമേത്യ താൻ മനോദുഃഖിനോ നിദ്രിതാൻ ദൃഷ്ട്വാവദത് ");
INSERT INTO sanmal_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","കുതോ നിദ്രാഥ? പരീക്ഷായാമ് അപതനാർഥം പ്രർഥയധ്വം| ");
INSERT INTO sanmal_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ഏതത്കഥായാഃ കഥനകാലേ ദ്വാദശശിഷ്യാണാം മധ്യേ ഗണിതോ യിഹൂദാനാമാ ജനതാസഹിതസ്തേഷാമ് അഗ്രേ ചലിത്വാ യീശോശ്ചുമ്ബനാർഥം തദന്തികമ് ആയയൗ| ");
INSERT INTO sanmal_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","തദാ യീശുരുവാച, ഹേ യിഹൂദാ കിം ചുമ്ബനേന മനുഷ്യപുത്രം പരകരേഷു സമർപയസി? ");
INSERT INTO sanmal_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","തദാ യദ്യദ് ഘടിഷ്യതേ തദനുമായ സങ്ഗിഭിരുക്തം, ഹേ പ്രഭോ വയം കി ഖങ്ഗേന ഘാതയിഷ്യാമഃ? ");
INSERT INTO sanmal_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","തത ഏകഃ കരവാലേനാഹത്യ പ്രധാനയാജകസ്യ ദാസസ്യ ദക്ഷിണം കർണം ചിച്ഛേദ| ");
INSERT INTO sanmal_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","അധൂനാ നിവർത്തസ്വ ഇത്യുക്ത്വാ യീശുസ്തസ്യ ശ്രുതിം സ്പൃഷ്ട്വാ സ്വസ്യം ചകാര| ");
INSERT INTO sanmal_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","പശ്ചാദ് യീശുഃ സമീപസ്ഥാൻ പ്രധാനയാജകാൻ മന്ദിരസ്യ സേനാപതീൻ പ്രാചീനാംശ്ച ജഗാദ, യൂയം കൃപാണാൻ യഷ്ടീംശ്ച ഗൃഹീത്വാ മാം കിം ചോരം ധർത്തുമായാതാഃ? ");
INSERT INTO sanmal_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","യദാഹം യുഷ്മാഭിഃ സഹ പ്രതിദിനം മന്ദിരേഽതിഷ്ഠം തദാ മാം ധർത്തം ന പ്രവൃത്താഃ, കിന്ത്വിദാനീം യുഷ്മാകം സമയോന്ധകാരസ്യ ചാധിപത്യമസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","അഥ തേ തം ധൃത്വാ മഹായാജകസ്യ നിവേശനം നിന്യുഃ| തതഃ പിതരോ ദൂരേ ദൂരേ പശ്ചാദിത്വാ ");
INSERT INTO sanmal_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","ബൃഹത്കോഷ്ഠസ്യ മധ്യേ യത്രാഗ്നിം ജ്വാലയിത്വാ ലോകാഃ സമേത്യോപവിഷ്ടാസ്തത്ര തൈഃ സാർദ്ധമ് ഉപവിവേശ| ");
INSERT INTO sanmal_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","അഥ വഹ്നിസന്നിധൗ സമുപവേശകാലേ കാചിദ്ദാസീ മനോ നിവിശ്യ തം നിരീക്ഷ്യാവദത് പുമാനയം തസ്യ സങ്ഗേഽസ്ഥാത്| ");
INSERT INTO sanmal_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","കിന്തു സ തദ് അപഹ്നുത്യാവാദീത് ഹേ നാരി തമഹം ന പരിചിനോമി| ");
INSERT INTO sanmal_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ക്ഷണാന്തരേഽന്യജനസ്തം ദൃഷ്ട്വാബ്രവീത് ത്വമപി തേഷാം നികരസ്യൈകജനോസി| പിതരഃ പ്രത്യുവാച ഹേ നര നാഹമസ്മി| ");
INSERT INTO sanmal_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","തതഃ സാർദ്ധദണ്ഡദ്വയാത് പരം പുനരന്യോ ജനോ നിശ്ചിത്യ ബഭാഷേ, ഏഷ തസ്യ സങ്ഗീതി സത്യം യതോയം ഗാലീലീയോ ലോകഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","തദാ പിതര ഉവാച ഹേ നര ത്വം യദ് വദമി തദഹം ബോദ്ധും ന ശക്നോമി, ഇതി വാക്യേ കഥിതമാത്രേ കുക്കുടോ രുരാവ| ");
INSERT INTO sanmal_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","തദാ പ്രഭുണാ വ്യാധുട്യ പിതരേ നിരീക്ഷിതേ കൃകവാകുരവാത് പൂർവ്വം മാം ത്രിരപഹ്നോഷ്യസേ ഇതി പൂർവ്വോക്തം തസ്യ വാക്യം പിതരഃ സ്മൃത്വാ ");
INSERT INTO sanmal_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ബഹിർഗത്വാ മഹാഖേദേന ചക്രന്ദ| ");
INSERT INTO sanmal_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","തദാ യൈ ര്യീശുർധൃതസ്തേ തമുപഹസ്യ പ്രഹർത്തുമാരേഭിരേ| ");
INSERT INTO sanmal_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","വസ്ത്രേണ തസ്യ ദൃശൗ ബദ്ധ്വാ കപോലേ ചപേടാഘാതം കൃത്വാ പപ്രച്ഛുഃ, കസ്തേ കപോലേ ചപേടാഘാതം കൃതവാന? ഗണയിത്വാ തദ് വദ| ");
INSERT INTO sanmal_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","തദന്യത് തദ്വിരുദ്ധം ബഹുനിന്ദാവാക്യം വക്തുമാരേഭിരേ| ");
INSERT INTO sanmal_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","അഥ പ്രഭാതേ സതി ലോകപ്രാഞ്ചഃ പ്രധാനയാജകാ അധ്യാപകാശ്ച സഭാം കൃത്വാ മധ്യേസഭം യീശുമാനീയ പപ്രച്ഛുഃ, ത്വമ് അഭിഷികതോസി ന വാസ്മാൻ വദ| ");
INSERT INTO sanmal_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","സ പ്രത്യുവാച, മയാ തസ്മിന്നുക്തേഽപി യൂയം ന വിശ്വസിഷ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","കസ്മിംശ്ചിദ്വാക്യേ യുഷ്മാൻ പൃഷ്ടേഽപി മാം ന തദുത്തരം വക്ഷ്യഥ ന മാം ത്യക്ഷ്യഥ ച| ");
INSERT INTO sanmal_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","കിന്ത്വിതഃ പരം മനുജസുതഃ സർവ്വശക്തിമത ഈശ്വരസ്യ ദക്ഷിണേ പാർശ്വേ സമുപവേക്ഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","തതസ്തേ പപ്രച്ഛുഃ, ർതിഹ ത്വമീശ്വരസ്യ പുത്രഃ? സ കഥയാമാസ, യൂയം യഥാർഥം വദഥ സ ഏവാഹം| ");
INSERT INTO sanmal_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","തദാ തേ സർവ്വേ കഥയാമാസുഃ, ർതിഹ സാക്ഷ്യേഽൻസസ്മിൻ അസ്മാകം കിം പ്രയോജനം? അസ്യ സ്വമുഖാദേവ സാക്ഷ്യം പ്രാപ്തമ്| ");
INSERT INTO sanmal_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","തതഃ സഭാസ്ഥാഃ സർവ്വലോകാ ഉത്ഥായ തം പീലാതസമ്മുഖം നീത്വാപ്രോദ്യ വക്തുമാരേഭിരേ, ");
INSERT INTO sanmal_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","സ്വമഭിഷിക്തം രാജാനം വദന്തം കൈമരരാജായ കരദാനം നിഷേധന്തം രാജ്യവിപര്യ്യയം കുർത്തും പ്രവർത്തമാനമ് ഏന പ്രാപ്താ വയം| ");
INSERT INTO sanmal_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","തദാ പീലാതസ്തം പൃഷ്ടവാൻ ത്വം കിം യിഹൂദീയാനാം രാജാ? സ പ്രത്യുവാച ത്വം സത്യമുക്തവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","തദാ പീലാതഃ പ്രധാനയാജകാദിലോകാൻ ജഗാദ്, അഹമേതസ്യ കമപ്യപരാധം നാപ്തവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","തതസ്തേ പുനഃ സാഹമിനോ ഭൂത്വാവദൻ, ഏഷ ഗാലീല ഏതത്സ്ഥാനപര്യ്യന്തേ സർവ്വസ്മിൻ യിഹൂദാദേശേ സർവ്വാല്ലോകാനുപദിശ്യ കുപ്രവൃത്തിം ഗ്രാഹീതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","തദാ പീലാതോ ഗാലീലപ്രദേശസ്യ നാമ ശ്രുത്വാ പപ്രച്ഛ, കിമയം ഗാലീലീയോ ലോകഃ? ");
INSERT INTO sanmal_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","തതഃ സ ഗാലീൽപ്രദേശീയഹേരോദ്രാജസ്യ തദാ സ്ഥിതേസ്തസ്യ സമീപേ യീശും പ്രേഷയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","തദാ ഹേരോദ് യീശും വിലോക്യ സന്തുതോഷ, യതഃ സ തസ്യ ബഹുവൃത്താന്തശ്രവണാത് തസ്യ കിഞി्ചദാശ്ചര്യ്യകർമ്മ പശ്യതി ഇത്യാശാം കൃത്വാ ബഹുകാലമാരഭ്യ തം ദ്രഷ്ടും പ്രയാസം കൃതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","തസ്മാത് തം ബഹുകഥാഃ പപ്രച്ഛ കിന്തു സ തസ്യ കസ്യാപി വാക്യസ്യ പ്രത്യുത്തരം നോവാച| ");
INSERT INTO sanmal_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","അഥ പ്രധാനയാജകാ അധ്യാപകാശ്ച പ്രോത്തിഷ്ഠന്തഃ സാഹസേന തമപവദിതും പ്രാരേഭിരേ| ");
INSERT INTO sanmal_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ഹേരോദ് തസ്യ സേനാഗണശ്ച തമവജ്ഞായ ഉപഹാസത്വേന രാജവസ്ത്രം പരിധാപ്യ പുനഃ പീലാതം പ്രതി തം പ്രാഹിണോത്| ");
INSERT INTO sanmal_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","പൂർവ്വം ഹേരോദ്പീലാതയോഃ പരസ്പരം വൈരഭാവ ആസീത് കിന്തു തദ്ദിനേ ദ്വയോ ർമേലനം ജാതമ്| ");
INSERT INTO sanmal_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","പശ്ചാത് പീലാതഃ പ്രധാനയാജകാൻ ശാസകാൻ ലോകാംശ്ച യുഗപദാഹൂയ ബഭാഷേ, ");
INSERT INTO sanmal_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","രാജ്യവിപര്യ്യയകാരകോയമ് ഇത്യുക്ത്വാ മനുഷ്യമേനം മമ നികടമാനൈഷ്ട കിന്തു പശ്യത യുഷ്മാകം സമക്ഷമ് അസ്യ വിചാരം കൃത്വാപി പ്രോക്താപവാദാനുരൂപേണാസ്യ കോപ്യപരാധഃ സപ്രമാണോ ന ജാതഃ, ");
INSERT INTO sanmal_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","യൂയഞ്ച ഹേരോദഃ സന്നിധൗ പ്രേഷിതാ മയാ തത്രാസ്യ കോപ്യപരാധസ്തേനാപി ന പ്രാപ്തഃ| പശ്യതാനേന വധഹേेതുകം കിമപി നാപരാദ്ധം| ");
INSERT INTO sanmal_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","തസ്മാദേനം താഡയിത്വാ വിഹാസ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","തത്രോത്സവേ തേഷാമേകോ മോചയിതവ്യഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ഇതി ഹേതോസ്തേ പ്രോച്ചൈരേകദാ പ്രോചുഃ, ഏനം ദൂരീകൃത്യ ബരബ്ബാനാമാനം മോചയ| ");
INSERT INTO sanmal_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","സ ബരബ്ബാ നഗര ഉപപ്ലവവധാപരാധാഭ്യാം കാരായാം ബദ്ധ ആസീത്| ");
INSERT INTO sanmal_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","കിന്തു പീലാതോ യീശും മോചയിതും വാഞ്ഛൻ പുനസ്താനുവാച| ");
INSERT INTO sanmal_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","തഥാപ്യേനം ക്രുശേ വ്യധ ക്രുശേ വ്യധേതി വദന്തസ്തേ രുരുവുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","തതഃ സ തൃതീയവാരം ജഗാദ കുതഃ? സ കിം കർമ്മ കൃതവാൻ? നാഹമസ്യ കമപി വധാപരാധം പ്രാപ്തഃ കേവലം താഡയിത്വാമും ത്യജാമി| ");
INSERT INTO sanmal_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","തഥാപി തേ പുനരേനം ക്രുശേ വ്യധ ഇത്യുക്ത്വാ പ്രോച്ചൈർദൃഢം പ്രാർഥയാഞ്ചക്രിരേ; ");
INSERT INTO sanmal_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","തതഃ പ്രധാനയാജകാദീനാം കലരവേ പ്രബലേ സതി തേഷാം പ്രാർഥനാരൂപം കർത്തും പീലാത ആദിദേശ| ");
INSERT INTO sanmal_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","രാജദ്രോഹവധയോരപരാധേന കാരാസ്ഥം യം ജനം തേ യയാചിരേ തം മോചയിത്വാ യീശും തേഷാമിച്ഛായാം സമാർപയത്| ");
INSERT INTO sanmal_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","അഥ തേ യീശും ഗൃഹീത്വാ യാന്തി, ഏതർഹി ഗ്രാമാദാഗതം ശിമോനനാമാനം കുരീണീയം ജനം ധൃത്വാ യീശോഃ പശ്ചാന്നേതും തസ്യ സ്കന്ധേ ക്രുശമർപയാമാസുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","തതോ ലോाകാരണ്യമധ്യേ ബഹുസ്ത്രിയോ രുദത്യോ വിലപന്ത്യശ്ച യീശോഃ പശ്ചാദ് യയുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","കിന്തു സ വ്യാഘുട്യ താ ഉവാച, ഹേ യിരൂശാലമോ നാര്യ്യോ യുയം മദർഥം ന രുദിത്വാ സ്വാർഥം സ്വാപത്യാർഥഞ്ച രുദിതി; ");
INSERT INTO sanmal_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","പശ്യത യഃ കദാപി ഗർഭവത്യോ നാഭവൻ സ്തന്യഞ്ച നാപായയൻ താദൃശീ ർവന്ധ്യാ യദാ ധന്യാ വക്ഷ്യന്തി സ കാല ആയാതി| ");
INSERT INTO sanmal_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","തദാ ഹേ ശൈലാ അസ്മാകമുപരി പതത, ഹേ ഉപശൈലാ അസ്മാനാച്ഛാദയത കഥാമീദൃശീം ലോകാ വക്ഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","യതഃ സതേജസി ശാഖിനി ചേദേതദ് ഘടതേ തർഹി ശുഷ്കശാഖിനി കിം ന ഘടിഷ്യതേ? ");
INSERT INTO sanmal_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","തദാ തേ ഹന്തും ദ്വാവപരാധിനൗ തേന സാർദ്ധം നിന്യുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","അപരം ശിരഃകപാലനാമകസ്ഥാനം പ്രാപ്യ തം ക്രുശേ വിവിധുഃ; തദ്ദ്വയോരപരാധിനോരേകം തസ്യ ദക്ഷിണോ തദന്യം വാമേ ക്രുശേ വിവിധുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","തദാ യീശുരകഥയത്, ഹേ പിതരേതാൻ ക്ഷമസ്വ യത ഏതേ യത് കർമ്മ കുർവ്വന്തി തൻ ന വിദുഃ; പശ്ചാത്തേ ഗുടികാപാതം കൃത്വാ തസ്യ വസ്ത്രാണി വിഭജ്യ ജഗൃഹുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","തത്ര ലോകസംഘസ്തിഷ്ഠൻ ദദർശ; തേ തേഷാം ശാസകാശ്ച തമുപഹസ്യ ജഗദുഃ, ഏഷ ഇതരാൻ രക്ഷിതവാൻ യദീശ്വരേണാഭിരുചിതോ ഽഭിഷിക്തസ്ത്രാതാ ഭവതി തർഹി സ്വമധുനാ രക്ഷതു| ");
INSERT INTO sanmal_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","തദന്യഃ സേനാഗണാ ഏത്യ തസ്മൈ അമ്ലരസം ദത്വാ പരിഹസ്യ പ്രോവാച, ");
INSERT INTO sanmal_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ചേത്ത്വം യിഹൂദീയാനാം രാജാസി തർഹി സ്വം രക്ഷ| ");
INSERT INTO sanmal_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","യിഹൂദീയാനാം രാജേതി വാക്യം യൂനാനീയരോമീയേബ്രീയാക്ഷരൈ ർലിഖിതം തച്ഛിരസ ഊർദ്ധ്വേഽസ്ഥാപ്യത| ");
INSERT INTO sanmal_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","തദോഭയപാർശ്വയോ ർവിദ്ധൗ യാവപരാധിനൗ തയോരേകസ്തം വിനിന്ദ്യ ബഭാഷേ, ചേത്ത്വമ് അഭിഷിക്തോസി തർഹി സ്വമാവാഞ്ച രക്ഷ| ");
INSERT INTO sanmal_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","കിന്ത്വന്യസ്തം തർജയിത്വാവദത്, ഈശ്വരാത്തവ കിഞ്ചിദപി ഭയം നാസ്തി കിം? ത്വമപി സമാനദണ്ഡോസി, ");
INSERT INTO sanmal_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","യോഗ്യപാത്രേ ആവാം സ്വസ്വകർമ്മണാം സമുചിതഫലം പ്രാപ്നുവഃ കിന്ത്വനേന കിമപി നാപരാദ്ധം| ");
INSERT INTO sanmal_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","അഥ സ യീശും ജഗാദ ഹേ പ്രഭേ ഭവാൻ സ്വരാജ്യപ്രവേശകാലേ മാം സ്മരതു| ");
INSERT INTO sanmal_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","തദാ യീശുഃ കഥിതവാൻ ത്വാം യഥാർഥം വദാമി ത്വമദ്യൈവ മയാ സാർദ്ധം പരലോകസ്യ സുഖസ്ഥാനം പ്രാപ്സ്യസി| ");
INSERT INTO sanmal_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","അപരഞ്ച ദ്വിതീയയാമാത് തൃതീയയാമപര്യ്യന്തം രവേസ്തേജസോന്തർഹിതത്വാത് സർവ്വദേശോഽന്ധകാരേണാവൃതോ ");
INSERT INTO sanmal_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","മന്ദിരസ്യ യവനികാ ച ഛിദ്യമാനാ ദ്വിധാ ബഭൂവ| ");
INSERT INTO sanmal_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","തതോ യീശുരുച്ചൈരുവാച, ഹേ പിത ർമമാത്മാനം തവ കരേ സമർപയേ, ഇത്യുക്ത്വാ സ പ്രാണാൻ ജഹൗ| ");
INSERT INTO sanmal_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","തദൈതാ ഘടനാ ദൃഷ്ട്വാ ശതസേനാപതിരീശ്വരം ധന്യമുക്ത്വാ കഥിതവാൻ അയം നിതാന്തം സാധുമനുഷ്യ ആസീത്| ");
INSERT INTO sanmal_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","അഥ യാവന്തോ ലോകാ ദ്രഷ്ടുമ് ആഗതാസ്തേ താ ഘടനാ ദൃഷ്ട്വാ വക്ഷഃസു കരാഘാതം കൃത്വാ വ്യാചുട്യ ഗതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","യീശോ ർജ്ഞാതയോ യാ യാ യോഷിതശ്ച ഗാലീലസ്തേന സാർദ്ധമായാതാസ്താ അപി ദൂരേ സ്ഥിത്വാ തത് സർവ്വം ദദൃശുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","തദാ യിഹൂദീയാനാം മന്ത്രണാം ക്രിയാഞ്ചാസമ്മന്യമാന ഈശ്വരസ്യ രാജത്വമ് അപേക്ഷമാണോ ");
INSERT INTO sanmal_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","യിഹൂദിദേശീയോ ഽരിമഥീയനഗരീയോ യൂഷഫ്നാമാ മന്ത്രീ ഭദ്രോ ധാർമ്മികശ്ച പുമാൻ ");
INSERT INTO sanmal_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","പീലാതാന്തികം ഗത്വാ യീശോ ർദേഹം യയാചേ| ");
INSERT INTO sanmal_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","പശ്ചാദ് വപുരവരോഹ്യ വാസസാ സംവേഷ്ട്യ യത്ര കോപി മാനുഷോ നാസ്ഥാപ്യത തസ്മിൻ ശൈലേ സ്വാതേ ശ്മശാനേ തദസ്ഥാപയത്| ");
INSERT INTO sanmal_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","തദ്ദിനമായോജനീയം ദിനം വിശ്രാമവാരശ്ച സമീപഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","അപരം യീശുനാ സാർദ്ധം ഗാലീല ആഗതാ യോഷിതഃ പശ്ചാദിത്വാ ശ്മശാനേ തത്ര യഥാ വപുഃ സ്ഥാപിതം തച്ച ദൃഷ്ട്വാ ");
INSERT INTO sanmal_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","വ്യാഘുട്യ സുഗന്ധിദ്രവ്യതൈലാനി കൃത്വാ വിധിവദ് വിശ്രാമവാരേ വിശ്രാമം ചക്രുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","അഥ സപ്താഹപ്രഥമദിനേഽതിപ്രത്യൂഷേ താ യോഷിതഃ സമ്പാദിതം സുഗന്ധിദ്രവ്യം ഗൃഹീത്വാ തദന്യാഭിഃ കിയതീഭിഃ സ്ത്രീഭിഃ സഹ ശ്മശാനം യയുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","കിന്തു ശ്മശാനദ്വാരാത് പാഷാണമപസാരിതം ദൃഷ്ട്വാ ");
INSERT INTO sanmal_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","താഃ പ്രവിശ്യ പ്രഭോ ർദേഹമപ്രാപ്യ ");
INSERT INTO sanmal_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","വ്യാകുലാ ഭവന്തി ഏതർഹി തേജോമയവസ്ത്രാന്വിതൗ ദ്വൗ പുരുഷൗ താസാം സമീപേ സമുപസ്ഥിതൗ ");
INSERT INTO sanmal_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","തസ്മാത്താഃ ശങ്കായുക്താ ഭൂമാവധോമുഖ്യസ്യസ്ഥുഃ| തദാ തൗ താ ഊചതു ർമൃതാനാം മധ്യേ ജീവന്തം കുതോ മൃഗയഥ? ");
INSERT INTO sanmal_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","സോത്ര നാസ്തി സ ഉദസ്ഥാത്| ");
INSERT INTO sanmal_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","പാപിനാം കരേഷു സമർപിതേന ക്രുശേ ഹതേന ച മനുഷ്യപുത്രേണ തൃതീയദിവസേ ശ്മശാനാദുത്ഥാതവ്യമ് ഇതി കഥാം സ ഗലീലി തിഷ്ഠൻ യുഷ്മഭ്യം കഥിതവാൻ താം സ്മരത| ");
INSERT INTO sanmal_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","തദാ തസ്യ സാ കഥാ താസാം മനഃസു ജാതാ| ");
INSERT INTO sanmal_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","അനന്തരം ശ്മശാനാദ് ഗത്വാ താ ഏകാദശശിഷ്യാദിഭ്യഃ സർവ്വേഭ്യസ്താം വാർത്താം കഥയാമാസുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","മഗ്ദലീനീമരിയമ്, യോഹനാ, യാകൂബോ മാതാ മരിയമ് തദന്യാഃ സങ്ഗിന്യോ യോഷിതശ്ച പ്രേരിതേഭ്യ ഏതാഃ സർവ്വാ വാർത്താഃ കഥയാമാസുഃ ");
INSERT INTO sanmal_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","കിന്തു താസാം കഥാമ് അനർഥകാഖ്യാനമാത്രം ബുദ്ധ്വാ കോപി ന പ്രത്യൈത്| ");
INSERT INTO sanmal_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","തദാ പിതര ഉത്ഥായ ശ്മശാനാന്തികം ദധാവ, തത്ര ച പ്രഹ്വോ ഭൂത്വാ പാർശ്വൈകസ്ഥാപിതം കേവലം വസ്ത്രം ദദർശ; തസ്മാദാശ്ചര്യ്യം മന്യമാനോ യദഘടത തന്മനസി വിചാരയൻ പ്രതസ്ഥേ| ");
INSERT INTO sanmal_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","തസ്മിന്നേവ ദിനേ ദ്വൗ ശിയ്യൗ യിരൂശാലമശ്ചതുഷ്ക്രോശാന്തരിതമ് ഇമ്മായുഗ്രാമം ഗച്ഛന്തൗ ");
INSERT INTO sanmal_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","താസാം ഘടനാനാം കഥാമകഥയതാം ");
INSERT INTO sanmal_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","തയോരാലാപവിചാരയോഃ കാലേ യീശുരാഗത്യ താഭ്യാം സഹ ജഗാമ ");
INSERT INTO sanmal_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","കിന്തു യഥാ തൗ തം ന പരിചിനുതസ്തദർഥം തയോ ർദൃഷ്ടിഃ സംരുദ്ധാ| ");
INSERT INTO sanmal_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","സ തൗ പൃഷ്ടവാൻ യുവാം വിഷണ്ണൗ കിം വിചാരയന്തൗ ഗച്ഛഥഃ? ");
INSERT INTO sanmal_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","തതസ്തയോഃ ക്ലിയപാനാമാ പ്രത്യുവാച യിരൂശാലമപുരേഽധുനാ യാന്യഘടന്ത ത്വം കേവലവിദേശീ കിം തദ്വൃത്താന്തം ന ജാനാസി? ");
INSERT INTO sanmal_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","സ പപ്രച്ഛ കാ ഘടനാഃ? തദാ തൗ വക്തുമാരേഭാതേ യീശുനാമാ യോ നാസരതീയോ ഭവിഷ്യദ്വാദീ ഈശ്വരസ്യ മാനുഷാണാഞ്ച സാക്ഷാത് വാക്യേ കർമ്മണി ച ശക്തിമാനാസീത് ");
INSERT INTO sanmal_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","തമ് അസ്മാകം പ്രധാനയാജകാ വിചാരകാശ്ച കേനാപി പ്രകാരേണ ക്രുശേ വിദ്ധ്വാ തസ്യ പ്രാണാനനാശയൻ തദീയാ ഘടനാഃ; ");
INSERT INTO sanmal_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","കിന്തു യ ഇസ്രായേലീയലോകാൻ ഉദ്ധാരയിഷ്യതി സ ഏവായമ് ഇത്യാശാസ്മാഭിഃ കൃതാ| തദ്യഥാ തഥാസ്തു തസ്യാ ഘടനായാ അദ്യ ദിനത്രയം ഗതം| ");
INSERT INTO sanmal_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","അധികന്ത്വസ്മാകം സങ്ഗിനീനാം കിയത്സ്ത്രീണാം മുഖേഭ്യോഽസമ്ഭവവാക്യമിദം ശ്രുതം; ");
INSERT INTO sanmal_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","താഃ പ്രത്യൂഷേ ശ്മശാനം ഗത്വാ തത്ര തസ്യ ദേഹമ് അപ്രാപ്യ വ്യാഘുട്യേത്വാ പ്രോക്തവത്യഃ സ്വർഗീസദൂതൗ ദൃഷ്ടാവസ്മാഭിസ്തൗ ചാവാദിഷ്ടാം സ ജീവിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","തതോസ്മാകം കൈശ്ചിത് ശ്മശാനമഗമ്യത തേഽപി സ്ത്രീണാം വാക്യാനുരൂപം ദൃഷ്ടവന്തഃ കിന്തു തം നാപശ്യൻ| ");
INSERT INTO sanmal_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","തദാ സ താവുവാച, ഹേ അബോധൗ ഹേ ഭവിഷ്യദ്വാദിഭിരുക്തവാക്യം പ്രത്യേതും വിലമ്ബമാനൗ; ");
INSERT INTO sanmal_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ഏതത്സർവ്വദുഃഖം ഭുക്ത്വാ സ്വഭൂതിപ്രാപ്തിഃ കിം ഖ്രീഷ്ടസ്യ ന ന്യായ്യാ? ");
INSERT INTO sanmal_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","തതഃ സ മൂസാഗ്രന്ഥമാരഭ്യ സർവ്വഭവിഷ്യദ്വാദിനാം സർവ്വശാസ്ത്രേ സ്വസ്മിൻ ലിഖിതാഖ്യാനാഭിപ്രായം ബോധയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","അഥ ഗമ്യഗ്രാമാഭ്യർണം പ്രാപ്യ തേനാഗ്രേ ഗമനലക്ഷണേ ദർശിതേ ");
INSERT INTO sanmal_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","തൗ സാധയിത്വാവദതാം സഹാവാഭ്യാം തിഷ്ഠ ദിനേ ഗതേ സതി രാത്രിരഭൂത്; തതഃ സ താഭ്യാം സാർദ്ധം സ്ഥാതും ഗൃഹം യയൗ| ");
INSERT INTO sanmal_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","പശ്ചാദ്ഭോജനോപവേശകാലേ സ പൂപം ഗൃഹീത്വാ ഈശ്വരഗുണാൻ ജഗാദ തഞ്ച ഭംക്ത്വാ താഭ്യാം ദദൗ| ");
INSERT INTO sanmal_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","തദാ തയോ ർദൃഷ്ടൗ പ്രസന്നായാം തം പ്രത്യഭിജ്ഞതുഃ കിന്തു സ തയോഃ സാക്ഷാദന്തർദധേ| ");
INSERT INTO sanmal_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","തതസ്തൗ മിഥോഭിധാതുമ് ആരബ്ധവന്തൗ ഗമനകാലേ യദാ കഥാമകഥയത് ശാസ്ത്രാർഥഞ്ചബോധയത് തദാവയോ ർബുദ്ധിഃ കിം ന പ്രാജ്വലത്? ");
INSERT INTO sanmal_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","തൗ തത്ക്ഷണാദുത്ഥായ യിരൂശാലമപുരം പ്രത്യായയതുഃ, തത്സ്ഥാനേ ശിഷ്യാണാമ് ഏകാദശാനാം സങ്ഗിനാഞ്ച ദർശനം ജാതം| ");
INSERT INTO sanmal_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","തേ പ്രോചുഃ പ്രഭുരുദതിഷ്ഠദ് ഇതി സത്യം ശിമോനേ ദർശനമദാച്ച| ");
INSERT INTO sanmal_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","തതഃ പഥഃ സർവ്വഘടനായാഃ പൂപഭഞ്ജനേന തത്പരിചയസ്യ ച സർവ്വവൃത്താന്തം തൗ വക്തുമാരേഭാതേ| ");
INSERT INTO sanmal_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ഇത്ഥം തേ പരസ്പരം വദന്തി തത്കാലേ യീശുഃ സ്വയം തേഷാം മധ്യ പ്രോത്ഥയ യുഷ്മാകം കല്യാണം ഭൂയാദ് ഇത്യുവാച, ");
INSERT INTO sanmal_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","കിന്തു ഭൂതം പശ്യാമ ഇത്യനുമായ തേ സമുദ്വിവിജിരേ ത്രേഷുശ്ച| ");
INSERT INTO sanmal_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","സ ഉവാച, കുതോ ദുഃഖിതാ ഭവഥ? യുഷ്മാകം മനഃസു സന്ദേഹ ഉദേതി ച കുതഃ? ");
INSERT INTO sanmal_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ഏഷോഹം, മമ കരൗ പശ്യത വരം സ്പൃഷ്ട്വാ പശ്യത, മമ യാദൃശാനി പശ്യഥ താദൃശാനി ഭൂതസ്യ മാംസാസ്ഥീനി ന സന്തി| ");
INSERT INTO sanmal_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ഇത്യുക്ത്വാ സ ഹസ്തപാദാൻ ദർശയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","തേഽസമ്ഭവം ജ്ഞാത്വാ സാനന്ദാ ന പ്രത്യയൻ| തതഃ സ താൻ പപ്രച്ഛ, അത്ര യുഷ്മാകം സമീപേ ഖാദ്യം കിഞ്ചിദസ്തി? ");
INSERT INTO sanmal_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","തതസ്തേ കിയദ്ദഗ്ധമത്സ്യം മധു ച ദദുഃ ");
INSERT INTO sanmal_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","സ തദാദായ തേഷാം സാക്ഷാദ് ബുഭുജേ ");
INSERT INTO sanmal_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","കഥയാമാസ ച മൂസാവ്യവസ്ഥായാം ഭവിഷ്യദ്വാദിനാം ഗ്രന്ഥേഷു ഗീതപുസ്തകേ ച മയി യാനി സർവ്വാണി വചനാനി ലിഖിതാനി തദനുരൂപാണി ഘടിഷ്യന്തേ യുഷ്മാഭിഃ സാർദ്ധം സ്ഥിത്വാഹം യദേതദ്വാക്യമ് അവദം തദിദാനീം പ്രത്യക്ഷമഭൂത്| ");
INSERT INTO sanmal_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","അഥ തേഭ്യഃ ശാസ്ത്രബോധാധികാരം ദത്വാവദത്, ");
INSERT INTO sanmal_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ഖ്രീഷ്ടേനേത്ഥം മൃതിയാതനാ ഭോക്തവ്യാ തൃതീയദിനേ ച ശ്മശാനാദുത്ഥാതവ്യഞ്ചേതി ലിപിരസ്തി; ");
INSERT INTO sanmal_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","തന്നാമ്നാ യിരൂശാലമമാരഭ്യ സർവ്വദേശേ മനഃപരാവർത്തനസ്യ പാപമോചനസ്യ ച സുസംവാദഃ പ്രചാരയിതവ്യഃ, ");
INSERT INTO sanmal_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ഏഷു സർവ്വേഷു യൂയം സാക്ഷിണഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","അപരഞ്ച പശ്യത പിത്രാ യത് പ്രതിജ്ഞാതം തത് പ്രേഷയിഷ്യാമി, അതഏവ യാവത്കാലം യൂയം സ്വർഗീയാം ശക്തിം ന പ്രാപ്സ്യഥ താവത്കാലം യിരൂശാലമ്നഗരേ തിഷ്ഠത| ");
INSERT INTO sanmal_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","അഥ സ താൻ ബൈഥനീയാപര്യ്യന്തം നീത്വാ ഹസ്താവുത്തോല്യ ആശിഷ വക്തുമാരേഭേ ");
INSERT INTO sanmal_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ആശിഷം വദന്നേവ ച തേഭ്യഃ പൃഥഗ് ഭൂത്വാ സ്വർഗായ നീതോഽഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","തദാ തേ തം ഭജമാനാ മഹാനന്ദേന യിരൂശാലമം പ്രത്യാജഗ്മുഃ| ");
INSERT INTO sanmal_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","തതോ നിരന്തരം മന്ദിരേ തിഷ്ഠന്ത ഈശ്വരസ്യ പ്രശംസാം ധന്യവാദഞ്ച കർത്തമ് ആരേഭിരേ| ഇതി||");
INSERT INTO sanmal_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ആദൗ വാദ ആസീത് സ ച വാദ ഈശ്വരേണ സാർധമാസീത് സ വാദഃ സ്വയമീശ്വര ഏവ| ");
INSERT INTO sanmal_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","സ ആദാവീശ്വരേണ സഹാസീത്| ");
INSERT INTO sanmal_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","തേന സർവ്വം വസ്തു സസൃജേ സർവ്വേഷു സൃഷ്ടവസ്തുഷു കിമപി വസ്തു തേനാസൃഷ്ടം നാസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","സ ജീവനസ്യാകാരഃ, തച്ച ജീവനം മനുഷ്യാണാം ജ്യോതിഃ ");
INSERT INTO sanmal_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","തജ്ജ്യോതിരന്ധകാരേ പ്രചകാശേ കിന്ത്വന്ധകാരസ്തന്ന ജഗ്രാഹ| ");
INSERT INTO sanmal_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","യോഹൻ നാമക ഏകോ മനുജ ഈശ്വരേണ പ്രേഷയാഞ്ചക്രേ| ");
INSERT INTO sanmal_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","തദ്വാരാ യഥാ സർവ്വേ വിശ്വസന്തി തദർഥം സ തജ്ജ്യോതിഷി പ്രമാണം ദാതും സാക്ഷിസ്വരൂപോ ഭൂത്വാഗമത്, ");
INSERT INTO sanmal_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","സ സ്വയം തജ്ജ്യോതി ർന കിന്തു തജ്ജ്യോതിഷി പ്രമാണം ദാതുമാഗമത്| ");
INSERT INTO sanmal_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ജഗത്യാഗത്യ യഃ സർവ്വമനുജേഭ്യോ ദീപ്തിം ദദാതി തദേവ സത്യജ്യോതിഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","സ യജ്ജഗദസൃജത് തന്മദ്യ ഏവ സ ആസീത് കിന്തു ജഗതോ ലോകാസ്തം നാജാനൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","നിജാധികാരം സ ആഗച്ഛത് കിന്തു പ്രജാസ്തം നാഗൃഹ്ലൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","തഥാപി യേ യേ തമഗൃഹ്ലൻ അർഥാത് തസ്യ നാമ്നി വ്യശ്വസൻ തേഭ്യ ഈശ്വരസ്യ പുത്രാ ഭവിതുമ് അധികാരമ് അദദാത്| ");
INSERT INTO sanmal_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","തേഷാം ജനിഃ ശോണിതാന്ന ശാരീരികാഭിലാഷാന്ന മാനവാനാമിച്ഛാതോ ന കിന്ത്വീശ്വരാദഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","സ വാദോ മനുഷ്യരൂപേണാവതീര്യ്യ സത്യതാനുഗ്രഹാഭ്യാം പരിപൂർണഃ സൻ സാർധമ് അസ്മാഭി ർന്യവസത് തതഃ പിതുരദ്വിതീയപുത്രസ്യ യോഗ്യോ യോ മഹിമാ തം മഹിമാനം തസ്യാപശ്യാമ| ");
INSERT INTO sanmal_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","തതോ യോഹനപി പ്രചാര്യ്യ സാക്ഷ്യമിദം ദത്തവാൻ യോ മമ പശ്ചാദ് ആഗമിഷ്യതി സ മത്തോ ഗുരുതരഃ; യതോ മത്പൂർവ്വം സ വിദ്യമാന ആസീത്; യദർഥമ് അഹം സാക്ഷ്യമിദമ് അദാം സ ഏഷഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","അപരഞ്ച തസ്യ പൂർണതായാ വയം സർവ്വേ ക്രമശഃ ക്രമശോനുഗ്രഹം പ്രാപ്താഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","മൂസാദ്വാരാ വ്യവസ്ഥാ ദത്താ കിന്ത്വനുഗ്രഹഃ സത്യത്വഞ്ച യീശുഖ്രീഷ്ടദ്വാരാ സമുപാതിഷ്ഠതാം| ");
INSERT INTO sanmal_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","കോപി മനുജ ഈശ്വരം കദാപി നാപശ്യത് കിന്തു പിതുഃ ക്രോഡസ്ഥോഽദ്വിതീയഃ പുത്രസ്തം പ്രകാശയത്| ");
INSERT INTO sanmal_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","ത്വം കഃ? ഇതി വാക്യം പ്രേഷ്ടും യദാ യിഹൂദീയലോകാ യാജകാൻ ലേവിലോകാംശ്ച യിരൂശാലമോ യോഹനഃ സമീപേ പ്രേഷയാമാസുഃ, ");
INSERT INTO sanmal_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","തദാ സ സ്വീകൃതവാൻ നാപഹ്നൂതവാൻ നാഹമ് അഭിഷിക്ത ഇത്യങ്ഗീകൃതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","തദാ തേഽപൃച്ഛൻ തർഹി കോ ഭവാൻ? കിം ഏലിയഃ? സോവദത് ന; തതസ്തേഽപൃച്ഛൻ തർഹി ഭവാൻ സ ഭവിഷ്യദ്വാദീ? സോവദത് നാഹം സഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","തദാ തേഽപൃച്ഛൻ തർഹി ഭവാൻ കഃ? വയം ഗത്വാ പ്രേരകാൻ ത്വയി കിം വക്ഷ്യാമഃ? സ്വസ്മിൻ കിം വദസി? ");
INSERT INTO sanmal_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","തദാ സോവദത്| പരമേശസ്യ പന്ഥാനം പരിഷ്കുരുത സർവ്വതഃ| ഇതീദം പ്രാന്തരേ വാക്യം വദതഃ കസ്യചിദ്രവഃ| കഥാമിമാം യസ്മിൻ യിശയിയോ ഭവിഷ്യദ്വാദീ ലിഖിതവാൻ സോഹമ്| ");
INSERT INTO sanmal_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","യേ പ്രേഷിതാസ്തേ ഫിരൂശിലോകാഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","തദാ തേഽപൃച്ഛൻ യദി നാഭിഷിക്തോസി ഏലിയോസി ന സ ഭവിഷ്യദ്വാദ്യപി നാസി ച, തർഹി ലോകാൻ മജ്ജയസി കുതഃ? ");
INSERT INTO sanmal_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","തതോ യോഹൻ പ്രത്യവോചത്, തോയേഽഹം മജ്ജയാമീതി സത്യം കിന്തു യം യൂയം ന ജാനീഥ താദൃശ ഏകോ ജനോ യുഷ്മാകം മധ്യ ഉപതിഷ്ഠതി| ");
INSERT INTO sanmal_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","സ മത്പശ്ചാദ് ആഗതോപി മത്പൂർവ്വം വർത്തമാന ആസീത് തസ്യ പാദുകാബന്ധനം മോചയിതുമപി നാഹം യോഗ്യോസ്മി| ");
INSERT INTO sanmal_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","യർദ്ദനനദ്യാഃ പാരസ്ഥബൈഥബാരായാം യസ്മിൻസ്ഥാനേ യോഹനമജ്ജയത് തസ്മിന സ്ഥാനേ സർവ്വമേതദ് അഘടത| ");
INSERT INTO sanmal_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","പരേഽഹനി യോഹൻ സ്വനികടമാഗച്ഛന്തം യിശും വിലോക്യ പ്രാവോചത് ജഗതഃ പാപമോചകമ് ഈശ്വരസ്യ മേഷശാവകം പശ്യത| ");
INSERT INTO sanmal_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","യോ മമ പശ്ചാദാഗമിഷ്യതി സ മത്തോ ഗുരുതരഃ, യതോ ഹേതോർമത്പൂർവ്വം സോഽവർത്തത യസ്മിന്നഹം കഥാമിമാം കഥിതവാൻ സ ഏവായം| ");
INSERT INTO sanmal_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","അപരം നാഹമേനം പ്രത്യഭിജ്ഞാതവാൻ കിന്തു ഇസ്രായേല്ലോകാ ഏനം യഥാ പരിചിന്വന്തി തദഭിപ്രായേണാഹം ജലേ മജ്ജയിതുമാഗച്ഛമ്| ");
INSERT INTO sanmal_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","പുനശ്ച യോഹനപരമേകം പ്രമാണം ദത്വാ കഥിതവാൻ വിഹായസഃ കപോതവദ് അവതരന്തമാത്മാനമ് അസ്യോപര്യ്യവതിഷ്ഠന്തം ച ദൃഷ്ടവാനഹമ്| ");
INSERT INTO sanmal_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","നാഹമേനം പ്രത്യഭിജ്ഞാതവാൻ ഇതി സത്യം കിന്തു യോ ജലേ മജ്ജയിതും മാം പ്രൈരയത് സ ഏവേമാം കഥാമകഥയത് യസ്യോപര്യ്യാത്മാനമ് അവതരന്തമ് അവതിഷ്ഠന്തഞ്ച ദ്രക്ഷയസി സഏവ പവിത്രേ ആത്മനി മജ്ജയിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","അവസ്തന്നിരീക്ഷ്യായമ് ഈശ്വരസ്യ തനയ ഇതി പ്രമാണം ദദാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","പരേഽഹനി യോഹൻ ദ്വാഭ്യാം ശിഷ്യാഭ്യാം സാർദ്ധേം തിഷ്ഠൻ ");
INSERT INTO sanmal_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","യിശും ഗച്ഛന്തം വിലോക്യ ഗദിതവാൻ, ഈശ്വരസ്യ മേഷശാവകം പശ്യതം| ");
INSERT INTO sanmal_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ഇമാം കഥാം ശ്രുത്വാ ദ്വൗ ശിഷ്യൗ യീശോഃ പശ്ചാദ് ഈയതുഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","തതോ യീശുഃ പരാവൃത്യ തൗ പശ്ചാദ് ആഗച്ഛന്തൗ ദൃഷ്ട്വാ പൃഷ്ടവാൻ യുവാം കിം ഗവേശയഥഃ? താവപൃച്ഛതാം ഹേ രബ്ബി അർഥാത് ഹേ ഗുരോ ഭവാൻ കുത്ര തിഷ്ഠതി? ");
INSERT INTO sanmal_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","തതഃ സോവാദിത് ഏത്യ പശ്യതം| തതോ ദിവസസ്യ തൃതീയപ്രഹരസ്യ ഗതത്വാത് തൗ തദ്ദിനം തസ്യ സങ്ഗേഽസ്ഥാതാം| ");
INSERT INTO sanmal_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","യൗ ദ്വൗ യോഹനോ വാക്യം ശ്രുത്വാ യിശോഃ പശ്ചാദ് ആഗമതാം തയോഃ ശിമോൻപിതരസ്യ ഭ്രാതാ ആന്ദ്രിയഃ ");
INSERT INTO sanmal_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","സ ഇത്വാ പ്രഥമം നിജസോദരം ശിമോനം സാക്ഷാത്പ്രാപ്യ കഥിതവാൻ വയം ഖ്രീഷ്ടമ് അർഥാത് അഭിഷിക്തപുരുഷം സാക്ഷാത്കൃതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","പശ്ചാത് സ തം യിശോഃ സമീപമ് ആനയത്| തദാ യീശുസ്തം ദൃഷ്ട്വാവദത് ത്വം യൂനസഃ പുത്രഃ ശിമോൻ കിന്തു ത്വന്നാമധേയം കൈഫാഃ വാ പിതരഃ അർഥാത് പ്രസ്തരോ ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","പരേഽഹനി യീശൗ ഗാലീലം ഗന്തും നിശ്ചിതചേതസി സതി ഫിലിപനാമാനം ജനം സാക്ഷാത്പ്രാപ്യാവോചത് മമ പശ്ചാദ് ആഗച്ഛ| ");
INSERT INTO sanmal_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ബൈത്സൈദാനാമ്നി യസ്മിൻ ഗ്രാമേ പിതരാന്ദ്രിയയോർവാസ ആസീത് തസ്മിൻ ഗ്രാമേ തസ്യ ഫിലിപസ്യ വസതിരാസീത്| ");
INSERT INTO sanmal_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","പശ്ചാത് ഫിലിപോ നിഥനേലം സാക്ഷാത്പ്രാപ്യാവദത് മൂസാ വ്യവസ്ഥാ ഗ്രന്ഥേ ഭവിഷ്യദ്വാദിനാം ഗ്രന്ഥേഷു ച യസ്യാഖ്യാനം ലിഖിതമാസ്തേ തം യൂഷഫഃ പുത്രം നാസരതീയം യീശും സാക്ഷാദ് അകാർഷ്മ വയം| ");
INSERT INTO sanmal_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","തദാ നിഥനേൽ കഥിതവാൻ നാസരന്നഗരാത കിം കശ്ചിദുത്തമ ഉത്പന്തും ശക്നോതി? തതഃ ഫിലിപോ ഽവോചത് ഏത്യ പശ്യ| ");
INSERT INTO sanmal_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","അപരഞ്ച യീശുഃ സ്വസ്യ സമീപം തമ് ആഗച്ഛന്തം ദൃഷ്ട്വാ വ്യാഹൃതവാൻ, പശ്യായം നിഷ്കപടഃ സത്യ ഇസ്രായേല്ലോകഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","തതഃ സോവദദ്, ഭവാൻ മാം കഥം പ്രത്യഭിജാനാതി? യീശുരവാദീത് ഫിലിപസ്യ ആഹ്വാനാത് പൂർവ്വം യദാ ത്വമുഡുമ്ബരസ്യ തരോർമൂലേഽസ്ഥാസ്തദാ ത്വാമദർശമ്| ");
INSERT INTO sanmal_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","നിഥനേൽ അചകഥത്, ഹേ ഗുരോ ഭവാൻ നിതാന്തമ് ഈശ്വരസ്യ പുത്രോസി, ഭവാൻ ഇസ്രായേല്വംശസ്യ രാജാ| ");
INSERT INTO sanmal_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","തതോ യീശു ർവ്യാഹരത്, ത്വാമുഡുമ്ബരസ്യ പാദപസ്യ മൂലേ ദൃഷ്ടവാനാഹം മമൈതസ്മാദ്വാക്യാത് കിം ത്വം വ്യശ്വസീഃ? ഏതസ്മാദപ്യാശ്ചര്യ്യാണി കാര്യ്യാണി ദ്രക്ഷ്യസി| ");
INSERT INTO sanmal_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","അന്യച്ചാവാദീദ് യുഷ്മാനഹം യഥാർഥം വദാമി, ഇതഃ പരം മോചിതേ മേഘദ്വാരേ തസ്മാന്മനുജസൂനുനാ ഈശ്വരസ്യ ദൂതഗണമ് അവരോഹന്തമാരോഹന്തഞ്ച ദ്രക്ഷ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","അനന്തരം ത്രുതീയദിവസേ ഗാലീൽ പ്രദേശിയേ കാന്നാനാമ്നി നഗരേ വിവാഹ ആസീത് തത്ര ച യീശോർമാതാ തിഷ്ഠത്| ");
INSERT INTO sanmal_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","തസ്മൈ വിവാഹായ യീശുസ്തസ്യ ശിഷ്യാശ്ച നിമന്ത്രിതാ ആസൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","തദനന്തരം ദ്രാക്ഷാരസസ്യ ന്യൂനത്വാദ് യീശോർമാതാ തമവദത് ഏതേഷാം ദ്രാക്ഷാരസോ നാസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","തദാ സ താമവോചത് ഹേ നാരി മയാ സഹ തവ കിം കാര്യ്യം? മമ സമയ ഇദാനീം നോപതിഷ്ഠതി| ");
INSERT INTO sanmal_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","തതസ്തസ്യ മാതാ ദാസാനവോചദ് അയം യദ് വദതി തദേവ കുരുത| ");
INSERT INTO sanmal_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","തസ്മിൻ സ്ഥാനേ യിഹൂദീയാനാം ശുചിത്വകരണവ്യവഹാരാനുസാരേണാഢകൈകജലധരാണി പാഷാണമയാനി ഷഡ്വൃഹത്പാത്രാണിആസൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","തദാ യീശുസ്താൻ സർവ്വകലശാൻ ജലൈഃ പൂരയിതും താനാജ്ഞാപയത്, തതസ്തേ സർവ്വാൻ കുമ്ഭാനാകർണം ജലൈഃ പര്യ്യപൂരയൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","അഥ തേഭ്യഃ കിഞ്ചിദുത്താര്യ്യ ഭോജ്യാധിപാതേഃസമീപം നേതും സ താനാദിശത്, തേ തദനയൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","അപരഞ്ച തജ്ജലം കഥം ദ്രാക്ഷാരസോഽഭവത് തജ്ജലവാഹകാദാസാ ജ്ഞാതും ശക്താഃ കിന്തു തദ്ഭോജ്യാധിപോ ജ്ഞാതും നാശക്നോത് തദവലിഹ്യ വരം സംമ്ബോദ്യാവദത, ");
INSERT INTO sanmal_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ലോകാഃ പ്രഥമം ഉത്തമദ്രാക്ഷാരസം ദദതി തഷു യഥേഷ്ടം പിതവത്സു തസ്മാ കിഞ്ചിദനുത്തമഞ്ച ദദതി കിന്തു ത്വമിദാനീം യാവത് ഉത്തമദ്രാക്ഷാരസം സ്ഥാപയസി| ");
INSERT INTO sanmal_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ഇത്ഥം യീശുർഗാലീലപ്രദേശേ ആശ്ചര്യ്യകാർമ്മ പ്രാരമ്ഭ നിജമഹിമാനം പ്രാകാശയത് തതഃ ശിഷ്യാസ്തസ്മിൻ വ്യശ്വസൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","തതഃ പരമ് സ നിജമാത്രുഭ്രാത്രുസ്ശിഷ്യൈഃ സാർദ്ധ്ം കഫർനാഹൂമമ് ആഗമത് കിന്തു തത്ര ബഹൂദിനാനി ആതിഷ്ഠത്| ");
INSERT INTO sanmal_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","തദനന്തരം യിഹൂദിയാനാം നിസ്താരോത്സവേ നികടമാഗതേ യീശു ര്യിരൂശാലമ് നഗരമ് ആഗച്ഛത്| ");
INSERT INTO sanmal_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","തതോ മന്ദിരസ്യ മധ്യേ ഗോമേഷപാരാവതവിക്രയിണോ വാണിജക്ഷ്ചോപവിഷ്ടാൻ വിലോക്യ ");
INSERT INTO sanmal_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","രജ്ജുഭിഃ കശാം നിർമ്മായ സർവ്വഗോമേഷാദിഭിഃ സാർദ്ധം താൻ മന്ദിരാദ് ദൂരീകൃതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","വണിജാം മുദ്രാദി വികീര്യ്യ ആസനാനി ന്യൂബ്ജീകൃത്യ പാരാവതവിക്രയിഭ്യോഽകഥയദ് അസ്മാത് സ്ഥാനാത് സർവാണ്യേതാനി നയത, മമ പിതുഗൃഹം വാണിജ്യഗൃഹം മാ കാർഷ്ട| ");
INSERT INTO sanmal_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","തസ്മാത് തന്മന്ദിരാർഥ ഉദ്യോഗോ യസ്തു സ ഗ്രസതീവ മാമ്| ഇമാം ശാസ്ത്രീയലിപിം ശിഷ്യാഃസമസ്മരൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","തതഃ പരമ് യിഹൂദീയലോകാ യീഷിമവദൻ തവമിദൃശകർമ്മകരണാത് കിം ചിഹ്നമസ്മാൻ ദർശയസി? ");
INSERT INTO sanmal_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","തതോ യീശുസ്താനവോചദ് യുഷ്മാഭിരേ തസ്മിൻ മന്ദിരേ നാശിതേ ദിനത്രയമധ്യേഽഹം തദ് ഉത്ഥാപയിഷ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","തദാ യിഹൂദിയാ വ്യാഹാർഷുഃ, ഏതസ്യ മന്ദിരസ നിർമ്മാണേന ഷട്ചത്വാരിംശദ് വത്സരാ ഗതാഃ, ത്വം കിം ദിനത്രയമധ്യേ തദ് ഉത്ഥാപയിഷ്യസി? ");
INSERT INTO sanmal_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","കിന്തു സ നിജദേഹരൂപമന്ദിരേ കഥാമിമാം കഥിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","സ യദേതാദൃശം ഗദിതവാൻ തച്ഛിഷ്യാഃ ശ്മശാനാത് തദീയോത്ഥാനേ സതി സ്മൃത്വാ ധർമ്മഗ്രന്ഥേ യീശുനോക്തകഥായാം ച വ്യശ്വസിഷുഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","അനന്തരം നിസ്താരോത്സവസ്യ ഭോജ്യസമയേ യിരൂശാലമ് നഗരേ തത്ക്രുതാശ്ചര്യ്യകർമ്മാണി വിലോക്യ ബഹുഭിസ്തസ്യ നാമനി വിശ്വസിതം| ");
INSERT INTO sanmal_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","കിന്തു സ തേഷാം കരേഷു സ്വം ന സമർപയത്, യതഃ സ സർവ്വാനവൈത്| ");
INSERT INTO sanmal_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","സ മാനവേഷു കസ്യചിത് പ്രമാണം നാപേക്ഷത യതോ മനുജാനാം മധ്യേ യദ്യദസ്തി തത്തത് സോജാനാത്| ");
INSERT INTO sanmal_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","നികദിമനാമാ യിഹൂദീയാനാമ് അധിപതിഃ ഫിരൂശീ ക്ഷണദായാം ");
INSERT INTO sanmal_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","യീശൗരഭ്യർണമ് ആവ്രജ്യ വ്യാഹാർഷീത്, ഹേ ഗുരോ ഭവാൻ ഈശ്വരാദ് ആഗത് ഏക ഉപദേഷ്ടാ, ഏതദ് അസ്മാഭിർജ്ഞായതേ; യതോ ഭവതാ യാന്യാശ്ചര്യ്യകർമ്മാണി ക്രിയന്തേ പരമേശ്വരസ്യ സാഹായ്യം വിനാ കേനാപി തത്തത്കർമ്മാണി കർത്തും ന ശക്യന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","തദാ യീശുരുത്തരം ദത്തവാൻ തവാഹം യഥാർഥതരം വ്യാഹരാമി പുനർജന്മനി ന സതി കോപി മാനവ ഈശ്വരസ്യ രാജ്യം ദ്രഷ്ടും ന ശക്നോതി| ");
INSERT INTO sanmal_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","തതോ നികദീമഃ പ്രത്യവോചത് മനുജോ വൃദ്ധോ ഭൂത്വാ കഥം ജനിഷ്യതേ? സ കിം പുന ർമാതൃർജഠരം പ്രവിശ്യ ജനിതും ശക്നോതി? ");
INSERT INTO sanmal_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","യീശുരവാദീദ് യഥാർഥതരമ് അഹം കഥയാമി മനുജേ തോയാത്മഭ്യാം പുന ർന ജാതേ സ ഈശ്വരസ്യ രാജ്യം പ്രവേഷ്ടും ന ശക്നോതി| ");
INSERT INTO sanmal_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","മാംസാദ് യത് ജായതേ തൻ മാംസമേവ തഥാത്മനോ യോ ജായതേ സ ആത്മൈവ| ");
INSERT INTO sanmal_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","യുഷ്മാഭിഃ പുന ർജനിതവ്യം മമൈതസ്യാം കഥായാമ് ആശ്ചര്യം മാ മംസ്ഥാഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","സദാഗതിര്യാം ദിശമിച്ഛതി തസ്യാമേവ ദിശി വാതി, ത്വം തസ്യ സ്വനം ശുണോഷി കിന്തു സ കുത ആയാതി കുത്ര യാതി വാ കിമപി ന ജാനാസി തദ്വാദ് ആത്മനഃ സകാശാത് സർവ്വേഷാം മനുജാനാം ജന്മ ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","തദാ നികദീമഃ പൃഷ്ടവാൻ ഏതത് കഥം ഭവിതും ശക്നോതി? ");
INSERT INTO sanmal_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","യീശുഃ പ്രത്യക്തവാൻ ത്വമിസ്രായേലോ ഗുരുർഭൂത്വാപി കിമേതാം കഥാം ന വേത്സി? ");
INSERT INTO sanmal_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","തുഭ്യം യഥാർഥം കഥയാമി, വയം യദ് വിദ്മസ്തദ് വച്മഃ യംച്ച പശ്യാമസ്തസ്യൈവ സാക്ഷ്യം ദദ്മഃ കിന്തു യുഷ്മാഭിരസ്മാകം സാക്ഷിത്വം ന ഗൃഹ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ഏതസ്യ സംസാരസ്യ കഥായാം കഥിതായാം യദി യൂയം ന വിശ്വസിഥ തർഹി സ്വർഗീയായാം കഥായാം കഥം വിശ്വസിഷ്യഥ? ");
INSERT INTO sanmal_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","യഃ സ്വർഗേഽസ്തി യം ച സ്വർഗാദ് അവാരോഹത് തം മാനവതനയം വിനാ കോപി സ്വർഗം നാരോഹത്| ");
INSERT INTO sanmal_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","അപരഞ്ച മൂസാ യഥാ പ്രാന്തരേ സർപം പ്രോത്ഥാപിതവാൻ മനുഷ്യപുത്രോഽപി തഥൈവോത്ഥാപിതവ്യഃ; ");
INSERT INTO sanmal_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","തസ്മാദ് യഃ കശ്ചിത് തസ്മിൻ വിശ്വസിഷ്യതി സോഽവിനാശ്യഃ സൻ അനന്തായുഃ പ്രാപ്സ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ഈശ്വര ഇത്ഥം ജഗദദയത യത് സ്വമദ്വിതീയം തനയം പ്രാദദാത് തതോ യഃ കശ്ചിത് തസ്മിൻ വിശ്വസിഷ്യതി സോഽവിനാശ്യഃ സൻ അനന്തായുഃ പ്രാപ്സ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ഈശ്വരോ ജഗതോ ലോകാൻ ദണ്ഡയിതും സ്വപുത്രം ന പ്രേഷ്യ താൻ പരിത്രാതും പ്രേഷിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","അതഏവ യഃ കശ്ചിത് തസ്മിൻ വിശ്വസിതി സ ദണ്ഡാർഹോ ന ഭവതി കിന്തു യഃ കശ്ചിത് തസ്മിൻ ന വിശ്വസിതി സ ഇദാനീമേവ ദണ്ഡാർഹോ ഭവതി,യതഃ സ ഈശ്വരസ്യാദ്വിതീയപുത്രസ്യ നാമനി പ്രത്യയം ന കരോതി| ");
INSERT INTO sanmal_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","ജഗതോ മധ്യേ ജ്യോതിഃ പ്രാകാശത കിന്തു മനുഷ്യാണാം കർമ്മണാം ദൃഷ്ടത്വാത് തേ ജ്യോതിഷോപി തിമിരേ പ്രീയന്തേ ഏതദേവ ദണ്ഡസ്യ കാരണാം ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","യഃ കുകർമ്മ കരോതി തസ്യാചാരസ്യ ദൃഷ്ടത്വാത് സ ജ്യോതിരൄതീയിത്വാ തന്നികടം നായാതി; ");
INSERT INTO sanmal_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","കിന്തു യഃ സത്കർമ്മ കരോതി തസ്യ സർവ്വാണി കർമ്മാണീശ്വരേണ കൃതാനീതി സഥാ പ്രകാശതേ തദഭിപ്രായേണ സ ജ്യോതിഷഃ സന്നിധിമ് ആയാതി| ");
INSERT INTO sanmal_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","തതഃ പരമ് യീശുഃ ശിഷ്യൈഃ സാർദ്ധം യിഹൂദീയദേശം ഗത്വാ തത്ര സ്ഥിത്വാ മജ്ജയിതുമ് ആരഭത| ");
INSERT INTO sanmal_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","തദാ ശാലമ് നഗരസ്യ സമീപസ്ഥായിനി ഐനൻ ഗ്രാമേ ബഹുതരതോയസ്ഥിതേസ്തത്ര യോഹൻ അമജ്ജയത് തഥാ ച ലോകാ ആഗത്യ തേന മജ്ജിതാ അഭവൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","തദാ യോഹൻ കാരായാം ന ബദ്ധഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","അപരഞ്ച ശാചകർമ്മണി യോഹാനഃ ശിഷ്യൈഃ സഹ യിഹൂദീയലോകാനാം വിവാദേ ജാതേ, തേ യോഹനഃ സംന്നിധിം ഗത്വാകഥയൻ, ");
INSERT INTO sanmal_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ഹേ ഗുരോ യർദ്ദനനദ്യാഃ പാരേ ഭവതാ സാർദ്ധം യ ആസീത് യസ്മിംശ്ച ഭവാൻ സാക്ഷ്യം പ്രദദാത് പശ്യതു സോപി മജ്ജയതി സർവ്വേ തസ്യ സമീപം യാന്തി ച| ");
INSERT INTO sanmal_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","തദാ യോഹൻ പ്രത്യവോചദ് ഈശ്വരേണ ന ദത്തേ കോപി മനുജഃ കിമപി പ്രാപ്തും ന ശക്നോതി| ");
INSERT INTO sanmal_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","അഹം അഭിഷിക്തോ ന ഭവാമി കിന്തു തദഗ്രേ പ്രേഷിതോസ്മി യാമിമാം കഥാം കഥിതവാനാഹം തത്ര യൂയം സർവ്വേ സാക്ഷിണഃ സ്ഥ| ");
INSERT INTO sanmal_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","യോ ജനഃ കന്യാം ലഭതേ സ ഏവ വരഃ കിന്തു വരസ്യ സന്നിധൗ ദണ്ഡായമാനം തസ്യ യന്മിത്രം തേന വരസ്യ ശബ്ദേ ശ്രുതേഽതീവാഹ്ലാദ്യതേ മമാപി തദ്വദ് ആനന്ദസിദ്ധിർജാതാ| ");
INSERT INTO sanmal_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","തേന ക്രമശോ വർദ്ധിതവ്യം കിന്തു മയാ ഹ്സിതവ്യം| ");
INSERT INTO sanmal_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","യ ഊർധ്വാദാഗച്ഛത് സ സർവ്വേഷാം മുഖ്യോ യശ്ച സംസാരാദ് ഉദപദ്യത സ സാംസാരികഃ സംസാരീയാം കഥാഞ്ച കഥയതി യസ്തു സ്വർഗാദാഗച്ഛത് സ സർവ്വേഷാം മുഖ്യഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","സ യദപശ്യദശൃണോച്ച തസ്മിന്നേവ സാക്ഷ്യം ദദാതി തഥാപി പ്രായശഃ കശ്ചിത് തസ്യ സാക്ഷ്യം ന ഗൃഹ്ലാതി; ");
INSERT INTO sanmal_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","കിന്തു യോ ഗൃഹ്ലാതി സ ഈശ്വരസ്യ സത്യവാദിത്വം മുദ്രാങ്ഗിതം കരോതി| ");
INSERT INTO sanmal_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ഈശ്വരേണ യഃ പ്രേരിതഃ സഏവ ഈശ്വരീയകഥാം കഥയതി യത ഈശ്വര ആത്മാനം തസ്മൈ അപരിമിതമ് അദദാത്| ");
INSERT INTO sanmal_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","പിതാ പുത്രേ സ്നേഹം കൃത്വാ തസ്യ ഹസ്തേ സർവ്വാണി സമർപിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","യഃ കശ്ചിത് പുത്രേ വിശ്വസിതി സ ഏവാനന്തമ് പരമായുഃ പ്രാപ്നോതി കിന്തു യഃ കശ്ചിത് പുത്രേ ന വിശ്വസിതി സ പരമായുഷോ ദർശനം ന പ്രാപ്നോതി കിന്ത്വീശ്വരസ്യ കോപഭാജനം ഭൂത്വാ തിഷ്ഠതി| ");
INSERT INTO sanmal_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","യീശുഃ സ്വയം നാമജ്ജയത് കേവലം തസ്യ ശിഷ്യാ അമജ്ജയത് കിന്തു യോഹനോഽധികശിഷ്യാൻ സ കരോതി മജ്ജയതി ച, ");
INSERT INTO sanmal_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ഫിരൂശിന ഇമാം വാർത്താമശൃണ്വൻ ഇതി പ്രഭുരവഗത്യ ");
INSERT INTO sanmal_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","യിഹൂദീയദേശം വിഹായ പുന ർഗാലീലമ് ആഗത്| ");
INSERT INTO sanmal_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","തതഃ ശോമിരോണപ്രദേശസ്യ മദ്യേന തേന ഗന്തവ്യേ സതി ");
INSERT INTO sanmal_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","യാകൂബ് നിജപുത്രായ യൂഷഫേ യാം ഭൂമിമ് അദദാത് തത്സമീപസ്ഥായി ശോമിരോണപ്രദേശസ്യ സുഖാർ നാമ്നാ വിഖ്യാതസ്യ നഗരസ്യ സന്നിധാവുപാസ്ഥാത്| ");
INSERT INTO sanmal_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","തത്ര യാകൂബഃ പ്രഹിരാസീത്; തദാ ദ്വിതീയയാമവേലായാം ജാതായാം സ മാർഗേ ശ്രമാപന്നസ്തസ്യ പ്രഹേഃ പാർശ്വേ ഉപാവിശത്| ");
INSERT INTO sanmal_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ഏതർഹി കാചിത് ശോമിരോണീയാ യോഷിത് തോയോത്തോലനാർഥമ് തത്രാഗമത് ");
INSERT INTO sanmal_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","തദാ ശിഷ്യാഃ ഖാദ്യദ്രവ്യാണി ക്രേതും നഗരമ് അഗച്ഛൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","യീശുഃ ശോമിരോണീയാം താം യോഷിതമ് വ്യാഹാർഷീത് മഹ്യം കിഞ്ചിത് പാനീയം പാതും ദേഹി| കിന്തു ശോമിരോണീയൈഃ സാകം യിഹൂദീയലോകാ ന വ്യവാഹരൻ തസ്മാദ്ധേതോഃ സാകഥയത് ശോമിരോണീയാ യോഷിതദഹം ത്വം യിഹൂദീയോസി കഥം മത്തഃ പാനീയം പാതുമ് ഇച്ഛസി? ");
INSERT INTO sanmal_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","തതോ യീശുരവദദ് ഈശ്വരസ്യ യദ്ദാനം തത്കീദൃക് പാനീയം പാതും മഹ്യം ദേഹി യ ഇത്ഥം ത്വാം യാചതേ സ വാ ക ഇതി ചേദജ്ഞാസ്യഥാസ്തർഹി തമയാചിഷ്യഥാഃ സ ച തുഭ്യമമൃതം തോയമദാസ്യത്| ");
INSERT INTO sanmal_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","തദാ സാ സീമന്തിനീ ഭാഷിതവതി, ഹേ മഹേച്ഛ പ്രഹിർഗമ്ഭീരോ ഭവതോ നീരോത്തോലനപാത്രം നാസ്തീ ച തസ്മാത് തദമൃതം കീലാലം കുതഃ പ്രാപ്സ്യസി? ");
INSERT INTO sanmal_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","യോസ്മഭ്യമ് ഇമമന്ധൂം ദദൗ, യസ്യ ച പരിജനാ ഗോമേഷാദയശ്ച സർവ്വേഽസ്യ പ്രഹേഃ പാനീയം പപുരേതാദൃശോ യോസ്മാകം പൂർവ്വപുരുഷോ യാകൂബ് തസ്മാദപി ഭവാൻ മഹാൻ കിം? ");
INSERT INTO sanmal_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","തതോ യീശുരകഥയദ് ഇദം പാനീയം സഃ പിവതി സ പുനസ്തൃഷാർത്തോ ഭവിഷ്യതി, ");
INSERT INTO sanmal_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","കിന്തു മയാ ദത്തം പാനീയം യഃ പിവതി സ പുനഃ കദാപി തൃഷാർത്തോ ന ഭവിഷ്യതി| മയാ ദത്തമ് ഇദം തോയം തസ്യാന്തഃ പ്രസ്രവണരൂപം ഭൂത്വാ അനന്തായുര്യാവത് സ്രോഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","തദാ സാ വനിതാകഥയത് ഹേ മഹേച്ഛ തർഹി മമ പുനഃ പീപാസാ യഥാ ന ജായതേ തോയോത്തോലനായ യഥാത്രാഗമനം ന ഭവതി ച തദർഥം മഹ്യം തത്തോയം ദേഹീ| ");
INSERT INTO sanmal_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","തതോ യീശൂരവദദ്യാഹി തവ പതിമാഹൂയ സ്ഥാനേഽത്രാഗച്ഛ| ");
INSERT INTO sanmal_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","സാ വാമാവദത് മമ പതിർനാസ്തി| യീശുരവദത് മമ പതിർനാസ്തീതി വാക്യം ഭദ്രമവോചഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","യതസ്തവ പഞ്ച പതയോഭവൻ അധുനാ തു ത്വയാ സാർദ്ധം യസ്തിഷ്ഠതി സ തവ ഭർത്താ ന വാക്യമിദം സത്യമവാദിഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","തദാ സാ മഹിലാ ഗദിതവതി ഹേ മഹേച്ഛ ഭവാൻ ഏകോ ഭവിഷ്യദ്വാദീതി ബുദ്ധം മയാ| ");
INSERT INTO sanmal_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","അസ്മാകം പിതൃലോകാ ഏതസ്മിൻ ശിലോച്ചയേഽഭജന്ത, കിന്തു ഭവദ്ഭിരുച്യതേ യിരൂശാലമ് നഗരേ ഭജനയോഗ്യം സ്ഥാനമാസ്തേ| ");
INSERT INTO sanmal_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","യീശുരവോചത് ഹേ യോഷിത് മമ വാക്യേ വിശ്വസിഹി യദാ യൂയം കേവലശൈലേഽസ്മിൻ വാ യിരൂശാലമ് നഗരേ പിതുർഭജനം ന കരിഷ്യധ്വേ കാല ഏതാദൃശ ആയാതി| ");
INSERT INTO sanmal_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","യൂയം യം ഭജധ്വേ തം ന ജാനീഥ, കിന്തു വയം യം ഭജാമഹേ തം ജാനീമഹേ, യതോ യിഹൂദീയലോകാനാം മധ്യാത് പരിത്രാണം ജായതേ| ");
INSERT INTO sanmal_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","കിന്തു യദാ സത്യഭക്താ ആത്മനാ സത്യരൂപേണ ച പിതുർഭജനം കരിഷ്യന്തേ സമയ ഏതാദൃശ ആയാതി, വരമ് ഇദാനീമപി വിദ്യതേ ; യത ഏതാദൃശോ ഭത്കാൻ പിതാ ചേഷ്ടതേ| ");
INSERT INTO sanmal_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ഈശ്വര ആത്മാ; തതസ്തസ്യ യേ ഭക്താസ്തൈഃ സ ആത്മനാ സത്യരൂപേണ ച ഭജനീയഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","തദാ സാ മഹിലാവാദീത് ഖ്രീഷ്ടനാമ്നാ വിഖ്യാതോഽഭിഷിക്തഃ പുരുഷ ആഗമിഷ്യതീതി ജാനാമി സ ച സർവ്വാഃ കഥാ അസ്മാൻ ജ്ഞാപയിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","തതോ യീശുരവദത് ത്വയാ സാർദ്ധം കഥനം കരോമി യോഽഹമ് അഹമേവ സ പുരുഷഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ഏതസ്മിൻ സമയേ ശിഷ്യാ ആഗത്യ തഥാ സ്ത്രിയാ സാർദ്ധം തസ്യ കഥോപകഥനേ മഹാശ്ചര്യ്യമ് അമന്യന്ത തഥാപി ഭവാൻ കിമിച്ഛതി? യദ്വാ കിമർഥമ് ഏതയാ സാർദ്ധം കഥാം കഥയതി? ഇതി കോപി നാപൃച്ഛത്| ");
INSERT INTO sanmal_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","തതഃ പരം സാ നാരീ കലശം സ്ഥാപയിത്വാ നഗരമധ്യം ഗത്വാ ലോകേഭ്യോകഥായദ് ");
INSERT INTO sanmal_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","അഹം യദ്യത് കർമ്മാകരവം തത്സർവ്വം മഹ്യമകഥയദ് ഏതാദൃശം മാനവമേകമ് ആഗത്യ പശ്യത രു കിമ് അഭിഷിക്തോ ന ഭവതി ? ");
INSERT INTO sanmal_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","തതസ്തേ നഗരാദ് ബഹിരാഗത്യ താതസ്യ സമീപമ് ആയൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ഏതർഹി ശിഷ്യാഃ സാധയിത്വാ തം വ്യാഹാർഷുഃ ഹേ ഗുരോ ഭവാൻ കിഞ്ചിദ് ഭൂക്താം| ");
INSERT INTO sanmal_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","തതഃ സോവദദ് യുഷ്മാഭിര്യന്ന ജ്ഞായതേ താദൃശം ഭക്ഷ്യം മമാസ്തേ| ");
INSERT INTO sanmal_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","തദാ ശിഷ്യാഃ പരസ്പരം പ്രഷ്ടുമ് ആരമ്ഭന്ത, കിമസ്മൈ കോപി കിമപി ഭക്ഷ്യമാനീയ ദത്തവാൻ? ");
INSERT INTO sanmal_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","യീശുരവോചത് മത്പ്രേരകസ്യാഭിമതാനുരൂപകരണം തസ്യൈവ കർമ്മസിദ്ധികാരണഞ്ച മമ ഭക്ഷ്യം| ");
INSERT INTO sanmal_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","മാസചതുഷ്ടയേ ജാതേ ശസ്യകർത്തനസമയോ ഭവിഷ്യതീതി വാക്യം യുഷ്മാഭിഃ കിം നോദ്യതേ? കിന്ത്വഹം വദാമി, ശിര ഉത്തോല്യ ക്ഷേത്രാണി പ്രതി നിരീക്ഷ്യ പശ്യത, ഇദാനീം കർത്തനയോഗ്യാനി ശുക്ലവർണാന്യഭവൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","യശ്ഛിനത്തി സ വേതനം ലഭതേ അനന്തായുഃസ്വരൂപം ശസ്യം സ ഗൃഹ്ലാതി ച, തേനൈവ വപ്താ ഛേത്താ ച യുഗപദ് ആനന്ദതഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ഇത്ഥം സതി വപത്യേകശ്ഛിനത്യന്യ ഇതി വചനം സിദ്ധ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","യത്ര യൂയം ന പര്യ്യശ്രാമ്യത താദൃശം ശസ്യം ഛേത്തും യുഷ്മാൻ പ്രൈരയമ് അന്യേ ജനാഃപര്യ്യശ്രാമ്യൻ യൂയം തേഷാം ശ്രഗസ്യ ഫലമ് അലഭധ്വമ്| ");
INSERT INTO sanmal_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","യസ്മിൻ കാലേ യദ്യത് കർമ്മാകാർഷം തത്സർവ്വം സ മഹ്യമ് അകഥയത് തസ്യാ വനിതായാ ഇദം സാക്ഷ്യവാക്യം ശ്രുത്വാ തന്നഗരനിവാസിനോ ബഹവഃ ശോമിരോണീയലോകാ വ്യശ്വസൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","തഥാ ച തസ്യാന്തികേ സമുപസ്ഥായ സ്വേഷാം സന്നിധൗ കതിചിദ് ദിനാനി സ്ഥാതും തസ്മിൻ വിനയമ് അകുർവ്വാന തസ്മാത് സ ദിനദ്വയം തത്സ്ഥാനേ ന്യവഷ്ടത് ");
INSERT INTO sanmal_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","തതസ്തസ്യോപദേശേന ബഹവോഽപരേ വിശ്വസ്യ ");
INSERT INTO sanmal_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","താം യോഷാമവദൻ കേവലം തവ വാക്യേന പ്രതീമ ഇതി ന, കിന്തു സ ജഗതോഽഭിഷിക്തസ്ത്രാതേതി തസ്യ കഥാം ശ്രുത്വാ വയം സ്വയമേവാജ്ഞാസമഹി| ");
INSERT INTO sanmal_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","സ്വദേശേ ഭവിഷ്യദ്വക്തുഃ സത്കാരോ നാസ്തീതി യദ്യപി യീശുഃ പ്രമാണം ദത്വാകഥയത് ");
INSERT INTO sanmal_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","തഥാപി ദിവസദ്വയാത് പരം സ തസ്മാത് സ്ഥാനാദ് ഗാലീലം ഗതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","അനന്തരം യേ ഗാലീലീ ലിയലോകാ ഉത്സവേ ഗതാ ഉത്സവസമയേ യിരൂശലമ് നഗരേ തസ്യ സർവ്വാഃ ക്രിയാ അപശ്യൻ തേ ഗാലീലമ് ആഗതം തമ് ആഗൃഹ്ലൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","തതഃ പരമ് യീശു ര്യസ്മിൻ കാന്നാനഗരേ ജലം ദ്രാക്ഷാരസമ് ആകരോത് തത് സ്ഥാനം പുനരഗാത്| തസ്മിന്നേവ സമയേ കസ്യചിദ് രാജസഭാസ്താരസ്യ പുത്രഃ കഫർനാഹൂമപുരീ രോഗഗ്രസ്ത ആസീത്| ");
INSERT INTO sanmal_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","സ യേഹൂദീയദേശാദ് യീശോ ർഗാലീലാഗമനവാർത്താം നിശമ്യ തസ്യ സമീപം ഗത്വാ പ്രാർഥ്യ വ്യാഹൃതവാൻ മമ പുത്രസ്യ പ്രായേണ കാല ആസന്നഃ ഭവാൻ ആഗത്യ തം സ്വസ്ഥം കരോതു| ");
INSERT INTO sanmal_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","തദാ യീശുരകഥയദ് ആശ്ചര്യ്യം കർമ്മ ചിത്രം ചിഹ്നം ച ന ദൃഷ്ടാ യൂയം ന പ്രത്യേഷ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","തതഃ സ സഭാസദവദത് ഹേ മഹേച്ഛ മമ പുത്രേ ന മൃതേ ഭവാനാഗച്ഛതു| ");
INSERT INTO sanmal_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","യീശുസ്തമവദദ് ഗച്ഛ തവ പുത്രോഽജീവീത് തദാ യീശുനോക്തവാക്യേ സ വിശ്വസ്യ ഗതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ഗമനകാലേ മാർഗമധ്യേ ദാസാസ്തം സാക്ഷാത്പ്രാപ്യാവദൻ ഭവതഃ പുത്രോഽജീവീത്| ");
INSERT INTO sanmal_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","തതഃ കം കാലമാരഭ്യ രോഗപ്രതീകാരാരമ്ഭോ ജാതാ ഇതി പൃഷ്ടേ തൈരുക്തം ഹ്യഃ സാർദ്ധദണ്ഡദ്വയാധികദ്വിതീയയാമേ തസ്യ ജ്വരത്യാഗോഽഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","തദാ യീശുസ്തസ്മിൻ ക്ഷണേ പ്രോക്തവാൻ തവ പുത്രോഽജീവീത് പിതാ തദ്ബുദ്ധ്വാ സപരിവാരോ വ്യശ്വസീത്| ");
INSERT INTO sanmal_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","യിഹൂദീയദേശാദ് ആഗത്യ ഗാലീലി യീശുരേതദ് ദ്വിതീയമ് ആശ്ചര്യ്യകർമ്മാകരോത്| ");
INSERT INTO sanmal_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","തതഃ പരം യിഹൂദീയാനാമ് ഉത്സവ ഉപസ്ഥിതേ യീശു ര്യിരൂശാലമം ഗതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","തസ്മിന്നഗരേ മേഷനാമ്നോ ദ്വാരസ്യ സമീപേ ഇബ്രീയഭാഷയാ ബൈഥേസ്ദാ നാമ്നാ പിഷ്കരിണീ പഞ്ചഘട്ടയുക്താസീത്| ");
INSERT INTO sanmal_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","തസ്യാസ്തേഷു ഘട്ടേഷു കിലാലകമ്പനമ് അപേക്ഷ്യ അന്ധഖഞ്ചശുഷ്കാങ്ഗാദയോ ബഹവോ രോഗിണഃ പതന്തസ്തിഷ്ഠന്തി സ്മ| ");
INSERT INTO sanmal_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","യതോ വിശേഷകാലേ തസ്യ സരസോ വാരി സ്വർഗീയദൂത ഏത്യാകമ്പയത് തത്കീലാലകമ്പനാത് പരം യഃ കശ്ചിദ് രോഗീ പ്രഥമം പാനീയമവാരോഹത് സ ഏവ തത്ക്ഷണാദ് രോഗമുക്തോഽഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","തദാഷ്ടാത്രിംശദ്വർഷാണി യാവദ് രോഗഗ്രസ്ത ഏകജനസ്തസ്മിൻ സ്ഥാനേ സ്ഥിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","യീശുസ്തം ശയിതം ദൃഷ്ട്വാ ബഹുകാലികരോഗീതി ജ്ഞാത്വാ വ്യാഹൃതവാൻ ത്വം കിം സ്വസ്ഥോ ബുഭൂഷസി? ");
INSERT INTO sanmal_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","തതോ രോഗീ കഥിതവാൻ ഹേ മഹേച്ഛ യദാ കീലാലം കമ്പതേ തദാ മാം പുഷ്കരിണീമ് അവരോഹയിതും മമ കോപി നാസ്തി, തസ്മാൻ മമ ഗമനകാലേ കശ്ചിദന്യോഽഗ്രോ ഗത്വാ അവരോഹതി| ");
INSERT INTO sanmal_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","തദാ യീശുരകഥയദ് ഉത്തിഷ്ഠ, തവ ശയ്യാമുത്തോല്യ ഗൃഹീത്വാ യാഹി| ");
INSERT INTO sanmal_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","സ തത്ക്ഷണാത് സ്വസ്ഥോ ഭൂത്വാ ശയ്യാമുത്തോല്യാദായ ഗതവാൻ കിന്തു തദ്ദിനം വിശ്രാമവാരഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","തസ്മാദ് യിഹൂദീയാഃ സ്വസ്ഥം നരം വ്യാഹരൻ അദ്യ വിശ്രാമവാരേ ശയനീയമാദായ ന യാതവ്യമ്| ");
INSERT INTO sanmal_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","തതഃ സ പ്രത്യവോചദ് യോ മാം സ്വസ്ഥമ് അകാർഷീത് ശയനീയമ് ഉത്തോല്യാദായ യാതും മാം സ ഏവാദിശത്| ");
INSERT INTO sanmal_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","തദാ തേഽപൃച്ഛൻ ശയനീയമ് ഉത്തോല്യാദായ യാതും യ ആജ്ഞാപയത് സ കഃ? ");
INSERT INTO sanmal_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","കിന്തു സ ക ഇതി സ്വസ്ഥീഭൂതോ നാജാനാദ് യതസ്തസ്മിൻ സ്ഥാനേ ജനതാസത്ത്വാദ് യീശുഃ സ്ഥാനാന്തരമ് ആഗമത്| ");
INSERT INTO sanmal_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","തതഃ പരം യേശു ർമന്ദിരേ തം നരം സാക്ഷാത്പ്രാപ്യാകഥയത് പശ്യേദാനീമ് അനാമയോ ജാതോസി യഥാധികാ ദുർദശാ ന ഘടതേ തദ്ധേതോഃ പാപം കർമ്മ പുനർമാകാർഷീഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","തതഃ സ ഗത്വാ യിഹൂദീയാൻ അവദദ് യീശു ർമാമ് അരോഗിണമ് അകാർഷീത്| ");
INSERT INTO sanmal_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","തതോ യീശു ർവിശ്രാമവാരേ കർമ്മേദൃശം കൃതവാൻ ഇതി ഹേതോ ര്യിഹൂദീയാസ്തം താഡയിത്വാ ഹന്തുമ് അചേഷ്ടന്ത| ");
INSERT INTO sanmal_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","യീശുസ്താനാഖ്യത് മമ പിതാ യത് കാര്യ്യം കരോതി തദനുരൂപമ് അഹമപി കരോതി| ");
INSERT INTO sanmal_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","തതോ യിഹൂദീയാസ്തം ഹന്തും പുനരയതന്ത യതോ വിശ്രാമവാരം നാമന്യത തദേവ കേവലം ന അധികന്തു ഈശ്വരം സ്വപിതരം പ്രോച്യ സ്വമപീശ്വരതുല്യം കൃതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","പശ്ചാദ് യീശുരവദദ് യുഷ്മാനഹം യഥാർഥതരം വദാമി പുത്രഃ പിതരം യദ്യത് കർമ്മ കുർവ്വന്തം പശ്യതി തദതിരിക്തം സ്വേച്ഛാതഃ കിമപി കർമ്മ കർത്തും ന ശക്നോതി| പിതാ യത് കരോതി പുത്രോപി തദേവ കരോതി| ");
INSERT INTO sanmal_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","പിതാ പുത്രേ സ്നേഹം കരോതി തസ്മാത് സ്വയം യദ്യത് കർമ്മ കരോതി തത്സർവ്വം പുത്രം ദർശയതി ; യഥാ ച യുഷ്മാകം ആശ്ചര്യ്യജ്ഞാനം ജനിഷ്യതേ തദർഥമ് ഇതോപി മഹാകർമ്മ തം ദർശയിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","വസ്തുതസ്തു പിതാ യഥാ പ്രമിതാൻ ഉത്ഥാപ്യ സജിവാൻ കരോതി തദ്വത് പുത്രോപി യം യം ഇച്ഛതി തം തം സജീവം കരോതി| ");
INSERT INTO sanmal_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","സർവ്വേ പിതരം യഥാ സത്കുർവ്വന്തി തഥാ പുത്രമപി സത്കാരയിതും പിതാ സ്വയം കസ്യാപി വിചാരമകൃത്വാ സർവ്വവിചാരാണാം ഭാരം പുത്രേ സമർപിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","യഃ പുത്രം സത് കരോതി സ തസ്യ പ്രേരകമപി സത് കരോതി| ");
INSERT INTO sanmal_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","യുഷ്മാനാഹം യഥാർഥതരം വദാമി യോ ജനോ മമ വാക്യം ശ്രുത്വാ മത്പ്രേരകേ വിശ്വസിതി സോനന്തായുഃ പ്രാപ്നോതി കദാപി ദണ്ഡബാജനം ന ഭവതി നിധനാദുത്ഥായ പരമായുഃ പ്രാപ്നോതി| ");
INSERT INTO sanmal_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","അഹം യുഷ്മാനതിയഥാർഥം വദാമി യദാ മൃതാ ഈശ്വരപുത്രസ്യ നിനാദം ശ്രോഷ്യന്തി യേ ച ശ്രോഷ്യന്തി തേ സജീവാ ഭവിഷ്യന്തി സമയ ഏതാദൃശ ആയാതി വരമ് ഇദാനീമപ്യുപതിഷ്ഠതി| ");
INSERT INTO sanmal_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","പിതാ യഥാ സ്വയഞ്ജീവീ തഥാ പുത്രായ സ്വയഞ്ജീവിത്വാധികാരം ദത്തവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","സ മനുഷ്യപുത്രഃ ഏതസ്മാത് കാരണാത് പിതാ ദണ്ഡകരണാധികാരമപി തസ്മിൻ സമർപിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","ഏതദർഥേ യൂയമ് ആശ്ചര്യ്യം ന മന്യധ്വം യതോ യസ്മിൻ സമയേ തസ്യ നിനാദം ശ്രുത്വാ ശ്മശാനസ്ഥാഃ സർവ്വേ ബഹിരാഗമിഷ്യന്തി സമയ ഏതാദൃശ ഉപസ്ഥാസ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","തസ്മാദ് യേ സത്കർമ്മാണി കൃതവന്തസ്ത ഉത്ഥായ ആയുഃ പ്രാപ്സ്യന്തി യേ ച കുകർമാണി കൃതവന്തസ്ത ഉത്ഥായ ദണ്ഡം പ്രാപ്സ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","അഹം സ്വയം കിമപി കർത്തും ന ശക്നോമി യഥാ ശുണോമി തഥാ വിചാരയാമി മമ വിചാരഞ്ച ന്യായ്യഃ യതോഹം സ്വീയാഭീഷ്ടം നേഹിത്വാ മത്പ്രേരയിതുഃ പിതുരിഷ്ടമ് ഈഹേ| ");
INSERT INTO sanmal_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","യദി സ്വസ്മിൻ സ്വയം സാക്ഷ്യം ദദാമി തർഹി തത്സാക്ഷ്യമ് ആഗ്രാഹ്യം ഭവതി ; ");
INSERT INTO sanmal_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","കിന്തു മദർഥേഽപരോ ജനഃ സാക്ഷ്യം ദദാതി മദർഥേ തസ്യ യത് സാക്ഷ്യം തത് സത്യമ് ഏതദപ്യഹം ജാനാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","യുഷ്മാഭി ര്യോഹനം പ്രതി ലോകേഷു പ്രേരിതേഷു സ സത്യകഥായാം സാക്ഷ്യമദദാത്| ");
INSERT INTO sanmal_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","മാനുഷാദഹം സാക്ഷ്യം നോപേക്ഷേ തഥാപി യൂയം യഥാ പരിത്രയധ്വേ തദർഥമ് ഇദം വാക്യം വദാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","യോഹൻ ദേദീപ്യമാനോ ദീപ ഇവ തേജസ്വീ സ്ഥിതവാൻ യൂയമ് അൽപകാലം തസ്യ ദീപ്ത്യാനന്ദിതും സമമന്യധ്വം| ");
INSERT INTO sanmal_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","കിന്തു തത്പ്രമാണാദപി മമ ഗുരുതരം പ്രമാണം വിദ്യതേ പിതാ മാം പ്രേഷ്യ യദ്യത് കർമ്മ സമാപയിതും ശക്ത്തിമദദാത് മയാ കൃതം തത്തത് കർമ്മ മദർഥേ പ്രമാണം ദദാതി| ");
INSERT INTO sanmal_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","യഃ പിതാ മാം പ്രേരിതവാൻ മോപി മദർഥേ പ്രമാണം ദദാതി| തസ്യ വാക്യം യുഷ്മാഭിഃ കദാപി ന ശ്രുതം തസ്യ രൂപഞ്ച ന ദൃഷ്ടം ");
INSERT INTO sanmal_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","തസ്യ വാക്യഞ്ച യുഷ്മാകമ് അന്തഃ കദാപി സ്ഥാനം നാപ്നോതി യതഃ സ യം പ്രേഷിതവാൻ യൂയം തസ്മിൻ ന വിശ്വസിഥ| ");
INSERT INTO sanmal_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","ധർമ്മപുസ്തകാനി യൂയമ് ആലോചയധ്വം തൈ ർവാക്യൈരനന്തായുഃ പ്രാപ്സ്യാമ ഇതി യൂയം ബുധ്യധ്വേ തദ്ധർമ്മപുസ്തകാനി മദർഥേ പ്രമാണം ദദതി| ");
INSERT INTO sanmal_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","തഥാപി യൂയം പരമായുഃപ്രാപ്തയേ മമ സംനിധിമ് ന ജിഗമിഷഥ| ");
INSERT INTO sanmal_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","അഹം മാനുഷേഭ്യഃ സത്കാരം ന ഗൃഹ്ലാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","അഹം യുഷ്മാൻ ജാനാമി; യുഷ്മാകമന്തര ഈശ്വരപ്രേമ നാസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","അഹം നിജപിതു ർനാമ്നാഗതോസ്മി തഥാപി മാം ന ഗൃഹ്ലീഥ കിന്തു കശ്ചിദ് യദി സ്വനാമ്നാ സമാഗമിഷ്യതി തർഹി തം ഗ്രഹീഷ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","യൂയമ് ഈശ്വരാത് സത്കാരം ന ചിഷ്ടത്വാ കേവലം പരസ്പരം സത്കാരമ് ചേദ് ആദധ്വ്വേ തർഹി കഥം വിശ്വസിതും ശക്നുഥ? ");
INSERT INTO sanmal_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","പുതുഃ സമീപേഽഹം യുഷ്മാൻ അപവദിഷ്യാമീതി മാ ചിന്തയത യസ്മിൻ , യസ്മിൻ യുഷ്മാകം വിശ്വസഃ സഏവ മൂസാ യുഷ്മാൻ അപവദതി| ");
INSERT INTO sanmal_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","യദി യൂയം തസ്മിൻ വ്യശ്വസിഷ്യത തർഹി മയ്യപി വ്യശ്വസിഷ്യത, യത് സ മയി ലിഖിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","തതോ യദി തേന ലിഖിതവാനി ന പ്രതിഥ തർഹി മമ വാക്യാനി കഥം പ്രത്യേഷ്യഥ? ");
INSERT INTO sanmal_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","തതഃ പരം യീശു ർഗാലീൽ പ്രദേശീയസ്യ തിവിരിയാനാമ്നഃ സിന്ധോഃ പാരം ഗതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","തതോ വ്യാധിമല്ലോകസ്വാസ്ഥ്യകരണരൂപാണി തസ്യാശ്ചര്യ്യാണി കർമ്മാണി ദൃഷ്ട്വാ ബഹവോ ജനാസ്തത്പശ്ചാദ് അഗച്ഛൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","തതോ യീശുഃ പർവ്വതമാരുഹ്യ തത്ര ശിഷ്യൈഃ സാകമ്| ");
INSERT INTO sanmal_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","തസ്മിൻ സമയ നിസ്താരോത്സവനാമ്നി യിഹൂദീയാനാമ ഉത്സവ ഉപസ്ഥിതേ ");
INSERT INTO sanmal_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","യീശു ർനേത്രേ ഉത്തോല്യ ബഹുലോകാൻ സ്വസമീപാഗതാൻ വിലോക്യ ഫിലിപം പൃഷ്ടവാൻ ഏതേഷാം ഭോജനായ ഭോജദ്രവ്യാണി വയം കുത്ര ക്രേതും ശക്രുമഃ? ");
INSERT INTO sanmal_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","വാക്യമിദം തസ്യ പരീക്ഷാർഥമ് അവാദീത് കിന്തു യത് കരിഷ്യതി തത് സ്വയമ് അജാനാത്| ");
INSERT INTO sanmal_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ഫിലിപഃ പ്രത്യവോചത് ഏതേഷാമ് ഏകൈകോ യദ്യൽപമ് അൽപം പ്രാപ്നോതി തർഹി മുദ്രാപാദദ്വിശതേന ക്രീതപൂപാ അപി ന്യൂനാ ഭവിഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ശിമോൻ പിതരസ്യ ഭ്രാതാ ആന്ദ്രിയാഖ്യഃ ശിഷ്യാണാമേകോ വ്യാഹൃതവാൻ ");
INSERT INTO sanmal_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","അത്ര കസ്യചിദ് ബാലകസ്യ സമീപേ പഞ്ച യാവപൂപാഃ ക്ഷുദ്രമത്സ്യദ്വയഞ്ച സന്തി കിന്തു ലോകാനാം ഏതാവാതാം മധ്യേ തൈഃ കിം ഭവിഷ്യതി? ");
INSERT INTO sanmal_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","പശ്ചാദ് യീശുരവദത് ലോകാനുപവേശയത തത്ര ബഹുയവസസത്ത്വാത് പഞ്ചസഹസ്ത്രേഭ്യോ ന്യൂനാ അധികാ വാ പുരുഷാ ഭൂമ്യാമ് ഉപാവിശൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","തതോ യീശുസ്താൻ പൂപാനാദായ ഈശ്വരസ്യ ഗുണാൻ കീർത്തയിത്വാ ശിഷ്യേഷു സമാർപയത് തതസ്തേ തേഭ്യ ഉപവിഷ്ടലോകേഭ്യഃ പൂപാൻ യഥേഷ്ടമത്സ്യഞ്ച പ്രാദുഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","തേഷു തൃപ്തേഷു സ താനവോചദ് ഏതേഷാം കിഞ്ചിദപി യഥാ നാപചീയതേ തഥാ സർവ്വാണ്യവശിഷ്ടാനി സംഗൃഹ്ലീത| ");
INSERT INTO sanmal_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","തതഃ സർവ്വേഷാം ഭോജനാത് പരം തേ തേഷാം പഞ്ചാനാം യാവപൂപാനാം അവശിഷ്ടാന്യഖിലാനി സംഗൃഹ്യ ദ്വാദശഡല്ലകാൻ അപൂരയൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","അപരം യീശോരേതാദൃശീമ് ആശ്ചര്യ്യക്രിയാം ദൃഷ്ട്വാ ലോകാ മിഥോ വക്തുമാരേഭിരേ ജഗതി യസ്യാഗമനം ഭവിഷ്യതി സ ഏവായമ് അവശ്യം ഭവിഷ്യദ്വക്ത്താ| ");
INSERT INTO sanmal_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","അതഏവ ലോകാ ആഗത്യ തമാക്രമ്യ രാജാനം കരിഷ്യന്തി യീശുസ്തേഷാമ് ഈദൃശം മാനസം വിജ്ഞായ പുനശ്ച പർവ്വതമ് ഏകാകീ ഗതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","സായംകാല ഉപസ്ഥിതേ ശിഷ്യാ ജലധിതടം വ്രജിത്വാ നാവമാരുഹ്യ നഗരദിശി സിന്ധൗ വാഹയിത്വാഗമൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","തസ്മിൻ സമയേ തിമിര ഉപാതിഷ്ഠത് കിന്തു യീഷുസ്തേഷാം സമീപം നാഗച്ഛത്| ");
INSERT INTO sanmal_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","തദാ പ്രബലപവനവഹനാത് സാഗരേ മഹാതരങ്ഗോ ഭവിതുമ് ആരേഭേ| ");
INSERT INTO sanmal_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","തതസ്തേ വാഹയിത്വാ ദ്വിത്രാൻ ക്രോശാൻ ഗതാഃ പശ്ചാദ് യീശും ജലധേരുപരി പദ്ഭ്യാം വ്രജന്തം നൗകാന്തികമ് ആഗച്ഛന്തം വിലോക്യ ത്രാസയുക്താ അഭവൻ ");
INSERT INTO sanmal_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","കിന്തു സ താനുക്ത്തവാൻ അയമഹം മാ ഭൈഷ്ട| ");
INSERT INTO sanmal_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","തദാ തേ തം സ്വൈരം നാവി ഗൃഹീതവന്തഃ തദാ തത്ക്ഷണാദ് ഉദ്ദിഷ്ടസ്ഥാനേ നൗരുപാസ്ഥാത്| ");
INSERT INTO sanmal_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","യയാ നാവാ ശിഷ്യാ അഗച്ഛൻ തദന്യാ കാപി നൗകാ തസ്മിൻ സ്ഥാനേ നാസീത് തതോ യീശുഃ ശിഷ്യൈഃ സാകം നാഗമത് കേവലാഃ ശിഷ്യാ അഗമൻ ഏതത് പാരസ്ഥാ ലോകാ ജ്ഞാതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","കിന്തു തതഃ പരം പ്രഭു ര്യത്ര ഈശ്വരസ്യ ഗുണാൻ അനുകീർത്ത്യ ലോകാൻ പൂപാൻ അഭോജയത് തത്സ്ഥാനസ്യ സമീപസ്ഥതിവിരിയായാ അപരാസ്തരണയ ആഗമൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","യീശുസ്തത്ര നാസ്തി ശിഷ്യാ അപി തത്ര നാ സന്തി ലോകാ ഇതി വിജ്ഞായ യീശും ഗവേഷയിതും തരണിഭിഃ കഫർനാഹൂമ് പുരം ഗതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","തതസ്തേ സരിത്പതേഃ പാരേ തം സാക്ഷാത് പ്രാപ്യ പ്രാവോചൻ ഹേ ഗുരോ ഭവാൻ അത്ര സ്ഥാനേ കദാഗമത്? ");
INSERT INTO sanmal_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","തദാ യീശുസ്താൻ പ്രത്യവാദീദ് യുഷ്മാനഹം യഥാർഥതരം വദാമി ആശ്ചര്യ്യകർമ്മദർശനാദ്ധേതോ ർന കിന്തു പൂപഭോജനാത് തേന തൃപ്തത്വാഞ്ച മാം ഗവേഷയഥ| ");
INSERT INTO sanmal_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ക്ഷയണീയഭക്ഷ്യാർഥം മാ ശ്രാമിഷ്ട കിന്ത്വന്തായുർഭക്ഷ്യാർഥം ശ്രാമ്യത, തസ്മാത് താദൃശം ഭക്ഷ്യം മനുജപുത്രോ യുഷ്മാഭ്യം ദാസ്യതി; തസ്മിൻ താത ഈശ്വരഃ പ്രമാണം പ്രാദാത്| ");
INSERT INTO sanmal_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","തദാ തേഽപൃച്ഛൻ ഈശ്വരാഭിമതം കർമ്മ കർത്തുമ് അസ്മാഭിഃ കിം കർത്തവ്യം? ");
INSERT INTO sanmal_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","തതോ യീശുരവദദ് ഈശ്വരോ യം പ്രൈരയത് തസ്മിൻ വിശ്വസനമ് ഈശ്വരാഭിമതം കർമ്മ| ");
INSERT INTO sanmal_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","തദാ തേ വ്യാഹരൻ ഭവതാ കിം ലക്ഷണം ദർശിതം യദ്ദൃഷ്ട്വാ ഭവതി വിശ്വസിഷ്യാമഃ? ത്വയാ കിം കർമ്മ കൃതം? ");
INSERT INTO sanmal_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","അസ്മാകം പൂർവ്വപുരുഷാ മഹാപ്രാന്തരേ മാന്നാം ഭോക്ത്തും പ്രാപുഃ യഥാ ലിപിരാസ്തേ| സ്വർഗീയാണി തു ഭക്ഷ്യാണി പ്രദദൗ പരമേശ്വരഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","തദാ യീശുരവദദ് അഹം യുഷ്മാനതിയഥാർഥം വദാമി മൂസാ യുഷ്മാഭ്യം സ്വർഗീയം ഭക്ഷ്യം നാദാത് കിന്തു മമ പിതാ യുഷ്മാഭ്യം സ്വർഗീയം പരമം ഭക്ഷ്യം ദദാതി| ");
INSERT INTO sanmal_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","യഃ സ്വർഗാദവരുഹ്യ ജഗതേ ജീവനം ദദാതി സ ഈശ്വരദത്തഭക്ഷ്യരൂപഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","തദാ തേ പ്രാവോചൻ ഹേ പ്രഭോ ഭക്ഷ്യമിദം നിത്യമസ്മഭ്യം ദദാതു| ");
INSERT INTO sanmal_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","യീശുരവദദ് അഹമേവ ജീവനരൂപം ഭക്ഷ്യം യോ ജനോ മമ സന്നിധിമ് ആഗച്ഛതി സ ജാതു ക്ഷുധാർത്തോ ന ഭവിഷ്യതി, തഥാ യോ ജനോ മാം പ്രത്യേതി സ ജാതു തൃഷാർത്തോ ന ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","മാം ദൃഷ്ട്വാപി യൂയം ന വിശ്വസിഥ യുഷ്മാനഹമ് ഇത്യവോചം| ");
INSERT INTO sanmal_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","പിതാ മഹ്യം യാവതോ ലോകാനദദാത് തേ സർവ്വ ഏവ മമാന്തികമ് ആഗമിഷ്യന്തി യഃ കശ്ചിച്ച മമ സന്നിധിമ് ആയാസ്യതി തം കേനാപി പ്രകാരേണ ന ദൂരീകരിഷ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","നിജാഭിമതം സാധയിതും ന ഹി കിന്തു പ്രേരയിതുരഭിമതം സാധയിതും സ്വർഗാദ് ആഗതോസ്മി| ");
INSERT INTO sanmal_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","സ യാൻ യാൻ ലോകാൻ മഹ്യമദദാത് തേഷാമേകമപി ന ഹാരയിത്വാ ശേഷദിനേ സർവ്വാനഹമ് ഉത്ഥാപയാമി ഇദം മത്പ്രേരയിതുഃ പിതുരഭിമതം| ");
INSERT INTO sanmal_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","യഃ കശ്ചിൻ മാനവസുതം വിലോക്യ വിശ്വസിതി സ ശേഷദിനേ മയോത്ഥാപിതഃ സൻ അനന്തായുഃ പ്രാപ്സ്യതി ഇതി മത്പ്രേരകസ്യാഭിമതം| ");
INSERT INTO sanmal_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","തദാ സ്വർഗാദ് യദ് ഭക്ഷ്യമ് അവാരോഹത് തദ് ഭക്ഷ്യമ് അഹമേവ യിഹൂദീയലോകാസ്തസ്യൈതദ് വാക്യേ വിവദമാനാ വക്ത്തുമാരേഭിരേ ");
INSERT INTO sanmal_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","യൂഷഫഃ പുത്രോ യീശു ര്യസ്യ മാതാപിതരൗ വയം ജാനീമ ഏഷ കിം സഏവ ന? തർഹി സ്വർഗാദ് അവാരോഹമ് ഇതി വാക്യം കഥം വക്ത്തി? ");
INSERT INTO sanmal_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","തദാ യീശുസ്താൻ പ്രത്യവദത് പരസ്പരം മാ വിവദധ്വം ");
INSERT INTO sanmal_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","മത്പ്രേരകേണ പിത്രാ നാകൃഷ്ടഃ കോപി ജനോ മമാന്തികമ് ആയാതും ന ശക്നോതി കിന്ത്വാഗതം ജനം ചരമേഽഹ്നി പ്രോത്ഥാപയിഷ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","തേ സർവ്വ ഈശ്വരേണ ശിക്ഷിതാ ഭവിഷ്യന്തി ഭവിഷ്യദ്വാദിനാം ഗ്രന്ഥേഷു ലിപിരിത്ഥമാസ്തേ അതോ യഃ കശ്ചിത് പിതുഃ സകാശാത് ശ്രുത്വാ ശിക്ഷതേ സ ഏവ മമ സമീപമ് ആഗമിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","യ ഈശ്വരാദ് അജായത തം വിനാ കോപി മനുഷ്യോ ജനകം നാദർശത് കേവലഃ സഏവ താതമ് അദ്രാക്ഷീത്| ");
INSERT INTO sanmal_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","അഹം യുഷ്മാൻ യഥാർഥതരം വദാമി യോ ജനോ മയി വിശ്വാസം കരോതി സോനന്തായുഃ പ്രാപ്നോതി| ");
INSERT INTO sanmal_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","അഹമേവ തജ്ജീവനഭക്ഷ്യം| ");
INSERT INTO sanmal_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","യുഷ്മാകം പൂർവ്വപുരുഷാ മഹാപ്രാന്തരേ മന്നാഭക്ഷ്യം ഭൂക്ത്താപി മൃതാഃ ");
INSERT INTO sanmal_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","കിന്തു യദ്ഭക്ഷ്യം സ്വർഗാദാഗച്ഛത് തദ് യദി കശ്ചിദ് ഭുങ്ക്ത്തേ തർഹി സ ന മ്രിയതേ| ");
INSERT INTO sanmal_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","യജ്ജീവനഭക്ഷ്യം സ്വർഗാദാഗച്ഛത് സോഹമേവ ഇദം ഭക്ഷ്യം യോ ജനോ ഭുങ്ക്ത്തേ സ നിത്യജീവീ ഭവിഷ്യതി| പുനശ്ച ജഗതോ ജീവനാർഥമഹം യത് സ്വകീയപിശിതം ദാസ്യാമി തദേവ മയാ വിതരിതം ഭക്ഷ്യമ്| ");
INSERT INTO sanmal_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","തസ്മാദ് യിഹൂദീയാഃ പരസ്പരം വിവദമാനാ വക്ത്തുമാരേഭിരേ ഏഷ ഭോജനാർഥം സ്വീയം പലലം കഥമ് അസ്മഭ്യം ദാസ്യതി? ");
INSERT INTO sanmal_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","തദാ യീശുസ്താൻ ആവോചദ് യുഷ്മാനഹം യഥാർഥതരം വദാമി മനുഷ്യപുത്രസ്യാമിഷേ യുഷ്മാഭി ർന ഭുക്ത്തേ തസ്യ രുധിരേ ച ന പീതേ ജീവനേന സാർദ്ധം യുഷ്മാകം സമ്ബന്ധോ നാസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","യോ മമാമിഷം സ്വാദതി മമ സുധിരഞ്ച പിവതി സോനന്തായുഃ പ്രാപ്നോതി തതഃ ശേഷേഽഹ്നി തമഹമ് ഉത്ഥാപയിഷ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","യതോ മദീയമാമിഷം പരമം ഭക്ഷ്യം തഥാ മദീയം ശോണിതം പരമം പേയം| ");
INSERT INTO sanmal_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","യോ ജനോ മദീയം പലലം സ്വാദതി മദീയം രുധിരഞ്ച പിവതി സ മയി വസതി തസ്മിന്നഹഞ്ച വസാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","മത്പ്രേരയിത്രാ ജീവതാ താതേന യഥാഹം ജീവാമി തദ്വദ് യഃ കശ്ചിൻ മാമത്തി സോപി മയാ ജീവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","യദ്ഭക്ഷ്യം സ്വർഗാദാഗച്ഛത് തദിദം യന്മാന്നാം സ്വാദിത്വാ യുഷ്മാകം പിതരോഽമ്രിയന്ത താദൃശമ് ഇദം ഭക്ഷ്യം ന ഭവതി ഇദം ഭക്ഷ്യം യോ ഭക്ഷതി സ നിത്യം ജീവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","യദാ കഫർനാഹൂമ് പുര്യ്യാം ഭജനഗേഹേ ഉപാദിശത് തദാ കഥാ ഏതാ അകഥയത്| ");
INSERT INTO sanmal_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","തദേത്ഥം ശ്രുത്വാ തസ്യ ശിഷ്യാണാമ് അനേകേ പരസ്പരമ് അകഥയൻ ഇദം ഗാഢം വാക്യം വാക്യമീദൃശം കഃ ശ്രോതും ശക്രുയാത്? ");
INSERT INTO sanmal_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","കിന്തു യീശുഃ ശിഷ്യാണാമ് ഇത്ഥം വിവാദം സ്വചിത്തേ വിജ്ഞായ കഥിതവാൻ ഇദം വാക്യം കിം യുഷ്മാകം വിഘ്നം ജനയതി? ");
INSERT INTO sanmal_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","യദി മനുജസുതം പൂർവ്വവാസസ്ഥാനമ് ഊർദ്വ്വം ഗച്ഛന്തം പശ്യഥ തർഹി കിം ഭവിഷ്യതി? ");
INSERT INTO sanmal_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","ആത്മൈവ ജീവനദായകഃ വപു ർനിഷ്ഫലം യുഷ്മഭ്യമഹം യാനി വചാംസി കഥയാമി താന്യാത്മാ ജീവനഞ്ച| ");
INSERT INTO sanmal_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","കിന്തു യുഷ്മാകം മധ്യേ കേചന അവിശ്വാസിനഃ സന്തി കേ കേ ന വിശ്വസന്തി കോ വാ തം പരകരേഷു സമർപയിഷ്യതി താൻ യീശുരാപ്രഥമാദ് വേത്തി| ");
INSERT INTO sanmal_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","അപരമപി കഥിതവാൻ അസ്മാത് കാരണാദ് അകഥയം പിതുഃ സകാശാത് ശക്ത്തിമപ്രാപ്യ കോപി മമാന്തികമ് ആഗന്തും ന ശക്നോതി| ");
INSERT INTO sanmal_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","തത്കാലേഽനേകേ ശിഷ്യാ വ്യാഘുട്യ തേന സാർദ്ധം പുന ർനാഗച്ഛൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","തദാ യീശു ർദ്വാദശശിഷ്യാൻ ഉക്ത്തവാൻ യൂയമപി കിം യാസ്യഥ? ");
INSERT INTO sanmal_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","തതഃ ശിമോൻ പിതരഃ പ്രത്യവോചത് ഹേ പ്രഭോ കസ്യാഭ്യർണം ഗമിഷ്യാമഃ? ");
INSERT INTO sanmal_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","അനന്തജീവനദായിന്യോ യാഃ കഥാസ്താസ്തവൈവ| ഭവാൻ അമരേശ്വരസ്യാഭിഷിക്ത്തപുത്ര ഇതി വിശ്വസ്യ നിശ്ചിതം ജാനീമഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","തദാ യീശുരവദത് കിമഹം യുഷ്മാകം ദ്വാദശജനാൻ മനോനീതാൻ ന കൃതവാൻ? കിന്തു യുഷ്മാകം മധ്യേപി കശ്ചിദേകോ വിഘ്നകാരീ വിദ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ഇമാം കഥം സ ശിമോനഃ പുത്രമ് ഈഷ്കരീയോതീയം യിഹൂദാമ് ഉദ്ദിശ്യ കഥിതവാൻ യതോ ദ്വാദശാനാം മധ്യേ ഗണിതഃ സ തം പരകരേഷു സമർപയിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","തതഃ പരം യിഹൂദീയലോകാസ്തം ഹന്തും സമൈഹന്ത തസ്മാദ് യീശു ര്യിഹൂദാപ്രദേശേ പര്യ്യടിതും നേച്ഛൻ ഗാലീൽ പ്രദേശേ പര്യ്യടിതും പ്രാരഭത| ");
INSERT INTO sanmal_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","കിന്തു തസ്മിൻ സമയേ യിഹൂദീയാനാം ദൂഷ്യവാസനാമോത്സവ ഉപസ്ഥിതേ ");
INSERT INTO sanmal_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","തസ്യ ഭ്രാതരസ്തമ് അവദൻ യാനി കർമ്മാണി ത്വയാ ക്രിയന്തേ താനി യഥാ തവ ശിഷ്യാഃ പശ്യന്തി തദർഥം ത്വമിതഃ സ്ഥാനാദ് യിഹൂദീയദേശം വ്രജ| ");
INSERT INTO sanmal_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","യഃ കശ്ചിത് സ്വയം പ്രചികാശിഷതി സ കദാപി ഗുപ്തം കർമ്മ ന കരോതി യദീദൃശം കർമ്മ കരോഷി തർഹി ജഗതി നിജം പരിചായയ| ");
INSERT INTO sanmal_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","യതസ്തസ്യ ഭ്രാതരോപി തം ന വിശ്വസന്തി| ");
INSERT INTO sanmal_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","തദാ യീശുസ്താൻ അവോചത് മമ സമയ ഇദാനീം നോപതിഷ്ഠതി കിന്തു യുഷ്മാകം സമയഃ സതതമ് ഉപതിഷ്ഠതി| ");
INSERT INTO sanmal_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","ജഗതോ ലോകാ യുഷ്മാൻ ഋതീയിതും ന ശക്രുവന്തി കിന്തു മാമേവ ഋതീയന്തേ യതസ്തേഷാം കർമാണി ദുഷ്ടാനി തത്ര സാക്ഷ്യമിദമ് അഹം ദദാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","അതഏവ യൂയമ് ഉത്സവേഽസ്മിൻ യാത നാഹമ് ഇദാനീമ് അസ്മിന്നുത്സവേ യാമി യതോ മമ സമയ ഇദാനീം ന സമ്പൂർണഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ഇതി വാക്യമ് ഉക്ത്ത്വാ സ ഗാലീലി സ്ഥിതവാൻ ");
INSERT INTO sanmal_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","കിന്തു തസ്യ ഭ്രാതൃഷു തത്ര പ്രസ്ഥിതേഷു സത്സു സോഽപ്രകട ഉത്സവമ് അഗച്ഛത്| ");
INSERT INTO sanmal_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","അനന്തരമ് ഉത്സവമ് ഉപസ്ഥിതാ യിഹൂദീയാസ്തം മൃഗയിത്വാപൃച്ഛൻ സ കുത്ര? ");
INSERT INTO sanmal_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","തതോ ലോകാനാം മധ്യേ തസ്മിൻ നാനാവിധാ വിവാദാ ഭവിതുമ് ആരബ്ധവന്തഃ| കേചിദ് അവോചൻ സ ഉത്തമഃ പുരുഷഃ കേചിദ് അവോചൻ ന തഥാ വരം ലോകാനാം ഭ്രമം ജനയതി| ");
INSERT INTO sanmal_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","കിന്തു യിഹൂദീയാനാം ഭയാത് കോപി തസ്യ പക്ഷേ സ്പഷ്ടം നാകഥയത്| ");
INSERT INTO sanmal_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","തതഃ പരമ് ഉത്സവസ്യ മധ്യസമയേ യീശു ർമന്ദിരം ഗത്വാ സമുപദിശതി സ്മ| ");
INSERT INTO sanmal_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","തതോ യിഹൂദീയാ ലോകാ ആശ്ചര്യ്യം ജ്ഞാത്വാകഥയൻ ഏഷാ മാനുഷോ നാധീത്യാ കഥമ് ഏതാദൃശോ വിദ്വാനഭൂത്? ");
INSERT INTO sanmal_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","തദാ യീശുഃ പ്രത്യവോചദ് ഉപദേശോയം ന മമ കിന്തു യോ മാം പ്രേഷിതവാൻ തസ്യ| ");
INSERT INTO sanmal_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","യോ ജനോ നിദേശം തസ്യ ഗ്രഹീഷ്യതി മമോപദേശോ മത്തോ ഭവതി കിമ് ഈശ്വരാദ് ഭവതി സ ഗനസ്തജ്ജ്ഞാതും ശക്ഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","യോ ജനഃ സ്വതഃ കഥയതി സ സ്വീയം ഗൗരവമ് ഈഹതേ കിന്തു യഃ പ്രേരയിതു ർഗൗരവമ് ഈഹതേ സ സത്യവാദീ തസ്മിൻ കോപ്യധർമ്മോ നാസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","മൂസാ യുഷ്മഭ്യം വ്യവസ്ഥാഗ്രന്ഥം കിം നാദദാത്? കിന്തു യുഷ്മാകം കോപി താം വ്യവസ്ഥാം ന സമാചരതി| മാം ഹന്തും കുതോ യതധ്വേ? ");
INSERT INTO sanmal_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","തദാ ലോകാ അവദൻ ത്വം ഭൂതഗ്രസ്തസ്ത്വാം ഹന്തും കോ യതതേ? ");
INSERT INTO sanmal_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","തതോ യീശുരവോചദ് ഏകം കർമ്മ മയാകാരി തസ്മാദ് യൂയം സർവ്വ മഹാശ്ചര്യ്യം മന്യധ്വേ| ");
INSERT INTO sanmal_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","മൂസാ യുഷ്മഭ്യം ത്വക്ഛേദവിധിം പ്രദദൗ സ മൂസാതോ ന ജാതഃ കിന്തു പിതൃപുരുഷേഭ്യോ ജാതഃ തേന വിശ്രാമവാരേഽപി മാനുഷാണാം ത്വക്ഛേദം കുരുഥ| ");
INSERT INTO sanmal_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","അതഏവ വിശ്രാമവാരേ മനുഷ്യാണാം ത്വക്ഛേദേ കൃതേ യദി മൂസാവ്യവസ്ഥാമങ്ഗനം ന ഭവതി തർഹി മയാ വിശ്രാമവാരേ മാനുഷഃ സമ്പൂർണരൂപേണ സ്വസ്ഥോഽകാരി തത്കാരണാദ് യൂയം കിം മഹ്യം കുപ്യഥ? ");
INSERT INTO sanmal_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","സപക്ഷപാതം വിചാരമകൃത്വാ ന്യായ്യം വിചാരം കുരുത| ");
INSERT INTO sanmal_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","തദാ യിരൂശാലമ് നിവാസിനഃ കതിപയജനാ അകഥയൻ ഇമേ യം ഹന്തും ചേഷ്ടന്തേ സ ഏവായം കിം ന? ");
INSERT INTO sanmal_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","കിന്തു പശ്യത നിർഭയഃ സൻ കഥാം കഥയതി തഥാപി കിമപി അ വദന്ത്യേതേ അയമേവാഭിഷിക്ത്തോ ഭവതീതി നിശ്ചിതം കിമധിപതയോ ജാനന്തി? ");
INSERT INTO sanmal_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","മനുജോയം കസ്മാദാഗമദ് ഇതി വയം ജാനോമഃ കിന്ത്വഭിഷിക്ത്ത ആഗതേ സ കസ്മാദാഗതവാൻ ഇതി കോപി ജ്ഞാതും ന ശക്ഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","തദാ യീശു ർമധ്യേമന്ദിരമ് ഉപദിശൻ ഉച്ചൈഃകാരമ് ഉക്ത്തവാൻ യൂയം കിം മാം ജാനീഥ? കസ്മാച്ചാഗതോസ്മി തദപി കിം ജാനീഥ? നാഹം സ്വത ആഗതോസ്മി കിന്തു യഃ സത്യവാദീ സഏവ മാം പ്രേഷിതവാൻ യൂയം തം ന ജാനീഥ| ");
INSERT INTO sanmal_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","തമഹം ജാനേ തേനാഹം പ്രേരിത അഗതോസ്മി| ");
INSERT INTO sanmal_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","തസ്മാദ് യിഹൂദീയാസ്തം ധർത്തുമ് ഉദ്യതാസ്തഥാപി കോപി തസ്യ ഗാത്രേ ഹസ്തം നാർപയദ് യതോ ഹേതോസ്തദാ തസ്യ സമയോ നോപതിഷ്ഠതി| ");
INSERT INTO sanmal_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","കിന്തു ബഹവോ ലോകാസ്തസ്മിൻ വിശ്വസ്യ കഥിതവാന്തോഽഭിഷിക്ത്തപുരുഷ ആഗത്യ മാനുഷസ്യാസ്യ ക്രിയാഭ്യഃ കിമ് അധികാ ആശ്ചര്യ്യാഃ ക്രിയാഃ കരിഷ്യതി? ");
INSERT INTO sanmal_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","തതഃ പരം ലോകാസ്തസ്മിൻ ഇത്ഥം വിവദന്തേ ഫിരൂശിനഃ പ്രധാനയാജകാഞ്ചേതി ശ്രുതവന്തസ്തം ധൃത്വാ നേതും പദാതിഗണം പ്രേഷയാമാസുഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","തതോ യീശുരവദദ് അഹമ് അൽപദിനാനി യുഷ്മാഭിഃ സാർദ്ധം സ്ഥിത്വാ മത്പ്രേരയിതുഃ സമീപം യാസ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","മാം മൃഗയിഷ്യധ്വേ കിന്തൂദ്ദേശം ന ലപ്സ്യധ്വേ രത്ര സ്ഥാസ്യാമി തത്ര യൂയം ഗന്തും ന ശക്ഷ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","തദാ യിഹൂദീയാഃ പരസ്പരം വക്ത്തുമാരേഭിരേ അസ്യോദ്ദേശം ന പ്രാപ്സ്യാമ ഏതാദൃശം കിം സ്ഥാനം യാസ്യതി? ഭിന്നദേശേ വികീർണാനാം യിഹൂദീയാനാം സന്നിധിമ് ഏഷ ഗത്വാ താൻ ഉപദേക്ഷ്യതി കിം? ");
INSERT INTO sanmal_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","നോ ചേത് മാം ഗവേഷയിഷ്യഥ കിന്തൂദ്ദേശം ന പ്രാപ്സ്യഥ ഏഷ കോദൃശം വാക്യമിദം വദതി? ");
INSERT INTO sanmal_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","അനന്തരമ് ഉത്സവസ്യ ചരമേഽഹനി അർഥാത് പ്രധാനദിനേ യീശുരുത്തിഷ്ഠൻ ഉച്ചൈഃകാരമ് ആഹ്വയൻ ഉദിതവാൻ യദി കശ്ചിത് തൃഷാർത്തോ ഭവതി തർഹി മമാന്തികമ് ആഗത്യ പിവതു| ");
INSERT INTO sanmal_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","യഃ കശ്ചിന്മയി വിശ്വസിതി ധർമ്മഗ്രന്ഥസ്യ വചനാനുസാരേണ തസ്യാഭ്യന്തരതോഽമൃതതോയസ്യ സ്രോതാംസി നിർഗമിഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","യേ തസ്മിൻ വിശ്വസന്തി ത ആത്മാനം പ്രാപ്സ്യന്തീത്യർഥേ സ ഇദം വാക്യം വ്യാഹൃതവാൻ ഏതത്കാലം യാവദ് യീശു ർവിഭവം ന പ്രാപ്തസ്തസ്മാത് പവിത്ര ആത്മാ നാദീയത| ");
INSERT INTO sanmal_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ഏതാം വാണീം ശ്രുത്വാ ബഹവോ ലോകാ അവദൻ അയമേവ നിശ്ചിതം സ ഭവിഷ്യദ്വാദീ| ");
INSERT INTO sanmal_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","കേചിദ് അകഥയൻ ഏഷഏവ സോഭിഷിക്ത്തഃ കിന്തു കേചിദ് അവദൻ സോഭിഷിക്ത്തഃ കിം ഗാലീൽ പ്രദേശേ ജനിഷ്യതേ? ");
INSERT INTO sanmal_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","സോഭിഷിക്ത്തോ ദായൂദോ വംശേ ദായൂദോ ജന്മസ്ഥാനേ ബൈത്ലേഹമി പത്തനേ ജനിഷ്യതേ ധർമ്മഗ്രന്ഥേ കിമിത്ഥം ലിഖിതം നാസ്തി? ");
INSERT INTO sanmal_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ഇത്ഥം തസ്മിൻ ലോകാനാം ഭിന്നവാക്യതാ ജാതാ| ");
INSERT INTO sanmal_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","കതിപയലോകാസ്തം ധർത്തുമ് ഐച്ഛൻ തഥാപി തദ്വപുഷി കോപി ഹസ്തം നാർപയത്| ");
INSERT INTO sanmal_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","അനന്തരം പാദാതിഗണേ പ്രധാനയാജകാനാം ഫിരൂശിനാഞ്ച സമീപമാഗതവതി തേ താൻ അപൃച്ഛൻ കുതോ ഹേതോസ്തം നാനയത? ");
INSERT INTO sanmal_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","തദാ പദാതയഃ പ്രത്യവദൻ സ മാനവ ഇവ കോപി കദാപി നോപാദിശത്| ");
INSERT INTO sanmal_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","തതഃ ഫിരൂശിനഃ പ്രാവോചൻ യൂയമപി കിമഭ്രാമിഷ്ട? ");
INSERT INTO sanmal_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","അധിപതീനാം ഫിരൂശിനാഞ്ച കോപി കിം തസ്മിൻ വ്യശ്വസീത്? ");
INSERT INTO sanmal_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","യേ ശാസ്ത്രം ന ജാനന്തി ത ഇമേഽധമലോകാഏവ ശാപഗ്രസ്താഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","തദാ നികദീമനാമാ തേഷാമേകോ യഃ ക്ഷണദായാം യീശോഃ സന്നിധിമ് അഗാത് സ ഉക്ത്തവാൻ ");
INSERT INTO sanmal_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","തസ്യ വാക്യേ ന ശ്രുതേ കർമ്മണി ച ന വിദിതേ ഽസ്മാകം വ്യവസ്ഥാ കിം കഞ്ചന മനുജം ദോഷീകരോതി? ");
INSERT INTO sanmal_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","തതസ്തേ വ്യാഹരൻ ത്വമപി കിം ഗാലീലീയലോകഃ? വിവിച്യ പശ്യ ഗലീലി കോപി ഭവിഷ്യദ്വാദീ നോത്പദ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","തതഃ പരം സർവ്വേ സ്വം സ്വം ഗൃഹം ഗതാഃ കിന്തു യീശു ർജൈതുനനാമാനം ശിലോച്ചയം ഗതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","പ്രത്യൂഷേ യീശുഃ പനർമന്ദിരമ് ആഗച്ഛത് ");
INSERT INTO sanmal_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","തതഃ സർവ്വേഷു ലോകേഷു തസ്യ സമീപ ആഗതേഷു സ ഉപവിശ്യ താൻ ഉപദേഷ്ടുമ് ആരഭത| ");
INSERT INTO sanmal_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","തദാ അധ്യാപകാഃ ഫിരൂശിനഞ്ച വ്യഭിചാരകർമ്മണി ധൃതം സ്ത്രിയമേകാമ് ആനിയ സർവ്വേഷാം മധ്യേ സ്ഥാപയിത്വാ വ്യാഹരൻ ");
INSERT INTO sanmal_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ഹേ ഗുരോ യോഷിതമ് ഇമാം വ്യഭിചാരകർമ്മ കുർവ്വാണാം ലോകാ ധൃതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ഏതാദൃശലോകാഃ പാഷാണാഘാതേന ഹന്തവ്യാ ഇതി വിധിർമൂസാവ്യവസ്ഥാഗ്രന്ഥേ ലിഖിതോസ്തി കിന്തു ഭവാൻ കിമാദിശതി? ");
INSERT INTO sanmal_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","തേ തമപവദിതും പരീക്ഷാഭിപ്രായേണ വാക്യമിദമ് അപൃച്ഛൻ കിന്തു സ പ്രഹ്വീഭൂയ ഭൂമാവങ്ഗല്യാ ലേഖിതുമ് ആരഭത| ");
INSERT INTO sanmal_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","തതസ്തൈഃ പുനഃ പുനഃ പൃഷ്ട ഉത്ഥായ കഥിതവാൻ യുഷ്മാകം മധ്യേ യോ ജനോ നിരപരാധീ സഏവ പ്രഥമമ് ഏനാം പാഷാണേനാഹന്തു| ");
INSERT INTO sanmal_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","പശ്ചാത് സ പുനശ്ച പ്രഹ്വീഭൂയ ഭൂമൗ ലേഖിതുമ് ആരഭത| ");
INSERT INTO sanmal_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","താം കഥം ശ്രുത്വാ തേ സ്വസ്വമനസി പ്രബോധം പ്രാപ്യ ജ്യേഷ്ഠാനുക്രമം ഏകൈകശഃ സർവ്വേ ബഹിരഗച്ഛൻ തതോ യീശുരേകാകീ തയക്ത്തോഭവത് മധ്യസ്ഥാനേ ദണ്ഡായമാനാ സാ യോഷാ ച സ്ഥിതാ| ");
INSERT INTO sanmal_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","തത്പശ്ചാദ് യീശുരുത്ഥായ താം വനിതാം വിനാ കമപ്യപരം ന വിലോക്യ പൃഷ്ടവാൻ ഹേ വാമേ തവാപവാദകാഃ കുത്ര? കോപി ത്വാം കിം ന ദണ്ഡയതി? ");
INSERT INTO sanmal_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","സാവദത് ഹേ മഹേച്ഛ കോപി ന തദാ യീശുരവോചത് നാഹമപി ദണ്ഡയാമി യാഹി പുനഃ പാപം മാകാർഷീഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","തതോ യീശുഃ പുനരപി ലോകേഭ്യ ഇത്ഥം കഥയിതുമ് ആരഭത ജഗതോഹം ജ്യോതിഃസ്വരൂപോ യഃ കശ്ചിൻ മത്പശ്ചാദ ഗച്ഛതി സ തിമിരേ ന ഭ്രമിത്വാ ജീവനരൂപാം ദീപ്തിം പ്രാപ്സ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","തതഃ ഫിരൂശിനോഽവാദിഷുസ്ത്വം സ്വാർഥേ സ്വയം സാക്ഷ്യം ദദാസി തസ്മാത് തവ സാക്ഷ്യം ഗ്രാഹ്യം ന ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","തദാ യീശുഃ പ്രത്യുദിതവാൻ യദ്യപി സ്വാർഥേഽഹം സ്വയം സാക്ഷ്യം ദദാമി തഥാപി മത് സാക്ഷ്യം ഗ്രാഹ്യം യസ്മാദ് അഹം കുത ആഗതോസ്മി ക്വ യാമി ച തദഹം ജാനാമി കിന്തു കുത ആഗതോസ്മി കുത്ര ഗച്ഛാമി ച തദ് യൂയം ന ജാനീഥ| ");
INSERT INTO sanmal_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","യൂയം ലൗകികം വിചാരയഥ നാഹം കിമപി വിചാരയാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","കിന്തു യദി വിചാരയാമി തർഹി മമ വിചാരോ ഗ്രഹീതവ്യോ യതോഹമ് ഏകാകീ നാസ്മി പ്രേരയിതാ പിതാ മയാ സഹ വിദ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","ദ്വയോ ർജനയോഃ സാക്ഷ്യം ഗ്രഹണീയം ഭവതീതി യുഷ്മാകം വ്യവസ്ഥാഗ്രന്ഥേ ലിഖിതമസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","അഹം സ്വാർഥേ സ്വയം സാക്ഷിത്വം ദദാമി യശ്ച മമ താതോ മാം പ്രേരിതവാൻ സോപി മദർഥേ സാക്ഷ്യം ദദാതി| ");
INSERT INTO sanmal_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","തദാ തേഽപൃച്ഛൻ തവ താതഃ കുത്ര? തതോ യീശുഃ പ്രത്യവാദീദ് യൂയം മാം ന ജാനീഥ മത്പിതരഞ്ച ന ജാനീഥ യദി മാമ് അക്ഷാസ്യത തർഹി മമ താതമപ്യക്ഷാസ്യത| ");
INSERT INTO sanmal_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","യീശു ർമന്ദിര ഉപദിശ്യ ഭണ്ഡാഗാരേ കഥാ ഏതാ അകഥയത് തഥാപി തം പ്രതി കോപി കരം നോദതോലയത്| ");
INSERT INTO sanmal_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","തതഃ പരം യീശുഃ പുനരുദിതവാൻ അധുനാഹം ഗച്ഛാമി യൂയം മാം ഗവേഷയിഷ്യഥ കിന്തു നിജൈഃ പാപൈ ർമരിഷ്യഥ യത് സ്ഥാനമ് അഹം യാസ്യാമി തത് സ്ഥാനമ് യൂയം യാതും ന ശക്ഷ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","തദാ യിഹൂദീയാഃ പ്രാവോചൻ കിമയമ് ആത്മഘാതം കരിഷ്യതി? യതോ യത് സ്ഥാനമ് അഹം യാസ്യാമി തത് സ്ഥാനമ് യൂയം യാതും ന ശക്ഷ്യഥ ഇതി വാക്യം ബ്രവീതി| ");
INSERT INTO sanmal_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","തതോ യീശുസ്തേഭ്യഃ കഥിതവാൻ യൂയമ് അധഃസ്ഥാനീയാ ലോകാ അഹമ് ഊർദ്വ്വസ്ഥാനീയഃ യൂയമ് ഏതജ്ജഗത്സമ്ബന്ധീയാ അഹമ് ഏതജ്ജഗത്സമ്ബന്ധീയോ ന| ");
INSERT INTO sanmal_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","തസ്മാത് കഥിതവാൻ യൂയം നിജൈഃ പാപൈ ർമരിഷ്യഥ യതോഹം സ പുമാൻ ഇതി യദി ന വിശ്വസിഥ തർഹി നിജൈഃ പാപൈ ർമരിഷ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","തദാ തേ ഽപൃച്ഛൻ കസ്ത്വം? തതോ യീശുഃ കഥിതവാൻ യുഷ്മാകം സന്നിധൗ യസ്യ പ്രസ്താവമ് ആ പ്രഥമാത് കരോമി സഏവ പുരുഷോഹം| ");
INSERT INTO sanmal_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","യുഷ്മാസു മയാ ബഹുവാക്യം വക്ത്തവ്യം വിചാരയിതവ്യഞ്ച കിന്തു മത്പ്രേരയിതാ സത്യവാദീ തസ്യ സമീപേ യദഹം ശ്രുതവാൻ തദേവ ജഗതേ കഥയാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","കിന്തു സ ജനകേ വാക്യമിദം പ്രോക്ത്തവാൻ ഇതി തേ നാബുധ്യന്ത| ");
INSERT INTO sanmal_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","തതോ യീശുരകഥയദ് യദാ മനുഷ്യപുത്രമ് ഊർദ്വ്വ ഉത്ഥാപയിഷ്യഥ തദാഹം സ പുമാൻ കേവലഃ സ്വയം കിമപി കർമ്മ ന കരോമി കിന്തു താതോ യഥാ ശിക്ഷയതി തദനുസാരേണ വാക്യമിദം വദാമീതി ച യൂയം ജ്ഞാതും ശക്ഷ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","മത്പ്രേരയിതാ പിതാ മാമ് ഏകാകിനം ന ത്യജതി സ മയാ സാർദ്ധം തിഷ്ഠതി യതോഹം തദഭിമതം കർമ്മ സദാ കരോമി| ");
INSERT INTO sanmal_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","തദാ തസ്യൈതാനി വാക്യാനി ശ്രുത്വാ ബഹുവസ്താസ്മിൻ വ്യശ്വസൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","യേ യിഹൂദീയാ വ്യശ്വസൻ യീശുസ്തേഭ്യോഽകഥയത് ");
INSERT INTO sanmal_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","മമ വാക്യേ യദി യൂയമ് ആസ്ഥാം കുരുഥ തർഹി മമ ശിഷ്യാ ഭൂത്വാ സത്യത്വം ജ്ഞാസ്യഥ തതഃ സത്യതയാ യുഷ്മാകം മോക്ഷോ ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","തദാ തേ പ്രത്യവാദിഷുഃ വയമ് ഇബ്രാഹീമോ വംശഃ കദാപി കസ്യാപി ദാസാ ന ജാതാസ്തർഹി യുഷ്മാകം മുക്ത്തി ർഭവിഷ്യതീതി വാക്യം കഥം ബ്രവീഷി? ");
INSERT INTO sanmal_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","തദാ യീശുഃ പ്രത്യവദദ് യുഷ്മാനഹം യഥാർഥതരം വദാമി യഃ പാപം കരോതി സ പാപസ്യ ദാസഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","ദാസശ്ച നിരന്തരം നിവേശനേ ന തിഷ്ഠതി കിന്തു പുത്രോ നിരന്തരം തിഷ്ഠതി| ");
INSERT INTO sanmal_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","അതഃ പുത്രോ യദി യുഷ്മാൻ മോചയതി തർഹി നിതാന്തമേവ മുക്ത്താ ഭവിഷ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","യുയമ് ഇബ്രാഹീമോ വംശ ഇത്യഹം ജാനാമി കിന്തു മമ കഥാ യുഷ്മാകമ് അന്തഃകരണേഷു സ്ഥാനം ന പ്രാപ്നുവന്തി തസ്മാദ്ധേതോ ർമാം ഹന്തുമ് ഈഹധ്വേ| ");
INSERT INTO sanmal_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","അഹം സ്വപിതുഃ സമീപേ യദപശ്യം തദേവ കഥയാമി തഥാ യൂയമപി സ്വപിതുഃ സമീപേ യദപശ്യത തദേവ കുരുധ്വേ| ");
INSERT INTO sanmal_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","തദാ തേ പ്രത്യവോചൻ ഇബ്രാഹീമ് അസ്മാകം പിതാ തതോ യീശുരകഥയദ് യദി യൂയമ് ഇബ്രാഹീമഃ സന്താനാ അഭവിഷ്യത തർഹി ഇബ്രാഹീമ ആചാരണവദ് ആചരിഷ്യത| ");
INSERT INTO sanmal_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ഈശ്വരസ്യ മുഖാത് സത്യം വാക്യം ശ്രുത്വാ യുഷ്മാൻ ജ്ഞാപയാമി യോഹം തം മാം ഹന്തും ചേഷ്ടധ്വേ ഇബ്രാഹീമ് ഏതാദൃശം കർമ്മ ന ചകാര| ");
INSERT INTO sanmal_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","യൂയം സ്വസ്വപിതുഃ കർമ്മാണി കുരുഥ തദാ തൈരുക്ത്തം ന വയം ജാരജാതാ അസ്മാകമ് ഏകഏവ പിതാസ്തി സ ഏവേശ്വരഃ ");
INSERT INTO sanmal_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","തതോ യീശുനാ കഥിതമ് ഈശ്വരോ യദി യുഷ്മാകം താതോഭവിഷ്യത് തർഹി യൂയം മയി പ്രേമാകരിഷ്യത യതോഹമ് ഈശ്വരാന്നിർഗത്യാഗതോസ്മി സ്വതോ നാഗതോഹം സ മാം പ്രാഹിണോത്| ");
INSERT INTO sanmal_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","യൂയം മമ വാക്യമിദം ന ബുധ്യധ്വേ കുതഃ? യതോ യൂയം മമോപദേശം സോഢും ന ശക്നുഥ| ");
INSERT INTO sanmal_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","യൂയം ശൈതാൻ പിതുഃ സന്താനാ ഏതസ്മാദ് യുഷ്മാകം പിതുരഭിലാഷം പൂരയഥ സ ആ പ്രഥമാത് നരഘാതീ തദന്തഃ സത്യത്വസ്യ ലേശോപി നാസ്തി കാരണാദതഃ സ സത്യതായാം നാതിഷ്ഠത് സ യദാ മൃഷാ കഥയതി തദാ നിജസ്വഭാവാനുസാരേണൈവ കഥയതി യതോ സ മൃഷാഭാഷീ മൃഷോത്പാദകശ്ച| ");
INSERT INTO sanmal_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","അഹം തഥ്യവാക്യം വദാമി കാരണാദസ്മാദ് യൂയം മാം ന പ്രതീഥ| ");
INSERT INTO sanmal_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","മയി പാപമസ്തീതി പ്രമാണം യുഷ്മാകം കോ ദാതും ശക്നോതി? യദ്യഹം തഥ്യവാക്യം വദാമി തർഹി കുതോ മാം ന പ്രതിഥ? ");
INSERT INTO sanmal_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","യഃ കശ്ചന ഈശ്വരീയോ ലോകഃ സ ഈശ്വരീയകഥായാം മനോ നിധത്തേ യൂയമ് ഈശ്വരീയലോകാ ന ഭവഥ തന്നിദാനാത് തത്ര ന മനാംസി നിധദ്വേ| ");
INSERT INTO sanmal_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","തദാ യിഹൂദീയാഃ പ്രത്യവാദിഷുഃ ത്വമേകഃ ശോമിരോണീയോ ഭൂതഗ്രസ്തശ്ച വയം കിമിദം ഭദ്രം നാവാദിഷ്മ? ");
INSERT INTO sanmal_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","തതോ യീശുഃ പ്രത്യവാദീത് നാഹം ഭൂതഗ്രസ്തഃ കിന്തു നിജതാതം സമ്മന്യേ തസ്മാദ് യൂയം മാമ് അപമന്യധ്വേ| ");
INSERT INTO sanmal_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","അഹം സ്വസുഖ്യാതിം ന ചേഷ്ടേ കിന്തു ചേഷ്ടിതാ വിചാരയിതാ ചാപര ഏക ആസ്തേ| ");
INSERT INTO sanmal_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","അഹം യുഷ്മഭ്യമ് അതീവ യഥാർഥം കഥയാമി യോ നരോ മദീയം വാചം മന്യതേ സ കദാചന നിധനം ന ദ്രക്ഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","യിഹൂദീയാസ്തമവദൻ ത്വം ഭൂതഗ്രസ്ത ഇതീദാനീമ് അവൈഷ്മ| ഇബ്രാഹീമ് ഭവിഷ്യദ്വാദിനഞ്ച സർവ്വേ മൃതാഃ കിന്തു ത്വം ഭാഷസേ യോ നരോ മമ ഭാരതീം ഗൃഹ്ലാതി സ ജാതു നിധാനാസ്വാദം ന ലപ്സ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","തർഹി ത്വം കിമ് അസ്മാകം പൂർവ്വപുരുഷാദ് ഇബ്രാഹീമോപി മഹാൻ? യസ്മാത് സോപി മൃതഃ ഭവിഷ്യദ്വാദിനോപി മൃതാഃ ത്വം സ്വം കം പുമാംസം മനുഷേ? ");
INSERT INTO sanmal_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","യീശുഃ പ്രത്യവോചദ് യദ്യഹം സ്വം സ്വയം സമ്മന്യേ തർഹി മമ തത് സമ്മനനം കിമപി ന കിന്തു മമ താതോ യം യൂയം സ്വീയമ് ഈശ്വരം ഭാഷധ്വേ സഏവ മാം സമ്മനുതേ| ");
INSERT INTO sanmal_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","യൂയം തം നാവഗച്ഛഥ കിന്ത്വഹം തമവഗച്ഛാമി തം നാവഗച്ഛാമീതി വാക്യം യദി വദാമി തർഹി യൂയമിവ മൃഷാഭാഷീ ഭവാമി കിന്ത്വഹം തമവഗച്ഛാമി തദാക്ഷാമപി ഗൃഹ്ലാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","യുഷ്മാകം പൂർവ്വപുരുഷ ഇബ്രാഹീമ് മമ സമയം ദ്രഷ്ടുമ് അതീവാവാഞ്ഛത് തന്നിരീക്ഷ്യാനന്ദച്ച| ");
INSERT INTO sanmal_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","തദാ യിഹൂദീയാ അപൃച്ഛൻ തവ വയഃ പഞ്ചാശദ്വത്സരാ ന ത്വം കിമ് ഇബ്രാഹീമമ് അദ്രാക്ഷീഃ? ");
INSERT INTO sanmal_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","യീശുഃ പ്രത്യവാദീദ് യുഷ്മാനഹം യഥാർഥതരം വദാമി ഇബ്രാഹീമോ ജന്മനഃ പൂർവ്വകാലമാരഭ്യാഹം വിദ്യേ| ");
INSERT INTO sanmal_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","തദാ തേ പാഷാണാൻ ഉത്തോല്യ തമാഹന്തുമ് ഉദയച്ഛൻ കിന്തു യീശു ർഗുപ്തോ മന്തിരാദ് ബഹിർഗത്യ തേഷാം മധ്യേന പ്രസ്ഥിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","തതഃ പരം യീശുർഗച്ഛൻ മാർഗമധ്യേ ജന്മാന്ധം നരമ് അപശ്യത്| ");
INSERT INTO sanmal_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","തതഃ ശിഷ്യാസ്തമ് അപൃച്ഛൻ ഹേ ഗുരോ നരോയം സ്വപാപേന വാ സ്വപിത്രാഃ പാപേനാന്ധോഽജായത? ");
INSERT INTO sanmal_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","തതഃ സ പ്രത്യുദിതവാൻ ഏതസ്യ വാസ്യ പിത്രോഃ പാപാദ് ഏതാദൃശോഭൂദ ഇതി നഹി കിന്ത്വനേന യഥേശ്വരസ്യ കർമ്മ പ്രകാശ്യതേ തദ്ധേതോരേവ| ");
INSERT INTO sanmal_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","ദിനേ തിഷ്ഠതി മത്പ്രേരയിതുഃ കർമ്മ മയാ കർത്തവ്യം യദാ കിമപി കർമ്മ ന ക്രിയതേ താദൃശീ നിശാഗച്ഛതി| ");
INSERT INTO sanmal_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","അഹം യാവത്കാലം ജഗതി തിഷ്ഠാമി താവത്കാലം ജഗതോ ജ്യോതിഃസ്വരൂപോസ്മി| ");
INSERT INTO sanmal_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ഇത്യുക്ത്താ ഭൂമൗ നിഷ്ഠീവം നിക്ഷിപ്യ തേന പങ്കം കൃതവാൻ ");
INSERT INTO sanmal_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","പശ്ചാത് തത്പങ്കേന തസ്യാന്ധസ്യ നേത്രേ പ്രലിപ്യ തമിത്യാദിശത് ഗത്വാ ശിലോഹേ ഽർഥാത് പ്രേരിതനാമ്നി സരസി സ്നാഹി| തതോന്ധോ ഗത്വാ തത്രാസ്നാത് തതഃ പ്രന്നചക്ഷു ർഭൂത്വാ വ്യാഘുട്യാഗാത്| ");
INSERT INTO sanmal_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","അപരഞ്ച സമീപവാസിനോ ലോകാ യേ ച തം പൂർവ്വമന്ധമ് അപശ്യൻ തേ ബക്ത്തുമ് ആരഭന്ത യോന്ധലോകോ വർത്മന്യുപവിശ്യാഭിക്ഷത സ ഏവായം ജനഃ കിം ന ഭവതി? ");
INSERT INTO sanmal_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","കേചിദവദൻ സ ഏവ കേചിദവോചൻ താദൃശോ ഭവതി കിന്തു സ സ്വയമബ്രവീത് സ ഏവാഹം ഭവാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","അതഏവ തേ ഽപൃച്ഛൻ ത്വം കഥം ദൃഷ്ടിം പാപ്തവാൻ? ");
INSERT INTO sanmal_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","തതഃ സോവദദ് യീശനാമക ഏകോ ജനോ മമ നയനേ പങ്കേന പ്രലിപ്യ ഇത്യാജ്ഞാപയത് ശിലോഹകാസാരം ഗത്വാ തത്ര സ്നാഹി| തതസ്തത്ര ഗത്വാ മയി സ്നാതേ ദൃഷ്ടിമഹം ലബ്ധവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","തദാ തേ ഽവദൻ സ പുമാൻ കുത്ര? തേനോക്ത്തം നാഹം ജാനാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","അപരം തസ്മിൻ പൂർവ്വാന്ധേ ജനേ ഫിരൂശിനാം നികടമ് ആനീതേ സതി ഫിരൂശിനോപി തമപൃച്ഛൻ കഥം ദൃഷ്ടിം പ്രാപ്തോസി? ");
INSERT INTO sanmal_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","തതഃ സ കഥിതവാൻ സ പങ്കേന മമ നേത്രേ ഽലിമ്പത് പശ്ചാദ് സ്നാത്വാ ദൃഷ്ടിമലഭേ| ");
INSERT INTO sanmal_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","കിന്തു യീശു ർവിശ്രാമവാരേ കർദ്ദമം കൃത്വാ തസ്യ നയനേ പ്രസന്നേഽകരോദ് ഇതികാരണാത് കതിപയഫിരൂശിനോഽവദൻ ");
INSERT INTO sanmal_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","സ പുമാൻ ഈശ്വരാന്ന യതഃ സ വിശ്രാമവാരം ന മന്യതേ| തതോന്യേ കേചിത് പ്രത്യവദൻ പാപീ പുമാൻ കിമ് ഏതാദൃശമ് ആശ്ചര്യ്യം കർമ്മ കർത്തും ശക്നോതി? ");
INSERT INTO sanmal_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ഇത്ഥം തേഷാം പരസ്പരം ഭിന്നവാക്യത്വമ് അഭവത്| പശ്ചാത് തേ പുനരപി തം പൂർവ്വാന്ധം മാനുഷമ് അപ്രാക്ഷുഃ യോ ജനസ്തവ ചക്ഷുഷീ പ്രസന്നേ കൃതവാൻ തസ്മിൻ ത്വം കിം വദസി? സ ഉക്ത്തവാൻ സ ഭവിശദ്വാദീ| ");
INSERT INTO sanmal_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","സ ദൃഷ്ടിമ് ആപ്തവാൻ ഇതി യിഹൂദീയാസ്തസ്യ ദൃഷ്ടിം പ്രാപ്തസ്യ ജനസ്യ പിത്രോ ർമുഖാദ് അശ്രുത്വാ ന പ്രത്യയൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","അതഏവ തേ താവപൃച്ഛൻ യുവയോ ര്യം പുത്രം ജന്മാന്ധം വദഥഃ സ കിമയം? തർഹീദാനീം കഥം ദ്രഷ്ടും ശക്നോതി? ");
INSERT INTO sanmal_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","തതസ്തസ്യ പിതരൗ പ്രത്യവോചതാമ് അയമ് ആവയോഃ പുത്ര ആ ജനേരന്ധശ്ച തദപ്യാവാം ജാനീവഃ ");
INSERT INTO sanmal_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","കിന്ത്വധുനാ കഥം ദൃഷ്ടിം പ്രാപ്തവാൻ തദാവാം ൻ ജാനീവഃ കോസ്യ ചക്ഷുഷീ പ്രസന്നേ കൃതവാൻ തദപി ന ജാനീവ ഏഷ വയഃപ്രാപ്ത ഏനം പൃച്ഛത സ്വകഥാം സ്വയം വക്ഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","യിഹൂദീയാനാം ഭയാത് തസ്യ പിതരൗ വാക്യമിദമ് അവദതാം യതഃ കോപി മനുഷ്യോ യദി യീശുമ് അഭിഷിക്തം വദതി തർഹി സ ഭജനഗൃഹാദ് ദൂരീകാരിഷ്യതേ യിഹൂദീയാ ഇതി മന്ത്രണാമ് അകുർവ്വൻ ");
INSERT INTO sanmal_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","അതസ്തസ്യ പിതരൗ വ്യാഹരതാമ് ഏഷ വയഃപ്രാപ്ത ഏനം പൃച്ഛത| ");
INSERT INTO sanmal_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","തദാ തേ പുനശ്ച തം പൂർവ്വാന്ധമ് ആഹൂയ വ്യാഹരൻ ഈശ്വരസ്യ ഗുണാൻ വദ ഏഷ മനുഷ്യഃ പാപീതി വയം ജാനീമഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","തദാ സ ഉക്ത്തവാൻ സ പാപീ ന വേതി നാഹം ജാനേ പൂർവാമന്ധ ആസമഹമ് അധുനാ പശ്യാമീതി മാത്രം ജാനാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","തേ പുനരപൃച്ഛൻ സ ത്വാം പ്രതി കിമകരോത്? കഥം നേത്രേ പ്രസന്നേ ഽകരോത്? ");
INSERT INTO sanmal_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","തതഃ സോവാദീദ് ഏകകൃത്വോകഥയം യൂയം ന ശൃണുഥ തർഹി കുതഃ പുനഃ ശ്രോതുമ് ഇച്ഛഥ? യൂയമപി കിം തസ്യ ശിഷ്യാ ഭവിതുമ് ഇച്ഛഥ? ");
INSERT INTO sanmal_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","തദാ തേ തം തിരസ്കൃത്യ വ്യാഹരൻ ത്വം തസ്യ ശിഷ്യോ വയം മൂസാഃ ശിഷ്യാഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","മൂസാവക്ത്രേണേശ്വരോ ജഗാദ തജ്ജാനീമഃ കിന്ത്വേഷ കുത്രത്യലോക ഇതി ന ജാനീമഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","സോവദദ് ഏഷ മമ ലോചനേ പ്രസന്നേ ഽകരോത് തഥാപി കുത്രത്യലോക ഇതി യൂയം ന ജാനീഥ ഏതദ് ആശ്ചര്യ്യം ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ഈശ്വരഃ പാപിനാം കഥാം ന ശൃണോതി കിന്തു യോ ജനസ്തസ്മിൻ ഭക്തിം കൃത്വാ തദിഷ്ടക്രിയാം കരോതി തസ്യൈവ കഥാം ശൃണോതി ഏതദ് വയം ജാനീമഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","കോപി മനുഷ്യോ ജന്മാന്ധായ ചക്ഷുഷീ അദദാത് ജഗദാരമ്ഭാദ് ഏതാദൃശീം കഥാം കോപി കദാപി നാശൃണോത്| ");
INSERT INTO sanmal_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","അസ്മാദ് ഏഷ മനുഷ്യോ യദീശ്വരാന്നാജായത തർഹി കിഞ്ചിദപീദൃശം കർമ്മ കർത്തും നാശക്നോത്| ");
INSERT INTO sanmal_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","തേ വ്യാഹരൻ ത്വം പാപാദ് അജായഥാഃ കിമസ്മാൻ ത്വം ശിക്ഷയസി? പശ്ചാത്തേ തം ബഹിരകുർവ്വൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","തദനന്തരം യിഹൂദീയൈഃ സ ബഹിരക്രിയത യീശുരിതി വാർത്താം ശ്രുത്വാ തം സാക്ഷാത് പ്രാപ്യ പൃഷ്ടവാൻ ഈശ്വരസ്യ പുത്രേ ത്വം വിശ്വസിഷി? ");
INSERT INTO sanmal_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","തദാ സ പ്രത്യവോചത് ഹേ പ്രഭോ സ കോ യത് തസ്മിന്നഹം വിശ്വസിമി? ");
INSERT INTO sanmal_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","തതോ യീശുഃ കഥിതവാൻ ത്വം തം ദൃഷ്ടവാൻ ത്വയാ സാകം യഃ കഥം കഥയതി സഏവ സഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","തദാ ഹേ പ്രഭോ വിശ്വസിമീത്യുക്ത്വാ സ തം പ്രണാമത്| ");
INSERT INTO sanmal_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","പശ്ചാദ് യീശുഃ കഥിതവാൻ നയനഹീനാ നയനാനി പ്രാപ്നുവന്തി നയനവന്തശ്ചാന്ധാ ഭവന്തീത്യഭിപ്രായേണ ജഗദാഹമ് ആഗച്ഛമ്| ");
INSERT INTO sanmal_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ഏതത് ശ്രുത്വാ നികടസ്ഥാഃ കതിപയാഃ ഫിരൂശിനോ വ്യാഹരൻ വയമപി കിമന്ധാഃ? ");
INSERT INTO sanmal_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","തദാ യീശുരവാദീദ് യദ്യന്ധാ അഭവത തർഹി പാപാനി നാതിഷ്ഠൻ കിന്തു പശ്യാമീതി വാക്യവദനാദ് യുഷ്മാകം പാപാനി തിഷ്ഠന്തി| ");
INSERT INTO sanmal_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","അഹം യുഷ്മാനതിയഥാർഥം വദാമി, യോ ജനോ ദ്വാരേണ ന പ്രവിശ്യ കേനാപ്യന്യേന മേഷഗൃഹം പ്രവിശതി സ ഏവ സ്തേനോ ദസ്യുശ്ച| ");
INSERT INTO sanmal_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","യോ ദ്വാരേണ പ്രവിശതി സ ഏവ മേഷപാലകഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ദൗവാരികസ്തസ്മൈ ദ്വാരം മോചയതി മേഷഗണശ്ച തസ്യ വാക്യം ശൃണോതി സ നിജാൻ മേഷാൻ സ്വസ്വനാമ്നാഹൂയ ബഹിഃ കൃത്വാ നയതി| ");
INSERT INTO sanmal_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","തഥാ നിജാൻ മേഷാൻ ബഹിഃ കൃത്വാ സ്വയം തേഷാമ് അഗ്രേ ഗച്ഛതി, തതോ മേഷാസ്തസ്യ ശബ്ദം ബുധ്യന്തേ, തസ്മാത് തസ്യ പശ്ചാദ് വ്രജന്തി| ");
INSERT INTO sanmal_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","കിന്തു പരസ്യ ശബ്ദം ന ബുധ്യന്തേ തസ്മാത് തസ്യ പശ്ചാദ് വ്രജിഷ്യന്തി വരം തസ്യ സമീപാത് പലായിഷ്യന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","യീശുസ്തേഭ്യ ഇമാം ദൃഷ്ടാന്തകഥാമ് അകഥയത് കിന്തു തേന കഥിതകഥായാസ്താത്പര്യ്യം തേ നാബുധ്യന്ത| ");
INSERT INTO sanmal_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","അതോ യീശുഃ പുനരകഥയത്, യുഷ്മാനാഹം യഥാർഥതരം വ്യാഹരാമി, മേഷഗൃഹസ്യ ദ്വാരമ് അഹമേവ| ");
INSERT INTO sanmal_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","മയാ ന പ്രവിശ്യ യ ആഗച്ഛൻ തേ സ്തേനാ ദസ്യവശ്ച കിന്തു മേഷാസ്തേഷാം കഥാ നാശൃണ്വൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","അഹമേവ ദ്വാരസ്വരൂപഃ, മയാ യഃ കശ്ചിത പ്രവിശതി സ രക്ഷാം പ്രാപ്സ്യതി തഥാ ബഹിരന്തശ്ച ഗമനാഗമനേ കൃത്വാ ചരണസ്ഥാനം പ്രാപ്സ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","യോ ജനസ്തേനഃ സ കേവലം സ്തൈന്യബധവിനാശാൻ കർത്തുമേവ സമായാതി കിന്ത്വഹമ് ആയു ർദാതുമ് അർഥാത് ബാഹൂല്യേന തദേവ ദാതുമ് ആഗച്ഛമ്| ");
INSERT INTO sanmal_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","അഹമേവ സത്യമേഷപാലകോ യസ്തു സത്യോ മേഷപാലകഃ സ മേഷാർഥം പ്രാണത്യാഗം കരോതി; ");
INSERT INTO sanmal_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","കിന്തു യോ ജനോ മേഷപാലകോ ന, അർഥാദ് യസ്യ മേഷാ നിജാ ന ഭവന്തി, യ ഏതാദൃശോ വൈതനികഃ സ വൃകമ് ആഗച്ഛന്തം ദൃഷ്ട്വാ മേജവ്രജം വിഹായ പലായതേ, തസ്മാദ് വൃകസ്തം വ്രജം ധൃത്വാ വികിരതി| ");
INSERT INTO sanmal_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","വൈതനികഃ പലായതേ യതഃ സ വേതനാർഥീ മേഷാർഥം ന ചിന്തയതി| ");
INSERT INTO sanmal_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","അഹമേവ സത്യോ മേഷപാലകഃ, പിതാ മാം യഥാ ജാനാതി, അഹഞ്ച യഥാ പിതരം ജാനാമി, ");
INSERT INTO sanmal_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","തഥാ നിജാൻ മേഷാനപി ജാനാമി, മേഷാശ്ച മാം ജാനാന്തി, അഹഞ്ച മേഷാർഥം പ്രാണത്യാഗം കരോമി| ");
INSERT INTO sanmal_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","അപരഞ്ച ഏതദ് ഗൃഹീയ മേഷേഭ്യോ ഭിന്നാ അപി മേഷാ മമ സന്തി തേ സകലാ ആനയിതവ്യാഃ; തേ മമ ശബ്ദം ശ്രോഷ്യന്തി തത ഏകോ വ്രജ ഏകോ രക്ഷകോ ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","പ്രാണാനഹം ത്യക്ത്വാ പുനഃ പ്രാണാൻ ഗ്രഹീഷ്യാമി, തസ്മാത് പിതാ മയി സ്നേഹം കരോതി| ");
INSERT INTO sanmal_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","കശ്ചിജ്ജനോ മമ പ്രാണാൻ ഹന്തും ന ശക്നോതി കിന്തു സ്വയം താൻ സമർപയാമി താൻ സമർപയിതും പുനർഗ്രഹീതുഞ്ച മമ ശക്തിരാസ്തേ ഭാരമിമം സ്വപിതുഃ സകാശാത് പ്രാപ്തോഹമ്| ");
INSERT INTO sanmal_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","അസ്മാദുപദേശാത് പുനശ്ച യിഹൂദീയാനാം മധ്യേ ഭിന്നവാക്യതാ ജാതാ| ");
INSERT INTO sanmal_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","തതോ ബഹവോ വ്യാഹരൻ ഏഷ ഭൂതഗ്രസ്ത ഉന്മത്തശ്ച, കുത ഏതസ്യ കഥാം ശൃണുഥ? ");
INSERT INTO sanmal_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","കേചിദ് അവദൻ ഏതസ്യ കഥാ ഭൂതഗ്രസ്തസ്യ കഥാവന്ന ഭവന്തി, ഭൂതഃ കിമ് അന്ധായ ചക്ഷുഷീ ദാതും ശക്നോതി? ");
INSERT INTO sanmal_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","ശീതകാലേ യിരൂശാലമി മന്ദിരോത്സർഗപർവ്വണ്യുപസ്ഥിതേ ");
INSERT INTO sanmal_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","യീശുഃ സുലേമാനോ നിഃസാരേണ ഗമനാഗമനേ കരോതി, ");
INSERT INTO sanmal_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ഏതസ്മിൻ സമയേ യിഹൂദീയാസ്തം വേഷ്ടയിത്വാ വ്യാഹരൻ കതി കാലാൻ അസ്മാകം വിചികിത്സാം സ്ഥാപയിഷ്യാമി? യദ്യഭിഷിക്തോ ഭവതി തർഹി തത് സ്പഷ്ടം വദ| ");
INSERT INTO sanmal_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","തദാ യീശുഃ പ്രത്യവദദ് അഹമ് അചകഥം കിന്തു യൂയം ന പ്രതീഥ, നിജപിതു ർനാമ്നാ യാം യാം ക്രിയാം കരോമി സാ ക്രിയൈവ മമ സാക്ഷിസ്വരൂപാ| ");
INSERT INTO sanmal_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","കിന്ത്വഹം പൂർവ്വമകഥയം യൂയം മമ മേഷാ ന ഭവഥ, കാരണാദസ്മാൻ ന വിശ്വസിഥ| ");
INSERT INTO sanmal_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","മമ മേഷാ മമ ശബ്ദം ശൃണ്വന്തി താനഹം ജാനാമി തേ ച മമ പശ്ചാദ് ഗച്ഛന്തി| ");
INSERT INTO sanmal_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","അഹം തേഭ്യോഽനന്തായു ർദദാമി, തേ കദാപി ന നംക്ഷ്യന്തി കോപി മമ കരാത് താൻ ഹർത്തും ന ശക്ഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","യോ മമ പിതാ താൻ മഹ്യം ദത്തവാൻ സ സർവ്വസ്മാത് മഹാൻ, കോപി മമ പിതുഃ കരാത് താൻ ഹർത്തും ന ശക്ഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","അഹം പിതാ ച ദ്വയോരേകത്വമ്| ");
INSERT INTO sanmal_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","തതോ യിഹൂദീയാഃ പുനരപി തം ഹന്തും പാഷാണാൻ ഉദതോലയൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","യീശുഃ കഥിതവാൻ പിതുഃ സകാശാദ് ബഹൂന്യുത്തമകർമ്മാണി യുഷ്മാകം പ്രാകാശയം തേഷാം കസ്യ കർമ്മണഃ കാരണാൻ മാം പാഷാണൈരാഹന്തുമ് ഉദ്യതാഃ സ്ഥ? ");
INSERT INTO sanmal_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","യിഹൂദീയാഃ പ്രത്യവദൻ പ്രശസ്തകർമ്മഹേതോ ർന കിന്തു ത്വം മാനുഷഃ സ്വമീശ്വരമ് ഉക്ത്വേശ്വരം നിന്ദസി കാരണാദസ്മാത് ത്വാം പാഷാണൈർഹന്മഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","തദാ യീശുഃ പ്രത്യുക്തവാൻ മയാ കഥിതം യൂയമ് ഈശ്വരാ ഏതദ്വചനം യുഷ്മാകം ശാസ്ത്രേ ലിഖിതം നാസ്തി കിം? ");
INSERT INTO sanmal_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","തസ്മാദ് യേഷാമ് ഉദ്ദേശേ ഈശ്വരസ്യ കഥാ കഥിതാ തേ യദീശ്വരഗണാ ഉച്യന്തേ ധർമ്മഗ്രന്ഥസ്യാപ്യന്യഥാ ഭവിതും ന ശക്യം, ");
INSERT INTO sanmal_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","തർഹ്യാഹമ് ഈശ്വരസ്യ പുത്ര ഇതി വാക്യസ്യ കഥനാത് യൂയം പിത്രാഭിഷിക്തം ജഗതി പ്രേരിതഞ്ച പുമാംസം കഥമ് ഈശ്വരനിന്ദകം വാദയ? ");
INSERT INTO sanmal_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","യദ്യഹം പിതുഃ കർമ്മ ന കരോമി തർഹി മാം ന പ്രതീത; ");
INSERT INTO sanmal_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","കിന്തു യദി കരോമി തർഹി മയി യുഷ്മാഭിഃ പ്രത്യയേ ന കൃതേഽപി കാര്യ്യേ പ്രത്യയഃ ക്രിയതാം, തതോ മയി പിതാസ്തീതി പിതര്യ്യഹമ് അസ്മീതി ച ക്ഷാത്വാ വിശ്വസിഷ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","തദാ തേ പുനരപി തം ധർത്തുമ് അചേഷ്ടന്ത കിന്തു സ തേഷാം കരേഭ്യോ നിസ്തീര്യ്യ ");
INSERT INTO sanmal_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","പുന ര്യർദ്ദൻ അദ്യാസ്തടേ യത്ര പുർവ്വം യോഹൻ അമജ്ജയത് തത്രാഗത്യ ന്യവസത്| ");
INSERT INTO sanmal_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","തതോ ബഹവോ ലോകാസ്തത്സമീപമ് ആഗത്യ വ്യാഹരൻ യോഹൻ കിമപ്യാശ്ചര്യ്യം കർമ്മ നാകരോത് കിന്ത്വസ്മിൻ മനുഷ്യേ യാ യഃ കഥാ അകഥയത് താഃ സർവ്വാഃ സത്യാഃ; ");
INSERT INTO sanmal_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","തത്ര ച ബഹവോ ലോകാസ്തസ്മിൻ വ്യശ്വസൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","അനന്തരം മരിയമ് തസ്യാ ഭഗിനീ മർഥാ ച യസ്മിൻ വൈഥനീയാഗ്രാമേ വസതസ്തസ്മിൻ ഗ്രാമേ ഇലിയാസർ നാമാ പീഡിത ഏക ആസീത്| ");
INSERT INTO sanmal_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","യാ മരിയമ് പ്രഭും സുഗന്ധിതേലൈന മർദ്ദയിത്വാ സ്വകേശൈസ്തസ്യ ചരണൗ സമമാർജത് തസ്യാ ഭ്രാതാ സ ഇലിയാസർ രോഗീ| ");
INSERT INTO sanmal_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","അപരഞ്ച ഹേ പ്രഭോ ഭവാൻ യസ്മിൻ പ്രീയതേ സ ഏവ പീഡിതോസ്തീതി കഥാം കഥയിത്വാ തസ്യ ഭഗിന്യൗ പ്രേഷിതവത്യൗ| ");
INSERT INTO sanmal_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","തദാ യീശുരിമാം വാർത്താം ശ്രുത്വാകഥയത പീഡേയം മരണാർഥം ന കിന്ത്വീശ്വരസ്യ മഹിമാർഥമ് ഈശ്വരപുത്രസ്യ മഹിമപ്രകാശാർഥഞ്ച ജാതാ| ");
INSERT INTO sanmal_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","യീശു ര്യദ്യപിമർഥായാം തദ്ഭഗിന്യാമ് ഇലിയാസരി ചാപ്രീയത, ");
INSERT INTO sanmal_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","തഥാപി ഇലിയാസരഃ പീഡായാഃ കഥം ശ്രുത്വാ യത്ര ആസീത് തത്രൈവ ദിനദ്വയമതിഷ്ഠത്| ");
INSERT INTO sanmal_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","തതഃ പരമ് സ ശിഷ്യാനകഥയദ് വയം പുന ര്യിഹൂദീയപ്രദേശം യാമഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","തതസ്തേ പ്രത്യവദൻ, ഹേ ഗുരോ സ്വൽപദിനാനി ഗതാനി യിഹൂദീയാസ്ത്വാം പാഷാണൈ ർഹന്തുമ് ഉദ്യതാസ്തഥാപി കിം പുനസ്തത്ര യാസ്യസി? ");
INSERT INTO sanmal_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","യീശുഃ പ്രത്യവദത്, ഏകസ്മിൻ ദിനേ കിം ദ്വാദശഘടികാ ന ഭവന്തി? കോപി ദിവാ ഗച്ഛൻ ന സ്ഖലതി യതഃ സ ഏതജ്ജഗതോ ദീപ്തിം പ്രാപ്നോതി| ");
INSERT INTO sanmal_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","കിന്തു രാത്രൗ ഗച്ഛൻ സ്ഖലതി യതോ ഹേതോസ്തത്ര ദീപ്തി ർനാസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ഇമാം കഥാം കഥയിത്വാ സ താനവദദ്, അസ്മാകം ബന്ധുഃ ഇലിയാസർ നിദ്രിതോഭൂദ് ഇദാനീം തം നിദ്രാതോ ജാഗരയിതും ഗച്ഛാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","യീശു ർമൃതൗ കഥാമിമാം കഥിതവാൻ കിന്തു വിശ്രാമാർഥം നിദ്രായാം കഥിതവാൻ ഇതി ജ്ഞാത്വാ ശിഷ്യാ അകഥയൻ, ");
INSERT INTO sanmal_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ഹേ ഗുരോ സ യദി നിദ്രാതി തർഹി ഭദ്രമേവ| ");
INSERT INTO sanmal_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","തദാ യീശുഃ സ്പഷ്ടം താൻ വ്യാഹരത്, ഇലിയാസർ അമ്രിയത; ");
INSERT INTO sanmal_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","കിന്തു യൂയം യഥാ പ്രതീഥ തദർഥമഹം തത്ര ന സ്ഥിതവാൻ ഇത്യസ്മാദ് യുഷ്മന്നിമിത്തമ് ആഹ്ലാദിതോഹം, തഥാപി തസ്യ സമീപേ യാമ| ");
INSERT INTO sanmal_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","തദാ ഥോമാ യം ദിദുമം വദന്തി സ സങ്ഗിനഃ ശിഷ്യാൻ അവദദ് വയമപി ഗത്വാ തേന സാർദ്ധം മ്രിയാമഹൈ| ");
INSERT INTO sanmal_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","യീശുസ്തത്രോപസ്ഥായ ഇലിയാസരഃ ശ്മശാനേ സ്ഥാപനാത് ചത്വാരി ദിനാനി ഗതാനീതി വാർത്താം ശ്രുതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","വൈഥനീയാ യിരൂശാലമഃ സമീപസ്ഥാ ക്രോശൈകമാത്രാന്തരിതാ; ");
INSERT INTO sanmal_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","തസ്മാദ് ബഹവോ യിഹൂദീയാ മർഥാം മരിയമഞ്ച ഭ്യാതൃശോകാപന്നാം സാന്ത്വയിതും തയോഃ സമീപമ് ആഗച്ഛൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","മർഥാ യീശോരാഗമനവാർതാം ശ്രുത്വൈവ തം സാക്ഷാദ് അകരോത് കിന്തു മരിയമ് ഗേഹ ഉപവിശ്യ സ്ഥിതാ| ");
INSERT INTO sanmal_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","തദാ മർഥാ യീശുമവാദത്, ഹേ പ്രഭോ യദി ഭവാൻ അത്രാസ്ഥാസ്യത് തർഹി മമ ഭ്രാതാ നാമരിഷ്യത്| ");
INSERT INTO sanmal_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","കിന്ത്വിദാനീമപി യദ് ഈശ്വരേ പ്രാർഥയിഷ്യതേ ഈശ്വരസ്തദ് ദാസ്യതീതി ജാനേഽഹം| ");
INSERT INTO sanmal_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","യീശുരവാദീത് തവ ഭ്രാതാ സമുത്ഥാസ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","മർഥാ വ്യാഹരത് ശേഷദിവസേ സ ഉത്ഥാനസമയേ പ്രോത്ഥാസ്യതീതി ജാനേഽഹം| ");
INSERT INTO sanmal_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","തദാ യീശുഃ കഥിതവാൻ അഹമേവ ഉത്ഥാപയിതാ ജീവയിതാ ച യഃ കശ്ചന മയി വിശ്വസിതി സ മൃത്വാപി ജീവിഷ്യതി; ");
INSERT INTO sanmal_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","യഃ കശ്ചന ച ജീവൻ മയി വിശ്വസിതി സ കദാപി ന മരിഷ്യതി, അസ്യാം കഥായാം കിം വിശ്വസിഷി? ");
INSERT INTO sanmal_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","സാവദത് പ്രഭോ യസ്യാവതരണാപേക്ഷാസ്തി ഭവാൻ സഏവാഭിഷിക്ത്ത ഈശ്വരപുത്ര ഇതി വിശ്വസിമി| ");
INSERT INTO sanmal_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ഇതി കഥാം കഥയിത്വാ സാ ഗത്വാ സ്വാം ഭഗിനീം മരിയമം ഗുപ്തമാഹൂയ വ്യാഹരത് ഗുരുരുപതിഷ്ഠതി ത്വാമാഹൂയതി ച| ");
INSERT INTO sanmal_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","കഥാമിമാം ശ്രുത്വാ സാ തൂർണമ് ഉത്ഥായ തസ്യ സമീപമ് അഗച്ഛത്| ");
INSERT INTO sanmal_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","യീശു ർഗ്രാമമധ്യം ന പ്രവിശ്യ യത്ര മർഥാ തം സാക്ഷാദ് അകരോത് തത്ര സ്ഥിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","യേ യിഹൂദീയാ മരിയമാ സാകം ഗൃഹേ തിഷ്ഠന്തസ്താമ് അസാന്ത്വയന തേ താം ക്ഷിപ്രമ് ഉത്ഥായ ഗച്ഛന്തിം വിലോക്യ വ്യാഹരൻ, സ ശ്മശാനേ രോദിതും യാതി, ഇത്യുക്ത്വാ തേ തസ്യാഃ പശ്ചാദ് അഗച്ഛൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","യത്ര യീശുരതിഷ്ഠത് തത്ര മരിയമ് ഉപസ്ഥായ തം ദൃഷ്ട്വാ തസ്യ ചരണയോഃ പതിത്വാ വ്യാഹരത് ഹേ പ്രഭോ യദി ഭവാൻ അത്രാസ്ഥാസ്യത് തർഹി മമ ഭ്രാതാ നാമരിഷ്യത്| ");
INSERT INTO sanmal_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","യീശുസ്താം തസ്യാഃ സങ്ഗിനോ യിഹൂദീയാംശ്ച രുദതോ വിലോക്യ ശോകാർത്തഃ സൻ ദീർഘം നിശ്വസ്യ കഥിതവാൻ തം കുത്രാസ്ഥാപയത? ");
INSERT INTO sanmal_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","തേ വ്യാഹരൻ, ഹേ പ്രഭോ ഭവാൻ ആഗത്യ പശ്യതു| ");
INSERT INTO sanmal_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","യീശുനാ ക്രന്ദിതം| ");
INSERT INTO sanmal_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","അതഏവ യിഹൂദീയാ അവദൻ, പശ്യതായം തസ്മിൻ കിദൃഗ് അപ്രിയത| ");
INSERT INTO sanmal_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","തേഷാം കേചിദ് അവദൻ യോന്ധായ ചക്ഷുഷീ ദത്തവാൻ സ കിമ് അസ്യ മൃത്യും നിവാരയിതും നാശക്നോത്? ");
INSERT INTO sanmal_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","തതോ യീശുഃ പുനരന്തർദീർഘം നിശ്വസ്യ ശ്മശാനാന്തികമ് അഗച്ഛത്| തത് ശ്മശാനമ് ഏകം ഗഹ്വരം തന്മുഖേ പാഷാണ ഏക ആസീത്| ");
INSERT INTO sanmal_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","തദാ യീശുരവദദ് ഏനം പാഷാണമ് അപസാരയത, തതഃ പ്രമീതസ്യ ഭഗിനീ മർഥാവദത് പ്രഭോ, അധുനാ തത്ര ദുർഗന്ധോ ജാതഃ, യതോദ്യ ചത്വാരി ദിനാനി ശ്മശാനേ സ തിഷ്ഠതി| ");
INSERT INTO sanmal_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","തദാ യീശുരവാദീത്, യദി വിശ്വസിഷി തർഹീശ്വരസ്യ മഹിമപ്രകാശം ദ്രക്ഷ്യസി കഥാമിമാം കിം തുഭ്യം നാകഥയം? ");
INSERT INTO sanmal_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","തദാ മൃതസ്യ ശ്മശാനാത് പാഷാണോഽപസാരിതേ യീശുരൂർദ്വ്വം പശ്യൻ അകഥയത്, ഹേ പിത ർമമ നേവേസനമ് അശൃണോഃ കാരണാദസ്മാത് ത്വാം ധന്യം വദാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ത്വം സതതം ശൃണോഷി തദപ്യഹം ജാനാമി, കിന്തു ത്വം മാം യത് പ്രൈരയസ്തദ് യഥാസ്മിൻ സ്ഥാനേ സ്ഥിതാ ലോകാ വിശ്വസന്തി തദർഥമ് ഇദം വാക്യം വദാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ഇമാം കഥാം കഥയിത്വാ സ പ്രോച്ചൈരാഹ്വയത്, ഹേ ഇലിയാസർ ബഹിരാഗച്ഛ| ");
INSERT INTO sanmal_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","തതഃ സ പ്രമീതഃ ശ്മശാനവസ്ത്രൈ ർബദ്ധഹസ്തപാദോ ഗാത്രമാർജനവാസസാ ബദ്ധമുഖശ്ച ബഹിരാഗച്ഛത്| യീശുരുദിതവാൻ ബന്ധനാനി മോചയിത്വാ ത്യജതൈനം| ");
INSERT INTO sanmal_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","മരിയമഃ സമീപമ് ആഗതാ യേ യിഹൂദീയലോകാസ്തദാ യീശോരേതത് കർമ്മാപശ്യൻ തേഷാം ബഹവോ വ്യശ്വസൻ, ");
INSERT INTO sanmal_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","കിന്തു കേചിദന്യേ ഫിരൂശിനാം സമീപം ഗത്വാ യീശോരേതസ്യ കർമ്മണോ വാർത്താമ് അവദൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","തതഃ പരം പ്രധാനയാജകാഃ ഫിരൂശിനാശ്ച സഭാം കൃത്വാ വ്യാഹരൻ വയം കിം കുർമ്മഃ? ഏഷ മാനവോ ബഹൂന്യാശ്ചര്യ്യകർമ്മാണി കരോതി| ");
INSERT INTO sanmal_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","യദീദൃശം കർമ്മ കർത്തും ന വാരയാമസ്തർഹി സർവ്വേ ലോകാസ്തസ്മിൻ വിശ്വസിഷ്യന്തി രോമിലോകാശ്ചാഗത്യാസ്മാകമ് അനയാ രാജധാന്യാ സാർദ്ധം രാജ്യമ് ആഛേത്സ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","തദാ തേഷാം കിയഫാനാമാ യസ്തസ്മിൻ വത്സരേ മഹായാജകപദേ ന്യയുജ്യത സ പ്രത്യവദദ് യൂയം കിമപി ന ജാനീഥ; ");
INSERT INTO sanmal_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","സമഗ്രദേശസ്യ വിനാശതോപി സർവ്വലോകാർഥമ് ഏകസ്യ ജനസ്യ മരണമ് അസ്മാകം മങ്ഗലഹേതുകമ് ഏതസ്യ വിവേചനാമപി ന കുരുഥ| ");
INSERT INTO sanmal_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","ഏതാം കഥാം സ നിജബുദ്ധ്യാ വ്യാഹരദ് ഇതി ന, ");
INSERT INTO sanmal_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","കിന്തു യീശൂസ്തദ്ദേശീയാനാം കാരണാത് പ്രാണാൻ ത്യക്ഷ്യതി, ദിശി ദിശി വികീർണാൻ ഈശ്വരസ്യ സന്താനാൻ സംഗൃഹ്യൈകജാതിം കരിഷ്യതി ച, തസ്മിൻ വത്സരേ കിയഫാ മഹായാജകത്വപദേ നിയുക്തഃ സൻ ഇദം ഭവിഷ്യദ്വാക്യം കഥിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","തദ്ദിനമാരഭ്യ തേ കഥം തം ഹന്തും ശക്നുവന്തീതി മന്ത്രണാം കർത്തും പ്രാരേഭിരേ| ");
INSERT INTO sanmal_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","അതഏവ യിഹൂദീയാനാം മധ്യേ യീശുഃ സപ്രകാശം ഗമനാഗമനേ അകൃത്വാ തസ്മാദ് ഗത്വാ പ്രാന്തരസ്യ സമീപസ്ഥായിപ്രദേശസ്യേഫ്രായിമ് നാമ്നി നഗരേ ശിഷ്യൈഃ സാകം കാലം യാപയിതും പ്രാരേഭേ| ");
INSERT INTO sanmal_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","അനന്തരം യിഹൂദീയാനാം നിസ്താരോത്സവേ നികടവർത്തിനി സതി തദുത്സവാത് പൂർവ്വം സ്വാൻ ശുചീൻ കർത്തും ബഹവോ ജനാ ഗ്രാമേഭ്യോ യിരൂശാലമ് നഗരമ് ആഗച്ഛൻ, ");
INSERT INTO sanmal_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","യീശോരന്വേഷണം കൃത്വാ മന്ദിരേ ദണ്ഡായമാനാഃ സന്തഃ പരസ്പരം വ്യാഹരൻ, യുഷ്മാകം കീദൃശോ ബോധോ ജായതേ? സ കിമ് ഉത്സവേഽസ്മിൻ അത്രാഗമിഷ്യതി? ");
INSERT INTO sanmal_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","സ ച കുത്രാസ്തി യദ്യേതത് കശ്ചിദ് വേത്തി തർഹി ദർശയതു പ്രധാനയാജകാഃ ഫിരൂശിനശ്ച തം ധർത്തും പൂർവ്വമ് ഇമാമ് ആജ്ഞാം പ്രാചാരയൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","നിസ്താരോത്സവാത് പൂർവ്വം ദിനഷട്കേ സ്ഥിതേ യീശു ര്യം പ്രമീതമ് ഇലിയാസരം ശ്മശാനാദ് ഉദസ്ഥാപരത് തസ്യ നിവാസസ്ഥാനം ബൈഥനിയാഗ്രാമമ് ആഗച്ഛത്| ");
INSERT INTO sanmal_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","തത്ര തദർഥം രജന്യാം ഭോജ്യേ കൃതേ മർഥാ പര്യ്യവേഷയദ് ഇലിയാസർ ച തസ്യ സങ്ഗിഭിഃ സാർദ്ധം ഭോജനാസന ഉപാവിശത്| ");
INSERT INTO sanmal_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","തദാ മരിയമ് അർദ്ധസേടകം ബഹുമൂല്യം ജടാമാംസീയം തൈലമ് ആനീയ യീശോശ്ചരണയോ ർമർദ്ദയിത്വാ നിജകേശ ർമാർഷ്ടുമ് ആരഭത; തദാ തൈലസ്യ പരിമലേന ഗൃഹമ് ആമോദിതമ് അഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","യഃ ശിമോനഃ പുത്ര രിഷ്കരിയോതീയോ യിഹൂദാനാമാ യീശും പരകരേഷു സമർപയിഷ്യതി സ ശിഷ്യസ്തദാ കഥിതവാൻ, ");
INSERT INTO sanmal_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","ഏതത്തൈലം ത്രിഭിഃ ശതൈ ർമുദ്രാപദൈ ർവിക്രീതം സദ് ദരിദ്രേഭ്യഃ കുതോ നാദീയത? ");
INSERT INTO sanmal_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","സ ദരിദ്രലോകാർഥമ് അചിന്തയദ് ഇതി ന, കിന്തു സ ചൗര ഏവം തന്നികടേ മുദ്രാസമ്പുടകസ്ഥിത്യാ തന്മധ്യേ യദതിഷ്ഠത് തദപാഹരത് തസ്മാത് കാരണാദ് ഇമാം കഥാമകഥയത്| ");
INSERT INTO sanmal_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","തദാ യീശുരകഥയദ് ഏനാം മാ വാരയ സാ മമ ശ്മശാനസ്ഥാപനദിനാർഥം തദരക്ഷയത്| ");
INSERT INTO sanmal_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","ദരിദ്രാ യുഷ്മാകം സന്നിധൗ സർവ്വദാ തിഷ്ഠന്തി കിന്ത്വഹം സർവ്വദാ യുഷ്മാകം സന്നിധൗ ന തിഷ്ഠാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","തതഃ പരം യീശുസ്തത്രാസ്തീതി വാർത്താം ശ്രുത്വാ ബഹവോ യിഹൂദീയാസ്തം ശ്മശാനാദുത്ഥാപിതമ് ഇലിയാസരഞ്ച ദ്രഷ്ടും തത് സ്ഥാനമ് ആഗച്ഛന| ");
INSERT INTO sanmal_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","തദാ പ്രധാനയാജകാസ്തമ് ഇലിയാസരമപി സംഹർത്തുമ് അമന്ത്രയൻ ; ");
INSERT INTO sanmal_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","യതസ്തേന ബഹവോ യിഹൂദീയാ ഗത്വാ യീശൗ വ്യശ്വസൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","അനന്തരം യീശു ര്യിരൂശാലമ് നഗരമ് ആഗച്ഛതീതി വാർത്താം ശ്രുത്വാ പരേഽഹനി ഉത്സവാഗതാ ബഹവോ ലോകാഃ ");
INSERT INTO sanmal_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ഖർജ്ജൂരപത്രാദ്യാനീയ തം സാക്ഷാത് കർത്തും ബഹിരാഗത്യ ജയ ജയേതി വാചം പ്രോച്ചൈ ർവക്തുമ് ആരഭന്ത, ഇസ്രായേലോ യോ രാജാ പരമേശ്വരസ്യ നാമ്നാഗച്ഛതി സ ധന്യഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","തദാ \"ഹേ സിയോനഃ കന്യേ മാ ഭൈഷീഃ പശ്യായം തവ രാജാ ഗർദ്ദഭശാവകമ് ആരുഹ്യാഗച്ഛതി\" ");
INSERT INTO sanmal_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","ഇതി ശാസ്ത്രീയവചനാനുസാരേണ യീശുരേകം യുവഗർദ്ദഭം പ്രാപ്യ തദുപര്യ്യാരോഹത്| ");
INSERT INTO sanmal_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","അസ്യാഃ ഘടനായാസ്താത്പര്യ്യം ശിഷ്യാഃ പ്രഥമം നാബുധ്യന്ത, കിന്തു യീശൗ മഹിമാനം പ്രാപ്തേ സതി വാക്യമിദം തസ്മിന അകഥ്യത ലോകാശ്ച തമ്പ്രതീത്ഥമ് അകുർവ്വൻ ഇതി തേ സ്മൃതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","സ ഇലിയാസരം ശ്മശാനാദ് ആഗന്തുമ് ആഹ്വതവാൻ ശ്മശാനാഞ്ച ഉദസ്ഥാപയദ് യേ യേ ലോകാസ്തത്കർമ്യ സാക്ഷാദ് അപശ്യൻ തേ പ്രമാണം ദാതുമ് ആരഭന്ത| ");
INSERT INTO sanmal_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","സ ഏതാദൃശമ് അദ്ഭുതം കർമ്മകരോത് തസ്യ ജനശ്രുതേ ർലോകാസ്തം സാക്ഷാത് കർത്തുമ് ആഗച്ഛൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","തതഃ ഫിരൂശിനഃ പരസ്പരം വക്തുമ് ആരഭന്ത യുഷ്മാകം സർവ്വാശ്ചേഷ്ടാ വൃഥാ ജാതാഃ, ഇതി കിം യൂയം ന ബുധ്യധ്വേ? പശ്യത സർവ്വേ ലോകാസ്തസ്യ പശ്ചാദ്വർത്തിനോഭവൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ഭജനം കർത്തുമ് ഉത്സവാഗതാനാം ലോകാനാം കതിപയാ ജനാ അന്യദേശീയാ ആസൻ , ");
INSERT INTO sanmal_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","തേ ഗാലീലീയബൈത്സൈദാനിവാസിനഃ ഫിലിപസ്യ സമീപമ് ആഗത്യ വ്യാഹരൻ ഹേ മഹേച്ഛ വയം യീശും ദ്രഷ്ടുമ് ഇച്ഛാമഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","തതഃ ഫിലിപോ ഗത്വാ ആന്ദ്രിയമ് അവദത് പശ്ചാദ് ആന്ദ്രിയഫിലിപൗ യീശവേ വാർത്താമ് അകഥയതാം| ");
INSERT INTO sanmal_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","തദാ യീശുഃ പ്രത്യുദിതവാൻ മാനവസുതസ്യ മഹിമപ്രാപ്തിസമയ ഉപസ്ഥിതഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","അഹം യുഷ്മാനതിയഥാർഥം വദാമി, ധാന്യബീജം മൃത്തികായാം പതിത്വാ യദി ന മൃയതേ തർഹ്യേകാകീ തിഷ്ഠതി കിന്തു യദി മൃയതേ തർഹി ബഹുഗുണം ഫലം ഫലതി| ");
INSERT INTO sanmal_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","യോ ജനേा നിജപ്രാണാൻ പ്രിയാൻ ജാനാതി സ താൻ ഹാരയിഷ്യതി കിന്തു യേा ജന ഇഹലോകേ നിജപ്രാണാൻ അപ്രിയാൻ ജാനാതി സേाനന്തായുഃ പ്രാപ്തും താൻ രക്ഷിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","കശ്ചിദ് യദി മമ സേവകോ ഭവിതും വാഞ്ഛതി തർഹി സ മമ പശ്ചാദ്ഗാമീ ഭവതു, തസ്മാദ് അഹം യത്ര തിഷ്ഠാമി മമ സേവകേाപി തത്ര സ്ഥാസ്യതി; യോ ജനോ മാം സേവതേ മമ പിതാപി തം സമ്മംസ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","സാമ്പ്രതം മമ പ്രാണാ വ്യാകുലാ ഭവന്തി, തസ്മാദ് ഹേ പിതര ഏതസ്മാത് സമയാൻ മാം രക്ഷ, ഇത്യഹം കിം പ്രാർഥയിഷ്യേ? കിന്ത്വഹമ് ഏതത്സമയാർഥമ് അവതീർണവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ഹേ പിത: സ്വനാമ്നോ മഹിമാനം പ്രകാശയ; തനൈവ സ്വനാമ്നോ മഹിമാനമ് അഹം പ്രാകാശയം പുനരപി പ്രകാശയിഷ്യാമി, ഏഷാ ഗഗണീയാ വാണീ തസ്മിൻ സമയേഽജായത| ");
INSERT INTO sanmal_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","തച്ശ്രുത്വാ സമീപസ്ഥലോകാനാം കേചിദ് അവദൻ മേഘോഽഗർജീത്, കേചിദ് അവദൻ സ്വർഗീയദൂതോഽനേന സഹ കഥാമചകഥത്| ");
INSERT INTO sanmal_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","തദാ യീശുഃ പ്രത്യവാദീത്, മദർഥം ശബ്ദോയം നാഭൂത് യുഷ്മദർഥമേവാഭൂത്| ");
INSERT INTO sanmal_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","അധുനാ ജഗതോസ്യ വിചാര: സമ്പത്സ്യതേ, അധുനാസ്യ ജഗത: പതീ രാജ്യാത് ച്യോഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","യദ്യഈ പൃഥിവ്യാ ഊർദ്വ്വേ പ്രോത്ഥാപിതോസ്മി തർഹി സർവ്വാൻ മാനവാൻ സ്വസമീപമ് ആകർഷിഷ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","കഥം തസ്യ മൃതി ർഭവിഷ്യതി, ഏതദ് ബോധയിതും സ ഇമാം കഥാമ് അകഥയത്| ");
INSERT INTO sanmal_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","തദാ ലോകാ അകഥയൻ സോഭിഷിക്തഃ സർവ്വദാ തിഷ്ഠതീതി വ്യവസ്ഥാഗ്രന്ഥേ ശ്രുതമ് അസ്മാഭിഃ, തർഹി മനുഷ്യപുത്രഃ പ്രോത്ഥാപിതോ ഭവിഷ്യതീതി വാക്യം കഥം വദസി? മനുഷ്യപുത്രോയം കഃ? ");
INSERT INTO sanmal_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","തദാ യീശുരകഥായദ് യുഷ്മാഭിഃ സാർദ്ധമ് അൽപദിനാനി ജ്യോതിരാസ്തേ, യഥാ യുഷ്മാൻ അന്ധകാരോ നാച്ഛാദയതി തദർഥം യാവത്കാലം യുഷ്മാഭിഃ സാർദ്ധം ജ്യോതിസ്തിഷ്ഠതി താവത്കാലം ഗച്ഛത; യോ ജനോഽന്ധകാരേ ഗച്ഛതി സ കുത്ര യാതീതി ന ജാനാതി| ");
INSERT INTO sanmal_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","അതഏവ യാവത്കാലം യുഷ്മാകം നികടേ ജ്യോതിരാസ്തേ താവത്കാലം ജ്യോതീരൂപസന്താനാ ഭവിതും ജ്യോതിഷി വിശ്വസിത; ഇമാം കഥാം കഥയിത്വാ യീശുഃ പ്രസ്ഥായ തേഭ്യഃ സ്വം ഗുപ്തവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","യദ്യപി യീശുസ്തേഷാം സമക്ഷമ് ഏതാവദാശ്ചര്യ്യകർമ്മാണി കൃതവാൻ തഥാപി തേ തസ്മിൻ ന വ്യശ്വസൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","അതഏവ കഃ പ്രത്യേതി സുസംവാദം പരേശാസ്മത് പ്രചാരിതം? പ്രകാശതേ പരേശസ്യ ഹസ്തഃ കസ്യ ച സന്നിധൗ? യിശയിയഭവിഷ്യദ്വാദിനാ യദേതദ് വാക്യമുക്തം തത് സഫലമ് അഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","തേ പ്രത്യേതും നാശൻകുവൻ തസ്മിൻ യിശയിയഭവിഷ്യദ്വാദി പുനരവാദീദ്, ");
INSERT INTO sanmal_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","യദാ, \"തേ നയനൈ ർന പശ്യന്തി ബുദ്ധിഭിശ്ച ന ബുധ്യന്തേ തൈ ർമനഃസു പരിവർത്തിതേഷു ച താനഹം യഥാ സ്വസ്ഥാൻ ന കരോമി തഥാ സ തേഷാം ലോചനാന്യന്ധാനി കൃത്വാ തേഷാമന്തഃകരണാനി ഗാഢാനി കരിഷ്യതി| \" ");
INSERT INTO sanmal_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","യിശയിയോ യദാ യീശോ ർമഹിമാനം വിലോക്യ തസ്മിൻ കഥാമകഥയത് തദാ ഭവിഷ്യദ്വാക്യമ് ഈദൃശം പ്രകാശയത്| ");
INSERT INTO sanmal_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","തഥാപ്യധിപതിനാം ബഹവസ്തസ്മിൻ പ്രത്യായൻ| കിന്തു ഫിരൂശിനസ്താൻ ഭജനഗൃഹാദ് ദൂരീകുർവ്വന്തീതി ഭയാത് തേ തം ന സ്വീകൃതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","യത ഈശ്വരസ്യ പ്രശംസാതോ മാനവാനാം പ്രശംസായാം തേഽപ്രിയന്ത| ");
INSERT INTO sanmal_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","തദാ യീശുരുച്ചൈഃകാരമ് അകഥയദ് യോ ജനോ മയി വിശ്വസിതി സ കേവലേ മയി വിശ്വസിതീതി ന, സ മത്പ്രേരകേഽപി വിശ്വസിതി| ");
INSERT INTO sanmal_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","യോ ജനോ മാം പശ്യതി സ മത്പ്രേരകമപി പശ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","യോ ജനോ മാം പ്രത്യേതി സ യഥാന്ധകാരേ ന തിഷ്ഠതി തദർഥമ് അഹം ജ്യോതിഃസ്വരൂപോ ഭൂത്വാ ജഗത്യസ്മിൻ അവതീർണവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","മമ കഥാം ശ്രുത്വാ യദി കശ്ചിൻ ന വിശ്വസിതി തർഹി തമഹം ദോഷിണം ന കരോമി, യതോ ഹേതോ ർജഗതോ ജനാനാം ദോഷാൻ നിശ്ചിതാൻ കർത്തും നാഗത്യ താൻ പരിചാതുമ് ആഗതോസ്മി| ");
INSERT INTO sanmal_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","യഃ കശ്ചിൻ മാം ന ശ്രദ്ധായ മമ കഥം ന ഗൃഹ്ലാതി, അന്യസ്തം ദോഷിണം കരിഷ്യതി വസ്തുതസ്തു യാം കഥാമഹമ് അചകഥം സാ കഥാ ചരമേഽൻഹി തം ദോഷിണം കരിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","യതോ ഹേതോരഹം സ്വതഃ കിമപി ന കഥയാമി, കിം കിം മയാ കഥയിതവ്യം കിം സമുപദേഷ്ടവ്യഞ്ച ഇതി മത്പ്രേരയിതാ പിതാ മാമാജ്ഞാപയത്| ");
INSERT INTO sanmal_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","തസ്യ സാജ്ഞാ അനന്തായുരിത്യഹം ജാനാമി, അതഏവാഹം യത് കഥയാമി തത് പിതാ യഥാജ്ഞാപയത് തഥൈവ കഥയാമ്യഹമ്| ");
INSERT INTO sanmal_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","നിസ്താരോത്സവസ്യ കിഞ്ചിത്കാലാത് പൂർവ്വം പൃഥിവ്യാഃ പിതുഃ സമീപഗമനസ്യ സമയഃ സന്നികർഷോഭൂദ് ഇതി ജ്ഞാത്വാ യീശുരാപ്രഥമാദ് യേഷു ജഗത്പ്രവാസിഷ്വാത്മീയലോകേഷ പ്രേമ കരോതി സ്മ തേഷു ശേഷം യാവത് പ്രേമ കൃതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","പിതാ തസ്യ ഹസ്തേ സർവ്വം സമർപിതവാൻ സ്വയമ് ഈശ്വരസ്യ സമീപാദ് ആഗച്ഛദ് ഈശ്വരസ്യ സമീപം യാസ്യതി ച, സർവ്വാണ്യേതാനി ജ്ഞാത്വാ രജന്യാം ഭോജനേ സമ്പൂർണേ സതി, ");
INSERT INTO sanmal_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","യദാ ശൈതാൻ തം പരഹസ്തേഷു സമർപയിതും ശിമോനഃ പുത്രസ്യ ഈഷ്കാരിയോതിയസ്യ യിഹൂദാ അന്തഃകരണേ കുപ്രവൃത്തിം സമാർപയത്, ");
INSERT INTO sanmal_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","തദാ യീശു ർഭോജനാസനാദ് ഉത്ഥായ ഗാത്രവസ്ത്രം മോചയിത്വാ ഗാത്രമാർജനവസ്ത്രം ഗൃഹീത്വാ തേന സ്വകടിമ് അബധ്നാത്, ");
INSERT INTO sanmal_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","പശ്ചാദ് ഏകപാത്രേ ജലമ് അഭിഷിച്യ ശിഷ്യാണാം പാദാൻ പ്രക്ഷാല്യ തേന കടിബദ്ധഗാത്രമാർജനവാസസാ മാർഷ്ടും പ്രാരഭത| ");
INSERT INTO sanmal_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","തതഃ ശിമോൻപിതരസ്യ സമീപമാഗതേ സ ഉക്തവാൻ ഹേ പ്രഭോ ഭവാൻ കിം മമ പാദൗ പ്രക്ഷാലയിഷ്യതി? ");
INSERT INTO sanmal_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","യീശുരുദിതവാൻ അഹം യത് കരോമി തത് സമ്പ്രതി ന ജാനാസി കിന്തു പശ്ചാജ് ജ്ഞാസ്യസി| ");
INSERT INTO sanmal_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","തതഃ പിതരഃ കഥിതവാൻ ഭവാൻ കദാപി മമ പാദൗ ന പ്രക്ഷാലയിഷ്യതി| യീശുരകഥയദ് യദി ത്വാം ന പ്രക്ഷാലയേ തർഹി മയി തവ കോപ്യംശോ നാസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","തദാ ശിമോൻപിതരഃ കഥിതവാൻ ഹേ പ്രഭോ തർഹി കേവലപാദൗ ന, മമ ഹസ്തൗ ശിരശ്ച പ്രക്ഷാലയതു| ");
INSERT INTO sanmal_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","തതോ യീശുരവദദ് യോ ജനോ ധൗതസ്തസ്യ സർവ്വാങ്ഗപരിഷ്കൃതത്വാത് പാദൗ വിനാന്യാങ്ഗസ്യ പ്രക്ഷാലനാപേക്ഷാ നാസ്തി| യൂയം പരിഷ്കൃതാ ഇതി സത്യം കിന്തു ന സർവ്വേ, ");
INSERT INTO sanmal_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","യതോ യോ ജനസ്തം പരകരേഷു സമർപയിഷ്യതി തം സ ജ്ഞാതവാന; അതഏവ യൂയം സർവ്വേ ന പരിഷ്കൃതാ ഇമാം കഥാം കഥിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ഇത്ഥം യീശുസ്തേഷാം പാദാൻ പ്രക്ഷാല്യ വസ്ത്രം പരിധായാസനേ സമുപവിശ്യ കഥിതവാൻ അഹം യുഷ്മാൻ പ്രതി കിം കർമ്മാകാർഷം ജാനീഥ? ");
INSERT INTO sanmal_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","യൂയം മാം ഗുരും പ്രഭുഞ്ച വദഥ തത് സത്യമേവ വദഥ യതോഹം സഏവ ഭവാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","യദ്യഹം പ്രഭു ർഗുരുശ്ച സൻ യുഷ്മാകം പാദാൻ പ്രക്ഷാലിതവാൻ തർഹി യുഷ്മാകമപി പരസ്പരം പാദപ്രക്ഷാലനമ് ഉചിതമ്| ");
INSERT INTO sanmal_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","അഹം യുഷ്മാൻ പ്രതി യഥാ വ്യവാഹരം യുഷ്മാൻ തഥാ വ്യവഹർത്തുമ് ഏകം പന്ഥാനം ദർശിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","അഹം യുഷ്മാനതിയഥാർഥം വദാമി, പ്രഭോ ർദാസോ ന മഹാൻ പ്രേരകാച്ച പ്രേരിതോ ന മഹാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ഇമാം കഥാം വിദിത്വാ യദി തദനുസാരതഃ കർമ്മാണി കുരുഥ തർഹി യൂയം ധന്യാ ഭവിഷ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","സർവ്വേഷു യുഷ്മാസു കഥാമിമാം കഥയാമി ഇതി ന, യേ മമ മനോനീതാസ്താനഹം ജാനാമി, കിന്തു മമ ഭക്ഷ്യാണി യോ ഭുങ്ക്തേ മത്പ്രാണപ്രാതികൂല്യതഃ| ഉത്ഥാപയതി പാദസ്യ മൂലം സ ഏഷ മാനവഃ| യദേതദ് ധർമ്മപുസ്തകസ്യ വചനം തദനുസാരേണാവശ്യം ഘടിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","അഹം സ ജന ഇത്യത്ര യഥാ യുഷ്മാകം വിശ്വാസോ ജായതേ തദർഥം ഏതാദൃശഘടനാത് പൂർവ്വമ് അഹമിദാനീം യുഷ്മഭ്യമകഥയമ്| ");
INSERT INTO sanmal_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","അഹം യുഷ്മാനതീവ യഥാർഥം വദാമി, മയാ പ്രേരിതം ജനം യോ ഗൃഹ്ലാതി സ മാമേവ ഗൃഹ്ലാതി യശ്ച മാം ഗൃഹ്ലാതി സ മത്പ്രേരകം ഗൃഹ്ലാതി| ");
INSERT INTO sanmal_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ഏതാം കഥാം കഥയിത്വാ യീശു ർദുഃഖീ സൻ പ്രമാണം ദത്ത്വാ കഥിതവാൻ അഹം യുഷ്മാനതിയഥാർഥം വദാമി യുഷ്മാകമ് ഏകോ ജനോ മാം പരകരേഷു സമർപയിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","തതഃ സ കമുദ്ദിശ്യ കഥാമേതാം കഥിതവാൻ ഇത്യത്ര സന്ദിഗ്ധാഃ ശിഷ്യാഃ പരസ്പരം മുഖമാലോകയിതും പ്രാരഭന്ത| ");
INSERT INTO sanmal_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","തസ്മിൻ സമയേ യീശു ര്യസ്മിൻ അപ്രീയത സ ശിഷ്യസ്തസ്യ വക്ഷഃസ്ഥലമ് അവാലമ്ബത| ");
INSERT INTO sanmal_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ശിമോൻപിതരസ്തം സങ്കേതേനാവദത്, അയം കമുദ്ദിശ്യ കഥാമേതാമ് കഥയതീതി പൃച്ഛ| ");
INSERT INTO sanmal_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","തദാ സ യീശോ ർവക്ഷഃസ്ഥലമ് അവലമ്ബ്യ പൃഷ്ഠവാൻ, ഹേ പ്രഭോ സ ജനഃ കഃ? ");
INSERT INTO sanmal_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","തതോ യീശുഃ പ്രത്യവദദ് ഏകഖണ്ഡം പൂപം മജ്ജയിത്വാ യസ്മൈ ദാസ്യാമി സഏവ സഃ; പശ്ചാത് പൂപഖണ്ഡമേകം മജ്ജയിത്വാ ശിമോനഃ പുത്രായ ഈഷ്കരിയോതീയായ യിഹൂദൈ ദത്തവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","തസ്മിൻ ദത്തേ സതി ശൈതാൻ തമാശ്രയത്; തദാ യീശുസ്തമ് അവദത് ത്വം യത് കരിഷ്യസി തത് ക്ഷിപ്രം കുരു| ");
INSERT INTO sanmal_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","കിന്തു സ യേനാശയേന താം കഥാമകഥായത് തമ് ഉപവിഷ്ടലോകാനാം കോപി നാബുധ്യത; ");
INSERT INTO sanmal_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","കിന്തു യിഹൂദാഃ സമീപേ മുദ്രാസമ്പുടകസ്ഥിതേഃ കേചിദ് ഇത്ഥമ് അബുധ്യന്ത പാർവ്വണാസാദനാർഥം കിമപി ദ്രവ്യം ക്രേതും വാ ദരിദ്രേഭ്യഃ കിഞ്ചിദ് വിതരിതും കഥിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","തദാ പൂപഖണ്ഡഗ്രഹണാത് പരം സ തൂർണം ബഹിരഗച്ഛത്; രാത്രിശ്ച സമുപസ്യിതാ| ");
INSERT INTO sanmal_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","യിഹൂദേ ബഹിർഗതേ യീശുരകഥയദ് ഇദാനീം മാനവസുതസ്യ മഹിമാ പ്രകാശതേ തേനേശ്വരസ്യാപി മഹിമാ പ്രകാശതേ| ");
INSERT INTO sanmal_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","യദി തേനേശ്വരസ്യ മഹിമാ പ്രകാശതേ തർഹീശ്വരോപി സ്വേന തസ്യ മഹിമാനം പ്രകാശയിഷ്യതി തൂർണമേവ പ്രകാശയിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ഹേ വത്സാ അഹം യുഷ്മാഭിഃ സാർദ്ധം കിഞ്ചിത്കാലമാത്രമ് ആസേ, തതഃ പരം മാം മൃഗയിഷ്യധ്വേ കിന്ത്വഹം യത്സ്ഥാനം യാമി തത്സ്ഥാനം യൂയം ഗന്തും ന ശക്ഷ്യഥ, യാമിമാം കഥാം യിഹൂദീയേഭ്യഃ കഥിതവാൻ തഥാധുനാ യുഷ്മഭ്യമപി കഥയാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","യൂയം പരസ്പരം പ്രീയധ്വമ് അഹം യുഷ്മാസു യഥാ പ്രീയേ യൂയമപി പരസ്പരമ് തഥൈവ പ്രീയധ്വം, യുഷ്മാൻ ഇമാം നവീനാമ് ആജ്ഞാമ് ആദിശാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","തേനൈവ യദി പരസ്പരം പ്രീയധ്വേ തർഹി ലക്ഷണേനാനേന യൂയം മമ ശിഷ്യാ ഇതി സർവ്വേ ജ്ഞാതും ശക്ഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ശിമോനപിതരഃ പൃഷ്ഠവാൻ ഹേ പ്രഭോ ഭവാൻ കുത്ര യാസ്യതി? തതോ യീശുഃ പ്രത്യവദത്, അഹം യത്സ്ഥാനം യാമി തത്സ്ഥാനം സാമ്പ്രതം മമ പശ്ചാദ് ഗന്തും ന ശക്നോഷി കിന്തു പശ്ചാദ് ഗമിഷ്യസി| ");
INSERT INTO sanmal_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","തദാ പിതരഃ പ്രത്യുദിതവാൻ, ഹേ പ്രഭോ സാമ്പ്രതം കുതോ ഹേതോസ്തവ പശ്ചാദ് ഗന്തും ന ശക്നോമി? ത്വദർഥം പ്രാണാൻ ദാതും ശക്നോമി| ");
INSERT INTO sanmal_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","തതോ യീശുഃ പ്രത്യുക്തവാൻ മന്നിമിത്തം കിം പ്രാണാൻ ദാതും ശക്നോഷി? ത്വാമഹം യഥാർഥം വദാമി, കുക്കുടരവണാത് പൂർവ്വം ത്വം ത്രി ർമാമ് അപഹ്നോഷ്യസേ| ");
INSERT INTO sanmal_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","മനോദുഃഖിനോ മാ ഭൂത; ഈശ്വരേ വിശ്വസിത മയി ച വിശ്വസിത| ");
INSERT INTO sanmal_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","മമ പിതു ഗൃഹേ ബഹൂനി വാസസ്ഥാനി സന്തി നോ ചേത് പൂർവ്വം യുഷ്മാൻ അജ്ഞാപയിഷ്യം യുഷ്മദർഥം സ്ഥാനം സജ്ജയിതും ഗച്ഛാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","യദി ഗത്വാഹം യുഷ്മന്നിമിത്തം സ്ഥാനം സജ്ജയാമി തർഹി പനരാഗത്യ യുഷ്മാൻ സ്വസമീപം നേഷ്യാമി, തതോ യത്രാഹം തിഷ്ഠാമി തത്ര യൂയമപി സ്ഥാസ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","അഹം യത്സ്ഥാനം ബ്രജാമി തത്സ്ഥാനം യൂയം ജാനീഥ തസ്യ പന്ഥാനമപി ജാനീഥ| ");
INSERT INTO sanmal_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","തദാ ഥോമാ അവദത്, ഹേ പ്രഭോ ഭവാൻ കുത്ര യാതി തദ്വയം ന ജാനീമഃ, തർഹി കഥം പന്ഥാനം ജ്ഞാതും ശക്നുമഃ? ");
INSERT INTO sanmal_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","യീശുരകഥയദ് അഹമേവ സത്യജീവനരൂപപഥോ മയാ ന ഗന്താ കോപി പിതുഃ സമീപം ഗന്തും ന ശക്നോതി| ");
INSERT INTO sanmal_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","യദി മാമ് അജ്ഞാസ്യത തർഹി മമ പിതരമപ്യജ്ഞാസ്യത കിന്ത്വധുനാതസ്തം ജാനീഥ പശ്യഥ ച| ");
INSERT INTO sanmal_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","തദാ ഫിലിപഃ കഥിതവാൻ, ഹേ പ്രഭോ പിതരം ദർശയ തസ്മാദസ്മാകം യഥേഷ്ടം ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","തതോ യീശുഃ പ്രത്യാവാദീത്, ഹേ ഫിലിപ യുഷ്മാഭിഃ സാർദ്ധമ് ഏതാവദ്ദിനാനി സ്ഥിതമപി മാം കിം ന പ്രത്യഭിജാനാസി? യോ ജനോ മാമ് അപശ്യത് സ പിതരമപ്യപശ്യത് തർഹി പിതരമ് അസ്മാൻ ദർശയേതി കഥാം കഥം കഥയസി? ");
INSERT INTO sanmal_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","അഹം പിതരി തിഷ്ഠാമി പിതാ മയി തിഷ്ഠതീതി കിം ത്വം ന പ്രത്യഷി? അഹം യദ്വാക്യം വദാമി തത് സ്വതോ ന വദാമി കിന്തു യഃ പിതാ മയി വിരാജതേ സ ഏവ സർവ്വകർമ്മാണി കരാതി| ");
INSERT INTO sanmal_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","അതഏവ പിതര്യ്യഹം തിഷ്ഠാമി പിതാ ച മയി തിഷ്ഠതി മമാസ്യാം കഥായാം പ്രത്യയം കുരുത, നോ ചേത് കർമ്മഹേതോഃ പ്രത്യയം കുരുത| ");
INSERT INTO sanmal_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","അഹം യുഷ്മാനതിയഥാർഥം വദാമി, യോ ജനോ മയി വിശ്വസിതി സോഹമിവ കർമ്മാണി കരിഷ്യതി വരം തതോപി മഹാകർമ്മാണി കരിഷ്യതി യതോ ഹേതോരഹം പിതുഃ സമീപം ഗച്ഛാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","യഥാ പുത്രേണ പിതു ർമഹിമാ പ്രകാശതേ തദർഥം മമ നാമ പ്രോച്യ യത് പ്രാർഥയിഷ്യധ്വേ തത് സഫലം കരിഷ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","യദി മമ നാമ്നാ യത് കിഞ്ചിദ് യാചധ്വേ തർഹി തദഹം സാധയിഷ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","യദി മയി പ്രീയധ്വേ തർഹി മമാജ്ഞാഃ സമാചരത| ");
INSERT INTO sanmal_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","തതോ മയാ പിതുഃ സമീപേ പ്രാർഥിതേ പിതാ നിരന്തരം യുഷ്മാഭിഃ സാർദ്ധം സ്ഥാതുമ് ഇതരമേകം സഹായമ് അർഥാത് സത്യമയമ് ആത്മാനം യുഷ്മാകം നികടം പ്രേഷയിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ഏതജ്ജഗതോ ലോകാസ്തം ഗ്രഹീതും ന ശക്നുവന്തി യതസ്തേ തം നാപശ്യൻ നാജനംശ്ച കിന്തു യൂയം ജാനീഥ യതോ ഹേതോഃ സ യുഷ്മാകമന്ത ർനിവസതി യുഷ്മാകം മധ്യേ സ്ഥാസ്യതി ച| ");
INSERT INTO sanmal_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","അഹം യുഷ്മാൻ അനാഥാൻ കൃത്വാ ന യാസ്യാമി പുനരപി യുഷ്മാകം സമീപമ് ആഗമിഷ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","കിയത്കാലരത് പരമ് അസ്യ ജഗതോ ലോകാ മാം പുന ർന ദ്രക്ഷ്യന്തി കിന്തു യൂയം ദ്രക്ഷ്യഥ;അഹം ജീവിഷ്യാമി തസ്മാത് കാരണാദ് യൂയമപി ജീവിഷ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","പിതര്യ്യഹമസ്മി മയി ച യൂയം സ്ഥ, തഥാഹം യുഷ്മാസ്വസ്മി തദപി തദാ ജ്ഞാസ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","യോ ജനോ മമാജ്ഞാ ഗൃഹീത്വാ താ ആചരതി സഏവ മയി പ്രീയതേ; യോ ജനശ്ച മയി പ്രീയതേ സഏവ മമ പിതുഃ പ്രിയപാത്രം ഭവിഷ്യതി, തഥാഹമപി തസ്മിൻ പ്രീത്വാ തസ്മൈ സ്വം പ്രകാശയിഷ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","തദാ ഈഷ്കരിയോതീയാദ് അന്യോ യിഹൂദാസ്തമവദത്, ഹേ പ്രഭോ ഭവാൻ ജഗതോ ലോകാനാം സന്നിധൗ പ്രകാശിതോ ന ഭൂത്വാസ്മാകം സന്നിധൗ കുതഃ പ്രകാശിതോ ഭവിഷ്യതി? ");
INSERT INTO sanmal_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","തതോ യീശുഃ പ്രത്യുദിതവാൻ, യോ ജനോ മയി പ്രീയതേ സ മമാജ്ഞാ അപി ഗൃഹ്ലാതി, തേന മമ പിതാപി തസ്മിൻ പ്രേഷ്യതേ, ആവാഞ്ച തന്നികടമാഗത്യ തേന സഹ നിവത്സ്യാവഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","യോ ജനോ മയി ന പ്രീയതേ സ മമ കഥാ അപി ന ഗൃഹ്ലാതി പുനശ്ച യാമിമാം കഥാം യൂയം ശൃണുഥ സാ കഥാ കേവലസ്യ മമ ന കിന്തു മമ പ്രേരകോ യഃ പിതാ തസ്യാപി കഥാ| ");
INSERT INTO sanmal_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","ഇദാനീം യുഷ്മാകം നികടേ വിദ്യമാനോഹമ് ഏതാഃ സകലാഃ കഥാഃ കഥയാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","കിന്ത്വിതഃ പരം പിത്രാ യഃ സഹായോഽർഥാത് പവിത്ര ആത്മാ മമ നാമ്നി പ്രേരയിഷ്യതി സ സർവ്വം ശിക്ഷയിത്വാ മയോക്താഃ സമസ്താഃ കഥാ യുഷ്മാൻ സ്മാരയിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","അഹം യുഷ്മാകം നികടേ ശാന്തിം സ്ഥാപയിത്വാ യാമി, നിജാം ശാന്തിം യുഷ്മഭ്യം ദദാമി, ജഗതോ ലോകാ യഥാ ദദാതി തഥാഹം ന ദദാമി; യുഷ്മാകമ് അന്തഃകരണാനി ദുഃഖിതാനി ഭീതാനി ച ന ഭവന്തു| ");
INSERT INTO sanmal_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","അഹം ഗത്വാ പുനരപി യുഷ്മാകം സമീപമ് ആഗമിഷ്യാമി മയോക്തം വാക്യമിദം യൂയമ് അശ്രൗഷ്ട; യദി മയ്യപ്രേഷ്യധ്വം തർഹ്യഹം പിതുഃ സമീപം ഗച്ഛാമി മമാസ്യാം കഥായാം യൂയമ് അഹ്ലാദിഷ്യധ്വം യതോ മമ പിതാ മത്തോപി മഹാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","തസ്യാ ഘടനായാഃ സമയേ യഥാ യുഷ്മാകം ശ്രദ്ധാ ജായതേ തദർഥമ് അഹം തസ്യാ ഘടനായാഃ പൂർവ്വമ് ഇദാനീം യുഷ്മാൻ ഏതാം വാർത്താം വദാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ഇതഃ പരം യുഷ്മാഭിഃ സഹ മമ ബഹവ ആലാപാ ന ഭവിഷ്യന്തി യതഃ കാരണാദ് ഏതസ്യ ജഗതഃ പതിരാഗച്ഛതി കിന്തു മയാ സഹ തസ്യ കോപി സമ്ബന്ധോ നാസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","അഹം പിതരി പ്രേമ കരോമി തഥാ പിതു ർവിധിവത് കർമ്മാണി കരോമീതി യേന ജഗതോ ലോകാ ജാനന്തി തദർഥമ് ഉത്തിഷ്ഠത വയം സ്ഥാനാദസ്മാദ് ഗച്ഛാമ| ");
INSERT INTO sanmal_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","അഹം സത്യദ്രാക്ഷാലതാസ്വരൂപോ മമ പിതാ തൂദ്യാനപരിചാരകസ്വരൂപഞ്ച| ");
INSERT INTO sanmal_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","മമ യാസു ശാഖാസു ഫലാനി ന ഭവന്തി താഃ സ ഛിനത്തി തഥാ ഫലവത്യഃ ശാഖാ യഥാധികഫലാനി ഫലന്തി തദർഥം താഃ പരിഷ്കരോതി| ");
INSERT INTO sanmal_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ഇദാനീം മയോക്തോപദേശേന യൂയം പരിഷ്കൃതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","അതഃ കാരണാത് മയി തിഷ്ഠത തേനാഹമപി യുഷ്മാസു തിഷ്ഠാമി, യതോ ഹേതോ ർദ്രാക്ഷാലതായാമ് അസംലഗ്നാ ശാഖാ യഥാ ഫലവതീ ഭവിതും ന ശക്നോതി തഥാ യൂയമപി മയ്യതിഷ്ഠന്തഃ ഫലവന്തോ ഭവിതും ന ശക്നുഥ| ");
INSERT INTO sanmal_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","അഹം ദ്രാക്ഷാലതാസ്വരൂപോ യൂയഞ്ച ശാഖാസ്വരൂപോഃ; യോ ജനോ മയി തിഷ്ഠതി യത്ര ചാഹം തിഷ്ഠാമി, സ പ്രചൂരഫലൈഃ ഫലവാൻ ഭവതി, കിന്തു മാം വിനാ യൂയം കിമപി കർത്തും ന ശക്നുഥ| ");
INSERT INTO sanmal_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","യഃ കശ്ചിൻ മയി ന തിഷ്ഠതി സ ശുഷ്കശാഖേവ ബഹി ർനിക്ഷിപ്യതേ ലോകാശ്ച താ ആഹൃത്യ വഹ്നൗ നിക്ഷിപ്യ ദാഹയന്തി| ");
INSERT INTO sanmal_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","യദി യൂയം മയി തിഷ്ഠഥ മമ കഥാ ച യുഷ്മാസു തിഷ്ഠതി തർഹി യദ് വാഞ്ഛിത്വാ യാചിഷ്യധ്വേ യുഷ്മാകം തദേവ സഫലം ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","യദി യൂയം പ്രചൂരഫലവന്തോ ഭവഥ തർഹി തദ്വാരാ മമ പിതു ർമഹിമാ പ്രകാശിഷ്യതേ തഥാ യൂയം മമ ശിഷ്യാ ഇതി പരിക്ഷായിഷ്യധ്വേ| ");
INSERT INTO sanmal_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","പിതാ യഥാ മയി പ്രീതവാൻ അഹമപി യുഷ്മാസു തഥാ പ്രീതവാൻ അതോ ഹേതോ ര്യൂയം നിരന്തരം മമ പ്രേമപാത്രാണി ഭൂത്വാ തിഷ്ഠത| ");
INSERT INTO sanmal_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","അഹം യഥാ പിതുരാജ്ഞാ ഗൃഹീത്വാ തസ്യ പ്രേമഭാജനം തിഷ്ഠാമി തഥൈവ യൂയമപി യദി മമാജ്ഞാ ഗുഹ്ലീഥ തർഹി മമ പ്രേമഭാജനാനി സ്ഥാസ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","യുഷ്മന്നിമിത്തം മമ യ ആഹ്ലാദഃ സ യഥാ ചിരം തിഷ്ഠതി യുഷ്മാകമ് ആനന്ദശ്ച യഥാ പൂര്യ്യതേ തദർഥം യുഷ്മഭ്യമ് ഏതാഃ കഥാ അത്രകഥമ്| ");
INSERT INTO sanmal_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","അഹം യുഷ്മാസു യഥാ പ്രീയേ യൂയമപി പരസ്പരം തഥാ പ്രീയധ്വമ് ഏഷാ മമാജ്ഞാ| ");
INSERT INTO sanmal_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","മിത്രാണാം കാരണാത് സ്വപ്രാണദാനപര്യ്യന്തം യത് പ്രേമ തസ്മാൻ മഹാപ്രേമ കസ്യാപി നാസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","അഹം യദ്യദ് ആദിശാമി തത്തദേവ യദി യൂയമ് ആചരത തർഹി യൂയമേവ മമ മിത്രാണി| ");
INSERT INTO sanmal_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","അദ്യാരഭ്യ യുഷ്മാൻ ദാസാൻ ന വദിഷ്യാമി യത് പ്രഭു ര്യത് കരോതി ദാസസ്തദ് ന ജാനാതി; കിന്തു പിതുഃ സമീപേ യദ്യദ് അശൃണവം തത് സർവ്വം യൂഷ്മാൻ അജ്ഞാപയമ് തത്കാരണാദ് യുഷ്മാൻ മിത്രാണി പ്രോക്തവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","യൂയം മാം രോചിതവന്ത ഇതി ന, കിന്ത്വഹമേവ യുഷ്മാൻ രോചിതവാൻ യൂയം ഗത്വാ യഥാ ഫലാന്യുത്പാദയഥ താനി ഫലാനി ചാക്ഷയാണി ഭവന്തി, തദർഥം യുഷ്മാൻ ന്യജുനജം തസ്മാൻ മമ നാമ പ്രോച്യ പിതരം യത് കിഞ്ചിദ് യാചിഷ്യധ്വേ തദേവ സ യുഷ്മഭ്യം ദാസ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","യൂയം പരസ്പരം പ്രീയധ്വമ് അഹമ് ഇത്യാജ്ഞാപയാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","ജഗതോ ലോകൈ ര്യുഷ്മാസു ഋതീയിതേഷു തേ പൂർവ്വം മാമേവാർത്തീയന്ത ഇതി യൂയം ജാനീഥ| ");
INSERT INTO sanmal_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","യദി യൂയം ജഗതോ ലോകാ അഭവിഷ്യത തർഹി ജഗതോ ലോകാ യുഷ്മാൻ ആത്മീയാൻ ബുദ്ധ്വാപ്രേഷ്യന്ത; കിന്തു യൂയം ജഗതോ ലോകാ ന ഭവഥ, അഹം യുഷ്മാൻ അസ്മാജ്ജഗതോഽരോചയമ് ഏതസ്മാത് കാരണാജ്ജഗതോ ലോകാ യുഷ്മാൻ ഋതീയന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","ദാസഃ പ്രഭോ ർമഹാൻ ന ഭവതി മമൈതത് പൂർവ്വീയം വാക്യം സ്മരത; തേ യദി മാമേവാതാഡയൻ തർഹി യുഷ്മാനപി താഡയിഷ്യന്തി, യദി മമ വാക്യം ഗൃഹ്ലന്തി തർഹി യുഷ്മാകമപി വാക്യം ഗ്രഹീഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","കിന്തു തേ മമ നാമകാരണാദ് യുഷ്മാൻ പ്രതി താദൃശം വ്യവഹരിഷ്യന്തി യതോ യോ മാം പ്രേരിതവാൻ തം തേ ന ജാനന്തി| ");
INSERT INTO sanmal_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","തേഷാം സന്നിധിമ് ആഗത്യ യദ്യഹം നാകഥയിഷ്യം തർഹി തേഷാം പാപം നാഭവിഷ്യത് കിന്ത്വധുനാ തേഷാം പാപമാച്ഛാദയിതുമ് ഉപായോ നാസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","യോ ജനോ മാമ് ഋതീയതേ സ മമ പിതരമപി ഋതീയതേ| ");
INSERT INTO sanmal_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","യാദൃശാനി കർമ്മാണി കേനാപി കദാപി നാക്രിയന്ത താദൃശാനി കർമ്മാണി യദി തേഷാം സാക്ഷാദ് അഹം നാകരിഷ്യം തർഹി തേഷാം പാപം നാഭവിഷ്യത് കിന്ത്വധുനാ തേ ദൃഷ്ട്വാപി മാം മമ പിതരഞ്ചാർത്തീയന്ത| ");
INSERT INTO sanmal_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","തസ്മാത് തേഽകാരണം മാമ് ഋതീയന്തേ യദേതദ് വചനം തേഷാം ശാസ്ത്രേ ലിഖിതമാസ്തേ തത് സഫലമ് അഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","കിന്തു പിതു ർനിർഗതം യം സഹായമർഥാത് സത്യമയമ് ആത്മാനം പിതുഃ സമീപാദ് യുഷ്മാകം സമീപേ പ്രേഷയിഷ്യാമി സ ആഗത്യ മയി പ്രമാണം ദാസ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","യൂയം പ്രഥമമാരഭ്യ മയാ സാർദ്ധം തിഷ്ഠഥ തസ്മാദ്ധേതോ ര്യൂയമപി പ്രമാണം ദാസ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","യുഷ്മാകം യഥാ വാധാ ന ജായതേ തദർഥം യുഷ്മാൻ ഏതാനി സർവ്വവാക്യാനി വ്യാഹരം| ");
INSERT INTO sanmal_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ലോകാ യുഷ്മാൻ ഭജനഗൃഹേഭ്യോ ദൂരീകരിഷ്യന്തി തഥാ യസ്മിൻ സമയേ യുഷ്മാൻ ഹത്വാ ഈശ്വരസ്യ തുഷ്ടി ജനകം കർമ്മാകുർമ്മ ഇതി മംസ്യന്തേ സ സമയ ആഗച്ഛന്തി| ");
INSERT INTO sanmal_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","തേ പിതരം മാഞ്ച ന ജാനന്തി, തസ്മാദ് യുഷ്മാൻ പ്രതീദൃശമ് ആചരിഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","അതോ ഹേതാഃ സമയേ സമുപസ്ഥിതേ യഥാ മമ കഥാ യുഷ്മാകം മനഃസുഃ സമുപതിഷ്ഠതി തദർഥം യുഷ്മാഭ്യമ് ഏതാം കഥാം കഥയാമി യുഷ്മാഭിഃ സാർദ്ധമ് അഹം തിഷ്ഠൻ പ്രഥമം താം യുഷ്മഭ്യം നാകഥയം| ");
INSERT INTO sanmal_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","സാമ്പ്രതം സ്വസ്യ പ്രേരയിതുഃ സമീപം ഗച്ഛാമി തഥാപി ത്വം ക്ക ഗച്ഛസി കഥാമേതാം യുഷ്മാകം കോപി മാം ന പൃച്ഛതി| ");
INSERT INTO sanmal_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","കിന്തു മയോക്താഭിരാഭിഃ കഥാഭി ര്യൂഷ്മാകമ് അന്തഃകരണാനി ദുഃഖേന പൂർണാന്യഭവൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","തഥാപ്യഹം യഥാർഥം കഥയാമി മമ ഗമനം യുഷ്മാകം ഹിതാർഥമേവ, യതോ ഹേതോ ർഗമനേ ന കൃതേ സഹായോ യുഷ്മാകം സമീപം നാഗമിഷ്യതി കിന്തു യദി ഗച്ഛാമി തർഹി യുഷ്മാകം സമീപേ തം പ്രേഷയിഷ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","തതഃ സ ആഗത്യ പാപപുണ്യദണ്ഡേഷു ജഗതോ ലോകാനാം പ്രബോധം ജനയിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","തേ മയി ന വിശ്വസന്തി തസ്മാദ്ധേതോഃ പാപപ്രബോധം ജനയിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","യുഷ്മാകമ് അദൃശ്യഃ സന്നഹം പിതുഃ സമീപം ഗച്ഛാമി തസ്മാദ് പുണ്യേ പ്രബോധം ജനയിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ഏതജ്ജഗതോഽധിപതി ർദണ്ഡാജ്ഞാം പ്രാപ്നോതി തസ്മാദ് ദണ്ഡേ പ്രബോധം ജനയിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","യുഷ്മഭ്യം കഥയിതും മമാനേകാഃ കഥാ ആസതേ, താഃ കഥാ ഇദാനീം യൂയം സോഢും ന ശക്നുഥ; ");
INSERT INTO sanmal_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","കിന്തു സത്യമയ ആത്മാ യദാ സമാഗമിഷ്യതി തദാ സർവ്വം സത്യം യുഷ്മാൻ നേഷ്യതി, സ സ്വതഃ കിമപി ന വദിഷ്യതി കിന്തു യച്ഛ്രോഷ്യതി തദേവ കഥയിത്വാ ഭാവികാര്യ്യം യുഷ്മാൻ ജ്ഞാപയിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","മമ മഹിമാനം പ്രകാശയിഷ്യതി യതോ മദീയാം കഥാം ഗൃഹീത്വാ യുഷ്മാൻ ബോധയിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","പിതു ര്യദ്യദ് ആസ്തേ തത് സർവ്വം മമ തസ്മാദ് കാരണാദ് അവാദിഷം സ മദീയാം കഥാം ഗൃഹീത്വാ യുഷ്മാൻ ബോധയിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","കിയത്കാലാത് പരം യൂയം മാം ദ്രഷ്ടും ന ലപ്സ്യധ്വേ കിന്തു കിയത്കാലാത് പരം പുന ർദ്രഷ്ടും ലപ്സ്യധ്വേ യതോഹം പിതുഃ സമീപം ഗച്ഛാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","തതഃ ശിഷ്യാണാം കിയന്തോ ജനാഃ പരസ്പരം വദിതുമ് ആരഭന്ത, കിയത്കാലാത് പരം മാം ദ്രഷ്ടും ന ലപ്സ്യധ്വേ കിന്തു കിയത്കാലാത് പരം പുന ർദ്രഷ്ടും ലപ്സ്യധ്വേ യതോഹം പിതുഃ സമീപം ഗച്ഛാമി, ഇതി യദ് വാക്യമ് അയം വദതി തത് കിം? ");
INSERT INTO sanmal_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","തതഃ കിയത്കാലാത് പരമ് ഇതി തസ്യ വാക്യം കിം? തസ്യ വാക്യസ്യാഭിപ്രായം വയം ബോദ്ധും ന ശക്നുമസ്തൈരിതി ");
INSERT INTO sanmal_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","നിഗദിതേ യീശുസ്തേഷാം പ്രശ്നേച്ഛാം ജ്ഞാത്വാ തേഭ്യോഽകഥയത് കിയത്കാലാത് പരം മാം ദ്രഷ്ടും ന ലപ്സ്യധ്വേ, കിന്തു കിയത്കാലാത് പരം പൂന ർദ്രഷ്ടും ലപ്സ്യധ്വേ, യാമിമാം കഥാമകഥയം തസ്യാ അഭിപ്രായം കിം യൂയം പരസ്പരം മൃഗയധ്വേ? ");
INSERT INTO sanmal_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","യുഷ്മാനഹമ് അതിയഥാർഥം വദാമി യൂയം ക്രന്ദിഷ്യഥ വിലപിഷ്യഥ ച, കിന്തു ജഗതോ ലോകാ ആനന്ദിഷ്യന്തി; യൂയം ശോകാകുലാ ഭവിഷ്യഥ കിന്തു ശോകാത് പരം ആനന്ദയുക്താ ഭവിഷ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","പ്രസവകാല ഉപസ്ഥിതേ നാരീ യഥാ പ്രസവവേദനയാ വ്യാകുലാ ഭവതി കിന്തു പുത്രേ ഭൂമിഷ്ഠേ സതി മനുഷ്യൈകോ ജന്മനാ നരലോകേ പ്രവിഷ്ട ഇത്യാനന്ദാത് തസ്യാസ്തത്സർവ്വം ദുഃഖം മനസി ന തിഷ്ഠതി, ");
INSERT INTO sanmal_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","തഥാ യൂയമപി സാമ്പ്രതം ശോകാകുലാ ഭവഥ കിന്തു പുനരപി യുഷ്മഭ്യം ദർശനം ദാസ്യാമി തേന യുഷ്മാകമ് അന്തഃകരണാനി സാനന്ദാനി ഭവിഷ്യന്തി, യുഷ്മാകം തമ് ആനന്ദഞ്ച കോപി ഹർത്തും ന ശക്ഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","തസ്മിൻ ദിവസേ കാമപി കഥാം മാം ന പ്രക്ഷ്യഥ| യുഷ്മാനഹമ് അതിയഥാർഥം വദാമി, മമ നാമ്നാ യത് കിഞ്ചിദ് പിതരം യാചിഷ്യധ്വേ തദേവ സ ദാസ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","പൂർവ്വേ മമ നാമ്നാ കിമപി നായാചധ്വം, യാചധ്വം തതഃ പ്രാപ്സ്യഥ തസ്മാദ് യുഷ്മാകം സമ്പൂർണാനന്ദോ ജനിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","ഉപമാകഥാഭിഃ സർവ്വാണ്യേതാനി യുഷ്മാൻ ജ്ഞാപിതവാൻ കിന്തു യസ്മിൻ സമയേ ഉപമയാ നോക്ത്വാ പിതുഃ കഥാം സ്പഷ്ടം ജ്ഞാപയിഷ്യാമി സമയ ഏതാദൃശ ആഗച്ഛതി| ");
INSERT INTO sanmal_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","തദാ മമ നാമ്നാ പ്രാർഥയിഷ്യധ്വേ ഽഹം യുഷ്മന്നിമിത്തം പിതരം വിനേഷ്യേ കഥാമിമാം ന വദാമി; ");
INSERT INTO sanmal_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","യതോ യൂയം മയി പ്രേമ കുരുഥ, തഥാഹമ് ഈശ്വരസ്യ സമീപാദ് ആഗതവാൻ ഇത്യപി പ്രതീഥ, തസ്മാദ് കാരണാത് കാരണാത് പിതാ സ്വയം യുഷ്മാസു പ്രീയതേ| ");
INSERT INTO sanmal_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","പിതുഃ സമീപാജ്ജജദ് ആഗതോസ്മി ജഗത് പരിത്യജ്യ ച പുനരപി പിതുഃ സമീപം ഗച്ഛാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","തദാ ശിഷ്യാ അവദൻ, ഹേ പ്രഭോ ഭവാൻ ഉപമയാ നോക്ത്വാധുനാ സ്പഷ്ടം വദതി| ");
INSERT INTO sanmal_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ഭവാൻ സർവ്വജ്ഞഃ കേനചിത് പൃഷ്ടോ ഭവിതുമപി ഭവതഃ പ്രയോജനം നാസ്തീത്യധുനാസ്മാകം സ്ഥിരജ്ഞാനം ജാതം തസ്മാദ് ഭവാൻ ഈശ്വരസ്യ സമീപാദ് ആഗതവാൻ ഇത്യത്ര വയം വിശ്വസിമഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","തതോ യീശുഃ പ്രത്യവാദീദ് ഇദാനീം കിം യൂയം വിശ്വസിഥ? ");
INSERT INTO sanmal_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","പശ്യത സർവ്വേ യൂയം വികീർണാഃ സന്തോ മാമ് ഏകാകിനം പീരത്യജ്യ സ്വം സ്വം സ്ഥാനം ഗമിഷ്യഥ, ഏതാദൃശഃ സമയ ആഗച്ഛതി വരം പ്രായേണോപസ്ഥിതവാൻ; തഥാപ്യഹം നൈകാകീ ഭവാമി യതഃ പിതാ മയാ സാർദ്ധമ് ആസ്തേ| ");
INSERT INTO sanmal_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","യഥാ മയാ യുഷ്മാകം ശാന്തി ർജായതേ തദർഥമ് ഏതാഃ കഥാ യുഷ്മഭ്യമ് അചകഥം; അസ്മിൻ ജഗതി യുഷ്മാകം ക്ലേശോ ഘടിഷ്യതേ കിന്ത്വക്ഷോഭാ ഭവത യതോ മയാ ജഗജ്ജിതം| ");
INSERT INTO sanmal_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","തതഃ പരം യീശുരേതാഃ കഥാഃ കഥയിത്വാ സ്വർഗം വിലോക്യൈതത് പ്രാർഥയത്, ഹേ പിതഃ സമയ ഉപസ്ഥിതവാൻ; യഥാ തവ പുത്രസ്തവ മഹിമാനം പ്രകാശയതി തദർഥം ത്വം നിജപുത്രസ്യ മഹിമാനം പ്രകാശയ| ");
INSERT INTO sanmal_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ത്വം യോല്ലോകാൻ തസ്യ ഹസ്തേ സമർപിതവാൻ സ യഥാ തേഭ്യോഽനന്തായു ർദദാതി തദർഥം ത്വം പ്രാണിമാത്രാണാമ് അധിപതിത്വഭാരം തസ്മൈ ദത്തവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","യസ്ത്വമ് അദ്വിതീയഃ സത്യ ഈശ്വരസ്ത്വയാ പ്രേരിതശ്ച യീശുഃ ഖ്രീഷ്ട ഏതയോരുഭയോഃ പരിചയേ പ്രാപ്തേഽനന്തായു ർഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ത്വം യസ്യ കർമ്മണോ ഭാരം മഹ്യം ദത്തവാൻ, തത് സമ്പന്നം കൃത്വാ ജഗത്യസ്മിൻ തവ മഹിമാനം പ്രാകാശയം| ");
INSERT INTO sanmal_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","അതഏവ ഹേ പിത ർജഗത്യവിദ്യമാനേ ത്വയാ സഹ തിഷ്ഠതോ മമ യോ മഹിമാസീത് സമ്പ്രതി തവ സമീപേ മാം തം മഹിമാനം പ്രാപയ| ");
INSERT INTO sanmal_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","അന്യച്ച ത്വമ് ഏതജ്ജഗതോ യാല്ലോകാൻ മഹ്യമ് അദദാ അഹം തേഭ്യസ്തവ നാമ്നസ്തത്ത്വജ്ഞാനമ് അദദാം, തേ തവൈവാസൻ, ത്വം താൻ മഹ്യമദദാഃ, തസ്മാത്തേ തവോപദേശമ് അഗൃഹ്ലൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ത്വം മഹ്യം യത് കിഞ്ചിദ് അദദാസ്തത്സർവ്വം ത്വത്തോ ജായതേ ഇത്യധുനാജാനൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","മഹ്യം യമുപദേശമ് അദദാ അഹമപി തേഭ്യസ്തമുപദേശമ് അദദാം തേപി തമഗൃഹ്ലൻ ത്വത്തോഹം നിർഗത്യ ത്വയാ പ്രേരിതോഭവമ് അത്ര ച വ്യശ്വസൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","തേഷാമേവ നിമിത്തം പ്രാർഥയേഽഹം ജഗതോ ലോകനിമിത്തം ന പ്രാർഥയേ കിന്തു യാല്ലോകാൻ മഹ്യമ് അദദാസ്തേഷാമേവ നിമിത്തം പ്രാർഥയേഽഹം യതസ്തേ തവൈവാസതേ| ");
INSERT INTO sanmal_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","യേ മമ തേ തവ യേ ച തവ തേ മമ തഥാ തൈ ർമമ മഹിമാ പ്രകാശ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","സാമ്പ്രതമ് അസ്മിൻ ജഗതി മമാവസ്ഥിതേഃ ശേഷമ് അഭവത് അഹം തവ സമീപം ഗച്ഛാമി കിന്തു തേ ജഗതി സ്ഥാസ്യന്തി; ഹേ പവിത്ര പിതരാവയോ ര്യഥൈകത്വമാസ്തേ തഥാ തേഷാമപ്യേകത്വം ഭവതി തദർഥം യാല്ലോകാൻ മഹ്യമ് അദദാസ്താൻ സ്വനാമ്നാ രക്ഷ| ");
INSERT INTO sanmal_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","യാവന്തി ദിനാനി ജഗത്യസ്മിൻ തൈഃ സഹാഹമാസം താവന്തി ദിനാനി താൻ തവ നാമ്നാഹം രക്ഷിതവാൻ; യാല്ലോകാൻ മഹ്യമ് അദദാസ്താൻ സർവ്വാൻ അഹമരക്ഷം, തേഷാം മധ്യേ കേവലം വിനാശപാത്രം ഹാരിതം തേന ധർമ്മപുസ്തകസ്യ വചനം പ്രത്യക്ഷം ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","കിന്ത്വധുനാ തവ സന്നിധിം ഗച്ഛാമി മയാ യഥാ തേഷാം സമ്പൂർണാനന്ദോ ഭവതി തദർഥമഹം ജഗതി തിഷ്ഠൻ ഏതാഃ കഥാ അകഥയമ്| ");
INSERT INTO sanmal_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","തവോപദേശം തേഭ്യോഽദദാം ജഗതാ സഹ യഥാ മമ സമ്ബന്ധോ നാസ്തി തഥാ ജജതാ സഹ തേഷാമപി സമ്ബന്ധാഭാവാജ് ജഗതോ ലോകാസ്താൻ ഋതീയന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ത്വം ജഗതസ്താൻ ഗൃഹാണേതി ന പ്രാർഥയേ കിന്ത്വശുഭാദ് രക്ഷേതി പ്രാർഥയേഹമ്| ");
INSERT INTO sanmal_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","അഹം യഥാ ജഗത്സമ്ബന്ധീയോ ന ഭവാമി തഥാ തേപി ജഗത്സമ്ബന്ധീയാ ന ഭവന്തി| ");
INSERT INTO sanmal_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","തവ സത്യകഥയാ താൻ പവിത്രീകുരു തവ വാക്യമേവ സത്യം| ");
INSERT INTO sanmal_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ത്വം യഥാ മാം ജഗതി പ്രൈരയസ്തഥാഹമപി താൻ ജഗതി പ്രൈരയം| ");
INSERT INTO sanmal_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","തേഷാം ഹിതാർഥം യഥാഹം സ്വം പവിത്രീകരോമി തഥാ സത്യകഥയാ തേപി പവിത്രീഭവന്തു| ");
INSERT INTO sanmal_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","കേവലം ഏതേഷാമർഥേ പ്രാർഥയേഽഹമ് ഇതി ന കിന്ത്വേതേഷാമുപദേശേന യേ ജനാ മയി വിശ്വസിഷ്യന്തി തേഷാമപ്യർഥേ പ്രാർഥേയേഽഹമ്| ");
INSERT INTO sanmal_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ഹേ പിതസ്തേഷാം സർവ്വേഷാമ് ഏകത്വം ഭവതു തവ യഥാ മയി മമ ച യഥാ ത്വയ്യേകത്വം തഥാ തേഷാമപ്യാവയോരേകത്വം ഭവതു തേന ത്വം മാം പ്രേരിതവാൻ ഇതി ജഗതോ ലോകാഃ പ്രതിയന്തു| ");
INSERT INTO sanmal_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","യഥാവയോരേകത്വം തഥാ തേഷാമപ്യേകത്വം ഭവതു തേഷ്വഹം മയി ച ത്വമ് ഇത്ഥം തേഷാം സമ്പൂർണമേകത്വം ഭവതു, ത്വം പ്രേരിതവാൻ ത്വം മയി യഥാ പ്രീയസേ ച തഥാ തേഷ്വപി പ്രീതവാൻ ഏതദ്യഥാ ജഗതോ ലോകാ ജാനന്തി ");
INSERT INTO sanmal_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","തദർഥം ത്വം യം മഹിമാനം മഹ്യമ് അദദാസ്തം മഹിമാനമ് അഹമപി തേഭ്യോ ദത്തവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","ഹേ പിത ർജഗതോ നിർമ്മാണാത് പൂർവ്വം മയി സ്നേഹം കൃത്വാ യം മഹിമാനം ദത്തവാൻ മമ തം മഹിമാനം യഥാ തേ പശ്യന്തി തദർഥം യാല്ലോകാൻ മഹ്യം ദത്തവാൻ അഹം യത്ര തിഷ്ഠാമി തേപി യഥാ തത്ര തിഷ്ഠന്തി മമൈഷാ വാഞ്ഛാ| ");
INSERT INTO sanmal_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ഹേ യഥാർഥിക പിത ർജഗതോ ലോകൈസ്ത്വയ്യജ്ഞാതേപി ത്വാമഹം ജാനേ ത്വം മാം പ്രേരിതവാൻ ഇതീമേ ശിഷ്യാ ജാനന്തി| ");
INSERT INTO sanmal_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","യഥാഹം തേഷു തിഷ്ഠാമി തഥാ മയി യേന പ്രേമ്നാ പ്രേമാകരോസ്തത് തേഷു തിഷ്ഠതി തദർഥം തവ നാമാഹം താൻ ജ്ഞാപിതവാൻ പുനരപി ജ്ഞാപയിഷ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","താഃ കഥാഃ കഥയിത്വാ യീശുഃ ശിഷ്യാനാദായ കിദ്രോന്നാമകം സ്രോത ഉത്തീര്യ്യ ശിഷ്യൈഃ സഹ തത്രത്യോദ്യാനം പ്രാവിശത്| ");
INSERT INTO sanmal_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","കിന്തു വിശ്വാസഘാതിയിഹൂദാസ്തത് സ്ഥാനം പരിചീയതേ യതോ യീശുഃ ശിഷ്യൈഃ സാർദ്ധം കദാചിത് തത് സ്ഥാനമ് അഗച്ഛത്| ");
INSERT INTO sanmal_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","തദാ സ യിഹൂദാഃ സൈന്യഗണം പ്രധാനയാജകാനാം ഫിരൂശിനാഞ്ച പദാതിഗണഞ്ച ഗൃഹീത്വാ പ്രദീപാൻ ഉൽകാൻ അസ്ത്രാണി ചാദായ തസ്മിൻ സ്ഥാന ഉപസ്ഥിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","സ്വം പ്രതി യദ് ഘടിഷ്യതേ തജ് ജ്ഞാത്വാ യീശുരഗ്രേസരഃ സൻ താനപൃച്ഛത് കം ഗവേഷയഥ? ");
INSERT INTO sanmal_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","തേ പ്രത്യവദൻ, നാസരതീയം യീശും; തതോ യീശുരവാദീദ് അഹമേവ സഃ; തൈഃ സഹ വിശ്വാസഘാതീ യിഹൂദാശ്ചാതിഷ്ഠത്| ");
INSERT INTO sanmal_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","തദാഹമേവ സ തസ്യൈതാം കഥാം ശ്രുത്വൈവ തേ പശ്ചാദേത്യ ഭൂമൗ പതിതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","തതോ യീശുഃ പുനരപി പൃഷ്ഠവാൻ കം ഗവേഷയഥ? തതസ്തേ പ്രത്യവദൻ നാസരതീയം യീശും| ");
INSERT INTO sanmal_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","തദാ യീശുഃ പ്രത്യുദിതവാൻ അഹമേവ സ ഇമാം കഥാമചകഥമ്; യദി മാമന്വിച്ഛഥ തർഹീമാൻ ഗന്തും മാ വാരയത| ");
INSERT INTO sanmal_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ഇത്ഥം ഭൂതേ മഹ്യം യാല്ലോകാൻ അദദാസ്തേഷാമ് ഏകമപി നാഹാരയമ് ഇമാം യാം കഥാം സ സ്വയമകഥയത് സാ കഥാ സഫലാ ജാതാ| ");
INSERT INTO sanmal_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","തദാ ശിമോൻപിതരസ്യ നികടേ ഖങ്ഗൽസ്ഥിതേഃ സ തം നിഷ്കോഷം കൃത്വാ മഹായാജകസ്യ മാൽഖനാമാനം ദാസമ് ആഹത്യ തസ്യ ദക്ഷിണകർണം ഛിന്നവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","തതോ യീശുഃ പിതരമ് അവദത്, ഖങ്ഗം കോഷേ സ്ഥാപയ മമ പിതാ മഹ്യം പാതും യം കംസമ് അദദാത് തേനാഹം കിം ന പാസ്യാമി? ");
INSERT INTO sanmal_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","തദാ സൈന്യഗണഃ സേനാപതി ര്യിഹൂദീയാനാം പദാതയശ്ച യീശും ഘൃത്വാ ബദ്ധ്വാ ഹാനന്നാമ്നഃ കിയഫാഃ ശ്വശുരസ്യ സമീപം പ്രഥമമ് അനയൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","സ കിയഫാസ്തസ്മിൻ വത്സരേ മഹായാജത്വപദേ നിയുക്തഃ ");
INSERT INTO sanmal_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","സൻ സാധാരണലോകാനാം മങ്ഗലാർഥമ് ഏകജനസ്യ മരണമുചിതമ് ഇതി യിഹൂദീയൈഃ സാർദ്ധമ് അമന്ത്രയത്| ");
INSERT INTO sanmal_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","തദാ ശിമോൻപിതരോഽന്യൈകശിഷ്യശ്ച യീശോഃ പശ്ചാദ് അഗച്ഛതാം തസ്യാന്യശിഷ്യസ്യ മഹായാജകേന പരിചിതത്വാത് സ യീശുനാ സഹ മഹായാജകസ്യാട്ടാലികാം പ്രാവിശത്| ");
INSERT INTO sanmal_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","കിന്തു പിതരോ ബഹിർദ്വാരസ്യ സമീപേഽതിഷ്ഠദ് അതഏവ മഹായാജകേന പരിചിതഃ സ ശിഷ്യഃ പുനർബഹിർഗത്വാ ദൗവായികായൈ കഥയിത്വാ പിതരമ് അഭ്യന്തരമ് ആനയത്| ");
INSERT INTO sanmal_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","തദാ സ ദ്വാരരക്ഷികാ പിതരമ് അവദത് ത്വം കിം ന തസ്യ മാനവസ്യ ശിഷ്യഃ? തതഃ സോവദദ് അഹം ന ഭവാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","തതഃ പരം യത്സ്ഥാനേ ദാസാഃ പദാതയശ്ച ശീതഹേതോരങ്ഗാരൈ ർവഹ്നിം പ്രജ്വാല്യ താപം സേവിതവന്തസ്തത്സ്ഥാനേ പിതരസ്തിഷ്ഠൻ തൈഃ സഹ വഹ്നിതാപം സേവിതുമ് ആരഭത| ");
INSERT INTO sanmal_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","തദാ ശിഷ്യേഷൂപദേശേ ച മഹായാജകേന യീശുഃ പൃഷ്ടഃ ");
INSERT INTO sanmal_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","സൻ പ്രത്യുക്തവാൻ സർവ്വലോകാനാം സമക്ഷം കഥാമകഥയം ഗുപ്തം കാമപി കഥാം ന കഥയിത്വാ യത് സ്ഥാനം യിഹൂദീയാഃ സതതം ഗച്ഛന്തി തത്ര ഭജനഗേഹേ മന്ദിരേ ചാശിക്ഷയം| ");
INSERT INTO sanmal_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","മത്തഃ കുതഃ പൃച്ഛസി? യേ ജനാ മദുപദേശമ് അശൃണ്വൻ താനേവ പൃച്ഛ യദ്യദ് അവദം തേ തത് ജാനിന്ത| ");
INSERT INTO sanmal_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","തദേത്ഥം പ്രത്യുദിതത്വാത് നികടസ്ഥപദാതി ര്യീശും ചപേടേനാഹത്യ വ്യാഹരത് മഹായാജകമ് ഏവം പ്രതിവദസി? ");
INSERT INTO sanmal_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","തതോ യീശുഃ പ്രതിഗദിതവാൻ യദ്യയഥാർഥമ് അചകഥം തർഹി തസ്യായഥാർഥസ്യ പ്രമാണം ദേഹി, കിന്തു യദി യഥാർഥം തർഹി കുതോ ഹേതോ ർമാമ് അതാഡയഃ? ");
INSERT INTO sanmal_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","പൂർവ്വം ഹാനൻ സബന്ധനം തം കിയഫാമഹായാജകസ്യ സമീപം പ്രൈഷയത്| ");
INSERT INTO sanmal_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ശിമോൻപിതരസ്തിഷ്ഠൻ വഹ്നിതാപം സേവതേ, ഏതസ്മിൻ സമയേ കിയന്തസ്തമ് അപൃച്ഛൻ ത്വം കിമ് ഏതസ്യ ജനസ്യ ശിഷ്യോ ന? തതഃ സോപഹ്നുത്യാബ്രവീദ് അഹം ന ഭവാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","തദാ മഹായാജകസ്യ യസ്യ ദാസസ്യ പിതരഃ കർണമച്ഛിനത് തസ്യ കുടുമ്ബഃ പ്രത്യുദിതവാൻ ഉദ്യാനേ തേന സഹ തിഷ്ഠന്തം ത്വാം കിം നാപശ്യം? ");
INSERT INTO sanmal_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","കിന്തു പിതരഃ പുനരപഹ്നുത്യ കഥിതവാൻ; തദാനീം കുക്കുടോഽരൗത്| ");
INSERT INTO sanmal_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","തദനന്തരം പ്രത്യൂഷേ തേ കിയഫാഗൃഹാദ് അധിപതേ ർഗൃഹം യീശുമ് അനയൻ കിന്തു യസ്മിൻ അശുചിത്വേ ജാതേ തൈ ർനിസ്താരോത്സവേ ന ഭോക്തവ്യം, തസ്യ ഭയാദ് യിഹൂദീയാസ്തദ്ഗൃഹം നാവിശൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","അപരം പീലാതോ ബഹിരാഗത്യ താൻ പൃഷ്ഠവാൻ ഏതസ്യ മനുഷ്യസ്യ കം ദോഷം വദഥ? ");
INSERT INTO sanmal_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","തദാ തേ പേത്യവദൻ ദുഷ്കർമ്മകാരിണി ന സതി ഭവതഃ സമീപേ നൈനം സമാർപയിഷ്യാമഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","തതഃ പീലാതോഽവദദ് യൂയമേനം ഗൃഹീത്വാ സ്വേഷാം വ്യവസ്ഥയാ വിചാരയത| തദാ യിഹൂദീയാഃ പ്രത്യവദൻ കസ്യാപി മനുഷ്യസ്യ പ്രാണദണ്ഡം കർത്തും നാസ്മാകമ് അധികാരോഽസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ഏവം സതി യീശുഃ സ്വസ്യ മൃത്യൗ യാം കഥാം കഥിതവാൻ സാ സഫലാഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","തദനന്തരം പീലാതഃ പുനരപി തദ് രാജഗൃഹം ഗത്വാ യീശുമാഹൂയ പൃഷ്ടവാൻ ത്വം കിം യിഹൂദീയാനാം രാജാ? ");
INSERT INTO sanmal_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","യീശുഃ പ്രത്യവദത് ത്വമ് ഏതാം കഥാം സ്വതഃ കഥയസി കിമന്യഃ കശ്ചിൻ മയി കഥിതവാൻ? ");
INSERT INTO sanmal_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","പീലാതോഽവദദ് അഹം കിം യിഹൂദീയഃ? തവ സ്വദേശീയാ വിശേഷതഃ പ്രധാനയാജകാ മമ നികടേ ത്വാം സമാർപയന, ത്വം കിം കൃതവാൻ? ");
INSERT INTO sanmal_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","യീശുഃ പ്രത്യവദത് മമ രാജ്യമ് ഏതജ്ജഗത്സമ്ബന്ധീയം ന ഭവതി യദി മമ രാജ്യം ജഗത്സമ്ബന്ധീയമ് അഭവിഷ്യത് തർഹി യിഹൂദീയാനാം ഹസ്തേഷു യഥാ സമർപിതോ നാഭവം തദർഥം മമ സേവകാ അയോത്സ്യൻ കിന്തു മമ രാജ്യമ് ഐഹികം ന| ");
INSERT INTO sanmal_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","തദാ പീലാതഃ കഥിതവാൻ, തർഹി ത്വം രാജാ ഭവസി? യീശുഃ പ്രത്യുക്തവാൻ ത്വം സത്യം കഥയസി, രാജാഹം ഭവാമി; സത്യതായാം സാക്ഷ്യം ദാതും ജനിം ഗൃഹീത്വാ ജഗത്യസ്മിൻ അവതീർണവാൻ, തസ്മാത് സത്യധർമ്മപക്ഷപാതിനോ മമ കഥാം ശൃണ്വന്തി| ");
INSERT INTO sanmal_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","തദാ സത്യം കിം? ഏതാം കഥാം പഷ്ട്വാ പീലാതഃ പുനരപി ബഹിർഗത്വാ യിഹൂദീയാൻ അഭാഷത, അഹം തസ്യ കമപ്യപരാധം ന പ്രാപ്നോമി| ");
INSERT INTO sanmal_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","നിസ്താരോത്സവസമയേ യുഷ്മാഭിരഭിരുചിത ഏകോ ജനോ മയാ മോചയിതവ്യ ഏഷാ യുഷ്മാകം രീതിരസ്തി, അതഏവ യുഷ്മാകം നികടേ യിഹൂദീയാനാം രാജാനം കിം മോചയാമി, യുഷ്മാകമ് ഇച്ഛാ കാ? ");
INSERT INTO sanmal_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","തദാ തേ സർവ്വേ രുവന്തോ വ്യാഹരൻ ഏനം മാനുഷം നഹി ബരബ്ബാം മോചയ| കിന്തു സ ബരബ്ബാ ദസ്യുരാസീത്| ");
INSERT INTO sanmal_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","പീലാതോ യീശുമ് ആനീയ കശയാ പ്രാഹാരയത്| ");
INSERT INTO sanmal_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","പശ്ചാത് സേനാഗണഃ കണ്ടകനിർമ്മിതം മുകുടം തസ്യ മസ്തകേ സമർപ്യ വാർത്താകീവർണം രാജപരിച്ഛദം പരിധാപ്യ, ");
INSERT INTO sanmal_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ഹേ യിഹൂദീയാനാം രാജൻ നമസ്കാര ഇത്യുക്ത്വാ തം ചപേടേനാഹന്തുമ് ആരഭത| ");
INSERT INTO sanmal_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","തദാ പീലാതഃ പുനരപി ബഹിർഗത്വാ ലോകാൻ അവദത്, അസ്യ കമപ്യപരാധം ന ലഭേഽഹം, പശ്യത തദ് യുഷ്മാൻ ജ്ഞാപയിതും യുഷ്മാകം സന്നിധൗ ബഹിരേനമ് ആനയാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","തതഃ പരം യീശുഃ കണ്ടകമുകുടവാൻ വാർത്താകീവർണവസനവാംശ്ച ബഹിരാഗച്ഛത്| തതഃ പീലാത ഉക്തവാൻ ഏനം മനുഷ്യം പശ്യത| ");
INSERT INTO sanmal_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","തദാ പ്രധാനയാജകാഃ പദാതയശ്ച തം ദൃഷ്ട്വാ, ഏനം ക്രുശേ വിധ, ഏനം ക്രുശേ വിധ, ഇത്യുക്ത്വാ രവിതും ആരഭന്ത| തതഃ പീലാതഃ കഥിതവാൻ യൂയം സ്വയമ് ഏനം നീത്വാ ക്രുശേ വിധത, അഹമ് ഏതസ്യ കമപ്യപരാധം ന പ്രാപ്തവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","യിഹൂദീയാഃ പ്രത്യവദൻ അസ്മാകം യാ വ്യവസ്ഥാസ്തേ തദനുസാരേണാസ്യ പ്രാണഹനനമ് ഉചിതം യതോയം സ്വമ് ഈശ്വരസ്യ പുത്രമവദത്| ");
INSERT INTO sanmal_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","പീലാത ഇമാം കഥാം ശ്രുത്വാ മഹാത്രാസയുക്തഃ ");
INSERT INTO sanmal_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","സൻ പുനരപി രാജഗൃഹ ആഗത്യ യീശും പൃഷ്ടവാൻ ത്വം കുത്രത്യോ ലോകഃ? കിന്തു യീശസ്തസ്യ കിമപി പ്രത്യുത്തരം നാവദത്| ");
INSERT INTO sanmal_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","1॰ തതഃ പീലാത് കഥിതവാന ത്വം കിം മയാ സാർദ്ധം ന സംലപിഷ്യസി ? ത്വാം ക്രുശേ വേധിതും വാ മോചയിതും ശക്തി ർമമാസ്തേ ഇതി കിം ത്വം ന ജാനാസി ? തദാ യീശുഃ പ്രത്യവദദ് ഈശ്വരേണാദŸाം മമോപരി തവ കിമപ്യധിപതിത്വം ന വിദ്യതേ, തഥാപി യോ ജനോ മാം തവ ഹസ്തേ സമാർപയത് തസ്യ മഹാപാതകം ജാതമ്| ");
INSERT INTO sanmal_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","തദാ യീശുഃ പ്രത്യവദദ് ഈശ്വരേണാദത്തം മമോപരി തവ കിമപ്യധിപതിത്വം ന വിദ്യതേ, തഥാപി യോ ജനോ മാം തവ ഹസ്തേ സമാർപയത് തസ്യ മഹാപാതകം ജാതമ്| ");
INSERT INTO sanmal_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","തദാരഭ്യ പീലാതസ്തം മോചയിതും ചേഷ്ടിതവാൻ കിന്തു യിഹൂദീയാ രുവന്തോ വ്യാഹരൻ യദീമം മാനവം ത്യജസി തർഹി ത്വം കൈസരസ്യ മിത്രം ന ഭവസി, യോ ജനഃ സ്വം രാജാനം വക്തി സഏവ കൈമരസ്യ വിരുദ്ധാം കഥാം കഥയതി| ");
INSERT INTO sanmal_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ഏതാം കഥാം ശ്രുത്വാ പീലാതോ യീശും ബഹിരാനീയ നിസ്താരോത്സവസ്യ ആസാദനദിനസ്യ ദ്വിതീയപ്രഹരാത് പൂർവ്വം പ്രസ്തരബന്ധനനാമ്നി സ്ഥാനേ ഽർഥാത് ഇബ്രീയഭാഷയാ യദ് ഗബ്ബിഥാ കഥ്യതേ തസ്മിൻ സ്ഥാനേ വിചാരാസന ഉപാവിശത്| ");
INSERT INTO sanmal_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","അനന്തരം പീലാതോ യിഹൂദീയാൻ അവദത്, യുഷ്മാകം രാജാനം പശ്യത| ");
INSERT INTO sanmal_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","കിന്തു ഏനം ദൂരീകുരു, ഏനം ദൂരീകുരു, ഏനം ക്രുശേ വിധ, ഇതി കഥാം കഥയിത്വാ തേ രവിതുമ് ആരഭന്ത; തദാ പീലാതഃ കഥിതവാൻ യുഷ്മാകം രാജാനം കിം ക്രുശേ വേധിഷ്യാമി? പ്രധാനയാജകാ ഉത്തരമ് അവദൻ കൈസരം വിനാ കോപി രാജാസ്മാകം നാസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","തതഃ പീലാതോ യീശും ക്രുശേ വേധിതും തേഷാം ഹസ്തേഷു സമാർപയത്, തതസ്തേ തം ധൃത്വാ നീതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","തതഃ പരം യീശുഃ ക്രുശം വഹൻ ശിരഃകപാലമ് അർഥാദ് യദ് ഇബ്രീയഭാഷയാ ഗുൽഗൽതാം വദന്തി തസ്മിൻ സ്ഥാന ഉപസ്ഥിതഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","തതസ്തേ മധ്യസ്ഥാനേ തം തസ്യോഭയപാർശ്വേ ദ്വാവപരൗ ക്രുശേഽവിധൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","അപരമ് ഏഷ യിഹൂദീയാനാം രാജാ നാസരതീയയീശുഃ, ഇതി വിജ്ഞാപനം ലിഖിത്വാ പീലാതസ്തസ്യ ക്രുശോപരി സമയോജയത്| ");
INSERT INTO sanmal_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","സാ ലിപിഃ ഇബ്രീയയൂനാനീയരോമീയഭാഷാഭി ർലിഖിതാ; യീശോഃ ക്രുശവേധനസ്ഥാനം നഗരസ്യ സമീപം, തസ്മാദ് ബഹവോ യിഹൂദീയാസ്താം പഠിതുമ് ആരഭന്ത| ");
INSERT INTO sanmal_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","യിഹൂദീയാനാം പ്രധാനയാജകാഃ പീലാതമിതി ന്യവേദയൻ യിഹൂദീയാനാം രാജേതി വാക്യം ന കിന്തു ഏഷ സ്വം യിഹൂദീയാനാം രാജാനമ് അവദദ് ഇത്ഥം ലിഖതു| ");
INSERT INTO sanmal_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","തതഃ പീലാത ഉത്തരം ദത്തവാൻ യല്ലേഖനീയം തല്ലിഖിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ഇത്ഥം സേനാഗണോ യീശും ക്രുശേ വിധിത്വാ തസ്യ പരിധേയവസ്ത്രം ചതുരോ ഭാഗാൻ കൃത്വാ ഏകൈകസേനാ ഏകൈകഭാഗമ് അഗൃഹ്ലത് തസ്യോത്തരീയവസ്ത്രഞ്ചാഗൃഹ്ലത്| കിന്തൂത്തരീയവസ്ത്രം സൂചിസേവനം വിനാ സർവ്വമ് ഊതം| ");
INSERT INTO sanmal_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","തസ്മാത്തേ വ്യാഹരൻ ഏതത് കഃ പ്രാപ്സ്യതി? തന്ന ഖണ്ഡയിത്വാ തത്ര ഗുടികാപാതം കരവാമ| വിഭജന്തേഽധരീയം മേ വസനം തേ പരസ്പരം| മമോത്തരീയവസ്ത്രാർഥം ഗുടികാം പാതയന്തി ച| ഇതി യദ്വാക്യം ധർമ്മപുസ്തകേ ലിഖിതമാസ്തേ തത് സേനാഗണേനേത്ഥം വ്യവഹരണാത് സിദ്ധമഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","തദാനീം യീശോ ർമാതാ മാതു ർഭഗിനീ ച യാ ക്ലിയപാ ഭാര്യ്യാ മരിയമ് മഗ്ദലീനീ മരിയമ് ച ഏതാസ്തസ്യ ക്രുശസ്യ സന്നിധൗ സമതിഷ്ഠൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","തതോ യീശുഃ സ്വമാതരം പ്രിയതമശിഷ്യഞ്ച സമീപേ ദണ്ഡായമാനൗ വിലോക്യ മാതരമ് അവദത്, ഹേ യോഷിദ് ഏനം തവ പുത്രം പശ്യ, ");
INSERT INTO sanmal_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ശിഷ്യന്ത്വവദത്, ഏനാം തവ മാതരം പശ്യ| തതഃ സ ശിഷ്യസ്തദ്ഘടികായാം താം നിജഗൃഹം നീതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","അനന്തരം സർവ്വം കർമ്മാധുനാ സമ്പന്നമഭൂത് യീശുരിതി ജ്ഞാത്വാ ധർമ്മപുസ്തകസ്യ വചനം യഥാ സിദ്ധം ഭവതി തദർഥമ് അകഥയത് മമ പിപാസാ ജാതാ| ");
INSERT INTO sanmal_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","തതസ്തസ്മിൻ സ്ഥാനേ അമ്ലരസേന പൂർണപാത്രസ്ഥിത്യാ തേ സ്പഞ്ജമേകം തദമ്ലരസേനാർദ്രീകൃത്യ ഏസോബ്നലേ തദ് യോജയിത്വാ തസ്യ മുഖസ്യ സന്നിധാവസ്ഥാപയൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","തദാ യീശുരമ്ലരസം ഗൃഹീത്വാ സർവ്വം സിദ്ധമ് ഇതി കഥാം കഥയിത്വാ മസ്തകം നമയൻ പ്രാണാൻ പര്യ്യത്യജത്| ");
INSERT INTO sanmal_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","തദ്വിനമ് ആസാദനദിനം തസ്മാത് പരേഽഹനി വിശ്രാമവാരേ ദേഹാ യഥാ ക്രുശോപരി ന തിഷ്ഠന്തി, യതഃ സ വിശ്രാമവാരോ മഹാദിനമാസീത്, തസ്മാദ് യിഹൂദീയാഃ പീലാതനികടം ഗത്വാ തേഷാം പാദഭഞ്ജനസ്യ സ്ഥാനാന്തരനയനസ്യ ചാനുമതിം പ്രാർഥയന്ത| ");
INSERT INTO sanmal_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","അതഃ സേനാ ആഗത്യ യീശുനാ സഹ ക്രുശേ ഹതയോഃ പ്രഥമദ്വിതീയചോരയോഃ പാദാൻ അഭഞ്ജൻ; ");
INSERT INTO sanmal_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","കിന്തു യീശോഃ സന്നിധിം ഗത്വാ സ മൃത ഇതി ദൃഷ്ട്വാ തസ്യ പാദൗ നാഭഞ്ജൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","പശ്ചാദ് ഏകോ യോദ്ധാ ശൂലാഘാതേന തസ്യ കുക്ഷിമ് അവിധത് തത്ക്ഷണാത് തസ്മാദ് രക്തം ജലഞ്ച നിരഗച്ഛത്| ");
INSERT INTO sanmal_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","യോ ജനോഽസ്യ സാക്ഷ്യം ദദാതി സ സ്വയം ദൃഷ്ടവാൻ തസ്യേദം സാക്ഷ്യം സത്യം തസ്യ കഥാ യുഷ്മാകം വിശ്വാസം ജനയിതും യോഗ്യാ തത് സ ജാനാതി| ");
INSERT INTO sanmal_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","തസ്യൈകമ് അസ്ധ്യപി ന ഭംക്ഷ്യതേ, ");
INSERT INTO sanmal_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","തദ്വദ് അന്യശാസ്ത്രേപി ലിഖ്യതേ, യഥാ, \"ദൃഷ്ടിപാതം കരിഷ്യന്തി തേഽവിധൻ യന്തു തമ്പ്രതി| \" ");
INSERT INTO sanmal_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","അരിമഥീയനഗരസ്യ യൂഷഫ്നാമാ ശിഷ്യ ഏക ആസീത് കിന്തു യിഹൂദീയേഭ്യോ ഭയാത് പ്രകാശിതോ ന ഭവതി; സ യീശോ ർദേഹം നേതും പീലാതസ്യാനുമതിം പ്രാർഥയത, തതഃ പീലാതേനാനുമതേ സതി സ ഗത്വാ യീശോ ർദേഹമ് അനയത്| ");
INSERT INTO sanmal_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","അപരം യോ നികദീമോ രാത്രൗ യീശോഃ സമീപമ് അഗച്ഛത് സോപി ഗന്ധരസേന മിശ്രിതം പ്രായേണ പഞ്ചാശത്സേടകമഗുരും ഗൃഹീത്വാഗച്ഛത്| ");
INSERT INTO sanmal_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","തതസ്തേ യിഹൂദീയാനാം ശ്മശാനേ സ്ഥാപനരീത്യനുസാരേണ തത്സുഗന്ധിദ്രവ്യേണ സഹിതം തസ്യ ദേഹം വസ്ത്രേണാവേഷ്ടയൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","അപരഞ്ച യത്ര സ്ഥാനേ തം ക്രുശേഽവിധൻ തസ്യ നികടസ്ഥോദ്യാനേ യത്ര കിമപി മൃതദേഹം കദാപി നാസ്ഥാപ്യത താദൃശമ് ഏകം നൂതനം ശ്മശാനമ് ആസീത്| ");
INSERT INTO sanmal_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","യിഹൂദീയാനാമ് ആസാദനദിനാഗമനാത് തേ തസ്മിൻ സമീപസ്ഥശ്മശാനേ യീശുമ് അശായയൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","അനന്തരം സപ്താഹസ്യ പ്രഥമദിനേ ഽതിപ്രത്യൂഷേ ഽന്ധകാരേ തിഷ്ഠതി മഗ്ദലീനീ മരിയമ് തസ്യ ശ്മശാനസ്യ നികടം ഗത്വാ ശ്മശാനസ്യ മുഖാത് പ്രസ്തരമപസാരിതമ് അപശ്യത്| ");
INSERT INTO sanmal_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","പശ്ചാദ് ധാവിത്വാ ശിമോൻപിതരായ യീശോഃ പ്രിയതമശിഷ്യായ ചേദമ് അകഥയത്, ലോകാഃ ശ്മശാനാത് പ്രഭും നീത്വാ കുത്രാസ്ഥാപയൻ തദ് വക്തും ന ശക്നോമി| ");
INSERT INTO sanmal_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","അതഃ പിതരഃ സോന്യശിഷ്യശ്ച ബർഹി ർഭുത്വാ ശ്മശാനസ്ഥാനം ഗന്തുമ് ആരഭേതാം| ");
INSERT INTO sanmal_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ഉഭയോർധാവതോഃ സോന്യശിഷ്യഃ പിതരം പശ്ചാത് ത്യക്ത്വാ പൂർവ്വം ശ്മശാനസ്ഥാന ഉപസ്ഥിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","തദാ പ്രഹ്വീഭൂയ സ്ഥാപിതവസ്ത്രാണി ദൃഷ്ടവാൻ കിന്തു ന പ്രാവിശത്| ");
INSERT INTO sanmal_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","അപരം ശിമോൻപിതര ആഗത്യ ശ്മശാനസ്ഥാനം പ്രവിശ്യ ");
INSERT INTO sanmal_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","സ്ഥാപിതവസ്ത്രാണി മസ്തകസ്യ വസ്ത്രഞ്ച പൃഥക് സ്ഥാനാന്തരേ സ്ഥാപിതം ദൃഷ്ടവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","തതഃ ശ്മശാനസ്ഥാനം പൂർവ്വമ് ആഗതോ യോന്യശിഷ്യഃ സോപി പ്രവിശ്യ താദൃശം ദൃഷ്ടാ വ്യശ്വസീത്| ");
INSERT INTO sanmal_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","യതഃ ശ്മശാനാത് സ ഉത്ഥാപയിതവ്യ ഏതസ്യ ധർമ്മപുസ്തകവചനസ്യ ഭാവം തേ തദാ വോദ്ധും നാശൻകുവൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","അനന്തരം തൗ ദ്വൗ ശിഷ്യൗ സ്വം സ്വം ഗൃഹം പരാവൃത്യാഗച്ഛതാമ്| ");
INSERT INTO sanmal_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","തതഃ പരം മരിയമ് ശ്മശാനദ്വാരസ്യ ബഹിഃ സ്ഥിത്വാ രോദിതുമ് ആരഭത തതോ രുദതീ പ്രഹ്വീഭൂയ ശ്മശാനം വിലോക്യ ");
INSERT INTO sanmal_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","യീശോഃ ശയനസ്ഥാനസ്യ ശിരഃസ്ഥാനേ പദതലേ ച ദ്വയോ ർദിശോ ദ്വൗ സ്വർഗീയദൂതാവുപവിഷ്ടൗ സമപശ്യത്| ");
INSERT INTO sanmal_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","തൗ പൃഷ്ടവന്തൗ ഹേ നാരി കുതോ രോദിഷി? സാവദത് ലോകാ മമ പ്രഭും നീത്വാ കുത്രാസ്ഥാപയൻ ഇതി ന ജാനാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ഇത്യുക്ത്വാ മുഖം പരാവൃത്യ യീശും ദണ്ഡായമാനമ് അപശ്യത് കിന്തു സ യീശുരിതി സാ ജ്ഞാതും നാശക്നോത്| ");
INSERT INTO sanmal_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","തദാ യീശുസ്താമ് അപൃച്ഛത് ഹേ നാരി കുതോ രോദിഷി? കം വാ മൃഗയസേ? തതഃ സാ തമ് ഉദ്യാനസേവകം ജ്ഞാത്വാ വ്യാഹരത്, ഹേ മഹേച്ഛ ത്വം യദീതഃ സ്ഥാനാത് തം നീതവാൻ തർഹി കുത്രാസ്ഥാപയസ്തദ് വദ തത്സ്ഥാനാത് തമ് ആനയാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","തദാ യീശുസ്താമ് അവദത് ഹേ മരിയമ്| തതഃ സാ പരാവൃത്യ പ്രത്യവദത് ഹേ രബ്ബൂനീ അർഥാത് ഹേ ഗുരോ| ");
INSERT INTO sanmal_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","തദാ യീശുരവദത് മാം മാ ധര, ഇദാനീം പിതുഃ സമീപേ ഊർദ്ധ്വഗമനം ന കരോമി കിന്തു യോ മമ യുഷ്മാകഞ്ച പിതാ മമ യുഷ്മാകഞ്ചേശ്വരസ്തസ്യ നികട ഊർദ്ധ്വഗമനം കർത്തുമ് ഉദ്യതോസ്മി, ഇമാം കഥാം ത്വം ഗത്വാ മമ ഭ്രാതൃഗണം ജ്ഞാപയ| ");
INSERT INTO sanmal_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","തതോ മഗ്ദലീനീമരിയമ് തത്ക്ഷണാദ് ഗത്വാ പ്രഭുസ്തസ്യൈ ദർശനം ദത്ത്വാ കഥാ ഏതാ അകഥയദ് ഇതി വാർത്താം ശിഷ്യേഭ്യോഽകഥയത്| ");
INSERT INTO sanmal_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","തതഃ പരം സപ്താഹസ്യ പ്രഥമദിനസ്യ സന്ധ്യാസമയേ ശിഷ്യാ ഏകത്ര മിലിത്വാ യിഹൂദീയേഭ്യോ ഭിയാ ദ്വാരരുദ്ധമ് അകുർവ്വൻ, ഏതസ്മിൻ കാലേ യീശുസ്തേഷാം മധ്യസ്ഥാനേ തിഷ്ഠൻ അകഥയദ് യുഷ്മാകം കല്യാണം ഭൂയാത്| ");
INSERT INTO sanmal_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ഇത്യുക്ത്വാ നിജഹസ്തം കുക്ഷിഞ്ച ദർശിതവാൻ, തതഃ ശിഷ്യാഃ പ്രഭും ദൃഷ്ട്വാ ഹൃഷ്ടാ അഭവൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","യീശുഃ പുനരവദദ് യുഷ്മാകം കല്യാണം ഭൂയാത് പിതാ യഥാ മാം പ്രൈഷയത് തഥാഹമപി യുഷ്മാൻ പ്രേഷയാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ഇത്യുക്ത്വാ സ തേഷാമുപരി ദീർഘപ്രശ്വാസം ദത്ത്വാ കഥിതവാൻ പവിത്രമ് ആത്മാനം ഗൃഹ്ലീത| ");
INSERT INTO sanmal_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","യൂയം യേഷാം പാപാനി മോചയിഷ്യഥ തേ മോചയിഷ്യന്തേ യേഷാഞ്ച പാപാതി ന മോചയിഷ്യഥ തേ ന മോചയിഷ്യന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","ദ്വാദശമധ്യേ ഗണിതോ യമജോ ഥോമാനാമാ ശിഷ്യോ യീശോരാഗമനകാലൈ തൈഃ സാർദ്ധം നാസീത്| ");
INSERT INTO sanmal_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","അതോ വയം പ്രഭൂമ് അപശ്യാമേതി വാക്യേഽന്യശിഷ്യൈരുക്തേ സോവദത്, തസ്യ ഹസ്തയോ ർലൗഹകീലകാനാം ചിഹ്നം ന വിലോക്യ തച്ചിഹ്നമ് അങ്ഗുല്യാ ന സ്പൃഷ്ട്വാ തസ്യ കുക്ഷൗ ഹസ്തം നാരോപ്യ ചാഹം ന വിശ്വസിഷ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","അപരമ് അഷ്ടമേഽഹ്നി ഗതേ സതി ഥോമാസഹിതഃ ശിഷ്യഗണ ഏകത്ര മിലിത്വാ ദ്വാരം രുദ്ധ്വാഭ്യന്തര ആസീത്, ഏതർഹി യീശുസ്തേഷാം മധ്യസ്ഥാനേ തിഷ്ഠൻ അകഥയത്, യുഷ്മാകം കുശലം ഭൂയാത്| ");
INSERT INTO sanmal_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","പശ്ചാത് ഥാമൈ കഥിതവാൻ ത്വമ് അങ്ഗുലീമ് അത്രാർപയിത്വാ മമ കരൗ പശ്യ കരം പ്രസാര്യ്യ മമ കുക്ഷാവർപയ നാവിശ്വസ്യ| ");
INSERT INTO sanmal_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","തദാ ഥോമാ അവദത്, ഹേ മമ പ്രഭോ ഹേ മദീശ്വര| ");
INSERT INTO sanmal_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","യീശുരകഥയത്, ഹേ ഥോമാ മാം നിരീക്ഷ്യ വിശ്വസിഷി യേ ന ദൃഷ്ട്വാ വിശ്വസന്തി തഏവ ധന്യാഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ഏതദന്യാനി പുസ്തകേഽസ്മിൻ അലിഖിതാനി ബഹൂന്യാശ്ചര്യ്യകർമ്മാണി യീശുഃ ശിഷ്യാണാം പുരസ്താദ് അകരോത്| ");
INSERT INTO sanmal_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","കിന്തു യീശുരീശ്വരസ്യാഭിഷിക്തഃ സുത ഏവേതി യഥാ യൂയം വിശ്വസിഥ വിശ്വസ്യ ച തസ്യ നാമ്നാ പരമായുഃ പ്രാപ്നുഥ തദർഥമ് ഏതാനി സർവ്വാണ്യലിഖ്യന്ത| ");
INSERT INTO sanmal_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","തതഃ പരം തിബിരിയാജലധേസ്തടേ യീശുഃ പുനരപി ശിഷ്യേഭ്യോ ദർശനം ദത്തവാൻ ദർശനസ്യാഖ്യാനമിദമ്| ");
INSERT INTO sanmal_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ശിമോൻപിതരഃ യമജഥോമാ ഗാലീലീയകാന്നാനഗരനിവാസീ നിഥനേൽ സിവദേഃ പുത്രാവന്യൗ ദ്വൗ ശിഷ്യൗ ചൈതേഷ്വേകത്ര മിലിതേഷു ശിമോൻപിതരോഽകഥയത് മത്സ്യാൻ ധർതും യാമി| ");
INSERT INTO sanmal_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","തതസ്തേ വ്യാഹരൻ തർഹി വയമപി ത്വയാ സാർദ്ധം യാമഃ തദാ തേ ബഹിർഗതാഃ സന്തഃ ക്ഷിപ്രം നാവമ് ആരോഹൻ കിന്തു തസ്യാം രജന്യാമ് ഏകമപി ന പ്രാപ്നുവൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","പ്രഭാതേ സതി യീശുസ്തടേ സ്ഥിതവാൻ കിന്തു സ യീശുരിതി ശിഷ്യാ ജ്ഞാതും നാശക്നുവൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","തദാ യീശുരപൃച്ഛത്, ഹേ വത്സാ സന്നിധൗ കിഞ്ചിത് ഖാദ്യദ്രവ്യമ് ആസ്തേ? തേഽവദൻ കിമപി നാസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","തദാ സോഽവദത് നൗകായാ ദക്ഷിണപാർശ്വേ ജാലം നിക്ഷിപത തതോ ലപ്സ്യധ്വേ, തസ്മാത് തൈ ർനിക്ഷിപ്തേ ജാലേ മത്സ്യാ ഏതാവന്തോഽപതൻ യേന തേ ജാലമാകൃഷ്യ നോത്തോലയിതും ശക്താഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","തസ്മാദ് യീശോഃ പ്രിയതമശിഷ്യഃ പിതരായാകഥയത് ഏഷ പ്രഭു ർഭവേത്, ഏഷ പ്രഭുരിതി വാചം ശ്രുത്വൈവ ശിമോൻ നഗ്നതാഹേതോ ർമത്സ്യധാരിണ ഉത്തരീയവസ്ത്രം പരിധായ ഹ്രദം പ്രത്യുദലമ്ഫയത്| ");
INSERT INTO sanmal_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","അപരേ ശിഷ്യാ മത്സ്യൈഃ സാർദ്ധം ജാലമ് ആകർഷന്തഃ ക്ഷുദ്രനൗകാം വാഹയിത്വാ കൂലമാനയൻ തേ കൂലാദ് അതിദൂരേ നാസൻ ദ്വിശതഹസ്തേഭ്യോ ദൂര ആസൻ ഇത്യനുമീയതേ| ");
INSERT INTO sanmal_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","തീരം പ്രാപ്തൈസ്തൈസ്തത്ര പ്രജ്വലിതാഗ്നിസ്തദുപരി മത്സ്യാഃ പൂപാശ്ച ദൃഷ്ടാഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","തതോ യീശുരകഥയദ് യാൻ മത്സ്യാൻ അധരത തേഷാം കതിപയാൻ ആനയത| ");
INSERT INTO sanmal_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","അതഃ ശിമോൻപിതരഃ പരാവൃത്യ ഗത്വാ ബൃഹദ്ഭിസ്ത്രിപഞ്ചാശദധികശതമത്സ്യൈഃ പരിപൂർണം തജ്ജാലമ് ആകൃഷ്യോദതോലയത് കിന്ത്വേതാവദ്ഭി ർമത്സ്യൈരപി ജാലം നാഛിദ്യത| ");
INSERT INTO sanmal_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","അനന്തരം യീശുസ്താൻ അവാദീത് യൂയമാഗത്യ ഭുംഗ്ധ്വം; തദാ സഏവ പ്രഭുരിതി ജ്ഞാതത്വാത് ത്വം കഃ? ഇതി പ്രഷ്ടും ശിഷ്യാണാം കസ്യാപി പ്രഗൽഭതാ നാഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","തതോ യീശുരാഗത്യ പൂപാൻ മത്സ്യാംശ്ച ഗൃഹീത്വാ തേഭ്യഃ പര്യ്യവേഷയത്| ");
INSERT INTO sanmal_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ഇത്ഥം ശ്മശാനാദുത്ഥാനാത് പരം യീശുഃ ശിഷ്യേഭ്യസ്തൃതീയവാരം ദർശനം ദത്തവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ഭോജനേ സമാപ്തേ സതി യീശുഃ ശിമോൻപിതരം പൃഷ്ടവാൻ, ഹേ യൂനസഃ പുത്ര ശിമോൻ ത്വം കിമ് ഏതേഭ്യോധികം മയി പ്രീയസേ? തതഃ സ ഉദിതവാൻ സത്യം പ്രഭോ ത്വയി പ്രീയേഽഹം തദ് ഭവാൻ ജാനാതി; തദാ യീശുരകഥയത് തർഹി മമ മേഷശാവകഗണം പാലയ| ");
INSERT INTO sanmal_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","തതഃ സ ദ്വിതീയവാരം പൃഷ്ടവാൻ ഹേ യൂനസഃ പുത്ര ശിമോൻ ത്വം കിം മയി പ്രീയസേ? തതഃ സ ഉക്തവാൻ സത്യം പ്രഭോ ത്വയി പ്രീയേഽഹം തദ് ഭവാൻ ജാനാതി; തദാ യീശുരകഥയത തർഹി മമ മേഷഗണം പാലയ| ");
INSERT INTO sanmal_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","പശ്ചാത് സ തൃതീയവാരം പൃഷ്ടവാൻ, ഹേ യൂനസഃ പുത്ര ശിമോൻ ത്വം കിം മയി പ്രീയസേ? ഏതദ്വാക്യം തൃതീയവാരം പൃഷ്ടവാൻ തസ്മാത് പിതരോ ദുഃഖിതോ ഭൂത്വാഽകഥയത് ഹേ പ്രഭോ ഭവതഃ കിമപ്യഗോചരം നാസ്തി ത്വയ്യഹം പ്രീയേ തദ് ഭവാൻ ജാനാതി; തതോ യീശുരവദത് തർഹി മമ മേഷഗണം പാലയ| ");
INSERT INTO sanmal_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","അഹം തുഭ്യം യഥാർഥം കഥയാമി യൗവനകാലേ സ്വയം ബദ്ധകടി ര്യത്രേച്ഛാ തത്ര യാതവാൻ കിന്ത്വിതഃ പരം വൃദ്ധേ വയസി ഹസ്തം വിസ്താരയിഷ്യസി, അന്യജനസ്ത്വാം ബദ്ധ്വാ യത്ര ഗന്തും തവേച്ഛാ ന ഭവതി ത്വാം ധൃത്വാ തത്ര നേഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ഫലതഃ കീദൃശേന മരണേന സ ഈശ്വരസ്യ മഹിമാനം പ്രകാശയിഷ്യതി തദ് ബോധയിതും സ ഇതി വാക്യം പ്രോക്തവാൻ| ഇത്യുക്തേ സതി സ തമവോചത് മമ പശ്ചാദ് ആഗച്ഛ| ");
INSERT INTO sanmal_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","യോ ജനോ രാത്രികാലേ യീശോ ർവക്ഷോഽവലമ്ബ്യ, ഹേ പ്രഭോ കോ ഭവന്തം പരകരേഷു സമർപയിഷ്യതീതി വാക്യം പൃഷ്ടവാൻ, തം യീശോഃ പ്രിയതമശിഷ്യം പശ്ചാദ് ആഗച്ഛന്തം ");
INSERT INTO sanmal_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","പിതരോ മുഖം പരാവർത്ത്യ വിലോക്യ യീശും പൃഷ്ടവാൻ, ഹേ പ്രഭോ ഏതസ്യ മാനവസ്യ കീദൃശീ ഗതി ർഭവിഷ്യതി? ");
INSERT INTO sanmal_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","സ പ്രത്യവദത്, മമ പുനരാഗമനപര്യ്യന്തം യദി തം സ്ഥാപയിതുമ് ഇച്ഛാമി തത്ര തവ കിം? ത്വം മമ പശ്ചാദ് ആഗച്ഛ| ");
INSERT INTO sanmal_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","തസ്മാത് സ ശിഷ്യോ ന മരിഷ്യതീതി ഭ്രാതൃഗണമധ്യേ കിംവദന്തീ ജാതാ കിന്തു സ ന മരിഷ്യതീതി വാക്യം യീശു ർനാവദത് കേവലം മമ പുനരാഗമനപര്യ്യന്തം യദി തം സ്ഥാപയിതുമ് ഇച്ഛാമി തത്ര തവ കിം? ഇതി വാക്യമ് ഉക്തവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","യോ ജന ഏതാനി സർവ്വാണി ലിഖിതവാൻ അത്ര സാക്ഷ്യഞ്ച ദത്തവാൻ സഏവ സ ശിഷ്യഃ, തസ്യ സാക്ഷ്യം പ്രമാണമിതി വയം ജാനീമഃ| ");
INSERT INTO sanmal_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","യീശുരേതേഭ്യോഽപരാണ്യപി ബഹൂനി കർമ്മാണി കൃതവാൻ താനി സർവ്വാണി യദ്യേകൈകം കൃത്വാ ലിഖ്യന്തേ തർഹി ഗ്രന്ഥാ ഏതാവന്തോ ഭവന്തി തേഷാം ധാരണേ പൃഥിവ്യാം സ്ഥാനം ന ഭവതി| ഇതി||");
INSERT INTO sanmal_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","ഹേ ഥിയഫില, യീശുഃ സ്വമനോനീതാൻ പ്രേരിതാൻ പവിത്രേണാത്മനാ സമാദിശ്യ യസ്മിൻ ദിനേ സ്വർഗമാരോഹത് യാം യാം ക്രിയാമകരോത് യദ്യദ് ഉപാദിശച്ച താനി സർവ്വാണി പൂർവ്വം മയാ ലിഖിതാനി| ");
INSERT INTO sanmal_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","സ സ്വനിധനദുഃഖഭോഗാത് പരമ് അനേകപ്രത്യയക്ഷപ്രമാണൗഃ സ്വം സജീവം ദർശയിത്വാ ");
INSERT INTO sanmal_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ചത്വാരിംശദ്ദിനാനി യാവത് തേഭ്യഃ പ്രേരിതേഭ്യോ ദർശനം ദത്ത്വേശ്വരീയരാജ്യസ്യ വർണനമ അകരോത്| ");
INSERT INTO sanmal_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","അനന്തരം തേഷാം സഭാം കൃത്വാ ഇത്യാജ്ഞാപയത്, യൂയം യിരൂശാലമോഽന്യത്ര ഗമനമകൃത്വാ യസ്തിൻ പിത്രാങ്ഗീകൃതേ മമ വദനാത് കഥാ അശൃണുത തത്പ്രാപ്തിമ് അപേക്ഷ്യ തിഷ്ഠത| ");
INSERT INTO sanmal_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","യോഹൻ ജലേ മജ്ജിതാവാൻ കിന്ത്വൽപദിനമധ്യേ യൂയം പവിത്ര ആത്മനി മജ്ജിതാ ഭവിഷ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","പശ്ചാത് തേ സർവ്വേ മിലിത്വാ തമ് അപൃച്ഛൻ ഹേ പ്രഭോ ഭവാൻ കിമിദാനീം പുനരപി രാജ്യമ് ഇസ്രായേലീയലോകാനാം കരേഷു സമർപയിഷ്യതി? ");
INSERT INTO sanmal_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","തതഃ സോവദത് യാൻ സർവ്വാൻ കാലാൻ സമയാംശ്ച പിതാ സ്വവശേഽസ്ഥാപയത് താൻ ജ്ഞാതൃം യുഷ്മാകമ് അധികാരോ ന ജായതേ| ");
INSERT INTO sanmal_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","കിന്തു യുഷ്മാസു പവിത്രസ്യാത്മന ആവിർഭാവേ സതി യൂയം ശക്തിം പ്രാപ്യ യിരൂശാലമി സമസ്തയിഹൂദാശോമിരോണദേശയോഃ പൃഥിവ്യാഃ സീമാം യാവദ് യാവന്തോ ദേശാസ്തേഷു യർവ്വേഷു ച മയി സാക്ഷ്യം ദാസ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ഇതി വാക്യമുക്ത്വാ സ തേഷാം സമക്ഷം സ്വർഗം നീതോഽഭവത്, തതോ മേഘമാരുഹ്യ തേഷാം ദൃഷ്ടേരഗോചരോഽഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","യസ്മിൻ സമയേ തേ വിഹായസം പ്രത്യനന്യദൃഷ്ട്യാ തസ്യ താദൃശമ് ഊർദ്വ്വഗമനമ് അപശ്യൻ തസ്മിന്നേവ സമയേ ശുക്ലവസ്ത്രൗ ദ്വൗ ജനൗ തേഷാം സന്നിധൗ ദണ്ഡായമാനൗ കഥിതവന്തൗ, ");
INSERT INTO sanmal_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ഹേ ഗാലീലീയലോകാ യൂയം കിമർഥം ഗഗണം പ്രതി നിരീക്ഷ്യ ദണ്ഡായമാനാസ്തിഷ്ഠഥ? യുഷ്മാകം സമീപാത് സ്വർഗം നീതോ യോ യീശുസ്തം യൂയം യഥാ സ്വർഗമ് ആരോഹന്തമ് അദർശമ് തഥാ സ പുനശ്ചാഗമിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","തതഃ പരം തേ ജൈതുനനാമ്നഃ പർവ്വതാദ് വിശ്രാമവാരസ്യ പഥഃ പരിമാണമ് അർഥാത് പ്രായേണാർദ്ധക്രോശം ദുരസ്ഥം യിരൂശാലമ്നഗരം പരാവൃത്യാഗച്ഛൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","നഗരം പ്രവിശ്യ പിതരോ യാകൂബ് യോഹൻ ആന്ദ്രിയഃ ഫിലിപഃ ഥോമാ ബർഥജമയോ മഥിരാൽഫീയപുത്രോ യാകൂബ് ഉദ്യോഗാी ശിമോൻ യാകൂബോ ഭ്രാതാ യിഹൂദാ ഏതേ സർവ്വേ യത്ര സ്ഥാനേ പ്രവസന്തി തസ്മിൻ ഉപരിതനപ്രകോഷ്ഠേ പ്രാവിശൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","പശ്ചാദ് ഇമേ കിയത്യഃ സ്ത്രിയശ്ച യീശോ ർമാതാ മരിയമ് തസ്യ ഭ്രാതരശ്ചൈതേ സർവ്വ ഏകചിത്തീഭൂത സതതം വിനയേന വിനയേന പ്രാർഥയന്ത| ");
INSERT INTO sanmal_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","തസ്മിൻ സമയേ തത്ര സ്ഥാനേ സാകല്യേന വിംശത്യധികശതം ശിഷ്യാ ആസൻ| തതഃ പിതരസ്തേഷാം മധ്യേ തിഷ്ഠൻ ഉക്തവാൻ ");
INSERT INTO sanmal_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","ഹേ ഭ്രാതൃഗണ യീശുധാരിണാം ലോകാനാം പഥദർശകോ യോ യിഹൂദാസ്തസ്മിൻ ദായൂദാ പവിത്ര ആത്മാ യാം കഥാം കഥയാമാസ തസ്യാഃ പ്രത്യക്ഷീഭവനസ്യാവശ്യകത്വമ് ആസീത്| ");
INSERT INTO sanmal_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","സ ജനോഽസ്മാകം മധ്യവർത്തീ സൻ അസ്യാഃ സേവായാ അംശമ് അലഭത| ");
INSERT INTO sanmal_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","തദനന്തരം കുകർമ്മണാ ലബ്ധം യന്മൂല്യം തേന ക്ഷേത്രമേകം ക്രീതമ് അപരം തസ്മിൻ അധോമുഖേ ഭൃമൗ പതിതേ സതി തസ്യോദരസ്യ വിദീർണത്വാത് സർവ്വാ നാഡ്യോ നിരഗച്ഛൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ഏതാം കഥാം യിരൂശാലമ്നിവാസിനഃ സർവ്വേ ലോകാ വിദാന്തി; തേഷാം നിജഭാഷയാ തത്ക്ഷേത്രഞ്ച ഹകൽദാമാ, അർഥാത് രക്തക്ഷേത്രമിതി വിഖ്യാതമാസ്തേ| ");
INSERT INTO sanmal_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","അന്യച്ച, നികേതനം തദീയന്തു ശുന്യമേവ ഭവിഷ്യതി| തസ്യ ദൂഷ്യേ നിവാസാർഥം കോപി സ്ഥാസ്യതി നൈവ ഹി| അന്യ ഏവ ജനസ്തസ്യ പദം സംപ്രാപ്സ്യതി ധ്രുവം| ഇത്ഥം ഗീതപുസ്തകേ ലിഖിതമാസ്തേ| ");
INSERT INTO sanmal_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","അതോ യോഹനോ മജ്ജനമ് ആരഭ്യാസ്മാകം സമീപാത് പ്രഭോ ര്യീശോഃ സ്വർഗാരോഹണദിനം യാവത് സോസ്മാകം മധ്യേ യാവന്തി ദിനാനി യാപിതവാൻ ");
INSERT INTO sanmal_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","താവന്തി ദിനാനി യേ മാനവാ അസ്മാഭിഃ സാർദ്ധം തിഷ്ഠന്തി തേഷാമ് ഏകേന ജനേനാസ്മാഭിഃ സാർദ്ധം യീശോരുത്ഥാനേ സാക്ഷിണാ ഭവിതവ്യം| ");
INSERT INTO sanmal_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","അതോ യസ്യ രൂഢി ര്യുഷ്ടോ യം ബർശബ്ബേത്യുക്ത്വാഹൂയന്തി സ യൂഷഫ് മതഥിശ്ച ദ്വാവേതൗ പൃഥക് കൃത്വാ ത ഈശ്വരസ്യ സന്നിധൗ പ്രാര്യ്യ കഥിതവന്തഃ, ");
INSERT INTO sanmal_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","ഹേ സർവ്വാന്തര്യ്യാമിൻ പരമേശ്വര, യിഹൂദാഃ സേവനപ്രേരിതത്വപദച്യുതഃ ");
INSERT INTO sanmal_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","സൻ നിജസ്ഥാനമ് അഗച്ഛത്, തത്പദം ലബ്ധുമ് ഏനയോ ർജനയോ ർമധ്യേ ഭവതാ കോഽഭിരുചിതസ്തദസ്മാൻ ദർശ്യതാം| ");
INSERT INTO sanmal_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","തതോ ഗുടികാപാടേ കൃതേ മതഥിർനിരചീയത തസ്മാത് സോന്യേഷാമ് ഏകാദശാനാം പ്രരിതാനാം മധ്യേ ഗണിതോഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","അപരഞ്ച നിസ്താരോത്സവാത് പരം പഞ്ചാശത്തമേ ദിനേ സമുപസ്ഥിതേ സതി തേ സർവ്വേ ഏകാചിത്തീഭൂയ സ്ഥാന ഏകസ്മിൻ മിലിതാ ആസൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ഏതസ്മിന്നേവ സമയേഽകസ്മാദ് ആകാശാത് പ്രചണ്ഡാത്യുഗ്രവായോഃ ശബ്ദവദ് ഏകഃ ശബ്ദ ആഗത്യ യസ്മിൻ ഗൃഹേ ത ഉപാവിശൻ തദ് ഗൃഹം സമസ്തം വ്യാപ്നോത്| ");
INSERT INTO sanmal_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","തതഃ പരം വഹ്നിശിഖാസ്വരൂപാ ജിഹ്വാഃ പ്രത്യക്ഷീഭൂയ വിഭക്താഃ സത്യഃ പ്രതിജനോർദ്ധ്വേ സ്ഥഗിതാ അഭൂവൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","തസ്മാത് സർവ്വേ പവിത്രേണാത്മനാ പരിപൂർണാഃ സന്ത ആത്മാ യഥാ വാചിതവാൻ തദനുസാരേണാന്യദേശീയാനാം ഭാഷാ ഉക്തവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","തസ്മിൻ സമയേ പൃഥിവീസ്ഥസർവ്വദേശേഭ്യോ യിഹൂദീയമതാവലമ്ബിനോ ഭക്തലോകാ യിരൂശാലമി പ്രാവസൻ; ");
INSERT INTO sanmal_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","തസ്യാഃ കഥായാഃ കിംവദന്ത്യാ ജാതത്വാത് സർവ്വേ ലോകാ മിലിത്വാ നിജനിജഭാഷയാ ശിഷ്യാണാം കഥാകഥനം ശ്രുത്വാ സമുദ്വിഗ്നാ അഭവൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","സർവ്വഏവ വിസ്മയാപന്നാ ആശ്ചര്യ്യാന്വിതാശ്ച സന്തഃ പരസ്പരം ഉക്തവന്തഃ പശ്യത യേ കഥാം കഥയന്തി തേ സർവ്വേ ഗാലീലീയലോകാഃ കിം ന ഭവന്തി? ");
INSERT INTO sanmal_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","തർഹി വയം പ്രത്യേകശഃ സ്വസ്വജന്മദേശീയഭാഷാഭിഃ കഥാ ഏതേഷാം ശൃണുമഃ കിമിദം? ");
INSERT INTO sanmal_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","പാർഥീ-മാദീ-അരാമ്നഹരയിമ്ദേശനിവാസിമനോ യിഹൂദാ-കപ്പദകിയാ-പന്ത-ആശിയാ- ");
INSERT INTO sanmal_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ഫ്രുഗിയാ-പമ്ഫുലിയാ-മിസരനിവാസിനഃ കുരീണീനികടവർത്തിലൂബീയപ്രദേശനിവാസിനോ രോമനഗരാദ് ആഗതാ യിഹൂദീയലോകാ യിഹൂദീയമതഗ്രാഹിണഃ ക്രീതീയാ അരാബീയാദയോ ലോകാശ്ച യേ വയമ് ");
INSERT INTO sanmal_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","അസ്മാകം നിജനിജഭാഷാഭിരേതേഷാമ് ഈശ്വരീയമഹാകർമ്മവ്യാഖ്യാനം ശൃണുമഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ഇത്ഥം തേ സർവ്വഏവ വിസ്മയാപന്നാഃ സന്ദിഗ്ധചിത്താഃ സന്തഃ പരസ്പരമൂചുഃ, അസ്യ കോ ഭാവഃ? ");
INSERT INTO sanmal_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","അപരേ കേചിത് പരിഹസ്യ കഥിതവന്ത ഏതേ നവീനദ്രാക്ഷാരസേന മത്താ അഭവൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","തദാ പിതര ഏകാദശഭി ർജനൈഃ സാകം തിഷ്ഠൻ താല്ലോകാൻ ഉച്ചൈഃകാരമ് അവദത്, ഹേ യിഹൂദീയാ ഹേ യിരൂശാലമ്നിവാസിനഃ സർവ്വേ, അവധാനം കൃത്വാ മദീയവാക്യം ബുധ്യധ്വം| ");
INSERT INTO sanmal_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ഇദാനീമ് ഏകയാമാദ് അധികാ വേലാ നാസ്തി തസ്മാദ് യൂയം യദ് അനുമാഥ മാനവാ ഇമേ മദ്യപാനേന മത്താസ്തന്ന| ");
INSERT INTO sanmal_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","കിന്തു യോയേൽഭവിഷ്യദ്വക്ത്രൈതദ്വാക്യമുക്തം യഥാ, ");
INSERT INTO sanmal_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","ഈശ്വരഃ കഥയാമാസ യുഗാന്തസമയേ ത്വഹമ്| വർഷിഷ്യാമി സ്വമാത്മാനം സർവ്വപ്രാണ്യുപരി ധ്രുവമ്| ഭാവിവാക്യം വദിഷ്യന്തി കന്യാഃ പുത്രാശ്ച വസ്തുതഃ| പ്രത്യാദേശഞ്ച പ്രാപ്സ്യന്തി യുഷ്മാകം യുവമാനവാഃ| തഥാ പ്രാചീനലോകാസ്തു സ്വപ്നാൻ ദ്രക്ഷ്യന്തി നിശ്ചിതം| ");
INSERT INTO sanmal_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","വർഷിഷ്യാമി തദാത്മാനം ദാസദാസീജനോപിരി| തേനൈവ ഭാവിവാക്യം തേ വദിഷ്യന്തി ഹി സർവ്വശഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ഊർദ്ധ്വസ്ഥേ ഗഗണേ ചൈവ നീചസ്ഥേ പൃഥിവീതലേ| ശോണിതാനി ബൃഹദ്ഭാനൂൻ ഘനധൂമാദികാനി ച| ചിഹ്നാനി ദർശയിഷ്യാമി മഹാശ്ചര്യ്യക്രിയാസ്തഥാ| ");
INSERT INTO sanmal_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","മഹാഭയാനകസ്യൈവ തദ്ദിനസ്യ പരേശിതുഃ| പുരാഗമാദ് രവിഃ കൃഷ്ണോ രക്തശ്ചന്ദ്രോ ഭവിഷ്യതഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","കിന്തു യഃ പരമേശസ്യ നാമ്നി സമ്പ്രാർഥയിഷ്യതേ| സഏവ മനുജോ നൂനം പരിത്രാതോ ഭവിഷ്യതി|| ");
INSERT INTO sanmal_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","അതോ ഹേ ഇസ്രായേല്വംശീയലോകാഃ സർവ്വേ കഥായാമേതസ്യാമ് മനോ നിധദ്ധ്വം നാസരതീയോ യീശുരീശ്വരസ്യ മനോനീതഃ പുമാൻ ഏതദ് ഈശ്വരസ്തത്കൃതൈരാശ്ചര്യ്യാദ്ഭുതകർമ്മഭി ർലക്ഷണൈശ്ച യുഷ്മാകം സാക്ഷാദേവ പ്രതിപാദിതവാൻ ഇതി യൂയം ജാനീഥ| ");
INSERT INTO sanmal_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","തസ്മിൻ യീശൗ ഈശ്വരസ്യ പൂർവ്വനിശ്ചിതമന്ത്രണാനിരൂപണാനുസാരേണ മൃത്യൗ സമർപിതേ സതി യൂയം തം ധൃത്വാ ദുഷ്ടലോകാനാം ഹസ്തൈഃ ക്രുശേ വിധിത്വാഹത| ");
INSERT INTO sanmal_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","കിന്ത്വീശ്വരസ്തം നിധനസ്യ ബന്ധനാന്മോചയിത്വാ ഉദസ്ഥാപയത് യതഃ സ മൃത്യുനാ ബദ്ധസ്തിഷ്ഠതീതി ന സമ്ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ഏതസ്തിൻ ദായൂദപി കഥിതവാൻ യഥാ, സർവ്വദാ മമ സാക്ഷാത്തം സ്ഥാപയ പരമേശ്വരം| സ്ഥിതേ മദ്ദക്ഷിണേ തസ്മിൻ സ്ഖലിഷ്യാമി ത്വഹം നഹി| ");
INSERT INTO sanmal_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ആനന്ദിഷ്യതി തദ്ധേതോ ർമാമകീനം മനസ്തു വൈ| ആഹ്ലാദിഷ്യതി ജിഹ്വാപി മദീയാ തു തഥൈവ ച| പ്രത്യാശയാ ശരീരന്തു മദീയം വൈശയിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","പരലോകേ യതോ ഹേതോസ്ത്വം മാം നൈവ ഹി ത്യക്ഷ്യസി| സ്വകീയം പുണ്യവന്തം ത്വം ക്ഷയിതും നൈവ ദാസ്യസി| ഏവം ജീവനമാർഗം ത്വം മാമേവ ദർശയിഷ്യസി| ");
INSERT INTO sanmal_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","സ്വസമ്മുഖേ യ ആനന്ദോ ദക്ഷിണേ സ്വസ്യ യത് സുഖം| അനന്തം തേന മാം പൂർണം കരിഷ്യസി ന സംശയഃ|| ");
INSERT INTO sanmal_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","ഹേ ഭ്രാതരോഽസ്മാകം തസ്യ പൂർവ്വപുരുഷസ്യ ദായൂദഃ കഥാം സ്പഷ്ടം കഥയിതും മാമ് അനുമന്യധ്വം, സ പ്രാണാൻ ത്യക്ത്വാ ശ്മശാനേ സ്ഥാപിതോഭവദ് അദ്യാപി തത് ശ്മശാനമ് അസ്മാകം സന്നിധൗ വിദ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","ഫലതോ ലൗകികഭാവേന ദായൂദോ വംശേ ഖ്രീഷ്ടം ജന്മ ഗ്രാഹയിത്വാ തസ്യൈവ സിംഹാസനേ സമുവേഷ്ടും തമുത്ഥാപയിഷ്യതി പരമേശ്വരഃ ശപഥം കുത്വാ ദായൂദഃ സമീപ ഇമമ് അങ്ഗീകാരം കൃതവാൻ, ");
INSERT INTO sanmal_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ഇതി ജ്ഞാത്വാ ദായൂദ് ഭവിഷ്യദ്വാദീ സൻ ഭവിഷ്യത്കാലീയജ്ഞാനേന ഖ്രീഷ്ടോത്ഥാനേ കഥാമിമാം കഥയാമാസ യഥാ തസ്യാത്മാ പരലോകേ ന ത്യക്ഷ്യതേ തസ്യ ശരീരഞ്ച ന ക്ഷേഷ്യതി; ");
INSERT INTO sanmal_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","അതഃ പരമേശ്വര ഏനം യീശും ശ്മശാനാദ് ഉദസ്ഥാപയത് തത്ര വയം സർവ്വേ സാക്ഷിണ ആസ്മഹേ| ");
INSERT INTO sanmal_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","സ ഈശ്വരസ്യ ദക്ഷിണകരേണോന്നതിം പ്രാപ്യ പവിത്ര ആത്മിന പിതാ യമങ്ഗീകാരം കൃതവാൻ തസ്യ ഫലം പ്രാപ്യ യത് പശ്യഥ ശൃണുഥ ച തദവർഷത്| ");
INSERT INTO sanmal_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","യതോ ദായൂദ് സ്വർഗം നാരുരോഹ കിന്തു സ്വയമ് ഇമാം കഥാമ് അകഥയദ് യഥാ, മമ പ്രഭുമിദം വാക്യമവദത് പരമേശ്വരഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","തവ ശത്രൂനഹം യാവത് പാദപീഠം കരോമി ന| താവത് കാലം മദീയേ ത്വം ദക്ഷവാർശ്വ ഉപാവിശ| ");
INSERT INTO sanmal_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","അതോ യം യീശും യൂയം ക്രുശേഽഹത പരമേശ്വരസ്തം പ്രഭുത്വാഭിഷിക്തത്വപദേ ന്യയുംക്തേതി ഇസ്രായേലീയാ ലോകാ നിശ്ചിതം ജാനന്തു| ");
INSERT INTO sanmal_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ഏതാദൃശീം കഥാം ശ്രുത്വാ തേഷാം ഹൃദയാനാം വിദീർണത്വാത് തേ പിതരായ തദന്യപ്രേരിതേഭ്യശ്ച കഥിതവന്തഃ, ഹേ ഭ്രാതൃഗണ വയം കിം കരിഷ്യാമഃ? ");
INSERT INTO sanmal_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","തതഃ പിതരഃ പ്രത്യവദദ് യൂയം സർവ്വേ സ്വം സ്വം മനഃ പരിവർത്തയധ്വം തഥാ പാപമോചനാർഥം യീശുഖ്രീഷ്ടസ്യ നാമ്നാ മജ്ജിതാശ്ച ഭവത, തസ്മാദ് ദാനരൂപം പരിത്രമ് ആത്മാനം ലപ്സ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","യതോ യുഷ്മാകം യുഷ്മത്സന്താനാനാഞ്ച ദൂരസ്ഥസർവ്വലോകാനാഞ്ച നിമിത്തമ് അർഥാദ് അസ്മാകം പ്രഭുഃ പരമേശ്വരോ യാവതോ ലാകാൻ ആഹ്വാസ്യതി തേഷാം സർവ്വേഷാം നിമിത്തമ് അയമങ്ഗീകാര ആസ്തേ| ");
INSERT INTO sanmal_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ഏതദന്യാഭി ർബഹുകഥാഭിഃ പ്രമാണം ദത്വാകഥയത് ഏതേഭ്യോ വിപഥഗാമിഭ്യോ വർത്തമാനലോകേഭ്യഃ സ്വാൻ രക്ഷത| ");
INSERT INTO sanmal_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","തതഃ പരം യേ സാനന്ദാസ്താം കഥാമ് അഗൃഹ്ലൻ തേ മജ്ജിതാ അഭവൻ| തസ്മിൻ ദിവസേ പ്രായേണ ത്രീണി സഹസ്രാണി ലോകാസ്തേഷാം സപക്ഷാഃ സന്തഃ ");
INSERT INTO sanmal_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","പ്രേരിതാനാമ് ഉപദേശേ സങ്ഗതൗ പൂപഭഞ്ജനേ പ്രാർഥനാസു ച മനഃസംയോഗം കൃത്വാതിഷ്ഠൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","പ്രേരിതൈ ർനാനാപ്രകാരലക്ഷണേഷു മഹാശ്ചര്യ്യകർമമസു ച ദർശിതേഷു സർവ്വലോകാനാം ഭയമുപസ്ഥിതം| ");
INSERT INTO sanmal_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","വിശ്വാസകാരിണഃ സർവ്വ ച സഹ തിഷ്ഠനതഃ| സ്വേഷാം സർവ്വാഃ സമ്പത്തീഃ സാധാരണ്യേന സ്ഥാപയിത്വാഭുഞ്ജത| ");
INSERT INTO sanmal_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ഫലതോ ഗൃഹാണി ദ്രവ്യാണി ച സർവ്വാണി വിക്രീയ സർവ്വേഷാം സ്വസ്വപ്രയോജനാനുസാരേണ വിഭജ്യ സർവ്വേഭ്യോഽദദൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","സർവ്വ ഏകചിത്തീഭൂയ ദിനേ ദിനേ മന്ദിരേ സന്തിഷ്ഠമാനാ ഗൃഹേ ഗൃഹേ ച പൂപാനഭഞ്ജന്ത ഈശ്വരസ്യ ധന്യവാദം കുർവ്വന്തോ ലോകൈഃ സമാദൃതാഃ പരമാനന്ദേന സരലാന്തഃകരണേന ഭോജനം പാനഞ്ചകുർവ്വൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","പരമേശ്വരോ ദിനേ ദിനേ പരിത്രാണഭാജനൈ ർമണ്ഡലീമ് അവർദ്ധയത്| ");
INSERT INTO sanmal_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","തൃതീയയാമവേലായാം സത്യാം പ്രാർഥനായാഃ സമയേ പിതരയോഹനൗ സമ്ഭൂയ മന്ദിരം ഗച്ഛതഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","തസ്മിന്നേവ സമയേ മന്ദിരപ്രവേശകാനാം സമീപേ ഭിക്ഷാരണാർഥം യം ജന്മഖഞ്ജമാനുഷം ലോകാ മന്ദിരസ്യ സുന്ദരനാമ്നി ദ്വാരേ പ്രതിദിനമ് അസ്ഥാപയൻ തം വഹന്തസ്തദ്വാരം ആനയൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","തദാ പിതരയോഹനൗ മന്തിരം പ്രവേഷ്ടുമ് ഉദ്യതൗ വിലോക്യ സ ഖഞ്ജസ്തൗ കിഞ്ചിദ് ഭിക്ഷിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","തസ്മാദ് യോഹനാ സഹിതഃ പിതരസ്തമ് അനന്യദൃഷ്ട്യാ നിരീക്ഷ്യ പ്രോക്തവാൻ ആവാം പ്രതി ദൃഷ്ടിം കുരു| ");
INSERT INTO sanmal_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","തതഃ സ കിഞ്ചിത് പ്രാപ്ത്യാശയാ തൗ പ്രതി ദൃഷ്ടിം കൃതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","തദാ പിതരോ ഗദിതവാൻ മമ നികടേ സ്വർണരൂപ്യാദി കിമപി നാസ്തി കിന്തു യദാസ്തേ തദ് ദദാമി നാസരതീയസ്യ യീശുഖ്രീഷ്ടസ്യ നാമ്നാ ത്വമുത്ഥായ ഗമനാഗമനേ കുരു| ");
INSERT INTO sanmal_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","തതഃ പരം സ തസ്യ ദക്ഷിണകരം ധൃത്വാ തമ് ഉദതോലയത്; തേന തത്ക്ഷണാത് തസ്യ ജനസ്യ പാദഗുൽഫയോഃ സബലത്വാത് സ ഉല്ലമ്ഫ്യ പ്രോത്ഥായ ഗമനാഗമനേ ഽകരോത്| ");
INSERT INTO sanmal_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","തതോ ഗമനാഗമനേ കുർവ്വൻ ഉല്ലമ്ഫൻ ഈശ്വരം ധന്യം വദൻ താഭ്യാം സാർദ്ധം മന്ദിരം പ്രാവിശത്| ");
INSERT INTO sanmal_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","തതഃ സർവ്വേ ലോകാസ്തം ഗമനാഗമനേ കുർവ്വന്തമ് ഈശ്വരം ധന്യം വദന്തഞ്ച വിലോക്യ ");
INSERT INTO sanmal_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","മന്ദിരസ്യ സുന്ദരേ ദ്വാരേ യ ഉപവിശ്യ ഭിക്ഷിതവാൻ സഏവായമ് ഇതി ജ്ഞാത്വാ തം പ്രതി തയാ ഘടനയാ ചമത്കൃതാ വിസ്മയാപന്നാശ്ചാഭവൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","യഃ ഖഞ്ജഃ സ്വസ്ഥോഭവത് തേന പിതരയോഹനോഃ കരയോർധ്ടതയോഃ സതോഃ സർവ്വേ ലോകാ സന്നിധിമ് ആഗച്ഛൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","തദ് ദൃഷ്ട്വാ പിതരസ്തേഭ്യോഽകഥയത്, ഹേ ഇസ്രായേലീയലോകാ യൂയം കുതോ ഽനേനാശ്ചര്യ്യം മന്യധ്വേ? ആവാം നിജശക്ത്യാ യദ്വാ നിജപുണ്യേന ഖഞ്ജമനുഷ്യമേനം ഗമിതവന്താവിതി ചിന്തയിത്വാ ആവാം പ്രതി കുതോഽനന്യദൃഷ്ടിം കുരുഥ? ");
INSERT INTO sanmal_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","യം യീശും യൂയം പരകരേഷു സമാർപയത തതോ യം പീലാതോ മോചയിതുമ് ഏैച്ഛത് തഥാപി യൂയം തസ്യ സാക്ഷാൻ നാങ്ഗീകൃതവന്ത ഇബ്രാഹീമ ഇസ്ഹാകോ യാകൂബശ്ചേശ്വരോഽർഥാദ് അസ്മാകം പൂർവ്വപുരുഷാണാമ് ഈശ്വരഃ സ്വപുത്രസ്യ തസ്യ യീശോ ർമഹിമാനം പ്രാകാശയത്| ");
INSERT INTO sanmal_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","കിന്തു യൂയം തം പവിത്രം ധാർമ്മികം പുമാംസം നാങ്ഗീകൃത്യ ഹത്യാകാരിണമേകം സ്വേഭ്യോ ദാതുമ് അയാചധ്വം| ");
INSERT INTO sanmal_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","പശ്ചാത് തം ജീവനസ്യാധിപതിമ് അഹത കിന്ത്വീശ്വരഃ ശ്മശാനാത് തമ് ഉദസ്ഥാപയത തത്ര വയം സാക്ഷിണ ആസ്മഹേ| ");
INSERT INTO sanmal_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ഇമം യം മാനുഷം യൂയം പശ്യഥ പരിചിനുഥ ച സ തസ്യ നാമ്നി വിശ്വാസകരണാത് ചലനശക്തിം ലബ്ധവാൻ തസ്മിൻ തസ്യ യോ വിശ്വാസഃ സ തം യുഷ്മാകം സർവ്വേഷാം സാക്ഷാത് സമ്പൂർണരൂപേണ സ്വസ്ഥമ് അകാർഷീത്| ");
INSERT INTO sanmal_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","ഹേ ഭ്രാതരോ യൂയം യുഷ്മാകമ് അധിപതയശ്ച അജ്ഞാത്വാ കർമ്മാണ്യേതാനി കൃതവന്ത ഇദാനീം മമൈഷ ബോധോ ജായതേ| ");
INSERT INTO sanmal_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","കിന്ത്വീശ്വരഃ ഖ്രീഷ്ടസ്യ ദുഃഖഭോഗേ ഭവിഷ്യദ്വാദിനാം മുഖേഭ്യോ യാം യാം കഥാം പൂർവ്വമകഥയത് താഃ കഥാ ഇത്ഥം സിദ്ധാ അകരോത്| ");
INSERT INTO sanmal_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","അതഃ സ്വേഷാം പാപമോചനാർഥം ഖേദം കൃത്വാ മനാംസി പരിവർത്തയധ്വം, തസ്മാദ് ഈശ്വരാത് സാന്ത്വനാപ്രാപ്തേഃ സമയ ഉപസ്ഥാസ്യതി; ");
INSERT INTO sanmal_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","പുനശ്ച പൂർവ്വകാലമ് ആരഭ്യ പ്രചാരിതോ യോ യീശുഖ്രീഷ്ടസ്തമ് ഈശ്വരോ യുഷ്മാൻ പ്രതി പ്രേഷയിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","കിന്തു ജഗതഃ സൃഷ്ടിമാരഭ്യ ഈശ്വരോ നിജപവിത്രഭവിഷ്യദ്വാദിഗണോന യഥാ കഥിതവാൻ തദനുസാരേണ സർവ്വേഷാം കാര്യ്യാണാം സിദ്ധിപര്യ്യന്തം തേന സ്വർഗേ വാസഃ കർത്തവ്യഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","യുഷ്മാകം പ്രഭുഃ പരമേശ്വരോ യുഷ്മാകം ഭ്രാതൃഗണമധ്യാത് മത്സദൃശം ഭവിഷ്യദ്വക്താരമ് ഉത്പാദയിഷ്യതി, തതഃ സ യത് കിഞ്ചിത് കഥയിഷ്യതി തത്ര യൂയം മനാംസി നിധദ്ധ്വം| ");
INSERT INTO sanmal_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","കിന്തു യഃ കശ്ചിത് പ്രാണീ തസ്യ ഭവിഷ്യദ്വാദിനഃ കഥാം ന ഗ്രഹീഷ്യതി സ നിജലോകാനാം മധ്യാദ് ഉച്ഛേത്സ്യതേ,\" ഇമാം കഥാമ് അസ്മാകം പൂർവ്വപുരുഷേഭ്യഃ കേവലോ മൂസാഃ കഥയാമാസ ഇതി നഹി, ");
INSERT INTO sanmal_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","ശിമൂയേൽഭവിഷ്യദ്വാദിനമ് ആരഭ്യ യാവന്തോ ഭവിഷ്യദ്വാക്യമ് അകഥയൻ തേ സർവ്വഏവ സമയസ്യൈതസ്യ കഥാമ് അകഥയൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","യൂയമപി തേഷാം ഭവിഷ്യദ്വാദിനാം സന്താനാഃ, \"തവ വംശോദ്ഭവപുംസാ സർവ്വദേശീയാ ലോകാ ആശിഷം പ്രാപ്താ ഭവിഷ്യന്തി\", ഇബ്രാഹീമേ കഥാമേതാം കഥയിത്വാ ഈശ്വരോസ്മാകം പൂർവ്വപുരുഷൈഃ സാർദ്ധം യം നിയമം സ്ഥിരീകൃതവാൻ തസ്യ നിയമസ്യാധികാരിണോപി യൂയം ഭവഥ| ");
INSERT INTO sanmal_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","അത ഈശ്വരോ നിജപുത്രം യീശുമ് ഉത്ഥാപ്യ യുഷ്മാകം സർവ്വേഷാം സ്വസ്വപാപാത് പരാവർത്ത്യ യുഷ്മഭ്യമ് ആശിഷം ദാതും പ്രഥമതസ്തം യുഷ്മാകം നികടം പ്രേഷിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","യസ്മിൻ സമയേ പിതരയോഹനൗ ലോകാൻ ഉപദിശതസ്തസ്മിൻ സമയേ യാജകാ മന്ദിരസ്യ സേനാപതയഃ സിദൂകീഗണശ്ച ");
INSERT INTO sanmal_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","തയോർ ഉപദേശകരണേ ഖ്രീഷ്ടസ്യോത്ഥാനമ് ഉപലക്ഷ്യ സർവ്വേഷാം മൃതാനാമ് ഉത്ഥാനപ്രസ്താവേ ച വ്യഗ്രാഃ സന്തസ്താവുപാഗമൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","തൗ ധൃത്വാ ദിനാവസാനകാരണാത് പരദിനപര്യ്യനന്തം രുദ്ധ്വാ സ്ഥാപിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","തഥാപി യേ ലോകാസ്തയോരുപദേശമ് അശൃണ്വൻ തേഷാം പ്രായേണ പഞ്ചസഹസ്രാണി ജനാ വ്യശ്വസൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","പരേഽഹനി അധിപതയഃ പ്രാചീനാ അധ്യാപകാശ്ച ഹാനനനാമാ മഹായാജകഃ ");
INSERT INTO sanmal_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","കിയഫാ യോഹൻ സികന്ദര ഇത്യാദയോ മഹായാജകസ്യ ജ്ഞാതയഃ സർവ്വേ യിരൂശാലമ്നഗരേ മിലിതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","അനന്തരം പ്രേരിതൗ മധ്യേ സ്ഥാപയിത്വാപൃച്ഛൻ യുവാം കയാ ശക്തയാ വാ കേന നാമ്നാ കർമ്മാണ്യേതാനി കുരുഥഃ? ");
INSERT INTO sanmal_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","തദാ പിതരഃ പവിത്രേണാത്മനാ പരിപൂർണഃ സൻ പ്രത്യവാദീത്, ഹേ ലോകാനാമ് അധിപതിഗണ ഹേ ഇസ്രായേലീയപ്രാചീനാഃ, ");
INSERT INTO sanmal_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ഏതസ്യ ദുർബ്ബലമാനുഷസ്യ ഹിതം യത് കർമ്മാക്രിയത, അർഥാത്, സ യേന പ്രകാരേണ സ്വസ്ഥോഭവത് തച്ചേദ് അദ്യാവാം പൃച്ഛഥ, ");
INSERT INTO sanmal_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","തർഹി സർവ്വ ഇസ്രായേेലീയലോകാ യൂയം ജാനീത നാസരതീയോ യോ യീശുഖ്രീഷ്ടഃ ക്രുശേ യുഷ്മാഭിരവിധ്യത യശ്ചേശ്വരേണ ശ്മശാനാദ് ഉത്ഥാപിതഃ, തസ്യ നാമ്നാ ജനോയം സ്വസ്ഥഃ സൻ യുഷ്മാകം സമ്മുഖേ പ്രോത്തിഷ്ഠതി| ");
INSERT INTO sanmal_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","നിചേതൃഭി ര്യുഷ്മാഭിരയം യഃ പ്രസ്തരോഽവജ്ഞാതോഽഭവത് സ പ്രധാനകോണസ്യ പ്രസ്തരോഽഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","തദ്ഭിന്നാദപരാത് കസ്മാദപി പരിത്രാണം ഭവിതും ന ശക്നോതി, യേന ത്രാണം പ്രാപ്യേത ഭൂമണ്ഡലസ്യലോകാനാം മധ്യേ താദൃശം കിമപി നാമ നാസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","തദാ പിതരയോഹനോരേതാദൃശീമ് അക്ഷേഭതാം ദൃഷ്ട്വാ താവവിദ്വാംസൗ നീചലോകാവിതി ബുദ്ധ്വാ ആശ്ചര്യ്യമ് അമന്യന്ത തൗ ച യീശോഃ സങ്ഗിനൗ ജാതാവിതി ജ്ഞാതുമ് അശക്നുവൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","കിന്തു താഭ്യാം സാർദ്ധം തം സ്വസ്ഥമാനുഷം തിഷ്ഠന്തം ദൃഷ്ട്വാ തേ കാമപ്യപരാമ് ആപത്തിം കർത്തം നാശക്നുൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","തദാ തേ സഭാതഃ സ്ഥാനാന്തരം ഗന്തും താൻ ആജ്ഞാപ്യ സ്വയം പരസ്പരമ് ഇതി മന്ത്രണാമകുർവ്വൻ ");
INSERT INTO sanmal_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","തൗ മാനവൗ പ്രതി കിം കർത്തവ്യം? താവേകം പ്രസിദ്ധമ് ആശ്ചര്യ്യം കർമ്മ കൃതവന്തൗ തദ് യിരൂശാലമ്നിവാസിനാം സർവ്വേഷാം ലോകാനാം സമീപേ പ്രാകാശത തച്ച വയമപഹ്നോതും ന ശക്നുമഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","കിന്തു ലോകാനാം മധ്യമ് ഏതദ് യഥാ ന വ്യാപ്നോതി തദർഥം തൗ ഭയം പ്രദർശ്യ തേന നാമ്നാ കമപി മനുഷ്യം നോപദിശതമ് ഇതി ദൃഢം നിഷേധാമഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","തതസ്തേ പ്രേരിതാവാഹൂയ ഏതദാജ്ഞാപയൻ ഇതഃ പരം യീശോ ർനാമ്നാ കദാപി കാമപി കഥാം മാ കഥയതം കിമപി നോപദിശഞ്ച| ");
INSERT INTO sanmal_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","തതഃ പിതരയോഹനൗ പ്രത്യവദതാമ് ഈശ്വരസ്യാജ്ഞാഗ്രഹണം വാ യുഷ്മാകമ് ആജ്ഞാഗ്രഹണമ് ഏതയോ ർമധ്യേ ഈശ്വരസ്യ ഗോചരേ കിം വിഹിതം? യൂയം തസ്യ വിവേചനാം കുരുത| ");
INSERT INTO sanmal_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","വയം യദ് അപശ്യാമ യദശൃണുമ ച തന്ന പ്രചാരയിഷ്യാമ ഏതത് കദാപി ഭവിതും ന ശക്നോതി| ");
INSERT INTO sanmal_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","യദഘടത തദ് ദൃഷ്ടാ സർവ്വേ ലോകാ ഈശ്വരസ്യ ഗുണാൻ അന്വവദൻ തസ്മാത് ലോകഭയാത് തൗ ദണ്ഡയിതും കമപ്യുപായം ന പ്രാപ്യ തേ പുനരപി തർജയിത്വാ താവത്യജൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","യസ്യ മാനുഷസ്യൈതത് സ്വാസ്ഥ്യകരണമ് ആശ്ചര്യ്യം കർമ്മാക്രിയത തസ്യ വയശ്ചത്വാരിംശദ്വത്സരാ വ്യതീതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","തതഃ പരം തൗ വിസൃഷ്ടൗ സന്തൗ സ്വസങ്ഗിനാം സന്നിധിം ഗത്വാ പ്രധാനയാജകൈഃ പ്രാചീനലോകൈശ്ച പ്രോക്താഃ സർവ്വാഃ കഥാ ജ്ഞാപിതവന്തൗ| ");
INSERT INTO sanmal_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","തച്ഛ്രുത്വാ സർവ്വ ഏകചിത്തീഭൂയ ഈശ്വരമുദ്ദിശ്യ പ്രോച്ചൈരേതത് പ്രാർഥയന്ത, ഹേ പ്രഭോ ഗഗണപൃഥിവീപയോധീനാം തേഷു ച യദ്യദ് ആസ്തേ തേഷാം സ്രഷ്ടേശ്വരസ്ത്വം| ");
INSERT INTO sanmal_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ത്വം നിജസേവകേന ദായൂദാ വാക്യമിദമ് ഉവചിഥ, മനുഷ്യാ അന്യദേശീയാഃ കുർവ്വന്തി കലഹം കുതഃ| ലോകാഃ സർവ്വേ കിമർഥം വാ ചിന്താം കുർവ്വന്തി നിഷ്ഫലാം| ");
INSERT INTO sanmal_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","പരമേശസ്യ തേനൈവാഭിഷിക്തസ്യ ജനസ്യ ച| വിരുദ്ധമഭിതിഷ്ഠന്തി പൃഥിവ്യാഃ പതയഃ കുതഃ|| ");
INSERT INTO sanmal_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","ഫലതസ്തവ ഹസ്തേന മന്ത്രണയാ ച പൂർവ്വ യദ്യത് സ്ഥിരീകൃതം തദ് യഥാ സിദ്ധം ഭവതി തദർഥം ത്വം യമ് അഥിഷിക്തവാൻ സ ഏവ പവിത്രോ യീശുസ്തസ്യ പ്രാതികൂല്യേന ഹേരോദ് പന്തീയപീലാതോ ");
INSERT INTO sanmal_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ഽന്യദേശീയലോകാ ഇസ്രായേല്ലോകാശ്ച സർവ്വ ഏതേ സഭായാമ് അതിഷ്ഠൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ഹേ പരമേശ്വര അധുനാ തേഷാം തർജനം ഗർജനഞ്ച ശൃണു; ");
INSERT INTO sanmal_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","തഥാ സ്വാസ്ഥ്യകരണകർമ്മണാ തവ ബാഹുബലപ്രകാശപൂർവ്വകം തവ സേവകാൻ നിർഭയേന തവ വാക്യം പ്രചാരയിതും തവ പവിത്രപുത്രസ്യ യീശോ ർനാമ്നാ ആശ്ചര്യ്യാണ്യസമ്ഭവാനി ച കർമ്മാണി കർത്തുഞ്ചാജ്ഞാപയ| ");
INSERT INTO sanmal_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ഇത്ഥം പ്രാർഥനയാ യത്ര സ്ഥാനേ തേ സഭായാമ് ആസൻ തത് സ്ഥാനം പ്രാകമ്പത; തതഃ സർവ്വേ പവിത്രേണാത്മനാ പരിപൂർണാഃ സന്ത ഈശ്വരസ്യ കഥാമ് അക്ഷോഭേണ പ്രാചാരയൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","അപരഞ്ച പ്രത്യയകാരിലോകസമൂഹാ ഏകമനസ ഏകചിത്തീഭൂയ സ്ഥിതാഃ| തേഷാം കേപി നിജസമ്പത്തിം സ്വീയാം നാജാനൻ കിന്തു തേഷാം സർവ്വാഃ സമ്പത്ത്യഃ സാധാരണ്യേന സ്ഥിതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","അന്യച്ച പ്രേരിതാ മഹാശക്തിപ്രകാശപൂർവ്വകം പ്രഭോ ര്യീശോരുത്ഥാനേ സാക്ഷ്യമ് അദദുഃ, തേഷു സർവ്വേഷു മഹാനുഗ്രഹോഽഭവച്ച| ");
INSERT INTO sanmal_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","തേഷാം മധ്യേ കസ്യാപി ദ്രവ്യന്യൂനതാ നാഭവദ് യതസ്തേഷാം ഗൃഹഭൂമ്യാദ്യാ യാഃ സമ്പത്തയ ആസൻ താ വിക്രീയ ");
INSERT INTO sanmal_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","തന്മൂല്യമാനീയ പ്രേരിതാനാം ചരണേഷു തൈഃ സ്ഥാപിതം; തതഃ പ്രത്യേകശഃ പ്രയോജനാനുസാരേണ ദത്തമഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","വിശേഷതഃ കുപ്രോപദ്വീപീയോ യോസിനാമകോ ലേവിവംശജാത ഏകോ ജനോ ഭൂമ്യധികാരീ, യം പ്രേരിതാ ബർണബ്ബാ അർഥാത് സാന്ത്വനാദായക ഇത്യുക്ത്വാ സമാഹൂയൻ, ");
INSERT INTO sanmal_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","സ ജനോ നിജഭൂമിം വിക്രീയ തന്മൂല്യമാനീയ പ്രേരിതാനാം ചരണേഷു സ്ഥാപിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","തദാ അനാനിയനാമക ഏകോ ജനോ യസ്യ ഭാര്യ്യായാ നാമ സഫീരാ സ സ്വാധികാരം വിക്രീയ ");
INSERT INTO sanmal_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","സ്വഭാര്യ്യാം ജ്ഞാപയിത്വാ തന്മൂല്യസ്യൈകാംശം സങ്ഗോപ്യ സ്ഥാപയിത്വാ തദന്യാംശമാത്രമാനീയ പ്രേരിതാനാം ചരണേഷു സമർപിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","തസ്മാത് പിതരോകഥയത് ഹേ അനാനിയ ഭൂമേ ർമൂല്യം കിഞ്ചിത് സങ്ഗോപ്യ സ്ഥാപയിതും പവിത്രസ്യാത്മനഃ സന്നിധൗ മൃഷാവാക്യം കഥയിതുഞ്ച ശൈതാൻ കുതസ്തവാന്തഃകരണേ പ്രവൃത്തിമജനയത്? ");
INSERT INTO sanmal_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","സാ ഭൂമി ര്യദാ തവ ഹസ്തഗതാ തദാ കിം തവ സ്വീയാ നാസീത്? തർഹി സ്വാന്തഃകരണേ കുത ഏതാദൃശീ കുകൽപനാ ത്വയാ കൃതാ? ത്വം കേവലമനുഷ്യസ്യ നികടേ മൃഷാവാക്യം നാവാദീഃ കിന്ത്വീശ്വരസ്യ നികടേഽപി| ");
INSERT INTO sanmal_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ഏതാം കഥാം ശ്രുത്വൈവ സോഽനാനിയോ ഭൂമൗ പതൻ പ്രാണാൻ അത്യജത്, തദ്വൃത്താന്തം യാവന്തോ ലോകാ അശൃണ്വൻ തേഷാം സർവ്വേഷാം മഹാഭയമ് അജായത്| ");
INSERT INTO sanmal_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","തദാ യുവലോകാസ്തം വസ്ത്രേണാച്ഛാദ്യ ബഹി ർനീത്വാ ശ്മശാനേഽസ്ഥാപയൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","തതഃ പ്രഹരൈകാനന്തരം കിം വൃത്തം തന്നാവഗത്യ തസ്യ ഭാര്യ്യാപി തത്ര സമുപസ്ഥിതാ| ");
INSERT INTO sanmal_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","തതഃ പിതരസ്താമ് അപൃച്ഛത്, യുവാഭ്യാമ് ഏതാവന്മുദ്രാഭ്യോ ഭൂമി ർവിക്രീതാ ന വാ? ഏതത്വം വദ; തദാ സാ പ്രത്യവാദീത് സത്യമ് ഏതാവദ്ഭ്യോ മുദ്രാഭ്യ ഏവ| ");
INSERT INTO sanmal_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","തതഃ പിതരോകഥയത് യുവാം കഥം പരമേശ്വരസ്യാത്മാനം പരീക്ഷിതുമ് ഏകമന്ത്രണാവഭവതാം? പശ്യ യേ തവ പതിം ശ്മശാനേ സ്ഥാപിതവന്തസ്തേ ദ്വാരസ്യ സമീപേ സമുപതിഷ്ഠന്തി ത്വാമപി ബഹിർനേഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","തതഃ സാപി തസ്യ ചരണസന്നിധൗ പതിത്വാ പ്രാണാൻ അത്യാക്ഷീത്| പശ്ചാത് തേ യുവാനോഽഭ്യന്തരമ് ആഗത്യ താമപി മൃതാം ദൃഷ്ട്വാ ബഹി ർനീത്വാ തസ്യാഃ പത്യുഃ പാർശ്വേ ശ്മശാനേ സ്ഥാപിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","തസ്മാത് മണ്ഡല്യാഃ സർവ്വേ ലോകാ അന്യലോകാശ്ച താം വാർത്താം ശ്രുത്വാ സാധ്വസം ഗതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","തതഃ പരം പ്രേരിതാനാം ഹസ്തൈ ർലോകാനാം മധ്യേ ബഹ്വാശ്ചര്യ്യാണ്യദ്ഭുതാനി കർമ്മാണ്യക്രിയന്ത; തദാ ശിഷ്യാഃ സർവ്വ ഏകചിത്തീഭൂയ സുലേമാനോ ഽലിന്ദേ സമ്ഭൂയാസൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","തേഷാം സങ്ഘാന്തർഗോ ഭവിതും കോപി പ്രഗൽഭതാം നാഗമത് കിന്തു ലോകാസ്താൻ സമാദ്രിയന്ത| ");
INSERT INTO sanmal_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","സ്ത്രിയഃ പുരുഷാശ്ച ബഹവോ ലോകാ വിശ്വാസ്യ പ്രഭും ശരണമാപന്നാഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","പിതരസ്യ ഗമനാഗമനാഭ്യാം കേനാപി പ്രകാരേണ തസ്യ ഛായാ കസ്മിംശ്ചിജ്ജനേ ലഗിഷ്യതീത്യാശയാ ലോകാ രോഗിണഃ ശിവികയാ ഖട്വയാ ചാനീയ പഥി പഥി സ്ഥാപിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","ചതുർദിക്സ്ഥനഗരേഭ്യോ ബഹവോ ലോകാഃ സമ്ഭൂയ രോഗിണോഽപവിത്രഭുതഗ്രസ്താംശ്ച യിരൂശാലമമ് ആനയൻ തതഃ സർവ്വേ സ്വസ്ഥാ അക്രിയന്ത| ");
INSERT INTO sanmal_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","അനന്തരം മഹായാജകഃ സിദൂകിനാം മതഗ്രാഹിണസ്തേഷാം സഹചരാശ്ച ");
INSERT INTO sanmal_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","മഹാക്രോധാന്ത്വിതാഃ സന്തഃ പ്രേരിതാൻ ധൃത്വാ നീചലോകാനാം കാരായാം ബദ്ധ്വാ സ്ഥാപിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","കിന്തു രാത്രൗ പരമേശ്വരസ്യ ദൂതഃ കാരായാ ദ്വാരം മോചയിത്വാ താൻ ബഹിരാനീയാകഥയത്, ");
INSERT INTO sanmal_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","യൂയം ഗത്വാ മന്ദിരേ ദണ്ഡായമാനാഃ സന്തോ ലോകാൻ പ്രതീമാം ജീവനദായികാം സർവ്വാം കഥാം പ്രചാരയത| ");
INSERT INTO sanmal_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ഇതി ശ്രുത്വാ തേ പ്രത്യൂഷേ മന്ദിര ഉപസ്ഥായ ഉപദിഷ്ടവന്തഃ| തദാ സഹചരഗണേന സഹിതോ മഹായാജക ആഗത്യ മന്ത്രിഗണമ് ഇസ്രായേല്വംശസ്യ സർവ്വാൻ രാജസഭാസദഃ സഭാസ്ഥാൻ കൃത്വാ കാരായാസ്താൻ ആപയിതും പദാതിഗണം പ്രേരിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","തതസ്തേ ഗത്വാ കാരായാം താൻ അപ്രാപ്യ പ്രത്യാഗത്യ ഇതി വാർത്താമ് അവാദിഷുഃ, ");
INSERT INTO sanmal_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","വയം തത്ര ഗത്വാ നിർവ്വിഘ്നം കാരായാ ദ്വാരം രുദ്ധം രക്ഷകാംശ്ച ദ്വാരസ്യ ബഹിർദണ്ഡായമാനാൻ അദർശാമ ഏവ കിന്തു ദ്വാരം മോചയിത്വാ തന്മധ്യേ കമപി ദ്രഷ്ടും ന പ്രാപ്താഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ഏതാം കഥാം ശ്രുത്വാ മഹായാജകോ മന്ദിരസ്യ സേനാപതിഃ പ്രധാനയാജകാശ്ച, ഇത പരം കിമപരം ഭവിഷ്യതീതി ചിന്തയിത്വാ സന്ദിഗ്ധചിത്താ അഭവൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ഏതസ്മിന്നേവ സമയേ കശ്ചിത് ജന ആഗത്യ വാർത്താമേതാമ് അവദത് പശ്യത യൂയം യാൻ മാനവാൻ കാരായാമ് അസ്ഥാപയത തേ മന്ദിരേ തിഷ്ഠന്തോ ലോകാൻ ഉപദിശന്തി| ");
INSERT INTO sanmal_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","തദാ മന്ദിരസ്യ സേനാപതിഃ പദാതയശ്ച തത്ര ഗത്വാ ചേല്ലോകാഃ പാഷാണാൻ നിക്ഷിപ്യാസ്മാൻ മാരയന്തീതി ഭിയാ വിനത്യാചാരം താൻ ആനയൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","തേ മഹാസഭായാ മധ്യേ താൻ അസ്ഥാപയൻ തതഃ പരം മഹായാജകസ്താൻ അപൃച്ഛത്, ");
INSERT INTO sanmal_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","അനേന നാമ്നാ സമുപദേഷ്ടും വയം കിം ദൃഢം ന ന്യഷേധാമ? തഥാപി പശ്യത യൂയം സ്വേഷാം തേനോപദേശേനേ യിരൂശാലമം പരിപൂർണം കൃത്വാ തസ്യ ജനസ്യ രക്തപാതജനിതാപരാധമ് അസ്മാൻ പ്രത്യാനേതും ചേഷ്ടധ്വേ| ");
INSERT INTO sanmal_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","തതഃ പിതരോന്യപ്രേരിതാശ്ച പ്രത്യവദൻ മാനുഷസ്യാജ്ഞാഗ്രഹണാദ് ഈശ്വരസ്യാജ്ഞാഗ്രഹണമ് അസ്മാകമുചിതമ്| ");
INSERT INTO sanmal_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","യം യീശും യൂയം ക്രുശേ വേധിത്വാഹത തമ് അസ്മാകം പൈതൃക ഈശ്വര ഉത്ഥാപ്യ ");
INSERT INTO sanmal_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ഇസ്രായേല്വംശാനാം മനഃപരിവർത്തനം പാപക്ഷമാഞ്ച കർത്തും രാജാനം പരിത്രാതാരഞ്ച കൃത്വാ സ്വദക്ഷിണപാർശ്വേ തസ്യാന്നതിമ് അകരോത്| ");
INSERT INTO sanmal_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ഏതസ്മിൻ വയമപി സാക്ഷിണ ആസ്മഹേ, തത് കേവലം നഹി, ഈശ്വര ആജ്ഞാഗ്രാഹിഭ്യോ യം പവിത്രമ് ആത്മനം ദത്തവാൻ സോപി സാക്ഷ്യസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","ഏതദ്വാക്യേ ശ്രുതേ തേഷാം ഹൃദയാനി വിദ്ധാന്യഭവൻ തതസ്തേ താൻ ഹന്തും മന്ത്രിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ഏതസ്മിന്നേവ സമയേ തത്സഭാസ്ഥാനാം സർവ്വലോകാനാം മധ്യേ സുഖ്യാതോ ഗമിലീയേൽനാമക ഏകോ ജനോ വ്യവസ്ഥാപകഃ ഫിരൂശിലോക ഉത്ഥായ പ്രേരിതാൻ ക്ഷണാർഥം സ്ഥാനാന്തരം ഗന്തുമ് ആദിശ്യ കഥിതവാൻ, ");
INSERT INTO sanmal_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ഹേ ഇസ്രായേല്വംശീയാഃ സർവ്വേ യൂയമ് ഏതാൻ മാനുഷാൻ പ്രതി യത് കർത്തുമ് ഉദ്യതാസ്തസ്മിൻ സാവധാനാ ഭവത| ");
INSERT INTO sanmal_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","ഇതഃ പൂർവ്വം ഥൂദാനാമൈകോ ജന ഉപസ്ഥായ സ്വം കമപി മഹാപുരുഷമ് അവദത്, തതഃ പ്രായേണ ചതുഃശതലോകാസ്തസ്യ മതഗ്രാഹിണോഭവൻ പശ്ചാത് സ ഹതോഭവത് തസ്യാജ്ഞാഗ്രാഹിണോ യാവന്തോ ലോകാസ്തേ സർവ്വേ വിർകീർണാഃ സന്തോ ഽകൃതകാര്യ്യാ അഭവൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","തസ്മാജ്ജനാത് പരം നാമലേഖനസമയേ ഗാലീലീയയിഹൂദാനാമൈകോ ജന ഉപസ്ഥായ ബഹൂല്ലോകാൻ സ്വമതം ഗ്രാഹീതവാൻ തതഃ സോപി വ്യനശ്യത് തസ്യാജ്ഞാഗ്രാഹിണോ യാവന്തോ ലോകാ ആസൻ തേ സർവ്വേ വികീർണാ അഭവൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","അധുനാ വദാമി, യൂയമ് ഏതാൻ മനുഷ്യാൻ പ്രതി കിമപി ന കൃത്വാ ക്ഷാന്താ ഭവത, യത ഏഷ സങ്കൽപ ഏതത് കർമ്മ ച യദി മനുഷ്യാദഭവത് തർഹി വിഫലം ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","യദീശ്വരാദഭവത് തർഹി യൂയം തസ്യാന്യഥാ കർത്തും ന ശക്ഷ്യഥ, വരമ് ഈശ്വരരോധകാ ഭവിഷ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","തദാ തസ്യ മന്ത്രണാം സ്വീകൃത്യ തേ പ്രേരിതാൻ ആഹൂയ പ്രഹൃത്യ യീശോ ർനാമ്നാ കാമപി കഥാം കഥയിതും നിഷിധ്യ വ്യസർജൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","കിന്തു തസ്യ നാമാർഥം വയം ലജ്ജാഭോഗസ്യ യോഗ്യത്വേന ഗണിതാ ഇത്യത്ര തേ സാനന്ദാഃ സന്തഃ സഭാസ്ഥാനാം സാക്ഷാദ് അഗച്ഛൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","തതഃ പരം പ്രതിദിനം മന്ദിരേ ഗൃഹേ ഗൃഹേ ചാവിശ്രാമമ് ഉപദിശ്യ യീശുഖ്രീഷ്ടസ്യ സുസംവാദം പ്രചാരിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","തസ്മിൻ സമയേ ശിഷ്യാണാം ബാഹുല്യാത് പ്രാത്യഹികദാനസ്യ വിശ്രാണനൈ ർഭിന്നദേശീയാനാം വിധവാസ്ത്രീഗണ ഉപേക്ഷിതേ സതി ഇബ്രീയലോകൈഃ സഹാന്യദേശീയാനാം വിവാദ ഉപാതിഷ്ഠത്| ");
INSERT INTO sanmal_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","തദാ ദ്വാദശപ്രേരിതാഃ സർവ്വാൻ ശിഷ്യാൻ സംഗൃഹ്യാകഥയൻ ഈശ്വരസ്യ കഥാപ്രചാരം പരിത്യജ്യ ഭോജനഗവേഷണമ് അസ്മാകമ് ഉചിതം നഹി| ");
INSERT INTO sanmal_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","അതോ ഹേ ഭ്രാതൃഗണ വയമ് ഏതത്കർമ്മണോ ഭാരം യേഭ്യോ ദാതും ശക്നുമ ഏതാദൃശാൻ സുഖ്യാത്യാപന്നാൻ പവിത്രേണാത്മനാ ജ്ഞാനേന ച പൂർണാൻ സപ്പ്രജനാൻ യൂയം സ്വേഷാം മധ്യേ മനോനീതാൻ കുരുത, ");
INSERT INTO sanmal_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","കിന്തു വയം പ്രാർഥനായാം കഥാപ്രചാരകർമ്മണി ച നിത്യപ്രവൃത്താഃ സ്ഥാസ്യാമഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ഏതസ്യാം കഥായാം സർവ്വേ ലോകാഃ സന്തുഷ്ടാഃ സന്തഃ സ്വേഷാം മധ്യാത് സ്തിഫാനഃ ഫിലിപഃ പ്രഖരോ നികാനോർ തീമൻ പർമ്മിണാ യിഹൂദിമതഗ്രാഹീ-ആന്തിയഖിയാനഗരീയോ നികലാ ഏതാൻ പരമഭക്താൻ പവിത്രേണാത്മനാ പരിപൂർണാൻ സപ്ത ജനാൻ ");
INSERT INTO sanmal_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","പ്രേരിതാനാം സമക്ഷമ് ആനയൻ, തതസ്തേ പ്രാർഥനാം കൃത്വാ തേഷാം ശിരഃസു ഹസ്താൻ ആർപയൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","അപരഞ്ച ഈശ്വരസ്യ കഥാ ദേശം വ്യാപ്നോത് വിശേഷതോ യിരൂശാലമി നഗരേ ശിഷ്യാണാം സംഖ്യാ പ്രഭൂതരൂപേണാവർദ്ധത യാജകാനാം മധ്യേപി ബഹവഃ ഖ്രീഷ്ടമതഗ്രാഹിണോഽഭവൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","സ്തിഫാനോे വിശ്വാസേന പരാക്രമേണ ച പരിപൂർണഃ സൻ ലോകാനാം മധ്യേ ബഹുവിധമ് അദ്ഭുതമ് ആശ്ചര്യ്യം കർമ്മാകരോത്| ");
INSERT INTO sanmal_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","തേന ലിബർത്തിനീയനാമ്നാ വിഖ്യാതസങ്ഘസ്യ കതിപയജനാഃ കുരീണീയസികന്ദരീയ-കിലികീയാശീയാദേശീയാഃ കിയന്തോ ജനാശ്ചോത്ഥായ സ്തിഫാനേന സാർദ്ധം വ്യവദന്ത| ");
INSERT INTO sanmal_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","കിന്തു സ്തിഫാനോ ജ്ഞാനേന പവിത്രേണാത്മനാ ച ഈദൃശീം കഥാം കഥിതവാൻ യസ്യാസ്തേ ആപത്തിം കർത്തും നാശക്നുവൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","പശ്ചാത് തൈ ർലോഭിതാഃ കതിപയജനാഃ കഥാമേനാമ് അകഥയൻ, വയം തസ്യ മുഖതോ മൂസാ ഈശ്വരസ്യ ച നിന്ദാവാക്യമ് അശ്രൗഷ്മ| ");
INSERT INTO sanmal_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","തേ ലോകാനാം ലോകപ്രാചീനാനാമ് അധ്യാപകാനാഞ്ച പ്രവൃത്തിം ജനയിത്വാ സ്തിഫാനസ്യ സന്നിധിമ് ആഗത്യ തം ധൃത്വാ മഹാസഭാമധ്യമ് ആനയൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","തദനന്തരം കതിപയജനേഷു മിഥ്യാസാക്ഷിഷു സമാനീതേഷു തേഽകഥയൻ ഏഷ ജന ഏതത്പുണ്യസ്ഥാനവ്യവസ്ഥയോ ർനിന്ദാതഃ കദാപി ന നിവർത്തതേ| ");
INSERT INTO sanmal_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ഫലതോ നാസരതീയയീശുഃ സ്ഥാനമേതദ് ഉച്ഛിന്നം കരിഷ്യതി മൂസാസമർപിതമ് അസ്മാകം വ്യവഹരണമ് അന്യരൂപം കരിഷ്യതി തസ്യൈതാദൃശീം കഥാം വയമ് അശൃണുമ| ");
INSERT INTO sanmal_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","തദാ മഹാസഭാസ്ഥാഃ സർവ്വേ തം പ്രതി സ്ഥിരാം ദൃഷ്ടിം കൃത്വാ സ്വർഗദൂതമുഖസദൃശം തസ്യ മുഖമ് അപശ്യൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","തതഃ പരം മഹായാജകഃ പൃഷ്ടവാൻ, ഏഷാ കഥാം കിം സത്യാ? ");
INSERT INTO sanmal_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","തതഃ സ പ്രത്യവദത്, ഹേ പിതരോ ഹേ ഭ്രാതരഃ സർവ്വേ ലാകാ മനാംസി നിധദ്ധ്വം| അസ്മാകം പൂർവ്വപുരുഷ ഇബ്രാഹീമ് ഹാരൺനഗരേ വാസകരണാത് പൂർവ്വം യദാ അരാമ്-നഹരയിമദേശേ ആസീത് തദാ തേജോമയ ഈശ്വരോ ദർശനം ദത്വാ ");
INSERT INTO sanmal_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","തമവദത് ത്വം സ്വദേശജ്ഞാതിമിത്രാണി പരിത്യജ്യ യം ദേശമഹം ദർശയിഷ്യാമി തം ദേശം വ്രജ| ");
INSERT INTO sanmal_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","അതഃ സ കസ്ദീയദേശം വിഹായ ഹാരൺനഗരേ ന്യവസത്, തദനന്തരം തസ്യ പിതരി മൃതേ യത്ര ദേശേ യൂയം നിവസഥ സ ഏനം ദേശമാഗച്ഛത്| ");
INSERT INTO sanmal_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","കിന്ത്വീശ്വരസ്തസ്മൈ കമപ്യധികാരമ് അർഥാദ് ഏകപദപരിമിതാം ഭൂമിമപി നാദദാത്; തദാ തസ്യ കോപി സന്താനോ നാസീത് തഥാപി സന്താനൈഃ സാർദ്ധമ് ഏതസ്യ ദേശസ്യാധികാരീ ത്വം ഭവിഷ്യസീതി തമ്പ്രത്യങ്ഗീകൃതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ഈശ്വര ഇത്ഥമ് അപരമപി കഥിതവാൻ തവ സന്താനാഃ പരദേശേ നിവത്സ്യന്തി തതസ്തദ്ദേശീയലോകാശ്ചതുഃശതവത്സരാൻ യാവത് താൻ ദാസത്വേ സ്ഥാപയിത്വാ താൻ പ്രതി കുവ്യവഹാരം കരിഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","അപരമ് ഈശ്വര ഏനാം കഥാമപി കഥിതവാൻ, യേ ലോകാസ്താൻ ദാസത്വേ സ്ഥാപയിഷ്യന്തി താല്ലോകാൻ അഹം ദണ്ഡയിഷ്യാമി, തതഃ പരം തേ ബഹിർഗതാഃ സന്തോ മാമ് അത്ര സ്ഥാനേ സേവിഷ്യന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","പശ്ചാത് സ തസ്മൈ ത്വക്ഛേദസ്യ നിയമം ദത്തവാൻ, അത ഇസ്ഹാകനാമ്നി ഇബ്രാഹീമ ഏകപുത്രേ ജാതേ, അഷ്ടമദിനേ തസ്യ ത്വക്ഛേദമ് അകരോത്| തസ്യ ഇസ്ഹാകഃ പുത്രോ യാകൂബ്, തതസ്തസ്യ യാകൂബോഽസ്മാകം ദ്വാദശ പൂർവ്വപുരുഷാ അജായന്ത| ");
INSERT INTO sanmal_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","തേ പൂർവ്വപുരുഷാ ഈർഷ്യയാ പരിപൂർണാ മിസരദേശം പ്രേഷയിതും യൂഷഫം വ്യക്രീണൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","കിന്ത്വീശ്വരസ്തസ്യ സഹായോ ഭൂത്വാ സർവ്വസ്യാ ദുർഗതേ രക്ഷിത്വാ തസ്മൈ ബുദ്ധിം ദത്ത്വാ മിസരദേശസ്യ രാജ്ഞഃ ഫിരൗണഃ പ്രിയപാത്രം കൃതവാൻ തതോ രാജാ മിസരദേശസ്യ സ്വീയസർവ്വപരിവാരസ്യ ച ശാസനപദം തസ്മൈ ദത്തവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","തസ്മിൻ സമയേ മിസര-കിനാനദേശയോ ർദുർഭിക്ഷഹേതോരതിക്ലിഷ്ടത്വാത് നഃ പൂർവ്വപുരുഷാ ഭക്ഷ്യദ്രവ്യം നാലഭന്ത| ");
INSERT INTO sanmal_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","കിന്തു മിസരദേശേ ശസ്യാനി സന്തി, യാകൂബ് ഇമാം വാർത്താം ശ്രുത്വാ പ്രഥമമ് അസ്മാകം പൂർവ്വപുരുഷാൻ മിസരം പ്രേഷിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","തതോ ദ്വിതീയവാരഗമനേ യൂഷഫ് സ്വഭ്രാതൃഭിഃ പരിചിതോഽഭവത്; യൂഷഫോ ഭ്രാതരഃ ഫിരൗൺ രാജേന പരിചിതാ അഭവൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","അനന്തരം യൂഷഫ് ഭ്രാതൃഗണം പ്രേഷ്യ നിജപിതരം യാകൂബം നിജാൻ പഞ്ചാധികസപ്തതിസംഖ്യകാൻ ജ്ഞാതിജനാംശ്ച സമാഹൂതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","തസ്മാദ് യാകൂബ് മിസരദേശം ഗത്വാ സ്വയമ് അസ്മാകം പൂർവ്വപുരുഷാശ്ച തസ്മിൻ സ്ഥാനേഽമ്രിയന്ത| ");
INSERT INTO sanmal_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","തതസ്തേ ശിഖിമം നീതാ യത് ശ്മശാനമ് ഇബ്രാഹീമ് മുദ്രാദത്വാ ശിഖിമഃ പിതു ർഹമോരഃ പുത്രേഭ്യഃ ക്രീതവാൻ തത്ശ്മശാനേ സ്ഥാപയാഞ്ചക്രിരേ| ");
INSERT INTO sanmal_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","തതഃ പരമ് ഈശ്വര ഇബ്രാഹീമഃ സന്നിധൗ ശപഥം കൃത്വാ യാം പ്രതിജ്ഞാം കൃതവാൻ തസ്യാഃ പ്രതിജ്ഞായാഃ ഫലനസമയേ നികടേ സതി ഇസ്രായേല്ലോകാ സിമരദേശേ വർദ്ധമാനാ ബഹുസംഖ്യാ അഭവൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ശേഷേ യൂഷഫം യോ ന പരിചിനോതി താദൃശ ഏകോ നരപതിരുപസ്ഥായ ");
INSERT INTO sanmal_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","അസ്മാകം ജ്ഞാതിഭിഃ സാർദ്ധം ധൂർത്തതാം വിധായ പൂർവ്വപുരുഷാൻ പ്രതി കുവ്യവഹരണപൂർവ്വകം തേഷാം വംശനാശനായ തേഷാം നവജാതാൻ ശിശൂൻ ബഹി ർനിരക്ഷേപയത്| ");
INSERT INTO sanmal_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","ഏതസ്മിൻ സമയേ മൂസാ ജജ്ഞേ, സ തു പരമസുന്ദരോഽഭവത് തഥാ പിതൃഗൃഹേ മാസത്രയപര്യ്യന്തം പാലിതോഽഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","കിന്തു തസ്മിൻ ബഹിർനിക്ഷിപ്തേ സതി ഫിരൗണരാജസ്യ കന്യാ തമ് ഉത്തോല്യ നീത്വാ ദത്തകപുത്രം കൃത്വാ പാലിതവതീ| ");
INSERT INTO sanmal_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","തസ്മാത് സ മൂസാ മിസരദേശീയായാഃ സർവ്വവിദ്യായാഃ പാരദൃഷ്വാ സൻ വാക്യേ ക്രിയായാഞ്ച ശക്തിമാൻ അഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","സ സമ്പൂർണചത്വാരിംശദ്വത്സരവയസ്കോ ഭൂത്വാ ഇസ്രായേലീയവംശനിജഭ്രാതൃൻ സാക്ഷാത് കർതും മതിം ചക്രേ| ");
INSERT INTO sanmal_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","തേഷാം ജനമേകം ഹിംസിതം ദൃഷ്ട്വാ തസ്യ സപക്ഷഃ സൻ ഹിംസിതജനമ് ഉപകൃത്യ മിസരീയജനം ജഘാന| ");
INSERT INTO sanmal_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","തസ്യ ഹസ്തേനേശ്വരസ്താൻ ഉദ്ധരിഷ്യതി തസ്യ ഭ്രാതൃഗണ ഇതി ജ്ഞാസ്യതി സ ഇത്യനുമാനം ചകാര, കിന്തു തേ ന ബുബുധിരേ| ");
INSERT INTO sanmal_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","തത്പരേ ഽഹനി തേഷാമ് ഉഭയോ ർജനയോ ർവാക്കലഹ ഉപസ്ഥിതേ സതി മൂസാഃ സമീപം ഗത്വാ തയോ ർമേലനം കർത്തും മതിം കൃത്വാ കഥയാമാസ, ഹേ മഹാശയൗ യുവാം ഭ്രാതരൗ പരസ്പരമ് അന്യായം കുതഃ കുരുഥഃ? ");
INSERT INTO sanmal_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","തതഃ സമീപവാസിനം പ്രതി യോ ജനോഽന്യായം ചകാര സ തം ദൂരീകൃത്യ കഥയാമാസ, അസ്മാകമുപരി ശാസ്തൃത്വവിചാരയിതൃത്വപദയോഃ കസ്ത്വാം നിയുക്തവാൻ? ");
INSERT INTO sanmal_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","ഹ്യോ യഥാ മിസരീയം ഹതവാൻ തഥാ കിം മാമപി ഹനിഷ്യസി? ");
INSERT INTO sanmal_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","തദാ മൂസാ ഏതാദൃശീം കഥാം ശ്രുത്വാ പലായനം ചക്രേ, തതോ മിദിയനദേശം ഗത്വാ പ്രവാസീ സൻ തസ്ഥൗ, തതസ്തത്ര ദ്വൗ പുത്രൗ ജജ്ഞാതേ| ");
INSERT INTO sanmal_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","അനന്തരം ചത്വാരിംശദ്വത്സരേഷു ഗതേഷു സീനയപർവ്വതസ്യ പ്രാന്തരേ പ്രജ്വലിതസ്തമ്ബസ്യ വഹ്നിശിഖായാം പരമേശ്വരദൂതസ്തസ്മൈ ദർശനം ദദൗ| ");
INSERT INTO sanmal_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","മൂസാസ്തസ്മിൻ ദർശനേ വിസ്മയം മത്വാ വിശേഷം ജ്ഞാതും നികടം ഗച്ഛതി, ");
INSERT INTO sanmal_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","ഏതസ്മിൻ സമയേ, അഹം തവ പൂർവ്വപുരുഷാണാമ് ഈശ്വരോഽർഥാദ് ഇബ്രാഹീമ ഈശ്വര ഇസ്ഹാക ഈശ്വരോ യാകൂബ ഈശ്വരശ്ച, മൂസാമുദ്ദിശ്യ പരമേശ്വരസ്യൈതാദൃശീ വിഹായസീയാ വാണീ ബഭൂവ, തതഃ സ കമ്പാന്വിതഃ സൻ പുന ർനിരീക്ഷിതും പ്രഗൽഭോ ന ബഭൂവ| ");
INSERT INTO sanmal_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","പരമേശ്വരസ്തം ജഗാദ, തവ പാദയോഃ പാദുകേ മോചയ യത്ര തിഷ്ഠസി സാ പവിത്രഭൂമിഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","അഹം മിസരദേശസ്ഥാനാം നിജലോകാനാം ദുർദ്ദശാം നിതാന്തമ് അപശ്യം, തേഷാം കാതര്യ്യോക്തിഞ്ച ശ്രുതവാൻ തസ്മാത് താൻ ഉദ്ധർത്തുമ് അവരുഹ്യാഗമമ്; ഇദാനീമ് ആഗച്ഛ മിസരദേശം ത്വാം പ്രേഷയാമി| ");
INSERT INTO sanmal_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","കസ്ത്വാം ശാസ്തൃത്വവിചാരയിതൃത്വപദയോ ർനിയുക്തവാൻ, ഇതി വാക്യമുക്ത്വാ തൈ ര്യോ മൂസാ അവജ്ഞാതസ്തമേവ ഈശ്വരഃ സ്തമ്ബമധ്യേ ദർശനദാത്രാ തേന ദൂതേന ശാസ്താരം മുക്തിദാതാരഞ്ച കൃത്വാ പ്രേഷയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","സ ച മിസരദേശേ സൂഫ്നാമ്നി സമുദ്രേ ച പശ്ചാത് ചത്വാരിംശദ്വത്സരാൻ യാവത് മഹാപ്രാന്തരേ നാനാപ്രകാരാണ്യദ്ഭുതാനി കർമ്മാണി ലക്ഷണാനി ച ദർശയിത്വാ താൻ ബഹിഃ കൃത്വാ സമാനിനായ| ");
INSERT INTO sanmal_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","പ്രഭുഃ പരമേശ്വരോ യുഷ്മാകം ഭ്രാതൃഗണസ്യ മധ്യേ മാദൃശമ് ഏകം ഭവിഷ്യദ്വക്താരമ് ഉത്പാദയിഷ്യതി തസ്യ കഥായാം യൂയം മനോ നിധാസ്യഥ, യോ ജന ഇസ്രായേലഃ സന്താനേഭ്യ ഏനാം കഥാം കഥയാമാസ സ ഏഷ മൂസാഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","മഹാപ്രാന്തരസ്ഥമണ്ഡലീമധ്യേഽപി സ ഏവ സീനയപർവ്വതോപരി തേന സാർദ്ധം സംലാപിനോ ദൂതസ്യ ചാസ്മത്പിതൃഗണസ്യ മധ്യസ്ഥഃ സൻ അസ്മഭ്യം ദാതവ്യനി ജീവനദായകാനി വാക്യാനി ലേഭേ| ");
INSERT INTO sanmal_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","അസ്മാകം പൂർവ്വപുരുഷാസ്തമ് അമാന്യം കത്വാ സ്വേഭ്യോ ദൂരീകൃത്യ മിസരദേശം പരാവൃത്യ ഗന്തും മനോഭിരഭിലഷ്യ ഹാരോണം ജഗദുഃ, ");
INSERT INTO sanmal_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","അസ്മാകമ് അഗ്രേഽഗ്രേ ഗന്തുुമ് അസ്മദർഥം ദേവഗണം നിർമ്മാഹി യതോ യോ മൂസാ അസ്മാൻ മിസരദേശാദ് ബഹിഃ കൃത്വാനീതവാൻ തസ്യ കിം ജാതം തദസ്മാഭി ർന ജ്ഞായതേ| ");
INSERT INTO sanmal_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","തസ്മിൻ സമയേ തേ ഗോവത്സാകൃതിം പ്രതിമാം നിർമ്മായ താമുദ്ദിശ്യ നൈവേദ്യമുത്മൃജ്യ സ്വഹസ്തകൃതവസ്തുനാ ആനന്ദിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","തസ്മാദ് ഈശ്വരസ്തേഷാം പ്രതി വിമുഖഃ സൻ ആകാശസ്ഥം ജ്യോതിർഗണം പൂജയിതും തേഭ്യോഽനുമതിം ദദൗ, യാദൃശം ഭവിഷ്യദ്വാദിനാം ഗ്രന്ഥേഷു ലിഖിതമാസ്തേ, യഥാ, ഇസ്രായേലീയവംശാ രേ ചത്വാരിംശത്സമാൻ പുരാ| മഹതി പ്രാന്തരേ സംസ്ഥാ യൂയന്തു യാനി ച| ബലിഹോമാദികർമ്മാണി കൃതവന്തസ്തു താനി കിം| മാം സമുദ്ദിശ്യ യുഷ്മാഭിഃ പ്രകൃതാനീതി നൈവ ച| ");
INSERT INTO sanmal_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","കിന്തു വോ മോലകാഖ്യസ്യ ദേവസ്യ ദൂഷ്യമേവ ച| യുഷ്മാകം രിമ്ഫനാഖ്യായാ ദേവതായാശ്ച താരകാ| ഏതയോരുഭയോ ർമൂർതീ യുഷ്മാഭിഃ പരിപൂജിതേ| അതോ യുഷ്മാംസ്തു ബാബേലഃ പാരം നേഷ്യാമി നിശ്ചിതം| ");
INSERT INTO sanmal_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","അപരഞ്ച യന്നിദർശനമ് അപശ്യസ്തദനുസാരേണ ദൂഷ്യം നിർമ്മാഹി യസ്മിൻ ഈശ്വരോ മൂസാമ് ഏതദ്വാക്യം ബഭാഷേ തത് തസ്യ നിരൂപിതം സാക്ഷ്യസ്വരൂപം ദൂഷ്യമ് അസ്മാകം പൂർവ്വപുരുഷൈഃ സഹ പ്രാന്തരേ തസ്ഥൗ| ");
INSERT INTO sanmal_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","പശ്ചാത് യിഹോശൂയേന സഹിതൈസ്തേഷാം വംശജാതൈരസ്മത്പൂർവ്വപുരുഷൈഃ സ്വേഷാം സമ്മുഖാദ് ഈശ്വരേണ ദൂരീകൃതാനാമ് അന്യദേശീയാനാം ദേശാധികൃതികാലേ സമാനീതം തദ് ദൂഷ്യം ദായൂദോധികാരം യാവത് തത്ര സ്ഥാന ആസീത്| ");
INSERT INTO sanmal_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","സ ദായൂദ് പരമേശ്വരസ്യാനുഗ്രഹം പ്രാപ്യ യാകൂബ് ഈശ്വരാർഥമ് ഏകം ദൂഷ്യം നിർമ്മാതും വവാഞ്ഛ; ");
INSERT INTO sanmal_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","കിന്തു സുലേമാൻ തദർഥം മന്ദിരമ് ഏകം നിർമ്മിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","തഥാപി യഃ സർവ്വോപരിസ്ഥഃ സ കസ്മിംശ്ചിദ് ഹസ്തകൃതേ മന്ദിരേ നിവസതീതി നഹി, ഭവിഷ്യദ്വാദീ കഥാമേതാം കഥയതി, യഥാ, ");
INSERT INTO sanmal_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","പരേശോ വദതി സ്വർഗോ രാജസിംഹാസനം മമ| മദീയം പാദപീഠഞ്ച പൃഥിവീ ഭവതി ധ്രുവം| തർഹി യൂയം കൃതേ മേ കിം പ്രനിർമ്മാസ്യഥ മന്ദിരം| വിശ്രാമായ മദീയം വാ സ്ഥാനം കിം വിദ്യതേ ത്വിഹ| ");
INSERT INTO sanmal_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","സർവ്വാണ്യേതാനി വസ്തൂനി കിം മേ ഹസ്തകൃതാനി ന|| ");
INSERT INTO sanmal_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","ഹേ അനാജ്ഞാഗ്രാഹകാ അന്തഃകരണേ ശ്രവണേ ചാപവിത്രലോകാഃ യൂയമ് അനവരതം പവിത്രസ്യാത്മനഃ പ്രാതികൂല്യമ് ആചരഥ, യുഷ്മാകം പൂർവ്വപുരുഷാ യാദൃശാ യൂയമപി താദൃശാഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","യുഷ്മാകം പൂർവ്വപുരുഷാഃ കം ഭവിഷ്യദ്വാദിനം നാതാഡയൻ? യേ തസ്യ ധാർമ്മികസ്യ ജനസ്യാഗമനകഥാം കഥിതവന്തസ്താൻ അഘ്നൻ യൂയമ് അധൂനാ വിശ്വാസഘാതിനോ ഭൂത്വാ തം ധാർമ്മികം ജനമ് അഹത| ");
INSERT INTO sanmal_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","യൂയം സ്വർഗീയദൂതഗണേന വ്യവസ്ഥാം പ്രാപ്യാപി താം നാചരഥ| ");
INSERT INTO sanmal_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ഇമാം കഥാം ശ്രുത്വാ തേ മനഃസു ബിദ്ധാഃ സന്തസ്തം പ്രതി ദന്തഘർഷണമ് അകുർവ്വൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","കിന്തു സ്തിഫാനഃ പവിത്രേണാത്മനാ പൂർണോ ഭൂത്വാ ഗഗണം പ്രതി സ്ഥിരദൃഷ്ടിം കൃത്വാ ഈശ്വരസ്യ ദക്ഷിണേ ദണ്ഡായമാനം യീശുഞ്ച വിലോക്യ കഥിതവാൻ; ");
INSERT INTO sanmal_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","പശ്യ,മേഘദ്വാരം മുക്തമ് ഈശ്വരസ്യ ദക്ഷിണേ സ്ഥിതം മാനവസുതഞ്ച പശ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","തദാ തേ പ്രോച്ചൈഃ ശബ്ദം കൃത്വാ കർണേഷ്വങ്ഗുലീ ർനിധായ ഏകചിത്തീഭൂയ തമ് ആക്രമൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","പശ്ചാത് തം നഗരാദ് ബഹിഃ കൃത്വാ പ്രസ്തരൈരാഘ്നൻ സാക്ഷിണോ ലാകാഃ ശൗലനാമ്നോ യൂനശ്ചരണസന്നിധൗ നിജവസ്ത്രാണി സ്ഥാപിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","അനന്തരം ഹേ പ്രഭോ യീശേ മദീയമാത്മാനം ഗൃഹാണ സ്തിഫാനസ്യേതി പ്രാർഥനവാക്യവദനസമയേ തേ തം പ്രസ്തരൈരാഘ്നൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","തസ്മാത് സ ജാനുനീ പാതയിത്വാ പ്രോച്ചൈഃ ശബ്ദം കൃത്വാ, ഹേ പ്രഭേ പാപമേതദ് ഏതേഷു മാ സ്ഥാപയ, ഇത്യുക്ത്വാ മഹാനിദ്രാം പ്രാപ്നോത്| ");
INSERT INTO sanmal_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","തസ്യ ഹത്യാകരണം ശൗലോപി സമമന്യത| തസ്മിൻ സമയേ യിരൂശാലമ്നഗരസ്ഥാം മണ്ഡലീം പ്രതി മഹാതാഡനായാം ജാതായാം പ്രേരിതലോകാൻ ഹിത്വാ സർവ്വേഽപരേ യിഹൂദാശോമിരോണദേശയോ ർനാനാസ്ഥാനേ വികീർണാഃ സന്തോ ഗതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","അന്യച്ച ഭക്തലോകാസ്തം സ്തിഫാനം ശ്മശാനേ സ്ഥാപയിത്വാ ബഹു വ്യലപൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","കിന്തു ശൗലോ ഗൃഹേ ഗൃഹേ ഭ്രമിത്വാ സ്ത്രിയഃ പുരുഷാംശ്ച ധൃത്വാ കാരായാം ബദ്ധ്വാ മണ്ഡല്യാ മഹോത്പാതം കൃതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","അന്യച്ച യേ വികീർണാ അഭവൻ തേ സർവ്വത്ര ഭ്രമിത്വാ സുസംവാദം പ്രാചാരയൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","തദാ ഫിലിപഃ ശോമിരോൺനഗരം ഗത്വാ ഖ്രീഷ്ടാഖ്യാനം പ്രാചാരയത്; ");
INSERT INTO sanmal_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","തതോഽശുചി-ഭൃതഗ്രസ്തലോകേഭ്യോ ഭൂതാശ്ചീത്കൃത്യാഗച്ഛൻ തഥാ ബഹവഃ പക്ഷാഘാതിനഃ ഖഞ്ജാ ലോകാശ്ച സ്വസ്ഥാ അഭവൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","തസ്മാത് ലാകാ ഈദൃശം തസ്യാശ്ചര്യ്യം കർമ്മ വിലോക്യ നിശമ്യ ച സർവ്വ ഏകചിത്തീഭൂയ തേനോക്താഖ്യാനേ മനാംസി ന്യദധുഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","തസ്മിന്നഗരേ മഹാനന്ദശ്ചാഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","തതഃ പൂർവ്വം തസ്മിന്നഗരേ ശിമോന്നാമാ കശ്ചിജ്ജനോ ബഹ്വീ ർമായാക്രിയാഃ കൃത്വാ സ്വം കഞ്ചന മഹാപുരുഷം പ്രോച്യ ശോമിരോണീയാനാം മോഹം ജനയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","തസ്മാത് സ മാനുഷ ഈശ്വരസ്യ മഹാശക്തിസ്വരൂപ ഇത്യുക്ത്വാ ബാലവൃദ്ധവനിതാഃ സർവ്വേ ലാകാസ്തസ്മിൻ മനാംസി ന്യദധുഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","സ ബഹുകാലാൻ മായാവിക്രിയയാ സർവ്വാൻ അതീവ മോഹയാഞ്ചകാര, തസ്മാത് തേ തം മേനിരേ| ");
INSERT INTO sanmal_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","കിന്ത്വീശ്വരസ്യ രാജ്യസ്യ യീശുഖ്രീഷ്ടസ്യ നാമ്നശ്ചാഖ്യാനപ്രചാരിണഃ ഫിലിപസ്യ കഥായാം വിശ്വസ്യ തേഷാം സ്ത്രീപുരുഷോഭയലോകാ മജ്ജിതാ അഭവൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ശേഷേ സ ശിമോനപി സ്വയം പ്രത്യൈത് തതോ മജ്ജിതഃ സൻ ഫിലിപേന കൃതാമ് ആശ്ചര്യ്യക്രിയാം ലക്ഷണഞ്ച വിലോക്യാസമ്ഭവം മന്യമാനസ്തേന സഹ സ്ഥിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ഇത്ഥം ശോമിരോൺദേശീയലോകാ ഈശ്വരസ്യ കഥാമ് അഗൃഹ്ലൻ ഇതി വാർത്താം യിരൂശാലമ്നഗരസ്ഥപ്രേരിതാഃ പ്രാപ്യ പിതരം യോഹനഞ്ച തേഷാം നികടേ പ്രേഷിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","തതസ്തൗ തത് സ്ഥാനമ് ഉപസ്ഥായ ലോകാ യഥാ പവിത്രമ് ആത്മാനം പ്രാപ്നുവന്തി തദർഥം പ്രാർഥയേതാം| ");
INSERT INTO sanmal_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","യതസ്തേ പുരാ കേവലപ്രഭുയീശോ ർനാമ്നാ മജ്ജിതമാത്രാ അഭവൻ, ന തു തേഷാം മധ്യേ കമപി പ്രതി പവിത്രസ്യാത്മന ആവിർഭാവോ ജാതഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","കിന്തു പ്രേരിതാഭ്യാം തേഷാം ഗാത്രേഷു കരേഷ്വർപിതേഷു സത്സു തേ പവിത്രമ് ആത്മാനമ് പ്രാപ്നുവൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","ഇത്ഥം ലോകാനാം ഗാത്രേഷു പ്രേരിതയോഃ കരാർപണേന താൻ പവിത്രമ് ആത്മാനം പ്രാപ്താൻ ദൃഷ്ട്വാ സ ശിമോൻ തയോഃ സമീപേ മുദ്രാ ആനീയ കഥിതവാൻ; ");
INSERT INTO sanmal_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","അഹം യസ്യ ഗാത്രേ ഹസ്തമ് അർപയിഷ്യാമി തസ്യാപി യഥേത്ഥം പവിത്രാത്മപ്രാപ്തി ർഭവതി താദൃശീം ശക്തിം മഹ്യം ദത്തം| ");
INSERT INTO sanmal_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","കിന്തു പിതരസ്തം പ്രത്യവദത് തവ മുദ്രാസ്ത്വയാ വിനശ്യന്തു യത ഈശ്വരസ്യ ദാനം മുദ്രാഭിഃ ക്രീയതേ ത്വമിത്ഥം ബുദ്ധവാൻ; ");
INSERT INTO sanmal_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ഈശ്വരായ താവന്തഃകരണം സരലം നഹി, തസ്മാദ് അത്ര തവാംശോഽധികാരശ്ച കോപി നാസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","അത ഏതത്പാപഹേതോഃ ഖേദാന്വിതഃ സൻ കേനാപി പ്രകാരേണ തവ മനസ ഏതസ്യാഃ കുകൽപനായാഃ ക്ഷമാ ഭവതി, ഏതദർഥമ് ഈശ്വരേ പ്രാർഥനാം കുരു; ");
INSERT INTO sanmal_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","യതസ്ത്വം തിക്തപിത്തേ പാപസ്യ ബന്ധനേ ച യദസി തന്മയാ ബുദ്ധമ്| ");
INSERT INTO sanmal_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","തദാ ശിമോൻ അകഥയത് തർഹി യുവാഭ്യാമുദിതാ കഥാ മയി യഥാ ന ഫലതി തദർഥം യുവാം മന്നിമിത്തം പ്രഭൗ പ്രാർഥനാം കുരുതം| ");
INSERT INTO sanmal_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","അനേന പ്രകാരേണ തൗ സാക്ഷ്യം ദത്ത്വാ പ്രഭോഃ കഥാം പ്രചാരയന്തൗ ശോമിരോണീയാനാമ് അനേകഗ്രാമേഷു സുസംവാദഞ്ച പ്രചാരയന്തൗ യിരൂശാലമ്നഗരം പരാവൃത്യ ഗതൗ| ");
INSERT INTO sanmal_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","തതഃ പരമ് ഈശ്വരസ്യ ദൂതഃ ഫിലിപമ് ഇത്യാദിശത്, ത്വമുത്ഥായ ദക്ഷിണസ്യാം ദിശി യോ മാർഗോ പ്രാന്തരസ്യ മധ്യേന യിരൂശാലമോ ഽസാനഗരം യാതി തം മാർഗം ഗച്ഛ| ");
INSERT INTO sanmal_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","തതഃ സ ഉത്ഥായ ഗതവാൻ; തദാ കന്ദാകീനാമ്നഃ കൂശ്ലോകാനാം രാജ്ഞ്യാഃ സർവ്വസമ്പത്തേരധീശഃ കൂശദേശീയ ഏകഃ ഷണ്ഡോ ഭജനാർഥം യിരൂശാലമ്നഗരമ് ആഗത്യ ");
INSERT INTO sanmal_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","പുനരപി രഥമാരുഹ്യ യിശയിയനാമ്നോ ഭവിഷ്യദ്വാദിനോ ഗ്രന്ഥം പഠൻ പ്രത്യാഗച്ഛതി| ");
INSERT INTO sanmal_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ഏതസ്മിൻ സമയേ ആത്മാ ഫിലിപമ് അവദത്, ത്വമ് രഥസ്യ സമീപം ഗത്വാ തേന സാർദ്ധം മില| ");
INSERT INTO sanmal_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","തസ്മാത് സ ധാവൻ തസ്യ സന്നിധാവുപസ്ഥായ തേന പഠ്യമാനം യിശയിയഥവിഷ്യദ്വാദിനോ വാക്യം ശ്രുത്വാ പൃഷ്ടവാൻ യത് പഠസി തത് കിം ബുധ്യസേ? ");
INSERT INTO sanmal_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","തതഃ സ കഥിതവാൻ കേനചിന്ന ബോധിതോഹം കഥം ബുധ്യേയ? തതഃ സ ഫിലിപം രഥമാരോഢും സ്വേന സാർദ്ധമ് ഉപവേഷ്ടുഞ്ച ന്യവേദയത്| ");
INSERT INTO sanmal_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","സ ശാസ്ത്രസ്യേതദ്വാക്യം പഠിതവാൻ യഥാ, സമാനീയത ഘാതായ സ യഥാ മേഷശാവകഃ| ലോമച്ഛേദകസാക്ഷാച്ച മേഷശ്ച നീരവോ യഥാ| ആബധ്യ വദനം സ്വീയം തഥാ സ സമതിഷ്ഠത| ");
INSERT INTO sanmal_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","അന്യായേന വിചാരേണ സ ഉച്ഛിന്നോ ഽഭവത് തദാ| തത്കാലീനമനുഷ്യാൻ കോ ജനോ വർണയിതും ക്ഷമഃ| യതോ ജീവന്നൃണാം ദേശാത് സ ഉച്ഛിന്നോ ഽഭവത് ധ്രുവം| ");
INSERT INTO sanmal_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","അനന്തരം സ ഫിലിപമ് അവദത് നിവേദയാമി, ഭവിഷ്യദ്വാദീ യാമിമാം കഥാം കഥയാമാസ സ കിം സ്വസ്മിൻ വാ കസ്മിംശ്ചിദ് അന്യസ്മിൻ? ");
INSERT INTO sanmal_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","തതഃ ഫിലിപസ്തത്പ്രകരണമ് ആരഭ്യ യീശോരുപാഖ്യാനം തസ്യാഗ്രേ പ്രാസ്തൗത്| ");
INSERT INTO sanmal_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ഇത്ഥം മാർഗേണ ഗച്ഛന്തൗ ജലാശയസ്യ സമീപ ഉപസ്ഥിതൗ; തദാ ക്ലീബോഽവാദീത് പശ്യാത്ര സ്ഥാനേ ജലമാസ്തേ മമ മജ്ജനേ കാ ബാധാ? ");
INSERT INTO sanmal_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","തതഃ ഫിലിപ ഉത്തരം വ്യാഹരത് സ്വാന്തഃകരണേന സാകം യദി പ്രത്യേഷി തർഹി ബാധാ നാസ്തി| തതഃ സ കഥിതവാൻ യീശുഖ്രീഷ്ട ഈശ്വരസ്യ പുത്ര ഇത്യഹം പ്രത്യേമി| ");
INSERT INTO sanmal_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","തദാ രഥം സ്ഥഗിതം കർത്തുമ് ആദിഷ്ടേ ഫിലിപക്ലീബൗ ദ്വൗ ജലമ് അവാരുഹതാം; തദാ ഫിലിപസ്തമ് മജ്ജയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","തത്പശ്ചാത് ജലമധ്യാദ് ഉത്ഥിതയോഃ സതോഃ പരമേശ്വരസ്യാത്മാ ഫിലിപം ഹൃത്വാ നീതവാൻ, തസ്മാത് ക്ലീബഃ പുനസ്തം ന ദൃഷ്ടവാൻ തഥാപി ഹൃഷ്ടചിത്തഃ സൻ സ്വമാർഗേണ ഗതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ഫിലിപശ്ചാസ്ദോദ്നഗരമ് ഉപസ്ഥായ തസ്മാത് കൈസരിയാനഗര ഉപസ്ഥിതികാലപര്യ്യനതം സർവ്വസ്മിന്നഗരേ സുസംവാദം പ്രചാരയൻ ഗതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","തത്കാലപര്യ്യനതം ശൗലഃ പ്രഭോഃ ശിഷ്യാണാം പ്രാതികൂല്യേന താഡനാബധയോഃ കഥാം നിഃസാരയൻ മഹായാജകസ്യ സന്നിധിം ഗത്വാ ");
INSERT INTO sanmal_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","സ്ത്രിയം പുരുഷഞ്ച തന്മതഗ്രാഹിണം യം കഞ്ചിത് പശ്യതി താൻ ധൃത്വാ ബദ്ധ്വാ യിരൂശാലമമ് ആനയതീത്യാശയേന ദമ്മേഷക്നഗരീയം ധർമ്മസമാജാൻ പ്രതി പത്രം യാചിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","ഗച്ഛൻ തു ദമ്മേഷക്നഗരനികട ഉപസ്ഥിതവാൻ; തതോഽകസ്മാദ് ആകാശാത് തസ്യ ചതുർദിക്ഷു തേജസഃ പ്രകാശനാത് സ ഭൂമാവപതത്| ");
INSERT INTO sanmal_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","പശ്ചാത് ഹേ ശൗല ഹേ ശൗല കുതോ മാം താഡയസി? സ്വം പ്രതി പ്രോക്തമ് ഏതം ശബ്ദം ശ്രുത്വാ ");
INSERT INTO sanmal_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","സ പൃഷ്ടവാൻ, ഹേ പ്രഭോ ഭവാൻ കഃ? തദാ പ്രഭുരകഥയത് യം യീശും ത്വം താഡയസി സ ഏവാഹം; കണ്ടകസ്യ മുഖേ പദാഘാതകരണം തവ കഷ്ടമ്| ");
INSERT INTO sanmal_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","തദാ കമ്പമാനോ വിസ്മയാപന്നശ്ച സോവദത് ഹേ പ്രഭോ മയാ കിം കർത്തവ്യം? ഭവത ഇച്ഛാ കാ? തതഃ പ്രഭുരാജ്ഞാപയദ് ഉത്ഥായ നഗരം ഗച്ഛ തത്ര ത്വയാ യത് കർത്തവ്യം തദ് വദിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","തസ്യ സങ്ഗിനോ ലോകാ അപി തം ശബ്ദം ശ്രുതവന്തഃ കിന്തു കമപി ന ദൃഷ്ട്വാ സ്തബ്ധാഃ സന്തഃ സ്ഥിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","അനന്തരം ശൗലോ ഭൂമിത ഉത്ഥായ ചക്ഷുഷീ ഉന്മീല്യ കമപി ന ദൃഷ്ടവാൻ| തദാ ലോകാസ്തസ്യ ഹസ്തൗ ധൃത്വാ ദമ്മേഷക്നഗരമ് ആനയൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","തതഃ സ ദിനത്രയം യാവദ് അന്ധോ ഭൂത്വാ ന ഭുക്തവാൻ പീതവാംശ്ച| ");
INSERT INTO sanmal_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","തദനന്തരം പ്രഭുസ്തദ്ദമ്മേഷക്നഗരവാസിന ഏകസ്മൈ ശിഷ്യായ ദർശനം ദത്വാ ആഹൂതവാൻ ഹേ അനനിയ| തതഃ സ പ്രത്യവാദീത്, ഹേ പ്രഭോ പശ്യ ശൃണോമി| ");
INSERT INTO sanmal_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","തദാ പ്രഭുസ്തമാജ്ഞാപയത് ത്വമുത്ഥായ സരലനാമാനം മാർഗം ഗത്വാ യിഹൂദാനിവേശനേ താർഷനഗരീയം ശൗലനാമാനം ജനം ഗവേഷയൻ പൃച്ഛ; ");
INSERT INTO sanmal_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","പശ്യ സ പ്രാർഥയതേ, തഥാ അനനിയനാമക ഏകോ ജനസ്തസ്യ സമീപമ് ആഗത്യ തസ്യ ഗാത്രേ ഹസ്താർപണം കൃത്വാ ദൃഷ്ടിം ദദാതീത്ഥം സ്വപ്നേ ദൃഷ്ടവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","തസ്മാദ് അനനിയഃ പ്രത്യവദത് ഹേ പ്രഭോ യിരൂശാലമി പവിത്രലോകാൻ പ്രതി സോഽനേകഹിംസാം കൃതവാൻ; ");
INSERT INTO sanmal_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","അത്ര സ്ഥാനേ ച യേ ലോകാസ്തവ നാമ്നി പ്രാർഥയന്തി താനപി ബദ്ധും സ പ്രധാനയാജകേഭ്യഃ ശക്തിം പ്രാപ്തവാൻ, ഇമാം കഥാമ് അഹമ് അനേകേഷാം മുഖേഭ്യഃ ശ്രുതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","കിന്തു പ്രഭുരകഥയത്, യാഹി ഭിന്നദേശീയലോകാനാം ഭൂപതീനാമ് ഇസ്രായേല്ലോകാനാഞ്ച നികടേ മമ നാമ പ്രചാരയിതും സ ജനോ മമ മനോനീതപാത്രമാസ്തേ| ");
INSERT INTO sanmal_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","മമ നാമനിമിത്തഞ്ച തേന കിയാൻ മഹാൻ ക്ലേശോ ഭോക്തവ്യ ഏതത് തം ദർശയിഷ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","തതോ ഽനനിയോ ഗത്വാ ഗൃഹം പ്രവിശ്യ തസ്യ ഗാത്രേ ഹസ്താർപ്രണം കൃത്വാ കഥിതവാൻ, ഹേ ഭ്രാതഃ ശൗല ത്വം യഥാ ദൃഷ്ടിം പ്രാപ്നോഷി പവിത്രേണാത്മനാ പരിപൂർണോ ഭവസി ച, തദർഥം തവാഗമനകാലേ യഃ പ്രഭുയീശുസ്തുഭ്യം ദർശനമ് അദദാത് സ മാം പ്രേഷിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ഇത്യുക്തമാത്രേ തസ്യ ചക്ഷുർഭ്യാമ് മീനശൽകവദ് വസ്തുനി നിർഗതേ തത്ക്ഷണാത് സ പ്രസന്നചക്ഷു ർഭൂത്വാ പ്രോത്ഥായ മജ്ജിതോഽഭവത് ഭുക്ത്വാ പീത്വാ സബലോഭവച്ച| ");
INSERT INTO sanmal_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","തതഃ പരം ശൗലഃ ശിഷ്യൈഃ സഹ കതിപയദിവസാൻ തസ്മിൻ ദമ്മേഷകനഗരേ സ്ഥിത്വാഽവിലമ്ബം ");
INSERT INTO sanmal_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","സർവ്വഭജനഭവനാനി ഗത്വാ യീശുരീശ്വരസ്യ പുത്ര ഇമാം കഥാം പ്രാചാരയത്| ");
INSERT INTO sanmal_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","തസ്മാത് സർവ്വേ ശ്രോതാരശ്ചമത്കൃത്യ കഥിതവന്തോ യോ യിരൂശാലമ്നഗര ഏതന്നാമ്നാ പ്രാർഥയിതൃലോകാൻ വിനാശിതവാൻ ഏവമ് ഏതാദൃശലോകാൻ ബദ്ധ്വാ പ്രധാനയാജകനികടം നയതീത്യാശയാ ഏതത്സ്ഥാനമപ്യാഗച്ഛത് സഏവ കിമയം ന ഭവതി? ");
INSERT INTO sanmal_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","കിന്തു ശൗലഃ ക്രമശ ഉത്സാഹവാൻ ഭൂത്വാ യീശുരീശ്വരേണാഭിഷിക്തോ ജന ഏതസ്മിൻ പ്രമാണം ദത്വാ ദമ്മേഷക്-നിവാസിയിഹൂദീയലോകാൻ നിരുത്തരാൻ അകരോത്| ");
INSERT INTO sanmal_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ഇത്ഥം ബഹുതിഥേ കാലേ ഗതേ യിഹൂദീയലോകാസ്തം ഹന്തും മന്ത്രയാമാസുഃ ");
INSERT INTO sanmal_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","കിന്തു ശൗലസ്തേഷാമേതസ്യാ മന്ത്രണായാ വാർത്താം പ്രാപ്തവാൻ| തേ തം ഹന്തും തു ദിവാനിശം ഗുപ്താഃ സന്തോ നഗരസ്യ ദ്വാരേഽതിഷ്ഠൻ; ");
INSERT INTO sanmal_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","തസ്മാത് ശിഷ്യാസ്തം നീത്വാ രാത്രൗ പിടകേ നിധായ പ്രാചീരേണാവാരോഹയൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","തതഃ പരം ശൗലോ യിരൂശാലമം ഗത്വാ ശിഷ്യഗണേന സാർദ്ധം സ്ഥാതുമ് ഐഹത്, കിന്തു സർവ്വേ തസ്മാദബിഭയുഃ സ ശിഷ്യ ഇതി ച ന പ്രത്യയൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","ഏതസ്മാദ് ബർണബ്ബാസ്തം ഗൃഹീത്വാ പ്രേരിതാനാം സമീപമാനീയ മാർഗമധ്യേ പ്രഭുഃ കഥം തസ്മൈ ദർശനം ദത്തവാൻ യാഃ കഥാശ്ച കഥിതവാൻ സ ച യഥാക്ഷോഭഃ സൻ ദമ്മേഷക്നഗരേ യീശോ ർനാമ പ്രാചാരയത് ഏതാൻ സർവ്വവൃത്താന്താൻ താൻ ജ്ഞാപിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","തതഃ ശൗലസ്തൈഃ സഹ യിരൂശാലമി കാലം യാപയൻ നിർഭയം പ്രഭോ ര്യീശോ ർനാമ പ്രാചാരയത്| ");
INSERT INTO sanmal_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","തസ്മാദ് അന്യദേശീയലോകൈഃ സാർദ്ധം വിവാദസ്യോപസ്ഥിതത്വാത് തേ തം ഹന്തുമ് അചേഷ്ടന്ത| ");
INSERT INTO sanmal_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","കിന്തു ഭ്രാതൃഗണസ്തജ്ജ്ഞാത്വാ തം കൈസരിയാനഗരം നീത്വാ താർഷനഗരം പ്രേഷിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ഇത്ഥം സതി യിഹൂദിയാഗാലീൽശോമിരോണദേശീയാഃ സർവ്വാ മണ്ഡല്യോ വിശ്രാമം പ്രാപ്താസ്തതസ്താസാം നിഷ്ഠാഭവത് പ്രഭോ ർഭിയാ പവിത്രസ്യാത്മനഃ സാന്ത്വനയാ ച കാലം ക്ഷേപയിത്വാ ബഹുസംഖ്യാ അഭവൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","തതഃ പരം പിതരഃ സ്ഥാനേ സ്ഥാനേ ഭ്രമിത്വാ ശേഷേ ലോദ്നഗരനിവാസിപവിത്രലോകാനാം സമീപേ സ്ഥിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","തദാ തത്ര പക്ഷാഘാതവ്യാധിനാഷ്ടൗ വത്സരാൻ ശയ്യാഗതമ് ഐനേയനാമാനം മനുഷ്യം സാക്ഷത് പ്രാപ്യ തമവദത്, ");
INSERT INTO sanmal_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ഹേ ഐനേയ യീശുഖ്രീഷ്ടസ്ത്വാം സ്വസ്ഥമ് അകാർഷീത്, ത്വമുത്ഥായ സ്വശയ്യാം നിക്ഷിപ, ഇത്യുക്തമാത്രേ സ ഉദതിഷ്ഠത്| ");
INSERT INTO sanmal_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ഏതാദൃശം ദൃഷ്ട്വാ ലോദ്ശാരോണനിവാസിനോ ലോകാഃ പ്രഭും പ്രതി പരാവർത്തന്ത| ");
INSERT INTO sanmal_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","അപരഞ്ച ഭിക്ഷാദാനാദിഷു നാനക്രിയാസു നിത്യം പ്രവൃത്താ യാ യാഫോനഗരനിവാസിനീ ടാബിഥാനാമാ ശിഷ്യാ യാം ദർക്കാം അർഥാദ് ഹരിണീമയുക്ത്വാ ആഹ്വയൻ സാ നാരീ ");
INSERT INTO sanmal_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","തസ്മിൻ സമയേ രുഗ്നാ സതീ പ്രാണാൻ അത്യജത്, തതോ ലോകാസ്താം പ്രക്ഷാല്യോപരിസ്ഥപ്രകോഷ്ഠേ ശായയിത്വാസ്ഥാപയൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","ലോദ്നഗരം യാഫോനഗരസ്യ സമീപസ്ഥം തസ്മാത്തത്ര പിതര ആസ്തേ, ഇതി വാർത്താം ശ്രുത്വാ തൂർണം തസ്യാഗമനാർഥം തസ്മിൻ വിനയമുക്ത്വാ ശിഷ്യഗണോ ദ്വൗ മനുജൗ പ്രേഷിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","തസ്മാത് പിതര ഉത്ഥായ താഭ്യാം സാർദ്ധമ് ആഗച്ഛത്, തത്ര തസ്മിൻ ഉപസ്ഥിത ഉപരിസ്ഥപ്രകോഷ്ഠം സമാനീതേ ച വിധവാഃ സ്വാഭിഃ സഹ സ്ഥിതികാലേ ദർക്കയാ കൃതാനി യാന്യുത്തരീയാണി പരിധേയാനി ച താനി സർവ്വാണി തം ദർശയിത്വാ രുദത്യശ്ചതസൃഷു ദിക്ഷ്വതിഷ്ഠൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","കിന്തു പിതരസ്താഃ സർവ്വാ ബഹിഃ കൃത്വാ ജാനുനീ പാതയിത്വാ പ്രാർഥിതവാൻ; പശ്ചാത് ശവം പ്രതി ദൃഷ്ടിം കൃത്വാ കഥിതവാൻ, ഹേ ടാബീഥേ ത്വമുത്തിഷ്ഠ, ഇതി വാക്യ ഉക്തേ സാ സ്ത്രീ ചക്ഷുഷീ പ്രോന്മീല്യ പിതരമ് അവലോക്യോത്ഥായോപാവിശത്| ");
INSERT INTO sanmal_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","തതഃ പിതരസ്തസ്യാഃ കരൗ ധൃത്വാ ഉത്തോല്യ പവിത്രലോകാൻ വിധവാശ്ചാഹൂയ തേഷാം നികടേ സജീവാം താം സമാർപയത്| ");
INSERT INTO sanmal_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ഏഷാ കഥാ സമസ്തയാഫോനഗരം വ്യാപ്താ തസ്മാദ് അനേകേ ലോകാഃ പ്രഭൗ വ്യശ്വസൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","അപരഞ്ച പിതരസ്തദ്യാഫോനഗരീയസ്യ കസ്യചിത് ശിമോന്നാമ്നശ്ചർമ്മകാരസ്യ ഗൃഹേ ബഹുദിനാനി ന്യവസത്| ");
INSERT INTO sanmal_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","കൈസരിയാനഗര ഇതാലിയാഖ്യസൈന്യാന്തർഗതഃ കർണീലിയനാമാ സേനാപതിരാസീത് ");
INSERT INTO sanmal_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","സ സപരിവാരോ ഭക്ത ഈശ്വരപരായണശ്ചാസീത്; ലോകേഭ്യോ ബഹൂനി ദാനാദീനി ദത്വാ നിരന്തരമ് ഈശ്വരേ പ്രാർഥയാഞ്ചക്രേ| ");
INSERT INTO sanmal_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ഏകദാ തൃതീയപ്രഹരവേലായാം സ ദൃഷ്ടവാൻ ഈശ്വരസ്യൈകോ ദൂതഃ സപ്രകാശം തത്സമീപമ് ആഗത്യ കഥിതവാൻ, ഹേ കർണീലിയ| ");
INSERT INTO sanmal_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","കിന്തു സ തം ദൃഷ്ട്വാ ഭീതോഽകഥയത്, ഹേ പ്രഭോ കിം? തദാ തമവദത് തവ പ്രാർഥനാ ദാനാദി ച സാക്ഷിസ്വരൂപം ഭൂത്വേശ്വരസ്യ ഗോചരമഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ഇദാനീം യാഫോനഗരം പ്രതി ലോകാൻ പ്രേഷ്യ സമുദ്രതീരേ ശിമോന്നാമ്നശ്ചർമ്മകാരസ്യ ഗൃഹേ പ്രവാസകാരീ പിതരനാമ്നാ വിഖ്യാതോ യഃ ശിമോൻ തമ് ആഹ്വായയ; ");
INSERT INTO sanmal_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","തസ്മാത് ത്വയാ യദ്യത് കർത്തവ്യം തത്തത് സ വദിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ഇത്യുപദിശ്യ ദൂതേ പ്രസ്ഥിതേ സതി കർണീലിയഃ സ്വഗൃഹസ്ഥാനാം ദാസാനാം ദ്വൗ ജനൗ നിത്യം സ്വസങ്ഗിനാം സൈന്യാനാമ് ഏകാം ഭക്തസേനാഞ്ചാഹൂയ ");
INSERT INTO sanmal_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","സകലമേതം വൃത്താന്തം വിജ്ഞാപ്യ യാഫോനഗരം താൻ പ്രാഹിണോത്| ");
INSERT INTO sanmal_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","പരസ്മിൻ ദിനേ തേ യാത്രാം കൃത്വാ യദാ നഗരസ്യ സമീപ ഉപാതിഷ്ഠൻ, തദാ പിതരോ ദ്വിതീയപ്രഹരവേലായാം പ്രാർഥയിതും ഗൃഹപൃഷ്ഠമ് ആരോഹത്| ");
INSERT INTO sanmal_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ഏതസ്മിൻ സമയേ ക്ഷുധാർത്തഃ സൻ കിഞ്ചിദ് ഭോക്തുമ് ഐച്ഛത് കിന്തു തേഷാമ് അന്നാസാദനസമയേ സ മൂർച്ഛിതഃ സന്നപതത്| ");
INSERT INTO sanmal_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","തതോ മേഘദ്വാരം മുക്തം ചതുർഭിഃ കോണൈ ർലമ്ബിതം ബൃഹദ്വസ്ത്രമിവ കിഞ്ചന ഭാജനമ് ആകാശാത് പൃഥിവീമ് അവാരോഹതീതി ദൃഷ്ടവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","തന്മധ്യേ നാനപ്രകാരാ ഗ്രാമ്യവന്യപശവഃ ഖേചരോരോഗാമിപ്രഭൃതയോ ജന്തവശ്ചാസൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","അനന്തരം ഹേ പിതര ഉത്ഥായ ഹത്വാ ഭുംക്ഷ്വ തമ്പ്രതീയം ഗഗണീയാ വാണീ ജാതാ| ");
INSERT INTO sanmal_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","തദാ പിതരഃ പ്രത്യവദത്, ഹേ പ്രഭോ ഈദൃശം മാ ഭവതു, അഹമ് ഏതത് കാലം യാവത് നിഷിദ്ധമ് അശുചി വാ ദ്രവ്യം കിഞ്ചിദപി ന ഭുക്തവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","തതഃ പുനരപി താദൃശീ വിഹയസീയാ വാണീ ജാതാ യദ് ഈശ്വരഃ ശുചി കൃതവാൻ തത് ത്വം നിഷിദ്ധം ന ജാനീഹി| ");
INSERT INTO sanmal_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ഇത്ഥം ത്രിഃ സതി തത് പാത്രം പുനരാകൃഷ്ടം ആകാശമ് അഗച്ഛത്| ");
INSERT INTO sanmal_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","തതഃ പരം യദ് ദർശനം പ്രാപ്തവാൻ തസ്യ കോ ഭാവ ഇത്യത്ര പിതരോ മനസാ സന്ദേഗ്ധി, ഏതസ്മിൻ സമയേ കർണീലിയസ്യ തേ പ്രേഷിതാ മനുഷ്യാ ദ്വാരസ്യ സന്നിധാവുപസ്ഥായ, ");
INSERT INTO sanmal_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ശിമോനോ ഗൃഹമന്വിച്ഛന്തഃ സമ്പൃഛ്യാഹൂയ കഥിതവന്തഃ പിതരനാമ്നാ വിഖ്യാതോ യഃ ശിമോൻ സ കിമത്ര പ്രവസതി? ");
INSERT INTO sanmal_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","യദാ പിതരസ്തദ്ദർശനസ്യ ഭാവം മനസാന്ദോലയതി തദാത്മാ തമവദത്, പശ്യ ത്രയോ ജനാസ്ത്വാം മൃഗയന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ത്വമ് ഉത്ഥായാവരുഹ്യ നിഃസന്ദേഹം തൈഃ സഹ ഗച്ഛ മയൈവ തേ പ്രേഷിതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","തസ്മാത് പിതരോഽവരുഹ്യ കർണീലിയപ്രേരിതലോകാനാം നികടമാഗത്യ കഥിതവാൻ പശ്യത യൂയം യം മൃഗയധ്വേ സ ജനോഹം, യൂയം കിന്നിമിത്തമ് ആഗതാഃ? ");
INSERT INTO sanmal_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","തതസ്തേ പ്രത്യവദൻ കർണീലിയനാമാ ശുദ്ധസത്ത്വ ഈശ്വരപരായണോ യിഹൂദീയദേശസ്ഥാനാം സർവ്വേഷാം സന്നിധൗ സുഖ്യാത്യാപന്ന ഏകഃ സേനാപതി ർനിജഗൃഹം ത്വാമാഹൂയ നേതും ത്വത്തഃ കഥാ ശ്രോതുഞ്ച പവിത്രദൂതേന സമാദിഷ്ടഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","തദാ പിതരസ്താനഭ്യന്തരം നീത്വാ തേഷാമാതിഥ്യം കൃതവാൻ, പരേഽഹനി തൈഃ സാർദ്ധം യാത്രാമകരോത്, യാഫോനിവാസിനാം ഭ്രാതൃണാം കിയന്തോ ജനാശ്ച തേന സഹ ഗതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","പരസ്മിൻ ദിവസേ കൈസരിയാനഗരമധ്യപ്രവേശസമയേ കർണീലിയോ ജ്ഞാതിബന്ധൂൻ ആഹൂയാനീയ താൻ അപേക്ഷ്യ സ്ഥിതഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","പിതരേ ഗൃഹ ഉപസ്ഥിതേ കർണീലിയസ്തം സാക്ഷാത്കൃത്യ ചരണയോഃ പതിത്വാ പ്രാണമത്| ");
INSERT INTO sanmal_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","പിതരസ്തമുത്ഥാപ്യ കഥിതവാൻ, ഉത്തിഷ്ഠാഹമപി മാനുഷഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","തദാ കർണീലിയേന സാകമ് ആലപൻ ഗൃഹം പ്രാവിശത് തന്മധ്യേ ച ബഹുലോകാനാം സമാഗമം ദൃഷ്ട്വാ താൻ അവദത്, ");
INSERT INTO sanmal_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","അന്യജാതീയലോകൈഃ മഹാലപനം വാ തേഷാം ഗൃഹമധ്യേ പ്രവേശനം യിഹൂദീയാനാം നിഷിദ്ധമ് അസ്തീതി യൂയമ് അവഗച്ഛഥ; കിന്തു കമപി മാനുഷമ് അവ്യവഹാര്യ്യമ് അശുചിം വാ ജ്ഞാതും മമ നോചിതമ് ഇതി പരമേശ്വരോ മാം ജ്ഞാപിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ഇതി ഹേതോരാഹ്വാനശ്രവണമാത്രാത് കാഞ്ചനാപത്തിമ് അകൃത്വാ യുഷ്മാകം സമീപമ് ആഗതോസ്മി; പൃച്ഛാമി യൂയം കിന്നിമിത്തം മാമ് ആഹൂയത? ");
INSERT INTO sanmal_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","തദാ കർണീലിയഃ കഥിതവാൻ, അദ്യ ചത്വാരി ദിനാനി ജാതാനി ഏതാവദ്വേലാം യാവദ് അഹമ് അനാഹാര ആസൻ തതസ്തൃതീയപ്രഹരേ സതി ഗൃഹേ പ്രാർഥനസമയേ തേജോമയവസ്ത്രഭൃദ് ഏകോ ജനോ മമ സമക്ഷം തിഷ്ഠൻ ഏതാം കഥാമ് അകഥയത്, ");
INSERT INTO sanmal_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ഹേ കർണീലിയ ത്വദീയാ പ്രാർഥനാ ഈശ്വരസ്യ കർണഗോചരീഭൂതാ തവ ദാനാദി ച സാക്ഷിസ്വരൂപം ഭൂത്വാ തസ്യ ദൃഷ്ടിഗോചരമഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","അതോ യാഫോനഗരം പ്രതി ലോകാൻ പ്രഹിത്യ തത്ര സമുദ്രതീരേ ശിമോന്നാമ്നഃ കസ്യചിച്ചർമ്മകാരസ്യ ഗൃഹേ പ്രവാസകാരീ പിതരനാമ്നാ വിഖ്യാതോ യഃ ശിമോൻ തമാഹൂाയയ; തതഃ സ ആഗത്യ ത്വാമ് ഉപദേക്ഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ഇതി കാരണാത് തത്ക്ഷണാത് തവ നികടേ ലോകാൻ പ്രേഷിതവാൻ, ത്വമാഗതവാൻ ഇതി ഭദ്രം കൃതവാൻ| ഈശ്വരോ യാന്യാഖ്യാനാനി കഥയിതുമ് ആദിശത് താനി ശ്രോതും വയം സർവ്വേ സാമ്പ്രതമ് ഈശ്വരസ്യ സാക്ഷാദ് ഉപസ്ഥിതാഃ സ്മഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","തദാ പിതര ഇമാം കഥാം കഥയിതുമ് ആരബ്ധവാൻ, ഈശ്വരോ മനുഷ്യാണാമ് അപക്ഷപാതീ സൻ ");
INSERT INTO sanmal_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","യസ്യ കസ്യചിദ് ദേശസ്യ യോ ലോകാസ്തസ്മാദ്ഭീത്വാ സത്കർമ്മ കരോതി സ തസ്യ ഗ്രാഹ്യോ ഭവതി, ഏതസ്യ നിശ്ചയമ് ഉപലബ്ധവാനഹമ്| ");
INSERT INTO sanmal_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","സർവ്വേഷാം പ്രഭു ര്യോ യീശുഖ്രീഷ്ടസ്തേന ഈശ്വര ഇസ്രായേല്വംശാനാം നികടേ സുസംവാദം പ്രേഷ്യ സമ്മേലനസ്യ യം സംവാദം പ്രാചാരയത് തം സംവാദം യൂയം ശ്രുതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","യതോ യോഹനാ മജ്ജനേ പ്രചാരിതേ സതി സ ഗാലീലദേശമാരഭ്യ സമസ്തയിഹൂദീയദേശം വ്യാപ്നോത്; ");
INSERT INTO sanmal_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ഫലത ഈശ്വരേണ പവിത്രേണാത്മനാ ശക്ത്യാ ചാഭിഷിക്തോ നാസരതീയയീശുഃ സ്ഥാനേ സ്ഥാനേ ഭ്രമൻ സുക്രിയാം കുർവ്വൻ ശൈതാനാ ക്ലിഷ്ടാൻ സർവ്വലോകാൻ സ്വസ്ഥാൻ അകരോത്, യത ഈശ്വരസ്തസ്യ സഹായ ആസീത്; ");
INSERT INTO sanmal_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","വയഞ്ച യിഹൂദീയദേശേ യിരൂശാലമ്നഗരേ ച തേന കൃതാനാം സർവ്വേഷാം കർമ്മണാം സാക്ഷിണോ ഭവാമഃ| ലോകാസ്തം ക്രുശേ വിദ്ധ്വാ ഹതവന്തഃ, ");
INSERT INTO sanmal_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","കിന്തു തൃതീയദിവസേ ഈശ്വരസ്തമുത്ഥാപ്യ സപ്രകാശമ് അദർശയത്| ");
INSERT INTO sanmal_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","സർവ്വലോകാനാം നികട ഇതി ന ഹി, കിന്തു തസ്മിൻ ശ്മശാനാദുത്ഥിതേ സതി തേന സാർദ്ധം ഭോജനം പാനഞ്ച കൃതവന്ത ഏതാദൃശാ ഈശ്വരസ്യ മനോനീതാഃ സാക്ഷിണോ യേ വയമ് അസ്മാകം നികടേ തമദർശയത്| ");
INSERT INTO sanmal_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ജീവിതമൃതോഭയലോകാനാം വിചാരം കർത്തുമ് ഈശ്വരോ യം നിയുക്തവാൻ സ ഏവ സ ജനഃ, ഇമാം കഥാം പ്രചാരയിതും തസ്മിൻ പ്രമാണം ദാതുഞ്ച സോഽസ്മാൻ ആജ്ഞാപയത്| ");
INSERT INTO sanmal_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","യസ്തസ്മിൻ വിശ്വസിതി സ തസ്യ നാമ്നാ പാപാന്മുക്തോ ഭവിഷ്യതി തസ്മിൻ സർവ്വേ ഭവിഷ്യദ്വാദിനോപി ഏതാദൃശം സാക്ഷ്യം ദദതി| ");
INSERT INTO sanmal_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","പിതരസ്യൈതത്കഥാകഥനകാലേ സർവ്വേഷാം ശ്രോതൃണാമുപരി പവിത്ര ആത്മാവാരോഹത്| ");
INSERT INTO sanmal_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","തതഃ പിതരേണ സാർദ്ധമ് ആഗതാസ്ത്വക്ഛേദിനോ വിശ്വാസിനോ ലോകാ അന്യദേശീയേഭ്യഃ പവിത്ര ആത്മനി ദത്തേ സതി ");
INSERT INTO sanmal_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","തേ നാനാജാതീയഭാഷാഭിഃ കഥാം കഥയന്ത ഈശ്വരം പ്രശംസന്തി, ഇതി ദൃഷ്ട്വാ ശ്രുത്വാ ച വിസ്മയമ് ആപദ്യന്ത| ");
INSERT INTO sanmal_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","തദാ പിതരഃ കഥിതവാൻ, വയമിവ യേ പവിത്രമ് ആത്മാനം പ്രാപ്താസ്തേഷാം ജലമജ്ജനം കിം കോപി നിഷേദ്ധും ശക്നോതി? ");
INSERT INTO sanmal_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","തതഃ പ്രഭോ ർനാമ്നാ മജ്ജിതാ ഭവതേതി താനാജ്ഞാപയത്| അനന്തരം തേ സ്വൈഃ സാർദ്ധം കതിപയദിനാനി സ്ഥാതും പ്രാർഥയന്ത| ");
INSERT INTO sanmal_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ഇത്ഥം ഭിന്നദേശീയലോകാ അപീശ്വരസ്യ വാക്യമ് അഗൃഹ്ലൻ ഇമാം വാർത്താം യിഹൂദീയദേശസ്ഥപ്രേരിതാ ഭ്രാതൃഗണശ്ച ശ്രുതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","തതഃ പിതരേ യിരൂശാലമ്നഗരം ഗതവതി ത്വക്ഛേദിനോ ലോകാസ്തേന സഹ വിവദമാനാ അവദൻ, ");
INSERT INTO sanmal_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ത്വമ് അത്വക്ഛേദിലോകാനാം ഗൃഹം ഗത്വാ തൈഃ സാർദ്ധം ഭുക്തവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","തതഃ പിതര ആദിതഃ ക്രമശസ്തത്കാര്യ്യസ്യ സർവ്വവൃത്താന്തമാഖ്യാതുമ് ആരബ്ധവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","യാഫോനഗര ഏകദാഹം പ്രാർഥയമാനോ മൂർച്ഛിതഃ സൻ ദർശനേന ചതുർഷു കോണേഷു ലമ്ബനമാനം വൃഹദ്വസ്ത്രമിവ പാത്രമേകമ് ആകാശദവരുഹ്യ മന്നികടമ് ആഗച്ഛദ് അപശ്യമ്| ");
INSERT INTO sanmal_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","പശ്ചാത് തദ് അനന്യദൃഷ്ട്യാ ദൃഷ്ട്വാ വിവിച്യ തസ്യ മധ്യേ നാനാപ്രകാരാൻ ഗ്രാമ്യവന്യപശൂൻ ഉരോഗാമിഖേചരാംശ്ച ദൃഷ്ടവാൻ; ");
INSERT INTO sanmal_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","ഹേ പിതര ത്വമുത്ഥായ ഗത്വാ ഭുംക്ഷ്വ മാം സമ്ബോധ്യ കഥയന്തം ശബ്ദമേകം ശ്രുതവാംശ്ച| ");
INSERT INTO sanmal_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","തതോഹം പ്രത്യവദം, ഹേ പ്രഭോ നേത്ഥം ഭവതു, യതഃ കിഞ്ചന നിഷിദ്ധമ് അശുചി ദ്രവ്യം വാ മമ മുഖമധ്യം കദാപി ന പ്രാവിശത്| ");
INSERT INTO sanmal_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","അപരമ് ഈശ്വരോ യത് ശുചി കൃതവാൻ തന്നിഷിദ്ധം ന ജാനീഹി ദ്വി ർമാമ്പ്രതീദൃശീ വിഹായസീയാ വാണീ ജാതാ| ");
INSERT INTO sanmal_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","ത്രിരിത്ഥം സതി തത് സർവ്വം പുനരാകാശമ് ആകൃഷ്ടം| ");
INSERT INTO sanmal_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","പശ്ചാത് കൈസരിയാനഗരാത് ത്രയോ ജനാ മന്നികടം പ്രേഷിതാ യത്ര നിവേശനേ സ്ഥിതോഹം തസ്മിൻ സമയേ തത്രോപാതിഷ്ഠൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","തദാ നിഃസന്ദേഹം തൈഃ സാർദ്ധം യാതുമ് ആത്മാ മാമാദിഷ്ടവാൻ; തതഃ പരം മയാ സഹൈതേഷു ഷഡ്ഭ്രാതൃഷു ഗതേഷു വയം തസ്യ മനുജസ്യ ഗൃഹം പ്രാവിശാമ| ");
INSERT INTO sanmal_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","സോസ്മാകം നികടേ കഥാമേതാമ് അകഥയത് ഏകദാ ദൂത ഏകഃ പ്രത്യക്ഷീഭൂയ മമ ഗൃഹമധ്യേ തിഷ്ടൻ മാമിത്യാജ്ഞാപിതവാൻ, യാഫോനഗരം പ്രതി ലോകാൻ പ്രഹിത്യ പിതരനാമ്നാ വിഖ്യാതം ശിമോനമ് ആഹൂയയ; ");
INSERT INTO sanmal_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","തതസ്തവ ത്വദീയപരിവാരാണാഞ്ച യേന പരിത്രാണം ഭവിഷ്യതി തത് സ ഉപദേക്ഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","അഹം താം കഥാമുത്ഥാപ്യ കഥിതവാൻ തേന പ്രഥമമ് അസ്മാകമ് ഉപരി യഥാ പവിത്ര ആത്മാവരൂഢവാൻ തഥാ തേഷാമപ്യുപരി സമവരൂഢവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","തേന യോഹൻ ജലേ മജ്ജിതവാൻ ഇതി സത്യം കിന്തു യൂയം പവിത്ര ആത്മനി മജ്ജിതാ ഭവിഷ്യഥ, ഇതി യദ്വാക്യം പ്രഭുരുദിതവാൻ തത് തദാ മയാ സ്മൃതമ്| ");
INSERT INTO sanmal_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","അതഃ പ്രഭാ യീശുഖ്രീഷ്ടേ പ്രത്യയകാരിണോ യേ വയമ് അസ്മഭ്യമ് ഈശ്വരോ യദ് ദത്തവാൻ തത് തേഭ്യോ ലോകേഭ്യോപി ദത്തവാൻ തതഃ കോഹം? കിമഹമ് ഈശ്വരം വാരയിതും ശക്നോമി? ");
INSERT INTO sanmal_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","കഥാമേതാം ശ്രുവാ തേ ക്ഷാന്താ ഈശ്വരസ്യ ഗുണാൻ അനുകീർത്ത്യ കഥിതവന്തഃ, തർഹി പരമായുഃപ്രാപ്തിനിമിത്തമ് ഈശ്വരോന്യദേശീയലോകേഭ്യോപി മനഃപരിവർത്തനരൂപം ദാനമ് അദാത്| ");
INSERT INTO sanmal_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","സ്തിഫാനം പ്രതി ഉപദ്രവേ ഘടിതേ യേ വികീർണാ അഭവൻ തൈ ഫൈനീകീകുപ്രാന്തിയഖിയാസു ഭ്രമിത്വാ കേവലയിഹൂദീയലോകാൻ വിനാ കസ്യാപ്യന്യസ്യ സമീപ ഈശ്വരസ്യ കഥാം ന പ്രാചാരയൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","അപരം തേഷാം കുപ്രീയാഃ കുരീനീയാശ്ച കിയന്തോ ജനാ ആന്തിയഖിയാനഗരം ഗത്വാ യൂനാനീയലോകാനാം സമീപേപി പ്രഭോര്യീശോഃ കഥാം പ്രാചാരയൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","പ്രഭോഃ കരസ്തേഷാം സഹായ ആസീത് തസ്മാദ് അനേകേ ലോകാ വിശ്വസ്യ പ്രഭും പ്രതി പരാവർത്തന്ത| ");
INSERT INTO sanmal_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ഇതി വാർത്തായാം യിരൂശാലമസ്ഥമണ്ഡലീയലോകാനാം കർണഗോചരീഭൂതായാമ് ആന്തിയഖിയാനഗരം ഗന്തു തേ ബർണബ്ബാം പ്രൈരയൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","തതോ ബർണബ്ബാസ്തത്ര ഉപസ്ഥിതഃ സൻ ഈശ്വരസ്യാനുഗ്രഹസ്യ ഫലം ദൃഷ്ട്വാ സാനന്ദോ ജാതഃ, ");
INSERT INTO sanmal_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","സ സ്വയം സാധു ർവിശ്വാസേന പവിത്രേണാത്മനാ ച പരിപൂർണഃ സൻ ഗനോനിഷ്ടയാ പ്രഭാവാസ്ഥാം കർത്തും സർവ്വാൻ ഉപദിഷ്ടവാൻ തേന പ്രഭോഃ ശിഷ്യാ അനേകേ ബഭൂവുഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","ശേഷേ ശൗലം മൃഗയിതും ബർണബ്ബാസ്താർഷനഗരം പ്രസ്ഥിതവാൻ| തത്ര തസ്യോദ്ദേശം പ്രാപ്യ തമ് ആന്തിയഖിയാനഗരമ് ആനയത്; ");
INSERT INTO sanmal_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","തതസ്തൗ മണ്ഡലീസ്ഥലോകൈഃ സഭാം കൃത്വാ സംവത്സരമേകം യാവദ് ബഹുലോകാൻ ഉപാദിശതാം; തസ്മിൻ ആന്തിയഖിയാനഗരേ ശിഷ്യാഃ പ്രഥമം ഖ്രീഷ്ടീയനാമ്നാ വിഖ്യാതാ അഭവൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","തതഃ പരം ഭവിഷ്യദ്വാദിഗണേ യിരൂശാലമ ആന്തിയഖിയാനഗരമ് ആഗതേ സതി ");
INSERT INTO sanmal_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ആഗാബനാമാ തേഷാമേക ഉത്ഥായ ആത്മനഃ ശിക്ഷയാ സർവ്വദേശേ ദുർഭിക്ഷം ഭവിഷ്യതീതി ജ്ഞാപിതവാൻ; തതഃ ക്ലൗദിയകൈസരസ്യാധികാരേ സതി തത് പ്രത്യക്ഷമ് അഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","തസ്മാത് ശിഷ്യാ ഏകൈകശഃ സ്വസ്വശക്ത്യനുസാരതോ യിഹൂദീയദേശനിവാസിനാം ഭ്രതൃണാം ദിനയാപനാർഥം ധനം പ്രേഷയിതും നിശ്ചിത്യ ");
INSERT INTO sanmal_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ബർണബ്ബാശൗലയോ ർദ്വാരാ പ്രാചീനലോകാനാം സമീപം തത് പ്രേഷിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","തസ്മിൻ സമയേ ഹേരോദ്‌രാജോ മണ്ഡല്യാഃ കിയജ്ജനേഭ്യോ ദുഃഖം ദാതും പ്രാരഭത്| ");
INSERT INTO sanmal_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","വിശേഷതോ യോഹനഃ സോദരം യാകൂബം കരവാലാഘാതേൻ ഹതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","തസ്മാദ് യിഹൂദീയാഃ സന്തുഷ്ടാ അഭവൻ ഇതി വിജ്ഞായ സ പിതരമപി ധർത്തും ഗതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","തദാ കിണ്വശൂന്യപൂപോത്സവസമയ ഉപാതിഷ്ടത്; അത ഉത്സവേ ഗതേ സതി ലോകാനാം സമക്ഷം തം ബഹിരാനേയ്യാമീതി മനസി സ്ഥിരീകൃത്യ സ തം ധാരയിത്വാ രക്ഷ്ണാർഥമ് യേഷാമ് ഏകൈകസംഘേ ചത്വാരോ ജനാഃ സന്തി തേഷാം ചതുർണാം രക്ഷകസംഘാനാം സമീപേ തം സമർപ്യ കാരായാം സ്ഥാപിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","കിന്തും പിതരസ്യ കാരാസ്ഥിതികാരണാത് മണ്ഡല്യാ ലോകാ അവിശ്രാമമ് ഈശ്വരസ്യ സമീപേ പ്രാർഥയന്ത| ");
INSERT INTO sanmal_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","അനന്തരം ഹേരോദി തം ബഹിരാനായിതും ഉദ്യതേ സതി തസ്യാം രാത്രൗ പിതരോ രക്ഷകദ്വയമധ്യസ്ഥാനേ ശൃങ്ഖലദ്വയേന ബദ്ധ്വഃ സൻ നിദ്രിത ആസീത്, ദൗവാരികാശ്ച കാരായാഃ സമ്മുഖേ തിഷ്ഠനതോ ദ്വാരമ് അരക്ഷിഷുഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ഏതസ്മിൻ സമയേ പരമേശ്വരസ്യ ദൂതേ സമുപസ്ഥിതേ കാരാ ദീപ്തിമതീ ജാതാ; തതഃ സ ദൂതഃ പിതരസ്യ കുക്ഷാവാവാതം കൃത്വാ തം ജാഗരയിത്വാ ഭാഷിതവാൻ തൂർണമുത്തിഷ്ഠ; തതസ്തസ്യ ഹസ്തസ്ഥശൃങ്ഖലദ്വയം ഗലത് പതിതം| ");
INSERT INTO sanmal_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","സ ദൂതസ്തമവദത്, ബദ്ധകടിഃ സൻ പാദയോഃ പാദുകേ അർപയ; തേന തഥാ കൃതേ സതി ദൂതസ്തമ് ഉക്തവാൻ ഗാത്രീയവസ്ത്രം ഗാത്രേ നിധായ മമ പശ്ചാദ് ഏഹി| ");
INSERT INTO sanmal_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","തതഃ പിതരസ്തസ്യ പശ്ചാദ് വ്രജന ബഹിരഗച്ഛത്, കിന്തു ദൂതേന കർമ്മൈതത് കൃതമിതി സത്യമജ്ഞാത്വാ സ്വപ്നദർശനം ജ്ഞാതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ഇത്ഥം തൗ പ്രഥമാം ദ്വിതീയാഞ്ച കാരാം ലങ്ഘിത്വാ യേന ലൗഹനിർമ്മിതദ്വാരേണ നഗരം ഗമ്യതേ തത്സമീപം പ്രാപ്നുതാം; തതസ്തസ്യ കവാടം സ്വയം മുക്തമഭവത് തതസ്തൗ തത്സ്ഥാനാദ് ബഹി ർഭൂത്വാ മാർഗൈകസ്യ സീമാം യാവദ് ഗതൗ; തതോഽകസ്മാത് സ ദൂതഃ പിതരം ത്യക്തവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","തദാ സ ചേതനാം പ്രാപ്യ കഥിതവാൻ നിജദൂതം പ്രഹിത്യ പരമേശ്വരോ ഹേരോദോ ഹസ്താദ് യിഹൂദീയലോകാനാം സർവ്വാശായാശ്ച മാം സമുദ്ധൃതവാൻ ഇത്യഹം നിശ്ചയം ജ്ഞാതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","സ വിവിച്യ മാർകനാമ്രാ വിഖ്യാതസ്യ യോഹനോ മാതു ർമരിയമോ യസ്മിൻ ഗൃഹേ ബഹവഃ സമ്ഭൂയ പ്രാർഥയന്ത തന്നിവേശനം ഗതഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","പിതരേണ ബഹിർദ്വാര ആഹതേ സതി രോദാനാമാ ബാലികാ ദ്രഷ്ടും ഗതാ| ");
INSERT INTO sanmal_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","തതഃ പിതരസ്യ സ്വരം ശ്രുവാ സാ ഹർഷയുക്താ സതീ ദ്വാരം ന മോചയിത്വാ പിതരോ ദ്വാരേ തിഷ്ഠതീതി വാർത്താം വക്തുമ് അഭ്യന്തരം ധാവിത്വാ ഗതവതീ| ");
INSERT INTO sanmal_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","തേ പ്രാവോചൻ ത്വമുന്മത്താ ജാതാസി കിന്തു സാ മുഹുർമുഹുരുക്തവതീ സത്യമേവൈതത്| ");
INSERT INTO sanmal_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","തദാ തേ കഥിതവന്തസ്തർഹി തസ്യ ദൂതോ ഭവേത്| ");
INSERT INTO sanmal_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","പിതരോ ദ്വാരമാഹതവാൻ ഏതസ്മിന്നന്തരേ ദ്വാരം മോചയിത്വാ പിതരം ദൃഷ്ട്വാ വിസ്മയം പ്രാപ്താഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","തതഃ പിതരോ നിഃശബ്ദം സ്ഥാതും താൻ പ്രതി ഹസ്തേന സങ്കേതം കൃത്വാ പരമേശ്വരോ യേന പ്രകാരേണ തം കാരായാ ഉദ്ധൃത്യാനീതവാൻ തസ്യ വൃത്താന്തം താനജ്ഞാപയത്, യൂയം ഗത്വാ യാകുബം ഭ്രാതൃഗണഞ്ച വാർത്താമേതാം വദതേത്യുക്താ സ്ഥാനാന്തരം പ്രസ്ഥിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","പ്രഭാതേ സതി പിതരഃ ക്വ ഗത ഇത്യത്ര രക്ഷകാണാം മധ്യേ മഹാൻ കലഹോ ജാതഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ഹേരോദ് ബഹു മൃഗയിത്വാ തസ്യോദ്ദേശേ ന പ്രാപ്തേ സതി രക്ഷകാൻ സംപൃച്ഛ്യ തേഷാം പ്രാണാൻ ഹന്തുമ് ആദിഷ്ടവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","പശ്ചാത് സ യിഹൂദീയപ്രദേശാത് കൈസരിയാനഗരം ഗത്വാ തത്രാവാതിഷ്ഠത്| ");
INSERT INTO sanmal_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","സോരസീദോനദേശയോ ർലോകേഭ്യോ ഹേരോദി യുയുത്സൗ സതി തേ സർവ്വ ഏകമന്ത്രണാഃ സന്തസ്തസ്യ സമീപ ഉപസ്ഥായ ല്വാസ്തനാമാനം തസ്യ വസ്ത്രഗൃഹാധീശം സഹായം കൃത്വാ ഹേരോദാ സാർദ്ധം സന്ധിം പ്രാർഥയന്ത യതസ്തസ്യ രാജ്ഞോ ദേശേന തേഷാം ദേശീയാനാം ഭരണമ് അഭവത്ം ");
INSERT INTO sanmal_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","അതഃ കുത്രചിൻ നിരുപിതദിനേ ഹേരോദ് രാജകീയം പരിച്ഛദം പരിധായ സിംഹാസനേ സമുപവിശ്യ താൻ പ്രതി കഥാമ് ഉക്തവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","തതോ ലോകാ ഉച്ചൈഃകാരം പ്രത്യവദൻ, ഏഷ മനുജരവോ ന ഹി, ഈശ്വരീയരവഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","തദാ ഹേരോദ് ഈശ്വരസ്യ സമ്മാനം നാകരോത്; തസ്മാദ്ധേതോഃ പരമേശ്വരസ്യ ദൂതോ ഹഠാത് തം പ്രാഹരത് തേനൈവ സ കീടൈഃ ക്ഷീണഃ സൻ പ്രാണാൻ അജഹാത്| കിന്ത്വീശ്വരസ്യ കഥാ ദേശം വ്യാപ്യ പ്രബലാഭവത്| തതഃ പരം ബർണബ്ബാശൗലൗ യസ്യ കർമ്മണോ ഭാരം പ്രാപ്നുതാം താഭ്യാം തസ്മിൻ സമ്പാദിതേ സതി മാർകനാമ്നാ വിഖ്യാതോ യോ യോഹൻ തം സങ്ഗിനം കൃത്വാ യിരൂശാലമ്നഗരാത് പ്രത്യാഗതൗ| ");
INSERT INTO sanmal_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","അപരഞ്ച ബർണബ്ബാഃ, ശിമോൻ യം നിഗ്രം വദന്തി, കുരീനീയലൂകിയോ ഹേരോദാ രാജ്ഞാ സഹ കൃതവിദ്യാाഭ്യാസോ മിനഹേമ്, ശൗലശ്ചൈതേ യേ കിയന്തോ ജനാ ഭവിഷ്യദ്വാദിന ഉപദേഷ്ടാരശ്ചാന്തിയഖിയാനഗരസ്ഥമണ്ഡല്യാമ് ആസൻ, ");
INSERT INTO sanmal_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","തേ യദോപവാസം കൃത്വേശ്വരമ് അസേവന്ത തസ്മിൻ സമയേ പവിത്ര ആത്മാ കഥിതവാൻ അഹം യസ്മിൻ കർമ്മണി ബർണബ്ബാശൈലൗ നിയുക്തവാൻ തത്കർമ്മ കർത്തും തൗ പൃഥക് കുരുത| ");
INSERT INTO sanmal_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","തതസ്തൈരുപവാസപ്രാർഥനയോഃ കൃതയോഃ സതോസ്തേ തയോ ർഗാത്രയോ ർഹസ്താർപണം കൃത്വാ തൗ വ്യസൃജൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","തതഃ പരം തൗ പവിത്രേണാത്മനാ പ്രേരിതൗ സന്തൗ സിലൂകിയാനഗരമ് ഉപസ്ഥായ സമുദ്രപഥേന കുപ്രോപദ്വീപമ് അഗച്ഛതാം| ");
INSERT INTO sanmal_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","തതഃ സാലാമീനഗരമ് ഉപസ്ഥായ തത്ര യിഹൂദീയാനാം ഭജനഭവനാനി ഗത്വേശ്വരസ്യ കഥാം പ്രാചാരയതാം; യോഹനപി തത്സഹചരോഽഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ഇത്ഥം തേ തസ്യോപദ്വീപസ്യ സർവ്വത്ര ഭ്രമന്തഃ പാഫനഗരമ് ഉപസ്ഥിതാഃ; തത്ര സുവിവേചകേന സർജിയപൗലനാമ്നാ തദ്ദേശാധിപതിനാ സഹ ഭവിഷ്യദ്വാദിനോ വേശധാരീ ബര്യീശുനാമാ യോ മായാവീ യിഹൂദീ ആസീത് തം സാക്ഷാത് പ്രാപ്തവതഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","തദ്ദേശാധിപ ഈശ്വരസ്യ കഥാം ശ്രോതും വാഞ്ഛൻ പൗലബർണബ്ബൗ ന്യമന്ത്രയത്| ");
INSERT INTO sanmal_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","കിന്ത്വിലുമാ യം മായാവിനം വദന്തി സ ദേശാധിപതിം ധർമ്മമാർഗാദ് ബഹിർഭൂതം കർത്തുമ് അയതത| ");
INSERT INTO sanmal_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","തസ്മാത് ശോലോഽർഥാത് പൗലഃ പവിത്രേണാത്മനാ പരിപൂർണഃ സൻ തം മായാവിനം പ്രത്യനന്യദൃഷ്ടിം കൃത്വാകഥയത്, ");
INSERT INTO sanmal_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ഹേ നരകിൻ ധർമ്മദ്വേഷിൻ കൗടില്യദുഷ്കർമ്മപരിപൂർണ, ത്വം കിം പ്രഭോഃ സത്യപഥസ്യ വിപര്യ്യയകരണാത് കദാപി ന നിവർത്തിഷ്യസേ? ");
INSERT INTO sanmal_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","അധുനാ പരമേശ്വരസ്തവ സമുചിതം കരിഷ്യതി തേന കതിപയദിനാനി ത്വമ് അന്ധഃ സൻ സൂര്യ്യമപി ന ദ്രക്ഷ്യസി| തത്ക്ഷണാദ് രാത്രിവദ് അന്ധകാരസ്തസ്യ ദൃഷ്ടിമ് ആച്ഛാദിതവാൻ; തസ്മാത് തസ്യ ഹസ്തം ധർത്തും സ ലോകമന്വിച്ഛൻ ഇതസ്തതോ ഭ്രമണം കൃതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ഏനാം ഘടനാം ദൃഷ്ട്വാ സ ദേശാധിപതിഃ പ്രഭൂപദേശാദ് വിസ്മിത്യ വിശ്വാസം കൃതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","തദനന്തരം പൗലസ്തത്സങ്ഗിനൗ ച പാഫനഗരാത് പ്രോതം ചാലയിത്വാ പമ്ഫുലിയാദേശസ്യ പർഗീനഗരമ് അഗച്ഛൻ കിന്തു യോഹൻ തയോഃ സമീപാദ് ഏത്യ യിരൂശാലമം പ്രത്യാഗച്ഛത്| ");
INSERT INTO sanmal_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","പശ്ചാത് തൗ പർഗീതോ യാത്രാം കൃത്വാ പിസിദിയാദേശസ്യ ആന്തിയഖിയാനഗരമ് ഉപസ്ഥായ വിശ്രാമവാരേ ഭജനഭവനം പ്രവിശ്യ സമുപാവിശതാം| ");
INSERT INTO sanmal_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","വ്യവസ്ഥാഭവിഷ്യദ്വാക്യയോഃ പഠിതയോഃ സതോ ർഹേ ഭ്രാതരൗ ലോകാൻ പ്രതി യുവയോഃ കാചിദ് ഉപദേശകഥാ യദ്യസ്തി തർഹി താം വദതം തൗ പ്രതി തസ്യ ഭജനഭവനസ്യാധിപതയഃ കഥാമ് ഏതാം കഥയിത്വാ പ്രൈഷയൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","അതഃ പൗല ഉത്തിഷ്ഠൻ ഹസ്തേന സങ്കേതം കുർവ്വൻ കഥിതവാൻ ഹേ ഇസ്രായേലീയമനുഷ്യാ ഈശ്വരപരായണാഃ സർവ്വേ ലോകാ യൂയമ് അവധദ്ധം| ");
INSERT INTO sanmal_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ഏതേഷാമിസ്രായേല്ലോകാനാമ് ഈശ്വരോഽസ്മാകം പൂർവ്വപരുഷാൻ മനോനീതാൻ കത്വാ ഗൃഹീതവാൻ തതോ മിസരി ദേശേ പ്രവസനകാലേ തേഷാമുന്നതിം കൃത്വാ തസ്മാത് സ്വീയബാഹുബലേന താൻ ബഹിഃ കൃത്വാ സമാനയത്| ");
INSERT INTO sanmal_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ചത്വാരിംശദ്വത്സരാൻ യാവച്ച മഹാപ്രാന്തരേ തേഷാം ഭരണം കൃത്വാ ");
INSERT INTO sanmal_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","കിനാന്ദേശാന്തർവ്വർത്തീണി സപ്തരാജ്യാനി നാശയിത്വാ ഗുടികാപാതേന തേഷു സർവ്വദേശേഷു തേഭ്യോഽധികാരം ദത്തവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","പഞ്ചാശദധികചതുഃശതേഷു വത്സരേഷു ഗതേഷു ച ശിമൂയേൽഭവിഷ്യദ്വാദിപര്യ്യന്തം തേഷാമുപരി വിചാരയിതൃൻ നിയുക്തവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","തൈശ്ച രാജ്ഞി പ്രാർഥിതേ, ഈശ്വരോ ബിന്യാമീനോ വംശജാതസ്യ കീശഃ പുത്രം ശൗലം ചത്വാരിംശദ്വർഷപര്യ്യന്തം തേഷാമുപരി രാജാനം കൃതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","പശ്ചാത് തം പദച്യുതം കൃത്വാ യോ മദിഷ്ടക്രിയാഃ സർവ്വാഃ കരിഷ്യതി താദൃശം മമ മനോഭിമതമ് ഏകം ജനം യിശയഃ പുത്രം ദായൂദം പ്രാപ്തവാൻ ഇദം പ്രമാണം യസ്മിൻ ദായൂദി സ ദത്തവാൻ തം ദായൂദം തേഷാമുപരി രാജത്വം കർത്തുമ് ഉത്പാദിതവാന| ");
INSERT INTO sanmal_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","തസ്യ സ്വപ്രതിശ്രുതസ്യ വാക്യസ്യാനുസാരേണ ഇസ്രായേല്ലോകാനാം നിമിത്തം തേഷാം മനുഷ്യാണാം വംശാദ് ഈശ്വര ഏകം യീശും (ത്രാതാരമ്) ഉദപാദയത്| ");
INSERT INTO sanmal_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","തസ്യ പ്രകാശനാത് പൂർവ്വം യോഹൻ ഇസ്രായേല്ലോകാനാം സന്നിധൗ മനഃപരാവർത്തനരൂപം മജ്ജനം പ്രാചാരയത്| ");
INSERT INTO sanmal_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","യസ്യ ച കർമ്മണോे ഭാരം പ്രപ്തവാൻ യോഹൻ തൻ നിഷ്പാദയൻ ഏതാം കഥാം കഥിതവാൻ, യൂയം മാം കം ജനം ജാനീഥ? അഹമ് അഭിഷിക്തത്രാതാ നഹി, കിന്തു പശ്യത യസ്യ പാദയോഃ പാദുകയോ ർബന്ധനേ മോചയിതുമപി യോഗ്യോ ന ഭവാമി താദൃശ ഏകോ ജനോ മമ പശ്ചാദ് ഉപതിഷ്ഠതി| ");
INSERT INTO sanmal_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","ഹേ ഇബ്രാഹീമോ വംശജാതാ ഭ്രാതരോ ഹേ ഈശ്വരഭീതാഃ സർവ്വലോകാ യുഷ്മാൻ പ്രതി പരിത്രാണസ്യ കഥൈഷാ പ്രേരിതാ| ");
INSERT INTO sanmal_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","യിരൂശാലമ്നിവാസിനസ്തേഷാമ് അധിപതയശ്ച തസ്യ യീശോഃ പരിചയം ന പ്രാപ്യ പ്രതിവിശ്രാമവാരം പഠ്യമാനാനാം ഭവിഷ്യദ്വാദികഥാനാമ് അഭിപ്രായമ് അബുദ്ധ്വാ ച തസ്യ വധേന താഃ കഥാഃ സഫലാ അകുർവ്വൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","പ്രാണഹനനസ്യ കമപി ഹേതുമ് അപ്രാപ്യാപി പീലാതസ്യ നികടേ തസ്യ വധം പ്രാർഥയന്ത| ");
INSERT INTO sanmal_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","തസ്മിൻ യാഃ കഥാ ലിഖിതാഃ സന്തി തദനുസാരേണ കർമ്മ സമ്പാദ്യ തം ക്രുശാദ് അവതാര്യ്യ ശ്മശാനേ ശായിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","കിന്ത്വീശ്വരഃ ശ്മശാനാത് തമുദസ്ഥാപയത്, ");
INSERT INTO sanmal_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","പുനശ്ച ഗാലീലപ്രദേശാദ് യിരൂശാലമനഗരം തേന സാർദ്ധം യേ ലോകാ ആഗച്ഛൻ സ ബഹുദിനാനി തേഭ്യോ ദർശനം ദത്തവാൻ, അതസ്ത ഇദാനീം ലോകാൻ പ്രതി തസ്യ സാക്ഷിണഃ സന്തി| ");
INSERT INTO sanmal_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","അസ്മാകം പൂർവ്വപുരുഷാണാം സമക്ഷമ് ഈശ്വരോ യസ്മിൻ പ്രതിജ്ഞാതവാൻ യഥാ, ത്വം മേ പുത്രോസി ചാദ്യ ത്വാം സമുത്ഥാപിതവാനഹമ്| ");
INSERT INTO sanmal_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ഇദം യദ്വചനം ദ്വിതീയഗീതേ ലിഖിതമാസ്തേ തദ് യീശോരുത്ഥാനേന തേഷാം സന്താനാ യേ വയമ് അസ്മാകം സന്നിധൗ തേന പ്രത്യക്ഷീ കൃതം, യുഷ്മാൻ ഇമം സുസംവാദം ജ്ഞാപയാമി| ");
INSERT INTO sanmal_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","പരമേശ്വരേണ ശ്മശാനാദ് ഉത്ഥാപിതം തദീയം ശരീരം കദാപി ന ക്ഷേഷ്യതേ, ഏതസ്മിൻ സ സ്വയം കഥിതവാൻ യഥാ ദായൂദം പ്രതി പ്രതിജ്ഞാതോ യോ വരസ്തമഹം തുഭ്യം ദാസ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","ഏതദന്യസ്മിൻ ഗീതേഽപി കഥിതവാൻ| സ്വകീയം പുണ്യവന്തം ത്വം ക്ഷയിതും ന ച ദാസ്യസി| ");
INSERT INTO sanmal_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","ദായൂദാ ഈശ്വരാഭിമതസേവായൈ നിജായുഷി വ്യയിതേ സതി സ മഹാനിദ്രാം പ്രാപ്യ നിജൈഃ പൂർവ്വപുരുഷൈഃ സഹ മിലിതഃ സൻ അക്ഷീയത; ");
INSERT INTO sanmal_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","കിന്തു യമീശ്വരഃ ശ്മശാനാദ് ഉദസ്ഥാപയത് സ നാക്ഷീയത| ");
INSERT INTO sanmal_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","അതോ ഹേ ഭ്രാതരഃ, അനേന ജനേന പാപമോചനം ഭവതീതി യുഷ്മാൻ പ്രതി പ്രചാരിതമ് ആസ്തേ| ");
INSERT INTO sanmal_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ഫലതോ മൂസാവ്യവസ്ഥയാ യൂയം യേഭ്യോ ദോഷേഭ്യോ മുക്താ ഭവിതും ന ശക്ഷ്യഥ തേഭ്യഃ സർവ്വദോഷേഭ്യ ഏതസ്മിൻ ജനേ വിശ്വാസിനഃ സർവ്വേ മുക്താ ഭവിഷ്യന്തീതി യുഷ്മാഭി ർജ്ഞായതാം| ");
INSERT INTO sanmal_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","അപരഞ്ച| അവജ്ഞാകാരിണോ ലോകാശ്ചക്ഷുരുന്മീല്യ പശ്യത| തഥൈവാസമ്ഭവം ജ്ഞാത്വാ സ്യാത യൂയം വിലജ്ജിതാഃ| യതോ യുഷ്മാസു തിഷ്ഠത്സു കരിഷ്യേ കർമ്മ താദൃശം| യേനൈവ തസ്യ വൃത്താന്തേ യുഷ്മഭ്യം കഥിതേഽപി ഹി| യൂയം ന തന്തു വൃത്താന്തം പ്രത്യേഷ്യഥ കദാചന|| ");
INSERT INTO sanmal_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","യേയം കഥാ ഭവിഷ്യദ്വാദിനാം ഗ്രന്ഥേഷു ലിഖിതാസ്തേ സാവധാനാ ഭവത സ കഥാ യഥാ യുഷ്മാൻ പ്രതി ന ഘടതേ| ");
INSERT INTO sanmal_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","യിഹൂദീയഭജനഭവനാൻ നിർഗതയോസ്തയോ ർഭിന്നദേശീയൈ ർവക്ഷ്യമാണാ പ്രാർഥനാ കൃതാ, ആഗാമിനി വിശ്രാമവാരേഽപി കഥേയമ് അസ്മാൻ പ്രതി പ്രചാരിതാ ഭവത്വിതി| ");
INSERT INTO sanmal_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","സഭായാ ഭങ്ഗേ സതി ബഹവോ യിഹൂദീയലോകാ യിഹൂദീയമതഗ്രാഹിണോ ഭക്തലോകാശ്ച ബർണബ്ബാപൗലയോഃ പശ്ചാദ് ആഗച്ഛൻ, തേന തൗ തൈഃ സഹ നാനാകഥാഃ കഥയിത്വേശ്വരാനുഗ്രഹാശ്രയേ സ്ഥാതും താൻ പ്രാവർത്തയതാം| ");
INSERT INTO sanmal_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","പരവിശ്രാമവാരേ നഗരസ്യ പ്രായേണ സർവ്വേ ലാകാ ഈശ്വരീയാം കഥാം ശ്രോതും മിലിതാഃ, ");
INSERT INTO sanmal_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","കിന്തു യിഹൂദീയലോകാ ജനനിവഹം വിലോക്യ ഈർഷ്യയാ പരിപൂർണാഃ സന്തോ വിപരീതകഥാകഥനേനേശ്വരനിന്ദയാ ച പൗലേനോക്താം കഥാം ഖണ്ഡയിതും ചേഷ്ടിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","തതഃ പൗैലബർണബ്ബാവക്ഷോഭൗ കഥിതവന്തൗ പ്രഥമം യുഷ്മാകം സന്നിധാവീശ്വരീയകഥായാഃ പ്രചാരണമ് ഉചിതമാസീത് കിന്തും തദഗ്രാഹ്യത്വകരണേന യൂയം സ്വാൻ അനന്തായുഷോഽയോഗ്യാൻ ദർശയഥ, ഏതത്കാരണാദ് വയമ് അന്യദേശീയലോകാനാം സമീപം ഗച്ഛാമഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","പ്രഭുരസ്മാൻ ഇത്ഥമ് ആദിഷ്ടവാൻ യഥാ, യാവച്ച ജഗതഃ സീമാം ലോകാനാം ത്രാണകാരണാത്| മയാന്യദേശമധ്യേ ത്വം സ്ഥാപിതോ ഭൂഃ പ്രദീപവത്|| ");
INSERT INTO sanmal_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","തദാ കഥാമീദൃശീം ശ്രുത്വാ ഭിന്നദേശീയാ ആഹ്ലാദിതാഃ സന്തഃ പ്രഭോഃ കഥാം ധന്യാം ധന്യാമ് അവദൻ, യാവന്തോ ലോകാശ്ച പരമായുഃ പ്രാപ്തിനിമിത്തം നിരൂപിതാ ആസൻ തേे വ്യശ്വസൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ഇത്ഥം പ്രഭോഃ കഥാ സർവ്വേദേശം വ്യാപ്നോത്| ");
INSERT INTO sanmal_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","കിന്തു യിഹൂദീയാ നഗരസ്യ പ്രധാനപുരുഷാൻ സമ്മാന്യാഃ കഥിപയാ ഭക്താ യോഷിതശ്ച കുപ്രവൃത്തിം ഗ്രാഹയിത്വാ പൗലബർണബ്ബൗ താഡയിത്വാ തസ്മാത് പ്രദേശാദ് ദൂരീകൃതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","അതഃ കാരണാത് തൗ നിജപദധൂലീസ്തേഷാം പ്രാതികൂല്യേന പാതയിത്വേेകനിയം നഗരം ഗതൗ| ");
INSERT INTO sanmal_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","തതഃ ശിഷ്യഗണ ആനന്ദേന പവിത്രേണാത്മനാ ച പരിപൂർണോഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","തൗ ദ്വൗ ജനൗ യുഗപദ് ഇകനിയനഗരസ്ഥയിഹൂദീയാനാം ഭജനഭവനം ഗത്വാ യഥാ ബഹവോ യിഹൂദീയാ അന്യദേेശീയലോകാശ്ച വ്യശ്വസൻ താദൃശീം കഥാം കഥിതവന്തൗ| ");
INSERT INTO sanmal_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","കിന്തു വിശ്വാസഹീനാ യിഹൂദീയാ അന്യദേശീയലോകാൻ കുപ്രവൃത്തിം ഗ്രാഹയിത്വാ ഭ്രാതൃഗണം പ്രതി തേഷാം വൈരം ജനിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","അതഃ സ്വാനുഗ്രഹകഥായാഃ പ്രമാണം ദത്വാ തയോ ർഹസ്തൈ ർബഹുലക്ഷണമ് അദ്ഭുതകർമ്മ ച പ്രാകാശയദ് യഃ പ്രഭുസ്തസ്യ കഥാ അക്ഷോഭേന പ്രചാര്യ്യ തൗ തത്ര ബഹുദിനാനി സമവാതിഷ്ഠേതാം| ");
INSERT INTO sanmal_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","കിന്തു കിയന്തോ ലോകാ യിഹൂദീയാനാം സപക്ഷാഃ കിയന്തോ ലോകാഃ പ്രേരിതാനാം സപക്ഷാ ജാതാഃ, അതോ നാഗരികജനനിവഹമധ്യേ ഭിന്നവാക്യത്വമ് അഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","അന്യദേശീയാ യിഹൂദീയാസ്തേഷാമ് അധിപതയശ്ച ദൗരാത്മ്യം കുത്വാ തൗ പ്രസ്തരൈരാഹന്തുമ് ഉദ്യതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","തൗ തദ്വാർത്താം പ്രാപ്യ പലായിത്വാ ലുകായനിയാദേശസ്യാന്തർവ്വർത്തിലുസ്ത്രാദർബ്ബോ ");
INSERT INTO sanmal_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","തത്സമീപസ്ഥദേശഞ്ച ഗത്വാ തത്ര സുസംവാദം പ്രചാരയതാം| ");
INSERT INTO sanmal_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","തത്രോഭയപാദയോശ്ചലനശക്തിഹീനോ ജന്മാരഭ്യ ഖഞ്ജഃ കദാപി ഗമനം നാകരോത് ഏതാദൃശ ഏകോ മാനുഷോ ലുസ്ത്രാനഗര ഉപവിശ്യ പൗലസ്യ കഥാം ശ്രുതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ഏതസ്മിൻ സമയേ പൗലസ്തമ്പ്രതി ദൃഷ്ടിം കൃത്വാ തസ്യ സ്വാസ്ഥ്യേ വിശ്വാസം വിദിത്വാ പ്രോച്ചൈഃ കഥിതവാൻ ");
INSERT INTO sanmal_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","പദ്ഭ്യാമുത്തിഷ്ഠൻ ഋജു ർഭവ| തതഃ സ ഉല്ലമ്ഫം കൃത്വാ ഗമനാഗമനേ കുതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","തദാ ലോകാഃ പൗലസ്യ തത് കാര്യ്യം വിലോക്യ ലുകായനീയഭാഷയാ പ്രോച്ചൈഃ കഥാമേതാം കഥിതവന്തഃ, ദേവാ മനുഷ്യരൂപം ധൃത്വാസ്മാകം സമീപമ് അവാരോഹൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","തേ ബർണബ്ബാം യൂപിതരമ് അവദൻ പൗലശ്ച മുഖ്യോ വക്താ തസ്മാത് തം മർകുരിയമ് അവദൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","തസ്യ നഗരസ്യ സമ്മുഖേ സ്ഥാപിതസ്യ യൂപിതരവിഗ്രഹസ്യ യാജകോ വൃഷാൻ പുഷ്പമാലാശ്ച ദ്വാരസമീപമ് ആനീയ ലോകൈഃ സർദ്ധം താവുദ്ദിശ്യ സമുത്സൃജ്യ ദാതുമ് ഉദ്യതഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","തദ്വാർത്താം ശ്രുത്വാ ബർണബ്ബാപൗലൗ സ്വീയവസ്ത്രാണി ഛിത്വാ ലോകാനാം മധ്യം വേഗേന പ്രവിശ്യ പ്രോച്ചൈഃ കഥിതവന്തൗ, ");
INSERT INTO sanmal_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","ഹേ മഹേച്ഛാഃ കുത ഏതാദൃശം കർമ്മ കുരുഥ? ആവാമപി യുഷ്മാദൃശൗ സുഖദുഃഖഭോഗിനൗ മനുഷ്യൗ, യുയമ് ഏതാഃ സർവ്വാ വൃഥാകൽപനാഃ പരിത്യജ്യ യഥാ ഗഗണവസുന്ധരാജലനിധീനാം തന്മധ്യസ്ഥാനാം സർവ്വേഷാഞ്ച സ്രഷ്ടാരമമരമ് ഈശ്വരം പ്രതി പരാവർത്തധ്വേ തദർഥമ് ആവാം യുഷ്മാകം സന്നിധൗ സുസംവാദം പ്രചാരയാവഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","സ ഈശ്വരഃ പൂർവ്വകാലേ സർവ്വദേശീയലോകാൻ സ്വസ്വമാർഗേ ചലിതുമനുമതിം ദത്തവാൻ, ");
INSERT INTO sanmal_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","തഥാപി ആകാശാത് തോയവർഷണേന നാനാപ്രകാരശസ്യോത്പത്യാ ച യുഷ്മാകം ഹിതൈഷീ സൻ ഭക്ഷ്യൈരാനനദേന ച യുഷ്മാകമ് അന്തഃകരണാനി തർപയൻ താനി ദാനാനി നിജസാക്ഷിസ്വരൂപാണി സ്ഥപിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","കിന്തു താദൃശായാം കഥായാം കഥിതായാമപി തയോഃ സമീപ ഉത്സർജനാത് ലോകനിവഹം പ്രായേണ നിവർത്തയിതും നാശക്നുതാമ്| ");
INSERT INTO sanmal_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","ആന്തിയഖിയാ-ഇകനിയനഗരാഭ്യാം കതിപയയിഹൂദീയലോകാ ആഗത്യ ലോകാൻ പ്രാവർത്തയന്ത തസ്മാത് തൈ പൗലം പ്രസ്തരൈരാഘ്നൻ തേന സ മൃത ഇതി വിജ്ഞായ നഗരസ്യ ബഹിസ്തമ് ആകൃഷ്യ നീതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","കിന്തു ശിഷ്യഗണേ തസ്യ ചതുർദിശി തിഷ്ഠതി സതി സ സ്വയമ് ഉത്ഥായ പുനരപി നഗരമധ്യം പ്രാവിശത് തത്പരേഽഹനി ബർണബ്ബാസഹിതോ ദർബ്ബീനഗരം ഗതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","തത്ര സുസംവാദം പ്രചാര്യ്യ ബഹുലോകാൻ ശിഷ്യാൻ കൃത്വാ തൗ ലുസ്ത്രാമ് ഇകനിയമ് ആന്തിയഖിയാഞ്ച പരാവൃത്യ ഗതൗ| ");
INSERT INTO sanmal_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ബഹുദുഃഖാനി ഭുക്ത്വാപീശ്വരരാജ്യം പ്രവേഷ്ടവ്യമ് ഇതി കാരണാദ് ധർമ്മമാർഗേ സ്ഥാതും വിനയം കൃത്വാ ശിഷ്യഗണസ്യ മനഃസ്ഥൈര്യ്യമ് അകുരുതാം| ");
INSERT INTO sanmal_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","മണ്ഡലീനാം പ്രാചീനവർഗാൻ നിയുജ്യ പ്രാർഥനോപവാസൗ കൃത്വാ യത്പ്രഭൗ തേ വ്യശ്വസൻ തസ്യ ഹസ്തേ താൻ സമർപ്യ ");
INSERT INTO sanmal_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","പിസിദിയാമധ്യേന പാമ്ഫുലിയാദേശം ഗതവന്തൗ| ");
INSERT INTO sanmal_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","പശ്ചാത് പർഗാനഗരം ഗത്വാ സുസംവാദം പ്രചാര്യ്യ അത്താലിയാനഗരം പ്രസ്ഥിതവന്തൗ| ");
INSERT INTO sanmal_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","തസ്മാത് സമുദ്രപഥേന ഗത്വാ താഭ്യാം യത് കർമ്മ സമ്പന്നം തത്കർമ്മ സാധയിതും യന്നഗരേ ദയാലോരീശ്വരസ്യ ഹസ്തേ സമർപിതൗ ജാതൗ തദ് ആന്തിയഖിയാനഗരം ഗതവന്താ| ");
INSERT INTO sanmal_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","തത്രോപസ്ഥായ തന്നഗരസ്ഥമണ്ഡലീം സംഗൃഹ്യ സ്വാഭ്യാമ ഈശ്വരോ യദ്യത് കർമ്മകരോത് തഥാ യേന പ്രകാരേണ ഭിന്നദേശീയലോകാൻ പ്രതി വിശ്വാസരൂപദ്വാരമ് അമോചയദ് ഏതാൻ സർവ്വവൃത്താന്താൻ താൻ ജ്ഞാപിതവന്തൗ| ");
INSERT INTO sanmal_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","തതസ്തൗ ശിര്യ്യൈഃ സാർദ്ധം തത്ര ബഹുദിനാനി ന്യവസതാമ്| ");
INSERT INTO sanmal_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","യിഹൂദാദേശാത് കിയന്തോ ജനാ ആഗത്യ ഭ്രാതൃഗണമിത്ഥം ശിക്ഷിതവന്തോ മൂസാവ്യവസ്ഥയാ യദി യുഷ്മാകം ത്വക്ഛേദോ ന ഭവതി തർഹി യൂയം പരിത്രാണം പ്രാപ്തും ന ശക്ഷ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","പൗലബർണബ്ബൗ തൈഃ സഹ ബഹൂൻ വിചാരാൻ വിവാദാംശ്ച കൃതവന്തൗ, തതോ മണ്ഡലീയനോകാ ഏതസ്യാഃ കഥായാസ്തത്ത്വം ജ്ഞാതും യിരൂശാലമ്നഗരസ്ഥാൻ പ്രേരിതാൻ പ്രാചീനാംശ്ച പ്രതി പൗലബർണബ്ബാപ്രഭൃതീൻ കതിപയജനാൻ പ്രേഷയിതും നിശ്ചയം കൃതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","തേ മണ്ഡല്യാ പ്രേരിതാഃ സന്തഃ ഫൈണീകീശോമിരോന്ദേശാഭ്യാം ഗത്വാ ഭിന്നദേശീയാനാം മനഃപരിവർത്തനസ്യ വാർത്തയാ ഭ്രാതൃണാം പരമാഹ്ലാദമ് അജനയൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","യിരൂശാലമ്യുപസ്ഥായ പ്രേരിതഗണേന ലോകപ്രാചീനഗണേന സമാജേന ച സമുപഗൃഹീതാഃ സന്തഃ സ്വൈരീശ്വരോ യാനി കർമ്മാണി കൃതവാൻ തേഷാം സർവ്വവൃത്താന്താൻ തേഷാം സമക്ഷമ് അകഥയൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","കിന്തു വിശ്വാസിനഃ കിയന്തഃ ഫിരൂശിമതഗ്രാഹിണോ ലോകാ ഉത്ഥായ കഥാമേതാം കഥിതവന്തോ ഭിന്നദേശീയാനാം ത്വക്ഛേദം കർത്തും മൂസാവ്യവസ്ഥാം പാലയിതുഞ്ച സമാദേഷ്ടവ്യമ്| ");
INSERT INTO sanmal_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","തതഃ പ്രേരിതാ ലോകപ്രാചീനാശ്ച തസ്യ വിവേചനാം കർത്തും സഭായാം സ്ഥിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","ബഹുവിചാരേഷു ജാതഷു പിതര ഉത്ഥായ കഥിതവാൻ, ഹേ ഭ്രാതരോ യഥാ ഭിന്നദേശീയലോകാ മമ മുഖാത് സുസംവാദം ശ്രുത്വാ വിശ്വസന്തി തദർഥം ബഹുദിനാത് പൂർവ്വമ് ഈശ്വരോസ്മാകം മധ്യേ മാം വൃത്വാ നിയുക്തവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","അന്തര്യ്യാമീശ്വരോ യഥാസ്മഭ്യം തഥാ ഭിന്നദേശീയേഭ്യഃ പവിത്രമാത്മാനം പ്രദായ വിശ്വാസേന തേഷാമ് അന്തഃകരണാനി പവിത്രാണി കൃത്വാ ");
INSERT INTO sanmal_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","തേഷാമ് അസ്മാകഞ്ച മധ്യേ കിമപി വിശേഷം ന സ്ഥാപയിത്വാ താനധി സ്വയം പ്രമാണം ദത്തവാൻ ഇതി യൂയം ജാനീഥ| ");
INSERT INTO sanmal_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","അതഏവാസ്മാകം പൂർവ്വപുരുഷാ വയഞ്ച സ്വയം യദ്യുഗസ്യ ഭാരം സോഢും ന ശക്താഃ സമ്പ്രതി തം ശിഷ്യഗണസ്യ സ്കന്ധേഷു ന്യസിതും കുത ഈശ്വരസ്യ പരീക്ഷാം കരിഷ്യഥ? ");
INSERT INTO sanmal_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","പ്രഭോ ര്യീശുഖ്രീഷ്ടസ്യാനുഗ്രഹേണ തേ യഥാ വയമപി തഥാ പരിത്രാണം പ്രാപ്തുമ് ആശാം കുർമ്മഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","അനന്തരം ബർണബ്ബാപൗലാഭ്യാമ് ഈശ്വരോ ഭിന്നദേശീയാനാം മധ്യേ യദ്യദ് ആശ്ചര്യ്യമ് അദ്ഭുതഞ്ച കർമ്മ കൃതവാൻ തദ്വൃത്താന്തം തൗ സ്വമുഖാഭ്യാമ് അവർണയതാം സഭാസ്ഥാഃ സർവ്വേ നീരവാഃ സന്തഃ ശ്രുതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","തയോഃ കഥായാം സമാപ്തായാം സത്യാം യാകൂബ് കഥയിതുമ് ആരബ്ധവാൻ ");
INSERT INTO sanmal_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ഹേ ഭ്രാതരോ മമ കഥായാമ് മനോ നിധത്ത| ഈശ്വരഃ സ്വനാമാർഥം ഭിന്നദേശീയലോകാനാമ് മധ്യാദ് ഏകം ലോകസംഘം ഗ്രഹീതും മതിം കൃത്വാ യേന പ്രകാരേണ പ്രഥമം താൻ പ്രതി കൃപാവലേകനം കൃതവാൻ തം ശിമോൻ വർണിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ഭവിഷ്യദ്വാദിഭിരുക്താനി യാനി വാക്യാനി തൈഃ സാർദ്ധമ് ഏതസ്യൈക്യം ഭവതി യഥാ ലിഖിതമാസ്തേ| ");
INSERT INTO sanmal_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","സർവ്വേഷാം കർമ്മണാം യസ്തു സാധകഃ പരമേശ്വരഃ| സ ഏവേദം വദേദ്വാക്യം ശേഷാഃ സകലമാനവാഃ| ഭിന്നദേശീയലോകാശ്ച യാവന്തോ മമ നാമതഃ| ഭവന്തി ഹി സുവിഖ്യാതാസ്തേ യഥാ പരമേശിതുഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","തത്വം സമ്യക് സമീഹന്തേ തന്നിമിത്തമഹം കില| പരാവൃത്യ സമാഗത്യ ദായൂദഃ പതിതം പുനഃ| ദൂഷ്യമുത്ഥാപയിഷ്യാമി തദീയം സർവ്വവസ്തു ച| പതിതം പുനരുഥാപ്യ സജ്ജയിഷ്യാമി സർവ്വഥാ|| ");
INSERT INTO sanmal_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ആ പ്രഥമാദ് ഈശ്വരഃ സ്വീയാനി സർവ്വകർമ്മാണി ജാനാതി| ");
INSERT INTO sanmal_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","അതഏവ മമ നിവേദനമിദം ഭിന്നദേശീയലോകാനാം മധ്യേ യേ ജനാ ഈശ്വരം പ്രതി പരാവർത്തന്ത തേഷാമുപരി അന്യം കമപി ഭാരം ന ന്യസ്യ ");
INSERT INTO sanmal_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ദേവതാപ്രസാദാശുചിഭക്ഷ്യം വ്യഭിചാരകർമ്മ കണ്ഠസമ്പീഡനമാരിതപ്രാണിഭക്ഷ്യം രക്തഭക്ഷ്യഞ്ച ഏതാനി പരിത്യക്തും ലിഖാമഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","യതഃ പൂർവ്വകാലതോ മൂസാവ്യവസ്ഥാപ്രചാരിണോ ലോകാ നഗരേ നഗരേ സന്തി പ്രതിവിശ്രാമവാരഞ്ച ഭജനഭവനേ തസ്യാഃ പാഠോ ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","തതഃ പരം പ്രേരിതഗണോ ലോകപ്രാചീനഗണഃ സർവ്വാ മണ്ഡലീ ച സ്വേഷാം മധ്യേ ബർശബ്ബാ നാമ്നാ വിഖ്യാതോ മനോനീതൗ കൃത്വാ പൗലബർണബ്ബാഭ്യാം സാർദ്ധമ് ആന്തിയഖിയാനഗരം പ്രതി പ്രേഷണമ് ഉചിതം ബുദ്ധ്വാ താഭ്യാം പത്രം പ്രൈഷയൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","തസ്മിൻ പത്രേ ലിഖിതമിംദ, ആന്തിയഖിയാ-സുരിയാ-കിലികിയാദേശസ്ഥഭിന്നദേശീയഭ്രാതൃഗണായ പ്രേരിതഗണസ്യ ലോകപ്രാചീനഗണസ്യ ഭ്രാതൃഗണസ്യ ച നമസ്കാരഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","വിശേഷതോഽസ്മാകമ് ആജ്ഞാമ് അപ്രാപ്യാപി കിയന്തോ ജനാ അസ്മാകം മധ്യാദ് ഗത്വാ ത്വക്ഛേദോ മൂസാവ്യവസ്ഥാ ച പാലയിതവ്യാവിതി യുഷ്മാൻ ശിക്ഷയിത്വാ യുഷ്മാകം മനസാമസ്ഥൈര്യ്യം കൃത്വാ യുഷ്മാൻ സസന്ദേഹാൻ അകുർവ്വൻ ഏതാം കഥാം വയമ് അശൃന്മ| ");
INSERT INTO sanmal_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","തത്കാരണാദ് വയമ് ഏകമന്ത്രണാഃ സന്തഃ സഭായാം സ്ഥിത്വാ പ്രഭോ ര്യീശുഖ്രീഷ്ടസ്യ നാമനിമിത്തം മൃത്യുമുഖഗതാഭ്യാമസ്മാകം ");
INSERT INTO sanmal_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","പ്രിയബർണബ്ബാപൗലാഭ്യാം സാർദ്ധം മനോനീതലോകാനാം കേഷാഞ്ചിദ് യുഷ്മാകം സന്നിധൗ പ്രേഷണമ് ഉചിതം ബുദ്ധവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","അതോ യിഹൂദാസീലൗ യുഷ്മാൻ പ്രതി പ്രേഷിതവന്തഃ, ഏതയോ ർമുഖാഭ്യാം സർവ്വാം കഥാം ജ്ഞാസ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","ദേവതാപ്രസാദഭക്ഷ്യം രക്തഭക്ഷ്യം ഗലപീഡനമാരിതപ്രാണിഭക്ഷ്യം വ്യഭിചാരകർമ്മ ചേമാനി സർവ്വാണി യുഷ്മാഭിസ്ത്യാജ്യാനി; ഏതത്പ്രയോജനീയാജ്ഞാവ്യതിരേകേന യുഷ്മാകമ് ഉപരി ഭാരമന്യം ന ന്യസിതും പവിത്രസ്യാത്മനോഽസ്മാകഞ്ച ഉചിതജ്ഞാനമ് അഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","അതഏവ തേഭ്യഃ സർവ്വേഭ്യഃ സ്വേഷു രക്ഷിതേഷു യൂയം ഭദ്രം കർമ്മ കരിഷ്യഥ| യുഷ്മാകം മങ്ഗലം ഭൂയാത്| ");
INSERT INTO sanmal_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","തേे വിസൃഷ്ടാഃ സന്ത ആന്തിയഖിയാനഗര ഉപസ്ഥായ ലോകനിവഹം സംഗൃഹ്യ പത്രമ് അദദൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","തതസ്തേ തത്പത്രം പഠിത്വാ സാന്ത്വനാം പ്രാപ്യ സാനന്ദാ അഭവൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","യിഹൂദാസീലൗ ച സ്വയം പ്രചാരകൗ ഭൂത്വാ ഭ്രാതൃഗണം നാനോപദിശ്യ താൻ സുസ്ഥിരാൻ അകുരുതാമ്| ");
INSERT INTO sanmal_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ഇത്ഥം തൗ തത്ര തൈഃ സാകം കതിപയദിനാനി യാപയിത്വാ പശ്ചാത് പ്രേരിതാനാം സമീപേ പ്രത്യാഗമനാർഥം തേഷാം സന്നിധേഃ കല്യാണേന വിസൃഷ്ടാവഭവതാം| ");
INSERT INTO sanmal_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","കിന്തു സീലസ്തത്ര സ്ഥാതും വാഞ്ഛിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","അപരം പൗലബർണബ്ബൗ ബഹവഃ ശിഷ്യാശ്ച ലോകാൻ ഉപദിശ്യ പ്രഭോഃ സുസംവാദം പ്രചാരയന്ത ആന്തിയഖിയായാം കാലം യാപിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","കതിപയദിനേഷു ഗതേഷു പൗലോ ബർണബ്ബാമ് അവദത് ആഗച്ഛാവാം യേഷു നഗരേഷ്വീശ്വരസ്യ സുസംവാദം പ്രചാരിതവന്തൗ താനി സർവ്വനഗരാണി പുനർഗത്വാ ഭ്രാതരഃ കീദൃശാഃ സന്തീതി ദ്രഷ്ടും താൻ സാക്ഷാത് കുർവ്വഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","തേന മാർകനാമ്നാ വിഖ്യാതം യോഹനം സങ്ഗിനം കർത്തും ബർണബ്ബാ മതിമകരോത്, ");
INSERT INTO sanmal_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","കിന്തു സ പൂർവ്വം താഭ്യാം സഹ കാര്യ്യാർഥം ന ഗത്വാ പാമ്ഫൂലിയാദേശേ തൗ ത്യക്തവാൻ തത്കാരണാത് പൗലസ്തം സങ്ഗിനം കർത്തുമ് അനുചിതം ജ്ഞാതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ഇത്ഥം തയോരതിശയവിരോധസ്യോപസ്ഥിതത്വാത് തൗ പരസ്പരം പൃഥഗഭവതാം തതോ ബർണബ്ബാ മാർകം ഗൃഹീത്വാ പോതേന കുപ്രോപദ്വീപം ഗതവാൻ; ");
INSERT INTO sanmal_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","കിന്തു പൗലഃ സീലം മനോനീതം കൃത്വാ ഭ്രാതൃഭിരീശ്വരാനുഗ്രഹേ സമർപിതഃ സൻ പ്രസ്ഥായ ");
INSERT INTO sanmal_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","സുരിയാകിലികിയാദേശാഭ്യാം മണ്ഡലീഃ സ്ഥിരീകുർവ്വൻ അഗച്ഛത്| ");
INSERT INTO sanmal_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","പൗലോ ദർബ്ബീലുസ്ത്രാനഗരയോരുപസ്ഥിതോഭവത് തത്ര തീമഥിയനാമാ ശിഷ്യ ഏക ആസീത്; സ വിശ്വാസിന്യാ യിഹൂദീയായാ യോഷിതോ ഗർബ്ഭജാതഃ കിന്തു തസ്യ പിതാന്യദേശീയലോകഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","സ ജനോ ലുസ്ത്രാ-ഇകനിയനഗരസ്ഥാനാം ഭ്രാതൃണാം സമീപേപി സുഖ്യാതിമാൻ ആസീത്| ");
INSERT INTO sanmal_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","പൗലസ്തം സ്വസങ്ഗിനം കർത്തും മതിം കൃത്വാ തം ഗൃഹീത്വാ തദ്ദേശനിവാസിനാം യിഹൂദീയാനാമ് അനുരോധാത് തസ്യ ത്വക്ഛേദം കൃതവാൻ യതസ്തസ്യ പിതാ ഭിന്നദേശീയലോക ഇതി സർവ്വൈരജ്ഞായത| ");
INSERT INTO sanmal_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","തതഃ പരം തേ നഗരേ നഗരേ ഭ്രമിത്വാ യിരൂശാലമസ്ഥൈഃ പ്രേരിതൈ ർലോകപ്രാചീനൈശ്ച നിരൂപിതം യദ് വ്യവസ്ഥാപത്രം തദനുസാരേണാചരിതും ലോകേഭ്യസ്തദ് ദത്തവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","തേനൈവ സർവ്വേ ധർമ്മസമാജാഃ ഖ്രീഷ്ടധർമ്മേ സുസ്ഥിരാഃ സന്തഃ പ്രതിദിനം വർദ്ധിതാ അഭവൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","തേഷു ഫ്രുഗിയാഗാലാതിയാദേശമധ്യേന ഗതേഷു സത്സു പവിത്ര ആത്മാ താൻ ആശിയാദേശേ കഥാം പ്രകാശയിതും പ്രതിഷിദ്ധവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","തഥാ മുസിയാദേശ ഉപസ്ഥായ ബിഥുനിയാം ഗന്തും തൈരുദ്യോഗേ കൃതേ ആത്മാ താൻ നാന്വമന്യത| ");
INSERT INTO sanmal_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","തസ്മാത് തേ മുസിയാദേശം പരിത്യജ്യ ത്രോയാനഗരം ഗത്വാ സമുപസ്ഥിതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","രാത്രൗ പൗലഃ സ്വപ്നേ ദൃഷ്ടവാൻ ഏകോ മാകിദനിയലോകസ്തിഷ്ഠൻ വിനയം കൃത്വാ തസ്മൈ കഥയതി, മാകിദനിയാദേശമ് ആഗത്യാസ്മാൻ ഉപകുർവ്വിതി| ");
INSERT INTO sanmal_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","തസ്യേത്ഥം സ്വപ്നദർശനാത് പ്രഭുസ്തദ്ദേശീയലോകാൻ പ്രതി സുസംവാദം പ്രചാരയിതുമ് അസ്മാൻ ആഹൂയതീതി നിശ്ചിതം ബുദ്ധ്വാ വയം തൂർണം മാകിദനിയാദേശം ഗന്തുമ് ഉദ്യോഗമ് അകുർമ്മ| ");
INSERT INTO sanmal_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","തതഃ പരം വയം ത്രോയാനഗരാദ് പ്രസ്ഥായ ഋജുമാർഗേണ സാമഥ്രാകിയോപദ്വീപേന ഗത്വാ പരേഽഹനി നിയാപലിനഗര ഉപസ്ഥിതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","തസ്മാദ് ഗത്വാ മാകിദനിയാന്തർവ്വർത്തി രോമീയവസതിസ്ഥാനം യത് ഫിലിപീനാമപ്രധാനനഗരം തത്രോപസ്ഥായ കതിപയദിനാനി തത്ര സ്ഥിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","വിശ്രാമവാരേ നഗരാദ് ബഹി ർഗത്വാ നദീതടേ യത്ര പ്രാർഥനാചാര ആസീത് തത്രോപവിശ്യ സമാഗതാ നാരീഃ പ്രതി കഥാം പ്രാചാരയാമ| ");
INSERT INTO sanmal_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","തതഃ ഥുയാതീരാനഗരീയാ ധൂഷരാമ്ബരവിക്രായിണീ ലുദിയാനാമികാ യാ ഈശ്വരസേവികാ യോഷിത് ശ്രോത്രീണാം മധ്യ ആസീത് തയാ പൗലോക്തവാക്യാനി യദ് ഗൃഹ്യന്തേ തദർഥം പ്രഭുസ്തസ്യാ മനോദ്വാരം മുക്തവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","അതഃ സാ യോഷിത് സപരിവാരാ മജ്ജിതാ സതീ വിനയം കൃത്വാ കഥിതവതീ, യുഷ്മാകം വിചാരാദ് യദി പ്രഭൗ വിശ്വാസിനീ ജാതാഹം തർഹി മമ ഗൃഹമ് ആഗത്യ തിഷ്ഠത| ഇത്ഥം സാ യത്നേനാസ്മാൻ അസ്ഥാപയത്| ");
INSERT INTO sanmal_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","യസ്യാ ഗണനയാ തദധിപതീനാം ബഹുധനോപാർജനം ജാതം താദൃശീ ഗണകഭൂതഗ്രസ്താ കാചന ദാസീ പ്രാർഥനാസ്ഥാനഗമനകാല ആഗത്യാസ്മാൻ സാക്ഷാത് കൃതവതീ| ");
INSERT INTO sanmal_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","സാസ്മാകം പൗലസ്യ ച പശ്ചാദ് ഏത്യ പ്രോച്ചൈഃ കഥാമിമാം കഥിതവതീ, മനുഷ്യാ ഏതേ സർവ്വോപരിസ്ഥസ്യേശ്വരസ്യ സേവകാഃ സന്തോഽസ്മാൻ പ്രതി പരിത്രാണസ്യ മാർഗം പ്രകാശയന്തി| ");
INSERT INTO sanmal_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","സാ കന്യാ ബഹുദിനാനി താദൃശമ് അകരോത് തസ്മാത് പൗലോ ദുഃഖിതഃ സൻ മുഖം പരാവർത്യ തം ഭൂതമവദദ്, അഹം യീശുഖ്രീഷ്ടസ്യ നാമ്നാ ത്വാമാജ്ഞാപയാമി ത്വമസ്യാ ബഹിർഗച്ഛ; തേനൈവ തത്ക്ഷണാത് സ ഭൂതസ്തസ്യാ ബഹിർഗതഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","തതഃ സ്വേഷാം ലാഭസ്യ പ്രത്യാശാ വിഫലാ ജാതേതി വിലോക്യ തസ്യാഃ പ്രഭവഃ പൗലം സീലഞ്ച ധൃത്വാകൃഷ്യ വിചാരസ്ഥാനേഽധിപതീനാം സമീപമ് ആനയൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","തതഃ ശാസകാനാം നികടം നീത്വാ രോമിലോകാ വയമ് അസ്മാകം യദ് വ്യവഹരണം ഗ്രഹീതുമ് ആചരിതുഞ്ച നിഷിദ്ധം, ");
INSERT INTO sanmal_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ഇമേ യിഹൂദീയലോകാഃ സന്തോപി തദേവ ശിക്ഷയിത്വാ നഗരേഽസ്മാകമ് അതീവ കലഹം കുർവ്വന്തി, ");
INSERT INTO sanmal_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","ഇതി കഥിതേ സതി ലോകനിവഹസ്തയോഃ പ്രാതികൂല്യേനോദതിഷ്ഠത് തഥാ ശാസകാസ്തയോ ർവസ്ത്രാണി ഛിത്വാ വേത്രാഘാതം കർത്തുമ് ആജ്ഞാപയൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","അപരം തേ തൗ ബഹു പ്രഹാര്യ്യ ത്വമേതൗ കാരാം നീത്വാ സാവധാനം രക്ഷയേതി കാരാരക്ഷകമ് ആദിശൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ഇത്ഥമ് ആജ്ഞാം പ്രാപ്യ സ താവഭ്യന്തരസ്ഥകാരാം നീത്വാ പാദേഷു പാദപാശീഭി ർബദ്ധ്വാ സ്ഥാപിതാവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","അഥ നിശീഥസമയേ പൗലസീലാവീശ്വരമുദ്ദിശ്യ പ്രാഥനാം ഗാനഞ്ച കൃതവന്തൗ, കാരാസ്ഥിതാ ലോകാശ്ച തദശൃണ്വൻ ");
INSERT INTO sanmal_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","തദാകസ്മാത് മഹാൻ ഭൂമികമ്പോഽഭവത് തേന ഭിത്തിമൂലേന സഹ കാരാ കമ്പിതാഭൂത് തത്ക്ഷണാത് സർവ്വാണി ദ്വാരാണി മുക്താനി ജാതാനി സർവ്വേഷാം ബന്ധനാനി ച മുക്താനി| ");
INSERT INTO sanmal_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","അതഏവ കാരാരക്ഷകോ നിദ്രാതോ ജാഗരിത്വാ കാരായാ ദ്വാരാണി മുക്താനി ദൃഷ്ട്വാ ബന്ദിലോകാഃ പലായിതാ ഇത്യനുമായ കോഷാത് ഖങ്ഗം ബഹിഃ കൃത്വാത്മഘാതം കർത്തുമ് ഉദ്യതഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","കിന്തു പൗലഃ പ്രോച്ചൈസ്തമാഹൂയ കഥിതവാൻ പശ്യ വയം സർവ്വേഽത്രാസ്മഹേ, ത്വം നിജപ്രാണഹിംസാം മാകാർഷീഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","തദാ പ്രദീപമ് ആനേതുമ് ഉക്ത്വാ സ കമ്പമാനഃ സൻ ഉല്ലമ്പ്യാഭ്യന്തരമ് ആഗത്യ പൗലസീലയോഃ പാദേഷു പതിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","പശ്ചാത് സ തൗ ബഹിരാനീയ പൃഷ്ടവാൻ ഹേ മഹേച്ഛൗ പരിത്രാണം പ്രാപ്തും മയാ കിം കർത്തവ്യം? ");
INSERT INTO sanmal_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","പശ്ചാത് തൗ സ്വഗൃഹമാനീയ തയോഃ സമ്മുഖേ ഖാദ്യദ്രവ്യാണി സ്ഥാപിതവാൻ തഥാ സ സ്വയം തദീയാഃ സർവ്വേ പരിവാരാശ്ചേശ്വരേ വിശ്വസന്തഃ സാനന്ദിതാ അഭവൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","തസ്മൈ തസ്യ ഗൃഹസ്ഥിതസർവ്വലോകേഭ്യശ്ച പ്രഭോഃ കഥാം കഥിതവന്തൗ| ");
INSERT INTO sanmal_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","തഥാ രാത്രേസ്തസ്മിന്നേവ ദണ്ഡേ സ തൗ ഗൃഹീത്വാ തയോഃ പ്രഹാരാണാം ക്ഷതാനി പ്രക്ഷാലിതവാൻ തതഃ സ സ്വയം തസ്യ സർവ്വേ പരിജനാശ്ച മജ്ജിതാ അഭവൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","പശ്ചാത് തൗ സ്വഗൃഹമാനീയ തയോഃ സമ്മുഖേ ഖാദ്യദ്രവ്യാണി സ്ഥാപിതവാൻ തഥാ സ സ്വയം തദീയാഃ സർവ്വേ പരിവാരാശ്ചേശ്വരേ വിശ്വസന്തഃ സാനന്ദിതാ അഭവൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","ദിന ഉപസ്ഥിതേ തൗ ലോകൗ മോചയേതി കഥാം കഥയിതും ശാസകാഃ പദാതിഗണം പ്രേഷിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","തതഃ കാരാരക്ഷകഃ പൗലായ താം വാർത്താം കഥിതവാൻ യുവാം ത്യാജയിതും ശാസകാ ലോകാന പ്രേഷിതവന്ത ഇദാനീം യുവാം ബഹി ർഭൂത്വാ കുശലേന പ്രതിഷ്ഠേതാം| ");
INSERT INTO sanmal_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","കിന്തു പൗലസ്താൻ അവദത് രോമിലോകയോരാവയോഃ കമപി ദോഷമ് ന നിശ്ചിത്യ സർവ്വേഷാം സമക്ഷമ് ആവാം കശയാ താഡയിത്വാ കാരായാം ബദ്ധവന്ത ഇദാനീം കിമാവാം ഗുപ്തം വിസ്ത്രക്ഷ്യന്തി? തന്ന ഭവിഷ്യതി, സ്വയമാഗത്യാവാം ബഹിഃ കൃത്വാ നയന്തു| ");
INSERT INTO sanmal_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","തദാ പദാതിഭിഃ ശാസകേഭ്യ ഏതദ്വാർത്തായാം കഥിതായാം തൗ രോമിലോകാവിതി കഥാം ശ്രുത്വാ തേ ഭീതാഃ ");
INSERT INTO sanmal_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","സന്തസ്തയോഃ സന്നിധിമാഗത്യ വിനയമ് അകുർവ്വൻ അപരം ബഹിഃ കൃത്വാ നഗരാത് പ്രസ്ഥാതും പ്രാർഥിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","തതസ്തൗ കാരായാ നിർഗത്യ ലുദിയായാ ഗൃഹം ഗതവന്തൗ തത്ര ഭ്രാതൃഗണം സാക്ഷാത്കൃത്യ താൻ സാന്ത്വയിത്വാ തസ്മാത് സ്ഥാനാത് പ്രസ്ഥിതൗ| ");
INSERT INTO sanmal_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","പൗലസീലൗ ആമ്ഫിപല്യാപല്ലോനിയാനഗരാഭ്യാം ഗത്വാ യത്ര യിഹൂദീയാനാം ഭജനഭവനമേകമ് ആസ്തേ തത്ര ഥിഷലനീകീനഗര ഉപസ്ഥിതൗ| ");
INSERT INTO sanmal_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","തദാ പൗലഃ സ്വാചാരാനുസാരേണ തേഷാം സമീപം ഗത്വാ വിശ്രാമവാരത്രയേ തൈഃ സാർദ്ധം ധർമ്മപുസ്തകീയകഥായാ വിചാരം കൃതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ഫലതഃ ഖ്രീഷ്ടേന ദുഃഖഭോഗഃ കർത്തവ്യഃ ശ്മശാനദുത്ഥാനഞ്ച കർത്തവ്യം യുഷ്മാകം സന്നിധൗ യസ്യ യീശോഃ പ്രസ്താവം കരോമി സ ഈശ്വരേണാഭിഷിക്തഃ സ ഏതാഃ കഥാഃ പ്രകാശ്യ പ്രമാണം ദത്വാ സ്ഥിരീകൃതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","തസ്മാത് തേഷാം കതിപയജനാ അന്യദേശീയാ ബഹവോ ഭക്തലോകാ ബഹ്യഃ പ്രധാനനാര്യ്യശ്ച വിശ്വസ്യ പൗലസീലയോഃ പശ്ചാദ്ഗാമിനോ ജാതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","കിന്തു വിശ്വാസഹീനാ യിഹൂദീയലോകാ ഈർഷ്യയാ പരിപൂർണാഃ സന്തോ ഹടട്സ്യ കതിനയലമ്പടലോകാൻ സങ്ഗിനഃ കൃത്വാ ജനതയാ നഗരമധ്യേ മഹാകലഹം കൃത്വാ യാസോനോ ഗൃഹമ് ആക്രമ്യ പ്രേരിതാൻ ധൃത്വാ ലോകനിവഹസ്യ സമീപമ് ആനേതും ചേഷ്ടിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","തേഷാമുദ്ദേശമ് അപ്രാപ്യ ച യാസോനം കതിപയാൻ ഭ്രാതൃംശ്ച ധൃത്വാ നഗരാധിപതീനാം നികടമാനീയ പ്രോച്ചൈഃ കഥിതവന്തോ യേ മനുഷ്യാ ജഗദുദ്വാടിതവന്തസ്തേ ഽത്രാപ്യുപസ്ഥിതാഃ സന്തി, ");
INSERT INTO sanmal_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ഏഷ യാസോൻ ആതിഥ്യം കൃത്വാ താൻ ഗൃഹീതവാൻ| യീശുനാമക ഏകോ രാജസ്തീതി കഥയന്തസ്തേ കൈസരസ്യാജ്ഞാവിരുദ്ധം കർമ്മ കുർവ്വതി| ");
INSERT INTO sanmal_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","തേഷാം കഥാമിമാം ശ്രുത്വാ ലോകനിവഹോ നഗരാധിപതയശ്ച സമുദ്വിഗ്നാ അഭവൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","തദാ യാസോനസ്തദന്യേഷാഞ്ച ധനദണ്ഡം ഗൃഹീത്വാ താൻ പരിത്യക്തവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","തതഃ പരം ഭ്രാതൃഗണോ രജന്യാം പൗലസീലൗ ശീഘ്രം ബിരയാനഗരം പ്രേഷിതവാൻ തൗ തത്രോപസ്ഥായ യിഹൂദീയാനാം ഭജനഭവനം ഗതവന്തൗ| ");
INSERT INTO sanmal_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","തത്രസ്ഥാ ലോകാഃ ഥിഷലനീകീസ്ഥലോകേഭ്യോ മഹാത്മാന ആസൻ യത ഇത്ഥം ഭവതി ന വേതി ജ്ഞാതും ദിനേ ദിനേ ധർമ്മഗ്രന്ഥസ്യാലോചനാം കൃത്വാ സ്വൈരം കഥാമ് അഗൃഹ്ലൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","തസ്മാദ് അനേകേ യിഹൂദീയാ അന്യദേശീയാനാം മാന്യാ സ്ത്രിയഃ പുരുഷാശ്ചാനേകേ വ്യശ്വസൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","കിന്തു ബിരയാനഗരേ പൗലേനേശ്വരീയാ കഥാ പ്രചാര്യ്യത ഇതി ഥിഷലനീകീസ്ഥാ യിഹൂദീയാ ജ്ഞാത്വാ തത്സ്ഥാനമപ്യാഗത്യ ലോകാനാം കുപ്രവൃത്തിമ് അജനയൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","അതഏവ തസ്മാത് സ്ഥാനാത് സമുദ്രേണ യാന്തീതി ദർശയിത്വാ ഭ്രാതരഃ ക്ഷിപ്രം പൗലം പ്രാഹിണ്വൻ കിന്തു സീലതീമഥിയൗ തത്ര സ്ഥിതവന്തൗ| ");
INSERT INTO sanmal_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","തതഃ പരം പൗലസ്യ മാർഗദർശകാസ്തമ് ആഥീനീനഗര ഉപസ്ഥാപയൻ പശ്ചാദ് യുവാം തൂർണമ് ഏതത് സ്ഥാനം ആഗമിഷ്യഥഃ സീലതീമഥിയൗ പ്രതീമാമ് ആജ്ഞാം പ്രാപ്യ തേ പ്രത്യാഗതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","പൗല ആഥീനീനഗരേ താവപേക്ഷ്യ തിഷ്ഠൻ തന്നഗരം പ്രതിമാഭിഃ പരിപൂർണം ദൃഷ്ട്വാ സന്തപ്തഹൃദയോ ഽഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","തതഃ സ ഭജനഭവനേ യാൻ യിഹൂദീയാൻ ഭക്തലോകാംശ്ച ഹട്ടേ ച യാൻ അപശ്യത് തൈഃ സഹ പ്രതിദിനം വിചാരിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","കിന്ത്വിപികൂരീയമതഗ്രഹിണഃ സ്തോയികീയമതഗ്രാഹിണശ്ച കിയന്തോ ജനാസ്തേന സാർദ്ധം വ്യവദന്ത| തത്ര കേചിദ് അകഥയൻ ഏഷ വാചാലഃ കിം വക്തുമ് ഇച്ഛതി? അപരേ കേചിദ് ഏഷ ജനഃ കേഷാഞ്ചിദ് വിദേശീയദേവാനാം പ്രചാരക ഇത്യനുമീയതേ യതഃ സ യീശുമ് ഉത്ഥിതിഞ്ച പ്രചാരയത്| ");
INSERT INTO sanmal_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","തേ തമ് അരേയപാഗനാമ വിചാരസ്ഥാനമ് ആനീയ പ്രാവോചൻ ഇദം യന്നവീനം മതം ത്വം പ്രാചീകശ ഇദം കീദൃശം ഏതദ് അസ്മാൻ ശ്രാവയ; ");
INSERT INTO sanmal_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","യാമിമാമ് അസമ്ഭവകഥാമ് അസ്മാകം കർണഗോചരീകൃതവാൻ അസ്യാ ഭാവാർഥഃ ക ഇതി വയം ജ്ഞാതുമ് ഇച്ഛാമഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","തദാഥീനീനിവാസിനസ്തന്നഗരപ്രവാസിനശ്ച കേവലം കസ്യാശ്ചന നവീനകഥായാഃ ശ്രവണേന പ്രചാരണേന ച കാലമ് അയാപയൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","പൗലോഽരേയപാഗസ്യ മധ്യേ തിഷ്ഠൻ ഏതാം കഥാം പ്രചാരിതവാൻ, ഹേ ആഥീനീയലോകാ യൂയം സർവ്വഥാ ദേവപൂജായാമ് ആസക്താ ഇത്യഹ പ്രത്യക്ഷം പശ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","യതഃ പര്യ്യടനകാലേ യുഷ്മാകം പൂജനീയാനി പശ്യൻ ‘അവിജ്ഞാതേശ്വരായ’ ഏതല്ലിപിയുക്താം യജ്ഞവേദീമേകാം ദൃഷ്ടവാൻ; അതോ ന വിദിത്വാ യം പൂജയധ്വേ തസ്യൈവ തത്വം യുഷ്മാൻ പ്രതി പ്രചാരയാമി| ");
INSERT INTO sanmal_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ജഗതോ ജഗത്സ്ഥാനാം സർവ്വവസ്തൂനാഞ്ച സ്രഷ്ടാ യ ഈശ്വരഃ സ സ്വർഗപൃഥിവ്യോരേകാധിപതിഃ സൻ കരനിർമ്മിതമന്ദിരേഷു ന നിവസതി; ");
INSERT INTO sanmal_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","സ ഏവ സർവ്വേഭ്യോ ജീവനം പ്രാണാൻ സർവ്വസാമഗ്രീശ്ച പ്രദദാതി; അതഏവ സ കസ്യാശ്ചിത് സാമഗ്യ്രാ അഭാവഹേതോ ർമനുഷ്യാണാം ഹസ്തൈഃ സേവിതോ ഭവതീതി ന| ");
INSERT INTO sanmal_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","സ ഭൂമണ്ഡലേ നിവാസാർഥമ് ഏകസ്മാത് ശോണിതാത് സർവ്വാൻ മനുഷ്യാൻ സൃഷ്ട്വാ തേഷാം പൂർവ്വനിരൂപിതസമയം വസതിസീമാഞ്ച നിരചിനോത്; ");
INSERT INTO sanmal_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","തസ്മാത് ലോകൈഃ കേനാപി പ്രകാരേണ മൃഗയിത്വാ പരമേശ്വരസ്യ തത്വം പ്രാപ്തും തസ്യ ഗവേഷണം കരണീയമ്| ");
INSERT INTO sanmal_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","കിന്തു സോഽസ്മാകം കസ്മാച്ചിദപി ദൂരേ തിഷ്ഠതീതി നഹി, വയം തേന നിശ്വസനപ്രശ്വസനഗമനാഗമനപ്രാണധാരണാനി കുർമ്മഃ, പുुനശ്ച യുഷ്മാകമേവ കതിപയാഃ കവയഃ കഥയന്തി ‘തസ്യ വംശാ വയം സ്മോ ഹി’ ഇതി| ");
INSERT INTO sanmal_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","അതഏവ യദി വയമ് ഈശ്വരസ്യ വംശാ ഭവാമസ്തർഹി മനുഷ്യൈ ർവിദ്യയാ കൗശലേന ച തക്ഷിതം സ്വർണം രൂപ്യം ദൃഷദ് വൈതേഷാമീശ്വരത്വമ് അസ്മാഭി ർന ജ്ഞാതവ്യം| ");
INSERT INTO sanmal_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","തേഷാം പൂർവ്വീയലോകാനാമ് അജ്ഞാനതാം പ്രതീശ്വരോ യദ്യപി നാവാധത്ത തഥാപീദാനീം സർവ്വത്ര സർവ്വാൻ മനഃ പരിവർത്തയിതുമ് ആജ്ഞാപയതി, ");
INSERT INTO sanmal_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","യതഃ സ്വനിയുക്തേന പുരുഷേണ യദാ സ പൃഥിവീസ്ഥാനാം സർവ്വലോകാനാം വിചാരം കരിഷ്യതി തദ്ദിനം ന്യരൂപയത്; തസ്യ ശ്മശാനോത്ഥാപനേന തസ്മിൻ സർവ്വേഭ്യഃ പ്രമാണം പ്രാദാത്| ");
INSERT INTO sanmal_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","തദാ ശ്മശാനാദ് ഉത്ഥാനസ്യ കഥാം ശ്രുത്വാ കേചിദ് ഉപാഹമൻ, കേചിദവദൻ ഏനാം കഥാം പുനരപി ത്വത്തഃ ശ്രോഷ്യാമഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","തതഃ പൗലസ്തേഷാം സമീപാത് പ്രസ്ഥിाതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","തഥാപി കേചില്ലോകാസ്തേന സാർദ്ധം മിലിത്വാ വ്യശ്വസൻ തേഷാം മധ്യേ ഽരേയപാഗീയദിയനുസിയോ ദാമാരീനാമാ കാചിന്നാരീ കിയന്തോ നരാശ്ചാസൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","തദ്ഘടനാതഃ പരം പൗല ആഥീനീനഗരാദ് യാത്രാം കൃത്വാ കരിന്ഥനഗരമ് ആഗച്ഛത്| ");
INSERT INTO sanmal_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","തസ്മിൻ സമയേ ക്ലൗദിയഃ സർവ്വാൻ യിഹൂദീയാൻ രോമാനഗരം വിഹായ ഗന്തുമ് ആജ്ഞാപയത്, തസ്മാത് പ്രിസ്കില്ലാനാമ്നാ ജായയാ സാർദ്ധമ് ഇതാലിയാദേശാത് കിഞ്ചിത്പൂർവ്വമ് ആഗമത് യഃ പന്തദേശേ ജാത ആക്കിലനാമാ യിഹൂദീയലോകഃ പൗലസ്തം സാക്ഷാത് പ്രാപ്യ തയോഃ സമീപമിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","തൗ ദൂഷ്യനിർമ്മാണജീവിനൗ, തസ്മാത് പരസ്പരമ് ഏകവൃത്തികത്വാത് സ താഭ്യാം സഹ ഉഷിത്വാ തത് കർമ്മാകരോത്| ");
INSERT INTO sanmal_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","പൗലഃ പ്രതിവിശ്രാമവാരം ഭജനഭവനം ഗത്വാ വിചാരം കൃത്വാ യിഹൂദീയാൻ അന്യദേശീയാംശ്ച പ്രവൃത്തിം ഗ്രാഹിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","സീലതീമഥിയയോ ർമാകിദനിയാദേശാത് സമേതയോഃ സതോഃ പൗല ഉത്തപ്തമനാ ഭൂത്വാ യീശുരീശ്വരേണാഭിഷിക്തോ ഭവതീതി പ്രമാണം യിഹൂദീയാനാം സമീപേ പ്രാദാത്| ");
INSERT INTO sanmal_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","കിന്തു തേ ഽതീവ വിരോധം വിധായ പാഷണ്ഡീയകഥാം കഥിതവന്തസ്തതഃ പൗലോ വസ്ത്രം ധുന്വൻ ഏതാം കഥാം കഥിതവാൻ, യുഷ്മാകം ശോണിതപാതാപരാധോ യുഷ്മാൻ പ്രത്യേവ ഭവതു, തേനാഹം നിരപരാധോ ഽദ്യാരഭ്യ ഭിന്നദേശീയാനാം സമീപം യാമി| ");
INSERT INTO sanmal_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","സ തസ്മാത് പ്രസ്ഥായ ഭജനഭവനസമീപസ്ഥസ്യ യുസ്തനാമ്ന ഈശ്വരഭക്തസ്യ ഭിന്നദേശീയസ്യ നിവേശനം പ്രാവിശത്| ");
INSERT INTO sanmal_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","തതഃ ക്രീഷ്പനാമാ ഭജനഭവനാധിപതിഃ സപരിവാരഃ പ്രഭൗ വ്യശ്വസീത്, കരിന്ഥനഗരീയാ ബഹവോ ലോകാശ്ച സമാകർണ്യ വിശ്വസ്യ മജ്ജിതാ അഭവൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","ക്ഷണദായാം പ്രഭുഃ പൗലം ദർശനം ദത്വാ ഭാഷിതവാൻ, മാ ഭൈഷീഃ, മാ നിരസീഃ കഥാം പ്രചാരയ| ");
INSERT INTO sanmal_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","അഹം ത്വയാ സാർദ്ധമ് ആസ ഹിംസാർഥം കോപി ത്വാം സ്പ്രഷ്ടും ന ശക്ഷ്യതി നഗരേഽസ്മിൻ മദീയാ ലോകാ ബഹവ ആസതേ| ");
INSERT INTO sanmal_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","തസ്മാത് പൗലസ്തന്നഗരേ പ്രായേണ സാർദ്ധവത്സരപര്യ്യന്തം സംസ്ഥായേശ്വരസ്യ കഥാമ് ഉപാദിശത്| ");
INSERT INTO sanmal_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","ഗാല്ലിയനാമാ കശ്ചിദ് ആഖായാദേശസ്യ പ്രാഡ്വിവാകഃ സമഭവത്, തതോ യിഹൂദീയാ ഏകവാക്യാഃ സന്തഃ പൗലമ് ആക്രമ്യ വിചാരസ്ഥാനം നീത്വാ ");
INSERT INTO sanmal_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","മാനുഷ ഏഷ വ്യവസ്ഥായ വിരുദ്ധമ് ഈശ്വരഭജനം കർത്തും ലോകാൻ കുപ്രവൃത്തിം ഗ്രാഹയതീതി നിവേദിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","തതഃ പൗലേ പ്രത്യുത്തരം ദാതുമ് ഉദ്യതേ സതി ഗാല്ലിയാ യിഹൂദീയാൻ വ്യാഹരത്, യദി കസ്യചിദ് അന്യായസ്യ വാതിശയദുഷ്ടതാചരണസ്യ വിചാരോഽഭവിഷ്യത് തർഹി യുഷ്മാകം കഥാ മയാ സഹനീയാഭവിഷ്യത്| ");
INSERT INTO sanmal_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","കിന്തു യദി കേവലം കഥായാ വാ നാമ്നോ വാ യുഷ്മാകം വ്യവസ്ഥായാ വിവാദോ ഭവതി തർഹി തസ്യ വിചാരമഹം ന കരിഷ്യാമി, യൂയം തസ്യ മീമാംസാം കുരുത| ");
INSERT INTO sanmal_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","തതഃ സ താൻ വിചാരസ്ഥാനാദ് ദൂരീകൃതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","തദാ ഭിന്നദേശീയാഃ സോസ്ഥിനിനാമാനം ഭജനഭവനസ്യ പ്രധാനാധിപതിം ധൃത്വാ വിചാരസ്ഥാനസ്യ സമ്മുഖേ പ്രാഹരൻ തഥാപി ഗാല്ലിയാ തേഷു സർവ്വകർമ്മസു ന മനോ ന്യദധാത്| ");
INSERT INTO sanmal_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","പൗലസ്തത്ര പുനർബഹുദിനാനി ന്യവസത്, തതോ ഭ്രാതൃഗണാദ് വിസർജനം പ്രാപ്യ കിഞ്ചനവ്രതനിമിത്തം കിംക്രിയാനഗരേ ശിരോ മുണ്ഡയിത്വാ പ്രിസ്കില്ലാക്കിലാഭ്യാം സഹിതോ ജലപഥേന സുരിയാദേശം ഗതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","തത ഇഫിഷനഗര ഉപസ്ഥായ തത്ര തൗ വിസൃജ്യ സ്വയം ഭജനഭ്വനം പ്രവിശ്യ യിഹൂദീയൈഃ സഹ വിചാരിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","തേ സ്വൈഃ സാർദ്ധം പുനഃ കതിപയദിനാനി സ്ഥാതും തം വ്യനയൻ, സ തദനുരരീകൃത്യ കഥാമേതാം കഥിതവാൻ, ");
INSERT INTO sanmal_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","യിരൂശാലമി ആഗാമ്യുത്സവപാലനാർഥം മയാ ഗമനീയം; പശ്ചാദ് ഈശ്വരേച്ഛായാം ജാതായാം യുഷ്മാകം സമീപം പ്രത്യാഗമിഷ്യാമി| തതഃ പരം സ തൈ ർവിസൃഷ്ടഃ സൻ ജലപഥേന ഇഫിഷനഗരാത് പ്രസ്ഥിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","തതഃ കൈസരിയാമ് ഉപസ്ഥിതഃ സൻ നഗരം ഗത്വാ സമാജം നമസ്കൃത്യ തസ്മാദ് ആന്തിയഖിയാനഗരം പ്രസ്ഥിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","തത്ര കിയത്കാലം യാപയിത്വാ തസ്മാത് പ്രസ്ഥായ സർവ്വേഷാം ശിഷ്യാണാം മനാംസി സുസ്ഥിരാണി കൃത്വാ ക്രമശോ ഗലാതിയാഫ്രുഗിയാദേശയോ ർഭ്രമിത്വാ ഗതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","തസ്മിന്നേവ സമയേ സികന്ദരിയാനഗരേ ജാത ആപല്ലോനാമാ ശാസ്ത്രവിത് സുവക്താ യിഹൂദീയ ഏകോ ജന ഇഫിഷനഗരമ് ആഗതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","സ ശിക്ഷിതപ്രഭുമാർഗോ മനസോദ്യോഗീ ച സൻ യോഹനോ മജ്ജനമാത്രം ജ്ഞാത്വാ യഥാർഥതയാ പ്രഭോഃ കഥാം കഥയൻ സമുപാദിശത്| ");
INSERT INTO sanmal_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ഏഷ ജനോ നിർഭയത്വേന ഭജനഭവനേ കഥയിതുമ് ആരബ്ധവാൻ, തതഃ പ്രിസ്കില്ലാക്കിലൗ തസ്യോപദേശകഥാം നിശമ്യ തം സ്വയോഃ സമീപമ് ആനീയ ശുദ്ധരൂപേണേശ്വരസ്യ കഥാമ് അബോധയതാമ്| ");
INSERT INTO sanmal_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","പശ്ചാത് സ ആഖായാദേശം ഗന്തും മതിം കൃതവാൻ, തദാ തത്രത്യഃ ശിഷ്യഗണോ യഥാ തം ഗൃഹ്ലാതി തദർഥം ഭ്രാതൃഗണേന സമാശ്വസ്യ പത്രേ ലിഖിതേ സതി, ആപല്ലാസ്തത്രോപസ്ഥിതഃ സൻ അനുഗ്രഹേണ പ്രത്യയിനാം ബഹൂപകാരാൻ അകരോത്, ");
INSERT INTO sanmal_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ഫലതോ യീശുരഭിഷിക്തസ്ത്രാതേതി ശാസ്ത്രപ്രമാണം ദത്വാ പ്രകാശരൂപേണ പ്രതിപന്നം കൃത്വാ യിഹൂദീയാൻ നിരുത്തരാൻ കൃതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","കരിന്ഥനഗര ആപല്ലസഃ സ്ഥിതികാലേ പൗല ഉത്തരപ്രദേശൈരാഗച്ഛൻ ഇഫിഷനഗരമ് ഉപസ്ഥിതവാൻ| തത്ര കതിപയശിഷ്യാൻ സാക്ഷത് പ്രാപ്യ താൻ അപൃച്ഛത്, ");
INSERT INTO sanmal_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","യൂയം വിശ്വസ്യ പവിത്രമാത്മാനം പ്രാപ്താ ന വാ? തതസ്തേ പ്രത്യവദൻ പവിത്ര ആത്മാ ദീയതേ ഇത്യസ്മാഭിഃ ശ്രുതമപി നഹി| ");
INSERT INTO sanmal_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","തദാ സാഽവദത് തർഹി യൂയം കേന മജ്ജിതാ അഭവത? തേഽകഥയൻ യോഹനോ മജ്ജനേന| ");
INSERT INTO sanmal_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","തദാ പൗല ഉക്തവാൻ ഇതഃ പരം യ ഉപസ്ഥാസ്യതി തസ്മിൻ അർഥത യീശുഖ്രീഷ്ടേ വിശ്വസിതവ്യമിത്യുക്ത്വാ യോഹൻ മനഃപരിവർത്തനസൂചകേന മജ്ജനേന ജലേ ലോകാൻ അമജ്ജയത്| ");
INSERT INTO sanmal_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","താദൃശീം കഥാം ശ്രുത്വാ തേ പ്രഭോ ര്യീശുഖ്രീഷ്ടസ്യ നാമ്നാ മജ്ജിതാ അഭവൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","തതഃ പൗലേന തേഷാം ഗാത്രേഷു കരേഽർപിതേ തേഷാമുപരി പവിത്ര ആത്മാവരൂഢവാൻ, തസ്മാത് തേ നാനാദേശീയാ ഭാഷാ ഭവിഷ്യത്കഥാശ്ച കഥിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","തേ പ്രായേണ ദ്വാദശജനാ ആസൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","പൗലോ ഭജനഭവനം ഗത്വാ പ്രായേണ മാസത്രയമ് ഈശ്വരസ്യ രാജ്യസ്യ വിചാരം കൃത്വാ ലോകാൻ പ്രവർത്യ സാഹസേന കഥാമകഥയത്| ");
INSERT INTO sanmal_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","കിന്തു കഠിനാന്തഃകരണത്വാത് കിയന്തോ ജനാ ന വിശ്വസ്യ സർവ്വേഷാം സമക്ഷമ് ഏതത്പഥസ്യ നിന്ദാം കർത്തും പ്രവൃത്താഃ, അതഃ പൗലസ്തേഷാം സമീപാത് പ്രസ്ഥായ ശിഷ്യഗണം പൃഥക്കൃത്വാ പ്രത്യഹം തുരാന്നനാമ്നഃ കസ്യചിത് ജനസ്യ പാഠശാലായാം വിചാരം കൃതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ഇത്ഥം വത്സരദ്വയം ഗതം തസ്മാദ് ആശിയാദേശനിവാസിനഃ സർവ്വേ യിഹൂദീയാ അന്യദേശീയലോകാശ്ച പ്രഭോ ര്യീശോഃ കഥാമ് അശ്രൗഷൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","പൗലേന ച ഈശ്വര ഏതാദൃശാന്യദ്ഭുതാനി കർമ്മാണി കൃതവാൻ ");
INSERT INTO sanmal_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","യത് പരിധേയേ ഗാത്രമാർജനവസ്ത്രേ വാ തസ്യ ദേഹാത് പീഡിതലോകാനാമ് സമീപമ് ആനീതേ തേ നിരാമയാ ജാതാ അപവിത്രാ ഭൂതാശ്ച തേഭ്യോ ബഹിർഗതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","തദാ ദേശാടനകാരിണഃ കിയന്തോ യിഹൂദീയാ ഭൂതാപസാരിണോ ഭൂതഗ്രസ്തനോകാനാം സന്നിധൗ പ്രഭേ ര്യീശോ ർനാമ ജപ്ത്വാ വാക്യമിദമ് അവദൻ, യസ്യ കഥാം പൗലഃ പ്രചാരയതി തസ്യ യീശോ ർനാമ്നാ യുഷ്മാൻ ആജ്ഞാപയാമഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","സ്കിവനാമ്നോ യിഹൂദീയാനാം പ്രധാനയാജകസ്യ സപ്തഭിഃ പുത്തൈസ്തഥാ കൃതേ സതി ");
INSERT INTO sanmal_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","കശ്ചിദ് അപവിത്രോ ഭൂതഃ പ്രത്യുദിതവാൻ, യീശും ജാനാമി പൗലഞ്ച പരിചിനോമി കിന്തു കേ യൂയം? ");
INSERT INTO sanmal_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ഇത്യുക്ത്വാ സോപവിത്രഭൂതഗ്രസ്തോ മനുഷ്യോ ലമ്ഫം കൃത്വാ തേഷാമുപരി പതിത്വാ ബലേന താൻ ജിതവാൻ, തസ്മാത്തേ നഗ്നാഃ ക്ഷതാങ്ഗാശ്ച സന്തസ്തസ്മാദ് ഗേഹാത് പലായന്ത| ");
INSERT INTO sanmal_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","സാ വാഗ് ഇഫിഷനഗരനിവാസിനസം സർവ്വേഷാം യിഹൂദീയാനാം ഭിന്നദേശീയാനാം ലോകാനാഞ്ച ശ്രവോഗോചരീഭൂതാ; തതഃ സർവ്വേ ഭയം ഗതാഃ പ്രഭോ ര്യീശോ ർനാമ്നോ യശോ ഽവർദ്ധത| ");
INSERT INTO sanmal_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","യേഷാമനേകേഷാം ലോകാനാം പ്രതീതിരജായത ത ആഗത്യ സ്വൈഃ കൃതാഃ ക്രിയാഃ പ്രകാശരൂപേണാങ്ഗീകൃതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","ബഹവോ മായാകർമ്മകാരിണഃ സ്വസ്വഗ്രന്ഥാൻ ആനീയ രാശീകൃത്യ സർവ്വേഷാം സമക്ഷമ് അദാഹയൻ, തതോ ഗണനാം കൃത്വാബുധ്യന്ത പഞ്ചായുതരൂപ്യമുദ്രാമൂല്യപുസ്തകാനി ദഗ്ധാനി| ");
INSERT INTO sanmal_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ഇത്ഥം പ്രഭോഃ കഥാ സർവ്വദേശം വ്യാപ്യ പ്രബലാ ജാതാ| ");
INSERT INTO sanmal_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","സർവ്വേഷ്വേതേഷു കർമ്മസു സമ്പന്നേഷു സത്സു പൗലോ മാകിദനിയാഖായാദേശാഭ്യാം യിരൂശാലമം ഗന്തും മതിം കൃത്വാ കഥിതവാൻ തത്സ്ഥാനം യാത്രായാം കൃതായാം സത്യാം മയാ രോമാനഗരം ദ്രഷ്ടവ്യം| ");
INSERT INTO sanmal_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","സ്വാനുഗതലോകാനാം തീമഥിയേരാസ്തൗ ദ്വൗ ജനൗ മാകിദനിയാദേശം പ്രതി പ്രഹിത്യ സ്വയമ് ആശിയാദേശേ കതിപയദിനാനി സ്ഥിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","കിന്തു തസ്മിൻ സമയേ മതേഽസ്മിൻ കലഹോ ജാതഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","തത്കാരണമിദം, അർത്തിമീദേവ്യാ രൂപ്യമന്ദിരനിർമ്മാണേന സർവ്വേഷാം ശിൽപിനാം യഥേഷ്ടലാഭമ് അജനയത് യോ ദീമീത്രിയനാമാ നാഡീന്ധമഃ ");
INSERT INTO sanmal_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","സ താൻ തത്കർമ്മജീവിനഃ സർവ്വലോകാംശ്ച സമാഹൂയ ഭാഷിതവാൻ ഹേ മഹേച്ഛാ ഏതേന മന്ദിരനിർമ്മാണേനാസ്മാകം ജീവികാ ഭവതി, ഏതദ് യൂയം വിത്ഥ; ");
INSERT INTO sanmal_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","കിന്തു ഹസ്തനിർമ്മിതേശ്വരാ ഈശ്വരാ നഹി പൗലനാമ്നാ കേനചിജ്ജനേന കഥാമിമാം വ്യാഹൃത്യ കേവലേഫിഷനഗരേ നഹി പ്രായേണ സർവ്വസ്മിൻ ആശിയാദേശേ പ്രവൃത്തിം ഗ്രാഹയിത്വാ ബഹുലോകാനാം ശേമുഷീ പരാവർത്തിതാ, ഏതദ് യുഷ്മാഭി ർദൃശ്യതേ ശ്രൂയതേ ച| ");
INSERT INTO sanmal_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","തേനാസ്മാകം വാണിജ്യസ്യ സർവ്വഥാ ഹാനേഃ സമ്ഭവനം കേവലമിതി നഹി, ആശിയാദേശസ്ഥൈ ർവാ സർവ്വജഗത്സ്ഥൈ ർലോകൈഃ പൂജ്യാ യാർതിമീ മഹാദേവീ തസ്യാ മന്ദിരസ്യാവജ്ഞാനസ്യ തസ്യാ ഐശ്വര്യ്യസ്യ നാശസ്യ ച സമ്ഭാവനാ വിദ്യതേे| ");
INSERT INTO sanmal_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","ഏതാദൃശീം കഥാം ശ്രുത്വാ തേ മഹാക്രോധാന്വിതാഃ സന്ത ഉച്ചൈഃകാരം കഥിതവന്ത ഇഫിഷീയാനാമ് അർത്തിമീ ദേവീ മഹതീ ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","തതഃ സർവ്വനഗരം കലഹേന പരിപൂർണമഭവത്, തതഃ പരം തേ മാകിദനീയഗായാരിസ്താർഖനാമാനൗ പൗലസ്യ ദ്വൗ സഹചരൗ ധൃത്വൈകചിത്താ രങ്ഗഭൂമിം ജവേന ധാവിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","തതഃ പൗലോ ലോകാനാം സന്നിധിം യാതുമ് ഉദ്യതവാൻ കിന്തു ശിഷ്യഗണസ്തം വാരിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","പൗലസ്യത്മീയാ ആശിയാദേശസ്ഥാഃ കതിപയാഃ പ്രധാനലോകാസ്തസ്യ സമീപം നരമേകം പ്രേഷ്യ ത്വം രങ്ഗഭൂമിം മാഗാ ഇതി ന്യവേദയൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","തതോ നാനാലോകാനാം നാനാകഥാകഥനാത് സഭാ വ്യാകുലാ ജാതാ കിം കാരണാദ് ഏതാവതീ ജനതാഭവത് ഏതദ് അധികൈ ർലോകൈ ർനാജ്ഞായി| ");
INSERT INTO sanmal_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","തതഃ പരം ജനതാമധ്യാദ് യിഹൂദീയൈർബഹിഷ്കൃതഃ സികന്ദരോ ഹസ്തേന സങ്കേതം കൃത്വാ ലോകേഭ്യ ഉത്തരം ദാതുമുദ്യതവാൻ, ");
INSERT INTO sanmal_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","കിന്തു സ യിഹൂദീയലോക ഇതി നിശ്ചിതേ സതി ഇഫിഷീയാനാമ് അർത്തിമീ ദേവീ മഹതീതി വാക്യം പ്രായേണ പഞ്ച ദണ്ഡാൻ യാവദ് ഏകസ്വരേണ ലോകനിവഹൈഃ പ്രോക്തം| ");
INSERT INTO sanmal_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","തതോ നഗരാധിപതിസ്താൻ സ്ഥിരാൻ കൃത്വാ കഥിതവാൻ ഹേ ഇഫിഷായാഃ സർവ്വേ ലോകാ ആകർണയത, അർതിമീമഹാദേവ്യാ മഹാദേവാത് പതിതായാസ്തത്പ്രതിമായാശ്ച പൂജനമ ഇഫിഷനഗരസ്ഥാഃ സർവ്വേ ലോകാഃ കുർവ്വന്തി, ഏതത് കേ ന ജാനന്തി? ");
INSERT INTO sanmal_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","തസ്മാദ് ഏതത്പ്രതികൂലം കേപി കഥയിതും ന ശക്നുവന്തി, ഇതി ജ്ഞാത്വാ യുഷ്മാഭിഃ സുസ്ഥിരത്വേന സ്ഥാതവ്യമ് അവിവിച്യ കിമപി കർമ്മ ന കർത്തവ്യഞ്ച| ");
INSERT INTO sanmal_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","യാൻ ഏതാൻ മനുഷ്യാൻ യൂയമത്ര സമാനയത തേ മന്ദിരദ്രവ്യാപഹാരകാ യുഷ്മാകം ദേവ്യാ നിന്ദകാശ്ച ന ഭവന്തി| ");
INSERT INTO sanmal_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","യദി കഞ്ചന പ്രതി ദീമീത്രിയസ്യ തസ്യ സഹായാനാഞ്ച കാചിദ് ആപത്തി ർവിദ്യതേ തർഹി പ്രതിനിധിലോകാ വിചാരസ്ഥാനഞ്ച സന്തി, തേ തത് സ്ഥാനം ഗത്വാ ഉത്തരപ്രത്യുത്തരേ കുർവ്വന്തു| ");
INSERT INTO sanmal_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","കിന്തു യുഷ്മാകം കാചിദപരാ കഥാ യദി തിഷ്ഠതി തർഹി നിയമിതായാം സഭായാം തസ്യാ നിഷ്പത്തി ർഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","കിന്ത്വേതസ്യ വിരോധസ്യോത്തരം യേന ദാതും ശക്നുമ് ഏതാദൃശസ്യ കസ്യചിത് കാരണസ്യാഭാവാദ് അദ്യതനഘടനാഹേതോ രാജദ്രോഹിണാമിവാസ്മാകമ് അഭിയോഗോ ഭവിഷ്യതീതി ശങ്കാ വിദ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","ഇതി കഥയിത്വാ സ സഭാസ്ഥലോകാൻ വിസൃഷ്ടവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ഇത്ഥം കലഹേ നിവൃത്തേ സതി പൗലഃ ശിഷ്യഗണമ് ആഹൂയ വിസർജനം പ്രാപ്യ മാകിദനിയാദേശം പ്രസ്ഥിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","തേന സ്ഥാനേന ഗച്ഛൻ തദ്ദേശീയാൻ ശിഷ്യാൻ ബഹൂപദിശ്യ യൂനാനീയദേശമ് ഉപസ്ഥിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","തത്ര മാസത്രയം സ്ഥിത്വാ തസ്മാത് സുരിയാദേശം യാതുമ് ഉദ്യതഃ, കിന്തു യിഹൂദീയാസ്തം ഹന്തും ഗുപ്താ അതിഷ്ഠൻ തസ്മാത് സ പുനരപി മാകിദനിയാമാർഗേണ പ്രത്യാഗന്തും മതിം കൃതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","ബിരയാനഗരീയസോപാത്രഃ ഥിഷലനീകീയാരിസ്താർഖസികുന്ദൗ ദർബ്ബോനഗരീയഗായതീമഥിയൗ ആശിയാദേശീയതുഖികത്രഫിമൗ ച തേന സാർദ്ധം ആശിയാദേശം യാവദ് ഗതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ഏതേ സർവ്വേ ഽഗ്രസരാഃ സന്തോ ഽസ്മാൻ അപേക്ഷ്യ ത്രോയാനഗരേ സ്ഥിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","കിണ്വശൂന്യപൂപോത്സവദിനേ ച ഗതേ സതി വയം ഫിലിപീനഗരാത് തോയപഥേന ഗത്വാ പഞ്ചഭി ർദിനൈസ്ത്രോയാനഗരമ് ഉപസ്ഥായ തത്ര സപ്തദിനാന്യവാതിഷ്ഠാമ| ");
INSERT INTO sanmal_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","സപ്താഹസ്യ പ്രഥമദിനേ പൂപാൻ ഭംക്തു ശിഷ്യേഷു മിലിതേഷു പൗലഃ പരദിനേ തസ്മാത് പ്രസ്ഥാതുമ് ഉദ്യതഃ സൻ തദഹ്നി പ്രായേണ ക്ഷപായാ യാമദ്വയം യാവത് ശിഷ്യേഭ്യോ ധർമ്മകഥാമ് അകഥയത്| ");
INSERT INTO sanmal_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ഉപരിസ്ഥേ യസ്മിൻ പ്രകോഷ്ഠേ സഭാം കൃത്വാസൻ തത്ര ബഹവഃ പ്രദീപാഃ പ്രാജ്വലൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ഉതുഖനാമാ കശ്ചന യുവാ ച വാതായന ഉപവിശൻ ഘോരതരനിദ്രാഗ്രസ്തോ ഽഭൂത് തദാ പൗലേന ബഹുക്ഷണം കഥായാം പ്രചാരിതായാം നിദ്രാമഗ്നഃ സ തസ്മാദ് ഉപരിസ്ഥതൃതീയപ്രകോഷ്ഠാദ് അപതത്, തതോ ലോകാസ്തം മൃതകൽപം ധൃത്വോദതോലയൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","തതഃ പൗലോഽവരുഹ്യ തസ്യ ഗാത്രേ പതിത്വാ തം ക്രോഡേ നിധായ കഥിതവാൻ, യൂയം വ്യാകുലാ മാ ഭൂത നായം പ്രാണൈ ർവിയുക്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","പശ്ചാത് സ പുനശ്ചോപരി ഗത്വാ പൂപാൻ ഭംക്ത്വാ പ്രഭാതം യാവത് കഥോപകഥനേ കൃത്വാ പ്രസ്ഥിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","തേ ച തം ജീവന്തം യുവാനം ഗൃഹീത്വാ ഗത്വാ പരമാപ്യായിതാ ജാതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","അനന്തരം വയം പോതേനാഗ്രസരാ ഭൂത്വാസ്മനഗരമ് ഉത്തീര്യ്യ പൗലം ഗ്രഹീതും മതിമ് അകുർമ്മ യതഃ സ തത്ര പദ്ഭ്യാം വ്രജിതും മതിം കൃത്വേതി നിരൂപിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","തസ്മാത് തത്രാസ്മാഭിഃ സാർദ്ധം തസ്മിൻ മിലിതേ സതി വയം തം നീത്വാ മിതുലീന്യുപദ്വീപം പ്രാപ്തവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","തസ്മാത് പോതം മോചയിത്വാ പരേഽഹനി ഖീയോപദ്വീപസ്യ സമ്മുഖം ലബ്ധവന്തസ്തസ്മാദ് ഏകേനാഹ്നാ സാമോപദ്വീപം ഗത്വാ പോതം ലാഗയിത്വാ ത്രോഗുല്ലിയേ സ്ഥിത്വാ പരസ്മിൻ ദിവസേे മിലീതനഗരമ് ഉപാതിഷ്ഠാമ| ");
INSERT INTO sanmal_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","യതഃ പൗല ആശിയാദേശേ കാലം യാപയിതുമ് നാഭിലഷൻ ഇഫിഷനഗരം ത്യക്ത്വാ യാതും മന്ത്രണാം സ്ഥിരീകൃതവാൻ; യസ്മാദ് യദി സാധ്യം ഭവതി തർഹി നിസ്താരോത്സവസ്യ പഞ്ചാശത്തമദിനേ സ യിരൂശാലമ്യുപസ്ഥാതും മതിം കൃതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","പൗലോ മിലീതാദ് ഇഫിഷം പ്രതി ലോകം പ്രഹിത്യ സമാജസ്യ പ്രാചീനാൻ ആഹൂയാനീതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","തേഷു തസ്യ സമീപമ് ഉപസ്ഥിതേഷു സ തേഭ്യ ഇമാം കഥാം കഥിതവാൻ, അഹമ് ആശിയാദേശേ പ്രഥമാഗമനമ് ആരഭ്യാദ്യ യാവദ് യുഷ്മാകം സന്നിധൗ സ്ഥിത്വാ സർവ്വസമയേ യഥാചരിതവാൻ തദ് യൂയം ജാനീഥ; ");
INSERT INTO sanmal_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ഫലതഃ സർവ്വഥാ നമ്രമനാഃ സൻ ബഹുശ്രുപാതേന യിഹുദീയാനാമ് കുമന്ത്രണാജാതനാനാപരീക്ഷാഭിഃ പ്രഭോഃ സേവാമകരവം| ");
INSERT INTO sanmal_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","കാമപി ഹിതകഥാाം ന ഗോപായിതവാൻ താം പ്രചാര്യ്യ സപ്രകാശം ഗൃഹേ ഗൃഹേ സമുപദിശ്യേശ്വരം പ്രതി മനഃ പരാവർത്തനീയം പ്രഭൗ യീശുഖ്രീഷ്ടേ വിശ്വസനീയം ");
INSERT INTO sanmal_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","യിഹൂദീയാനാമ് അന്യദേശീയലോകാനാഞ്ച സമീപ ഏതാദൃശം സാക്ഷ്യം ദദാമി| ");
INSERT INTO sanmal_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","പശ്യത സാമ്പ്രതമ് ആത്മനാകൃഷ്ടഃ സൻ യിരൂശാലമ്നഗരേ യാത്രാം കരോമി, തത്ര മാമ്പ്രതി യദ്യദ് ഘടിഷ്യതേ താന്യഹം ന ജാനാമി; ");
INSERT INTO sanmal_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","കിന്തു മയാ ബന്ധനം ക്ലേശശ്ച ഭോക്തവ്യ ഇതി പവിത്ര ആത്മാ നഗരേ നഗരേ പ്രമാണം ദദാതി| ");
INSERT INTO sanmal_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","തഥാപി തം ക്ലേശമഹം തൃണായ ന മന്യേ; ഈശ്വരസ്യാനുഗ്രഹവിഷയകസ്യ സുസംവാദസ്യ പ്രമാണം ദാതും, പ്രഭോ ര്യീശോഃ സകാശാദ യസ്യാഃ സേവായാഃ ഭാരം പ്രാപ്നവം താം സേവാം സാധയിതും സാനന്ദം സ്വമാർഗം സമാപയിതുुഞ്ച നിജപ്രാണാനപി പ്രിയാൻ ന മന്യേ| ");
INSERT INTO sanmal_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","അധുനാ പശ്യത യേഷാം സമീപേഽഹമ് ഈശ്വരീയരാജ്യസ്യ സുസംവാദം പ്രചാര്യ്യ ഭ്രമണം കൃതവാൻ ഏതാദൃശാ യൂയം മമ വദനം പുന ർദ്രഷ്ടും ന പ്രാപ്സ്യഥ ഏതദപ്യഹം ജാനാമി| ");
INSERT INTO sanmal_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","യുഷ്മഭ്യമ് അഹമ് ഈശ്വരസ്യ സർവ്വാൻ ആദേശാൻ പ്രകാശയിതും ന ന്യവർത്തേ| ");
INSERT INTO sanmal_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","അഹം സർവ്വേഷാം ലോകാനാം രക്തപാതദോഷാദ് യന്നിർദോഷ ആസേ തസ്യാദ്യ യുഷ്മാൻ സാക്ഷിണഃ കരോമി| ");
INSERT INTO sanmal_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","യൂയം സ്വേഷു തഥാ യസ്യ വ്രജസ്യാധ്യക്ഷൻ ആത്മാ യുഷ്മാൻ വിധായ ന്യയുങ്ക്ത തത്സർവ്വസ്മിൻ സാവധാനാ ഭവത, യ സമാജഞ്ച പ്രഭു ർനിജരക്തമൂല്യേന ക്രീതവാന തമ് അവത, ");
INSERT INTO sanmal_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","യതോ മയാ ഗമനേ കൃതഏവ ദുർജയാ വൃകാ യുഷ്മാകം മധ്യം പ്രവിശ്യ വ്രജം പ്രതി നിർദയതാമ് ആചരിഷ്യന്തി, ");
INSERT INTO sanmal_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","യുഷ്മാകമേവ മധ്യാദപി ലോകാ ഉത്ഥായ ശിഷ്യഗണമ് അപഹന്തും വിപരീതമ് ഉപദേക്ഷ്യന്തീത്യഹം ജാനാമി| ");
INSERT INTO sanmal_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","ഇതി ഹേതോ ര്യൂയം സചൈതന്യാഃ സന്തസ്തിഷ്ടത, അഹഞ്ച സാശ്രുപാതഃ സൻ വത്സരത്രയം യാവദ് ദിവാനിശം പ്രതിജനം ബോധയിതും ന ന്യവർത്തേ തദപി സ്മരത| ");
INSERT INTO sanmal_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","ഇദാനീം ഹേ ഭ്രാതരോ യുഷ്മാകം നിഷ്ഠാം ജനയിതും പവിത്രീകൃതലോകാനാം മധ്യേഽധികാരഞ്ച ദാതും സമർഥോ യ ഈശ്വരസ്തസ്യാനുഗ്രഹസ്യ യോ വാദശ്ച തയോരുഭയോ ര്യുഷ്മാൻ സമാർപയമ്| ");
INSERT INTO sanmal_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","കസ്യാപി സ്വർണം രൂപ്യം വസ്ത്രം വാ പ്രതി മയാ ലോഭോ ന കൃതഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","കിന്തു മമ മത്സഹചരലോകാനാഞ്ചാവശ്യകവ്യയായ മദീയമിദം കരദ്വയമ് അശ്രാമ്യദ് ഏതദ് യൂയം ജാനീഥ| ");
INSERT INTO sanmal_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","അനേന പ്രകാരേണ ഗ്രഹണദ് ദാനം ഭദ്രമിതി യദ്വാക്യം പ്രഭു ര്യീശുഃ കഥിതവാൻ തത് സ്മർത്തും ദരിദ്രലോകാനാമുപകാരാർഥം ശ്രമം കർത്തുഞ്ച യുഷ്മാകമ് ഉചിതമ് ഏതത്സർവ്വം യുഷ്മാനഹമ് ഉപദിഷ്ടവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ഏതാം കഥാം കഥയിത്വാ സ ജാനുനീ പാതയിത്വാ സർവൈഃ സഹ പ്രാർഥയത| ");
INSERT INTO sanmal_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","തേന തേ ക്രന്ദ്രന്തഃ ");
INSERT INTO sanmal_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","പുന ർമമ മുഖം ന ദ്രക്ഷ്യഥ വിശേഷത ഏഷാ യാ കഥാ തേനാകഥി തത്കാരണാത് ശോകം വിലാപഞ്ച കൃത്വാ കണ്ഠം ധൃത്വാ ചുമ്ബിതവന്തഃ| പശ്ചാത് തേ തം പോതം നീതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","തൈ ർവിസൃഷ്ടാഃ സന്തോ വയം പോതം ബാഹയിത്വാ ഋജുമാർഗേണ കോഷമ് ഉപദ്വീപമ് ആഗത്യ പരേഽഹനി രോദിയോപദ്വീപമ് ആഗച്ഛാമ തതസ്തസ്മാത് പാതാരായാമ് ഉപാതിഷ്ഠാമ| ");
INSERT INTO sanmal_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","തത്ര ഫൈനീകിയാദേശഗാമിനമ് പോതമേകം പ്രാപ്യ തമാരുഹ്യ ഗതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","കുപ്രോപദ്വീപം ദൃഷ്ട്വാ തം സവ്യദിശി സ്ഥാപയിത്വാ സുരിയാദേശം ഗത്വാ പോതസ്ഥദ്രവ്യാണ്യവരോഹയിതും സോരനഗരേ ലാഗിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","തത്ര ശിഷ്യഗണസ്യ സാക്ഷാത്കരണായ വയം തത്ര സപ്തദിനാനി സ്ഥിതവന്തഃ പശ്ചാത്തേ പവിത്രേണാത്മനാ പൗലം വ്യാഹരൻ ത്വം യിരൂശാലമ്നഗരം മാ ഗമഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","തതസ്തേഷു സപ്തസു ദിനേഷു യാപിതേഷു സത്സു വയം തസ്മാത് സ്ഥാനാത് നിജവർത്മനാ ഗതവന്തഃ, തസ്മാത് തേ സബാലവൃദ്ധവനിതാ അസ്മാഭിഃ സഹ നഗരസ്യ പരിസരപര്യ്യന്തമ് ആഗതാഃ പശ്ചാദ്വയം ജലധിതടേ ജാനുപാതം പ്രാർഥയാമഹി| ");
INSERT INTO sanmal_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","തതഃ പരസ്പരം വിസൃഷ്ടാഃ സന്തോ വയം പോതം ഗതാസ്തേ തു സ്വസ്വഗൃഹം പ്രത്യാഗതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","വയം സോരനഗരാത് നാവാ പ്രസ്ഥായ തലിമായിനഗരമ് ഉപാതിഷ്ഠാമ തത്രാസ്മാകം സമുദ്രീയമാർഗസ്യാന്തോഽഭവത് തത്ര ഭ്രാതൃഗണം നമസ്കൃത്യ ദിനമേകം തൈഃ സാർദ്ധമ് ഉഷതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","പരേ ഽഹനി പൗലസ്തസ്യ സങ്ഗിനോ വയഞ്ച പ്രതിഷ്ഠമാനാഃ കൈസരിയാനഗരമ് ആഗത്യ സുസംവാദപ്രചാരകാനാം സപ്തജനാനാം ഫിലിപനാമ്ന ഏകസ്യ ഗൃഹം പ്രവിശ്യാവതിഷ്ഠാമ| ");
INSERT INTO sanmal_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","തസ്യ ചതസ്രോ ദുഹിതരോഽനൂഢാ ഭവിഷ്യദ്വാദിന്യ ആസൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","തത്രാസ്മാസു ബഹുദിനാനി പ്രോഷിതേഷു യിഹൂദീയദേശാദ് ആഗത്യാഗാബനാമാ ഭവിഷ്യദ്വാദീ സമുപസ്ഥിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","സോസ്മാകം സമീപമേത്യ പൗലസ്യ കടിബന്ധനം ഗൃഹീത്വാ നിജഹസ്താപാദാൻ ബദ്ധ്വാ ഭാഷിതവാൻ യസ്യേദം കടിബന്ധനം തം യിഹൂദീയലോകാ യിരൂശാലമനഗര ഇത്ഥം ബദ്ധ്വാ ഭിന്നദേശീയാനാം കരേഷു സമർപയിഷ്യന്തീതി വാക്യം പവിത്ര ആത്മാ കഥയതി| ");
INSERT INTO sanmal_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ഏതാദൃശീം കഥാം ശ്രുത്വാ വയം തന്നഗരവാസിനോ ഭ്രാതരശ്ച യിരൂശാലമം ന യാതും പൗലം വ്യനയാമഹി; ");
INSERT INTO sanmal_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","കിന്തു സ പ്രത്യാവാദീത്, യൂയം കിം കുരുഥ? കിം ക്രന്ദനേന മമാന്തഃകരണം വിദീർണം കരിഷ്യഥ? പ്രഭോ ര്യീശോ ർനാമ്നോ നിമിത്തം യിരൂശാലമി ബദ്ധോ ഭവിതും കേവല തന്ന പ്രാണാൻ ദാതുമപി സസജ്ജോസ്മി| ");
INSERT INTO sanmal_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","തേനാസ്മാകം കഥായാമ് അഗൃഹീതായാമ് ഈശ്വരസ്യ യഥേച്ഛാ തഥൈവ ഭവത്വിത്യുക്ത്വാ വയം നിരസ്യാമ| ");
INSERT INTO sanmal_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","പരേഽഹനി പാഥേയദ്രവ്യാണി ഗൃഹീത്വാ യിരൂശാലമം പ്രതി യാത്രാമ് അകുർമ്മ| ");
INSERT INTO sanmal_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","തതഃ കൈസരിയാനഗരനിവാസിനഃ കതിപയാഃ ശിഷ്യാ അസ്മാഭിഃ സാർദ്ധമ് ഇത്വാ കൃപ്രീയേന മ്നാസന്നാമ്നാ യേന പ്രാചീനശിഷ്യേന സാർദ്ധമ് അസ്മാഭി ർവസ്തവ്യം തസ്യ സമീപമ് അസ്മാൻ നീതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","അസ്മാസു യിരൂശാലമ്യുപസ്ഥിതേഷു തത്രസ്ഥഭ്രാതൃഗണോഽസ്മാൻ ആഹ്ലാദേന ഗൃഹീതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","പരസ്മിൻ ദിവസേ പൗലേഽസ്മാഭിഃ സഹ യാകൂബോ ഗൃഹം പ്രവിഷ്ടേ ലോകപ്രാചീനാഃ സർവ്വേ തത്ര പരിഷദി സംസ്ഥിതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","അനന്തരം സ താൻ നത്വാ സ്വീയപ്രചാരണേന ഭിന്നദേശീയാൻ പ്രതീശ്വരോ യാനി കർമ്മാണി സാധിതവാൻ തദീയാം കഥാമ് അനുക്രമാത് കഥിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ഇതി ശ്രുത്വാ തേ പ്രഭും ധന്യം പ്രോച്യ വാക്യമിദമ് അഭാഷന്ത, ഹേ ഭ്രാത ര്യിഹൂദീയാനാം മധ്യേ ബഹുസഹസ്രാണി ലോകാ വിശ്വാസിന ആസതേ കിന്തു തേ സർവ്വേ വ്യവസ്ഥാമതാചാരിണ ഏതത് പ്രത്യക്ഷം പശ്യസി| ");
INSERT INTO sanmal_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","ശിശൂനാം ത്വക്ഛേദനാദ്യാചരണം പ്രതിഷിധ്യ ത്വം ഭിന്നദേശനിവാസിനോ യിഹൂദീയലോകാൻ മൂസാവാക്യമ് അശ്രദ്ധാതുമ് ഉപദിശസീതി തൈഃ ശ്രുതമസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","ത്വമത്രാഗതോസീതി വാർത്താം സമാകർണ്യ ജനനിവഹോ മിലിത്വാവശ്യമേവാഗമിഷ്യതി; അതഏവ കിം കരണീയമ്? അത്ര വയം മന്ത്രയിത്വാ സമുപായം ത്വാം വദാമസ്തം ത്വമാചര| ");
INSERT INTO sanmal_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","വ്രതം കർത്തും കൃതസങ്കൽപാ യേഽസ്മാംക ചത്വാരോ മാനവാഃ സന്തി ");
INSERT INTO sanmal_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","താൻ ഗൃഹീത്വാ തൈഃ സഹിതഃ സ്വം ശുചിം കുരു തഥാ തേഷാം ശിരോമുണ്ഡനേ യോ വ്യയോ ഭവതി തം ത്വം ദേഹി| തഥാ കൃതേ ത്വദീയാചാരേ യാ ജനശ്രുതി ർജായതേ സാലീകാ കിന്തു ത്വം വിധിം പാലയൻ വ്യവസ്ഥാനുസാരേണേവാചരസീതി തേ ഭോത്സന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","ഭിന്നദേശീയാനാം വിശ്വാസിലോകാനാം നികടേ വയം പത്രം ലിഖിത്വേത്ഥം സ്ഥിരീകൃതവന്തഃ, ദേവപ്രസാദഭോജനം രക്തം ഗലപീഡനമാരിതപ്രാണിഭോജനം വ്യഭിചാരശ്ചൈതേഭ്യഃ സ്വരക്ഷണവ്യതിരേകേണ തേഷാമന്യവിധിപാലനം കരണീയം ന| ");
INSERT INTO sanmal_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","തതഃ പൗലസ്താൻ മാനുഷാനാദായ പരസ്മിൻ ദിവസേ തൈഃ സഹ ശുചി ർഭൂത്വാ മന്ദിരം ഗത്വാ ശൗചകർമ്മണോ ദിനേഷു സമ്പൂർണേഷു തേഷാമ് ഏകൈകാർഥം നൈവേദ്യാദ്യുത്സർഗോ ഭവിഷ്യതീതി ജ്ഞാപിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","തേഷു സപ്തസു ദിനേഷു സമാപ്തകൽപേഷു ആശിയാദേശനിവാസിനോ യിഹൂദീയാസ്തം മധ്യേമന്ദിരം വിലോക്യ ജനനിവഹസ്യ മനഃസു കുപ്രവൃത്തിം ജനയിത്വാ തം ധൃത്വാ ");
INSERT INTO sanmal_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","പ്രോച്ചൈഃ പ്രാവോചൻ, ഹേ ഇസ്രായേല്ലോകാഃ സർവ്വേ സാഹായ്യം കുരുത| യോ മനുജ ഏതേഷാം ലോകാനാം മൂസാവ്യവസ്ഥായാ ഏതസ്യ സ്ഥാനസ്യാപി വിപരീതം സർവ്വത്ര സർവ്വാൻ ശിക്ഷയതി സ ഏഷഃ; വിശേഷതഃ സ ഭിന്നദേശീയലോകാൻ മന്ദിരമ് ആനീയ പവിത്രസ്ഥാനമേതദ് അപവിത്രമകരോത്| ");
INSERT INTO sanmal_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","പൂർവ്വം തേ മധ്യേനഗരമ് ഇഫിഷനഗരീയം ത്രഫിമം പൗലേന സഹിതം ദൃഷ്ടവന്ത ഏതസ്മാത് പൗലസ്തം മന്ദിരമധ്യമ് ആനയദ് ഇത്യന്വമിമത| ");
INSERT INTO sanmal_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","അതഏവ സർവ്വസ്മിൻ നഗരേ കലഹോത്പന്നത്വാത് ധാവന്തോ ലോകാ ആഗത്യ പൗലം ധൃത്വാ മന്ദിരസ്യ ബഹിരാകൃഷ്യാനയൻ തത്ക്ഷണാദ് ദ്വാരാണി സർവ്വാണി ച രുദ്ധാനി| ");
INSERT INTO sanmal_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","തേഷു തം ഹന്തുമുദ്യതേेഷു യിരൂശാലമ്നഗരേ മഹാനുപദ്രവോ ജാത ഇതി വാർത്തായാം സഹസ്രസേനാപതേഃ കർണഗോചരീഭൂതായാം സത്യാം സ തത്ക്ഷണാത് സൈന്യാനി സേനാപതിഗണഞ്ച ഗൃഹീത്വാ ജവേനാഗതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","തതോ ലോകാഃ സേനാഗണേന സഹ സഹസ്രസേനാപതിമ് ആഗച്ഛന്തം ദൃഷ്ട്വാ പൗലതാഡനാതോ ന്യവർത്തന്ത| ");
INSERT INTO sanmal_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","സ സഹസ്രസേനാപതിഃ സന്നിധാവാഗമ്യ പൗലം ധൃത്വാ ശൃങ്ഖലദ്വയേന ബദ്ധമ് ആദിശ്യ താൻ പൃഷ്ടവാൻ ഏഷ കഃ? കിം കർമ്മ ചായം കൃതവാൻ? ");
INSERT INTO sanmal_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","തതോ ജനസമൂഹസ്യ കശ്ചിദ് ഏകപ്രകാരം കശ്ചിദ് അന്യപ്രകാരം വാക്യമ് അരൗത് സ തത്ര സത്യം ജ്ഞാതുമ് കലഹകാരണാദ് അശക്തഃ സൻ തം ദുർഗം നേതുമ് ആജ്ഞാപയത്| ");
INSERT INTO sanmal_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","തേഷു സോപാനസ്യോപരി പ്രാപ്തേഷു ലോകാനാം സാഹസകാരണാത് സേനാഗണഃ പൗലമുത്തോല്യ നീതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","തതഃ സർവ്വേ ലോകാഃ പശ്ചാദ്ഗാമിനഃ സന്ത ഏനം ദുരീകുരുതേതി വാക്യമ് ഉച്ചൈരവദൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","പൗലസ്യ ദുർഗാനയനസമയേ സ തസ്മൈ സഹസ്രസേനാപതയേ കഥിതവാൻ, ഭവതഃ പുരസ്താത് കഥാം കഥയിതും കിമ് അനുമന്യതേ? സ തമപൃച്ഛത് ത്വം കിം യൂനാനീയാം ഭാഷാം ജാനാസി? ");
INSERT INTO sanmal_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","യോ മിസരീയോ ജനഃ പൂർവ്വം വിരോധം കൃത്വാ ചത്വാരി സഹസ്രാണി ഘാതകാൻ സങ്ഗിനഃ കൃത്വാ വിപിനം ഗതവാൻ ത്വം കിം സഏവ ന ഭവസി? ");
INSERT INTO sanmal_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","തദാ പൗലോഽകഥയത് അഹം കിലികിയാദേശസ്യ താർഷനഗരീയോ യിഹൂദീയോ, നാഹം സാമാന്യനഗരീയോ മാനവഃ; അതഏവ വിനയേഽഹം ലാകാനാം സമക്ഷം കഥാം കഥയിതും മാമനുജാനീഷ്വ| ");
INSERT INTO sanmal_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","തേനാനുജ്ഞാതഃ പൗലഃ സോപാനോപരി തിഷ്ഠൻ ഹസ്തേനേങ്ഗിതം കൃതവാൻ, തസ്മാത് സർവ്വേ സുസ്ഥിരാ അഭവൻ| തദാ പൗല ഇബ്രീയഭാഷയാ കഥയിതുമ് ആരഭത, ");
INSERT INTO sanmal_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","ഹേ പിതൃഗണാ ഹേ ഭ്രാതൃഗണാഃ, ഇദാനീം മമ നിവേദനേ സമവധത്ത| ");
INSERT INTO sanmal_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","തദാ സ ഇബ്രീയഭാഷയാ കഥാം കഥയതീതി ശ്രുത്വാ സർവ്വേ ലോകാ അതീവ നിഃശബ്ദാ സന്തോഽതിഷ്ഠൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","പശ്ചാത് സോഽകഥയദ് അഹം യിഹൂദീയ ഇതി നിശ്ചയഃ കിലികിയാദേശസ്യ താർഷനഗരം മമ ജന്മഭൂമിഃ,ഏതന്നഗരീയസ്യ ഗമിലീയേലനാമ്നോഽധ്യാപകസ്യ ശിഷ്യോ ഭൂത്വാ പൂർവ്വപുരുഷാണാം വിധിവ്യവസ്ഥാനുസാരേണ സമ്പൂർണരൂപേണ ശിക്ഷിതോഽഭവമ് ഇദാനീന്തനാ യൂയം യാദൃശാ ഭവഥ താദൃശോഽഹമപീശ്വരസേവായാമ് ഉദ്യോഗീ ജാതഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","മതമേതദ് ദ്വിഷ്ട്വാ തദ്ഗ്രാഹിനാരീപുരുഷാൻ കാരായാം ബദ്ധ്വാ തേഷാം പ്രാണനാശപര്യ്യന്താം വിപക്ഷതാമ് അകരവമ്| ");
INSERT INTO sanmal_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","മഹായാജകഃ സഭാസദഃ പ്രാചീനലോകാശ്ച മമൈതസ്യാഃ കഥായാഃ പ്രമാണം ദാതും ശക്നുവന്തി, യസ്മാത് തേഷാം സമീപാദ് ദമ്മേഷകനഗരനിവാസിഭ്രാതൃഗണാർഥമ് ആജ്ഞാപത്രാണി ഗൃഹീത്വാ യേ തത്ര സ്ഥിതാസ്താൻ ദണ്ഡയിതും യിരൂശാലമമ് ആനയനാർഥം ദമ്മേഷകനഗരം ഗതോസ്മി| ");
INSERT INTO sanmal_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","കിന്തു ഗച്ഛൻ തന്നഗരസ്യ സമീപം പ്രാപ്തവാൻ തദാ ദ്വിതീയപ്രഹരവേലായാം സത്യാമ് അകസ്മാദ് ഗഗണാന്നിർഗത്യ മഹതീ ദീപ്തി ർമമ ചതുർദിശി പ്രകാശിതവതീ| ");
INSERT INTO sanmal_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","തതോ മയി ഭൂമൗै പതിതേ സതി, ഹേ ശൗല ഹേ ശൗല കുതോ മാം താഡയസി? മാമ്പ്രതി ഭാഷിത ഏതാദൃശ ഏകോ രവോപി മയാ ശ്രുതഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","തദാഹം പ്രത്യവദം, ഹേ പ്രഭേ കോ ഭവാൻ? തതഃ സോഽവാദീത് യം ത്വം താഡയസി സ നാസരതീയോ യീശുരഹം| ");
INSERT INTO sanmal_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","മമ സങ്ഗിനോ ലോകാസ്താം ദീപ്തിം ദൃഷ്ട്വാ ഭിയം പ്രാപ്താഃ, കിന്തു മാമ്പ്രത്യുദിതം തദ്വാക്യം തേे നാബുധ്യന്ത| ");
INSERT INTO sanmal_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","തതഃ പരം പൃഷ്ടവാനഹം, ഹേ പ്രഭോ മയാ കിം കർത്തവ്യം? തതഃ പ്രഭുരകഥയത്, ഉത്ഥായ ദമ്മേഷകനഗരം യാഹി ത്വയാ യദ്യത് കർത്തവ്യം നിരൂപിതമാസ്തേ തത് തത്ര ത്വം ജ്ഞാപയിഷ്യസേ| ");
INSERT INTO sanmal_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","അനന്തരം തസ്യാഃ ഖരതരദീപ്തേഃ കാരണാത് കിമപി ന ദൃഷ്ട്വാ സങ്ഗിഗണേന ധൃതഹസ്തഃ സൻ ദമ്മേഷകനഗരം വ്രജിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","തന്നഗരനിവാസിനാം സർവ്വേഷാം യിഹൂദീയാനാം മാന്യോ വ്യവസ്ഥാനുസാരേണ ഭക്തശ്ച ഹനാനീയനാമാ മാനവ ഏകോ ");
INSERT INTO sanmal_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","മമ സന്നിധിമ് ഏത്യ തിഷ്ഠൻ അകഥയത്, ഹേ ഭ്രാതഃ ശൗല സുദൃഷ്ടി ർഭവ തസ്മിൻ ദണ്ഡേഽഹം സമ്യക് തം ദൃഷ്ടവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","തതഃ സ മഹ്യം കഥിതവാൻ യഥാ ത്വമ് ഈശ്വരസ്യാഭിപ്രായം വേത്സി തസ്യ ശുദ്ധസത്ത്വജനസ്യ ദർശനം പ്രാപ്യ തസ്യ ശ്രീമുഖസ്യ വാക്യം ശൃണോഷി തന്നിമിത്തമ് അസ്മാകം പൂർവ്വപുരുഷാണാമ് ഈശ്വരസ്ത്വാം മനോനീതം കൃതവാനം| ");
INSERT INTO sanmal_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","യതോ യദ്യദ് അദ്രാക്ഷീരശ്രൗഷീശ്ച സർവ്വേഷാം മാനവാനാം സമീപേ ത്വം തേഷാം സാക്ഷീ ഭവിഷ്യസി| ");
INSERT INTO sanmal_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","അതഏവ കുതോ വിലമ്ബസേ? പ്രഭോ ർനാമ്നാ പ്രാർഥ്യ നിജപാപപ്രക്ഷാലനാർഥം മജ്ജനായ സമുത്തിഷ്ഠ| ");
INSERT INTO sanmal_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","തതഃ പരം യിരൂശാലമ്നഗരം പ്രത്യാഗത്യ മന്ദിരേഽഹമ് ഏകദാ പ്രാർഥയേ, തസ്മിൻ സമയേഽഹമ് അഭിഭൂതഃ സൻ പ്രഭൂം സാക്ഷാത് പശ്യൻ, ");
INSERT INTO sanmal_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ത്വം ത്വരയാ യിരൂശാലമഃ പ്രതിഷ്ഠസ്വ യതോ ലോകാമയി തവ സാക്ഷ്യം ന ഗ്രഹീഷ്യന്തി, മാമ്പ്രത്യുദിതം തസ്യേദം വാക്യമ് അശ്രൗഷമ്| ");
INSERT INTO sanmal_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","തതോഹം പ്രത്യവാദിഷമ് ഹേ പ്രഭോ പ്രതിഭജനഭവനം ത്വയി വിശ്വാസിനോ ലോകാൻ ബദ്ധ്വാ പ്രഹൃതവാൻ, ");
INSERT INTO sanmal_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","തഥാ തവ സാക്ഷിണഃ സ്തിഫാനസ്യ രക്തപാതനസമയേ തസ്യ വിനാശം സമ്മന്യ സന്നിധൗ തിഷ്ഠൻ ഹന്തൃലോകാനാം വാസാംസി രക്ഷിതവാൻ, ഏതത് തേ വിദുഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","തതഃ സോഽകഥയത് പ്രതിഷ്ഠസ്വ ത്വാം ദൂരസ്ഥഭിന്നദേശീയാനാം സമീപം പ്രേഷയിഷ്യേ| ");
INSERT INTO sanmal_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","തദാ ലോകാ ഏതാവത്പര്യ്യന്താം തദീയാം കഥാം ശ്രുത്വാ പ്രോച്ചൈരകഥയൻ, ഏനം ഭൂമണ്ഡലാദ് ദൂരീകുരുത, ഏതാദൃശജനസ്യ ജീവനം നോചിതമ്| ");
INSERT INTO sanmal_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ഇത്യുച്ചൈഃ കഥയിത്വാ വസനാനി പരിത്യജ്യ ഗഗണം പ്രതി ധൂലീരക്ഷിപൻ ");
INSERT INTO sanmal_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","തതഃ സഹസ്രസേനാപതിഃ പൗലം ദുർഗാഭ്യന്തര നേതും സമാദിശത്| ഏതസ്യ പ്രതികൂലാഃ സന്തോ ലോകാഃ കിന്നിമിത്തമ് ഏതാവദുച്ചൈഃസ്വരമ് അകുർവ്വൻ, ഏതദ് വേത്തും തം കശയാ പ്രഹൃത്യ തസ്യ പരീക്ഷാം കർത്തുമാദിശത്| ");
INSERT INTO sanmal_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","പദാതയശ്ചർമ്മനിർമ്മിതരജ്ജുഭിസ്തസ്യ ബന്ധനം കർത്തുമുദ്യതാസ്താസ്തദാനീം പൗലഃ സമ്മുഖസ്ഥിതം ശതസേനാപതിമ് ഉക്തവാൻ ദണ്ഡാജ്ഞായാമ് അപ്രാപ്തായാം കിം രോമിലോകം പ്രഹർത്തും യുഷ്മാകമ് അധികാരോസ്തി? ");
INSERT INTO sanmal_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","ഏനാം കഥാം ശ്രുത്വാ സ സഹസ്രസേനാപതേഃ സന്നിധിം ഗത്വാ താം വാർത്താമവദത് സ രോമിലോക ഏതസ്മാത് സാവധാനഃ സൻ കർമ്മ കുരു| ");
INSERT INTO sanmal_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","തസ്മാത് സഹസ്രസേനാപതി ർഗത്വാ തമപ്രാക്ഷീത് ത്വം കിം രോമിലോകഃ? ഇതി മാം ബ്രൂഹി| സോഽകഥയത് സത്യമ്| ");
INSERT INTO sanmal_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","തതഃ സഹസ്രസേനാപതിഃ കഥിതവാൻ ബഹുദ്രവിണം ദത്ത്വാഹം തത് പൗരസഖ്യം പ്രാപ്തവാൻ; കിന്തു പൗലഃ കഥിതവാൻ അഹം ജനുനാ തത് പ്രാപ്തോഽസ്മി| ");
INSERT INTO sanmal_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","ഇത്ഥം സതി യേ പ്രഹാരേണ തം പരീക്ഷിതും സമുദ്യതാ ആസൻ തേ തസ്യ സമീപാത് പ്രാതിഷ്ഠന്ത; സഹസ്രസേനാപതിസ്തം രോമിലോകം വിജ്ഞായ സ്വയം യത് തസ്യ ബന്ധനമ് അകാർഷീത് തത്കാരണാദ് അബിഭേത്| ");
INSERT INTO sanmal_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","യിഹൂദീയലോകാഃ പൗലം കുതോഽപവദന്തേ തസ്യ വൃത്താന്തം ജ്ഞാതും വാഞ്ഛൻ സഹസ്രസേനാപതിഃ പരേഽഹനി പൗലം ബന്ധനാത് മോചയിത്വാ പ്രധാനയാജകാൻ മഹാസഭായാഃ സർവ്വലോകാശ്ച സമുപസ്ഥാതുമ് ആദിശ്യ തേഷാം സന്നിധൗ പൗലമ് അവരോഹ്യ സ്ഥാപിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","സഭാസദ്ലോകാൻ പ്രതി പൗലോഽനന്യദൃഷ്ട്യാ പശ്യൻ അകഥയത്, ഹേ ഭ്രാതൃഗണാ അദ്യ യാവത് സരലേന സർവ്വാന്തഃകരണേനേശ്വരസ്യ സാക്ഷാദ് ആചരാമി| ");
INSERT INTO sanmal_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","അനേന ഹനാനീയനാമാ മഹായാജകസ്തം കപോലേ ചപേടേനാഹന്തും സമീപസ്ഥലോകാൻ ആദിഷ്ടവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","തദാ പൗലസ്തമവദത്, ഹേ ബഹിഷ്പരിഷ്കൃത, ഈശ്വരസ്ത്വാം പ്രഹർത്തുമ് ഉദ്യതോസ്തി, യതോ വ്യവസ്ഥാനുസാരേണ വിചാരയിതുമ് ഉപവിശ്യ വ്യവസ്ഥാം ലങ്ഘിത്വാ മാം പ്രഹർത്തുമ് ആജ്ഞാപയസി| ");
INSERT INTO sanmal_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","തതോ നികടസ്ഥാ ലോകാ അകഥയൻ, ത്വം കിമ് ഈശ്വരസ്യ മഹായാജകം നിന്ദസി? ");
INSERT INTO sanmal_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","തതഃ പൗലഃ പ്രതിഭാഷിതവാൻ ഹേ ഭ്രാതൃഗണ മഹായാജക ഏഷ ഇതി ന ബുദ്ധം മയാ തദന്യച്ച സ്വലോകാനാമ് അധിപതിം പ്രതി ദുർവ്വാക്യം മാ കഥയ, ഏതാദൃശീ ലിപിരസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","അനന്തരം പൗലസ്തേഷാമ് അർദ്ധം സിദൂകിലോകാ അർദ്ധം ഫിരൂശിലോകാ ഇതി ദൃഷ്ട്വാ പ്രോച്ചൈഃ സഭാസ്ഥലോകാൻ അവദത് ഹേ ഭ്രാതൃഗണ അഹം ഫിരൂശിമതാവലമ്ബീ ഫിരൂശിനഃ സത്നാനശ്ച, മൃതലോകാനാമ് ഉത്ഥാനേ പ്രത്യാശാകരണാദ് അഹമപവാദിതോസ്മി| ");
INSERT INTO sanmal_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ഇതി കഥായാം കഥിതായാം ഫിരൂശിസിദൂകിനോഃ പരസ്പരം ഭിന്നവാക്യത്വാത് സഭായാ മധ്യേ ദ്വൗ സംഘൗ ജാതൗ| ");
INSERT INTO sanmal_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","യതഃ സിദൂകിലോകാ ഉത്ഥാനം സ്വർഗീയദൂതാ ആത്മാനശ്ച സർവ്വേഷാമ് ഏതേഷാം കമപി ന മന്യന്തേ, കിന്തു ഫിരൂശിനഃ സർവ്വമ് അങ്ഗീകുർവ്വന്തി| ");
INSERT INTO sanmal_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","തതഃ പരസ്പരമ് അതിശയകോലാഹലേ സമുപസ്ഥിതേ ഫിരൂശിനാം പക്ഷീയാഃ സഭാസ്ഥാ അധ്യാപകാഃ പ്രതിപക്ഷാ ഉത്തിഷ്ഠന്തോ ഽകഥയൻ, ഏതസ്യ മാനവസ്യ കമപി ദോഷം ന പശ്യാമഃ; യദി കശ്ചിദ് ആത്മാ വാ കശ്ചിദ് ദൂത ഏനം പ്രത്യാദിശത് തർഹി വയമ് ഈശ്വരസ്യ പ്രാതികൂല്യേന ന യോത്സ്യാമഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","തസ്മാദ് അതീവ ഭിന്നവാക്യത്വേ സതി തേ പൗലം ഖണ്ഡം ഖണ്ഡം കരിഷ്യന്തീത്യാശങ്കയാ സഹസ്രസേനാപതിഃ സേനാഗണം തത്സ്ഥാനം യാതും സഭാതോ ബലാത് പൗലം ധൃത്വാ ദുർഗം നേതഞ്ചാജ്ഞാപയത്| ");
INSERT INTO sanmal_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","രാത്രോ പ്രഭുസ്തസ്യ സമീപേ തിഷ്ഠൻ കഥിതവാൻ ഹേ പൗല നിർഭയോ ഭവ യഥാ യിരൂശാലമ്നഗരേ മയി സാക്ഷ്യം ദത്തവാൻ തഥാ രോമാനഗരേപി ത്വയാ ദാതവ്യമ്| ");
INSERT INTO sanmal_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","ദിനേ സമുപസ്ഥിതേ സതി കിയന്തോ യിഹൂദീയലോകാ ഏകമന്ത്രണാഃ സന്തഃ പൗലം ന ഹത്വാ ഭോജനപാനേ കരിഷ്യാമ ഇതി ശപഥേന സ്വാൻ അബധ്നൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","ചത്വാരിംശജ്ജനേഭ്യോഽധികാ ലോകാ ഇതി പണമ് അകുർവ്വൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","തേ മഹായാജകാനാം പ്രാചീനലോകാനാഞ്ച സമീപം ഗത്വാ കഥയൻ, വയം പൗലം ന ഹത്വാ കിമപി ന ഭോക്ഷ്യാമഹേ ദൃഢേനാനേന ശപഥേന ബദ്ധ്വാ അഭവാമ| ");
INSERT INTO sanmal_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","അതഏവ സാമ്പ്രതം സഭാസദ്ലോകൈഃ സഹ വയം തസ്മിൻ കഞ്ചിദ് വിശേഷവിചാരം കരിഷ്യാമസ്തദർഥം ഭവാൻ ശ്വോ ഽസ്മാകം സമീപം തമ് ആനയത്വിതി സഹസ്രസേനാപതയേ നിവേദനം കുരുത തേന യുഷ്മാകം സമീപം ഉപസ്ഥിതേഃ പൂർവ്വം വയം തം ഹന്തു സജ്ജിഷ്യാമ| ");
INSERT INTO sanmal_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","തദാ പൗലസ്യ ഭാഗിനേയസ്തേഷാമിതി മന്ത്രണാം വിജ്ഞായ ദുർഗം ഗത്വാ താം വാർത്താം പൗലമ് ഉക്തവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","തസ്മാത് പൗല ഏകം ശതസേനാപതിമ് ആഹൂയ വാക്യമിദമ് ഭാഷിതവാൻ സഹസ്രസേനാപതേഃ സമീപേഽസ്യ യുവമനുഷ്യസ്യ കിഞ്ചിന്നിവേദനമ് ആസ്തേ, തസ്മാത് തത്സവിധമ് ഏനം നയ| ");
INSERT INTO sanmal_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","തതഃ സ തമാദായ സഹസ്രസേനാപതേഃ സമീപമ് ഉപസ്ഥായ കഥിതവാൻ, ഭവതഃ സമീപേഽസ്യ കിമപി നിവേദനമാസ്തേ തസ്മാത് ബന്ദിഃ പൗലോ മാമാഹൂയ ഭവതഃ സമീപമ് ഏനമ് ആനേതും പ്രാർഥിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","തദാ സഹസ്രസേനാപതിസ്തസ്യ ഹസ്തം ധൃത്വാ നിർജനസ്ഥാനം നീത്വാ പൃഷ്ഠവാൻ തവ കിം നിവേദനം? തത് കഥയ| ");
INSERT INTO sanmal_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","തതഃ സോകഥയത്, യിഹൂദീയലാകാഃ പൗലേ കമപി വിശേഷവിചാരം ഛലം കൃത്വാ തം സഭാം നേതും ഭവതഃ സമീപേ നിവേദയിതും അമന്ത്രയൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","കിന്തു മവതാ തന്ന സ്വീകർത്തവ്യം യതസ്തേഷാം മധ്യേവർത്തിനശ്ചത്വാരിംശജ്ജനേഭ്യോ ഽധികലോകാ ഏകമന്ത്രണാ ഭൂത്വാ പൗലം ന ഹത്വാ ഭോജനം പാനഞ്ച ന കരിഷ്യാമ ഇതി ശപഥേന ബദ്ധാഃ സന്തോ ഘാതകാ ഇവ സജ്ജിതാ ഇദാനീം കേവലം ഭവതോ ഽനുമതിമ് അപേക്ഷന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","യാമിമാം കഥാം ത്വം നിവേദിതവാൻ താം കസ്മൈചിദപി മാ കഥയേത്യുക്ത്വാ സഹസ്രസേനാപതിസ്തം യുവാനം വിസൃഷ്ടവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","അനന്തരം സഹസ്രസേനാപതി ർദ്വൗ ശതസേനാപതീ ആഹൂയേദമ് ആദിശത്, യുവാം രാത്രൗ പ്രഹരൈകാവശിഷ്ടായാം സത്യാം കൈസരിയാനഗരം യാതും പദാതിസൈന്യാനാം ദ്വേ ശതേ ഘോടകാരോഹിസൈന്യാനാം സപ്തതിം ശക്തിധാരിസൈന്യാനാം ദ്വേ ശതേ ച ജനാൻ സജ്ജിതാൻ കുരുതം| ");
INSERT INTO sanmal_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","പൗലമ് ആരോഹയിതും ഫീലിക്ഷാധിപതേഃ സമീപം നിർവ്വിഘ്നം നേതുഞ്ച വാഹനാനി സമുപസ്ഥാപയതം| ");
INSERT INTO sanmal_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","അപരം സ പത്രം ലിഖിത്വാ ദത്തവാൻ തല്ലിഖിതമേതത്, ");
INSERT INTO sanmal_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","മഹാമഹിമശ്രീയുക്തഫീലിക്ഷാധിപതയേ ക്ലൗദിയലുഷിയസ്യ നമസ്കാരഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","യിഹൂദീയലോകാഃ പൂർവ്വമ് ഏനം മാനവം ധൃത്വാ സ്വഹസ്തൈ ർഹന്തുമ് ഉദ്യതാ ഏതസ്മിന്നന്തരേ സസൈന്യോഹം തത്രോപസ്ഥായ ഏഷ ജനോ രോമീയ ഇതി വിജ്ഞായ തം രക്ഷിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","കിന്നിമിത്തം തേ തമപവദന്തേ തജ്ജ്ഞാതും തേഷാ സഭാം തമാനായിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","തതസ്തേഷാം വ്യവസ്ഥായാ വിരുദ്ധയാ കയാചന കഥയാ സോഽപവാദിതോഽഭവത്, കിന്തു സ ശൃങ്ഖലബന്ധനാർഹോ വാ പ്രാണനാശാർഹോ ഭവതീദൃശഃ കോപ്യപരാധോ മയാസ്യ ന ദൃഷ്ടഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","തഥാപി മനുഷ്യസ്യാസ്യ വധാർഥം യിഹൂദീയാ ഘാതകാഇവ സജ്ജിതാ ഏതാം വാർത്താം ശ്രുത്വാ തത്ക്ഷണാത് തവ സമീപമേനം പ്രേഷിതവാൻ അസ്യാപവാദകാംശ്ച തവ സമീപം ഗത്വാപവദിതുമ് ആജ്ഞാപയമ്| ഭവതഃ കുശലം ഭൂയാത്| ");
INSERT INTO sanmal_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","സൈന്യഗണ ആജ്ഞാനുസാരേണ പൗലം ഗൃഹീത്വാ തസ്യാം രജന്യാമ് ആന്തിപാത്രിനഗരമ് ആനയത്| ");
INSERT INTO sanmal_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","പരേഽഹനി തേന സഹ യാതും ഘോടകാരൂഢസൈന്യഗണം സ്ഥാപയിത്വാ പരാവൃത്യ ദുർഗം ഗതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","തതഃ പരേ ഘോടകാരോഹിസൈന്യഗണഃ കൈസരിയാനഗരമ് ഉപസ്ഥായ തത്പത്രമ് അധിപതേഃ കരേ സമർപ്യ തസ്യ സമീപേ പൗലമ് ഉപസ്ഥാപിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","തദാധിപതിസ്തത്പത്രം പഠിത്വാ പൃഷ്ഠവാൻ ഏഷ കിമ്പ്രദേശീയോ ജനഃ? സ കിലികിയാപ്രദേശീയ ഏകോ ജന ഇതി ജ്ഞാത്വാ കഥിതവാൻ, ");
INSERT INTO sanmal_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","തവാപവാദകഗണ ആഗതേ തവ കഥാം ശ്രോഷ്യാമി| ഹേരോദ്രാജഗൃഹേ തം സ്ഥാപയിതുമ് ആദിഷ്ടവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","പഞ്ചഭ്യോ ദിനേഭ്യഃ പരം ഹനാനീയനാമാ മഹായാജകോഽധിപതേഃ സമക്ഷം പൗലസ്യ പ്രാതികൂല്യേന നിവേദയിതും തർതുല്ലനാമാനം കഞ്ചന വക്താരം പ്രാചീനജനാംശ്ച സങ്ഗിനഃ കൃത്വാ കൈസരിയാനഗരമ് ആഗച്ഛത്| ");
INSERT INTO sanmal_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","തതഃ പൗലേ സമാനീതേ സതി തർതുല്ലസ്തസ്യാപവാദകഥാം കഥയിതുമ് ആരഭത ഹേ മഹാമഹിമഫീലിക്ഷ ഭവതോ വയമ് അതിനിർവ്വിഘ്നം കാലം യാപയാമോ ഭവതഃ പരിണാമദർശിതയാ ഏതദ്ദേശീയാനാം ബഹൂനി മങ്ഗലാനി ഘടിതാനി, ");
INSERT INTO sanmal_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","ഇതി ഹേതോ ർവയമതികൃതജ്ഞാഃ സന്തഃ സർവ്വത്ര സർവ്വദാ ഭവതോ ഗുണാൻ ഗായമഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","കിന്തു ബഹുഭിഃ കഥാഭി ർഭവന്തം യേന ന വിരഞ്ജയാമി തസ്മാദ് വിനയേ ഭവാൻ ബനുകമ്പ്യ മദൽപകഥാം ശൃണോതു| ");
INSERT INTO sanmal_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","ഏഷ മഹാമാരീസ്വരൂപോ നാസരതീയമതഗ്രാഹിസംഘാതസ്യ മുഖ്യോ ഭൂത്വാ സർവ്വദേശേഷു സർവ്വേഷാം യിഹൂദീയാനാം രാജദ്രോഹാചരണപ്രവൃത്തിം ജനയതീത്യസ്മാഭി ർനിശ്ചിതം| ");
INSERT INTO sanmal_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","സ മന്ദിരമപി അശുചി കർത്തും ചേഷ്ടിതവാൻ; ഇതി കാരണാദ് വയമ് ഏനം ധൃത്വാ സ്വവ്യവസ്ഥാനുസാരേണ വിചാരയിതും പ്രാവർത്താമഹി; ");
INSERT INTO sanmal_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","കിന്തു ലുഷിയഃ സഹസ്രസേനാപതിരാഗത്യ ബലാദ് അസ്മാകം കരേഭ്യ ഏനം ഗൃഹീത്വാ ");
INSERT INTO sanmal_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ഏതസ്യാപവാദകാൻ ഭവതഃ സമീപമ് ആഗന്തുമ് ആജ്ഞാപയത്| വയം യസ്മിൻ തമപവാദാമോ ഭവതാ പദപവാദകഥായാം വിചാരിതായാം സത്യാം സർവ്വം വൃത്താന്തം വേദിതും ശക്ഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","തതോ യിഹൂദീയാ അപി സ്വീകൃത്യ കഥിതവന്ത ഏഷാ കഥാ പ്രമാണമ്| ");
INSERT INTO sanmal_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","അധിപതൗ കഥാം കഥയിതും പൗലം പ്രതീങ്ഗിതം കൃതവതി സ കഥിതവാൻ ഭവാൻ ബഹൂൻ വത്സരാൻ യാവദ് ഏതദ്ദേശസ്യ ശാസനം കരോതീതി വിജ്ഞായ പ്രത്യുത്തരം ദാതുമ് അക്ഷോഭോഽഭവമ്| ");
INSERT INTO sanmal_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","അദ്യ കേവലം ദ്വാദശ ദിനാനി യാതാനി, അഹമ് ആരാധനാം കർത്തും യിരൂശാലമനഗരം ഗതവാൻ ഏഷാ കഥാ ഭവതാ ജ്ഞാതും ശക്യതേ; ");
INSERT INTO sanmal_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","കിന്ത്വിഭേ മാം മധ്യേമന്ദിരം കേനാപി സഹ വിതണ്ഡാം കുർവ്വന്തം കുത്രാപി ഭജനഭവനേ നഗരേ വാ ലോകാൻ കുപ്രവൃത്തിം ജനയന്തും ന ദൃഷ്ടവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","ഇദാനീം യസ്മിൻ യസ്മിൻ മാമ് അപവദന്തേ തസ്യ കിമപി പ്രമാണം ദാതും ന ശക്നുവന്തി| ");
INSERT INTO sanmal_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","കിന്തു ഭവിഷ്യദ്വാക്യഗ്രന്ഥേ വ്യവസ്ഥാഗ്രന്ഥേ ച യാ യാ കഥാ ലിഖിതാസ്തേ താസു സർവ്വാസു വിശ്വസ്യ യന്മതമ് ഇമേ വിധർമ്മം ജാനന്തി തന്മതാനുസാരേണാഹം നിജപിതൃപുരുഷാണാമ് ഈശ്വരമ് ആരാധയാമീത്യഹം ഭവതഃ സമക്ഷമ് അങ്ഗീകരോമി| ");
INSERT INTO sanmal_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","ധാർമ്മികാണാമ് അധാർമ്മികാണാഞ്ച പ്രമീതലോകാനാമേവോത്ഥാനം ഭവിഷ്യതീതി കഥാമിമേ സ്വീകുർവ്വന്തി തഥാഹമപി തസ്മിൻ ഈശ്വരേ പ്രത്യാശാം കരോമി; ");
INSERT INTO sanmal_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","ഈശ്വരസ്യ മാനവാനാഞ്ച സമീപേ യഥാ നിർദോഷോ ഭവാമി തദർഥം സതതം യത്നവാൻ അസ്മി| ");
INSERT INTO sanmal_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","ബഹുഷു വത്സരേഷു ഗതേഷു സ്വദേശീയലോകാനാം നിമിത്തം ദാനീയദ്രവ്യാണി നൈവേദ്യാനി ച സമാദായ പുനരാഗമനം കൃതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","തതോഹം ശുചി ർഭൂത്വാ ലോകാനാം സമാഗമം കലഹം വാ ന കാരിതവാൻ തഥാപ്യാശിയാദേശീയാഃ കിയന്തോ യിഹുദീയലോകാ മധ്യേമന്ദിരം മാം ധൃതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","മമോപരി യദി കാചിദപവാദകഥാസ്തി തർഹി ഭവതഃ സമീപമ് ഉപസ്ഥായ തേഷാമേവ സാക്ഷ്യദാനമ് ഉചിതമ്| ");
INSERT INTO sanmal_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","നോചേത് പൂർവ്വേ മഹാസഭാസ്ഥാനാം ലോകാനാം സന്നിധൗ മമ ദണ്ഡായമാനത്വസമയേ, അഹമദ്യ മൃതാനാമുത്ഥാനേ യുഷ്മാഭി ർവിചാരിതോസ്മി, ");
INSERT INTO sanmal_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","തേഷാം മധ്യേ തിഷ്ഠന്നഹം യാമിമാം കഥാമുച്ചൈഃ സ്വരേണ കഥിതവാൻ തദന്യോ മമ കോപി ദോഷോഽലഭ്യത ന വേതി വരമ് ഏതേ സമുപസ്ഥിതലോകാ വദന്തു| ");
INSERT INTO sanmal_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","തദാ ഫീലിക്ഷ ഏതാം കഥാം ശ്രുത്വാ തന്മതസ്യ വിശേഷവൃത്താന്തം വിജ്ഞാതും വിചാരം സ്ഥഗിതം കൃത്വാ കഥിതവാൻ ലുഷിയേ സഹസ്രസേനാപതൗ സമായാതേ സതി യുഷ്മാകം വിചാരമ് അഹം നിഷ്പാദയിഷ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","അനന്തരം ബന്ധനം വിനാ പൗലം രക്ഷിതും തസ്യ സേവനായ സാക്ഷാത്കരണായ വാ തദീയാത്മീയബന്ധുജനാൻ ന വാരയിതുഞ്ച ശമസേനാപതിമ് ആദിഷ്ടവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","അൽപദിനാത് പരം ഫീലിക്ഷോഽധിപതി ർദ്രുഷില്ലാനാമ്നാ യിഹൂദീയയാ സ്വഭാര്യ്യയാ സഹാഗത്യ പൗലമാഹൂയ തസ്യ മുഖാത് ഖ്രീഷ്ടധർമ്മസ്യ വൃത്താന്തമ് അശ്രൗഷീത്| ");
INSERT INTO sanmal_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","പൗലേന ന്യായസ്യ പരിമിതഭോഗസ്യ ചരമവിചാരസ്യ ച കഥായാം കഥിതായാം സത്യാം ഫീലിക്ഷഃ കമ്പമാനഃ സൻ വ്യാഹരദ് ഇദാനീം യാഹി, അഹമ് അവകാശം പ്രാപ്യ ത്വാമ് ആഹൂസ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","മുക്തിപ്രപ്ത്യർഥം പൗലേന മഹ്യം മുദ്രാദാസ്യന്തേ ഇതി പത്യാശാം കൃത്വാ സ പുനഃ പുനസ്തമാഹൂയ തേന സാകം കഥോപകഥനം കൃതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","കിന്തു വത്സരദ്വയാത് പരം പർകിയഫീഷ്ട ഫാലിക്ഷസ്യ പദം പ്രാപ്തേ സതി ഫീലിക്ഷോ യിഹൂദീയാൻ സന്തുഷ്ടാൻ ചികീർഷൻ പൗലം ബദ്ധം സംസ്ഥാപ്യ ഗതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","അനന്തരം ഫീഷ്ടോ നിജരാജ്യമ് ആഗത്യ ദിനത്രയാത് പരം കൈസരിയാതോ യിരൂശാലമ്നഗരമ് ആഗമത്| ");
INSERT INTO sanmal_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","തദാ മഹായാജകോ യിഹൂദീയാനാം പ്രധാനലോകാശ്ച തസ്യ സമക്ഷം പൗലമ് അപാവദന്ത| ");
INSERT INTO sanmal_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ഭവാൻ തം യിരൂശാലമമ് ആനേതുമ് ആജ്ഞാപയത്വിതി വിനീയ തേ തസ്മാദ് അനുഗ്രഹം വാഞ്ഛിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","യതഃ പഥിമധ്യേ ഗോപനേന പൗലം ഹന്തും തൈ ർഘാതകാ നിയുക്താഃ| ഫീഷ്ട ഉത്തരം ദത്തവാൻ പൗലഃ കൈസരിയായാം സ്ഥാസ്യതി പുനരൽപദിനാത് പരമ് അഹം തത്ര യാസ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","തതസ്തസ്യ മാനുഷസ്യ യദി കശ്ചിദ് അപരാധസ്തിഷ്ഠതി തർഹി യുഷ്മാകം യേ ശക്നുവന്തി തേ മയാ സഹ തത്ര ഗത്വാ തമപവദന്തു സ ഏതാം കഥാം കഥിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","ദശദിവസേഭ്യോഽധികം വിലമ്ബ്യ ഫീഷ്ടസ്തസ്മാത് കൈസരിയാനഗരം ഗത്വാ പരസ്മിൻ ദിവസേ വിചാരാസന ഉപദിശ്യ പൗലമ് ആനേതുമ് ആജ്ഞാപയത്| ");
INSERT INTO sanmal_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","പൗലേ സമുപസ്ഥിതേ സതി യിരൂശാലമ്നഗരാദ് ആഗതാ യിഹൂദീയലോകാസ്തം ചതുർദിശി സംവേഷ്ട്യ തസ്യ വിരുദ്ധം ബഹൂൻ മഹാദോഷാൻ ഉത്ഥാപിതവന്തഃ കിന്തു തേഷാം കിമപി പ്രമാണം ദാതും ന ശക്നുവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","തതഃ പൗലഃ സ്വസ്മിൻ ഉത്തരമിദമ് ഉദിതവാൻ, യിഹൂദീയാനാം വ്യവസ്ഥായാ മന്ദിരസ്യ കൈസരസ്യ വാ പ്രതികൂലം കിമപി കർമ്മ നാഹം കൃതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","കിന്തു ഫീഷ്ടോ യിഹൂദീയാൻ സന്തുഷ്ടാൻ കർത്തുമ് അഭിലഷൻ പൗലമ് അഭാഷത ത്വം കിം യിരൂശാലമം ഗത്വാസ്മിൻ അഭിയോഗേ മമ സാക്ഷാദ് വിചാരിതോ ഭവിഷ്യസി? ");
INSERT INTO sanmal_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","തതഃ പൗല ഉത്തരം പ്രോക്തവാൻ, യത്ര മമ വിചാരോ ഭവിതും യോഗ്യഃ കൈസരസ്യ തത്ര വിചാരാസന ഏവ സമുപസ്ഥിതോസ്മി; അഹം യിഹൂദീയാനാം കാമപി ഹാനിം നാകാർഷമ് ഇതി ഭവാൻ യഥാർഥതോ വിജാനാതി| ");
INSERT INTO sanmal_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","കഞ്ചിദപരാധം കിഞ്ചന വധാർഹം കർമ്മ വാ യദ്യഹമ് അകരിഷ്യം തർഹി പ്രാണഹനനദണ്ഡമപി ഭോക്തുമ് ഉദ്യതോഽഭവിഷ്യം, കിന്തു തേ മമ സമപവാദം കുർവ്വന്തി സ യദി കൽപിതമാത്രോ ഭവതി തർഹി തേഷാം കരേഷു മാം സമർപയിതും കസ്യാപ്യധികാരോ നാസ്തി, കൈസരസ്യ നികടേ മമ വിചാരോ ഭവതു| ");
INSERT INTO sanmal_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","തദാ ഫീഷ്ടോ മന്ത്രിഭിഃ സാർദ്ധം സംമന്ത്ര്യ പൗലായ കഥിതവാൻ, കൈസരസ്യ നികടേ കിം തവ വിചാരോ ഭവിഷ്യതി? കൈസരസ്യ സമീപം ഗമിഷ്യസി| ");
INSERT INTO sanmal_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","കിയദ്ദിനേഭ്യഃ പരമ് ആഗ്രിപ്പരാജാ ബർണീകീ ച ഫീഷ്ടം സാക്ഷാത് കർത്തും കൈസരിയാനഗരമ് ആഗതവന്തൗ| ");
INSERT INTO sanmal_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","തദാ തൗ ബഹുദിനാനി തത്ര സ്ഥിതൗ തതഃ ഫീഷ്ടസ്തം രാജാനം പൗലസ്യ കഥാം വിജ്ഞാപ്യ കഥയിതുമ് ആരഭത പൗലനാമാനമ് ഏകം ബന്ദി ഫീലിക്ഷോ ബദ്ധം സംസ്ഥാപ്യ ഗതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","യിരൂശാലമി മമ സ്ഥിതികാലേ മഹായാജകോ യിഹൂദീയാനാം പ്രാചീനലോകാശ്ച തമ് അപോദ്യ തമ്പ്രതി ദണ്ഡാജ്ഞാം പ്രാർഥയന്ത| ");
INSERT INTO sanmal_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","തതോഹമ് ഇത്യുത്തരമ് അവദം യാവദ് അപോദിതോ ജനഃ സ്വാപവാദകാൻ സാക്ഷാത് കൃത്വാ സ്വസ്മിൻ യോഽപരാധ ആരോപിതസ്തസ്യ പ്രത്യുത്തരം ദാതും സുയോഗം ന പ്രാപ്നോതി, താവത്കാലം കസ്യാപി മാനുഷസ്യ പ്രാണനാശാജ്ഞാപനം രോമിലോകാനാം രീതി ർനഹി| ");
INSERT INTO sanmal_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","തതസ്തേഷ്വത്രാഗതേഷു പരസ്മിൻ ദിവസേഽഹമ് അവിലമ്ബം വിചാരാസന ഉപവിശ്യ തം മാനുഷമ് ആനേതുമ് ആജ്ഞാപയമ്| ");
INSERT INTO sanmal_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","തദനന്തരം തസ്യാപവാദകാ ഉപസ്ഥായ യാദൃശമ് അഹം ചിന്തിതവാൻ താദൃശം കഞ്ചന മഹാപവാദം നോത്ഥാപ്യ ");
INSERT INTO sanmal_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","സ്വേഷാം മതേ തഥാ പൗലോ യം സജീവം വദതി തസ്മിൻ യീശുനാമനി മൃതജനേ ച തസ്യ വിരുദ്ധം കഥിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","തതോഹം താദൃഗ്വിചാരേ സംശയാനഃ സൻ കഥിതവാൻ ത്വം യിരൂശാലമം ഗത്വാ കിം തത്ര വിചാരിതോ ഭവിതുമ് ഇച്ഛസി? ");
INSERT INTO sanmal_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","തദാ പൗലോ മഹാരാജസ്യ നികടേ വിചാരിതോ ഭവിതും പ്രാർഥയത, തസ്മാദ് യാവത്കാലം തം കൈസരസ്യ സമീപം പ്രേഷയിതും ന ശക്നോമി താവത്കാലം തമത്ര സ്ഥാപയിതുമ് ആദിഷ്ടവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","തത ആഗ്രിപ്പഃ ഫീഷ്ടമ് ഉക്തവാൻ, അഹമപി തസ്യ മാനുഷസ്യ കഥാം ശ്രോതുമ് അഭിലഷാമി| തദാ ഫീഷ്ടോ വ്യാഹരത് ശ്വസ്തദീയാം കഥാം ത്വം ശ്രോഷ്യസി| ");
INSERT INTO sanmal_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","പരസ്മിൻ ദിവസേ ആഗ്രിപ്പോ ബർണീകീ ച മഹാസമാഗമം കൃത്വാ പ്രധാനവാഹിനീപതിഭി ർനഗരസ്ഥപ്രധാനലോകൈശ്ച സഹ മിലിത്വാ രാജഗൃഹമാഗത്യ സമുപസ്ഥിതൗ തദാ ഫീഷ്ടസ്യാജ്ഞയാ പൗല ആനീതോഽഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","തദാ ഫീഷ്ടഃ കഥിതവാൻ ഹേ രാജൻ ആഗ്രിപ്പ ഹേ ഉപസ്ഥിതാഃ സർവ്വേ ലോകാ യിരൂശാലമ്നഗരേ യിഹൂദീയലോകസമൂഹോ യസ്മിൻ മാനുഷേ മമ സമീപേ നിവേദനം കൃത്വാ പ്രോച്ചൈഃ കഥാമിമാം കഥിതവാൻ പുനരൽപകാലമപി തസ്യ ജീവനം നോചിതം തമേതം മാനുഷം പശ്യത| ");
INSERT INTO sanmal_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","കിന്ത്വേഷ ജനഃ പ്രാണനാശർഹം കിമപി കർമ്മ ന കൃതവാൻ ഇത്യജാനാം തഥാപി സ മഹാരാജസ്യ സന്നിധൗ വിചാരിതോ ഭവിതും പ്രാർഥയത തസ്മാത് തസ്യ സമീപം തം പ്രേഷയിതും മതിമകരവമ്| ");
INSERT INTO sanmal_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","കിന്തു ശ്രീയുക്തസ്യ സമീപമ് ഏതസ്മിൻ കിം ലേഖനീയമ് ഇത്യസ്യ കസ്യചിൻ നിർണയസ്യ ന ജാതത്വാദ് ഏതസ്യ വിചാരേ സതി യഥാഹം ലേഖിതും കിഞ്ചന നിശ്ചിതം പ്രാപ്നോമി തദർഥം യുഷ്മാകം സമക്ഷം വിശേഷതോ ഹേ ആഗ്രിപ്പരാജ ഭവതഃ സമക്ഷമ് ഏതമ് ആനയേ| ");
INSERT INTO sanmal_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","യതോ ബന്ദിപ്രേഷണസമയേ തസ്യാഭിയോഗസ്യ കിഞ്ചിദലേഖനമ് അഹമ് അയുക്തം ജാനാമി| ");
INSERT INTO sanmal_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","തത ആഗ്രിപ്പഃ പൗലമ് അവാദീത്, നിജാം കഥാം കഥയിതും തുഭ്യമ് അനുമതി ർദീയതേ| തസ്മാത് പൗലഃ കരം പ്രസാര്യ്യ സ്വസ്മിൻ ഉത്തരമ് അവാദീത്| ");
INSERT INTO sanmal_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","ഹേ ആഗ്രിപ്പരാജ യത്കാരണാദഹം യിഹൂദീയൈരപവാദിതോ ഽഭവം തസ്യ വൃത്താന്തമ് അദ്യ ഭവതഃ സാക്ഷാൻ നിവേദയിതുമനുമതോഹമ് ഇദം സ്വീയം പരമം ഭാഗ്യം മന്യേ; ");
INSERT INTO sanmal_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","യതോ യിഹൂദീയലോകാനാം മധ്യേ യാ യാ രീതിഃ സൂക്ഷ്മവിചാരാശ്ച സന്തി തേഷു ഭവാൻ വിജ്ഞതമഃ; അതഏവ പ്രാർഥയേ ധൈര്യ്യമവലമ്ബ്യ മമ നിവേദനം ശൃണോതു| ");
INSERT INTO sanmal_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","അഹം യിരൂശാലമ്നഗരേ സ്വദേശീയലോകാനാം മധ്യേ തിഷ്ഠൻ ആ യൗവനകാലാദ് യദ്രൂപമ് ആചരിതവാൻ തദ് യിഹൂദീയലോകാഃ സർവ്വേ വിദന്തി| ");
INSERT INTO sanmal_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","അസ്മാകം സർവ്വേഭ്യഃ ശുദ്ധതമം യത് ഫിരൂശീയമതം തദവലമ്ബീ ഭൂത്വാഹം കാലം യാപിതവാൻ യേ ജനാ ആ ബാല്യകാലാൻ മാം ജാനാന്തി തേ ഏതാദൃശം സാക്ഷ്യം യദി ദദാതി തർഹി ദാതും ശക്നുവന്തി| ");
INSERT INTO sanmal_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","കിന്തു ഹേ ആഗ്രിപ്പരാജ ഈശ്വരോഽസ്മാകം പൂർവ്വപുരുഷാണാം നികടേ യദ് അങ്ഗീകൃതവാൻ തസ്യ പ്രത്യാശാഹേതോരഹമ് ഇദാനീം വിചാരസ്ഥാനേ ദണ്ഡായമാനോസ്മി| ");
INSERT INTO sanmal_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","തസ്യാങ്ഗീകാരസ്യ ഫലം പ്രാപ്തുമ് അസ്മാകം ദ്വാദശവംശാ ദിവാനിശം മഹായത്നാദ് ഈശ്വരസേവനം കൃത്വാ യാം പ്രത്യാശാം കുർവ്വന്തി തസ്യാഃ പ്രത്യാശായാ ഹേതോരഹം യിഹൂദീയൈരപവാദിതോഽഭവമ്| ");
INSERT INTO sanmal_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","ഈശ്വരോ മൃതാൻ ഉത്ഥാപയിഷ്യതീതി വാക്യം യുഷ്മാകം നികടേഽസമ്ഭവം കുതോ ഭവേത്? ");
INSERT INTO sanmal_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","നാസരതീയയീശോ ർനാമ്നോ വിരുദ്ധം നാനാപ്രകാരപ്രതികൂലാചരണമ് ഉചിതമ് ഇത്യഹം മനസി യഥാർഥം വിജ്ഞായ ");
INSERT INTO sanmal_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","യിരൂശാലമനഗരേ തദകരവം ഫലതഃ പ്രധാനയാജകസ്യ നികടാത് ക്ഷമതാം പ്രാപ്യ ബഹൂൻ പവിത്രലോകാൻ കാരായാം ബദ്ധവാൻ വിശേഷതസ്തേഷാം ഹനനസമയേ തേഷാം വിരുദ്ധാം നിജാം സമ്മതിം പ്രകാശിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","വാരം വാരം ഭജനഭവനേഷു തേഭ്യോ ദണ്ഡം പ്രദത്തവാൻ ബലാത് തം ധർമ്മം നിന്ദയിതവാംശ്ച പുനശ്ച താൻ പ്രതി മഹാക്രോധാദ് ഉന്മത്തഃ സൻ വിദേശീയനഗരാണി യാവത് താൻ താഡിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","ഇത്ഥം പ്രധാനയാജകസ്യ സമീപാത് ശക്തിമ് ആജ്ഞാപത്രഞ്ച ലബ്ധ്വാ ദമ്മേഷക്നഗരം ഗതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","തദാഹം ഹേ രാജൻ മാർഗമധ്യേ മധ്യാഹ്നകാലേ മമ മദീയസങ്ഗിനാം ലോകാനാഞ്ച ചതസൃഷു ദിക്ഷു ഗഗണാത് പ്രകാശമാനാം ഭാസ്കരതോപി തേജസ്വതീം ദീപ്തിം ദൃഷ്ടവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","തസ്മാദ് അസ്മാസു സർവ്വേഷു ഭൂമൗ പതിതേഷു സത്സു ഹേ ശൗല ഹൈ ശൗല കുതോ മാം താഡയസി? കണ്ടകാനാം മുഖേ പാദാഹനനം തവ ദുഃസാധ്യമ് ഇബ്രീയഭാഷയാ ഗദിത ഏതാദൃശ ഏകഃ ശബ്ദോ മയാ ശ്രുതഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","തദാഹം പൃഷ്ടവാൻ ഹേ പ്രഭോ കോ ഭവാൻ? തതഃ സ കഥിതവാൻ യം യീശും ത്വം താഡയസി സോഹം, ");
INSERT INTO sanmal_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","കിന്തു സമുത്തിഷ്ഠ ത്വം യദ് ദൃഷ്ടവാൻ ഇതഃ പുനഞ്ച യദ്യത് ത്വാം ദർശയിഷ്യാമി തേഷാം സർവ്വേഷാം കാര്യ്യാണാം ത്വാം സാക്ഷിണം മമ സേവകഞ്ച കർത്തുമ് ദർശനമ് അദാമ്| ");
INSERT INTO sanmal_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","വിശേഷതോ യിഹൂദീയലോകേഭ്യോ ഭിന്നജാതീയേഭ്യശ്ച ത്വാം മനോനീതം കൃത്വാ തേഷാം യഥാ പാപമോചനം ഭവതി ");
INSERT INTO sanmal_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","യഥാ തേ മയി വിശ്വസ്യ പവിത്രീകൃതാനാം മധ്യേ ഭാഗം പ്രാപ്നുവന്തി തദഭിപ്രായേണ തേഷാം ജ്ഞാനചക്ഷൂംഷി പ്രസന്നാനി കർത്തും തഥാന്ധകാരാദ് ദീപ്തിം പ്രതി ശൈതാനാധികാരാച്ച ഈശ്വരം പ്രതി മതീഃ പരാവർത്തയിതും തേഷാം സമീപം ത്വാം പ്രേഷ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","ഹേ ആഗ്രിപ്പരാജ ഏതാദൃശം സ്വർഗീയപ്രത്യാദേശം അഗ്രാഹ്യമ് അകൃത്വാഹം ");
INSERT INTO sanmal_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","പ്രഥമതോ ദമ്മേഷക്നഗരേ തതോ യിരൂശാലമി സർവ്വസ്മിൻ യിഹൂദീയദേശേ അന്യേഷു ദേശേഷു ച യേेന ലോകാ മതിം പരാവർത്ത്യ ഈശ്വരം പ്രതി പരാവർത്തയന്തേ, മനഃപരാവർത്തനയോഗ്യാനി കർമ്മാണി ച കുർവ്വന്തി താദൃശമ് ഉപദേശം പ്രചാരിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","ഏതത്കാരണാദ് യിഹൂദീയാ മധ്യേമന്ദിരം മാം ധൃത്വാ ഹന്തുമ് ഉദ്യതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","തഥാപി ഖ്രീഷ്ടോ ദുഃഖം ഭുക്ത്വാ സർവ്വേഷാം പൂർവ്വം ശ്മശാനാദ് ഉത്ഥായ നിജദേശീയാനാം ഭിന്നദേശീയാനാഞ്ച സമീപേ ദീപ്തിം പ്രകാശയിഷ്യതി ");
INSERT INTO sanmal_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","ഭവിഷ്യദ്വാദിഗണോ മൂസാശ്ച ഭാവികാര്യ്യസ്യ യദിദം പ്രമാണമ് അദദുരേതദ് വിനാന്യാം കഥാം ന കഥയിത്വാ ഈശ്വരാദ് അനുഗ്രഹം ലബ്ധ്വാ മഹതാം ക്ഷുദ്രാണാഞ്ച സർവ്വേഷാം സമീപേ പ്രമാണം ദത്ത്വാദ്യ യാവത് തിഷ്ഠാമി| ");
INSERT INTO sanmal_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","തസ്യമാം കഥാം നിശമ്യ ഫീഷ്ട ഉച്ചൈഃ സ്വരേണ കഥിതവാൻ ഹേ പൗല ത്വമ് ഉന്മത്തോസി ബഹുവിദ്യാഭ്യാസേന ത്വം ഹതജ്ഞാനോ ജാതഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","സ ഉക്തവാൻ ഹേ മഹാമഹിമ ഫീഷ്ട നാഹമ് ഉന്മത്തഃ കിന്തു സത്യം വിവേചനീയഞ്ച വാക്യം പ്രസ്തൗമി| ");
INSERT INTO sanmal_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","യസ്യ സാക്ഷാദ് അക്ഷോഭഃ സൻ കഥാം കഥയാമി സ രാജാ തദ്വൃത്താന്തം ജാനാതി തസ്യ സമീപേ കിമപി ഗുപ്തം നേതി മയാ നിശ്ചിതം ബുധ്യതേ യതസ്തദ് വിജനേ ന കൃതം| ");
INSERT INTO sanmal_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","ഹേ ആഗ്രിപ്പരാജ ഭവാൻ കിം ഭവിഷ്യദ്വാദിഗണോക്താനി വാക്യാനി പ്രത്യേതി? ഭവാൻ പ്രത്യേതി തദഹം ജാനാമി| ");
INSERT INTO sanmal_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","തത ആഗ്രിപ്പഃ പൗലമ് അഭിഹിതവാൻ ത്വം പ്രവൃത്തിം ജനയിത്വാ പ്രായേണ മാമപി ഖ്രീഷ്ടീയം കരോഷി| ");
INSERT INTO sanmal_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","തതഃ സോഽവാദീത് ഭവാൻ യേ യേ ലോകാശ്ച മമ കഥാമ് അദ്യ ശൃണ്വന്തി പ്രായേണ ഇതി നഹി കിന്ത്വേതത് ശൃങ്ഖലബന്ധനം വിനാ സർവ്വഥാ തേ സർവ്വേ മാദൃശാ ഭവന്ത്വിതീശ്വസ്യ സമീപേ പ്രാർഥയേഽഹമ്| ");
INSERT INTO sanmal_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","ഏതസ്യാം കഥായാം കഥിതായാം സ രാജാ സോഽധിപതി ർബർണീകീ സഭാസ്ഥാ ലോകാശ്ച തസ്മാദ് ഉത്ഥായ ");
INSERT INTO sanmal_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ഗോപനേ പരസ്പരം വിവിച്യ കഥിതവന്ത ഏഷ ജനോ ബന്ധനാർഹം പ്രാണഹനനാർഹം വാ കിമപി കർമ്മ നാകരോത്| ");
INSERT INTO sanmal_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","തത ആഗ്രിപ്പഃ ഫീഷ്ടമ് അവദത്, യദ്യേഷ മാനുഷഃ കൈസരസ്യ നികടേ വിചാരിതോ ഭവിതും ന പ്രാർഥയിഷ്യത് തർഹി മുക്തോ ഭവിതുമ് അശക്ഷ്യത്| ");
INSERT INTO sanmal_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","ജലപഥേനാസ്മാകമ് ഇതോലിയാദേശം പ്രതി യാത്രായാം നിശ്ചിതായാം സത്യാം തേ യൂലിയനാമ്നോ മഹാരാജസ്യ സംഘാതാന്തർഗതസ്യ സേനാപതേഃ സമീപേ പൗലം തദന്യാൻ കതിനയജനാംശ്ച സമാർപയൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","വയമ് ആദ്രാമുത്തീയം പോതമേകമ് ആരുഹ്യ ആശിയാദേശസ്യ തടസമീപേന യാതും മതിം കൃത്വാ ലങ്ഗരമ് ഉത്ഥാപ്യ പോതമ് അമോചയാമ; മാകിദനിയാദേശസ്ഥഥിഷലനീകീനിവാസ്യാരിസ്താർഖനാമാ കശ്ചിദ് ജനോഽസ്മാഭിഃ സാർദ്ധമ് ആസീത്| ");
INSERT INTO sanmal_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","പരസ്മിൻ ദിവസേ ഽസ്മാഭിഃ സീദോന്നഗരേ പോതേ ലാഗിതേ തത്ര യൂലിയഃ സേനാപതിഃ പൗലം പ്രതി സൗജന്യം പ്രദർഥ്യ സാന്ത്വനാർഥം ബന്ധുബാന്ധവാൻ ഉപയാതുമ് അനുജജ്ഞൗ| ");
INSERT INTO sanmal_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","തസ്മാത് പോതേ മോചിതേ സതി സമ്മുഖവായോഃ സമ്ഭവാദ് വയം കുപ്രോപദ്വീപസ്യ തീരസമീപേന ഗതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","കിലികിയായാഃ പാമ്ഫൂലിയായാശ്ച സമുദ്രസ്യ പാരം ഗത്വാ ലൂകിയാദേശാന്തർഗതം മുരാനഗരമ് ഉപാതിഷ്ഠാമ| ");
INSERT INTO sanmal_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","തത്സ്ഥാനാദ് ഇതാലിയാദേശം ഗച്ഛതി യഃ സികന്ദരിയാനഗരസ്യ പോതസ്തം തത്ര പ്രാപ്യ ശതസേനാപതിസ്തം പോതമ് അസ്മാൻ ആരോഹയത്| ");
INSERT INTO sanmal_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","തതഃ പരം ബഹൂനി ദിനാനി ശനൈഃ ശനൈഃ ർഗത്വാ ക്നീദപാർശ്വോപസ്ഥ്തിेഃ പൂർവ്വം പ്രതികൂലേന പവനേന വയം സൽമോന്യാഃ സമ്മുഖമ് ഉപസ്ഥായ ക്രീത്യുപദ്വീപസ്യ തീരസമീപേന ഗതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","കഷ്ടേന തമുത്തീര്യ്യ ലാസേയാനഗരസ്യാധഃ സുന്ദരനാമകം ഖാതമ് ഉപാതിഷ്ഠാമ| ");
INSERT INTO sanmal_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","ഇത്ഥം ബഹുതിഥഃ കാലോ യാപിത ഉപവാസദിനഞ്ചാതീതം, തത്കാരണാത് നൗവർത്മനി ഭയങ്കരേ സതി പൗലോ വിനയേന കഥിതവാൻ, ");
INSERT INTO sanmal_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","ഹേ മഹേച്ഛാ അഹം നിശ്ചയം ജാനാമി യാത്രായാമസ്യാമ് അസ്മാകം ക്ലേശാ ബഹൂനാമപചയാശ്ച ഭവിഷ്യന്തി, തേ കേവലം പോതസാമഗ്ര്യോരിതി നഹി, കിന്ത്വസ്മാകം പ്രാണാനാമപി| ");
INSERT INTO sanmal_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","തദാ ശതസേനാപതിഃ പൗैेലോക്തവാക്യതോപി കർണധാരസ്യ പോതവണിജശ്ച വാക്യം ബഹുമംസ്ത| ");
INSERT INTO sanmal_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","തത് ഖാതം ശീതകാലേ വാസാർഹസ്ഥാനം ന തസ്മാദ് അവാചീപ്രതീചോർദിശോഃ ക്രീത്യാഃ ഫൈനീകിയഖാതം യാതും യദി ശക്നുവന്തസ്തർഹി തത്ര ശീതകാലം യാപയിതും പ്രായേണ സർവ്വേ മന്ത്രയാമാസുഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","തതഃ പരം ദക്ഷിണവായു ർമന്ദം വഹതീതി വിലോക്യ നിജാഭിപ്രായസ്യ സിദ്ധേഃ സുയോഗോ ഭവതീതി ബുദ്ധ്വാ പോതം മോചയിത്വാ ക്രീത്യുപദ്വീപസ്യ തീരസമീപേന ചലിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","കിന്ത്വൽപക്ഷണാത് പരമേവ ഉരക്ലുദോന്നാമാ പ്രതികൂലഃ പ്രചണ്ഡോ വായു ർവഹൻ പോതേഽലഗീത് ");
INSERT INTO sanmal_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","തസ്യാഭിമുഖം ഗന്തുമ് പോതസ്യാശക്തത്വാദ് വയം വായുനാ സ്വയം നീതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","അനന്തരം ക്ലൗദീനാമ്ന ഉപദ്വീപസ്യ കൂലസമീപേന പോതം ഗമയിത്വാ ബഹുനാ കഷ്ടേന ക്ഷുദ്രനാവമ് അരക്ഷാമ| ");
INSERT INTO sanmal_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","തേ താമാരുഹ്യ രജ്ജ്ചാ പോതസ്യാധോഭാഗമ് അബധ്നൻ തദനന്തരം ചേത് പോതോ സൈകതേ ലഗതീതി ഭയാദ് വാതവസനാന്യമോചയൻ തതഃ പോതോ വായുനാ ചാലിതഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","കിന്തു ക്രമശോ വായോഃ പ്രബലത്വാത് പോതോ ദോലായമാനോഽഭവത് പരസ്മിൻ ദിവസേ പോതസ്ഥാനി കതിപയാനി ദ്രവ്യാണി തോയേ നിക്ഷിപ്താനി| ");
INSERT INTO sanmal_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","തൃതീയദിവസേ വയം സ്വഹസ്തൈഃ പോതസജ്ജനദ്രവ്യാണി നിക്ഷിപ്തവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","തതോ ബഹുദിനാനി യാവത് സൂര്യ്യനക്ഷത്രാദീനി സമാച്ഛന്നാനി തതോ ഽതീവ വാത്യാഗമാദ് അസ്മാകം പ്രാണരക്ഷായാഃ കാപി പ്രത്യാശാ നാതിഷ്ഠത്| ");
INSERT INTO sanmal_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","ബഹുദിനേഷു ലോകൈരനാഹാരേണ യാപിതേഷു സർവ്വേഷാം സാക്ഷത് പൗലസ്തിഷ്ഠൻ അകഥയത്, ഹേ മഹേച്ഛാഃ ക്രീത്യുപദ്വീപാത് പോതം ന മോചയിതുമ് അഹം പൂർവ്വം യദ് അവദം തദ്ഗ്രഹണം യുഷ്മാകമ് ഉചിതമ് ആസീത് തഥാ കൃതേ യുഷ്മാകമ് ഏഷാ വിപദ് ഏഷോഽപചയശ്ച നാഘടിഷ്യേതാമ്| ");
INSERT INTO sanmal_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","കിന്തു സാമ്പ്രതം യുഷ്മാൻ വിനീയ ബ്രവീമ്യഹം, യൂയം ന ക്ഷുഭ്യത യുഷ്മാകമ് ഏകസ്യാപി പ്രാണിനോ ഹാനി ർന ഭവിഷ്യതി, കേവലസ്യ പോതസ്യ ഹാനി ർഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","യതോ യസ്യേശ്വരസ്യ ലോകോഽഹം യഞ്ചാഹം പരിചരാമി തദീയ ഏകോ ദൂതോ ഹ്യോ രാത്രൗ മമാന്തികേ തിഷ്ഠൻ കഥിതവാൻ, ");
INSERT INTO sanmal_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ഹേ പൗല മാ ഭൈഷീഃ കൈസരസ്യ സമ്മുഖേ ത്വയോപസ്ഥാതവ്യം; തവൈതാൻ സങ്ഗിനോ ലോകാൻ ഈശ്വരസ്തുഭ്യം ദത്തവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","അതഏവ ഹേ മഹേച്ഛാ യൂയം സ്ഥിരമനസോ ഭവത മഹ്യം യാ കഥാകഥി സാവശ്യം ഘടിഷ്യതേ മമൈതാദൃശീ വിശ്വാസ ഈശ്വരേ വിദ്യതേ, ");
INSERT INTO sanmal_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","കിന്തു കസ്യചിദ് ഉപദ്വീപസ്യോപരി പതിതവ്യമ് അസ്മാഭിഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","തതഃ പരമ് ആദ്രിയാസമുദ്രേ പോതസ്തഥൈവ ദോലായമാനഃ സൻ ഇതസ്തതോ ഗച്ഛൻ ചതുർദശദിവസസ്യ രാത്രേ ർദ്വിതീയപ്രഹരസമയേ കസ്യചിത് സ്ഥലസ്യ സമീപമുപതിഷ്ഠതീതി പോതീയലോകാ അന്വമന്യന്ത| ");
INSERT INTO sanmal_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","തതസ്തേ ജലം പരിമായ തത്ര വിംശതി ർവ്യാമാ ജലാനീതി ജ്ഞാതവന്തഃ| കിഞ്ചിദ്ദൂരം ഗത്വാ പുനരപി ജലം പരിമിതവന്തഃ| തത്ര പഞ്ചദശ വ്യാമാ ജലാനി ദൃഷ്ട്വാ ");
INSERT INTO sanmal_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","ചേത് പാഷാണേ ലഗതീതി ഭയാത് പോതസ്യ പശ്ചാദ്ഭാഗതശ്ചതുരോ ലങ്ഗരാൻ നിക്ഷിപ്യ ദിവാകരമ് അപേക്ഷ്യ സർവ്വേ സ്ഥിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","കിന്തു പോതീയലോകാഃ പോതാഗ്രഭാഗേ ലങ്ഗരനിക്ഷേപം ഛലം കൃത്വാ ജലധൗ ക്ഷുദ്രനാവമ് അവരോഹ്യ പലായിതുമ് അചേഷ്ടന്ത| ");
INSERT INTO sanmal_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","തതഃ പൗലഃ സേനാപതയേ സൈന്യഗണായ ച കഥിതവാൻ, ഏതേ യദി പോതമധ്യേ ന തിഷ്ഠന്തി തർഹി യുഷ്മാകം രക്ഷണം ന ശക്യം| ");
INSERT INTO sanmal_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","തദാ സേനാഗണോ രജ്ജൂൻ ഛിത്വാ നാവം ജലേ പതിതുമ് അദദാത്| ");
INSERT INTO sanmal_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","പ്രഭാതസമയേ പൗലഃ സർവ്വാൻ ജനാൻ ഭോജനാർഥം പ്രാർഥ്യ വ്യാഹരത്, അദ്യ ചതുർദശദിനാനി യാവദ് യൂയമ് അപേക്ഷമാനാ അനാഹാരാഃ കാലമ് അയാപയത കിമപി നാഭുംഗ്ധം| ");
INSERT INTO sanmal_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","അതോ വിനയേेഽഹം ഭക്ഷ്യം ഭുജ്യതാം തതോ യുഷ്മാകം മങ്ഗലം ഭവിഷ്യതി, യുഷ്മാകം കസ്യചിജ്ജനസ്യ ശിരസഃ കേശൈകോപി ന നംക്ഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","ഇതി വ്യാഹൃത്യ പൗലം പൂപം ഗൃഹീത്വേശ്വരം ധന്യം ഭാഷമാണസ്തം ഭംക്ത്വാ ഭോക്തുമ് ആരബ്ധവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","അനന്തരം സർവ്വേ ച സുസ്ഥിരാഃ സന്തഃ ഖാദ്യാനി പർപ്യഗൃഹ്ലൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","അസ്മാകം പോതേ ഷട്സപ്തത്യധികശതദ്വയലോകാ ആസൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","സർവ്വേഷു ലോകേഷു യഥേഷ്ടം ഭുക്തവത്സു പോതസ്ഥൻ ഗോധൂമാൻ ജലധൗ നിക്ഷിപ്യ തൈഃ പോതസ്യ ഭാരോ ലഘൂകൃതഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","ദിനേ ജാതേഽപി സ കോ ദേശ ഇതി തദാ ന പര്യ്യചീയത; കിന്തു തത്ര സമതടമ് ഏകം ഖാതം ദൃഷ്ട്വാ യദി ശക്നുമസ്തർഹി വയം തസ്യാഭ്യന്തരം പോതം ഗമയാമ ഇതി മതിം കൃത്വാ തേ ലങ്ഗരാൻ ഛിത്ത്വാ ജലധൗ ത്യക്തവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","തഥാ കർണബന്ധനം മോചയിത്വാ പ്രധാനം വാതവസനമ് ഉത്തോല്യ തീരസമീപം ഗതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","കിന്തു ദ്വയോഃ സമുദ്രയോഃ സങ്ഗമസ്ഥാനേ സൈകതോപരി പോതേ നിക്ഷിപ്തേ ഽഗ്രഭാഗേ ബാധിതേ പശ്ചാദ്ഭാഗേ പ്രബലതരങ്ഗോഽലഗത് തേന പോതോ ഭഗ്നഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","തസ്മാദ് ബന്ദയശ്ചേദ് ബാഹുഭിസ്തരന്തഃ പലായന്തേ ഇത്യാശങ്കയാ സേനാഗണസ്താൻ ഹന്തുമ് അമന്ത്രയത്; ");
INSERT INTO sanmal_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","കിന്തു ശതസേനാപതിഃ പൗലം രക്ഷിതും പ്രയത്നം കൃത്വാ താൻ തച്ചേഷ്ടായാ നിവർത്യ ഇത്യാദിഷ്ടവാൻ, യേ ബാഹുതരണം ജാനന്തി തേഽഗ്രേ പ്രോല്ലമ്പ്യ സമുദ്രേ പതിത്വാ ബാഹുഭിസ്തീർത്ത്വാ കൂലം യാന്തു| ");
INSERT INTO sanmal_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","അപരമ് അവശിഷ്ടാ ജനാഃ കാഷ്ഠം പോതീയം ദ്രവ്യം വാ യേന യത് പ്രാപ്യതേ തദവലമ്ബ്യ യാന്തു; ഇത്ഥം സർവ്വേ ഭൂമിം പ്രാപ്യ പ്രാണൈ ർജീവിതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","ഇത്ഥം സർവ്വേഷു രക്ഷാം പ്രാപ്തേഷു തത്രത്യോപദ്വീപസ്യ നാമ മിലീതേതി തേ ജ്ഞാതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","അസഭ്യലോകാ യഥേഷ്ടമ് അനുകമ്പാം കൃത്വാ വർത്തമാനവൃഷ്ടേഃ ശീതാച്ച വഹ്നിം പ്രജ്ജ്വാല്യാസ്മാകമ് ആതിഥ്യമ് അകുർവ്വൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","കിന്തു പൗല ഇന്ധനാനി സംഗൃഹ്യ യദാ തസ്മിൻ അഗ്രൗ നിരക്ഷിപത്, തദാ വഹ്നേഃ പ്രതാപാത് ഏകഃ കൃഷ്ണസർപോ നിർഗത്യ തസ്യ ഹസ്തേ ദ്രഷ്ടവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","തേഽസഭ്യലോകാസ്തസ്യ ഹസ്തേ സർപമ് അവലമ്ബമാനം ദൃഷ്ട്വാ പരസ്പരമ് ഉക്തവന്ത ഏഷ ജനോഽവശ്യം നരഹാ ഭവിഷ്യതി, യതോ യദ്യപി ജലധേ രക്ഷാം പ്രാപ്തവാൻ തഥാപി പ്രതിഫലദായക ഏനം ജീവിതും ന ദദാതി| ");
INSERT INTO sanmal_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","കിന്തു സ ഹസ്തം വിധുന്വൻ തം സർപമ് അഗ്നിമധ്യേ നിക്ഷിപ്യ കാമപി പീഡാം നാപ്തവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","തതോ വിഷജ്വാലയാ ഏതസ്യ ശരീരം സ്ഫീതം ഭവിഷ്യതി യദ്വാ ഹഠാദയം പ്രാണാൻ ത്യക്ഷ്യതീതി നിശ്ചിത്യ ലോകാ ബഹുക്ഷണാനി യാവത് തദ് ദ്രഷ്ടും സ്ഥിതവന്തഃ കിന്തു തസ്യ കസ്യാശ്ചിദ് വിപദോഽഘടനാത് തേ തദ്വിപരീതം വിജ്ഞായ ഭാഷിതവന്ത ഏഷ കശ്ചിദ് ദേവോ ഭവേത്| ");
INSERT INTO sanmal_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","പുബ്ലിയനാമാ ജന ഏകസ്തസ്യോപദ്വീപസ്യാധിപതിരാസീത് തത്ര തസ്യ ഭൂമ്യാദി ച സ്ഥിതം| സ ജനോഽസ്മാൻ നിജഗൃഹം നീത്വാ സൗജന്യം പ്രകാശ്യ ദിനത്രയം യാവദ് അസ്മാകം ആതിഥ്യമ് അകരോത്| ");
INSERT INTO sanmal_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","തദാ തസ്യ പുബ്ലിയസ്യ പിതാ ജ്വരാതിസാരേണ പീഡ്യമാനഃ സൻ ശയ്യായാമ് ആസീത്; തതഃ പൗലസ്തസ്യ സമീപം ഗത്വാ പ്രാർഥനാം കൃത്വാ തസ്യ ഗാത്രേ ഹസ്തം സമർപ്യ തം സ്വസ്ഥം കൃതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","ഇത്ഥം ഭൂതേ തദ്വീപനിവാസിന ഇതരേപി രോഗിലോകാ ആഗത്യ നിരാമയാ അഭവൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","തസ്മാത്തേഽസ്മാകമ് അതീവ സത്കാരം കൃതവന്തഃ, വിശേഷതഃ പ്രസ്ഥാനസമയേ പ്രയോജനീയാനി നാനദ്രവ്യാണി ദത്തവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","ഇത്ഥം തത്ര ത്രിഷു മാസേഷു ഗതേഷു യസ്യ ചിഹ്നം ദിയസ്കൂരീ താദൃശ ഏകഃ സികന്ദരീയനഗരസ്യ പോതഃ ശീതകാലം യാപയൻ തസ്മിൻ ഉപദ്വീപേ ഽതിഷ്ഠത് തമേവ പോതം വയമ് ആരുഹ്യ യാത്രാമ് അകുർമ്മ| ");
INSERT INTO sanmal_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","തതഃ പ്രഥമതഃ സുരാകൂസനഗരമ് ഉപസ്ഥായ തത്ര ത്രീണി ദിനാനി സ്ഥിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","തസ്മാദ് ആവൃത്യ രീഗിയനഗരമ് ഉപസ്ഥിതാഃ ദിനൈകസ്മാത് പരം ദക്ഷിണവയൗ സാനുകൂല്യേ സതി പരസ്മിൻ ദിവസേ പതിയലീനഗരമ് ഉപാതിഷ്ഠാമ| ");
INSERT INTO sanmal_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","തതോഽസ്മാസു തത്രത്യം ഭ്രാതൃഗണം പ്രാപ്തേഷു തേ സ്വൈഃ സാർദ്ധമ് അസ്മാൻ സപ്ത ദിനാനി സ്ഥാപയിതുമ് അയതന്ത, ഇത്ഥം വയം രോമാനഗരമ് പ്രത്യഗച്ഛാമ| ");
INSERT INTO sanmal_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","തസ്മാത് തത്രത്യാഃ ഭ്രാതരോഽസ്മാകമ് ആഗമനവാർത്താം ശ്രുത്വാ ആപ്പിയഫരം ത്രിഷ്ടാവർണീഞ്ച യാവദ് അഗ്രേസരാഃ സന്തോസ്മാൻ സാക്ഷാത് കർത്തുമ് ആഗമൻ; തേഷാം ദർശനാത് പൗല ഈശ്വരം ധന്യം വദൻ ആശ്വാസമ് ആപ്തവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","അസ്മാസു രോമാനഗരം ഗതേഷു ശതസേനാപതിഃ സർവ്വാൻ ബന്ദീൻ പ്രധാനസേനാപതേഃ സമീപേ സമാർപയത് കിന്തു പൗലായ സ്വരക്ഷകപദാതിനാ സഹ പൃഥഗ് വസ്തുമ് അനുമതിം ദത്തവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","ദിനത്രയാത് പരം പൗലസ്തദ്ദേശസ്ഥാൻ പ്രധാനയിഹൂദിന ആഹൂതവാൻ തതസ്തേഷു സമുപസ്ഥിതേഷു സ കഥിതവാൻ, ഹേ ഭ്രാതൃഗണ നിജലോകാനാം പൂർവ്വപുരുഷാണാം വാ രീതേ ർവിപരീതം കിഞ്ചന കർമ്മാഹം നാകരവം തഥാപി യിരൂശാലമനിവാസിനോ ലോകാ മാം ബന്ദിം കൃത്വാ രോമിലോകാനാം ഹസ്തേഷു സമർപിതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","രോമിലോകാ വിചാര്യ്യ മമ പ്രാണഹനനാർഹം കിമപി കാരണം ന പ്രാപ്യ മാം മോചയിതുമ് ഐച്ഛൻ; ");
INSERT INTO sanmal_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","കിന്തു യിഹൂദിലോകാനാമ് ആപത്ത്യാ മയാ കൈസരരാജസ്യ സമീപേ വിചാരസ്യ പ്രാർഥനാ കർത്തവ്യാ ജാതാ നോചേത് നിജദേശീയലോകാൻ പ്രതി മമ കോപ്യഭിയോഗോ നാസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","ഏതത്കാരണാദ് അഹം യുഷ്മാൻ ദ്രഷ്ടും സംലപിതുഞ്ചാഹൂയമ് ഇസ്രായേല്വശീയാനാം പ്രത്യാശാഹേതോഹമ് ഏതേന ശുങ്ഖലേന ബദ്ധോഽഭവമ്| ");
INSERT INTO sanmal_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","തദാ തേ തമ് അവാദിഷുഃ, യിഹൂദീയദേശാദ് വയം ത്വാമധി കിമപി പത്രം ന പ്രാപ്താ യേ ഭ്രാതരഃ സമായാതാസ്തേഷാം കോപി തവ കാമപി വാർത്താം നാവദത് അഭദ്രമപി നാകഥയച്ച| ");
INSERT INTO sanmal_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","തവ മതം കിമിതി വയം ത്വത്തഃ ശ്രോതുമിച്ഛാമഃ| യദ് ഇദം നവീനം മതമുത്ഥിതം തത് സർവ്വത്ര സർവ്വേഷാം നികടേ നിന്ദിതം ജാതമ ഇതി വയം ജാനീമഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","തൈസ്തദർഥമ് ഏകസ്മിൻ ദിനേ നിരൂപിതേ തസ്മിൻ ദിനേ ബഹവ ഏകത്ര മിലിത്വാ പൗലസ്യ വാസഗൃഹമ് ആഗച്ഛൻ തസ്മാത് പൗല ആ പ്രാതഃകാലാത് സന്ധ്യാകാലം യാവൻ മൂസാവ്യവസ്ഥാഗ്രന്ഥാദ് ഭവിഷ്യദ്വാദിനാം ഗ്രന്ഥേഭ്യശ്ച യീശോഃ കഥാമ് ഉത്ഥാപ്യ ഈശ്വരസ്യ രാജ്യേ പ്രമാണം ദത്വാ തേഷാം പ്രവൃത്തിം ജനയിതും ചേഷ്ടിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","കേചിത്തു തസ്യ കഥാം പ്രത്യായൻ കേചിത്തു ന പ്രത്യായൻ; ");
INSERT INTO sanmal_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","ഏതത്കാരണാത് തേഷാം പരസ്പരമ് അനൈക്യാത് സർവ്വേ ചലിതവന്തഃ; തഥാപി പൗല ഏതാം കഥാമേകാം കഥിതവാൻ പവിത്ര ആത്മാ യിശയിയസ്യ ഭവിഷ്യദ്വക്തു ർവദനാദ് അസ്മാകം പിതൃപുരുഷേഭ്യ ഏതാം കഥാം ഭദ്രം കഥയാമാസ, യഥാ, ");
INSERT INTO sanmal_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","\"ഉപഗത്യ ജനാനേതാൻ ത്വം ഭാഷസ്വ വചസ്ത്വിദം| കർണൈഃ ശ്രോഷ്യഥ യൂയം ഹി കിന്തു യൂയം ന ഭോത്സ്യഥ| നേത്രൈ ർദ്രക്ഷ്യഥ യൂയഞ്ച ജ്ഞാതും യൂയം ന ശക്ഷ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","തേ മാനുഷാ യഥാ നേത്രൈഃ പരിപശ്യന്തി നൈവ ഹി| കർണൈഃ ര്യഥാ ന ശൃണ്വന്തി ബുധ്യന്തേ ന ച മാനസൈഃ| വ്യാവർത്തയത്സു ചിത്താനി കാലേ കുത്രാപി തേഷു വൈ| മത്തസ്തേ മനുജാഃ സ്വസ്ഥാ യഥാ നൈവ ഭവന്തി ച| തഥാ തേഷാം മനുഷ്യാണാം സന്തി സ്ഥൂലാ ഹി ബുദ്ധയഃ| ബധിരീഭൂതകർണാശ്ച ജാതാശ്ച മുദ്രിതാ ദൃശഃ|| ");
INSERT INTO sanmal_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","അത ഈശ്വരാദ് യത് പരിത്രാണം തസ്യ വാർത്താ ഭിന്നദേശീയാനാം സമീപം പ്രേഷിതാ തഏവ താം ഗ്രഹീഷ്യന്തീതി യൂയം ജാനീത| ");
INSERT INTO sanmal_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","ഏതാദൃശ്യാം കഥായാം കഥിതായാം സത്യാം യിഹൂദിനഃ പരസ്പരം ബഹുവിചാരം കുർവ്വന്തോ ഗതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","ഇത്ഥം പൗലഃ സമ്പൂർണം വത്സരദ്വയം യാവദ് ഭാടകീയേ വാസഗൃഹേ വസൻ യേ ലോകാസ്തസ്യ സന്നിധിമ് ആഗച്ഛന്തി താൻ സർവ്വാനേവ പരിഗൃഹ്ലൻ, ");
INSERT INTO sanmal_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","നിർവിഘ്നമ് അതിശയനിഃക്ഷോഭമ് ഈശ്വരീയരാജത്വസ്യ കഥാം പ്രചാരയൻ പ്രഭൗ യീശൗ ഖ്രീഷ്ടേ കഥാഃ സമുപാദിശത്| ഇതി||");
INSERT INTO sanmal_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","ഈശ്വരോ നിജപുത്രമധി യം സുസംവാദം ഭവിഷ്യദ്വാദിഭി ർധർമ്മഗ്രന്ഥേ പ്രതിശ്രുതവാൻ തം സുസംവാദം പ്രചാരയിതും പൃഥക്കൃത ആഹൂതഃ പ്രേരിതശ്ച പ്രഭോ ര്യീശുഖ്രീഷ്ടസ്യ സേവകോ യഃ പൗലഃ ");
INSERT INTO sanmal_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","സ രോമാനഗരസ്ഥാൻ ഈശ്വരപ്രിയാൻ ആഹൂതാംശ്ച പവിത്രലോകാൻ പ്രതി പത്രം ലിഖതി| ");
INSERT INTO sanmal_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","അസ്മാകം സ പ്രഭു ര്യീശുഃ ഖ്രീഷ്ടഃ ശാരീരികസമ്ബന്ധേന ദായൂദോ വംശോദ്ഭവഃ ");
INSERT INTO sanmal_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","പവിത്രസ്യാത്മനഃ സമ്ബന്ധേന ചേശ്വരസ്യ പ്രഭാവവാൻ പുത്ര ഇതി ശ്മശാനാത് തസ്യോത്ഥാനേന പ്രതിപന്നം| ");
INSERT INTO sanmal_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","അപരം യേഷാം മധ്യേ യീശുനാ ഖ്രീഷ്ടേന യൂയമപ്യാഹൂതാസ്തേ ഽന്യദേശീയലോകാസ്തസ്യ നാമ്നി വിശ്വസ്യ നിദേശഗ്രാഹിണോ യഥാ ഭവന്തി ");
INSERT INTO sanmal_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","തദഭിപ്രായേണ വയം തസ്മാദ് അനുഗ്രഹം പ്രേരിതത്വപദഞ്ച പ്രാപ്താഃ| ");
INSERT INTO sanmal_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","താതേനാസ്മാകമ് ഈശ്വരേണ പ്രഭുണാ യീശുഖ്രീഷ്ടേന ച യുഷ്മഭ്യമ് അനുഗ്രഹഃ ശാന്തിശ്ച പ്രദീയേതാം| ");
INSERT INTO sanmal_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","പ്രഥമതഃ സർവ്വസ്മിൻ ജഗതി യുഷ്മാകം വിശ്വാസസ്യ പ്രകാശിതത്വാദ് അഹം യുഷ്മാകം സർവ്വേഷാം നിമിത്തം യീശുഖ്രീഷ്ടസ്യ നാമ ഗൃഹ്ലൻ ഈശ്വരസ്യ ധന്യവാദം കരോമി| ");
INSERT INTO sanmal_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","അപരമ് ഈശ്വരസ്യ പ്രസാദാദ് ബഹുകാലാത് പരം സാമ്പ്രതം യുഷ്മാകം സമീപം യാതും കഥമപി യത് സുയോഗം പ്രാപ്നോമി, ഏതദർഥം നിരന്തരം നാമാന്യുച്ചാരയൻ നിജാസു സർവ്വപ്രാർഥനാസു സർവ്വദാ നിവേദയാമി, ");
INSERT INTO sanmal_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ഏതസ്മിൻ യമഹം തത്പുത്രീയസുസംവാദപ്രചാരണേന മനസാ പരിചരാമി സ ഈശ്വരോ മമ സാക്ഷീ വിദ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","യതോ യുഷ്മാകം മമ ച വിശ്വാസേന വയമ് ഉഭയേ യഥാ ശാന്തിയുക്താ ഭവാമ ഇതി കാരണാദ് ");
INSERT INTO sanmal_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","യുഷ്മാകം സ്ഥൈര്യ്യകരണാർഥം യുഷ്മഭ്യം കിഞ്ചിത്പരമാർഥദാനദാനായ യുഷ്മാൻ സാക്ഷാത് കർത്തും മദീയാ വാഞ്ഛാ| ");
INSERT INTO sanmal_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","ഹേ ഭ്രാതൃഗണ ഭിന്നദേശീയലോകാനാം മധ്യേ യദ്വത് തദ്വദ് യുഷ്മാകം മധ്യേപി യഥാ ഫലം ഭുഞ്ജേ തദഭിപ്രായേണ മുഹുർമുഹു ര്യുഷ്മാകം സമീപം ഗന്തുമ് ഉദ്യതോഽഹം കിന്തു യാവദ് അദ്യ തസ്മിൻ ഗമനേ മമ വിഘ്നോ ജാത ഇതി യൂയം യദ് അജ്ഞാതാസ്തിഷ്ഠഥ തദഹമ് ഉചിതം ന ബുധ്യേ| ");
INSERT INTO sanmal_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","അഹം സഭ്യാസഭ്യാനാം വിദ്വദവിദ്വതാഞ്ച സർവ്വേഷാമ് ഋണീ വിദ്യേ| ");
INSERT INTO sanmal_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","അതഏവ രോമാനിവാസിനാം യുഷ്മാകം സമീപേഽപി യഥാശക്തി സുസംവാദം പ്രചാരയിതുമ് അഹമ് ഉദ്യതോസ്മി| ");
INSERT INTO sanmal_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","യതഃ ഖ്രീഷ്ടസ്യ സുസംവാദോ മമ ലജ്ജാസ്പദം നഹി സ ഈശ്വരസ്യ ശക്തിസ്വരൂപഃ സൻ ആ യിഹൂദീയേഭ്യോ ഽന്യജാതീയാൻ യാവത് സർവ്വജാതീയാനാം മധ്യേ യഃ കശ്ചിദ് തത്ര വിശ്വസിതി തസ്യൈവ ത്രാണം ജനയതി| ");
INSERT INTO sanmal_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","യതഃ പ്രത്യയസ്യ സമപരിമാണമ് ഈശ്വരദത്തം പുണ്യം തത്സുസംവാദേ പ്രകാശതേ| തദധി ധർമ്മപുസ്തകേപി ലിഖിതമിദം \"പുണ്യവാൻ ജനോ വിശ്വാസേന ജീവിഷ്യതി\"| ");
INSERT INTO sanmal_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","അതഏവ യേ മാനവാഃ പാപകർമ്മണാ സത്യതാം രുന്ധന്തി തേഷാം സർവ്വസ്യ ദുരാചരണസ്യാധർമ്മസ്യ ച വിരുദ്ധം സ്വർഗാദ് ഈശ്വരസ്യ കോപഃ പ്രകാശതേ| ");
INSERT INTO sanmal_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","യത ഈശ്വരമധി യദ്യദ് ജ്ഞേയം തദ് ഈശ്വരഃ സ്വയം താൻ പ്രതി പ്രകാശിതവാൻ തസ്മാത് തേഷാമ് അഗോചരം നഹി| ");
INSERT INTO sanmal_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","ഫലതസ്തസ്യാനന്തശക്തീശ്വരത്വാദീന്യദൃശ്യാന്യപി സൃഷ്ടികാലമ് ആരഭ്യ കർമ്മസു പ്രകാശമാനാനി ദൃശ്യന്തേ തസ്മാത് തേഷാം ദോഷപ്രക്ഷാലനസ്യ പന്ഥാ നാസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","അപരമ് ഈശ്വരം ജ്ഞാത്വാപി തേ തമ് ഈശ്വരജ്ഞാനേന നാദ്രിയന്ത കൃതജ്ഞാ വാ ന ജാതാഃ; തസ്മാത് തേഷാം സർവ്വേ തർകാ വിഫലീഭൂതാഃ, അപരഞ്ച തേഷാം വിവേകശൂന്യാനി മനാംസി തിമിരേ മഗ്നാനി| ");
INSERT INTO sanmal_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","തേ സ്വാൻ ജ്ഞാനിനോ ജ്ഞാത്വാ ജ്ഞാനഹീനാ അഭവൻ ");
INSERT INTO sanmal_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","അനശ്വരസ്യേശ്വരസ്യ ഗൗരവം വിഹായ നശ്വരമനുഷ്യപശുപക്ഷ്യുരോഗാമിപ്രഭൃതേരാകൃതിവിശിഷ്ടപ്രതിമാസ്തൈരാശ്രിതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","ഇത്ഥം ത ഈശ്വരസ്യ സത്യതാം വിഹായ മൃഷാമതമ് ആശ്രിതവന്തഃ സച്ചിദാനന്ദം സൃഷ്ടികർത്താരം ത്യക്ത്വാ സൃഷ്ടവസ്തുനഃ പൂജാം സേവാഞ്ച കൃതവന്തഃ; ");
INSERT INTO sanmal_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","ഇതി ഹേതോരീശ്വരസ്താൻ കുക്രിയായാം സമർപ്യ നിജനിജകുചിന്താഭിലാഷാഭ്യാം സ്വം സ്വം ശരീരം പരസ്പരമ് അപമാനിതം കർത്തുമ് അദദാത്| ");
INSERT INTO sanmal_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","ഈശ്വരേണ തേഷു ക്വഭിലാഷേ സമർപിതേഷു തേഷാം യോഷിതഃ സ്വാഭാവികാചരണമ് അപഹായ വിപരീതകൃത്യേ പ്രാവർത്തന്ത; ");
INSERT INTO sanmal_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","തഥാ പുരുഷാ അപി സ്വാഭാവികയോഷിത്സങ്ഗമം വിഹായ പരസ്പരം കാമകൃശാനുനാ ദഗ്ധാഃ സന്തഃ പുമാംസഃ പുംഭിഃ സാകം കുകൃത്യേ സമാസജ്യ നിജനിജഭ്രാന്തേഃ സമുചിതം ഫലമ് അലഭന്ത| ");
INSERT INTO sanmal_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","തേ സ്വേഷാം മനഃസ്വീശ്വരായ സ്ഥാനം ദാതുമ് അനിച്ഛുകാസ്തതോ ഹേതോരീശ്വരസ്താൻ പ്രതി ദുഷ്ടമനസ്കത്വമ് അവിഹിതക്രിയത്വഞ്ച ദത്തവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","അതഏവ തേ സർവ്വേ ഽന്യായോ വ്യഭിചാരോ ദുഷ്ടത്വം ലോഭോ ജിഘാംസാ ഈർഷ്യാ വധോ വിവാദശ്ചാതുരീ കുമതിരിത്യാദിഭി ർദുഷ്കർമ്മഭിഃ പരിപൂർണാഃ സന്തഃ ");
INSERT INTO sanmal_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","കർണേജപാ അപവാദിന ഈശ്വരദ്വേഷകാ ഹിംസകാ അഹങ്കാരിണ ആത്മശ്ലാഘിനഃ കുകർമ്മോത്പാദകാഃ പിത്രോരാജ്ഞാലങ്ഘകാ ");
INSERT INTO sanmal_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","അവിചാരകാ നിയമലങ്ഘിനഃ സ്നേഹരഹിതാ അതിദ്വേഷിണോ നിർദയാശ്ച ജാതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","യേ ജനാ ഏതാദൃശം കർമ്മ കുർവ്വന്തി തഏവ മൃതിയോഗ്യാ ഈശ്വരസ്യ വിചാരമീദൃശം ജ്ഞാത്വാപി ത ഏതാദൃശം കർമ്മ സ്വയം കുർവ്വന്തി കേവലമിതി നഹി കിന്തു താദൃശകർമ്മകാരിഷു ലോകേഷ്വപി പ്രീയന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","ഹേ പരദൂഷക മനുഷ്യ യഃ കശ്ചന ത്വം ഭവസി തവോത്തരദാനായ പന്ഥാ നാസ്തി യതോ യസ്മാത് കർമ്മണഃ പരസ്ത്വയാ ദൂഷ്യതേ തസ്മാത് ത്വമപി ദൂഷ്യസേ, യതസ്തം ദൂഷയന്നപി ത്വം തദ്വദ് ആചരസി| ");
INSERT INTO sanmal_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","കിന്ത്വേതാദൃഗാചാരിഭ്യോ യം ദണ്ഡമ് ഈശ്വരോ നിശ്ചിനോതി സ യഥാർഥ ഇതി വയം ജാനീമഃ| ");
INSERT INTO sanmal_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","അതഏവ ഹേ മാനുഷ ത്വം യാദൃഗാചാരിണോ ദൂഷയസി സ്വയം യദി താദൃഗാചരസി തർഹി ത്വമ് ഈശ്വരദണ്ഡാത് പലായിതും ശക്ഷ്യസീതി കിം ബുധ്യസേ? ");
INSERT INTO sanmal_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","അപരം തവ മനസഃ പരിവർത്തനം കർത്തുമ് ഇശ്വരസ്യാനുഗ്രഹോ ഭവതി തന്ന ബുദ്ധ്വാ ത്വം കിം തദീയാനുഗ്രഹക്ഷമാചിരസഹിഷ്ണുത്വനിധിം തുച്ഛീകരോഷി? ");
INSERT INTO sanmal_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","തഥാ സ്വാന്തഃകരണസ്യ കഠോരത്വാത് ഖേദരാഹിത്യാച്ചേശ്വരസ്യ ന്യായ്യവിചാരപ്രകാശനസ്യ ക്രോധസ്യ ച ദിനം യാവത് കിം സ്വാർഥം കോപം സഞ്ചിനോഷി? ");
INSERT INTO sanmal_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","കിന്തു സ ഏകൈകമനുജായ തത്കർമ്മാനുസാരേണ പ്രതിഫലം ദാസ്യതി; ");
INSERT INTO sanmal_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","വസ്തുതസ്തു യേ ജനാ ധൈര്യ്യം ധൃത്വാ സത്കർമ്മ കുർവ്വന്തോ മഹിമാ സത്കാരോഽമരത്വഞ്ചൈതാനി മൃഗയന്തേ തേഭ്യോഽനന്തായു ർദാസ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","അപരം യേ ജനാഃ സത്യധർമ്മമ് അഗൃഹീത്വാ വിപരീതധർമ്മമ് ഗൃഹ്ലന്തി താദൃശാ വിരോധിജനാഃ കോപം ക്രോധഞ്ച ഭോക്ഷ്യന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","ആ യിഹൂദിനോഽന്യദേശിനഃ പര്യ്യന്തം യാവന്തഃ കുകർമ്മകാരിണഃ പ്രാണിനഃ സന്തി തേ സർവ്വേ ദുഃഖം യാതനാഞ്ച ഗമിഷ്യന്തി; ");
INSERT INTO sanmal_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","കിന്തു ആ യിഹൂദിനോ ഭിന്നദേശിപര്യ്യന്താ യാവന്തഃ സത്കർമ്മകാരിണോ ലോകാഃ സന്തി താൻ പ്രതി മഹിമാ സത്കാരഃ ശാന്തിശ്ച ഭവിഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","ഈശ്വരസ്യ വിചാരേ പക്ഷപാതോ നാസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","അലബ്ധവ്യവസ്ഥാശാസ്ത്രൈ ര്യൈഃ പാപാനി കൃതാനി വ്യവസ്ഥാശാസ്ത്രാലബ്ധത്വാനുരൂപസ്തേഷാം വിനാശോ ഭവിഷ്യതി; കിന്തു ലബ്ധവ്യവസ്ഥാശാസ്ത്രാ യേ പാപാന്യകുർവ്വൻ വ്യവസ്ഥാനുസാരാദേവ തേഷാം വിചാരോ ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","വ്യവസ്ഥാശ്രോതാര ഈശ്വരസ്യ സമീപേ നിഷ്പാപാ ഭവിഷ്യന്തീതി നഹി കിന്തു വ്യവസ്ഥാചാരിണ ഏവ സപുണ്യാ ഭവിഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","യതോ ഽലബ്ധവ്യവസ്ഥാശാസ്ത്രാ ഭിന്നദേശീയലോകാ യദി സ്വഭാവതോ വ്യവസ്ഥാനുരൂപാൻ ആചാരാൻ കുർവ്വന്തി തർഹ്യലബ്ധശാസ്ത്രാഃ സന്തോഽപി തേ സ്വേഷാം വ്യവസ്ഥാശാസ്ത്രമിവ സ്വയമേവ ഭവന്തി| ");
INSERT INTO sanmal_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","തേഷാം മനസി സാക്ഷിസ്വരൂപേ സതി തേഷാം വിതർകേഷു ച കദാ താൻ ദോഷിണഃ കദാ വാ നിർദോഷാൻ കൃതവത്സു തേ സ്വാന്തർലിഖിതസ്യ വ്യവസ്ഥാശാസ്ത്രസ്യ പ്രമാണം സ്വയമേവ ദദതി| ");
INSERT INTO sanmal_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","യസ്മിൻ ദിനേ മയാ പ്രകാശിതസ്യ സുസംവാദസ്യാനുസാരാദ് ഈശ്വരോ യീശുഖ്രീഷ്ടേന മാനുഷാണാമ് അന്തഃകരണാനാം ഗൂഢാഭിപ്രായാൻ ധൃത്വാ വിചാരയിഷ്യതി തസ്മിൻ വിചാരദിനേ തത് പ്രകാശിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","പശ്യ ത്വം സ്വയം യിഹൂദീതി വിഖ്യാതോ വ്യവസ്ഥോപരി വിശ്വാസം കരോഷി, ");
INSERT INTO sanmal_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ഈശ്വരമുദ്ദിശ്യ സ്വം ശ്ലാഘസേ, തഥാ വ്യവസ്ഥയാ ശിക്ഷിതോ ഭൂത്വാ തസ്യാഭിമതം ജാനാസി, സർവ്വാസാം കഥാനാം സാരം വിവിംക്ഷേ, ");
INSERT INTO sanmal_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","അപരം ജ്ഞാനസ്യ സത്യതായാശ്ചാകരസ്വരൂപം ശാസ്ത്രം മമ സമീപേ വിദ്യത അതോ ഽന്ധലോകാനാം മാർഗദർശയിതാ ");
INSERT INTO sanmal_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","തിമിരസ്ഥിതലോകാനാം മധ്യേ ദീപ്തിസ്വരൂപോഽജ്ഞാനലോകേഭ്യോ ജ്ഞാനദാതാ ശിശൂനാം ശിക്ഷയിതാഹമേവേതി മന്യസേ| ");
INSERT INTO sanmal_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","പരാൻ ശിക്ഷയൻ സ്വയം സ്വം കിം ന ശിക്ഷയസി? വസ്തുതശ്ചൗര്യ്യനിഷേധവ്യവസ്ഥാം പ്രചാരയൻ ത്വം കിം സ്വയമേവ ചോരയസി? ");
INSERT INTO sanmal_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","തഥാ പരദാരഗമനം പ്രതിഷേധൻ സ്വയം കിം പരദാരാൻ ഗച്ഛസി? തഥാ ത്വം സ്വയം പ്രതിമാദ്വേഷീ സൻ കിം മന്ദിരസ്യ ദ്രവ്യാണി ഹരസി? ");
INSERT INTO sanmal_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","യസ്ത്വം വ്യവസ്ഥാം ശ്ലാഘസേ സ ത്വം കിം വ്യവസ്ഥാമ് അവമത്യ നേശ്വരം സമ്മന്യസേ? ");
INSERT INTO sanmal_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","ശാസ്ത്രേ യഥാ ലിഖതി \"ഭിന്നദേശിനാം സമീപേ യുഷ്മാകം ദോഷാദ് ഈശ്വരസ്യ നാമ്നോ നിന്ദാ ഭവതി| \" ");
INSERT INTO sanmal_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","യദി വ്യവസ്ഥാം പാലയസി തർഹി തവ ത്വക്ഛേദക്രിയാ സഫലാ ഭവതി; യതി വ്യവസ്ഥാം ലങ്ഘസേ തർഹി തവ ത്വക്ഛേദോഽത്വക്ഛേദോ ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","യതോ വ്യവസ്ഥാശാസ്ത്രാദിഷ്ടധർമ്മകർമ്മാചാരീ പുമാൻ അത്വക്ഛേദീ സന്നപി കിം ത്വക്ഛേദിനാം മധ്യേ ന ഗണയിഷ്യതേ? ");
INSERT INTO sanmal_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","കിന്തു ലബ്ധശാസ്ത്രശ്ഛിന്നത്വക് ച ത്വം യദി വ്യവസ്ഥാലങ്ഘനം കരോഷി തർഹി വ്യവസ്ഥാപാലകാഃ സ്വാഭാവികാച്ഛിന്നത്വചോ ലോകാസ്ത്വാം കിം ന ദൂഷയിഷ്യന്തി? ");
INSERT INTO sanmal_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","തസ്മാദ് യോ ബാഹ്യേ യിഹൂദീ സ യിഹൂദീ നഹി തഥാങ്ഗസ്യ യസ്ത്വക്ഛേദഃ സ ത്വക്ഛേദോ നഹി; ");
INSERT INTO sanmal_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","കിന്തു യോ ജന ആന്തരികോ യിഹൂദീ സ ഏവ യിഹൂദീ അപരഞ്ച കേവലലിഖിതയാ വ്യവസ്ഥയാ ന കിന്തു മാനസികോ യസ്ത്വക്ഛേദോ യസ്യ ച പ്രശംസാ മനുഷ്യേഭ്യോ ന ഭൂത്വാ ഈശ്വരാദ് ഭവതി സ ഏവ ത്വക്ഛേദഃ| ");
INSERT INTO sanmal_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","അപരഞ്ച യിഹൂദിനഃ കിം ശ്രേഷ്ഠത്വം? തഥാ ത്വക്ഛേദസ്യ വാ കിം ഫലം? ");
INSERT INTO sanmal_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","സർവ്വഥാ ബഹൂനി ഫലാനി സന്തി, വിശേഷത ഈശ്വരസ്യ ശാസ്ത്രം തേഭ്യോഽദീയത| ");
INSERT INTO sanmal_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","കൈശ്ചിദ് അവിശ്വസനേ കൃതേ തേഷാമ് അവിശ്വസനാത് കിമ് ഈശ്വരസ്യ വിശ്വാസ്യതായാ ഹാനിരുത്പത്സ്യതേ? ");
INSERT INTO sanmal_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","കേനാപി പ്രകാരേണ നഹി| യദ്യപി സർവ്വേ മനുഷ്യാ മിഥ്യാവാദിനസ്തഥാപീശ്വരഃ സത്യവാദീ| ശാസ്ത്രേ യഥാ ലിഖിതമാസ്തേ, അതസ്ത്വന്തു സ്വവാക്യേന നിർദ്ദോഷോ ഹി ഭവിഷ്യസി| വിചാരേ ചൈവ നിഷ്പാപോ ഭവിഷ്യസി ന സംശയഃ| ");
INSERT INTO sanmal_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","അസ്മാകമ് അന്യായേന യദീശ്വരസ്യ ന്യായഃ പ്രകാശതേ തർഹി കിം വദിഷ്യാമഃ? അഹം മാനുഷാണാം കഥാമിവ കഥാം കഥയാമി, ഈശ്വരഃ സമുചിതം ദണ്ഡം ദത്ത്വാ കിമ് അന്യായീ ഭവിഷ്യതി? ");
INSERT INTO sanmal_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","ഇത്ഥം ന ഭവതു, തഥാ സതീശ്വരഃ കഥം ജഗതോ വിചാരയിതാ ഭവിഷ്യതി? ");
INSERT INTO sanmal_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","മമ മിഥ്യാവാക്യവദനാദ് യദീശ്വരസ്യ സത്യത്വേന തസ്യ മഹിമാ വർദ്ധതേ തർഹി കസ്മാദഹം വിചാരേഽപരാധിത്വേന ഗണ്യോ ഭവാമി? ");
INSERT INTO sanmal_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","മങ്ഗലാർഥം പാപമപി കരണീയമിതി വാക്യം ത്വയാ കുതോ നോച്യതേ? കിന്തു യൈരുച്യതേ തേ നിതാന്തം ദണ്ഡസ്യ പാത്രാണി ഭവന്തി; തഥാപി തദ്വാക്യമ് അസ്മാഭിരപ്യുച്യത ഇത്യസ്മാകം ഗ്ലാനിം കുർവ്വന്തഃ കിയന്തോ ലോകാ വദന്തി| ");
INSERT INTO sanmal_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","അന്യലോകേഭ്യോ വയം കിം ശ്രേഷ്ഠാഃ? കദാചന നഹി യതോ യിഹൂദിനോ ഽന്യദേശിനശ്ച സർവ്വഏവ പാപസ്യായത്താ ഇത്യസ്യ പ്രമാണം വയം പൂർവ്വമ് അദദാമ| ");
INSERT INTO sanmal_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","ലിപി ര്യഥാസ്തേ, നൈകോപി ധാർമ്മികോ ജനഃ| ");
INSERT INTO sanmal_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","തഥാ ജ്ഞാനീശ്വരജ്ഞാനീ മാനവഃ കോപി നാസ്തി ഹി| ");
INSERT INTO sanmal_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","വിമാർഗഗാമിനഃ സർവ്വേ സർവ്വേ ദുഷ്കർമ്മകാരിണഃ| ഏകോ ജനോപി നോ തേഷാം സാധുകർമ്മ കരോതി ച| ");
INSERT INTO sanmal_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","തഥാ തേഷാന്തു വൈ കണ്ഠാ അനാവൃതശ്മശാനവത്| സ്തുതിവാദം പ്രകുർവ്വന്തി ജിഹ്വാഭിസ്തേ തു കേവലം| തേഷാമോഷ്ഠസ്യ നിമ്നേ തു വിഷം തിഷ്ഠതി സർപ്പവത്| ");
INSERT INTO sanmal_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","മുഖം തേഷാം ഹി ശാപേന കപടേന ച പൂര്യ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","രക്തപാതായ തേഷാം തു പദാനി ക്ഷിപ്രഗാനി ച| ");
INSERT INTO sanmal_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","പഥി തേഷാം മനുഷ്യാണാം നാശഃ ക്ലേശശ്ച കേവലഃ| ");
INSERT INTO sanmal_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","തേ ജനാ നഹി ജാനന്തി പന്ഥാനം സുഖദായിനം| ");
INSERT INTO sanmal_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","പരമേശാദ് ഭയം യത്തത് തച്ചക്ഷുഷോരഗോചരം| ");
INSERT INTO sanmal_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","വ്യവസ്ഥായാം യദ്യല്ലിഖതി തദ് വ്യവസ്ഥാധീനാൻ ലോകാൻ ഉദ്ദിശ്യ ലിഖതീതി വയം ജാനീമഃ| തതോ മനുഷ്യമാത്രോ നിരുത്തരഃ സൻ ഈശ്വരസ്യ സാക്ഷാദ് അപരാധീ ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","അതഏവ വ്യവസ്ഥാനുരൂപൈഃ കർമ്മഭിഃ കശ്ചിദപി പ്രാണീശ്വരസ്യ സാക്ഷാത് സപുണ്യീകൃതോ ഭവിതും ന ശക്ഷ്യതി യതോ വ്യവസ്ഥയാ പാപജ്ഞാനമാത്രം ജായതേ| ");
INSERT INTO sanmal_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","കിന്തു വ്യവസ്ഥായാഃ പൃഥഗ് ഈശ്വരേണ ദേയം യത് പുണ്യം തദ് വ്യവസ്ഥായാ ഭവിഷ്യദ്വാദിഗണസ്യ ച വചനൈഃ പ്രമാണീകൃതം സദ് ഇദാനീം പ്രകാശതേ| ");
INSERT INTO sanmal_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","യീശുഖ്രീഷ്ടേ വിശ്വാസകരണാദ് ഈശ്വരേണ ദത്തം തത് പുണ്യം സകലേഷു പ്രകാശിതം സത് സർവ്വാൻ വിശ്വാസിനഃ പ്രതി വർത്തതേ| ");
INSERT INTO sanmal_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","തേഷാം കോപി പ്രഭേദോ നാസ്തി, യതഃ സർവ്വഏവ പാപിന ഈശ്വരീയതേജോഹീനാശ്ച ജാതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","ത ഈശ്വരസ്യാനുഗ്രഹാദ് മൂല്യം വിനാ ഖ്രീഷ്ടകൃതേന പരിത്രാണേന സപുണ്യീകൃതാ ഭവന്തി| ");
INSERT INTO sanmal_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","യസ്മാത് സ്വശോണിതേന വിശ്വാസാത് പാപനാശകോ ബലീ ഭവിതും സ ഏവ പൂർവ്വമ് ഈശ്വരേണ നിശ്ചിതഃ, ഇത്ഥമ് ഈശ്വരീയസഹിഷ്ണുത്വാത് പുരാകൃതപാപാനാം മാർജ്ജനകരണേ സ്വീയയാഥാർഥ്യം തേന പ്രകാശ്യതേ, ");
INSERT INTO sanmal_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","വർത്തമാനകാലീയമപി സ്വയാഥാർഥ്യം തേന പ്രകാശ്യതേ, അപരം യീശൗ വിശ്വാസിനം സപുണ്യീകുർവ്വന്നപി സ യാഥാർഥികസ്തിഷ്ഠതി| ");
INSERT INTO sanmal_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","തർഹി കുത്രാത്മശ്ലാഘാ? സാ ദൂരീകൃതാ; കയാ വ്യവസ്ഥയാ? കിം ക്രിയാരൂപവ്യവസ്ഥയാ? ഇത്ഥം നഹി കിന്തു തത് കേവലവിശ്വാസരൂപയാ വ്യവസ്ഥയൈവ ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","അതഏവ വ്യവസ്ഥാനുരൂപാഃ ക്രിയാ വിനാ കേവലേന വിശ്വാസേന മാനവഃ സപുണ്യീകൃതോ ഭവിതും ശക്നോതീത്യസ്യ രാദ്ധാന്തം ദർശയാമഃ| ");
INSERT INTO sanmal_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","സ കിം കേവലയിഹൂദിനാമ് ഈശ്വരോ ഭവതി? ഭിന്നദേശിനാമ് ഈശ്വരോ ന ഭവതി? ഭിന്നദേശിനാമപി ഭവതി; ");
INSERT INTO sanmal_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","യസ്മാദ് ഏക ഈശ്വരോ വിശ്വാസാത് ത്വക്ഛേദിനോ വിശ്വാസേനാത്വക്ഛേദിനശ്ച സപുണ്യീകരിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","തർഹി വിശ്വാസേന വയം കിം വ്യവസ്ഥാം ലുമ്പാമ? ഇത്ഥം ന ഭവതു വയം വ്യവസ്ഥാം സംസ്ഥാപയാമ ഏവ| ");
INSERT INTO sanmal_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","അസ്മാകം പൂർവ്വപുരുഷ ഇബ്രാഹീമ് കായികക്രിയയാ കിം ലബ്ധവാൻ ഏതദധി കിം വദിഷ്യാമഃ? ");
INSERT INTO sanmal_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","സ യദി നിജക്രിയാഭ്യഃ സപുണ്യോ ഭവേത് തർഹി തസ്യാത്മശ്ലാഘാം കർത്തും പന്ഥാ ഭവേദിതി സത്യം, കിന്ത്വീശ്വരസ്യ സമീപേ നഹി| ");
INSERT INTO sanmal_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","ശാസ്ത്രേ കിം ലിഖതി? ഇബ്രാഹീമ് ഈശ്വരേ വിശ്വസനാത് സ വിശ്വാസസ്തസ്മൈ പുണ്യാർഥം ഗണിതോ ബഭൂവ| ");
INSERT INTO sanmal_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","കർമ്മകാരിണോ യദ് വേതനം തദ് അനുഗ്രഹസ്യ ഫലം നഹി കിന്തു തേനോപാർജിതം മന്തവ്യമ്| ");
INSERT INTO sanmal_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","കിന്തു യഃ പാപിനം സപുണ്യീകരോതി തസ്മിൻ വിശ്വാസിനഃ കർമ്മഹീനസ്യ ജനസ്യ യോ വിശ്വാസഃ സ പുണ്യാർഥം ഗണ്യോ ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","അപരം യം ക്രിയാഹീനമ് ഈശ്വരഃ സപുണ്യീകരോതി തസ്യ ധന്യവാദം ദായൂദ് വർണയാമാസ, യഥാ, ");
INSERT INTO sanmal_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","സ ധന്യോഽഘാനി മൃഷ്ടാനി യസ്യാഗാംസ്യാവൃതാനി ച| ");
INSERT INTO sanmal_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","സ ച ധന്യഃ പരേശേന പാപം യസ്യ ന ഗണ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","ഏഷ ധന്യവാദസ്ത്വക്ഛേദിനമ് അത്വക്ഛേദിനം വാ കം പ്രതി ഭവതി? ഇബ്രാഹീമോ വിശ്വാസഃ പുണ്യാർഥം ഗണിത ഇതി വയം വദാമഃ| ");
INSERT INTO sanmal_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","സ വിശ്വാസസ്തസ്യ ത്വക്ഛേദിത്വാവസ്ഥായാം കിമ് അത്വക്ഛേദിത്വാവസ്ഥായാം കസ്മിൻ സമയേ പുണ്യമിവ ഗണിതഃ? ത്വക്ഛേദിത്വാവസ്ഥായാം നഹി കിന്ത്വത്വക്ഛേദിത്വാവസ്ഥായാം| ");
INSERT INTO sanmal_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","അപരഞ്ച സ യത് സർവ്വേഷാമ് അത്വക്ഛേദിനാം വിശ്വാസിനാമ് ആദിപുരുഷോ ഭവേത്, തേ ച പുണ്യവത്ത്വേന ഗണ്യേരൻ; ");
INSERT INTO sanmal_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","യേ ച ലോകാഃ കേവലം ഛിന്നത്വചോ ന സന്തോ ഽസ്മത്പൂർവ്വപുരുഷ ഇബ്രാഹീമ് അഛിന്നത്വക് സൻ യേന വിശ്വാസമാർഗേണ ഗതവാൻ തേനൈവ തസ്യ പാദചിഹ്നേന ഗച്ഛന്തി തേഷാം ത്വക്ഛേദിനാമപ്യാദിപുരുഷോ ഭവേത് തദർഥമ് അത്വക്ഛേദിനോ മാനവസ്യ വിശ്വാസാത് പുണ്യമ് ഉത്പദ്യത ഇതി പ്രമാണസ്വരൂപം ത്വക്ഛേദചിഹ്നം സ പ്രാപ്നോത്| ");
INSERT INTO sanmal_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","ഇബ്രാഹീമ് ജഗതോഽധികാരീ ഭവിഷ്യതി യൈഷാ പ്രതിജ്ഞാ തം തസ്യ വംശഞ്ച പ്രതി പൂർവ്വമ് അക്രിയത സാ വ്യവസ്ഥാമൂലികാ നഹി കിന്തു വിശ്വാസജന്യപുണ്യമൂലികാ| ");
INSERT INTO sanmal_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","യതോ വ്യവസ്ഥാവലമ്ബിനോ യദ്യധികാരിണോ ഭവന്തി തർഹി വിശ്വാസോ വിഫലോ ജായതേ സാ പ്രതിജ്ഞാപി ലുപ്തൈവ| ");
INSERT INTO sanmal_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","അധികന്തു വ്യവസ്ഥാ കോപം ജനയതി യതോ ഽവിദ്യമാനായാം വ്യവസ്ഥായാമ് ആജ്ഞാലങ്ഘനം ന സമ്ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","അതഏവ സാ പ്രതിജ്ഞാ യദ് അനുഗ്രഹസ്യ ഫലം ഭവേത് തദർഥം വിശ്വാസമൂലികാ യതസ്തഥാത്വേ തദ്വംശസമുദായം പ്രതി അർഥതോ യേ വ്യവസ്ഥയാ തദ്വംശസമ്ഭവാഃ കേവലം താൻ പ്രതി നഹി കിന്തു യ ഇബ്രാഹീമീയവിശ്വാസേന തത്സമ്ഭവാസ്താനപി പ്രതി സാ പ്രതിജ്ഞാ സ്ഥാസ്നുർഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","യോ നിർജീവാൻ സജീവാൻ അവിദ്യമാനാനി വസ്തൂനി ച വിദ്യമാനാനി കരോതി ഇബ്രാഹീമോ വിശ്വാസഭൂമേസ്തസ്യേശ്വരസ്യ സാക്ഷാത് സോഽസ്മാകം സർവ്വേഷാമ് ആദിപുരുഷ ആസ്തേ, യഥാ ലിഖിതം വിദ്യതേ, അഹം ത്വാം ബഹുജാതീനാമ് ആദിപുരുഷം കൃത്വാ നിയുക്തവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","ത്വദീയസ്താദൃശോ വംശോ ജനിഷ്യതേ യദിദം വാക്യം പ്രതിശ്രുതം തദനുസാരാദ് ഇബ്രാഹീമ് ബഹുദേശീയലോകാനാമ് ആദിപുരുഷോ യദ് ഭവതി തദർഥം സോഽനപേക്ഷിതവ്യമപ്യപേക്ഷമാണോ വിശ്വാസം കൃതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","അപരഞ്ച ക്ഷീണവിശ്വാസോ ന ഭൂത്വാ ശതവത്സരവയസ്കത്വാത് സ്വശരീരസ്യ ജരാം സാരാനാമ്നഃ സ്വഭാര്യ്യായാ രജോനിവൃത്തിഞ്ച തൃണായ ന മേനേ| ");
INSERT INTO sanmal_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","അപരമ് അവിശ്വാസാദ് ഈശ്വരസ്യ പ്രതിജ്ഞാവചനേ കമപി സംശയം ന ചകാര; ");
INSERT INTO sanmal_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","കിന്ത്വീശ്വരേണ യത് പ്രതിശ്രുതം തത് സാധയിതും ശക്യത ഇതി നിശ്ചിതം വിജ്ഞായ ദൃഢവിശ്വാസഃ സൻ ഈശ്വരസ്യ മഹിമാനം പ്രകാശയാഞ്ചകാര| ");
INSERT INTO sanmal_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","ഇതി ഹേതോസ്തസ്യ സ വിശ്വാസസ്തദീയപുണ്യമിവ ഗണയാഞ്ചക്രേ| ");
INSERT INTO sanmal_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","പുണ്യമിവാഗണ്യത തത് കേവലസ്യ തസ്യ നിമിത്തം ലിഖിതം നഹി, അസ്മാകം നിമിത്തമപി, ");
INSERT INTO sanmal_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","യതോഽസ്മാകം പാപനാശാർഥം സമർപിതോഽസ്മാകം പുണ്യപ്രാപ്ത്യർഥഞ്ചോത്ഥാപിതോഽഭവത് യോഽസ്മാകം പ്രഭു ര്യീശുസ്തസ്യോത്ഥാപയിതരീശ്വരേ ");
INSERT INTO sanmal_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","യദി വയം വിശ്വസാമസ്തർഹ്യസ്മാകമപി സഏവ വിശ്വാസഃ പുണ്യമിവ ഗണയിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","വിശ്വാസേന സപുണ്യീകൃതാ വയമ് ഈശ്വരേണ സാർദ്ധം പ്രഭുണാസ്മാകം യീശുഖ്രീഷ്ടേന മേലനം പ്രാപ്താഃ| ");
INSERT INTO sanmal_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","അപരം വയം യസ്മിൻ അനുഗ്രഹാശ്രയേ തിഷ്ഠാമസ്തന്മധ്യം വിശ്വാസമാർഗേണ തേനൈവാനീതാ വയമ് ഈശ്വരീയവിഭവപ്രാപ്തിപ്രത്യാശയാ സമാനന്ദാമഃ| ");
INSERT INTO sanmal_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","തത് കേവലം നഹി കിന്തു ക്ലേശഭോഗേഽപ്യാനന്ദാമോ യതഃ ക്ലേശാाദ് ധൈര്യ്യം ജായത ഇതി വയം ജാനീമഃ, ");
INSERT INTO sanmal_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ധൈര്യ്യാച്ച പരീക്ഷിതത്വം ജായതേ, പരീക്ഷിതത്വാത് പ്രത്യാശാ ജായതേ, ");
INSERT INTO sanmal_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","പ്രത്യാശാതോ വ്രീഡിതത്വം ന ജായതേ, യസ്മാദ് അസ്മഭ്യം ദത്തേന പവിത്രേണാത്മനാസ്മാകമ് അന്തഃകരണാനീശ്വരസ്യ പ്രേമവാരിണാ സിക്താനി| ");
INSERT INTO sanmal_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","അസ്മാസു നിരുപായേഷു സത്സു ഖ്രീഷ്ട ഉപയുക്തേ സമയേ പാപിനാം നിമിത്തം സ്വീയാൻ പ്രണാൻ അത്യജത്| ");
INSERT INTO sanmal_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","ഹിതകാരിണോ ജനസ്യ കൃതേ കോപി പ്രണാൻ ത്യക്തും സാഹസം കർത്തും ശക്നോതി, കിന്തു ധാർമ്മികസ്യ കൃതേ പ്രായേണ കോപി പ്രാണാൻ ന ത്യജതി| ");
INSERT INTO sanmal_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","കിന്ത്വസ്മാസു പാപിഷു സത്സ്വപി നിമിത്തമസ്മാകം ഖ്രീഷ്ടഃ സ്വപ്രാണാൻ ത്യക്തവാൻ, തത ഈശ്വരോസ്മാൻ പ്രതി നിജം പരമപ്രേമാണം ദർശിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","അതഏവ തസ്യ രക്തപാതേന സപുണ്യീകൃതാ വയം നിതാന്തം തേന കോപാദ് ഉദ്ധാരിഷ്യാമഹേ| ");
INSERT INTO sanmal_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","ഫലതോ വയം യദാ രിപവ ആസ്മ തദേശ്വരസ്യ പുത്രസ്യ മരണേന തേന സാർദ്ധം യദ്യസ്മാകം മേലനം ജാതം തർഹി മേലനപ്രാപ്താഃ സന്തോഽവശ്യം തസ്യ ജീവനേന രക്ഷാം ലപ്സ്യാമഹേ| ");
INSERT INTO sanmal_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","തത് കേവലം നഹി കിന്തു യേന മേലനമ് അലഭാമഹി തേനാസ്മാകം പ്രഭുണാ യീശുഖ്രീഷ്ടേന സാമ്പ്രതമ് ഈശ്വരേ സമാനന്ദാമശ്ച| ");
INSERT INTO sanmal_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","തഥാ സതി, ഏകേന മാനുഷേണ പാപം പാപേന ച മരണം ജഗതീം പ്രാവിശത് അപരം സർവ്വേഷാം പാപിത്വാത് സർവ്വേ മാനുഷാ മൃതേ ർനിഘ്നാ അഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","യതോ വ്യവസ്ഥാദാനസമയം യാവത് ജഗതി പാപമ് ആസീത് കിന്തു യത്ര വ്യവസ്ഥാ ന വിദ്യതേ തത്ര പാപസ്യാപി ഗണനാ ന വിദ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","തഥാപ്യാദമാ യാദൃശം പാപം കൃതം താദൃശം പാപം യൈ ർനാകാരി ആദമമ് ആരഭ്യ മൂസാം യാവത് തേഷാമപ്യുപരി മൃത്യൂ രാജത്വമ് അകരോത് സ ആദമ് ഭാവ്യാദമോ നിദർശനമേവാസ്തേ| ");
INSERT INTO sanmal_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","കിന്തു പാപകർമ്മണോ യാദൃശോ ഭാവസ്താദൃഗ് ദാനകർമ്മണോ ഭാവോ ന ഭവതി യത ഏകസ്യ ജനസ്യാപരാധേന യദി ബഹൂനാം മരണമ് അഘടത തഥാപീശ്വരാനുഗ്രഹസ്തദനുഗ്രഹമൂലകം ദാനഞ്ചൈകേന ജനേനാർഥാദ് യീശുനാ ഖ്രീഷ്ടേന ബഹുഷു ബാഹുല്യാതിബാഹുല്യേന ഫലതി| ");
INSERT INTO sanmal_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","അപരമ് ഏകസ്യ ജനസ്യ പാപകർമ്മ യാദൃക് ഫലയുക്തം ദാനകർമ്മ താദൃക് ന ഭവതി യതോ വിചാരകർമ്മൈകം പാപമ് ആരഭ്യ ദണ്ഡജനകം ബഭൂവ, കിന്തു ദാനകർമ്മ ബഹുപാപാന്യാരഭ്യ പുണ്യജനകം ബഭൂവ| ");
INSERT INTO sanmal_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","യത ഏകസ്യ ജനസ്യ പാപകർമ്മതസ്തേനൈകേന യദി മരണസ്യ രാജത്വം ജാതം തർഹി യേ ജനാ അനുഗ്രഹസ്യ ബാഹുല്യം പുണ്യദാനഞ്ച പ്രാപ്നുവന്തി ത ഏകേന ജനേന, അർഥാത് യീശുഖ്രീഷ്ടേന, ജീവനേ രാജത്വമ് അവശ്യം കരിഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","ഏകോഽപരാധോ യദ്വത് സർവ്വമാനവാനാം ദണ്ഡഗാമീ മാർഗോ ഽഭവത് തദ്വദ് ഏകം പുണ്യദാനം സർവ്വമാനവാനാം ജീവനയുക്തപുണ്യഗാമീ മാർഗ ഏവ| ");
INSERT INTO sanmal_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","അപരമ് ഏകസ്യ ജനസ്യാജ്ഞാലങ്ഘനാദ് യഥാ ബഹവോ ഽപരാധിനോ ജാതാസ്തദ്വദ് ഏകസ്യാജ്ഞാചരണാദ് ബഹവഃ സപുണ്യീകൃതാ ഭവന്തി| ");
INSERT INTO sanmal_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","അധികന്തു വ്യവസ്ഥാഗമനാദ് അപരാധസ്യ ബാഹുല്യം ജാതം കിന്തു യത്ര പാപസ്യ ബാഹുല്യം തത്രൈവ തസ്മാദ് അനുഗ്രഹസ്യ ബാഹുല്യമ് അഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","തേന മൃത്യുനാ യദ്വത് പാപസ്യ രാജത്വമ് അഭവത് തദ്വദ് അസ്മാകം പ്രഭുയീശുഖ്രീഷ്ടദ്വാരാനന്തജീവനദായിപുണ്യേനാനുഗ്രഹസ്യ രാജത്വം ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","പ്രഭൂതരൂപേണ യദ് അനുഗ്രഹഃ പ്രകാശതേ തദർഥം പാപേ തിഷ്ഠാമ ഇതി വാക്യം കിം വയം വദിഷ്യാമഃ? തന്ന ഭവതു| ");
INSERT INTO sanmal_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","പാപം പ്രതി മൃതാ വയം പുനസ്തസ്മിൻ കഥമ് ജീവിഷ്യാമഃ? ");
INSERT INTO sanmal_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","വയം യാവന്തോ ലോകാ യീശുഖ്രീഷ്ടേ മജ്ജിതാ അഭവാമ താവന്ത ഏവ തസ്യ മരണേ മജ്ജിതാ ഇതി കിം യൂയം ന ജാനീഥ? ");
INSERT INTO sanmal_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","തതോ യഥാ പിതുഃ പരാക്രമേണ ശ്മശാനാത് ഖ്രീഷ്ട ഉത്ഥാപിതസ്തഥാ വയമപി യത് നൂതനജീവിന ഇവാചരാമസ്തദർഥം മജ്ജനേന തേന സാർദ്ധം മൃത്യുരൂപേ ശ്മശാനേ സംസ്ഥാപിതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","അപരം വയം യദി തേന സംയുക്താഃ സന്തഃ സ ഇവ മരണഭാഗിനോ ജാതാസ്തർഹി സ ഇവോത്ഥാനഭാഗിനോഽപി ഭവിഷ്യാമഃ| ");
INSERT INTO sanmal_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","വയം യത് പാപസ്യ ദാസാഃ പുന ർന ഭവാമസ്തദർഥമ് അസ്മാകം പാപരൂപശരീരസ്യ വിനാശാർഥമ് അസ്മാകം പുരാതനപുരുഷസ്തേന സാകം ക്രുശേഽഹന്യതേതി വയം ജാനീമഃ| ");
INSERT INTO sanmal_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","യോ ഹതഃ സ പാപാത് മുക്ത ഏവ| ");
INSERT INTO sanmal_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","അതഏവ യദി വയം ഖ്രീഷ്ടേന സാർദ്ധമ് അഹന്യാമഹി തർഹി പുനരപി തേന സഹിതാ ജീവിഷ്യാമ ഇത്യത്രാസ്മാകം വിശ്വാസോ വിദ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","യതഃ ശ്മശാനാദ് ഉത്ഥാപിതഃ ഖ്രീഷ്ടോ പുന ർന മ്രിയത ഇതി വയം ജാനീമഃ| തസ്മിൻ കോപ്യധികാരോ മൃത്യോ ർനാസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","അപരഞ്ച സ യദ് അമ്രിയത തേനൈകദാ പാപമ് ഉദ്ദിശ്യാമ്രിയത, യച്ച ജീവതി തേനേശ്വരമ് ഉദ്ദിശ്യ ജീവതി; ");
INSERT INTO sanmal_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","തദ്വദ് യൂയമപി സ്വാൻ പാപമ് ഉദ്ദിശ്യ മൃതാൻ അസ്മാകം പ്രഭുണാ യീശുഖ്രീഷ്ടേനേശ്വരമ് ഉദ്ദിശ്യ ജീവന്തോ ജാനീത| ");
INSERT INTO sanmal_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","അപരഞ്ച കുത്സിതാഭിലാഷാाൻ പൂരയിതും യുഷ്മാകം മർത്യദേഹേഷു പാപമ് ആധിപത്യം ന കരോതു| ");
INSERT INTO sanmal_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","അപരം സ്വം സ്വമ് അങ്ഗമ് അധർമ്മസ്യാസ്ത്രം കൃത്വാ പാപസേവായാം ന സമർപയത, കിന്തു ശ്മശാനാദ് ഉത്ഥിതാനിവ സ്വാൻ ഈശ്വരേ സമർപയത സ്വാന്യങ്ഗാനി ച ധർമ്മാസ്ത്രസ്വരൂപാണീശ്വരമ് ഉദ്ദിശ്യ സമർപയത| ");
INSERT INTO sanmal_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","യുഷ്മാകമ് ഉപരി പാപസ്യാധിപത്യം പുന ർന ഭവിഷ്യതി, യസ്മാദ് യൂയം വ്യവസ്ഥായാ അനായത്താ അനുഗ്രഹസ്യ ചായത്താ അഭവത| ");
INSERT INTO sanmal_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","കിന്തു വയം വ്യവസ്ഥായാ അനായത്താ അനുഗ്രഹസ്യ ചായത്താ അഭവാമ, ഇതി കാരണാത് കിം പാപം കരിഷ്യാമഃ? തന്ന ഭവതു| ");
INSERT INTO sanmal_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","യതോ മൃതിജനകം പാപം പുണ്യജനകം നിദേശാചരണഞ്ചൈതയോർദ്വയോ ര്യസ്മിൻ ആജ്ഞാപാലനാർഥം ഭൃത്യാനിവ സ്വാൻ സമർപയഥ, തസ്യൈവ ഭൃത്യാ ഭവഥ, ഏതത് കിം യൂയം ന ജാനീഥ? ");
INSERT INTO sanmal_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","അപരഞ്ച പൂർവ്വം യൂയം പാപസ്യ ഭൃത്യാ ആസ്തേതി സത്യം കിന്തു യസ്യാം ശിക്ഷാരൂപായാം മൂഷായാം നിക്ഷിപ്താ അഭവത തസ്യാ ആകൃതിം മനോഭി ർലബ്ധവന്ത ഇതി കാരണാദ് ഈശ്വരസ്യ ധന്യവാദോ ഭവതു| ");
INSERT INTO sanmal_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","ഇത്ഥം യൂയം പാപസേവാതോ മുക്താഃ സന്തോ ധർമ്മസ്യ ഭൃത്യാ ജാതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","യുഷ്മാകം ശാരീരിക്യാ ദുർബ്ബലതായാ ഹേതോ ർമാനവവദ് അഹമ് ഏതദ് ബ്രവീമി; പുനഃ പുനരധർമ്മകരണാർഥം യദ്വത് പൂർവ്വം പാപാമേധ്യയോ ർഭൃത്യത്വേ നിജാങ്ഗാനി സമാർപയത തദ്വദ് ഇദാനീം സാധുകർമ്മകരണാർഥം ധർമ്മസ്യ ഭൃത്യത്വേ നിജാങ്ഗാനി സമർപയത| ");
INSERT INTO sanmal_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","യദാ യൂയം പാപസ്യ ഭൃത്യാ ആസ്ത തദാ ധർമ്മസ്യ നായത്താ ആസ്ത| ");
INSERT INTO sanmal_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","തർഹി യാനി കർമ്മാണി യൂയമ് ഇദാനീം ലജ്ജാജനകാനി ബുധ്യധ്വേ പൂർവ്വം തൈ ര്യുഷ്മാകം കോ ലാഭ ആസീത്? തേഷാം കർമ്മണാം ഫലം മരണമേവ| ");
INSERT INTO sanmal_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","കിന്തു സാമ്പ്രതം യൂയം പാപസേവാതോ മുക്താഃ സന്ത ഈശ്വരസ്യ ഭൃത്യാഽഭവത തസ്മാദ് യുഷ്മാകം പവിത്രത്വരൂപം ലഭ്യമ് അനന്തജീവനരൂപഞ്ച ഫലമ് ആസ്തേ| ");
INSERT INTO sanmal_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","യതഃ പാപസ്യ വേതനം മരണം കിന്ത്വസ്മാകം പ്രഭുണാ യീശുഖ്രീഷ്ടേനാനന്തജീവനമ് ഈശ്വരദത്തം പാരിതോഷികമ് ആസ്തേ| ");
INSERT INTO sanmal_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","ഹേ ഭ്രാതൃഗണ വ്യവസ്ഥാവിദഃ പ്രതി മമേദം നിവേദനം| വിധിഃ കേവലം യാവജ്ജീവം മാനവോപര്യ്യധിപതിത്വം കരോതീതി യൂയം കിം ന ജാനീഥ? ");
INSERT INTO sanmal_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","യാവത്കാലം പതി ർജീവതി താവത്കാലമ് ഊഢാ ഭാര്യ്യാ വ്യവസ്ഥയാ തസ്മിൻ ബദ്ധാ തിഷ്ഠതി കിന്തു യദി പതി ർമ്രിയതേ തർഹി സാ നാരീ പത്യു ർവ്യവസ്ഥാതോ മുച്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","ഏതത്കാരണാത് പത്യുർജീവനകാലേ നാരീ യദ്യന്യം പുരുഷം വിവഹതി തർഹി സാ വ്യഭിചാരിണീ ഭവതി കിന്തു യദി സ പതി ർമ്രിയതേ തർഹി സാ തസ്യാ വ്യവസ്ഥായാ മുക്താ സതീ പുരുഷാന്തരേണ വ്യൂഢാപി വ്യഭിചാരിണീ ന ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","ഹേ മമ ഭ്രാതൃഗണ, ഈശ്വരനിമിത്തം യദസ്മാകം ഫലം ജായതേ തദർഥം ശ്മശാനാദ് ഉത്ഥാപിതേന പുരുഷേണ സഹ യുഷ്മാകം വിവാഹോ യദ് ഭവേത് തദർഥം ഖ്രീഷ്ടസ്യ ശരീരേണ യൂയം വ്യവസ്ഥാം പ്രതി മൃതവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","യതോഽസ്മാകം ശാരീരികാചരണസമയേ മരണനിമിത്തം ഫലമ് ഉത്പാദയിതും വ്യവസ്ഥയാ ദൂഷിതഃ പാപാഭിലാഷോഽസ്മാകമ് അങ്ഗേഷു ജീവൻ ആസീത്| ");
INSERT INTO sanmal_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","കിന്തു തദാ യസ്യാ വ്യവസ്ഥായാ വശേ ആസ്മഹി സാമ്പ്രതം താം പ്രതി മൃതത്വാദ് വയം തസ്യാ അധീനത്വാത് മുക്താ ഇതി ഹേതോരീശ്വരോഽസ്മാഭിഃ പുരാതനലിഖിതാനുസാരാത് ന സേവിതവ്യഃ കിന്തു നവീനസ്വഭാവേനൈവ സേവിതവ്യഃ ");
INSERT INTO sanmal_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","തർഹി വയം കിം ബ്രൂമഃ? വ്യവസ്ഥാ കിം പാപജനികാ ഭവതി? നേത്ഥം ഭവതു| വ്യവസ്ഥാമ് അവിദ്യമാനായാം പാപം കിമ് ഇത്യഹം നാവേദം; കിഞ്ച ലോഭം മാ കാർഷീരിതി ചേദ് വ്യവസ്ഥാഗ്രന്ഥേ ലിഖിതം നാഭവിഷ്യത് തർഹി ലോഭഃ കിമ്ഭൂതസ്തദഹം നാജ്ഞാസ്യം| ");
INSERT INTO sanmal_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","കിന്തു വ്യവസ്ഥയാ പാപം ഛിദ്രം പ്രാപ്യാസ്മാകമ് അന്തഃ സർവ്വവിധം കുത്സിതാഭിലാഷമ് അജനയത്; യതോ വ്യവസ്ഥായാമ് അവിദ്യമാനായാം പാപം മൃതം| ");
INSERT INTO sanmal_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","അപരം പൂർവ്വം വ്യവസ്ഥായാമ് അവിദ്യമാനായാമ് അഹമ് അജീവം തതഃ പരമ് ആജ്ഞായാമ് ഉപസ്ഥിതായാമ് പാപമ് അജീവത് തദാഹമ് അമ്രിയേ| ");
INSERT INTO sanmal_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","ഇത്ഥം സതി ജീവനനിമിത്താ യാജ്ഞാ സാ മമ മൃത്യുജനികാഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","യതഃ പാപം ഛിദ്രം പ്രാപ്യ വ്യവസ്ഥിതാദേശേന മാം വഞ്ചയിത്വാ തേന മാമ് അഹൻ| ");
INSERT INTO sanmal_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","അതഏവ വ്യവസ്ഥാ പവിത്രാ, ആദേശശ്ച പവിത്രോ ന്യായ്യോ ഹിതകാരീ ച ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","തർഹി യത് സ്വയം ഹിതകൃത് തത് കിം മമ മൃത്യുജനകമ് അഭവത്? നേത്ഥം ഭവതു; കിന്തു പാപം യത് പാതകമിവ പ്രകാശതേ തഥാ നിദേശേന പാപം യദതീവ പാതകമിവ പ്രകാശതേ തദർഥം ഹിതോപായേന മമ മരണമ് അജനയത്| ");
INSERT INTO sanmal_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","വ്യവസ്ഥാത്മബോധികേതി വയം ജാനീമഃ കിന്ത്വഹം ശാരീരതാചാരീ പാപസ്യ ക്രീതകിങ്കരോ വിദ്യേ| ");
INSERT INTO sanmal_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","യതോ യത് കർമ്മ കരോമി തത് മമ മനോഽഭിമതം നഹി; അപരം യൻ മമ മനോഽഭിമതം തന്ന കരോമി കിന്തു യദ് ഋതീയേ തത് കരോമി| ");
INSERT INTO sanmal_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","തഥാത്വേ യൻ മമാനഭിമതം തദ് യദി കരോമി തർഹി വ്യവസ്ഥാ സൂത്തമേതി സ്വീകരോമി| ");
INSERT INTO sanmal_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","അതഏവ സമ്പ്രതി തത് കർമ്മ മയാ ക്രിയത ഇതി നഹി കിന്തു മമ ശരീരസ്ഥേന പാപേനൈവ ക്രിയതേ| ");
INSERT INTO sanmal_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","യതോ മയി, അർഥതോ മമ ശരീരേ, കിമപ്യുത്തമം ന വസതി, ഏതദ് അഹം ജാനാമി; മമേച്ഛുകതായാം തിഷ്ഠന്ത്യാമപ്യഹമ് ഉത്തമകർമ്മസാധനേ സമർഥോ ന ഭവാമി| ");
INSERT INTO sanmal_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","യതോ യാമുത്തമാം ക്രിയാം കർത്തുമഹം വാഞ്ഛാമി താം ന കരോമി കിന്തു യത് കുത്സിതം കർമ്മ കർത്തുമ് അനിച്ഛുകോഽസ്മി തദേവ കരോമി| ");
INSERT INTO sanmal_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","അതഏവ യദ്യത് കർമ്മ കർത്തും മമേച്ഛാ ന ഭവതി തദ് യദി കരോമി തർഹി തത് മയാ ന ക്രിയതേ, മമാന്തർവർത്തിനാ പാപേനൈവ ക്രിയതേ| ");
INSERT INTO sanmal_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","ഭദ്രം കർത്തുമ് ഇച്ഛുകം മാം യോ ഽഭദ്രം കർത്തും പ്രവർത്തയതി താദൃശം സ്വഭാവമേകം മയി പശ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","അഹമ് ആന്തരികപുരുഷേണേശ്വരവ്യവസ്ഥായാം സന്തുഷ്ട ആസേ; ");
INSERT INTO sanmal_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","കിന്തു തദ്വിപരീതം യുധ്യന്തം തദന്യമേകം സ്വഭാവം മദീയാങ്ഗസ്ഥിതം പ്രപശ്യാമി, സ മദീയാങ്ഗസ്ഥിതപാപസ്വഭാവസ്യായത്തം മാം കർത്തും ചേഷ്ടതേ| ");
INSERT INTO sanmal_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","ഹാ ഹാ യോഽഹം ദുർഭാഗ്യോ മനുജസ്തം മാമ് ഏതസ്മാൻ മൃതാച്ഛരീരാത് കോ നിസ്താരയിഷ്യതി? ");
INSERT INTO sanmal_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","അസ്മാകം പ്രഭുണാ യീശുഖ്രീഷ്ടേന നിസ്താരയിതാരമ് ഈശ്വരം ധന്യം വദാമി| അതഏവ ശരീരേണ പാപവ്യവസ്ഥായാ മനസാ തു ഈശ്വരവ്യവസ്ഥായാഃ സേവനം കരോമി| ");
INSERT INTO sanmal_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","യേ ജനാഃ ഖ്രീഷ്ടം യീശുമ് ആശ്രിത്യ ശാരീരികം നാചരന്ത ആത്മികമാചരന്തി തേഽധുനാ ദണ്ഡാർഹാ ന ഭവന്തി| ");
INSERT INTO sanmal_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","ജീവനദായകസ്യാത്മനോ വ്യവസ്ഥാ ഖ്രീഷ്ടയീശുനാ പാപമരണയോ ർവ്യവസ്ഥാതോ മാമമോചയത്| ");
INSERT INTO sanmal_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","യസ്മാച്ഛാരീരസ്യ ദുർബ്ബലത്വാദ് വ്യവസ്ഥയാ യത് കർമ്മാസാധ്യമ് ഈശ്വരോ നിജപുത്രം പാപിശരീരരൂപം പാപനാശകബലിരൂപഞ്ച പ്രേഷ്യ തസ്യ ശരീരേ പാപസ്യ ദണ്ഡം കുർവ്വൻ തത്കർമ്മ സാധിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","തതഃ ശാരീരികം നാചരിത്വാസ്മാഭിരാത്മികമ് ആചരദ്ഭിർവ്യവസ്ഥാഗ്രന്ഥേ നിർദ്ദിഷ്ടാനി പുണ്യകർമ്മാണി സർവ്വാണി സാധ്യന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","യേ ശാരീരികാചാരിണസ്തേ ശാരീരികാൻ വിഷയാൻ ഭാവയന്തി യേ ചാത്മികാചാരിണസ്തേ ആത്മനോ വിഷയാൻ ഭാവയന്തി| ");
INSERT INTO sanmal_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","ശാരീരികഭാവസ്യ ഫലം മൃത്യുഃ കിഞ്ചാത്മികഭാവസ്യ ഫലേ ജീവനം ശാന്തിശ്ച| ");
INSERT INTO sanmal_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","യതഃ ശാരീരികഭാവ ഈശ്വരസ്യ വിരുദ്ധഃ ശത്രുതാഭാവ ഏവ സ ഈശ്വരസ്യ വ്യവസ്ഥായാ അധീനോ ന ഭവതി ഭവിതുഞ്ച ന ശക്നോതി| ");
INSERT INTO sanmal_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","ഏതസ്മാത് ശാരീരികാചാരിഷു തോഷ്ടുമ് ഈശ്വരേണ ന ശക്യം| ");
INSERT INTO sanmal_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","കിന്ത്വീശ്വരസ്യാത്മാ യദി യുഷ്മാകം മധ്യേ വസതി തർഹി യൂയം ശാരീരികാചാരിണോ ന സന്ത ആത്മികാചാരിണോ ഭവഥഃ| യസ്മിൻ തു ഖ്രീഷ്ടസ്യാത്മാ ന വിദ്യതേ സ തത്സമ്ഭവോ നഹി| ");
INSERT INTO sanmal_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","യദി ഖ്രീഷ്ടോ യുഷ്മാൻ അധിതിഷ്ഠതി തർഹി പാപമ് ഉദ്ദിശ്യ ശരീരം മൃതം കിന്തു പുണ്യമുദ്ദിശ്യാത്മാ ജീവതി| ");
INSERT INTO sanmal_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","മൃതഗണാദ് യീശു ര്യേനോത്ഥാപിതസ്തസ്യാത്മാ യദി യുഷ്മന്മധ്യേ വസതി തർഹി മൃതഗണാത് ഖ്രീഷ്ടസ്യ സ ഉത്ഥാപയിതാ യുഷ്മന്മധ്യവാസിനാ സ്വകീയാത്മനാ യുഷ്മാകം മൃതദേഹാനപി പുന ർജീവയിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","ഹേ ഭ്രാതൃഗണ ശരീരസ്യ വയമധമർണാ ന ഭവാമോഽതഃ ശാരീരികാചാരോഽസ്മാഭി ർന കർത്തവ്യഃ| ");
INSERT INTO sanmal_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","യദി യൂയം ശരീരികാചാരിണോ ഭവേത തർഹി യുഷ്മാഭി ർമർത്തവ്യമേവ കിന്ത്വാത്മനാ യദി ശരീരകർമ്മാണി ഘാതയേത തർഹി ജീവിഷ്യഥ| ");
INSERT INTO sanmal_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","യതോ യാവന്തോ ലോകാ ഈശ്വരസ്യാത്മനാകൃഷ്യന്തേ തേ സർവ്വ ഈശ്വരസ്യ സന്താനാ ഭവന്തി| ");
INSERT INTO sanmal_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","യൂയം പുനരപി ഭയജനകം ദാസ്യഭാവം ന പ്രാപ്താഃ കിന്തു യേന ഭാവേനേശ്വരം പിതഃ പിതരിതി പ്രോച്യ സമ്ബോധയഥ താദൃശം ദത്തകപുത്രത്വഭാവമ് പ്രാപ്നുത| ");
INSERT INTO sanmal_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","അപരഞ്ച വയമ് ഈശ്വരസ്യ സന്താനാ ഏതസ്മിൻ പവിത്ര ആത്മാ സ്വയമ് അസ്മാകമ് ആത്മാഭിഃ സാർദ്ധം പ്രമാണം ദദാതി| ");
INSERT INTO sanmal_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","അതഏവ വയം യദി സന്താനാസ്തർഹ്യധികാരിണഃ, അർഥാദ് ഈശ്വരസ്യ സ്വത്ത്വാധികാരിണഃ ഖ്രീഷ്ടേന സഹാധികാരിണശ്ച ഭവാമഃ; അപരം തേന സാർദ്ധം യദി ദുഃഖഭാഗിനോ ഭവാമസ്തർഹി തസ്യ വിഭവസ്യാപി ഭാഗിനോ ഭവിഷ്യാമഃ| ");
INSERT INTO sanmal_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","കിന്ത്വസ്മാസു യോ ഭാവീവിഭവഃ പ്രകാശിഷ്യതേ തസ്യ സമീപേ വർത്തമാനകാലീനം ദുഃഖമഹം തൃണായ മന്യേ| ");
INSERT INTO sanmal_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","യതഃ പ്രാണിഗണ ഈശ്വരസ്യ സന്താനാനാം വിഭവപ്രാപ്തിമ് ആകാങ്ക്ഷൻ നിതാന്തമ് അപേക്ഷതേ| ");
INSERT INTO sanmal_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","അപരഞ്ച പ്രാണിഗണഃ സ്വൈരമ് അലീകതായാ വശീകൃതോ നാഭവത് ");
INSERT INTO sanmal_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","കിന്തു പ്രാണിഗണോഽപി നശ്വരതാധീനത്വാത് മുക്തഃ സൻ ഈശ്വരസ്യ സന്താനാനാം പരമമുക്തിം പ്രാപ്സ്യതീത്യഭിപ്രായേണ വശീകർത്രാ വശീചക്രേ| ");
INSERT INTO sanmal_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","അപരഞ്ച പ്രസൂയമാനാവദ് വ്യഥിതഃ സൻ ഇദാനീം യാവത് കൃത്സ്നഃ പ്രാണിഗണ ആർത്തസ്വരം കരോതീതി വയം ജാനീമഃ| ");
INSERT INTO sanmal_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","കേവലഃ സ ഇതി നഹി കിന്തു പ്രഥമജാതഫലസ്വരൂപമ് ആത്മാനം പ്രാപ്താ വയമപി ദത്തകപുത്രത്വപദപ്രാപ്തിമ് അർഥാത് ശരീരസ്യ മുക്തിം പ്രതീക്ഷമാണാസ്തദ്വദ് അന്തരാർത്തരാവം കുർമ്മഃ| ");
INSERT INTO sanmal_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","വയം പ്രത്യാശയാ ത്രാണമ് അലഭാമഹി കിന്തു പ്രത്യക്ഷവസ്തുനോ യാ പ്രത്യാശാ സാ പ്രത്യാശാ നഹി, യതോ മനുഷ്യോ യത് സമീക്ഷതേ തസ്യ പ്രത്യാശാം കുതഃ കരിഷ്യതി? ");
INSERT INTO sanmal_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","യദ് അപ്രത്യക്ഷം തസ്യ പ്രത്യാശാം യദി വയം കുർവ്വീമഹി തർഹി ധൈര്യ്യമ് അവലമ്ബ്യ പ്രതീക്ഷാമഹേ| ");
INSERT INTO sanmal_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","തത ആത്മാപി സ്വയമ് അസ്മാകം ദുർബ്ബലതായാഃ സഹായത്വം കരോതി; യതഃ കിം പ്രാർഥിതവ്യം തദ് ബോദ്ധും വയം ന ശക്നുമഃ, കിന്ത്വസ്പഷ്ടൈരാർത്തരാവൈരാത്മാ സ്വയമ് അസ്മന്നിമിത്തം നിവേദയതി| ");
INSERT INTO sanmal_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","അപരമ് ഈശ്വരാഭിമതരൂപേണ പവിത്രലോകാനാം കൃതേ നിവേദയതി യ ആത്മാ തസ്യാഭിപ്രായോഽന്തര്യ്യാമിനാ ജ്ഞായതേ| ");
INSERT INTO sanmal_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","അപരമ് ഈശ്വരീയനിരൂപണാനുസാരേണാഹൂതാഃ സന്തോ യേ തസ്മിൻ പ്രീയന്തേ സർവ്വാണി മിലിത്വാ തേഷാം മങ്ഗലം സാധയന്തി, ഏതദ് വയം ജാനീമഃ| ");
INSERT INTO sanmal_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","യത ഈശ്വരോ ബഹുഭ്രാതൃണാം മധ്യേ സ്വപുത്രം ജ്യേഷ്ഠം കർത്തുമ് ഇച്ഛൻ യാൻ പൂർവ്വം ലക്ഷ്യീകൃതവാൻ താൻ തസ്യ പ്രതിമൂർത്യാഃ സാദൃശ്യപ്രാപ്ത്യർഥം ന്യയുംക്ത| ");
INSERT INTO sanmal_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","അപരഞ്ച തേന യേ നിയുക്താസ്ത ആഹൂതാ അപി യേ ച തേനാഹൂതാസ്തേ സപുണ്യീകൃതാഃ, യേ ച തേന സപുണ്യീകൃതാസ്തേ വിഭവയുക്താഃ| ");
INSERT INTO sanmal_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","ഇത്യത്ര വയം കിം ബ്രൂമഃ? ഈശ്വരോ യദ്യസ്മാകം സപക്ഷോ ഭവതി തർഹി കോ വിപക്ഷോഽസ്മാകം? ");
INSERT INTO sanmal_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","ആത്മപുത്രം ന രക്ഷിത്വാ യോഽസ്മാകം സർവ്വേഷാം കൃതേ തം പ്രദത്തവാൻ സ കിം തേന സഹാസ്മഭ്യമ് അന്യാനി സർവ്വാണി ന ദാസ്യതി? ");
INSERT INTO sanmal_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","ഈശ്വരസ്യാഭിരുചിതേഷു കേന ദോഷ ആരോപയിഷ്യതേ? യ ഈശ്വരസ്താൻ പുണ്യവത ഇവ ഗണയതി കിം തേന? ");
INSERT INTO sanmal_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","അപരം തേഭ്യോ ദണ്ഡദാനാജ്ഞാ വാ കേന കരിഷ്യതേ? യോഽസ്മന്നിമിത്തം പ്രാണാൻ ത്യക്തവാൻ കേവലം തന്ന കിന്തു മൃതഗണമധ്യാദ് ഉത്ഥിതവാൻ, അപി ചേശ്വരസ്യ ദക്ഷിണേ പാർശ്വേ തിഷ്ഠൻ അദ്യാപ്യസ്മാകം നിമിത്തം പ്രാർഥത ഏവമ്ഭൂതോ യഃ ഖ്രീഷ്ടഃ കിം തേന? ");
INSERT INTO sanmal_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","അസ്മാഭിഃ സഹ ഖ്രീഷ്ടസ്യ പ്രേമവിച്ഛേദം ജനയിതും കഃ ശക്നോതി? ക്ലേശോ വ്യസനം വാ താഡനാ വാ ദുർഭിക്ഷം വാ വസ്ത്രഹീനത്വം വാ പ്രാണസംശയോ വാ ഖങ്ഗോ വാ കിമേതാനി ശക്നുവന്തി? ");
INSERT INTO sanmal_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","കിന്തു ലിഖിതമ് ആസ്തേ, യഥാ, വയം തവ നിമിത്തം സ്മോ മൃത്യുവക്ത്രേഽഖിലം ദിനം| ബലിർദേയോ യഥാ മേഷോ വയം ഗണ്യാമഹേ തഥാ| ");
INSERT INTO sanmal_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","അപരം യോഽസ്മാസു പ്രീയതേ തേനൈതാസു വിപത്സു വയം സമ്യഗ് വിജയാമഹേ| ");
INSERT INTO sanmal_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","യതോഽസ്മാകം പ്രഭുനാ യീശുഖ്രീഷ്ടേനേശ്വരസ്യ യത് പ്രേമ തസ്മാദ് അസ്മാകം വിച്ഛേദം ജനയിതും മൃത്യു ർജീവനം വാ ദിവ്യദൂതാ വാ ബലവന്തോ മുഖ്യദൂതാ വാ വർത്തമാനോ വാ ഭവിഷ്യൻ കാലോ വാ ഉച്ചപദം വാ നീചപദം വാപരം കിമപി സൃഷ്ടവസ്തു ");
INSERT INTO sanmal_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","വൈതേഷാം കേനാപി ന ശക്യമിത്യസ്മിൻ ദൃഢവിശ്വാസോ മമാസ്തേ| ");
INSERT INTO sanmal_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","അഹം കാഞ്ചിദ് കൽപിതാം കഥാം ന കഥയാമി, ഖ്രീഷ്ടസ്യ സാക്ഷാത് സത്യമേവ ബ്രവീമി പവിത്രസ്യാത്മനഃ സാക്ഷാൻ മദീയം മന ഏതത് സാക്ഷ്യം ദദാതി| ");
INSERT INTO sanmal_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","മമാന്തരതിശയദുഃഖം നിരന്തരം ഖേദശ്ച ");
INSERT INTO sanmal_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","തസ്മാദ് അഹം സ്വജാതീയഭ്രാതൃണാം നിമിത്താത് സ്വയം ഖ്രീഷ്ടാച്ഛാപാക്രാന്തോ ഭവിതുമ് ഐച്ഛമ്| ");
INSERT INTO sanmal_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","യതസ്ത ഇസ്രായേലസ്യ വംശാ അപി ച ദത്തകപുത്രത്വം തേജോ നിയമോ വ്യവസ്ഥാദാനം മന്ദിരേ ഭജനം പ്രതിജ്ഞാഃ പിതൃപുരുഷഗണശ്ചൈതേഷു സർവ്വേഷു തേഷാമ് അധികാരോഽസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","തത് കേവലം നഹി കിന്തു സർവ്വാധ്യക്ഷഃ സർവ്വദാ സച്ചിദാനന്ദ ഈശ്വരോ യഃ ഖ്രീഷ്ടഃ സോഽപി ശാരീരികസമ്ബന്ധേന തേഷാം വംശസമ്ഭവഃ| ");
INSERT INTO sanmal_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","ഈശ്വരസ്യ വാക്യം വിഫലം ജാതമ് ഇതി നഹി യത്കാരണാദ് ഇസ്രായേലോ വംശേ യേ ജാതാസ്തേ സർവ്വേ വസ്തുത ഇസ്രായേലീയാ ന ഭവന്തി| ");
INSERT INTO sanmal_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","അപരമ് ഇബ്രാഹീമോ വംശേ ജാതാ അപി സർവ്വേ തസ്യൈവ സന്താനാ ന ഭവന്തി കിന്തു ഇസ്ഹാകോ നാമ്നാ തവ വംശോ വിഖ്യാതോ ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","അർഥാത് ശാരീരികസംസർഗാത് ജാതാഃ സന്താനാ യാവന്തസ്താവന്ത ഏവേശ്വരസ്യ സന്താനാ ന ഭവന്തി കിന്തു പ്രതിശ്രവണാദ് യേ ജായന്തേ തഏവേശ്വരവംശോ ഗണ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","യതസ്തത്പ്രതിശ്രുതേ ർവാക്യമേതത്, ഏതാദൃശേ സമയേ ഽഹം പുനരാഗമിഷ്യാമി തത്പൂർവ്വം സാരായാഃ പുത്ര ഏകോ ജനിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","അപരമപി വദാമി സ്വമനോഽഭിലാഷത ഈശ്വരേണ യന്നിരൂപിതം തത് കർമ്മതോ നഹി കിന്ത്വാഹ്വയിതു ർജാതമേതദ് യഥാ സിദ്ധ്യതി ");
INSERT INTO sanmal_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","തദർഥം രിബ്കാനാമികയാ യോഷിതാ ജനൈകസ്മാദ് അർഥാദ് അസ്മാകമ് ഇസ്ഹാകഃ പൂർവ്വപുരുഷാദ് ഗർഭേ ധൃതേ തസ്യാഃ സന്താനയോഃ പ്രസവാത് പൂർവ്വം കിഞ്ച തയോഃ ശുഭാശുഭകർമ്മണഃ കരണാത് പൂർവ്വം ");
INSERT INTO sanmal_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","താം പ്രതീദം വാക്യമ് ഉക്തം, ജ്യേഷ്ഠഃ കനിഷ്ഠം സേവിഷ്യതേ, ");
INSERT INTO sanmal_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","യഥാ ലിഖിതമ് ആസ്തേ, തഥാപ്യേഷാവി ന പ്രീത്വാ യാകൂബി പ്രീതവാൻ അഹം| ");
INSERT INTO sanmal_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","തർഹി വയം കിം ബ്രൂമഃ? ഈശ്വരഃ കിമ് അന്യായകാരീ? തഥാ ന ഭവതു| ");
INSERT INTO sanmal_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","യതഃ സ സ്വയം മൂസാമ് അവദത്; അഹം യസ്മിൻ അനുഗ്രഹം ചികീർഷാമി തമേവാനുഗൃഹ്ലാമി, യഞ്ച ദയിതുമ് ഇച്ഛാമി തമേവ ദയേ| ");
INSERT INTO sanmal_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","അതഏവേച്ഛതാ യതമാനേന വാ മാനവേന തന്ന സാധ്യതേ ദയാകാരിണേശ്വരേണൈവ സാധ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","ഫിരൗണി ശാസ്ത്രേ ലിഖതി, അഹം ത്വദ്ദ്വാരാ മത്പരാക്രമം ദർശയിതും സർവ്വപൃഥിവ്യാം നിജനാമ പ്രകാശയിതുഞ്ച ത്വാം സ്ഥാപിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","അതഃ സ യമ് അനുഗ്രഹീതുമ് ഇച്ഛതി തമേവാനുഗൃഹ്ലാതി, യഞ്ച നിഗ്രഹീതുമ് ഇച്ഛതി തം നിഗൃഹ്ലാതി| ");
INSERT INTO sanmal_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","യദി വദസി തർഹി സ ദോഷം കുതോ ഗൃഹ്ലാതി? തദീയേച്ഛായാഃ പ്രതിബന്ധകത്വം കർത്തം കസ്യ സാമർഥ്യം വിദ്യതേ? ");
INSERT INTO sanmal_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","ഹേ ഈശ്വരസ്യ പ്രതിപക്ഷ മർത്യ ത്വം കഃ? ഏതാദൃശം മാം കുതഃ സൃഷ്ടവാൻ? ഇതി കഥാം സൃഷ്ടവസ്തു സ്രഷ്ട്രേ കിം കഥയിഷ്യതി? ");
INSERT INTO sanmal_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","ഏകസ്മാൻ മൃത്പിണ്ഡാദ് ഉത്കൃഷ്ടാപകൃഷ്ടൗ ദ്വിവിധൗ കലശൗ കർത്തും കിം കുലാലസ്യ സാമർഥ്യം നാസ്തി? ");
INSERT INTO sanmal_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","ഈശ്വരഃ കോപം പ്രകാശയിതും നിജശക്തിം ജ്ഞാപയിതുഞ്ചേച്ഛൻ യദി വിനാശസ്യ യോഗ്യാനി ക്രോധഭാജനാനി പ്രതി ബഹുകാലം ദീർഘസഹിഷ്ണുതാമ് ആശ്രയതി; ");
INSERT INTO sanmal_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","അപരഞ്ച വിഭവപ്രാപ്ത്യർഥം പൂർവ്വം നിയുക്താന്യനുഗ്രഹപാത്രാണി പ്രതി നിജവിഭവസ്യ ബാഹുല്യം പ്രകാശയിതും കേവലയിഹൂദിനാം നഹി ഭിന്നദേശിനാമപി മധ്യാദ് ");
INSERT INTO sanmal_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","അസ്മാനിവ താന്യാഹ്വയതി തത്ര തവ കിം? ");
INSERT INTO sanmal_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","ഹോശേയഗ്രന്ഥേ യഥാ ലിഖിതമ് ആസ്തേ, യോ ലോകോ മമ നാസീത് തം വദിഷ്യാമി മദീയകം| യാ ജാതി ർമേഽപ്രിയാ ചാസീത് താം വദിഷ്യാമ്യഹം പ്രിയാം| ");
INSERT INTO sanmal_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","യൂയം മദീയലോകാ ന യത്രേതി വാക്യമൗച്യത| അമരേശസ്യ സന്താനാ ഇതി ഖ്യാസ്യന്തി തത്ര തേ| ");
INSERT INTO sanmal_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","ഇസ്രായേലീയലോകേഷു യിശായിയോഽപി വാചമേതാം പ്രാചാരയത്, ഇസ്രായേലീയവംശാനാം യാ സംഖ്യാ സാ തു നിശ്ചിതം| സമുദ്രസികതാസംഖ്യാസമാനാ യദി ജായതേ| തഥാപി കേവലം ലോകൈരൽപൈസ്ത്രാണം വ്രജിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","യതോ ന്യായേന സ്വം കർമ്മ പരേശഃ സാധയിഷ്യതി| ദേശേ സഏവ സംക്ഷേപാന്നിജം കർമ്മ കരിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","യിശായിയോഽപരമപി കഥയാമാസ, സൈന്യാധ്യക്ഷപരേശേന ചേത് കിഞ്ചിന്നോദശിഷ്യത| തദാ വയം സിദോമേവാഭവിഷ്യാമ വിനിശ്ചിതം| യദ്വാ വയമ് അമോരായാ അഗമിഷ്യാമ തുല്യതാം| ");
INSERT INTO sanmal_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","തർഹി വയം കിം വക്ഷ്യാമഃ? ഇതരദേശീയാ ലോകാ അപി പുണ്യാർഥമ് അയതമാനാ വിശ്വാസേന പുണ്യമ് അലഭന്ത; ");
INSERT INTO sanmal_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","കിന്ത്വിസ്രായേല്ലോകാ വ്യവസ്ഥാപാലനേന പുണ്യാർഥം യതമാനാസ്തൻ നാലഭന്ത| ");
INSERT INTO sanmal_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","തസ്യ കിം കാരണം? തേ വിശ്വാസേന നഹി കിന്തു വ്യവസ്ഥായാഃ ക്രിയയാ ചേഷ്ടിത്വാ തസ്മിൻ സ്ഖലനജനകേ പാഷാണേ പാദസ്ഖലനം പ്രാപ്താഃ| ");
INSERT INTO sanmal_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","ലിഖിതം യാദൃശമ് ആസ്തേ, പശ്യ പാദസ്ഖലാർഥം ഹി സീയോനി പ്രസ്തരന്തഥാ| ബാധാകാരഞ്ച പാഷാണം പരിസ്ഥാപിതവാനഹമ്| വിശ്വസിഷ്യതി യസ്തത്ര സ ജനോ ന ത്രപിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","ഹേ ഭ്രാതര ഇസ്രായേലീയലോകാ യത് പരിത്രാണം പ്രാപ്നുവന്തി തദഹം മനസാഭിലഷൻ ഈശ്വരസ്യ സമീപേ പ്രാർഥയേ| ");
INSERT INTO sanmal_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","യത ഈശ്വരേ തേഷാം ചേഷ്ടാ വിദ്യത ഇത്യത്രാഹം സാക്ഷ്യസ്മി; കിന്തു തേഷാം സാ ചേഷ്ടാ സജ്ഞാനാ നഹി, ");
INSERT INTO sanmal_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","യതസ്ത ഈശ്വരദത്തം പുണ്യമ് അവിജ്ഞായ സ്വകൃതപുണ്യം സ്ഥാപയിതുമ് ചേഷ്ടമാനാ ഈശ്വരദത്തസ്യ പുണ്യസ്യ നിഘ്നത്വം ന സ്വീകുർവ്വന്തി| ");
INSERT INTO sanmal_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","ഖ്രീഷ്ട ഏകൈകവിശ്വാസിജനായ പുണ്യം ദാതും വ്യവസ്ഥായാഃ ഫലസ്വരൂപോ ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","വ്യവസ്ഥാപാലനേന യത് പുണ്യം തത് മൂസാ വർണയാമാസ, യഥാ, യോ ജനസ്താം പാലയിഷ്യതി സ തദ്ദ്വാരാ ജീവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","കിന്തു പ്രത്യയേന യത് പുണ്യം തദ് ഏതാദൃശം വാക്യം വദതി, കഃ സ്വർഗമ് ആരുഹ്യ ഖ്രീഷ്ടമ് അവരോഹയിഷ്യതി? ");
INSERT INTO sanmal_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","കോ വാ പ്രേതലോകമ് അവരുഹ്യ ഖ്രീഷ്ടം മൃതഗണമധ്യാദ് ആനേഷ്യതീതി വാക് മനസി ത്വയാ ന ഗദിതവ്യാ| ");
INSERT INTO sanmal_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","തർഹി കിം ബ്രവീതി? തദ് വാക്യം തവ സമീപസ്ഥമ് അർഥാത് തവ വദനേ മനസി ചാസ്തേ, തച്ച വാക്യമ് അസ്മാഭിഃ പ്രചാര്യ്യമാണം വിശ്വാസസ്യ വാക്യമേവ| ");
INSERT INTO sanmal_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","വസ്തുതഃ പ്രഭും യീശും യദി വദനേന സ്വീകരോഷി, തഥേശ്വരസ്തം ശ്മശാനാദ് ഉദസ്ഥാപയദ് ഇതി യദ്യന്തഃകരണേന വിശ്വസിഷി തർഹി പരിത്രാണം ലപ്സ്യസേ| ");
INSERT INTO sanmal_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","യസ്മാത് പുണ്യപ്രാപ്ത്യർഥമ് അന്തഃകരണേന വിശ്വസിതവ്യം പരിത്രാണാർഥഞ്ച വദനേന സ്വീകർത്തവ്യം| ");
INSERT INTO sanmal_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","ശാസ്ത്രേ യാദൃശം ലിഖതി വിശ്വസിഷ്യതി യസ്തത്ര സ ജനോ ന ത്രപിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","ഇത്യത്ര യിഹൂദിനി തദന്യലോകേ ച കോപി വിശേഷോ നാസ്തി യസ്മാദ് യഃ സർവ്വേഷാമ് അദ്വിതീയഃ പ്രഭുഃ സ നിജയാചകാന സർവ്വാൻ പ്രതി വദാന്യോ ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","യതഃ, യഃ കശ്ചിത് പരമേശസ്യ നാമ്നാ ഹി പ്രാർഥയിഷ്യതേ| സ ഏവ മനുജോ നൂനം പരിത്രാതോ ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","യം യേ ജനാ ന പ്രത്യായൻ തേ തമുദ്ദിശ്യ കഥം പ്രാർഥയിഷ്യന്തേ? യേ വാ യസ്യാഖ്യാനം കദാപി ന ശ്രുതവന്തസ്തേ തം കഥം പ്രത്യേഷ്യന്തി? അപരം യദി പ്രചാരയിതാരോ ന തിഷ്ഠന്തി തദാ കഥം തേ ശ്രോഷ്യന്തി? ");
INSERT INTO sanmal_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","യദി വാ പ്രേരിതാ ന ഭവന്തി തദാ കഥം പ്രചാരയിഷ്യന്തി? യാദൃശം ലിഖിതമ് ആസ്തേ, യഥാ, മാങ്ഗലികം സുസംവാദം ദദത്യാനീയ യേ നരാഃ| പ്രചാരയന്തി ശാന്തേശ്ച സുസംവാദം ജനാസ്തു യേ| തേഷാം ചരണപദ്മാനി കീദൃക് ശോഭാന്വിതാനി ഹി| ");
INSERT INTO sanmal_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","കിന്തു തേ സർവ്വേ തം സുസംവാദം ന ഗൃഹീതവന്തഃ| യിശായിയോ യഥാ ലിഖിതവാൻ| അസ്മത്പ്രചാരിതേ വാക്യേ വിശ്വാസമകരോദ്ധി കഃ| ");
INSERT INTO sanmal_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","അതഏവ ശ്രവണാദ് വിശ്വാസ ഐശ്വരവാക്യപ്രചാരാത് ശ്രവണഞ്ച ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","തർഹ്യഹം ബ്രവീമി തൈഃ കിം നാശ്രാവി? അവശ്യമ് അശ്രാവി, യസ്മാത് തേഷാം ശബ്ദോ മഹീം വ്യാപ്നോദ് വാക്യഞ്ച നിഖിലം ജഗത്| ");
INSERT INTO sanmal_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","അപരമപി വദാമി, ഇസ്രായേലീയലോകാഃ കിമ് ഏതാം കഥാം ന ബുധ്യന്തേ? പ്രഥമതോ മൂസാ ഇദം വാക്യം പ്രോവാച, അഹമുത്താപയിഷ്യേ താൻ അഗണ്യമാനവൈരപി| ക്ലേക്ഷ്യാമി ജാതിമ് ഏതാഞ്ച പ്രോന്മത്തഭിന്നജാതിഭിഃ| ");
INSERT INTO sanmal_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","അപരഞ്ച യിശായിയോഽതിശയാക്ഷോഭേണ കഥയാമാസ, യഥാ, അധി മാം യൈസ്തു നാചേഷ്ടി സമ്പ്രാപ്തസ്തൈ ർജനൈരഹം| അധി മാം യൈ ർന സമ്പൃഷ്ടം വിജ്ഞാതസ്തൈ ർജനൈരഹം|| ");
INSERT INTO sanmal_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","കിന്ത്വിസ്രായേലീയലോകാൻ അധി കഥയാഞ്ചകാര, യൈരാജ്ഞാലങ്ഘിഭി ർലോകൈ ർവിരുദ്ധം വാക്യമുച്യതേ| താൻ പ്രത്യേവ ദിനം കൃത്സ്നം ഹസ്തൗ വിസ്താരയാമ്യഹം|| ");
INSERT INTO sanmal_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","ഈശ്വരേണ സ്വീകീയലോകാ അപസാരിതാ അഹം കിമ് ഈദൃശം വാക്യം ബ്രവീമി? തന്ന ഭവതു യതോഽഹമപി ബിന്യാമീനഗോത്രീയ ഇബ്രാഹീമവംശീയ ഇസ്രായേലീയലോകോഽസ്മി| ");
INSERT INTO sanmal_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","ഈശ്വരേണ പൂർവ്വം യേ പ്രദൃഷ്ടാസ്തേ സ്വകീയലോകാ അപസാരിതാ ഇതി നഹി| അപരമ് ഏലിയോപാഖ്യാനേ ശാസ്ത്രേ യല്ലിഖിതമ് ആസ്തേ തദ് യൂയം കിം ന ജാനീഥ? ");
INSERT INTO sanmal_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","ഹേ പരമേശ്വര ലോകാസ്ത്വദീയാഃ സർവ്വാ യജ്ഞവേദീരഭഞ്ജൻ തഥാ തവ ഭവിഷ്യദ്വാദിനഃ സർവ്വാൻ അഘ്നൻ കേവല ഏകോഽഹമ് അവശിഷ്ട ആസേ തേ മമാപി പ്രാണാൻ നാശയിതും ചേഷ്ടനതേ, ഏതാം കഥാമ് ഇസ്രായേലീയലോകാനാം വിരുദ്ധമ് ഏലിയ ഈശ്വരായ നിവേദയാമാസ| ");
INSERT INTO sanmal_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","തതസ്തം പ്രതീശ്വരസ്യോത്തരം കിം ജാതം? ബാൽനാമ്നോ ദേവസ്യ സാക്ഷാത് യൈ ർജാനൂനി ന പാതിതാനി താദൃശാഃ സപ്ത സഹസ്രാണി ലോകാ അവശേഷിതാ മയാ| ");
INSERT INTO sanmal_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","തദ്വദ് ഏതസ്മിൻ വർത്തമാനകാലേഽപി അനുഗ്രഹേണാഭിരുചിതാസ്തേഷാമ് അവശിഷ്ടാഃ കതിപയാ ലോകാഃ സന്തി| ");
INSERT INTO sanmal_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","അതഏവ തദ് യദ്യനുഗ്രഹേണ ഭവതി തർഹി ക്രിയയാ ന ഭവതി നോ ചേദ് അനുഗ്രഹോഽനനുഗ്രഹ ഏവ, യദി വാ ക്രിയയാ ഭവതി തർഹ്യനുഗ്രഹേണ ന ഭവതി നോ ചേത് ക്രിയാ ക്രിയൈവ ന ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","തർഹി കിം? ഇസ്രായേലീയലോകാ യദ് അമൃഗയന്ത തന്ന പ്രാപുഃ| കിന്ത്വഭിരുചിതലോകാസ്തത് പ്രാപുസ്തദന്യേ സർവ്വ അന്ധീഭൂതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","യഥാ ലിഖിതമ് ആസ്തേ, ഘോരനിദ്രാലുതാഭാവം ദൃഷ്ടിഹീനേ ച ലോചനേ| കർണൗ ശ്രുതിവിഹീനൗ ച പ്രദദൗ തേഭ്യ ഈശ്വരഃ|| ");
INSERT INTO sanmal_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","ഏതേസ്മിൻ ദായൂദപി ലിഖിതവാൻ യഥാ, അതോ ഭുക്ത്യാസനം തേഷാമ് ഉന്മാഥവദ് ഭവിഷ്യതി| വാ വംശയന്ത്രവദ് ബാധാ ദണ്ഡവദ് വാ ഭവിഷ്യതി|| ");
INSERT INTO sanmal_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","ഭവിഷ്യന്തി തഥാന്ധാസ്തേ നേത്രൈഃ പശ്യന്തി നോ യഥാ| വേപഥുഃ കടിദേശസ്യ തേഷാം നിത്യം ഭവിഷ്യതി|| ");
INSERT INTO sanmal_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","പതനാർഥം തേ സ്ഖലിതവന്ത ഇതി വാചം കിമഹം വദാമി? തന്ന ഭവതു കിന്തു താൻ ഉദ്യോഗിനഃ കർത്തും തേഷാം പതനാദ് ഇതരദേശീയലോകൈഃ പരിത്രാണം പ്രാപ്തം| ");
INSERT INTO sanmal_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","തേഷാം പതനം യദി ജഗതോ ലോകാനാം ലാഭജനകമ് അഭവത് തേഷാം ഹ്രാസോഽപി യദി ഭിന്നദേശിനാം ലാഭജനകോഽഭവത് തർഹി തേഷാം വൃദ്ധിഃ കതി ലാഭജനികാ ഭവിഷ്യതി? ");
INSERT INTO sanmal_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","അതോ ഹേ അന്യദേശിനോ യുഷ്മാൻ സമ്ബോധ്യ കഥയാമി നിജാനാം ജ്ഞാതിബന്ധൂനാം മനഃസൂദ്യോഗം ജനയൻ തേഷാം മധ്യേ കിയതാം ലോകാനാം യഥാ പരിത്രാണം സാധയാമി ");
INSERT INTO sanmal_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","തന്നിമിത്തമ് അന്യദേശിനാം നികടേ പ്രേരിതഃ സൻ അഹം സ്വപദസ്യ മഹിമാനം പ്രകാശയാമി| ");
INSERT INTO sanmal_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","തേഷാം നിഗ്രഹേണ യദീശ്വരേണ സഹ ജഗതോ ജനാനാം മേലനം ജാതം തർഹി തേഷാമ് അനുഗൃഹീതത്വം മൃതദേഹേ യഥാ ജീവനലാഭസ്തദ്വത് കിം ന ഭവിഷ്യതി? ");
INSERT INTO sanmal_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","അപരം പ്രഥമജാതം ഫലം യദി പവിത്രം ഭവതി തർഹി സർവ്വമേവ ഫലം പവിത്രം ഭവിഷ്യതി; തഥാ മൂലം യദി പവിത്രം ഭവതി തർഹി ശാഖാ അപി തഥൈവ ഭവിഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","കിയതീനാം ശാഖാനാം ഛേദനേ കൃതേ ത്വം വന്യജിതവൃക്ഷസ്യ ശാഖാ ഭൂത്വാ യദി തച്ഛാഖാനാം സ്ഥാനേ രോപിതാ സതി ജിതവൃക്ഷീയമൂലസ്യ രസം ഭുംക്ഷേ, ");
INSERT INTO sanmal_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","തർഹി താസാം ഭിന്നശാഖാനാം വിരുദ്ധം മാം ഗർവ്വീഃ; യദി ഗർവ്വസി തർഹി ത്വം മൂലം യന്ന ധാരയസി കിന്തു മൂലം ത്വാം ധാരയതീതി സംസ്മര| ");
INSERT INTO sanmal_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","അപരഞ്ച യദി വദസി മാം രോപയിതും താഃ ശാഖാ വിഭന്നാ അഭവൻ; ");
INSERT INTO sanmal_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","ഭദ്രമ്, അപ്രത്യയകാരണാത് തേ വിഭിന്നാ ജാതാസ്തഥാ വിശ്വാസകാരണാത് ത്വം രോപിതോ ജാതസ്തസ്മാദ് അഹങ്കാരമ് അകൃത്വാ സസാധ്വസോ ഭവ| ");
INSERT INTO sanmal_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","യത ഈശ്വരോ യദി സ്വാഭാവികീഃ ശാഖാ ന രക്ഷതി തർഹി സാവധാനോ ഭവ ചേത് ത്വാമപി ന സ്ഥാപയതി| ");
INSERT INTO sanmal_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","ഇത്യത്രേശ്വരസ്യ യാദൃശീ കൃപാ താദൃശം ഭയാനകത്വമപി ത്വയാ ദൃശ്യതാം; യേ പതിതാസ്താൻ പ്രതി തസ്യ ഭയാനകത്വം ദൃശ്യതാം, ത്വഞ്ച യദി തത്കൃപാശ്രിതസ്തിഷ്ഠസി തർഹി ത്വാം പ്രതി കൃപാ ദ്രക്ഷ്യതേ; നോ ചേത് ത്വമപി തദ്വത് ഛിന്നോ ഭവിഷ്യസി| ");
INSERT INTO sanmal_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","അപരഞ്ച തേ യദ്യപ്രത്യയേ ന തിഷ്ഠന്തി തർഹി പുനരപി രോപയിഷ്യന്തേ യസ്മാത് താൻ പുനരപി രോപയിതുമ് ഇശ്വരസ്യ ശക്തിരാസ്തേ| ");
INSERT INTO sanmal_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","വന്യജിതവൃക്ഷസ്യ ശാഖാ സൻ ത്വം യദി തതശ്ഛിന്നോ രീതിവ്യത്യയേനോത്തമജിതവൃക്ഷേ രോेेപിതോഽഭവസ്തർഹി തസ്യ വൃക്ഷസ്യ സ്വീയാ യാഃ ശാഖാസ്താഃ കിം പുനഃ സ്വവൃക്ഷേ സംലഗിതും ന ശക്നുവന്തി? ");
INSERT INTO sanmal_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","ഹേ ഭ്രാതരോ യുഷ്മാകമ് ആത്മാഭിമാനോ യന്ന ജായതേ തദർഥം മമേദൃശീ വാഞ്ഛാ ഭവതി യൂയം ഏതന്നിഗൂഢതത്ത്വമ് അജാനന്തോ യന്ന തിഷ്ഠഥ; വസ്തുതോ യാവത്കാലം സമ്പൂർണരൂപേണ ഭിന്നദേശിനാം സംഗ്രഹോ ന ഭവിഷ്യതി താവത്കാലമ് അംശത്വേന ഇസ്രായേലീയലോകാനാമ് അന്ധതാ സ്ഥാസ്യതി; ");
INSERT INTO sanmal_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","പശ്ചാത് തേ സർവ്വേ പരിത്രാസ്യന്തേ; ഏതാദൃശം ലിഖിതമപ്യാസ്തേ, ആഗമിഷ്യതി സീയോനാദ് ഏകോ യസ്ത്രാണദായകഃ| അധർമ്മം യാകുബോ വംശാത് സ തു ദൂരീകരിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","തഥാ ദൂരീകരിഷ്യാമി തേഷാം പാപാന്യഹം യദാ| തദാ തൈരേവ സാർദ്ധം മേ നിയമോഽയം ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","സുസംവാദാത് തേ യുഷ്മാകം വിപക്ഷാ അഭവൻ കിന്ത്വഭിരുചിതത്വാത് തേ പിതൃലോകാനാം കൃതേ പ്രിയപാത്രാണി ഭവന്തി| ");
INSERT INTO sanmal_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","യത ഈശ്വരസ്യ ദാനാദ് ആഹ്വാനാഞ്ച പശ്ചാത്താപോ ന ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","അതഏവ പൂർവ്വമ് ഈശ്വരേഽവിശ്വാസിനഃ സന്തോഽപി യൂയം യദ്വത് സമ്പ്രതി തേഷാമ് അവിശ്വാസകാരണാദ് ഈശ്വരസ്യ കൃപാപാത്രാണി ജാതാസ്തദ്വദ് ");
INSERT INTO sanmal_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","ഇദാനീം തേഽവിശ്വാസിനഃ സന്തി കിന്തു യുഷ്മാഭി ർലബ്ധകൃപാകാരണാത് തൈരപി കൃപാ ലപ്സ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","ഈശ്വരഃ സർവ്വാൻ പ്രതി കൃപാം പ്രകാശയിതും സർവ്വാൻ അവിശ്വാസിത്വേന ഗണയതി| ");
INSERT INTO sanmal_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","അഹോ ഈശ്വരസ്യ ജ്ഞാനബുദ്ധിരൂപയോ ർധനയോഃ കീദൃക് പ്രാചുര്യ്യം| തസ്യ രാജശാസനസ്യ തത്ത്വം കീദൃഗ് അപ്രാപ്യം| തസ്യ മാർഗാശ്ച കീദൃഗ് അനുപലക്ഷ്യാഃ| ");
INSERT INTO sanmal_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","പരമേശ്വരസ്യ സങ്കൽപം കോ ജ്ഞാതവാൻ? തസ്യ മന്ത്രീ വാ കോഽഭവത്? ");
INSERT INTO sanmal_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","കോ വാ തസ്യോപകാരീ ഭൃത്വാ തത്കൃതേ തേന പ്രത്യുപകർത്തവ്യഃ? ");
INSERT INTO sanmal_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","യതോ വസ്തുമാത്രമേവ തസ്മാത് തേന തസ്മൈ ചാഭവത് തദീയോ മഹിമാ സർവ്വദാ പ്രകാശിതോ ഭവതു| ഇതി| ");
INSERT INTO sanmal_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","ഹേ ഭ്രാതര ഈശ്വരസ്യ കൃപയാഹം യുഷ്മാൻ വിനയേ യൂയം സ്വം സ്വം ശരീരം സജീവം പവിത്രം ഗ്രാഹ്യം ബലിമ് ഈശ്വരമുദ്ദിശ്യ സമുത്സൃജത, ഏഷാ സേവാ യുഷ്മാകം യോഗ്യാ| ");
INSERT INTO sanmal_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","അപരം യൂയം സാംസാരികാ ഇവ മാചരത, കിന്തു സ്വം സ്വം സ്വഭാവം പരാവർത്യ നൂതനാചാരിണോ ഭവത, തത ഈശ്വരസ്യ നിദേശഃ കീദൃഗ് ഉത്തമോ ഗ്രഹണീയഃ സമ്പൂർണശ്ചേതി യുഷ്മാഭിരനുഭാവിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","കശ്ചിദപി ജനോ യോഗ്യത്വാദധികം സ്വം ന മന്യതാം കിന്തു ഈശ്വരോ യസ്മൈ പ്രത്യയസ്യ യത്പരിമാണമ് അദദാത് സ തദനുസാരതോ യോഗ്യരൂപം സ്വം മനുതാമ്, ഈശ്വരാദ് അനുഗ്രഹം പ്രാപ്തഃ സൻ യുഷ്മാകമ് ഏകൈകം ജനമ് ഇത്യാജ്ഞാപയാമി| ");
INSERT INTO sanmal_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","യതോ യദ്വദസ്മാകമ് ഏകസ്മിൻ ശരീരേ ബഹൂന്യങ്ഗാനി സന്തി കിന്തു സർവ്വേഷാമങ്ഗാനാം കാര്യ്യം സമാനം നഹി; ");
INSERT INTO sanmal_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","തദ്വദസ്മാകം ബഹുത്വേഽപി സർവ്വേ വയം ഖ്രീഷ്ടേ ഏകശരീരാഃ പരസ്പരമ് അങ്ഗപ്രത്യങ്ഗത്വേന ഭവാമഃ| ");
INSERT INTO sanmal_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","അസ്മാദ് ഈശ്വരാനുഗ്രഹേണ വിശേഷം വിശേഷം ദാനമ് അസ്മാസു പ്രാപ്തേഷു സത്സു കോപി യദി ഭവിഷ്യദ്വാക്യം വദതി തർഹി പ്രത്യയസ്യ പരിമാണാനുസാരതഃ സ തദ് വദതു; ");
INSERT INTO sanmal_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","യദ്വാ യദി കശ്ചിത് സേവനകാരീ ഭവതി തർഹി സ തത്സേവനം കരോതു; അഥവാ യദി കശ്ചിദ് അധ്യാപയിതാ ഭവതി തർഹി സോഽധ്യാപയതു; ");
INSERT INTO sanmal_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","തഥാ യ ഉപദേഷ്ടാ ഭവതി സ ഉപദിശതു യശ്ച ദാതാ സ സരലതയാ ദദാതു യസ്ത്വധിപതിഃ സ യത്നേനാധിപതിത്വം കരോതു യശ്ച ദയാലുഃ സ ഹൃഷ്ടമനസാ ദയതാമ്| ");
INSERT INTO sanmal_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","അപരഞ്ച യുഷ്മാകം പ്രേമ കാപട്യവർജിതം ഭവതു യദ് അഭദ്രം തദ് ഋതീയധ്വം യച്ച ഭദ്രം തസ്മിൻ അനുരജ്യധ്വമ്| ");
INSERT INTO sanmal_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","അപരം ഭ്രാതൃത്വപ്രേമ്നാ പരസ്പരം പ്രീയധ്വം സമാദരാദ് ഏകോഽപരജനം ശ്രേഷ്ഠം ജാനീധ്വമ്| ");
INSERT INTO sanmal_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","തഥാ കാര്യ്യേ നിരാലസ്യാ മനസി ച സോദ്യോഗാഃ സന്തഃ പ്രഭും സേവധ്വമ്| ");
INSERT INTO sanmal_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","അപരം പ്രത്യാശായാമ് ആനന്ദിതാ ദുഃഖസമയേ ച ധൈര്യ്യയുക്താ ഭവത; പ്രാർഥനായാം സതതം പ്രവർത്തധ്വം| ");
INSERT INTO sanmal_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","പവിത്രാണാം ദീനതാം ദൂരീകുരുധ്വമ് അതിഥിസേവായാമ് അനുരജ്യധ്വമ്| ");
INSERT INTO sanmal_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","യേ ജനാ യുഷ്മാൻ താഡയന്തി താൻ ആശിഷം വദത ശാപമ് അദത്ത്വാ ദദ്ധ്വമാശിഷമ്| ");
INSERT INTO sanmal_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","യേ ജനാ ആനന്ദന്തി തൈഃ സാർദ്ധമ് ആനന്ദത യേ ച രുദന്തി തൈഃ സഹ രുദിത| ");
INSERT INTO sanmal_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","അപരഞ്ച യുഷ്മാകം മനസാം പരസ്പരമ് ഏകോഭാവോ ഭവതു; അപരമ് ഉച്ചപദമ് അനാകാങ്ക്ഷ്യ നീചലോകൈഃ സഹാപി മാർദവമ് ആചരത; സ്വാൻ ജ്ഞാനിനോ ന മന്യധ്വം| ");
INSERT INTO sanmal_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","പരസ്മാദ് അപകാരം പ്രാപ്യാപി പരം നാപകുരുത| സർവ്വേഷാം ദൃഷ്ടിതോ യത് കർമ്മോത്തമം തദേവ കുരുത| ");
INSERT INTO sanmal_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","യദി ഭവിതും ശക്യതേ തർഹി യഥാശക്തി സർവ്വലോകൈഃ സഹ നിർവ്വിരോധേന കാലം യാപയത| ");
INSERT INTO sanmal_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","ഹേ പ്രിയബന്ധവഃ, കസ്മൈചിദ് അപകാരസ്യ സമുചിതം ദണ്ഡം സ്വയം ന ദദ്ധ്വം, കിന്ത്വീശ്വരീയക്രോധായ സ്ഥാനം ദത്ത യതോ ലിഖിതമാസ്തേ പരമേശ്വരഃ കഥയതി, ദാനം ഫലസ്യ മത്കർമ്മ സൂചിതം പ്രദദാമ്യഹം| ");
INSERT INTO sanmal_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","ഇതികാരണാദ് രിപു ര്യദി ക്ഷുധാർത്തസ്തേ തർഹി തം ത്വം പ്രഭോജയ| തഥാ യദി തൃഷാർത്തഃ സ്യാത് തർഹി തം പരിപായയ| തേന ത്വം മസ്തകേ തസ്യ ജ്വലദഗ്നിം നിധാസ്യസി| ");
INSERT INTO sanmal_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","കുക്രിയയാ പരാജിതാ ന സന്ത ഉത്തമക്രിയയാ കുക്രിയാം പരാജയത| ");
INSERT INTO sanmal_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","യുഷ്മാകമ് ഏകൈകജനഃ ശാസനപദസ്യ നിഘ്നോ ഭവതു യതോ യാനി ശാസനപദാനി സന്തി താനി സർവ്വാണീശ്വരേണ സ്ഥാപിതാനി; ഈശ്വരം വിനാ പദസ്ഥാപനം ന ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","ഇതി ഹേതോഃ ശാസനപദസ്യ യത് പ്രാതികൂല്യം തദ് ഈശ്വരീയനിരൂപണസ്യ പ്രാതികൂല്യമേവ; അപരം യേ പ്രാതികൂല്യമ് ആചരന്തി തേ സ്വേഷാം സമുചിതം ദണ്ഡം സ്വയമേവ ഘടയന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","ശാസ്താ സദാചാരിണാം ഭയപ്രദോ നഹി ദുരാചാരിണാമേവ ഭയപ്രദോ ഭവതി; ത്വം കിം തസ്മാൻ നിർഭയോ ഭവിതുമ് ഇച്ഛസി? തർഹി സത്കർമ്മാചര, തസ്മാദ് യശോ ലപ്സ്യസേ, ");
INSERT INTO sanmal_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","യതസ്തവ സദാചരണായ സ ഈശ്വരസ്യ ഭൃത്യോഽസ്തി| കിന്തു യദി കുകർമ്മാചരസി തർഹി ത്വം ശങ്കസ്വ യതഃ സ നിരർഥകം ഖങ്ഗം ന ധാരയതി; കുകർമ്മാചാരിണം സമുചിതം ദണ്ഡയിതുമ് സ ഈശ്വരസ്യ ദണ്ഡദഭൃത്യ ഏവ| ");
INSERT INTO sanmal_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","അതഏവ കേവലദണ്ഡഭയാന്നഹി കിന്തു സദസദ്ബോധാദപി തസ്യ വശ്യേന ഭവിതവ്യം| ");
INSERT INTO sanmal_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","ഏതസ്മാദ് യുഷ്മാകം രാജകരദാനമപ്യുചിതം യസ്മാദ് യേ കരം ഗൃഹ്ലന്തി ത ഈശ്വരസ്യ കിങ്കരാ ഭൂത്വാ സതതമ് ഏതസ്മിൻ കർമ്മണി നിവിഷ്ടാസ്തിഷ്ഠന്തി| ");
INSERT INTO sanmal_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","അസ്മാത് കരഗ്രാഹിണേ കരം ദത്ത, തഥാ ശുൽകഗ്രാഹിണേ ശുൽകം ദത്ത, അപരം യസ്മാദ് ഭേതവ്യം തസ്മാദ് ബിഭീത, യശ്ച സമാദരണീയസ്തം സമാദ്രിയധ്വമ്; ഇത്ഥം യസ്യ യത് പ്രാപ്യം തത് തസ്മൈ ദത്ത| ");
INSERT INTO sanmal_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","യുഷ്മാകം പരസ്പരം പ്രേമ വിനാ ഽന്യത് കിമപി ദേയമ് ഋണം ന ഭവതു, യതോ യഃ പരസ്മിൻ പ്രേമ കരോതി തേന വ്യവസ്ഥാ സിധ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","വസ്തുതഃ പരദാരാൻ മാ ഗച്ഛ, നരഹത്യാം മാ കാർഷീഃ, ചൈര്യ്യം മാ കാർഷീഃ, മിഥ്യാസാക്ഷ്യം മാ ദേഹി, ലോഭം മാ കാർഷീഃ, ഏതാഃ സർവ്വാ ആജ്ഞാ ഏതാഭ്യോ ഭിന്നാ യാ കാചിദ് ആജ്ഞാസ്തി സാപി സ്വസമീപവാസിനി സ്വവത് പ്രേമ കുർവ്വിത്യനേന വചനേന വേദിതാ| ");
INSERT INTO sanmal_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","യതഃ പ്രേമ സമീപവാസിനോഽശുഭം ന ജനയതി തസ്മാത് പ്രേമ്നാ സർവ്വാ വ്യവസ്ഥാ പാല്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","പ്രത്യയീഭവനകാലേഽസ്മാകം പരിത്രാണസ്യ സാമീപ്യാദ് ഇദാനീം തസ്യ സാമീപ്യമ് അവ്യവഹിതം; അതഃ സമയം വിവിച്യാസ്മാഭിഃ സാമ്പ്രതമ് അവശ്യമേവ നിദ്രാതോ ജാഗർത്തവ്യം| ");
INSERT INTO sanmal_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","ബഹുതരാ യാമിനീ ഗതാ പ്രഭാതം സന്നിധിം പ്രാപ്തം തസ്മാത് താമസീയാഃ ക്രിയാഃ പരിത്യജ്യാസ്മാഭി ർവാസരീയാ സജ്ജാ പരിധാതവ്യാ| ");
INSERT INTO sanmal_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","അതോ ഹേതോ ർവയം ദിവാ വിഹിതം സദാചരണമ് ആചരിഷ്യാമഃ| രങ്ഗരസോ മത്തത്വം ലമ്പടത്വം കാമുകത്വം വിവാദ ഈർഷ്യാ ചൈതാനി പരിത്യക്ഷ്യാമഃ| ");
INSERT INTO sanmal_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","യൂയം പ്രഭുയീശുഖ്രീഷ്ടരൂപം പരിച്ഛദം പരിധദ്ധ്വം സുഖാഭിലാഷപൂരണായ ശാരീരികാചരണം മാചരത| ");
INSERT INTO sanmal_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","യോ ജനോഽദൃഢവിശ്വാസസ്തം യുഷ്മാകം സങ്ഗിനം കുരുത കിന്തു സന്ദേഹവിചാരാർഥം നഹി| ");
INSERT INTO sanmal_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","യതോ നിഷിദ്ധം കിമപി ഖാദ്യദ്രവ്യം നാസ്തി, കസ്യചിജ്ജനസ്യ പ്രത്യയ ഏതാദൃശോ വിദ്യതേ കിന്ത്വദൃഢവിശ്വാസഃ കശ്ചിദപരോ ജനഃ കേവലം ശാകം ഭുങ്ക്തം| ");
INSERT INTO sanmal_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","തർഹി യോ ജനഃ സാധാരണം ദ്രവ്യം ഭുങ്ക്തേ സ വിശേഷദ്രവ്യഭോക്താരം നാവജാനീയാത് തഥാ വിശേഷദ്രവ്യഭോക്താപി സാധാരണദ്രവ്യഭോക്താരം ദോഷിണം ന കുര്യ്യാത്, യസ്മാദ് ഈശ്വരസ്തമ് അഗൃഹ്ലാത്| ");
INSERT INTO sanmal_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","ഹേ പരദാസസ്യ ദൂഷയിതസ്ത്വം കഃ? നിജപ്രഭോഃ സമീപേ തേന പദസ്ഥേന പദച്യുതേന വാ ഭവിതവ്യം സ ച പദസ്ഥ ഏവ ഭവിഷ്യതി യത ഈശ്വരസ്തം പദസ്ഥം കർത്തും ശക്നോതി| ");
INSERT INTO sanmal_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","അപരഞ്ച കശ്ചിജ്ജനോ ദിനാദ് ദിനം വിശേഷം മന്യതേ കശ്ചിത്തുु സർവ്വാണി ദിനാനി സമാനാനി മന്യതേ, ഏകൈകോ ജനഃ സ്വീയമനസി വിവിച്യ നിശ്ചിനോതു| ");
INSERT INTO sanmal_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","യോ ജനഃ കിഞ്ചന ദിനം വിശേഷം മന്യതേ സ പ്രഭുഭക്ത്യാ തൻ മന്യതേ, യശ്ച ജനഃ കിമപി ദിനം വിശേഷം ന മന്യതേ സോഽപി പ്രഭുഭക്ത്യാ തന്ന മന്യതേ; അപരഞ്ച യഃ സർവ്വാണി ഭക്ഷ്യദ്രവ്യാണി ഭുങ്ക്തേ സ പ്രഭുഭക്തയാ താനി ഭുങ്ക്തേ യതഃ സ ഈശ്വരം ധന്യം വക്തി, യശ്ച ന ഭുങ്ക്തേ സോഽപി പ്രഭുഭക്ത്യൈവ ന ഭുഞ്ജാന ഈശ്വരം ധന്യം ബ്രൂതേ| ");
INSERT INTO sanmal_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","അപരമ് അസ്മാകം കശ്ചിത് നിജനിമിത്തം പ്രാണാൻ ധാരയതി നിജനിമിത്തം മ്രിയതേ വാ തന്ന; ");
INSERT INTO sanmal_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","കിന്തു യദി വയം പ്രാണാൻ ധാരയാമസ്തർഹി പ്രഭുനിമിത്തം ധാരയാമഃ, യദി ച പ്രാണാൻ ത്യജാമസ്തർഹ്യപി പ്രഭുനിമിത്തം ത്യജാമഃ, അതഏവ ജീവനേ മരണേ വാ വയം പ്രഭോരേവാസ്മഹേ| ");
INSERT INTO sanmal_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","യതോ ജീവന്തോ മൃതാശ്ചേത്യുഭയേഷാം ലോകാനാം പ്രഭുത്വപ്രാപ്ത്യർഥം ഖ്രീഷ്ടോ മൃത ഉത്ഥിതഃ പുനർജീവിതശ്ച| ");
INSERT INTO sanmal_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","കിന്തു ത്വം നിജം ഭ്രാതരം കുതോ ദൂഷയസി? തഥാ ത്വം നിജം ഭ്രാതരം കുതസ്തുച്ഛം ജാനാസി? ഖ്രീഷ്ടസ്യ വിചാരസിംഹാസനസ്യ സമ്മുഖേ സർവ്വൈരസ്മാഭിരുപസ്ഥാതവ്യം; ");
INSERT INTO sanmal_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","യാദൃശം ലിഖിതമ് ആസ്തേ, പരേശഃ ശപഥം കുർവ്വൻ വാക്യമേതത് പുരാവദത്| സർവ്വോ ജനഃ സമീപേ മേ ജാനുപാതം കരിഷ്യതി| ജിഹ്വൈകൈകാ തഥേശസ്യ നിഘ്നത്വം സ്വീകരിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","അതഏവ ഈശ്വരസമീപേഽസ്മാകമ് ഏകൈകജനേന നിജാ കഥാ കഥയിതവ്യാ| ");
INSERT INTO sanmal_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","ഇത്ഥം സതി വയമ് അദ്യാരഭ്യ പരസ്പരം ന ദൂഷയന്തഃ സ്വഭ്രാതു ർവിഘ്നോ വ്യാഘാതോ വാ യന്ന ജായേത താദൃശീമീഹാം കുർമ്മഹേ| ");
INSERT INTO sanmal_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","കിമപി വസ്തു സ്വഭാവതോ നാശുചി ഭവതീത്യഹം ജാനേ തഥാ പ്രഭുനാ യീശുഖ്രീഷ്ടേനാപി നിശ്ചിതം ജാനേ, കിന്തു യോ ജനോ യദ് ദ്രവ്യമ് അപവിത്രം ജാനീതേ തസ്യ കൃതേ തദ് അപവിത്രമ് ആസ്തേ| ");
INSERT INTO sanmal_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","അതഏവ തവ ഭക്ഷ്യദ്രവ്യേണ തവ ഭ്രാതാ ശോകാന്വിതോ ഭവതി തർഹി ത്വം ഭ്രാതരം പ്രതി പ്രേമ്നാ നാചരസി| ഖ്രീഷ്ടോ യസ്യ കൃതേ സ്വപ്രാണാൻ വ്യയിതവാൻ ത്വം നിജേന ഭക്ഷ്യദ്രവ്യേണ തം ന നാശയ| ");
INSERT INTO sanmal_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","അപരം യുഷ്മാകമ് ഉത്തമം കർമ്മ നിന്ദിതം ന ഭവതു| ");
INSERT INTO sanmal_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","ഭക്ഷ്യം പേയഞ്ചേശ്വരരാജ്യസ്യ സാരോ നഹി, കിന്തു പുണ്യം ശാന്തിശ്ച പവിത്രേണാത്മനാ ജാത ആനന്ദശ്ച| ");
INSERT INTO sanmal_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","ഏതൈ ര്യോ ജനഃ ഖ്രീഷ്ടം സേവതേ, സ ഏവേശ്വരസ്യ തുഷ്ടികരോ മനുഷ്യൈശ്ച സുഖ്യാതഃ| ");
INSERT INTO sanmal_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","അതഏവ യേനാസ്മാകം സർവ്വേഷാം പരസ്പരമ് ഐക്യം നിഷ്ഠാ ച ജായതേ തദേവാസ്മാഭി ര്യതിതവ്യം| ");
INSERT INTO sanmal_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","ഭക്ഷ്യാർഥമ് ഈശ്വരസ്യ കർമ്മണോ ഹാനിം മാ ജനയത; സർവ്വം വസ്തു പവിത്രമിതി സത്യം തഥാപി യോ ജനോ യദ് ഭുക്ത്വാ വിഘ്നം ലഭതേ തദർഥം തദ് ഭദ്രം നഹി| ");
INSERT INTO sanmal_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","തവ മാംസഭക്ഷണസുരാപാനാദിഭിഃ ക്രിയാഭി ര്യദി തവ ഭ്രാതുഃ പാദസ്ഖലനം വിഘ്നോ വാ ചാഞ്ചല്യം വാ ജായതേ തർഹി തദ്ഭോജനപാനയോസ്ത്യാഗോ ഭദ്രഃ| ");
INSERT INTO sanmal_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","യദി തവ പ്രത്യയസ്തിഷ്ഠതി തർഹീശ്വരസ്യ ഗോചരേ സ്വാന്തരേ തം ഗോപയ; യോ ജനഃ സ്വമതേന സ്വം ദോഷിണം ന കരോതി സ ഏവ ധന്യഃ| ");
INSERT INTO sanmal_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","കിന്തു യഃ കശ്ചിത് സംശയ്യ ഭുങ്ക്തേഽർഥാത് ന പ്രതീത്യ ഭുങ്ക്തേ, സ ഏവാവശ്യം ദണ്ഡാർഹോ ഭവിഷ്യതി, യതോ യത് പ്രത്യയജം നഹി തദേവ പാപമയം ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","ബലവദ്ഭിരസ്മാഭി ർദുർബ്ബലാനാം ദൗർബ്ബല്യം സോഢവ്യം ന ച സ്വേഷാമ് ഇഷ്ടാചാര ആചരിതവ്യഃ| ");
INSERT INTO sanmal_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","അസ്മാകമ് ഏകൈകോ ജനഃ സ്വസമീപവാസിനോ ഹിതാർഥം നിഷ്ഠാർഥഞ്ച തസ്യൈവേഷ്ടാചാരമ് ആചരതു| ");
INSERT INTO sanmal_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","യതഃ ഖ്രീഷ്ടോഽപി നിജേഷ്ടാചാരം നാചരിതവാൻ, യഥാ ലിഖിതമ് ആസ്തേ, ത്വന്നിന്ദകഗണസ്യൈവ നിന്ദാഭി ർനിന്ദിതോഽസ്മ്യഹം| ");
INSERT INTO sanmal_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","അപരഞ്ച വയം യത് സഹിഷ്ണുതാസാന്ത്വനയോ ർജനകേന ശാസ്ത്രേണ പ്രത്യാശാം ലഭേമഹി തന്നിമിത്തം പൂർവ്വകാലേ ലിഖിതാനി സർവ്വവചനാന്യസ്മാകമ് ഉപദേശാർഥമേവ ലിലിഖിരേ| ");
INSERT INTO sanmal_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","സഹിഷ്ണുതാസാന്ത്വനയോരാകരോ യ ഈശ്വരഃ സ ഏവം കരോതു യത് പ്രഭു ര്യീശുഖ്രീഷ്ട ഇവ യുഷ്മാകമ് ഏകജനോഽന്യജനേന സാർദ്ധം മനസ ഐക്യമ് ആചരേത്; ");
INSERT INTO sanmal_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","യൂയഞ്ച സർവ്വ ഏകചിത്താ ഭൂത്വാ മുഖൈകേനേവാസ്മത്പ്രഭുയീശുഖ്രീഷ്ടസ്യ പിതുരീശ്വരസ്യ ഗുണാൻ കീർത്തയേത| ");
INSERT INTO sanmal_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","അപരമ് ഈശ്വരസ്യ മഹിമ്നഃ പ്രകാശാർഥം ഖ്രീഷ്ടോ യഥാ യുഷ്മാൻ പ്രത്യഗൃഹ്ലാത് തഥാ യുഷ്മാകമപ്യേകോ ജനോഽന്യജനം പ്രതിഗൃഹ്ലാതു| ");
INSERT INTO sanmal_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","യഥാ ലിഖിതമ് ആസ്തേ, അതോഽഹം സമ്മുഖേ തിഷ്ഠൻ ഭിന്നദേശനിവാസിനാം| സ്തുവംസ്ത്വാം പരിഗാസ്യാമി തവ നാമ്നി പരേശ്വര|| ");
INSERT INTO sanmal_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","തസ്യ ദയാലുത്വാച്ച ഭിന്നജാതീയാ യദ് ഈശ്വരസ്യ ഗുണാൻ കീർത്തയേയുസ്തദർഥം യീശുഃ ഖ്രീഷ്ടസ്ത്വക്ഛേദനിയമസ്യ നിഘ്നോഽഭവദ് ഇത്യഹം വദാമി| യഥാ ലിഖിതമ് ആസ്തേ, അതോഽഹം സമ്മുഖേ തിഷ്ഠൻ ഭിന്നദേശനിവാസിനാം| സ്തുവംസ്ത്വാം പരിഗാസ്യാമി തവ നാമ്നി പരേശ്വര|| ");
INSERT INTO sanmal_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","അപരമപി ലിഖിതമ് ആസ്തേ, ഹേ അന്യജാതയോ യൂയം സമം നന്ദത തജ്ജനൈഃ| ");
INSERT INTO sanmal_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","പുനശ്ച ലിഖിതമ് ആസ്തേ, ഹേ സർവ്വദേശിനോ യൂയം ധന്യം ബ്രൂത പരേശ്വരം| ഹേ തദീയനരാ യൂയം കുരുധ്വം തത്പ്രശംസനം|| ");
INSERT INTO sanmal_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","അപര യീശായിയോഽപി ലിലേഖ, യീശയസ്യ തു യത് മൂലം തത് പ്രകാശിഷ്യതേ തദാ| സർവ്വജാതീയനൃണാഞ്ച ശാസകഃ സമുദേഷ്യതി| തത്രാന്യദേശിലോകൈശ്ച പ്രത്യാശാ പ്രകരിഷ്യതേ|| ");
INSERT INTO sanmal_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","അതഏവ യൂയം പവിത്രസ്യാത്മനഃ പ്രഭാവാദ് യത് സമ്പൂർണാം പ്രത്യാശാം ലപ്സ്യധ്വേ തദർഥം തത്പ്രത്യാശാജനക ഈശ്വരഃ പ്രത്യയേന യുഷ്മാൻ ശാന്ത്യാനന്ദാഭ്യാം സമ്പൂർണാൻ കരോതു| ");
INSERT INTO sanmal_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","ഹേ ഭ്രാതരോ യൂയം സദ്ഭാവയുക്താഃ സർവ്വപ്രകാരേണ ജ്ഞാനേന ച സമ്പൂർണാഃ പരസ്പരോപദേശേ ച തത്പരാ ഇത്യഹം നിശ്ചിതം ജാനാമി, ");
INSERT INTO sanmal_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","തഥാപ്യഹം യത് പ്രഗൽഭതരോ ഭവൻ യുഷ്മാൻ പ്രബോധയാമി തസ്യൈകം കാരണമിദം| ");
INSERT INTO sanmal_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","ഭിന്നജാതീയാഃ പവിത്രേണാത്മനാ പാവിതനൈവേദ്യരൂപാ ഭൂത്വാ യദ് ഗ്രാഹ്യാ ഭവേയുസ്തന്നിമിത്തമഹമ് ഈശ്വരസ്യ സുസംവാദം പ്രചാരയിതും ഭിന്നജാതീയാനാം മധ്യേ യീശുഖ്രീഷ്ടസ്യ സേവകത്വം ദാനം ഈശ്വരാത് ലബ്ധവാനസ്മി| ");
INSERT INTO sanmal_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","ഈശ്വരം പ്രതി യീശുഖ്രീഷ്ടേന മമ ശ്ലാഘാകരണസ്യ കാരണമ് ആസ്തേ| ");
INSERT INTO sanmal_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","ഭിന്നദേശിന ആജ്ഞാഗ്രാഹിണഃ കർത്തും ഖ്രീഷ്ടോ വാക്യേന ക്രിയയാ ച, ആശ്ചര്യ്യലക്ഷണൈശ്ചിത്രക്രിയാഭിഃ പവിത്രസ്യാത്മനഃ പ്രഭാവേന ച യാനി കർമ്മാണി മയാ സാധിതവാൻ, ");
INSERT INTO sanmal_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","കേവലം താന്യേവ വിനാന്യസ്യ കസ്യചിത് കർമ്മണോ വർണനാം കർത്തും പ്രഗൽഭോ ന ഭവാമി| തസ്മാത് ആ യിരൂശാലമ ഇല്ലൂരികം യാവത് സർവ്വത്ര ഖ്രീഷ്ടസ്യ സുസംവാദം പ്രാചാരയം| ");
INSERT INTO sanmal_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","അന്യേന നിചിതായാം ഭിത്താവഹം യന്ന നിചിനോമി തന്നിമിത്തം യത്ര യത്ര സ്ഥാനേ ഖ്രീഷ്ടസ്യ നാമ കദാപി കേനാപി ന ജ്ഞാപിതം തത്ര തത്ര സുസംവാദം പ്രചാരയിതുമ് അഹം യതേ| ");
INSERT INTO sanmal_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","യാദൃശം ലിഖിതമ് ആസ്തേ, യൈ ർവാർത്താ തസ്യ ന പ്രാപ്താ ദർശനം തൈസ്തു ലപ്സ്യതേ| യൈശ്ച നൈവ ശ്രുതം കിഞ്ചിത് ബോദ്ധും ശക്ഷ്യന്തി തേ ജനാഃ|| ");
INSERT INTO sanmal_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","തസ്മാദ് യുഷ്മത്സമീപഗമനാദ് അഹം മുഹുർമുഹു ർനിവാരിതോഽഭവം| ");
INSERT INTO sanmal_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","കിന്ത്വിദാനീമ് അത്ര പ്രദേശേഷു മയാ ന ഗതം സ്ഥാനം കിമപി നാവശിഷ്യതേ യുഷ്മത്സമീപം ഗന്തും ബഹുവത്സരാനാരഭ്യ മാമകീനാകാങ്ക്ഷാ ച വിദ്യത ഇതി ഹേതോഃ ");
INSERT INTO sanmal_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","സ്പാനിയാദേശഗമനകാലേഽഹം യുഷ്മന്മധ്യേന ഗച്ഛൻ യുഷ്മാൻ ആലോകിഷ്യേ, തതഃ പരം യുഷ്മത്സമ്ഭാഷണേന തൃപ്തിം പരിലഭ്യ തദ്ദേശഗമനാർഥം യുഷ്മാഭി ർവിസർജയിഷ്യേ, ഈദൃശീ മദീയാ പ്രത്യാശാ വിദ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","കിന്തു സാമ്പ്രതം പവിത്രലോകാനാം സേവനായ യിരൂശാലമ്നഗരം വ്രജാമി| ");
INSERT INTO sanmal_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","യതോ യിരൂശാലമസ്ഥപവിത്രലോകാനാം മധ്യേ യേ ദരിദ്രാ അർഥവിശ്രാണനേന താനുപകർത്തും മാകിദനിയാദേശീയാ ആഖായാദേശീയാശ്ച ലോകാ ഐച്ഛൻ| ");
INSERT INTO sanmal_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","ഏഷാ തേഷാം സദിച്ഛാ യതസ്തേ തേഷാമ് ഋണിനഃ സന്തി യതോ ഹേതോ ർഭിന്നജാതീയാ യേഷാം പരമാർഥസ്യാംശിനോ ജാതാ ഐഹികവിഷയേ തേഷാമുപകാരസ്തൈഃ കർത്തവ്യഃ| ");
INSERT INTO sanmal_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","അതോ മയാ തത് കർമ്മ സാധയിത്വാ തസ്മിൻ ഫലേ തേഭ്യഃ സമർപിതേ യുഷ്മന്മധ്യേന സ്പാനിയാദേശോ ഗമിഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","യുഷ്മത്സമീപേ മമാഗമനസമയേ ഖ്രീഷ്ടസ്യ സുസംവാദസ്യ പൂർണവരേണ സമ്ബലിതഃ സൻ അഹമ് ആഗമിഷ്യാമി ഇതി മയാ ജ്ഞായതേ| ");
INSERT INTO sanmal_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","ഹേ ഭ്രാതൃഗണ പ്രഭോ ര്യീശുഖ്രീഷ്ടസ്യ നാമ്നാ പവിത്രസ്യാത്മാനഃ പ്രേമ്നാ ച വിനയേഽഹം ");
INSERT INTO sanmal_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","യിഹൂദാദേശസ്ഥാനാമ് അവിശ്വാസിലോകാനാം കരേഭ്യോ യദഹം രക്ഷാം ലഭേയ മദീയൈതേന സേവനകർമ്മണാ ച യദ് യിരൂശാലമസ്ഥാഃ പവിത്രലോകാസ്തുഷ്യേയുഃ, ");
INSERT INTO sanmal_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","തദർഥം യൂയം മത്കൃത ഈശ്വരായ പ്രാർഥയമാണാ യതധ്വം തേനാഹമ് ഈശ്വരേച്ഛയാ സാനന്ദം യുഷ്മത്സമീപം ഗത്വാ യുഷ്മാഭിഃ സഹിതഃ പ്രാണാൻ ആപ്യായിതും പാരയിഷ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","ശാന്തിദായക ഈശ്വരോ യുഷ്മാകം സർവ്വേഷാം സങ്ഗീ ഭൂയാത്| ഇതി| ");
INSERT INTO sanmal_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","കിംക്രീയാനഗരീയധർമ്മസമാജസ്യ പരിചാരികാ യാ ഫൈബീനാമികാസ്മാകം ധർമ്മഭഗിനീ തസ്യാഃ കൃതേഽഹം യുഷ്മാൻ നിവേദയാമി, ");
INSERT INTO sanmal_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","യൂയം താം പ്രഭുമാശ്രിതാം വിജ്ഞായ തസ്യാ ആതിഥ്യം പവിത്രലോകാർഹം കുരുധ്വം, യുഷ്മത്തസ്തസ്യാ യ ഉപകാരോ ഭവിതും ശക്നോതി തം കുരുധ്വം, യസ്മാത് തയാ ബഹൂനാം മമ ചോപകാരഃ കൃതഃ| ");
INSERT INTO sanmal_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","അപരഞ്ച ഖ്രീഷ്ടസ്യ യീശോഃ കർമ്മണി മമ സഹകാരിണൗ മമ പ്രാണരക്ഷാർഥഞ്ച സ്വപ്രാണാൻ പണീകൃതവന്തൗ യൗ പ്രിഷ്കില്ലാക്കിലൗ തൗ മമ നമസ്കാരം ജ്ഞാപയധ്വം| ");
INSERT INTO sanmal_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","താഭ്യാമ് ഉപകാരാപ്തിഃ കേവലം മയാ സ്വീകർത്തവ്യേതി നഹി ഭിന്നദേശീയൈഃ സർവ്വധർമ്മസമാജൈരപി| ");
INSERT INTO sanmal_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","അപരഞ്ച തയോ ർഗൃഹേ സ്ഥിതാൻ ധർമ്മസമാജലോകാൻ മമ നമസ്കാരം ജ്ഞാപയധ്വം| തദ്വത് ആശിയാദേശേ ഖ്രീഷ്ടസ്യ പക്ഷേ പ്രഥമജാതഫലസ്വരൂപോ യ ഇപേനിതനാമാ മമ പ്രിയബന്ധുസ്തമപി മമ നമസ്കാരം ജ്ഞാപയധ്വം| ");
INSERT INTO sanmal_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","അപരം ബഹുശ്രമേണാസ്മാൻ അസേവത യാ മരിയമ് താമപി നമസ്കാരം ജ്ഞാപയധ്വം| ");
INSERT INTO sanmal_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","അപരഞ്ച പ്രേരിതേഷു ഖ്യാതകീർത്തീ മദഗ്രേ ഖ്രീഷ്ടാശ്രിതൗ മമ സ്വജാതീയൗ സഹബന്ദിനൗ ച യാവാന്ദ്രനീകയൂനിയൗ തൗ മമ നമസ്കാരം ജ്ഞാപയധ്വം| ");
INSERT INTO sanmal_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","തഥാ പ്രഭൗ മത്പ്രിയതമമ് ആമ്പ്ലിയമപി മമ നമസ്കാരം ജ്ഞാപയധ്വം| ");
INSERT INTO sanmal_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","അപരം ഖ്രീഷ്ടസേവായാം മമ സഹകാരിണമ് ഊർബ്ബാണം മമ പ്രിയതമം സ്താഖുഞ്ച മമ നമസ്കാരം ജ്ഞാപയധ്വം| ");
INSERT INTO sanmal_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","അപരം ഖ്രീഷ്ടേന പരീക്ഷിതമ് ആപില്ലിം മമ നമസ്കാരം വദത, ആരിഷ്ടബൂലസ്യ പരിജനാംശ്ച മമ നമസ്കാരം ജ്ഞാപയധ്വം| ");
INSERT INTO sanmal_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","അപരം മമ ജ്ഞാതിം ഹേരോദിയോനം മമ നമസ്കാരം വദത, തഥാ നാർകിസസ്യ പരിവാരാണാം മധ്യേ യേ പ്രഭുമാശ്രിതാസ്താൻ മമ നമസ്കാരം വദത| ");
INSERT INTO sanmal_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","അപരം പ്രഭോഃ സേവായാം പരിശ്രമകാരിണ്യൗ ത്രുഫേനാത്രുഫോഷേ മമ നമസ്കാരം വദത, തഥാ പ്രഭോഃ സേവായാമ് അത്യന്തം പരിശ്രമകാരിണീ യാ പ്രിയാ പർഷിസ്താം നമസ്കാരം ജ്ഞാപയധ്വം| ");
INSERT INTO sanmal_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","അപരം പ്രഭോരഭിരുചിതം രൂഫം മമ ധർമ്മമാതാ യാ തസ്യ മാതാ താമപി നമസ്കാരം വദത| ");
INSERT INTO sanmal_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","അപരമ് അസുംകൃതം ഫ്ലിഗോനം ഹർമ്മം പാത്രബം ഹർമ്മിമ് ഏതേഷാം സങ്ഗിഭ്രാതൃഗണഞ്ച നമസ്കാരം ജ്ഞാപയധ്വം| ");
INSERT INTO sanmal_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","അപരം ഫിലലഗോ യൂലിയാ നീരിയസ്തസ്യ ഭഗിന്യലുമ്പാ ചൈതാൻ ഏതൈഃ സാർദ്ധം യാവന്തഃ പവിത്രലോകാ ആസതേ താനപി നമസ്കാരം ജ്ഞാപയധ്വം| ");
INSERT INTO sanmal_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","യൂയം പരസ്പരം പവിത്രചുമ്ബനേന നമസ്കുരുധ്വം| ഖ്രീഷ്ടസ്യ ധർമ്മസമാജഗണോ യുഷ്മാൻ നമസ്കുരുതേ| ");
INSERT INTO sanmal_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","ഹേ ഭ്രാതരോ യുഷ്മാൻ വിനയേഽഹം യുഷ്മാഭി ര്യാ ശിക്ഷാ ലബ്ധാ താമ് അതിക്രമ്യ യേ വിച്ഛേദാൻ വിഘ്നാംശ്ച കുർവ്വന്തി താൻ നിശ്ചിനുത തേഷാം സങ്ഗം വർജയത ച| ");
INSERT INTO sanmal_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","യതസ്താദൃശാ ലോകാ അസ്മാകം പ്രഭോ ര്യീശുഖ്രീഷ്ടസ്യ ദാസാ ഇതി നഹി കിന്തു സ്വോദരസ്യൈവ ദാസാഃ; അപരം പ്രണയവചനൈ ർമധുരവാക്യൈശ്ച സരലലോകാനാം മനാംസി മോഹയന്തി| ");
INSERT INTO sanmal_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","യുഷ്മാകമ് ആജ്ഞാഗ്രാഹിത്വം സർവ്വത്ര സർവ്വൈ ർജ്ഞാതം തതോഽഹം യുഷ്മാസു സാനന്ദോഽഭവം തഥാപി യൂയം യത് സത്ജ്ഞാനേന ജ്ഞാനിനഃ കുജ്ഞാനേे ചാതത്പരാ ഭവേതേതി മമാഭിലാഷഃ| ");
INSERT INTO sanmal_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","അധികന്തു ശാന്തിദായക ഈശ്വരഃ ശൈതാനമ് അവിലമ്ബം യുഷ്മാകം പദാനാമ് അധോ മർദ്ദിഷ്യതി| അസ്മാകം പ്രഭു ര്യീശുഖ്രീഷ്ടോ യുഷ്മാസു പ്രസാദം ക്രിയാത്| ഇതി| ");
INSERT INTO sanmal_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","മമ സഹകാരീ തീമഥിയോ മമ ജ്ഞാതയോ ലൂകിയോ യാസോൻ സോസിപാത്രശ്ചേമേ യുഷ്മാൻ നമസ്കുർവ്വന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","അപരമ് ഏതത്പത്രലേഖകസ്തർത്തിയനാമാഹമപി പ്രഭോ ർനാമ്നാ യുഷ്മാൻ നമസ്കരോമി| ");
INSERT INTO sanmal_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","തഥാ കൃത്സ്നധർമ്മസമാജസ്യ മമ ചാതിഥ്യകാരീ ഗായോ യുഷ്മാൻ നമസ്കരോതി| അപരമ് ഏതന്നഗരസ്യ ധനരക്ഷക ഇരാസ്തഃ ക്കാർത്തനാമകശ്ചൈകോ ഭ്രാതാ താവപി യുഷ്മാൻ നമസ്കുരുതഃ| ");
INSERT INTO sanmal_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","അസ്മാകം പ്രഭു ര്യീശുഖ്രീഷ്ടാ യുഷ്മാസു സർവ്വേഷു പ്രസാദം ക്രിയാത്| ഇതി| ");
INSERT INTO sanmal_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","പൂർവ്വകാലികയുഗേഷു പ്രച്ഛന്നാ യാ മന്ത്രണാധുനാ പ്രകാശിതാ ഭൂത്വാ ഭവിഷ്യദ്വാദിലിഖിതഗ്രന്ഥഗണസ്യ പ്രമാണാദ് വിശ്വാസേന ഗ്രഹണാർഥം സദാതനസ്യേശ്വരസ്യാജ്ഞയാ സർവ്വദേശീയലോകാൻ ജ്ഞാപ്യതേ, ");
INSERT INTO sanmal_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","തസ്യാ മന്ത്രണായാ ജ്ഞാനം ലബ്ധ്വാ മയാ യഃ സുസംവാദോ യീശുഖ്രീഷ്ടമധി പ്രചാര്യ്യതേ, തദനുസാരാദ് യുഷ്മാൻ ധർമ്മേ സുസ്ഥിരാൻ കർത്തും സമർഥോ യോഽദ്വിതീയഃ ");
INSERT INTO sanmal_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","സർവ്വജ്ഞ ഈശ്വരസ്തസ്യ ധന്യവാദോ യീശുഖ്രീഷ്ടേന സന്തതം ഭൂയാത്| ഇതി|");
INSERT INTO sanmal_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","യാവന്തഃ പവിത്രാ ലോകാഃ സ്വേഷാമ് അസ്മാകഞ്ച വസതിസ്ഥാനേഷ്വസ്മാകം പ്രഭോ ര്യീശോഃ ഖ്രീഷ്ടസ്യ നാമ്നാ പ്രാർഥയന്തേ തൈഃ സഹാഹൂതാനാം ഖ്രീഷ്ടേന യീശുനാ പവിത്രീകൃതാനാം ലോകാനാം യ ഈശ്വരീയധർമ്മസമാജഃ കരിന്ഥനഗരേ വിദ്യതേ ");
INSERT INTO sanmal_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","തം പ്രതീശ്വരസ്യേച്ഛയാഹൂതോ യീശുഖ്രീഷ്ടസ്യ പ്രേരിതഃ പൗലഃ സോസ്ഥിനിനാമാ ഭ്രാതാ ച പത്രം ലിഖതി| ");
INSERT INTO sanmal_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","അസ്മാകം പിത്രേശ്വരേണ പ്രഭുനാ യീശുഖ്രീഷ്ടേന ച പ്രസാദഃ ശാന്തിശ്ച യുഷ്മഭ്യം ദീയതാം| ");
INSERT INTO sanmal_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","ഈശ്വരോ യീശുഖ്രീഷ്ടേന യുഷ്മാൻ പ്രതി പ്രസാദം പ്രകാശിതവാൻ, തസ്മാദഹം യുഷ്മന്നിമിത്തം സർവ്വദാ മദീയേശ്വരം ധന്യം വദാമി| ");
INSERT INTO sanmal_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","ഖ്രീഷ്ടസമ്ബന്ധീയം സാക്ഷ്യം യുഷ്മാകം മധ്യേ യേന പ്രകാരേണ സപ്രമാണമ് അഭവത് ");
INSERT INTO sanmal_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","തേന യൂയം ഖ്രീഷ്ടാത് സർവ്വവിധവക്തൃതാജ്ഞാനാദീനി സർവ്വധനാനി ലബ്ധവന്തഃ| ");
INSERT INTO sanmal_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","തതോഽസ്മത്പ്രഭോ ര്യീശുഖ്രീഷ്ടസ്യ പുനരാഗമനം പ്രതീക്ഷമാണാനാം യുഷ്മാകം കസ്യാപി വരസ്യാഭാവോ ന ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","അപരമ് അസ്മാകം പ്രഭോ ര്യീശുഖ്രീഷ്ടസ്യ ദിവസേ യൂയം യന്നിർദ്ദോഷാ ഭവേത തദർഥം സഏവ യാവദന്തം യുഷ്മാൻ സുസ്ഥിരാൻ കരിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","യ ഈശ്വരഃ സ്വപുത്രസ്യാസ്മത്പ്രഭോ ര്യീശുഖ്രീഷ്ടസ്യാംശിനഃ കർത്തും യുഷ്മാൻ ആഹൂതവാൻ സ വിശ്വസനീയഃ| ");
INSERT INTO sanmal_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","ഹേ ഭ്രാതരഃ, അസ്മാകം പ്രഭുയീശുഖ്രീഷ്ടസ്യ നാമ്നാ യുഷ്മാൻ വിനയേഽഹം സർവ്വൈ ര്യുഷ്മാഭിരേകരൂപാണി വാക്യാനി കഥ്യന്താം യുഷ്മന്മധ്യേ ഭിന്നസങ്ഘാതാ ന ഭവന്തു മനോവിചാരയോരൈക്യേന യുഷ്മാകം സിദ്ധത്വം ഭവതു| ");
INSERT INTO sanmal_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","ഹേ മമ ഭ്രാതരോ യുഷ്മന്മധ്യേ വിവാദാ ജാതാ ഇതി വാർത്താമഹം ക്ലോയ്യാഃ പരിജനൈ ർജ്ഞാപിതഃ| ");
INSERT INTO sanmal_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","മമാഭിപ്രേതമിദം യുഷ്മാകം കശ്ചിത് കശ്ചിദ് വദതി പൗലസ്യ ശിഷ്യോഽഹമ് ആപല്ലോഃ ശിഷ്യോഽഹം കൈഫാഃ ശിഷ്യോഽഹം ഖ്രീഷ്ടസ്യ ശിഷ്യോഽഹമിതി ച| ");
INSERT INTO sanmal_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","ഖ്രീഷ്ടസ്യ കിം വിഭേദഃ കൃതഃ? പൗലഃ കിം യുഷ്മത്കൃതേ ക്രുശേ ഹതഃ? പൗലസ്യ നാമ്നാ വാ യൂയം കിം മജ്ജിതാഃ? ");
INSERT INTO sanmal_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","ക്രിഷ്പഗായൗ വിനാ യുഷ്മാകം മധ്യേഽന്യഃ കോഽപി മയാ ന മജ്ജിത ഇതി ഹേതോരഹമ് ഈശ്വരം ധന്യം വദാമി| ");
INSERT INTO sanmal_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","ഏതേന മമ നാമ്നാ മാനവാ മയാ മജ്ജിതാ ഇതി വക്തും കേനാപി ന ശക്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","അപരം സ്തിഫാനസ്യ പരിജനാ മയാ മജ്ജിതാസ്തദന്യഃ കശ്ചിദ് യന്മയാ മജ്ജിതസ്തദഹം ന വേദ്മി| ");
INSERT INTO sanmal_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","ഖ്രീഷ്ടേനാഹം മജ്ജനാർഥം ന പ്രേരിതഃ കിന്തു സുസംവാദസ്യ പ്രചാരാർഥമേവ; സോഽപി വാക്പടുതയാ മയാ ന പ്രചാരിതവ്യഃ, യതസ്തഥാ പ്രചാരിതേ ഖ്രീഷ്ടസ്യ ക്രുശേ മൃത്യുഃ ഫലഹീനോ ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","യതോ ഹേതോ ര്യേ വിനശ്യന്തി തേ താം ക്രുശസ്യ വാർത്താം പ്രലാപമിവ മന്യന്തേ കിഞ്ച പരിത്രാണം ലഭമാനേഷ്വസ്മാസു സാ ഈശ്വരീയശക്തിസ്വരൂപാ| ");
INSERT INTO sanmal_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","തസ്മാദിത്ഥം ലിഖിതമാസ്തേ, ജ്ഞാനവതാന്തു യത് ജ്ഞാനം തന്മയാ നാശയിഷ്യതേ| വിലോപയിഷ്യതേ തദ്വദ് ബുദ്ധി ർബദ്ധിമതാം മയാ|| ");
INSERT INTO sanmal_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","ജ്ഞാനീ കുത്ര? ശാസ്ത്രീ വാ കുത്ര? ഇഹലോകസ്യ വിചാരതത്പരോ വാ കുത്ര? ഇഹലോകസ്യ ജ്ഞാനം കിമീശ്വരേണ മോഹീകൃതം നഹി? ");
INSERT INTO sanmal_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","ഈശ്വരസ്യ ജ്ഞാനാദ് ഇഹലോകസ്യ മാനവാഃ സ്വജ്ഞാനേനേശ്വരസ്യ തത്ത്വബോധം ന പ്രാപ്തവന്തസ്തസ്മാദ് ഈശ്വരഃ പ്രചാരരൂപിണാ പ്രലാപേന വിശ്വാസിനഃ പരിത്രാതും രോചിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","യിഹൂദീയലോകാ ലക്ഷണാനി ദിദൃക്ഷന്തി ഭിന്നദേശീയലോകാസ്തു വിദ്യാം മൃഗയന്തേ, ");
INSERT INTO sanmal_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","വയഞ്ച ക്രുശേ ഹതം ഖ്രീഷ്ടം പ്രചാരയാമഃ| തസ്യ പ്രചാരോ യിഹൂദീയൈ ർവിഘ്ന ഇവ ഭിന്നദേശീയൈശ്ച പ്രലാപ ഇവ മന്യതേ, ");
INSERT INTO sanmal_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","കിന്തു യിഹൂദീയാനാം ഭിന്നദേശീയാനാഞ്ച മധ്യേ യേ ആഹൂതാസ്തേഷു സ ഖ്രീഷ്ട ഈശ്വരീയശക്തിരിവേശ്വരീയജ്ഞാനമിവ ച പ്രകാശതേ| ");
INSERT INTO sanmal_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","യത ഈശ്വരേ യഃ പ്രലാപ ആരോപ്യതേ സ മാനവാതിരിക്തം ജ്ഞാനമേവ യച്ച ദൗർബ്ബല്യമ് ഈശ്വര ആരോപ്യതേ തത് മാനവാതിരിക്തം ബലമേവ| ");
INSERT INTO sanmal_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","ഹേ ഭ്രാതരഃ, ആഹൂതയുഷ്മദ്ഗണോ യഷ്മാഭിരാലോക്യതാം തന്മധ്യേ സാംസാരികജ്ഞാനേന ജ്ഞാനവന്തഃ പരാക്രമിണോ വാ കുലീനാ വാ ബഹവോ ന വിദ്യന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","യത ഈശ്വരോ ജ്ഞാനവതസ്ത്രപയിതും മൂർഖലോകാൻ രോചിതവാൻ ബലാനി ച ത്രപയിതുമ് ഈശ്വരോ ദുർബ്ബലാൻ രോചിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","തഥാ വർത്തമാനലോകാൻ സംസ്ഥിതിഭ്രഷ്ടാൻ കർത്തുമ് ഈശ്വരോ ജഗതോഽപകൃഷ്ടാൻ ഹേയാൻ അവർത്തമാനാംശ്ചാഭിരോചിതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","തത ഈശ്വരസ്യ സാക്ഷാത് കേനാപ്യാത്മശ്ലാഘാ ന കർത്തവ്യാ| ");
INSERT INTO sanmal_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","യൂയഞ്ച തസ്മാത് ഖ്രീഷ്ടേ യീശൗ സംസ്ഥിതിം പ്രാപ്തവന്തഃ സ ഈശ്വരാദ് യുഷ്മാകം ജ്ഞാനം പുണ്യം പവിത്രത്വം മുക്തിശ്ച ജാതാ| ");
INSERT INTO sanmal_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","അതഏവ യദ്വദ് ലിഖിതമാസ്തേ തദ്വത്, യഃ കശ്ചിത് ശ്ലാഘമാനഃ സ്യാത് ശ്ലാഘതാം പ്രഭുനാ സ ഹി| ");
INSERT INTO sanmal_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","ഹേ ഭ്രാതരോ യുഷ്മത്സമീപേ മമാഗമനകാലേഽഹം വക്തൃതായാ വിദ്യായാ വാ നൈപുണ്യേനേശ്വരസ്യ സാക്ഷ്യം പ്രചാരിതവാൻ തന്നഹി; ");
INSERT INTO sanmal_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","യതോ യീശുഖ്രീഷ്ടം തസ്യ ക്രുശേ ഹതത്വഞ്ച വിനാ നാന്യത് കിമപി യുഷ്മന്മധ്യേ ജ്ഞാപയിതും വിഹിതം ബുദ്ധവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","അപരഞ്ചാതീവ ദൗർബ്ബല്യഭീതികമ്പയുക്തോ യുഷ്മാഭിഃ സാർദ്ധമാസം| ");
INSERT INTO sanmal_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","അപരം യുഷ്മാകം വിശ്വാസോ യത് മാനുഷികജ്ഞാനസ്യ ഫലം ന ഭവേത് കിന്ത്വീശ്വരീയശക്തേഃ ഫലം ഭവേത്, ");
INSERT INTO sanmal_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","തദർഥം മമ വക്തൃതാ മദീയപ്രചാരശ്ച മാനുഷികജ്ഞാനസ്യ മധുരവാക്യസമ്ബലിതൗ നാസ്താം കിന്ത്വാത്മനഃ ശക്തേശ്ച പ്രമാണയുക്താവാസ്താം| ");
INSERT INTO sanmal_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","വയം ജ്ഞാനം ഭാഷാമഹേ തച്ച സിദ്ധലോകൈ ർജ്ഞാനമിവ മന്യതേ, തദിഹലോകസ്യ ജ്ഞാനം നഹി, ഇഹലോകസ്യ നശ്വരാണാമ് അധിപതീനാം വാ ജ്ഞാനം നഹി; ");
INSERT INTO sanmal_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","കിന്തു കാലാവസ്ഥായാഃ പൂർവ്വസ്മാദ് യത് ജ്ഞാനമ് അസ്മാകം വിഭവാർഥമ് ഈശ്വരേണ നിശ്ചിത്യ പ്രച്ഛന്നം തന്നിഗൂഢമ് ഈശ്വരീയജ്ഞാനം പ്രഭാഷാമഹേ| ");
INSERT INTO sanmal_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","ഇഹലോകസ്യാധിപതീനാം കേനാപി തത് ജ്ഞാനം ന ലബ്ധം, ലബ്ധേ സതി തേ പ്രഭാവവിശിഷ്ടം പ്രഭും ക്രുശേ നാഹനിഷ്യൻ| ");
INSERT INTO sanmal_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","തദ്വല്ലിഖിതമാസ്തേ, നേത്രേണ ക്കാപി നോ ദൃഷ്ടം കർണേനാപി ച ന ശ്രുതം| മനോമധ്യേ തു കസ്യാപി ന പ്രവിഷ്ടം കദാപി യത്| ഈശ്വരേ പ്രീയമാണാനാം കൃതേ തത് തേന സഞ്ചിതം| ");
INSERT INTO sanmal_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","അപരമീശ്വരഃ സ്വാത്മനാ തദസ്മാകം സാക്ഷാത് പ്രാകാശയത്; യത ആത്മാ സർവ്വമേവാനുസന്ധത്തേ തേന ചേശ്വരസ്യ മർമ്മതത്ത്വമപി ബുധ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","മനുജസ്യാന്തഃസ്ഥമാത്മാനം വിനാ കേന മനുജേന തസ്യ മനുജസ്യ തത്ത്വം ബുധ്യതേ? തദ്വദീശ്വരസ്യാത്മാനം വിനാ കേനാപീശ്വരസ്യ തത്ത്വം ന ബുധ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","വയഞ്ചേഹലോകസ്യാത്മാനം ലബ്ധവന്തസ്തന്നഹി കിന്ത്വീശ്വരസ്യൈവാത്മാനം ലബ്ധവന്തഃ, തതോ ഹേതോരീശ്വരേണ സ്വപ്രസാദാദ് അസ്മഭ്യം യദ് യദ് ദത്തം തത്സർവ്വമ് അസ്മാഭി ർജ്ഞാതും ശക്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","തച്ചാസ്മാഭി ർമാനുഷികജ്ഞാനസ്യ വാക്യാനി ശിക്ഷിത്വാ കഥ്യത ഇതി നഹി കിന്ത്വാത്മതോ വാക്യാനി ശിക്ഷിത്വാത്മികൈ ർവാക്യൈരാത്മികം ഭാവം പ്രകാശയദ്ഭിഃ കഥ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","പ്രാണീ മനുഷ്യ ഈശ്വരീയാത്മനഃ ശിക്ഷാം ന ഗൃഹ്ലാതി യത ആത്മികവിചാരേണ സാ വിചാര്യ്യേതി ഹേതോഃ സ താം പ്രലാപമിവ മന്യതേ ബോദ്ധുഞ്ച ന ശക്നോതി| ");
INSERT INTO sanmal_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","ആത്മികോ മാനവഃ സർവ്വാണി വിചാരയതി കിന്തു സ്വയം കേനാപി ന വിചാര്യ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","യത ഈശ്വരസ്യ മനോ ജ്ഞാത്വാ തമുപദേഷ്ടും കഃ ശക്നോതി? കിന്തു ഖ്രീഷ്ടസ്യ മനോഽസ്മാഭി ർലബ്ധം| ");
INSERT INTO sanmal_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","ഹേ ഭ്രാതരഃ, അഹമാത്മികൈരിവ യുഷ്മാഭിഃ സമം സമ്ഭാഷിതും നാശക്നവം കിന്തു ശാരീരികാചാരിഭിഃ ഖ്രീഷ്ടധർമ്മേ ശിശുതുല്യൈശ്ച ജനൈരിവ യുഷ്മാഭിഃ സഹ സമഭാഷേ| ");
INSERT INTO sanmal_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","യുഷ്മാൻ കഠിനഭക്ഷ്യം ന ഭോജയൻ ദുഗ്ധമ് അപായയം യതോ യൂയം ഭക്ഷ്യം ഗ്രഹീതും തദാ നാശക്നുത ഇദാനീമപി ന ശക്നുഥ, യതോ ഹേതോരധുനാപി ശാരീരികാചാരിണ ആധ്വേ| ");
INSERT INTO sanmal_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","യുഷ്മന്മധ്യേ മാത്സര്യ്യവിവാദഭേദാ ഭവന്തി തതഃ കിം ശാരീരികാചാരിണോ നാധ്വേ മാനുഷികമാർഗേണ ച ന ചരഥ? ");
INSERT INTO sanmal_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","പൗലസ്യാഹമിത്യാപല്ലോരഹമിതി വാ യദ്വാക്യം യുഷ്മാകം കൈശ്ചിത് കൈശ്ചിത് കഥ്യതേ തസ്മാദ് യൂയം ശാരീരികാചാരിണ ന ഭവഥ? ");
INSERT INTO sanmal_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","പൗലഃ കഃ? ആപല്ലോ ർവാ കഃ? തൗ പരിചാരകമാത്രൗ തയോരേകൈകസ്മൈ ച പ്രഭു ര്യാദൃക് ഫലമദദാത് തദ്വത് തയോർദ്വാരാ യൂയം വിശ്വാസിനോ ജാതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","അഹം രോപിതവാൻ ആപല്ലോശ്ച നിഷിക്തവാൻ ഈശ്വരശ്ചാവർദ്ധയത്| ");
INSERT INTO sanmal_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","അതോ രോപയിതൃസേക്താരാവസാരൗ വർദ്ധയിതേശ്വര ഏവ സാരഃ| ");
INSERT INTO sanmal_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","രോപയിതൃസേക്താരൗ ച സമൗ തയോരേകൈകശ്ച സ്വശ്രമയോഗ്യം സ്വവേതനം ലപ്സ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","ആവാമീശ്വരേണ സഹ കർമ്മകാരിണൗ, ഈശ്വരസ്യ യത് ക്ഷേത്രമ് ഈശ്വരസ്യ യാ നിർമ്മിതിഃ സാ യൂയമേവ| ");
INSERT INTO sanmal_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","ഈശ്വരസ്യ പ്രസാദാത് മയാ യത് പദം ലബ്ധം തസ്മാത് ജ്ഞാനിനാ ഗൃഹകാരിണേവ മയാ ഭിത്തിമൂലം സ്ഥാപിതം തദുപരി ചാന്യേന നിചീയതേ| കിന്തു യേന യന്നിചീയതേ തത് തേന വിവിച്യതാം| ");
INSERT INTO sanmal_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","യതോ യീശുഖ്രീഷ്ടരൂപം യദ് ഭിത്തിമൂലം സ്ഥാപിതം തദന്യത് കിമപി ഭിത്തിമൂലം സ്ഥാപയിതും കേനാപി ന ശക്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","ഏതദ്ഭിത്തിമൂലസ്യോപരി യദി കേചിത് സ്വർണരൂപ്യമണികാഷ്ഠതൃണനലാൻ നിചിന്വന്തി, ");
INSERT INTO sanmal_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","തർഹ്യേകൈകസ്യ കർമ്മ പ്രകാശിഷ്യതേ യതഃ സ ദിവസസ്തത് പ്രകാശയിഷ്യതി| യതോ ഹതോസ്തന ദിവസേന വഹ്നിമയേനോദേതവ്യം തത ഏകൈകസ്യ കർമ്മ കീദൃശമേതസ്യ പരീക്ഷാ ബഹ്നിനാ ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","യസ്യ നിചയനരൂപം കർമ്മ സ്ഥാസ്നു ഭവിഷ്യതി സ വേതനം ലപ്സ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","യസ്യ ച കർമ്മ ധക്ഷ്യതേ തസ്യ ക്ഷതി ർഭവിഷ്യതി കിന്തു വഹ്നേ ർനിർഗതജന ഇവ സ സ്വയം പരിത്രാണം പ്രാപ്സ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","യൂയമ് ഈശ്വരസ്യ മന്ദിരം യുഷ്മന്മധ്യേ ചേശ്വരസ്യാത്മാ നിവസതീതി കിം ന ജാനീഥ? ");
INSERT INTO sanmal_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","ഈശ്വരസ്യ മന്ദിരം യേന വിനാശ്യതേ സോഽപീശ്വരേണ വിനാശയിഷ്യതേ യത ഈശ്വരസ്യ മന്ദിരം പവിത്രമേവ യൂയം തു തന്മന്ദിരമ് ആധ്വേ| ");
INSERT INTO sanmal_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","കോപി സ്വം ന വഞ്ചയതാം| യുഷ്മാകം കശ്ചന ചേദിഹലോകസ്യ ജ്ഞാനേന ജ്ഞാനവാനഹമിതി ബുധ്യതേ തർഹി സ യത് ജ്ഞാനീ ഭവേത് തദർഥം മൂഢോ ഭവതു| ");
INSERT INTO sanmal_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","യസ്മാദിഹലോകസ്യ ജ്ഞാനമ് ഈശ്വരസ്യ സാക്ഷാത് മൂഢത്വമേവ| ഏതസ്മിൻ ലിഖിതമപ്യാസ്തേ, തീക്ഷ്ണാ യാ ജ്ഞാനിനാം ബുദ്ധിസ്തയാ താൻ ധരതീശ്വരഃ| ");
INSERT INTO sanmal_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","പുനശ്ച| ജ്ഞാനിനാം കൽപനാ വേത്തി പരമേശോ നിരർഥകാഃ| ");
INSERT INTO sanmal_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","അതഏവ കോഽപി മനുജൈരാത്മാനം ന ശ്ലാഘതാം യതഃ സർവ്വാണി യുഷ്മാകമേവ, ");
INSERT INTO sanmal_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","പൗല വാ ആപല്ലോ ർവാ കൈഫാ വാ ജഗദ് വാ ജീവനം വാ മരണം വാ വർത്തമാനം വാ ഭവിഷ്യദ്വാ സർവ്വാണ്യേവ യുഷ്മാകം, ");
INSERT INTO sanmal_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","യൂയഞ്ച ഖ്രീഷ്ടസ്യ, ഖ്രീഷ്ടശ്ചേശ്വരസ്യ| ");
INSERT INTO sanmal_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","ലോകാ അസ്മാൻ ഖ്രീഷ്ടസ്യ പരിചാരകാൻ ഈശ്വരസ്യ നിഗൂഠവാക്യധനസ്യാധ്യക്ഷാംശ്ച മന്യന്താം| ");
INSERT INTO sanmal_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","കിഞ്ച ധനാധ്യക്ഷേണ വിശ്വസനീയേന ഭവിതവ്യമേതദേവ ലോകൈ ര്യാച്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","അതോ വിചാരയദ്ഭി ര്യുഷ്മാഭിരന്യൈഃ കൈശ്ചിൻ മനുജൈ ർവാ മമ പരീക്ഷണം മയാതീവ ലഘു മന്യതേ ഽഹമപ്യാത്മാനം ന വിചാരയാമി| ");
INSERT INTO sanmal_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","മയാ കിമപ്യപരാദ്ധമിത്യഹം ന വേദ്മി കിന്ത്വേതേന മമ നിരപരാധത്വം ന നിശ്ചീയതേ പ്രഭുരേവ മമ വിചാരയിതാസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","അത ഉപയുക്തസമയാത് പൂർവ്വമ് അർഥതഃ പ്രഭോരാഗമനാത് പൂർവ്വം യുഷ്മാഭി ർവിചാരോ ന ക്രിയതാം| പ്രഭുരാഗത്യ തിമിരേണ പ്രച്ഛന്നാനി സർവ്വാണി ദീപയിഷ്യതി മനസാം മന്ത്രണാശ്ച പ്രകാശയിഷ്യതി തസ്മിൻ സമയ ഈശ്വരാദ് ഏകൈകസ്യ പ്രശംസാ ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","ഹേ ഭ്രാതരഃ സർവ്വാണ്യേതാനി മയാത്മാനമ് ആപല്ലവഞ്ചോദ്ദിശ്യ കഥിതാനി തസ്യൈതത് കാരണം യുയം യഥാ ശാസ്ത്രീയവിധിമതിക്രമ്യ മാനവമ് അതീവ നാദരിഷ്യധ്ബ ഈത്ഥഞ്ചൈകേന വൈപരീത്യാദ് അപരേണ ന ശ്ലാഘിഷ്യധ്ബ ഏതാദൃശീം ശിക്ഷാമാവയോർദൃഷ്ടാന്താത് ലപ്സ്യധ്വേ| ");
INSERT INTO sanmal_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","അപരാത് കസ്ത്വാം വിശേഷയതി? തുഭ്യം യന്ന ദത്ത താദൃശം കിം ധാരയസി? അദത്തേനേവ ദത്തേന വസ്തുനാ കുതഃ ശ്ലാഘസേ? ");
INSERT INTO sanmal_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","ഇദാനീമേവ യൂയം കിം തൃപ്താ ലബ്ധധനാ വാ? അസ്മാസ്വവിദ്യമാനേഷു യൂയം കിം രാജത്വപദം പ്രാപ്താഃ? യുഷ്മാകം രാജത്വം മയാഭിലഷിതം യതസ്തേന യുഷ്മാഭിഃ സഹ വയമപി രാജ്യാംശിനോ ഭവിഷ്യാമഃ| ");
INSERT INTO sanmal_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","പ്രേരിതാ വയം ശേഷാ ഹന്തവ്യാശ്ചേവേശ്വരേണ നിദർശിതാഃ| യതോ വയം സർവ്വലോകാനാമ് അർഥതഃ സ്വർഗീയദൂതാനാം മാനവാനാഞ്ച കൗതുകാസ്പദാനി ജാതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","ഖ്രീഷ്ടസ്യ കൃതേ വയം മൂഢാഃ കിന്തു യൂയം ഖ്രീഷ്ടേന ജ്ഞാനിനഃ, വയം ദുർബ്ബലാ യൂയഞ്ച സബലാഃ, യൂയം സമ്മാനിതാ വയഞ്ചാപമാനിതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","വയമദ്യാപി ക്ഷുധാർത്താസ്തൃഷ്ണാർത്താ വസ്ത്രഹീനാസ്താഡിതാ ആശ്രമരഹിതാശ്ച സന്തഃ ");
INSERT INTO sanmal_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","കർമ്മണി സ്വകരാൻ വ്യാപാരയന്തശ്ച ദുഃഖൈഃ കാലം യാപയാമഃ| ഗർഹിതൈരസ്മാഭിരാശീഃ കഥ്യതേ ദൂരീകൃതൈഃ സഹ്യതേ നിന്ദിതൈഃ പ്രസാദ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","വയമദ്യാപി ജഗതഃ സമ്മാർജനീയോഗ്യാ അവകരാ ഇവ സർവ്വൈ ർമന്യാമഹേ| ");
INSERT INTO sanmal_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","യുഷ്മാൻ ത്രപയിതുമഹമേതാനി ലിഖാമീതി നഹി കിന്തു പ്രിയാത്മജാനിവ യുഷ്മാൻ പ്രബോധയാമി| ");
INSERT INTO sanmal_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","യതഃ ഖ്രീഷ്ടധർമ്മേ യദ്യപി യുഷ്മാകം ദശസഹസ്രാണി വിനേതാരോ ഭവന്തി തഥാപി ബഹവോ ജനകാ ന ഭവന്തി യതോഽഹമേവ സുസംവാദേന യീശുഖ്രീഷ്ടേ യുഷ്മാൻ അജനയം| ");
INSERT INTO sanmal_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","അതോ യുഷ്മാൻ വിനയേഽഹം യൂയം മദനുഗാമിനോ ഭവത| ");
INSERT INTO sanmal_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","ഇത്യർഥം സർവ്വേഷു ധർമ്മസമാജേഷു സർവ്വത്ര ഖ്രീഷ്ടധർമ്മയോഗ്യാ യേ വിധയോ മയോപദിശ്യന്തേ താൻ യോ യുഷ്മാൻ സ്മാരയിഷ്യത്യേവമ്ഭൂതം പ്രഭോഃ കൃതേ പ്രിയം വിശ്വാസിനഞ്ച മദീയതനയം തീമഥിയം യുഷ്മാകം സമീപം പ്രേഷിതവാനഹം| ");
INSERT INTO sanmal_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","അപരമഹം യുഷ്മാകം സമീപം ന ഗമിഷ്യാമീതി ബുദ്ധ്വാ യുഷ്മാകം കിയന്തോ ലോകാ ഗർവ്വന്തി| ");
INSERT INTO sanmal_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","കിന്തു യദി പ്രഭേരിച്ഛാ ഭവതി തർഹ്യഹമവിലമ്ബം യുഷ്മത്സമീപമുപസ്ഥായ തേഷാം ദർപധ്മാതാനാം ലോകാനാം വാചം ജ്ഞാസ്യാമീതി നഹി സാമർഥ്യമേവ ജ്ഞാസ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","യസ്മാദീശ്വരസ്യ രാജത്വം വാഗ്യുക്തം നഹി കിന്തു സാമർഥ്യയുക്തം| ");
INSERT INTO sanmal_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","യുഷ്മാകം കാ വാഞ്ഛാ? യുഷ്മത്സമീപേ മയാ കിം ദണ്ഡപാണിനാ ഗന്തവ്യമുത പ്രേമനമ്രതാത്മയുക്തേന വാ? ");
INSERT INTO sanmal_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","അപരം യുഷ്മാകം മധ്യേ വ്യഭിചാരോ വിദ്യതേ സ ച വ്യഭിചാരസ്താദൃശോ യദ് ദേവപൂജകാനാം മധ്യേഽപി തത്തുല്യോ ന വിദ്യതേ ഫലതോ യുഷ്മാകമേകോ ജനോ വിമാതൃഗമനം കൃരുത ഇതി വാർത്താ സർവ്വത്ര വ്യാപ്താ| ");
INSERT INTO sanmal_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","തഥാച യൂയം ദർപധ്മാതാ ആധ്ബേ, തത് കർമ്മ യേന കൃതം സ യഥാ യുഷ്മന്മധ്യാദ് ദൂരീക്രിയതേ തഥാ ശോകോ യുഷ്മാഭി ർന ക്രിയതേ കിമ് ഏതത്? ");
INSERT INTO sanmal_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","അവിദ്യമാനേ മദീയശരീരേ മമാത്മാ യുഷ്മന്മധ്യേ വിദ്യതേ അതോഽഹം വിദ്യമാന ഇവ തത്കർമ്മകാരിണോ വിചാരം നിശ്ചിതവാൻ, ");
INSERT INTO sanmal_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","അസ്മത്പ്രഭോ ര്യീശുഖ്രീഷ്ടസ്യ നാമ്നാ യുഷ്മാകം മദീയാത്മനശ്ച മിലനേ ജാതേ ഽസ്മത്പ്രഭോ ര്യീശുഖ്രീഷ്ടസ്യ ശക്തേഃ സാഹായ്യേന ");
INSERT INTO sanmal_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","സ നരഃ ശരീരനാശാർഥമസ്മാഭിഃ ശയതാനോ ഹസ്തേ സമർപയിതവ്യസ്തതോഽസ്മാകം പ്രഭോ ര്യീശോ ർദിവസേ തസ്യാത്മാ രക്ഷാം ഗന്തും ശക്ഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","യുഷ്മാകം ദർപോ ന ഭദ്രായ യൂയം കിമേതന്ന ജാനീഥ, യഥാ, വികാരഃ കൃത്സ്നശക്തൂനാം സ്വൽപകിണ്വേന ജായതേ| ");
INSERT INTO sanmal_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","യൂയം യത് നവീനശക്തുസ്വരൂപാ ഭവേത തദർഥം പുരാതനം കിണ്വമ് അവമാർജ്ജത യതോ യുഷ്മാഭിഃ കിണ്വശൂന്യൈ ർഭവിതവ്യം| അപരമ് അസ്മാകം നിസ്താരോത്സവീയമേഷശാവകോ യഃ ഖ്രീഷ്ടഃ സോഽസ്മദർഥം ബലീകൃതോ ഽഭവത്| ");
INSERT INTO sanmal_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","അതഃ പുരാതനകിണ്വേനാർഥതോ ദുഷ്ടതാജിഘാംസാരൂപേണ കിണ്വേന തന്നഹി കിന്തു സാരല്യസത്യത്വരൂപയാ കിണ്വശൂന്യതയാസ്മാഭിരുത്സവഃ കർത്തവ്യഃ| ");
INSERT INTO sanmal_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","വ്യാഭിചാരിണാം സംസർഗോ യുഷ്മാഭി ർവിഹാതവ്യ ഇതി മയാ പത്രേ ലിഖിതം| ");
INSERT INTO sanmal_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","കിന്ത്വൈഹികലോകാനാം മധ്യേ യേ വ്യഭിചാരിണോ ലോഭിന ഉപദ്രാവിണോ ദേവപൂജകാ വാ തേഷാം സംസർഗഃ സർവ്വഥാ വിഹാതവ്യ ഇതി നഹി, വിഹാതവ്യേ സതി യുഷ്മാഭി ർജഗതോ നിർഗന്തവ്യമേവ| ");
INSERT INTO sanmal_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","കിന്തു ഭ്രാതൃത്വേന വിഖ്യാതഃ കശ്ചിജ്ജനോ യദി വ്യഭിചാരീ ലോഭീ ദേവപൂജകോ നിന്ദകോ മദ്യപ ഉപദ്രാവീ വാ ഭവേത് തർഹി താദൃശേന മാനവേന സഹ ഭോജനപാനേഽപി യുഷ്മാഭി ർന കർത്തവ്യേ ഇത്യധുനാ മയാ ലിഖിതം| ");
INSERT INTO sanmal_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","സമാജബഹിഃസ്ഥിതാനാം ലോകാനാം വിചാരകരണേ മമ കോഽധികാരഃ? കിന്തു തദന്തർഗതാനാം വിചാരണം യുഷ്മാഭിഃ കിം ന കർത്തവ്യം ഭവേത്? ");
INSERT INTO sanmal_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","ബഹിഃസ്ഥാനാം തു വിചാര ഈശ്വരേണ കാരിഷ്യതേ| അതോ യുഷ്മാഭിഃ സ പാതകീ സ്വമധ്യാദ് ബഹിഷ്ക്രിയതാം| ");
INSERT INTO sanmal_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","യുഷ്മാകമേകസ്യ ജനസ്യാപരേണ സഹ വിവാദേ ജാതേ സ പവിത്രലോകൈ ർവിചാരമകാരയൻ കിമ് അധാർമ്മികലോകൈ ർവിചാരയിതും പ്രോത്സഹതേ? ");
INSERT INTO sanmal_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","ജഗതോഽപി വിചാരണം പവിത്രലോകൈഃ കാരിഷ്യത ഏതദ് യൂയം കിം ന ജാനീഥ? അതോ ജഗദ് യദി യുഷ്മാഭി ർവിചാരയിതവ്യം തർഹി ക്ഷുദ്രതമവിചാരേഷു യൂയം കിമസമർഥാഃ? ");
INSERT INTO sanmal_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","ദൂതാ അപ്യസ്മാഭി ർവിചാരയിഷ്യന്ത ഇതി കിം ന ജാനീഥ? അത ഐഹികവിഷയാഃ കിമ് അസ്മാഭി ർന വിചാരയിതവ്യാ ഭവേയുഃ? ");
INSERT INTO sanmal_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","ഐഹികവിഷയസ്യ വിചാരേ യുഷ്മാഭിഃ കർത്തവ്യേ യേ ലോകാഃ സമിതൗ ക്ഷുദ്രതമാസ്ത ഏവ നിയുജ്യന്താം| ");
INSERT INTO sanmal_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","അഹം യുഷ്മാൻ ത്രപയിതുമിച്ഛൻ വദാമി യൃഷ്മന്മധ്യേ കിമേകോഽപി മനുഷ്യസ്താദൃഗ് ബുദ്ധിമാന്നഹി യോ ഭ്രാതൃവിവാദവിചാരണേ സമർഥഃ സ്യാത്? ");
INSERT INTO sanmal_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","കിഞ്ചൈകോ ഭ്രാതാ ഭ്രാത്രാന്യേന കിമവിശ്വാസിനാം വിചാരകാണാം സാക്ഷാദ് വിവദതേ? യഷ്മന്മധ്യേ വിവാദാ വിദ്യന്ത ഏതദപി യുഷ്മാകം ദോഷഃ| ");
INSERT INTO sanmal_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","യൂയം കുതോഽന്യായസഹനം ക്ഷതിസഹനം വാ ശ്രേയോ ന മന്യധ്വേ? ");
INSERT INTO sanmal_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","കിന്തു യൂയമപി ഭ്രാതൃനേവ പ്രത്യന്യായം ക്ഷതിഞ്ച കുരുഥ കിമേതത്? ");
INSERT INTO sanmal_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","ഈശ്വരസ്യ രാജ്യേഽന്യായകാരിണാം ലോകാനാമധികാരോ നാസ്ത്യേതദ് യൂയം കിം ന ജാനീഥ? മാ വഞ്ച്യധ്വം, യേ വ്യഭിചാരിണോ ദേവാർച്ചിനഃ പാരദാരികാഃ സ്ത്രീവദാചാരിണഃ പുംമൈഥുനകാരിണസ്തസ്കരാ ");
INSERT INTO sanmal_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","ലോഭിനോ മദ്യപാ നിന്ദകാ ഉപദ്രാവിണോ വാ ത ഈശ്വരസ്യ രാജ്യഭാഗിനോ ന ഭവിഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","യൂയഞ്ചൈവംവിധാ ലോകാ ആസ്ത കിന്തു പ്രഭോ ര്യീശോ ർനാമ്നാസ്മദീശ്വരസ്യാത്മനാ ച യൂയം പ്രക്ഷാലിതാഃ പാവിതാഃ സപുണ്യീകൃതാശ്ച| ");
INSERT INTO sanmal_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","മദർഥം സർവ്വം ദ്രവ്യമ് അപ്രതിഷിദ്ധം കിന്തു ന സർവ്വം ഹിതജനകം| മദർഥം സർവ്വമപ്രതിഷിദ്ധം തഥാപ്യഹം കസ്യാപി ദ്രവ്യസ്യ വശീകൃതോ ന ഭവിഷ്യാമി| ");
INSERT INTO sanmal_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","ഉദരായ ഭക്ഷ്യാണി ഭക്ഷ്യേഭ്യശ്ചോദരം, കിന്തു ഭക്ഷ്യോദരേ ഈശ്വരേണ നാശയിഷ്യേതേ; അപരം ദേഹോ ന വ്യഭിചാരായ കിന്തു പ്രഭവേ പ്രഭുശ്ച ദേഹായ| ");
INSERT INTO sanmal_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","യശ്ചേശ്വരഃ പ്രഭുമുത്ഥാപിതവാൻ സ സ്വശക്ത്യാസ്മാനപ്യുത്ഥാപയിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","യുഷ്മാകം യാനി ശരീരാണി താനി ഖ്രീഷ്ടസ്യാങ്ഗാനീതി കിം യൂയം ന ജാനീഥ? അതഃ ഖ്രീഷ്ടസ്യ യാന്യങ്ഗാനി താനി മയാപഹൃത്യ വേശ്യായാ അങ്ഗാനി കിം കാരിഷ്യന്തേ? തന്ന ഭവതു| ");
INSERT INTO sanmal_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","യഃ കശ്ചിദ് വേശ്യായാമ് ആസജ്യതേ സ തയാ സഹൈകദേഹോ ഭവതി കിം യൂയമേതന്ന ജാനീഥ? യതോ ലിഖിതമാസ്തേ, യഥാ, തൗ ദ്വൗ ജനാവേകാങ്ഗൗ ഭവിഷ്യതഃ| ");
INSERT INTO sanmal_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","മാനവാ യാന്യന്യാനി കലുഷാണി കുർവ്വതേ താനി വപു ർന സമാവിശന്തി കിന്തു വ്യഭിചാരിണാ സ്വവിഗ്രഹസ്യ വിരുദ്ധം കൽമഷം ക്രിയതേ| ");
INSERT INTO sanmal_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","മാനവാ യാന്യന്യാനി കലുഷാണി കുർവ്വതേ താനി വപു ർന സമാവിശന്തി കിന്തു വ്യഭിചാരിണാ സ്വവിഗ്രഹസ്യ വിരുദ്ധം കൽമഷം ക്രിയതേ| ");
INSERT INTO sanmal_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","യുഷ്മാകം യാനി വപൂംസി താനി യുഷ്മദന്തഃസ്ഥിതസ്യേശ്വരാല്ലബ്ധസ്യ പവിത്രസ്യാത്മനോ മന്ദിരാണി യൂയഞ്ച സ്വേഷാം സ്വാമിനോ നാധ്വേ കിമേതദ് യുഷ്മാഭി ർന ജ്ഞായതേ? ");
INSERT INTO sanmal_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","യൂയം മൂല്യേന ക്രീതാ അതോ വപുർമനോഭ്യാമ് ഈശ്വരോ യുഷ്മാഭിഃ പൂജ്യതാം യത ഈശ്വര ഏവ തയോഃ സ്വാമീ| ");
INSERT INTO sanmal_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","അപരഞ്ച യുഷ്മാഭി ർമാം പ്രതി യത് പത്രമലേഖി തസ്യോത്തരമേതത്, യോഷിതോഽസ്പർശനം മനുജസ്യ വരം; ");
INSERT INTO sanmal_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","കിന്തു വ്യഭിചാരഭയാദ് ഏകൈകസ്യ പുംസഃ സ്വകീയഭാര്യ്യാ ഭവതു തദ്വദ് ഏകൈകസ്യാ യോഷിതോ ഽപി സ്വകീയഭർത്താ ഭവതു| ");
INSERT INTO sanmal_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","ഭാര്യ്യായൈ ഭർത്രാ യദ്യദ് വിതരണീയം തദ് വിതീര്യ്യതാം തദ്വദ് ഭർത്രേഽപി ഭാര്യ്യയാ വിതരണീയം വിതീര്യ്യതാം| ");
INSERT INTO sanmal_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","ഭാര്യ്യായാഃ സ്വദേഹേ സ്വത്വം നാസ്തി ഭർത്തുരേവ, തദ്വദ് ഭർത്തുരപി സ്വദേഹേ സ്വത്വം നാസ്തി ഭാര്യ്യായാ ഏവ| ");
INSERT INTO sanmal_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","ഉപോഷണപ്രാർഥനയോഃ സേവനാർഥമ് ഏകമന്ത്രണാനാം യുഷ്മാകം കിയത്കാലം യാവദ് യാ പൃഥക്സ്ഥിതി ർഭവതി തദന്യോ വിച്ഛേദോ യുഷ്മന്മധ്യേ ന ഭവതു, തതഃ പരമ് ഇന്ദ്രിയാണാമ് അധൈര്യ്യാത് ശയതാൻ യദ് യുഷ്മാൻ പരീക്ഷാം ന നയേത് തദർഥം പുനരേകത്ര മിലത| ");
INSERT INTO sanmal_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","ഏതദ് ആദേശതോ നഹി കിന്ത്വനുജ്ഞാത ഏവ മയാ കഥ്യതേ, ");
INSERT INTO sanmal_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","യതോ മമാവസ്ഥേവ സർവ്വമാനവാനാമവസ്ഥാ ഭവത്വിതി മമ വാഞ്ഛാ കിന്ത്വീശ്വരാദ് ഏകേനൈകോ വരോഽന്യേന ചാന്യോ വര ഇത്ഥമേകൈകേന സ്വകീയവരോ ലബ്ധഃ| ");
INSERT INTO sanmal_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","അപരമ് അകൃതവിവാഹാൻ വിധവാശ്ച പ്രതി മമൈതന്നിവേദനം മമേവ തേഷാമവസ്ഥിതി ർഭദ്രാ; ");
INSERT INTO sanmal_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","കിഞ്ച യദി തൈരിന്ദ്രിയാണി നിയന്തും ന ശക്യന്തേ തർഹി വിവാഹഃ ക്രിയതാം യതഃ കാമദഹനാദ് വ്യൂഢത്വം ഭദ്രം| ");
INSERT INTO sanmal_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","യേ ച കൃതവിവാഹാസ്തേ മയാ നഹി പ്രഭുനൈവൈതദ് ആജ്ഞാപ്യന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","ഭാര്യ്യാ ഭർത്തൃതഃ പൃഥക് ന ഭവതു| യദി വാ പൃഥഗ്ഭൂതാ സ്യാത് തർഹി നിർവിവാഹാ തിഷ്ഠതു സ്വീയപതിനാ വാ സന്ദധാതു ഭർത്താപി ഭാര്യ്യാം ന ത്യജതു| ");
INSERT INTO sanmal_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","ഇതരാൻ ജനാൻ പ്രതി പ്രഭു ർന ബ്രവീതി കിന്ത്വഹം ബ്രവീമി; കസ്യചിദ് ഭ്രാതുര്യോഷിദ് അവിശ്വാസിനീ സത്യപി യദി തേന സഹവാസേ തുഷ്യതി തർഹി സാ തേന ന ത്യജ്യതാം| ");
INSERT INTO sanmal_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","തദ്വത് കസ്യാശ്ചിദ് യോഷിതഃ പതിരവിശ്വാസീ സന്നപി യദി തയാ സഹവാസേ തുഷ്യതി തർഹി സ തയാ ന ത്യജ്യതാം| ");
INSERT INTO sanmal_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","യതോഽവിശ്വാസീ ഭർത്താ ഭാര്യ്യയാ പവിത്രീഭൂതഃ, തദ്വദവിശ്വാസിനീ ഭാര്യ്യാ ഭർത്രാ പവിത്രീഭൂതാ; നോചേദ് യുഷ്മാകമപത്യാന്യശുചീന്യഭവിഷ്യൻ കിന്ത്വധുനാ താനി പവിത്രാണി സന്തി| ");
INSERT INTO sanmal_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","അവിശ്വാസീ ജനോ യദി വാ പൃഥഗ് ഭവതി തർഹി പൃഥഗ് ഭവതു; ഏതേന ഭ്രാതാ ഭഗിനീ വാ ന നിബധ്യതേ തഥാപി വയമീശ്വരേണ ശാന്തയേ സമാഹൂതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","ഹേ നാരി തവ ഭർത്തുഃ പരിത്രാണം ത്വത്തോ ഭവിഷ്യതി ന വേതി ത്വയാ കിം ജ്ഞായതേ? ഹേ നര തവ ജായായാഃ പരിത്രാണം ത്വത്തേा ഭവിഷ്യതി ന വേതി ത്വയാ കിം ജ്ഞായതേ? ");
INSERT INTO sanmal_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","ഏകൈകോ ജനഃ പരമേശ്വരാല്ലബ്ധം യദ് ഭജതേ യസ്യാഞ്ചാവസ്ഥായാമ് ഈശ്വരേണാഹ്വായി തദനുസാരേണൈവാചരതു തദഹം സർവ്വസമാജസ്ഥാൻ ആദിശാമി| ");
INSERT INTO sanmal_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","ഛിന്നത്വഗ് ഭൃത്വാ യ ആഹൂതഃ സ പ്രകൃഷ്ടത്വക് ന ഭവതു, തദ്വദ് അഛിന്നത്വഗ് ഭൂത്വാ യ ആഹൂതഃ സ ഛിന്നത്വക് ന ഭവതു| ");
INSERT INTO sanmal_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","ത്വക്ഛേദഃ സാരോ നഹി തദ്വദത്വക്ഛേദോഽപി സാരോ നഹി കിന്ത്വീശ്വരസ്യാജ്ഞാനാം പാലനമേവ| ");
INSERT INTO sanmal_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","യോ ജനോ യസ്യാമവസ്ഥായാമാഹ്വായി സ തസ്യാമേവാവതിഷ്ഠതാം| ");
INSERT INTO sanmal_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","ദാസഃ സൻ ത്വം കിമാഹൂതോഽസി? തന്മാ ചിന്തയ, തഥാച യദി സ്വതന്ത്രോ ഭവിതും ശക്നുയാസ്തർഹി തദേവ വൃണു| ");
INSERT INTO sanmal_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","യതഃ പ്രഭുനാഹൂതോ യോ ദാസഃ സ പ്രഭോ ർമോചിതജനഃ| തദ്വദ് തേനാഹൂതഃ സ്വതന്ത്രോ ജനോഽപി ഖ്രീഷ്ടസ്യ ദാസ ഏവ| ");
INSERT INTO sanmal_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","യൂയം മൂല്യേന ക്രീതാ അതോ ഹേതോ ർമാനവാനാം ദാസാ മാ ഭവത| ");
INSERT INTO sanmal_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","ഹേ ഭ്രാതരോ യസ്യാമവസ്ഥായാം യസ്യാഹ്വാനമഭവത് തയാ സ ഈശ്വരസ്യ സാക്ഷാത് തിഷ്ഠതു| ");
INSERT INTO sanmal_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","അപരമ് അകൃതവിവാഹാൻ ജനാൻ പ്രതി പ്രഭോഃ കോഽപ്യാദേശോ മയാ ന ലബ്ധഃ കിന്തു പ്രഭോരനുകമ്പയാ വിശ്വാസ്യോ ഭൂതോഽഹം യദ് ഭദ്രം മന്യേ തദ് വദാമി| ");
INSERT INTO sanmal_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","വർത്തമാനാത് ക്ലേശസമയാത് മനുഷ്യസ്യാനൂഢത്വം ഭദ്രമിതി മയാ ബുധ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","ത്വം കിം യോഷിതി നിബദ്ധോഽസി തർഹി മോചനം പ്രാപ്തും മാ യതസ്വ| കിം വാ യോഷിതോ മുക്തോഽസി? തർഹി ജായാം മാ ഗവേഷയ| ");
INSERT INTO sanmal_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","വിവാഹം കുർവ്വതാ ത്വയാ കിമപി നാപാരാധ്യതേ തദ്വദ് വ്യൂഹ്യമാനയാ യുവത്യാപി കിമപി നാപരാധ്യതേ തഥാച താദൃശൗ ദ്വൗ ജനൗ ശാരീരികം ക്ലേശം ലപ്സ്യേതേ കിന്തു യുഷ്മാൻ പ്രതി മമ കരുണാ വിദ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","ഹേ ഭ്രാതരോഽഹമിദം ബ്രവീമി, ഇതഃ പരം സമയോഽതീവ സംക്ഷിപ്തഃ, ");
INSERT INTO sanmal_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","അതഃ കൃതദാരൈരകൃതദാരൈരിവ രുദദ്ഭിശ്ചാരുദദ്ഭിരിവ സാനന്ദൈശ്ച നിരാനന്ദൈരിവ ക്രേതൃഭിശ്ചാഭാഗിഭിരിവാചരിതവ്യം ");
INSERT INTO sanmal_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","യേ ച സംസാരേ ചരന്തി തൈ ർനാതിചരിതവ്യം യത ഇഹലേाകസ്യ കൗതുകോ വിചലതി| ");
INSERT INTO sanmal_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","കിന്തു യൂയം യന്നിശ്ചിന്താ ഭവേതേതി മമ വാഞ്ഛാ| അകൃതവിവാഹോ ജനോ യഥാ പ്രഭും പരിതോഷയേത് തഥാ പ്രഭും ചിന്തയതി, ");
INSERT INTO sanmal_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","കിന്തു കൃതവിവാഹോ ജനോ യഥാ ഭാര്യ്യാം പരിതോഷയേത് തഥാ സംസാരം ചിന്തയതി| ");
INSERT INTO sanmal_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","തദ്വദ് ഊഢയോഷിതോ ഽനൂഢാ വിശിഷ്യതേ| യാനൂഢാ സാ യഥാ കായമനസോഃ പവിത്രാ ഭവേത് തഥാ പ്രഭും ചിന്തയതി യാ ചോഢാ സാ യഥാ ഭർത്താരം പരിതോഷയേത് തഥാ സംസാരം ചിന്തയതി| ");
INSERT INTO sanmal_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","അഹം യദ് യുഷ്മാൻ മൃഗബന്ധിന്യാ പരിക്ഷിപേയം തദർഥം നഹി കിന്തു യൂയം യദനിന്ദിതാ ഭൂത്വാ പ്രഭോഃ സേവനേഽബാധമ് ആസക്താ ഭവേത തദർഥമേതാനി സർവ്വാണി യുഷ്മാകം ഹിതായ മയാ കഥ്യന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","കസ്യചിത് കന്യായാം യൗവനപ്രാപ്തായാം യദി സ തസ്യാ അനൂഢത്വം നിന്ദനീയം വിവാഹശ്ച സാധയിതവ്യ ഇതി മന്യതേ തർഹി യഥാഭിലാഷം കരോതു, ഏതേന കിമപി നാപരാത്സ്യതി വിവാഹഃ ക്രിയതാം| ");
INSERT INTO sanmal_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","കിന്തു ദുഃഖേനാക്ലിഷ്ടഃ കശ്ചിത് പിതാ യദി സ്ഥിരമനോഗതഃ സ്വമനോഽഭിലാഷസാധനേ സമർഥശ്ച സ്യാത് മമ കന്യാ മയാ രക്ഷിതവ്യേതി മനസി നിശ്ചിനോതി ച തർഹി സ ഭദ്രം കർമ്മ കരോതി| ");
INSERT INTO sanmal_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","അതോ യോ വിവാഹം കരോതി സ ഭദ്രം കർമ്മ കരോതി യശ്ച വിവാഹം ന കരോതി സ ഭദ്രതരം കർമ്മ കരോതി| ");
INSERT INTO sanmal_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","യാവത്കാലം പതി ർജീവതി താവദ് ഭാര്യ്യാ വ്യവസ്ഥയാ നിബദ്ധാ തിഷ്ഠതി കിന്തു പത്യൗ മഹാനിദ്രാം ഗതേ സാ മുക്തീഭൂയ യമഭിലഷതി തേന സഹ തസ്യാ വിവാഹോ ഭവിതും ശക്നോതി, കിന്ത്വേതത് കേവലം പ്രഭുഭക്താനാം മധ്യേ| ");
INSERT INTO sanmal_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","തഥാച സാ യദി നിഷ്പതികാ തിഷ്ഠതി തർഹി തസ്യാഃ ക്ഷേമം ഭവിഷ്യതീതി മമ ഭാവഃ| അപരമ് ഈശ്വരസ്യാത്മാ മമാപ്യന്ത ർവിദ്യത ഇതി മയാ ബുധ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","ദേവപ്രസാദേ സർവ്വേഷാമ് അസ്മാകം ജ്ഞാനമാസ്തേ തദ്വയം വിദ്മഃ| തഥാപി ജ്ഞാനം ഗർവ്വം ജനയതി കിന്തു പ്രേമതോ നിഷ്ഠാ ജായതേ| ");
INSERT INTO sanmal_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","അതഃ കശ്ചന യദി മന്യതേ മമ ജ്ഞാനമാസ്ത ഇതി തർഹി തേന യാദൃശം ജ്ഞാനം ചേഷ്ടിതവ്യം താദൃശം കിമപി ജ്ഞാനമദ്യാപി ന ലബ്ധം| ");
INSERT INTO sanmal_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","കിന്തു യ ഈശ്വരേ പ്രീയതേ സ ഈശ്വരേണാപി ജ്ഞായതേ| ");
INSERT INTO sanmal_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","ദേവതാബലിപ്രസാദഭക്ഷണേ വയമിദം വിദ്മോ യത് ജഗന്മധ്യേ കോഽപി ദേവോ ന വിദ്യതേ, ഏകശ്ചേശ്വരോ ദ്വിതീയോ നാസ്തീതി| ");
INSERT INTO sanmal_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","സ്വർഗേ പൃഥിവ്യാം വാ യദ്യപി കേഷുചിദ് ഈശ്വര ഇതി നാമാരോപ്യതേ താദൃശാശ്ച ബഹവ ഈശ്വരാ ബഹവശ്ച പ്രഭവോ വിദ്യന്തേ ");
INSERT INTO sanmal_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","തഥാപ്യസ്മാകമദ്വിതീയ ഈശ്വരഃ സ പിതാ യസ്മാത് സർവ്വേഷാം യദർഥഞ്ചാസ്മാകം സൃഷ്ടി ർജാതാ, അസ്മാകഞ്ചാദ്വിതീയഃ പ്രഭുഃ സ യീശുഃ ഖ്രീഷ്ടോ യേന സർവ്വവസ്തൂനാം യേനാസ്മാകമപി സൃഷ്ടിഃ കൃതാ| ");
INSERT INTO sanmal_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","അധികന്തു ജ്ഞാനം സർവ്വേഷാം നാസ്തി യതഃ കേചിദദ്യാപി ദേവതാം സമ്മന്യ ദേവപ്രസാദമിവ തദ് ഭക്ഷ്യം ഭുഞ്ജതേ തേന ദുർബ്ബലതയാ തേഷാം സ്വാന്താനി മലീമസാനി ഭവന്തി| ");
INSERT INTO sanmal_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","കിന്തു ഭക്ഷ്യദ്രവ്യാദ് വയമ് ഈശ്വരേണ ഗ്രാഹ്യാ ഭവാമസ്തന്നഹി യതോ ഭുങ്ക്ത്വാ വയമുത്കൃഷ്ടാ ന ഭവാമസ്തദ്വദഭുങ്ക്ത്വാപ്യപകൃഷ്ടാ ന ഭവാമഃ| ");
INSERT INTO sanmal_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","അതോ യുഷ്മാകം യാ ക്ഷമതാ സാ ദുർബ്ബലാനാമ് ഉന്മാഥസ്വരൂപാ യന്ന ഭവേത് തദർഥം സാവധാനാ ഭവത| ");
INSERT INTO sanmal_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","യതോ ജ്ഞാനവിശിഷ്ടസ്ത്വം യദി ദേവാലയേ ഉപവിഷ്ടഃ കേനാപി ദൃശ്യസേ തർഹി തസ്യ ദുർബ്ബലസ്യ മനസി കിം പ്രസാദഭക്ഷണ ഉത്സാഹോ ന ജനിഷ്യതേ? ");
INSERT INTO sanmal_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","തഥാ സതി യസ്യ കൃതേ ഖ്രീഷ്ടോ മമാര തവ സ ദുർബ്ബലോ ഭ്രാതാ തവ ജ്ഞാനാത് കിം ന വിനംക്ഷ്യതി? ");
INSERT INTO sanmal_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","ഇത്യനേന പ്രകാരേണ ഭ്രാതൃണാം വിരുദ്ധമ് അപരാധ്യദ്ഭിസ്തേഷാം ദുർബ്ബലാനി മനാംസി വ്യാഘാതയദ്ഭിശ്ച യുഷ്മാഭിഃ ഖ്രീഷ്ടസ്യ വൈപരീത്യേനാപരാധ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","അതോ ഹേതോഃ പിശിതാശനം യദി മമ ഭ്രാതു ർവിഘ്നസ്വരൂപം ഭവേത് തർഹ്യഹം യത് സ്വഭ്രാതു ർവിഘ്നജനകോ ന ഭവേയം തദർഥം യാവജ്ജീവനം പിശിതം ന ഭോക്ഷ്യേ| ");
INSERT INTO sanmal_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","അഹം കിമ് ഏകഃ പ്രേരിതോ നാസ്മി? കിമഹം സ്വതന്ത്രോ നാസ്മി? അസ്മാകം പ്രഭു ര്യീശുഃ ഖ്രീഷ്ടഃ കിം മയാ നാദർശി? യൂയമപി കിം പ്രഭുനാ മദീയശ്രമഫലസ്വരൂപാ ന ഭവഥ? ");
INSERT INTO sanmal_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","അന്യലോകാനാം കൃതേ യദ്യപ്യഹം പ്രേരിതോ ന ഭവേയം തഥാച യുഷ്മത്കൃതേ പ്രേരിതോഽസ്മി യതഃ പ്രഭുനാ മമ പ്രേരിതത്വപദസ്യ മുദ്രാസ്വരൂപാ യൂയമേവാധ്വേ| ");
INSERT INTO sanmal_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","യേ ലോകാ മയി ദോഷമാരോപയന്തി താൻ പ്രതി മമ പ്രത്യുത്തരമേതത്| ");
INSERT INTO sanmal_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","ഭോജനപാനയോഃ കിമസ്മാകം ക്ഷമതാ നാസ്തി? ");
INSERT INTO sanmal_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","അന്യേ പ്രേരിതാഃ പ്രഭോ ർഭ്രാതരൗ കൈഫാശ്ച യത് കുർവ്വന്തി തദ്വത് കാഞ്ചിത് ധർമ്മഭഗിനീം വ്യൂഹ്യ തയാ സാർദ്ധം പര്യ്യടിതും വയം കിം ന ശക്നുമഃ? ");
INSERT INTO sanmal_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","സാംസാരികശ്രമസ്യ പരിത്യാഗാത് കിം കേവലമഹം ബർണബ്ബാശ്ച നിവാരിതൗ? ");
INSERT INTO sanmal_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","നിജധനവ്യയേന കഃ സംഗ്രാമം കരോതി? കോ വാ ദ്രാക്ഷാക്ഷേത്രം കൃത്വാ തത്ഫലാനി ന ഭുങ്ക്തേ? കോ വാ പശുവ്രജം പാലയൻ തത്പയോ ന പിവതി? ");
INSERT INTO sanmal_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","കിമഹം കേവലാം മാനുഷികാം വാചം വദാമി? വ്യവസ്ഥായാം കിമേതാദൃശം വചനം ന വിദ്യതേ? ");
INSERT INTO sanmal_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","മൂസാവ്യവസ്ഥാഗ്രന്ഥേ ലിഖിതമാസ്തേ, ത്വം ശസ്യമർദ്ദകവൃഷസ്യാസ്യം ന ഭംത്സ്യസീതി| ഈശ്വരേണ ബലീവർദ്ദാനാമേവ ചിന്താ കിം ക്രിയതേ? ");
INSERT INTO sanmal_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","കിം വാ സർവ്വഥാസ്മാകം കൃതേ തദ്വചനം തേനോക്തം? അസ്മാകമേവ കൃതേ തല്ലിഖിതം| യഃ ക്ഷേത്രം കർഷതി തേന പ്രത്യാശായുക്തേന കർഷ്ടവ്യം, യശ്ച ശസ്യാനി മർദ്ദയതി തേന ലാഭപ്രത്യാശായുക്തേന മർദ്ദിതവ്യം| ");
INSERT INTO sanmal_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","യുഷ്മത്കൃതേഽസ്മാഭിഃ പാരത്രികാണി ബീജാനി രോപിതാനി, അതോ യുഷ്മാകമൈഹികഫലാനാം വയമ് അംശിനോ ഭവിഷ്യാമഃ കിമേതത് മഹത് കർമ്മ? ");
INSERT INTO sanmal_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","യുഷ്മാസു യോഽധികാരസ്തസ്യ ഭാഗിനോ യദ്യന്യേ ഭവേയുസ്തർഹ്യസ്മാഭിസ്തതോഽധികം കിം തസ്യ ഭാഗിഭി ർന ഭവിതവ്യം? അധികന്തു വയം തേനാധികാരേണ ന വ്യവഹൃതവന്തഃ കിന്തു ഖ്രീഷ്ടീയസുസംവാദസ്യ കോഽപി വ്യാഘാതോഽസ്മാഭിര്യന്ന ജായേത തദർഥം സർവ്വം സഹാമഹേ| ");
INSERT INTO sanmal_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","അപരം യേ പവിത്രവസ്തൂനാം പരിചര്യ്യാം കുർവ്വന്തി തേ പവിത്രവസ്തുതോ ഭക്ഷ്യാണി ലഭന്തേ, യേ ച വേദ്യാഃ പരിചര്യ്യാം കുർവ്വന്തി തേ വേദിസ്ഥവസ്തൂനാമ് അംശിനോ ഭവന്ത്യേതദ് യൂയം കിം ന വിദ? ");
INSERT INTO sanmal_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","തദ്വദ് യേ സുസംവാദം ഘോഷയന്തി തൈഃ സുസംവാദേന ജീവിതവ്യമിതി പ്രഭുനാദിഷ്ടം| ");
INSERT INTO sanmal_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","അഹമേതേഷാം സർവ്വേഷാം കിമപി നാശ്രിതവാൻ മാം പ്രതി തദനുസാരാത് ആചരിതവ്യമിത്യാശയേനാപി പത്രമിദം മയാ ന ലിഖ്യതേ യതഃ കേനാപി ജനേന മമ യശസോ മുധാകരണാത് മമ മരണം വരം| ");
INSERT INTO sanmal_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","സുസംവാദഘേഷണാത് മമ യശോ ന ജായതേ യതസ്തദ്ഘോഷണം മമാവശ്യകം യദ്യഹം സുസംവാദം ന ഘോഷയേയം തർഹി മാം ധിക്| ");
INSERT INTO sanmal_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","ഇച്ഛുകേന തത് കുർവ്വതാ മയാ ഫലം ലപ്സ്യതേ കിന്ത്വനിച്ഛുകേഽപി മയി തത്കർമ്മണോ ഭാരോഽർപിതോഽസ്തി| ");
INSERT INTO sanmal_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","ഏതേന മയാ ലഭ്യം ഫലം കിം? സുസംവാദേന മമ യോഽധികാര ആസ്തേ തം യദഭദ്രഭാവേന നാചരേയം തദർഥം സുസംവാദഘോഷണസമയേ തസ്യ ഖ്രീഷ്ടീയസുസംവാദസ്യ നിർവ്യയീകരണമേവ മമ ഫലം| ");
INSERT INTO sanmal_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","സർവ്വേഷാമ് അനായത്തോഽഹം യദ് ഭൂരിശോ ലോകാൻ പ്രതിപദ്യേ തദർഥം സർവ്വേഷാം ദാസത്വമങ്ഗീകൃതവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","യിഹൂദീയാൻ യത് പ്രതിപദ്യേ തദർഥം യിഹൂദീയാനാം കൃതേ യിഹൂദീയഇവാഭവം| യേ ച വ്യവസ്ഥായത്താസ്താൻ യത് പ്രതിപദ്യേ തദർഥം വ്യവസ്ഥാനായത്തോ യോഽഹം സോഽഹം വ്യവസ്ഥായത്താനാം കൃതേ വ്യവസ്ഥായത്തഇവാഭവം| ");
INSERT INTO sanmal_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","യേ ചാലബ്ധവ്യവസ്ഥാസ്താൻ യത് പ്രതിപദ്യേ തദർഥമ് ഈശ്വരസ്യ സാക്ഷാദ് അലബ്ധവ്യവസ്ഥോ ന ഭൂത്വാ ഖ്രീഷ്ടേന ലബ്ധവ്യവസ്ഥോ യോഽഹം സോഽഹമ് അലബ്ധവ്യവസ്ഥാനാം കൃതേഽലബ്ധവ്യവസ്ഥ ഇവാഭവം| ");
INSERT INTO sanmal_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","ദുർബ്ബലാൻ യത് പ്രതിപദ്യേ തദർഥമഹം ദുർബ്ബലാനാം കൃതേ ദുർബ്ബലഇവാഭവം| ഇത്ഥം കേനാപി പ്രകാരേണ കതിപയാ ലോകാ യന്മയാ പരിത്രാണം പ്രാപ്നുയുസ്തദർഥം യോ യാദൃശ ആസീത് തസ്യ കൃതേ ഽഹം താദൃശഇവാഭവം| ");
INSERT INTO sanmal_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","ഇദൃശ ആചാരഃ സുസംവാദാർഥം മയാ ക്രിയതേ യതോഽഹം തസ്യ ഫലാനാം സഹഭാഗീ ഭവിതുമിച്ഛാമി| ");
INSERT INTO sanmal_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","പണ്യലാഭാർഥം യേ ധാവന്തി ധാവതാം തേഷാം സർവ്വേഷാം കേവല ഏകഃ പണ്യം ലഭതേ യുഷ്മാഭിഃ കിമേതന്ന ജ്ഞായതേ? അതോ യൂയം യഥാ പണ്യം ലപ്സ്യധ്വേ തഥൈവ ധാവത| ");
INSERT INTO sanmal_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","മല്ലാ അപി സർവ്വഭോഗേ പരിമിതഭോഗിനോ ഭവന്തി തേ തു മ്ലാനാം സ്രജം ലിപ്സന്തേ കിന്തു വയമ് അമ്ലാനാം ലിപ്സാമഹേ| ");
INSERT INTO sanmal_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","തസ്മാദ് അഹമപി ധാവാമി കിന്തു ലക്ഷ്യമനുദ്ദിശ്യ ധാവാമി തന്നഹി| അഹം മല്ലഇവ യുധ്യാമി ച കിന്തു ഛായാമാഘാതയന്നിവ യുധ്യാമി തന്നഹി| ");
INSERT INTO sanmal_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","ഇതരാൻ പ്രതി സുസംവാദം ഘോഷയിത്വാഹം യത് സ്വയമഗ്രാഹ്യോ ന ഭവാമി തദർഥം ദേഹമ് ആഹന്മി വശീകുർവ്വേ ച| ");
INSERT INTO sanmal_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","ഹേ ഭ്രാതരഃ, അസ്മത്പിതൃപുരുഷാനധി യൂയം യദജ്ഞാതാ ന തിഷ്ഠതേതി മമ വാഞ്ഛാ, തേ സർവ്വേ മേഘാധഃസ്ഥിതാ ബഭൂവുഃ സർവ്വേ സമുദ്രമധ്യേന വവ്രജുഃ, ");
INSERT INTO sanmal_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","സർവ്വേ മൂസാമുദ്ദിശ്യ മേഘസമുദ്രയോ ർമജ്ജിതാ ബഭൂവുഃ ");
INSERT INTO sanmal_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","സർവ്വ ഏകമ് ആത്മികം ഭക്ഷ്യം ബുഭുജിര ഏകമ് ആത്മികം പേയം പപുശ്ച ");
INSERT INTO sanmal_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","യതസ്തേഽനുചരത ആത്മികാദ് അചലാത് ലബ്ധം തോയം പപുഃ സോഽചലഃ ഖ്രീഷ്ടഏവ| ");
INSERT INTO sanmal_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","തഥാ സത്യപി തേഷാം മധ്യേഽധികേഷു ലോകേഷ്വീശ്വരോ ന സന്തുതോഷേതി ഹേതോസ്തേ പ്രന്തരേ നിപാതിതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","ഏതസ്മിൻ തേ ഽസ്മാകം നിദർശനസ്വരൂപാ ബഭൂവുഃ; അതസ്തേ യഥാ കുത്സിതാഭിലാഷിണോ ബഭൂവുരസ്മാഭിസ്തഥാ കുത്സിതാഭിലാഷിഭി ർന ഭവിതവ്യം| ");
INSERT INTO sanmal_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","ലിഖിതമാസ്തേ, ലോകാ ഭോക്തും പാതുഞ്ചോപവിവിശുസ്തതഃ ക്രീഡിതുമുത്ഥിതാ ഇതയനേന പ്രകാരേണ തേഷാം കൈശ്ചിദ് യദ്വദ് ദേവപൂജാ കൃതാ യുഷ്മാഭിസ്തദ്വത് ന ക്രിയതാം| ");
INSERT INTO sanmal_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","അപരം തേഷാം കൈശ്ചിദ് യദ്വദ് വ്യഭിചാരഃ കൃതസ്തേന ചൈകസ്മിൻ ദിനേ ത്രയോവിംശതിസഹസ്രാണി ലോകാ നിപാതിതാസ്തദ്വദ് അസ്മാഭി ർവ്യഭിചാരോ ന കർത്തവ്യഃ| ");
INSERT INTO sanmal_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","തേഷാം കേചിദ് യദ്വത് ഖ്രീഷ്ടം പരീക്ഷിതവന്തസ്തസ്മാദ് ഭുജങ്ഗൈ ർനഷ്ടാശ്ച തദ്വദ് അസ്മാഭിഃ ഖ്രീഷ്ടോ ന പരീക്ഷിതവ്യഃ| ");
INSERT INTO sanmal_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","തേഷാം കേചിദ് യഥാ വാക്കലഹം കൃതവന്തസ്തത്കാരണാത് ഹന്ത്രാ വിനാശിതാശ്ച യുഷ്മാഭിസ്തദ്വദ് വാക്കലഹോ ന ക്രിയതാം| ");
INSERT INTO sanmal_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","താൻ പ്രതി യാന്യേതാനി ജഘടിരേ താന്യസ്മാകം നിദർശനാനി ജഗതഃ ശേഷയുഗേ വർത്തമാനാനാമ് അസ്മാകം ശിക്ഷാർഥം ലിഖിതാനി ച ബഭൂവുഃ| ");
INSERT INTO sanmal_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","അതഏവ യഃ കശ്ചിദ് സുസ്ഥിരംമന്യഃ സ യന്ന പതേത് തത്ര സാവധാനോ ഭവതു| ");
INSERT INTO sanmal_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","മാനുഷികപരീക്ഷാതിരിക്താ കാപി പരീക്ഷാ യുഷ്മാൻ നാക്രാമത്, ഈശ്വരശ്ച വിശ്വാസ്യഃ സോഽതിശക്ത്യാം പരീക്ഷായാം പതനാത് യുഷ്മാൻ രക്ഷിഷ്യതി, പരീക്ഷാ ച യദ് യുഷ്മാഭിഃ സോഢും ശക്യതേ തദർഥം തയാ സഹ നിസ്താരസ്യ പന്ഥാനം നിരൂപയിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","ഹേ പ്രിയഭ്രാതരഃ, ദേവപൂജാതോ ദൂരമ് അപസരത| ");
INSERT INTO sanmal_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","അഹം യുഷ്മാൻ വിജ്ഞാൻ മത്വാ പ്രഭാഷേ മയാ യത് കഥ്യതേ തദ് യുഷ്മാഭി ർവിവിച്യതാം| ");
INSERT INTO sanmal_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","യദ് ധന്യവാദപാത്രമ് അസ്മാഭി ർധന്യം ഗദ്യതേ തത് കിം ഖ്രീഷ്ടസ്യ ശോണിതസ്യ സഹഭാഗിത്വം നഹി? യശ്ച പൂപോഽസ്മാഭി ർഭജ്യതേ സ കിം ഖ്രീഷ്ടസ്യ വപുഷഃ സഹഭാഗിത്വം നഹി? ");
INSERT INTO sanmal_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","വയം ബഹവഃ സന്തോഽപ്യേകപൂപസ്വരൂപാ ഏകവപുഃസ്വരൂപാശ്ച ഭവാമഃ, യതോ വയം സർവ്വ ഏകപൂപസ്യ സഹഭാഗിനഃ| ");
INSERT INTO sanmal_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","യൂയം ശാരീരികമ് ഇസ്രായേലീയവംശം നിരീക്ഷധ്വം| യേ ബലീനാം മാംസാനി ഭുഞ്ജതേ തേ കിം യജ്ഞവേദ്യാഃ സഹഭാഗിനോ ന ഭവന്തി? ");
INSERT INTO sanmal_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","ഇത്യനേന മയാ കിം കഥ്യതേ? ദേവതാ വാസ്തവികീ ദേവതായൈ ബലിദാനം വാ വാസ്തവികം കിം ഭവേത്? ");
INSERT INTO sanmal_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","തന്നഹി കിന്തു ഭിന്നജാതിഭി ര്യേ ബലയോ ദീയന്തേ ത ഈശ്വരായ തന്നഹി ഭൂതേഭ്യഏവ ദീയന്തേ തസ്മാദ് യൂയം യദ് ഭൂതാനാം സഹഭാഗിനോ ഭവഥേത്യഹം നാഭിലഷാമി| ");
INSERT INTO sanmal_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","പ്രഭോഃ കംസേന ഭൂതാനാമപി കംസേന പാനം യുഷ്മാഭിരസാധ്യം; യൂയം പ്രഭോ ർഭോജ്യസ്യ ഭൂതാനാമപി ഭോജ്യസ്യ സഹഭാഗിനോ ഭവിതും ന ശക്നുഥ| ");
INSERT INTO sanmal_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","വയം കിം പ്രഭും സ്പർദ്ധിഷ്യാമഹേ? വയം കിം തസ്മാദ് ബലവന്തഃ? ");
INSERT INTO sanmal_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","മാം പ്രതി സർവ്വം കർമ്മാപ്രതിഷിദ്ധം കിന്തു ന സർവ്വം ഹിതജനകം സർവ്വമ് അപ്രതിഷിദ്ധം കിന്തു ന സർവ്വം നിഷ്ഠാജനകം| ");
INSERT INTO sanmal_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","ആത്മഹിതഃ കേനാപി ന ചേഷ്ടിതവ്യഃ കിന്തു സർവ്വൈഃ പരഹിതശ്ചേഷ്ടിതവ്യഃ| ");
INSERT INTO sanmal_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","ആപണേ യത് ക്രയ്യം തദ് യുഷ്മാഭിഃ സംവേദസ്യാർഥം കിമപി ന പൃഷ്ട്വാ ഭുജ്യതാം ");
INSERT INTO sanmal_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","യതഃ പൃഥിവീ തന്മധ്യസ്ഥഞ്ച സർവ്വം പരമേശ്വരസ്യ| ");
INSERT INTO sanmal_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","അപരമ് അവിശ്വാസിലോകാനാം കേനചിത് നിമന്ത്രിതാ യൂയം യദി തത്ര ജിഗമിഷഥ തർഹി തേന യദ് യദ് ഉപസ്ഥാപ്യതേ തദ് യുഷ്മാഭിഃ സംവേദസ്യാർഥം കിമപി ന പൃഷ്ട്വാ ഭുജ്യതാം| ");
INSERT INTO sanmal_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","കിന്തു തത്ര യദി കശ്ചിദ് യുഷ്മാൻ വദേത് ഭക്ഷ്യമേതദ് ദേവതായാഃ പ്രസാദ ഇതി തർഹി തസ്യ ജ്ഞാപയിതുരനുരോധാത് സംവേദസ്യാർഥഞ്ച തദ് യുഷ്മാഭി ർന ഭോക്തവ്യം| പൃഥിവീ തന്മധ്യസ്ഥഞ്ച സർവ്വം പരമേശ്വരസ്യ, ");
INSERT INTO sanmal_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","സത്യമേതത്, കിന്തു മയാ യഃ സംവേദോ നിർദ്ദിശ്യതേ സ തവ നഹി പരസ്യൈവ| ");
INSERT INTO sanmal_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","അനുഗ്രഹപാത്രേണ മയാ ധന്യവാദം കൃത്വാ യദ് ഭുജ്യതേ തത്കാരണാദ് അഹം കുതോ നിന്ദിഷ്യേ? ");
INSERT INTO sanmal_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","തസ്മാദ് ഭോജനം പാനമ് അന്യദ്വാ കർമ്മ കുർവ്വദ്ഭി ര്യുഷ്മാഭിഃ സർവ്വമേവേശ്വരസ്യ മഹിമ്നഃ പ്രകാശാർഥം ക്രിയതാം| ");
INSERT INTO sanmal_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","യിഹൂദീയാനാം ഭിന്നജാതീയാനാമ് ഈശ്വരസ്യ സമാജസ്യ വാ വിഘ്നജനകൈ ര്യുഷ്മാഭി ർന ഭവിതവ്യം| ");
INSERT INTO sanmal_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","അഹമപ്യാത്മഹിതമ് അചേഷ്ടമാനോ ബഹൂനാം പരിത്രാണാർഥം തേഷാം ഹിതം ചേഷ്ടമാനഃ സർവ്വവിഷയേ സർവ്വേഷാം തുഷ്ടികരോ ഭവാമീത്യനേനാഹം യദ്വത് ഖ്രീഷ്ടസ്യാനുഗാമീ തദ്വദ് യൂയം മമാനുഗാമിനോ ഭവത| ");
INSERT INTO sanmal_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","ഹേ ഭ്രാതരഃ, യൂയം സർവ്വസ്മിൻ കാര്യ്യേ മാം സ്മരഥ മയാ ച യാദൃഗുപദിഷ്ടാസ്താദൃഗാചരഥൈതത്കാരണാത് മയാ പ്രശംസനീയാ ആധ്ബേ| ");
INSERT INTO sanmal_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","തഥാപി മമൈഷാ വാഞ്ഛാ യദ് യൂയമിദമ് അവഗതാ ഭവഥ, ");
INSERT INTO sanmal_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","ഏകൈകസ്യ പുരുഷസ്യോത്തമാങ്ഗസ്വരൂപഃ ഖ്രീഷ്ടഃ, യോഷിതശ്ചോത്തമാങ്ഗസ്വരൂപഃ പുമാൻ, ഖ്രീഷ്ടസ്യ ചോത്തമാങ്ഗസ്വരൂപ ഈശ്വരഃ| ");
INSERT INTO sanmal_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","അപരമ് ആച്ഛാദിതോത്തമാങ്ഗേന യേന പുംസാ പ്രാർഥനാ ക്രിയത ഈശ്വരീയവാണീ കഥ്യതേ വാ തേന സ്വീയോത്തമാങ്ഗമ് അവജ്ഞായതേ| ");
INSERT INTO sanmal_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","അനാച്ഛാദിതോത്തമാങ്ഗയാ യയാ യോഷിതാ ച പ്രാർഥനാ ക്രിയത ഈശ്വരീയവാണീ കഥ്യതേ വാ തയാപി സ്വീയോത്തമാങ്ഗമ് അവജ്ഞായതേ യതഃ സാ മുണ്ഡിതശിരഃസദൃശാ| ");
INSERT INTO sanmal_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","അനാച്ഛാദിതമസ്തകാ യാ യോഷിത് തസ്യാഃ ശിരഃ മുണ്ഡനീയമേവ കിന്തു യോഷിതഃ കേശച്ഛേദനം ശിരോമുണ്ഡനം വാ യദി ലജ്ജാജനകം ഭവേത് തർഹി തയാ സ്വശിര ആച്ഛാദ്യതാം| ");
INSERT INTO sanmal_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","പുമാൻ ഈശ്വരസ്യ പ്രതിമൂർത്തിഃ പ്രതിതേജഃസ്വരൂപശ്ച തസ്മാത് തേന ശിരോ നാച്ഛാദനീയം കിന്തു സീമന്തിനീ പുംസഃ പ്രതിബിമ്ബസ്വരൂപാ| ");
INSERT INTO sanmal_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","യതോ യോഷാതഃ പുമാൻ നോദപാദി കിന്തു പുംസോ യോഷിദ് ഉദപാദി| ");
INSERT INTO sanmal_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","അധികന്തു യോഷിതഃ കൃതേ പുംസഃ സൃഷ്ടി ർന ബഭൂവ കിന്തു പുംസഃ കൃതേ യോഷിതഃ സൃഷ്ടി ർബഭൂവ| ");
INSERT INTO sanmal_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","ഇതി ഹേതോ ർദൂതാനാമ് ആദരാദ് യോഷിതാ ശിരസ്യധീനതാസൂചകമ് ആവരണം ധർത്തവ്യം| ");
INSERT INTO sanmal_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","തഥാപി പ്രഭോ ർവിധിനാ പുമാംസം വിനാ യോഷിന്ന ജായതേ യോഷിതഞ്ച വിനാ പുമാൻ ന ജായതേ| ");
INSERT INTO sanmal_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","യതോ യഥാ പുംസോ യോഷിദ് ഉദപാദി തഥാ യോഷിതഃ പുമാൻ ജായതേ, സർവ്വവസ്തൂനി ചേശ്വരാദ് ഉത്പദ്യന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","യുഷ്മാഭിരേവൈതദ് വിവിച്യതാം, അനാവൃതയാ യോഷിതാ പ്രാർഥനം കിം സുദൃശ്യം ഭവേത്? ");
INSERT INTO sanmal_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","പുരുഷസ്യ ദീർഘകേശത്വം തസ്യ ലജ്ജാജനകം, കിന്തു യോഷിതോ ദീർഘകേശത്വം തസ്യാ ഗൗരവജനകം ");
INSERT INTO sanmal_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","യത ആച്ഛാദനായ തസ്യൈ കേശാ ദത്താ ഇതി കിം യുഷ്മാഭിഃ സ്വഭാവതോ ന ശിക്ഷ്യതേ? ");
INSERT INTO sanmal_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","അത്ര യദി കശ്ചിദ് വിവദിതുമ് ഇച്ഛേത് തർഹ്യസ്മാകമ് ഈശ്വരീയസമിതീനാഞ്ച താദൃശീ രീതി ർന വിദ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","യുഷ്മാഭി ർന ഭദ്രായ കിന്തു കുത്സിതായ സമാഗമ്യതേ തസ്മാദ് ഏതാനി ഭാഷമാണേന മയാ യൂയം ന പ്രശംസനീയാഃ| ");
INSERT INTO sanmal_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","പ്രഥമതഃ സമിതൗ സമാഗതാനാം യുഷ്മാകം മധ്യേ ഭേദാഃ സന്തീതി വാർത്താ മയാ ശ്രൂയതേ തന്മധ്യേ കിഞ്ചിത് സത്യം മന്യതേ ച| ");
INSERT INTO sanmal_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","യതോ ഹേതോ ര്യുഷ്മന്മധ്യേ യേ പരീക്ഷിതാസ്തേ യത് പ്രകാശ്യന്തേ തദർഥം ഭേദൈ ർഭവിതവ്യമേവ| ");
INSERT INTO sanmal_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","ഏകത്ര സമാഗതൈ ര്യുഷ്മാഭിഃ പ്രഭാവം ഭേाജ്യം ഭുജ്യത ഇതി നഹി; ");
INSERT INTO sanmal_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","യതോ ഭോജനകാലേ യുഷ്മാകമേകൈകേന സ്വകീയം ഭക്ഷ്യം തൂർണം ഗ്രസ്യതേ തസ്മാദ് ഏകോ ജനോ ബുഭുക്ഷിതസ്തിഷ്ഠതി, അന്യശ്ച പരിതൃപ്തോ ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","ഭോജനപാനാർഥം യുഷ്മാകം കിം വേശ്മാനി ന സന്തി? യുഷ്മാഭി ർവാ കിമ് ഈശ്വരസ്യ സമിതിം തുച്ഛീകൃത്യ ദീനാ ലോകാ അവജ്ഞായന്തേ? ഇത്യനേന മയാ കിം വക്തവ്യം? യൂയം കിം മയാ പ്രശംസനീയാഃ? ഏതസ്മിൻ യൂയം ന പ്രശംസനീയാഃ| ");
INSERT INTO sanmal_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","പ്രഭുതോ യ ഉപദേശോ മയാ ലബ്ധോ യുഷ്മാസു സമർപിതശ്ച സ ഏഷഃ| ");
INSERT INTO sanmal_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","പരകരസമർപണക്ഷപായാം പ്രഭു ര്യീശുഃ പൂപമാദായേശ്വരം ധന്യം വ്യാഹൃത്യ തം ഭങ്ക്ത്വാ ഭാഷിതവാൻ യുഷ്മാഭിരേതദ് ഗൃഹ്യതാം ഭുജ്യതാഞ്ച തദ് യുഷ്മത്കൃതേ ഭഗ്നം മമ ശരീരം; മമ സ്മരണാർഥം യുഷ്മാഭിരേതത് ക്രിയതാം| ");
INSERT INTO sanmal_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","പുനശ്ച ഭേജനാത് പരം തഥൈവ കംസമ് ആദായ തേനോക്തം കംസോഽയം മമ ശോണിതേന സ്ഥാപിതോ നൂതനനിയമഃ; യതിവാരം യുഷ്മാഭിരേതത് പീയതേ തതിവാരം മമ സ്മരണാർഥം പീയതാം| ");
INSERT INTO sanmal_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","യതിവാരം യുഷ്മാഭിരേഷ പൂപോ ഭുജ്യതേ ഭാജനേനാനേന പീയതേ ച തതിവാരം പ്രഭോരാഗമനം യാവത് തസ്യ മൃത്യുഃ പ്രകാശ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","അപരഞ്ച യഃ കശ്ചിദ് അയോഗ്യത്വേന പ്രഭോരിമം പൂപമ് അശ്നാതി തസ്യാനേന ഭാജനേന പിവതി ച സ പ്രഭോഃ കായരുധിരയോ ർദണ്ഡദായീ ഭവിഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","തസ്മാത് മാനവേനാഗ്ര ആത്മാന പരീക്ഷ്യ പശ്ചാദ് ഏഷ പൂപോ ഭുജ്യതാം കംസേനാനേന ച പീയതാം| ");
INSERT INTO sanmal_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","യേന ചാനർഹത്വേന ഭുജ്യതേ പീയതേ ച പ്രഭോഃ കായമ് അവിമൃശതാ തേന ദണ്ഡപ്രാപ്തയേ ഭുജ്യതേ പീയതേ ച| ");
INSERT INTO sanmal_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","ഏതത്കാരണാദ് യുഷ്മാകം ഭൂരിശോ ലോകാ ദുർബ്ബലാ രോഗിണശ്ച സന്തി ബഹവശ്ച മഹാനിദ്രാം ഗതാഃ| ");
INSERT INTO sanmal_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","അസ്മാഭി ര്യദ്യാത്മവിചാരോഽകാരിഷ്യത തർഹി ദണ്ഡോ നാലപ്സ്യത; ");
INSERT INTO sanmal_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","കിന്തു യദാസ്മാകം വിചാരോ ഭവതി തദാ വയം ജഗതോ ജനൈഃ സമം യദ് ദണ്ഡം ന ലഭാമഹേ തദർഥം പ്രഭുനാ ശാസ്തിം ഭുംജ്മഹേ| ");
INSERT INTO sanmal_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","ഹേ മമ ഭ്രാതരഃ, ഭോജനാർഥം മിലിതാനാം യുഷ്മാകമ് ഏകേനേതരോഽനുഗൃഹ്യതാം| ");
INSERT INTO sanmal_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","യശ്ച ബുഭുക്ഷിതഃ സ സ്വഗൃഹേ ഭുങ്ക്താം| ദണ്ഡപ്രാപ്തയേ യുഷ്മാഭി ർന സമാഗമ്യതാം| ഏതദ്ഭിന്നം യദ് ആദേഷ്ടവ്യം തദ് യുഷ്മത്സമീപാഗമനകാലേ മയാദേക്ഷ്യതേ| ");
INSERT INTO sanmal_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","ഹേ ഭ്രാതരഃ, യൂയം യദ് ആത്മികാൻ ദായാൻ അനവഗതാസ്തിഷ്ഠഥ തദഹം നാഭിലഷാമി| ");
INSERT INTO sanmal_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","പൂർവ്വം ഭിന്നജാതീയാ യൂയം യദ്വദ് വിനീതാസ്തദ്വദ് അവാക്പ്രതിമാനാമ് അനുഗാമിന ആധ്ബമ് ഇതി ജാനീഥ| ");
INSERT INTO sanmal_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","ഇതി ഹേതോരഹം യുഷ്മഭ്യം നിവേദയാമി, ഈശ്വരസ്യാത്മനാ ഭാഷമാണഃ കോഽപി യീശും ശപ്ത ഇതി ന വ്യാഹരതി, പുനശ്ച പവിത്രേണാത്മനാ വിനീതം വിനാന്യഃ കോഽപി യീശും പ്രഭുരിതി വ്യാഹർത്തും ന ശക്നോതി| ");
INSERT INTO sanmal_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","ദായാ ബഹുവിധാഃ കിന്ത്വേക ആത്മാ ");
INSERT INTO sanmal_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","പരിചര്യ്യാശ്ച ബഹുവിധാഃ കിന്ത്വേകഃ പ്രഭുഃ| ");
INSERT INTO sanmal_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","സാധനാനി ബഹുവിധാനി കിന്തു സർവ്വേഷു സർവ്വസാധക ഈശ്വര ഏകഃ| ");
INSERT INTO sanmal_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","ഏകൈകസ്മൈ തസ്യാത്മനോ ദർശനം പരഹിതാർഥം ദീയതേ| ");
INSERT INTO sanmal_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","ഏകസ്മൈ തേനാത്മനാ ജ്ഞാനവാക്യം ദീയതേ, അന്യസ്മൈ തേനൈവാത്മനാദിഷ്ടം വിദ്യാവാക്യമ്, ");
INSERT INTO sanmal_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","അന്യസ്മൈ തേനൈവാത്മനാ വിശ്വാസഃ, അന്യസ്മൈ തേനൈവാത്മനാ സ്വാസ്ഥ്യദാനശക്തിഃ, ");
INSERT INTO sanmal_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","അന്യസ്മൈ ദുഃസാധ്യസാധനശക്തിരന്യസ്മൈ ചേശ്വരീയാദേശഃ, അന്യസ്മൈ ചാതിമാനുഷികസ്യാദേശസ്യ വിചാരസാമർഥ്യമ്, അന്യസ്മൈ പരഭാഷാഭാഷണശക്തിരന്യസ്മൈ ച ഭാഷാർഥഭാഷണസാമര്യം ദീയതേ| ");
INSERT INTO sanmal_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","ഏകേനാദ്വിതീയേനാത്മനാ യഥാഭിലാഷമ് ഏകൈകസ്മൈ ജനായൈകൈകം ദാനം വിതരതാ താനി സർവ്വാണി സാധ്യന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","ദേഹ ഏകഃ സന്നപി യദ്വദ് ബഹ്വങ്ഗയുക്തോ ഭവതി, തസ്യൈകസ്യ വപുഷോ ഽങ്ഗാനാം ബഹുത്വേന യദ്വദ് ഏകം വപു ർഭവതി, തദ്വത് ഖ്രീഷ്ടഃ| ");
INSERT INTO sanmal_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","യതോ ഹേതോ ര്യിഹൂദിഭിന്നജാതീയദാസസ്വതന്ത്രാ വയം സർവ്വേ മജ്ജനേനൈകേനാത്മനൈകദേഹീകൃതാഃ സർവ്വേ ചൈകാത്മഭുക്താ അഭവാമ| ");
INSERT INTO sanmal_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","ഏകേനാങ്ഗേന വപു ർന ഭവതി കിന്തു ബഹുഭിഃ| ");
INSERT INTO sanmal_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","തത്ര ചരണം യദി വദേത് നാഹം ഹസ്തസ്തസ്മാത് ശരീരസ്യ ഭാഗോ നാസ്മീതി തർഹ്യനേന ശരീരാത് തസ്യ വിയോഗോ ന ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","ശ്രോത്രം വാ യദി വദേത് നാഹം നയനം തസ്മാത് ശരീരസ്യാംശോ നാസ്മീതി തർഹ്യനേന ശരീരാത് തസ്യ വിയോഗോ ന ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","കൃത്സ്നം ശരീരം യദി ദർശനേന്ദ്രിയം ഭവേത് തർഹി ശ്രവണേന്ദ്രിയം കുത്ര സ്ഥാസ്യതി? തത് കൃത്സ്നം യദി വാ ശ്രവണേന്ദ്രിയം ഭവേത് തർഹി ഘ്രണേന്ദ്രിയം കുത്ര സ്ഥാസ്യതി? ");
INSERT INTO sanmal_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","കിന്ത്വിദാനീമ് ഈശ്വരേണ യഥാഭിലഷിതം തഥൈവാങ്ഗപ്രത്യങ്ഗാനാമ് ഏകൈകം ശരീരേ സ്ഥാപിതം| ");
INSERT INTO sanmal_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","തത് കൃത്സ്നം യദ്യേകാങ്ഗരൂപി ഭവേത് തർഹി ശരീരേ കുത്ര സ്ഥാസ്യതി? ");
INSERT INTO sanmal_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","തസ്മാദ് അങ്ഗാനി ബഹൂനി സന്തി ശരീരം ത്വേകമേവ| ");
INSERT INTO sanmal_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","അതഏവ ത്വയാ മമ പ്രയോജനം നാസ്തീതി വാചം പാണിം വദിതും നയനം ന ശക്നോതി, തഥാ യുവാഭ്യാം മമ പ്രയോജനം നാസ്തീതി മൂർദ്ധാ ചരണൗ വദിതും ന ശക്നോതിഃ; ");
INSERT INTO sanmal_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","വസ്തുതസ്തു വിഗ്രഹസ്യ യാന്യങ്ഗാന്യസ്മാഭി ർദുർബ്ബലാനി ബുധ്യന്തേ താന്യേവ സപ്രയോജനാനി സന്തി| ");
INSERT INTO sanmal_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","യാനി ച ശരീരമധ്യേഽവമന്യാനി ബുധ്യതേ താന്യസ്മാഭിരധികം ശോഭ്യന്തേ| യാനി ച കുദൃശ്യാനി താനി സുദൃശ്യതരാണി ക്രിയന്തേ ");
INSERT INTO sanmal_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","കിന്തു യാനി സ്വയം സുദൃശ്യാനി തേഷാം ശോഭനമ് നിഷ്പ്രയോജനം| ");
INSERT INTO sanmal_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","ശരീരമധ്യേ യദ് ഭേദോ ന ഭവേത് കിന്തു സർവ്വാണ്യങ്ഗാനി യദ് ഐക്യഭാവേന സർവ്വേഷാം ഹിതം ചിന്തയന്തി തദർഥമ് ഈശ്വരേണാപ്രധാനമ് ആദരണീയം കൃത്വാ ശരീരം വിരചിതം| ");
INSERT INTO sanmal_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","തസ്മാദ് ഏകസ്യാങ്ഗസ്യ പീഡായാം ജാതായാം സർവ്വാണ്യങ്ഗാനി തേന സഹ പീഡ്യന്തേ, ഏകസ്യ സമാദരേ ജാതേ ച സർവ്വാണി തേന സഹ സംഹൃഷ്യന്തി| ");
INSERT INTO sanmal_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","യൂയഞ്ച ഖ്രീഷ്ടസ്യ ശരീരം, യുഷ്മാകമ് ഏകൈകശ്ച തസ്യൈകൈകമ് അങ്ഗം| ");
INSERT INTO sanmal_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","കേചിത് കേചിത് സമിതാവീശ്വരേണ പ്രഥമതഃ പ്രേരിതാ ദ്വിതീയത ഈശ്വരീയാദേശവക്താരസ്തൃതീയത ഉപദേഷ്ടാരോ നിയുക്താഃ, തതഃ പരം കേഭ്യോഽപി ചിത്രകാര്യ്യസാധനസാമർഥ്യമ് അനാമയകരണശക്തിരുപകൃതൗ ലോകശാസനേ വാ നൈപുണ്യം നാനാഭാഷാഭാഷണസാമർഥ്യം വാ തേന വ്യതാരി| ");
INSERT INTO sanmal_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","സർവ്വേ കിം പ്രേരിതാഃ? സർവ്വേ കിമ് ഈശ്വരീയാദേശവക്താരഃ? സർവ്വേ കിമ് ഉപദേഷ്ടാരഃ? സർവ്വേ കിം ചിത്രകാര്യ്യസാധകാഃ? ");
INSERT INTO sanmal_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","സർവ്വേ കിമ് അനാമയകരണശക്തിയുക്താഃ? സർവ്വേ കിം പരഭാഷാവാദിനഃ? സർവ്വേ വാ കിം പരഭാഷാർഥപ്രകാശകാഃ? ");
INSERT INTO sanmal_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","യൂയം ശ്രേഷ്ഠദായാൻ ലബ്ധും യതധ്വം| അനേന യൂയം മയാ സർവ്വോത്തമമാർഗം ദർശയിതവ്യാഃ| ");
INSERT INTO sanmal_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","മർത്യസ്വർഗീയാണാം ഭാഷാ ഭാഷമാണോഽഹം യദി പ്രേമഹീനോ ഭവേയം തർഹി വാദകതാലസ്വരൂപോ നിനാദകാരിഭേരീസ്വരൂപശ്ച ഭവാമി| ");
INSERT INTO sanmal_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","അപരഞ്ച യദ്യഹമ് ഈശ്വരീയാദേശാഢ്യഃ സ്യാം സർവ്വാണി ഗുപ്തവാക്യാനി സർവ്വവിദ്യാഞ്ച ജാനീയാം പൂർണവിശ്വാസഃ സൻ ശൈലാൻ സ്ഥാനാന്തരീകർത്തും ശക്നുയാഞ്ച കിന്തു യദി പ്രേമഹീനോ ഭവേയം തർഹ്യഗണനീയ ഏവ ഭവാമി| ");
INSERT INTO sanmal_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","അപരം യദ്യഹമ് അന്നദാനേന സർവ്വസ്വം ത്യജേയം ദാഹനായ സ്വശരീരം സമർപയേയഞ്ച കിന്തു യദി പ്രേമഹീനോ ഭവേയം തർഹി തത്സർവ്വം മദർഥം നിഷ്ഫലം ഭവതി| ");
INSERT INTO sanmal_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","പ്രേമ ചിരസഹിഷ്ണു ഹിതൈഷി ച, പ്രേമ നിർദ്വേഷമ് അശഠം നിർഗർവ്വഞ്ച| ");
INSERT INTO sanmal_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","അപരം തത് കുത്സിതം നാചരതി, ആത്മചേഷ്ടാം ന കുരുതേ സഹസാ ന ക്രുധ്യതി പരാനിഷ്ടം ന ചിന്തയതി, ");
INSERT INTO sanmal_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","അധർമ്മേ ന തുഷ്യതി സത്യ ഏവ സന്തുഷ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","തത് സർവ്വം തിതിക്ഷതേ സർവ്വത്ര വിശ്വസിതി സർവ്വത്ര ഭദ്രം പ്രതീക്ഷതേ സർവ്വം സഹതേ ച| ");
INSERT INTO sanmal_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","പ്രേമ്നോ ലോപഃ കദാപി ന ഭവിഷ്യതി, ഈശ്വരീയാദേശകഥനം ലോപ്സ്യതേ പരഭാഷാഭാഷണം നിവർത്തിഷ്യതേ ജ്ഞാനമപി ലോപം യാസ്യതി| ");
INSERT INTO sanmal_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","യതോഽസ്മാകം ജ്ഞാനം ഖണ്ഡമാത്രമ് ഈശ്വരീയാദേശകഥനമപി ഖണ്ഡമാത്രം| ");
INSERT INTO sanmal_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","കിന്ത്വസ്മാസു സിദ്ധതാം ഗതേഷു താനി ഖണ്ഡമാത്രാണി ലോപം യാസ്യന്തേ| ");
INSERT INTO sanmal_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","ബാല്യകാലേഽഹം ബാല ഇവാഭാഷേ ബാല ഇവാചിന്തയഞ്ച കിന്തു യൗവനേ ജാതേ തത്സർവ്വം ബാല്യാചരണം പരിത്യക്തവാൻ| ");
INSERT INTO sanmal_vpl VALUES ("C113_12","076_13_12","1CO","13","12","12","ഇദാനീമ് അഭ