﻿USE sofia;
DROP TABLE IF EXISTS sofia.sankhm_vpl;
CREATE TABLE sankhm_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sankhm_vpl WRITE;
INSERT INTO sankhm_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ឥព្រាហីមះ សន្តានោ ទាយូទ៑ តស្យ សន្តានោ យីឝុខ្រីឞ្ដស្តស្យ បូវ៌្វបុរុឞវំឝឝ្រេណី។ ");
INSERT INTO sankhm_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ឥព្រាហីមះ បុត្រ ឥស្ហាក៑ តស្យ បុត្រោ យាកូព៑ តស្យ បុត្រោ យិហូទាស្តស្យ ភ្រាតរឝ្ច។ ");
INSERT INTO sankhm_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","តស្មាទ៑ យិហូទាតស្តាមរោ គព៌្ហេ បេរស្សេរហៅ ជជ្ញាតេ, តស្យ បេរសះ បុត្រោ ហិឞ្រោណ៑ តស្យ បុត្រោ ៜរាម៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","តស្យ បុត្រោ ៜម្មីនាទព៑ តស្យ បុត្រោ នហឝោន៑ តស្យ បុត្រះ សល្មោន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","តស្មាទ៑ រាហពោ គព៌្ហេ ពោយម៑ ជជ្ញេ, តស្មាទ៑ រូតោ គព៌្ហេ ឱពេទ៑ ជជ្ញេ, តស្យ បុត្រោ យិឝយះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","តស្យ បុត្រោ ទាយូទ៑ រាជះ តស្មាទ៑ ម្ឫតោរិយស្យ ជាយាយាំ សុលេមាន៑ ជជ្ញេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","តស្យ បុត្រោ រិហពិយាម៑, តស្យ បុត្រោៜពិយះ, តស្យ បុត្រ អាសា:។ ");
INSERT INTO sankhm_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","តស្យ សុតោ យិហោឝាផដ៑ តស្យ សុតោ យិហោរាម តស្យ សុត ឧឞិយះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","តស្យ សុតោ យោថម៑ តស្យ សុត អាហម៑ តស្យ សុតោ ហិឞ្កិយះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","តស្យ សុតោ មិនឝិះ, តស្យ សុត អាមោន៑ តស្យ សុតោ យោឝិយះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ពាពិល្នគរេ ប្រវសនាត៑ បូវ៌្វំ ស យោឝិយោ យិខនិយំ តស្យ ភ្រាត្ឫំឝ្ច ជនយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","តតោ ពាពិលិ ប្រវសនកាលេ យិខនិយះ ឝល្តីយេលំ ជនយាមាស, តស្យ សុតះ សិរុព្ពាវិល៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","តស្យ សុតោ ៜពោហុទ៑ តស្យ សុត ឥលីយាកីម៑ តស្យ សុតោៜសោរ៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","អសោរះ សុតះ សាទោក៑ តស្យ សុត អាខីម៑ តស្យ សុត ឥលីហូទ៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","តស្យ សុត ឥលិយាសរ៑ តស្យ សុតោ មត្តន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","តស្យ សុតោ យាកូព៑ តស្យ សុតោ យូឞផ៑ តស្យ ជាយា មរិយម៑; តស្យ គព៌្ហេ យីឝុរជនិ, តមេវ ខ្រីឞ្ដម៑ (អត៌្ហាទ៑ អភិឞិក្តំ) វទន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ឥត្ថម៑ ឥព្រាហីមោ ទាយូទំ យាវត៑ សាកល្យេន ចតុទ៌ឝបុរុឞាះ; អា ទាយូទះ កាលាទ៑ ពាពិលិ ប្រវសនកាលំ យាវត៑ ចតុទ៌ឝបុរុឞា ភវន្តិ។ ពាពិលិ ប្រវាសនកាលាត៑ ខ្រីឞ្ដស្យ កាលំ យាវត៑ ចតុទ៌ឝបុរុឞា ភវន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","យីឝុខ្រីឞ្ដស្យ ជន្ម កថ្ថតេ។ មរិយម៑ នាមិកា កន្យា យូឞផេ វាគ្ទត្តាសីត៑, តទា តយោះ សង្គមាត៑ ប្រាក៑ សា កន្យា  បវិត្រេណាត្មនា គព៌្ហវតី ពភូវ។ ");
INSERT INTO sankhm_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","តត្រ តស្យាះ បតិ រ្យូឞផ៑ សៅជន្យាត៑ តស្យាះ កលង្គំ ប្រកាឝយិតុម៑ អនិច្ឆន៑ គោបនេនេ តាំ បារិត្យក្តុំ មនឝ្ចក្រេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ស តថៃវ ភាវយតិ, តទានីំ បរមេឝ្វរស្យ ទូតះ ស្វប្នេ តំ ទឝ៌នំ ទត្ត្វា វ្យាជហារ, ហេ ទាយូទះ សន្តាន យូឞផ៑ ត្វំ និជាំ ជាយាំ មរិយមម៑ អាទាតុំ មា ភៃឞីះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","យតស្តស្យា គព៌្ហះ បវិត្រាទាត្មនោៜភវត៑, សា ច បុត្រំ ប្រសវិឞ្យតេ, តទា ត្វំ តស្យ នាម យីឝុម៑ (អត៌្ហាត៑ ត្រាតារំ) ករីឞ្យសេ, យស្មាត៑ ស និជមនុជាន៑ តេឞាំ កលុឞេភ្យ ឧទ្ធរិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ឥត្ថំ សតិ, បឝ្យ គព៌្ហវតី កន្យា តនយំ ប្រសវិឞ្យតេ។ ឥម្មានូយេល៑ តទីយញ្ច នាមធេយំ ភវិឞ្យតិ៕ ឥម្មានូយេល៑ អស្មាកំ សង្គីឝ្វរឥត្យត៌្ហះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","ឥតិ យទ៑ វចនំ បុវ៌្វំ ភវិឞ្យទ្វក្ត្រា ឦឝ្វរះ កថាយាមាស, តត៑ តទានីំ សិទ្ធមភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","អនន្តរំ យូឞផ៑ និទ្រាតោ ជាគរិត ឧត្ថាយ បរមេឝ្វរីយទូតស្យ និទេឝានុសារេណ និជាំ ជាយាំ ជគ្រាហ, ");
INSERT INTO sankhm_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","កិន្តុ យាវត៑ សា និជំ ប្រថមសុតំ អ សុឞុវេ, តាវត៑ តាំ នោបាគច្ឆត៑, តតះ សុតស្យ នាម យីឝុំ ចក្រេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","អនន្តរំ ហេរោទ៑ សំជ្ញកេ រាជ្ញិ រាជ្យំ ឝាសតិ យិហូទីយទេឝស្យ ពៃត្លេហមិ នគរេ យីឝៅ ជាតវតិ ច, កតិបយា ជ្យោតិវ៌្វុទះ បូវ៌្វស្យា ទិឝោ យិរូឝាលម្នគរំ សមេត្យ កថយមាសុះ, ");
INSERT INTO sankhm_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","យោ យិហូទីយានាំ រាជា ជាតវាន៑, ស កុត្រាស្តេ? វយំ បូវ៌្វស្យាំ ទិឝិ តិឞ្ឋន្តស្តទីយាំ តារកាម៑ អបឝ្យាម តស្មាត៑ តំ ប្រណន្តុម៑ អाគមាម។ ");
INSERT INTO sankhm_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","តទា ហេរោទ៑ រាជា កថាមេតាំ និឝម្យ យិរូឝាលម្នគរស្ថិតៃះ សវ៌្វមានវៃះ សាទ៌្ធម៑ ឧទ្វិជ្យ ");
INSERT INTO sankhm_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","សវ៌្វាន៑ ប្រធានយាជកាន៑ អធ្យាបកាំឝ្ច សមាហូយានីយ បប្រច្ឆ, ខ្រីឞ្ដះ កុត្រ ជនិឞ្យតេ? ");
INSERT INTO sankhm_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","តទា តេ កថយាមាសុះ, យិហូទីយទេឝស្យ ពៃត្លេហមិ នគរេ, យតោ ភវិឞ្យទ្វាទិនា ឥត្ថំ លិខិតមាស្តេ, ");
INSERT INTO sankhm_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","សវ៌្វាភ្យោ រាជធានីភ្យោ យិហូទីយស្យ នីវ្ឫតះ។ ហេ យីហូទីយទេឝស្យេ ពៃត្លេហម៑ ត្វំ ន ចាវរា។ ឥស្រាយេលីយលោកាន៑ មេ យតោ យះ បាលយិឞ្យតិ។ តាទ្ឫគេកោ មហារាជស្ត្វន្មធ្យ ឧទ្ភវិឞ្យតី៕ ");
INSERT INTO sankhm_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","តទានីំ ហេរោទ៑ រាជា តាន៑ ជ្យោតិវ៌្វិទោ គោបនម៑ អាហូយ សា តារកា កទា ទ្ឫឞ្ដាភវត៑ , តទ៑ វិនិឝ្ចយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","អបរំ តាន៑ ពៃត្លេហមំ ប្រហីត្យ គទិតវាន៑, យូយំ យាត, យត្នាត៑ តំ ឝិឝុម៑ អន្វិឞ្យ តទុទ្ទេឝេ ប្រាប្តេ មហ្យំ វាត៌្តាំ ទាស្យថ, តតោ មយាបិ គត្វា ស ប្រណំស្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","តទានីំ រាជ្ញ ឯតាទ្ឫឝីម៑ អាជ្ញាំ ប្រាប្យ តេ ប្រតស្ថិរេ, តតះ បូវ៌្វស៌្យាំ ទិឝិ ស្ថិតៃស្តៃ រ្យា តារកា ទ្ឫឞ្ដា សា តារកា តេឞាមគ្រេ គត្វា យត្រ ស្ថានេ ឝិឝូរាស្តេ, តស្យ ស្ថានស្យោបរិ ស្ថគិតា តស្យៅ។ ");
INSERT INTO sankhm_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","តទ៑ ទ្ឫឞ្ដ្វា តេ មហានន្ទិតា ពភូវុះ, ");
INSERT INTO sankhm_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","តតោ គេហមធ្យ ប្រវិឝ្យ តស្យ មាត្រា មរិយមា សាទ្ធំ តំ ឝិឝុំ និរីក្ឞយ ទណ្ឌវទ៑ ភូត្វា ប្រណេមុះ, អបរំ ស្វេឞាំ ឃនសម្បត្តិំ មោចយិត្វា សុវណ៌ំ កុន្ទុរុំ គន្ធរមញ្ច តស្មៃ ទឝ៌នីយំ ទត្តវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","បឝ្ចាទ៑ ហេរោទ៑ រាជស្យ សមីបំ បុនរបិ គន្តុំ ស្វប្ន ឦឝ្វរេណ និឞិទ្ធាះ សន្តោ ៜន្យេន បថា តេ និជទេឝំ ប្រតិ ប្រតស្ថិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","អនន្តរំ តេឞុ គតវត្មុ បរមេឝ្វរស្យ ទូតោ យូឞផេ ស្វប្នេ ទឝ៌នំ ទត្វា ជគាទ, ត្វម៑ ឧត្ថាយ ឝិឝុំ តន្មាតរញ្ច គ្ឫហីត្វា មិសទ៌េឝំ បលាយស្វ, អបរំ យាវទហំ តុភ្យំ វាត៌្តាំ ន កថយិឞ្យាមិ, តាវត៑ តត្រៃវ និវស, យតោ រាជា ហេរោទ៑ ឝិឝុំ នាឝយិតុំ ម្ឫគយិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","តទានីំ យូឞផ៑ ឧត្ថាយ រជន្យាំ ឝិឝុំ តន្មាតរញ្ច គ្ឫហីត្វា មិសទ៌េឝំ ប្រតិ ប្រតស្ថេ, ");
INSERT INTO sankhm_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","គត្វា ច ហេរោទោ ន្ឫបតេ រ្មរណបយ៌្យន្តំ តត្រ ទេឝេ ន្យុវាស, តេន មិសទ៌េឝាទហំ បុត្រំ ស្វកីយំ សមុបាហូយម៑។ យទេតទ្វចនម៑ ឦឝ្វរេណ ភវិឞ្យទ្វាទិនា កថិតំ តត៑ សផលមភូត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","អនន្តរំ ហេរោទ៑ ជ្យោតិវ៌ិទ្ភិរាត្មានំ ប្រវញ្ចិតំ វិជ្ញាយ ភ្ឫឝំ ចុកោប; អបរំ ជ្យោតិវ៌្វិទ្ភ្យស្តេន វិនិឝ្ចិតំ យទ៑ ទិនំ តទ្ទិនាទ៑ គណយិត្វា ទ្វិតីយវត្សរំ ប្រវិឞ្ដា យាវន្តោ ពាលកា អស្មិន៑ ពៃត្លេហម្នគរេ តត្សីមមធ្យេ ចាសន៑, លោកាន៑ ប្រហិត្យ តាន៑ សវ៌្វាន៑ ឃាតយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","អតះ អនេកស្យ វិលាបស្យ និនាទ: ក្រន្ទនស្យ ច។ ឝោកេន ក្ឫតឝព្ទឝ្ច រាមាយាំ សំនិឝម្យតេ។ ស្វពាលគណហេតោវ៌ៃ រាហេល៑ នារី តុ រោទិនី។ ន មន្យតេ ប្រពោធន្តុ យតស្តេ នៃវ មន្តិ ហិ៕ ");
INSERT INTO sankhm_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","យទេតទ៑ វចនំ យិរីមិយនាមកភវិឞ្យទ្វាទិនា កថិតំ តត៑ តទានីំ សផលម៑ អភូត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","តទនន្តរំ ហេរេទិ រាជនិ ម្ឫតេ បរមេឝ្វរស្យ ទូតោ មិសទ៌េឝេ ស្វប្នេ ទឝ៌នំ ទត្ត្វា យូឞផេ កថិតវាន្ ");
INSERT INTO sankhm_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ត្វម៑ ឧត្ថាយ ឝិឝុំ តន្មាតរញ្ច គ្ឫហីត្វា បុនរបីស្រាយេលោ ទេឝំ យាហី, យេ ជនាះ ឝិឝុំ នាឝយិតុម៑ អម្ឫគយន្ត, តេ ម្ឫតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","តទានីំ ស ឧត្ថាយ ឝិឝុំ តន្មាតរញ្ច គ្ឫហ្លន៑ ឥស្រាយេល្ទេឝម៑ អាជគាម។ ");
INSERT INTO sankhm_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","កិន្តុ យិហូទីយទេឝេ អក៌្ហិលាយនាម រាជកុមារោ និជបិតុ រ្ហេរោទះ បទំ ប្រាប្យ រាជត្វំ ករោតីតិ និឝម្យ តត៑ ស្ថានំ យាតុំ ឝង្កិតវាន៑, បឝ្ចាត៑ ស្វប្ន ឦឝ្វរាត៑ ប្រពោធំ ប្រាប្យ គាលីល្ទេឝស្យ ប្រទេឝៃកំ ប្រស្ថាយ នាសរន្នាម នគរំ គត្វា តត្រ ន្យុឞិតវាន៑, ");
INSERT INTO sankhm_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","តេន តំ នាសរតីយំ កថយិឞ្យន្តិ, យទេតទ្វាក្យំ ភវិឞ្យទ្វាទិភិរុក្ត្តំ តត៑ សផលមភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","តទានោំ យោហ្ន្នាមា មជ្ជយិតា យិហូទីយទេឝស្យ ប្រាន្តរម៑ ឧបស្ថាយ ប្រចារយន៑ កថយាមាស, ");
INSERT INTO sankhm_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","មនាំសិ បរាវត៌្តយត, ស្វគ៌ីយរាជត្វំ សមីបមាគតម៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","បរមេឝស្យ បន្ថានំ បរិឞ្កុរុត សវ៌្វតះ។ តស្យ រាជបថាំឝ្ចៃវ សមីកុរុត សវ៌្វថា។ ឥត្យេតត៑ ប្រាន្តរេ វាក្យំ វទតះ កស្យចិទ៑ រវះ៕ ");
INSERT INTO sankhm_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ឯតទ្វចនំ យិឝយិយភវិឞ្យទ្វាទិនា យោហនមុទ្ទិឝ្យ ភាឞិតម៑។ យោហនោ វសនំ មហាង្គរោមជំ តស្យ កដៅ ចម៌្មកដិពន្ធនំ; ស ច ឝូកកីដាន៑ មធុ ច ភុក្តវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","តទានីំ យិរូឝាលម្នគរនិវាសិនះ សវ៌្វេ យិហូទិទេឝីយា យទ៌្ទន្តដិន្យា ឧភយតដស្ថាឝ្ច មានវា ពហិរាគត្យ តស្យ សមីបេ ");
INSERT INTO sankhm_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ស្វីយំ ស្វីយំ ទុរិតម៑ អង្គីក្ឫត្យ តស្យាំ យទ៌្ទនិ តេន មជ្ជិតា ពភូវុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","អបរំ ពហូន៑ ផិរូឝិនះ សិទូកិនឝ្ច មនុជាន៑ មំក្តុំ ស្វសមីបម៑ អាគច្ឆ្តោ វិលោក្យ ស តាន៑ អភិទធៅ, រេ រេ ភុជគវំឝា អាគាមីនះ កោបាត៑ បលាយិតុំ យុឞ្មាន៑ កឝ្ចេតិតវាន៑? ");
INSERT INTO sankhm_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","មនះបរាវត៌្តនស្យ សមុចិតំ ផលំ ផលត។ ");
INSERT INTO sankhm_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","កិន្ត្វស្មាកំ តាត ឥព្រាហីម៑ អស្តីតិ ស្វេឞុ មនះសុ ចីន្តយន្តោ មា វ្យាហរត។ យតោ យុឞ្មាន៑ អហំ វទាមិ, ឦឝ្វរ ឯតេភ្យះ បាឞាណេភ្យ ឥព្រាហីមះ សន្តានាន៑ ឧត្បាទយិតុំ ឝក្នោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","អបរំ បាទបានាំ មូលេ កុឋារ ឥទានីមបិ លគន៑ អាស្តេ, តស្មាទ៑ យស្មិន៑ បាទបេ ឧត្តមំ ផលំ ន ភវតិ, ស ក្ឫត្តោ មធ្យេៜគ្និំ និក្ឞេប្ស្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","អបរម៑ អហំ មនះបរាវត៌្តនសូចកេន មជ្ជនេន យុឞ្មាន៑ មជ្ជយាមីតិ សត្យំ, កិន្តុ មម បឝ្ចាទ៑ យ អាគច្ឆតិ, ស មត្តោបិ មហាន៑, អហំ តទីយោបានហៅ វោឍុមបិ នហិ យោគ្យោស្មិ, ស យុឞ្មាន៑ វហ្និរូបេ បវិត្រ អាត្មនិ សំមជ្ជយិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","តស្យ ការេ សូប៌ អាស្តេ, ស ស្វីយឝស្យានិ សម្យក៑ ប្រស្ផោដ្យ និជាន៑ សកលគោធូមាន៑ សំគ្ឫហ្យ ភាណ្ឌាគារេ ស្ថាបយិឞ្យតិ, កិំន្តុ សវ៌្វាណិ វុឞាណ្យនិវ៌្វាណវហ្និនា ទាហយិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","អនន្តរំ យីឝុ រ្យោហនា មជ្ជិតោ ភវិតុំ គាលីល្ប្រទេឝាទ៑ យទ៌្ទនិ តស្យ សមីបម៑ អាជគាម។ ");
INSERT INTO sankhm_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","កិន្តុ យោហន៑ តំ និឞិធ្យ ពភាឞេ, ត្វំ កិំ មម សមីបម៑ អាគច្ឆសិ? វរំ ត្វយា មជ្ជនំ មម ប្រយោជនម៑ អាស្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","តទានីំ យីឝុះ ប្រត្យវោចត៑; ឦទានីម៑ អនុមន្យស្វ, យត ឥត្ថំ សវ៌្វធម៌្មសាធនម៑ អស្មាកំ កត៌្តវ្យំ, តតះ សោៜន្វមន្យត។ ");
INSERT INTO sankhm_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","អនន្តរំ យីឝុរម្មសិ មជ្ជិតុះ សន៑ តត្ក្ឞណាត៑ តោយមធ្យាទ៑ ឧត្ថាយ ជគាម, តទា ជីមូតទ្វារេ មុក្តេ ជាតេ, ស ឦឝ្វរស្យាត្មានំ កបោតវទ៑ អវរុហ្យ ស្វោបយ៌្យាគច្ឆន្តំ វីក្ឞាញ្ចក្រេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","អបរម៑ ឯឞ មម ប្រិយះ បុត្រ ឯតស្មិន្នេវ មម មហាសន្តោឞ ឯតាទ្ឫឝី វ្យោមជា វាគ៑ ពភូវ។ ");
INSERT INTO sankhm_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","តតះ បរំ យីឝុះ ប្រតារកេណ បរីក្ឞិតោ ភវិតុម៑ អាត្មនា ប្រាន្តរម៑ អាក្ឫឞ្ដះ ");
INSERT INTO sankhm_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","សន៑ ចត្វារិំឝទហោរាត្រាន៑ អនាហារស្តិឞ្ឋន៑ ក្ឞុធិតោ ពភូវ។ ");
INSERT INTO sankhm_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","តទានីំ បរីក្ឞិតា តត្សមីបម៑ អាគត្យ វ្យាហ្ឫតវាន៑, យទិ ត្វមីឝ្វរាត្មជោ ភវេស្តហ៌្យាជ្ញយា បាឞាណានេតាន៑ បូបាន៑ វិធេហិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","តតះ ស ប្រត្យព្រវីត៑, ឥត្ថំ លិខិតមាស្តេ, \"មនុជះ កេវលបូបេន ន ជីវិឞ្យតិ, កិន្ត្វីឝ្វរស្យ វទនាទ៑ យានិ យានិ វចាំសិ និះសរន្តិ តៃរេវ ជីវិឞ្យតិ។ \" ");
INSERT INTO sankhm_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","តទា ប្រតារកស្តំ បុណ្យនគរំ នីត្វា មន្ទិរស្យ ចូឌោបរិ និធាយ គទិតវាន៑, ");
INSERT INTO sankhm_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ត្វំ យទិឝ្វរស្យ តនយោ ភវេស្តហ៌ីតោៜធះ បត, យត ឥត្ថំ លិខិតមាស្តេ, អាទេក្ឞ្យតិ និជាន៑ ទូតាន៑ រក្ឞិតុំ ត្វាំ បរមេឝ្វរះ។ យថា សវ៌្វេឞុ មាគ៌េឞុ ត្វទីយចរណទ្វយេ។ ន លគេត៑ ប្រស្តរាឃាតស្ត្វាំ ឃរិឞ្យន្តិ តេ ករៃះ៕ ");
INSERT INTO sankhm_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","តទានីំ យីឝុស្តស្មៃ កថិតវាន៑ ឯតទបិ លិខិតមាស្តេ, \"ត្វំ និជប្រភុំ បរមេឝ្វរំ មា បរីក្ឞស្វ។ \" ");
INSERT INTO sankhm_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","អនន្តរំ ប្រតារកះ បុនរបិ តម៑ អត្យុញ្ចធរាធរោបរិ នីត្វា ជគតះ សកលរាជ្យានិ តទៃឝ្វយ៌្យាណិ ច ទឝ៌យាឝ្ចការ កថយាញ្ចការ ច, ");
INSERT INTO sankhm_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","យទិ ត្វំ ទណ្ឌវទ៑ ភវន៑ មាំ ប្រណមេស្តហ៌្យហម៑ ឯតានិ តុភ្យំ ប្រទាស្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","តទានីំ យីឝុស្តមវោចត៑, ទូរីភវ ប្រតារក, លិខិតមិទម៑ អាស្តេ, \"ត្វយា និជះ ប្រភុះ បរមេឝ្វរះ ប្រណម្យះ កេវលះ ស សេវ្យឝ្ច។ \" ");
INSERT INTO sankhm_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","តតះ ប្រតារកេណ ស បយ៌្យត្យាជិ, តទា ស្វគ៌ីយទូតៃរាគត្យ ស សិឞេវេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","តទនន្តរំ យោហន៑ ការាយាំ ពពន្ធេ, តទ្វាត៌្តាំ និឝម្យ យីឝុនា គាលីល៑ ប្រាស្ថីយត។ ");
INSERT INTO sankhm_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","តតះ បរំ ស នាសរន្នគរំ វិហាយ ជលឃេស្តដេ សិពូលូន្នប្តាលី ឯតយោរុវភយោះ ប្រទេឝយោះ សីម្នោម៌ធ្យវត៌្តី យ: កផន៌ាហូម៑ តន្នគរម៑ ឥត្វា ន្យវសត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","តស្មាត៑, អន្យាទេឝីយគាលីលិ យទ៌្ទន្បារេៜព្ធិរោធសិ។ នប្តាលិសិពូលូន្ទេឝៅ យត្រ ស្ថានេ ស្ថិតៅ បុរា។ ");
INSERT INTO sankhm_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","តត្រត្យា មនុជា យេ យេ បយ៌្យភ្រាម្យន៑ តមិស្រកេ។ តៃជ៌នៃព៌្ឫហទាលោកះ បរិទឝ៌ិឞ្យតេ តទា។ អវសន៑ យេ ជនា ទេឝេ ម្ឫត្យុច្ឆាយាស្វរូបកេ។ តេឞាមុបរិ លោកានាមាលោកះ សំប្រកាឝិតះ៕ ");
INSERT INTO sankhm_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","យទេតទ្វចនំ យិឝយិយភវិឞ្យទ្វាទិនា ប្រោក្តំ, តត៑ តទា សផលម៑ អភូត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","អនន្តរំ យីឝុះ សុសំវាទំ ប្រចារយន៑ ឯតាំ កថាំ កថយិតុម៑ អារេភេ, មនាំសិ បរាវត៌្តយត, ស្វគ៌ីយរាជត្វំ សវិធមភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","តតះ បរំ យីឝុ រ្គាលីលោ ជលធេស្តដេន គច្ឆន៑ គច្ឆន៑ អាន្ទ្រិយស្តស្យ ភ្រាតា ឝិមោន៑ អត៌្ហតោ យំ បិតរំ វទន្តិ ឯតាវុភៅ ជលឃៅ ជាលំ ក្ឞិបន្តៅ ទទឝ៌, យតស្តៅ មីនធារិណាវាស្តាម៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","តទា ស តាវាហូយ វ្យាជហារ, យុវាំ មម បឝ្ចាទ៑ អាគច្ឆតំ, យុវាមហំ មនុជធារិណៅ ករិឞ្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","តេនៃវ តៅ ជាលំ វិហាយ តស្យ បឝ្ចាត៑ អាគច្ឆតាម៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","អនន្តរំ តស្មាត៑ ស្ថានាត៑ វ្រជន៑ វ្រជន៑ សិវទិយស្យ សុតៅ យាកូព៑ យោហន្នាមានៅ ទ្វៅ សហជៅ តាតេន សាទ៌្ធំ នៅកោបរិ ជាលស្យ ជីណ៌ោទ្ធារំ កុវ៌្វន្តៅ វីក្ឞ្យ តាវាហូតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","តត្ក្ឞណាត៑ តៅ នាវំ ស្វតាតញ្ច វិហាយ តស្យ បឝ្ចាទ្គាមិនៅ ពភូវតុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","អនន្តរំ ភជនភវនេ សមុបទិឝន៑ រាជ្យស្យ សុសំវាទំ ប្រចារយន៑ មនុជានាំ សវ៌្វប្រការាន៑ រោគាន៑ សវ៌្វប្រការបីឌាឝ្ច ឝមយន៑ យីឝុះ ក្ឫត្ស្នំ គាលីល្ទេឝំ ភ្រមិតុម៑ អារភត។ ");
INSERT INTO sankhm_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","តេន ក្ឫត្ស្នសុរិយាទេឝស្យ មធ្យំ តស្យ យឝោ វ្យាប្នោត៑, អបរំ ភូតគ្រស្តា អបស្មារគ៌ីណះ បក្ឞាធាតិប្រភ្ឫតយឝ្ច យាវន្តោ មនុជា នានាវិធវ្យាធិភិះ ក្លិឞ្ដា អាសន៑, តេឞុ សវ៌្វេឞុ តស្យ សមីបម៑ អានីតេឞុ ស តាន៑ ស្វស្ថាន៑ ចការ។ ");
INSERT INTO sankhm_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ឯតេន គាលីល៑-ទិកាបនិ-យិរូឝាលម៑-យិហូទីយទេឝេភ្យោ យទ៌្ទនះ បារាញ្ច ពហវោ មនុជាស្តស្យ បឝ្ចាទ៑ អាគច្ឆន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","អនន្តរំ ស ជននិវហំ និរីក្ឞ្យ ភូធរោបរិ វ្រជិត្វា សមុបវិវេឝ។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","តទានីំ ឝិឞ្យេឞុ តស្យ សមីបមាគតេឞុ តេន តេភ្យ ឯឞា កថា កថ្យាញ្ចក្រេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","អភិមានហីនា ជនា ធន្យាះ, យតស្តេ ស្វគ៌ីយរាជ្យម៑ អធិករិឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ខិទ្យមានា មនុជា ធន្យាះ, យស្មាត៑ តេ សាន្ត្វនាំ ប្រាប្សន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","នម្រា មានវាឝ្ច ធន្យាះ, យស្មាត៑ តេ មេទិនីម៑ អធិករិឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ធម៌្មាយ ពុភុក្ឞិតាះ ត្ឫឞាត៌្តាឝ្ច មនុជា ធន្យាះ, យស្មាត៑ តេ បរិតប៌្ស្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","ក្ឫបាលវោ មានវា ធន្យាះ, យស្មាត៑ តេ ក្ឫបាំ ប្រាប្ស្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","និម៌្មលហ្ឫទយា មនុជាឝ្ច ធន្យាះ, យស្មាត៑ ត ឦឝ្ចរំ ទ្រក្ឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","មេលយិតារោ មានវា ធន្យាះ, យស្មាត៑ ត ឦឝ្ចរស្យ សន្តានត្វេន វិខ្យាស្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ធម៌្មការណាត៑ តាឌិតា មនុជា ធន្យា, យស្មាត៑ ស្វគ៌ីយរាជ្យេ តេឞាមធិករោ វិទ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","យទា មនុជា មម នាមក្ឫតេ យុឞ្មាន៑ និន្ទន្តិ តាឌយន្តិ ម្ឫឞា នានាទុវ៌្វាក្យានិ វទន្តិ ច, តទា យុយំ ធន្យាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","តទា អានន្ទត, តថា ភ្ឫឝំ ហ្លាទធ្វញ្ច, យតះ ស្វគ៌េ ភូយាំសិ ផលានិ លប្ស្យធ្វេ; តេ យុឞ្មាកំ បុរាតនាន៑ ភវិឞ្យទ្វាទិនោៜបិ តាទ្ឫគ៑ អតាឌយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","យុយំ មេទិន្យាំ លវណរូបាះ, កិន្តុ យទិ លវណស្យ លវណត្វម៑ អបយាតិ, តហ៌ិ តត៑ កេន ប្រការេណ ស្វាទុយុក្តំ ភវិឞ្យតិ? តត៑ កស្យាបិ កាយ៌្យស្យាយោគ្យត្វាត៑ កេវលំ ពហិះ ប្រក្ឞេប្តុំ នរាណាំ បទតលេន ទលយិតុញ្ច យោគ្យំ ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","យូយំ ជគតិ ទីប្តិរូបាះ, ភូធរោបរិ ស្ថិតំ នគរំ គុប្តំ ភវិតុំ នហិ ឝក្ឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","អបរំ មនុជាះ ប្រទីបាន៑ ប្រជ្វាល្យ ទ្រោណាធោ ន ស្ថាបយន្តិ, កិន្តុ ទីបាធារោបយ៌្យេវ ស្ថាបយន្តិ, តេន តេ ទីបា គេហស្ថិតាន៑ សកលាន៑ ប្រកាឝយន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","យេន មានវា យុឞ្មាកំ សត្កម៌្មាណិ វិលោក្យ យុឞ្មាកំ ស្វគ៌ស្ថំ បិតរំ ធន្យំ វទន្តិ, តេឞាំ សមក្ឞំ យុឞ្មាកំ ទីប្តិស្តាទ្ឫក៑ ប្រកាឝតាម៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","អហំ វ្យវស្ថាំ ភវិឞ្យទ្វាក្យញ្ច លោប្តុម៑ អាគតវាន៑, ឥត្ថំ មានុភវត, តេ ទ្វេ លោប្តុំ នាគតវាន៑, កិន្តុ សផលេ កត៌្តុម៑ អាគតោស្មិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","អបរំ យុឞ្មាន៑ អហំ តថ្យំ វទាមិ យាវត៑ វ្យោមមេទិន្យោ រ្ធ្វំសោ ន ភវិឞ្យតិ, តាវត៑ សវ៌្វស្មិន៑ សផលេ ន ជាតេ វ្យវស្ថាយា ឯកា មាត្រា ពិន្ទុរេកោបិ វា ន លោប្ស្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","តស្មាត៑ យោ ជន ឯតាសាម៑ អាជ្ញានាម៑ អតិក្ឞុទ្រាម៑ ឯកាជ្ញាមបី លំឃតេ មនុជាំញ្ច តថៃវ ឝិក្ឞយតិ, ស ស្វគ៌ីយរាជ្យេ សវ៌្វេភ្យះ ក្ឞុទ្រត្វេន វិខ្យាស្យតេ, កិន្តុ យោ ជនស្តាំ បាលយតិ, តថៃវ ឝិក្ឞយតិ ច, ស ស្វគ៌ីយរាជ្យេ ប្រធានត្វេន វិខ្យាស្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","អបរំ យុឞ្មាន៑ អហំ វទាមិ, អធ្យាបកផិរូឝិមានវានាំ ធម៌្មានុឞ្ឋានាត៑ យុឞ្មាកំ ធម៌្មានុឞ្ឋានេ នោត្តមេ ជាតេ យូយម៑ ឦឝ្វរីយរាជ្យំ ប្រវេឞ្ដុំ ន ឝក្ឞ្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","អបរញ្ច ត្វំ នរំ មា វធីះ, យស្មាត៑ យោ នរំ ហន្តិ, ស វិចារសភាយាំ ទណ្ឌាហ៌ោ ភវិឞ្យតិ, បូវ៌្វកាលីនជនេភ្យ ឥតិ កថិតមាសីត៑, យុឞ្មាភិរឝ្រាវិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","កិន្ត្វហំ យុឞ្មាន៑ វទាមិ, យះ កឝ្ចិត៑ ការណំ វិនា និជភ្រាត្រេ កុប្យតិ, ស វិចារសភាយាំ ទណ្ឌាហ៌ោ ភវិឞ្យតិ; យះ កឝ្ចិច្ច ស្វីយសហជំ និព៌្ពោធំ វទតិ, ស មហាសភាយាំ ទណ្ឌាហ៌ោ ភវិឞ្យតិ; បុនឝ្ច ត្វំ មូឍ ឥតិ វាក្យំ យទិ កឝ្ចិត៑ ស្វីយភ្រាតរំ វក្តិ, តហ៌ិ នរកាគ្នៅ ស ទណ្ឌាហ៌ោ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","អតោ វេទ្យាះ សមីបំ និជនៃវេទ្យេ សមានីតេៜបិ និជភ្រាតរំ ប្រតិ កស្មាច្ចិត៑ ការណាត៑ ត្វំ យទិ ទោឞី វិទ្យសេ, តទានីំ តវ តស្យ ស្ម្ឫតិ រ្ជាយតេ ច, ");
INSERT INTO sankhm_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","តហ៌ិ តស្យា វេទ្យាះ សមីបេ និជនៃវៃទ្យំ និធាយ តទៃវ គត្វា បូវ៌្វំ តេន សាទ៌្ធំ មិល, បឝ្ចាត៑ អាគត្យ និជនៃវេទ្យំ និវេទយ។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","អន្យញ្ច យាវត៑ វិវាទិនា សាទ៌្ធំ វត៌្មនិ តិឞ្ឋសិ, តាវត៑ តេន សាទ៌្ធំ មេលនំ កុរុ; នោ ចេត៑ វិវាទី វិចារយិតុះ សមីបេ ត្វាំ សមប៌យតិ វិចារយិតា ច រក្ឞិណះ សន្និធៅ សមប៌យតិ តទា ត្វំ ការាយាំ ពធ្យេថាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","តហ៌ិ ត្វាមហំ តថ្ថំ ព្រវីមិ, ឝេឞកបទ៌កេៜបិ ន បរិឝោធិតេ តស្មាត៑ ស្ថានាត៑ កទាបិ ពហិរាគន្តុំ ន ឝក្ឞ្យសិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","អបរំ ត្វំ មា វ្យភិចរ, យទេតទ៑ វចនំ បូវ៌្វកាលីនលោកេភ្យះ កថិតមាសីត៑, តទ៑ យូយំ ឝ្រុតវន្តះ; ");
INSERT INTO sankhm_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","កិន្ត្វហំ យុឞ្មាន៑ វទាមិ, យទិ កឝ្ចិត៑ កាមតះ កាញ្ចន យោឞិតំ បឝ្យតិ, តហ៌ិ ស មនសា តទៃវ វ្យភិចរិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","តស្មាត៑ តវ ទក្ឞិណំ នេត្រំ យទិ ត្វាំ ពាធតេ, តហ៌ិ តន្នេត្រម៑ ឧត្បាដ្យ ទូរេ និក្ឞិប, យស្មាត៑ តវ សវ៌្វវបុឞោ នរកេ និក្ឞេបាត៑ តវៃកាង្គស្យ នាឝោ វរំ។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","យទ្វា តវ ទក្ឞិណះ ករោ យទិ ត្វាំ ពាធតេ, តហ៌ិ តំ ករំ ឆិត្ត្វា ទូរេ និក្ឞិប, យតះ សវ៌្វវបុឞោ នរកេ និក្ឞេបាត៑ ឯកាង្គស្យ នាឝោ វរំ។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","ឧក្តមាស្តេ, យទិ កឝ្ចិន៑ និជជាយាំ បរិត្យក្ត្តុម៑ ឥច្ឆតិ, តហ៌ិ ស តស្យៃ ត្យាគបត្រំ ទទាតុ។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","កិន្ត្វហំ យុឞ្មាន៑ វ្យាហរាមិ, វ្យភិចារទោឞេ ន ជាតេ យទិ កឝ្ចិន៑ និជជាយាំ បរិត្យជតិ, តហ៌ិ ស តាំ វ្យភិចារយតិ; យឝ្ច តាំ ត្យក្តាំ ស្ត្រិយំ វិវហតិ, សោបិ វ្យភិចរតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","បុនឝ្ច ត្វំ ម្ឫឞា ឝបថម៑ ន កុវ៌្វន៑ ឦឝ្ចរាយ និជឝបថំ បាលយ, បូវ៌្វកាលីនលោកេភ្យោ យៃឞា កថា កថិតា, តាមបិ យូយំ ឝ្រុតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","កិន្ត្វហំ យុឞ្មាន៑ វទាមិ, កមបិ ឝបថំ មា កាឞ៌្ដ, អត៌្ហតះ ស្វគ៌នាម្នា ន, យតះ ស ឦឝ្វរស្យ សិំហាសនំ; ");
INSERT INTO sankhm_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ប្ឫថិវ្យា នាម្នាបិ ន, យតះ សា តស្យ បាទបីឋំ; យិរូឝាលមោ នាម្នាបិ ន, យតះ សា មហារាជស្យ បុរី; ");
INSERT INTO sankhm_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","និជឝិរោនាម្នាបិ ន, យស្មាត៑ តស្យៃកំ កចមបិ សិតម៑ អសិតំ វា កត៌្តុំ ត្វយា ន ឝក្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","អបរំ យូយំ សំលាបសមយេ កេវលំ ភវតីតិ ន ភវតីតិ ច វទត យត ឥតោៜធិកំ យត៑ តត៑ បាបាត្មនោ ជាយតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","អបរំ លោចនស្យ វិនិមយេន លោចនំ ទន្តស្យ វិនិមយេន ទន្តះ បូវ៌្វក្តមិទំ វចនញ្ច យុឞ្មាភិរឝ្រូយត។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","កិន្ត្វហំ យុឞ្មាន៑ វទាមិ យូយំ ហិំសកំ នរំ មា វ្យាឃាតយត។ កិន្តុ កេនចិត៑ តវ ទក្ឞិណកបោលេ ចបេដាឃាតេ ក្ឫតេ តំ ប្រតិ វាមំ កបោលញ្ច វ្យាឃោដយ។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","អបរំ កេនចិត៑ ត្វយា សាទ៌្ហ្ទំ វិវាទំ ក្ឫត្វា តវ បរិធេយវសនេ ជិឃ្ឫតិតេ តស្មាយុត្តរីយវសនមបិ ទេហិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","យទិ កឝ្ចិត៑ ត្វាំ ក្រោឝមេកំ នយនាត៌្ហំ អន្យាយតោ ធរតិ, តទា តេន សាទ៌្ហ្ទំ ក្រោឝទ្វយំ យាហិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","យឝ្ច មានវស្ត្វាំ យាចតេ, តស្មៃ ទេហិ, យទិ កឝ្ចិត៑ តុភ្យំ ធារយិតុម៑ ឥច្ឆតិ, តហ៌ិ តំ ប្រតិ បរាំមុខោ មា ភូះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","និជសមីបវសិនិ ប្រេម កុរុ, កិន្តុ ឝត្រុំ ប្រតិ ទ្វេឞំ កុរុ, យទេតត៑ បុរោក្តំ វចនំ ឯតទបិ យូយំ ឝ្រុតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","កិន្ត្វហំ យុឞ្មាន៑ វទាមិ, យូយំ រិបុវ្វបិ ប្រេម កុរុត, យេ ច យុឞ្មាន៑ ឝបន្តេ, តាន, អាឝិឞំ វទត, យេ ច យុឞ្មាន៑ ឫृតីយន្តេ, តេឞាំ មង្គលំ កុរុត, យេ ច យុឞ្មាន៑ និន្ទន្តិ, តាឌយន្តិ ច, តេឞាំ ក្ឫតេ ប្រាត៌្ហយធ្វំ។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","តត្រ យះ សតាមសតាញ្ចោបរិ ប្រភាករម៑ ឧទាយយតិ, តថា ធាម៌្មិកានាមធាម៌្មិកានាញ្ចោបរិ នីរំ វឞ៌យតិ តាទ្ឫឝោ យោ យុឞ្មាកំ ស្វគ៌ស្ថះ បិតា, យូយំ តស្យៃវ សន្តានា ភវិឞ្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","យេ យុឞ្មាសុ ប្រេម កុវ៌្វន្តិ, យូយំ យទិ កេវលំ តេវ្វេវ ប្រេម កុរុថ, តហ៌ិ យុឞ្មាកំ កិំ ផលំ ភវិឞ្យតិ? ចណ្ឌាលា អបិ តាទ្ឫឝំ កិំ ន កុវ៌្វន្តិ? ");
INSERT INTO sankhm_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","អបរំ យូយំ យទិ កេវលំ ស្វីយភ្រាត្ឫត្វេន នមត, តហ៌ិ កិំ មហត៑ កម៌្ម កុរុថ? ចណ្ឌាលា អបិ តាទ្ឫឝំ កិំ ន កុវ៌្វន្តិ? ");
INSERT INTO sankhm_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","តស្មាត៑ យុឞ្មាកំ ស្វគ៌ស្ថះ បិតា យថា បូណ៌ោ ភវតិ, យូយមបិ តាទ្ឫឝា ភវត។ ");
INSERT INTO sankhm_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","សាវធានា ភវត, មនុជាន៑ ទឝ៌យិតុំ តេឞាំ គោចរេ ធម៌្មកម៌្ម មា កុរុត, តថា ក្ឫតេ យុឞ្មាកំ ស្វគ៌ស្ថបិតុះ សកាឝាត៑ កិញ្ចន ផលំ ន ប្រាប្ស្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","ត្វំ យទា ទទាសិ តទា កបដិនោ ជនា យថា មនុជេភ្យះ ប្រឝំសាំ ប្រាប្តុំ ភជនភវនេ រាជមាគ៌េ ច តូរីំ វាទយន្តិ, តថា មា កុរិु, អហំ តុភ្យំ យថាត៌្ហំ កថយាមិ, តេ ស្វកាយំ ផលម៑ អលភន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","កិន្តុ ត្វំ យទា ទទាសិ, តទា និជទក្ឞិណករោ យត៑ ករោតិ, តទ៑ វាមករំ មា ជ្ញាបយ។ ");
INSERT INTO sankhm_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","តេន តវ ទានំ គុប្តំ ភវិឞ្យតិ យស្តុ តវ បិតា គុប្តទឝ៌ី, ស ប្រកាឝ្យ តុភ្យំ ផលំ ទាស្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","អបរំ យទា ប្រាត៌្ហយសេ, តទា កបដិនឥវ មា កុរុ, យស្មាត៑ តេ ភជនភវនេ រាជមាគ៌ស្យ កោណេ តិឞ្ឋន្តោ លោកាន៑ ទឝ៌យន្តះ ប្រាត៌្ហយិតុំ ប្រីយន្តេ; អហំ យុឞ្មាន៑ តថ្យំ វទាមិ, តេ ស្វកីយផលំ ប្រាប្នុវន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","តស្មាត៑ ប្រាត៌្ហនាកាលេ អន្តរាគារំ ប្រវិឝ្យ ទ្វារំ រុទ្វ្វា គុប្តំ បឝ្យតស្តវ បិតុះ សមីបេ ប្រាត៌្ហយស្វ; តេន តវ យះ បិតា គុប្តទឝ៌ី, ស ប្រកាឝ្យ តុភ្យំ ផលំ ទាស្យតិl ");
INSERT INTO sankhm_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","អបរំ ប្រាត៌្ហនាកាលេ ទេវបូជកាឥវ មុធា បុនរុក្តិំ មា កុរុ, យស្មាត៑ តេ ពោធន្តេ, ពហុវារំ កថាយាំ កថិតាយាំ តេឞាំ ប្រាត៌្ហនា គ្រាហិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","យូយំ តេឞាមិវ មា កុរុត, យស្មាត៑ យុឞ្មាកំ យទ៑ យត៑ ប្រយោជនំ យាចនាតះ ប្រាគេវ យុឞ្មាកំ បិតា តត៑ ជានាតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","អតឯវ យូយម ឦទ្ឫក៑ ប្រាត៌្ហយធ្វំ, ហេ អស្មាកំ ស្វគ៌ស្ថបិតះ, តវ នាម បូជ្យំ ភវតុ។ ");
INSERT INTO sankhm_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","តវ រាជត្វំ ភវតុ; តវេច្ឆា ស្វគ៌េ យថា តថៃវ មេទិន្យាមបិ សផលា ភវតុ។ ");
INSERT INTO sankhm_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","អស្មាកំ ប្រយោជនីយម៑ អាហារម៑ អទ្យ ទេហិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","វយំ យថា និជាបរាធិនះ ក្ឞមាមហេ, តថៃវាស្មាកម៑ អបរាធាន៑ ក្ឞមស្វ។ ");
INSERT INTO sankhm_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","អស្មាន៑ បរីក្ឞាំ មានយ, កិន្តុ បាបាត្មនោ រក្ឞ; រាជត្វំ គៅរវំ បរាក្រមះ ឯតេ សវ៌្វេ សវ៌្វទា តវ; តថាស្តុ។ ");
INSERT INTO sankhm_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","យទិ យូយម៑ អន្យេឞាម៑ អបរាធាន៑ ក្ឞមធ្វេ តហ៌ិ យុឞ្មាកំ ស្វគ៌ស្ថបិតាបិ យុឞ្មាន៑ ក្ឞមិឞ្យតេ; ");
INSERT INTO sankhm_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","កិន្តុ យទិ យូយម៑ អន្យេឞាម៑ អបរាធាន៑ ន ក្ឞមធ្វេ, តហ៌ិ យុឞ្មាកំ ជនកោបិ យុឞ្មាកម៑ អបរាធាន៑ ន ក្ឞមិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","អបរម៑ ឧបវាសកាលេ កបដិនោ ជនា មានុឞាន៑ ឧបវាសំ ជ្ញាបយិតុំ ស្វេឞាំ វទនានិ ម្លានានិ កុវ៌្វន្តិ, យូយំ តឥវ វិឞណវទនា មា ភវត; អហំ យុឞ្មាន៑ តថ្យំ វទាមិ តេ ស្វកីយផលម៑ អលភន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","យទា ត្វម៑ ឧបវសសិ, តទា យថា លោកៃស្ត្វំ ឧបវាសីវ ន ទ្ឫឝ្យសេ, កិន្តុ តវ យោៜគោចរះ បិតា តេនៃវ ទ្ឫឝ្យសេ, តត្ក្ឫតេ និជឝិរសិ តៃលំ មទ៌្ទយ វទនញ្ច ប្រក្ឞាលយ; ");
INSERT INTO sankhm_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","តេន តវ យះ បិតា គុប្តទឝ៌ី ស ប្រកាឝ្យ តុភ្យំ ផលំ ទាស្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","អបរំ យត្រ ស្ថានេ កីដាះ កលង្កាឝ្ច ក្ឞយំ នយន្តិ, ចៅរាឝ្ច សន្ធិំ កត៌្តយិត្វា ចោរយិតុំ ឝក្នុវន្តិ, តាទ្ឫឝ្យាំ មេទិន្យាំ ស្វាត៌្ហំ ធនំ មា សំចិនុត។ ");
INSERT INTO sankhm_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","កិន្តុ យត្រ ស្ថានេ កីដាះ កលង្កាឝ្ច ក្ឞយំ ន នយន្តិ, ចៅរាឝ្ច សន្ធិំ កត៌្តយិត្វា ចោរយិតុំ ន ឝក្នុវន្តិ, តាទ្ឫឝេ ស្វគ៌េ ធនំ សញ្ចិនុត។ ");
INSERT INTO sankhm_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","យស្មាត៑ យត្រ ស្ថានេ យុឞ្មាំក ធនំ តត្រៃវ ខានេ យុឞ្មាកំ មនាំសិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","លោចនំ ទេហស្យ ប្រទីបកំ, តស្មាត៑ យទិ តវ លោចនំ ប្រសន្នំ ភវតិ, តហ៌ិ តវ ក្ឫត្ស្នំ វបុ រ្ទីប្តិយុក្តំ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","កិន្តុ លោចនេៜប្រសន្នេ តវ ក្ឫត្ស្នំ វបុះ តមិស្រយុក្តំ ភវិឞ្យតិ។ អតឯវ យា ទីប្តិស្ត្វយិ វិទ្យតេ, សា យទិ តមិស្រយុក្តា ភវតិ, តហ៌ិ តត៑ តមិស្រំ កិយន៑ មហត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","កោបិ មនុជោ ទ្វៅ ប្រភូ សេវិតុំ ន ឝក្នោតិ, យស្មាទ៑ ឯកំ សំមន្យ តទន្យំ ន សម្មន្យតេ, យទ្វា ឯកត្រ មនោ និធាយ តទន្យម៑ អវមន្យតេ; តថា យូយមបីឝ្វរំ លក្ឞ្មីញ្ចេត្យុភេ សេវិតុំ ន ឝក្នុថ។ ");
INSERT INTO sankhm_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","អបរម៑ អហំ យុឞ្មភ្យំ តថ្យំ កថយាមិ, កិំ ភក្ឞិឞ្យាមះ? កិំ បាស្យាមះ? ឥតិ ប្រាណធារណាយ មា ចិន្តយត; កិំ បរិធាស្យាមះ? ឥតិ កាយរក្ឞណាយ ន ចិន្តយត; ភក្ឞ្យាត៑ ប្រាណា វសនាញ្ច វបូំឞិ កិំ ឝ្រេឞ្ឋាណិ ន ហិ? ");
INSERT INTO sankhm_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","វិហាយសោ វិហង្គមាន៑ វិលោកយត; តៃ រ្នោប្យតេ ន ក្ឫត្យតេ ភាណ្ឌាគារេ ន សញ្ចីយតេៜបិ; តថាបិ យុឞ្មាកំ ស្វគ៌ស្ថះ បិតា តេភ្យ អាហារំ វិតរតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","យូយំ តេភ្យះ កិំ ឝ្រេឞ្ឋា ន ភវថ? យុឞ្មាកំ កឝ្ចិត៑ មនុជះ ចិន្តយន៑ និជាយុឞះ ក្ឞណមបិ វទ៌្ធយិតុំ ឝក្នោតិ? ");
INSERT INTO sankhm_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","អបរំ វសនាយ កុតឝ្ចិន្តយត? ក្ឞេត្រោត្បន្នានិ បុឞ្បាណិ កថំ វទ៌្ធន្តេ តទាលោចយត។ តានិ តន្តូន៑ នោត្បាទយន្តិ កិមបិ កាយ៌្យំ ន កុវ៌្វន្តិ; ");
INSERT INTO sankhm_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","តថាប្យហំ យុឞ្មាន៑ វទាមិ, សុលេមាន៑ តាទ្ឫគ៑ ឰឝ្វយ៌្យវានបិ តត្បុឞ្បមិវ វិភូឞិតោ នាសីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","តស្មាត៑ ក្ឞទ្យ វិទ្យមានំ ឝ្ចះ ចុល្ល្យាំ និក្ឞេប្ស្យតេ តាទ្ឫឝំ យត៑ ក្ឞេត្រស្ថិតំ កុសុមំ តត៑ យទីឝ្ចរ ឥត្ថំ ពិភូឞយតិ, តហ៌ិ ហេ ស្តោកប្រត្យយិនោ យុឞ្មាន៑ កិំ ន បរិធាបយិឞ្យតិ? ");
INSERT INTO sankhm_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","តស្មាត៑ អស្មាភិះ កិមត្ស្យតេ? កិញ្ច បាយិឞ្យតេ? កិំ វា បរិធាយិឞ្យតេ, ឥតិ ន ចិន្តយត។ ");
INSERT INTO sankhm_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","យស្មាត៑ ទេវាច៌្ចកា អបីតិ ចេឞ្ដន្តេ; ឯតេឞុ ទ្រវ្យេឞុ ប្រយោជនមស្តីតិ យុឞ្មាកំ ស្វគ៌ស្ថះ បិតា ជានាតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","អតឯវ ប្រថមត ឦឝ្វរីយរាជ្យំ ធម៌្មញ្ច ចេឞ្ដធ្វំ, តត ឯតានិ វស្តូនិ យុឞ្មភ្យំ ប្រទាយិឞ្យន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","ឝ្វះ ក្ឫតេ មា ចិន្តយត, ឝ្វឯវ ស្វយំ ស្វមុទ្ទិឝ្យ ចិន្តយិឞ្យតិ; អទ្យតនី យា ចិន្តា សាទ្យក្ឫតេ ប្រចុរតរា។ ");
INSERT INTO sankhm_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","យថា យូយំ ទោឞីក្ឫតា ន ភវថ, តត្ក្ឫតេៜន្យំ ទោឞិណំ មា កុរុត។ ");
INSERT INTO sankhm_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","យតោ យាទ្ឫឝេន ទោឞេណ យូយំ បរាន៑ ទោឞិណះ កុរុថ, តាទ្ឫឝេន ទោឞេណ យូយមបិ ទោឞីក្ឫតា ភវិឞ្យថ, អន្យញ្ច យេន បរិមាណេន យុឞ្មាភិះ បរិមីយតេ, តេនៃវ បរិមាណេន យុឞ្មត្ក្ឫតេ បរិមាយិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","អបរញ្ច និជនយនេ យា នាសា វិទ្យតេ, តាម៑ អនាលោច្យ តវ សហជស្យ លោចនេ យត៑ ត្ឫណម៑ អាស្តេ, តទេវ កុតោ វីក្ឞសេ? ");
INSERT INTO sankhm_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","តវ និជលោចនេ នាសាយាំ វិទ្យមានាយាំ, ហេ ភ្រាតះ, តវ នយនាត៑ ត្ឫណំ ពហិឞ្យត៌ុំ អនុជានីហិ, កថាមេតាំ និជសហជាយ កថំ កថយិតុំ ឝក្នោឞិ? ");
INSERT INTO sankhm_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ហេ កបដិន៑, អាទៅ និជនយនាត៑ នាសាំ ពហិឞ្កុរុ តតោ និជទ្ឫឞ្ដៅ សុប្រសន្នាយាំ តវ ភ្រាត្ឫ រ្លោចនាត៑ ត្ឫណំ ពហិឞ្កត៌ុំ ឝក្ឞ្យសិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","អន្យញ្ច សារមេយេភ្យះ បវិត្រវស្តូនិ មា វិតរត, វរាហាណាំ សមក្ឞញ្ច មុក្តា មា និក្ឞិបត; និក្ឞេបណាត៑ តេ តាះ សវ៌្វាះ បទៃ រ្ទលយិឞ្យន្តិ, បរាវ្ឫត្យ យុឞ្មានបិ វិទារយិឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","យាចធ្វំ តតោ យុឞ្មភ្យំ ទាយិឞ្យតេ; ម្ឫគយធ្វំ តត ឧទ្ទេឝំ លប្ស្យធ្វេ; ទ្វារម៑ អាហត, តតោ យុឞ្មត្ក្ឫតេ មុក្តំ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","យស្មាទ៑ យេន យាច្យតេ, តេន លភ្យតេ; យេន ម្ឫគ្យតេ តេនោទ្ទេឝះ ប្រាប្យតេ; យេន ច ទ្វារម៑ អាហន្យតេ, តត្ក្ឫតេ ទ្វារំ មោច្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","អាត្មជេន បូបេ ប្រាត៌្ហិតេ តស្មៃ បាឞាណំ វិឝ្រាណយតិ, ");
INSERT INTO sankhm_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","មីនេ យាចិតេ ច តស្មៃ ភុជគំ វិតរតិ, ឯតាទ្ឫឝះ បិតា យុឞ្មាកំ មធ្យេ ក អាស្តេ? ");
INSERT INTO sankhm_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","តស្មាទ៑ យូយម៑ អភទ្រាះ សន្តោៜបិ យទិ និជពាលកេភ្យ ឧត្តមំ ទ្រវ្យំ ទាតុំ ជានីថ, តហ៌ិ យុឞ្មាកំ ស្វគ៌ស្ថះ បិតា ស្វីយយាចកេភ្យះ កិមុត្តមានិ វស្តូនិ ន ទាស្យតិ? ");
INSERT INTO sankhm_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","យូឞ្មាន៑ ប្រតីតរេឞាំ យាទ្ឫឝោ វ្យវហារោ យុឞ្មាកំ ប្រិយះ, យូយំ តាន៑ ប្រតិ តាទ្ឫឝានេវ វ្យវហារាន៑ វិធត្ត; យស្មាទ៑ វ្យវស្ថាភវិឞ្យទ្វាទិនាំ វចនានាម៑ ឥតិ សារម៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","សង្កីណ៌ទ្វារេណ ប្រវិឝត; យតោ នរកគមនាយ យទ៑ ទ្វារំ តទ៑ វិស្តីណ៌ំ យច្ច វត៌្ម តទ៑ ព្ឫហត៑ តេន ពហវះ ប្រវិឝន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","អបរំ ស្វគ៌គមនាយ យទ៑ ទ្វារំ តត៑ កីទ្ឫក៑ សំកីណ៌ំ។ យច្ច វត៌្ម តត៑ កីទ្ឫគ៑ ទុគ៌មម៑។ តទុទ្ទេឞ្ដារះ កិយន្តោៜល្បាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","អបរញ្ច យេ ជនា មេឞវេឝេន យុឞ្មាកំ សមីបម៑ អាគច្ឆន្តិ, កិន្ត្វន្តទ៌ុរន្តា វ្ឫកា ឯតាទ្ឫឝេភ្យោ ភវិឞ្យទ្វាទិភ្យះ សាវធានា ភវត, យូយំ ផលេន តាន៑ បរិចេតុំ ឝក្នុថ។ ");
INSERT INTO sankhm_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","មនុជាះ កិំ កណ្ដកិនោ វ្ឫក្ឞាទ៑ ទ្រាក្ឞាផលានិ ឝ្ឫគាលកោលិតឝ្ច ឧឌុម្ពរផលានិ ឝាតយន្តិ? ");
INSERT INTO sankhm_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","តទ្វទ៑ ឧត្តម ឯវ បាទប ឧត្តមផលានិ ជនយតិ, អធមបាទបឯវាធមផលានិ ជនយតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","កិន្តូត្តមបាទបះ កទាប្យធមផលានិ ជនយិតុំ ន ឝក្នោតិ, តថាធមោបិ បាទប ឧត្តមផលានិ ជនយិតុំ ន ឝក្នោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","អបរំ យេ យេ បាទបា អធមផលានិ ជនយន្តិ, តេ ក្ឫត្តា វហ្នៅ ក្ឞិប្យន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","អតឯវ យូយំ ផលេន តាន៑ បរិចេឞ្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","យេ ជនា មាំ ប្រភុំ វទន្តិ, តេ សវ៌្វេ ស្វគ៌រាជ្យំ ប្រវេក្ឞ្យន្តិ តន្ន, កិន្តុ យោ មានវោ មម ស្វគ៌ស្ថស្យ បិតុរិឞ្ដំ កម៌្ម ករោតិ ស ឯវ ប្រវេក្ឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","តទ៑ ទិនេ ពហវោ មាំ វទិឞ្យន្តិ, ហេ ប្រភោ ហេ ប្រភោ, តវ នាម្នា កិមស្មាមិ រ្ភវិឞ្យទ្វាក្យំ ន វ្យាហ្ឫតំ? តវ នាម្នា ភូតាះ កិំ ន ត្យាជិតាះ? តវ នាម្នា កិំ នានាទ្ភុតានិ កម៌្មាណិ ន ក្ឫតានិ? ");
INSERT INTO sankhm_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","តទាហំ វទិឞ្យាមិ, ហេ កុកម៌្មការិណោ យុឞ្មាន៑ អហំ ន វេទ្មិ, យូយំ មត្សមីបាទ៑ ទូរីភវត។ ");
INSERT INTO sankhm_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","យះ កឝ្ចិត៑ មមៃតាះ កថាះ ឝ្រុត្វា បាលយតិ, ស បាឞាណោបរិ គ្ឫហនិម៌្មាត្រា ជ្ញានិនា សហ មយោបមីយតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","យតោ វ្ឫឞ្ដៅ សត្យាម៑ អាប្លាវ អាគតេ វាយៅ វាតេ ច តេឞុ តទ្គេហំ លគ្នេឞុ បាឞាណោបរិ តស្យ ភិត្តេស្តន្ន បតតិl ");
INSERT INTO sankhm_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","កិន្តុ យះ កឝ្ចិត៑ មមៃតាះ កថាះ ឝ្រុត្វា ន បាលយតិ ស សៃកតេ គេហនិម៌្មាត្រា ៜជ្ញានិនា ឧបមីយតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","យតោ ជលវ្ឫឞ្ដៅ សត្យាម៑ អាប្លាវ អាគតេ បវនេ វាតេ ច តៃ រ្គ្ឫហេ សមាឃាតេ តត៑ បតតិ តត្បតនំ មហទ៑ ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","យីឝុនៃតេឞុ វាក្យេឞុ សមាបិតេឞុ មានវាស្តទីយោបទេឝម៑ អាឝ្ចយ៌្យំ មេនិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","យស្មាត៑ ស ឧបាធ្យាយា ឥវ តាន៑ នោបទិទេឝ កិន្តុ សមត៌្ហបុរុឞឥវ សមុបទិទេឝ។ ");
INSERT INTO sankhm_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","យទា ស បវ៌្វតាទ៑ អវារោហត៑ តទា ពហវោ មានវាស្តត្បឝ្ចាទ៑ វវ្រជុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ឯកះ កុឞ្ឋវាន៑ អាគត្យ តំ ប្រណម្យ ពភាឞេ, ហេ ប្រភោ, យទិ ភវាន៑ សំមន្យតេ, តហ៌ិ មាំ និរាមយំ កត៌្តុំ ឝក្នោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","តតោ យីឝុះ ករំ ប្រសាយ៌្យ តស្យាង្គំ ស្ប្ឫឝន៑ វ្យាជហារ, សម្មន្យេៜហំ ត្វំ និរាមយោ ភវ; តេន ស តត្ក្ឞណាត៑ កុឞ្ឋេនាមោចិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","តតោ យីឝុស្តំ ជគាទ, អវធេហិ កថាមេតាំ កឝ្ចិទបិ មា ព្រូហិ, កិន្តុ យាជកស្យ សន្និធិំ គត្វា ស្វាត្មានំ ទឝ៌យ មនុជេភ្យោ និជនិរាមយត្វំ ប្រមាណយិតុំ មូសានិរូបិតំ ទ្រវ្យម៑ ឧត្ស្ឫជ ច។ ");
INSERT INTO sankhm_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","តទនន្តរំ យីឝុនា កផន៌ាហូម្នាមនិ នគរេ ប្រវិឞ្ដេ កឝ្ចិត៑ ឝតសេនាបតិស្តត្សមីបម៑ អាគត្យ វិនីយ ពភាឞេ, ");
INSERT INTO sankhm_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ហេ ប្រភោ, មទីយ ឯកោ ទាសះ បក្ឞាឃាតវ្យាធិនា ភ្ឫឝំ វ្យថិតះ, សតុ ឝយនីយ អាស្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","តទានីំ យីឝុស្តស្មៃ កថិតវាន៑, អហំ គត្វា តំ និរាមយំ ករិឞ្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","តតះ ស ឝតសេនាបតិះ ប្រត្យវទត៑, ហេ ប្រភោ, ភវាន៑ យត៑ មម គេហមធ្យំ យាតិ តទ្យោគ្យភាជនំ នាហមស្មិ; វាង្មាត្រម៑ អាទិឝតុ, តេនៃវ មម ទាសោ និរាមយោ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","យតោ មយិ បរនិធ្នេៜបិ មម និទេឝវឝ្យាះ កតិ កតិ សេនាះ សន្តិ, តត ឯកស្មិន៑ យាហីត្យុក្តេ ស យាតិ, តទន្យស្មិន៑ ឯហីត្យុក្តេ ស អាយាតិ, តថា មម និជទាសេ កម៌្មៃតត៑ កុវ៌្វិត្យុក្តេ ស តត៑ ករោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","តទានីំ យីឝុស្តស្យៃតត៑ វចោ និឝម្យ វិស្មយាបន្នោៜភូត៑; និជបឝ្ចាទ្គាមិនោ មានវាន៑ អវោច្ច, យុឞ្មាន៑ តថ្យំ វច្មិ, ឥស្រាយេលីយលោកានាំ មធ្យេៜបិ នៃតាទ្ឫឝោ វិឝ្វាសោ មយា ប្រាប្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","អន្យច្ចាហំ យុឞ្មាន៑ វទាមិ, ពហវះ បូវ៌្វស្យាះ បឝ្ចិមាយាឝ្ច ទិឝ អាគត្យ ឥព្រាហីមា ឥស្ហាកា យាកូពា ច សាកម៑ មិលិត្វា សមុបវេក្ឞ្យន្តិ; ");
INSERT INTO sankhm_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","កិន្តុ យត្រ ស្ថានេ រោទនទន្តឃឞ៌ណេ ភវតស្តស្មិន៑ ពហិព៌្ហូតតមិស្រេ រាជ្យស្យ សន្តានា និក្ឞេស្យន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","តតះ បរំ យីឝុស្តំ ឝតសេនាបតិំ ជគាទ, យាហិ, តវ ប្រតីត្យនុសារតោ មង្គលំ ភូយាត៑; តទា តស្មិន្នេវ ទណ្ឌេ តទីយទាសោ និរាមយោ ពភូវ។ ");
INSERT INTO sankhm_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","អនន្តរំ យីឝុះ បិតរស្យ គេហមុបស្ថាយ ជ្វរេណ បីឌិតាំ ឝយនីយស្ថិតាំ តស្យ ឝ្វឝ្រូំ វីក្ឞាញ្ចក្រេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","តតស្តេន តស្យាះ ករស្យ ស្ប្ឫឞ្ដតវាត៑ ជ្វរស្តាំ តត្យាជ, តទា សា សមុត្ថាយ តាន៑ សិឞេវេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","អនន្តរំ សន្ធ្យាយាំ សត្យាំ ពហុឝោ ភូតគ្រស្តមនុជាន៑ តស្យ សមីបម៑ អានិន្យុះ ស ច វាក្យេន ភូតាន៑ ត្យាជយាមាស, សវ៌្វប្រការបីឌិតជនាំឝ្ច និរាមយាន៑ ចការ; ");
INSERT INTO sankhm_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","តស្មាត៑, សវ៌្វា ទុព៌្ពលតាស្មាកំ តេនៃវ បរិធារិតា។ អស្មាកំ សកលំ វ្យាធិំ សឯវ សំគ្ឫហីតវាន៑។ យទេតទ្វចនំ យិឝយិយភវិឞ្យទ្វាទិនោក្តមាសីត៑, តត្តទា សផលមភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","អនន្តរំ យីឝុឝ្ចតុទ៌ិក្ឞុ ជននិវហំ វិលោក្យ តដិន្យាះ បារំ យាតុំ ឝិឞ្យាន៑ អាទិទេឝ។ ");
INSERT INTO sankhm_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","តទានីម៑ ឯក ឧបាធ្យាយ អាគត្យ កថិតវាន៑, ហេ គុរោ, ភវាន៑ យត្រ យាស្យតិ តត្រាហមបិ ភវតះ បឝ្ចាទ៑ យាស្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","តតោ យីឝុ រ្ជគាទ, ក្រោឞ្ដុះ ស្ថាតុំ ស្ថានំ វិទ្យតេ, វិហាយសោ វិហង្គមានាំ នីឌានិ ច សន្តិ; កិន្តុ មនុឞ្យបុត្រស្យ ឝិរះ ស្ថាបយិតុំ ស្ថានំ ន វិទ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","អនន្តរម៑ អបរ ឯកះ ឝិឞ្យស្តំ ពភាឞេ, ហេ ប្រភោ, ប្រថមតោ មម បិតរំ ឝ្មឝានេ និធាតុំ គមនាត៌្ហំ មាម៑ អនុមន្យស្វ។ ");
INSERT INTO sankhm_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","តតោ យីឝុរុក្តវាន៑ ម្ឫតា ម្ឫតាន៑ ឝ្មឝានេ និទធតុ, ត្វំ មម បឝ្ចាទ៑ អាគច្ឆ។ ");
INSERT INTO sankhm_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","អនន្តរំ តស្មិន៑ នាវមារូឍេ តស្យ ឝិឞ្យាស្តត្បឝ្ចាត៑ ជគ្មុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","បឝ្ចាត៑ សាគរស្យ មធ្យំ តេឞុ គតេឞុ តាទ្ឫឝះ ប្រពលោ ឈញ្ភ្ឝនិល ឧទតិឞ្ឋត៑, យេន មហាតរង្គ ឧត្ថាយ តរណិំ ឆាទិតវាន៑, កិន្តុ ស និទ្រិត អាសីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","តទា ឝិឞ្យា អាគត្យ តស្យ និទ្រាភង្គំ ក្ឫត្វា កថយាមាសុះ, ហេ ប្រភោ, វយំ ម្រិយាមហេ, ភវាន៑ អស្មាកំ ប្រាណាន៑ រក្ឞតុ។ ");
INSERT INTO sankhm_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","តទា ស តាន៑ ឧក្តវាន៑, ហេ អល្បវិឝ្វាសិនោ យូយំ កុតោ វិភីថ? តតះ ស ឧត្ថាយ វាតំ សាគរញ្ច តជ៌យាមាស, តតោ និវ៌្វាតមភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","អបរំ មនុជា វិស្មយំ វិលោក្យ កថយាមាសុះ, អហោ វាតសរិត្បតី អស្យ កិមាជ្ញាគ្រាហិណៅ? កីទ្ឫឝោៜយំ មានវះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","អនន្តរំ ស បារំ គត្វា គិទេរីយទេឝម៑ ឧបស្ថិតវាន៑; តទា ទ្វៅ ភូតគ្រស្តមនុជៅ ឝ្មឝានស្ថានាទ៑ ពហិ រ្ភូត្វា តំ សាក្ឞាត៑ ក្ឫតវន្តៅ, តាវេតាទ្ឫឝៅ ប្រចណ្ឌាវាស្តាំ យត៑ តេន ស្ថានេន កោបិ យាតុំ នាឝក្នោត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","តាវុចៃះ កថយាមាសតុះ, ហេ ឦឝ្វរស្យ សូនោ យីឝោ, ត្វយា សាកម៑ អាវយោះ កះ សម្ពន្ធះ? និរូបិតកាលាត៑ ប្រាគេវ កិមាវាភ្យាំ យាតនាំ ទាតុម៑ អត្រាគតោសិ? ");
INSERT INTO sankhm_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","តទានីំ តាភ្យាំ កិញ្ចិទ៑ ទូរេ វរាហាណាម៑ ឯកោ មហាវ្រជោៜចរត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","តតោ ភូតៅ តៅ តស្យាន្តិកេ វិនីយ កថយាមាសតុះ, យទ្យាវាំ ត្យាជយសិ, តហ៌ិ វរាហាណាំ មធ្យេវ្រជម៑ អាវាំ ប្រេរយ។ ");
INSERT INTO sankhm_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","តទា យីឝុរវទត៑ យាតំ, អនន្តរំ តៅ យទា មនុជៅ វិហាយ វរាហាន៑ អាឝ្រិតវន្តៅ, តទា តេ សវ៌្វេ វរាហា ឧច្ចស្ថានាត៑ មហាជវេន ធាវន្តះ សាគរីយតោយេ មជ្ជន្តោ មម្រុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","តតោ វរាហរក្ឞកាះ បលាយមានា មធ្យេនគរំ តៅ ភូតគ្រស្តៅ ប្រតិ យទ្យទ៑ អឃដត, តាះ សវ៌្វវាត៌្តា អវទន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","តតោ នាគរិកាះ សវ៌្វេ មនុជា យីឝុំ សាក្ឞាត៑ កត៌្តុំ ពហិរាយាតាះ តញ្ច វិលោក្យ ប្រាត៌្ហយាញ្ចក្រិរេ ភវាន៑ អស្មាកំ សីមាតោ យាតុ។ ");
INSERT INTO sankhm_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","អនន្តរំ យីឝុ រ្នៅកាមារុហ្យ បុនះ បារមាគត្យ និជគ្រាមម៑ អាយយៅ។ ");
INSERT INTO sankhm_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","តតះ កតិបយា ជនា ឯកំ បក្ឞាឃាតិនំ ស្វដ្ដោបរិ ឝាយយិត្វា តត្សមីបម៑ អានយន៑; តតោ យីឝុស្តេឞាំ ប្រតីតិំ វិជ្ញាយ តំ បក្ឞាឃាតិនំ ជគាទ, ហេ បុត្រ, សុស្ថិរោ ភវ, តវ កលុឞស្យ មឞ៌ណំ ជាតម៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","តាំ កថាំ និឝម្យ កិយន្ត ឧបាធ្យាយា មនះសុ ចិន្តិតវន្ត ឯឞ មនុជ ឦឝ្វរំ និន្ទតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","តតះ ស តេឞាម៑ ឯតាទ្ឫឝីំ ចិន្តាំ វិជ្ញាយ កថិតវាន៑, យូយំ មនះសុ ក្ឫត ឯតាទ្ឫឝីំ កុចិន្តាំ កុរុថ? ");
INSERT INTO sankhm_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","តវ បាបមឞ៌ណំ ជាតំ, យទ្វា ត្វមុត្ថាយ គច្ឆ, ទ្វយោរនយោ រ្វាក្យយោះ កិំ វាក្យំ វក្តុំ សុគមំ? ");
INSERT INTO sankhm_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","កិន្តុ មេទិន្យាំ កលុឞំ ក្ឞមិតុំ មនុជសុតស្យ សាមត៌្ហ្យមស្តីតិ យូយំ យថា ជានីថ, តទត៌្ហំ ស តំ បក្ឞាឃាតិនំ គទិតវាន៑, ឧត្តិឞ្ឋ, និជឝយនីយំ អាទាយ គេហំ គច្ឆ។ ");
INSERT INTO sankhm_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","តតះ ស តត្ក្ឞណាទ៑ ឧត្ថាយ និជគេហំ ប្រស្ថិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","មានវា ឥត្ថំ វិលោក្យ វិស្មយំ មេនិរេ, ឦឝ្វរេណ មានវាយ សាមត៌្ហ្យម៑ ឦទ្ឫឝំ ទត្តំ ឥតិ ការណាត៑ តំ ធន្យំ ពភាឞិរេ ច។ ");
INSERT INTO sankhm_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","អនន្តរំ យីឝុស្តត្ស្ថានាទ៑ គច្ឆន៑ គច្ឆន៑ ករសំគ្រហស្ថានេ សមុបវិឞ្ដំ មថិនាមានម៑ ឯកំ មនុជំ វិលោក្យ តំ ពភាឞេ, មម បឝ្ចាទ៑ អាគច្ឆ, តតះ ស ឧត្ថាយ តស្យ បឝ្ចាទ៑ វវ្រាជ។ ");
INSERT INTO sankhm_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","តតះ បរំ យីឝៅ គ្ឫហេ ភោក្តុម៑ ឧបវិឞ្ដេ ពហវះ ករសំគ្រាហិណះ កលុឞិណឝ្ច មានវា អាគត្យ តេន សាកំ តស្យ ឝិឞ្យៃឝ្ច សាកម៑ ឧបវិវិឝុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ផិរូឝិនស្តទ៑ ទ្ឫឞ្ដ្វា តស្យ ឝិឞ្យាន៑ ពភាឞិរេ, យុឞ្មាកំ គុរុះ កិំ និមិត្តំ ករសំគ្រាហិភិះ កលុឞិភិឝ្ច សាកំ ភុំក្តេ? ");
INSERT INTO sankhm_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","យីឝុស្តត៑ ឝ្រុត្វា តាន៑ ប្រត្យវទត៑, និរាមយលោកានាំ ចិកិត្សកេន ប្រយោជនំ នាស្តិ, កិន្តុ សាមយលោកានាំ ប្រយោជនមាស្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","អតោ យូយំ យាត្វា វចនស្យាស្យាត៌្ហំ ឝិក្ឞធ្វម៑, ទយាយាំ មេ យថា ប្រីតិ រ្ន តថា យជ្ញកម៌្មណិ។ យតោៜហំ ធាម៌្មិកាន៑ អាហ្វាតុំ នាគតោៜស្មិ កិន្តុ មនះ បរិវត៌្តយិតុំ បាបិន អាហ្វាតុម៑ អាគតោៜស្មិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","អនន្តរំ យោហនះ ឝិឞ្យាស្តស្យ សមីបម៑ អាគត្យ កថយាមាសុះ, ផិរូឝិនោ វយញ្ច បុនះ បុនរុបវសាមះ, កិន្តុ តវ ឝិឞ្យា នោបវសន្តិ, កុតះ? ");
INSERT INTO sankhm_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","តទា យីឝុស្តាន៑ អវោចត៑ យាវត៑ សខីនាំ សំង្គេ កន្យាយា វរស្តិឞ្ឋតិ, តាវត៑ កិំ តេ វិលាបំ កត៌្តុំ ឝក្លុវន្តិ? កិន្តុ យទា តេឞាំ សំង្គាទ៑ វរំ នយន្តិ, តាទ្ឫឝះ សមយ អាគមិឞ្យតិ, តទា តេ ឧបវត្ស្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","បុរាតនវសនេ កោបិ នវីនវស្ត្រំ ន យោជយតិ, យស្មាត៑ តេន យោជិតេន បុរាតនវសនំ ឆិនត្តិ តច្ឆិទ្រញ្ច ពហុកុត្សិតំ ទ្ឫឝ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","អន្យញ្ច បុរាតនកុត្វាំ កោបិ នវានគោស្តនីរសំ ន និទធាតិ, យស្មាត៑ តថា ក្ឫតេ កុតូ រ្វិទីយ៌្យតេ តេន គោស្តនីរសះ បតតិ កុតូឝ្ច នឝ្យតិ; តស្មាត៑ នវីនាយាំ កុត្វាំ នវីនោ គោស្តនីរសះ ស្ថាប្យតេ, តេន ទ្វយោរវនំ ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","អបរំ តេនៃតត្កថាកថនកាលេ ឯកោៜធិបតិស្តំ ប្រណម្យ ពភាឞេ, មម ទុហិតា ប្រាយេណៃតាវត្កាលេ ម្ឫតា, តស្មាទ៑ ភវានាគត្យ តស្យា គាត្រេ ហស្តមប៌យតុ, តេន សា ជីវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","តទានីំ យីឝុះ ឝិឞ្យៃះ សាកម៑ ឧត្ថាយ តស្យ បឝ្ចាទ៑ វវ្រាជ។ ");
INSERT INTO sankhm_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ឥត្យនន្តរេ ទ្វាទឝវត្សរាន៑ យាវត៑ ប្រទរាមយេន ឝីណ៌ៃកា នារី តស្យ បឝ្ចាទ៑ អាគត្យ តស្យ វសនស្យ គ្រន្ថិំ បស្បឝ៌; ");
INSERT INTO sankhm_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","យស្មាត៑ មយា កេវលំ តស្យ វសនំ ស្ប្ឫឞ្ដ្វា ស្វាស្ថ្យំ ប្រាប្ស្យតេ, សា នារីតិ មនសិ និឝ្ចិតវតី។ ");
INSERT INTO sankhm_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","តតោ យីឝុវ៌ទនំ បរាវត៌្ត្យ តាំ ជគាទ, ហេ កន្យេ, ត្វំ សុស្ថិរា ភវ, តវ វិឝ្វាសស្ត្វាំ ស្វស្ថាមកាឞ៌ីត៑។ ឯតទ្វាក្យេ គទិតឯវ សា យោឞិត៑ ស្វស្ថាភូត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","អបរំ យីឝុស្តស្យាធ្យក្ឞស្យ គេហំ គត្វា វាទកប្រភ្ឫតីន៑ ពហូន៑ លោកាន៑ ឝព្ទាយមានាន៑ វិលោក្យ តាន៑ អវទត៑, ");
INSERT INTO sankhm_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","បន្ថានំ ត្យជ, កន្យេយំ នាម្រិយត និទ្រិតាស្តេ; កថាមេតាំ ឝ្រុត្វា តេ តមុបជហសុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","កិន្តុ សវ៌្វេឞុ ពហិឞ្ក្ឫតេឞុ សោៜភ្យន្តរំ គត្វា កន្យាយាះ ករំ ធ្ឫតវាន៑, តេន សោទតិឞ្ឋត៑; ");
INSERT INTO sankhm_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","តតស្តត្កម៌្មណោ យឝះ ក្ឫត្ស្នំ តំ ទេឝំ វ្យាប្តវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","តតះ បរំ យីឝុស្តស្មាត៑ ស្ថានាទ៑ យាត្រាំ ចការ; តទា ហេ ទាយូទះ សន្តាន, អស្មាន៑ ទយស្វ, ឥតិ វទន្តៅ ទ្វៅ ជនាវន្ធៅ ប្រោចៃរាហូយន្តៅ តត្បឝ្ចាទ៑ វវ្រជតុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","តតោ យីឝៅ គេហមធ្យំ ប្រវិឞ្ដំ តាវបិ តស្យ សមីបម៑ ឧបស្ថិតវន្តៅ, តទានីំ ស តៅ ប្ឫឞ្ដវាន៑ កម៌្មៃតត៑ កត៌្តុំ មម សាមត៌្ហ្យម៑ អាស្តេ, យុវាំ កិមិតិ ប្រតីថះ? តទា តៅ ប្រត្យូចតុះ, សត្យំ ប្រភោ។ ");
INSERT INTO sankhm_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","តទានីំ ស តយោ រ្លោចនានិ ស្ប្ឫឝន៑ ពភាឞេ, យុវយោះ ប្រតីត្យនុសារាទ៑ យុវយោ រ្មង្គលំ ភូយាត៑។ តេន តត្ក្ឞណាត៑ តយោ រ្នេត្រាណិ ប្រសន្នាន្យភវន៑, ");
INSERT INTO sankhm_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","បឝ្ចាទ៑ យីឝុស្តៅ ទ្ឫឍមាជ្ញាប្យ ជគាទ, អវធត្តម៑ ឯតាំ កថាំ កោបិ មនុជោ ម ជានីយាត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","កិន្តុ តៅ ប្រស្ថាយ តស្មិន៑ ក្ឫត្ស្នេ ទេឝេ តស្យ កីត៌្តិំ ប្រកាឝយាមាសតុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","អបរំ តៅ ពហិយ៌ាត ឯតស្មិន្នន្តរេ មនុជា ឯកំ ភូតគ្រស្តមូកំ តស្យ សមីបម៑ អានីតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","តេន ភូតេ ត្យាជិតេ ស មូកះ កថាំ កថយិតុំ ប្រារភត, តេន ជនា វិស្មយំ វិជ្ញាយ កថយាមាសុះ, ឥស្រាយេលោ វំឝេ កទាបិ នេទ្ឫគទ្ឫឝ្យត; ");
INSERT INTO sankhm_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","កិន្តុ ផិរូឝិនះ កថយាញ្ចក្រុះ ភូតាធិបតិនា ស ភូតាន៑ ត្យាជយតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","តតះ បរំ យីឝុស្តេឞាំ ភជនភវន ឧបទិឝន៑ រាជ្យស្យ សុសំវាទំ ប្រចារយន៑ លោកានាំ យស្យ យ អាមយោ យា ច បីឌាសីត៑, តាន៑ ឝមយន៑ ឝមយំឝ្ច សវ៌្វាណិ នគរាណិ គ្រាមាំឝ្ច ពភ្រាម។ ");
INSERT INTO sankhm_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","អន្យញ្ច មនុជាន៑ វ្យាកុលាន៑ អរក្ឞកមេឞានិវ ច ត្យក្តាន៑ និរីក្ឞ្យ តេឞុ ការុណិកះ សន៑ ឝិឞ្យាន៑ អវទត៑, ");
INSERT INTO sankhm_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ឝស្យានិ ប្រចុរាណិ សន្តិ, កិន្តុ ឆេត្តារះ ស្តោកាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ក្ឞេត្រំ ប្រត្យបរាន៑ ឆេទកាន៑ ប្រហេតុំ ឝស្យស្វាមិនំ ប្រាត៌្ហយធ្វម៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","អនន្តរំ យីឝុ រ្ទ្វាទឝឝិឞ្យាន៑ អាហូយាមេធ្យភូតាន៑ ត្យាជយិតុំ សវ៌្វប្រការរោគាន៑ បីឌាឝ្ច ឝមយិតុំ តេភ្យះ សាមត៌្ហ្យមទាត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","តេឞាំ ទ្វាទឝប្រេឞ្យាណាំ នាមាន្យេតានិ។ ប្រថមំ ឝិមោន៑ យំ បិតរំ វទន្តិ, តតះ បរំ តស្យ សហជ អាន្ទ្រិយះ, សិវទិយស្យ បុត្រោ យាកូព្ ");
INSERT INTO sankhm_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","តស្យ សហជោ យោហន៑; ផិលិប៑ ពត៌្ហលមយ៑ ថោមាះ ករសំគ្រាហី មថិះ, អាល្ផេយបុត្រោ យាកូព៑, ");
INSERT INTO sankhm_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","កិនានីយះ ឝិមោន៑, យ ឦឞ្ករិយោតីយយិហូទាះ ខ្រីឞ្ដំ បរករេៜរ្បយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ឯតាន៑ ទ្វាទឝឝិឞ្យាន៑ យីឝុះ ប្រេឞយន៑ ឥត្យាជ្ញាបយត៑, យូយម៑ អន្យទេឝីយានាំ បទវីំ ឝេមិរោណីយានាំ កិមបិ នគរញ្ច ន ប្រវិឝ្យេ ");
INSERT INTO sankhm_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ឥស្រាយេល្គោត្រស្យ ហារិតា យេ យេ មេឞាស្តេឞាមេវ សមីបំ យាត។ ");
INSERT INTO sankhm_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","គត្វា គត្វា ស្វគ៌ស្យ រាជត្វំ សវិធមភវត៑, ឯតាំ កថាំ ប្រចារយត។ ");
INSERT INTO sankhm_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","អាមយគ្រស្តាន៑ ស្វស្ថាន៑ កុរុត, កុឞ្ឋិនះ បរិឞ្កុរុត, ម្ឫតលោកាន៑ ជីវយត, ភូតាន៑ ត្យាជយត, វិនា មូល្យំ យូយម៑ អលភធ្វំ វិនៃវ មូល្យំ វិឝ្រាណយត។ ");
INSERT INTO sankhm_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","កិន្តុ ស្វេឞាំ កដិពន្ធេឞុ ស្វណ៌រូប្យតាម្រាណាំ កិមបិ ន គ្ឫហ្លីត។ ");
INSERT INTO sankhm_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","អន្យច្ច យាត្រាយៃ ចេលសម្បុដំ វា ទ្វិតីយវសនំ វា បាទុកេ វា យឞ្ដិះ, ឯតាន៑ មា គ្ឫហ្លីត, យតះ កាយ៌្យក្ឫត៑ ភត៌្តុំ យោគ្យោ ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","អបរំ យូយំ យត៑ បុរំ យញ្ច គ្រាមំ ប្រវិឝថ, តត្រ យោ ជនោ យោគ្យបាត្រំ តមវគត្យ យានកាលំ យាវត៑ តត្រ តិឞ្ឋត។ ");
INSERT INTO sankhm_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","យទា យូយំ តទ្គេហំ ប្រវិឝថ, តទា តមាឝិឞំ វទត។ ");
INSERT INTO sankhm_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","យទិ ស យោគ្យបាត្រំ ភវតិ, តហ៌ិ តត្កល្យាណំ តស្មៃ ភវិឞ្យតិ, នោចេត៑ សាឝីយ៌ុឞ្មភ្យមេវ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","កិន្តុ យេ ជនា យុឞ្មាកមាតិថ្យំ ន វិទធតិ យុឞ្មាកំ កថាញ្ច ន ឝ្ឫណ្វន្តិ តេឞាំ គេហាត៑ បុរាទ្វា ប្រស្ថានកាលេ ស្វបទូលីះ បាតយត។ ");
INSERT INTO sankhm_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","យុឞ្មានហំ តថ្យំ វច្មិ វិចារទិនេ តត្បុរស្យ ទឝាតះ សិទោមមោរាបុរយោទ៌ឝា សហ្យតរា ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","បឝ្យត, វ្ឫកយូថមធ្យេ មេឞះ យថាវិស្តថា យុឞ្មាន ប្រហិណោមិ, តស្មាទ៑ យូយម៑ អហិរិវ សតក៌ាះ កបោតាឥវាហិំសកា ភវត។ ");
INSERT INTO sankhm_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","ន្ឫភ្យះ សាវធានា ភវត; យតស្តៃ រ្យូយំ រាជសំសទិ សមប៌ិឞ្យធ្វេ តេឞាំ ភជនគេហេ ប្រហារិឞ្យធ្វេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","យូយំ មន្នាមហេតោះ ឝាស្ត្ឫណាំ រាជ្ញាញ្ច សមក្ឞំ តានន្យទេឝិនឝ្ចាធិ សាក្ឞិត្វាត៌្ហមានេឞ្យធ្វេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","កិន្ត្វិត្ថំ សមប៌ិតា យូយំ កថំ កិមុត្តរំ វក្ឞ្យថ តត្រ មា ចិន្តយត, យតស្តទា យុឞ្មាភិ រ្យទ៑ វក្តវ្យំ តត៑ តទ្ទណ្ឌេ យុឞ្មន្មនះ សុ សមុបស្ថាស្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","យស្មាត៑ តទា យោ វក្ឞ្យតិ ស ន យូយំ កិន្តុ យុឞ្មាកមន្តរស្ថះ បិត្រាត្មា។ ");
INSERT INTO sankhm_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","សហជះ សហជំ តាតះ សុតញ្ច ម្ឫតៅ សមប៌យិឞ្យតិ, អបត្យាគិ ស្វស្វបិត្រោे រ្វិបក្ឞីភូយ តៅ ឃាតយិឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","មន្នមហេតោះ សវ៌្វេ ជនា យុឞ្មាន៑ ឫृតីយិឞ្យន្តេ, កិន្តុ យះ ឝេឞំ យាវទ៑ ធៃយ៌្យំ ឃ្ឫត្វា ស្ថាស្យតិ, ស ត្រាយិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","តៃ រ្យទា យូយមេកបុរេ តាឌិឞ្យធ្វេ, តទា យូយមន្យបុរំ បលាយធ្វំ យុឞ្មានហំ តថ្យំ វច្មិ យាវន្មនុជសុតោ នៃតិ តាវទ៑ ឥស្រាយេល្ទេឝីយសវ៌្វនគរភ្រមណំ សមាបយិតុំ ន ឝក្ឞ្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","គុរោះ ឝិឞ្យោ ន មហាន៑, ប្រភោទ៌ាសោ ន មហាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","យទិ ឝិឞ្យោ និជគុរោ រ្ទាសឝ្ច ស្វប្រភោះ សមានោ ភវតិ តហ៌ិ តទ៑ យថេឞ្ដំ។ ចេត្តៃគ៌្ឫហបតិព៌្ហូតរាជ ឧច្យតេ, តហ៌ិ បរិវារាះ កិំ តថា ន វក្ឞ្យន្តេ? ");
INSERT INTO sankhm_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","កិន្តុ តេភ្យោ យូយំ មា ពិភីត, យតោ យន្ន ប្រកាឝិឞ្យតេ, តាទ្ឫក៑ ឆាទិតំ កិមបិ នាស្តិ, យច្ច ន វ្យញ្ចិឞ្យតេ, តាទ្ឫគ៑ គុប្តំ កិមបិ នាស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","យទហំ យុឞ្មាន៑ តមសិ វច្មិ តទ៑ យុឞ្មាភិទ៌ីប្តៅ កថ្យតាំ; កណ៌ាភ្យាំ យត៑ ឝ្រូយតេ តទ៑ គេហោបរិ ប្រចាយ៌្យតាំ។ ");
INSERT INTO sankhm_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","យេ កាយំ ហន្តុំ ឝក្នុវន្តិ នាត្មានំ, តេភ្យោ មា ភៃឞ្ដ; យះ កាយាត្មានៅ និរយេ នាឝយិតុំ, ឝក្នោតិ, តតោ ពិភីត។ ");
INSERT INTO sankhm_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ទ្វៅ ចដកៅ កិមេកតាម្រមុទ្រយា ន វិក្រីយេតេ? តថាបិ យុឞ្មត្តាតានុមតិំ វិនា តេឞាមេកោបិ ភុវិ ន បតតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","យុឞ្មច្ឆិរសាំ សវ៌្វកចា គណិតាំះ សន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","អតោ មា ពិភីត, យូយំ ពហុចដកេភ្យោ ពហុមូល្យាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","យោ មនុជសាក្ឞាន្មាមង្គីកុរុតេ តមហំ ស្វគ៌ស្ថតាតសាក្ឞាទង្គីករិឞ្យេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ប្ឫថ្វ្យាមហំ ឝាន្តិំ ទាតុមាគតឥតិ មានុភវត, ឝាន្តិំ ទាតុំ ន កិន្ត្វសិំ។ ");
INSERT INTO sankhm_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","បិត្ឫមាត្ឫឝ្ចឝ្រូភិះ សាកំ សុតសុតាពធូ រ្វិរោធយិតុញ្ចាគតេाស្មិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","តតះ ស្វស្វបរិវារឯវ ន្ឫឝត្រុ រ្ភវិតា។ ");
INSERT INTO sankhm_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","យះ បិតរិ មាតរិ វា មត្តោធិកំ ប្រីយតេ, ស ន មទហ៌ះ; ");
INSERT INTO sankhm_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","យឝ្ច សុតេ សុតាយាំ វា មត្តោធិកំ ប្រីយតេ, សេाបិ ន មទហ៌ះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","យះ ស្វក្រុឝំ គ្ឫហ្លន៑ មត្បឝ្ចាន្នៃតិ, សេाបិ ន មទហ៌ះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","យះ ស្វប្រាណានវតិ, ស តាន៑ ហារយិឞ្យតេ, យស្តុ មត្ក្ឫតេ ស្វប្រាណាន៑ ហារយតិ, ស តានវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","យោ យុឞ្មាកមាតិថ្យំ វិទធាតិ, ស មមាតិថ្យំ វិទធាតិ, យឝ្ច មមាតិថ្យំ វិទធាតិ, ស មត្ប្រេរកស្យាតិថ្យំ វិទធាតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","យោ ភវិឞ្យទ្វាទីតិ ជ្ញាត្វា តស្យាតិថ្យំ វិធត្តេ, ស ភវិឞ្យទ្វាទិនះ ផលំ លប្ស្យតេ, យឝ្ច ធាម៌្មិក ឥតិ វិទិត្វា តស្យាតិថ្យំ វិធត្តេ ស ធាម៌្មិកមានវស្យ ផលំ ប្រាប្ស្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","យឝ្ច កឝ្ចិត៑ ឯតេឞាំ ក្ឞុទ្រនរាណាម៑ យំ កញ្ចនៃកំ ឝិឞ្យ ឥតិ វិទិត្វា កំសៃកំ ឝីតលសលិលំ តស្មៃ ទត្តេ, យុឞ្មានហំ តថ្យំ វទាមិ, ស កេនាបិ ប្រការេណ ផលេន ន វញ្ចិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ឥត្ថំ យីឝុះ ស្វទ្វាទឝឝិឞ្យាណាមាជ្ញាបនំ សមាប្យ បុរេ បុរ ឧបទេឞ្ដុំ សុសំវាទំ ប្រចារយិតុំ តត្ស្ថានាត៑ ប្រតស្ថេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","អនន្តរំ យោហន៑ ការាយាំ តិឞ្ឋន៑ ខ្រិឞ្ដស្យ កម៌្មណាំ វាត៌្តំ ប្រាប្យ យស្យាគមនវាត៌្តាសីត៑ សឯវ កិំ ត្វំ? វា វយមន្យម៑ អបេក្ឞិឞ្យាមហេ? ");
INSERT INTO sankhm_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ឯតត៑ ប្រឞ្ដុំ និជៅ ទ្វៅ ឝិឞ្យៅ ប្រាហិណោត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","យីឝុះ ប្រត្យវោចត៑, អន្ធា នេត្រាណិ លភន្តេ, ខញ្ចា គច្ឆន្តិ, កុឞ្ឋិនះ ស្វស្ថា ភវន្តិ, ពធិរាះ ឝ្ឫណ្វន្តិ, ម្ឫតា ជីវន្ត ឧត្តិឞ្ឋន្តិ, ទរិទ្រាណាំ សមីបេ សុសំវាទះ ប្រចាយ៌្យត, ");
INSERT INTO sankhm_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ឯតានិ យទ្យទ៑ យុវាំ ឝ្ឫណុថះ បឝ្យថឝ្ច គត្វា តទ្វាត៌្តាំ យោហនំ គទតំ។ ");
INSERT INTO sankhm_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","យស្យាហំ ន វិឃ្នីភវាមិ, សឯវ ធន្យះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","អនន្តរំ តយោះ ប្រស្ថិតយោ រ្យីឝុ រ្យោហនម៑ ឧទ្ទិឝ្យ ជនាន៑ ជគាទ, យូយំ កិំ ទ្រឞ្ដុំ វហិម៌ធ្យេប្រាន្តរម៑ អគច្ឆត? កិំ វាតេន កម្បិតំ នលំ? ");
INSERT INTO sankhm_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","វា កិំ វីក្ឞិតុំ វហិគ៌តវន្តះ? កិំ បរិហិតសូក្ឞ្មវសនំ មនុជមេកំ? បឝ្យត, យេ សូក្ឞ្មវសនានិ បរិទធតិ, តេ រាជធាន្យាំ តិឞ្ឋន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","តហ៌ិ យូយំ កិំ ទ្រឞ្ដុំ ពហិរគមត, កិមេកំ ភវិឞ្យទ្វាទិនំ? តទេវ សត្យំ។ យុឞ្មានហំ វទាមិ, ស ភវិឞ្យទ្វាទិនោបិ មហាន៑; ");
INSERT INTO sankhm_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","យតះ, បឝ្យ ស្វកីយទូតោយំ ត្វទគ្រេ ប្រេឞ្យតេ មយា។ ស គត្វា តវ បន្ថានំ ស្មយក៑ បរិឞ្ករិឞ្យតិ៕ ឯតទ្វចនំ យមធិ លិខិតមាស្តេ សោៜយំ យោហន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","អបរំ យុឞ្មានហំ តថ្យំ ព្រវីមិ, មជ្ជយិតុ រ្យោហនះ ឝ្រេឞ្ឋះ កោបិ នារីតោ នាជាយត; តថាបិ ស្វគ៌រាជ្យមធ្យេ សវ៌្វេភ្យោ យះ ក្ឞុទ្រះ ស យោហនះ ឝ្រេឞ្ឋះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","អបរញ្ច អា យោហនោៜទ្យ យាវត៑ ស្វគ៌រាជ្យំ ពលាទាក្រាន្តំ ភវតិ អាក្រមិនឝ្ច ជនា ពលេន តទធិកុវ៌្វន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","យតោ យោហនំ យាវត៑ សវ៌្វភវិឞ្យទ្វាទិភិ រ្វ្យវស្ថយា ច ឧបទេឝះ ប្រាកាឝ្យត។ ");
INSERT INTO sankhm_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","យទិ យូយមិទំ វាក្យំ គ្រហីតុំ ឝក្នុថ, តហ៌ិ ឝ្រេយះ, យស្យាគមនស្យ វចនមាស្តេ សោៜយម៑ ឯលិយះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","យស្យ ឝ្រោតុំ កណ៌ៅ ស្តះ ស ឝ្ឫណោតុ។ ");
INSERT INTO sankhm_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","ឯតេ វិទ្យមានជនាះ កៃ រ្មយោបមីយន្តេ? យេ ពាលកា ហដ្ដ ឧបវិឝ្យ ស្វំ ស្វំ ពន្ធុមាហូយ វទន្តិ, ");
INSERT INTO sankhm_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","វយំ យុឞ្មាកំ សមីបេ វំឝីរវាទយាម, កិន្តុ យូយំ នាន្ឫត្យត; យុឞ្មាកំ សមីបេ ច វយមរោទិម, កិន្តុ យូយំ ន វ្យលបត, តាទ្ឫឝៃ រ្ពាលកៃស្ត ឧបមាយិឞ្យន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","យតោ យោហន៑ អាគត្យ ន ភុក្តវាន៑ ន បីតវាំឝ្ច, តេន លោកា វទន្តិ, ស ភូតគ្រស្ត ឥតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","មនុជសុត អាគត្យ ភុក្តវាន៑ បីតវាំឝ្ច, តេន លោកា វទន្តិ, បឝ្យត ឯឞ ភោក្តា មទ្យបាតា ចណ្ឌាលបាបិនាំ ពន្ធឝ្ច, កិន្តុ ជ្ញានិនោ ជ្ញានវ្យវហារំ និទ៌ោឞំ ជានន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ស យត្រ យត្រ បុរេ ពហ្វាឝ្ចយ៌្យំ កម៌្ម ក្ឫតវាន៑, តន្និវាសិនាំ មនះបរាវ្ឫត្ត្យភាវាត៑ តានិ នគរាណិ ប្រតិ ហន្តេត្យុក្តា កថិតវាន៑, ");
INSERT INTO sankhm_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","ហា កោរាសីន៑, ហា ពៃត្សៃទេ, យុឞ្មន្មធ្យេ យទ្យទាឝ្ចយ៌្យំ កម៌្ម ក្ឫតំ យទិ តត៑ សោរសីទោន្នគរ អការិឞ្យត, តហ៌ិ បូវ៌្វមេវ តន្និវាសិនះ ឝាណវសនេ ភស្មនិ ចោបវិឝន្តោ មនាំសិ បរាវត៌្តិឞ្យន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","តស្មាទហំ យុឞ្មាន៑ វទាមិ, វិចារទិនេ យុឞ្មាកំ ទឝាតះ សោរសីទោនោ រ្ទឝា សហ្យតរា ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","អបរញ្ច ពត កផន៌ាហូម៑, ត្វំ ស្វគ៌ំ យាវទុន្នតោសិ, កិន្តុ នរកេ និក្ឞេប្ស្យសេ, យស្មាត៑ ត្វយិ យាន្យាឝ្ចយ៌្យាណិ កម៌្មណ្យការិឞត, យទិ តានិ សិទោម្នគរ អការិឞ្យន្ត, តហ៌ិ តទទ្យ យាវទស្ថាស្យត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","កិន្ត្វហំ យុឞ្មាន៑ វទាមិ, វិចារទិនេ តវ ទណ្ឌតះ សិទោមោ ទណ្ឌោ សហ្យតរោ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ឯតស្មិន្នេវ សមយេ យីឝុះ បុនរុវាច, ហេ ស្វគ៌ប្ឫថិវ្យោរេកាធិបតេ បិតស្ត្វំ ជ្ញានវតោ វិទុឞឝ្ច លោកាន៑ ប្រត្យេតានិ ន ប្រកាឝ្យ ពាលកាន៑ ប្រតិ ប្រកាឝិតវាន៑, ឥតិ ហេតោស្ត្វាំ ធន្យំ វទាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ហេ បិតះ, ឥត្ថំ ភវេត៑ យត ឥទំ ត្វទ្ឫឞ្ដាវុត្តមំ។ ");
INSERT INTO sankhm_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","បិត្រា មយិ សវ៌្វាណិ សមប៌ិតានិ, បិតរំ វិនា កោបិ បុត្រំ ន ជានាតិ, យាន៑ ប្រតិ បុត្រេណ បិតា ប្រកាឝ្យតេ តាន៑ វិនា បុត្រាទ៑ អន្យះ កោបិ បិតរំ ន ជានាតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","ហេ បរិឝ្រាន្តា ភារាក្រាន្តាឝ្ច លោកា យូយំ មត្សន្និធិម៑ អាគច្ឆត, អហំ យុឞ្មាន៑ វិឝ្រមយិឞ្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","អហំ ក្ឞមណឝីលោ នម្រមនាឝ្ច, តស្មាត៑ មម យុគំ ស្វេឞាមុបរិ ធារយត មត្តះ ឝិក្ឞធ្វញ្ច, តេន យូយំ ស្វេ ស្វេ មនសិ វិឝ្រាមំ លប្ស្យធ្ពេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","យតោ មម យុគម៑ អនាយាសំ មម ភារឝ្ច លឃុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","អនន្តរំ យីឝុ រ្វិឝ្រាមវារេ ឝ្ស្យមធ្យេន គច្ឆតិ, តទា តច្ឆិឞ្យា ពុភុក្ឞិតាះ សន្តះ ឝ្ស្យមញ្ជរីឝ្ឆត្វា ឆិត្វា ខាទិតុមារភន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","តទ៑ វិលោក្យ ផិរូឝិនោ យីឝុំ ជគទុះ, បឝ្យ វិឝ្រាមវារេ យត៑ កម៌្មាកត៌្តវ្យំ តទេវ តវ ឝិឞ្យាះ កុវ៌្វន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ស តាន៑ ប្រត្យាវទត, ទាយូទ៑ តត្សង្គិនឝ្ច ពុភុក្ឞិតាះ សន្តោ យត៑ កម៌្មាកុវ៌្វន៑ តត៑ កិំ យុឞ្មាភិ រ្នាបាឋិ? ");
INSERT INTO sankhm_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","យេ ទឝ៌នីយាះ បូបាះ យាជកាន៑ វិនា តស្យ តត្សង្គិមនុជានាញ្ចាភោជនីយាស្ត ឦឝ្វរាវាសំ ប្រវិឞ្ដេន តេន ភុក្តាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","អន្យច្ច វិឝ្រាមវារេ មធ្យេមន្ទិរំ វិឝ្រាមវារីយំ និយមំ លង្វន្តោបិ យាជកា និទ៌ោឞា ភវន្តិ, ឝាស្ត្រមធ្យេ កិមិទមបិ យុឞ្មាភិ រ្ន បឋិតំ? ");
INSERT INTO sankhm_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","យុឞ្មានហំ វទាមិ, អត្រ ស្ថានេ មន្ទិរាទបិ គរីយាន៑ ឯក អាស្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","កិន្តុ ទយាយាំ មេ យថា ប្រីតិ រ្ន តថា យជ្ញកម៌្មណិ។ ឯតទ្វចនស្យាត៌្ហំ យទិ យុយម៑ អជ្ញាសិឞ្ដ តហ៌ិ និទ៌ោឞាន៑ ទោឞិណោ នាកាឞ៌្ដ។ ");
INSERT INTO sankhm_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","អន្យច្ច មនុជសុតោ វិឝ្រាមវារស្យាបិ បតិរាស្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","អនន្តរំ ស តត្ស្ថានាត៑ ប្រស្ថាយ តេឞាំ ភជនភវនំ ប្រវិឞ្ដវាន៑, តទានីម៑ ឯកះ ឝុឞ្កករាមយវាន៑ ឧបស្ថិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","តតោ យីឝុម៑ អបវទិតុំ មានុឞាះ បប្រច្ឆុះ, វិឝ្រាមវារេ និរាមយត្វំ ករណីយំ ន វា? ");
INSERT INTO sankhm_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","តេន ស ប្រត្យុវាច, វិឝ្រាមវារេ យទិ កស្យចិទ៑ អវិ រ្គត៌្តេ បតតិ, តហ៌ិ យស្តំ ឃ្ឫត្វា ន តោលយតិ, ឯតាទ្ឫឝោ មនុជោ យុឞ្មាកំ មធ្យេ ក អាស្តេ? ");
INSERT INTO sankhm_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","អវេ រ្មានវះ កិំ នហិ ឝ្រេយាន៑? អតោ វិឝ្រាមវារេ ហិតកម៌្ម កត៌្តវ្យំ។ ");
INSERT INTO sankhm_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","អនន្តរំ ស តំ មានវំ គទិតវាន៑, ករំ ប្រសារយ; តេន ករេ ប្រសារិតេ សោន្យករវត៑ ស្វស្ថោៜភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","តទា ផិរូឝិនោ ពហិព៌្ហូយ កថំ តំ ហនិឞ្យាម ឥតិ កុមន្ត្រណាំ តត្ប្រាតិកូល្យេន ចក្រុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","តតោ យីឝុស្តទ៑ វិទិត្វា ស្ថនាន្តរំ គតវាន៑; អន្យេឞុ ពហុនរេឞុ តត្បឝ្ចាទ៑ គតេឞុ តាន៑ ស និរាមយាន៑ ក្ឫត្វា ឥត្យាជ្ញាបយត៑, ");
INSERT INTO sankhm_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","យូយំ មាំ ន បរិចាយយត។ ");
INSERT INTO sankhm_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","តស្មាត៑ មម ប្រីយោ មនោនីតោ មនសស្តុឞ្ដិការកះ។ មទីយះ សេវកោ យស្តុ វិទ្យតេ តំ សមីក្ឞតាំ។ តស្យោបរិ ស្វកីយាត្មា មយា សំស្ថាបយិឞ្យតេ។ តេនាន្យទេឝជាតេឞុ វ្យវស្ថា សំប្រកាឝ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","កេនាបិ ន វិរោធំ ស វិវាទញ្ច ករិឞ្យតិ។ ន ច រាជបថេ តេន វចនំ ឝ្រាវយិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","វ្យវស្ថា ចលិតា យាវត៑ នហិ តេន ករិឞ្យតេ។ តាវត៑ នលោ វិទីណ៌ោៜបិ ភំក្ឞ្យតេ នហិ តេន ច។ តថា សធូមវត៌្តិញ្ច ន ស និវ៌្វាបយិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ប្រត្យាឝាញ្ច ករិឞ្យន្តិ តន្នាម្និ ភិន្នទេឝជាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","យាន្យេតានិ វចនានិ យិឝយិយភវិឞ្យទ្វាទិនា ប្រោក្តាន្យាសន៑, តានិ សផលាន្យភវន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","អនន្តរំ លោកៃ ស្តត្សមីបម៑ អានីតោ ភូតគ្រស្តាន្ធមូកៃកមនុជស្តេន ស្វស្ថីក្ឫតះ, តតះ សោៜន្ធោ មូកោ ទ្រឞ្ដុំ វក្តុញ្ចារព្ធវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","អនេន សវ៌្វេ វិស្មិតាះ កថយាញ្ចក្រុះ, ឯឞះ កិំ ទាយូទះ សន្តានោ នហិ? ");
INSERT INTO sankhm_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","កិន្តុ ផិរូឝិនស្តត៑ ឝ្រុត្វា គទិតវន្តះ, ពាល្សិពូព្នាម្នោ ភូតរាជស្យ សាហាយ្យំ វិនា នាយំ ភូតាន៑ ត្យាជយតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","តទានីំ យីឝុស្តេឞាម៑ ឥតិ មានសំ វិជ្ញាយ តាន៑ អវទត៑ កិញ្ចន រាជ្យំ យទិ ស្វវិបក្ឞាទ៑ ភិទ្យតេ, តហ៌ិ តត៑ ឧច្ឆិទ្យតេ; យច្ច កិញ្ចន នគរំ វា គ្ឫហំ ស្វវិបក្ឞាទ៑ វិភិទ្យតេ, តត៑ ស្ថាតុំ ន ឝក្នោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","តទ្វត៑ ឝយតានោ យទិ ឝយតានំ ពហិះ ក្ឫត្វា ស្វវិបក្ឞាត៑ ប្ឫថក៑ ប្ឫថក៑ ភវតិ, តហ៌ិ តស្យ រាជ្យំ កេន ប្រការេណ ស្ថាស្យតិ? ");
INSERT INTO sankhm_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","អហញ្ច យទិ ពាល្សិពូពា ភូតាន៑ ត្យាជយាមិ, តហ៌ិ យុឞ្មាកំ សន្តានាះ កេន ភូតាន៑ ត្យាជយន្តិ? តស្មាទ៑ យុឞ្មាកម៑ ឯតទ្វិចារយិតារស្ត ឯវ ភវិឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","កិន្តវហំ យទីឝ្វរាត្មនា ភូតាន៑ ត្យាជយាមិ, តហ៌ីឝ្វរស្យ រាជ្យំ យុឞ្មាកំ សន្និធិមាគតវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","អន្យញ្ច កោបិ ពលវន្ត ជនំ ប្រថមតោ ន ពទ្វ្វា កេន ប្រការេណ តស្យ គ្ឫហំ ប្រវិឝ្យ តទ្ទ្រវ្យាទិ លោឋយិតុំ ឝក្នោតិ? កិន្តុ តត៑ ក្ឫត្វា តទីយគ្ឫស្យ ទ្រវ្យាទិ លោឋយិតុំ ឝក្នោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","យះ កឝ្ចិត៑ មម ស្វបក្ឞីយោ នហិ ស វិបក្ឞីយ អាស្តេ, យឝ្ច មយា សាកំ ន សំគ្ឫហ្លាតិ, ស វិកិរតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","អតឯវ យុឞ្មានហំ វទាមិ, មនុជានាំ សវ៌្វប្រការបាបានាំ និន្ទាយាឝ្ច មឞ៌ណំ ភវិតុំ ឝក្នោតិ, កិន្តុ បវិត្រស្យាត្មនោ វិរុទ្ធនិន្ទាយា មឞ៌ណំ ភវិតុំ ន ឝក្នោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","យោ មនុជសុតស្យ វិរុទ្ធាំ កថាំ កថយតិ, តស្យាបរាធស្យ ក្ឞមា ភវិតុំ ឝក្នោតិ, កិន្តុ យះ កឝ្ចិត៑ បវិត្រស្យាត្មនោ វិរុទ្ធាំ កថាំ កថយតិ នេហលោកេ ន ប្រេត្យ តស្យាបរាធស្យ ក្ឞមា ភវិតុំ ឝក្នោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","បាទបំ យទិ ភទ្រំ វទថ, តហ៌ិ តស្យ ផលមបិ សាធុ វក្តវ្យំ, យទិ ច បាទបំ អសាធុំ វទថ, តហ៌ិ តស្យ ផលមប្យសាធុ វក្តវ្យំ; យតះ ស្វីយស្វីយផលេន បាទបះ បរិចីយតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","រេ ភុជគវំឝា យូយមសាធវះ សន្តះ កថំ សាធុ វាក្យំ វក្តុំ ឝក្ឞ្យថ? យស្មាទ៑ អន្តះករណស្យ បូណ៌ភាវានុសារាទ៑ វទនាទ៑ វចោ និគ៌ច្ឆតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","តេន សាធុម៌ានវោៜន្តះករណរូបាត៑ សាធុភាណ្ឌាគារាត៑ សាធុ ទ្រវ្យំ និគ៌មយតិ, អសាធុម៌ានុឞស្ត្វសាធុភាណ្ឌាគារាទ៑ អសាធុវស្តូនិ និគ៌មយតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","កិន្ត្វហំ យុឞ្មាន៑ វទាមិ, មនុជា យាវន្ត្យាលស្យវចាំសិ វទន្តិ, វិចារទិនេ តទុត្តរមវឝ្យំ ទាតវ្យំ, ");
INSERT INTO sankhm_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","យតស្ត្វំ ស្វីយវចោភិ រ្និរបរាធះ ស្វីយវចោភិឝ្ច សាបរាធោ គណិឞ្យសេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","តទានីំ កតិបយា ឧបាធ្យាយាះ ផិរូឝិនឝ្ច ជគទុះ, ហេ គុរោ វយំ ភវត្តះ កិញ្ចន លក្ឞ្ម ទិទ្ឫក្ឞាមះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","តទា ស ប្រត្យុក្តវាន៑, ទុឞ្ដោ វ្យភិចារី ច វំឝោ លក្ឞ្ម ម្ឫគយតេ, កិន្តុ ភវិឞ្យទ្វាទិនោ យូនសោ លក្ឞ្ម វិហាយាន្យត៑ កិមបិ លក្ឞ្ម តេ ន ប្រទឝ៌យិឞ្យន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","យតោ យូនម៑ យថា ត្រ្យហោរាត្រំ ព្ឫហន្មីនស្យ កុក្ឞាវាសីត៑, តថា មនុជបុត្រោបិ ត្រ្យហោរាត្រំ មេទិន្យា មធ្យេ ស្ថាស្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","អបរំ នីនិវីយា មានវា វិចារទិន ឯតទ្វំឝីយានាំ ប្រតិកូលម៑ ឧត្ថាយ តាន៑ ទោឞិណះ ករិឞ្យន្តិ, យស្មាត្តេ យូនស ឧបទេឝាត៑ មនាំសិ បរាវត៌្តយាញ្ចក្រិរេ, កិន្ត្វត្រ យូនសោបិ គុរុតរ ឯក អាស្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","បុនឝ្ច ទក្ឞិណទេឝីយា រាជ្ញី វិចារទិន ឯតទ្វំឝីយានាំ ប្រតិកូលមុត្ថាយ តាន៑ ទោឞិណះ ករិឞ្យតិ យតះ សា រាជ្ញី សុលេមនោ វិទ្យាយាះ កថាំ ឝ្រោតុំ មេទិន្យាះ សីម្ន អាគច្ឆត៑, កិន្តុ សុលេមនោបិ គុរុតរ ឯកោ ជនោៜត្រ អាស្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","អបរំ មនុជាទ៑ ពហិគ៌តោ ៜបវិត្រភូតះ ឝុឞ្កស្ថានេន គត្វា វិឝ្រាមំ គវេឞយតិ, កិន្តុ តទលភមានះ ស វក្តិ, យស្មា; និកេតនាទ៑ អាគមំ, តទេវ វេឝ្ម បកាវ្ឫត្យ យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","បឝ្ចាត៑ ស តត៑ ស្ថានម៑ ឧបស្ថាយ តត៑ ឝូន្យំ មាជ៌្ជិតំ ឝោភិតញ្ច វិលោក្យ វ្រជន៑ ស្វតោបិ ទុឞ្ដតរាន៑ អន្យសប្តភូតាន៑ សង្គិនះ ករោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","តតស្តេ តត៑ ស្ថានំ ប្រវិឝ្យ និវសន្តិ, តេន តស្យ មនុជស្យ ឝេឞទឝា បូវ៌្វទឝាតោតីវាឝុភា ភវតិ, ឯតេឞាំ ទុឞ្ដវំឝ្យានាមបិ តថៃវ ឃដិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","មានវេភ្យ ឯតាសាំ កថនាំ កថនកាលេ តស្យ មាតា សហជាឝ្ច តេន សាកំ កាញ្ចិត៑ កថាំ កថយិតុំ វាញ្ឆន្តោ ពហិរេវ ស្ថិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","តតះ កឝ្ចិត៑ តស្មៃ កថិតវាន៑, បឝ្យ តវ ជននី សហជាឝ្ច ត្វយា សាកំ កាញ្ចន កថាំ កថយិតុំ កាមយមានា ពហិស្តិឞ្ឋន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","កិន្តុ ស តំ ប្រត្យវទត៑, មម កា ជននី? កេ វា មម សហជាះ? ");
INSERT INTO sankhm_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","បឝ្ចាត៑ ឝិឞ្យាន៑ ប្រតិ ករំ ប្រសាយ៌្យ កថិតវាន៑, បឝ្យ មម ជននី មម សហជាឝ្ចៃតេ; ");
INSERT INTO sankhm_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","យះ កឝ្ចិត៑ មម ស្វគ៌ស្ថស្យ បិតុរិឞ្ដំ កម៌្ម កុរុតេ, សឯវ មម ភ្រាតា ភគិនី ជននី ច។ ");
INSERT INTO sankhm_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","អបរញ្ច តស្មិន៑ ទិនេ យីឝុះ សទ្មនោ គត្វា សរិត្បតេ រោធសិ សមុបវិវេឝ។ ");
INSERT INTO sankhm_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","តត្រ តត្សន្និធៅ ពហុជនានាំ និវហោបស្ថិតេះ ស តរណិមារុហ្យ សមុបាវិឝត៑, តេន មានវា រោធសិ ស្ថិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","តទានីំ ស ទ្ឫឞ្ដាន្តៃស្តាន៑ ឥត្ថំ ពហុឝ ឧបទិឞ្ដវាន៑។ បឝ្យត, កឝ្ចិត៑ ក្ឫឞីវលោ ពីជានិ វប្តុំ ពហិជ៌គាម, ");
INSERT INTO sankhm_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","តស្យ វបនកាលេ កតិបយពីជេឞុ មាគ៌បាឝ៌្វេ បតិតេឞុ វិហគាស្តានិ ភក្ឞិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","អបរំ កតិបយពីជេឞុ ស្តោកម្ឫទ្យុក្តបាឞាណេ បតិតេឞុ ម្ឫទល្បត្វាត៑ តត្ក្ឞណាត៑ តាន្យង្កុរិតានិ, ");
INSERT INTO sankhm_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","កិន្តុ រវាវុទិតេ ទគ្ធានិ តេឞាំ មូលាប្រវិឞ្ដត្វាត៑ ឝុឞ្កតាំ គតានិ ច។ ");
INSERT INTO sankhm_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","អបរំ កតិបយពីជេឞុ កណ្ដកានាំ មធ្យេ បតិតេឞុ កណ្ដកាន្យេធិត្វា តានិ ជគ្រសុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","អបរញ្ច កតិបយពីជានិ ឧវ៌្វរាយាំ បតិតានិ; តេឞាំ មធ្យេ កានិចិត៑ ឝតគុណានិ កានិចិត៑ ឞឞ្ដិគុណានិ កានិចិត៑ ត្រិំឝគុំណានិ ផលានិ ផលិតវន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ឝ្រោតុំ យស្យ ឝ្រុតី អាសាតេ ស ឝ្ឫណុយាត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","អនន្តរំ ឝិឞ្យៃរាគត្យ សោៜប្ឫច្ឆ្យត, ភវតា តេភ្យះ កុតោ ទ្ឫឞ្ដាន្តកថា កថ្យតេ? ");
INSERT INTO sankhm_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","តតះ ស ប្រត្យវទត៑, ស្វគ៌រាជ្យស្យ និគូឍាំ កថាំ វេទិតុំ យុឞ្មភ្យំ សាមត៌្ហ្យមទាយិ, កិន្តុ តេភ្យោ នាទាយិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","យស្មាទ៑ យស្យាន្តិកេ វទ៌្ធតេ, តស្មាយេវ ទាយិឞ្យតេ, តស្មាត៑ តស្យ ពាហុល្យំ ភវិឞ្យតិ, កិន្តុ យស្យាន្តិកេ ន វទ៌្ធតេ, តស្យ យត៑ កិញ្ចនាស្តេ, តទបិ តស្មាទ៑ អាទាយិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","តេ បឝ្យន្តោបិ ន បឝ្យន្តិ, ឝ្ឫណ្វន្តោបិ ន ឝ្ឫណ្វន្តិ, ពុធ្យមានា អបិ ន ពុធ្យន្តេ ច, តស្មាត៑ តេភ្យោ ទ្ឫឞ្ដាន្តកថា កថ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","យថា កណ៌ៃះ ឝ្រោឞ្យថ យូយំ វៃ កិន្តុ យូយំ ន ភោត្ស្យថ។ នេត្រៃទ៌្រក្ឞ្យថ យូយញ្ច បរិជ្ញាតុំ ន ឝក្ឞ្យថ។ តេ មានុឞា យថា នៃវ បរិបឝ្យន្តិ លោចនៃះ។ កណ៌ៃ រ្យថា ន ឝ្ឫណ្វន្តិ ន ពុធ្យន្តេ ច មានសៃះ។ វ្យាវត៌្តិតេឞុ ចិត្តេឞុ កាលេ កុត្រាបិ តៃជ៌នៃះ។ មត្តស្តេ មនុជាះ ស្វស្ថា យថា នៃវ ភវន្តិ ច។ តថា តេឞាំ មនុឞ្យាណាំ ក្រិយន្តេ ស្ថូលពុទ្ធយះ។ ពធិរីភូតកណ៌ាឝ្ច ជាតាឝ្ច មុទ្រិតា ទ្ឫឝះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","យទេតានិ វចនានិ យិឝយិយភវិឞ្យទ្វាទិនា ប្រោក្តានិ តេឞុ តានិ ផលន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","កិន្តុ យុឞ្មាកំ នយនានិ ធន្យានិ, យស្មាត៑ តានិ វីក្ឞន្តេ; ធន្យាឝ្ច យុឞ្មាកំ ឝព្ទគ្រហាះ, យស្មាត៑ តៃរាកណ៌្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","មយា យូយំ តថ្យំ វចាមិ យុឞ្មាភិ រ្យទ្យទ៑ វីក្ឞ្យតេ, តទ៑ ពហវោ ភវិឞ្យទ្វាទិនោ ធាម៌្មិកាឝ្ច មានវា ទិទ្ឫក្ឞន្តោបិ ទ្រឞ្ដុំ នាលភន្ត, បុនឝ្ច យូយំ យទ្យត៑ ឝ្ឫណុថ, តត៑ តេ ឝុឝ្រូឞមាណា អបិ ឝ្រោតុំ នាលភន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","ក្ឫឞីវលីយទ្ឫឞ្ដាន្តស្យាត៌្ហំ ឝ្ឫណុត។ ");
INSERT INTO sankhm_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","មាគ៌បាឝ៌្វេ ពីជាន្យុប្តានិ តស្យាត៌្ហ ឯឞះ, យទា កឝ្ចិត៑ រាជ្យស្យ កថាំ និឝម្យ ន ពុធ្យតេ, តទា បាបាត្មាគត្យ តទីយមនស ឧប្តាំ កថាំ ហរន៑ នយតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","អបរំ បាឞាណស្ថលេ ពីជាន្យុប្តានិ តស្យាត៌្ហ ឯឞះ; កឝ្ចិត៑ កថាំ ឝ្រុត្វៃវ ហឞ៌ចិត្តេន គ្ឫហ្លាតិ, ");
INSERT INTO sankhm_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","កិន្តុ តស្យ មនសិ មូលាប្រវិឞ្ដត្វាត៑ ស កិញ្ចិត្កាលមាត្រំ ស្ថិរស្តិឞ្ឋតិ; បឝ្ចាត តត្កថាការណាត៑ កោបិ ក្លេស្តាឌនា វា ចេត៑ ជាយតេ, តហ៌ិ ស តត្ក្ឞណាទ៑ វិឃ្នមេតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","អបរំ កណ្ដកានាំ មធ្យេ ពីជាន្យុប្តានិ តទត៌្ហ ឯឞះ; កេនចិត៑ កថាយាំ ឝ្រុតាយាំ សាំសារិកចិន្តាភិ រ្ភ្រាន្តិភិឝ្ច សា គ្រស្យតេ, តេន សា មា វិផលា ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","អបរម៑ ឧវ៌្វរាយាំ ពីជាន្យុប្តានិ តទត៌្ហ ឯឞះ; យេ តាំ កថាំ ឝ្រុត្វា វុធ្យន្តេ, តេ ផលិតាះ សន្តះ កេចិត៑ ឝតគុណានិ កេចិត ឞឞ្ដិគុណានិ កេចិច្ច ត្រិំឝទ្គុណានិ ផលានិ ជនយន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","អនន្តរំ សោបរាមេកាំ ទ្ឫឞ្ដាន្តកថាមុបស្ថាប្យ តេភ្យះ កថយាមាស; ស្វគ៌ីយរាជ្យំ តាទ្ឫឝេន កេនចិទ៑ គ្ឫហស្ថេនោបមីយតេ, យេន ស្វីយក្ឞេត្រេ ប្រឝស្តពីជាន្យៅប្យន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","កិន្តុ ក្ឞណទាយាំ សកលលោកេឞុ សុប្តេឞុ តស្យ រិបុរាគត្យ តេឞាំ គោធូមពីជានាំ មធ្យេ វន្យយវមពីជាន្យុប្ត្វា វវ្រាជ។ ");
INSERT INTO sankhm_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","តតោ យទា ពីជេភ្យោៜង្ករា ជាយមានាះ កណិឝានិ ឃ្ឫតវន្តះ; តទា វន្យយវសាន្យបិ ទ្ឫឝ្យមានាន្យភវន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","តតោ គ្ឫហស្ថស្យ ទាសេយា អាគម្យ តស្មៃ កថយាញ្ចក្រុះ, ហេ មហេច្ឆ, ភវតា កិំ ក្ឞេត្រេ ភទ្រពីជានិ នៅប្យន្ត? តថាត្វេ វន្យយវសានិ ក្ឫត អាយន៑? ");
INSERT INTO sankhm_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","តទានីំ តេន តេ ប្រតិគទិតាះ, កេនចិត៑ រិបុណា កម៌្មទមការិ។ ទាសេយាះ កថយាមាសុះ, វយំ គត្វា តាន្យុត្បាយ្យ ក្ឞិបាមោ ភវតះ កីទ្ឫឝីច្ឆា ជាយតេ? ");
INSERT INTO sankhm_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","តេនាវាទិ, នហិ, ឝង្កេៜហំ វន្យយវសោត្បាដនកាលេ យុឞ្មាភិស្តៃះ សាកំ គោធូមា អប្យុត្បាដិឞ្យន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","អតះ ឝ្ស្យកត៌្តនកាលំ យាវទ៑ ឧភយាន្យបិ សហ វទ៌្ធន្តាំ, បឝ្ចាត៑ កត៌្តនកាលេ កត៌្តកាន៑ វក្ឞ្យាមិ, យូយមាទៅ វន្យយវសានិ សំគ្ឫហ្យ ទាហយិតុំ វីដិកា ពទ្វ្វា ស្ថាបយត; កិន្តុ សវ៌្វេ គោធូមា យុឞ្មាភិ រ្ភាណ្ឌាគារំ នីត្វា ស្ថាប្យន្តាម៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","អនន្តរំ សោបរាមេកាំ ទ្ឫឞ្ដាន្តកថាមុត្ថាប្យ តេភ្យះ កថិតវាន៑ កឝ្ចិន្មនុជះ សឞ៌បពីជមេកំ នីត្វា ស្វក្ឞេត្រ ឧវាប។ ");
INSERT INTO sankhm_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","សឞ៌បពីជំ សវ៌្វស្មាទ៑ ពីជាត៑ ក្ឞុទ្រមបិ សទង្កុរិតំ សវ៌្វស្មាត៑ ឝាកាត៑ ព្ឫហទ៑ ភវតិ; ស តាទ្ឫឝស្តរុ រ្ភវតិ, យស្យ ឝាខាសុ នភសះ ខគា អាគត្យ និវសន្តិ; ស្វគ៌ីយរាជ្យំ តាទ្ឫឝស្យ សឞ៌បៃកស្យ សមម៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","បុនរបិ ស ឧបមាកថាមេកាំ តេភ្យះ កថយាញ្ចការ; កាចន យោឞិត៑ យត៑ កិណ្វមាទាយ ទ្រោណត្រយមិតគោធូមចូណ៌ានាំ មធ្យេ សវ៌្វេឞាំ មិឝ្រីភវនបយ៌្យន្តំ សមាច្ឆាទ្យ និធត្តវតី, តត្កិណ្វមិវ ស្វគ៌រាជ្យំ។ ");
INSERT INTO sankhm_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ឥត្ថំ យីឝុ រ្មនុជនិវហានាំ សន្និធាវុបមាកថាភិរេតាន្យាខ្យានានិ កថិតវាន៑ ឧបមាំ វិនា តេភ្យះ កិមបិ កថាំ នាកថយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ឯតេន ទ្ឫឞ្ដាន្តីយេន វាក្យេន វ្យាទាយ វទនំ និជំ។ អហំ ប្រកាឝយិឞ្យាមិ គុប្តវាក្យំ បុរាភវំ។ យទេតទ្វចនំ ភវិឞ្យទ្វាទិនា ប្រោក្តមាសីត៑, តត៑ សិទ្ធមភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","សវ៌្វាន៑ មនុជាន៑ វិស្ឫជ្យ យីឝៅ គ្ឫហំ ប្រវិឞ្ដេ តច្ឆិឞ្យា អាគត្យ យីឝវេ កថិតវន្តះ, ក្ឞេត្រស្យ វន្យយវសីយទ្ឫឞ្ដាន្តកថាម៑ ភវាន អស្មាន៑ ស្បឞ្ដីក្ឫត្យ វទតុ។ ");
INSERT INTO sankhm_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","តតះ ស ប្រត្យុវាច, យេន ភទ្រពីជាន្យុប្យន្តេ ស មនុជបុត្រះ, ");
INSERT INTO sankhm_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ក្ឞេត្រំ ជគត៑, ភទ្រពីជានី រាជ្យស្យ សន្តានាះ, ");
INSERT INTO sankhm_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","វន្យយវសានិ បាបាត្មនះ សន្តានាះ។ យេន រិបុណា តាន្យុប្តានិ ស ឝយតានះ, កត៌្តនសមយឝ្ច ជគតះ ឝេឞះ, កត៌្តកាះ ស្វគ៌ីយទូតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","យថា វន្យយវសានិ សំគ្ឫហ្យ ទាហ្យន្តេ, តថា ជគតះ ឝេឞេ ភវិឞ្យតិ; ");
INSERT INTO sankhm_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","អត៌្ហាត៑ មនុជសុតះ ស្វាំយទូតាន៑ ប្រេឞយិឞ្យតិ, តេន តេ ច តស្យ រាជ្យាត៑ សវ៌្វាន៑ វិឃ្នការិណោៜធាម៌្មិកលោកាំឝ្ច សំគ្ឫហ្យ ");
INSERT INTO sankhm_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","យត្រ រោទនំ ទន្តឃឞ៌ណញ្ច ភវតិ, តត្រាគ្និកុណ្ឌេ និក្ឞេប្ស្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","តទានីំ ធាម៌្មិកលោកាះ ស្វេឞាំ បិតូ រាជ្យេ ភាស្ករឥវ តេជស្វិនោ ភវិឞ្យន្តិ។ ឝ្រោតុំ យស្យ ឝ្រុតី អាសាតេ, ម ឝ្ឫណុយាត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","អបរញ្ច ក្ឞេត្រមធ្យេ និធិំ បឝ្យន៑ យោ គោបយតិ, តតះ បរំ សានន្ទោ គត្វា ស្វីយសវ៌្វស្វំ វិក្រីយ ត្តក្ឞេត្រំ ក្រីណាតិ, ស ឥវ ស្វគ៌រាជ្យំ។ ");
INSERT INTO sankhm_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","អន្យញ្ច យោ វណិក៑ ឧត្តមាំ មុក្តាំ គវេឞយន្ ");
INSERT INTO sankhm_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","មហាគ៌្ហាំ មុក្តាំ វិលោក្យ និជសវ៌្វស្វំ វិក្រីយ តាំ ក្រីណាតិ, ស ឥវ ស្វគ៌រាជ្យំ។ ");
INSERT INTO sankhm_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","បុនឝ្ច សមុទ្រោ និក្ឞិប្តះ សវ៌្វប្រការមីនសំគ្រាហ្យានាយឥវ ស្វគ៌រាជ្យំ។ ");
INSERT INTO sankhm_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","តស្មិន៑ អានាយេ បូណ៌េ ជនា យថា រោធស្យុត្តោល្យ សមុបវិឝ្យ ប្រឝស្តមីនាន៑ សំគ្រហ្យ ភាជនេឞុ និទធតេ, កុត្សិតាន៑ និក្ឞិបន្តិ; ");
INSERT INTO sankhm_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","តថៃវ ជគតះ ឝេឞេ ភវិឞ្យតិ, ផលតះ ស្វគ៌ីយទូតា អាគត្យ បុណ្យវជ្ជនានាំ មធ្យាត៑ បាបិនះ ប្ឫថក៑ ក្ឫត្វា វហ្និកុណ្ឌេ និក្ឞេប្ស្យន្តិ, ");
INSERT INTO sankhm_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","តត្រ រោទនំ ទន្តៃ រ្ទន្តឃឞ៌ណញ្ច ភវិឞ្យតះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","យីឝុនា តេ ប្ឫឞ្ដា យុឞ្មាភិះ កិមេតាន្យាខ្យានាន្យពុធ្យន្ត? តទា តេ ប្រត្យវទន៑, សត្យំ ប្រភោ។ ");
INSERT INTO sankhm_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","តទានីំ ស កថិតវាន៑, និជភាណ្ឌាគារាត៑ នវីនបុរាតនានិ វស្តូនិ និគ៌មយតិ យោ គ្ឫហស្ថះ ស ឥវ ស្វគ៌រាជ្យមធិ ឝិក្ឞិតាះ ស្វវ៌ ឧបទេឞ្ដារះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","អនន្តរំ យីឝុរេតាះ សវ៌្វា ទ្ឫឞ្ដាន្តកថាះ សមាប្យ តស្មាត៑ ស្ថានាត៑ ប្រតស្ថេ។ អបរំ ស្វទេឝមាគត្យ ជនាន៑ ភជនភវន ឧបទិឞ្ដវាន៑; ");
INSERT INTO sankhm_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","តេ វិស្មយំ គត្វា កថិតវន្ត ឯតស្យៃតាទ្ឫឝំ ជ្ញានម៑ អាឝ្ចយ៌្យំ កម៌្ម ច កស្មាទ៑ អជាយត? ");
INSERT INTO sankhm_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","កិមយំ សូត្រធារស្យ បុត្រោ នហិ? ឯតស្យ មាតុ រ្នាម ច កិំ មរិយម៑ នហិ? យាកុព៑-យូឞផ៑-ឝិមោន៑-យិហូទាឝ្ច កិមេតស្យ ភ្រាតរោ នហិ? ");
INSERT INTO sankhm_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ឯតស្យ ភគិន្យឝ្ច កិមស្មាកំ មធ្យេ ន សន្តិ? តហ៌ិ កស្មាទយមេតានិ លព្ធវាន៑? ឥត្ថំ ស តេឞាំ វិឃ្នរូបោ ពភូវ; ");
INSERT INTO sankhm_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","តតោ យីឝុនា និគទិតំ ស្វទេឝីយជនានាំ មធ្យំ វិនា ភវិឞ្យទ្វាទី កុត្រាប្យន្យត្រ នាសម្មាន្យោ ភវតី។ ");
INSERT INTO sankhm_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","តេឞាមវិឝ្វាសហេតោះ ស តត្រ ស្ថានេ ពហ្វាឝ្ចយ៌្យកម៌្មាណិ ន ក្ឫតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","តទានីំ រាជា ហេរោទ៑ យីឝោ រ្យឝះ ឝ្រុត្វា និជទាសេយាន៑ ជគាទ៑, ");
INSERT INTO sankhm_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ឯឞ មជ្ជយិតា យោហន៑, ប្រមិតេភយស្តស្យោត្ថានាត៑ តេនេត្ថមទ្ភុតំ កម៌្ម ប្រកាឝ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","បុរា ហេរោទ៑ និជភ្រាតុ: ផិលិបោ ជាយាយា ហេរោទីយាយា អនុរោធាទ៑ យោហនំ ធារយិត្វា ពទ្ធា ការាយាំ ស្ថាបិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","យតោ យោហន៑ ឧក្តវាន៑, ឯត្សយាះ សំគ្រហោ ភវតោ នោចិតះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","តស្មាត៑ ន្ឫបតិស្តំ ហន្តុមិច្ឆន្នបិ លោកេភ្យោ វិភយាញ្ចការ; យតះ សវ៌្វេ យោហនំ ភវិឞ្យទ្វាទិនំ មេនិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","កិន្តុ ហេរោទោ ជន្មាហីយមហ ឧបស្ថិតេ ហេរោទីយាយា ទុហិតា តេឞាំ សមក្ឞំ ន្ឫតិត្វា ហេរោទមប្រីណ្យត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","តស្មាត៑ ភូបតិះ ឝបថំ កុវ៌្វន៑ ឥតិ ប្រត្យជ្ញាសីត៑, ត្វយា យទ៑ យាច្យតេ, តទេវាហំ ទាស្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","សា កុមារី ស្វីយមាតុះ ឝិក្ឞាំ លព្ធា ពភាឞេ, មជ្ជយិតុយ៌ោហន ឧត្តមាង្គំ ភាជនេ សមានីយ មហ្យំ វិឝ្រាណយ។ ");
INSERT INTO sankhm_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","តតោ រាជា ឝុឝោច, កិន្តុ ភោជនាយោបវិឝតាំ សង្គិនាំ ស្វក្ឫតឝបថស្យ ចានុរោធាត៑ តត៑ ប្រទាតុម អាទិទេឝ។ ");
INSERT INTO sankhm_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","បឝ្ចាត៑ ការាំ ប្រតិ នរំ ប្រហិត្យ យោហន ឧត្តមាង្គំ ឆិត្ត្វា ");
INSERT INTO sankhm_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","តត៑ ភាជន អានាយ្យ តស្យៃ កុមាយ៌្យៃ វ្យឝ្រាណយត៑, តតះ សា ស្វជនន្យាះ សមីបំ តន្និនាយ។ ");
INSERT INTO sankhm_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","បឝ្ចាត៑ យោហនះ ឝិឞ្យា អាគត្យ កាយំ នីត្វា ឝ្មឝានេ ស្ថាបយាមាសុស្តតោ យីឝោះ សន្និធិំ វ្រជិត្វា តទ្វាត៌្តាំ ពភាឞិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","អនន្តរំ យីឝុរិតិ និឝភ្យ នាវា និជ៌នស្ថានម៑ ឯកាកី គតវាន៑, បឝ្ចាត៑ មានវាស្តត៑ ឝ្រុត្វា នានានគរេភ្យ អាគត្យ បទៃស្តត្បឝ្ចាទ៑ ឦយុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","តទានីំ យីឝុ រ្ពហិរាគត្យ មហាន្តំ ជននិវហំ និរីក្ឞ្យ តេឞុ ការុណិកះ មន៑ តេឞាំ បីឌិតជនាន៑ និរាមយាន៑ ចការ។ ");
INSERT INTO sankhm_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","តតះ បរំ សន្ធ្យាយាំ ឝិឞ្យាស្តទន្តិកមាគត្យ កថយាញ្ចក្រុះ, ឥទំ និជ៌នស្ថានំ វេលាប្យវសន្នា; តស្មាត៑ មនុជាន៑ ស្វស្វគ្រាមំ គន្តុំ ស្វាត៌្ហំ ភក្ឞ្យាណិ ក្រេតុញ្ច ភវាន៑ តាន៑ វិស្ឫជតុ។ ");
INSERT INTO sankhm_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","កិន្តុ យីឝុស្តានវាទីត៑, តេឞាំ គមនេ ប្រយោជនំ នាស្តិ, យូយមេវ តាន៑ ភោជយត។ ");
INSERT INTO sankhm_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","តទា តេ ប្រត្យវទន៑, អស្មាកមត្រ បូបបញ្ចកំ មីនទ្វយញ្ចាស្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","តទានីំ តេនោក្តំ តានិ មទន្តិកមានយត។ ");
INSERT INTO sankhm_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","អនន្តរំ ស មនុជាន៑ យវសោបយ៌្យុបវេឞ្ដុម៑ អាជ្ញាបយាមាស; អបរ តត៑ បូបបញ្ចកំ មីនទ្វយញ្ច គ្ឫហ្លន៑ ស្វគ៌ំ ប្រតិ និរីក្ឞ្យេឝ្វរីយគុណាន៑ អនូទ្យ ភំក្ត្វា ឝិឞ្យេភ្យោ ទត្តវាន៑, ឝិឞ្យាឝ្ច លោកេភ្យោ ទទុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","តតះ សវ៌្វេ ភុក្ត្វា បរិត្ឫប្តវន្តះ, តតស្តទវឝិឞ្ដភក្ឞ្យៃះ បូណ៌ាន៑ ទ្វាទឝឌលកាន៑ គ្ឫហីតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","តេ ភោក្តារះ ស្ត្រីព៌ាលកាំឝ្ច វិហាយ ប្រាយេណ បញ្ច សហស្រាណិ បុមាំស អាសន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","តទនន្តរំ យីឝុ រ្លោកានាំ វិសជ៌នកាលេ ឝិឞ្យាន៑ តរណិមារោឍុំ ស្វាគ្រេ បារំ យាតុញ្ច គាឍមាទិឞ្ដវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","តតោ លោកេឞុ វិស្ឫឞ្ដេឞុ ស វិវិក្តេ ប្រាត៌្ហយិតុំ គិរិមេកំ គត្វា សន្ធ្យាំ យាវត៑ តត្រៃកាកី ស្ថិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","កិន្តុ តទានីំ សម្មុខវាតត្វាត៑ សរិត្បតេ រ្មធ្យេ តរង្គៃស្តរណិទ៌ោលាយមានាភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","តទា ស យាមិន្យាឝ្ចតុត៌្ហប្រហរេ បទ្ភ្យាំ វ្រជន៑ តេឞាមន្តិកំ គតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","កិន្តុ ឝិឞ្យាស្តំ សាគរោបរិ វ្រជន្តំ វិលោក្យ សមុទ្វិគ្នា ជគទុះ, ឯឞ ភូត ឥតិ ឝង្កមានា ឧច្ចៃះ ឝព្ទាយាញ្ចក្រិរេ ច។ ");
INSERT INTO sankhm_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","តទៃវ យីឝុស្តានវទត៑, សុស្ថិរា ភវត, មា ភៃឞ្ដ, ឯឞោៜហម៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","តតះ បិតរ ឥត្យុក្តវាន៑, ហេ ប្រភោ, យទិ ភវានេវ, តហ៌ិ មាំ ភវត្សមីបំ យាតុមាជ្ញាបយតុ។ ");
INSERT INTO sankhm_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","តតះ តេនាទិឞ្ដះ បិតរស្តរណិតោៜវរុហ្យ យីឝេाរន្តិកំ ប្រាប្តុំ តោយោបរិ វវ្រាជ។ ");
INSERT INTO sankhm_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","កិន្តុ ប្រចណ្ឌំ បវនំ វិលោក្យ ភយាត៑ តោយេ មំក្តុម៑ អារេភេ, តស្មាទ៑ ឧច្ចៃះ ឝព្ទាយមានះ កថិតវាន៑, ហេ ប្រភោ, មាមវតុ។ ");
INSERT INTO sankhm_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","យីឝុស្តត្ក្ឞណាត៑ ករំ ប្រសាយ៌្យ តំ ធរន៑ ឧក្តវាន៑, ហ ស្តោកប្រត្យយិន៑ ត្វំ កុតះ សមឝេថាះ? ");
INSERT INTO sankhm_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","អនន្តរំ តយោស្តរណិមារូឍយោះ បវនោ និវវ្ឫតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","តទានីំ យេ តរណ្យាមាសន៑, ត អាគត្យ តំ ប្រណភ្យ កថិតវន្តះ, យថាត៌្ហស្ត្វមេវេឝ្វរសុតះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","អនន្តរំ បារំ ប្រាប្យ តេ គិនេឞរន្នាមកំ នគរមុបតស្ថុះ, ");
INSERT INTO sankhm_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","តទា តត្រត្យា ជនា យីឝុំ បរិចីយ តទ្ទេឝ្ស្យ ចតុទ៌ិឝោ វាត៌្តាំ ប្រហិត្យ យត្រ យាវន្តះ បីឌិតា អាសន៑, តាវតឯវ តទន្តិកមានយាមាសុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","អបរំ តទីយវសនស្យ គ្រន្ថិមាត្រំ ស្ប្រឞ្ដុំ វិនីយ យាវន្តោ ជនាស្តត៑ ស្បឝ៌ំ ចក្រិរេ, តេ សវ៌្វឯវ និរាមយា ពភូវុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","អបរំ យិរូឝាលម្នគរីយាះ កតិបយា អធ្យាបកាះ ផិរូឝិនឝ្ច យីឝោះ សមីបមាគត្យ កថយាមាសុះ, ");
INSERT INTO sankhm_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","តវ ឝិឞ្យាះ កិមត៌្ហម៑ អប្រក្ឞាលិតករៃ រ្ភក្ឞិត្វា បរម្បរាគតំ ប្រាចីនានាំ វ្យវហារំ លង្វន្តេ? ");
INSERT INTO sankhm_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","តតោ យីឝុះ ប្រត្យុវាច, យូយំ បរម្បរាគតាចារេណ កុត ឦឝ្វរាជ្ញាំ លង្វធ្វេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ឦឝ្វរ ឥត្យាជ្ញាបយត៑, ត្វំ និជបិតរៅ សំមន្យេថាះ, យេន ច និជបិតរៅ និន្ទ្យេតេ, ស និឝ្ចិតំ ម្រិយេត; ");
INSERT INTO sankhm_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","កិន្តុ យូយំ វទថ, យះ ស្វជនកំ ស្វជននីំ វា វាក្យមិទំ វទតិ, យុវាំ មត្តោ យល្លភេថេ, តត៑ ន្យវិទ្យត, ");
INSERT INTO sankhm_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ស និជបិតរៅ បុន រ្ន សំមំស្យតេ។ ឥត្ថំ យូយំ បរម្បរាគតេន ស្វេឞាមាចារេណេឝ្វរីយាជ្ញាំ លុម្បថ។ ");
INSERT INTO sankhm_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","រេ កបដិនះ សវ៌្វេ យិឝយិយោ យុឞ្មានធិ ភវិឞ្យទ្វចនាន្យេតានិ សម្យគ៑ ឧក្តវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","វទនៃ រ្មនុជា ឯតេ សមាយាន្តិ មទន្តិកំ។ តថាធរៃ រ្មទីយញ្ច មានំ កុវ៌្វន្តិ តេ នរាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","កិន្តុ តេឞាំ មនោ មត្តោ វិទូរឯវ តិឞ្ឋតិ។ ឝិក្ឞយន្តោ វិធីន៑ ន្រាជ្ញា ភជន្តេ មាំ មុធៃវ តេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","តតោ យីឝុ រ្លោកាន៑ អាហូយ ប្រោក្តវាន៑, យូយំ ឝ្រុត្វា ពុធ្យធ្ពំ។ ");
INSERT INTO sankhm_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","យន្មុខំ ប្រវិឝតិ, តត៑ មនុជម៑ អមេធ្យំ ន ករោតិ, កិន្តុ យទាស្យាត៑ និគ៌ច្ឆតិ, តទេវ មានុឞមមេធ្យី ករោតី។ ");
INSERT INTO sankhm_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","តទានីំ ឝិឞ្យា អាគត្យ តស្មៃ កថយាញ្ចក្រុះ, ឯតាំ កថាំ ឝ្រុត្វា ផិរូឝិនោ វ្យរជ្យន្ត, តត៑ កិំ ភវតា ជ្ញាយតេ? ");
INSERT INTO sankhm_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ស ប្រត្យវទត៑, មម ស្វគ៌ស្ថះ បិតា យំ កញ្ចិទង្កុរំ នារោបយត៑, ស ឧត្បាវ្ទ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","តេ តិឞ្ឋន្តុ, តេ អន្ធមនុជានាម៑ អន្ធមាគ៌ទឝ៌កា ឯវ; យទ្យន្ធោៜន្ធំ បន្ថានំ ទឝ៌យតិ, តហ៌្យុភៅ គត៌្តេ បតតះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","តទា បិតរស្តំ ប្រត្យវទត៑, ទ្ឫឞ្ដាន្តមិមមស្មាន៑ ពោធយតុ។ ");
INSERT INTO sankhm_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","យីឝុនា ប្រោក្តំ, យូយមទ្យ យាវត៑ កិមពោធាះ ស្ថ? ");
INSERT INTO sankhm_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","កថាមិមាំ កិំ ន ពុធ្យធ្ពេ ? យទាស្យំ ប្រេវិឝតិ, តទ៑ ឧទរេ បតន៑ ពហិន៌ិយ៌ាតិ, ");
INSERT INTO sankhm_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","កិន្ត្វាស្យាទ៑ យន្និយ៌ាតិ, តទ៑ អន្តះករណាត៑ និយ៌ាតត្វាត៑ មនុជមមេធ្យំ ករោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","យតោៜន្តះករណាត៑ កុចិន្តា ពធះ បារទារិកតា វេឝ្យាគមនំ ចៃយ៌្យំ មិថ្យាសាក្ឞ្យម៑ ឦឝ្វរនិន្ទា ចៃតានិ សវ៌្វាណិ និយ៌្យាន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ឯតានិ មនុឞ្យមបវិត្រី កុវ៌្វន្តិ កិន្ត្វប្រក្ឞាលិតករេណ ភោជនំ មនុជមមេធ្យំ ន ករោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","អនន្តរំ យីឝុស្តស្មាត៑ ស្ថានាត៑ ប្រស្ថាយ សោរសីទោន្នគរយោះ សីមាមុបតស្យៅ។ ");
INSERT INTO sankhm_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","តទា តត្សីមាតះ កាចិត៑ កិនានីយា យោឞិទ៑ អាគត្យ តមុច្ចៃរុវាច, ហេ ប្រភោ ទាយូទះ សន្តាន, មមៃកា ទុហិតាស្តេ សា ភូតគ្រស្តា សតី មហាក្លេឝំ ប្រាប្នោតិ មម ទយស្វ។ ");
INSERT INTO sankhm_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","កិន្តុ យីឝុស្តាំ កិមបិ នោក្តវាន៑, តតះ ឝិឞ្យា អាគត្យ តំ និវេទយាមាសុះ, ឯឞា យោឞិទ៑ អស្មាកំ បឝ្ចាទ៑ ឧច្ចៃរាហូយាគច្ឆតិ, ឯនាំ វិស្ឫជតុ។ ");
INSERT INTO sankhm_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","តទា ស ប្រត្យវទត៑, ឥស្រាយេល្គោត្រស្យ ហារិតមេឞាន៑ វិនា កស្យាប្យន្យស្យ សមីបំ នាហំ ប្រេឞិតោស្មិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","តតះ សា នារីសមាគត្យ តំ ប្រណម្យ ជគាទ, ហេ ប្រភោ មាមុបកុរុ។ ");
INSERT INTO sankhm_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ស ឧក្តវាន៑, ពាលកានាំ ភក្ឞ្យមាទាយ សារមេយេភ្យោ ទានំ នោចិតំ។ ");
INSERT INTO sankhm_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","តទា សា ពភាឞេ, ហេ ប្រភោ, តត៑ សត្យំ, តថាបិ ប្រភោ រ្ភញ្ចាទ៑ យទុច្ឆិឞ្ដំ បតតិ, តត៑ សារមេយាះ ខាទន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","តតោ យីឝុះ ប្រត្យវទត៑, ហេ យោឞិត៑, តវ វិឝ្វាសោ មហាន៑ តស្មាត៑ តវ មនោភិលឞិតំ សិទ្យ្យតុ, តេន តស្យាះ កន្យា តស្មិន្នេវ ទណ្ឌេ និរាមយាភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","អនន្តរំ យីឝស្តស្មាត៑ ស្ថានាត៑ ប្រស្ថាយ គាលីល្សាគរស្យ សន្និធិមាគត្យ ធរាធរមារុហ្យ តត្រោបវិវេឝ។ ");
INSERT INTO sankhm_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","បឝ្ចាត៑ ជននិវហោ ពហូន៑ ខញ្ចាន្ធមូកឝុឞ្កករមានុឞាន៑ អាទាយ យីឝោះ សមីបមាគត្យ តច្ចរណាន្តិកេ ស្ថាបយាមាសុះ, តតះ សា តាន៑ និរាមយាន៑ អករោត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ឥត្ថំ មូកា វាក្យំ វទន្តិ, ឝុឞ្កករាះ ស្វាស្ថ្យមាយាន្តិ, បង្គវោ គច្ឆន្តិ, អន្ធា វីក្ឞន្តេ, ឥតិ វិលោក្យ លោកា វិស្មយំ មន្យមានា ឥស្រាយេល ឦឝ្វរំ ធន្យំ ពភាឞិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","តទានីំ យីឝុះ ស្វឝិឞ្យាន៑ អាហូយ គទិតវាន៑, ឯតជ្ជននិវហេឞុ មម ទយា ជាយតេ, ឯតេ ទិនត្រយំ មយា សាកំ សន្តិ, ឯឞាំ ភក្ឞ្យវស្តុ ច កញ្ចិទបិ នាស្តិ, តស្មាទហមេតានក្ឫតាហារាន៑ ន វិស្រក្ឞ្យាមិ, តថាត្វេ វត៌្មមធ្យេ ក្លាម្យេឞុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","តទា ឝិឞ្យា ឩចុះ, ឯតស្មិន៑ ប្រាន្តរមធ្យ ឯតាវតោ មត៌្យាន៑ តប៌យិតុំ វយំ កុត្រ បូបាន៑ ប្រាប្ស្យាមះ? ");
INSERT INTO sankhm_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","យីឝុរប្ឫច្ឆត៑, យុឞ្មាកំ និកដេ កតិ បូបា អាសតេ? ត ឩចុះ, សប្តបូបា អល្បាះ ក្ឞុទ្រមីនាឝ្ច សន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","តទានីំ ស លោកនិវហំ ភូមាវុបវេឞ្ដុម៑ អាទិឝ្យ ");
INSERT INTO sankhm_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","តាន៑ សប្តបូបាន៑ មីនាំឝ្ច គ្ឫហ្លន៑ ឦឝ្វរីយគុណាន៑ អនូទ្យ ភំក្ត្វា ឝិឞ្យេភ្យោ ទទៅ, ឝិឞ្យា លោកេភ្យោ ទទុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","តតះ សវ៌្វេ ភុក្ត្វា ត្ឫប្តវន្តះ; តទវឝិឞ្ដភក្ឞ្យេណ សប្តឌលកាន៑ បរិបូយ៌្យ សំជគ្ឫហុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","តេ ភោក្តារោ យោឞិតោ ពាលកាំឝ្ច វិហាយ ប្រាយេណ ចតុះសហស្រាណិ បុរុឞា អាសន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","តតះ បរំ ស ជននិវហំ វិស្ឫជ្យ តរិមារុហ្យ មគ្ទលាប្រទេឝំ គតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","តទានីំ ផិរូឝិនះ សិទូកិនឝ្ចាគត្យ តំ បរីក្ឞិតុំ នភមីយំ កិញ្ចន លក្ឞ្ម ទឝ៌យិតុំ តស្មៃ និវេទយាមាសុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","តតះ ស ឧក្តវាន៑, សន្ធ្យាយាំ នភសោ រក្តត្វាទ៑ យូយំ វទថ, ឝ្វោ និម៌្មលំ ទិនំ ភវិឞ្យតិ; ");
INSERT INTO sankhm_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ប្រាតះកាលេ ច នភសោ រក្តត្វាត៑ មលិនត្វាញ្ច វទថ, ឈញ្ភ្ឝទ្យ ភវិឞ្យតិ។ ហេ កបដិនោ យទិ យូយម៑ អន្តរីក្ឞស្យ លក្ឞ្ម ពោទ្ធុំ ឝក្នុថ, តហ៌ិ កាលស្យៃតស្យ លក្ឞ្ម កថំ ពោទ្ធុំ ន ឝក្នុថ? ");
INSERT INTO sankhm_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ឯតត្កាលស្យ ទុឞ្ដោ វ្យភិចារី ច វំឝោ លក្ឞ្ម គវេឞយតិ, កិន្តុ យូនសោ ភវិឞ្យទ្វាទិនោ លក្ឞ្ម វិនាន្យត៑ កិមបិ លក្ឞ្ម តាន៑ ន ទឝ៌យិយ្យតេ។ តទានីំ ស តាន៑ វិហាយ ប្រតស្ថេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","អនន្តរមន្យបារគមនកាលេ តស្យ ឝិឞ្យាះ បូបមានេតុំ វិស្ម្ឫតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","យីឝុស្តានវាទីត៑, យូយំ ផិរូឝិនាំ សិទូកិនាញ្ច កិណ្វំ ប្រតិ សាវធានាះ សតក៌ាឝ្ច ភវត។ ");
INSERT INTO sankhm_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","តេន តេ បរស្បរំ វិវិច្យ កថយិតុមារេភិរេ, វយំ បូបានានេតុំ វិស្ម្ឫតវន្ត ឯតត្ការណាទ៑ ឥតិ កថយតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","កិន្តុ យីឝុស្តទ្វិជ្ញាយ តានវោចត៑, ហេ ស្តោកវិឝ្វាសិនោ យូយំ បូបានានយនមធិ កុតះ បរស្បរមេតទ៑ វិវិំក្យ? ");
INSERT INTO sankhm_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","យុឞ្មាភិះ កិមទ្យាបិ ន ជ្ញាយតេ? បញ្ចភិះ បូបៃះ បញ្ចសហស្របុរុឞេឞុ ភោជិតេឞុ ភក្ឞ្យោច្ឆិឞ្ដបូណ៌ាន៑ កតិ ឌលកាន៑ សមគ្ឫហ្លីតំ; ");
INSERT INTO sankhm_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","តថា សប្តភិះ បូបៃឝ្ចតុះសហស្របុរុឞេឞុ ភេជិតេឞុ កតិ ឌលកាន៑ សមគ្ឫហ្លីត, តត៑ កិំ យុឞ្មាភិន៌ ស្មយ៌្យតេ? ");
INSERT INTO sankhm_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","តស្មាត៑ ផិរូឝិនាំ សិទូកិនាញ្ច កិណ្វំ ប្រតិ សាវធានាស្តិឞ្ឋត, កថាមិមាម៑ អហំ បូបានធិ នាកថយំ, ឯតទ៑ យូយំ កុតោ ន ពុធ្យធ្វេ? ");
INSERT INTO sankhm_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","តទានីំ បូបកិណ្វំ ប្រតិ សាវធានាស្តិឞ្ឋតេតិ នោក្ត្វា ផិរូឝិនាំ សិទូកិនាញ្ច ឧបទេឝំ ប្រតិ សាវធានាស្តិឞ្ឋតេតិ កថិតវាន៑, ឥតិ តៃរពោធិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","អបរញ្ច យីឝុះ កៃសរិយា-ផិលិបិប្រទេឝមាគត្យ ឝិឞ្យាន៑ អប្ឫច្ឆត៑, យោៜហំ មនុជសុតះ សោៜហំ កះ? លោកៃរហំ កិមុច្យេ? ");
INSERT INTO sankhm_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","តទានីំ តេ កថិតវន្តះ, កេចិទ៑ វទន្តិ ត្វំ មជ្ជយិតា យោហន៑, កេចិទ្វទន្តិ, ត្វម៑ ឯលិយះ, កេចិច្ច វទន្តិ, ត្វំ យិរិមិយោ វា កឝ្ចិទ៑ ភវិឞ្យទ្វាទីតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","បឝ្ចាត៑ ស តាន៑ បប្រច្ឆ, យូយំ មាំ កំ វទថ? តតះ ឝិមោន៑ បិតរ ឧវាច, ");
INSERT INTO sankhm_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ត្វមមរេឝ្វរស្យាភិឞិក្តបុត្រះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","តតោ យីឝុះ កថិតវាន៑, ហេ យូនសះ បុត្រ ឝិមោន៑ ត្វំ ធន្យះ; យតះ កោបិ អនុជស្ត្វយ្យេតជ្ជ្ញានំ នោទបាទយត៑, កិន្តុ មម ស្វគ៌ស្យះ បិតោទបាទយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","អតោៜហំ ត្វាំ វទាមិ, ត្វំ បិតរះ (ប្រស្តរះ) អហញ្ច តស្យ ប្រស្តរស្យោបរិ ស្វមណ្ឌលីំ និម៌្មាស្យាមិ, តេន និរយោ ពលាត៑ តាំ បរាជេតុំ ន ឝក្ឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","អហំ តុភ្យំ ស្វគ៌ីយរាជ្យស្យ កុញ្ជិកាំ ទាស្យាមិ, តេន យត៑ កិញ្ចន ត្វំ ប្ឫថិវ្យាំ ភំត្ស្យសិ តត្ស្វគ៌េ ភំត្ស្យតេ, យច្ច កិញ្ចន មហ្យាំ មោក្ឞ្យសិ តត៑ ស្វគ៌េ មោក្ឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","បឝ្ចាត៑ ស ឝិឞ្យានាទិឝត៑, អហមភិឞិក្តោ យីឝុរិតិ កថាំ កស្មៃចិទបិ យូយំ មា កថយត។ ");
INSERT INTO sankhm_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","អន្យញ្ច យិរូឝាលម្នគរំ គត្វា ប្រាចីនលោកេភ្យះ ប្រធានយាជកេភ្យ ឧបាធ្យាយេភ្យឝ្ច ពហុទុះខភោគស្តៃ រ្ហតត្វំ ត្ឫតីយទិនេ បុនរុត្ថានញ្ច មមាវឝ្យកម៑ ឯតាះ កថា យីឝុស្តត្កាលមារភ្យ ឝិឞ្យាន៑ ជ្ញាបយិតុម៑ អារព្ធវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","តទានីំ បិតរស្តស្យ ករំ ឃ្ឫត្វា តជ៌យិត្វា កថយិតុមារព្ធវាន៑, ហេ ប្រភោ, តត៑ ត្វត្តោ ទូរំ យាតុ, ត្វាំ ប្រតិ កទាបិ ន ឃដិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","កិន្តុ ស វទនំ បរាវត៌្យ បិតរំ ជគាទ, ហេ វិឃ្នការិន៑, មត្សម្មុខាទ៑ ទូរីភវ, ត្វំ មាំ ពាធសេ, ឦឝ្វរីយកាយ៌្យាត៑ មានុឞីយកាយ៌្យំ តុភ្យំ រោចតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","អនន្តរំ យីឝុះ ស្វីយឝិឞ្យាន៑ ឧក្តវាន៑ យះ កឝ្ចិត៑ មម បឝ្ចាទ្គាមី ភវិតុម៑ ឥច្ឆតិ, ស ស្វំ ទាម្យតុ, តថា ស្វក្រុឝំ គ្ឫហ្លន៑ មត្បឝ្ចាទាយាតុ។ ");
INSERT INTO sankhm_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","យតោ យះ ប្រាណាន៑ រក្ឞិតុមិច្ឆតិ, ស តាន៑ ហារយិឞ្យតិ, កិន្តុ យោ មទត៌្ហំ និជប្រាណាន៑ ហារយតិ, ស តាន៑ ប្រាប្ស្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","មានុឞោ យទិ សវ៌្វំ ជគត៑ លភតេ និជប្រណាន៑ ហារយតិ, តហ៌ិ តស្យ កោ លាភះ? មនុជោ និជប្រាណានាំ វិនិមយេន វា កិំ ទាតុំ ឝក្នោតិ? ");
INSERT INTO sankhm_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","មនុជសុតះ ស្វទូតៃះ សាកំ បិតុះ ប្រភាវេណាគមិឞ្យតិ; តទា ប្រតិមនុជំ ស្វស្វកម៌្មានុសារាត៑ ផលំ ទាស្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","អហំ យុឞ្មាន៑ តថ្យំ វច្មិ, សរាជ្យំ មនុជសុតម៑ អាគតំ ន បឝ្យន្តោ ម្ឫត្យុំ ន ស្វាទិឞ្យន្តិ, ឯតាទ្ឫឝាះ កតិបយជនា អត្រាបិ ទណ្ឌាយមានាះ សន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","អនន្តរំ ឞឌ្ទិនេភ្យះ បរំ យីឝុះ បិតរំ យាកូពំ តត្សហជំ យោហនញ្ច គ្ឫហ្លន៑ ឧច្ចាទ្រេ រ្វិវិក្តស្ថានម៑ អាគត្យ តេឞាំ សមក្ឞំ រូបមន្យត៑ ទធារ។ ");
INSERT INTO sankhm_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","តេន តទាស្យំ តេជស្វិ, តទាភរណម៑ អាលោកវត៑ បាណ្ឌរមភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","អន្យច្ច តេន សាកំ សំលបន្តៅ មូសា ឯលិយឝ្ច តេភ្យោ ទឝ៌នំ ទទតុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","តទានីំ បិតរោ យីឝុំ ជគាទ, ហេ ប្រភោ ស្ថិតិរត្រាស្មាកំ ឝុភា, យទិ ភវតានុមន្យតេ, តហ៌ិ ភវទត៌្ហមេកំ មូសាត៌្ហមេកម៑ ឯលិយាត៌្ហញ្ចៃកម៑ ឥតិ ត្រីណិ ទូឞ្យាណិ និម៌្មម។ ");
INSERT INTO sankhm_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ឯតត្កថនកាល ឯក ឧជ្ជវលះ បយោទស្តេឞាមុបរិ ឆាយាំ ក្ឫតវាន៑, វារិទាទ៑ ឯឞា នភសីយា វាគ៑ ពភូវ, មមាយំ ប្រិយះ បុត្រះ, អស្មិន៑ មម មហាសន្តោឞ ឯតស្យ វាក្យំ យូយំ និឝាមយត។ ");
INSERT INTO sankhm_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","កិន្តុ វាចមេតាំ ឝ្ឫណ្វន្តឯវ ឝិឞ្យា ម្ឫឝំ ឝង្កមានា ន្យុព្ជា ន្យបតន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","តទា យីឝុរាគត្យ តេឞាំ គាត្រាណិ ស្ប្ឫឝន៑ ឧវាច, ឧត្តិឞ្ឋត, មា ភៃឞ្ដ។ ");
INSERT INTO sankhm_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","តទានីំ នេត្រាណ្យុន្មីល្យ យីឝុំ វិនា កមបិ ន ទទ្ឫឝុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","តតះ បរម៑ អទ្រេរវរោហណកាលេ យីឝុស្តាន៑ ឥត្យាទិទេឝ, មនុជសុតស្យ ម្ឫតានាំ មធ្យាទុត្ថានំ យាវន្ន ជាយតេ, តាវត៑ យុឞ្មាភិរេតទ្ទឝ៌នំ កស្មៃចិទបិ ន កថយិតវ្យំ។ ");
INSERT INTO sankhm_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","តទា ឝិឞ្យាស្តំ បប្រច្ឆុះ, ប្រថមម៑ ឯលិយ អាយាស្យតីតិ កុត ឧបាធ្យាយៃរុច្យតេ? ");
INSERT INTO sankhm_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","តតោ យីឝុះ ប្រត្យវាទីត៑, ឯលិយះ ប្រាគេត្យ សវ៌្វាណិ សាធយិឞ្យតីតិ សត្យំ, ");
INSERT INTO sankhm_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","កិន្ត្វហំ យុឞ្មាន៑ វច្មិ, ឯលិយ ឯត្យ គតះ, តេ តមបរិចិត្យ តស្មិន៑ យថេច្ឆំ វ្យវជហុះ; មនុជសុតេនាបិ តេឞាមន្តិកេ តាទ្ឫគ៑ ទុះខំ ភោក្តវ្យំ។ ");
INSERT INTO sankhm_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","តទានីំ ស មជ្ជយិតារំ យោហនមធិ កថាមេតាំ វ្យាហ្ឫតវាន៑, ឥត្ថំ តច្ឆិឞ្យា ពុពុធិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","បឝ្ចាត៑ តេឞុ ជននិវហស្យាន្តិកមាគតេឞុ កឝ្ចិត៑ មនុជស្តទន្តិកមេត្យ ជានូនី បាតយិត្វា កថិតវាន៑, ");
INSERT INTO sankhm_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ហេ ប្រភោ, មត្បុត្រំ ប្រតិ ក្ឫបាំ វិទធាតុ, សោបស្មារាមយេន ភ្ឫឝំ វ្យថិតះ សន៑ បុនះ បុន រ្វហ្នៅ មុហុ រ្ជលមធ្យេ បតតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","តស្មាទ៑ ភវតះ ឝិឞ្យាណាំ សមីបេ តមានយំ កិន្តុ តេ តំ ស្វាស្ថំ កត៌្តុំ ន ឝក្តាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","តទា យីឝុះ កថិតវាន៑ រេ អវិឝ្វាសិនះ, រេ វិបថគាមិនះ, បុនះ កតិកាលាន៑ អហំ យុឞ្មាកំ សន្និធៅ ស្ថាស្យាមិ? កតិកាលាន៑ វា យុឞ្មាន៑ សហិឞ្យេ? តមត្រ មមាន្តិកមានយត។ ");
INSERT INTO sankhm_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","បឝ្ចាទ៑ យីឝុនា តជ៌តឯវ ស ភូតស្តំ វិហាយ គតវាន៑, តទ្ទណ្ឌឯវ ស ពាលកោ និរាមយោៜភូត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","តតះ ឝិឞ្យា គុប្តំ យីឝុមុបាគត្យ ពភាឞិរេ, កុតោ វយំ តំ ភូតំ ត្យាជយិតុំ ន ឝក្តាះ? ");
INSERT INTO sankhm_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","យីឝុនា តេ ប្រោក្តាះ, យុឞ្មាកមប្រត្យយាត៑; ");
INSERT INTO sankhm_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","យុឞ្មានហំ តថ្យំ វច្មិ យទិ យុឞ្មាកំ សឞ៌បៃកមាត្រោបិ វិឝ្វាសោ ជាយតេ, តហ៌ិ យុឞ្មាភិរស្មិន៑ ឝៃលេ ត្វមិតះ ស្ថានាត៑ តត៑ ស្ថានំ យាហីតិ ព្រូតេ ស តទៃវ ចលិឞ្យតិ, យុឞ្មាកំ កិមប្យសាធ្យញ្ច កម៌្ម ន ស្ថាស្យាតិ។ កិន្តុ ប្រាត៌្ហនោបវាសៅ វិនៃតាទ្ឫឝោ ភូតោ ន ត្យាជ្យេត។ ");
INSERT INTO sankhm_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","អបរំ តេឞាំ គាលីល្ប្រទេឝេ ភ្រមណកាលេ យីឝុនា តេ គទិតាះ, មនុជសុតោ ជនានាំ ករេឞុ សមប៌យិឞ្យតេ តៃ រ្ហនិឞ្យតេ ច, ");
INSERT INTO sankhm_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","កិន្តុ ត្ឫតីយេៜហិ्ន ម ឧត្ថាបិឞ្យតេ, តេន តេ ភ្ឫឝំ ទុះខិតា ពភូវះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","តទនន្តរំ តេឞុ កផន៌ាហូម្នគរមាគតេឞុ ករសំគ្រាហិណះ បិតរាន្តិកមាគត្យ បប្រច្ឆុះ, យុឞ្មាកំ គុរុះ កិំ មន្ទិរាត៌្ហំ ករំ ន ទទាតិ? តតះ បិតរះ កថិតវាន៑ ទទាតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","តតស្តស្មិន៑ គ្ឫហមធ្យមាគតេ តស្យ កថាកថនាត៑ បូវ៌្វមេវ យីឝុរុវាច, ហេ ឝិមោន៑, មេទិន្យា រាជានះ ស្វស្វាបត្យេភ្យះ កិំ វិទេឝិភ្យះ កេភ្យះ ករំ គ្ឫហ្លន្តិ? អត្រ ត្វំ កិំ ពុធ្យសេ? តតះ បិតរ ឧក្តវាន៑, វិទេឝិភ្យះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","តទា យីឝុរុក្តវាន៑, តហ៌ិ សន្តានា មុក្តាះ សន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","តថាបិ យថាស្មាភិស្តេឞាមន្តរាយោ ន ជន្យតេ, តត្ក្ឫតេ ជលធេស្តីរំ គត្វា វឌិឝំ ក្ឞិប, តេនាទៅ យោ មីន ឧត្ថាស្យតិ, តំ ឃ្ឫត្វា តន្មុខេ មោចិតេ តោលកៃកំ រូប្យំ ប្រាប្ស្យសិ, តទ៑ គ្ឫហីត្វា តវ មម ច ក្ឫតេ តេភ្យោ ទេហិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","តទានីំ ឝិឞ្យា យីឝោះ សមីបមាគត្យ ប្ឫឞ្ដវន្តះ ស្វគ៌រាជ្យេ កះ ឝ្រេឞ្ឋះ? ");
INSERT INTO sankhm_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","តតោ យីឝុះ ក្ឞុទ្រមេកំ ពាលកំ ស្វសមីបមានីយ តេឞាំ មធ្យេ និធាយ ជគាទ, ");
INSERT INTO sankhm_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","យុឞ្មានហំ សត្យំ ព្រវីមិ, យូយំ មនោវិនិមយេន ក្ឞុទ្រពាលវត៑ ន សន្តះ ស្វគ៌រាជ្យំ ប្រវេឞ្ដុំ ន ឝក្នុថ។ ");
INSERT INTO sankhm_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","យះ កឝ្ចិទ៑ ឯតស្យ ក្ឞុទ្រពាលកស្យ សមមាត្មានំ នម្រីករោតិ, សឯវ ស្វគ៌រាជយេ ឝ្រេឞ្ឋះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","យះ កឝ្ចិទ៑ ឯតាទ្ឫឝំ ក្ឞុទ្រពាលកមេកំ មម នាម្និ គ្ឫហ្លាតិ, ស មាមេវ គ្ឫហ្លាតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","កិន្តុ យោ ជនោ មយិ ក្ឫតវិឝ្វាសានាមេតេឞាំ ក្ឞុទ្រប្រាណិនាម៑ ឯកស្យាបិ វិធ្និំ ជនយតិ, កណ្ឋពទ្ធបេឞណីកស្យ តស្យ សាគរាគាធជលេ មជ្ជនំ ឝ្រេយះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","វិឃ្នាត៑ ជគតះ សន្តាបោ ភវិឞ្យតិ, វិឃ្នោៜវឝ្យំ ជនយិឞ្យតេ, កិន្តុ យេន មនុជេន វិឃ្នោ ជនិឞ្យតេ តស្យៃវ សន្តាបោ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","តស្មាត៑ តវ ករឝ្ចរណោ វា យទិ ត្វាំ ពាធតេ, តហ៌ិ តំ ឆិត្ត្វា និក្ឞិប, ទ្វិករស្យ ទ្វិបទស្យ វា តវានប្តវហ្នៅ និក្ឞេបាត៑, ខញ្ជស្យ វា ឆិន្នហស្តស្យ តវ ជីវនេ ប្រវេឝោ វរំ។ ");
INSERT INTO sankhm_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","អបរំ តវ នេត្រំ យទិ ត្វាំ ពាធតេ, តហ៌ិ តទប្យុត្បាវ្យ និក្ឞិប, ទ្វិនេត្រស្យ នរកាគ្នៅ និក្ឞេបាត៑ កាណស្យ តវ ជីវនេ ប្រវេឝោ វរំ។ ");
INSERT INTO sankhm_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","តស្មាទវធទ្ធំ, ឯតេឞាំ ក្ឞុទ្រប្រាណិនាម៑ ឯកមបិ មា តុច្ឆីកុរុត, ");
INSERT INTO sankhm_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","យតោ យុឞ្មានហំ តថ្យំ ព្រវីមិ, ស្វគ៌េ តេឞាំ ទូតា មម ស្វគ៌ស្ថស្យ បិតុរាស្យំ និត្យំ បឝ្យន្តិ។ ឯវំ យេ យេ ហារិតាស្តាន៑ រក្ឞិតុំ មនុជបុត្រ អាគច្ឆត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","យូយមត្រ កិំ វិវិំគ្ឃ្វេ? កស្យចិទ៑ យទិ ឝតំ មេឞាះ សន្តិ, តេឞាមេកោ ហាយ៌្យតេ ច, តហ៌ិ ស ឯកោនឝតំ មេឞាន៑ វិហាយ បវ៌្វតំ គត្វា តំ ហារិតមេកំ កិំ ន ម្ឫគយតេ? ");
INSERT INTO sankhm_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","យទិ ច កទាចិត៑ តន្មេឞោទ្ទេឝំ លមតេ, តហ៌ិ យុឞ្មានហំ សត្យំ កថយាមិ, សោៜវិបថគាមិភ្យ ឯកោនឝតមេឞេភ្យោបិ តទេកហេតោរធិកម៑ អាហ្លាទតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","តទ្វទ៑ ឯតេឞាំ ក្ឞុទ្រប្រាឯिនាម៑ ឯកោបិ នឝ្យតីតិ យុឞ្មាកំ ស្វគ៌ស្ថបិតុ រ្នាភិមតម៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","យទ្យបិ តវ ភ្រាតា ត្វយិ កិមប្យបរាធ្យតិ, តហ៌ិ គត្វា យុវយោទ៌្វយោះ ស្ថិតយោស្តស្យាបរាធំ តំ ជ្ញាបយ។ តត្រ ស យទិ តវ វាក្យំ ឝ្ឫណោតិ, តហ៌ិ ត្វំ ស្វភ្រាតរំ ប្រាប្តវាន៑, ");
INSERT INTO sankhm_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","កិន្តុ យទិ ន ឝ្ឫណោតិ, តហ៌ិ ទ្វាភ្យាំ ត្រិភិ រ្វា សាក្ឞីភិះ សវ៌្វំ វាក្យំ យថា និឝ្ចិតំ ជាយតេ, តទត៌្ហម៑ ឯកំ ទ្វៅ វា សាក្ឞិណៅ គ្ឫហីត្វា យាហិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","តេន ស យទិ តយោ រ្វាក្យំ ន មាន្យតេ, តហ៌ិ សមាជំ តជ្ជ្ញាបយ, កិន្តុ យទិ សមាជស្យាបិ វាក្យំ ន មាន្យតេ,តហ៌ិ ស តវ សមីបេ ទេវបូជកឥវ ចណ្ឌាលឥវ ច ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","អហំ យុឞ្មាន៑ សត្យំ វទាមិ, យុឞ្មាភិះ ប្ឫថិវ្យាំ យទ៑ ពធ្យតេ តត៑ ស្វគ៌េ ភំត្ស្យតេ; មេទិន្យាំ យត៑ ភោច្យតេ, ស្វគ៌េៜបិ តត៑ មោក្ឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","បុនរហំ យុឞ្មាន៑ វទាមិ, មេទិន្យាំ យុឞ្មាកំ យទិ ទ្វាវេកវាក្យីភូយ កិញ្ចិត៑ ប្រាត៌្ហយេតេ, តហ៌ិ មម ស្វគ៌ស្ថបិត្រា តត៑ តយោះ ក្ឫតេ សម្បន្នំ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","យតោ យត្រ ទ្វៅ ត្រយោ វា មម នាន្និ មិលន្តិ, តត្រៃវាហំ តេឞាំ មធ្យេៜស្មិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","តទានីំ បិតរស្តត្សមីបមាគត្យ កថិតវាន៑ ហេ ប្រភោ, មម ភ្រាតា មម យទ្យបរាធ្យតិ, តហ៌ិ តំ កតិក្ឫត្វះ ក្ឞមិឞ្យេ? ");
INSERT INTO sankhm_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","កិំ សប្តក្ឫត្វះ? យីឝុស្តំ ជគាទ, ត្វាំ កេវលំ សប្តក្ឫត្វោ យាវត៑ ន វទាមិ, កិន្តុ សប្តត្យា គុណិតំ សប្តក្ឫត្វោ យាវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","អបរំ និជទាសៃះ សហ ជិគណយិឞុះ កឝ្ចិទ៑ រាជេវ ស្វគ៌រាជយំ។ ");
INSERT INTO sankhm_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","អារព្ធេ តស្មិន៑ គណនេ សាទ៌្ធសហស្រមុទ្រាបូរិតានាំ ទឝសហស្របុដកានាម៑ ឯកោៜឃមណ៌ស្តត្សមក្ឞមានាយិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","តស្យ បរិឝោធនាយ ទ្រវ្យាភាវាត៑ បរិឝោធនាត៌្ហំ ស តទីយភាយ៌្យាបុត្រាទិសវ៌្វស្វញ្ច វិក្រីយតាមិតិ តត្ប្រភុរាទិទេឝ។ ");
INSERT INTO sankhm_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","តេន ស ទាសស្តស្យ បាទយោះ បតន៑ ប្រណម្យ កថិតវាន៑ , ហេ ប្រភោ ភវតា ឃៃយ៌្យេ ក្ឫតេ មយា សវ៌្វំ បរិឝោធិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","តទានីំ ទាសស្យ ប្រភុះ សករុណះ សន៑ សកលណ៌ំ ក្ឞមិត្វា តំ តត្យាជ។ ");
INSERT INTO sankhm_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","កិន្តុ តស្មិន៑ ទាសេ ពហិ រ្យាតេ, តស្យ ឝតំ មុទ្រាចតុត៌្ហាំឝាន៑ យោ ធារយតិ, តំ សហទាសំ ទ្ឫឞ្ទ្វា តស្យ កណ្ឋំ និឞ្បីឌ្យ គទិតវាន៑, មម យត៑ ប្រាប្យំ តត៑ បរិឝោធយ។ ");
INSERT INTO sankhm_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","តទា តស្យ សហទាសស្តត្បាទយោះ បតិត្វា វិនីយ ពភាឞេ, ត្វយា ធៃយ៌្យេ ក្ឫតេ មយា សវ៌្វំ បរិឝោធិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","តថាបិ ស តត៑ នាងគីក្ឫត្យ យាវត៑ សវ៌្វម្ឫណំ ន បរិឝោធិតវាន៑ តាវត៑ តំ ការាយាំ ស្ថាបយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","តទា តស្យ សហទាសាស្តស្យៃតាទ្ឫគ៑ អាចរណំ វិលោក្យ ប្រភោះ សមីបំ គត្វា សវ៌្វំ វ្ឫត្តាន្តំ និវេទយាមាសុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","តទា តស្យ ប្រភុស្តមាហូយ ជគាទ, រេ ទុឞ្ដ ទាស, ត្វយា មត្សន្និធៅ ប្រាត៌្ហិតេ មយា តវ សវ៌្វម្ឫណំ ត្យក្តំ; ");
INSERT INTO sankhm_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","យថា ចាហំ ត្វយិ ករុណាំ ក្ឫតវាន៑, តថៃវ ត្វត្សហទាសេ ករុណាករណំ កិំ តវ នោចិតំ? ");
INSERT INTO sankhm_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ឥតិ កថយិត្វា តស្យ ប្រភុះ ក្រុទ្ធ្យន៑ និជប្រាប្យំ យាវត៑ ស ន បរិឝោធិតវាន៑, តាវត៑ ប្រហារកានាំ ករេឞុ តំ សមប៌ិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","យទិ យូយំ ស្វាន្តះករណៃះ ស្វស្វសហជានាម៑ អបរាធាន៑ ន ក្ឞមធ្វេ, តហ៌ិ មម ស្វគ៌ស្យះ បិតាបិ យុឞ្មាន៑ ប្រតីត្ថំ ករិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","អនន្តរម៑ ឯតាសុ កថាសុ សមាប្តាសុ យីឝុ រ្គាលីលប្រទេឝាត៑ ប្រស្ថាយ យទ៌ន្តីរស្ថំ យិហូទាប្រទេឝំ ប្រាប្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","តទា តត្បឝ្ចាត៑ ជននិវហេ គតេ ស តត្រ តាន៑ និរាមយាន៑ អករោត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","តទនន្តរំ ផិរូឝិនស្តត្សមីបមាគត្យ បារីក្ឞិតុំ តំ បប្រច្ឆុះ, កស្មាទបិ ការណាត៑ នរេណ ស្វជាយា បរិត្យាជ្យា ន វា? ");
INSERT INTO sankhm_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ស ប្រត្យុវាច, ប្រថមម៑ ឦឝ្វរោ នរត្វេន នារីត្វេន ច មនុជាន៑ សសជ៌, តស្មាត៑ កថិតវាន៑, ");
INSERT INTO sankhm_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","មានុឞះ ស្វបិតរៅ បរិត្យជ្យ ស្វបត្ន្យាម៑ អាសក្ឞ្យតេ, តៅ ទ្វៅ ជនាវេកាង្គៅ ភវិឞ្យតះ, កិមេតទ៑ យុឞ្មាភិ រ្ន បឋិតម៑? ");
INSERT INTO sankhm_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","អតស្តៅ បុន រ្ន ទ្វៅ តយោរេកាង្គត្វំ ជាតំ, ឦឝ្វរេណ យច្ច សមយុជ្យត, មនុជោ ន តទ៑ ភិន្ទ្យាត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","តទានីំ តេ តំ ប្រត្យវទន៑, តថាត្វេ ត្យាជ្យបត្រំ ទត្ត្វា ស្វាំ ស្វាំ ជាយាំ ត្យក្តុំ វ្យវស្ថាំ មូសាះ កថំ លិលេខ? ");
INSERT INTO sankhm_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","តតះ ស កថិតវាន៑, យុឞ្មាកំ មនសាំ កាឋិន្យាទ៑ យុឞ្មាន៑ ស្វាំ ស្វាំ ជាយាំ ត្យក្តុម៑ អន្វមន្យត កិន្តុ ប្រថមាទ៑ ឯឞោ វិធិន៌ាសីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","អតោ យុឞ្មានហំ វទាមិ, វ្យភិចារំ វិនា យោ និជជាយាំ ត្យជេត៑ អន្យាញ្ច វិវហេត៑, ស បរទារាន៑ គច្ឆតិ; យឝ្ច ត្យក្តាំ នារីំ វិវហតិ សោបិ បរទារេឞុ រមតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","តទា តស្យ ឝិឞ្យាស្តំ ពភាឞិរេ, យទិ ស្វជាយយា សាកំ បុំស ឯតាទ្ឫក៑ សម្ពន្ធោ ជាយតេ, តហ៌ិ វិវហនមេវ ន ភទ្រំ។ ");
INSERT INTO sankhm_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","តតះ ស ឧក្តវាន៑, យេភ្យស្តត្សាមត៌្ហ្យំ អាទាយិ, តាន៑ វិនាន្យះ កោបិ មនុជ ឯតន្មតំ គ្រហីតុំ ន ឝក្នោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","កតិបយា ជននក្លីពះ កតិបយា នរក្ឫតក្លីពះ ស្វគ៌រាជ្យាយ កតិបយាះ ស្វក្ឫតក្លីពាឝ្ច សន្តិ, យេ គ្រហីតុំ ឝក្នុវន្តិ តេ គ្ឫហ្លន្តុ។ ");
INSERT INTO sankhm_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","អបរម៑ យថា ស ឝិឝូនាំ គាត្រេឞុ ហស្តំ ទត្វា ប្រាត៌្ហយតេ, តទត៌្ហំ តត្សមីំបំ ឝិឝវ អានីយន្ត, តត អានយិត្ឫន៑ ឝិឞ្យាស្តិរស្ក្ឫតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","កិន្តុ យីឝុរុវាច, ឝិឝវោ មទន្តិកម៑ អាគច្ឆន្តុ, តាន៑ មា វារយត, ឯតាទ្ឫឝាំ ឝិឝូនាមេវ ស្វគ៌រាជ្យំ។ ");
INSERT INTO sankhm_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","តតះ ស តេឞាំ គាត្រេឞុ ហស្តំ ទត្វា តស្មាត៑ ស្ថានាត៑ ប្រតស្ថេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","អបរម៑ ឯក អាគត្យ តំ បប្រច្ឆ, ហេ បរមគុរោ, អនន្តាយុះ ប្រាប្តុំ មយា កិំ កិំ សត្កម៌្ម កត៌្តវ្យំ? ");
INSERT INTO sankhm_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","តតះ ស ឧវាច, មាំ បរមំ កុតោ វទសិ? វិនេឝ្ចរំ ន កោបិ បរមះ, កិន្តុ យទ្យនន្តាយុះ ប្រាប្តុំ វាញ្ឆសិ, តហ៌្យាជ្ញាះ បាលយ។ ");
INSERT INTO sankhm_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","តទា ស ប្ឫឞ្ដវាន៑, កាះ កា អាជ្ញាះ? តតោ យីឝុះ កថិតវាន៑, នរំ មា ហន្យាះ, បរទារាន៑ មា គច្ឆេះ, មា ចោរយេះ, ម្ឫឞាសាក្ឞ្យំ មា ទទ្យាះ, ");
INSERT INTO sankhm_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","និជបិតរៅ សំមន្យស្វ, ស្វសមីបវាសិនិ ស្វវត៑ ប្រេម កុរុ។ ");
INSERT INTO sankhm_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ស យុវា កថិតវាន៑, អា ពាល្យាទ៑ ឯតាះ បាលយាមិ, ឥទានីំ កិំ ន្យូនមាស្តេ? ");
INSERT INTO sankhm_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","តតោ យីឝុរវទត៑, យទិ សិទ្ធោ ភវិតុំ វាញ្ឆសិ, តហ៌ិ គត្វា និជសវ៌្វស្វំ វិក្រីយ ទរិទ្រេភ្យោ វិតរ, តតះ ស្វគ៌េ វិត្តំ លប្ស្យសេ; អាគច្ឆ, មត្បឝ្ចាទ្វត៌្តី ច ភវ។ ");
INSERT INTO sankhm_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ឯតាំ វាចំ ឝ្រុត្វា ស យុវា ស្វីយពហុសម្បត្តេ រ្វិឞណះ សន៑ ចលិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","តទា យីឝុះ ស្វឝិឞ្យាន៑ អវទត៑, ធនិនាំ ស្វគ៌រាជ្យប្រវេឝោ មហាទុឞ្ករ ឥតិ យុឞ្មានហំ តថ្យំ វទាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","បុនរបិ យុឞ្មានហំ វទាមិ, ធនិនាំ ស្វគ៌រាជ្យប្រវេឝាត៑ សូចីឆិទ្រេណ មហាង្គគមនំ សុករំ។ ");
INSERT INTO sankhm_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ឥតិ វាក្យំ និឝម្យ ឝិឞ្យា អតិចមត្ក្ឫត្យ កថយាមាសុះ; តហ៌ិ កស្យ បរិត្រាណំ ភវិតុំ ឝក្នោតិ? ");
INSERT INTO sankhm_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","តទា ស តាន៑ ទ្ឫឞ្ទ្វា កថយាមាស, តត៑ មានុឞាណាមឝក្យំ ភវតិ, កិន្ត្វីឝ្វរស្យ សវ៌្វំ ឝក្យម៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","តទា បិតរស្តំ គទិតវាន៑, បឝ្យ, វយំ សវ៌្វំ បរិត្យជ្យ ភវតះ បឝ្ចាទ្វត៌្តិនោ ៜភវាម; វយំ កិំ ប្រាប្ស្យាមះ? ");
INSERT INTO sankhm_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","តតោ យីឝុះ កថិតវាន៑, យុឞ្មានហំ តថ្យំ វទាមិ, យូយំ មម បឝ្ចាទ្វត៌្តិនោ ជាតា ឥតិ ការណាត៑ នវីនស្ឫឞ្ដិកាលេ យទា មនុជសុតះ ស្វីយៃឝ្ចយ៌្យសិំហាសន ឧបវេក្ឞ្យតិ, តទា យូយមបិ ទ្វាទឝសិំហាសនេឞូបវិឝ្យ ឥស្រាយេលីយទ្វាទឝវំឝានាំ វិចារំ ករិឞ្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","អន្យច្ច យះ កឝ្ចិត៑ មម នាមការណាត៑ គ្ឫហំ វា ភ្រាតរំ វា ភគិនីំ វា បិតរំ វា មាតរំ វា ជាយាំ វា ពាលកំ វា ភូមិំ បរិត្យជតិ, ស តេឞាំ ឝតគុណំ លប្ស្យតេ, អនន្តាយុមោៜធិការិត្វញ្ច ប្រាប្ស្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","កិន្តុ អគ្រីយា អនេកេ ជនាះ បឝ្ចាត៑, បឝ្ចាតីយាឝ្ចានេកេ លោកា អគ្រេ ភវិឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","ស្វគ៌រាជ្យម៑ ឯតាទ្ឫឝា កេនចិទ៑ គ្ឫហស្យេន សមំ, យោៜតិប្រភាតេ និជទ្រាក្ឞាក្ឞេត្រេ ក្ឫឞកាន៑ និយោក្តុំ គតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","បឝ្ចាត៑ តៃះ សាកំ ទិនៃកភ្ឫតិំ មុទ្រាចតុត៌្ហាំឝំ និរូប្យ តាន៑ ទ្រាក្ឞាក្ឞេត្រំ ប្រេរយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","អនន្តរំ ប្រហរៃកវេលាយាំ គត្វា ហដ្ដេ កតិបយាន៑ និឞ្កម៌្មកាន៑ វិលោក្យ តានវទត៑, ");
INSERT INTO sankhm_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","យូយមបិ មម ទ្រាក្ឞាក្ឞេត្រំ យាត, យុឞ្មភ្យមហំ យោគ្យភ្ឫតិំ ទាស្យាមិ, តតស្តេ វវ្រជុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","បុនឝ្ច ស ទ្វិតីយត្ឫតីយយោះ ប្រហរយោ រ្ពហិ រ្គត្វា តថៃវ ក្ឫតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","តតោ ទណ្ឌទ្វយាវឝិឞ្ដាយាំ វេលាយាំ ពហិ រ្គត្វាបរាន៑ កតិបយជនាន៑ និឞ្កម៌្មកាន៑ វិលោក្យ ប្ឫឞ្ដវាន៑, យូយំ កិមត៌្ហម៑ អត្រ សវ៌្វំ ទិនំ និឞ្កម៌្មាណស្តិឞ្ឋថ? ");
INSERT INTO sankhm_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","តេ ប្រត្យវទន៑, អស្មាន៑ ន កោបិ កម៌មណិ និយុំក្តេ។ តទានីំ ស កថិតវាន៑, យូយមបិ មម ទ្រាក្ឞាក្ឞេត្រំ យាត, តេន យោគ្យាំ ភ្ឫតិំ លប្ស្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","តទនន្តរំ សន្ធ្យាយាំ សត្យាំ សឯវ ទ្រាក្ឞាក្ឞេត្របតិរធ្យក្ឞំ គទិវាន៑, ក្ឫឞកាន៑ អាហូយ ឝេឞជនមារភ្យ ប្រថមំ យាវត៑ តេភ្យោ ភ្ឫតិំ ទេហិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","តេន យេ ទណ្ឌទ្វយាវស្ថិតេ សមាយាតាស្តេឞាម៑ ឯកៃកោ ជនោ មុទ្រាចតុត៌្ហាំឝំ ប្រាប្នោត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","តទានីំ ប្រថមនិយុក្តា ជនា អាគត្យានុមិតវន្តោ វយមធិកំ ប្រប្ស្យាមះ, កិន្តុ តៃរបិ មុទ្រាចតុត៌្ហាំឝោៜលាភិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","តតស្តេ តំ គ្ឫហីត្វា តេន ក្ឞេត្របតិនា សាកំ វាគ្យុទ្ធំ កុវ៌្វន្តះ កថយាមាសុះ, ");
INSERT INTO sankhm_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","វយំ ក្ឫត្ស្នំ ទិនំ តាបក្លេឝៅ សោឍវន្តះ, កិន្តុ បឝ្ចាតាយា សេ ជនា ទណ្ឌទ្វយមាត្រំ បរិឝ្រាន្តវន្តស្តេៜស្មាភិះ សមានាំឝាះ ក្ឫតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","តតះ ស តេឞាមេកំ ប្រត្យុវាច, ហេ វត្ស, មយា ត្វាំ ប្រតិ កោប្យន្យាយោ ន ក្ឫតះ កិំ ត្វយា មត្សមក្ឞំ មុទ្រាចតុត៌្ហាំឝោ នាង្គីក្ឫតះ? ");
INSERT INTO sankhm_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","តស្មាត៑ តវ យត៑ ប្រាប្យំ តទាទាយ យាហិ, តុភ្យំ យតិ, បឝ្ចាតីយនិយុក្តលោកាយាបិ តតិ ទាតុមិច្ឆាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ស្វេច្ឆយា និជទ្រវ្យវ្យវហរណំ កិំ មយា ន កត៌្តវ្យំ? មម ទាត្ឫត្វាត៑ ត្វយា កិម៑ ឦឞ៌្យាទ្ឫឞ្ដិះ ក្រិយតេ? ");
INSERT INTO sankhm_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","ឥត្ថម៑ អគ្រីយលោកាះ បឝ្ចតីយា ភវិឞ្យន្តិ, បឝ្ចាតីយជនាឝ្ចគ្រីយា ភវិឞ្យន្តិ, អហូតា ពហវះ កិន្ត្វល្បេ មនោភិលឞិតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","តទនន្តរំ យីឝុ រ្យិរូឝាលម្នគរំ គច្ឆន៑ មាគ៌មធ្យេ ឝិឞ្យាន៑ ឯកាន្តេ វភាឞេ, ");
INSERT INTO sankhm_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","បឝ្យ វយំ យិរូឝាលម្នគរំ យាមះ, តត្រ ប្រធានយាជកាធ្យាបកានាំ ករេឞុ មនុឞ្យបុត្រះ សមប៌ិឞ្យតេ; ");
INSERT INTO sankhm_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","តេ ច តំ ហន្តុមាជ្ញាប្យ តិរស្ក្ឫត្យ វេត្រេណ ប្រហត៌្តុំ ក្រុឝេ ធាតយិតុញ្ចាន្យទេឝីយានាំ ករេឞុ សមប៌យិឞ្យន្តិ, កិន្តុ ស ត្ឫតីយទិវសេ ឝ្មឝានាទ៑ ឧត្ថាបិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","តទានីំ សិវទីយស្យ នារី ស្វបុត្រាវាទាយ យីឝោះ សមីបម៑ ឯត្យ ប្រណម្យ កញ្ចនានុគ្រហំ តំ យយាចេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","តទា យីឝុស្តាំ ប្រោក្តវាន៑, ត្វំ កិំ យាចសេ? តតះ សា ពភាឞេ, ភវតោ រាជត្វេ មមានយោះ សុតយោរេកំ ភវទ្ទក្ឞិណបាឝ៌្វេ ទ្វិតីយំ វាមបាឝ៌្វ ឧបវេឞ្ដុម៑ អាជ្ញាបយតុ។ ");
INSERT INTO sankhm_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","យីឝុះ ប្រត្យុវាច, យុវាភ្យាំ យទ៑ យាច្យតេ, តន្ន ពុធ្យតេ, អហំ យេន កំសេន បាស្យាមិ យុវាភ្យាំ កិំ តេន បាតុំ ឝក្យតេ? អហញ្ច យេន មជ្ជេនេន មជ្ជិឞ្យេ, យុវាភ្យាំ កិំ តេន មជ្ជយិតុំ ឝក្យតេ? តេ ជគទុះ ឝក្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","តទា ស ឧក្តវាន៑, យុវាំ មម កំសេនាវឝ្យំ បាស្យថះ, មម មជ្ជនេន ច យុវាមបិ មជ្ជិឞ្យេថេ, កិន្តុ យេឞាំ ក្ឫតេ មត្តាតេន និរូបិតម៑ ឥទំ តាន៑ វិហាយាន្យំ កមបិ មទ្ទក្ឞិណបាឝ៌្វេ វាមបាឝ៌្វេ ច សមុបវេឝយិតុំ មមាធិការោ នាស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ឯតាំ កថាំ ឝ្រុត្វាន្យេ ទឝឝិឞ្យាស្តៅ ភ្រាតរៅ ប្រតិ ចុកុបុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","កិន្តុ យីឝុះ ស្វសមីបំ តានាហូយ ជគាទ, អន្យទេឝីយលោកានាំ នរបតយស្តាន៑ អធិកុវ៌្វន្តិ, យេ តុ មហាន្តស្តេ តាន៑ ឝាសតិ, ឥតិ យូយំ ជានីថ។ ");
INSERT INTO sankhm_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","កិន្តុ យុឞ្មាកំ មធ្យេ ន តថា ភវេត៑, យុឞ្មាកំ យះ កឝ្ចិត៑ មហាន៑ ពុភូឞតិ, ស យុឞ្មាន៑ សេវេត; ");
INSERT INTO sankhm_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","យឝ្ច យុឞ្មាកំ មធ្យេ មុខ្យោ ពុភូឞតិ, ស យុឞ្មាកំ ទាសោ ភវេត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ឥត្ថំ មនុជបុត្រះ សេវ្យោ ភវិតុំ នហិ, កិន្តុ សេវិតុំ ពហូនាំ បរិត្រាណមូល្យាត៌្ហំ ស្វប្រាណាន៑ ទាតុញ្ចាគតះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","អនន្តរំ យិរីហោនគរាត៑ តេឞាំ ពហិគ៌មនសមយេ តស្យ បឝ្ចាទ៑ ពហវោ លោកា វវ្រជុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","អបរំ វត៌្មបាឝ៌្វ ឧបវិឝន្តៅ ទ្វាវន្ធៅ តេន មាគ៌េណ យីឝោ រ្គមនំ និឝម្យ ប្រោច្ចៃះ កថយាមាសតុះ, ហេ ប្រភោ ទាយូទះ សន្តាន, អាវយោ រ្ទយាំ វិធេហិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","តតោ លោកាះ សវ៌្វេ តុឞ្ណីម្ភវតមិត្យុក្ត្វា តៅ តជ៌យាមាសុះ; តថាបិ តៅ បុនរុច្ចៃះ កថយាមាសតុះ ហេ ប្រភោ ទាយូទះ សន្តាន, អាវាំ ទយស្វ។ ");
INSERT INTO sankhm_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","តទានីំ យីឝុះ ស្ថគិតះ សន៑ តាវាហូយ ភាឞិតវាន៑, យុវយោះ ក្ឫតេ មយា កិំ កត៌្តវ៌្យំ? យុវាំ កិំ កាមយេថេ? ");
INSERT INTO sankhm_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","តទា តាវុក្តវន្តៅ, ប្រភោ នេត្រាណិ នៅ ប្រសន្នានិ ភវេយុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","តទានីំ យីឝុស្តៅ ប្រតិ ប្រមន្នះ សន៑ តយោ រ្នេត្រាណិ បស្បឝ៌, តេនៃវ តៅ សុវីក្ឞាញ្ចក្រាតេ តត្បឝ្ចាត៑ ជគ្មុតុឝ្ច។ ");
INSERT INTO sankhm_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","អនន្តរំ តេឞុ យិរូឝាលម្នគរស្យ សមីបវេត៌្តិនោ ជៃតុននាមកធរាធរស្យ សមីបស្ថ្តិំ ពៃត្ផគិគ្រាមម៑ អាគតេឞុ, យីឝុះ ឝិឞ្យទ្វយំ ប្រេឞយន៑ ជគាទ, ");
INSERT INTO sankhm_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","យុវាំ សម្មុខស្ថគ្រាមំ គត្វា ពទ្ធាំ យាំ សវត្សាំ គទ៌្ទភីំ ហឋាត៑ ប្រាប្ស្យថះ, តាំ មោចយិត្វា មទន្តិកម៑ អានយតំ។ ");
INSERT INTO sankhm_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","តត្រ យទិ កឝ្ចិត៑ កិញ្ចិទ៑ វក្ឞ្យតិ, តហ៌ិ វទិឞ្យថះ, ឯតស្យាំ ប្រភោះ ប្រយោជនមាស្តេ, តេន ស តត្ក្ឞណាត៑ ប្រហេឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","សីយោនះ កន្យកាំ យូយំ ភាឞធ្វមិតិ ភារតីំ។ បឝ្យ តេ នម្រឝីលះ សន៑ ន្ឫប អារុហ្យ គទ៌ភីំ។ អត៌្ហាទារុហ្យ តទ្វត្សមាយាស្យតិ ត្វទន្តិកំ។ ");
INSERT INTO sankhm_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","ភវិឞ្យទ្វាទិនោក្តំ វចនមិទំ តទា សផលមភូត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","អនន្តរំ តៅ ឝ្ឞ្យិौ យីឝោ រ្យថានិទេឝំ តំ គ្រាមំ គត្វា ");
INSERT INTO sankhm_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","គទ៌ភីំ តទ្វត្សញ្ច សមានីតវន្តៅ, បឝ្ចាត៑ តទុបរិ ស្វីយវសនានី បាតយិត្វា តមារោហយាមាសតុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","តតោ ពហវោ លោកា និជវសនានិ បថិ ប្រសារយិតុមារេភិរេ, កតិបយា ជនាឝ្ច បាទបបណ៌ាទិកំ ឆិត្វា បថិ វិស្តារយាមាសុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","អគ្រគាមិនះ បឝ្ចាទ្គាមិនឝ្ច មនុជា ឧច្ចៃជ៌យ ជយ ទាយូទះ សន្តានេតិ ជគទុះ បរមេឝ្វរស្យ នាម្នា យ អាយាតិ ស ធន្យះ, សវ៌្វោបរិស្ថស្វគ៌េបិ ជយតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ឥត្ថំ តស្មិន៑ យិរូឝាលមំ ប្រវិឞ្ដេ កោៜយមិតិ កថនាត៑ ក្ឫត្ស្នំ នគរំ ចញ្ចលមភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","តត្រ លោកោះ កថយាមាសុះ, ឯឞ គាលីល្ប្រទេឝីយ-នាសរតីយ-ភវិឞ្យទ្វាទី យីឝុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","អនន្តរំ យីឝុរីឝ្វរស្យ មន្ទិរំ ប្រវិឝ្យ តន្មធ្យាត៑ ក្រយវិក្រយិណោ វហិឝ្ចការ; វណិជាំ មុទ្រាសនានី កបោតវិក្រយិណាញ្ចសនានី ច ន្យុវ្ជយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","អបរំ តានុវាច, ឯឞា លិបិរាស្តេ, \"មម គ្ឫហំ ប្រាត៌្ហនាគ្ឫហមិតិ វិខ្យាស្យតិ\", កិន្តុ យូយំ តទ៑ ទស្យូនាំ គហ្វរំ ក្ឫតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","តទនន្តរម៑ អន្ធខញ្ចលោកាស្តស្យ សមីបមាគតាះ, ស តាន៑ និរាមយាន៑ ក្ឫតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","យទា ប្រធានយាជកា អធ្យាបកាឝ្ច តេន ក្ឫតាន្យេតានិ ចិត្រកម៌្មាណិ ទទ្ឫឝុះ, ជយ ជយ ទាយូទះ សន្តាន, មន្ទិរេ ពាលកានាម៑ ឯតាទ្ឫឝម៑ ឧច្ចធ្វនិំ ឝុឝ្រុវុឝ្ច, តទា មហាក្រុទ្ធា ពភូវះ, ");
INSERT INTO sankhm_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","តំ បប្រច្ឆុឝ្ច, ឥមេ យទ៑ វទន្តិ, តត៑ កិំ ត្វំ ឝ្ឫណោឞិ? តតោ យីឝុស្តាន៑ អវោចត៑, សត្យម៑; ស្តន្យបាយិឝិឝូនាញ្ច ពាលកានាញ្ច វក្ត្រតះ។ ស្វកីយំ មហិមានំ ត្វំ សំប្រកាឝយសិ ស្វយំ។ ឯតទ្វាក្យំ យូយំ កិំ នាបឋត? ");
INSERT INTO sankhm_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","តតស្តាន៑ វិហាយ ស នគរាទ៑ ពៃថនិយាគ្រាមំ គត្វា តត្រ រជនីំ យាបយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","អនន្តរំ ប្រភាតេ សតិ យីឝុះ បុនរបិ នគរមាគច្ឆន៑ ក្ឞុធាត៌្តោ ពភូវ។ ");
INSERT INTO sankhm_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","តតោ មាគ៌បាឝ៌្វ ឧឌុម្ពរវ្ឫក្ឞមេកំ វិលោក្យ តត្សមីបំ គត្វា បត្រាណិ វិនា កិមបិ ន ប្រាប្យ តំ បាទបំ ប្រោវាច, អទ្យារភ្យ កទាបិ ត្វយិ ផលំ ន ភវតុ; តេន តត្ក្ឞណាត៑ ស ឧឌុម្ពរមាហីរុហះ ឝុឞ្កតាំ គតះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","តទ៑ ទ្ឫឞ្ដ្វា ឝិឞ្យា អាឝ្ចយ៌្យំ វិជ្ញាយ កថយាមាសុះ, អាះ, ឧឌុម្វរបាទបោៜតិតូណ៌ំ ឝុឞ្កោៜភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","តតោ យីឝុស្តានុវាច, យុឞ្មានហំ សត្យំ វទាមិ, យទិ យូយមសន្ទិគ្ធាះ ប្រតីថ, តហ៌ិ យូយមបិ កេវលោឌុម្វរបាទបំ ប្រតីត្ថំ កត៌្តុំ ឝក្ឞ្យថ, តន្ន, ត្វំ ចលិត្វា សាគរេ បតេតិ វាក្យំ យុឞ្មាភិរស្មិន ឝៃលេ ប្រោក្តេបិ តទៃវ តទ៑ ឃដិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","តថា វិឝ្វស្យ ប្រាត៌្ហ្យ យុឞ្មាភិ រ្យទ៑ យាចិឞ្យតេ, តទេវ ប្រាប្ស្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","អនន្តរំ មន្ទិរំ ប្រវិឝ្យោបទេឝនសមយេ តត្សមីបំ ប្រធានយាជកាះ ប្រាចីនលោកាឝ្ចាគត្យ បប្រច្ឆុះ, ត្វយា កេន សាមត៌្ហ្យនៃតានិ កម៌្មាណិ ក្រិយន្តេ? កេន វា តុភ្យមេតានិ សាមត៌្ហ្យានិ ទត្តានិ? ");
INSERT INTO sankhm_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","តតោ យីឝុះ ប្រត្យវទត៑, អហមបិ យុឞ្មាន៑ វាចមេកាំ ប្ឫច្ឆាមិ, យទិ យូយំ តទុត្តរំ ទាតុំ ឝក្ឞ្យថ, តទា កេន សាមត៌្ហ្យេន កម៌្មាណ្យេតានិ ករោមិ, តទហំ យុឞ្មាន៑ វក្ឞ្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","យោហនោ មជ្ជនំ កស្យាជ្ញយាភវត៑? កិមីឝ្វរស្យ មនុឞ្យស្យ វា? តតស្តេ បរស្បរំ វិវិច្យ កថយាមាសុះ, យទីឝ្វរស្យេតិ វទាមស្តហ៌ិ យូយំ តំ កុតោ ន ប្រត្យៃត? វាចមេតាំ វក្ឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","មនុឞ្យស្យេតិ វក្តុមបិ លោកេភ្យោ ពិភីមះ, យតះ សវ៌្វៃរបិ យោហន៑ ភវិឞ្យទ្វាទីតិ ជ្ញាយតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","តស្មាត៑ តេ យីឝុំ ប្រត្យវទន៑, តទ៑ វយំ ន វិទ្មះ។ តទា ស តានុក្តវាន៑, តហ៌ិ កេន សាមរថ្យេន កម៌្មាណ្យេតាន្យហំ ករោមិ, តទប្យហំ យុឞ្មាន៑ ន វក្ឞ្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","កស្យចិជ្ជនស្យ ទ្វៅ សុតាវាស្តាំ ស ឯកស្យ សុតស្យ សមីបំ គត្វា ជគាទ, ហេ សុត, ត្វមទ្យ មម ទ្រាក្ឞាក្ឞេត្រេ កម៌្ម កត៌ុំ វ្រជ។ ");
INSERT INTO sankhm_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","តតះ ស ឧក្តវាន៑, ន យាស្យាមិ, កិន្តុ ឝេឞេៜនុតប្យ ជគាម។ ");
INSERT INTO sankhm_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","អនន្តរំ សោន្យសុតស្យ សមីបំ គត្វា តថៃវ កថ្តិវាន៑; តតះ ស ប្រត្យុវាច, មហេច្ឆ យាមិ, កិន្តុ ន គតះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","ឯតយោះ បុត្រយោ រ្មធ្យេ បិតុរភិមតំ កេន បាលិតំ? យុឞ្មាភិះ កិំ ពុធ្យតេ? តតស្តេ ប្រត្យូចុះ, ប្រថមេន បុुត្រេណ។ តទានីំ យីឝុស្តានុវាច, អហំ យុឞ្មាន៑ តថ្យំ វទាមិ, ចណ្ឌាលា គណិកាឝ្ច យុឞ្មាកមគ្រត ឦឝ្វរស្យ រាជ្យំ ប្រវិឝន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","យតោ យុឞ្មាកំ សមីបំ យោហនិ ធម៌្មបថេនាគតេ យូយំ តំ ន ប្រតីថ, កិន្តុ ចណ្ឌាលា គណិកាឝ្ច តំ ប្រត្យាយន៑, តទ៑ វិលោក្យាបិ យូយំ ប្រត្យេតុំ នាខិទ្យធ្វំ។ ");
INSERT INTO sankhm_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","អបរមេកំ ទ្ឫឞ្ដាន្តំ ឝ្ឫណុត, កឝ្ចិទ៑ គ្ឫហស្ថះ ក្ឞេត្រេ ទ្រាក្ឞាលតា រោបយិត្វា តច្ចតុទ៌ិក្ឞុ វារណីំ វិធាយ តន្មធ្យេ ទ្រាក្ឞាយន្ត្រំ ស្ថាបិតវាន៑, មាញ្ចញ្ច និម៌្មិតវាន៑, តតះ ក្ឫឞកេឞុ តត៑ ក្ឞេត្រំ សមប៌្យ ស្វយំ ទូរទេឝំ ជគាម។ ");
INSERT INTO sankhm_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","តទនន្តរំ ផលសមយ ឧបស្ថិតេ ស ផលានិ ប្រាប្តុំ ក្ឫឞីវលានាំ សមីបំ និជទាសាន៑ ប្រេឞយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","កិន្តុ ក្ឫឞីវលាស្តស្យ តាន៑ ទាសេយាន៑ ធ្ឫត្វា កញ្ចន ប្រហ្ឫតវន្តះ, កញ្ចន បាឞាណៃរាហតវន្តះ, កញ្ចន ច ហតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","បុនរបិ ស ប្រភុះ ប្រថមតោៜធិកទាសេយាន៑ ប្រេឞយាមាស, កិន្តុ តេ តាន៑ ប្រត្យបិ តថៃវ ចក្រុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","អនន្តរំ មម សុតេ គតេ តំ សមាទរិឞ្យន្តេ, ឥត្យុក្ត្វា ឝេឞេ ស និជសុតំ តេឞាំ សន្និធិំ ប្រេឞយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","កិន្តុ តេ ក្ឫឞីវលាះ សុតំ វីក្ឞ្យ បរស្បរម៑ ឥតិ មន្ត្រយិតុម៑ អារេភិរេ, អយមុត្តរាធិការី វយមេនំ និហត្យាស្យាធិការំ ស្វវឝីករិឞ្យាមះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","បឝ្ចាត៑ តេ តំ ធ្ឫត្វា ទ្រាក្ឞាក្ឞេត្រាទ៑ ពហិះ បាតយិត្វាពធិឞុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","យទា ស ទ្រាក្ឞាក្ឞេត្របតិរាគមិឞ្យតិ, តទា តាន៑ ក្ឫឞីវលាន៑ កិំ ករិឞ្យតិ? ");
INSERT INTO sankhm_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","តតស្តេ ប្រត្យវទន៑, តាន៑ កលុឞិណោ ទារុណយាតនាភិរាហនិឞ្យតិ, យេ ច សមយានុក្រមាត៑ ផលានិ ទាស្យន្តិ, តាទ្ឫឝេឞុ ក្ឫឞីវលេឞុ ក្ឞេត្រំ សមប៌យិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","តទា យីឝុនា តេ គទិតាះ, គ្រហណំ ន ក្ឫតំ យស្យ បាឞាណស្យ និចាយកៃះ។ ប្រធានប្រស្តរះ កោណេ សឯវ សំភវិឞ្យតិ។ ឯតត៑ បរេឝិតុះ កម៌្មាស្មទ្ឫឞ្ដាវទ្ភុតំ ភវេត៑។ ធម៌្មគ្រន្ថេ លិខិតមេតទ្វចនំ យុឞ្មាភិះ កិំ នាបាឋិ? ");
INSERT INTO sankhm_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","តស្មាទហំ យុឞ្មាន៑ វទាមិ, យុឞ្មត្ត ឦឝ្វរីយរាជ្យមបនីយ ផលោត្បាទយិត្រន្យជាតយេ ទាយិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","យោ ជន ឯតត្បាឞាណោបរិ បតិឞ្យតិ, តំ ស ភំក្ឞ្យតេ, កិន្ត្វយំ បាឞាណោ យស្យោបរិ បតិឞ្យតិ, តំ ស ធូលិវត៑ ចូណ៌ីករិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","តទានីំ ប្រាធនយាជកាះ ផិរូឝិនឝ្ច តស្យេមាំ ទ្ឫឞ្ដាន្តកថាំ ឝ្រុត្វា សោៜស្មានុទ្ទិឝ្យ កថិតវាន៑, ឥតិ វិជ្ញាយ តំ ធត៌្តុំ ចេឞ្ដិតវន្តះ; ");
INSERT INTO sankhm_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","កិន្តុ លោកេភ្យោ ពិភ្យុះ, យតោ លោកៃះ ស ភវិឞ្យទ្វាទីត្យជ្ញាយិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","អនន្តរំ យីឝុះ បុនរបិ ទ្ឫឞ្ដាន្តេន តាន៑ អវាទីត៑, ");
INSERT INTO sankhm_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","ស្វគ៌ីយរាជ្យម៑ ឯតាទ្ឫឝស្យ ន្ឫបតេះ សមំ, យោ និជ បុត្រំ វិវាហយន៑ សវ៌្វាន៑ និមន្ត្រិតាន៑ អានេតុំ ទាសេយាន៑ ប្រហិតវាន៑, ");
INSERT INTO sankhm_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","កិន្តុ តេ សមាគន្តុំ នេឞ្ដវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","តតោ រាជា បុនរបិ ទាសានន្យាន៑ ឥត្យុក្ត្វា ប្រេឞយាមាស, និមន្ត្រិតាន៑ វទត, បឝ្យត, មម ភេជ្យមាសាទិតមាស្តេ, និជវ្ដឞាទិបុឞ្ដជន្តូន៑ មារយិត្វា សវ៌្វំ ខាទ្យទ្រវ្យមាសាទិតវាន៑, យូយំ វិវាហមាគច្ឆត។ ");
INSERT INTO sankhm_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","តថបិ តេ តុច្ឆីក្ឫត្យ កេចិត៑ និជក្ឞេត្រំ កេចិទ៑ វាណិជ្យំ ប្រតិ ស្វស្វមាគ៌េណ ចលិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","អន្យេ លោកាស្តស្យ ទាសេយាន៑ ធ្ឫត្វា ទៅរាត្ម្យំ វ្យវហ្ឫត្យ តានវធិឞុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","អនន្តរំ ស ន្ឫបតិស្តាំ វាត៌្តាំ ឝ្រុត្វា ក្រុធ្យន៑ សៃន្យានិ ប្រហិត្យ តាន៑ ឃាតកាន៑ ហត្វា តេឞាំ នគរំ ទាហយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","តតះ ស និជទាសេយាន៑ ពភាឞេ, វិវាហីយំ ភោជ្យមាសាទិតមាស្តេ, កិន្តុ និមន្ត្រិតា ជនា អយោគ្យាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","តស្មាទ៑ យូយំ រាជមាគ៌ំ គត្វា យាវតោ មនុជាន៑ បឝ្យត, តាវតឯវ វិវាហីយភោជ្យាយ និមន្ត្រយត។ ");
INSERT INTO sankhm_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","តទា តេ ទាសេយា រាជមាគ៌ំ គត្វា ភទ្រាន៑ អភទ្រាន៑ វា យាវតោ ជនាន៑ ទទ្ឫឝុះ, តាវតឯវ សំគ្ឫហ្យានយន៑; តតោៜភ្យាគតមនុជៃ រ្វិវាហគ្ឫហម៑ អបូយ៌្យត។ ");
INSERT INTO sankhm_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","តទានីំ ស រាជា សវ៌្វានភ្យាគតាន៑ ទ្រឞ្ដុម៑ អភ្យន្តរមាគតវាន៑; តទា តត្រ វិវាហីយវសនហីនមេកំ ជនំ វីក្ឞ្យ តំ ជគាទ៑, ");
INSERT INTO sankhm_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ហេ មិត្រ,ត្វំ វិវាហីយវសនំ វិនា កថមត្រ ប្រវិឞ្ដវាន៑? តេន ស និរុត្តរោ ពភូវ។ ");
INSERT INTO sankhm_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","តទា រាជា និជានុចរាន៑ អវទត៑, ឯតស្យ ករចរណាន៑ ពទ្ធា យត្រ រោទនំ ទន្តៃទ៌ន្តឃឞ៌ណញ្ច ភវតិ, តត្រ វហិព៌្ហូតតមិស្រេ តំ និក្ឞិបត។ ");
INSERT INTO sankhm_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","ឥត្ថំ ពហវ អាហូតា អល្បេ មនោភិមតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","អនន្តរំ ផិរូឝិនះ ប្រគត្យ យថា សំលាបេន តម៑ ឧន្មាថេ បាតយេយុស្តថា មន្ត្រយិត្វា ");
INSERT INTO sankhm_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ហេរោទីយមនុជៃះ សាកំ និជឝិឞ្យគណេន តំ ប្រតិ កថយាមាសុះ, ហេ គុរោ, ភវាន៑ សត្យះ សត្យមីឝ្វរីយមាគ៌មុបទិឝតិ, កមបិ មានុឞំ នានុរុធ្យតេ, កមបិ នាបេក្ឞតេ ច, តទ៑ វយំ ជានីមះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","អតះ កៃសរភូបាយ ករោៜស្មាកំ ទាតវ្យោ ន វា? អត្រ ភវតា កិំ ពុធ្យតេ? តទ៑ អស្មាន៑ វទតុ។ ");
INSERT INTO sankhm_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","តតោ យីឝុស្តេឞាំ ខលតាំ វិជ្ញាយ កថិតវាន៑, រេ កបដិនះ យុយំ កុតោ មាំ បរិក្ឞធ្វេ? ");
INSERT INTO sankhm_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","តត្ករទានស្យ មុទ្រាំ មាំ ទឝ៌យត។ តទានីំ តៃស្តស្យ សមីបំ មុទ្រាចតុត៌្ហភាគ អានីតេ ");
INSERT INTO sankhm_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ស តាន៑ បប្រច្ឆ, អត្រ កស្យេយំ មូត៌្តិ រ្នាម ចាស្តេ? តេ ជគទុះ, កៃសរភូបស្យ។ ");
INSERT INTO sankhm_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","តតះ ស ឧក្តវាន, កៃសរស្យ យត៑ តត៑ កៃសរាយ ទត្ត, ឦឝ្វរស្យ យត៑ តទ៑ ឦឝ្វរាយ ទត្ត។ ");
INSERT INTO sankhm_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ឥតិ វាក្យំ និឝម្យ តេ វិស្មយំ វិជ្ញាយ តំ វិហាយ ចលិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","តស្មិន្នហនិ សិទូកិនោៜរ្ថាត៑ ឝ្មឝានាត៑ នោត្ថាស្យន្តីតិ វាក្យំ យេ វទន្តិ, តេ យីឝេाរន្តិកម៑ អាគត្យ បប្រច្ឆុះ, ");
INSERT INTO sankhm_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ហេ គុរោ, កឝ្ចិន្មនុជឝ្ចេត៑ និះសន្តានះ សន៑ ប្រាណាន៑ ត្យជតិ, តហ៌ិ តស្យ ភ្រាតា តស្យ ជាយាំ វ្យុហ្យ ភ្រាតុះ សន្តានម៑ ឧត្បាទយិឞ្យតីតិ មូសា អាទិឞ្ដវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","កិន្ត្វស្មាកមត្រ កេៜបិ ជនាះ សប្តសហោទរា អាសន៑, តេឞាំ ជ្យេឞ្ឋ ឯកាំ កន្យាំ វ្យវហាត៑, អបរំ ប្រាណត្យាគកាលេ ស្វយំ និះសន្តានះ សន៑ តាំ ស្ត្រិយំ ស្វភ្រាតរិ សមប៌ិតវាន៑, ");
INSERT INTO sankhm_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","តតោ ទ្វិតីយាទិសប្តមាន្តាឝ្ច តថៃវ ចក្រុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ឝេឞេ សាបី នារី មមារ។ ");
INSERT INTO sankhm_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","ម្ឫតានាម៑ ឧត្ថានសមយេ តេឞាំ សប្តានាំ មធ្យេ សា នារី កស្យ ភាយ៌្យា ភវិឞ្យតិ? យស្មាត៑ សវ៌្វឯវ តាំ វ្យវហន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","តតោ យីឝុះ ប្រត្យវាទីត៑, យូយំ ធម៌្មបុស្តកម៑ ឦឝ្វរីយាំ ឝក្តិញ្ច ន វិជ្ញាយ ភ្រាន្តិមន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","ឧត្ថានប្រាប្តា លោកា ន វិវហន្តិ, ន ច វាចា ទីយន្តេ, កិន្ត្វីឝ្វរស្យ ស្វគ៌ស្ថទូតានាំ សទ្ឫឝា ភវន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","អបរំ ម្ឫតានាមុត្ថានមធិ យុឞ្មាន៑ ប្រតីយមីឝ្វរោក្តិះ, ");
INSERT INTO sankhm_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","\"អហមិព្រាហីម ឦឝ្វរ ឥស្ហាក ឦឝ្វរោ យាកូព ឦឝ្វរ\" ឥតិ កិំ យុឞ្មាភិ រ្នាបាឋិ? កិន្ត្វីឝ្វរោ ជីវតាម៑ ឦឝ្វរ:, ស ម្ឫតានាមីឝ្វរោ នហិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ឥតិ ឝ្រុត្វា សវ៌្វេ លោកាស្តស្យោបទេឝាទ៑ វិស្មយំ គតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","អនន្តរំ សិទូកិនាម៑ និរុត្តរត្វវាត៌ាំ និឝម្យ ផិរូឝិន ឯកត្រ មិលិតវន្តះ, ");
INSERT INTO sankhm_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","តេឞាមេកោ វ្យវស្ថាបកោ យីឝុំ បរីក្ឞិតុំ បបច្ឆ, ");
INSERT INTO sankhm_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","ហេ គុរោ វ្យវស្ថាឝាស្ត្រមធ្យេ កាជ្ញា ឝ្រេឞ្ឋា? ");
INSERT INTO sankhm_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","តតោ យីឝុរុវាច, ត្វំ សវ៌្វាន្តះករណៃះ សវ៌្វប្រាណៃះ សវ៌្វចិត្តៃឝ្ច សាកំ ប្រភៅ បរមេឝ្វរេ ប្រីយស្វ, ");
INSERT INTO sankhm_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ឯឞា ប្រថមមហាជ្ញា។ តស្យាះ សទ្ឫឝី ទ្វិតីយាជ្ញៃឞា, ");
INSERT INTO sankhm_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","តវ សមីបវាសិនិ ស្វាត្មនីវ ប្រេម កុរុ។ ");
INSERT INTO sankhm_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","អនយោ រ្ទ្វយោរាជ្ញយោះ ក្ឫត្ស្នវ្យវស្ថាយា ភវិឞ្យទ្វក្ត្ឫគ្រន្ថស្យ ច ភារស្តិឞ្ឋតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","អនន្តរំ ផិរូឝិនាម៑ ឯកត្រ ស្ថិតិកាលេ យីឝុស្តាន៑ បប្រច្ឆ, ");
INSERT INTO sankhm_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","ខ្រីឞ្ដមធិ យុឞ្មាកំ កីទ្ឫគ្ពោធោ ជាយតេ? ស កស្យ សន្តានះ? តតស្តេ ប្រត្យវទន៑, ទាយូទះ សន្តានះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","តទា ស ឧក្តវាន៑, តហ៌ិ ទាយូទ៑ កថម៑ អាត្មាធិឞ្ឋានេន តំ ប្រភុំ វទតិ ? ");
INSERT INTO sankhm_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","យថា មម ប្រភុមិទំ វាក្យមវទត៑ បរមេឝ្វរះ។ តវារីន៑ បាទបីឋំ តេ យាវន្នហិ ករោម្យហំ។ តាវត៑ កាលំ មទីយេ ត្វំ ទក្ឞបាឝ៌្វ ឧបាវិឝ។ អតោ យទិ ទាយូទ៑ តំ ប្រភុំ វទតិ, រ្តិហ ស កថំ តស្យ សន្តានោ ភវតិ? ");
INSERT INTO sankhm_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","តទានីំ តេឞាំ កោបិ តទ្វាក្យស្យ កិមប្យុត្តរំ ទាតុំ នាឝក្នោត៑; ");
INSERT INTO sankhm_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","តទ្ទិនមារភ្យ តំ កិមបិ វាក្យំ ប្រឞ្ដុំ កស្យាបិ សាហសោ នាភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","អនន្តរំ យីឝុ រ្ជននិវហំ ឝិឞ្យាំឝ្ចាវទត៑, ");
INSERT INTO sankhm_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","អធ្យាបកាះ ផិរូឝិនឝ្ច មូសាសនេ ឧបវិឝន្តិ, ");
INSERT INTO sankhm_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","អតស្តេ យុឞ្មាន៑ យទ្យត៑ មន្តុម៑ អាជ្ញាបយន្តិ, តត៑ មន្យធ្វំ បាលយធ្វញ្ច, កិន្តុ តេឞាំ កម៌្មានុរូបំ កម៌្ម ន កុរុធ្វំ; យតស្តេឞាំ វាក្យមាត្រំ សារំ កាយ៌្យេ កិមបិ នាស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","តេ ទុវ៌្វហាន៑ គុរុតរាន៑ ភារាន៑ ពទ្វ្វា មនុឞ្យាណាំ ស្កន្ធេបរិ សមប៌យន្តិ, កិន្តុ ស្វយមង្គុល្យៃកយាបិ ន ចាលយន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","កេវលំ លោកទឝ៌នាយ សវ៌្វកម៌្មាណិ កុវ៌្វន្តិ; ផលតះ បដ្ដពន្ធាន៑ ប្រសាយ៌្យ ធារយន្តិ, ស្វវស្ត្រេឞុ ច ទីគ៌្ហគ្រន្ថីន៑ ធារយន្តិ; ");
INSERT INTO sankhm_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ភោជនភវន ឧច្ចស្ថានំ, ភជនភវនេ ប្រធានមាសនំ, ");
INSERT INTO sankhm_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ហដ្ឋេ នមស្ការំ គុរុរិតិ សម្ពោធនញ្ចៃតានិ សវ៌្វាណិ វាញ្ឆន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","កិន្តុ យូយំ គុរវ ឥតិ សម្ពោធនីយា មា ភវត, យតោ យុឞ្មាកម៑ ឯកះ ខ្រីឞ្ដឯវ គុរុ ");
INSERT INTO sankhm_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","រ្យូយំ សវ៌្វេ មិថោ ភ្រាតរឝ្ច។ បុនះ ប្ឫថិវ្យាំ កមបិ បិតេតិ មា សម្ពុធ្យធ្វំ, យតោ យុឞ្មាកមេកះ ស្វគ៌ស្ថឯវ បិតា។ ");
INSERT INTO sankhm_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","យូយំ នាយកេតិ សម្ភាឞិតា មា ភវត, យតោ យុឞ្មាកមេកះ ខ្រីឞ្ដឯវ នាយកះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","អបរំ យុឞ្មាកំ មធ្យេ យះ បុមាន៑ ឝ្រេឞ្ឋះ ស យុឞ្មាន៑ សេវិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","យតោ យះ ស្វមុន្នមតិ, ស នតះ ករិឞ្យតេ; កិន្តុ យះ កឝ្ចិត៑ ស្វមវនតំ ករោតិ, ស ឧន្នតះ ករិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","ហន្ត កបដិន ឧបាធ្យាយាះ ផិរូឝិនឝ្ច, យូយំ មនុជានាំ សមក្ឞំ ស្វគ៌ទ្វារំ រុន្ធ, យូយំ ស្វយំ តេន ន ប្រវិឝថ, ប្រវិវិក្ឞូនបិ វារយថ។ វត កបដិន ឧបាធ្យាយាះ ផិរូឝិនឝ្ច យូយំ ឆលាទ៑ ទីគ៌្ហំ ប្រាត៌្ហ្យ វិធវានាំ សវ៌្វស្វំ គ្រសថ, យុឞ្មាកំ ឃោរតរទណ្ឌោ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","ហន្ត កបដិន ឧបាធ្យាយាះ ផិរូឝិនឝ្ច, យូយមេកំ ស្វធម៌្មាវលម្ពិនំ កត៌្តុំ សាគរំ ភូមណ្ឌលញ្ច ប្រទក្ឞិណីកុរុថ, ");
INSERT INTO sankhm_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","កញ្ចន ប្រាប្យ ស្វតោ ទ្វិគុណនរកភាជនំ តំ កុរុថ។ ");
INSERT INTO sankhm_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","វត អន្ធបថទឝ៌កាះ សវ៌្វេ, យូយំ វទថ, មន្ទិរស្យ ឝបថករណាត៑ កិមបិ ន ទេយំ; កិន្តុ មន្ទិរស្ថសុវណ៌ស្យ ឝបថករណាទ៑ ទេយំ។ ");
INSERT INTO sankhm_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ហេ មូឍា ហេ អន្ធាះ សុវណ៌ំ តត្សុវណ៌បាវកមន្ទិរម៑ ឯតយោរុភយោ រ្មធ្យេ កិំ ឝ្រេយះ? ");
INSERT INTO sankhm_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","អន្យច្ច វទថ, យជ្ញវេទ្យាះ ឝបថករណាត៑ កិមបិ ន ទេយំ, កិន្តុ តទុបរិស្ថិតស្យ នៃវេទ្យស្យ ឝបថករណាទ៑ ទេយំ។ ");
INSERT INTO sankhm_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ហេ មូឍា ហេ អន្ធាះ, នៃវេទ្យំ តន្នៃវេទ្យបាវកវេទិរេតយោរុភយោ រ្មធ្យេ កិំ ឝ្រេយះ? ");
INSERT INTO sankhm_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","អតះ កេនចិទ៑ យជ្ញវេទ្យាះ ឝបថេ ក្ឫតេ តទុបរិស្ថស្យ សវ៌្វស្យ ឝបថះ ក្រិយតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","កេនចិត៑ មន្ទិរស្យ ឝបថេ ក្ឫតេ មន្ទិរតន្និវាសិនោះ ឝបថះ ក្រិយតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","កេនចិត៑ ស្វគ៌ស្យ ឝបថេ ក្ឫតេ ឦឝ្វរីយសិំហាសនតទុបយ៌្យុបវិឞ្ដយោះ ឝបថះ ក្រិយតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","ហន្ត កបដិន ឧបាធ្យាយាះ ផិរូឝិនឝ្ច, យូយំ បោទិនាយាះ សិតច្ឆត្រាយា ជីរកស្យ ច ទឝមាំឝាន៑ ទត្ថ, កិន្តុ វ្យវស្ថាយា គុរុតរាន៑ ន្យាយទយាវិឝ្វាសាន៑ បរិត្យជថ; ឥមេ យុឞ្មាភិរាចរណីយា អមី ច ន លំឃនីយាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ហេ អន្ធបថទឝ៌កា យូយំ មឝកាន៑ អបសារយថ, កិន្តុ មហាង្គាន៑ គ្រសថ។ ");
INSERT INTO sankhm_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","ហន្ត កបដិន ឧបាធ្យាយាះ ផិរូឝិនឝ្ច, យូយំ បានបាត្រាណាំ ភោជនបាត្រាណាញ្ច ពហិះ បរិឞ្កុរុថ; កិន្តុ តទភ្យន្តរំ ទុរាត្មតយា កលុឞេណ ច បរិបូណ៌មាស្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ហេ អន្ធាះ ផិរូឝិលោកា អាទៅ បានបាត្រាណាំ ភោជនបាត្រាណាញ្ចាភ្យន្តរំ បរិឞ្កុរុត, តេន តេឞាំ ពហិរបិ បរិឞ្ការិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","ហន្ត កបដិន ឧបាធ្យាយាះ ផិរូឝិនឝ្ច, យូយំ ឝុក្លីក្ឫតឝ្មឝានស្វរូបា ភវថ, យថា ឝ្មឝានភវនស្យ ពហិឝ្ចារុ, កិន្ត្វភ្យន្តរំ ម្ឫតលោកានាំ កីកឝៃះ សវ៌្វប្រការមលេន ច បរិបូណ៌ម៑; ");
INSERT INTO sankhm_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","តថៃវ យូយមបិ លោកានាំ សមក្ឞំ ពហិទ៌្ហាម៌្មិកាះ កិន្ត្វន្តះករណេឞុ កេវលកាបដ្យាធម៌្មាភ្យាំ បរិបូណ៌ាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","ហា ហា កបដិន ឧបាធ្យាយាះ ផិរូឝិនឝ្ច, យូយំ ភវិឞ្យទ្វាទិនាំ ឝ្មឝានគេហំ និម៌្មាថ, សាធូនាំ ឝ្មឝាននិកេតនំ ឝោភយថ ");
INSERT INTO sankhm_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","វទថ ច យទិ វយំ ស្វេឞាំ បូវ៌្វបុរុឞាណាំ កាល អស្ថាស្យាម, តហ៌ិ ភវិឞ្យទ្វាទិនាំ ឝោណិតបាតនេ តេឞាំ សហភាគិនោ នាភវិឞ្យាម។ ");
INSERT INTO sankhm_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","អតោ យូយំ ភវិឞ្យទ្វាទិឃាតកានាំ សន្តានា ឥតិ ស្វយមេវ ស្វេឞាំ សាក្ឞ្យំ ទត្ថ។ ");
INSERT INTO sankhm_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","អតោ យូយំ និជបូវ៌្វបុរុឞាណាំ បរិមាណបាត្រំ បរិបូរយត។ ");
INSERT INTO sankhm_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","រេ ភុជគាះ ក្ឫឞ្ណភុជគវំឝាះ, យូយំ កថំ នរកទណ្ឌាទ៑ រក្ឞិឞ្យធ្វេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","បឝ្យត, យុឞ្មាកមន្តិកម៑ អហំ ភវិឞ្យទ្វាទិនោ ពុទ្ធិមត ឧបាធ្យាយាំឝ្ច ប្រេឞយិឞ្យាមិ, កិន្តុ តេឞាំ កតិបយា យុឞ្មាភិ រ្ឃានិឞ្យន្តេ, ក្រុឝេ ច ឃានិឞ្យន្តេ, កេចិទ៑ ភជនភវនេ កឞាភិរាឃានិឞ្យន្តេ, នគរេ នគរេ តាឌិឞ្យន្តេ ច; ");
INSERT INTO sankhm_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","តេន សត្បុរុឞស្យ ហាពិលោ រក្តបាតមារភ្យ ពេរិខិយះ បុត្រំ យំ សិខរិយំ យូយំ មន្ទិរយជ្ញវេទ្យោ រ្មធ្យេ ហតវន្តះ, តទីយឝោណិតបាតំ យាវទ៑ អស្មិន៑ ទេឝេ យាវតាំ សាធុបុរុឞាណាំ ឝោណិតបាតោ ៜភវត៑ តត៑ សវ៌្វេឞាមាគសាំ ទណ្ឌា យុឞ្មាសុ វត៌្តិឞ្យន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","អហំ យុឞ្មាន្ត តថ្យំ វទាមិ, វិទ្យមានេៜស្មិន៑ បុរុឞេ សវ៌្វេ វត៌្តិឞ្យន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","ហេ យិរូឝាលម៑ ហេ យិរូឝាលម៑ នគរិ ត្វំ ភវិឞ្យទ្វាទិនោ ហតវតី, តវ សមីបំ ប្រេរិតាំឝ្ច បាឞាណៃរាហតវតី, យថា កុក្កុដី ឝាវកាន៑ បក្ឞាធះ សំគ្ឫហ្លាតិ, តថា តវ សន្តានាន៑ សំគ្រហីតុំ អហំ ពហុវារម៑ ឰច្ឆំ; កិន្តុ ត្វំ ន សមមន្យថាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","បឝ្យត យឞ្មាកំ វាសស្ថានម៑ ឧច្ឆិន្នំ ត្យក្ឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","អហំ យុឞ្មាន៑ តថ្យំ វទាមិ, យះ បរមេឝ្វរស្យ នាម្នាគច្ឆតិ, ស ធន្យ ឥតិ វាណីំ យាវន្ន វទិឞ្យថ, តាវត៑ មាំ បុន រ្ន ទ្រក្ឞ្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","អនន្តរំ យីឝុ រ្យទា មន្ទិរាទ៑ ពហិ រ្គច្ឆតិ, តទានីំ ឝិឞ្យាស្តំ មន្ទិរនិម៌្មាណំ ទឝ៌យិតុមាគតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","តតោ យីឝុស្តានុវាច, យូយំ កិមេតានិ ន បឝ្យថ? យុឞ្មានហំ សត្យំ វទាមិ, ឯតន្និចយនស្យ បាឞាណៃកមប្យន្យបាឞាណេाបរិ ន ស្ថាស្យតិ សវ៌្វាណិ ភូមិសាត៑ ការិឞ្យន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","អនន្តរំ តស្មិន៑ ជៃតុនបវ៌្វតោបរិ សមុបវិឞ្ដេ ឝិឞ្យាស្តស្យ សមីបមាគត្យ គុប្តំ បប្រច្ឆុះ, ឯតា ឃដនាះ កទា ភវិឞ្យន្តិ? ភវត អាគមនស្យ យុគាន្តស្យ ច កិំ លក្ឞ្ម? តទស្មាន៑ វទតុ។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","តទានីំ យីឝុស្តានវោចត៑, អវធទ្វ្វំ, កោបិ យុឞ្មាន៑ ន ភ្រមយេត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ពហវោ មម នាម គ្ឫហ្លន្ត អាគមិឞ្យន្តិ, ខ្រីឞ្ដោៜហមេវេតិ វាចំ វទន្តោ ពហូន៑ ភ្រមយិឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","យូយញ្ច សំគ្រាមស្យ រណស្យ ចាឌម្ពរំ ឝ្រោឞ្យថ, អវធទ្វ្វំ តេន ចញ្ចលា មា ភវត, ឯតាន្យវឝ្យំ ឃដិឞ្យន្តេ, កិន្តុ តទា យុគាន្តោ នហិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","អបរំ ទេឝស្យ វិបក្ឞោ ទេឝោ រាជ្យស្យ វិបក្ឞោ រាជ្យំ ភវិឞ្យតិ, ស្ថានេ ស្ថានេ ច ទុព៌្ហិក្ឞំ មហាមារី ភូកម្បឝ្ច ភវិឞ្យន្តិ, ");
INSERT INTO sankhm_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ឯតានិ ទុះខោបក្រមាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","តទានីំ លោកា ទុះខំ ភោជយិតុំ យុឞ្មាន៑ បរករេឞុ សមប៌យិឞ្យន្តិ ហនិឞ្យន្តិ ច, តថា មម នាមការណាទ៑ យូយំ សវ៌្វទេឝីយមនុជានាំ សមីបេ ឃ្ឫណាហ៌ា ភវិឞ្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","ពហុឞុ វិឃ្នំ ប្រាប្តវត្សុ បរស្បរម៑ ឫृតីយាំ ក្ឫតវត្សុ ច ឯកោៜបរំ បរករេឞុ សមប៌យិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","តថា ពហវោ ម្ឫឞាភវិឞ្យទ្វាទិន ឧបស្ថាយ ពហូន៑ ភ្រមយិឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","ទុឞ្កម៌្មណាំ ពាហុល្យាញ្ច ពហូនាំ ប្រេម ឝីតលំ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","កិន្តុ យះ កឝ្ចិត៑ ឝេឞំ យាវទ៑ ធៃយ៌្យមាឝ្រយតេ, សឯវ បរិត្រាយិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","អបរំ សវ៌្វទេឝីយលោកាន៑ ប្រតិមាក្ឞី ភវិតុំ រាជស្យ ឝុភសមាចារះ សវ៌្វជគតិ ប្រចារិឞ្យតេ, ឯតាទ្ឫឝិ សតិ យុគាន្ត ឧបស្ថាស្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","អតោ យត៑ សវ៌្វនាឝក្ឫទ្ឃ្ឫណាហ៌ំ វស្តុ ទានិយេល្ភវិឞ្យទ្វទិនា ប្រោក្តំ តទ៑ យទា បុណ្យស្ថានេ ស្ថាបិតំ ទ្រក្ឞ្យថ, (យះ បឋតិ, ស ពុធ្យតាំ) ");
INSERT INTO sankhm_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","តទានីំ យេ យិហូទីយទេឝេ តិឞ្ឋន្តិ, តេ បវ៌្វតេឞុ បលាយន្តាំ។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","យះ កឝ្ចិទ៑ គ្ឫហប្ឫឞ្ឋេ តិឞ្ឋតិ, ស គ្ឫហាត៑ កិមបិ វស្ត្វានេតុម៑ អធេा នាវរោហេត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","យឝ្ច ក្ឞេត្រេ តិឞ្ឋតិ, សោបិ វស្ត្រមានេតុំ បរាវ្ឫត្យ ន យាយាត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","តទានីំ គព៌្ហិណីស្តន្យបាយយិត្រីណាំ ទុគ៌តិ រ្ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","អតោ យឞ្មាកំ បលាយនំ ឝីតកាលេ វិឝ្រាមវារេ វា យន្ន ភវេត៑, តទត៌្ហំ ប្រាត៌្ហយធ្វម៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","អា ជគទារម្ភាទ៑ ឯតត្កាលបយ៌្យនន្តំ យាទ្ឫឝះ កទាបិ នាភវត៑ ន ច ភវិឞ្យតិ តាទ្ឫឝោ មហាក្លេឝស្តទានីម៑ ឧបស្ថាស្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","តស្យ ក្លេឝស្យ សមយោ យទិ ហ្ស្វោ ន ក្រិយេត, តហ៌ិ កស្យាបិ ប្រាណិនោ រក្ឞណំ ភវិតុំ ន ឝក្នុយាត៑, កិន្តុ មនោនីតមនុជានាំ ក្ឫតេ ស កាលោ ហ្ស្វីករិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","អបរញ្ច បឝ្យត, ខ្រីឞ្ដោៜត្រ វិទ្យតេ, វា តត្រ វិទ្យតេ, តទានីំ យទី កឝ្ចិទ៑ យុឞ្មាន ឥតិ វាក្យំ វទតិ, តថាបិ តត៑ ន ប្រតីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","យតោ ភាក្តខ្រីឞ្ដា ភាក្តភវិឞ្យទ្វាទិនឝ្ច ឧបស្ថាយ យានិ មហន្តិ លក្ឞ្មាណិ ចិត្រកម៌្មាណិ ច ប្រកាឝយិឞ្យន្តិ, តៃ រ្យទិ សម្ភវេត៑ តហ៌ិ មនោនីតមានវា អបិ ភ្រាមិឞ្យន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","បឝ្យត, ឃដនាតះ បូវ៌្វំ យុឞ្មាន៑ វាត៌្តាម៑ អវាទិឞម៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","អតះ បឝ្យត, ស ប្រាន្តរេ វិទ្យត ឥតិ វាក្យេ កេនចិត៑ កថិតេបិ ពហិ រ្មា គច្ឆត, វា បឝ្យត, សោន្តះបុរេ វិទ្យតេ, ឯតទ្វាក្យ ឧក្តេបិ មា ប្រតីត។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","យតោ យថា វិទ្យុត៑ បូវ៌្វទិឝោ និគ៌ត្យ បឝ្ចិមទិឝំ យាវត៑ ប្រកាឝតេ, តថា មានុឞបុត្រស្យាប្យាគមនំ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","យត្រ ឝវស្តិឞ្ឋតិ, តត្រេវ គ្ឫធ្រា មិលន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","អបរំ តស្យ ក្លេឝសមយស្យាវ្យវហិតបរត្រ សូយ៌្យស្យ តេជោ លោប្ស្យតេ, ចន្ទ្រមា ជ្យោស្នាំ ន ករិឞ្យតិ, នភសោ នក្ឞត្រាណិ បតិឞ្យន្តិ, គគណីយា គ្រហាឝ្ច វិចលិឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","តទានីម៑ អាកាឝមធ្យេ មនុជសុតស្យ លក្ឞ្ម ទឝ៌ិឞ្យតេ, តតោ និជបរាក្រមេណ មហាតេជសា ច មេឃារូឍំ មនុជសុតំ នភសាគច្ឆន្តំ វិលោក្យ ប្ឫថិវ្យាះ សវ៌្វវំឝីយា វិលបិឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","តទានីំ ស មហាឝព្ទាយមានតូយ៌្យា វាទកាន៑ និជទូតាន៑ ប្រហេឞ្យតិ, តេ វ្យោម្ន ឯកសីមាតោៜបរសីមាំ យាវត៑ ចតុទ៌ិឝស្តស្យ មនោនីតជនាន៑ អានីយ មេលយិឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","ឧឌុម្ពរបាទបស្យ ទ្ឫឞ្ដាន្តំ ឝិក្ឞធ្វំ; យទា តស្យ នវីនាះ ឝាខា ជាយន្តេ, បល្លវាទិឝ្ច និគ៌ច្ឆតិ, តទា និទាឃកាលះ សវិធោ ភវតីតិ យូយំ ជានីថ; ");
INSERT INTO sankhm_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","តទ្វទ៑ ឯតា ឃដនា ទ្ឫឞ្ដ្វា ស សមយោ ទ្វារ ឧបាស្ថាទ៑ ឥតិ ជានីត។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","យុឞ្មានហំ តថ្យំ វទាមិ, ឥទានីន្តនជនានាំ គមនាត៑ បូវ៌្វមេវ តានិ សវ៌្វាណិ ឃដិឞ្យន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","នភោមេទិន្យោ រ្លុប្តយោរបិ មម វាក៑ កទាបិ ន លោប្ស្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","អបរំ មម តាតំ វិនា មានុឞះ ស្វគ៌ស្ថោ ទូតោ វា កោបិ តទ្ទិនំ តទ្ទណ្ឌញ្ច ន ជ្ញាបយតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","អបរំ នោហេ វិទ្យមានេ យាទ្ឫឝមភវត៑ តាទ្ឫឝំ មនុជសុតស្យាគមនកាលេបិ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ផលតោ ជលាប្លាវនាត៑ បូវ៌្វំ យទ្ទិនំ យាវត៑ នោហះ បោតំ នារោហត៑, តាវត្កាលំ យថា មនុឞ្យា ភោជនេ បានេ វិវហនេ វិវាហនេ ច ប្រវ្ឫត្តា អាសន៑; ");
INSERT INTO sankhm_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","អបរម៑ អាប្លាវិតោយមាគត្យ យាវត៑ សកលមនុជាន៑ ប្លាវយិត្វា នានយត៑, តាវត៑ តេ យថា ន វិទាមាសុះ, តថា មនុជសុតាគមនេបិ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","តទា ក្ឞេត្រស្ថិតយោទ៌្វយោរេកោ ធារិឞ្យតេ, អបរស្ត្យាជិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","តថា បេឞណ្យា បិំឞត្យោរុភយោ រ្យោឞិតោរេកា ធារិឞ្យតេៜបរា ត្យាជិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","យុឞ្មាកំ ប្រភុះ កស្មិន៑ ទណ្ឌ អាគមិឞ្យតិ, តទ៑ យុឞ្មាភិ រ្នាវគម្យតេ, តស្មាត៑ ជាគ្រតះ សន្តស្តិឞ្ឋត។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","កុត្រ យាមេ ស្តេន អាគមិឞ្យតីតិ ចេទ៑ គ្ឫហស្ថោ ជ្ញាតុម៑ អឝក្ឞ្យត៑, តហ៌ិ ជាគរិត្វា តំ សន្ធិំ កត៌្តិតុម៑ អវារយិឞ្យត៑ តទ៑ ជានីត។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","យុឞ្មាភិរវធីយតាំ, យតោ យុឞ្មាភិ រ្យត្រ ន ពុធ្យតេ, តត្រៃវ ទណ្ឌេ មនុជសុត អាយាស្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","ប្រភុ រ្និជបរិវារាន៑ យថាកាលំ ភោជយិតុំ យំ ទាសម៑ អធ្យក្ឞីក្ឫត្យ ស្ថាបយតិ, តាទ្ឫឝោ វិឝ្វាស្យោ ធីមាន៑ ទាសះ កះ? ");
INSERT INTO sankhm_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ប្រភុរាគត្យ យំ ទាសំ តថាចរន្តំ វីក្ឞតេ, សឯវ ធន្យះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","យុឞ្មានហំ សត្យំ វទាមិ, ស តំ និជសវ៌្វស្វស្យាធិបំ ករិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","កិន្តុ ប្រភុរាគន្តុំ វិលម្ពត ឥតិ មនសិ ចិន្តយិត្វា យោ ទុឞ្ដោ ទាសោ ");
INSERT INTO sankhm_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ៜបរទាសាន៑ ប្រហត៌្តុំ មត្តានាំ សង្គេ ភោក្តុំ បាតុញ្ច ប្រវត៌្តតេ, ");
INSERT INTO sankhm_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ស ទាសោ យទា នាបេក្ឞតេ, យញ្ច ទណ្ឌំ ន ជានាតិ, តត្កាលឯវ តត្ប្រភុរុបស្ថាស្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","តទា តំ ទណ្ឌយិត្វា យត្រ ស្ថានេ រោទនំ ទន្តឃឞ៌ណញ្ចាសាតេ, តត្រ កបដិភិះ សាកំ តទ្ទឝាំ និរូបយិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","យា ទឝ កន្យាះ ប្រទីបាន៑ គ្ឫហ្លត្យោ វរំ សាក្ឞាត៑ កត៌្តុំ ពហិរិតាះ, តាភិស្តទា ស្វគ៌ីយរាជ្យស្យ សាទ្ឫឝ្យំ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","តាសាំ កន្យានាំ មធ្យេ បញ្ច សុធិយះ បញ្ច ទុទ៌្ហិយ អាសន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","យា ទុទ៌្ហិយស្តាះ ប្រទីបាន៑ សង្គេ គ្ឫហីត្វា តៃលំ ន ជគ្ឫហុះ, ");
INSERT INTO sankhm_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","កិន្តុ សុធិយះ ប្រទីបាន៑ បាត្រេណ តៃលញ្ច ជគ្ឫហុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","អនន្តរំ វរេ វិលម្ពិតេ តាះ សវ៌្វា និទ្រាវិឞ្ដា និទ្រាំ ជគ្មុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","អនន្តរម៑ អទ៌្ធរាត្រេ បឝ្យត វរ អាគច្ឆតិ, តំ សាក្ឞាត៑ កត៌្តុំ ពហិយ៌ាតេតិ ជនរវាត្ ");
INSERT INTO sankhm_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","តាះ សវ៌្វាះ កន្យា ឧត្ថាយ ប្រទីបាន៑ អាសាទយិតុំ អារភន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","តតោ ទុទ៌្ហិយះ សុធិយ ឩចុះ, កិញ្ចិត៑ តៃលំ ទត្ត, ប្រទីបា អស្មាកំ និវ៌្វាណាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","កិន្តុ សុធិយះ ប្រត្យវទន៑, ទត្តេ យុឞ្មានស្មាំឝ្ច ប្រតិ តៃលំ ន្យូនីភវេត៑, តស្មាទ៑ វិក្រេត្ឫណាំ សមីបំ គត្វា ស្វាត៌្ហំ តៃលំ ក្រីណីត។ ");
INSERT INTO sankhm_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","តទា តាសុ ក្រេតុំ គតាសុ វរ អាជគាម, តតោ យាះ សជ្ជិតា អាសន៑, តាស្តេន សាកំ វិវាហីយំ វេឝ្ម ប្រវិវិឝុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","អនន្តរំ ទ្វារេ រុទ្ធេ អបរាះ កន្យា អាគត្យ ជគទុះ, ហេ ប្រភោ, ហេ ប្រភោ, អស្មាន៑ ប្រតិ ទ្វារំ មោចយ។ ");
INSERT INTO sankhm_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","កិន្តុ ស ឧក្តវាន៑, តថ្យំ វទាមិ, យុឞ្មានហំ ន វេទ្មិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","អតោ ជាគ្រតះ សន្តស្តិឞ្ឋត, មនុជសុតះ កស្មិន៑ ទិនេ កស្មិន៑ ទណ្ឌេ វាគមិឞ្យតិ, តទ៑ យុឞ្មាភិ រ្ន ជ្ញាយតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","អបរំ ស ឯតាទ្ឫឝះ កស្យចិត៑ បុំសស្តុល្យះ, យោ ទូរទេឝំ ប្រតិ យាត្រាកាលេ និជទាសាន៑ អាហូយ តេឞាំ ស្វស្វសាមត៌្ហ្យានុរូបម្ ");
INSERT INTO sankhm_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ឯកស្មិន៑ មុទ្រាណាំ បញ្ច បោដលិកាះ អន្យស្មិំឝ្ច ទ្វេ បោដលិកេ អបរស្មិំឝ្ច បោដលិកៃកាម៑ ឥត្ថំ ប្រតិជនំ សមប៌្យ ស្វយំ ប្រវាសំ គតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","អនន្តរំ យោ ទាសះ បញ្ច បោដលិកាះ លព្ធវាន៑, ស គត្វា វាណិជ្យំ វិធាយ តា ទ្វិគុណីចការ។ ");
INSERT INTO sankhm_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","យឝ្ច ទាសោ ទ្វេ បោដលិកេ អលភត, សោបិ តា មុទ្រា ទ្វិគុណីចការ។ ");
INSERT INTO sankhm_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","កិន្តុ យោ ទាស ឯកាំ បោដលិកាំ លព្ធវាន៑, ស គត្វា ភូមិំ ខនិត្វា តន្មធ្យេ និជប្រភោស្តា មុទ្រា គោបយាញ្ចការ។ ");
INSERT INTO sankhm_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","តទនន្តរំ ពហុតិថេ កាលេ គតេ តេឞាំ ទាសានាំ ប្រភុរាគត្យ តៃទ៌ាសៃះ សមំ គណយាញ្ចការ។ ");
INSERT INTO sankhm_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","តទានីំ យះ បញ្ច បោដលិកាះ ប្រាប្តវាន៑ ស តា ទ្វិគុណីក្ឫតមុទ្រា អានីយ ជគាទ; ហេ ប្រភោ, ភវតា មយិ បញ្ច បោដលិកាះ សមប៌ិតាះ, បឝ្យតុ, តា មយា ទ្វិគុណីក្ឫតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","តទានីំ តស្យ ប្រភុស្តមុវាច, ហេ ឧត្តម វិឝ្វាស្យ ទាស, ត្វំ ធន្យោសិ, ស្តោកេន វិឝ្វាស្យោ ជាតះ, តស្មាត៑ ត្វាំ ពហុវិត្តាធិបំ ករោមិ, ត្វំ ស្វប្រភោះ សុខស្យ ភាគី ភវ។ ");
INSERT INTO sankhm_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","តតោ យេន ទ្វេ បោដលិកេ លព្ធេ សោប្យាគត្យ ជគាទ, ហេ ប្រភោ, ភវតា មយិ ទ្វេ បោដលិកេ សមប៌ិតេ, បឝ្យតុ តេ មយា ទ្វិគុណីក្ឫតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","តេន តស្យ ប្រភុស្តមវោចត៑, ហេ ឧត្តម វិឝ្វាស្យ ទាស, ត្វំ ធន្យោសិ, ស្តោកេន វិឝ្វាស្យោ ជាតះ, តស្មាត៑ ត្វាំ ពហុទ្រវិណាធិបំ ករោមិ, ត្វំ និជប្រភោះ សុខស្យ ភាគី ភវ។ ");
INSERT INTO sankhm_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","អនន្តរំ យ ឯកាំ បោដលិកាំ លព្ធវាន៑, ស ឯត្យ កថិតវាន៑, ហេ ប្រភោ, ត្វាំ កឋិននរំ ជ្ញាតវាន៑, ត្វយា យត្រ នោប្តំ, តត្រៃវ ក្ឫត្យតេ, យត្រ ច ន កីណ៌ំ, តត្រៃវ សំគ្ឫហ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","អតោហំ សឝង្កះ សន៑ គត្វា តវ មុទ្រា ភូមធ្យេ សំគោប្យ ស្ថាបិតវាន៑, បឝ្យ, តវ យត៑ តទេវ គ្ឫហាណ។ ");
INSERT INTO sankhm_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","តទា តស្យ ប្រភុះ ប្រត្យវទត៑ រេ ទុឞ្ដាលស ទាស, យត្រាហំ ន វបាមិ, តត្រ ឆិនទ្មិ, យត្រ ច ន កិរាមិ, តត្រេវ សំគ្ឫហ្លាមីតិ ចេទជានាស្តហ៌ិ ");
INSERT INTO sankhm_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","វណិក្ឞុ មម វិត្តាប៌ណំ តវោចិតមាសីត៑, យេនាហមាគត្យ វ្ឫទ្វ្យា សាកំ មូលមុទ្រាះ ប្រាប្ស្យម៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","អតោស្មាត៑ តាំ បោដលិកាម៑ អាទាយ យស្យ ទឝ បោដលិកាះ សន្តិ តស្មិន្នប៌យត។ ");
INSERT INTO sankhm_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","យេន វទ៌្វ្យតេ តស្មិន្នៃវាប៌ិឞ្យតេ, តស្យៃវ ច ពាហុល្យំ ភវិឞ្យតិ, កិន្តុ យេន ន វទ៌្វ្យតេ, តស្យាន្តិកេ យត៑ កិញ្ចន តិឞ្ឋតិ, តទបិ បុនន៌េឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","អបរំ យូយំ តមកម៌្មណ្យំ ទាសំ នីត្វា យត្រ ស្ថានេ ក្រន្ទនំ ទន្តឃឞ៌ណញ្ច វិទ្យេតេ, តស្មិន៑ ពហិព៌្ហូតតមសិ និក្ឞិបត។ ");
INSERT INTO sankhm_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","យទា មនុជសុតះ បវិត្រទូតាន៑ សង្គិនះ ក្ឫត្វា និជប្រភាវេនាគត្យ និជតេជោមយេ សិំហាសនេ និវេក្ឞ្យតិ, ");
INSERT INTO sankhm_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","តទា តត្សម្មុខេ សវ៌្វជាតីយា ជនា សំមេលិឞ្យន្តិ។ តតោ មេឞបាលកោ យថា ឆាគេភ្យោៜវីន៑ ប្ឫថក៑ ករោតិ តថា សោប្យេកស្មាទន្យម៑ ឥត្ថំ តាន៑ ប្ឫថក ក្ឫត្វាវីន្ ");
INSERT INTO sankhm_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ទក្ឞិណេ ឆាគាំឝ្ច វាមេ ស្ថាបយិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","តតះ បរំ រាជា ទក្ឞិណស្ថិតាន៑ មានវាន៑ វទិឞ្យតិ, អាគច្ឆត មត្តាតស្យានុគ្រហភាជនានិ, យុឞ្មត្ក្ឫត អា ជគទារម្ភត៑ យទ៑ រាជ្យម៑ អាសាទិតំ តទធិកុរុត។ ");
INSERT INTO sankhm_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","យតោ ពុភុក្ឞិតាយ មហ្យំ ភោជ្យម៑ អទត្ត, បិបាសិតាយ បេយមទត្ត, វិទេឝិនំ មាំ ស្វស្ថានមនយត, ");
INSERT INTO sankhm_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","វស្ត្រហីនំ មាំ វសនំ បយ៌្យធាបយត, បីឌីតំ មាំ ទ្រឞ្ដុមាគច្ឆត, ការាស្ថញ្ច មាំ វីក្ឞិតុម អាគច្ឆត។ ");
INSERT INTO sankhm_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","តទា ធាម៌្មិកាះ ប្រតិវទិឞ្យន្តិ, ហេ ប្រភោ, កទា ត្វាំ ក្ឞុធិតំ វីក្ឞ្យ វយមភោជយាម? វា បិបាសិតំ វីក្ឞ្យ អបាយយាម? ");
INSERT INTO sankhm_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","កទា វា ត្វាំ វិទេឝិនំ វិលោក្យ ស្វស្ថានមនយាម? កទា វា ត្វាំ នគ្នំ វីក្ឞ្យ វសនំ បយ៌្យធាបយាម? ");
INSERT INTO sankhm_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","កទា វា ត្វាំ បីឌិតំ ការាស្ថញ្ច វីក្ឞ្យ ត្វទន្តិកមគច្ឆាម? ");
INSERT INTO sankhm_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","តទានីំ រាជា តាន៑ ប្រតិវទិឞ្យតិ, យុឞ្មានហំ សត្យំ វទាមិ, មមៃតេឞាំ ភ្រាត្ឫណាំ មធ្យេ កញ្ចនៃកំ ក្ឞុទ្រតមំ ប្រតិ យទ៑ អកុរុត, តន្មាំ ប្រត្យកុរុត។ ");
INSERT INTO sankhm_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","បឝ្ចាត៑ ស វាមស្ថិតាន៑ ជនាន៑ វទិឞ្យតិ, រេ ឝាបគ្រស្តាះ សវ៌្វេ, ឝៃតានេ តស្យ ទូតេភ្យឝ្ច យោៜនន្តវហ្និរាសាទិត អាស្តេ, យូយំ មទន្តិកាត៑ តមគ្និំ គច្ឆត។ ");
INSERT INTO sankhm_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","យតោ ក្ឞុធិតាយ មហ្យមាហារំ នាទត្ត, បិបាសិតាយ មហ្យំ បេយំ នាទត្ត, ");
INSERT INTO sankhm_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","វិទេឝិនំ មាំ ស្វស្ថានំ នានយត, វសនហីនំ មាំ វសនំ ន បយ៌្យធាបយត, បីឌិតំ ការាស្ថញ្ច មាំ វីក្ឞិតុំ នាគច្ឆត។ ");
INSERT INTO sankhm_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","តទា តេ ប្រតិវទិឞ្យន្តិ, ហេ ប្រភោ, កទា ត្វាំ ក្ឞុធិតំ វា បិបាសិតំ វា វិទេឝិនំ វា នគ្នំ វា បីឌិតំ វា ការាស្ថំ វីក្ឞ្យ ត្វាំ នាសេវាមហិ? ");
INSERT INTO sankhm_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","តទា ស តាន៑ វទិឞ្យតិ, តថ្យមហំ យុឞ្មាន៑ ព្រវីមិ, យុឞ្មាភិរេឞាំ កញ្ចន ក្ឞោទិឞ្ឋំ ប្រតិ យន្នាការិ, តន្មាំ ប្រត្យេវ នាការិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","បឝ្ចាទម្យនន្តឝាស្តិំ កិន្តុ ធាម៌្មិកា អនន្តាយុឞំ ភោក្តុំ យាស្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","យីឝុរេតាន៑ ប្រស្តាវាន៑ សមាប្យ ឝិឞ្យានូចេ, ");
INSERT INTO sankhm_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","យុឞ្មាភិ រ្ជ្ញាតំ ទិនទ្វយាត៑ បរំ និស្តារមហ ឧបស្ថាស្យតិ, តត្រ មនុជសុតះ ក្រុឝេន ហន្តុំ បរករេឞុ សមប៌ិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","តតះ បរំ ប្រធានយាជកាធ្យាបកប្រាញ្ចះ កិយផានាម្នោ មហាយាជកស្យាដ្ដាលិកាយាំ មិលិត្វា ");
INSERT INTO sankhm_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","កេនោបាយេន យីឝុំ ធ្ឫត្វា ហន្តុំ ឝក្នុយុរិតិ មន្ត្រយាញ្ចក្រុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","កិន្តុ តៃរុក្តំ មហកាលេ ន ធត៌្តវ្យះ, ធ្ឫតេ ប្រជានាំ កលហេន ភវិតុំ ឝក្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","តតោ ពៃថនិយាបុរេ ឝិមោនាខ្យស្យ កុឞ្ឋិនោ វេឝ្មនិ យីឝៅ តិឞ្ឋតិ ");
INSERT INTO sankhm_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","កាចន យោឞា ឝ្វេតោបលភាជនេន មហាគ៌្ហ្យំ សុគន្ធិ តៃលមានីយ ភោជនាយោបវិឝតស្តស្យ ឝិរោភ្យឞេចត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","កិន្តុ តទាលោក្យ តច្ឆិឞ្យៃះ កុបិតៃរុក្តំ, កុត ឥត្ថមបវ្យយតេ? ");
INSERT INTO sankhm_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ចេទិទំ វ្យក្រេឞ្យត, តហ៌ិ ភូរិមូល្យំ ប្រាប្យ ទរិទ្រេភ្យោ វ្យតារិឞ្យត។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","យីឝុនា តទវគត្យ តេ សមុទិតាះ, យោឞាមេនាំ កុតោ ទុះខិនីំ កុរុថ, សា មាំ ប្រតិ សាធុ កម៌្មាកាឞ៌ីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","យុឞ្មាកមំ សមីបេ ទរិទ្រាះ សតតមេវាសតេ, កិន្តុ យុឞ្មាកមន្តិកេហំ នាសេ សតតំ។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","សា មម កាយោបរិ សុគន្ធិតៃលំ សិក្ត្វា មម ឝ្មឝានទានកម៌្មាកាឞ៌ីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","អតោហំ យុឞ្មាន៑ តថ្យំ វទាមិ សវ៌្វស្មិន៑ ជគតិ យត្រ យត្រៃឞ សុសមាចារះ ប្រចារិឞ្យតេ, តត្រ តត្រៃតស្យា នាយ៌្យាះ ស្មរណាត៌្ហម៑ កម៌្មេទំ ប្រចារិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","តតោ ទ្វាទឝឝិឞ្យាណាម៑ ឦឞ្ករិយោតីយយិហូទានាមក ឯកះ ឝិឞ្យះ ប្រធានយាជកានាមន្តិកំ គត្វា កថិតវាន៑, ");
INSERT INTO sankhm_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","យទិ យុឞ្មាកំ ករេឞុ យីឝុំ សមប៌យាមិ, តហ៌ិ កិំ ទាស្យថ? តទានីំ តេ តស្មៃ ត្រិំឝន្មុទ្រា ទាតុំ ស្ថិរីក្ឫតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ស តទារភ្យ តំ បរករេឞុ សមប៌យិតុំ សុយោគំ ចេឞ្ដិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","អនន្តរំ កិណ្វឝូន្យបូបបវ៌្វណះ ប្រថមេហ្និ ឝិឞ្យា យីឝុម៑ ឧបគត្យ បប្រច្ឆុះ ភវត្ក្ឫតេ កុត្រ វយំ និស្តារមហភោជ្យម៑ អាយោជយិឞ្យាមះ? ភវតះ កេច្ឆា? ");
INSERT INTO sankhm_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","តទា ស គទិតវាន៑, មធ្យេនគរមមុកបុំសះ សមីបំ វ្រជិត្វា វទត, គុរុ រ្គទិតវាន៑, មត្កាលះ សវិធះ, សហ ឝិឞ្យៃស្ត្វទាលយេ និស្តារមហភោជ្យំ ភោក្ឞ្យេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","តទា ឝិឞ្យា យីឝោស្តាទ្ឫឝនិទេឝានុរូបកម៌្ម វិធាយ តត្រ និស្តារមហភោជ្យមាសាទយាមាសុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","តតះ សន្ធ្យាយាំ សត្យាំ ទ្វាទឝភិះ ឝិឞ្យៃះ សាកំ ស ន្យវិឝត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","អបរំ ភុញ្ជាន ឧក្តវាន៑ យុឞ្មាន៑ តថ្យំ វទាមិ, យុឞ្មាកមេកោ មាំ បរករេឞុ សមប៌យិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","តទា តេៜតីវ ទុះខិតា ឯកៃកឝោ វក្តុមារេភិរេ, ហេ ប្រភោ, ស កិមហំ? ");
INSERT INTO sankhm_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","តតះ ស ជគាទ, មយា សាកំ យោ ជនោ ភោជនបាត្រេ ករំ សំក្ឞិបតិ, ស ឯវ មាំ បរករេឞុ សមប៌យិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","មនុជសុតមធិ យាទ្ឫឝំ លិខិតមាស្តេ, តទនុរូបា តទ្គតិ រ្ភវិឞ្យតិ; កិន្តុ យេន បុំសា ស បរករេឞុ សមប៌យិឞ្យតេ, ហា ហា ចេត៑ ស នាជនិឞ្យត, តទា តស្យ ក្ឞេមមភវិឞ្យត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","តទា យិហូទានាមា យោ ជនស្តំ បរករេឞុ សមប៌យិឞ្យតិ, ស ឧក្តវាន៑, ហេ គុរោ, ស កិមហំ? តតះ ស ប្រត្យុក្តវាន៑, ត្វយា សត្យំ គទិតម៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","អនន្តរំ តេឞាមឝនកាលេ យីឝុះ បូបមាទាយេឝ្វរីយគុណាននូទ្យ ភំក្ត្វា ឝិឞ្យេភ្យះ ប្រទាយ ជគាទ, មទ្វបុះស្វរូបមិមំ គ្ឫហីត្វា ខាទត។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","បឝ្ចាត៑ ស កំសំ គ្ឫហ្លន៑ ឦឝ្វរីយគុណាននូទ្យ តេភ្យះ ប្រទាយ កថិតវាន៑, សវ៌្វៃ រ្យុឞ្មាភិរនេន បាតវ្យំ, ");
INSERT INTO sankhm_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","យស្មាទនេកេឞាំ បាបមឞ៌ណាយ បាតិតំ យន្មន្នូត្ននិយមរូបឝោណិតំ តទេតត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","អបរមហំ នូត្នគោស្តនីរសំ ន បាស្យាមិ, តាវត៑ គោស្តនីផលរសំ បុនះ កទាបិ ន បាស្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","បឝ្ចាត៑ តេ គីតមេកំ សំគីយ ជៃតុនាខ្យគិរិំ គតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","តទានីំ យីឝុស្តានវោចត៑, អស្យាំ រជន្យាមហំ យុឞ្មាកំ សវ៌្វេឞាំ វិឃ្នរូបោ ភវិឞ្យាមិ, យតោ លិខិតមាស្តេ, \"មេឞាណាំ រក្ឞកោ យស្តំ ប្រហរិឞ្យាម្យហំ តតះ។ មេឞាណាំ និវហោ នូនំ ប្រវិកីណ៌ោ ភវិឞ្យតិ\"៕ ");
INSERT INTO sankhm_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","កិន្តុ ឝ្មឝានាត៑ សមុត្ថាយ យុឞ្មាកមគ្រេៜហំ គាលីលំ គមិឞ្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","បិតរស្តំ ប្រោវាច, ភវាំឝ្ចេត៑ សវ៌្វេឞាំ វិឃ្នរូបោ ភវតិ, តថាបិ មម ន ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","តតោ យីឝុនា ស ឧក្តះ, តុភ្យមហំ តថ្យំ កថយាមិ, យាមិន្យាមស្យាំ ចរណាយុធស្យ រវាត៑ បូវ៌្វំ ត្វំ មាំ ត្រិ រ្នាង្គីករិឞ្យសិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","តតះ បិតរ ឧទិតវាន៑, យទ្យបិ ត្វយា សមំ មត៌្តវ្យំ, តថាបិ កទាបិ ត្វាំ ន នាង្គីករិឞ្យាមិ; តថៃវ សវ៌្វេ ឝិឞ្យាឝ្ចោចុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","អនន្តរំ យីឝុះ ឝិឞ្យៃះ សាកំ គេត្ឝិមានីនាមកំ ស្ថានំ ប្រស្ថាយ តេភ្យះ កថិតវាន៑, អទះ ស្ថានំ គត្វា យាវទហំ ប្រាត៌្ហយិឞ្យេ តាវទ៑ យូយមត្រោបវិឝត។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","បឝ្ចាត៑ ស បិតរំ សិវទិយសុតៅ ច សង្គិនះ ក្ឫត្វា គតវាន៑, ឝោកាកុលោៜតីវ វ្យថិតឝ្ច ពភូវ។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","តានវាទីច្ច ម្ឫតិយាតនេវ មត្ប្រាណានាំ យាតនា ជាយតេ, យូយមត្រ មយា សាទ៌្ធំ ជាគ្ឫត។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","តតះ ស កិញ្ចិទ្ទូរំ គត្វាធោមុខះ បតន៑ ប្រាត៌្ហយាញ្ចក្រេ, ហេ មត្បិតយ៌ទិ ភវិតុំ ឝក្នោតិ, តហ៌ិ កំសោៜយំ មត្តោ ទូរំ យាតុ; កិន្តុ មទិច្ឆាវត៑ ន ភវតុ, ត្វទិច្ឆាវទ៑ ភវតុ។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","តតះ ស ឝិឞ្យានុបេត្យ តាន៑ និទ្រតោ និរីក្ឞ្យ បិតរាយ កថយាមាស, យូយំ មយា សាកំ ទណ្ឌមេកមបិ ជាគរិតុំ នាឝន្កុត? ");
INSERT INTO sankhm_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","បរីក្ឞាយាំ ន បតិតុំ ជាគ្ឫត ប្រាត៌្ហយធ្វញ្ច; អាត្មា សមុទ្យតោស្តិ, កិន្តុ វបុ រ្ទុព៌្ពលំ។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ស ទ្វិតីយវារំ ប្រាត៌្ហយាញ្ចក្រេ, ហេ មត្តាត, ន បីតេ យទិ កំសមិទំ មត្តោ ទូរំ យាតុំ ន ឝក្នោតិ, តហ៌ិ ត្វទិច្ឆាវទ៑ ភវតុ។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ស បុនរេត្យ តាន៑ និទ្រតោ ទទឝ៌, យតស្តេឞាំ នេត្រាណិ និទ្រយា បូណ៌ាន្យាសន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","បឝ្ចាត៑ ស តាន៑ វិហាយ វ្រជិត្វា ត្ឫតីយវារំ បូវ៌្វវត៑ កថយន៑ ប្រាត៌្ហិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","តតះ ឝិឞ្យានុបាគត្យ គទិតវាន៑, សាម្ប្រតំ ឝយានាះ កិំ វិឝ្រាម្យថ? បឝ្យត, សមយ ឧបាស្ថាត៑, មនុជសុតះ បាបិនាំ ករេឞុ សមប៌្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ឧត្តិឞ្ឋត, វយំ យាមះ, យោ មាំ បរករេឞុ មសប៌យិឞ្យតិ, បឝ្យត, ស សមីបមាយាតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ឯតត្កថាកថនកាលេ ទ្វាទឝឝិឞ្យាណាមេកោ យិហូទានាមកោ មុខ្យយាជកលោកប្រាចីនៃះ ប្រហិតាន៑ អសិធារិយឞ្ដិធារិណោ មនុជាន៑ គ្ឫហីត្វា តត្សមីបមុបតស្ថៅ។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","អសៅ បរករេឞ្វប៌យិតា បូវ៌្វំ តាន៑ ឥត្ថំ សង្កេតយាមាស, យមហំ ចុម្ពិឞ្យេ, សោៜសៅ មនុជះ,សឯវ យុឞ្មាភិ រ្ធាយ៌្យតាំ។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","តទា ស សបទិ យីឝុមុបាគត្យ ហេ គុរោ, ប្រណមាមីត្យុក្ត្វា តំ ចុចុម្ពេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","តទា យីឝុស្តមុវាច, ហេ មិត្រំ កិមត៌្ហមាគតោសិ? តទា តៃរាគត្យ យីឝុរាក្រម្យ ទឃ្រេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","តតោ យីឝោះ សង្គិនាមេកះ ករំ ប្រសាយ៌្យ កោឞាទសិំ ពហិឞ្ក្ឫត្យ មហាយាជកស្យ ទាសមេកមាហត្យ តស្យ កណ៌ំ ចិច្ឆេទ។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","តតោ យីឝុស្តំ ជគាទ, ខឌ្គំ ស្វស្ថានេे និធេហិ យតោ យេ យេ ជនា អសិំ ធារយន្តិ, តឯវាសិនា វិនឝ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","អបរំ បិតា យថា មទន្តិកំ ស្វគ៌ីយទូតានាំ ទ្វាទឝវាហិនីតោៜធិកំ ប្រហិណុយាត៑ មយា តមុទ្ទិឝ្យេទានីមេវ តថា ប្រាត៌្ហយិតុំ ន ឝក្យតេ, ត្វយា កិមិត្ថំ ជ្ញាយតេ? ");
INSERT INTO sankhm_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","តថា សតីត្ថំ ឃដិឞ្យតេ ធម៌្មបុស្តកស្យ យទិទំ វាក្យំ តត៑ កថំ សិធ្យេត៑? ");
INSERT INTO sankhm_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","តទានីំ យីឝុ រ្ជននិវហំ ជគាទ, យូយំ ខឌ្គយឞ្ដីន៑ អាទាយ មាំ កិំ ចៅរំ ធត៌្តុមាយាតាះ? អហំ ប្រត្យហំ យុឞ្មាភិះ សាកមុបវិឝ្យ សមុបាទិឝំ, តទា មាំ នាធរត; ");
INSERT INTO sankhm_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","កិន្តុ ភវិឞ្យទ្វាទិនាំ វាក្យានាំ សំសិទ្ធយេ សវ៌្វមេតទភូត៑។ តទា សវ៌្វេ ឝិឞ្យាស្តំ វិហាយ បលាយន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","អនន្តរំ តេ មនុជា យីឝុំ ធ្ឫត្វា យត្រាធ្យាបកប្រាញ្ចះ បរិឞទំ កុវ៌្វន្ត ឧបាវិឝន៑ តត្រ កិយផានាाមកមហាយាជកស្យាន្តិកំ និន្យុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","កិន្តុ ឝេឞេ កិំ ភវិឞ្យតីតិ វេត្តុំ បិតរោ ទូរេ តត្បឝ្ចាទ៑ វ្រជិត្វា មហាយាជកស្យាដ្ដាលិកាំ ប្រវិឝ្យ ទាសៃះ សហិត ឧបាវិឝត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","តទានីំ ប្រធានយាជកប្រាចីនមន្ត្រិណះ សវ៌្វេ យីឝុំ ហន្តុំ ម្ឫឞាសាក្ឞ្យម៑ អលិប្សន្ត, ");
INSERT INTO sankhm_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","កិន្តុ ន លេភិរេ។ អនេកេឞុ ម្ឫឞាសាក្ឞិឞ្វាគតេឞ្វបិ តន្ន ប្រាបុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ឝេឞេ ទ្វៅ ម្ឫឞាសាក្ឞិណាវាគត្យ ជគទតុះ, បុមានយមកថយត៑, អហមីឝ្វរមន្ទិរំ ភំក្ត្វា ទិនត្រយមធ្យេ តន្និម៌្មាតុំ ឝក្នោមិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","តទា មហាយាជក ឧត្ថាយ យីឝុម៑ អវាទីត៑។ ត្វំ កិមបិ ន ប្រតិវទសិ? ត្វាមធិ កិមេតេ សាក្ឞ្យំ វទន្តិ? ");
INSERT INTO sankhm_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","កិន្តុ យីឝុ រ្មៅនីភូយ តស្យៅ។ តតោ មហាយាជក ឧក្តវាន៑, ត្វាម៑ អមរេឝ្វរនាម្នា ឝបយាមិ, ត្វមីឝ្វរស្យ បុត្រោៜភិឞិក្តោ ភវសិ នវេតិ វទ។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","យីឝុះ ប្រត្យវទត៑, ត្វំ សត្យមុក្តវាន៑; អហំ យុឞ្មាន៑ តថ្យំ វទាមិ, ឥតះបរំ មនុជសុតំ សវ៌្វឝក្តិមតោ ទក្ឞិណបាឝ៌្វេ ស្ថាតុំ គគណស្ថំ ជលធរានារុហ្យាយាន្តំ វីក្ឞធ្វេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","តទា មហាយាជកោ និជវសនំ ឆិត្ត្វា ជគាទ, ឯឞ ឦឝ្វរំ និន្ទិតវាន៑, អស្មាកមបរសាក្ឞ្យេណ កិំ ប្រយោជនំ? បឝ្យត, យូយមេវាស្យាស្យាទ៑ ឦឝ្វរនិន្ទាំ ឝ្រុតវន្តះ, ");
INSERT INTO sankhm_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","យុឞ្មាភិះ កិំ វិវិច្យតេ? តេ ប្រត្យូចុះ, វធាហ៌ោៜយំ។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","តតោ លោកៃស្តទាស្យេ និឞ្ឋីវិតំ កេចិត៑ ប្រតលមាហត្យ កេចិច្ច ចបេដមាហត្យ ពភាឞិរេ, ");
INSERT INTO sankhm_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ហេ ខ្រីឞ្ដ ត្វាំ កឝ្ចបេដមាហតវាន៑? ឥតិ គណយិត្វា វទាស្មាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","បិតរោ ពហិរង្គន ឧបវិឝតិ, តទានីមេកា ទាសី តមុបាគត្យ ពភាឞេ, ត្វំ គាលីលីយយីឝោះ សហចរឯកះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","កិន្តុ ស សវ៌្វេឞាំ សមក្ឞម៑ អនង្គីក្ឫត្យាវាទីត៑, ត្វយា យទុច្យតេ, តទត៌្ហមហំ ន វេទ្មិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","តទា តស្មិន៑ ពហិទ៌្វារំ គតេ ៜន្យា ទាសី តំ និរីក្ឞ្យ តត្រត្យជនានវទត៑, អយមបិ នាសរតីយយីឝុនា សាទ៌្ធម៑ អាសីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","តតះ ស ឝបថេន បុនរនង្គីក្ឫត្យ កថិតវាន៑, តំ នរំ ន បរិចិនោមិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ក្ឞណាត៑ បរំ តិឞ្ឋន្តោ ជនា ឯត្យ បិតរម៑ អវទន៑, ត្វមវឝ្យំ តេឞាមេក ឥតិ ត្វទុច្ចារណមេវ ទ្យោតយតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","កិន្តុ សោៜភិឝប្យ កថិតវាន៑, តំ ជនំ នាហំ បរិចិនោមិ, តទា សបទិ កុក្កុដោ រុរាវ។ ");
INSERT INTO sankhm_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","កុក្កុដរវាត៑ ប្រាក៑ ត្វំ មាំ ត្រិរបាហ្នោឞ្យសេ, យៃឞា វាគ៑ យីឝុនាវាទិ តាំ បិតរះ សំស្ម្ឫត្យ ពហិរិត្វា ខេទាទ៑ ភ្ឫឝំ ចក្រន្ទ។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ប្រភាតេ ជាតេ ប្រធានយាជកលោកប្រាចីនា យីឝុំ ហន្តុំ តត្ប្រតិកូលំ មន្ត្រយិត្វា ");
INSERT INTO sankhm_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","តំ ពទ្វ្វា នីត្វា បន្តីយបីលាតាខ្យាធិបេ សមប៌យាមាសុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","តតោ យីឝោះ បរករេវ្វប៌យិតា យិហូទាស្តត្ប្រាណាទណ្ឌាជ្ញាំ វិទិត្វា សន្តប្តមនាះ ប្រធានយាជកលោកប្រាចីនានាំ សមក្ឞំ តាស្ត្រីំឝន្មុទ្រាះ ប្រតិទាយាវាទីត៑, ");
INSERT INTO sankhm_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ឯតន្និរាគោនរប្រាណបរករាប៌ណាត៑ កលុឞំ ក្ឫតវានហំ។ តទា ត ឧទិតវន្តះ, តេនាស្មាកំ កិំ? ត្វយា តទ៑ ពុធ្យតាម៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","តតោ យិហូទា មន្ទិរមធ្យេ តា មុទ្រា និក្ឞិប្យ ប្រស្ថិតវាន៑ ឥត្វា ច ស្វយមាត្មានមុទ្ពពន្ធ។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","បឝ្ចាត៑ ប្រធានយាជកាស្តា មុទ្រា អាទាយ កថិតវន្តះ, ឯតា មុទ្រាះ ឝោណិតមូល្យំ តស្មាទ៑ ភាណ្ឌាគារេ ន និធាតវ្យាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","អនន្តរំ តេ មន្ត្រយិត្វា វិទេឝិនាំ ឝ្មឝានស្ថានាយ តាភិះ កុលាលស្យ ក្ឞេត្រមក្រីណន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","អតោៜទ្យាបិ តត្ស្ថានំ រក្តក្ឞេត្រំ វទន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ឥត្ថំ សតិ ឥស្រាយេលីយសន្តានៃ រ្យស្យ មូល្យំ និរុបិតំ, តស្យ ត្រិំឝន្មុទ្រាមានំ មូល្យំ ");
INSERT INTO sankhm_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","មាំ ប្រតិ បរមេឝ្វរស្យាទេឝាត៑ តេភ្យ អាទីយត, តេន ច កុលាលស្យ ក្ឞេត្រំ ក្រីតមិតិ យទ្វចនំ យិរិមិយភវិឞ្យទ្វាទិនា ប្រោក្តំ តត៑ តទាសិធ្យត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","អនន្តរំ យីឝៅ តទធិបតេះ សម្មុខ ឧបតិឞ្ឋតិ ស តំ បប្រច្ឆ, ត្វំ កិំ យិហូទីយានាំ រាជា? តទា យីឝុស្តមវទត៑, ត្វំ សត្យមុក្តវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","កិន្តុ ប្រធានយាជកប្រាចីនៃរភិយុក្តេន តេន កិមបិ ន ប្រត្យវាទិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","តតះ បីលាតេន ស ឧទិតះ, ឥមេ ត្វត្ប្រតិកូលតះ កតិ កតិ សាក្ឞ្យំ ទទតិ, តត៑ ត្វំ ន ឝ្ឫណោឞិ? ");
INSERT INTO sankhm_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","តថាបិ ស តេឞាមេកស្យាបិ វចស ឧត្តរំ នោទិតវាន៑; តេន សោៜធិបតិ រ្មហាចិត្រំ វិទាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","អន្យច្ច តន្មហកាលេៜធិបតេរេតាទ្ឫឝី រាតិរាសីត៑, ប្រជា យំ កញ្ចន ពន្ធិនំ យាចន្តេ, តមេវ ស មោចយតីតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","តទានីំ ពរព្ពានាមា កឝ្ចិត៑ ខ្យាតពន្ធ្យាសីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","តតះ បីលាតស្តត្រ មិលិតាន៑ លោកាន៑ អប្ឫច្ឆត៑, ឯឞ ពរព្ពា ពន្ធី ខ្រីឞ្ដវិខ្យាតោ យីឝុឝ្ចៃតយោះ កំ មោចយិឞ្យាមិ? យុឞ្មាកំ កិមីប្សិតំ? ");
INSERT INTO sankhm_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","តៃរីឞ៌្យយា ស សមប៌ិត ឥតិ ស ជ្ញាតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","អបរំ វិចារាសនោបវេឝនកាលេ បីលាតស្យ បត្នី ភ្ឫត្យំ ប្រហិត្យ តស្មៃ កថយាមាស, តំ ធាម៌្មិកមនុជំ ប្រតិ ត្វយា កិមបិ ន កត៌្តវ្យំ; យស្មាត៑ តត្ក្ឫតេៜទ្យាហំ ស្វប្នេ ប្រភូតកឞ្ដមលភេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","អនន្តរំ ប្រធានយាជកប្រាចីនា ពរព្ពាំ យាចិត្វាទាតុំ យីឝុញ្ច ហន្តុំ សកលលោកាន៑ ប្រាវត៌្តយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","តតោៜធិបតិស្តាន៑ ប្ឫឞ្ដវាន៑, ឯតយោះ កមហំ មោចយិឞ្យាមិ? យុឞ្មាកំ កេច្ឆា? តេ ប្រោចុ រ្ពរព្ពាំ។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","តទា បីលាតះ បប្រច្ឆ, តហ៌ិ យំ ខ្រីឞ្ដំ វទន្តិ, តំ យីឝុំ កិំ ករិឞ្យាមិ? សវ៌្វេ កថយាមាសុះ, ស ក្រុឝេន វិធ្យតាំ។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","តតោៜធិបតិរវាទីត៑, កុតះ? កិំ តេនាបរាទ្ធំ? កិន្តុ តេ បុនរុចៃ រ្ជគទុះ, ស ក្រុឝេន វិធ្យតាំ។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","តទា និជវាក្យមគ្រាហ្យមភូត៑, កលហឝ្ចាប្យភូត៑, បីលាត ឥតិ វិលោក្យ លោកានាំ សមក្ឞំ តោយមាទាយ ករៅ ប្រក្ឞាល្យាវោចត៑, ឯតស្យ ធាម៌្មិកមនុឞ្យស្យ ឝោណិតបាតេ និទ៌ោឞោៜហំ, យុឞ្មាភិរេវ តទ៑ ពុធ្យតាំ។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","តទា សវ៌្វាះ ប្រជាះ ប្រត្យវោចន៑, តស្យ ឝោណិតបាតាបរាធោៜស្មាកម៑ អស្មត្សន្តានានាញ្ចោបរិ ភវតុ។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","តតះ ស តេឞាំ សមីបេ ពរព្ពាំ មោចយាមាស យីឝុន្តុ កឞាភិរាហត្យ ក្រុឝេន វេធិតុំ សមប៌យាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","អនន្តរម៑ អធិបតេះ សេនា អធិបតេ រ្គ្ឫហំ យីឝុមានីយ តស្យ សមីបេ សេនាសមូហំ សំជគ្ឫហុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","តតស្តេ តស្យ វសនំ មោចយិត្វា ក្ឫឞ្ណលោហិតវណ៌វសនំ បរិធាបយាមាសុះ ");
INSERT INTO sankhm_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","កណ្ដកានាំ មុកុដំ និម៌្មាយ តច្ឆិរសិ ទទុះ, តស្យ ទក្ឞិណករេ វេត្រមេកំ ទត្ត្វា តស្យ សម្មុខេ ជានូនិ បាតយិត្វា, ហេ យិហូទីយានាំ រាជន៑, តុភ្យំ នម ឥត្យុក្ត្វា តំ តិរឝ្ចក្រុះ, ");
INSERT INTO sankhm_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","តតស្តស្យ គាត្រេ និឞ្ឋីវំ ទត្វា តេន វេត្រេណ ឝិរ អាជឃ្នុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ឥត្ថំ តំ តិរស្ក្ឫត្យ តទ៑ វសនំ មោចយិត្វា បុនន៌ិជវសនំ បរិធាបយាញ្ចក្រុះ, តំ ក្រុឝេន វេធិតុំ នីតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","បឝ្ចាត្តេ ពហិព៌្ហូយ កុរីណីយំ ឝិមោន្នាមកមេកំ វិលោក្យ ក្រុឝំ វោឍុំ តមាទទិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","អនន្តរំ គុល្គល្តាម៑ អត៌្ហាត៑ ឝិរស្កបាលនាមកស្ថានមុ បស្ថាយ តេ យីឝវេ បិត្តមិឝ្រិតាម្លរសំ បាតុំ ទទុះ, ");
INSERT INTO sankhm_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","កិន្តុ ស តមាស្វាទ្យ ន បបៅ។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","តទានីំ តេ តំ ក្រុឝេន សំវិធ្យ តស្យ វសនានិ គុដិកាបាតេន វិភជ្យ ជគ្ឫហុះ, តស្មាត៑, វិភជន្តេៜធរីយំ មេ តេ មនុឞ្យាះ បរស្បរំ។ មទុត្តរីយវស្ត្រាត៌្ហំ គុដិកាំ បាតយន្តិ ច៕ យទេតទ្វចនំ ភវិឞ្យទ្វាទិភិរុក្តមាសីត៑, តទា តទ៑ អសិធ្យត៑, ");
INSERT INTO sankhm_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","បឝ្ចាត៑ តេ តត្រោបវិឝ្យ តទ្រក្ឞណកវ៌្វណិ និយុក្តាស្តស្ថុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","អបរម៑ ឯឞ យិហូទីយានាំ រាជា យីឝុរិត្យបវាទលិបិបត្រំ តច្ឆិរស ឩទ៌្វ្វេ យោជយាមាសុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","តតស្តស្យ វាមេ ទក្ឞិណេ ច ទ្វៅ ចៃរៅ តេន សាកំ ក្រុឝេន វិវិធុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","តទា បាន្ថា និជឝិរោ លាឌយិត្វា តំ និន្ទន្តោ ជគទុះ, ");
INSERT INTO sankhm_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ហេ ឦឝ្វរមន្ទិរភញ្ជក ទិនត្រយេ តន្និម៌្មាតះ ស្វំ រក្ឞ, ចេត្ត្វមីឝ្វរសុតស្តហ៌ិ ក្រុឝាទវរោហ។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ប្រធានយាជកាធ្យាបកប្រាចីនាឝ្ច តថា តិរស្ក្ឫត្យ ជគទុះ, ");
INSERT INTO sankhm_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","សោៜន្យជនានាវត៑, កិន្តុ ស្វមវិតុំ ន ឝក្នោតិ។ យទីស្រាយេលោ រាជា ភវេត៑, តហ៌ីទានីមេវ ក្រុឝាទវរោហតុ, តេន តំ វយំ ប្រត្យេឞ្យាមះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ស ឦឝ្វរេ ប្រត្យាឝាមករោត៑, យទីឝ្វរស្តស្មិន៑ សន្តុឞ្ដស្តហ៌ីទានីមេវ តមវេត៑, យតះ ស ឧក្តវាន៑ អហមីឝ្វរសុតះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","យៅ ស្តេនៅ សាកំ តេន ក្រុឝេន វិទ្ធៅ តៅ តទ្វទេវ តំ និនិន្ទតុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","តទា ទ្វិតីយយាមាត៑ ត្ឫតីយយាមំ យាវត៑ សវ៌្វទេឝេ តមិរំ ពភូវ, ");
INSERT INTO sankhm_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ត្ឫតីយយាមេ \"ឯលី ឯលី លាមា ឝិវក្តនី\", អត៌្ហាត៑ មទីឝ្វរ មទីឝ្វរ កុតោ មាមត្យាក្ឞីះ? យីឝុរុច្ចៃរិតិ ជគាទ។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","តទា តត្រ ស្ថិតាះ កេចិត៑ តត៑ ឝ្រុត្វា ពភាឞិរេ, អយម៑ ឯលិយមាហូយតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","តេឞាំ មធ្យាទ៑ ឯកះ ឝីឃ្រំ គត្វា ស្បញ្ជំ គ្ឫហីត្វា តត្រាម្លរសំ ទត្ត្វា នលេន បាតុំ តស្មៃ ទទៅ។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ឥតរេៜកថយន៑ តិឞ្ឋត, តំ រក្ឞិតុម៑ ឯលិយ អាយាតិ នវេតិ បឝ្យាមះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","យីឝុះ បុនរុចៃរាហូយ ប្រាណាន៑ ជហៅ។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","តតោ មន្ទិរស្យ វិច្ឆេទវសនម៑ ឩទ៌្វ្វាទធោ យាវត៑ ឆិទ្យមានំ ទ្វិធាភវត៑, ");
INSERT INTO sankhm_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ភូមិឝ្ចកម្បេ ភូធរោវ្យទីយ៌្យត ច។ ឝ្មឝានេ មុក្តេ ភូរិបុណ្យវតាំ សុប្តទេហា ឧទតិឞ្ឋន៑, ");
INSERT INTO sankhm_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ឝ្មឝានាទ៑ វហិព៌្ហូយ តទុត្ថានាត៑ បរំ បុណ្យបុរំ គត្វា ពហុជនាន៑ ទឝ៌យាមាសុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","យីឝុរក្ឞណាយ និយុក្តះ ឝតសេនាបតិស្តត្សង្គិនឝ្ច តាទ្ឫឝីំ ភូកម្បាទិឃដនាំ ទ្ឫឞ្ដ្វា ភីតា អវទន៑, ឯឞ ឦឝ្វរបុត្រោ ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","យា ពហុយោឞិតោ យីឝុំ សេវមានា គាលីលស្តត្បឝ្ចាទាគតាស្តាសាំ មធ្យេ ");
INSERT INTO sankhm_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","មគ្ទលីនី មរិយម៑ យាកូព្យោឝ្យោ រ្មាតា យា មរិយម៑ សិពទិយបុត្រយោ រ្មាតា ច យោឞិត ឯតា ទូរេ តិឞ្ឋន្ត្យោ ទទ្ឫឝុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","សន្ធ្យាយាំ សត្យម៑ អរិមថិយានគរស្យ យូឞផ្នាមា ធនី មនុជោ យីឝោះ ឝិឞ្យត្វាត្ ");
INSERT INTO sankhm_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","បីលាតស្យ សមីបំ គត្វា យីឝោះ កាយំ យយាចេ, តេន បីលាតះ កាយំ ទាតុម៑ អាទិទេឝ។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","យូឞផ៑ តត្កាយំ នីត្វា ឝុចិវស្ត្រេណាច្ឆាទ្យ ");
INSERT INTO sankhm_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ស្វាត៌្ហំ ឝៃលេ យត៑ ឝ្មឝានំ ចខាន, តន្មធ្យេ តត្កាយំ និធាយ តស្យ ទ្វារិ វ្ឫហត្បាឞាណំ ទទៅ។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","កិន្តុ មគ្ទលីនី មរិយម៑ អន្យមរិយម៑ ឯតេ ស្ត្រិយៅ តត្រ ឝ្មឝានសម្មុខ ឧបវិវិឝតុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","តទនន្តរំ និស្តារោត្សវស្យាយោជនទិនាត៑ បរេៜហនិ ប្រធានយាជកាះ ផិរូឝិនឝ្ច មិលិត្វា បីលាតមុបាគត្យាកថយន៑, ");
INSERT INTO sankhm_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ហេ មហេច្ឆ ស ប្រតារកោ ជីវន អកថយត៑, ទិនត្រយាត៑ បរំ ឝ្មឝានាទុត្ថាស្យាមិ តទ្វាក្យំ ស្មរាមោ វយំ; ");
INSERT INTO sankhm_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","តស្មាត៑ ត្ឫតីយទិនំ យាវត៑ តត៑ ឝ្មឝានំ រក្ឞិតុមាទិឝតុ, នោចេត៑ តច្ឆិឞ្យា យាមិន្យាមាគត្យ តំ ហ្ឫត្វា លោកាន៑ វទិឞ្យន្តិ, ស ឝ្មឝានាទុទតិឞ្ឋត៑, តថា សតិ ប្រថមភ្រាន្តេះ ឝេឞីយភ្រាន្តិ រ្មហតី ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","តទា បីលាត អវាទីត៑, យុឞ្មាកំ សមីបេ រក្ឞិគណ អាស្តេ, យូយំ គត្វា យថា សាធ្យំ រក្ឞយត។ ");
INSERT INTO sankhm_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","តតស្តេ គត្វា តទ្ទូाរបាឞាណំ មុទ្រាង្កិតំ ក្ឫត្វា រក្ឞិគណំ និយោជ្យ ឝ្មឝានំ រក្ឞយាមាសុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","តតះ បរំ វិឝ្រាមវារស្យ ឝេឞេ សប្តាហប្រថមទិនស្យ ប្រភោតេ ជាតេ មគ្ទលីនី មរិយម៑ អន្យមរិយម៑ ច ឝ្មឝានំ ទ្រឞ្ដុមាគតា។ ");
INSERT INTO sankhm_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","តទា មហាន៑ ភូកម្បោៜភវត៑; បរមេឝ្វរីយទូតះ ស្វគ៌ាទវរុហ្យ ឝ្មឝានទ្វារាត៑ បាឞាណមបសាយ៌្យ តទុបយ៌្យុបវិវេឝ។ ");
INSERT INTO sankhm_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","តទ្វទនំ វិទ្យុទ្វត៑ តេជោមយំ វសនំ ហិមឝុភ្រញ្ច។ ");
INSERT INTO sankhm_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","តទានីំ រក្ឞិណស្តទ្ភយាត៑ កម្បិតា ម្ឫតវទ៑ ពភូវះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ស ទូតោ យោឞិតោ ជគាទ, យូយំ មា ភៃឞ្ដ, ក្រុឝហតយីឝុំ ម្ឫគយធ្វេ តទហំ វេទ្មិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","សោៜត្រ នាស្តិ, យថាវទត៑ តថោត្ថិតវាន៑; ឯតត៑ ប្រភោះ ឝយនស្ថានំ បឝ្យត។ ");
INSERT INTO sankhm_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","តូណ៌ំ គត្វា តច្ឆិឞ្យាន៑ ឥតិ វទត, ស ឝ្មឝានាទ៑ ឧទតិឞ្ឋត៑, យុឞ្មាកមគ្រេ គាលីលំ យាស្យតិ យូយំ តត្រ តំ វីក្ឞិឞ្យធ្វេ, បឝ្យតាហំ វាត៌្តាមិមាំ យុឞ្មានវាទិឞំ។ ");
INSERT INTO sankhm_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","តតស្តា ភយាត៑ មហានន្ទាញ្ច ឝ្មឝានាត៑ តូណ៌ំ ពហិព៌្ហូយ តច្ឆិឞ្យាន៑ វាត៌្តាំ វក្តុំ ធាវិតវត្យះ។ កិន្តុ ឝិឞ្យាន៑ វាត៌្តាំ វក្តុំ យាន្តិ, តទា យីឝុ រ្ទឝ៌នំ ទត្ត្វា តា ជគាទ, ");
INSERT INTO sankhm_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","យុឞ្មាកំ កល្យាណំ ភូយាត៑, តតស្តា អាគត្យ តត្បាទយោះ បតិត្វា ប្រណេមុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","យីឝុស្តា អវាទីត៑, មា ពិភីត, យូយំ គត្វា មម ភ្រាត្ឫន៑ គាលីលំ យាតុំ វទត, តត្រ តេ មាំ ទ្រក្ឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","ស្ត្រិយោ គច្ឆន្តិ, តទា រក្ឞិណាំ កេចិត៑ បុរំ គត្វា យទ្យទ៑ ឃដិតំ តត្សវ៌្វំ ប្រធានយាជកាន៑ ជ្ញាបិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","តេ ប្រាចីនៃះ សមំ សំសទំ ក្ឫត្វា មន្ត្រយន្តោ ពហុមុទ្រាះ សេនាភ្យោ ទត្ត្វាវទន៑, ");
INSERT INTO sankhm_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","អស្មាសុ និទ្រិតេឞុ តច្ឆិឞ្យា យាមិន្យាមាគត្យ តំ ហ្ឫត្វានយន៑, ឥតិ យូយំ ប្រចារយត។ ");
INSERT INTO sankhm_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","យទ្យេតទធិបតេះ ឝ្រោត្រគោចរីភវេត៑, តហ៌ិ តំ ពោធយិត្វា យុឞ្មានវិឞ្យាមះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","តតស្តេ មុទ្រា គ្ឫហីត្វា ឝិក្ឞានុរូបំ កម៌្ម ចក្រុះ, យិហូទីយានាំ មធ្យេ តស្យាទ្យាបិ កិំវទន្តី វិទ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ឯកាទឝ ឝិឞ្យា យីឝុនិរូបិតាគាលីលស្យាទ្រិំ គត្វា ");
INSERT INTO sankhm_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","តត្រ តំ សំវីក្ឞ្យ ប្រណេមុះ, កិន្តុ កេចិត៑ សន្ទិគ្ធវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","យីឝុស្តេឞាំ សមីបមាគត្យ វ្យាហ្ឫតវាន៑, ស្វគ៌មេទិន្យោះ សវ៌្វាធិបតិត្វភារោ មយ្យប៌ិត អាស្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","អតោ យូយំ ប្រយាយ សវ៌្វទេឝីយាន៑ ឝិឞ្យាន៑ ក្ឫត្វា បិតុះ បុត្រស្យ បវិត្រស្យាត្មនឝ្ច នាម្នា តានវគាហយត; អហំ យុឞ្មាន៑ យទ្យទាទិឝំ តទបិ បាលយិតុំ តានុបាទិឝត។ ");
INSERT INTO sankhm_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","បឝ្យត, ជគទន្តំ យាវត៑ សទាហំ យុឞ្មាភិះ សាកំ តិឞ្ឋាមិ។ ឥតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ឦឝ្វរបុត្រស្យ យីឝុខ្រីឞ្ដស្យ សុសំវាទារម្ភះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ភវិឞ្យទ្វាទិនាំ គ្រន្ថេឞុ លិបិរិត្ថមាស្តេ, បឝ្យ ស្វកីយទូតន្តុ តវាគ្រេ ប្រេឞយាម្យហម៑។ គត្វា ត្វទីយបន្ថានំ ស ហិ បរិឞ្ករិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","\"បរមេឝស្យ បន្ថានំ បរិឞ្កុរុត សវ៌្វតះ។ តស្យ រាជបថញ្ចៃវ សមានំ កុរុតាធុនា។ \" ឥត្យេតត៑ ប្រាន្តរេ វាក្យំ វទតះ កស្យចិទ្រវះ៕ ");
INSERT INTO sankhm_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","សឯវ យោហន៑ ប្រាន្តរេ មជ្ជិតវាន៑ តថា បាបមាជ៌ននិមិត្តំ មនោវ្យាវត៌្តកមជ្ជនស្យ កថាញ្ច ប្រចារិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","តតោ យិហូទាទេឝយិរូឝាលម្នគរនិវាសិនះ សវ៌្វេ លោកា ពហិ រ្ភូត្វា តស្យ សមីបមាគត្យ ស្វានិ ស្វានិ បាបាន្យង្គីក្ឫត្យ យទ៌្ទននទ្យាំ តេន មជ្ជិតា ពភូវុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","អស្យ យោហនះ បរិធេយានិ ក្រមេលកលោមជានិ, តស្យ កដិពន្ធនំ ចម៌្មជាតម៑, តស្យ ភក្ឞ្យាណិ ច ឝូកកីដា វន្យមធូនិ ចាសន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ស ប្រចារយន៑ កថយាញ្ចក្រេ, អហំ នម្រីភូយ យស្យ បាទុកាពន្ធនំ មោចយិតុមបិ ន យោគ្យោស្មិ, តាទ្ឫឝោ មត្តោ គុរុតរ ឯកះ បុរុឞោ មត្បឝ្ចាទាគច្ឆតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","អហំ យុឞ្មាន៑ ជលេ មជ្ជិតវាន៑ កិន្តុ ស បវិត្រ អាត្មានិ សំមជ្ជយិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","អបរញ្ច តស្មិន្នេវ កាលេ គាលីល្ប្រទេឝស្យ នាសរទ្គ្រាមាទ៑ យីឝុរាគត្យ យោហនា យទ៌្ទននទ្យាំ មជ្ជិតោៜភូត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ស ជលាទុត្ថិតមាត្រោ មេឃទ្វារំ មុក្តំ កបោតវត៑ ស្វស្យោបរិ អវរោហន្តមាត្មានញ្ច ទ្ឫឞ្ដវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ត្វំ មម ប្រិយះ បុត្រស្ត្វយ្យេវ មមមហាសន្តោឞ ឥយមាកាឝីយា វាណី ពភូវ។ ");
INSERT INTO sankhm_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","តស្មិន៑ កាលេ អាត្មា តំ ប្រាន្តរមធ្យំ និនាយ។ ");
INSERT INTO sankhm_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","អថ ស ចត្វារិំឝទ្ទិនានិ តស្មិន៑ ស្ថានេ វន្យបឝុភិះ សហ តិឞ្ឋន៑ ឝៃតានា បរីក្ឞិតះ; បឝ្ចាត៑ ស្វគ៌ីយទូតាស្តំ សិឞេវិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","អនន្តរំ យោហនិ ពន្ធនាលយេ ពទ្ធេ សតិ យីឝុ រ្គាលីល្ប្រទេឝមាគត្យ ឦឝ្វររាជ្យស្យ សុសំវាទំ ប្រចារយន៑ កថយាមាស, ");
INSERT INTO sankhm_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","កាលះ សម្បូណ៌ ឦឝ្វររាជ្យញ្ច សមីបមាគតំ; អតោហេតោ រ្យូយំ មនាំសិ វ្យាវត៌្តយធ្វំ សុសំវាទេ ច វិឝ្វាសិត។ ");
INSERT INTO sankhm_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","តទនន្តរំ ស គាលីលីយសមុទ្រស្យ តីរេ គច្ឆន៑ ឝិមោន៑ តស្យ ភ្រាតា អន្ទ្រិយនាមា ច ឥមៅ ទ្វៅ ជនៅ មត្ស្យធារិណៅ សាគរមធ្យេ ជាលំ ប្រក្ឞិបន្តៅ ទ្ឫឞ្ដ្វា តាវវទត៑, ");
INSERT INTO sankhm_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","យុវាំ មម បឝ្ចាទាគច្ឆតំ, យុវាមហំ មនុឞ្យធារិណៅ ករិឞ្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","តតស្តៅ តត្ក្ឞណមេវ ជាលានិ បរិត្យជ្យ តស្យ បឝ្ចាត៑ ជគ្មតុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","តតះ បរំ តត្ស្ថានាត៑ កិញ្ចិទ៑ ទូរំ គត្វា ស សិវទីបុត្រយាកូព៑ តទ្ភ្រាត្ឫយោហន៑ ច ឥមៅ នៅកាយាំ ជាលានាំ ជីណ៌មុទ្ធារយន្តៅ ទ្ឫឞ្ដ្វា តាវាហូយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","តតស្តៅ នៅកាយាំ វេតនភុគ្ភិះ សហិតំ ស្វបិតរំ វិហាយ តត្បឝ្ចាទីយតុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","តតះ បរំ កផន៌ាហូម្នាមកំ នគរមុបស្ថាយ ស វិឝ្រាមទិវសេ ភជនគ្រហំ ប្រវិឝ្យ សមុបទិទេឝ។ ");
INSERT INTO sankhm_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","តស្យោបទេឝាល្លោកា អាឝ្ចយ៌្យំ មេនិរេ យតះ សោធ្យាបកាឥវ នោបទិឝន៑ ប្រភាវវានិវ ប្រោបទិទេឝ។ ");
INSERT INTO sankhm_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","អបរញ្ច តស្មិន៑ ភជនគ្ឫហេ អបវិត្រភូតេន គ្រស្ត ឯកោ មានុឞ អាសីត៑។ ស ចីត្ឝព្ទំ ក្ឫត្វា កថយាញ្ចកេ ");
INSERT INTO sankhm_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ភោ នាសរតីយ យីឝោ ត្វមស្មាន៑ ត្យជ, ត្វយា សហាស្មាកំ កះ សម្ពន្ធះ? ត្វំ កិមស្មាន៑ នាឝយិតុំ សមាគតះ? ត្វមីឝ្វរស្យ បវិត្រលោក ឥត្យហំ ជានាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","តទា យីឝុស្តំ តជ៌យិត្វា ជគាទ តូឞ្ណីំ ភវ ឥតោ ពហិព៌្ហវ ច។ ");
INSERT INTO sankhm_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","តតះ សោៜបវិត្រភូតស្តំ សម្បីឌ្យ អត្យុចៃឝ្ចីត្ក្ឫត្យ និជ៌គាម។ ");
INSERT INTO sankhm_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","តេនៃវ សវ៌្វេ ចមត្ក្ឫត្យ បរស្បរំ កថយាញ្ចក្រិរេ, អហោ កិមិទំ? កីទ្ឫឝោៜយំ នវ្យ ឧបទេឝះ? អនេន ប្រភាវេនាបវិត្រភូតេឞ្វាជ្ញាបិតេឞុ តេ តទាជ្ញានុវត៌្តិនោ ភវន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","តទា តស្យ យឝោ គាលីលឝ្ចតុទ៌ិក្ស្ថសវ៌្វទេឝាន៑ វ្យាប្នោត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","អបរញ្ច តេ ភជនគ្ឫហាទ៑ ពហិ រ្ភូត្វា យាកូព្យោហន្ភ្យាំ សហ ឝិមោន អាន្ទ្រិយស្យ ច និវេឝនំ ប្រវិវិឝុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","តទា បិតរស្យ ឝ្វឝ្រូជ៌្វរបីឌិតា ឝយ្យាយាមាស្ត ឥតិ តេ តំ ឈដិតិ វិជ្ញាបយាញ្ចក្រុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","តតះ ស អាគត្យ តស្យា ហស្តំ ធ្ឫត្វា តាមុទស្ថាបយត៑; តទៃវ តាំ ជ្វរោៜត្យាក្ឞីត៑ តតះ បរំ សា តាន៑ សិឞេវេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","អថាស្តំ គតេ រវៅ សន្ធ្យាកាលេ សតិ លោកាស្តត្សមីបំ សវ៌្វាន៑ រោគិណោ ភូតធ្ឫតាំឝ្ច សមានិន្យុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","សវ៌្វេ នាគរិកា លោកា ទ្វារិ សំមិលិតាឝ្ច។ ");
INSERT INTO sankhm_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","តតះ ស នានាវិធរោគិណោ ពហូន៑ មនុជានរោគិណឝ្ចការ តថា ពហូន៑ ភូតាន៑ ត្យាជយាញ្ចការ តាន៑ ភូតាន៑ កិមបិ វាក្យំ វក្តុំ និឞិឞេធ ច យតោហេតោស្តេ តមជានន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","អបរញ្ច សោៜតិប្រត្យូឞេ វស្តុតស្តុ រាត្រិឝេឞេ សមុត្ថាយ ពហិព៌្ហូយ និជ៌នំ ស្ថានំ គត្វា តត្រ ប្រាត៌្ហយាញ្ចក្រេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","អនន្តរំ ឝិមោន៑ តត្សង្គិនឝ្ច តស្យ បឝ្ចាទ៑ គតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","តទុទ្ទេឝំ ប្រាប្យ តមវទន៑ សវ៌្វេ លោកាស្ត្វាំ ម្ឫគយន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","តទា សោៜកថយត៑ អាគច្ឆត វយំ សមីបស្ថានិ នគរាណិ យាមះ, យតោៜហំ តត្រ កថាំ ប្រចារយិតុំ ពហិរាគមម៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","អថ ស តេឞាំ គាលីល្ប្រទេឝស្យ សវ៌្វេឞុ ភជនគ្ឫហេឞុ កថាះ ប្រចារយាញ្ចក្រេ ភូតានត្យាជយញ្ច។ ");
INSERT INTO sankhm_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","អនន្តរមេកះ កុឞ្ឋី សមាគត្យ តត្សម្មុខេ ជានុបាតំ វិនយញ្ច ក្ឫត្វា កថិតវាន៑ យទិ ភវាន៑ ឥច្ឆតិ តហ៌ិ មាំ បរិឞ្កត៌្តុំ ឝក្នោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","តតះ ក្ឫបាលុ រ្យីឝុះ ករៅ ប្រសាយ៌្យ តំ ស្បឞ្ដ្វា កថយាមាស ");
INSERT INTO sankhm_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","មមេច្ឆា វិទ្យតេ ត្វំ បរិឞ្ក្ឫតោ ភវ។ ឯតត្កថាយាះ កថនមាត្រាត៑ ស កុឞ្ឋី រោគាន្មុក្តះ បរិឞ្ក្ឫតោៜភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","តទា ស តំ វិស្ឫជន៑ គាឍមាទិឝ្យ ជគាទ ");
INSERT INTO sankhm_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","សាវធានោ ភវ កថាមិមាំ កមបិ មា វទ; ស្វាត្មានំ យាជកំ ទឝ៌យ, លោកេភ្យះ ស្វបរិឞ្ក្ឫតេះ ប្រមាណទានាយ មូសានិណ៌ីតំ យទ្ទានំ តទុត្ស្ឫជស្វ ច។ ");
INSERT INTO sankhm_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","កិន្តុ ស គត្វា តត៑ កម៌្ម ឥត្ថំ វិស្តាយ៌្យ ប្រចារយិតុំ ប្រារេភេ តេនៃវ យីឝុះ បុនះ សប្រកាឝំ នគរំ ប្រវេឞ្ដុំ នាឝក្នោត៑ តតោហេតោព៌ហិះ កាននស្ថានេ តស្យៅ; តថាបិ ចតុទ៌្ទិគ្ភ្យោ លោកាស្តស្យ សមីបមាយយុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","តទនន្តរំ យីឝៃ កតិបយទិនានិ វិលម្ព្យ បុនះ កផន៌ាហូម្នគរំ ប្រវិឞ្ដេ ស គ្ឫហ អាស្ត ឥតិ កិំវទន្ត្យា តត្ក្ឞណំ តត្សមីបំ ពហវោ លោកា អាគត្យ សមុបតស្ថុះ, ");
INSERT INTO sankhm_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","តស្មាទ៑ គ្ឫហមធ្យេ សវ៌្វេឞាំ ក្ឫតេ ស្ថានំ នាភវទ៑ ទ្វារស្យ ចតុទ៌ិក្ឞ្វបិ នាភវត៑, តត្កាលេ ស តាន៑ ប្រតិ កថាំ ប្រចារយាញ្ចក្រេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","តតះ បរំ លោកាឝ្ចតុព៌្ហិ រ្មានវៃរេកំ បក្ឞាឃាតិនំ វាហយិត្វា តត្សមីបម៑ អានិន្យុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","កិន្តុ ជនានាំ ពហុត្វាត៑ តំ យីឝោះ សម្មុខមានេតុំ ន ឝក្នុវន្តោ យស្មិន៑ ស្ថានេ ស អាស្តេ តទុបរិគ្ឫហប្ឫឞ្ឋំ ខនិត្វា ឆិទ្រំ ក្ឫត្វា តេន មាគ៌េណ សឝយ្យំ បក្ឞាឃាតិនម៑ អវរោហយាមាសុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","តតោ យីឝុស្តេឞាំ វិឝ្វាសំ ទ្ឫឞ្ដ្វា តំ បក្ឞាឃាតិនំ ពភាឞេ ហេ វត្ស តវ បាបានាំ មាជ៌នំ ភវតុ។ ");
INSERT INTO sankhm_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","តទា កិយន្តោៜធ្យាបកាស្តត្រោបវិឝន្តោ មនោភិ រ្វិតក៌យាញ្ចក្រុះ, ឯឞ មនុឞ្យ ឯតាទ្ឫឝីមីឝ្វរនិន្ទាំ កថាំ កុតះ កថយតិ? ");
INSERT INTO sankhm_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","ឦឝ្វរំ វិនា បាបានិ មាឞ៌្ដុំ កស្យ សាមត៌្ហ្យម៑ អាស្តេ? ");
INSERT INTO sankhm_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ឥត្ថំ តេ វិតក៌យន្តិ យីឝុស្តត្ក្ឞណំ មនសា តទ៑ ពុទ្វ្វា តានវទទ៑ យូយមន្តះករណៃះ កុត ឯតានិ វិតក៌យថ? ");
INSERT INTO sankhm_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","តទនន្តរំ យីឝុស្តត្ស្ថានាត៑ បុនះ សមុទ្រតដំ យយៅ; លោកនិវហេ តត្សមីបមាគតេ ស តាន៑ សមុបទិទេឝ។ ");
INSERT INTO sankhm_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","កិន្តុ ប្ឫថិវ្យាំ បាបានិ មាឞ៌្ដុំ មនុឞ្យបុត្រស្យ សាមត៌្ហ្យមស្តិ, ឯតទ៑ យុឞ្មាន៑ ជ្ញាបយិតុំ (ស តស្មៃ បក្ឞាឃាតិនេ កថយាមាស) ");
INSERT INTO sankhm_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","ឧត្តិឞ្ឋ តវ ឝយ្យាំ គ្ឫហីត្វា ស្វគ្ឫហំ យាហិ, អហំ ត្វាមិទម៑ អាជ្ញាបយាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","តតះ ស តត្ក្ឞណម៑ ឧត្ថាយ ឝយ្យាំ គ្ឫហីត្វា សវ៌្វេឞាំ សាក្ឞាត៑ ជគាម; សវ៌្វេ វិស្មិតា ឯតាទ្ឫឝំ កម៌្ម វយម៑ កទាបិ នាបឝ្យាម, ឥមាំ កថាំ កថយិត្វេឝ្វរំ ធន្យមព្រុវន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","តទនន្តរំ យីឝុស្តត្ស្ថានាត៑ បុនះ សមុទ្រតដំ យយៅ; លោកនិវហេ តត្សមីបមាគតេ ស តាន៑ សមុបទិទេឝ។ ");
INSERT INTO sankhm_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","អថ គច្ឆន៑ ករសញ្ចយគ្ឫហ ឧបវិឞ្ដម៑ អាល្ផីយបុត្រំ លេវិំ ទ្ឫឞ្ដ្វា តមាហូយ កថិតវាន៑ មត្បឝ្ចាត៑ ត្វាមាមច្ឆ តតះ ស ឧត្ថាយ តត្បឝ្ចាទ៑ យយៅ។ ");
INSERT INTO sankhm_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","អនន្តរំ យីឝៅ តស្យ គ្ឫហេ ភោក្តុម៑ ឧបវិឞ្ដេ ពហវះ ករមញ្ចាយិនះ បាបិនឝ្ច តេន តច្ឆិឞ្យៃឝ្ច សហោបវិវិឝុះ, យតោ ពហវស្តត្បឝ្ចាទាជគ្មុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","តទា ស ករមញ្ចាយិភិះ បាបិភិឝ្ច សហ ខាទតិ, តទ៑ ទ្ឫឞ្ដ្វាធ្យាបកាះ ផិរូឝិនឝ្ច តស្យ ឝិឞ្យានូចុះ ករមញ្ចាយិភិះ បាបិភិឝ្ច សហាយំ កុតោ ភុំក្តេ បិវតិ ច? ");
INSERT INTO sankhm_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","តទ្វាក្យំ ឝ្រុត្វា យីឝុះ ប្រត្យុវាច,អរោគិលោកានាំ ចិកិត្សកេន ប្រយោជនំ នាស្តិ, កិន្តុ រោគិណាមេវ; អហំ ធាម៌្មិកានាហ្វាតុំ នាគតះ កិន្តុ មនោ វ្យាវត៌្តយិតុំ បាបិន ឯវ។ ");
INSERT INTO sankhm_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","តតះ បរំ យោហនះ ផិរូឝិនាញ្ចោបវាសាចារិឝិឞ្យា យីឝោះ សមីបម៑ អាគត្យ កថយាមាសុះ, យោហនះ ផិរូឝិនាញ្ច ឝិឞ្យា ឧបវសន្តិ កិន្តុ ភវតះ ឝិឞ្យា នោបវសន្តិ កិំ ការណមស្យ? ");
INSERT INTO sankhm_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","តទា យីឝុស្តាន៑ ពភាឞេ យាវត៑ កាលំ សខិភិះ សហ កន្យាយា វរស្តិឞ្ឋតិ តាវត្កាលំ តេ កិមុបវស្តុំ ឝក្នុវន្តិ? យាវត្កាលំ វរស្តៃះ សហ តិឞ្ឋតិ តាវត្កាលំ ត ឧបវស្តុំ ន ឝក្នុវន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","យស្មិន៑ កាលេ តេភ្យះ សកាឝាទ៑ វរោ នេឞ្យតេ ស កាល អាគច្ឆតិ, តស្មិន៑ កាលេ តេ ជនា ឧបវត្ស្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","កោបិ ជនះ បុរាតនវស្ត្រេ នូតនវស្ត្រំ ន សីវ្យតិ, យតោ នូតនវស្ត្រេណ សហ សេវនេ ក្ឫតេ ជីណ៌ំ វស្ត្រំ ឆិទ្យតេ តស្មាត៑ បុន រ្មហត៑ ឆិទ្រំ ជាយតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","កោបិ ជនះ បុរាតនកុតូឞុ នូតនំ ទ្រាក្ឞារសំ ន ស្ថាបយតិ, យតោ នូតនទ្រាក្ឞារសស្យ តេជសា តាះ កុត្វោ វិទីយ៌្យន្តេ តតោ ទ្រាក្ឞារសឝ្ច បតតិ កុត្វឝ្ច នឝ្យន្តិ, អតឯវ នូតនទ្រាក្ឞារសោ នូតនកុតូឞុ ស្ថាបនីយះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","តទនន្តរំ យីឝុ រ្យទា វិឝ្រាមវារេ ឝស្យក្ឞេត្រេណ គច្ឆតិ តទា តស្យ ឝិឞ្យា គច្ឆន្តះ ឝស្យមញ្ជរីឝ្ឆេត្តុំ ប្រវ្ឫត្តាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","អតះ ផិរូឝិនោ យីឝវេ កថយាមាសុះ បឝ្យតុ វិឝ្រាមវាសរេ យត៑ កម៌្ម ន កត៌្តវ្យំ តទ៑ ឥមេ កុតះ កុវ៌្វន្តិ? ");
INSERT INTO sankhm_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","តទា ស តេភ្យោៜកថយត៑ ទាយូទ៑ តត្សំង្គិនឝ្ច ភក្ឞ្យាភាវាត៑ ក្ឞុធិតាះ សន្តោ យត៑ កម៌្ម ក្ឫតវន្តស្តត៑ កិំ យុឞ្មាភិ រ្ន បឋិតម៑? ");
INSERT INTO sankhm_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","អពិយាថន៌ាមកេ មហាយាជកតាំ កុវ៌្វតិ ស កថមីឝ្វរស្យាវាសំ ប្រវិឝ្យ យេ ទឝ៌នីយបូបា យាជកាន៑ វិនាន្យស្យ កស្យាបិ ន ភក្ឞ្យាស្តានេវ ពុភុជេ សង្គិលោកេភ្យោៜបិ ទទៅ។ ");
INSERT INTO sankhm_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","សោៜបរមបិ ជគាទ, វិឝ្រាមវារោ មនុឞ្យាត៌្ហមេវ និរូបិតោៜស្តិ កិន្តុ មនុឞ្យោ វិឝ្រាមវារាត៌្ហំ នៃវ។ ");
INSERT INTO sankhm_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","មនុឞ្យបុត្រោ វិឝ្រាមវារស្យាបិ ប្រភុរាស្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","អនន្តរំ យីឝុះ បុន រ្ភជនគ្ឫហំ ប្រវិឞ្ដស្តស្មិន៑ ស្ថានេ ឝុឞ្កហស្ត ឯកោ មានវ អាសីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ស វិឝ្រាមវារេ តមរោគិណំ ករិឞ្យតិ នវេត្យត្រ ពហវស្តម៑ អបវទិតុំ ឆិទ្រមបេក្ឞិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","តទា ស តំ ឝុឞ្កហស្តំ មនុឞ្យំ ជគាទ មធ្យស្ថានេ ត្វមុត្តិឞ្ឋ។ ");
INSERT INTO sankhm_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","តតះ បរំ ស តាន៑ បប្រច្ឆ វិឝ្រាមវារេ ហិតមហិតំ តថា ហិ ប្រាណរក្ឞា វា ប្រាណនាឝ ឯឞាំ មធ្យេ កិំ ករណីយំ ? កិន្តុ តេ និះឝព្ទាស្តស្ថុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","តទា ស តេឞាមន្តះករណានាំ កាឋិន្យាទ្ធេតោ រ្ទុះខិតះ ក្រោធាត៑ ចត៌ុिទឝោ ទ្ឫឞ្ដវាន៑ តំ មានុឞំ គទិតវាន៑ តំ ហស្តំ វិស្តារយ, តតស្តេន ហស្តេ វិស្ត្ឫតេ តទ្ធស្តោៜន្យហស្តវទ៑ អរោគោ ជាតះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","អថ ផិរូឝិនះ ប្រស្ថាយ តំ នាឝយិតុំ ហេរោទីយៃះ សហ មន្ត្រយិតុមារេភិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","អតឯវ យីឝុស្តត្ស្ថានំ បរិត្យជ្យ ឝិឞ្យៃះ សហ បុនះ សាគរសមីបំ គតះ; ");
INSERT INTO sankhm_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","តតោ គាលីល្យិហូទា-យិរូឝាលម៑-ឥទោម៑-យទ៌ន្នទីបារស្ថានេភ្យោ លោកសមូហស្តស្យ បឝ្ចាទ៑ គតះ; តទន្យះ សោរសីទនោះ សមីបវាសិលោកសមូហឝ្ច តស្យ មហាកម៌្មណាំ វាត៌្តំ ឝ្រុត្វា តស្យ សន្និធិមាគតះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","តទា លោកសមូហឝ្ចេត៑ តស្យោបរិ បតតិ ឥត្យាឝង្ក្យ ស នាវមេកាំ និកដេ ស្ថាបយិតុំ ឝិឞ្យានាទិឞ្ដវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","យតោៜនេកមនុឞ្យាណាមារោគ្យករណាទ៑ វ្យាធិគ្រស្តាះ សវ៌្វេ តំ ស្ប្រឞ្ដុំ បរស្បរំ ពលេន យត្នវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","អបរញ្ច អបវិត្រភូតាស្តំ ទ្ឫឞ្ដ្វា តច្ចរណយោះ បតិត្វា ប្រោចៃះ ប្រោចុះ, ត្វមីឝ្វរស្យ បុត្រះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","កិន្តុ ស តាន៑ ទ្ឫឍម៑ អាជ្ញាប្យ ស្វំ បរិចាយិតុំ និឞិទ្ធវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","អនន្តរំ ស បវ៌្វតមារុហ្យ យំ យំ ប្រតិច្ឆា តំ តមាហូតវាន៑ តតស្តេ តត្សមីបមាគតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","តទា ស ទ្វាទឝជនាន៑ ស្វេន សហ ស្ថាតុំ សុសំវាទប្រចារាយ ប្រេរិតា ភវិតុំ ");
INSERT INTO sankhm_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","សវ៌្វប្រការវ្យាធីនាំ ឝមនករណាយ ប្រភាវំ ប្រាប្តុំ ភូតាន៑ ត្យាជយិតុញ្ច និយុក្តវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","តេឞាំ នាមានីមានិ, ឝិមោន៑ សិវទិបុត្រោ ");
INSERT INTO sankhm_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","យាកូព៑ តស្យ ភ្រាតា យោហន៑ ច អាន្ទ្រិយះ ផិលិបោ ពត៌្ហលមយះ, ");
INSERT INTO sankhm_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","មថី ថោមា ច អាល្ផីយបុត្រោ យាកូព៑ ថទ្ទីយះ កិនានីយះ ឝិមោន៑ យស្តំ បរហស្តេឞ្វប៌យិឞ្យតិ ស ឦឞ្ករិយោតីយយិហូទាឝ្ច។ ");
INSERT INTO sankhm_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ស ឝិមោនេ បិតរ ឥត្យុបនាម ទទៅ យាកូព្យោហន្ភ្យាំ ច ពិនេរិគិឝ៑ អត៌្ហតោ មេឃនាទបុត្រាវិត្យុបនាម ទទៅ។ ");
INSERT INTO sankhm_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","អនន្តរំ តេ និវេឝនំ គតាះ, កិន្តុ តត្រាបិ បុនម៌ហាន៑ ជនសមាគមោ ៜភវត៑ តស្មាត្តេ ភោក្តុមប្យវកាឝំ ន ប្រាប្តាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","តតស្តស្យ សុហ្ឫល្លោកា ឥមាំ វាត៌្តាំ ប្រាប្យ ស ហតជ្ញានោភូទ៑ ឥតិ កថាំ កថយិត្វា តំ ធ្ឫត្វានេតុំ គតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","អបរញ្ច យិរូឝាលម អាគតា យេ យេៜធ្យាបកាស្តេ ជគទុរយំ បុរុឞោ ភូតបត្យាពិឞ្ដស្តេន ភូតបតិនា ភូតាន៑ ត្យាជយតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","តតស្តានាហូយ យីឝុ រ្ទ្ឫឞ្ដាន្តៃះ កថាំ កថិតវាន៑ ឝៃតាន៑ កថំ ឝៃតានំ ត្យាជយិតុំ ឝក្នោតិ? ");
INSERT INTO sankhm_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","កិញ្ចន រាជ្យំ យទិ ស្វវិរោធេន ប្ឫថគ៑ ភវតិ តហ៌ិ តទ៑ រាជ្យំ ស្ថិរំ ស្ថាតុំ ន ឝក្នោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","តថា កស្យាបិ បរិវារោ យទិ បរស្បរំ វិរោធី ភវតិ តហ៌ិ សោបិ បរិវារះ ស្ថិរំ ស្ថាតុំ ន ឝក្នោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","តទ្វត៑ ឝៃតាន៑ យទិ ស្វវិបក្ឞតយា ឧត្តិឞ្ឋន៑ ភិន្នោ ភវតិ តហ៌ិ សោបិ ស្ថិរំ ស្ថាតុំ ន ឝក្នោតិ កិន្តូច្ឆិន្នោ ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","អបរញ្ច ប្រពលំ ជនំ ប្រថមំ ន ពទ្ធា កោបិ តស្យ គ្ឫហំ ប្រវិឝ្យ ទ្រវ្យាណិ លុណ្ឋយិតុំ ន ឝក្នោតិ, តំ ពទ្វ្វៃវ តស្យ គ្ឫហស្យ ទ្រវ្យាណិ លុណ្ឋយិតុំ ឝក្នោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","អតោហេតោ រ្យុឞ្មភ្យមហំ សត្យំ កថយាមិ មនុឞ្យាណាំ សន្តានា យានិ យានិ បាបានីឝ្វរនិន្ទាញ្ច កុវ៌្វន្តិ តេឞាំ តត្សវ៌្វេឞាមបរាធានាំ ក្ឞមា ភវិតុំ ឝក្នោតិ, ");
INSERT INTO sankhm_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","កិន្តុ យះ កឝ្ចិត៑ បវិត្រមាត្មានំ និន្ទតិ តស្យាបរាធស្យ ក្ឞមា កទាបិ ន ភវិឞ្យតិ សោនន្តទណ្ឌស្យាហ៌ោ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","តស្យាបវិត្រភូតោៜស្តិ តេឞាមេតត្កថាហេតោះ ស ឥត្ថំ កថិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","អថ តស្យ មាតា ភ្រាត្ឫគណឝ្ចាគត្យ ពហិស្តិឞ្ឋនតោ លោកាន៑ ប្រេឞ្យ តមាហូតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","តតស្តត្សន្និធៅ សមុបវិឞ្ដា លោកាស្តំ ពភាឞិរេ បឝ្យ ពហិស្តវ មាតា ភ្រាតរឝ្ច ត្វាម៑ អន្វិច្ឆន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","តទា ស តាន៑ ប្រត្យុវាច មម មាតា កា ភ្រាតរោ វា កេ? តតះ បរំ ស ស្វមីបោបវិឞ្ដាន៑ ឝិឞ្យាន៑ ប្រតិ អវលោកនំ ក្ឫត្វា កថយាមាស ");
INSERT INTO sankhm_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","បឝ្យតៃតេ មម មាតា ភ្រាតរឝ្ច។ ");
INSERT INTO sankhm_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","យះ កឝ្ចិទ៑ ឦឝ្វរស្យេឞ្ដាំ ក្រិយាំ ករោតិ ស ឯវ មម ភ្រាតា ភគិនី មាតា ច។ ");
INSERT INTO sankhm_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","អនន្តរំ ស សមុទ្រតដេ បុនរុបទេឞ្ដុំ ប្រារេភេ, តតស្តត្រ ពហុជនានាំ សមាគមាត៑ ស សាគរោបរិ នៅកាមារុហ្យ សមុបវិឞ្ដះ; សវ៌្វេ លោកាះ សមុទ្រកូលេ តស្ថុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","តទា ស ទ្ឫឞ្ដាន្តកថាភិ រ្ពហូបទិឞ្ដវាន៑ ឧបទិឝំឝ្ច កថិតវាន៑, ");
INSERT INTO sankhm_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","អវធានំ កុរុត, ឯកោ ពីជវប្តា ពីជានិ វប្តុំ គតះ; ");
INSERT INTO sankhm_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","វបនកាលេ កិយន្តិ ពីជានិ មាគ៌បាឝ្វេ បតិតានិ, តត អាកាឝីយបក្ឞិណ ឯត្យ តានិ ចខាទុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","កិយន្តិ ពីជានិ ស្វល្បម្ឫត្តិកាវត្បាឞាណភូមៅ បតិតានិ តានិ ម្ឫទោល្បត្វាត៑ ឝីឃ្រមង្កុរិតានិ; ");
INSERT INTO sankhm_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","កិន្តូទិតេ សូយ៌្យេ ទគ្ធានិ តថា មូលានោ នាធោគតត្វាត៑ ឝុឞ្កាណិ ច។ ");
INSERT INTO sankhm_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","កិយន្តិ ពីជានិ កណ្ដកិវនមធ្យេ បតិតានិ តតះ កណ្ដកានិ សំវ្ឫទ្វ្យ តានិ ជគ្រសុស្តានិ ន ច ផលិតានិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","តថា កិយន្តិ ពីជាន្យុត្តមភូមៅ បតិតានិ តានិ សំវ្ឫទ្វ្យ ផលាន្យុត្បាទិតានិ កិយន្តិ ពីជានិ ត្រិំឝទ្គុណានិ កិយន្តិ ឞឞ្ដិគុណានិ កិយន្តិ ឝតគុណានិ ផលានិ ផលិតវន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","អថ ស តានវទត៑ យស្យ ឝ្រោតុំ កណ៌ៅ ស្តះ ស ឝ្ឫណោតុ។ ");
INSERT INTO sankhm_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","តទនន្តរំ និជ៌នសមយេ តត្សង្គិនោ ទ្វាទឝឝិឞ្យាឝ្ច តំ តទ្ទ្ឫឞ្ដាន្តវាក្យស្យាត៌្ហំ បប្រច្ឆុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","តទា ស តានុទិតវាន៑ ឦឝ្វររាជ្យស្យ និគូឍវាក្យំ ពោទ្ធុំ យុឞ្មាកមធិការោៜស្តិ; ");
INSERT INTO sankhm_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","កិន្តុ យេ វហិព៌្ហូតាះ \"តេ បឝ្យន្តះ បឝ្យន្តិ កិន្តុ ន ជានន្តិ, ឝ្ឫណ្វន្តះ ឝ្ឫណ្វន្តិ កិន្តុ ន ពុធ្យន្តេ, ចេត្តៃ រ្មនះសុ កទាបិ បរិវត៌្តិតេឞុ តេឞាំ បាបាន្យមោចយិឞ្យន្ត,\" អតោហេតោស្តាន៑ ប្រតិ ទ្ឫឞ្ដាន្តៃរេវ តានិ មយា កថិតានិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","អថ ស កថិតវាន៑ យូយំ កិមេតទ៑ ទ្ឫឞ្ដាន្តវាក្យំ ន ពុធ្យធ្វេ? តហ៌ិ កថំ សវ៌្វាន៑ ទ្ឫឞ្ដាន្តាន ភោត្ស្យធ្វេ? ");
INSERT INTO sankhm_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ពីជវប្តា វាក្យរូបាណិ ពីជានិ វបតិ; ");
INSERT INTO sankhm_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","តត្រ យេ យេ លោកា វាក្យំ ឝ្ឫណ្វន្តិ, កិន្តុ ឝ្រុតមាត្រាត៑ ឝៃតាន៑ ឝីឃ្រមាគត្យ តេឞាំ មនះសូប្តានិ តានិ វាក្យរូបាណិ ពីជាន្យបនយតិ តឯវ ឧប្តពីជមាគ៌បាឝ៌្វេស្វរូបាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","យេ ជនា វាក្យំ ឝ្រុត្វា សហសា បរមានន្ទេន គ្ឫហ្លន្តិ, កិន្តុ ហ្ឫទិ ស្ថៃយ៌្យាភាវាត៑ កិញ្ចិត៑ កាលមាត្រំ តិឞ្ឋន្តិ តត្បឝ្ចាត៑ តទ្វាក្យហេតោះ ");
INSERT INTO sankhm_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","កុត្រចិត៑ ក្លេឝេ ឧបទ្រវេ វា សមុបស្ថិតេ តទៃវ វិឃ្នំ ប្រាប្នុវន្តិ តឯវ ឧប្តពីជបាឞាណភូមិស្វរូបាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","យេ ជនាះ កថាំ ឝ្ឫណ្វន្តិ កិន្តុ សាំសារិកី ចិន្តា ធនភ្រាន្តិ រ្វិឞយលោភឝ្ច ឯតេ សវ៌្វេ ឧបស្ថាយ តាំ កថាំ គ្រសន្តិ តតះ មា វិផលា ភវតិ ");
INSERT INTO sankhm_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","តឯវ ឧប្តពីជសកណ្ដកភូមិស្វរូបាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","យេ ជនា វាក្យំ ឝ្រុត្វា គ្ឫហ្លន្តិ តេឞាំ កស្យ វា ត្រិំឝទ្គុណានិ កស្យ វា ឞឞ្ដិគុណានិ កស្យ វា ឝតគុណានិ ផលានិ ភវន្តិ តឯវ ឧប្តពីជោវ៌្វរភូមិស្វរូបាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","តទា សោៜបរមបិ កថិតវាន៑ កោបិ ជនោ ទីបាធារំ បរិត្យជ្យ ទ្រោណស្យាធះ ខដ្វាយា អធេ វា ស្ថាបយិតុំ ទីបមានយតិ កិំ? ");
INSERT INTO sankhm_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","អតោហេតោ រ្យន្ន ប្រកាឝយិឞ្យតេ តាទ្ឫគ៑ លុក្កាយិតំ កិមបិ វស្តុ នាស្តិ; យទ៑ វ្យក្តំ ន ភវិឞ្យតិ តាទ្ឫឝំ គុប្តំ កិមបិ វស្តុ នាស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","យស្យ ឝ្រោតុំ កណ៌ៅ ស្តះ ស ឝ្ឫណោតុ។ ");
INSERT INTO sankhm_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","អបរមបិ កថិតវាន៑ យូយំ យទ៑ យទ៑ វាក្យំ ឝ្ឫណុថ តត្រ សាវធានា ភវត, យតោ យូយំ យេន បរិមាណេន បរិមាថ តេនៃវ បរិមាណេន យុឞ្មទត៌្ហមបិ បរិមាស្យតេ; ឝ្រោតារោ យូយំ យុឞ្មភ្យមធិកំ ទាស្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","យស្យាឝ្រយេ វទ៌្ធតេ តស្មៃ អបរមបិ ទាស្យតេ, កិន្តុ យស្យាឝ្រយេ ន វទ៌្ធតេ តស្យ យត៑ កិញ្ចិទស្តិ តទបិ តស្មាន៑ នេឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","អនន្តរំ ស កថិតវាន៑ ឯកោ លោកះ ក្ឞេត្រេ ពីជាន្យុប្ត្វា ");
INSERT INTO sankhm_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ជាគរណនិទ្រាភ្យាំ ទិវានិឝំ គមយតិ, បរន្តុ តទ្វីជំ តស្យាជ្ញាតរូបេណាង្កុរយតិ វទ៌្ធតេ ច; ");
INSERT INTO sankhm_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","យតោហេតោះ ប្រថមតះ បត្រាណិ តតះ បរំ កណិឝានិ តត្បឝ្ចាត៑ កណិឝបូណ៌ានិ ឝស្យានិ ភូមិះ ស្វយមុត្បាទយតិ; ");
INSERT INTO sankhm_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","កិន្តុ ផលេឞុ បក្កេឞុ ឝស្យច្ឆេទនកាលំ ជ្ញាត្វា ស តត្ក្ឞណំ ឝស្យានិ ឆិនត្តិ, អនេន តុល្យមីឝ្វររាជ្យំ។ ");
INSERT INTO sankhm_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","បុនះ សោៜកថយទ៑ ឦឝ្វររាជ្យំ កេន សមំ? កេន វស្តុនា សហ វា តទុបមាស្យាមិ? ");
INSERT INTO sankhm_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","តត៑ សឞ៌បៃកេន តុល្យំ យតោ ម្ឫទិ វបនកាលេ សឞ៌បពីជំ សវ៌្វប្ឫថិវីស្ថពីជាត៑ ក្ឞុទ្រំ ");
INSERT INTO sankhm_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","កិន្តុ វបនាត៑ បរម៑ អង្កុរយិត្វា សវ៌្វឝាកាទ៑ ព្ឫហទ៑ ភវតិ, តស្យ ព្ឫហត្យះ ឝាខាឝ្ច ជាយន្តេ តតស្តច្ឆាយាំ បក្ឞិណ អាឝ្រយន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ឥត្ថំ តេឞាំ ពោធានុរូបំ សោៜនេកទ្ឫឞ្ដាន្តៃស្តានុបទិឞ្ដវាន៑, ");
INSERT INTO sankhm_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ទ្ឫឞ្ដាន្តំ វិនា កាមបិ កថាំ តេភ្យោ ន កថិតវាន៑ បឝ្ចាន៑ និជ៌នេ ស ឝិឞ្យាន៑ សវ៌្វទ្ឫឞ្ដាន្តាត៌្ហំ ពោធិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","តទ្ទិនស្យ សន្ធ្យាយាំ ស តេភ្យោៜកថយទ៑ អាគច្ឆត វយំ បារំ យាម។ ");
INSERT INTO sankhm_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","តទា តេ លោកាន៑ វិស្ឫជ្យ តមវិលម្ពំ គ្ឫហីត្វា នៅកយា ប្រតស្ថិរេ; អបរា អបិ នាវស្តយា សហ ស្ថិតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","តតះ បរំ មហាឈញ្ភ្ឝគមាត៑ នៅ រ្ទោលាយមានា តរង្គេណ ជលៃះ បូណ៌ាភវច្ច។ ");
INSERT INTO sankhm_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","តទា ស នៅកាចឝ្ចាទ្ភាគេ ឧបធានេ ឝិរោ និធាយ និទ្រិត អាសីត៑ តតស្តេ តំ ជាគរយិត្វា ជគទុះ, ហេ ប្រភោ, អស្មាកំ ប្រាណា យាន្តិ កិមត្រ ភវតឝ្ចិន្តា នាស្តិ? ");
INSERT INTO sankhm_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","តទា ស ឧត្ថាយ វាយុំ តជ៌ិតវាន៑ សមុទ្រញ្ចោក្តវាន៑ ឝាន្តះ សុស្ថិរឝ្ច ភវ; តតោ វាយៅ និវ្ឫត្តេៜព្ធិន៌ិស្តរង្គោភូត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","តទា ស តានុវាច យូយំ កុត ឯតាទ្ឫក្ឝង្កាកុលា ភវត? កិំ វោ វិឝ្វាសោ នាស្តិ? ");
INSERT INTO sankhm_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","តស្មាត្តេៜតីវភីតាះ បរស្បរំ វក្តុមារេភិរេ, អហោ វាយុះ សិន្ធុឝ្ចាស្យ និទេឝគ្រាហិណៅ កីទ្ឫគយំ មនុជះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","អថ តូ សិន្ធុបារំ គត្វា គិទេរីយប្រទេឝ ឧបតស្ថុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","នៅកាតោ និគ៌តមាត្រាទ៑ អបវិត្រភូតគ្រស្ត ឯកះ ឝ្មឝានាទេត្យ តំ សាក្ឞាច៑ ចការ។ ");
INSERT INTO sankhm_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ស ឝ្មឝានេៜវាត្សីត៑ កោបិ តំ ឝ្ឫង្ខលេន ពទ្វ្វា ស្ថាបយិតុំ នាឝក្នោត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ជនៃវ៌ារំ និគឌៃះ ឝ្ឫង្ខលៃឝ្ច ស ពទ្ធោបិ ឝ្ឫង្ខលាន្យាក្ឫឞ្យ មោចិតវាន៑ និគឌានិ ច ភំក្ត្វា ខណ្ឌំ ខណ្ឌំ ក្ឫតវាន៑ កោបិ តំ វឝីកត៌្តុំ ន ឝឝក។ ");
INSERT INTO sankhm_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ទិវានិឝំ សទា បវ៌្វតំ ឝ្មឝានញ្ច ភ្រមិត្វា ចីត្ឝព្ទំ ក្ឫតវាន៑ គ្រាវភិឝ្ច ស្វយំ ស្វំ ក្ឫតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ស យីឝុំ ទូរាត៑ បឝ្យន្នេវ ធាវន៑ តំ ប្រណនាម ឧចៃរុវំឝ្ចោវាច, ");
INSERT INTO sankhm_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ហេ សវ៌្វោបរិស្ថេឝ្វរបុត្រ យីឝោ ភវតា សហ មេ កះ សម្ពន្ធះ? អហំ ត្វាមីឝ្វរេណ ឝាបយេ មាំ មា យាតយ។ ");
INSERT INTO sankhm_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","យតោ យីឝុស្តំ កថិតវាន៑ រេ អបវិត្រភូត, អស្មាន្នរាទ៑ ពហិន៌ិគ៌ច្ឆ។ ");
INSERT INTO sankhm_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","អថ ស តំ ប្ឫឞ្ដវាន៑ កិន្តេ នាម? តេន ប្រត្យុក្តំ វយមនេកេ ៜស្មស្តតោៜស្មន្នាម ពាហិនី។ ");
INSERT INTO sankhm_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","តតោស្មាន៑ ទេឝាន្ន ប្រេឞយេតិ តេ តំ ប្រាត៌្ហយន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","តទានីំ បវ៌្វតំ និកឞា ព្ឫហន៑ វរាហវ្រជឝ្ចរន្នាសីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","តស្មាទ៑ ភូតា វិនយេន ជគទុះ, អមុំ វរាហវ្រជម៑ អាឝ្រយិតុម៑ អស្មាន៑ ប្រហិណុ។ ");
INSERT INTO sankhm_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","យីឝុនានុជ្ញាតាស្តេៜបវិត្រភូតា ពហិន៌ិយ៌ាយ វរាហវ្រជំ ប្រាវិឝន៑ តតះ សវ៌្វេ វរាហា វស្តុតស្តុ ប្រាយោទ្វិសហស្រសំង្ខ្យកាះ កដកេន មហាជវាទ៑ ធាវន្តះ សិន្ធៅ ប្រាណាន៑ ជហុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","តស្មាទ៑ វរាហបាលកាះ បលាយមានាះ បុរេ គ្រាមេ ច តទ្វាត៌្តំ កថយាញ្ចក្រុះ។ តទា លោកា ឃដិតំ តត្កាយ៌្យំ ទ្រឞ្ដុំ ពហិជ៌គ្មុះ ");
INSERT INTO sankhm_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","យីឝោះ សន្និធិំ គត្វា តំ ភូតគ្រស្តម៑ អត៌្ហាទ៑ ពាហិនីភូតគ្រស្តំ នរំ សវស្ត្រំ សចេតនំ សមុបវិឞ្ដញ្ច ទ្ឫृឞ្ដ្វា ពិភ្យុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","តតោ ទ្ឫឞ្ដតត្កាយ៌្យលោកាស្តស្យ ភូតគ្រស្តនរស្យ វរាហវ្រជស្យាបិ តាំ ធដនាំ វណ៌យាមាសុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","តតស្តេ ស្វសីមាតោ ពហិគ៌ន្តុំ យីឝុំ វិនេតុមារេភិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","អថ តស្យ នៅការោហណកាលេ ស ភូតមុក្តោ នា យីឝុនា សហ ស្ថាតុំ ប្រាត៌្ហយតេ; ");
INSERT INTO sankhm_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","កិន្តុ ស តមននុមត្យ កថិតវាន៑ ត្វំ និជាត្មីយានាំ សមីបំ គ្ឫហញ្ច គច្ឆ ប្រភុស្ត្វយិ ក្ឫបាំ ក្ឫត្វា យានិ កម៌្មាណិ ក្ឫតវាន៑ តានិ តាន៑ ជ្ញាបយ។ ");
INSERT INTO sankhm_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","អតះ ស ប្រស្ថាយ យីឝុនា ក្ឫតំ តត្សវ៌្វាឝ្ចយ៌្យំ កម៌្ម ទិកាបលិទេឝេ ប្រចារយិតុំ ប្រារព្ធវាន៑ តតះ សវ៌្វេ លោកា អាឝ្ចយ៌្យំ មេនិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","អនន្តរំ យីឝៅ នាវា បុនរន្យបារ ឧត្តីណ៌េ សិន្ធុតដេ ច តិឞ្ឋតិ សតិ តត្សមីបេ ពហុលោកានាំ សមាគមោៜភូត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","អបរំ យាយីរ៑ នាម្នា កឝ្ចិទ៑ ភជនគ្ឫហស្យាធិប អាគត្យ តំ ទ្ឫឞ្ដ្វៃវ ចរណយោះ បតិត្វា ពហុ និវេទ្យ កថិតវាន៑; ");
INSERT INTO sankhm_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","មម កន្យា ម្ឫតប្រាយាភូទ៑ អតោ ភវានេត្យ តទារោគ្យាយ តស្យា គាត្រេ ហស្តម៑ អប៌យតុ តេនៃវ សា ជីវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","តទា យីឝុស្តេន សហ ចលិតះ កិន្តុ តត្បឝ្ចាទ៑ ពហុលោកាឝ្ចលិត្វា តាទ្គាត្រេ បតិតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","អថ ទ្វាទឝវឞ៌ាណិ ប្រទររោគេណ ");
INSERT INTO sankhm_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ឝីណ៌ា ចិកិត្សកានាំ នានាចិកិត្សាភិឝ្ច ទុះខំ ភុក្តវតី ច សវ៌្វស្វំ វ្យយិត្វាបិ នារោគ្យំ ប្រាប្តា ច បុនរបិ បីឌិតាសីច្ច ");
INSERT INTO sankhm_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","យា ស្ត្រី សា យីឝោ រ្វាត៌្តាំ ប្រាប្យ មនសាកថយត៑ យទ្យហំ តស្យ វស្ត្រមាត្រ ស្ប្រឞ្ដុំ លភេយំ តទា រោគហីនា ភវិឞ្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","អតោហេតោះ សា លោការណ្យមធ្យេ តត្បឝ្ចាទាគត្យ តស្យ វស្ត្រំ បស្បឝ៌។ ");
INSERT INTO sankhm_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","តេនៃវ តត្ក្ឞណំ តស្យា រក្តស្រោតះ ឝុឞ្កំ ស្វយំ តស្មាទ៑ រោគាន្មុក្តា ឥត្យបិ ទេហេៜនុភូតា។ ");
INSERT INTO sankhm_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","អថ ស្វស្មាត៑ ឝក្តិ រ្និគ៌តា យីឝុរេតន្មនសា ជ្ញាត្វា លោកនិវហំ ប្រតិ មុខំ វ្យាវ្ឫត្យ ប្ឫឞ្ដវាន៑ កេន មទ្វស្ត្រំ ស្ប្ឫឞ្ដំ? ");
INSERT INTO sankhm_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","តតស្តស្យ ឝិឞ្យា ឩចុះ ភវតោ វបុឞិ លោកាះ សំឃឞ៌ន្តិ តទ៑ ទ្ឫឞ្ដ្វា កេន មទ្វស្ត្រំ ស្ប្ឫឞ្ដមិតិ កុតះ កថយតិ? ");
INSERT INTO sankhm_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","កិន្តុ កេន តត៑ កម៌្ម ក្ឫតំ តទ៑ ទ្រឞ្ដុំ យីឝុឝ្ចតុទ៌ិឝោ ទ្ឫឞ្ដវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","តតះ សា ស្ត្រី ភីតា កម្បិតា ច សតី ស្វស្យា រុក្ប្រតិក្រិយា ជាតេតិ ជ្ញាត្វាគត្យ តត្សម្មុខេ បតិត្វា សវ៌្វវ្ឫត្តាន្តំ សត្យំ តស្មៃ កថយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","តទានីំ យីឝុស្តាំ គទិតវាន៑, ហេ កន្យេ តវ ប្រតីតិស្ត្វាម៑ អរោគាមករោត៑ ត្វំ ក្ឞេមេណ វ្រជ ស្វរោគាន្មុក្តា ច តិឞ្ឋ។ ");
INSERT INTO sankhm_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ឥតិវាក្យវទនកាលេ ភជនគ្ឫហាធិបស្យ និវេឝនាល៑ លោកា ឯត្យាធិបំ ពភាឞិរេ តវ កន្យា ម្ឫតា តស្មាទ៑ គុរុំ បុនះ កុតះ ក្លិឝ្នាសិ? ");
INSERT INTO sankhm_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","កិន្តុ យីឝុស្តទ៑ វាក្យំ ឝ្រុត្វៃវ ភជនគ្ឫហាធិបំ គទិតវាន៑ មា ភៃឞីះ កេវលំ វិឝ្វាសិហិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","អថ បិតរោ យាកូព៑ តទ្ភ្រាតា យោហន៑ ច ឯតាន៑ វិនា កមបិ ស្វបឝ្ចាទ៑ យាតុំ នាន្វមន្យត។ ");
INSERT INTO sankhm_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","តស្យ ភជនគ្ឫហាធិបស្យ និវេឝនសមីបម៑ អាគត្យ កលហំ ពហុរោទនំ វិលាបញ្ច កុវ៌្វតោ លោកាន៑ ទទឝ៌។ ");
INSERT INTO sankhm_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","តស្មាន៑ និវេឝនំ ប្រវិឝ្យ ប្រោក្តវាន៑ យូយំ កុត ឥត្ថំ កលហំ រោទនញ្ច កុរុថ? កន្យា ន ម្ឫតា និទ្រាតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","តស្មាត្តេ តមុបជហសុះ កិន្តុ យីឝុះ សវ៌្វាន ពហិឞ្ក្ឫត្យ កន្យាយាះ បិតរៅ ស្វសង្គិនឝ្ច គ្ឫហីត្វា យត្រ កន្យាសីត៑ តត៑ ស្ថានំ ប្រវិឞ្ដវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","អថ ស តស្យាះ កន្យាយា ហស្តៅ ធ្ឫត្វា តាំ ពភាឞេ ដាលីថា កូមី, អត៌្ហតោ ហេ កន្យេ ត្វមុត្តិឞ្ឋ ឥត្យាជ្ញាបយាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","តុនៃវ តត្ក្ឞណំ សា ទ្វាទឝវឞ៌វយស្កា កន្យា បោត្ថាយ ចលិតុមារេភេ, ឥតះ សវ៌្វេ មហាវិស្មយំ គតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","តត ឯតស្យៃ កិញ្ចិត៑ ខាទ្យំ ទត្តេតិ កថយិត្វា ឯតត្កម៌្ម កមបិ ន ជ្ញាបយតេតិ ទ្ឫឍមាទិឞ្ដវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","អនន្តរំ ស តត្ស្ថានាត៑ ប្រស្ថាយ ស្វប្រទេឝមាគតះ ឝិឞ្យាឝ្ច តត្បឝ្ចាទ៑ គតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","អថ វិឝ្រាមវារេ សតិ ស ភជនគ្ឫហេ ឧបទេឞ្ដុមារព្ធវាន៑ តតោៜនេកេ លោកាស្តត្កថាំ ឝ្រុត្វា វិស្មិត្យ ជគទុះ, អស្យ មនុជស្យ ឦទ្ឫឝី អាឝ្ចយ៌្យក្រិយា កស្មាជ៑ ជាតា? តថា ស្វករាភ្យាម៑ ឥត្ថមទ្ភុតំ កម៌្ម កត៌្តាुម៑ ឯតស្មៃ កថំ ជ្ញានំ ទត្តម៑? ");
INSERT INTO sankhm_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","កិមយំ មរិយមះ បុត្រស្តជ្ញា នោ? កិមយំ យាកូព៑-យោសិ-យិហុទា-ឝិមោនាំ ភ្រាតា នោ? អស្យ ភគិន្យះ កិមិហាស្មាភិះ សហ នោ? ឥត្ថំ តេ តទត៌្ហេ ប្រត្យូហំ គតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","តទា យីឝុស្តេភ្យោៜកថយត៑ ស្វទេឝំ ស្វកុដុម្ពាន៑ ស្វបរិជនាំឝ្ច វិនា កុត្រាបិ ភវិឞ្យទ្វាទី អសត្ក្ឫតោ ន ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","អបរញ្ច តេឞាមប្រត្យយាត៑ ស វិស្មិតះ កិយតាំ រោគិណាំ វបុះឞុ ហស្តម៑ អប៌យិត្វា កេវលំ តេឞាមារោគ្យករណាទ៑ អន្យត៑ កិមបិ ចិត្រកាយ៌្យំ កត៌្តាំ ន ឝក្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","អថ ស ចតុទ៌ិក្ស្ថ គ្រាមាន៑ ភ្រមិត្វា ឧបទិឞ្ដវាន្ ");
INSERT INTO sankhm_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ទ្វាទឝឝិឞ្យាន៑ អាហូយ អមេធ្យភូតាន៑ វឝីកត៌្តាំ ឝក្តិំ ទត្ត្វា តេឞាំ ទ្វៅ ទ្វៅ ជនោ ប្រេឞិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","បុនរិត្យាទិឝទ៑ យូយម៑ ឯកៃកាំ យឞ្ដិំ វិនា វស្ត្រសំបុដះ បូបះ កដិពន្ធេ តាម្រខណ្ឌញ្ច ឯឞាំ កិមបិ មា គ្រហ្លីត, ");
INSERT INTO sankhm_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","មាគ៌យាត្រាយៃ បាទេឞូបានហៅ ទត្ត្វា ទ្វេ ឧត្តរីយេ មា បរិធទ្វ្វំ។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","អបរមប្យុក្តំ តេន យូយំ យស្យាំ បុយ៌្យាំ យស្យ និវេឝនំ ប្រវេក្ឞ្យថ តាំ បុរីំ យាវន្ន ត្យក្ឞ្យថ តាវត៑ តន្និវេឝនេ ស្ថាស្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","តត្រ យទិ កេបិ យុឞ្មាកមាតិថ្យំ ន វិទធតិ យុឞ្មាកំ កថាឝ្ច ន ឝ្ឫណ្វន្តិ តហ៌ិ តត្ស្ថានាត៑ ប្រស្ថានសមយេ តេឞាំ វិរុទ្ធំ សាក្ឞ្យំ ទាតុំ ស្វបាទានាស្ផាល្យ រជះ សម្បាតយត; អហំ យុឞ្មាន៑ យថាត៌្ហំ វច្មិ វិចារទិនេ តន្នគរស្យាវស្ថាតះ សិទោមាមោរយោ រ្នគរយោរវស្ថា សហ្យតរា ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","អថ តេ គត្វា លោកានាំ មនះបរាវត៌្តនីះ កថា ប្រចារិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ឯវមនេកាន៑ ភូតាំឝ្ច ត្យាជិតវន្តស្តថា តៃលេន មទ៌្ទយិត្វា ពហូន៑ ជនានរោគានកាឞ៌ុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ឥត្ថំ តស្យ សុខ្យាតិឝ្ចតុទ៌ិឝោ វ្យាប្តា តទា ហេរោទ៑ រាជា តន្និឝម្យ កថិតវាន៑, យោហន៑ មជ្ជកះ ឝ្មឝានាទ៑ ឧត្ថិត អតោហេតោស្តេន សវ៌្វា ឯតា អទ្ភុតក្រិយាះ ប្រកាឝន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","អន្យេៜកថយន៑ អយម៑ ឯលិយះ, កេបិ កថិតវន្ត ឯឞ ភវិឞ្យទ្វាទី យទ្វា ភវិឞ្យទ្វាទិនាំ សទ្ឫឝ ឯកោយម៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","កិន្តុ ហេរោទ៑ ឥត្យាកណ៌្យ ភាឞិតវាន៑ យស្យាហំ ឝិរឝ្ឆិន្នវាន៑ ស ឯវ យោហនយំ ស ឝ្មឝានាទុទតិឞ្ឋត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","បូវ៌្វំ ស្វភ្រាតុះ ផិលិបស្យ បត្ន្យា ឧទ្វាហំ ក្ឫតវន្តំ ហេរោទំ យោហនវាទីត៑ ស្វភាត្ឫវធូ រ្ន វិវាហ្យា។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","អតះ ការណាត៑ ហេរោទ៑ លោកំ ប្រហិត្យ យោហនំ ធ្ឫត្វា ពន្ធនាលយេ ពទ្ធវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ហេរោទិយា តស្មៃ យោហនេ ប្រកុប្យ តំ ហន្តុម៑ ឰច្ឆត៑ កិន្តុ ន ឝក្តា, ");
INSERT INTO sankhm_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","យស្មាទ៑ ហេរោទ៑ តំ ធាម៌្មិកំ សត្បុរុឞញ្ច ជ្ញាត្វា សម្មន្យ រក្ឞិតវាន៑; តត្កថាំ ឝ្រុត្វា តទនុសារេណ ពហូនិ កម៌្មាណិ ក្ឫតវាន៑ ហ្ឫឞ្ដមនាស្តទុបទេឝំ ឝ្រុតវាំឝ្ច។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","កិន្តុ ហេរោទ៑ យទា ស្វជន្មទិនេ ប្រធានលោកេភ្យះ សេនានីភ្យឝ្ច គាលីល្ប្រទេឝីយឝ្រេឞ្ឋលោកេភ្យឝ្ច រាត្រៅ ភោជ្យមេកំ ក្ឫតវាន្ ");
INSERT INTO sankhm_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","តស្មិន៑ ឝុភទិនេ ហេរោទិយាយាះ កន្យា សមេត្យ តេឞាំ សមក្ឞំ សំន្ឫត្យ ហេរោទស្តេន សហោបវិឞ្ដានាញ្ច តោឞមជីជនត៑ តតា ន្ឫបះ កន្យាមាហ ស្ម មត្តោ យទ៑ យាចសេ តទេវ តុភ្យំ ទាស្យេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ឝបថំ ក្ឫត្វាកថយត៑ ចេទ៑ រាជ្យាទ៌្ធមបិ យាចសេ តទបិ តុភ្យំ ទាស្យេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","តតះ សា ពហិ រ្គត្វា ស្វមាតរំ បប្រច្ឆ កិមហំ យាចិឞ្យេ? តទា សាកថយត៑ យោហនោ មជ្ជកស្យ ឝិរះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","អថ តូណ៌ំ ភូបសមីបម៑ ឯត្យ យាចមានាវទត៑ ក្ឞណេស្មិន៑ យោហនោ មជ្ជកស្យ ឝិរះ បាត្រេ និធាយ ទេហិ, ឯតទ៑ យាចេៜហំ។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","តស្មាត៑ ភូបោៜតិទុះខិតះ, តថាបិ ស្វឝបថស្យ សហភោជិនាញ្ចានុរោធាត៑ តទនង្គីកត៌្តុំ ន ឝក្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","តត្ក្ឞណំ រាជា ឃាតកំ ប្រេឞ្យ តស្យ ឝិរ អានេតុមាទិឞ្ដវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","តតះ ស ការាគារំ គត្វា តច្ឆិរឝ្ឆិត្វា បាត្រេ និធាយានីយ តស្យៃ កន្យាយៃ ទត្តវាន៑ កន្យា ច ស្វមាត្រេ ទទៅ។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","អននតរំ យោហនះ ឝិឞ្យាស្តទ្វាត៌្តាំ ប្រាប្យាគត្យ តស្យ កុណបំ ឝ្មឝានេៜស្ថាបយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","អថ ប្រេឞិតា យីឝោះ សន្និធៅ មិលិតា យទ៑ យច៑ ចក្រុះ ឝិក្ឞយាមាសុឝ្ច តត្សវ៌្វវាត៌្តាស្តស្មៃ កថិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ស តានុវាច យូយំ វិជនស្ថានំ គត្វា វិឝ្រាម្យត យតស្តត្សន្និធៅ ពហុលោកានាំ សមាគមាត៑ តេ ភោក្តុំ នាវកាឝំ ប្រាប្តាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","តតស្តេ នាវា វិជនស្ថានំ គុប្តំ គគ្មុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","តតោ លោកនិវហស្តេឞាំ ស្ថានាន្តរយានំ ទទឝ៌, អនេកេ តំ បរិចិត្យ នានាបុរេភ្យះ បទៃវ៌្រជិត្វា ជវេន តៃឞាមគ្រេ យីឝោះ សមីប ឧបតស្ថុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","តទា យីឝុ រ្នាវោ ពហិគ៌ត្យ លោការណ្យានីំ ទ្ឫឞ្ដ្វា តេឞុ ករុណាំ ក្ឫតវាន៑ យតស្តេៜរក្ឞកមេឞា ឥវាសន៑ តទា ស តាន នានាប្រសង្គាន៑ ឧបទិឞ្ដវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","អថ ទិវាន្តេ សតិ ឝិឞ្យា ឯត្យ យីឝុមូចិរេ, ឥទំ វិជនស្ថានំ ទិនញ្ចាវសន្នំ។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","លោកានាំ កិមបិ ខាទ្យំ នាស្តិ, អតឝ្ចតុទ៌ិក្ឞុ គ្រាមាន៑ គន្តុំ ភោជ្យទ្រវ្យាណិ ក្រេតុញ្ច ភវាន៑ តាន៑ វិស្ឫជតុ។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","តទា ស តានុវាច យូយមេវ តាន៑ ភោជយត; តតស្តេ ជគទុ រ្វយំ គត្វា ទ្វិឝតសំខ្យកៃ រ្មុទ្រាបាទៃះ បូបាន៑ ក្រីត្វា កិំ តាន៑ ភោជយិឞ្យាមះ? ");
INSERT INTO sankhm_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","តទា ស តាន៑ ប្ឫឞ្ឋវាន៑ យុឞ្មាកំ សន្និធៅ កតិ បូបា អាសតេ? គត្វា បឝ្យត; តតស្តេ ទ្ឫឞ្ដ្វា តមវទន៑ បញ្ច បូបា ទ្វៅ មត្ស្យៅ ច សន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","តទា ស លោកាន៑ ឝស្បោបរិ បំក្តិភិរុបវេឝយិតុម៑ អាទិឞ្ដវាន៑, ");
INSERT INTO sankhm_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","តតស្តេ ឝតំ ឝតំ ជនាះ បញ្ចាឝត៑ បញ្ចាឝជ្ជនាឝ្ច បំក្តិភិ រ្ភុវិ សមុបវិវិឝុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","អថ ស តាន៑ បញ្ចបូបាន៑ មត្ស្យទ្វយញ្ច ធ្ឫត្វា ស្វគ៌ំ បឝ្យន៑ ឦឝ្វរគុណាន៑ អន្វកីត៌្តយត៑ តាន៑ បូបាន៑ ភំក្ត្វា លោកេភ្យះ បរិវេឞយិតុំ ឝិឞ្យេភ្យោ ទត្តវាន៑ ទ្វា មត្ស្យៅ ច វិភជ្យ សវ៌្វេភ្យោ ទត្តវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","តតះ សវ៌្វេ ភុក្ត្វាត្ឫប្យន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","អនន្តរំ ឝិឞ្យា អវឝិឞ្ដៃះ បូបៃ រ្មត្ស្យៃឝ្ច បូណ៌ាន៑ ទ្វទឝ ឌល្លកាន៑ ជគ្ឫហុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","តេ ភោក្តារះ ប្រាយះ បញ្ច សហស្រាណិ បុរុឞា អាសន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","អថ ស លោកាន៑ វិស្ឫជន្នេវ នាវមារោឍុំ ស្វស្មាទគ្រេ បារេ ពៃត្សៃទាបុរំ យាតុញ្ច ឝ្ឞ្យិाន៑ វាឍមាទិឞ្ដវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","តទា ស សវ៌្វាន៑ វិស្ឫជ្យ ប្រាត៌្ហយិតុំ បវ៌្វតំ គតះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","តតះ សន្ធ្យាយាំ សត្យាំ នៅះ សិន្ធុមធ្យ ឧបស្ថិតា កិន្តុ ស ឯកាកី ស្ថលេ ស្ថិតះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","អថ សម្មុខវាតវហនាត៑ ឝិឞ្យា នាវំ វាហយិត្វា បរិឝ្រាន្តា ឥតិ ជ្ញាត្វា ស និឝាចតុត៌្ហយាមេ សិន្ធូបរិ បទ្ភ្យាំ វ្រជន៑ តេឞាំ សមីបមេត្យ តេឞាមគ្រេ យាតុម៑ ឧទ្យតះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","កិន្តុ ឝិឞ្យាះ សិន្ធូបរិ តំ វ្រជន្តំ ទ្ឫឞ្ដ្វា ភូតមនុមាយ រុរុវុះ, ");
INSERT INTO sankhm_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","យតះ សវ៌្វេ តំ ទ្ឫឞ្ដ្វា វ្យាកុលិតាះ។ អតឯវ យីឝុស្តត្ក្ឞណំ តៃះ សហាលប្យ កថិតវាន៑, សុស្ថិរា ភូត, អយមហំ មា ភៃឞ្ដ។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","អថ នៅកាមារុហ្យ តស្មិន៑ តេឞាំ សន្និធិំ គតេ វាតោ និវ្ឫត្តះ; តស្មាត្តេ មនះសុ វិស្មិតា អាឝ្ចយ៌្យំ មេនិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","យតស្តេ មនសាំ កាឋិន្យាត៑ តត៑ បូបីយម៑ អាឝ្ចយ៌្យំ កម៌្ម ន វិវិក្តវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","អថ តេ បារំ គត្វា គិនេឞរត្ប្រទេឝមេត្យ តដ ឧបស្ថិតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","តេឞុ នៅកាតោ ពហិគ៌តេឞុ តត្ប្រទេឝីយា លោកាស្តំ បរិចិត្យ ");
INSERT INTO sankhm_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ចតុទ៌ិក្ឞុ ធាវន្តោ យត្រ យត្រ រោគិណោ នរា អាសន៑ តាន៑ សវ៌្វាន ខដ្វោបរិ និធាយ យត្រ កុត្រចិត៑ តទ្វាត៌្តាំ ប្រាបុះ តត៑ ស្ថានម៑ អានេតុម៑ អារេភិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","តថា យត្រ យត្រ គ្រាមេ យត្រ យត្រ បុរេ យត្រ យត្រ បល្ល្យាញ្ច តេន ប្រវេឝះ ក្ឫតស្តទ្វត៌្មមធ្យេ លោកាះ បីឌិតាន៑ ស្ថាបយិត្វា តស្យ ចេលគ្រន្ថិមាត្រំ ស្ប្រឞ្ដុម៑ តេឞាមត៌្ហេ តទនុជ្ញាំ ប្រាត៌្ហយន្តះ យាវន្តោ លោកាះ បស្ប្ឫឝុស្តាវន្ត ឯវ គទាន្មុក្តាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","អនន្តរំ យិរូឝាលម អាគតាះ ផិរូឝិនោៜធ្យាបកាឝ្ច យីឝោះ សមីបម៑ អាគតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","តេ តស្យ កិយតះ ឝិឞ្យាន៑ អឝុចិករៃរត៌្ហាទ អប្រក្ឞាលិតហស្តៃ រ្ភុញ្ជតោ ទ្ឫឞ្ដ្វា តានទូឞយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","យតះ ផិរូឝិនះ សវ៌្វយិហូទីយាឝ្ច ប្រាចាំ បរម្បរាគតវាក្យំ សម្មន្យ ប្រតលេន ហស្តាន៑ អប្រក្ឞាល្យ ន ភុញ្ជតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","អាបនាទាគត្យ មជ្ជនំ វិនា ន ខាទន្តិ; តថា បានបាត្រាណាំ ជលបាត្រាណាំ បិត្តលបាត្រាណាម៑ អាសនានាញ្ច ជលេ មជ្ជនម៑ ឥត្យាទយោន្យេបិ ពហវស្តេឞាមាចារាះ សន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","តេ ផិរូឝិនោៜធ្យាបកាឝ្ច យីឝុំ បប្រច្ឆុះ, តវ ឝិឞ្យាះ ប្រាចាំ បរម្បរាគតវាក្យានុសារេណ នាចរន្តោៜប្រក្ឞាលិតករៃះ កុតោ ភុជំតេ? ");
INSERT INTO sankhm_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","តតះ ស ប្រត្យុវាច កបដិនោ យុឞ្មាន៑ ឧទ្ទិឝ្យ យិឝយិយភវិឞ្យទ្វាទី យុក្តមវាទីត៑។ យថា ស្វកីយៃរធរៃរេតេ សម្មន្យនតេ សទៃវ មាំ។ កិន្តុ មត្តោ វិប្រកឞ៌េ សន្តិ តេឞាំ មនាំសិ ច។ ");
INSERT INTO sankhm_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ឝិក្ឞយន្តោ ពិធីន៑ ន្នាជ្ញា ភជន្តេ មាំ មុធៃវ តេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","យូយំ ជលបាត្របានបាត្រាទីនិ មជ្ជយន្តោ មនុជបរម្បរាគតវាក្យំ រក្ឞថ កិន្តុ ឦឝ្វរាជ្ញាំ លំឃធ្វេ; អបរា ឦទ្ឫឝ្យោនេកាះ ក្រិយា អបិ កុរុធ្វេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","អន្យញ្ចាកថយត៑ យូយំ ស្វបរម្បរាគតវាក្យស្យ រក្ឞាត៌្ហំ ស្បឞ្ដរូបេណ ឦឝ្វរាជ្ញាំ លោបយថ។ ");
INSERT INTO sankhm_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","យតោ មូសាទ្វារា ប្រោក្តមស្តិ ស្វបិតរៅ សម្មន្យធ្វំ យស្តុ មាតរំ បិតរំ វា ទុវ៌្វាក្យំ វក្តិ ស និតាន្តំ ហន្យតាំ។ ");
INSERT INTO sankhm_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","កិន្តុ មទីយេន យេន ទ្រវ្យេណ តវោបការោភវត៑ តត៑ កព៌្ពាណមត៌្ហាទ៑ ឦឝ្វរាយ និវេទិតម៑ ឥទំ វាក្យំ យទិ កោបិ បិតរំ មាតរំ វា វក្តិ ");
INSERT INTO sankhm_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","តហ៌ិ យូយំ មាតុះ បិតុ រ្វោបការំ កត៌្តាំ តំ វារយថ។ ");
INSERT INTO sankhm_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ឥត្ថំ ស្វប្រចារិតបរម្បរាគតវាក្យេន យូយម៑ ឦឝ្វរាជ្ញាំ មុធា វិធទ្វ្វេ, ឦទ្ឫឝាន្យន្យាន្យនេកានិ កម៌្មាណិ កុរុធ្វេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","អថ ស លោកានាហូយ ពភាឞេ យូយំ សវ៌្វេ មទ្វាក្យំ ឝ្ឫណុត ពុធ្យធ្វញ្ច។ ");
INSERT INTO sankhm_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ពាហ្យាទន្តរំ ប្រវិឝ្យ នរមមេធ្យំ កត៌្តាំ ឝក្នោតិ ឦទ្ឫឝំ កិមបិ វស្តុ នាស្តិ, វរម៑ អន្តរាទ៑ ពហិគ៌តំ យទ្វស្តុ តន្មនុជម៑ អមេធ្យំ ករោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","យស្យ ឝ្រោតុំ ឝ្រោត្រេ ស្តះ ស ឝ្ឫណោតុ។ ");
INSERT INTO sankhm_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","តតះ ស លោកាន៑ ហិត្វា គ្ឫហមធ្យំ ប្រវិឞ្ដស្តទា ឝិឞ្យាស្តទ្ឫឞ្ដាន្តវាក្យាត៌្ហំ បប្រច្ឆុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","តស្មាត៑ ស តាន៑ ជគាទ យូយមបិ កិមេតាទ្ឫគពោធាះ? កិមបិ ទ្រវ្យំ ពាហ្យាទន្តរំ ប្រវិឝ្យ នរមមេធ្យំ កត៌្តាំ ន ឝក្នោតិ កថាមិមាំ កិំ ន ពុធ្យធ្វេ? ");
INSERT INTO sankhm_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","តត៑ តទន្តន៌ ប្រវិឝតិ កិន្តុ កុក្ឞិមធ្យំ ប្រវិឝតិ ឝេឞេ សវ៌្វភុក្តវស្តុគ្រាហិណិ ពហិទ៌េឝេ និយ៌ាតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","អបរមប្យវាទីទ៑ យន្នរាន្និរេតិ តទេវ នរមមេធ្យំ ករោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","យតោៜន្តរាទ៑ អត៌្ហាន៑ មានវានាំ មនោភ្យះ កុចិន្តា បរស្ត្រីវេឝ្យាគមនំ ");
INSERT INTO sankhm_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","នរវធឝ្ចៅយ៌្យំ លោភោ ទុឞ្ដតា ប្រវញ្ចនា កាមុកតា កុទ្ឫឞ្ដិរីឝ្វរនិន្ទា គវ៌្វស្តម ឥត្យាទីនិ និគ៌ច្ឆន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ឯតានិ សវ៌្វាណិ ទុរិតាន្យន្តរាទេត្យ នរមមេធ្យំ កុវ៌្វន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","អថ ស ឧត្ថាយ តត្ស្ថានាត៑ សោរសីទោន្បុរប្រទេឝំ ជគាម តត្រ កិមបិ និវេឝនំ ប្រវិឝ្យ សវ៌្វៃរជ្ញាតះ ស្ថាតុំ មតិញ្ចក្រេ កិន្តុ គុប្តះ ស្ថាតុំ ន ឝឝាក។ ");
INSERT INTO sankhm_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","យតះ សុរផៃនិកីទេឝីយយូនានីវំឝោទ្ភវស្ត្រិយាះ កន្យា ភូតគ្រស្តាសីត៑។ សា ស្ត្រី តទ្វាត៌្តាំ ប្រាប្យ តត្សមីបមាគត្យ តច្ចរណយោះ បតិត្វា ");
INSERT INTO sankhm_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ស្វកន្យាតោ ភូតំ និរាកត៌្តាំ តស្មិន៑ វិនយំ ក្ឫតវតី។ ");
INSERT INTO sankhm_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","កិន្តុ យីឝុស្តាមវទត៑ ប្រថមំ ពាលកាស្ត្ឫប្យន្តុ យតោ ពាលកានាំ ខាទ្យំ គ្ឫហីត្វា កុក្កុរេភ្យោ និក្ឞេបោៜនុចិតះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","តទា សា ស្ត្រី តមវាទីត៑ ភោះ ប្រភោ តត៑ សត្យំ តថាបិ មញ្ចាធះស្ថាះ កុក្កុរា ពាលានាំ ករបតិតានិ ខាទ្យខណ្ឌានិ ខាទន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","តតះ សោៜកថយទ៑ ឯតត្កថាហេតោះ សកុឝលា យាហិ តវ កន្យាំ ត្យក្ត្វា ភូតោ គតះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","អថ សា ស្ត្រី គ្ឫហំ គត្វា កន្យាំ ភូតត្យក្តាំ ឝយ្យាស្ថិតាំ ទទឝ៌។ ");
INSERT INTO sankhm_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","បុនឝ្ច ស សោរសីទោន្បុរប្រទេឝាត៑ ប្រស្ថាយ ទិកាបលិទេឝស្យ ប្រាន្តរភាគេន គាលីល្ជលធេះ សមីបំ គតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","តទា លោកៃរេកំ ពធិរំ កទ្វទញ្ច នរំ តន្និកដមានីយ តស្យ គាត្រេ ហស្តមប៌យិតុំ វិនយះ ក្ឫតះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","តតោ យីឝុ រ្លោការណ្យាត៑ តំ និជ៌នមានីយ តស្យ កណ៌យោង្គុលី រ្ទទៅ និឞ្ឋីវំ ទត្ត្វា ច តជ្ជិហ្វាំ បស្បឝ៌។ ");
INSERT INTO sankhm_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","អនន្តរំ ស្វគ៌ំ និរីក្ឞ្យ ទីគ៌្ហំ និឝ្វស្យ តមវទត៑ ឥតផតះ អត៌្ហាន៑ មុក្តោ ភូយាត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","តតស្តត្ក្ឞណំ តស្យ កណ៌ៅ មុក្តៅ ជិហ្វាយាឝ្ច ជាឌ្យាបគមាត៑ ស សុស្បឞ្ដវាក្យមកថយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","អថ ស តាន៑ វាឍមិត្យាទិទេឝ យូយមិមាំ កថាំ កស្មៃចិទបិ មា កថយត, កិន្តុ ស យតិ ន្យឞេធត៑ តេ តតិ ពាហុល្យេន ប្រាចារយន៑; ");
INSERT INTO sankhm_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","តេៜតិចមត្ក្ឫត្យ បរស្បរំ កថយាមាសុះ ស ពធិរាយ ឝ្រវណឝក្តិំ មូកាយ ច កថនឝក្តិំ ទត្ត្វា សវ៌្វំ កម៌្មោត្តមរូបេណ ចការ។ ");
INSERT INTO sankhm_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","តទា តត្សមីបំ ពហវោ លោកា អាយាតា អតស្តេឞាំ ភោជ្យទ្រវ្យាភាវាទ៑ យីឝុះ ឝិឞ្យានាហូយ ជគាទ,។ ");
INSERT INTO sankhm_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","លោកនិវហេ មម ក្ឫបា ជាយតេ តេ ទិនត្រយំ មយា សាទ៌្ធំ សន្តិ តេឞាំ ភោជ្យំ កិមបិ នាស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","តេឞាំ មធ្យេៜនេកេ ទូរាទ៑ អាគតាះ, អភុក្តេឞុ តេឞុ មយា ស្វគ្ឫហមភិប្រហិតេឞុ តេ បថិ ក្លមិឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ឝិឞ្យា អវាទិឞុះ, ឯតាវតោ លោកាន៑ តប៌យិតុម៑ អត្រ ប្រន្តរេ បូបាន៑ ប្រាប្តុំ កេន ឝក្យតេ? ");
INSERT INTO sankhm_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","តតះ ស តាន៑ បប្រច្ឆ យុឞ្មាកំ កតិ បូបាះ សន្តិ? តេៜកថយន៑ សប្ត។ ");
INSERT INTO sankhm_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","តតះ ស តាល្លោកាន៑ ភុវិ សមុបវេឞ្ដុម៑ អាទិឝ្យ តាន៑ សប្ត បូបាន៑ ធ្ឫត្វា ឦឝ្វរគុណាន៑ អនុកីត៌្តយាមាស, ភំក្ត្វា បរិវេឞយិតុំ ឝិឞ្យាន៑ ប្រតិ ទទៅ, តតស្តេ លោកេភ្យះ បរិវេឞយាមាសុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","តថា តេឞាំ សមីបេ យេ ក្ឞុទ្រមត្ស្យា អាសន៑ តានប្យាទាយ ឦឝ្វរគុណាន៑ សំកីត៌្យ បរិវេឞយិតុម៑ អាទិឞ្ដវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","តតោ លោកា ភុក្ត្វា ត្ឫប្តិំ គតា អវឝិឞ្ដខាទ្យៃះ បូណ៌ាះ សប្តឌល្លកា គ្ឫហីតាឝ្ច។ ");
INSERT INTO sankhm_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ឯតេ ភោក្តារះ ប្រាយឝ្ចតុះ សហស្របុរុឞា អាសន៑ តតះ ស តាន៑ វិសសជ៌។ ");
INSERT INTO sankhm_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","អថ ស ឝិឞ្យះ សហ នាវមារុហ្យ ទល្មានូថាសីមាមាគតះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","តតះ បរំ ផិរូឝិន អាគត្យ តេន សហ វិវទមានាស្តស្យ បរីក្ឞាត៌្ហម៑ អាកាឝីយចិហ្នំ ទ្រឞ្ដុំ យាចិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","តទា សោៜន្តទ៌ីគ៌្ហំ និឝ្វស្យាកថយត៑, ឯតេ វិទ្យមាននរាះ កុតឝ្ចិន្ហំ ម្ឫគយន្តេ? យុឞ្មានហំ យថាត៌្ហំ ព្រវីមិ លោកានេតាន៑ កិមបិ ចិហ្នំ ន ទឝ៌យិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","អថ តាន៑ ហិត្វា បុន រ្នាវម៑ អារុហ្យ បារមគាត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ឯតហ៌ិ ឝិឞ្យៃះ បូបេឞុ វិស្ម្ឫតេឞុ នាវិ តេឞាំ សន្និធៅ បូប ឯកឯវ ស្ថិតះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","តទានីំ យីឝុស្តាន៑ អាទិឞ្ដវាន៑ ផិរូឝិនាំ ហេរោទឝ្ច កិណ្វំ ប្រតិ សតក៌ាះ សាវធានាឝ្ច ភវត។ ");
INSERT INTO sankhm_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","តតស្តេៜន្យោន្យំ វិវេចនំ កត៌ុម៑ អារេភិរេ, អស្មាកំ សន្និធៅ បូបោ នាស្តីតិ ហេតោរិទំ កថយតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","តទ៑ ពុទ្វ្វា យីឝុស្តេភ្យោៜកថយត៑ យុឞ្មាកំ ស្ថានេ បូបាភាវាត៑ កុត ឥត្ថំ វិតក៌យថ? យូយំ កិមទ្យាបិ កិមបិ ន ជានីថ? ពោទ្ធុញ្ច ន ឝក្នុថ? យាវទទ្យ កិំ យុឞ្មាកំ មនាំសិ កឋិនានិ សន្តិ? ");
INSERT INTO sankhm_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","សត្សុ នេត្រេឞុ កិំ ន បឝ្យថ? សត្សុ កណ៌េឞុ កិំ ន ឝ្ឫណុថ? ន ស្មរថ ច? ");
INSERT INTO sankhm_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","យទាហំ បញ្ចបូបាន៑ បញ្ចសហស្រាណាំ បុរុឞាណាំ មធ្យេ ភំក្ត្វា ទត្តវាន៑ តទានីំ យូយម៑ អវឝិឞ្ដបូបៃះ បូណ៌ាន៑ កតិ ឌល្លកាន៑ គ្ឫហីតវន្តះ? តេៜកថយន៑ ទ្វាទឝឌល្លកាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","អបរញ្ច យទា ចតុះសហស្រាណាំ បុរុឞាណាំ មធ្យេ បូបាន៑ ភំក្ត្វាទទាំ តទា យូយម៑ អតិរិក្តបូបានាំ កតិ ឌល្លកាន៑ គ្ឫហីតវន្តះ? តេ កថយាមាសុះ សប្តឌល្លកាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","តទា ស កថិតវាន៑ តហ៌ិ យូយម៑ អធុនាបិ កុតោ ពោទ្វ្វុំ ន ឝក្នុថ? ");
INSERT INTO sankhm_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","អនន្តរំ តស្មិន៑ ពៃត្សៃទានគរេ ប្រាប្តេ លោកា អន្ធមេកំ នរំ តត្សមីបមានីយ តំ ស្ប្រឞ្ដុំ តំ ប្រាត៌្ហយាញ្ចក្រិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","តទា តស្យាន្ធស្យ ករៅ គ្ឫហីត្វា នគរាទ៑ ពហិទ៌េឝំ តំ នីតវាន៑; តន្នេត្រេ និឞ្ឋីវំ ទត្ត្វា តទ្គាត្រេ ហស្តាវប៌យិត្វា តំ បប្រច្ឆ, កិមបិ បឝ្យសិ? ");
INSERT INTO sankhm_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ស នេត្រេ ឧន្មីល្យ ជគាទ, វ្ឫក្ឞវត៑ មនុជាន៑ គច្ឆតោ និរីក្ឞេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","តតោ យីឝុះ បុនស្តស្យ នយនយោ រ្ហស្តាវប៌យិត្វា តស្យ នេត្រេ ឧន្មីលយាមាស; តស្មាត៑ ស ស្វស្ថោ ភូត្វា ស្បឞ្ដរូបំ សវ៌្វលោកាន៑ ទទឝ៌។ ");
INSERT INTO sankhm_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","តតះ បរំ ត្វំ គ្រាមំ មា គច្ឆ គ្រាមស្ថំ កមបិ ច កិមប្យនុក្ត្វា និជគ្ឫហំ យាហីត្យាទិឝ្យ យីឝុស្តំ និជគ្ឫហំ ប្រហិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","អនន្តរំ ឝិឞ្យៃះ សហិតោ យីឝុះ កៃសរីយាផិលិបិបុរំ ជគាម, បថិ គច្ឆន៑ តានប្ឫច្ឆត៑ កោៜហម៑ អត្រ លោកាះ កិំ វទន្តិ? ");
INSERT INTO sankhm_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","តេ ប្រត្យូចុះ ត្វាំ យោហនំ មជ្ជកំ វទន្តិ កិន្តុ កេបិ កេបិ ឯលិយំ វទន្តិ; អបរេ កេបិ កេបិ ភវិឞ្យទ្វាទិនាម៑ ឯកោ ជន ឥតិ វទន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","អថ ស តានប្ឫច្ឆត៑ កិន្តុ កោហម៑? ឥត្យត្រ យូយំ កិំ វទថ? តទា បិតរះ ប្រត្យវទត៑ ភវាន៑ អភិឞិក្តស្ត្រាតា។ ");
INSERT INTO sankhm_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","តតះ ស តាន៑ គាឍមាទិឝទ៑ យូយំ មម កថា កស្មៃចិទបិ មា កថយត។ ");
INSERT INTO sankhm_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","មនុឞ្យបុត្រេណាវឝ្យំ ពហវោ យាតនា ភោក្តវ្យាះ ប្រាចីនលោកៃះ ប្រធានយាជកៃរធ្យាបកៃឝ្ច ស និន្ទិតះ សន៑ ឃាតយិឞ្យតេ ត្ឫតីយទិនេ ឧត្ថាស្យតិ ច, យីឝុះ ឝិឞ្យានុបទេឞ្ដុមារភ្យ កថាមិមាំ ស្បឞ្ដមាចឞ្ដ។ ");
INSERT INTO sankhm_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","តស្មាត៑ បិតរស្តស្យ ហស្តៅ ធ្ឫត្វា តំ តជ៌្ជិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","កិន្តុ ស មុខំ បរាវត៌្យ ឝិឞ្យគណំ និរីក្ឞ្យ បិតរំ តជ៌យិត្វាវាទីទ៑ ទូរីភវ វិឃ្នការិន៑ ឦឝ្វរីយកាយ៌្យាទបិ មនុឞ្យកាយ៌្យំ តុភ្យំ រោចតតរាំ។ ");
INSERT INTO sankhm_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","អថ ស លោកាន៑ ឝិឞ្យាំឝ្ចាហូយ ជគាទ យះ កឝ្ចិន៑ មាមនុគន្តុម៑ ឥច្ឆតិ ស អាត្មានំ ទាម្យតុ, ស្វក្រុឝំ គ្ឫហីត្វា មត្បឝ្ចាទ៑ អាយាតុ។ ");
INSERT INTO sankhm_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","យតោ យះ កឝ្ចិត៑ ស្វប្រាណំ រក្ឞិតុមិច្ឆតិ ស តំ ហារយិឞ្យតិ, កិន្តុ យះ កឝ្ចិន៑ មទត៌្ហំ សុសំវាទាត៌្ហញ្ច ប្រាណំ ហារយតិ ស តំ រក្ឞិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","អបរញ្ច មនុជះ សវ៌្វំ ជគត៑ ប្រាប្យ យទិ ស្វប្រាណំ ហារយតិ តហ៌ិ តស្យ កោ លាភះ? ");
INSERT INTO sankhm_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","នរះ ស្វប្រាណវិនិមយេន កិំ ទាតុំ ឝក្នោតិ? ");
INSERT INTO sankhm_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ឯតេឞាំ វ្យភិចារិណាំ បាបិនាញ្ច លោកានាំ សាក្ឞាទ៑ យទិ កោបិ មាំ មត្កថាញ្ច លជ្ជាស្បទំ ជានាតិ តហ៌ិ មនុជបុត្រោ យទា ធម៌្មទូតៃះ សហ បិតុះ ប្រភាវេណាគមិឞ្យតិ តទា សោបិ តំ លជ្ជាស្បទំ ជ្ញាស្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","អថ ស តានវាទីត៑ យុឞ្មភ្យមហំ យថាត៌្ហំ កថយាមិ, ឦឝ្វររាជ្យំ បរាក្រមេណោបស្ថិតំ ន ទ្ឫឞ្ដ្វា ម្ឫត្យុំ នាស្វាទិឞ្យន្តេ, អត្រ ទណ្ឌាយមានានាំ មធ្យេបិ តាទ្ឫឝា លោកាះ សន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","អថ ឞឌ្ទិនេភ្យះ បរំ យីឝុះ បិតរំ យាកូពំ យោហនញ្ច គ្ឫហីត្វា គិរេរុច្ចស្យ និជ៌នស្ថានំ គត្វា តេឞាំ ប្រត្យក្ឞេ មូត៌្យន្តរំ ទធារ។ ");
INSERT INTO sankhm_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","តតស្តស្យ បរិធេយម៑ ឦទ្ឫឝម៑ ឧជ្ជ្វលហិមបាណឌរំ ជាតំ យទ៑ ជគតិ កោបិ រជកោ ន តាទ្ឫក៑ បាណឌរំ កត៌្តាំ ឝក្នោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","អបរញ្ច ឯលិយោ មូសាឝ្ច តេភ្យោ ទឝ៌នំ ទត្ត្វា យីឝុនា សហ កថនំ កត៌្តុមារេភាតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","តទា បិតរោ យីឝុមវាទីត៑ ហេ គុរោៜស្មាកមត្រ ស្ថិតិរុត្តមា, តតឯវ វយំ ត្វត្ក្ឫតេ ឯកាំ មូសាក្ឫតេ ឯកាម៑ ឯលិយក្ឫតេ ចៃកាំ, ឯតាស្តិស្រះ កុដី រ្និម៌្មាម។ ");
INSERT INTO sankhm_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","កិន្តុ ស យទុក្តវាន៑ តត៑ ស្វយំ ន ពុពុធេ តតះ សវ៌្វេ ពិភយាញ្ចក្រុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ឯតហ៌ិ បយោទស្តាន៑ ឆាទយាមាស, មមយាំ ប្រិយះ បុត្រះ កថាសុ តស្យ មនាំសិ និវេឝយតេតិ នភោវាណី តន្មេទ្យាន្និយ៌យៅ។ ");
INSERT INTO sankhm_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","អថ ហឋាត្តេ ចតុទ៌ិឝោ ទ្ឫឞ្ដ្វា យីឝុំ វិនា ស្វៃះ សហិតំ កមបិ ន ទទ្ឫឝុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","តតះ បរំ គិរេរវរោហណកាលេ ស តាន៑ គាឍម៑ ទូត្យាទិទេឝ យាវន្នរសូនោះ ឝ្មឝានាទុត្ថានំ ន ភវតិ, តាវត៑ ទឝ៌នស្យាស្យ វាត៌្តា យុឞ្មាភិះ កស្មៃចិទបិ ន វក្តវ្យា។ ");
INSERT INTO sankhm_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","តទា ឝ្មឝានាទុត្ថានស្យ កោភិប្រាយ ឥតិ វិចាយ៌្យ តេ តទ្វាក្យំ ស្វេឞុ គោបាយាញ្ចក្រិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","អថ តេ យីឝុំ បប្រច្ឆុះ ប្រថមត ឯលិយេនាគន្តវ្យម៑ ឥតិ វាក្យំ កុត ឧបាធ្យាយា អាហុះ? ");
INSERT INTO sankhm_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","តទា ស ប្រត្យុវាច , ឯលិយះ ប្រថមមេត្យ សវ៌្វកាយ៌្យាណិ សាធយិឞ្យតិ; នរបុត្រេ ច លិបិ រ្យថាស្តេ តថៃវ សោបិ ពហុទុះខំ ប្រាប្យាវជ្ញាស្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","កិន្ត្វហំ យុឞ្មាន៑ វទាមិ , ឯលិយាត៌្ហេ លិបិ រ្យថាស្តេ តថៃវ ស ឯត្យ យយៅ, លោកា: ស្វេច្ឆានុរូបំ តមភិវ្យវហរន្តិ ស្ម។ ");
INSERT INTO sankhm_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","អនន្តរំ ស ឝិឞ្យសមីបមេត្យ តេឞាំ ចតុះបាឝ៌្វេ តៃះ សហ ពហុជនាន៑ វិវទមានាន៑ អធ្យាបកាំឝ្ច ទ្ឫឞ្ដវាន៑; ");
INSERT INTO sankhm_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","កិន្តុ សវ៌្វលោកាស្តំ ទ្ឫឞ្ដ្វៃវ ចមត្ក្ឫត្យ តទាសន្នំ ធាវន្តស្តំ ប្រណេមុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","តទា យីឝុរធ្យាបកានប្រាក្ឞីទ៑ ឯតៃះ សហ យូយំ កិំ វិវទធ្វេ? ");
INSERT INTO sankhm_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","តតោ លោកានាំ កឝ្ចិទេកះ ប្រត្យវាទីត៑ ហេ គុរោ មម សូនុំ មូកំ ភូតធ្ឫតញ្ច ភវទាសន្នម៑ អានយំ។ ");
INSERT INTO sankhm_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","យទាសៅ ភូតស្តមាក្រមតេ តទៃវ បាតសតិ តថា ស ផេណាយតេ, ទន្តៃទ៌ន្តាន៑ ឃឞ៌តិ ក្ឞីណោ ភវតិ ច; តតោ ហេតោស្តំ ភូតំ ត្យាជយិតុំ ភវច្ឆិឞ្យាន៑ និវេទិតវាន៑ កិន្តុ តេ ន ឝេកុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","តទា ស តមវាទីត៑, រេ អវិឝ្វាសិនះ សន្តានា យុឞ្មាភិះ សហ កតិ កាលានហំ ស្ថាស្យាមិ? អបរាន៑ កតិ កាលាន៑ វា វ អាចារាន៑ សហិឞ្យេ? តំ មទាសន្នមានយត។ ");
INSERT INTO sankhm_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","តតស្តត្សន្និធិំ ស អានីយត កិន្តុ តំ ទ្ឫឞ្ដ្វៃវ ភូតោ ពាលកំ ធ្ឫតវាន៑; ស ច ភូមៅ បតិត្វា ផេណាយមានោ លុលោឋ។ ");
INSERT INTO sankhm_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","តទា ស តត្បិតរំ បប្រច្ឆ, អស្យេទ្ឫឝី ទឝា កតិ ទិនានិ ភូតា? តតះ សោវាទីត៑ ពាល្យកាលាត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","ភូតោយំ តំ នាឝយិតុំ ពហុវារាន៑ វហ្នៅ ជលេ ច ន្យក្ឞិបត៑ កិន្តុ យទិ ភវាន កិមបិ កត៌្តាំ ឝក្នោតិ តហ៌ិ ទយាំ ក្ឫត្វាស្មាន៑ ឧបករោតុ។ ");
INSERT INTO sankhm_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","តទា យីឝុស្តមវទត៑ យទិ ប្រត្យេតុំ ឝក្នោឞិ តហ៌ិ ប្រត្យយិនេ ជនាយ សវ៌្វំ សាធ្យម៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","តតស្តត្ក្ឞណំ តទ្ពាលកស្យ បិតា ប្រោច្ចៃ រូវន៑ សាឝ្រុនេត្រះ ប្រោវាច, ប្រភោ ប្រត្យេមិ មមាប្រត្យយំ ប្រតិកុរុ។ ");
INSERT INTO sankhm_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","អថ យីឝុ រ្លោកសង្ឃំ ធាវិត្វាយាន្តំ ទ្ឫឞ្ដ្វា តមបូតភូតំ តជ៌យិត្វា ជគាទ, រេ ពធិរ មូក ភូត ត្វមេតស្មាទ៑ ពហិព៌្ហវ បុនះ កទាបិ មាឝ្រយៃនំ ត្វាមហម៑ ឥត្យាទិឝាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","តទា ស ភូតឝ្ចីត្ឝព្ទំ ក្ឫត្វា តមាបីឌ្យ ពហិជ៌ជាម, តតោ ពាលកោ ម្ឫតកល្បោ ពភូវ តស្មាទយំ ម្ឫតឥត្យនេកេ កថយាមាសុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","កិន្តុ ករំ ធ្ឫត្វា យីឝុនោត្ថាបិតះ ស ឧត្តស្ថៅ។ ");
INSERT INTO sankhm_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","អថ យីឝៅ គ្ឫហំ ប្រវិឞ្ដេ ឝិឞ្យា គុប្តំ តំ បប្រច្ឆុះ, វយមេនំ ភូតំ ត្យាជយិតុំ កុតោ ន ឝក្តាះ? ");
INSERT INTO sankhm_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ស ឧវាច, ប្រាត៌្ហនោបវាសៅ វិនា កេនាប្យន្យេន កម៌្មណា ភូតមីទ្ឫឝំ ត្យាជយិតុំ ន ឝក្យំ។ ");
INSERT INTO sankhm_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","អនន្តរំ ស តត្ស្ថានាទិត្វា គាលីល្មធ្យេន យយៅ, កិន្តុ តត៑ កោបិ ជានីយាទិតិ ស នៃច្ឆត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","អបរញ្ច ស ឝិឞ្យានុបទិឝន៑ ពភាឞេ, នរបុត្រោ នរហស្តេឞុ សមប៌យិឞ្យតេ តេ ច តំ ហនិឞ្យន្តិ តៃស្តស្មិន៑ ហតេ ត្ឫតីយទិនេ ស ឧត្ថាស្យតីតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","កិន្តុ តត្កថាំ តេ នាពុធ្យន្ត ប្រឞ្ដុញ្ច ពិភ្យះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","អថ យីឝុះ កផន៌ាហូម្បុរមាគត្យ មធ្យេគ្ឫហញ្ចេត្យ តានប្ឫច្ឆទ៑ វត៌្មមធ្យេ យូយមន្យោន្យំ កិំ វិវទធ្វេ ស្ម? ");
INSERT INTO sankhm_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","កិន្តុ តេ និរុត្តរាស្តស្ថុ រ្យស្មាត្តេឞាំ កោ មុខ្យ ឥតិ វត៌្មានិ តេៜន្យោន្យំ វ្យវទន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","តតះ ស ឧបវិឝ្យ ទ្វាទឝឝិឞ្យាន៑ អាហូយ ពភាឞេ យះ កឝ្ចិត៑ មុខ្យោ ភវិតុមិច្ឆតិ ស សវ៌្វេភ្យោ គៅណះ សវ៌្វេឞាំ សេវកឝ្ច ភវតុ។ ");
INSERT INTO sankhm_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","តទា ស ពាលកមេកំ គ្ឫហីត្វា មធ្យេ សមុបាវេឝយត៑ តតស្តំ ក្រោឌេ ក្ឫត្វា តានវាទាត្ ");
INSERT INTO sankhm_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","យះ កឝ្ចិទីទ្ឫឝស្យ កស្យាបិ ពាលស្យាតិថ្យំ ករោតិ ស មមាតិថ្យំ ករោតិ; យះ កឝ្ចិន្មមាតិថ្យំ ករោតិ ស កេវលម៑ មមាតិថ្យំ ករោតិ តន្ន មត្ប្រេរកស្យាប្យាតិថ្យំ ករោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","អថ យោហន៑ តមព្រវីត៑ ហេ គុរោ, អស្មាកមននុគាមិនម៑ ឯកំ ត្វាន្នាម្នា ភូតាន៑ ត្យាជយន្តំ វយំ ទ្ឫឞ្ដវន្តះ, អស្មាកមបឝ្ចាទ្គាមិត្វាច្ច តំ ន្យឞេធាម។ ");
INSERT INTO sankhm_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","កិន្តុ យីឝុរវទត៑ តំ មា និឞេធត៑, យតោ យះ កឝ្ចិន៑ មន្នាម្នា ចិត្រំ កម៌្ម ករោតិ ស សហសា មាំ និន្ទិតុំ ន ឝក្នោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","តថា យះ កឝ្ចិទ៑ យុឞ្មាកំ វិបក្ឞតាំ ន ករោតិ ស យុឞ្មាកមេវ សបក្ឞះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","យះ កឝ្ចិទ៑ យុឞ្មាន៑ ខ្រីឞ្ដឝិឞ្យាន៑ ជ្ញាត្វា មន្នាម្នា កំសៃកេន បានីយំ បាតុំ ទទាតិ, យុឞ្មានហំ យថាត៌្ហំ វច្មិ, ស ផលេន វញ្ចិតោ ន ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","កិន្តុ យទិ កឝ្ចិន៑ មយិ វិឝ្វាសិនាមេឞាំ ក្ឞុទ្រប្រាណិនាម៑ ឯកស្យាបិ វិឃ្នំ ជនយតិ, តហ៌ិ តស្យៃតត្កម៌្ម ករណាត៑ កណ្ឋពទ្ធបេឞណីកស្យ តស្យ សាគរាគាធជល មជ្ជនំ ភទ្រំ។ ");
INSERT INTO sankhm_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","អតះ ស្វករោ យទិ ត្វាំ ពាធតេ តហ៌ិ តំ ឆិន្ធិ; ");
INSERT INTO sankhm_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","យស្មាត៑ យត្រ កីដា ន ម្រិយន្តេ វហ្និឝ្ច ន និវ៌្វាតិ, តស្មិន៑ អនិវ៌្វាណានលនរកេ ករទ្វយវស្តវ គមនាត៑ ករហីនស្យ ស្វគ៌ប្រវេឝស្តវ ក្ឞេមំ។ ");
INSERT INTO sankhm_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","យទិ តវ បាទោ វិឃ្នំ ជនយតិ តហ៌ិ តំ ឆិន្ធិ, ");
INSERT INTO sankhm_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","យតោ យត្រ កីដា ន ម្រិយន្តេ វហ្និឝ្ច ន និវ៌្វាតិ, តស្មិន៑ ៜនិវ៌្វាណវហ្នៅ នរកេ ទ្វិបាទវតស្តវ និក្ឞេបាត៑ បាទហីនស្យ ស្វគ៌ប្រវេឝស្តវ ក្ឞេមំ។ ");
INSERT INTO sankhm_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","ស្វនេត្រំ យទិ ត្វាំ ពាធតេ តហ៌ិ តទប្យុត្បាដយ, យតោ យត្រ កីដា ន ម្រិយន្តេ វហ្និឝ្ច ន និវ៌្វាតិ, ");
INSERT INTO sankhm_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","តស្មិន ៜនិវ៌្វាណវហ្នៅ នរកេ ទ្វិនេត្រស្យ តវ និក្ឞេបាទ៑ ឯកនេត្រវត ឦឝ្វររាជ្យេ ប្រវេឝស្តវ ក្ឞេមំ។ ");
INSERT INTO sankhm_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","យថា សវ៌្វោ ពលិ រ្លវណាក្តះ ក្រិយតេ តថា សវ៌្វោ ជនោ វហ្និរូបេណ លវណាក្តះ ការិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","លវណំ ភទ្រំ កិន្តុ យទិ លវណេ ស្វាទុតា ន តិឞ្ឋតិ, តហ៌ិ កថម៑ អាស្វាទ្យុក្តំ ករិឞ្យថ? យូយំ លវណយុក្តា ភវត បរស្បរំ ប្រេម កុរុត។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","អនន្តរំ ស តត្ស្ថានាត៑ ប្រស្ថាយ យទ៌្ទននទ្យាះ បារេ យិហូទាប្រទេឝ ឧបស្ថិតវាន៑, តត្រ តទន្តិកេ លោកានាំ សមាគមេ ជាតេ ស និជរីត្យនុសារេណ បុនស្តាន៑ ឧបទិទេឝ។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","តទា ផិរូឝិនស្តត្សមីបម៑ ឯត្យ តំ បរីក្ឞិតុំ បប្រច្ឆះ ស្វជាយា មនុជានាំ ត្យជ្យា ន វេតិ? ");
INSERT INTO sankhm_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","តតះ ស ប្រត្យវាទីត៑, អត្រ កាយ៌្យេ មូសា យុឞ្មាន៑ ប្រតិ កិមាជ្ញាបយត៑? ");
INSERT INTO sankhm_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ត ឩចុះ ត្យាគបត្រំ លេខិតុំ ស្វបត្នីំ ត្យក្តុញ្ច មូសាៜនុមន្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","តទា យីឝុះ ប្រត្យុវាច, យុឞ្មាកំ មនសាំ កាឋិន្យាទ្ធេតោ រ្មូសា និទេឝមិមម៑ អលិខត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","កិន្តុ ស្ឫឞ្ដេរាទៅ ឦឝ្វរោ នរាន៑ បុំរូបេណ ស្ត្រីរូបេណ ច សសជ៌។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","\"តតះ ការណាត៑ បុមាន៑ បិតរំ មាតរញ្ច ត្យក្ត្វា ស្វជាយាយាម៑ អាសក្តោ ភវិឞ្យតិ, ");
INSERT INTO sankhm_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","តៅ ទ្វាវ៑ ឯកាង្គៅ ភវិឞ្យតះ។ \" តស្មាត៑ តត្កាលមារភ្យ តៅ ន ទ្វាវ៑ ឯកាង្គៅ។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","អតះ ការណាទ៑ ឦឝ្វរោ យទយោជយត៑ កោបិ នរស្តន្ន វិយេជយេត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","អថ យីឝុ រ្គ្ឫហំ ប្រវិឞ្ដស្តទា ឝិឞ្យាះ បុនស្តត្កថាំ តំ បប្រច្ឆុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","តតះ សោវទត៑ កឝ្ចិទ៑ យទិ ស្វភាយ៌្យាំ ត្យក្តវាន្យាម៑ ឧទ្វហតិ តហ៌ិ ស ស្វភាយ៌្យាយាះ ប្រាតិកូល្យេន វ្យភិចារី ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","កាចិន្នារី យទិ ស្វបតិំ ហិត្វាន្យបុំសា វិវាហិតា ភវតិ តហ៌ិ សាបិ វ្យភិចារិណី ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","អថ ស យថា ឝិឝូន៑ ស្ប្ឫឝេត៑, តទត៌្ហំ លោកៃស្តទន្តិកំ ឝិឝវ អានីយន្ត, កិន្តុ ឝិឞ្យាស្តានានីតវតស្តជ៌យាមាសុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","យីឝុស្តទ៑ ទ្ឫឞ្ដ្វា ក្រុធ្យន៑ ជគាទ, មន្និកដម៑ អាគន្តុំ ឝិឝូន៑ មា វារយត, យត ឯតាទ្ឫឝា ឦឝ្វររាជ្យាធិការិណះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","យុឞ្មានហំ យថាត៌្ហំ វច្មិ, យះ កឝ្ចិត៑ ឝិឝុវទ៑ ភូត្វា រាជ្យមីឝ្វរស្យ ន គ្ឫហ្លីយាត៑ ស កទាបិ តទ្រាជ្យំ ប្រវេឞ្ដុំ ន ឝក្នោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","អននតរំ ស ឝិឝូនង្កេ និធាយ តេឞាំ គាត្រេឞុ ហស្តៅ ទត្ត្វាឝិឞំ ពភាឞេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","អថ ស វត៌្មនា យាតិ, ឯតហ៌ិ ជន ឯកោ ធាវន៑ អាគត្យ តត្សម្មុខេ ជានុនី បាតយិត្វា ប្ឫឞ្ដវាន៑, ភោះ បរមគុរោ, អនន្តាយុះ ប្រាប្តយេ មយា កិំ កត៌្តវ្យំ? ");
INSERT INTO sankhm_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","តទា យីឝុរុវាច, មាំ បរមំ កុតោ វទសិ? វិនេឝ្វរំ កោបិ បរមោ ន ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","បរស្ត្រីំ នាភិគច្ឆ; នរំ មា ឃាតយ; ស្តេយំ មា កុរុ; ម្ឫឞាសាក្ឞ្យំ មា ទេហិ; ហិំសាញ្ច មា កុរុ; បិតរៅ សម្មន្យស្វ; និទេឝា ឯតេ ត្វយា ជ្ញាតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","តតស្តន ប្រត្យុក្តំ, ហេ គុរោ ពាល្យកាលាទហំ សវ៌្វានេតាន៑ អាចរាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","តទា យីឝុស្តំ វិលោក្យ ស្នេហេន ពភាឞេ, តវៃកស្យាភាវ អាស្តេ; ត្វំ គត្វា សវ៌្វស្វំ វិក្រីយ ទរិទ្រេភ្យោ វិឝ្រាណយ, តតះ ស្វគ៌េ ធនំ ប្រាប្ស្យសិ; តតះ បរម៑ ឯត្យ ក្រុឝំ វហន៑ មទនុវត៌្តី ភវ។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","កិន្តុ តស្យ ពហុសម្បទ្វិទ្យមានត្វាត៑ ស ឥមាំ កថាមាកណ៌្យ វិឞណោ ទុះខិតឝ្ច សន៑ ជគាម។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","អថ យីឝុឝ្ចតុទ៌ិឝោ និរីក្ឞ្យ ឝិឞ្យាន៑ អវាទីត៑, ធនិលោកានាម៑ ឦឝ្វររាជ្យប្រវេឝះ កីទ្ឫគ៑ ទុឞ្ករះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","តស្យ កថាតះ ឝិឞ្យាឝ្ចមច្ចក្រុះ, កិន្តុ ស បុនរវទត៑, ហេ ពាលកា យេ ធនេ វិឝ្វសន្តិ តេឞាម៑ ឦឝ្វររាជ្យប្រវេឝះ កីទ្ឫគ៑ ទុឞ្ករះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ឦឝ្វររាជ្យេ ធនិនាំ ប្រវេឝាត៑ សូចិរន្ធ្រេណ មហាង្គស្យ គមនាគមនំ សុករំ។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","តទា ឝិឞ្យា អតីវ វិស្មិតាះ បរស្បរំ ប្រោចុះ, តហ៌ិ កះ បរិត្រាណំ ប្រាប្តុំ ឝក្នោតិ? ");
INSERT INTO sankhm_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","តតោ យីឝុស្តាន៑ វិលោក្យ ពភាឞេ, តន៑ នរស្យាសាធ្យំ កិន្តុ នេឝ្វរស្យ, យតោ ហេតោរីឝ្វរស្យ សវ៌្វំ សាធ្យម៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","តទា បិតរ ឧវាច, បឝ្យ វយំ សវ៌្វំ បរិត្យជ្យ ភវតោនុគាមិនោ ជាតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","តតោ យីឝុះ ប្រត្យវទត៑, យុឞ្មានហំ យថាត៌្ហំ វទាមិ, មទត៌្ហំ សុសំវាទាត៌្ហំ វា យោ ជនះ សទនំ ភ្រាតរំ ភគិនីំ បិតរំ មាតរំ ជាយាំ សន្តានាន៑ ភូមិ វា ត្យក្ត្វា ");
INSERT INTO sankhm_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","គ្ឫហភ្រាត្ឫភគិនីបិត្ឫមាត្ឫបត្នីសន្តានភូមីនាមិហ ឝតគុណាន៑ ប្រេត្យានន្តាយុឝ្ច ន ប្រាប្នោតិ តាទ្ឫឝះ កោបិ នាស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","កិន្ត្វគ្រីយា អនេកេ លោកាះ ឝេឞាះ, ឝេឞីយា អនេកេ លោកាឝ្ចាគ្រា ភវិឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","អថ យិរូឝាលម្យានកាលេ យីឝុស្តេឞាម៑ អគ្រគាមី ពភូវ, តស្មាត្តេ ចិត្រំ ជ្ញាត្វា បឝ្ចាទ្គាមិនោ ភូត្វា ពិភ្យុះ។ តទា ស បុន រ្ទ្វាទឝឝិឞ្យាន៑ គ្ឫហីត្វា ស្វីយំ យទ្យទ៑ ឃដិឞ្យតេ តត្តត៑ តេភ្យះ កថយិតុំ ប្រារេភេ; ");
INSERT INTO sankhm_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","បឝ្យត វយំ យិរូឝាលម្បុរំ យាមះ, តត្រ មនុឞ្យបុត្រះ ប្រធានយាជកានាម៑ ឧបាធ្យាយានាញ្ច ករេឞុ សមប៌យិឞ្យតេ; តេ ច វធទណ្ឌាជ្ញាំ ទាបយិត្វា បរទេឝីយានាំ ករេឞុ តំ សមប៌យិឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","តេ តមុបហស្យ កឝយា ប្រហ្ឫត្យ តទ្វបុឞិ និឞ្ឋីវំ និក្ឞិប្យ តំ ហនិឞ្យន្តិ, តតះ ស ត្ឫតីយទិនេ ប្រោត្ថាស្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","តតះ សិវទេះ បុត្រៅ យាកូព្យោហនៅ តទន្តិកម៑ ឯត្យ ប្រោចតុះ, ហេ គុរោ យទ៑ អាវាភ្យាំ យាចិឞ្យតេ តទស្មទត៌្ហំ ភវាន៑ ករោតុ និវេទនមិទមាវយោះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","តតះ ស កថិតវាន៑, យុវាំ កិមិច្ឆថះ? កិំ មយា យុឞ្មទត៌្ហំ ករណីយំ? ");
INSERT INTO sankhm_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","តទា តៅ ប្រោចតុះ, អាវយោរេកំ ទក្ឞិណបាឝ៌្វេ វាមបាឝ៌្វេ ចៃកំ តវៃឝ្វយ៌្យបទេ សមុបវេឞ្ដុម៑ អាជ្ញាបយ។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","កិន្តុ យីឝុះ ប្រត្យុវាច យុវាមជ្ញាត្វេទំ ប្រាត៌្ហយេថេ, យេន កំសេនាហំ បាស្យាមិ តេន យុវាភ្យាំ កិំ បាតុំ ឝក្ឞ្យតេ? យស្មិន៑ មជ្ជនេនាហំ មជ្ជិឞ្យេ តន្មជ្ជនេ មជ្ជយិតុំ កិំ យុវាភ្យាំ ឝក្ឞ្យតេ? តៅ ប្រត្យូចតុះ ឝក្ឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","តទា យីឝុរវទត៑ យេន កំសេនាហំ បាស្យាមិ តេនាវឝ្យំ យុវាមបិ បាស្យថះ, យេន មជ្ជនេន ចាហំ មជ្ជិយ្យេ តត្រ យុវាមបិ មជ្ជិឞ្យេថេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","កិន្តុ យេឞាមត៌្ហម៑ ឥទំ និរូបិតំ, តាន៑ វិហាយាន្យំ កមបិ មម ទក្ឞិណបាឝ៌្វេ វាមបាឝ៌្វេ វា សមុបវេឝយិតុំ មមាធិការោ នាស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","អថាន្យទឝឝិឞ្យា ឥមាំ កថាំ ឝ្រុត្វា យាកូព្យោហន្ភ្យាំ ចុកុបុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","កិន្តុ យីឝុស្តាន៑ សមាហូយ ពភាឞេ, អន្យទេឝីយានាំ រាជត្វំ យេ កុវ៌្វន្តិ តេ តេឞាមេវ ប្រភុត្វំ កុវ៌្វន្តិ, តថា យេ មហាលោកាស្តេ តេឞាម៑ អធិបតិត្វំ កុវ៌្វន្តីតិ យូយំ ជានីថ។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","កិន្តុ យុឞ្មាកំ មធ្យេ ន តថា ភវិឞ្យតិ, យុឞ្មាកំ មធ្យេ យះ ប្រាធាន្យំ វាញ្ឆតិ ស យុឞ្មាកំ សេវកោ ភវិឞ្យតិ, ");
INSERT INTO sankhm_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","យុឞ្មាកំ យោ មហាន៑ ភវិតុមិច្ឆតិ ស សវ៌្វេឞាំ កិង្ករោ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","យតោ មនុឞ្យបុត្រះ សេវ្យោ ភវិតុំ នាគតះ សេវាំ កត៌្តាំ តថានេកេឞាំ បរិត្រាណស្យ មូល្យរូបស្វប្រាណំ ទាតុញ្ចាគតះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","អថ តេ យិរីហោនគរំ ប្រាប្តាស្តស្មាត៑ ឝិឞ្យៃ រ្លោកៃឝ្ច សហ យីឝោ រ្គមនកាលេ ដីមយស្យ បុត្រោ ពដ៌ីមយនាមា អន្ធស្តន្មាគ៌បាឝ៌្វេ ភិក្ឞាត៌្ហម៑ ឧបវិឞ្ដះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ស នាសរតីយស្យ យីឝោរាគមនវាត៌្តាំ ប្រាប្យ ប្រោចៃ រ្វក្តុមារេភេ, ហេ យីឝោ ទាយូទះ សន្តាន មាំ ទយស្វ។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","តតោនេកេ លោកា មៅនីភវេតិ តំ តជ៌យាមាសុះ, កិន្តុ ស បុនរធិកមុច្ចៃ រ្ជគាទ, ហេ យីឝោ ទាយូទះ សន្តាន មាំ ទយស្វ។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","តទា យីឝុះ ស្ថិត្វា តមាហ្វាតុំ សមាទិទេឝ, តតោ លោកាស្តមន្ធមាហូយ ពភាឞិរេ, ហេ នរ, ស្ថិរោ ភវ, ឧត្តិឞ្ឋ, ស ត្វាមាហ្វយតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","តទា ស ឧត្តរីយវស្ត្រំ និក្ឞិប្យ ប្រោត្ថាយ យីឝោះ សមីបំ គតះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","តតោ យីឝុស្តមវទត៑ ត្វយា កិំ ប្រាត៌្ហ្យតេ? តុភ្យមហំ កិំ ករិឞ្យាមី? តទា សោន្ធស្តមុវាច, ហេ គុរោ មទីយា ទ្ឫឞ្ដិព៌្ហវេត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","តតោ យីឝុស្តមុវាច យាហិ តវ វិឝ្វាសស្ត្វាំ ស្វស្ថមកាឞ៌ីត៑, តស្មាត៑ តត្ក្ឞណំ ស ទ្ឫឞ្ដិំ ប្រាប្យ បថា យីឝោះ បឝ្ចាទ៑ យយៅ។ ");
INSERT INTO sankhm_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","អនន្តរំ តេឞុ យិរូឝាលមះ សមីបស្ថយោ រ្ពៃត្ផគីពៃថនីយបុរយោរន្តិកស្ថំ ជៃតុននាមាទ្រិមាគតេឞុ យីឝុះ ប្រេឞណកាលេ ទ្វៅ ឝិឞ្យាវិទំ វាក្យំ ជគាទ, ");
INSERT INTO sankhm_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","យុវាមមុំ សម្មុខស្ថំ គ្រាមំ យាតំ, តត្រ ប្រវិឝ្យ យោ នរំ នាវហត៑ តំ គទ៌្ទភឝាវកំ ទ្រក្ឞ្យថស្តំ មោចយិត្វានយតំ។ ");
INSERT INTO sankhm_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","កិន្តុ យុវាំ កម៌្មេទំ កុតះ កុរុថះ? កថាមិមាំ យទិ កោបិ ប្ឫច្ឆតិ តហ៌ិ ប្រភោរត្រ ប្រយោជនមស្តីតិ កថិតេ ស ឝីឃ្រំ តមត្រ ប្រេឞយិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","តតស្តៅ គត្វា ទ្វិមាគ៌មេលនេ កស្យចិទ៑ ទ្វារស្យ បាឝ៌្វេ តំ គទ៌្ទភឝាវកំ ប្រាប្យ មោចយតះ, ");
INSERT INTO sankhm_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ឯតហ៌ិ តត្រោបស្ថិតលោកានាំ កឝ្ចិទ៑ អប្ឫច្ឆត៑, គទ៌្ទភឝិឝុំ កុតោ មោចយថះ? ");
INSERT INTO sankhm_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","តទា យីឝោរាជ្ញានុសារេណ តេភ្យះ ប្រត្យុទិតេ តត្ក្ឞណំ តមាទាតុំ តេៜនុជជ្ញុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","អថ តៅ យីឝោះ សន្និធិំ គទ៌្ទភឝិឝុម៑ អានីយ តទុបរិ ស្វវស្ត្រាណិ បាតយាមាសតុះ; តតះ ស តទុបរិ សមុបវិឞ្ដះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","តទានេកេ បថិ ស្វវាសាំសិ បាតយាមាសុះ, បរៃឝ្ច តរុឝាខាឝ្ឆិតវា មាគ៌េ វិកីណ៌ាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","អបរញ្ច បឝ្ចាទ្គាមិនោៜគ្រគាមិនឝ្ច សវ៌្វេ ជនា ឧចៃះស្វរេណ វក្តុមារេភិរេ, ជយ ជយ យះ បរមេឝ្វរស្យ នាម្នាគច្ឆតិ ស ធន្យ ឥតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","តថាស្មាកមំ បូវ៌្វបុរុឞស្យ ទាយូទោ យទ្រាជ្យំ បរមេឝ្វរនាម្នាយាតិ តទបិ ធន្យំ, សវ៌្វស្មាទុច្ឆ្រាយេ ស្វគ៌េ ឦឝ្វរស្យ ជយោ ភវេត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ឥត្ថំ យីឝុ រ្យិរូឝាលមិ មន្ទិរំ ប្រវិឝ្យ ចតុទ៌ិក្ស្ថានិ សវ៌្វាណិ វស្តូនិ ទ្ឫឞ្ដវាន៑; អថ សាយំកាល ឧបស្ថិតេ ទ្វាទឝឝិឞ្យសហិតោ ពៃថនិយំ ជគាម។ ");
INSERT INTO sankhm_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","អបរេហនិ ពៃថនិយាទ៑ អាគមនសមយេ ក្ឞុធាត៌្តោ ពភូវ។ ");
INSERT INTO sankhm_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","តតោ ទូរេ សបត្រមុឌុម្ពរបាទបំ វិលោក្យ តត្រ កិញ្ចិត៑ ផលំ ប្រាប្តុំ តស្យ សន្និក្ឫឞ្ដំ យយៅ, តទានីំ ផលបាតនស្យ សមយោ នាគច្ឆតិ។ តតស្តត្រោបស្ថិតះ បត្រាណិ វិនា កិមប្យបរំ ន ប្រាប្យ ស កថិតវាន៑, ");
INSERT INTO sankhm_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","អទ្យារភ្យ កោបិ មានវស្ត្វត្តះ ផលំ ន ភុញ្ជីត; ឥមាំ កថាំ តស្យ ឝិឞ្យាះ ឝុឝ្រុវុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","តទនន្តរំ តេឞុ យិរូឝាលមមាយាតេឞុ យីឝុ រ្មន្ទិរំ គត្វា តត្រស្ថានាំ ពណិជាំ មុទ្រាសនានិ បារាវតវិក្រេត្ឫណាម៑ អាសនានិ ច ន្យុព្ជយាញ្ចការ សវ៌្វាន៑ ក្រេត្ឫន៑ វិក្រេត្ឫំឝ្ច ពហិឝ្ចការ។ ");
INSERT INTO sankhm_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","អបរំ មន្ទិរមធ្យេន កិមបិ បាត្រំ វោឍុំ សវ៌្វជនំ និវារយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","លោកានុបទិឝន៑ ជគាទ, មម គ្ឫហំ សវ៌្វជាតីយានាំ ប្រាត៌្ហនាគ្ឫហម៑ ឥតិ នាម្នា ប្រថិតំ ភវិឞ្យតិ ឯតត៑ កិំ ឝាស្ត្រេ លិខិតំ នាស្តិ? កិន្តុ យូយំ តទេវ ចោរាណាំ គហ្វរំ កុរុថ។ ");
INSERT INTO sankhm_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ឥមាំ វាណីំ ឝ្រុត្វាធ្យាបកាះ ប្រធានយាជកាឝ្ច តំ យថា នាឝយិតុំ ឝក្នុវន្តិ តថោेបាយំ ម្ឫគយាមាសុះ, កិន្តុ តស្យោបទេឝាត៑ សវ៌្វេ លោកា វិស្មយំ គតា អតស្តេ តស្មាទ៑ ពិភ្យុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","អថ សាយំសមយ ឧបស្ថិតេ យីឝុន៌គរាទ៑ ពហិវ៌វ្រាជ។ ");
INSERT INTO sankhm_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","អនន្តរំ ប្រាតះកាលេ តេ តេន មាគ៌េណ គច្ឆន្តស្តមុឌុម្ពរមហីរុហំ សមូលំ ឝុឞ្កំ ទទ្ឫឝុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","តតះ បិតរះ បូវ៌្វវាក្យំ ស្មរន៑ យីឝុំ ពភាឞំ, ហេ គុរោ បឝ្យតុ យ ឧឌុម្ពរវិដបី ភវតា ឝប្តះ ស ឝុឞ្កោ ពភូវ។ ");
INSERT INTO sankhm_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","តតោ យីឝុះ ប្រត្យវាទីត៑, យូយមីឝ្វរេ វិឝ្វសិត។ ");
INSERT INTO sankhm_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","យុឞ្មានហំ យថាត៌្ហំ វទាមិ កោបិ យទ្យេតទ្គិរិំ វទតិ, ត្វមុត្ថាយ គត្វា ជលធៅ បត, ប្រោក្តមិទំ វាក្យមវឝ្យំ ឃដិឞ្យតេ, មនសា កិមបិ ន សន្ទិហ្យ ចេទិទំ វិឝ្វសេត៑ តហ៌ិ តស្យ វាក្យានុសារេណ តទ៑ ឃដិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","អតោ ហេតោរហំ យុឞ្មាន៑ វច្មិ, ប្រាត៌្ហនាកាលេ យទ្យទាកាំក្ឞិឞ្យធ្វេ តត្តទវឝ្យំ ប្រាប្ស្យថ, ឥត្ថំ វិឝ្វសិត, តតះ ប្រាប្ស្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","អបរញ្ច យុឞ្មាសុ ប្រាត៌្ហយិតុំ សមុត្ថិតេឞុ យទិ កោបិ យុឞ្មាកម៑ អបរាធី តិឞ្ឋតិ, តហ៌ិ តំ ក្ឞមធ្វំ, តថា ក្ឫតេ យុឞ្មាកំ ស្វគ៌ស្ថះ បិតាបិ យុឞ្មាកមាគាំមិ ក្ឞមិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","កិន្តុ យទិ ន ក្ឞមធ្វេ តហ៌ិ វះ ស្វគ៌ស្ថះ បិតាបិ យុឞ្មាកមាគាំសិ ន ក្ឞមិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","អនន្តរំ តេ បុន រ្យិរូឝាលមំ ប្រវិវិឝុះ, យីឝុ រ្យទា មធ្យេមន្ទិរម៑ ឥតស្តតោ គច្ឆតិ, តទានីំ ប្រធានយាជកា ឧបាធ្យាយាះ ប្រាញ្ចឝ្ច តទន្តិកមេត្យ កថាមិមាំ បប្រច្ឆុះ, ");
INSERT INTO sankhm_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ត្វំ កេនាទេឝេន កម៌្មាណ្យេតានិ ករោឞិ? តថៃតានិ កម៌្មាណិ កត៌្តាំ កេនាទិឞ្ដោសិ? ");
INSERT INTO sankhm_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","តតោ យីឝុះ ប្រតិគទិតវាន៑ អហមបិ យុឞ្មាន៑ ឯកកថាំ ប្ឫច្ឆាមិ, យទិ យូយំ តស្យា ឧត្តរំ កុរុថ, តហ៌ិ កយាជ្ញយាហំ កម៌្មាណ្យេតានិ ករោមិ តទ៑ យុឞ្មភ្យំ កថយិឞ្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","យោហនោ មជ្ជនម៑ ឦឝ្វរាត៑ ជាតំ កិំ មានវាត៑? តន្មហ្យំ កថយត។ ");
INSERT INTO sankhm_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","តេ បរស្បរំ វិវេក្តុំ ប្រារេភិរេ, តទ៑ ឦឝ្វរាទ៑ ពភូវេតិ ចេទ៑ វទាមស្តហ៌ិ កុតស្តំ ន ប្រត្យៃត? កថមេតាំ កថយិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","មានវាទ៑ អភវទិតិ ចេទ៑ វទាមស្តហ៌ិ លោកេភ្យោ ភយមស្តិ យតោ ហេតោះ សវ៌្វេ យោហនំ សត្យំ ភវិឞ្យទ្វាទិនំ មន្យន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","អតឯវ តេ យីឝុំ ប្រត្យវាទិឞុ រ្វយំ តទ៑ វក្តុំ ន ឝក្នុមះ។ យីឝុរុវាច, តហ៌ិ យេនាទេឝេន កម៌្មាណ្យេតានិ ករោមិ, អហមបិ យុឞ្មភ្យំ តន្ន កថយិឞ្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","អនន្តរំ យីឝុ រ្ទ្ឫឞ្ដាន្តេន តេភ្យះ កថយិតុមារេភេ, កឝ្ចិទេកោ ទ្រាក្ឞាក្ឞេត្រំ វិធាយ តច្ចតុទ៌ិក្ឞុ វារណីំ ក្ឫត្វា តន្មធ្យេ ទ្រាក្ឞាបេឞណកុណ្ឌម៑ អខនត៑, តថា តស្យ គឌមបិ និម៌្មិតវាន៑ តតស្តត្ក្ឞេត្រំ ក្ឫឞីវលេឞុ សមប៌្យ ទូរទេឝំ ជគាម។ ");
INSERT INTO sankhm_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","តទនន្តរំ ផលកាលេ ក្ឫឞីវលេភ្យោ ទ្រាក្ឞាក្ឞេត្រផលានិ ប្រាប្តុំ តេឞាំ សវិធេ ភ្ឫត្យម៑ ឯកំ ប្រាហិណោត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","កិន្តុ ក្ឫឞីវលាស្តំ ធ្ឫត្វា ប្រហ្ឫត្យ រិក្តហស្តំ វិសស្ឫជុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","តតះ ស បុនរន្យមេកំ ភ្ឫត្យំ ប្រឞយាមាស, កិន្តុ តេ ក្ឫឞីវលាះ បាឞាណាឃាតៃស្តស្យ ឝិរោ ភង្ក្ត្វា សាបមានំ តំ វ្យសជ៌ន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","តតះ បរំ សោបរំ ទាសំ ប្រាហិណោត៑ តទា តេ តំ ជឃ្នុះ, ឯវម៑ អនេកេឞាំ កស្យចិត៑ ប្រហារះ កស្យចិទ៑ វធឝ្ច តៃះ ក្ឫតះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","តតះ បរំ មយា ស្វបុត្រេ ប្រហិតេ តេ តមវឝ្យំ សម្មំស្យន្តេ, ឥត្យុក្ត្វាវឝេឞេ តេឞាំ សន្និធៅ និជប្រិយម៑ អទ្វិតីយំ បុត្រំ ប្រេឞយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","កិន្តុ ក្ឫឞីវលាះ បរស្បរំ ជគទុះ, ឯឞ ឧត្តរាធិការី, អាគច្ឆត វយមេនំ ហន្មស្តថា ក្ឫតេ ៜធិការោយម៑ អស្មាកំ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","តតស្តំ ធ្ឫត្វា ហត្វា ទ្រាក្ឞាក្ឞេត្រាទ៑ ពហិះ ប្រាក្ឞិបន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","អនេនាសៅ ទ្រាក្ឞាក្ឞេត្របតិះ កិំ ករិឞ្យតិ? ស ឯត្យ តាន៑ ក្ឫឞីវលាន៑ សំហត្យ តត្ក្ឞេត្រម៑ អន្យេឞុ ក្ឫឞីវលេឞុ សមប៌យិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","អបរញ្ច, \"ស្ថបតយះ ករិឞ្យន្តិ គ្រាវាណំ យន្តុ តុច្ឆកំ។ ប្រាធានប្រស្តរះ កោណេ ស ឯវ សំភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ឯតត៑ កម៌្ម បរេឝស្យាំទ្ភុតំ នោ ទ្ឫឞ្ដិតោ ភវេត៑៕ \" ឥមាំ ឝាស្ត្រីយាំ លិបិំ យូយំ កិំ នាបាឋិឞ្ដ? ");
INSERT INTO sankhm_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","តទានីំ ស តានុទ្ទិឝ្យ តាំ ទ្ឫឞ្ដាន្តកថាំ កថិតវាន៑, ត ឥត្ថំ ពុទ្វ្វា តំ ធត៌្តាមុទ្យតាះ, កិន្តុ លោកេភ្យោ ពិភ្យុះ, តទនន្តរំ តេ តំ វិហាយ វវ្រជុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","អបរញ្ច តេ តស្យ វាក្យទោឞំ ធត៌្តាំ កតិបយាន៑ ផិរូឝិនោ ហេរោទីយាំឝ្ច លោកាន៑ តទន្តិកំ ប្រេឞយាមាសុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ត អាគត្យ តមវទន៑, ហេ គុរោ ភវាន៑ តថ្យភាឞី កស្យាប្យនុរោធំ ន មន្យតេ, បក្ឞបាតញ្ច ន ករោតិ, យថាត៌្ហត ឦឝ្វរីយំ មាគ៌ំ ទឝ៌យតិ វយមេតត៑ ប្រជានីមះ, កៃសរាយ ករោ ទេយោ ន វាំ? វយំ ទាស្យាមោ ន វា? ");
INSERT INTO sankhm_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","កិន្តុ ស តេឞាំ កបដំ ជ្ញាត្វា ជគាទ, កុតោ មាំ បរីក្ឞធ្វេ? ឯកំ មុទ្រាបាទំ សមានីយ មាំ ទឝ៌យត។ ");
INSERT INTO sankhm_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","តទា តៃរេកស្មិន៑ មុទ្រាបាទេ សមានីតេ ស តាន៑ បប្រច្ឆ, អត្រ លិខិតំ នាម មូត៌្តិ រ្វា កស្យ? តេ ប្រត្យូចុះ, កៃសរស្យ។ ");
INSERT INTO sankhm_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","តទា យីឝុរវទត៑ តហ៌ិ កៃសរស្យ ទ្រវ្យាណិ កៃសរាយ ទត្ត, ឦឝ្វរស្យ ទ្រវ្យាណិ តុ ឦឝ្វរាយ ទត្ត; តតស្តេ វិស្មយំ មេនិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","អថ ម្ឫតានាមុត្ថានំ យេ ន មន្យន្តេ តេ សិទូកិនោ យីឝោះ សមីបមាគត្យ តំ បប្រច្ឆុះ; ");
INSERT INTO sankhm_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","ហេ គុរោ កឝ្ចិជ្ជនោ យទិ និះសន្តតិះ សន៑ ភាយ៌្យាយាំ សត្យាំ ម្រិយតេ តហ៌ិ តស្យ ភ្រាតា តស្យ ភាយ៌្យាំ គ្ឫហីត្វា ភ្រាតុ រ្វំឝោត្បត្តិំ ករិឞ្យតិ, វ្យវស្ថាមិមាំ មូសា អស្មាន៑ ប្រតិ វ្យលិខត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","កិន្តុ កេចិត៑ សប្ត ភ្រាតរ អាសន៑, តតស្តេឞាំ ជ្យេឞ្ឋភ្រាតា វិវហ្យ និះសន្តតិះ សន៑ អម្រិយត។ ");
INSERT INTO sankhm_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","តតោ ទ្វិតីយោ ភ្រាតា តាំ ស្ត្រិយមគ្ឫហណត៑ កិន្តុ សោបិ និះសន្តតិះ សន៑ អម្រិយត; អថ ត្ឫតីយោបិ ភ្រាតា តាទ្ឫឝោភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ឥត្ថំ សប្តៃវ ភ្រាតរស្តាំ ស្ត្រិយំ គ្ឫហីត្វា និះសន្តានាះ សន្តោៜម្រិយន្ត, សវ៌្វឝេឞេ សាបិ ស្ត្រី ម្រិយតេ ស្ម។ ");
INSERT INTO sankhm_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","អថ ម្ឫតានាមុត្ថានកាលេ យទា ត ឧត្ថាស្យន្តិ តទា តេឞាំ កស្យ ភាយ៌្យា សា ភវិឞ្យតិ? យតស្តេ សប្តៃវ តាំ វ្យវហន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","តតោ យីឝុះ ប្រត្យុវាច ឝាស្ត្រម៑ ឦឝ្វរឝក្តិញ្ច យូយមជ្ញាត្វា កិមភ្រាម្យត ន? ");
INSERT INTO sankhm_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","ម្ឫតលោកានាមុត្ថានំ សតិ តេ ន វិវហន្តិ វាគ្ទត្តា អបិ ន ភវន្តិ, កិន្តុ ស្វគ៌ីយទូតានាំ សទ្ឫឝា ភវន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","បុនឝ្ច \"អហម៑ ឥព្រាហីម ឦឝ្វរ ឥស្ហាក ឦឝ្វរោ យាកូពឝ្ចេឝ្វរះ\" យាមិមាំ កថាំ ស្តម្ពមធ្យេ តិឞ្ឋន៑ ឦឝ្វរោ មូសាមវាទីត៑ ម្ឫតានាមុត្ថានាត៌្ហេ សា កថា មូសាលិខិតេ បុស្តកេ កិំ យុឞ្មាភិ រ្នាបាឋិ? ");
INSERT INTO sankhm_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ឦឝ្វរោ ជីវតាំ ប្រភុះ កិន្តុ ម្ឫតានាំ ប្រភុ រ្ន ភវតិ, តស្មាទ្ធេតោ រ្យូយំ មហាភ្រមេណ តិឞ្ឋថ។ ");
INSERT INTO sankhm_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ឯតហ៌ិ ឯកោធ្យាបក ឯត្យ តេឞាមិត្ថំ វិចារំ ឝុឝ្រាវ; យីឝុស្តេឞាំ វាក្យស្យ សទុត្តរំ ទត្តវាន៑ ឥតិ ពុទ្វ្វា តំ ប្ឫឞ្ដវាន៑ សវ៌្វាសាម៑ អាជ្ញានាំ កា ឝ្រេឞ្ឋា? តតោ យីឝុះ ប្រត្យុវាច, ");
INSERT INTO sankhm_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","\"ហេ ឥស្រាយេល្លោកា អវធត្ត, អស្មាកំ ប្រភុះ បរមេឝ្វរ ឯក ឯវ, ");
INSERT INTO sankhm_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","យូយំ សវ៌្វន្តះករណៃះ សវ៌្វប្រាណៃះ សវ៌្វចិត្តៃះ សវ៌្វឝក្តិភិឝ្ច តស្មិន៑ ប្រភៅ បរមេឝ្វរេ ប្រីយធ្វំ,\" ឥត្យាជ្ញា ឝ្រេឞ្ឋា។ ");
INSERT INTO sankhm_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","តថា \"ស្វប្រតិវាសិនិ ស្វវត៑ ប្រេម កុរុធ្វំ,\" ឯឞា យា ទ្វិតីយាជ្ញា សា តាទ្ឫឝី; ឯតាភ្យាំ ទ្វាភ្យាម៑ អាជ្ញាភ្យាម៑ អន្យា កាប្យាជ្ញា ឝ្រេឞ្ឋា នាស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","តទា សោធ្យាបកស្តមវទត៑, ហេ គុរោ សត្យំ ភវាន៑ យថាត៌្ហំ ប្រោក្តវាន៑ យត ឯកស្មាទ៑ ឦឝ្វរាទ៑ អន្យោ ទ្វិតីយ ឦឝ្វរោ នាស្តិ; ");
INSERT INTO sankhm_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","អបរំ សវ៌្វាន្តះករណៃះ សវ៌្វប្រាណៃះ សវ៌្វចិត្តៃះ សវ៌្វឝក្តិភិឝ្ច ឦឝ្វរេ ប្រេមករណំ តថា ស្វមីបវាសិនិ ស្វវត៑ ប្រេមករណញ្ច សវ៌្វេភ្យោ ហោមពលិទានាទិភ្យះ ឝ្រឞ្ឋំ ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","តតោ យីឝុះ សុពុទ្ធេរិវ តស្យេទម៑ ឧត្តរំ ឝ្រុត្វា តំ ភាឞិតវាន៑ ត្វមីឝ្វរស្យ រាជ្យាន្ន ទូរោសិ។ ឥតះ បរំ តេន សហ កស្យាបិ វាក្យស្យ វិចារំ កត៌្តាំ កស្យាបិ ប្រគល្ភតា ន ជាតា។ ");
INSERT INTO sankhm_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","អនន្តរំ មធ្យេមន្ទិរម៑ ឧបទិឝន៑ យីឝុរិមំ ប្រឝ្នំ ចការ, អធ្យាបកា អភិឞិក្តំ (តារកំ) កុតោ ទាយូទះ សន្តានំ វទន្តិ? ");
INSERT INTO sankhm_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ស្វយំ ទាយូទ៑ បវិត្រស្យាត្មន អាវេឝេនេទំ កថយាមាស។ យថា។ \"មម ប្រភុមិទំ វាក្យវទត៑ បរមេឝ្វរះ។ តវ ឝត្រូនហំ យាវត៑ បាទបីឋំ ករោមិ ន។ តាវត៑ កាលំ មទីយេ ត្វំ ទក្ឞបាឝ៌្វ៑ ឧបាវិឝ។ \" ");
INSERT INTO sankhm_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","យទិ ទាយូទ៑ តំ ប្រភូំ វទតិ តហ៌ិ កថំ ស តស្យ សន្តានោ ភវិតុមហ៌តិ? ឥតរេ លោកាស្តត្កថាំ ឝ្រុត្វាននន្ទុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","តទានីំ ស តានុបទិឝ្យ កថិតវាន៑ យេ នរា ទីគ៌្ហបរិធេយានិ ហដ្ដេ វិបនៅ ច ");
INSERT INTO sankhm_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","លោកក្ឫតនមស្ការាន៑ ភជនគ្ឫហេ ប្រធានាសនានិ ភោជនកាលេ ប្រធានស្ថានានិ ច កាង្ក្ឞន្តេ; ");
INSERT INTO sankhm_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","វិធវានាំ សវ៌្វស្វំ គ្រសិត្វា ឆលាទ៑ ទីគ៌្ហកាលំ ប្រាត៌្ហយន្តេ តេភ្យ ឧបាធ្យាយេភ្យះ សាវធានា ភវត; តេៜធិកតរាន៑ ទណ្ឌាន៑ ប្រាប្ស្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","តទនន្តរំ លោកា ភាណ្ឌាគារេ មុទ្រា យថា និក្ឞិបន្តិ ភាណ្ឌាគារស្យ សម្មុខេ សមុបវិឝ្យ យីឝុស្តទវលុលោក; តទានីំ ពហវោ ធនិនស្តស្យ មធ្យេ ពហូនិ ធនានិ និរក្ឞិបន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","បឝ្ចាទ៑ ឯកា ទរិទ្រា វិធវា សមាគត្យ ទ្វិបណមូល្យាំ មុទ្រៃកាំ តត្រ និរក្ឞិបត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","តទា យីឝុះ ឝិឞ្យាន៑ អាហូយ កថិតវាន៑ យុឞ្មានហំ យថាត៌្ហំ វទាមិ យេ យេ ភាណ្ឌាគារេៜស្មិន ធនានិ និះក្ឞិបន្តិ ស្ម តេភ្យះ សវ៌្វេភ្យ ឥយំ វិធវា ទរិទ្រាធិកម៑ និះក្ឞិបតិ ស្ម។ ");
INSERT INTO sankhm_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","យតស្តេ ប្រភូតធនស្យ កិញ្ចិត៑ និរក្ឞិបន៑ កិន្តុ ទីនេយំ ស្វទិនយាបនយោគ្យំ កិញ្ចិទបិ ន ស្ថាបយិត្វា សវ៌្វស្វំ និរក្ឞិបត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","អនន្តរំ មន្ទិរាទ៑ ពហិគ៌មនកាលេ តស្យ ឝិឞ្យាណាមេកស្តំ វ្យាហ្ឫតវាន៑ ហេ គុរោ បឝ្យតុ កីទ្ឫឝាះ បាឞាណាះ កីទ្ឫក៑ ច និចយនំ។ ");
INSERT INTO sankhm_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","តទា យីឝុស្តម៑ អវទត៑ ត្វំ កិមេតទ៑ ព្ឫហន្និចយនំ បឝ្យសិ? អស្យៃកបាឞាណោបិ ទ្វិតីយបាឞាណោបរិ ន ស្ថាស្យតិ សវ៌្វេ ៜធះក្ឞេប្ស្យន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","អថ យស្មិន៑ កាលេ ជៃតុន្គិរៅ មន្ទិរស្យ សម្មុខេ ស សមុបវិឞ្ដស្តស្មិន៑ កាលេ បិតរោ យាកូព៑ យោហន៑ អាន្ទ្រិយឝ្ចៃតេ តំ រហសិ បប្រច្ឆុះ, ");
INSERT INTO sankhm_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","ឯតា ឃដនាះ កទា ភវិឞ្យន្តិ? តថៃតត្សវ៌្វាសាំ សិទ្ធ្យុបក្រមស្យ វា កិំ ចិហ្នំ? តទស្មភ្យំ កថយតុ ភវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","តតោ យាឝុស្តាន៑ វក្តុមារេភេ, កោបិ យថា យុឞ្មាន៑ ន ភ្រាមយតិ តថាត្រ យូយំ សាវធានា ភវត។ ");
INSERT INTO sankhm_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","យតះ ខ្រីឞ្ដោហមិតិ កថយិត្វា មម នាម្នានេកេ សមាគត្យ លោកានាំ ភ្រមំ ជនយិឞ្យន្តិ; ");
INSERT INTO sankhm_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","កិន្តុ យូយំ រណស្យ វាត៌្តាំ រណាឌម្ពរញ្ច ឝ្រុត្វា មា វ្យាកុលា ភវត, ឃដនា ឯតា អវឝ្យម្មាវិន្យះ; កិន្ត្វាបាតតោ ន យុគាន្តោ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","ទេឝស្យ វិបក្ឞតយា ទេឝោ រាជ្យស្យ វិបក្ឞតយា ច រាជ្យមុត្ថាស្យតិ, តថា ស្ថានេ ស្ថានេ ភូមិកម្បោ ទុព៌្ហិក្ឞំ មហាក្លេឝាឝ្ច សមុបស្ថាស្យន្តិ, សវ៌្វ ឯតេ ទុះខស្យារម្ភាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","កិន្តុ យូយម៑ អាត្មាត៌្ហេ សាវធានាស្តិឞ្ឋត, យតោ លោកា រាជសភាយាំ យុឞ្មាន៑ សមប៌យិឞ្យន្តិ, តថា ភជនគ្ឫហេ ប្រហរិឞ្យន្តិ; យូយំ មទត៌្ហេ ទេឝាធិបាន៑ ភូបាំឝ្ច ប្រតិ សាក្ឞ្យទានាយ តេឞាំ សម្មុខេ ឧបស្ថាបយិឞ្យធ្វេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ឝេឞីភវនាត៑ បូវ៌្វំ សវ៌្វាន៑ ទេឝីយាន៑ ប្រតិ សុសំវាទះ ប្រចារយិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","កិន្តុ យទា តេ យុឞ្មាន៑ ធ្ឫត្វា សមប៌យិឞ្យន្តិ តទា យូយំ យទ្យទ៑ ឧត្តរំ ទាស្យថ, តទគ្រ តស្យ វិវេចនំ មា កុរុត តទត៌្ហំ កិញ្ចិទបិ មា ចិន្តយត ច, តទានីំ យុឞ្មាកំ មនះសុ យទ្យទ៑ វាក្យម៑ ឧបស្ថាបយិឞ្យតេ តទេវ វទិឞ្យថ, យតោ យូយំ ន តទ្វក្តារះ កិន្តុ បវិត្រ អាត្មា តស្យ វក្តា។ ");
INSERT INTO sankhm_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","តទា ភ្រាតា ភ្រាតរំ បិតា បុត្រំ ឃាតនាត៌្ហំ បរហស្តេឞុ សមប៌យិឞ្យតេ, តថា បត្យានិ មាតាបិត្រោ រ្វិបក្ឞតយា តៅ ឃាតយិឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","មម នាមហេតោះ សវ៌្វេឞាំ សវិធេ យូយំ ជុគុប្សិតា ភវិឞ្យថ, កិន្តុ យះ កឝ្ចិត៑ ឝេឞបយ៌្យន្តំ ធៃយ៌្យម៑ អាលម្ពិឞ្យតេ សឯវ បរិត្រាស្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","ទានិយេល្ភវិឞ្យទ្វាទិនា ប្រោក្តំ សវ៌្វនាឝិ ជុគុប្សិតញ្ច វស្តុ យទា ត្វយោគ្យស្ថានេ វិទ្យមានំ ទ្រក្ឞថ (យោ ជនះ បឋតិ ស ពុធ្យតាំ) តទា យេ យិហូទីយទេឝេ តិឞ្ឋន្តិ តេ មហីធ្រំ ប្រតិ បលាយន្តាំ; ");
INSERT INTO sankhm_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","តថា យោ នរោ គ្ឫហោបរិ តិឞ្ឋតិ ស គ្ឫហមធ្យំ នាវរោហតុ, តថា កិមបិ វស្តុ គ្រហីតុំ មធ្យេគ្ឫហំ ន ប្រវិឝតុ; ");
INSERT INTO sankhm_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","តថា ច យោ នរះ ក្ឞេត្រេ តិឞ្ឋតិ សោបិ ស្វវស្ត្រំ គ្រហីតុំ បរាវ្ឫត្យ ន វ្រជតុ។ ");
INSERT INTO sankhm_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","តទានីំ គព៌្ភវតីនាំ ស្តន្យទាត្រីណាញ្ច យោឞិតាំ ទុគ៌តិ រ្ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","យុឞ្មាកំ បលាយនំ ឝីតកាលេ យថា ន ភវតិ តទត៌្ហំ ប្រាត៌្ហយធ្វំ។ ");
INSERT INTO sankhm_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","យតស្តទា យាទ្ឫឝី ទុគ៌្ហដនា ឃដិឞ្យតេ តាទ្ឫឝី ទុគ៌្ហដនា ឦឝ្វរស្ឫឞ្ដេះ ប្រថមមារភ្យាទ្យ យាវត៑ កទាបិ ន ជាតា ន ជនិឞ្យតេ ច។ ");
INSERT INTO sankhm_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","អបរញ្ច បរមេឝ្វរោ យទិ តស្យ សមយស្យ សំក្ឞេបំ ន ករោតិ តហ៌ិ កស្យាបិ ប្រាណភ្ឫតោ រក្ឞា ភវិតុំ ន ឝក្ឞ្យតិ, កិន្តុ យាន៑ ជនាន៑ មនោនីតាន៑ អករោត៑ តេឞាំ ស្វមនោនីតានាំ ហេតោះ ស តទនេហសំ សំក្ឞេប្ស្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","អន្យច្ច បឝ្យត ខ្រីឞ្ដោត្រ ស្ថានេ វា តត្រ ស្ថានេ វិទ្យតេ, តស្មិន្កាលេ យទិ កឝ្ចិទ៑ យុឞ្មាន៑ ឯតាទ្ឫឝំ វាក្យំ វ្យាហរតិ, តហ៌ិ តស្មិន៑ វាក្យេ ភៃវ វិឝ្វសិត។ ");
INSERT INTO sankhm_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","យតោនេកេ មិថ្យាខ្រីឞ្ដា មិថ្យាភវិឞ្យទ្វាទិនឝ្ច សមុបស្ថាយ ពហូនិ ចិហ្នាន្យទ្ភុតានិ កម៌្មាណិ ច ទឝ៌យិឞ្យន្តិ; តថា យទិ សម្ភវតិ តហ៌ិ មនោនីតលោកានាមបិ មិថ្យាមតិំ ជនយិឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","បឝ្យត ឃដនាតះ បូវ៌្វំ សវ៌្វកាយ៌្យស្យ វាត៌្តាំ យុឞ្មភ្យមទាម៑, យូយំ សាវធានាស្តិឞ្ឋត។ ");
INSERT INTO sankhm_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","អបរញ្ច តស្យ ក្លេឝកាលស្យាវ្យវហិតេ បរកាលេ ភាស្ករះ សាន្ធការោ ភវិឞ្យតិ តថៃវ ចន្ទ្រឝ្ចន្ទ្រិកាំ ន ទាស្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","នភះស្ថានិ នក្ឞត្រាណិ បតិឞ្យន្តិ, វ្យោមមណ្ឌលស្ថា គ្រហាឝ្ច វិចលិឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","តទានីំ មហាបរាក្រមេណ មហៃឝ្វយ៌្យេណ ច មេឃមារុហ្យ សមាយាន្តំ មានវសុតំ មានវាះ សមីក្ឞិឞ្យន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","អន្យច្ច ស និជទូតាន៑ ប្រហិត្យ នភោភូម្យោះ សីមាំ យាវទ៑ ជគតឝ្ចតុទ៌ិគ្ភ្យះ ស្វមនោនីតលោកាន៑ សំគ្រហីឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","ឧឌុម្ពរតរោ រ្ទ្ឫឞ្ដាន្តំ ឝិក្ឞធ្វំ យទោឌុម្ពរស្យ តរោ រ្នវីនាះ ឝាខា ជាយន្តេ បល្លវាទីនិ ច រ្និគច្ឆន្តិ, តទា និទាឃកាលះ សវិធោ ភវតីតិ យូយំ ជ្ញាតុំ ឝក្នុថ។ ");
INSERT INTO sankhm_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","តទ្វទ៑ ឯតា ឃដនា ទ្ឫឞ្ដ្វា ស កាលោ ទ្វាយ៌្យុបស្ថិត ឥតិ ជានីត។ ");
INSERT INTO sankhm_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","យុឞ្មានហំ យថាត៌្ហំ វទាមិ, អាធុនិកលោកានាំ គមនាត៑ បូវ៌្វំ តានិ សវ៌្វាណិ ឃដិឞ្យន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ទ្យាវាប្ឫថិវ្យោ រ្វិចលិតយោះ សត្យោ រ្មទីយា វាណី ន វិចលិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","អបរញ្ច ស្វគ៌ស្ថទូតគណោ វា បុត្រោ វា តាតាទន្យះ កោបិ តំ ទិវសំ តំ ទណ្ឌំ វា ន ជ្ញាបយតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","អតះ ស សមយះ កទា ភវិឞ្យតិ, ឯតជ្ជ្ញានាភាវាទ៑ យូយំ សាវធានាស្តិឞ្ឋត, សតក៌ាឝ្ច ភូត្វា ប្រាត៌្ហយធ្វំ; ");
INSERT INTO sankhm_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","យទ្វត៑ កឝ្ចិត៑ បុមាន៑ ស្វនិវេឝនាទ៑ ទូរទេឝំ ប្រតិ យាត្រាករណកាលេ ទាសេឞុ ស្វកាយ៌្យស្យ ភារមប៌យិត្វា សវ៌្វាន៑ ស្វេ ស្វេ កម៌្មណិ និយោជយតិ; អបរំ ទៅវារិកំ ជាគរិតុំ សមាទិឝ្យ យាតិ, តទ្វន៑ នរបុត្រះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","គ្ឫហបតិះ សាយំកាលេ និឝីថេ វា ត្ឫតីយយាមេ វា ប្រាតះកាលេ វា កទាគមិឞ្យតិ តទ៑ យូយំ ន ជានីថ; ");
INSERT INTO sankhm_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ស ហឋាទាគត្យ យថា យុឞ្មាន៑ និទ្រិតាន៑ ន បឝ្យតិ, តទត៌្ហំ ជាគរិតាស្តិឞ្ឋត។ ");
INSERT INTO sankhm_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","យុឞ្មានហំ យទ៑ វទាមិ តទេវ សវ៌្វាន៑ វទាមិ, ជាគរិតាស្តិឞ្ឋតេតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","តទា និស្តារោត្សវកិណ្វហីនបូបោត្សវយោរារម្ភស្យ ទិនទ្វយេ ៜវឝិឞ្ដេ ប្រធានយាជកា អធ្យាបកាឝ្ច កេនាបិ ឆលេន យីឝុំ ធត៌្តាំ ហន្តុញ្ច ម្ឫគយាញ្ចក្រិរេ; ");
INSERT INTO sankhm_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","កិន្តុ លោកានាំ កលហភយាទូចិរេ, នចោត្សវកាល ឧចិតមេតទិតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","អនន្តរំ ពៃថនិយាបុुរេ ឝិមោនកុឞ្ឋិនោ គ្ឫហេ យោឝៅ ភោត្កុមុបវិឞ្ដេ សតិ កាចិទ៑ យោឞិត៑ បាណ្ឌរបាឞាណស្យ សម្បុដកេន មហាគ៌្ហ្យោត្តមតៃលម៑ អានីយ សម្បុដកំ ភំក្ត្វា តស្យោត្តមាង្គេ តៃលធារាំ បាតយាញ្ចក្រេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","តស្មាត៑ កេចិត៑ ស្វាន្តេ កុប្យន្តះ កថិតវំន្តះ កុតោយំ តៃលាបវ្យយះ? ");
INSERT INTO sankhm_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","យទ្យេតត៑ តៃល វ្យក្រេឞ្យត តហ៌ិ មុទ្រាបាទឝតត្រយាទប្យធិកំ តស្យ ប្រាប្តមូល្យំ ទរិទ្រលោកេភ្យោ ទាតុមឝក្ឞ្យត, កថាមេតាំ កថយិត្វា តយា យោឞិតា សាកំ វាចាយុហ្យន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","កិន្តុ យីឝុរុវាច, កុត ឯតស្យៃ ក្ឫច្ឆ្រំ ទទាសិ? មហ្យមិយំ កម៌្មោត្តមំ ក្ឫតវតី។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ទរិទ្រាះ សវ៌្វទា យុឞ្មាភិះ សហ តិឞ្ឋន្តិ, តស្មាទ៑ យូយំ យទេច្ឆថ តទៃវ តានុបកត៌្តាំ ឝក្នុថ, កិន្ត្វហំ យុភាភិះ សហ និរន្តរំ ន តិឞ្ឋាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","អស្យា យថាសាធ្យំ តថៃវាករោទិយំ, ឝ្មឝានយាបនាត៑ បូវ៌្វំ សមេត្យ មទ្វបុឞិ តៃលម៑ អមទ៌្ទយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","អហំ យុឞ្មភ្យំ យថាត៌្ហំ កថយាមិ, ជគតាំ មធ្យេ យត្រ យត្រ សុសំវាទោយំ ប្រចារយិឞ្យតេ តត្រ តត្រ យោឞិត ឯតស្យាះ ស្មរណាត៌្ហំ តត្ក្ឫតកម៌្មៃតត៑ ប្រចារយិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","តតះ បរំ ទ្វាទឝានាំ ឝិឞ្យាណាមេក ឦឞ្ករិយោតីយយិហូទាខ្យោ យីឝុំ បរករេឞុ សមប៌យិតុំ ប្រធានយាជកានាំ សមីបមិយាយ។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","តេ តស្យ វាក្យំ សមាកណ៌្យ សន្តុឞ្ដាះ សន្តស្តស្មៃ មុទ្រា ទាតុំ ប្រត្យជានត; តស្មាត៑ ស តំ តេឞាំ ករេឞុ សមប៌ណាយោបាយំ ម្ឫគយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","អនន្តរំ កិណ្វឝូន្យបូបោត្សវស្យ ប្រថមេៜហនិ និស្តារោត្មវាត៌្ហំ មេឞមារណាសមយេ ឝិឞ្យាស្តំ បប្រច្ឆះ កុត្រ គត្វា វយំ និស្តារោត្សវស្យ ភោជ្យមាសាទយិឞ្យាមះ? កិមិច្ឆតិ ភវាន៑? ");
INSERT INTO sankhm_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","តទានីំ ស តេឞាំ ទ្វយំ ប្រេរយន៑ ពភាឞេ យុវយោះ បុរមធ្យំ គតយោះ សតោ រ្យោ ជនះ សជលកុម្ភំ វហន៑ យុវាំ សាក្ឞាត៑ ករិឞ្យតិ តស្យៃវ បឝ្ចាទ៑ យាតំ; ");
INSERT INTO sankhm_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ស យត៑ សទនំ ប្រវេក្ឞ្យតិ តទ្ភវនបតិំ វទតំ, គុរុរាហ យត្រ សឝិឞ្យោហំ និស្តារោត្សវីយំ ភោជនំ ករិឞ្យាមិ, សា ភោជនឝាលា កុត្រាស្តិ? ");
INSERT INTO sankhm_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","តតះ ស បរិឞ្ក្ឫតាំ សុសជ្ជិតាំ ព្ឫហតីចញ្ច យាំ ឝាលាំ ទឝ៌យិឞ្យតិ តស្យាមស្មទត៌្ហំ ភោជ្យទ្រវ្យាណ្យាសាទយតំ។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","តតះ ឝិឞ្យៅ ប្រស្ថាយ បុរំ ប្រវិឝ្យ ស យថោក្តវាន៑ តថៃវ ប្រាប្យ និស្តារោត្សវស្យ ភោជ្យទ្រវ្យាណិ សមាសាទយេតាម៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","អនន្តរំ យីឝុះ សាយំកាលេ ទ្វាទឝភិះ ឝិឞ្យៃះ សាទ៌្ធំ ជគាម; ");
INSERT INTO sankhm_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","សវ៌្វេឞុ ភោជនាយ ប្រោបវិឞ្ដេឞុ ស តានុទិតវាន៑ យុឞ្មានហំ យថាត៌្ហំ វ្យាហរាមិ, អត្រ យុឞ្មាកមេកោ ជនោ យោ មយា សហ ភុំក្តេ មាំ បរកេរេឞុ សមប៌យិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","តទានីំ តេ ទុះខិតាះ សន្ត ឯកៃកឝស្តំ ប្រឞ្ដុមារព្ធវន្តះ ស កិមហំ? បឝ្ចាទ៑ អន្យ ឯកោភិទធេ ស កិមហំ? ");
INSERT INTO sankhm_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","តតះ ស ប្រត្យវទទ៑ ឯតេឞាំ ទ្វាទឝានាំ យោ ជនោ មយា សមំ ភោជនាបាត្រេ បាណិំ មជ្ជយិឞ្យតិ ស ឯវ។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","មនុជតនយមធិ យាទ្ឫឝំ លិខិតមាស្តេ តទនុរូបា គតិស្តស្យ ភវិឞ្យតិ, កិន្តុ យោ ជនោ មានវសុតំ សមប៌យិឞ្យតេ ហន្ត តស្យ ជន្មាភាវេ សតិ ភទ្រមភវិឞ្យត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","អបរញ្ច តេឞាំ ភោជនសមយេ យីឝុះ បូបំ គ្ឫហីត្វេឝ្វរគុណាន៑ អនុកីត៌្យ ភង្ក្ត្វា តេភ្យោ ទត្ត្វា ពភាឞេ, ឯតទ៑ គ្ឫហីត្វា ភុញ្ជីធ្វម៑ ឯតន្មម វិគ្រហរូបំ។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","អនន្តរំ ស កំសំ គ្ឫហីត្វេឝ្វរស្យ គុណាន៑ កីត៌្តយិត្វា តេភ្យោ ទទៅ, តតស្តេ សវ៌្វេ បបុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","អបរំ ស តានវាទីទ៑ ពហូនាំ និមិត្តំ បាតិតំ មម នវីននិយមរូបំ ឝោណិតមេតត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","យុឞ្មានហំ យថាត៌្ហំ វទាមិ, ឦឝ្វរស្យ រាជ្យេ យាវត៑ សទ្យោជាតំ ទ្រាក្ឞារសំ ន បាស្យាមិ,តាវទហំ ទ្រាក្ឞាផលរសំ បុន រ្ន បាស្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","តទនន្តរំ តេ គីតមេកំ សំគីយ ពហិ រ្ជៃតុនំ ឝិខរិណំ យយុះ ");
INSERT INTO sankhm_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","អថ យីឝុស្តានុវាច និឝាយាមស្យាំ មយិ យុឞ្មាកំ សវ៌្វេឞាំ ប្រត្យូហោ ភវិឞ្យតិ យតោ លិខិតមាស្តេ យថា, មេឞាណាំ រក្ឞកញ្ចាហំ ប្រហរិឞ្យាមិ វៃ តតះ។ មេឞាណាំ និវហោ នូនំ ប្រវិកីណ៌ោ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","កន្តុ មទុត្ថានេ ជាតេ យុឞ្មាកមគ្រេៜហំ គាលីលំ វ្រជិឞ្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","តទា បិតរះ ប្រតិពភាឞេ, យទ្យបិ សវ៌្វេឞាំ ប្រត្យូហោ ភវតិ តថាបិ មម នៃវ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","តតោ យីឝុរុក្តាវាន៑ អហំ តុភ្យំ តថ្យំ កថយាមិ, ក្ឞណាទាយាមទ្យ កុក្កុដស្យ ទ្វិតីយវាររវណាត៑ បូវ៌្វំ ត្វំ វារត្រយំ មាមបហ្នោឞ្យសេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","កិន្តុ ស គាឍំ វ្យាហរទ៑ យទ្យបិ ត្វយា សាទ៌្ធំ មម ប្រាណោ យាតិ តថាបិ កថមបិ ត្វាំ នាបហ្នោឞ្យេ; សវ៌្វេៜបីតរេ តថៃវ ពភាឞិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","អបរញ្ច តេឞុ គេត្ឝិមានីនាមកំ ស្ថាន គតេឞុ ស ឝិឞ្យាន៑ ជគាទ, យាវទហំ ប្រាត៌្ហយេ តាវទត្រ ស្ថានេ យូយំ សមុបវិឝត។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","អថ ស បិតរំ យាកូពំ យោហនញ្ច គ្ឫហីត្វា វវ្រាជ; អត្យន្តំ ត្រាសិតោ វ្យាកុលិតឝ្ច តេភ្យះ កថយាមាស, ");
INSERT INTO sankhm_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","និធនកាលវត៑ ប្រាណោ មេៜតីវ ទះខមេតិ, យូយំ ជាគ្រតោត្រ ស្ថានេ តិឞ្ឋត។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","តតះ ស កិញ្ចិទ្ទូរំ គត្វា ភូមាវធោមុខះ បតិត្វា ប្រាត៌្ហិតវានេតត៑, យទិ ភវិតុំ ឝក្យំ តហ៌ិ ទុះខសមយោយំ មត្តោ ទូរីភវតុ។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","អបរមុទិតវាន៑ ហេ បិត រ្ហេ បិតះ សវ៌្វេំ ត្វយា សាធ្យំ, តតោ ហេតោរិមំ កំសំ មត្តោ ទូរីកុរុ, កិន្តុ តន៑ មមេច្ឆាតោ ន តវេច្ឆាតោ ភវតុ។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","តតះ បរំ ស ឯត្យ តាន៑ និទ្រិតាន៑ និរីក្ឞ្យ បិតរំ ប្រោវាច, ឝិមោន៑ ត្វំ កិំ និទ្រាសិ? ឃដិកាមេកាម៑ អបិ ជាគរិតុំ ន ឝក្នោឞិ? ");
INSERT INTO sankhm_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","បរីក្ឞាយាំ យថា ន បតថ តទត៌្ហំ សចេតនាះ សន្តះ ប្រាត៌្ហយធ្វំ; មន ឧទ្យុក្តមិតិ សត្យំ កិន្តុ វបុរឝក្តិកំ។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","អថ ស បុនវ៌្រជិត្វា បូវ៌្វវត៑ ប្រាត៌្ហយាញ្ចក្រេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","បរាវ្ឫត្យាគត្យ បុនរបិ តាន៑ និទ្រិតាន៑ ទទឝ៌ តទា តេឞាំ លោចនានិ និទ្រយា បូណ៌ានិ, តស្មាត្តស្មៃ កា កថា កថយិតវ្យា ត ឯតទ៑ ពោទ្ធុំ ន ឝេកុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","តតះបរំ ត្ឫតីយវារំ អាគត្យ តេភ្យោ ៜកថយទ៑ ឥទានីមបិ ឝយិត្វា វិឝ្រាម្យថ? យថេឞ្ដំ ជាតំ, សមយឝ្ចោបស្ថិតះ បឝ្យត មានវតនយះ បាបិលោកានាំ បាណិឞុ សមប៌្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ឧត្តិឞ្ឋត, វយំ វ្រជាមោ យោ ជនោ មាំ បរបាណិឞុ សមប៌យិឞ្យតេ បឝ្យត ស សមីបមាយាតះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ឥមាំ កថាំ កថយតិ ស, ឯតហ៌ិទ្វាទឝានាមេកោ យិហូទា នាមា ឝិឞ្យះ ប្រធានយាជកានាម៑ ឧបាធ្យាយានាំ ប្រាចីនលោកានាញ្ច សន្និធេះ ខង្គលគុឌធារិណោ ពហុលោកាន៑ គ្ឫហីត្វា តស្យ សមីប ឧបស្ថិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","អបរញ្ចាសៅ បរបាណិឞុ សមប៌យិតា បូវ៌្វមិតិ សង្កេតំ ក្ឫតវាន៑ យមហំ ចុម្ពិឞ្យាមិ ស ឯវាសៅ តមេវ ធ្ឫត្វា សាវធានំ នយត។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","អតោ ហេតោះ ស អាគត្យៃវ យោឝោះ សវិធំ គត្វា ហេ គុរោ ហេ គុរោ, ឥត្យុក្ត្វា តំ ចុចុម្ព។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","តទា តេ តទុបរិ បាណីនប៌យិត្វា តំ ទធ្នុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","តតស្តស្យ បាឝ៌្វស្ថានាំ លោកានាមេកះ ខង្គំ និឞ្កោឞយន៑ មហាយាជកស្យ ទាសមេកំ ប្រហ្ឫត្យ តស្យ កណ៌ំ ចិច្ឆេទ។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","បឝ្ចាទ៑ យីឝុស្តាន៑ វ្យាជហារ ខង្គាន៑ លគុឌាំឝ្ច គ្ឫហីត្វា មាំ កិំ ចៅរំ ធត៌្តាំ សមាយាតាះ? ");
INSERT INTO sankhm_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","មធ្យេមន្ទិរំ សមុបទិឝន៑ ប្រត្យហំ យុឞ្មាភិះ សហ ស្ថិតវានតហំ, តស្មិន៑ កាលេ យូយំ មាំ នាទីធរត, កិន្ត្វនេន ឝាស្ត្រីយំ វចនំ សេធនីយំ។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","តទា សវ៌្វេ ឝិឞ្យាស្តំ បរិត្យជ្យ បលាយាញ្ចក្រិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","អថៃកោ យុវា មានវោ នគ្នកាយេ វស្ត្រមេកំ និធាយ តស្យ បឝ្ចាទ៑ វ្រជន៑ យុវលោកៃ រ្ធ្ឫតោ ");
INSERT INTO sankhm_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","វស្ត្រំ វិហាយ នគ្នះ បលាយាញ្ចក្រេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","អបរញ្ច យស្មិន៑ ស្ថានេ ប្រធានយាជកា ឧបាធ្យាយាះ ប្រាចីនលោកាឝ្ច មហាយាជកេន សហ សទសិ ស្ថិតាស្តស្មិន៑ ស្ថានេ មហាយាជកស្យ សមីបំ យីឝុំ និន្យុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","បិតរោ ទូរេ តត្បឝ្ចាទ៑ ឥត្វា មហាយាជកស្យាដ្ដាលិកាំ ប្រវិឝ្យ កិង្ករៃះ សហោបវិឝ្យ វហ្និតាបំ ជគ្រាហ។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","តទានីំ ប្រធានយាជកា មន្ត្រិណឝ្ច យីឝុំ ឃាតយិតុំ តត្ប្រាតិកូល្យេន សាក្ឞិណោ ម្ឫគយាញ្ចក្រិរេ, កិន្តុ ន ប្រាប្តាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","អនេកៃស្តទ្វិរុទ្ធំ ម្ឫឞាសាក្ឞ្យេ ទត្តេបិ តេឞាំ វាក្យានិ ន សមគច្ឆន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","សវ៌្វឝេឞេ កិយន្ត ឧត្ថាយ តស្យ ប្រាតិកូល្យេន ម្ឫឞាសាក្ឞ្យំ ទត្ត្វា កថយាមាសុះ, ");
INSERT INTO sankhm_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","ឥទំ ករក្ឫតមន្ទិរំ វិនាឝ្យ ទិនត្រយមធ្យេ បុនរបរម៑ អករក្ឫតំ មន្ទិរំ និម៌្មាស្យាមិ, ឥតិ វាក្យម៑ អស្យ មុខាត៑ ឝ្រុតមស្មាភិរិតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","កិន្តុ តត្រាបិ តេឞាំ សាក្ឞ្យកថា ន សង្គាតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","អថ មហាយាជកោ មធ្យេសភម៑ ឧត្ថាយ យីឝុំ វ្យាជហារ, ឯតេ ជនាស្ត្វយិ យត៑ សាក្ឞ្យមទុះ ត្វមេតស្យ កិមប្យុត្តរំ កិំ ន ទាស្យសិ? ");
INSERT INTO sankhm_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","កិន្តុ ស កិមប្យុត្តរំ ន ទត្វា មៅនីភូយ តស្យៅ; តតោ មហាយាជកះ បុនរបិ តំ ប្ឫឞ្ដាវាន៑ ត្វំ សច្ចិទានន្ទស្យ តនយោ ៜភិឞិក្តស្ត្រតា? ");
INSERT INTO sankhm_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","តទា យីឝុស្តំ ប្រោវាច ភវាម្យហម៑ យូយញ្ច សវ៌្វឝក្តិមតោ ទក្ឞីណបាឝ៌្វេ សមុបវិឝន្តំ មេឃ មារុហ្យ សមាយាន្តញ្ច មនុឞ្យបុត្រំ សន្ទ្រក្ឞ្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","តទា មហាយាជកះ ស្វំ វមនំ ឆិត្វា វ្យាវហរត្ ");
INSERT INTO sankhm_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","កិមស្មាកំ សាក្ឞិភិះ ប្រយោជនម៑? ឦឝ្វរនិន្ទាវាក្យំ យុឞ្មាភិរឝ្រាវិ កិំ វិចារយថ? តទានីំ សវ៌្វេ ជគទុរយំ និធនទណ្ឌមហ៌តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","តតះ កឝ្ចិត៑ កឝ្ចិត៑ តទ្វបុឞិ និឞ្ឋីវំ និចិក្ឞេប តថា តន្មុខមាច្ឆាទ្យ ចបេដេន ហត្វា គទិតវាន៑ គណយិត្វា វទ, អនុចរាឝ្ច ចបេដៃស្តមាជឃ្នុះ ");
INSERT INTO sankhm_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","តតះ បរំ បិតរេៜដ្ដាលិកាធះកោឞ្ឋេ តិឞ្ឋតិ មហាយាជកស្យៃកា ទាសី សមេត្យ ");
INSERT INTO sankhm_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","តំ វិហ្និតាបំ គ្ឫហ្លន្តំ វិលោក្យ តំ សុនិរីក្ឞ្យ ពភាឞេ ត្វមបិ នាសរតីយយីឝោះ សង្គិនាម៑ ឯកោ ជន អាសីះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","កិន្តុ សោបហ្នុត្យ ជគាទ តមហំ ន វទ្មិ ត្វំ យត៑ កថយមិ តទប្យហំ ន ពុទ្ធ្យេ។ តទានីំ បិតរេ ចត្វរំ គតវតិ កុेក្កុដោ រុរាវ។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","អថាន្យា ទាសី បិតរំ ទ្ឫឞ្ដ្វា សមីបស្ថាន៑ ជនាន៑ ជគាទ អយំ តេឞាមេកោ ជនះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","តតះ ស ទ្វិតីយវារម៑ អបហ្នុតវាន៑ បឝ្ចាត៑ តត្រស្ថា លោកាះ បិតរំ ប្រោចុស្ត្វមវឝ្យំ តេឞាមេកោ ជនះ យតស្ត្វំ គាលីលីយោ នរ ឥតិ តវោច្ចារណំ ប្រកាឝយតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","តទា ស ឝបថាភិឝាបៅ ក្ឫត្វា ប្រោវាច យូយំ កថាំ កថយថ តំ នរំ ន ជានេៜហំ។ ");
INSERT INTO sankhm_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","តទានីំ ទ្វិតីយវារំ កុក្កុដោ ៜរាវីត៑។ កុក្កុដស្យ ទ្វិតីយរវាត៑ បូវ៌្វំ ត្វំ មាំ វារត្រយម៑ អបហ្នោឞ្យសិ, ឥតិ យទ្វាក្យំ យីឝុនា សមុទិតំ តត៑ តទា សំស្ម្ឫត្យ បិតរោ រោទិតុម៑ អារភត។ ");
INSERT INTO sankhm_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","អថ ប្រភាតេ សតិ ប្រធានយាជកាះ ប្រាញ្ច ឧបាធ្យាយាះ សវ៌្វេ មន្ត្រិណឝ្ច សភាំ ក្ឫត្វា យីឝុृំ ពន្ធយិត្វ បីលាតាខ្យស្យ ទេឝាធិបតេះ សវិធំ នីត្វា សមប៌យាមាសុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","តទា បីលាតស្តំ ប្ឫឞ្ដវាន៑ ត្វំ កិំ យិហូទីយលោកានាំ រាជា? តតះ ស ប្រត្យុក្តវាន៑ សត្យំ វទសិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","អបរំ ប្រធានយាជកាស្តស្យ ពហុឞុ វាក្យេឞុ ទោឞមារោបយាញ្ចក្រុះ កិន្តុ ស កិមបិ ន ប្រត្យុវាច។ ");
INSERT INTO sankhm_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","តទានីំ បីលាតស្តំ បុនះ បប្រច្ឆ ត្វំ កិំ នោត្តរយសិ? បឝ្យៃតេ ត្វទ្វិរុទ្ធំ កតិឞុ សាធ្យេឞុ សាក្ឞំ ទទតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","កន្តុ យីឝុស្តទាបិ នោត្តរំ ទទៅ តតះ បីលាត អាឝ្ចយ៌្យំ ជគាម។ ");
INSERT INTO sankhm_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","អបរញ្ច ការាពទ្ធេ កស្តិំឝ្ចិត៑ ជនេ តន្មហោត្សវកាលេ លោកៃ រ្យាចិតេ ទេឝាធិបតិស្តំ មោចយតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","យេ ច បូវ៌្វមុបប្លវមកាឞ៌ុរុបប្លវេ វធមបិ ក្ឫតវន្តស្តេឞាំ មធ្យេ តទានោំ ពរព្ពានាមក ឯកោ ពទ្ធ អាសីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","អតោ ហេតោះ បូវ៌្វាបរីយាំ រីតិកថាំ កថយិត្វា លោកា ឧច្ចៃរុវន្តះ បីលាតស្យ សមក្ឞំ និវេទយាមាសុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","តទា បីលាតស្តានាចខ្យៅ តហ៌ិ កិំ យិហូទីយានាំ រាជានំ មោចយិឞ្យាមិ? យុឞ្មាភិះ កិមិឞ្យតេ? ");
INSERT INTO sankhm_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","យតះ ប្រធានយាជកា ឦឞ៌្យាត ឯវ យីឝុំ សមាប៌យន្និតិ ស វិវេទ។ ");
INSERT INTO sankhm_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","កិន្តុ យថា ពរព្ពាំ មោចយតិ តថា ប្រាត៌្ហយិតុំ ប្រធានយាជកា លោកាន៑ ប្រវត៌្តយាមាសុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","អថ បីលាតះ បុនះ ប្ឫឞ្ដវាន៑ តហ៌ិ យំ យិហូទីយានាំ រាជេតិ វទថ តស្យ កិំ ករិឞ្យាមិ យុឞ្មាភិះ កិមិឞ្យតេ? ");
INSERT INTO sankhm_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","តទា តេ បុនរបិ ប្រោច្ចៃះ ប្រោចុស្តំ ក្រុឝេ វេធយ។ ");
INSERT INTO sankhm_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","តស្មាត៑ បីលាតះ កថិតវាន៑ កុតះ? ស កិំ កុកម៌្ម ក្ឫតវាន៑? កិន្តុ តេ បុនឝ្ច រុវន្តោ វ្យាជហ្រុស្តំ ក្រុឝេ វេធយ។ ");
INSERT INTO sankhm_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","តទា បីលាតះ សវ៌្វាល្លោកាន៑ តោឞយិតុមិច្ឆន៑ ពរព្ពាំ មោចយិត្វា យីឝុំ កឝាភិះ ប្រហ្ឫត្យ ក្រុឝេ វេទ្ធុំ តំ សមប៌យាម្ពភូវ។ ");
INSERT INTO sankhm_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","អនន្តរំ សៃន្យគណោៜដ្ដាលិកាម៑ អត៌្ហាទ៑ អធិបតេ រ្គ្ឫហំ យីឝុំ នីត្វា សេនានិវហំ សមាហុយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","បឝ្ចាត៑ តេ តំ ធូមលវណ៌វស្ត្រំ បរិធាប្យ កណ្ដកមុកុដំ រចយិត្វា ឝិរសិ សមារោប្យ ");
INSERT INTO sankhm_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ហេ យិហូទីយានាំ រាជន៑ នមស្ការ ឥត្យុក្ត្វា តំ នមស្កត៌្តាមារេភិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","តស្យោត្តមាង្គេ វេត្រាឃាតំ ចក្រុស្តទ្គាត្រេ និឞ្ឋីវញ្ច និចិក្ឞិបុះ, តថា តស្យ សម្មុខេ ជានុបាតំ ប្រណោមុះ ");
INSERT INTO sankhm_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ឥត្ថមុបហស្យ ធូម្រវណ៌វស្ត្រម៑ ឧត្តាយ៌្យ តស្យ វស្ត្រំ តំ បយ៌្យធាបយន៑ ក្រុឝេ វេទ្ធុំ ពហិន៌ិន្យុឝ្ច។ ");
INSERT INTO sankhm_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","តតះ បរំ សេកន្ទរស្យ រុផស្យ ច បិតា ឝិមោន្នាមា កុរីណីយលោក ឯកះ កុតឝ្ចិទ៑ គ្រាមាទេត្យ បថិ យាតិ តំ តេ យីឝោះ ក្រុឝំ វោឍុំ ពលាទ៑ ទធ្នុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","អថ គុល្គល្តា អត៌្ហាត៑ ឝិរះកបាលនាមកំ ស្ថានំ យីឝុមានីយ ");
INSERT INTO sankhm_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","តេ គន្ធរសមិឝ្រិតំ ទ្រាក្ឞារសំ បាតុំ តស្មៃ ទទុះ កិន្តុ ស ន ជគ្រាហ។ ");
INSERT INTO sankhm_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","តស្មិន៑ ក្រុឝេ វិទ្ធេ សតិ តេឞាមេកៃកឝះ កិំ ប្រាប្ស្យតីតិ និណ៌យាយ ");
INSERT INTO sankhm_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","តស្យ បរិធេយានាំ វិភាគាត៌្ហំ គុដិកាបាតំ ចក្រុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","អបរម៑ ឯឞ យិហូទីយានាំ រាជេតិ លិខិតំ ទោឞបត្រំ តស្យ ឝិរឩទ៌្វ្វម៑ អារោបយាញ្ចក្រុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","តស្យ វាមទក្ឞិណយោ រ្ទ្វៅ ចៅរៅ ក្រុឝយោ រ្វិវិធាតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","តេនៃវ \"អបរាធិជនៃះ សាទ៌្ធំ ស គណិតោ ភវិឞ្យតិ,\" ឥតិ ឝាស្ត្រោក្តំ វចនំ សិទ្ធមភូត។ ");
INSERT INTO sankhm_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","អនន្តរំ មាគ៌េ យេ យេ លោកា គមនាគមនេ ចក្រុស្តេ សវ៌្វ ឯវ ឝិរាំស្យាន្ទោល្យ និន្ទន្តោ ជគទុះ, រេ មន្ទិរនាឝក រេ ទិនត្រយមធ្យេ តន្និម៌្មាយក, ");
INSERT INTO sankhm_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","អធុនាត្មានម៑ អវិត្វា ក្រុឝាទវរោហ។ ");
INSERT INTO sankhm_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","កិញ្ច ប្រធានយាជកា អធ្យាបកាឝ្ច តទ្វត៑ តិរស្ក្ឫត្យ បរស្បរំ ចចក្ឞិរេ ឯឞ បរានាវត៑ កិន្តុ ស្វមវិតុំ ន ឝក្នោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","យទីស្រាយេលោ រាជាភិឞិក្តស្ត្រាតា ភវតិ តហ៌្យធុនៃន ក្រុឝាទវរោហតុ វយំ តទ៑ ទ្ឫឞ្ដ្វា វិឝ្វសិឞ្យាមះ; កិញ្ច យៅ លោកៅ តេន សាទ៌្ធំ ក្រុឝេ ៜវិធ្យេតាំ តាវបិ តំ និព៌្ហត៌្សយាមាសតុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","អថ ទ្វិតីយយាមាត៑ ត្ឫតីយយាមំ យាវត៑ សវ៌្វោ ទេឝះ សាន្ធការោភូត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","តតស្ត្ឫតីយប្រហរេ យីឝុរុច្ចៃរវទត៑ ឯលី ឯលី លាមា ឝិវក្តនី អត៌្ហាទ៑ \"ហេ មទីឝ មទីឝ ត្វំ បយ៌្យត្យាក្ឞីះ កុតោ ហិ មាំ?\" ");
INSERT INTO sankhm_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","តទា សមីបស្ថលោកានាំ កេចិត៑ តទ្វាក្យំ និឝម្យាចខ្យុះ បឝ្យៃឞ ឯលិយម៑ អាហូយតិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","តត ឯកោ ជនោ ធាវិត្វាគត្យ ស្បញ្ជេ ៜម្លរសំ បូរយិត្វា តំ នឌាគ្រេ និធាយ បាតុំ តស្មៃ ទត្ត្វាវទត៑ តិឞ្ឋ ឯលិយ ឯនមវរោហយិតុម៑ ឯតិ ន វេតិ បឝ្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","អថ យីឝុរុច្ចៃះ សមាហូយ ប្រាណាន៑ ជហៅ។ ");
INSERT INTO sankhm_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","តទា មន្ទិរស្យ ជវនិកោទ៌្វ្វាទធះរ្យ្យន្តា វិទីណ៌ា ទ្វិខណ្ឌាភូត៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","កិញ្ច ឥត្ថមុច្ចៃរាហូយ ប្រាណាន៑ ត្យជន្តំ តំ ទ្ឫឞ្ទ្វា តទ្រក្ឞណាយ និយុក្តោ យះ សេនាបតិរាសីត៑ សោវទត៑ នរោយម៑ ឦឝ្វរបុត្រ ឥតិ សត្យម៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","តទានីំ មគ្ទលីនី មរិសម៑ កនិឞ្ឋយាកូពោ យោសេឝ្ច មាតាន្យមរិយម៑ ឝាលោមី ច យាះ ស្ត្រិយោ ");
INSERT INTO sankhm_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","គាលីល្ប្រទេឝេ យីឝុំ សេវិត្វា តទនុគាមិន្យោ ជាតា ឥមាស្តទន្យាឝ្ច យា អនេកា នាយ៌ោ យីឝុនា សាទ៌្ធំ យិរូឝាលមមាយាតាស្តាឝ្ច ទូរាត៑ តានិ ទទ្ឫឝុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","អថាសាទនទិនស្យាត៌្ហាទ៑ វិឝ្រាមវារាត៑ បូវ៌្វទិនស្យ សាយំកាល អាគត ");
INSERT INTO sankhm_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ឦឝ្វររាជ្យាបេក្ឞ្យរិមថីយយូឞផនាមា មាន្យមន្ត្រី សមេត្យ បីលាតសវិធំ និព៌្ហយោ គត្វា យីឝោទ៌េហំ យយាចេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","កិន្តុ ស ឥទានីំ ម្ឫតះ បីលាត ឥត្យសម្ភវំ មត្វា ឝតសេនាបតិមាហូយ ស កទា ម្ឫត ឥតិ បប្រច្ឆ។ ");
INSERT INTO sankhm_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ឝតសេមនាបតិមុខាត៑ តជ្ជ្ញាត្វា យូឞផេ យីឝោទ៌េហំ ទទៅ។ ");
INSERT INTO sankhm_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","បឝ្ចាត៑ ស សូក្ឞ្មំ វាសះ ក្រីត្វា យីឝោះ កាយមវរោហ្យ តេន វាសសា វេឞ្ដាយិត្វា គិរៅ ខាតឝ្មឝានេ ស្ថាបិតវាន៑ បាឞាណំ លោឋយិត្វា ទ្វារិ និទធេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","កិន្តុ យត្រ សោស្ថាប្យត តត មគ្ទលីនី មរិយម៑ យោសិមាត្ឫមរិយម៑ ច ទទ្ឫឝត្ឫះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","អថ វិឝ្រាមវារេ គតេ មគ្ទលីនី មរិយម៑ យាកូពមាតា មរិយម៑ ឝាលោមី ចេមាស្តំ មទ៌្ទយិតុំ សុគន្ធិទ្រវ្យាណិ ក្រីត្វា ");
INSERT INTO sankhm_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","សប្តាហប្រថមទិនេៜតិប្រត្យូឞេ សូយ៌្យោទយកាលេ ឝ្មឝានមុបគតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","កិន្តុ ឝ្មឝានទ្វារបាឞាណោៜតិព្ឫហន៑ តំ កោៜបសារយិឞ្យតីតិ តាះ បរស្បរំ គទន្តិ! ");
INSERT INTO sankhm_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ឯតហ៌ិ និរីក្ឞ្យ បាឞាណោ ទ្វារោ ៜបសារិត ឥតិ ទទ្ឫឝុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","បឝ្ចាត្តាះ ឝ្មឝានំ ប្រវិឝ្យ ឝុក្លវណ៌ទីគ៌្ហបរិច្ឆទាវ្ឫតមេកំ យុវានំ ឝ្មឝានទក្ឞិណបាឝ៌្វ ឧបវិឞ្ដំ ទ្ឫឞ្ដ្វា ចមច្ចក្រុះ។ ");
INSERT INTO sankhm_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","សោៜវទត៑, មាភៃឞ្ដ យូយំ ក្រុឝេ ហតំ នាសរតីយយីឝុំ គវេឞយថ សោត្រ នាស្តិ ឝ្មឝានាទុទស្ថាត៑; តៃ រ្យត្រ ស ស្ថាបិតះ ស្ថានំ តទិទំ បឝ្យត។ ");
INSERT INTO sankhm_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","កិន្តុ តេន យថោក្តំ តថា យុឞ្មាកមគ្រេ គាលីលំ យាស្យតេ តត្រ ស យុឞ្មាន៑ សាក្ឞាត៑ ករិឞ្យតេ យូយំ គត្វា តស្យ ឝិឞ្យេភ្យះ បិតរាយ ច វាត៌្តាមិមាំ កថយត។ ");
INSERT INTO sankhm_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","តាះ កម្បិតា វិស្តិតាឝ្ច តូណ៌ំ ឝ្មឝានាទ៑ ពហិគ៌ត្វា បលាយន្ត ភយាត៑ កមបិ កិមបិ នាវទំឝ្ច។ ");
INSERT INTO sankhm_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","អបរំ យីឝុះ សប្តាហប្រថមទិនេ ប្រត្យូឞេ ឝ្មឝានាទុត្ថាយ យស្យាះ សប្តភូតាស្ត្យាជិតាស្តស្យៃ មគ្ទលីនីមរិយមេ ប្រថមំ ទឝ៌នំ ទទៅ។ ");
INSERT INTO sankhm_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","តតះ សា គត្វា ឝោករោទនក្ឫទ្ភ្យោៜនុគតលោកេភ្យស្តាំ វាត៌្តាំ កថយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","កិន្តុ យីឝុះ បុនជ៌ីវន៑ តស្យៃ ទឝ៌នំ ទត្តវានិតិ ឝ្រុត្វា តេ ន ប្រត្យយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","បឝ្ចាត៑ តេឞាំ ទ្វាយោ រ្គ្រាមយានកាលេ យីឝុរន្យវេឝំ ធ្ឫត្វា តាភ្យាំ ទឝ៌ន ទទៅ! ");
INSERT INTO sankhm_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","តាវបិ គត្វាន្យឝិឞ្យេភ្យស្តាំ កថាំ កថយាញ្ចក្រតុះ កិន្តុ តយោះ កថាមបិ តេ ន ប្រត្យយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ឝេឞត ឯកាទឝឝិឞ្យេឞុ ភោជនោបវិឞ្ដេឞុ យីឝុស្តេភ្យោ ទឝ៌នំ ទទៅ តថោត្ថានាត៑ បរំ តទ្ទឝ៌នប្រាប្តលោកានាំ កថាយាមវិឝ្វាសករណាត៑ តេឞាមវិឝ្វាសមនះកាឋិន្យាភ្យាំ ហេតុភ្យាំ ស តាំស្តជ៌ិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","អថ តានាចខ្យៅ យូយំ សវ៌្វជគទ៑ គត្វា សវ៌្វជនាន៑ ប្រតិ សុសំវាទំ ប្រចារយត។ ");
INSERT INTO sankhm_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","តត្រ យះ កឝ្ចិទ៑ វិឝ្វស្យ មជ្ជិតោ ភវេត៑ ស បរិត្រាស្យតេ កិន្តុ យោ ន វិឝ្វសិឞ្យតិ ស ទណ្ឌយិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","កិញ្ច យេ ប្រត្យេឞ្យន្តិ តៃរីទ្ឫគ៑ អាឝ្ចយ៌្យំ កម៌្ម ប្រកាឝយិឞ្យតេ តេ មន្នាម្នា ភូតាន៑ ត្យាជយិឞ្យន្តិ ភាឞា អន្យាឝ្ច វទិឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","អបរំ តៃះ សប៌េឞុ ធ្ឫតេឞុ ប្រាណនាឝកវស្តុនិ បីតេ ច តេឞាំ កាបិ ក្ឞតិ រ្ន ភវិឞ្យតិ; រោគិណាំ គាត្រេឞុ ករាប៌ិតេ តេៜរោគា ភវិឞ្យន្តិ ច។ ");
INSERT INTO sankhm_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","អថ ប្រភុស្តានិត្យាទិឝ្យ ស្វគ៌ំ នីតះ សន៑ បរមេឝ្វរស្យ ទក្ឞិណ ឧបវិវេឝ។ ");
INSERT INTO sankhm_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","តតស្តេ ប្រស្ថាយ សវ៌្វត្រ សុសំវាទីយកថាំ ប្រចារយិតុមារេភិរេ ប្រភុស្តុ តេឞាំ សហាយះ សន៑ ប្រកាឝិតាឝ្ចយ៌្យក្រិយាភិស្តាំ កថាំ ប្រមាណវតីំ ចការ។ ឥតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","ប្រថមតោ យេ សាក្ឞិណោ វាក្យប្រចារកាឝ្ចាសន៑ តេៜស្មាកំ មធ្យេ យទ្យត៑ សប្រមាណំ វាក្យមប៌យន្តិ ស្ម ");
INSERT INTO sankhm_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","តទនុសារតោៜន្យេបិ ពហវស្តទ្វ្ឫត្តាន្តំ រចយិតុំ ប្រវ្ឫត្តាះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","អតឯវ ហេ មហាមហិមថិយផិល៑ ត្វំ យា យាះ កថា អឝិក្ឞ្យថាស្តាសាំ ទ្ឫឍប្រមាណានិ យថា ប្រាប្នោឞិ ");
INSERT INTO sankhm_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","តទត៌្ហំ ប្រថមមារភ្យ តានិ សវ៌្វាណិ ជ្ញាត្វាហមបិ អនុក្រមាត៑ សវ៌្វវ្ឫត្តាន្តាន៑ តុភ្យំ លេខិតុំ មតិមកាឞ៌ម៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","យិហូទាទេឝីយហេរោទ្នាមកេ រាជត្វំ កុវ៌្វតិ អពីយយាជកស្យ បយ៌្យាយាធិការី សិខរិយនាមក ឯកោ យាជកោ ហារោណវំឝោទ្ភវា ឥលីឝេវាខ្យា ");
INSERT INTO sankhm_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","តស្យ ជាយា ទ្វាវិមៅ និទ៌ោឞៅ ប្រភោះ សវ៌្វាជ្ញា វ្យវស្ថាឝ្ច សំមន្យ ឦឝ្វរទ្ឫឞ្ដៅ ធាម៌្មិកាវាស្តាម៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","តយោះ សន្តាន ឯកោបិ នាសីត៑, យត ឥលីឝេវា ពន្ធ្យា តៅ ទ្វាវេវ វ្ឫទ្ធាវភវតាម៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","យទា ស្វបយ៌្យានុក្រមេណ សិខរិយ ឦឝ្វាស្យ សមក្ឞំ យាជកីយំ កម៌្ម ករោតិ ");
INSERT INTO sankhm_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","តទា យជ្ញស្យ ទិនបរិបាយ្យា បរមេឝ្វរស្យ មន្ទិរេ ប្រវេឝកាលេ ធូបជ្វាលនំ កម៌្ម តស្យ ករណីយមាសីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","តទ្ធូបជ្វាលនកាលេ លោកនិវហេ ប្រាត៌្ហនាំ កត៌ុំ ពហិស្តិឞ្ឋតិ ");
INSERT INTO sankhm_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","សតិ សិខរិយោ យស្យាំ វេទ្យាំ ធូបំ ជ្វាលយតិ តទ្ទក្ឞិណបាឝ៌្វេ បរមេឝ្វរស្យ ទូត ឯក ឧបស្ថិតោ ទឝ៌នំ ទទៅ។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","តំ ទ្ឫឞ្ដ្វា សិខរិយ ឧទ្វិវិជេ ឝឝង្កេ ច។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","តទា ស ទូតស្តំ ពភាឞេ ហេ សិខរិយ មា ភៃស្តវ ប្រាត៌្ហនា គ្រាហ្យា ជាតា តវ ភាយ៌្យា ឥលីឝេវា បុត្រំ ប្រសោឞ្យតេ តស្យ នាម យោेហន៑ ឥតិ ករិឞ្យសិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","កិញ្ច ត្វំ សានន្ទះ សហឞ៌ឝ្ច ភវិឞ្យសិ តស្យ ជន្មនិ ពហវ អានន្ទិឞ្យន្តិ ច។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","យតោ ហេតោះ ស បរមេឝ្វរស្យ គោចរេ មហាន៑ ភវិឞ្យតិ តថា ទ្រាក្ឞារសំ សុរាំ វា កិមបិ ន បាស្យតិ, អបរំ ជន្មារភ្យ បវិត្រេណាត្មនា បរិបូណ៌ះ ");
INSERT INTO sankhm_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","សន៑ ឥស្រាយេល្វំឝីយាន៑ អនេកាន៑ ប្រភោះ បរមេឝ្វរស្យ មាគ៌មានេឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","សន្តានាន៑ ប្រតិ បិត្ឫណាំ មនាំសិ ធម៌្មជ្ញានំ ប្រត្យនាជ្ញាគ្រាហិណឝ្ច បរាវត៌្តយិតុំ, ប្រភោះ បរមេឝ្វរស្យ សេវាត៌្ហម៑ ឯកាំ សជ្ជិតជាតិំ វិធាតុញ្ច ស ឯលិយរូបាត្មឝក្តិប្រាប្តស្តស្យាគ្រេ គមិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","តទា សិខរិយោ ទូតមវាទីត៑ កថមេតទ៑ វេត្ស្យាមិ? យតោហំ វ្ឫទ្ធោ មម ភាយ៌្យា ច វ្ឫទ្ធា។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","តតោ ទូតះ ប្រត្យុវាច បឝ្យេឝ្វរស្យ សាក្ឞាទ្វត៌្តី ជិព្រាយេល្នាមា ទូតោហំ ត្វយា សហ កថាំ គទិតុំ តុភ្យមិមាំ ឝុភវាត៌្តាំ ទាតុញ្ច ប្រេឞិតះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","កិន្តុ មទីយំ វាក្យំ កាលេ ផលិឞ្យតិ តត៑ ត្វយា ន ប្រតីតម៑ អតះ ការណាទ៑ យាវទេវ តានិ ន សេត្ស្យន្តិ តាវត៑ ត្វំ វក្តុំមឝក្តោ មូកោ ភវ។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","តទានីំ យេ យេ លោកាះ សិខរិយមបៃក្ឞន្ត តេ មធ្យេមន្ទិរំ តស្យ ពហុវិលម្ពាទ៑ អាឝ្ចយ៌្យំ មេនិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ស ពហិរាគតោ យទា កិមបិ វាក្យំ វក្តុមឝក្តះ សង្កេតំ ក្ឫត្វា និះឝព្ទស្តស្យៅ តទា មធ្យេមន្ទិរំ កស្យចិទ៑ ទឝ៌នំ តេន ប្រាប្តម៑ ឥតិ សវ៌្វេ ពុពុធិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","អនន្តរំ តស្យ សេវនបយ៌្យាយេ សម្បូណ៌េ សតិ ស និជគេហំ ជគាម។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","កតិបយទិនេឞុ គតេឞុ តស្យ ភាយ៌្យា ឥលីឝេវា គព៌្ភវតី ពភូវ ");
INSERT INTO sankhm_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","បឝ្ចាត៑ សា បញ្ចមាសាន៑ សំគោប្យាកថយត៑ លោកានាំ សមក្ឞំ មមាបមានំ ខណ្ឌយិតុំ បរមេឝ្វរោ មយិ ទ្ឫឞ្ដិំ បាតយិត្វា កម៌្មេទ្ឫឝំ ក្ឫតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","អបរញ្ច តស្យា គព៌្ភស្យ ឞឞ្ឋេ មាសេ ជាតេ គាលីល្ប្រទេឝីយនាសរត្បុរេ ");
INSERT INTO sankhm_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ទាយូទោ វំឝីយាយ យូឞផ្នាម្នេ បុរុឞាយ យា មរិយម្នាមកុមារី វាគ្ទត្តាសីត៑ តស្យាះ សមីបំ ជិព្រាយេល៑ ទូត ឦឝ្វរេណ ប្រហិតះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ស គត្វា ជគាទ ហេ ឦឝ្វរានុគ្ឫហីតកន្យេ តវ ឝុភំ ភូយាត៑ ប្រភុះ បរមេឝ្វរស្តវ សហាយោស្តិ នារីណាំ មធ្យេ ត្វមេវ ធន្យា។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","តទានីំ សា តំ ទ្ឫឞ្ដ្វា តស្យ វាក្យត ឧទ្វិជ្យ កីទ្ឫឝំ ភាឞណមិទម៑ ឥតិ មនសា ចិន្តយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","តតោ ទូតោៜវទត៑ ហេ មរិយម៑ ភយំ មាកាឞ៌ីះ, ត្វយិ បរមេឝ្វរស្យានុគ្រហោស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","បឝ្យ ត្វំ គព៌្ភំ ធ្ឫត្វា បុត្រំ ប្រសោឞ្យសេ តស្យ នាម យីឝុរិតិ ករិឞ្យសិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ស មហាន៑ ភវិឞ្យតិ តថា សវ៌្វេភ្យះ ឝ្រេឞ្ឋស្យ បុត្រ ឥតិ ខ្យាស្យតិ; អបរំ ប្រភុះ បរមេឝ្វរស្តស្យ បិតុទ៌ាយូទះ សិំហាសនំ តស្មៃ ទាស្យតិ; ");
INSERT INTO sankhm_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","តថា ស យាកូពោ វំឝោបរិ សវ៌្វទា រាជត្វំ ករិឞ្យតិ, តស្យ រាជត្វស្យាន្តោ ន ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","តទា មរិយម៑ តំ ទូតំ ពភាឞេ នាហំ បុរុឞសង្គំ ករោមិ តហ៌ិ កថមេតត៑ សម្ភវិឞ្យតិ? ");
INSERT INTO sankhm_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","តតោ ទូតោៜកថយត៑ បវិត្រ អាត្មា ត្វាមាឝ្រាយិឞ្យតិ តថា សវ៌្វឝ្រេឞ្ឋស្យ ឝក្តិស្តវោបរិ ឆាយាំ ករិឞ្យតិ តតោ ហេតោស្តវ គព៌្ភាទ៑ យះ បវិត្រពាលកោ ជនិឞ្យតេ ស ឦឝ្វរបុត្រ ឥតិ ខ្យាតិំ ប្រាប្ស្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","អបរញ្ច បឝ្យ តវ ជ្ញាតិរិលីឝេវា យាំ សវ៌្វេ ពន្ធ្យាមវទន៑ ឥទានីំ សា វាទ៌្ធក្យេ សន្តានមេកំ គព៌្ភេៜធារយត៑ តស្យ ឞឞ្ឋមាសោភូត៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","កិមបិ កម៌្ម នាសាធ្យម៑ ឦឝ្វរស្យ។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","តទា មរិយម៑ ជគាទ, បឝ្យ ប្រភេរហំ ទាសី មហ្យំ តវ វាក្យានុសារេណ សវ៌្វមេតទ៑ ឃដតាម៑; អននតរំ ទូតស្តស្យាះ សមីបាត៑ ប្រតស្ថេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","អថ កតិបយទិនាត៑ បរំ មរិយម៑ តស្មាត៑ បវ៌្វតមយប្រទេឝីយយិហូទាយា នគរមេកំ ឝីឃ្រំ គត្វា ");
INSERT INTO sankhm_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","សិខរិយយាជកស្យ គ្ឫហំ ប្រវិឝ្យ តស្យ ជាយាម៑ ឥលីឝេវាំ សម្ពោធ្យាវទត៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","តតោ មរិយមះ សម្ពោធនវាក្យេ ឥលីឝេវាយាះ កណ៌យោះ ប្រវិឞ្ដមាត្រេ សតិ តស្យា គព៌្ភស្ថពាលកោ ននត៌្ត។ តត ឥលីឝេវា បវិត្រេណាត្មនា បរិបូណ៌ា សតី ");
INSERT INTO sankhm_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ប្រោច្ចៃគ៌ទិតុមារេភេ, យោឞិតាំ មធ្យេ ត្វមេវ ធន្យា, តវ គព៌្ភស្ថះ ឝិឝុឝ្ច ធន្យះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ត្វំ ប្រភោម៌ាតា, មម និវេឝនេ ត្វយា ចរណាវប៌ិតៅ, មមាទ្យ សៅភាគ្យមេតត៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","បឝ្យ តវ វាក្យេ មម កណ៌យោះ ប្រវិឞ្ដមាត្រេ សតិ មមោទរស្ថះ ឝិឝុរានន្ទាន៑ ននត៌្ត។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","យា ស្ត្រី វ្យឝ្វសីត៑ សា ធន្យា, យតោ ហេតោស្តាំ ប្រតិ បរមេឝ្វរោក្តំ វាក្យំ សវ៌្វំ សិទ្ធំ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","តទានីំ មរិយម៑ ជគាទ។ ធន្យវាទំ បរេឝស្យ ករោតិ មាមកំ មនះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","មមាត្មា តារកេឝេ ច សមុល្លាសំ ប្រគច្ឆតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","អករោត៑ ស ប្រភុ រ្ទុឞ្ដិំ ស្វទាស្យា ទុគ៌តិំ ប្រតិ។ បឝ្យាទ្យារភ្យ មាំ ធន្យាំ វក្ឞ្យន្តិ បុរុឞាះ សទា។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","យះ សវ៌្វឝក្តិមាន៑ យស្យ នាមាបិ ច បវិត្រកំ។ ស ឯវ សុមហត្កម៌្ម ក្ឫតវាន៑ មន្និមិត្តកំ។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","យេ ពិភ្យតិ ជនាស្តស្មាត៑ តេឞាំ សន្តានបំក្តិឞុ។ អនុកម្បា តទីយា ច សវ៌្វទៃវ សុតិឞ្ឋតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ស្វពាហុពលតស្តេន ប្រាកាឝ្យត បរាក្រមះ។ មនះកុមន្ត្រណាសាទ៌្ធំ វិកីយ៌្យន្តេៜភិមានិនះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","សិំហាសនគតាល្លោកាន៑ ពលិនឝ្ចាវរោហ្យ សះ។ បទេឞូច្ចេឞុ លោកាំស្តុ ក្ឞុទ្រាន៑ សំស្ថាបយត្យបិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ក្ឞុធិតាន៑ មានវាន៑ ទ្រវ្យៃរុត្តមៃះ បរិតប៌្យ សះ។ សកលាន៑ ធនិនោ លោកាន៑ វិស្ឫជេទ៑ រិក្តហស្តកាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ឥព្រាហីមិ ច តទ្វំឝេ យា ទយាស្តិ សទៃវ តាំ។ ស្ម្ឫត្វា បុរា បិត្ឫណាំ នោ យថា សាក្ឞាត៑ ប្រតិឝ្រុតំ។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ឥស្រាយេល្សេវកស្តេន តថោបក្រិយតេ ស្វយំ៕ ");
INSERT INTO sankhm_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","អនន្តរំ មរិយម៑ ប្រាយេណ មាសត្រយម៑ ឥលីឝេវយា សហោឞិត្វា វ្យាឃុយ្យ និជនិវេឝនំ យយៅ។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","តទនន្តរម៑ ឥលីឝេវាយាះ ប្រសវកាល ឧបស្ថិតេ សតិ សា បុត្រំ ប្រាសោឞ្ដ។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","តតះ បរមេឝ្វរស្តស្យាំ មហានុគ្រហំ ក្ឫតវាន៑ ឯតត៑ ឝ្រុត្វា សមីបវាសិនះ កុដុម្ពាឝ្ចាគត្យ តយា សហ មុមុទិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","តថាឞ្ដមេ ទិនេ តេ ពាលកស្យ ត្វចំ ឆេត្តុម៑ ឯត្យ តស្យ បិត្ឫនាមានុរូបំ តន្នាម សិខរិយ ឥតិ កត៌្តុមីឞុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","កិន្តុ តស្យ មាតាកថយត៑ តន្ន, នាមាស្យ យោហន៑ ឥតិ កត៌្តវ្យម៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","តទា តេ វ្យាហរន៑ តវ វំឝមធ្យេ នាមេទ្ឫឝំ កស្យាបិ នាស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","តតះ បរំ តស្យ បិតរំ សិខរិយំ ប្រតិ សង្កេត្យ បប្រច្ឆុះ ឝិឝោះ កិំ នាម ការិឞ្យតេ? ");
INSERT INTO sankhm_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","តតះ ស ផលកមេកំ យាចិត្វា លិលេខ តស្យ នាម យោហន៑ ភវិឞ្យតិ។ តស្មាត៑ សវ៌្វេ អាឝ្ចយ៌្យំ មេនិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","តត្ក្ឞណំ សិខរិយស្យ ជិហ្វាជាឌ្យេៜបគតេ ស មុខំ វ្យាទាយ ស្បឞ្ដវណ៌មុច្ចាយ៌្យ ឦឝ្វរស្យ គុណានុវាទំ ចការ។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","តស្មាច្ចតុទ៌ិក្ស្ថាះ សមីបវាសិលោកា ភីតា ឯវមេតាះ សវ៌្វាះ កថា យិហូទាយាះ បវ៌្វតមយប្រទេឝស្យ សវ៌្វត្រ ប្រចារិតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","តស្មាត៑ ឝ្រោតារោ មនះសុ ស្ថាបយិត្វា កថយាម្ពភូវុះ កីទ្ឫឝោយំ ពាលោ ភវិឞ្យតិ? អថ បរមេឝ្វរស្តស្យ សហាយោភូត៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","តទា យោហនះ បិតា សិខរិយះ បវិត្រេណាត្មនា បរិបូណ៌ះ សន៑ ឯតាទ្ឫឝំ ភវិឞ្យទ្វាក្យំ កថយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","ឥស្រាយេលះ ប្រភុ រ្យស្តុ ស ធន្យះ បរមេឝ្វរះ។ អនុគ្ឫហ្យ និជាល្លោកាន៑ ស ឯវ បរិមោចយេត៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","វិបក្ឞជនហស្តេភ្យោ យថា មោច្យាមហេ វយំ។ យាវជ្ជីវញ្ច ធម៌្មេណ សារល្យេន ច និព៌្ហយាះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","សេវាមហៃ តមេវៃកម៑ ឯតត្ការណមេវ ច។ ស្វកីយំ សុបវិត្រញ្ច សំស្ម្ឫត្យ និយមំ សទា។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ក្ឫបយា បុរុឞាន៑ បូវ៌្វាន៑ និកឞាត៌្ហាត្តុ នះ បិតុះ។ ឥព្រាហីមះ សមីបេ យំ ឝបថំ ក្ឫតវាន៑ បុរា។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","តមេវ សផលំ កត៌្តំ តថា ឝត្រុគណស្យ ច។ ឫृតីយាការិណឝ្ចៃវ ករេភ្យោ រក្ឞណាយ នះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ស្ឫឞ្ដេះ ប្រថមតះ ស្វីយៃះ បវិត្រៃ រ្ភាវិវាទិភិះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","យថោក្តវាន៑ តថា ស្វស្យ ទាយូទះ សេវកស្យ តុ។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","វំឝេ ត្រាតារមេកំ ស សមុត្បាទិតវាន៑ ស្វយម៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","អតោ ហេ ពាលក ត្វន្តុ សវ៌្វេភ្យះ ឝ្រេឞ្ឋ ឯវ យះ។ តស្យៃវ ភាវិវាទីតិ ប្រវិខ្យាតោ ភវិឞ្យសិ។ អស្មាកំ ចរណាន៑ ក្ឞេមេ មាគ៌េ ចាលយិតុំ សទា។ ឯវំ ធ្វាន្តេៜរ្ថតោ ម្ឫត្យោឝ្ឆាយាយាំ យេ តុ មានវាះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ឧបវិឞ្ដាស្តុ តានេវ ប្រកាឝយិតុមេវ ហិ។ ក្ឫត្វា មហានុកម្បាំ ហិ យាមេវ បរមេឝ្វរះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ឩទ៌្វ្វាត៑ សូយ៌្យមុទាយ្យៃវាស្មភ្យំ ប្រាទាត្តុ ទឝ៌នំ។ តយានុកម្បយា ស្វស្យ លោកានាំ បាបមោចនេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","បរិត្រាណស្យ តេភ្យោ ហិ ជ្ញានវិឝ្រាណនាយ ច។ ប្រភោ រ្មាគ៌ំ បរិឞ្កត៌្តុំ តស្យាគ្រាយី ភវិឞ្យសិ៕ ");
INSERT INTO sankhm_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","អថ ពាលកះ ឝរីរេណ ពុទ្ធ្យា ច វទ៌្ធិតុមារេភេ; អបរញ្ច ស ឥស្រាយេលោ វំឝីយលោកានាំ សមីបេ យាវន្ន ប្រកដីភូតស្តាស្តាវត៑ ប្រាន្តរេ ន្យវសត៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","អបរញ្ច តស្មិន៑ កាលេ រាជ្យស្យ សវ៌្វេឞាំ លោកានាំ នាមានិ លេខយិតុម៑ អគស្តកៃសរ អាជ្ញាបយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","តទនុសារេណ កុរីណិយនាមនិ សុរិយាទេឝស្យ ឝាសកេ សតិ នាមលេខនំ ប្រារេភេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","អតោ ហេតោ រ្នាម លេខិតុំ សវ៌្វេ ជនាះ ស្វីយំ ស្វីយំ នគរំ ជគ្មុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","តទានីំ យូឞផ៑ នាម លេខិតុំ វាគ្ទត្តយា ស្វភាយ៌្យយា គព៌្ភវត្យា មរិយមា សហ ស្វយំ ទាយូទះ សជាតិវំឝ ឥតិ ការណាទ៑ គាលីល្ប្រទេឝស្យ នាសរត្នគរាទ្ ");
INSERT INTO sankhm_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","យិហូទាប្រទេឝស្យ ពៃត្លេហមាខ្យំ ទាយូទ្នគរំ ជគាម។ ");
INSERT INTO sankhm_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","អន្យច្ច តត្រ ស្ថានេ តយោស្តិឞ្ឋតោះ សតោ រ្មរិយមះ ប្រសូតិកាល ឧបស្ថិតេ ");
INSERT INTO sankhm_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","សា តំ ប្រថមសុតំ ប្រាសោឞ្ដ កិន្តុ តស្មិន៑ វាសគ្ឫហេ ស្ថានាភាវាទ៑ ពាលកំ វស្ត្រេណ វេឞ្ដយិត្វា គោឝាលាយាំ ស្ថាបយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","អនន្តរំ យេ កិយន្តោ មេឞបាលកាះ ស្វមេឞវ្រជរក្ឞាយៃ តត្ប្រទេឝេ ស្ថិត្វា រជន្យាំ ប្រាន្តរេ ប្រហរិណះ កម៌្ម កុវ៌្វន្តិ, ");
INSERT INTO sankhm_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","តេឞាំ សមីបំ បរមេឝ្វរស្យ ទូត អាគត្យោបតស្ថៅ; តទា ចតុឞ្បាឝ៌្វេ បរមេឝ្វរស្យ តេជសះ ប្រកាឝិតត្វាត៑ តេៜតិឝឝង្កិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","តទា ស ទូត ឧវាច មា ភៃឞ្ដ បឝ្យតាទ្យ ទាយូទះ បុរេ យុឞ្មន្និមិត្តំ ត្រាតា ប្រភុះ ខ្រីឞ្ដោៜជនិឞ្ដ, ");
INSERT INTO sankhm_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","សវ៌្វេឞាំ លោកានាំ មហានន្ទជនកម៑ ឥមំ មង្គលវ្ឫត្តាន្តំ យុឞ្មាន៑ ជ្ញាបយាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","យូយំ (តត្ស្ថានំ គត្វា) វស្ត្រវេឞ្ដិតំ តំ ពាលកំ គោឝាលាយាំ ឝយនំ ទ្រក្ឞ្យថ យុឞ្មាន៑ ប្រតីទំ ចិហ្នំ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ទូត ឥមាំ កថាំ កថិតវតិ តត្រាកស្មាត៑ ស្វគ៌ីយាះ ប្ឫតនា អាគត្យ កថាម៑ ឥមាំ កថយិត្វេឝ្វរស្យ គុណានន្វវាទិឞុះ, យថា, ");
INSERT INTO sankhm_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","សវ៌្វោទ៌្វ្វស្ថៃរីឝ្វរស្យ មហិមា សម្ប្រកាឝ្យតាំ។ ឝាន្តិព៌្ហូយាត៑ ប្ឫថិវ្យាស្តុ សន្តោឞឝ្ច នរាន៑ ប្រតិ៕ ");
INSERT INTO sankhm_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","តតះ បរំ តេឞាំ សន្និធេ រ្ទូតគណេ ស្វគ៌ំ គតេ មេឞបាលកាះ បរស្បរម៑ អវេចន៑ អាគច្ឆត ប្រភុះ បរមេឝ្វរោ យាំ ឃដនាំ ជ្ញាបិតវាន៑ តស្យា យាថយ៌ំ ជ្ញាតុំ វយមធុនា ពៃត្លេហម្បុរំ យាមះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","បឝ្ចាត៑ តេ តូណ៌ំ វ្រជិត្វា មរិយមំ យូឞផំ គោឝាលាយាំ ឝយនំ ពាលកញ្ច ទទ្ឫឝុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ឥត្ថំ ទ្ឫឞ្ដ្វា ពាលកស្យាត៌្ហេ ប្រោក្តាំ សវ៌្វកថាំ តេ ប្រាចារយាញ្ចក្រុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","តតោ យេ លោកា មេឞរក្ឞកាណាំ វទនេភ្យស្តាំ វាត៌្តាំ ឝុឝ្រុវុស្តេ មហាឝ្ចយ៌្យំ មេនិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","កិន្តុ មរិយម៑ ឯតត្សវ៌្វឃដនានាំ តាត្បយ៌្យំ វិវិច្យ មនសិ ស្ថាបយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","តត្បឝ្ចាទ៑ ទូតវិជ្ញប្តានុរូបំ ឝ្រុត្វា ទ្ឫឞ្ដ្វា ច មេឞបាលកា ឦឝ្វរស្យ គុណានុវាទំ ធន្យវាទញ្ច កុវ៌្វាណាះ បរាវ្ឫត្យ យយុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","អថ ពាលកស្យ ត្វក្ឆេទនកាលេៜឞ្ដមទិវសេ សមុបស្ថិតេ តស្យ គព៌្ភស្ថិតេះ បុវ៌្វំ ស្វគ៌ីយទូតោ យថាជ្ញាបយត៑ តទនុរូបំ តេ តន្នាមធេយំ យីឝុរិតិ ចក្រិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","តតះ បរំ មូសាលិខិតវ្យវស្ថាយា អនុសារេណ មរិយមះ ឝុចិត្វកាល ឧបស្ថិតេ, ");
INSERT INTO sankhm_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","\"ប្រថមជះ សវ៌្វះ បុរុឞសន្តានះ បរមេឝ្វរេ សមប៌្យតាំ,\" ឥតិ បរមេឝ្វរស្យ វ្យវស្ថយា ");
INSERT INTO sankhm_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","យីឝុំ បរមេឝ្វរេ សមប៌យិតុម៑ ឝាស្ត្រីយវិធ្យុក្តំ កបោតទ្វយំ បារាវតឝាវកទ្វយំ វា ពលិំ ទាតុំ តេ តំ គ្ឫហីត្វា យិរូឝាលមម៑ អាយយុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","យិរូឝាលម្បុរនិវាសី ឝិមិយោន្នាមា ធាម៌្មិក ឯក អាសីត៑ ស ឥស្រាយេលះ សាន្ត្វនាមបេក្ឞ្យ តស្ថៅ កិញ្ច បវិត្រ អាត្មា តស្មិន្នាវិព៌្ហូតះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","អបរំ ប្រភុណា បរមេឝ្វរេណាភិឞិក្តេ ត្រាតរិ ត្វយា ន ទ្ឫឞ្ដេ ត្វំ ន មរិឞ្យសីតិ វាក្យំ បវិត្រេណ អាត្មនា តស្ម ប្រាកថ្យត។ ");
INSERT INTO sankhm_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","អបរញ្ច យទា យីឝោះ បិតា មាតា ច តទត៌្ហំ វ្យវស្ថានុរូបំ កម៌្ម កត៌្តុំ តំ មន្ទិរម៑ អានិន្យតុស្តទា ");
INSERT INTO sankhm_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ឝិមិយោន៑ អាត្មន អាកឞ៌ណេន មន្ទិរមាគត្យ តំ ក្រោឌេ និធាយ ឦឝ្វរស្យ ធន្យវាទំ ក្ឫត្វា កថយាមាស, យថា, ");
INSERT INTO sankhm_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","ហេ ប្រភោ តវ ទាសោយំ និជវាក្យានុសារតះ។ ឥទានីន្តុ សកល្យាណោ ភវតា សំវិស្ឫជ្យតាម៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","យតះ សកលទេឝស្យ ទីប្តយេ ទីប្តិរូបកំ។ ");
INSERT INTO sankhm_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ឥស្រាយេលីយលោកស្យ មហាគៅរវរូបកំ។ ");
INSERT INTO sankhm_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","យំ ត្រាយកំ ជនានាន្តុ សម្មុខេ ត្វមជីជនះ។ សឯវ វិទ្យតេៜស្មាកំ ធ្រវំ នយននគោចរេ៕ ");
INSERT INTO sankhm_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","តទានីំ តេនោក្តា ឯតាះ សកលាះ កថាះ ឝ្រុត្វា តស្យ មាតា យូឞផ៑ ច វិស្មយំ មេនាតេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","តតះ បរំ ឝិមិយោន៑ តេភ្យ អាឝិឞំ ទត្ត្វា តន្មាតរំ មរិយមម៑ ឧវាច, បឝ្យ ឥស្រាយេលោ វំឝមធ្យេ ពហូនាំ បាតនាយោត្ថាបនាយ ច តថា វិរោធបាត្រំ ភវិតុំ, ពហូនាំ គុប្តមនោគតានាំ ប្រកដីករណាយ ពាលកោយំ និយុក្តោស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","តស្មាត៑ តវាបិ ប្រាណាះ ឝូលេន វ្យត្ស្យន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","អបរញ្ច អាឝេរស្យ វំឝីយផិនូយេលោ ទុហិតា ហន្នាខ្យា អតិជរតី ភវិឞ្យទ្វាទិន្យេកា យា វិវាហាត៑ បរំ សប្ត វត្សរាន៑ បត្យា សហ ន្យវសត៑ តតោ វិធវា ភូត្វា ចតុរឝីតិវឞ៌វយះបយ៌្យនតំ ");
INSERT INTO sankhm_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","មន្ទិរេ ស្ថិត្វា ប្រាត៌្ហនោបវាសៃទ៌ិវានិឝម៑ ឦឝ្វរម៑ អសេវត សាបិ ស្ត្រី តស្មិន៑ សមយេ មន្ទិរមាគត្យ ");
INSERT INTO sankhm_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","បរមេឝ្វរស្យ ធន្យវាទំ ចការ, យិរូឝាលម្បុរវាសិនោ យាវន្តោ លោកា មុក្តិមបេក្ឞ្យ ស្ថិតាស្តាន៑ យីឝោវ៌្ឫត្តាន្តំ ជ្ញាបយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ឥត្ថំ បរមេឝ្វរស្យ វ្យវស្ថានុសារេណ សវ៌្វេឞុ កម៌្មសុ ក្ឫតេឞុ តៅ បុនឝ្ច គាលីលោ នាសរត្នាមកំ និជនគរំ ប្រតស្ថាតេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","តត្បឝ្ចាទ៑ ពាលកះ ឝរីរេណ វ្ឫទ្ធិមេត្យ ជ្ញានេន បរិបូណ៌ អាត្មនា ឝក្តិមាំឝ្ច ភវិតុមារេភេ តថា តស្មិន៑ ឦឝ្វរានុគ្រហោ ពភូវ។ ");
INSERT INTO sankhm_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","តស្យ បិតា មាតា ច ប្រតិវឞ៌ំ និស្តារោត្សវសមយេ យិរូឝាលមម៑ អគច្ឆតាម៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","អបរញ្ច យីឝៅ ទ្វាទឝវឞ៌វយស្កេ សតិ តៅ បវ៌្វសមយស្យ រីត្យនុសារេណ យិរូឝាលមំ គត្វា ");
INSERT INTO sankhm_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","បាវ៌្វណំ សម្បាទ្យ បុនរបិ វ្យាឃុយ្យ យាតះ កិន្តុ យីឝុព៌ាលកោ យិរូឝាលមិ តិឞ្ឋតិ។ យូឞផ៑ តន្មាតា ច តទ៑ អវិទិត្វា ");
INSERT INTO sankhm_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ស សង្គិភិះ សហ វិទ្យត ឯតច្ច ពុទ្វ្វា ទិនៃកគម្យមាគ៌ំ ជគ្មតុះ។ កិន្តុ ឝេឞេ ជ្ញាតិពន្ធូនាំ សមីបេ ម្ឫគយិត្វា តទុទ្ទេेឝមប្រាប្យ ");
INSERT INTO sankhm_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","តៅ បុនរបិ យិរូឝាលមម៑ បរាវ្ឫត្យាគត្យ តំ ម្ឫគយាញ្ចក្រតុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","អថ ទិនត្រយាត៑ បរំ បណ្ឌិតានាំ មធ្យេ តេឞាំ កថាះ ឝ្ឫណ្វន៑ តត្ត្វំ ប្ឫច្ឆំឝ្ច មន្ទិរេ សមុបវិឞ្ដះ ស តាភ្យាំ ទ្ឫឞ្ដះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","តទា តស្យ ពុទ្ធ្យា ប្រត្យុត្តរៃឝ្ច សវ៌្វេ ឝ្រោតារោ វិស្មយមាបទ្យន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","តាទ្ឫឝំ ទ្ឫឞ្ដ្វា តស្យ ជនកោ ជននី ច ចមច្ចក្រតុះ កិញ្ច តស្យ មាតា តមវទត៑, ហេ បុត្រ, កថមាវាំ ប្រតីត្ថំ សមាចរស្ត្វម៑? បឝ្យ តវ បិតាហញ្ច ឝោកាកុលៅ សន្តៅ ត្វាមន្វិច្ឆាវះ ស្ម។ ");
INSERT INTO sankhm_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","តតះ សោវទត៑ កុតោ មាម៑ អន្វៃច្ឆតំ? បិតុគ៌្ឫហេ មយា ស្ថាតវ្យម៑ ឯតត៑ កិំ យុវាភ្យាំ ន ជ្ញាយតេ? ");
INSERT INTO sankhm_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","កិន្តុ តៅ តស្យៃតទ្វាក្យស្យ តាត្បយ៌្យំ ពោទ្ធុំ នាឝក្នុតាំ។ ");
INSERT INTO sankhm_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","តតះ បរំ ស តាភ្យាំ សហ នាសរតំ គត្វា តយោវ៌ឝីភូតស្តស្ថៅ កិន្តុ សវ៌្វា ឯតាះ កថាស្តស្យ មាតា មនសិ ស្ថាបយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","អថ យីឝោ រ្ពុទ្ធិះ ឝរីរញ្ច តថា តស្មិន៑ ឦឝ្វរស្យ មានវានាញ្ចានុគ្រហោ វទ៌្ធិតុម៑ អារេភេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","អនន្តរំ តិពិរិយកៃសរស្យ រាជត្វស្យ បញ្ចទឝេ វត្សរេ សតិ យទា បន្តីយបីលាតោ យិហូទាទេឝាធិបតិ រ្ហេរោទ៑ តុ គាលីល្ប្រទេឝស្យ រាជា ផិលិបនាមា តស្យ ភ្រាតា តុ យិតូរិយាយាស្ត្រាខោនីតិយាប្រទេឝស្យ ច រាជាសីត៑ លុឞានីយនាមា អវិលីនីទេឝស្យ រាជាសីត្ ");
INSERT INTO sankhm_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ហានន៑ កិយផាឝ្ចេមៅ ប្រធានយាជាកាវាស្តាំ តទានីំ សិខរិយស្យ បុត្រាយ យោហនេ មធ្យេប្រាន្តរម៑ ឦឝ្វរស្យ វាក្យេ ប្រកាឝិតេ សតិ ");
INSERT INTO sankhm_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ស យទ៌្ទន ឧភយតដប្រទេឝាន៑ សមេត្យ បាបមោចនាត៌្ហំ មនះបរាវត៌្តនស្យ ចិហ្នរូបំ យន្មជ្ជនំ តទីយាះ កថាះ សវ៌្វត្រ ប្រចារយិតុមារេភេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","យិឝយិយភវិឞ្យទ្វក្ត្ឫគ្រន្ថេ យាទ្ឫឝី លិបិរាស្តេ យថា, បរមេឝស្យ បន្ថានំ បរិឞ្កុរុត សវ៌្វតះ។ តស្យ រាជបថញ្ចៃវ សមានំ កុរុតាធុនា។ ");
INSERT INTO sankhm_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ការិឞ្យន្តេ សមុច្ឆ្រាយាះ សកលា និម្នភូមយះ។ ការិឞ្យន្តេ នតាះ សវ៌្វេ បវ៌្វតាឝ្ចោបបវ៌្វតាះ។ ការិឞ្យន្តេ ច យា វក្រាស្តាះ សវ៌្វាះ សរលា ភុវះ។ ការិឞ្យន្តេ សមានាស្តា យា ឧច្ចនីចភូមយះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ឦឝ្វរេណ ក្ឫតំ ត្រាណំ ទ្រក្ឞ្យន្តិ សវ៌្វមានវាះ។ ឥត្យេតត៑ ប្រាន្តរេ វាក្យំ វទតះ កស្យចិទ៑ រវះ៕ ");
INSERT INTO sankhm_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","យេ យេ លោកា មជ្ជនាត៌្ហំ ពហិរាយយុស្តាន៑ សោវទត៑ រេ រេ សប៌វំឝា អាគាមិនះ កោបាត៑ បលាយិតុំ យុឞ្មាន៑ កឝ្ចេតយាមាស? ");
INSERT INTO sankhm_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","តស្មាទ៑ ឥព្រាហីម៑ អស្មាកំ បិតា កថាមីទ្ឫឝីំ មនោភិ រ្ន កថយិត្វា យូយំ មនះបរិវត៌្តនយោគ្យំ ផលំ ផលត; យុឞ្មានហំ យថាត៌្ហំ វទាមិ បាឞាណេភ្យ ឯតេភ្យ ឦឝ្វរ ឥព្រាហីមះ សន្តានោត្បាទនេ សមត៌្ហះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","អបរញ្ច តរុមូលេៜធុនាបិ បរឝុះ សំលគ្នោស្តិ យស្តរុរុត្តមំ ផលំ ន ផលតិ ស ឆិទ្យតេៜគ្នៅ និក្ឞិប្យតេ ច។ ");
INSERT INTO sankhm_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","តទានីំ លោកាស្តំ បប្រច្ឆុស្តហ៌ិ កិំ កត៌្តវ្យមស្មាភិះ? ");
INSERT INTO sankhm_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","តតះ សោវាទីត៑ យស្យ ទ្វេ វសនេ វិទ្យេតេ ស វស្ត្រហីនាយៃកំ វិតរតុ កិំញ្ច យស្យ ខាទ្យទ្រវ្យំ វិទ្យតេ សោបិ តថៃវ ករោតុ។ ");
INSERT INTO sankhm_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","តតះ បរំ ករសញ្ចាយិនោ មជ្ជនាត៌្ហម៑ អាគត្យ បប្រច្ឆុះ ហេ គុរោ កិំ កត៌្តវ្យមស្មាភិះ? ");
INSERT INTO sankhm_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","តតះ សោកថយត៑ និរូបិតាទធិកំ ន គ្ឫហ្លិត។ ");
INSERT INTO sankhm_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","អនន្តរំ សេនាគណ ឯត្យ បប្រច្ឆ កិមស្មាភិ រ្វា កត៌្តវ្យម៑? តតះ សោភិទធេ កស្យ កាមបិ ហានិំ មា កាឞ៌្ដ តថា ម្ឫឞាបវាទំ មា កុរុត និជវេតនេន ច សន្តុឞ្យ តិឞ្ឋត។ ");
INSERT INTO sankhm_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","អបរញ្ច លោកា អបេក្ឞយា ស្ថិត្វា សវ៌្វេបីតិ មនោភិ រ្វិតក៌យាញ្ចក្រុះ, យោហនយម៑ អភិឞិក្តស្ត្រាតា ន វេតិ? ");
INSERT INTO sankhm_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","តទា យោហន៑ សវ៌្វាន៑ វ្យាជហារ, ជលេៜហំ យុឞ្មាន៑ មជ្ជយាមិ សត្យំ កិន្តុ យស្យ បាទុកាពន្ធនំ មោចយិតុមបិ ន យោគ្យោស្មិ តាទ្ឫឝ ឯកោ មត្តោ គុរុតរះ បុមាន៑ ឯតិ, ស យុឞ្មាន៑ វហ្និរូបេ បវិត្រ អាត្មនិ មជ្ជយិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","អបរញ្ច តស្យ ហស្តេ ឝូប៌ អាស្តេ ស ស្វឝស្យានិ ឝុទ្ធរូបំ ប្រស្ផោដ្យ គោធូមាន៑ សវ៌្វាន៑ ភាណ្ឌាគារេ សំគ្រហីឞ្យតិ កិន្តុ ពូឞាណិ សវ៌្វាណ្យនិវ៌្វាណវហ្និនា ទាហយិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","យោហន៑ ឧបទេឝេនេត្ថំ នានាកថា លោកានាំ សមក្ឞំ ប្រចារយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","អបរញ្ច ហេរោទ៑ រាជា ផិលិប្នាម្នះ សហោទរស្យ ភាយ៌្យាំ ហេរោទិយាមធិ តថាន្យានិ យានិ យានិ កុកម៌្មាណិ ក្ឫតវាន៑ តទធិ ច ");
INSERT INTO sankhm_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","យោហនា តិរស្ក្ឫតោ ភូត្វា ការាគារេ តស្យ ពន្ធនាទ៑ អបរមបិ កុកម៌្ម ចការ។ ");
INSERT INTO sankhm_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ឥតះ បូវ៌្វំ យស្មិន៑ សមយេ សវ៌្វេ យោហនា មជ្ជិតាស្តទានីំ យីឝុរប្យាគត្យ មជ្ជិតះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","តទនន្តរំ តេន ប្រាត៌្ហិតេ មេឃទ្វារំ មុក្តំ តស្មាច្ច បវិត្រ អាត្មា មូត៌្តិមាន៑ ភូត្វា កបោតវត៑ តទុបយ៌្យវរុរោហ; តទា ត្វំ មម ប្រិយះ បុត្រស្ត្វយិ មម បរមះ សន្តោឞ ឥត្យាកាឝវាណី ពភូវ។ ");
INSERT INTO sankhm_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","តទានីំ យីឝុះ ប្រាយេណ ត្រិំឝទ្វឞ៌វយស្ក អាសីត៑។ លៅកិកជ្ញានេ តុ ស យូឞផះ បុត្រះ, ");
INSERT INTO sankhm_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","យូឞផ៑ ឯលេះ បុត្រះ, ឯលិម៌ត្តតះ បុត្រះ, មត្តត៑ លេវេះ បុត្រះ, លេវិ រ្មល្កេះ បុត្រះ, មល្កិយ៌ាន្នស្យ បុត្រះ; យាន្នោ យូឞផះ បុត្រះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","យូឞផ៑ មត្តថិយស្យ បុត្រះ, មត្តថិយ អាមោសះ បុត្រះ, អាមោស៑ នហូមះ បុត្រះ, នហូម៑ ឥឞ្លេះ បុត្រះ ឥឞ្លិន៌គេះ បុត្រះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","នគិម៌ាដះ បុត្រះ, មាដ៑ មត្តថិយស្យ បុត្រះ, មត្តថិយះ ឝិមិយេះ បុត្រះ, ឝិមិយិយ៌ូឞផះ បុត្រះ, យូឞផ៑ យិហូទាះ បុត្រះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","យិហូទា យោហានាះ បុត្រះ, យោហានា រីឞាះ បុត្រះ, រីឞាះ សិរុព្ពាពិលះ បុត្រះ, សិរុព្ពាពិល៑ ឝល្តីយេលះ បុត្រះ, ឝល្តីយេល៑ នេរេះ បុត្រះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","នេរិម៌ល្កេះ បុត្រះ, មល្កិះ អទ្យះ បុត្រះ, អទ្ទី កោឞមះ បុត្រះ, កោឞម៑ ឥល្មោទទះ បុត្រះ, ឥល្មោទទ៑ ឯរះ បុត្រះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ឯរ៑ យោឝេះ បុត្រះ, យោឝិះ ឥលីយេឞរះ បុត្រះ, ឥលីយេឞរ៑ យោរីមះ បុត្រះ, យោរីម៑ មត្តតះ បុត្រះ, មត្តត លេវេះ បុត្រះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","លេវិះ ឝិមិយោនះ បុត្រះ, ឝិមិយោន៑ យិហូទាះ បុត្រះ, យិហូទា យូឞុផះ បុត្រះ, យូឞុផ៑ យោននះ បុត្រះ, យានន៑ ឥលីយាកីមះ បុត្រះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ឥលិយាកីម្ះ មិលេយាះ បុត្រះ, មិលេយា មៃននះ បុត្រះ, មៃនន៑ មត្តត្តស្យ បុត្រះ, មត្តត្តោ នាថនះ បុត្រះ, នាថន៑ ទាយូទះ បុត្រះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ទាយូទ៑ យិឝយះ បុត្រះ, យិឝយ ឱពេទះ បុត្រ, ឱពេទ៑ ពោយសះ បុត្រះ, ពោយស៑ សល្មោនះ បុត្រះ, សល្មោន៑ នហឝោនះ បុត្រះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","នហឝោន៑ អម្មីនាទពះ បុត្រះ, អម្មីនាទព៑ អរាមះ បុត្រះ, អរាម៑ ហិឞ្រោណះ បុត្រះ, ហិឞ្រោណ៑ បេរសះ បុត្រះ, បេរស៑ យិហូទាះ បុត្រះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","យិហូទា យាកូពះ បុត្រះ, យាកូព៑ ឥស្ហាកះ បុត្រះ, ឥស្ហាក៑ ឥព្រាហីមះ បុត្រះ, ឥព្រាហីម៑ តេរហះ បុត្រះ, តេរហ៑ នាហោរះ បុត្រះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","នាហោរ៑ សិរុគះ បុត្រះ, សិរុគ៑ រិយ្វះ បុត្រះ, រិយូះ បេលគះ បុត្រះ, បេលគ៑ ឯវរះ បុត្រះ, ឯវរ៑ ឝេលហះ បុត្រះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ឝេលហ៑ កៃននះ បុត្រះ, កៃនន៑ អប៌្ហក្ឞទះ បុត្រះ, អប៌្ហក្ឞទ៑ ឝាមះ បុត្រះ, ឝាម៑ នោហះ បុត្រះ, នោហោ លេមកះ បុត្រះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","លេមក៑ មិថូឝេលហះ បុត្រះ, មិថូឝេលហ៑ ហនោកះ បុត្រះ, ហនោក៑ យេរទះ បុត្រះ, យេរទ៑ មហលលេលះ បុត្រះ, មហលលេល៑ កៃននះ បុត្រះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","កៃនន៑ ឥនោឝះ បុត្រះ, ឥនោឝ៑ ឝេតះ បុត្រះ, ឝេត៑ អាទមះ បុត្រ, អាទម៑ ឦឝ្វរស្យ បុត្រះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","តតះ បរំ យីឝុះ បវិត្រេណាត្មនា បូណ៌ះ សន៑ យទ៌្ទននទ្យាះ បរាវ្ឫត្យាត្មនា ប្រាន្តរំ នីតះ សន៑ ចត្វារិំឝទ្ទិនានិ យាវត៑ ឝៃតានា បរីក្ឞិតោៜភូត៑, ");
INSERT INTO sankhm_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","កិញ្ច តានិ សវ៌្វទិនានិ ភោជនំ វិនា ស្ថិតត្វាត៑ កាលេ បូណ៌េ ស ក្ឞុធិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","តតះ ឝៃតានាគត្យ តមវទត៑ ត្វំ ចេទីឝ្វរស្យ បុត្រស្តហ៌ិ ប្រស្តរានេតាន៑ អាជ្ញយា បូបាន៑ កុរុ។ ");
INSERT INTO sankhm_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","តទា យីឝុរុវាច, លិបិរីទ្ឫឝី វិទ្យតេ មនុជះ កេវលេន បូបេន ន ជីវតិ កិន្ត្វីឝ្វរស្យ សវ៌្វាភិរាជ្ញាភិ រ្ជីវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","តទា ឝៃតាន៑ តមុច្ចំ បវ៌្វតំ នីត្វា និមិឞៃកមធ្យេ ជគតះ សវ៌្វរាជ្យានិ ទឝ៌ិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","បឝ្ចាត៑ តមវាទីត៑ សវ៌្វម៑ ឯតទ៑ វិភវំ ប្រតាបញ្ច តុភ្យំ ទាស្យាមិ តន៑ មយិ សមប៌ិតមាស្តេ យំ ប្រតិ មមេច្ឆា ជាយតេ តស្មៃ ទាតុំ ឝក្នោមិ, ");
INSERT INTO sankhm_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ត្វំ ចេន្មាំ ភជសេ តហ៌ិ សវ៌្វមេតត៑ តវៃវ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","តទា យីឝុស្តំ ប្រត្យុក្តវាន៑ ទូរី ភវ ឝៃតាន៑ លិបិរាស្តេ, និជំ ប្រភុំ បរមេឝ្វរំ ភជស្វ កេវលំ តមេវ សេវស្វ ច។ ");
INSERT INTO sankhm_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","អថ ឝៃតាន៑ តំ យិរូឝាលមំ នីត្វា មន្ទិរស្យ ចូឌាយា ឧបរិ សមុបវេឝ្យ ជគាទ ត្វំ ចេទីឝ្វរស្យ បុត្រស្តហ៌ិ ស្ថានាទិតោ លម្ផិត្វាធះ ");
INSERT INTO sankhm_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","បត យតោ លិបិរាស្តេ, អាជ្ញាបយិឞ្យតិ ស្វីយាន៑ ទូតាន៑ ស បរមេឝ្វរះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","រក្ឞិតុំ សវ៌្វមាគ៌េ ត្វាំ តេន ត្វច្ចរណេ យថា។ ន លគេត៑ ប្រស្តរាឃាតស្ត្វាំ ធរិឞ្យន្តិ តេ តថា។ ");
INSERT INTO sankhm_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","តទា យីឝុនា ប្រត្យុក្តម៑ ឥទមប្យុក្តមស្តិ ត្វំ ស្វប្រភុំ បរេឝំ មា បរីក្ឞស្វ។ ");
INSERT INTO sankhm_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","បឝ្ចាត៑ ឝៃតាន៑ សវ៌្វបរីក្ឞាំ សមាប្យ ក្ឞណាត្តំ ត្យក្ត្វា យយៅ។ ");
INSERT INTO sankhm_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","តទា យីឝុរាត្មប្រភាវាត៑ បុនគ៌ាលីល្ប្រទេឝំ គតស្តទា តត្សុខ្យាតិឝ្ចតុទ៌ិឝំ វ្យានឝេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ស តេឞាំ ភជនគ្ឫហេឞុ ឧបទិឝ្យ សវ៌្វៃះ ប្រឝំសិតោ ពភូវ។ ");
INSERT INTO sankhm_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","អថ ស ស្វបាលនស្ថានំ នាសរត្បុរមេត្យ វិឝ្រាមវារេ ស្វាចារាទ៑ ភជនគេហំ ប្រវិឝ្យ បឋិតុមុត្តស្ថៅ។ ");
INSERT INTO sankhm_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","តតោ យិឝយិយភវិឞ្យទ្វាទិនះ បុស្តកេ តស្យ ករទត្តេ សតិ ស តត៑ បុស្តកំ វិស្តាយ៌្យ យត្រ វក្ឞ្យមាណានិ វចនានិ សន្តិ តត៑ ស្ថានំ ប្រាប្យ បបាឋ។ ");
INSERT INTO sankhm_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","អាត្មា តុ បរមេឝស្យ មទីយោបរិ វិទ្យតេ។ ទរិទ្រេឞុ សុសំវាទំ វក្តុំ មាំ សោភិឞិក្តវាន៑។ ភគ្នាន្តះ ករណាល្លោកាន៑ សុស្វស្ថាន៑ កត៌្តុមេវ ច។ ពន្ទីក្ឫតេឞុ លោកេឞុ មុក្តេ រ្ឃោឞយិតុំ វចះ។ នេត្រាណិ ទាតុមន្ធេភ្យស្ត្រាតុំ ពទ្ធជនានបិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","បរេឝានុគ្រហេ កាលំ ប្រចារយិតុមេវ ច។ សវ៌្វៃតត្ករណាត៌្ហាយ មាមេវ ប្រហិណោតិ សះ៕ ");
INSERT INTO sankhm_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","តតះ បុស្តកំ ពទ្វ្វា បរិចារកស្យ ហស្តេ សមប៌្យ ចាសនេ សមុបវិឞ្ដះ, តតោ ភជនគ្ឫហេ យាវន្តោ លោកា អាសន៑ តេ សវ៌្វេៜនន្យទ្ឫឞ្ដ្យា តំ វិលុលោកិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","អនន្តរម៑ អទ្យៃតានិ សវ៌្វាណិ លិខិតវចនានិ យុឞ្មាកំ មធ្យេ សិទ្ធានិ ស ឥមាំ កថាំ តេភ្យះ កថយិតុមារេភេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","តតះ សវ៌្វេ តស្មិន៑ អន្វរជ្យន្ត, កិញ្ច តស្យ មុខាន្និគ៌តាភិរនុគ្រហស្យ កថាភិឝ្ចមត្ក្ឫត្យ កថយាមាសុះ កិមយំ យូឞផះ បុត្រោ ន? ");
INSERT INTO sankhm_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","តទា សោៜវាទីទ៑ ហេ ចិកិត្សក ស្វមេវ ស្វស្ថំ កុរុ កផន៌ាហូមិ យទ្យត៑ ក្ឫតវាន៑ តទឝ្រៅឞ្ម តាះ សវ៌ាះ ក្រិយា អត្រ ស្វទេឝេ កុរុ កថាមេតាំ យូយមេវាវឝ្យំ មាំ វទិឞ្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","បុនះ សោវាទីទ៑ យុឞ្មានហំ យថាត៌្ហំ វទាមិ, កោបិ ភវិឞ្យទ្វាទី ស្វទេឝេ សត្ការំ ន ប្រាប្នោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","អបរញ្ច យថាត៌្ហំ វច្មិ, ឯលិយស្យ ជីវនកាលេ យទា សាទ៌្ធត្រិតយវឞ៌ាណិ យាវត៑ ជលទប្រតិពន្ធាត៑ សវ៌្វស្មិន៑ ទេឝេ មហាទុព៌្ហិក្ឞម៑ អជនិឞ្ដ តទានីម៑ ឥស្រាយេលោ ទេឝស្យ មធ្យេ ពហ្វ្យោ វិធវា អាសន៑, ");
INSERT INTO sankhm_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","កិន្តុ សីទោន្ប្រទេឝីយសារិផត្បុរនិវាសិនីម៑ ឯកាំ វិធវាំ វិនា កស្យាឝ្ចិទបិ សមីបេ ឯលិយះ ប្រេរិតោ នាភូត៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","អបរញ្ច ឥលីឝាយភវិឞ្យទ្វាទិវិទ្យមានតាកាលេ ឥស្រាយេល្ទេឝេ ពហវះ កុឞ្ឋិន អាសន៑ កិន្តុ សុរីយទេឝីយំ នាមាន្កុឞ្ឋិនំ វិនា កោប្យន្យះ បរិឞ្ក្ឫតោ នាភូត៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ឥមាំ កថាំ ឝ្រុត្វា ភជនគេហស្ថិតា លោកាះ សក្រោធម៑ ឧត្ថាយ ");
INSERT INTO sankhm_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","នគរាត្តំ ពហិឞ្ក្ឫត្យ យស្យ ឝិខរិណ ឧបរិ តេឞាំ នគរំ ស្ថាបិតមាស្តេ តស្មាន្និក្ឞេប្តុំ តស្យ ឝិខរំ តំ និន្យុះ ");
INSERT INTO sankhm_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","កិន្តុ ស តេឞាំ មធ្យាទបស្ឫត្យ ស្ថានាន្តរំ ជគាម។ ");
INSERT INTO sankhm_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","តតះ បរំ យីឝុគ៌ាលីល្ប្រទេឝីយកផន៌ាហូម្នគរ ឧបស្ថាយ វិឝ្រាមវារេ លោកានុបទេឞ្ដុម៑ អារព្ធវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","តទុបទេឝាត៑ សវ៌្វេ ចមច្ចក្រុ រ្យតស្តស្យ កថា គុរុតរា អាសន៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","តទានីំ តទ្ភជនគេហស្ថិតោៜមេធ្យភូតគ្រស្ត ឯកោ ជន ឧច្ចៃះ កថយាមាស, ");
INSERT INTO sankhm_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","ហេ នាសរតីយយីឝោៜស្មាន៑ ត្យជ, ត្វយា សហាស្មាកំ កះ សម្ពន្ធះ? កិមស្មាន៑ វិនាឝយិតុមាយាសិ? ត្វមីឝ្វរស្យ បវិត្រោ ជន ឯតទហំ ជានាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","តទា យីឝុស្តំ តជ៌យិត្វាវទត៑ មៅនី ភវ ឥតោ ពហិព៌្ហវ; តតះ សោមេធ្យភូតស្តំ មធ្យស្ថានេ បាតយិត្វា កិញ្ចិទប្យហិំសិត្វា តស្មាទ៑ ពហិគ៌តវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","តតះ សវ៌្វេ លោកាឝ្ចមត្ក្ឫត្យ បរស្បរំ វក្តុមារេភិរេ កោយំ ចមត្ការះ។ ឯឞ ប្រភាវេណ បរាក្រមេណ ចាមេធ្យភូតាន៑ អាជ្ញាបយតិ តេនៃវ តេ ពហិគ៌ច្ឆន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","អនន្តរំ ចតុទ៌ិក្ស្ថទេឝាន៑ តស្យ សុខ្យាតិវ៌្យាប្នោត៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","តទនន្តរំ ស ភជនគេហាទ៑ ពហិរាគត្យ ឝិមោនោ និវេឝនំ ប្រវិវេឝ តទា តស្យ ឝ្វឝ្រូជ៌្វរេណាត្យន្តំ បីឌិតាសីត៑ ឝិឞ្យាស្តទត៌្ហំ តស្មិន៑ វិនយំ ចក្រុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","តតះ ស តស្យាះ សមីបេ ស្ថិត្វា ជ្វរំ តជ៌យាមាស តេនៃវ តាំ ជ្វរោៜត្យាក្ឞីត៑ តតះ សា តត្ក្ឞណម៑ ឧត្ថាយ តាន៑ សិឞេវេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","អថ សូយ៌្យាស្តកាលេ ស្វេឞាំ យេ យេ ជនា នានារោគៃះ បីឌិតា អាសន៑ លោកាស្តាន៑ យីឝោះ សមីបម៑ អានិន្យុះ, តទា ស ឯកៃកស្យ គាត្រេ ករមប៌យិត្វា តានរោគាន៑ ចការ។ ");
INSERT INTO sankhm_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","តតោ ភូតា ពហុភ្យោ និគ៌ត្យ ចីត្ឝព្ទំ ក្ឫត្វា ច ពភាឞិរេ ត្វមីឝ្វរស្យ បុត្រោៜភិឞិក្តត្រាតា; កិន្តុ សោភិឞិក្តត្រាតេតិ តេ វិវិទុរេតស្មាត៑ ការណាត៑ តាន៑ តជ៌យិត្វា តទ្វក្តុំ និឞិឞេធ។ ");
INSERT INTO sankhm_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","អបរញ្ច ប្រភាតេ សតិ ស វិជនស្ថានំ ប្រតស្ថេ បឝ្ចាត៑ ជនាស្តមន្វិច្ឆន្តស្តន្និកដំ គត្វា ស្ថានាន្តរគមនាត៌្ហំ តមន្វរុន្ធន៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","កិន្តុ ស តាន៑ ជគាទ, ឦឝ្វរីយរាជ្យស្យ សុសំវាទំ ប្រចារយិតុម៑ អន្យានិ បុរាណ្យបិ មយា យាតវ្យានិ យតស្តទត៌្ហមេវ ប្រេរិតោហំ។ ");
INSERT INTO sankhm_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","អថ គាលីលោ ភជនគេហេឞុ ស ឧបទិទេឝ។ ");
INSERT INTO sankhm_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","អនន្តរំ យីឝុរេកទា គិនេឞរថ្ទស្យ តីរ ឧត្តិឞ្ឋតិ, តទា លោកា ឦឝ្វរីយកថាំ ឝ្រោតុំ តទុបរិ ប្របតិតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","តទានីំ ស ហ្ទស្យ តីរសមីបេ នៅទ្វយំ ទទឝ៌ កិញ្ច មត្ស្យោបជីវិនោ នាវំ វិហាយ ជាលំ ប្រក្ឞាលយន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","តតស្តយោទ៌្វយោ រ្មធ្យេ ឝិមោនោ នាវមារុហ្យ តីរាត៑ កិញ្ចិទ្ទូរំ យាតុំ តស្មិន៑ វិនយំ ក្ឫត្វា នៅកាយាមុបវិឝ្យ លោកាន៑ ប្រោបទិឞ្ដវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","បឝ្ចាត៑ តំ ប្រស្តាវំ សមាប្យ ស ឝិមោនំ វ្យាជហារ, គភីរំ ជលំ គត្វា មត្ស្យាន៑ ធត៌្តុំ ជាលំ និក្ឞិប។ ");
INSERT INTO sankhm_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","តតះ ឝិមោន ពភាឞេ, ហេ គុរោ យទ្យបិ វយំ ក្ឫត្ស្នាំ យាមិនីំ បរិឝ្រម្យ មត្ស្យៃកមបិ ន ប្រាប្តាស្តថាបិ ភវតោ និទេឝតោ ជាលំ ក្ឞិបាមះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","អថ ជាលេ ក្ឞិប្តេ ពហុមត្ស្យបតនាទ៑ អានាយះ ប្រច្ឆិន្នះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","តស្មាទ៑ ឧបកត៌្តុម៑ អន្យនៅស្ថាន៑ សង្គិន អាយាតុម៑ ឥង្គិតេន សមាហ្វយន៑ តតស្ត អាគត្យ មត្ស្យៃ រ្នៅទ្វយំ ប្របូរយាមាសុ រ្យៃ រ្នៅទ្វយំ ប្រមគ្នម៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","តទា ឝិមោន្បិតរស្តទ៑ វិលោក្យ យីឝោឝ្ចរណយោះ បតិត្វា, ហេ ប្រភោហំ បាបី នរោ មម និកដាទ៑ ភវាន៑ យាតុ, ឥតិ កថិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","យតោ ជាលេ បតិតានាំ មត្ស្យានាំ យូថាត៑ ឝិមោន៑ តត្សង្គិនឝ្ច ចមត្ក្ឫតវន្តះ; ឝិមោនះ សហការិណៅ សិវទេះ បុត្រៅ យាកូព៑ យោហន៑ ចេមៅ តាទ្ឫឝៅ ពភូវតុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","តទា យីឝុះ ឝិមោនំ ជគាទ មា ភៃឞីរទ្យារភ្យ ត្វំ មនុឞ្យធរោ ភវិឞ្យសិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","អនន្តរំ សវ៌្វាសុ នៅសុ តីរម៑ អានីតាសុ តេ សវ៌្វាន៑ បរិត្យជ្យ តស្យ បឝ្ចាទ្គាមិនោ ពភូវុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","តតះ បរំ យីឝៅ កស្មិំឝ្ចិត៑ បុរេ តិឞ្ឋតិ ជន ឯកះ សវ៌្វាង្គកុឞ្ឋស្តំ វិលោក្យ តស្យ សមីបេ ន្យុព្ជះ បតិត្វា សវិនយំ វក្តុមារេភេ, ហេ ប្រភោ យទិ ភវានិច្ឆតិ តហ៌ិ មាំ បរិឞ្កត៌្តុំ ឝក្នោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","តទានីំ ស បាណិំ ប្រសាយ៌្យ តទង្គំ ស្ប្ឫឝន៑ ពភាឞេ ត្វំ បរិឞ្ក្រិយស្វេតិ មមេច្ឆាស្តិ តតស្តត្ក្ឞណំ ស កុឞ្ឋាត៑ មុក្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","បឝ្ចាត៑ ស តមាជ្ញាបយាមាស កថាមិមាំ កស្មៃចិទ៑ អកថយិត្វា យាជកស្យ សមីបញ្ច គត្វា ស្វំ ទឝ៌យ, លោកេភ្យោ និជបរិឞ្ក្ឫតត្វស្យ ប្រមាណទានាយ មូសាជ្ញានុសារេណ ទ្រវ្យមុត្ម្ឫជស្វ ច។ ");
INSERT INTO sankhm_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","តថាបិ យីឝោះ សុខ្យាតិ រ្ពហុ វ្យាប្តុមារេភេ កិញ្ច តស្យ កថាំ ឝ្រោតុំ ស្វីយរោគេភ្យោ មោក្តុញ្ច លោកា អាជគ្មុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","អថ ស ប្រាន្តរំ គត្វា ប្រាត៌្ហយាញ្ចក្រេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","អបរញ្ច ឯកទា យីឝុរុបទិឝតិ, ឯតហ៌ិ គាលីល្យិហូទាប្រទេឝយោះ សវ៌្វនគរេភ្យោ យិរូឝាលមឝ្ច កិយន្តះ ផិរូឝិលោកា វ្យវស្ថាបកាឝ្ច សមាគត្យ តទន្តិកេ សមុបវិវិឝុះ, តស្មិន៑ កាលេ លោកានាមារោគ្យការណាត៑ ប្រភោះ ប្រភាវះ ប្រចកាឝេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","បឝ្ចាត៑ កិយន្តោ លោកា ឯកំ បក្ឞាឃាតិនំ ខដ្វាយាំ និធាយ យីឝោះ សមីបមានេតុំ សម្មុខេ ស្ថាបយិតុញ្ច វ្យាប្រិយន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","កិន្តុ ពហុជននិវហសម្វាធាត៑ ន ឝក្នុវន្តោ គ្ឫហោបរិ គត្វា គ្ឫហប្ឫឞ្ឋំ ខនិត្វា តំ បក្ឞាឃាតិនំ សខដ្វំ គ្ឫហមធ្យេ យីឝោះ សម្មុខេ ៜវរោហយាមាសុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","តទា យីឝុស្តេឞាម៑ ឦទ្ឫឝំ វិឝ្វាសំ វិលោក្យ តំ បក្ឞាឃាតិនំ វ្យាជហារ, ហេ មានវ តវ បាបមក្ឞម្យត។ ");
INSERT INTO sankhm_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","តស្មាទ៑ អធ្យាបកាះ ផិរូឝិនឝ្ច ចិត្តៃរិត្ថំ ប្រចិន្តិតវន្តះ, ឯឞ ជន ឦឝ្វរំ និន្ទតិ កោយំ? កេវលមីឝ្វរំ វិនា បាបំ ក្ឞន្តុំ កះ ឝក្នោតិ? ");
INSERT INTO sankhm_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","តទា យីឝុស្តេឞាម៑ ឥត្ថំ ចិន្តនំ វិទិត្វា តេភ្យោកថយទ៑ យូយំ មនោភិះ កុតោ វិតក៌យថ? ");
INSERT INTO sankhm_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","តវ បាបក្ឞមា ជាតា យទ្វា ត្វមុត្ថាយ វ្រជ ឯតយោ រ្មធ្យេ កា កថា សុកថ្យា? ");
INSERT INTO sankhm_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","កិន្តុ ប្ឫថិវ្យាំ បាបំ ក្ឞន្តុំ មានវសុតស្យ សាមត៌្ហ្យមស្តីតិ យថា យូយំ ជ្ញាតុំ ឝក្នុថ តទត៌្ហំ (ស តំ បក្ឞាឃាតិនំ ជគាទ) ឧត្តិឞ្ឋ ស្វឝយ្យាំ គ្ឫហីត្វា គ្ឫហំ យាហីតិ ត្វាមាទិឝាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","តស្មាត៑ ស តត្ក្ឞណម៑ ឧត្ថាយ សវ៌្វេឞាំ សាក្ឞាត៑ និជឝយនីយំ គ្ឫហីត្វា ឦឝ្វរំ ធន្យំ វទន៑ និជនិវេឝនំ យយៅ។ ");
INSERT INTO sankhm_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","តស្មាត៑ សវ៌្វេ វិស្មយ ប្រាប្តា មនះសុ ភីតាឝ្ច វយមទ្យាសម្ភវកាយ៌្យាណ្យទឝ៌ាម ឥត្យុក្ត្វា បរមេឝ្វរំ ធន្យំ ប្រោទិតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","តតះ បរំ ពហិគ៌ច្ឆន៑ ករសញ្ចយស្ថានេ លេវិនាមានំ ករសញ្ចាយកំ ទ្ឫឞ្ដ្វា យីឝុស្តមភិទធេ មម បឝ្ចាទេហិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","តស្មាត៑ ស តត្ក្ឞណាត៑ សវ៌្វំ បរិត្យជ្យ តស្យ បឝ្ចាទិយាយ។ ");
INSERT INTO sankhm_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","អនន្តរំ លេវិ រ្និជគ្ឫហេ តទត៌្ហំ មហាភោជ្យំ ចការ, តទា តៃះ សហានេកេ ករសញ្ចាយិនស្តទន្យលោកាឝ្ច ភោក្តុមុបវិវិឝុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","តស្មាត៑ ការណាត៑ ចណ្ឌាលានាំ បាបិលោកានាញ្ច សង្គេ យូយំ កុតោ ភំគ្ធ្វេ បិវថ ចេតិ កថាំ កថយិត្វា ផិរូឝិនោៜធ្យាបកាឝ្ច តស្យ ឝិឞ្យៃះ សហ វាគ្យុទ្ធំ កត៌្តុមារេភិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","តស្មាទ៑ យីឝុស្តាន៑ ប្រត្យវោចទ៑ អរោគលោកានាំ ចិកិត្សកេន ប្រយោជនំ នាស្តិ កិន្តុ សរោគាណាមេវ។ ");
INSERT INTO sankhm_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","អហំ ធាម៌្មិកាន៑ អាហ្វាតុំ នាគតោស្មិ កិន្តុ មនះ បរាវត៌្តយិតុំ បាបិន ឯវ។ ");
INSERT INTO sankhm_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","តតស្តេ ប្រោចុះ, យោហនះ ផិរូឝិនាញ្ច ឝិឞ្យា វារំវារម៑ ឧបវសន្តិ ប្រាត៌្ហយន្តេ ច កិន្តុ តវ ឝិឞ្យាះ កុតោ ភុញ្ជតេ បិវន្តិ ច? ");
INSERT INTO sankhm_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","តទា ស តានាចខ្យៅ វរេ សង្គេ តិឞ្ឋតិ វរស្យ សខិគណំ កិមុបវាសយិតុំ ឝក្នុថ? ");
INSERT INTO sankhm_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","កិន្តុ យទា តេឞាំ និកដាទ៑ វរោ នេឞ្យតេ តទា តេ សមុបវត្ស្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","សោបរមបិ ទ្ឫឞ្ដាន្តំ កថយាម្ពភូវ បុរាតនវស្ត្រេ កោបិ នុតនវស្ត្រំ ន សីវ្យតិ យតស្តេន សេវនេន ជីណ៌វស្ត្រំ ឆិទ្យតេ, នូតនបុរាតនវស្ត្រយោ រ្មេលញ្ច ន ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","បុរាតន្យាំ កុត្វាំ កោបិ នុតនំ ទ្រាក្ឞារសំ ន និទធាតិ, យតោ នវីនទ្រាក្ឞារសស្យ តេជសា បុរាតនី កុតូ រ្វិទីយ៌្យតេ តតោ ទ្រាក្ឞារសះ បតតិ កុតូឝ្ច នឝ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","តតោ ហេតោ រ្នូតន្យាំ កុត្វាំ នវីនទ្រាក្ឞារសះ និធាតវ្យស្តេនោភយស្យ រក្ឞា ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","អបរញ្ច បុរាតនំ ទ្រាក្ឞារសំ បីត្វា កោបិ នូតនំ ន វាញ្ឆតិ, យតះ ស វក្តិ នូតនាត៑ បុរាតនម៑ ប្រឝស្តម៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","អចរញ្ច បវ៌្វណោ ទ្វិតីយទិនាត៑ បរំ ប្រថមវិឝ្រាមវារេ ឝស្យក្ឞេត្រេណ យីឝោគ៌មនកាលេ តស្យ ឝិឞ្យាះ កណិឝំ ឆិត្ត្វា ករេឞុ មទ៌្ទយិត្វា ខាទិតុមារេភិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","តស្មាត៑ កិយន្តះ ផិរូឝិនស្តានវទន៑ វិឝ្រាមវារេ យត៑ កម៌្ម ន កត៌្តវ្យំ តត៑ កុតះ កុរុថ? ");
INSERT INTO sankhm_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","យីឝុះ ប្រត្យុវាច ទាយូទ៑ តស្យ សង្គិនឝ្ច ក្ឞុធាត៌្តាះ កិំ ចក្រុះ ស កថម៑ ឦឝ្វរស្យ មន្ទិរំ ប្រវិឝ្យ ");
INSERT INTO sankhm_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","យេ ទឝ៌នីយាះ បូបា យាជកាន៑ វិនាន្យស្យ កស្យាប្យភោជនីយាស្តានានីយ ស្វយំ ពុភជេ សង្គិភ្យោបិ ទទៅ តត៑ កិំ យុឞ្មាភិះ កទាបិ នាបាឋិ? ");
INSERT INTO sankhm_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","បឝ្ចាត៑ ស តានវទត៑ មនុជសុតោ វិឝ្រាមវារស្យាបិ ប្រភុ រ្ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","អនន្តរម៑ អន្យវិឝ្រាមវារេ ស ភជនគេហំ ប្រវិឝ្យ សមុបទិឝតិ។ តទា តត្ស្ថានេ ឝុឞ្កទក្ឞិណករ ឯកះ បុមាន៑ ឧបតស្ថិវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","តស្មាទ៑ អធ្យាបកាះ ផិរូឝិនឝ្ច តស្មិន៑ ទោឞមារោបយិតុំ ស វិឝ្រាមវារេ តស្យ ស្វាស្ថ្យំ ករោតិ នវេតិ ប្រតីក្ឞិតុមារេភិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","តទា យីឝុស្តេឞាំ ចិន្តាំ វិទិត្វា តំ ឝុឞ្កករំ បុមាំសំ ប្រោវាច, ត្វមុត្ថាយ មធ្យស្ថានេ តិឞ្ឋ។ ");
INSERT INTO sankhm_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","តស្មាត៑ តស្មិន៑ ឧត្ថិតវតិ យីឝុស្តាន៑ វ្យាជហារ, យុឞ្មាន៑ ឥមាំ កថាំ ប្ឫច្ឆាមិ, វិឝ្រាមវារេ ហិតម៑ អហិតំ វា, ប្រាណរក្ឞណំ ប្រាណនាឝនំ វា, ឯតេឞាំ កិំ កម៌្មករណីយម៑? ");
INSERT INTO sankhm_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","បឝ្ចាត៑ ចតុទ៌ិក្ឞុ សវ៌្វាន៑ វិលោក្យ តំ មានវំ ពភាឞេ, និជករំ ប្រសារយ; តតស្តេន តថា ក្ឫត ឥតរករវត៑ តស្យ ហស្តះ ស្វស្ថោភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","តស្មាត៑ តេ ប្រចណ្ឌកោបាន្វិតា យីឝុំ កិំ ករិឞ្យន្តីតិ បរស្បរំ ប្រមន្ត្រិតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","តតះ បរំ ស បវ៌្វតមារុហ្យេឝ្វរមុទ្ទិឝ្យ ប្រាត៌្ហយមានះ ក្ឫត្ស្នាំ រាត្រិំ យាបិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","អថ ទិនេ សតិ ស សវ៌្វាន៑ ឝិឞ្យាន៑ អាហូតវាន៑ តេឞាំ មធ្យេ ");
INSERT INTO sankhm_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","បិតរនាម្នា ខ្យាតះ ឝិមោន៑ តស្យ ភ្រាតា អាន្ទ្រិយឝ្ច យាកូព៑ យោហន៑ ច ផិលិប៑ ពត៌្ហលមយឝ្ច ");
INSERT INTO sankhm_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","មថិះ ថោមា អាល្ផីយស្យ បុត្រោ យាកូព៑ ជ្វលន្តនាម្នា ខ្យាតះ ឝិមោន្ ");
INSERT INTO sankhm_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ច យាកូពោ ភ្រាតា យិហូទាឝ្ច តំ យះ បរករេឞុ សមប៌យិឞ្យតិ ស ឦឞ្ករីយោតីយយិហូទាឝ្ចៃតាន៑ ទ្វាទឝ ជនាន៑ មនោនីតាន៑ ក្ឫត្វា ស ជគ្រាហ តថា ប្រេរិត ឥតិ តេឞាំ នាម ចការ។ ");
INSERT INTO sankhm_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","តតះ បរំ ស តៃះ សហ បវ៌្វតាទវរុហ្យ ឧបត្យកាយាំ តស្ថៅ តតស្តស្យ ឝិឞ្យសង្ឃោ យិហូទាទេឝាទ៑ យិរូឝាលមឝ្ច សោរះ សីទោនឝ្ច ជលធេ រោធសោ ជននិហាឝ្ច ឯត្យ តស្យ កថាឝ្រវណាត៌្ហំ រោគមុក្ត្យត៌្ហញ្ច តស្យ សមីបេ តស្ថុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","អមេធ្យភូតគ្រស្តាឝ្ច តន្និកដមាគត្យ ស្វាស្ថ្យំ ប្រាបុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","សវ៌្វេឞាំ ស្វាស្ថ្យករណប្រភាវស្យ ប្រកាឝិតត្វាត៑ សវ៌្វេ លោកា ឯត្យ តំ ស្ប្រឞ្ដុំ យេតិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","បឝ្ចាត៑ ស ឝិឞ្យាន៑ ប្រតិ ទ្ឫឞ្ដិំ កុត្វា ជគាទ, ហេ ទរិទ្រា យូយំ ធន្យា យត ឦឝ្វរីយេ រាជ្យេ វោៜធិការោស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ហេ អធុនា ក្ឞុធិតលោកា យូយំ ធន្យា យតោ យូយំ តប៌្ស្យថ; ហេ ឥហ រោទិនោ ជនា យូយំ ធន្យា យតោ យូយំ ហសិឞ្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","យទា លោកា មនុឞ្យសូនោ រ្នាមហេតោ រ្យុឞ្មាន៑ ឫृតីយិឞ្យន្តេ ប្ឫថក៑ ក្ឫត្វា និន្ទិឞ្យន្តិ, អធមានិវ យុឞ្មាន៑ ស្វសមីបាទ៑ ទូរីករិឞ្យន្តិ ច តទា យូយំ ធន្យាះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ស្វគ៌េ យុឞ្មាកំ យថេឞ្ដំ ផលំ ភវិឞ្យតិ, ឯតទត៌្ហំ តស្មិន៑ ទិនេ ប្រោល្លសត អានន្ទេន ន្ឫត្យត ច, តេឞាំ បូវ៌្វបុរុឞាឝ្ច ភវិឞ្យទ្វាទិនះ ប្រតិ តថៃវ វ្យវាហរន៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","កិន្តុ ហា ហា ធនវន្តោ យូយំ សុខំ ប្រាប្នុត។ ហន្ត បរិត្ឫប្តា យូយំ ក្ឞុធិតា ភវិឞ្យថ; ");
INSERT INTO sankhm_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ឥហ ហសន្តោ យូយំ វត យុឞ្មាភិះ ឝោចិតវ្យំ រោទិតវ្យញ្ច។ ");
INSERT INTO sankhm_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","សវ៌្វៃលាកៃ រ្យុឞ្មាកំ សុខ្យាតៅ ក្ឫតាយាំ យុឞ្មាកំ ទុគ៌តិ រ្ភវិឞ្យតិ យុឞ្មាកំ បូវ៌្វបុរុឞា ម្ឫឞាភវិឞ្យទ្វាទិនះ ប្រតិ តទ្វត៑ ក្ឫតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","ហេ ឝ្រោតារោ យុឞ្មភ្យមហំ កថយាមិ, យូយំ ឝត្រុឞុ ប្រីយធ្វំ យេ ច យុឞ្មាន៑ ទ្វិឞន្តិ តេឞាមបិ ហិតំ កុរុត។ ");
INSERT INTO sankhm_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","យេ ច យុឞ្មាន៑ ឝបន្តិ តេភ្យ អាឝិឞំ ទត្ត យេ ច យុឞ្មាន៑ អវមន្យន្តេ តេឞាំ មង្គលំ ប្រាត៌្ហយធ្វំ។ ");
INSERT INTO sankhm_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","យទិ កឝ្ចិត៑ តវ កបោលេ ចបេដាឃាតំ ករោតិ តហ៌ិ តំ ប្រតិ កបោលម៑ អន្យំ បរាវត៌្ត្យ សម្មុខីកុរុ បុនឝ្ច យទិ កឝ្ចិត៑ តវ គាត្រីយវស្ត្រំ ហរតិ តហ៌ិ តំ បរិធេយវស្ត្រម៑ អបិ គ្រហីតុំ មា វារយ។ ");
INSERT INTO sankhm_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","យស្ត្វាំ យាចតេ តស្មៃ ទេហិ, យឝ្ច តវ សម្បត្តិំ ហរតិ តំ មា យាចស្វ។ ");
INSERT INTO sankhm_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","បរេភ្យះ ស្វាន៑ ប្រតិ យថាចរណម៑ អបេក្ឞធ្វេ បរាន៑ ប្រតិ យូយមបិ តថាចរត។ ");
INSERT INTO sankhm_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","យេ ជនា យុឞ្មាសុ ប្រីយន្តេ កេវលំ តេឞុ ប្រីយមាណេឞុ យុឞ្មាកំ កិំ ផលំ? បាបិលោកា អបិ ស្វេឞុ ប្រីយមាណេឞុ ប្រីយន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","យទិ ហិតការិណ ឯវ ហិតំ កុរុថ តហ៌ិ យុឞ្មាកំ កិំ ផលំ? បាបិលោកា អបិ តថា កុវ៌្វន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","យេភ្យ ឫណបរិឝោធស្យ ប្រាប្តិប្រត្យាឝាស្តេ កេវលំ តេឞុ ឫណេ សមប៌ិតេ យុឞ្មាកំ កិំ ផលំ? បុនះ ប្រាប្ត្យាឝយា បាបីលោកា អបិ បាបិជនេឞុ ឫណម៑ អប៌យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","អតោ យូយំ រិបុឞ្វបិ ប្រីយធ្វំ, បរហិតំ កុរុត ច; បុនះ ប្រាប្ត្យាឝាំ ត្យក្ត្វា ឫណមប៌យត, តថា ក្ឫតេ យុឞ្មាកំ មហាផលំ ភវិឞ្យតិ, យូយញ្ច សវ៌្វប្រធានស្យ សន្តានា ឥតិ ខ្យាតិំ ប្រាប្ស្យថ, យតោ យុឞ្មាកំ បិតា ក្ឫតឃ្នានាំ ទុវ៌្ដត្តានាញ្ច ហិតមាចរតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","អត ឯវ ស យថា ទយាលុ រ្យូយមបិ តាទ្ឫឝា ទយាលវោ ភវត។ ");
INSERT INTO sankhm_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","អបរញ្ច បរាន៑ ទោឞិណោ មា កុរុត តស្មាទ៑ យូយំ ទោឞីក្ឫតា ន ភវិឞ្យថ; អទណ្ឌ្យាន៑ មា ទណ្ឌយត តស្មាទ៑ យូយមបិ ទណ្ឌំ ន ប្រាប្ស្យថ; បរេឞាំ ទោឞាន៑ ក្ឞមធ្វំ តស្មាទ៑ យុឞ្មាកមបិ ទោឞាះ ក្ឞមិឞ្យន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","ទានានិទត្ត តស្មាទ៑ យូយំ ទានានិ ប្រាប្ស្យថ, វរញ្ច លោកាះ បរិមាណបាត្រំ ប្រទលយ្យ សញ្ចាល្យ ប្រោញ្ចាល្យ បរិបូយ៌្យ យុឞ្មាកំ ក្រោឌេឞុ សមប៌យិឞ្យន្តិ; យូយំ យេន បរិមាណេន បរិមាថ តេនៃវ បរិមាណេន យុឞ្មត្ក្ឫតេ បរិមាស្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","អថ ស តេភ្យោ ទ្ឫឞ្ដាន្តកថាមកថយត៑, អន្ធោ ជនះ កិមន្ធំ បន្ថានំ ទឝ៌យិតុំ ឝក្នោតិ? តស្មាទ៑ ឧភាវបិ កិំ គត៌្តេ ន បតិឞ្យតះ? ");
INSERT INTO sankhm_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","គុរោះ ឝិឞ្យោ ន ឝ្រេឞ្ឋះ កិន្តុ ឝិឞ្យេ សិទ្ធេ សតិ ស គុរុតុល្យោ ភវិតុំ ឝក្នោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","អបរញ្ច ត្វំ ស្វចក្ឞុुឞិ នាសាម៑ អទ្ឫឞ្ដ្វា តវ ភ្រាតុឝ្ចក្ឞុឞិ យត្ត្ឫណមស្តិ តទេវ កុតះ បឝ្យមិ? ");
INSERT INTO sankhm_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","ស្វចក្ឞុឞិ យា នាសា វិទ្យតេ តាម៑ អជ្ញាត្វា, ភ្រាតស្តវ នេត្រាត៑ ត្ឫណំ ពហិះ ករោមីតិ វាក្យំ ភ្រាតរំ កថំ វក្តុំ ឝក្នោឞិ? ហេ កបដិន៑ បូវ៌្វំ ស្វនយនាត៑ នាសាំ ពហិះ កុរុ តតោ ភ្រាតុឝ្ចក្ឞុឞស្ត្ឫណំ ពហិះ កត៌្តុំ សុទ្ឫឞ្ដិំ ប្រាប្ស្យសិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","អន្យញ្ច ឧត្តមស្តរុះ កទាបិ ផលមនុត្តមំ ន ផលតិ, អនុត្តមតរុឝ្ច ផលមុត្តមំ ន ផលតិ ការណាទតះ ផលៃស្តរវោ ជ្ញាយន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","កណ្ដកិបាទបាត៑ កោបិ ឧឌុម្ពរផលានិ ន បាតយតិ តថា ឝ្ឫគាលកោលិវ្ឫក្ឞាទបិ កោបិ ទ្រាក្ឞាផលំ ន បាតយតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","តទ្វត៑ សាធុលោកោៜន្តះករណរូបាត៑ សុភាណ្ឌាគារាទ៑ ឧត្តមានិ ទ្រវ្យាណិ ពហិះ ករោតិ, ទុឞ្ដោ លោកឝ្ចាន្តះករណរូបាត៑ កុភាណ្ឌាគារាត៑ កុត្សិតានិ ទ្រវ្យាណិ និគ៌មយតិ យតោៜន្តះករណានាំ បូណ៌ភាវានុរូបាណិ វចាំសិ មុខាន្និគ៌ច្ឆន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","អបរញ្ច មមាជ្ញានុរូបំ នាចរិត្វា កុតោ មាំ ប្រភោ ប្រភោ ឥតិ វទថ? ");
INSERT INTO sankhm_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","យះ កឝ្ចិន៑ មម និកដម៑ អាគត្យ មម កថា និឝម្យ តទនុរូបំ កម៌្ម ករោតិ ស កស្យ សទ្ឫឝោ ភវតិ តទហំ យុឞ្មាន៑ ជ្ញាाបយាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","យោ ជនោ គភីរំ ខនិត្វា បាឞាណស្ថលេ ភិត្តិំ និម៌្មាយ ស្វគ្ឫហំ រចយតិ តេន សហ តស្យោបមា ភវតិ; យត អាប្លាវិជលមេត្យ តស្យ មូលេ វេគេន វហទបិ តទ្គេហំ លាឌយិតុំ ន ឝក្នោតិ យតស្តស្យ ភិត្តិះ បាឞាណោបរិ តិឞ្ឋតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","កិន្តុ យះ កឝ្ចិន៑ មម កថាះ ឝ្រុត្វា តទនុរូបំ នាចរតិ ស ភិត្តិំ វិនា ម្ឫृទុបរិ គ្ឫហនិម៌្មាត្រា សមានោ ភវតិ; យត អាប្លាវិជលមាគត្យ វេគេន យទា វហតិ តទា តទ្គ្ឫហំ បតតិ តស្យ មហត៑ បតនំ ជាយតេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","តតះ បរំ ស លោកានាំ កណ៌គោចរេ តាន៑ សវ៌្វាន៑ ឧបទេឝាន៑ សមាប្យ យទា កផន៌ាហូម្បុរំ ប្រវិឝតិ ");
INSERT INTO sankhm_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","តទា ឝតសេនាបតេះ ប្រិយទាស ឯកោ ម្ឫតកល្បះ បីឌិត អាសីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","អតះ សេនាបតិ រ្យីឝោ រ្វាត៌្តាំ និឝម្យ ទាសស្យារោគ្យករណាយ តស្យាគមនាត៌្ហំ វិនយករណាយ យិហូទីយាន៑ កិយតះ ប្រាចះ ប្រេឞយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","តេ យីឝោរន្តិកំ គត្វា វិនយាតិឝយំ វក្តុមារេភិរេ, ស សេនាបតិ រ្ភវតោនុគ្រហំ ប្រាប្តុម៑ អហ៌តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","យតះ សោស្មជ្ជាតីយេឞុ លោកេឞុ ប្រីយតេ តថាស្មត្ក្ឫតេ ភជនគេហំ និម៌្មិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","តស្មាទ៑ យីឝុស្តៃះ សហ គត្វា និវេឝនស្យ សមីបំ ប្រាប, តទា ស ឝតសេនាបតិ រ្វក្ឞ្យមាណវាក្យំ តំ វក្តុំ ពន្ធូន៑ ប្រាហិណោត៑។ ហេ ប្រភោ ស្វយំ ឝ្រមោ ន កត៌្តវ្យោ យទ៑ ភវតា មទ្គេហមធ្យេ បាទាប៌ណំ ក្រិយេត តទប្យហំ នាហ៌ាមិ, ");
INSERT INTO sankhm_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","កិញ្ចាហំ ភវត្សមីបំ យាតុមបិ នាត្មានំ យោគ្យំ ពុទ្ធវាន៑, តតោ ភវាន៑ វាក្យមាត្រំ វទតុ តេនៃវ មម ទាសះ ស្វស្ថោ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","យស្មាទ៑ អហំ បរាធីនោបិ មមាធីនា យាះ សេនាះ សន្តិ តាសាម៑ ឯកជនំ ប្រតិ យាហីតិ មយា ប្រោក្តេ ស យាតិ; តទន្យំ ប្រតិ អាយាហីតិ ប្រោក្តេ ស អាយាតិ; តថា និជទាសំ ប្រតិ ឯតត៑ កុវ៌្វិតិ ប្រោក្តេ ស តទេវ ករោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","យីឝុរិទំ វាក្យំ ឝ្រុត្វា វិស្មយំ យយៅ, មុខំ បរាវត៌្យ បឝ្ចាទ្វត៌្តិនោ លោកាន៑ ពភាឞេ ច, យុឞ្មានហំ វទាមិ ឥស្រាយេលោ វំឝមធ្យេបិ វិឝ្វាសមីទ្ឫឝំ ន ប្រាប្នវំ។ ");
INSERT INTO sankhm_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","តតស្តេ ប្រេឞិតា គ្ឫហំ គត្វា តំ បីឌិតំ ទាសំ ស្វស្ថំ ទទ្ឫឝុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","បរេៜហនិ ស នាយីនាខ្យំ នគរំ ជគាម តស្យានេកេ ឝិឞ្យា អន្យេ ច លោកាស្តេន សាទ៌្ធំ យយុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","តេឞុ តន្នគរស្យ ទ្វារសន្និធិំ ប្រាប្តេឞុ កិយន្តោ លោកា ឯកំ ម្ឫតមនុជំ វហន្តោ នគរស្យ ពហិយ៌ាន្តិ, ស តន្មាតុរេកបុត្រស្តន្មាតា ច វិធវា; តយា សាទ៌្ធំ តន្នគរីយា ពហវោ លោកា អាសន៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ប្រភុស្តាំ វិលោក្យ សានុកម្បះ កថយាមាស, មា រោទីះ។ ស សមីបមិត្វា ខដ្វាំ បស្បឝ៌ តស្មាទ៑ វាហកាះ ស្ថគិតាស្តម្យុះ; ");
INSERT INTO sankhm_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","តទា ស ឧវាច ហេ យុវមនុឞ្យ ត្វមុត្តិឞ្ឋ, ត្វាមហម៑ អាជ្ញាបយាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","តស្មាត៑ ស ម្ឫតោ ជនស្តត្ក្ឞណមុត្ថាយ កថាំ ប្រកថិតះ; តតោ យីឝុស្តស្យ មាតរិ តំ សមប៌យាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","តស្មាត៑ សវ៌្វេ លោកាះ ឝឝង្កិរេ; ឯកោ មហាភវិឞ្យទ្វាទី មធ្យេៜស្មាកម៑ សមុទៃត៑, ឦឝ្វរឝ្ច ស្វលោកានន្វគ្ឫហ្លាត៑ កថាមិមាំ កថយិត្វា ឦឝ្វរំ ធន្យំ ជគទុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","តតះ បរំ សមស្តំ យិហូទាទេឝំ តស្យ ចតុទ៌ិក្ស្ថទេឝញ្ច តស្យៃតត្កីត៌្តិ រ្វ្យានឝេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","តតះ បរំ យោហនះ ឝិឞ្យេឞុ តំ តទ្វ្ឫត្តាន្តំ ជ្ញាបិតវត្សុ ");
INSERT INTO sankhm_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ស ស្វឝិឞ្យាណាំ ទ្វៅ ជនាវាហូយ យីឝុំ ប្រតិ វក្ឞ្យមាណំ វាក្យំ វក្តុំ ប្រេឞយាមាស, យស្យាគមនម៑ អបេក្ឞ្យ តិឞ្ឋាមោ វយំ កិំ ស ឯវ ជនស្ត្វំ? កិំ វយមន្យមបេក្ឞ្យ ស្ថាស្យាមះ? ");
INSERT INTO sankhm_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","បឝ្ចាត្តៅ មានវៅ គត្វា កថយាមាសតុះ, យស្យាគមនម៑ អបេក្ឞ្យ តិឞ្ឋាមោ វយំ, កិំ សឯវ ជនស្ត្វំ? កិំ វយមន្យមបេក្ឞ្យ ស្ថាស្យាមះ? កថាមិមាំ តុភ្យំ កថយិតុំ យោហន៑ មជ្ជក អាវាំ ប្រេឞិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","តស្មិន៑ ទណ្ឌេ យីឝូរោគិណោ មហាវ្យាធិមតោ ទុឞ្ដភូតគ្រស្តាំឝ្ច ពហូន៑ ស្វស្ថាន៑ ក្ឫត្វា, អនេកាន្ធេភ្យឝ្ចក្ឞុំឞិ ទត្ត្វា ប្រត្យុវាច, ");
INSERT INTO sankhm_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","យុវាំ វ្រជតម៑ អន្ធា នេត្រាណិ ខញ្ជាឝ្ចរណានិ ច ប្រាប្នុវន្តិ, កុឞ្ឋិនះ បរិឞ្ក្រិយន្តេ, ពធិរាះ ឝ្រវណានិ ម្ឫតាឝ្ច ជីវនានិ ប្រាប្នុវន្តិ, ទរិទ្រាណាំ សមីបេឞុ សុសំវាទះ ប្រចាយ៌្យតេ, យំ ប្រតិ វិឃ្នស្វរូបោហំ ន ភវាមិ ស ធន្យះ, ");
INSERT INTO sankhm_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ឯតានិ យានិ បឝ្យថះ ឝ្ឫណុថឝ្ច តានិ យោហនំ ជ្ញាបយតម៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","តយោ រ្ទូតយោ រ្គតយោះ សតោ រ្យោហនិ ស លោកាន៑ វក្តុមុបចក្រមេ, យូយំ មធ្យេប្រាន្តរំ កិំ ទ្រឞ្ដុំ និរគមត? កិំ វាយុនា កម្បិតំ នឌំ? ");
INSERT INTO sankhm_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","យូយំ កិំ ទ្រឞ្ដុំ និរគមត? កិំ សូក្ឞ្មវស្ត្របរិធាយិនំ កមបិ នរំ? កិន្តុ យេ សូក្ឞ្មម្ឫទុវស្ត្រាណិ បរិទធតិ សូត្តមានិ ទ្រវ្យាណិ ភុញ្ជតេ ច តេ រាជធានីឞុ តិឞ្ឋន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","តហ៌ិ យូយំ កិំ ទ្រឞ្ដុំ និរគមត? កិមេកំ ភវិឞ្យទ្វាទិនំ? តទេវ សត្យំ កិន្តុ ស បុមាន៑ ភវិឞ្យទ្វាទិនោបិ ឝ្រេឞ្ឋ ឥត្យហំ យុឞ្មាន៑ វទាមិ; ");
INSERT INTO sankhm_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","បឝ្យ ស្វកីយទូតន្តុ តវាគ្រ ប្រេឞយាម្យហំ។ គត្វា ត្វទីយមាគ៌ន្តុ ស ហិ បរិឞ្ករិឞ្យតិ។ យទត៌្ហេ លិបិរិយម៑ អាស្តេ ស ឯវ យោហន៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","អតោ យុឞ្មានហំ វទាមិ ស្ត្រិយា គព៌្ភជាតានាំ ភវិឞ្យទ្វាទិនាំ មធ្យេ យោហនោ មជ្ជកាត៑ ឝ្រេឞ្ឋះ កោបិ នាស្តិ, តត្រាបិ ឦឝ្វរស្យ រាជ្យេ យះ សវ៌្វស្មាត៑ ក្ឞុទ្រះ ស យោហនោបិ ឝ្រេឞ្ឋះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","អបរញ្ច សវ៌្វេ លោកាះ ករមញ្ចាយិនឝ្ច តស្យ វាក្យានិ ឝ្រុត្វា យោហនា មជ្ជនេន មជ្ជិតាះ បរមេឝ្វរំ និទ៌ោឞំ មេនិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","កិន្តុ ផិរូឝិនោ វ្យវស្ថាបកាឝ្ច តេន ន មជ្ជិតាះ ស្វាន៑ ប្រតីឝ្វរស្យោបទេឝំ និឞ្ផលម៑ អកុវ៌្វន៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","អថ ប្រភុះ កថយាមាស, ឥទានីន្តនជនាន៑ កេនោបមាមិ? តេ កស្យ សទ្ឫឝាះ? ");
INSERT INTO sankhm_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","យេ ពាលកា វិបណ្យាម៑ ឧបវិឝ្យ បរស្បរម៑ អាហូយ វាក្យមិទំ វទន្តិ, វយំ យុឞ្មាកំ និកដេ វំឝីរវាទិឞ្ម, កិន្តុ យូយំ នានត៌្តិឞ្ដ, វយំ យុឞ្មាកំ និកដ អរោទិឞ្ម, កិន្តុ យុយំ ន វ្យលបិឞ្ដ, ពាលកៃរេតាទ្ឫឝៃស្តេឞាម៑ ឧបមា ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","យតោ យោហន៑ មជ្ជក អាគត្យ បូបំ នាខាទត៑ ទ្រាក្ឞារសញ្ច នាបិវត៑ តស្មាទ៑ យូយំ វទថ, ភូតគ្រស្តោយម៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","តតះ បរំ មានវសុត អាគត្យាខាទទបិវញ្ច តស្មាទ៑ យូយំ វទថ, ខាទកះ សុរាបឝ្ចាណ្ឌាលបាបិនាំ ពន្ធុរេកោ ជនោ ទ្ឫឝ្យតាម៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","កិន្តុ ជ្ញានិនោ ជ្ញានំ និទ៌ោឞំ វិទុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","បឝ្ចាទេកះ ផិរូឝី យីឝុំ ភោជនាយ ន្យមន្ត្រយត៑ តតះ ស តស្យ គ្ឫហំ គត្វា ភោក្តុមុបវិឞ្ដះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ឯតហ៌ិ តត្ផិរូឝិនោ គ្ឫហេ យីឝុ រ្ភេក្តុម៑ ឧបាវេក្ឞីត៑ តច្ឆ្រុត្វា តន្នគរវាសិនី កាបិ ទុឞ្ដា នារី បាណ្ឌរប្រស្តរស្យ សម្បុដកេ សុគន្ធិតៃលម៑ អានីយ ");
INSERT INTO sankhm_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","តស្យ បឝ្ចាត៑ បាទយោះ សន្និធៅ តស្យៅ រុទតី ច នេត្រាម្ពុភិស្តស្យ ចរណៅ ប្រក្ឞាល្យ និជកចៃរមាក៌្ឞីត៑, តតស្តស្យ ចរណៅ ចុម្ពិត្វា តេន សុគន្ធិតៃលេន មមទ៌។ ");
INSERT INTO sankhm_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","តស្មាត៑ ស និមន្ត្រយិតា ផិរូឝី មនសា ចិន្តយាមាស, យទ្យយំ ភវិឞ្យទ្វាទី ភវេត៑ តហ៌ិ ឯនំ ស្ប្ឫឝតិ យា ស្ត្រី សា កា កីទ្ឫឝី ចេតិ ជ្ញាតុំ ឝក្នុយាត៑ យតះ សា ទុឞ្ដា។ ");
INSERT INTO sankhm_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","តទា យាឝុស្តំ ជគាទ, ហេ ឝិមោន៑ ត្វាំ ប្រតិ មម កិញ្ចិទ៑ វក្តវ្យមស្តិ; តស្មាត៑ ស ពភាឞេ, ហេ គុរោ តទ៑ វទតុ។ ");
INSERT INTO sankhm_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ឯកោត្តមណ៌ស្យ ទ្វាវធមណ៌ាវាស្តាំ, តយោរេកះ បញ្ចឝតានិ មុទ្រាបាទាន៑ អបរឝ្ច បញ្ចាឝត៑ មុទ្រាបាទាន៑ ធារយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","តទនន្តរំ តយោះ ឝោធ្យាភាវាត៑ ស ឧត្តមណ៌ស្តយោ រ្ឫណេ ចក្ឞមេ; តស្មាត៑ តយោទ៌្វយោះ កស្តស្មិន៑ ប្រេឞ្យតេ ពហុ? តទ៑ ព្រូហិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ឝិមោន៑ ប្រត្យុវាច, មយា ពុធ្យតេ យស្យាធិកម៑ ឫណំ ចក្ឞមេ ស ឥតិ; តតោ យីឝុស្តំ វ្យាជហារ, ត្វំ យថាត៌្ហំ វ្យចារយះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","អថ តាំ នារីំ ប្រតិ វ្យាឃុឋ្យ ឝិមោនមវោចត៑, ស្ត្រីមិមាំ បឝ្យសិ? តវ គ្ឫហេ មយ្យាគតេ ត្វំ បាទប្រក្ឞាលនាត៌្ហំ ជលំ នាទាះ កិន្តុ យោឞិទេឞា នយនជលៃ រ្មម បាទៅ ប្រក្ឞាល្យ កេឝៃរមាក៌្ឞីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ត្វំ មាំ នាចុម្ពីះ កិន្តុ យោឞិទេឞា ស្វីយាគមនាទារភ្យ មទីយបាទៅ ចុម្ពិតុំ ន វ្យរំស្ត។ ");
INSERT INTO sankhm_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ត្វញ្ច មទីយោត្តមាង្គេ កិញ្ចិទបិ តៃលំ នាមទ៌ីះ កិន្តុ យោឞិទេឞា មម ចរណៅ សុគន្ធិតៃលេនាមទ៌្ទីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","អតស្ត្វាំ វ្យាហរាមិ, ឯតស្យា ពហុ បាបមក្ឞម្យត តតោ ពហុ ប្រីយតេ កិន្តុ យស្យាល្បបាបំ ក្ឞម្យតេ សោល្បំ ប្រីយតេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","តតះ បរំ ស តាំ ពភាឞេ, ត្វទីយំ បាបមក្ឞម្យត។ ");
INSERT INTO sankhm_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","តទា តេន សាទ៌្ធំ យេ ភោក្តុម៑ ឧបវិវិឝុស្តេ បរស្បរំ វក្តុមារេភិរេ, អយំ បាបំ ក្ឞមតេ ក ឯឞះ? ");
INSERT INTO sankhm_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","កិន្តុ ស តាំ នារីំ ជគាទ, តវ វិឝ្វាសស្ត្វាំ បយ៌្យត្រាស្ត ត្វំ ក្ឞេមេណ វ្រជ។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","អបរញ្ច យីឝុ រ្ទ្វាទឝភិះ ឝិឞ្យៃះ សាទ៌្ធំ នានានគរេឞុ នានាគ្រាមេឞុ ច គច្ឆន៑ ឥឝ្វរីយរាជត្វស្យ សុសំវាទំ ប្រចារយិតុំ ប្រារេភេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","តទា យស្យាះ សប្ត ភូតា និរគច្ឆន៑ សា មគ្ទលីនីតិ វិខ្យាតា មរិយម៑ ហេរោទ្រាជស្យ គ្ឫហាធិបតេះ ហោឞេ រ្ភាយ៌្យា យោហនា ឝូឝានា ");
INSERT INTO sankhm_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ប្រភ្ឫតយោ យា ពហ្វ្យះ ស្ត្រិយះ ទុឞ្ដភូតេភ្យោ រោគេភ្យឝ្ច មុក្តាះ សត្យោ និជវិភូតី រ្វ្យយិត្វា តមសេវន្ត, តាះ សវ៌្វាស្តេន សាទ៌្ធម៑ អាសន៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","អនន្តរំ នានានគរេភ្យោ ពហវោ លោកា អាគត្យ តស្យ សមីបេៜមិលន៑, តទា ស តេភ្យ ឯកាំ ទ្ឫឞ្ដាន្តកថាំ កថយាមាស។ ឯកះ ក្ឫឞីពលោ ពីជានិ វប្តុំ ពហិជ៌គាម, ");
INSERT INTO sankhm_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","តតោ វបនកាលេ កតិបយានិ ពីជានិ មាគ៌បាឝ៌្វេ បេតុះ, តតស្តានិ បទតលៃ រ្ទលិតានិ បក្ឞិភិ រ្ភក្ឞិតានិ ច។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","កតិបយានិ ពីជានិ បាឞាណស្ថលេ បតិតានិ យទ្យបិ តាន្យង្កុរិតានិ តថាបិ រសាភាវាត៑ ឝុឝុឞុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","កតិបយានិ ពីជានិ កណ្ដកិវនមធ្យេ បតិតានិ តតះ កណ្ដកិវនានិ សំវ្ឫទ្ធ្យ តានិ ជគ្រសុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","តទន្យានិ កតិបយពីជានិ ច ភូម្យាមុត្តមាយាំ បេតុស្តតស្តាន្យង្កុរយិត្វា ឝតគុណានិ ផលានិ ផេលុះ។ ស ឥមា កថាំ កថយិត្វា ប្រោច្ចៃះ ប្រោវាច, យស្យ ឝ្រោតុំ ឝ្រោត្រេ ស្តះ ស ឝ្ឫណោតុ។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","តតះ បរំ ឝិឞ្យាស្តំ បប្រច្ឆុរស្យ ទ្ឫឞ្ដាន្តស្យ កិំ តាត្បយ៌្យំ? ");
INSERT INTO sankhm_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","តតះ ស វ្យាជហារ, ឦឝ្វរីយរាជ្យស្យ គុហ្យានិ ជ្ញាតុំ យុឞ្មភ្យមធិការោ ទីយតេ កិន្ត្វន្យេ យថា ទ្ឫឞ្ដ្វាបិ ន បឝ្យន្តិ ឝ្រុត្វាបិ ម ពុធ្យន្តេ ច តទត៌្ហំ តេឞាំ បុរស្តាត៑ តាះ សវ៌្វាះ កថា ទ្ឫឞ្ដាន្តេន កថ្យន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","ទ្ឫឞ្ដាន្តស្យាស្យាភិប្រាយះ, ឦឝ្វរីយកថា ពីជស្វរូបា។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","យេ កថាមាត្រំ ឝ្ឫណ្វន្តិ កិន្តុ បឝ្ចាទ៑ វិឝ្វស្យ យថា បរិត្រាណំ ន ប្រាប្នុវន្តិ តទាឝយេន ឝៃតានេត្យ ហ្ឫទយាត្ឫ តាំ កថាម៑ អបហរតិ ត ឯវ មាគ៌បាឝ៌្វស្ថភូមិស្វរូបាះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","យេ កថំ ឝ្រុត្វា សានន្ទំ គ្ឫហ្លន្តិ កិន្ត្វពទ្ធមូលត្វាត៑ ស្វល្បកាលមាត្រំ ប្រតីត្យ បរីក្ឞាកាលេ ភ្រឝ្យន្តិ តឯវ បាឞាណភូមិស្វរូបាះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","យេ កថាំ ឝ្រុត្វា យាន្តិ វិឞយចិន្តាយាំ ធនលោភេន ឯेហិកសុខេ ច មជ្ជន្ត ឧបយុក្តផលានិ ន ផលន្តិ ត ឯវោប្តពីជកណ្ដកិភូស្វរូបាះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","កិន្តុ យេ ឝ្រុត្វា សរលៃះ ឝុទ្ធៃឝ្ចាន្តះករណៃះ កថាំ គ្ឫហ្លន្តិ ធៃយ៌្យម៑ អវលម្ព្យ ផលាន្យុត្បាទយន្តិ ច ត ឯវោត្តមម្ឫត្ស្វរូបាះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","អបរញ្ច ប្រទីបំ ប្រជ្វាល្យ កោបិ បាត្រេណ នាច្ឆាទយតិ តថា ខដ្វាធោបិ ន ស្ថាបយតិ, កិន្តុ ទីបាធារោបយ៌្យេវ ស្ថាបយតិ, តស្មាត៑ ប្រវេឝកា ទីប្តិំ បឝ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","យន្ន ប្រកាឝយិឞ្យតេ តាទ្ឫគ៑ អប្រកាឝិតំ វស្តុ កិមបិ នាស្តិ យច្ច ន សុវ្យក្តំ ប្រចារយិឞ្យតេ តាទ្ឫគ៑ គ្ឫប្តំ វស្តុ កិមបិ នាស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","អតោ យូយំ កេន ប្រការេណ ឝ្ឫណុថ តត្រ សាវធានា ភវត, យស្យ សមីបេ ពទ៌្ធតេ តស្មៃ បុនទ៌ាស្យតេ កិន្តុ យស្យាឝ្រយេ ន ពទ៌្ធតេ តស្យ យទ្យទស្តិ តទបិ តស្មាត៑ នេឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","អបរញ្ច យីឝោ រ្មាតា ភ្រាតរឝ្ច តស្យ សមីបំ ជិគមិឞវះ ");
INSERT INTO sankhm_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","កិន្តុ ជនតាសម្ពាធាត៑ តត្សន្និធិំ ប្រាប្តុំ ន ឝេកុះ។ តត្បឝ្ចាត៑ តវ មាតា ភ្រាតរឝ្ច ត្វាំ សាក្ឞាត៑ ចិកីឞ៌ន្តោ ពហិស្តិឞ្ឋនតីតិ វាត៌្តាយាំ តស្មៃ កថិតាយាំ ");
INSERT INTO sankhm_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ស ប្រត្យុវាច; យេ ជនា ឦឝ្វរស្យ កថាំ ឝ្រុត្វា តទនុរូបមាចរន្តិ តឯវ មម មាតា ភ្រាតរឝ្ច។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","អនន្តរំ ឯកទា យីឝុះ ឝិឞ្យៃះ សាទ៌្ធំ នាវមារុហ្យ ជគាទ, អាយាត វយំ ហ្រទស្យ បារំ យាមះ, តតស្តេ ជគ្មុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","តេឞុ នៅកាំ វាហយត្សុ ស និទទ្រៅ; ");
INSERT INTO sankhm_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","អថាកស្មាត៑ ប្រពលឈញ្ភ្ឝគមាទ៑ ហ្រទេ នៅកាយាំ តរង្គៃរាច្ឆន្នាយាំ វិបត៑ តាន៑ ជគ្រាស។ តស្មាទ៑ យីឝោរន្តិកំ គត្វា ហេ គុរោ ហេ គុរោ ប្រាណា នោ យាន្តីតិ គទិត្វា តំ ជាគរយាម្ពភូវុះ។ តទា ស ឧត្ថាយ វាយុំ តរង្គាំឝ្ច តជ៌យាមាស តស្មាទុភៅ និវ្ឫត្យ ស្ថិរៅ ពភូវតុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ស តាន៑ ពភាឞេ យុឞ្មាកំ វិឝ្វាសះ ក? តស្មាត្តេ ភីតា វិស្មិតាឝ្ច បរស្បរំ ជគទុះ, អហោ កីទ្ឫគយំ មនុជះ បវនំ បានីយញ្ចាទិឝតិ តទុភយំ តទាទេឝំ វហតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","តតះ បរំ គាលីល្ប្រទេឝស្យ សម្មុខស្ថគិទេរីយប្រទេឝេ នៅកាយាំ លគន្ត្យាំ តដេៜវរោហមាវាទ្ ");
INSERT INTO sankhm_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ពហុតិថកាលំ ភូតគ្រស្ត ឯកោ មានុឞះ បុរាទាគត្យ តំ សាក្ឞាច្ចការ។ ស មនុឞោ វាសោ ន បរិទធត៑ គ្ឫហេ ច ន វសន៑ កេវលំ ឝ្មឝានម៑ អធ្យុវាស។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ស យីឝុំ ទ្ឫឞ្ដ្វៃវ ចីច្ឆព្ទំ ចការ តស្យ សម្មុខេ បតិត្វា ប្រោច្ចៃជ៌គាទ ច, ហេ សវ៌្វប្រធានេឝ្វរស្យ បុត្រ, មយា សហ តវ កះ សម្ពន្ធះ? ត្វយិ វិនយំ ករោមិ មាំ មា យាតយ។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","យតះ ស តំ មានុឞំ ត្យក្ត្វា យាតុម៑ អមេធ្យភូតម៑ អាទិទេឝ; ស ភូតស្តំ មានុឞម៑ អសក្ឫទ៑ ទធារ តស្មាល្លោកាះ ឝ្ឫង្ខលេន និគឌេន ច ពពន្ធុះ; ស តទ៑ ភំក្ត្វា ភូតវឝត្វាត៑ មធ្យេប្រាន្តរំ យយៅ។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","អនន្តរំ យីឝុស្តំ បប្រច្ឆ តវ កិន្នាម? ស ឧវាច, មម នាម ពាហិនោ យតោ ពហវោ ភូតាស្តមាឝិឝ្រិយុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","អថ ភូតា វិនយេន ជគទុះ, គភីរំ គត៌្តំ គន្តុំ មាជ្ញាបយាស្មាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","តទា បវ៌្វតោបរិ វរាហវ្រជឝ្ចរតិ តស្មាទ៑ ភូតា វិនយេន ប្រោចុះ, អមុំ វរាហវ្រជម៑ អាឝ្រយិតុម៑ អស្មាន៑ អនុជានីហិ; តតះ សោនុជជ្ញៅ។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","តតះ បរំ ភូតាស្តំ មានុឞំ វិហាយ វរាហវ្រជម៑ អាឝិឝ្រិយុះ វរាហវ្រជាឝ្ច តត្ក្ឞណាត៑ កដកេន ធាវន្តោ ហ្រទេ ប្រាណាន៑ វិជ្ឫហុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","តទ៑ ទ្ឫឞ្ដ្វា ឝូកររក្ឞកាះ បលាយមានា នគរំ គ្រាមញ្ច គត្វា តត្សវ៌្វវ្ឫត្តាន្តំ កថយាមាសុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","តតះ កិំ វ្ឫត្តម៑ ឯតទ្ទឝ៌នាត៌្ហំ លោកា និគ៌ត្យ យីឝោះ សមីបំ យយុះ, តំ មានុឞំ ត្យក្តភូតំ បរិហិតវស្ត្រំ ស្វស្ថមានុឞវទ៑ យីឝោឝ្ចរណសន្និធៅ សូបវិឝន្តំ វិលោក្យ ពិភ្យុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","យេ លោកាស្តស្យ ភូតគ្រស្តស្យ ស្វាស្ថ្យករណំ ទទ្ឫឝុស្តេ តេភ្យះ សវ៌្វវ្ឫត្តាន្តំ កថយាមាសុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","តទនន្តរំ តស្យ គិទេរីយប្រទេឝស្យ ចតុទ៌ិក្ស្ថា ពហវោ ជនា អតិត្រស្តា វិនយេន តំ ជគទុះ, ភវាន៑ អស្មាកំ និកដាទ៑ វ្រជតុ តស្មាត៑ ស នាវមារុហ្យ តតោ វ្យាឃុដ្យ ជគាម។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","តទានីំ ត្យក្តភូតមនុជស្តេន សហ ស្ថាតុំ ប្រាត៌្ហយាញ្ចក្រេ ");
INSERT INTO sankhm_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","កិន្តុ តទត៌្ហម៑ ឦឝ្វរះ កីទ្ឫង្មហាកម៌្ម ក្ឫតវាន៑ ឥតិ និវេឝនំ គត្វា វិជ្ញាបយ, យីឝុះ កថាមេតាំ កថយិត្វា តំ វិសសជ៌។ តតះ ស វ្រជិត្វា យីឝុស្តទត៌្ហំ យន្មហាកម៌្ម ចការ តត៑ បុរស្យ សវ៌្វត្រ ប្រកាឝយិតុំ ប្រារេភេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","អថ យីឝៅ បរាវ្ឫត្យាគតេ លោកាស្តំ អាទរេណ ជគ្ឫហុ រ្យស្មាត្តេ សវ៌្វេ តមបេក្ឞាញ្ចក្រិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","តទនន្តរំ យាយីន៌ាម្នោ ភជនគេហស្យៃកោធិប អាគត្យ យីឝោឝ្ចរណយោះ បតិត្វា ស្វនិវេឝនាគមនាត៌្ហំ តស្មិន៑ វិនយំ ចការ, ");
INSERT INTO sankhm_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","យតស្តស្យ ទ្វាទឝវឞ៌វយស្កា កន្យៃកាសីត៑ សា ម្ឫតកល្បាភវត៑។ តតស្តស្យ គមនកាលេ មាគ៌េ លោកានាំ មហាន៑ សមាគមោ ពភូវ។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ទ្វាទឝវឞ៌ាណិ ប្រទររោគគ្រស្តា នានា វៃទ្យៃឝ្ចិកិត្សិតា សវ៌្វស្វំ វ្យយិត្វាបិ ស្វាស្ថ្យំ ន ប្រាប្តា យា យោឞិត៑ សា យីឝោះ បឝ្ចាទាគត្យ តស្យ វស្ត្រគ្រន្ថិំ បស្បឝ៌។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","តស្មាត៑ តត្ក្ឞណាត៑ តស្យា រក្តស្រាវោ រុទ្ធះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","តទានីំ យីឝុរវទត៑ កេនាហំ ស្ប្ឫឞ្ដះ? តតោៜនេកៃរនង្គីក្ឫតេ បិតរស្តស្យ សង្គិនឝ្ចាវទន៑, ហេ គុរោ លោកា និកដស្ថាះ សន្តស្តវ ទេហេ ឃឞ៌យន្តិ, តថាបិ កេនាហំ ស្ប្ឫឞ្ដឥតិ ភវាន៑ កុតះ ប្ឫច្ឆតិ? ");
INSERT INTO sankhm_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","យីឝុះ កថយាមាស, កេនាប្យហំ ស្ប្ឫឞ្ដោ, យតោ មត្តះ ឝក្តិ រ្និគ៌តេតិ មយា និឝ្ចិតមជ្ញាយិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","តទា សា នារី ស្វយំ ន គុប្តេតិ វិទិត្វា កម្បមានា សតី តស្យ សម្មុខេ បបាត; យេន និមិត្តេន តំ បស្បឝ៌ ស្បឝ៌មាត្រាច្ច យេន ប្រការេណ ស្វស្ថាភវត៑ តត៑ សវ៌្វំ តស្យ សាក្ឞាទាចខ្យៅ។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","តតះ ស តាំ ជគាទ ហេ កន្យេ សុស្ថិរា ភវ, តវ វិឝ្វាសស្ត្វាំ ស្វស្ថាម៑ អកាឞ៌ីត៑ ត្វំ ក្ឞេមេណ យាហិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","យីឝោរេតទ្វាក្យវទនកាលេ តស្យាធិបតេ រ្និវេឝនាត៑ កឝ្ចិល្លោក អាគត្យ តំ ពភាឞេ, តវ កន្យា ម្ឫតា គុរុំ មា ក្លិឝាន។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","កិន្តុ យីឝុស្តទាកណ៌្យាធិបតិំ វ្យាជហារ, មា ភៃឞីះ កេវលំ វិឝ្វសិហិ តស្មាត៑ សា ជីវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","អថ តស្យ និវេឝនេ ប្រាប្តេ ស បិតរំ យោហនំ យាកូពញ្ច កន្យាយា មាតរំ បិតរញ្ច វិនា, អន្យំ កញ្ចន ប្រវេឞ្ដុំ វារយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","អបរញ្ច យេ រុទន្តិ វិលបន្តិ ច តាន៑ សវ៌្វាន៑ ជនាន៑ ឧវាច, យូយំ មា រោទិឞ្ដ កន្យា ន ម្ឫតា និទ្រាតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","កិន្តុ សា និឝ្ចិតំ ម្ឫតេតិ ជ្ញាត្វា តេ តមុបជហសុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","បឝ្ចាត៑ ស សវ៌្វាន៑ ពហិះ ក្ឫត្វា កន្យាយាះ ករៅ ធ្ឫត្វាជុហុវេ, ហេ កន្យេ ត្វមុត្តិឞ្ឋ, ");
INSERT INTO sankhm_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","តស្មាត៑ តស្យាះ ប្រាណេឞុ បុនរាគតេឞុ សា តត្ក្ឞណាទ៑ ឧត្តស្យៅ។ តទានីំ តស្យៃ កិញ្ចិទ៑ ភក្ឞ្យំ ទាតុម៑ អាទិទេឝ។ ");
INSERT INTO sankhm_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","តតស្តស្យាះ បិតរៅ វិស្មយំ គតៅ កិន្តុ ស តាវាទិទេឝ ឃដនាយា ឯតស្យាះ កថាំ កស្មៃចិទបិ មា កថយតំ។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","តតះ បរំ ស ទ្វាទឝឝិឞ្យានាហូយ ភូតាន៑ ត្យាជយិតុំ រោគាន៑ ប្រតិកត៌្តុញ្ច តេភ្យះ ឝក្តិមាធិបត្យញ្ច ទទៅ។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","អបរញ្ច ឦឝ្វរីយរាជ្យស្យ សុសំវាទំ ប្រកាឝយិតុម៑ រោគិណាមារោគ្យំ កត៌្តុញ្ច ប្រេរណកាលេ តាន៑ ជគាទ។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","យាត្រាត៌្ហំ យឞ្ដិ រ្វស្ត្របុដកំ ភក្ឞ្យំ មុទ្រា ទ្វិតីយវស្ត្រម៑, ឯឞាំ កិមបិ មា គ្ឫហ្លីត។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","យូយញ្ច យន្និវេឝនំ ប្រវិឝថ នគរត្យាគបយ៌្យនតំ តន្និវេឝនេ តិឞ្ឋត។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","តត្រ យទិ កស្យចិត៑ បុរស្យ លោកា យុឞ្មាកមាតិថ្យំ ន កុវ៌្វន្តិ តហ៌ិ តស្មាន្នគរាទ៑ គមនកាលេ តេឞាំ វិរុទ្ធំ សាក្ឞ្យាត៌្ហំ យុឞ្មាកំ បទធូលីះ សម្បាតយត។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","អថ តេ ប្រស្ថាយ សវ៌្វត្រ សុសំវាទំ ប្រចារយិតុំ បីឌិតាន៑ ស្វស្ថាន៑ កត៌្តុញ្ច គ្រាមេឞុ ភ្រមិតុំ ប្រារេភិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ឯតហ៌ិ ហេរោទ៑ រាជា យីឝោះ សវ៌្វកម៌្មណាំ វាត៌្តាំ ឝ្រុត្វា ភ្ឫឝមុទ្វិវិជេ ");
INSERT INTO sankhm_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","យតះ កេចិទូចុយ៌ោហន៑ ឝ្មឝានាទុទតិឞ្ឋត៑។ កេចិទូចុះ, ឯលិយោ ទឝ៌នំ ទត្តវាន៑; ឯវមន្យលោកា ឩចុះ បូវ៌្វីយះ កឝ្ចិទ៑ ភវិឞ្យទ្វាទី សមុត្ថិតះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","កិន្តុ ហេរោទុវាច យោហនះ ឝិរោៜហមឆិនទម៑ ឥទានីំ យស្យេទ្ឫក្កម៌្មណាំ វាត៌្តាំ ប្រាប្នោមិ ស កះ? អថ ស តំ ទ្រឞ្ដុម៑ ឰច្ឆត៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","អនន្តរំ ប្រេរិតាះ ប្រត្យាគត្យ យានិ យានិ កម៌្មាណិ ចក្រុស្តានិ យីឝវេ កថយាមាសុះ តតះ ស តាន៑ ពៃត្សៃទានាមកនគរស្យ វិជនំ ស្ថានំ នីត្វា គុប្តំ ជគាម។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","បឝ្ចាល៑ លោកាស្តទ៑ វិទិត្វា តស្យ បឝ្ចាទ៑ យយុះ; តតះ ស តាន៑ នយន៑ ឦឝ្វរីយរាជ្យស្យ ប្រសង្គមុក្តវាន៑, យេឞាំ ចិកិត្សយា ប្រយោជនម៑ អាសីត៑ តាន៑ ស្វស្ថាន៑ ចការ ច។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","អបរញ្ច ទិវាវសន្នេ សតិ ទ្វាទឝឝិឞ្យា យីឝោរន្តិកម៑ ឯត្យ កថយាមាសុះ, វយមត្រ ប្រាន្តរស្ថានេ តិឞ្ឋាមះ, តតោ នគរាណិ គ្រាមាណិ គត្វា វាសស្ថានានិ ប្រាប្យ ភក្ឞ្យទ្រវ្យាណិ ក្រេតុំ ជននិវហំ ភវាន៑ វិស្ឫជតុ។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","តទា ស ឧវាច, យូយមេវ តាន៑ ភេជយធ្វំ; តតស្តេ ប្រោចុរស្មាកំ និកដេ កេវលំ បញ្ច បូបា ទ្វៅ មត្ស្យៅ ច វិទ្យន្តេ, អតឯវ ស្ថានាន្តរម៑ ឥត្វា និមិត្តមេតេឞាំ ភក្ឞ្យទ្រវ្យេឞុ ន ក្រីតេឞុ ន ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","តត្រ ប្រាយេណ បញ្ចសហស្រាណិ បុរុឞា អាសន៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","តទា ស ឝិឞ្យាន៑ ជគាទ បញ្ចាឝត៑ បញ្ចាឝជ្ជនៃះ បំក្តីក្ឫត្យ តានុបវេឝយត, តស្មាត៑ តេ តទនុសារេណ សវ៌្វលោកានុបវេឝយាបាសុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","តតះ ស តាន៑ បញ្ច បូបាន៑ មីនទ្វយញ្ច គ្ឫហីត្វា ស្វគ៌ំ វិលោក្យេឝ្វរគុណាន៑ កីត៌្តយាញ្ចក្រេ ភង្ក្តា ច លោកេភ្យះ បរិវេឞណាត៌្ហំ ឝិឞ្យេឞុ សមប៌យាម្ពភូវ។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","តតះ សវ៌្វេ ភុក្ត្វា ត្ឫប្តិំ គតា អវឝិឞ្ដានាញ្ច ទ្វាទឝ ឌល្លកាន៑ សំជគ្ឫហុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","អថៃកទា និជ៌នេ ឝិឞ្យៃះ សហ ប្រាត៌្ហនាកាលេ តាន៑ បប្រច្ឆ, លោកា មាំ កំ វទន្តិ? ");
INSERT INTO sankhm_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","តតស្តេ ប្រាចុះ, ត្វាំ យោហន្មជ្ជកំ វទន្តិ; កេចិត៑ ត្វាម៑ ឯលិយំ វទន្តិ, បូវ៌្វកាលិកះ កឝ្ចិទ៑ ភវិឞ្យទ្វាទី ឝ្មឝានាទ៑ ឧទតិឞ្ឋទ៑ ឥត្យបិ កេចិទ៑ វទន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","តទា ស ឧវាច, យូយំ មាំ កំ វទថ? តតះ បិតរ ឧក្តវាន៑ ត្វម៑ ឦឝ្វរាភិឞិក្តះ បុរុឞះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","តទា ស តាន៑ ទ្ឫឍមាទិទេឝ, កថាមេតាំ កស្មៃចិទបិ មា កថយត។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ស បុនរុវាច, មនុឞ្យបុត្រេណ វហុយាតនា ភោក្តវ្យាះ ប្រាចីនលោកៃះ ប្រធានយាជកៃរធ្យាបកៃឝ្ច សោវជ្ញាយ ហន្តវ្យះ កិន្តុ ត្ឫតីយទិវសេ ឝ្មឝានាត៑ តេនោត្ថាតវ្យម៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","អបរំ ស សវ៌្វានុវាច, កឝ្ចិទ៑ យទិ មម បឝ្ចាទ៑ គន្តុំ វាញ្ឆតិ តហ៌ិ ស ស្វំ ទាម្យតុ, ទិនេ ទិនេ ក្រុឝំ គ្ឫហីត្វា ច មម បឝ្ចាទាគច្ឆតុ។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","យតោ យះ កឝ្ចិត៑ ស្វប្រាណាន៑ រិរក្ឞិឞតិ ស តាន៑ ហារយិឞ្យតិ, យះ កឝ្ចិន៑ មទត៌្ហំ ប្រាណាន៑ ហារយិឞ្យតិ ស តាន៑ រក្ឞិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","កឝ្ចិទ៑ យទិ សវ៌្វំ ជគត៑ ប្រាប្នោតិ កិន្តុ ស្វប្រាណាន៑ ហារយតិ ស្វយំ វិនឝ្យតិ ច តហ៌ិ តស្យ កោ លាភះ? ");
INSERT INTO sankhm_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","បុន រ្យះ កឝ្ចិន៑ មាំ មម វាក្យំ វា លជ្ជាស្បទំ ជានាតិ មនុឞ្យបុត្រោ យទា ស្វស្យ បិតុឝ្ច បវិត្រាណាំ ទូតានាញ្ច តេជោភិះ បរិវេឞ្ដិត អាគមិឞ្យតិ តទា សោបិ តំ លជ្ជាស្បទំ ជ្ញាស្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","កិន្តុ យុឞ្មានហំ យថាត៌្ហំ វទាមិ, ឦឝ្វរីយរាជត្វំ ន ទ្ឫឞ្ដវា ម្ឫត្យុំ នាស្វាទិឞ្យន្តេ, ឯតាទ្ឫឝាះ កិយន្តោ លោកា អត្រ ស្ថនេៜបិ ទណ្ឌាយមានាះ សន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ឯតទាខ្យានកថនាត៑ បរំ ប្រាយេណាឞ្ដសុ ទិនេឞុ គតេឞុ ស បិតរំ យោហនំ យាកូពញ្ច គ្ឫហីត្វា ប្រាត៌្ហយិតុំ បវ៌្វតមេកំ សមារុរោហ។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","អថ តស្យ ប្រាត៌្ហនកាលេ តស្យ មុខាក្ឫតិរន្យរូបា ជាតា, តទីយំ វស្ត្រមុជ្ជ្វលឝុក្លំ ជាតំ។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","អបរញ្ច មូសា ឯលិយឝ្ចោភៅ តេជស្វិនៅ ទ្ឫឞ្ដៅ ");
INSERT INTO sankhm_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","តៅ តេន យិរូឝាលម្បុរេ យោ ម្ឫត្យុះ សាធិឞ្យតេ តទីយាំ កថាំ តេន សាទ៌្ធំ កថយិតុម៑ អារេភាតេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","តទា បិតរាទយះ ស្វស្យ សង្គិនោ និទ្រយាក្ឫឞ្ដា អាសន៑ កិន្តុ ជាគរិត្វា តស្យ តេជស្តេន សាទ៌្ធម៑ ឧត្តិឞ្ឋន្តៅ ជនៅ ច ទទ្ឫឝុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","អថ តយោរុភយោ រ្គមនកាលេ បិតរោ យីឝុំ ពភាឞេ, ហេ គុរោៜស្មាកំ ស្ថានេៜស្មិន៑ ស្ថិតិះ ឝុភា, តត ឯកា ត្វទត៌្ហា, ឯកា មូសាត៌្ហា, ឯកា ឯលិយាត៌្ហា, ឥតិ តិស្រះ កុដ្យោស្មាភិ រ្និម៌្មីយន្តាំ, ឥមាំ កថាំ ស ន វិវិច្យ កថយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","អបរញ្ច តទ្វាក្យវទនកាលេ បយោទ ឯក អាគត្យ តេឞាមុបរិ ឆាយាំ ចការ, តតស្តន្មធ្យេ តយោះ ប្រវេឝាត៑ តេ ឝឝង្កិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","តទា តស្មាត៑ បយោទាទ៑ ឥយមាកាឝីយា វាណី និជ៌គាម, មមាយំ ប្រិយះ បុត្រ ឯតស្យ កថាយាំ មនោ និធត្ត។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ឥតិ ឝព្ទេ ជាតេ តេ យីឝុមេកាកិនំ ទទ្ឫឝុះ កិន្តុ តេ តទានីំ តស្យ ទឝ៌នស្យ វាចមេកាមបិ នោក្ត្វា មនះសុ ស្ថាបយាមាសុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","បរេៜហនិ តេឞុ តស្មាច្ឆៃលាទ៑ អវរូឍេឞុ តំ សាក្ឞាត៑ កត៌្តុំ ពហវោ លោកា អាជគ្មុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","តេឞាំ មធ្យាទ៑ ឯកោ ជន ឧច្ចៃរុវាច, ហេ គុរោ អហំ វិនយំ ករោមិ មម បុត្រំ ប្រតិ ក្ឫបាទ្ឫឞ្ដិំ ករោតុ, មម ស ឯវៃកះ បុត្រះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ភូតេន ធ្ឫតះ សន៑ សំ ប្រសភំ ចីច្ឆព្ទំ ករោតិ តន្មុខាត៑ ផេណា និគ៌ច្ឆន្តិ ច, ភូត ឥត្ថំ វិទាយ៌្យ ក្លិឞ្ដ្វា ប្រាយឝស្តំ ន ត្យជតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","តស្មាត៑ តំ ភូតំ ត្យាជយិតុំ តវ ឝិឞ្យសមីបេ ន្យវេទយំ កិន្តុ តេ ន ឝេកុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","តទា យីឝុរវាទីត៑, រេ អាវិឝ្វាសិន៑ វិបថគាមិន៑ វំឝ កតិកាលាន៑ យុឞ្មាភិះ សហ ស្ថាស្យាម្យហំ យុឞ្មាកម៑ អាចរណានិ ច សហិឞ្យេ? តវ បុត្រមិហានយ។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","តតស្តស្មិន្នាគតមាត្រេ ភូតស្តំ ភូមៅ បាតយិត្វា វិទទារ; តទា យីឝុស្តមមេធ្យំ ភូតំ តជ៌យិត្វា ពាលកំ ស្វស្ថំ ក្ឫត្វា តស្យ បិតរិ សមប៌យាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ឦឝ្វរស្យ មហាឝក្តិម៑ ឥមាំ វិលោក្យ សវ៌្វេ ចមច្ចក្រុះ; ឥត្ថំ យីឝោះ សវ៌្វាភិះ ក្រិយាភិះ សវ៌្វៃល៌ោកៃរាឝ្ចយ៌្យេ មន្យមានេ សតិ ស ឝិឞ្យាន៑ ពភាឞេ, ");
INSERT INTO sankhm_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","កថេយំ យុឞ្មាកំ កណ៌េឞុ ប្រវិឝតុ, មនុឞ្យបុត្រោ មនុឞ្យាណាំ ករេឞុ សមប៌យិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","កិន្តុ តេ តាំ កថាំ ន ពុពុធិរេ, ស្បឞ្ដត្វាភាវាត៑ តស្យា អភិប្រាយស្តេឞាំ ពោធគម្យោ ន ពភូវ; តស្យា អាឝយះ ក ឥត្យបិ តេ ភយាត៑ ប្រឞ្ដុំ ន ឝេកុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","តទនន្តរំ តេឞាំ មធ្យេ កះ ឝ្រេឞ្ឋះ កថាមេតាំ គ្ឫហីត្វា តេ មិថោ វិវាទំ ចក្រុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","តតោ យីឝុស្តេឞាំ មនោភិប្រាយំ វិទិត្វា ពាលកមេកំ គ្ឫហីត្វា ស្វស្យ និកដេ ស្ថាបយិត្វា តាន៑ ជគាទ, ");
INSERT INTO sankhm_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","យោ ជនោ មម នាម្នាស្យ ពាលាស្យាតិថ្យំ វិទធាតិ ស មមាតិថ្យំ វិទធាតិ, យឝ្ច មមាតិថ្យំ វិទធាតិ ស មម ប្រេរកស្យាតិថ្យំ វិទធាតិ, យុឞ្មាកំ មធ្យេយះ ស្វំ សវ៌្វស្មាត៑ ក្ឞុទ្រំ ជានីតេ ស ឯវ ឝ្រេឞ្ឋោ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","អបរញ្ច យោហន៑ វ្យាជហារ ហេ ប្រភេा តវ នាម្នា ភូតាន៑ ត្យាជយន្តំ មានុឞម៑ ឯកំ ទ្ឫឞ្ដវន្តោ វយំ, កិន្ត្វស្មាកម៑ អបឝ្ចាទ៑ គាមិត្វាត៑ តំ ន្យឞេធាម៑។ តទានីំ យីឝុរុវាច, ");
INSERT INTO sankhm_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","តំ មា និឞេធត, យតោ យោ ជនោស្មាកំ ន វិបក្ឞះ ស ឯវាស្មាកំ សបក្ឞោ ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","អនន្តរំ តស្យារោហណសមយ ឧបស្ថិតេ ស ស្ថិរចេតា យិរូឝាលមំ ប្រតិ យាត្រាំ កត៌្តុំ និឝ្ចិត្យាគ្រេ ទូតាន៑ ប្រេឞយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","តស្មាត៑ តេ គត្វា តស្យ ប្រយោជនីយទ្រវ្យាណិ សំគ្រហីតុំ ឝោមិរោណីយានាំ គ្រាមំ ប្រវិវិឝុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","កិន្តុ ស យិរូឝាលមំ នគរំ យាតិ តតោ ហេតោ រ្លោកាស្តស្យាតិថ្យំ ន ចក្រុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","អតឯវ យាកូព្យោហនៅ តស្យ ឝិឞ្យៅ តទ៑ ទ្ឫឞ្ដ្វា ជគទតុះ, ហេ ប្រភោ ឯលិយោ យថា ចការ តថា វយមបិ កិំ គគណាទ៑ អាគន្តុម៑ ឯតាន៑ ភស្មីកត៌្តុញ្ច វហ្និមាជ្ញាបយាមះ? ភវាន៑ កិមិច្ឆតិ? ");
INSERT INTO sankhm_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","កិន្តុ ស មុខំ បរាវត៌្យ តាន៑ តជ៌យិត្វា គទិតវាន៑ យុឞ្មាកំ មនោភាវះ កះ, ឥតិ យូយំ ន ជានីថ។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","មនុជសុតោ មនុជានាំ ប្រាណាន៑ នាឝយិតុំ នាគច្ឆត៑, កិន្តុ រក្ឞិតុម៑ អាគច្ឆត៑។ បឝ្ចាទ៑ ឥតរគ្រាមំ តេ យយុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","តទនន្តរំ បថិ គមនកាលេ ជន ឯកស្តំ ពភាឞេ, ហេ ប្រភោ ភវាន៑ យត្រ យាតិ ភវតា សហាហមបិ តត្រ យាស្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","តទានីំ យីឝុស្តមុវាច, គោមាយូនាំ គត៌្តា អាសតេ, វិហាយសីយវិហគាाនាំ នីឌានិ ច សន្តិ, កិន្តុ មានវតនយស្យ ឝិរះ ស្ថាបយិតុំ ស្ថានំ នាស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","តតះ បរំ ស ឥតរជនំ ជគាទ, ត្វំ មម បឝ្ចាទ៑ ឯហិ; តតះ ស ឧវាច, ហេ ប្រភោ បូវ៌្វំ បិតរំ ឝ្មឝានេ ស្ថាបយិតុំ មាមាទិឝតុ។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","តទា យីឝុរុវាច, ម្ឫតា ម្ឫតាន៑ ឝ្មឝានេ ស្ថាបយន្តុ កិន្តុ ត្វំ គត្វេឝ្វរីយរាជ្យស្យ កថាំ ប្រចារយ។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","តតោន្យះ កថយាមាស, ហេ ប្រភោ មយាបិ ភវតះ បឝ្ចាទ៑ គំស្យតេ, កិន្តុ បូវ៌្វំ មម និវេឝនស្យ បរិជនានាម៑ អនុមតិំ គ្រហីតុម៑ អហមាទិឝ្យៃ ភវតា។ ");
INSERT INTO sankhm_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","តទានីំ យីឝុស្តំ ប្រោក្តវាន៑, យោ ជនោ លាង្គលេ ករមប៌យិត្វា បឝ្ចាត៑ បឝ្យតិ ស ឦឝ្វរីយរាជ្យំ នាហ៌តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","តតះ បរំ ប្រភុរបរាន៑ សប្តតិឝិឞ្យាន៑ និយុជ្យ ស្វយំ យានិ នគរាណិ យានិ ស្ថានានិ ច គមិឞ្យតិ តានិ នគរាណិ តានិ ស្ថានានិ ច ប្រតិ ទ្វៅ ទ្វៅ ជនៅ ប្រហិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","តេភ្យះ កថយាមាស ច ឝស្យានិ ពហូនីតិ សត្យំ កិន្តុ ឆេទកា អល្បេ; តស្មាទ្ធេតោះ ឝស្យក្ឞេត្រេ ឆេទកាន៑ អបរានបិ ប្រេឞយិតុំ ក្ឞេត្រស្វាមិនំ ប្រាត៌្ហយធ្វំ។ ");
INSERT INTO sankhm_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","យូយំ យាត, បឝ្យត, វ្ឫកាណាំ មធ្យេ មេឞឝាវកានិវ យុឞ្មាន៑ ប្រហិណោមិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","យូយំ ក្ឞុទ្រំ មហទ៑ វា វសនសម្បុដកំ បាទុកាឝ្ច មា គ្ឫហ្លីត, មាគ៌មធ្យេ កមបិ មា នមត ច។ ");
INSERT INTO sankhm_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","អបរញ្ច យូយំ យទ៑ យត៑ និវេឝនំ ប្រវិឝថ តត្រ និវេឝនស្យាស្យ មង្គលំ ភូយាទិតិ វាក្យំ ប្រថមំ វទត។ ");
INSERT INTO sankhm_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","តស្មាត៑ តស្មិន៑ និវេឝនេ យទិ មង្គលបាត្រំ ស្ថាស្យតិ តហ៌ិ តន្មង្គលំ តស្យ ភវិឞ្យតិ, នោចេត៑ យុឞ្មាន៑ ប្រតិ បរាវត៌្តិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","អបរញ្ច តេ យត្កិញ្ចិទ៑ ទាស្យន្តិ តទេវ ភុក្ត្វា បីត្វា តស្មិន្និវេឝនេ ស្ថាស្យថ; យតះ កម៌្មការី ជនោ ភ្ឫតិម៑ អហ៌តិ; គ្ឫហាទ៑ គ្ឫហំ មា យាស្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","អន្យច្ច យុឞ្មាសុ កិមបិ នគរំ ប្រវិឞ្ដេឞុ លោកា យទិ យុឞ្មាកម៑ អាតិថ្យំ ករិឞ្យន្តិ, តហ៌ិ យត៑ ខាទ្យម៑ ឧបស្ថាស្យន្តិ តទេវ ខាទិឞ្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","តន្នគរស្ថាន៑ រោគិណះ ស្វស្ថាន៑ ករិឞ្យថ, ឦឝ្វរីយំ រាជ្យំ យុឞ្មាកម៑ អន្តិកម៑ អាគមត៑ កថាមេតាញ្ច ប្រចារយិឞ្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","កិន្តុ កិមបិ បុរំ យុឞ្មាសុ ប្រវិឞ្ដេឞុ លោកា យទិ យុឞ្មាកម៑ អាតិថ្យំ ន ករិឞ្យន្តិ, តហ៌ិ តស្យ នគរស្យ បន្ថានំ គត្វា កថាមេតាំ វទិឞ្យថ, ");
INSERT INTO sankhm_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","យុឞ្មាកំ នគរីយា យា ធូល្យោៜស្មាសុ សមលគន៑ តា អបិ យុឞ្មាកំ ប្រាតិកូល្យេន សាក្ឞ្យាត៌្ហំ សម្បាតយាមះ; តថាបីឝ្វររាជ្យំ យុឞ្មាកំ សមីបម៑ អាគតម៑ ឥតិ និឝ្ចិតំ ជានីត។ ");
INSERT INTO sankhm_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","អហំ យុឞ្មភ្យំ យថាត៌្ហំ កថយាមិ, វិចារទិនេ តស្យ នគរស្យ ទឝាតះ សិទោមោ ទឝា សហ្យា ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","ហា ហា កោរាសីន៑ នគរ, ហា ហា ពៃត្សៃទានគរ យុវយោម៌ធ្យេ យាទ្ឫឝានិ អាឝ្ចយ៌្យាណិ កម៌្មាណ្យក្រិយន្ត, តានិ កម៌្មាណិ យទិ សោរសីទោនោ រ្នគរយោរការិឞ្យន្ត, តទា ឥតោ ពហុទិនបូវ៌្វំ តន្និវាសិនះ ឝណវស្ត្រាណិ បរិធាយ គាត្រេឞុ ភស្ម វិលិប្យ សមុបវិឝ្យ សមខេត្ស្យន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","អតោ វិចារទិវសេ យុឞ្មាកំ ទឝាតះ សោរសីទោន្និវាសិនាំ ទឝា សហ្យា ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ហេ កផន៌ាហូម៑, ត្វំ ស្វគ៌ំ យាវទ៑ ឧន្នតា កិន្តុ នរកំ យាវត៑ ន្យគ្ភវិឞ្យសិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","យោ ជនោ យុឞ្មាកំ វាក្យំ គ្ឫហ្លាតិ ស មមៃវ វាក្យំ គ្ឫហ្លាតិ; កិញ្ច យោ ជនោ យុឞ្មាកម៑ អវជ្ញាំ ករោតិ ស មមៃវាវជ្ញាំ ករោតិ; យោ ជនោ មមាវជ្ញាំ ករោតិ ច ស មត្ប្រេរកស្យៃវាវជ្ញាំ ករោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","អថ តេ សប្តតិឝិឞ្យា អានន្ទេន ប្រត្យាគត្យ កថយាមាសុះ, ហេ ប្រភោ ភវតោ នាម្នា ភូតា អប្យស្មាកំ វឝីភវន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","តទានីំ ស តាន៑ ជគាទ, វិទ្យុតមិវ ស្វគ៌ាត៑ បតន្តំ ឝៃតានម៑ អទឝ៌ម៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","បឝ្យត សប៌ាន៑ វ្ឫឝ្ចិកាន៑ រិបោះ សវ៌្វបរាក្រមាំឝ្ច បទតលៃ រ្ទលយិតុំ យុឞ្មភ្យំ ឝក្តិំ ទទាមិ តស្មាទ៑ យុឞ្មាកំ កាបិ ហានិ រ្ន ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","ភូតា យុឞ្មាកំ វឝីភវន្តិ, ឯតន្និមិត្តត៑ មា សមុល្លសត, ស្វគ៌េ យុឞ្មាកំ នាមានិ លិខិតានិ សន្តីតិ និមិត្តំ សមុល្លសត។ ");
INSERT INTO sankhm_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","តទ្ឃដិកាយាំ យីឝុ រ្មនសិ ជាតាហ្លាទះ កថយាមាស ហេ ស្វគ៌ប្ឫថិវ្យោរេកាធិបតេ បិតស្ត្វំ ជ្ញានវតាំ វិទុឞាញ្ច លោកានាំ បុរស្តាត៑ សវ៌្វមេតទ៑ អប្រកាឝ្យ ពាលកានាំ បុរស្តាត៑ ប្រាកាឝយ ឯតស្មាទ្ធេតោស្ត្វាំ ធន្យំ វទាមិ, ហេ បិតរិត្ថំ ភវតុ យទ៑ ឯតទេវ តវ គោចរ ឧត្តមម៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","បិត្រា សវ៌្វាណិ មយិ សមប៌ិតានិ បិតរំ វិនា កោបិ បុត្រំ ន ជានាតិ កិញ្ច បុត្រំ វិនា យស្មៃ ជនាយ បុត្រស្តំ ប្រកាឝិតវាន៑ តញ្ច វិនា កោបិ បិតរំ ន ជានាតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","តបះ បរំ ស ឝិឞ្យាន៑ ប្រតិ បរាវ្ឫត្យ គុប្តំ ជគាទ, យូយមេតានិ សវ៌្វាណិ បឝ្យថ តតោ យុឞ្មាកំ ចក្ឞូំឞិ ធន្យានិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","យុឞ្មានហំ វទាមិ, យូយំ យានិ សវ៌្វាណិ បឝ្យថ តានិ ពហវោ ភវិឞ្យទ្វាទិនោ ភូបតយឝ្ច ទ្រឞ្ដុមិច្ឆន្តោបិ ទ្រឞ្ដុំ ន ប្រាប្នុវន៑, យុឞ្មាភិ រ្យា យាះ កថាឝ្ច ឝ្រូយន្តេ តាះ ឝ្រោតុមិច្ឆន្តោបិ ឝ្រោតុំ នាលភន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","អនន្តរម៑ ឯកោ វ្យវស្ថាបក ឧត្ថាយ តំ បរីក្ឞិតុំ បប្រច្ឆ, ហេ ឧបទេឝក អនន្តាយុឞះ ប្រាប្តយេ មយា កិំ ករណីយំ? ");
INSERT INTO sankhm_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","យីឝុះ ប្រត្យុវាច, អត្រាត៌្ហេ វ្យវស្ថាយាំ កិំ លិខិតមស្តិ? ត្វំ កីទ្ឫក៑ បឋសិ? ");
INSERT INTO sankhm_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","តតះ សោវទត៑, ត្វំ សវ៌្វាន្តះករណៃះ សវ៌្វប្រាណៃះ សវ៌្វឝក្តិភិះ សវ៌្វចិត្តៃឝ្ច ប្រភៅ បរមេឝ្វរេ ប្រេម កុរុ, សមីបវាសិនិ ស្វវត៑ ប្រេម កុរុ ច។ ");
INSERT INTO sankhm_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","តទា ស កថយាមាស, ត្វំ យថាត៌្ហំ ប្រត្យវោចះ, ឥត្ថម៑ អាចរ តេនៃវ ជីវិឞ្យសិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","កិន្តុ ស ជនះ ស្វំ និទ៌្ទោឞំ ជ្ញាបយិតុំ យីឝុំ បប្រច្ឆ, មម សមីបវាសី កះ? តតោ យីឝុះ ប្រត្យុវាច, ");
INSERT INTO sankhm_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ឯកោ ជនោ យិរូឝាលម្បុរាទ៑ យិរីហោបុរំ យាតិ, ឯតហ៌ិ ទស្យូនាំ ករេឞុ បតិតេ តេ តស្យ វស្ត្រាទិកំ ហ្ឫតវន្តះ តមាហត្យ ម្ឫតប្រាយំ ក្ឫត្វា ត្យក្ត្វា យយុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","អកស្មាទ៑ ឯកោ យាជកស្តេន មាគ៌េណ គច្ឆន៑ តំ ទ្ឫឞ្ដ្វា មាគ៌ាន្យបាឝ៌្វេន ជគាម។ ");
INSERT INTO sankhm_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ឥត្ថម៑ ឯកោ លេវីយស្តត្ស្ថានំ ប្រាប្យ តស្យាន្តិកំ គត្វា តំ វិលោក្យាន្យេន បាឝ៌្វេន ជគាម។ ");
INSERT INTO sankhm_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","កិន្ត្វេកះ ឝោមិរោណីយោ គច្ឆន៑ តត្ស្ថានំ ប្រាប្យ តំ ទ្ឫឞ្ដ្វាទយត។ ");
INSERT INTO sankhm_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","តស្យាន្តិកំ គត្វា តស្យ ក្ឞតេឞុ តៃលំ ទ្រាក្ឞារសញ្ច ប្រក្ឞិប្យ ក្ឞតានិ ពទ្ធ្វា និជវាហនោបរិ តមុបវេឝ្យ ប្រវាសីយគ្ឫហម៑ អានីយ តំ សិឞេវេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","បរស្មិន៑ ទិវសេ និជគមនកាលេ ទ្វៅ មុទ្រាបាទៅ តទ្គ្ឫហស្វាមិនេ ទត្ត្វាវទត៑ ជនមេនំ សេវស្វ តត្រ យោៜធិកោ វ្យយោ ភវិឞ្យតិ តមហំ បុនរាគមនកាលេ បរិឝោត្ស្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","ឯឞាំ ត្រយាណាំ មធ្យេ តស្យ ទស្យុហស្តបតិតស្យ ជនស្យ សមីបវាសី កះ? ត្វយា កិំ ពុធ្យតេ? ");
INSERT INTO sankhm_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","តតះ ស វ្យវស្ថាបកះ កថយាមាស យស្តស្មិន៑ ទយាំ ចការ។ តទា យីឝុះ កថយាមាស ត្វមបិ គត្វា តថាចរ។ ");
INSERT INTO sankhm_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","តតះ បរំ តេ គច្ឆន្ត ឯកំ គ្រាមំ ប្រវិវិឝុះ; តទា មត៌្ហានាមា ស្ត្រី ស្វគ្ឫហេ តស្យាតិថ្យំ ចការ។ ");
INSERT INTO sankhm_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","តស្មាត៑ មរិយម៑ នាមធេយា តស្យា ភគិនី យីឝោះ បទសមីប ឧវវិឝ្យ តស្យោបទេឝកថាំ ឝ្រោតុមារេភេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","កិន្តុ មត៌្ហា នានាបរិចយ៌្យាយាំ វ្យគ្រា ពភូវ តស្មាទ្ធេតោស្តស្យ សមីបមាគត្យ ពភាឞេ; ហេ ប្រភោ មម ភគិនី កេវលំ មមោបរិ សវ៌្វកម៌្មណាំ ភារម៑ អប៌ិតវតី តត្រ ភវតា កិញ្ចិទបិ ន មនោ និធីយតេ កិម៑? មម សាហាយ្យំ កត៌្តុំ ភវាន៑ តាមាទិឝតុ។ ");
INSERT INTO sankhm_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","តតោ យីឝុះ ប្រត្យុវាច ហេ មត៌្ហេ ហេ មត៌្ហេ, ត្វំ នានាកាយ៌្យេឞុ ចិន្តិតវតី វ្យគ្រា ចាសិ, ");
INSERT INTO sankhm_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","កិន្តុ ប្រយោជនីយម៑ ឯកមាត្រម៑ អាស្តេ។ អបរញ្ច យមុត្តមំ ភាគំ កោបិ ហត៌្តុំ ន ឝក្នោតិ សឯវ មរិយមា វ្ឫតះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","អនន្តរំ ស កស្មិំឝ្ចិត៑ ស្ថានេ ប្រាត៌្ហយត តត្សមាប្តៅ សត្យាំ តស្យៃកះ ឝិឞ្យស្តំ ជគាទ ហេ ប្រភោ យោហន៑ យថា ស្វឝិឞ្យាន៑ ប្រាត៌្ហយិតុម៑ ឧបទិឞ្ដវាន៑ តថា ភវានប្យស្មាន៑ ឧបទិឝតុ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","តស្មាត៑ ស កថយាមាស, ប្រាត៌្ហនកាលេ យូយម៑ ឥត្ថំ កថយធ្វំ, ហេ អស្មាកំ ស្វគ៌ស្ថបិតស្តវ នាម បូជ្យំ ភវតុ; តវ រាជត្វំ ភវតុ; ស្វគ៌េ យថា តថា ប្ឫថិវ្យាមបិ តវេច្ឆយា សវ៌្វំ ភវតុ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ប្រត្យហម៑ អស្មាកំ ប្រយោជនីយំ ភោជ្យំ ទេហិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","យថា វយំ សវ៌្វាន៑ អបរាធិនះ ក្ឞមាមហេ តថា ត្វមបិ បាបាន្យស្មាកំ ក្ឞមស្វ។ អស្មាន៑ បរីក្ឞាំ មានយ កិន្តុ បាបាត្មនោ រក្ឞ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","បឝ្ចាត៑ សោបរមបិ កថិតវាន៑ យទិ យុឞ្មាកំ កស្យចិទ៑ ពន្ធុស្តិឞ្ឋតិ និឝីថេ ច តស្យ សមីបំ ស គត្វា វទតិ, ");
INSERT INTO sankhm_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ហេ ពន្ធោ បថិក ឯកោ ពន្ធុ រ្មម និវេឝនម៑ អាយាតះ កិន្តុ តស្យាតិថ្យំ កត៌្តុំ មមាន្តិកេ កិមបិ នាស្តិ, អតឯវ បូបត្រយំ មហ្យម៑ ឫណំ ទេហិ; ");
INSERT INTO sankhm_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","តទា ស យទិ គ្ឫហមធ្យាត៑ ប្រតិវទតិ មាំ មា ក្លិឝាន, ឥទានីំ ទ្វារំ រុទ្ធំ ឝយនេ មយា សហ ពាលកាឝ្ច តិឞ្ឋន្តិ តុភ្យំ ទាតុម៑ ឧត្ថាតុំ ន ឝក្នោមិ, ");
INSERT INTO sankhm_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","តហ៌ិ យុឞ្មានហំ វទាមិ, ស យទិ មិត្រតយា តស្មៃ កិមបិ ទាតុំ នោត្តិឞ្ឋតិ តថាបិ វារំ វារំ ប្រាត៌្ហនាត ឧត្ថាបិតះ សន៑ យស្មិន៑ តស្យ ប្រយោជនំ តទេវ ទាស្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","អតះ ការណាត៑ កថយាមិ, យាចធ្វំ តតោ យុឞ្មភ្យំ ទាស្យតេ, ម្ឫគយធ្វំ តត ឧទ្ទេឝំ ប្រាប្ស្យថ, ទ្វារម៑ អាហត តតោ យុឞ្មភ្យំ ទ្វារំ មោក្ឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","យោ យាចតេ ស ប្រាប្នោតិ, យោ ម្ឫគយតេ ស ឯវោទ្ទេឝំ ប្រាប្នោតិ, យោ ទ្វារម៑ អាហន្តិ តទត៌្ហំ ទ្វារំ មោច្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","បុត្រេណ បូបេ យាចិតេ តស្មៃ បាឞាណំ ទទាតិ វា មត្ស្យេ យាចិតេ តស្មៃ សប៌ំ ទទាតិ ");
INSERT INTO sankhm_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","វា អណ្ឌេ យាចិតេ តស្មៃ វ្ឫឝ្ចិកំ ទទាតិ យុឞ្មាកំ មធ្យេ ក ឯតាទ្ឫឝះ បិតាស្តេ? ");
INSERT INTO sankhm_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","តស្មាទេវ យូយមភទ្រា អបិ យទិ ស្វស្វពាលកេភ្យ ឧត្តមានិ ទ្រវ្យាណិ ទាតុំ ជានីថ តហ៌្យស្មាកំ ស្វគ៌ស្ថះ បិតា និជយាចកេភ្យះ កិំ បវិត្រម៑ អាត្មានំ ន ទាស្យតិ? ");
INSERT INTO sankhm_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","អនន្តរំ យីឝុនា កស្មាច្ចិទ៑ ឯកស្មិន៑ មូកភូតេ ត្យាជិតេ សតិ ស ភូតត្យក្តោ មានុឞោ វាក្យំ វក្តុម៑ អារេភេ; តតោ លោកាះ សកលា អាឝ្ចយ៌្យំ មេនិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","កិន្តុ តេឞាំ កេចិទូចុ រ្ជនោយំ ពាលសិពូពា អត៌្ហាទ៑ ភូតរាជេន ភូតាន៑ ត្យាជយតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","តំ បរីក្ឞិតុំ កេចិទ៑ អាកាឝីយម៑ ឯកំ ចិហ្នំ ទឝ៌យិតុំ តំ ប្រាត៌្ហយាញ្ចក្រិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","តទា ស តេឞាំ មនះកល្បនាំ ជ្ញាត្វា កថយាមាស, កស្យចិទ៑ រាជ្យស្យ លោកា យទិ បរស្បរំ វិរុន្ធន្តិ តហ៌ិ តទ៑ រាជ្យម៑ នឝ្យតិ; កេចិទ៑ គ្ឫហស្ថា យទិ បរស្បរំ វិរុន្ធន្តិ តហ៌ិ តេបិ នឝ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","តថៃវ ឝៃតានបិ ស្វលោកាន៑ យទិ វិរុណទ្ធិ តទា តស្យ រាជ្យំ កថំ ស្ថាស្យតិ? ពាលសិពូពាហំ ភូតាន៑ ត្យាជយាមិ យូយមិតិ វទថ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","យទ្យហំ ពាលសិពូពា ភូតាន៑ ត្យាជយាមិ តហ៌ិ យុឞ្មាកំ សន្តានាះ កេន ត្យាជយន្តិ? តស្មាត៑ តឯវ កថាយា ឯតស្យា វិចារយិតារោ ភវិឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","កិន្តុ យទ្យហម៑ ឦឝ្វរស្យ បរាក្រមេណ ភូតាន៑ ត្យាជយាមិ តហ៌ិ យុឞ្មាកំ និកដម៑ ឦឝ្វរស្យ រាជ្យមវឝ្យម៑ ឧបតិឞ្ឋតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","ពលវាន៑ បុមាន៑ សុសជ្ជមានោ យតិកាលំ និជាដ្ដាលិកាំ រក្ឞតិ តតិកាលំ តស្យ ទ្រវ្យំ និរុបទ្រវំ តិឞ្ឋតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","កិន្តុ តស្មាទ៑ អធិកពលះ កឝ្ចិទាគត្យ យទិ តំ ជយតិ តហ៌ិ យេឞុ ឝស្ត្រាស្ត្រេឞុ តស្យ វិឝ្វាស អាសីត៑ តានិ សវ៌្វាណិ ហ្ឫត្វា តស្យ ទ្រវ្យាណិ គ្ឫហ្លាតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","អតះ ការណាទ៑ យោ មម សបក្ឞោ ន ស វិបក្ឞះ, យោ មយា សហ ន សំគ្ឫហ្លាតិ ស វិកិរតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","អបរញ្ច អមេធ្យភូតោ មានុឞស្យាន្តន៌ិគ៌ត្យ ឝុឞ្កស្ថានេ ភ្រាន្ត្វា វិឝ្រាមំ ម្ឫគយតេ កិន្តុ ន ប្រាប្យ វទតិ មម យស្មាទ៑ គ្ឫហាទ៑ អាគតោហំ បុនស្តទ៑ គ្ឫហំ បរាវ្ឫត្យ យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","តតោ គត្វា តទ៑ គ្ឫហំ មាជ៌ិតំ ឝោភិតញ្ច ទ្ឫឞ្ដ្វា ");
INSERT INTO sankhm_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","តត្ក្ឞណម៑ អបគត្យ ស្វស្មាទបិ ទុម៌្មតីន៑ អបរាន៑ សប្តភូតាន៑ សហានយតិ តេ ច តទ្គ្ឫហំ បវិឝ្យ និវសន្តិ។ តស្មាត៑ តស្យ មនុឞ្យស្យ ប្រថមទឝាតះ ឝេឞទឝា ទុះខតរា ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","អស្យាះ កថាយាះ កថនកាលេ ជនតាមធ្យស្ថា កាចិន្នារី តមុច្ចៃះស្វរំ ប្រោវាច, យា យោឞិត៑ ត្វាំ គព៌្ភេៜធារយត៑ ស្តន្យមបាយយច្ច សៃវ ធន្យា។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","កិន្តុ សោកថយត៑ យេ បរមេឝ្វរស្យ កថាំ ឝ្រុត្វា តទនុរូបម៑ អាចរន្តិ តឯវ ធន្យាះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","តតះ បរំ តស្យាន្តិកេ ពហុលោកានាំ សមាគមេ ជាតេ ស វក្តុមារេភេ, អាធុនិកា ទុឞ្ដលោកាឝ្ចិហ្នំ ទ្រឞ្ដុមិច្ឆន្តិ កិន្តុ យូនស្ភវិឞ្យទ្វាទិនឝ្ចិហ្នំ វិនាន្យត៑ កិញ្ចិច្ចិហ្នំ តាន៑ ន ទឝ៌យិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","យូនស៑ តុ យថា នីនិវីយលោកានាំ សមីបេ ចិហ្នរូបោភវត៑ តថា វិទ្យមានលោកានាម៑ ឯឞាំ សមីបេ មនុឞ្យបុត្រោបិ ចិហ្នរូបោ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","វិចារសមយេ ឥទានីន្តនលោកានាំ ប្រាតិកូល្យេន ទក្ឞិណទេឝីយា រាជ្ញី ប្រោត្ថាយ តាន៑ ទោឞិណះ ករិឞ្យតិ, យតះ សា រាជ្ញី សុលេមាន ឧបទេឝកថាំ ឝ្រោតុំ ប្ឫថិវ្យាះ សីមាត អាគច្ឆត៑ កិន្តុ បឝ្យត សុលេមានោបិ គុរុតរ ឯកោ ជនោៜស្មិន៑ ស្ថានេ វិទ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","អបរញ្ច វិចារសមយេ នីនិវីយលោកា អបិ វត៌្តមានកាលិកានាំ លោកានាំ វៃបរីត្យេន ប្រោត្ថាយ តាន៑ ទោឞិណះ ករិឞ្យន្តិ, យតោ ហេតោស្តេ យូនសោ វាក្យាត៑ ចិត្តានិ បរិវត៌្តយាមាសុះ កិន្តុ បឝ្យត យូនសោតិគុរុតរ ឯកោ ជនោៜស្មិន៑ ស្ថានេ វិទ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","ប្រទីបំ ប្រជ្វាល្យ ទ្រោណស្យាធះ កុត្រាបិ គុប្តស្ថានេ វា កោបិ ន ស្ថាបយតិ កិន្តុ គ្ឫហប្រវេឝិភ្យោ ទីប្តិំ ទាតំ ទីបាធារោបយ៌្យេវ ស្ថាបយតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","ទេហស្យ ប្រទីបឝ្ចក្ឞុស្តស្មាទេវ ចក្ឞុ រ្យទិ ប្រសន្នំ ភវតិ តហ៌ិ តវ សវ៌្វឝរីរំ ទីប្តិមទ៑ ភវិឞ្យតិ កិន្តុ ចក្ឞុ រ្យទិ មលីមសំ តិឞ្ឋតិ តហ៌ិ សវ៌្វឝរីរំ សាន្ធការំ ស្ថាស្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","អស្មាត៑ ការណាត៑ តវាន្តះស្ថំ ជ្យោតិ រ្យថាន្ធការមយំ ន ភវតិ តទត៌្ហេ សាវធានោ ភវ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","យតះ ឝរីរស្យ កុត្រាប្យំឝេ សាន្ធការេ ន ជាតេ សវ៌្វំ យទិ ទីប្តិមត៑ តិឞ្ឋតិ តហ៌ិ តុភ្យំ ទីប្តិទាយិប្រោជ្ជ្វលន៑ ប្រទីប ឥវ តវ សវវ៌ឝរីរំ ទីប្តិមទ៑ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ឯតត្កថាយាះ កថនកាលេ ផិរុឝ្យេកោ ភេជនាយ តំ និមន្ត្រយាមាស, តតះ ស គត្វា ភោក្តុម៑ ឧបវិវេឝ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","កិន្តុ ភោជនាត៑ បូវ៌្វំ នាមាង្ក្ឞីត៑ ឯតទ៑ ទ្ឫឞ្ដ្វា ស ផិរុឝ្យាឝ្ចយ៌្យំ មេនេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","តទា ប្រភុស្តំ ប្រោវាច យូយំ ផិរូឝិលោកាះ បានបាត្រាណាំ ភោជនបាត្រាណាញ្ច ពហិះ បរិឞ្កុរុថ កិន្តុ យុឞ្មាកមន្ត រ្ទៅរាត្ម្យៃ រ្ទុឞ្ក្រិយាភិឝ្ច បរិបូណ៌ំ តិឞ្ឋតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ហេ សវ៌្វេ និព៌ោធា យោ ពហិះ សសជ៌ ស ឯវ កិមន្ត រ្ន សសជ៌? ");
INSERT INTO sankhm_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","តត ឯវ យុឞ្មាភិរន្តះករណំ (ឦឝ្វរាយ) និវេទ្យតាំ តស្មិន៑ ក្ឫតេ យុឞ្មាកំ សវ៌្វាណិ ឝុចិតាំ យាស្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","កិន្តុ ហន្ត ផិរូឝិគណា យូយំ ន្យាយម៑ ឦឝ្វរេ ប្រេម ច បរិត្យជ្យ បោទិនាយា អរុទាទីនាំ សវ៌្វេឞាំ ឝាកានាញ្ច ទឝមាំឝាន៑ ទត្ថ កិន្តុ ប្រថមំ បាលយិត្វា ឝេឞស្យាលង្ឃនំ យុឞ្មាកម៑ ឧចិតមាសីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","ហា ហា ផិរូឝិនោ យូយំ ភជនគេហេ ប្រោច្ចាសនេ អាបណេឞុ ច នមស្ការេឞុ ប្រីយធ្វេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","វត កបដិនោៜធ្យាបកាះ ផិរូឝិនឝ្ច លោកាយត៑ ឝ្មឝានម៑ អនុបលភ្យ តទុបរិ គច្ឆន្តិ យូយម៑ តាទ្ឫគប្រកាឝិតឝ្មឝានវាទ៑ ភវថ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","តទានីំ វ្យវស្ថាបកានាម៑ ឯកា យីឝុមវទត៑, ហេ ឧបទេឝក វាក្យេនេទ្ឫឝេនាស្មាស្វបិ ទោឞម៑ អារោបយសិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","តតះ ស ឧវាច, ហា ហា វ្យវស្ថាបកា យូយម៑ មានុឞាណាម៑ ឧបរិ ទុះសហ្យាន៑ ភារាន៑ ន្យស្យថ កិន្តុ ស្វយម៑ ឯកាង្គុुល្យាបិ តាន៑ ភារាន៑ ន ស្ប្ឫឝថ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","ហន្ត យុឞ្មាកំ បូវ៌្វបុរុឞា យាន៑ ភវិឞ្យទ្វាទិនោៜវធិឞុស្តេឞាំ ឝ្មឝានានិ យូយំ និម៌្មាថ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","តេនៃវ យូយំ ស្វបូវ៌្វបុរុឞាណាំ កម៌្មាណិ សំមន្យធ្វេ តទេវ សប្រមាណំ កុរុថ ច, យតស្តេ តានវធិឞុះ យូយំ តេឞាំ ឝ្មឝានានិ និម៌្មាថ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","អតឯវ ឦឝ្វរស្យ ឝាស្ត្រេ ប្រោក្តមស្តិ តេឞាមន្តិកេ ភវិឞ្យទ្វាទិនះ ប្រេរិតាំឝ្ច ប្រេឞយិឞ្យាមិ តតស្តេ តេឞាំ កាំឝ្ចន ហនិឞ្យន្តិ កាំឝ្ចន តាឌឝ្ឞ្យិន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ឯតស្មាត៑ ការណាត៑ ហាពិលះ ឝោណិតបាតមារភ្យ មន្ទិរយជ្ញវេទ្យោ រ្មធ្យេ ហតស្យ សិខរិយស្យ រក្តបាតបយ៌្យន្តំ ");
INSERT INTO sankhm_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ជគតះ ស្ឫឞ្ដិមារភ្យ ប្ឫថិវ្យាំ ភវិឞ្យទ្វាទិនាំ យតិរក្តបាតា ជាតាស្តតីនាម៑ អបរាធទណ្ឌា ឯឞាំ វត៌្តមានលោកានាំ ភវិឞ្យន្តិ, យុឞ្មានហំ និឝ្ចិតំ វទាមិ សវ៌្វេ ទណ្ឌា វំឝស្យាស្យ ភវិឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","ហា ហា វ្យវស្ថបកា យូយំ ជ្ញានស្យ កុញ្ចិកាំ ហ្ឫត្វា ស្វយំ ន ប្រវិឞ្ដា យេ ប្រវេឞ្ដុញ្ច ប្រយាសិនស្តានបិ ប្រវេឞ្ដុំ វារិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ឥត្ថំ កថាកថនាទ៑ អធ្យាបកាះ ផិរូឝិនឝ្ច សតក៌ាះ ");
INSERT INTO sankhm_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","សន្តស្តមបវទិតុំ តស្យ កថាយា ទោឞំ ធត៌្តមិច្ឆន្តោ នានាខ្យានកថនាយ តំ ប្រវត៌្តយិតុំ កោបយិតុញ្ច ប្រារេភិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","តទានីំ លោកាះ សហស្រំ សហស្រម៑ អាគត្យ សមុបស្ថិតាស្តត ឯកៃកោ ៜន្យេឞាមុបរិ បតិតុម៑ ឧបចក្រមេ; តទា យីឝុះ ឝិឞ្យាន៑ ពភាឞេ, យូយំ ផិរូឝិនាំ កិណ្វរូបកាបដ្យេ វិឝេឞេណ សាវធានាស្តិឞ្ឋត។ ");
INSERT INTO sankhm_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","យតោ យន្ន ប្រកាឝយិឞ្យតេ តទាច្ឆន្នំ វស្តុ កិមបិ នាស្តិ; តថា យន្ន ជ្ញាស្យតេ តទ៑ គុប្តំ វស្តុ កិមបិ នាស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","អន្ធការេ តិឞ្ឋនតោ យាះ កថា អកថយត តាះ សវ៌្វាះ កថា ទីប្តៅ ឝ្រោឞ្យន្តេ និជ៌នេ កណ៌េ ច យទកថយត គ្ឫហប្ឫឞ្ឋាត៑ តត៑ ប្រចារយិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","ហេ ពន្ធវោ យុឞ្មានហំ វទាមិ, យេ ឝរីរស្យ នាឝំ វិនា កិមប្យបរំ កត៌្តុំ ន ឝក្រុវន្តិ តេភ្យោ មា ភៃឞ្ដ។ ");
INSERT INTO sankhm_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","តហ៌ិ កស្មាទ៑ ភេតវ្យម៑ ឥត្យហំ វទាមិ, យះ ឝរីរំ នាឝយិត្វា នរកំ និក្ឞេប្តុំ ឝក្នោតិ តស្មាទេវ ភយំ កុរុត, បុនរបិ វទាមិ តស្មាទេវ ភយំ កុរុត។ ");
INSERT INTO sankhm_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","បញ្ច ចដកបក្ឞិណះ កិំ ទ្វាភ្យាំ តាម្រខណ្ឌាភ្យាំ ន វិក្រីយន្តេ? តថាបីឝ្វរស្តេឞាម៑ ឯកមបិ ន វិស្មរតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","យុឞ្មាកំ ឝិរះកេឝា អបិ គណិតាះ សន្តិ តស្មាត៑ មា វិភីត ពហុចដកបក្ឞិភ្យោបិ យូយំ ពហុមូល្យាះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","អបរំ យុឞ្មភ្យំ កថយាមិ យះ កឝ្ចិន៑ មានុឞាណាំ សាក្ឞាន៑ មាំ ស្វីករោតិ មនុឞ្យបុត្រ ឦឝ្វរទូតានាំ សាក្ឞាត៑ តំ ស្វីករិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","កិន្តុ យះ កឝ្ចិន្មានុឞាណាំ សាក្ឞាន្មាម៑ អស្វីករោតិ តម៑ ឦឝ្វរស្យ ទូតានាំ សាក្ឞាទ៑ អហម៑ អស្វីករិឞ្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","អន្យច្ច យះ កឝ្ចិន៑ មនុជសុតស្យ និន្ទាភាវេន កាញ្ចិត៑ កថាំ កថយតិ តស្យ តត្បាបស្យ មោចនំ ភវិឞ្យតិ កិន្តុ យទិ កឝ្ចិត៑ បវិត្រម៑ អាត្មានំ និន្ទតិ តហ៌ិ តស្យ តត្បាបស្យ មោចនំ ន ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","យទា លោកា យុឞ្មាន៑ ភជនគេហំ វិចារកត៌្ឫរាជ្យកត៌្ឫណាំ សម្មុខញ្ច នេឞ្យន្តិ តទា កេន ប្រការេណ កិមុត្តរំ វទិឞ្យថ កិំ កថយិឞ្យថ ចេត្យត្រ មា ចិន្តយត; ");
INSERT INTO sankhm_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","យតោ យុឞ្មាភិយ៌ទ៑ យទ៑ វក្តវ្យំ តត៑ តស្មិន៑ សមយឯវ បវិត្រ អាត្មា យុឞ្មាន៑ ឝិក្ឞយិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","តតះ បរំ ជនតាមធ្យស្ថះ កឝ្ចិជ្ជនស្តំ ជគាទ ហេ គុរោ មយា សហ បៃត្ឫកំ ធនំ វិភក្តុំ មម ភ្រាតរមាជ្ញាបយតុ ភវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","កិន្តុ ស តមវទត៑ ហេ មនុឞ្យ យុវយោ រ្វិចារំ វិភាគញ្ច កត៌្តុំ មាំ កោ និយុក្តវាន៑? ");
INSERT INTO sankhm_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","អនន្តរំ ស លោកានវទត៑ លោភេ សាវធានាះ សតក៌ាឝ្ច តិឞ្ឋត, យតោ ពហុសម្បត្តិប្រាប្ត្យា មនុឞ្យស្យាយុ រ្ន ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","បឝ្ចាទ៑ ទ្ឫឞ្ដាន្តកថាមុត្ថាប្យ កថយាមាស, ឯកស្យ ធនិនោ ភូមៅ ពហូនិ ឝស្យានិ ជាតានិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","តតះ ស មនសា ចិន្តយិត្វា កថយាម្ពភូវ មមៃតានិ សមុត្បន្នានិ ទ្រវ្យាណិ ស្ថាបយិតុំ ស្ថានំ នាស្តិ កិំ ករិឞ្យាមិ? ");
INSERT INTO sankhm_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","តតោវទទ៑ ឥត្ថំ ករិឞ្យាមិ, មម សវ៌្វភាណ្ឌាគារាណិ ភង្ក្ត្វា ព្ឫហទ្ភាណ្ឌាគារាណិ និម៌្មាយ តន្មធ្យេ សវ៌្វផលានិ ទ្រវ្យាណិ ច ស្ថាបយិឞ្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","អបរំ និជមនោ វទិឞ្យាមិ, ហេ មនោ ពហុវត្សរាត៌្ហំ នានាទ្រវ្យាណិ សញ្ចិតានិ សន្តិ វិឝ្រាមំ កុរុ ភុក្ត្វា បីត្វា កៅតុកញ្ច កុរុ។ កិន្ត្វីឝ្វរស្តម៑ អវទត៑, ");
INSERT INTO sankhm_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","រេ និព៌ោធ អទ្យ រាត្រៅ តវ ប្រាណាស្ត្វត្តោ នេឞ្យន្តេ តត ឯតានិ យានិ ទ្រវ្យាណិ ត្វយាសាទិតានិ តានិ កស្យ ភវិឞ្យន្តិ? ");
INSERT INTO sankhm_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","អតឯវ យះ កឝ្ចិទ៑ ឦឝ្វរស្យ សមីបេ ធនសញ្ចយមក្ឫត្វា កេវលំ ស្វនិកដេ សញ្ចយំ ករោតិ សោបិ តាទ្ឫឝះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","អថ ស ឝិឞ្យេភ្យះ កថយាមាស, យុឞ្មានហំ វទាមិ, កិំ ខាទិឞ្យាមះ? កិំ បរិធាស្យាមះ? ឥត្យុក្ត្វា ជីវនស្យ ឝរីរស្យ ចាត៌្ហំ ចិន្តាំ មា កាឞ៌្ដ។ ");
INSERT INTO sankhm_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ភក្ឞ្យាជ្ជីវនំ ភូឞណាច្ឆរីរញ្ច ឝ្រេឞ្ឋំ ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","កាកបក្ឞិណាំ កាយ៌្យំ វិចារយត, តេ ន វបន្តិ ឝស្យានិ ច ន ឆិន្ទន្តិ, តេឞាំ ភាណ្ឌាគារាណិ ន សន្តិ កោឞាឝ្ច ន សន្តិ, តថាបីឝ្វរស្តេភ្យោ ភក្ឞ្យាណិ ទទាតិ, យូយំ បក្ឞិភ្យះ ឝ្រេឞ្ឋតរា ន កិំ? ");
INSERT INTO sankhm_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","អបរញ្ច ភាវយិត្វា និជាយុឞះ ក្ឞណមាត្រំ វទ៌្ធយិតុំ ឝក្នោតិ, ឯតាទ្ឫឝោ លាកោ យុឞ្មាកំ មធ្យេ កោស្តិ? ");
INSERT INTO sankhm_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","អតឯវ ក្ឞុទ្រំ កាយ៌្យំ សាធយិតុម៑ អសមត៌្ហា យូយម៑ អន្យស្មិន៑ កាយ៌្យេ កុតោ ភាវយថ? ");
INSERT INTO sankhm_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","អន្យច្ច កាម្បិលបុឞ្បំ កថំ វទ៌្ធតេ តទាបិ វិចារយត, តត៑ កញ្ចន ឝ្រមំ ន ករោតិ តន្តូំឝ្ច ន ជនយតិ កិន្តុ យុឞ្មភ្យំ យថាត៌្ហំ កថយាមិ សុលេមាន៑ ពហ្វៃឝ្វយ៌្យាន្វិតោបិ បុឞ្បស្យាស្យ សទ្ឫឝោ វិភូឞិតោ នាសីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","អទ្យ ក្ឞេត្រេ វត៌្តមានំ ឝ្វឝ្ចូល្ល្យាំ ក្ឞេប្ស្យមានំ យត៑ ត្ឫណំ, តស្មៃ យទីឝ្វរ ឥត្ថំ ភូឞយតិ តហ៌ិ ហេ អល្បប្រត្យយិនោ យុឞ្មាន កិំ ន បរិធាបយិឞ្យតិ? ");
INSERT INTO sankhm_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","អតឯវ កិំ ខាទិឞ្យាមះ? កិំ បរិធាស្យាមះ? ឯតទត៌្ហំ មា ចេឞ្ដធ្វំ មា សំទិគ្ធ្វញ្ច។ ");
INSERT INTO sankhm_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ជគតោ ទេវាច៌្ចកា ឯតានិ សវ៌្វាណិ ចេឞ្ដនតេ; ឯឞុ វស្តុឞុ យុឞ្មាកំ ប្រយោជនមាស្តេ ឥតិ យុឞ្មាកំ បិតា ជានាតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","អតឯវេឝ្វរស្យ រាជ្យាត៌្ហំ សចេឞ្ដា ភវត តថា ក្ឫតេ សវ៌្វាណ្យេតានិ ទ្រវ្យាណិ យុឞ្មភ្យំ ប្រទាយិឞ្យន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","ហេ ក្ឞុទ្រមេឞវ្រជ យូយំ មា ភៃឞ្ដ យុឞ្មភ្យំ រាជ្យំ ទាតុំ យុឞ្មាកំ បិតុះ សម្មតិរស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","អតឯវ យុឞ្មាកំ យា យា សម្បត្តិរស្តិ តាំ តាំ វិក្រីយ វិតរត, យត៑ ស្ថានំ ចៅរា នាគច្ឆន្តិ, កីដាឝ្ច ន ក្ឞាយយន្តិ តាទ្ឫឝេ ស្វគ៌េ និជាត៌្ហម៑ អជរេ សម្បុដកេ ៜក្ឞយំ ធនំ សញ្ចិនុត ច; ");
INSERT INTO sankhm_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","យតោ យត្រ យុឞ្មាកំ ធនំ វត៌្តតេ តត្រេវ យុឞ្មាកំ មនះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","អបរញ្ច យូយំ ប្រទីបំ ជ្វាលយិត្វា ពទ្ធកដយស្តិឞ្ឋត; ");
INSERT INTO sankhm_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ប្រភុ រ្វិវាហាទាគត្យ យទៃវ ទ្វារមាហន្តិ តទៃវ ទ្វារំ មោចយិតុំ យថា ភ្ឫត្យា អបេក្ឞ្យ តិឞ្ឋន្តិ តថា យូយមបិ តិឞ្ឋត។ ");
INSERT INTO sankhm_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","យតះ ប្រភុរាគត្យ យាន៑ ទាសាន៑ សចេតនាន៑ តិឞ្ឋតោ ទ្រក្ឞ្យតិ តឯវ ធន្យាះ; អហំ យុឞ្មាន៑ យថាត៌្ហំ វទាមិ ប្រភុស្តាន៑ ភោជនាត៌្ហម៑ ឧបវេឝ្យ ស្វយំ ពទ្ធកដិះ សមីបមេត្យ បរិវេឞយិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","យទិ ទ្វិតីយេ ត្ឫតីយេ វា ប្រហរេ សមាគត្យ តថៃវ បឝ្យតិ, តហ៌ិ តឯវ ទាសា ធន្យាះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","អបរញ្ច កស្មិន៑ ក្ឞណេ ចៅរា អាគមិឞ្យន្តិ ឥតិ យទិ គ្ឫហបតិ រ្ជ្ញាតុំ ឝក្នោតិ តទាវឝ្យំ ជាគ្រន៑ និជគ្ឫហេ សន្ធិំ កត៌្តយិតុំ វារយតិ យូយមេតទ៑ វិត្ត។ ");
INSERT INTO sankhm_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","អតឯវ យូយមបិ សជ្ជមានាស្តិឞ្ឋត យតោ យស្មិន៑ ក្ឞណេ តំ នាប្រេក្ឞធ្វេ តស្មិន្នេវ ក្ឞណេ មនុឞ្យបុត្រ អាគមិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","តទា បិតរះ បប្រច្ឆ, ហេ ប្រភោ ភវាន៑ កិមស្មាន៑ ឧទ្ទិឝ្យ កិំ សវ៌្វាន៑ ឧទ្ទិឝ្យ ទ្ឫឞ្ដាន្តកថាមិមាំ វទតិ? ");
INSERT INTO sankhm_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","តតះ ប្រភុះ ប្រោវាច, ប្រភុះ សមុចិតកាលេ និជបរិវារាត៌្ហំ ភោជ្យបរិវេឞណាយ យំ តត្បទេ និយោក្ឞ្យតិ តាទ្ឫឝោ វិឝ្វាស្យោ ពោទ្ធា កម៌្មាធីឝះ កោស្តិ? ");
INSERT INTO sankhm_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ប្រភុរាគត្យ យម៑ ឯតាទ្ឫឝេ កម៌្មណិ ប្រវ្ឫត្តំ ទ្រក្ឞ្យតិ សឯវ ទាសោ ធន្យះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","អហំ យុឞ្មាន៑ យថាត៌្ហំ វទាមិ ស តំ និជសវ៌្វស្វស្យាធិបតិំ ករិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","កិន្តុ ប្រភុវ៌ិលម្ពេនាគមិឞ្យតិ, ឥតិ វិចិន្ត្យ ស ទាសោ យទិ តទន្យទាសីទាសាន៑ ប្រហត៌្តុម៑ ភោក្តុំ បាតុំ មទិតុញ្ច ប្រារភតេ, ");
INSERT INTO sankhm_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","តហ៌ិ យទា ប្រភុំ នាបេក្ឞិឞ្យតេ យស្មិន៑ ក្ឞណេ សោៜចេតនឝ្ច ស្ថាស្យតិ តស្មិន្នេវ ក្ឞណេ តស្យ ប្រភុរាគត្យ តំ បទភ្រឞ្ដំ ក្ឫត្វា វិឝ្វាសហីនៃះ សហ តស្យ អំឝំ និរូបយិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","យោ ទាសះ ប្រភេाរាជ្ញាំ ជ្ញាត្វាបិ សជ្ជិតោ ន តិឞ្ឋតិ តទាជ្ញានុសារេណ ច កាយ៌្យំ ន ករោតិ សោនេកាន៑ ប្រហារាន៑ ប្រាប្ស្យតិ; ");
INSERT INTO sankhm_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","កិន្តុ យោ ជនោៜជ្ញាត្វា ប្រហារាហ៌ំ កម៌្ម ករោតិ សោល្បប្រហារាន៑ ប្រាប្ស្យតិ។ យតោ យស្មៃ ពាហុល្យេន ទត្តំ តស្មាទេវ ពាហុល្យេន គ្រហីឞ្យតេ, មានុឞា យស្យ និកដេ ពហុ សមប៌យន្តិ តស្មាទ៑ ពហុ យាចន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","អហំ ប្ឫថិវ្យាម៑ អនៃក្យរូបំ វហ្និ និក្ឞេប្តុម៑ អាគតោស្មិ, ស ចេទ៑ ឥទានីមេវ ប្រជ្វលតិ តត្រ មម កា ចិន្តា? ");
INSERT INTO sankhm_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","កិន្តុ យេន មជ្ជនេនាហំ មគ្នោ ភវិឞ្យាមិ យាវត្កាលំ តស្យ សិទ្ធិ រ្ន ភវិឞ្យតិ តាវទហំ កតិកឞ្ដំ ប្រាប្ស្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","មេលនំ កត៌្តុំ ជគទ៑ អាគតោស្មិ យូយំ កិមិត្ថំ ពោធធ្វេ? យុឞ្មាន៑ វទាមិ ន តថា, កិន្ត្វហំ មេលនាភាវំ កត៌្តុំម៑ អាគតោស្មិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","យស្មាទេតត្កាលមារភ្យ ឯកត្រស្ថបរិជនានាំ មធ្យេ បញ្ចជនាះ ប្ឫថគ៑ ភូត្វា ត្រយោ ជនា ទ្វយោជ៌នយោះ ប្រតិកូលា ទ្វៅ ជនៅ ច ត្រយាណាំ ជនានាំ ប្រតិកូលៅ ភវិឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","បិតា បុត្រស្យ វិបក្ឞះ បុត្រឝ្ច បិតុ រ្វិបក្ឞោ ភវិឞ្យតិ មាតា កន្យាយា វិបក្ឞា កន្យា ច មាតុ រ្វិបក្ឞា ភវិឞ្យតិ, តថា ឝ្វឝ្រូព៌ធ្វា វិបក្ឞា ពធូឝ្ច ឝ្វឝ្រ្វា វិបក្ឞា ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ស លោកេភ្យោបរមបិ កថយាមាស, បឝ្ចិមទិឝិ មេឃោទ្គមំ ទ្ឫឞ្ដ្វា យូយំ ហឋាទ៑ វទថ វ្ឫឞ្ដិ រ្ភវិឞ្យតិ តតស្តថៃវ ជាយតេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","អបរំ ទក្ឞិណតោ វាយៅ វាតិ សតិ វទថ និទាឃោ ភវិឞ្យតិ តតះ សោបិ ជាយតេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","រេ រេ កបដិន អាកាឝស្យ ភូម្យាឝ្ច លក្ឞណំ ពោទ្ធុំ ឝក្នុថ, ");
INSERT INTO sankhm_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","កិន្តុ កាលស្យាស្យ លក្ឞណំ កុតោ ពោទ្ធុំ ន ឝក្នុថ? យូយញ្ច ស្វយំ កុតោ ន ន្យាឞ្យំ វិចារយថ? ");
INSERT INTO sankhm_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","អបរញ្ច វិវាទិនា សាទ៌្ធំ វិចារយិតុះ សមីបំ គច្ឆន៑ បថិ តស្មាទុទ្ធារំ ប្រាប្តុំ យតស្វ នោចេត៑ ស ត្វាំ ធ្ឫត្វា វិចារយិតុះ សមីបំ នយតិ។ វិចារយិតា យទិ ត្វាំ ប្រហត៌្តុះ សមីបំ សមប៌យតិ ប្រហត៌្តា ត្វាំ ការាយាំ ពធ្នាតិ ");
INSERT INTO sankhm_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","តហ៌ិ ត្វាមហំ វទាមិ ត្វយា និះឝេឞំ កបទ៌កេឞុ ន បរិឝោធិតេឞុ ត្វំ តតោ មុក្តិំ ប្រាប្តុំ ន ឝក្ឞ្យសិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","អបរញ្ច បីលាតោ យេឞាំ គាលីលីយានាំ រក្តានិ ពលីនាំ រក្តៃះ សហាមិឝ្រយត៑ តេឞាំ គាលីលីយានាំ វ្ឫត្តាន្តំ កតិបយជនា ឧបស្ថាប្យ យីឝវេ កថយាមាសុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","តតះ ស ប្រត្យុវាច តេឞាំ លោកានាម៑ ឯតាទ្ឫឝី ទុគ៌តិ រ្ឃដិតា តត្ការណាទ៑ យូយំ កិមន្យេភ្យោ គាលីលីយេភ្យោប្យធិកបាបិនស្តាន៑ ពោធធ្វេ? ");
INSERT INTO sankhm_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","យុឞ្មានហំ វទាមិ តថា ន កិន្តុ មនះសុ ន បរាវត៌្តិតេឞុ យូយមបិ តថា នំក្ឞ្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","អបរញ្ច ឝីលោហនាម្ន ឧច្ចគ្ឫហស្យ បតនាទ៑ យេៜឞ្ដាទឝជនា ម្ឫតាស្តេ យិរូឝាលមិ និវាសិសវ៌្វលោកេភ្យោៜធិកាបរាធិនះ កិំ យូយមិត្យំ ពោធធ្វេ? ");
INSERT INTO sankhm_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","យុឞ្មានហំ វទាមិ តថា ន កិន្តុ មនះសុ ន បរិវត៌្តិតេឞុ យូយមបិ តថា នំក្ឞ្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","អនន្តរំ ស ឥមាំ ទ្ឫឞ្ដាន្តកថាមកថយទ៑ ឯកោ ជនោ ទ្រាក្ឞាក្ឞេត្រមធ្យ ឯកមុឌុម្ពរវ្ឫក្ឞំ រោបិតវាន៑។ បឝ្ចាត៑ ស អាគត្យ តស្មិន៑ ផលានិ គវេឞយាមាស, ");
INSERT INTO sankhm_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","កិន្តុ ផលាប្រាប្តេះ ការណាទ៑ ឧទ្យានការំ ភ្ឫត្យំ ជគាទ, បឝ្យ វត្សរត្រយំ យាវទាគត្យ ឯតស្មិន្នុឌុម្ពរតរៅ ក្ឞលាន្យន្វិច្ឆាមិ, កិន្តុ នៃកមបិ ប្រប្នោមិ តរុរយំ កុតោ វ្ឫថា ស្ថានំ វ្យាប្យ តិឞ្ឋតិ? ឯនំ ឆិន្ធិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","តតោ ភ្ឫត្យះ ប្រត្យុវាច, ហេ ប្រភោ បុនវ៌ឞ៌មេកំ ស្ថាតុម៑ អាទិឝ; ឯតស្យ មូលស្យ ចតុទ៌ិក្ឞុ ខនិត្វាហម៑ អាលវាលំ ស្ថាបយាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","តតះ ផលិតុំ ឝក្នោតិ យទិ ន ផលតិ តហ៌ិ បឝ្ចាត៑ ឆេត្ស្យសិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","អថ វិឝ្រាមវារេ ភជនគេហេ យីឝុរុបទិឝតិ ");
INSERT INTO sankhm_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","តស្មិត៑ សមយេ ភូតគ្រស្តត្វាត៑ កុព្ជីភូយាឞ្ដាទឝវឞ៌ាណិ យាវត៑ កេនាប្យុបាយេន ឫជុ រ្ភវិតុំ ន ឝក្នោតិ យា ទុព៌្ពលា ស្ត្រី, ");
INSERT INTO sankhm_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","តាំ តត្រោបស្ថិតាំ វិលោក្យ យីឝុស្តាមាហូយ កថិតវាន៑ ហេ នារិ តវ ទៅព៌្ពល្យាត៑ ត្វំ មុក្តា ភវ។ ");
INSERT INTO sankhm_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","តតះ បរំ តស្យា គាត្រេ ហស្តាប៌ណមាត្រាត៑ សា ឫជុព៌្ហូត្វេឝ្វរស្យ ធន្យវាទំ កត៌្តុមារេភេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","កិន្តុ វិឝ្រាមវារេ យីឝុនា តស្យាះ ស្វាស្ថ្យករណាទ៑ ភជនគេហស្យាធិបតិះ ប្រកុប្យ លោកាន៑ ឧវាច, ឞដ្សុ ទិនេឞុ លោកៃះ កម៌្ម កត៌្តវ្យំ តស្មាទ្ធេតោះ ស្វាស្ថ្យាត៌្ហំ តេឞុ ទិនេឞុ អាគច្ឆត, វិឝ្រាមវារេ មាគច្ឆត។ ");
INSERT INTO sankhm_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","តទា បភុះ ប្រត្យុវាច រេ កបដិនោ យុឞ្មាកម៑ ឯកៃកោ ជនោ វិឝ្រាមវារេ ស្វីយំ ស្វីយំ វ្ឫឞភំ គទ៌ភំ វា ពន្ធនាន្មោចយិត្វា ជលំ បាយយិតុំ កិំ ន នយតិ? ");
INSERT INTO sankhm_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","តហ៌្យាឞ្ដាទឝវត្សរាន៑ យាវត៑ ឝៃតានា ពទ្ធា ឥព្រាហីមះ សន្តតិរិយំ នារី កិំ វិឝ្រាមវារេ ន មោចយិតវ្យា? ");
INSERT INTO sankhm_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ឯឞុ វាក្យេឞុ កថិតេឞុ តស្យ វិបក្ឞាះ សលជ្ជា ជាតាះ កិន្តុ តេន ក្ឫតសវ៌្វមហាកម៌្មការណាត៑ លោកនិវហះ សានន្ទោៜភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","អនន្តរំ សោវទទ៑ ឦឝ្វរស្យ រាជ្យំ កស្យ សទ្ឫឝំ? កេន តទុបមាស្យាមិ? ");
INSERT INTO sankhm_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","យត៑ សឞ៌បពីជំ គ្ឫហីត្វា កឝ្ចិជ្ជន ឧទ្យាន ឧប្តវាន៑ តទ៑ ពីជមង្កុរិតំ សត៑ មហាវ្ឫក្ឞោៜជាយត, តតស្តស្យ ឝាខាសុ វិហាយសីយវិហគា អាគត្យ ន្យូឞុះ, តទ្រាជ្យំ តាទ្ឫឝេន សឞ៌បពីជេន តុល្យំ។ ");
INSERT INTO sankhm_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","បុនះ កថយាមាស, ឦឝ្វរស្យ រាជ្យំ កស្យ សទ្ឫឝំ វទិឞ្យាមិ? យត៑ កិណ្វំ កាចិត៑ ស្ត្រី គ្ឫហីត្វា ទ្រោណត្រយបរិមិតគោធូមចូណ៌េឞុ ស្ថាបយាមាស, ");
INSERT INTO sankhm_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","តតះ ក្រមេណ តត៑ សវ៌្វគោធូមចូណ៌ំ វ្យាប្នោតិ, តស្យ កិណ្វស្យ តុល្យម៑ ឦឝ្វរស្យ រាជ្យំ។ ");
INSERT INTO sankhm_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","តតះ ស យិរូឝាលម្នគរំ ប្រតិ យាត្រាំ ក្ឫត្វា នគរេ នគរេ គ្រាមេ គ្រាមេ សមុបទិឝន៑ ជគាម។ ");
INSERT INTO sankhm_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","តទា កឝ្ចិជ្ជនស្តំ បប្រច្ឆ, ហេ ប្រភោ កិំ កេវលម៑ អល្បេ លោកាះ បរិត្រាស្យន្តេ? ");
INSERT INTO sankhm_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","តតះ ស លោកាន៑ ឧវាច, សំកីណ៌ទ្វារេណ ប្រវេឞ្ដុំ យតឃ្វំ, យតោហំ យុឞ្មាន៑ វទាមិ, ពហវះ ប្រវេឞ្ដុំ ចេឞ្ដិឞ្យន្តេ កិន្តុ ន ឝក្ឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","គ្ឫហបតិនោត្ថាយ ទ្វារេ រុទ្ធេ សតិ យទិ យូយំ ពហិះ ស្ថិត្វា ទ្វារមាហត្យ វទថ, ហេ ប្រភោ ហេ ប្រភោ អស្មត្ការណាទ៑ ទ្វារំ មោចយតុ, តតះ ស ឥតិ ប្រតិវក្ឞ្យតិ, យូយំ កុត្រត្យា លោកា ឥត្យហំ ន ជានាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","តទា យូយំ វទិឞ្យថ, តវ សាក្ឞាទ៑ វយំ ភេाជនំ បានញ្ច ក្ឫតវន្តះ, ត្វញ្ចាស្មាកំ នគរស្យ បថិ សមុបទិឞ្ដវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","កិន្តុ ស វក្ឞ្យតិ, យុឞ្មានហំ វទាមិ, យូយំ កុត្រត្យា លោកា ឥត្យហំ ន ជានាមិ; ហេ ទុរាចារិណោ យូយំ មត្តោ ទូរីភវត។ ");
INSERT INTO sankhm_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","តទា ឥព្រាហីមំ ឥស្ហាកំ យាកូពញ្ច សវ៌្វភវិឞ្យទ្វាទិនឝ្ច ឦឝ្វរស្យ រាជ្យំ ប្រាប្តាន៑ ស្វាំឝ្ច ពហិឞ្ក្ឫតាន៑ ទ្ឫឞ្ដ្វា យូយំ រោទនំ ទន្តៃទ៌ន្តឃឞ៌ណញ្ច ករិឞ្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","អបរញ្ច បូវ៌្វបឝ្ចិមទក្ឞិណោត្តរទិគ្ភ្យោ លោកា អាគត្យ ឦឝ្វរស្យ រាជ្យេ និវត្ស្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","បឝ្យតេត្ថំ ឝេឞីយា លោកា អគ្រា ភវិឞ្យន្តិ, អគ្រីយា លោកាឝ្ច ឝេឞា ភវិឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","អបរញ្ច តស្មិន៑ ទិនេ កិយន្តះ ផិរូឝិន អាគត្យ យីឝុំ ប្រោចុះ, ពហិគ៌ច្ឆ, ស្ថានាទស្មាត៑ ប្រស្ថានំ កុរុ, ហេរោទ៑ ត្វាំ ជិឃាំសតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","តតះ ស ប្រត្យវោចត៑ បឝ្យតាទ្យ ឝ្វឝ្ច ភូតាន៑ វិហាប្យ រោគិណោៜរោគិណះ ក្ឫត្វា ត្ឫតីយេហ្និ សេត្ស្យាមិ, កថាមេតាំ យូយមិត្វា តំ ភូរិមាយំ វទត។ ");
INSERT INTO sankhm_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","តត្រាប្យទ្យ ឝ្វះ បរឝ្វឝ្ច មយា គមនាគមនេ កត៌្តវ្យេ, យតោ ហេតោ រ្យិរូឝាលមោ ពហិះ កុត្រាបិ កោបិ ភវិឞ្យទ្វាទី ន ឃានិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","ហេ យិរូឝាលម៑ ហេ យិរូឝាលម៑ ត្វំ ភវិឞ្យទ្វាទិនោ ហំសិ តវាន្តិកេ ប្រេរិតាន៑ ប្រស្តរៃម៌ារយសិ ច, យថា កុក្កុដី និជបក្ឞាធះ ស្វឝាវកាន៑ សំគ្ឫហ្លាតិ, តថាហមបិ តវ ឝិឝូន៑ សំគ្រហីតុំ កតិវារាន៑ ឰច្ឆំ កិន្តុ ត្វំ នៃច្ឆះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","បឝ្យត យុឞ្មាកំ វាសស្ថានានិ ប្រោច្ឆិទ្យមានានិ បរិត្យក្តានិ ច ភវិឞ្យន្តិ; យុឞ្មានហំ យថាត៌្ហំ វទាមិ, យះ ប្រភោ រ្នាម្នាគច្ឆតិ ស ធន្យ ឥតិ វាចំ យាវត្កាលំ ន វទិឞ្យថ, តាវត្កាលំ យូយំ មាំ ន ទ្រក្ឞ្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","អនន្តរំ វិឝ្រាមវារេ យីឝៅ ប្រធានស្យ ផិរូឝិនោ គ្ឫហេ ភោក្តុំ គតវតិ តេ តំ វីក្ឞិតុម៑ អារេភិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","តទា ជលោទរី តស្យ សម្មុខេ ស្ថិតះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","តតះ ស វ្យវស្ថាបកាន៑ ផិរូឝិនឝ្ច បប្រច្ឆ, វិឝ្រាមវារេ ស្វាស្ថ្យំ កត៌្តវ្យំ ន វា? តតស្តេ កិមបិ ន ប្រត្យូចុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","តទា ស តំ រោគិណំ ស្វស្ថំ ក្ឫត្វា វិសសជ៌; ");
INSERT INTO sankhm_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","តានុវាច ច យុឞ្មាកំ កស្យចិទ៑ គទ៌្ទភោ វ្ឫឞភោ វា ចេទ៑ គត៌្តេ បតតិ តហ៌ិ វិឝ្រាមវារេ តត្ក្ឞណំ ស កិំ តំ នោត្ថាបយិឞ្យតិ? ");
INSERT INTO sankhm_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","តតស្តេ កថាយា ឯតស្យាះ កិមបិ ប្រតិវក្តុំ ន ឝេកុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","អបរញ្ច ប្រធានស្ថានមនោនីតត្វករណំ វិលោក្យ ស និមន្ត្រិតាន៑ ឯតទុបទេឝកថាំ ជគាទ, ");
INSERT INTO sankhm_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","ត្វំ វិវាហាទិភោជ្យេឞុ និមន្ត្រិតះ សន៑ ប្រធានស្ថានេ មោបាវេក្ឞីះ។ ត្វត្តោ គៅរវាន្វិតនិមន្ត្រិតជន អាយាតេ ");
INSERT INTO sankhm_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","និមន្ត្រយិតាគត្យ មនុឞ្យាយៃតស្មៃ ស្ថានំ ទេហីតិ វាក្យំ ចេទ៑ វក្ឞ្យតិ តហ៌ិ ត្វំ សង្កុចិតោ ភូត្វា ស្ថាន ឥតរស្មិន៑ ឧបវេឞ្ដុម៑ ឧទ្យំស្យសិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","អស្មាត៑ ការណាទេវ ត្វំ និមន្ត្រិតោ គត្វាៜប្រធានស្ថាន ឧបវិឝ, តតោ និមន្ត្រយិតាគត្យ វទិឞ្យតិ, ហេ ពន្ធោ ប្រោច្ចស្ថានំ គត្វោបវិឝ, តថា សតិ ភោជនោបវិឞ្ដានាំ សកលានាំ សាក្ឞាត៑ ត្វំ មាន្យោ ភវិឞ្យសិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","យះ កឝ្ចិត៑ ស្វមុន្នមយតិ ស នមយិឞ្យតេ, កិន្តុ យះ កឝ្ចិត៑ ស្វំ នមយតិ ស ឧន្នមយិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","តទា ស និមន្ត្រយិតារំ ជនមបិ ជគាទ, មធ្យាហ្នេ រាត្រៅ វា ភោជ្យេ ក្ឫតេ និជពន្ធុគណោ វា ភ្រាត្ឫृគណោ វា ជ្ញាតិគណោ វា ធនិគណោ វា សមីបវាសិគណោ វា ឯតាន៑ ន និមន្ត្រយ, តថា ក្ឫតេ ចេត៑ តេ ត្វាំ និមន្ត្រយិឞ្យន្តិ, តហ៌ិ បរិឝោធោ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","កិន្តុ យទា ភេជ្យំ ករោឞិ តទា ទរិទ្រឝុឞ្កករខញ្ជាន្ធាន៑ និមន្ត្រយ, ");
INSERT INTO sankhm_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","តត អាឝិឞំ លប្ស្យសេ, តេឞុ បរិឝោធំ កត៌្តុមឝក្នុវត្សុ ឝ្មឝានាទ្ធាម៌្មិកានាមុត្ថានកាលេ ត្វំ ផលាំ លប្ស្យសេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","អនន្តរំ តាំ កថាំ និឝម្យ ភោជនោបវិឞ្ដះ កឝ្ចិត៑ កថយាមាស, យោ ជន ឦឝ្វរស្យ រាជ្យេ ភោក្តុំ លប្ស្យតេ សឯវ ធន្យះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","តតះ ស ឧវាច, កឝ្ចិត៑ ជនោ រាត្រៅ ភេाជ្យំ ក្ឫត្វា ពហូន៑ និមន្ត្រយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","តតោ ភោជនសមយេ និមន្ត្រិតលោកាន៑ អាហ្វាតុំ ទាសទ្វារា កថយាមាស, ខទ្យទ្រវ្យាណិ សវ៌្វាណិ សមាសាទិតានិ សន្តិ, យូយមាគច្ឆត។ ");
INSERT INTO sankhm_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","កិន្តុ តេ សវ៌្វ ឯកៃកំ ឆលំ ក្ឫត្វា ក្ឞមាំ ប្រាត៌្ហយាញ្ចក្រិរេ។ ប្រថមោ ជនះ កថយាមាស, ក្ឞេត្រមេកំ ក្រីតវានហំ តទេវ ទ្រឞ្ដុំ មយា គន្តវ្យម៑, អតឯវ មាំ ក្ឞន្តុំ តំ និវេទយ។ ");
INSERT INTO sankhm_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","អន្យោ ជនះ កថយាមាស, ទឝវ្ឫឞានហំ ក្រីតវាន៑ តាន៑ បរីក្ឞិតុំ យាមិ តស្មាទេវ មាំ ក្ឞន្តុំ តំ និវេទយ។ ");
INSERT INTO sankhm_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","អបរះ កថយាមាស, វ្យូឍវានហំ តស្មាត៑ ការណាទ៑ យាតុំ ន ឝក្នោមិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","បឝ្ចាត៑ ស ទាសោ គត្វា និជប្រភោះ សាក្ឞាត៑ សវ៌្វវ្ឫត្តាន្តំ និវេទយាមាស, តតោសៅ គ្ឫហបតិះ កុបិត្វា ស្វទាសំ វ្យាជហារ, ត្វំ សត្វរំ នគរស្យ សន្និវេឝាន៑ មាគ៌ាំឝ្ច គត្វា ទរិទ្រឝុឞ្កករខញ្ជាន្ធាន៑ អត្រានយ។ ");
INSERT INTO sankhm_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","តតោ ទាសោៜវទត៑, ហេ ប្រភោ ភវត អាជ្ញានុសារេណាក្រិយត តថាបិ ស្ថានមស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","តទា ប្រភុះ បុន រ្ទាសាយាកថយត៑, រាជបថាន៑ វ្ឫក្ឞមូលានិ ច យាត្វា មទីយគ្ឫហបូរណាត៌្ហំ លោកានាគន្តុំ ប្រវត៌្តយ។ ");
INSERT INTO sankhm_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","អហំ យុឞ្មភ្យំ កថយាមិ, បូវ៌្វនិមន្ត្រិតានមេកោបិ មមាស្យ រាត្រិភោជ្យស្យាស្វាទំ ន ប្រាប្ស្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","អនន្តរំ ពហុឞុ លោកេឞុ យីឝោះ បឝ្ចាទ៑ វ្រជិតេឞុ សត្សុ ស វ្យាឃុដ្យ តេភ្យះ កថយាមាស, ");
INSERT INTO sankhm_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","យះ កឝ្ចិន៑ មម សមីបម៑ អាគត្យ ស្វស្យ មាតា បិតា បត្នី សន្តានា ភ្រាតរោ ភគិម្យោ និជប្រាណាឝ្ច, ឯតេភ្យះ សវ៌្វេភ្យោ មយ្យធិកំ ប្រេម ន ករោតិ, ស មម ឝិឞ្យោ ភវិតុំ ន ឝក្ឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","យះ កឝ្ចិត៑ ស្វីយំ ក្រុឝំ វហន៑ មម បឝ្ចាន្ន គច្ឆតិ, សោបិ មម ឝិឞ្យោ ភវិតុំ ន ឝក្ឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","ទុគ៌និម៌្មាណេ កតិវ្យយោ ភវិឞ្យតិ, តថា តស្យ សមាប្តិករណាត៌្ហំ សម្បត្តិរស្តិ ន វា, ប្រថមមុបវិឝ្យ ឯតន្ន គណយតិ, យុឞ្មាកំ មធ្យ ឯតាទ្ឫឝះ កោស្តិ? ");
INSERT INTO sankhm_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","នោចេទ៑ ភិត្តិំ ក្ឫត្វា ឝេឞេ យទិ សមាបយិតុំ ន ឝក្ឞ្យតិ, ");
INSERT INTO sankhm_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","តហ៌ិ មានុឞោយំ និចេតុម៑ អារភត សមាបយិតុំ នាឝក្នោត៑, ឥតិ វ្យាហ្ឫត្យ សវ៌្វេ តមុបហសិឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","អបរញ្ច ភិន្នភូបតិនា សហ យុទ្ធំ កត៌្តុម៑ ឧទ្យម្យ ទឝសហស្រាណិ សៃន្យានិ គ្ឫហីត្វា វិំឝតិសហស្រេះ សៃន្យៃះ សហិតស្យ សមីបវាសិនះ សម្មុខំ យាតុំ ឝក្ឞ្យាមិ ន វេតិ ប្រថមំ ឧបវិឝ្យ ន វិចារយតិ ឯតាទ្ឫឝោ ភូមិបតិះ កះ? ");
INSERT INTO sankhm_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","យទិ ន ឝក្នោតិ តហ៌ិ រិបាវតិទូរេ តិឞ្ឋតិ សតិ និជទូតំ ប្រេឞ្យ សន្ធិំ កត៌្តុំ ប្រាត៌្ហយេត។ ");
INSERT INTO sankhm_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","តទ្វទ៑ យុឞ្មាកំ មធ្យេ យះ កឝ្ចិន៑ មទត៌្ហំ សវ៌្វស្វំ ហាតុំ ន ឝក្នោតិ ស មម ឝិឞ្យោ ភវិតុំ ន ឝក្ឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","លវណម៑ ឧត្តមម៑ ឥតិ សត្យំ, កិន្តុ យទិ លវណស្យ លវណត្វម៑ អបគច្ឆតិ តហ៌ិ តត៑ កថំ ស្វាទុយុក្តំ ភវិឞ្យតិ? ");
INSERT INTO sankhm_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","តទ ភូម្យត៌្ហម៑ អាលវាលរាឝ្យត៌្ហមបិ ភទ្រំ ន ភវតិ; លោកាស្តទ៑ ពហិះ ក្ឞិបន្តិ។ យស្យ ឝ្រោតុំ ឝ្រោត្រេ ស្តះ ស ឝ្ឫណោតុ។ ");
INSERT INTO sankhm_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","តទា ករសញ្ចាយិនះ បាបិនឝ្ច លោកា ឧបទេឝ្កថាំ ឝ្រោតុំ យីឝោះ សមីបម៑ អាគច្ឆន៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","តតះ ផិរូឝិន ឧបាធ្យាយាឝ្ច វិវទមានាះ កថយាមាសុះ ឯឞ មានុឞះ បាបិភិះ សហ ប្រណយំ ក្ឫត្វា តៃះ សាទ៌្ធំ ភុំក្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","តទា ស តេភ្យ ឥមាំ ទ្ឫឞ្ដាន្តកថាំ កថិតវាន៑, ");
INSERT INTO sankhm_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","កស្យចិត៑ ឝតមេឞេឞុ តិឞ្ឋត្មុ តេឞាមេកំ ស យទិ ហារយតិ តហ៌ិ មធ្យេប្រាន្តរម៑ ឯកោនឝតមេឞាន៑ វិហាយ ហារិតមេឞស្យ ឧទ្ទេឝប្រាប្តិបយ៌្យនតំ ន គវេឞយតិ, ឯតាទ្ឫឝោ លោកោ យុឞ្មាកំ មធ្យេ ក អាស្តេ? ");
INSERT INTO sankhm_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","តស្យោទ្ទេឝំ ប្រាប្យ ហ្ឫឞ្ដមនាស្តំ ស្កន្ធេ និធាយ ស្វស្ថានម៑ អានីយ ពន្ធុពាន្ធវសមីបវាសិន អាហូយ វក្តិ, ");
INSERT INTO sankhm_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ហារិតំ មេឞំ ប្រាប្តោហម៑ អតោ ហេតោ រ្មយា សាទ៌្ធម៑ អានន្ទត។ ");
INSERT INTO sankhm_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","តទ្វទហំ យុឞ្មាន៑ វទាមិ, យេឞាំ មនះបរាវត៌្តនស្យ ប្រយោជនំ នាស្តិ, តាទ្ឫឝៃកោនឝតធាម៌្មិកការណាទ៑ យ អានន្ទស្តស្មាទ៑ ឯកស្យ មនះបរិវត៌្តិនះ បាបិនះ ការណាត៑ ស្វគ៌េ ៜធិកានន្ទោ ជាយតេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","អបរញ្ច ទឝានាំ រូប្យខណ្ឌានាម៑ ឯកខណ្ឌេ ហារិតេ ប្រទីបំ ប្រជ្វាល្យ គ្ឫហំ សម្មាជ៌្យ តស្យ ប្រាប្តិំ យាវទ៑ យត្នេន ន គវេឞយតិ, ឯតាទ្ឫឝី យោឞិត៑ កាស្តេ? ");
INSERT INTO sankhm_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ប្រាប្តេ សតិ ពន្ធុពាន្ធវសមីបវាសិនីរាហូយ កថយតិ, ហារិតំ រូប្យខណ្ឌំ ប្រាប្តាហំ តស្មាទេវ មយា សាទ៌្ធម៑ អានន្ទត។ ");
INSERT INTO sankhm_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","តទ្វទហំ យុឞ្មាន៑ វ្យាហរាមិ, ឯកេន បាបិនា មនសិ បរិវត៌្តិតេ, ឦឝ្វរស្យ ទូតានាំ មធ្យេប្យានន្ទោ ជាយតេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","អបរញ្ច ស កថយាមាស, កស្យចិទ៑ ទ្វៅ បុត្រាវាស្តាំ, ");
INSERT INTO sankhm_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","តយោះ កនិឞ្ឋះ បុត្រះ បិត្រេ កថយាមាស, ហេ បិតស្តវ សម្បត្ត្យា យមំឝំ ប្រាប្ស្យាម្យហំ វិភជ្យ តំ ទេហិ, តតះ បិតា និជាំ សម្បត្តិំ វិភជ្យ តាភ្យាំ ទទៅ។ ");
INSERT INTO sankhm_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","កតិបយាត៑ កាលាត៑ បរំ ស កនិឞ្ឋបុត្រះ សមស្តំ ធនំ សំគ្ឫហ្យ ទូរទេឝំ គត្វា ទុឞ្ដាចរណេន សវ៌្វាំ សម្បត្តិំ នាឝយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","តស្យ សវ៌្វធនេ វ្យយំ គតេ តទ្ទេឝេ មហាទុព៌្ហិក្ឞំ ពភូវ, តតស្តស្យ ទៃន្យទឝា ភវិតុម៑ អារេភេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","តតះ បរំ ស គត្វា តទ្ទេឝីយំ គ្ឫហស្ថមេកម៑ អាឝ្រយត; តតះ សតំ ឝូករវ្រជំ ចារយិតុំ ប្រាន្តរំ ប្រេឞយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","កេនាបិ តស្មៃ ភក្ឞ្យាទានាត៑ ស ឝូករផលវល្កលេន បិចិណ្ឌបូរណាំ វវាញ្ឆ។ ");
INSERT INTO sankhm_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ឝេឞេ ស មនសិ ចេតនាំ ប្រាប្យ កថយាមាស, ហា មម បិតុះ សមីបេ កតិ កតិ វេតនភុជោ ទាសា យថេឞ្ដំ តតោធិកញ្ច ភក្ឞ្យំ ប្រាប្នុវន្តិ កិន្ត្វហំ ក្ឞុធា មុមូឞ៌ុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","អហមុត្ថាយ បិតុះ សមីបំ គត្វា កថាមេតាំ វទិឞ្យាមិ, ហេ បិតរ៑ ឦឝ្វរស្យ តវ ច វិរុទ្ធំ បាបមករវម្ ");
INSERT INTO sankhm_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","តវ បុត្រឥតិ វិខ្យាតោ ភវិតុំ ន យោគ្យោស្មិ ច, មាំ តវ វៃតនិកំ ទាសំ ក្ឫត្វា ស្ថាបយ។ ");
INSERT INTO sankhm_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","បឝ្ចាត៑ ស ឧត្ថាយ បិតុះ សមីបំ ជគាម; តតស្តស្យ បិតាតិទូរេ តំ និរីក្ឞ្យ ទយាញ្ចក្រេ, ធាវិត្វា តស្យ កណ្ឋំ គ្ឫហីត្វា តំ ចុចុម្ព ច។ ");
INSERT INTO sankhm_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","តទា បុត្រ ឧវាច, ហេ បិតរ៑ ឦឝ្វរស្យ តវ ច វិរុទ្ធំ បាបមករវំ, តវ បុត្រឥតិ វិខ្យាតោ ភវិតុំ ន យោគ្យោស្មិ ច។ ");
INSERT INTO sankhm_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","កិន្តុ តស្យ បិតា និជទាសាន៑ អាទិទេឝ, សវ៌្វោត្តមវស្ត្រាណ្យានីយ បរិធាបយតៃនំ ហស្តេ ចាង្គុរីយកម៑ អប៌យត បាទយោឝ្ចោបានហៅ សមប៌យត; ");
INSERT INTO sankhm_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","បុឞ្ដំ គោវត្សម៑ អានីយ មារយត ច តំ ភុក្ត្វា វយម៑ អានន្ទាម។ ");
INSERT INTO sankhm_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","យតោ មម បុត្រោយម៑ អម្រិយត បុនរជីវីទ៑ ហារិតឝ្ច លព្ធោភូត៑ តតស្ត អានន្ទិតុម៑ អារេភិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","តត្កាលេ តស្យ ជ្យេឞ្ឋះ បុត្រះ ក្ឞេត្រ អាសីត៑។ អថ ស និវេឝនស្យ និកដំ អាគច្ឆន៑ ន្ឫត្យានាំ វាទ្យានាញ្ច ឝព្ទំ ឝ្រុត្វា ");
INSERT INTO sankhm_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ទាសានាម៑ ឯកម៑ អាហូយ បប្រច្ឆ, កិំ ការណមស្យ? ");
INSERT INTO sankhm_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","តតះ សោវាទីត៑, តវ ភ្រាតាគមត៑, តវ តាតឝ្ច តំ សុឝរីរំ ប្រាប្យ បុឞ្ដំ គោវត្សំ មារិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","តតះ ស ប្រកុប្យ និវេឝនាន្តះ ប្រវេឞ្ដុំ ន សម្មេនេ; តតស្តស្យ បិតា ពហិរាគត្យ តំ សាធយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","តតះ ស បិតរំ ប្រត្យុវាច, បឝ្យ តវ កាញ្ចិទប្យាជ្ញាំ ន វិលំឃ្យ ពហូន៑ វត្សរាន៑ អហំ ត្វាំ សេវេ តថាបិ មិត្រៃះ សាទ៌្ធម៑ ឧត្សវំ កត៌្តុំ កទាបិ ឆាគមេកមបិ មហ្យំ នាទទាះ; ");
INSERT INTO sankhm_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","កិន្តុ តវ យះ បុត្រោ វេឝ្យាគមនាទិភិស្តវ សម្បត្តិម៑ អបវ្យយិតវាន៑ តស្មិន្នាគតមាត្រេ តស្យៃវ និមិត្តំ បុឞ្ដំ គោវត្សំ មារិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","តទា តស្យ បិតាវោចត៑, ហេ បុត្រ ត្វំ សវ៌្វទា មយា សហាសិ តស្មាន៑ មម យទ្យទាស្តេ តត្សវ៌្វំ តវ។ ");
INSERT INTO sankhm_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","កិន្តុ តវាយំ ភ្រាតា ម្ឫតះ បុនរជីវីទ៑ ហារិតឝ្ច ភូត្វា ប្រាប្តោភូត៑, ឯតស្មាត៑ ការណាទ៑ ឧត្សវានន្ទៅ កត៌្តុម៑ ឧចិតមស្មាកម៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","អបរញ្ច យីឝុះ ឝិឞ្យេភ្យោន្យាមេកាំ កថាំ កថយាមាស កស្យចិទ៑ ធនវតោ មនុឞ្យស្យ គ្ឫហកាយ៌្យាធីឝេ សម្បត្តេរបវ្យយេៜបវាទិតេ សតិ ");
INSERT INTO sankhm_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","តស្យ ប្រភុស្តម៑ អាហូយ ជគាទ, ត្វយិ យាមិមាំ កថាំ ឝ្ឫណោមិ សា កីទ្ឫឝី? ត្វំ គ្ឫហកាយ៌្យាធីឝកម៌្មណោ គណនាំ ទឝ៌យ គ្ឫហកាយ៌្យាធីឝបទេ ត្វំ ន ស្ថាស្យសិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","តទា ស គ្ឫហកាយ៌្យាធីឝោ មនសា ចិន្តយាមាស, ប្រភុ រ្យទិ មាំ គ្ឫហកាយ៌្យាធីឝបទាទ៑ ភ្រំឝយតិ តហ៌ិ កិំ ករិឞ្យេៜហំ? ម្ឫទំ ខនិតុំ មម ឝក្តិ រ្នាស្តិ ភិក្ឞិតុញ្ច លជ្ជិឞ្យេៜហំ។ ");
INSERT INTO sankhm_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","អតឯវ មយិ គ្ឫហកាយ៌្យាធីឝបទាត៑ ច្យុតេ សតិ យថា លោកា មហ្យម៑ អាឝ្រយំ ទាស្យន្តិ តទត៌្ហំ យត្កម៌្ម មយា ករណីយំ តន៑ និណ៌ីយតេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","បឝ្ចាត៑ ស ស្វប្រភោរេកៃកម៑ អធមណ៌ម៑ អាហូយ ប្រថមំ បប្រច្ឆ, ត្វត្តោ មេ ប្រភុណា កតិ ប្រាប្យម៑? ");
INSERT INTO sankhm_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","តតះ ស ឧវាច, ឯកឝតាឍកតៃលានិ; តទា គ្ឫហកាយ៌្យាធីឝះ ប្រោវាច, តវ បត្រមានីយ ឝីឃ្រមុបវិឝ្យ តត្រ បញ្ចាឝតំ លិខ។ ");
INSERT INTO sankhm_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","បឝ្ចាទន្យមេកំ បប្រច្ឆ, ត្វត្តោ មេ ប្រភុណា កតិ ប្រាប្យម៑? តតះ សោវាទីទ៑ ឯកឝតាឍកគោធូមាះ; តទា ស កថយាមាស, តវ បត្រមានីយ អឝីតិំ លិខ។ ");
INSERT INTO sankhm_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","តេនៃវ ប្រភុស្តមយថាត៌្ហក្ឫតម៑ អធីឝំ តទ្ពុទ្ធិនៃបុណ្យាត៑ ប្រឝឝំស; ឥត្ថំ ទីប្តិរូបសន្តានេភ្យ ឯតត្សំសារស្យ សន្តានា វត៌្តមានកាលេៜធិកពុទ្ធិមន្តោ ភវន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","អតោ វទាមិ យូយមប្យយថាត៌្ហេន ធនេន មិត្រាណិ លភធ្វំ តតោ យុឞ្មាសុ បទភ្រឞ្ដេឞ្វបិ តានិ ចិរកាលម៑ អាឝ្រយំ ទាស្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","យះ កឝ្ចិត៑ ក្ឞុទ្រេ កាយ៌្យេ វិឝ្វាស្យោ ភវតិ ស មហតិ កាយ៌្យេបិ វិឝ្វាស្យោ ភវតិ, កិន្តុ យះ កឝ្ចិត៑ ក្ឞុទ្រេ កាយ៌្យេៜវិឝ្វាស្យោ ភវតិ ស មហតិ កាយ៌្យេប្យវិឝ្វាស្យោ ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","អតឯវ អយថាត៌្ហេន ធនេន យទិ យូយមវិឝ្វាស្យា ជាតាស្តហ៌ិ សត្យំ ធនំ យុឞ្មាកំ ករេឞុ កះ សមប៌យិឞ្យតិ? ");
INSERT INTO sankhm_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","យទិ ច បរធនេន យូយម៑ អវិឝ្វាស្យា ភវថ តហ៌ិ យុឞ្មាកំ ស្វកីយធនំ យុឞ្មភ្យំ កោ ទាស្យតិ? ");
INSERT INTO sankhm_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","កោបិ ទាស ឧភៅ ប្រភូ សេវិតុំ ន ឝក្នោតិ, យត ឯកស្មិន៑ ប្រីយមាណោៜន្យស្មិន្នប្រីយតេ យទ្វា ឯកំ ជនំ សមាទ្ឫត្យ តទន្យំ តុច្ឆីករោតិ តទ្វទ៑ យូយមបិ ធនេឝ្វរៅ សេវិតុំ ន ឝក្នុថ។ ");
INSERT INTO sankhm_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","តទៃតាះ សវ៌្វាះ កថាះ ឝ្រុត្វា លោភិផិរូឝិនស្តមុបជហសុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","តតះ ស ឧវាច, យូយំ មនុឞ្យាណាំ និកដេ ស្វាន៑ និទ៌ោឞាន៑ ទឝ៌យថ កិន្តុ យុឞ្មាកម៑ អន្តះករណានីឝ្វរោ ជានាតិ, យត៑ មនុឞ្យាណាម៑ អតិ ប្រឝំស្យំ តទ៑ ឦឝ្វរស្យ ឃ្ឫណ្យំ។ ");
INSERT INTO sankhm_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","យោហន អាគមនបយ៌្យនតំ យុឞ្មាកំ សមីបេ វ្យវស្ថាភវិឞ្យទ្វាទិនាំ លេខនានិ ចាសន៑ តតះ ប្រភ្ឫតិ ឦឝ្វររាជ្យស្យ សុសំវាទះ ប្រចរតិ, ឯកៃកោ លោកស្តន្មធ្យំ យត្នេន ប្រវិឝតិ ច។ ");
INSERT INTO sankhm_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","វរំ នភសះ ប្ឫថិវ្យាឝ្ច លោបោ ភវិឞ្យតិ តថាបិ វ្យវស្ថាយា ឯកពិន្ទោរបិ លោបោ ន ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","យះ កឝ្ចិត៑ ស្វីយាំ ភាយ៌្យាំ វិហាយ ស្ត្រិយមន្យាំ វិវហតិ ស បរទារាន៑ គច្ឆតិ, យឝ្ច តា ត្យក្តាំ នារីំ វិវហតិ សោបិ បរទារាន គច្ឆតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ឯកោ ធនី មនុឞ្យះ ឝុក្លានិ សូក្ឞ្មាណិ វស្ត្រាណិ បយ៌្យទធាត៑ ប្រតិទិនំ បរិតោឞរូបេណាភុំក្តាបិវច្ច។ ");
INSERT INTO sankhm_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","សវ៌្វាង្គេ ក្ឞតយុក្ត ឥលិយាសរនាមា កឝ្ចិទ៑ ទរិទ្រស្តស្យ ធនវតោ ភោជនបាត្រាត៑ បតិតម៑ ឧច្ឆិឞ្ដំ ភោក្តុំ វាញ្ឆន៑ តស្យ ទ្វារេ បតិត្វាតិឞ្ឋត៑; ");
INSERT INTO sankhm_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","អថ ឝ្វាន អាគត្យ តស្យ ក្ឞតាន្យលិហន៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","កិយត្កាលាត្បរំ ស ទរិទ្រះ ប្រាណាន៑ ជហៅ; តតះ ស្វគ៌ីយទូតាស្តំ នីត្វា ឥព្រាហីមះ ក្រោឌ ឧបវេឝយាមាសុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","បឝ្ចាត៑ ស ធនវានបិ មមារ, តំ ឝ្មឝានេ ស្ថាបយាមាសុឝ្ច; កិន្តុ បរលោកេ ស វេទនាកុលះ សន៑ ឩទ៌្ធ្វាំ និរីក្ឞ្យ ពហុទូរាទ៑ ឥព្រាហីមំ តត្ក្រោឌ ឥលិយាសរញ្ច វិលោក្យ រុវន្នុវាច; ");
INSERT INTO sankhm_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ហេ បិតរ៑ ឥព្រាហីម៑ អនុគ្ឫហ្យ អង្គុល្យគ្រភាគំ ជលេ មជ្ជយិត្វា មម ជិហ្វាំ ឝីតលាំ កត៌្តុម៑ ឥលិយាសរំ ប្រេរយ, យតោ វហ្និឝិខាតោហំ វ្យថិតោស្មិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","តទា ឥព្រាហីម៑ ពភាឞេ, ហេ បុត្រ ត្វំ ជីវន៑ សម្បទំ ប្រាប្តវាន៑ ឥលិយាសរស្តុ វិបទំ ប្រាប្តវាន៑ ឯតត៑ ស្មរ, កិន្តុ សម្ប្រតិ តស្យ សុខំ តវ ច ទុះខំ ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","អបរមបិ យុឞ្មាកម៑ អស្មាកញ្ច ស្ថានយោ រ្មធ្យេ មហទ្វិច្ឆេទោៜស្តិ តត ឯតត្ស្ថានស្យ លោកាស្តត៑ ស្ថានំ យាតុំ យទ្វា តត្ស្ថានស្យ លោកា ឯតត៑ ស្ថានមាយាតុំ ន ឝក្នុវន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","តទា ស ឧក្តវាន៑, ហេ បិតស្តហ៌ិ ត្វាំ និវេទយាមិ មម បិតុ រ្គេហេ យេ មម បញ្ច ភ្រាតរះ សន្តិ ");
INSERT INTO sankhm_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","តេ យថៃតទ៑ យាតនាស្ថានំ នាយាស្យន្តិ តថា មន្ត្រណាំ ទាតុំ តេឞាំ សមីបម៑ ឥលិយាសរំ ប្រេរយ។ ");
INSERT INTO sankhm_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","តត ឥព្រាហីម៑ ឧវាច, មូសាភវិឞ្យទ្វាទិនាញ្ច បុស្តកានិ តេឞាំ និកដេ សន្តិ តេ តទ្វចនានិ មន្យន្តាំ។ ");
INSERT INTO sankhm_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","តទា ស និវេទយាមាស, ហេ បិតរ៑ ឥព្រាហីម៑ ន តថា, កិន្តុ យទិ ម្ឫតលោកានាំ កឝ្ចិត៑ តេឞាំ សមីបំ យាតិ តហ៌ិ តេ មនាំសិ វ្យាឃោដយិឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","តត ឥព្រាហីម៑ ជគាទ, តេ យទិ មូសាភវិឞ្យទ្វាទិនាញ្ច វចនានិ ន មន្យន្តេ តហ៌ិ ម្ឫតលោកានាំ កស្មិំឝ្ចិទ៑ ឧត្ថិតេបិ តេ តស្យ មន្ត្រណាំ ន មំស្យន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ឥតះ បរំ យីឝុះ ឝិឞ្យាន៑ ឧវាច, វិឃ្នៃរវឝ្យម៑ អាគន្តវ្យំ កិន្តុ វិឃ្នា យេន ឃដិឞ្យន្តេ តស្យ ទុគ៌តិ រ្ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ឯតេឞាំ ក្ឞុទ្រប្រាណិនាម៑ ឯកស្យាបិ វិឃ្នជននាត៑ កណ្ឋពទ្ធបេឞណីកស្យ តស្យ សាគរាគាធជលេ មជ្ជនំ ភទ្រំ។ ");
INSERT INTO sankhm_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","យូយំ ស្វេឞុ សាវធានាស្តិឞ្ឋត; តវ ភ្រាតា យទិ តវ កិញ្ចិទ៑ អបរាធ្យតិ តហ៌ិ តំ តជ៌យ, តេន យទិ មនះ បរិវត៌្តយតិ តហ៌ិ តំ ក្ឞមស្វ។ ");
INSERT INTO sankhm_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","បុនរេកទិនមធ្យេ យទិ ស តវ សប្តក្ឫត្វោៜបរាធ្យតិ កិន្តុ សប្តក្ឫត្វ អាគត្យ មនះ បរិវត៌្យ មយាបរាទ្ធម៑ ឥតិ វទតិ តហ៌ិ តំ ក្ឞមស្វ។ ");
INSERT INTO sankhm_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","តទា ប្រេរិតាះ ប្រភុម៑ អវទន៑ អស្មាកំ វិឝ្វាសំ វទ៌្ធយ។ ");
INSERT INTO sankhm_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ប្រភុរុវាច, យទិ យុឞ្មាកំ សឞ៌បៃកប្រមាណោ វិឝ្វាសោស្តិ តហ៌ិ ត្វំ សមូលមុត្បាដិតោ ភូត្វា សមុទ្រេ រោបិតោ ភវ កថាយាម៑ ឯតស្យាម៑ ឯតទុឌុម្ពរាយ កថិតាយាំ ស យុឞ្មាកមាជ្ញាវហោ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","អបរំ ស្វទាសេ ហលំ វាហយិត្វា វា បឝូន៑ ចារយិត្វា ក្ឞេត្រាទ៑ អាគតេ សតិ តំ វទតិ, ឯហិ ភោក្តុមុបវិឝ, យុឞ្មាកម៑ ឯតាទ្ឫឝះ កោស្តិ? ");
INSERT INTO sankhm_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","វរញ្ច បូវ៌្វំ មម ខាទ្យមាសាទ្យ យាវទ៑ ភុញ្ជេ បិវាមិ ច តាវទ៑ ពទ្ធកដិះ បរិចរ បឝ្ចាត៑ ត្វមបិ ភោក្ឞ្យសេ បាស្យសិ ច កថាមីទ្ឫឝីំ កិំ ន វក្ឞ្យតិ? ");
INSERT INTO sankhm_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","តេន ទាសេន ប្រភោរាជ្ញានុរូបេ កម៌្មណិ ក្ឫតេ ប្រភុះ កិំ តស្មិន៑ ពាធិតោ ជាតះ? នេត្ថំ ពុធ្យតេ មយា។ ");
INSERT INTO sankhm_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ឥត្ថំ និរូបិតេឞុ សវ៌្វកម៌្មសុ ក្ឫតេឞុ សត្មុ យូយមបីទំ វាក្យំ វទថ, វយម៑ អនុបការិណោ ទាសា អស្មាភិយ៌ទ្យត្កត៌្តវ្យំ តន្មាត្រមេវ ក្ឫតំ។ ");
INSERT INTO sankhm_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ស យិរូឝាលមិ យាត្រាំ កុវ៌្វន៑ ឝោមិរោណ្គាលីល្ប្រទេឝមធ្យេន គច្ឆតិ, ");
INSERT INTO sankhm_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ឯតហ៌ិ កុត្រចិទ៑ គ្រាមេ ប្រវេឝមាត្រេ ទឝកុឞ្ឋិនស្តំ សាក្ឞាត៑ ក្ឫត្វា ");
INSERT INTO sankhm_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ទូរេ តិឞ្ឋនត ឧច្ចៃ រ្វក្តុមារេភិរេ, ហេ ប្រភោ យីឝោ ទយស្វាស្មាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","តតះ ស តាន៑ ទ្ឫឞ្ដ្វា ជគាទ, យូយំ យាជកានាំ សមីបេ ស្វាន៑ ទឝ៌យត, តតស្តេ គច្ឆន្តោ រោគាត៑ បរិឞ្ក្ឫតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","តទា តេឞាមេកះ ស្វំ ស្វស្ថំ ទ្ឫឞ្ដ្វា ប្រោច្ចៃរីឝ្វរំ ធន្យំ វទន៑ វ្យាឃុដ្យាយាតោ យីឝោ រ្គុណាននុវទន៑ តច្ចរណាធោភូមៅ បបាត; ");
INSERT INTO sankhm_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ស ចាសីត៑ ឝោមិរោណី។ ");
INSERT INTO sankhm_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","តទា យីឝុរវទត៑, ទឝជនាះ កិំ ន បរិឞ្ក្ឫតាះ? តហ្យន្យេ នវជនាះ កុត្រ? ");
INSERT INTO sankhm_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ឦឝ្វរំ ធន្យំ វទន្តម៑ ឯនំ វិទេឝិនំ វិនា កោប្យន្យោ ន ប្រាប្យត។ ");
INSERT INTO sankhm_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","តទា ស តមុវាច, ត្វមុត្ថាយ យាហិ វិឝ្វាសស្តេ ត្វាំ ស្វស្ថំ ក្ឫតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","អថ កទេឝ្វរស្យ រាជត្វំ ភវិឞ្យតីតិ ផិរូឝិភិះ ប្ឫឞ្ដេ ស ប្រត្យុវាច, ឦឝ្វរស្យ រាជត្វម៑ ឰឝ្វយ៌្យទឝ៌នេន ន ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","អត ឯតស្មិន៑ បឝ្យ តស្មិន៑ វា បឝ្យ, ឥតិ វាក្យំ លោកា វក្តុំ ន ឝក្ឞ្យន្តិ, ឦឝ្វរស្យ រាជត្វំ យុឞ្មាកម៑ អន្តរេវាស្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","តតះ ស ឝិឞ្យាន៑ ជគាទ, យទា យុឞ្មាភិ រ្មនុជសុតស្យ ទិនមេកំ ទ្រឞ្ដុម៑ វាញ្ឆិឞ្យតេ កិន្តុ ន ទឝ៌ិឞ្យតេ, ឦទ្ឫក្កាល អាយាតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","តទាត្រ បឝ្យ វា តត្រ បឝ្យេតិ វាក្យំ លោកា វក្ឞ្យន្តិ, កិន្តុ តេឞាំ បឝ្ចាត៑ មា យាត, មានុគច្ឆត ច។ ");
INSERT INTO sankhm_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","យតស្តឌិទ៑ យថាកាឝៃកទិឝ្យុទិយ តទន្យាមបិ ទិឝំ វ្យាប្យ ប្រកាឝតេ តទ្វត៑ និជទិនេ មនុជសូនុះ ប្រកាឝិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","កិន្តុ តត្បូវ៌្វំ តេនានេកានិ ទុះខានិ ភោក្តវ្យាន្យេតទ្វត៌្តមានលោកៃឝ្ច សោៜវជ្ញាតវ្យះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","នោហស្យ វិទ្យមានកាលេ យថាភវត៑ មនុឞ្យសូនោះ កាលេបិ តថា ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","យាវត្កាលំ នោហោ មហាបោតំ នារោហទ៑ អាប្លាវិវាយ៌្យេត្យ សវ៌្វំ នានាឝយច្ច តាវត្កាលំ យថា លោកា អភុញ្ជតាបិវន៑ វ្យវហន៑ វ្យវាហយំឝ្ច; ");
INSERT INTO sankhm_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ឥត្ថំ លោដោ វត៌្តមានកាលេបិ យថា លោកា ភោជនបានក្រយវិក្រយរោបណគ្ឫហនិម៌្មាណកម៌្មសុ ប្រាវត៌្តន្ត, ");
INSERT INTO sankhm_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","កិន្តុ យទា លោដ៑ សិទោមោ និជ៌គាម តទា នភសះ សគន្ធកាគ្និវ្ឫឞ្ដិ រ្ភូត្វា សវ៌្វំ វ្យនាឝយត្ ");
INSERT INTO sankhm_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","តទ្វន៑ មានវបុត្រប្រកាឝទិនេបិ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","តទា យទិ កឝ្ចិទ៑ គ្ឫហោបរិ តិឞ្ឋតិ តហ៌ិ ស គ្ឫហមធ្យាត៑ កិមបិ ទ្រវ្យមានេតុម៑ អវរុហ្យ នៃតុ; យឝ្ច ក្ឞេត្រេ តិឞ្ឋតិ សោបិ វ្យាឃុដ្យ នាយាតុ។ ");
INSERT INTO sankhm_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","លោដះ បត្នីំ ស្មរត។ ");
INSERT INTO sankhm_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","យះ ប្រាណាន៑ រក្ឞិតុំ ចេឞ្ដិឞ្យតេ ស ប្រាណាន៑ ហារយិឞ្យតិ យស្តុ ប្រាណាន៑ ហារយិឞ្យតិ សឯវ ប្រាណាន៑ រក្ឞិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","យុឞ្មានហំ វច្មិ តស្យាំ រាត្រៅ ឝយ្យៃកគតយោ រ្លោកយោរេកោ ធារិឞ្យតេ បរស្ត្យក្ឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ស្ត្រិយៅ យុគបត៑ បេឞណីំ វ្យាវត៌្តយិឞ្យតស្តយោរេកា ធារិឞ្យតេ បរាត្យក្ឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","បុរុឞៅ ក្ឞេត្រេ ស្ថាស្យតស្តយោរេកោ ធារិឞ្យតេ បរស្ត្យក្ឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","តទា តេ បប្រច្ឆុះ, ហេ ប្រភោ កុត្រេត្ថំ ភវិឞ្យតិ? តតះ ស ឧវាច, យត្រ ឝវស្តិឞ្ឋតិ តត្រ គ្ឫធ្រា មិលន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","អបរញ្ច លោកៃរក្លាន្តៃ រ្និរន្តរំ ប្រាត៌្ហយិតវ្យម៑ ឥត្យាឝយេន យីឝុនា ទ្ឫឞ្ដាន្ត ឯកះ កថិតះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","កុត្រចិន្នគរេ កឝ្ចិត៑ ប្រាឌ្វិវាក អាសីត៑ ស ឦឝ្វរាន្នាពិភេត៑ មានុឞាំឝ្ច នាមន្យត។ ");
INSERT INTO sankhm_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","អថ តត្បុរវាសិនី កាចិទ្វិធវា តត្សមីបមេត្យ វិវាទិនា សហ មម វិវាទំ បរិឞ្កុវ៌្វិតិ និវេទយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","តតះ ស ប្រាឌ្វិវាកះ កិយទ្ទិនានិ ន តទង្គីក្ឫតវាន៑ បឝ្ចាច្ចិត្តេ ចិន្តយាមាស, យទ្យបីឝ្វរាន្ន ពិភេមិ មនុឞ្យានបិ ន មន្យេ ");
INSERT INTO sankhm_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","តថាប្យេឞា វិធវា មាំ ក្លិឝ្នាតិ តស្មាទស្យា វិវាទំ បរិឞ្ករិឞ្យាមិ នោចេត៑ សា សទាគត្យ មាំ វ្យគ្រំ ករិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","បឝ្ចាត៑ ប្រភុរវទទ៑ អសាវន្យាយប្រាឌ្វិវាកោ យទាហ តត្រ មនោ និធធ្វំ។ ");
INSERT INTO sankhm_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ឦឝ្វរស្យ យេ ៜភិរុចិតលោកា ទិវានិឝំ ប្រាត៌្ហយន្តេ ស ពហុទិនានិ វិលម្ព្យាបិ តេឞាំ វិវាទាន៑ កិំ ន បរិឞ្ករិឞ្យតិ? ");
INSERT INTO sankhm_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","យុឞ្មានហំ វទាមិ ត្វរយា បរិឞ្ករិឞ្យតិ, កិន្តុ យទា មនុឞ្យបុត្រ អាគមិឞ្យតិ តទា ប្ឫថិវ្យាំ កិមីទ្ឫឝំ វិឝ្វាសំ ប្រាប្ស្យតិ? ");
INSERT INTO sankhm_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","យេ ស្វាន៑ ធាម៌្មិកាន៑ ជ្ញាត្វា បរាន៑ តុច្ឆីកុវ៌្វន្តិ ឯតាទ្ឫគ្ភ្យះ, កិយទ្ភ្យ ឥមំ ទ្ឫឞ្ដាន្តំ កថយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","ឯកះ ផិរូឝ្យបរះ ករសញ្ចាយី ទ្វាវិមៅ ប្រាត៌្ហយិតុំ មន្ទិរំ គតៅ។ ");
INSERT INTO sankhm_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","តតោៜសៅ ផិរូឝ្យេកបាឝ៌្វេ តិឞ្ឋន៑ ហេ ឦឝ្វរ អហមន្យលោកវត៑ លោឋយិតាន្យាយី បារទារិកឝ្ច ន ភវាមិ អស្យ ករសញ្ចាយិនស្តុល្យឝ្ច ន, តស្មាត្ត្វាំ ធន្យំ វទាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","សប្តសុ ទិនេឞុ ទិនទ្វយមុបវសាមិ សវ៌្វសម្បត្តេ រ្ទឝមាំឝំ ទទាមិ ច, ឯតត្កថាំ កថយន៑ ប្រាត៌្ហយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","កិន្តុ ស ករសញ្ចាយិ ទូរេ តិឞ្ឋន៑ ស្វគ៌ំ ទ្រឞ្ដុំ នេច្ឆន៑ វក្ឞសិ ករាឃាតំ កុវ៌្វន៑ ហេ ឦឝ្វរ បាបិឞ្ឋំ មាំ ទយស្វ, ឥត្ថំ ប្រាត៌្ហយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","យុឞ្មានហំ វទាមិ, តយោទ៌្វយោ រ្មធ្យេ កេវលះ ករសញ្ចាយី បុណ្យវត្ត្វេន គណិតោ និជគ្ឫហំ ជគាម, យតោ យះ កឝ្ចិត៑ ស្វមុន្នមយតិ ស នាមយិឞ្យតេ កិន្តុ យះ កឝ្ចិត៑ ស្វំ នមយតិ ស ឧន្នមយិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","អថ ឝិឝូនាំ គាត្រស្បឝ៌ាត៌្ហំ លោកាស្តាន៑ តស្យ សមីបមានិន្យុះ ឝិឞ្យាស្តទ៑ ទ្ឫឞ្ដ្វានេត្ឫន៑ តជ៌យាមាសុះ, ");
INSERT INTO sankhm_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","កិន្តុ យីឝុស្តានាហូយ ជគាទ, មន្និកដម៑ អាគន្តុំ ឝិឝូន៑ អនុជានីធ្វំ តាំឝ្ច មា វារយត; យត ឦឝ្វររាជ្យាធិការិណ ឯឞាំ សទ្ឫឝាះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","អហំ យុឞ្មាន៑ យថាត៌្ហំ វទាមិ, យោ ជនះ ឝិឝោះ សទ្ឫឝោ ភូត្វា ឦឝ្វររាជ្យំ ន គ្ឫហ្លាតិ ស កេនាបិ ប្រការេណ តត៑ ប្រវេឞ្ដុំ ន ឝក្នោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","អបរម៑ ឯកោធិបតិស្តំ បប្រច្ឆ, ហេ បរមគុរោ, អនន្តាយុឞះ ប្រាប្តយេ មយា កិំ កត៌្តវ្យំ? ");
INSERT INTO sankhm_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","យីឝុរុវាច, មាំ កុតះ បរមំ វទសិ? ឦឝ្វរំ វិនា កោបិ បរមោ ន ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","បរទារាន៑ មា គច្ឆ, នរំ មា ជហិ, មា ចោរយ, មិថ្យាសាក្ឞ្យំ មា ទេហិ, មាតរំ បិតរញ្ច សំមន្យស្វ, ឯតា យា អាជ្ញាះ សន្តិ តាស្ត្វំ ជានាសិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","តទា ស ឧវាច, ពាល្យកាលាត៑ សវ៌្វា ឯតា អាចរាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ឥតិ កថាំ ឝ្រុត្វា យីឝុស្តមវទត៑, តថាបិ តវៃកំ កម៌្ម ន្យូនមាស្តេ, និជំ សវ៌្វស្វំ វិក្រីយ ទរិទ្រេភ្យោ វិតរ, តស្មាត៑ ស្វគ៌េ ធនំ ប្រាប្ស្យសិ; តត អាគត្យ មមានុគាមី ភវ។ ");
INSERT INTO sankhm_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","កិន្ត្វេតាំ កថាំ ឝ្រុត្វា សោធិបតិះ ឝុឝោច, យតស្តស្យ ពហុធនមាសីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","តទា យីឝុស្តមតិឝោកាន្វិតំ ទ្ឫឞ្ដ្វា ជគាទ, ធនវតាម៑ ឦឝ្វររាជ្យប្រវេឝះ កីទ្ឫគ៑ ទុឞ្ករះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ឦឝ្វររាជ្យេ ធនិនះ ប្រវេឝាត៑ សូចេឝ្ឆិទ្រេណ មហាង្គស្យ គមនាគមនេ សុករេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ឝ្រោតារះ បប្រច្ឆុស្តហ៌ិ កេន បរិត្រាណំ ប្រាប្ស្យតេ? ");
INSERT INTO sankhm_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ស ឧក្តវាន៑, យន៑ មានុឞេណាឝក្យំ តទ៑ ឦឝ្វរេណ ឝក្យំ។ ");
INSERT INTO sankhm_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","តទា បិតរ ឧវាច, បឝ្យ វយំ សវ៌្វស្វំ បរិត្យជ្យ តវ បឝ្ចាទ្គាមិនោៜភវាម។ ");
INSERT INTO sankhm_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","តតះ ស ឧវាច, យុឞ្មានហំ យថាត៌្ហំ វទាមិ, ឦឝ្វររាជ្យាត៌្ហំ គ្ឫហំ បិតរៅ ភ្រាត្ឫគណំ ជាយាំ សន្តានាំឝ្ច ត្យក្តវា ");
INSERT INTO sankhm_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ឥហ កាលេ តតោៜធិកំ បរកាលេ ៜនន្តាយុឝ្ច ន ប្រាប្ស្យតិ លោក ឦទ្ឫឝះ កោបិ នាស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","អនន្តរំ ស ទ្វាទឝឝិឞ្យានាហូយ ពភាឞេ, បឝ្យត វយំ យិរូឝាលម្នគរំ យាមះ, តស្មាត៑ មនុឞ្យបុត្រេ ភវិឞ្យទ្វាទិភិរុក្តំ យទស្តិ តទនុរូបំ តំ ប្រតិ ឃដិឞ្យតេ; ");
INSERT INTO sankhm_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","វស្តុតស្តុ សោៜន្យទេឝីយានាំ ហស្តេឞុ សមប៌យិឞ្យតេ, តេ តមុបហសិឞ្យន្តិ, អន្យាយមាចរិឞ្យន្តិ តទ្វបុឞិ និឞ្ឋីវំ និក្ឞេប្ស្យន្តិ, កឝាភិះ ប្រហ្ឫត្យ តំ ហនិឞ្យន្តិ ច, ");
INSERT INTO sankhm_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","កិន្តុ ត្ឫតីយទិនេ ស ឝ្មឝានាទ៑ ឧត្ថាស្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ឯតស្យាះ កថាយា អភិប្រាយំ កិញ្ចិទបិ តេ ពោទ្ធុំ ន ឝេកុះ តេឞាំ និកដេៜស្បឞ្ដតវាត៑ តស្យៃតាសាំ កថានាម៑ អាឝយំ តេ ជ្ញាតុំ ន ឝេកុឝ្ច។ ");
INSERT INTO sankhm_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","អថ តស្មិន៑ យិរីហោះ បុរស្យាន្តិកំ ប្រាប្តេ កឝ្ចិទន្ធះ បថះ បាឝ៌្វ ឧបវិឝ្យ ភិក្ឞាម៑ អករោត្ ");
INSERT INTO sankhm_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ស លោកសមូហស្យ គមនឝព្ទំ ឝ្រុត្វា តត្ការណំ ប្ឫឞ្ដវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","នាសរតីយយីឝុយ៌ាតីតិ លោកៃរុក្តេ ស ឧច្ចៃវ៌ក្តុមារេភេ, ");
INSERT INTO sankhm_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ហេ ទាយូទះ សន្តាន យីឝោ មាំ ទយស្វ។ ");
INSERT INTO sankhm_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","តតោគ្រគាមិនស្តំ មៅនី តិឞ្ឋេតិ តជ៌យាមាសុះ កិន្តុ ស បុនារុវន៑ ឧវាច, ហេ ទាយូទះ សន្តាន មាំ ទយស្វ។ ");
INSERT INTO sankhm_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","តទា យីឝុះ ស្ថគិតោ ភូត្វា ស្វាន្តិកេ តមានេតុម៑ អាទិទេឝ។ ");
INSERT INTO sankhm_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","តតះ ស តស្យាន្តិកម៑ អាគមត៑, តទា ស តំ បប្រច្ឆ, ត្វំ កិមិច្ឆសិ? ត្វទត៌្ហមហំ កិំ ករិឞ្យាមិ? ស ឧក្តវាន៑, ហេ ប្រភោៜហំ ទ្រឞ្ដុំ លភៃ។ ");
INSERT INTO sankhm_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","តទា យីឝុរុវាច, ទ្ឫឞ្ដិឝក្តិំ គ្ឫហាណ តវ ប្រត្យយស្ត្វាំ ស្វស្ថំ ក្ឫតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","តតស្តត្ក្ឞណាត៑ តស្យ ចក្ឞុឞី ប្រសន្នេ; តស្មាត៑ ស ឦឝ្វរំ ធន្យំ វទន៑ តត្បឝ្ចាទ៑ យយៅ, តទាលោក្យ សវ៌្វេ លោកា ឦឝ្វរំ ប្រឝំសិតុម៑ អារេភិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","យទា យីឝុ រ្យិរីហោបុរំ ប្រវិឝ្យ តន្មធ្យេន គច្ឆំស្តទា ");
INSERT INTO sankhm_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","សក្កេយនាមា ករសញ្ចាយិនាំ ប្រធានោ ធនវានេកោ ");
INSERT INTO sankhm_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","យីឝុះ កីទ្ឫគិតិ ទ្រឞ្ដុំ ចេឞ្ដិតវាន៑ កិន្តុ ខវ៌្វត្វាល្លោកសំឃមធ្យេ តទ្ទឝ៌នមប្រាប្យ ");
INSERT INTO sankhm_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","យេន បថា ស យាស្យតិ តត្បថេៜគ្រេ ធាវិត្វា តំ ទ្រឞ្ដុម៑ ឧឌុម្ពរតរុមារុរោហ។ ");
INSERT INTO sankhm_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","បឝ្ចាទ៑ យីឝុស្តត្ស្ថានម៑ ឥត្វា ឩទ៌្ធ្វំ វិលោក្យ តំ ទ្ឫឞ្ដ្វាវាទីត៑, ហេ សក្កេយ ត្វំ ឝីឃ្រមវរោហ មយាទ្យ ត្វទ្គេហេ វស្តវ្យំ។ ");
INSERT INTO sankhm_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","តតះ ស ឝីឃ្រមវរុហ្យ សាហ្លាទំ តំ ជគ្រាហ។ ");
INSERT INTO sankhm_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","តទ៑ ទ្ឫឞ្ដ្វា សវ៌្វេ វិវទមានា វក្តុមារេភិរេ, សោតិថិត្វេន ទុឞ្ដលោកគ្ឫហំ គច្ឆតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","កិន្តុ សក្កេយោ ទណ្ឌាយមានោ វក្តុមារេភេ, ហេ ប្រភោ បឝ្យ មម យា សម្បត្តិរស្តិ តទទ៌្ធំ ទរិទ្រេភ្យោ ទទេ, អបរម៑ អន្យាយំ ក្ឫត្វា កស្មាទបិ យទិ កទាបិ កិញ្ចិត៑ មយា គ្ឫហីតំ តហ៌ិ តច្ចតុគ៌ុណំ ទទាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","តទា យីឝុស្តមុក្តវាន៑ អយមបិ ឥព្រាហីមះ សន្តានោៜតះ ការណាទ៑ អទ្យាស្យ គ្ឫហេ ត្រាណមុបស្ថិតំ។ ");
INSERT INTO sankhm_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","យទ៑ ហារិតំ តត៑ ម្ឫគយិតុំ រក្ឞិតុញ្ច មនុឞ្យបុត្រ អាគតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","អថ ស យិរូឝាលមះ សមីប ឧបាតិឞ្ឋទ៑ ឦឝ្វររាជត្វស្យានុឞ្ឋានំ តទៃវ ភវិឞ្យតីតិ លោកៃរន្វភូយត, តស្មាត៑ ស ឝ្រោត្ឫភ្យះ បុនទ៌្ឫឞ្ដាន្តកថាម៑ ឧត្ថាប្យ កថយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","កោបិ មហាល្លោកោ និជាត៌្ហំ រាជត្វបទំ គ្ឫហីត្វា បុនរាគន្តុំ ទូរទេឝំ ជគាម។ ");
INSERT INTO sankhm_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","យាត្រាកាលេ និជាន៑ ទឝទាសាន៑ អាហូយ ទឝស្វណ៌មុទ្រា ទត្ត្វា មមាគមនបយ៌្យន្តំ វាណិជ្យំ កុរុតេត្យាទិទេឝ។ ");
INSERT INTO sankhm_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","កិន្តុ តស្យ ប្រជាស្តមវជ្ញាយ មនុឞ្យមេនម៑ អស្មាកមុបរិ រាជត្វំ ន ការយិវ្យាម ឥមាំ វាត៌្តាំ តន្និកដេ ប្រេរយាមាសុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","អថ ស រាជត្វបទំ ប្រាប្យាគតវាន៑ ឯកៃកោ ជនោ ពាណិជ្យេន កិំ លព្ធវាន៑ ឥតិ ជ្ញាតុំ យេឞុ ទាសេឞុ មុទ្រា អប៌យត៑ តាន៑ អាហូយានេតុម៑ អាទិទេឝ។ ");
INSERT INTO sankhm_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","តទា ប្រថម អាគត្យ កថិតវាន៑, ហេ ប្រភោ តវ តយៃកយា មុទ្រយា ទឝមុទ្រា លព្ធាះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","តតះ ស ឧវាច ត្វមុត្តមោ ទាសះ ស្វល្បេន វិឝ្វាស្យោ ជាត ឥតះ ការណាត៑ ត្វំ ទឝនគរាណាម៑ អធិបោ ភវ។ ");
INSERT INTO sankhm_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","ទ្វិតីយ អាគត្យ កថិតវាន៑, ហេ ប្រភោ តវៃកយា មុទ្រយា បញ្ចមុទ្រា លព្ធាះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","តតះ ស ឧវាច, ត្វំ បញ្ចានាំ នគរាណាមធិបតិ រ្ភវ។ ");
INSERT INTO sankhm_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","តតោន្យ អាគត្យ កថយាមាស, ហេ ប្រភោ បឝ្យ តវ យា មុទ្រា អហំ វស្ត្រេ ពទ្ធ្វាស្ថាបយំ សេយំ។ ");
INSERT INTO sankhm_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ត្វំ ក្ឫបណោ យន្នាស្ថាបយស្តទបិ គ្ឫហ្លាសិ, យន្នាវបស្តទេវ ច ឆិនត្សិ តតោហំ ត្វត្តោ ភីតះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","តទា ស ជគាទ, រេ ទុឞ្ដទាស តវ វាក្យេន ត្វាំ ទោឞិណំ ករិឞ្យាមិ, យទហំ នាស្ថាបយំ តទេវ គ្ឫហ្លាមិ, យទហំ នាវបញ្ច តទេវ ឆិនទ្មិ, ឯតាទ្ឫឝះ ក្ឫបណោហមិតិ យទិ ត្វំ ជានាសិ, ");
INSERT INTO sankhm_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","តហ៌ិ មម មុទ្រា ពណិជាំ និកដេ កុតោ នាស្ថាបយះ? តយា ក្ឫតេៜហម៑ អាគត្យ កុសីទេន សាទ៌្ធំ និជមុទ្រា អប្រាប្ស្យម៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","បឝ្ចាត៑ ស សមីបស្ថាន៑ ជនាន៑ អាជ្ញាបយត៑ អស្មាត៑ មុទ្រា អានីយ យស្យ ទឝមុទ្រាះ សន្តិ តស្មៃ ទត្ត។ ");
INSERT INTO sankhm_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","តេ ប្រោចុះ ប្រភោៜស្យ ទឝមុទ្រាះ សន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","យុឞ្មានហំ វទាមិ យស្យាឝ្រយេ វទ្ធតេ ៜធិកំ តស្មៃ ទាយិឞ្យតេ, កិន្តុ យស្យាឝ្រយេ ន វទ៌្ធតេ តស្យ យទ្យទស្តិ តទបិ តស្មាន៑ នាយិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","កិន្តុ មមាធិបតិត្វស្យ វឝត្វេ ស្ថាតុម៑ អសម្មន្យមានា យេ មម រិបវស្តានានីយ មម សមក្ឞំ សំហរត។ ");
INSERT INTO sankhm_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ឥត្យុបទេឝកថាំ កថយិត្វា សោគ្រគះ សន៑ យិរូឝាលមបុរំ យយៅ។ ");
INSERT INTO sankhm_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","តតោ ពៃត្ផគីពៃថនីយាគ្រាមយោះ សមីបេ ជៃតុនាទ្រេរន្តិកម៑ ឥត្វា ឝិឞ្យទ្វយម៑ ឥត្យុក្ត្វា ប្រេឞយាមាស, ");
INSERT INTO sankhm_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","យុវាមមុំ សម្មុខស្ថគ្រាមំ ប្រវិឝ្យៃវ យំ កោបិ មានុឞះ កទាបិ នារោហត៑ តំ គទ៌្ទភឝាវកំ ពទ្ធំ ទ្រក្ឞ្យថស្តំ មោចយិត្វានយតំ។ ");
INSERT INTO sankhm_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","តត្រ កុតោ មោចយថះ? ឥតិ ចេត៑ កោបិ វក្ឞ្យតិ តហ៌ិ វក្ឞ្យថះ ប្រភេाរត្រ ប្រយោជនម៑ អាស្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","តទា តៅ ប្ររិតៅ គត្វា តត្កថាाនុសារេណ សវ៌្វំ ប្រាប្តៅ។ ");
INSERT INTO sankhm_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","គទ៌ភឝាវកមោចនកាលេ តត្វាមិន ឩចុះ, គទ៌ភឝាវកំ កុតោ មោចយថះ? ");
INSERT INTO sankhm_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","តាវូចតុះ ប្រភោរត្រ ប្រយោជនម៑ អាស្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","បឝ្ចាត៑ តៅ តំ គទ៌ភឝាវកំ យីឝោរន្តិកមានីយ តត្ប្ឫឞ្ឋេ និជវសនានិ បាតយិត្វា តទុបរិ យីឝុមារោហយាមាសតុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","អថ យាត្រាកាលេ លោកាះ បថិ ស្វវស្ត្រាណិ បាតយិតុម៑ អារេភិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","អបរំ ជៃតុនាទ្រេរុបត្យកាម៑ ឥត្វា ឝិឞ្យសំឃះ បូវ៌្វទ្ឫឞ្ដានិ មហាកម៌្មាណិ ស្ម្ឫត្វា, ");
INSERT INTO sankhm_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","យោ រាជា ប្រភោ រ្នាម្នាយាតិ ស ធន្យះ ស្វគ៌េ កុឝលំ សវ៌្វោច្ចេ ជយធ្វនិ រ្ភវតុ, កថាមេតាំ កថយិត្វា សានន្ទម៑ ឧចៃរីឝ្វរំ ធន្យំ វក្តុមារេភេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","តទា លោការណ្យមធ្យស្ថាះ កិយន្តះ ផិរូឝិនស្តត៑ ឝ្រុត្វា យីឝុំ ប្រោចុះ, ហេ ឧបទេឝក ស្វឝិឞ្យាន៑ តជ៌យ។ ");
INSERT INTO sankhm_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ស ឧវាច, យុឞ្មានហំ វទាមិ យទ្យមី នីរវាស្តិឞ្ឋន្តិ តហ៌ិ បាឞាណា ឧចៃះ កថាះ កថយិឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","បឝ្ចាត៑ តត្បុរាន្តិកមេត្យ តទវលោក្យ សាឝ្រុបាតំ ជគាទ, ");
INSERT INTO sankhm_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ហា ហា ចេត៑ ត្វមគ្រេៜជ្ញាស្យថាះ, តវាស្មិន្នេវ ទិនេ វា យទិ ស្វមង្គលម៑ ឧបាលប្ស្យថាះ, តហ៌្យុត្តមម៑ អភវិឞ្យត៑, កិន្តុ ក្ឞណេស្មិន៑ តត្តវ ទ្ឫឞ្ដេរគោចរម៑ ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ត្វំ ស្វត្រាណកាលេ ន មនោ ន្យធត្ថា ឥតិ ហេតោ រ្យត្កាលេ តវ រិបវស្ត្វាំ ចតុទ៌ិក្ឞុ ប្រាចីរេណ វេឞ្ដយិត្វា រោត្ស្យន្តិ ");
INSERT INTO sankhm_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ពាលកៃះ សាទ៌្ធំ ភូមិសាត៑ ករិឞ្យន្តិ ច ត្វន្មធ្យេ បាឞាណៃកោបិ បាឞាណោបរិ ន ស្ថាស្យតិ ច, កាល ឦទ្ឫឝ ឧបស្ថាស្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","អថ មធ្យេមន្ទិរំ ប្រវិឝ្យ តត្រត្យាន៑ ក្រយិវិក្រយិណោ ពហិឞ្កុវ៌្វន្ ");
INSERT INTO sankhm_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","អវទត៑ មទ្គ្ឫហំ ប្រាត៌្ហនាគ្ឫហមិតិ លិបិរាស្តេ កិន្តុ យូយំ តទេវ ចៃរាណាំ គហ្វរំ កុរុថ។ ");
INSERT INTO sankhm_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","បឝ្ចាត៑ ស ប្រត្យហំ មធ្យេមន្ទិរម៑ ឧបទិទេឝ; តតះ ប្រធានយាជកា អធ្យាបកាះ ប្រាចីនាឝ្ច តំ នាឝយិតុំ ចិចេឞ្ដិរេ; ");
INSERT INTO sankhm_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","កិន្តុ តទុបទេឝេ សវ៌្វេ លោកា និវិឞ្ដចិត្តាះ ស្ថិតាស្តស្មាត៑ តេ តត្កត៌្តុំ នាវកាឝំ ប្រាបុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","អថៃកទា យីឝុ រ្មនិទរេ សុសំវាទំ ប្រចារយន៑ លោកានុបទិឝតិ, ឯតហ៌ិ ប្រធានយាជកា អធ្យាបកាះ ប្រាញ្ចឝ្ច តន្និកដមាគត្យ បប្រច្ឆុះ ");
INSERT INTO sankhm_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","កយាជ្ញយា ត្វំ កម៌្មាណ្យេតានិ ករោឞិ? កោ វា ត្វាមាជ្ញាបយត៑? តទស្មាន៑ វទ។ ");
INSERT INTO sankhm_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ស ប្រត្យុវាច, តហ៌ិ យុឞ្មានបិ កថាមេកាំ ប្ឫច្ឆាមិ តស្យោត្តរំ វទត។ ");
INSERT INTO sankhm_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","យោហនោ មជ្ជនម៑ ឦឝ្វរស្យ មានុឞាណាំ វាជ្ញាតោ ជាតំ? ");
INSERT INTO sankhm_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","តតស្តេ មិថោ វិវិច្យ ជគទុះ, យទីឝ្វរស្យ វទាមស្តហ៌ិ តំ កុតោ ន ប្រត្យៃត ស ឥតិ វក្ឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","យទិ មនុឞ្យស្យេតិ វទាមស្តហ៌ិ សវ៌្វេ លោកា អស្មាន៑ បាឞាណៃ រ្ហនិឞ្យន្តិ យតោ យោហន៑ ភវិឞ្យទ្វាទីតិ សវ៌្វេ ទ្ឫឍំ ជានន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","អតឯវ តេ ប្រត្យូចុះ កស្យាជ្ញយា ជាតម៑ ឥតិ វក្តុំ ន ឝក្នុមះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","តទា យីឝុរវទត៑ តហ៌ិ កយាជ្ញយា កម៌្មាណ្យេតាតិ ករោមីតិ ច យុឞ្មាន៑ ន វក្ឞ្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","អថ លោកានាំ សាក្ឞាត៑ ស ឥមាំ ទ្ឫឞ្ដាន្តកថាំ វក្តុមារេភេ, កឝ្ចិទ៑ ទ្រាក្ឞាក្ឞេត្រំ ក្ឫត្វា តត៑ ក្ឞេត្រំ ក្ឫឞីវលានាំ ហស្តេឞុ សមប៌្យ ពហុកាលាត៌្ហំ ទូរទេឝំ ជគាម។ ");
INSERT INTO sankhm_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","អថ ផលកាលេ ផលានិ គ្រហីតុ ក្ឫឞីវលានាំ សមីបេ ទាសំ ប្រាហិណោត៑ កិន្តុ ក្ឫឞីវលាស្តំ ប្រហ្ឫត្យ រិក្តហស្តំ វិសសជ៌ុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","តតះ សោធិបតិះ បុនរន្យំ ទាសំ ប្រេឞយាមាស, តេ តមបិ ប្រហ្ឫត្យ កុវ្យវហ្ឫត្យ រិក្តហស្តំ វិសស្ឫជុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","តតះ ស ត្ឫតីយវារម៑ អន្យំ ប្រាហិណោត៑ តេ តមបិ ក្ឞតាង្គំ ក្ឫត្វា ពហិ រ្និចិក្ឞិបុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","តទា ក្ឞេត្របតិ រ្វិចារយាមាស, មមេទានីំ កិំ កត៌្តវ្យំ? មម ប្រិយេ បុត្រេ ប្រហិតេ តេ តមវឝ្យំ ទ្ឫឞ្ដ្វា សមាទរិឞ្យន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","កិន្តុ ក្ឫឞីវលាស្តំ និរីក្ឞ្យ បរស្បរំ វិវិច្យ ប្រោចុះ, អយមុត្តរាធិការី អាគច្ឆតៃនំ ហន្មស្តតោធិការោស្មាកំ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","តតស្តេ តំ ក្ឞេត្រាទ៑ ពហិ រ្និបាត្យ ជឃ្នុស្តស្មាត៑ ស ក្ឞេត្របតិស្តាន៑ ប្រតិ កិំ ករិឞ្យតិ? ");
INSERT INTO sankhm_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ស អាគត្យ តាន៑ ក្ឫឞីវលាន៑ ហត្វា បរេឞាំ ហស្តេឞុ តត្ក្ឞេត្រំ សមប៌យិឞ្យតិ; ឥតិ កថាំ ឝ្រុត្វា តេ ៜវទន៑ ឯតាទ្ឫឝី ឃដនា ន ភវតុ។ ");
INSERT INTO sankhm_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","កិន្តុ យីឝុស្តានវលោក្យ ជគាទ, តហ៌ិ, ស្ថបតយះ ករិឞ្យន្តិ គ្រាវាណំ យន្តុ តុច្ឆកំ។ ប្រធានប្រស្តរះ កោណេ ស ឯវ ហិ ភវិឞ្យតិ។ ឯតស្យ ឝាស្ត្រីយវចនស្យ កិំ តាត្បយ៌្យំ? ");
INSERT INTO sankhm_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","អបរំ តត្បាឞាណោបរិ យះ បតិឞ្យតិ ស ភំក្ឞ្យតេ កិន្តុ យស្យោបរិ ស បាឞាណះ បតិឞ្យតិ ស តេន ធូលិវច៑ ចូណ៌ីភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","សោស្មាកំ វិរុទ្ធំ ទ្ឫឞ្ដាន្តមិមំ កថិតវាន៑ ឥតិ ជ្ញាត្វា ប្រធានយាជកា អធ្យាបកាឝ្ច តទៃវ តំ ធត៌ុំ វវាញ្ឆុះ កិន្តុ លោកេភ្យោ ពិភ្យុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","អតឯវ តំ ប្រតិ សតក៌ាះ សន្តះ កថំ តទ្វាក្យទោឞំ ធ្ឫត្វា តំ ទេឝាធិបស្យ សាធុវេឝធារិណឝ្ចរាន៑ តស្យ សមីបេ ប្រេឞយាមាសុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","តទា តេ តំ បប្រច្ឆុះ, ហេ ឧបទេឝក ភវាន៑ យថាត៌្ហំ កថយន៑ ឧបទិឝតិ, កមប្យនបេក្ឞ្យ សត្យត្វេនៃឝ្វរំ មាគ៌មុបទិឝតិ, វយមេតជ្ជានីមះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","កៃសររាជាយ ករោស្មាភិ រ្ទេយោ ន វា? ");
INSERT INTO sankhm_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ស តេឞាំ វញ្ចនំ ជ្ញាត្វាវទត៑ កុតោ មាំ បរីក្ឞធ្វេ? មាំ មុទ្រាមេកំ ទឝ៌យត។ ");
INSERT INTO sankhm_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","ឥហ លិខិតា មូត៌ិរិយំ នាម ច កស្យ? តេៜវទន៑ កៃសរស្យ។ ");
INSERT INTO sankhm_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","តទា ស ឧវាច, តហ៌ិ កៃសរស្យ ទ្រវ្យំ កៃសរាយ ទត្ត; ឦឝ្វរស្យ តុ ទ្រវ្យមីឝ្វរាយ ទត្ត។ ");
INSERT INTO sankhm_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","តស្មាល្លោកានាំ សាក្ឞាត៑ តត្កថាយាះ កមបិ ទោឞំ ធត៌ុមប្រាប្យ តេ តស្យោត្តរាទ៑ អាឝ្ចយ៌្យំ មន្យមានា មៅនិនស្តស្ថុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","អបរញ្ច ឝ្មឝានាទុត្ថានានង្គីការិណាំ សិទូកិនាំ កិយន្តោ ជនា អាគត្យ តំ បប្រច្ឆុះ, ");
INSERT INTO sankhm_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","ហេ ឧបទេឝក ឝាស្ត្រេ មូសា អស្មាន៑ ប្រតីតិ លិលេខ យស្យ ភ្រាតា ភាយ៌្យាយាំ សត្យាំ និះសន្តានោ ម្រិយតេ ស តជ្ជាយាំ វិវហ្យ តទ្វំឝម៑ ឧត្បាទយិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","តថាច កេចិត៑ សប្ត ភ្រាតរ អាសន៑ តេឞាំ ជ្យេឞ្ឋោ ភ្រាតា វិវហ្យ និរបត្យះ ប្រាណាន៑ ជហៅ។ ");
INSERT INTO sankhm_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","អថ ទ្វិតីយស្តស្យ ជាយាំ វិវហ្យ និរបត្យះ សន៑ មមារ។ ត្ឫតីយឝ្ច តាមេវ វ្យុវាហ; ");
INSERT INTO sankhm_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ឥត្ថំ សប្ត ភ្រាតរស្តាមេវ វិវហ្យ និរបត្យាះ សន្តោ មម្រុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ឝេឞេ សា ស្ត្រី ច មមារ។ ");
INSERT INTO sankhm_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","អតឯវ ឝ្មឝានាទុត្ថានកាលេ តេឞាំ សប្តជនានាំ កស្យ សា ភាយ៌្យា ភវិឞ្យតិ? យតះ សា តេឞាំ សប្តានាមេវ ភាយ៌្យាសីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","តទា យីឝុះ ប្រត្យុវាច, ឯតស្យ ជគតោ លោកា វិវហន្តិ វាគ្ទត្តាឝ្ច ភវន្តិ ");
INSERT INTO sankhm_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","កិន្តុ យេ តជ្ជគត្ប្រាប្តិយោគ្យត្វេន គណិតាំ ភវិឞ្យន្តិ ឝ្មឝានាច្ចោត្ថាស្យន្តិ តេ ន វិវហន្តិ វាគ្ទត្តាឝ្ច ន ភវន្តិ, ");
INSERT INTO sankhm_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","តេ បុន រ្ន ម្រិយន្តេ កិន្តុ ឝ្មឝានាទុត្ថាបិតាះ សន្ត ឦឝ្វរស្យ សន្តានាះ ស្វគ៌ីយទូតានាំ សទ្ឫឝាឝ្ច ភវន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","អធិកន្តុ មូសាះ ស្តម្ពោបាខ្យានេ បរមេឝ្វរ ឦព្រាហីម ឦឝ្វរ ឥស្ហាក ឦឝ្វរោ យាកូពឝ្ចេឝ្វរ ឥត្យុក្ត្វា ម្ឫតានាំ ឝ្មឝានាទ៑ ឧត្ថានស្យ ប្រមាណំ លិលេខ។ ");
INSERT INTO sankhm_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","អតឯវ យ ឦឝ្វរះ ស ម្ឫតានាំ ប្រភុ រ្ន កិន្តុ ជីវតាមេវ ប្រភុះ, តន្និកដេ សវ៌្វេ ជីវន្តះ សន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ឥតិ ឝ្រុត្វា កិយន្តោធ្យាបកា ឩចុះ, ហេ ឧបទេឝក ភវាន៑ ភទ្រំ ប្រត្យុក្តវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ឥតះ បរំ តំ កិមបិ ប្រឞ្ដំ តេឞាំ ប្រគល្ភតា នាភូត៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","បឝ្ចាត៑ ស តាន៑ ឧវាច, យះ ខ្រីឞ្ដះ ស ទាយូទះ សន្តាន ឯតាំ កថាំ លោកាះ កថំ កថយន្តិ? ");
INSERT INTO sankhm_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","យតះ មម ប្រភុមិទំ វាក្យមវទត៑ បរមេឝ្វរះ។ តវ ឝត្រូនហំ យាវត៑ បាទបីឋំ ករោមិ ន។ តាវត៑ កាលំ មទីយេ ត្វំ ទក្ឞបាឝ៌្វ ឧបាវិឝ។ ");
INSERT INTO sankhm_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ឥតិ កថាំ ទាយូទ៑ ស្វយំ គីតគ្រន្ថេៜវទត៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","អតឯវ យទិ ទាយូទ៑ តំ ប្រភុំ វទតិ, តហ៌ិ ស កថំ តស្យ សន្តានោ ភវតិ? ");
INSERT INTO sankhm_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","បឝ្ចាទ៑ យីឝុះ សវ៌្វជនានាំ កណ៌គោចរេ ឝិឞ្យានុវាច, ");
INSERT INTO sankhm_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","យេៜធ្យាបកា ទីគ៌្ហបរិច្ឆទំ បរិធាយ ភ្រមន្តិ, ហដ្ដាបណយោ រ្នមស្ការេ ភជនគេហស្យ ប្រោច្ចាសនេ ភោជនគ្ឫហស្យ ប្រធានស្ថានេ ច ប្រីយន្តេ ");
INSERT INTO sankhm_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","វិធវានាំ សវ៌្វស្វំ គ្រសិត្វា ឆលេន ទីគ៌្ហកាលំ ប្រាត៌្ហយន្តេ ច តេឞុ សាវធានា ភវត, តេឞាមុគ្រទណ្ឌោ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","អថ ធនិលោកា ភាណ្ឌាគារេ ធនំ និក្ឞិបន្តិ ស តទេវ បឝ្យតិ, ");
INSERT INTO sankhm_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ឯតហ៌ិ កាចិទ្ទីនា វិធវា បណទ្វយំ និក្ឞិបតិ តទ៑ ទទឝ៌។ ");
INSERT INTO sankhm_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","តតោ យីឝុរុវាច យុឞ្មានហំ យថាត៌្ហំ វទាមិ, ទរិទ្រេយំ វិធវា សវ៌្វេភ្យោធិកំ ន្យក្ឞេប្សីត៑, ");
INSERT INTO sankhm_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","យតោន្យេ ស្វប្រាជ្យធនេភ្យ ឦឝ្វរាយ កិញ្ចិត៑ ន្យក្ឞេប្សុះ, កិន្តុ ទរិទ្រេយំ វិធវា ទិនយាបនាត៌្ហំ ស្វស្យ យត៑ កិញ្ចិត៑ ស្ថិតំ តត៑ សវ៌្វំ ន្យក្ឞេប្សីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","អបរញ្ច ឧត្តមប្រស្តរៃរុត្ស្ឫឞ្ដវ្យៃឝ្ច មន្ទិរំ សុឝោភតេតរាំ កៃឝ្ចិទិត្យុក្តេ ស ប្រត្យុវាច ");
INSERT INTO sankhm_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","យូយំ យទិទំ និចយនំ បឝ្យថ, អស្យ បាឞាណៃកោប្យន្យបាឞាណោបរិ ន ស្ថាស្យតិ, សវ៌្វេ ភូសាទ្ភវិឞ្យន្តិ កាលោយមាយាតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","តទា តេ បប្រច្ឆុះ, ហេ គុរោ ឃដនេទ្ឫឝី កទា ភវិឞ្យតិ? ឃដនាយា ឯតស្យសឝ្ចិហ្នំ វា កិំ ភវិឞ្យតិ? ");
INSERT INTO sankhm_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","តទា ស ជគាទ, សាវធានា ភវត យថា យុឞ្មាកំ ភ្រមំ កោបិ ន ជនយតិ, ខីឞ្ដោហមិត្យុក្ត្វា មម នាម្រា ពហវ ឧបស្ថាស្យន្តិ ស កាលះ ប្រាយេណោបស្ថិតះ, តេឞាំ បឝ្ចាន្មា គច្ឆត។ ");
INSERT INTO sankhm_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","យុទ្ធស្យោបប្លវស្យ ច វាត៌្តាំ ឝ្រុត្វា មា ឝង្កធ្វំ, យតះ ប្រថមម៑ ឯតា ឃដនា អវឝ្យំ ភវិឞ្យន្តិ កិន្តុ នាបាតេ យុគាន្តោ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","អបរញ្ច កថយាមាស, តទា ទេឝស្យ វិបក្ឞត្វេន ទេឝោ រាជ្យស្យ វិបក្ឞត្វេន រាជ្យម៑ ឧត្ថាស្យតិ, ");
INSERT INTO sankhm_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","នានាស្ថានេឞុ មហាភូកម្បោ ទុព៌្ហិក្ឞំ មារី ច ភវិឞ្យន្តិ, តថា វ្យោមមណ្ឌលស្យ ភយង្ករទឝ៌នាន្យឝ្ចយ៌្យលក្ឞណានិ ច ប្រកាឝយិឞ្យន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","កិន្តុ សវ៌្វាសាមេតាសាំ ឃដនានាំ បូវ៌្វំ លោកា យុឞ្មាន៑ ធ្ឫត្វា តាឌយិឞ្យន្តិ, ភជនាលយេ ការាយាញ្ច សមប៌យិឞ្យន្តិ មម នាមការណាទ៑ យុឞ្មាន៑ ភូបានាំ ឝាសកានាញ្ច សម្មុខំ នេឞ្យន្តិ ច។ ");
INSERT INTO sankhm_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","សាក្ឞ្យាត៌្ហម៑ ឯតានិ យុឞ្មាន៑ ប្រតិ ឃដិឞ្យន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","តទា កិមុត្តរំ វក្តវ្យម៑ ឯតត៑ ន ចិន្តយិឞ្យាម ឥតិ មនះសុ និឝ្ចិតនុត។ ");
INSERT INTO sankhm_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","វិបក្ឞា យស្មាត៑ កិមប្យុត្តរម៑ អាបត្តិញ្ច កត៌្តុំ ន ឝក្ឞ្យន្តិ តាទ្ឫឝំ វាក្បដុត្វំ ជ្ញានញ្ច យុឞ្មភ្យំ ទាស្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","កិញ្ច យូយំ បិត្រា មាត្រា ភ្រាត្រា ពន្ធុនា ជ្ញាត្យា កុដុម្ពេន ច បរករេឞុ សមប៌យិឞ្យធ្វេ; តតស្តេ យុឞ្មាកំ កញ្ចន កញ្ចន ឃាតយិឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","មម នាម្នះ ការណាត៑ សវ៌្វៃ រ្មនុឞ្យៃ រ្យូយម៑ ឫតីយិឞ្យធ្វេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","កិន្តុ យុឞ្មាកំ ឝិរះកេឝៃកោបិ ន វិនំក្ឞ្យតិ, ");
INSERT INTO sankhm_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","តស្មាទេវ ធៃយ៌្យមវលម្ព្យ ស្វស្វប្រាណាន៑ រក្ឞត។ ");
INSERT INTO sankhm_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","អបរញ្ច យិរូឝាលម្បុរំ សៃន្យវេឞ្ដិតំ វិលោក្យ តស្យោច្ឆិន្នតាយាះ សមយះ សមីប ឥត្យវគមិឞ្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","តទា យិហូទាទេឝស្ថា លោកាះ បវ៌្វតំ បលាយន្តាំ, យេ ច នគរេ តិឞ្ឋន្តិ តេ ទេឝាន្តរំ បលាយន្តា, យេ ច គ្រាមេ តិឞ្ឋន្តិ តេ នគរំ ន ប្រវិឝន្តុ, ");
INSERT INTO sankhm_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","យតស្តទា សមុចិតទណ្ឌនាយ ធម៌្មបុស្តកេ យានិ សវ៌្វាណិ លិខិតានិ តានិ សផលានិ ភវិឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","កិន្តុ យា យាស្តទា គព៌្ហវត្យះ ស្តន្យទាវ្យឝ្ច តាមាំ ទុគ៌តិ រ្ភវិឞ្យតិ, យត ឯតាល្លោកាន៑ ប្រតិ កោបោ ទេឝេ ច វិឞមទុគ៌តិ រ្ឃដិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","វស្តុតស្តុ តេ ខង្គធារបរិវ្វង្គំ លប្ស្យន្តេ ពទ្ធាះ សន្តះ សវ៌្វទេឝេឞុ នាយិឞ្យន្តេ ច កិញ្ចាន្យទេឝីយានាំ សមយោបស្ថិតិបយ៌្យន្តំ យិរូឝាលម្បុរំ តៃះ បទតលៃ រ្ទលយិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","សូយ៌្យចន្ទ្រនក្ឞត្រេឞុ លក្ឞណាទិ ភវិឞ្យន្តិ, ភុវិ សវ៌្វទេឝីយានាំ ទុះខំ ចិន្តា ច សិន្ធៅ វីចីនាំ តជ៌នំ គជ៌នញ្ច ភវិឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ភូភៅ ភាវិឃដនាំ ចិន្តយិត្វា មនុជា ភិយាម្ឫតកល្បា ភវិឞ្យន្តិ, យតោ វ្យោមមណ្ឌលេ តេជស្វិនោ ទោលាយមានា ភវិឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","តទា បរាក្រមេណា មហាតេជសា ច មេឃារូឍំ មនុឞ្យបុត្រម៑ អាយាន្តំ ទ្រក្ឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","កិន្ត្វេតាសាំ ឃដនានាមារម្ភេ សតិ យូយំ មស្តកាន្យុត្តោល្យ ឩទ៌ធ្វំ ទ្រក្ឞ្យថ, យតោ យុឞ្មាកំ មុក្តេះ កាលះ សវិធោ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","តតស្តេនៃតទ្ឫឞ្ដាន្តកថា កថិតា, បឝ្យត ឧឌុម្ពរាទិវ្ឫក្ឞាណាំ ");
INSERT INTO sankhm_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","នវីនបត្រាណិ ជាតានីតិ ទ្ឫឞ្ដ្វា និទាវកាល ឧបស្ថិត ឥតិ យថា យូយំ ជ្ញាតុំ ឝក្នុថ, ");
INSERT INTO sankhm_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","តថា សវ៌្វាសាមាសាំ ឃដនានាម៑ អារម្ភេ ទ្ឫឞ្ដេ សតីឝ្វរស្យ រាជត្វំ និកដម៑ ឥត្យបិ ជ្ញាស្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","យុឞ្មានហំ យថាត៌្ហំ វទាមិ, វិទ្យមានលោកានាមេឞាំ គមនាត៑ បូវ៌្វម៑ ឯតានិ ឃដិឞ្យន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","នភោភុវោល៌ោបោ ភវិឞ្យតិ មម វាក៑ តុ កទាបិ លុប្តា ន ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","អតឯវ វិឞមាឝនេន បានេន ច សាំមារិកចិន្តាភិឝ្ច យុឞ្មាកំ ចិត្តេឞុ មត្តេឞុ តទ្ទិនម៑ អកស្មាទ៑ យុឞ្មាន៑ ប្រតិ យថា នោបតិឞ្ឋតិ តទត៌្ហំ ស្វេឞុ សាវធានាស្តិឞ្ឋត។ ");
INSERT INTO sankhm_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ប្ឫថិវីស្ថសវ៌្វលោកាន៑ ប្រតិ តទ្ទិនម៑ ឧន្មាថ ឥវ ឧបស្ថាស្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","យថា យូយម៑ ឯតទ្ភាវិឃដនា ឧត្តត៌្តុំ មនុជសុតស្យ សម្មុខេ សំស្ថាតុញ្ច យោគ្យា ភវថ ការណាទស្មាត៑ សាវធានាះ សន្តោ និរន្តរំ ប្រាត៌្ហយធ្វំ។ ");
INSERT INTO sankhm_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","អបរញ្ច ស ទិវា មន្ទិរ ឧបទិឝ្យ រាចៃ ជៃតុនាទ្រិំ គត្វាតិឞ្ឋត៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","តតះ ប្រត្យូឞេ លាកាស្តត្កថាំ ឝ្រោតុំ មន្ទិរេ តទន្តិកម៑ អាគច្ឆន៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","អបរញ្ច កិណ្វឝូន្យបូបោត្សវស្យ កាល ឧបស្ថិតេ ");
INSERT INTO sankhm_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ប្រធានយាជកា អធ្យាយកាឝ្ច យថា តំ ហន្តុំ ឝក្នុវន្តិ តថោបាយាម៑ អចេឞ្ដន្ត កិន្តុ លោកេភ្យោ ពិភ្យុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ឯតស្តិន៑ សមយេ ទ្វាទឝឝិឞ្យេឞុ គណិត ឦឞ្ករិយោតីយរូឍិមាន៑ យោ យិហូទាស្តស្យាន្តះករណំ ឝៃតានាឝ្រិតត្វាត្ ");
INSERT INTO sankhm_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ស គត្វា យថា យីឝុំ តេឞាំ ករេឞុ សមប៌យិតុំ ឝក្នោតិ តថា មន្ត្រណាំ ប្រធានយាជកៃះ សេនាបតិភិឝ្ច សហ ចការ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","តេន តេ តុឞ្ដាស្តស្មៃ មុទ្រាំ ទាតុំ បណំ ចក្រុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","តតះ សោង្គីក្ឫត្យ យថា លោកានាមគោចរេ តំ បរករេឞុ សមប៌យិតុំ ឝក្នោតិ តថាវកាឝំ ចេឞ្ដិតុមារេភេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","អថ កិណ្វឝូន្យបូបោត្មវទិនេ, អត៌្ហាត៑ យស្មិន៑ ទិនេ និស្តារោត្សវស្យ មេឞោ ហន្តវ្យស្តស្មិន៑ ទិនេ ");
INSERT INTO sankhm_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","យីឝុះ បិតរំ យោហនញ្ចាហូយ ជគាទ, យុវាំ គត្វាស្មាកំ ភោជនាត៌្ហំ និស្តារោត្សវស្យ ទ្រវ្យាណ្យាសាទយតំ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","តទា តៅ បប្រច្ឆតុះ កុចាសាទយាវោ ភវតះ កេច្ឆា? ");
INSERT INTO sankhm_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","តទា សោវាទីត៑, នគរេ ប្រវិឞ្ដេ កឝ្ចិជ្ជលកុម្ភមាទាយ យុវាំ សាក្ឞាត៑ ករិឞ្យតិ ស យន្និវេឝនំ ប្រវិឝតិ យុវាមបិ តន្និវេឝនំ តត្បឝ្ចាទិត្វា និវេឝនបតិម៑ ឥតិ វាក្យំ វទតំ, ");
INSERT INTO sankhm_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","យត្រាហំ និស្តារោត្សវស្យ ភោជ្យំ ឝិឞ្យៃះ សាទ៌្ធំ ភោក្តុំ ឝក្នោមិ សាតិថិឝាលាा កុត្រ? កថាមិមាំ ប្រភុស្ត្វាំ ប្ឫច្ឆតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","តតះ ស ជនោ ទ្វិតីយប្រកោឞ្ឋីយម៑ ឯកំ ឝស្តំ កោឞ្ឋំ ទឝ៌យិឞ្យតិ តត្រ ភោជ្យមាសាទយតំ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","តតស្តៅ គត្វា តទ្វាក្យានុសារេណ សវ៌្វំ ទ្ឫឞ្ទ្វា តត្រ និស្តារោត្សវីយំ ភោជ្យមាសាទយាមាសតុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","អថ កាល ឧបស្ថិតេ យីឝុ រ្ទ្វាទឝភិះ ប្រេរិតៃះ សហ ភោក្តុមុបវិឝ្យ កថិតវាន្ ");
INSERT INTO sankhm_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","មម ទុះខភោគាត៑ បូវ៌្វំ យុភាភិះ សហ និស្តារោត្សវស្យៃតស្យ ភោជ្យំ ភោក្តុំ មយាតិវាញ្ឆា ក្ឫតា។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","យុឞ្មាន៑ វទាមិ, យាវត្កាលម៑ ឦឝ្វររាជ្យេ ភោជនំ ន ករិឞ្យេ តាវត្កាលម៑ ឥទំ ន ភោក្ឞ្យេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","តទា ស បានបាត្រមាទាយ ឦឝ្វរស្យ គុណាន៑ កីត៌្តយិត្វា តេភ្យោ ទត្វាវទត៑, ឥទំ គ្ឫហ្លីត យូយំ វិភជ្យ បិវត។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","យុឞ្មាន៑ វទាមិ យាវត្កាលម៑ ឦឝ្វររាជត្វស្យ សំស្ថាបនំ ន ភវតិ តាវទ៑ ទ្រាក្ឞាផលរសំ ន បាស្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","តតះ បូបំ គ្ឫហីត្វា ឦឝ្វរគុណាន៑ កីត៌្តយិត្វា ភង្ក្តា តេភ្យោ ទត្វាវទត៑, យុឞ្មទត៌្ហំ សមប៌ិតំ យន្មម វបុស្តទិទំ, ឯតត៑ កម៌្ម មម ស្មរណាត៌្ហំ កុរុធ្វំ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","អថ ភោជនាន្តេ តាទ្ឫឝំ បាត្រំ គ្ឫហីត្វាវទត៑, យុឞ្មត្ក្ឫតេ បាតិតំ យន្មម រក្តំ តេន និណ៌ីតនវនិយមរូបំ បានបាត្រមិទំ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","បឝ្យត យោ មាំ បរករេឞុ សមប៌យិឞ្យតិ ស មយា សហ ភោជនាសន ឧបវិឝតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","យថា និរូបិតមាស្តេ តទនុសារេណា មនុឞ្យបុुត្រស្យ គតិ រ្ភវិឞ្យតិ កិន្តុ យស្តំ បរករេឞុ សមប៌យិឞ្យតិ តស្យ សន្តាបោ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","តទា តេឞាំ កោ ជន ឯតត៑ កម៌្ម ករិឞ្យតិ តត៑ តេ បរស្បរំ ប្រឞ្ដុមារេភិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","អបរំ តេឞាំ កោ ជនះ ឝ្រេឞ្ឋត្វេន គណយិឞ្យតេ, អត្រាត៌្ហេ តេឞាំ វិវាទោភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","អស្មាត៑ ការណាត៑ សោវទត៑, អន្យទេឝីយានាំ រាជានះ ប្រជានាមុបរិ ប្រភុត្វំ កុវ៌្វន្តិ ទារុណឝាសនំ ក្ឫត្វាបិ តេ ភូបតិត្វេន វិខ្យាតា ភវន្តិ ច។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","កិន្តុ យុឞ្មាកំ តថា ន ភវិឞ្យតិ, យោ យុឞ្មាកំ ឝ្រេឞ្ឋោ ភវិឞ្យតិ ស កនិឞ្ឋវទ៑ ភវតុ, យឝ្ច មុខ្យោ ភវិឞ្យតិ ស សេវកវទ្ភវតុ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","ភោជនោបវិឞ្ដបរិចារកយោះ កះ ឝ្រេឞ្ឋះ? យោ ភោជនាយោបវិឝតិ ស កិំ ឝ្រេឞ្ឋោ ន ភវតិ? កិន្តុ យុឞ្មាកំ មធ្យេៜហំ បរិចារកឥវាស្មិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","អបរញ្ច យុយំ មម បរីក្ឞាកាលេ ប្រថមមារភ្យ មយា សហ ស្ថិតា ");
INSERT INTO sankhm_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ឯតត្ការណាត៑ បិត្រា យថា មទត៌្ហំ រាជ្យមេកំ និរូបិតំ តថាហមបិ យុឞ្មទត៌្ហំ រាជ្យំ និរូបយាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","តស្មាន៑ មម រាជ្យេ ភោជនាសនេ ច ភោជនបានេ ករិឞ្យធ្វេ សិំហាសនេឞូបវិឝ្យ ចេស្រាយេលីយានាំ ទ្វាទឝវំឝានាំ វិចារំ ករិឞ្យធ្វេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","អបរំ ប្រភុរុវាច, ហេ ឝិមោន៑ បឝ្យ តិតឧនា ធាន្យានីវ យុឞ្មាន៑ ឝៃតាន៑ ចាលយិតុម៑ ឰច្ឆត៑, ");
INSERT INTO sankhm_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","កិន្តុ តវ វិឝ្វាសស្យ លោបោ យថា ន ភវតិ ឯតត៑ ត្វទត៌្ហំ ប្រាត៌្ហិតំ មយា, ត្វន្មនសិ បរិវត៌្តិតេ ច ភ្រាត្ឫណាំ មនាំសិ ស្ថិរីកុរុ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","តទា សោវទត៑, ហេ ប្រភោហំ ត្វយា សាទ៌្ធំ ការាំ ម្ឫតិញ្ច យាតុំ មជ្ជិតោស្មិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","តតះ ស ឧវាច, ហេ បិតរ ត្វាំ វទាមិ, អទ្យ កុក្កុដរវាត៑ បូវ៌្វំ ត្វំ មត្បរិចយំ វារត្រយម៑ អបហ្វោឞ្យសេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","អបរំ ស បប្រច្ឆ, យទា មុទ្រាសម្បុដំ ខាទ្យបាត្រំ បាទុកាញ្ច វិនា យុឞ្មាន៑ ប្រាហិណវំ តទា យុឞ្មាកំ កស្យាបិ ន្យូនតាសីត៑? តេ ប្រោចុះ កស្យាបិ ន។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","តទា សោវទត៑ កិន្ត្វិទានីំ មុទ្រាសម្បុដំ ខាទ្យបាត្រំ វា យស្យាស្តិ តេន តទ្គ្រហីតវ្យំ, យស្យ ច ក្ឫបាណោे នាស្តិ តេន ស្វវស្ត្រំ វិក្រីយ ស ក្រេតវ្យះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","យតោ យុឞ្មានហំ វទាមិ, អបរាធិជនៃះ សាទ៌្ធំ គណិតះ ស ភវិឞ្យតិ។ ឥទំ យច្ឆាស្ត្រីយំ វចនំ លិខិតមស្តិ តន្មយិ ផលិឞ្យតិ យតោ មម សម្ពន្ធីយំ សវ៌្វំ សេត្ស្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","តទា តេ ប្រោចុះ ប្រភោ បឝ្យ ឥមៅ ក្ឫបាណៅ។ តតះ សោវទទ៑ ឯតៅ យថេឞ្ដៅ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","អថ ស តស្មាទ្វហិ រ្គត្វា ស្វាចារានុសារេណ ជៃតុននាមាទ្រិំ ជគាម ឝិឞ្យាឝ្ច តត្បឝ្ចាទ៑ យយុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","តត្រោបស្ថាយ ស តានុវាច, យថា បរីក្ឞាយាំ ន បតថ តទត៌្ហំ ប្រាត៌្ហយធ្វំ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","បឝ្ចាត៑ ស តស្មាទ៑ ឯកឝរក្ឞេបាទ៑ ពហិ រ្គត្វា ជានុនី បាតយិត្វា ឯតត៑ ប្រាត៌្ហយាញ្ចក្រេ, ");
INSERT INTO sankhm_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ហេ បិត រ្យទិ ភវាន៑ សម្មន្យតេ តហ៌ិ កំសមេនំ មមាន្តិកាទ៑ ទូរយ កិន្តុ មទិច្ឆានុរូបំ ន ត្វទិច្ឆានុរូបំ ភវតុ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","តទា តស្មៃ ឝក្តិំ ទាតុំ ស្វគ៌ីយទូតោ ទឝ៌នំ ទទៅ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","បឝ្ចាត៑ សោត្យន្តំ យាតនយា វ្យាកុលោ ភូត្វា បុនទ៌្ឫឍំ ប្រាត៌្ហយាញ្ចក្រេ, តស្មាទ៑ ព្ឫហច្ឆោណិតពិន្ទវ ឥវ តស្យ ស្វេទពិន្ទវះ ប្ឫថិវ្យាំ បតិតុមារេភិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","អថ ប្រាត៌្ហនាត ឧត្ថាយ ឝិឞ្យាណាំ សមីបមេត្យ តាន៑ មនោទុះខិនោ និទ្រិតាន៑ ទ្ឫឞ្ដ្វាវទត្ ");
INSERT INTO sankhm_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","កុតោ និទ្រាថ? បរីក្ឞាយាម៑ អបតនាត៌្ហំ ប្រត៌្ហយធ្វំ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ឯតត្កថាយាះ កថនកាលេ ទ្វាទឝឝិឞ្យាណាំ មធ្យេ គណិតោ យិហូទានាមា ជនតាសហិតស្តេឞាម៑ អគ្រេ ចលិត្វា យីឝោឝ្ចុម្ពនាត៌្ហំ តទន្តិកម៑ អាយយៅ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","តទា យីឝុរុវាច, ហេ យិហូទា កិំ ចុម្ពនេន មនុឞ្យបុត្រំ បរករេឞុ សមប៌យសិ? ");
INSERT INTO sankhm_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","តទា យទ្យទ៑ ឃដិឞ្យតេ តទនុមាយ សង្គិភិរុក្តំ, ហេ ប្រភោ វយំ កិ ខង្គេន ឃាតយិឞ្យាមះ? ");
INSERT INTO sankhm_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","តត ឯកះ ករវាលេនាហត្យ ប្រធានយាជកស្យ ទាសស្យ ទក្ឞិណំ កណ៌ំ ចិច្ឆេទ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","អធូនា និវត៌្តស្វ ឥត្យុក្ត្វា យីឝុស្តស្យ ឝ្រុតិំ ស្ប្ឫឞ្ដ្វា ស្វស្យំ ចការ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","បឝ្ចាទ៑ យីឝុះ សមីបស្ថាន៑ ប្រធានយាជកាន៑ មន្ទិរស្យ សេនាបតីន៑ ប្រាចីនាំឝ្ច ជគាទ, យូយំ ក្ឫបាណាន៑ យឞ្ដីំឝ្ច គ្ឫហីត្វា មាំ កិំ ចោរំ ធត៌្តុមាយាតាះ? ");
INSERT INTO sankhm_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","យទាហំ យុឞ្មាភិះ សហ ប្រតិទិនំ មន្ទិរេៜតិឞ្ឋំ តទា មាំ ធត៌្តំ ន ប្រវ្ឫត្តាះ, កិន្ត្វិទានីំ យុឞ្មាកំ សមយោន្ធការស្យ ចាធិបត្យមស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","អថ តេ តំ ធ្ឫត្វា មហាយាជកស្យ និវេឝនំ និន្យុះ។ តតះ បិតរោ ទូរេ ទូរេ បឝ្ចាទិត្វា ");
INSERT INTO sankhm_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","ព្ឫហត្កោឞ្ឋស្យ មធ្យេ យត្រាគ្និំ ជ្វាលយិត្វា លោកាះ សមេត្យោបវិឞ្ដាស្តត្រ តៃះ សាទ៌្ធម៑ ឧបវិវេឝ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","អថ វហ្និសន្និធៅ សមុបវេឝកាលេ កាចិទ្ទាសី មនោ និវិឝ្យ តំ និរីក្ឞ្យាវទត៑ បុមានយំ តស្យ សង្គេៜស្ថាត៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","កិន្តុ ស តទ៑ អបហ្នុត្យាវាទីត៑ ហេ នារិ តមហំ ន បរិចិនោមិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ក្ឞណាន្តរេៜន្យជនស្តំ ទ្ឫឞ្ដ្វាព្រវីត៑ ត្វមបិ តេឞាំ និករស្យៃកជនោសិ។ បិតរះ ប្រត្យុវាច ហេ នរ នាហមស្មិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","តតះ សាទ៌្ធទណ្ឌទ្វយាត៑ បរំ បុនរន្យោ ជនោ និឝ្ចិត្យ ពភាឞេ, ឯឞ តស្យ សង្គីតិ សត្យំ យតោយំ គាលីលីយោ លោកះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","តទា បិតរ ឧវាច ហេ នរ ត្វំ យទ៑ វទមិ តទហំ ពោទ្ធុំ ន ឝក្នោមិ, ឥតិ វាក្យេ កថិតមាត្រេ កុក្កុដោ រុរាវ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","តទា ប្រភុណា វ្យាធុដ្យ បិតរេ និរីក្ឞិតេ ក្ឫកវាកុរវាត៑ បូវ៌្វំ មាំ ត្រិរបហ្នោឞ្យសេ ឥតិ បូវ៌្វោក្តំ តស្យ វាក្យំ បិតរះ ស្ម្ឫត្វា ");
INSERT INTO sankhm_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ពហិគ៌ត្វា មហាខេទេន ចក្រន្ទ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","តទា យៃ រ្យីឝុទ៌្ហ្ឫតស្តេ តមុបហស្យ ប្រហត៌្តុមារេភិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","វស្ត្រេណ តស្យ ទ្ឫឝៅ ពទ្ធ្វា កបោលេ ចបេដាឃាតំ ក្ឫត្វា បប្រច្ឆុះ, កស្តេ កបោលេ ចបេដាឃាតំ ក្ឫតវាន? គណយិត្វា តទ៑ វទ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","តទន្យត៑ តទ្វិរុទ្ធំ ពហុនិន្ទាវាក្យំ វក្តុមារេភិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","អថ ប្រភាតេ សតិ លោកប្រាញ្ចះ ប្រធានយាជកា អធ្យាបកាឝ្ច សភាំ ក្ឫត្វា មធ្យេសភំ យីឝុមានីយ បប្រច្ឆុះ, ត្វម៑ អភិឞិកតោសិ ន វាស្មាន៑ វទ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ស ប្រត្យុវាច, មយា តស្មិន្នុក្តេៜបិ យូយំ ន វិឝ្វសិឞ្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","កស្មិំឝ្ចិទ្វាក្យេ យុឞ្មាន៑ ប្ឫឞ្ដេៜបិ មាំ ន តទុត្តរំ វក្ឞ្យថ ន មាំ ត្យក្ឞ្យថ ច។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","កិន្ត្វិតះ បរំ មនុជសុតះ សវ៌្វឝក្តិមត ឦឝ្វរស្យ ទក្ឞិណេ បាឝ៌្វេ សមុបវេក្ឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","តតស្តេ បប្រច្ឆុះ, រ្តិហ ត្វមីឝ្វរស្យ បុត្រះ? ស កថយាមាស, យូយំ យថាត៌្ហំ វទថ ស ឯវាហំ។ ");
INSERT INTO sankhm_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","តទា តេ សវ៌្វេ កថយាមាសុះ, រ្តិហ សាក្ឞ្យេៜន្សស្មិន៑ អស្មាកំ កិំ ប្រយោជនំ? អស្យ ស្វមុខាទេវ សាក្ឞ្យំ ប្រាប្តម៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","តតះ សភាស្ថាះ សវ៌្វលោកា ឧត្ថាយ តំ បីលាតសម្មុខំ នីត្វាប្រោទ្យ វក្តុមារេភិរេ, ");
INSERT INTO sankhm_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ស្វមភិឞិក្តំ រាជានំ វទន្តំ កៃមររាជាយ ករទានំ និឞេធន្តំ រាជ្យវិបយ៌្យយំ កុត៌្តុំ ប្រវត៌្តមានម៑ ឯន ប្រាប្តា វយំ។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","តទា បីលាតស្តំ ប្ឫឞ្ដវាន៑ ត្វំ កិំ យិហូទីយានាំ រាជា? ស ប្រត្យុវាច ត្វំ សត្យមុក្តវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","តទា បីលាតះ ប្រធានយាជកាទិលោកាន៑ ជគាទ៑, អហមេតស្យ កមប្យបរាធំ នាប្តវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","តតស្តេ បុនះ សាហមិនោ ភូត្វាវទន៑, ឯឞ គាលីល ឯតត្ស្ថានបយ៌្យន្តេ សវ៌្វស្មិន៑ យិហូទាទេឝេ សវ៌្វាល្លោកានុបទិឝ្យ កុប្រវ្ឫត្តិំ គ្រាហីតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","តទា បីលាតោ គាលីលប្រទេឝស្យ នាម ឝ្រុត្វា បប្រច្ឆ, កិមយំ គាលីលីយោ លោកះ? ");
INSERT INTO sankhm_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","តតះ ស គាលីល្ប្រទេឝីយហេរោទ្រាជស្យ តទា ស្ថិតេស្តស្យ សមីបេ យីឝុំ ប្រេឞយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","តទា ហេរោទ៑ យីឝុំ វិលោក្យ សន្តុតោឞ, យតះ ស តស្យ ពហុវ្ឫត្តាន្តឝ្រវណាត៑ តស្យ កិញិ्ចទាឝ្ចយ៌្យកម៌្ម បឝ្យតិ ឥត្យាឝាំ ក្ឫត្វា ពហុកាលមារភ្យ តំ ទ្រឞ្ដុំ ប្រយាសំ ក្ឫតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","តស្មាត៑ តំ ពហុកថាះ បប្រច្ឆ កិន្តុ ស តស្យ កស្យាបិ វាក្យស្យ ប្រត្យុត្តរំ នោវាច។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","អថ ប្រធានយាជកា អធ្យាបកាឝ្ច ប្រោត្តិឞ្ឋន្តះ សាហសេន តមបវទិតុំ ប្រារេភិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ហេរោទ៑ តស្យ សេនាគណឝ្ច តមវជ្ញាយ ឧបហាសត្វេន រាជវស្ត្រំ បរិធាប្យ បុនះ បីលាតំ ប្រតិ តំ ប្រាហិណោត៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","បូវ៌្វំ ហេរោទ្បីលាតយោះ បរស្បរំ វៃរភាវ អាសីត៑ កិន្តុ តទ្ទិនេ ទ្វយោ រ្មេលនំ ជាតម៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","បឝ្ចាត៑ បីលាតះ ប្រធានយាជកាន៑ ឝាសកាន៑ លោកាំឝ្ច យុគបទាហូយ ពភាឞេ, ");
INSERT INTO sankhm_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","រាជ្យវិបយ៌្យយការកោយម៑ ឥត្យុក្ត្វា មនុឞ្យមេនំ មម និកដមានៃឞ្ដ កិន្តុ បឝ្យត យុឞ្មាកំ សមក្ឞម៑ អស្យ វិចារំ ក្ឫត្វាបិ ប្រោក្តាបវាទានុរូបេណាស្យ កោប្យបរាធះ សប្រមាណោ ន ជាតះ, ");
INSERT INTO sankhm_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","យូយញ្ច ហេរោទះ សន្និធៅ ប្រេឞិតា មយា តត្រាស្យ កោប្យបរាធស្តេនាបិ ន ប្រាប្តះ។ បឝ្យតានេន វធហេेតុកំ កិមបិ នាបរាទ្ធំ។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","តស្មាទេនំ តាឌយិត្វា វិហាស្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","តត្រោត្សវេ តេឞាមេកោ មោចយិតវ្យះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ឥតិ ហេតោស្តេ ប្រោច្ចៃរេកទា ប្រោចុះ, ឯនំ ទូរីក្ឫត្យ ពរព្ពានាមានំ មោចយ។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","ស ពរព្ពា នគរ ឧបប្លវវធាបរាធាភ្យាំ ការាយាំ ពទ្ធ អាសីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","កិន្តុ បីលាតោ យីឝុំ មោចយិតុំ វាញ្ឆន៑ បុនស្តានុវាច។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","តថាប្យេនំ ក្រុឝេ វ្យធ ក្រុឝេ វ្យធេតិ វទន្តស្តេ រុរុវុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","តតះ ស ត្ឫតីយវារំ ជគាទ កុតះ? ស កិំ កម៌្ម ក្ឫតវាន៑? នាហមស្យ កមបិ វធាបរាធំ ប្រាប្តះ កេវលំ តាឌយិត្វាមុំ ត្យជាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","តថាបិ តេ បុនរេនំ ក្រុឝេ វ្យធ ឥត្យុក្ត្វា ប្រោច្ចៃទ៌្ឫឍំ ប្រាត៌្ហយាញ្ចក្រិរេ; ");
INSERT INTO sankhm_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","តតះ ប្រធានយាជកាទីនាំ កលរវេ ប្រពលេ សតិ តេឞាំ ប្រាត៌្ហនារូបំ កត៌្តុំ បីលាត អាទិទេឝ។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","រាជទ្រោហវធយោរបរាធេន ការាស្ថំ យំ ជនំ តេ យយាចិរេ តំ មោចយិត្វា យីឝុំ តេឞាមិច្ឆាយាំ សមាប៌យត៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","អថ តេ យីឝុំ គ្ឫហីត្វា យាន្តិ, ឯតហ៌ិ គ្រាមាទាគតំ ឝិមោននាមានំ កុរីណីយំ ជនំ ធ្ឫត្វា យីឝោះ បឝ្ចាន្នេតុំ តស្យ ស្កន្ធេ ក្រុឝមប៌យាមាសុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","តតោ លោाការណ្យមធ្យេ ពហុស្ត្រិយោ រុទត្យោ វិលបន្ត្យឝ្ច យីឝោះ បឝ្ចាទ៑ យយុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","កិន្តុ ស វ្យាឃុដ្យ តា ឧវាច, ហេ យិរូឝាលមោ នាយ៌្យោ យុយំ មទត៌្ហំ ន រុទិត្វា ស្វាត៌្ហំ ស្វាបត្យាត៌្ហញ្ច រុទិតិ; ");
INSERT INTO sankhm_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","បឝ្យត យះ កទាបិ គព៌្ហវត្យោ នាភវន៑ ស្តន្យញ្ច នាបាយយន៑ តាទ្ឫឝី រ្វន្ធ្យា យទា ធន្យា វក្ឞ្យន្តិ ស កាល អាយាតិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","តទា ហេ ឝៃលា អស្មាកមុបរិ បតត, ហេ ឧបឝៃលា អស្មានាច្ឆាទយត កថាមីទ្ឫឝីំ លោកា វក្ឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","យតះ សតេជសិ ឝាខិនិ ចេទេតទ៑ ឃដតេ តហ៌ិ ឝុឞ្កឝាខិនិ កិំ ន ឃដិឞ្យតេ? ");
INSERT INTO sankhm_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","តទា តេ ហន្តុំ ទ្វាវបរាធិនៅ តេន សាទ៌្ធំ និន្យុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","អបរំ ឝិរះកបាលនាមកស្ថានំ ប្រាប្យ តំ ក្រុឝេ វិវិធុះ; តទ្ទ្វយោរបរាធិនោរេកំ តស្យ ទក្ឞិណោ តទន្យំ វាមេ ក្រុឝេ វិវិធុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","តទា យីឝុរកថយត៑, ហេ បិតរេតាន៑ ក្ឞមស្វ យត ឯតេ យត៑ កម៌្ម កុវ៌្វន្តិ តន៑ ន វិទុះ; បឝ្ចាត្តេ គុដិកាបាតំ ក្ឫត្វា តស្យ វស្ត្រាណិ វិភជ្យ ជគ្ឫហុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","តត្រ លោកសំឃស្តិឞ្ឋន៑ ទទឝ៌; តេ តេឞាំ ឝាសកាឝ្ច តមុបហស្យ ជគទុះ, ឯឞ ឥតរាន៑ រក្ឞិតវាន៑ យទីឝ្វរេណាភិរុចិតោ ៜភិឞិក្តស្ត្រាតា ភវតិ តហ៌ិ ស្វមធុនា រក្ឞតុ។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","តទន្យះ សេនាគណា ឯត្យ តស្មៃ អម្លរសំ ទត្វា បរិហស្យ ប្រោវាច, ");
INSERT INTO sankhm_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ចេត្ត្វំ យិហូទីយានាំ រាជាសិ តហ៌ិ ស្វំ រក្ឞ។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","យិហូទីយានាំ រាជេតិ វាក្យំ យូនានីយរោមីយេព្រីយាក្ឞរៃ រ្លិខិតំ តច្ឆិរស ឩទ៌្ធ្វេៜស្ថាប្យត។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","តទោភយបាឝ៌្វយោ រ្វិទ្ធៅ យាវបរាធិនៅ តយោរេកស្តំ វិនិន្ទ្យ ពភាឞេ, ចេត្ត្វម៑ អភិឞិក្តោសិ តហ៌ិ ស្វមាវាញ្ច រក្ឞ។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","កិន្ត្វន្យស្តំ តជ៌យិត្វាវទត៑, ឦឝ្វរាត្តវ កិញ្ចិទបិ ភយំ នាស្តិ កិំ? ត្វមបិ សមានទណ្ឌោសិ, ");
INSERT INTO sankhm_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","យោគ្យបាត្រេ អាវាំ ស្វស្វកម៌្មណាំ សមុចិតផលំ ប្រាប្នុវះ កិន្ត្វនេន កិមបិ នាបរាទ្ធំ។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","អថ ស យីឝុំ ជគាទ ហេ ប្រភេ ភវាន៑ ស្វរាជ្យប្រវេឝកាលេ មាំ ស្មរតុ។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","តទា យីឝុះ កថិតវាន៑ ត្វាំ យថាត៌្ហំ វទាមិ ត្វមទ្យៃវ មយា សាទ៌្ធំ បរលោកស្យ សុខស្ថានំ ប្រាប្ស្យសិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","អបរញ្ច ទ្វិតីយយាមាត៑ ត្ឫតីយយាមបយ៌្យន្តំ រវេស្តេជសោន្តហ៌ិតត្វាត៑ សវ៌្វទេឝោៜន្ធការេណាវ្ឫតោ ");
INSERT INTO sankhm_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","មន្ទិរស្យ យវនិកា ច ឆិទ្យមានា ទ្វិធា ពភូវ។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","តតោ យីឝុរុច្ចៃរុវាច, ហេ បិត រ្មមាត្មានំ តវ ករេ សមប៌យេ, ឥត្យុក្ត្វា ស ប្រាណាន៑ ជហៅ។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","តទៃតា ឃដនា ទ្ឫឞ្ដ្វា ឝតសេនាបតិរីឝ្វរំ ធន្យមុក្ត្វា កថិតវាន៑ អយំ និតាន្តំ សាធុមនុឞ្យ អាសីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","អថ យាវន្តោ លោកា ទ្រឞ្ដុម៑ អាគតាស្តេ តា ឃដនា ទ្ឫឞ្ដ្វា វក្ឞះសុ ករាឃាតំ ក្ឫត្វា វ្យាចុដ្យ គតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","យីឝោ រ្ជ្ញាតយោ យា យា យោឞិតឝ្ច គាលីលស្តេន សាទ៌្ធមាយាតាស្តា អបិ ទូរេ ស្ថិត្វា តត៑ សវ៌្វំ ទទ្ឫឝុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","តទា យិហូទីយានាំ មន្ត្រណាំ ក្រិយាញ្ចាសម្មន្យមាន ឦឝ្វរស្យ រាជត្វម៑ អបេក្ឞមាណោ ");
INSERT INTO sankhm_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","យិហូទិទេឝីយោ ៜរិមថីយនគរីយោ យូឞផ្នាមា មន្ត្រី ភទ្រោ ធាម៌្មិកឝ្ច បុមាន្ ");
INSERT INTO sankhm_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","បីលាតាន្តិកំ គត្វា យីឝោ រ្ទេហំ យយាចេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","បឝ្ចាទ៑ វបុរវរោហ្យ វាសសា សំវេឞ្ដ្យ យត្រ កោបិ មានុឞោ នាស្ថាប្យត តស្មិន៑ ឝៃលេ ស្វាតេ ឝ្មឝានេ តទស្ថាបយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","តទ្ទិនមាយោជនីយំ ទិនំ វិឝ្រាមវារឝ្ច សមីបះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","អបរំ យីឝុនា សាទ៌្ធំ គាលីល អាគតា យោឞិតះ បឝ្ចាទិត្វា ឝ្មឝានេ តត្រ យថា វបុះ ស្ថាបិតំ តច្ច ទ្ឫឞ្ដ្វា ");
INSERT INTO sankhm_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","វ្យាឃុដ្យ សុគន្ធិទ្រវ្យតៃលានិ ក្ឫត្វា វិធិវទ៑ វិឝ្រាមវារេ វិឝ្រាមំ ចក្រុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","អថ សប្តាហប្រថមទិនេៜតិប្រត្យូឞេ តា យោឞិតះ សម្បាទិតំ សុគន្ធិទ្រវ្យំ គ្ឫហីត្វា តទន្យាភិះ កិយតីភិះ ស្ត្រីភិះ សហ ឝ្មឝានំ យយុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","កិន្តុ ឝ្មឝានទ្វារាត៑ បាឞាណមបសារិតំ ទ្ឫឞ្ដ្វា ");
INSERT INTO sankhm_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","តាះ ប្រវិឝ្យ ប្រភោ រ្ទេហមប្រាប្យ ");
INSERT INTO sankhm_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","វ្យាកុលា ភវន្តិ ឯតហ៌ិ តេជោមយវស្ត្រាន្វិតៅ ទ្វៅ បុរុឞៅ តាសាំ សមីបេ សមុបស្ថិតៅ ");
INSERT INTO sankhm_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","តស្មាត្តាះ ឝង្កាយុក្តា ភូមាវធោមុខ្យស្យស្ថុះ។ តទា តៅ តា ឩចតុ រ្ម្ឫតានាំ មធ្យេ ជីវន្តំ កុតោ ម្ឫគយថ? ");
INSERT INTO sankhm_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","សោត្រ នាស្តិ ស ឧទស្ថាត៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","បាបិនាំ ករេឞុ សមប៌ិតេន ក្រុឝេ ហតេន ច មនុឞ្យបុត្រេណ ត្ឫតីយទិវសេ ឝ្មឝានាទុត្ថាតវ្យម៑ ឥតិ កថាំ ស គលីលិ តិឞ្ឋន៑ យុឞ្មភ្យំ កថិតវាន៑ តាំ ស្មរត។ ");
INSERT INTO sankhm_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","តទា តស្យ សា កថា តាសាំ មនះសុ ជាតា។ ");
INSERT INTO sankhm_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","អនន្តរំ ឝ្មឝានាទ៑ គត្វា តា ឯកាទឝឝិឞ្យាទិភ្យះ សវ៌្វេភ្យស្តាំ វាត៌្តាំ កថយាមាសុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","មគ្ទលីនីមរិយម៑, យោហនា, យាកូពោ មាតា មរិយម៑ តទន្យាះ សង្គិន្យោ យោឞិតឝ្ច ប្រេរិតេភ្យ ឯតាះ សវ៌្វា វាត៌្តាះ កថយាមាសុះ ");
INSERT INTO sankhm_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","កិន្តុ តាសាំ កថាម៑ អនត៌្ហកាខ្យានមាត្រំ ពុទ្ធ្វា កោបិ ន ប្រត្យៃត៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","តទា បិតរ ឧត្ថាយ ឝ្មឝានាន្តិកំ ទធាវ, តត្រ ច ប្រហ្វោ ភូត្វា បាឝ៌្វៃកស្ថាបិតំ កេវលំ វស្ត្រំ ទទឝ៌; តស្មាទាឝ្ចយ៌្យំ មន្យមានោ យទឃដត តន្មនសិ វិចារយន៑ ប្រតស្ថេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","តស្មិន្នេវ ទិនេ ទ្វៅ ឝិយ្យៅ យិរូឝាលមឝ្ចតុឞ្ក្រោឝាន្តរិតម៑ ឥម្មាយុគ្រាមំ គច្ឆន្តៅ ");
INSERT INTO sankhm_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","តាសាំ ឃដនានាំ កថាមកថយតាំ ");
INSERT INTO sankhm_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","តយោរាលាបវិចារយោះ កាលេ យីឝុរាគត្យ តាភ្យាំ សហ ជគាម ");
INSERT INTO sankhm_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","កិន្តុ យថា តៅ តំ ន បរិចិនុតស្តទត៌្ហំ តយោ រ្ទ្ឫឞ្ដិះ សំរុទ្ធា។ ");
INSERT INTO sankhm_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ស តៅ ប្ឫឞ្ដវាន៑ យុវាំ វិឞណ្ណៅ កិំ វិចារយន្តៅ គច្ឆថះ? ");
INSERT INTO sankhm_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","តតស្តយោះ ក្លិយបានាមា ប្រត្យុវាច យិរូឝាលមបុរេៜធុនា យាន្យឃដន្ត ត្វំ កេវលវិទេឝី កិំ តទ្វ្ឫត្តាន្តំ ន ជានាសិ? ");
INSERT INTO sankhm_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ស បប្រច្ឆ កា ឃដនាះ? តទា តៅ វក្តុមារេភាតេ យីឝុនាមា យោ នាសរតីយោ ភវិឞ្យទ្វាទី ឦឝ្វរស្យ មានុឞាណាញ្ច សាក្ឞាត៑ វាក្យេ កម៌្មណិ ច ឝក្តិមានាសីត្ ");
INSERT INTO sankhm_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","តម៑ អស្មាកំ ប្រធានយាជកា វិចារកាឝ្ច កេនាបិ ប្រការេណ ក្រុឝេ វិទ្ធ្វា តស្យ ប្រាណាននាឝយន៑ តទីយា ឃដនាះ; ");
INSERT INTO sankhm_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","កិន្តុ យ ឥស្រាយេលីយលោកាន៑ ឧទ្ធារយិឞ្យតិ ស ឯវាយម៑ ឥត្យាឝាស្មាភិះ ក្ឫតា។ តទ្យថា តថាស្តុ តស្យា ឃដនាយា អទ្យ ទិនត្រយំ គតំ។ ");
INSERT INTO sankhm_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","អធិកន្ត្វស្មាកំ សង្គិនីនាំ កិយត្ស្ត្រីណាំ មុខេភ្យោៜសម្ភវវាក្យមិទំ ឝ្រុតំ; ");
INSERT INTO sankhm_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","តាះ ប្រត្យូឞេ ឝ្មឝានំ គត្វា តត្រ តស្យ ទេហម៑ អប្រាប្យ វ្យាឃុដ្យេត្វា ប្រោក្តវត្យះ ស្វគ៌ីសទូតៅ ទ្ឫឞ្ដាវស្មាភិស្តៅ ចាវាទិឞ្ដាំ ស ជីវិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","តតោស្មាកំ កៃឝ្ចិត៑ ឝ្មឝានមគម្យត តេៜបិ ស្ត្រីណាំ វាក្យានុរូបំ ទ្ឫឞ្ដវន្តះ កិន្តុ តំ នាបឝ្យន៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","តទា ស តាវុវាច, ហេ អពោធៅ ហេ ភវិឞ្យទ្វាទិភិរុក្តវាក្យំ ប្រត្យេតុំ វិលម្ពមានៅ; ");
INSERT INTO sankhm_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ឯតត្សវ៌្វទុះខំ ភុក្ត្វា ស្វភូតិប្រាប្តិះ កិំ ខ្រីឞ្ដស្យ ន ន្យាយ្យា? ");
INSERT INTO sankhm_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","តតះ ស មូសាគ្រន្ថមារភ្យ សវ៌្វភវិឞ្យទ្វាទិនាំ សវ៌្វឝាស្ត្រេ ស្វស្មិន៑ លិខិតាខ្យានាភិប្រាយំ ពោធយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","អថ គម្យគ្រាមាភ្យណ៌ំ ប្រាប្យ តេនាគ្រេ គមនលក្ឞណេ ទឝ៌ិតេ ");
INSERT INTO sankhm_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","តៅ សាធយិត្វាវទតាំ សហាវាភ្យាំ តិឞ្ឋ ទិនេ គតេ សតិ រាត្រិរភូត៑; តតះ ស តាភ្យាំ សាទ៌្ធំ ស្ថាតុំ គ្ឫហំ យយៅ។ ");
INSERT INTO sankhm_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","បឝ្ចាទ្ភោជនោបវេឝកាលេ ស បូបំ គ្ឫហីត្វា ឦឝ្វរគុណាន៑ ជគាទ តញ្ច ភំក្ត្វា តាភ្យាំ ទទៅ។ ");
INSERT INTO sankhm_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","តទា តយោ រ្ទ្ឫឞ្ដៅ ប្រសន្នាយាំ តំ ប្រត្យភិជ្ញតុះ កិន្តុ ស តយោះ សាក្ឞាទន្តទ៌ធេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","តតស្តៅ មិថោភិធាតុម៑ អារព្ធវន្តៅ គមនកាលេ យទា កថាមកថយត៑ ឝាស្ត្រាត៌្ហញ្ចពោធយត៑ តទាវយោ រ្ពុទ្ធិះ កិំ ន ប្រាជ្វលត៑? ");
INSERT INTO sankhm_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","តៅ តត្ក្ឞណាទុត្ថាយ យិរូឝាលមបុរំ ប្រត្យាយយតុះ, តត្ស្ថានេ ឝិឞ្យាណាម៑ ឯកាទឝានាំ សង្គិនាញ្ច ទឝ៌នំ ជាតំ។ ");
INSERT INTO sankhm_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","តេ ប្រោចុះ ប្រភុរុទតិឞ្ឋទ៑ ឥតិ សត្យំ ឝិមោនេ ទឝ៌នមទាច្ច។ ");
INSERT INTO sankhm_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","តតះ បថះ សវ៌្វឃដនាយាះ បូបភញ្ជនេន តត្បរិចយស្យ ច សវ៌្វវ្ឫត្តាន្តំ តៅ វក្តុមារេភាតេ។ ");
INSERT INTO sankhm_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ឥត្ថំ តេ បរស្បរំ វទន្តិ តត្កាលេ យីឝុះ ស្វយំ តេឞាំ មធ្យ ប្រោត្ថយ យុឞ្មាកំ កល្យាណំ ភូយាទ៑ ឥត្យុវាច, ");
INSERT INTO sankhm_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","កិន្តុ ភូតំ បឝ្យាម ឥត្យនុមាយ តេ សមុទ្វិវិជិរេ ត្រេឞុឝ្ច។ ");
INSERT INTO sankhm_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","ស ឧវាច, កុតោ ទុះខិតា ភវថ? យុឞ្មាកំ មនះសុ សន្ទេហ ឧទេតិ ច កុតះ? ");
INSERT INTO sankhm_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ឯឞោហំ, មម ករៅ បឝ្យត វរំ ស្ប្ឫឞ្ដ្វា បឝ្យត, មម យាទ្ឫឝានិ បឝ្យថ តាទ្ឫឝានិ ភូតស្យ មាំសាស្ថីនិ ន សន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ឥត្យុក្ត្វា ស ហស្តបាទាន៑ ទឝ៌យាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","តេៜសម្ភវំ ជ្ញាត្វា សានន្ទា ន ប្រត្យយន៑។ តតះ ស តាន៑ បប្រច្ឆ, អត្រ យុឞ្មាកំ សមីបេ ខាទ្យំ កិញ្ចិទស្តិ? ");
INSERT INTO sankhm_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","តតស្តេ កិយទ្ទគ្ធមត្ស្យំ មធុ ច ទទុះ ");
INSERT INTO sankhm_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ស តទាទាយ តេឞាំ សាក្ឞាទ៑ ពុភុជេ ");
INSERT INTO sankhm_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","កថយាមាស ច មូសាវ្យវស្ថាយាំ ភវិឞ្យទ្វាទិនាំ គ្រន្ថេឞុ គីតបុស្តកេ ច មយិ យានិ សវ៌្វាណិ វចនានិ លិខិតានិ តទនុរូបាណិ ឃដិឞ្យន្តេ យុឞ្មាភិះ សាទ៌្ធំ ស្ថិត្វាហំ យទេតទ្វាក្យម៑ អវទំ តទិទានីំ ប្រត្យក្ឞមភូត៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","អថ តេភ្យះ ឝាស្ត្រពោធាធិការំ ទត្វាវទត៑, ");
INSERT INTO sankhm_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ខ្រីឞ្ដេនេត្ថំ ម្ឫតិយាតនា ភោក្តវ្យា ត្ឫតីយទិនេ ច ឝ្មឝានាទុត្ថាតវ្យញ្ចេតិ លិបិរស្តិ; ");
INSERT INTO sankhm_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","តន្នាម្នា យិរូឝាលមមារភ្យ សវ៌្វទេឝេ មនះបរាវត៌្តនស្យ បាបមោចនស្យ ច សុសំវាទះ ប្រចារយិតវ្យះ, ");
INSERT INTO sankhm_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ឯឞុ សវ៌្វេឞុ យូយំ សាក្ឞិណះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","អបរញ្ច បឝ្យត បិត្រា យត៑ ប្រតិជ្ញាតំ តត៑ ប្រេឞយិឞ្យាមិ, អតឯវ យាវត្កាលំ យូយំ ស្វគ៌ីយាំ ឝក្តិំ ន ប្រាប្ស្យថ តាវត្កាលំ យិរូឝាលម្នគរេ តិឞ្ឋត។ ");
INSERT INTO sankhm_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","អថ ស តាន៑ ពៃថនីយាបយ៌្យន្តំ នីត្វា ហស្តាវុត្តោល្យ អាឝិឞ វក្តុមារេភេ ");
INSERT INTO sankhm_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","អាឝិឞំ វទន្នេវ ច តេភ្យះ ប្ឫថគ៑ ភូត្វា ស្វគ៌ាយ នីតោៜភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","តទា តេ តំ ភជមានា មហានន្ទេន យិរូឝាលមំ ប្រត្យាជគ្មុះ។ ");
INSERT INTO sankhm_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","តតោ និរន្តរំ មន្ទិរេ តិឞ្ឋន្ត ឦឝ្វរស្យ ប្រឝំសាំ ធន្យវាទញ្ច កត៌្តម៑ អារេភិរេ។ ឥតិ៕ ");
INSERT INTO sankhm_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","អាទៅ វាទ អាសីត៑ ស ច វាទ ឦឝ្វរេណ សាទ៌្ហមាសីត៑ ស វាទះ ស្វយមីឝ្វរ ឯវ។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ស អាទាវីឝ្វរេណ សហាសីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","តេន សវ៌្វំ វស្តុ សស្ឫជេ សវ៌្វេឞុ ស្ឫឞ្ដវស្តុឞុ កិមបិ វស្តុ តេនាស្ឫឞ្ដំ នាស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ស ជីវនស្យាការះ, តច្ច ជីវនំ មនុឞ្យាណាំ ជ្យោតិះ ");
INSERT INTO sankhm_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","តជ្ជ្យោតិរន្ធការេ ប្រចកាឝេ កិន្ត្វន្ធការស្តន្ន ជគ្រាហ។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","យោហន៑ នាមក ឯកោ មនុជ ឦឝ្វរេណ ប្រេឞយាញ្ចក្រេ។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","តទ្វារា យថា សវ៌្វេ វិឝ្វសន្តិ តទត៌្ហំ ស តជ្ជ្យោតិឞិ ប្រមាណំ ទាតុំ សាក្ឞិស្វរូបោ ភូត្វាគមត៑, ");
INSERT INTO sankhm_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ស ស្វយំ តជ្ជ្យោតិ រ្ន កិន្តុ តជ្ជ្យោតិឞិ ប្រមាណំ ទាតុមាគមត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ជគត្យាគត្យ យះ សវ៌្វមនុជេភ្យោ ទីប្តិំ ទទាតិ តទេវ សត្យជ្យោតិះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ស យជ្ជគទស្ឫជត៑ តន្មទ្យ ឯវ ស អាសីត៑ កិន្តុ ជគតោ លោកាស្តំ នាជានន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","និជាធិការំ ស អាគច្ឆត៑ កិន្តុ ប្រជាស្តំ នាគ្ឫហ្លន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","តថាបិ យេ យេ តមគ្ឫហ្លន៑ អត៌្ហាត៑ តស្យ នាម្និ វ្យឝ្វសន៑ តេភ្យ ឦឝ្វរស្យ បុត្រា ភវិតុម៑ អធិការម៑ អទទាត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","តេឞាំ ជនិះ ឝោណិតាន្ន ឝារីរិកាភិលាឞាន្ន មានវានាមិច្ឆាតោ ន កិន្ត្វីឝ្វរាទភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","ស វាទោ មនុឞ្យរូបេណាវតីយ៌្យ សត្យតានុគ្រហាភ្យាំ បរិបូណ៌ះ សន៑ សាទ៌្ហម៑ អស្មាភិ រ្ន្យវសត៑ តតះ បិតុរទ្វិតីយបុត្រស្យ យោគ្យោ យោ មហិមា តំ មហិមានំ តស្យាបឝ្យាម។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","តតោ យោហនបិ ប្រចាយ៌្យ សាក្ឞ្យមិទំ ទត្តវាន៑ យោ មម បឝ្ចាទ៑ អាគមិឞ្យតិ ស មត្តោ គុរុតរះ; យតោ មត្បូវ៌្វំ ស វិទ្យមាន អាសីត៑; យទត៌្ហម៑ អហំ សាក្ឞ្យមិទម៑ អទាំ ស ឯឞះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","អបរញ្ច តស្យ បូណ៌តាយា វយំ សវ៌្វេ ក្រមឝះ ក្រមឝោនុគ្រហំ ប្រាប្តាះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","មូសាទ្វារា វ្យវស្ថា ទត្តា កិន្ត្វនុគ្រហះ សត្យត្វញ្ច យីឝុខ្រីឞ្ដទ្វារា សមុបាតិឞ្ឋតាំ។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","កោបិ មនុជ ឦឝ្វរំ កទាបិ នាបឝ្យត៑ កិន្តុ បិតុះ ក្រោឌស្ថោៜទ្វិតីយះ បុត្រស្តំ ប្រកាឝយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","ត្វំ កះ? ឥតិ វាក្យំ ប្រេឞ្ដុំ យទា យិហូទីយលោកា យាជកាន៑ លេវិលោកាំឝ្ច យិរូឝាលមោ យោហនះ សមីបេ ប្រេឞយាមាសុះ, ");
INSERT INTO sankhm_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","តទា ស ស្វីក្ឫតវាន៑ នាបហ្នូតវាន៑ នាហម៑ អភិឞិក្ត ឥត្យង្គីក្ឫតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","តទា តេៜប្ឫច្ឆន៑ តហ៌ិ កោ ភវាន៑? កិំ ឯលិយះ? សោវទត៑ ន; តតស្តេៜប្ឫច្ឆន៑ តហ៌ិ ភវាន៑ ស ភវិឞ្យទ្វាទី? សោវទត៑ នាហំ សះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","តទា តេៜប្ឫច្ឆន៑ តហ៌ិ ភវាន៑ កះ? វយំ គត្វា ប្រេរកាន៑ ត្វយិ កិំ វក្ឞ្យាមះ? ស្វស្មិន៑ កិំ វទសិ? ");
INSERT INTO sankhm_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","តទា សោវទត៑។ បរមេឝស្យ បន្ថានំ បរិឞ្កុរុត សវ៌្វតះ។ ឥតីទំ ប្រាន្តរេ វាក្យំ វទតះ កស្យចិទ្រវះ។ កថាមិមាំ យស្មិន៑ យិឝយិយោ ភវិឞ្យទ្វាទី លិខិតវាន៑ សោហម៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","យេ ប្រេឞិតាស្តេ ផិរូឝិលោកាះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","តទា តេៜប្ឫច្ឆន៑ យទិ នាភិឞិក្តោសិ ឯលិយោសិ ន ស ភវិឞ្យទ្វាទ្យបិ នាសិ ច, តហ៌ិ លោកាន៑ មជ្ជយសិ កុតះ? ");
INSERT INTO sankhm_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","តតោ យោហន៑ ប្រត្យវោចត៑, តោយេៜហំ មជ្ជយាមីតិ សត្យំ កិន្តុ យំ យូយំ ន ជានីថ តាទ្ឫឝ ឯកោ ជនោ យុឞ្មាកំ មធ្យ ឧបតិឞ្ឋតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ស មត្បឝ្ចាទ៑ អាគតោបិ មត្បូវ៌្វំ វត៌្តមាន អាសីត៑ តស្យ បាទុកាពន្ធនំ មោចយិតុមបិ នាហំ យោគ្យោស្មិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","យទ៌្ទននទ្យាះ បារស្ថពៃថពារាយាំ យស្មិន្ស្ថានេ យោហនមជ្ជយត៑ តស្មិន ស្ថានេ សវ៌្វមេតទ៑ អឃដត។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","បរេៜហនិ យោហន៑ ស្វនិកដមាគច្ឆន្តំ យិឝុំ វិលោក្យ ប្រាវោចត៑ ជគតះ បាបមោចកម៑ ឦឝ្វរស្យ មេឞឝាវកំ បឝ្យត។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","យោ មម បឝ្ចាទាគមិឞ្យតិ ស មត្តោ គុរុតរះ, យតោ ហេតោម៌ត្បូវ៌្វំ សោៜវត៌្តត យស្មិន្នហំ កថាមិមាំ កថិតវាន៑ ស ឯវាយំ។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","អបរំ នាហមេនំ ប្រត្យភិជ្ញាតវាន៑ កិន្តុ ឥស្រាយេល្លោកា ឯនំ យថា បរិចិន្វន្តិ តទភិប្រាយេណាហំ ជលេ មជ្ជយិតុមាគច្ឆម៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","បុនឝ្ច យោហនបរមេកំ ប្រមាណំ ទត្វា កថិតវាន៑ វិហាយសះ កបោតវទ៑ អវតរន្តមាត្មានម៑ អស្យោបយ៌្យវតិឞ្ឋន្តំ ច ទ្ឫឞ្ដវានហម៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","នាហមេនំ ប្រត្យភិជ្ញាតវាន៑ ឥតិ សត្យំ កិន្តុ យោ ជលេ មជ្ជយិតុំ មាំ ប្រៃរយត៑ ស ឯវេមាំ កថាមកថយត៑ យស្យោបយ៌្យាត្មានម៑ អវតរន្តម៑ អវតិឞ្ឋន្តញ្ច ទ្រក្ឞយសិ សឯវ បវិត្រេ អាត្មនិ មជ្ជយិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","អវស្តន្និរីក្ឞ្យាយម៑ ឦឝ្វរស្យ តនយ ឥតិ ប្រមាណំ ទទាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","បរេៜហនិ យោហន៑ ទ្វាភ្យាំ ឝិឞ្យាភ្យាំ សាទ៌្ធេំ តិឞ្ឋន្ ");
INSERT INTO sankhm_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","យិឝុំ គច្ឆន្តំ វិលោក្យ គទិតវាន៑, ឦឝ្វរស្យ មេឞឝាវកំ បឝ្យតំ។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ឥមាំ កថាំ ឝ្រុត្វា ទ្វៅ ឝិឞ្យៅ យីឝោះ បឝ្ចាទ៑ ឦយតុះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","តតោ យីឝុះ បរាវ្ឫត្យ តៅ បឝ្ចាទ៑ អាគច្ឆន្តៅ ទ្ឫឞ្ដ្វា ប្ឫឞ្ដវាន៑ យុវាំ កិំ គវេឝយថះ? តាវប្ឫច្ឆតាំ ហេ រព្ពិ អត៌្ហាត៑ ហេ គុរោ ភវាន៑ កុត្រ តិឞ្ឋតិ? ");
INSERT INTO sankhm_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","តតះ សោវាទិត៑ ឯត្យ បឝ្យតំ។ តតោ ទិវសស្យ ត្ឫតីយប្រហរស្យ គតត្វាត៑ តៅ តទ្ទិនំ តស្យ សង្គេៜស្ថាតាំ។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","យៅ ទ្វៅ យោហនោ វាក្យំ ឝ្រុត្វា យិឝោះ បឝ្ចាទ៑ អាគមតាំ តយោះ ឝិមោន្បិតរស្យ ភ្រាតា អាន្ទ្រិយះ ");
INSERT INTO sankhm_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ស ឥត្វា ប្រថមំ និជសោទរំ ឝិមោនំ សាក្ឞាត្ប្រាប្យ កថិតវាន៑ វយំ ខ្រីឞ្ដម៑ អត៌្ហាត៑ អភិឞិក្តបុរុឞំ សាក្ឞាត្ក្ឫតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","បឝ្ចាត៑ ស តំ យិឝោះ សមីបម៑ អានយត៑។ តទា យីឝុស្តំ ទ្ឫឞ្ដ្វាវទត៑ ត្វំ យូនសះ បុត្រះ ឝិមោន៑ កិន្តុ ត្វន្នាមធេយំ កៃផាះ វា បិតរះ អត៌្ហាត៑ ប្រស្តរោ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","បរេៜហនិ យីឝៅ គាលីលំ គន្តុំ និឝ្ចិតចេតសិ សតិ ផិលិបនាមានំ ជនំ សាក្ឞាត្ប្រាប្យាវោចត៑ មម បឝ្ចាទ៑ អាគច្ឆ។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ពៃត្សៃទានាម្និ យស្មិន៑ គ្រាមេ បិតរាន្ទ្រិយយោវ៌ាស អាសីត៑ តស្មិន៑ គ្រាមេ តស្យ ផិលិបស្យ វសតិរាសីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","បឝ្ចាត៑ ផិលិបោ និថនេលំ សាក្ឞាត្ប្រាប្យាវទត៑ មូសា វ្យវស្ថា គ្រន្ថេ ភវិឞ្យទ្វាទិនាំ គ្រន្ថេឞុ ច យស្យាខ្យានំ លិខិតមាស្តេ តំ យូឞផះ បុត្រំ នាសរតីយំ យីឝុំ សាក្ឞាទ៑ អកាឞ៌្ម វយំ។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","តទា និថនេល៑ កថិតវាន៑ នាសរន្នគរាត កិំ កឝ្ចិទុត្តម ឧត្បន្តុំ ឝក្នោតិ? តតះ ផិលិបោ ៜវោចត៑ ឯត្យ បឝ្យ។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","អបរញ្ច យីឝុះ ស្វស្យ សមីបំ តម៑ អាគច្ឆន្តំ ទ្ឫឞ្ដ្វា វ្យាហ្ឫតវាន៑, បឝ្យាយំ និឞ្កបដះ សត្យ ឥស្រាយេល្លោកះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","តតះ សោវទទ៑, ភវាន៑ មាំ កថំ ប្រត្យភិជានាតិ? យីឝុរវាទីត៑ ផិលិបស្យ អាហ្វានាត៑ បូវ៌្វំ យទា ត្វមុឌុម្ពរស្យ តរោម៌ូលេៜស្ថាស្តទា ត្វាមទឝ៌ម៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","និថនេល៑ អចកថត៑, ហេ គុរោ ភវាន៑ និតាន្តម៑ ឦឝ្វរស្យ បុត្រោសិ, ភវាន៑ ឥស្រាយេល្វំឝស្យ រាជា។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","តតោ យីឝុ រ្វ្យាហរត៑, ត្វាមុឌុម្ពរស្យ បាទបស្យ មូលេ ទ្ឫឞ្ដវានាហំ មមៃតស្មាទ្វាក្យាត៑ កិំ ត្វំ វ្យឝ្វសីះ? ឯតស្មាទប្យាឝ្ចយ៌្យាណិ កាយ៌្យាណិ ទ្រក្ឞ្យសិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","អន្យច្ចាវាទីទ៑ យុឞ្មានហំ យថាត៌្ហំ វទាមិ, ឥតះ បរំ មោចិតេ មេឃទ្វារេ តស្មាន្មនុជសូនុនា ឦឝ្វរស្យ ទូតគណម៑ អវរោហន្តមារោហន្តញ្ច ទ្រក្ឞ្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","អនន្តរំ ត្រុតីយទិវសេ គាលីល៑ ប្រទេឝិយេ កាន្នានាម្និ នគរេ វិវាហ អាសីត៑ តត្រ ច យីឝោម៌ាតា តិឞ្ឋត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","តស្មៃ វិវាហាយ យីឝុស្តស្យ ឝិឞ្យាឝ្ច និមន្ត្រិតា អាសន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","តទនន្តរំ ទ្រាក្ឞារសស្យ ន្យូនត្វាទ៑ យីឝោម៌ាតា តមវទត៑ ឯតេឞាំ ទ្រាក្ឞារសោ នាស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","តទា ស តាមវោចត៑ ហេ នារិ មយា សហ តវ កិំ កាយ៌្យំ? មម សមយ ឥទានីំ នោបតិឞ្ឋតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","តតស្តស្យ មាតា ទាសានវោចទ៑ អយំ យទ៑ វទតិ តទេវ កុរុត។ ");
INSERT INTO sankhm_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","តស្មិន៑ ស្ថានេ យិហូទីយានាំ ឝុចិត្វករណវ្យវហារានុសារេណាឍកៃកជលធរាណិ បាឞាណមយានិ ឞឌ្វ្ឫហត្បាត្រាណិអាសន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","តទា យីឝុស្តាន៑ សវ៌្វកលឝាន៑ ជលៃះ បូរយិតុំ តានាជ្ញាបយត៑, តតស្តេ សវ៌្វាន៑ កុម្ភានាកណ៌ំ ជលៃះ បយ៌្យបូរយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","អថ តេភ្យះ កិញ្ចិទុត្តាយ៌្យ ភោជ្យាធិបាតេះសមីបំ នេតុំ ស តានាទិឝត៑, តេ តទនយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","អបរញ្ច តជ្ជលំ កថំ ទ្រាក្ឞារសោៜភវត៑ តជ្ជលវាហកាទាសា ជ្ញាតុំ ឝក្តាះ កិន្តុ តទ្ភោជ្យាធិបោ ជ្ញាតុំ នាឝក្នោត៑ តទវលិហ្យ វរំ សំម្ពោទ្យាវទត, ");
INSERT INTO sankhm_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","លោកាះ ប្រថមំ ឧត្តមទ្រាក្ឞារសំ ទទតិ តឞុ យថេឞ្ដំ បិតវត្សុ តស្មា កិញ្ចិទនុត្តមញ្ច ទទតិ កិន្តុ ត្វមិទានីំ យាវត៑ ឧត្តមទ្រាក្ឞារសំ ស្ថាបយសិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ឥត្ថំ យីឝុគ៌ាលីលប្រទេឝេ អាឝ្ចយ៌្យកាម៌្ម ប្រារម្ភ និជមហិមានំ ប្រាកាឝយត៑ តតះ ឝិឞ្យាស្តស្មិន៑ វ្យឝ្វសន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","តតះ បរម៑ ស និជមាត្រុភ្រាត្រុស្ឝិឞ្យៃះ សាទ៌្ធ្ំ កផន៌ាហូមម៑ អាគមត៑ កិន្តុ តត្រ ពហូទិនានិ អាតិឞ្ឋត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","តទនន្តរំ យិហូទិយានាំ និស្តារោត្សវេ និកដមាគតេ យីឝុ រ្យិរូឝាលម៑ នគរម៑ អាគច្ឆត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","តតោ មន្ទិរស្យ មធ្យេ គោមេឞបារាវតវិក្រយិណោ វាណិជក្ឞ្ចោបវិឞ្ដាន៑ វិលោក្យ ");
INSERT INTO sankhm_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","រជ្ជុភិះ កឝាំ និម៌្មាយ សវ៌្វគោមេឞាទិភិះ សាទ៌្ធំ តាន៑ មន្ទិរាទ៑ ទូរីក្ឫតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","វណិជាំ មុទ្រាទិ វិកីយ៌្យ អាសនានិ ន្យូព្ជីក្ឫត្យ បារាវតវិក្រយិភ្យោៜកថយទ៑ អស្មាត៑ ស្ថានាត៑ សវ៌ាណ្យេតានិ នយត, មម បិតុគ្ឫហំ វាណិជ្យគ្ឫហំ មា កាឞ៌្ដ។ ");
INSERT INTO sankhm_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","តស្មាត៑ តន្មន្ទិរាត៌្ហ ឧទ្យោគោ យស្តុ ស គ្រសតីវ មាម៑។ ឥមាំ ឝាស្ត្រីយលិបិំ ឝិឞ្យាះសមស្មរន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","តតះ បរម៑ យិហូទីយលោកា យីឞិមវទន៑ តវមិទ្ឫឝកម៌្មករណាត៑ កិំ ចិហ្នមស្មាន៑ ទឝ៌យសិ? ");
INSERT INTO sankhm_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","តតោ យីឝុស្តានវោចទ៑ យុឞ្មាភិរេ តស្មិន៑ មន្ទិរេ នាឝិតេ ទិនត្រយមធ្យេៜហំ តទ៑ ឧត្ថាបយិឞ្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","តទា យិហូទិយា វ្យាហាឞ៌ុះ, ឯតស្យ មន្ទិរស និម៌្មាណេន ឞដ្ចត្វារិំឝទ៑ វត្សរា គតាះ, ត្វំ កិំ ទិនត្រយមធ្យេ តទ៑ ឧត្ថាបយិឞ្យសិ? ");
INSERT INTO sankhm_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","កិន្តុ ស និជទេហរូបមន្ទិរេ កថាមិមាំ កថិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ស យទេតាទ្ឫឝំ គទិតវាន៑ តច្ឆិឞ្យាះ ឝ្មឝានាត៑ តទីយោត្ថានេ សតិ ស្ម្ឫត្វា ធម៌្មគ្រន្ថេ យីឝុនោក្តកថាយាំ ច វ្យឝ្វសិឞុះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","អនន្តរំ និស្តារោត្សវស្យ ភោជ្យសមយេ យិរូឝាលម៑ នគរេ តត្ក្រុតាឝ្ចយ៌្យកម៌្មាណិ វិលោក្យ ពហុភិស្តស្យ នាមនិ វិឝ្វសិតំ។ ");
INSERT INTO sankhm_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","កិន្តុ ស តេឞាំ ករេឞុ ស្វំ ន សមប៌យត៑, យតះ ស សវ៌្វានវៃត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ស មានវេឞុ កស្យចិត៑ ប្រមាណំ នាបេក្ឞត យតោ មនុជានាំ មធ្យេ យទ្យទស្តិ តត្តត៑ សោជានាត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","និកទិមនាមា យិហូទីយានាម៑ អធិបតិះ ផិរូឝី ក្ឞណទាយាំ ");
INSERT INTO sankhm_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","យីឝៅរភ្យណ៌ម៑ អាវ្រជ្យ វ្យាហាឞ៌ីត៑, ហេ គុរោ ភវាន៑ ឦឝ្វរាទ៑ អាគត៑ ឯក ឧបទេឞ្ដា, ឯតទ៑ អស្មាភិជ៌្ញាយតេ; យតោ ភវតា យាន្យាឝ្ចយ៌្យកម៌្មាណិ ក្រិយន្តេ បរមេឝ្វរស្យ សាហាយ្យំ វិនា កេនាបិ តត្តត្កម៌្មាណិ កត៌្តុំ ន ឝក្យន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","តទា យីឝុរុត្តរំ ទត្តវាន៑ តវាហំ យថាត៌្ហតរំ វ្យាហរាមិ បុនជ៌ន្មនិ ន សតិ កោបិ មានវ ឦឝ្វរស្យ រាជ្យំ ទ្រឞ្ដុំ ន ឝក្នោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","តតោ និកទីមះ ប្រត្យវោចត៑ មនុជោ វ្ឫទ្ធោ ភូត្វា កថំ ជនិឞ្យតេ? ស កិំ បុន រ្មាត្ឫជ៌ឋរំ ប្រវិឝ្យ ជនិតុំ ឝក្នោតិ? ");
INSERT INTO sankhm_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","យីឝុរវាទីទ៑ យថាត៌្ហតរម៑ អហំ កថយាមិ មនុជេ តោយាត្មភ្យាំ បុន រ្ន ជាតេ ស ឦឝ្វរស្យ រាជ្យំ ប្រវេឞ្ដុំ ន ឝក្នោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","មាំសាទ៑ យត៑ ជាយតេ តន៑ មាំសមេវ តថាត្មនោ យោ ជាយតេ ស អាត្មៃវ។ ");
INSERT INTO sankhm_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","យុឞ្មាភិះ បុន រ្ជនិតវ្យំ មមៃតស្យាំ កថាយាម៑ អាឝ្ចយ៌ំ មា មំស្ថាះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","សទាគតិយ៌ាំ ទិឝមិច្ឆតិ តស្យាមេវ ទិឝិ វាតិ, ត្វំ តស្យ ស្វនំ ឝុណោឞិ កិន្តុ ស កុត អាយាតិ កុត្រ យាតិ វា កិមបិ ន ជានាសិ តទ្វាទ៑ អាត្មនះ សកាឝាត៑ សវ៌្វេឞាំ មនុជានាំ ជន្ម ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","តទា និកទីមះ ប្ឫឞ្ដវាន៑ ឯតត៑ កថំ ភវិតុំ ឝក្នោតិ? ");
INSERT INTO sankhm_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","យីឝុះ ប្រត្យក្តវាន៑ ត្វមិស្រាយេលោ គុរុព៌្ហូត្វាបិ កិមេតាំ កថាំ ន វេត្សិ? ");
INSERT INTO sankhm_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","តុភ្យំ យថាត៌្ហំ កថយាមិ, វយំ យទ៑ វិទ្មស្តទ៑ វច្មះ យំច្ច បឝ្យាមស្តស្យៃវ សាក្ឞ្យំ ទទ្មះ កិន្តុ យុឞ្មាភិរស្មាកំ សាក្ឞិត្វំ ន គ្ឫហ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ឯតស្យ សំសារស្យ កថាយាំ កថិតាយាំ យទិ យូយំ ន វិឝ្វសិថ តហ៌ិ ស្វគ៌ីយាយាំ កថាយាំ កថំ វិឝ្វសិឞ្យថ? ");
INSERT INTO sankhm_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","យះ ស្វគ៌េៜស្តិ យំ ច ស្វគ៌ាទ៑ អវារោហត៑ តំ មានវតនយំ វិនា កោបិ ស្វគ៌ំ នារោហត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","អបរញ្ច មូសា យថា ប្រាន្តរេ សប៌ំ ប្រោត្ថាបិតវាន៑ មនុឞ្យបុត្រោៜបិ តថៃវោត្ថាបិតវ្យះ; ");
INSERT INTO sankhm_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","តស្មាទ៑ យះ កឝ្ចិត៑ តស្មិន៑ វិឝ្វសិឞ្យតិ សោៜវិនាឝ្យះ សន៑ អនន្តាយុះ ប្រាប្ស្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ឦឝ្វរ ឥត្ថំ ជគទទយត យត៑ ស្វមទ្វិតីយំ តនយំ ប្រាទទាត៑ តតោ យះ កឝ្ចិត៑ តស្មិន៑ វិឝ្វសិឞ្យតិ សោៜវិនាឝ្យះ សន៑ អនន្តាយុះ ប្រាប្ស្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ឦឝ្វរោ ជគតោ លោកាន៑ ទណ្ឌយិតុំ ស្វបុត្រំ ន ប្រេឞ្យ តាន៑ បរិត្រាតុំ ប្រេឞិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","អតឯវ យះ កឝ្ចិត៑ តស្មិន៑ វិឝ្វសិតិ ស ទណ្ឌាហ៌ោ ន ភវតិ កិន្តុ យះ កឝ្ចិត៑ តស្មិន៑ ន វិឝ្វសិតិ ស ឥទានីមេវ ទណ្ឌាហ៌ោ ភវតិ,យតះ ស ឦឝ្វរស្យាទ្វិតីយបុត្រស្យ នាមនិ ប្រត្យយំ ន ករោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","ជគតោ មធ្យេ ជ្យោតិះ ប្រាកាឝត កិន្តុ មនុឞ្យាណាំ កម៌្មណាំ ទ្ឫឞ្ដត្វាត៑ តេ ជ្យោតិឞោបិ តិមិរេ ប្រីយន្តេ ឯតទេវ ទណ្ឌស្យ ការណាំ ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","យះ កុកម៌្ម ករោតិ តស្យាចារស្យ ទ្ឫឞ្ដត្វាត៑ ស ជ្យោតិរ្ឬតីយិត្វា តន្និកដំ នាយាតិ; ");
INSERT INTO sankhm_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","កិន្តុ យះ សត្កម៌្ម ករោតិ តស្យ សវ៌្វាណិ កម៌្មាណីឝ្វរេណ ក្ឫតានីតិ សថា ប្រកាឝតេ តទភិប្រាយេណ ស ជ្យោតិឞះ សន្និធិម៑ អាយាតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","តតះ បរម៑ យីឝុះ ឝិឞ្យៃះ សាទ៌្ធំ យិហូទីយទេឝំ គត្វា តត្រ ស្ថិត្វា មជ្ជយិតុម៑ អារភត។ ");
INSERT INTO sankhm_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","តទា ឝាលម៑ នគរស្យ សមីបស្ថាយិនិ ឰនន៑ គ្រាមេ ពហុតរតោយស្ថិតេស្តត្រ យោហន៑ អមជ្ជយត៑ តថា ច លោកា អាគត្យ តេន មជ្ជិតា អភវន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","តទា យោហន៑ ការាយាំ ន ពទ្ធះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","អបរញ្ច ឝាចកម៌្មណិ យោហានះ ឝិឞ្យៃះ សហ យិហូទីយលោកានាំ វិវាទេ ជាតេ, តេ យោហនះ សំន្និធិំ គត្វាកថយន៑, ");
INSERT INTO sankhm_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ហេ គុរោ យទ៌្ទននទ្យាះ បារេ ភវតា សាទ៌្ធំ យ អាសីត៑ យស្មិំឝ្ច ភវាន៑ សាក្ឞ្យំ ប្រទទាត៑ បឝ្យតុ សោបិ មជ្ជយតិ សវ៌្វេ តស្យ សមីបំ យាន្តិ ច។ ");
INSERT INTO sankhm_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","តទា យោហន៑ ប្រត្យវោចទ៑ ឦឝ្វរេណ ន ទត្តេ កោបិ មនុជះ កិមបិ ប្រាប្តុំ ន ឝក្នោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","អហំ អភិឞិក្តោ ន ភវាមិ កិន្តុ តទគ្រេ ប្រេឞិតោស្មិ យាមិមាំ កថាំ កថិតវានាហំ តត្រ យូយំ សវ៌្វេ សាក្ឞិណះ ស្ថ។ ");
INSERT INTO sankhm_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","យោ ជនះ កន្យាំ លភតេ ស ឯវ វរះ កិន្តុ វរស្យ សន្និធៅ ទណ្ឌាយមានំ តស្យ យន្មិត្រំ តេន វរស្យ ឝព្ទេ ឝ្រុតេៜតីវាហ្លាទ្យតេ មមាបិ តទ្វទ៑ អានន្ទសិទ្ធិជ៌ាតា។ ");
INSERT INTO sankhm_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","តេន ក្រមឝោ វទ៌្ធិតវ្យំ កិន្តុ មយា ហ្សិតវ្យំ។ ");
INSERT INTO sankhm_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","យ ឩទ៌្ហ្វាទាគច្ឆត៑ ស សវ៌្វេឞាំ មុខ្យោ យឝ្ច សំសារាទ៑ ឧទបទ្យត ស សាំសារិកះ សំសារីយាំ កថាញ្ច កថយតិ យស្តុ ស្វគ៌ាទាគច្ឆត៑ ស សវ៌្វេឞាំ មុខ្យះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ស យទបឝ្យទឝ្ឫណោច្ច តស្មិន្នេវ សាក្ឞ្យំ ទទាតិ តថាបិ ប្រាយឝះ កឝ្ចិត៑ តស្យ សាក្ឞ្យំ ន គ្ឫហ្លាតិ; ");
INSERT INTO sankhm_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","កិន្តុ យោ គ្ឫហ្លាតិ ស ឦឝ្វរស្យ សត្យវាទិត្វំ មុទ្រាង្គិតំ ករោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ឦឝ្វរេណ យះ ប្រេរិតះ សឯវ ឦឝ្វរីយកថាំ កថយតិ យត ឦឝ្វរ អាត្មានំ តស្មៃ អបរិមិតម៑ អទទាត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","បិតា បុត្រេ ស្នេហំ ក្ឫត្វា តស្យ ហស្តេ សវ៌្វាណិ សមប៌ិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","យះ កឝ្ចិត៑ បុត្រេ វិឝ្វសិតិ ស ឯវានន្តម៑ បរមាយុះ ប្រាប្នោតិ កិន្តុ យះ កឝ្ចិត៑ បុត្រេ ន វិឝ្វសិតិ ស បរមាយុឞោ ទឝ៌នំ ន ប្រាប្នោតិ កិន្ត្វីឝ្វរស្យ កោបភាជនំ ភូត្វា តិឞ្ឋតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","យីឝុះ ស្វយំ នាមជ្ជយត៑ កេវលំ តស្យ ឝិឞ្យា អមជ្ជយត៑ កិន្តុ យោហនោៜធិកឝិឞ្យាន៑ ស ករោតិ មជ្ជយតិ ច, ");
INSERT INTO sankhm_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ផិរូឝិន ឥមាំ វាត៌្តាមឝ្ឫណ្វន៑ ឥតិ ប្រភុរវគត្យ ");
INSERT INTO sankhm_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","យិហូទីយទេឝំ វិហាយ បុន រ្គាលីលម៑ អាគត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","តតះ ឝោមិរោណប្រទេឝស្យ មទ្យេន តេន គន្តវ្យេ សតិ ");
INSERT INTO sankhm_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","យាកូព៑ និជបុត្រាយ យូឞផេ យាំ ភូមិម៑ អទទាត៑ តត្សមីបស្ថាយិ ឝោមិរោណប្រទេឝស្យ សុខារ៑ នាម្នា វិខ្យាតស្យ នគរស្យ សន្និធាវុបាស្ថាត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","តត្រ យាកូពះ ប្រហិរាសីត៑; តទា ទ្វិតីយយាមវេលាយាំ ជាតាយាំ ស មាគ៌េ ឝ្រមាបន្នស្តស្យ ប្រហេះ បាឝ៌្វេ ឧបាវិឝត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ឯតហ៌ិ កាចិត៑ ឝោមិរោណីយា យោឞិត៑ តោយោត្តោលនាត៌្ហម៑ តត្រាគមត្ ");
INSERT INTO sankhm_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","តទា ឝិឞ្យាះ ខាទ្យទ្រវ្យាណិ ក្រេតុំ នគរម៑ អគច្ឆន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","យីឝុះ ឝោមិរោណីយាំ តាំ យោឞិតម៑ វ្យាហាឞ៌ីត៑ មហ្យំ កិញ្ចិត៑ បានីយំ បាតុំ ទេហិ។ កិន្តុ ឝោមិរោណីយៃះ សាកំ យិហូទីយលោកា ន វ្យវាហរន៑ តស្មាទ្ធេតោះ សាកថយត៑ ឝោមិរោណីយា យោឞិតទហំ ត្វំ យិហូទីយោសិ កថំ មត្តះ បានីយំ បាតុម៑ ឥច្ឆសិ? ");
INSERT INTO sankhm_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","តតោ យីឝុរវទទ៑ ឦឝ្វរស្យ យទ្ទានំ តត្កីទ្ឫក៑ បានីយំ បាតុំ មហ្យំ ទេហិ យ ឥត្ថំ ត្វាំ យាចតេ ស វា ក ឥតិ ចេទជ្ញាស្យថាស្តហ៌ិ តមយាចិឞ្យថាះ ស ច តុភ្យមម្ឫតំ តោយមទាស្យត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","តទា សា សីមន្តិនី ភាឞិតវតិ, ហេ មហេច្ឆ ប្រហិគ៌ម្ភីរោ ភវតោ នីរោត្តោលនបាត្រំ នាស្តី ច តស្មាត៑ តទម្ឫតំ កីលាលំ កុតះ ប្រាប្ស្យសិ? ");
INSERT INTO sankhm_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","យោស្មភ្យម៑ ឥមមន្ធូំ ទទៅ, យស្យ ច បរិជនា គោមេឞាទយឝ្ច សវ៌្វេៜស្យ ប្រហេះ បានីយំ បបុរេតាទ្ឫឝោ យោស្មាកំ បូវ៌្វបុរុឞោ យាកូព៑ តស្មាទបិ ភវាន៑ មហាន៑ កិំ? ");
INSERT INTO sankhm_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","តតោ យីឝុរកថយទ៑ ឥទំ បានីយំ សះ បិវតិ ស បុនស្ត្ឫឞាត៌្តោ ភវិឞ្យតិ, ");
INSERT INTO sankhm_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","កិន្តុ មយា ទត្តំ បានីយំ យះ បិវតិ ស បុនះ កទាបិ ត្ឫឞាត៌្តោ ន ភវិឞ្យតិ។ មយា ទត្តម៑ ឥទំ តោយំ តស្យាន្តះ ប្រស្រវណរូបំ ភូត្វា អនន្តាយុយ៌ាវត៑ ស្រោឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","តទា សា វនិតាកថយត៑ ហេ មហេច្ឆ តហ៌ិ មម បុនះ បីបាសា យថា ន ជាយតេ តោយោត្តោលនាយ យថាត្រាគមនំ ន ភវតិ ច តទត៌្ហំ មហ្យំ តត្តោយំ ទេហី។ ");
INSERT INTO sankhm_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","តតោ យីឝូរវទទ្យាហិ តវ បតិមាហូយ ស្ថានេៜត្រាគច្ឆ។ ");
INSERT INTO sankhm_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","សា វាមាវទត៑ មម បតិន៌ាស្តិ។ យីឝុរវទត៑ មម បតិន៌ាស្តីតិ វាក្យំ ភទ្រមវោចះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","យតស្តវ បញ្ច បតយោភវន៑ អធុនា តុ ត្វយា សាទ៌្ធំ យស្តិឞ្ឋតិ ស តវ ភត៌្តា ន វាក្យមិទំ សត្យមវាទិះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","តទា សា មហិលា គទិតវតិ ហេ មហេច្ឆ ភវាន៑ ឯកោ ភវិឞ្យទ្វាទីតិ ពុទ្ធំ មយា។ ");
INSERT INTO sankhm_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","អស្មាកំ បិត្ឫលោកា ឯតស្មិន៑ ឝិលោច្ចយេៜភជន្ត, កិន្តុ ភវទ្ភិរុច្យតេ យិរូឝាលម៑ នគរេ ភជនយោគ្យំ ស្ថានមាស្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","យីឝុរវោចត៑ ហេ យោឞិត៑ មម វាក្យេ វិឝ្វសិហិ យទា យូយំ កេវលឝៃលេៜស្មិន៑ វា យិរូឝាលម៑ នគរេ បិតុព៌្ហជនំ ន ករិឞ្យធ្វេ កាល ឯតាទ្ឫឝ អាយាតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","យូយំ យំ ភជធ្វេ តំ ន ជានីថ, កិន្តុ វយំ យំ ភជាមហេ តំ ជានីមហេ, យតោ យិហូទីយលោកានាំ មធ្យាត៑ បរិត្រាណំ ជាយតេ។ ");
INSERT INTO sankhm_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","កិន្តុ យទា សត្យភក្តា អាត្មនា សត្យរូបេណ ច បិតុព៌្ហជនំ ករិឞ្យន្តេ សមយ ឯតាទ្ឫឝ អាយាតិ, វរម៑ ឥទានីមបិ វិទ្យតេ ; យត ឯតាទ្ឫឝោ ភត្កាន៑ បិតា ចេឞ្ដតេ។ ");
INSERT INTO sankhm_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ឦឝ្វរ អាត្មា; តតស្តស្យ យេ ភក្តាស្តៃះ ស អាត្មនា សត្យរូបេណ ច ភជនីយះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","តទា សា មហិលាវាទីត៑ ខ្រីឞ្ដនាម្នា វិខ្យាតោៜភិឞិក្តះ បុរុឞ អាគមិឞ្យតីតិ ជានាមិ ស ច សវ៌្វាះ កថា អស្មាន៑ ជ្ញាបយិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","តតោ យីឝុរវទត៑ ត្វយា សាទ៌្ធំ កថនំ ករោមិ យោៜហម៑ អហមេវ ស បុរុឞះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ឯតស្មិន៑ សមយេ ឝិឞ្យា អាគត្យ តថា ស្ត្រិយា សាទ៌្ធំ តស្យ កថោបកថនេ មហាឝ្ចយ៌្យម៑ អមន្យន្ត តថាបិ ភវាន៑ កិមិច្ឆតិ? យទ្វា កិមត៌្ហម៑ ឯតយា សាទ៌្ធំ កថាំ កថយតិ? ឥតិ កោបិ នាប្ឫច្ឆត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","តតះ បរំ សា នារី កលឝំ ស្ថាបយិត្វា នគរមធ្យំ គត្វា លោកេភ្យោកថាយទ្ ");
INSERT INTO sankhm_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","អហំ យទ្យត៑ កម៌្មាករវំ តត្សវ៌្វំ មហ្យមកថយទ៑ ឯតាទ្ឫឝំ មានវមេកម៑ អាគត្យ បឝ្យត រុ កិម៑ អភិឞិក្តោ ន ភវតិ ? ");
INSERT INTO sankhm_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","តតស្តេ នគរាទ៑ ពហិរាគត្យ តាតស្យ សមីបម៑ អាយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ឯតហ៌ិ ឝិឞ្យាះ សាធយិត្វា តំ វ្យាហាឞ៌ុះ ហេ គុរោ ភវាន៑ កិញ្ចិទ៑ ភូក្តាំ។ ");
INSERT INTO sankhm_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","តតះ សោវទទ៑ យុឞ្មាភិយ៌ន្ន ជ្ញាយតេ តាទ្ឫឝំ ភក្ឞ្យំ មមាស្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","តទា ឝិឞ្យាះ បរស្បរំ ប្រឞ្ដុម៑ អារម្ភន្ត, កិមស្មៃ កោបិ កិមបិ ភក្ឞ្យមានីយ ទត្តវាន៑? ");
INSERT INTO sankhm_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","យីឝុរវោចត៑ មត្ប្រេរកស្យាភិមតានុរូបករណំ តស្យៃវ កម៌្មសិទ្ធិការណញ្ច មម ភក្ឞ្យំ។ ");
INSERT INTO sankhm_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","មាសចតុឞ្ដយេ ជាតេ ឝស្យកត៌្តនសមយោ ភវិឞ្យតីតិ វាក្យំ យុឞ្មាភិះ កិំ នោទ្យតេ? កិន្ត្វហំ វទាមិ, ឝិរ ឧត្តោល្យ ក្ឞេត្រាណិ ប្រតិ និរីក្ឞ្យ បឝ្យត, ឥទានីំ កត៌្តនយោគ្យានិ ឝុក្លវណ៌ាន្យភវន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","យឝ្ឆិនត្តិ ស វេតនំ លភតេ អនន្តាយុះស្វរូបំ ឝស្យំ ស គ្ឫហ្លាតិ ច, តេនៃវ វប្តា ឆេត្តា ច យុគបទ៑ អានន្ទតះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ឥត្ថំ សតិ វបត្យេកឝ្ឆិនត្យន្យ ឥតិ វចនំ សិទ្ធ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","យត្រ យូយំ ន បយ៌្យឝ្រាម្យត តាទ្ឫឝំ ឝស្យំ ឆេត្តុំ យុឞ្មាន៑ ប្រៃរយម៑ អន្យេ ជនាះបយ៌្យឝ្រាម្យន៑ យូយំ តេឞាំ ឝ្រគស្យ ផលម៑ អលភធ្វម៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","យស្មិន៑ កាលេ យទ្យត៑ កម៌្មាកាឞ៌ំ តត្សវ៌្វំ ស មហ្យម៑ អកថយត៑ តស្យា វនិតាយា ឥទំ សាក្ឞ្យវាក្យំ ឝ្រុត្វា តន្នគរនិវាសិនោ ពហវះ ឝោមិរោណីយលោកា វ្យឝ្វសន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","តថា ច តស្យាន្តិកេ សមុបស្ថាយ ស្វេឞាំ សន្និធៅ កតិចិទ៑ ទិនានិ ស្ថាតុំ តស្មិន៑ វិនយម៑ អកុវ៌្វាន តស្មាត៑ ស ទិនទ្វយំ តត្ស្ថានេ ន្យវឞ្ដត្ ");
INSERT INTO sankhm_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","តតស្តស្យោបទេឝេន ពហវោៜបរេ វិឝ្វស្យ ");
INSERT INTO sankhm_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","តាំ យោឞាមវទន៑ កេវលំ តវ វាក្យេន ប្រតីម ឥតិ ន, កិន្តុ ស ជគតោៜភិឞិក្តស្ត្រាតេតិ តស្យ កថាំ ឝ្រុត្វា វយំ ស្វយមេវាជ្ញាសមហិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","ស្វទេឝេ ភវិឞ្យទ្វក្តុះ សត្ការោ នាស្តីតិ យទ្យបិ យីឝុះ ប្រមាណំ ទត្វាកថយត្ ");
INSERT INTO sankhm_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","តថាបិ ទិវសទ្វយាត៑ បរំ ស តស្មាត៑ ស្ថានាទ៑ គាលីលំ គតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","អនន្តរំ យេ គាលីលី លិយលោកា ឧត្សវេ គតា ឧត្សវសមយេ យិរូឝលម៑ នគរេ តស្យ សវ៌្វាះ ក្រិយា អបឝ្យន៑ តេ គាលីលម៑ អាគតំ តម៑ អាគ្ឫហ្លន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","តតះ បរម៑ យីឝុ រ្យស្មិន៑ កាន្នានគរេ ជលំ ទ្រាក្ឞារសម៑ អាករោត៑ តត៑ ស្ថានំ បុនរគាត៑។ តស្មិន្នេវ សមយេ កស្យចិទ៑ រាជសភាស្តារស្យ បុត្រះ កផន៌ាហូមបុរី រោគគ្រស្ត អាសីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ស យេហូទីយទេឝាទ៑ យីឝោ រ្គាលីលាគមនវាត៌្តាំ និឝម្យ តស្យ សមីបំ គត្វា ប្រាត៌្ហ្យ វ្យាហ្ឫតវាន៑ មម បុត្រស្យ ប្រាយេណ កាល អាសន្នះ ភវាន៑ អាគត្យ តំ ស្វស្ថំ ករោតុ។ ");
INSERT INTO sankhm_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","តទា យីឝុរកថយទ៑ អាឝ្ចយ៌្យំ កម៌្ម ចិត្រំ ចិហ្នំ ច ន ទ្ឫឞ្ដា យូយំ ន ប្រត្យេឞ្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","តតះ ស សភាសទវទត៑ ហេ មហេច្ឆ មម បុត្រេ ន ម្ឫតេ ភវានាគច្ឆតុ។ ");
INSERT INTO sankhm_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","យីឝុស្តមវទទ៑ គច្ឆ តវ បុត្រោៜជីវីត៑ តទា យីឝុនោក្តវាក្យេ ស វិឝ្វស្យ គតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","គមនកាលេ មាគ៌មធ្យេ ទាសាស្តំ សាក្ឞាត្ប្រាប្យាវទន៑ ភវតះ បុត្រោៜជីវីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","តតះ កំ កាលមារភ្យ រោគប្រតីការារម្ភោ ជាតា ឥតិ ប្ឫឞ្ដេ តៃរុក្តំ ហ្យះ សាទ៌្ធទណ្ឌទ្វយាធិកទ្វិតីយយាមេ តស្យ ជ្វរត្យាគោៜភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","តទា យីឝុស្តស្មិន៑ ក្ឞណេ ប្រោក្តវាន៑ តវ បុត្រោៜជីវីត៑ បិតា តទ្ពុទ្ធ្វា សបរិវារោ វ្យឝ្វសីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","យិហូទីយទេឝាទ៑ អាគត្យ គាលីលិ យីឝុរេតទ៑ ទ្វិតីយម៑ អាឝ្ចយ៌្យកម៌្មាករោត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","តតះ បរំ យិហូទីយានាម៑ ឧត្សវ ឧបស្ថិតេ យីឝុ រ្យិរូឝាលមំ គតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","តស្មិន្នគរេ មេឞនាម្នោ ទ្វារស្យ សមីបេ ឥព្រីយភាឞយា ពៃថេស្ទា នាម្នា បិឞ្ករិណី បញ្ចឃដ្ដយុក្តាសីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","តស្យាស្តេឞុ ឃដ្ដេឞុ កិលាលកម្បនម៑ អបេក្ឞ្យ អន្ធខញ្ចឝុឞ្កាង្គាទយោ ពហវោ រោគិណះ បតន្តស្តិឞ្ឋន្តិ ស្ម។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","យតោ វិឝេឞកាលេ តស្យ សរសោ វារិ ស្វគ៌ីយទូត ឯត្យាកម្បយត៑ តត្កីលាលកម្បនាត៑ បរំ យះ កឝ្ចិទ៑ រោគី ប្រថមំ បានីយមវារោហត៑ ស ឯវ តត្ក្ឞណាទ៑ រោគមុក្តោៜភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","តទាឞ្ដាត្រិំឝទ្វឞ៌ាណិ យាវទ៑ រោគគ្រស្ត ឯកជនស្តស្មិន៑ ស្ថានេ ស្ថិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","យីឝុស្តំ ឝយិតំ ទ្ឫឞ្ដ្វា ពហុកាលិករោគីតិ ជ្ញាត្វា វ្យាហ្ឫតវាន៑ ត្វំ កិំ ស្វស្ថោ ពុភូឞសិ? ");
INSERT INTO sankhm_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","តតោ រោគី កថិតវាន៑ ហេ មហេច្ឆ យទា កីលាលំ កម្បតេ តទា មាំ បុឞ្ករិណីម៑ អវរោហយិតុំ មម កោបិ នាស្តិ, តស្មាន៑ មម គមនកាលេ កឝ្ចិទន្យោៜគ្រោ គត្វា អវរោហតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","តទា យីឝុរកថយទ៑ ឧត្តិឞ្ឋ, តវ ឝយ្យាមុត្តោល្យ គ្ឫហីត្វា យាហិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","ស តត្ក្ឞណាត៑ ស្វស្ថោ ភូត្វា ឝយ្យាមុត្តោល្យាទាយ គតវាន៑ កិន្តុ តទ្ទិនំ វិឝ្រាមវារះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","តស្មាទ៑ យិហូទីយាះ ស្វស្ថំ នរំ វ្យាហរន៑ អទ្យ វិឝ្រាមវារេ ឝយនីយមាទាយ ន យាតវ្យម៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","តតះ ស ប្រត្យវោចទ៑ យោ មាំ ស្វស្ថម៑ អកាឞ៌ីត៑ ឝយនីយម៑ ឧត្តោល្យាទាយ យាតុំ មាំ ស ឯវាទិឝត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","តទា តេៜប្ឫច្ឆន៑ ឝយនីយម៑ ឧត្តោល្យាទាយ យាតុំ យ អាជ្ញាបយត៑ ស កះ? ");
INSERT INTO sankhm_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","កិន្តុ ស ក ឥតិ ស្វស្ថីភូតោ នាជានាទ៑ យតស្តស្មិន៑ ស្ថានេ ជនតាសត្ត្វាទ៑ យីឝុះ ស្ថានាន្តរម៑ អាគមត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","តតះ បរំ យេឝុ រ្មន្ទិរេ តំ នរំ សាក្ឞាត្ប្រាប្យាកថយត៑ បឝ្យេទានីម៑ អនាមយោ ជាតោសិ យថាធិកា ទុទ៌ឝា ន ឃដតេ តទ្ធេតោះ បាបំ កម៌្ម បុនម៌ាកាឞ៌ីះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","តតះ ស គត្វា យិហូទីយាន៑ អវទទ៑ យីឝុ រ្មាម៑ អរោគិណម៑ អកាឞ៌ីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","តតោ យីឝុ រ្វិឝ្រាមវារេ កម៌្មេទ្ឫឝំ ក្ឫតវាន៑ ឥតិ ហេតោ រ្យិហូទីយាស្តំ តាឌយិត្វា ហន្តុម៑ អចេឞ្ដន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","យីឝុស្តានាខ្យត៑ មម បិតា យត៑ កាយ៌្យំ ករោតិ តទនុរូបម៑ អហមបិ ករោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","តតោ យិហូទីយាស្តំ ហន្តុំ បុនរយតន្ត យតោ វិឝ្រាមវារំ នាមន្យត តទេវ កេវលំ ន អធិកន្តុ ឦឝ្វរំ ស្វបិតរំ ប្រោច្យ ស្វមបីឝ្វរតុល្យំ ក្ឫតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","បឝ្ចាទ៑ យីឝុរវទទ៑ យុឞ្មានហំ យថាត៌្ហតរំ វទាមិ បុត្រះ បិតរំ យទ្យត៑ កម៌្ម កុវ៌្វន្តំ បឝ្យតិ តទតិរិក្តំ ស្វេច្ឆាតះ កិមបិ កម៌្ម កត៌្តុំ ន ឝក្នោតិ។ បិតា យត៑ ករោតិ បុត្រោបិ តទេវ ករោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","បិតា បុត្រេ ស្នេហំ ករោតិ តស្មាត៑ ស្វយំ យទ្យត៑ កម៌្ម ករោតិ តត្សវ៌្វំ បុត្រំ ទឝ៌យតិ ; យថា ច យុឞ្មាកំ អាឝ្ចយ៌្យជ្ញានំ ជនិឞ្យតេ តទត៌្ហម៑ ឥតោបិ មហាកម៌្ម តំ ទឝ៌យិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","វស្តុតស្តុ បិតា យថា ប្រមិតាន៑ ឧត្ថាប្យ សជិវាន៑ ករោតិ តទ្វត៑ បុត្រោបិ យំ យំ ឥច្ឆតិ តំ តំ សជីវំ ករោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","សវ៌្វេ បិតរំ យថា សត្កុវ៌្វន្តិ តថា បុត្រមបិ សត្ការយិតុំ បិតា ស្វយំ កស្យាបិ វិចារមក្ឫត្វា សវ៌្វវិចារាណាំ ភារំ បុត្រេ សមប៌ិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","យះ បុត្រំ សត៑ ករោតិ ស តស្យ ប្រេរកមបិ សត៑ ករោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","យុឞ្មានាហំ យថាត៌្ហតរំ វទាមិ យោ ជនោ មម វាក្យំ ឝ្រុត្វា មត្ប្រេរកេ វិឝ្វសិតិ សោនន្តាយុះ ប្រាប្នោតិ កទាបិ ទណ្ឌពាជនំ ន ភវតិ និធនាទុត្ថាយ បរមាយុះ ប្រាប្នោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","អហំ យុឞ្មានតិយថាត៌្ហំ វទាមិ យទា ម្ឫតា ឦឝ្វរបុត្រស្យ និនាទំ ឝ្រោឞ្យន្តិ យេ ច ឝ្រោឞ្យន្តិ តេ សជីវា ភវិឞ្យន្តិ សមយ ឯតាទ្ឫឝ អាយាតិ វរម៑ ឥទានីមប្យុបតិឞ្ឋតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","បិតា យថា ស្វយញ្ជីវី តថា បុត្រាយ ស្វយញ្ជីវិត្វាធិការំ ទត្តវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ស មនុឞ្យបុត្រះ ឯតស្មាត៑ ការណាត៑ បិតា ទណ្ឌករណាធិការមបិ តស្មិន៑ សមប៌ិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","ឯតទត៌្ហេ យូយម៑ អាឝ្ចយ៌្យំ ន មន្យធ្វំ យតោ យស្មិន៑ សមយេ តស្យ និនាទំ ឝ្រុត្វា ឝ្មឝានស្ថាះ សវ៌្វេ ពហិរាគមិឞ្យន្តិ សមយ ឯតាទ្ឫឝ ឧបស្ថាស្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","តស្មាទ៑ យេ សត្កម៌្មាណិ ក្ឫតវន្តស្ត ឧត្ថាយ អាយុះ ប្រាប្ស្យន្តិ យេ ច កុកម៌ាណិ ក្ឫតវន្តស្ត ឧត្ថាយ ទណ្ឌំ ប្រាប្ស្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","អហំ ស្វយំ កិមបិ កត៌្តុំ ន ឝក្នោមិ យថា ឝុណោមិ តថា វិចារយាមិ មម វិចារញ្ច ន្យាយ្យះ យតោហំ ស្វីយាភីឞ្ដំ នេហិត្វា មត្ប្រេរយិតុះ បិតុរិឞ្ដម៑ ឦហេ។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","យទិ ស្វស្មិន៑ ស្វយំ សាក្ឞ្យំ ទទាមិ តហ៌ិ តត្សាក្ឞ្យម៑ អាគ្រាហ្យំ ភវតិ ; ");
INSERT INTO sankhm_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","កិន្តុ មទត៌្ហេៜបរោ ជនះ សាក្ឞ្យំ ទទាតិ មទត៌្ហេ តស្យ យត៑ សាក្ឞ្យំ តត៑ សត្យម៑ ឯតទប្យហំ ជានាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","យុឞ្មាភិ រ្យោហនំ ប្រតិ លោកេឞុ ប្រេរិតេឞុ ស សត្យកថាយាំ សាក្ឞ្យមទទាត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","មានុឞាទហំ សាក្ឞ្យំ នោបេក្ឞេ តថាបិ យូយំ យថា បរិត្រយធ្វេ តទត៌្ហម៑ ឥទំ វាក្យំ វទាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","យោហន៑ ទេទីប្យមានោ ទីប ឥវ តេជស្វី ស្ថិតវាន៑ យូយម៑ អល្បកាលំ តស្យ ទីប្ត្យានន្ទិតុំ សមមន្យធ្វំ។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","កិន្តុ តត្ប្រមាណាទបិ មម គុរុតរំ ប្រមាណំ វិទ្យតេ បិតា មាំ ប្រេឞ្យ យទ្យត៑ កម៌្ម សមាបយិតុំ ឝក្ត្តិមទទាត៑ មយា ក្ឫតំ តត្តត៑ កម៌្ម មទត៌្ហេ ប្រមាណំ ទទាតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","យះ បិតា មាំ ប្រេរិតវាន៑ មោបិ មទត៌្ហេ ប្រមាណំ ទទាតិ។ តស្យ វាក្យំ យុឞ្មាភិះ កទាបិ ន ឝ្រុតំ តស្យ រូបញ្ច ន ទ្ឫឞ្ដំ ");
INSERT INTO sankhm_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","តស្យ វាក្យញ្ច យុឞ្មាកម៑ អន្តះ កទាបិ ស្ថានំ នាប្នោតិ យតះ ស យំ ប្រេឞិតវាន៑ យូយំ តស្មិន៑ ន វិឝ្វសិថ។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","ធម៌្មបុស្តកានិ យូយម៑ អាលោចយធ្វំ តៃ រ្វាក្យៃរនន្តាយុះ ប្រាប្ស្យាម ឥតិ យូយំ ពុធ្យធ្វេ តទ្ធម៌្មបុស្តកានិ មទត៌្ហេ ប្រមាណំ ទទតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","តថាបិ យូយំ បរមាយុះប្រាប្តយេ មម សំនិធិម៑ ន ជិគមិឞថ។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","អហំ មានុឞេភ្យះ សត្ការំ ន គ្ឫហ្លាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","អហំ យុឞ្មាន៑ ជានាមិ; យុឞ្មាកមន្តរ ឦឝ្វរប្រេម នាស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","អហំ និជបិតុ រ្នាម្នាគតោស្មិ តថាបិ មាំ ន គ្ឫហ្លីថ កិន្តុ កឝ្ចិទ៑ យទិ ស្វនាម្នា សមាគមិឞ្យតិ តហ៌ិ តំ គ្រហីឞ្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","យូយម៑ ឦឝ្វរាត៑ សត្ការំ ន ចិឞ្ដត្វា កេវលំ បរស្បរំ សត្ការម៑ ចេទ៑ អាទធ្វ្វេ តហ៌ិ កថំ វិឝ្វសិតុំ ឝក្នុថ? ");
INSERT INTO sankhm_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","បុតុះ សមីបេៜហំ យុឞ្មាន៑ អបវទិឞ្យាមីតិ មា ចិន្តយត យស្មិន៑ , យស្មិន៑ យុឞ្មាកំ វិឝ្វសះ សឯវ មូសា យុឞ្មាន៑ អបវទតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","យទិ យូយំ តស្មិន៑ វ្យឝ្វសិឞ្យត តហ៌ិ មយ្យបិ វ្យឝ្វសិឞ្យត, យត៑ ស មយិ លិខិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","តតោ យទិ តេន លិខិតវានិ ន ប្រតិថ តហ៌ិ មម វាក្យានិ កថំ ប្រត្យេឞ្យថ? ");
INSERT INTO sankhm_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","តតះ បរំ យីឝុ រ្គាលីល៑ ប្រទេឝីយស្យ តិវិរិយានាម្នះ សិន្ធោះ បារំ គតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","តតោ វ្យាធិមល្លោកស្វាស្ថ្យករណរូបាណិ តស្យាឝ្ចយ៌្យាណិ កម៌្មាណិ ទ្ឫឞ្ដ្វា ពហវោ ជនាស្តត្បឝ្ចាទ៑ អគច្ឆន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","តតោ យីឝុះ បវ៌្វតមារុហ្យ តត្រ ឝិឞ្យៃះ សាកម៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","តស្មិន៑ សមយ និស្តារោត្សវនាម្និ យិហូទីយានាម ឧត្សវ ឧបស្ថិតេ ");
INSERT INTO sankhm_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","យីឝុ រ្នេត្រេ ឧត្តោល្យ ពហុលោកាន៑ ស្វសមីបាគតាន៑ វិលោក្យ ផិលិបំ ប្ឫឞ្ដវាន៑ ឯតេឞាំ ភោជនាយ ភោជទ្រវ្យាណិ វយំ កុត្រ ក្រេតុំ ឝក្រុមះ? ");
INSERT INTO sankhm_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","វាក្យមិទំ តស្យ បរីក្ឞាត៌្ហម៑ អវាទីត៑ កិន្តុ យត៑ ករិឞ្យតិ តត៑ ស្វយម៑ អជានាត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ផិលិបះ ប្រត្យវោចត៑ ឯតេឞាម៑ ឯកៃកោ យទ្យល្បម៑ អល្បំ ប្រាប្នោតិ តហ៌ិ មុទ្រាបាទទ្វិឝតេន ក្រីតបូបា អបិ ន្យូនា ភវិឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ឝិមោន៑ បិតរស្យ ភ្រាតា អាន្ទ្រិយាខ្យះ ឝិឞ្យាណាមេកោ វ្យាហ្ឫតវាន្ ");
INSERT INTO sankhm_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","អត្រ កស្យចិទ៑ ពាលកស្យ សមីបេ បញ្ច យាវបូបាះ ក្ឞុទ្រមត្ស្យទ្វយញ្ច សន្តិ កិន្តុ លោកានាំ ឯតាវាតាំ មធ្យេ តៃះ កិំ ភវិឞ្យតិ? ");
INSERT INTO sankhm_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","បឝ្ចាទ៑ យីឝុរវទត៑ លោកានុបវេឝយត តត្រ ពហុយវសសត្ត្វាត៑ បញ្ចសហស្ត្រេភ្យោ ន្យូនា អធិកា វា បុរុឞា ភូម្យាម៑ ឧបាវិឝន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","តតោ យីឝុស្តាន៑ បូបានាទាយ ឦឝ្វរស្យ គុណាន៑ កីត៌្តយិត្វា ឝិឞ្យេឞុ សមាប៌យត៑ តតស្តេ តេភ្យ ឧបវិឞ្ដលោកេភ្យះ បូបាន៑ យថេឞ្ដមត្ស្យញ្ច ប្រាទុះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","តេឞុ ត្ឫប្តេឞុ ស តានវោចទ៑ ឯតេឞាំ កិញ្ចិទបិ យថា នាបចីយតេ តថា សវ៌្វាណ្យវឝិឞ្ដានិ សំគ្ឫហ្លីត។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","តតះ សវ៌្វេឞាំ ភោជនាត៑ បរំ តេ តេឞាំ បញ្ចានាំ យាវបូបានាំ អវឝិឞ្ដាន្យខិលានិ សំគ្ឫហ្យ ទ្វាទឝឌល្លកាន៑ អបូរយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","អបរំ យីឝោរេតាទ្ឫឝីម៑ អាឝ្ចយ៌្យក្រិយាំ ទ្ឫឞ្ដ្វា លោកា មិថោ វក្តុមារេភិរេ ជគតិ យស្យាគមនំ ភវិឞ្យតិ ស ឯវាយម៑ អវឝ្យំ ភវិឞ្យទ្វក្ត្តា។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","អតឯវ លោកា អាគត្យ តមាក្រម្យ រាជានំ ករិឞ្យន្តិ យីឝុស្តេឞាម៑ ឦទ្ឫឝំ មានសំ វិជ្ញាយ បុនឝ្ច បវ៌្វតម៑ ឯកាកី គតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","សាយំកាល ឧបស្ថិតេ ឝិឞ្យា ជលធិតដំ វ្រជិត្វា នាវមារុហ្យ នគរទិឝិ សិន្ធៅ វាហយិត្វាគមន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","តស្មិន៑ សមយេ តិមិរ ឧបាតិឞ្ឋត៑ កិន្តុ យីឞុស្តេឞាំ សមីបំ នាគច្ឆត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","តទា ប្រពលបវនវហនាត៑ សាគរេ មហាតរង្គោ ភវិតុម៑ អារេភេ។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","តតស្តេ វាហយិត្វា ទ្វិត្រាន៑ ក្រោឝាន៑ គតាះ បឝ្ចាទ៑ យីឝុំ ជលធេរុបរិ បទ្ភ្យាំ វ្រជន្តំ នៅកាន្តិកម៑ អាគច្ឆន្តំ វិលោក្យ ត្រាសយុក្តា អភវន្ ");
INSERT INTO sankhm_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","កិន្តុ ស តានុក្ត្តវាន៑ អយមហំ មា ភៃឞ្ដ។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","តទា តេ តំ ស្វៃរំ នាវិ គ្ឫហីតវន្តះ តទា តត្ក្ឞណាទ៑ ឧទ្ទិឞ្ដស្ថានេ នៅរុបាស្ថាត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","យយា នាវា ឝិឞ្យា អគច្ឆន៑ តទន្យា កាបិ នៅកា តស្មិន៑ ស្ថានេ នាសីត៑ តតោ យីឝុះ ឝិឞ្យៃះ សាកំ នាគមត៑ កេវលាះ ឝិឞ្យា អគមន៑ ឯតត៑ បារស្ថា លោកា ជ្ញាតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","កិន្តុ តតះ បរំ ប្រភុ រ្យត្រ ឦឝ្វរស្យ គុណាន៑ អនុកីត៌្ត្យ លោកាន៑ បូបាន៑ អភោជយត៑ តត្ស្ថានស្យ សមីបស្ថតិវិរិយាយា អបរាស្តរណយ អាគមន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","យីឝុស្តត្រ នាស្តិ ឝិឞ្យា អបិ តត្រ នា សន្តិ លោកា ឥតិ វិជ្ញាយ យីឝុំ គវេឞយិតុំ តរណិភិះ កផន៌ាហូម៑ បុរំ គតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","តតស្តេ សរិត្បតេះ បារេ តំ សាក្ឞាត៑ ប្រាប្យ ប្រាវោចន៑ ហេ គុរោ ភវាន៑ អត្រ ស្ថានេ កទាគមត៑? ");
INSERT INTO sankhm_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","តទា យីឝុស្តាន៑ ប្រត្យវាទីទ៑ យុឞ្មានហំ យថាត៌្ហតរំ វទាមិ អាឝ្ចយ៌្យកម៌្មទឝ៌នាទ្ធេតោ រ្ន កិន្តុ បូបភោជនាត៑ តេន ត្ឫប្តត្វាញ្ច មាំ គវេឞយថ។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ក្ឞយណីយភក្ឞ្យាត៌្ហំ មា ឝ្រាមិឞ្ដ កិន្ត្វន្តាយុព៌្ហក្ឞ្យាត៌្ហំ ឝ្រាម្យត, តស្មាត៑ តាទ្ឫឝំ ភក្ឞ្យំ មនុជបុត្រោ យុឞ្មាភ្យំ ទាស្យតិ; តស្មិន៑ តាត ឦឝ្វរះ ប្រមាណំ ប្រាទាត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","តទា តេៜប្ឫច្ឆន៑ ឦឝ្វរាភិមតំ កម៌្ម កត៌្តុម៑ អស្មាភិះ កិំ កត៌្តវ្យំ? ");
INSERT INTO sankhm_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","តតោ យីឝុរវទទ៑ ឦឝ្វរោ យំ ប្រៃរយត៑ តស្មិន៑ វិឝ្វសនម៑ ឦឝ្វរាភិមតំ កម៌្ម។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","តទា តេ វ្យាហរន៑ ភវតា កិំ លក្ឞណំ ទឝ៌ិតំ យទ្ទ្ឫឞ្ដ្វា ភវតិ វិឝ្វសិឞ្យាមះ? ត្វយា កិំ កម៌្ម ក្ឫតំ? ");
INSERT INTO sankhm_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","អស្មាកំ បូវ៌្វបុរុឞា មហាប្រាន្តរេ មាន្នាំ ភោក្ត្តុំ ប្រាបុះ យថា លិបិរាស្តេ។ ស្វគ៌ីយាណិ តុ ភក្ឞ្យាណិ ប្រទទៅ បរមេឝ្វរះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","តទា យីឝុរវទទ៑ អហំ យុឞ្មានតិយថាត៌្ហំ វទាមិ មូសា យុឞ្មាភ្យំ ស្វគ៌ីយំ ភក្ឞ្យំ នាទាត៑ កិន្តុ មម បិតា យុឞ្មាភ្យំ ស្វគ៌ីយំ បរមំ ភក្ឞ្យំ ទទាតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","យះ ស្វគ៌ាទវរុហ្យ ជគតេ ជីវនំ ទទាតិ ស ឦឝ្វរទត្តភក្ឞ្យរូបះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","តទា តេ ប្រាវោចន៑ ហេ ប្រភោ ភក្ឞ្យមិទំ និត្យមស្មភ្យំ ទទាតុ។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","យីឝុរវទទ៑ អហមេវ ជីវនរូបំ ភក្ឞ្យំ យោ ជនោ មម សន្និធិម៑ អាគច្ឆតិ ស ជាតុ ក្ឞុធាត៌្តោ ន ភវិឞ្យតិ, តថា យោ ជនោ មាំ ប្រត្យេតិ ស ជាតុ ត្ឫឞាត៌្តោ ន ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","មាំ ទ្ឫឞ្ដ្វាបិ យូយំ ន វិឝ្វសិថ យុឞ្មានហម៑ ឥត្យវោចំ។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","បិតា មហ្យំ យាវតោ លោកានទទាត៑ តេ សវ៌្វ ឯវ មមាន្តិកម៑ អាគមិឞ្យន្តិ យះ កឝ្ចិច្ច មម សន្និធិម៑ អាយាស្យតិ តំ កេនាបិ ប្រការេណ ន ទូរីករិឞ្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","និជាភិមតំ សាធយិតុំ ន ហិ កិន្តុ ប្រេរយិតុរភិមតំ សាធយិតុំ ស្វគ៌ាទ៑ អាគតោស្មិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ស យាន៑ យាន៑ លោកាន៑ មហ្យមទទាត៑ តេឞាមេកមបិ ន ហារយិត្វា ឝេឞទិនេ សវ៌្វានហម៑ ឧត្ថាបយាមិ ឥទំ មត្ប្រេរយិតុះ បិតុរភិមតំ។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","យះ កឝ្ចិន៑ មានវសុតំ វិលោក្យ វិឝ្វសិតិ ស ឝេឞទិនេ មយោត្ថាបិតះ សន៑ អនន្តាយុះ ប្រាប្ស្យតិ ឥតិ មត្ប្រេរកស្យាភិមតំ។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","តទា ស្វគ៌ាទ៑ យទ៑ ភក្ឞ្យម៑ អវារោហត៑ តទ៑ ភក្ឞ្យម៑ អហមេវ យិហូទីយលោកាស្តស្យៃតទ៑ វាក្យេ វិវទមានា វក្ត្តុមារេភិរេ ");
INSERT INTO sankhm_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","យូឞផះ បុត្រោ យីឝុ រ្យស្យ មាតាបិតរៅ វយំ ជានីម ឯឞ កិំ សឯវ ន? តហ៌ិ ស្វគ៌ាទ៑ អវារោហម៑ ឥតិ វាក្យំ កថំ វក្ត្តិ? ");
INSERT INTO sankhm_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","តទា យីឝុស្តាន៑ ប្រត្យវទត៑ បរស្បរំ មា វិវទធ្វំ ");
INSERT INTO sankhm_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","មត្ប្រេរកេណ បិត្រា នាក្ឫឞ្ដះ កោបិ ជនោ មមាន្តិកម៑ អាយាតុំ ន ឝក្នោតិ កិន្ត្វាគតំ ជនំ ចរមេៜហ្និ ប្រោត្ថាបយិឞ្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","តេ សវ៌្វ ឦឝ្វរេណ ឝិក្ឞិតា ភវិឞ្យន្តិ ភវិឞ្យទ្វាទិនាំ គ្រន្ថេឞុ លិបិរិត្ថមាស្តេ អតោ យះ កឝ្ចិត៑ បិតុះ សកាឝាត៑ ឝ្រុត្វា ឝិក្ឞតេ ស ឯវ មម សមីបម៑ អាគមិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","យ ឦឝ្វរាទ៑ អជាយត តំ វិនា កោបិ មនុឞ្យោ ជនកំ នាទឝ៌ត៑ កេវលះ សឯវ តាតម៑ អទ្រាក្ឞីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","អហំ យុឞ្មាន៑ យថាត៌្ហតរំ វទាមិ យោ ជនោ មយិ វិឝ្វាសំ ករោតិ សោនន្តាយុះ ប្រាប្នោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","អហមេវ តជ្ជីវនភក្ឞ្យំ។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","យុឞ្មាកំ បូវ៌្វបុរុឞា មហាប្រាន្តរេ មន្នាភក្ឞ្យំ ភូក្ត្តាបិ ម្ឫតាះ ");
INSERT INTO sankhm_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","កិន្តុ យទ្ភក្ឞ្យំ ស្វគ៌ាទាគច្ឆត៑ តទ៑ យទិ កឝ្ចិទ៑ ភុង្ក្ត្តេ តហ៌ិ ស ន ម្រិយតេ។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","យជ្ជីវនភក្ឞ្យំ ស្វគ៌ាទាគច្ឆត៑ សោហមេវ ឥទំ ភក្ឞ្យំ យោ ជនោ ភុង្ក្ត្តេ ស និត្យជីវី ភវិឞ្យតិ។ បុនឝ្ច ជគតោ ជីវនាត៌្ហមហំ យត៑ ស្វកីយបិឝិតំ ទាស្យាមិ តទេវ មយា វិតរិតំ ភក្ឞ្យម៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","តស្មាទ៑ យិហូទីយាះ បរស្បរំ វិវទមានា វក្ត្តុមារេភិរេ ឯឞ ភោជនាត៌្ហំ ស្វីយំ បលលំ កថម៑ អស្មភ្យំ ទាស្យតិ? ");
INSERT INTO sankhm_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","តទា យីឝុស្តាន៑ អាវោចទ៑ យុឞ្មានហំ យថាត៌្ហតរំ វទាមិ មនុឞ្យបុត្រស្យាមិឞេ យុឞ្មាភិ រ្ន ភុក្ត្តេ តស្យ រុធិរេ ច ន បីតេ ជីវនេន សាទ៌្ធំ យុឞ្មាកំ សម្ពន្ធោ នាស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","យោ មមាមិឞំ ស្វាទតិ មម សុធិរញ្ច បិវតិ សោនន្តាយុះ ប្រាប្នោតិ តតះ ឝេឞេៜហ្និ តមហម៑ ឧត្ថាបយិឞ្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","យតោ មទីយមាមិឞំ បរមំ ភក្ឞ្យំ តថា មទីយំ ឝោណិតំ បរមំ បេយំ។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","យោ ជនោ មទីយំ បលលំ ស្វាទតិ មទីយំ រុធិរញ្ច បិវតិ ស មយិ វសតិ តស្មិន្នហញ្ច វសាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","មត្ប្រេរយិត្រា ជីវតា តាតេន យថាហំ ជីវាមិ តទ្វទ៑ យះ កឝ្ចិន៑ មាមត្តិ សោបិ មយា ជីវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","យទ្ភក្ឞ្យំ ស្វគ៌ាទាគច្ឆត៑ តទិទំ យន្មាន្នាំ ស្វាទិត្វា យុឞ្មាកំ បិតរោៜម្រិយន្ត តាទ្ឫឝម៑ ឥទំ ភក្ឞ្យំ ន ភវតិ ឥទំ ភក្ឞ្យំ យោ ភក្ឞតិ ស និត្យំ ជីវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","យទា កផន៌ាហូម៑ បុយ៌្យាំ ភជនគេហេ ឧបាទិឝត៑ តទា កថា ឯតា អកថយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","តទេត្ថំ ឝ្រុត្វា តស្យ ឝិឞ្យាណាម៑ អនេកេ បរស្បរម៑ អកថយន៑ ឥទំ គាឍំ វាក្យំ វាក្យមីទ្ឫឝំ កះ ឝ្រោតុំ ឝក្រុយាត៑? ");
INSERT INTO sankhm_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","កិន្តុ យីឝុះ ឝិឞ្យាណាម៑ ឥត្ថំ វិវាទំ ស្វចិត្តេ វិជ្ញាយ កថិតវាន៑ ឥទំ វាក្យំ កិំ យុឞ្មាកំ វិឃ្នំ ជនយតិ? ");
INSERT INTO sankhm_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","យទិ មនុជសុតំ បូវ៌្វវាសស្ថានម៑ ឩទ៌្វ្វំ គច្ឆន្តំ បឝ្យថ តហ៌ិ កិំ ភវិឞ្យតិ? ");
INSERT INTO sankhm_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","អាត្មៃវ ជីវនទាយកះ វបុ រ្និឞ្ផលំ យុឞ្មភ្យមហំ យានិ វចាំសិ កថយាមិ តាន្យាត្មា ជីវនញ្ច។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","កិន្តុ យុឞ្មាកំ មធ្យេ កេចន អវិឝ្វាសិនះ សន្តិ កេ កេ ន វិឝ្វសន្តិ កោ វា តំ បរករេឞុ សមប៌យិឞ្យតិ តាន៑ យីឝុរាប្រថមាទ៑ វេត្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","អបរមបិ កថិតវាន៑ អស្មាត៑ ការណាទ៑ អកថយំ បិតុះ សកាឝាត៑ ឝក្ត្តិមប្រាប្យ កោបិ មមាន្តិកម៑ អាគន្តុំ ន ឝក្នោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","តត្កាលេៜនេកេ ឝិឞ្យា វ្យាឃុដ្យ តេន សាទ៌្ធំ បុន រ្នាគច្ឆន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","តទា យីឝុ រ្ទ្វាទឝឝិឞ្យាន៑ ឧក្ត្តវាន៑ យូយមបិ កិំ យាស្យថ? ");
INSERT INTO sankhm_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","តតះ ឝិមោន៑ បិតរះ ប្រត្យវោចត៑ ហេ ប្រភោ កស្យាភ្យណ៌ំ គមិឞ្យាមះ? ");
INSERT INTO sankhm_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","អនន្តជីវនទាយិន្យោ យាះ កថាស្តាស្តវៃវ។ ភវាន៑ អមរេឝ្វរស្យាភិឞិក្ត្តបុត្រ ឥតិ វិឝ្វស្យ និឝ្ចិតំ ជានីមះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","តទា យីឝុរវទត៑ កិមហំ យុឞ្មាកំ ទ្វាទឝជនាន៑ មនោនីតាន៑ ន ក្ឫតវាន៑? កិន្តុ យុឞ្មាកំ មធ្យេបិ កឝ្ចិទេកោ វិឃ្នការី វិទ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ឥមាំ កថំ ស ឝិមោនះ បុត្រម៑ ឦឞ្ករីយោតីយំ យិហូទាម៑ ឧទ្ទិឝ្យ កថិតវាន៑ យតោ ទ្វាទឝានាំ មធ្យេ គណិតះ ស តំ បរករេឞុ សមប៌យិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","តតះ បរំ យិហូទីយលោកាស្តំ ហន្តុំ សមៃហន្ត តស្មាទ៑ យីឝុ រ្យិហូទាប្រទេឝេ បយ៌្យដិតុំ នេច្ឆន៑ គាលីល៑ ប្រទេឝេ បយ៌្យដិតុំ ប្រារភត។ ");
INSERT INTO sankhm_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","កិន្តុ តស្មិន៑ សមយេ យិហូទីយានាំ ទូឞ្យវាសនាមោត្សវ ឧបស្ថិតេ ");
INSERT INTO sankhm_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","តស្យ ភ្រាតរស្តម៑ អវទន៑ យានិ កម៌្មាណិ ត្វយា ក្រិយន្តេ តានិ យថា តវ ឝិឞ្យាះ បឝ្យន្តិ តទត៌្ហំ ត្វមិតះ ស្ថានាទ៑ យិហូទីយទេឝំ វ្រជ។ ");
INSERT INTO sankhm_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","យះ កឝ្ចិត៑ ស្វយំ ប្រចិកាឝិឞតិ ស កទាបិ គុប្តំ កម៌្ម ន ករោតិ យទីទ្ឫឝំ កម៌្ម ករោឞិ តហ៌ិ ជគតិ និជំ បរិចាយយ។ ");
INSERT INTO sankhm_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","យតស្តស្យ ភ្រាតរោបិ តំ ន វិឝ្វសន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","តទា យីឝុស្តាន៑ អវោចត៑ មម សមយ ឥទានីំ នោបតិឞ្ឋតិ កិន្តុ យុឞ្មាកំ សមយះ សតតម៑ ឧបតិឞ្ឋតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","ជគតោ លោកា យុឞ្មាន៑ ឫតីយិតុំ ន ឝក្រុវន្តិ កិន្តុ មាមេវ ឫតីយន្តេ យតស្តេឞាំ កម៌ាណិ ទុឞ្ដានិ តត្រ សាក្ឞ្យមិទម៑ អហំ ទទាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","អតឯវ យូយម៑ ឧត្សវេៜស្មិន៑ យាត នាហម៑ ឥទានីម៑ អស្មិន្នុត្សវេ យាមិ យតោ មម សមយ ឥទានីំ ន សម្បូណ៌ះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ឥតិ វាក្យម៑ ឧក្ត្ត្វា ស គាលីលិ ស្ថិតវាន្ ");
INSERT INTO sankhm_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","កិន្តុ តស្យ ភ្រាត្ឫឞុ តត្រ ប្រស្ថិតេឞុ សត្សុ សោៜប្រកដ ឧត្សវម៑ អគច្ឆត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","អនន្តរម៑ ឧត្សវម៑ ឧបស្ថិតា យិហូទីយាស្តំ ម្ឫគយិត្វាប្ឫច្ឆន៑ ស កុត្រ? ");
INSERT INTO sankhm_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","តតោ លោកានាំ មធ្យេ តស្មិន៑ នានាវិធា វិវាទា ភវិតុម៑ អារព្ធវន្តះ។ កេចិទ៑ អវោចន៑ ស ឧត្តមះ បុរុឞះ កេចិទ៑ អវោចន៑ ន តថា វរំ លោកានាំ ភ្រមំ ជនយតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","កិន្តុ យិហូទីយានាំ ភយាត៑ កោបិ តស្យ បក្ឞេ ស្បឞ្ដំ នាកថយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","តតះ បរម៑ ឧត្សវស្យ មធ្យសមយេ យីឝុ រ្មន្ទិរំ គត្វា សមុបទិឝតិ ស្ម។ ");
INSERT INTO sankhm_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","តតោ យិហូទីយា លោកា អាឝ្ចយ៌្យំ ជ្ញាត្វាកថយន៑ ឯឞា មានុឞោ នាធីត្យា កថម៑ ឯតាទ្ឫឝោ វិទ្វានភូត៑? ");
INSERT INTO sankhm_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","តទា យីឝុះ ប្រត្យវោចទ៑ ឧបទេឝោយំ ន មម កិន្តុ យោ មាំ ប្រេឞិតវាន៑ តស្យ។ ");
INSERT INTO sankhm_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","យោ ជនោ និទេឝំ តស្យ គ្រហីឞ្យតិ មមោបទេឝោ មត្តោ ភវតិ កិម៑ ឦឝ្វរាទ៑ ភវតិ ស គនស្តជ្ជ្ញាតុំ ឝក្ឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","យោ ជនះ ស្វតះ កថយតិ ស ស្វីយំ គៅរវម៑ ឦហតេ កិន្តុ យះ ប្រេរយិតុ រ្គៅរវម៑ ឦហតេ ស សត្យវាទី តស្មិន៑ កោប្យធម៌្មោ នាស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","មូសា យុឞ្មភ្យំ វ្យវស្ថាគ្រន្ថំ កិំ នាទទាត៑? កិន្តុ យុឞ្មាកំ កោបិ តាំ វ្យវស្ថាំ ន សមាចរតិ។ មាំ ហន្តុំ កុតោ យតធ្វេ? ");
INSERT INTO sankhm_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","តទា លោកា អវទន៑ ត្វំ ភូតគ្រស្តស្ត្វាំ ហន្តុំ កោ យតតេ? ");
INSERT INTO sankhm_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","តតោ យីឝុរវោចទ៑ ឯកំ កម៌្ម មយាការិ តស្មាទ៑ យូយំ សវ៌្វ មហាឝ្ចយ៌្យំ មន្យធ្វេ។ ");
INSERT INTO sankhm_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","មូសា យុឞ្មភ្យំ ត្វក្ឆេទវិធិំ ប្រទទៅ ស មូសាតោ ន ជាតះ កិន្តុ បិត្ឫបុរុឞេភ្យោ ជាតះ តេន វិឝ្រាមវារេៜបិ មានុឞាណាំ ត្វក្ឆេទំ កុរុថ។ ");
INSERT INTO sankhm_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","អតឯវ វិឝ្រាមវារេ មនុឞ្យាណាំ ត្វក្ឆេទេ ក្ឫតេ យទិ មូសាវ្យវស្ថាមង្គនំ ន ភវតិ តហ៌ិ មយា វិឝ្រាមវារេ មានុឞះ សម្បូណ៌រូបេណ ស្វស្ថោៜការិ តត្ការណាទ៑ យូយំ កិំ មហ្យំ កុប្យថ? ");
INSERT INTO sankhm_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","សបក្ឞបាតំ វិចារមក្ឫត្វា ន្យាយ្យំ វិចារំ កុរុត។ ");
INSERT INTO sankhm_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","តទា យិរូឝាលម៑ និវាសិនះ កតិបយជនា អកថយន៑ ឥមេ យំ ហន្តុំ ចេឞ្ដន្តេ ស ឯវាយំ កិំ ន? ");
INSERT INTO sankhm_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","កិន្តុ បឝ្យត និព៌្ហយះ សន៑ កថាំ កថយតិ តថាបិ កិមបិ អ វទន្ត្យេតេ អយមេវាភិឞិក្ត្តោ ភវតីតិ និឝ្ចិតំ កិមធិបតយោ ជានន្តិ? ");
INSERT INTO sankhm_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","មនុជោយំ កស្មាទាគមទ៑ ឥតិ វយំ ជានោមះ កិន្ត្វភិឞិក្ត្ត អាគតេ ស កស្មាទាគតវាន៑ ឥតិ កោបិ ជ្ញាតុំ ន ឝក្ឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","តទា យីឝុ រ្មធ្យេមន្ទិរម៑ ឧបទិឝន៑ ឧច្ចៃះការម៑ ឧក្ត្តវាន៑ យូយំ កិំ មាំ ជានីថ? កស្មាច្ចាគតោស្មិ តទបិ កិំ ជានីថ? នាហំ ស្វត អាគតោស្មិ កិន្តុ យះ សត្យវាទី សឯវ មាំ ប្រេឞិតវាន៑ យូយំ តំ ន ជានីថ។ ");
INSERT INTO sankhm_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","តមហំ ជានេ តេនាហំ ប្រេរិត អគតោស្មិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","តស្មាទ៑ យិហូទីយាស្តំ ធត៌្តុម៑ ឧទ្យតាស្តថាបិ កោបិ តស្យ គាត្រេ ហស្តំ នាប៌យទ៑ យតោ ហេតោស្តទា តស្យ សមយោ នោបតិឞ្ឋតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","កិន្តុ ពហវោ លោកាស្តស្មិន៑ វិឝ្វស្យ កថិតវាន្តោៜភិឞិក្ត្តបុរុឞ អាគត្យ មានុឞស្យាស្យ ក្រិយាភ្យះ កិម៑ អធិកា អាឝ្ចយ៌្យាះ ក្រិយាះ ករិឞ្យតិ? ");
INSERT INTO sankhm_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","តតះ បរំ លោកាស្តស្មិន៑ ឥត្ថំ វិវទន្តេ ផិរូឝិនះ ប្រធានយាជកាញ្ចេតិ ឝ្រុតវន្តស្តំ ធ្ឫត្វា នេតុំ បទាតិគណំ ប្រេឞយាមាសុះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","តតោ យីឝុរវទទ៑ អហម៑ អល្បទិនានិ យុឞ្មាភិះ សាទ៌្ធំ ស្ថិត្វា មត្ប្រេរយិតុះ សមីបំ យាស្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","មាំ ម្ឫគយិឞ្យធ្វេ កិន្តូទ្ទេឝំ ន លប្ស្យធ្វេ រត្រ ស្ថាស្យាមិ តត្រ យូយំ គន្តុំ ន ឝក្ឞ្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","តទា យិហូទីយាះ បរស្បរំ វក្ត្តុមារេភិរេ អស្យោទ្ទេឝំ ន ប្រាប្ស្យាម ឯតាទ្ឫឝំ កិំ ស្ថានំ យាស្យតិ? ភិន្នទេឝេ វិកីណ៌ានាំ យិហូទីយានាំ សន្និធិម៑ ឯឞ គត្វា តាន៑ ឧបទេក្ឞ្យតិ កិំ? ");
INSERT INTO sankhm_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","នោ ចេត៑ មាំ គវេឞយិឞ្យថ កិន្តូទ្ទេឝំ ន ប្រាប្ស្យថ ឯឞ កោទ្ឫឝំ វាក្យមិទំ វទតិ? ");
INSERT INTO sankhm_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","អនន្តរម៑ ឧត្សវស្យ ចរមេៜហនិ អត៌្ហាត៑ ប្រធានទិនេ យីឝុរុត្តិឞ្ឋន៑ ឧច្ចៃះការម៑ អាហ្វយន៑ ឧទិតវាន៑ យទិ កឝ្ចិត៑ ត្ឫឞាត៌្តោ ភវតិ តហ៌ិ មមាន្តិកម៑ អាគត្យ បិវតុ។ ");
INSERT INTO sankhm_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","យះ កឝ្ចិន្មយិ វិឝ្វសិតិ ធម៌្មគ្រន្ថស្យ វចនានុសារេណ តស្យាភ្យន្តរតោៜម្ឫតតោយស្យ ស្រោតាំសិ និគ៌មិឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","យេ តស្មិន៑ វិឝ្វសន្តិ ត អាត្មានំ ប្រាប្ស្យន្តីត្យត៌្ហេ ស ឥទំ វាក្យំ វ្យាហ្ឫតវាន៑ ឯតត្កាលំ យាវទ៑ យីឝុ រ្វិភវំ ន ប្រាប្តស្តស្មាត៑ បវិត្រ អាត្មា នាទីយត។ ");
INSERT INTO sankhm_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ឯតាំ វាណីំ ឝ្រុត្វា ពហវោ លោកា អវទន៑ អយមេវ និឝ្ចិតំ ស ភវិឞ្យទ្វាទី។ ");
INSERT INTO sankhm_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","កេចិទ៑ អកថយន៑ ឯឞឯវ សោភិឞិក្ត្តះ កិន្តុ កេចិទ៑ អវទន៑ សោភិឞិក្ត្តះ កិំ គាលីល៑ ប្រទេឝេ ជនិឞ្យតេ? ");
INSERT INTO sankhm_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","សោភិឞិក្ត្តោ ទាយូទោ វំឝេ ទាយូទោ ជន្មស្ថានេ ពៃត្លេហមិ បត្តនេ ជនិឞ្យតេ ធម៌្មគ្រន្ថេ កិមិត្ថំ លិខិតំ នាស្តិ? ");
INSERT INTO sankhm_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ឥត្ថំ តស្មិន៑ លោកានាំ ភិន្នវាក្យតា ជាតា។ ");
INSERT INTO sankhm_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","កតិបយលោកាស្តំ ធត៌្តុម៑ ឰច្ឆន៑ តថាបិ តទ្វបុឞិ កោបិ ហស្តំ នាប៌យត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","អនន្តរំ បាទាតិគណេ ប្រធានយាជកានាំ ផិរូឝិនាញ្ច សមីបមាគតវតិ តេ តាន៑ អប្ឫច្ឆន៑ កុតោ ហេតោស្តំ នានយត? ");
INSERT INTO sankhm_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","តទា បទាតយះ ប្រត្យវទន៑ ស មានវ ឥវ កោបិ កទាបិ នោបាទិឝត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","តតះ ផិរូឝិនះ ប្រាវោចន៑ យូយមបិ កិមភ្រាមិឞ្ដ? ");
INSERT INTO sankhm_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","អធិបតីនាំ ផិរូឝិនាញ្ច កោបិ កិំ តស្មិន៑ វ្យឝ្វសីត៑? ");
INSERT INTO sankhm_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","យេ ឝាស្ត្រំ ន ជានន្តិ ត ឥមេៜធមលោកាឯវ ឝាបគ្រស្តាះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","តទា និកទីមនាមា តេឞាមេកោ យះ ក្ឞណទាយាំ យីឝោះ សន្និធិម៑ អគាត៑ ស ឧក្ត្តវាន្ ");
INSERT INTO sankhm_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","តស្យ វាក្យេ ន ឝ្រុតេ កម៌្មណិ ច ន វិទិតេ ៜស្មាកំ វ្យវស្ថា កិំ កញ្ចន មនុជំ ទោឞីករោតិ? ");
INSERT INTO sankhm_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","តតស្តេ វ្យាហរន៑ ត្វមបិ កិំ គាលីលីយលោកះ? វិវិច្យ បឝ្យ គលីលិ កោបិ ភវិឞ្យទ្វាទី នោត្បទ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","តតះ បរំ សវ៌្វេ ស្វំ ស្វំ គ្ឫហំ គតាះ កិន្តុ យីឝុ រ្ជៃតុននាមានំ ឝិលោច្ចយំ គតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ប្រត្យូឞេ យីឝុះ បនម៌ន្ទិរម៑ អាគច្ឆត្ ");
INSERT INTO sankhm_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","តតះ សវ៌្វេឞុ លោកេឞុ តស្យ សមីប អាគតេឞុ ស ឧបវិឝ្យ តាន៑ ឧបទេឞ្ដុម៑ អារភត។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","តទា អធ្យាបកាះ ផិរូឝិនញ្ច វ្យភិចារកម៌្មណិ ធ្ឫតំ ស្ត្រិយមេកាម៑ អានិយ សវ៌្វេឞាំ មធ្យេ ស្ថាបយិត្វា វ្យាហរន្ ");
INSERT INTO sankhm_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ហេ គុរោ យោឞិតម៑ ឥមាំ វ្យភិចារកម៌្ម កុវ៌្វាណាំ លោកា ធ្ឫតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ឯតាទ្ឫឝលោកាះ បាឞាណាឃាតេន ហន្តវ្យា ឥតិ វិធិម៌ូសាវ្យវស្ថាគ្រន្ថេ លិខិតោស្តិ កិន្តុ ភវាន៑ កិមាទិឝតិ? ");
INSERT INTO sankhm_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","តេ តមបវទិតុំ បរីក្ឞាភិប្រាយេណ វាក្យមិទម៑ អប្ឫច្ឆន៑ កិន្តុ ស ប្រហ្វីភូយ ភូមាវង្គល្យា លេខិតុម៑ អារភត។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","តតស្តៃះ បុនះ បុនះ ប្ឫឞ្ដ ឧត្ថាយ កថិតវាន៑ យុឞ្មាកំ មធ្យេ យោ ជនោ និរបរាធី សឯវ ប្រថមម៑ ឯនាំ បាឞាណេនាហន្តុ។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","បឝ្ចាត៑ ស បុនឝ្ច ប្រហ្វីភូយ ភូមៅ លេខិតុម៑ អារភត។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","តាំ កថំ ឝ្រុត្វា តេ ស្វស្វមនសិ ប្រពោធំ ប្រាប្យ ជ្យេឞ្ឋានុក្រមំ ឯកៃកឝះ សវ៌្វេ ពហិរគច្ឆន៑ តតោ យីឝុរេកាកី តយក្ត្តោភវត៑ មធ្យស្ថានេ ទណ្ឌាយមានា សា យោឞា ច ស្ថិតា។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","តត្បឝ្ចាទ៑ យីឝុរុត្ថាយ តាំ វនិតាំ វិនា កមប្យបរំ ន វិលោក្យ ប្ឫឞ្ដវាន៑ ហេ វាមេ តវាបវាទកាះ កុត្រ? កោបិ ត្វាំ កិំ ន ទណ្ឌយតិ? ");
INSERT INTO sankhm_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","សាវទត៑ ហេ មហេច្ឆ កោបិ ន តទា យីឝុរវោចត៑ នាហមបិ ទណ្ឌយាមិ យាហិ បុនះ បាបំ មាកាឞ៌ីះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","តតោ យីឝុះ បុនរបិ លោកេភ្យ ឥត្ថំ កថយិតុម៑ អារភត ជគតោហំ ជ្យោតិះស្វរូបោ យះ កឝ្ចិន៑ មត្បឝ្ចាទ គច្ឆតិ ស តិមិរេ ន ភ្រមិត្វា ជីវនរូបាំ ទីប្តិំ ប្រាប្ស្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","តតះ ផិរូឝិនោៜវាទិឞុស្ត្វំ ស្វាត៌្ហេ ស្វយំ សាក្ឞ្យំ ទទាសិ តស្មាត៑ តវ សាក្ឞ្យំ គ្រាហ្យំ ន ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","តទា យីឝុះ ប្រត្យុទិតវាន៑ យទ្យបិ ស្វាត៌្ហេៜហំ ស្វយំ សាក្ឞ្យំ ទទាមិ តថាបិ មត៑ សាក្ឞ្យំ គ្រាហ្យំ យស្មាទ៑ អហំ កុត អាគតោស្មិ ក្វ យាមិ ច តទហំ ជានាមិ កិន្តុ កុត អាគតោស្មិ កុត្រ គច្ឆាមិ ច តទ៑ យូយំ ន ជានីថ។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","យូយំ លៅកិកំ វិចារយថ នាហំ កិមបិ វិចារយាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","កិន្តុ យទិ វិចារយាមិ តហ៌ិ មម វិចារោ គ្រហីតវ្យោ យតោហម៑ ឯកាកី នាស្មិ ប្រេរយិតា បិតា មយា សហ វិទ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","ទ្វយោ រ្ជនយោះ សាក្ឞ្យំ គ្រហណីយំ ភវតីតិ យុឞ្មាកំ វ្យវស្ថាគ្រន្ថេ លិខិតមស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","អហំ ស្វាត៌្ហេ ស្វយំ សាក្ឞិត្វំ ទទាមិ យឝ្ច មម តាតោ មាំ ប្រេរិតវាន៑ សោបិ មទត៌្ហេ សាក្ឞ្យំ ទទាតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","តទា តេៜប្ឫច្ឆន៑ តវ តាតះ កុត្រ? តតោ យីឝុះ ប្រត្យវាទីទ៑ យូយំ មាំ ន ជានីថ មត្បិតរញ្ច ន ជានីថ យទិ មាម៑ អក្ឞាស្យត តហ៌ិ មម តាតមប្យក្ឞាស្យត។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","យីឝុ រ្មន្ទិរ ឧបទិឝ្យ ភណ្ឌាគារេ កថា ឯតា អកថយត៑ តថាបិ តំ ប្រតិ កោបិ ករំ នោទតោលយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","តតះ បរំ យីឝុះ បុនរុទិតវាន៑ អធុនាហំ គច្ឆាមិ យូយំ មាំ គវេឞយិឞ្យថ កិន្តុ និជៃះ បាបៃ រ្មរិឞ្យថ យត៑ ស្ថានម៑ អហំ យាស្យាមិ តត៑ ស្ថានម៑ យូយំ យាតុំ ន ឝក្ឞ្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","តទា យិហូទីយាះ ប្រាវោចន៑ កិមយម៑ អាត្មឃាតំ ករិឞ្យតិ? យតោ យត៑ ស្ថានម៑ អហំ យាស្យាមិ តត៑ ស្ថានម៑ យូយំ យាតុំ ន ឝក្ឞ្យថ ឥតិ វាក្យំ ព្រវីតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","តតោ យីឝុស្តេភ្យះ កថិតវាន៑ យូយម៑ អធះស្ថានីយា លោកា អហម៑ ឩទ៌្វ្វស្ថានីយះ យូយម៑ ឯតជ្ជគត្សម្ពន្ធីយា អហម៑ ឯតជ្ជគត្សម្ពន្ធីយោ ន។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","តស្មាត៑ កថិតវាន៑ យូយំ និជៃះ បាបៃ រ្មរិឞ្យថ យតោហំ ស បុមាន៑ ឥតិ យទិ ន វិឝ្វសិថ តហ៌ិ និជៃះ បាបៃ រ្មរិឞ្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","តទា តេ ៜប្ឫច្ឆន៑ កស្ត្វំ? តតោ យីឝុះ កថិតវាន៑ យុឞ្មាកំ សន្និធៅ យស្យ ប្រស្តាវម៑ អា ប្រថមាត៑ ករោមិ សឯវ បុរុឞោហំ។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","យុឞ្មាសុ មយា ពហុវាក្យំ វក្ត្តវ្យំ វិចារយិតវ្យញ្ច កិន្តុ មត្ប្រេរយិតា សត្យវាទី តស្យ សមីបេ យទហំ ឝ្រុតវាន៑ តទេវ ជគតេ កថយាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","កិន្តុ ស ជនកេ វាក្យមិទំ ប្រោក្ត្តវាន៑ ឥតិ តេ នាពុធ្យន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","តតោ យីឝុរកថយទ៑ យទា មនុឞ្យបុត្រម៑ ឩទ៌្វ្វ ឧត្ថាបយិឞ្យថ តទាហំ ស បុមាន៑ កេវលះ ស្វយំ កិមបិ កម៌្ម ន ករោមិ កិន្តុ តាតោ យថា ឝិក្ឞយតិ តទនុសារេណ វាក្យមិទំ វទាមីតិ ច យូយំ ជ្ញាតុំ ឝក្ឞ្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","មត្ប្រេរយិតា បិតា មាម៑ ឯកាកិនំ ន ត្យជតិ ស មយា សាទ៌្ធំ តិឞ្ឋតិ យតោហំ តទភិមតំ កម៌្ម សទា ករោមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","តទា តស្យៃតានិ វាក្យានិ ឝ្រុត្វា ពហុវស្តាស្មិន៑ វ្យឝ្វសន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","យេ យិហូទីយា វ្យឝ្វសន៑ យីឝុស្តេភ្យោៜកថយត្ ");
INSERT INTO sankhm_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","មម វាក្យេ យទិ យូយម៑ អាស្ថាំ កុរុថ តហ៌ិ មម ឝិឞ្យា ភូត្វា សត្យត្វំ ជ្ញាស្យថ តតះ សត្យតយា យុឞ្មាកំ មោក្ឞោ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","តទា តេ ប្រត្យវាទិឞុះ វយម៑ ឥព្រាហីមោ វំឝះ កទាបិ កស្យាបិ ទាសា ន ជាតាស្តហ៌ិ យុឞ្មាកំ មុក្ត្តិ រ្ភវិឞ្យតីតិ វាក្យំ កថំ ព្រវីឞិ? ");
INSERT INTO sankhm_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","តទា យីឝុះ ប្រត្យវទទ៑ យុឞ្មានហំ យថាត៌្ហតរំ វទាមិ យះ បាបំ ករោតិ ស បាបស្យ ទាសះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","ទាសឝ្ច និរន្តរំ និវេឝនេ ន តិឞ្ឋតិ កិន្តុ បុត្រោ និរន្តរំ តិឞ្ឋតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","អតះ បុត្រោ យទិ យុឞ្មាន៑ មោចយតិ តហ៌ិ និតាន្តមេវ មុក្ត្តា ភវិឞ្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","យុយម៑ ឥព្រាហីមោ វំឝ ឥត្យហំ ជានាមិ កិន្តុ មម កថា យុឞ្មាកម៑ អន្តះករណេឞុ ស្ថានំ ន ប្រាប្នុវន្តិ តស្មាទ្ធេតោ រ្មាំ ហន្តុម៑ ឦហធ្វេ។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","អហំ ស្វបិតុះ សមីបេ យទបឝ្យំ តទេវ កថយាមិ តថា យូយមបិ ស្វបិតុះ សមីបេ យទបឝ្យត តទេវ កុរុធ្វេ។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","តទា តេ ប្រត្យវោចន៑ ឥព្រាហីម៑ អស្មាកំ បិតា តតោ យីឝុរកថយទ៑ យទិ យូយម៑ ឥព្រាហីមះ សន្តានា អភវិឞ្យត តហ៌ិ ឥព្រាហីម អាចារណវទ៑ អាចរិឞ្យត។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ឦឝ្វរស្យ មុខាត៑ សត្យំ វាក្យំ ឝ្រុត្វា យុឞ្មាន៑ ជ្ញាបយាមិ យោហំ តំ មាំ ហន្តុំ ចេឞ្ដធ្វេ ឥព្រាហីម៑ ឯតាទ្ឫឝំ កម៌្ម ន ចការ។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","យូយំ ស្វស្វបិតុះ កម៌្មាណិ កុរុថ តទា តៃរុក្ត្តំ ន វយំ ជារជាតា អស្មាកម៑ ឯកឯវ បិតាស្តិ ស ឯវេឝ្វរះ ");
INSERT INTO sankhm_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","តតោ យីឝុនា កថិតម៑ ឦឝ្វរោ យទិ យុឞ្មាកំ តាតោភវិឞ្យត៑ តហ៌ិ យូយំ មយិ ប្រេមាករិឞ្យត យតោហម៑ ឦឝ្វរាន្និគ៌ត្យាគតោស្មិ ស្វតោ នាគតោហំ ស មាំ ប្រាហិណោត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","យូយំ មម វាក្យមិទំ ន ពុធ្យធ្វេ កុតះ? យតោ យូយំ មមោបទេឝំ សោឍុំ ន ឝក្នុថ។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","យូយំ ឝៃតាន៑ បិតុះ សន្តានា ឯតស្មាទ៑ យុឞ្មាកំ បិតុរភិលាឞំ បូរយថ ស អា ប្រថមាត៑ នរឃាតី តទន្តះ សត្យត្វស្យ លេឝោបិ នាស្តិ ការណាទតះ ស សត្យតាយាំ នាតិឞ្ឋត៑ ស យទា ម្ឫឞា កថយតិ តទា និជស្វភាវានុសារេណៃវ កថយតិ យតោ ស ម្ឫឞាភាឞី ម្ឫឞោត្បាទកឝ្ច។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","អហំ តថ្យវាក្យំ វទាមិ ការណាទស្មាទ៑ យូយំ មាំ ន ប្រតីថ។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","មយិ បាបមស្តីតិ ប្រមាណំ យុឞ្មាកំ កោ ទាតុំ ឝក្នោតិ? យទ្យហំ តថ្យវាក្យំ វទាមិ តហ៌ិ កុតោ មាំ ន ប្រតិថ? ");
INSERT INTO sankhm_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","យះ កឝ្ចន ឦឝ្វរីយោ លោកះ ស ឦឝ្វរីយកថាយាំ មនោ និធត្តេ យូយម៑ ឦឝ្វរីយលោកា ន ភវថ តន្និទានាត៑ តត្រ ន មនាំសិ និធទ្វេ។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","តទា យិហូទីយាះ ប្រត្យវាទិឞុះ ត្វមេកះ ឝោមិរោណីយោ ភូតគ្រស្តឝ្ច វយំ កិមិទំ ភទ្រំ នាវាទិឞ្ម? ");
INSERT INTO sankhm_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","តតោ យីឝុះ ប្រត្យវាទីត៑ នាហំ ភូតគ្រស្តះ កិន្តុ និជតាតំ សម្មន្យេ តស្មាទ៑ យូយំ មាម៑ អបមន្យធ្វេ។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","អហំ ស្វសុខ្យាតិំ ន ចេឞ្ដេ កិន្តុ ចេឞ្ដិតា វិចារយិតា ចាបរ ឯក អាស្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","អហំ យុឞ្មភ្យម៑ អតីវ យថាត៌្ហំ កថយាមិ យោ នរោ មទីយំ វាចំ មន្យតេ ស កទាចន និធនំ ន ទ្រក្ឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","យិហូទីយាស្តមវទន៑ ត្វំ ភូតគ្រស្ត ឥតីទានីម៑ អវៃឞ្ម។ ឥព្រាហីម៑ ភវិឞ្យទ្វាទិនញ្ច សវ៌្វេ ម្ឫតាះ កិន្តុ ត្វំ ភាឞសេ យោ នរោ មម ភារតីំ គ្ឫហ្លាតិ ស ជាតុ និធានាស្វាទំ ន លប្ស្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","តហ៌ិ ត្វំ កិម៑ អស្មាកំ បូវ៌្វបុរុឞាទ៑ ឥព្រាហីមោបិ មហាន៑? យស្មាត៑ សោបិ ម្ឫតះ ភវិឞ្យទ្វាទិនោបិ ម្ឫតាះ ត្វំ ស្វំ កំ បុមាំសំ មនុឞេ? ");
INSERT INTO sankhm_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","យីឝុះ ប្រត្យវោចទ៑ យទ្យហំ ស្វំ ស្វយំ សម្មន្យេ តហ៌ិ មម តត៑ សម្មននំ កិមបិ ន កិន្តុ មម តាតោ យំ យូយំ ស្វីយម៑ ឦឝ្វរំ ភាឞធ្វេ សឯវ មាំ សម្មនុតេ។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","យូយំ តំ នាវគច្ឆថ កិន្ត្វហំ តមវគច្ឆាមិ តំ នាវគច្ឆាមីតិ វាក្យំ យទិ វទាមិ តហ៌ិ យូយមិវ ម្ឫឞាភាឞី ភវាមិ កិន្ត្វហំ តមវគច្ឆាមិ តទាក្ឞាមបិ គ្ឫហ្លាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","យុឞ្មាកំ បូវ៌្វបុរុឞ ឥព្រាហីម៑ មម សមយំ ទ្រឞ្ដុម៑ អតីវាវាញ្ឆត៑ តន្និរីក្ឞ្យានន្ទច្ច។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","តទា យិហូទីយា អប្ឫច្ឆន៑ តវ វយះ បញ្ចាឝទ្វត្សរា ន ត្វំ កិម៑ ឥព្រាហីមម៑ អទ្រាក្ឞីះ? ");
INSERT INTO sankhm_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","យីឝុះ ប្រត្យវាទីទ៑ យុឞ្មានហំ យថាត៌្ហតរំ វទាមិ ឥព្រាហីមោ ជន្មនះ បូវ៌្វកាលមារភ្យាហំ វិទ្យេ។ ");
INSERT INTO sankhm_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","តទា តេ បាឞាណាន៑ ឧត្តោល្យ តមាហន្តុម៑ ឧទយច្ឆន៑ កិន្តុ យីឝុ រ្គុប្តោ មន្តិរាទ៑ ពហិគ៌ត្យ តេឞាំ មធ្យេន ប្រស្ថិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","តតះ បរំ យីឝុគ៌ច្ឆន៑ មាគ៌មធ្យេ ជន្មាន្ធំ នរម៑ អបឝ្យត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","តតះ ឝិឞ្យាស្តម៑ អប្ឫច្ឆន៑ ហេ គុរោ នរោយំ ស្វបាបេន វា ស្វបិត្រាះ បាបេនាន្ធោៜជាយត? ");
INSERT INTO sankhm_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","តតះ ស ប្រត្យុទិតវាន៑ ឯតស្យ វាស្យ បិត្រោះ បាបាទ៑ ឯតាទ្ឫឝោភូទ ឥតិ នហិ កិន្ត្វនេន យថេឝ្វរស្យ កម៌្ម ប្រកាឝ្យតេ តទ្ធេតោរេវ។ ");
INSERT INTO sankhm_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","ទិនេ តិឞ្ឋតិ មត្ប្រេរយិតុះ កម៌្ម មយា កត៌្តវ្យំ យទា កិមបិ កម៌្ម ន ក្រិយតេ តាទ្ឫឝី និឝាគច្ឆតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","អហំ យាវត្កាលំ ជគតិ តិឞ្ឋាមិ តាវត្កាលំ ជគតោ ជ្យោតិះស្វរូបោស្មិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ឥត្យុក្ត្តា ភូមៅ និឞ្ឋីវំ និក្ឞិប្យ តេន បង្កំ ក្ឫតវាន្ ");
INSERT INTO sankhm_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","បឝ្ចាត៑ តត្បង្កេន តស្យាន្ធស្យ នេត្រេ ប្រលិប្យ តមិត្យាទិឝត៑ គត្វា ឝិលោហេ ៜរ្ថាត៑ ប្រេរិតនាម្និ សរសិ ស្នាហិ។ តតោន្ធោ គត្វា តត្រាស្នាត៑ តតះ ប្រន្នចក្ឞុ រ្ភូត្វា វ្យាឃុដ្យាគាត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","អបរញ្ច សមីបវាសិនោ លោកា យេ ច តំ បូវ៌្វមន្ធម៑ អបឝ្យន៑ តេ ពក្ត្តុម៑ អារភន្ត យោន្ធលោកោ វត៌្មន្យុបវិឝ្យាភិក្ឞត ស ឯវាយំ ជនះ កិំ ន ភវតិ? ");
INSERT INTO sankhm_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","កេចិទវទន៑ ស ឯវ កេចិទវោចន៑ តាទ្ឫឝោ ភវតិ កិន្តុ ស ស្វយមព្រវីត៑ ស ឯវាហំ ភវាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","អតឯវ តេ ៜប្ឫច្ឆន៑ ត្វំ កថំ ទ្ឫឞ្ដិំ បាប្តវាន៑? ");
INSERT INTO sankhm_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","តតះ សោវទទ៑ យីឝនាមក ឯកោ ជនោ មម នយនេ បង្កេន ប្រលិប្យ ឥត្យាជ្ញាបយត៑ ឝិលោហកាសារំ គត្វា តត្រ ស្នាហិ។ តតស្តត្រ គត្វា មយិ ស្នាតេ ទ្ឫឞ្ដិមហំ លព្ធវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","តទា តេ ៜវទន៑ ស បុមាន៑ កុត្រ? តេនោក្ត្តំ នាហំ ជានាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","អបរំ តស្មិន៑ បូវ៌្វាន្ធេ ជនេ ផិរូឝិនាំ និកដម៑ អានីតេ សតិ ផិរូឝិនោបិ តមប្ឫច្ឆន៑ កថំ ទ្ឫឞ្ដិំ ប្រាប្តោសិ? ");
INSERT INTO sankhm_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","តតះ ស កថិតវាន៑ ស បង្កេន មម នេត្រេ ៜលិម្បត៑ បឝ្ចាទ៑ ស្នាត្វា ទ្ឫឞ្ដិមលភេ។ ");
INSERT INTO sankhm_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","កិន្តុ យីឝុ រ្វិឝ្រាមវារេ កទ៌្ទមំ ក្ឫត្វា តស្យ នយនេ ប្រសន្នេៜករោទ៑ ឥតិការណាត៑ កតិបយផិរូឝិនោៜវទន្ ");
INSERT INTO sankhm_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ស បុមាន៑ ឦឝ្វរាន្ន យតះ ស វិឝ្រាមវារំ ន មន្យតេ។ តតោន្យេ កេចិត៑ ប្រត្យវទន៑ បាបី បុមាន៑ កិម៑ ឯតាទ្ឫឝម៑ អាឝ្ចយ៌្យំ កម៌្ម កត៌្តុំ ឝក្នោតិ? ");
INSERT INTO sankhm_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ឥត្ថំ តេឞាំ បរស្បរំ ភិន្នវាក្យត្វម៑ អភវត៑។ បឝ្ចាត៑ តេ បុនរបិ តំ បូវ៌្វាន្ធំ មានុឞម៑ អប្រាក្ឞុះ យោ ជនស្តវ ចក្ឞុឞី ប្រសន្នេ ក្ឫតវាន៑ តស្មិន៑ ត្វំ កិំ វទសិ? ស ឧក្ត្តវាន៑ ស ភវិឝទ្វាទី។ ");
INSERT INTO sankhm_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","ស ទ្ឫឞ្ដិម៑ អាប្តវាន៑ ឥតិ យិហូទីយាស្តស្យ ទ្ឫឞ្ដិំ ប្រាប្តស្យ ជនស្យ បិត្រោ រ្មុខាទ៑ អឝ្រុត្វា ន ប្រត្យយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","អតឯវ តេ តាវប្ឫច្ឆន៑ យុវយោ រ្យំ បុត្រំ ជន្មាន្ធំ វទថះ ស កិមយំ? តហ៌ីទានីំ កថំ ទ្រឞ្ដុំ ឝក្នោតិ? ");
INSERT INTO sankhm_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","តតស្តស្យ បិតរៅ ប្រត្យវោចតាម៑ អយម៑ អាវយោះ បុត្រ អា ជនេរន្ធឝ្ច តទប្យាវាំ ជានីវះ ");
INSERT INTO sankhm_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","កិន្ត្វធុនា កថំ ទ្ឫឞ្ដិំ ប្រាប្តវាន៑ តទាវាំ ន៑ ជានីវះ កោស្យ ចក្ឞុឞី ប្រសន្នេ ក្ឫតវាន៑ តទបិ ន ជានីវ ឯឞ វយះប្រាប្ត ឯនំ ប្ឫច្ឆត ស្វកថាំ ស្វយំ វក្ឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","យិហូទីយានាំ ភយាត៑ តស្យ បិតរៅ វាក្យមិទម៑ អវទតាំ យតះ កោបិ មនុឞ្យោ យទិ យីឝុម៑ អភិឞិក្តំ វទតិ តហ៌ិ ស ភជនគ្ឫហាទ៑ ទូរីការិឞ្យតេ យិហូទីយា ឥតិ មន្ត្រណាម៑ អកុវ៌្វន្ ");
INSERT INTO sankhm_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","អតស្តស្យ បិតរៅ វ្យាហរតាម៑ ឯឞ វយះប្រាប្ត ឯនំ ប្ឫច្ឆត។ ");
INSERT INTO sankhm_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","តទា តេ បុនឝ្ច តំ បូវ៌្វាន្ធម៑ អាហូយ វ្យាហរន៑ ឦឝ្វរស្យ គុណាន៑ វទ ឯឞ មនុឞ្យះ បាបីតិ វយំ ជានីមះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","តទា ស ឧក្ត្តវាន៑ ស បាបី ន វេតិ នាហំ ជានេ បូវ៌ាមន្ធ អាសមហម៑ អធុនា បឝ្យាមីតិ មាត្រំ ជានាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","តេ បុនរប្ឫច្ឆន៑ ស ត្វាំ ប្រតិ កិមករោត៑? កថំ នេត្រេ ប្រសន្នេ ៜករោត៑? ");
INSERT INTO sankhm_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","តតះ សោវាទីទ៑ ឯកក្ឫត្វោកថយំ យូយំ ន ឝ្ឫណុថ តហ៌ិ កុតះ បុនះ ឝ្រោតុម៑ ឥច្ឆថ? យូយមបិ កិំ តស្យ ឝិឞ្យា ភវិតុម៑ ឥច្ឆថ? ");
INSERT INTO sankhm_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","តទា តេ តំ តិរស្ក្ឫត្យ វ្យាហរន៑ ត្វំ តស្យ ឝិឞ្យោ វយំ មូសាះ ឝិឞ្យាះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","មូសាវក្ត្រេណេឝ្វរោ ជគាទ តជ្ជានីមះ កិន្ត្វេឞ កុត្រត្យលោក ឥតិ ន ជានីមះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","សោវទទ៑ ឯឞ មម លោចនេ ប្រសន្នេ ៜករោត៑ តថាបិ កុត្រត្យលោក ឥតិ យូយំ ន ជានីថ ឯតទ៑ អាឝ្ចយ៌្យំ ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ឦឝ្វរះ បាបិនាំ កថាំ ន ឝ្ឫណោតិ កិន្តុ យោ ជនស្តស្មិន៑ ភក្តិំ ក្ឫត្វា តទិឞ្ដក្រិយាំ ករោតិ តស្យៃវ កថាំ ឝ្ឫណោតិ ឯតទ៑ វយំ ជានីមះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","កោបិ មនុឞ្យោ ជន្មាន្ធាយ ចក្ឞុឞី អទទាត៑ ជគទារម្ភាទ៑ ឯតាទ្ឫឝីំ កថាំ កោបិ កទាបិ នាឝ្ឫណោត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","អស្មាទ៑ ឯឞ មនុឞ្យោ យទីឝ្វរាន្នាជាយត តហ៌ិ កិញ្ចិទបីទ្ឫឝំ កម៌្ម កត៌្តុំ នាឝក្នោត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","តេ វ្យាហរន៑ ត្វំ បាបាទ៑ អជាយថាះ កិមស្មាន៑ ត្វំ ឝិក្ឞយសិ? បឝ្ចាត្តេ តំ ពហិរកុវ៌្វន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","តទនន្តរំ យិហូទីយៃះ ស ពហិរក្រិយត យីឝុរិតិ វាត៌្តាំ ឝ្រុត្វា តំ សាក្ឞាត៑ ប្រាប្យ ប្ឫឞ្ដវាន៑ ឦឝ្វរស្យ បុត្រេ ត្វំ វិឝ្វសិឞិ? ");
INSERT INTO sankhm_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","តទា ស ប្រត្យវោចត៑ ហេ ប្រភោ ស កោ យត៑ តស្មិន្នហំ វិឝ្វសិមិ? ");
INSERT INTO sankhm_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","តតោ យីឝុះ កថិតវាន៑ ត្វំ តំ ទ្ឫឞ្ដវាន៑ ត្វយា សាកំ យះ កថំ កថយតិ សឯវ សះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","តទា ហេ ប្រភោ វិឝ្វសិមីត្យុក្ត្វា ស តំ ប្រណាមត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","បឝ្ចាទ៑ យីឝុះ កថិតវាន៑ នយនហីនា នយនានិ ប្រាប្នុវន្តិ នយនវន្តឝ្ចាន្ធា ភវន្តីត្យភិប្រាយេណ ជគទាហម៑ អាគច្ឆម៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ឯតត៑ ឝ្រុត្វា និកដស្ថាះ កតិបយាះ ផិរូឝិនោ វ្យាហរន៑ វយមបិ កិមន្ធាះ? ");
INSERT INTO sankhm_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","តទា យីឝុរវាទីទ៑ យទ្យន្ធា អភវត តហ៌ិ បាបានិ នាតិឞ្ឋន៑ កិន្តុ បឝ្យាមីតិ វាក្យវទនាទ៑ យុឞ្មាកំ បាបានិ តិឞ្ឋន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","អហំ យុឞ្មានតិយថាត៌្ហំ វទាមិ, យោ ជនោ ទ្វារេណ ន ប្រវិឝ្យ កេនាប្យន្យេន មេឞគ្ឫហំ ប្រវិឝតិ ស ឯវ ស្តេនោ ទស្យុឝ្ច។ ");
INSERT INTO sankhm_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","យោ ទ្វារេណ ប្រវិឝតិ ស ឯវ មេឞបាលកះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ទៅវារិកស្តស្មៃ ទ្វារំ មោចយតិ មេឞគណឝ្ច តស្យ វាក្យំ ឝ្ឫណោតិ ស និជាន៑ មេឞាន៑ ស្វស្វនាម្នាហូយ ពហិះ ក្ឫត្វា នយតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","តថា និជាន៑ មេឞាន៑ ពហិះ ក្ឫត្វា ស្វយំ តេឞាម៑ អគ្រេ គច្ឆតិ, តតោ មេឞាស្តស្យ ឝព្ទំ ពុធ្យន្តេ, តស្មាត៑ តស្យ បឝ្ចាទ៑ វ្រជន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","កិន្តុ បរស្យ ឝព្ទំ ន ពុធ្យន្តេ តស្មាត៑ តស្យ បឝ្ចាទ៑ វ្រជិឞ្យន្តិ វរំ តស្យ សមីបាត៑ បលាយិឞ្យន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","យីឝុស្តេភ្យ ឥមាំ ទ្ឫឞ្ដាន្តកថាម៑ អកថយត៑ កិន្តុ តេន កថិតកថាយាស្តាត្បយ៌្យំ តេ នាពុធ្យន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","អតោ យីឝុះ បុនរកថយត៑, យុឞ្មានាហំ យថាត៌្ហតរំ វ្យាហរាមិ, មេឞគ្ឫហស្យ ទ្វារម៑ អហមេវ។ ");
INSERT INTO sankhm_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","មយា ន ប្រវិឝ្យ យ អាគច្ឆន៑ តេ ស្តេនា ទស្យវឝ្ច កិន្តុ មេឞាស្តេឞាំ កថា នាឝ្ឫណ្វន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","អហមេវ ទ្វារស្វរូបះ, មយា យះ កឝ្ចិត ប្រវិឝតិ ស រក្ឞាំ ប្រាប្ស្យតិ តថា ពហិរន្តឝ្ច គមនាគមនេ ក្ឫត្វា ចរណស្ថានំ ប្រាប្ស្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","យោ ជនស្តេនះ ស កេវលំ ស្តៃន្យពធវិនាឝាន៑ កត៌្តុមេវ សមាយាតិ កិន្ត្វហម៑ អាយុ រ្ទាតុម៑ អត៌្ហាត៑ ពាហូល្យេន តទេវ ទាតុម៑ អាគច្ឆម៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","អហមេវ សត្យមេឞបាលកោ យស្តុ សត្យោ មេឞបាលកះ ស មេឞាត៌្ហំ ប្រាណត្យាគំ ករោតិ; ");
INSERT INTO sankhm_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","កិន្តុ យោ ជនោ មេឞបាលកោ ន, អត៌្ហាទ៑ យស្យ មេឞា និជា ន ភវន្តិ, យ ឯតាទ្ឫឝោ វៃតនិកះ ស វ្ឫកម៑ អាគច្ឆន្តំ ទ្ឫឞ្ដ្វា មេជវ្រជំ វិហាយ បលាយតេ, តស្មាទ៑ វ្ឫកស្តំ វ្រជំ ធ្ឫត្វា វិកិរតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","វៃតនិកះ បលាយតេ យតះ ស វេតនាត៌្ហី មេឞាត៌្ហំ ន ចិន្តយតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","អហមេវ សត្យោ មេឞបាលកះ, បិតា មាំ យថា ជានាតិ, អហញ្ច យថា បិតរំ ជានាមិ, ");
INSERT INTO sankhm_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","តថា និជាន៑ មេឞានបិ ជានាមិ, មេឞាឝ្ច មាំ ជានាន្តិ, អហញ្ច មេឞាត៌្ហំ ប្រាណត្យាគំ ករោមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","អបរញ្ច ឯតទ៑ គ្ឫហីយ មេឞេភ្យោ ភិន្នា អបិ មេឞា មម សន្តិ តេ សកលា អានយិតវ្យាះ; តេ មម ឝព្ទំ ឝ្រោឞ្យន្តិ តត ឯកោ វ្រជ ឯកោ រក្ឞកោ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","ប្រាណានហំ ត្យក្ត្វា បុនះ ប្រាណាន៑ គ្រហីឞ្យាមិ, តស្មាត៑ បិតា មយិ ស្នេហំ ករោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","កឝ្ចិជ្ជនោ មម ប្រាណាន៑ ហន្តុំ ន ឝក្នោតិ កិន្តុ ស្វយំ តាន៑ សមប៌យាមិ តាន៑ សមប៌យិតុំ បុនគ៌្រហីតុញ្ច មម ឝក្តិរាស្តេ ភារមិមំ ស្វបិតុះ សកាឝាត៑ ប្រាប្តោហម៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","អស្មាទុបទេឝាត៑ បុនឝ្ច យិហូទីយានាំ មធ្យេ ភិន្នវាក្យតា ជាតា។ ");
INSERT INTO sankhm_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","តតោ ពហវោ វ្យាហរន៑ ឯឞ ភូតគ្រស្ត ឧន្មត្តឝ្ច, កុត ឯតស្យ កថាំ ឝ្ឫណុថ? ");
INSERT INTO sankhm_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","កេចិទ៑ អវទន៑ ឯតស្យ កថា ភូតគ្រស្តស្យ កថាវន្ន ភវន្តិ, ភូតះ កិម៑ អន្ធាយ ចក្ឞុឞី ទាតុំ ឝក្នោតិ? ");
INSERT INTO sankhm_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","ឝីតកាលេ យិរូឝាលមិ មន្ទិរោត្សគ៌បវ៌្វណ្យុបស្ថិតេ ");
INSERT INTO sankhm_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","យីឝុះ សុលេមានោ និះសារេណ គមនាគមនេ ករោតិ, ");
INSERT INTO sankhm_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ឯតស្មិន៑ សមយេ យិហូទីយាស្តំ វេឞ្ដយិត្វា វ្យាហរន៑ កតិ កាលាន៑ អស្មាកំ វិចិកិត្សាំ ស្ថាបយិឞ្យាមិ? យទ្យភិឞិក្តោ ភវតិ តហ៌ិ តត៑ ស្បឞ្ដំ វទ។ ");
INSERT INTO sankhm_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","តទា យីឝុះ ប្រត្យវទទ៑ អហម៑ អចកថំ កិន្តុ យូយំ ន ប្រតីថ, និជបិតុ រ្នាម្នា យាំ យាំ ក្រិយាំ ករោមិ សា ក្រិយៃវ មម សាក្ឞិស្វរូបា។ ");
INSERT INTO sankhm_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","កិន្ត្វហំ បូវ៌្វមកថយំ យូយំ មម មេឞា ន ភវថ, ការណាទស្មាន៑ ន វិឝ្វសិថ។ ");
INSERT INTO sankhm_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","មម មេឞា មម ឝព្ទំ ឝ្ឫណ្វន្តិ តានហំ ជានាមិ តេ ច មម បឝ្ចាទ៑ គច្ឆន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","អហំ តេភ្យោៜនន្តាយុ រ្ទទាមិ, តេ កទាបិ ន នំក្ឞ្យន្តិ កោបិ មម ករាត៑ តាន៑ ហត៌្តុំ ន ឝក្ឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","យោ មម បិតា តាន៑ មហ្យំ ទត្តវាន៑ ស សវ៌្វស្មាត៑ មហាន៑, កោបិ មម បិតុះ ករាត៑ តាន៑ ហត៌្តុំ ន ឝក្ឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","អហំ បិតា ច ទ្វយោរេកត្វម៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","តតោ យិហូទីយាះ បុនរបិ តំ ហន្តុំ បាឞាណាន៑ ឧទតោលយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","យីឝុះ កថិតវាន៑ បិតុះ សកាឝាទ៑ ពហូន្យុត្តមកម៌្មាណិ យុឞ្មាកំ ប្រាកាឝយំ តេឞាំ កស្យ កម៌្មណះ ការណាន៑ មាំ បាឞាណៃរាហន្តុម៑ ឧទ្យតាះ ស្ថ? ");
INSERT INTO sankhm_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","យិហូទីយាះ ប្រត្យវទន៑ ប្រឝស្តកម៌្មហេតោ រ្ន កិន្តុ ត្វំ មានុឞះ ស្វមីឝ្វរម៑ ឧក្ត្វេឝ្វរំ និន្ទសិ ការណាទស្មាត៑ ត្វាំ បាឞាណៃហ៌ន្មះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","តទា យីឝុះ ប្រត្យុក្តវាន៑ មយា កថិតំ យូយម៑ ឦឝ្វរា ឯតទ្វចនំ យុឞ្មាកំ ឝាស្ត្រេ លិខិតំ នាស្តិ កិំ? ");
INSERT INTO sankhm_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","តស្មាទ៑ យេឞាម៑ ឧទ្ទេឝេ ឦឝ្វរស្យ កថា កថិតា តេ យទីឝ្វរគណា ឧច្យន្តេ ធម៌្មគ្រន្ថស្យាប្យន្យថា ភវិតុំ ន ឝក្យំ, ");
INSERT INTO sankhm_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","តហ៌្យាហម៑ ឦឝ្វរស្យ បុត្រ ឥតិ វាក្យស្យ កថនាត៑ យូយំ បិត្រាភិឞិក្តំ ជគតិ ប្រេរិតញ្ច បុមាំសំ កថម៑ ឦឝ្វរនិន្ទកំ វាទយ? ");
INSERT INTO sankhm_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","យទ្យហំ បិតុះ កម៌្ម ន ករោមិ តហ៌ិ មាំ ន ប្រតីត; ");
INSERT INTO sankhm_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","កិន្តុ យទិ ករោមិ តហ៌ិ មយិ យុឞ្មាភិះ ប្រត្យយេ ន ក្ឫតេៜបិ កាយ៌្យេ ប្រត្យយះ ក្រិយតាំ, តតោ មយិ បិតាស្តីតិ បិតយ៌្យហម៑ អស្មីតិ ច ក្ឞាត្វា វិឝ្វសិឞ្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","តទា តេ បុនរបិ តំ ធត៌្តុម៑ អចេឞ្ដន្ត កិន្តុ ស តេឞាំ ករេភ្យោ និស្តីយ៌្យ ");
INSERT INTO sankhm_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","បុន រ្យទ៌្ទន៑ អទ្យាស្តដេ យត្រ បុវ៌្វំ យោហន៑ អមជ្ជយត៑ តត្រាគត្យ ន្យវសត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","តតោ ពហវោ លោកាស្តត្សមីបម៑ អាគត្យ វ្យាហរន៑ យោហន៑ កិមប្យាឝ្ចយ៌្យំ កម៌្ម នាករោត៑ កិន្ត្វស្មិន៑ មនុឞ្យេ យា យះ កថា អកថយត៑ តាះ សវ៌្វាះ សត្យាះ; ");
INSERT INTO sankhm_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","តត្រ ច ពហវោ លោកាស្តស្មិន៑ វ្យឝ្វសន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","អនន្តរំ មរិយម៑ តស្យា ភគិនី មត៌្ហា ច យស្មិន៑ វៃថនីយាគ្រាមេ វសតស្តស្មិន៑ គ្រាមេ ឥលិយាសរ៑ នាមា បីឌិត ឯក អាសីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","យា មរិយម៑ ប្រភុំ សុគន្ធិតេលៃន មទ៌្ទយិត្វា ស្វកេឝៃស្តស្យ ចរណៅ សមមាជ៌ត៑ តស្យា ភ្រាតា ស ឥលិយាសរ៑ រោគី។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","អបរញ្ច ហេ ប្រភោ ភវាន៑ យស្មិន៑ ប្រីយតេ ស ឯវ បីឌិតោស្តីតិ កថាំ កថយិត្វា តស្យ ភគិន្យៅ ប្រេឞិតវត្យៅ។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","តទា យីឝុរិមាំ វាត៌្តាំ ឝ្រុត្វាកថយត បីឌេយំ មរណាត៌្ហំ ន កិន្ត្វីឝ្វរស្យ មហិមាត៌្ហម៑ ឦឝ្វរបុត្រស្យ មហិមប្រកាឝាត៌្ហញ្ច ជាតា។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","យីឝុ រ្យទ្យបិមត៌្ហាយាំ តទ្ភគិន្យាម៑ ឥលិយាសរិ ចាប្រីយត, ");
INSERT INTO sankhm_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","តថាបិ ឥលិយាសរះ បីឌាយាះ កថំ ឝ្រុត្វា យត្រ អាសីត៑ តត្រៃវ ទិនទ្វយមតិឞ្ឋត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","តតះ បរម៑ ស ឝិឞ្យានកថយទ៑ វយំ បុន រ្យិហូទីយប្រទេឝំ យាមះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","តតស្តេ ប្រត្យវទន៑, ហេ គុរោ ស្វល្បទិនានិ គតានិ យិហូទីយាស្ត្វាំ បាឞាណៃ រ្ហន្តុម៑ ឧទ្យតាស្តថាបិ កិំ បុនស្តត្រ យាស្យសិ? ");
INSERT INTO sankhm_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","យីឝុះ ប្រត្យវទត៑, ឯកស្មិន៑ ទិនេ កិំ ទ្វាទឝឃដិកា ន ភវន្តិ? កោបិ ទិវា គច្ឆន៑ ន ស្ខលតិ យតះ ស ឯតជ្ជគតោ ទីប្តិំ ប្រាប្នោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","កិន្តុ រាត្រៅ គច្ឆន៑ ស្ខលតិ យតោ ហេតោស្តត្រ ទីប្តិ រ្នាស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ឥមាំ កថាំ កថយិត្វា ស តានវទទ៑, អស្មាកំ ពន្ធុះ ឥលិយាសរ៑ និទ្រិតោភូទ៑ ឥទានីំ តំ និទ្រាតោ ជាគរយិតុំ គច្ឆាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","យីឝុ រ្ម្ឫតៅ កថាមិមាំ កថិតវាន៑ កិន្តុ វិឝ្រាមាត៌្ហំ និទ្រាយាំ កថិតវាន៑ ឥតិ ជ្ញាត្វា ឝិឞ្យា អកថយន៑, ");
INSERT INTO sankhm_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ហេ គុរោ ស យទិ និទ្រាតិ តហ៌ិ ភទ្រមេវ។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","តទា យីឝុះ ស្បឞ្ដំ តាន៑ វ្យាហរត៑, ឥលិយាសរ៑ អម្រិយត; ");
INSERT INTO sankhm_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","កិន្តុ យូយំ យថា ប្រតីថ តទត៌្ហមហំ តត្រ ន ស្ថិតវាន៑ ឥត្យស្មាទ៑ យុឞ្មន្និមិត្តម៑ អាហ្លាទិតោហំ, តថាបិ តស្យ សមីបេ យាម។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","តទា ថោមា យំ ទិទុមំ វទន្តិ ស សង្គិនះ ឝិឞ្យាន៑ អវទទ៑ វយមបិ គត្វា តេន សាទ៌្ធំ ម្រិយាមហៃ។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","យីឝុស្តត្រោបស្ថាយ ឥលិយាសរះ ឝ្មឝានេ ស្ថាបនាត៑ ចត្វារិ ទិនានិ គតានីតិ វាត៌្តាំ ឝ្រុតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","វៃថនីយា យិរូឝាលមះ សមីបស្ថា ក្រោឝៃកមាត្រាន្តរិតា; ");
INSERT INTO sankhm_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","តស្មាទ៑ ពហវោ យិហូទីយា មត៌្ហាំ មរិយមញ្ច ភ្យាត្ឫឝោកាបន្នាំ សាន្ត្វយិតុំ តយោះ សមីបម៑ អាគច្ឆន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","មត៌្ហា យីឝោរាគមនវាត៌ាំ ឝ្រុត្វៃវ តំ សាក្ឞាទ៑ អករោត៑ កិន្តុ មរិយម៑ គេហ ឧបវិឝ្យ ស្ថិតា។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","តទា មត៌្ហា យីឝុមវាទត៑, ហេ ប្រភោ យទិ ភវាន៑ អត្រាស្ថាស្យត៑ តហ៌ិ មម ភ្រាតា នាមរិឞ្យត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","កិន្ត្វិទានីមបិ យទ៑ ឦឝ្វរេ ប្រាត៌្ហយិឞ្យតេ ឦឝ្វរស្តទ៑ ទាស្យតីតិ ជានេៜហំ។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","យីឝុរវាទីត៑ តវ ភ្រាតា សមុត្ថាស្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","មត៌្ហា វ្យាហរត៑ ឝេឞទិវសេ ស ឧត្ថានសមយេ ប្រោត្ថាស្យតីតិ ជានេៜហំ។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","តទា យីឝុះ កថិតវាន៑ អហមេវ ឧត្ថាបយិតា ជីវយិតា ច យះ កឝ្ចន មយិ វិឝ្វសិតិ ស ម្ឫត្វាបិ ជីវិឞ្យតិ; ");
INSERT INTO sankhm_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","យះ កឝ្ចន ច ជីវន៑ មយិ វិឝ្វសិតិ ស កទាបិ ន មរិឞ្យតិ, អស្យាំ កថាយាំ កិំ វិឝ្វសិឞិ? ");
INSERT INTO sankhm_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","សាវទត៑ ប្រភោ យស្យាវតរណាបេក្ឞាស្តិ ភវាន៑ សឯវាភិឞិក្ត្ត ឦឝ្វរបុត្រ ឥតិ វិឝ្វសិមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ឥតិ កថាំ កថយិត្វា សា គត្វា ស្វាំ ភគិនីំ មរិយមំ គុប្តមាហូយ វ្យាហរត៑ គុរុរុបតិឞ្ឋតិ ត្វាមាហូយតិ ច។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","កថាមិមាំ ឝ្រុត្វា សា តូណ៌ម៑ ឧត្ថាយ តស្យ សមីបម៑ អគច្ឆត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","យីឝុ រ្គ្រាមមធ្យំ ន ប្រវិឝ្យ យត្រ មត៌្ហា តំ សាក្ឞាទ៑ អករោត៑ តត្រ ស្ថិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","យេ យិហូទីយា មរិយមា សាកំ គ្ឫហេ តិឞ្ឋន្តស្តាម៑ អសាន្ត្វយន តេ តាំ ក្ឞិប្រម៑ ឧត្ថាយ គច្ឆន្តិំ វិលោក្យ វ្យាហរន៑, ស ឝ្មឝានេ រោទិតុំ យាតិ, ឥត្យុក្ត្វា តេ តស្យាះ បឝ្ចាទ៑ អគច្ឆន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","យត្រ យីឝុរតិឞ្ឋត៑ តត្រ មរិយម៑ ឧបស្ថាយ តំ ទ្ឫឞ្ដ្វា តស្យ ចរណយោះ បតិត្វា វ្យាហរត៑ ហេ ប្រភោ យទិ ភវាន៑ អត្រាស្ថាស្យត៑ តហ៌ិ មម ភ្រាតា នាមរិឞ្យត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","យីឝុស្តាំ តស្យាះ សង្គិនោ យិហូទីយាំឝ្ច រុទតោ វិលោក្យ ឝោកាត៌្តះ សន៑ ទីគ៌្ហំ និឝ្វស្យ កថិតវាន៑ តំ កុត្រាស្ថាបយត? ");
INSERT INTO sankhm_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","តេ វ្យាហរន៑, ហេ ប្រភោ ភវាន៑ អាគត្យ បឝ្យតុ។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","យីឝុនា ក្រន្ទិតំ។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","អតឯវ យិហូទីយា អវទន៑, បឝ្យតាយំ តស្មិន៑ កិទ្ឫគ៑ អប្រិយត។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","តេឞាំ កេចិទ៑ អវទន៑ យោន្ធាយ ចក្ឞុឞី ទត្តវាន៑ ស កិម៑ អស្យ ម្ឫត្យុំ និវារយិតុំ នាឝក្នោត៑? ");
INSERT INTO sankhm_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","តតោ យីឝុះ បុនរន្តទ៌ីគ៌្ហំ និឝ្វស្យ ឝ្មឝានាន្តិកម៑ អគច្ឆត៑។ តត៑ ឝ្មឝានម៑ ឯកំ គហ្វរំ តន្មុខេ បាឞាណ ឯក អាសីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","តទា យីឝុរវទទ៑ ឯនំ បាឞាណម៑ អបសារយត, តតះ ប្រមីតស្យ ភគិនី មត៌្ហាវទត៑ ប្រភោ, អធុនា តត្រ ទុគ៌ន្ធោ ជាតះ, យតោទ្យ ចត្វារិ ទិនានិ ឝ្មឝានេ ស តិឞ្ឋតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","តទា យីឝុរវាទីត៑, យទិ វិឝ្វសិឞិ តហ៌ីឝ្វរស្យ មហិមប្រកាឝំ ទ្រក្ឞ្យសិ កថាមិមាំ កិំ តុភ្យំ នាកថយំ? ");
INSERT INTO sankhm_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","តទា ម្ឫតស្យ ឝ្មឝានាត៑ បាឞាណោៜបសារិតេ យីឝុរូទ៌្វ្វំ បឝ្យន៑ អកថយត៑, ហេ បិត រ្មម នេវេសនម៑ អឝ្ឫណោះ ការណាទស្មាត៑ ត្វាំ ធន្យំ វទាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ត្វំ សតតំ ឝ្ឫណោឞិ តទប្យហំ ជានាមិ, កិន្តុ ត្វំ មាំ យត៑ ប្រៃរយស្តទ៑ យថាស្មិន៑ ស្ថានេ ស្ថិតា លោកា វិឝ្វសន្តិ តទត៌្ហម៑ ឥទំ វាក្យំ វទាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ឥមាំ កថាំ កថយិត្វា ស ប្រោច្ចៃរាហ្វយត៑, ហេ ឥលិយាសរ៑ ពហិរាគច្ឆ។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","តតះ ស ប្រមីតះ ឝ្មឝានវស្ត្រៃ រ្ពទ្ធហស្តបាទោ គាត្រមាជ៌នវាសសា ពទ្ធមុខឝ្ច ពហិរាគច្ឆត៑។ យីឝុរុទិតវាន៑ ពន្ធនានិ មោចយិត្វា ត្យជតៃនំ។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","មរិយមះ សមីបម៑ អាគតា យេ យិហូទីយលោកាស្តទា យីឝោរេតត៑ កម៌្មាបឝ្យន៑ តេឞាំ ពហវោ វ្យឝ្វសន៑, ");
INSERT INTO sankhm_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","កិន្តុ កេចិទន្យេ ផិរូឝិនាំ សមីបំ គត្វា យីឝោរេតស្យ កម៌្មណោ វាត៌្តាម៑ អវទន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","តតះ បរំ ប្រធានយាជកាះ ផិរូឝិនាឝ្ច សភាំ ក្ឫត្វា វ្យាហរន៑ វយំ កិំ កុម៌្មះ? ឯឞ មានវោ ពហូន្យាឝ្ចយ៌្យកម៌្មាណិ ករោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","យទីទ្ឫឝំ កម៌្ម កត៌្តុំ ន វារយាមស្តហ៌ិ សវ៌្វេ លោកាស្តស្មិន៑ វិឝ្វសិឞ្យន្តិ រោមិលោកាឝ្ចាគត្យាស្មាកម៑ អនយា រាជធាន្យា សាទ៌្ធំ រាជ្យម៑ អាឆេត្ស្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","តទា តេឞាំ កិយផានាមា យស្តស្មិន៑ វត្សរេ មហាយាជកបទេ ន្យយុជ្យត ស ប្រត្យវទទ៑ យូយំ កិមបិ ន ជានីថ; ");
INSERT INTO sankhm_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","សមគ្រទេឝស្យ វិនាឝតោបិ សវ៌្វលោកាត៌្ហម៑ ឯកស្យ ជនស្យ មរណម៑ អស្មាកំ មង្គលហេតុកម៑ ឯតស្យ វិវេចនាមបិ ន កុរុថ។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","ឯតាំ កថាំ ស និជពុទ្ធ្យា វ្យាហរទ៑ ឥតិ ន, ");
INSERT INTO sankhm_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","កិន្តុ យីឝូស្តទ្ទេឝីយានាំ ការណាត៑ ប្រាណាន៑ ត្យក្ឞ្យតិ, ទិឝិ ទិឝិ វិកីណ៌ាន៑ ឦឝ្វរស្យ សន្តានាន៑ សំគ្ឫហ្យៃកជាតិំ ករិឞ្យតិ ច, តស្មិន៑ វត្សរេ កិយផា មហាយាជកត្វបទេ និយុក្តះ សន៑ ឥទំ ភវិឞ្យទ្វាក្យំ កថិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","តទ្ទិនមារភ្យ តេ កថំ តំ ហន្តុំ ឝក្នុវន្តីតិ មន្ត្រណាំ កត៌្តុំ ប្រារេភិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","អតឯវ យិហូទីយានាំ មធ្យេ យីឝុះ សប្រកាឝំ គមនាគមនេ អក្ឫត្វា តស្មាទ៑ គត្វា ប្រាន្តរស្យ សមីបស្ថាយិប្រទេឝស្យេផ្រាយិម៑ នាម្និ នគរេ ឝិឞ្យៃះ សាកំ កាលំ យាបយិតុំ ប្រារេភេ។ ");
INSERT INTO sankhm_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","អនន្តរំ យិហូទីយានាំ និស្តារោត្សវេ និកដវត៌្តិនិ សតិ តទុត្សវាត៑ បូវ៌្វំ ស្វាន៑ ឝុចីន៑ កត៌្តុំ ពហវោ ជនា គ្រាមេភ្យោ យិរូឝាលម៑ នគរម៑ អាគច្ឆន៑, ");
INSERT INTO sankhm_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","យីឝោរន្វេឞណំ ក្ឫត្វា មន្ទិរេ ទណ្ឌាយមានាះ សន្តះ បរស្បរំ វ្យាហរន៑, យុឞ្មាកំ កីទ្ឫឝោ ពោធោ ជាយតេ? ស កិម៑ ឧត្សវេៜស្មិន៑ អត្រាគមិឞ្យតិ? ");
INSERT INTO sankhm_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","ស ច កុត្រាស្តិ យទ្យេតត៑ កឝ្ចិទ៑ វេត្តិ តហ៌ិ ទឝ៌យតុ ប្រធានយាជកាះ ផិរូឝិនឝ្ច តំ ធត៌្តុំ បូវ៌្វម៑ ឥមាម៑ អាជ្ញាំ ប្រាចារយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","និស្តារោត្សវាត៑ បូវ៌្វំ ទិនឞដ្កេ ស្ថិតេ យីឝុ រ្យំ ប្រមីតម៑ ឥលិយាសរំ ឝ្មឝានាទ៑ ឧទស្ថាបរត៑ តស្យ និវាសស្ថានំ ពៃថនិយាគ្រាមម៑ អាគច្ឆត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","តត្រ តទត៌្ហំ រជន្យាំ ភោជ្យេ ក្ឫតេ មត៌្ហា បយ៌្យវេឞយទ៑ ឥលិយាសរ៑ ច តស្យ សង្គិភិះ សាទ៌្ធំ ភោជនាសន ឧបាវិឝត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","តទា មរិយម៑ អទ៌្ធសេដកំ ពហុមូល្យំ ជដាមាំសីយំ តៃលម៑ អានីយ យីឝោឝ្ចរណយោ រ្មទ៌្ទយិត្វា និជកេឝ រ្មាឞ៌្ដុម៑ អារភត; តទា តៃលស្យ បរិមលេន គ្ឫហម៑ អាមោទិតម៑ អភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","យះ ឝិមោនះ បុត្រ រិឞ្ករិយោតីយោ យិហូទានាមា យីឝុំ បរករេឞុ សមប៌យិឞ្យតិ ស ឝិឞ្យស្តទា កថិតវាន៑, ");
INSERT INTO sankhm_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","ឯតត្តៃលំ ត្រិភិះ ឝតៃ រ្មុទ្រាបទៃ រ្វិក្រីតំ សទ៑ ទរិទ្រេភ្យះ កុតោ នាទីយត? ");
INSERT INTO sankhm_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ស ទរិទ្រលោកាត៌្ហម៑ អចិន្តយទ៑ ឥតិ ន, កិន្តុ ស ចៅរ ឯវំ តន្និកដេ មុទ្រាសម្បុដកស្ថិត្យា តន្មធ្យេ យទតិឞ្ឋត៑ តទបាហរត៑ តស្មាត៑ ការណាទ៑ ឥមាំ កថាមកថយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","តទា យីឝុរកថយទ៑ ឯនាំ មា វារយ សា មម ឝ្មឝានស្ថាបនទិនាត៌្ហំ តទរក្ឞយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","ទរិទ្រា យុឞ្មាកំ សន្និធៅ សវ៌្វទា តិឞ្ឋន្តិ កិន្ត្វហំ សវ៌្វទា យុឞ្មាកំ សន្និធៅ ន តិឞ្ឋាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","តតះ បរំ យីឝុស្តត្រាស្តីតិ វាត៌្តាំ ឝ្រុត្វា ពហវោ យិហូទីយាស្តំ ឝ្មឝានាទុត្ថាបិតម៑ ឥលិយាសរញ្ច ទ្រឞ្ដុំ តត៑ ស្ថានម៑ អាគច្ឆន។ ");
INSERT INTO sankhm_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","តទា ប្រធានយាជកាស្តម៑ ឥលិយាសរមបិ សំហត៌្តុម៑ អមន្ត្រយន៑ ; ");
INSERT INTO sankhm_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","យតស្តេន ពហវោ យិហូទីយា គត្វា យីឝៅ វ្យឝ្វសន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","អនន្តរំ យីឝុ រ្យិរូឝាលម៑ នគរម៑ អាគច្ឆតីតិ វាត៌្តាំ ឝ្រុត្វា បរេៜហនិ ឧត្សវាគតា ពហវោ លោកាះ ");
INSERT INTO sankhm_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ខជ៌្ជូរបត្រាទ្យានីយ តំ សាក្ឞាត៑ កត៌្តុំ ពហិរាគត្យ ជយ ជយេតិ វាចំ ប្រោច្ចៃ រ្វក្តុម៑ អារភន្ត, ឥស្រាយេលោ យោ រាជា បរមេឝ្វរស្យ នាម្នាគច្ឆតិ ស ធន្យះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","តទា \"ហេ សិយោនះ កន្យេ មា ភៃឞីះ បឝ្យាយំ តវ រាជា គទ៌្ទភឝាវកម៑ អារុហ្យាគច្ឆតិ\" ");
INSERT INTO sankhm_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","ឥតិ ឝាស្ត្រីយវចនានុសារេណ យីឝុរេកំ យុវគទ៌្ទភំ ប្រាប្យ តទុបយ៌្យារោហត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","អស្យាះ ឃដនាយាស្តាត្បយ៌្យំ ឝិឞ្យាះ ប្រថមំ នាពុធ្យន្ត, កិន្តុ យីឝៅ មហិមានំ ប្រាប្តេ សតិ វាក្យមិទំ តស្មិន អកថ្យត លោកាឝ្ច តម្ប្រតីត្ថម៑ អកុវ៌្វន៑ ឥតិ តេ ស្ម្ឫតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","ស ឥលិយាសរំ ឝ្មឝានាទ៑ អាគន្តុម៑ អាហ្វតវាន៑ ឝ្មឝានាញ្ច ឧទស្ថាបយទ៑ យេ យេ លោកាស្តត្កម៌្យ សាក្ឞាទ៑ អបឝ្យន៑ តេ ប្រមាណំ ទាតុម៑ អារភន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ស ឯតាទ្ឫឝម៑ អទ្ភុតំ កម៌្មករោត៑ តស្យ ជនឝ្រុតេ រ្លោកាស្តំ សាក្ឞាត៑ កត៌្តុម៑ អាគច្ឆន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","តតះ ផិរូឝិនះ បរស្បរំ វក្តុម៑ អារភន្ត យុឞ្មាកំ សវ៌្វាឝ្ចេឞ្ដា វ្ឫថា ជាតាះ, ឥតិ កិំ យូយំ ន ពុធ្យធ្វេ? បឝ្យត សវ៌្វេ លោកាស្តស្យ បឝ្ចាទ្វត៌្តិនោភវន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ភជនំ កត៌្តុម៑ ឧត្សវាគតានាំ លោកានាំ កតិបយា ជនា អន្យទេឝីយា អាសន៑ , ");
INSERT INTO sankhm_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","តេ គាលីលីយពៃត្សៃទានិវាសិនះ ផិលិបស្យ សមីបម៑ អាគត្យ វ្យាហរន៑ ហេ មហេច្ឆ វយំ យីឝុំ ទ្រឞ្ដុម៑ ឥច្ឆាមះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","តតះ ផិលិបោ គត្វា អាន្ទ្រិយម៑ អវទត៑ បឝ្ចាទ៑ អាន្ទ្រិយផិលិបៅ យីឝវេ វាត៌្តាម៑ អកថយតាំ។ ");
INSERT INTO sankhm_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","តទា យីឝុះ ប្រត្យុទិតវាន៑ មានវសុតស្យ មហិមប្រាប្តិសមយ ឧបស្ថិតះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","អហំ យុឞ្មានតិយថាត៌្ហំ វទាមិ, ធាន្យពីជំ ម្ឫត្តិកាយាំ បតិត្វា យទិ ន ម្ឫយតេ តហ៌្យេកាកី តិឞ្ឋតិ កិន្តុ យទិ ម្ឫយតេ តហ៌ិ ពហុគុណំ ផលំ ផលតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","យោ ជនេा និជប្រាណាន៑ ប្រិយាន៑ ជានាតិ ស តាន៑ ហារយិឞ្យតិ កិន្តុ យេा ជន ឥហលោកេ និជប្រាណាន៑ អប្រិយាន៑ ជានាតិ សេाនន្តាយុះ ប្រាប្តុំ តាន៑ រក្ឞិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","កឝ្ចិទ៑ យទិ មម សេវកោ ភវិតុំ វាញ្ឆតិ តហ៌ិ ស មម បឝ្ចាទ្គាមី ភវតុ, តស្មាទ៑ អហំ យត្រ តិឞ្ឋាមិ មម សេវកេाបិ តត្រ ស្ថាស្យតិ; យោ ជនោ មាំ សេវតេ មម បិតាបិ តំ សម្មំស្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","សាម្ប្រតំ មម ប្រាណា វ្យាកុលា ភវន្តិ, តស្មាទ៑ ហេ បិតរ ឯតស្មាត៑ សមយាន៑ មាំ រក្ឞ, ឥត្យហំ កិំ ប្រាត៌្ហយិឞ្យេ? កិន្ត្វហម៑ ឯតត្សមយាត៌្ហម៑ អវតីណ៌វាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ហេ បិត: ស្វនាម្នោ មហិមានំ ប្រកាឝយ; តនៃវ ស្វនាម្នោ មហិមានម៑ អហំ ប្រាកាឝយំ បុនរបិ ប្រកាឝយិឞ្យាមិ, ឯឞា គគណីយា វាណី តស្មិន៑ សមយេៜជាយត។ ");
INSERT INTO sankhm_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","តច្ឝ្រុត្វា សមីបស្ថលោកានាំ កេចិទ៑ អវទន៑ មេឃោៜគជ៌ីត៑, កេចិទ៑ អវទន៑ ស្វគ៌ីយទូតោៜនេន សហ កថាមចកថត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","តទា យីឝុះ ប្រត្យវាទីត៑, មទត៌្ហំ ឝព្ទោយំ នាភូត៑ យុឞ្មទត៌្ហមេវាភូត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","អធុនា ជគតោស្យ វិចារ: សម្បត្ស្យតេ, អធុនាស្យ ជគត: បតី រាជ្យាត៑ ច្យោឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","យទ្យឦ ប្ឫថិវ្យា ឩទ៌្វ្វេ ប្រោត្ថាបិតោស្មិ តហ៌ិ សវ៌្វាន៑ មានវាន៑ ស្វសមីបម៑ អាកឞ៌ិឞ្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","កថំ តស្យ ម្ឫតិ រ្ភវិឞ្យតិ, ឯតទ៑ ពោធយិតុំ ស ឥមាំ កថាម៑ អកថយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","តទា លោកា អកថយន៑ សោភិឞិក្តះ សវ៌្វទា តិឞ្ឋតីតិ វ្យវស្ថាគ្រន្ថេ ឝ្រុតម៑ អស្មាភិះ, តហ៌ិ មនុឞ្យបុត្រះ ប្រោត្ថាបិតោ ភវិឞ្យតីតិ វាក្យំ កថំ វទសិ? មនុឞ្យបុត្រោយំ កះ? ");
INSERT INTO sankhm_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","តទា យីឝុរកថាយទ៑ យុឞ្មាភិះ សាទ៌្ធម៑ អល្បទិនានិ ជ្យោតិរាស្តេ, យថា យុឞ្មាន៑ អន្ធការោ នាច្ឆាទយតិ តទត៌្ហំ យាវត្កាលំ យុឞ្មាភិះ សាទ៌្ធំ ជ្យោតិស្តិឞ្ឋតិ តាវត្កាលំ គច្ឆត; យោ ជនោៜន្ធការេ គច្ឆតិ ស កុត្រ យាតីតិ ន ជានាតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","អតឯវ យាវត្កាលំ យុឞ្មាកំ និកដេ ជ្យោតិរាស្តេ តាវត្កាលំ ជ្យោតីរូបសន្តានា ភវិតុំ ជ្យោតិឞិ វិឝ្វសិត; ឥមាំ កថាំ កថយិត្វា យីឝុះ ប្រស្ថាយ តេភ្យះ ស្វំ គុប្តវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","យទ្យបិ យីឝុស្តេឞាំ សមក្ឞម៑ ឯតាវទាឝ្ចយ៌្យកម៌្មាណិ ក្ឫតវាន៑ តថាបិ តេ តស្មិន៑ ន វ្យឝ្វសន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","អតឯវ កះ ប្រត្យេតិ សុសំវាទំ បរេឝាស្មត៑ ប្រចារិតំ? ប្រកាឝតេ បរេឝស្យ ហស្តះ កស្យ ច សន្និធៅ? យិឝយិយភវិឞ្យទ្វាទិនា យទេតទ៑ វាក្យមុក្តំ តត៑ សផលម៑ អភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","តេ ប្រត្យេតុំ នាឝន្កុវន៑ តស្មិន៑ យិឝយិយភវិឞ្យទ្វាទិ បុនរវាទីទ៑, ");
INSERT INTO sankhm_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","យទា, \"តេ នយនៃ រ្ន បឝ្យន្តិ ពុទ្ធិភិឝ្ច ន ពុធ្យន្តេ តៃ រ្មនះសុ បរិវត៌្តិតេឞុ ច តានហំ យថា ស្វស្ថាន៑ ន ករោមិ តថា ស តេឞាំ លោចនាន្យន្ធានិ ក្ឫត្វា តេឞាមន្តះករណានិ គាឍានិ ករិឞ្យតិ។ \" ");
INSERT INTO sankhm_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","យិឝយិយោ យទា យីឝោ រ្មហិមានំ វិលោក្យ តស្មិន៑ កថាមកថយត៑ តទា ភវិឞ្យទ្វាក្យម៑ ឦទ្ឫឝំ ប្រកាឝយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","តថាប្យធិបតិនាំ ពហវស្តស្មិន៑ ប្រត្យាយន៑។ កិន្តុ ផិរូឝិនស្តាន៑ ភជនគ្ឫហាទ៑ ទូរីកុវ៌្វន្តីតិ ភយាត៑ តេ តំ ន ស្វីក្ឫតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","យត ឦឝ្វរស្យ ប្រឝំសាតោ មានវានាំ ប្រឝំសាយាំ តេៜប្រិយន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","តទា យីឝុរុច្ចៃះការម៑ អកថយទ៑ យោ ជនោ មយិ វិឝ្វសិតិ ស កេវលេ មយិ វិឝ្វសិតីតិ ន, ស មត្ប្រេរកេៜបិ វិឝ្វសិតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","យោ ជនោ មាំ បឝ្យតិ ស មត្ប្រេរកមបិ បឝ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","យោ ជនោ មាំ ប្រត្យេតិ ស យថាន្ធការេ ន តិឞ្ឋតិ តទត៌្ហម៑ អហំ ជ្យោតិះស្វរូបោ ភូត្វា ជគត្យស្មិន៑ អវតីណ៌វាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","មម កថាំ ឝ្រុត្វា យទិ កឝ្ចិន៑ ន វិឝ្វសិតិ តហ៌ិ តមហំ ទោឞិណំ ន ករោមិ, យតោ ហេតោ រ្ជគតោ ជនានាំ ទោឞាន៑ និឝ្ចិតាន៑ កត៌្តុំ នាគត្យ តាន៑ បរិចាតុម៑ អាគតោស្មិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","យះ កឝ្ចិន៑ មាំ ន ឝ្រទ្ធាយ មម កថំ ន គ្ឫហ្លាតិ, អន្យស្តំ ទោឞិណំ ករិឞ្យតិ វស្តុតស្តុ យាំ កថាមហម៑ អចកថំ សា កថា ចរមេៜន្ហិ តំ ទោឞិណំ ករិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","យតោ ហេតោរហំ ស្វតះ កិមបិ ន កថយាមិ, កិំ កិំ មយា កថយិតវ្យំ កិំ សមុបទេឞ្ដវ្យញ្ច ឥតិ មត្ប្រេរយិតា បិតា មាមាជ្ញាបយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","តស្យ សាជ្ញា អនន្តាយុរិត្យហំ ជានាមិ, អតឯវាហំ យត៑ កថយាមិ តត៑ បិតា យថាជ្ញាបយត៑ តថៃវ កថយាម្យហម៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","និស្តារោត្សវស្យ កិញ្ចិត្កាលាត៑ បូវ៌្វំ ប្ឫថិវ្យាះ បិតុះ សមីបគមនស្យ សមយះ សន្និកឞ៌ោភូទ៑ ឥតិ ជ្ញាត្វា យីឝុរាប្រថមាទ៑ យេឞុ ជគត្ប្រវាសិឞ្វាត្មីយលោកេឞ ប្រេម ករោតិ ស្ម តេឞុ ឝេឞំ យាវត៑ ប្រេម ក្ឫតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","បិតា តស្យ ហស្តេ សវ៌្វំ សមប៌ិតវាន៑ ស្វយម៑ ឦឝ្វរស្យ សមីបាទ៑ អាគច្ឆទ៑ ឦឝ្វរស្យ សមីបំ យាស្យតិ ច, សវ៌្វាណ្យេតានិ ជ្ញាត្វា រជន្យាំ ភោជនេ សម្បូណ៌េ សតិ, ");
INSERT INTO sankhm_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","យទា ឝៃតាន៑ តំ បរហស្តេឞុ សមប៌យិតុំ ឝិមោនះ បុត្រស្យ ឦឞ្ការិយោតិយស្យ យិហូទា អន្តះករណេ កុប្រវ្ឫត្តិំ សមាប៌យត៑, ");
INSERT INTO sankhm_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","តទា យីឝុ រ្ភោជនាសនាទ៑ ឧត្ថាយ គាត្រវស្ត្រំ មោចយិត្វា គាត្រមាជ៌នវស្ត្រំ គ្ឫហីត្វា តេន ស្វកដិម៑ អពធ្នាត៑, ");
INSERT INTO sankhm_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","បឝ្ចាទ៑ ឯកបាត្រេ ជលម៑ អភិឞិច្យ ឝិឞ្យាណាំ បាទាន៑ ប្រក្ឞាល្យ តេន កដិពទ្ធគាត្រមាជ៌នវាសសា មាឞ៌្ដុំ ប្រារភត។ ");
INSERT INTO sankhm_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","តតះ ឝិមោន្បិតរស្យ សមីបមាគតេ ស ឧក្តវាន៑ ហេ ប្រភោ ភវាន៑ កិំ មម បាទៅ ប្រក្ឞាលយិឞ្យតិ? ");
INSERT INTO sankhm_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","យីឝុរុទិតវាន៑ អហំ យត៑ ករោមិ តត៑ សម្ប្រតិ ន ជានាសិ កិន្តុ បឝ្ចាជ៑ ជ្ញាស្យសិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","តតះ បិតរះ កថិតវាន៑ ភវាន៑ កទាបិ មម បាទៅ ន ប្រក្ឞាលយិឞ្យតិ។ យីឝុរកថយទ៑ យទិ ត្វាំ ន ប្រក្ឞាលយេ តហ៌ិ មយិ តវ កោប្យំឝោ នាស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","តទា ឝិមោន្បិតរះ កថិតវាន៑ ហេ ប្រភោ តហ៌ិ កេវលបាទៅ ន, មម ហស្តៅ ឝិរឝ្ច ប្រក្ឞាលយតុ។ ");
INSERT INTO sankhm_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","តតោ យីឝុរវទទ៑ យោ ជនោ ធៅតស្តស្យ សវ៌្វាង្គបរិឞ្ក្ឫតត្វាត៑ បាទៅ វិនាន្យាង្គស្យ ប្រក្ឞាលនាបេក្ឞា នាស្តិ។ យូយំ បរិឞ្ក្ឫតា ឥតិ សត្យំ កិន្តុ ន សវ៌្វេ, ");
INSERT INTO sankhm_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","យតោ យោ ជនស្តំ បរករេឞុ សមប៌យិឞ្យតិ តំ ស ជ្ញាតវាន; អតឯវ យូយំ សវ៌្វេ ន បរិឞ្ក្ឫតា ឥមាំ កថាំ កថិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ឥត្ថំ យីឝុស្តេឞាំ បាទាន៑ ប្រក្ឞាល្យ វស្ត្រំ បរិធាយាសនេ សមុបវិឝ្យ កថិតវាន៑ អហំ យុឞ្មាន៑ ប្រតិ កិំ កម៌្មាកាឞ៌ំ ជានីថ? ");
INSERT INTO sankhm_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","យូយំ មាំ គុរុំ ប្រភុញ្ច វទថ តត៑ សត្យមេវ វទថ យតោហំ សឯវ ភវាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","យទ្យហំ ប្រភុ រ្គុរុឝ្ច សន៑ យុឞ្មាកំ បាទាន៑ ប្រក្ឞាលិតវាន៑ តហ៌ិ យុឞ្មាកមបិ បរស្បរំ បាទប្រក្ឞាលនម៑ ឧចិតម៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","អហំ យុឞ្មាន៑ ប្រតិ យថា វ្យវាហរំ យុឞ្មាន៑ តថា វ្យវហត៌្តុម៑ ឯកំ បន្ថានំ ទឝ៌ិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","អហំ យុឞ្មានតិយថាត៌្ហំ វទាមិ, ប្រភោ រ្ទាសោ ន មហាន៑ ប្រេរកាច្ច ប្រេរិតោ ន មហាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ឥមាំ កថាំ វិទិត្វា យទិ តទនុសារតះ កម៌្មាណិ កុរុថ តហ៌ិ យូយំ ធន្យា ភវិឞ្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","សវ៌្វេឞុ យុឞ្មាសុ កថាមិមាំ កថយាមិ ឥតិ ន, យេ មម មនោនីតាស្តានហំ ជានាមិ, កិន្តុ មម ភក្ឞ្យាណិ យោ ភុង្ក្តេ មត្ប្រាណប្រាតិកូល្យតះ។ ឧត្ថាបយតិ បាទស្យ មូលំ ស ឯឞ មានវះ។ យទេតទ៑ ធម៌្មបុស្តកស្យ វចនំ តទនុសារេណាវឝ្យំ ឃដិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","អហំ ស ជន ឥត្យត្រ យថា យុឞ្មាកំ វិឝ្វាសោ ជាយតេ តទត៌្ហំ ឯតាទ្ឫឝឃដនាត៑ បូវ៌្វម៑ អហមិទានីំ យុឞ្មភ្យមកថយម៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","អហំ យុឞ្មានតីវ យថាត៌្ហំ វទាមិ, មយា ប្រេរិតំ ជនំ យោ គ្ឫហ្លាតិ ស មាមេវ គ្ឫហ្លាតិ យឝ្ច មាំ គ្ឫហ្លាតិ ស មត្ប្រេរកំ គ្ឫហ្លាតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ឯតាំ កថាំ កថយិត្វា យីឝុ រ្ទុះខី សន៑ ប្រមាណំ ទត្ត្វា កថិតវាន៑ អហំ យុឞ្មានតិយថាត៌្ហំ វទាមិ យុឞ្មាកម៑ ឯកោ ជនោ មាំ បរករេឞុ សមប៌យិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","តតះ ស កមុទ្ទិឝ្យ កថាមេតាំ កថិតវាន៑ ឥត្យត្រ សន្ទិគ្ធាះ ឝិឞ្យាះ បរស្បរំ មុខមាលោកយិតុំ ប្រារភន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","តស្មិន៑ សមយេ យីឝុ រ្យស្មិន៑ អប្រីយត ស ឝិឞ្យស្តស្យ វក្ឞះស្ថលម៑ អវាលម្ពត។ ");
INSERT INTO sankhm_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ឝិមោន្បិតរស្តំ សង្កេតេនាវទត៑, អយំ កមុទ្ទិឝ្យ កថាមេតាម៑ កថយតីតិ ប្ឫច្ឆ។ ");
INSERT INTO sankhm_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","តទា ស យីឝោ រ្វក្ឞះស្ថលម៑ អវលម្ព្យ ប្ឫឞ្ឋវាន៑, ហេ ប្រភោ ស ជនះ កះ? ");
INSERT INTO sankhm_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","តតោ យីឝុះ ប្រត្យវទទ៑ ឯកខណ្ឌំ បូបំ មជ្ជយិត្វា យស្មៃ ទាស្យាមិ សឯវ សះ; បឝ្ចាត៑ បូបខណ្ឌមេកំ មជ្ជយិត្វា ឝិមោនះ បុត្រាយ ឦឞ្ករិយោតីយាយ យិហូទៃ ទត្តវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","តស្មិន៑ ទត្តេ សតិ ឝៃតាន៑ តមាឝ្រយត៑; តទា យីឝុស្តម៑ អវទត៑ ត្វំ យត៑ ករិឞ្យសិ តត៑ ក្ឞិប្រំ កុរុ។ ");
INSERT INTO sankhm_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","កិន្តុ ស យេនាឝយេន តាំ កថាមកថាយត៑ តម៑ ឧបវិឞ្ដលោកានាំ កោបិ នាពុធ្យត; ");
INSERT INTO sankhm_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","កិន្តុ យិហូទាះ សមីបេ មុទ្រាសម្បុដកស្ថិតេះ កេចិទ៑ ឥត្ថម៑ អពុធ្យន្ត បាវ៌្វណាសាទនាត៌្ហំ កិមបិ ទ្រវ្យំ ក្រេតុំ វា ទរិទ្រេភ្យះ កិញ្ចិទ៑ វិតរិតុំ កថិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","តទា បូបខណ្ឌគ្រហណាត៑ បរំ ស តូណ៌ំ ពហិរគច្ឆត៑; រាត្រិឝ្ច សមុបស្យិតា។ ");
INSERT INTO sankhm_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","យិហូទេ ពហិគ៌តេ យីឝុរកថយទ៑ ឥទានីំ មានវសុតស្យ មហិមា ប្រកាឝតេ តេនេឝ្វរស្យាបិ មហិមា ប្រកាឝតេ។ ");
INSERT INTO sankhm_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","យទិ តេនេឝ្វរស្យ មហិមា ប្រកាឝតេ តហ៌ីឝ្វរោបិ ស្វេន តស្យ មហិមានំ ប្រកាឝយិឞ្យតិ តូណ៌មេវ ប្រកាឝយិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ហេ វត្សា អហំ យុឞ្មាភិះ សាទ៌្ធំ កិញ្ចិត្កាលមាត្រម៑ អាសេ, តតះ បរំ មាំ ម្ឫគយិឞ្យធ្វេ កិន្ត្វហំ យត្ស្ថានំ យាមិ តត្ស្ថានំ យូយំ គន្តុំ ន ឝក្ឞ្យថ, យាមិមាំ កថាំ យិហូទីយេភ្យះ កថិតវាន៑ តថាធុនា យុឞ្មភ្យមបិ កថយាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","យូយំ បរស្បរំ ប្រីយធ្វម៑ អហំ យុឞ្មាសុ យថា ប្រីយេ យូយមបិ បរស្បរម៑ តថៃវ ប្រីយធ្វំ, យុឞ្មាន៑ ឥមាំ នវីនាម៑ អាជ្ញាម៑ អាទិឝាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","តេនៃវ យទិ បរស្បរំ ប្រីយធ្វេ តហ៌ិ លក្ឞណេនានេន យូយំ មម ឝិឞ្យា ឥតិ សវ៌្វេ ជ្ញាតុំ ឝក្ឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ឝិមោនបិតរះ ប្ឫឞ្ឋវាន៑ ហេ ប្រភោ ភវាន៑ កុត្រ យាស្យតិ? តតោ យីឝុះ ប្រត្យវទត៑, អហំ យត្ស្ថានំ យាមិ តត្ស្ថានំ សាម្ប្រតំ មម បឝ្ចាទ៑ គន្តុំ ន ឝក្នោឞិ កិន្តុ បឝ្ចាទ៑ គមិឞ្យសិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","តទា បិតរះ ប្រត្យុទិតវាន៑, ហេ ប្រភោ សាម្ប្រតំ កុតោ ហេតោស្តវ បឝ្ចាទ៑ គន្តុំ ន ឝក្នោមិ? ត្វទត៌្ហំ ប្រាណាន៑ ទាតុំ ឝក្នោមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","តតោ យីឝុះ ប្រត្យុក្តវាន៑ មន្និមិត្តំ កិំ ប្រាណាន៑ ទាតុំ ឝក្នោឞិ? ត្វាមហំ យថាត៌្ហំ វទាមិ, កុក្កុដរវណាត៑ បូវ៌្វំ ត្វំ ត្រិ រ្មាម៑ អបហ្នោឞ្យសេ។ ");
INSERT INTO sankhm_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","មនោទុះខិនោ មា ភូត; ឦឝ្វរេ វិឝ្វសិត មយិ ច វិឝ្វសិត។ ");
INSERT INTO sankhm_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","មម បិតុ គ្ឫហេ ពហូនិ វាសស្ថានិ សន្តិ នោ ចេត៑ បូវ៌្វំ យុឞ្មាន៑ អជ្ញាបយិឞ្យំ យុឞ្មទត៌្ហំ ស្ថានំ សជ្ជយិតុំ គច្ឆាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","យទិ គត្វាហំ យុឞ្មន្និមិត្តំ ស្ថានំ សជ្ជយាមិ តហ៌ិ បនរាគត្យ យុឞ្មាន៑ ស្វសមីបំ នេឞ្យាមិ, តតោ យត្រាហំ តិឞ្ឋាមិ តត្រ យូយមបិ ស្ថាស្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","អហំ យត្ស្ថានំ ព្រជាមិ តត្ស្ថានំ យូយំ ជានីថ តស្យ បន្ថានមបិ ជានីថ។ ");
INSERT INTO sankhm_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","តទា ថោមា អវទត៑, ហេ ប្រភោ ភវាន៑ កុត្រ យាតិ តទ្វយំ ន ជានីមះ, តហ៌ិ កថំ បន្ថានំ ជ្ញាតុំ ឝក្នុមះ? ");
INSERT INTO sankhm_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","យីឝុរកថយទ៑ អហមេវ សត្យជីវនរូបបថោ មយា ន គន្តា កោបិ បិតុះ សមីបំ គន្តុំ ន ឝក្នោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","យទិ មាម៑ អជ្ញាស្យត តហ៌ិ មម បិតរមប្យជ្ញាស្យត កិន្ត្វធុនាតស្តំ ជានីថ បឝ្យថ ច។ ");
INSERT INTO sankhm_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","តទា ផិលិបះ កថិតវាន៑, ហេ ប្រភោ បិតរំ ទឝ៌យ តស្មាទស្មាកំ យថេឞ្ដំ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","តតោ យីឝុះ ប្រត្យាវាទីត៑, ហេ ផិលិប យុឞ្មាភិះ សាទ៌្ធម៑ ឯតាវទ្ទិនានិ ស្ថិតមបិ មាំ កិំ ន ប្រត្យភិជានាសិ? យោ ជនោ មាម៑ អបឝ្យត៑ ស បិតរមប្យបឝ្យត៑ តហ៌ិ បិតរម៑ អស្មាន៑ ទឝ៌យេតិ កថាំ កថំ កថយសិ? ");
INSERT INTO sankhm_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","អហំ បិតរិ តិឞ្ឋាមិ បិតា មយិ តិឞ្ឋតីតិ កិំ ត្វំ ន ប្រត្យឞិ? អហំ យទ្វាក្យំ វទាមិ តត៑ ស្វតោ ន វទាមិ កិន្តុ យះ បិតា មយិ វិរាជតេ ស ឯវ សវ៌្វកម៌្មាណិ ករាតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","អតឯវ បិតយ៌្យហំ តិឞ្ឋាមិ បិតា ច មយិ តិឞ្ឋតិ មមាស្យាំ កថាយាំ ប្រត្យយំ កុរុត, នោ ចេត៑ កម៌្មហេតោះ ប្រត្យយំ កុរុត។ ");
INSERT INTO sankhm_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","អហំ យុឞ្មានតិយថាត៌្ហំ វទាមិ, យោ ជនោ មយិ វិឝ្វសិតិ សោហមិវ កម៌្មាណិ ករិឞ្យតិ វរំ តតោបិ មហាកម៌្មាណិ ករិឞ្យតិ យតោ ហេតោរហំ បិតុះ សមីបំ គច្ឆាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","យថា បុត្រេណ បិតុ រ្មហិមា ប្រកាឝតេ តទត៌្ហំ មម នាម ប្រោច្យ យត៑ ប្រាត៌្ហយិឞ្យធ្វេ តត៑ សផលំ ករិឞ្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","យទិ មម នាម្នា យត៑ កិញ្ចិទ៑ យាចធ្វេ តហ៌ិ តទហំ សាធយិឞ្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","យទិ មយិ ប្រីយធ្វេ តហ៌ិ មមាជ្ញាះ សមាចរត។ ");
INSERT INTO sankhm_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","តតោ មយា បិតុះ សមីបេ ប្រាត៌្ហិតេ បិតា និរន្តរំ យុឞ្មាភិះ សាទ៌្ធំ ស្ថាតុម៑ ឥតរមេកំ សហាយម៑ អត៌្ហាត៑ សត្យមយម៑ អាត្មានំ យុឞ្មាកំ និកដំ ប្រេឞយិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ឯតជ្ជគតោ លោកាស្តំ គ្រហីតុំ ន ឝក្នុវន្តិ យតស្តេ តំ នាបឝ្យន៑ នាជនំឝ្ច កិន្តុ យូយំ ជានីថ យតោ ហេតោះ ស យុឞ្មាកមន្ត រ្និវសតិ យុឞ្មាកំ មធ្យេ ស្ថាស្យតិ ច។ ");
INSERT INTO sankhm_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","អហំ យុឞ្មាន៑ អនាថាន៑ ក្ឫត្វា ន យាស្យាមិ បុនរបិ យុឞ្មាកំ សមីបម៑ អាគមិឞ្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","កិយត្កាលរត៑ បរម៑ អស្យ ជគតោ លោកា មាំ បុន រ្ន ទ្រក្ឞ្យន្តិ កិន្តុ យូយំ ទ្រក្ឞ្យថ;អហំ ជីវិឞ្យាមិ តស្មាត៑ ការណាទ៑ យូយមបិ ជីវិឞ្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","បិតយ៌្យហមស្មិ មយិ ច យូយំ ស្ថ, តថាហំ យុឞ្មាស្វស្មិ តទបិ តទា ជ្ញាស្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","យោ ជនោ មមាជ្ញា គ្ឫហីត្វា តា អាចរតិ សឯវ មយិ ប្រីយតេ; យោ ជនឝ្ច មយិ ប្រីយតេ សឯវ មម បិតុះ ប្រិយបាត្រំ ភវិឞ្យតិ, តថាហមបិ តស្មិន៑ ប្រីត្វា តស្មៃ ស្វំ ប្រកាឝយិឞ្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","តទា ឦឞ្ករិយោតីយាទ៑ អន្យោ យិហូទាស្តមវទត៑, ហេ ប្រភោ ភវាន៑ ជគតោ លោកានាំ សន្និធៅ ប្រកាឝិតោ ន ភូត្វាស្មាកំ សន្និធៅ កុតះ ប្រកាឝិតោ ភវិឞ្យតិ? ");
INSERT INTO sankhm_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","តតោ យីឝុះ ប្រត្យុទិតវាន៑, យោ ជនោ មយិ ប្រីយតេ ស មមាជ្ញា អបិ គ្ឫហ្លាតិ, តេន មម បិតាបិ តស្មិន៑ ប្រេឞ្យតេ, អាវាញ្ច តន្និកដមាគត្យ តេន សហ និវត្ស្យាវះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","យោ ជនោ មយិ ន ប្រីយតេ ស មម កថា អបិ ន គ្ឫហ្លាតិ បុនឝ្ច យាមិមាំ កថាំ យូយំ ឝ្ឫណុថ សា កថា កេវលស្យ មម ន កិន្តុ មម ប្រេរកោ យះ បិតា តស្យាបិ កថា។ ");
INSERT INTO sankhm_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","ឥទានីំ យុឞ្មាកំ និកដេ វិទ្យមានោហម៑ ឯតាះ សកលាះ កថាះ កថយាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","កិន្ត្វិតះ បរំ បិត្រា យះ សហាយោៜរ្ថាត៑ បវិត្រ អាត្មា មម នាម្និ ប្រេរយិឞ្យតិ ស សវ៌្វំ ឝិក្ឞយិត្វា មយោក្តាះ សមស្តាះ កថា យុឞ្មាន៑ ស្មារយិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","អហំ យុឞ្មាកំ និកដេ ឝាន្តិំ ស្ថាបយិត្វា យាមិ, និជាំ ឝាន្តិំ យុឞ្មភ្យំ ទទាមិ, ជគតោ លោកា យថា ទទាតិ តថាហំ ន ទទាមិ; យុឞ្មាកម៑ អន្តះករណានិ ទុះខិតានិ ភីតានិ ច ន ភវន្តុ។ ");
INSERT INTO sankhm_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","អហំ គត្វា បុនរបិ យុឞ្មាកំ សមីបម៑ អាគមិឞ្យាមិ មយោក្តំ វាក្យមិទំ យូយម៑ អឝ្រៅឞ្ដ; យទិ មយ្យប្រេឞ្យធ្វំ តហ៌្យហំ បិតុះ សមីបំ គច្ឆាមិ មមាស្យាំ កថាយាំ យូយម៑ អហ្លាទិឞ្យធ្វំ យតោ មម បិតា មត្តោបិ មហាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","តស្យា ឃដនាយាះ សមយេ យថា យុឞ្មាកំ ឝ្រទ្ធា ជាយតេ តទត៌្ហម៑ អហំ តស្យា ឃដនាយាះ បូវ៌្វម៑ ឥទានីំ យុឞ្មាន៑ ឯតាំ វាត៌្តាំ វទាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ឥតះ បរំ យុឞ្មាភិះ សហ មម ពហវ អាលាបា ន ភវិឞ្យន្តិ យតះ ការណាទ៑ ឯតស្យ ជគតះ បតិរាគច្ឆតិ កិន្តុ មយា សហ តស្យ កោបិ សម្ពន្ធោ នាស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","អហំ បិតរិ ប្រេម ករោមិ តថា បិតុ រ្វិធិវត៑ កម៌្មាណិ ករោមីតិ យេន ជគតោ លោកា ជានន្តិ តទត៌្ហម៑ ឧត្តិឞ្ឋត វយំ ស្ថានាទស្មាទ៑ គច្ឆាម។ ");
INSERT INTO sankhm_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","អហំ សត្យទ្រាក្ឞាលតាស្វរូបោ មម បិតា តូទ្យានបរិចារកស្វរូបញ្ច។ ");
INSERT INTO sankhm_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","មម យាសុ ឝាខាសុ ផលានិ ន ភវន្តិ តាះ ស ឆិនត្តិ តថា ផលវត្យះ ឝាខា យថាធិកផលានិ ផលន្តិ តទត៌្ហំ តាះ បរិឞ្ករោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ឥទានីំ មយោក្តោបទេឝេន យូយំ បរិឞ្ក្ឫតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","អតះ ការណាត៑ មយិ តិឞ្ឋត តេនាហមបិ យុឞ្មាសុ តិឞ្ឋាមិ, យតោ ហេតោ រ្ទ្រាក្ឞាលតាយាម៑ អសំលគ្នា ឝាខា យថា ផលវតី ភវិតុំ ន ឝក្នោតិ តថា យូយមបិ មយ្យតិឞ្ឋន្តះ ផលវន្តោ ភវិតុំ ន ឝក្នុថ។ ");
INSERT INTO sankhm_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","អហំ ទ្រាក្ឞាលតាស្វរូបោ យូយញ្ច ឝាខាស្វរូបោះ; យោ ជនោ មយិ តិឞ្ឋតិ យត្រ ចាហំ តិឞ្ឋាមិ, ស ប្រចូរផលៃះ ផលវាន៑ ភវតិ, កិន្តុ មាំ វិនា យូយំ កិមបិ កត៌្តុំ ន ឝក្នុថ។ ");
INSERT INTO sankhm_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","យះ កឝ្ចិន៑ មយិ ន តិឞ្ឋតិ ស ឝុឞ្កឝាខេវ ពហិ រ្និក្ឞិប្យតេ លោកាឝ្ច តា អាហ្ឫត្យ វហ្នៅ និក្ឞិប្យ ទាហយន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","យទិ យូយំ មយិ តិឞ្ឋថ មម កថា ច យុឞ្មាសុ តិឞ្ឋតិ តហ៌ិ យទ៑ វាញ្ឆិត្វា យាចិឞ្យធ្វេ យុឞ្មាកំ តទេវ សផលំ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","យទិ យូយំ ប្រចូរផលវន្តោ ភវថ តហ៌ិ តទ្វារា មម បិតុ រ្មហិមា ប្រកាឝិឞ្យតេ តថា យូយំ មម ឝិឞ្យា ឥតិ បរិក្ឞាយិឞ្យធ្វេ។ ");
INSERT INTO sankhm_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","បិតា យថា មយិ ប្រីតវាន៑ អហមបិ យុឞ្មាសុ តថា ប្រីតវាន៑ អតោ ហេតោ រ្យូយំ និរន្តរំ មម ប្រេមបាត្រាណិ ភូត្វា តិឞ្ឋត។ ");
INSERT INTO sankhm_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","អហំ យថា បិតុរាជ្ញា គ្ឫហីត្វា តស្យ ប្រេមភាជនំ តិឞ្ឋាមិ តថៃវ យូយមបិ យទិ មមាជ្ញា គុហ្លីថ តហ៌ិ មម ប្រេមភាជនានិ ស្ថាស្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","យុឞ្មន្និមិត្តំ មម យ អាហ្លាទះ ស យថា ចិរំ តិឞ្ឋតិ យុឞ្មាកម៑ អានន្ទឝ្ច យថា បូយ៌្យតេ តទត៌្ហំ យុឞ្មភ្យម៑ ឯតាះ កថា អត្រកថម៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","អហំ យុឞ្មាសុ យថា ប្រីយេ យូយមបិ បរស្បរំ តថា ប្រីយធ្វម៑ ឯឞា មមាជ្ញា។ ");
INSERT INTO sankhm_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","មិត្រាណាំ ការណាត៑ ស្វប្រាណទានបយ៌្យន្តំ យត៑ ប្រេម តស្មាន៑ មហាប្រេម កស្យាបិ នាស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","អហំ យទ្យទ៑ អាទិឝាមិ តត្តទេវ យទិ យូយម៑ អាចរត តហ៌ិ យូយមេវ មម មិត្រាណិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","អទ្យារភ្យ យុឞ្មាន៑ ទាសាន៑ ន វទិឞ្យាមិ យត៑ ប្រភុ រ្យត៑ ករោតិ ទាសស្តទ៑ ន ជានាតិ; កិន្តុ បិតុះ សមីបេ យទ្យទ៑ អឝ្ឫណវំ តត៑ សវ៌្វំ យូឞ្មាន៑ អជ្ញាបយម៑ តត្ការណាទ៑ យុឞ្មាន៑ មិត្រាណិ ប្រោក្តវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","យូយំ មាំ រោចិតវន្ត ឥតិ ន, កិន្ត្វហមេវ យុឞ្មាន៑ រោចិតវាន៑ យូយំ គត្វា យថា ផលាន្យុត្បាទយថ តានិ ផលានិ ចាក្ឞយាណិ ភវន្តិ, តទត៌្ហំ យុឞ្មាន៑ ន្យជុនជំ តស្មាន៑ មម នាម ប្រោច្យ បិតរំ យត៑ កិញ្ចិទ៑ យាចិឞ្យធ្វេ តទេវ ស យុឞ្មភ្យំ ទាស្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","យូយំ បរស្បរំ ប្រីយធ្វម៑ អហម៑ ឥត្យាជ្ញាបយាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","ជគតោ លោកៃ រ្យុឞ្មាសុ ឫតីយិតេឞុ តេ បូវ៌្វំ មាមេវាត៌្តីយន្ត ឥតិ យូយំ ជានីថ។ ");
INSERT INTO sankhm_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","យទិ យូយំ ជគតោ លោកា អភវិឞ្យត តហ៌ិ ជគតោ លោកា យុឞ្មាន៑ អាត្មីយាន៑ ពុទ្ធ្វាប្រេឞ្យន្ត; កិន្តុ យូយំ ជគតោ លោកា ន ភវថ, អហំ យុឞ្មាន៑ អស្មាជ្ជគតោៜរោចយម៑ ឯតស្មាត៑ ការណាជ្ជគតោ លោកា យុឞ្មាន៑ ឫតីយន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","ទាសះ ប្រភោ រ្មហាន៑ ន ភវតិ មមៃតត៑ បូវ៌្វីយំ វាក្យំ ស្មរត; តេ យទិ មាមេវាតាឌយន៑ តហ៌ិ យុឞ្មានបិ តាឌយិឞ្យន្តិ, យទិ មម វាក្យំ គ្ឫហ្លន្តិ តហ៌ិ យុឞ្មាកមបិ វាក្យំ គ្រហីឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","កិន្តុ តេ មម នាមការណាទ៑ យុឞ្មាន៑ ប្រតិ តាទ្ឫឝំ វ្យវហរិឞ្យន្តិ យតោ យោ មាំ ប្រេរិតវាន៑ តំ តេ ន ជានន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","តេឞាំ សន្និធិម៑ អាគត្យ យទ្យហំ នាកថយិឞ្យំ តហ៌ិ តេឞាំ បាបំ នាភវិឞ្យត៑ កិន្ត្វធុនា តេឞាំ បាបមាច្ឆាទយិតុម៑ ឧបាយោ នាស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","យោ ជនោ មាម៑ ឫតីយតេ ស មម បិតរមបិ ឫតីយតេ។ ");
INSERT INTO sankhm_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","យាទ្ឫឝានិ កម៌្មាណិ កេនាបិ កទាបិ នាក្រិយន្ត តាទ្ឫឝានិ កម៌្មាណិ យទិ តេឞាំ សាក្ឞាទ៑ អហំ នាករិឞ្យំ តហ៌ិ តេឞាំ បាបំ នាភវិឞ្យត៑ កិន្ត្វធុនា តេ ទ្ឫឞ្ដ្វាបិ មាំ មម បិតរញ្ចាត៌្តីយន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","តស្មាត៑ តេៜការណំ មាម៑ ឫតីយន្តេ យទេតទ៑ វចនំ តេឞាំ ឝាស្ត្រេ លិខិតមាស្តេ តត៑ សផលម៑ អភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","កិន្តុ បិតុ រ្និគ៌តំ យំ សហាយមត៌្ហាត៑ សត្យមយម៑ អាត្មានំ បិតុះ សមីបាទ៑ យុឞ្មាកំ សមីបេ ប្រេឞយិឞ្យាមិ ស អាគត្យ មយិ ប្រមាណំ ទាស្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","យូយំ ប្រថមមារភ្យ មយា សាទ៌្ធំ តិឞ្ឋថ តស្មាទ្ធេតោ រ្យូយមបិ ប្រមាណំ ទាស្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","យុឞ្មាកំ យថា វាធា ន ជាយតេ តទត៌្ហំ យុឞ្មាន៑ ឯតានិ សវ៌្វវាក្យានិ វ្យាហរំ។ ");
INSERT INTO sankhm_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","លោកា យុឞ្មាន៑ ភជនគ្ឫហេភ្យោ ទូរីករិឞ្យន្តិ តថា យស្មិន៑ សមយេ យុឞ្មាន៑ ហត្វា ឦឝ្វរស្យ តុឞ្ដិ ជនកំ កម៌្មាកុម៌្ម ឥតិ មំស្យន្តេ ស សមយ អាគច្ឆន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","តេ បិតរំ មាញ្ច ន ជានន្តិ, តស្មាទ៑ យុឞ្មាន៑ ប្រតីទ្ឫឝម៑ អាចរិឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","អតោ ហេតាះ សមយេ សមុបស្ថិតេ យថា មម កថា យុឞ្មាកំ មនះសុះ សមុបតិឞ្ឋតិ តទត៌្ហំ យុឞ្មាភ្យម៑ ឯតាំ កថាំ កថយាមិ យុឞ្មាភិះ សាទ៌្ធម៑ អហំ តិឞ្ឋន៑ ប្រថមំ តាំ យុឞ្មភ្យំ នាកថយំ។ ");
INSERT INTO sankhm_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","សាម្ប្រតំ ស្វស្យ ប្រេរយិតុះ សមីបំ គច្ឆាមិ តថាបិ ត្វំ ក្ក គច្ឆសិ កថាមេតាំ យុឞ្មាកំ កោបិ មាំ ន ប្ឫច្ឆតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","កិន្តុ មយោក្តាភិរាភិះ កថាភិ រ្យូឞ្មាកម៑ អន្តះករណានិ ទុះខេន បូណ៌ាន្យភវន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","តថាប្យហំ យថាត៌្ហំ កថយាមិ មម គមនំ យុឞ្មាកំ ហិតាត៌្ហមេវ, យតោ ហេតោ រ្គមនេ ន ក្ឫតេ សហាយោ យុឞ្មាកំ សមីបំ នាគមិឞ្យតិ កិន្តុ យទិ គច្ឆាមិ តហ៌ិ យុឞ្មាកំ សមីបេ តំ ប្រេឞយិឞ្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","តតះ ស អាគត្យ បាបបុណ្យទណ្ឌេឞុ ជគតោ លោកានាំ ប្រពោធំ ជនយិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","តេ មយិ ន វិឝ្វសន្តិ តស្មាទ្ធេតោះ បាបប្រពោធំ ជនយិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","យុឞ្មាកម៑ អទ្ឫឝ្យះ សន្នហំ បិតុះ សមីបំ គច្ឆាមិ តស្មាទ៑ បុណ្យេ ប្រពោធំ ជនយិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ឯតជ្ជគតោៜធិបតិ រ្ទណ្ឌាជ្ញាំ ប្រាប្នោតិ តស្មាទ៑ ទណ្ឌេ ប្រពោធំ ជនយិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","យុឞ្មភ្យំ កថយិតុំ មមានេកាះ កថា អាសតេ, តាះ កថា ឥទានីំ យូយំ សោឍុំ ន ឝក្នុថ; ");
INSERT INTO sankhm_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","កិន្តុ សត្យមយ អាត្មា យទា សមាគមិឞ្យតិ តទា សវ៌្វំ សត្យំ យុឞ្មាន៑ នេឞ្យតិ, ស ស្វតះ កិមបិ ន វទិឞ្យតិ កិន្តុ យច្ឆ្រោឞ្យតិ តទេវ កថយិត្វា ភាវិកាយ៌្យំ យុឞ្មាន៑ ជ្ញាបយិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","មម មហិមានំ ប្រកាឝយិឞ្យតិ យតោ មទីយាំ កថាំ គ្ឫហីត្វា យុឞ្មាន៑ ពោធយិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","បិតុ រ្យទ្យទ៑ អាស្តេ តត៑ សវ៌្វំ មម តស្មាទ៑ ការណាទ៑ អវាទិឞំ ស មទីយាំ កថាំ គ្ឫហីត្វា យុឞ្មាន៑ ពោធយិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","កិយត្កាលាត៑ បរំ យូយំ មាំ ទ្រឞ្ដុំ ន លប្ស្យធ្វេ កិន្តុ កិយត្កាលាត៑ បរំ បុន រ្ទ្រឞ្ដុំ លប្ស្យធ្វេ យតោហំ បិតុះ សមីបំ គច្ឆាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","តតះ ឝិឞ្យាណាំ កិយន្តោ ជនាះ បរស្បរំ វទិតុម៑ អារភន្ត, កិយត្កាលាត៑ បរំ មាំ ទ្រឞ្ដុំ ន លប្ស្យធ្វេ កិន្តុ កិយត្កាលាត៑ បរំ បុន រ្ទ្រឞ្ដុំ លប្ស្យធ្វេ យតោហំ បិតុះ សមីបំ គច្ឆាមិ, ឥតិ យទ៑ វាក្យម៑ អយំ វទតិ តត៑ កិំ? ");
INSERT INTO sankhm_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","តតះ កិយត្កាលាត៑ បរម៑ ឥតិ តស្យ វាក្យំ កិំ? តស្យ វាក្យស្យាភិប្រាយំ វយំ ពោទ្ធុំ ន ឝក្នុមស្តៃរិតិ ");
INSERT INTO sankhm_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","និគទិតេ យីឝុស្តេឞាំ ប្រឝ្នេច្ឆាំ ជ្ញាត្វា តេភ្យោៜកថយត៑ កិយត្កាលាត៑ បរំ មាំ ទ្រឞ្ដុំ ន លប្ស្យធ្វេ, កិន្តុ កិយត្កាលាត៑ បរំ បូន រ្ទ្រឞ្ដុំ លប្ស្យធ្វេ, យាមិមាំ កថាមកថយំ តស្យា អភិប្រាយំ កិំ យូយំ បរស្បរំ ម្ឫគយធ្វេ? ");
INSERT INTO sankhm_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","យុឞ្មានហម៑ អតិយថាត៌្ហំ វទាមិ យូយំ ក្រន្ទិឞ្យថ វិលបិឞ្យថ ច, កិន្តុ ជគតោ លោកា អានន្ទិឞ្យន្តិ; យូយំ ឝោកាកុលា ភវិឞ្យថ កិន្តុ ឝោកាត៑ បរំ អានន្ទយុក្តា ភវិឞ្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","ប្រសវកាល ឧបស្ថិតេ នារី យថា ប្រសវវេទនយា វ្យាកុលា ភវតិ កិន្តុ បុត្រេ ភូមិឞ្ឋេ សតិ មនុឞ្យៃកោ ជន្មនា នរលោកេ ប្រវិឞ្ដ ឥត្យានន្ទាត៑ តស្យាស្តត្សវ៌្វំ ទុះខំ មនសិ ន តិឞ្ឋតិ, ");
INSERT INTO sankhm_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","តថា យូយមបិ សាម្ប្រតំ ឝោកាកុលា ភវថ កិន្តុ បុនរបិ យុឞ្មភ្យំ ទឝ៌នំ ទាស្យាមិ តេន យុឞ្មាកម៑ អន្តះករណានិ សានន្ទានិ ភវិឞ្យន្តិ, យុឞ្មាកំ តម៑ អានន្ទញ្ច កោបិ ហត៌្តុំ ន ឝក្ឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","តស្មិន៑ ទិវសេ កាមបិ កថាំ មាំ ន ប្រក្ឞ្យថ។ យុឞ្មានហម៑ អតិយថាត៌្ហំ វទាមិ, មម នាម្នា យត៑ កិញ្ចិទ៑ បិតរំ យាចិឞ្យធ្វេ តទេវ ស ទាស្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","បូវ៌្វេ មម នាម្នា កិមបិ នាយាចធ្វំ, យាចធ្វំ តតះ ប្រាប្ស្យថ តស្មាទ៑ យុឞ្មាកំ សម្បូណ៌ានន្ទោ ជនិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","ឧបមាកថាភិះ សវ៌្វាណ្យេតានិ យុឞ្មាន៑ ជ្ញាបិតវាន៑ កិន្តុ យស្មិន៑ សមយេ ឧបមយា នោក្ត្វា បិតុះ កថាំ ស្បឞ្ដំ ជ្ញាបយិឞ្យាមិ សមយ ឯតាទ្ឫឝ អាគច្ឆតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","តទា មម នាម្នា ប្រាត៌្ហយិឞ្យធ្វេ ៜហំ យុឞ្មន្និមិត្តំ បិតរំ វិនេឞ្យេ កថាមិមាំ ន វទាមិ; ");
INSERT INTO sankhm_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","យតោ យូយំ មយិ ប្រេម កុរុថ, តថាហម៑ ឦឝ្វរស្យ សមីបាទ៑ អាគតវាន៑ ឥត្យបិ ប្រតីថ, តស្មាទ៑ ការណាត៑ ការណាត៑ បិតា ស្វយំ យុឞ្មាសុ ប្រីយតេ។ ");
INSERT INTO sankhm_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","បិតុះ សមីបាជ្ជជទ៑ អាគតោស្មិ ជគត៑ បរិត្យជ្យ ច បុនរបិ បិតុះ សមីបំ គច្ឆាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","តទា ឝិឞ្យា អវទន៑, ហេ ប្រភោ ភវាន៑ ឧបមយា នោក្ត្វាធុនា ស្បឞ្ដំ វទតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ភវាន៑ សវ៌្វជ្ញះ កេនចិត៑ ប្ឫឞ្ដោ ភវិតុមបិ ភវតះ ប្រយោជនំ នាស្តីត្យធុនាស្មាកំ ស្ថិរជ្ញានំ ជាតំ តស្មាទ៑ ភវាន៑ ឦឝ្វរស្យ សមីបាទ៑ អាគតវាន៑ ឥត្យត្រ វយំ វិឝ្វសិមះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","តតោ យីឝុះ ប្រត្យវាទីទ៑ ឥទានីំ កិំ យូយំ វិឝ្វសិថ? ");
INSERT INTO sankhm_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","បឝ្យត សវ៌្វេ យូយំ វិកីណ៌ាះ សន្តោ មាម៑ ឯកាកិនំ បីរត្យជ្យ ស្វំ ស្វំ ស្ថានំ គមិឞ្យថ, ឯតាទ្ឫឝះ សមយ អាគច្ឆតិ វរំ ប្រាយេណោបស្ថិតវាន៑; តថាប្យហំ នៃកាកី ភវាមិ យតះ បិតា មយា សាទ៌្ធម៑ អាស្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","យថា មយា យុឞ្មាកំ ឝាន្តិ រ្ជាយតេ តទត៌្ហម៑ ឯតាះ កថា យុឞ្មភ្យម៑ អចកថំ; អស្មិន៑ ជគតិ យុឞ្មាកំ ក្លេឝោ ឃដិឞ្យតេ កិន្ត្វក្ឞោភា ភវត យតោ មយា ជគជ្ជិតំ។ ");
INSERT INTO sankhm_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","តតះ បរំ យីឝុរេតាះ កថាះ កថយិត្វា ស្វគ៌ំ វិលោក្យៃតត៑ ប្រាត៌្ហយត៑, ហេ បិតះ សមយ ឧបស្ថិតវាន៑; យថា តវ បុត្រស្តវ មហិមានំ ប្រកាឝយតិ តទត៌្ហំ ត្វំ និជបុត្រស្យ មហិមានំ ប្រកាឝយ។ ");
INSERT INTO sankhm_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ត្វំ យោល្លោកាន៑ តស្យ ហស្តេ សមប៌ិតវាន៑ ស យថា តេភ្យោៜនន្តាយុ រ្ទទាតិ តទត៌្ហំ ត្វំ ប្រាណិមាត្រាណាម៑ អធិបតិត្វភារំ តស្មៃ ទត្តវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","យស្ត្វម៑ អទ្វិតីយះ សត្យ ឦឝ្វរស្ត្វយា ប្រេរិតឝ្ច យីឝុះ ខ្រីឞ្ដ ឯតយោរុភយោះ បរិចយេ ប្រាប្តេៜនន្តាយុ រ្ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ត្វំ យស្យ កម៌្មណោ ភារំ មហ្យំ ទត្តវាន៑, តត៑ សម្បន្នំ ក្ឫត្វា ជគត្យស្មិន៑ តវ មហិមានំ ប្រាកាឝយំ។ ");
INSERT INTO sankhm_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","អតឯវ ហេ បិត រ្ជគត្យវិទ្យមានេ ត្វយា សហ តិឞ្ឋតោ មម យោ មហិមាសីត៑ សម្ប្រតិ តវ សមីបេ មាំ តំ មហិមានំ ប្រាបយ។ ");
INSERT INTO sankhm_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","អន្យច្ច ត្វម៑ ឯតជ្ជគតោ យាល្លោកាន៑ មហ្យម៑ អទទា អហំ តេភ្យស្តវ នាម្នស្តត្ត្វជ្ញានម៑ អទទាំ, តេ តវៃវាសន៑, ត្វំ តាន៑ មហ្យមទទាះ, តស្មាត្តេ តវោបទេឝម៑ អគ្ឫហ្លន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ត្វំ មហ្យំ យត៑ កិញ្ចិទ៑ អទទាស្តត្សវ៌្វំ ត្វត្តោ ជាយតេ ឥត្យធុនាជានន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","មហ្យំ យមុបទេឝម៑ អទទា អហមបិ តេភ្យស្តមុបទេឝម៑ អទទាំ តេបិ តមគ្ឫហ្លន៑ ត្វត្តោហំ និគ៌ត្យ ត្វយា ប្រេរិតោភវម៑ អត្រ ច វ្យឝ្វសន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","តេឞាមេវ និមិត្តំ ប្រាត៌្ហយេៜហំ ជគតោ លោកនិមិត្តំ ន ប្រាត៌្ហយេ កិន្តុ យាល្លោកាន៑ មហ្យម៑ អទទាស្តេឞាមេវ និមិត្តំ ប្រាត៌្ហយេៜហំ យតស្តេ តវៃវាសតេ។ ");
INSERT INTO sankhm_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","យេ មម តេ តវ យេ ច តវ តេ មម តថា តៃ រ្មម មហិមា ប្រកាឝ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","សាម្ប្រតម៑ អស្មិន៑ ជគតិ មមាវស្ថិតេះ ឝេឞម៑ អភវត៑ អហំ តវ សមីបំ គច្ឆាមិ កិន្តុ តេ ជគតិ ស្ថាស្យន្តិ; ហេ បវិត្រ បិតរាវយោ រ្យថៃកត្វមាស្តេ តថា តេឞាមប្យេកត្វំ ភវតិ តទត៌្ហំ យាល្លោកាន៑ មហ្យម៑ អទទាស្តាន៑ ស្វនាម្នា រក្ឞ។ ");
INSERT INTO sankhm_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","យាវន្តិ ទិនានិ ជគត្យស្មិន៑ តៃះ សហាហមាសំ តាវន្តិ ទិនានិ តាន៑ តវ នាម្នាហំ រក្ឞិតវាន៑; យាល្លោកាន៑ មហ្យម៑ អទទាស្តាន៑ សវ៌្វាន៑ អហមរក្ឞំ, តេឞាំ មធ្យេ កេវលំ វិនាឝបាត្រំ ហារិតំ តេន ធម៌្មបុស្តកស្យ វចនំ ប្រត្យក្ឞំ ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","កិន្ត្វធុនា តវ សន្និធិំ គច្ឆាមិ មយា យថា តេឞាំ សម្បូណ៌ានន្ទោ ភវតិ តទត៌្ហមហំ ជគតិ តិឞ្ឋន៑ ឯតាះ កថា អកថយម៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","តវោបទេឝំ តេភ្យោៜទទាំ ជគតា សហ យថា មម សម្ពន្ធោ នាស្តិ តថា ជជតា សហ តេឞាមបិ សម្ពន្ធាភាវាជ៑ ជគតោ លោកាស្តាន៑ ឫតីយន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ត្វំ ជគតស្តាន៑ គ្ឫហាណេតិ ន ប្រាត៌្ហយេ កិន្ត្វឝុភាទ៑ រក្ឞេតិ ប្រាត៌្ហយេហម៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","អហំ យថា ជគត្សម្ពន្ធីយោ ន ភវាមិ តថា តេបិ ជគត្សម្ពន្ធីយា ន ភវន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","តវ សត្យកថយា តាន៑ បវិត្រីកុរុ តវ វាក្យមេវ សត្យំ។ ");
INSERT INTO sankhm_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ត្វំ យថា មាំ ជគតិ ប្រៃរយស្តថាហមបិ តាន៑ ជគតិ ប្រៃរយំ។ ");
INSERT INTO sankhm_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","តេឞាំ ហិតាត៌្ហំ យថាហំ ស្វំ បវិត្រីករោមិ តថា សត្យកថយា តេបិ បវិត្រីភវន្តុ។ ");
INSERT INTO sankhm_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","កេវលំ ឯតេឞាមត៌្ហេ ប្រាត៌្ហយេៜហម៑ ឥតិ ន កិន្ត្វេតេឞាមុបទេឝេន យេ ជនា មយិ វិឝ្វសិឞ្យន្តិ តេឞាមប្យត៌្ហេ ប្រាត៌្ហេយេៜហម៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ហេ បិតស្តេឞាំ សវ៌្វេឞាម៑ ឯកត្វំ ភវតុ តវ យថា មយិ មម ច យថា ត្វយ្យេកត្វំ តថា តេឞាមប្យាវយោរេកត្វំ ភវតុ តេន ត្វំ មាំ ប្រេរិតវាន៑ ឥតិ ជគតោ លោកាះ ប្រតិយន្តុ។ ");
INSERT INTO sankhm_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","យថាវយោរេកត្វំ តថា តេឞាមប្យេកត្វំ ភវតុ តេឞ្វហំ មយិ ច ត្វម៑ ឥត្ថំ តេឞាំ សម្បូណ៌មេកត្វំ ភវតុ, ត្វំ ប្រេរិតវាន៑ ត្វំ មយិ យថា ប្រីយសេ ច តថា តេឞ្វបិ ប្រីតវាន៑ ឯតទ្យថា ជគតោ លោកា ជានន្តិ ");
INSERT INTO sankhm_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","តទត៌្ហំ ត្វំ យំ មហិមានំ មហ្យម៑ អទទាស្តំ មហិមានម៑ អហមបិ តេភ្យោ ទត្តវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","ហេ បិត រ្ជគតោ និម៌្មាណាត៑ បូវ៌្វំ មយិ ស្នេហំ ក្ឫត្វា យំ មហិមានំ ទត្តវាន៑ មម តំ មហិមានំ យថា តេ បឝ្យន្តិ តទត៌្ហំ យាល្លោកាន៑ មហ្យំ ទត្តវាន៑ អហំ យត្រ តិឞ្ឋាមិ តេបិ យថា តត្រ តិឞ្ឋន្តិ មមៃឞា វាញ្ឆា។ ");
INSERT INTO sankhm_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ហេ យថាត៌្ហិក បិត រ្ជគតោ លោកៃស្ត្វយ្យជ្ញាតេបិ ត្វាមហំ ជានេ ត្វំ មាំ ប្រេរិតវាន៑ ឥតីមេ ឝិឞ្យា ជានន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","យថាហំ តេឞុ តិឞ្ឋាមិ តថា មយិ យេន ប្រេម្នា ប្រេមាករោស្តត៑ តេឞុ តិឞ្ឋតិ តទត៌្ហំ តវ នាមាហំ តាន៑ ជ្ញាបិតវាន៑ បុនរបិ ជ្ញាបយិឞ្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","តាះ កថាះ កថយិត្វា យីឝុះ ឝិឞ្យានាទាយ កិទ្រោន្នាមកំ ស្រោត ឧត្តីយ៌្យ ឝិឞ្យៃះ សហ តត្រត្យោទ្យានំ ប្រាវិឝត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","កិន្តុ វិឝ្វាសឃាតិយិហូទាស្តត៑ ស្ថានំ បរិចីយតេ យតោ យីឝុះ ឝិឞ្យៃះ សាទ៌្ធំ កទាចិត៑ តត៑ ស្ថានម៑ អគច្ឆត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","តទា ស យិហូទាះ សៃន្យគណំ ប្រធានយាជកានាំ ផិរូឝិនាញ្ច បទាតិគណញ្ច គ្ឫហីត្វា ប្រទីបាន៑ ឧល្កាន៑ អស្ត្រាណិ ចាទាយ តស្មិន៑ ស្ថាន ឧបស្ថិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","ស្វំ ប្រតិ យទ៑ ឃដិឞ្យតេ តជ៑ ជ្ញាត្វា យីឝុរគ្រេសរះ សន៑ តានប្ឫច្ឆត៑ កំ គវេឞយថ? ");
INSERT INTO sankhm_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","តេ ប្រត្យវទន៑, នាសរតីយំ យីឝុំ; តតោ យីឝុរវាទីទ៑ អហមេវ សះ; តៃះ សហ វិឝ្វាសឃាតី យិហូទាឝ្ចាតិឞ្ឋត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","តទាហមេវ ស តស្យៃតាំ កថាំ ឝ្រុត្វៃវ តេ បឝ្ចាទេត្យ ភូមៅ បតិតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","តតោ យីឝុះ បុនរបិ ប្ឫឞ្ឋវាន៑ កំ គវេឞយថ? តតស្តេ ប្រត្យវទន៑ នាសរតីយំ យីឝុំ។ ");
INSERT INTO sankhm_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","តទា យីឝុះ ប្រត្យុទិតវាន៑ អហមេវ ស ឥមាំ កថាមចកថម៑; យទិ មាមន្វិច្ឆថ តហ៌ីមាន៑ គន្តុំ មា វារយត។ ");
INSERT INTO sankhm_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ឥត្ថំ ភូតេ មហ្យំ យាល្លោកាន៑ អទទាស្តេឞាម៑ ឯកមបិ នាហារយម៑ ឥមាំ យាំ កថាំ ស ស្វយមកថយត៑ សា កថា សផលា ជាតា។ ");
INSERT INTO sankhm_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","តទា ឝិមោន្បិតរស្យ និកដេ ខង្គល្ស្ថិតេះ ស តំ និឞ្កោឞំ ក្ឫត្វា មហាយាជកស្យ មាល្ខនាមានំ ទាសម៑ អាហត្យ តស្យ ទក្ឞិណកណ៌ំ ឆិន្នវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","តតោ យីឝុះ បិតរម៑ អវទត៑, ខង្គំ កោឞេ ស្ថាបយ មម បិតា មហ្យំ បាតុំ យំ កំសម៑ អទទាត៑ តេនាហំ កិំ ន បាស្យាមិ? ");
INSERT INTO sankhm_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","តទា សៃន្យគណះ សេនាបតិ រ្យិហូទីយានាំ បទាតយឝ្ច យីឝុំ ឃ្ឫត្វា ពទ្ធ្វា ហានន្នាម្នះ កិយផាះ ឝ្វឝុរស្យ សមីបំ ប្រថមម៑ អនយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ស កិយផាស្តស្មិន៑ វត្សរេ មហាយាជត្វបទេ និយុក្តះ ");
INSERT INTO sankhm_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","សន៑ សាធារណលោកានាំ មង្គលាត៌្ហម៑ ឯកជនស្យ មរណមុចិតម៑ ឥតិ យិហូទីយៃះ សាទ៌្ធម៑ អមន្ត្រយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","តទា ឝិមោន្បិតរោៜន្យៃកឝិឞ្យឝ្ច យីឝោះ បឝ្ចាទ៑ អគច្ឆតាំ តស្យាន្យឝិឞ្យស្យ មហាយាជកេន បរិចិតត្វាត៑ ស យីឝុនា សហ មហាយាជកស្យាដ្ដាលិកាំ ប្រាវិឝត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","កិន្តុ បិតរោ ពហិទ៌្វារស្យ សមីបេៜតិឞ្ឋទ៑ អតឯវ មហាយាជកេន បរិចិតះ ស ឝិឞ្យះ បុនព៌ហិគ៌ត្វា ទៅវាយិកាយៃ កថយិត្វា បិតរម៑ អភ្យន្តរម៑ អានយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","តទា ស ទ្វាររក្ឞិកា បិតរម៑ អវទត៑ ត្វំ កិំ ន តស្យ មានវស្យ ឝិឞ្យះ? តតះ សោវទទ៑ អហំ ន ភវាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","តតះ បរំ យត្ស្ថានេ ទាសាះ បទាតយឝ្ច ឝីតហេតោរង្គារៃ រ្វហ្និំ ប្រជ្វាល្យ តាបំ សេវិតវន្តស្តត្ស្ថានេ បិតរស្តិឞ្ឋន៑ តៃះ សហ វហ្និតាបំ សេវិតុម៑ អារភត។ ");
INSERT INTO sankhm_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","តទា ឝិឞ្យេឞូបទេឝេ ច មហាយាជកេន យីឝុះ ប្ឫឞ្ដះ ");
INSERT INTO sankhm_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","សន៑ ប្រត្យុក្តវាន៑ សវ៌្វលោកានាំ សមក្ឞំ កថាមកថយំ គុប្តំ កាមបិ កថាំ ន កថយិត្វា យត៑ ស្ថានំ យិហូទីយាះ សតតំ គច្ឆន្តិ តត្រ ភជនគេហេ មន្ទិរេ ចាឝិក្ឞយំ។ ");
INSERT INTO sankhm_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","មត្តះ កុតះ ប្ឫច្ឆសិ? យេ ជនា មទុបទេឝម៑ អឝ្ឫណ្វន៑ តានេវ ប្ឫច្ឆ យទ្យទ៑ អវទំ តេ តត៑ ជានិន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","តទេត្ថំ ប្រត្យុទិតត្វាត៑ និកដស្ថបទាតិ រ្យីឝុំ ចបេដេនាហត្យ វ្យាហរត៑ មហាយាជកម៑ ឯវំ ប្រតិវទសិ? ");
INSERT INTO sankhm_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","តតោ យីឝុះ ប្រតិគទិតវាន៑ យទ្យយថាត៌្ហម៑ អចកថំ តហ៌ិ តស្យាយថាត៌្ហស្យ ប្រមាណំ ទេហិ, កិន្តុ យទិ យថាត៌្ហំ តហ៌ិ កុតោ ហេតោ រ្មាម៑ អតាឌយះ? ");
INSERT INTO sankhm_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","បូវ៌្វំ ហានន៑ សពន្ធនំ តំ កិយផាមហាយាជកស្យ សមីបំ ប្រៃឞយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ឝិមោន្បិតរស្តិឞ្ឋន៑ វហ្និតាបំ សេវតេ, ឯតស្មិន៑ សមយេ កិយន្តស្តម៑ អប្ឫច្ឆន៑ ត្វំ កិម៑ ឯតស្យ ជនស្យ ឝិឞ្យោ ន? តតះ សោបហ្នុត្យាព្រវីទ៑ អហំ ន ភវាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","តទា មហាយាជកស្យ យស្យ ទាសស្យ បិតរះ កណ៌មច្ឆិនត៑ តស្យ កុដុម្ពះ ប្រត្យុទិតវាន៑ ឧទ្យានេ តេន សហ តិឞ្ឋន្តំ ត្វាំ កិំ នាបឝ្យំ? ");
INSERT INTO sankhm_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","កិន្តុ បិតរះ បុនរបហ្នុត្យ កថិតវាន៑; តទានីំ កុក្កុដោៜរៅត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","តទនន្តរំ ប្រត្យូឞេ តេ កិយផាគ្ឫហាទ៑ អធិបតេ រ្គ្ឫហំ យីឝុម៑ អនយន៑ កិន្តុ យស្មិន៑ អឝុចិត្វេ ជាតេ តៃ រ្និស្តារោត្សវេ ន ភោក្តវ្យំ, តស្យ ភយាទ៑ យិហូទីយាស្តទ្គ្ឫហំ នាវិឝន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","អបរំ បីលាតោ ពហិរាគត្យ តាន៑ ប្ឫឞ្ឋវាន៑ ឯតស្យ មនុឞ្យស្យ កំ ទោឞំ វទថ? ");
INSERT INTO sankhm_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","តទា តេ បេត្យវទន៑ ទុឞ្កម៌្មការិណិ ន សតិ ភវតះ សមីបេ នៃនំ សមាប៌យិឞ្យាមះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","តតះ បីលាតោៜវទទ៑ យូយមេនំ គ្ឫហីត្វា ស្វេឞាំ វ្យវស្ថយា វិចារយត។ តទា យិហូទីយាះ ប្រត្យវទន៑ កស្យាបិ មនុឞ្យស្យ ប្រាណទណ្ឌំ កត៌្តុំ នាស្មាកម៑ អធិការោៜស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ឯវំ សតិ យីឝុះ ស្វស្យ ម្ឫត្យៅ យាំ កថាំ កថិតវាន៑ សា សផលាភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","តទនន្តរំ បីលាតះ បុនរបិ តទ៑ រាជគ្ឫហំ គត្វា យីឝុមាហូយ ប្ឫឞ្ដវាន៑ ត្វំ កិំ យិហូទីយានាំ រាជា? ");
INSERT INTO sankhm_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","យីឝុះ ប្រត្យវទត៑ ត្វម៑ ឯតាំ កថាំ ស្វតះ កថយសិ កិមន្យះ កឝ្ចិន៑ មយិ កថិតវាន៑? ");
INSERT INTO sankhm_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","បីលាតោៜវទទ៑ អហំ កិំ យិហូទីយះ? តវ ស្វទេឝីយា វិឝេឞតះ ប្រធានយាជកា មម និកដេ ត្វាំ សមាប៌យន, ត្វំ កិំ ក្ឫតវាន៑? ");
INSERT INTO sankhm_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","យីឝុះ ប្រត្យវទត៑ មម រាជ្យម៑ ឯតជ្ជគត្សម្ពន្ធីយំ ន ភវតិ យទិ មម រាជ្យំ ជគត្សម្ពន្ធីយម៑ អភវិឞ្យត៑ តហ៌ិ យិហូទីយានាំ ហស្តេឞុ យថា សមប៌ិតោ នាភវំ តទត៌្ហំ មម សេវកា អយោត្ស្យន៑ កិន្តុ មម រាជ្យម៑ ឰហិកំ ន។ ");
INSERT INTO sankhm_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","តទា បីលាតះ កថិតវាន៑, តហ៌ិ ត្វំ រាជា ភវសិ? យីឝុះ ប្រត្យុក្តវាន៑ ត្វំ សត្យំ កថយសិ, រាជាហំ ភវាមិ; សត្យតាយាំ សាក្ឞ្យំ ទាតុំ ជនិំ គ្ឫហីត្វា ជគត្យស្មិន៑ អវតីណ៌វាន៑, តស្មាត៑ សត្យធម៌្មបក្ឞបាតិនោ មម កថាំ ឝ្ឫណ្វន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","តទា សត្យំ កិំ? ឯតាំ កថាំ បឞ្ដ្វា បីលាតះ បុនរបិ ពហិគ៌ត្វា យិហូទីយាន៑ អភាឞត, អហំ តស្យ កមប្យបរាធំ ន ប្រាប្នោមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","និស្តារោត្សវសមយេ យុឞ្មាភិរភិរុចិត ឯកោ ជនោ មយា មោចយិតវ្យ ឯឞា យុឞ្មាកំ រីតិរស្តិ, អតឯវ យុឞ្មាកំ និកដេ យិហូទីយានាំ រាជានំ កិំ មោចយាមិ, យុឞ្មាកម៑ ឥច្ឆា កា? ");
INSERT INTO sankhm_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","តទា តេ សវ៌្វេ រុវន្តោ វ្យាហរន៑ ឯនំ មានុឞំ នហិ ពរព្ពាំ មោចយ។ កិន្តុ ស ពរព្ពា ទស្យុរាសីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","បីលាតោ យីឝុម៑ អានីយ កឝយា ប្រាហារយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","បឝ្ចាត៑ សេនាគណះ កណ្ដកនិម៌្មិតំ មុកុដំ តស្យ មស្តកេ សមប៌្យ វាត៌្តាកីវណ៌ំ រាជបរិច្ឆទំ បរិធាប្យ, ");
INSERT INTO sankhm_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ហេ យិហូទីយានាំ រាជន៑ នមស្ការ ឥត្យុក្ត្វា តំ ចបេដេនាហន្តុម៑ អារភត។ ");
INSERT INTO sankhm_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","តទា បីលាតះ បុនរបិ ពហិគ៌ត្វា លោកាន៑ អវទត៑, អស្យ កមប្យបរាធំ ន លភេៜហំ, បឝ្យត តទ៑ យុឞ្មាន៑ ជ្ញាបយិតុំ យុឞ្មាកំ សន្និធៅ ពហិរេនម៑ អានយាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","តតះ បរំ យីឝុះ កណ្ដកមុកុដវាន៑ វាត៌្តាកីវណ៌វសនវាំឝ្ច ពហិរាគច្ឆត៑។ តតះ បីលាត ឧក្តវាន៑ ឯនំ មនុឞ្យំ បឝ្យត។ ");
INSERT INTO sankhm_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","តទា ប្រធានយាជកាះ បទាតយឝ្ច តំ ទ្ឫឞ្ដ្វា, ឯនំ ក្រុឝេ វិធ, ឯនំ ក្រុឝេ វិធ, ឥត្យុក្ត្វា រវិតុំ អារភន្ត។ តតះ បីលាតះ កថិតវាន៑ យូយំ ស្វយម៑ ឯនំ នីត្វា ក្រុឝេ វិធត, អហម៑ ឯតស្យ កមប្យបរាធំ ន ប្រាប្តវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","យិហូទីយាះ ប្រត្យវទន៑ អស្មាកំ យា វ្យវស្ថាស្តេ តទនុសារេណាស្យ ប្រាណហននម៑ ឧចិតំ យតោយំ ស្វម៑ ឦឝ្វរស្យ បុត្រមវទត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","បីលាត ឥមាំ កថាំ ឝ្រុត្វា មហាត្រាសយុក្តះ ");
INSERT INTO sankhm_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","សន៑ បុនរបិ រាជគ្ឫហ អាគត្យ យីឝុំ ប្ឫឞ្ដវាន៑ ត្វំ កុត្រត្យោ លោកះ? កិន្តុ យីឝស្តស្យ កិមបិ ប្រត្យុត្តរំ នាវទត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","១× តតះ បីលាត៑ កថិតវាន ត្វំ កិំ មយា សាទ៌្ធំ ន សំលបិឞ្យសិ ? ត្វាំ ក្រុឝេ វេធិតុំ វា មោចយិតុំ ឝក្តិ រ្មមាស្តេ ឥតិ កិំ ត្វំ ន ជានាសិ ? តទា យីឝុះ ប្រត្យវទទ៑ ឦឝ្វរេណាទŸाំ មមោបរិ តវ កិមប្យធិបតិត្វំ ន វិទ្យតេ, តថាបិ យោ ជនោ មាំ តវ ហស្តេ សមាប៌យត៑ តស្យ មហាបាតកំ ជាតម៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","តទា យីឝុះ ប្រត្យវទទ៑ ឦឝ្វរេណាទត្តំ មមោបរិ តវ កិមប្យធិបតិត្វំ ន វិទ្យតេ, តថាបិ យោ ជនោ មាំ តវ ហស្តេ សមាប៌យត៑ តស្យ មហាបាតកំ ជាតម៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","តទារភ្យ បីលាតស្តំ មោចយិតុំ ចេឞ្ដិតវាន៑ កិន្តុ យិហូទីយា រុវន្តោ វ្យាហរន៑ យទីមំ មានវំ ត្យជសិ តហ៌ិ ត្វំ កៃសរស្យ មិត្រំ ន ភវសិ, យោ ជនះ ស្វំ រាជានំ វក្តិ សឯវ កៃមរស្យ វិរុទ្ធាំ កថាំ កថយតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ឯតាំ កថាំ ឝ្រុត្វា បីលាតោ យីឝុំ ពហិរានីយ និស្តារោត្សវស្យ អាសាទនទិនស្យ ទ្វិតីយប្រហរាត៑ បូវ៌្វំ ប្រស្តរពន្ធននាម្និ ស្ថានេ ៜរ្ថាត៑ ឥព្រីយភាឞយា យទ៑ គព្ពិថា កថ្យតេ តស្មិន៑ ស្ថានេ វិចារាសន ឧបាវិឝត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","អនន្តរំ បីលាតោ យិហូទីយាន៑ អវទត៑, យុឞ្មាកំ រាជានំ បឝ្យត។ ");
INSERT INTO sankhm_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","កិន្តុ ឯនំ ទូរីកុរុ, ឯនំ ទូរីកុរុ, ឯនំ ក្រុឝេ វិធ, ឥតិ កថាំ កថយិត្វា តេ រវិតុម៑ អារភន្ត; តទា បីលាតះ កថិតវាន៑ យុឞ្មាកំ រាជានំ កិំ ក្រុឝេ វេធិឞ្យាមិ? ប្រធានយាជកា ឧត្តរម៑ អវទន៑ កៃសរំ វិនា កោបិ រាជាស្មាកំ នាស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","តតះ បីលាតោ យីឝុំ ក្រុឝេ វេធិតុំ តេឞាំ ហស្តេឞុ សមាប៌យត៑, តតស្តេ តំ ធ្ឫត្វា នីតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","តតះ បរំ យីឝុះ ក្រុឝំ វហន៑ ឝិរះកបាលម៑ អត៌្ហាទ៑ យទ៑ ឥព្រីយភាឞយា គុល្គល្តាំ វទន្តិ តស្មិន៑ ស្ថាន ឧបស្ថិតះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","តតស្តេ មធ្យស្ថានេ តំ តស្យោភយបាឝ៌្វេ ទ្វាវបរៅ ក្រុឝេៜវិធន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","អបរម៑ ឯឞ យិហូទីយានាំ រាជា នាសរតីយយីឝុះ, ឥតិ វិជ្ញាបនំ លិខិត្វា បីលាតស្តស្យ ក្រុឝោបរិ សមយោជយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","សា លិបិះ ឥព្រីយយូនានីយរោមីយភាឞាភិ រ្លិខិតា; យីឝោះ ក្រុឝវេធនស្ថានំ នគរស្យ សមីបំ, តស្មាទ៑ ពហវោ យិហូទីយាស្តាំ បឋិតុម៑ អារភន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","យិហូទីយានាំ ប្រធានយាជកាះ បីលាតមិតិ ន្យវេទយន៑ យិហូទីយានាំ រាជេតិ វាក្យំ ន កិន្តុ ឯឞ ស្វំ យិហូទីយានាំ រាជានម៑ អវទទ៑ ឥត្ថំ លិខតុ។ ");
INSERT INTO sankhm_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","តតះ បីលាត ឧត្តរំ ទត្តវាន៑ យល្លេខនីយំ តល្លិខិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ឥត្ថំ សេនាគណោ យីឝុំ ក្រុឝេ វិធិត្វា តស្យ បរិធេយវស្ត្រំ ចតុរោ ភាគាន៑ ក្ឫត្វា ឯកៃកសេនា ឯកៃកភាគម៑ អគ្ឫហ្លត៑ តស្យោត្តរីយវស្ត្រញ្ចាគ្ឫហ្លត៑។ កិន្តូត្តរីយវស្ត្រំ សូចិសេវនំ វិនា សវ៌្វម៑ ឩតំ។ ");
INSERT INTO sankhm_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","តស្មាត្តេ វ្យាហរន៑ ឯតត៑ កះ ប្រាប្ស្យតិ? តន្ន ខណ្ឌយិត្វា តត្រ គុដិកាបាតំ ករវាម។ វិភជន្តេៜធរីយំ មេ វសនំ តេ បរស្បរំ។ មមោត្តរីយវស្ត្រាត៌្ហំ គុដិកាំ បាតយន្តិ ច។ ឥតិ យទ្វាក្យំ ធម៌្មបុស្តកេ លិខិតមាស្តេ តត៑ សេនាគណេនេត្ថំ វ្យវហរណាត៑ សិទ្ធមភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","តទានីំ យីឝោ រ្មាតា មាតុ រ្ភគិនី ច យា ក្លិយបា ភាយ៌្យា មរិយម៑ មគ្ទលីនី មរិយម៑ ច ឯតាស្តស្យ ក្រុឝស្យ សន្និធៅ សមតិឞ្ឋន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","តតោ យីឝុះ ស្វមាតរំ ប្រិយតមឝិឞ្យញ្ច សមីបេ ទណ្ឌាយមានៅ វិលោក្យ មាតរម៑ អវទត៑, ហេ យោឞិទ៑ ឯនំ តវ បុត្រំ បឝ្យ, ");
INSERT INTO sankhm_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ឝិឞ្យន្ត្វវទត៑, ឯនាំ តវ មាតរំ បឝ្យ។ តតះ ស ឝិឞ្យស្តទ្ឃដិកាយាំ តាំ និជគ្ឫហំ នីតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","អនន្តរំ សវ៌្វំ កម៌្មាធុនា សម្បន្នមភូត៑ យីឝុរិតិ ជ្ញាត្វា ធម៌្មបុស្តកស្យ វចនំ យថា សិទ្ធំ ភវតិ តទត៌្ហម៑ អកថយត៑ មម បិបាសា ជាតា។ ");
INSERT INTO sankhm_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","តតស្តស្មិន៑ ស្ថានេ អម្លរសេន បូណ៌បាត្រស្ថិត្យា តេ ស្បញ្ជមេកំ តទម្លរសេនាទ៌្រីក្ឫត្យ ឯសោព្នលេ តទ៑ យោជយិត្វា តស្យ មុខស្យ សន្និធាវស្ថាបយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","តទា យីឝុរម្លរសំ គ្ឫហីត្វា សវ៌្វំ សិទ្ធម៑ ឥតិ កថាំ កថយិត្វា មស្តកំ នមយន៑ ប្រាណាន៑ បយ៌្យត្យជត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","តទ្វិនម៑ អាសាទនទិនំ តស្មាត៑ បរេៜហនិ វិឝ្រាមវារេ ទេហា យថា ក្រុឝោបរិ ន តិឞ្ឋន្តិ, យតះ ស វិឝ្រាមវារោ មហាទិនមាសីត៑, តស្មាទ៑ យិហូទីយាះ បីលាតនិកដំ គត្វា តេឞាំ បាទភញ្ជនស្យ ស្ថានាន្តរនយនស្យ ចានុមតិំ ប្រាត៌្ហយន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","អតះ សេនា អាគត្យ យីឝុនា សហ ក្រុឝេ ហតយោះ ប្រថមទ្វិតីយចោរយោះ បាទាន៑ អភញ្ជន៑; ");
INSERT INTO sankhm_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","កិន្តុ យីឝោះ សន្និធិំ គត្វា ស ម្ឫត ឥតិ ទ្ឫឞ្ដ្វា តស្យ បាទៅ នាភញ្ជន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","បឝ្ចាទ៑ ឯកោ យោទ្ធា ឝូលាឃាតេន តស្យ កុក្ឞិម៑ អវិធត៑ តត្ក្ឞណាត៑ តស្មាទ៑ រក្តំ ជលញ្ច និរគច្ឆត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","យោ ជនោៜស្យ សាក្ឞ្យំ ទទាតិ ស ស្វយំ ទ្ឫឞ្ដវាន៑ តស្យេទំ សាក្ឞ្យំ សត្យំ តស្យ កថា យុឞ្មាកំ វិឝ្វាសំ ជនយិតុំ យោគ្យា តត៑ ស ជានាតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","តស្យៃកម៑ អស្ធ្យបិ ន ភំក្ឞ្យតេ, ");
INSERT INTO sankhm_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","តទ្វទ៑ អន្យឝាស្ត្រេបិ លិខ្យតេ, យថា, \"ទ្ឫឞ្ដិបាតំ ករិឞ្យន្តិ តេៜវិធន៑ យន្តុ តម្ប្រតិ។ \" ");
INSERT INTO sankhm_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","អរិមថីយនគរស្យ យូឞផ្នាមា ឝិឞ្យ ឯក អាសីត៑ កិន្តុ យិហូទីយេភ្យោ ភយាត៑ ប្រកាឝិតោ ន ភវតិ; ស យីឝោ រ្ទេហំ នេតុំ បីលាតស្យានុមតិំ ប្រាត៌្ហយត, តតះ បីលាតេនានុមតេ សតិ ស គត្វា យីឝោ រ្ទេហម៑ អនយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","អបរំ យោ និកទីមោ រាត្រៅ យីឝោះ សមីបម៑ អគច្ឆត៑ សោបិ គន្ធរសេន មិឝ្រិតំ ប្រាយេណ បញ្ចាឝត្សេដកមគុរុំ គ្ឫហីត្វាគច្ឆត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","តតស្តេ យិហូទីយានាំ ឝ្មឝានេ ស្ថាបនរីត្យនុសារេណ តត្សុគន្ធិទ្រវ្យេណ សហិតំ តស្យ ទេហំ វស្ត្រេណាវេឞ្ដយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","អបរញ្ច យត្រ ស្ថានេ តំ ក្រុឝេៜវិធន៑ តស្យ និកដស្ថោទ្យានេ យត្រ កិមបិ ម្ឫតទេហំ កទាបិ នាស្ថាប្យត តាទ្ឫឝម៑ ឯកំ នូតនំ ឝ្មឝានម៑ អាសីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","យិហូទីយានាម៑ អាសាទនទិនាគមនាត៑ តេ តស្មិន៑ សមីបស្ថឝ្មឝានេ យីឝុម៑ អឝាយយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","អនន្តរំ សប្តាហស្យ ប្រថមទិនេ ៜតិប្រត្យូឞេ ៜន្ធការេ តិឞ្ឋតិ មគ្ទលីនី មរិយម៑ តស្យ ឝ្មឝានស្យ និកដំ គត្វា ឝ្មឝានស្យ មុខាត៑ ប្រស្តរមបសារិតម៑ អបឝ្យត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","បឝ្ចាទ៑ ធាវិត្វា ឝិមោន្បិតរាយ យីឝោះ ប្រិយតមឝិឞ្យាយ ចេទម៑ អកថយត៑, លោកាះ ឝ្មឝានាត៑ ប្រភុំ នីត្វា កុត្រាស្ថាបយន៑ តទ៑ វក្តុំ ន ឝក្នោមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","អតះ បិតរះ សោន្យឝិឞ្យឝ្ច ពហ៌ិ រ្ភុត្វា ឝ្មឝានស្ថានំ គន្តុម៑ អារភេតាំ។ ");
INSERT INTO sankhm_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ឧភយោទ៌្ហាវតោះ សោន្យឝិឞ្យះ បិតរំ បឝ្ចាត៑ ត្យក្ត្វា បូវ៌្វំ ឝ្មឝានស្ថាន ឧបស្ថិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","តទា ប្រហ្វីភូយ ស្ថាបិតវស្ត្រាណិ ទ្ឫឞ្ដវាន៑ កិន្តុ ន ប្រាវិឝត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","អបរំ ឝិមោន្បិតរ អាគត្យ ឝ្មឝានស្ថានំ ប្រវិឝ្យ ");
INSERT INTO sankhm_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ស្ថាបិតវស្ត្រាណិ មស្តកស្យ វស្ត្រញ្ច ប្ឫថក៑ ស្ថានាន្តរេ ស្ថាបិតំ ទ្ឫឞ្ដវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","តតះ ឝ្មឝានស្ថានំ បូវ៌្វម៑ អាគតោ យោន្យឝិឞ្យះ សោបិ ប្រវិឝ្យ តាទ្ឫឝំ ទ្ឫឞ្ដា វ្យឝ្វសីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","យតះ ឝ្មឝានាត៑ ស ឧត្ថាបយិតវ្យ ឯតស្យ ធម៌្មបុស្តកវចនស្យ ភាវំ តេ តទា វោទ្ធុំ នាឝន្កុវន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","អនន្តរំ តៅ ទ្វៅ ឝិឞ្យៅ ស្វំ ស្វំ គ្ឫហំ បរាវ្ឫត្យាគច្ឆតាម៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","តតះ បរំ មរិយម៑ ឝ្មឝានទ្វារស្យ ពហិះ ស្ថិត្វា រោទិតុម៑ អារភត តតោ រុទតី ប្រហ្វីភូយ ឝ្មឝានំ វិលោក្យ ");
INSERT INTO sankhm_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","យីឝោះ ឝយនស្ថានស្យ ឝិរះស្ថានេ បទតលេ ច ទ្វយោ រ្ទិឝោ ទ្វៅ ស្វគ៌ីយទូតាវុបវិឞ្ដៅ សមបឝ្យត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","តៅ ប្ឫឞ្ដវន្តៅ ហេ នារិ កុតោ រោទិឞិ? សាវទត៑ លោកា មម ប្រភុំ នីត្វា កុត្រាស្ថាបយន៑ ឥតិ ន ជានាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ឥត្យុក្ត្វា មុខំ បរាវ្ឫត្យ យីឝុំ ទណ្ឌាយមានម៑ អបឝ្យត៑ កិន្តុ ស យីឝុរិតិ សា ជ្ញាតុំ នាឝក្នោត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","តទា យីឝុស្តាម៑ អប្ឫច្ឆត៑ ហេ នារិ កុតោ រោទិឞិ? កំ វា ម្ឫគយសេ? តតះ សា តម៑ ឧទ្យានសេវកំ ជ្ញាត្វា វ្យាហរត៑, ហេ មហេច្ឆ ត្វំ យទីតះ ស្ថានាត៑ តំ នីតវាន៑ តហ៌ិ កុត្រាស្ថាបយស្តទ៑ វទ តត្ស្ថានាត៑ តម៑ អានយាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","តទា យីឝុស្តាម៑ អវទត៑ ហេ មរិយម៑។ តតះ សា បរាវ្ឫត្យ ប្រត្យវទត៑ ហេ រព្ពូនី អត៌្ហាត៑ ហេ គុរោ។ ");
INSERT INTO sankhm_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","តទា យីឝុរវទត៑ មាំ មា ធរ, ឥទានីំ បិតុះ សមីបេ ឩទ៌្ធ្វគមនំ ន ករោមិ កិន្តុ យោ មម យុឞ្មាកញ្ច បិតា មម យុឞ្មាកញ្ចេឝ្វរស្តស្យ និកដ ឩទ៌្ធ្វគមនំ កត៌្តុម៑ ឧទ្យតោស្មិ, ឥមាំ កថាំ ត្វំ គត្វា មម ភ្រាត្ឫគណំ ជ្ញាបយ។ ");
INSERT INTO sankhm_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","តតោ មគ្ទលីនីមរិយម៑ តត្ក្ឞណាទ៑ គត្វា ប្រភុស្តស្យៃ ទឝ៌នំ ទត្ត្វា កថា ឯតា អកថយទ៑ ឥតិ វាត៌្តាំ ឝិឞ្យេភ្យោៜកថយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","តតះ បរំ សប្តាហស្យ ប្រថមទិនស្យ សន្ធ្យាសមយេ ឝិឞ្យា ឯកត្រ មិលិត្វា យិហូទីយេភ្យោ ភិយា ទ្វាររុទ្ធម៑ អកុវ៌្វន៑, ឯតស្មិន៑ កាលេ យីឝុស្តេឞាំ មធ្យស្ថានេ តិឞ្ឋន៑ អកថយទ៑ យុឞ្មាកំ កល្យាណំ ភូយាត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ឥត្យុក្ត្វា និជហស្តំ កុក្ឞិញ្ច ទឝ៌ិតវាន៑, តតះ ឝិឞ្យាះ ប្រភុំ ទ្ឫឞ្ដ្វា ហ្ឫឞ្ដា អភវន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","យីឝុះ បុនរវទទ៑ យុឞ្មាកំ កល្យាណំ ភូយាត៑ បិតា យថា មាំ ប្រៃឞយត៑ តថាហមបិ យុឞ្មាន៑ ប្រេឞយាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ឥត្យុក្ត្វា ស តេឞាមុបរិ ទីគ៌្ហប្រឝ្វាសំ ទត្ត្វា កថិតវាន៑ បវិត្រម៑ អាត្មានំ គ្ឫហ្លីត។ ");
INSERT INTO sankhm_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","យូយំ យេឞាំ បាបានិ មោចយិឞ្យថ តេ មោចយិឞ្យន្តេ យេឞាញ្ច បាបាតិ ន មោចយិឞ្យថ តេ ន មោចយិឞ្យន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","ទ្វាទឝមធ្យេ គណិតោ យមជោ ថោមានាមា ឝិឞ្យោ យីឝោរាគមនកាលៃ តៃះ សាទ៌្ធំ នាសីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","អតោ វយំ ប្រភូម៑ អបឝ្យាមេតិ វាក្យេៜន្យឝិឞ្យៃរុក្តេ សោវទត៑, តស្យ ហស្តយោ រ្លៅហកីលកានាំ ចិហ្នំ ន វិលោក្យ តច្ចិហ្នម៑ អង្គុល្យា ន ស្ប្ឫឞ្ដ្វា តស្យ កុក្ឞៅ ហស្តំ នារោប្យ ចាហំ ន វិឝ្វសិឞ្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","អបរម៑ អឞ្ដមេៜហ្និ គតេ សតិ ថោមាសហិតះ ឝិឞ្យគណ ឯកត្រ មិលិត្វា ទ្វារំ រុទ្ធ្វាភ្យន្តរ អាសីត៑, ឯតហ៌ិ យីឝុស្តេឞាំ មធ្យស្ថានេ តិឞ្ឋន៑ អកថយត៑, យុឞ្មាកំ កុឝលំ ភូយាត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","បឝ្ចាត៑ ថាមៃ កថិតវាន៑ ត្វម៑ អង្គុលីម៑ អត្រាប៌យិត្វា មម ករៅ បឝ្យ ករំ ប្រសាយ៌្យ មម កុក្ឞាវប៌យ នាវិឝ្វស្យ។ ");
INSERT INTO sankhm_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","តទា ថោមា អវទត៑, ហេ មម ប្រភោ ហេ មទីឝ្វរ។ ");
INSERT INTO sankhm_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","យីឝុរកថយត៑, ហេ ថោមា មាំ និរីក្ឞ្យ វិឝ្វសិឞិ យេ ន ទ្ឫឞ្ដ្វា វិឝ្វសន្តិ តឯវ ធន្យាះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ឯតទន្យានិ បុស្តកេៜស្មិន៑ អលិខិតានិ ពហូន្យាឝ្ចយ៌្យកម៌្មាណិ យីឝុះ ឝិឞ្យាណាំ បុរស្តាទ៑ អករោត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","កិន្តុ យីឝុរីឝ្វរស្យាភិឞិក្តះ សុត ឯវេតិ យថា យូយំ វិឝ្វសិថ វិឝ្វស្យ ច តស្យ នាម្នា បរមាយុះ ប្រាប្នុថ តទត៌្ហម៑ ឯតានិ សវ៌្វាណ្យលិខ្យន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","តតះ បរំ តិពិរិយាជលធេស្តដេ យីឝុះ បុនរបិ ឝិឞ្យេភ្យោ ទឝ៌នំ ទត្តវាន៑ ទឝ៌នស្យាខ្យានមិទម៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ឝិមោន្បិតរះ យមជថោមា គាលីលីយកាន្នានគរនិវាសី និថនេល៑ សិវទេះ បុត្រាវន្យៅ ទ្វៅ ឝិឞ្យៅ ចៃតេឞ្វេកត្រ មិលិតេឞុ ឝិមោន្បិតរោៜកថយត៑ មត្ស្យាន៑ ធត៌ុំ យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","តតស្តេ វ្យាហរន៑ តហ៌ិ វយមបិ ត្វយា សាទ៌្ធំ យាមះ តទា តេ ពហិគ៌តាះ សន្តះ ក្ឞិប្រំ នាវម៑ អារោហន៑ កិន្តុ តស្យាំ រជន្យាម៑ ឯកមបិ ន ប្រាប្នុវន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","ប្រភាតេ សតិ យីឝុស្តដេ ស្ថិតវាន៑ កិន្តុ ស យីឝុរិតិ ឝិឞ្យា ជ្ញាតុំ នាឝក្នុវន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","តទា យីឝុរប្ឫច្ឆត៑, ហេ វត្សា សន្និធៅ កិញ្ចិត៑ ខាទ្យទ្រវ្យម៑ អាស្តេ? តេៜវទន៑ កិមបិ នាស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","តទា សោៜវទត៑ នៅកាយា ទក្ឞិណបាឝ៌្វេ ជាលំ និក្ឞិបត តតោ លប្ស្យធ្វេ, តស្មាត៑ តៃ រ្និក្ឞិប្តេ ជាលេ មត្ស្យា ឯតាវន្តោៜបតន៑ យេន តេ ជាលមាក្ឫឞ្យ នោត្តោលយិតុំ ឝក្តាះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","តស្មាទ៑ យីឝោះ ប្រិយតមឝិឞ្យះ បិតរាយាកថយត៑ ឯឞ ប្រភុ រ្ភវេត៑, ឯឞ ប្រភុរិតិ វាចំ ឝ្រុត្វៃវ ឝិមោន៑ នគ្នតាហេតោ រ្មត្ស្យធារិណ ឧត្តរីយវស្ត្រំ បរិធាយ ហ្រទំ ប្រត្យុទលម្ផយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","អបរេ ឝិឞ្យា មត្ស្យៃះ សាទ៌្ធំ ជាលម៑ អាកឞ៌ន្តះ ក្ឞុទ្រនៅកាំ វាហយិត្វា កូលមានយន៑ តេ កូលាទ៑ អតិទូរេ នាសន៑ ទ្វិឝតហស្តេភ្យោ ទូរ អាសន៑ ឥត្យនុមីយតេ។ ");
INSERT INTO sankhm_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","តីរំ ប្រាប្តៃស្តៃស្តត្រ ប្រជ្វលិតាគ្និស្តទុបរិ មត្ស្យាះ បូបាឝ្ច ទ្ឫឞ្ដាះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","តតោ យីឝុរកថយទ៑ យាន៑ មត្ស្យាន៑ អធរត តេឞាំ កតិបយាន៑ អានយត។ ");
INSERT INTO sankhm_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","អតះ ឝិមោន្បិតរះ បរាវ្ឫត្យ គត្វា ព្ឫហទ្ភិស្ត្រិបញ្ចាឝទធិកឝតមត្ស្យៃះ បរិបូណ៌ំ តជ្ជាលម៑ អាក្ឫឞ្យោទតោលយត៑ កិន្ត្វេតាវទ្ភិ រ្មត្ស្យៃរបិ ជាលំ នាឆិទ្យត។ ");
INSERT INTO sankhm_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","អនន្តរំ យីឝុស្តាន៑ អវាទីត៑ យូយមាគត្យ ភុំគ្ធ្វំ; តទា សឯវ ប្រភុរិតិ ជ្ញាតត្វាត៑ ត្វំ កះ? ឥតិ ប្រឞ្ដុំ ឝិឞ្យាណាំ កស្យាបិ ប្រគល្ភតា នាភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","តតោ យីឝុរាគត្យ បូបាន៑ មត្ស្យាំឝ្ច គ្ឫហីត្វា តេភ្យះ បយ៌្យវេឞយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ឥត្ថំ ឝ្មឝានាទុត្ថានាត៑ បរំ យីឝុះ ឝិឞ្យេភ្យស្ត្ឫតីយវារំ ទឝ៌នំ ទត្តវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ភោជនេ សមាប្តេ សតិ យីឝុះ ឝិមោន្បិតរំ ប្ឫឞ្ដវាន៑, ហេ យូនសះ បុត្រ ឝិមោន៑ ត្វំ កិម៑ ឯតេភ្យោធិកំ មយិ ប្រីយសេ? តតះ ស ឧទិតវាន៑ សត្យំ ប្រភោ ត្វយិ ប្រីយេៜហំ តទ៑ ភវាន៑ ជានាតិ; តទា យីឝុរកថយត៑ តហ៌ិ មម មេឞឝាវកគណំ បាលយ។ ");
INSERT INTO sankhm_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","តតះ ស ទ្វិតីយវារំ ប្ឫឞ្ដវាន៑ ហេ យូនសះ បុត្រ ឝិមោន៑ ត្វំ កិំ មយិ ប្រីយសេ? តតះ ស ឧក្តវាន៑ សត្យំ ប្រភោ ត្វយិ ប្រីយេៜហំ តទ៑ ភវាន៑ ជានាតិ; តទា យីឝុរកថយត តហ៌ិ មម មេឞគណំ បាលយ។ ");
INSERT INTO sankhm_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","បឝ្ចាត៑ ស ត្ឫតីយវារំ ប្ឫឞ្ដវាន៑, ហេ យូនសះ បុត្រ ឝិមោន៑ ត្វំ កិំ មយិ ប្រីយសេ? ឯតទ្វាក្យំ ត្ឫតីយវារំ ប្ឫឞ្ដវាន៑ តស្មាត៑ បិតរោ ទុះខិតោ ភូត្វាៜកថយត៑ ហេ ប្រភោ ភវតះ កិមប្យគោចរំ នាស្តិ ត្វយ្យហំ ប្រីយេ តទ៑ ភវាន៑ ជានាតិ; តតោ យីឝុរវទត៑ តហ៌ិ មម មេឞគណំ បាលយ។ ");
INSERT INTO sankhm_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","អហំ តុភ្យំ យថាត៌្ហំ កថយាមិ យៅវនកាលេ ស្វយំ ពទ្ធកដិ រ្យត្រេច្ឆា តត្រ យាតវាន៑ កិន្ត្វិតះ បរំ វ្ឫទ្ធេ វយសិ ហស្តំ វិស្តារយិឞ្យសិ, អន្យជនស្ត្វាំ ពទ្ធ្វា យត្រ គន្តុំ តវេច្ឆា ន ភវតិ ត្វាំ ធ្ឫត្វា តត្រ នេឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ផលតះ កីទ្ឫឝេន មរណេន ស ឦឝ្វរស្យ មហិមានំ ប្រកាឝយិឞ្យតិ តទ៑ ពោធយិតុំ ស ឥតិ វាក្យំ ប្រោក្តវាន៑។ ឥត្យុក្តេ សតិ ស តមវោចត៑ មម បឝ្ចាទ៑ អាគច្ឆ។ ");
INSERT INTO sankhm_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","យោ ជនោ រាត្រិកាលេ យីឝោ រ្វក្ឞោៜវលម្ព្យ, ហេ ប្រភោ កោ ភវន្តំ បរករេឞុ សមប៌យិឞ្យតីតិ វាក្យំ ប្ឫឞ្ដវាន៑, តំ យីឝោះ ប្រិយតមឝិឞ្យំ បឝ្ចាទ៑ អាគច្ឆន្តំ ");
INSERT INTO sankhm_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","បិតរោ មុខំ បរាវត៌្ត្យ វិលោក្យ យីឝុំ ប្ឫឞ្ដវាន៑, ហេ ប្រភោ ឯតស្យ មានវស្យ កីទ្ឫឝី គតិ រ្ភវិឞ្យតិ? ");
INSERT INTO sankhm_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","ស ប្រត្យវទត៑, មម បុនរាគមនបយ៌្យន្តំ យទិ តំ ស្ថាបយិតុម៑ ឥច្ឆាមិ តត្រ តវ កិំ? ត្វំ មម បឝ្ចាទ៑ អាគច្ឆ។ ");
INSERT INTO sankhm_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","តស្មាត៑ ស ឝិឞ្យោ ន មរិឞ្យតីតិ ភ្រាត្ឫគណមធ្យេ កិំវទន្តី ជាតា កិន្តុ ស ន មរិឞ្យតីតិ វាក្យំ យីឝុ រ្នាវទត៑ កេវលំ មម បុនរាគមនបយ៌្យន្តំ យទិ តំ ស្ថាបយិតុម៑ ឥច្ឆាមិ តត្រ តវ កិំ? ឥតិ វាក្យម៑ ឧក្តវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","យោ ជន ឯតានិ សវ៌្វាណិ លិខិតវាន៑ អត្រ សាក្ឞ្យញ្ច ទត្តវាន៑ សឯវ ស ឝិឞ្យះ, តស្យ សាក្ឞ្យំ ប្រមាណមិតិ វយំ ជានីមះ។ ");
INSERT INTO sankhm_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","យីឝុរេតេភ្យោៜបរាណ្យបិ ពហូនិ កម៌្មាណិ ក្ឫតវាន៑ តានិ សវ៌្វាណិ យទ្យេកៃកំ ក្ឫត្វា លិខ្យន្តេ តហ៌ិ គ្រន្ថា ឯតាវន្តោ ភវន្តិ តេឞាំ ធារណេ ប្ឫថិវ្យាំ ស្ថានំ ន ភវតិ។ ឥតិ៕ ");
INSERT INTO sankhm_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","ហេ ថិយផិល, យីឝុះ ស្វមនោនីតាន៑ ប្រេរិតាន៑ បវិត្រេណាត្មនា សមាទិឝ្យ យស្មិន៑ ទិនេ ស្វគ៌មារោហត៑ យាំ យាំ ក្រិយាមករោត៑ យទ្យទ៑ ឧបាទិឝច្ច តានិ សវ៌្វាណិ បូវ៌្វំ មយា លិខិតានិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ស ស្វនិធនទុះខភោគាត៑ បរម៑ អនេកប្រត្យយក្ឞប្រមាណៅះ ស្វំ សជីវំ ទឝ៌យិត្វា ");
INSERT INTO sankhm_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ចត្វារិំឝទ្ទិនានិ យាវត៑ តេភ្យះ ប្រេរិតេភ្យោ ទឝ៌នំ ទត្ត្វេឝ្វរីយរាជ្យស្យ វណ៌នម អករោត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","អនន្តរំ តេឞាំ សភាំ ក្ឫត្វា ឥត្យាជ្ញាបយត៑, យូយំ យិរូឝាលមោៜន្យត្រ គមនមក្ឫត្វា យស្តិន៑ បិត្រាង្គីក្ឫតេ មម វទនាត៑ កថា អឝ្ឫណុត តត្ប្រាប្តិម៑ អបេក្ឞ្យ តិឞ្ឋត។ ");
INSERT INTO sankhm_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","យោហន៑ ជលេ មជ្ជិតាវាន៑ កិន្ត្វល្បទិនមធ្យេ យូយំ បវិត្រ អាត្មនិ មជ្ជិតា ភវិឞ្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","បឝ្ចាត៑ តេ សវ៌្វេ មិលិត្វា តម៑ អប្ឫច្ឆន៑ ហេ ប្រភោ ភវាន៑ កិមិទានីំ បុនរបិ រាជ្យម៑ ឥស្រាយេលីយលោកានាំ ករេឞុ សមប៌យិឞ្យតិ? ");
INSERT INTO sankhm_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","តតះ សោវទត៑ យាន៑ សវ៌្វាន៑ កាលាន៑ សមយាំឝ្ច បិតា ស្វវឝេៜស្ថាបយត៑ តាន៑ ជ្ញាត្ឫំ យុឞ្មាកម៑ អធិការោ ន ជាយតេ។ ");
INSERT INTO sankhm_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","កិន្តុ យុឞ្មាសុ បវិត្រស្យាត្មន អាវិព៌្ហាវេ សតិ យូយំ ឝក្តិំ ប្រាប្យ យិរូឝាលមិ សមស្តយិហូទាឝោមិរោណទេឝយោះ ប្ឫថិវ្យាះ សីមាំ យាវទ៑ យាវន្តោ ទេឝាស្តេឞុ យវ៌្វេឞុ ច មយិ សាក្ឞ្យំ ទាស្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ឥតិ វាក្យមុក្ត្វា ស តេឞាំ សមក្ឞំ ស្វគ៌ំ នីតោៜភវត៑, តតោ មេឃមារុហ្យ តេឞាំ ទ្ឫឞ្ដេរគោចរោៜភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","យស្មិន៑ សមយេ តេ វិហាយសំ ប្រត្យនន្យទ្ឫឞ្ដ្យា តស្យ តាទ្ឫឝម៑ ឩទ៌្វ្វគមនម៑ អបឝ្យន៑ តស្មិន្នេវ សមយេ ឝុក្លវស្ត្រៅ ទ្វៅ ជនៅ តេឞាំ សន្និធៅ ទណ្ឌាយមានៅ កថិតវន្តៅ, ");
INSERT INTO sankhm_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ហេ គាលីលីយលោកា យូយំ កិមត៌្ហំ គគណំ ប្រតិ និរីក្ឞ្យ ទណ្ឌាយមានាស្តិឞ្ឋថ? យុឞ្មាកំ សមីបាត៑ ស្វគ៌ំ នីតោ យោ យីឝុស្តំ យូយំ យថា ស្វគ៌ម៑ អារោហន្តម៑ អទឝ៌ម៑ តថា ស បុនឝ្ចាគមិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","តតះ បរំ តេ ជៃតុននាម្នះ បវ៌្វតាទ៑ វិឝ្រាមវារស្យ បថះ បរិមាណម៑ អត៌្ហាត៑ ប្រាយេណាទ៌្ធក្រោឝំ ទុរស្ថំ យិរូឝាលម្នគរំ បរាវ្ឫត្យាគច្ឆន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","នគរំ ប្រវិឝ្យ បិតរោ យាកូព៑ យោហន៑ អាន្ទ្រិយះ ផិលិបះ ថោមា ពត៌្ហជមយោ មថិរាល្ផីយបុត្រោ យាកូព៑ ឧទ្យោគាी ឝិមោន៑ យាកូពោ ភ្រាតា យិហូទា ឯតេ សវ៌្វេ យត្រ ស្ថានេ ប្រវសន្តិ តស្មិន៑ ឧបរិតនប្រកោឞ្ឋេ ប្រាវិឝន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","បឝ្ចាទ៑ ឥមេ កិយត្យះ ស្ត្រិយឝ្ច យីឝោ រ្មាតា មរិយម៑ តស្យ ភ្រាតរឝ្ចៃតេ សវ៌្វ ឯកចិត្តីភូត សតតំ វិនយេន វិនយេន ប្រាត៌្ហយន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","តស្មិន៑ សមយេ តត្រ ស្ថានេ សាកល្យេន វិំឝត្យធិកឝតំ ឝិឞ្យា អាសន៑។ តតះ បិតរស្តេឞាំ មធ្យេ តិឞ្ឋន៑ ឧក្តវាន្ ");
INSERT INTO sankhm_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","ហេ ភ្រាត្ឫគណ យីឝុធារិណាំ លោកានាំ បថទឝ៌កោ យោ យិហូទាស្តស្មិន៑ ទាយូទា បវិត្រ អាត្មា យាំ កថាំ កថយាមាស តស្យាះ ប្រត្យក្ឞីភវនស្យាវឝ្យកត្វម៑ អាសីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ស ជនោៜស្មាកំ មធ្យវត៌្តី សន៑ អស្យាះ សេវាយា អំឝម៑ អលភត។ ");
INSERT INTO sankhm_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","តទនន្តរំ កុកម៌្មណា លព្ធំ យន្មូល្យំ តេន ក្ឞេត្រមេកំ ក្រីតម៑ អបរំ តស្មិន៑ អធោមុខេ ភ្ឫមៅ បតិតេ សតិ តស្យោទរស្យ វិទីណ៌ត្វាត៑ សវ៌្វា នាឌ្យោ និរគច្ឆន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ឯតាំ កថាំ យិរូឝាលម្និវាសិនះ សវ៌្វេ លោកា វិទាន្តិ; តេឞាំ និជភាឞយា តត្ក្ឞេត្រញ្ច ហកល្ទាមា, អត៌្ហាត៑ រក្តក្ឞេត្រមិតិ វិខ្យាតមាស្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","អន្យច្ច, និកេតនំ តទីយន្តុ ឝុន្យមេវ ភវិឞ្យតិ។ តស្យ ទូឞ្យេ និវាសាត៌្ហំ កោបិ ស្ថាស្យតិ នៃវ ហិ។ អន្យ ឯវ ជនស្តស្យ បទំ សំប្រាប្ស្យតិ ធ្រុវំ។ ឥត្ថំ គីតបុស្តកេ លិខិតមាស្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","អតោ យោហនោ មជ្ជនម៑ អារភ្យាស្មាកំ សមីបាត៑ ប្រភោ រ្យីឝោះ ស្វគ៌ារោហណទិនំ យាវត៑ សោស្មាកំ មធ្យេ យាវន្តិ ទិនានិ យាបិតវាន្ ");
INSERT INTO sankhm_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","តាវន្តិ ទិនានិ យេ មានវា អស្មាភិះ សាទ៌្ធំ តិឞ្ឋន្តិ តេឞាម៑ ឯកេន ជនេនាស្មាភិះ សាទ៌្ធំ យីឝោរុត្ថានេ សាក្ឞិណា ភវិតវ្យំ។ ");
INSERT INTO sankhm_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","អតោ យស្យ រូឍិ រ្យុឞ្ដោ យំ ពឝ៌ព្ពេត្យុក្ត្វាហូយន្តិ ស យូឞផ៑ មតថិឝ្ច ទ្វាវេតៅ ប្ឫថក៑ ក្ឫត្វា ត ឦឝ្វរស្យ សន្និធៅ ប្រាយ៌្យ កថិតវន្តះ, ");
INSERT INTO sankhm_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","ហេ សវ៌្វាន្តយ៌្យាមិន៑ បរមេឝ្វរ, យិហូទាះ សេវនប្រេរិតត្វបទច្យុតះ ");
INSERT INTO sankhm_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","សន៑ និជស្ថានម៑ អគច្ឆត៑, តត្បទំ លព្ធុម៑ ឯនយោ រ្ជនយោ រ្មធ្យេ ភវតា កោៜភិរុចិតស្តទស្មាន៑ ទឝ៌្យតាំ។ ");
INSERT INTO sankhm_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","តតោ គុដិកាបាដេ ក្ឫតេ មតថិន៌ិរចីយត តស្មាត៑ សោន្យេឞាម៑ ឯកាទឝានាំ ប្ររិតានាំ មធ្យេ គណិតោភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","អបរញ្ច និស្តារោត្សវាត៑ បរំ បញ្ចាឝត្តមេ ទិនេ សមុបស្ថិតេ សតិ តេ សវ៌្វេ ឯកាចិត្តីភូយ ស្ថាន ឯកស្មិន៑ មិលិតា អាសន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ឯតស្មិន្នេវ សមយេៜកស្មាទ៑ អាកាឝាត៑ ប្រចណ្ឌាត្យុគ្រវាយោះ ឝព្ទវទ៑ ឯកះ ឝព្ទ អាគត្យ យស្មិន៑ គ្ឫហេ ត ឧបាវិឝន៑ តទ៑ គ្ឫហំ សមស្តំ វ្យាប្នោត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","តតះ បរំ វហ្និឝិខាស្វរូបា ជិហ្វាះ ប្រត្យក្ឞីភូយ វិភក្តាះ សត្យះ ប្រតិជនោទ៌្ធ្វេ ស្ថគិតា អភូវន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","តស្មាត៑ សវ៌្វេ បវិត្រេណាត្មនា បរិបូណ៌ាះ សន្ត អាត្មា យថា វាចិតវាន៑ តទនុសារេណាន្យទេឝីយានាំ ភាឞា ឧក្តវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","តស្មិន៑ សមយេ ប្ឫថិវីស្ថសវ៌្វទេឝេភ្យោ យិហូទីយមតាវលម្ពិនោ ភក្តលោកា យិរូឝាលមិ ប្រាវសន៑; ");
INSERT INTO sankhm_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","តស្យាះ កថាយាះ កិំវទន្ត្យា ជាតត្វាត៑ សវ៌្វេ លោកា មិលិត្វា និជនិជភាឞយា ឝិឞ្យាណាំ កថាកថនំ ឝ្រុត្វា សមុទ្វិគ្នា អភវន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","សវ៌្វឯវ វិស្មយាបន្នា អាឝ្ចយ៌្យាន្វិតាឝ្ច សន្តះ បរស្បរំ ឧក្តវន្តះ បឝ្យត យេ កថាំ កថយន្តិ តេ សវ៌្វេ គាលីលីយលោកាះ កិំ ន ភវន្តិ? ");
INSERT INTO sankhm_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","តហ៌ិ វយំ ប្រត្យេកឝះ ស្វស្វជន្មទេឝីយភាឞាភិះ កថា ឯតេឞាំ ឝ្ឫណុមះ កិមិទំ? ");
INSERT INTO sankhm_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","បាត៌្ហី-មាទី-អរាម្នហរយិម្ទេឝនិវាសិមនោ យិហូទា-កប្បទកិយា-បន្ត-អាឝិយា- ");
INSERT INTO sankhm_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ផ្រុគិយា-បម្ផុលិយា-មិសរនិវាសិនះ កុរីណីនិកដវត៌្តិលូពីយប្រទេឝនិវាសិនោ រោមនគរាទ៑ អាគតា យិហូទីយលោកា យិហូទីយមតគ្រាហិណះ ក្រីតីយា អរាពីយាទយោ លោកាឝ្ច យេ វយម្ ");
INSERT INTO sankhm_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","អស្មាកំ និជនិជភាឞាភិរេតេឞាម៑ ឦឝ្វរីយមហាកម៌្មវ្យាខ្យានំ ឝ្ឫណុមះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ឥត្ថំ តេ សវ៌្វឯវ វិស្មយាបន្នាះ សន្ទិគ្ធចិត្តាះ សន្តះ បរស្បរមូចុះ, អស្យ កោ ភាវះ? ");
INSERT INTO sankhm_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","អបរេ កេចិត៑ បរិហស្យ កថិតវន្ត ឯតេ នវីនទ្រាក្ឞារសេន មត្តា អភវន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","តទា បិតរ ឯកាទឝភិ រ្ជនៃះ សាកំ តិឞ្ឋន៑ តាល្លោកាន៑ ឧច្ចៃះការម៑ អវទត៑, ហេ យិហូទីយា ហេ យិរូឝាលម្និវាសិនះ សវ៌្វេ, អវធានំ ក្ឫត្វា មទីយវាក្យំ ពុធ្យធ្វំ។ ");
INSERT INTO sankhm_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ឥទានីម៑ ឯកយាមាទ៑ អធិកា វេលា នាស្តិ តស្មាទ៑ យូយំ យទ៑ អនុមាថ មានវា ឥមេ មទ្យបានេន មត្តាស្តន្ន។ ");
INSERT INTO sankhm_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","កិន្តុ យោយេល្ភវិឞ្យទ្វក្ត្រៃតទ្វាក្យមុក្តំ យថា, ");
INSERT INTO sankhm_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","ឦឝ្វរះ កថយាមាស យុគាន្តសមយេ ត្វហម៑។ វឞ៌ិឞ្យាមិ ស្វមាត្មានំ សវ៌្វប្រាណ្យុបរិ ធ្រុវម៑។ ភាវិវាក្យំ វទិឞ្យន្តិ កន្យាះ បុត្រាឝ្ច វស្តុតះ។ ប្រត្យាទេឝញ្ច ប្រាប្ស្យន្តិ យុឞ្មាកំ យុវមានវាះ។ តថា ប្រាចីនលោកាស្តុ ស្វប្នាន៑ ទ្រក្ឞ្យន្តិ និឝ្ចិតំ។ ");
INSERT INTO sankhm_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","វឞ៌ិឞ្យាមិ តទាត្មានំ ទាសទាសីជនោបិរិ។ តេនៃវ ភាវិវាក្យំ តេ វទិឞ្យន្តិ ហិ សវ៌្វឝះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ឩទ៌្ធ្វស្ថេ គគណេ ចៃវ នីចស្ថេ ប្ឫថិវីតលេ។ ឝោណិតានិ ព្ឫហទ្ភានូន៑ ឃនធូមាទិកានិ ច។ ចិហ្នានិ ទឝ៌យិឞ្យាមិ មហាឝ្ចយ៌្យក្រិយាស្តថា។ ");
INSERT INTO sankhm_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","មហាភយានកស្យៃវ តទ្ទិនស្យ បរេឝិតុះ។ បុរាគមាទ៑ រវិះ ក្ឫឞ្ណោ រក្តឝ្ចន្ទ្រោ ភវិឞ្យតះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","កិន្តុ យះ បរមេឝស្យ នាម្និ សម្ប្រាត៌្ហយិឞ្យតេ។ សឯវ មនុជោ នូនំ បរិត្រាតោ ភវិឞ្យតិ៕ ");
INSERT INTO sankhm_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","អតោ ហេ ឥស្រាយេល្វំឝីយលោកាះ សវ៌្វេ កថាយាមេតស្យាម៑ មនោ និធទ្ធ្វំ នាសរតីយោ យីឝុរីឝ្វរស្យ មនោនីតះ បុមាន៑ ឯតទ៑ ឦឝ្វរស្តត្ក្ឫតៃរាឝ្ចយ៌្យាទ្ភុតកម៌្មភិ រ្លក្ឞណៃឝ្ច យុឞ្មាកំ សាក្ឞាទេវ ប្រតិបាទិតវាន៑ ឥតិ យូយំ ជានីថ។ ");
INSERT INTO sankhm_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","តស្មិន៑ យីឝៅ ឦឝ្វរស្យ បូវ៌្វនិឝ្ចិតមន្ត្រណានិរូបណានុសារេណ ម្ឫត្យៅ សមប៌ិតេ សតិ យូយំ តំ ធ្ឫត្វា ទុឞ្ដលោកានាំ ហស្តៃះ ក្រុឝេ វិធិត្វាហត។ ");
INSERT INTO sankhm_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","កិន្ត្វីឝ្វរស្តំ និធនស្យ ពន្ធនាន្មោចយិត្វា ឧទស្ថាបយត៑ យតះ ស ម្ឫត្យុនា ពទ្ធស្តិឞ្ឋតីតិ ន សម្ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ឯតស្តិន៑ ទាយូទបិ កថិតវាន៑ យថា, សវ៌្វទា មម សាក្ឞាត្តំ ស្ថាបយ បរមេឝ្វរំ។ ស្ថិតេ មទ្ទក្ឞិណេ តស្មិន៑ ស្ខលិឞ្យាមិ ត្វហំ នហិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","អានន្ទិឞ្យតិ តទ្ធេតោ រ្មាមកីនំ មនស្តុ វៃ។ អាហ្លាទិឞ្យតិ ជិហ្វាបិ មទីយា តុ តថៃវ ច។ ប្រត្យាឝយា ឝរីរន្តុ មទីយំ វៃឝយិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","បរលោកេ យតោ ហេតោស្ត្វំ មាំ នៃវ ហិ ត្យក្ឞ្យសិ។ ស្វកីយំ បុណ្យវន្តំ ត្វំ ក្ឞយិតុំ នៃវ ទាស្យសិ។ ឯវំ ជីវនមាគ៌ំ ត្វំ មាមេវ ទឝ៌យិឞ្យសិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","ស្វសម្មុខេ យ អានន្ទោ ទក្ឞិណេ ស្វស្យ យត៑ សុខំ។ អនន្តំ តេន មាំ បូណ៌ំ ករិឞ្យសិ ន សំឝយះ៕ ");
INSERT INTO sankhm_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","ហេ ភ្រាតរោៜស្មាកំ តស្យ បូវ៌្វបុរុឞស្យ ទាយូទះ កថាំ ស្បឞ្ដំ កថយិតុំ មាម៑ អនុមន្យធ្វំ, ស ប្រាណាន៑ ត្យក្ត្វា ឝ្មឝានេ ស្ថាបិតោភវទ៑ អទ្យាបិ តត៑ ឝ្មឝានម៑ អស្មាកំ សន្និធៅ វិទ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","ផលតោ លៅកិកភាវេន ទាយូទោ វំឝេ ខ្រីឞ្ដំ ជន្ម គ្រាហយិត្វា តស្យៃវ សិំហាសនេ សមុវេឞ្ដុំ តមុត្ថាបយិឞ្យតិ បរមេឝ្វរះ ឝបថំ កុត្វា ទាយូទះ សមីប ឥមម៑ អង្គីការំ ក្ឫតវាន៑, ");
INSERT INTO sankhm_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ឥតិ ជ្ញាត្វា ទាយូទ៑ ភវិឞ្យទ្វាទី សន៑ ភវិឞ្យត្កាលីយជ្ញានេន ខ្រីឞ្ដោត្ថានេ កថាមិមាំ កថយាមាស យថា តស្យាត្មា បរលោកេ ន ត្យក្ឞ្យតេ តស្យ ឝរីរញ្ច ន ក្ឞេឞ្យតិ; ");
INSERT INTO sankhm_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","អតះ បរមេឝ្វរ ឯនំ យីឝុំ ឝ្មឝានាទ៑ ឧទស្ថាបយត៑ តត្រ វយំ សវ៌្វេ សាក្ឞិណ អាស្មហេ។ ");
INSERT INTO sankhm_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ស ឦឝ្វរស្យ ទក្ឞិណករេណោន្នតិំ ប្រាប្យ បវិត្រ អាត្មិន បិតា យមង្គីការំ ក្ឫតវាន៑ តស្យ ផលំ ប្រាប្យ យត៑ បឝ្យថ ឝ្ឫណុថ ច តទវឞ៌ត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","យតោ ទាយូទ៑ ស្វគ៌ំ នារុរោហ កិន្តុ ស្វយម៑ ឥមាំ កថាម៑ អកថយទ៑ យថា, មម ប្រភុមិទំ វាក្យមវទត៑ បរមេឝ្វរះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","តវ ឝត្រូនហំ យាវត៑ បាទបីឋំ ករោមិ ន។ តាវត៑ កាលំ មទីយេ ត្វំ ទក្ឞវាឝ៌្វ ឧបាវិឝ។ ");
INSERT INTO sankhm_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","អតោ យំ យីឝុំ យូយំ ក្រុឝេៜហត បរមេឝ្វរស្តំ ប្រភុត្វាភិឞិក្តត្វបទេ ន្យយុំក្តេតិ ឥស្រាយេលីយា លោកា និឝ្ចិតំ ជានន្តុ។ ");
INSERT INTO sankhm_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ឯតាទ្ឫឝីំ កថាំ ឝ្រុត្វា តេឞាំ ហ្ឫទយានាំ វិទីណ៌ត្វាត៑ តេ បិតរាយ តទន្យប្រេរិតេភ្យឝ្ច កថិតវន្តះ, ហេ ភ្រាត្ឫគណ វយំ កិំ ករិឞ្យាមះ? ");
INSERT INTO sankhm_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","តតះ បិតរះ ប្រត្យវទទ៑ យូយំ សវ៌្វេ ស្វំ ស្វំ មនះ បរិវត៌្តយធ្វំ តថា បាបមោចនាត៌្ហំ យីឝុខ្រីឞ្ដស្យ នាម្នា មជ្ជិតាឝ្ច ភវត, តស្មាទ៑ ទានរូបំ បរិត្រម៑ អាត្មានំ លប្ស្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","យតោ យុឞ្មាកំ យុឞ្មត្សន្តានានាញ្ច ទូរស្ថសវ៌្វលោកានាញ្ច និមិត្តម៑ អត៌្ហាទ៑ អស្មាកំ ប្រភុះ បរមេឝ្វរោ យាវតោ លាកាន៑ អាហ្វាស្យតិ តេឞាំ សវ៌្វេឞាំ និមិត្តម៑ អយមង្គីការ អាស្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ឯតទន្យាភិ រ្ពហុកថាភិះ ប្រមាណំ ទត្វាកថយត៑ ឯតេភ្យោ វិបថគាមិភ្យោ វត៌្តមានលោកេភ្យះ ស្វាន៑ រក្ឞត។ ");
INSERT INTO sankhm_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","តតះ បរំ យេ សានន្ទាស្តាំ កថាម៑ អគ្ឫហ្លន៑ តេ មជ្ជិតា អភវន៑។ តស្មិន៑ ទិវសេ ប្រាយេណ ត្រីណិ សហស្រាណិ លោកាស្តេឞាំ សបក្ឞាះ សន្តះ ");
INSERT INTO sankhm_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ប្រេរិតានាម៑ ឧបទេឝេ សង្គតៅ បូបភញ្ជនេ ប្រាត៌្ហនាសុ ច មនះសំយោគំ ក្ឫត្វាតិឞ្ឋន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","ប្រេរិតៃ រ្នានាប្រការលក្ឞណេឞុ មហាឝ្ចយ៌្យកម៌មសុ ច ទឝ៌ិតេឞុ សវ៌្វលោកានាំ ភយមុបស្ថិតំ។ ");
INSERT INTO sankhm_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","វិឝ្វាសការិណះ សវ៌្វ ច សហ តិឞ្ឋនតះ។ ស្វេឞាំ សវ៌្វាះ សម្បត្តីះ សាធារណ្យេន ស្ថាបយិត្វាភុញ្ជត។ ");
INSERT INTO sankhm_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ផលតោ គ្ឫហាណិ ទ្រវ្យាណិ ច សវ៌្វាណិ វិក្រីយ សវ៌្វេឞាំ ស្វស្វប្រយោជនានុសារេណ វិភជ្យ សវ៌្វេភ្យោៜទទន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","សវ៌្វ ឯកចិត្តីភូយ ទិនេ ទិនេ មន្ទិរេ សន្តិឞ្ឋមានា គ្ឫហេ គ្ឫហេ ច បូបានភញ្ជន្ត ឦឝ្វរស្យ ធន្យវាទំ កុវ៌្វន្តោ លោកៃះ សមាទ្ឫតាះ បរមានន្ទេន សរលាន្តះករណេន ភោជនំ បានញ្ចកុវ៌្វន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","បរមេឝ្វរោ ទិនេ ទិនេ បរិត្រាណភាជនៃ រ្មណ្ឌលីម៑ អវទ៌្ធយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","ត្ឫតីយយាមវេលាយាំ សត្យាំ ប្រាត៌្ហនាយាះ សមយេ បិតរយោហនៅ សម្ភូយ មន្ទិរំ គច្ឆតះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","តស្មិន្នេវ សមយេ មន្ទិរប្រវេឝកានាំ សមីបេ ភិក្ឞារណាត៌្ហំ យំ ជន្មខញ្ជមានុឞំ លោកា មន្ទិរស្យ សុន្ទរនាម្និ ទ្វារេ ប្រតិទិនម៑ អស្ថាបយន៑ តំ វហន្តស្តទ្វារំ អានយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","តទា បិតរយោហនៅ មន្តិរំ ប្រវេឞ្ដុម៑ ឧទ្យតៅ វិលោក្យ ស ខញ្ជស្តៅ កិញ្ចិទ៑ ភិក្ឞិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","តស្មាទ៑ យោហនា សហិតះ បិតរស្តម៑ អនន្យទ្ឫឞ្ដ្យា និរីក្ឞ្យ ប្រោក្តវាន៑ អាវាំ ប្រតិ ទ្ឫឞ្ដិំ កុរុ។ ");
INSERT INTO sankhm_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","តតះ ស កិញ្ចិត៑ ប្រាប្ត្យាឝយា តៅ ប្រតិ ទ្ឫឞ្ដិំ ក្ឫតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","តទា បិតរោ គទិតវាន៑ មម និកដេ ស្វណ៌រូប្យាទិ កិមបិ នាស្តិ កិន្តុ យទាស្តេ តទ៑ ទទាមិ នាសរតីយស្យ យីឝុខ្រីឞ្ដស្យ នាម្នា ត្វមុត្ថាយ គមនាគមនេ កុរុ។ ");
INSERT INTO sankhm_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","តតះ បរំ ស តស្យ ទក្ឞិណករំ ធ្ឫត្វា តម៑ ឧទតោលយត៑; តេន តត្ក្ឞណាត៑ តស្យ ជនស្យ បាទគុល្ផយោះ សពលត្វាត៑ ស ឧល្លម្ផ្យ ប្រោត្ថាយ គមនាគមនេ ៜករោត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","តតោ គមនាគមនេ កុវ៌្វន៑ ឧល្លម្ផន៑ ឦឝ្វរំ ធន្យំ វទន៑ តាភ្យាំ សាទ៌្ធំ មន្ទិរំ ប្រាវិឝត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","តតះ សវ៌្វេ លោកាស្តំ គមនាគមនេ កុវ៌្វន្តម៑ ឦឝ្វរំ ធន្យំ វទន្តញ្ច វិលោក្យ ");
INSERT INTO sankhm_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","មន្ទិរស្យ សុន្ទរេ ទ្វារេ យ ឧបវិឝ្យ ភិក្ឞិតវាន៑ សឯវាយម៑ ឥតិ ជ្ញាត្វា តំ ប្រតិ តយា ឃដនយា ចមត្ក្ឫតា វិស្មយាបន្នាឝ្ចាភវន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","យះ ខញ្ជះ ស្វស្ថោភវត៑ តេន បិតរយោហនោះ ករយោទ៌្ហ្ដតយោះ សតោះ សវ៌្វេ លោកា សន្និធិម៑ អាគច្ឆន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","តទ៑ ទ្ឫឞ្ដ្វា បិតរស្តេភ្យោៜកថយត៑, ហេ ឥស្រាយេលីយលោកា យូយំ កុតោ ៜនេនាឝ្ចយ៌្យំ មន្យធ្វេ? អាវាំ និជឝក្ត្យា យទ្វា និជបុណ្យេន ខញ្ជមនុឞ្យមេនំ គមិតវន្តាវិតិ ចិន្តយិត្វា អាវាំ ប្រតិ កុតោៜនន្យទ្ឫឞ្ដិំ កុរុថ? ");
INSERT INTO sankhm_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","យំ យីឝុំ យូយំ បរករេឞុ សមាប៌យត តតោ យំ បីលាតោ មោចយិតុម៑ ឯैច្ឆត៑ តថាបិ យូយំ តស្យ សាក្ឞាន៑ នាង្គីក្ឫតវន្ត ឥព្រាហីម ឥស្ហាកោ យាកូពឝ្ចេឝ្វរោៜរ្ថាទ៑ អស្មាកំ បូវ៌្វបុរុឞាណាម៑ ឦឝ្វរះ ស្វបុត្រស្យ តស្យ យីឝោ រ្មហិមានំ ប្រាកាឝយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","កិន្តុ យូយំ តំ បវិត្រំ ធាម៌្មិកំ បុមាំសំ នាង្គីក្ឫត្យ ហត្យាការិណមេកំ ស្វេភ្យោ ទាតុម៑ អយាចធ្វំ។ ");
INSERT INTO sankhm_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","បឝ្ចាត៑ តំ ជីវនស្យាធិបតិម៑ អហត កិន្ត្វីឝ្វរះ ឝ្មឝានាត៑ តម៑ ឧទស្ថាបយត តត្រ វយំ សាក្ឞិណ អាស្មហេ។ ");
INSERT INTO sankhm_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ឥមំ យំ មានុឞំ យូយំ បឝ្យថ បរិចិនុថ ច ស តស្យ នាម្និ វិឝ្វាសករណាត៑ ចលនឝក្តិំ លព្ធវាន៑ តស្មិន៑ តស្យ យោ វិឝ្វាសះ ស តំ យុឞ្មាកំ សវ៌្វេឞាំ សាក្ឞាត៑ សម្បូណ៌រូបេណ ស្វស្ថម៑ អកាឞ៌ីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","ហេ ភ្រាតរោ យូយំ យុឞ្មាកម៑ អធិបតយឝ្ច អជ្ញាត្វា កម៌្មាណ្យេតានិ ក្ឫតវន្ត ឥទានីំ មមៃឞ ពោធោ ជាយតេ។ ");
INSERT INTO sankhm_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","កិន្ត្វីឝ្វរះ ខ្រីឞ្ដស្យ ទុះខភោគេ ភវិឞ្យទ្វាទិនាំ មុខេភ្យោ យាំ យាំ កថាំ បូវ៌្វមកថយត៑ តាះ កថា ឥត្ថំ សិទ្ធា អករោត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","អតះ ស្វេឞាំ បាបមោចនាត៌្ហំ ខេទំ ក្ឫត្វា មនាំសិ បរិវត៌្តយធ្វំ, តស្មាទ៑ ឦឝ្វរាត៑ សាន្ត្វនាប្រាប្តេះ សមយ ឧបស្ថាស្យតិ; ");
INSERT INTO sankhm_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","បុនឝ្ច បូវ៌្វកាលម៑ អារភ្យ ប្រចារិតោ យោ យីឝុខ្រីឞ្ដស្តម៑ ឦឝ្វរោ យុឞ្មាន៑ ប្រតិ ប្រេឞយិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","កិន្តុ ជគតះ ស្ឫឞ្ដិមារភ្យ ឦឝ្វរោ និជបវិត្រភវិឞ្យទ្វាទិគណោន យថា កថិតវាន៑ តទនុសារេណ សវ៌្វេឞាំ កាយ៌្យាណាំ សិទ្ធិបយ៌្យន្តំ តេន ស្វគ៌េ វាសះ កត៌្តវ្យះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","យុឞ្មាកំ ប្រភុះ បរមេឝ្វរោ យុឞ្មាកំ ភ្រាត្ឫគណមធ្យាត៑ មត្សទ្ឫឝំ ភវិឞ្យទ្វក្តារម៑ ឧត្បាទយិឞ្យតិ, តតះ ស យត៑ កិញ្ចិត៑ កថយិឞ្យតិ តត្រ យូយំ មនាំសិ និធទ្ធ្វំ។ ");
INSERT INTO sankhm_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","កិន្តុ យះ កឝ្ចិត៑ ប្រាណី តស្យ ភវិឞ្យទ្វាទិនះ កថាំ ន គ្រហីឞ្យតិ ស និជលោកានាំ មធ្យាទ៑ ឧច្ឆេត្ស្យតេ,\" ឥមាំ កថាម៑ អស្មាកំ បូវ៌្វបុរុឞេភ្យះ កេវលោ មូសាះ កថយាមាស ឥតិ នហិ, ");
INSERT INTO sankhm_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","ឝិមូយេល្ភវិឞ្យទ្វាទិនម៑ អារភ្យ យាវន្តោ ភវិឞ្យទ្វាក្យម៑ អកថយន៑ តេ សវ៌្វឯវ សមយស្យៃតស្យ កថាម៑ អកថយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","យូយមបិ តេឞាំ ភវិឞ្យទ្វាទិនាំ សន្តានាះ, \"តវ វំឝោទ្ភវបុំសា សវ៌្វទេឝីយា លោកា អាឝិឞំ ប្រាប្តា ភវិឞ្យន្តិ\", ឥព្រាហីមេ កថាមេតាំ កថយិត្វា ឦឝ្វរោស្មាកំ បូវ៌្វបុរុឞៃះ សាទ៌្ធំ យំ និយមំ ស្ថិរីក្ឫតវាន៑ តស្យ និយមស្យាធិការិណោបិ យូយំ ភវថ។ ");
INSERT INTO sankhm_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","អត ឦឝ្វរោ និជបុត្រំ យីឝុម៑ ឧត្ថាប្យ យុឞ្មាកំ សវ៌្វេឞាំ ស្វស្វបាបាត៑ បរាវត៌្ត្យ យុឞ្មភ្យម៑ អាឝិឞំ ទាតុំ ប្រថមតស្តំ យុឞ្មាកំ និកដំ ប្រេឞិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","យស្មិន៑ សមយេ បិតរយោហនៅ លោកាន៑ ឧបទិឝតស្តស្មិន៑ សមយេ យាជកា មន្ទិរស្យ សេនាបតយះ សិទូកីគណឝ្ច ");
INSERT INTO sankhm_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","តយោរ៑ ឧបទេឝករណេ ខ្រីឞ្ដស្យោត្ថានម៑ ឧបលក្ឞ្យ សវ៌្វេឞាំ ម្ឫតានាម៑ ឧត្ថានប្រស្តាវេ ច វ្យគ្រាះ សន្តស្តាវុបាគមន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","តៅ ធ្ឫត្វា ទិនាវសានការណាត៑ បរទិនបយ៌្យនន្តំ រុទ្ធ្វា ស្ថាបិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","តថាបិ យេ លោកាស្តយោរុបទេឝម៑ អឝ្ឫណ្វន៑ តេឞាំ ប្រាយេណ បញ្ចសហស្រាណិ ជនា វ្យឝ្វសន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","បរេៜហនិ អធិបតយះ ប្រាចីនា អធ្យាបកាឝ្ច ហានននាមា មហាយាជកះ ");
INSERT INTO sankhm_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","កិយផា យោហន៑ សិកន្ទរ ឥត្យាទយោ មហាយាជកស្យ ជ្ញាតយះ សវ៌្វេ យិរូឝាលម្នគរេ មិលិតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","អនន្តរំ ប្រេរិតៅ មធ្យេ ស្ថាបយិត្វាប្ឫច្ឆន៑ យុវាំ កយា ឝក្តយា វា កេន នាម្នា កម៌្មាណ្យេតានិ កុរុថះ? ");
INSERT INTO sankhm_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","តទា បិតរះ បវិត្រេណាត្មនា បរិបូណ៌ះ សន៑ ប្រត្យវាទីត៑, ហេ លោកានាម៑ អធិបតិគណ ហេ ឥស្រាយេលីយប្រាចីនាះ, ");
INSERT INTO sankhm_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ឯតស្យ ទុព៌្ពលមានុឞស្យ ហិតំ យត៑ កម៌្មាក្រិយត, អត៌្ហាត៑, ស យេន ប្រការេណ ស្វស្ថោភវត៑ តច្ចេទ៑ អទ្យាវាំ ប្ឫច្ឆថ, ");
INSERT INTO sankhm_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","តហ៌ិ សវ៌្វ ឥស្រាយេेលីយលោកា យូយំ ជានីត នាសរតីយោ យោ យីឝុខ្រីឞ្ដះ ក្រុឝេ យុឞ្មាភិរវិធ្យត យឝ្ចេឝ្វរេណ ឝ្មឝានាទ៑ ឧត្ថាបិតះ, តស្យ នាម្នា ជនោយំ ស្វស្ថះ សន៑ យុឞ្មាកំ សម្មុខេ ប្រោត្តិឞ្ឋតិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","និចេត្ឫភិ រ្យុឞ្មាភិរយំ យះ ប្រស្តរោៜវជ្ញាតោៜភវត៑ ស ប្រធានកោណស្យ ប្រស្តរោៜភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","តទ្ភិន្នាទបរាត៑ កស្មាទបិ បរិត្រាណំ ភវិតុំ ន ឝក្នោតិ, យេន ត្រាណំ ប្រាប្យេត ភូមណ្ឌលស្យលោកានាំ មធ្យេ តាទ្ឫឝំ កិមបិ នាម នាស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","តទា បិតរយោហនោរេតាទ្ឫឝីម៑ អក្ឞេភតាំ ទ្ឫឞ្ដ្វា តាវវិទ្វាំសៅ នីចលោកាវិតិ ពុទ្ធ្វា អាឝ្ចយ៌្យម៑ អមន្យន្ត តៅ ច យីឝោះ សង្គិនៅ ជាតាវិតិ ជ្ញាតុម៑ អឝក្នុវន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","កិន្តុ តាភ្យាំ សាទ៌្ធំ តំ ស្វស្ថមានុឞំ តិឞ្ឋន្តំ ទ្ឫឞ្ដ្វា តេ កាមប្យបរាម៑ អាបត្តិំ កត៌្តំ នាឝក្នុន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","តទា តេ សភាតះ ស្ថានាន្តរំ គន្តុំ តាន៑ អាជ្ញាប្យ ស្វយំ បរស្បរម៑ ឥតិ មន្ត្រណាមកុវ៌្វន្ ");
INSERT INTO sankhm_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","តៅ មានវៅ ប្រតិ កិំ កត៌្តវ្យំ? តាវេកំ ប្រសិទ្ធម៑ អាឝ្ចយ៌្យំ កម៌្ម ក្ឫតវន្តៅ តទ៑ យិរូឝាលម្និវាសិនាំ សវ៌្វេឞាំ លោកានាំ សមីបេ ប្រាកាឝត តច្ច វយមបហ្នោតុំ ន ឝក្នុមះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","កិន្តុ លោកានាំ មធ្យម៑ ឯតទ៑ យថា ន វ្យាប្នោតិ តទត៌្ហំ តៅ ភយំ ប្រទឝ៌្យ តេន នាម្នា កមបិ មនុឞ្យំ នោបទិឝតម៑ ឥតិ ទ្ឫឍំ និឞេធាមះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","តតស្តេ ប្រេរិតាវាហូយ ឯតទាជ្ញាបយន៑ ឥតះ បរំ យីឝោ រ្នាម្នា កទាបិ កាមបិ កថាំ មា កថយតំ កិមបិ នោបទិឝញ្ច។ ");
INSERT INTO sankhm_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","តតះ បិតរយោហនៅ ប្រត្យវទតាម៑ ឦឝ្វរស្យាជ្ញាគ្រហណំ វា យុឞ្មាកម៑ អាជ្ញាគ្រហណម៑ ឯតយោ រ្មធ្យេ ឦឝ្វរស្យ គោចរេ កិំ វិហិតំ? យូយំ តស្យ វិវេចនាំ កុរុត។ ");
INSERT INTO sankhm_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","វយំ យទ៑ អបឝ្យាម យទឝ្ឫណុម ច តន្ន ប្រចារយិឞ្យាម ឯតត៑ កទាបិ ភវិតុំ ន ឝក្នោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","យទឃដត តទ៑ ទ្ឫឞ្ដា សវ៌្វេ លោកា ឦឝ្វរស្យ គុណាន៑ អន្វវទន៑ តស្មាត៑ លោកភយាត៑ តៅ ទណ្ឌយិតុំ កមប្យុបាយំ ន ប្រាប្យ តេ បុនរបិ តជ៌យិត្វា តាវត្យជន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","យស្យ មានុឞស្យៃតត៑ ស្វាស្ថ្យករណម៑ អាឝ្ចយ៌្យំ កម៌្មាក្រិយត តស្យ វយឝ្ចត្វារិំឝទ្វត្សរា វ្យតីតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","តតះ បរំ តៅ វិស្ឫឞ្ដៅ សន្តៅ ស្វសង្គិនាំ សន្និធិំ គត្វា ប្រធានយាជកៃះ ប្រាចីនលោកៃឝ្ច ប្រោក្តាះ សវ៌្វាះ កថា ជ្ញាបិតវន្តៅ។ ");
INSERT INTO sankhm_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","តច្ឆ្រុត្វា សវ៌្វ ឯកចិត្តីភូយ ឦឝ្វរមុទ្ទិឝ្យ ប្រោច្ចៃរេតត៑ ប្រាត៌្ហយន្ត, ហេ ប្រភោ គគណប្ឫថិវីបយោធីនាំ តេឞុ ច យទ្យទ៑ អាស្តេ តេឞាំ ស្រឞ្ដេឝ្វរស្ត្វំ។ ");
INSERT INTO sankhm_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ត្វំ និជសេវកេន ទាយូទា វាក្យមិទម៑ ឧវចិថ, មនុឞ្យា អន្យទេឝីយាះ កុវ៌្វន្តិ កលហំ កុតះ។ លោកាះ សវ៌្វេ កិមត៌្ហំ វា ចិន្តាំ កុវ៌្វន្តិ និឞ្ផលាំ។ ");
INSERT INTO sankhm_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","បរមេឝស្យ តេនៃវាភិឞិក្តស្យ ជនស្យ ច។ វិរុទ្ធមភិតិឞ្ឋន្តិ ប្ឫថិវ្យាះ បតយះ កុតះ៕ ");
INSERT INTO sankhm_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","ផលតស្តវ ហស្តេន មន្ត្រណយា ច បូវ៌្វ យទ្យត៑ ស្ថិរីក្ឫតំ តទ៑ យថា សិទ្ធំ ភវតិ តទត៌្ហំ ត្វំ យម៑ អថិឞិក្តវាន៑ ស ឯវ បវិត្រោ យីឝុស្តស្យ ប្រាតិកូល្យេន ហេរោទ៑ បន្តីយបីលាតោ ");
INSERT INTO sankhm_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ៜន្យទេឝីយលោកា ឥស្រាយេល្លោកាឝ្ច សវ៌្វ ឯតេ សភាយាម៑ អតិឞ្ឋន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ហេ បរមេឝ្វរ អធុនា តេឞាំ តជ៌នំ គជ៌នញ្ច ឝ្ឫណុ; ");
INSERT INTO sankhm_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","តថា ស្វាស្ថ្យករណកម៌្មណា តវ ពាហុពលប្រកាឝបូវ៌្វកំ តវ សេវកាន៑ និព៌្ហយេន តវ វាក្យំ ប្រចារយិតុំ តវ បវិត្របុត្រស្យ យីឝោ រ្នាម្នា អាឝ្ចយ៌្យាណ្យសម្ភវានិ ច កម៌្មាណិ កត៌្តុញ្ចាជ្ញាបយ។ ");
INSERT INTO sankhm_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ឥត្ថំ ប្រាត៌្ហនយា យត្រ ស្ថានេ តេ សភាយាម៑ អាសន៑ តត៑ ស្ថានំ ប្រាកម្បត; តតះ សវ៌្វេ បវិត្រេណាត្មនា បរិបូណ៌ាះ សន្ត ឦឝ្វរស្យ កថាម៑ អក្ឞោភេណ ប្រាចារយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","អបរញ្ច ប្រត្យយការិលោកសមូហា ឯកមនស ឯកចិត្តីភូយ ស្ថិតាះ។ តេឞាំ កេបិ និជសម្បត្តិំ ស្វីយាំ នាជានន៑ កិន្តុ តេឞាំ សវ៌្វាះ សម្បត្ត្យះ សាធារណ្យេន ស្ថិតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","អន្យច្ច ប្រេរិតា មហាឝក្តិប្រកាឝបូវ៌្វកំ ប្រភោ រ្យីឝោរុត្ថានេ សាក្ឞ្យម៑ អទទុះ, តេឞុ សវ៌្វេឞុ មហានុគ្រហោៜភវច្ច។ ");
INSERT INTO sankhm_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","តេឞាំ មធ្យេ កស្យាបិ ទ្រវ្យន្យូនតា នាភវទ៑ យតស្តេឞាំ គ្ឫហភូម្យាទ្យា យាះ សម្បត្តយ អាសន៑ តា វិក្រីយ ");
INSERT INTO sankhm_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","តន្មូល្យមានីយ ប្រេរិតានាំ ចរណេឞុ តៃះ ស្ថាបិតំ; តតះ ប្រត្យេកឝះ ប្រយោជនានុសារេណ ទត្តមភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","វិឝេឞតះ កុប្រោបទ្វីបីយោ យោសិនាមកោ លេវិវំឝជាត ឯកោ ជនោ ភូម្យធិការី, យំ ប្រេរិតា ពណ៌ព្ពា អត៌្ហាត៑ សាន្ត្វនាទាយក ឥត្យុក្ត្វា សមាហូយន៑, ");
INSERT INTO sankhm_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ស ជនោ និជភូមិំ វិក្រីយ តន្មូល្យមានីយ ប្រេរិតានាំ ចរណេឞុ ស្ថាបិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","តទា អនានិយនាមក ឯកោ ជនោ យស្យ ភាយ៌្យាយា នាម សផីរា ស ស្វាធិការំ វិក្រីយ ");
INSERT INTO sankhm_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ស្វភាយ៌្យាំ ជ្ញាបយិត្វា តន្មូល្យស្យៃកាំឝំ សង្គោប្យ ស្ថាបយិត្វា តទន្យាំឝមាត្រមានីយ ប្រេរិតានាំ ចរណេឞុ សមប៌ិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","តស្មាត៑ បិតរោកថយត៑ ហេ អនានិយ ភូមេ រ្មូល្យំ កិញ្ចិត៑ សង្គោប្យ ស្ថាបយិតុំ បវិត្រស្យាត្មនះ សន្និធៅ ម្ឫឞាវាក្យំ កថយិតុញ្ច ឝៃតាន៑ កុតស្តវាន្តះករណេ ប្រវ្ឫត្តិមជនយត៑? ");
INSERT INTO sankhm_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","សា ភូមិ រ្យទា តវ ហស្តគតា តទា កិំ តវ ស្វីយា នាសីត៑? តហ៌ិ ស្វាន្តះករណេ កុត ឯតាទ្ឫឝី កុកល្បនា ត្វយា ក្ឫតា? ត្វំ កេវលមនុឞ្យស្យ និកដេ ម្ឫឞាវាក្យំ នាវាទីះ កិន្ត្វីឝ្វរស្យ និកដេៜបិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ឯតាំ កថាំ ឝ្រុត្វៃវ សោៜនានិយោ ភូមៅ បតន៑ ប្រាណាន៑ អត្យជត៑, តទ្វ្ឫត្តាន្តំ យាវន្តោ លោកា អឝ្ឫណ្វន៑ តេឞាំ សវ៌្វេឞាំ មហាភយម៑ អជាយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","តទា យុវលោកាស្តំ វស្ត្រេណាច្ឆាទ្យ ពហិ រ្នីត្វា ឝ្មឝានេៜស្ថាបយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","តតះ ប្រហរៃកានន្តរំ កិំ វ្ឫត្តំ តន្នាវគត្យ តស្យ ភាយ៌្យាបិ តត្រ សមុបស្ថិតា។ ");
INSERT INTO sankhm_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","តតះ បិតរស្តាម៑ អប្ឫច្ឆត៑, យុវាភ្យាម៑ ឯតាវន្មុទ្រាភ្យោ ភូមិ រ្វិក្រីតា ន វា? ឯតត្វំ វទ; តទា សា ប្រត្យវាទីត៑ សត្យម៑ ឯតាវទ្ភ្យោ មុទ្រាភ្យ ឯវ។ ");
INSERT INTO sankhm_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","តតះ បិតរោកថយត៑ យុវាំ កថំ បរមេឝ្វរស្យាត្មានំ បរីក្ឞិតុម៑ ឯកមន្ត្រណាវភវតាំ? បឝ្យ យេ តវ បតិំ ឝ្មឝានេ ស្ថាបិតវន្តស្តេ ទ្វារស្យ សមីបេ សមុបតិឞ្ឋន្តិ ត្វាមបិ ពហិន៌េឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","តតះ សាបិ តស្យ ចរណសន្និធៅ បតិត្វា ប្រាណាន៑ អត្យាក្ឞីត៑។ បឝ្ចាត៑ តេ យុវានោៜភ្យន្តរម៑ អាគត្យ តាមបិ ម្ឫតាំ ទ្ឫឞ្ដ្វា ពហិ រ្នីត្វា តស្យាះ បត្យុះ បាឝ៌្វេ ឝ្មឝានេ ស្ថាបិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","តស្មាត៑ មណ្ឌល្យាះ សវ៌្វេ លោកា អន្យលោកាឝ្ច តាំ វាត៌្តាំ ឝ្រុត្វា សាធ្វសំ គតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","តតះ បរំ ប្រេរិតានាំ ហស្តៃ រ្លោកានាំ មធ្យេ ពហ្វាឝ្ចយ៌្យាណ្យទ្ភុតានិ កម៌្មាណ្យក្រិយន្ត; តទា ឝិឞ្យាះ សវ៌្វ ឯកចិត្តីភូយ សុលេមានោ ៜលិន្ទេ សម្ភូយាសន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","តេឞាំ សង្ឃាន្តគ៌ោ ភវិតុំ កោបិ ប្រគល្ភតាំ នាគមត៑ កិន្តុ លោកាស្តាន៑ សមាទ្រិយន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","ស្ត្រិយះ បុរុឞាឝ្ច ពហវោ លោកា វិឝ្វាស្យ ប្រភុំ ឝរណមាបន្នាះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","បិតរស្យ គមនាគមនាភ្យាំ កេនាបិ ប្រការេណ តស្យ ឆាយា កស្មិំឝ្ចិជ្ជនេ លគិឞ្យតីត្យាឝយា លោកា រោគិណះ ឝិវិកយា ខដ្វយា ចានីយ បថិ បថិ ស្ថាបិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","ចតុទ៌ិក្ស្ថនគរេភ្យោ ពហវោ លោកាះ សម្ភូយ រោគិណោៜបវិត្រភុតគ្រស្តាំឝ្ច យិរូឝាលមម៑ អានយន៑ តតះ សវ៌្វេ ស្វស្ថា អក្រិយន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","អនន្តរំ មហាយាជកះ សិទូកិនាំ មតគ្រាហិណស្តេឞាំ សហចរាឝ្ច ");
INSERT INTO sankhm_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","មហាក្រោធាន្ត្វិតាះ សន្តះ ប្រេរិតាន៑ ធ្ឫត្វា នីចលោកានាំ ការាយាំ ពទ្ធ្វា ស្ថាបិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","កិន្តុ រាត្រៅ បរមេឝ្វរស្យ ទូតះ ការាយា ទ្វារំ មោចយិត្វា តាន៑ ពហិរានីយាកថយត៑, ");
INSERT INTO sankhm_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","យូយំ គត្វា មន្ទិរេ ទណ្ឌាយមានាះ សន្តោ លោកាន៑ ប្រតីមាំ ជីវនទាយិកាំ សវ៌្វាំ កថាំ ប្រចារយត។ ");
INSERT INTO sankhm_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ឥតិ ឝ្រុត្វា តេ ប្រត្យូឞេ មន្ទិរ ឧបស្ថាយ ឧបទិឞ្ដវន្តះ។ តទា សហចរគណេន សហិតោ មហាយាជក អាគត្យ មន្ត្រិគណម៑ ឥស្រាយេល្វំឝស្យ សវ៌្វាន៑ រាជសភាសទះ សភាស្ថាន៑ ក្ឫត្វា ការាយាស្តាន៑ អាបយិតុំ បទាតិគណំ ប្រេរិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","តតស្តេ គត្វា ការាយាំ តាន៑ អប្រាប្យ ប្រត្យាគត្យ ឥតិ វាត៌្តាម៑ អវាទិឞុះ, ");
INSERT INTO sankhm_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","វយំ តត្រ គត្វា និវ៌្វិឃ្នំ ការាយា ទ្វារំ រុទ្ធំ រក្ឞកាំឝ្ច ទ្វារស្យ ពហិទ៌ណ្ឌាយមានាន៑ អទឝ៌ាម ឯវ កិន្តុ ទ្វារំ មោចយិត្វា តន្មធ្យេ កមបិ ទ្រឞ្ដុំ ន ប្រាប្តាះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ឯតាំ កថាំ ឝ្រុត្វា មហាយាជកោ មន្ទិរស្យ សេនាបតិះ ប្រធានយាជកាឝ្ច, ឥត បរំ កិមបរំ ភវិឞ្យតីតិ ចិន្តយិត្វា សន្ទិគ្ធចិត្តា អភវន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ឯតស្មិន្នេវ សមយេ កឝ្ចិត៑ ជន អាគត្យ វាត៌្តាមេតាម៑ អវទត៑ បឝ្យត យូយំ យាន៑ មានវាន៑ ការាយាម៑ អស្ថាបយត តេ មន្ទិរេ តិឞ្ឋន្តោ លោកាន៑ ឧបទិឝន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","តទា មន្ទិរស្យ សេនាបតិះ បទាតយឝ្ច តត្រ គត្វា ចេល្លោកាះ បាឞាណាន៑ និក្ឞិប្យាស្មាន៑ មារយន្តីតិ ភិយា វិនត្យាចារំ តាន៑ អានយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","តេ មហាសភាយា មធ្យេ តាន៑ អស្ថាបយន៑ តតះ បរំ មហាយាជកស្តាន៑ អប្ឫច្ឆត៑, ");
INSERT INTO sankhm_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","អនេន នាម្នា សមុបទេឞ្ដុំ វយំ កិំ ទ្ឫឍំ ន ន្យឞេធាម? តថាបិ បឝ្យត យូយំ ស្វេឞាំ តេនោបទេឝេនេ យិរូឝាលមំ បរិបូណ៌ំ ក្ឫត្វា តស្យ ជនស្យ រក្តបាតជនិតាបរាធម៑ អស្មាន៑ ប្រត្យានេតុំ ចេឞ្ដធ្វេ។ ");
INSERT INTO sankhm_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","តតះ បិតរោន្យប្រេរិតាឝ្ច ប្រត្យវទន៑ មានុឞស្យាជ្ញាគ្រហណាទ៑ ឦឝ្វរស្យាជ្ញាគ្រហណម៑ អស្មាកមុចិតម៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","យំ យីឝុំ យូយំ ក្រុឝេ វេធិត្វាហត តម៑ អស្មាកំ បៃត្ឫក ឦឝ្វរ ឧត្ថាប្យ ");
INSERT INTO sankhm_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ឥស្រាយេល្វំឝានាំ មនះបរិវត៌្តនំ បាបក្ឞមាញ្ច កត៌្តុំ រាជានំ បរិត្រាតារញ្ច ក្ឫត្វា ស្វទក្ឞិណបាឝ៌្វេ តស្យាន្នតិម៑ អករោត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ឯតស្មិន៑ វយមបិ សាក្ឞិណ អាស្មហេ, តត៑ កេវលំ នហិ, ឦឝ្វរ អាជ្ញាគ្រាហិភ្យោ យំ បវិត្រម៑ អាត្មនំ ទត្តវាន៑ សោបិ សាក្ឞ្យស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","ឯតទ្វាក្យេ ឝ្រុតេ តេឞាំ ហ្ឫទយានិ វិទ្ធាន្យភវន៑ តតស្តេ តាន៑ ហន្តុំ មន្ត្រិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ឯតស្មិន្នេវ សមយេ តត្សភាស្ថានាំ សវ៌្វលោកានាំ មធ្យេ សុខ្យាតោ គមិលីយេល្នាមក ឯកោ ជនោ វ្យវស្ថាបកះ ផិរូឝិលោក ឧត្ថាយ ប្រេរិតាន៑ ក្ឞណាត៌្ហំ ស្ថានាន្តរំ គន្តុម៑ អាទិឝ្យ កថិតវាន៑, ");
INSERT INTO sankhm_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ហេ ឥស្រាយេល្វំឝីយាះ សវ៌្វេ យូយម៑ ឯតាន៑ មានុឞាន៑ ប្រតិ យត៑ កត៌្តុម៑ ឧទ្យតាស្តស្មិន៑ សាវធានា ភវត។ ");
INSERT INTO sankhm_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","ឥតះ បូវ៌្វំ ថូទានាមៃកោ ជន ឧបស្ថាយ ស្វំ កមបិ មហាបុរុឞម៑ អវទត៑, តតះ ប្រាយេណ ចតុះឝតលោកាស្តស្យ មតគ្រាហិណោភវន៑ បឝ្ចាត៑ ស ហតោភវត៑ តស្យាជ្ញាគ្រាហិណោ យាវន្តោ លោកាស្តេ សវ៌្វេ វិក៌ីណ៌ាះ សន្តោ ៜក្ឫតកាយ៌្យា អភវន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","តស្មាជ្ជនាត៑ បរំ នាមលេខនសមយេ គាលីលីយយិហូទានាមៃកោ ជន ឧបស្ថាយ ពហូល្លោកាន៑ ស្វមតំ គ្រាហីតវាន៑ តតះ សោបិ វ្យនឝ្យត៑ តស្យាជ្ញាគ្រាហិណោ យាវន្តោ លោកា អាសន៑ តេ សវ៌្វេ វិកីណ៌ា អភវន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","អធុនា វទាមិ, យូយម៑ ឯតាន៑ មនុឞ្យាន៑ ប្រតិ កិមបិ ន ក្ឫត្វា ក្ឞាន្តា ភវត, យត ឯឞ សង្កល្ប ឯតត៑ កម៌្ម ច យទិ មនុឞ្យាទភវត៑ តហ៌ិ វិផលំ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","យទីឝ្វរាទភវត៑ តហ៌ិ យូយំ តស្យាន្យថា កត៌្តុំ ន ឝក្ឞ្យថ, វរម៑ ឦឝ្វររោធកា ភវិឞ្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","តទា តស្យ មន្ត្រណាំ ស្វីក្ឫត្យ តេ ប្រេរិតាន៑ អាហូយ ប្រហ្ឫត្យ យីឝោ រ្នាម្នា កាមបិ កថាំ កថយិតុំ និឞិធ្យ វ្យសជ៌ន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","កិន្តុ តស្យ នាមាត៌្ហំ វយំ លជ្ជាភោគស្យ យោគ្យត្វេន គណិតា ឥត្យត្រ តេ សានន្ទាះ សន្តះ សភាស្ថានាំ សាក្ឞាទ៑ អគច្ឆន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","តតះ បរំ ប្រតិទិនំ មន្ទិរេ គ្ឫហេ គ្ឫហេ ចាវិឝ្រាមម៑ ឧបទិឝ្យ យីឝុខ្រីឞ្ដស្យ សុសំវាទំ ប្រចារិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","តស្មិន៑ សមយេ ឝិឞ្យាណាំ ពាហុល្យាត៑ ប្រាត្យហិកទានស្យ វិឝ្រាណនៃ រ្ភិន្នទេឝីយានាំ វិធវាស្ត្រីគណ ឧបេក្ឞិតេ សតិ ឥព្រីយលោកៃះ សហាន្យទេឝីយានាំ វិវាទ ឧបាតិឞ្ឋត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","តទា ទ្វាទឝប្រេរិតាះ សវ៌្វាន៑ ឝិឞ្យាន៑ សំគ្ឫហ្យាកថយន៑ ឦឝ្វរស្យ កថាប្រចារំ បរិត្យជ្យ ភោជនគវេឞណម៑ អស្មាកម៑ ឧចិតំ នហិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","អតោ ហេ ភ្រាត្ឫគណ វយម៑ ឯតត្កម៌្មណោ ភារំ យេភ្យោ ទាតុំ ឝក្នុម ឯតាទ្ឫឝាន៑ សុខ្យាត្យាបន្នាន៑ បវិត្រេណាត្មនា ជ្ញានេន ច បូណ៌ាន៑ សប្ប្រជនាន៑ យូយំ ស្វេឞាំ មធ្យេ មនោនីតាន៑ កុរុត, ");
INSERT INTO sankhm_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","កិន្តុ វយំ ប្រាត៌្ហនាយាំ កថាប្រចារកម៌្មណិ ច និត្យប្រវ្ឫត្តាះ ស្ថាស្យាមះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ឯតស្យាំ កថាយាំ សវ៌្វេ លោកាះ សន្តុឞ្ដាះ សន្តះ ស្វេឞាំ មធ្យាត៑ ស្តិផានះ ផិលិបះ ប្រខរោ និកានោរ៑ តីមន៑ បម៌្មិណា យិហូទិមតគ្រាហី-អាន្តិយខិយានគរីយោ និកលា ឯតាន៑ បរមភក្តាន៑ បវិត្រេណាត្មនា បរិបូណ៌ាន៑ សប្ត ជនាន្ ");
INSERT INTO sankhm_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ប្រេរិតានាំ សមក្ឞម៑ អានយន៑, តតស្តេ ប្រាត៌្ហនាំ ក្ឫត្វា តេឞាំ ឝិរះសុ ហស្តាន៑ អាប៌យន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","អបរញ្ច ឦឝ្វរស្យ កថា ទេឝំ វ្យាប្នោត៑ វិឝេឞតោ យិរូឝាលមិ នគរេ ឝិឞ្យាណាំ សំខ្យា ប្រភូតរូបេណាវទ៌្ធត យាជកានាំ មធ្យេបិ ពហវះ ខ្រីឞ្ដមតគ្រាហិណោៜភវន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","ស្តិផានោे វិឝ្វាសេន បរាក្រមេណ ច បរិបូណ៌ះ សន៑ លោកានាំ មធ្យេ ពហុវិធម៑ អទ្ភុតម៑ អាឝ្ចយ៌្យំ កម៌្មាករោត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","តេន លិពត៌្តិនីយនាម្នា វិខ្យាតសង្ឃស្យ កតិបយជនាះ កុរីណីយសិកន្ទរីយ-កិលិកីយាឝីយាទេឝីយាះ កិយន្តោ ជនាឝ្ចោត្ថាយ ស្តិផានេន សាទ៌្ធំ វ្យវទន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","កិន្តុ ស្តិផានោ ជ្ញានេន បវិត្រេណាត្មនា ច ឦទ្ឫឝីំ កថាំ កថិតវាន៑ យស្យាស្តេ អាបត្តិំ កត៌្តុំ នាឝក្នុវន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","បឝ្ចាត៑ តៃ រ្លោភិតាះ កតិបយជនាះ កថាមេនាម៑ អកថយន៑, វយំ តស្យ មុខតោ មូសា ឦឝ្វរស្យ ច និន្ទាវាក្យម៑ អឝ្រៅឞ្ម។ ");
INSERT INTO sankhm_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","តេ លោកានាំ លោកប្រាចីនានាម៑ អធ្យាបកានាញ្ច ប្រវ្ឫត្តិំ ជនយិត្វា ស្តិផានស្យ សន្និធិម៑ អាគត្យ តំ ធ្ឫត្វា មហាសភាមធ្យម៑ អានយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","តទនន្តរំ កតិបយជនេឞុ មិថ្យាសាក្ឞិឞុ សមានីតេឞុ តេៜកថយន៑ ឯឞ ជន ឯតត្បុណ្យស្ថានវ្យវស្ថយោ រ្និន្ទាតះ កទាបិ ន និវត៌្តតេ។ ");
INSERT INTO sankhm_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ផលតោ នាសរតីយយីឝុះ ស្ថានមេតទ៑ ឧច្ឆិន្នំ ករិឞ្យតិ មូសាសមប៌ិតម៑ អស្មាកំ វ្យវហរណម៑ អន្យរូបំ ករិឞ្យតិ តស្យៃតាទ្ឫឝីំ កថាំ វយម៑ អឝ្ឫណុម។ ");
INSERT INTO sankhm_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","តទា មហាសភាស្ថាះ សវ៌្វេ តំ ប្រតិ ស្ថិរាំ ទ្ឫឞ្ដិំ ក្ឫត្វា ស្វគ៌ទូតមុខសទ្ឫឝំ តស្យ មុខម៑ អបឝ្យន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","តតះ បរំ មហាយាជកះ ប្ឫឞ្ដវាន៑, ឯឞា កថាំ កិំ សត្យា? ");
INSERT INTO sankhm_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","តតះ ស ប្រត្យវទត៑, ហេ បិតរោ ហេ ភ្រាតរះ សវ៌្វេ លាកា មនាំសិ និធទ្ធ្វំ។ អស្មាកំ បូវ៌្វបុរុឞ ឥព្រាហីម៑ ហារណ្នគរេ វាសករណាត៑ បូវ៌្វំ យទា អរាម៑-នហរយិមទេឝេ អាសីត៑ តទា តេជោមយ ឦឝ្វរោ ទឝ៌នំ ទត្វា ");
INSERT INTO sankhm_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","តមវទត៑ ត្វំ ស្វទេឝជ្ញាតិមិត្រាណិ បរិត្យជ្យ យំ ទេឝមហំ ទឝ៌យិឞ្យាមិ តំ ទេឝំ វ្រជ។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","អតះ ស កស្ទីយទេឝំ វិហាយ ហារណ្នគរេ ន្យវសត៑, តទនន្តរំ តស្យ បិតរិ ម្ឫតេ យត្រ ទេឝេ យូយំ និវសថ ស ឯនំ ទេឝមាគច្ឆត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","កិន្ត្វីឝ្វរស្តស្មៃ កមប្យធិការម៑ អត៌្ហាទ៑ ឯកបទបរិមិតាំ ភូមិមបិ នាទទាត៑; តទា តស្យ កោបិ សន្តានោ នាសីត៑ តថាបិ សន្តានៃះ សាទ៌្ធម៑ ឯតស្យ ទេឝស្យាធិការី ត្វំ ភវិឞ្យសីតិ តម្ប្រត្យង្គីក្ឫតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ឦឝ្វរ ឥត្ថម៑ អបរមបិ កថិតវាន៑ តវ សន្តានាះ បរទេឝេ និវត្ស្យន្តិ តតស្តទ្ទេឝីយលោកាឝ្ចតុះឝតវត្សរាន៑ យាវត៑ តាន៑ ទាសត្វេ ស្ថាបយិត្វា តាន៑ ប្រតិ កុវ្យវហារំ ករិឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","អបរម៑ ឦឝ្វរ ឯនាំ កថាមបិ កថិតវាន៑, យេ លោកាស្តាន៑ ទាសត្វេ ស្ថាបយិឞ្យន្តិ តាល្លោកាន៑ អហំ ទណ្ឌយិឞ្យាមិ, តតះ បរំ តេ ពហិគ៌តាះ សន្តោ មាម៑ អត្រ ស្ថានេ សេវិឞ្យន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","បឝ្ចាត៑ ស តស្មៃ ត្វក្ឆេទស្យ និយមំ ទត្តវាន៑, អត ឥស្ហាកនាម្និ ឥព្រាហីម ឯកបុត្រេ ជាតេ, អឞ្ដមទិនេ តស្យ ត្វក្ឆេទម៑ អករោត៑។ តស្យ ឥស្ហាកះ បុត្រោ យាកូព៑, តតស្តស្យ យាកូពោៜស្មាកំ ទ្វាទឝ បូវ៌្វបុរុឞា អជាយន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","តេ បូវ៌្វបុរុឞា ឦឞ៌្យយា បរិបូណ៌ា មិសរទេឝំ ប្រេឞយិតុំ យូឞផំ វ្យក្រីណន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","កិន្ត្វីឝ្វរស្តស្យ សហាយោ ភូត្វា សវ៌្វស្យា ទុគ៌តេ រក្ឞិត្វា តស្មៃ ពុទ្ធិំ ទត្ត្វា មិសរទេឝស្យ រាជ្ញះ ផិរៅណះ ប្រិយបាត្រំ ក្ឫតវាន៑ តតោ រាជា មិសរទេឝស្យ ស្វីយសវ៌្វបរិវារស្យ ច ឝាសនបទំ តស្មៃ ទត្តវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","តស្មិន៑ សមយេ មិសរ-កិនានទេឝយោ រ្ទុព៌្ហិក្ឞហេតោរតិក្លិឞ្ដត្វាត៑ នះ បូវ៌្វបុរុឞា ភក្ឞ្យទ្រវ្យំ នាលភន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","កិន្តុ មិសរទេឝេ ឝស្យានិ សន្តិ, យាកូព៑ ឥមាំ វាត៌្តាំ ឝ្រុត្វា ប្រថមម៑ អស្មាកំ បូវ៌្វបុរុឞាន៑ មិសរំ ប្រេឞិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","តតោ ទ្វិតីយវារគមនេ យូឞផ៑ ស្វភ្រាត្ឫភិះ បរិចិតោៜភវត៑; យូឞផោ ភ្រាតរះ ផិរៅណ៑ រាជេន បរិចិតា អភវន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","អនន្តរំ យូឞផ៑ ភ្រាត្ឫគណំ ប្រេឞ្យ និជបិតរំ យាកូពំ និជាន៑ បញ្ចាធិកសប្តតិសំខ្យកាន៑ ជ្ញាតិជនាំឝ្ច សមាហូតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","តស្មាទ៑ យាកូព៑ មិសរទេឝំ គត្វា ស្វយម៑ អស្មាកំ បូវ៌្វបុរុឞាឝ្ច តស្មិន៑ ស្ថានេៜម្រិយន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","តតស្តេ ឝិខិមំ នីតា យត៑ ឝ្មឝានម៑ ឥព្រាហីម៑ មុទ្រាទត្វា ឝិខិមះ បិតុ រ្ហមោរះ បុត្រេភ្យះ ក្រីតវាន៑ តត្ឝ្មឝានេ ស្ថាបយាញ្ចក្រិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","តតះ បរម៑ ឦឝ្វរ ឥព្រាហីមះ សន្និធៅ ឝបថំ ក្ឫត្វា យាំ ប្រតិជ្ញាំ ក្ឫតវាន៑ តស្យាះ ប្រតិជ្ញាយាះ ផលនសមយេ និកដេ សតិ ឥស្រាយេល្លោកា សិមរទេឝេ វទ៌្ធមានា ពហុសំខ្យា អភវន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ឝេឞេ យូឞផំ យោ ន បរិចិនោតិ តាទ្ឫឝ ឯកោ នរបតិរុបស្ថាយ ");
INSERT INTO sankhm_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","អស្មាកំ ជ្ញាតិភិះ សាទ៌្ធំ ធូត៌្តតាំ វិធាយ បូវ៌្វបុរុឞាន៑ ប្រតិ កុវ្យវហរណបូវ៌្វកំ តេឞាំ វំឝនាឝនាយ តេឞាំ នវជាតាន៑ ឝិឝូន៑ ពហិ រ្និរក្ឞេបយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","ឯតស្មិន៑ សមយេ មូសា ជជ្ញេ, ស តុ បរមសុន្ទរោៜភវត៑ តថា បិត្ឫគ្ឫហេ មាសត្រយបយ៌្យន្តំ បាលិតោៜភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","កិន្តុ តស្មិន៑ ពហិន៌ិក្ឞិប្តេ សតិ ផិរៅណរាជស្យ កន្យា តម៑ ឧត្តោល្យ នីត្វា ទត្តកបុត្រំ ក្ឫត្វា បាលិតវតី។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","តស្មាត៑ ស មូសា មិសរទេឝីយាយាះ សវ៌្វវិទ្យាយាះ បារទ្ឫឞ្វា សន៑ វាក្យេ ក្រិយាយាញ្ច ឝក្តិមាន៑ អភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","ស សម្បូណ៌ចត្វារិំឝទ្វត្សរវយស្កោ ភូត្វា ឥស្រាយេលីយវំឝនិជភ្រាត្ឫន៑ សាក្ឞាត៑ កត៌ុំ មតិំ ចក្រេ។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","តេឞាំ ជនមេកំ ហិំសិតំ ទ្ឫឞ្ដ្វា តស្យ សបក្ឞះ សន៑ ហិំសិតជនម៑ ឧបក្ឫត្យ មិសរីយជនំ ជឃាន។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","តស្យ ហស្តេនេឝ្វរស្តាន៑ ឧទ្ធរិឞ្យតិ តស្យ ភ្រាត្ឫគណ ឥតិ ជ្ញាស្យតិ ស ឥត្យនុមានំ ចការ, កិន្តុ តេ ន ពុពុធិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","តត្បរេ ៜហនិ តេឞាម៑ ឧភយោ រ្ជនយោ រ្វាក្កលហ ឧបស្ថិតេ សតិ មូសាះ សមីបំ គត្វា តយោ រ្មេលនំ កត៌្តុំ មតិំ ក្ឫត្វា កថយាមាស, ហេ មហាឝយៅ យុវាំ ភ្រាតរៅ បរស្បរម៑ អន្យាយំ កុតះ កុរុថះ? ");
INSERT INTO sankhm_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","តតះ សមីបវាសិនំ ប្រតិ យោ ជនោៜន្យាយំ ចការ ស តំ ទូរីក្ឫត្យ កថយាមាស, អស្មាកមុបរិ ឝាស្ត្ឫត្វវិចារយិត្ឫត្វបទយោះ កស្ត្វាំ និយុក្តវាន៑? ");
INSERT INTO sankhm_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","ហ្យោ យថា មិសរីយំ ហតវាន៑ តថា កិំ មាមបិ ហនិឞ្យសិ? ");
INSERT INTO sankhm_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","តទា មូសា ឯតាទ្ឫឝីំ កថាំ ឝ្រុត្វា បលាយនំ ចក្រេ, តតោ មិទិយនទេឝំ គត្វា ប្រវាសី សន៑ តស្ថៅ, តតស្តត្រ ទ្វៅ បុត្រៅ ជជ្ញាតេ។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","អនន្តរំ ចត្វារិំឝទ្វត្សរេឞុ គតេឞុ សីនយបវ៌្វតស្យ ប្រាន្តរេ ប្រជ្វលិតស្តម្ពស្យ វហ្និឝិខាយាំ បរមេឝ្វរទូតស្តស្មៃ ទឝ៌នំ ទទៅ។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","មូសាស្តស្មិន៑ ទឝ៌នេ វិស្មយំ មត្វា វិឝេឞំ ជ្ញាតុំ និកដំ គច្ឆតិ, ");
INSERT INTO sankhm_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","ឯតស្មិន៑ សមយេ, អហំ តវ បូវ៌្វបុរុឞាណាម៑ ឦឝ្វរោៜរ្ថាទ៑ ឥព្រាហីម ឦឝ្វរ ឥស្ហាក ឦឝ្វរោ យាកូព ឦឝ្វរឝ្ច, មូសាមុទ្ទិឝ្យ បរមេឝ្វរស្យៃតាទ្ឫឝី វិហាយសីយា វាណី ពភូវ, តតះ ស កម្បាន្វិតះ សន៑ បុន រ្និរីក្ឞិតុំ ប្រគល្ភោ ន ពភូវ។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","បរមេឝ្វរស្តំ ជគាទ, តវ បាទយោះ បាទុកេ មោចយ យត្រ តិឞ្ឋសិ សា បវិត្រភូមិះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","អហំ មិសរទេឝស្ថានាំ និជលោកានាំ ទុទ៌្ទឝាំ និតាន្តម៑ អបឝ្យំ, តេឞាំ កាតយ៌្យោក្តិញ្ច ឝ្រុតវាន៑ តស្មាត៑ តាន៑ ឧទ្ធត៌្តុម៑ អវរុហ្យាគមម៑; ឥទានីម៑ អាគច្ឆ មិសរទេឝំ ត្វាំ ប្រេឞយាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","កស្ត្វាំ ឝាស្ត្ឫត្វវិចារយិត្ឫត្វបទយោ រ្និយុក្តវាន៑, ឥតិ វាក្យមុក្ត្វា តៃ រ្យោ មូសា អវជ្ញាតស្តមេវ ឦឝ្វរះ ស្តម្ពមធ្យេ ទឝ៌នទាត្រា តេន ទូតេន ឝាស្តារំ មុក្តិទាតារញ្ច ក្ឫត្វា ប្រេឞយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","ស ច មិសរទេឝេ សូផ្នាម្និ សមុទ្រេ ច បឝ្ចាត៑ ចត្វារិំឝទ្វត្សរាន៑ យាវត៑ មហាប្រាន្តរេ នានាប្រការាណ្យទ្ភុតានិ កម៌្មាណិ លក្ឞណានិ ច ទឝ៌យិត្វា តាន៑ ពហិះ ក្ឫត្វា សមានិនាយ។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","ប្រភុះ បរមេឝ្វរោ យុឞ្មាកំ ភ្រាត្ឫគណស្យ មធ្យេ មាទ្ឫឝម៑ ឯកំ ភវិឞ្យទ្វក្តារម៑ ឧត្បាទយិឞ្យតិ តស្យ កថាយាំ យូយំ មនោ និធាស្យថ, យោ ជន ឥស្រាយេលះ សន្តានេភ្យ ឯនាំ កថាំ កថយាមាស ស ឯឞ មូសាះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","មហាប្រាន្តរស្ថមណ្ឌលីមធ្យេៜបិ ស ឯវ សីនយបវ៌្វតោបរិ តេន សាទ៌្ធំ សំលាបិនោ ទូតស្យ ចាស្មត្បិត្ឫគណស្យ មធ្យស្ថះ សន៑ អស្មភ្យំ ទាតវ្យនិ ជីវនទាយកានិ វាក្យានិ លេភេ។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","អស្មាកំ បូវ៌្វបុរុឞាស្តម៑ អមាន្យំ កត្វា ស្វេភ្យោ ទូរីក្ឫត្យ មិសរទេឝំ បរាវ្ឫត្យ គន្តុំ មនោភិរភិលឞ្យ ហារោណំ ជគទុះ, ");
INSERT INTO sankhm_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","អស្មាកម៑ អគ្រេៜគ្រេ គន្តុुម៑ អស្មទត៌្ហំ ទេវគណំ និម៌្មាហិ យតោ យោ មូសា អស្មាន៑ មិសរទេឝាទ៑ ពហិះ ក្ឫត្វានីតវាន៑ តស្យ កិំ ជាតំ តទស្មាភិ រ្ន ជ្ញាយតេ។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","តស្មិន៑ សមយេ តេ គោវត្សាក្ឫតិំ ប្រតិមាំ និម៌្មាយ តាមុទ្ទិឝ្យ នៃវេទ្យមុត្ម្ឫជ្យ ស្វហស្តក្ឫតវស្តុនា អានន្ទិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","តស្មាទ៑ ឦឝ្វរស្តេឞាំ ប្រតិ វិមុខះ សន៑ អាកាឝស្ថំ ជ្យោតិគ៌ណំ បូជយិតុំ តេភ្យោៜនុមតិំ ទទៅ, យាទ្ឫឝំ ភវិឞ្យទ្វាទិនាំ គ្រន្ថេឞុ លិខិតមាស្តេ, យថា, ឥស្រាយេលីយវំឝា រេ ចត្វារិំឝត្សមាន៑ បុរា។ មហតិ ប្រាន្តរេ សំស្ថា យូយន្តុ យានិ ច។ ពលិហោមាទិកម៌្មាណិ ក្ឫតវន្តស្តុ តានិ កិំ។ មាំ សមុទ្ទិឝ្យ យុឞ្មាភិះ ប្រក្ឫតានីតិ នៃវ ច។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","កិន្តុ វោ មោលកាខ្យស្យ ទេវស្យ ទូឞ្យមេវ ច។ យុឞ្មាកំ រិម្ផនាខ្យាយា ទេវតាយាឝ្ច តារកា។ ឯតយោរុភយោ រ្មូត៌ី យុឞ្មាភិះ បរិបូជិតេ។ អតោ យុឞ្មាំស្តុ ពាពេលះ បារំ នេឞ្យាមិ និឝ្ចិតំ។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","អបរញ្ច យន្និទឝ៌នម៑ អបឝ្យស្តទនុសារេណ ទូឞ្យំ និម៌្មាហិ យស្មិន៑ ឦឝ្វរោ មូសាម៑ ឯតទ្វាក្យំ ពភាឞេ តត៑ តស្យ និរូបិតំ សាក្ឞ្យស្វរូបំ ទូឞ្យម៑ អស្មាកំ បូវ៌្វបុរុឞៃះ សហ ប្រាន្តរេ តស្ថៅ។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","បឝ្ចាត៑ យិហោឝូយេន សហិតៃស្តេឞាំ វំឝជាតៃរស្មត្បូវ៌្វបុរុឞៃះ ស្វេឞាំ សម្មុខាទ៑ ឦឝ្វរេណ ទូរីក្ឫតានាម៑ អន្យទេឝីយានាំ ទេឝាធិក្ឫតិកាលេ សមានីតំ តទ៑ ទូឞ្យំ ទាយូទោធិការំ យាវត៑ តត្រ ស្ថាន អាសីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ស ទាយូទ៑ បរមេឝ្វរស្យានុគ្រហំ ប្រាប្យ យាកូព៑ ឦឝ្វរាត៌្ហម៑ ឯកំ ទូឞ្យំ និម៌្មាតុំ វវាញ្ឆ; ");
INSERT INTO sankhm_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","កិន្តុ សុលេមាន៑ តទត៌្ហំ មន្ទិរម៑ ឯកំ និម៌្មិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","តថាបិ យះ សវ៌្វោបរិស្ថះ ស កស្មិំឝ្ចិទ៑ ហស្តក្ឫតេ មន្ទិរេ និវសតីតិ នហិ, ភវិឞ្យទ្វាទី កថាមេតាំ កថយតិ, យថា, ");
INSERT INTO sankhm_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","បរេឝោ វទតិ ស្វគ៌ោ រាជសិំហាសនំ មម។ មទីយំ បាទបីឋញ្ច ប្ឫថិវី ភវតិ ធ្រុវំ។ តហ៌ិ យូយំ ក្ឫតេ មេ កិំ ប្រនិម៌្មាស្យថ មន្ទិរំ។ វិឝ្រាមាយ មទីយំ វា ស្ថានំ កិំ វិទ្យតេ ត្វិហ។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","សវ៌្វាណ្យេតានិ វស្តូនិ កិំ មេ ហស្តក្ឫតានិ ន៕ ");
INSERT INTO sankhm_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","ហេ អនាជ្ញាគ្រាហកា អន្តះករណេ ឝ្រវណេ ចាបវិត្រលោកាះ យូយម៑ អនវរតំ បវិត្រស្យាត្មនះ ប្រាតិកូល្យម៑ អាចរថ, យុឞ្មាកំ បូវ៌្វបុរុឞា យាទ្ឫឝា យូយមបិ តាទ្ឫឝាះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","យុឞ្មាកំ បូវ៌្វបុរុឞាះ កំ ភវិឞ្យទ្វាទិនំ នាតាឌយន៑? យេ តស្យ ធាម៌្មិកស្យ ជនស្យាគមនកថាំ កថិតវន្តស្តាន៑ អឃ្នន៑ យូយម៑ អធូនា វិឝ្វាសឃាតិនោ ភូត្វា តំ ធាម៌្មិកំ ជនម៑ អហត។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","យូយំ ស្វគ៌ីយទូតគណេន វ្យវស្ថាំ ប្រាប្យាបិ តាំ នាចរថ។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ឥមាំ កថាំ ឝ្រុត្វា តេ មនះសុ ពិទ្ធាះ សន្តស្តំ ប្រតិ ទន្តឃឞ៌ណម៑ អកុវ៌្វន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","កិន្តុ ស្តិផានះ បវិត្រេណាត្មនា បូណ៌ោ ភូត្វា គគណំ ប្រតិ ស្ថិរទ្ឫឞ្ដិំ ក្ឫត្វា ឦឝ្វរស្យ ទក្ឞិណេ ទណ្ឌាយមានំ យីឝុញ្ច វិលោក្យ កថិតវាន៑; ");
INSERT INTO sankhm_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","បឝ្យ,មេឃទ្វារំ មុក្តម៑ ឦឝ្វរស្យ ទក្ឞិណេ ស្ថិតំ មានវសុតញ្ច បឝ្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","តទា តេ ប្រោច្ចៃះ ឝព្ទំ ក្ឫត្វា កណ៌េឞ្វង្គុលី រ្និធាយ ឯកចិត្តីភូយ តម៑ អាក្រមន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","បឝ្ចាត៑ តំ នគរាទ៑ ពហិះ ក្ឫត្វា ប្រស្តរៃរាឃ្នន៑ សាក្ឞិណោ លាកាះ ឝៅលនាម្នោ យូនឝ្ចរណសន្និធៅ និជវស្ត្រាណិ ស្ថាបិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","អនន្តរំ ហេ ប្រភោ យីឝេ មទីយមាត្មានំ គ្ឫហាណ ស្តិផានស្យេតិ ប្រាត៌្ហនវាក្យវទនសមយេ តេ តំ ប្រស្តរៃរាឃ្នន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","តស្មាត៑ ស ជានុនី បាតយិត្វា ប្រោច្ចៃះ ឝព្ទំ ក្ឫត្វា, ហេ ប្រភេ បាបមេតទ៑ ឯតេឞុ មា ស្ថាបយ, ឥត្យុក្ត្វា មហានិទ្រាំ ប្រាប្នោត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","តស្យ ហត្យាករណំ ឝៅលោបិ សមមន្យត។ តស្មិន៑ សមយេ យិរូឝាលម្នគរស្ថាំ មណ្ឌលីំ ប្រតិ មហាតាឌនាយាំ ជាតាយាំ ប្រេរិតលោកាន៑ ហិត្វា សវ៌្វេៜបរេ យិហូទាឝោមិរោណទេឝយោ រ្នានាស្ថានេ វិកីណ៌ាះ សន្តោ គតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","អន្យច្ច ភក្តលោកាស្តំ ស្តិផានំ ឝ្មឝានេ ស្ថាបយិត្វា ពហុ វ្យលបន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","កិន្តុ ឝៅលោ គ្ឫហេ គ្ឫហេ ភ្រមិត្វា ស្ត្រិយះ បុរុឞាំឝ្ច ធ្ឫត្វា ការាយាំ ពទ្ធ្វា មណ្ឌល្យា មហោត្បាតំ ក្ឫតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","អន្យច្ច យេ វិកីណ៌ា អភវន៑ តេ សវ៌្វត្រ ភ្រមិត្វា សុសំវាទំ ប្រាចារយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","តទា ផិលិបះ ឝោមិរោណ្នគរំ គត្វា ខ្រីឞ្ដាខ្យានំ ប្រាចារយត៑; ");
INSERT INTO sankhm_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","តតោៜឝុចិ-ភ្ឫតគ្រស្តលោកេភ្យោ ភូតាឝ្ចីត្ក្ឫត្យាគច្ឆន៑ តថា ពហវះ បក្ឞាឃាតិនះ ខញ្ជា លោកាឝ្ច ស្វស្ថា អភវន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","តស្មាត៑ លាកា ឦទ្ឫឝំ តស្យាឝ្ចយ៌្យំ កម៌្ម វិលោក្យ និឝម្យ ច សវ៌្វ ឯកចិត្តីភូយ តេនោក្តាខ្យានេ មនាំសិ ន្យទធុះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","តស្មិន្នគរេ មហានន្ទឝ្ចាភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","តតះ បូវ៌្វំ តស្មិន្នគរេ ឝិមោន្នាមា កឝ្ចិជ្ជនោ ពហ្វី រ្មាយាក្រិយាះ ក្ឫត្វា ស្វំ កញ្ចន មហាបុរុឞំ ប្រោច្យ ឝោមិរោណីយានាំ មោហំ ជនយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","តស្មាត៑ ស មានុឞ ឦឝ្វរស្យ មហាឝក្តិស្វរូប ឥត្យុក្ត្វា ពាលវ្ឫទ្ធវនិតាះ សវ៌្វេ លាកាស្តស្មិន៑ មនាំសិ ន្យទធុះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ស ពហុកាលាន៑ មាយាវិក្រិយយា សវ៌្វាន៑ អតីវ មោហយាញ្ចការ, តស្មាត៑ តេ តំ មេនិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","កិន្ត្វីឝ្វរស្យ រាជ្យស្យ យីឝុខ្រីឞ្ដស្យ នាម្នឝ្ចាខ្យានប្រចារិណះ ផិលិបស្យ កថាយាំ វិឝ្វស្យ តេឞាំ ស្ត្រីបុរុឞោភយលោកា មជ្ជិតា អភវន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ឝេឞេ ស ឝិមោនបិ ស្វយំ ប្រត្យៃត៑ តតោ មជ្ជិតះ សន៑ ផិលិបេន ក្ឫតាម៑ អាឝ្ចយ៌្យក្រិយាំ លក្ឞណញ្ច វិលោក្យាសម្ភវំ មន្យមានស្តេន សហ ស្ថិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ឥត្ថំ ឝោមិរោណ្ទេឝីយលោកា ឦឝ្វរស្យ កថាម៑ អគ្ឫហ្លន៑ ឥតិ វាត៌្តាំ យិរូឝាលម្នគរស្ថប្រេរិតាះ ប្រាប្យ បិតរំ យោហនញ្ច តេឞាំ និកដេ ប្រេឞិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","តតស្តៅ តត៑ ស្ថានម៑ ឧបស្ថាយ លោកា យថា បវិត្រម៑ អាត្មានំ ប្រាប្នុវន្តិ តទត៌្ហំ ប្រាត៌្ហយេតាំ។ ");
INSERT INTO sankhm_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","យតស្តេ បុរា កេវលប្រភុយីឝោ រ្នាម្នា មជ្ជិតមាត្រា អភវន៑, ន តុ តេឞាំ មធ្យេ កមបិ ប្រតិ បវិត្រស្យាត្មន អាវិព៌្ហាវោ ជាតះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","កិន្តុ ប្រេរិតាភ្យាំ តេឞាំ គាត្រេឞុ ករេឞ្វប៌ិតេឞុ សត្សុ តេ បវិត្រម៑ អាត្មានម៑ ប្រាប្នុវន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","ឥត្ថំ លោកានាំ គាត្រេឞុ ប្រេរិតយោះ ករាប៌ណេន តាន៑ បវិត្រម៑ អាត្មានំ ប្រាប្តាន៑ ទ្ឫឞ្ដ្វា ស ឝិមោន៑ តយោះ សមីបេ មុទ្រា អានីយ កថិតវាន៑; ");
INSERT INTO sankhm_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","អហំ យស្យ គាត្រេ ហស្តម៑ អប៌យិឞ្យាមិ តស្យាបិ យថេត្ថំ បវិត្រាត្មប្រាប្តិ រ្ភវតិ តាទ្ឫឝីំ ឝក្តិំ មហ្យំ ទត្តំ។ ");
INSERT INTO sankhm_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","កិន្តុ បិតរស្តំ ប្រត្យវទត៑ តវ មុទ្រាស្ត្វយា វិនឝ្យន្តុ យត ឦឝ្វរស្យ ទានំ មុទ្រាភិះ ក្រីយតេ ត្វមិត្ថំ ពុទ្ធវាន៑; ");
INSERT INTO sankhm_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ឦឝ្វរាយ តាវន្តះករណំ សរលំ នហិ, តស្មាទ៑ អត្រ តវាំឝោៜធិការឝ្ច កោបិ នាស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","អត ឯតត្បាបហេតោះ ខេទាន្វិតះ សន៑ កេនាបិ ប្រការេណ តវ មនស ឯតស្យាះ កុកល្បនាយាះ ក្ឞមា ភវតិ, ឯតទត៌្ហម៑ ឦឝ្វរេ ប្រាត៌្ហនាំ កុរុ; ");
INSERT INTO sankhm_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","យតស្ត្វំ តិក្តបិត្តេ បាបស្យ ពន្ធនេ ច យទសិ តន្មយា ពុទ្ធម៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","តទា ឝិមោន៑ អកថយត៑ តហ៌ិ យុវាភ្យាមុទិតា កថា មយិ យថា ន ផលតិ តទត៌្ហំ យុវាំ មន្និមិត្តំ ប្រភៅ ប្រាត៌្ហនាំ កុរុតំ។ ");
INSERT INTO sankhm_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","អនេន ប្រការេណ តៅ សាក្ឞ្យំ ទត្ត្វា ប្រភោះ កថាំ ប្រចារយន្តៅ ឝោមិរោណីយានាម៑ អនេកគ្រាមេឞុ សុសំវាទញ្ច ប្រចារយន្តៅ យិរូឝាលម្នគរំ បរាវ្ឫត្យ គតៅ។ ");
INSERT INTO sankhm_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","តតះ បរម៑ ឦឝ្វរស្យ ទូតះ ផិលិបម៑ ឥត្យាទិឝត៑, ត្វមុត្ថាយ ទក្ឞិណស្យាំ ទិឝិ យោ មាគ៌ោ ប្រាន្តរស្យ មធ្យេន យិរូឝាលមោ ៜសានគរំ យាតិ តំ មាគ៌ំ គច្ឆ។ ");
INSERT INTO sankhm_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","តតះ ស ឧត្ថាយ គតវាន៑; តទា កន្ទាកីនាម្នះ កូឝ្លោកានាំ រាជ្ញ្យាះ សវ៌្វសម្បត្តេរធីឝះ កូឝទេឝីយ ឯកះ ឞណ្ឌោ ភជនាត៌្ហំ យិរូឝាលម្នគរម៑ អាគត្យ ");
INSERT INTO sankhm_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","បុនរបិ រថមារុហ្យ យិឝយិយនាម្នោ ភវិឞ្យទ្វាទិនោ គ្រន្ថំ បឋន៑ ប្រត្យាគច្ឆតិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ឯតស្មិន៑ សមយេ អាត្មា ផិលិបម៑ អវទត៑, ត្វម៑ រថស្យ សមីបំ គត្វា តេន សាទ៌្ធំ មិល។ ");
INSERT INTO sankhm_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","តស្មាត៑ ស ធាវន៑ តស្យ សន្និធាវុបស្ថាយ តេន បឋ្យមានំ យិឝយិយថវិឞ្យទ្វាទិនោ វាក្យំ ឝ្រុត្វា ប្ឫឞ្ដវាន៑ យត៑ បឋសិ តត៑ កិំ ពុធ្យសេ? ");
INSERT INTO sankhm_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","តតះ ស កថិតវាន៑ កេនចិន្ន ពោធិតោហំ កថំ ពុធ្យេយ? តតះ ស ផិលិបំ រថមារោឍុំ ស្វេន សាទ៌្ធម៑ ឧបវេឞ្ដុញ្ច ន្យវេទយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ស ឝាស្ត្រស្យេតទ្វាក្យំ បឋិតវាន៑ យថា, សមានីយត ឃាតាយ ស យថា មេឞឝាវកះ។ លោមច្ឆេទកសាក្ឞាច្ច មេឞឝ្ច នីរវោ យថា។ អាពធ្យ វទនំ ស្វីយំ តថា ស សមតិឞ្ឋត។ ");
INSERT INTO sankhm_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","អន្យាយេន វិចារេណ ស ឧច្ឆិន្នោ ៜភវត៑ តទា។ តត្កាលីនមនុឞ្យាន៑ កោ ជនោ វណ៌យិតុំ ក្ឞមះ។ យតោ ជីវន្ន្ឫណាំ ទេឝាត៑ ស ឧច្ឆិន្នោ ៜភវត៑ ធ្រុវំ។ ");
INSERT INTO sankhm_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","អនន្តរំ ស ផិលិបម៑ អវទត៑ និវេទយាមិ, ភវិឞ្យទ្វាទី យាមិមាំ កថាំ កថយាមាស ស កិំ ស្វស្មិន៑ វា កស្មិំឝ្ចិទ៑ អន្យស្មិន៑? ");
INSERT INTO sankhm_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","តតះ ផិលិបស្តត្ប្រករណម៑ អារភ្យ យីឝោរុបាខ្យានំ តស្យាគ្រេ ប្រាស្តៅត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ឥត្ថំ មាគ៌េណ គច្ឆន្តៅ ជលាឝយស្យ សមីប ឧបស្ថិតៅ; តទា ក្លីពោៜវាទីត៑ បឝ្យាត្រ ស្ថានេ ជលមាស្តេ មម មជ្ជនេ កា ពាធា? ");
INSERT INTO sankhm_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","តតះ ផិលិប ឧត្តរំ វ្យាហរត៑ ស្វាន្តះករណេន សាកំ យទិ ប្រត្យេឞិ តហ៌ិ ពាធា នាស្តិ។ តតះ ស កថិតវាន៑ យីឝុខ្រីឞ្ដ ឦឝ្វរស្យ បុត្រ ឥត្យហំ ប្រត្យេមិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","តទា រថំ ស្ថគិតំ កត៌្តុម៑ អាទិឞ្ដេ ផិលិបក្លីពៅ ទ្វៅ ជលម៑ អវារុហតាំ; តទា ផិលិបស្តម៑ មជ្ជយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","តត្បឝ្ចាត៑ ជលមធ្យាទ៑ ឧត្ថិតយោះ សតោះ បរមេឝ្វរស្យាត្មា ផិលិបំ ហ្ឫត្វា នីតវាន៑, តស្មាត៑ ក្លីពះ បុនស្តំ ន ទ្ឫឞ្ដវាន៑ តថាបិ ហ្ឫឞ្ដចិត្តះ សន៑ ស្វមាគ៌េណ គតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ផិលិបឝ្ចាស្ទោទ្នគរម៑ ឧបស្ថាយ តស្មាត៑ កៃសរិយានគរ ឧបស្ថិតិកាលបយ៌្យនតំ សវ៌្វស្មិន្នគរេ សុសំវាទំ ប្រចារយន៑ គតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","តត្កាលបយ៌្យនតំ ឝៅលះ ប្រភោះ ឝិឞ្យាណាំ ប្រាតិកូល្យេន តាឌនាពធយោះ កថាំ និះសារយន៑ មហាយាជកស្យ សន្និធិំ គត្វា ");
INSERT INTO sankhm_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ស្ត្រិយំ បុរុឞញ្ច តន្មតគ្រាហិណំ យំ កញ្ចិត៑ បឝ្យតិ តាន៑ ធ្ឫត្វា ពទ្ធ្វា យិរូឝាលមម៑ អានយតីត្យាឝយេន ទម្មេឞក្នគរីយំ ធម៌្មសមាជាន៑ ប្រតិ បត្រំ យាចិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","គច្ឆន៑ តុ ទម្មេឞក្នគរនិកដ ឧបស្ថិតវាន៑; តតោៜកស្មាទ៑ អាកាឝាត៑ តស្យ ចតុទ៌ិក្ឞុ តេជសះ ប្រកាឝនាត៑ ស ភូមាវបតត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","បឝ្ចាត៑ ហេ ឝៅល ហេ ឝៅល កុតោ មាំ តាឌយសិ? ស្វំ ប្រតិ ប្រោក្តម៑ ឯតំ ឝព្ទំ ឝ្រុត្វា ");
INSERT INTO sankhm_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ស ប្ឫឞ្ដវាន៑, ហេ ប្រភោ ភវាន៑ កះ? តទា ប្រភុរកថយត៑ យំ យីឝុំ ត្វំ តាឌយសិ ស ឯវាហំ; កណ្ដកស្យ មុខេ បទាឃាតករណំ តវ កឞ្ដម៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","តទា កម្បមានោ វិស្មយាបន្នឝ្ច សោវទត៑ ហេ ប្រភោ មយា កិំ កត៌្តវ្យំ? ភវត ឥច្ឆា កា? តតះ ប្រភុរាជ្ញាបយទ៑ ឧត្ថាយ នគរំ គច្ឆ តត្រ ត្វយា យត៑ កត៌្តវ្យំ តទ៑ វទិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","តស្យ សង្គិនោ លោកា អបិ តំ ឝព្ទំ ឝ្រុតវន្តះ កិន្តុ កមបិ ន ទ្ឫឞ្ដ្វា ស្តព្ធាះ សន្តះ ស្ថិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","អនន្តរំ ឝៅលោ ភូមិត ឧត្ថាយ ចក្ឞុឞី ឧន្មីល្យ កមបិ ន ទ្ឫឞ្ដវាន៑។ តទា លោកាស្តស្យ ហស្តៅ ធ្ឫត្វា ទម្មេឞក្នគរម៑ អានយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","តតះ ស ទិនត្រយំ យាវទ៑ អន្ធោ ភូត្វា ន ភុក្តវាន៑ បីតវាំឝ្ច។ ");
INSERT INTO sankhm_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","តទនន្តរំ ប្រភុស្តទ្ទម្មេឞក្នគរវាសិន ឯកស្មៃ ឝិឞ្យាយ ទឝ៌នំ ទត្វា អាហូតវាន៑ ហេ អននិយ។ តតះ ស ប្រត្យវាទីត៑, ហេ ប្រភោ បឝ្យ ឝ្ឫណោមិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","តទា ប្រភុស្តមាជ្ញាបយត៑ ត្វមុត្ថាយ សរលនាមានំ មាគ៌ំ គត្វា យិហូទានិវេឝនេ តាឞ៌នគរីយំ ឝៅលនាមានំ ជនំ គវេឞយន៑ ប្ឫច្ឆ; ");
INSERT INTO sankhm_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","បឝ្យ ស ប្រាត៌្ហយតេ, តថា អននិយនាមក ឯកោ ជនស្តស្យ សមីបម៑ អាគត្យ តស្យ គាត្រេ ហស្តាប៌ណំ ក្ឫត្វា ទ្ឫឞ្ដិំ ទទាតីត្ថំ ស្វប្នេ ទ្ឫឞ្ដវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","តស្មាទ៑ អននិយះ ប្រត្យវទត៑ ហេ ប្រភោ យិរូឝាលមិ បវិត្រលោកាន៑ ប្រតិ សោៜនេកហិំសាំ ក្ឫតវាន៑; ");
INSERT INTO sankhm_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","អត្រ ស្ថានេ ច យេ លោកាស្តវ នាម្និ ប្រាត៌្ហយន្តិ តានបិ ពទ្ធុំ ស ប្រធានយាជកេភ្យះ ឝក្តិំ ប្រាប្តវាន៑, ឥមាំ កថាម៑ អហម៑ អនេកេឞាំ មុខេភ្យះ ឝ្រុតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","កិន្តុ ប្រភុរកថយត៑, យាហិ ភិន្នទេឝីយលោកានាំ ភូបតីនាម៑ ឥស្រាយេល្លោកានាញ្ច និកដេ មម នាម ប្រចារយិតុំ ស ជនោ មម មនោនីតបាត្រមាស្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","មម នាមនិមិត្តញ្ច តេន កិយាន៑ មហាន៑ ក្លេឝោ ភោក្តវ្យ ឯតត៑ តំ ទឝ៌យិឞ្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","តតោ ៜននិយោ គត្វា គ្ឫហំ ប្រវិឝ្យ តស្យ គាត្រេ ហស្តាប៌្រណំ ក្ឫត្វា កថិតវាន៑, ហេ ភ្រាតះ ឝៅល ត្វំ យថា ទ្ឫឞ្ដិំ ប្រាប្នោឞិ បវិត្រេណាត្មនា បរិបូណ៌ោ ភវសិ ច, តទត៌្ហំ តវាគមនកាលេ យះ ប្រភុយីឝុស្តុភ្យំ ទឝ៌នម៑ អទទាត៑ ស មាំ ប្រេឞិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ឥត្យុក្តមាត្រេ តស្យ ចក្ឞុព៌្ហ្យាម៑ មីនឝល្កវទ៑ វស្តុនិ និគ៌តេ តត្ក្ឞណាត៑ ស ប្រសន្នចក្ឞុ រ្ភូត្វា ប្រោត្ថាយ មជ្ជិតោៜភវត៑ ភុក្ត្វា បីត្វា សពលោភវច្ច។ ");
INSERT INTO sankhm_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","តតះ បរំ ឝៅលះ ឝិឞ្យៃះ សហ កតិបយទិវសាន៑ តស្មិន៑ ទម្មេឞកនគរេ ស្ថិត្វាៜវិលម្ពំ ");
INSERT INTO sankhm_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","សវ៌្វភជនភវនានិ គត្វា យីឝុរីឝ្វរស្យ បុត្រ ឥមាំ កថាំ ប្រាចារយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","តស្មាត៑ សវ៌្វេ ឝ្រោតារឝ្ចមត្ក្ឫត្យ កថិតវន្តោ យោ យិរូឝាលម្នគរ ឯតន្នាម្នា ប្រាត៌្ហយិត្ឫលោកាន៑ វិនាឝិតវាន៑ ឯវម៑ ឯតាទ្ឫឝលោកាន៑ ពទ្ធ្វា ប្រធានយាជកនិកដំ នយតីត្យាឝយា ឯតត្ស្ថានមប្យាគច្ឆត៑ សឯវ កិមយំ ន ភវតិ? ");
INSERT INTO sankhm_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","កិន្តុ ឝៅលះ ក្រមឝ ឧត្សាហវាន៑ ភូត្វា យីឝុរីឝ្វរេណាភិឞិក្តោ ជន ឯតស្មិន៑ ប្រមាណំ ទត្វា ទម្មេឞក៑-និវាសិយិហូទីយលោកាន៑ និរុត្តរាន៑ អករោត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ឥត្ថំ ពហុតិថេ កាលេ គតេ យិហូទីយលោកាស្តំ ហន្តុំ មន្ត្រយាមាសុះ ");
INSERT INTO sankhm_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","កិន្តុ ឝៅលស្តេឞាមេតស្យា មន្ត្រណាយា វាត៌្តាំ ប្រាប្តវាន៑។ តេ តំ ហន្តុំ តុ ទិវានិឝំ គុប្តាះ សន្តោ នគរស្យ ទ្វារេៜតិឞ្ឋន៑; ");
INSERT INTO sankhm_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","តស្មាត៑ ឝិឞ្យាស្តំ នីត្វា រាត្រៅ បិដកេ និធាយ ប្រាចីរេណាវារោហយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","តតះ បរំ ឝៅលោ យិរូឝាលមំ គត្វា ឝិឞ្យគណេន សាទ៌្ធំ ស្ថាតុម៑ ឰហត៑, កិន្តុ សវ៌្វេ តស្មាទពិភយុះ ស ឝិឞ្យ ឥតិ ច ន ប្រត្យយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","ឯតស្មាទ៑ ពណ៌ព្ពាស្តំ គ្ឫហីត្វា ប្រេរិតានាំ សមីបមានីយ មាគ៌មធ្យេ ប្រភុះ កថំ តស្មៃ ទឝ៌នំ ទត្តវាន៑ យាះ កថាឝ្ច កថិតវាន៑ ស ច យថាក្ឞោភះ សន៑ ទម្មេឞក្នគរេ យីឝោ រ្នាម ប្រាចារយត៑ ឯតាន៑ សវ៌្វវ្ឫត្តាន្តាន៑ តាន៑ ជ្ញាបិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","តតះ ឝៅលស្តៃះ សហ យិរូឝាលមិ កាលំ យាបយន៑ និព៌្ហយំ ប្រភោ រ្យីឝោ រ្នាម ប្រាចារយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","តស្មាទ៑ អន្យទេឝីយលោកៃះ សាទ៌្ធំ វិវាទស្យោបស្ថិតត្វាត៑ តេ តំ ហន្តុម៑ អចេឞ្ដន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","កិន្តុ ភ្រាត្ឫគណស្តជ្ជ្ញាត្វា តំ កៃសរិយានគរំ នីត្វា តាឞ៌នគរំ ប្រេឞិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ឥត្ថំ សតិ យិហូទិយាគាលីល្ឝោមិរោណទេឝីយាះ សវ៌្វា មណ្ឌល្យោ វិឝ្រាមំ ប្រាប្តាស្តតស្តាសាំ និឞ្ឋាភវត៑ ប្រភោ រ្ភិយា បវិត្រស្យាត្មនះ សាន្ត្វនយា ច កាលំ ក្ឞេបយិត្វា ពហុសំខ្យា អភវន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","តតះ បរំ បិតរះ ស្ថានេ ស្ថានេ ភ្រមិត្វា ឝេឞេ លោទ្នគរនិវាសិបវិត្រលោកានាំ សមីបេ ស្ថិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","តទា តត្រ បក្ឞាឃាតវ្យាធិនាឞ្ដៅ វត្សរាន៑ ឝយ្យាគតម៑ ឰនេយនាមានំ មនុឞ្យំ សាក្ឞត៑ ប្រាប្យ តមវទត៑, ");
INSERT INTO sankhm_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ហេ ឰនេយ យីឝុខ្រីឞ្ដស្ត្វាំ ស្វស្ថម៑ អកាឞ៌ីត៑, ត្វមុត្ថាយ ស្វឝយ្យាំ និក្ឞិប, ឥត្យុក្តមាត្រេ ស ឧទតិឞ្ឋត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ឯតាទ្ឫឝំ ទ្ឫឞ្ដ្វា លោទ្ឝារោណនិវាសិនោ លោកាះ ប្រភុំ ប្រតិ បរាវត៌្តន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","អបរញ្ច ភិក្ឞាទានាទិឞុ នានក្រិយាសុ និត្យំ ប្រវ្ឫត្តា យា យាផោនគរនិវាសិនី ដាពិថានាមា ឝិឞ្យា យាំ ទក៌្កាំ អត៌្ហាទ៑ ហរិណីមយុក្ត្វា អាហ្វយន៑ សា នារី ");
INSERT INTO sankhm_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","តស្មិន៑ សមយេ រុគ្នា សតី ប្រាណាន៑ អត្យជត៑, តតោ លោកាស្តាំ ប្រក្ឞាល្យោបរិស្ថប្រកោឞ្ឋេ ឝាយយិត្វាស្ថាបយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","លោទ្នគរំ យាផោនគរស្យ សមីបស្ថំ តស្មាត្តត្រ បិតរ អាស្តេ, ឥតិ វាត៌្តាំ ឝ្រុត្វា តូណ៌ំ តស្យាគមនាត៌្ហំ តស្មិន៑ វិនយមុក្ត្វា ឝិឞ្យគណោ ទ្វៅ មនុជៅ ប្រេឞិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","តស្មាត៑ បិតរ ឧត្ថាយ តាភ្យាំ សាទ៌្ធម៑ អាគច្ឆត៑, តត្រ តស្មិន៑ ឧបស្ថិត ឧបរិស្ថប្រកោឞ្ឋំ សមានីតេ ច វិធវាះ ស្វាភិះ សហ ស្ថិតិកាលេ ទក៌្កយា ក្ឫតានិ យាន្យុត្តរីយាណិ បរិធេយានិ ច តានិ សវ៌្វាណិ តំ ទឝ៌យិត្វា រុទត្យឝ្ចតស្ឫឞុ ទិក្ឞ្វតិឞ្ឋន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","កិន្តុ បិតរស្តាះ សវ៌្វា ពហិះ ក្ឫត្វា ជានុនី បាតយិត្វា ប្រាត៌្ហិតវាន៑; បឝ្ចាត៑ ឝវំ ប្រតិ ទ្ឫឞ្ដិំ ក្ឫត្វា កថិតវាន៑, ហេ ដាពីថេ ត្វមុត្តិឞ្ឋ, ឥតិ វាក្យ ឧក្តេ សា ស្ត្រី ចក្ឞុឞី ប្រោន្មីល្យ បិតរម៑ អវលោក្យោត្ថាយោបាវិឝត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","តតះ បិតរស្តស្យាះ ករៅ ធ្ឫត្វា ឧត្តោល្យ បវិត្រលោកាន៑ វិធវាឝ្ចាហូយ តេឞាំ និកដេ សជីវាំ តាំ សមាប៌យត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ឯឞា កថា សមស្តយាផោនគរំ វ្យាប្តា តស្មាទ៑ អនេកេ លោកាះ ប្រភៅ វ្យឝ្វសន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","អបរញ្ច បិតរស្តទ្យាផោនគរីយស្យ កស្យចិត៑ ឝិមោន្នាម្នឝ្ចម៌្មការស្យ គ្ឫហេ ពហុទិនានិ ន្យវសត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","កៃសរិយានគរ ឥតាលិយាខ្យសៃន្យាន្តគ៌តះ កណ៌ីលិយនាមា សេនាបតិរាសីត្ ");
INSERT INTO sankhm_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ស សបរិវារោ ភក្ត ឦឝ្វរបរាយណឝ្ចាសីត៑; លោកេភ្យោ ពហូនិ ទានាទីនិ ទត្វា និរន្តរម៑ ឦឝ្វរេ ប្រាត៌្ហយាញ្ចក្រេ។ ");
INSERT INTO sankhm_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ឯកទា ត្ឫតីយប្រហរវេលាយាំ ស ទ្ឫឞ្ដវាន៑ ឦឝ្វរស្យៃកោ ទូតះ សប្រកាឝំ តត្សមីបម៑ អាគត្យ កថិតវាន៑, ហេ កណ៌ីលិយ។ ");
INSERT INTO sankhm_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","កិន្តុ ស តំ ទ្ឫឞ្ដ្វា ភីតោៜកថយត៑, ហេ ប្រភោ កិំ? តទា តមវទត៑ តវ ប្រាត៌្ហនា ទានាទិ ច សាក្ឞិស្វរូបំ ភូត្វេឝ្វរស្យ គោចរមភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ឥទានីំ យាផោនគរំ ប្រតិ លោកាន៑ ប្រេឞ្យ សមុទ្រតីរេ ឝិមោន្នាម្នឝ្ចម៌្មការស្យ គ្ឫហេ ប្រវាសការី បិតរនាម្នា វិខ្យាតោ យះ ឝិមោន៑ តម៑ អាហ្វាយយ; ");
INSERT INTO sankhm_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","តស្មាត៑ ត្វយា យទ្យត៑ កត៌្តវ្យំ តត្តត៑ ស វទិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ឥត្យុបទិឝ្យ ទូតេ ប្រស្ថិតេ សតិ កណ៌ីលិយះ ស្វគ្ឫហស្ថានាំ ទាសានាំ ទ្វៅ ជនៅ និត្យំ ស្វសង្គិនាំ សៃន្យានាម៑ ឯកាំ ភក្តសេនាញ្ចាហូយ ");
INSERT INTO sankhm_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","សកលមេតំ វ្ឫត្តាន្តំ វិជ្ញាប្យ យាផោនគរំ តាន៑ ប្រាហិណោត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","បរស្មិន៑ ទិនេ តេ យាត្រាំ ក្ឫត្វា យទា នគរស្យ សមីប ឧបាតិឞ្ឋន៑, តទា បិតរោ ទ្វិតីយប្រហរវេលាយាំ ប្រាត៌្ហយិតុំ គ្ឫហប្ឫឞ្ឋម៑ អារោហត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ឯតស្មិន៑ សមយេ ក្ឞុធាត៌្តះ សន៑ កិញ្ចិទ៑ ភោក្តុម៑ ឰច្ឆត៑ កិន្តុ តេឞាម៑ អន្នាសាទនសមយេ ស មូច៌្ឆិតះ សន្នបតត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","តតោ មេឃទ្វារំ មុក្តំ ចតុព៌្ហិះ កោណៃ រ្លម្ពិតំ ព្ឫហទ្វស្ត្រមិវ កិញ្ចន ភាជនម៑ អាកាឝាត៑ ប្ឫថិវីម៑ អវារោហតីតិ ទ្ឫឞ្ដវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","តន្មធ្យេ នានប្រការា គ្រាម្យវន្យបឝវះ ខេចរោរោគាមិប្រភ្ឫតយោ ជន្តវឝ្ចាសន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","អនន្តរំ ហេ បិតរ ឧត្ថាយ ហត្វា ភុំក្ឞ្វ តម្ប្រតីយំ គគណីយា វាណី ជាតា។ ");
INSERT INTO sankhm_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","តទា បិតរះ ប្រត្យវទត៑, ហេ ប្រភោ ឦទ្ឫឝំ មា ភវតុ, អហម៑ ឯតត៑ កាលំ យាវត៑ និឞិទ្ធម៑ អឝុចិ វា ទ្រវ្យំ កិញ្ចិទបិ ន ភុក្តវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","តតះ បុនរបិ តាទ្ឫឝី វិហយសីយា វាណី ជាតា យទ៑ ឦឝ្វរះ ឝុចិ ក្ឫតវាន៑ តត៑ ត្វំ និឞិទ្ធំ ន ជានីហិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ឥត្ថំ ត្រិះ សតិ តត៑ បាត្រំ បុនរាក្ឫឞ្ដំ អាកាឝម៑ អគច្ឆត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","តតះ បរំ យទ៑ ទឝ៌នំ ប្រាប្តវាន៑ តស្យ កោ ភាវ ឥត្យត្រ បិតរោ មនសា សន្ទេគ្ធិ, ឯតស្មិន៑ សមយេ កណ៌ីលិយស្យ តេ ប្រេឞិតា មនុឞ្យា ទ្វារស្យ សន្និធាវុបស្ថាយ, ");
INSERT INTO sankhm_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ឝិមោនោ គ្ឫហមន្វិច្ឆន្តះ សម្ប្ឫឆ្យាហូយ កថិតវន្តះ បិតរនាម្នា វិខ្យាតោ យះ ឝិមោន៑ ស កិមត្រ ប្រវសតិ? ");
INSERT INTO sankhm_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","យទា បិតរស្តទ្ទឝ៌នស្យ ភាវំ មនសាន្ទោលយតិ តទាត្មា តមវទត៑, បឝ្យ ត្រយោ ជនាស្ត្វាំ ម្ឫគយន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ត្វម៑ ឧត្ថាយាវរុហ្យ និះសន្ទេហំ តៃះ សហ គច្ឆ មយៃវ តេ ប្រេឞិតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","តស្មាត៑ បិតរោៜវរុហ្យ កណ៌ីលិយប្រេរិតលោកានាំ និកដមាគត្យ កថិតវាន៑ បឝ្យត យូយំ យំ ម្ឫគយធ្វេ ស ជនោហំ, យូយំ កិន្និមិត្តម៑ អាគតាះ? ");
INSERT INTO sankhm_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","តតស្តេ ប្រត្យវទន៑ កណ៌ីលិយនាមា ឝុទ្ធសត្ត្វ ឦឝ្វរបរាយណោ យិហូទីយទេឝស្ថានាំ សវ៌្វេឞាំ សន្និធៅ សុខ្យាត្យាបន្ន ឯកះ សេនាបតិ រ្និជគ្ឫហំ ត្វាមាហូយ នេតុំ ត្វត្តះ កថា ឝ្រោតុញ្ច បវិត្រទូតេន សមាទិឞ្ដះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","តទា បិតរស្តានភ្យន្តរំ នីត្វា តេឞាមាតិថ្យំ ក្ឫតវាន៑, បរេៜហនិ តៃះ សាទ៌្ធំ យាត្រាមករោត៑, យាផោនិវាសិនាំ ភ្រាត្ឫណាំ កិយន្តោ ជនាឝ្ច តេន សហ គតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","បរស្មិន៑ ទិវសេ កៃសរិយានគរមធ្យប្រវេឝសមយេ កណ៌ីលិយោ ជ្ញាតិពន្ធូន៑ អាហូយានីយ តាន៑ អបេក្ឞ្យ ស្ថិតះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","បិតរេ គ្ឫហ ឧបស្ថិតេ កណ៌ីលិយស្តំ សាក្ឞាត្ក្ឫត្យ ចរណយោះ បតិត្វា ប្រាណមត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","បិតរស្តមុត្ថាប្យ កថិតវាន៑, ឧត្តិឞ្ឋាហមបិ មានុឞះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","តទា កណ៌ីលិយេន សាកម៑ អាលបន៑ គ្ឫហំ ប្រាវិឝត៑ តន្មធ្យេ ច ពហុលោកានាំ សមាគមំ ទ្ឫឞ្ដ្វា តាន៑ អវទត៑, ");
INSERT INTO sankhm_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","អន្យជាតីយលោកៃះ មហាលបនំ វា តេឞាំ គ្ឫហមធ្យេ ប្រវេឝនំ យិហូទីយានាំ និឞិទ្ធម៑ អស្តីតិ យូយម៑ អវគច្ឆថ; កិន្តុ កមបិ មានុឞម៑ អវ្យវហាយ៌្យម៑ អឝុចិំ វា ជ្ញាតុំ មម នោចិតម៑ ឥតិ បរមេឝ្វរោ មាំ ជ្ញាបិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ឥតិ ហេតោរាហ្វានឝ្រវណមាត្រាត៑ កាញ្ចនាបត្តិម៑ អក្ឫត្វា យុឞ្មាកំ សមីបម៑ អាគតោស្មិ; ប្ឫច្ឆាមិ យូយំ កិន្និមិត្តំ មាម៑ អាហូយត? ");
INSERT INTO sankhm_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","តទា កណ៌ីលិយះ កថិតវាន៑, អទ្យ ចត្វារិ ទិនានិ ជាតានិ ឯតាវទ្វេលាំ យាវទ៑ អហម៑ អនាហារ អាសន៑ តតស្ត្ឫតីយប្រហរេ សតិ គ្ឫហេ ប្រាត៌្ហនសមយេ តេជោមយវស្ត្រភ្ឫទ៑ ឯកោ ជនោ មម សមក្ឞំ តិឞ្ឋន៑ ឯតាំ កថាម៑ អកថយត៑, ");
INSERT INTO sankhm_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ហេ កណ៌ីលិយ ត្វទីយា ប្រាត៌្ហនា ឦឝ្វរស្យ កណ៌គោចរីភូតា តវ ទានាទិ ច សាក្ឞិស្វរូបំ ភូត្វា តស្យ ទ្ឫឞ្ដិគោចរមភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","អតោ យាផោនគរំ ប្រតិ លោកាន៑ ប្រហិត្យ តត្រ សមុទ្រតីរេ ឝិមោន្នាម្នះ កស្យចិច្ចម៌្មការស្យ គ្ឫហេ ប្រវាសការី បិតរនាម្នា វិខ្យាតោ យះ ឝិមោន៑ តមាហូाយយ; តតះ ស អាគត្យ ត្វាម៑ ឧបទេក្ឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ឥតិ ការណាត៑ តត្ក្ឞណាត៑ តវ និកដេ លោកាន៑ ប្រេឞិតវាន៑, ត្វមាគតវាន៑ ឥតិ ភទ្រំ ក្ឫតវាន៑។ ឦឝ្វរោ យាន្យាខ្យានានិ កថយិតុម៑ អាទិឝត៑ តានិ ឝ្រោតុំ វយំ សវ៌្វេ សាម្ប្រតម៑ ឦឝ្វរស្យ សាក្ឞាទ៑ ឧបស្ថិតាះ ស្មះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","តទា បិតរ ឥមាំ កថាំ កថយិតុម៑ អារព្ធវាន៑, ឦឝ្វរោ មនុឞ្យាណាម៑ អបក្ឞបាតី សន្ ");
INSERT INTO sankhm_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","យស្យ កស្យចិទ៑ ទេឝស្យ យោ លោកាស្តស្មាទ្ភីត្វា សត្កម៌្ម ករោតិ ស តស្យ គ្រាហ្យោ ភវតិ, ឯតស្យ និឝ្ចយម៑ ឧបលព្ធវានហម៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","សវ៌្វេឞាំ ប្រភុ រ្យោ យីឝុខ្រីឞ្ដស្តេន ឦឝ្វរ ឥស្រាយេល្វំឝានាំ និកដេ សុសំវាទំ ប្រេឞ្យ សម្មេលនស្យ យំ សំវាទំ ប្រាចារយត៑ តំ សំវាទំ យូយំ ឝ្រុតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","យតោ យោហនា មជ្ជនេ ប្រចារិតេ សតិ ស គាលីលទេឝមារភ្យ សមស្តយិហូទីយទេឝំ វ្យាប្នោត៑; ");
INSERT INTO sankhm_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ផលត ឦឝ្វរេណ បវិត្រេណាត្មនា ឝក្ត្យា ចាភិឞិក្តោ នាសរតីយយីឝុះ ស្ថានេ ស្ថានេ ភ្រមន៑ សុក្រិយាំ កុវ៌្វន៑ ឝៃតានា ក្លិឞ្ដាន៑ សវ៌្វលោកាន៑ ស្វស្ថាន៑ អករោត៑, យត ឦឝ្វរស្តស្យ សហាយ អាសីត៑; ");
INSERT INTO sankhm_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","វយញ្ច យិហូទីយទេឝេ យិរូឝាលម្នគរេ ច តេន ក្ឫតានាំ សវ៌្វេឞាំ កម៌្មណាំ សាក្ឞិណោ ភវាមះ។ លោកាស្តំ ក្រុឝេ វិទ្ធ្វា ហតវន្តះ, ");
INSERT INTO sankhm_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","កិន្តុ ត្ឫតីយទិវសេ ឦឝ្វរស្តមុត្ថាប្យ សប្រកាឝម៑ អទឝ៌យត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","សវ៌្វលោកានាំ និកដ ឥតិ ន ហិ, កិន្តុ តស្មិន៑ ឝ្មឝានាទុត្ថិតេ សតិ តេន សាទ៌្ធំ ភោជនំ បានញ្ច ក្ឫតវន្ត ឯតាទ្ឫឝា ឦឝ្វរស្យ មនោនីតាះ សាក្ឞិណោ យេ វយម៑ អស្មាកំ និកដេ តមទឝ៌យត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ជីវិតម្ឫតោភយលោកានាំ វិចារំ កត៌្តុម៑ ឦឝ្វរោ យំ និយុក្តវាន៑ ស ឯវ ស ជនះ, ឥមាំ កថាំ ប្រចារយិតុំ តស្មិន៑ ប្រមាណំ ទាតុញ្ច សោៜស្មាន៑ អាជ្ញាបយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","យស្តស្មិន៑ វិឝ្វសិតិ ស តស្យ នាម្នា បាបាន្មុក្តោ ភវិឞ្យតិ តស្មិន៑ សវ៌្វេ ភវិឞ្យទ្វាទិនោបិ ឯតាទ្ឫឝំ សាក្ឞ្យំ ទទតិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","បិតរស្យៃតត្កថាកថនកាលេ សវ៌្វេឞាំ ឝ្រោត្ឫណាមុបរិ បវិត្រ អាត្មាវារោហត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","តតះ បិតរេណ សាទ៌្ធម៑ អាគតាស្ត្វក្ឆេទិនោ វិឝ្វាសិនោ លោកា អន្យទេឝីយេភ្យះ បវិត្រ អាត្មនិ ទត្តេ សតិ ");
INSERT INTO sankhm_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","តេ នានាជាតីយភាឞាភិះ កថាំ កថយន្ត ឦឝ្វរំ ប្រឝំសន្តិ, ឥតិ ទ្ឫឞ្ដ្វា ឝ្រុត្វា ច វិស្មយម៑ អាបទ្យន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","តទា បិតរះ កថិតវាន៑, វយមិវ យេ បវិត្រម៑ អាត្មានំ ប្រាប្តាស្តេឞាំ ជលមជ្ជនំ កិំ កោបិ និឞេទ្ធុំ ឝក្នោតិ? ");
INSERT INTO sankhm_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","តតះ ប្រភោ រ្នាម្នា មជ្ជិតា ភវតេតិ តានាជ្ញាបយត៑។ អនន្តរំ តេ ស្វៃះ សាទ៌្ធំ កតិបយទិនានិ ស្ថាតុំ ប្រាត៌្ហយន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ឥត្ថំ ភិន្នទេឝីយលោកា អបីឝ្វរស្យ វាក្យម៑ អគ្ឫហ្លន៑ ឥមាំ វាត៌្តាំ យិហូទីយទេឝស្ថប្រេរិតា ភ្រាត្ឫគណឝ្ច ឝ្រុតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","តតះ បិតរេ យិរូឝាលម្នគរំ គតវតិ ត្វក្ឆេទិនោ លោកាស្តេន សហ វិវទមានា អវទន៑, ");
INSERT INTO sankhm_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ត្វម៑ អត្វក្ឆេទិលោកានាំ គ្ឫហំ គត្វា តៃះ សាទ៌្ធំ ភុក្តវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","តតះ បិតរ អាទិតះ ក្រមឝស្តត្កាយ៌្យស្យ សវ៌្វវ្ឫត្តាន្តមាខ្យាតុម៑ អារព្ធវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","យាផោនគរ ឯកទាហំ ប្រាត៌្ហយមានោ មូច៌្ឆិតះ សន៑ ទឝ៌នេន ចតុឞ៌ុ កោណេឞុ លម្ពនមានំ វ្ឫហទ្វស្ត្រមិវ បាត្រមេកម៑ អាកាឝទវរុហ្យ មន្និកដម៑ អាគច្ឆទ៑ អបឝ្យម៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","បឝ្ចាត៑ តទ៑ អនន្យទ្ឫឞ្ដ្យា ទ្ឫឞ្ដ្វា វិវិច្យ តស្យ មធ្យេ នានាប្រការាន៑ គ្រាម្យវន្យបឝូន៑ ឧរោគាមិខេចរាំឝ្ច ទ្ឫឞ្ដវាន៑; ");
INSERT INTO sankhm_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","ហេ បិតរ ត្វមុត្ថាយ គត្វា ភុំក្ឞ្វ មាំ សម្ពោធ្យ កថយន្តំ ឝព្ទមេកំ ឝ្រុតវាំឝ្ច។ ");
INSERT INTO sankhm_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","តតោហំ ប្រត្យវទំ, ហេ ប្រភោ នេត្ថំ ភវតុ, យតះ កិញ្ចន និឞិទ្ធម៑ អឝុចិ ទ្រវ្យំ វា មម មុខមធ្យំ កទាបិ ន ប្រាវិឝត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","អបរម៑ ឦឝ្វរោ យត៑ ឝុចិ ក្ឫតវាន៑ តន្និឞិទ្ធំ ន ជានីហិ ទ្វិ រ្មាម្ប្រតីទ្ឫឝី វិហាយសីយា វាណី ជាតា។ ");
INSERT INTO sankhm_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","ត្រិរិត្ថំ សតិ តត៑ សវ៌្វំ បុនរាកាឝម៑ អាក្ឫឞ្ដំ។ ");
INSERT INTO sankhm_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","បឝ្ចាត៑ កៃសរិយានគរាត៑ ត្រយោ ជនា មន្និកដំ ប្រេឞិតា យត្រ និវេឝនេ ស្ថិតោហំ តស្មិន៑ សមយេ តត្រោបាតិឞ្ឋន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","តទា និះសន្ទេហំ តៃះ សាទ៌្ធំ យាតុម៑ អាត្មា មាមាទិឞ្ដវាន៑; តតះ បរំ មយា សហៃតេឞុ ឞឌ្ភ្រាត្ឫឞុ គតេឞុ វយំ តស្យ មនុជស្យ គ្ឫហំ ប្រាវិឝាម។ ");
INSERT INTO sankhm_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","សោស្មាកំ និកដេ កថាមេតាម៑ អកថយត៑ ឯកទា ទូត ឯកះ ប្រត្យក្ឞីភូយ មម គ្ឫហមធ្យេ តិឞ្ដន៑ មាមិត្យាជ្ញាបិតវាន៑, យាផោនគរំ ប្រតិ លោកាន៑ ប្រហិត្យ បិតរនាម្នា វិខ្យាតំ ឝិមោនម៑ អាហូយយ; ");
INSERT INTO sankhm_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","តតស្តវ ត្វទីយបរិវារាណាញ្ច យេន បរិត្រាណំ ភវិឞ្យតិ តត៑ ស ឧបទេក្ឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","អហំ តាំ កថាមុត្ថាប្យ កថិតវាន៑ តេន ប្រថមម៑ អស្មាកម៑ ឧបរិ យថា បវិត្រ អាត្មាវរូឍវាន៑ តថា តេឞាមប្យុបរិ សមវរូឍវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","តេន យោហន៑ ជលេ មជ្ជិតវាន៑ ឥតិ សត្យំ កិន្តុ យូយំ បវិត្រ អាត្មនិ មជ្ជិតា ភវិឞ្យថ, ឥតិ យទ្វាក្យំ ប្រភុរុទិតវាន៑ តត៑ តទា មយា ស្ម្ឫតម៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","អតះ ប្រភា យីឝុខ្រីឞ្ដេ ប្រត្យយការិណោ យេ វយម៑ អស្មភ្យម៑ ឦឝ្វរោ យទ៑ ទត្តវាន៑ តត៑ តេភ្យោ លោកេភ្យោបិ ទត្តវាន៑ តតះ កោហំ? កិមហម៑ ឦឝ្វរំ វារយិតុំ ឝក្នោមិ? ");
INSERT INTO sankhm_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","កថាមេតាំ ឝ្រុវា តេ ក្ឞាន្តា ឦឝ្វរស្យ គុណាន៑ អនុកីត៌្ត្យ កថិតវន្តះ, តហ៌ិ បរមាយុះប្រាប្តិនិមិត្តម៑ ឦឝ្វរោន្យទេឝីយលោកេភ្យោបិ មនះបរិវត៌្តនរូបំ ទានម៑ អទាត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","ស្តិផានំ ប្រតិ ឧបទ្រវេ ឃដិតេ យេ វិកីណ៌ា អភវន៑ តៃ ផៃនីកីកុប្រាន្តិយខិយាសុ ភ្រមិត្វា កេវលយិហូទីយលោកាន៑ វិនា កស្យាប្យន្យស្យ សមីប ឦឝ្វរស្យ កថាំ ន ប្រាចារយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","អបរំ តេឞាំ កុប្រីយាះ កុរីនីយាឝ្ច កិយន្តោ ជនា អាន្តិយខិយានគរំ គត្វា យូនានីយលោកានាំ សមីបេបិ ប្រភោយ៌ីឝោះ កថាំ ប្រាចារយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ប្រភោះ ករស្តេឞាំ សហាយ អាសីត៑ តស្មាទ៑ អនេកេ លោកា វិឝ្វស្យ ប្រភុំ ប្រតិ បរាវត៌្តន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ឥតិ វាត៌្តាយាំ យិរូឝាលមស្ថមណ្ឌលីយលោកានាំ កណ៌គោចរីភូតាយាម៑ អាន្តិយខិយានគរំ គន្តុ តេ ពណ៌ព្ពាំ ប្រៃរយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","តតោ ពណ៌ព្ពាស្តត្រ ឧបស្ថិតះ សន៑ ឦឝ្វរស្យានុគ្រហស្យ ផលំ ទ្ឫឞ្ដ្វា សានន្ទោ ជាតះ, ");
INSERT INTO sankhm_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ស ស្វយំ សាធុ រ្វិឝ្វាសេន បវិត្រេណាត្មនា ច បរិបូណ៌ះ សន៑ គនោនិឞ្ដយា ប្រភាវាស្ថាំ កត៌្តុំ សវ៌្វាន៑ ឧបទិឞ្ដវាន៑ តេន ប្រភោះ ឝិឞ្យា អនេកេ ពភូវុះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","ឝេឞេ ឝៅលំ ម្ឫគយិតុំ ពណ៌ព្ពាស្តាឞ៌នគរំ ប្រស្ថិតវាន៑។ តត្រ តស្យោទ្ទេឝំ ប្រាប្យ តម៑ អាន្តិយខិយានគរម៑ អានយត៑; ");
INSERT INTO sankhm_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","តតស្តៅ មណ្ឌលីស្ថលោកៃះ សភាំ ក្ឫត្វា សំវត្សរមេកំ យាវទ៑ ពហុលោកាន៑ ឧបាទិឝតាំ; តស្មិន៑ អាន្តិយខិយានគរេ ឝិឞ្យាះ ប្រថមំ ខ្រីឞ្ដីយនាម្នា វិខ្យាតា អភវន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","តតះ បរំ ភវិឞ្យទ្វាទិគណេ យិរូឝាលម អាន្តិយខិយានគរម៑ អាគតេ សតិ ");
INSERT INTO sankhm_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","អាគាពនាមា តេឞាមេក ឧត្ថាយ អាត្មនះ ឝិក្ឞយា សវ៌្វទេឝេ ទុព៌្ហិក្ឞំ ភវិឞ្យតីតិ ជ្ញាបិតវាន៑; តតះ ក្លៅទិយកៃសរស្យាធិការេ សតិ តត៑ ប្រត្យក្ឞម៑ អភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","តស្មាត៑ ឝិឞ្យា ឯកៃកឝះ ស្វស្វឝក្ត្យនុសារតោ យិហូទីយទេឝនិវាសិនាំ ភ្រត្ឫណាំ ទិនយាបនាត៌្ហំ ធនំ ប្រេឞយិតុំ និឝ្ចិត្យ ");
INSERT INTO sankhm_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ពណ៌ព្ពាឝៅលយោ រ្ទ្វារា ប្រាចីនលោកានាំ សមីបំ តត៑ ប្រេឞិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","តស្មិន៑ សមយេ ហេរោទ៑រាជោ មណ្ឌល្យាះ កិយជ្ជនេភ្យោ ទុះខំ ទាតុំ ប្រារភត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","វិឝេឞតោ យោហនះ សោទរំ យាកូពំ ករវាលាឃាតេន៑ ហតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","តស្មាទ៑ យិហូទីយាះ សន្តុឞ្ដា អភវន៑ ឥតិ វិជ្ញាយ ស បិតរមបិ ធត៌្តុំ គតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","តទា កិណ្វឝូន្យបូបោត្សវសមយ ឧបាតិឞ្ដត៑; អត ឧត្សវេ គតេ សតិ លោកានាំ សមក្ឞំ តំ ពហិរានេយ្យាមីតិ មនសិ ស្ថិរីក្ឫត្យ ស តំ ធារយិត្វា រក្ឞ្ណាត៌្ហម៑ យេឞាម៑ ឯកៃកសំឃេ ចត្វារោ ជនាះ សន្តិ តេឞាំ ចតុណ៌ាំ រក្ឞកសំឃានាំ សមីបេ តំ សមប៌្យ ការាយាំ ស្ថាបិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","កិន្តុំ បិតរស្យ ការាស្ថិតិការណាត៑ មណ្ឌល្យា លោកា អវិឝ្រាមម៑ ឦឝ្វរស្យ សមីបេ ប្រាត៌្ហយន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","អនន្តរំ ហេរោទិ តំ ពហិរានាយិតុំ ឧទ្យតេ សតិ តស្យាំ រាត្រៅ បិតរោ រក្ឞកទ្វយមធ្យស្ថានេ ឝ្ឫង្ខលទ្វយេន ពទ្ធ្វះ សន៑ និទ្រិត អាសីត៑, ទៅវារិកាឝ្ច ការាយាះ សម្មុខេ តិឞ្ឋនតោ ទ្វារម៑ អរក្ឞិឞុះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ឯតស្មិន៑ សមយេ បរមេឝ្វរស្យ ទូតេ សមុបស្ថិតេ ការា ទីប្តិមតី ជាតា; តតះ ស ទូតះ បិតរស្យ កុក្ឞាវាវាតំ ក្ឫត្វា តំ ជាគរយិត្វា ភាឞិតវាន៑ តូណ៌មុត្តិឞ្ឋ; តតស្តស្យ ហស្តស្ថឝ្ឫង្ខលទ្វយំ គលត៑ បតិតំ។ ");
INSERT INTO sankhm_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ស ទូតស្តមវទត៑, ពទ្ធកដិះ សន៑ បាទយោះ បាទុកេ អប៌យ; តេន តថា ក្ឫតេ សតិ ទូតស្តម៑ ឧក្តវាន៑ គាត្រីយវស្ត្រំ គាត្រេ និធាយ មម បឝ្ចាទ៑ ឯហិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","តតះ បិតរស្តស្យ បឝ្ចាទ៑ វ្រជន ពហិរគច្ឆត៑, កិន្តុ ទូតេន កម៌្មៃតត៑ ក្ឫតមិតិ សត្យមជ្ញាត្វា ស្វប្នទឝ៌នំ ជ្ញាតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ឥត្ថំ តៅ ប្រថមាំ ទ្វិតីយាញ្ច ការាំ លង្ឃិត្វា យេន លៅហនិម៌្មិតទ្វារេណ នគរំ គម្យតេ តត្សមីបំ ប្រាប្នុតាំ; តតស្តស្យ កវាដំ ស្វយំ មុក្តមភវត៑ តតស្តៅ តត្ស្ថានាទ៑ ពហិ រ្ភូត្វា មាគ៌ៃកស្យ សីមាំ យាវទ៑ គតៅ; តតោៜកស្មាត៑ ស ទូតះ បិតរំ ត្យក្តវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","តទា ស ចេតនាំ ប្រាប្យ កថិតវាន៑ និជទូតំ ប្រហិត្យ បរមេឝ្វរោ ហេរោទោ ហស្តាទ៑ យិហូទីយលោកានាំ សវ៌្វាឝាយាឝ្ច មាំ សមុទ្ធ្ឫតវាន៑ ឥត្យហំ និឝ្ចយំ ជ្ញាតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ស វិវិច្យ មាក៌នាម្រា វិខ្យាតស្យ យោហនោ មាតុ រ្មរិយមោ យស្មិន៑ គ្ឫហេ ពហវះ សម្ភូយ ប្រាត៌្ហយន្ត តន្និវេឝនំ គតះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","បិតរេណ ពហិទ៌្វារ អាហតេ សតិ រោទានាមា ពាលិកា ទ្រឞ្ដុំ គតា។ ");
INSERT INTO sankhm_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","តតះ បិតរស្យ ស្វរំ ឝ្រុវា សា ហឞ៌យុក្តា សតី ទ្វារំ ន មោចយិត្វា បិតរោ ទ្វារេ តិឞ្ឋតីតិ វាត៌្តាំ វក្តុម៑ អភ្យន្តរំ ធាវិត្វា គតវតី។ ");
INSERT INTO sankhm_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","តេ ប្រាវោចន៑ ត្វមុន្មត្តា ជាតាសិ កិន្តុ សា មុហុម៌ុហុរុក្តវតី សត្យមេវៃតត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","តទា តេ កថិតវន្តស្តហ៌ិ តស្យ ទូតោ ភវេត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","បិតរោ ទ្វារមាហតវាន៑ ឯតស្មិន្នន្តរេ ទ្វារំ មោចយិត្វា បិតរំ ទ្ឫឞ្ដ្វា វិស្មយំ ប្រាប្តាះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","តតះ បិតរោ និះឝព្ទំ ស្ថាតុំ តាន៑ ប្រតិ ហស្តេន សង្កេតំ ក្ឫត្វា បរមេឝ្វរោ យេន ប្រការេណ តំ ការាយា ឧទ្ធ្ឫត្យានីតវាន៑ តស្យ វ្ឫត្តាន្តំ តានជ្ញាបយត៑, យូយំ គត្វា យាកុពំ ភ្រាត្ឫគណញ្ច វាត៌្តាមេតាំ វទតេត្យុក្តា ស្ថានាន្តរំ ប្រស្ថិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ប្រភាតេ សតិ បិតរះ ក្វ គត ឥត្យត្រ រក្ឞកាណាំ មធ្យេ មហាន៑ កលហោ ជាតះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ហេរោទ៑ ពហុ ម្ឫគយិត្វា តស្យោទ្ទេឝេ ន ប្រាប្តេ សតិ រក្ឞកាន៑ សំប្ឫច្ឆ្យ តេឞាំ ប្រាណាន៑ ហន្តុម៑ អាទិឞ្ដវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","បឝ្ចាត៑ ស យិហូទីយប្រទេឝាត៑ កៃសរិយានគរំ គត្វា តត្រាវាតិឞ្ឋត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","សោរសីទោនទេឝយោ រ្លោកេភ្យោ ហេរោទិ យុយុត្សៅ សតិ តេ សវ៌្វ ឯកមន្ត្រណាះ សន្តស្តស្យ សមីប ឧបស្ថាយ ល្វាស្តនាមានំ តស្យ វស្ត្រគ្ឫហាធីឝំ សហាយំ ក្ឫត្វា ហេរោទា សាទ៌្ធំ សន្ធិំ ប្រាត៌្ហយន្ត យតស្តស្យ រាជ្ញោ ទេឝេន តេឞាំ ទេឝីយានាំ ភរណម៑ អភវត្ំ ");
INSERT INTO sankhm_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","អតះ កុត្រចិន៑ និរុបិតទិនេ ហេរោទ៑ រាជកីយំ បរិច្ឆទំ បរិធាយ សិំហាសនេ សមុបវិឝ្យ តាន៑ ប្រតិ កថាម៑ ឧក្តវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","តតោ លោកា ឧច្ចៃះការំ ប្រត្យវទន៑, ឯឞ មនុជរវោ ន ហិ, ឦឝ្វរីយរវះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","តទា ហេរោទ៑ ឦឝ្វរស្យ សម្មានំ នាករោត៑; តស្មាទ្ធេតោះ បរមេឝ្វរស្យ ទូតោ ហឋាត៑ តំ ប្រាហរត៑ តេនៃវ ស កីដៃះ ក្ឞីណះ សន៑ ប្រាណាន៑ អជហាត៑។ កិន្ត្វីឝ្វរស្យ កថា ទេឝំ វ្យាប្យ ប្រពលាភវត៑។ តតះ បរំ ពណ៌ព្ពាឝៅលៅ យស្យ កម៌្មណោ ភារំ ប្រាប្នុតាំ តាភ្យាំ តស្មិន៑ សម្បាទិតេ សតិ មាក៌នាម្នា វិខ្យាតោ យោ យោហន៑ តំ សង្គិនំ ក្ឫត្វា យិរូឝាលម្នគរាត៑ ប្រត្យាគតៅ។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","អបរញ្ច ពណ៌ព្ពាះ, ឝិមោន៑ យំ និគ្រំ វទន្តិ, កុរីនីយលូកិយោ ហេរោទា រាជ្ញា សហ ក្ឫតវិទ្យាाភ្យាសោ មិនហេម៑, ឝៅលឝ្ចៃតេ យេ កិយន្តោ ជនា ភវិឞ្យទ្វាទិន ឧបទេឞ្ដារឝ្ចាន្តិយខិយានគរស្ថមណ្ឌល្យាម៑ អាសន៑, ");
INSERT INTO sankhm_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","តេ យទោបវាសំ ក្ឫត្វេឝ្វរម៑ អសេវន្ត តស្មិន៑ សមយេ បវិត្រ អាត្មា កថិតវាន៑ អហំ យស្មិន៑ កម៌្មណិ ពណ៌ព្ពាឝៃលៅ និយុក្តវាន៑ តត្កម៌្ម កត៌្តុំ តៅ ប្ឫថក៑ កុរុត។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","តតស្តៃរុបវាសប្រាត៌្ហនយោះ ក្ឫតយោះ សតោស្តេ តយោ រ្គាត្រយោ រ្ហស្តាប៌ណំ ក្ឫត្វា តៅ វ្យស្ឫជន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","តតះ បរំ តៅ បវិត្រេណាត្មនា ប្រេរិតៅ សន្តៅ សិលូកិយានគរម៑ ឧបស្ថាយ សមុទ្របថេន កុប្រោបទ្វីបម៑ អគច្ឆតាំ។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","តតះ សាលាមីនគរម៑ ឧបស្ថាយ តត្រ យិហូទីយានាំ ភជនភវនានិ គត្វេឝ្វរស្យ កថាំ ប្រាចារយតាំ; យោហនបិ តត្សហចរោៜភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ឥត្ថំ តេ តស្យោបទ្វីបស្យ សវ៌្វត្រ ភ្រមន្តះ បាផនគរម៑ ឧបស្ថិតាះ; តត្រ សុវិវេចកេន សជ៌ិយបៅលនាម្នា តទ្ទេឝាធិបតិនា សហ ភវិឞ្យទ្វាទិនោ វេឝធារី ពយ៌ីឝុនាមា យោ មាយាវី យិហូទី អាសីត៑ តំ សាក្ឞាត៑ ប្រាប្តវតះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","តទ្ទេឝាធិប ឦឝ្វរស្យ កថាំ ឝ្រោតុំ វាញ្ឆន៑ បៅលពណ៌ព្ពៅ ន្យមន្ត្រយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","កិន្ត្វិលុមា យំ មាយាវិនំ វទន្តិ ស ទេឝាធិបតិំ ធម៌្មមាគ៌ាទ៑ ពហិព៌្ហូតំ កត៌្តុម៑ អយតត។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","តស្មាត៑ ឝោលោៜរ្ថាត៑ បៅលះ បវិត្រេណាត្មនា បរិបូណ៌ះ សន៑ តំ មាយាវិនំ ប្រត្យនន្យទ្ឫឞ្ដិំ ក្ឫត្វាកថយត៑, ");
INSERT INTO sankhm_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ហេ នរកិន៑ ធម៌្មទ្វេឞិន៑ កៅដិល្យទុឞ្កម៌្មបរិបូណ៌, ត្វំ កិំ ប្រភោះ សត្យបថស្យ វិបយ៌្យយករណាត៑ កទាបិ ន និវត៌្តិឞ្យសេ? ");
INSERT INTO sankhm_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","អធុនា បរមេឝ្វរស្តវ សមុចិតំ ករិឞ្យតិ តេន កតិបយទិនានិ ត្វម៑ អន្ធះ សន៑ សូយ៌្យមបិ ន ទ្រក្ឞ្យសិ។ តត្ក្ឞណាទ៑ រាត្រិវទ៑ អន្ធការស្តស្យ ទ្ឫឞ្ដិម៑ អាច្ឆាទិតវាន៑; តស្មាត៑ តស្យ ហស្តំ ធត៌្តុំ ស លោកមន្វិច្ឆន៑ ឥតស្តតោ ភ្រមណំ ក្ឫតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ឯនាំ ឃដនាំ ទ្ឫឞ្ដ្វា ស ទេឝាធិបតិះ ប្រភូបទេឝាទ៑ វិស្មិត្យ វិឝ្វាសំ ក្ឫតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","តទនន្តរំ បៅលស្តត្សង្គិនៅ ច បាផនគរាត៑ ប្រោតំ ចាលយិត្វា បម្ផុលិយាទេឝស្យ បគ៌ីនគរម៑ អគច្ឆន៑ កិន្តុ យោហន៑ តយោះ សមីបាទ៑ ឯត្យ យិរូឝាលមំ ប្រត្យាគច្ឆត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","បឝ្ចាត៑ តៅ បគ៌ីតោ យាត្រាំ ក្ឫត្វា បិសិទិយាទេឝស្យ អាន្តិយខិយានគរម៑ ឧបស្ថាយ វិឝ្រាមវារេ ភជនភវនំ ប្រវិឝ្យ សមុបាវិឝតាំ។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","វ្យវស្ថាភវិឞ្យទ្វាក្យយោះ បឋិតយោះ សតោ រ្ហេ ភ្រាតរៅ លោកាន៑ ប្រតិ យុវយោះ កាចិទ៑ ឧបទេឝកថា យទ្យស្តិ តហ៌ិ តាំ វទតំ តៅ ប្រតិ តស្យ ភជនភវនស្យាធិបតយះ កថាម៑ ឯតាំ កថយិត្វា ប្រៃឞយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","អតះ បៅល ឧត្តិឞ្ឋន៑ ហស្តេន សង្កេតំ កុវ៌្វន៑ កថិតវាន៑ ហេ ឥស្រាយេលីយមនុឞ្យា ឦឝ្វរបរាយណាះ សវ៌្វេ លោកា យូយម៑ អវធទ្ធំ។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ឯតេឞាមិស្រាយេល្លោកានាម៑ ឦឝ្វរោៜស្មាកំ បូវ៌្វបរុឞាន៑ មនោនីតាន៑ កត្វា គ្ឫហីតវាន៑ តតោ មិសរិ ទេឝេ ប្រវសនកាលេ តេឞាមុន្នតិំ ក្ឫត្វា តស្មាត៑ ស្វីយពាហុពលេន តាន៑ ពហិះ ក្ឫត្វា សមានយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ចត្វារិំឝទ្វត្សរាន៑ យាវច្ច មហាប្រាន្តរេ តេឞាំ ភរណំ ក្ឫត្វា ");
INSERT INTO sankhm_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","កិនាន្ទេឝាន្តវ៌្វត៌្តីណិ សប្តរាជ្យានិ នាឝយិត្វា គុដិកាបាតេន តេឞុ សវ៌្វទេឝេឞុ តេភ្យោៜធិការំ ទត្តវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","បញ្ចាឝទធិកចតុះឝតេឞុ វត្សរេឞុ គតេឞុ ច ឝិមូយេល្ភវិឞ្យទ្វាទិបយ៌្យន្តំ តេឞាមុបរិ វិចារយិត្ឫន៑ និយុក្តវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","តៃឝ្ច រាជ្ញិ ប្រាត៌្ហិតេ, ឦឝ្វរោ ពិន្យាមីនោ វំឝជាតស្យ កីឝះ បុត្រំ ឝៅលំ ចត្វារិំឝទ្វឞ៌បយ៌្យន្តំ តេឞាមុបរិ រាជានំ ក្ឫតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","បឝ្ចាត៑ តំ បទច្យុតំ ក្ឫត្វា យោ មទិឞ្ដក្រិយាះ សវ៌្វាះ ករិឞ្យតិ តាទ្ឫឝំ មម មនោភិមតម៑ ឯកំ ជនំ យិឝយះ បុត្រំ ទាយូទំ ប្រាប្តវាន៑ ឥទំ ប្រមាណំ យស្មិន៑ ទាយូទិ ស ទត្តវាន៑ តំ ទាយូទំ តេឞាមុបរិ រាជត្វំ កត៌្តុម៑ ឧត្បាទិតវាន។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","តស្យ ស្វប្រតិឝ្រុតស្យ វាក្យស្យានុសារេណ ឥស្រាយេល្លោកានាំ និមិត្តំ តេឞាំ មនុឞ្យាណាំ វំឝាទ៑ ឦឝ្វរ ឯកំ យីឝុំ (ត្រាតារម៑) ឧទបាទយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","តស្យ ប្រកាឝនាត៑ បូវ៌្វំ យោហន៑ ឥស្រាយេល្លោកានាំ សន្និធៅ មនះបរាវត៌្តនរូបំ មជ្ជនំ ប្រាចារយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","យស្យ ច កម៌្មណោे ភារំ ប្រប្តវាន៑ យោហន៑ តន៑ និឞ្បាទយន៑ ឯតាំ កថាំ កថិតវាន៑, យូយំ មាំ កំ ជនំ ជានីថ? អហម៑ អភិឞិក្តត្រាតា នហិ, កិន្តុ បឝ្យត យស្យ បាទយោះ បាទុកយោ រ្ពន្ធនេ មោចយិតុមបិ យោគ្យោ ន ភវាមិ តាទ្ឫឝ ឯកោ ជនោ មម បឝ្ចាទ៑ ឧបតិឞ្ឋតិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","ហេ ឥព្រាហីមោ វំឝជាតា ភ្រាតរោ ហេ ឦឝ្វរភីតាះ សវ៌្វលោកា យុឞ្មាន៑ ប្រតិ បរិត្រាណស្យ កថៃឞា ប្រេរិតា។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","យិរូឝាលម្និវាសិនស្តេឞាម៑ អធិបតយឝ្ច តស្យ យីឝោះ បរិចយំ ន ប្រាប្យ ប្រតិវិឝ្រាមវារំ បឋ្យមានានាំ ភវិឞ្យទ្វាទិកថានាម៑ អភិប្រាយម៑ អពុទ្ធ្វា ច តស្យ វធេន តាះ កថាះ សផលា អកុវ៌្វន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","ប្រាណហននស្យ កមបិ ហេតុម៑ អប្រាប្យាបិ បីលាតស្យ និកដេ តស្យ វធំ ប្រាត៌្ហយន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","តស្មិន៑ យាះ កថា លិខិតាះ សន្តិ តទនុសារេណ កម៌្ម សម្បាទ្យ តំ ក្រុឝាទ៑ អវតាយ៌្យ ឝ្មឝានេ ឝាយិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","កិន្ត្វីឝ្វរះ ឝ្មឝានាត៑ តមុទស្ថាបយត៑, ");
INSERT INTO sankhm_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","បុនឝ្ច គាលីលប្រទេឝាទ៑ យិរូឝាលមនគរំ តេន សាទ៌្ធំ យេ លោកា អាគច្ឆន៑ ស ពហុទិនានិ តេភ្យោ ទឝ៌នំ ទត្តវាន៑, អតស្ត ឥទានីំ លោកាន៑ ប្រតិ តស្យ សាក្ឞិណះ សន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","អស្មាកំ បូវ៌្វបុរុឞាណាំ សមក្ឞម៑ ឦឝ្វរោ យស្មិន៑ ប្រតិជ្ញាតវាន៑ យថា, ត្វំ មេ បុត្រោសិ ចាទ្យ ត្វាំ សមុត្ថាបិតវានហម៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ឥទំ យទ្វចនំ ទ្វិតីយគីតេ លិខិតមាស្តេ តទ៑ យីឝោរុត្ថានេន តេឞាំ សន្តានា យេ វយម៑ អស្មាកំ សន្និធៅ តេន ប្រត្យក្ឞី ក្ឫតំ, យុឞ្មាន៑ ឥមំ សុសំវាទំ ជ្ញាបយាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","បរមេឝ្វរេណ ឝ្មឝានាទ៑ ឧត្ថាបិតំ តទីយំ ឝរីរំ កទាបិ ន ក្ឞេឞ្យតេ, ឯតស្មិន៑ ស ស្វយំ កថិតវាន៑ យថា ទាយូទំ ប្រតិ ប្រតិជ្ញាតោ យោ វរស្តមហំ តុភ្យំ ទាស្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","ឯតទន្យស្មិន៑ គីតេៜបិ កថិតវាន៑។ ស្វកីយំ បុណ្យវន្តំ ត្វំ ក្ឞយិតុំ ន ច ទាស្យសិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","ទាយូទា ឦឝ្វរាភិមតសេវាយៃ និជាយុឞិ វ្យយិតេ សតិ ស មហានិទ្រាំ ប្រាប្យ និជៃះ បូវ៌្វបុរុឞៃះ សហ មិលិតះ សន៑ អក្ឞីយត; ");
INSERT INTO sankhm_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","កិន្តុ យមីឝ្វរះ ឝ្មឝានាទ៑ ឧទស្ថាបយត៑ ស នាក្ឞីយត។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","អតោ ហេ ភ្រាតរះ, អនេន ជនេន បាបមោចនំ ភវតីតិ យុឞ្មាន៑ ប្រតិ ប្រចារិតម៑ អាស្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ផលតោ មូសាវ្យវស្ថយា យូយំ យេភ្យោ ទោឞេភ្យោ មុក្តា ភវិតុំ ន ឝក្ឞ្យថ តេភ្យះ សវ៌្វទោឞេភ្យ ឯតស្មិន៑ ជនេ វិឝ្វាសិនះ សវ៌្វេ មុក្តា ភវិឞ្យន្តីតិ យុឞ្មាភិ រ្ជ្ញាយតាំ។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","អបរញ្ច។ អវជ្ញាការិណោ លោកាឝ្ចក្ឞុរុន្មីល្យ បឝ្យត។ តថៃវាសម្ភវំ ជ្ញាត្វា ស្យាត យូយំ វិលជ្ជិតាះ។ យតោ យុឞ្មាសុ តិឞ្ឋត្សុ ករិឞ្យេ កម៌្ម តាទ្ឫឝំ។ យេនៃវ តស្យ វ្ឫត្តាន្តេ យុឞ្មភ្យំ កថិតេៜបិ ហិ។ យូយំ ន តន្តុ វ្ឫត្តាន្តំ ប្រត្យេឞ្យថ កទាចន៕ ");
INSERT INTO sankhm_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","យេយំ កថា ភវិឞ្យទ្វាទិនាំ គ្រន្ថេឞុ លិខិតាស្តេ សាវធានា ភវត ស កថា យថា យុឞ្មាន៑ ប្រតិ ន ឃដតេ។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","យិហូទីយភជនភវនាន៑ និគ៌តយោស្តយោ រ្ភិន្នទេឝីយៃ រ្វក្ឞ្យមាណា ប្រាត៌្ហនា ក្ឫតា, អាគាមិនិ វិឝ្រាមវារេៜបិ កថេយម៑ អស្មាន៑ ប្រតិ ប្រចារិតា ភវត្វិតិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","សភាយា ភង្គេ សតិ ពហវោ យិហូទីយលោកា យិហូទីយមតគ្រាហិណោ ភក្តលោកាឝ្ច ពណ៌ព្ពាបៅលយោះ បឝ្ចាទ៑ អាគច្ឆន៑, តេន តៅ តៃះ សហ នានាកថាះ កថយិត្វេឝ្វរានុគ្រហាឝ្រយេ ស្ថាតុំ តាន៑ ប្រាវត៌្តយតាំ។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","បរវិឝ្រាមវារេ នគរស្យ ប្រាយេណ សវ៌្វេ លាកា ឦឝ្វរីយាំ កថាំ ឝ្រោតុំ មិលិតាះ, ");
INSERT INTO sankhm_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","កិន្តុ យិហូទីយលោកា ជននិវហំ វិលោក្យ ឦឞ៌្យយា បរិបូណ៌ាះ សន្តោ វិបរីតកថាកថនេនេឝ្វរនិន្ទយា ច បៅលេនោក្តាំ កថាំ ខណ្ឌយិតុំ ចេឞ្ដិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","តតះ បៅैលពណ៌ព្ពាវក្ឞោភៅ កថិតវន្តៅ ប្រថមំ យុឞ្មាកំ សន្និធាវីឝ្វរីយកថាយាះ ប្រចារណម៑ ឧចិតមាសីត៑ កិន្តុំ តទគ្រាហ្យត្វករណេន យូយំ ស្វាន៑ អនន្តាយុឞោៜយោគ្យាន៑ ទឝ៌យថ, ឯតត្ការណាទ៑ វយម៑ អន្យទេឝីយលោកានាំ សមីបំ គច្ឆាមះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ប្រភុរស្មាន៑ ឥត្ថម៑ អាទិឞ្ដវាន៑ យថា, យាវច្ច ជគតះ សីមាំ លោកានាំ ត្រាណការណាត៑។ មយាន្យទេឝមធ្យេ ត្វំ ស្ថាបិតោ ភូះ ប្រទីបវត៑៕ ");
INSERT INTO sankhm_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","តទា កថាមីទ្ឫឝីំ ឝ្រុត្វា ភិន្នទេឝីយា អាហ្លាទិតាះ សន្តះ ប្រភោះ កថាំ ធន្យាំ ធន្យាម៑ អវទន៑, យាវន្តោ លោកាឝ្ច បរមាយុះ ប្រាប្តិនិមិត្តំ និរូបិតា អាសន៑ តេे វ្យឝ្វសន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ឥត្ថំ ប្រភោះ កថា សវ៌្វេទេឝំ វ្យាប្នោត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","កិន្តុ យិហូទីយា នគរស្យ ប្រធានបុរុឞាន៑ សម្មាន្យាះ កថិបយា ភក្តា យោឞិតឝ្ច កុប្រវ្ឫត្តិំ គ្រាហយិត្វា បៅលពណ៌ព្ពៅ តាឌយិត្វា តស្មាត៑ ប្រទេឝាទ៑ ទូរីក្ឫតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","អតះ ការណាត៑ តៅ និជបទធូលីស្តេឞាំ ប្រាតិកូល្យេន បាតយិត្វេेកនិយំ នគរំ គតៅ។ ");
INSERT INTO sankhm_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","តតះ ឝិឞ្យគណ អានន្ទេន បវិត្រេណាត្មនា ច បរិបូណ៌ោភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","តៅ ទ្វៅ ជនៅ យុគបទ៑ ឥកនិយនគរស្ថយិហូទីយានាំ ភជនភវនំ គត្វា យថា ពហវោ យិហូទីយា អន្យទេेឝីយលោកាឝ្ច វ្យឝ្វសន៑ តាទ្ឫឝីំ កថាំ កថិតវន្តៅ។ ");
INSERT INTO sankhm_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","កិន្តុ វិឝ្វាសហីនា យិហូទីយា អន្យទេឝីយលោកាន៑ កុប្រវ្ឫត្តិំ គ្រាហយិត្វា ភ្រាត្ឫគណំ ប្រតិ តេឞាំ វៃរំ ជនិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","អតះ ស្វានុគ្រហកថាយាះ ប្រមាណំ ទត្វា តយោ រ្ហស្តៃ រ្ពហុលក្ឞណម៑ អទ្ភុតកម៌្ម ច ប្រាកាឝយទ៑ យះ ប្រភុស្តស្យ កថា អក្ឞោភេន ប្រចាយ៌្យ តៅ តត្រ ពហុទិនានិ សមវាតិឞ្ឋេតាំ។ ");
INSERT INTO sankhm_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","កិន្តុ កិយន្តោ លោកា យិហូទីយានាំ សបក្ឞាះ កិយន្តោ លោកាះ ប្រេរិតានាំ សបក្ឞា ជាតាះ, អតោ នាគរិកជននិវហមធ្យេ ភិន្នវាក្យត្វម៑ អភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","អន្យទេឝីយា យិហូទីយាស្តេឞាម៑ អធិបតយឝ្ច ទៅរាត្ម្យំ កុត្វា តៅ ប្រស្តរៃរាហន្តុម៑ ឧទ្យតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","តៅ តទ្វាត៌្តាំ ប្រាប្យ បលាយិត្វា លុកាយនិយាទេឝស្យាន្តវ៌្វត៌្តិលុស្ត្រាទព៌្ពោ ");
INSERT INTO sankhm_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","តត្សមីបស្ថទេឝញ្ច គត្វា តត្រ សុសំវាទំ ប្រចារយតាំ។ ");
INSERT INTO sankhm_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","តត្រោភយបាទយោឝ្ចលនឝក្តិហីនោ ជន្មារភ្យ ខញ្ជះ កទាបិ គមនំ នាករោត៑ ឯតាទ្ឫឝ ឯកោ មានុឞោ លុស្ត្រានគរ ឧបវិឝ្យ បៅលស្យ កថាំ ឝ្រុតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ឯតស្មិន៑ សមយេ បៅលស្តម្ប្រតិ ទ្ឫឞ្ដិំ ក្ឫត្វា តស្យ ស្វាស្ថ្យេ វិឝ្វាសំ វិទិត្វា ប្រោច្ចៃះ កថិតវាន្ ");
INSERT INTO sankhm_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","បទ្ភ្យាមុត្តិឞ្ឋន៑ ឫជុ រ្ភវ។ តតះ ស ឧល្លម្ផំ ក្ឫត្វា គមនាគមនេ កុតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","តទា លោកាះ បៅលស្យ តត៑ កាយ៌្យំ វិលោក្យ លុកាយនីយភាឞយា ប្រោច្ចៃះ កថាមេតាំ កថិតវន្តះ, ទេវា មនុឞ្យរូបំ ធ្ឫត្វាស្មាកំ សមីបម៑ អវារោហន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","តេ ពណ៌ព្ពាំ យូបិតរម៑ អវទន៑ បៅលឝ្ច មុខ្យោ វក្តា តស្មាត៑ តំ មក៌ុរិយម៑ អវទន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","តស្យ នគរស្យ សម្មុខេ ស្ថាបិតស្យ យូបិតរវិគ្រហស្យ យាជកោ វ្ឫឞាន៑ បុឞ្បមាលាឝ្ច ទ្វារសមីបម៑ អានីយ លោកៃះ សទ៌្ធំ តាវុទ្ទិឝ្យ សមុត្ស្ឫជ្យ ទាតុម៑ ឧទ្យតះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","តទ្វាត៌្តាំ ឝ្រុត្វា ពណ៌ព្ពាបៅលៅ ស្វីយវស្ត្រាណិ ឆិត្វា លោកានាំ មធ្យំ វេគេន ប្រវិឝ្យ ប្រោច្ចៃះ កថិតវន្តៅ, ");
INSERT INTO sankhm_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","ហេ មហេច្ឆាះ កុត ឯតាទ្ឫឝំ កម៌្ម កុរុថ? អាវាមបិ យុឞ្មាទ្ឫឝៅ សុខទុះខភោគិនៅ មនុឞ្យៅ, យុយម៑ ឯតាះ សវ៌្វា វ្ឫថាកល្បនាះ បរិត្យជ្យ យថា គគណវសុន្ធរាជលនិធីនាំ តន្មធ្យស្ថានាំ សវ៌្វេឞាញ្ច ស្រឞ្ដារមមរម៑ ឦឝ្វរំ ប្រតិ បរាវត៌្តធ្វេ តទត៌្ហម៑ អាវាំ យុឞ្មាកំ សន្និធៅ សុសំវាទំ ប្រចារយាវះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ស ឦឝ្វរះ បូវ៌្វកាលេ សវ៌្វទេឝីយលោកាន៑ ស្វស្វមាគ៌េ ចលិតុមនុមតិំ ទត្តវាន៑, ");
INSERT INTO sankhm_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","តថាបិ អាកាឝាត៑ តោយវឞ៌ណេន នានាប្រការឝស្យោត្បត្យា ច យុឞ្មាកំ ហិតៃឞី សន៑ ភក្ឞ្យៃរាននទេន ច យុឞ្មាកម៑ អន្តះករណានិ តប៌យន៑ តានិ ទានានិ និជសាក្ឞិស្វរូបាណិ ស្ថបិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","កិន្តុ តាទ្ឫឝាយាំ កថាយាំ កថិតាយាមបិ តយោះ សមីប ឧត្សជ៌នាត៑ លោកនិវហំ ប្រាយេណ និវត៌្តយិតុំ នាឝក្នុតាម៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","អាន្តិយខិយា-ឥកនិយនគរាភ្យាំ កតិបយយិហូទីយលោកា អាគត្យ លោកាន៑ ប្រាវត៌្តយន្ត តស្មាត៑ តៃ បៅលំ ប្រស្តរៃរាឃ្នន៑ តេន ស ម្ឫត ឥតិ វិជ្ញាយ នគរស្យ ពហិស្តម៑ អាក្ឫឞ្យ នីតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","កិន្តុ ឝិឞ្យគណេ តស្យ ចតុទ៌ិឝិ តិឞ្ឋតិ សតិ ស ស្វយម៑ ឧត្ថាយ បុនរបិ នគរមធ្យំ ប្រាវិឝត៑ តត្បរេៜហនិ ពណ៌ព្ពាសហិតោ ទព៌្ពីនគរំ គតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","តត្រ សុសំវាទំ ប្រចាយ៌្យ ពហុលោកាន៑ ឝិឞ្យាន៑ ក្ឫត្វា តៅ លុស្ត្រាម៑ ឥកនិយម៑ អាន្តិយខិយាញ្ច បរាវ្ឫត្យ គតៅ។ ");
INSERT INTO sankhm_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ពហុទុះខានិ ភុក្ត្វាបីឝ្វររាជ្យំ ប្រវេឞ្ដវ្យម៑ ឥតិ ការណាទ៑ ធម៌្មមាគ៌េ ស្ថាតុំ វិនយំ ក្ឫត្វា ឝិឞ្យគណស្យ មនះស្ថៃយ៌្យម៑ អកុរុតាំ។ ");
INSERT INTO sankhm_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","មណ្ឌលីនាំ ប្រាចីនវគ៌ាន៑ និយុជ្យ ប្រាត៌្ហនោបវាសៅ ក្ឫត្វា យត្ប្រភៅ តេ វ្យឝ្វសន៑ តស្យ ហស្តេ តាន៑ សមប៌្យ ");
INSERT INTO sankhm_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","បិសិទិយាមធ្យេន បាម្ផុលិយាទេឝំ គតវន្តៅ។ ");
INSERT INTO sankhm_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","បឝ្ចាត៑ បគ៌ានគរំ គត្វា សុសំវាទំ ប្រចាយ៌្យ អត្តាលិយានគរំ ប្រស្ថិតវន្តៅ។ ");
INSERT INTO sankhm_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","តស្មាត៑ សមុទ្របថេន គត្វា តាភ្យាំ យត៑ កម៌្ម សម្បន្នំ តត្កម៌្ម សាធយិតុំ យន្នគរេ ទយាលោរីឝ្វរស្យ ហស្តេ សមប៌ិតៅ ជាតៅ តទ៑ អាន្តិយខិយានគរំ គតវន្តា។ ");
INSERT INTO sankhm_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","តត្រោបស្ថាយ តន្នគរស្ថមណ្ឌលីំ សំគ្ឫហ្យ ស្វាភ្យាម ឦឝ្វរោ យទ្យត៑ កម៌្មករោត៑ តថា យេន ប្រការេណ ភិន្នទេឝីយលោកាន៑ ប្រតិ វិឝ្វាសរូបទ្វារម៑ អមោចយទ៑ ឯតាន៑ សវ៌្វវ្ឫត្តាន្តាន៑ តាន៑ ជ្ញាបិតវន្តៅ។ ");
INSERT INTO sankhm_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","តតស្តៅ ឝិយ៌្យៃះ សាទ៌្ធំ តត្រ ពហុទិនានិ ន្យវសតាម៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","យិហូទាទេឝាត៑ កិយន្តោ ជនា អាគត្យ ភ្រាត្ឫគណមិត្ថំ ឝិក្ឞិតវន្តោ មូសាវ្យវស្ថយា យទិ យុឞ្មាកំ ត្វក្ឆេទោ ន ភវតិ តហ៌ិ យូយំ បរិត្រាណំ ប្រាប្តុំ ន ឝក្ឞ្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","បៅលពណ៌ព្ពៅ តៃះ សហ ពហូន៑ វិចារាន៑ វិវាទាំឝ្ច ក្ឫតវន្តៅ, តតោ មណ្ឌលីយនោកា ឯតស្យាះ កថាយាស្តត្ត្វំ ជ្ញាតុំ យិរូឝាលម្នគរស្ថាន៑ ប្រេរិតាន៑ ប្រាចីនាំឝ្ច ប្រតិ បៅលពណ៌ព្ពាប្រភ្ឫតីន៑ កតិបយជនាន៑ ប្រេឞយិតុំ និឝ្ចយំ ក្ឫតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","តេ មណ្ឌល្យា ប្រេរិតាះ សន្តះ ផៃណីកីឝោមិរោន្ទេឝាភ្យាំ គត្វា ភិន្នទេឝីយានាំ មនះបរិវត៌្តនស្យ វាត៌្តយា ភ្រាត្ឫណាំ បរមាហ្លាទម៑ អជនយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","យិរូឝាលម្យុបស្ថាយ ប្រេរិតគណេន លោកប្រាចីនគណេន សមាជេន ច សមុបគ្ឫហីតាះ សន្តះ ស្វៃរីឝ្វរោ យានិ កម៌្មាណិ ក្ឫតវាន៑ តេឞាំ សវ៌្វវ្ឫត្តាន្តាន៑ តេឞាំ សមក្ឞម៑ អកថយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","កិន្តុ វិឝ្វាសិនះ កិយន្តះ ផិរូឝិមតគ្រាហិណោ លោកា ឧត្ថាយ កថាមេតាំ កថិតវន្តោ ភិន្នទេឝីយានាំ ត្វក្ឆេទំ កត៌្តុំ មូសាវ្យវស្ថាំ បាលយិតុញ្ច សមាទេឞ្ដវ្យម៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","តតះ ប្រេរិតា លោកប្រាចីនាឝ្ច តស្យ វិវេចនាំ កត៌្តុំ សភាយាំ ស្ថិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","ពហុវិចារេឞុ ជាតឞុ បិតរ ឧត្ថាយ កថិតវាន៑, ហេ ភ្រាតរោ យថា ភិន្នទេឝីយលោកា មម មុខាត៑ សុសំវាទំ ឝ្រុត្វា វិឝ្វសន្តិ តទត៌្ហំ ពហុទិនាត៑ បូវ៌្វម៑ ឦឝ្វរោស្មាកំ មធ្យេ មាំ វ្ឫត្វា និយុក្តវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","អន្តយ៌្យាមីឝ្វរោ យថាស្មភ្យំ តថា ភិន្នទេឝីយេភ្យះ បវិត្រមាត្មានំ ប្រទាយ វិឝ្វាសេន តេឞាម៑ អន្តះករណានិ បវិត្រាណិ ក្ឫត្វា ");
INSERT INTO sankhm_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","តេឞាម៑ អស្មាកញ្ច មធ្យេ កិមបិ វិឝេឞំ ន ស្ថាបយិត្វា តានធិ ស្វយំ ប្រមាណំ ទត្តវាន៑ ឥតិ យូយំ ជានីថ។ ");
INSERT INTO sankhm_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","អតឯវាស្មាកំ បូវ៌្វបុរុឞា វយញ្ច ស្វយំ យទ្យុគស្យ ភារំ សោឍុំ ន ឝក្តាះ សម្ប្រតិ តំ ឝិឞ្យគណស្យ ស្កន្ធេឞុ ន្យសិតុំ កុត ឦឝ្វរស្យ បរីក្ឞាំ ករិឞ្យថ? ");
INSERT INTO sankhm_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","ប្រភោ រ្យីឝុខ្រីឞ្ដស្យានុគ្រហេណ តេ យថា វយមបិ តថា បរិត្រាណំ ប្រាប្តុម៑ អាឝាំ កុម៌្មះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","អនន្តរំ ពណ៌ព្ពាបៅលាភ្យាម៑ ឦឝ្វរោ ភិន្នទេឝីយានាំ មធ្យេ យទ្យទ៑ អាឝ្ចយ៌្យម៑ អទ្ភុតញ្ច កម៌្ម ក្ឫតវាន៑ តទ្វ្ឫត្តាន្តំ តៅ ស្វមុខាភ្យាម៑ អវណ៌យតាំ សភាស្ថាះ សវ៌្វេ នីរវាះ សន្តះ ឝ្រុតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","តយោះ កថាយាំ សមាប្តាយាំ សត្យាំ យាកូព៑ កថយិតុម៑ អារព្ធវាន្ ");
INSERT INTO sankhm_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ហេ ភ្រាតរោ មម កថាយាម៑ មនោ និធត្ត។ ឦឝ្វរះ ស្វនាមាត៌្ហំ ភិន្នទេឝីយលោកានាម៑ មធ្យាទ៑ ឯកំ លោកសំឃំ គ្រហីតុំ មតិំ ក្ឫត្វា យេន ប្រការេណ ប្រថមំ តាន៑ ប្រតិ ក្ឫបាវលេកនំ ក្ឫតវាន៑ តំ ឝិមោន៑ វណ៌ិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ភវិឞ្យទ្វាទិភិរុក្តានិ យានិ វាក្យានិ តៃះ សាទ៌្ធម៑ ឯតស្យៃក្យំ ភវតិ យថា លិខិតមាស្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","សវ៌្វេឞាំ កម៌្មណាំ យស្តុ សាធកះ បរមេឝ្វរះ។ ស ឯវេទំ វទេទ្វាក្យំ ឝេឞាះ សកលមានវាះ។ ភិន្នទេឝីយលោកាឝ្ច យាវន្តោ មម នាមតះ។ ភវន្តិ ហិ សុវិខ្យាតាស្តេ យថា បរមេឝិតុះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","តត្វំ សម្យក៑ សមីហន្តេ តន្និមិត្តមហំ កិល។ បរាវ្ឫត្យ សមាគត្យ ទាយូទះ បតិតំ បុនះ។ ទូឞ្យមុត្ថាបយិឞ្យាមិ តទីយំ សវ៌្វវស្តុ ច។ បតិតំ បុនរុថាប្យ សជ្ជយិឞ្យាមិ សវ៌្វថា៕ ");
INSERT INTO sankhm_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","អា ប្រថមាទ៑ ឦឝ្វរះ ស្វីយានិ សវ៌្វកម៌្មាណិ ជានាតិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","អតឯវ មម និវេទនមិទំ ភិន្នទេឝីយលោកានាំ មធ្យេ យេ ជនា ឦឝ្វរំ ប្រតិ បរាវត៌្តន្ត តេឞាមុបរិ អន្យំ កមបិ ភារំ ន ន្យស្យ ");
INSERT INTO sankhm_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ទេវតាប្រសាទាឝុចិភក្ឞ្យំ វ្យភិចារកម៌្ម កណ្ឋសម្បីឌនមារិតប្រាណិភក្ឞ្យំ រក្តភក្ឞ្យញ្ច ឯតានិ បរិត្យក្តុំ លិខាមះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","យតះ បូវ៌្វកាលតោ មូសាវ្យវស្ថាប្រចារិណោ លោកា នគរេ នគរេ សន្តិ ប្រតិវិឝ្រាមវារញ្ច ភជនភវនេ តស្យាះ បាឋោ ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","តតះ បរំ ប្រេរិតគណោ លោកប្រាចីនគណះ សវ៌្វា មណ្ឌលី ច ស្វេឞាំ មធ្យេ ពឝ៌ព្ពា នាម្នា វិខ្យាតោ មនោនីតៅ ក្ឫត្វា បៅលពណ៌ព្ពាភ្យាំ សាទ៌្ធម៑ អាន្តិយខិយានគរំ ប្រតិ ប្រេឞណម៑ ឧចិតំ ពុទ្ធ្វា តាភ្យាំ បត្រំ ប្រៃឞយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","តស្មិន៑ បត្រេ លិខិតមិំទ, អាន្តិយខិយា-សុរិយា-កិលិកិយាទេឝស្ថភិន្នទេឝីយភ្រាត្ឫគណាយ ប្រេរិតគណស្យ លោកប្រាចីនគណស្យ ភ្រាត្ឫគណស្យ ច នមស្ការះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","វិឝេឞតោៜស្មាកម៑ អាជ្ញាម៑ អប្រាប្យាបិ កិយន្តោ ជនា អស្មាកំ មធ្យាទ៑ គត្វា ត្វក្ឆេទោ មូសាវ្យវស្ថា ច បាលយិតវ្យាវិតិ យុឞ្មាន៑ ឝិក្ឞយិត្វា យុឞ្មាកំ មនសាមស្ថៃយ៌្យំ ក្ឫត្វា យុឞ្មាន៑ សសន្ទេហាន៑ អកុវ៌្វន៑ ឯតាំ កថាំ វយម៑ អឝ្ឫន្ម។ ");
INSERT INTO sankhm_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","តត្ការណាទ៑ វយម៑ ឯកមន្ត្រណាះ សន្តះ សភាយាំ ស្ថិត្វា ប្រភោ រ្យីឝុខ្រីឞ្ដស្យ នាមនិមិត្តំ ម្ឫត្យុមុខគតាភ្យាមស្មាកំ ");
INSERT INTO sankhm_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ប្រិយពណ៌ព្ពាបៅលាភ្យាំ សាទ៌្ធំ មនោនីតលោកានាំ កេឞាញ្ចិទ៑ យុឞ្មាកំ សន្និធៅ ប្រេឞណម៑ ឧចិតំ ពុទ្ធវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","អតោ យិហូទាសីលៅ យុឞ្មាន៑ ប្រតិ ប្រេឞិតវន្តះ, ឯតយោ រ្មុខាភ្យាំ សវ៌្វាំ កថាំ ជ្ញាស្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","ទេវតាប្រសាទភក្ឞ្យំ រក្តភក្ឞ្យំ គលបីឌនមារិតប្រាណិភក្ឞ្យំ វ្យភិចារកម៌្ម ចេមានិ សវ៌្វាណិ យុឞ្មាភិស្ត្យាជ្យានិ; ឯតត្ប្រយោជនីយាជ្ញាវ្យតិរេកេន យុឞ្មាកម៑ ឧបរិ ភារមន្យំ ន ន្យសិតុំ បវិត្រស្យាត្មនោៜស្មាកញ្ច ឧចិតជ្ញានម៑ អភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","អតឯវ តេភ្យះ សវ៌្វេភ្យះ ស្វេឞុ រក្ឞិតេឞុ យូយំ ភទ្រំ កម៌្ម ករិឞ្យថ។ យុឞ្មាកំ មង្គលំ ភូយាត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","តេे វិស្ឫឞ្ដាះ សន្ត អាន្តិយខិយានគរ ឧបស្ថាយ លោកនិវហំ សំគ្ឫហ្យ បត្រម៑ អទទន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","តតស្តេ តត្បត្រំ បឋិត្វា សាន្ត្វនាំ ប្រាប្យ សានន្ទា អភវន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","យិហូទាសីលៅ ច ស្វយំ ប្រចារកៅ ភូត្វា ភ្រាត្ឫគណំ នានោបទិឝ្យ តាន៑ សុស្ថិរាន៑ អកុរុតាម៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ឥត្ថំ តៅ តត្រ តៃះ សាកំ កតិបយទិនានិ យាបយិត្វា បឝ្ចាត៑ ប្រេរិតានាំ សមីបេ ប្រត្យាគមនាត៌្ហំ តេឞាំ សន្និធេះ កល្យាណេន វិស្ឫឞ្ដាវភវតាំ។ ");
INSERT INTO sankhm_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","កិន្តុ សីលស្តត្រ ស្ថាតុំ វាញ្ឆិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","អបរំ បៅលពណ៌ព្ពៅ ពហវះ ឝិឞ្យាឝ្ច លោកាន៑ ឧបទិឝ្យ ប្រភោះ សុសំវាទំ ប្រចារយន្ត អាន្តិយខិយាយាំ កាលំ យាបិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","កតិបយទិនេឞុ គតេឞុ បៅលោ ពណ៌ព្ពាម៑ អវទត៑ អាគច្ឆាវាំ យេឞុ នគរេឞ្វីឝ្វរស្យ សុសំវាទំ ប្រចារិតវន្តៅ តានិ សវ៌្វនគរាណិ បុនគ៌ត្វា ភ្រាតរះ កីទ្ឫឝាះ សន្តីតិ ទ្រឞ្ដុំ តាន៑ សាក្ឞាត៑ កុវ៌្វះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","តេន មាក៌នាម្នា វិខ្យាតំ យោហនំ សង្គិនំ កត៌្តុំ ពណ៌ព្ពា មតិមករោត៑, ");
INSERT INTO sankhm_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","កិន្តុ ស បូវ៌្វំ តាភ្យាំ សហ កាយ៌្យាត៌្ហំ ន គត្វា បាម្ផូលិយាទេឝេ តៅ ត្យក្តវាន៑ តត្ការណាត៑ បៅលស្តំ សង្គិនំ កត៌្តុម៑ អនុចិតំ ជ្ញាតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ឥត្ថំ តយោរតិឝយវិរោធស្យោបស្ថិតត្វាត៑ តៅ បរស្បរំ ប្ឫថគភវតាំ តតោ ពណ៌ព្ពា មាក៌ំ គ្ឫហីត្វា បោតេន កុប្រោបទ្វីបំ គតវាន៑; ");
INSERT INTO sankhm_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","កិន្តុ បៅលះ សីលំ មនោនីតំ ក្ឫត្វា ភ្រាត្ឫភិរីឝ្វរានុគ្រហេ សមប៌ិតះ សន៑ ប្រស្ថាយ ");
INSERT INTO sankhm_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","សុរិយាកិលិកិយាទេឝាភ្យាំ មណ្ឌលីះ ស្ថិរីកុវ៌្វន៑ អគច្ឆត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","បៅលោ ទព៌្ពីលុស្ត្រានគរយោរុបស្ថិតោភវត៑ តត្រ តីមថិយនាមា ឝិឞ្យ ឯក អាសីត៑; ស វិឝ្វាសិន្យា យិហូទីយាយា យោឞិតោ គព៌្ភជាតះ កិន្តុ តស្យ បិតាន្យទេឝីយលោកះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","ស ជនោ លុស្ត្រា-ឥកនិយនគរស្ថានាំ ភ្រាត្ឫណាំ សមីបេបិ សុខ្យាតិមាន៑ អាសីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","បៅលស្តំ ស្វសង្គិនំ កត៌្តុំ មតិំ ក្ឫត្វា តំ គ្ឫហីត្វា តទ្ទេឝនិវាសិនាំ យិហូទីយានាម៑ អនុរោធាត៑ តស្យ ត្វក្ឆេទំ ក្ឫតវាន៑ យតស្តស្យ បិតា ភិន្នទេឝីយលោក ឥតិ សវ៌្វៃរជ្ញាយត។ ");
INSERT INTO sankhm_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","តតះ បរំ តេ នគរេ នគរេ ភ្រមិត្វា យិរូឝាលមស្ថៃះ ប្រេរិតៃ រ្លោកប្រាចីនៃឝ្ច និរូបិតំ យទ៑ វ្យវស្ថាបត្រំ តទនុសារេណាចរិតុំ លោកេភ្យស្តទ៑ ទត្តវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","តេនៃវ សវ៌្វេ ធម៌្មសមាជាះ ខ្រីឞ្ដធម៌្មេ សុស្ថិរាះ សន្តះ ប្រតិទិនំ វទ៌្ធិតា អភវន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","តេឞុ ផ្រុគិយាគាលាតិយាទេឝមធ្យេន គតេឞុ សត្សុ បវិត្រ អាត្មា តាន៑ អាឝិយាទេឝេ កថាំ ប្រកាឝយិតុំ ប្រតិឞិទ្ធវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","តថា មុសិយាទេឝ ឧបស្ថាយ ពិថុនិយាំ គន្តុំ តៃរុទ្យោគេ ក្ឫតេ អាត្មា តាន៑ នាន្វមន្យត។ ");
INSERT INTO sankhm_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","តស្មាត៑ តេ មុសិយាទេឝំ បរិត្យជ្យ ត្រោយានគរំ គត្វា សមុបស្ថិតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","រាត្រៅ បៅលះ ស្វប្នេ ទ្ឫឞ្ដវាន៑ ឯកោ មាកិទនិយលោកស្តិឞ្ឋន៑ វិនយំ ក្ឫត្វា តស្មៃ កថយតិ, មាកិទនិយាទេឝម៑ អាគត្យាស្មាន៑ ឧបកុវ៌្វិតិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","តស្យេត្ថំ ស្វប្នទឝ៌នាត៑ ប្រភុស្តទ្ទេឝីយលោកាន៑ ប្រតិ សុសំវាទំ ប្រចារយិតុម៑ អស្មាន៑ អាហូយតីតិ និឝ្ចិតំ ពុទ្ធ្វា វយំ តូណ៌ំ មាកិទនិយាទេឝំ គន្តុម៑ ឧទ្យោគម៑ អកុម៌្ម។ ");
INSERT INTO sankhm_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","តតះ បរំ វយំ ត្រោយានគរាទ៑ ប្រស្ថាយ ឫជុមាគ៌េណ សាមថ្រាកិយោបទ្វីបេន គត្វា បរេៜហនិ និយាបលិនគរ ឧបស្ថិតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","តស្មាទ៑ គត្វា មាកិទនិយាន្តវ៌្វត៌្តិ រោមីយវសតិស្ថានំ យត៑ ផិលិបីនាមប្រធាននគរំ តត្រោបស្ថាយ កតិបយទិនានិ តត្រ ស្ថិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","វិឝ្រាមវារេ នគរាទ៑ ពហិ រ្គត្វា នទីតដេ យត្រ ប្រាត៌្ហនាចារ អាសីត៑ តត្រោបវិឝ្យ សមាគតា នារីះ ប្រតិ កថាំ ប្រាចារយាម។ ");
INSERT INTO sankhm_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","តតះ ថុយាតីរានគរីយា ធូឞរាម្ពរវិក្រាយិណី លុទិយានាមិកា យា ឦឝ្វរសេវិកា យោឞិត៑ ឝ្រោត្រីណាំ មធ្យ អាសីត៑ តយា បៅលោក្តវាក្យានិ យទ៑ គ្ឫហ្យន្តេ តទត៌្ហំ ប្រភុស្តស្យា មនោទ្វារំ មុក្តវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","អតះ សា យោឞិត៑ សបរិវារា មជ្ជិតា សតី វិនយំ ក្ឫត្វា កថិតវតី, យុឞ្មាកំ វិចារាទ៑ យទិ ប្រភៅ វិឝ្វាសិនី ជាតាហំ តហ៌ិ មម គ្ឫហម៑ អាគត្យ តិឞ្ឋត។ ឥត្ថំ សា យត្នេនាស្មាន៑ អស្ថាបយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","យស្យា គណនយា តទធិបតីនាំ ពហុធនោបាជ៌នំ ជាតំ តាទ្ឫឝី គណកភូតគ្រស្តា កាចន ទាសី ប្រាត៌្ហនាស្ថានគមនកាល អាគត្យាស្មាន៑ សាក្ឞាត៑ ក្ឫតវតី។ ");
INSERT INTO sankhm_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","សាស្មាកំ បៅលស្យ ច បឝ្ចាទ៑ ឯត្យ ប្រោច្ចៃះ កថាមិមាំ កថិតវតី, មនុឞ្យា ឯតេ សវ៌្វោបរិស្ថស្យេឝ្វរស្យ សេវកាះ សន្តោៜស្មាន៑ ប្រតិ បរិត្រាណស្យ មាគ៌ំ ប្រកាឝយន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","សា កន្យា ពហុទិនានិ តាទ្ឫឝម៑ អករោត៑ តស្មាត៑ បៅលោ ទុះខិតះ សន៑ មុខំ បរាវត៌្យ តំ ភូតមវទទ៑, អហំ យីឝុខ្រីឞ្ដស្យ នាម្នា ត្វាមាជ្ញាបយាមិ ត្វមស្យា ពហិគ៌ច្ឆ; តេនៃវ តត្ក្ឞណាត៑ ស ភូតស្តស្យា ពហិគ៌តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","តតះ ស្វេឞាំ លាភស្យ ប្រត្យាឝា វិផលា ជាតេតិ វិលោក្យ តស្យាះ ប្រភវះ បៅលំ សីលញ្ច ធ្ឫត្វាក្ឫឞ្យ វិចារស្ថានេៜធិបតីនាំ សមីបម៑ អានយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","តតះ ឝាសកានាំ និកដំ នីត្វា រោមិលោកា វយម៑ អស្មាកំ យទ៑ វ្យវហរណំ គ្រហីតុម៑ អាចរិតុញ្ច និឞិទ្ធំ, ");
INSERT INTO sankhm_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ឥមេ យិហូទីយលោកាះ សន្តោបិ តទេវ ឝិក្ឞយិត្វា នគរេៜស្មាកម៑ អតីវ កលហំ កុវ៌្វន្តិ, ");
INSERT INTO sankhm_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","ឥតិ កថិតេ សតិ លោកនិវហស្តយោះ ប្រាតិកូល្យេនោទតិឞ្ឋត៑ តថា ឝាសកាស្តយោ រ្វស្ត្រាណិ ឆិត្វា វេត្រាឃាតំ កត៌្តុម៑ អាជ្ញាបយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","អបរំ តេ តៅ ពហុ ប្រហាយ៌្យ ត្វមេតៅ ការាំ នីត្វា សាវធានំ រក្ឞយេតិ ការារក្ឞកម៑ អាទិឝន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ឥត្ថម៑ អាជ្ញាំ ប្រាប្យ ស តាវភ្យន្តរស្ថការាំ នីត្វា បាទេឞុ បាទបាឝីភិ រ្ពទ្ធ្វា ស្ថាបិតាវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","អថ និឝីថសមយេ បៅលសីលាវីឝ្វរមុទ្ទិឝ្យ ប្រាថនាំ គានញ្ច ក្ឫតវន្តៅ, ការាស្ថិតា លោកាឝ្ច តទឝ្ឫណ្វន្ ");
INSERT INTO sankhm_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","តទាកស្មាត៑ មហាន៑ ភូមិកម្បោៜភវត៑ តេន ភិត្តិមូលេន សហ ការា កម្បិតាភូត៑ តត្ក្ឞណាត៑ សវ៌្វាណិ ទ្វារាណិ មុក្តានិ ជាតានិ សវ៌្វេឞាំ ពន្ធនានិ ច មុក្តានិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","អតឯវ ការារក្ឞកោ និទ្រាតោ ជាគរិត្វា ការាយា ទ្វារាណិ មុក្តានិ ទ្ឫឞ្ដ្វា ពន្ទិលោកាះ បលាយិតា ឥត្យនុមាយ កោឞាត៑ ខង្គំ ពហិះ ក្ឫត្វាត្មឃាតំ កត៌្តុម៑ ឧទ្យតះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","កិន្តុ បៅលះ ប្រោច្ចៃស្តមាហូយ កថិតវាន៑ បឝ្យ វយំ សវ៌្វេៜត្រាស្មហេ, ត្វំ និជប្រាណហិំសាំ មាកាឞ៌ីះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","តទា ប្រទីបម៑ អានេតុម៑ ឧក្ត្វា ស កម្បមានះ សន៑ ឧល្លម្ប្យាភ្យន្តរម៑ អាគត្យ បៅលសីលយោះ បាទេឞុ បតិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","បឝ្ចាត៑ ស តៅ ពហិរានីយ ប្ឫឞ្ដវាន៑ ហេ មហេច្ឆៅ បរិត្រាណំ ប្រាប្តុំ មយា កិំ កត៌្តវ្យំ? ");
INSERT INTO sankhm_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","បឝ្ចាត៑ តៅ ស្វគ្ឫហមានីយ តយោះ សម្មុខេ ខាទ្យទ្រវ្យាណិ ស្ថាបិតវាន៑ តថា ស ស្វយំ តទីយាះ សវ៌្វេ បរិវារាឝ្ចេឝ្វរេ វិឝ្វសន្តះ សានន្ទិតា អភវន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","តស្មៃ តស្យ គ្ឫហស្ថិតសវ៌្វលោកេភ្យឝ្ច ប្រភោះ កថាំ កថិតវន្តៅ។ ");
INSERT INTO sankhm_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","តថា រាត្រេស្តស្មិន្នេវ ទណ្ឌេ ស តៅ គ្ឫហីត្វា តយោះ ប្រហារាណាំ ក្ឞតានិ ប្រក្ឞាលិតវាន៑ តតះ ស ស្វយំ តស្យ សវ៌្វេ បរិជនាឝ្ច មជ្ជិតា អភវន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","បឝ្ចាត៑ តៅ ស្វគ្ឫហមានីយ តយោះ សម្មុខេ ខាទ្យទ្រវ្យាណិ ស្ថាបិតវាន៑ តថា ស ស្វយំ តទីយាះ សវ៌្វេ បរិវារាឝ្ចេឝ្វរេ វិឝ្វសន្តះ សានន្ទិតា អភវន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","ទិន ឧបស្ថិតេ តៅ លោកៅ មោចយេតិ កថាំ កថយិតុំ ឝាសកាះ បទាតិគណំ ប្រេឞិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","តតះ ការារក្ឞកះ បៅលាយ តាំ វាត៌្តាំ កថិតវាន៑ យុវាំ ត្យាជយិតុំ ឝាសកា លោកាន ប្រេឞិតវន្ត ឥទានីំ យុវាំ ពហិ រ្ភូត្វា កុឝលេន ប្រតិឞ្ឋេតាំ។ ");
INSERT INTO sankhm_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","កិន្តុ បៅលស្តាន៑ អវទត៑ រោមិលោកយោរាវយោះ កមបិ ទោឞម៑ ន និឝ្ចិត្យ សវ៌្វេឞាំ សមក្ឞម៑ អាវាំ កឝយា តាឌយិត្វា ការាយាំ ពទ្ធវន្ត ឥទានីំ កិមាវាំ គុប្តំ វិស្ត្រក្ឞ្យន្តិ? តន្ន ភវិឞ្យតិ, ស្វយមាគត្យាវាំ ពហិះ ក្ឫត្វា នយន្តុ។ ");
INSERT INTO sankhm_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","តទា បទាតិភិះ ឝាសកេភ្យ ឯតទ្វាត៌្តាយាំ កថិតាយាំ តៅ រោមិលោកាវិតិ កថាំ ឝ្រុត្វា តេ ភីតាះ ");
INSERT INTO sankhm_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","សន្តស្តយោះ សន្និធិមាគត្យ វិនយម៑ អកុវ៌្វន៑ អបរំ ពហិះ ក្ឫត្វា នគរាត៑ ប្រស្ថាតុំ ប្រាត៌្ហិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","តតស្តៅ ការាយា និគ៌ត្យ លុទិយាយា គ្ឫហំ គតវន្តៅ តត្រ ភ្រាត្ឫគណំ សាក្ឞាត្ក្ឫត្យ តាន៑ សាន្ត្វយិត្វា តស្មាត៑ ស្ថានាត៑ ប្រស្ថិតៅ។ ");
INSERT INTO sankhm_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","បៅលសីលៅ អាម្ផិបល្យាបល្លោនិយានគរាភ្យាំ គត្វា យត្រ យិហូទីយានាំ ភជនភវនមេកម៑ អាស្តេ តត្រ ថិឞលនីកីនគរ ឧបស្ថិតៅ។ ");
INSERT INTO sankhm_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","តទា បៅលះ ស្វាចារានុសារេណ តេឞាំ សមីបំ គត្វា វិឝ្រាមវារត្រយេ តៃះ សាទ៌្ធំ ធម៌្មបុស្តកីយកថាយា វិចារំ ក្ឫតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ផលតះ ខ្រីឞ្ដេន ទុះខភោគះ កត៌្តវ្យះ ឝ្មឝានទុត្ថានញ្ច កត៌្តវ្យំ យុឞ្មាកំ សន្និធៅ យស្យ យីឝោះ ប្រស្តាវំ ករោមិ ស ឦឝ្វរេណាភិឞិក្តះ ស ឯតាះ កថាះ ប្រកាឝ្យ ប្រមាណំ ទត្វា ស្ថិរីក្ឫតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","តស្មាត៑ តេឞាំ កតិបយជនា អន្យទេឝីយា ពហវោ ភក្តលោកា ពហ្យះ ប្រធាននាយ៌្យឝ្ច វិឝ្វស្យ បៅលសីលយោះ បឝ្ចាទ្គាមិនោ ជាតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","កិន្តុ វិឝ្វាសហីនា យិហូទីយលោកា ឦឞ៌្យយា បរិបូណ៌ាះ សន្តោ ហដដ្ស្យ កតិនយលម្បដលោកាន៑ សង្គិនះ ក្ឫត្វា ជនតយា នគរមធ្យេ មហាកលហំ ក្ឫត្វា យាសោនោ គ្ឫហម៑ អាក្រម្យ ប្រេរិតាន៑ ធ្ឫត្វា លោកនិវហស្យ សមីបម៑ អានេតុំ ចេឞ្ដិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","តេឞាមុទ្ទេឝម៑ អប្រាប្យ ច យាសោនំ កតិបយាន៑ ភ្រាត្ឫំឝ្ច ធ្ឫត្វា នគរាធិបតីនាំ និកដមានីយ ប្រោច្ចៃះ កថិតវន្តោ យេ មនុឞ្យា ជគទុទ្វាដិតវន្តស្តេ ៜត្រាប្យុបស្ថិតាះ សន្តិ, ");
INSERT INTO sankhm_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ឯឞ យាសោន៑ អាតិថ្យំ ក្ឫត្វា តាន៑ គ្ឫហីតវាន៑។ យីឝុនាមក ឯកោ រាជស្តីតិ កថយន្តស្តេ កៃសរស្យាជ្ញាវិរុទ្ធំ កម៌្ម កុវ៌្វតិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","តេឞាំ កថាមិមាំ ឝ្រុត្វា លោកនិវហោ នគរាធិបតយឝ្ច សមុទ្វិគ្នា អភវន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","តទា យាសោនស្តទន្យេឞាញ្ច ធនទណ្ឌំ គ្ឫហីត្វា តាន៑ បរិត្យក្តវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","តតះ បរំ ភ្រាត្ឫគណោ រជន្យាំ បៅលសីលៅ ឝីឃ្រំ ពិរយានគរំ ប្រេឞិតវាន៑ តៅ តត្រោបស្ថាយ យិហូទីយានាំ ភជនភវនំ គតវន្តៅ។ ");
INSERT INTO sankhm_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","តត្រស្ថា លោកាះ ថិឞលនីកីស្ថលោកេភ្យោ មហាត្មាន អាសន៑ យត ឥត្ថំ ភវតិ ន វេតិ ជ្ញាតុំ ទិនេ ទិនេ ធម៌្មគ្រន្ថស្យាលោចនាំ ក្ឫត្វា ស្វៃរំ កថាម៑ អគ្ឫហ្លន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","តស្មាទ៑ អនេកេ យិហូទីយា អន្យទេឝីយានាំ មាន្យា ស្ត្រិយះ បុរុឞាឝ្ចានេកេ វ្យឝ្វសន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","កិន្តុ ពិរយានគរេ បៅលេនេឝ្វរីយា កថា ប្រចាយ៌្យត ឥតិ ថិឞលនីកីស្ថា យិហូទីយា ជ្ញាត្វា តត្ស្ថានមប្យាគត្យ លោកានាំ កុប្រវ្ឫត្តិម៑ អជនយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","អតឯវ តស្មាត៑ ស្ថានាត៑ សមុទ្រេណ យាន្តីតិ ទឝ៌យិត្វា ភ្រាតរះ ក្ឞិប្រំ បៅលំ ប្រាហិណ្វន៑ កិន្តុ សីលតីមថិយៅ តត្រ ស្ថិតវន្តៅ។ ");
INSERT INTO sankhm_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","តតះ បរំ បៅលស្យ មាគ៌ទឝ៌កាស្តម៑ អាថីនីនគរ ឧបស្ថាបយន៑ បឝ្ចាទ៑ យុវាំ តូណ៌ម៑ ឯតត៑ ស្ថានំ អាគមិឞ្យថះ សីលតីមថិយៅ ប្រតីមាម៑ អាជ្ញាំ ប្រាប្យ តេ ប្រត្យាគតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","បៅល អាថីនីនគរេ តាវបេក្ឞ្យ តិឞ្ឋន៑ តន្នគរំ ប្រតិមាភិះ បរិបូណ៌ំ ទ្ឫឞ្ដ្វា សន្តប្តហ្ឫទយោ ៜភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","តតះ ស ភជនភវនេ យាន៑ យិហូទីយាន៑ ភក្តលោកាំឝ្ច ហដ្ដេ ច យាន៑ អបឝ្យត៑ តៃះ សហ ប្រតិទិនំ វិចារិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","កិន្ត្វិបិកូរីយមតគ្រហិណះ ស្តោយិកីយមតគ្រាហិណឝ្ច កិយន្តោ ជនាស្តេន សាទ៌្ធំ វ្យវទន្ត។ តត្រ កេចិទ៑ អកថយន៑ ឯឞ វាចាលះ កិំ វក្តុម៑ ឥច្ឆតិ? អបរេ កេចិទ៑ ឯឞ ជនះ កេឞាញ្ចិទ៑ វិទេឝីយទេវានាំ ប្រចារក ឥត្យនុមីយតេ យតះ ស យីឝុម៑ ឧត្ថិតិញ្ច ប្រចារយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","តេ តម៑ អរេយបាគនាម វិចារស្ថានម៑ អានីយ ប្រាវោចន៑ ឥទំ យន្នវីនំ មតំ ត្វំ ប្រាចីកឝ ឥទំ កីទ្ឫឝំ ឯតទ៑ អស្មាន៑ ឝ្រាវយ; ");
INSERT INTO sankhm_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","យាមិមាម៑ អសម្ភវកថាម៑ អស្មាកំ កណ៌គោចរីក្ឫតវាន៑ អស្យា ភាវាត៌្ហះ ក ឥតិ វយំ ជ្ញាតុម៑ ឥច្ឆាមះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","តទាថីនីនិវាសិនស្តន្នគរប្រវាសិនឝ្ច កេវលំ កស្យាឝ្ចន នវីនកថាយាះ ឝ្រវណេន ប្រចារណេន ច កាលម៑ អយាបយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","បៅលោៜរេយបាគស្យ មធ្យេ តិឞ្ឋន៑ ឯតាំ កថាំ ប្រចារិតវាន៑, ហេ អាថីនីយលោកា យូយំ សវ៌្វថា ទេវបូជាយាម៑ អាសក្តា ឥត្យហ ប្រត្យក្ឞំ បឝ្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","យតះ បយ៌្យដនកាលេ យុឞ្មាកំ បូជនីយានិ បឝ្យន៑ ‘អវិជ្ញាតេឝ្វរាយ’ ឯតល្លិបិយុក្តាំ យជ្ញវេទីមេកាំ ទ្ឫឞ្ដវាន៑; អតោ ន វិទិត្វា យំ បូជយធ្វេ តស្យៃវ តត្វំ យុឞ្មាន៑ ប្រតិ ប្រចារយាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ជគតោ ជគត្ស្ថានាំ សវ៌្វវស្តូនាញ្ច ស្រឞ្ដា យ ឦឝ្វរះ ស ស្វគ៌ប្ឫថិវ្យោរេកាធិបតិះ សន៑ ករនិម៌្មិតមន្ទិរេឞុ ន និវសតិ; ");
INSERT INTO sankhm_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ស ឯវ សវ៌្វេភ្យោ ជីវនំ ប្រាណាន៑ សវ៌្វសាមគ្រីឝ្ច ប្រទទាតិ; អតឯវ ស កស្យាឝ្ចិត៑ សាមគ្យ្រា អភាវហេតោ រ្មនុឞ្យាណាំ ហស្តៃះ សេវិតោ ភវតីតិ ន។ ");
INSERT INTO sankhm_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ស ភូមណ្ឌលេ និវាសាត៌្ហម៑ ឯកស្មាត៑ ឝោណិតាត៑ សវ៌្វាន៑ មនុឞ្យាន៑ ស្ឫឞ្ដ្វា តេឞាំ បូវ៌្វនិរូបិតសមយំ វសតិសីមាញ្ច និរចិនោត៑; ");
INSERT INTO sankhm_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","តស្មាត៑ លោកៃះ កេនាបិ ប្រការេណ ម្ឫគយិត្វា បរមេឝ្វរស្យ តត្វំ ប្រាប្តុំ តស្យ គវេឞណំ ករណីយម៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","កិន្តុ សោៜស្មាកំ កស្មាច្ចិទបិ ទូរេ តិឞ្ឋតីតិ នហិ, វយំ តេន និឝ្វសនប្រឝ្វសនគមនាគមនប្រាណធារណានិ កុម៌្មះ, បុुនឝ្ច យុឞ្មាកមេវ កតិបយាះ កវយះ កថយន្តិ ‘តស្យ វំឝា វយំ ស្មោ ហិ’ ឥតិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","អតឯវ យទិ វយម៑ ឦឝ្វរស្យ វំឝា ភវាមស្តហ៌ិ មនុឞ្យៃ រ្វិទ្យយា កៅឝលេន ច តក្ឞិតំ ស្វណ៌ំ រូប្យំ ទ្ឫឞទ៑ វៃតេឞាមីឝ្វរត្វម៑ អស្មាភិ រ្ន ជ្ញាតវ្យំ។ ");
INSERT INTO sankhm_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","តេឞាំ បូវ៌្វីយលោកានាម៑ អជ្ញានតាំ ប្រតីឝ្វរោ យទ្យបិ នាវាធត្ត តថាបីទានីំ សវ៌្វត្រ សវ៌្វាន៑ មនះ បរិវត៌្តយិតុម៑ អាជ្ញាបយតិ, ");
INSERT INTO sankhm_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","យតះ ស្វនិយុក្តេន បុរុឞេណ យទា ស ប្ឫថិវីស្ថានាំ សវ៌្វលោកានាំ វិចារំ ករិឞ្យតិ តទ្ទិនំ ន្យរូបយត៑; តស្យ ឝ្មឝានោត្ថាបនេន តស្មិន៑ សវ៌្វេភ្យះ ប្រមាណំ ប្រាទាត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","តទា ឝ្មឝានាទ៑ ឧត្ថានស្យ កថាំ ឝ្រុត្វា កេចិទ៑ ឧបាហមន៑, កេចិទវទន៑ ឯនាំ កថាំ បុនរបិ ត្វត្តះ ឝ្រោឞ្យាមះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","តតះ បៅលស្តេឞាំ សមីបាត៑ ប្រស្ថិाតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","តថាបិ កេចិល្លោកាស្តេន សាទ៌្ធំ មិលិត្វា វ្យឝ្វសន៑ តេឞាំ មធ្យេ ៜរេយបាគីយទិយនុសិយោ ទាមារីនាមា កាចិន្នារី កិយន្តោ នរាឝ្ចាសន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","តទ្ឃដនាតះ បរំ បៅល អាថីនីនគរាទ៑ យាត្រាំ ក្ឫត្វា ករិន្ថនគរម៑ អាគច្ឆត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","តស្មិន៑ សមយេ ក្លៅទិយះ សវ៌្វាន៑ យិហូទីយាន៑ រោមានគរំ វិហាយ គន្តុម៑ អាជ្ញាបយត៑, តស្មាត៑ ប្រិស្កិល្លានាម្នា ជាយយា សាទ៌្ធម៑ ឥតាលិយាទេឝាត៑ កិញ្ចិត្បូវ៌្វម៑ អាគមត៑ យះ បន្តទេឝេ ជាត អាក្កិលនាមា យិហូទីយលោកះ បៅលស្តំ សាក្ឞាត៑ ប្រាប្យ តយោះ សមីបមិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","តៅ ទូឞ្យនិម៌្មាណជីវិនៅ, តស្មាត៑ បរស្បរម៑ ឯកវ្ឫត្តិកត្វាត៑ ស តាភ្យាំ សហ ឧឞិត្វា តត៑ កម៌្មាករោត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","បៅលះ ប្រតិវិឝ្រាមវារំ ភជនភវនំ គត្វា វិចារំ ក្ឫត្វា យិហូទីយាន៑ អន្យទេឝីយាំឝ្ច ប្រវ្ឫត្តិំ គ្រាហិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","សីលតីមថិយយោ រ្មាកិទនិយាទេឝាត៑ សមេតយោះ សតោះ បៅល ឧត្តប្តមនា ភូត្វា យីឝុរីឝ្វរេណាភិឞិក្តោ ភវតីតិ ប្រមាណំ យិហូទីយានាំ សមីបេ ប្រាទាត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","កិន្តុ តេ ៜតីវ វិរោធំ វិធាយ បាឞណ្ឌីយកថាំ កថិតវន្តស្តតះ បៅលោ វស្ត្រំ ធុន្វន៑ ឯតាំ កថាំ កថិតវាន៑, យុឞ្មាកំ ឝោណិតបាតាបរាធោ យុឞ្មាន៑ ប្រត្យេវ ភវតុ, តេនាហំ និរបរាធោ ៜទ្យារភ្យ ភិន្នទេឝីយានាំ សមីបំ យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","ស តស្មាត៑ ប្រស្ថាយ ភជនភវនសមីបស្ថស្យ យុស្តនាម្ន ឦឝ្វរភក្តស្យ ភិន្នទេឝីយស្យ និវេឝនំ ប្រាវិឝត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","តតះ ក្រីឞ្បនាមា ភជនភវនាធិបតិះ សបរិវារះ ប្រភៅ វ្យឝ្វសីត៑, ករិន្ថនគរីយា ពហវោ លោកាឝ្ច សមាកណ៌្យ វិឝ្វស្យ មជ្ជិតា អភវន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","ក្ឞណទាយាំ ប្រភុះ បៅលំ ទឝ៌នំ ទត្វា ភាឞិតវាន៑, មា ភៃឞីះ, មា និរសីះ កថាំ ប្រចារយ។ ");
INSERT INTO sankhm_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","អហំ ត្វយា សាទ៌្ធម៑ អាស ហិំសាត៌្ហំ កោបិ ត្វាំ ស្ប្រឞ្ដុំ ន ឝក្ឞ្យតិ នគរេៜស្មិន៑ មទីយា លោកា ពហវ អាសតេ។ ");
INSERT INTO sankhm_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","តស្មាត៑ បៅលស្តន្នគរេ ប្រាយេណ សាទ៌្ធវត្សរបយ៌្យន្តំ សំស្ថាយេឝ្វរស្យ កថាម៑ ឧបាទិឝត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","គាល្លិយនាមា កឝ្ចិទ៑ អាខាយាទេឝស្យ ប្រាឌ្វិវាកះ សមភវត៑, តតោ យិហូទីយា ឯកវាក្យាះ សន្តះ បៅលម៑ អាក្រម្យ វិចារស្ថានំ នីត្វា ");
INSERT INTO sankhm_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","មានុឞ ឯឞ វ្យវស្ថាយ វិរុទ្ធម៑ ឦឝ្វរភជនំ កត៌្តុំ លោកាន៑ កុប្រវ្ឫត្តិំ គ្រាហយតីតិ និវេទិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","តតះ បៅលេ ប្រត្យុត្តរំ ទាតុម៑ ឧទ្យតេ សតិ គាល្លិយា យិហូទីយាន៑ វ្យាហរត៑, យទិ កស្យចិទ៑ អន្យាយស្យ វាតិឝយទុឞ្ដតាចរណស្យ វិចារោៜភវិឞ្យត៑ តហ៌ិ យុឞ្មាកំ កថា មយា សហនីយាភវិឞ្យត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","កិន្តុ យទិ កេវលំ កថាយា វា នាម្នោ វា យុឞ្មាកំ វ្យវស្ថាយា វិវាទោ ភវតិ តហ៌ិ តស្យ វិចារមហំ ន ករិឞ្យាមិ, យូយំ តស្យ មីមាំសាំ កុរុត។ ");
INSERT INTO sankhm_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","តតះ ស តាន៑ វិចារស្ថានាទ៑ ទូរីក្ឫតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","តទា ភិន្នទេឝីយាះ សោស្ថិនិនាមានំ ភជនភវនស្យ ប្រធានាធិបតិំ ធ្ឫត្វា វិចារស្ថានស្យ សម្មុខេ ប្រាហរន៑ តថាបិ គាល្លិយា តេឞុ សវ៌្វកម៌្មសុ ន មនោ ន្យទធាត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","បៅលស្តត្រ បុនព៌ហុទិនានិ ន្យវសត៑, តតោ ភ្រាត្ឫគណាទ៑ វិសជ៌នំ ប្រាប្យ កិញ្ចនវ្រតនិមិត្តំ កិំក្រិយានគរេ ឝិរោ មុណ្ឌយិត្វា ប្រិស្កិល្លាក្កិលាភ្យាំ សហិតោ ជលបថេន សុរិយាទេឝំ គតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","តត ឥផិឞនគរ ឧបស្ថាយ តត្រ តៅ វិស្ឫជ្យ ស្វយំ ភជនភ្វនំ ប្រវិឝ្យ យិហូទីយៃះ សហ វិចារិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","តេ ស្វៃះ សាទ៌្ធំ បុនះ កតិបយទិនានិ ស្ថាតុំ តំ វ្យនយន៑, ស តទនុររីក្ឫត្យ កថាមេតាំ កថិតវាន៑, ");
INSERT INTO sankhm_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","យិរូឝាលមិ អាគាម្យុត្សវបាលនាត៌្ហំ មយា គមនីយំ; បឝ្ចាទ៑ ឦឝ្វរេច្ឆាយាំ ជាតាយាំ យុឞ្មាកំ សមីបំ ប្រត្យាគមិឞ្យាមិ។ តតះ បរំ ស តៃ រ្វិស្ឫឞ្ដះ សន៑ ជលបថេន ឥផិឞនគរាត៑ ប្រស្ថិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","តតះ កៃសរិយាម៑ ឧបស្ថិតះ សន៑ នគរំ គត្វា សមាជំ នមស្ក្ឫត្យ តស្មាទ៑ អាន្តិយខិយានគរំ ប្រស្ថិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","តត្រ កិយត្កាលំ យាបយិត្វា តស្មាត៑ ប្រស្ថាយ សវ៌្វេឞាំ ឝិឞ្យាណាំ មនាំសិ សុស្ថិរាណិ ក្ឫត្វា ក្រមឝោ គលាតិយាផ្រុគិយាទេឝយោ រ្ភ្រមិត្វា គតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","តស្មិន្នេវ សមយេ សិកន្ទរិយានគរេ ជាត អាបល្លោនាមា ឝាស្ត្រវិត៑ សុវក្តា យិហូទីយ ឯកោ ជន ឥផិឞនគរម៑ អាគតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","ស ឝិក្ឞិតប្រភុមាគ៌ោ មនសោទ្យោគី ច សន៑ យោហនោ មជ្ជនមាត្រំ ជ្ញាត្វា យថាត៌្ហតយា ប្រភោះ កថាំ កថយន៑ សមុបាទិឝត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ឯឞ ជនោ និព៌្ហយត្វេន ភជនភវនេ កថយិតុម៑ អារព្ធវាន៑, តតះ ប្រិស្កិល្លាក្កិលៅ តស្យោបទេឝកថាំ និឝម្យ តំ ស្វយោះ សមីបម៑ អានីយ ឝុទ្ធរូបេណេឝ្វរស្យ កថាម៑ អពោធយតាម៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","បឝ្ចាត៑ ស អាខាយាទេឝំ គន្តុំ មតិំ ក្ឫតវាន៑, តទា តត្រត្យះ ឝិឞ្យគណោ យថា តំ គ្ឫហ្លាតិ តទត៌្ហំ ភ្រាត្ឫគណេន សមាឝ្វស្យ បត្រេ លិខិតេ សតិ, អាបល្លាស្តត្រោបស្ថិតះ សន៑ អនុគ្រហេណ ប្រត្យយិនាំ ពហូបការាន៑ អករោត៑, ");
INSERT INTO sankhm_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ផលតោ យីឝុរភិឞិក្តស្ត្រាតេតិ ឝាស្ត្រប្រមាណំ ទត្វា ប្រកាឝរូបេណ ប្រតិបន្នំ ក្ឫត្វា យិហូទីយាន៑ និរុត្តរាន៑ ក្ឫតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","ករិន្ថនគរ អាបល្លសះ ស្ថិតិកាលេ បៅល ឧត្តរប្រទេឝៃរាគច្ឆន៑ ឥផិឞនគរម៑ ឧបស្ថិតវាន៑។ តត្រ កតិបយឝិឞ្យាន៑ សាក្ឞត៑ ប្រាប្យ តាន៑ អប្ឫច្ឆត៑, ");
INSERT INTO sankhm_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","យូយំ វិឝ្វស្យ បវិត្រមាត្មានំ ប្រាប្តា ន វា? តតស្តេ ប្រត្យវទន៑ បវិត្រ អាត្មា ទីយតេ ឥត្យស្មាភិះ ឝ្រុតមបិ នហិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","តទា សាៜវទត៑ តហ៌ិ យូយំ កេន មជ្ជិតា អភវត? តេៜកថយន៑ យោហនោ មជ្ជនេន។ ");
INSERT INTO sankhm_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","តទា បៅល ឧក្តវាន៑ ឥតះ បរំ យ ឧបស្ថាស្យតិ តស្មិន៑ អត៌្ហត យីឝុខ្រីឞ្ដេ វិឝ្វសិតវ្យមិត្យុក្ត្វា យោហន៑ មនះបរិវត៌្តនសូចកេន មជ្ជនេន ជលេ លោកាន៑ អមជ្ជយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","តាទ្ឫឝីំ កថាំ ឝ្រុត្វា តេ ប្រភោ រ្យីឝុខ្រីឞ្ដស្យ នាម្នា មជ្ជិតា អភវន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","តតះ បៅលេន តេឞាំ គាត្រេឞុ ករេៜរ្បិតេ តេឞាមុបរិ បវិត្រ អាត្មាវរូឍវាន៑, តស្មាត៑ តេ នានាទេឝីយា ភាឞា ភវិឞ្យត្កថាឝ្ច កថិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","តេ ប្រាយេណ ទ្វាទឝជនា អាសន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","បៅលោ ភជនភវនំ គត្វា ប្រាយេណ មាសត្រយម៑ ឦឝ្វរស្យ រាជ្យស្យ វិចារំ ក្ឫត្វា លោកាន៑ ប្រវត៌្យ សាហសេន កថាមកថយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","កិន្តុ កឋិនាន្តះករណត្វាត៑ កិយន្តោ ជនា ន វិឝ្វស្យ សវ៌្វេឞាំ សមក្ឞម៑ ឯតត្បថស្យ និន្ទាំ កត៌្តុំ ប្រវ្ឫត្តាះ, អតះ បៅលស្តេឞាំ សមីបាត៑ ប្រស្ថាយ ឝិឞ្យគណំ ប្ឫថក្ក្ឫត្វា ប្រត្យហំ តុរាន្ននាម្នះ កស្យចិត៑ ជនស្យ បាឋឝាលាយាំ វិចារំ ក្ឫតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ឥត្ថំ វត្សរទ្វយំ គតំ តស្មាទ៑ អាឝិយាទេឝនិវាសិនះ សវ៌្វេ យិហូទីយា អន្យទេឝីយលោកាឝ្ច ប្រភោ រ្យីឝោះ កថាម៑ អឝ្រៅឞន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","បៅលេន ច ឦឝ្វរ ឯតាទ្ឫឝាន្យទ្ភុតានិ កម៌្មាណិ ក្ឫតវាន្ ");
INSERT INTO sankhm_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","យត៑ បរិធេយេ គាត្រមាជ៌នវស្ត្រេ វា តស្យ ទេហាត៑ បីឌិតលោកានាម៑ សមីបម៑ អានីតេ តេ និរាមយា ជាតា អបវិត្រា ភូតាឝ្ច តេភ្យោ ពហិគ៌តវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","តទា ទេឝាដនការិណះ កិយន្តោ យិហូទីយា ភូតាបសារិណោ ភូតគ្រស្តនោកានាំ សន្និធៅ ប្រភេ រ្យីឝោ រ្នាម ជប្ត្វា វាក្យមិទម៑ អវទន៑, យស្យ កថាំ បៅលះ ប្រចារយតិ តស្យ យីឝោ រ្នាម្នា យុឞ្មាន៑ អាជ្ញាបយាមះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","ស្កិវនាម្នោ យិហូទីយានាំ ប្រធានយាជកស្យ សប្តភិះ បុត្តៃស្តថា ក្ឫតេ សតិ ");
INSERT INTO sankhm_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","កឝ្ចិទ៑ អបវិត្រោ ភូតះ ប្រត្យុទិតវាន៑, យីឝុំ ជានាមិ បៅលញ្ច បរិចិនោមិ កិន្តុ កេ យូយំ? ");
INSERT INTO sankhm_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ឥត្យុក្ត្វា សោបវិត្រភូតគ្រស្តោ មនុឞ្យោ លម្ផំ ក្ឫត្វា តេឞាមុបរិ បតិត្វា ពលេន តាន៑ ជិតវាន៑, តស្មាត្តេ នគ្នាះ ក្ឞតាង្គាឝ្ច សន្តស្តស្មាទ៑ គេហាត៑ បលាយន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","សា វាគ៑ ឥផិឞនគរនិវាសិនសំ សវ៌្វេឞាំ យិហូទីយានាំ ភិន្នទេឝីយានាំ លោកានាញ្ច ឝ្រវោគោចរីភូតា; តតះ សវ៌្វេ ភយំ គតាះ ប្រភោ រ្យីឝោ រ្នាម្នោ យឝោ ៜវទ៌្ធត។ ");
INSERT INTO sankhm_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","យេឞាមនេកេឞាំ លោកានាំ ប្រតីតិរជាយត ត អាគត្យ ស្វៃះ ក្ឫតាះ ក្រិយាះ ប្រកាឝរូបេណាង្គីក្ឫតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","ពហវោ មាយាកម៌្មការិណះ ស្វស្វគ្រន្ថាន៑ អានីយ រាឝីក្ឫត្យ សវ៌្វេឞាំ សមក្ឞម៑ អទាហយន៑, តតោ គណនាំ ក្ឫត្វាពុធ្យន្ត បញ្ចាយុតរូប្យមុទ្រាមូល្យបុស្តកានិ ទគ្ធានិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ឥត្ថំ ប្រភោះ កថា សវ៌្វទេឝំ វ្យាប្យ ប្រពលា ជាតា។ ");
INSERT INTO sankhm_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","សវ៌្វេឞ្វេតេឞុ កម៌្មសុ សម្បន្នេឞុ សត្សុ បៅលោ មាកិទនិយាខាយាទេឝាភ្យាំ យិរូឝាលមំ គន្តុំ មតិំ ក្ឫត្វា កថិតវាន៑ តត្ស្ថានំ យាត្រាយាំ ក្ឫតាយាំ សត្យាំ មយា រោមានគរំ ទ្រឞ្ដវ្យំ។ ");
INSERT INTO sankhm_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","ស្វានុគតលោកានាំ តីមថិយេរាស្តៅ ទ្វៅ ជនៅ មាកិទនិយាទេឝំ ប្រតិ ប្រហិត្យ ស្វយម៑ អាឝិយាទេឝេ កតិបយទិនានិ ស្ថិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","កិន្តុ តស្មិន៑ សមយេ មតេៜស្មិន៑ កលហោ ជាតះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","តត្ការណមិទំ, អត៌្តិមីទេវ្យា រូប្យមន្ទិរនិម៌្មាណេន សវ៌្វេឞាំ ឝិល្បិនាំ យថេឞ្ដលាភម៑ អជនយត៑ យោ ទីមីត្រិយនាមា នាឌីន្ធមះ ");
INSERT INTO sankhm_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ស តាន៑ តត្កម៌្មជីវិនះ សវ៌្វលោកាំឝ្ច សមាហូយ ភាឞិតវាន៑ ហេ មហេច្ឆា ឯតេន មន្ទិរនិម៌្មាណេនាស្មាកំ ជីវិកា ភវតិ, ឯតទ៑ យូយំ វិត្ថ; ");
INSERT INTO sankhm_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","កិន្តុ ហស្តនិម៌្មិតេឝ្វរា ឦឝ្វរា នហិ បៅលនាម្នា កេនចិជ្ជនេន កថាមិមាំ វ្យាហ្ឫត្យ កេវលេផិឞនគរេ នហិ ប្រាយេណ សវ៌្វស្មិន៑ អាឝិយាទេឝេ ប្រវ្ឫត្តិំ គ្រាហយិត្វា ពហុលោកានាំ ឝេមុឞី បរាវត៌្តិតា, ឯតទ៑ យុឞ្មាភិ រ្ទ្ឫឝ្យតេ ឝ្រូយតេ ច។ ");
INSERT INTO sankhm_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","តេនាស្មាកំ វាណិជ្យស្យ សវ៌្វថា ហានេះ សម្ភវនំ កេវលមិតិ នហិ, អាឝិយាទេឝស្ថៃ រ្វា សវ៌្វជគត្ស្ថៃ រ្លោកៃះ បូជ្យា យាត៌ិមី មហាទេវី តស្យា មន្ទិរស្យាវជ្ញានស្យ តស្យា ឰឝ្វយ៌្យស្យ នាឝស្យ ច សម្ភាវនា វិទ្យតេे។ ");
INSERT INTO sankhm_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","ឯតាទ្ឫឝីំ កថាំ ឝ្រុត្វា តេ មហាក្រោធាន្វិតាះ សន្ត ឧច្ចៃះការំ កថិតវន្ត ឥផិឞីយានាម៑ អត៌្តិមី ទេវី មហតី ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","តតះ សវ៌្វនគរំ កលហេន បរិបូណ៌មភវត៑, តតះ បរំ តេ មាកិទនីយគាយារិស្តាក៌្ហនាមានៅ បៅលស្យ ទ្វៅ សហចរៅ ធ្ឫត្វៃកចិត្តា រង្គភូមិំ ជវេន ធាវិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","តតះ បៅលោ លោកានាំ សន្និធិំ យាតុម៑ ឧទ្យតវាន៑ កិន្តុ ឝិឞ្យគណស្តំ វារិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","បៅលស្យត្មីយា អាឝិយាទេឝស្ថាះ កតិបយាះ ប្រធានលោកាស្តស្យ សមីបំ នរមេកំ ប្រេឞ្យ ត្វំ រង្គភូមិំ មាគា ឥតិ ន្យវេទយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","តតោ នានាលោកានាំ នានាកថាកថនាត៑ សភា វ្យាកុលា ជាតា កិំ ការណាទ៑ ឯតាវតី ជនតាភវត៑ ឯតទ៑ អធិកៃ រ្លោកៃ រ្នាជ្ញាយិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","តតះ បរំ ជនតាមធ្យាទ៑ យិហូទីយៃព៌ហិឞ្ក្ឫតះ សិកន្ទរោ ហស្តេន សង្កេតំ ក្ឫត្វា លោកេភ្យ ឧត្តរំ ទាតុមុទ្យតវាន៑, ");
INSERT INTO sankhm_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","កិន្តុ ស យិហូទីយលោក ឥតិ និឝ្ចិតេ សតិ ឥផិឞីយានាម៑ អត៌្តិមី ទេវី មហតីតិ វាក្យំ ប្រាយេណ បញ្ច ទណ្ឌាន៑ យាវទ៑ ឯកស្វរេណ លោកនិវហៃះ ប្រោក្តំ។ ");
INSERT INTO sankhm_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","តតោ នគរាធិបតិស្តាន៑ ស្ថិរាន៑ ក្ឫត្វា កថិតវាន៑ ហេ ឥផិឞាយាះ សវ៌្វេ លោកា អាកណ៌យត, អត៌ិមីមហាទេវ្យា មហាទេវាត៑ បតិតាយាស្តត្ប្រតិមាយាឝ្ច បូជនម ឥផិឞនគរស្ថាះ សវ៌្វេ លោកាះ កុវ៌្វន្តិ, ឯតត៑ កេ ន ជានន្តិ? ");
INSERT INTO sankhm_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","តស្មាទ៑ ឯតត្ប្រតិកូលំ កេបិ កថយិតុំ ន ឝក្នុវន្តិ, ឥតិ ជ្ញាត្វា យុឞ្មាភិះ សុស្ថិរត្វេន ស្ថាតវ្យម៑ អវិវិច្យ កិមបិ កម៌្ម ន កត៌្តវ្យញ្ច។ ");
INSERT INTO sankhm_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","យាន៑ ឯតាន៑ មនុឞ្យាន៑ យូយមត្រ សមានយត តេ មន្ទិរទ្រវ្យាបហារកា យុឞ្មាកំ ទេវ្យា និន្ទកាឝ្ច ន ភវន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","យទិ កញ្ចន ប្រតិ ទីមីត្រិយស្យ តស្យ សហាយានាញ្ច កាចិទ៑ អាបត្តិ រ្វិទ្យតេ តហ៌ិ ប្រតិនិធិលោកា វិចារស្ថានញ្ច សន្តិ, តេ តត៑ ស្ថានំ គត្វា ឧត្តរប្រត្យុត្តរេ កុវ៌្វន្តុ។ ");
INSERT INTO sankhm_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","កិន្តុ យុឞ្មាកំ កាចិទបរា កថា យទិ តិឞ្ឋតិ តហ៌ិ និយមិតាយាំ សភាយាំ តស្យា និឞ្បត្តិ រ្ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","កិន្ត្វេតស្យ វិរោធស្យោត្តរំ យេន ទាតុំ ឝក្នុម៑ ឯតាទ្ឫឝស្យ កស្យចិត៑ ការណស្យាភាវាទ៑ អទ្យតនឃដនាហេតោ រាជទ្រោហិណាមិវាស្មាកម៑ អភិយោគោ ភវិឞ្យតីតិ ឝង្កា វិទ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","ឥតិ កថយិត្វា ស សភាស្ថលោកាន៑ វិស្ឫឞ្ដវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ឥត្ថំ កលហេ និវ្ឫត្តេ សតិ បៅលះ ឝិឞ្យគណម៑ អាហូយ វិសជ៌នំ ប្រាប្យ មាកិទនិយាទេឝំ ប្រស្ថិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","តេន ស្ថានេន គច្ឆន៑ តទ្ទេឝីយាន៑ ឝិឞ្យាន៑ ពហូបទិឝ្យ យូនានីយទេឝម៑ ឧបស្ថិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","តត្រ មាសត្រយំ ស្ថិត្វា តស្មាត៑ សុរិយាទេឝំ យាតុម៑ ឧទ្យតះ, កិន្តុ យិហូទីយាស្តំ ហន្តុំ គុប្តា អតិឞ្ឋន៑ តស្មាត៑ ស បុនរបិ មាកិទនិយាមាគ៌េណ ប្រត្យាគន្តុំ មតិំ ក្ឫតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","ពិរយានគរីយសោបាត្រះ ថិឞលនីកីយារិស្តាក៌្ហសិកុន្ទៅ ទព៌្ពោនគរីយគាយតីមថិយៅ អាឝិយាទេឝីយតុខិកត្រផិមៅ ច តេន សាទ៌្ធំ អាឝិយាទេឝំ យាវទ៑ គតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ឯតេ សវ៌្វេ ៜគ្រសរាះ សន្តោ ៜស្មាន៑ អបេក្ឞ្យ ត្រោយានគរេ ស្ថិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","កិណ្វឝូន្យបូបោត្សវទិនេ ច គតេ សតិ វយំ ផិលិបីនគរាត៑ តោយបថេន គត្វា បញ្ចភិ រ្ទិនៃស្ត្រោយានគរម៑ ឧបស្ថាយ តត្រ សប្តទិនាន្យវាតិឞ្ឋាម។ ");
INSERT INTO sankhm_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","សប្តាហស្យ ប្រថមទិនេ បូបាន៑ ភំក្តុ ឝិឞ្យេឞុ មិលិតេឞុ បៅលះ បរទិនេ តស្មាត៑ ប្រស្ថាតុម៑ ឧទ្យតះ សន៑ តទហ្និ ប្រាយេណ ក្ឞបាយា យាមទ្វយំ យាវត៑ ឝិឞ្យេភ្យោ ធម៌្មកថាម៑ អកថយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ឧបរិស្ថេ យស្មិន៑ ប្រកោឞ្ឋេ សភាំ ក្ឫត្វាសន៑ តត្រ ពហវះ ប្រទីបាះ ប្រាជ្វលន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ឧតុខនាមា កឝ្ចន យុវា ច វាតាយន ឧបវិឝន៑ ឃោរតរនិទ្រាគ្រស្តោ ៜភូត៑ តទា បៅលេន ពហុក្ឞណំ កថាយាំ ប្រចារិតាយាំ និទ្រាមគ្នះ ស តស្មាទ៑ ឧបរិស្ថត្ឫតីយប្រកោឞ្ឋាទ៑ អបតត៑, តតោ លោកាស្តំ ម្ឫតកល្បំ ធ្ឫត្វោទតោលយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","តតះ បៅលោៜវរុហ្យ តស្យ គាត្រេ បតិត្វា តំ ក្រោឌេ និធាយ កថិតវាន៑, យូយំ វ្យាកុលា មា ភូត នាយំ ប្រាណៃ រ្វិយុក្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","បឝ្ចាត៑ ស បុនឝ្ចោបរិ គត្វា បូបាន៑ ភំក្ត្វា ប្រភាតំ យាវត៑ កថោបកថនេ ក្ឫត្វា ប្រស្ថិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","តេ ច តំ ជីវន្តំ យុវានំ គ្ឫហីត្វា គត្វា បរមាប្យាយិតា ជាតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","អនន្តរំ វយំ បោតេនាគ្រសរា ភូត្វាស្មនគរម៑ ឧត្តីយ៌្យ បៅលំ គ្រហីតុំ មតិម៑ អកុម៌្ម យតះ ស តត្រ បទ្ភ្យាំ វ្រជិតុំ មតិំ ក្ឫត្វេតិ និរូបិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","តស្មាត៑ តត្រាស្មាភិះ សាទ៌្ធំ តស្មិន៑ មិលិតេ សតិ វយំ តំ នីត្វា មិតុលីន្យុបទ្វីបំ ប្រាប្តវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","តស្មាត៑ បោតំ មោចយិត្វា បរេៜហនិ ខីយោបទ្វីបស្យ សម្មុខំ លព្ធវន្តស្តស្មាទ៑ ឯកេនាហ្នា សាមោបទ្វីបំ គត្វា បោតំ លាគយិត្វា ត្រោគុល្លិយេ ស្ថិត្វា បរស្មិន៑ ទិវសេे មិលីតនគរម៑ ឧបាតិឞ្ឋាម។ ");
INSERT INTO sankhm_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","យតះ បៅល អាឝិយាទេឝេ កាលំ យាបយិតុម៑ នាភិលឞន៑ ឥផិឞនគរំ ត្យក្ត្វា យាតុំ មន្ត្រណាំ ស្ថិរីក្ឫតវាន៑; យស្មាទ៑ យទិ សាធ្យំ ភវតិ តហ៌ិ និស្តារោត្សវស្យ បញ្ចាឝត្តមទិនេ ស យិរូឝាលម្យុបស្ថាតុំ មតិំ ក្ឫតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","បៅលោ មិលីតាទ៑ ឥផិឞំ ប្រតិ លោកំ ប្រហិត្យ សមាជស្យ ប្រាចីនាន៑ អាហូយានីតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","តេឞុ តស្យ សមីបម៑ ឧបស្ថិតេឞុ ស តេភ្យ ឥមាំ កថាំ កថិតវាន៑, អហម៑ អាឝិយាទេឝេ ប្រថមាគមនម៑ អារភ្យាទ្យ យាវទ៑ យុឞ្មាកំ សន្និធៅ ស្ថិត្វា សវ៌្វសមយេ យថាចរិតវាន៑ តទ៑ យូយំ ជានីថ; ");
INSERT INTO sankhm_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ផលតះ សវ៌្វថា នម្រមនាះ សន៑ ពហុឝ្រុបាតេន យិហុទីយានាម៑ កុមន្ត្រណាជាតនានាបរីក្ឞាភិះ ប្រភោះ សេវាមករវំ។ ");
INSERT INTO sankhm_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","កាមបិ ហិតកថាाំ ន គោបាយិតវាន៑ តាំ ប្រចាយ៌្យ សប្រកាឝំ គ្ឫហេ គ្ឫហេ សមុបទិឝ្យេឝ្វរំ ប្រតិ មនះ បរាវត៌្តនីយំ ប្រភៅ យីឝុខ្រីឞ្ដេ វិឝ្វសនីយំ ");
INSERT INTO sankhm_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","យិហូទីយានាម៑ អន្យទេឝីយលោកានាញ្ច សមីប ឯតាទ្ឫឝំ សាក្ឞ្យំ ទទាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","បឝ្យត សាម្ប្រតម៑ អាត្មនាក្ឫឞ្ដះ សន៑ យិរូឝាលម្នគរេ យាត្រាំ ករោមិ, តត្រ មាម្ប្រតិ យទ្យទ៑ ឃដិឞ្យតេ តាន្យហំ ន ជានាមិ; ");
INSERT INTO sankhm_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","កិន្តុ មយា ពន្ធនំ ក្លេឝឝ្ច ភោក្តវ្យ ឥតិ បវិត្រ អាត្មា នគរេ នគរេ ប្រមាណំ ទទាតិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","តថាបិ តំ ក្លេឝមហំ ត្ឫណាយ ន មន្យេ; ឦឝ្វរស្យានុគ្រហវិឞយកស្យ សុសំវាទស្យ ប្រមាណំ ទាតុំ, ប្រភោ រ្យីឝោះ សកាឝាទ យស្យាះ សេវាយាះ ភារំ ប្រាប្នវំ តាំ សេវាំ សាធយិតុំ សានន្ទំ ស្វមាគ៌ំ សមាបយិតុुញ្ច និជប្រាណានបិ ប្រិយាន៑ ន មន្យេ។ ");
INSERT INTO sankhm_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","អធុនា បឝ្យត យេឞាំ សមីបេៜហម៑ ឦឝ្វរីយរាជ្យស្យ សុសំវាទំ ប្រចាយ៌្យ ភ្រមណំ ក្ឫតវាន៑ ឯតាទ្ឫឝា យូយំ មម វទនំ បុន រ្ទ្រឞ្ដុំ ន ប្រាប្ស្យថ ឯតទប្យហំ ជានាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","យុឞ្មភ្យម៑ អហម៑ ឦឝ្វរស្យ សវ៌្វាន៑ អាទេឝាន៑ ប្រកាឝយិតុំ ន ន្យវត៌្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","អហំ សវ៌្វេឞាំ លោកានាំ រក្តបាតទោឞាទ៑ យន្និទ៌ោឞ អាសេ តស្យាទ្យ យុឞ្មាន៑ សាក្ឞិណះ ករោមិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","យូយំ ស្វេឞុ តថា យស្យ វ្រជស្យាធ្យក្ឞន៑ អាត្មា យុឞ្មាន៑ វិធាយ ន្យយុង្ក្ត តត្សវ៌្វស្មិន៑ សាវធានា ភវត, យ សមាជញ្ច ប្រភុ រ្និជរក្តមូល្យេន ក្រីតវាន តម៑ អវត, ");
INSERT INTO sankhm_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","យតោ មយា គមនេ ក្ឫតឯវ ទុជ៌យា វ្ឫកា យុឞ្មាកំ មធ្យំ ប្រវិឝ្យ វ្រជំ ប្រតិ និទ៌យតាម៑ អាចរិឞ្យន្តិ, ");
INSERT INTO sankhm_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","យុឞ្មាកមេវ មធ្យាទបិ លោកា ឧត្ថាយ ឝិឞ្យគណម៑ អបហន្តុំ វិបរីតម៑ ឧបទេក្ឞ្យន្តីត្យហំ ជានាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","ឥតិ ហេតោ រ្យូយំ សចៃតន្យាះ សន្តស្តិឞ្ដត, អហញ្ច សាឝ្រុបាតះ សន៑ វត្សរត្រយំ យាវទ៑ ទិវានិឝំ ប្រតិជនំ ពោធយិតុំ ន ន្យវត៌្តេ តទបិ ស្មរត។ ");
INSERT INTO sankhm_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","ឥទានីំ ហេ ភ្រាតរោ យុឞ្មាកំ និឞ្ឋាំ ជនយិតុំ បវិត្រីក្ឫតលោកានាំ មធ្យេៜធិការញ្ច ទាតុំ សមត៌្ហោ យ ឦឝ្វរស្តស្យានុគ្រហស្យ យោ វាទឝ្ច តយោរុភយោ រ្យុឞ្មាន៑ សមាប៌យម៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","កស្យាបិ ស្វណ៌ំ រូប្យំ វស្ត្រំ វា ប្រតិ មយា លោភោ ន ក្ឫតះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","កិន្តុ មម មត្សហចរលោកានាញ្ចាវឝ្យកវ្យយាយ មទីយមិទំ ករទ្វយម៑ អឝ្រាម្យទ៑ ឯតទ៑ យូយំ ជានីថ។ ");
INSERT INTO sankhm_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","អនេន ប្រការេណ គ្រហណទ៑ ទានំ ភទ្រមិតិ យទ្វាក្យំ ប្រភុ រ្យីឝុះ កថិតវាន៑ តត៑ ស្មត៌្តុំ ទរិទ្រលោកានាមុបការាត៌្ហំ ឝ្រមំ កត៌្តុញ្ច យុឞ្មាកម៑ ឧចិតម៑ ឯតត្សវ៌្វំ យុឞ្មានហម៑ ឧបទិឞ្ដវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ឯតាំ កថាំ កថយិត្វា ស ជានុនី បាតយិត្វា សវ៌ៃះ សហ ប្រាត៌្ហយត។ ");
INSERT INTO sankhm_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","តេន តេ ក្រន្ទ្រន្តះ ");
INSERT INTO sankhm_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","បុន រ្មម មុខំ ន ទ្រក្ឞ្យថ វិឝេឞត ឯឞា យា កថា តេនាកថិ តត្ការណាត៑ ឝោកំ វិលាបញ្ច ក្ឫត្វា កណ្ឋំ ធ្ឫត្វា ចុម្ពិតវន្តះ។ បឝ្ចាត៑ តេ តំ បោតំ នីតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","តៃ រ្វិស្ឫឞ្ដាះ សន្តោ វយំ បោតំ ពាហយិត្វា ឫជុមាគ៌េណ កោឞម៑ ឧបទ្វីបម៑ អាគត្យ បរេៜហនិ រោទិយោបទ្វីបម៑ អាគច្ឆាម តតស្តស្មាត៑ បាតារាយាម៑ ឧបាតិឞ្ឋាម។ ");
INSERT INTO sankhm_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","តត្រ ផៃនីកិយាទេឝគាមិនម៑ បោតមេកំ ប្រាប្យ តមារុហ្យ គតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","កុប្រោបទ្វីបំ ទ្ឫឞ្ដ្វា តំ សវ្យទិឝិ ស្ថាបយិត្វា សុរិយាទេឝំ គត្វា បោតស្ថទ្រវ្យាណ្យវរោហយិតុំ សោរនគរេ លាគិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","តត្រ ឝិឞ្យគណស្យ សាក្ឞាត្ករណាយ វយំ តត្រ សប្តទិនានិ ស្ថិតវន្តះ បឝ្ចាត្តេ បវិត្រេណាត្មនា បៅលំ វ្យាហរន៑ ត្វំ យិរូឝាលម្នគរំ មា គមះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","តតស្តេឞុ សប្តសុ ទិនេឞុ យាបិតេឞុ សត្សុ វយំ តស្មាត៑ ស្ថានាត៑ និជវត៌្មនា គតវន្តះ, តស្មាត៑ តេ សពាលវ្ឫទ្ធវនិតា អស្មាភិះ សហ នគរស្យ បរិសរបយ៌្យន្តម៑ អាគតាះ បឝ្ចាទ្វយំ ជលធិតដេ ជានុបាតំ ប្រាត៌្ហយាមហិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","តតះ បរស្បរំ វិស្ឫឞ្ដាះ សន្តោ វយំ បោតំ គតាស្តេ តុ ស្វស្វគ្ឫហំ ប្រត្យាគតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","វយំ សោរនគរាត៑ នាវា ប្រស្ថាយ តលិមាយិនគរម៑ ឧបាតិឞ្ឋាម តត្រាស្មាកំ សមុទ្រីយមាគ៌ស្យាន្តោៜភវត៑ តត្រ ភ្រាត្ឫគណំ នមស្ក្ឫត្យ ទិនមេកំ តៃះ សាទ៌្ធម៑ ឧឞតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","បរេ ៜហនិ បៅលស្តស្យ សង្គិនោ វយញ្ច ប្រតិឞ្ឋមានាះ កៃសរិយានគរម៑ អាគត្យ សុសំវាទប្រចារកានាំ សប្តជនានាំ ផិលិបនាម្ន ឯកស្យ គ្ឫហំ ប្រវិឝ្យាវតិឞ្ឋាម។ ");
INSERT INTO sankhm_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","តស្យ ចតស្រោ ទុហិតរោៜនូឍា ភវិឞ្យទ្វាទិន្យ អាសន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","តត្រាស្មាសុ ពហុទិនានិ ប្រោឞិតេឞុ យិហូទីយទេឝាទ៑ អាគត្យាគាពនាមា ភវិឞ្យទ្វាទី សមុបស្ថិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","សោស្មាកំ សមីបមេត្យ បៅលស្យ កដិពន្ធនំ គ្ឫហីត្វា និជហស្តាបាទាន៑ ពទ្ធ្វា ភាឞិតវាន៑ យស្យេទំ កដិពន្ធនំ តំ យិហូទីយលោកា យិរូឝាលមនគរ ឥត្ថំ ពទ្ធ្វា ភិន្នទេឝីយានាំ ករេឞុ សមប៌យិឞ្យន្តីតិ វាក្យំ បវិត្រ អាត្មា កថយតិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ឯតាទ្ឫឝីំ កថាំ ឝ្រុត្វា វយំ តន្នគរវាសិនោ ភ្រាតរឝ្ច យិរូឝាលមំ ន យាតុំ បៅលំ វ្យនយាមហិ; ");
INSERT INTO sankhm_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","កិន្តុ ស ប្រត្យាវាទីត៑, យូយំ កិំ កុរុថ? កិំ ក្រន្ទនេន មមាន្តះករណំ វិទីណ៌ំ ករិឞ្យថ? ប្រភោ រ្យីឝោ រ្នាម្នោ និមិត្តំ យិរូឝាលមិ ពទ្ធោ ភវិតុំ កេវល តន្ន ប្រាណាន៑ ទាតុមបិ សសជ្ជោស្មិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","តេនាស្មាកំ កថាយាម៑ អគ្ឫហីតាយាម៑ ឦឝ្វរស្យ យថេច្ឆា តថៃវ ភវត្វិត្យុក្ត្វា វយំ និរស្យាម។ ");
INSERT INTO sankhm_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","បរេៜហនិ បាថេយទ្រវ្យាណិ គ្ឫហីត្វា យិរូឝាលមំ ប្រតិ យាត្រាម៑ អកុម៌្ម។ ");
INSERT INTO sankhm_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","តតះ កៃសរិយានគរនិវាសិនះ កតិបយាះ ឝិឞ្យា អស្មាភិះ សាទ៌្ធម៑ ឥត្វា ក្ឫប្រីយេន ម្នាសន្នាម្នា យេន ប្រាចីនឝិឞ្យេន សាទ៌្ធម៑ អស្មាភិ រ្វស្តវ្យំ តស្យ សមីបម៑ អស្មាន៑ នីតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","អស្មាសុ យិរូឝាលម្យុបស្ថិតេឞុ តត្រស្ថភ្រាត្ឫគណោៜស្មាន៑ អាហ្លាទេន គ្ឫហីតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","បរស្មិន៑ ទិវសេ បៅលេៜស្មាភិះ សហ យាកូពោ គ្ឫហំ ប្រវិឞ្ដេ លោកប្រាចីនាះ សវ៌្វេ តត្រ បរិឞទិ សំស្ថិតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","អនន្តរំ ស តាន៑ នត្វា ស្វីយប្រចារណេន ភិន្នទេឝីយាន៑ ប្រតីឝ្វរោ យានិ កម៌្មាណិ សាធិតវាន៑ តទីយាំ កថាម៑ អនុក្រមាត៑ កថិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ឥតិ ឝ្រុត្វា តេ ប្រភុំ ធន្យំ ប្រោច្យ វាក្យមិទម៑ អភាឞន្ត, ហេ ភ្រាត រ្យិហូទីយានាំ មធ្យេ ពហុសហស្រាណិ លោកា វិឝ្វាសិន អាសតេ កិន្តុ តេ សវ៌្វេ វ្យវស្ថាមតាចារិណ ឯតត៑ ប្រត្យក្ឞំ បឝ្យសិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","ឝិឝូនាំ ត្វក្ឆេទនាទ្យាចរណំ ប្រតិឞិធ្យ ត្វំ ភិន្នទេឝនិវាសិនោ យិហូទីយលោកាន៑ មូសាវាក្យម៑ អឝ្រទ្ធាតុម៑ ឧបទិឝសីតិ តៃះ ឝ្រុតមស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","ត្វមត្រាគតោសីតិ វាត៌្តាំ សមាកណ៌្យ ជននិវហោ មិលិត្វាវឝ្យមេវាគមិឞ្យតិ; អតឯវ កិំ ករណីយម៑? អត្រ វយំ មន្ត្រយិត្វា សមុបាយំ ត្វាំ វទាមស្តំ ត្វមាចរ។ ");
INSERT INTO sankhm_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","វ្រតំ កត៌្តុំ ក្ឫតសង្កល្បា យេៜស្មាំក ចត្វារោ មានវាះ សន្តិ ");
INSERT INTO sankhm_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","តាន៑ គ្ឫហីត្វា តៃះ សហិតះ ស្វំ ឝុចិំ កុរុ តថា តេឞាំ ឝិរោមុណ្ឌនេ យោ វ្យយោ ភវតិ តំ ត្វំ ទេហិ។ តថា ក្ឫតេ ត្វទីយាចារេ យា ជនឝ្រុតិ រ្ជាយតេ សាលីកា កិន្តុ ត្វំ វិធិំ បាលយន៑ វ្យវស្ថានុសារេណេវាចរសីតិ តេ ភោត្សន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","ភិន្នទេឝីយានាំ វិឝ្វាសិលោកានាំ និកដេ វយំ បត្រំ លិខិត្វេត្ថំ ស្ថិរីក្ឫតវន្តះ, ទេវប្រសាទភោជនំ រក្តំ គលបីឌនមារិតប្រាណិភោជនំ វ្យភិចារឝ្ចៃតេភ្យះ ស្វរក្ឞណវ្យតិរេកេណ តេឞាមន្យវិធិបាលនំ ករណីយំ ន។ ");
INSERT INTO sankhm_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","តតះ បៅលស្តាន៑ មានុឞានាទាយ បរស្មិន៑ ទិវសេ តៃះ សហ ឝុចិ រ្ភូត្វា មន្ទិរំ គត្វា ឝៅចកម៌្មណោ ទិនេឞុ សម្បូណ៌េឞុ តេឞាម៑ ឯកៃកាត៌្ហំ នៃវេទ្យាទ្យុត្សគ៌ោ ភវិឞ្យតីតិ ជ្ញាបិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","តេឞុ សប្តសុ ទិនេឞុ សមាប្តកល្បេឞុ អាឝិយាទេឝនិវាសិនោ យិហូទីយាស្តំ មធ្យេមន្ទិរំ វិលោក្យ ជននិវហស្យ មនះសុ កុប្រវ្ឫត្តិំ ជនយិត្វា តំ ធ្ឫត្វា ");
INSERT INTO sankhm_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ប្រោច្ចៃះ ប្រាវោចន៑, ហេ ឥស្រាយេល្លោកាះ សវ៌្វេ សាហាយ្យំ កុរុត។ យោ មនុជ ឯតេឞាំ លោកានាំ មូសាវ្យវស្ថាយា ឯតស្យ ស្ថានស្យាបិ វិបរីតំ សវ៌្វត្រ សវ៌្វាន៑ ឝិក្ឞយតិ ស ឯឞះ; វិឝេឞតះ ស ភិន្នទេឝីយលោកាន៑ មន្ទិរម៑ អានីយ បវិត្រស្ថានមេតទ៑ អបវិត្រមករោត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","បូវ៌្វំ តេ មធ្យេនគរម៑ ឥផិឞនគរីយំ ត្រផិមំ បៅលេន សហិតំ ទ្ឫឞ្ដវន្ត ឯតស្មាត៑ បៅលស្តំ មន្ទិរមធ្យម៑ អានយទ៑ ឥត្យន្វមិមត។ ");
INSERT INTO sankhm_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","អតឯវ សវ៌្វស្មិន៑ នគរេ កលហោត្បន្នត្វាត៑ ធាវន្តោ លោកា អាគត្យ បៅលំ ធ្ឫត្វា មន្ទិរស្យ ពហិរាក្ឫឞ្យានយន៑ តត្ក្ឞណាទ៑ ទ្វារាណិ សវ៌្វាណិ ច រុទ្ធានិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","តេឞុ តំ ហន្តុមុទ្យតេेឞុ យិរូឝាលម្នគរេ មហានុបទ្រវោ ជាត ឥតិ វាត៌្តាយាំ សហស្រសេនាបតេះ កណ៌គោចរីភូតាយាំ សត្យាំ ស តត្ក្ឞណាត៑ សៃន្យានិ សេនាបតិគណញ្ច គ្ឫហីត្វា ជវេនាគតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","តតោ លោកាះ សេនាគណេន សហ សហស្រសេនាបតិម៑ អាគច្ឆន្តំ ទ្ឫឞ្ដ្វា បៅលតាឌនាតោ ន្យវត៌្តន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","ស សហស្រសេនាបតិះ សន្និធាវាគម្យ បៅលំ ធ្ឫត្វា ឝ្ឫង្ខលទ្វយេន ពទ្ធម៑ អាទិឝ្យ តាន៑ ប្ឫឞ្ដវាន៑ ឯឞ កះ? កិំ កម៌្ម ចាយំ ក្ឫតវាន៑? ");
INSERT INTO sankhm_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","តតោ ជនសមូហស្យ កឝ្ចិទ៑ ឯកប្រការំ កឝ្ចិទ៑ អន្យប្រការំ វាក្យម៑ អរៅត៑ ស តត្រ សត្យំ ជ្ញាតុម៑ កលហការណាទ៑ អឝក្តះ សន៑ តំ ទុគ៌ំ នេតុម៑ អាជ្ញាបយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","តេឞុ សោបានស្យោបរិ ប្រាប្តេឞុ លោកានាំ សាហសការណាត៑ សេនាគណះ បៅលមុត្តោល្យ នីតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","តតះ សវ៌្វេ លោកាះ បឝ្ចាទ្គាមិនះ សន្ត ឯនំ ទុរីកុរុតេតិ វាក្យម៑ ឧច្ចៃរវទន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","បៅលស្យ ទុគ៌ានយនសមយេ ស តស្មៃ សហស្រសេនាបតយេ កថិតវាន៑, ភវតះ បុរស្តាត៑ កថាំ កថយិតុំ កិម៑ អនុមន្យតេ? ស តមប្ឫច្ឆត៑ ត្វំ កិំ យូនានីយាំ ភាឞាំ ជានាសិ? ");
INSERT INTO sankhm_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","យោ មិសរីយោ ជនះ បូវ៌្វំ វិរោធំ ក្ឫត្វា ចត្វារិ សហស្រាណិ ឃាតកាន៑ សង្គិនះ ក្ឫត្វា វិបិនំ គតវាន៑ ត្វំ កិំ សឯវ ន ភវសិ? ");
INSERT INTO sankhm_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","តទា បៅលោៜកថយត៑ អហំ កិលិកិយាទេឝស្យ តាឞ៌នគរីយោ យិហូទីយោ, នាហំ សាមាន្យនគរីយោ មានវះ; អតឯវ វិនយេៜហំ លាកានាំ សមក្ឞំ កថាំ កថយិតុំ មាមនុជានីឞ្វ។ ");
INSERT INTO sankhm_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","តេនានុជ្ញាតះ បៅលះ សោបានោបរិ តិឞ្ឋន៑ ហស្តេនេង្គិតំ ក្ឫតវាន៑, តស្មាត៑ សវ៌្វេ សុស្ថិរា អភវន៑។ តទា បៅល ឥព្រីយភាឞយា កថយិតុម៑ អារភត, ");
INSERT INTO sankhm_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","ហេ បិត្ឫគណា ហេ ភ្រាត្ឫគណាះ, ឥទានីំ មម និវេទនេ សមវធត្ត។ ");
INSERT INTO sankhm_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","តទា ស ឥព្រីយភាឞយា កថាំ កថយតីតិ ឝ្រុត្វា សវ៌្វេ លោកា អតីវ និះឝព្ទា សន្តោៜតិឞ្ឋន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","បឝ្ចាត៑ សោៜកថយទ៑ អហំ យិហូទីយ ឥតិ និឝ្ចយះ កិលិកិយាទេឝស្យ តាឞ៌នគរំ មម ជន្មភូមិះ,ឯតន្នគរីយស្យ គមិលីយេលនាម្នោៜធ្យាបកស្យ ឝិឞ្យោ ភូត្វា បូវ៌្វបុរុឞាណាំ វិធិវ្យវស្ថានុសារេណ សម្បូណ៌រូបេណ ឝិក្ឞិតោៜភវម៑ ឥទានីន្តនា យូយំ យាទ្ឫឝា ភវថ តាទ្ឫឝោៜហមបីឝ្វរសេវាយាម៑ ឧទ្យោគី ជាតះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","មតមេតទ៑ ទ្វិឞ្ដ្វា តទ្គ្រាហិនារីបុរុឞាន៑ ការាយាំ ពទ្ធ្វា តេឞាំ ប្រាណនាឝបយ៌្យន្តាំ វិបក្ឞតាម៑ អករវម៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","មហាយាជកះ សភាសទះ ប្រាចីនលោកាឝ្ច មមៃតស្យាះ កថាយាះ ប្រមាណំ ទាតុំ ឝក្នុវន្តិ, យស្មាត៑ តេឞាំ សមីបាទ៑ ទម្មេឞកនគរនិវាសិភ្រាត្ឫគណាត៌្ហម៑ អាជ្ញាបត្រាណិ គ្ឫហីត្វា យេ តត្រ ស្ថិតាស្តាន៑ ទណ្ឌយិតុំ យិរូឝាលមម៑ អានយនាត៌្ហំ ទម្មេឞកនគរំ គតោស្មិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","កិន្តុ គច្ឆន៑ តន្នគរស្យ សមីបំ ប្រាប្តវាន៑ តទា ទ្វិតីយប្រហរវេលាយាំ សត្យាម៑ អកស្មាទ៑ គគណាន្និគ៌ត្យ មហតី ទីប្តិ រ្មម ចតុទ៌ិឝិ ប្រកាឝិតវតី។ ");
INSERT INTO sankhm_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","តតោ មយិ ភូមៅै បតិតេ សតិ, ហេ ឝៅល ហេ ឝៅល កុតោ មាំ តាឌយសិ? មាម្ប្រតិ ភាឞិត ឯតាទ្ឫឝ ឯកោ រវោបិ មយា ឝ្រុតះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","តទាហំ ប្រត្យវទំ, ហេ ប្រភេ កោ ភវាន៑? តតះ សោៜវាទីត៑ យំ ត្វំ តាឌយសិ ស នាសរតីយោ យីឝុរហំ។ ");
INSERT INTO sankhm_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","មម សង្គិនោ លោកាស្តាំ ទីប្តិំ ទ្ឫឞ្ដ្វា ភិយំ ប្រាប្តាះ, កិន្តុ មាម្ប្រត្យុទិតំ តទ្វាក្យំ តេे នាពុធ្យន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","តតះ បរំ ប្ឫឞ្ដវានហំ, ហេ ប្រភោ មយា កិំ កត៌្តវ្យំ? តតះ ប្រភុរកថយត៑, ឧត្ថាយ ទម្មេឞកនគរំ យាហិ ត្វយា យទ្យត៑ កត៌្តវ្យំ និរូបិតមាស្តេ តត៑ តត្រ ត្វំ ជ្ញាបយិឞ្យសេ។ ");
INSERT INTO sankhm_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","អនន្តរំ តស្យាះ ខរតរទីប្តេះ ការណាត៑ កិមបិ ន ទ្ឫឞ្ដ្វា សង្គិគណេន ធ្ឫតហស្តះ សន៑ ទម្មេឞកនគរំ វ្រជិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","តន្នគរនិវាសិនាំ សវ៌្វេឞាំ យិហូទីយានាំ មាន្យោ វ្យវស្ថានុសារេណ ភក្តឝ្ច ហនានីយនាមា មានវ ឯកោ ");
INSERT INTO sankhm_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","មម សន្និធិម៑ ឯត្យ តិឞ្ឋន៑ អកថយត៑, ហេ ភ្រាតះ ឝៅល សុទ្ឫឞ្ដិ រ្ភវ តស្មិន៑ ទណ្ឌេៜហំ សម្យក៑ តំ ទ្ឫឞ្ដវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","តតះ ស មហ្យំ កថិតវាន៑ យថា ត្វម៑ ឦឝ្វរស្យាភិប្រាយំ វេត្សិ តស្យ ឝុទ្ធសត្ត្វជនស្យ ទឝ៌នំ ប្រាប្យ តស្យ ឝ្រីមុខស្យ វាក្យំ ឝ្ឫណោឞិ តន្និមិត្តម៑ អស្មាកំ បូវ៌្វបុរុឞាណាម៑ ឦឝ្វរស្ត្វាំ មនោនីតំ ក្ឫតវានំ។ ");
INSERT INTO sankhm_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","យតោ យទ្យទ៑ អទ្រាក្ឞីរឝ្រៅឞីឝ្ច សវ៌្វេឞាំ មានវានាំ សមីបេ ត្វំ តេឞាំ សាក្ឞី ភវិឞ្យសិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","អតឯវ កុតោ វិលម្ពសេ? ប្រភោ រ្នាម្នា ប្រាត៌្ហ្យ និជបាបប្រក្ឞាលនាត៌្ហំ មជ្ជនាយ សមុត្តិឞ្ឋ។ ");
INSERT INTO sankhm_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","តតះ បរំ យិរូឝាលម្នគរំ ប្រត្យាគត្យ មន្ទិរេៜហម៑ ឯកទា ប្រាត៌្ហយេ, តស្មិន៑ សមយេៜហម៑ អភិភូតះ សន៑ ប្រភូំ សាក្ឞាត៑ បឝ្យន៑, ");
INSERT INTO sankhm_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ត្វំ ត្វរយា យិរូឝាលមះ ប្រតិឞ្ឋស្វ យតោ លោកាមយិ តវ សាក្ឞ្យំ ន គ្រហីឞ្យន្តិ, មាម្ប្រត្យុទិតំ តស្យេទំ វាក្យម៑ អឝ្រៅឞម៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","តតោហំ ប្រត្យវាទិឞម៑ ហេ ប្រភោ ប្រតិភជនភវនំ ត្វយិ វិឝ្វាសិនោ លោកាន៑ ពទ្ធ្វា ប្រហ្ឫតវាន៑, ");
INSERT INTO sankhm_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","តថា តវ សាក្ឞិណះ ស្តិផានស្យ រក្តបាតនសមយេ តស្យ វិនាឝំ សម្មន្យ សន្និធៅ តិឞ្ឋន៑ ហន្ត្ឫលោកានាំ វាសាំសិ រក្ឞិតវាន៑, ឯតត៑ តេ វិទុះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","តតះ សោៜកថយត៑ ប្រតិឞ្ឋស្វ ត្វាំ ទូរស្ថភិន្នទេឝីយានាំ សមីបំ ប្រេឞយិឞ្យេ។ ");
INSERT INTO sankhm_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","តទា លោកា ឯតាវត្បយ៌្យន្តាំ តទីយាំ កថាំ ឝ្រុត្វា ប្រោច្ចៃរកថយន៑, ឯនំ ភូមណ្ឌលាទ៑ ទូរីកុរុត, ឯតាទ្ឫឝជនស្យ ជីវនំ នោចិតម៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ឥត្យុច្ចៃះ កថយិត្វា វសនានិ បរិត្យជ្យ គគណំ ប្រតិ ធូលីរក្ឞិបន្ ");
INSERT INTO sankhm_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","តតះ សហស្រសេនាបតិះ បៅលំ ទុគ៌ាភ្យន្តរ នេតុំ សមាទិឝត៑។ ឯតស្យ ប្រតិកូលាះ សន្តោ លោកាះ កិន្និមិត្តម៑ ឯតាវទុច្ចៃះស្វរម៑ អកុវ៌្វន៑, ឯតទ៑ វេត្តុំ តំ កឝយា ប្រហ្ឫត្យ តស្យ បរីក្ឞាំ កត៌្តុមាទិឝត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","បទាតយឝ្ចម៌្មនិម៌្មិតរជ្ជុភិស្តស្យ ពន្ធនំ កត៌្តុមុទ្យតាស្តាស្តទានីំ បៅលះ សម្មុខស្ថិតំ ឝតសេនាបតិម៑ ឧក្តវាន៑ ទណ្ឌាជ្ញាយាម៑ អប្រាប្តាយាំ កិំ រោមិលោកំ ប្រហត៌្តុំ យុឞ្មាកម៑ អធិការោស្តិ? ");
INSERT INTO sankhm_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","ឯនាំ កថាំ ឝ្រុត្វា ស សហស្រសេនាបតេះ សន្និធិំ គត្វា តាំ វាត៌្តាមវទត៑ ស រោមិលោក ឯតស្មាត៑ សាវធានះ សន៑ កម៌្ម កុរុ។ ");
INSERT INTO sankhm_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","តស្មាត៑ សហស្រសេនាបតិ រ្គត្វា តមប្រាក្ឞីត៑ ត្វំ កិំ រោមិលោកះ? ឥតិ មាំ ព្រូហិ។ សោៜកថយត៑ សត្យម៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","តតះ សហស្រសេនាបតិះ កថិតវាន៑ ពហុទ្រវិណំ ទត្ត្វាហំ តត៑ បៅរសខ្យំ ប្រាប្តវាន៑; កិន្តុ បៅលះ កថិតវាន៑ អហំ ជនុនា តត៑ ប្រាប្តោៜស្មិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","ឥត្ថំ សតិ យេ ប្រហារេណ តំ បរីក្ឞិតុំ សមុទ្យតា អាសន៑ តេ តស្យ សមីបាត៑ ប្រាតិឞ្ឋន្ត; សហស្រសេនាបតិស្តំ រោមិលោកំ វិជ្ញាយ ស្វយំ យត៑ តស្យ ពន្ធនម៑ អកាឞ៌ីត៑ តត្ការណាទ៑ អពិភេត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","យិហូទីយលោកាះ បៅលំ កុតោៜបវទន្តេ តស្យ វ្ឫត្តាន្តំ ជ្ញាតុំ វាញ្ឆន៑ សហស្រសេនាបតិះ បរេៜហនិ បៅលំ ពន្ធនាត៑ មោចយិត្វា ប្រធានយាជកាន៑ មហាសភាយាះ សវ៌្វលោកាឝ្ច សមុបស្ថាតុម៑ អាទិឝ្យ តេឞាំ សន្និធៅ បៅលម៑ អវរោហ្យ ស្ថាបិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","សភាសទ្លោកាន៑ ប្រតិ បៅលោៜនន្យទ្ឫឞ្ដ្យា បឝ្យន៑ អកថយត៑, ហេ ភ្រាត្ឫគណា អទ្យ យាវត៑ សរលេន សវ៌្វាន្តះករណេនេឝ្វរស្យ សាក្ឞាទ៑ អាចរាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","អនេន ហនានីយនាមា មហាយាជកស្តំ កបោលេ ចបេដេនាហន្តុំ សមីបស្ថលោកាន៑ អាទិឞ្ដវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","តទា បៅលស្តមវទត៑, ហេ ពហិឞ្បរិឞ្ក្ឫត, ឦឝ្វរស្ត្វាំ ប្រហត៌្តុម៑ ឧទ្យតោស្តិ, យតោ វ្យវស្ថានុសារេណ វិចារយិតុម៑ ឧបវិឝ្យ វ្យវស្ថាំ លង្ឃិត្វា មាំ ប្រហត៌្តុម៑ អាជ្ញាបយសិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","តតោ និកដស្ថា លោកា អកថយន៑, ត្វំ កិម៑ ឦឝ្វរស្យ មហាយាជកំ និន្ទសិ? ");
INSERT INTO sankhm_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","តតះ បៅលះ ប្រតិភាឞិតវាន៑ ហេ ភ្រាត្ឫគណ មហាយាជក ឯឞ ឥតិ ន ពុទ្ធំ មយា តទន្យច្ច ស្វលោកានាម៑ អធិបតិំ ប្រតិ ទុវ៌្វាក្យំ មា កថយ, ឯតាទ្ឫឝី លិបិរស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","អនន្តរំ បៅលស្តេឞាម៑ អទ៌្ធំ សិទូកិលោកា អទ៌្ធំ ផិរូឝិលោកា ឥតិ ទ្ឫឞ្ដ្វា ប្រោច្ចៃះ សភាស្ថលោកាន៑ អវទត៑ ហេ ភ្រាត្ឫគណ អហំ ផិរូឝិមតាវលម្ពី ផិរូឝិនះ សត្នានឝ្ច, ម្ឫតលោកានាម៑ ឧត្ថានេ ប្រត្យាឝាករណាទ៑ អហមបវាទិតោស្មិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ឥតិ កថាយាំ កថិតាយាំ ផិរូឝិសិទូកិនោះ បរស្បរំ ភិន្នវាក្យត្វាត៑ សភាយា មធ្យេ ទ្វៅ សំឃៅ ជាតៅ។ ");
INSERT INTO sankhm_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","យតះ សិទូកិលោកា ឧត្ថានំ ស្វគ៌ីយទូតា អាត្មានឝ្ច សវ៌្វេឞាម៑ ឯតេឞាំ កមបិ ន មន្យន្តេ, កិន្តុ ផិរូឝិនះ សវ៌្វម៑ អង្គីកុវ៌្វន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","តតះ បរស្បរម៑ អតិឝយកោលាហលេ សមុបស្ថិតេ ផិរូឝិនាំ បក្ឞីយាះ សភាស្ថា អធ្យាបកាះ ប្រតិបក្ឞា ឧត្តិឞ្ឋន្តោ ៜកថយន៑, ឯតស្យ មានវស្យ កមបិ ទោឞំ ន បឝ្យាមះ; យទិ កឝ្ចិទ៑ អាត្មា វា កឝ្ចិទ៑ ទូត ឯនំ ប្រត្យាទិឝត៑ តហ៌ិ វយម៑ ឦឝ្វរស្យ ប្រាតិកូល្យេន ន យោត្ស្យាមះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","តស្មាទ៑ អតីវ ភិន្នវាក្យត្វេ សតិ តេ បៅលំ ខណ្ឌំ ខណ្ឌំ ករិឞ្យន្តីត្យាឝង្កយា សហស្រសេនាបតិះ សេនាគណំ តត្ស្ថានំ យាតុំ សភាតោ ពលាត៑ បៅលំ ធ្ឫត្វា ទុគ៌ំ នេតញ្ចាជ្ញាបយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","រាត្រោ ប្រភុស្តស្យ សមីបេ តិឞ្ឋន៑ កថិតវាន៑ ហេ បៅល និព៌្ហយោ ភវ យថា យិរូឝាលម្នគរេ មយិ សាក្ឞ្យំ ទត្តវាន៑ តថា រោមានគរេបិ ត្វយា ទាតវ្យម៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","ទិនេ សមុបស្ថិតេ សតិ កិយន្តោ យិហូទីយលោកា ឯកមន្ត្រណាះ សន្តះ បៅលំ ន ហត្វា ភោជនបានេ ករិឞ្យាម ឥតិ ឝបថេន ស្វាន៑ អពធ្នន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","ចត្វារិំឝជ្ជនេភ្យោៜធិកា លោកា ឥតិ បណម៑ អកុវ៌្វន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","តេ មហាយាជកានាំ ប្រាចីនលោកានាញ្ច សមីបំ គត្វា កថយន៑, វយំ បៅលំ ន ហត្វា កិមបិ ន ភោក្ឞ្យាមហេ ទ្ឫឍេនានេន ឝបថេន ពទ្ធ្វា អភវាម។ ");
INSERT INTO sankhm_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","អតឯវ សាម្ប្រតំ សភាសទ្លោកៃះ សហ វយំ តស្មិន៑ កញ្ចិទ៑ វិឝេឞវិចារំ ករិឞ្យាមស្តទត៌្ហំ ភវាន៑ ឝ្វោ ៜស្មាកំ សមីបំ តម៑ អានយត្វិតិ សហស្រសេនាបតយេ និវេទនំ កុរុត តេន យុឞ្មាកំ សមីបំ ឧបស្ថិតេះ បូវ៌្វំ វយំ តំ ហន្តុ សជ្ជិឞ្យាម។ ");
INSERT INTO sankhm_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","តទា បៅលស្យ ភាគិនេយស្តេឞាមិតិ មន្ត្រណាំ វិជ្ញាយ ទុគ៌ំ គត្វា តាំ វាត៌្តាំ បៅលម៑ ឧក្តវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","តស្មាត៑ បៅល ឯកំ ឝតសេនាបតិម៑ អាហូយ វាក្យមិទម៑ ភាឞិតវាន៑ សហស្រសេនាបតេះ សមីបេៜស្យ យុវមនុឞ្យស្យ កិញ្ចិន្និវេទនម៑ អាស្តេ, តស្មាត៑ តត្សវិធម៑ ឯនំ នយ។ ");
INSERT INTO sankhm_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","តតះ ស តមាទាយ សហស្រសេនាបតេះ សមីបម៑ ឧបស្ថាយ កថិតវាន៑, ភវតះ សមីបេៜស្យ កិមបិ និវេទនមាស្តេ តស្មាត៑ ពន្ទិះ បៅលោ មាមាហូយ ភវតះ សមីបម៑ ឯនម៑ អានេតុំ ប្រាត៌្ហិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","តទា សហស្រសេនាបតិស្តស្យ ហស្តំ ធ្ឫត្វា និជ៌នស្ថានំ នីត្វា ប្ឫឞ្ឋវាន៑ តវ កិំ និវេទនំ? តត៑ កថយ។ ");
INSERT INTO sankhm_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","តតះ សោកថយត៑, យិហូទីយលាកាះ បៅលេ កមបិ វិឝេឞវិចារំ ឆលំ ក្ឫត្វា តំ សភាំ នេតុំ ភវតះ សមីបេ និវេទយិតុំ អមន្ត្រយន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","កិន្តុ មវតា តន្ន ស្វីកត៌្តវ្យំ យតស្តេឞាំ មធ្យេវត៌្តិនឝ្ចត្វារិំឝជ្ជនេភ្យោ ៜធិកលោកា ឯកមន្ត្រណា ភូត្វា បៅលំ ន ហត្វា ភោជនំ បានញ្ច ន ករិឞ្យាម ឥតិ ឝបថេន ពទ្ធាះ សន្តោ ឃាតកា ឥវ សជ្ជិតា ឥទានីំ កេវលំ ភវតោ ៜនុមតិម៑ អបេក្ឞន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","យាមិមាំ កថាំ ត្វំ និវេទិតវាន៑ តាំ កស្មៃចិទបិ មា កថយេត្យុក្ត្វា សហស្រសេនាបតិស្តំ យុវានំ វិស្ឫឞ្ដវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","អនន្តរំ សហស្រសេនាបតិ រ្ទ្វៅ ឝតសេនាបតី អាហូយេទម៑ អាទិឝត៑, យុវាំ រាត្រៅ ប្រហរៃកាវឝិឞ្ដាយាំ សត្យាំ កៃសរិយានគរំ យាតុំ បទាតិសៃន្យានាំ ទ្វេ ឝតេ ឃោដការោហិសៃន្យានាំ សប្តតិំ ឝក្តិធារិសៃន្យានាំ ទ្វេ ឝតេ ច ជនាន៑ សជ្ជិតាន៑ កុរុតំ។ ");
INSERT INTO sankhm_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","បៅលម៑ អារោហយិតុំ ផីលិក្ឞាធិបតេះ សមីបំ និវ៌្វិឃ្នំ នេតុញ្ច វាហនានិ សមុបស្ថាបយតំ។ ");
INSERT INTO sankhm_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","អបរំ ស បត្រំ លិខិត្វា ទត្តវាន៑ តល្លិខិតមេតត៑, ");
INSERT INTO sankhm_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","មហាមហិមឝ្រីយុក្តផីលិក្ឞាធិបតយេ ក្លៅទិយលុឞិយស្យ នមស្ការះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","យិហូទីយលោកាះ បូវ៌្វម៑ ឯនំ មានវំ ធ្ឫត្វា ស្វហស្តៃ រ្ហន្តុម៑ ឧទ្យតា ឯតស្មិន្នន្តរេ សសៃន្យោហំ តត្រោបស្ថាយ ឯឞ ជនោ រោមីយ ឥតិ វិជ្ញាយ តំ រក្ឞិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","កិន្និមិត្តំ តេ តមបវទន្តេ តជ្ជ្ញាតុំ តេឞា សភាំ តមានាយិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","តតស្តេឞាំ វ្យវស្ថាយា វិរុទ្ធយា កយាចន កថយា សោៜបវាទិតោៜភវត៑, កិន្តុ ស ឝ្ឫង្ខលពន្ធនាហ៌ោ វា ប្រាណនាឝាហ៌ោ ភវតីទ្ឫឝះ កោប្យបរាធោ មយាស្យ ន ទ្ឫឞ្ដះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","តថាបិ មនុឞ្យស្យាស្យ វធាត៌្ហំ យិហូទីយា ឃាតកាឥវ សជ្ជិតា ឯតាំ វាត៌្តាំ ឝ្រុត្វា តត្ក្ឞណាត៑ តវ សមីបមេនំ ប្រេឞិតវាន៑ អស្យាបវាទកាំឝ្ច តវ សមីបំ គត្វាបវទិតុម៑ អាជ្ញាបយម៑។ ភវតះ កុឝលំ ភូយាត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","សៃន្យគណ អាជ្ញានុសារេណ បៅលំ គ្ឫហីត្វា តស្យាំ រជន្យាម៑ អាន្តិបាត្រិនគរម៑ អានយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","បរេៜហនិ តេន សហ យាតុំ ឃោដការូឍសៃន្យគណំ ស្ថាបយិត្វា បរាវ្ឫត្យ ទុគ៌ំ គតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","តតះ បរេ ឃោដការោហិសៃន្យគណះ កៃសរិយានគរម៑ ឧបស្ថាយ តត្បត្រម៑ អធិបតេះ ករេ សមប៌្យ តស្យ សមីបេ បៅលម៑ ឧបស្ថាបិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","តទាធិបតិស្តត្បត្រំ បឋិត្វា ប្ឫឞ្ឋវាន៑ ឯឞ កិម្ប្រទេឝីយោ ជនះ? ស កិលិកិយាប្រទេឝីយ ឯកោ ជន ឥតិ ជ្ញាត្វា កថិតវាន៑, ");
INSERT INTO sankhm_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","តវាបវាទកគណ អាគតេ តវ កថាំ ឝ្រោឞ្យាមិ។ ហេរោទ្រាជគ្ឫហេ តំ ស្ថាបយិតុម៑ អាទិឞ្ដវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","បញ្ចភ្យោ ទិនេភ្យះ បរំ ហនានីយនាមា មហាយាជកោៜធិបតេះ សមក្ឞំ បៅលស្យ ប្រាតិកូល្យេន និវេទយិតុំ តត៌ុល្លនាមានំ កញ្ចន វក្តារំ ប្រាចីនជនាំឝ្ច សង្គិនះ ក្ឫត្វា កៃសរិយានគរម៑ អាគច្ឆត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","តតះ បៅលេ សមានីតេ សតិ តត៌ុល្លស្តស្យាបវាទកថាំ កថយិតុម៑ អារភត ហេ មហាមហិមផីលិក្ឞ ភវតោ វយម៑ អតិនិវ៌្វិឃ្នំ កាលំ យាបយាមោ ភវតះ បរិណាមទឝ៌ិតយា ឯតទ្ទេឝីយានាំ ពហូនិ មង្គលានិ ឃដិតានិ, ");
INSERT INTO sankhm_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","ឥតិ ហេតោ រ្វយមតិក្ឫតជ្ញាះ សន្តះ សវ៌្វត្រ សវ៌្វទា ភវតោ គុណាន៑ គាយមះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","កិន្តុ ពហុភិះ កថាភិ រ្ភវន្តំ យេន ន វិរញ្ជយាមិ តស្មាទ៑ វិនយេ ភវាន៑ ពនុកម្ប្យ មទល្បកថាំ ឝ្ឫណោតុ។ ");
INSERT INTO sankhm_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","ឯឞ មហាមារីស្វរូបោ នាសរតីយមតគ្រាហិសំឃាតស្យ មុខ្យោ ភូត្វា សវ៌្វទេឝេឞុ សវ៌្វេឞាំ យិហូទីយានាំ រាជទ្រោហាចរណប្រវ្ឫត្តិំ ជនយតីត្យស្មាភិ រ្និឝ្ចិតំ។ ");
INSERT INTO sankhm_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","ស មន្ទិរមបិ អឝុចិ កត៌្តុំ ចេឞ្ដិតវាន៑; ឥតិ ការណាទ៑ វយម៑ ឯនំ ធ្ឫត្វា ស្វវ្យវស្ថានុសារេណ វិចារយិតុំ ប្រាវត៌្តាមហិ; ");
INSERT INTO sankhm_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","កិន្តុ លុឞិយះ សហស្រសេនាបតិរាគត្យ ពលាទ៑ អស្មាកំ ករេភ្យ ឯនំ គ្ឫហីត្វា ");
INSERT INTO sankhm_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ឯតស្យាបវាទកាន៑ ភវតះ សមីបម៑ អាគន្តុម៑ អាជ្ញាបយត៑។ វយំ យស្មិន៑ តមបវាទាមោ ភវតា បទបវាទកថាយាំ វិចារិតាយាំ សត្យាំ សវ៌្វំ វ្ឫត្តាន្តំ វេទិតុំ ឝក្ឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","តតោ យិហូទីយា អបិ ស្វីក្ឫត្យ កថិតវន្ត ឯឞា កថា ប្រមាណម៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","អធិបតៅ កថាំ កថយិតុំ បៅលំ ប្រតីង្គិតំ ក្ឫតវតិ ស កថិតវាន៑ ភវាន៑ ពហូន៑ វត្សរាន៑ យាវទ៑ ឯតទ្ទេឝស្យ ឝាសនំ ករោតីតិ វិជ្ញាយ ប្រត្យុត្តរំ ទាតុម៑ អក្ឞោភោៜភវម៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","អទ្យ កេវលំ ទ្វាទឝ ទិនានិ យាតានិ, អហម៑ អារាធនាំ កត៌្តុំ យិរូឝាលមនគរំ គតវាន៑ ឯឞា កថា ភវតា ជ្ញាតុំ ឝក្យតេ; ");
INSERT INTO sankhm_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","កិន្ត្វិភេ មាំ មធ្យេមន្ទិរំ កេនាបិ សហ វិតណ្ឌាំ កុវ៌្វន្តំ កុត្រាបិ ភជនភវនេ នគរេ វា លោកាន៑ កុប្រវ្ឫត្តិំ ជនយន្តុំ ន ទ្ឫឞ្ដវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","ឥទានីំ យស្មិន៑ យស្មិន៑ មាម៑ អបវទន្តេ តស្យ កិមបិ ប្រមាណំ ទាតុំ ន ឝក្នុវន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","កិន្តុ ភវិឞ្យទ្វាក្យគ្រន្ថេ វ្យវស្ថាគ្រន្ថេ ច យា យា កថា លិខិតាស្តេ តាសុ សវ៌្វាសុ វិឝ្វស្យ យន្មតម៑ ឥមេ វិធម៌្មំ ជានន្តិ តន្មតានុសារេណាហំ និជបិត្ឫបុរុឞាណាម៑ ឦឝ្វរម៑ អារាធយាមីត្យហំ ភវតះ សមក្ឞម៑ អង្គីករោមិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","ធាម៌្មិកាណាម៑ អធាម៌្មិកាណាញ្ច ប្រមីតលោកានាមេវោត្ថានំ ភវិឞ្យតីតិ កថាមិមេ ស្វីកុវ៌្វន្តិ តថាហមបិ តស្មិន៑ ឦឝ្វរេ ប្រត្យាឝាំ ករោមិ; ");
INSERT INTO sankhm_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","ឦឝ្វរស្យ មានវានាញ្ច សមីបេ យថា និទ៌ោឞោ ភវាមិ តទត៌្ហំ សតតំ យត្នវាន៑ អស្មិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","ពហុឞុ វត្សរេឞុ គតេឞុ ស្វទេឝីយលោកានាំ និមិត្តំ ទានីយទ្រវ្យាណិ នៃវេទ្យានិ ច សមាទាយ បុនរាគមនំ ក្ឫតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","តតោហំ ឝុចិ រ្ភូត្វា លោកានាំ សមាគមំ កលហំ វា ន ការិតវាន៑ តថាប្យាឝិយាទេឝីយាះ កិយន្តោ យិហុទីយលោកា មធ្យេមន្ទិរំ មាំ ធ្ឫតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","មមោបរិ យទិ កាចិទបវាទកថាស្តិ តហ៌ិ ភវតះ សមីបម៑ ឧបស្ថាយ តេឞាមេវ សាក្ឞ្យទានម៑ ឧចិតម៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","នោចេត៑ បូវ៌្វេ មហាសភាស្ថានាំ លោកានាំ សន្និធៅ មម ទណ្ឌាយមានត្វសមយេ, អហមទ្យ ម្ឫតានាមុត្ថានេ យុឞ្មាភិ រ្វិចារិតោស្មិ, ");
INSERT INTO sankhm_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","តេឞាំ មធ្យេ តិឞ្ឋន្នហំ យាមិមាំ កថាមុច្ចៃះ ស្វរេណ កថិតវាន៑ តទន្យោ មម កោបិ ទោឞោៜលភ្យត ន វេតិ វរម៑ ឯតេ សមុបស្ថិតលោកា វទន្តុ។ ");
INSERT INTO sankhm_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","តទា ផីលិក្ឞ ឯតាំ កថាំ ឝ្រុត្វា តន្មតស្យ វិឝេឞវ្ឫត្តាន្តំ វិជ្ញាតុំ វិចារំ ស្ថគិតំ ក្ឫត្វា កថិតវាន៑ លុឞិយេ សហស្រសេនាបតៅ សមាយាតេ សតិ យុឞ្មាកំ វិចារម៑ អហំ និឞ្បាទយិឞ្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","អនន្តរំ ពន្ធនំ វិនា បៅលំ រក្ឞិតុំ តស្យ សេវនាយ សាក្ឞាត្ករណាយ វា តទីយាត្មីយពន្ធុជនាន៑ ន វារយិតុញ្ច ឝមសេនាបតិម៑ អាទិឞ្ដវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","អល្បទិនាត៑ បរំ ផីលិក្ឞោៜធិបតិ រ្ទ្រុឞិល្លានាម្នា យិហូទីយយា ស្វភាយ៌្យយា សហាគត្យ បៅលមាហូយ តស្យ មុខាត៑ ខ្រីឞ្ដធម៌្មស្យ វ្ឫត្តាន្តម៑ អឝ្រៅឞីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","បៅលេន ន្យាយស្យ បរិមិតភោគស្យ ចរមវិចារស្យ ច កថាយាំ កថិតាយាំ សត្យាំ ផីលិក្ឞះ កម្បមានះ សន៑ វ្យាហរទ៑ ឥទានីំ យាហិ, អហម៑ អវកាឝំ ប្រាប្យ ត្វាម៑ អាហូស្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","មុក្តិប្រប្ត្យត៌្ហំ បៅលេន មហ្យំ មុទ្រាទាស្យន្តេ ឥតិ បត្យាឝាំ ក្ឫត្វា ស បុនះ បុនស្តមាហូយ តេន សាកំ កថោបកថនំ ក្ឫតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","កិន្តុ វត្សរទ្វយាត៑ បរំ បក៌ិយផីឞ្ដ ផាលិក្ឞស្យ បទំ ប្រាប្តេ សតិ ផីលិក្ឞោ យិហូទីយាន៑ សន្តុឞ្ដាន៑ ចិកីឞ៌ន៑ បៅលំ ពទ្ធំ សំស្ថាប្យ គតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","អនន្តរំ ផីឞ្ដោ និជរាជ្យម៑ អាគត្យ ទិនត្រយាត៑ បរំ កៃសរិយាតោ យិរូឝាលម្នគរម៑ អាគមត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","តទា មហាយាជកោ យិហូទីយានាំ ប្រធានលោកាឝ្ច តស្យ សមក្ឞំ បៅលម៑ អបាវទន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ភវាន៑ តំ យិរូឝាលមម៑ អានេតុម៑ អាជ្ញាបយត្វិតិ វិនីយ តេ តស្មាទ៑ អនុគ្រហំ វាញ្ឆិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","យតះ បថិមធ្យេ គោបនេន បៅលំ ហន្តុំ តៃ រ្ឃាតកា និយុក្តាះ។ ផីឞ្ដ ឧត្តរំ ទត្តវាន៑ បៅលះ កៃសរិយាយាំ ស្ថាស្យតិ បុនរល្បទិនាត៑ បរម៑ អហំ តត្រ យាស្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","តតស្តស្យ មានុឞស្យ យទិ កឝ្ចិទ៑ អបរាធស្តិឞ្ឋតិ តហ៌ិ យុឞ្មាកំ យេ ឝក្នុវន្តិ តេ មយា សហ តត្រ គត្វា តមបវទន្តុ ស ឯតាំ កថាំ កថិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","ទឝទិវសេភ្យោៜធិកំ វិលម្ព្យ ផីឞ្ដស្តស្មាត៑ កៃសរិយានគរំ គត្វា បរស្មិន៑ ទិវសេ វិចារាសន ឧបទិឝ្យ បៅលម៑ អានេតុម៑ អាជ្ញាបយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","បៅលេ សមុបស្ថិតេ សតិ យិរូឝាលម្នគរាទ៑ អាគតា យិហូទីយលោកាស្តំ ចតុទ៌ិឝិ សំវេឞ្ដ្យ តស្យ វិរុទ្ធំ ពហូន៑ មហាទោឞាន៑ ឧត្ថាបិតវន្តះ កិន្តុ តេឞាំ កិមបិ ប្រមាណំ ទាតុំ ន ឝក្នុវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","តតះ បៅលះ ស្វស្មិន៑ ឧត្តរមិទម៑ ឧទិតវាន៑, យិហូទីយានាំ វ្យវស្ថាយា មន្ទិរស្យ កៃសរស្យ វា ប្រតិកូលំ កិមបិ កម៌្ម នាហំ ក្ឫតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","កិន្តុ ផីឞ្ដោ យិហូទីយាន៑ សន្តុឞ្ដាន៑ កត៌្តុម៑ អភិលឞន៑ បៅលម៑ អភាឞត ត្វំ កិំ យិរូឝាលមំ គត្វាស្មិន៑ អភិយោគេ មម សាក្ឞាទ៑ វិចារិតោ ភវិឞ្យសិ? ");
INSERT INTO sankhm_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","តតះ បៅល ឧត្តរំ ប្រោក្តវាន៑, យត្រ មម វិចារោ ភវិតុំ យោគ្យះ កៃសរស្យ តត្រ វិចារាសន ឯវ សមុបស្ថិតោស្មិ; អហំ យិហូទីយានាំ កាមបិ ហានិំ នាកាឞ៌ម៑ ឥតិ ភវាន៑ យថាត៌្ហតោ វិជានាតិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","កញ្ចិទបរាធំ កិញ្ចន វធាហ៌ំ កម៌្ម វា យទ្យហម៑ អករិឞ្យំ តហ៌ិ ប្រាណហននទណ្ឌមបិ ភោក្តុម៑ ឧទ្យតោៜភវិឞ្យំ, កិន្តុ តេ មម សមបវាទំ កុវ៌្វន្តិ ស យទិ កល្បិតមាត្រោ ភវតិ តហ៌ិ តេឞាំ ករេឞុ មាំ សមប៌យិតុំ កស្យាប្យធិការោ នាស្តិ, កៃសរស្យ និកដេ មម វិចារោ ភវតុ។ ");
INSERT INTO sankhm_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","តទា ផីឞ្ដោ មន្ត្រិភិះ សាទ៌្ធំ សំមន្ត្រ្យ បៅលាយ កថិតវាន៑, កៃសរស្យ និកដេ កិំ តវ វិចារោ ភវិឞ្យតិ? កៃសរស្យ សមីបំ គមិឞ្យសិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","កិយទ្ទិនេភ្យះ បរម៑ អាគ្រិប្បរាជា ពណ៌ីកី ច ផីឞ្ដំ សាក្ឞាត៑ កត៌្តុំ កៃសរិយានគរម៑ អាគតវន្តៅ។ ");
INSERT INTO sankhm_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","តទា តៅ ពហុទិនានិ តត្រ ស្ថិតៅ តតះ ផីឞ្ដស្តំ រាជានំ បៅលស្យ កថាំ វិជ្ញាប្យ កថយិតុម៑ អារភត បៅលនាមានម៑ ឯកំ ពន្ទិ ផីលិក្ឞោ ពទ្ធំ សំស្ថាប្យ គតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","យិរូឝាលមិ មម ស្ថិតិកាលេ មហាយាជកោ យិហូទីយានាំ ប្រាចីនលោកាឝ្ច តម៑ អបោទ្យ តម្ប្រតិ ទណ្ឌាជ្ញាំ ប្រាត៌្ហយន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","តតោហម៑ ឥត្យុត្តរម៑ អវទំ យាវទ៑ អបោទិតោ ជនះ ស្វាបវាទកាន៑ សាក្ឞាត៑ ក្ឫត្វា ស្វស្មិន៑ យោៜបរាធ អារោបិតស្តស្យ ប្រត្យុត្តរំ ទាតុំ សុយោគំ ន ប្រាប្នោតិ, តាវត្កាលំ កស្យាបិ មានុឞស្យ ប្រាណនាឝាជ្ញាបនំ រោមិលោកានាំ រីតិ រ្នហិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","តតស្តេឞ្វត្រាគតេឞុ បរស្មិន៑ ទិវសេៜហម៑ អវិលម្ពំ វិចារាសន ឧបវិឝ្យ តំ មានុឞម៑ អានេតុម៑ អាជ្ញាបយម៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","តទនន្តរំ តស្យាបវាទកា ឧបស្ថាយ យាទ្ឫឝម៑ អហំ ចិន្តិតវាន៑ តាទ្ឫឝំ កញ្ចន មហាបវាទំ នោត្ថាប្យ ");
INSERT INTO sankhm_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","ស្វេឞាំ មតេ តថា បៅលោ យំ សជីវំ វទតិ តស្មិន៑ យីឝុនាមនិ ម្ឫតជនេ ច តស្យ វិរុទ្ធំ កថិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","តតោហំ តាទ្ឫគ្វិចារេ សំឝយានះ សន៑ កថិតវាន៑ ត្វំ យិរូឝាលមំ គត្វា កិំ តត្រ វិចារិតោ ភវិតុម៑ ឥច្ឆសិ? ");
INSERT INTO sankhm_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","តទា បៅលោ មហារាជស្យ និកដេ វិចារិតោ ភវិតុំ ប្រាត៌្ហយត, តស្មាទ៑ យាវត្កាលំ តំ កៃសរស្យ សមីបំ ប្រេឞយិតុំ ន ឝក្នោមិ តាវត្កាលំ តមត្រ ស្ថាបយិតុម៑ អាទិឞ្ដវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","តត អាគ្រិប្បះ ផីឞ្ដម៑ ឧក្តវាន៑, អហមបិ តស្យ មានុឞស្យ កថាំ ឝ្រោតុម៑ អភិលឞាមិ។ តទា ផីឞ្ដោ វ្យាហរត៑ ឝ្វស្តទីយាំ កថាំ ត្វំ ឝ្រោឞ្យសិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","បរស្មិន៑ ទិវសេ អាគ្រិប្បោ ពណ៌ីកី ច មហាសមាគមំ ក្ឫត្វា ប្រធានវាហិនីបតិភិ រ្នគរស្ថប្រធានលោកៃឝ្ច សហ មិលិត្វា រាជគ្ឫហមាគត្យ សមុបស្ថិតៅ តទា ផីឞ្ដស្យាជ្ញយា បៅល អានីតោៜភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","តទា ផីឞ្ដះ កថិតវាន៑ ហេ រាជន៑ អាគ្រិប្ប ហេ ឧបស្ថិតាះ សវ៌្វេ លោកា យិរូឝាលម្នគរេ យិហូទីយលោកសមូហោ យស្មិន៑ មានុឞេ មម សមីបេ និវេទនំ ក្ឫត្វា ប្រោច្ចៃះ កថាមិមាំ កថិតវាន៑ បុនរល្បកាលមបិ តស្យ ជីវនំ នោចិតំ តមេតំ មានុឞំ បឝ្យត។ ");
INSERT INTO sankhm_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","កិន្ត្វេឞ ជនះ ប្រាណនាឝហ៌ំ កិមបិ កម៌្ម ន ក្ឫតវាន៑ ឥត្យជានាំ តថាបិ ស មហារាជស្យ សន្និធៅ វិចារិតោ ភវិតុំ ប្រាត៌្ហយត តស្មាត៑ តស្យ សមីបំ តំ ប្រេឞយិតុំ មតិមករវម៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","កិន្តុ ឝ្រីយុក្តស្យ សមីបម៑ ឯតស្មិន៑ កិំ លេខនីយម៑ ឥត្យស្យ កស្យចិន៑ និណ៌យស្យ ន ជាតត្វាទ៑ ឯតស្យ វិចារេ សតិ យថាហំ លេខិតុំ កិញ្ចន និឝ្ចិតំ ប្រាប្នោមិ តទត៌្ហំ យុឞ្មាកំ សមក្ឞំ វិឝេឞតោ ហេ អាគ្រិប្បរាជ ភវតះ សមក្ឞម៑ ឯតម៑ អានយេ។ ");
INSERT INTO sankhm_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","យតោ ពន្ទិប្រេឞណសមយេ តស្យាភិយោគស្យ កិញ្ចិទលេខនម៑ អហម៑ អយុក្តំ ជានាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","តត អាគ្រិប្បះ បៅលម៑ អវាទីត៑, និជាំ កថាំ កថយិតុំ តុភ្យម៑ អនុមតិ រ្ទីយតេ។ តស្មាត៑ បៅលះ ករំ ប្រសាយ៌្យ ស្វស្មិន៑ ឧត្តរម៑ អវាទីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","ហេ អាគ្រិប្បរាជ យត្ការណាទហំ យិហូទីយៃរបវាទិតោ ៜភវំ តស្យ វ្ឫត្តាន្តម៑ អទ្យ ភវតះ សាក្ឞាន៑ និវេទយិតុមនុមតោហម៑ ឥទំ ស្វីយំ បរមំ ភាគ្យំ មន្យេ; ");
INSERT INTO sankhm_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","យតោ យិហូទីយលោកានាំ មធ្យេ យា យា រីតិះ សូក្ឞ្មវិចារាឝ្ច សន្តិ តេឞុ ភវាន៑ វិជ្ញតមះ; អតឯវ ប្រាត៌្ហយេ ធៃយ៌្យមវលម្ព្យ មម និវេទនំ ឝ្ឫណោតុ។ ");
INSERT INTO sankhm_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","អហំ យិរូឝាលម្នគរេ ស្វទេឝីយលោកានាំ មធ្យេ តិឞ្ឋន៑ អា យៅវនកាលាទ៑ យទ្រូបម៑ អាចរិតវាន៑ តទ៑ យិហូទីយលោកាះ សវ៌្វេ វិទន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","អស្មាកំ សវ៌្វេភ្យះ ឝុទ្ធតមំ យត៑ ផិរូឝីយមតំ តទវលម្ពី ភូត្វាហំ កាលំ យាបិតវាន៑ យេ ជនា អា ពាល្យកាលាន៑ មាំ ជានាន្តិ តេ ឯតាទ្ឫឝំ សាក្ឞ្យំ យទិ ទទាតិ តហ៌ិ ទាតុំ ឝក្នុវន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","កិន្តុ ហេ អាគ្រិប្បរាជ ឦឝ្វរោៜស្មាកំ បូវ៌្វបុរុឞាណាំ និកដេ យទ៑ អង្គីក្ឫតវាន៑ តស្យ ប្រត្យាឝាហេតោរហម៑ ឥទានីំ វិចារស្ថានេ ទណ្ឌាយមានោស្មិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","តស្យាង្គីការស្យ ផលំ ប្រាប្តុម៑ អស្មាកំ ទ្វាទឝវំឝា ទិវានិឝំ មហាយត្នាទ៑ ឦឝ្វរសេវនំ ក្ឫត្វា យាំ ប្រត្យាឝាំ កុវ៌្វន្តិ តស្យាះ ប្រត្យាឝាយា ហេតោរហំ យិហូទីយៃរបវាទិតោៜភវម៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","ឦឝ្វរោ ម្ឫតាន៑ ឧត្ថាបយិឞ្យតីតិ វាក្យំ យុឞ្មាកំ និកដេៜសម្ភវំ កុតោ ភវេត៑? ");
INSERT INTO sankhm_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","នាសរតីយយីឝោ រ្នាម្នោ វិរុទ្ធំ នានាប្រការប្រតិកូលាចរណម៑ ឧចិតម៑ ឥត្យហំ មនសិ យថាត៌្ហំ វិជ្ញាយ ");
INSERT INTO sankhm_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","យិរូឝាលមនគរេ តទករវំ ផលតះ ប្រធានយាជកស្យ និកដាត៑ ក្ឞមតាំ ប្រាប្យ ពហូន៑ បវិត្រលោកាន៑ ការាយាំ ពទ្ធវាន៑ វិឝេឞតស្តេឞាំ ហននសមយេ តេឞាំ វិរុទ្ធាំ និជាំ សម្មតិំ ប្រកាឝិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","វារំ វារំ ភជនភវនេឞុ តេភ្យោ ទណ្ឌំ ប្រទត្តវាន៑ ពលាត៑ តំ ធម៌្មំ និន្ទយិតវាំឝ្ច បុនឝ្ច តាន៑ ប្រតិ មហាក្រោធាទ៑ ឧន្មត្តះ សន៑ វិទេឝីយនគរាណិ យាវត៑ តាន៑ តាឌិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","ឥត្ថំ ប្រធានយាជកស្យ សមីបាត៑ ឝក្តិម៑ អាជ្ញាបត្រញ្ច លព្ធ្វា ទម្មេឞក្នគរំ គតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","តទាហំ ហេ រាជន៑ មាគ៌មធ្យេ មធ្យាហ្នកាលេ មម មទីយសង្គិនាំ លោកានាញ្ច ចតស្ឫឞុ ទិក្ឞុ គគណាត៑ ប្រកាឝមានាំ ភាស្ករតោបិ តេជស្វតីំ ទីប្តិំ ទ្ឫឞ្ដវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","តស្មាទ៑ អស្មាសុ សវ៌្វេឞុ ភូមៅ បតិតេឞុ សត្សុ ហេ ឝៅល ហៃ ឝៅល កុតោ មាំ តាឌយសិ? កណ្ដកានាំ មុខេ បាទាហននំ តវ ទុះសាធ្យម៑ ឥព្រីយភាឞយា គទិត ឯតាទ្ឫឝ ឯកះ ឝព្ទោ មយា ឝ្រុតះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","តទាហំ ប្ឫឞ្ដវាន៑ ហេ ប្រភោ កោ ភវាន៑? តតះ ស កថិតវាន៑ យំ យីឝុំ ត្វំ តាឌយសិ សោហំ, ");
INSERT INTO sankhm_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","កិន្តុ សមុត្តិឞ្ឋ ត្វំ យទ៑ ទ្ឫឞ្ដវាន៑ ឥតះ បុនញ្ច យទ្យត៑ ត្វាំ ទឝ៌យិឞ្យាមិ តេឞាំ សវ៌្វេឞាំ កាយ៌្យាណាំ ត្វាំ សាក្ឞិណំ មម សេវកញ្ច កត៌្តុម៑ ទឝ៌នម៑ អទាម៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","វិឝេឞតោ យិហូទីយលោកេភ្យោ ភិន្នជាតីយេភ្យឝ្ច ត្វាំ មនោនីតំ ក្ឫត្វា តេឞាំ យថា បាបមោចនំ ភវតិ ");
INSERT INTO sankhm_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","យថា តេ មយិ វិឝ្វស្យ បវិត្រីក្ឫតានាំ មធ្យេ ភាគំ ប្រាប្នុវន្តិ តទភិប្រាយេណ តេឞាំ ជ្ញានចក្ឞូំឞិ ប្រសន្នានិ កត៌្តុំ តថាន្ធការាទ៑ ទីប្តិំ ប្រតិ ឝៃតានាធិការាច្ច ឦឝ្វរំ ប្រតិ មតីះ បរាវត៌្តយិតុំ តេឞាំ សមីបំ ត្វាំ ប្រេឞ្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","ហេ អាគ្រិប្បរាជ ឯតាទ្ឫឝំ ស្វគ៌ីយប្រត្យាទេឝំ អគ្រាហ្យម៑ អក្ឫត្វាហំ ");
INSERT INTO sankhm_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","ប្រថមតោ ទម្មេឞក្នគរេ តតោ យិរូឝាលមិ សវ៌្វស្មិន៑ យិហូទីយទេឝេ អន្យេឞុ ទេឝេឞុ ច យេेន លោកា មតិំ បរាវត៌្ត្យ ឦឝ្វរំ ប្រតិ បរាវត៌្តយន្តេ, មនះបរាវត៌្តនយោគ្យានិ កម៌្មាណិ ច កុវ៌្វន្តិ តាទ្ឫឝម៑ ឧបទេឝំ ប្រចារិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","ឯតត្ការណាទ៑ យិហូទីយា មធ្យេមន្ទិរំ មាំ ធ្ឫត្វា ហន្តុម៑ ឧទ្យតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","តថាបិ ខ្រីឞ្ដោ ទុះខំ ភុក្ត្វា សវ៌្វេឞាំ បូវ៌្វំ ឝ្មឝានាទ៑ ឧត្ថាយ និជទេឝីយានាំ ភិន្នទេឝីយានាញ្ច សមីបេ ទីប្តិំ ប្រកាឝយិឞ្យតិ ");
INSERT INTO sankhm_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","ភវិឞ្យទ្វាទិគណោ មូសាឝ្ច ភាវិកាយ៌្យស្យ យទិទំ ប្រមាណម៑ អទទុរេតទ៑ វិនាន្យាំ កថាំ ន កថយិត្វា ឦឝ្វរាទ៑ អនុគ្រហំ លព្ធ្វា មហតាំ ក្ឞុទ្រាណាញ្ច សវ៌្វេឞាំ សមីបេ ប្រមាណំ ទត្ត្វាទ្យ យាវត៑ តិឞ្ឋាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","តស្យមាំ កថាំ និឝម្យ ផីឞ្ដ ឧច្ចៃះ ស្វរេណ កថិតវាន៑ ហេ បៅល ត្វម៑ ឧន្មត្តោសិ ពហុវិទ្យាភ្យាសេន ត្វំ ហតជ្ញានោ ជាតះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","ស ឧក្តវាន៑ ហេ មហាមហិម ផីឞ្ដ នាហម៑ ឧន្មត្តះ កិន្តុ សត្យំ វិវេចនីយញ្ច វាក្យំ ប្រស្តៅមិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","យស្យ សាក្ឞាទ៑ អក្ឞោភះ សន៑ កថាំ កថយាមិ ស រាជា តទ្វ្ឫត្តាន្តំ ជានាតិ តស្យ សមីបេ កិមបិ គុប្តំ នេតិ មយា និឝ្ចិតំ ពុធ្យតេ យតស្តទ៑ វិជនេ ន ក្ឫតំ។ ");
INSERT INTO sankhm_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","ហេ អាគ្រិប្បរាជ ភវាន៑ កិំ ភវិឞ្យទ្វាទិគណោក្តានិ វាក្យានិ ប្រត្យេតិ? ភវាន៑ ប្រត្យេតិ តទហំ ជានាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","តត អាគ្រិប្បះ បៅលម៑ អភិហិតវាន៑ ត្វំ ប្រវ្ឫត្តិំ ជនយិត្វា ប្រាយេណ មាមបិ ខ្រីឞ្ដីយំ ករោឞិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","តតះ សោៜវាទីត៑ ភវាន៑ យេ យេ លោកាឝ្ច មម កថាម៑ អទ្យ ឝ្ឫណ្វន្តិ ប្រាយេណ ឥតិ នហិ កិន្ត្វេតត៑ ឝ្ឫង្ខលពន្ធនំ វិនា សវ៌្វថា តេ សវ៌្វេ មាទ្ឫឝា ភវន្ត្វិតីឝ្វស្យ សមីបេ ប្រាត៌្ហយេៜហម៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","ឯតស្យាំ កថាយាំ កថិតាយាំ ស រាជា សោៜធិបតិ រ្ពណ៌ីកី សភាស្ថា លោកាឝ្ច តស្មាទ៑ ឧត្ថាយ ");
INSERT INTO sankhm_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","គោបនេ បរស្បរំ វិវិច្យ កថិតវន្ត ឯឞ ជនោ ពន្ធនាហ៌ំ ប្រាណហននាហ៌ំ វា កិមបិ កម៌្ម នាករោត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","តត អាគ្រិប្បះ ផីឞ្ដម៑ អវទត៑, យទ្យេឞ មានុឞះ កៃសរស្យ និកដេ វិចារិតោ ភវិតុំ ន ប្រាត៌្ហយិឞ្យត៑ តហ៌ិ មុក្តោ ភវិតុម៑ អឝក្ឞ្យត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","ជលបថេនាស្មាកម៑ ឥតោលិយាទេឝំ ប្រតិ យាត្រាយាំ និឝ្ចិតាយាំ សត្យាំ តេ យូលិយនាម្នោ មហារាជស្យ សំឃាតាន្តគ៌តស្យ សេនាបតេះ សមីបេ បៅលំ តទន្យាន៑ កតិនយជនាំឝ្ច សមាប៌យន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","វយម៑ អាទ្រាមុត្តីយំ បោតមេកម៑ អារុហ្យ អាឝិយាទេឝស្យ តដសមីបេន យាតុំ មតិំ ក្ឫត្វា លង្គរម៑ ឧត្ថាប្យ បោតម៑ អមោចយាម; មាកិទនិយាទេឝស្ថថិឞលនីកីនិវាស្យារិស្តាក៌្ហនាមា កឝ្ចិទ៑ ជនោៜស្មាភិះ សាទ៌្ធម៑ អាសីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","បរស្មិន៑ ទិវសេ ៜស្មាភិះ សីទោន្នគរេ បោតេ លាគិតេ តត្រ យូលិយះ សេនាបតិះ បៅលំ ប្រតិ សៅជន្យំ ប្រទត៌្ហ្យ សាន្ត្វនាត៌្ហំ ពន្ធុពាន្ធវាន៑ ឧបយាតុម៑ អនុជជ្ញៅ។ ");
INSERT INTO sankhm_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","តស្មាត៑ បោតេ មោចិតេ សតិ សម្មុខវាយោះ សម្ភវាទ៑ វយំ កុប្រោបទ្វីបស្យ តីរសមីបេន គតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","កិលិកិយាយាះ បាម្ផូលិយាយាឝ្ច សមុទ្រស្យ បារំ គត្វា លូកិយាទេឝាន្តគ៌តំ មុរានគរម៑ ឧបាតិឞ្ឋាម។ ");
INSERT INTO sankhm_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","តត្ស្ថានាទ៑ ឥតាលិយាទេឝំ គច្ឆតិ យះ សិកន្ទរិយានគរស្យ បោតស្តំ តត្រ ប្រាប្យ ឝតសេនាបតិស្តំ បោតម៑ អស្មាន៑ អារោហយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","តតះ បរំ ពហូនិ ទិនានិ ឝនៃះ ឝនៃះ រ្គត្វា ក្នីទបាឝ៌្វោបស្ថ្តិेះ បូវ៌្វំ ប្រតិកូលេន បវនេន វយំ សល្មោន្យាះ សម្មុខម៑ ឧបស្ថាយ ក្រីត្យុបទ្វីបស្យ តីរសមីបេន គតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","កឞ្ដេន តមុត្តីយ៌្យ លាសេយានគរស្យាធះ សុន្ទរនាមកំ ខាតម៑ ឧបាតិឞ្ឋាម។ ");
INSERT INTO sankhm_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","ឥត្ថំ ពហុតិថះ កាលោ យាបិត ឧបវាសទិនញ្ចាតីតំ, តត្ការណាត៑ នៅវត៌្មនិ ភយង្ករេ សតិ បៅលោ វិនយេន កថិតវាន៑, ");
INSERT INTO sankhm_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","ហេ មហេច្ឆា អហំ និឝ្ចយំ ជានាមិ យាត្រាយាមស្យាម៑ អស្មាកំ ក្លេឝា ពហូនាមបចយាឝ្ច ភវិឞ្យន្តិ, តេ កេវលំ បោតសាមគ្រ្យោរិតិ នហិ, កិន្ត្វស្មាកំ ប្រាណានាមបិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","តទា ឝតសេនាបតិះ បៅैेលោក្តវាក្យតោបិ កណ៌ធារស្យ បោតវណិជឝ្ច វាក្យំ ពហុមំស្ត។ ");
INSERT INTO sankhm_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","តត៑ ខាតំ ឝីតកាលេ វាសាហ៌ស្ថានំ ន តស្មាទ៑ អវាចីប្រតីចោទ៌ិឝោះ ក្រីត្យាះ ផៃនីកិយខាតំ យាតុំ យទិ ឝក្នុវន្តស្តហ៌ិ តត្រ ឝីតកាលំ យាបយិតុំ ប្រាយេណ សវ៌្វេ មន្ត្រយាមាសុះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","តតះ បរំ ទក្ឞិណវាយុ រ្មន្ទំ វហតីតិ វិលោក្យ និជាភិប្រាយស្យ សិទ្ធេះ សុយោគោ ភវតីតិ ពុទ្ធ្វា បោតំ មោចយិត្វា ក្រីត្យុបទ្វីបស្យ តីរសមីបេន ចលិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","កិន្ត្វល្បក្ឞណាត៑ បរមេវ ឧរក្លុទោន្នាមា ប្រតិកូលះ ប្រចណ្ឌោ វាយុ រ្វហន៑ បោតេៜលគីត្ ");
INSERT INTO sankhm_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","តស្យាភិមុខំ គន្តុម៑ បោតស្យាឝក្តត្វាទ៑ វយំ វាយុនា ស្វយំ នីតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","អនន្តរំ ក្លៅទីនាម្ន ឧបទ្វីបស្យ កូលសមីបេន បោតំ គមយិត្វា ពហុនា កឞ្ដេន ក្ឞុទ្រនាវម៑ អរក្ឞាម។ ");
INSERT INTO sankhm_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","តេ តាមារុហ្យ រជ្ជ្ចា បោតស្យាធោភាគម៑ អពធ្នន៑ តទនន្តរំ ចេត៑ បោតោ សៃកតេ លគតីតិ ភយាទ៑ វាតវសនាន្យមោចយន៑ តតះ បោតោ វាយុនា ចាលិតះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","កិន្តុ ក្រមឝោ វាយោះ ប្រពលត្វាត៑ បោតោ ទោលាយមានោៜភវត៑ បរស្មិន៑ ទិវសេ បោតស្ថានិ កតិបយានិ ទ្រវ្យាណិ តោយេ និក្ឞិប្តានិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","ត្ឫតីយទិវសេ វយំ ស្វហស្តៃះ បោតសជ្ជនទ្រវ្យាណិ និក្ឞិប្តវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","តតោ ពហុទិនានិ យាវត៑ សូយ៌្យនក្ឞត្រាទីនិ សមាច្ឆន្នានិ តតោ ៜតីវ វាត្យាគមាទ៑ អស្មាកំ ប្រាណរក្ឞាយាះ កាបិ ប្រត្យាឝា នាតិឞ្ឋត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","ពហុទិនេឞុ លោកៃរនាហារេណ យាបិតេឞុ សវ៌្វេឞាំ សាក្ឞត៑ បៅលស្តិឞ្ឋន៑ អកថយត៑, ហេ មហេច្ឆាះ ក្រីត្យុបទ្វីបាត៑ បោតំ ន មោចយិតុម៑ អហំ បូវ៌្វំ យទ៑ អវទំ តទ្គ្រហណំ យុឞ្មាកម៑ ឧចិតម៑ អាសីត៑ តថា ក្ឫតេ យុឞ្មាកម៑ ឯឞា វិបទ៑ ឯឞោៜបចយឝ្ច នាឃដិឞ្យេតាម៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","កិន្តុ សាម្ប្រតំ យុឞ្មាន៑ វិនីយ ព្រវីម្យហំ, យូយំ ន ក្ឞុភ្យត យុឞ្មាកម៑ ឯកស្យាបិ ប្រាណិនោ ហានិ រ្ន ភវិឞ្យតិ, កេវលស្យ បោតស្យ ហានិ រ្ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","យតោ យស្យេឝ្វរស្យ លោកោៜហំ យញ្ចាហំ បរិចរាមិ តទីយ ឯកោ ទូតោ ហ្យោ រាត្រៅ មមាន្តិកេ តិឞ្ឋន៑ កថិតវាន៑, ");
INSERT INTO sankhm_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ហេ បៅល មា ភៃឞីះ កៃសរស្យ សម្មុខេ ត្វយោបស្ថាតវ្យំ; តវៃតាន៑ សង្គិនោ លោកាន៑ ឦឝ្វរស្តុភ្យំ ទត្តវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","អតឯវ ហេ មហេច្ឆា យូយំ ស្ថិរមនសោ ភវត មហ្យំ យា កថាកថិ សាវឝ្យំ ឃដិឞ្យតេ មមៃតាទ្ឫឝី វិឝ្វាស ឦឝ្វរេ វិទ្យតេ, ");
INSERT INTO sankhm_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","កិន្តុ កស្យចិទ៑ ឧបទ្វីបស្យោបរិ បតិតវ្យម៑ អស្មាភិះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","តតះ បរម៑ អាទ្រិយាសមុទ្រេ បោតស្តថៃវ ទោលាយមានះ សន៑ ឥតស្តតោ គច្ឆន៑ ចតុទ៌ឝទិវសស្យ រាត្រេ រ្ទ្វិតីយប្រហរសមយេ កស្យចិត៑ ស្ថលស្យ សមីបមុបតិឞ្ឋតីតិ បោតីយលោកា អន្វមន្យន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","តតស្តេ ជលំ បរិមាយ តត្រ វិំឝតិ រ្វ្យាមា ជលានីតិ ជ្ញាតវន្តះ។ កិញ្ចិទ្ទូរំ គត្វា បុនរបិ ជលំ បរិមិតវន្តះ។ តត្រ បញ្ចទឝ វ្យាមា ជលានិ ទ្ឫឞ្ដ្វា ");
INSERT INTO sankhm_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","ចេត៑ បាឞាណេ លគតីតិ ភយាត៑ បោតស្យ បឝ្ចាទ្ភាគតឝ្ចតុរោ លង្គរាន៑ និក្ឞិប្យ ទិវាករម៑ អបេក្ឞ្យ សវ៌្វេ ស្ថិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","កិន្តុ បោតីយលោកាះ បោតាគ្រភាគេ លង្គរនិក្ឞេបំ ឆលំ ក្ឫត្វា ជលធៅ ក្ឞុទ្រនាវម៑ អវរោហ្យ បលាយិតុម៑ អចេឞ្ដន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","តតះ បៅលះ សេនាបតយេ សៃន្យគណាយ ច កថិតវាន៑, ឯតេ យទិ បោតមធ្យេ ន តិឞ្ឋន្តិ តហ៌ិ យុឞ្មាកំ រក្ឞណំ ន ឝក្យំ។ ");
INSERT INTO sankhm_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","តទា សេនាគណោ រជ្ជូន៑ ឆិត្វា នាវំ ជលេ បតិតុម៑ អទទាត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","ប្រភាតសមយេ បៅលះ សវ៌្វាន៑ ជនាន៑ ភោជនាត៌្ហំ ប្រាត៌្ហ្យ វ្យាហរត៑, អទ្យ ចតុទ៌ឝទិនានិ យាវទ៑ យូយម៑ អបេក្ឞមានា អនាហារាះ កាលម៑ អយាបយត កិមបិ នាភុំគ្ធំ។ ");
INSERT INTO sankhm_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","អតោ វិនយេेៜហំ ភក្ឞ្យំ ភុជ្យតាំ តតោ យុឞ្មាកំ មង្គលំ ភវិឞ្យតិ, យុឞ្មាកំ កស្យចិជ្ជនស្យ ឝិរសះ កេឝៃកោបិ ន នំក្ឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","ឥតិ វ្យាហ្ឫត្យ បៅលំ បូបំ គ្ឫហីត្វេឝ្វរំ ធន្យំ ភាឞមាណស្តំ ភំក្ត្វា ភោក្តុម៑ អារព្ធវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","អនន្តរំ សវ៌្វេ ច សុស្ថិរាះ សន្តះ ខាទ្យានិ បប៌្យគ្ឫហ្លន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","អស្មាកំ បោតេ ឞដ្សប្តត្យធិកឝតទ្វយលោកា អាសន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","សវ៌្វេឞុ លោកេឞុ យថេឞ្ដំ ភុក្តវត្សុ បោតស្ថន៑ គោធូមាន៑ ជលធៅ និក្ឞិប្យ តៃះ បោតស្យ ភារោ លឃូក្ឫតះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","ទិនេ ជាតេៜបិ ស កោ ទេឝ ឥតិ តទា ន បយ៌្យចីយត; កិន្តុ តត្រ សមតដម៑ ឯកំ ខាតំ ទ្ឫឞ្ដ្វា យទិ ឝក្នុមស្តហ៌ិ វយំ តស្យាភ្យន្តរំ បោតំ គមយាម ឥតិ មតិំ ក្ឫត្វា តេ លង្គរាន៑ ឆិត្ត្វា ជលធៅ ត្យក្តវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","តថា កណ៌ពន្ធនំ មោចយិត្វា ប្រធានំ វាតវសនម៑ ឧត្តោល្យ តីរសមីបំ គតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","កិន្តុ ទ្វយោះ សមុទ្រយោះ សង្គមស្ថានេ សៃកតោបរិ បោតេ និក្ឞិប្តេ ៜគ្រភាគេ ពាធិតេ បឝ្ចាទ្ភាគេ ប្រពលតរង្គោៜលគត៑ តេន បោតោ ភគ្នះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","តស្មាទ៑ ពន្ទយឝ្ចេទ៑ ពាហុភិស្តរន្តះ បលាយន្តេ ឥត្យាឝង្កយា សេនាគណស្តាន៑ ហន្តុម៑ អមន្ត្រយត៑; ");
INSERT INTO sankhm_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","កិន្តុ ឝតសេនាបតិះ បៅលំ រក្ឞិតុំ ប្រយត្នំ ក្ឫត្វា តាន៑ តច្ចេឞ្ដាយា និវត៌្យ ឥត្យាទិឞ្ដវាន៑, យេ ពាហុតរណំ ជានន្តិ តេៜគ្រេ ប្រោល្លម្ប្យ សមុទ្រេ បតិត្វា ពាហុភិស្តីត៌្ត្វា កូលំ យាន្តុ។ ");
INSERT INTO sankhm_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","អបរម៑ អវឝិឞ្ដា ជនាះ កាឞ្ឋំ បោតីយំ ទ្រវ្យំ វា យេន យត៑ ប្រាប្យតេ តទវលម្ព្យ យាន្តុ; ឥត្ថំ សវ៌្វេ ភូមិំ ប្រាប្យ ប្រាណៃ រ្ជីវិតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","ឥត្ថំ សវ៌្វេឞុ រក្ឞាំ ប្រាប្តេឞុ តត្រត្យោបទ្វីបស្យ នាម មិលីតេតិ តេ ជ្ញាតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","អសភ្យលោកា យថេឞ្ដម៑ អនុកម្បាំ ក្ឫត្វា វត៌្តមានវ្ឫឞ្ដេះ ឝីតាច្ច វហ្និំ ប្រជ្ជ្វាល្យាស្មាកម៑ អាតិថ្យម៑ អកុវ៌្វន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","កិន្តុ បៅល ឥន្ធនានិ សំគ្ឫហ្យ យទា តស្មិន៑ អគ្រៅ និរក្ឞិបត៑, តទា វហ្នេះ ប្រតាបាត៑ ឯកះ ក្ឫឞ្ណសប៌ោ និគ៌ត្យ តស្យ ហស្តេ ទ្រឞ្ដវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","តេៜសភ្យលោកាស្តស្យ ហស្តេ សប៌ម៑ អវលម្ពមានំ ទ្ឫឞ្ដ្វា បរស្បរម៑ ឧក្តវន្ត ឯឞ ជនោៜវឝ្យំ នរហា ភវិឞ្យតិ, យតោ យទ្យបិ ជលធេ រក្ឞាំ ប្រាប្តវាន៑ តថាបិ ប្រតិផលទាយក ឯនំ ជីវិតុំ ន ទទាតិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","កិន្តុ ស ហស្តំ វិធុន្វន៑ តំ សប៌ម៑ អគ្និមធ្យេ និក្ឞិប្យ កាមបិ បីឌាំ នាប្តវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","តតោ វិឞជ្វាលយា ឯតស្យ ឝរីរំ ស្ផីតំ ភវិឞ្យតិ យទ្វា ហឋាទយំ ប្រាណាន៑ ត្យក្ឞ្យតីតិ និឝ្ចិត្យ លោកា ពហុក្ឞណានិ យាវត៑ តទ៑ ទ្រឞ្ដុំ ស្ថិតវន្តះ កិន្តុ តស្យ កស្យាឝ្ចិទ៑ វិបទោៜឃដនាត៑ តេ តទ្វិបរីតំ វិជ្ញាយ ភាឞិតវន្ត ឯឞ កឝ្ចិទ៑ ទេវោ ភវេត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","បុព្លិយនាមា ជន ឯកស្តស្យោបទ្វីបស្យាធិបតិរាសីត៑ តត្រ តស្យ ភូម្យាទិ ច ស្ថិតំ។ ស ជនោៜស្មាន៑ និជគ្ឫហំ នីត្វា សៅជន្យំ ប្រកាឝ្យ ទិនត្រយំ យាវទ៑ អស្មាកំ អាតិថ្យម៑ អករោត៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","តទា តស្យ បុព្លិយស្យ បិតា ជ្វរាតិសារេណ បីឌ្យមានះ សន៑ ឝយ្យាយាម៑ អាសីត៑; តតះ បៅលស្តស្យ សមីបំ គត្វា ប្រាត៌្ហនាំ ក្ឫត្វា តស្យ គាត្រេ ហស្តំ សមប៌្យ តំ ស្វស្ថំ ក្ឫតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","ឥត្ថំ ភូតេ តទ្វីបនិវាសិន ឥតរេបិ រោគិលោកា អាគត្យ និរាមយា អភវន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","តស្មាត្តេៜស្មាកម៑ អតីវ សត្ការំ ក្ឫតវន្តះ, វិឝេឞតះ ប្រស្ថានសមយេ ប្រយោជនីយានិ នានទ្រវ្យាណិ ទត្តវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","ឥត្ថំ តត្រ ត្រិឞុ មាសេឞុ គតេឞុ យស្យ ចិហ្នំ ទិយស្កូរី តាទ្ឫឝ ឯកះ សិកន្ទរីយនគរស្យ បោតះ ឝីតកាលំ យាបយន៑ តស្មិន៑ ឧបទ្វីបេ ៜតិឞ្ឋត៑ តមេវ បោតំ វយម៑ អារុហ្យ យាត្រាម៑ អកុម៌្ម។ ");
INSERT INTO sankhm_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","តតះ ប្រថមតះ សុរាកូសនគរម៑ ឧបស្ថាយ តត្រ ត្រីណិ ទិនានិ ស្ថិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","តស្មាទ៑ អាវ្ឫត្យ រីគិយនគរម៑ ឧបស្ថិតាះ ទិនៃកស្មាត៑ បរំ ទក្ឞិណវយៅ សានុកូល្យេ សតិ បរស្មិន៑ ទិវសេ បតិយលីនគរម៑ ឧបាតិឞ្ឋាម។ ");
INSERT INTO sankhm_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","តតោៜស្មាសុ តត្រត្យំ ភ្រាត្ឫគណំ ប្រាប្តេឞុ តេ ស្វៃះ សាទ៌្ធម៑ អស្មាន៑ សប្ត ទិនានិ ស្ថាបយិតុម៑ អយតន្ត, ឥត្ថំ វយំ រោមានគរម៑ ប្រត្យគច្ឆាម។ ");
INSERT INTO sankhm_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","តស្មាត៑ តត្រត្យាះ ភ្រាតរោៜស្មាកម៑ អាគមនវាត៌្តាំ ឝ្រុត្វា អាប្បិយផរំ ត្រិឞ្ដាវណ៌ីញ្ច យាវទ៑ អគ្រេសរាះ សន្តោស្មាន៑ សាក្ឞាត៑ កត៌្តុម៑ អាគមន៑; តេឞាំ ទឝ៌នាត៑ បៅល ឦឝ្វរំ ធន្យំ វទន៑ អាឝ្វាសម៑ អាប្តវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","អស្មាសុ រោមានគរំ គតេឞុ ឝតសេនាបតិះ សវ៌្វាន៑ ពន្ទីន៑ ប្រធានសេនាបតេះ សមីបេ សមាប៌យត៑ កិន្តុ បៅលាយ ស្វរក្ឞកបទាតិនា សហ ប្ឫថគ៑ វស្តុម៑ អនុមតិំ ទត្តវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","ទិនត្រយាត៑ បរំ បៅលស្តទ្ទេឝស្ថាន៑ ប្រធានយិហូទិន អាហូតវាន៑ តតស្តេឞុ សមុបស្ថិតេឞុ ស កថិតវាន៑, ហេ ភ្រាត្ឫគណ និជលោកានាំ បូវ៌្វបុរុឞាណាំ វា រីតេ រ្វិបរីតំ កិញ្ចន កម៌្មាហំ នាករវំ តថាបិ យិរូឝាលមនិវាសិនោ លោកា មាំ ពន្ទិំ ក្ឫត្វា រោមិលោកានាំ ហស្តេឞុ សមប៌ិតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","រោមិលោកា វិចាយ៌្យ មម ប្រាណហននាហ៌ំ កិមបិ ការណំ ន ប្រាប្យ មាំ មោចយិតុម៑ ឰច្ឆន៑; ");
INSERT INTO sankhm_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","កិន្តុ យិហូទិលោកានាម៑ អាបត្ត្យា មយា កៃសររាជស្យ សមីបេ វិចារស្យ ប្រាត៌្ហនា កត៌្តវ្យា ជាតា នោចេត៑ និជទេឝីយលោកាន៑ ប្រតិ មម កោប្យភិយោគោ នាស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","ឯតត្ការណាទ៑ អហំ យុឞ្មាន៑ ទ្រឞ្ដុំ សំលបិតុញ្ចាហូយម៑ ឥស្រាយេល្វឝីយានាំ ប្រត្យាឝាហេតោហម៑ ឯតេន ឝុង្ខលេន ពទ្ធោៜភវម៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","តទា តេ តម៑ អវាទិឞុះ, យិហូទីយទេឝាទ៑ វយំ ត្វាមធិ កិមបិ បត្រំ ន ប្រាប្តា យេ ភ្រាតរះ សមាយាតាស្តេឞាំ កោបិ តវ កាមបិ វាត៌្តាំ នាវទត៑ អភទ្រមបិ នាកថយច្ច។ ");
INSERT INTO sankhm_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","តវ មតំ កិមិតិ វយំ ត្វត្តះ ឝ្រោតុមិច្ឆាមះ។ យទ៑ ឥទំ នវីនំ មតមុត្ថិតំ តត៑ សវ៌្វត្រ សវ៌្វេឞាំ និកដេ និន្ទិតំ ជាតម ឥតិ វយំ ជានីមះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","តៃស្តទត៌្ហម៑ ឯកស្មិន៑ ទិនេ និរូបិតេ តស្មិន៑ ទិនេ ពហវ ឯកត្រ មិលិត្វា បៅលស្យ វាសគ្ឫហម៑ អាគច្ឆន៑ តស្មាត៑ បៅល អា ប្រាតះកាលាត៑ សន្ធ្យាកាលំ យាវន៑ មូសាវ្យវស្ថាគ្រន្ថាទ៑ ភវិឞ្យទ្វាទិនាំ គ្រន្ថេភ្យឝ្ច យីឝោះ កថាម៑ ឧត្ថាប្យ ឦឝ្វរស្យ រាជ្យេ ប្រមាណំ ទត្វា តេឞាំ ប្រវ្ឫត្តិំ ជនយិតុំ ចេឞ្ដិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","កេចិត្តុ តស្យ កថាំ ប្រត្យាយន៑ កេចិត្តុ ន ប្រត្យាយន៑; ");
INSERT INTO sankhm_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","ឯតត្ការណាត៑ តេឞាំ បរស្បរម៑ អនៃក្យាត៑ សវ៌្វេ ចលិតវន្តះ; តថាបិ បៅល ឯតាំ កថាមេកាំ កថិតវាន៑ បវិត្រ អាត្មា យិឝយិយស្យ ភវិឞ្យទ្វក្តុ រ្វទនាទ៑ អស្មាកំ បិត្ឫបុរុឞេភ្យ ឯតាំ កថាំ ភទ្រំ កថយាមាស, យថា, ");
INSERT INTO sankhm_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","\"ឧបគត្យ ជនានេតាន៑ ត្វំ ភាឞស្វ វចស្ត្វិទំ។ កណ៌ៃះ ឝ្រោឞ្យថ យូយំ ហិ កិន្តុ យូយំ ន ភោត្ស្យថ។ នេត្រៃ រ្ទ្រក្ឞ្យថ យូយញ្ច ជ្ញាតុំ យូយំ ន ឝក្ឞ្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","តេ មានុឞា យថា នេត្រៃះ បរិបឝ្យន្តិ នៃវ ហិ។ កណ៌ៃះ រ្យថា ន ឝ្ឫណ្វន្តិ ពុធ្យន្តេ ន ច មានសៃះ។ វ្យាវត៌្តយត្សុ ចិត្តានិ កាលេ កុត្រាបិ តេឞុ វៃ។ មត្តស្តេ មនុជាះ ស្វស្ថា យថា នៃវ ភវន្តិ ច។ តថា តេឞាំ មនុឞ្យាណាំ សន្តិ ស្ថូលា ហិ ពុទ្ធយះ។ ពធិរីភូតកណ៌ាឝ្ច ជាតាឝ្ច មុទ្រិតា ទ្ឫឝះ៕ ");
INSERT INTO sankhm_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","អត ឦឝ្វរាទ៑ យត៑ បរិត្រាណំ តស្យ វាត៌្តា ភិន្នទេឝីយានាំ សមីបំ ប្រេឞិតា តឯវ តាំ គ្រហីឞ្យន្តីតិ យូយំ ជានីត។ ");
INSERT INTO sankhm_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","ឯតាទ្ឫឝ្យាំ កថាយាំ កថិតាយាំ សត្យាំ យិហូទិនះ បរស្បរំ ពហុវិចារំ កុវ៌្វន្តោ គតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","ឥត្ថំ បៅលះ សម្បូណ៌ំ វត្សរទ្វយំ យាវទ៑ ភាដកីយេ វាសគ្ឫហេ វសន៑ យេ លោកាស្តស្យ សន្និធិម៑ អាគច្ឆន្តិ តាន៑ សវ៌្វានេវ បរិគ្ឫហ្លន៑, ");
INSERT INTO sankhm_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","និវ៌ិឃ្នម៑ អតិឝយនិះក្ឞោភម៑ ឦឝ្វរីយរាជត្វស្យ កថាំ ប្រចារយន៑ ប្រភៅ យីឝៅ ខ្រីឞ្ដេ កថាះ សមុបាទិឝត៑។ ឥតិ៕ ");
INSERT INTO sankhm_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","ឦឝ្វរោ និជបុត្រមធិ យំ សុសំវាទំ ភវិឞ្យទ្វាទិភិ រ្ធម៌្មគ្រន្ថេ ប្រតិឝ្រុតវាន៑ តំ សុសំវាទំ ប្រចារយិតុំ ប្ឫថក្ក្ឫត អាហូតះ ប្រេរិតឝ្ច ប្រភោ រ្យីឝុខ្រីឞ្ដស្យ សេវកោ យះ បៅលះ ");
INSERT INTO sankhm_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","ស រោមានគរស្ថាន៑ ឦឝ្វរប្រិយាន៑ អាហូតាំឝ្ច បវិត្រលោកាន៑ ប្រតិ បត្រំ លិខតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","អស្មាកំ ស ប្រភុ រ្យីឝុះ ខ្រីឞ្ដះ ឝារីរិកសម្ពន្ធេន ទាយូទោ វំឝោទ្ភវះ ");
INSERT INTO sankhm_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","បវិត្រស្យាត្មនះ សម្ពន្ធេន ចេឝ្វរស្យ ប្រភាវវាន៑ បុត្រ ឥតិ ឝ្មឝានាត៑ តស្យោត្ថានេន ប្រតិបន្នំ។ ");
INSERT INTO sankhm_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","អបរំ យេឞាំ មធ្យេ យីឝុនា ខ្រីឞ្ដេន យូយមប្យាហូតាស្តេ ៜន្យទេឝីយលោកាស្តស្យ នាម្និ វិឝ្វស្យ និទេឝគ្រាហិណោ យថា ភវន្តិ ");
INSERT INTO sankhm_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","តទភិប្រាយេណ វយំ តស្មាទ៑ អនុគ្រហំ ប្រេរិតត្វបទញ្ច ប្រាប្តាះ។ ");
INSERT INTO sankhm_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","តាតេនាស្មាកម៑ ឦឝ្វរេណ ប្រភុណា យីឝុខ្រីឞ្ដេន ច យុឞ្មភ្យម៑ អនុគ្រហះ ឝាន្តិឝ្ច ប្រទីយេតាំ។ ");
INSERT INTO sankhm_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","ប្រថមតះ សវ៌្វស្មិន៑ ជគតិ យុឞ្មាកំ វិឝ្វាសស្យ ប្រកាឝិតត្វាទ៑ អហំ យុឞ្មាកំ សវ៌្វេឞាំ និមិត្តំ យីឝុខ្រីឞ្ដស្យ នាម គ្ឫហ្លន៑ ឦឝ្វរស្យ ធន្យវាទំ ករោមិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","អបរម៑ ឦឝ្វរស្យ ប្រសាទាទ៑ ពហុកាលាត៑ បរំ សាម្ប្រតំ យុឞ្មាកំ សមីបំ យាតុំ កថមបិ យត៑ សុយោគំ ប្រាប្នោមិ, ឯតទត៌្ហំ និរន្តរំ នាមាន្យុច្ចារយន៑ និជាសុ សវ៌្វប្រាត៌្ហនាសុ សវ៌្វទា និវេទយាមិ, ");
INSERT INTO sankhm_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ឯតស្មិន៑ យមហំ តត្បុត្រីយសុសំវាទប្រចារណេន មនសា បរិចរាមិ ស ឦឝ្វរោ មម សាក្ឞី វិទ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","យតោ យុឞ្មាកំ មម ច វិឝ្វាសេន វយម៑ ឧភយេ យថា ឝាន្តិយុក្តា ភវាម ឥតិ ការណាទ្ ");
INSERT INTO sankhm_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","យុឞ្មាកំ ស្ថៃយ៌្យករណាត៌្ហំ យុឞ្មភ្យំ កិញ្ចិត្បរមាត៌្ហទានទានាយ យុឞ្មាន៑ សាក្ឞាត៑ កត៌្តុំ មទីយា វាញ្ឆា។ ");
INSERT INTO sankhm_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","ហេ ភ្រាត្ឫគណ ភិន្នទេឝីយលោកានាំ មធ្យេ យទ្វត៑ តទ្វទ៑ យុឞ្មាកំ មធ្យេបិ យថា ផលំ ភុញ្ជេ តទភិប្រាយេណ មុហុម៌ុហុ រ្យុឞ្មាកំ សមីបំ គន្តុម៑ ឧទ្យតោៜហំ កិន្តុ យាវទ៑ អទ្យ តស្មិន៑ គមនេ មម វិឃ្នោ ជាត ឥតិ យូយំ យទ៑ អជ្ញាតាស្តិឞ្ឋថ តទហម៑ ឧចិតំ ន ពុធ្យេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","អហំ សភ្យាសភ្យានាំ វិទ្វទវិទ្វតាញ្ច សវ៌្វេឞាម៑ ឫណី វិទ្យេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","អតឯវ រោមានិវាសិនាំ យុឞ្មាកំ សមីបេៜបិ យថាឝក្តិ សុសំវាទំ ប្រចារយិតុម៑ អហម៑ ឧទ្យតោស្មិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","យតះ ខ្រីឞ្ដស្យ សុសំវាទោ មម លជ្ជាស្បទំ នហិ ស ឦឝ្វរស្យ ឝក្តិស្វរូបះ សន៑ អា យិហូទីយេភ្យោ ៜន្យជាតីយាន៑ យាវត៑ សវ៌្វជាតីយានាំ មធ្យេ យះ កឝ្ចិទ៑ តត្រ វិឝ្វសិតិ តស្យៃវ ត្រាណំ ជនយតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","យតះ ប្រត្យយស្យ សមបរិមាណម៑ ឦឝ្វរទត្តំ បុណ្យំ តត្សុសំវាទេ ប្រកាឝតេ។ តទធិ ធម៌្មបុស្តកេបិ លិខិតមិទំ \"បុណ្យវាន៑ ជនោ វិឝ្វាសេន ជីវិឞ្យតិ\"។ ");
INSERT INTO sankhm_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","អតឯវ យេ មានវាះ បាបកម៌្មណា សត្យតាំ រុន្ធន្តិ តេឞាំ សវ៌្វស្យ ទុរាចរណស្យាធម៌្មស្យ ច វិរុទ្ធំ ស្វគ៌ាទ៑ ឦឝ្វរស្យ កោបះ ប្រកាឝតេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","យត ឦឝ្វរមធិ យទ្យទ៑ ជ្ញេយំ តទ៑ ឦឝ្វរះ ស្វយំ តាន៑ ប្រតិ ប្រកាឝិតវាន៑ តស្មាត៑ តេឞាម៑ អគោចរំ នហិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","ផលតស្តស្យានន្តឝក្តីឝ្វរត្វាទីន្យទ្ឫឝ្យាន្យបិ ស្ឫឞ្ដិកាលម៑ អារភ្យ កម៌្មសុ ប្រកាឝមានានិ ទ្ឫឝ្យន្តេ តស្មាត៑ តេឞាំ ទោឞប្រក្ឞាលនស្យ បន្ថា នាស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","អបរម៑ ឦឝ្វរំ ជ្ញាត្វាបិ តេ តម៑ ឦឝ្វរជ្ញានេន នាទ្រិយន្ត ក្ឫតជ្ញា វា ន ជាតាះ; តស្មាត៑ តេឞាំ សវ៌្វេ តក៌ា វិផលីភូតាះ, អបរញ្ច តេឞាំ វិវេកឝូន្យានិ មនាំសិ តិមិរេ មគ្នានិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","តេ ស្វាន៑ ជ្ញានិនោ ជ្ញាត្វា ជ្ញានហីនា អភវន្ ");
INSERT INTO sankhm_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","អនឝ្វរស្យេឝ្វរស្យ គៅរវំ វិហាយ នឝ្វរមនុឞ្យបឝុបក្ឞ្យុរោគាមិប្រភ្ឫតេរាក្ឫតិវិឝិឞ្ដប្រតិមាស្តៃរាឝ្រិតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","ឥត្ថំ ត ឦឝ្វរស្យ សត្យតាំ វិហាយ ម្ឫឞាមតម៑ អាឝ្រិតវន្តះ សច្ចិទានន្ទំ ស្ឫឞ្ដិកត៌្តារំ ត្យក្ត្វា ស្ឫឞ្ដវស្តុនះ បូជាំ សេវាញ្ច ក្ឫតវន្តះ; ");
INSERT INTO sankhm_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","ឥតិ ហេតោរីឝ្វរស្តាន៑ កុក្រិយាយាំ សមប៌្យ និជនិជកុចិន្តាភិលាឞាភ្យាំ ស្វំ ស្វំ ឝរីរំ បរស្បរម៑ អបមានិតំ កត៌្តុម៑ អទទាត៑។ ");
INSERT INTO sankhm_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","ឦឝ្វរេណ តេឞុ ក្វភិលាឞេ សមប៌ិតេឞុ តេឞាំ យោឞិតះ ស្វាភាវិកាចរណម៑ អបហាយ វិបរីតក្ឫត្យេ ប្រាវត៌្តន្ត; ");
INSERT INTO sankhm_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","តថា បុរុឞា អបិ ស្វាភាវិកយោឞិត្សង្គមំ វិហាយ បរស្បរំ កាមក្ឫឝានុនា ទគ្ធាះ សន្តះ បុមាំសះ បុំភិះ សាកំ កុក្ឫត្យេ សមាសជ្យ និជនិជភ្រាន្តេះ សមុចិតំ ផលម៑ អលភន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","តេ ស្វេឞាំ មនះស្វីឝ្វរាយ ស្ថានំ ទាតុម៑ អនិច្ឆុកាស្តតោ ហេតោរីឝ្វរស្តាន៑ ប្រតិ ទុឞ្ដមនស្កត្វម៑ អវិហិតក្រិយត្វញ្ច ទត្តវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","អតឯវ តេ សវ៌្វេ ៜន្យាយោ វ្យភិចារោ ទុឞ្ដត្វំ លោភោ ជិឃាំសា ឦឞ៌្យា វធោ វិវាទឝ្ចាតុរី កុមតិរិត្យាទិភិ រ្ទុឞ្កម៌្មភិះ បរិបូណ៌ាះ សន្តះ ");
INSERT INTO sankhm_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","កណ៌េជបា អបវាទិន ឦឝ្វរទ្វេឞកា ហិំសកា អហង្ការិណ អាត្មឝ្លាឃិនះ កុកម៌្មោត្បាទកាះ បិត្រោរាជ្ញាលង្ឃកា ");
INSERT INTO sankhm_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","អវិចារកា និយមលង្ឃិនះ ស្នេហរហិតា អតិទ្វេឞិណោ និទ៌យាឝ្ច ជាតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","យេ ជនា ឯតាទ្ឫឝំ កម៌្ម កុវ៌្វន្តិ តឯវ ម្ឫតិយោគ្យា ឦឝ្វរស្យ វិចារមីទ្ឫឝំ ជ្ញាត្វាបិ ត ឯតាទ្ឫឝំ កម៌្ម ស្វយំ កុវ៌្វន្តិ កេវលមិតិ នហិ កិន្តុ តាទ្ឫឝកម៌្មការិឞុ លោកេឞ្វបិ ប្រីយន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","ហេ បរទូឞក មនុឞ្យ យះ កឝ្ចន ត្វំ ភវសិ តវោត្តរទានាយ បន្ថា នាស្តិ យតោ យស្មាត៑ កម៌្មណះ បរស្ត្វយា ទូឞ្យតេ តស្មាត៑ ត្វមបិ ទូឞ្យសេ, យតស្តំ ទូឞយន្នបិ ត្វំ តទ្វទ៑ អាចរសិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","កិន្ត្វេតាទ្ឫគាចារិភ្យោ យំ ទណ្ឌម៑ ឦឝ្វរោ និឝ្ចិនោតិ ស យថាត៌្ហ ឥតិ វយំ ជានីមះ។ ");
INSERT INTO sankhm_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","អតឯវ ហេ មានុឞ ត្វំ យាទ្ឫគាចារិណោ ទូឞយសិ ស្វយំ យទិ តាទ្ឫគាចរសិ តហ៌ិ ត្វម៑ ឦឝ្វរទណ្ឌាត៑ បលាយិតុំ ឝក្ឞ្យសីតិ កិំ ពុធ្យសេ? ");
INSERT INTO sankhm_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","អបរំ តវ មនសះ បរិវត៌្តនំ កត៌្តុម៑ ឥឝ្វរស្យានុគ្រហោ ភវតិ តន្ន ពុទ្ធ្វា ត្វំ កិំ តទីយានុគ្រហក្ឞមាចិរសហិឞ្ណុត្វនិធិំ តុច្ឆីករោឞិ? ");
INSERT INTO sankhm_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","តថា ស្វាន្តះករណស្យ កឋោរត្វាត៑ ខេទរាហិត្យាច្ចេឝ្វរស្យ ន្យាយ្យវិចារប្រកាឝនស្យ ក្រោធស្យ ច ទិនំ យាវត៑ កិំ ស្វាត៌្ហំ កោបំ សញ្ចិនោឞិ? ");
INSERT INTO sankhm_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","កិន្តុ ស ឯកៃកមនុជាយ តត្កម៌្មានុសារេណ ប្រតិផលំ ទាស្យតិ; ");
INSERT INTO sankhm_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","វស្តុតស្តុ យេ ជនា ធៃយ៌្យំ ធ្ឫត្វា សត្កម៌្ម កុវ៌្វន្តោ មហិមា សត្ការោៜមរត្វញ្ចៃតានិ ម្ឫគយន្តេ តេភ្យោៜនន្តាយុ រ្ទាស្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","អបរំ យេ ជនាះ សត្យធម៌្មម៑ អគ្ឫហីត្វា វិបរីតធម៌្មម៑ គ្ឫហ្លន្តិ តាទ្ឫឝា វិរោធិជនាះ កោបំ ក្រោធញ្ច ភោក្ឞ្យន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","អា យិហូទិនោៜន្យទេឝិនះ បយ៌្យន្តំ យាវន្តះ កុកម៌្មការិណះ ប្រាណិនះ សន្តិ តេ សវ៌្វេ ទុះខំ យាតនាញ្ច គមិឞ្យន្តិ; ");
INSERT INTO sankhm_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","កិន្តុ អា យិហូទិនោ ភិន្នទេឝិបយ៌្យន្តា យាវន្តះ សត្កម៌្មការិណោ លោកាះ សន្តិ តាន៑ ប្រតិ មហិមា សត្ការះ ឝាន្តិឝ្ច ភវិឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","ឦឝ្វរស្យ វិចារេ បក្ឞបាតោ នាស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","អលព្ធវ្យវស្ថាឝាស្ត្រៃ រ្យៃះ បាបានិ ក្ឫតានិ វ្យវស្ថាឝាស្ត្រាលព្ធត្វានុរូបស្តេឞាំ វិនាឝោ ភវិឞ្យតិ; កិន្តុ លព្ធវ្យវស្ថាឝាស្ត្រា យេ បាបាន្យកុវ៌្វន៑ វ្យវស្ថានុសារាទេវ តេឞាំ វិចារោ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","វ្យវស្ថាឝ្រោតារ ឦឝ្វរស្យ សមីបេ និឞ្បាបា ភវិឞ្យន្តីតិ នហិ កិន្តុ វ្យវស្ថាចារិណ ឯវ សបុណ្យា ភវិឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","យតោ ៜលព្ធវ្យវស្ថាឝាស្ត្រា ភិន្នទេឝីយលោកា យទិ ស្វភាវតោ វ្យវស្ថានុរូបាន៑ អាចារាន៑ កុវ៌្វន្តិ តហ៌្យលព្ធឝាស្ត្រាះ សន្តោៜបិ តេ ស្វេឞាំ វ្យវស្ថាឝាស្ត្រមិវ ស្វយមេវ ភវន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","តេឞាំ មនសិ សាក្ឞិស្វរូបេ សតិ តេឞាំ វិតក៌េឞុ ច កទា តាន៑ ទោឞិណះ កទា វា និទ៌ោឞាន៑ ក្ឫតវត្សុ តេ ស្វាន្តល៌ិខិតស្យ វ្យវស្ថាឝាស្ត្រស្យ ប្រមាណំ ស្វយមេវ ទទតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","យស្មិន៑ ទិនេ មយា ប្រកាឝិតស្យ សុសំវាទស្យានុសារាទ៑ ឦឝ្វរោ យីឝុខ្រីឞ្ដេន មានុឞាណាម៑ អន្តះករណានាំ គូឍាភិប្រាយាន៑ ធ្ឫត្វា វិចារយិឞ្យតិ តស្មិន៑ វិចារទិនេ តត៑ ប្រកាឝិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","បឝ្យ ត្វំ ស្វយំ យិហូទីតិ វិខ្យាតោ វ្យវស្ថោបរិ វិឝ្វាសំ ករោឞិ, ");
INSERT INTO sankhm_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ឦឝ្វរមុទ្ទិឝ្យ ស្វំ ឝ្លាឃសេ, តថា វ្យវស្ថយា ឝិក្ឞិតោ ភូត្វា តស្យាភិមតំ ជានាសិ, សវ៌្វាសាំ កថានាំ សារំ វិវិំក្ឞេ, ");
INSERT INTO sankhm_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","អបរំ ជ្ញានស្យ សត្យតាយាឝ្ចាករស្វរូបំ ឝាស្ត្រំ មម សមីបេ វិទ្យត អតោ ៜន្ធលោកានាំ មាគ៌ទឝ៌យិតា ");
INSERT INTO sankhm_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","តិមិរស្ថិតលោកានាំ មធ្យេ ទីប្តិស្វរូបោៜជ្ញានលោកេភ្យោ ជ្ញានទាតា ឝិឝូនាំ ឝិក្ឞយិតាហមេវេតិ មន្យសេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","បរាន៑ ឝិក្ឞយន៑ ស្វយំ ស្វំ កិំ ន ឝិក្ឞយសិ? វស្តុតឝ្ចៅយ៌្យនិឞេធវ្យវស្ថាំ ប្រចារយន៑ ត្វំ កិំ ស្វយមេវ ចោរយសិ? ");
INSERT INTO sankhm_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","តថា បរទារគមនំ ប្រតិឞេធន៑ ស្វយំ កិំ បរទារាន៑ គច្ឆសិ? តថា ត្វំ ស្វយំ ប្រតិមាទ្វេឞី សន៑ កិំ មន្ទិរស្យ ទ្រវ្យាណិ ហរសិ? ");
INSERT INTO sankhm_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","យស្ត្វំ វ្យវស្ថាំ ឝ្លាឃសេ ស ត្វំ កិំ វ្យវស្ថាម៑ អវមត្យ នេឝ្វរំ សម្មន្យសេ? ");
INSERT INTO sankhm_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","ឝាស្ត្រេ យថា លិខតិ \"ភិន្នទេឝិនាំ សមីបេ យុឞ្មាកំ ទោឞាទ៑ ឦឝ្វរស្យ នាម្នោ និន្ទា ភវតិ។ \" ");
INSERT INTO sankhm_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","យទិ វ្យវស្ថាំ បាលយសិ តហ៌ិ តវ ត្វក្ឆេទក្រិយា សផលា ភវតិ; យតិ វ្យវស្ថាំ លង្ឃសេ តហ៌ិ តវ ត្វក្ឆេទោៜត្វក្ឆេទោ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","យតោ វ្យវស្ថាឝាស្ត្រាទិឞ្ដធម៌្មកម៌្មាចារី បុមាន៑ អត្វក្ឆេទី សន្នបិ កិំ ត្វក្ឆេទិនាំ មធ្យេ ន គណយិឞ្យតេ? ");
INSERT INTO sankhm_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","កិន្តុ លព្ធឝាស្ត្រឝ្ឆិន្នត្វក៑ ច ត្វំ យទិ វ្យវស្ថាលង្ឃនំ ករោឞិ តហ៌ិ វ្យវស្ថាបាលកាះ ស្វាភាវិកាច្ឆិន្នត្វចោ លោកាស្ត្វាំ កិំ ន ទូឞយិឞ្យន្តិ? ");
INSERT INTO sankhm_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","តស្មាទ៑ យោ ពាហ្យេ យិហូទី ស យិហូទី នហិ តថាង្គស្យ យស្ត្វក្ឆេទះ ស ត្វក្ឆេទោ នហិ; ");
INSERT INTO sankhm_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","កិន្តុ យោ ជន អាន្តរិកោ យិហូទី ស ឯវ យិហូទី អបរញ្ច កេវលលិខិតយា វ្យវស្ថយា ន កិន្តុ មានសិកោ យស្ត្វក្ឆេទោ យស្យ ច ប្រឝំសា មនុឞ្យេភ្យោ ន ភូត្វា ឦឝ្វរាទ៑ ភវតិ ស ឯវ ត្វក្ឆេទះ។ ");
INSERT INTO sankhm_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","អបរញ្ច យិហូទិនះ កិំ ឝ្រេឞ្ឋត្វំ? តថា ត្វក្ឆេទស្យ វា កិំ ផលំ? ");
INSERT INTO sankhm_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","សវ៌្វថា ពហូនិ ផលានិ សន្តិ, វិឝេឞត ឦឝ្វរស្យ ឝាស្ត្រំ តេភ្យោៜទីយត។ ");
INSERT INTO sankhm_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","កៃឝ្ចិទ៑ អវិឝ្វសនេ ក្ឫតេ តេឞាម៑ អវិឝ្វសនាត៑ កិម៑ ឦឝ្វរស្យ វិឝ្វាស្យតាយា ហានិរុត្បត្ស្យតេ? ");
INSERT INTO sankhm_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","កេនាបិ ប្រការេណ នហិ។ យទ្យបិ សវ៌្វេ មនុឞ្យា មិថ្យាវាទិនស្តថាបីឝ្វរះ សត្យវាទី។ ឝាស្ត្រេ យថា លិខិតមាស្តេ, អតស្ត្វន្តុ ស្វវាក្យេន និទ៌្ទោឞោ ហិ ភវិឞ្យសិ។ វិចារេ ចៃវ និឞ្បាបោ ភវិឞ្យសិ ន សំឝយះ។ ");
INSERT INTO sankhm_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","អស្មាកម៑ អន្យាយេន យទីឝ្វរស្យ ន្យាយះ ប្រកាឝតេ តហ៌ិ កិំ វទិឞ្យាមះ? អហំ មានុឞាណាំ កថាមិវ កថាំ កថយាមិ, ឦឝ្វរះ សមុចិតំ ទណ្ឌំ ទត្ត្វា កិម៑ អន្យាយី ភវិឞ្យតិ? ");
INSERT INTO sankhm_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","ឥត្ថំ ន ភវតុ, តថា សតីឝ្វរះ កថំ ជគតោ វិចារយិតា ភវិឞ្យតិ? ");
INSERT INTO sankhm_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","មម មិថ្យាវាក្យវទនាទ៑ យទីឝ្វរស្យ សត្យត្វេន តស្យ មហិមា វទ៌្ធតេ តហ៌ិ កស្មាទហំ វិចារេៜបរាធិត្វេន គណ្យោ ភវាមិ? ");
INSERT INTO sankhm_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","មង្គលាត៌្ហំ បាបមបិ ករណីយមិតិ វាក្យំ ត្វយា កុតោ នោច្យតេ? កិន្តុ យៃរុច្យតេ តេ និតាន្តំ ទណ្ឌស្យ បាត្រាណិ ភវន្តិ; តថាបិ តទ្វាក្យម៑ អស្មាភិរប្យុច្យត ឥត្យស្មាកំ គ្លានិំ កុវ៌្វន្តះ កិយន្តោ លោកា វទន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","អន្យលោកេភ្យោ វយំ កិំ ឝ្រេឞ្ឋាះ? កទាចន នហិ យតោ យិហូទិនោ ៜន្យទេឝិនឝ្ច សវ៌្វឯវ បាបស្យាយត្តា ឥត្យស្យ ប្រមាណំ វយំ បូវ៌្វម៑ អទទាម។ ");
INSERT INTO sankhm_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","លិបិ រ្យថាស្តេ, នៃកោបិ ធាម៌្មិកោ ជនះ។ ");
INSERT INTO sankhm_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","តថា ជ្ញានីឝ្វរជ្ញានី មានវះ កោបិ នាស្តិ ហិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","វិមាគ៌គាមិនះ សវ៌្វេ សវ៌្វេ ទុឞ្កម៌្មការិណះ។ ឯកោ ជនោបិ នោ តេឞាំ សាធុកម៌្ម ករោតិ ច។ ");
INSERT INTO sankhm_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","តថា តេឞាន្តុ វៃ កណ្ឋា អនាវ្ឫតឝ្មឝានវត៑។ ស្តុតិវាទំ ប្រកុវ៌្វន្តិ ជិហ្វាភិស្តេ តុ កេវលំ។ តេឞាមោឞ្ឋស្យ និម្នេ តុ វិឞំ តិឞ្ឋតិ សប៌្បវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","មុខំ តេឞាំ ហិ ឝាបេន កបដេន ច បូយ៌្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","រក្តបាតាយ តេឞាំ តុ បទានិ ក្ឞិប្រគានិ ច។ ");
INSERT INTO sankhm_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","បថិ តេឞាំ មនុឞ្យាណាំ នាឝះ ក្លេឝឝ្ច កេវលះ។ ");
INSERT INTO sankhm_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","តេ ជនា នហិ ជានន្តិ បន្ថានំ សុខទាយិនំ។ ");
INSERT INTO sankhm_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","បរមេឝាទ៑ ភយំ យត្តត៑ តច្ចក្ឞុឞោរគោចរំ។ ");
INSERT INTO sankhm_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","វ្យវស្ថាយាំ យទ្យល្លិខតិ តទ៑ វ្យវស្ថាធីនាន៑ លោកាន៑ ឧទ្ទិឝ្យ លិខតីតិ វយំ ជានីមះ។ តតោ មនុឞ្យមាត្រោ និរុត្តរះ សន៑ ឦឝ្វរស្យ សាក្ឞាទ៑ អបរាធី ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","អតឯវ វ្យវស្ថានុរូបៃះ កម៌្មភិះ កឝ្ចិទបិ ប្រាណីឝ្វរស្យ សាក្ឞាត៑ សបុណ្យីក្ឫតោ ភវិតុំ ន ឝក្ឞ្យតិ យតោ វ្យវស្ថយា បាបជ្ញានមាត្រំ ជាយតេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","កិន្តុ វ្យវស្ថាយាះ ប្ឫថគ៑ ឦឝ្វរេណ ទេយំ យត៑ បុណ្យំ តទ៑ វ្យវស្ថាយា ភវិឞ្យទ្វាទិគណស្យ ច វចនៃះ ប្រមាណីក្ឫតំ សទ៑ ឥទានីំ ប្រកាឝតេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","យីឝុខ្រីឞ្ដេ វិឝ្វាសករណាទ៑ ឦឝ្វរេណ ទត្តំ តត៑ បុណ្យំ សកលេឞុ ប្រកាឝិតំ សត៑ សវ៌្វាន៑ វិឝ្វាសិនះ ប្រតិ វត៌្តតេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","តេឞាំ កោបិ ប្រភេទោ នាស្តិ, យតះ សវ៌្វឯវ បាបិន ឦឝ្វរីយតេជោហីនាឝ្ច ជាតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","ត ឦឝ្វរស្យានុគ្រហាទ៑ មូល្យំ វិនា ខ្រីឞ្ដក្ឫតេន បរិត្រាណេន សបុណ្យីក្ឫតា ភវន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","យស្មាត៑ ស្វឝោណិតេន វិឝ្វាសាត៑ បាបនាឝកោ ពលី ភវិតុំ ស ឯវ បូវ៌្វម៑ ឦឝ្វរេណ និឝ្ចិតះ, ឥត្ថម៑ ឦឝ្វរីយសហិឞ្ណុត្វាត៑ បុរាក្ឫតបាបានាំ មាជ៌្ជនករណេ ស្វីយយាថាត៌្ហ្យំ តេន ប្រកាឝ្យតេ, ");
INSERT INTO sankhm_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","វត៌្តមានកាលីយមបិ ស្វយាថាត៌្ហ្យំ តេន ប្រកាឝ្យតេ, អបរំ យីឝៅ វិឝ្វាសិនំ សបុណ្យីកុវ៌្វន្នបិ ស យាថាត៌្ហិកស្តិឞ្ឋតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","តហ៌ិ កុត្រាត្មឝ្លាឃា? សា ទូរីក្ឫតា; កយា វ្យវស្ថយា? កិំ ក្រិយារូបវ្យវស្ថយា? ឥត្ថំ នហិ កិន្តុ តត៑ កេវលវិឝ្វាសរូបយា វ្យវស្ថយៃវ ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","អតឯវ វ្យវស្ថានុរូបាះ ក្រិយា វិនា កេវលេន វិឝ្វាសេន មានវះ សបុណ្យីក្ឫតោ ភវិតុំ ឝក្នោតីត្យស្យ រាទ្ធាន្តំ ទឝ៌យាមះ។ ");
INSERT INTO sankhm_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","ស កិំ កេវលយិហូទិនាម៑ ឦឝ្វរោ ភវតិ? ភិន្នទេឝិនាម៑ ឦឝ្វរោ ន ភវតិ? ភិន្នទេឝិនាមបិ ភវតិ; ");
INSERT INTO sankhm_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","យស្មាទ៑ ឯក ឦឝ្វរោ វិឝ្វាសាត៑ ត្វក្ឆេទិនោ វិឝ្វាសេនាត្វក្ឆេទិនឝ្ច សបុណ្យីករិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","តហ៌ិ វិឝ្វាសេន វយំ កិំ វ្យវស្ថាំ លុម្បាម? ឥត្ថំ ន ភវតុ វយំ វ្យវស្ថាំ សំស្ថាបយាម ឯវ។ ");
INSERT INTO sankhm_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","អស្មាកំ បូវ៌្វបុរុឞ ឥព្រាហីម៑ កាយិកក្រិយយា កិំ លព្ធវាន៑ ឯតទធិ កិំ វទិឞ្យាមះ? ");
INSERT INTO sankhm_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","ស យទិ និជក្រិយាភ្យះ សបុណ្យោ ភវេត៑ តហ៌ិ តស្យាត្មឝ្លាឃាំ កត៌្តុំ បន្ថា ភវេទិតិ សត្យំ, កិន្ត្វីឝ្វរស្យ សមីបេ នហិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","ឝាស្ត្រេ កិំ លិខតិ? ឥព្រាហីម៑ ឦឝ្វរេ វិឝ្វសនាត៑ ស វិឝ្វាសស្តស្មៃ បុណ្យាត៌្ហំ គណិតោ ពភូវ។ ");
INSERT INTO sankhm_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","កម៌្មការិណោ យទ៑ វេតនំ តទ៑ អនុគ្រហស្យ ផលំ នហិ កិន្តុ តេនោបាជ៌ិតំ មន្តវ្យម៑។ ");
INSERT INTO sankhm_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","កិន្តុ យះ បាបិនំ សបុណ្យីករោតិ តស្មិន៑ វិឝ្វាសិនះ កម៌្មហីនស្យ ជនស្យ យោ វិឝ្វាសះ ស បុណ្យាត៌្ហំ គណ្យោ ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","អបរំ យំ ក្រិយាហីនម៑ ឦឝ្វរះ សបុណ្យីករោតិ តស្យ ធន្យវាទំ ទាយូទ៑ វណ៌យាមាស, យថា, ");
INSERT INTO sankhm_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","ស ធន្យោៜឃានិ ម្ឫឞ្ដានិ យស្យាគាំស្យាវ្ឫតានិ ច។ ");
INSERT INTO sankhm_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","ស ច ធន្យះ បរេឝេន បាបំ យស្យ ន គណ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","ឯឞ ធន្យវាទស្ត្វក្ឆេទិនម៑ អត្វក្ឆេទិនំ វា កំ ប្រតិ ភវតិ? ឥព្រាហីមោ វិឝ្វាសះ បុណ្យាត៌្ហំ គណិត ឥតិ វយំ វទាមះ។ ");
INSERT INTO sankhm_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","ស វិឝ្វាសស្តស្យ ត្វក្ឆេទិត្វាវស្ថាយាំ កិម៑ អត្វក្ឆេទិត្វាវស្ថាយាំ កស្មិន៑ សមយេ បុណ្យមិវ គណិតះ? ត្វក្ឆេទិត្វាវស្ថាយាំ នហិ កិន្ត្វត្វក្ឆេទិត្វាវស្ថាយាំ។ ");
INSERT INTO sankhm_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","អបរញ្ច ស យត៑ សវ៌្វេឞាម៑ អត្វក្ឆេទិនាំ វិឝ្វាសិនាម៑ អាទិបុរុឞោ ភវេត៑, តេ ច បុណ្យវត្ត្វេន គណ្យេរន៑; ");
INSERT INTO sankhm_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","យេ ច លោកាះ កេវលំ ឆិន្នត្វចោ ន សន្តោ ៜស្មត្បូវ៌្វបុរុឞ ឥព្រាហីម៑ អឆិន្នត្វក៑ សន៑ យេន វិឝ្វាសមាគ៌េណ គតវាន៑ តេនៃវ តស្យ បាទចិហ្នេន គច្ឆន្តិ តេឞាំ ត្វក្ឆេទិនាមប្យាទិបុរុឞោ ភវេត៑ តទត៌្ហម៑ អត្វក្ឆេទិនោ មានវស្យ វិឝ្វាសាត៑ បុណ្យម៑ ឧត្បទ្យត ឥតិ ប្រមាណស្វរូបំ ត្វក្ឆេទចិហ្នំ ស ប្រាប្នោត៑។ ");
INSERT INTO sankhm_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","ឥព្រាហីម៑ ជគតោៜធិការី ភវិឞ្យតិ យៃឞា ប្រតិជ្ញា តំ តស្យ វំឝញ្ច ប្រតិ បូវ៌្វម៑ អក្រិយត សា វ្យវស្ថាមូលិកា នហិ កិន្តុ វិឝ្វាសជន្យបុណ្យមូលិកា។ ");
INSERT INTO sankhm_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","យតោ វ្យវស្ថាវលម្ពិនោ យទ្យធិការិណោ ភវន្តិ តហ៌ិ វិឝ្វាសោ វិផលោ ជាយតេ សា ប្រតិជ្ញាបិ លុប្តៃវ។ ");
INSERT INTO sankhm_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","អធិកន្តុ វ្យវស្ថា កោបំ ជនយតិ យតោ ៜវិទ្យមានាយាំ វ្យវស្ថាយាម៑ អាជ្ញាលង្ឃនំ ន សម្ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","អតឯវ សា ប្រតិជ្ញា យទ៑ អនុគ្រហស្យ ផលំ ភវេត៑ តទត៌្ហំ វិឝ្វាសមូលិកា យតស្តថាត្វេ តទ្វំឝសមុទាយំ ប្រតិ អត៌្ហតោ យេ វ្យវស្ថយា តទ្វំឝសម្ភវាះ កេវលំ តាន៑ ប្រតិ នហិ កិន្តុ យ ឥព្រាហីមីយវិឝ្វាសេន តត្សម្ភវាស្តានបិ ប្រតិ សា ប្រតិជ្ញា ស្ថាស្នុព៌្ហវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","យោ និជ៌ីវាន៑ សជីវាន៑ អវិទ្យមានានិ វស្តូនិ ច វិទ្យមានានិ ករោតិ ឥព្រាហីមោ វិឝ្វាសភូមេស្តស្យេឝ្វរស្យ សាក្ឞាត៑ សោៜស្មាកំ សវ៌្វេឞាម៑ អាទិបុរុឞ អាស្តេ, យថា លិខិតំ វិទ្យតេ, អហំ ត្វាំ ពហុជាតីនាម៑ អាទិបុរុឞំ ក្ឫត្វា និយុក្តវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","ត្វទីយស្តាទ្ឫឝោ វំឝោ ជនិឞ្យតេ យទិទំ វាក្យំ ប្រតិឝ្រុតំ តទនុសារាទ៑ ឥព្រាហីម៑ ពហុទេឝីយលោកានាម៑ អាទិបុរុឞោ យទ៑ ភវតិ តទត៌្ហំ សោៜនបេក្ឞិតវ្យមប្យបេក្ឞមាណោ វិឝ្វាសំ ក្ឫតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","អបរញ្ច ក្ឞីណវិឝ្វាសោ ន ភូត្វា ឝតវត្សរវយស្កត្វាត៑ ស្វឝរីរស្យ ជរាំ សារានាម្នះ ស្វភាយ៌្យាយា រជោនិវ្ឫត្តិញ្ច ត្ឫណាយ ន មេនេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","អបរម៑ អវិឝ្វាសាទ៑ ឦឝ្វរស្យ ប្រតិជ្ញាវចនេ កមបិ សំឝយំ ន ចការ; ");
INSERT INTO sankhm_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","កិន្ត្វីឝ្វរេណ យត៑ ប្រតិឝ្រុតំ តត៑ សាធយិតុំ ឝក្យត ឥតិ និឝ្ចិតំ វិជ្ញាយ ទ្ឫឍវិឝ្វាសះ សន៑ ឦឝ្វរស្យ មហិមានំ ប្រកាឝយាញ្ចការ។ ");
INSERT INTO sankhm_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","ឥតិ ហេតោស្តស្យ ស វិឝ្វាសស្តទីយបុណ្យមិវ គណយាញ្ចក្រេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","បុណ្យមិវាគណ្យត តត៑ កេវលស្យ តស្យ និមិត្តំ លិខិតំ នហិ, អស្មាកំ និមិត្តមបិ, ");
INSERT INTO sankhm_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","យតោៜស្មាកំ បាបនាឝាត៌្ហំ សមប៌ិតោៜស្មាកំ បុណ្យប្រាប្ត្យត៌្ហញ្ចោត្ថាបិតោៜភវត៑ យោៜស្មាកំ ប្រភុ រ្យីឝុស្តស្យោត្ថាបយិតរីឝ្វរេ ");
INSERT INTO sankhm_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","យទិ វយំ វិឝ្វសាមស្តហ៌្យស្មាកមបិ សឯវ វិឝ្វាសះ បុណ្យមិវ គណយិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","វិឝ្វាសេន សបុណ្យីក្ឫតា វយម៑ ឦឝ្វរេណ សាទ៌្ធំ ប្រភុណាស្មាកំ យីឝុខ្រីឞ្ដេន មេលនំ ប្រាប្តាះ។ ");
INSERT INTO sankhm_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","អបរំ វយំ យស្មិន៑ អនុគ្រហាឝ្រយេ តិឞ្ឋាមស្តន្មធ្យំ វិឝ្វាសមាគ៌េណ តេនៃវានីតា វយម៑ ឦឝ្វរីយវិភវប្រាប្តិប្រត្យាឝយា សមានន្ទាមះ។ ");
INSERT INTO sankhm_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","តត៑ កេវលំ នហិ កិន្តុ ក្លេឝភោគេៜប្យានន្ទាមោ យតះ ក្លេឝាाទ៑ ធៃយ៌្យំ ជាយត ឥតិ វយំ ជានីមះ, ");
INSERT INTO sankhm_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ធៃយ៌្យាច្ច បរីក្ឞិតត្វំ ជាយតេ, បរីក្ឞិតត្វាត៑ ប្រត្យាឝា ជាយតេ, ");
INSERT INTO sankhm_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","ប្រត្យាឝាតោ វ្រីឌិតត្វំ ន ជាយតេ, យស្មាទ៑ អស្មភ្យំ ទត្តេន បវិត្រេណាត្មនាស្មាកម៑ អន្តះករណានីឝ្វរស្យ ប្រេមវារិណា សិក្តានិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","អស្មាសុ និរុបាយេឞុ សត្សុ ខ្រីឞ្ដ ឧបយុក្តេ សមយេ បាបិនាំ និមិត្តំ ស្វីយាន៑ ប្រណាន៑ អត្យជត៑។ ");
INSERT INTO sankhm_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","ហិតការិណោ ជនស្យ ក្ឫតេ កោបិ ប្រណាន៑ ត្យក្តុំ សាហសំ កត៌្តុំ ឝក្នោតិ, កិន្តុ ធាម៌្មិកស្យ ក្ឫតេ ប្រាយេណ កោបិ ប្រាណាន៑ ន ត្យជតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","កិន្ត្វស្មាសុ បាបិឞុ សត្ស្វបិ និមិត្តមស្មាកំ ខ្រីឞ្ដះ ស្វប្រាណាន៑ ត្យក្តវាន៑, តត ឦឝ្វរោស្មាន៑ ប្រតិ និជំ បរមប្រេមាណំ ទឝ៌ិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","អតឯវ តស្យ រក្តបាតេន សបុណ្យីក្ឫតា វយំ និតាន្តំ តេន កោបាទ៑ ឧទ្ធារិឞ្យាមហេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","ផលតោ វយំ យទា រិបវ អាស្ម តទេឝ្វរស្យ បុត្រស្យ មរណេន តេន សាទ៌្ធំ យទ្យស្មាកំ មេលនំ ជាតំ តហ៌ិ មេលនប្រាប្តាះ សន្តោៜវឝ្យំ តស្យ ជីវនេន រក្ឞាំ លប្ស្យាមហេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","តត៑ កេវលំ នហិ កិន្តុ យេន មេលនម៑ អលភាមហិ តេនាស្មាកំ ប្រភុណា យីឝុខ្រីឞ្ដេន សាម្ប្រតម៑ ឦឝ្វរេ សមានន្ទាមឝ្ច។ ");
INSERT INTO sankhm_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","តថា សតិ, ឯកេន មានុឞេណ បាបំ បាបេន ច មរណំ ជគតីំ ប្រាវិឝត៑ អបរំ សវ៌្វេឞាំ បាបិត្វាត៑ សវ៌្វេ មានុឞា ម្ឫតេ រ្និឃ្នា អភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","យតោ វ្យវស្ថាទានសមយំ យាវត៑ ជគតិ បាបម៑ អាសីត៑ កិន្តុ យត្រ វ្យវស្ថា ន វិទ្យតេ តត្រ បាបស្យាបិ គណនា ន វិទ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","តថាប្យាទមា យាទ្ឫឝំ បាបំ ក្ឫតំ តាទ្ឫឝំ បាបំ យៃ រ្នាការិ អាទមម៑ អារភ្យ មូសាំ យាវត៑ តេឞាមប្យុបរិ ម្ឫត្យូ រាជត្វម៑ អករោត៑ ស អាទម៑ ភាវ្យាទមោ និទឝ៌នមេវាស្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","កិន្តុ បាបកម៌្មណោ យាទ្ឫឝោ ភាវស្តាទ្ឫគ៑ ទានកម៌្មណោ ភាវោ ន ភវតិ យត ឯកស្យ ជនស្យាបរាធេន យទិ ពហូនាំ មរណម៑ អឃដត តថាបីឝ្វរានុគ្រហស្តទនុគ្រហមូលកំ ទានញ្ចៃកេន ជនេនាត៌្ហាទ៑ យីឝុនា ខ្រីឞ្ដេន ពហុឞុ ពាហុល្យាតិពាហុល្យេន ផលតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","អបរម៑ ឯកស្យ ជនស្យ បាបកម៌្ម យាទ្ឫក៑ ផលយុក្តំ ទានកម៌្ម តាទ្ឫក៑ ន ភវតិ យតោ វិចារកម៌្មៃកំ បាបម៑ អារភ្យ ទណ្ឌជនកំ ពភូវ, កិន្តុ ទានកម៌្ម ពហុបាបាន្យារភ្យ បុណ្យជនកំ ពភូវ។ ");
INSERT INTO sankhm_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","យត ឯកស្យ ជនស្យ បាបកម៌្មតស្តេនៃកេន យទិ មរណស្យ រាជត្វំ ជាតំ តហ៌ិ យេ ជនា អនុគ្រហស្យ ពាហុល្យំ បុណ្យទានញ្ច ប្រាប្នុវន្តិ ត ឯកេន ជនេន, អត៌្ហាត៑ យីឝុខ្រីឞ្ដេន, ជីវនេ រាជត្វម៑ អវឝ្យំ ករិឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","ឯកោៜបរាធោ យទ្វត៑ សវ៌្វមានវានាំ ទណ្ឌគាមី មាគ៌ោ ៜភវត៑ តទ្វទ៑ ឯកំ បុណ្យទានំ សវ៌្វមានវានាំ ជីវនយុក្តបុណ្យគាមី មាគ៌ ឯវ។ ");
INSERT INTO sankhm_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","អបរម៑ ឯកស្យ ជនស្យាជ្ញាលង្ឃនាទ៑ យថា ពហវោ ៜបរាធិនោ ជាតាស្តទ្វទ៑ ឯកស្យាជ្ញាចរណាទ៑ ពហវះ សបុណ្យីក្ឫតា ភវន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","អធិកន្តុ វ្យវស្ថាគមនាទ៑ អបរាធស្យ ពាហុល្យំ ជាតំ កិន្តុ យត្រ បាបស្យ ពាហុល្យំ តត្រៃវ តស្មាទ៑ អនុគ្រហស្យ ពាហុល្យម៑ អភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","តេន ម្ឫត្យុនា យទ្វត៑ បាបស្យ រាជត្វម៑ អភវត៑ តទ្វទ៑ អស្មាកំ ប្រភុយីឝុខ្រីឞ្ដទ្វារានន្តជីវនទាយិបុណ្យេនានុគ្រហស្យ រាជត្វំ ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","ប្រភូតរូបេណ យទ៑ អនុគ្រហះ ប្រកាឝតេ តទត៌្ហំ បាបេ តិឞ្ឋាម ឥតិ វាក្យំ កិំ វយំ វទិឞ្យាមះ? តន្ន ភវតុ។ ");
INSERT INTO sankhm_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","បាបំ ប្រតិ ម្ឫតា វយំ បុនស្តស្មិន៑ កថម៑ ជីវិឞ្យាមះ? ");
INSERT INTO sankhm_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","វយំ យាវន្តោ លោកា យីឝុខ្រីឞ្ដេ មជ្ជិតា អភវាម តាវន្ត ឯវ តស្យ មរណេ មជ្ជិតា ឥតិ កិំ យូយំ ន ជានីថ? ");
INSERT INTO sankhm_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","តតោ យថា បិតុះ បរាក្រមេណ ឝ្មឝានាត៑ ខ្រីឞ្ដ ឧត្ថាបិតស្តថា វយមបិ យត៑ នូតនជីវិន ឥវាចរាមស្តទត៌្ហំ មជ្ជនេន តេន សាទ៌្ធំ ម្ឫត្យុរូបេ ឝ្មឝានេ សំស្ថាបិតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","អបរំ វយំ យទិ តេន សំយុក្តាះ សន្តះ ស ឥវ មរណភាគិនោ ជាតាស្តហ៌ិ ស ឥវោត្ថានភាគិនោៜបិ ភវិឞ្យាមះ។ ");
INSERT INTO sankhm_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","វយំ យត៑ បាបស្យ ទាសាះ បុន រ្ន ភវាមស្តទត៌្ហម៑ អស្មាកំ បាបរូបឝរីរស្យ វិនាឝាត៌្ហម៑ អស្មាកំ បុរាតនបុរុឞស្តេន សាកំ ក្រុឝេៜហន្យតេតិ វយំ ជានីមះ។ ");
INSERT INTO sankhm_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","យោ ហតះ ស បាបាត៑ មុក្ត ឯវ។ ");
INSERT INTO sankhm_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","អតឯវ យទិ វយំ ខ្រីឞ្ដេន សាទ៌្ធម៑ អហន្យាមហិ តហ៌ិ បុនរបិ តេន សហិតា ជីវិឞ្យាម ឥត្យត្រាស្មាកំ វិឝ្វាសោ វិទ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","យតះ ឝ្មឝានាទ៑ ឧត្ថាបិតះ ខ្រីឞ្ដោ បុន រ្ន ម្រិយត ឥតិ វយំ ជានីមះ។ តស្មិន៑ កោប្យធិការោ ម្ឫត្យោ រ្នាស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","អបរញ្ច ស យទ៑ អម្រិយត តេនៃកទា បាបម៑ ឧទ្ទិឝ្យាម្រិយត, យច្ច ជីវតិ តេនេឝ្វរម៑ ឧទ្ទិឝ្យ ជីវតិ; ");
INSERT INTO sankhm_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","តទ្វទ៑ យូយមបិ ស្វាន៑ បាបម៑ ឧទ្ទិឝ្យ ម្ឫតាន៑ អស្មាកំ ប្រភុណា យីឝុខ្រីឞ្ដេនេឝ្វរម៑ ឧទ្ទិឝ្យ ជីវន្តោ ជានីត។ ");
INSERT INTO sankhm_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","អបរញ្ច កុត្សិតាភិលាឞាाន៑ បូរយិតុំ យុឞ្មាកំ មត៌្យទេហេឞុ បាបម៑ អាធិបត្យំ ន ករោតុ។ ");
INSERT INTO sankhm_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","អបរំ ស្វំ ស្វម៑ អង្គម៑ អធម៌្មស្យាស្ត្រំ ក្ឫត្វា បាបសេវាយាំ ន សមប៌យត, កិន្តុ ឝ្មឝានាទ៑ ឧត្ថិតានិវ ស្វាន៑ ឦឝ្វរេ សមប៌យត ស្វាន្យង្គានិ ច ធម៌្មាស្ត្រស្វរូបាណីឝ្វរម៑ ឧទ្ទិឝ្យ សមប៌យត។ ");
INSERT INTO sankhm_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","យុឞ្មាកម៑ ឧបរិ បាបស្យាធិបត្យំ បុន រ្ន ភវិឞ្យតិ, យស្មាទ៑ យូយំ វ្យវស្ថាយា អនាយត្តា អនុគ្រហស្យ ចាយត្តា អភវត។ ");
INSERT INTO sankhm_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","កិន្តុ វយំ វ្យវស្ថាយា អនាយត្តា អនុគ្រហស្យ ចាយត្តា អភវាម, ឥតិ ការណាត៑ កិំ បាបំ ករិឞ្យាមះ? តន្ន ភវតុ។ ");
INSERT INTO sankhm_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","យតោ ម្ឫតិជនកំ បាបំ បុណ្យជនកំ និទេឝាចរណញ្ចៃតយោទ៌្វយោ រ្យស្មិន៑ អាជ្ញាបាលនាត៌្ហំ ភ្ឫត្យានិវ ស្វាន៑ សមប៌យថ, តស្យៃវ ភ្ឫត្យា ភវថ, ឯតត៑ កិំ យូយំ ន ជានីថ? ");
INSERT INTO sankhm_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","អបរញ្ច បូវ៌្វំ យូយំ បាបស្យ ភ្ឫត្យា អាស្តេតិ សត្យំ កិន្តុ យស្យាំ ឝិក្ឞារូបាយាំ មូឞាយាំ និក្ឞិប្តា អភវត តស្យា អាក្ឫតិំ មនោភិ រ្លព្ធវន្ត ឥតិ ការណាទ៑ ឦឝ្វរស្យ ធន្យវាទោ ភវតុ។ ");
INSERT INTO sankhm_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","ឥត្ថំ យូយំ បាបសេវាតោ មុក្តាះ សន្តោ ធម៌្មស្យ ភ្ឫត្យា ជាតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","យុឞ្មាកំ ឝារីរិក្យា ទុព៌្ពលតាយា ហេតោ រ្មានវវទ៑ អហម៑ ឯតទ៑ ព្រវីមិ; បុនះ បុនរធម៌្មករណាត៌្ហំ យទ្វត៑ បូវ៌្វំ បាបាមេធ្យយោ រ្ភ្ឫត្យត្វេ និជាង្គានិ សមាប៌យត តទ្វទ៑ ឥទានីំ សាធុកម៌្មករណាត៌្ហំ ធម៌្មស្យ ភ្ឫត្យត្វេ និជាង្គានិ សមប៌យត។ ");
INSERT INTO sankhm_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","យទា យូយំ បាបស្យ ភ្ឫត្យា អាស្ត តទា ធម៌្មស្យ នាយត្តា អាស្ត។ ");
INSERT INTO sankhm_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","តហ៌ិ យានិ កម៌្មាណិ យូយម៑ ឥទានីំ លជ្ជាជនកានិ ពុធ្យធ្វេ បូវ៌្វំ តៃ រ្យុឞ្មាកំ កោ លាភ អាសីត៑? តេឞាំ កម៌្មណាំ ផលំ មរណមេវ។ ");
INSERT INTO sankhm_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","កិន្តុ សាម្ប្រតំ យូយំ បាបសេវាតោ មុក្តាះ សន្ត ឦឝ្វរស្យ ភ្ឫត្យាៜភវត តស្មាទ៑ យុឞ្មាកំ បវិត្រត្វរូបំ លភ្យម៑ អនន្តជីវនរូបញ្ច ផលម៑ អាស្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","យតះ បាបស្យ វេតនំ មរណំ កិន្ត្វស្មាកំ ប្រភុណា យីឝុខ្រីឞ្ដេនានន្តជីវនម៑ ឦឝ្វរទត្តំ បារិតោឞិកម៑ អាស្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","ហេ ភ្រាត្ឫគណ វ្យវស្ថាវិទះ ប្រតិ មមេទំ និវេទនំ។ វិធិះ កេវលំ យាវជ្ជីវំ មានវោបយ៌្យធិបតិត្វំ ករោតីតិ យូយំ កិំ ន ជានីថ? ");
INSERT INTO sankhm_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","យាវត្កាលំ បតិ រ្ជីវតិ តាវត្កាលម៑ ឩឍា ភាយ៌្យា វ្យវស្ថយា តស្មិន៑ ពទ្ធា តិឞ្ឋតិ កិន្តុ យទិ បតិ រ្ម្រិយតេ តហ៌ិ សា នារី បត្យុ រ្វ្យវស្ថាតោ មុច្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","ឯតត្ការណាត៑ បត្យុជ៌ីវនកាលេ នារី យទ្យន្យំ បុរុឞំ វិវហតិ តហ៌ិ សា វ្យភិចារិណី ភវតិ កិន្តុ យទិ ស បតិ រ្ម្រិយតេ តហ៌ិ សា តស្យា វ្យវស្ថាយា មុក្តា សតី បុរុឞាន្តរេណ វ្យូឍាបិ វ្យភិចារិណី ន ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","ហេ មម ភ្រាត្ឫគណ, ឦឝ្វរនិមិត្តំ យទស្មាកំ ផលំ ជាយតេ តទត៌្ហំ ឝ្មឝានាទ៑ ឧត្ថាបិតេន បុរុឞេណ សហ យុឞ្មាកំ វិវាហោ យទ៑ ភវេត៑ តទត៌្ហំ ខ្រីឞ្ដស្យ ឝរីរេណ យូយំ វ្យវស្ថាំ ប្រតិ ម្ឫតវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","យតោៜស្មាកំ ឝារីរិកាចរណសមយេ មរណនិមិត្តំ ផលម៑ ឧត្បាទយិតុំ វ្យវស្ថយា ទូឞិតះ បាបាភិលាឞោៜស្មាកម៑ អង្គេឞុ ជីវន៑ អាសីត៑។ ");
INSERT INTO sankhm_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","កិន្តុ តទា យស្យា វ្យវស្ថាយា វឝេ អាស្មហិ សាម្ប្រតំ តាំ ប្រតិ ម្ឫតត្វាទ៑ វយំ តស្យា អធីនត្វាត៑ មុក្តា ឥតិ ហេតោរីឝ្វរោៜស្មាភិះ បុរាតនលិខិតានុសារាត៑ ន សេវិតវ្យះ កិន្តុ នវីនស្វភាវេនៃវ សេវិតវ្យះ ");
INSERT INTO sankhm_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","តហ៌ិ វយំ កិំ ព្រូមះ? វ្យវស្ថា កិំ បាបជនិកា ភវតិ? នេត្ថំ ភវតុ។ វ្យវស្ថាម៑ អវិទ្យមានាយាំ បាបំ កិម៑ ឥត្យហំ នាវេទំ; កិញ្ច លោភំ មា កាឞ៌ីរិតិ ចេទ៑ វ្យវស្ថាគ្រន្ថេ លិខិតំ នាភវិឞ្យត៑ តហ៌ិ លោភះ កិម្ភូតស្តទហំ នាជ្ញាស្យំ។ ");
INSERT INTO sankhm_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","កិន្តុ វ្យវស្ថយា បាបំ ឆិទ្រំ ប្រាប្យាស្មាកម៑ អន្តះ សវ៌្វវិធំ កុត្សិតាភិលាឞម៑ អជនយត៑; យតោ វ្យវស្ថាយាម៑ អវិទ្យមានាយាំ បាបំ ម្ឫតំ។ ");
INSERT INTO sankhm_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","អបរំ បូវ៌្វំ វ្យវស្ថាយាម៑ អវិទ្យមានាយាម៑ អហម៑ អជីវំ តតះ បរម៑ អាជ្ញាយាម៑ ឧបស្ថិតាយាម៑ បាបម៑ អជីវត៑ តទាហម៑ អម្រិយេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","ឥត្ថំ សតិ ជីវននិមិត្តា យាជ្ញា សា មម ម្ឫត្យុជនិកាភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","យតះ បាបំ ឆិទ្រំ ប្រាប្យ វ្យវស្ថិតាទេឝេន មាំ វញ្ចយិត្វា តេន មាម៑ អហន៑។ ");
INSERT INTO sankhm_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","អតឯវ វ្យវស្ថា បវិត្រា, អាទេឝឝ្ច បវិត្រោ ន្យាយ្យោ ហិតការី ច ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","តហ៌ិ យត៑ ស្វយំ ហិតក្ឫត៑ តត៑ កិំ មម ម្ឫត្យុជនកម៑ អភវត៑? នេត្ថំ ភវតុ; កិន្តុ បាបំ យត៑ បាតកមិវ ប្រកាឝតេ តថា និទេឝេន បាបំ យទតីវ បាតកមិវ ប្រកាឝតេ តទត៌្ហំ ហិតោបាយេន មម មរណម៑ អជនយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","វ្យវស្ថាត្មពោធិកេតិ វយំ ជានីមះ កិន្ត្វហំ ឝារីរតាចារី បាបស្យ ក្រីតកិង្ករោ វិទ្យេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","យតោ យត៑ កម៌្ម ករោមិ តត៑ មម មនោៜភិមតំ នហិ; អបរំ យន៑ មម មនោៜភិមតំ តន្ន ករោមិ កិន្តុ យទ៑ ឫតីយេ តត៑ ករោមិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","តថាត្វេ យន៑ មមានភិមតំ តទ៑ យទិ ករោមិ តហ៌ិ វ្យវស្ថា សូត្តមេតិ ស្វីករោមិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","អតឯវ សម្ប្រតិ តត៑ កម៌្ម មយា ក្រិយត ឥតិ នហិ កិន្តុ មម ឝរីរស្ថេន បាបេនៃវ ក្រិយតេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","យតោ មយិ, អត៌្ហតោ មម ឝរីរេ, កិមប្យុត្តមំ ន វសតិ, ឯតទ៑ អហំ ជានាមិ; មមេច្ឆុកតាយាំ តិឞ្ឋន្ត្យាមប្យហម៑ ឧត្តមកម៌្មសាធនេ សមត៌្ហោ ន ភវាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","យតោ យាមុត្តមាំ ក្រិយាំ កត៌្តុមហំ វាញ្ឆាមិ តាំ ន ករោមិ កិន្តុ យត៑ កុត្សិតំ កម៌្ម កត៌្តុម៑ អនិច្ឆុកោៜស្មិ តទេវ ករោមិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","អតឯវ យទ្យត៑ កម៌្ម កត៌្តុំ មមេច្ឆា ន ភវតិ តទ៑ យទិ ករោមិ តហ៌ិ តត៑ មយា ន ក្រិយតេ, មមាន្តវ៌ត៌្តិនា បាបេនៃវ ក្រិយតេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","ភទ្រំ កត៌្តុម៑ ឥច្ឆុកំ មាំ យោ ៜភទ្រំ កត៌្តុំ ប្រវត៌្តយតិ តាទ្ឫឝំ ស្វភាវមេកំ មយិ បឝ្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","អហម៑ អាន្តរិកបុរុឞេណេឝ្វរវ្យវស្ថាយាំ សន្តុឞ្ដ អាសេ; ");
INSERT INTO sankhm_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","កិន្តុ តទ្វិបរីតំ យុធ្យន្តំ តទន្យមេកំ ស្វភាវំ មទីយាង្គស្ថិតំ ប្របឝ្យាមិ, ស មទីយាង្គស្ថិតបាបស្វភាវស្យាយត្តំ មាំ កត៌្តុំ ចេឞ្ដតេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","ហា ហា យោៜហំ ទុព៌្ហាគ្យោ មនុជស្តំ មាម៑ ឯតស្មាន៑ ម្ឫតាច្ឆរីរាត៑ កោ និស្តារយិឞ្យតិ? ");
INSERT INTO sankhm_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","អស្មាកំ ប្រភុណា យីឝុខ្រីឞ្ដេន និស្តារយិតារម៑ ឦឝ្វរំ ធន្យំ វទាមិ។ អតឯវ ឝរីរេណ បាបវ្យវស្ថាយា មនសា តុ ឦឝ្វរវ្យវស្ថាយាះ សេវនំ ករោមិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","យេ ជនាះ ខ្រីឞ្ដំ យីឝុម៑ អាឝ្រិត្យ ឝារីរិកំ នាចរន្ត អាត្មិកមាចរន្តិ តេៜធុនា ទណ្ឌាហ៌ា ន ភវន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","ជីវនទាយកស្យាត្មនោ វ្យវស្ថា ខ្រីឞ្ដយីឝុនា បាបមរណយោ រ្វ្យវស្ថាតោ មាមមោចយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","យស្មាច្ឆារីរស្យ ទុព៌្ពលត្វាទ៑ វ្យវស្ថយា យត៑ កម៌្មាសាធ្យម៑ ឦឝ្វរោ និជបុត្រំ បាបិឝរីររូបំ បាបនាឝកពលិរូបញ្ច ប្រេឞ្យ តស្យ ឝរីរេ បាបស្យ ទណ្ឌំ កុវ៌្វន៑ តត្កម៌្ម សាធិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","តតះ ឝារីរិកំ នាចរិត្វាស្មាភិរាត្មិកម៑ អាចរទ្ភិវ៌្យវស្ថាគ្រន្ថេ និទ៌្ទិឞ្ដានិ បុណ្យកម៌្មាណិ សវ៌្វាណិ សាធ្យន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","យេ ឝារីរិកាចារិណស្តេ ឝារីរិកាន៑ វិឞយាន៑ ភាវយន្តិ យេ ចាត្មិកាចារិណស្តេ អាត្មនោ វិឞយាន៑ ភាវយន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","ឝារីរិកភាវស្យ ផលំ ម្ឫត្យុះ កិញ្ចាត្មិកភាវស្យ ផលេ ជីវនំ ឝាន្តិឝ្ច។ ");
INSERT INTO sankhm_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","យតះ ឝារីរិកភាវ ឦឝ្វរស្យ វិរុទ្ធះ ឝត្រុតាភាវ ឯវ ស ឦឝ្វរស្យ វ្យវស្ថាយា អធីនោ ន ភវតិ ភវិតុញ្ច ន ឝក្នោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","ឯតស្មាត៑ ឝារីរិកាចារិឞុ តោឞ្ដុម៑ ឦឝ្វរេណ ន ឝក្យំ។ ");
INSERT INTO sankhm_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","កិន្ត្វីឝ្វរស្យាត្មា យទិ យុឞ្មាកំ មធ្យេ វសតិ តហ៌ិ យូយំ ឝារីរិកាចារិណោ ន សន្ត អាត្មិកាចារិណោ ភវថះ។ យស្មិន៑ តុ ខ្រីឞ្ដស្យាត្មា ន វិទ្យតេ ស តត្សម្ភវោ នហិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","យទិ ខ្រីឞ្ដោ យុឞ្មាន៑ អធិតិឞ្ឋតិ តហ៌ិ បាបម៑ ឧទ្ទិឝ្យ ឝរីរំ ម្ឫតំ កិន្តុ បុណ្យមុទ្ទិឝ្យាត្មា ជីវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","ម្ឫតគណាទ៑ យីឝុ រ្យេនោត្ថាបិតស្តស្យាត្មា យទិ យុឞ្មន្មធ្យេ វសតិ តហ៌ិ ម្ឫតគណាត៑ ខ្រីឞ្ដស្យ ស ឧត្ថាបយិតា យុឞ្មន្មធ្យវាសិនា ស្វកីយាត្មនា យុឞ្មាកំ ម្ឫតទេហានបិ បុន រ្ជីវយិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","ហេ ភ្រាត្ឫគណ ឝរីរស្យ វយមធមណ៌ា ន ភវាមោៜតះ ឝារីរិកាចារោៜស្មាភិ រ្ន កត៌្តវ្យះ។ ");
INSERT INTO sankhm_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","យទិ យូយំ ឝរីរិកាចារិណោ ភវេត តហ៌ិ យុឞ្មាភិ រ្មត៌្តវ្យមេវ កិន្ត្វាត្មនា យទិ ឝរីរកម៌្មាណិ ឃាតយេត តហ៌ិ ជីវិឞ្យថ។ ");
INSERT INTO sankhm_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","យតោ យាវន្តោ លោកា ឦឝ្វរស្យាត្មនាក្ឫឞ្យន្តេ តេ សវ៌្វ ឦឝ្វរស្យ សន្តានា ភវន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","យូយំ បុនរបិ ភយជនកំ ទាស្យភាវំ ន ប្រាប្តាះ កិន្តុ យេន ភាវេនេឝ្វរំ បិតះ បិតរិតិ ប្រោច្យ សម្ពោធយថ តាទ្ឫឝំ ទត្តកបុត្រត្វភាវម៑ ប្រាប្នុត។ ");
INSERT INTO sankhm_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","អបរញ្ច វយម៑ ឦឝ្វរស្យ សន្តានា ឯតស្មិន៑ បវិត្រ អាត្មា ស្វយម៑ អស្មាកម៑ អាត្មាភិះ សាទ៌្ធំ ប្រមាណំ ទទាតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","អតឯវ វយំ យទិ សន្តានាស្តហ៌្យធិការិណះ, អត៌្ហាទ៑ ឦឝ្វរស្យ ស្វត្ត្វាធិការិណះ ខ្រីឞ្ដេន សហាធិការិណឝ្ច ភវាមះ; អបរំ តេន សាទ៌្ធំ យទិ ទុះខភាគិនោ ភវាមស្តហ៌ិ តស្យ វិភវស្យាបិ ភាគិនោ ភវិឞ្យាមះ។ ");
INSERT INTO sankhm_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","កិន្ត្វស្មាសុ យោ ភាវីវិភវះ ប្រកាឝិឞ្យតេ តស្យ សមីបេ វត៌្តមានកាលីនំ ទុះខមហំ ត្ឫណាយ មន្យេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","យតះ ប្រាណិគណ ឦឝ្វរស្យ សន្តានានាំ វិភវប្រាប្តិម៑ អាកាង្ក្ឞន៑ និតាន្តម៑ អបេក្ឞតេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","អបរញ្ច ប្រាណិគណះ ស្វៃរម៑ អលីកតាយា វឝីក្ឫតោ នាភវត្ ");
INSERT INTO sankhm_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","កិន្តុ ប្រាណិគណោៜបិ នឝ្វរតាធីនត្វាត៑ មុក្តះ សន៑ ឦឝ្វរស្យ សន្តានានាំ បរមមុក្តិំ ប្រាប្ស្យតីត្យភិប្រាយេណ វឝីកត៌្រា វឝីចក្រេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","អបរញ្ច ប្រសូយមានាវទ៑ វ្យថិតះ សន៑ ឥទានីំ យាវត៑ ក្ឫត្ស្នះ ប្រាណិគណ អាត៌្តស្វរំ ករោតីតិ វយំ ជានីមះ។ ");
INSERT INTO sankhm_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","កេវលះ ស ឥតិ នហិ កិន្តុ ប្រថមជាតផលស្វរូបម៑ អាត្មានំ ប្រាប្តា វយមបិ ទត្តកបុត្រត្វបទប្រាប្តិម៑ អត៌្ហាត៑ ឝរីរស្យ មុក្តិំ ប្រតីក្ឞមាណាស្តទ្វទ៑ អន្តរាត៌្តរាវំ កុម៌្មះ។ ");
INSERT INTO sankhm_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","វយំ ប្រត្យាឝយា ត្រាណម៑ អលភាមហិ កិន្តុ ប្រត្យក្ឞវស្តុនោ យា ប្រត្យាឝា សា ប្រត្យាឝា នហិ, យតោ មនុឞ្យោ យត៑ សមីក្ឞតេ តស្យ ប្រត្យាឝាំ កុតះ ករិឞ្យតិ? ");
INSERT INTO sankhm_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","យទ៑ អប្រត្យក្ឞំ តស្យ ប្រត្យាឝាំ យទិ វយំ កុវ៌្វីមហិ តហ៌ិ ធៃយ៌្យម៑ អវលម្ព្យ ប្រតីក្ឞាមហេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","តត អាត្មាបិ ស្វយម៑ អស្មាកំ ទុព៌្ពលតាយាះ សហាយត្វំ ករោតិ; យតះ កិំ ប្រាត៌្ហិតវ្យំ តទ៑ ពោទ្ធុំ វយំ ន ឝក្នុមះ, កិន្ត្វស្បឞ្ដៃរាត៌្តរាវៃរាត្មា ស្វយម៑ អស្មន្និមិត្តំ និវេទយតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","អបរម៑ ឦឝ្វរាភិមតរូបេណ បវិត្រលោកានាំ ក្ឫតេ និវេទយតិ យ អាត្មា តស្យាភិប្រាយោៜន្តយ៌្យាមិនា ជ្ញាយតេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","អបរម៑ ឦឝ្វរីយនិរូបណានុសារេណាហូតាះ សន្តោ យេ តស្មិន៑ ប្រីយន្តេ សវ៌្វាណិ មិលិត្វា តេឞាំ មង្គលំ សាធយន្តិ, ឯតទ៑ វយំ ជានីមះ។ ");
INSERT INTO sankhm_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","យត ឦឝ្វរោ ពហុភ្រាត្ឫណាំ មធ្យេ ស្វបុត្រំ ជ្យេឞ្ឋំ កត៌្តុម៑ ឥច្ឆន៑ យាន៑ បូវ៌្វំ លក្ឞ្យីក្ឫតវាន៑ តាន៑ តស្យ ប្រតិមូត៌្យាះ សាទ្ឫឝ្យប្រាប្ត្យត៌្ហំ ន្យយុំក្ត។ ");
INSERT INTO sankhm_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","អបរញ្ច តេន យេ និយុក្តាស្ត អាហូតា អបិ យេ ច តេនាហូតាស្តេ សបុណ្យីក្ឫតាះ, យេ ច តេន សបុណ្យីក្ឫតាស្តេ វិភវយុក្តាះ។ ");
INSERT INTO sankhm_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","ឥត្យត្រ វយំ កិំ ព្រូមះ? ឦឝ្វរោ យទ្យស្មាកំ សបក្ឞោ ភវតិ តហ៌ិ កោ វិបក្ឞោៜស្មាកំ? ");
INSERT INTO sankhm_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","អាត្មបុត្រំ ន រក្ឞិត្វា យោៜស្មាកំ សវ៌្វេឞាំ ក្ឫតេ តំ ប្រទត្តវាន៑ ស កិំ តេន សហាស្មភ្យម៑ អន្យានិ សវ៌្វាណិ ន ទាស្យតិ? ");
INSERT INTO sankhm_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","ឦឝ្វរស្យាភិរុចិតេឞុ កេន ទោឞ អារោបយិឞ្យតេ? យ ឦឝ្វរស្តាន៑ បុណ្យវត ឥវ គណយតិ កិំ តេន? ");
INSERT INTO sankhm_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","អបរំ តេភ្យោ ទណ្ឌទានាជ្ញា វា កេន ករិឞ្យតេ? យោៜស្មន្និមិត្តំ ប្រាណាន៑ ត្យក្តវាន៑ កេវលំ តន្ន កិន្តុ ម្ឫតគណមធ្យាទ៑ ឧត្ថិតវាន៑, អបិ ចេឝ្វរស្យ ទក្ឞិណេ បាឝ៌្វេ តិឞ្ឋន៑ អទ្យាប្យស្មាកំ និមិត្តំ ប្រាត៌្ហត ឯវម្ភូតោ យះ ខ្រីឞ្ដះ កិំ តេន? ");
INSERT INTO sankhm_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","អស្មាភិះ សហ ខ្រីឞ្ដស្យ ប្រេមវិច្ឆេទំ ជនយិតុំ កះ ឝក្នោតិ? ក្លេឝោ វ្យសនំ វា តាឌនា វា ទុព៌្ហិក្ឞំ វា វស្ត្រហីនត្វំ វា ប្រាណសំឝយោ វា ខង្គោ វា កិមេតានិ ឝក្នុវន្តិ? ");
INSERT INTO sankhm_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","កិន្តុ លិខិតម៑ អាស្តេ, យថា, វយំ តវ និមិត្តំ ស្មោ ម្ឫត្យុវក្ត្រេៜខិលំ ទិនំ។ ពលិទ៌េយោ យថា មេឞោ វយំ គណ្យាមហេ តថា។ ");
INSERT INTO sankhm_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","អបរំ យោៜស្មាសុ ប្រីយតេ តេនៃតាសុ វិបត្សុ វយំ សម្យគ៑ វិជយាមហេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","យតោៜស្មាកំ ប្រភុនា យីឝុខ្រីឞ្ដេនេឝ្វរស្យ យត៑ ប្រេម តស្មាទ៑ អស្មាកំ វិច្ឆេទំ ជនយិតុំ ម្ឫត្យុ រ្ជីវនំ វា ទិវ្យទូតា វា ពលវន្តោ មុខ្យទូតា វា វត៌្តមានោ វា ភវិឞ្យន៑ កាលោ វា ឧច្ចបទំ វា នីចបទំ វាបរំ កិមបិ ស្ឫឞ្ដវស្តុ ");
INSERT INTO sankhm_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","វៃតេឞាំ កេនាបិ ន ឝក្យមិត្យស្មិន៑ ទ្ឫឍវិឝ្វាសោ មមាស្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","អហំ កាញ្ចិទ៑ កល្បិតាំ កថាំ ន កថយាមិ, ខ្រីឞ្ដស្យ សាក្ឞាត៑ សត្យមេវ ព្រវីមិ បវិត្រស្យាត្មនះ សាក្ឞាន៑ មទីយំ មន ឯតត៑ សាក្ឞ្យំ ទទាតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","មមាន្តរតិឝយទុះខំ និរន្តរំ ខេទឝ្ច ");
INSERT INTO sankhm_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","តស្មាទ៑ អហំ ស្វជាតីយភ្រាត្ឫណាំ និមិត្តាត៑ ស្វយំ ខ្រីឞ្ដាច្ឆាបាក្រាន្តោ ភវិតុម៑ ឰច្ឆម៑។ ");
INSERT INTO sankhm_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","យតស្ត ឥស្រាយេលស្យ វំឝា អបិ ច ទត្តកបុត្រត្វំ តេជោ និយមោ វ្យវស្ថាទានំ មន្ទិរេ ភជនំ ប្រតិជ្ញាះ បិត្ឫបុរុឞគណឝ្ចៃតេឞុ សវ៌្វេឞុ តេឞាម៑ អធិការោៜស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","តត៑ កេវលំ នហិ កិន្តុ សវ៌្វាធ្យក្ឞះ សវ៌្វទា សច្ចិទានន្ទ ឦឝ្វរោ យះ ខ្រីឞ្ដះ សោៜបិ ឝារីរិកសម្ពន្ធេន តេឞាំ វំឝសម្ភវះ។ ");
INSERT INTO sankhm_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","ឦឝ្វរស្យ វាក្យំ វិផលំ ជាតម៑ ឥតិ នហិ យត្ការណាទ៑ ឥស្រាយេលោ វំឝេ យេ ជាតាស្តេ សវ៌្វេ វស្តុត ឥស្រាយេលីយា ន ភវន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","អបរម៑ ឥព្រាហីមោ វំឝេ ជាតា អបិ សវ៌្វេ តស្យៃវ សន្តានា ន ភវន្តិ កិន្តុ ឥស្ហាកោ នាម្នា តវ វំឝោ វិខ្យាតោ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","អត៌្ហាត៑ ឝារីរិកសំសគ៌ាត៑ ជាតាះ សន្តានា យាវន្តស្តាវន្ត ឯវេឝ្វរស្យ សន្តានា ន ភវន្តិ កិន្តុ ប្រតិឝ្រវណាទ៑ យេ ជាយន្តេ តឯវេឝ្វរវំឝោ គណ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","យតស្តត្ប្រតិឝ្រុតេ រ្វាក្យមេតត៑, ឯតាទ្ឫឝេ សមយេ ៜហំ បុនរាគមិឞ្យាមិ តត្បូវ៌្វំ សារាយាះ បុត្រ ឯកោ ជនិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","អបរមបិ វទាមិ ស្វមនោៜភិលាឞត ឦឝ្វរេណ យន្និរូបិតំ តត៑ កម៌្មតោ នហិ កិន្ត្វាហ្វយិតុ រ្ជាតមេតទ៑ យថា សិទ្ធ្យតិ ");
INSERT INTO sankhm_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","តទត៌្ហំ រិព្កានាមិកយា យោឞិតា ជនៃកស្មាទ៑ អត៌្ហាទ៑ អស្មាកម៑ ឥស្ហាកះ បូវ៌្វបុរុឞាទ៑ គព៌្ហេ ធ្ឫតេ តស្យាះ សន្តានយោះ ប្រសវាត៑ បូវ៌្វំ កិញ្ច តយោះ ឝុភាឝុភកម៌្មណះ ករណាត៑ បូវ៌្វំ ");
INSERT INTO sankhm_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","តាំ ប្រតីទំ វាក្យម៑ ឧក្តំ, ជ្យេឞ្ឋះ កនិឞ្ឋំ សេវិឞ្យតេ, ");
INSERT INTO sankhm_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","យថា លិខិតម៑ អាស្តេ, តថាប្យេឞាវិ ន ប្រីត្វា យាកូពិ ប្រីតវាន៑ អហំ។ ");
INSERT INTO sankhm_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","តហ៌ិ វយំ កិំ ព្រូមះ? ឦឝ្វរះ កិម៑ អន្យាយការី? តថា ន ភវតុ។ ");
INSERT INTO sankhm_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","យតះ ស ស្វយំ មូសាម៑ អវទត៑; អហំ យស្មិន៑ អនុគ្រហំ ចិកីឞ៌ាមិ តមេវានុគ្ឫហ្លាមិ, យញ្ច ទយិតុម៑ ឥច្ឆាមិ តមេវ ទយេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","អតឯវេច្ឆតា យតមានេន វា មានវេន តន្ន សាធ្យតេ ទយាការិណេឝ្វរេណៃវ សាធ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","ផិរៅណិ ឝាស្ត្រេ លិខតិ, អហំ ត្វទ្ទ្វារា មត្បរាក្រមំ ទឝ៌យិតុំ សវ៌្វប្ឫថិវ្យាំ និជនាម ប្រកាឝយិតុញ្ច ត្វាំ ស្ថាបិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","អតះ ស យម៑ អនុគ្រហីតុម៑ ឥច្ឆតិ តមេវានុគ្ឫហ្លាតិ, យញ្ច និគ្រហីតុម៑ ឥច្ឆតិ តំ និគ្ឫហ្លាតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","យទិ វទសិ តហ៌ិ ស ទោឞំ កុតោ គ្ឫហ្លាតិ? តទីយេច្ឆាយាះ ប្រតិពន្ធកត្វំ កត៌្តំ កស្យ សាមត៌្ហ្យំ វិទ្យតេ? ");
INSERT INTO sankhm_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","ហេ ឦឝ្វរស្យ ប្រតិបក្ឞ មត៌្យ ត្វំ កះ? ឯតាទ្ឫឝំ មាំ កុតះ ស្ឫឞ្ដវាន៑? ឥតិ កថាំ ស្ឫឞ្ដវស្តុ ស្រឞ្ដ្រេ កិំ កថយិឞ្យតិ? ");
INSERT INTO sankhm_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","ឯកស្មាន៑ ម្ឫត្បិណ្ឌាទ៑ ឧត្ក្ឫឞ្ដាបក្ឫឞ្ដៅ ទ្វិវិធៅ កលឝៅ កត៌្តុំ កិំ កុលាលស្យ សាមត៌្ហ្យំ នាស្តិ? ");
INSERT INTO sankhm_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","ឦឝ្វរះ កោបំ ប្រកាឝយិតុំ និជឝក្តិំ ជ្ញាបយិតុញ្ចេច្ឆន៑ យទិ វិនាឝស្យ យោគ្យានិ ក្រោធភាជនានិ ប្រតិ ពហុកាលំ ទីគ៌្ហសហិឞ្ណុតាម៑ អាឝ្រយតិ; ");
INSERT INTO sankhm_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","អបរញ្ច វិភវប្រាប្ត្យត៌្ហំ បូវ៌្វំ និយុក្តាន្យនុគ្រហបាត្រាណិ ប្រតិ និជវិភវស្យ ពាហុល្យំ ប្រកាឝយិតុំ កេវលយិហូទិនាំ នហិ ភិន្នទេឝិនាមបិ មធ្យាទ្ ");
INSERT INTO sankhm_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","អស្មានិវ តាន្យាហ្វយតិ តត្រ តវ កិំ? ");
INSERT INTO sankhm_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","ហោឝេយគ្រន្ថេ យថា លិខិតម៑ អាស្តេ, យោ លោកោ មម នាសីត៑ តំ វទិឞ្យាមិ មទីយកំ។ យា ជាតិ រ្មេៜប្រិយា ចាសីត៑ តាំ វទិឞ្យាម្យហំ ប្រិយាំ។ ");
INSERT INTO sankhm_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","យូយំ មទីយលោកា ន យត្រេតិ វាក្យមៅច្យត។ អមរេឝស្យ សន្តានា ឥតិ ខ្យាស្យន្តិ តត្រ តេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","ឥស្រាយេលីយលោកេឞុ យិឝាយិយោៜបិ វាចមេតាំ ប្រាចារយត៑, ឥស្រាយេលីយវំឝានាំ យា សំខ្យា សា តុ និឝ្ចិតំ។ សមុទ្រសិកតាសំខ្យាសមានា យទិ ជាយតេ។ តថាបិ កេវលំ លោកៃរល្បៃស្ត្រាណំ វ្រជិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","យតោ ន្យាយេន ស្វំ កម៌្ម បរេឝះ សាធយិឞ្យតិ។ ទេឝេ សឯវ សំក្ឞេបាន្និជំ កម៌្ម ករិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","យិឝាយិយោៜបរមបិ កថយាមាស, សៃន្យាធ្យក្ឞបរេឝេន ចេត៑ កិញ្ចិន្នោទឝិឞ្យត។ តទា វយំ សិទោមេវាភវិឞ្យាម វិនិឝ្ចិតំ។ យទ្វា វយម៑ អមោរាយា អគមិឞ្យាម តុល្យតាំ។ ");
INSERT INTO sankhm_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","តហ៌ិ វយំ កិំ វក្ឞ្យាមះ? ឥតរទេឝីយា លោកា អបិ បុណ្យាត៌្ហម៑ អយតមានា វិឝ្វាសេន បុណ្យម៑ អលភន្ត; ");
INSERT INTO sankhm_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","កិន្ត្វិស្រាយេល្លោកា វ្យវស្ថាបាលនេន បុណ្យាត៌្ហំ យតមានាស្តន៑ នាលភន្ត។ ");
INSERT INTO sankhm_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","តស្យ កិំ ការណំ? តេ វិឝ្វាសេន នហិ កិន្តុ វ្យវស្ថាយាះ ក្រិយយា ចេឞ្ដិត្វា តស្មិន៑ ស្ខលនជនកេ បាឞាណេ បាទស្ខលនំ ប្រាប្តាះ។ ");
INSERT INTO sankhm_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","លិខិតំ យាទ្ឫឝម៑ អាស្តេ, បឝ្យ បាទស្ខលាត៌្ហំ ហិ សីយោនិ ប្រស្តរន្តថា។ ពាធាការញ្ច បាឞាណំ បរិស្ថាបិតវានហម៑។ វិឝ្វសិឞ្យតិ យស្តត្រ ស ជនោ ន ត្របិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","ហេ ភ្រាតរ ឥស្រាយេលីយលោកា យត៑ បរិត្រាណំ ប្រាប្នុវន្តិ តទហំ មនសាភិលឞន៑ ឦឝ្វរស្យ សមីបេ ប្រាត៌្ហយេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","យត ឦឝ្វរេ តេឞាំ ចេឞ្ដា វិទ្យត ឥត្យត្រាហំ សាក្ឞ្យស្មិ; កិន្តុ តេឞាំ សា ចេឞ្ដា សជ្ញានា នហិ, ");
INSERT INTO sankhm_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","យតស្ត ឦឝ្វរទត្តំ បុណ្យម៑ អវិជ្ញាយ ស្វក្ឫតបុណ្យំ ស្ថាបយិតុម៑ ចេឞ្ដមានា ឦឝ្វរទត្តស្យ បុណ្យស្យ និឃ្នត្វំ ន ស្វីកុវ៌្វន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","ខ្រីឞ្ដ ឯកៃកវិឝ្វាសិជនាយ បុណ្យំ ទាតុំ វ្យវស្ថាយាះ ផលស្វរូបោ ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","វ្យវស្ថាបាលនេន យត៑ បុណ្យំ តត៑ មូសា វណ៌យាមាស, យថា, យោ ជនស្តាំ បាលយិឞ្យតិ ស តទ្ទ្វារា ជីវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","កិន្តុ ប្រត្យយេន យត៑ បុណ្យំ តទ៑ ឯតាទ្ឫឝំ វាក្យំ វទតិ, កះ ស្វគ៌ម៑ អារុហ្យ ខ្រីឞ្ដម៑ អវរោហយិឞ្យតិ? ");
INSERT INTO sankhm_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","កោ វា ប្រេតលោកម៑ អវរុហ្យ ខ្រីឞ្ដំ ម្ឫតគណមធ្យាទ៑ អានេឞ្យតីតិ វាក៑ មនសិ ត្វយា ន គទិតវ្យា។ ");
INSERT INTO sankhm_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","តហ៌ិ កិំ ព្រវីតិ? តទ៑ វាក្យំ តវ សមីបស្ថម៑ អត៌្ហាត៑ តវ វទនេ មនសិ ចាស្តេ, តច្ច វាក្យម៑ អស្មាភិះ ប្រចាយ៌្យមាណំ វិឝ្វាសស្យ វាក្យមេវ។ ");
INSERT INTO sankhm_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","វស្តុតះ ប្រភុំ យីឝុំ យទិ វទនេន ស្វីករោឞិ, តថេឝ្វរស្តំ ឝ្មឝានាទ៑ ឧទស្ថាបយទ៑ ឥតិ យទ្យន្តះករណេន វិឝ្វសិឞិ តហ៌ិ បរិត្រាណំ លប្ស្យសេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","យស្មាត៑ បុណ្យប្រាប្ត្យត៌្ហម៑ អន្តះករណេន វិឝ្វសិតវ្យំ បរិត្រាណាត៌្ហញ្ច វទនេន ស្វីកត៌្តវ្យំ។ ");
INSERT INTO sankhm_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","ឝាស្ត្រេ យាទ្ឫឝំ លិខតិ វិឝ្វសិឞ្យតិ យស្តត្រ ស ជនោ ន ត្របិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","ឥត្យត្រ យិហូទិនិ តទន្យលោកេ ច កោបិ វិឝេឞោ នាស្តិ យស្មាទ៑ យះ សវ៌្វេឞាម៑ អទ្វិតីយះ ប្រភុះ ស និជយាចកាន សវ៌្វាន៑ ប្រតិ វទាន្យោ ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","យតះ, យះ កឝ្ចិត៑ បរមេឝស្យ នាម្នា ហិ ប្រាត៌្ហយិឞ្យតេ។ ស ឯវ មនុជោ នូនំ បរិត្រាតោ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","យំ យេ ជនា ន ប្រត្យាយន៑ តេ តមុទ្ទិឝ្យ កថំ ប្រាត៌្ហយិឞ្យន្តេ? យេ វា យស្យាខ្យានំ កទាបិ ន ឝ្រុតវន្តស្តេ តំ កថំ ប្រត្យេឞ្យន្តិ? អបរំ យទិ ប្រចារយិតារោ ន តិឞ្ឋន្តិ តទា កថំ តេ ឝ្រោឞ្យន្តិ? ");
INSERT INTO sankhm_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","យទិ វា ប្រេរិតា ន ភវន្តិ តទា កថំ ប្រចារយិឞ្យន្តិ? យាទ្ឫឝំ លិខិតម៑ អាស្តេ, យថា, មាង្គលិកំ សុសំវាទំ ទទត្យានីយ យេ នរាះ។ ប្រចារយន្តិ ឝាន្តេឝ្ច សុសំវាទំ ជនាស្តុ យេ។ តេឞាំ ចរណបទ្មានិ កីទ្ឫក៑ ឝោភាន្វិតានិ ហិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","កិន្តុ តេ សវ៌្វេ តំ សុសំវាទំ ន គ្ឫហីតវន្តះ។ យិឝាយិយោ យថា លិខិតវាន៑។ អស្មត្ប្រចារិតេ វាក្យេ វិឝ្វាសមករោទ្ធិ កះ។ ");
INSERT INTO sankhm_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","អតឯវ ឝ្រវណាទ៑ វិឝ្វាស ឰឝ្វរវាក្យប្រចារាត៑ ឝ្រវណញ្ច ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","តហ៌្យហំ ព្រវីមិ តៃះ កិំ នាឝ្រាវិ? អវឝ្យម៑ អឝ្រាវិ, យស្មាត៑ តេឞាំ ឝព្ទោ មហីំ វ្យាប្នោទ៑ វាក្យញ្ច និខិលំ ជគត៑។ ");
INSERT INTO sankhm_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","អបរមបិ វទាមិ, ឥស្រាយេលីយលោកាះ កិម៑ ឯតាំ កថាំ ន ពុធ្យន្តេ? ប្រថមតោ មូសា ឥទំ វាក្យំ ប្រោវាច, អហមុត្តាបយិឞ្យេ តាន៑ អគណ្យមានវៃរបិ។ ក្លេក្ឞ្យាមិ ជាតិម៑ ឯតាញ្ច ប្រោន្មត្តភិន្នជាតិភិះ។ ");
INSERT INTO sankhm_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","អបរញ្ច យិឝាយិយោៜតិឝយាក្ឞោភេណ កថយាមាស, យថា, អធិ មាំ យៃស្តុ នាចេឞ្ដិ សម្ប្រាប្តស្តៃ រ្ជនៃរហំ។ អធិ មាំ យៃ រ្ន សម្ប្ឫឞ្ដំ វិជ្ញាតស្តៃ រ្ជនៃរហំ៕ ");
INSERT INTO sankhm_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","កិន្ត្វិស្រាយេលីយលោកាន៑ អធិ កថយាញ្ចការ, យៃរាជ្ញាលង្ឃិភិ រ្លោកៃ រ្វិរុទ្ធំ វាក្យមុច្យតេ។ តាន៑ ប្រត្យេវ ទិនំ ក្ឫត្ស្នំ ហស្តៅ វិស្តារយាម្យហំ៕ ");
INSERT INTO sankhm_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","ឦឝ្វរេណ ស្វីកីយលោកា អបសារិតា អហំ កិម៑ ឦទ្ឫឝំ វាក្យំ ព្រវីមិ? តន្ន ភវតុ យតោៜហមបិ ពិន្យាមីនគោត្រីយ ឥព្រាហីមវំឝីយ ឥស្រាយេលីយលោកោៜស្មិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","ឦឝ្វរេណ បូវ៌្វំ យេ ប្រទ្ឫឞ្ដាស្តេ ស្វកីយលោកា អបសារិតា ឥតិ នហិ។ អបរម៑ ឯលិយោបាខ្យានេ ឝាស្ត្រេ យល្លិខិតម៑ អាស្តេ តទ៑ យូយំ កិំ ន ជានីថ? ");
INSERT INTO sankhm_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","ហេ បរមេឝ្វរ លោកាស្ត្វទីយាះ សវ៌្វា យជ្ញវេទីរភញ្ជន៑ តថា តវ ភវិឞ្យទ្វាទិនះ សវ៌្វាន៑ អឃ្នន៑ កេវល ឯកោៜហម៑ អវឝិឞ្ដ អាសេ តេ មមាបិ ប្រាណាន៑ នាឝយិតុំ ចេឞ្ដនតេ, ឯតាំ កថាម៑ ឥស្រាយេលីយលោកានាំ វិរុទ្ធម៑ ឯលិយ ឦឝ្វរាយ និវេទយាមាស។ ");
INSERT INTO sankhm_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","តតស្តំ ប្រតីឝ្វរស្យោត្តរំ កិំ ជាតំ? ពាល្នាម្នោ ទេវស្យ សាក្ឞាត៑ យៃ រ្ជានូនិ ន បាតិតានិ តាទ្ឫឝាះ សប្ត សហស្រាណិ លោកា អវឝេឞិតា មយា។ ");
INSERT INTO sankhm_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","តទ្វទ៑ ឯតស្មិន៑ វត៌្តមានកាលេៜបិ អនុគ្រហេណាភិរុចិតាស្តេឞាម៑ អវឝិឞ្ដាះ កតិបយា លោកាះ សន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","អតឯវ តទ៑ យទ្យនុគ្រហេណ ភវតិ តហ៌ិ ក្រិយយា ន ភវតិ នោ ចេទ៑ អនុគ្រហោៜននុគ្រហ ឯវ, យទិ វា ក្រិយយា ភវតិ តហ៌្យនុគ្រហេណ ន ភវតិ នោ ចេត៑ ក្រិយា ក្រិយៃវ ន ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","តហ៌ិ កិំ? ឥស្រាយេលីយលោកា យទ៑ អម្ឫគយន្ត តន្ន ប្រាបុះ។ កិន្ត្វភិរុចិតលោកាស្តត៑ ប្រាបុស្តទន្យេ សវ៌្វ អន្ធីភូតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","យថា លិខិតម៑ អាស្តេ, ឃោរនិទ្រាលុតាភាវំ ទ្ឫឞ្ដិហីនេ ច លោចនេ។ កណ៌ៅ ឝ្រុតិវិហីនៅ ច ប្រទទៅ តេភ្យ ឦឝ្វរះ៕ ");
INSERT INTO sankhm_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","ឯតេស្មិន៑ ទាយូទបិ លិខិតវាន៑ យថា, អតោ ភុក្ត្យាសនំ តេឞាម៑ ឧន្មាថវទ៑ ភវិឞ្យតិ។ វា វំឝយន្ត្រវទ៑ ពាធា ទណ្ឌវទ៑ វា ភវិឞ្យតិ៕ ");
INSERT INTO sankhm_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","ភវិឞ្យន្តិ តថាន្ធាស្តេ នេត្រៃះ បឝ្យន្តិ នោ យថា។ វេបថុះ កដិទេឝស្យ តេឞាំ និត្យំ ភវិឞ្យតិ៕ ");
INSERT INTO sankhm_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","បតនាត៌្ហំ តេ ស្ខលិតវន្ត ឥតិ វាចំ កិមហំ វទាមិ? តន្ន ភវតុ កិន្តុ តាន៑ ឧទ្យោគិនះ កត៌្តុំ តេឞាំ បតនាទ៑ ឥតរទេឝីយលោកៃះ បរិត្រាណំ ប្រាប្តំ។ ");
INSERT INTO sankhm_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","តេឞាំ បតនំ យទិ ជគតោ លោកានាំ លាភជនកម៑ អភវត៑ តេឞាំ ហ្រាសោៜបិ យទិ ភិន្នទេឝិនាំ លាភជនកោៜភវត៑ តហ៌ិ តេឞាំ វ្ឫទ្ធិះ កតិ លាភជនិកា ភវិឞ្យតិ? ");
INSERT INTO sankhm_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","អតោ ហេ អន្យទេឝិនោ យុឞ្មាន៑ សម្ពោធ្យ កថយាមិ និជានាំ ជ្ញាតិពន្ធូនាំ មនះសូទ្យោគំ ជនយន៑ តេឞាំ មធ្យេ កិយតាំ លោកានាំ យថា បរិត្រាណំ សាធយាមិ ");
INSERT INTO sankhm_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","តន្និមិត្តម៑ អន្យទេឝិនាំ និកដេ ប្រេរិតះ សន៑ អហំ ស្វបទស្យ មហិមានំ ប្រកាឝយាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","តេឞាំ និគ្រហេណ យទីឝ្វរេណ សហ ជគតោ ជនានាំ មេលនំ ជាតំ តហ៌ិ តេឞាម៑ អនុគ្ឫហីតត្វំ ម្ឫតទេហេ យថា ជីវនលាភស្តទ្វត៑ កិំ ន ភវិឞ្យតិ? ");
INSERT INTO sankhm_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","អបរំ ប្រថមជាតំ ផលំ យទិ បវិត្រំ ភវតិ តហ៌ិ សវ៌្វមេវ ផលំ បវិត្រំ ភវិឞ្យតិ; តថា មូលំ យទិ បវិត្រំ ភវតិ តហ៌ិ ឝាខា អបិ តថៃវ ភវិឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","កិយតីនាំ ឝាខានាំ ឆេទនេ ក្ឫតេ ត្វំ វន្យជិតវ្ឫក្ឞស្យ ឝាខា ភូត្វា យទិ តច្ឆាខានាំ ស្ថានេ រោបិតា សតិ ជិតវ្ឫក្ឞីយមូលស្យ រសំ ភុំក្ឞេ, ");
INSERT INTO sankhm_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","តហ៌ិ តាសាំ ភិន្នឝាខានាំ វិរុទ្ធំ មាំ គវ៌្វីះ; យទិ គវ៌្វសិ តហ៌ិ ត្វំ មូលំ យន្ន ធារយសិ កិន្តុ មូលំ ត្វាំ ធារយតីតិ សំស្មរ។ ");
INSERT INTO sankhm_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","អបរញ្ច យទិ វទសិ មាំ រោបយិតុំ តាះ ឝាខា វិភន្នា អភវន៑; ");
INSERT INTO sankhm_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","ភទ្រម៑, អប្រត្យយការណាត៑ តេ វិភិន្នា ជាតាស្តថា វិឝ្វាសការណាត៑ ត្វំ រោបិតោ ជាតស្តស្មាទ៑ អហង្ការម៑ អក្ឫត្វា សសាធ្វសោ ភវ។ ");
INSERT INTO sankhm_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","យត ឦឝ្វរោ យទិ ស្វាភាវិកីះ ឝាខា ន រក្ឞតិ តហ៌ិ សាវធានោ ភវ ចេត៑ ត្វាមបិ ន ស្ថាបយតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","ឥត្យត្រេឝ្វរស្យ យាទ្ឫឝី ក្ឫបា តាទ្ឫឝំ ភយានកត្វមបិ ត្វយា ទ្ឫឝ្យតាំ; យេ បតិតាស្តាន៑ ប្រតិ តស្យ ភយានកត្វំ ទ្ឫឝ្យតាំ, ត្វញ្ច យទិ តត្ក្ឫបាឝ្រិតស្តិឞ្ឋសិ តហ៌ិ ត្វាំ ប្រតិ ក្ឫបា ទ្រក្ឞ្យតេ; នោ ចេត៑ ត្វមបិ តទ្វត៑ ឆិន្នោ ភវិឞ្យសិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","អបរញ្ច តេ យទ្យប្រត្យយេ ន តិឞ្ឋន្តិ តហ៌ិ បុនរបិ រោបយិឞ្យន្តេ យស្មាត៑ តាន៑ បុនរបិ រោបយិតុម៑ ឥឝ្វរស្យ ឝក្តិរាស្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","វន្យជិតវ្ឫក្ឞស្យ ឝាខា សន៑ ត្វំ យទិ តតឝ្ឆិន្នោ រីតិវ្យត្យយេនោត្តមជិតវ្ឫក្ឞេ រោेेបិតោៜភវស្តហ៌ិ តស្យ វ្ឫក្ឞស្យ ស្វីយា យាះ ឝាខាស្តាះ កិំ បុនះ ស្វវ្ឫក្ឞេ សំលគិតុំ ន ឝក្នុវន្តិ? ");
INSERT INTO sankhm_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","ហេ ភ្រាតរោ យុឞ្មាកម៑ អាត្មាភិមានោ យន្ន ជាយតេ តទត៌្ហំ មមេទ្ឫឝី វាញ្ឆា ភវតិ យូយំ ឯតន្និគូឍតត្ត្វម៑ អជានន្តោ យន្ន តិឞ្ឋថ; វស្តុតោ យាវត្កាលំ សម្បូណ៌រូបេណ ភិន្នទេឝិនាំ សំគ្រហោ ន ភវិឞ្យតិ តាវត្កាលម៑ អំឝត្វេន ឥស្រាយេលីយលោកានាម៑ អន្ធតា ស្ថាស្យតិ; ");
INSERT INTO sankhm_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","បឝ្ចាត៑ តេ សវ៌្វេ បរិត្រាស្យន្តេ; ឯតាទ្ឫឝំ លិខិតមប្យាស្តេ, អាគមិឞ្យតិ សីយោនាទ៑ ឯកោ យស្ត្រាណទាយកះ។ អធម៌្មំ យាកុពោ វំឝាត៑ ស តុ ទូរីករិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","តថា ទូរីករិឞ្យាមិ តេឞាំ បាបាន្យហំ យទា។ តទា តៃរេវ សាទ៌្ធំ មេ និយមោៜយំ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","សុសំវាទាត៑ តេ យុឞ្មាកំ វិបក្ឞា អភវន៑ កិន្ត្វភិរុចិតត្វាត៑ តេ បិត្ឫលោកានាំ ក្ឫតេ ប្រិយបាត្រាណិ ភវន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","យត ឦឝ្វរស្យ ទានាទ៑ អាហ្វានាញ្ច បឝ្ចាត្តាបោ ន ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","អតឯវ បូវ៌្វម៑ ឦឝ្វរេៜវិឝ្វាសិនះ សន្តោៜបិ យូយំ យទ្វត៑ សម្ប្រតិ តេឞាម៑ អវិឝ្វាសការណាទ៑ ឦឝ្វរស្យ ក្ឫបាបាត្រាណិ ជាតាស្តទ្វទ្ ");
INSERT INTO sankhm_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","ឥទានីំ តេៜវិឝ្វាសិនះ សន្តិ កិន្តុ យុឞ្មាភិ រ្លព្ធក្ឫបាការណាត៑ តៃរបិ ក្ឫបា លប្ស្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","ឦឝ្វរះ សវ៌្វាន៑ ប្រតិ ក្ឫបាំ ប្រកាឝយិតុំ សវ៌្វាន៑ អវិឝ្វាសិត្វេន គណយតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","អហោ ឦឝ្វរស្យ ជ្ញានពុទ្ធិរូបយោ រ្ធនយោះ កីទ្ឫក៑ ប្រាចុយ៌្យំ។ តស្យ រាជឝាសនស្យ តត្ត្វំ កីទ្ឫគ៑ អប្រាប្យំ។ តស្យ មាគ៌ាឝ្ច កីទ្ឫគ៑ អនុបលក្ឞ្យាះ។ ");
INSERT INTO sankhm_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","បរមេឝ្វរស្យ សង្កល្បំ កោ ជ្ញាតវាន៑? តស្យ មន្ត្រី វា កោៜភវត៑? ");
INSERT INTO sankhm_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","កោ វា តស្យោបការី ភ្ឫត្វា តត្ក្ឫតេ តេន ប្រត្យុបកត៌្តវ្យះ? ");
INSERT INTO sankhm_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","យតោ វស្តុមាត្រមេវ តស្មាត៑ តេន តស្មៃ ចាភវត៑ តទីយោ មហិមា សវ៌្វទា ប្រកាឝិតោ ភវតុ។ ឥតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","ហេ ភ្រាតរ ឦឝ្វរស្យ ក្ឫបយាហំ យុឞ្មាន៑ វិនយេ យូយំ ស្វំ ស្វំ ឝរីរំ សជីវំ បវិត្រំ គ្រាហ្យំ ពលិម៑ ឦឝ្វរមុទ្ទិឝ្យ សមុត្ស្ឫជត, ឯឞា សេវា យុឞ្មាកំ យោគ្យា។ ");
INSERT INTO sankhm_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","អបរំ យូយំ សាំសារិកា ឥវ មាចរត, កិន្តុ ស្វំ ស្វំ ស្វភាវំ បរាវត៌្យ នូតនាចារិណោ ភវត, តត ឦឝ្វរស្យ និទេឝះ កីទ្ឫគ៑ ឧត្តមោ គ្រហណីយះ សម្បូណ៌ឝ្ចេតិ យុឞ្មាភិរនុភាវិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","កឝ្ចិទបិ ជនោ យោគ្យត្វាទធិកំ ស្វំ ន មន្យតាំ កិន្តុ ឦឝ្វរោ យស្មៃ ប្រត្យយស្យ យត្បរិមាណម៑ អទទាត៑ ស តទនុសារតោ យោគ្យរូបំ ស្វំ មនុតាម៑, ឦឝ្វរាទ៑ អនុគ្រហំ ប្រាប្តះ សន៑ យុឞ្មាកម៑ ឯកៃកំ ជនម៑ ឥត្យាជ្ញាបយាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","យតោ យទ្វទស្មាកម៑ ឯកស្មិន៑ ឝរីរេ ពហូន្យង្គានិ សន្តិ កិន្តុ សវ៌្វេឞាមង្គានាំ កាយ៌្យំ សមានំ នហិ; ");
INSERT INTO sankhm_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","តទ្វទស្មាកំ ពហុត្វេៜបិ សវ៌្វេ វយំ ខ្រីឞ្ដេ ឯកឝរីរាះ បរស្បរម៑ អង្គប្រត្យង្គត្វេន ភវាមះ។ ");
INSERT INTO sankhm_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","អស្មាទ៑ ឦឝ្វរានុគ្រហេណ វិឝេឞំ វិឝេឞំ ទានម៑ អស្មាសុ ប្រាប្តេឞុ សត្សុ កោបិ យទិ ភវិឞ្យទ្វាក្យំ វទតិ តហ៌ិ ប្រត្យយស្យ បរិមាណានុសារតះ ស តទ៑ វទតុ; ");
INSERT INTO sankhm_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","យទ្វា យទិ កឝ្ចិត៑ សេវនការី ភវតិ តហ៌ិ ស តត្សេវនំ ករោតុ; អថវា យទិ កឝ្ចិទ៑ អធ្យាបយិតា ភវតិ តហ៌ិ សោៜធ្យាបយតុ; ");
INSERT INTO sankhm_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","តថា យ ឧបទេឞ្ដា ភវតិ ស ឧបទិឝតុ យឝ្ច ទាតា ស សរលតយា ទទាតុ យស្ត្វធិបតិះ ស យត្នេនាធិបតិត្វំ ករោតុ យឝ្ច ទយាលុះ ស ហ្ឫឞ្ដមនសា ទយតាម៑។ ");
INSERT INTO sankhm_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","អបរញ្ច យុឞ្មាកំ ប្រេម កាបដ្យវជ៌ិតំ ភវតុ យទ៑ អភទ្រំ តទ៑ ឫតីយធ្វំ យច្ច ភទ្រំ តស្មិន៑ អនុរជ្យធ្វម៑។ ");
INSERT INTO sankhm_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","អបរំ ភ្រាត្ឫត្វប្រេម្នា បរស្បរំ ប្រីយធ្វំ សមាទរាទ៑ ឯកោៜបរជនំ ឝ្រេឞ្ឋំ ជានីធ្វម៑។ ");
INSERT INTO sankhm_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","តថា កាយ៌្យេ និរាលស្យា មនសិ ច សោទ្យោគាះ សន្តះ ប្រភុំ សេវធ្វម៑។ ");
INSERT INTO sankhm_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","អបរំ ប្រត្យាឝាយាម៑ អានន្ទិតា ទុះខសមយេ ច ធៃយ៌្យយុក្តា ភវត; ប្រាត៌្ហនាយាំ សតតំ ប្រវត៌្តធ្វំ។ ");
INSERT INTO sankhm_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","បវិត្រាណាំ ទីនតាំ ទូរីកុរុធ្វម៑ អតិថិសេវាយាម៑ អនុរជ្យធ្វម៑។ ");
INSERT INTO sankhm_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","យេ ជនា យុឞ្មាន៑ តាឌយន្តិ តាន៑ អាឝិឞំ វទត ឝាបម៑ អទត្ត្វា ទទ្ធ្វមាឝិឞម៑។ ");
INSERT INTO sankhm_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","យេ ជនា អានន្ទន្តិ តៃះ សាទ៌្ធម៑ អានន្ទត យេ ច រុទន្តិ តៃះ សហ រុទិត។ ");
INSERT INTO sankhm_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","អបរញ្ច យុឞ្មាកំ មនសាំ បរស្បរម៑ ឯកោភាវោ ភវតុ; អបរម៑ ឧច្ចបទម៑ អនាកាង្ក្ឞ្យ នីចលោកៃះ សហាបិ មាទ៌វម៑ អាចរត; ស្វាន៑ ជ្ញានិនោ ន មន្យធ្វំ។ ");
INSERT INTO sankhm_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","បរស្មាទ៑ អបការំ ប្រាប្យាបិ បរំ នាបកុរុត។ សវ៌្វេឞាំ ទ្ឫឞ្ដិតោ យត៑ កម៌្មោត្តមំ តទេវ កុរុត។ ");
INSERT INTO sankhm_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","យទិ ភវិតុំ ឝក្យតេ តហ៌ិ យថាឝក្តិ សវ៌្វលោកៃះ សហ និវ៌្វិរោធេន កាលំ យាបយត។ ");
INSERT INTO sankhm_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","ហេ ប្រិយពន្ធវះ, កស្មៃចិទ៑ អបការស្យ សមុចិតំ ទណ្ឌំ ស្វយំ ន ទទ្ធ្វំ, កិន្ត្វីឝ្វរីយក្រោធាយ ស្ថានំ ទត្ត យតោ លិខិតមាស្តេ បរមេឝ្វរះ កថយតិ, ទានំ ផលស្យ មត្កម៌្ម សូចិតំ ប្រទទាម្យហំ។ ");
INSERT INTO sankhm_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","ឥតិការណាទ៑ រិបុ រ្យទិ ក្ឞុធាត៌្តស្តេ តហ៌ិ តំ ត្វំ ប្រភោជយ។ តថា យទិ ត្ឫឞាត៌្តះ ស្យាត៑ តហ៌ិ តំ បរិបាយយ។ តេន ត្វំ មស្តកេ តស្យ ជ្វលទគ្និំ និធាស្យសិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","កុក្រិយយា បរាជិតា ន សន្ត ឧត្តមក្រិយយា កុក្រិយាំ បរាជយត។ ");
INSERT INTO sankhm_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","យុឞ្មាកម៑ ឯកៃកជនះ ឝាសនបទស្យ និឃ្នោ ភវតុ យតោ យានិ ឝាសនបទានិ សន្តិ តានិ សវ៌្វាណីឝ្វរេណ ស្ថាបិតានិ; ឦឝ្វរំ វិនា បទស្ថាបនំ ន ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","ឥតិ ហេតោះ ឝាសនបទស្យ យត៑ ប្រាតិកូល្យំ តទ៑ ឦឝ្វរីយនិរូបណស្យ ប្រាតិកូល្យមេវ; អបរំ យេ ប្រាតិកូល្យម៑ អាចរន្តិ តេ ស្វេឞាំ សមុចិតំ ទណ្ឌំ ស្វយមេវ ឃដយន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","ឝាស្តា សទាចារិណាំ ភយប្រទោ នហិ ទុរាចារិណាមេវ ភយប្រទោ ភវតិ; ត្វំ កិំ តស្មាន៑ និព៌្ហយោ ភវិតុម៑ ឥច្ឆសិ? តហ៌ិ សត្កម៌្មាចរ, តស្មាទ៑ យឝោ លប្ស្យសេ, ");
INSERT INTO sankhm_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","យតស្តវ សទាចរណាយ ស ឦឝ្វរស្យ ភ្ឫត្យោៜស្តិ។ កិន្តុ យទិ កុកម៌្មាចរសិ តហ៌ិ ត្វំ ឝង្កស្វ យតះ ស និរត៌្ហកំ ខង្គំ ន ធារយតិ; កុកម៌្មាចារិណំ សមុចិតំ ទណ្ឌយិតុម៑ ស ឦឝ្វរស្យ ទណ្ឌទភ្ឫត្យ ឯវ។ ");
INSERT INTO sankhm_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","អតឯវ កេវលទណ្ឌភយាន្នហិ កិន្តុ សទសទ្ពោធាទបិ តស្យ វឝ្យេន ភវិតវ្យំ។ ");
INSERT INTO sankhm_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","ឯតស្មាទ៑ យុឞ្មាកំ រាជករទានមប្យុចិតំ យស្មាទ៑ យេ ករំ គ្ឫហ្លន្តិ ត ឦឝ្វរស្យ កិង្ករា ភូត្វា សតតម៑ ឯតស្មិន៑ កម៌្មណិ និវិឞ្ដាស្តិឞ្ឋន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","អស្មាត៑ ករគ្រាហិណេ ករំ ទត្ត, តថា ឝុល្កគ្រាហិណេ ឝុល្កំ ទត្ត, អបរំ យស្មាទ៑ ភេតវ្យំ តស្មាទ៑ ពិភីត, យឝ្ច សមាទរណីយស្តំ សមាទ្រិយធ្វម៑; ឥត្ថំ យស្យ យត៑ ប្រាប្យំ តត៑ តស្មៃ ទត្ត។ ");
INSERT INTO sankhm_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","យុឞ្មាកំ បរស្បរំ ប្រេម វិនា ៜន្យត៑ កិមបិ ទេយម៑ ឫណំ ន ភវតុ, យតោ យះ បរស្មិន៑ ប្រេម ករោតិ តេន វ្យវស្ថា សិធ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","វស្តុតះ បរទារាន៑ មា គច្ឆ, នរហត្យាំ មា កាឞ៌ីះ, ចៃយ៌្យំ មា កាឞ៌ីះ, មិថ្យាសាក្ឞ្យំ មា ទេហិ, លោភំ មា កាឞ៌ីះ, ឯតាះ សវ៌្វា អាជ្ញា ឯតាភ្យោ ភិន្នា យា កាចិទ៑ អាជ្ញាស្តិ សាបិ ស្វសមីបវាសិនិ ស្វវត៑ ប្រេម កុវ៌្វិត្យនេន វចនេន វេទិតា។ ");
INSERT INTO sankhm_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","យតះ ប្រេម សមីបវាសិនោៜឝុភំ ន ជនយតិ តស្មាត៑ ប្រេម្នា សវ៌្វា វ្យវស្ថា បាល្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","ប្រត្យយីភវនកាលេៜស្មាកំ បរិត្រាណស្យ សាមីប្យាទ៑ ឥទានីំ តស្យ សាមីប្យម៑ អវ្យវហិតំ; អតះ សមយំ វិវិច្យាស្មាភិះ សាម្ប្រតម៑ អវឝ្យមេវ និទ្រាតោ ជាគត៌្តវ្យំ។ ");
INSERT INTO sankhm_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","ពហុតរា យាមិនី គតា ប្រភាតំ សន្និធិំ ប្រាប្តំ តស្មាត៑ តាមសីយាះ ក្រិយាះ បរិត្យជ្យាស្មាភិ រ្វាសរីយា សជ្ជា បរិធាតវ្យា។ ");
INSERT INTO sankhm_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","អតោ ហេតោ រ្វយំ ទិវា វិហិតំ សទាចរណម៑ អាចរិឞ្យាមះ។ រង្គរសោ មត្តត្វំ លម្បដត្វំ កាមុកត្វំ វិវាទ ឦឞ៌្យា ចៃតានិ បរិត្យក្ឞ្យាមះ។ ");
INSERT INTO sankhm_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","យូយំ ប្រភុយីឝុខ្រីឞ្ដរូបំ បរិច្ឆទំ បរិធទ្ធ្វំ សុខាភិលាឞបូរណាយ ឝារីរិកាចរណំ មាចរត។ ");
INSERT INTO sankhm_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","យោ ជនោៜទ្ឫឍវិឝ្វាសស្តំ យុឞ្មាកំ សង្គិនំ កុរុត កិន្តុ សន្ទេហវិចារាត៌្ហំ នហិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","យតោ និឞិទ្ធំ កិមបិ ខាទ្យទ្រវ្យំ នាស្តិ, កស្យចិជ្ជនស្យ ប្រត្យយ ឯតាទ្ឫឝោ វិទ្យតេ កិន្ត្វទ្ឫឍវិឝ្វាសះ កឝ្ចិទបរោ ជនះ កេវលំ ឝាកំ ភុង្ក្តំ។ ");
INSERT INTO sankhm_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","តហ៌ិ យោ ជនះ សាធារណំ ទ្រវ្យំ ភុង្ក្តេ ស វិឝេឞទ្រវ្យភោក្តារំ នាវជានីយាត៑ តថា វិឝេឞទ្រវ្យភោក្តាបិ សាធារណទ្រវ្យភោក្តារំ ទោឞិណំ ន កុយ៌្យាត៑, យស្មាទ៑ ឦឝ្វរស្តម៑ អគ្ឫហ្លាត៑។ ");
INSERT INTO sankhm_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","ហេ បរទាសស្យ ទូឞយិតស្ត្វំ កះ? និជប្រភោះ សមីបេ តេន បទស្ថេន បទច្យុតេន វា ភវិតវ្យំ ស ច បទស្ថ ឯវ ភវិឞ្យតិ យត ឦឝ្វរស្តំ បទស្ថំ កត៌្តុំ ឝក្នោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","អបរញ្ច កឝ្ចិជ្ជនោ ទិនាទ៑ ទិនំ វិឝេឞំ មន្យតេ កឝ្ចិត្តុु សវ៌្វាណិ ទិនានិ សមានានិ មន្យតេ, ឯកៃកោ ជនះ ស្វីយមនសិ វិវិច្យ និឝ្ចិនោតុ។ ");
INSERT INTO sankhm_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","យោ ជនះ កិញ្ចន ទិនំ វិឝេឞំ មន្យតេ ស ប្រភុភក្ត្យា តន៑ មន្យតេ, យឝ្ច ជនះ កិមបិ ទិនំ វិឝេឞំ ន មន្យតេ សោៜបិ ប្រភុភក្ត្យា តន្ន មន្យតេ; អបរញ្ច យះ សវ៌្វាណិ ភក្ឞ្យទ្រវ្យាណិ ភុង្ក្តេ ស ប្រភុភក្តយា តានិ ភុង្ក្តេ យតះ ស ឦឝ្វរំ ធន្យំ វក្តិ, យឝ្ច ន ភុង្ក្តេ សោៜបិ ប្រភុភក្ត្យៃវ ន ភុញ្ជាន ឦឝ្វរំ ធន្យំ ព្រូតេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","អបរម៑ អស្មាកំ កឝ្ចិត៑ និជនិមិត្តំ ប្រាណាន៑ ធារយតិ និជនិមិត្តំ ម្រិយតេ វា តន្ន; ");
INSERT INTO sankhm_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","កិន្តុ យទិ វយំ ប្រាណាន៑ ធារយាមស្តហ៌ិ ប្រភុនិមិត្តំ ធារយាមះ, យទិ ច ប្រាណាន៑ ត្យជាមស្តហ៌្យបិ ប្រភុនិមិត្តំ ត្យជាមះ, អតឯវ ជីវនេ មរណេ វា វយំ ប្រភោរេវាស្មហេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","យតោ ជីវន្តោ ម្ឫតាឝ្ចេត្យុភយេឞាំ លោកានាំ ប្រភុត្វប្រាប្ត្យត៌្ហំ ខ្រីឞ្ដោ ម្ឫត ឧត្ថិតះ បុនជ៌ីវិតឝ្ច។ ");
INSERT INTO sankhm_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","កិន្តុ ត្វំ និជំ ភ្រាតរំ កុតោ ទូឞយសិ? តថា ត្វំ និជំ ភ្រាតរំ កុតស្តុច្ឆំ ជានាសិ? ខ្រីឞ្ដស្យ វិចារសិំហាសនស្យ សម្មុខេ សវ៌្វៃរស្មាភិរុបស្ថាតវ្យំ; ");
INSERT INTO sankhm_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","យាទ្ឫឝំ លិខិតម៑ អាស្តេ, បរេឝះ ឝបថំ កុវ៌្វន៑ វាក្យមេតត៑ បុរាវទត៑។ សវ៌្វោ ជនះ សមីបេ មេ ជានុបាតំ ករិឞ្យតិ។ ជិហ្វៃកៃកា តថេឝស្យ និឃ្នត្វំ ស្វីករិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","អតឯវ ឦឝ្វរសមីបេៜស្មាកម៑ ឯកៃកជនេន និជា កថា កថយិតវ្យា។ ");
INSERT INTO sankhm_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","ឥត្ថំ សតិ វយម៑ អទ្យារភ្យ បរស្បរំ ន ទូឞយន្តះ ស្វភ្រាតុ រ្វិឃ្នោ វ្យាឃាតោ វា យន្ន ជាយេត តាទ្ឫឝីមីហាំ កុម៌្មហេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","កិមបិ វស្តុ ស្វភាវតោ នាឝុចិ ភវតីត្យហំ ជានេ តថា ប្រភុនា យីឝុខ្រីឞ្ដេនាបិ និឝ្ចិតំ ជានេ, កិន្តុ យោ ជនោ យទ៑ ទ្រវ្យម៑ អបវិត្រំ ជានីតេ តស្យ ក្ឫតេ តទ៑ អបវិត្រម៑ អាស្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","អតឯវ តវ ភក្ឞ្យទ្រវ្យេណ តវ ភ្រាតា ឝោកាន្វិតោ ភវតិ តហ៌ិ ត្វំ ភ្រាតរំ ប្រតិ ប្រេម្នា នាចរសិ។ ខ្រីឞ្ដោ យស្យ ក្ឫតេ ស្វប្រាណាន៑ វ្យយិតវាន៑ ត្វំ និជេន ភក្ឞ្យទ្រវ្យេណ តំ ន នាឝយ។ ");
INSERT INTO sankhm_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","អបរំ យុឞ្មាកម៑ ឧត្តមំ កម៌្ម និន្ទិតំ ន ភវតុ។ ");
INSERT INTO sankhm_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","ភក្ឞ្យំ បេយញ្ចេឝ្វររាជ្យស្យ សារោ នហិ, កិន្តុ បុណ្យំ ឝាន្តិឝ្ច បវិត្រេណាត្មនា ជាត អានន្ទឝ្ច។ ");
INSERT INTO sankhm_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","ឯតៃ រ្យោ ជនះ ខ្រីឞ្ដំ សេវតេ, ស ឯវេឝ្វរស្យ តុឞ្ដិករោ មនុឞ្យៃឝ្ច សុខ្យាតះ។ ");
INSERT INTO sankhm_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","អតឯវ យេនាស្មាកំ សវ៌្វេឞាំ បរស្បរម៑ ឰក្យំ និឞ្ឋា ច ជាយតេ តទេវាស្មាភិ រ្យតិតវ្យំ។ ");
INSERT INTO sankhm_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","ភក្ឞ្យាត៌្ហម៑ ឦឝ្វរស្យ កម៌្មណោ ហានិំ មា ជនយត; សវ៌្វំ វស្តុ បវិត្រមិតិ សត្យំ តថាបិ យោ ជនោ យទ៑ ភុក្ត្វា វិឃ្នំ លភតេ តទត៌្ហំ តទ៑ ភទ្រំ នហិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","តវ មាំសភក្ឞណសុរាបានាទិភិះ ក្រិយាភិ រ្យទិ តវ ភ្រាតុះ បាទស្ខលនំ វិឃ្នោ វា ចាញ្ចល្យំ វា ជាយតេ តហ៌ិ តទ្ភោជនបានយោស្ត្យាគោ ភទ្រះ។ ");
INSERT INTO sankhm_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","យទិ តវ ប្រត្យយស្តិឞ្ឋតិ តហ៌ីឝ្វរស្យ គោចរេ ស្វាន្តរេ តំ គោបយ; យោ ជនះ ស្វមតេន ស្វំ ទោឞិណំ ន ករោតិ ស ឯវ ធន្យះ។ ");
INSERT INTO sankhm_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","កិន្តុ យះ កឝ្ចិត៑ សំឝយ្យ ភុង្ក្តេៜរ្ថាត៑ ន ប្រតីត្យ ភុង្ក្តេ, ស ឯវាវឝ្យំ ទណ្ឌាហ៌ោ ភវិឞ្យតិ, យតោ យត៑ ប្រត្យយជំ នហិ តទេវ បាបមយំ ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","ពលវទ្ភិរស្មាភិ រ្ទុព៌្ពលានាំ ទៅព៌្ពល្យំ សោឍវ្យំ ន ច ស្វេឞាម៑ ឥឞ្ដាចារ អាចរិតវ្យះ។ ");
INSERT INTO sankhm_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","អស្មាកម៑ ឯកៃកោ ជនះ ស្វសមីបវាសិនោ ហិតាត៌្ហំ និឞ្ឋាត៌្ហញ្ច តស្យៃវេឞ្ដាចារម៑ អាចរតុ។ ");
INSERT INTO sankhm_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","យតះ ខ្រីឞ្ដោៜបិ និជេឞ្ដាចារំ នាចរិតវាន៑, យថា លិខិតម៑ អាស្តេ, ត្វន្និន្ទកគណស្យៃវ និន្ទាភិ រ្និន្ទិតោៜស្ម្យហំ។ ");
INSERT INTO sankhm_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","អបរញ្ច វយំ យត៑ សហិឞ្ណុតាសាន្ត្វនយោ រ្ជនកេន ឝាស្ត្រេណ ប្រត្យាឝាំ លភេមហិ តន្និមិត្តំ បូវ៌្វកាលេ លិខិតានិ សវ៌្វវចនាន្យស្មាកម៑ ឧបទេឝាត៌្ហមេវ លិលិខិរេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","សហិឞ្ណុតាសាន្ត្វនយោរាករោ យ ឦឝ្វរះ ស ឯវំ ករោតុ យត៑ ប្រភុ រ្យីឝុខ្រីឞ្ដ ឥវ យុឞ្មាកម៑ ឯកជនោៜន្យជនេន សាទ៌្ធំ មនស ឰក្យម៑ អាចរេត៑; ");
INSERT INTO sankhm_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","យូយញ្ច សវ៌្វ ឯកចិត្តា ភូត្វា មុខៃកេនេវាស្មត្ប្រភុយីឝុខ្រីឞ្ដស្យ បិតុរីឝ្វរស្យ គុណាន៑ កីត៌្តយេត។ ");
INSERT INTO sankhm_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","អបរម៑ ឦឝ្វរស្យ មហិម្នះ ប្រកាឝាត៌្ហំ ខ្រីឞ្ដោ យថា យុឞ្មាន៑ ប្រត្យគ្ឫហ្លាត៑ តថា យុឞ្មាកមប្យេកោ ជនោៜន្យជនំ ប្រតិគ្ឫហ្លាតុ។ ");
INSERT INTO sankhm_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","យថា លិខិតម៑ អាស្តេ, អតោៜហំ សម្មុខេ តិឞ្ឋន៑ ភិន្នទេឝនិវាសិនាំ។ ស្តុវំស្ត្វាំ បរិគាស្យាមិ តវ នាម្និ បរេឝ្វរ៕ ");
INSERT INTO sankhm_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","តស្យ ទយាលុត្វាច្ច ភិន្នជាតីយា យទ៑ ឦឝ្វរស្យ គុណាន៑ កីត៌្តយេយុស្តទត៌្ហំ យីឝុះ ខ្រីឞ្ដស្ត្វក្ឆេទនិយមស្យ និឃ្នោៜភវទ៑ ឥត្យហំ វទាមិ។ យថា លិខិតម៑ អាស្តេ, អតោៜហំ សម្មុខេ តិឞ្ឋន៑ ភិន្នទេឝនិវាសិនាំ។ ស្តុវំស្ត្វាំ បរិគាស្យាមិ តវ នាម្និ បរេឝ្វរ៕ ");
INSERT INTO sankhm_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","អបរមបិ លិខិតម៑ អាស្តេ, ហេ អន្យជាតយោ យូយំ សមំ នន្ទត តជ្ជនៃះ។ ");
INSERT INTO sankhm_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","បុនឝ្ច លិខិតម៑ អាស្តេ, ហេ សវ៌្វទេឝិនោ យូយំ ធន្យំ ព្រូត បរេឝ្វរំ។ ហេ តទីយនរា យូយំ កុរុធ្វំ តត្ប្រឝំសនំ៕ ");
INSERT INTO sankhm_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","អបរ យីឝាយិយោៜបិ លិលេខ, យីឝយស្យ តុ យត៑ មូលំ តត៑ ប្រកាឝិឞ្យតេ តទា។ សវ៌្វជាតីយន្ឫណាញ្ច ឝាសកះ សមុទេឞ្យតិ។ តត្រាន្យទេឝិលោកៃឝ្ច ប្រត្យាឝា ប្រករិឞ្យតេ៕ ");
INSERT INTO sankhm_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","អតឯវ យូយំ បវិត្រស្យាត្មនះ ប្រភាវាទ៑ យត៑ សម្បូណ៌ាំ ប្រត្យាឝាំ លប្ស្យធ្វេ តទត៌្ហំ តត្ប្រត្យាឝាជនក ឦឝ្វរះ ប្រត្យយេន យុឞ្មាន៑ ឝាន្ត្យានន្ទាភ្យាំ សម្បូណ៌ាន៑ ករោតុ។ ");
INSERT INTO sankhm_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","ហេ ភ្រាតរោ យូយំ សទ្ភាវយុក្តាះ សវ៌្វប្រការេណ ជ្ញានេន ច សម្បូណ៌ាះ បរស្បរោបទេឝេ ច តត្បរា ឥត្យហំ និឝ្ចិតំ ជានាមិ, ");
INSERT INTO sankhm_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","តថាប្យហំ យត៑ ប្រគល្ភតរោ ភវន៑ យុឞ្មាន៑ ប្រពោធយាមិ តស្យៃកំ ការណមិទំ។ ");
INSERT INTO sankhm_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","ភិន្នជាតីយាះ បវិត្រេណាត្មនា បាវិតនៃវេទ្យរូបា ភូត្វា យទ៑ គ្រាហ្យា ភវេយុស្តន្និមិត្តមហម៑ ឦឝ្វរស្យ សុសំវាទំ ប្រចារយិតុំ ភិន្នជាតីយានាំ មធ្យេ យីឝុខ្រីឞ្ដស្យ សេវកត្វំ ទានំ ឦឝ្វរាត៑ លព្ធវានស្មិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","ឦឝ្វរំ ប្រតិ យីឝុខ្រីឞ្ដេន មម ឝ្លាឃាករណស្យ ការណម៑ អាស្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","ភិន្នទេឝិន អាជ្ញាគ្រាហិណះ កត៌្តុំ ខ្រីឞ្ដោ វាក្យេន ក្រិយយា ច, អាឝ្ចយ៌្យលក្ឞណៃឝ្ចិត្រក្រិយាភិះ បវិត្រស្យាត្មនះ ប្រភាវេន ច យានិ កម៌្មាណិ មយា សាធិតវាន៑, ");
INSERT INTO sankhm_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","កេវលំ តាន្យេវ វិនាន្យស្យ កស្យចិត៑ កម៌្មណោ វណ៌នាំ កត៌្តុំ ប្រគល្ភោ ន ភវាមិ។ តស្មាត៑ អា យិរូឝាលម ឥល្លូរិកំ យាវត៑ សវ៌្វត្រ ខ្រីឞ្ដស្យ សុសំវាទំ ប្រាចារយំ។ ");
INSERT INTO sankhm_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","អន្យេន និចិតាយាំ ភិត្តាវហំ យន្ន និចិនោមិ តន្និមិត្តំ យត្រ យត្រ ស្ថានេ ខ្រីឞ្ដស្យ នាម កទាបិ កេនាបិ ន ជ្ញាបិតំ តត្រ តត្រ សុសំវាទំ ប្រចារយិតុម៑ អហំ យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","យាទ្ឫឝំ លិខិតម៑ អាស្តេ, យៃ រ្វាត៌្តា តស្យ ន ប្រាប្តា ទឝ៌នំ តៃស្តុ លប្ស្យតេ។ យៃឝ្ច នៃវ ឝ្រុតំ កិញ្ចិត៑ ពោទ្ធុំ ឝក្ឞ្យន្តិ តេ ជនាះ៕ ");
INSERT INTO sankhm_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","តស្មាទ៑ យុឞ្មត្សមីបគមនាទ៑ អហំ មុហុម៌ុហុ រ្និវារិតោៜភវំ។ ");
INSERT INTO sankhm_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","កិន្ត្វិទានីម៑ អត្រ ប្រទេឝេឞុ មយា ន គតំ ស្ថានំ កិមបិ នាវឝិឞ្យតេ យុឞ្មត្សមីបំ គន្តុំ ពហុវត្សរានារភ្យ មាមកីនាកាង្ក្ឞា ច វិទ្យត ឥតិ ហេតោះ ");
INSERT INTO sankhm_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","ស្បានិយាទេឝគមនកាលេៜហំ យុឞ្មន្មធ្យេន គច្ឆន៑ យុឞ្មាន៑ អាលោកិឞ្យេ, តតះ បរំ យុឞ្មត្សម្ភាឞណេន ត្ឫប្តិំ បរិលភ្យ តទ្ទេឝគមនាត៌្ហំ យុឞ្មាភិ រ្វិសជ៌យិឞ្យេ, ឦទ្ឫឝី មទីយា ប្រត្យាឝា វិទ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","កិន្តុ សាម្ប្រតំ បវិត្រលោកានាំ សេវនាយ យិរូឝាលម្នគរំ វ្រជាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","យតោ យិរូឝាលមស្ថបវិត្រលោកានាំ មធ្យេ យេ ទរិទ្រា អត៌្ហវិឝ្រាណនេន តានុបកត៌្តុំ មាកិទនិយាទេឝីយា អាខាយាទេឝីយាឝ្ច លោកា ឰច្ឆន៑។ ");
INSERT INTO sankhm_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","ឯឞា តេឞាំ សទិច្ឆា យតស្តេ តេឞាម៑ ឫណិនះ សន្តិ យតោ ហេតោ រ្ភិន្នជាតីយា យេឞាំ បរមាត៌្ហស្យាំឝិនោ ជាតា ឰហិកវិឞយេ តេឞាមុបការស្តៃះ កត៌្តវ្យះ។ ");
INSERT INTO sankhm_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","អតោ មយា តត៑ កម៌្ម សាធយិត្វា តស្មិន៑ ផលេ តេភ្យះ សមប៌ិតេ យុឞ្មន្មធ្យេន ស្បានិយាទេឝោ គមិឞ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","យុឞ្មត្សមីបេ មមាគមនសមយេ ខ្រីឞ្ដស្យ សុសំវាទស្យ បូណ៌វរេណ សម្ពលិតះ សន៑ អហម៑ អាគមិឞ្យាមិ ឥតិ មយា ជ្ញាយតេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","ហេ ភ្រាត្ឫគណ ប្រភោ រ្យីឝុខ្រីឞ្ដស្យ នាម្នា បវិត្រស្យាត្មានះ ប្រេម្នា ច វិនយេៜហំ ");
INSERT INTO sankhm_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","យិហូទាទេឝស្ថានាម៑ អវិឝ្វាសិលោកានាំ ករេភ្យោ យទហំ រក្ឞាំ លភេយ មទីយៃតេន សេវនកម៌្មណា ច យទ៑ យិរូឝាលមស្ថាះ បវិត្រលោកាស្តុឞ្យេយុះ, ");
INSERT INTO sankhm_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","តទត៌្ហំ យូយំ មត្ក្ឫត ឦឝ្វរាយ ប្រាត៌្ហយមាណា យតធ្វំ តេនាហម៑ ឦឝ្វរេច្ឆយា សានន្ទំ យុឞ្មត្សមីបំ គត្វា យុឞ្មាភិះ សហិតះ ប្រាណាន៑ អាប្យាយិតុំ បារយិឞ្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","ឝាន្តិទាយក ឦឝ្វរោ យុឞ្មាកំ សវ៌្វេឞាំ សង្គី ភូយាត៑។ ឥតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","កិំក្រីយានគរីយធម៌្មសមាជស្យ បរិចារិកា យា ផៃពីនាមិកាស្មាកំ ធម៌្មភគិនី តស្យាះ ក្ឫតេៜហំ យុឞ្មាន៑ និវេទយាមិ, ");
INSERT INTO sankhm_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","យូយំ តាំ ប្រភុមាឝ្រិតាំ វិជ្ញាយ តស្យា អាតិថ្យំ បវិត្រលោកាហ៌ំ កុរុធ្វំ, យុឞ្មត្តស្តស្យា យ ឧបការោ ភវិតុំ ឝក្នោតិ តំ កុរុធ្វំ, យស្មាត៑ តយា ពហូនាំ មម ចោបការះ ក្ឫតះ។ ");
INSERT INTO sankhm_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","អបរញ្ច ខ្រីឞ្ដស្យ យីឝោះ កម៌្មណិ មម សហការិណៅ មម ប្រាណរក្ឞាត៌្ហញ្ច ស្វប្រាណាន៑ បណីក្ឫតវន្តៅ យៅ ប្រិឞ្កិល្លាក្កិលៅ តៅ មម នមស្ការំ ជ្ញាបយធ្វំ។ ");
INSERT INTO sankhm_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","តាភ្យាម៑ ឧបការាប្តិះ កេវលំ មយា ស្វីកត៌្តវ្យេតិ នហិ ភិន្នទេឝីយៃះ សវ៌្វធម៌្មសមាជៃរបិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","អបរញ្ច តយោ រ្គ្ឫហេ ស្ថិតាន៑ ធម៌្មសមាជលោកាន៑ មម នមស្ការំ ជ្ញាបយធ្វំ។ តទ្វត៑ អាឝិយាទេឝេ ខ្រីឞ្ដស្យ បក្ឞេ ប្រថមជាតផលស្វរូបោ យ ឥបេនិតនាមា មម ប្រិយពន្ធុស្តមបិ មម នមស្ការំ ជ្ញាបយធ្វំ។ ");
INSERT INTO sankhm_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","អបរំ ពហុឝ្រមេណាស្មាន៑ អសេវត យា មរិយម៑ តាមបិ នមស្ការំ ជ្ញាបយធ្វំ។ ");
INSERT INTO sankhm_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","អបរញ្ច ប្រេរិតេឞុ ខ្យាតកីត៌្តី មទគ្រេ ខ្រីឞ្ដាឝ្រិតៅ មម ស្វជាតីយៅ សហពន្ទិនៅ ច យាវាន្ទ្រនីកយូនិយៅ តៅ មម នមស្ការំ ជ្ញាបយធ្វំ។ ");
INSERT INTO sankhm_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","តថា ប្រភៅ មត្ប្រិយតមម៑ អាម្ប្លិយមបិ មម នមស្ការំ ជ្ញាបយធ្វំ។ ");
INSERT INTO sankhm_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","អបរំ ខ្រីឞ្ដសេវាយាំ មម សហការិណម៑ ឩព៌្ពាណំ មម ប្រិយតមំ ស្តាខុញ្ច មម នមស្ការំ ជ្ញាបយធ្វំ។ ");
INSERT INTO sankhm_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","អបរំ ខ្រីឞ្ដេន បរីក្ឞិតម៑ អាបិល្លិំ មម នមស្ការំ វទត, អារិឞ្ដពូលស្យ បរិជនាំឝ្ច មម នមស្ការំ ជ្ញាបយធ្វំ។ ");
INSERT INTO sankhm_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","អបរំ មម ជ្ញាតិំ ហេរោទិយោនំ មម នមស្ការំ វទត, តថា នាក៌ិសស្យ បរិវារាណាំ មធ្យេ យេ ប្រភុមាឝ្រិតាស្តាន៑ មម នមស្ការំ វទត។ ");
INSERT INTO sankhm_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","អបរំ ប្រភោះ សេវាយាំ បរិឝ្រមការិណ្យៅ ត្រុផេនាត្រុផោឞេ មម នមស្ការំ វទត, តថា ប្រភោះ សេវាយាម៑ អត្យន្តំ បរិឝ្រមការិណី យា ប្រិយា បឞ៌ិស្តាំ នមស្ការំ ជ្ញាបយធ្វំ។ ");
INSERT INTO sankhm_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","អបរំ ប្រភោរភិរុចិតំ រូផំ មម ធម៌្មមាតា យា តស្យ មាតា តាមបិ នមស្ការំ វទត។ ");
INSERT INTO sankhm_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","អបរម៑ អសុំក្ឫតំ ផ្លិគោនំ ហម៌្មំ បាត្រពំ ហម៌្មិម៑ ឯតេឞាំ សង្គិភ្រាត្ឫគណញ្ច នមស្ការំ ជ្ញាបយធ្វំ។ ");
INSERT INTO sankhm_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","អបរំ ផិលលគោ យូលិយា នីរិយស្តស្យ ភគិន្យលុម្បា ចៃតាន៑ ឯតៃះ សាទ៌្ធំ យាវន្តះ បវិត្រលោកា អាសតេ តានបិ នមស្ការំ ជ្ញាបយធ្វំ។ ");
INSERT INTO sankhm_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","យូយំ បរស្បរំ បវិត្រចុម្ពនេន នមស្កុរុធ្វំ។ ខ្រីឞ្ដស្យ ធម៌្មសមាជគណោ យុឞ្មាន៑ នមស្កុរុតេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","ហេ ភ្រាតរោ យុឞ្មាន៑ វិនយេៜហំ យុឞ្មាភិ រ្យា ឝិក្ឞា លព្ធា តាម៑ អតិក្រម្យ យេ វិច្ឆេទាន៑ វិឃ្នាំឝ្ច កុវ៌្វន្តិ តាន៑ និឝ្ចិនុត តេឞាំ សង្គំ វជ៌យត ច។ ");
INSERT INTO sankhm_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","យតស្តាទ្ឫឝា លោកា អស្មាកំ ប្រភោ រ្យីឝុខ្រីឞ្ដស្យ ទាសា ឥតិ នហិ កិន្តុ ស្វោទរស្យៃវ ទាសាះ; អបរំ ប្រណយវចនៃ រ្មធុរវាក្យៃឝ្ច សរលលោកានាំ មនាំសិ មោហយន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","យុឞ្មាកម៑ អាជ្ញាគ្រាហិត្វំ សវ៌្វត្រ សវ៌្វៃ រ្ជ្ញាតំ តតោៜហំ យុឞ្មាសុ សានន្ទោៜភវំ តថាបិ យូយំ យត៑ សត្ជ្ញានេន ជ្ញានិនះ កុជ្ញានេे ចាតត្បរា ភវេតេតិ មមាភិលាឞះ។ ");
INSERT INTO sankhm_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","អធិកន្តុ ឝាន្តិទាយក ឦឝ្វរះ ឝៃតានម៑ អវិលម្ពំ យុឞ្មាកំ បទានាម៑ អធោ មទ៌្ទិឞ្យតិ។ អស្មាកំ ប្រភុ រ្យីឝុខ្រីឞ្ដោ យុឞ្មាសុ ប្រសាទំ ក្រិយាត៑។ ឥតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","មម សហការី តីមថិយោ មម ជ្ញាតយោ លូកិយោ យាសោន៑ សោសិបាត្រឝ្ចេមេ យុឞ្មាន៑ នមស្កុវ៌្វន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","អបរម៑ ឯតត្បត្រលេខកស្តត៌្តិយនាមាហមបិ ប្រភោ រ្នាម្នា យុឞ្មាន៑ នមស្ករោមិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","តថា ក្ឫត្ស្នធម៌្មសមាជស្យ មម ចាតិថ្យការី គាយោ យុឞ្មាន៑ នមស្ករោតិ។ អបរម៑ ឯតន្នគរស្យ ធនរក្ឞក ឥរាស្តះ ក្កាត៌្តនាមកឝ្ចៃកោ ភ្រាតា តាវបិ យុឞ្មាន៑ នមស្កុរុតះ។ ");
INSERT INTO sankhm_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","អស្មាកំ ប្រភុ រ្យីឝុខ្រីឞ្ដា យុឞ្មាសុ សវ៌្វេឞុ ប្រសាទំ ក្រិយាត៑។ ឥតិ។ ");
INSERT INTO sankhm_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","បូវ៌្វកាលិកយុគេឞុ ប្រច្ឆន្នា យា មន្ត្រណាធុនា ប្រកាឝិតា ភូត្វា ភវិឞ្យទ្វាទិលិខិតគ្រន្ថគណស្យ ប្រមាណាទ៑ វិឝ្វាសេន គ្រហណាត៌្ហំ សទាតនស្យេឝ្វរស្យាជ្ញយា សវ៌្វទេឝីយលោកាន៑ ជ្ញាប្យតេ, ");
INSERT INTO sankhm_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","តស្យា មន្ត្រណាយា ជ្ញានំ លព្ធ្វា មយា យះ សុសំវាទោ យីឝុខ្រីឞ្ដមធិ ប្រចាយ៌្យតេ, តទនុសារាទ៑ យុឞ្មាន៑ ធម៌្មេ សុស្ថិរាន៑ កត៌្តុំ សមត៌្ហោ យោៜទ្វិតីយះ ");
INSERT INTO sankhm_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","សវ៌្វជ្ញ ឦឝ្វរស្តស្យ ធន្យវាទោ យីឝុខ្រីឞ្ដេន សន្តតំ ភូយាត៑។ ឥតិ។ ");
INSERT INTO sankhm_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","យាវន្តះ បវិត្រា លោកាះ ស្វេឞាម៑ អស្មាកញ្ច វសតិស្ថានេឞ្វស្មាកំ ប្រភោ រ្យីឝោះ ខ្រីឞ្ដស្យ នាម្នា ប្រាត៌្ហយន្តេ តៃះ សហាហូតានាំ ខ្រីឞ្ដេន យីឝុនា បវិត្រីក្ឫតានាំ លោកានាំ យ ឦឝ្វរីយធម៌្មសមាជះ ករិន្ថនគរេ វិទ្យតេ ");
INSERT INTO sankhm_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","តំ ប្រតីឝ្វរស្យេច្ឆយាហូតោ យីឝុខ្រីឞ្ដស្យ ប្រេរិតះ បៅលះ សោស្ថិនិនាមា ភ្រាតា ច បត្រំ លិខតិ។ ");
INSERT INTO sankhm_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","អស្មាកំ បិត្រេឝ្វរេណ ប្រភុនា យីឝុខ្រីឞ្ដេន ច ប្រសាទះ ឝាន្តិឝ្ច យុឞ្មភ្យំ ទីយតាំ។ ");
INSERT INTO sankhm_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","ឦឝ្វរោ យីឝុខ្រីឞ្ដេន យុឞ្មាន៑ ប្រតិ ប្រសាទំ ប្រកាឝិតវាន៑, តស្មាទហំ យុឞ្មន្និមិត្តំ សវ៌្វទា មទីយេឝ្វរំ ធន្យំ វទាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","ខ្រីឞ្ដសម្ពន្ធីយំ សាក្ឞ្យំ យុឞ្មាកំ មធ្យេ យេន ប្រការេណ សប្រមាណម៑ អភវត្ ");
INSERT INTO sankhm_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","តេន យូយំ ខ្រីឞ្ដាត៑ សវ៌្វវិធវក្ត្ឫតាជ្ញានាទីនិ សវ៌្វធនានិ លព្ធវន្តះ។ ");
INSERT INTO sankhm_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","តតោៜស្មត្ប្រភោ រ្យីឝុខ្រីឞ្ដស្យ បុនរាគមនំ ប្រតីក្ឞមាណានាំ យុឞ្មាកំ កស្យាបិ វរស្យាភាវោ ន ភវតិ។ ");
INSERT INTO sankhm_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","អបរម៑ អស្មាកំ ប្រភោ រ្យីឝុខ្រីឞ្ដស្យ ទិវសេ យូយំ យន្និទ៌្ទោឞា ភវេត តទត៌្ហំ សឯវ យាវទន្តំ យុឞ្មាន៑ សុស្ថិរាន៑ ករិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","យ ឦឝ្វរះ ស្វបុត្រស្យាស្មត្ប្រភោ រ្យីឝុខ្រីឞ្ដស្យាំឝិនះ កត៌្តុំ យុឞ្មាន៑ អាហូតវាន៑ ស វិឝ្វសនីយះ។ ");
INSERT INTO sankhm_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","ហេ ភ្រាតរះ, អស្មាកំ ប្រភុយីឝុខ្រីឞ្ដស្យ នាម្នា យុឞ្មាន៑ វិនយេៜហំ សវ៌្វៃ រ្យុឞ្មាភិរេករូបាណិ វាក្យានិ កថ្យន្តាំ យុឞ្មន្មធ្យេ ភិន្នសង្ឃាតា ន ភវន្តុ មនោវិចារយោរៃក្យេន យុឞ្មាកំ សិទ្ធត្វំ ភវតុ។ ");
INSERT INTO sankhm_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","ហេ មម ភ្រាតរោ យុឞ្មន្មធ្យេ វិវាទា ជាតា ឥតិ វាត៌្តាមហំ ក្លោយ្យាះ បរិជនៃ រ្ជ្ញាបិតះ។ ");
INSERT INTO sankhm_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","មមាភិប្រេតមិទំ យុឞ្មាកំ កឝ្ចិត៑ កឝ្ចិទ៑ វទតិ បៅលស្យ ឝិឞ្យោៜហម៑ អាបល្លោះ ឝិឞ្យោៜហំ កៃផាះ ឝិឞ្យោៜហំ ខ្រីឞ្ដស្យ ឝិឞ្យោៜហមិតិ ច។ ");
INSERT INTO sankhm_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","ខ្រីឞ្ដស្យ កិំ វិភេទះ ក្ឫតះ? បៅលះ កិំ យុឞ្មត្ក្ឫតេ ក្រុឝេ ហតះ? បៅលស្យ នាម្នា វា យូយំ កិំ មជ្ជិតាះ? ");
INSERT INTO sankhm_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","ក្រិឞ្បគាយៅ វិនា យុឞ្មាកំ មធ្យេៜន្យះ កោៜបិ មយា ន មជ្ជិត ឥតិ ហេតោរហម៑ ឦឝ្វរំ ធន្យំ វទាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","ឯតេន មម នាម្នា មានវា មយា មជ្ជិតា ឥតិ វក្តុំ កេនាបិ ន ឝក្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","អបរំ ស្តិផានស្យ បរិជនា មយា មជ្ជិតាស្តទន្យះ កឝ្ចិទ៑ យន្មយា មជ្ជិតស្តទហំ ន វេទ្មិ។ ");
INSERT INTO sankhm_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","ខ្រីឞ្ដេនាហំ មជ្ជនាត៌្ហំ ន ប្រេរិតះ កិន្តុ សុសំវាទស្យ ប្រចារាត៌្ហមេវ; សោៜបិ វាក្បដុតយា មយា ន ប្រចារិតវ្យះ, យតស្តថា ប្រចារិតេ ខ្រីឞ្ដស្យ ក្រុឝេ ម្ឫត្យុះ ផលហីនោ ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","យតោ ហេតោ រ្យេ វិនឝ្យន្តិ តេ តាំ ក្រុឝស្យ វាត៌្តាំ ប្រលាបមិវ មន្យន្តេ កិញ្ច បរិត្រាណំ លភមានេឞ្វស្មាសុ សា ឦឝ្វរីយឝក្តិស្វរូបា។ ");
INSERT INTO sankhm_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","តស្មាទិត្ថំ លិខិតមាស្តេ, ជ្ញានវតាន្តុ យត៑ ជ្ញានំ តន្មយា នាឝយិឞ្យតេ។ វិលោបយិឞ្យតេ តទ្វទ៑ ពុទ្ធិ រ្ពទ្ធិមតាំ មយា៕ ");
INSERT INTO sankhm_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","ជ្ញានី កុត្រ? ឝាស្ត្រី វា កុត្រ? ឥហលោកស្យ វិចារតត្បរោ វា កុត្រ? ឥហលោកស្យ ជ្ញានំ កិមីឝ្វរេណ មោហីក្ឫតំ នហិ? ");
INSERT INTO sankhm_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","ឦឝ្វរស្យ ជ្ញានាទ៑ ឥហលោកស្យ មានវាះ ស្វជ្ញានេនេឝ្វរស្យ តត្ត្វពោធំ ន ប្រាប្តវន្តស្តស្មាទ៑ ឦឝ្វរះ ប្រចាររូបិណា ប្រលាបេន វិឝ្វាសិនះ បរិត្រាតុំ រោចិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","យិហូទីយលោកា លក្ឞណានិ ទិទ្ឫក្ឞន្តិ ភិន្នទេឝីយលោកាស្តុ វិទ្យាំ ម្ឫគយន្តេ, ");
INSERT INTO sankhm_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","វយញ្ច ក្រុឝេ ហតំ ខ្រីឞ្ដំ ប្រចារយាមះ។ តស្យ ប្រចារោ យិហូទីយៃ រ្វិឃ្ន ឥវ ភិន្នទេឝីយៃឝ្ច ប្រលាប ឥវ មន្យតេ, ");
INSERT INTO sankhm_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","កិន្តុ យិហូទីយានាំ ភិន្នទេឝីយានាញ្ច មធ្យេ យេ អាហូតាស្តេឞុ ស ខ្រីឞ្ដ ឦឝ្វរីយឝក្តិរិវេឝ្វរីយជ្ញានមិវ ច ប្រកាឝតេ។ ");
INSERT INTO sankhm_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","យត ឦឝ្វរេ យះ ប្រលាប អារោប្យតេ ស មានវាតិរិក្តំ ជ្ញានមេវ យច្ច ទៅព៌្ពល្យម៑ ឦឝ្វរ អារោប្យតេ តត៑ មានវាតិរិក្តំ ពលមេវ។ ");
INSERT INTO sankhm_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","ហេ ភ្រាតរះ, អាហូតយុឞ្មទ្គណោ យឞ្មាភិរាលោក្យតាំ តន្មធ្យេ សាំសារិកជ្ញានេន ជ្ញានវន្តះ បរាក្រមិណោ វា កុលីនា វា ពហវោ ន វិទ្យន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","យត ឦឝ្វរោ ជ្ញានវតស្ត្របយិតុំ មូក៌្ហលោកាន៑ រោចិតវាន៑ ពលានិ ច ត្របយិតុម៑ ឦឝ្វរោ ទុព៌្ពលាន៑ រោចិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","តថា វត៌្តមានលោកាន៑ សំស្ថិតិភ្រឞ្ដាន៑ កត៌្តុម៑ ឦឝ្វរោ ជគតោៜបក្ឫឞ្ដាន៑ ហេយាន៑ អវត៌្តមានាំឝ្ចាភិរោចិតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","តត ឦឝ្វរស្យ សាក្ឞាត៑ កេនាប្យាត្មឝ្លាឃា ន កត៌្តវ្យា។ ");
INSERT INTO sankhm_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","យូយញ្ច តស្មាត៑ ខ្រីឞ្ដេ យីឝៅ សំស្ថិតិំ ប្រាប្តវន្តះ ស ឦឝ្វរាទ៑ យុឞ្មាកំ ជ្ញានំ បុណ្យំ បវិត្រត្វំ មុក្តិឝ្ច ជាតា។ ");
INSERT INTO sankhm_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","អតឯវ យទ្វទ៑ លិខិតមាស្តេ តទ្វត៑, យះ កឝ្ចិត៑ ឝ្លាឃមានះ ស្យាត៑ ឝ្លាឃតាំ ប្រភុនា ស ហិ។ ");
INSERT INTO sankhm_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","ហេ ភ្រាតរោ យុឞ្មត្សមីបេ មមាគមនកាលេៜហំ វក្ត្ឫតាយា វិទ្យាយា វា នៃបុណ្យេនេឝ្វរស្យ សាក្ឞ្យំ ប្រចារិតវាន៑ តន្នហិ; ");
INSERT INTO sankhm_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","យតោ យីឝុខ្រីឞ្ដំ តស្យ ក្រុឝេ ហតត្វញ្ច វិនា នាន្យត៑ កិមបិ យុឞ្មន្មធ្យេ ជ្ញាបយិតុំ វិហិតំ ពុទ្ធវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","អបរញ្ចាតីវ ទៅព៌្ពល្យភីតិកម្បយុក្តោ យុឞ្មាភិះ សាទ៌្ធមាសំ។ ");
INSERT INTO sankhm_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","អបរំ យុឞ្មាកំ វិឝ្វាសោ យត៑ មានុឞិកជ្ញានស្យ ផលំ ន ភវេត៑ កិន្ត្វីឝ្វរីយឝក្តេះ ផលំ ភវេត៑, ");
INSERT INTO sankhm_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","តទត៌្ហំ មម វក្ត្ឫតា មទីយប្រចារឝ្ច មានុឞិកជ្ញានស្យ មធុរវាក្យសម្ពលិតៅ នាស្តាំ កិន្ត្វាត្មនះ ឝក្តេឝ្ច ប្រមាណយុក្តាវាស្តាំ។ ");
INSERT INTO sankhm_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","វយំ ជ្ញានំ ភាឞាមហេ តច្ច សិទ្ធលោកៃ រ្ជ្ញានមិវ មន្យតេ, តទិហលោកស្យ ជ្ញានំ នហិ, ឥហលោកស្យ នឝ្វរាណាម៑ អធិបតីនាំ វា ជ្ញានំ នហិ; ");
INSERT INTO sankhm_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","កិន្តុ កាលាវស្ថាយាះ បូវ៌្វស្មាទ៑ យត៑ ជ្ញានម៑ អស្មាកំ វិភវាត៌្ហម៑ ឦឝ្វរេណ និឝ្ចិត្យ ប្រច្ឆន្នំ តន្និគូឍម៑ ឦឝ្វរីយជ្ញានំ ប្រភាឞាមហេ។ ");
INSERT INTO sankhm_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","ឥហលោកស្យាធិបតីនាំ កេនាបិ តត៑ ជ្ញានំ ន លព្ធំ, លព្ធេ សតិ តេ ប្រភាវវិឝិឞ្ដំ ប្រភុំ ក្រុឝេ នាហនិឞ្យន៑។ ");
INSERT INTO sankhm_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","តទ្វល្លិខិតមាស្តេ, នេត្រេណ ក្កាបិ នោ ទ្ឫឞ្ដំ កណ៌េនាបិ ច ន ឝ្រុតំ។ មនោមធ្យេ តុ កស្យាបិ ន ប្រវិឞ្ដំ កទាបិ យត៑។ ឦឝ្វរេ ប្រីយមាណានាំ ក្ឫតេ តត៑ តេន សញ្ចិតំ។ ");
INSERT INTO sankhm_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","អបរមីឝ្វរះ ស្វាត្មនា តទស្មាកំ សាក្ឞាត៑ ប្រាកាឝយត៑; យត អាត្មា សវ៌្វមេវានុសន្ធត្តេ តេន ចេឝ្វរស្យ មម៌្មតត្ត្វមបិ ពុធ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","មនុជស្យាន្តះស្ថមាត្មានំ វិនា កេន មនុជេន តស្យ មនុជស្យ តត្ត្វំ ពុធ្យតេ? តទ្វទីឝ្វរស្យាត្មានំ វិនា កេនាបីឝ្វរស្យ តត្ត្វំ ន ពុធ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","វយញ្ចេហលោកស្យាត្មានំ លព្ធវន្តស្តន្នហិ កិន្ត្វីឝ្វរស្យៃវាត្មានំ លព្ធវន្តះ, តតោ ហេតោរីឝ្វរេណ ស្វប្រសាទាទ៑ អស្មភ្យំ យទ៑ យទ៑ ទត្តំ តត្សវ៌្វម៑ អស្មាភិ រ្ជ្ញាតុំ ឝក្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","តច្ចាស្មាភិ រ្មានុឞិកជ្ញានស្យ វាក្យានិ ឝិក្ឞិត្វា កថ្យត ឥតិ នហិ កិន្ត្វាត្មតោ វាក្យានិ ឝិក្ឞិត្វាត្មិកៃ រ្វាក្យៃរាត្មិកំ ភាវំ ប្រកាឝយទ្ភិះ កថ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","ប្រាណី មនុឞ្យ ឦឝ្វរីយាត្មនះ ឝិក្ឞាំ ន គ្ឫហ្លាតិ យត អាត្មិកវិចារេណ សា វិចាយ៌្យេតិ ហេតោះ ស តាំ ប្រលាបមិវ មន្យតេ ពោទ្ធុញ្ច ន ឝក្នោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","អាត្មិកោ មានវះ សវ៌្វាណិ វិចារយតិ កិន្តុ ស្វយំ កេនាបិ ន វិចាយ៌្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","យត ឦឝ្វរស្យ មនោ ជ្ញាត្វា តមុបទេឞ្ដុំ កះ ឝក្នោតិ? កិន្តុ ខ្រីឞ្ដស្យ មនោៜស្មាភិ រ្លព្ធំ។ ");
INSERT INTO sankhm_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","ហេ ភ្រាតរះ, អហមាត្មិកៃរិវ យុឞ្មាភិះ សមំ សម្ភាឞិតុំ នាឝក្នវំ កិន្តុ ឝារីរិកាចារិភិះ ខ្រីឞ្ដធម៌្មេ ឝិឝុតុល្យៃឝ្ច ជនៃរិវ យុឞ្មាភិះ សហ សមភាឞេ។ ");
INSERT INTO sankhm_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","យុឞ្មាន៑ កឋិនភក្ឞ្យំ ន ភោជយន៑ ទុគ្ធម៑ អបាយយំ យតោ យូយំ ភក្ឞ្យំ គ្រហីតុំ តទា នាឝក្នុត ឥទានីមបិ ន ឝក្នុថ, យតោ ហេតោរធុនាបិ ឝារីរិកាចារិណ អាធ្វេ។ ");
INSERT INTO sankhm_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","យុឞ្មន្មធ្យេ មាត្សយ៌្យវិវាទភេទា ភវន្តិ តតះ កិំ ឝារីរិកាចារិណោ នាធ្វេ មានុឞិកមាគ៌េណ ច ន ចរថ? ");
INSERT INTO sankhm_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","បៅលស្យាហមិត្យាបល្លោរហមិតិ វា យទ្វាក្យំ យុឞ្មាកំ កៃឝ្ចិត៑ កៃឝ្ចិត៑ កថ្យតេ តស្មាទ៑ យូយំ ឝារីរិកាចារិណ ន ភវថ? ");
INSERT INTO sankhm_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","បៅលះ កះ? អាបល្លោ រ្វា កះ? តៅ បរិចារកមាត្រៅ តយោរេកៃកស្មៃ ច ប្រភុ រ្យាទ្ឫក៑ ផលមទទាត៑ តទ្វត៑ តយោទ៌្វារា យូយំ វិឝ្វាសិនោ ជាតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","អហំ រោបិតវាន៑ អាបល្លោឝ្ច និឞិក្តវាន៑ ឦឝ្វរឝ្ចាវទ៌្ធយត៑។ ");
INSERT INTO sankhm_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","អតោ រោបយិត្ឫសេក្តារាវសារៅ វទ៌្ធយិតេឝ្វរ ឯវ សារះ។ ");
INSERT INTO sankhm_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","រោបយិត្ឫសេក្តារៅ ច សមៅ តយោរេកៃកឝ្ច ស្វឝ្រមយោគ្យំ ស្វវេតនំ លប្ស្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","អាវាមីឝ្វរេណ សហ កម៌្មការិណៅ, ឦឝ្វរស្យ យត៑ ក្ឞេត្រម៑ ឦឝ្វរស្យ យា និម៌្មិតិះ សា យូយមេវ។ ");
INSERT INTO sankhm_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","ឦឝ្វរស្យ ប្រសាទាត៑ មយា យត៑ បទំ លព្ធំ តស្មាត៑ ជ្ញានិនា គ្ឫហការិណេវ មយា ភិត្តិមូលំ ស្ថាបិតំ តទុបរិ ចាន្យេន និចីយតេ។ កិន្តុ យេន យន្និចីយតេ តត៑ តេន វិវិច្យតាំ។ ");
INSERT INTO sankhm_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","យតោ យីឝុខ្រីឞ្ដរូបំ យទ៑ ភិត្តិមូលំ ស្ថាបិតំ តទន្យត៑ កិមបិ ភិត្តិមូលំ ស្ថាបយិតុំ កេនាបិ ន ឝក្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","ឯតទ្ភិត្តិមូលស្យោបរិ យទិ កេចិត៑ ស្វណ៌រូប្យមណិកាឞ្ឋត្ឫណនលាន៑ និចិន្វន្តិ, ");
INSERT INTO sankhm_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","តហ៌្យេកៃកស្យ កម៌្ម ប្រកាឝិឞ្យតេ យតះ ស ទិវសស្តត៑ ប្រកាឝយិឞ្យតិ។ យតោ ហតោស្តន ទិវសេន វហ្និមយេនោទេតវ្យំ តត ឯកៃកស្យ កម៌្ម កីទ្ឫឝមេតស្យ បរីក្ឞា ពហ្និនា ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","យស្យ និចយនរូបំ កម៌្ម ស្ថាស្នុ ភវិឞ្យតិ ស វេតនំ លប្ស្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","យស្យ ច កម៌្ម ធក្ឞ្យតេ តស្យ ក្ឞតិ រ្ភវិឞ្យតិ កិន្តុ វហ្នេ រ្និគ៌តជន ឥវ ស ស្វយំ បរិត្រាណំ ប្រាប្ស្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","យូយម៑ ឦឝ្វរស្យ មន្ទិរំ យុឞ្មន្មធ្យេ ចេឝ្វរស្យាត្មា និវសតីតិ កិំ ន ជានីថ? ");
INSERT INTO sankhm_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","ឦឝ្វរស្យ មន្ទិរំ យេន វិនាឝ្យតេ សោៜបីឝ្វរេណ វិនាឝយិឞ្យតេ យត ឦឝ្វរស្យ មន្ទិរំ បវិត្រមេវ យូយំ តុ តន្មន្ទិរម៑ អាធ្វេ។ ");
INSERT INTO sankhm_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","កោបិ ស្វំ ន វញ្ចយតាំ។ យុឞ្មាកំ កឝ្ចន ចេទិហលោកស្យ ជ្ញានេន ជ្ញានវានហមិតិ ពុធ្យតេ តហ៌ិ ស យត៑ ជ្ញានី ភវេត៑ តទត៌្ហំ មូឍោ ភវតុ។ ");
INSERT INTO sankhm_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","យស្មាទិហលោកស្យ ជ្ញានម៑ ឦឝ្វរស្យ សាក្ឞាត៑ មូឍត្វមេវ។ ឯតស្មិន៑ លិខិតមប្យាស្តេ, តីក្ឞ្ណា យា ជ្ញានិនាំ ពុទ្ធិស្តយា តាន៑ ធរតីឝ្វរះ។ ");
INSERT INTO sankhm_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","បុនឝ្ច។ ជ្ញានិនាំ កល្បនា វេត្តិ បរមេឝោ និរត៌្ហកាះ។ ");
INSERT INTO sankhm_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","អតឯវ កោៜបិ មនុជៃរាត្មានំ ន ឝ្លាឃតាំ យតះ សវ៌្វាណិ យុឞ្មាកមេវ, ");
INSERT INTO sankhm_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","បៅល វា អាបល្លោ រ្វា កៃផា វា ជគទ៑ វា ជីវនំ វា មរណំ វា វត៌្តមានំ វា ភវិឞ្យទ្វា សវ៌្វាណ្យេវ យុឞ្មាកំ, ");
INSERT INTO sankhm_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","យូយញ្ច ខ្រីឞ្ដស្យ, ខ្រីឞ្ដឝ្ចេឝ្វរស្យ។ ");
INSERT INTO sankhm_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","លោកា អស្មាន៑ ខ្រីឞ្ដស្យ បរិចារកាន៑ ឦឝ្វរស្យ និគូឋវាក្យធនស្យាធ្យក្ឞាំឝ្ច មន្យន្តាំ។ ");
INSERT INTO sankhm_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","កិញ្ច ធនាធ្យក្ឞេណ វិឝ្វសនីយេន ភវិតវ្យមេតទេវ លោកៃ រ្យាច្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","អតោ វិចារយទ្ភិ រ្យុឞ្មាភិរន្យៃះ កៃឝ្ចិន៑ មនុជៃ រ្វា មម បរីក្ឞណំ មយាតីវ លឃុ មន្យតេ ៜហមប្យាត្មានំ ន វិចារយាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","មយា កិមប្យបរាទ្ធមិត្យហំ ន វេទ្មិ កិន្ត្វេតេន មម និរបរាធត្វំ ន និឝ្ចីយតេ ប្រភុរេវ មម វិចារយិតាស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","អត ឧបយុក្តសមយាត៑ បូវ៌្វម៑ អត៌្ហតះ ប្រភោរាគមនាត៑ បូវ៌្វំ យុឞ្មាភិ រ្វិចារោ ន ក្រិយតាំ។ ប្រភុរាគត្យ តិមិរេណ ប្រច្ឆន្នានិ សវ៌្វាណិ ទីបយិឞ្យតិ មនសាំ មន្ត្រណាឝ្ច ប្រកាឝយិឞ្យតិ តស្មិន៑ សមយ ឦឝ្វរាទ៑ ឯកៃកស្យ ប្រឝំសា ភវិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","ហេ ភ្រាតរះ សវ៌្វាណ្យេតានិ មយាត្មានម៑ អាបល្លវញ្ចោទ្ទិឝ្យ កថិតានិ តស្យៃតត៑ ការណំ យុយំ យថា ឝាស្ត្រីយវិធិមតិក្រម្យ មានវម៑ អតីវ នាទរិឞ្យធ្ព ឦត្ថញ្ចៃកេន វៃបរីត្យាទ៑ អបរេណ ន ឝ្លាឃិឞ្យធ្ព ឯតាទ្ឫឝីំ ឝិក្ឞាមាវយោទ៌្ឫឞ្ដាន្តាត៑ លប្ស្យធ្វេ។ ");
INSERT INTO sankhm_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","អបរាត៑ កស្ត្វាំ វិឝេឞយតិ? តុភ្យំ យន្ន ទត្ត តាទ្ឫឝំ កិំ ធារយសិ? អទត្តេនេវ ទត្តេន វស្តុនា កុតះ ឝ្លាឃសេ? ");
INSERT INTO sankhm_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","ឥទានីមេវ យូយំ កិំ ត្ឫប្តា លព្ធធនា វា? អស្មាស្វវិទ្យមានេឞុ យូយំ កិំ រាជត្វបទំ ប្រាប្តាះ? យុឞ្មាកំ រាជត្វំ មយាភិលឞិតំ យតស្តេន យុឞ្មាភិះ សហ វយមបិ រាជ្យាំឝិនោ ភវិឞ្យាមះ។ ");
INSERT INTO sankhm_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","ប្រេរិតា វយំ ឝេឞា ហន្តវ្យាឝ្ចេវេឝ្វរេណ និទឝ៌ិតាះ។ យតោ វយំ សវ៌្វលោកានាម៑ អត៌្ហតះ ស្វគ៌ីយទូតានាំ មានវានាញ្ច កៅតុកាស្បទានិ ជាតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","ខ្រីឞ្ដស្យ ក្ឫតេ វយំ មូឍាះ កិន្តុ យូយំ ខ្រីឞ្ដេន ជ្ញានិនះ, វយំ ទុព៌្ពលា យូយញ្ច សពលាះ, យូយំ សម្មានិតា វយញ្ចាបមានិតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","វយមទ្យាបិ ក្ឞុធាត៌្តាស្ត្ឫឞ្ណាត៌្តា វស្ត្រហីនាស្តាឌិតា អាឝ្រមរហិតាឝ្ច សន្តះ ");
INSERT INTO sankhm_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","កម៌្មណិ ស្វករាន៑ វ្យាបារយន្តឝ្ច ទុះខៃះ កាលំ យាបយាមះ។ គហ៌ិតៃរស្មាភិរាឝីះ កថ្យតេ ទូរីក្ឫតៃះ សហ្យតេ និន្ទិតៃះ ប្រសាទ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","វយមទ្យាបិ ជគតះ សម្មាជ៌នីយោគ្យា អវករា ឥវ សវ៌្វៃ រ្មន្យាមហេ។ ");
INSERT INTO sankhm_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","យុឞ្មាន៑ ត្របយិតុមហមេតានិ លិខាមីតិ នហិ កិន្តុ ប្រិយាត្មជានិវ យុឞ្មាន៑ ប្រពោធយាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","យតះ ខ្រីឞ្ដធម៌្មេ យទ្យបិ យុឞ្មាកំ ទឝសហស្រាណិ វិនេតារោ ភវន្តិ តថាបិ ពហវោ ជនកា ន ភវន្តិ យតោៜហមេវ សុសំវាទេន យីឝុខ្រីឞ្ដេ យុឞ្មាន៑ អជនយំ។ ");
INSERT INTO sankhm_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","អតោ យុឞ្មាន៑ វិនយេៜហំ យូយំ មទនុគាមិនោ ភវត។ ");
INSERT INTO sankhm_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","ឥត្យត៌្ហំ សវ៌្វេឞុ ធម៌្មសមាជេឞុ សវ៌្វត្រ ខ្រីឞ្ដធម៌្មយោគ្យា យេ វិធយោ មយោបទិឝ្យន្តេ តាន៑ យោ យុឞ្មាន៑ ស្មារយិឞ្យត្យេវម្ភូតំ ប្រភោះ ក្ឫតេ ប្រិយំ វិឝ្វាសិនញ្ច មទីយតនយំ តីមថិយំ យុឞ្មាកំ សមីបំ ប្រេឞិតវានហំ។ ");
INSERT INTO sankhm_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","អបរមហំ យុឞ្មាកំ សមីបំ ន គមិឞ្យាមីតិ ពុទ្ធ្វា យុឞ្មាកំ កិយន្តោ លោកា គវ៌្វន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","កិន្តុ យទិ ប្រភេរិច្ឆា ភវតិ តហ៌្យហមវិលម្ពំ យុឞ្មត្សមីបមុបស្ថាយ តេឞាំ ទប៌ធ្មាតានាំ លោកានាំ វាចំ ជ្ញាស្យាមីតិ នហិ សាមត៌្ហ្យមេវ ជ្ញាស្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","យស្មាទីឝ្វរស្យ រាជត្វំ វាគ្យុក្តំ នហិ កិន្តុ សាមត៌្ហ្យយុក្តំ។ ");
INSERT INTO sankhm_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","យុឞ្មាកំ កា វាញ្ឆា? យុឞ្មត្សមីបេ មយា កិំ ទណ្ឌបាណិនា គន្តវ្យមុត ប្រេមនម្រតាត្មយុក្តេន វា? ");
INSERT INTO sankhm_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","អបរំ យុឞ្មាកំ មធ្យេ វ្យភិចារោ វិទ្យតេ ស ច វ្យភិចារស្តាទ្ឫឝោ យទ៑ ទេវបូជកានាំ មធ្យេៜបិ តត្តុល្យោ ន វិទ្យតេ ផលតោ យុឞ្មាកមេកោ ជនោ វិមាត្ឫគមនំ ក្ឫរុត ឥតិ វាត៌្តា សវ៌្វត្រ វ្យាប្តា។ ");
INSERT INTO sankhm_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","តថាច យូយំ ទប៌ធ្មាតា អាធ្ពេ, តត៑ កម៌្ម យេន ក្ឫតំ ស យថា យុឞ្មន្មធ្យាទ៑ ទូរីក្រិយតេ តថា ឝោកោ យុឞ្មាភិ រ្ន ក្រិយតេ កិម៑ ឯតត៑? ");
INSERT INTO sankhm_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","អវិទ្យមានេ មទីយឝរីរេ មមាត្មា យុឞ្មន្មធ្យេ វិទ្យតេ អតោៜហំ វិទ្យមាន ឥវ តត្កម៌្មការិណោ វិចារំ និឝ្ចិតវាន៑, ");
INSERT INTO sankhm_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","អស្មត្ប្រភោ រ្យីឝុខ្រីឞ្ដស្យ នាម្នា យុឞ្មាកំ មទីយាត្មនឝ្ច មិលនេ ជាតេ ៜស្មត្ប្រភោ រ្យីឝុខ្រីឞ្ដស្យ ឝក្តេះ សាហាយ្យេន ");
INSERT INTO sankhm_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","ស នរះ ឝរីរនាឝាត៌្ហមស្មាភិះ ឝយតានោ ហស្តេ សមប៌យិតវ្យស្តតោៜស្មាកំ ប្រភោ រ្យីឝោ រ្ទិវសេ តស្យាត្មា រក្ឞាំ គន្តុំ ឝក្ឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","យុឞ្មាកំ ទប៌ោ ន ភទ្រាយ យូយំ កិមេតន្ន ជានីថ, យថា, វិការះ ក្ឫត្ស្នឝក្តូនាំ ស្វល្បកិណ្វេន ជាយតេ។ ");
INSERT INTO sankhm_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","យូយំ យត៑ នវីនឝក្តុស្វរូបា ភវេត តទត៌្ហំ បុរាតនំ កិណ្វម៑ អវមាជ៌្ជត យតោ យុឞ្មាភិះ កិណ្វឝូន្យៃ រ្ភវិតវ្យំ។ អបរម៑ អស្មាកំ និស្តារោត្សវីយមេឞឝាវកោ យះ ខ្រីឞ្ដះ សោៜស្មទត៌្ហំ ពលីក្ឫតោ ៜភវត៑។ ");
INSERT INTO sankhm_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","អតះ បុរាតនកិណ្វេនាត៌្ហតោ ទុឞ្ដតាជិឃាំសារូបេណ កិណ្វេន តន្នហិ កិន្តុ សារល្យសត្យត្វរូបយា កិណ្វឝូន្យតយាស្មាភិរុត្សវះ កត៌្តវ្យះ។ ");
INSERT INTO sankhm_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","វ្យាភិចារិណាំ សំសគ៌ោ យុឞ្មាភិ រ្វិហាតវ្យ ឥតិ មយា បត្រេ លិខិតំ។ ");
INSERT INTO sankhm_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","កិន្ត្វៃហិកលោកានាំ មធ្យេ យេ វ្យភិចារិណោ លោភិន ឧបទ្រាវិណោ ទេវបូជកា វា តេឞាំ សំសគ៌ះ សវ៌្វថា វិហាតវ្យ ឥតិ នហិ, វិហាតវ្យេ សតិ យុឞ្មាភិ រ្ជគតោ និគ៌ន្តវ្យមេវ។ ");
INSERT INTO sankhm_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","កិន្តុ ភ្រាត្ឫត្វេន វិខ្យាតះ កឝ្ចិជ្ជនោ យទិ វ្យភិចារី លោភី ទេវបូជកោ និន្ទកោ មទ្យប ឧបទ្រាវី វា ភវេត៑ តហ៌ិ តាទ្ឫឝេន មានវេន សហ ភោជនបានេៜបិ យុឞ្មាភិ រ្ន កត៌្តវ្យេ ឥត្យធុនា មយា លិខិតំ។ ");
INSERT INTO sankhm_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","សមាជពហិះស្ថិតានាំ លោកានាំ វិចារករណេ មម កោៜធិការះ? កិន្តុ តទន្តគ៌តានាំ វិចារណំ យុឞ្មាភិះ កិំ ន កត៌្តវ្យំ ភវេត៑? ");
INSERT INTO sankhm_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","ពហិះស្ថានាំ តុ វិចារ ឦឝ្វរេណ ការិឞ្យតេ។ អតោ យុឞ្មាភិះ ស បាតកី ស្វមធ្យាទ៑ ពហិឞ្ក្រិយតាំ។ ");
INSERT INTO sankhm_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","យុឞ្មាកមេកស្យ ជនស្យាបរេណ សហ វិវាទេ ជាតេ ស បវិត្រលោកៃ រ្វិចារមការយន៑ កិម៑ អធាម៌្មិកលោកៃ រ្វិចារយិតុំ ប្រោត្សហតេ? ");
INSERT INTO sankhm_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","ជគតោៜបិ វិចារណំ បវិត្រលោកៃះ ការិឞ្យត ឯតទ៑ យូយំ កិំ ន ជានីថ? អតោ ជគទ៑ យទិ យុឞ្មាភិ រ្វិចារយិតវ្យំ តហ៌ិ ក្ឞុទ្រតមវិចារេឞុ យូយំ កិមសមត៌្ហាះ? ");
INSERT INTO sankhm_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","ទូតា អប្យស្មាភិ រ្វិចារយិឞ្យន្ត ឥតិ កិំ ន ជានីថ? អត ឰហិកវិឞយាះ កិម៑ អស្មាភិ រ្ន វិចារយិតវ្យា ភវេយុះ? ");
INSERT INTO sankhm_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","ឰហិកវិឞយស្យ វិចារេ យុឞ្មាភិះ កត៌្តវ្យេ យេ លោកាះ សមិតៅ ក្ឞុទ្រតមាស្ត ឯវ និយុជ្យន្តាំ។ ");
INSERT INTO sankhm_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","អហំ យុឞ្មាន៑ ត្របយិតុមិច្ឆន៑ វទាមិ យ្ឫឞ្មន្មធ្យេ កិមេកោៜបិ មនុឞ្យស្តាទ្ឫគ៑ ពុទ្ធិមាន្នហិ យោ ភ្រាត្ឫវិវាទវិចារណេ សមត៌្ហះ ស្យាត៑? ");
INSERT INTO sankhm_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","កិញ្ចៃកោ ភ្រាតា ភ្រាត្រាន្យេន កិមវិឝ្វាសិនាំ វិចារកាណាំ សាក្ឞាទ៑ វិវទតេ? យឞ្មន្មធ្យេ វិវាទា វិទ្យន្ត ឯតទបិ យុឞ្មាកំ ទោឞះ។ ");
INSERT INTO sankhm_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","យូយំ កុតោៜន្យាយសហនំ ក្ឞតិសហនំ វា ឝ្រេយោ ន មន្យធ្វេ? ");
INSERT INTO sankhm_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","កិន្តុ យូយមបិ ភ្រាត្ឫនេវ ប្រត្យន្យាយំ ក្ឞតិញ្ច កុរុថ កិមេតត៑? ");
INSERT INTO sankhm_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","ឦឝ្វរស្យ រាជ្យេៜន្យាយការិណាំ លោកានាមធិការោ នាស្ត្យេតទ៑ យូយំ កិំ ន ជានីថ? មា វញ្ច្យធ្វំ, យេ វ្យភិចារិណោ ទេវាច៌្ចិនះ បារទារិកាះ ស្ត្រីវទាចារិណះ បុំមៃថុនការិណស្តស្ករា ");
INSERT INTO sankhm_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","លោភិនោ មទ្យបា និន្ទកា ឧបទ្រាវិណោ វា ត ឦឝ្វរស្យ រាជ្យភាគិនោ ន ភវិឞ្យន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","យូយញ្ចៃវំវិធា លោកា អាស្ត កិន្តុ ប្រភោ រ្យីឝោ រ្នាម្នាស្មទីឝ្វរស្យាត្មនា ច យូយំ ប្រក្ឞាលិតាះ បាវិតាះ សបុណ្យីក្ឫតាឝ្ច។ ");
INSERT INTO sankhm_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","មទត៌្ហំ សវ៌្វំ ទ្រវ្យម៑ អប្រតិឞិទ្ធំ កិន្តុ ន សវ៌្វំ ហិតជនកំ។ មទត៌្ហំ សវ៌្វមប្រតិឞិទ្ធំ តថាប្យហំ កស្យាបិ ទ្រវ្យស្យ វឝីក្ឫតោ ន ភវិឞ្យាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","ឧទរាយ ភក្ឞ្យាណិ ភក្ឞ្យេភ្យឝ្ចោទរំ, កិន្តុ ភក្ឞ្យោទរេ ឦឝ្វរេណ នាឝយិឞ្យេតេ; អបរំ ទេហោ ន វ្យភិចារាយ កិន្តុ ប្រភវេ ប្រភុឝ្ច ទេហាយ។ ");
INSERT INTO sankhm_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","យឝ្ចេឝ្វរះ ប្រភុមុត្ថាបិតវាន៑ ស ស្វឝក្ត្យាស្មានប្យុត្ថាបយិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","យុឞ្មាកំ យានិ ឝរីរាណិ តានិ ខ្រីឞ្ដស្យាង្គានីតិ កិំ យូយំ ន ជានីថ? អតះ ខ្រីឞ្ដស្យ យាន្យង្គានិ តានិ មយាបហ្ឫត្យ វេឝ្យាយា អង្គានិ កិំ ការិឞ្យន្តេ? តន្ន ភវតុ។ ");
INSERT INTO sankhm_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","យះ កឝ្ចិទ៑ វេឝ្យាយាម៑ អាសជ្យតេ ស តយា សហៃកទេហោ ភវតិ កិំ យូយមេតន្ន ជានីថ? យតោ លិខិតមាស្តេ, យថា, តៅ ទ្វៅ ជនាវេកាង្គៅ ភវិឞ្យតះ។ ");
INSERT INTO sankhm_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","មានវា យាន្យន្យានិ កលុឞាណិ កុវ៌្វតេ តានិ វបុ រ្ន សមាវិឝន្តិ កិន្តុ វ្យភិចារិណា ស្វវិគ្រហស្យ វិរុទ្ធំ កល្មឞំ ក្រិយតេ។ ");
INSERT INTO sankhm_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","មានវា យាន្យន្យានិ កលុឞាណិ កុវ៌្វតេ តានិ វបុ រ្ន សមាវិឝន្តិ កិន្តុ វ្យភិចារិណា ស្វវិគ្រហស្យ វិរុទ្ធំ កល្មឞំ ក្រិយតេ។ ");
INSERT INTO sankhm_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","យុឞ្មាកំ យានិ វបូំសិ តានិ យុឞ្មទន្តះស្ថិតស្យេឝ្វរាល្លព្ធស្យ បវិត្រស្យាត្មនោ មន្ទិរាណិ យូយញ្ច ស្វេឞាំ ស្វាមិនោ នាធ្វេ កិមេតទ៑ យុឞ្មាភិ រ្ន ជ្ញាយតេ? ");
INSERT INTO sankhm_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","យូយំ មូល្យេន ក្រីតា អតោ វបុម៌នោភ្យាម៑ ឦឝ្វរោ យុឞ្មាភិះ បូជ្យតាំ យត ឦឝ្វរ ឯវ តយោះ ស្វាមី។ ");
INSERT INTO sankhm_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","អបរញ្ច យុឞ្មាភិ រ្មាំ ប្រតិ យត៑ បត្រមលេខិ តស្យោត្តរមេតត៑, យោឞិតោៜស្បឝ៌នំ មនុជស្យ វរំ; ");
INSERT INTO sankhm_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","កិន្តុ វ្យភិចារភយាទ៑ ឯកៃកស្យ បុំសះ ស្វកីយភាយ៌្យា ភវតុ តទ្វទ៑ ឯកៃកស្យា យោឞិតោ ៜបិ ស្វកីយភត៌្តា ភវតុ។ ");
INSERT INTO sankhm_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","ភាយ៌្យាយៃ ភត៌្រា យទ្យទ៑ វិតរណីយំ តទ៑ វិតីយ៌្យតាំ តទ្វទ៑ ភត៌្រេៜបិ ភាយ៌្យយា វិតរណីយំ វិតីយ៌្យតាំ។ ");
INSERT INTO sankhm_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","ភាយ៌្យាយាះ ស្វទេហេ ស្វត្វំ នាស្តិ ភត៌្តុរេវ, តទ្វទ៑ ភត៌្តុរបិ ស្វទេហេ ស្វត្វំ នាស្តិ ភាយ៌្យាយា ឯវ។ ");
INSERT INTO sankhm_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","ឧបោឞណប្រាត៌្ហនយោះ សេវនាត៌្ហម៑ ឯកមន្ត្រណានាំ យុឞ្មាកំ កិយត្កាលំ យាវទ៑ យា ប្ឫថក្ស្ថិតិ រ្ភវតិ តទន្យោ វិច្ឆេទោ យុឞ្មន្មធ្យេ ន ភវតុ, តតះ បរម៑ ឥន្ទ្រិយាណាម៑ អធៃយ៌្យាត៑ ឝយតាន៑ យទ៑ យុឞ្មាន៑ បរីក្ឞាំ ន នយេត៑ តទត៌្ហំ បុនរេកត្រ មិលត។ ");
INSERT INTO sankhm_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","ឯតទ៑ អាទេឝតោ នហិ កិន្ត្វនុជ្ញាត ឯវ មយា កថ្យតេ, ");
INSERT INTO sankhm_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","យតោ មមាវស្ថេវ សវ៌្វមានវានាមវស្ថា ភវត្វិតិ មម វាញ្ឆា កិន្ត្វីឝ្វរាទ៑ ឯកេនៃកោ វរោៜន្យេន ចាន្យោ វរ ឥត្ថមេកៃកេន ស្វកីយវរោ លព្ធះ។ ");
INSERT INTO sankhm_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","អបរម៑ អក្ឫតវិវាហាន៑ វិធវាឝ្ច ប្រតិ មមៃតន្និវេទនំ មមេវ តេឞាមវស្ថិតិ រ្ភទ្រា; ");
INSERT INTO sankhm_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","កិញ្ច យទិ តៃរិន្ទ្រិយាណិ និយន្តុំ ន ឝក្យន្តេ តហ៌ិ វិវាហះ ក្រិយតាំ យតះ កាមទហនាទ៑ វ្យូឍត្វំ ភទ្រំ។ ");
INSERT INTO sankhm_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","យេ ច ក្ឫតវិវាហាស្តេ មយា នហិ ប្រភុនៃវៃតទ៑ អាជ្ញាប្យន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","ភាយ៌្យា ភត៌្ត្ឫតះ ប្ឫថក៑ ន ភវតុ។ យទិ វា ប្ឫថគ្ភូតា ស្យាត៑ តហ៌ិ និវ៌ិវាហា តិឞ្ឋតុ ស្វីយបតិនា វា សន្ទធាតុ ភត៌្តាបិ ភាយ៌្យាំ ន ត្យជតុ។ ");
INSERT INTO sankhm_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","ឥតរាន៑ ជនាន៑ ប្រតិ ប្រភុ រ្ន ព្រវីតិ កិន្ត្វហំ ព្រវីមិ; កស្យចិទ៑ ភ្រាតុយ៌ោឞិទ៑ អវិឝ្វាសិនី សត្យបិ យទិ តេន សហវាសេ តុឞ្យតិ តហ៌ិ សា តេន ន ត្យជ្យតាំ។ ");
INSERT INTO sankhm_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","តទ្វត៑ កស្យាឝ្ចិទ៑ យោឞិតះ បតិរវិឝ្វាសី សន្នបិ យទិ តយា សហវាសេ តុឞ្យតិ តហ៌ិ ស តយា ន ត្យជ្យតាំ។ ");
INSERT INTO sankhm_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","យតោៜវិឝ្វាសី ភត៌្តា ភាយ៌្យយា បវិត្រីភូតះ, តទ្វទវិឝ្វាសិនី ភាយ៌្យា ភត៌្រា បវិត្រីភូតា; នោចេទ៑ យុឞ្មាកមបត្យាន្យឝុចីន្យភវិឞ្យន៑ កិន្ត្វធុនា តានិ បវិត្រាណិ សន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","អវិឝ្វាសី ជនោ យទិ វា ប្ឫថគ៑ ភវតិ តហ៌ិ ប្ឫថគ៑ ភវតុ; ឯតេន ភ្រាតា ភគិនី វា ន និពធ្យតេ តថាបិ វយមីឝ្វរេណ ឝាន្តយេ សមាហូតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","ហេ នារិ តវ ភត៌្តុះ បរិត្រាណំ ត្វត្តោ ភវិឞ្យតិ ន វេតិ ត្វយា កិំ ជ្ញាយតេ? ហេ នរ តវ ជាយាយាះ បរិត្រាណំ ត្វត្តេा ភវិឞ្យតិ ន វេតិ ត្វយា កិំ ជ្ញាយតេ? ");
INSERT INTO sankhm_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","ឯកៃកោ ជនះ បរមេឝ្វរាល្លព្ធំ យទ៑ ភជតេ យស្យាញ្ចាវស្ថាយាម៑ ឦឝ្វរេណាហ្វាយិ តទនុសារេណៃវាចរតុ តទហំ សវ៌្វសមាជស្ថាន៑ អាទិឝាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","ឆិន្នត្វគ៑ ភ្ឫត្វា យ អាហូតះ ស ប្រក្ឫឞ្ដត្វក៑ ន ភវតុ, តទ្វទ៑ អឆិន្នត្វគ៑ ភូត្វា យ អាហូតះ ស ឆិន្នត្វក៑ ន ភវតុ។ ");
INSERT INTO sankhm_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","ត្វក្ឆេទះ សារោ នហិ តទ្វទត្វក្ឆេទោៜបិ សារោ នហិ កិន្ត្វីឝ្វរស្យាជ្ញានាំ បាលនមេវ។ ");
INSERT INTO sankhm_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","យោ ជនោ យស្យាមវស្ថាយាមាហ្វាយិ ស តស្យាមេវាវតិឞ្ឋតាំ។ ");
INSERT INTO sankhm_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","ទាសះ សន៑ ត្វំ កិមាហូតោៜសិ? តន្មា ចិន្តយ, តថាច យទិ ស្វតន្ត្រោ ភវិតុំ ឝក្នុយាស្តហ៌ិ តទេវ វ្ឫណុ។ ");
INSERT INTO sankhm_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","យតះ ប្រភុនាហូតោ យោ ទាសះ ស ប្រភោ រ្មោចិតជនះ។ តទ្វទ៑ តេនាហូតះ ស្វតន្ត្រោ ជនោៜបិ ខ្រីឞ្ដស្យ ទាស ឯវ។ ");
INSERT INTO sankhm_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","យូយំ មូល្យេន ក្រីតា អតោ ហេតោ រ្មានវានាំ ទាសា មា ភវត។ ");
INSERT INTO sankhm_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","ហេ ភ្រាតរោ យស្យាមវស្ថាយាំ យស្យាហ្វានមភវត៑ តយា ស ឦឝ្វរស្យ សាក្ឞាត៑ តិឞ្ឋតុ។ ");
INSERT INTO sankhm_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","អបរម៑ អក្ឫតវិវាហាន៑ ជនាន៑ ប្រតិ ប្រភោះ កោៜប្យាទេឝោ មយា ន លព្ធះ កិន្តុ ប្រភោរនុកម្បយា វិឝ្វាស្យោ ភូតោៜហំ យទ៑ ភទ្រំ មន្យេ តទ៑ វទាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","វត៌្តមានាត៑ ក្លេឝសមយាត៑ មនុឞ្យស្យានូឍត្វំ ភទ្រមិតិ មយា ពុធ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","ត្វំ កិំ យោឞិតិ និពទ្ធោៜសិ តហ៌ិ មោចនំ ប្រាប្តុំ មា យតស្វ។ កិំ វា យោឞិតោ មុក្តោៜសិ? តហ៌ិ ជាយាំ មា គវេឞយ។ ");
INSERT INTO sankhm_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","វិវាហំ កុវ៌្វតា ត្វយា កិមបិ នាបារាធ្យតេ តទ្វទ៑ វ្យូហ្យមានយា យុវត្យាបិ កិមបិ នាបរាធ្យតេ តថាច តាទ្ឫឝៅ ទ្វៅ ជនៅ ឝារីរិកំ ក្លេឝំ លប្ស្យេតេ កិន្តុ យុឞ្មាន៑ ប្រតិ មម ករុណា វិទ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","ហេ ភ្រាតរោៜហមិទំ ព្រវីមិ, ឥតះ បរំ សមយោៜតីវ សំក្ឞិប្តះ, ");
INSERT INTO sankhm_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","អតះ ក្ឫតទារៃរក្ឫតទារៃរិវ រុទទ្ភិឝ្ចារុទទ្ភិរិវ សានន្ទៃឝ្ច និរានន្ទៃរិវ ក្រេត្ឫភិឝ្ចាភាគិភិរិវាចរិតវ្យំ ");
INSERT INTO sankhm_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","យេ ច សំសារេ ចរន្តិ តៃ រ្នាតិចរិតវ្យំ យត ឥហលេाកស្យ កៅតុកោ វិចលតិ។ ");
INSERT INTO sankhm_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","កិន្តុ យូយំ យន្និឝ្ចិន្តា ភវេតេតិ មម វាញ្ឆា។ អក្ឫតវិវាហោ ជនោ យថា ប្រភុំ បរិតោឞយេត៑ តថា ប្រភុំ ចិន្តយតិ, ");
INSERT INTO sankhm_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","កិន្តុ ក្ឫតវិវាហោ ជនោ យថា ភាយ៌្យាំ បរិតោឞយេត៑ តថា សំសារំ ចិន្តយតិ។ ");
INSERT INTO sankhm_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","តទ្វទ៑ ឩឍយោឞិតោ ៜនូឍា វិឝិឞ្យតេ។ យានូឍា សា យថា កាយមនសោះ បវិត្រា ភវេត៑ តថា ប្រភុំ ចិន្តយតិ យា ចោឍា សា យថា ភត៌្តារំ បរិតោឞយេត៑ តថា សំសារំ ចិន្តយតិ។ ");
INSERT INTO sankhm_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","អហំ យទ៑ យុឞ្មាន៑ ម្ឫគពន្ធិន្យា បរិក្ឞិបេយំ តទត៌្ហំ នហិ កិន្តុ យូយំ យទនិន្ទិតា ភូត្វា ប្រភោះ សេវនេៜពាធម៑ អាសក្តា ភវេត តទត៌្ហមេតានិ សវ៌្វាណិ យុឞ្មាកំ ហិតាយ មយា កថ្យន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","កស្យចិត៑ កន្យាយាំ យៅវនប្រាប្តាយាំ យទិ ស តស្យា អនូឍត្វំ និន្ទនីយំ វិវាហឝ្ច សាធយិតវ្យ ឥតិ មន្យតេ តហ៌ិ យថាភិលាឞំ ករោតុ, ឯតេន កិមបិ នាបរាត្ស្យតិ វិវាហះ ក្រិយតាំ។ ");
INSERT INTO sankhm_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","កិន្តុ ទុះខេនាក្លិឞ្ដះ កឝ្ចិត៑ បិតា យទិ ស្ថិរមនោគតះ ស្វមនោៜភិលាឞសាធនេ សមត៌្ហឝ្ច ស្យាត៑ មម កន្យា មយា រក្ឞិតវ្យេតិ មនសិ និឝ្ចិនោតិ ច តហ៌ិ ស ភទ្រំ កម៌្ម ករោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","អតោ យោ វិវាហំ ករោតិ ស ភទ្រំ កម៌្ម ករោតិ យឝ្ច វិវាហំ ន ករោតិ ស ភទ្រតរំ កម៌្ម ករោតិ។ ");
INSERT INTO sankhm_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","យាវត្កាលំ បតិ រ្ជីវតិ តាវទ៑ ភាយ៌្យា វ្យវស្ថយា និពទ្ធា តិឞ្ឋតិ កិន្តុ បត្យៅ មហានិទ្រាំ គតេ សា មុក្តីភូយ យមភិលឞតិ តេន សហ តស្យា វិវាហោ ភវិតុំ ឝក្នោតិ, កិន្ត្វេតត៑ កេវលំ ប្រភុភក្តានាំ មធ្យេ។ ");
INSERT INTO sankhm_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","តថាច សា យទិ និឞ្បតិកា តិឞ្ឋតិ តហ៌ិ តស្យាះ ក្ឞេមំ ភវិឞ្យតីតិ មម ភាវះ។ អបរម៑ ឦឝ្វរស្យាត្មា មមាប្យន្ត រ្វិទ្យត ឥតិ មយា ពុធ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","ទេវប្រសាទេ សវ៌្វេឞាម៑ អស្មាកំ ជ្ញានមាស្តេ តទ្វយំ វិទ្មះ។ តថាបិ ជ្ញានំ គវ៌្វំ ជនយតិ កិន្តុ ប្រេមតោ និឞ្ឋា ជាយតេ។ ");
INSERT INTO sankhm_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","អតះ កឝ្ចន យទិ មន្យតេ មម ជ្ញានមាស្ត ឥតិ តហ៌ិ តេន យាទ្ឫឝំ ជ្ញានំ ចេឞ្ដិតវ្យំ តាទ្ឫឝំ កិមបិ ជ្ញានមទ្យាបិ ន លព្ធំ។ ");
INSERT INTO sankhm_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","កិន្តុ យ ឦឝ្វរេ ប្រីយតេ ស ឦឝ្វរេណាបិ ជ្ញាយតេ។ ");
INSERT INTO sankhm_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","ទេវតាពលិប្រសាទភក្ឞណេ វយមិទំ វិទ្មោ យត៑ ជគន្មធ្យេ កោៜបិ ទេវោ ន វិទ្យតេ, ឯកឝ្ចេឝ្វរោ ទ្វិតីយោ នាស្តីតិ។ ");
INSERT INTO sankhm_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","ស្វគ៌េ ប្ឫថិវ្យាំ វា យទ្យបិ កេឞុចិទ៑ ឦឝ្វរ ឥតិ នាមារោប្យតេ តាទ្ឫឝាឝ្ច ពហវ ឦឝ្វរា ពហវឝ្ច ប្រភវោ វិទ្យន្តេ ");
INSERT INTO sankhm_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","តថាប្យស្មាកមទ្វិតីយ ឦឝ្វរះ ស បិតា យស្មាត៑ សវ៌្វេឞាំ យទត៌្ហញ្ចាស្មាកំ ស្ឫឞ្ដិ រ្ជាតា, អស្មាកញ្ចាទ្វិតីយះ ប្រភុះ ស យីឝុះ ខ្រីឞ្ដោ យេន សវ៌្វវស្តូនាំ យេនាស្មាកមបិ ស្ឫឞ្ដិះ ក្ឫតា។ ");
INSERT INTO sankhm_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","អធិកន្តុ ជ្ញានំ សវ៌្វេឞាំ នាស្តិ យតះ កេចិទទ្យាបិ ទេវតាំ សម្មន្យ ទេវប្រសាទមិវ តទ៑ ភក្ឞ្យំ ភុញ្ជតេ តេន ទុព៌្ពលតយា តេឞាំ ស្វាន្តានិ មលីមសានិ ភវន្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","កិន្តុ ភក្ឞ្យទ្រវ្យាទ៑ វយម៑ ឦឝ្វរេណ គ្រាហ្យា ភវាមស្តន្នហិ យតោ ភុង្ក្ត្វា វយមុត្ក្ឫឞ្ដា ន ភវាមស្តទ្វទភុង្ក្ត្វាប្យបក្ឫឞ្ដា ន ភវាមះ។ ");
INSERT INTO sankhm_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","អតោ យុឞ្មាកំ យា ក្ឞមតា សា ទុព៌្ពលានាម៑ ឧន្មាថស្វរូបា យន្ន ភវេត៑ តទត៌្ហំ សាវធានា ភវត។ ");
INSERT INTO sankhm_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","យតោ ជ្ញានវិឝិឞ្ដស្ត្វំ យទិ ទេវាលយេ ឧបវិឞ្ដះ កេនាបិ ទ្ឫឝ្យសេ តហ៌ិ តស្យ ទុព៌្ពលស្យ មនសិ កិំ ប្រសាទភក្ឞណ ឧត្សាហោ ន ជនិឞ្យតេ? ");
INSERT INTO sankhm_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","តថា សតិ យស្យ ក្ឫតេ ខ្រីឞ្ដោ មមារ តវ ស ទុព៌្ពលោ ភ្រាតា តវ ជ្ញានាត៑ កិំ ន វិនំក្ឞ្យតិ? ");
INSERT INTO sankhm_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","ឥត្យនេន ប្រការេណ ភ្រាត្ឫណាំ វិរុទ្ធម៑ អបរាធ្យទ្ភិស្តេឞាំ ទុព៌្ពលានិ មនាំសិ វ្យាឃាតយទ្ភិឝ្ច យុឞ្មាភិះ ខ្រីឞ្ដស្យ វៃបរីត្យេនាបរាធ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","អតោ ហេតោះ បិឝិតាឝនំ យទិ មម ភ្រាតុ រ្វិឃ្នស្វរូបំ ភវេត៑ តហ៌្យហំ យត៑ ស្វភ្រាតុ រ្វិឃ្នជនកោ ន ភវេយំ តទត៌្ហំ យាវជ្ជីវនំ បិឝិតំ ន ភោក្ឞ្យេ។ ");
INSERT INTO sankhm_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","អហំ កិម៑ ឯកះ ប្រេរិតោ នាស្មិ? កិមហំ ស្វតន្ត្រោ នាស្មិ? អស្មាកំ ប្រភុ រ្យីឝុះ ខ្រីឞ្ដះ កិំ មយា នាទឝ៌ិ? យូយមបិ កិំ ប្រភុនា មទីយឝ្រមផលស្វរូបា ន ភវថ? ");
INSERT INTO sankhm_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","អន្យលោកានាំ ក្ឫតេ យទ្យប្យហំ ប្រេរិតោ ន ភវេយំ តថាច យុឞ្មត្ក្ឫតេ ប្រេរិតោៜស្មិ យតះ ប្រភុនា មម ប្រេរិតត្វបទស្យ មុទ្រាស្វរូបា យូយមេវាធ្វេ។ ");
INSERT INTO sankhm_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","យេ លោកា មយិ ទោឞមារោបយន្តិ តាន៑ ប្រតិ មម ប្រត្យុត្តរមេតត៑។ ");
INSERT INTO sankhm_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","ភោជនបានយោះ កិមស្មាកំ ក្ឞមតា នាស្តិ? ");
INSERT INTO sankhm_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","អន្យេ ប្រេរិតាះ ប្រភោ រ្ភ្រាតរៅ កៃផាឝ្ច យត៑ កុវ៌្វន្តិ តទ្វត៑ កាញ្ចិត៑ ធម៌្មភគិនីំ វ្យូហ្យ តយា សាទ៌្ធំ បយ៌្យដិតុំ វយំ កិំ ន ឝក្នុមះ? ");
INSERT INTO sankhm_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","សាំសារិកឝ្រមស្យ បរិត្យាគាត៑ កិំ កេវលមហំ ពណ៌ព្ពាឝ្ច និវារិតៅ? ");
INSERT INTO sankhm_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","និជធនវ្យយេន កះ សំគ្រាមំ ករោតិ? កោ វា ទ្រាក្ឞាក្ឞេត្រំ ក្ឫត្វា តត្ផលានិ ន ភុង្ក្តេ? កោ វា បឝុវ្រជំ បាលយន៑ តត្បយោ ន បិវតិ? ");
INSERT INTO sankhm_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","កិមហំ កេវលាំ មានុឞិកាំ វាចំ វទាមិ? វ្យវស្ថាយាំ កិមេតាទ្ឫឝំ វចនំ ន វិទ្យតេ? ");
INSERT INTO sankhm_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","មូសាវ្យវស្ថាគ្រន្ថេ លិខិតមាស្តេ, ត្វំ ឝស្យមទ៌្ទកវ្ឫឞស្យាស្យំ ន ភំត្ស្យសីតិ។ ឦឝ្វរេណ ពលីវទ៌្ទានាមេវ ចិន្តា កិំ ក្រិយតេ? ");
INSERT INTO sankhm_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","កិំ វា សវ៌្វថាស្មាកំ ក្ឫតេ តទ្វចនំ តេនោក្តំ? អស្មាកមេវ ក្ឫតេ តល្លិខិតំ។ យះ ក្ឞេត្រំ កឞ៌តិ តេន ប្រត្យាឝាយុក្តេន កឞ៌្ដវ្យំ, យឝ្ច ឝស្យានិ មទ៌្ទយតិ តេន លាភប្រត្យាឝាយុក្តេន មទ៌្ទិតវ្យំ។ ");
INSERT INTO sankhm_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","យុឞ្មត្ក្ឫតេៜស្មាភិះ បារត្រិកាណិ ពីជានិ រោបិតានិ, អតោ យុឞ្មាកមៃហិកផលានាំ វយម៑ អំឝិនោ ភវិឞ្យាមះ កិមេតត៑ មហត៑ កម៌្ម? ");
INSERT INTO sankhm_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","យុឞ្មាសុ យោៜធិការស្តស្យ ភាគិនោ យទ្យន្យេ ភវេយុស្តហ៌្យស្មាភិស្តតោៜធិកំ កិំ តស្យ ភាគិភិ រ្ន ភវិតវ្យំ? អធិកន្តុ វយំ តេនាធិការេណ ន វ្យវហ្ឫតវន្តះ កិន្តុ ខ្រីឞ្ដីយសុសំវាទស្យ កោៜបិ វ្យាឃាតោៜស្មាភិយ៌ន្ន ជាយេត តទត៌្ហំ សវ៌្វំ សហាមហេ។ ");
INSERT INTO sankhm_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","អបរំ យេ បវិត្រវស្តូនាំ បរិចយ៌្យាំ កុវ៌្វន្តិ តេ បវិត្រវស្តុតោ ភក្ឞ្យាណិ លភន្តេ, យេ ច វេទ្យាះ បរិចយ៌្យាំ កុវ៌្វន្តិ តេ វេទិស្ថវស្តូនាម៑ អំឝិនោ ភវន្ត្យេតទ៑ យូយំ កិំ ន វិទ? ");
INSERT INTO sankhm_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","តទ្វទ៑ យេ សុសំវាទំ ឃោឞយន្តិ តៃះ សុសំវាទេន ជីវិតវ្យមិតិ ប្រភុនាទិឞ្ដំ។ ");
INSERT INTO sankhm_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","អហមេតេឞាំ សវ៌្វេឞាំ កិមបិ នាឝ្រិតវាន៑ មាំ ប្រតិ តទនុសារាត៑ អាចរិតវ្យមិត្យាឝយេនាបិ បត្រមិទំ មយា ន លិខ្យតេ យតះ កេនាបិ ជនេន មម យឝសោ មុធាករណាត៑ មម មរណំ វរំ។ ");
INSERT INTO sankhm_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","សុសំវាទឃេឞណាត៑ មម យឝោ ន ជាយតេ យតស្តទ្ឃោឞណំ មមាវឝ្យកំ យទ្យហំ សុសំវាទំ ន ឃោឞយេយំ តហ៌ិ មាំ ធិក៑។ ");
INSERT INTO sankhm_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","ឥច្ឆុកេន តត៑ កុវ៌្វតា មយា ផលំ លប្ស្យតេ កិន្ត្វនិច្ឆុកេៜបិ មយិ តត្កម៌្មណោ ភារោៜរ្បិតោៜស្តិ។ ");
INSERT INTO sankhm_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","ឯតេន មយា លភ្យំ ផលំ កិំ? សុសំវាទេន មម យោៜធិការ អាស្តេ តំ យទភទ្រភាវេន នាចរេយំ តទត៌្ហំ សុសំវាទឃោឞណសមយេ តស្យ ខ្រីឞ្ដីយសុសំវាទស្យ និវ៌្យយីករណមេវ មម ផលំ។ ");
INSERT INTO sankhm_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","សវ៌្វេឞាម៑ អនាយត្តោៜហំ យទ៑ ភូរិឝោ លោកាន៑ ប្រតិបទ្យេ តទត៌្ហំ សវ៌្វេឞាំ ទាសត្វមង្គីក្ឫតវាន៑។ ");
INSERT INTO sankhm_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","យិហូទីយាន៑ យត៑ ប្រតិបទ្យេ តទត៌្ហំ យិហូទីយានាំ ក្ឫតេ យិហូទីយឥវាភវំ។ យេ ច វ្យវស្ថាយត្តាស្តាន៑ យត៑ ប្រតិបទ្យេ តទត៌្ហំ វ្យវស្ថានាយត្តោ យោៜហំ សោៜហំ វ្យវស្ថាយត្តានាំ ក្ឫតេ វ្យវស្ថាយត្តឥវាភវំ។ ");
INSERT INTO sankhm_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","យេ ចាលព្ធវ្យវស្ថាស្តាន៑ យត៑ ប្រតិបទ្យេ តទត៌្ហម៑ ឦឝ្វរស្យ សាក្ឞាទ៑ អលព្ធវ្យវស្ថោ ន ភូត្វា ខ្រីឞ្ដេន លព្ធវ្យវស្ថោ យោៜហំ សោៜហម៑ អលព្ធវ្យវស្ថានាំ ក្ឫតេៜលព្ធវ្យវស្ថ ឥវាភវំ។ ");
INSERT INTO sankhm_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","ទុព៌្ពលាន៑ យត៑ ប្រតិបទ្យេ តទត៌្ហមហំ ទុព៌្ពលានាំ ក្ឫតេ ទុព៌្ពលឥវាភវំ។ ឥត្ថំ កេនាបិ ប្រការេណ កតិបយា លោកា យន្មយា បរិត្រាណំ ប្រាប្នុយុស្តទត៌្ហំ យោ យាទ្ឫឝ អាសីត៑ តស្យ ក្ឫតេ ៜហំ តាទ្ឫឝឥវាភវំ។ ");
INSERT INTO sankhm_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","ឥទ្ឫឝ អាចារះ សុសំវាទាត៌្ហំ មយា ក្រិយតេ យតោៜហំ តស្យ ផលានាំ សហភាគី ភវិតុមិច្ឆាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","បណ្យលាភាត៌្ហំ យេ ធាវន្តិ ធាវតាំ តេឞាំ សវ៌្វេឞាំ កេវល ឯកះ បណ្យំ លភតេ យុឞ្មាភិះ កិមេតន្ន ជ្ញាយតេ? អតោ យូយំ យថា បណ្យំ លប្ស្យធ្វេ តថៃវ ធាវត។ ");
INSERT INTO sankhm_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","មល្លា អបិ សវ៌្វភោគេ បរិមិតភោគិនោ ភវន្តិ តេ តុ ម្លានាំ ស្រជំ លិប្សន្តេ កិន្តុ វយម៑ អម្លានាំ លិប្សាមហេ។ ");
INSERT INTO sankhm_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","តស្មាទ៑ អហមបិ ធាវាមិ កិន្តុ លក្ឞ្យមនុទ្ទិឝ្យ ធាវាមិ តន្នហិ។ អហំ មល្លឥវ យុធ្យាមិ ច កិន្តុ ឆាយាមាឃាតយន្និវ យុធ្យាមិ តន្នហិ។ ");
INSERT INTO sankhm_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","ឥតរាន៑ ប្រតិ សុសំវាទំ ឃោឞយិត្វាហំ យត៑ ស្វយមគ្រាហ្យោ ន ភវាមិ តទត៌្ហំ ទេហម៑ អាហន្មិ វឝីកុវ៌្វេ ច។ ");
INSERT INTO sankhm_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","ហេ ភ្រាតរះ, អស្មត្បិត្ឫបុរុឞានធិ យូយំ យទជ្ញាតា ន តិឞ្ឋតេតិ មម វាញ្ឆា, តេ សវ៌្វេ មេឃាធះស្ថិតា ពភូវុះ សវ៌្វេ សមុទ្រមធ្យេន វវ្រជុះ, ");
INSERT INTO sankhm_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","សវ៌្វេ មូសាមុទ្ទិឝ្យ មេឃសមុទ្រយោ រ្មជ្ជិតា ពភូវុះ ");
INSERT INTO sankhm_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","សវ៌្វ ឯកម៑ អាត្មិកំ ភក្ឞ្យំ ពុភុជិរ ឯកម៑ អាត្មិកំ បេយំ បបុឝ្ច ");
INSERT INTO sankhm_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","យតស្តេៜនុចរត អាត្មិកាទ៑ អចលាត៑ លព្ធំ តោយំ បបុះ សោៜចលះ ខ្រីឞ្ដឯវ។ ");
INSERT INTO sankhm_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","តថា សត្យបិ តេឞាំ មធ្យេៜធិកេឞុ លោកេឞ្វីឝ្វរោ ន សន្តុតោឞេតិ ហេតោស្តេ ប្រន្តរេ និបាតិតាះ។ ");
INSERT INTO sankhm_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","ឯតស្មិន៑ តេ ៜស្មាកំ និទឝ៌នស្វរូបា ពភូវុះ; អតស្តេ យថា កុត្សិតាភិលាឞិណោ ពភូវុរស្មាភិស្តថា កុត្សិតាភិលាឞិភិ រ្ន ភវិតវ្យំ។ ");
INSERT INTO sankhm_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","លិខិតមាស្តេ, លោកា ភោក្តុំ បាតុញ្ចោបវិវិឝុស្តតះ ក្រីឌិតុមុត្ថិតា ឥតយនេន ប្រការេណ តេឞាំ កៃឝ្ចិទ៑ យទ្វទ៑ ទេវបូជា ក្ឫតា យុឞ្មាភិស្តទ្វត៑ ន ក្រិយតាំ។ ");
INSERT INTO sankhm_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","អបរំ តេឞាំ កៃឝ្ចិទ៑ យទ្វទ៑ វ្យភិចារះ ក្ឫតស្តេន ចៃកស្មិន៑ ទិនេ ត្រយោវិំឝតិសហស្រាណិ លោកា និបាតិតាស្តទ្វទ៑ អស្មាភិ រ្វ្យភិចារោ ន កត៌្តវ្យះ។ ");
INSERT INTO sankhm_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","តេឞាំ កេចិទ៑ យទ្វត៑ ខ្រីឞ្ដំ បរីក្ឞិតវន្តស្តស្មាទ៑ ភុជង្គៃ រ្នឞ្ដាឝ្ច តទ្វទ៑ អស្មាភិះ ខ្រីឞ្ដោ ន បរីក្ឞិតវ្យះ។ ");
INSERT INTO sankhm_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","តេឞាំ កេចិទ៑ យថា វាក្កលហំ ក្ឫតវន្តស្តត្ការណាត៑ ហន្ត្រា វិនាឝិតាឝ្ច យុឞ្មាភិស្តទ្វទ៑ វាក្កលហោ ន ក្រិយតាំ។ ");
INSERT INTO sankhm_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","តាន៑ ប្រតិ យាន្យេតានិ ជឃដិរេ តាន្យស្មាកំ និទឝ៌នានិ ជគតះ ឝេឞយុគេ វត៌្តមានានាម៑ អស្មាកំ ឝិក្ឞាត៌្ហំ លិខិតានិ ច ពភូវុះ។ ");
INSERT INTO sankhm_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","អតឯវ យះ កឝ្ចិទ៑ សុស្ថិរំមន្យះ ស យន្ន បតេត៑ តត្រ សាវធានោ ភវតុ។ ");
INSERT INTO sankhm_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","មានុឞិកបរីក្ឞាតិរិក្តា កាបិ បរីក្ឞា យុឞ្មាន៑ នាក្រាមត៑, ឦឝ្វរឝ្ច វិឝ្វាស្យះ សោៜតិឝក្ត្យាំ បរីក្ឞាយាំ បតនាត៑ យុឞ្មាន៑ រក្ឞិឞ្យតិ, បរីក្ឞា ច យទ៑ យុឞ្មាភិះ សោឍុំ ឝក្យតេ តទត៌្ហំ តយា សហ និស្តារស្យ បន្ថានំ និរូបយិឞ្យតិ។ ");
INSERT INTO sankhm_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","ហេ ប្រិយភ្រាតរះ, ទេវបូជាតោ ទូរម៑ អបសរត។ ");
INSERT INTO sankhm_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","អហំ យុឞ្មាន៑ វិជ្ញាន៑ មត្វា ប្រភាឞេ មយា យត៑ កថ្យតេ តទ៑ យុឞ្មាភិ រ្វិវិច្យតាំ។ ");
INSERT INTO sankhm_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","យទ៑ ធន្យវាទបាត្រម៑ អស្មាភិ រ្ធន្យំ គទ្យតេ តត៑ កិំ ខ្រីឞ្ដស្យ ឝោណិតស្យ សហភាគិត្វំ នហិ? យឝ្ច បូបោៜស្មាភិ រ្ភជ្យតេ ស កិំ ខ្រីឞ្ដស្យ វបុឞះ សហភាគិត្វំ នហិ? ");
INSERT INTO sankhm_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","វយំ ពហវះ សន្តោៜប្យេកបូបស្វរូបា ឯកវបុះស្វរូបាឝ្ច ភវាមះ, យតោ វយំ សវ៌្វ ឯកបូបស្យ សហភាគិនះ។ ");
INSERT INTO sankhm_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","យូយំ ឝារីរិកម៑ ឥស្រាយេលីយវំឝំ និរីក្ឞធ្វំ។ យេ ពលីនាំ មាំសានិ ភុញ្ជតេ តេ កិំ យជ្ញវេទ្យាះ សហភាគិនោ ន ភវន្តិ? ");
INSERT INTO sankhm_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","ឥត្យនេន មយា កិំ កថ្យតេ? ទេវតា វាស្តវិកី ទេវតាយៃ ពលិទានំ វា វាស្តវិកំ កិំ ភវេត៑? ");
INSERT INTO sankhm_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","តន្នហិ កិន្តុ ភិន្នជាតិភិ រ្យេ ពលយោ ទីយន្តេ ត ឦឝ្វរាយ តន្នហិ ភូតេភ្យឯវ ទីយន្តេ តស្មាទ៑ យូយំ យទ៑ ភូតានាំ សហភាគិនោ ភវថេត្យហំ នាភិលឞាមិ។ ");
INSERT INTO sankhm_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","ប្រភោះ កំសេន ភូតានាមបិ កំសេន បានំ យុឞ្មាភិរសាធ្យំ; យូយំ ប្រភោ រ្ភោជ្យស្យ ភូតានាមបិ ភោជ្យស្យ សហភាគិនោ ភវិតុំ ន ឝក្នុថ។ ");
INSERT INTO sankhm_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","វយំ កិំ ប្រភុំ ស្បទ៌្ធិឞ្យាមហេ? វយំ កិំ តស្មាទ៑ ពលវន្តះ? ");
INSERT INTO sankhm_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","មាំ ប្រតិ សវ៌្វំ កម៌្មាប្រតិឞិទ្ធំ កិន្តុ ន សវ៌្វំ ហិតជនកំ សវ៌្វម៑ អប្រតិឞិទ្ធំ កិន្តុ ន សវ៌្វំ និឞ្ឋាជនកំ។ ");
INSERT INTO sankhm_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","អាត្មហិតះ កេនាបិ ន ចេឞ្ដិតវ្យះ កិន្តុ សវ៌្វៃះ បរហិតឝ្ចេឞ្ដិតវ្យះ។ ");
INSERT INTO sankhm_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","អាបណេ យត៑ ក្រយ្យំ តទ៑ យុឞ្មាភិះ សំវេទស្យាត៌្ហំ កិមបិ ន ប្ឫឞ្ដ្វា ភុជ្យតាំ ");
INSERT INTO sankhm_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","យតះ ប្ឫថិវី តន្មធ្យស្ថញ្ច សវ៌្វំ បរមេឝ្វរស្យ។ ");
INSERT INTO sankhm_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","អបរម៑ អវិឝ្វាសិលោកានាំ កេនចិត៑ និមន្ត្រិតា យូយំ យទិ តត្រ ជិគមិឞថ តហ៌ិ តេន យទ៑ យទ៑ ឧបស្ថាប្យតេ តទ៑ យុឞ្មាភិះ សំវេទស្យាត៌្ហំ កិមបិ ន ប្ឫឞ្ដ្វា ភុជ្យតាំ។ ");
INSERT INTO sankhm_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","កិន្តុ តត្រ យទិ កឝ្ចិទ៑ យុឞ្មាន៑ វទេត៑ ភក្ឞ្យមេតទ៑ ទេវតាយាះ ប្រសាទ ឥតិ តហ៌ិ តស្យ ជ្ញាបយិតុរនុរោធាត៑ សំវេទស្យាត៌្ហញ្ច តទ៑ យុឞ្មាភិ រ្ន ភោក្តវ្យំ។ ប្ឫថិវី តន្មធ្យស្ថញ្ច សវ៌្វំ បរមេឝ្វរស្យ, ");
INSERT INTO sankhm_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","សត្យមេតត៑, កិន្តុ មយា យះ សំវេទោ និទ៌្ទិឝ្យតេ ស តវ នហិ បរស្យៃវ។ ");
INSERT INTO sankhm_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","អនុគ្រហបាត្រេណ មយា ធន្យវាទំ ក្ឫត្វា យទ៑ ភុជ្យតេ តត្ការណាទ៑ អហំ កុតោ និន្ទិឞ្យេ? ");
INSERT INTO sankhm_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","តស្មាទ៑ ភោជនំ បានម៑ អន្យទ្វា កម៌្ម កុវ៌្វទ្ភិ រ្យុឞ្មាភិះ សវ៌្វមេវេឝ្វរស្យ មហិម្នះ ប្រកាឝាត៌្ហំ ក្រិយតាំ។ ");
INSERT INTO sankhm_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","យិហូទីយានាំ ភិន្នជាតីយានាម៑ ឦឝ្វរស្យ សមាជស្យ វា វិឃ្នជនកៃ រ្យុឞ្មាភិ រ្ន ភវិតវ្យំ។ ");
INSERT INTO sankhm_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","អហមប្យាត្មហិតម៑ អចេឞ្ដមានោ ពហូនាំ បរិត្រាណាត៌្ហំ តេឞាំ ហិតំ ចេឞ្ដមានះ សវ៌្វវិឞយេ សវ៌្វេឞាំ តុឞ្ដិករោ ភវាមីត្យនេនាហំ យទ្វត៑ ខ្រីឞ្ដស្យានុគាមី តទ្វទ៑ យូយំ មមានុគាមិនោ ភវត។ ");
INSERT INTO sankhm_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","ហេ ភ្រាតរះ, យូយំ សវ៌្វស្មិន៑ កាយ៌្យេ មាំ ស្មរថ មយា ច យាទ្ឫគុបទិឞ្ដាស្តាទ្ឫគាចរថៃតត្ការណាត៑ មយា ប្រឝំសនីយា អាធ្ពេ។ ");
INSERT INTO sankhm_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","តថាបិ មមៃឞា វាញ្ឆា យទ៑ យូយមិទម៑ អវគតា ភវថ, ");
INSERT INTO sankhm_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","ឯកៃកស្យ បុរុឞស្យោត្តមាង្គស្វរូបះ ខ្រីឞ្ដះ, យោឞិតឝ្ចោត្តមាង្គស្វរូបះ បុមាន៑, ខ្រីឞ្ដស្យ ចោត្តមាង្គស្វរូប ឦឝ្វរះ។ ");
INSERT INTO sankhm_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","អបរម៑ អាច្ឆាទិតោត្តមាង្គេន យេន បុំសា ប្រាត៌្ហនា ក្រិយត ឦឝ្វរីយវាណី កថ្យតេ វា តេន ស្វីយោត្តមាង្គម៑ អវជ្ញាយតេ។ ");
INSERT INTO sankhm_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","អនាច្ឆាទិតោត្តមាង្គយា យយា យោឞិតា ច ប្រាត៌្ហនា ក្រិយត ឦឝ្វរីយវាណី កថ្យតេ វា តយាបិ ស្វីយោត្តមាង្គម៑ អវជ្ញាយតេ យតះ សា មុណ្ឌិតឝិរះសទ្ឫឝា។ ");
INSERT INTO sankhm_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","អនាច្ឆាទិតមស្តកា យា យោឞិត៑ តស្យាះ ឝិរះ មុណ្ឌនីយមេវ កិន្តុ យោឞិតះ កេឝច្ឆេទនំ ឝិរោមុណ្ឌនំ វា យទិ លជ្ជាជនកំ ភវេត៑ តហ៌ិ តយា ស្វឝិរ អាច្ឆាទ្យតាំ។ ");
INSERT INTO sankhm_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","បុមាន៑ ឦឝ្វរស្យ ប្រតិមូត៌្តិះ ប្រតិតេជះស្វរូបឝ្ច តស្មាត៑ តេន ឝិរោ នាច្ឆាទនីយំ កិន្តុ សីមន្តិនី បុំសះ ប្រតិពិម្ពស្វរូបា។ ");
INSERT INTO sankhm_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","យតោ យោឞាតះ បុមាន៑ នោទបាទិ កិន្តុ បុំសោ យោឞិទ៑ ឧទបាទិ។ ");
INSERT INTO sankhm_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","អធិកន្តុ យោឞិតះ ក្ឫតេ បុំសះ ស្ឫឞ្ដិ រ្ន ពភូវ កិន្តុ បុំសះ ក្ឫតេ យោឞិតះ ស្ឫឞ្ដិ រ្ពភូវ។ ");
INSERT INTO sankhm_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","ឥតិ ហេតោ រ្ទូតានាម៑ អាទរាទ៑ យោឞិតា ឝិរស្យធីនតាសូចកម៑ អាវរណំ ធត៌្តវ្យំ។ ");
INSERT INTO sankhm_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","តថាបិ ប្រភោ រ្វិធិនា បុមាំសំ វិនា យោឞិន្ន ជាយតេ យោឞិតញ្ច វិនា បុមាន៑ ន ជាយតេ។ ");
INSERT INTO sankhm_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","យតោ យថា បុំសោ យោឞិទ៑ ឧទបាទិ តថា យោឞិតះ បុមាន៑ ជាយតេ, សវ៌្វវស្តូនិ ចេឝ្វរាទ៑ ឧត្បទ្យន្តេ។ ");
INSERT INTO sankhm_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","យុឞ្មាភិរេវៃតទ៑ វិវិច្យតាំ, អនាវ្ឫតយា យោឞិតា ប្រាត៌្ហនំ កិំ សុទ្ឫឝ្យំ ភវេត៑? ");
INSERT INTO sankhm_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","បុរុឞស្យ ទីគ៌្ហកេឝត្វំ តស្យ លជ្ជាជនកំ, កិន្តុ យោឞិតោ ទីគ៌្ហកេឝត្វំ តស្យា គៅរវជនកំ ");
INSERT INTO sankhm_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","យត អាច្ឆាទនាយ តស្យៃ កេឝា ទត្តា ឥតិ កិំ យុឞ្មាភិះ ស្វភាវតោ ន ឝិក្ឞ្យតេ? ");
INSERT INTO sankhm_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","អត្រ យទិ កឝ្ចិទ៑ វិវទិតុម៑ ឥច្ឆេត៑ តហ៌្យស្មាកម៑ ឦឝ្វរីយសមិតីនាញ្ច តាទ្ឫឝី រីតិ រ្ន វិទ្យតេ។ ");
INSERT INTO sankhm_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","យុឞ្មាភិ រ្ន ភទ្រាយ កិន្តុ កុត្សិតាយ សមាគម្យតេ តស្មាទ៑ ឯតានិ ភាឞមាណេន មយា យូយំ ន ប្រឝំសនីយាះ។ ");
INSERT INTO sankhm_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","ប្រថមតះ សមិតៅ សមាគតានាំ យុឞ្មាកំ មធ្យេ ភេទាះ សន្តីតិ វាត៌្តា មយា ឝ្រូយតេ តន្មធ្យេ កិញ្ចិត៑ សត្យំ មន្យតេ ច។ ");
INSERT INTO sankhm_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","យតោ ហេតោ រ្យុឞ្មន្មធ្យេ យេ បរីក្ឞិតាស្តេ យត៑ ប្រកាឝ្យន្តេ តទត៌្ហំ ភេទៃ រ្ភវិតវ្យមេវ។ ");
INSERT INTO sankhm_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","ឯកត្រ សមាគតៃ រ្យុឞ្មាភិះ ប្រភាវំ ភេाជ្យំ ភុជ្យត ឥតិ នហិ; ");
INSERT INTO sankhm_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","យតោ ភោជនកាលេ យុឞ្មាកមេកៃកេន ស្វកីយំ ភក្ឞ្យំ តូណ៌ំ គ្រស្យតេ តស្មាទ៑ ឯកោ ជនោ ពុភុក្ឞ