﻿USE sofia;
DROP TABLE IF EXISTS sofia.sankan_vpl;
CREATE TABLE sankan_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sankan_vpl WRITE;
INSERT INTO sankan_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ಇಬ್ರಾಹೀಮಃ ಸನ್ತಾನೋ ದಾಯೂದ್ ತಸ್ಯ ಸನ್ತಾನೋ ಯೀಶುಖ್ರೀಷ್ಟಸ್ತಸ್ಯ ಪೂರ್ವ್ವಪುರುಷವಂಶಶ್ರೇಣೀ| ");
INSERT INTO sankan_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ಇಬ್ರಾಹೀಮಃ ಪುತ್ರ ಇಸ್ಹಾಕ್ ತಸ್ಯ ಪುತ್ರೋ ಯಾಕೂಬ್ ತಸ್ಯ ಪುತ್ರೋ ಯಿಹೂದಾಸ್ತಸ್ಯ ಭ್ರಾತರಶ್ಚ| ");
INSERT INTO sankan_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ತಸ್ಮಾದ್ ಯಿಹೂದಾತಸ್ತಾಮರೋ ಗರ್ಭೇ ಪೇರಸ್ಸೇರಹೌ ಜಜ್ಞಾತೇ, ತಸ್ಯ ಪೇರಸಃ ಪುತ್ರೋ ಹಿಷ್ರೋಣ್ ತಸ್ಯ ಪುತ್ರೋ ಽರಾಮ್| ");
INSERT INTO sankan_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ತಸ್ಯ ಪುತ್ರೋ ಽಮ್ಮೀನಾದಬ್ ತಸ್ಯ ಪುತ್ರೋ ನಹಶೋನ್ ತಸ್ಯ ಪುತ್ರಃ ಸಲ್ಮೋನ್| ");
INSERT INTO sankan_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ತಸ್ಮಾದ್ ರಾಹಬೋ ಗರ್ಭೇ ಬೋಯಮ್ ಜಜ್ಞೇ, ತಸ್ಮಾದ್ ರೂತೋ ಗರ್ಭೇ ಓಬೇದ್ ಜಜ್ಞೇ, ತಸ್ಯ ಪುತ್ರೋ ಯಿಶಯಃ| ");
INSERT INTO sankan_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ತಸ್ಯ ಪುತ್ರೋ ದಾಯೂದ್ ರಾಜಃ ತಸ್ಮಾದ್ ಮೃತೋರಿಯಸ್ಯ ಜಾಯಾಯಾಂ ಸುಲೇಮಾನ್ ಜಜ್ಞೇ| ");
INSERT INTO sankan_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ತಸ್ಯ ಪುತ್ರೋ ರಿಹಬಿಯಾಮ್, ತಸ್ಯ ಪುತ್ರೋಽಬಿಯಃ, ತಸ್ಯ ಪುತ್ರ ಆಸಾ:| ");
INSERT INTO sankan_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ತಸ್ಯ ಸುತೋ ಯಿಹೋಶಾಫಟ್ ತಸ್ಯ ಸುತೋ ಯಿಹೋರಾಮ ತಸ್ಯ ಸುತ ಉಷಿಯಃ| ");
INSERT INTO sankan_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ತಸ್ಯ ಸುತೋ ಯೋಥಮ್ ತಸ್ಯ ಸುತ ಆಹಮ್ ತಸ್ಯ ಸುತೋ ಹಿಷ್ಕಿಯಃ| ");
INSERT INTO sankan_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ತಸ್ಯ ಸುತೋ ಮಿನಶಿಃ, ತಸ್ಯ ಸುತ ಆಮೋನ್ ತಸ್ಯ ಸುತೋ ಯೋಶಿಯಃ| ");
INSERT INTO sankan_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ಬಾಬಿಲ್ನಗರೇ ಪ್ರವಸನಾತ್ ಪೂರ್ವ್ವಂ ಸ ಯೋಶಿಯೋ ಯಿಖನಿಯಂ ತಸ್ಯ ಭ್ರಾತೃಂಶ್ಚ ಜನಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ತತೋ ಬಾಬಿಲಿ ಪ್ರವಸನಕಾಲೇ ಯಿಖನಿಯಃ ಶಲ್ತೀಯೇಲಂ ಜನಯಾಮಾಸ, ತಸ್ಯ ಸುತಃ ಸಿರುಬ್ಬಾವಿಲ್| ");
INSERT INTO sankan_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ತಸ್ಯ ಸುತೋ ಽಬೋಹುದ್ ತಸ್ಯ ಸುತ ಇಲೀಯಾಕೀಮ್ ತಸ್ಯ ಸುತೋಽಸೋರ್| ");
INSERT INTO sankan_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ಅಸೋರಃ ಸುತಃ ಸಾದೋಕ್ ತಸ್ಯ ಸುತ ಆಖೀಮ್ ತಸ್ಯ ಸುತ ಇಲೀಹೂದ್| ");
INSERT INTO sankan_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ತಸ್ಯ ಸುತ ಇಲಿಯಾಸರ್ ತಸ್ಯ ಸುತೋ ಮತ್ತನ್| ");
INSERT INTO sankan_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ತಸ್ಯ ಸುತೋ ಯಾಕೂಬ್ ತಸ್ಯ ಸುತೋ ಯೂಷಫ್ ತಸ್ಯ ಜಾಯಾ ಮರಿಯಮ್; ತಸ್ಯ ಗರ್ಭೇ ಯೀಶುರಜನಿ, ತಮೇವ ಖ್ರೀಷ್ಟಮ್ (ಅರ್ಥಾದ್ ಅಭಿಷಿಕ್ತಂ) ವದನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ಇತ್ಥಮ್ ಇಬ್ರಾಹೀಮೋ ದಾಯೂದಂ ಯಾವತ್ ಸಾಕಲ್ಯೇನ ಚತುರ್ದಶಪುರುಷಾಃ; ಆ ದಾಯೂದಃ ಕಾಲಾದ್ ಬಾಬಿಲಿ ಪ್ರವಸನಕಾಲಂ ಯಾವತ್ ಚತುರ್ದಶಪುರುಷಾ ಭವನ್ತಿ| ಬಾಬಿಲಿ ಪ್ರವಾಸನಕಾಲಾತ್ ಖ್ರೀಷ್ಟಸ್ಯ ಕಾಲಂ ಯಾವತ್ ಚತುರ್ದಶಪುರುಷಾ ಭವನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","ಯೀಶುಖ್ರೀಷ್ಟಸ್ಯ ಜನ್ಮ ಕಥ್ಥತೇ| ಮರಿಯಮ್ ನಾಮಿಕಾ ಕನ್ಯಾ ಯೂಷಫೇ ವಾಗ್ದತ್ತಾಸೀತ್, ತದಾ ತಯೋಃ ಸಙ್ಗಮಾತ್ ಪ್ರಾಕ್ ಸಾ ಕನ್ಯಾ  ಪವಿತ್ರೇಣಾತ್ಮನಾ ಗರ್ಭವತೀ ಬಭೂವ| ");
INSERT INTO sankan_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ತತ್ರ ತಸ್ಯಾಃ ಪತಿ ರ್ಯೂಷಫ್ ಸೌಜನ್ಯಾತ್ ತಸ್ಯಾಃ ಕಲಙ್ಗಂ ಪ್ರಕಾಶಯಿತುಮ್ ಅನಿಚ್ಛನ್ ಗೋಪನೇನೇ ತಾಂ ಪಾರಿತ್ಯಕ್ತುಂ ಮನಶ್ಚಕ್ರೇ| ");
INSERT INTO sankan_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ಸ ತಥೈವ ಭಾವಯತಿ, ತದಾನೀಂ ಪರಮೇಶ್ವರಸ್ಯ ದೂತಃ ಸ್ವಪ್ನೇ ತಂ ದರ್ಶನಂ ದತ್ತ್ವಾ ವ್ಯಾಜಹಾರ, ಹೇ ದಾಯೂದಃ ಸನ್ತಾನ ಯೂಷಫ್ ತ್ವಂ ನಿಜಾಂ ಜಾಯಾಂ ಮರಿಯಮಮ್ ಆದಾತುಂ ಮಾ ಭೈಷೀಃ| ");
INSERT INTO sankan_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","ಯತಸ್ತಸ್ಯಾ ಗರ್ಭಃ ಪವಿತ್ರಾದಾತ್ಮನೋಽಭವತ್, ಸಾ ಚ ಪುತ್ರಂ ಪ್ರಸವಿಷ್ಯತೇ, ತದಾ ತ್ವಂ ತಸ್ಯ ನಾಮ ಯೀಶುಮ್ (ಅರ್ಥಾತ್ ತ್ರಾತಾರಂ) ಕರೀಷ್ಯಸೇ, ಯಸ್ಮಾತ್ ಸ ನಿಜಮನುಜಾನ್ ತೇಷಾಂ ಕಲುಷೇಭ್ಯ ಉದ್ಧರಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ಇತ್ಥಂ ಸತಿ, ಪಶ್ಯ ಗರ್ಭವತೀ ಕನ್ಯಾ ತನಯಂ ಪ್ರಸವಿಷ್ಯತೇ| ಇಮ್ಮಾನೂಯೇಲ್ ತದೀಯಞ್ಚ ನಾಮಧೇಯಂ ಭವಿಷ್ಯತಿ|| ಇಮ್ಮಾನೂಯೇಲ್ ಅಸ್ಮಾಕಂ ಸಙ್ಗೀಶ್ವರಇತ್ಯರ್ಥಃ| ");
INSERT INTO sankan_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","ಇತಿ ಯದ್ ವಚನಂ ಪುರ್ವ್ವಂ ಭವಿಷ್ಯದ್ವಕ್ತ್ರಾ ಈಶ್ವರಃ ಕಥಾಯಾಮಾಸ, ತತ್ ತದಾನೀಂ ಸಿದ್ಧಮಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ಅನನ್ತರಂ ಯೂಷಫ್ ನಿದ್ರಾತೋ ಜಾಗರಿತ ಉತ್ಥಾಯ ಪರಮೇಶ್ವರೀಯದೂತಸ್ಯ ನಿದೇಶಾನುಸಾರೇಣ ನಿಜಾಂ ಜಾಯಾಂ ಜಗ್ರಾಹ, ");
INSERT INTO sankan_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ಕಿನ್ತು ಯಾವತ್ ಸಾ ನಿಜಂ ಪ್ರಥಮಸುತಂ ಅ ಸುಷುವೇ, ತಾವತ್ ತಾಂ ನೋಪಾಗಚ್ಛತ್, ತತಃ ಸುತಸ್ಯ ನಾಮ ಯೀಶುಂ ಚಕ್ರೇ| ");
INSERT INTO sankan_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","ಅನನ್ತರಂ ಹೇರೋದ್ ಸಂಜ್ಞಕೇ ರಾಜ್ಞಿ ರಾಜ್ಯಂ ಶಾಸತಿ ಯಿಹೂದೀಯದೇಶಸ್ಯ ಬೈತ್ಲೇಹಮಿ ನಗರೇ ಯೀಶೌ ಜಾತವತಿ ಚ, ಕತಿಪಯಾ ಜ್ಯೋತಿರ್ವ್ವುದಃ ಪೂರ್ವ್ವಸ್ಯಾ ದಿಶೋ ಯಿರೂಶಾಲಮ್ನಗರಂ ಸಮೇತ್ಯ ಕಥಯಮಾಸುಃ, ");
INSERT INTO sankan_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ಯೋ ಯಿಹೂದೀಯಾನಾಂ ರಾಜಾ ಜಾತವಾನ್, ಸ ಕುತ್ರಾಸ್ತೇ? ವಯಂ ಪೂರ್ವ್ವಸ್ಯಾಂ ದಿಶಿ ತಿಷ್ಠನ್ತಸ್ತದೀಯಾಂ ತಾರಕಾಮ್ ಅಪಶ್ಯಾಮ ತಸ್ಮಾತ್ ತಂ ಪ್ರಣನ್ತುಮ್ ಅाಗಮಾಮ| ");
INSERT INTO sankan_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ತದಾ ಹೇರೋದ್ ರಾಜಾ ಕಥಾಮೇತಾಂ ನಿಶಮ್ಯ ಯಿರೂಶಾಲಮ್ನಗರಸ್ಥಿತೈಃ ಸರ್ವ್ವಮಾನವೈಃ ಸಾರ್ದ್ಧಮ್ ಉದ್ವಿಜ್ಯ ");
INSERT INTO sankan_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ಸರ್ವ್ವಾನ್ ಪ್ರಧಾನಯಾಜಕಾನ್ ಅಧ್ಯಾಪಕಾಂಶ್ಚ ಸಮಾಹೂಯಾನೀಯ ಪಪ್ರಚ್ಛ, ಖ್ರೀಷ್ಟಃ ಕುತ್ರ ಜನಿಷ್ಯತೇ? ");
INSERT INTO sankan_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ತದಾ ತೇ ಕಥಯಾಮಾಸುಃ, ಯಿಹೂದೀಯದೇಶಸ್ಯ ಬೈತ್ಲೇಹಮಿ ನಗರೇ, ಯತೋ ಭವಿಷ್ಯದ್ವಾದಿನಾ ಇತ್ಥಂ ಲಿಖಿತಮಾಸ್ತೇ, ");
INSERT INTO sankan_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","ಸರ್ವ್ವಾಭ್ಯೋ ರಾಜಧಾನೀಭ್ಯೋ ಯಿಹೂದೀಯಸ್ಯ ನೀವೃತಃ| ಹೇ ಯೀಹೂದೀಯದೇಶಸ್ಯೇ ಬೈತ್ಲೇಹಮ್ ತ್ವಂ ನ ಚಾವರಾ| ಇಸ್ರಾಯೇಲೀಯಲೋಕಾನ್ ಮೇ ಯತೋ ಯಃ ಪಾಲಯಿಷ್ಯತಿ| ತಾದೃಗೇಕೋ ಮಹಾರಾಜಸ್ತ್ವನ್ಮಧ್ಯ ಉದ್ಭವಿಷ್ಯತೀ|| ");
INSERT INTO sankan_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","ತದಾನೀಂ ಹೇರೋದ್ ರಾಜಾ ತಾನ್ ಜ್ಯೋತಿರ್ವ್ವಿದೋ ಗೋಪನಮ್ ಆಹೂಯ ಸಾ ತಾರಕಾ ಕದಾ ದೃಷ್ಟಾಭವತ್ , ತದ್ ವಿನಿಶ್ಚಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ಅಪರಂ ತಾನ್ ಬೈತ್ಲೇಹಮಂ ಪ್ರಹೀತ್ಯ ಗದಿತವಾನ್, ಯೂಯಂ ಯಾತ, ಯತ್ನಾತ್ ತಂ ಶಿಶುಮ್ ಅನ್ವಿಷ್ಯ ತದುದ್ದೇಶೇ ಪ್ರಾಪ್ತೇ ಮಹ್ಯಂ ವಾರ್ತ್ತಾಂ ದಾಸ್ಯಥ, ತತೋ ಮಯಾಪಿ ಗತ್ವಾ ಸ ಪ್ರಣಂಸ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","ತದಾನೀಂ ರಾಜ್ಞ ಏತಾದೃಶೀಮ್ ಆಜ್ಞಾಂ ಪ್ರಾಪ್ಯ ತೇ ಪ್ರತಸ್ಥಿರೇ, ತತಃ ಪೂರ್ವ್ವರ್ಸ್ಯಾಂ ದಿಶಿ ಸ್ಥಿತೈಸ್ತೈ ರ್ಯಾ ತಾರಕಾ ದೃಷ್ಟಾ ಸಾ ತಾರಕಾ ತೇಷಾಮಗ್ರೇ ಗತ್ವಾ ಯತ್ರ ಸ್ಥಾನೇ ಶಿಶೂರಾಸ್ತೇ, ತಸ್ಯ ಸ್ಥಾನಸ್ಯೋಪರಿ ಸ್ಥಗಿತಾ ತಸ್ಯೌ| ");
INSERT INTO sankan_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ತದ್ ದೃಷ್ಟ್ವಾ ತೇ ಮಹಾನನ್ದಿತಾ ಬಭೂವುಃ, ");
INSERT INTO sankan_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ತತೋ ಗೇಹಮಧ್ಯ ಪ್ರವಿಶ್ಯ ತಸ್ಯ ಮಾತ್ರಾ ಮರಿಯಮಾ ಸಾದ್ಧಂ ತಂ ಶಿಶುಂ ನಿರೀಕ್ಷಯ ದಣ್ಡವದ್ ಭೂತ್ವಾ ಪ್ರಣೇಮುಃ, ಅಪರಂ ಸ್ವೇಷಾಂ ಘನಸಮ್ಪತ್ತಿಂ ಮೋಚಯಿತ್ವಾ ಸುವರ್ಣಂ ಕುನ್ದುರುಂ ಗನ್ಧರಮಞ್ಚ ತಸ್ಮೈ ದರ್ಶನೀಯಂ ದತ್ತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ಪಶ್ಚಾದ್ ಹೇರೋದ್ ರಾಜಸ್ಯ ಸಮೀಪಂ ಪುನರಪಿ ಗನ್ತುಂ ಸ್ವಪ್ನ ಈಶ್ವರೇಣ ನಿಷಿದ್ಧಾಃ ಸನ್ತೋ ಽನ್ಯೇನ ಪಥಾ ತೇ ನಿಜದೇಶಂ ಪ್ರತಿ ಪ್ರತಸ್ಥಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","ಅನನ್ತರಂ ತೇಷು ಗತವತ್ಮು ಪರಮೇಶ್ವರಸ್ಯ ದೂತೋ ಯೂಷಫೇ ಸ್ವಪ್ನೇ ದರ್ಶನಂ ದತ್ವಾ ಜಗಾದ, ತ್ವಮ್ ಉತ್ಥಾಯ ಶಿಶುಂ ತನ್ಮಾತರಞ್ಚ ಗೃಹೀತ್ವಾ ಮಿಸರ್ದೇಶಂ ಪಲಾಯಸ್ವ, ಅಪರಂ ಯಾವದಹಂ ತುಭ್ಯಂ ವಾರ್ತ್ತಾಂ ನ ಕಥಯಿಷ್ಯಾಮಿ, ತಾವತ್ ತತ್ರೈವ ನಿವಸ, ಯತೋ ರಾಜಾ ಹೇರೋದ್ ಶಿಶುಂ ನಾಶಯಿತುಂ ಮೃಗಯಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ತದಾನೀಂ ಯೂಷಫ್ ಉತ್ಥಾಯ ರಜನ್ಯಾಂ ಶಿಶುಂ ತನ್ಮಾತರಞ್ಚ ಗೃಹೀತ್ವಾ ಮಿಸರ್ದೇಶಂ ಪ್ರತಿ ಪ್ರತಸ್ಥೇ, ");
INSERT INTO sankan_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ಗತ್ವಾ ಚ ಹೇರೋದೋ ನೃಪತೇ ರ್ಮರಣಪರ್ಯ್ಯನ್ತಂ ತತ್ರ ದೇಶೇ ನ್ಯುವಾಸ, ತೇನ ಮಿಸರ್ದೇಶಾದಹಂ ಪುತ್ರಂ ಸ್ವಕೀಯಂ ಸಮುಪಾಹೂಯಮ್| ಯದೇತದ್ವಚನಮ್ ಈಶ್ವರೇಣ ಭವಿಷ್ಯದ್ವಾದಿನಾ ಕಥಿತಂ ತತ್ ಸಫಲಮಭೂತ್| ");
INSERT INTO sankan_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","ಅನನ್ತರಂ ಹೇರೋದ್ ಜ್ಯೋತಿರ್ವಿದ್ಭಿರಾತ್ಮಾನಂ ಪ್ರವಞ್ಚಿತಂ ವಿಜ್ಞಾಯ ಭೃಶಂ ಚುಕೋಪ; ಅಪರಂ ಜ್ಯೋತಿರ್ವ್ವಿದ್ಭ್ಯಸ್ತೇನ ವಿನಿಶ್ಚಿತಂ ಯದ್ ದಿನಂ ತದ್ದಿನಾದ್ ಗಣಯಿತ್ವಾ ದ್ವಿತೀಯವತ್ಸರಂ ಪ್ರವಿಷ್ಟಾ ಯಾವನ್ತೋ ಬಾಲಕಾ ಅಸ್ಮಿನ್ ಬೈತ್ಲೇಹಮ್ನಗರೇ ತತ್ಸೀಮಮಧ್ಯೇ ಚಾಸನ್, ಲೋಕಾನ್ ಪ್ರಹಿತ್ಯ ತಾನ್ ಸರ್ವ್ವಾನ್ ಘಾತಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ಅತಃ ಅನೇಕಸ್ಯ ವಿಲಾಪಸ್ಯ ನಿನಾದ: ಕ್ರನ್ದನಸ್ಯ ಚ| ಶೋಕೇನ ಕೃತಶಬ್ದಶ್ಚ ರಾಮಾಯಾಂ ಸಂನಿಶಮ್ಯತೇ| ಸ್ವಬಾಲಗಣಹೇತೋರ್ವೈ ರಾಹೇಲ್ ನಾರೀ ತು ರೋದಿನೀ| ನ ಮನ್ಯತೇ ಪ್ರಬೋಧನ್ತು ಯತಸ್ತೇ ನೈವ ಮನ್ತಿ ಹಿ|| ");
INSERT INTO sankan_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","ಯದೇತದ್ ವಚನಂ ಯಿರೀಮಿಯನಾಮಕಭವಿಷ್ಯದ್ವಾದಿನಾ ಕಥಿತಂ ತತ್ ತದಾನೀಂ ಸಫಲಮ್ ಅಭೂತ್| ");
INSERT INTO sankan_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ತದನನ್ತರಂ ಹೇರೇದಿ ರಾಜನಿ ಮೃತೇ ಪರಮೇಶ್ವರಸ್ಯ ದೂತೋ ಮಿಸರ್ದೇಶೇ ಸ್ವಪ್ನೇ ದರ್ಶನಂ ದತ್ತ್ವಾ ಯೂಷಫೇ ಕಥಿತವಾನ್ ");
INSERT INTO sankan_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ತ್ವಮ್ ಉತ್ಥಾಯ ಶಿಶುಂ ತನ್ಮಾತರಞ್ಚ ಗೃಹೀತ್ವಾ ಪುನರಪೀಸ್ರಾಯೇಲೋ ದೇಶಂ ಯಾಹೀ, ಯೇ ಜನಾಃ ಶಿಶುಂ ನಾಶಯಿತುಮ್ ಅಮೃಗಯನ್ತ, ತೇ ಮೃತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ತದಾನೀಂ ಸ ಉತ್ಥಾಯ ಶಿಶುಂ ತನ್ಮಾತರಞ್ಚ ಗೃಹ್ಲನ್ ಇಸ್ರಾಯೇಲ್ದೇಶಮ್ ಆಜಗಾಮ| ");
INSERT INTO sankan_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","ಕಿನ್ತು ಯಿಹೂದೀಯದೇಶೇ ಅರ್ಖಿಲಾಯನಾಮ ರಾಜಕುಮಾರೋ ನಿಜಪಿತು ರ್ಹೇರೋದಃ ಪದಂ ಪ್ರಾಪ್ಯ ರಾಜತ್ವಂ ಕರೋತೀತಿ ನಿಶಮ್ಯ ತತ್ ಸ್ಥಾನಂ ಯಾತುಂ ಶಙ್ಕಿತವಾನ್, ಪಶ್ಚಾತ್ ಸ್ವಪ್ನ ಈಶ್ವರಾತ್ ಪ್ರಬೋಧಂ ಪ್ರಾಪ್ಯ ಗಾಲೀಲ್ದೇಶಸ್ಯ ಪ್ರದೇಶೈಕಂ ಪ್ರಸ್ಥಾಯ ನಾಸರನ್ನಾಮ ನಗರಂ ಗತ್ವಾ ತತ್ರ ನ್ಯುಷಿತವಾನ್, ");
INSERT INTO sankan_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ತೇನ ತಂ ನಾಸರತೀಯಂ ಕಥಯಿಷ್ಯನ್ತಿ, ಯದೇತದ್ವಾಕ್ಯಂ ಭವಿಷ್ಯದ್ವಾದಿಭಿರುಕ್ತ್ತಂ ತತ್ ಸಫಲಮಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","ತದಾನೋಂ ಯೋಹ್ನ್ನಾಮಾ ಮಜ್ಜಯಿತಾ ಯಿಹೂದೀಯದೇಶಸ್ಯ ಪ್ರಾನ್ತರಮ್ ಉಪಸ್ಥಾಯ ಪ್ರಚಾರಯನ್ ಕಥಯಾಮಾಸ, ");
INSERT INTO sankan_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ಮನಾಂಸಿ ಪರಾವರ್ತ್ತಯತ, ಸ್ವರ್ಗೀಯರಾಜತ್ವಂ ಸಮೀಪಮಾಗತಮ್| ");
INSERT INTO sankan_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ಪರಮೇಶಸ್ಯ ಪನ್ಥಾನಂ ಪರಿಷ್ಕುರುತ ಸರ್ವ್ವತಃ| ತಸ್ಯ ರಾಜಪಥಾಂಶ್ಚೈವ ಸಮೀಕುರುತ ಸರ್ವ್ವಥಾ| ಇತ್ಯೇತತ್ ಪ್ರಾನ್ತರೇ ವಾಕ್ಯಂ ವದತಃ ಕಸ್ಯಚಿದ್ ರವಃ|| ");
INSERT INTO sankan_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ಏತದ್ವಚನಂ ಯಿಶಯಿಯಭವಿಷ್ಯದ್ವಾದಿನಾ ಯೋಹನಮುದ್ದಿಶ್ಯ ಭಾಷಿತಮ್| ಯೋಹನೋ ವಸನಂ ಮಹಾಙ್ಗರೋಮಜಂ ತಸ್ಯ ಕಟೌ ಚರ್ಮ್ಮಕಟಿಬನ್ಧನಂ; ಸ ಚ ಶೂಕಕೀಟಾನ್ ಮಧು ಚ ಭುಕ್ತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","ತದಾನೀಂ ಯಿರೂಶಾಲಮ್ನಗರನಿವಾಸಿನಃ ಸರ್ವ್ವೇ ಯಿಹೂದಿದೇಶೀಯಾ ಯರ್ದ್ದನ್ತಟಿನ್ಯಾ ಉಭಯತಟಸ್ಥಾಶ್ಚ ಮಾನವಾ ಬಹಿರಾಗತ್ಯ ತಸ್ಯ ಸಮೀಪೇ ");
INSERT INTO sankan_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ಸ್ವೀಯಂ ಸ್ವೀಯಂ ದುರಿತಮ್ ಅಙ್ಗೀಕೃತ್ಯ ತಸ್ಯಾಂ ಯರ್ದ್ದನಿ ತೇನ ಮಜ್ಜಿತಾ ಬಭೂವುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ಅಪರಂ ಬಹೂನ್ ಫಿರೂಶಿನಃ ಸಿದೂಕಿನಶ್ಚ ಮನುಜಾನ್ ಮಂಕ್ತುಂ ಸ್ವಸಮೀಪಮ್ ಆಗಚ್ಛ್ತೋ ವಿಲೋಕ್ಯ ಸ ತಾನ್ ಅಭಿದಧೌ, ರೇ ರೇ ಭುಜಗವಂಶಾ ಆಗಾಮೀನಃ ಕೋಪಾತ್ ಪಲಾಯಿತುಂ ಯುಷ್ಮಾನ್ ಕಶ್ಚೇತಿತವಾನ್? ");
INSERT INTO sankan_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","ಮನಃಪರಾವರ್ತ್ತನಸ್ಯ ಸಮುಚಿತಂ ಫಲಂ ಫಲತ| ");
INSERT INTO sankan_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ಕಿನ್ತ್ವಸ್ಮಾಕಂ ತಾತ ಇಬ್ರಾಹೀಮ್ ಅಸ್ತೀತಿ ಸ್ವೇಷು ಮನಃಸು ಚೀನ್ತಯನ್ತೋ ಮಾ ವ್ಯಾಹರತ| ಯತೋ ಯುಷ್ಮಾನ್ ಅಹಂ ವದಾಮಿ, ಈಶ್ವರ ಏತೇಭ್ಯಃ ಪಾಷಾಣೇಭ್ಯ ಇಬ್ರಾಹೀಮಃ ಸನ್ತಾನಾನ್ ಉತ್ಪಾದಯಿತುಂ ಶಕ್ನೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ಅಪರಂ ಪಾದಪಾನಾಂ ಮೂಲೇ ಕುಠಾರ ಇದಾನೀಮಪಿ ಲಗನ್ ಆಸ್ತೇ, ತಸ್ಮಾದ್ ಯಸ್ಮಿನ್ ಪಾದಪೇ ಉತ್ತಮಂ ಫಲಂ ನ ಭವತಿ, ಸ ಕೃತ್ತೋ ಮಧ್ಯೇಽಗ್ನಿಂ ನಿಕ್ಷೇಪ್ಸ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","ಅಪರಮ್ ಅಹಂ ಮನಃಪರಾವರ್ತ್ತನಸೂಚಕೇನ ಮಜ್ಜನೇನ ಯುಷ್ಮಾನ್ ಮಜ್ಜಯಾಮೀತಿ ಸತ್ಯಂ, ಕಿನ್ತು ಮಮ ಪಶ್ಚಾದ್ ಯ ಆಗಚ್ಛತಿ, ಸ ಮತ್ತೋಪಿ ಮಹಾನ್, ಅಹಂ ತದೀಯೋಪಾನಹೌ ವೋಢುಮಪಿ ನಹಿ ಯೋಗ್ಯೋಸ್ಮಿ, ಸ ಯುಷ್ಮಾನ್ ವಹ್ನಿರೂಪೇ ಪವಿತ್ರ ಆತ್ಮನಿ ಸಂಮಜ್ಜಯಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ತಸ್ಯ ಕಾರೇ ಸೂರ್ಪ ಆಸ್ತೇ, ಸ ಸ್ವೀಯಶಸ್ಯಾನಿ ಸಮ್ಯಕ್ ಪ್ರಸ್ಫೋಟ್ಯ ನಿಜಾನ್ ಸಕಲಗೋಧೂಮಾನ್ ಸಂಗೃಹ್ಯ ಭಾಣ್ಡಾಗಾರೇ ಸ್ಥಾಪಯಿಷ್ಯತಿ, ಕಿಂನ್ತು ಸರ್ವ್ವಾಣಿ ವುಷಾಣ್ಯನಿರ್ವ್ವಾಣವಹ್ನಿನಾ ದಾಹಯಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","ಅನನ್ತರಂ ಯೀಶು ರ್ಯೋಹನಾ ಮಜ್ಜಿತೋ ಭವಿತುಂ ಗಾಲೀಲ್ಪ್ರದೇಶಾದ್ ಯರ್ದ್ದನಿ ತಸ್ಯ ಸಮೀಪಮ್ ಆಜಗಾಮ| ");
INSERT INTO sankan_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","ಕಿನ್ತು ಯೋಹನ್ ತಂ ನಿಷಿಧ್ಯ ಬಭಾಷೇ, ತ್ವಂ ಕಿಂ ಮಮ ಸಮೀಪಮ್ ಆಗಚ್ಛಸಿ? ವರಂ ತ್ವಯಾ ಮಜ್ಜನಂ ಮಮ ಪ್ರಯೋಜನಮ್ ಆಸ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ತದಾನೀಂ ಯೀಶುಃ ಪ್ರತ್ಯವೋಚತ್; ಈದಾನೀಮ್ ಅನುಮನ್ಯಸ್ವ, ಯತ ಇತ್ಥಂ ಸರ್ವ್ವಧರ್ಮ್ಮಸಾಧನಮ್ ಅಸ್ಮಾಕಂ ಕರ್ತ್ತವ್ಯಂ, ತತಃ ಸೋಽನ್ವಮನ್ಯತ| ");
INSERT INTO sankan_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ಅನನ್ತರಂ ಯೀಶುರಮ್ಮಸಿ ಮಜ್ಜಿತುಃ ಸನ್ ತತ್ಕ್ಷಣಾತ್ ತೋಯಮಧ್ಯಾದ್ ಉತ್ಥಾಯ ಜಗಾಮ, ತದಾ ಜೀಮೂತದ್ವಾರೇ ಮುಕ್ತೇ ಜಾತೇ, ಸ ಈಶ್ವರಸ್ಯಾತ್ಮಾನಂ ಕಪೋತವದ್ ಅವರುಹ್ಯ ಸ್ವೋಪರ್ಯ್ಯಾಗಚ್ಛನ್ತಂ ವೀಕ್ಷಾಞ್ಚಕ್ರೇ| ");
INSERT INTO sankan_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ಅಪರಮ್ ಏಷ ಮಮ ಪ್ರಿಯಃ ಪುತ್ರ ಏತಸ್ಮಿನ್ನೇವ ಮಮ ಮಹಾಸನ್ತೋಷ ಏತಾದೃಶೀ ವ್ಯೋಮಜಾ ವಾಗ್ ಬಭೂವ| ");
INSERT INTO sankan_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","ತತಃ ಪರಂ ಯೀಶುಃ ಪ್ರತಾರಕೇಣ ಪರೀಕ್ಷಿತೋ ಭವಿತುಮ್ ಆತ್ಮನಾ ಪ್ರಾನ್ತರಮ್ ಆಕೃಷ್ಟಃ ");
INSERT INTO sankan_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ಸನ್ ಚತ್ವಾರಿಂಶದಹೋರಾತ್ರಾನ್ ಅನಾಹಾರಸ್ತಿಷ್ಠನ್ ಕ್ಷುಧಿತೋ ಬಭೂವ| ");
INSERT INTO sankan_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ತದಾನೀಂ ಪರೀಕ್ಷಿತಾ ತತ್ಸಮೀಪಮ್ ಆಗತ್ಯ ವ್ಯಾಹೃತವಾನ್, ಯದಿ ತ್ವಮೀಶ್ವರಾತ್ಮಜೋ ಭವೇಸ್ತರ್ಹ್ಯಾಜ್ಞಯಾ ಪಾಷಾಣಾನೇತಾನ್ ಪೂಪಾನ್ ವಿಧೇಹಿ| ");
INSERT INTO sankan_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","ತತಃ ಸ ಪ್ರತ್ಯಬ್ರವೀತ್, ಇತ್ಥಂ ಲಿಖಿತಮಾಸ್ತೇ, \"ಮನುಜಃ ಕೇವಲಪೂಪೇನ ನ ಜೀವಿಷ್ಯತಿ, ಕಿನ್ತ್ವೀಶ್ವರಸ್ಯ ವದನಾದ್ ಯಾನಿ ಯಾನಿ ವಚಾಂಸಿ ನಿಃಸರನ್ತಿ ತೈರೇವ ಜೀವಿಷ್ಯತಿ| \" ");
INSERT INTO sankan_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","ತದಾ ಪ್ರತಾರಕಸ್ತಂ ಪುಣ್ಯನಗರಂ ನೀತ್ವಾ ಮನ್ದಿರಸ್ಯ ಚೂಡೋಪರಿ ನಿಧಾಯ ಗದಿತವಾನ್, ");
INSERT INTO sankan_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ತ್ವಂ ಯದಿಶ್ವರಸ್ಯ ತನಯೋ ಭವೇಸ್ತರ್ಹೀತೋಽಧಃ ಪತ, ಯತ ಇತ್ಥಂ ಲಿಖಿತಮಾಸ್ತೇ, ಆದೇಕ್ಷ್ಯತಿ ನಿಜಾನ್ ದೂತಾನ್ ರಕ್ಷಿತುಂ ತ್ವಾಂ ಪರಮೇಶ್ವರಃ| ಯಥಾ ಸರ್ವ್ವೇಷು ಮಾರ್ಗೇಷು ತ್ವದೀಯಚರಣದ್ವಯೇ| ನ ಲಗೇತ್ ಪ್ರಸ್ತರಾಘಾತಸ್ತ್ವಾಂ ಘರಿಷ್ಯನ್ತಿ ತೇ ಕರೈಃ|| ");
INSERT INTO sankan_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ತದಾನೀಂ ಯೀಶುಸ್ತಸ್ಮೈ ಕಥಿತವಾನ್ ಏತದಪಿ ಲಿಖಿತಮಾಸ್ತೇ, \"ತ್ವಂ ನಿಜಪ್ರಭುಂ ಪರಮೇಶ್ವರಂ ಮಾ ಪರೀಕ್ಷಸ್ವ| \" ");
INSERT INTO sankan_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","ಅನನ್ತರಂ ಪ್ರತಾರಕಃ ಪುನರಪಿ ತಮ್ ಅತ್ಯುಞ್ಚಧರಾಧರೋಪರಿ ನೀತ್ವಾ ಜಗತಃ ಸಕಲರಾಜ್ಯಾನಿ ತದೈಶ್ವರ್ಯ್ಯಾಣಿ ಚ ದರ್ಶಯಾಶ್ಚಕಾರ ಕಥಯಾಞ್ಚಕಾರ ಚ, ");
INSERT INTO sankan_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ಯದಿ ತ್ವಂ ದಣ್ಡವದ್ ಭವನ್ ಮಾಂ ಪ್ರಣಮೇಸ್ತರ್ಹ್ಯಹಮ್ ಏತಾನಿ ತುಭ್ಯಂ ಪ್ರದಾಸ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ತದಾನೀಂ ಯೀಶುಸ್ತಮವೋಚತ್, ದೂರೀಭವ ಪ್ರತಾರಕ, ಲಿಖಿತಮಿದಮ್ ಆಸ್ತೇ, \"ತ್ವಯಾ ನಿಜಃ ಪ್ರಭುಃ ಪರಮೇಶ್ವರಃ ಪ್ರಣಮ್ಯಃ ಕೇವಲಃ ಸ ಸೇವ್ಯಶ್ಚ| \" ");
INSERT INTO sankan_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ತತಃ ಪ್ರತಾರಕೇಣ ಸ ಪರ್ಯ್ಯತ್ಯಾಜಿ, ತದಾ ಸ್ವರ್ಗೀಯದೂತೈರಾಗತ್ಯ ಸ ಸಿಷೇವೇ| ");
INSERT INTO sankan_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","ತದನನ್ತರಂ ಯೋಹನ್ ಕಾರಾಯಾಂ ಬಬನ್ಧೇ, ತದ್ವಾರ್ತ್ತಾಂ ನಿಶಮ್ಯ ಯೀಶುನಾ ಗಾಲೀಲ್ ಪ್ರಾಸ್ಥೀಯತ| ");
INSERT INTO sankan_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ತತಃ ಪರಂ ಸ ನಾಸರನ್ನಗರಂ ವಿಹಾಯ ಜಲಘೇಸ್ತಟೇ ಸಿಬೂಲೂನ್ನಪ್ತಾಲೀ ಏತಯೋರುವಭಯೋಃ ಪ್ರದೇಶಯೋಃ ಸೀಮ್ನೋರ್ಮಧ್ಯವರ್ತ್ತೀ ಯ: ಕಫರ್ನಾಹೂಮ್ ತನ್ನಗರಮ್ ಇತ್ವಾ ನ್ಯವಸತ್| ");
INSERT INTO sankan_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ತಸ್ಮಾತ್, ಅನ್ಯಾದೇಶೀಯಗಾಲೀಲಿ ಯರ್ದ್ದನ್ಪಾರೇಽಬ್ಧಿರೋಧಸಿ| ನಪ್ತಾಲಿಸಿಬೂಲೂನ್ದೇಶೌ ಯತ್ರ ಸ್ಥಾನೇ ಸ್ಥಿತೌ ಪುರಾ| ");
INSERT INTO sankan_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","ತತ್ರತ್ಯಾ ಮನುಜಾ ಯೇ ಯೇ ಪರ್ಯ್ಯಭ್ರಾಮ್ಯನ್ ತಮಿಸ್ರಕೇ| ತೈರ್ಜನೈರ್ಬೃಹದಾಲೋಕಃ ಪರಿದರ್ಶಿಷ್ಯತೇ ತದಾ| ಅವಸನ್ ಯೇ ಜನಾ ದೇಶೇ ಮೃತ್ಯುಚ್ಛಾಯಾಸ್ವರೂಪಕೇ| ತೇಷಾಮುಪರಿ ಲೋಕಾನಾಮಾಲೋಕಃ ಸಂಪ್ರಕಾಶಿತಃ|| ");
INSERT INTO sankan_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ಯದೇತದ್ವಚನಂ ಯಿಶಯಿಯಭವಿಷ್ಯದ್ವಾದಿನಾ ಪ್ರೋಕ್ತಂ, ತತ್ ತದಾ ಸಫಲಮ್ ಅಭೂತ್| ");
INSERT INTO sankan_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","ಅನನ್ತರಂ ಯೀಶುಃ ಸುಸಂವಾದಂ ಪ್ರಚಾರಯನ್ ಏತಾಂ ಕಥಾಂ ಕಥಯಿತುಮ್ ಆರೇಭೇ, ಮನಾಂಸಿ ಪರಾವರ್ತ್ತಯತ, ಸ್ವರ್ಗೀಯರಾಜತ್ವಂ ಸವಿಧಮಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ತತಃ ಪರಂ ಯೀಶು ರ್ಗಾಲೀಲೋ ಜಲಧೇಸ್ತಟೇನ ಗಚ್ಛನ್ ಗಚ್ಛನ್ ಆನ್ದ್ರಿಯಸ್ತಸ್ಯ ಭ್ರಾತಾ ಶಿಮೋನ್ ಅರ್ಥತೋ ಯಂ ಪಿತರಂ ವದನ್ತಿ ಏತಾವುಭೌ ಜಲಘೌ ಜಾಲಂ ಕ್ಷಿಪನ್ತೌ ದದರ್ಶ, ಯತಸ್ತೌ ಮೀನಧಾರಿಣಾವಾಸ್ತಾಮ್| ");
INSERT INTO sankan_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ತದಾ ಸ ತಾವಾಹೂಯ ವ್ಯಾಜಹಾರ, ಯುವಾಂ ಮಮ ಪಶ್ಚಾದ್ ಆಗಚ್ಛತಂ, ಯುವಾಮಹಂ ಮನುಜಧಾರಿಣೌ ಕರಿಷ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","ತೇನೈವ ತೌ ಜಾಲಂ ವಿಹಾಯ ತಸ್ಯ ಪಶ್ಚಾತ್ ಆಗಚ್ಛತಾಮ್| ");
INSERT INTO sankan_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ಅನನ್ತರಂ ತಸ್ಮಾತ್ ಸ್ಥಾನಾತ್ ವ್ರಜನ್ ವ್ರಜನ್ ಸಿವದಿಯಸ್ಯ ಸುತೌ ಯಾಕೂಬ್ ಯೋಹನ್ನಾಮಾನೌ ದ್ವೌ ಸಹಜೌ ತಾತೇನ ಸಾರ್ದ್ಧಂ ನೌಕೋಪರಿ ಜಾಲಸ್ಯ ಜೀರ್ಣೋದ್ಧಾರಂ ಕುರ್ವ್ವನ್ತೌ ವೀಕ್ಷ್ಯ ತಾವಾಹೂತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ತತ್ಕ್ಷಣಾತ್ ತೌ ನಾವಂ ಸ್ವತಾತಞ್ಚ ವಿಹಾಯ ತಸ್ಯ ಪಶ್ಚಾದ್ಗಾಮಿನೌ ಬಭೂವತುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ಅನನ್ತರಂ ಭಜನಭವನೇ ಸಮುಪದಿಶನ್ ರಾಜ್ಯಸ್ಯ ಸುಸಂವಾದಂ ಪ್ರಚಾರಯನ್ ಮನುಜಾನಾಂ ಸರ್ವ್ವಪ್ರಕಾರಾನ್ ರೋಗಾನ್ ಸರ್ವ್ವಪ್ರಕಾರಪೀಡಾಶ್ಚ ಶಮಯನ್ ಯೀಶುಃ ಕೃತ್ಸ್ನಂ ಗಾಲೀಲ್ದೇಶಂ ಭ್ರಮಿತುಮ್ ಆರಭತ| ");
INSERT INTO sankan_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ತೇನ ಕೃತ್ಸ್ನಸುರಿಯಾದೇಶಸ್ಯ ಮಧ್ಯಂ ತಸ್ಯ ಯಶೋ ವ್ಯಾಪ್ನೋತ್, ಅಪರಂ ಭೂತಗ್ರಸ್ತಾ ಅಪಸ್ಮಾರರ್ಗೀಣಃ ಪಕ್ಷಾಧಾತಿಪ್ರಭೃತಯಶ್ಚ ಯಾವನ್ತೋ ಮನುಜಾ ನಾನಾವಿಧವ್ಯಾಧಿಭಿಃ ಕ್ಲಿಷ್ಟಾ ಆಸನ್, ತೇಷು ಸರ್ವ್ವೇಷು ತಸ್ಯ ಸಮೀಪಮ್ ಆನೀತೇಷು ಸ ತಾನ್ ಸ್ವಸ್ಥಾನ್ ಚಕಾರ| ");
INSERT INTO sankan_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ಏತೇನ ಗಾಲೀಲ್-ದಿಕಾಪನಿ-ಯಿರೂಶಾಲಮ್-ಯಿಹೂದೀಯದೇಶೇಭ್ಯೋ ಯರ್ದ್ದನಃ ಪಾರಾಞ್ಚ ಬಹವೋ ಮನುಜಾಸ್ತಸ್ಯ ಪಶ್ಚಾದ್ ಆಗಚ್ಛನ್| ");
INSERT INTO sankan_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ಅನನ್ತರಂ ಸ ಜನನಿವಹಂ ನಿರೀಕ್ಷ್ಯ ಭೂಧರೋಪರಿ ವ್ರಜಿತ್ವಾ ಸಮುಪವಿವೇಶ| ");
INSERT INTO sankan_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ತದಾನೀಂ ಶಿಷ್ಯೇಷು ತಸ್ಯ ಸಮೀಪಮಾಗತೇಷು ತೇನ ತೇಭ್ಯ ಏಷಾ ಕಥಾ ಕಥ್ಯಾಞ್ಚಕ್ರೇ| ");
INSERT INTO sankan_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","ಅಭಿಮಾನಹೀನಾ ಜನಾ ಧನ್ಯಾಃ, ಯತಸ್ತೇ ಸ್ವರ್ಗೀಯರಾಜ್ಯಮ್ ಅಧಿಕರಿಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ಖಿದ್ಯಮಾನಾ ಮನುಜಾ ಧನ್ಯಾಃ, ಯಸ್ಮಾತ್ ತೇ ಸಾನ್ತ್ವನಾಂ ಪ್ರಾಪ್ಸನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","ನಮ್ರಾ ಮಾನವಾಶ್ಚ ಧನ್ಯಾಃ, ಯಸ್ಮಾತ್ ತೇ ಮೇದಿನೀಮ್ ಅಧಿಕರಿಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ಧರ್ಮ್ಮಾಯ ಬುಭುಕ್ಷಿತಾಃ ತೃಷಾರ್ತ್ತಾಶ್ಚ ಮನುಜಾ ಧನ್ಯಾಃ, ಯಸ್ಮಾತ್ ತೇ ಪರಿತರ್ಪ್ಸ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","ಕೃಪಾಲವೋ ಮಾನವಾ ಧನ್ಯಾಃ, ಯಸ್ಮಾತ್ ತೇ ಕೃಪಾಂ ಪ್ರಾಪ್ಸ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ನಿರ್ಮ್ಮಲಹೃದಯಾ ಮನುಜಾಶ್ಚ ಧನ್ಯಾಃ, ಯಸ್ಮಾತ್ ತ ಈಶ್ಚರಂ ದ್ರಕ್ಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","ಮೇಲಯಿತಾರೋ ಮಾನವಾ ಧನ್ಯಾಃ, ಯಸ್ಮಾತ್ ತ ಈಶ್ಚರಸ್ಯ ಸನ್ತಾನತ್ವೇನ ವಿಖ್ಯಾಸ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ಧರ್ಮ್ಮಕಾರಣಾತ್ ತಾಡಿತಾ ಮನುಜಾ ಧನ್ಯಾ, ಯಸ್ಮಾತ್ ಸ್ವರ್ಗೀಯರಾಜ್ಯೇ ತೇಷಾಮಧಿಕರೋ ವಿದ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","ಯದಾ ಮನುಜಾ ಮಮ ನಾಮಕೃತೇ ಯುಷ್ಮಾನ್ ನಿನ್ದನ್ತಿ ತಾಡಯನ್ತಿ ಮೃಷಾ ನಾನಾದುರ್ವ್ವಾಕ್ಯಾನಿ ವದನ್ತಿ ಚ, ತದಾ ಯುಯಂ ಧನ್ಯಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ತದಾ ಆನನ್ದತ, ತಥಾ ಭೃಶಂ ಹ್ಲಾದಧ್ವಞ್ಚ, ಯತಃ ಸ್ವರ್ಗೇ ಭೂಯಾಂಸಿ ಫಲಾನಿ ಲಪ್ಸ್ಯಧ್ವೇ; ತೇ ಯುಷ್ಮಾಕಂ ಪುರಾತನಾನ್ ಭವಿಷ್ಯದ್ವಾದಿನೋಽಪಿ ತಾದೃಗ್ ಅತಾಡಯನ್| ");
INSERT INTO sankan_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","ಯುಯಂ ಮೇದಿನ್ಯಾಂ ಲವಣರೂಪಾಃ, ಕಿನ್ತು ಯದಿ ಲವಣಸ್ಯ ಲವಣತ್ವಮ್ ಅಪಯಾತಿ, ತರ್ಹಿ ತತ್ ಕೇನ ಪ್ರಕಾರೇಣ ಸ್ವಾದುಯುಕ್ತಂ ಭವಿಷ್ಯತಿ? ತತ್ ಕಸ್ಯಾಪಿ ಕಾರ್ಯ್ಯಸ್ಯಾಯೋಗ್ಯತ್ವಾತ್ ಕೇವಲಂ ಬಹಿಃ ಪ್ರಕ್ಷೇಪ್ತುಂ ನರಾಣಾಂ ಪದತಲೇನ ದಲಯಿತುಞ್ಚ ಯೋಗ್ಯಂ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","ಯೂಯಂ ಜಗತಿ ದೀಪ್ತಿರೂಪಾಃ, ಭೂಧರೋಪರಿ ಸ್ಥಿತಂ ನಗರಂ ಗುಪ್ತಂ ಭವಿತುಂ ನಹಿ ಶಕ್ಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","ಅಪರಂ ಮನುಜಾಃ ಪ್ರದೀಪಾನ್ ಪ್ರಜ್ವಾಲ್ಯ ದ್ರೋಣಾಧೋ ನ ಸ್ಥಾಪಯನ್ತಿ, ಕಿನ್ತು ದೀಪಾಧಾರೋಪರ್ಯ್ಯೇವ ಸ್ಥಾಪಯನ್ತಿ, ತೇನ ತೇ ದೀಪಾ ಗೇಹಸ್ಥಿತಾನ್ ಸಕಲಾನ್ ಪ್ರಕಾಶಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","ಯೇನ ಮಾನವಾ ಯುಷ್ಮಾಕಂ ಸತ್ಕರ್ಮ್ಮಾಣಿ ವಿಲೋಕ್ಯ ಯುಷ್ಮಾಕಂ ಸ್ವರ್ಗಸ್ಥಂ ಪಿತರಂ ಧನ್ಯಂ ವದನ್ತಿ, ತೇಷಾಂ ಸಮಕ್ಷಂ ಯುಷ್ಮಾಕಂ ದೀಪ್ತಿಸ್ತಾದೃಕ್ ಪ್ರಕಾಶತಾಮ್| ");
INSERT INTO sankan_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","ಅಹಂ ವ್ಯವಸ್ಥಾಂ ಭವಿಷ್ಯದ್ವಾಕ್ಯಞ್ಚ ಲೋಪ್ತುಮ್ ಆಗತವಾನ್, ಇತ್ಥಂ ಮಾನುಭವತ, ತೇ ದ್ವೇ ಲೋಪ್ತುಂ ನಾಗತವಾನ್, ಕಿನ್ತು ಸಫಲೇ ಕರ್ತ್ತುಮ್ ಆಗತೋಸ್ಮಿ| ");
INSERT INTO sankan_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","ಅಪರಂ ಯುಷ್ಮಾನ್ ಅಹಂ ತಥ್ಯಂ ವದಾಮಿ ಯಾವತ್ ವ್ಯೋಮಮೇದಿನ್ಯೋ ರ್ಧ್ವಂಸೋ ನ ಭವಿಷ್ಯತಿ, ತಾವತ್ ಸರ್ವ್ವಸ್ಮಿನ್ ಸಫಲೇ ನ ಜಾತೇ ವ್ಯವಸ್ಥಾಯಾ ಏಕಾ ಮಾತ್ರಾ ಬಿನ್ದುರೇಕೋಪಿ ವಾ ನ ಲೋಪ್ಸ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ತಸ್ಮಾತ್ ಯೋ ಜನ ಏತಾಸಾಮ್ ಆಜ್ಞಾನಾಮ್ ಅತಿಕ್ಷುದ್ರಾಮ್ ಏಕಾಜ್ಞಾಮಪೀ ಲಂಘತೇ ಮನುಜಾಂಞ್ಚ ತಥೈವ ಶಿಕ್ಷಯತಿ, ಸ ಸ್ವರ್ಗೀಯರಾಜ್ಯೇ ಸರ್ವ್ವೇಭ್ಯಃ ಕ್ಷುದ್ರತ್ವೇನ ವಿಖ್ಯಾಸ್ಯತೇ, ಕಿನ್ತು ಯೋ ಜನಸ್ತಾಂ ಪಾಲಯತಿ, ತಥೈವ ಶಿಕ್ಷಯತಿ ಚ, ಸ ಸ್ವರ್ಗೀಯರಾಜ್ಯೇ ಪ್ರಧಾನತ್ವೇನ ವಿಖ್ಯಾಸ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","ಅಪರಂ ಯುಷ್ಮಾನ್ ಅಹಂ ವದಾಮಿ, ಅಧ್ಯಾಪಕಫಿರೂಶಿಮಾನವಾನಾಂ ಧರ್ಮ್ಮಾನುಷ್ಠಾನಾತ್ ಯುಷ್ಮಾಕಂ ಧರ್ಮ್ಮಾನುಷ್ಠಾನೇ ನೋತ್ತಮೇ ಜಾತೇ ಯೂಯಮ್ ಈಶ್ವರೀಯರಾಜ್ಯಂ ಪ್ರವೇಷ್ಟುಂ ನ ಶಕ್ಷ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","ಅಪರಞ್ಚ ತ್ವಂ ನರಂ ಮಾ ವಧೀಃ, ಯಸ್ಮಾತ್ ಯೋ ನರಂ ಹನ್ತಿ, ಸ ವಿಚಾರಸಭಾಯಾಂ ದಣ್ಡಾರ್ಹೋ ಭವಿಷ್ಯತಿ, ಪೂರ್ವ್ವಕಾಲೀನಜನೇಭ್ಯ ಇತಿ ಕಥಿತಮಾಸೀತ್, ಯುಷ್ಮಾಭಿರಶ್ರಾವಿ| ");
INSERT INTO sankan_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","ಕಿನ್ತ್ವಹಂ ಯುಷ್ಮಾನ್ ವದಾಮಿ, ಯಃ ಕಶ್ಚಿತ್ ಕಾರಣಂ ವಿನಾ ನಿಜಭ್ರಾತ್ರೇ ಕುಪ್ಯತಿ, ಸ ವಿಚಾರಸಭಾಯಾಂ ದಣ್ಡಾರ್ಹೋ ಭವಿಷ್ಯತಿ; ಯಃ ಕಶ್ಚಿಚ್ಚ ಸ್ವೀಯಸಹಜಂ ನಿರ್ಬ್ಬೋಧಂ ವದತಿ, ಸ ಮಹಾಸಭಾಯಾಂ ದಣ್ಡಾರ್ಹೋ ಭವಿಷ್ಯತಿ; ಪುನಶ್ಚ ತ್ವಂ ಮೂಢ ಇತಿ ವಾಕ್ಯಂ ಯದಿ ಕಶ್ಚಿತ್ ಸ್ವೀಯಭ್ರಾತರಂ ವಕ್ತಿ, ತರ್ಹಿ ನರಕಾಗ್ನೌ ಸ ದಣ್ಡಾರ್ಹೋ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","ಅತೋ ವೇದ್ಯಾಃ ಸಮೀಪಂ ನಿಜನೈವೇದ್ಯೇ ಸಮಾನೀತೇಽಪಿ ನಿಜಭ್ರಾತರಂ ಪ್ರತಿ ಕಸ್ಮಾಚ್ಚಿತ್ ಕಾರಣಾತ್ ತ್ವಂ ಯದಿ ದೋಷೀ ವಿದ್ಯಸೇ, ತದಾನೀಂ ತವ ತಸ್ಯ ಸ್ಮೃತಿ ರ್ಜಾಯತೇ ಚ, ");
INSERT INTO sankan_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ತರ್ಹಿ ತಸ್ಯಾ ವೇದ್ಯಾಃ ಸಮೀಪೇ ನಿಜನೈವೈದ್ಯಂ ನಿಧಾಯ ತದೈವ ಗತ್ವಾ ಪೂರ್ವ್ವಂ ತೇನ ಸಾರ್ದ್ಧಂ ಮಿಲ, ಪಶ್ಚಾತ್ ಆಗತ್ಯ ನಿಜನೈವೇದ್ಯಂ ನಿವೇದಯ| ");
INSERT INTO sankan_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","ಅನ್ಯಞ್ಚ ಯಾವತ್ ವಿವಾದಿನಾ ಸಾರ್ದ್ಧಂ ವರ್ತ್ಮನಿ ತಿಷ್ಠಸಿ, ತಾವತ್ ತೇನ ಸಾರ್ದ್ಧಂ ಮೇಲನಂ ಕುರು; ನೋ ಚೇತ್ ವಿವಾದೀ ವಿಚಾರಯಿತುಃ ಸಮೀಪೇ ತ್ವಾಂ ಸಮರ್ಪಯತಿ ವಿಚಾರಯಿತಾ ಚ ರಕ್ಷಿಣಃ ಸನ್ನಿಧೌ ಸಮರ್ಪಯತಿ ತದಾ ತ್ವಂ ಕಾರಾಯಾಂ ಬಧ್ಯೇಥಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ತರ್ಹಿ ತ್ವಾಮಹಂ ತಥ್ಥಂ ಬ್ರವೀಮಿ, ಶೇಷಕಪರ್ದಕೇಽಪಿ ನ ಪರಿಶೋಧಿತೇ ತಸ್ಮಾತ್ ಸ್ಥಾನಾತ್ ಕದಾಪಿ ಬಹಿರಾಗನ್ತುಂ ನ ಶಕ್ಷ್ಯಸಿ| ");
INSERT INTO sankan_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","ಅಪರಂ ತ್ವಂ ಮಾ ವ್ಯಭಿಚರ, ಯದೇತದ್ ವಚನಂ ಪೂರ್ವ್ವಕಾಲೀನಲೋಕೇಭ್ಯಃ ಕಥಿತಮಾಸೀತ್, ತದ್ ಯೂಯಂ ಶ್ರುತವನ್ತಃ; ");
INSERT INTO sankan_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","ಕಿನ್ತ್ವಹಂ ಯುಷ್ಮಾನ್ ವದಾಮಿ, ಯದಿ ಕಶ್ಚಿತ್ ಕಾಮತಃ ಕಾಞ್ಚನ ಯೋಷಿತಂ ಪಶ್ಯತಿ, ತರ್ಹಿ ಸ ಮನಸಾ ತದೈವ ವ್ಯಭಿಚರಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ತಸ್ಮಾತ್ ತವ ದಕ್ಷಿಣಂ ನೇತ್ರಂ ಯದಿ ತ್ವಾಂ ಬಾಧತೇ, ತರ್ಹಿ ತನ್ನೇತ್ರಮ್ ಉತ್ಪಾಟ್ಯ ದೂರೇ ನಿಕ್ಷಿಪ, ಯಸ್ಮಾತ್ ತವ ಸರ್ವ್ವವಪುಷೋ ನರಕೇ ನಿಕ್ಷೇಪಾತ್ ತವೈಕಾಙ್ಗಸ್ಯ ನಾಶೋ ವರಂ| ");
INSERT INTO sankan_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","ಯದ್ವಾ ತವ ದಕ್ಷಿಣಃ ಕರೋ ಯದಿ ತ್ವಾಂ ಬಾಧತೇ, ತರ್ಹಿ ತಂ ಕರಂ ಛಿತ್ತ್ವಾ ದೂರೇ ನಿಕ್ಷಿಪ, ಯತಃ ಸರ್ವ್ವವಪುಷೋ ನರಕೇ ನಿಕ್ಷೇಪಾತ್ ಏಕಾಙ್ಗಸ್ಯ ನಾಶೋ ವರಂ| ");
INSERT INTO sankan_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","ಉಕ್ತಮಾಸ್ತೇ, ಯದಿ ಕಶ್ಚಿನ್ ನಿಜಜಾಯಾಂ ಪರಿತ್ಯಕ್ತ್ತುಮ್ ಇಚ್ಛತಿ, ತರ್ಹಿ ಸ ತಸ್ಯೈ ತ್ಯಾಗಪತ್ರಂ ದದಾತು| ");
INSERT INTO sankan_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","ಕಿನ್ತ್ವಹಂ ಯುಷ್ಮಾನ್ ವ್ಯಾಹರಾಮಿ, ವ್ಯಭಿಚಾರದೋಷೇ ನ ಜಾತೇ ಯದಿ ಕಶ್ಚಿನ್ ನಿಜಜಾಯಾಂ ಪರಿತ್ಯಜತಿ, ತರ್ಹಿ ಸ ತಾಂ ವ್ಯಭಿಚಾರಯತಿ; ಯಶ್ಚ ತಾಂ ತ್ಯಕ್ತಾಂ ಸ್ತ್ರಿಯಂ ವಿವಹತಿ, ಸೋಪಿ ವ್ಯಭಿಚರತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","ಪುನಶ್ಚ ತ್ವಂ ಮೃಷಾ ಶಪಥಮ್ ನ ಕುರ್ವ್ವನ್ ಈಶ್ಚರಾಯ ನಿಜಶಪಥಂ ಪಾಲಯ, ಪೂರ್ವ್ವಕಾಲೀನಲೋಕೇಭ್ಯೋ ಯೈಷಾ ಕಥಾ ಕಥಿತಾ, ತಾಮಪಿ ಯೂಯಂ ಶ್ರುತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","ಕಿನ್ತ್ವಹಂ ಯುಷ್ಮಾನ್ ವದಾಮಿ, ಕಮಪಿ ಶಪಥಂ ಮಾ ಕಾರ್ಷ್ಟ, ಅರ್ಥತಃ ಸ್ವರ್ಗನಾಮ್ನಾ ನ, ಯತಃ ಸ ಈಶ್ವರಸ್ಯ ಸಿಂಹಾಸನಂ; ");
INSERT INTO sankan_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ಪೃಥಿವ್ಯಾ ನಾಮ್ನಾಪಿ ನ, ಯತಃ ಸಾ ತಸ್ಯ ಪಾದಪೀಠಂ; ಯಿರೂಶಾಲಮೋ ನಾಮ್ನಾಪಿ ನ, ಯತಃ ಸಾ ಮಹಾರಾಜಸ್ಯ ಪುರೀ; ");
INSERT INTO sankan_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ನಿಜಶಿರೋನಾಮ್ನಾಪಿ ನ, ಯಸ್ಮಾತ್ ತಸ್ಯೈಕಂ ಕಚಮಪಿ ಸಿತಮ್ ಅಸಿತಂ ವಾ ಕರ್ತ್ತುಂ ತ್ವಯಾ ನ ಶಕ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","ಅಪರಂ ಯೂಯಂ ಸಂಲಾಪಸಮಯೇ ಕೇವಲಂ ಭವತೀತಿ ನ ಭವತೀತಿ ಚ ವದತ ಯತ ಇತೋಽಧಿಕಂ ಯತ್ ತತ್ ಪಾಪಾತ್ಮನೋ ಜಾಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","ಅಪರಂ ಲೋಚನಸ್ಯ ವಿನಿಮಯೇನ ಲೋಚನಂ ದನ್ತಸ್ಯ ವಿನಿಮಯೇನ ದನ್ತಃ ಪೂರ್ವ್ವಕ್ತಮಿದಂ ವಚನಞ್ಚ ಯುಷ್ಮಾಭಿರಶ್ರೂಯತ| ");
INSERT INTO sankan_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","ಕಿನ್ತ್ವಹಂ ಯುಷ್ಮಾನ್ ವದಾಮಿ ಯೂಯಂ ಹಿಂಸಕಂ ನರಂ ಮಾ ವ್ಯಾಘಾತಯತ| ಕಿನ್ತು ಕೇನಚಿತ್ ತವ ದಕ್ಷಿಣಕಪೋಲೇ ಚಪೇಟಾಘಾತೇ ಕೃತೇ ತಂ ಪ್ರತಿ ವಾಮಂ ಕಪೋಲಞ್ಚ ವ್ಯಾಘೋಟಯ| ");
INSERT INTO sankan_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ಅಪರಂ ಕೇನಚಿತ್ ತ್ವಯಾ ಸಾರ್ಧ್ದಂ ವಿವಾದಂ ಕೃತ್ವಾ ತವ ಪರಿಧೇಯವಸನೇ ಜಿಘೃತಿತೇ ತಸ್ಮಾಯುತ್ತರೀಯವಸನಮಪಿ ದೇಹಿ| ");
INSERT INTO sankan_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ಯದಿ ಕಶ್ಚಿತ್ ತ್ವಾಂ ಕ್ರೋಶಮೇಕಂ ನಯನಾರ್ಥಂ ಅನ್ಯಾಯತೋ ಧರತಿ, ತದಾ ತೇನ ಸಾರ್ಧ್ದಂ ಕ್ರೋಶದ್ವಯಂ ಯಾಹಿ| ");
INSERT INTO sankan_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ಯಶ್ಚ ಮಾನವಸ್ತ್ವಾಂ ಯಾಚತೇ, ತಸ್ಮೈ ದೇಹಿ, ಯದಿ ಕಶ್ಚಿತ್ ತುಭ್ಯಂ ಧಾರಯಿತುಮ್ ಇಚ್ಛತಿ, ತರ್ಹಿ ತಂ ಪ್ರತಿ ಪರಾಂಮುಖೋ ಮಾ ಭೂಃ| ");
INSERT INTO sankan_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","ನಿಜಸಮೀಪವಸಿನಿ ಪ್ರೇಮ ಕುರು, ಕಿನ್ತು ಶತ್ರುಂ ಪ್ರತಿ ದ್ವೇಷಂ ಕುರು, ಯದೇತತ್ ಪುರೋಕ್ತಂ ವಚನಂ ಏತದಪಿ ಯೂಯಂ ಶ್ರುತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","ಕಿನ್ತ್ವಹಂ ಯುಷ್ಮಾನ್ ವದಾಮಿ, ಯೂಯಂ ರಿಪುವ್ವಪಿ ಪ್ರೇಮ ಕುರುತ, ಯೇ ಚ ಯುಷ್ಮಾನ್ ಶಪನ್ತೇ, ತಾನ, ಆಶಿಷಂ ವದತ, ಯೇ ಚ ಯುಷ್ಮಾನ್ ಋृತೀಯನ್ತೇ, ತೇಷಾಂ ಮಙ್ಗಲಂ ಕುರುತ, ಯೇ ಚ ಯುಷ್ಮಾನ್ ನಿನ್ದನ್ತಿ, ತಾಡಯನ್ತಿ ಚ, ತೇಷಾಂ ಕೃತೇ ಪ್ರಾರ್ಥಯಧ್ವಂ| ");
INSERT INTO sankan_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ತತ್ರ ಯಃ ಸತಾಮಸತಾಞ್ಚೋಪರಿ ಪ್ರಭಾಕರಮ್ ಉದಾಯಯತಿ, ತಥಾ ಧಾರ್ಮ್ಮಿಕಾನಾಮಧಾರ್ಮ್ಮಿಕಾನಾಞ್ಚೋಪರಿ ನೀರಂ ವರ್ಷಯತಿ ತಾದೃಶೋ ಯೋ ಯುಷ್ಮಾಕಂ ಸ್ವರ್ಗಸ್ಥಃ ಪಿತಾ, ಯೂಯಂ ತಸ್ಯೈವ ಸನ್ತಾನಾ ಭವಿಷ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ಯೇ ಯುಷ್ಮಾಸು ಪ್ರೇಮ ಕುರ್ವ್ವನ್ತಿ, ಯೂಯಂ ಯದಿ ಕೇವಲಂ ತೇವ್ವೇವ ಪ್ರೇಮ ಕುರುಥ, ತರ್ಹಿ ಯುಷ್ಮಾಕಂ ಕಿಂ ಫಲಂ ಭವಿಷ್ಯತಿ? ಚಣ್ಡಾಲಾ ಅಪಿ ತಾದೃಶಂ ಕಿಂ ನ ಕುರ್ವ್ವನ್ತಿ? ");
INSERT INTO sankan_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","ಅಪರಂ ಯೂಯಂ ಯದಿ ಕೇವಲಂ ಸ್ವೀಯಭ್ರಾತೃತ್ವೇನ ನಮತ, ತರ್ಹಿ ಕಿಂ ಮಹತ್ ಕರ್ಮ್ಮ ಕುರುಥ? ಚಣ್ಡಾಲಾ ಅಪಿ ತಾದೃಶಂ ಕಿಂ ನ ಕುರ್ವ್ವನ್ತಿ? ");
INSERT INTO sankan_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","ತಸ್ಮಾತ್ ಯುಷ್ಮಾಕಂ ಸ್ವರ್ಗಸ್ಥಃ ಪಿತಾ ಯಥಾ ಪೂರ್ಣೋ ಭವತಿ, ಯೂಯಮಪಿ ತಾದೃಶಾ ಭವತ| ");
INSERT INTO sankan_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","ಸಾವಧಾನಾ ಭವತ, ಮನುಜಾನ್ ದರ್ಶಯಿತುಂ ತೇಷಾಂ ಗೋಚರೇ ಧರ್ಮ್ಮಕರ್ಮ್ಮ ಮಾ ಕುರುತ, ತಥಾ ಕೃತೇ ಯುಷ್ಮಾಕಂ ಸ್ವರ್ಗಸ್ಥಪಿತುಃ ಸಕಾಶಾತ್ ಕಿಞ್ಚನ ಫಲಂ ನ ಪ್ರಾಪ್ಸ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","ತ್ವಂ ಯದಾ ದದಾಸಿ ತದಾ ಕಪಟಿನೋ ಜನಾ ಯಥಾ ಮನುಜೇಭ್ಯಃ ಪ್ರಶಂಸಾಂ ಪ್ರಾಪ್ತುಂ ಭಜನಭವನೇ ರಾಜಮಾರ್ಗೇ ಚ ತೂರೀಂ ವಾದಯನ್ತಿ, ತಥಾ ಮಾ ಕುರಿु, ಅಹಂ ತುಭ್ಯಂ ಯಥಾರ್ಥಂ ಕಥಯಾಮಿ, ತೇ ಸ್ವಕಾಯಂ ಫಲಮ್ ಅಲಭನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","ಕಿನ್ತು ತ್ವಂ ಯದಾ ದದಾಸಿ, ತದಾ ನಿಜದಕ್ಷಿಣಕರೋ ಯತ್ ಕರೋತಿ, ತದ್ ವಾಮಕರಂ ಮಾ ಜ್ಞಾಪಯ| ");
INSERT INTO sankan_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ತೇನ ತವ ದಾನಂ ಗುಪ್ತಂ ಭವಿಷ್ಯತಿ ಯಸ್ತು ತವ ಪಿತಾ ಗುಪ್ತದರ್ಶೀ, ಸ ಪ್ರಕಾಶ್ಯ ತುಭ್ಯಂ ಫಲಂ ದಾಸ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","ಅಪರಂ ಯದಾ ಪ್ರಾರ್ಥಯಸೇ, ತದಾ ಕಪಟಿನಇವ ಮಾ ಕುರು, ಯಸ್ಮಾತ್ ತೇ ಭಜನಭವನೇ ರಾಜಮಾರ್ಗಸ್ಯ ಕೋಣೇ ತಿಷ್ಠನ್ತೋ ಲೋಕಾನ್ ದರ್ಶಯನ್ತಃ ಪ್ರಾರ್ಥಯಿತುಂ ಪ್ರೀಯನ್ತೇ; ಅಹಂ ಯುಷ್ಮಾನ್ ತಥ್ಯಂ ವದಾಮಿ, ತೇ ಸ್ವಕೀಯಫಲಂ ಪ್ರಾಪ್ನುವನ್| ");
INSERT INTO sankan_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","ತಸ್ಮಾತ್ ಪ್ರಾರ್ಥನಾಕಾಲೇ ಅನ್ತರಾಗಾರಂ ಪ್ರವಿಶ್ಯ ದ್ವಾರಂ ರುದ್ವ್ವಾ ಗುಪ್ತಂ ಪಶ್ಯತಸ್ತವ ಪಿತುಃ ಸಮೀಪೇ ಪ್ರಾರ್ಥಯಸ್ವ; ತೇನ ತವ ಯಃ ಪಿತಾ ಗುಪ್ತದರ್ಶೀ, ಸ ಪ್ರಕಾಶ್ಯ ತುಭ್ಯಂ ಫಲಂ ದಾಸ್ಯತಿl ");
INSERT INTO sankan_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","ಅಪರಂ ಪ್ರಾರ್ಥನಾಕಾಲೇ ದೇವಪೂಜಕಾಇವ ಮುಧಾ ಪುನರುಕ್ತಿಂ ಮಾ ಕುರು, ಯಸ್ಮಾತ್ ತೇ ಬೋಧನ್ತೇ, ಬಹುವಾರಂ ಕಥಾಯಾಂ ಕಥಿತಾಯಾಂ ತೇಷಾಂ ಪ್ರಾರ್ಥನಾ ಗ್ರಾಹಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","ಯೂಯಂ ತೇಷಾಮಿವ ಮಾ ಕುರುತ, ಯಸ್ಮಾತ್ ಯುಷ್ಮಾಕಂ ಯದ್ ಯತ್ ಪ್ರಯೋಜನಂ ಯಾಚನಾತಃ ಪ್ರಾಗೇವ ಯುಷ್ಮಾಕಂ ಪಿತಾ ತತ್ ಜಾನಾತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","ಅತಏವ ಯೂಯಮ ಈದೃಕ್ ಪ್ರಾರ್ಥಯಧ್ವಂ, ಹೇ ಅಸ್ಮಾಕಂ ಸ್ವರ್ಗಸ್ಥಪಿತಃ, ತವ ನಾಮ ಪೂಜ್ಯಂ ಭವತು| ");
INSERT INTO sankan_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ತವ ರಾಜತ್ವಂ ಭವತು; ತವೇಚ್ಛಾ ಸ್ವರ್ಗೇ ಯಥಾ ತಥೈವ ಮೇದಿನ್ಯಾಮಪಿ ಸಫಲಾ ಭವತು| ");
INSERT INTO sankan_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ಅಸ್ಮಾಕಂ ಪ್ರಯೋಜನೀಯಮ್ ಆಹಾರಮ್ ಅದ್ಯ ದೇಹಿ| ");
INSERT INTO sankan_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ವಯಂ ಯಥಾ ನಿಜಾಪರಾಧಿನಃ ಕ್ಷಮಾಮಹೇ, ತಥೈವಾಸ್ಮಾಕಮ್ ಅಪರಾಧಾನ್ ಕ್ಷಮಸ್ವ| ");
INSERT INTO sankan_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ಅಸ್ಮಾನ್ ಪರೀಕ್ಷಾಂ ಮಾನಯ, ಕಿನ್ತು ಪಾಪಾತ್ಮನೋ ರಕ್ಷ; ರಾಜತ್ವಂ ಗೌರವಂ ಪರಾಕ್ರಮಃ ಏತೇ ಸರ್ವ್ವೇ ಸರ್ವ್ವದಾ ತವ; ತಥಾಸ್ತು| ");
INSERT INTO sankan_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","ಯದಿ ಯೂಯಮ್ ಅನ್ಯೇಷಾಮ್ ಅಪರಾಧಾನ್ ಕ್ಷಮಧ್ವೇ ತರ್ಹಿ ಯುಷ್ಮಾಕಂ ಸ್ವರ್ಗಸ್ಥಪಿತಾಪಿ ಯುಷ್ಮಾನ್ ಕ್ಷಮಿಷ್ಯತೇ; ");
INSERT INTO sankan_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ಕಿನ್ತು ಯದಿ ಯೂಯಮ್ ಅನ್ಯೇಷಾಮ್ ಅಪರಾಧಾನ್ ನ ಕ್ಷಮಧ್ವೇ, ತರ್ಹಿ ಯುಷ್ಮಾಕಂ ಜನಕೋಪಿ ಯುಷ್ಮಾಕಮ್ ಅಪರಾಧಾನ್ ನ ಕ್ಷಮಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","ಅಪರಮ್ ಉಪವಾಸಕಾಲೇ ಕಪಟಿನೋ ಜನಾ ಮಾನುಷಾನ್ ಉಪವಾಸಂ ಜ್ಞಾಪಯಿತುಂ ಸ್ವೇಷಾಂ ವದನಾನಿ ಮ್ಲಾನಾನಿ ಕುರ್ವ್ವನ್ತಿ, ಯೂಯಂ ತಇವ ವಿಷಣವದನಾ ಮಾ ಭವತ; ಅಹಂ ಯುಷ್ಮಾನ್ ತಥ್ಯಂ ವದಾಮಿ ತೇ ಸ್ವಕೀಯಫಲಮ್ ಅಲಭನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","ಯದಾ ತ್ವಮ್ ಉಪವಸಸಿ, ತದಾ ಯಥಾ ಲೋಕೈಸ್ತ್ವಂ ಉಪವಾಸೀವ ನ ದೃಶ್ಯಸೇ, ಕಿನ್ತು ತವ ಯೋಽಗೋಚರಃ ಪಿತಾ ತೇನೈವ ದೃಶ್ಯಸೇ, ತತ್ಕೃತೇ ನಿಜಶಿರಸಿ ತೈಲಂ ಮರ್ದ್ದಯ ವದನಞ್ಚ ಪ್ರಕ್ಷಾಲಯ; ");
INSERT INTO sankan_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ತೇನ ತವ ಯಃ ಪಿತಾ ಗುಪ್ತದರ್ಶೀ ಸ ಪ್ರಕಾಶ್ಯ ತುಭ್ಯಂ ಫಲಂ ದಾಸ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","ಅಪರಂ ಯತ್ರ ಸ್ಥಾನೇ ಕೀಟಾಃ ಕಲಙ್ಕಾಶ್ಚ ಕ್ಷಯಂ ನಯನ್ತಿ, ಚೌರಾಶ್ಚ ಸನ್ಧಿಂ ಕರ್ತ್ತಯಿತ್ವಾ ಚೋರಯಿತುಂ ಶಕ್ನುವನ್ತಿ, ತಾದೃಶ್ಯಾಂ ಮೇದಿನ್ಯಾಂ ಸ್ವಾರ್ಥಂ ಧನಂ ಮಾ ಸಂಚಿನುತ| ");
INSERT INTO sankan_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","ಕಿನ್ತು ಯತ್ರ ಸ್ಥಾನೇ ಕೀಟಾಃ ಕಲಙ್ಕಾಶ್ಚ ಕ್ಷಯಂ ನ ನಯನ್ತಿ, ಚೌರಾಶ್ಚ ಸನ್ಧಿಂ ಕರ್ತ್ತಯಿತ್ವಾ ಚೋರಯಿತುಂ ನ ಶಕ್ನುವನ್ತಿ, ತಾದೃಶೇ ಸ್ವರ್ಗೇ ಧನಂ ಸಞ್ಚಿನುತ| ");
INSERT INTO sankan_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ಯಸ್ಮಾತ್ ಯತ್ರ ಸ್ಥಾನೇ ಯುಷ್ಮಾಂಕ ಧನಂ ತತ್ರೈವ ಖಾನೇ ಯುಷ್ಮಾಕಂ ಮನಾಂಸಿ| ");
INSERT INTO sankan_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","ಲೋಚನಂ ದೇಹಸ್ಯ ಪ್ರದೀಪಕಂ, ತಸ್ಮಾತ್ ಯದಿ ತವ ಲೋಚನಂ ಪ್ರಸನ್ನಂ ಭವತಿ, ತರ್ಹಿ ತವ ಕೃತ್ಸ್ನಂ ವಪು ರ್ದೀಪ್ತಿಯುಕ್ತಂ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ಕಿನ್ತು ಲೋಚನೇಽಪ್ರಸನ್ನೇ ತವ ಕೃತ್ಸ್ನಂ ವಪುಃ ತಮಿಸ್ರಯುಕ್ತಂ ಭವಿಷ್ಯತಿ| ಅತಏವ ಯಾ ದೀಪ್ತಿಸ್ತ್ವಯಿ ವಿದ್ಯತೇ, ಸಾ ಯದಿ ತಮಿಸ್ರಯುಕ್ತಾ ಭವತಿ, ತರ್ಹಿ ತತ್ ತಮಿಸ್ರಂ ಕಿಯನ್ ಮಹತ್| ");
INSERT INTO sankan_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","ಕೋಪಿ ಮನುಜೋ ದ್ವೌ ಪ್ರಭೂ ಸೇವಿತುಂ ನ ಶಕ್ನೋತಿ, ಯಸ್ಮಾದ್ ಏಕಂ ಸಂಮನ್ಯ ತದನ್ಯಂ ನ ಸಮ್ಮನ್ಯತೇ, ಯದ್ವಾ ಏಕತ್ರ ಮನೋ ನಿಧಾಯ ತದನ್ಯಮ್ ಅವಮನ್ಯತೇ; ತಥಾ ಯೂಯಮಪೀಶ್ವರಂ ಲಕ್ಷ್ಮೀಞ್ಚೇತ್ಯುಭೇ ಸೇವಿತುಂ ನ ಶಕ್ನುಥ| ");
INSERT INTO sankan_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","ಅಪರಮ್ ಅಹಂ ಯುಷ್ಮಭ್ಯಂ ತಥ್ಯಂ ಕಥಯಾಮಿ, ಕಿಂ ಭಕ್ಷಿಷ್ಯಾಮಃ? ಕಿಂ ಪಾಸ್ಯಾಮಃ? ಇತಿ ಪ್ರಾಣಧಾರಣಾಯ ಮಾ ಚಿನ್ತಯತ; ಕಿಂ ಪರಿಧಾಸ್ಯಾಮಃ? ಇತಿ ಕಾಯರಕ್ಷಣಾಯ ನ ಚಿನ್ತಯತ; ಭಕ್ಷ್ಯಾತ್ ಪ್ರಾಣಾ ವಸನಾಞ್ಚ ವಪೂಂಷಿ ಕಿಂ ಶ್ರೇಷ್ಠಾಣಿ ನ ಹಿ? ");
INSERT INTO sankan_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ವಿಹಾಯಸೋ ವಿಹಙ್ಗಮಾನ್ ವಿಲೋಕಯತ; ತೈ ರ್ನೋಪ್ಯತೇ ನ ಕೃತ್ಯತೇ ಭಾಣ್ಡಾಗಾರೇ ನ ಸಞ್ಚೀಯತೇಽಪಿ; ತಥಾಪಿ ಯುಷ್ಮಾಕಂ ಸ್ವರ್ಗಸ್ಥಃ ಪಿತಾ ತೇಭ್ಯ ಆಹಾರಂ ವಿತರತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","ಯೂಯಂ ತೇಭ್ಯಃ ಕಿಂ ಶ್ರೇಷ್ಠಾ ನ ಭವಥ? ಯುಷ್ಮಾಕಂ ಕಶ್ಚಿತ್ ಮನುಜಃ ಚಿನ್ತಯನ್ ನಿಜಾಯುಷಃ ಕ್ಷಣಮಪಿ ವರ್ದ್ಧಯಿತುಂ ಶಕ್ನೋತಿ? ");
INSERT INTO sankan_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","ಅಪರಂ ವಸನಾಯ ಕುತಶ್ಚಿನ್ತಯತ? ಕ್ಷೇತ್ರೋತ್ಪನ್ನಾನಿ ಪುಷ್ಪಾಣಿ ಕಥಂ ವರ್ದ್ಧನ್ತೇ ತದಾಲೋಚಯತ| ತಾನಿ ತನ್ತೂನ್ ನೋತ್ಪಾದಯನ್ತಿ ಕಿಮಪಿ ಕಾರ್ಯ್ಯಂ ನ ಕುರ್ವ್ವನ್ತಿ; ");
INSERT INTO sankan_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ತಥಾಪ್ಯಹಂ ಯುಷ್ಮಾನ್ ವದಾಮಿ, ಸುಲೇಮಾನ್ ತಾದೃಗ್ ಐಶ್ವರ್ಯ್ಯವಾನಪಿ ತತ್ಪುಷ್ಪಮಿವ ವಿಭೂಷಿತೋ ನಾಸೀತ್| ");
INSERT INTO sankan_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ತಸ್ಮಾತ್ ಕ್ಷದ್ಯ ವಿದ್ಯಮಾನಂ ಶ್ಚಃ ಚುಲ್ಲ್ಯಾಂ ನಿಕ್ಷೇಪ್ಸ್ಯತೇ ತಾದೃಶಂ ಯತ್ ಕ್ಷೇತ್ರಸ್ಥಿತಂ ಕುಸುಮಂ ತತ್ ಯದೀಶ್ಚರ ಇತ್ಥಂ ಬಿಭೂಷಯತಿ, ತರ್ಹಿ ಹೇ ಸ್ತೋಕಪ್ರತ್ಯಯಿನೋ ಯುಷ್ಮಾನ್ ಕಿಂ ನ ಪರಿಧಾಪಯಿಷ್ಯತಿ? ");
INSERT INTO sankan_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","ತಸ್ಮಾತ್ ಅಸ್ಮಾಭಿಃ ಕಿಮತ್ಸ್ಯತೇ? ಕಿಞ್ಚ ಪಾಯಿಷ್ಯತೇ? ಕಿಂ ವಾ ಪರಿಧಾಯಿಷ್ಯತೇ, ಇತಿ ನ ಚಿನ್ತಯತ| ");
INSERT INTO sankan_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ಯಸ್ಮಾತ್ ದೇವಾರ್ಚ್ಚಕಾ ಅಪೀತಿ ಚೇಷ್ಟನ್ತೇ; ಏತೇಷು ದ್ರವ್ಯೇಷು ಪ್ರಯೋಜನಮಸ್ತೀತಿ ಯುಷ್ಮಾಕಂ ಸ್ವರ್ಗಸ್ಥಃ ಪಿತಾ ಜಾನಾತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ಅತಏವ ಪ್ರಥಮತ ಈಶ್ವರೀಯರಾಜ್ಯಂ ಧರ್ಮ್ಮಞ್ಚ ಚೇಷ್ಟಧ್ವಂ, ತತ ಏತಾನಿ ವಸ್ತೂನಿ ಯುಷ್ಮಭ್ಯಂ ಪ್ರದಾಯಿಷ್ಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","ಶ್ವಃ ಕೃತೇ ಮಾ ಚಿನ್ತಯತ, ಶ್ವಏವ ಸ್ವಯಂ ಸ್ವಮುದ್ದಿಶ್ಯ ಚಿನ್ತಯಿಷ್ಯತಿ; ಅದ್ಯತನೀ ಯಾ ಚಿನ್ತಾ ಸಾದ್ಯಕೃತೇ ಪ್ರಚುರತರಾ| ");
INSERT INTO sankan_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","ಯಥಾ ಯೂಯಂ ದೋಷೀಕೃತಾ ನ ಭವಥ, ತತ್ಕೃತೇಽನ್ಯಂ ದೋಷಿಣಂ ಮಾ ಕುರುತ| ");
INSERT INTO sankan_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ಯತೋ ಯಾದೃಶೇನ ದೋಷೇಣ ಯೂಯಂ ಪರಾನ್ ದೋಷಿಣಃ ಕುರುಥ, ತಾದೃಶೇನ ದೋಷೇಣ ಯೂಯಮಪಿ ದೋಷೀಕೃತಾ ಭವಿಷ್ಯಥ, ಅನ್ಯಞ್ಚ ಯೇನ ಪರಿಮಾಣೇನ ಯುಷ್ಮಾಭಿಃ ಪರಿಮೀಯತೇ, ತೇನೈವ ಪರಿಮಾಣೇನ ಯುಷ್ಮತ್ಕೃತೇ ಪರಿಮಾಯಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","ಅಪರಞ್ಚ ನಿಜನಯನೇ ಯಾ ನಾಸಾ ವಿದ್ಯತೇ, ತಾಮ್ ಅನಾಲೋಚ್ಯ ತವ ಸಹಜಸ್ಯ ಲೋಚನೇ ಯತ್ ತೃಣಮ್ ಆಸ್ತೇ, ತದೇವ ಕುತೋ ವೀಕ್ಷಸೇ? ");
INSERT INTO sankan_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","ತವ ನಿಜಲೋಚನೇ ನಾಸಾಯಾಂ ವಿದ್ಯಮಾನಾಯಾಂ, ಹೇ ಭ್ರಾತಃ, ತವ ನಯನಾತ್ ತೃಣಂ ಬಹಿಷ್ಯರ್ತುಂ ಅನುಜಾನೀಹಿ, ಕಥಾಮೇತಾಂ ನಿಜಸಹಜಾಯ ಕಥಂ ಕಥಯಿತುಂ ಶಕ್ನೋಷಿ? ");
INSERT INTO sankan_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ಹೇ ಕಪಟಿನ್, ಆದೌ ನಿಜನಯನಾತ್ ನಾಸಾಂ ಬಹಿಷ್ಕುರು ತತೋ ನಿಜದೃಷ್ಟೌ ಸುಪ್ರಸನ್ನಾಯಾಂ ತವ ಭ್ರಾತೃ ರ್ಲೋಚನಾತ್ ತೃಣಂ ಬಹಿಷ್ಕರ್ತುಂ ಶಕ್ಷ್ಯಸಿ| ");
INSERT INTO sankan_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","ಅನ್ಯಞ್ಚ ಸಾರಮೇಯೇಭ್ಯಃ ಪವಿತ್ರವಸ್ತೂನಿ ಮಾ ವಿತರತ, ವರಾಹಾಣಾಂ ಸಮಕ್ಷಞ್ಚ ಮುಕ್ತಾ ಮಾ ನಿಕ್ಷಿಪತ; ನಿಕ್ಷೇಪಣಾತ್ ತೇ ತಾಃ ಸರ್ವ್ವಾಃ ಪದೈ ರ್ದಲಯಿಷ್ಯನ್ತಿ, ಪರಾವೃತ್ಯ ಯುಷ್ಮಾನಪಿ ವಿದಾರಯಿಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","ಯಾಚಧ್ವಂ ತತೋ ಯುಷ್ಮಭ್ಯಂ ದಾಯಿಷ್ಯತೇ; ಮೃಗಯಧ್ವಂ ತತ ಉದ್ದೇಶಂ ಲಪ್ಸ್ಯಧ್ವೇ; ದ್ವಾರಮ್ ಆಹತ, ತತೋ ಯುಷ್ಮತ್ಕೃತೇ ಮುಕ್ತಂ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ಯಸ್ಮಾದ್ ಯೇನ ಯಾಚ್ಯತೇ, ತೇನ ಲಭ್ಯತೇ; ಯೇನ ಮೃಗ್ಯತೇ ತೇನೋದ್ದೇಶಃ ಪ್ರಾಪ್ಯತೇ; ಯೇನ ಚ ದ್ವಾರಮ್ ಆಹನ್ಯತೇ, ತತ್ಕೃತೇ ದ್ವಾರಂ ಮೋಚ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","ಆತ್ಮಜೇನ ಪೂಪೇ ಪ್ರಾರ್ಥಿತೇ ತಸ್ಮೈ ಪಾಷಾಣಂ ವಿಶ್ರಾಣಯತಿ, ");
INSERT INTO sankan_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","ಮೀನೇ ಯಾಚಿತೇ ಚ ತಸ್ಮೈ ಭುಜಗಂ ವಿತರತಿ, ಏತಾದೃಶಃ ಪಿತಾ ಯುಷ್ಮಾಕಂ ಮಧ್ಯೇ ಕ ಆಸ್ತೇ? ");
INSERT INTO sankan_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","ತಸ್ಮಾದ್ ಯೂಯಮ್ ಅಭದ್ರಾಃ ಸನ್ತೋಽಪಿ ಯದಿ ನಿಜಬಾಲಕೇಭ್ಯ ಉತ್ತಮಂ ದ್ರವ್ಯಂ ದಾತುಂ ಜಾನೀಥ, ತರ್ಹಿ ಯುಷ್ಮಾಕಂ ಸ್ವರ್ಗಸ್ಥಃ ಪಿತಾ ಸ್ವೀಯಯಾಚಕೇಭ್ಯಃ ಕಿಮುತ್ತಮಾನಿ ವಸ್ತೂನಿ ನ ದಾಸ್ಯತಿ? ");
INSERT INTO sankan_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","ಯೂಷ್ಮಾನ್ ಪ್ರತೀತರೇಷಾಂ ಯಾದೃಶೋ ವ್ಯವಹಾರೋ ಯುಷ್ಮಾಕಂ ಪ್ರಿಯಃ, ಯೂಯಂ ತಾನ್ ಪ್ರತಿ ತಾದೃಶಾನೇವ ವ್ಯವಹಾರಾನ್ ವಿಧತ್ತ; ಯಸ್ಮಾದ್ ವ್ಯವಸ್ಥಾಭವಿಷ್ಯದ್ವಾದಿನಾಂ ವಚನಾನಾಮ್ ಇತಿ ಸಾರಮ್| ");
INSERT INTO sankan_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","ಸಙ್ಕೀರ್ಣದ್ವಾರೇಣ ಪ್ರವಿಶತ; ಯತೋ ನರಕಗಮನಾಯ ಯದ್ ದ್ವಾರಂ ತದ್ ವಿಸ್ತೀರ್ಣಂ ಯಚ್ಚ ವರ್ತ್ಮ ತದ್ ಬೃಹತ್ ತೇನ ಬಹವಃ ಪ್ರವಿಶನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","ಅಪರಂ ಸ್ವರ್ಗಗಮನಾಯ ಯದ್ ದ್ವಾರಂ ತತ್ ಕೀದೃಕ್ ಸಂಕೀರ್ಣಂ| ಯಚ್ಚ ವರ್ತ್ಮ ತತ್ ಕೀದೃಗ್ ದುರ್ಗಮಮ್| ತದುದ್ದೇಷ್ಟಾರಃ ಕಿಯನ್ತೋಽಲ್ಪಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","ಅಪರಞ್ಚ ಯೇ ಜನಾ ಮೇಷವೇಶೇನ ಯುಷ್ಮಾಕಂ ಸಮೀಪಮ್ ಆಗಚ್ಛನ್ತಿ, ಕಿನ್ತ್ವನ್ತರ್ದುರನ್ತಾ ವೃಕಾ ಏತಾದೃಶೇಭ್ಯೋ ಭವಿಷ್ಯದ್ವಾದಿಭ್ಯಃ ಸಾವಧಾನಾ ಭವತ, ಯೂಯಂ ಫಲೇನ ತಾನ್ ಪರಿಚೇತುಂ ಶಕ್ನುಥ| ");
INSERT INTO sankan_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","ಮನುಜಾಃ ಕಿಂ ಕಣ್ಟಕಿನೋ ವೃಕ್ಷಾದ್ ದ್ರಾಕ್ಷಾಫಲಾನಿ ಶೃಗಾಲಕೋಲಿತಶ್ಚ ಉಡುಮ್ಬರಫಲಾನಿ ಶಾತಯನ್ತಿ? ");
INSERT INTO sankan_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","ತದ್ವದ್ ಉತ್ತಮ ಏವ ಪಾದಪ ಉತ್ತಮಫಲಾನಿ ಜನಯತಿ, ಅಧಮಪಾದಪಏವಾಧಮಫಲಾನಿ ಜನಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","ಕಿನ್ತೂತ್ತಮಪಾದಪಃ ಕದಾಪ್ಯಧಮಫಲಾನಿ ಜನಯಿತುಂ ನ ಶಕ್ನೋತಿ, ತಥಾಧಮೋಪಿ ಪಾದಪ ಉತ್ತಮಫಲಾನಿ ಜನಯಿತುಂ ನ ಶಕ್ನೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","ಅಪರಂ ಯೇ ಯೇ ಪಾದಪಾ ಅಧಮಫಲಾನಿ ಜನಯನ್ತಿ, ತೇ ಕೃತ್ತಾ ವಹ್ನೌ ಕ್ಷಿಪ್ಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ಅತಏವ ಯೂಯಂ ಫಲೇನ ತಾನ್ ಪರಿಚೇಷ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","ಯೇ ಜನಾ ಮಾಂ ಪ್ರಭುಂ ವದನ್ತಿ, ತೇ ಸರ್ವ್ವೇ ಸ್ವರ್ಗರಾಜ್ಯಂ ಪ್ರವೇಕ್ಷ್ಯನ್ತಿ ತನ್ನ, ಕಿನ್ತು ಯೋ ಮಾನವೋ ಮಮ ಸ್ವರ್ಗಸ್ಥಸ್ಯ ಪಿತುರಿಷ್ಟಂ ಕರ್ಮ್ಮ ಕರೋತಿ ಸ ಏವ ಪ್ರವೇಕ್ಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","ತದ್ ದಿನೇ ಬಹವೋ ಮಾಂ ವದಿಷ್ಯನ್ತಿ, ಹೇ ಪ್ರಭೋ ಹೇ ಪ್ರಭೋ, ತವ ನಾಮ್ನಾ ಕಿಮಸ್ಮಾಮಿ ರ್ಭವಿಷ್ಯದ್ವಾಕ್ಯಂ ನ ವ್ಯಾಹೃತಂ? ತವ ನಾಮ್ನಾ ಭೂತಾಃ ಕಿಂ ನ ತ್ಯಾಜಿತಾಃ? ತವ ನಾಮ್ನಾ ಕಿಂ ನಾನಾದ್ಭುತಾನಿ ಕರ್ಮ್ಮಾಣಿ ನ ಕೃತಾನಿ? ");
INSERT INTO sankan_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","ತದಾಹಂ ವದಿಷ್ಯಾಮಿ, ಹೇ ಕುಕರ್ಮ್ಮಕಾರಿಣೋ ಯುಷ್ಮಾನ್ ಅಹಂ ನ ವೇದ್ಮಿ, ಯೂಯಂ ಮತ್ಸಮೀಪಾದ್ ದೂರೀಭವತ| ");
INSERT INTO sankan_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","ಯಃ ಕಶ್ಚಿತ್ ಮಮೈತಾಃ ಕಥಾಃ ಶ್ರುತ್ವಾ ಪಾಲಯತಿ, ಸ ಪಾಷಾಣೋಪರಿ ಗೃಹನಿರ್ಮ್ಮಾತ್ರಾ ಜ್ಞಾನಿನಾ ಸಹ ಮಯೋಪಮೀಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","ಯತೋ ವೃಷ್ಟೌ ಸತ್ಯಾಮ್ ಆಪ್ಲಾವ ಆಗತೇ ವಾಯೌ ವಾತೇ ಚ ತೇಷು ತದ್ಗೇಹಂ ಲಗ್ನೇಷು ಪಾಷಾಣೋಪರಿ ತಸ್ಯ ಭಿತ್ತೇಸ್ತನ್ನ ಪತತಿl ");
INSERT INTO sankan_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","ಕಿನ್ತು ಯಃ ಕಶ್ಚಿತ್ ಮಮೈತಾಃ ಕಥಾಃ ಶ್ರುತ್ವಾ ನ ಪಾಲಯತಿ ಸ ಸೈಕತೇ ಗೇಹನಿರ್ಮ್ಮಾತ್ರಾ ಽಜ್ಞಾನಿನಾ ಉಪಮೀಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","ಯತೋ ಜಲವೃಷ್ಟೌ ಸತ್ಯಾಮ್ ಆಪ್ಲಾವ ಆಗತೇ ಪವನೇ ವಾತೇ ಚ ತೈ ರ್ಗೃಹೇ ಸಮಾಘಾತೇ ತತ್ ಪತತಿ ತತ್ಪತನಂ ಮಹದ್ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","ಯೀಶುನೈತೇಷು ವಾಕ್ಯೇಷು ಸಮಾಪಿತೇಷು ಮಾನವಾಸ್ತದೀಯೋಪದೇಶಮ್ ಆಶ್ಚರ್ಯ್ಯಂ ಮೇನಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ಯಸ್ಮಾತ್ ಸ ಉಪಾಧ್ಯಾಯಾ ಇವ ತಾನ್ ನೋಪದಿದೇಶ ಕಿನ್ತು ಸಮರ್ಥಪುರುಷಇವ ಸಮುಪದಿದೇಶ| ");
INSERT INTO sankan_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","ಯದಾ ಸ ಪರ್ವ್ವತಾದ್ ಅವಾರೋಹತ್ ತದಾ ಬಹವೋ ಮಾನವಾಸ್ತತ್ಪಶ್ಚಾದ್ ವವ್ರಜುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ಏಕಃ ಕುಷ್ಠವಾನ್ ಆಗತ್ಯ ತಂ ಪ್ರಣಮ್ಯ ಬಭಾಷೇ, ಹೇ ಪ್ರಭೋ, ಯದಿ ಭವಾನ್ ಸಂಮನ್ಯತೇ, ತರ್ಹಿ ಮಾಂ ನಿರಾಮಯಂ ಕರ್ತ್ತುಂ ಶಕ್ನೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ತತೋ ಯೀಶುಃ ಕರಂ ಪ್ರಸಾರ್ಯ್ಯ ತಸ್ಯಾಙ್ಗಂ ಸ್ಪೃಶನ್ ವ್ಯಾಜಹಾರ, ಸಮ್ಮನ್ಯೇಽಹಂ ತ್ವಂ ನಿರಾಮಯೋ ಭವ; ತೇನ ಸ ತತ್ಕ್ಷಣಾತ್ ಕುಷ್ಠೇನಾಮೋಚಿ| ");
INSERT INTO sankan_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ತತೋ ಯೀಶುಸ್ತಂ ಜಗಾದ, ಅವಧೇಹಿ ಕಥಾಮೇತಾಂ ಕಶ್ಚಿದಪಿ ಮಾ ಬ್ರೂಹಿ, ಕಿನ್ತು ಯಾಜಕಸ್ಯ ಸನ್ನಿಧಿಂ ಗತ್ವಾ ಸ್ವಾತ್ಮಾನಂ ದರ್ಶಯ ಮನುಜೇಭ್ಯೋ ನಿಜನಿರಾಮಯತ್ವಂ ಪ್ರಮಾಣಯಿತುಂ ಮೂಸಾನಿರೂಪಿತಂ ದ್ರವ್ಯಮ್ ಉತ್ಸೃಜ ಚ| ");
INSERT INTO sankan_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","ತದನನ್ತರಂ ಯೀಶುನಾ ಕಫರ್ನಾಹೂಮ್ನಾಮನಿ ನಗರೇ ಪ್ರವಿಷ್ಟೇ ಕಶ್ಚಿತ್ ಶತಸೇನಾಪತಿಸ್ತತ್ಸಮೀಪಮ್ ಆಗತ್ಯ ವಿನೀಯ ಬಭಾಷೇ, ");
INSERT INTO sankan_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ಹೇ ಪ್ರಭೋ, ಮದೀಯ ಏಕೋ ದಾಸಃ ಪಕ್ಷಾಘಾತವ್ಯಾಧಿನಾ ಭೃಶಂ ವ್ಯಥಿತಃ, ಸತು ಶಯನೀಯ ಆಸ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ತದಾನೀಂ ಯೀಶುಸ್ತಸ್ಮೈ ಕಥಿತವಾನ್, ಅಹಂ ಗತ್ವಾ ತಂ ನಿರಾಮಯಂ ಕರಿಷ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ತತಃ ಸ ಶತಸೇನಾಪತಿಃ ಪ್ರತ್ಯವದತ್, ಹೇ ಪ್ರಭೋ, ಭವಾನ್ ಯತ್ ಮಮ ಗೇಹಮಧ್ಯಂ ಯಾತಿ ತದ್ಯೋಗ್ಯಭಾಜನಂ ನಾಹಮಸ್ಮಿ; ವಾಙ್ಮಾತ್ರಮ್ ಆದಿಶತು, ತೇನೈವ ಮಮ ದಾಸೋ ನಿರಾಮಯೋ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","ಯತೋ ಮಯಿ ಪರನಿಧ್ನೇಽಪಿ ಮಮ ನಿದೇಶವಶ್ಯಾಃ ಕತಿ ಕತಿ ಸೇನಾಃ ಸನ್ತಿ, ತತ ಏಕಸ್ಮಿನ್ ಯಾಹೀತ್ಯುಕ್ತೇ ಸ ಯಾತಿ, ತದನ್ಯಸ್ಮಿನ್ ಏಹೀತ್ಯುಕ್ತೇ ಸ ಆಯಾತಿ, ತಥಾ ಮಮ ನಿಜದಾಸೇ ಕರ್ಮ್ಮೈತತ್ ಕುರ್ವ್ವಿತ್ಯುಕ್ತೇ ಸ ತತ್ ಕರೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ತದಾನೀಂ ಯೀಶುಸ್ತಸ್ಯೈತತ್ ವಚೋ ನಿಶಮ್ಯ ವಿಸ್ಮಯಾಪನ್ನೋಽಭೂತ್; ನಿಜಪಶ್ಚಾದ್ಗಾಮಿನೋ ಮಾನವಾನ್ ಅವೋಚ್ಚ, ಯುಷ್ಮಾನ್ ತಥ್ಯಂ ವಚ್ಮಿ, ಇಸ್ರಾಯೇಲೀಯಲೋಕಾನಾಂ ಮಧ್ಯೇಽಪಿ ನೈತಾದೃಶೋ ವಿಶ್ವಾಸೋ ಮಯಾ ಪ್ರಾಪ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","ಅನ್ಯಚ್ಚಾಹಂ ಯುಷ್ಮಾನ್ ವದಾಮಿ, ಬಹವಃ ಪೂರ್ವ್ವಸ್ಯಾಃ ಪಶ್ಚಿಮಾಯಾಶ್ಚ ದಿಶ ಆಗತ್ಯ ಇಬ್ರಾಹೀಮಾ ಇಸ್ಹಾಕಾ ಯಾಕೂಬಾ ಚ ಸಾಕಮ್ ಮಿಲಿತ್ವಾ ಸಮುಪವೇಕ್ಷ್ಯನ್ತಿ; ");
INSERT INTO sankan_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ಕಿನ್ತು ಯತ್ರ ಸ್ಥಾನೇ ರೋದನದನ್ತಘರ್ಷಣೇ ಭವತಸ್ತಸ್ಮಿನ್ ಬಹಿರ್ಭೂತತಮಿಸ್ರೇ ರಾಜ್ಯಸ್ಯ ಸನ್ತಾನಾ ನಿಕ್ಷೇಸ್ಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ತತಃ ಪರಂ ಯೀಶುಸ್ತಂ ಶತಸೇನಾಪತಿಂ ಜಗಾದ, ಯಾಹಿ, ತವ ಪ್ರತೀತ್ಯನುಸಾರತೋ ಮಙ್ಗಲಂ ಭೂಯಾತ್; ತದಾ ತಸ್ಮಿನ್ನೇವ ದಣ್ಡೇ ತದೀಯದಾಸೋ ನಿರಾಮಯೋ ಬಭೂವ| ");
INSERT INTO sankan_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ಅನನ್ತರಂ ಯೀಶುಃ ಪಿತರಸ್ಯ ಗೇಹಮುಪಸ್ಥಾಯ ಜ್ವರೇಣ ಪೀಡಿತಾಂ ಶಯನೀಯಸ್ಥಿತಾಂ ತಸ್ಯ ಶ್ವಶ್ರೂಂ ವೀಕ್ಷಾಞ್ಚಕ್ರೇ| ");
INSERT INTO sankan_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ತತಸ್ತೇನ ತಸ್ಯಾಃ ಕರಸ್ಯ ಸ್ಪೃಷ್ಟತವಾತ್ ಜ್ವರಸ್ತಾಂ ತತ್ಯಾಜ, ತದಾ ಸಾ ಸಮುತ್ಥಾಯ ತಾನ್ ಸಿಷೇವೇ| ");
INSERT INTO sankan_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","ಅನನ್ತರಂ ಸನ್ಧ್ಯಾಯಾಂ ಸತ್ಯಾಂ ಬಹುಶೋ ಭೂತಗ್ರಸ್ತಮನುಜಾನ್ ತಸ್ಯ ಸಮೀಪಮ್ ಆನಿನ್ಯುಃ ಸ ಚ ವಾಕ್ಯೇನ ಭೂತಾನ್ ತ್ಯಾಜಯಾಮಾಸ, ಸರ್ವ್ವಪ್ರಕಾರಪೀಡಿತಜನಾಂಶ್ಚ ನಿರಾಮಯಾನ್ ಚಕಾರ; ");
INSERT INTO sankan_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ತಸ್ಮಾತ್, ಸರ್ವ್ವಾ ದುರ್ಬ್ಬಲತಾಸ್ಮಾಕಂ ತೇನೈವ ಪರಿಧಾರಿತಾ| ಅಸ್ಮಾಕಂ ಸಕಲಂ ವ್ಯಾಧಿಂ ಸಏವ ಸಂಗೃಹೀತವಾನ್| ಯದೇತದ್ವಚನಂ ಯಿಶಯಿಯಭವಿಷ್ಯದ್ವಾದಿನೋಕ್ತಮಾಸೀತ್, ತತ್ತದಾ ಸಫಲಮಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","ಅನನ್ತರಂ ಯೀಶುಶ್ಚತುರ್ದಿಕ್ಷು ಜನನಿವಹಂ ವಿಲೋಕ್ಯ ತಟಿನ್ಯಾಃ ಪಾರಂ ಯಾತುಂ ಶಿಷ್ಯಾನ್ ಆದಿದೇಶ| ");
INSERT INTO sankan_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ತದಾನೀಮ್ ಏಕ ಉಪಾಧ್ಯಾಯ ಆಗತ್ಯ ಕಥಿತವಾನ್, ಹೇ ಗುರೋ, ಭವಾನ್ ಯತ್ರ ಯಾಸ್ಯತಿ ತತ್ರಾಹಮಪಿ ಭವತಃ ಪಶ್ಚಾದ್ ಯಾಸ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ತತೋ ಯೀಶು ರ್ಜಗಾದ, ಕ್ರೋಷ್ಟುಃ ಸ್ಥಾತುಂ ಸ್ಥಾನಂ ವಿದ್ಯತೇ, ವಿಹಾಯಸೋ ವಿಹಙ್ಗಮಾನಾಂ ನೀಡಾನಿ ಚ ಸನ್ತಿ; ಕಿನ್ತು ಮನುಷ್ಯಪುತ್ರಸ್ಯ ಶಿರಃ ಸ್ಥಾಪಯಿತುಂ ಸ್ಥಾನಂ ನ ವಿದ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","ಅನನ್ತರಮ್ ಅಪರ ಏಕಃ ಶಿಷ್ಯಸ್ತಂ ಬಭಾಷೇ, ಹೇ ಪ್ರಭೋ, ಪ್ರಥಮತೋ ಮಮ ಪಿತರಂ ಶ್ಮಶಾನೇ ನಿಧಾತುಂ ಗಮನಾರ್ಥಂ ಮಾಮ್ ಅನುಮನ್ಯಸ್ವ| ");
INSERT INTO sankan_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ತತೋ ಯೀಶುರುಕ್ತವಾನ್ ಮೃತಾ ಮೃತಾನ್ ಶ್ಮಶಾನೇ ನಿದಧತು, ತ್ವಂ ಮಮ ಪಶ್ಚಾದ್ ಆಗಚ್ಛ| ");
INSERT INTO sankan_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","ಅನನ್ತರಂ ತಸ್ಮಿನ್ ನಾವಮಾರೂಢೇ ತಸ್ಯ ಶಿಷ್ಯಾಸ್ತತ್ಪಶ್ಚಾತ್ ಜಗ್ಮುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ಪಶ್ಚಾತ್ ಸಾಗರಸ್ಯ ಮಧ್ಯಂ ತೇಷು ಗತೇಷು ತಾದೃಶಃ ಪ್ರಬಲೋ ಝಞ್ಭ್ಶನಿಲ ಉದತಿಷ್ಠತ್, ಯೇನ ಮಹಾತರಙ್ಗ ಉತ್ಥಾಯ ತರಣಿಂ ಛಾದಿತವಾನ್, ಕಿನ್ತು ಸ ನಿದ್ರಿತ ಆಸೀತ್| ");
INSERT INTO sankan_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ತದಾ ಶಿಷ್ಯಾ ಆಗತ್ಯ ತಸ್ಯ ನಿದ್ರಾಭಙ್ಗಂ ಕೃತ್ವಾ ಕಥಯಾಮಾಸುಃ, ಹೇ ಪ್ರಭೋ, ವಯಂ ಮ್ರಿಯಾಮಹೇ, ಭವಾನ್ ಅಸ್ಮಾಕಂ ಪ್ರಾಣಾನ್ ರಕ್ಷತು| ");
INSERT INTO sankan_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ತದಾ ಸ ತಾನ್ ಉಕ್ತವಾನ್, ಹೇ ಅಲ್ಪವಿಶ್ವಾಸಿನೋ ಯೂಯಂ ಕುತೋ ವಿಭೀಥ? ತತಃ ಸ ಉತ್ಥಾಯ ವಾತಂ ಸಾಗರಞ್ಚ ತರ್ಜಯಾಮಾಸ, ತತೋ ನಿರ್ವ್ವಾತಮಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","ಅಪರಂ ಮನುಜಾ ವಿಸ್ಮಯಂ ವಿಲೋಕ್ಯ ಕಥಯಾಮಾಸುಃ, ಅಹೋ ವಾತಸರಿತ್ಪತೀ ಅಸ್ಯ ಕಿಮಾಜ್ಞಾಗ್ರಾಹಿಣೌ? ಕೀದೃಶೋಽಯಂ ಮಾನವಃ| ");
INSERT INTO sankan_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","ಅನನ್ತರಂ ಸ ಪಾರಂ ಗತ್ವಾ ಗಿದೇರೀಯದೇಶಮ್ ಉಪಸ್ಥಿತವಾನ್; ತದಾ ದ್ವೌ ಭೂತಗ್ರಸ್ತಮನುಜೌ ಶ್ಮಶಾನಸ್ಥಾನಾದ್ ಬಹಿ ರ್ಭೂತ್ವಾ ತಂ ಸಾಕ್ಷಾತ್ ಕೃತವನ್ತೌ, ತಾವೇತಾದೃಶೌ ಪ್ರಚಣ್ಡಾವಾಸ್ತಾಂ ಯತ್ ತೇನ ಸ್ಥಾನೇನ ಕೋಪಿ ಯಾತುಂ ನಾಶಕ್ನೋತ್| ");
INSERT INTO sankan_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ತಾವುಚೈಃ ಕಥಯಾಮಾಸತುಃ, ಹೇ ಈಶ್ವರಸ್ಯ ಸೂನೋ ಯೀಶೋ, ತ್ವಯಾ ಸಾಕಮ್ ಆವಯೋಃ ಕಃ ಸಮ್ಬನ್ಧಃ? ನಿರೂಪಿತಕಾಲಾತ್ ಪ್ರಾಗೇವ ಕಿಮಾವಾಭ್ಯಾಂ ಯಾತನಾಂ ದಾತುಮ್ ಅತ್ರಾಗತೋಸಿ? ");
INSERT INTO sankan_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ತದಾನೀಂ ತಾಭ್ಯಾಂ ಕಿಞ್ಚಿದ್ ದೂರೇ ವರಾಹಾಣಾಮ್ ಏಕೋ ಮಹಾವ್ರಜೋಽಚರತ್| ");
INSERT INTO sankan_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ತತೋ ಭೂತೌ ತೌ ತಸ್ಯಾನ್ತಿಕೇ ವಿನೀಯ ಕಥಯಾಮಾಸತುಃ, ಯದ್ಯಾವಾಂ ತ್ಯಾಜಯಸಿ, ತರ್ಹಿ ವರಾಹಾಣಾಂ ಮಧ್ಯೇವ್ರಜಮ್ ಆವಾಂ ಪ್ರೇರಯ| ");
INSERT INTO sankan_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ತದಾ ಯೀಶುರವದತ್ ಯಾತಂ, ಅನನ್ತರಂ ತೌ ಯದಾ ಮನುಜೌ ವಿಹಾಯ ವರಾಹಾನ್ ಆಶ್ರಿತವನ್ತೌ, ತದಾ ತೇ ಸರ್ವ್ವೇ ವರಾಹಾ ಉಚ್ಚಸ್ಥಾನಾತ್ ಮಹಾಜವೇನ ಧಾವನ್ತಃ ಸಾಗರೀಯತೋಯೇ ಮಜ್ಜನ್ತೋ ಮಮ್ರುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ತತೋ ವರಾಹರಕ್ಷಕಾಃ ಪಲಾಯಮಾನಾ ಮಧ್ಯೇನಗರಂ ತೌ ಭೂತಗ್ರಸ್ತೌ ಪ್ರತಿ ಯದ್ಯದ್ ಅಘಟತ, ತಾಃ ಸರ್ವ್ವವಾರ್ತ್ತಾ ಅವದನ್| ");
INSERT INTO sankan_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ತತೋ ನಾಗರಿಕಾಃ ಸರ್ವ್ವೇ ಮನುಜಾ ಯೀಶುಂ ಸಾಕ್ಷಾತ್ ಕರ್ತ್ತುಂ ಬಹಿರಾಯಾತಾಃ ತಞ್ಚ ವಿಲೋಕ್ಯ ಪ್ರಾರ್ಥಯಾಞ್ಚಕ್ರಿರೇ ಭವಾನ್ ಅಸ್ಮಾಕಂ ಸೀಮಾತೋ ಯಾತು| ");
INSERT INTO sankan_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ಅನನ್ತರಂ ಯೀಶು ರ್ನೌಕಾಮಾರುಹ್ಯ ಪುನಃ ಪಾರಮಾಗತ್ಯ ನಿಜಗ್ರಾಮಮ್ ಆಯಯೌ| ");
INSERT INTO sankan_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ತತಃ ಕತಿಪಯಾ ಜನಾ ಏಕಂ ಪಕ್ಷಾಘಾತಿನಂ ಸ್ವಟ್ಟೋಪರಿ ಶಾಯಯಿತ್ವಾ ತತ್ಸಮೀಪಮ್ ಆನಯನ್; ತತೋ ಯೀಶುಸ್ತೇಷಾಂ ಪ್ರತೀತಿಂ ವಿಜ್ಞಾಯ ತಂ ಪಕ್ಷಾಘಾತಿನಂ ಜಗಾದ, ಹೇ ಪುತ್ರ, ಸುಸ್ಥಿರೋ ಭವ, ತವ ಕಲುಷಸ್ಯ ಮರ್ಷಣಂ ಜಾತಮ್| ");
INSERT INTO sankan_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ತಾಂ ಕಥಾಂ ನಿಶಮ್ಯ ಕಿಯನ್ತ ಉಪಾಧ್ಯಾಯಾ ಮನಃಸು ಚಿನ್ತಿತವನ್ತ ಏಷ ಮನುಜ ಈಶ್ವರಂ ನಿನ್ದತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ತತಃ ಸ ತೇಷಾಮ್ ಏತಾದೃಶೀಂ ಚಿನ್ತಾಂ ವಿಜ್ಞಾಯ ಕಥಿತವಾನ್, ಯೂಯಂ ಮನಃಸು ಕೃತ ಏತಾದೃಶೀಂ ಕುಚಿನ್ತಾಂ ಕುರುಥ? ");
INSERT INTO sankan_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","ತವ ಪಾಪಮರ್ಷಣಂ ಜಾತಂ, ಯದ್ವಾ ತ್ವಮುತ್ಥಾಯ ಗಚ್ಛ, ದ್ವಯೋರನಯೋ ರ್ವಾಕ್ಯಯೋಃ ಕಿಂ ವಾಕ್ಯಂ ವಕ್ತುಂ ಸುಗಮಂ? ");
INSERT INTO sankan_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","ಕಿನ್ತು ಮೇದಿನ್ಯಾಂ ಕಲುಷಂ ಕ್ಷಮಿತುಂ ಮನುಜಸುತಸ್ಯ ಸಾಮರ್ಥ್ಯಮಸ್ತೀತಿ ಯೂಯಂ ಯಥಾ ಜಾನೀಥ, ತದರ್ಥಂ ಸ ತಂ ಪಕ್ಷಾಘಾತಿನಂ ಗದಿತವಾನ್, ಉತ್ತಿಷ್ಠ, ನಿಜಶಯನೀಯಂ ಆದಾಯ ಗೇಹಂ ಗಚ್ಛ| ");
INSERT INTO sankan_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ತತಃ ಸ ತತ್ಕ್ಷಣಾದ್ ಉತ್ಥಾಯ ನಿಜಗೇಹಂ ಪ್ರಸ್ಥಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ಮಾನವಾ ಇತ್ಥಂ ವಿಲೋಕ್ಯ ವಿಸ್ಮಯಂ ಮೇನಿರೇ, ಈಶ್ವರೇಣ ಮಾನವಾಯ ಸಾಮರ್ಥ್ಯಮ್ ಈದೃಶಂ ದತ್ತಂ ಇತಿ ಕಾರಣಾತ್ ತಂ ಧನ್ಯಂ ಬಭಾಷಿರೇ ಚ| ");
INSERT INTO sankan_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ಅನನ್ತರಂ ಯೀಶುಸ್ತತ್ಸ್ಥಾನಾದ್ ಗಚ್ಛನ್ ಗಚ್ಛನ್ ಕರಸಂಗ್ರಹಸ್ಥಾನೇ ಸಮುಪವಿಷ್ಟಂ ಮಥಿನಾಮಾನಮ್ ಏಕಂ ಮನುಜಂ ವಿಲೋಕ್ಯ ತಂ ಬಭಾಷೇ, ಮಮ ಪಶ್ಚಾದ್ ಆಗಚ್ಛ, ತತಃ ಸ ಉತ್ಥಾಯ ತಸ್ಯ ಪಶ್ಚಾದ್ ವವ್ರಾಜ| ");
INSERT INTO sankan_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ತತಃ ಪರಂ ಯೀಶೌ ಗೃಹೇ ಭೋಕ್ತುಮ್ ಉಪವಿಷ್ಟೇ ಬಹವಃ ಕರಸಂಗ್ರಾಹಿಣಃ ಕಲುಷಿಣಶ್ಚ ಮಾನವಾ ಆಗತ್ಯ ತೇನ ಸಾಕಂ ತಸ್ಯ ಶಿಷ್ಯೈಶ್ಚ ಸಾಕಮ್ ಉಪವಿವಿಶುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ಫಿರೂಶಿನಸ್ತದ್ ದೃಷ್ಟ್ವಾ ತಸ್ಯ ಶಿಷ್ಯಾನ್ ಬಭಾಷಿರೇ, ಯುಷ್ಮಾಕಂ ಗುರುಃ ಕಿಂ ನಿಮಿತ್ತಂ ಕರಸಂಗ್ರಾಹಿಭಿಃ ಕಲುಷಿಭಿಶ್ಚ ಸಾಕಂ ಭುಂಕ್ತೇ? ");
INSERT INTO sankan_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ಯೀಶುಸ್ತತ್ ಶ್ರುತ್ವಾ ತಾನ್ ಪ್ರತ್ಯವದತ್, ನಿರಾಮಯಲೋಕಾನಾಂ ಚಿಕಿತ್ಸಕೇನ ಪ್ರಯೋಜನಂ ನಾಸ್ತಿ, ಕಿನ್ತು ಸಾಮಯಲೋಕಾನಾಂ ಪ್ರಯೋಜನಮಾಸ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","ಅತೋ ಯೂಯಂ ಯಾತ್ವಾ ವಚನಸ್ಯಾಸ್ಯಾರ್ಥಂ ಶಿಕ್ಷಧ್ವಮ್, ದಯಾಯಾಂ ಮೇ ಯಥಾ ಪ್ರೀತಿ ರ್ನ ತಥಾ ಯಜ್ಞಕರ್ಮ್ಮಣಿ| ಯತೋಽಹಂ ಧಾರ್ಮ್ಮಿಕಾನ್ ಆಹ್ವಾತುಂ ನಾಗತೋಽಸ್ಮಿ ಕಿನ್ತು ಮನಃ ಪರಿವರ್ತ್ತಯಿತುಂ ಪಾಪಿನ ಆಹ್ವಾತುಮ್ ಆಗತೋಽಸ್ಮಿ| ");
INSERT INTO sankan_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","ಅನನ್ತರಂ ಯೋಹನಃ ಶಿಷ್ಯಾಸ್ತಸ್ಯ ಸಮೀಪಮ್ ಆಗತ್ಯ ಕಥಯಾಮಾಸುಃ, ಫಿರೂಶಿನೋ ವಯಞ್ಚ ಪುನಃ ಪುನರುಪವಸಾಮಃ, ಕಿನ್ತು ತವ ಶಿಷ್ಯಾ ನೋಪವಸನ್ತಿ, ಕುತಃ? ");
INSERT INTO sankan_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ತದಾ ಯೀಶುಸ್ತಾನ್ ಅವೋಚತ್ ಯಾವತ್ ಸಖೀನಾಂ ಸಂಙ್ಗೇ ಕನ್ಯಾಯಾ ವರಸ್ತಿಷ್ಠತಿ, ತಾವತ್ ಕಿಂ ತೇ ವಿಲಾಪಂ ಕರ್ತ್ತುಂ ಶಕ್ಲುವನ್ತಿ? ಕಿನ್ತು ಯದಾ ತೇಷಾಂ ಸಂಙ್ಗಾದ್ ವರಂ ನಯನ್ತಿ, ತಾದೃಶಃ ಸಮಯ ಆಗಮಿಷ್ಯತಿ, ತದಾ ತೇ ಉಪವತ್ಸ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","ಪುರಾತನವಸನೇ ಕೋಪಿ ನವೀನವಸ್ತ್ರಂ ನ ಯೋಜಯತಿ, ಯಸ್ಮಾತ್ ತೇನ ಯೋಜಿತೇನ ಪುರಾತನವಸನಂ ಛಿನತ್ತಿ ತಚ್ಛಿದ್ರಞ್ಚ ಬಹುಕುತ್ಸಿತಂ ದೃಶ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ಅನ್ಯಞ್ಚ ಪುರಾತನಕುತ್ವಾಂ ಕೋಪಿ ನವಾನಗೋಸ್ತನೀರಸಂ ನ ನಿದಧಾತಿ, ಯಸ್ಮಾತ್ ತಥಾ ಕೃತೇ ಕುತೂ ರ್ವಿದೀರ್ಯ್ಯತೇ ತೇನ ಗೋಸ್ತನೀರಸಃ ಪತತಿ ಕುತೂಶ್ಚ ನಶ್ಯತಿ; ತಸ್ಮಾತ್ ನವೀನಾಯಾಂ ಕುತ್ವಾಂ ನವೀನೋ ಗೋಸ್ತನೀರಸಃ ಸ್ಥಾಪ್ಯತೇ, ತೇನ ದ್ವಯೋರವನಂ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","ಅಪರಂ ತೇನೈತತ್ಕಥಾಕಥನಕಾಲೇ ಏಕೋಽಧಿಪತಿಸ್ತಂ ಪ್ರಣಮ್ಯ ಬಭಾಷೇ, ಮಮ ದುಹಿತಾ ಪ್ರಾಯೇಣೈತಾವತ್ಕಾಲೇ ಮೃತಾ, ತಸ್ಮಾದ್ ಭವಾನಾಗತ್ಯ ತಸ್ಯಾ ಗಾತ್ರೇ ಹಸ್ತಮರ್ಪಯತು, ತೇನ ಸಾ ಜೀವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ತದಾನೀಂ ಯೀಶುಃ ಶಿಷ್ಯೈಃ ಸಾಕಮ್ ಉತ್ಥಾಯ ತಸ್ಯ ಪಶ್ಚಾದ್ ವವ್ರಾಜ| ");
INSERT INTO sankan_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ಇತ್ಯನನ್ತರೇ ದ್ವಾದಶವತ್ಸರಾನ್ ಯಾವತ್ ಪ್ರದರಾಮಯೇನ ಶೀರ್ಣೈಕಾ ನಾರೀ ತಸ್ಯ ಪಶ್ಚಾದ್ ಆಗತ್ಯ ತಸ್ಯ ವಸನಸ್ಯ ಗ್ರನ್ಥಿಂ ಪಸ್ಪರ್ಶ; ");
INSERT INTO sankan_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ಯಸ್ಮಾತ್ ಮಯಾ ಕೇವಲಂ ತಸ್ಯ ವಸನಂ ಸ್ಪೃಷ್ಟ್ವಾ ಸ್ವಾಸ್ಥ್ಯಂ ಪ್ರಾಪ್ಸ್ಯತೇ, ಸಾ ನಾರೀತಿ ಮನಸಿ ನಿಶ್ಚಿತವತೀ| ");
INSERT INTO sankan_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ತತೋ ಯೀಶುರ್ವದನಂ ಪರಾವರ್ತ್ತ್ಯ ತಾಂ ಜಗಾದ, ಹೇ ಕನ್ಯೇ, ತ್ವಂ ಸುಸ್ಥಿರಾ ಭವ, ತವ ವಿಶ್ವಾಸಸ್ತ್ವಾಂ ಸ್ವಸ್ಥಾಮಕಾರ್ಷೀತ್| ಏತದ್ವಾಕ್ಯೇ ಗದಿತಏವ ಸಾ ಯೋಷಿತ್ ಸ್ವಸ್ಥಾಭೂತ್| ");
INSERT INTO sankan_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","ಅಪರಂ ಯೀಶುಸ್ತಸ್ಯಾಧ್ಯಕ್ಷಸ್ಯ ಗೇಹಂ ಗತ್ವಾ ವಾದಕಪ್ರಭೃತೀನ್ ಬಹೂನ್ ಲೋಕಾನ್ ಶಬ್ದಾಯಮಾನಾನ್ ವಿಲೋಕ್ಯ ತಾನ್ ಅವದತ್, ");
INSERT INTO sankan_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ಪನ್ಥಾನಂ ತ್ಯಜ, ಕನ್ಯೇಯಂ ನಾಮ್ರಿಯತ ನಿದ್ರಿತಾಸ್ತೇ; ಕಥಾಮೇತಾಂ ಶ್ರುತ್ವಾ ತೇ ತಮುಪಜಹಸುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","ಕಿನ್ತು ಸರ್ವ್ವೇಷು ಬಹಿಷ್ಕೃತೇಷು ಸೋಽಭ್ಯನ್ತರಂ ಗತ್ವಾ ಕನ್ಯಾಯಾಃ ಕರಂ ಧೃತವಾನ್, ತೇನ ಸೋದತಿಷ್ಠತ್; ");
INSERT INTO sankan_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ತತಸ್ತತ್ಕರ್ಮ್ಮಣೋ ಯಶಃ ಕೃತ್ಸ್ನಂ ತಂ ದೇಶಂ ವ್ಯಾಪ್ತವತ್| ");
INSERT INTO sankan_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","ತತಃ ಪರಂ ಯೀಶುಸ್ತಸ್ಮಾತ್ ಸ್ಥಾನಾದ್ ಯಾತ್ರಾಂ ಚಕಾರ; ತದಾ ಹೇ ದಾಯೂದಃ ಸನ್ತಾನ, ಅಸ್ಮಾನ್ ದಯಸ್ವ, ಇತಿ ವದನ್ತೌ ದ್ವೌ ಜನಾವನ್ಧೌ ಪ್ರೋಚೈರಾಹೂಯನ್ತೌ ತತ್ಪಶ್ಚಾದ್ ವವ್ರಜತುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ತತೋ ಯೀಶೌ ಗೇಹಮಧ್ಯಂ ಪ್ರವಿಷ್ಟಂ ತಾವಪಿ ತಸ್ಯ ಸಮೀಪಮ್ ಉಪಸ್ಥಿತವನ್ತೌ, ತದಾನೀಂ ಸ ತೌ ಪೃಷ್ಟವಾನ್ ಕರ್ಮ್ಮೈತತ್ ಕರ್ತ್ತುಂ ಮಮ ಸಾಮರ್ಥ್ಯಮ್ ಆಸ್ತೇ, ಯುವಾಂ ಕಿಮಿತಿ ಪ್ರತೀಥಃ? ತದಾ ತೌ ಪ್ರತ್ಯೂಚತುಃ, ಸತ್ಯಂ ಪ್ರಭೋ| ");
INSERT INTO sankan_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","ತದಾನೀಂ ಸ ತಯೋ ರ್ಲೋಚನಾನಿ ಸ್ಪೃಶನ್ ಬಭಾಷೇ, ಯುವಯೋಃ ಪ್ರತೀತ್ಯನುಸಾರಾದ್ ಯುವಯೋ ರ್ಮಙ್ಗಲಂ ಭೂಯಾತ್| ತೇನ ತತ್ಕ್ಷಣಾತ್ ತಯೋ ರ್ನೇತ್ರಾಣಿ ಪ್ರಸನ್ನಾನ್ಯಭವನ್, ");
INSERT INTO sankan_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ಪಶ್ಚಾದ್ ಯೀಶುಸ್ತೌ ದೃಢಮಾಜ್ಞಾಪ್ಯ ಜಗಾದ, ಅವಧತ್ತಮ್ ಏತಾಂ ಕಥಾಂ ಕೋಪಿ ಮನುಜೋ ಮ ಜಾನೀಯಾತ್| ");
INSERT INTO sankan_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","ಕಿನ್ತು ತೌ ಪ್ರಸ್ಥಾಯ ತಸ್ಮಿನ್ ಕೃತ್ಸ್ನೇ ದೇಶೇ ತಸ್ಯ ಕೀರ್ತ್ತಿಂ ಪ್ರಕಾಶಯಾಮಾಸತುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ಅಪರಂ ತೌ ಬಹಿರ್ಯಾತ ಏತಸ್ಮಿನ್ನನ್ತರೇ ಮನುಜಾ ಏಕಂ ಭೂತಗ್ರಸ್ತಮೂಕಂ ತಸ್ಯ ಸಮೀಪಮ್ ಆನೀತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ತೇನ ಭೂತೇ ತ್ಯಾಜಿತೇ ಸ ಮೂಕಃ ಕಥಾಂ ಕಥಯಿತುಂ ಪ್ರಾರಭತ, ತೇನ ಜನಾ ವಿಸ್ಮಯಂ ವಿಜ್ಞಾಯ ಕಥಯಾಮಾಸುಃ, ಇಸ್ರಾಯೇಲೋ ವಂಶೇ ಕದಾಪಿ ನೇದೃಗದೃಶ್ಯತ; ");
INSERT INTO sankan_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","ಕಿನ್ತು ಫಿರೂಶಿನಃ ಕಥಯಾಞ್ಚಕ್ರುಃ ಭೂತಾಧಿಪತಿನಾ ಸ ಭೂತಾನ್ ತ್ಯಾಜಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ತತಃ ಪರಂ ಯೀಶುಸ್ತೇಷಾಂ ಭಜನಭವನ ಉಪದಿಶನ್ ರಾಜ್ಯಸ್ಯ ಸುಸಂವಾದಂ ಪ್ರಚಾರಯನ್ ಲೋಕಾನಾಂ ಯಸ್ಯ ಯ ಆಮಯೋ ಯಾ ಚ ಪೀಡಾಸೀತ್, ತಾನ್ ಶಮಯನ್ ಶಮಯಂಶ್ಚ ಸರ್ವ್ವಾಣಿ ನಗರಾಣಿ ಗ್ರಾಮಾಂಶ್ಚ ಬಭ್ರಾಮ| ");
INSERT INTO sankan_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ಅನ್ಯಞ್ಚ ಮನುಜಾನ್ ವ್ಯಾಕುಲಾನ್ ಅರಕ್ಷಕಮೇಷಾನಿವ ಚ ತ್ಯಕ್ತಾನ್ ನಿರೀಕ್ಷ್ಯ ತೇಷು ಕಾರುಣಿಕಃ ಸನ್ ಶಿಷ್ಯಾನ್ ಅವದತ್, ");
INSERT INTO sankan_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ಶಸ್ಯಾನಿ ಪ್ರಚುರಾಣಿ ಸನ್ತಿ, ಕಿನ್ತು ಛೇತ್ತಾರಃ ಸ್ತೋಕಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ಕ್ಷೇತ್ರಂ ಪ್ರತ್ಯಪರಾನ್ ಛೇದಕಾನ್ ಪ್ರಹೇತುಂ ಶಸ್ಯಸ್ವಾಮಿನಂ ಪ್ರಾರ್ಥಯಧ್ವಮ್| ");
INSERT INTO sankan_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","ಅನನ್ತರಂ ಯೀಶು ರ್ದ್ವಾದಶಶಿಷ್ಯಾನ್ ಆಹೂಯಾಮೇಧ್ಯಭೂತಾನ್ ತ್ಯಾಜಯಿತುಂ ಸರ್ವ್ವಪ್ರಕಾರರೋಗಾನ್ ಪೀಡಾಶ್ಚ ಶಮಯಿತುಂ ತೇಭ್ಯಃ ಸಾಮರ್ಥ್ಯಮದಾತ್| ");
INSERT INTO sankan_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","ತೇಷಾಂ ದ್ವಾದಶಪ್ರೇಷ್ಯಾಣಾಂ ನಾಮಾನ್ಯೇತಾನಿ| ಪ್ರಥಮಂ ಶಿಮೋನ್ ಯಂ ಪಿತರಂ ವದನ್ತಿ, ತತಃ ಪರಂ ತಸ್ಯ ಸಹಜ ಆನ್ದ್ರಿಯಃ, ಸಿವದಿಯಸ್ಯ ಪುತ್ರೋ ಯಾಕೂಬ್ ");
INSERT INTO sankan_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ತಸ್ಯ ಸಹಜೋ ಯೋಹನ್; ಫಿಲಿಪ್ ಬರ್ಥಲಮಯ್ ಥೋಮಾಃ ಕರಸಂಗ್ರಾಹೀ ಮಥಿಃ, ಆಲ್ಫೇಯಪುತ್ರೋ ಯಾಕೂಬ್, ");
INSERT INTO sankan_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ಕಿನಾನೀಯಃ ಶಿಮೋನ್, ಯ ಈಷ್ಕರಿಯೋತೀಯಯಿಹೂದಾಃ ಖ್ರೀಷ್ಟಂ ಪರಕರೇಽರ್ಪಯತ್| ");
INSERT INTO sankan_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ಏತಾನ್ ದ್ವಾದಶಶಿಷ್ಯಾನ್ ಯೀಶುಃ ಪ್ರೇಷಯನ್ ಇತ್ಯಾಜ್ಞಾಪಯತ್, ಯೂಯಮ್ ಅನ್ಯದೇಶೀಯಾನಾಂ ಪದವೀಂ ಶೇಮಿರೋಣೀಯಾನಾಂ ಕಿಮಪಿ ನಗರಞ್ಚ ನ ಪ್ರವಿಶ್ಯೇ ");
INSERT INTO sankan_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ಇಸ್ರಾಯೇಲ್ಗೋತ್ರಸ್ಯ ಹಾರಿತಾ ಯೇ ಯೇ ಮೇಷಾಸ್ತೇಷಾಮೇವ ಸಮೀಪಂ ಯಾತ| ");
INSERT INTO sankan_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","ಗತ್ವಾ ಗತ್ವಾ ಸ್ವರ್ಗಸ್ಯ ರಾಜತ್ವಂ ಸವಿಧಮಭವತ್, ಏತಾಂ ಕಥಾಂ ಪ್ರಚಾರಯತ| ");
INSERT INTO sankan_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ಆಮಯಗ್ರಸ್ತಾನ್ ಸ್ವಸ್ಥಾನ್ ಕುರುತ, ಕುಷ್ಠಿನಃ ಪರಿಷ್ಕುರುತ, ಮೃತಲೋಕಾನ್ ಜೀವಯತ, ಭೂತಾನ್ ತ್ಯಾಜಯತ, ವಿನಾ ಮೂಲ್ಯಂ ಯೂಯಮ್ ಅಲಭಧ್ವಂ ವಿನೈವ ಮೂಲ್ಯಂ ವಿಶ್ರಾಣಯತ| ");
INSERT INTO sankan_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","ಕಿನ್ತು ಸ್ವೇಷಾಂ ಕಟಿಬನ್ಧೇಷು ಸ್ವರ್ಣರೂಪ್ಯತಾಮ್ರಾಣಾಂ ಕಿಮಪಿ ನ ಗೃಹ್ಲೀತ| ");
INSERT INTO sankan_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ಅನ್ಯಚ್ಚ ಯಾತ್ರಾಯೈ ಚೇಲಸಮ್ಪುಟಂ ವಾ ದ್ವಿತೀಯವಸನಂ ವಾ ಪಾದುಕೇ ವಾ ಯಷ್ಟಿಃ, ಏತಾನ್ ಮಾ ಗೃಹ್ಲೀತ, ಯತಃ ಕಾರ್ಯ್ಯಕೃತ್ ಭರ್ತ್ತುಂ ಯೋಗ್ಯೋ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","ಅಪರಂ ಯೂಯಂ ಯತ್ ಪುರಂ ಯಞ್ಚ ಗ್ರಾಮಂ ಪ್ರವಿಶಥ, ತತ್ರ ಯೋ ಜನೋ ಯೋಗ್ಯಪಾತ್ರಂ ತಮವಗತ್ಯ ಯಾನಕಾಲಂ ಯಾವತ್ ತತ್ರ ತಿಷ್ಠತ| ");
INSERT INTO sankan_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ಯದಾ ಯೂಯಂ ತದ್ಗೇಹಂ ಪ್ರವಿಶಥ, ತದಾ ತಮಾಶಿಷಂ ವದತ| ");
INSERT INTO sankan_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ಯದಿ ಸ ಯೋಗ್ಯಪಾತ್ರಂ ಭವತಿ, ತರ್ಹಿ ತತ್ಕಲ್ಯಾಣಂ ತಸ್ಮೈ ಭವಿಷ್ಯತಿ, ನೋಚೇತ್ ಸಾಶೀರ್ಯುಷ್ಮಭ್ಯಮೇವ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ಕಿನ್ತು ಯೇ ಜನಾ ಯುಷ್ಮಾಕಮಾತಿಥ್ಯಂ ನ ವಿದಧತಿ ಯುಷ್ಮಾಕಂ ಕಥಾಞ್ಚ ನ ಶೃಣ್ವನ್ತಿ ತೇಷಾಂ ಗೇಹಾತ್ ಪುರಾದ್ವಾ ಪ್ರಸ್ಥಾನಕಾಲೇ ಸ್ವಪದೂಲೀಃ ಪಾತಯತ| ");
INSERT INTO sankan_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","ಯುಷ್ಮಾನಹಂ ತಥ್ಯಂ ವಚ್ಮಿ ವಿಚಾರದಿನೇ ತತ್ಪುರಸ್ಯ ದಶಾತಃ ಸಿದೋಮಮೋರಾಪುರಯೋರ್ದಶಾ ಸಹ್ಯತರಾ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","ಪಶ್ಯತ, ವೃಕಯೂಥಮಧ್ಯೇ ಮೇಷಃ ಯಥಾವಿಸ್ತಥಾ ಯುಷ್ಮಾನ ಪ್ರಹಿಣೋಮಿ, ತಸ್ಮಾದ್ ಯೂಯಮ್ ಅಹಿರಿವ ಸತರ್ಕಾಃ ಕಪೋತಾಇವಾಹಿಂಸಕಾ ಭವತ| ");
INSERT INTO sankan_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","ನೃಭ್ಯಃ ಸಾವಧಾನಾ ಭವತ; ಯತಸ್ತೈ ರ್ಯೂಯಂ ರಾಜಸಂಸದಿ ಸಮರ್ಪಿಷ್ಯಧ್ವೇ ತೇಷಾಂ ಭಜನಗೇಹೇ ಪ್ರಹಾರಿಷ್ಯಧ್ವೇ| ");
INSERT INTO sankan_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ಯೂಯಂ ಮನ್ನಾಮಹೇತೋಃ ಶಾಸ್ತೃಣಾಂ ರಾಜ್ಞಾಞ್ಚ ಸಮಕ್ಷಂ ತಾನನ್ಯದೇಶಿನಶ್ಚಾಧಿ ಸಾಕ್ಷಿತ್ವಾರ್ಥಮಾನೇಷ್ಯಧ್ವೇ| ");
INSERT INTO sankan_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","ಕಿನ್ತ್ವಿತ್ಥಂ ಸಮರ್ಪಿತಾ ಯೂಯಂ ಕಥಂ ಕಿಮುತ್ತರಂ ವಕ್ಷ್ಯಥ ತತ್ರ ಮಾ ಚಿನ್ತಯತ, ಯತಸ್ತದಾ ಯುಷ್ಮಾಭಿ ರ್ಯದ್ ವಕ್ತವ್ಯಂ ತತ್ ತದ್ದಣ್ಡೇ ಯುಷ್ಮನ್ಮನಃ ಸು ಸಮುಪಸ್ಥಾಸ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ಯಸ್ಮಾತ್ ತದಾ ಯೋ ವಕ್ಷ್ಯತಿ ಸ ನ ಯೂಯಂ ಕಿನ್ತು ಯುಷ್ಮಾಕಮನ್ತರಸ್ಥಃ ಪಿತ್ರಾತ್ಮಾ| ");
INSERT INTO sankan_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","ಸಹಜಃ ಸಹಜಂ ತಾತಃ ಸುತಞ್ಚ ಮೃತೌ ಸಮರ್ಪಯಿಷ್ಯತಿ, ಅಪತ್ಯಾಗಿ ಸ್ವಸ್ವಪಿತ್ರೋे ರ್ವಿಪಕ್ಷೀಭೂಯ ತೌ ಘಾತಯಿಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","ಮನ್ನಮಹೇತೋಃ ಸರ್ವ್ವೇ ಜನಾ ಯುಷ್ಮಾನ್ ಋृತೀಯಿಷ್ಯನ್ತೇ, ಕಿನ್ತು ಯಃ ಶೇಷಂ ಯಾವದ್ ಧೈರ್ಯ್ಯಂ ಘೃತ್ವಾ ಸ್ಥಾಸ್ಯತಿ, ಸ ತ್ರಾಯಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","ತೈ ರ್ಯದಾ ಯೂಯಮೇಕಪುರೇ ತಾಡಿಷ್ಯಧ್ವೇ, ತದಾ ಯೂಯಮನ್ಯಪುರಂ ಪಲಾಯಧ್ವಂ ಯುಷ್ಮಾನಹಂ ತಥ್ಯಂ ವಚ್ಮಿ ಯಾವನ್ಮನುಜಸುತೋ ನೈತಿ ತಾವದ್ ಇಸ್ರಾಯೇಲ್ದೇಶೀಯಸರ್ವ್ವನಗರಭ್ರಮಣಂ ಸಮಾಪಯಿತುಂ ನ ಶಕ್ಷ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","ಗುರೋಃ ಶಿಷ್ಯೋ ನ ಮಹಾನ್, ಪ್ರಭೋರ್ದಾಸೋ ನ ಮಹಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","ಯದಿ ಶಿಷ್ಯೋ ನಿಜಗುರೋ ರ್ದಾಸಶ್ಚ ಸ್ವಪ್ರಭೋಃ ಸಮಾನೋ ಭವತಿ ತರ್ಹಿ ತದ್ ಯಥೇಷ್ಟಂ| ಚೇತ್ತೈರ್ಗೃಹಪತಿರ್ಭೂತರಾಜ ಉಚ್ಯತೇ, ತರ್ಹಿ ಪರಿವಾರಾಃ ಕಿಂ ತಥಾ ನ ವಕ್ಷ್ಯನ್ತೇ? ");
INSERT INTO sankan_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","ಕಿನ್ತು ತೇಭ್ಯೋ ಯೂಯಂ ಮಾ ಬಿಭೀತ, ಯತೋ ಯನ್ನ ಪ್ರಕಾಶಿಷ್ಯತೇ, ತಾದೃಕ್ ಛಾದಿತಂ ಕಿಮಪಿ ನಾಸ್ತಿ, ಯಚ್ಚ ನ ವ್ಯಞ್ಚಿಷ್ಯತೇ, ತಾದೃಗ್ ಗುಪ್ತಂ ಕಿಮಪಿ ನಾಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ಯದಹಂ ಯುಷ್ಮಾನ್ ತಮಸಿ ವಚ್ಮಿ ತದ್ ಯುಷ್ಮಾಭಿರ್ದೀಪ್ತೌ ಕಥ್ಯತಾಂ; ಕರ್ಣಾಭ್ಯಾಂ ಯತ್ ಶ್ರೂಯತೇ ತದ್ ಗೇಹೋಪರಿ ಪ್ರಚಾರ್ಯ್ಯತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ಯೇ ಕಾಯಂ ಹನ್ತುಂ ಶಕ್ನುವನ್ತಿ ನಾತ್ಮಾನಂ, ತೇಭ್ಯೋ ಮಾ ಭೈಷ್ಟ; ಯಃ ಕಾಯಾತ್ಮಾನೌ ನಿರಯೇ ನಾಶಯಿತುಂ, ಶಕ್ನೋತಿ, ತತೋ ಬಿಭೀತ| ");
INSERT INTO sankan_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ದ್ವೌ ಚಟಕೌ ಕಿಮೇಕತಾಮ್ರಮುದ್ರಯಾ ನ ವಿಕ್ರೀಯೇತೇ? ತಥಾಪಿ ಯುಷ್ಮತ್ತಾತಾನುಮತಿಂ ವಿನಾ ತೇಷಾಮೇಕೋಪಿ ಭುವಿ ನ ಪತತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","ಯುಷ್ಮಚ್ಛಿರಸಾಂ ಸರ್ವ್ವಕಚಾ ಗಣಿತಾಂಃ ಸನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ಅತೋ ಮಾ ಬಿಭೀತ, ಯೂಯಂ ಬಹುಚಟಕೇಭ್ಯೋ ಬಹುಮೂಲ್ಯಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","ಯೋ ಮನುಜಸಾಕ್ಷಾನ್ಮಾಮಙ್ಗೀಕುರುತೇ ತಮಹಂ ಸ್ವರ್ಗಸ್ಥತಾತಸಾಕ್ಷಾದಙ್ಗೀಕರಿಷ್ಯೇ| ");
INSERT INTO sankan_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ಪೃಥ್ವ್ಯಾಮಹಂ ಶಾನ್ತಿಂ ದಾತುಮಾಗತಇತಿ ಮಾನುಭವತ, ಶಾನ್ತಿಂ ದಾತುಂ ನ ಕಿನ್ತ್ವಸಿಂ| ");
INSERT INTO sankan_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","ಪಿತೃಮಾತೃಶ್ಚಶ್ರೂಭಿಃ ಸಾಕಂ ಸುತಸುತಾಬಧೂ ರ್ವಿರೋಧಯಿತುಞ್ಚಾಗತೇाಸ್ಮಿ| ");
INSERT INTO sankan_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ತತಃ ಸ್ವಸ್ವಪರಿವಾರಏವ ನೃಶತ್ರು ರ್ಭವಿತಾ| ");
INSERT INTO sankan_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ಯಃ ಪಿತರಿ ಮಾತರಿ ವಾ ಮತ್ತೋಧಿಕಂ ಪ್ರೀಯತೇ, ಸ ನ ಮದರ್ಹಃ; ");
INSERT INTO sankan_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","ಯಶ್ಚ ಸುತೇ ಸುತಾಯಾಂ ವಾ ಮತ್ತೋಧಿಕಂ ಪ್ರೀಯತೇ, ಸೇाಪಿ ನ ಮದರ್ಹಃ| ");
INSERT INTO sankan_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ಯಃ ಸ್ವಕ್ರುಶಂ ಗೃಹ್ಲನ್ ಮತ್ಪಶ್ಚಾನ್ನೈತಿ, ಸೇाಪಿ ನ ಮದರ್ಹಃ| ");
INSERT INTO sankan_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ಯಃ ಸ್ವಪ್ರಾಣಾನವತಿ, ಸ ತಾನ್ ಹಾರಯಿಷ್ಯತೇ, ಯಸ್ತು ಮತ್ಕೃತೇ ಸ್ವಪ್ರಾಣಾನ್ ಹಾರಯತಿ, ಸ ತಾನವತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","ಯೋ ಯುಷ್ಮಾಕಮಾತಿಥ್ಯಂ ವಿದಧಾತಿ, ಸ ಮಮಾತಿಥ್ಯಂ ವಿದಧಾತಿ, ಯಶ್ಚ ಮಮಾತಿಥ್ಯಂ ವಿದಧಾತಿ, ಸ ಮತ್ಪ್ರೇರಕಸ್ಯಾತಿಥ್ಯಂ ವಿದಧಾತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ಯೋ ಭವಿಷ್ಯದ್ವಾದೀತಿ ಜ್ಞಾತ್ವಾ ತಸ್ಯಾತಿಥ್ಯಂ ವಿಧತ್ತೇ, ಸ ಭವಿಷ್ಯದ್ವಾದಿನಃ ಫಲಂ ಲಪ್ಸ್ಯತೇ, ಯಶ್ಚ ಧಾರ್ಮ್ಮಿಕ ಇತಿ ವಿದಿತ್ವಾ ತಸ್ಯಾತಿಥ್ಯಂ ವಿಧತ್ತೇ ಸ ಧಾರ್ಮ್ಮಿಕಮಾನವಸ್ಯ ಫಲಂ ಪ್ರಾಪ್ಸ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ಯಶ್ಚ ಕಶ್ಚಿತ್ ಏತೇಷಾಂ ಕ್ಷುದ್ರನರಾಣಾಮ್ ಯಂ ಕಞ್ಚನೈಕಂ ಶಿಷ್ಯ ಇತಿ ವಿದಿತ್ವಾ ಕಂಸೈಕಂ ಶೀತಲಸಲಿಲಂ ತಸ್ಮೈ ದತ್ತೇ, ಯುಷ್ಮಾನಹಂ ತಥ್ಯಂ ವದಾಮಿ, ಸ ಕೇನಾಪಿ ಪ್ರಕಾರೇಣ ಫಲೇನ ನ ವಞ್ಚಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ಇತ್ಥಂ ಯೀಶುಃ ಸ್ವದ್ವಾದಶಶಿಷ್ಯಾಣಾಮಾಜ್ಞಾಪನಂ ಸಮಾಪ್ಯ ಪುರೇ ಪುರ ಉಪದೇಷ್ಟುಂ ಸುಸಂವಾದಂ ಪ್ರಚಾರಯಿತುಂ ತತ್ಸ್ಥಾನಾತ್ ಪ್ರತಸ್ಥೇ| ");
INSERT INTO sankan_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ಅನನ್ತರಂ ಯೋಹನ್ ಕಾರಾಯಾಂ ತಿಷ್ಠನ್ ಖ್ರಿಷ್ಟಸ್ಯ ಕರ್ಮ್ಮಣಾಂ ವಾರ್ತ್ತಂ ಪ್ರಾಪ್ಯ ಯಸ್ಯಾಗಮನವಾರ್ತ್ತಾಸೀತ್ ಸಏವ ಕಿಂ ತ್ವಂ? ವಾ ವಯಮನ್ಯಮ್ ಅಪೇಕ್ಷಿಷ್ಯಾಮಹೇ? ");
INSERT INTO sankan_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ಏತತ್ ಪ್ರಷ್ಟುಂ ನಿಜೌ ದ್ವೌ ಶಿಷ್ಯೌ ಪ್ರಾಹಿಣೋತ್| ");
INSERT INTO sankan_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ಯೀಶುಃ ಪ್ರತ್ಯವೋಚತ್, ಅನ್ಧಾ ನೇತ್ರಾಣಿ ಲಭನ್ತೇ, ಖಞ್ಚಾ ಗಚ್ಛನ್ತಿ, ಕುಷ್ಠಿನಃ ಸ್ವಸ್ಥಾ ಭವನ್ತಿ, ಬಧಿರಾಃ ಶೃಣ್ವನ್ತಿ, ಮೃತಾ ಜೀವನ್ತ ಉತ್ತಿಷ್ಠನ್ತಿ, ದರಿದ್ರಾಣಾಂ ಸಮೀಪೇ ಸುಸಂವಾದಃ ಪ್ರಚಾರ್ಯ್ಯತ, ");
INSERT INTO sankan_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ಏತಾನಿ ಯದ್ಯದ್ ಯುವಾಂ ಶೃಣುಥಃ ಪಶ್ಯಥಶ್ಚ ಗತ್ವಾ ತದ್ವಾರ್ತ್ತಾಂ ಯೋಹನಂ ಗದತಂ| ");
INSERT INTO sankan_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ಯಸ್ಯಾಹಂ ನ ವಿಘ್ನೀಭವಾಮಿ, ಸಏವ ಧನ್ಯಃ| ");
INSERT INTO sankan_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ಅನನ್ತರಂ ತಯೋಃ ಪ್ರಸ್ಥಿತಯೋ ರ್ಯೀಶು ರ್ಯೋಹನಮ್ ಉದ್ದಿಶ್ಯ ಜನಾನ್ ಜಗಾದ, ಯೂಯಂ ಕಿಂ ದ್ರಷ್ಟುಂ ವಹಿರ್ಮಧ್ಯೇಪ್ರಾನ್ತರಮ್ ಅಗಚ್ಛತ? ಕಿಂ ವಾತೇನ ಕಮ್ಪಿತಂ ನಲಂ? ");
INSERT INTO sankan_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","ವಾ ಕಿಂ ವೀಕ್ಷಿತುಂ ವಹಿರ್ಗತವನ್ತಃ? ಕಿಂ ಪರಿಹಿತಸೂಕ್ಷ್ಮವಸನಂ ಮನುಜಮೇಕಂ? ಪಶ್ಯತ, ಯೇ ಸೂಕ್ಷ್ಮವಸನಾನಿ ಪರಿದಧತಿ, ತೇ ರಾಜಧಾನ್ಯಾಂ ತಿಷ್ಠನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ತರ್ಹಿ ಯೂಯಂ ಕಿಂ ದ್ರಷ್ಟುಂ ಬಹಿರಗಮತ, ಕಿಮೇಕಂ ಭವಿಷ್ಯದ್ವಾದಿನಂ? ತದೇವ ಸತ್ಯಂ| ಯುಷ್ಮಾನಹಂ ವದಾಮಿ, ಸ ಭವಿಷ್ಯದ್ವಾದಿನೋಪಿ ಮಹಾನ್; ");
INSERT INTO sankan_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","ಯತಃ, ಪಶ್ಯ ಸ್ವಕೀಯದೂತೋಯಂ ತ್ವದಗ್ರೇ ಪ್ರೇಷ್ಯತೇ ಮಯಾ| ಸ ಗತ್ವಾ ತವ ಪನ್ಥಾನಂ ಸ್ಮಯಕ್ ಪರಿಷ್ಕರಿಷ್ಯತಿ|| ಏತದ್ವಚನಂ ಯಮಧಿ ಲಿಖಿತಮಾಸ್ತೇ ಸೋಽಯಂ ಯೋಹನ್| ");
INSERT INTO sankan_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","ಅಪರಂ ಯುಷ್ಮಾನಹಂ ತಥ್ಯಂ ಬ್ರವೀಮಿ, ಮಜ್ಜಯಿತು ರ್ಯೋಹನಃ ಶ್ರೇಷ್ಠಃ ಕೋಪಿ ನಾರೀತೋ ನಾಜಾಯತ; ತಥಾಪಿ ಸ್ವರ್ಗರಾಜ್ಯಮಧ್ಯೇ ಸರ್ವ್ವೇಭ್ಯೋ ಯಃ ಕ್ಷುದ್ರಃ ಸ ಯೋಹನಃ ಶ್ರೇಷ್ಠಃ| ");
INSERT INTO sankan_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","ಅಪರಞ್ಚ ಆ ಯೋಹನೋಽದ್ಯ ಯಾವತ್ ಸ್ವರ್ಗರಾಜ್ಯಂ ಬಲಾದಾಕ್ರಾನ್ತಂ ಭವತಿ ಆಕ್ರಮಿನಶ್ಚ ಜನಾ ಬಲೇನ ತದಧಿಕುರ್ವ್ವನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","ಯತೋ ಯೋಹನಂ ಯಾವತ್ ಸರ್ವ್ವಭವಿಷ್ಯದ್ವಾದಿಭಿ ರ್ವ್ಯವಸ್ಥಯಾ ಚ ಉಪದೇಶಃ ಪ್ರಾಕಾಶ್ಯತ| ");
INSERT INTO sankan_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ಯದಿ ಯೂಯಮಿದಂ ವಾಕ್ಯಂ ಗ್ರಹೀತುಂ ಶಕ್ನುಥ, ತರ್ಹಿ ಶ್ರೇಯಃ, ಯಸ್ಯಾಗಮನಸ್ಯ ವಚನಮಾಸ್ತೇ ಸೋಽಯಮ್ ಏಲಿಯಃ| ");
INSERT INTO sankan_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ಯಸ್ಯ ಶ್ರೋತುಂ ಕರ್ಣೌ ಸ್ತಃ ಸ ಶೃಣೋತು| ");
INSERT INTO sankan_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","ಏತೇ ವಿದ್ಯಮಾನಜನಾಃ ಕೈ ರ್ಮಯೋಪಮೀಯನ್ತೇ? ಯೇ ಬಾಲಕಾ ಹಟ್ಟ ಉಪವಿಶ್ಯ ಸ್ವಂ ಸ್ವಂ ಬನ್ಧುಮಾಹೂಯ ವದನ್ತಿ, ");
INSERT INTO sankan_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ವಯಂ ಯುಷ್ಮಾಕಂ ಸಮೀಪೇ ವಂಶೀರವಾದಯಾಮ, ಕಿನ್ತು ಯೂಯಂ ನಾನೃತ್ಯತ; ಯುಷ್ಮಾಕಂ ಸಮೀಪೇ ಚ ವಯಮರೋದಿಮ, ಕಿನ್ತು ಯೂಯಂ ನ ವ್ಯಲಪತ, ತಾದೃಶೈ ರ್ಬಾಲಕೈಸ್ತ ಉಪಮಾಯಿಷ್ಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","ಯತೋ ಯೋಹನ್ ಆಗತ್ಯ ನ ಭುಕ್ತವಾನ್ ನ ಪೀತವಾಂಶ್ಚ, ತೇನ ಲೋಕಾ ವದನ್ತಿ, ಸ ಭೂತಗ್ರಸ್ತ ಇತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","ಮನುಜಸುತ ಆಗತ್ಯ ಭುಕ್ತವಾನ್ ಪೀತವಾಂಶ್ಚ, ತೇನ ಲೋಕಾ ವದನ್ತಿ, ಪಶ್ಯತ ಏಷ ಭೋಕ್ತಾ ಮದ್ಯಪಾತಾ ಚಣ್ಡಾಲಪಾಪಿನಾಂ ಬನ್ಧಶ್ಚ, ಕಿನ್ತು ಜ್ಞಾನಿನೋ ಜ್ಞಾನವ್ಯವಹಾರಂ ನಿರ್ದೋಷಂ ಜಾನನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ಸ ಯತ್ರ ಯತ್ರ ಪುರೇ ಬಹ್ವಾಶ್ಚರ್ಯ್ಯಂ ಕರ್ಮ್ಮ ಕೃತವಾನ್, ತನ್ನಿವಾಸಿನಾಂ ಮನಃಪರಾವೃತ್ತ್ಯಭಾವಾತ್ ತಾನಿ ನಗರಾಣಿ ಪ್ರತಿ ಹನ್ತೇತ್ಯುಕ್ತಾ ಕಥಿತವಾನ್, ");
INSERT INTO sankan_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","ಹಾ ಕೋರಾಸೀನ್, ಹಾ ಬೈತ್ಸೈದೇ, ಯುಷ್ಮನ್ಮಧ್ಯೇ ಯದ್ಯದಾಶ್ಚರ್ಯ್ಯಂ ಕರ್ಮ್ಮ ಕೃತಂ ಯದಿ ತತ್ ಸೋರಸೀದೋನ್ನಗರ ಅಕಾರಿಷ್ಯತ, ತರ್ಹಿ ಪೂರ್ವ್ವಮೇವ ತನ್ನಿವಾಸಿನಃ ಶಾಣವಸನೇ ಭಸ್ಮನಿ ಚೋಪವಿಶನ್ತೋ ಮನಾಂಸಿ ಪರಾವರ್ತ್ತಿಷ್ಯನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","ತಸ್ಮಾದಹಂ ಯುಷ್ಮಾನ್ ವದಾಮಿ, ವಿಚಾರದಿನೇ ಯುಷ್ಮಾಕಂ ದಶಾತಃ ಸೋರಸೀದೋನೋ ರ್ದಶಾ ಸಹ್ಯತರಾ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","ಅಪರಞ್ಚ ಬತ ಕಫರ್ನಾಹೂಮ್, ತ್ವಂ ಸ್ವರ್ಗಂ ಯಾವದುನ್ನತೋಸಿ, ಕಿನ್ತು ನರಕೇ ನಿಕ್ಷೇಪ್ಸ್ಯಸೇ, ಯಸ್ಮಾತ್ ತ್ವಯಿ ಯಾನ್ಯಾಶ್ಚರ್ಯ್ಯಾಣಿ ಕರ್ಮ್ಮಣ್ಯಕಾರಿಷತ, ಯದಿ ತಾನಿ ಸಿದೋಮ್ನಗರ ಅಕಾರಿಷ್ಯನ್ತ, ತರ್ಹಿ ತದದ್ಯ ಯಾವದಸ್ಥಾಸ್ಯತ್| ");
INSERT INTO sankan_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","ಕಿನ್ತ್ವಹಂ ಯುಷ್ಮಾನ್ ವದಾಮಿ, ವಿಚಾರದಿನೇ ತವ ದಣ್ಡತಃ ಸಿದೋಮೋ ದಣ್ಡೋ ಸಹ್ಯತರೋ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ಏತಸ್ಮಿನ್ನೇವ ಸಮಯೇ ಯೀಶುಃ ಪುನರುವಾಚ, ಹೇ ಸ್ವರ್ಗಪೃಥಿವ್ಯೋರೇಕಾಧಿಪತೇ ಪಿತಸ್ತ್ವಂ ಜ್ಞಾನವತೋ ವಿದುಷಶ್ಚ ಲೋಕಾನ್ ಪ್ರತ್ಯೇತಾನಿ ನ ಪ್ರಕಾಶ್ಯ ಬಾಲಕಾನ್ ಪ್ರತಿ ಪ್ರಕಾಶಿತವಾನ್, ಇತಿ ಹೇತೋಸ್ತ್ವಾಂ ಧನ್ಯಂ ವದಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ಹೇ ಪಿತಃ, ಇತ್ಥಂ ಭವೇತ್ ಯತ ಇದಂ ತ್ವದೃಷ್ಟಾವುತ್ತಮಂ| ");
INSERT INTO sankan_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","ಪಿತ್ರಾ ಮಯಿ ಸರ್ವ್ವಾಣಿ ಸಮರ್ಪಿತಾನಿ, ಪಿತರಂ ವಿನಾ ಕೋಪಿ ಪುತ್ರಂ ನ ಜಾನಾತಿ, ಯಾನ್ ಪ್ರತಿ ಪುತ್ರೇಣ ಪಿತಾ ಪ್ರಕಾಶ್ಯತೇ ತಾನ್ ವಿನಾ ಪುತ್ರಾದ್ ಅನ್ಯಃ ಕೋಪಿ ಪಿತರಂ ನ ಜಾನಾತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","ಹೇ ಪರಿಶ್ರಾನ್ತಾ ಭಾರಾಕ್ರಾನ್ತಾಶ್ಚ ಲೋಕಾ ಯೂಯಂ ಮತ್ಸನ್ನಿಧಿಮ್ ಆಗಚ್ಛತ, ಅಹಂ ಯುಷ್ಮಾನ್ ವಿಶ್ರಮಯಿಷ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ಅಹಂ ಕ್ಷಮಣಶೀಲೋ ನಮ್ರಮನಾಶ್ಚ, ತಸ್ಮಾತ್ ಮಮ ಯುಗಂ ಸ್ವೇಷಾಮುಪರಿ ಧಾರಯತ ಮತ್ತಃ ಶಿಕ್ಷಧ್ವಞ್ಚ, ತೇನ ಯೂಯಂ ಸ್ವೇ ಸ್ವೇ ಮನಸಿ ವಿಶ್ರಾಮಂ ಲಪ್ಸ್ಯಧ್ಬೇ| ");
INSERT INTO sankan_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ಯತೋ ಮಮ ಯುಗಮ್ ಅನಾಯಾಸಂ ಮಮ ಭಾರಶ್ಚ ಲಘುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","ಅನನ್ತರಂ ಯೀಶು ರ್ವಿಶ್ರಾಮವಾರೇ ಶ್ಸ್ಯಮಧ್ಯೇನ ಗಚ್ಛತಿ, ತದಾ ತಚ್ಛಿಷ್ಯಾ ಬುಭುಕ್ಷಿತಾಃ ಸನ್ತಃ ಶ್ಸ್ಯಮಞ್ಜರೀಶ್ಛತ್ವಾ ಛಿತ್ವಾ ಖಾದಿತುಮಾರಭನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ತದ್ ವಿಲೋಕ್ಯ ಫಿರೂಶಿನೋ ಯೀಶುಂ ಜಗದುಃ, ಪಶ್ಯ ವಿಶ್ರಾಮವಾರೇ ಯತ್ ಕರ್ಮ್ಮಾಕರ್ತ್ತವ್ಯಂ ತದೇವ ತವ ಶಿಷ್ಯಾಃ ಕುರ್ವ್ವನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ಸ ತಾನ್ ಪ್ರತ್ಯಾವದತ, ದಾಯೂದ್ ತತ್ಸಙ್ಗಿನಶ್ಚ ಬುಭುಕ್ಷಿತಾಃ ಸನ್ತೋ ಯತ್ ಕರ್ಮ್ಮಾಕುರ್ವ್ವನ್ ತತ್ ಕಿಂ ಯುಷ್ಮಾಭಿ ರ್ನಾಪಾಠಿ? ");
INSERT INTO sankan_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ಯೇ ದರ್ಶನೀಯಾಃ ಪೂಪಾಃ ಯಾಜಕಾನ್ ವಿನಾ ತಸ್ಯ ತತ್ಸಙ್ಗಿಮನುಜಾನಾಞ್ಚಾಭೋಜನೀಯಾಸ್ತ ಈಶ್ವರಾವಾಸಂ ಪ್ರವಿಷ್ಟೇನ ತೇನ ಭುಕ್ತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","ಅನ್ಯಚ್ಚ ವಿಶ್ರಾಮವಾರೇ ಮಧ್ಯೇಮನ್ದಿರಂ ವಿಶ್ರಾಮವಾರೀಯಂ ನಿಯಮಂ ಲಙ್ವನ್ತೋಪಿ ಯಾಜಕಾ ನಿರ್ದೋಷಾ ಭವನ್ತಿ, ಶಾಸ್ತ್ರಮಧ್ಯೇ ಕಿಮಿದಮಪಿ ಯುಷ್ಮಾಭಿ ರ್ನ ಪಠಿತಂ? ");
INSERT INTO sankan_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","ಯುಷ್ಮಾನಹಂ ವದಾಮಿ, ಅತ್ರ ಸ್ಥಾನೇ ಮನ್ದಿರಾದಪಿ ಗರೀಯಾನ್ ಏಕ ಆಸ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","ಕಿನ್ತು ದಯಾಯಾಂ ಮೇ ಯಥಾ ಪ್ರೀತಿ ರ್ನ ತಥಾ ಯಜ್ಞಕರ್ಮ್ಮಣಿ| ಏತದ್ವಚನಸ್ಯಾರ್ಥಂ ಯದಿ ಯುಯಮ್ ಅಜ್ಞಾಸಿಷ್ಟ ತರ್ಹಿ ನಿರ್ದೋಷಾನ್ ದೋಷಿಣೋ ನಾಕಾರ್ಷ್ಟ| ");
INSERT INTO sankan_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","ಅನ್ಯಚ್ಚ ಮನುಜಸುತೋ ವಿಶ್ರಾಮವಾರಸ್ಯಾಪಿ ಪತಿರಾಸ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ಅನನ್ತರಂ ಸ ತತ್ಸ್ಥಾನಾತ್ ಪ್ರಸ್ಥಾಯ ತೇಷಾಂ ಭಜನಭವನಂ ಪ್ರವಿಷ್ಟವಾನ್, ತದಾನೀಮ್ ಏಕಃ ಶುಷ್ಕಕರಾಮಯವಾನ್ ಉಪಸ್ಥಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ತತೋ ಯೀಶುಮ್ ಅಪವದಿತುಂ ಮಾನುಷಾಃ ಪಪ್ರಚ್ಛುಃ, ವಿಶ್ರಾಮವಾರೇ ನಿರಾಮಯತ್ವಂ ಕರಣೀಯಂ ನ ವಾ? ");
INSERT INTO sankan_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ತೇನ ಸ ಪ್ರತ್ಯುವಾಚ, ವಿಶ್ರಾಮವಾರೇ ಯದಿ ಕಸ್ಯಚಿದ್ ಅವಿ ರ್ಗರ್ತ್ತೇ ಪತತಿ, ತರ್ಹಿ ಯಸ್ತಂ ಘೃತ್ವಾ ನ ತೋಲಯತಿ, ಏತಾದೃಶೋ ಮನುಜೋ ಯುಷ್ಮಾಕಂ ಮಧ್ಯೇ ಕ ಆಸ್ತೇ? ");
INSERT INTO sankan_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ಅವೇ ರ್ಮಾನವಃ ಕಿಂ ನಹಿ ಶ್ರೇಯಾನ್? ಅತೋ ವಿಶ್ರಾಮವಾರೇ ಹಿತಕರ್ಮ್ಮ ಕರ್ತ್ತವ್ಯಂ| ");
INSERT INTO sankan_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","ಅನನ್ತರಂ ಸ ತಂ ಮಾನವಂ ಗದಿತವಾನ್, ಕರಂ ಪ್ರಸಾರಯ; ತೇನ ಕರೇ ಪ್ರಸಾರಿತೇ ಸೋನ್ಯಕರವತ್ ಸ್ವಸ್ಥೋಽಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ತದಾ ಫಿರೂಶಿನೋ ಬಹಿರ್ಭೂಯ ಕಥಂ ತಂ ಹನಿಷ್ಯಾಮ ಇತಿ ಕುಮನ್ತ್ರಣಾಂ ತತ್ಪ್ರಾತಿಕೂಲ್ಯೇನ ಚಕ್ರುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ತತೋ ಯೀಶುಸ್ತದ್ ವಿದಿತ್ವಾ ಸ್ಥನಾನ್ತರಂ ಗತವಾನ್; ಅನ್ಯೇಷು ಬಹುನರೇಷು ತತ್ಪಶ್ಚಾದ್ ಗತೇಷು ತಾನ್ ಸ ನಿರಾಮಯಾನ್ ಕೃತ್ವಾ ಇತ್ಯಾಜ್ಞಾಪಯತ್, ");
INSERT INTO sankan_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ಯೂಯಂ ಮಾಂ ನ ಪರಿಚಾಯಯತ| ");
INSERT INTO sankan_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ತಸ್ಮಾತ್ ಮಮ ಪ್ರೀಯೋ ಮನೋನೀತೋ ಮನಸಸ್ತುಷ್ಟಿಕಾರಕಃ| ಮದೀಯಃ ಸೇವಕೋ ಯಸ್ತು ವಿದ್ಯತೇ ತಂ ಸಮೀಕ್ಷತಾಂ| ತಸ್ಯೋಪರಿ ಸ್ವಕೀಯಾತ್ಮಾ ಮಯಾ ಸಂಸ್ಥಾಪಯಿಷ್ಯತೇ| ತೇನಾನ್ಯದೇಶಜಾತೇಷು ವ್ಯವಸ್ಥಾ ಸಂಪ್ರಕಾಶ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","ಕೇನಾಪಿ ನ ವಿರೋಧಂ ಸ ವಿವಾದಞ್ಚ ಕರಿಷ್ಯತಿ| ನ ಚ ರಾಜಪಥೇ ತೇನ ವಚನಂ ಶ್ರಾವಯಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ವ್ಯವಸ್ಥಾ ಚಲಿತಾ ಯಾವತ್ ನಹಿ ತೇನ ಕರಿಷ್ಯತೇ| ತಾವತ್ ನಲೋ ವಿದೀರ್ಣೋಽಪಿ ಭಂಕ್ಷ್ಯತೇ ನಹಿ ತೇನ ಚ| ತಥಾ ಸಧೂಮವರ್ತ್ತಿಞ್ಚ ನ ಸ ನಿರ್ವ್ವಾಪಯಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ಪ್ರತ್ಯಾಶಾಞ್ಚ ಕರಿಷ್ಯನ್ತಿ ತನ್ನಾಮ್ನಿ ಭಿನ್ನದೇಶಜಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ಯಾನ್ಯೇತಾನಿ ವಚನಾನಿ ಯಿಶಯಿಯಭವಿಷ್ಯದ್ವಾದಿನಾ ಪ್ರೋಕ್ತಾನ್ಯಾಸನ್, ತಾನಿ ಸಫಲಾನ್ಯಭವನ್| ");
INSERT INTO sankan_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","ಅನನ್ತರಂ ಲೋಕೈ ಸ್ತತ್ಸಮೀಪಮ್ ಆನೀತೋ ಭೂತಗ್ರಸ್ತಾನ್ಧಮೂಕೈಕಮನುಜಸ್ತೇನ ಸ್ವಸ್ಥೀಕೃತಃ, ತತಃ ಸೋಽನ್ಧೋ ಮೂಕೋ ದ್ರಷ್ಟುಂ ವಕ್ತುಞ್ಚಾರಬ್ಧವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ಅನೇನ ಸರ್ವ್ವೇ ವಿಸ್ಮಿತಾಃ ಕಥಯಾಞ್ಚಕ್ರುಃ, ಏಷಃ ಕಿಂ ದಾಯೂದಃ ಸನ್ತಾನೋ ನಹಿ? ");
INSERT INTO sankan_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","ಕಿನ್ತು ಫಿರೂಶಿನಸ್ತತ್ ಶ್ರುತ್ವಾ ಗದಿತವನ್ತಃ, ಬಾಲ್ಸಿಬೂಬ್ನಾಮ್ನೋ ಭೂತರಾಜಸ್ಯ ಸಾಹಾಯ್ಯಂ ವಿನಾ ನಾಯಂ ಭೂತಾನ್ ತ್ಯಾಜಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ತದಾನೀಂ ಯೀಶುಸ್ತೇಷಾಮ್ ಇತಿ ಮಾನಸಂ ವಿಜ್ಞಾಯ ತಾನ್ ಅವದತ್ ಕಿಞ್ಚನ ರಾಜ್ಯಂ ಯದಿ ಸ್ವವಿಪಕ್ಷಾದ್ ಭಿದ್ಯತೇ, ತರ್ಹಿ ತತ್ ಉಚ್ಛಿದ್ಯತೇ; ಯಚ್ಚ ಕಿಞ್ಚನ ನಗರಂ ವಾ ಗೃಹಂ ಸ್ವವಿಪಕ್ಷಾದ್ ವಿಭಿದ್ಯತೇ, ತತ್ ಸ್ಥಾತುಂ ನ ಶಕ್ನೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","ತದ್ವತ್ ಶಯತಾನೋ ಯದಿ ಶಯತಾನಂ ಬಹಿಃ ಕೃತ್ವಾ ಸ್ವವಿಪಕ್ಷಾತ್ ಪೃಥಕ್ ಪೃಥಕ್ ಭವತಿ, ತರ್ಹಿ ತಸ್ಯ ರಾಜ್ಯಂ ಕೇನ ಪ್ರಕಾರೇಣ ಸ್ಥಾಸ್ಯತಿ? ");
INSERT INTO sankan_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ಅಹಞ್ಚ ಯದಿ ಬಾಲ್ಸಿಬೂಬಾ ಭೂತಾನ್ ತ್ಯಾಜಯಾಮಿ, ತರ್ಹಿ ಯುಷ್ಮಾಕಂ ಸನ್ತಾನಾಃ ಕೇನ ಭೂತಾನ್ ತ್ಯಾಜಯನ್ತಿ? ತಸ್ಮಾದ್ ಯುಷ್ಮಾಕಮ್ ಏತದ್ವಿಚಾರಯಿತಾರಸ್ತ ಏವ ಭವಿಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","ಕಿನ್ತವಹಂ ಯದೀಶ್ವರಾತ್ಮನಾ ಭೂತಾನ್ ತ್ಯಾಜಯಾಮಿ, ತರ್ಹೀಶ್ವರಸ್ಯ ರಾಜ್ಯಂ ಯುಷ್ಮಾಕಂ ಸನ್ನಿಧಿಮಾಗತವತ್| ");
INSERT INTO sankan_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","ಅನ್ಯಞ್ಚ ಕೋಪಿ ಬಲವನ್ತ ಜನಂ ಪ್ರಥಮತೋ ನ ಬದ್ವ್ವಾ ಕೇನ ಪ್ರಕಾರೇಣ ತಸ್ಯ ಗೃಹಂ ಪ್ರವಿಶ್ಯ ತದ್ದ್ರವ್ಯಾದಿ ಲೋಠಯಿತುಂ ಶಕ್ನೋತಿ? ಕಿನ್ತು ತತ್ ಕೃತ್ವಾ ತದೀಯಗೃಸ್ಯ ದ್ರವ್ಯಾದಿ ಲೋಠಯಿತುಂ ಶಕ್ನೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","ಯಃ ಕಶ್ಚಿತ್ ಮಮ ಸ್ವಪಕ್ಷೀಯೋ ನಹಿ ಸ ವಿಪಕ್ಷೀಯ ಆಸ್ತೇ, ಯಶ್ಚ ಮಯಾ ಸಾಕಂ ನ ಸಂಗೃಹ್ಲಾತಿ, ಸ ವಿಕಿರತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ಅತಏವ ಯುಷ್ಮಾನಹಂ ವದಾಮಿ, ಮನುಜಾನಾಂ ಸರ್ವ್ವಪ್ರಕಾರಪಾಪಾನಾಂ ನಿನ್ದಾಯಾಶ್ಚ ಮರ್ಷಣಂ ಭವಿತುಂ ಶಕ್ನೋತಿ, ಕಿನ್ತು ಪವಿತ್ರಸ್ಯಾತ್ಮನೋ ವಿರುದ್ಧನಿನ್ದಾಯಾ ಮರ್ಷಣಂ ಭವಿತುಂ ನ ಶಕ್ನೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","ಯೋ ಮನುಜಸುತಸ್ಯ ವಿರುದ್ಧಾಂ ಕಥಾಂ ಕಥಯತಿ, ತಸ್ಯಾಪರಾಧಸ್ಯ ಕ್ಷಮಾ ಭವಿತುಂ ಶಕ್ನೋತಿ, ಕಿನ್ತು ಯಃ ಕಶ್ಚಿತ್ ಪವಿತ್ರಸ್ಯಾತ್ಮನೋ ವಿರುದ್ಧಾಂ ಕಥಾಂ ಕಥಯತಿ ನೇಹಲೋಕೇ ನ ಪ್ರೇತ್ಯ ತಸ್ಯಾಪರಾಧಸ್ಯ ಕ್ಷಮಾ ಭವಿತುಂ ಶಕ್ನೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","ಪಾದಪಂ ಯದಿ ಭದ್ರಂ ವದಥ, ತರ್ಹಿ ತಸ್ಯ ಫಲಮಪಿ ಸಾಧು ವಕ್ತವ್ಯಂ, ಯದಿ ಚ ಪಾದಪಂ ಅಸಾಧುಂ ವದಥ, ತರ್ಹಿ ತಸ್ಯ ಫಲಮಪ್ಯಸಾಧು ವಕ್ತವ್ಯಂ; ಯತಃ ಸ್ವೀಯಸ್ವೀಯಫಲೇನ ಪಾದಪಃ ಪರಿಚೀಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","ರೇ ಭುಜಗವಂಶಾ ಯೂಯಮಸಾಧವಃ ಸನ್ತಃ ಕಥಂ ಸಾಧು ವಾಕ್ಯಂ ವಕ್ತುಂ ಶಕ್ಷ್ಯಥ? ಯಸ್ಮಾದ್ ಅನ್ತಃಕರಣಸ್ಯ ಪೂರ್ಣಭಾವಾನುಸಾರಾದ್ ವದನಾದ್ ವಚೋ ನಿರ್ಗಚ್ಛತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","ತೇನ ಸಾಧುರ್ಮಾನವೋಽನ್ತಃಕರಣರೂಪಾತ್ ಸಾಧುಭಾಣ್ಡಾಗಾರಾತ್ ಸಾಧು ದ್ರವ್ಯಂ ನಿರ್ಗಮಯತಿ, ಅಸಾಧುರ್ಮಾನುಷಸ್ತ್ವಸಾಧುಭಾಣ್ಡಾಗಾರಾದ್ ಅಸಾಧುವಸ್ತೂನಿ ನಿರ್ಗಮಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","ಕಿನ್ತ್ವಹಂ ಯುಷ್ಮಾನ್ ವದಾಮಿ, ಮನುಜಾ ಯಾವನ್ತ್ಯಾಲಸ್ಯವಚಾಂಸಿ ವದನ್ತಿ, ವಿಚಾರದಿನೇ ತದುತ್ತರಮವಶ್ಯಂ ದಾತವ್ಯಂ, ");
INSERT INTO sankan_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","ಯತಸ್ತ್ವಂ ಸ್ವೀಯವಚೋಭಿ ರ್ನಿರಪರಾಧಃ ಸ್ವೀಯವಚೋಭಿಶ್ಚ ಸಾಪರಾಧೋ ಗಣಿಷ್ಯಸೇ| ");
INSERT INTO sankan_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","ತದಾನೀಂ ಕತಿಪಯಾ ಉಪಾಧ್ಯಾಯಾಃ ಫಿರೂಶಿನಶ್ಚ ಜಗದುಃ, ಹೇ ಗುರೋ ವಯಂ ಭವತ್ತಃ ಕಿಞ್ಚನ ಲಕ್ಷ್ಮ ದಿದೃಕ್ಷಾಮಃ| ");
INSERT INTO sankan_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ತದಾ ಸ ಪ್ರತ್ಯುಕ್ತವಾನ್, ದುಷ್ಟೋ ವ್ಯಭಿಚಾರೀ ಚ ವಂಶೋ ಲಕ್ಷ್ಮ ಮೃಗಯತೇ, ಕಿನ್ತು ಭವಿಷ್ಯದ್ವಾದಿನೋ ಯೂನಸೋ ಲಕ್ಷ್ಮ ವಿಹಾಯಾನ್ಯತ್ ಕಿಮಪಿ ಲಕ್ಷ್ಮ ತೇ ನ ಪ್ರದರ್ಶಯಿಷ್ಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ಯತೋ ಯೂನಮ್ ಯಥಾ ತ್ರ್ಯಹೋರಾತ್ರಂ ಬೃಹನ್ಮೀನಸ್ಯ ಕುಕ್ಷಾವಾಸೀತ್, ತಥಾ ಮನುಜಪುತ್ರೋಪಿ ತ್ರ್ಯಹೋರಾತ್ರಂ ಮೇದಿನ್ಯಾ ಮಧ್ಯೇ ಸ್ಥಾಸ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","ಅಪರಂ ನೀನಿವೀಯಾ ಮಾನವಾ ವಿಚಾರದಿನ ಏತದ್ವಂಶೀಯಾನಾಂ ಪ್ರತಿಕೂಲಮ್ ಉತ್ಥಾಯ ತಾನ್ ದೋಷಿಣಃ ಕರಿಷ್ಯನ್ತಿ, ಯಸ್ಮಾತ್ತೇ ಯೂನಸ ಉಪದೇಶಾತ್ ಮನಾಂಸಿ ಪರಾವರ್ತ್ತಯಾಞ್ಚಕ್ರಿರೇ, ಕಿನ್ತ್ವತ್ರ ಯೂನಸೋಪಿ ಗುರುತರ ಏಕ ಆಸ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","ಪುನಶ್ಚ ದಕ್ಷಿಣದೇಶೀಯಾ ರಾಜ್ಞೀ ವಿಚಾರದಿನ ಏತದ್ವಂಶೀಯಾನಾಂ ಪ್ರತಿಕೂಲಮುತ್ಥಾಯ ತಾನ್ ದೋಷಿಣಃ ಕರಿಷ್ಯತಿ ಯತಃ ಸಾ ರಾಜ್ಞೀ ಸುಲೇಮನೋ ವಿದ್ಯಾಯಾಃ ಕಥಾಂ ಶ್ರೋತುಂ ಮೇದಿನ್ಯಾಃ ಸೀಮ್ನ ಆಗಚ್ಛತ್, ಕಿನ್ತು ಸುಲೇಮನೋಪಿ ಗುರುತರ ಏಕೋ ಜನೋಽತ್ರ ಆಸ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","ಅಪರಂ ಮನುಜಾದ್ ಬಹಿರ್ಗತೋ ಽಪವಿತ್ರಭೂತಃ ಶುಷ್ಕಸ್ಥಾನೇನ ಗತ್ವಾ ವಿಶ್ರಾಮಂ ಗವೇಷಯತಿ, ಕಿನ್ತು ತದಲಭಮಾನಃ ಸ ವಕ್ತಿ, ಯಸ್ಮಾ; ನಿಕೇತನಾದ್ ಆಗಮಂ, ತದೇವ ವೇಶ್ಮ ಪಕಾವೃತ್ಯ ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ಪಶ್ಚಾತ್ ಸ ತತ್ ಸ್ಥಾನಮ್ ಉಪಸ್ಥಾಯ ತತ್ ಶೂನ್ಯಂ ಮಾರ್ಜ್ಜಿತಂ ಶೋಭಿತಞ್ಚ ವಿಲೋಕ್ಯ ವ್ರಜನ್ ಸ್ವತೋಪಿ ದುಷ್ಟತರಾನ್ ಅನ್ಯಸಪ್ತಭೂತಾನ್ ಸಙ್ಗಿನಃ ಕರೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ತತಸ್ತೇ ತತ್ ಸ್ಥಾನಂ ಪ್ರವಿಶ್ಯ ನಿವಸನ್ತಿ, ತೇನ ತಸ್ಯ ಮನುಜಸ್ಯ ಶೇಷದಶಾ ಪೂರ್ವ್ವದಶಾತೋತೀವಾಶುಭಾ ಭವತಿ, ಏತೇಷಾಂ ದುಷ್ಟವಂಶ್ಯಾನಾಮಪಿ ತಥೈವ ಘಟಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","ಮಾನವೇಭ್ಯ ಏತಾಸಾಂ ಕಥನಾಂ ಕಥನಕಾಲೇ ತಸ್ಯ ಮಾತಾ ಸಹಜಾಶ್ಚ ತೇನ ಸಾಕಂ ಕಾಞ್ಚಿತ್ ಕಥಾಂ ಕಥಯಿತುಂ ವಾಞ್ಛನ್ತೋ ಬಹಿರೇವ ಸ್ಥಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ತತಃ ಕಶ್ಚಿತ್ ತಸ್ಮೈ ಕಥಿತವಾನ್, ಪಶ್ಯ ತವ ಜನನೀ ಸಹಜಾಶ್ಚ ತ್ವಯಾ ಸಾಕಂ ಕಾಞ್ಚನ ಕಥಾಂ ಕಥಯಿತುಂ ಕಾಮಯಮಾನಾ ಬಹಿಸ್ತಿಷ್ಠನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","ಕಿನ್ತು ಸ ತಂ ಪ್ರತ್ಯವದತ್, ಮಮ ಕಾ ಜನನೀ? ಕೇ ವಾ ಮಮ ಸಹಜಾಃ? ");
INSERT INTO sankan_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ಪಶ್ಚಾತ್ ಶಿಷ್ಯಾನ್ ಪ್ರತಿ ಕರಂ ಪ್ರಸಾರ್ಯ್ಯ ಕಥಿತವಾನ್, ಪಶ್ಯ ಮಮ ಜನನೀ ಮಮ ಸಹಜಾಶ್ಚೈತೇ; ");
INSERT INTO sankan_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ಯಃ ಕಶ್ಚಿತ್ ಮಮ ಸ್ವರ್ಗಸ್ಥಸ್ಯ ಪಿತುರಿಷ್ಟಂ ಕರ್ಮ್ಮ ಕುರುತೇ, ಸಏವ ಮಮ ಭ್ರಾತಾ ಭಗಿನೀ ಜನನೀ ಚ| ");
INSERT INTO sankan_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","ಅಪರಞ್ಚ ತಸ್ಮಿನ್ ದಿನೇ ಯೀಶುಃ ಸದ್ಮನೋ ಗತ್ವಾ ಸರಿತ್ಪತೇ ರೋಧಸಿ ಸಮುಪವಿವೇಶ| ");
INSERT INTO sankan_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ತತ್ರ ತತ್ಸನ್ನಿಧೌ ಬಹುಜನಾನಾಂ ನಿವಹೋಪಸ್ಥಿತೇಃ ಸ ತರಣಿಮಾರುಹ್ಯ ಸಮುಪಾವಿಶತ್, ತೇನ ಮಾನವಾ ರೋಧಸಿ ಸ್ಥಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ತದಾನೀಂ ಸ ದೃಷ್ಟಾನ್ತೈಸ್ತಾನ್ ಇತ್ಥಂ ಬಹುಶ ಉಪದಿಷ್ಟವಾನ್| ಪಶ್ಯತ, ಕಶ್ಚಿತ್ ಕೃಷೀವಲೋ ಬೀಜಾನಿ ವಪ್ತುಂ ಬಹಿರ್ಜಗಾಮ, ");
INSERT INTO sankan_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ತಸ್ಯ ವಪನಕಾಲೇ ಕತಿಪಯಬೀಜೇಷು ಮಾರ್ಗಪಾರ್ಶ್ವೇ ಪತಿತೇಷು ವಿಹಗಾಸ್ತಾನಿ ಭಕ್ಷಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","ಅಪರಂ ಕತಿಪಯಬೀಜೇಷು ಸ್ತೋಕಮೃದ್ಯುಕ್ತಪಾಷಾಣೇ ಪತಿತೇಷು ಮೃದಲ್ಪತ್ವಾತ್ ತತ್ಕ್ಷಣಾತ್ ತಾನ್ಯಙ್ಕುರಿತಾನಿ, ");
INSERT INTO sankan_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ಕಿನ್ತು ರವಾವುದಿತೇ ದಗ್ಧಾನಿ ತೇಷಾಂ ಮೂಲಾಪ್ರವಿಷ್ಟತ್ವಾತ್ ಶುಷ್ಕತಾಂ ಗತಾನಿ ಚ| ");
INSERT INTO sankan_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","ಅಪರಂ ಕತಿಪಯಬೀಜೇಷು ಕಣ್ಟಕಾನಾಂ ಮಧ್ಯೇ ಪತಿತೇಷು ಕಣ್ಟಕಾನ್ಯೇಧಿತ್ವಾ ತಾನಿ ಜಗ್ರಸುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","ಅಪರಞ್ಚ ಕತಿಪಯಬೀಜಾನಿ ಉರ್ವ್ವರಾಯಾಂ ಪತಿತಾನಿ; ತೇಷಾಂ ಮಧ್ಯೇ ಕಾನಿಚಿತ್ ಶತಗುಣಾನಿ ಕಾನಿಚಿತ್ ಷಷ್ಟಿಗುಣಾನಿ ಕಾನಿಚಿತ್ ತ್ರಿಂಶಗುಂಣಾನಿ ಫಲಾನಿ ಫಲಿತವನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ಶ್ರೋತುಂ ಯಸ್ಯ ಶ್ರುತೀ ಆಸಾತೇ ಸ ಶೃಣುಯಾತ್| ");
INSERT INTO sankan_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","ಅನನ್ತರಂ ಶಿಷ್ಯೈರಾಗತ್ಯ ಸೋಽಪೃಚ್ಛ್ಯತ, ಭವತಾ ತೇಭ್ಯಃ ಕುತೋ ದೃಷ್ಟಾನ್ತಕಥಾ ಕಥ್ಯತೇ? ");
INSERT INTO sankan_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ತತಃ ಸ ಪ್ರತ್ಯವದತ್, ಸ್ವರ್ಗರಾಜ್ಯಸ್ಯ ನಿಗೂಢಾಂ ಕಥಾಂ ವೇದಿತುಂ ಯುಷ್ಮಭ್ಯಂ ಸಾಮರ್ಥ್ಯಮದಾಯಿ, ಕಿನ್ತು ತೇಭ್ಯೋ ನಾದಾಯಿ| ");
INSERT INTO sankan_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","ಯಸ್ಮಾದ್ ಯಸ್ಯಾನ್ತಿಕೇ ವರ್ದ್ಧತೇ, ತಸ್ಮಾಯೇವ ದಾಯಿಷ್ಯತೇ, ತಸ್ಮಾತ್ ತಸ್ಯ ಬಾಹುಲ್ಯಂ ಭವಿಷ್ಯತಿ, ಕಿನ್ತು ಯಸ್ಯಾನ್ತಿಕೇ ನ ವರ್ದ್ಧತೇ, ತಸ್ಯ ಯತ್ ಕಿಞ್ಚನಾಸ್ತೇ, ತದಪಿ ತಸ್ಮಾದ್ ಆದಾಯಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","ತೇ ಪಶ್ಯನ್ತೋಪಿ ನ ಪಶ್ಯನ್ತಿ, ಶೃಣ್ವನ್ತೋಪಿ ನ ಶೃಣ್ವನ್ತಿ, ಬುಧ್ಯಮಾನಾ ಅಪಿ ನ ಬುಧ್ಯನ್ತೇ ಚ, ತಸ್ಮಾತ್ ತೇಭ್ಯೋ ದೃಷ್ಟಾನ್ತಕಥಾ ಕಥ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","ಯಥಾ ಕರ್ಣೈಃ ಶ್ರೋಷ್ಯಥ ಯೂಯಂ ವೈ ಕಿನ್ತು ಯೂಯಂ ನ ಭೋತ್ಸ್ಯಥ| ನೇತ್ರೈರ್ದ್ರಕ್ಷ್ಯಥ ಯೂಯಞ್ಚ ಪರಿಜ್ಞಾತುಂ ನ ಶಕ್ಷ್ಯಥ| ತೇ ಮಾನುಷಾ ಯಥಾ ನೈವ ಪರಿಪಶ್ಯನ್ತಿ ಲೋಚನೈಃ| ಕರ್ಣೈ ರ್ಯಥಾ ನ ಶೃಣ್ವನ್ತಿ ನ ಬುಧ್ಯನ್ತೇ ಚ ಮಾನಸೈಃ| ವ್ಯಾವರ್ತ್ತಿತೇಷು ಚಿತ್ತೇಷು ಕಾಲೇ ಕುತ್ರಾಪಿ ತೈರ್ಜನೈಃ| ಮತ್ತಸ್ತೇ ಮನುಜಾಃ ಸ್ವಸ್ಥಾ ಯಥಾ ನೈವ ಭವನ್ತಿ ಚ| ತಥಾ ತೇಷಾಂ ಮನುಷ್ಯಾಣಾಂ ಕ್ರಿಯನ್ತೇ ಸ್ಥೂಲಬುದ್ಧಯಃ| ಬಧಿರೀಭೂತಕರ್ಣಾಶ್ಚ ಜಾತಾಶ್ಚ ಮುದ್ರಿತಾ ದೃಶಃ| ");
INSERT INTO sankan_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ಯದೇತಾನಿ ವಚನಾನಿ ಯಿಶಯಿಯಭವಿಷ್ಯದ್ವಾದಿನಾ ಪ್ರೋಕ್ತಾನಿ ತೇಷು ತಾನಿ ಫಲನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","ಕಿನ್ತು ಯುಷ್ಮಾಕಂ ನಯನಾನಿ ಧನ್ಯಾನಿ, ಯಸ್ಮಾತ್ ತಾನಿ ವೀಕ್ಷನ್ತೇ; ಧನ್ಯಾಶ್ಚ ಯುಷ್ಮಾಕಂ ಶಬ್ದಗ್ರಹಾಃ, ಯಸ್ಮಾತ್ ತೈರಾಕರ್ಣ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","ಮಯಾ ಯೂಯಂ ತಥ್ಯಂ ವಚಾಮಿ ಯುಷ್ಮಾಭಿ ರ್ಯದ್ಯದ್ ವೀಕ್ಷ್ಯತೇ, ತದ್ ಬಹವೋ ಭವಿಷ್ಯದ್ವಾದಿನೋ ಧಾರ್ಮ್ಮಿಕಾಶ್ಚ ಮಾನವಾ ದಿದೃಕ್ಷನ್ತೋಪಿ ದ್ರಷ್ಟುಂ ನಾಲಭನ್ತ, ಪುನಶ್ಚ ಯೂಯಂ ಯದ್ಯತ್ ಶೃಣುಥ, ತತ್ ತೇ ಶುಶ್ರೂಷಮಾಣಾ ಅಪಿ ಶ್ರೋತುಂ ನಾಲಭನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","ಕೃಷೀವಲೀಯದೃಷ್ಟಾನ್ತಸ್ಯಾರ್ಥಂ ಶೃಣುತ| ");
INSERT INTO sankan_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","ಮಾರ್ಗಪಾರ್ಶ್ವೇ ಬೀಜಾನ್ಯುಪ್ತಾನಿ ತಸ್ಯಾರ್ಥ ಏಷಃ, ಯದಾ ಕಶ್ಚಿತ್ ರಾಜ್ಯಸ್ಯ ಕಥಾಂ ನಿಶಮ್ಯ ನ ಬುಧ್ಯತೇ, ತದಾ ಪಾಪಾತ್ಮಾಗತ್ಯ ತದೀಯಮನಸ ಉಪ್ತಾಂ ಕಥಾಂ ಹರನ್ ನಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","ಅಪರಂ ಪಾಷಾಣಸ್ಥಲೇ ಬೀಜಾನ್ಯುಪ್ತಾನಿ ತಸ್ಯಾರ್ಥ ಏಷಃ; ಕಶ್ಚಿತ್ ಕಥಾಂ ಶ್ರುತ್ವೈವ ಹರ್ಷಚಿತ್ತೇನ ಗೃಹ್ಲಾತಿ, ");
INSERT INTO sankan_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ಕಿನ್ತು ತಸ್ಯ ಮನಸಿ ಮೂಲಾಪ್ರವಿಷ್ಟತ್ವಾತ್ ಸ ಕಿಞ್ಚಿತ್ಕಾಲಮಾತ್ರಂ ಸ್ಥಿರಸ್ತಿಷ್ಠತಿ; ಪಶ್ಚಾತ ತತ್ಕಥಾಕಾರಣಾತ್ ಕೋಪಿ ಕ್ಲೇಸ್ತಾಡನಾ ವಾ ಚೇತ್ ಜಾಯತೇ, ತರ್ಹಿ ಸ ತತ್ಕ್ಷಣಾದ್ ವಿಘ್ನಮೇತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","ಅಪರಂ ಕಣ್ಟಕಾನಾಂ ಮಧ್ಯೇ ಬೀಜಾನ್ಯುಪ್ತಾನಿ ತದರ್ಥ ಏಷಃ; ಕೇನಚಿತ್ ಕಥಾಯಾಂ ಶ್ರುತಾಯಾಂ ಸಾಂಸಾರಿಕಚಿನ್ತಾಭಿ ರ್ಭ್ರಾನ್ತಿಭಿಶ್ಚ ಸಾ ಗ್ರಸ್ಯತೇ, ತೇನ ಸಾ ಮಾ ವಿಫಲಾ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ಅಪರಮ್ ಉರ್ವ್ವರಾಯಾಂ ಬೀಜಾನ್ಯುಪ್ತಾನಿ ತದರ್ಥ ಏಷಃ; ಯೇ ತಾಂ ಕಥಾಂ ಶ್ರುತ್ವಾ ವುಧ್ಯನ್ತೇ, ತೇ ಫಲಿತಾಃ ಸನ್ತಃ ಕೇಚಿತ್ ಶತಗುಣಾನಿ ಕೇಚಿತ ಷಷ್ಟಿಗುಣಾನಿ ಕೇಚಿಚ್ಚ ತ್ರಿಂಶದ್ಗುಣಾನಿ ಫಲಾನಿ ಜನಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ಅನನ್ತರಂ ಸೋಪರಾಮೇಕಾಂ ದೃಷ್ಟಾನ್ತಕಥಾಮುಪಸ್ಥಾಪ್ಯ ತೇಭ್ಯಃ ಕಥಯಾಮಾಸ; ಸ್ವರ್ಗೀಯರಾಜ್ಯಂ ತಾದೃಶೇನ ಕೇನಚಿದ್ ಗೃಹಸ್ಥೇನೋಪಮೀಯತೇ, ಯೇನ ಸ್ವೀಯಕ್ಷೇತ್ರೇ ಪ್ರಶಸ್ತಬೀಜಾನ್ಯೌಪ್ಯನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ಕಿನ್ತು ಕ್ಷಣದಾಯಾಂ ಸಕಲಲೋಕೇಷು ಸುಪ್ತೇಷು ತಸ್ಯ ರಿಪುರಾಗತ್ಯ ತೇಷಾಂ ಗೋಧೂಮಬೀಜಾನಾಂ ಮಧ್ಯೇ ವನ್ಯಯವಮಬೀಜಾನ್ಯುಪ್ತ್ವಾ ವವ್ರಾಜ| ");
INSERT INTO sankan_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ತತೋ ಯದಾ ಬೀಜೇಭ್ಯೋಽಙ್ಕರಾ ಜಾಯಮಾನಾಃ ಕಣಿಶಾನಿ ಘೃತವನ್ತಃ; ತದಾ ವನ್ಯಯವಸಾನ್ಯಪಿ ದೃಶ್ಯಮಾನಾನ್ಯಭವನ್| ");
INSERT INTO sankan_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ತತೋ ಗೃಹಸ್ಥಸ್ಯ ದಾಸೇಯಾ ಆಗಮ್ಯ ತಸ್ಮೈ ಕಥಯಾಞ್ಚಕ್ರುಃ, ಹೇ ಮಹೇಚ್ಛ, ಭವತಾ ಕಿಂ ಕ್ಷೇತ್ರೇ ಭದ್ರಬೀಜಾನಿ ನೌಪ್ಯನ್ತ? ತಥಾತ್ವೇ ವನ್ಯಯವಸಾನಿ ಕೃತ ಆಯನ್? ");
INSERT INTO sankan_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","ತದಾನೀಂ ತೇನ ತೇ ಪ್ರತಿಗದಿತಾಃ, ಕೇನಚಿತ್ ರಿಪುಣಾ ಕರ್ಮ್ಮದಮಕಾರಿ| ದಾಸೇಯಾಃ ಕಥಯಾಮಾಸುಃ, ವಯಂ ಗತ್ವಾ ತಾನ್ಯುತ್ಪಾಯ್ಯ ಕ್ಷಿಪಾಮೋ ಭವತಃ ಕೀದೃಶೀಚ್ಛಾ ಜಾಯತೇ? ");
INSERT INTO sankan_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","ತೇನಾವಾದಿ, ನಹಿ, ಶಙ್ಕೇಽಹಂ ವನ್ಯಯವಸೋತ್ಪಾಟನಕಾಲೇ ಯುಷ್ಮಾಭಿಸ್ತೈಃ ಸಾಕಂ ಗೋಧೂಮಾ ಅಪ್ಯುತ್ಪಾಟಿಷ್ಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ಅತಃ ಶ್ಸ್ಯಕರ್ತ್ತನಕಾಲಂ ಯಾವದ್ ಉಭಯಾನ್ಯಪಿ ಸಹ ವರ್ದ್ಧನ್ತಾಂ, ಪಶ್ಚಾತ್ ಕರ್ತ್ತನಕಾಲೇ ಕರ್ತ್ತಕಾನ್ ವಕ್ಷ್ಯಾಮಿ, ಯೂಯಮಾದೌ ವನ್ಯಯವಸಾನಿ ಸಂಗೃಹ್ಯ ದಾಹಯಿತುಂ ವೀಟಿಕಾ ಬದ್ವ್ವಾ ಸ್ಥಾಪಯತ; ಕಿನ್ತು ಸರ್ವ್ವೇ ಗೋಧೂಮಾ ಯುಷ್ಮಾಭಿ ರ್ಭಾಣ್ಡಾಗಾರಂ ನೀತ್ವಾ ಸ್ಥಾಪ್ಯನ್ತಾಮ್| ");
INSERT INTO sankan_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ಅನನ್ತರಂ ಸೋಪರಾಮೇಕಾಂ ದೃಷ್ಟಾನ್ತಕಥಾಮುತ್ಥಾಪ್ಯ ತೇಭ್ಯಃ ಕಥಿತವಾನ್ ಕಶ್ಚಿನ್ಮನುಜಃ ಸರ್ಷಪಬೀಜಮೇಕಂ ನೀತ್ವಾ ಸ್ವಕ್ಷೇತ್ರ ಉವಾಪ| ");
INSERT INTO sankan_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","ಸರ್ಷಪಬೀಜಂ ಸರ್ವ್ವಸ್ಮಾದ್ ಬೀಜಾತ್ ಕ್ಷುದ್ರಮಪಿ ಸದಙ್ಕುರಿತಂ ಸರ್ವ್ವಸ್ಮಾತ್ ಶಾಕಾತ್ ಬೃಹದ್ ಭವತಿ; ಸ ತಾದೃಶಸ್ತರು ರ್ಭವತಿ, ಯಸ್ಯ ಶಾಖಾಸು ನಭಸಃ ಖಗಾ ಆಗತ್ಯ ನಿವಸನ್ತಿ; ಸ್ವರ್ಗೀಯರಾಜ್ಯಂ ತಾದೃಶಸ್ಯ ಸರ್ಷಪೈಕಸ್ಯ ಸಮಮ್| ");
INSERT INTO sankan_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ಪುನರಪಿ ಸ ಉಪಮಾಕಥಾಮೇಕಾಂ ತೇಭ್ಯಃ ಕಥಯಾಞ್ಚಕಾರ; ಕಾಚನ ಯೋಷಿತ್ ಯತ್ ಕಿಣ್ವಮಾದಾಯ ದ್ರೋಣತ್ರಯಮಿತಗೋಧೂಮಚೂರ್ಣಾನಾಂ ಮಧ್ಯೇ ಸರ್ವ್ವೇಷಾಂ ಮಿಶ್ರೀಭವನಪರ್ಯ್ಯನ್ತಂ ಸಮಾಚ್ಛಾದ್ಯ ನಿಧತ್ತವತೀ, ತತ್ಕಿಣ್ವಮಿವ ಸ್ವರ್ಗರಾಜ್ಯಂ| ");
INSERT INTO sankan_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ಇತ್ಥಂ ಯೀಶು ರ್ಮನುಜನಿವಹಾನಾಂ ಸನ್ನಿಧಾವುಪಮಾಕಥಾಭಿರೇತಾನ್ಯಾಖ್ಯಾನಾನಿ ಕಥಿತವಾನ್ ಉಪಮಾಂ ವಿನಾ ತೇಭ್ಯಃ ಕಿಮಪಿ ಕಥಾಂ ನಾಕಥಯತ್| ");
INSERT INTO sankan_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ಏತೇನ ದೃಷ್ಟಾನ್ತೀಯೇನ ವಾಕ್ಯೇನ ವ್ಯಾದಾಯ ವದನಂ ನಿಜಂ| ಅಹಂ ಪ್ರಕಾಶಯಿಷ್ಯಾಮಿ ಗುಪ್ತವಾಕ್ಯಂ ಪುರಾಭವಂ| ಯದೇತದ್ವಚನಂ ಭವಿಷ್ಯದ್ವಾದಿನಾ ಪ್ರೋಕ್ತಮಾಸೀತ್, ತತ್ ಸಿದ್ಧಮಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","ಸರ್ವ್ವಾನ್ ಮನುಜಾನ್ ವಿಸೃಜ್ಯ ಯೀಶೌ ಗೃಹಂ ಪ್ರವಿಷ್ಟೇ ತಚ್ಛಿಷ್ಯಾ ಆಗತ್ಯ ಯೀಶವೇ ಕಥಿತವನ್ತಃ, ಕ್ಷೇತ್ರಸ್ಯ ವನ್ಯಯವಸೀಯದೃಷ್ಟಾನ್ತಕಥಾಮ್ ಭವಾನ ಅಸ್ಮಾನ್ ಸ್ಪಷ್ಟೀಕೃತ್ಯ ವದತು| ");
INSERT INTO sankan_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ತತಃ ಸ ಪ್ರತ್ಯುವಾಚ, ಯೇನ ಭದ್ರಬೀಜಾನ್ಯುಪ್ಯನ್ತೇ ಸ ಮನುಜಪುತ್ರಃ, ");
INSERT INTO sankan_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ಕ್ಷೇತ್ರಂ ಜಗತ್, ಭದ್ರಬೀಜಾನೀ ರಾಜ್ಯಸ್ಯ ಸನ್ತಾನಾಃ, ");
INSERT INTO sankan_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ವನ್ಯಯವಸಾನಿ ಪಾಪಾತ್ಮನಃ ಸನ್ತಾನಾಃ| ಯೇನ ರಿಪುಣಾ ತಾನ್ಯುಪ್ತಾನಿ ಸ ಶಯತಾನಃ, ಕರ್ತ್ತನಸಮಯಶ್ಚ ಜಗತಃ ಶೇಷಃ, ಕರ್ತ್ತಕಾಃ ಸ್ವರ್ಗೀಯದೂತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","ಯಥಾ ವನ್ಯಯವಸಾನಿ ಸಂಗೃಹ್ಯ ದಾಹ್ಯನ್ತೇ, ತಥಾ ಜಗತಃ ಶೇಷೇ ಭವಿಷ್ಯತಿ; ");
INSERT INTO sankan_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","ಅರ್ಥಾತ್ ಮನುಜಸುತಃ ಸ್ವಾಂಯದೂತಾನ್ ಪ್ರೇಷಯಿಷ್ಯತಿ, ತೇನ ತೇ ಚ ತಸ್ಯ ರಾಜ್ಯಾತ್ ಸರ್ವ್ವಾನ್ ವಿಘ್ನಕಾರಿಣೋಽಧಾರ್ಮ್ಮಿಕಲೋಕಾಂಶ್ಚ ಸಂಗೃಹ್ಯ ");
INSERT INTO sankan_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ಯತ್ರ ರೋದನಂ ದನ್ತಘರ್ಷಣಞ್ಚ ಭವತಿ, ತತ್ರಾಗ್ನಿಕುಣ್ಡೇ ನಿಕ್ಷೇಪ್ಸ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","ತದಾನೀಂ ಧಾರ್ಮ್ಮಿಕಲೋಕಾಃ ಸ್ವೇಷಾಂ ಪಿತೂ ರಾಜ್ಯೇ ಭಾಸ್ಕರಇವ ತೇಜಸ್ವಿನೋ ಭವಿಷ್ಯನ್ತಿ| ಶ್ರೋತುಂ ಯಸ್ಯ ಶ್ರುತೀ ಆಸಾತೇ, ಮ ಶೃಣುಯಾತ್| ");
INSERT INTO sankan_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","ಅಪರಞ್ಚ ಕ್ಷೇತ್ರಮಧ್ಯೇ ನಿಧಿಂ ಪಶ್ಯನ್ ಯೋ ಗೋಪಯತಿ, ತತಃ ಪರಂ ಸಾನನ್ದೋ ಗತ್ವಾ ಸ್ವೀಯಸರ್ವ್ವಸ್ವಂ ವಿಕ್ರೀಯ ತ್ತಕ್ಷೇತ್ರಂ ಕ್ರೀಣಾತಿ, ಸ ಇವ ಸ್ವರ್ಗರಾಜ್ಯಂ| ");
INSERT INTO sankan_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","ಅನ್ಯಞ್ಚ ಯೋ ವಣಿಕ್ ಉತ್ತಮಾಂ ಮುಕ್ತಾಂ ಗವೇಷಯನ್ ");
INSERT INTO sankan_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ಮಹಾರ್ಘಾಂ ಮುಕ್ತಾಂ ವಿಲೋಕ್ಯ ನಿಜಸರ್ವ್ವಸ್ವಂ ವಿಕ್ರೀಯ ತಾಂ ಕ್ರೀಣಾತಿ, ಸ ಇವ ಸ್ವರ್ಗರಾಜ್ಯಂ| ");
INSERT INTO sankan_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","ಪುನಶ್ಚ ಸಮುದ್ರೋ ನಿಕ್ಷಿಪ್ತಃ ಸರ್ವ್ವಪ್ರಕಾರಮೀನಸಂಗ್ರಾಹ್ಯಾನಾಯಇವ ಸ್ವರ್ಗರಾಜ್ಯಂ| ");
INSERT INTO sankan_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ತಸ್ಮಿನ್ ಆನಾಯೇ ಪೂರ್ಣೇ ಜನಾ ಯಥಾ ರೋಧಸ್ಯುತ್ತೋಲ್ಯ ಸಮುಪವಿಶ್ಯ ಪ್ರಶಸ್ತಮೀನಾನ್ ಸಂಗ್ರಹ್ಯ ಭಾಜನೇಷು ನಿದಧತೇ, ಕುತ್ಸಿತಾನ್ ನಿಕ್ಷಿಪನ್ತಿ; ");
INSERT INTO sankan_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","ತಥೈವ ಜಗತಃ ಶೇಷೇ ಭವಿಷ್ಯತಿ, ಫಲತಃ ಸ್ವರ್ಗೀಯದೂತಾ ಆಗತ್ಯ ಪುಣ್ಯವಜ್ಜನಾನಾಂ ಮಧ್ಯಾತ್ ಪಾಪಿನಃ ಪೃಥಕ್ ಕೃತ್ವಾ ವಹ್ನಿಕುಣ್ಡೇ ನಿಕ್ಷೇಪ್ಸ್ಯನ್ತಿ, ");
INSERT INTO sankan_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ತತ್ರ ರೋದನಂ ದನ್ತೈ ರ್ದನ್ತಘರ್ಷಣಞ್ಚ ಭವಿಷ್ಯತಃ| ");
INSERT INTO sankan_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","ಯೀಶುನಾ ತೇ ಪೃಷ್ಟಾ ಯುಷ್ಮಾಭಿಃ ಕಿಮೇತಾನ್ಯಾಖ್ಯಾನಾನ್ಯಬುಧ್ಯನ್ತ? ತದಾ ತೇ ಪ್ರತ್ಯವದನ್, ಸತ್ಯಂ ಪ್ರಭೋ| ");
INSERT INTO sankan_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ತದಾನೀಂ ಸ ಕಥಿತವಾನ್, ನಿಜಭಾಣ್ಡಾಗಾರಾತ್ ನವೀನಪುರಾತನಾನಿ ವಸ್ತೂನಿ ನಿರ್ಗಮಯತಿ ಯೋ ಗೃಹಸ್ಥಃ ಸ ಇವ ಸ್ವರ್ಗರಾಜ್ಯಮಧಿ ಶಿಕ್ಷಿತಾಃ ಸ್ವರ್ವ ಉಪದೇಷ್ಟಾರಃ| ");
INSERT INTO sankan_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","ಅನನ್ತರಂ ಯೀಶುರೇತಾಃ ಸರ್ವ್ವಾ ದೃಷ್ಟಾನ್ತಕಥಾಃ ಸಮಾಪ್ಯ ತಸ್ಮಾತ್ ಸ್ಥಾನಾತ್ ಪ್ರತಸ್ಥೇ| ಅಪರಂ ಸ್ವದೇಶಮಾಗತ್ಯ ಜನಾನ್ ಭಜನಭವನ ಉಪದಿಷ್ಟವಾನ್; ");
INSERT INTO sankan_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ತೇ ವಿಸ್ಮಯಂ ಗತ್ವಾ ಕಥಿತವನ್ತ ಏತಸ್ಯೈತಾದೃಶಂ ಜ್ಞಾನಮ್ ಆಶ್ಚರ್ಯ್ಯಂ ಕರ್ಮ್ಮ ಚ ಕಸ್ಮಾದ್ ಅಜಾಯತ? ");
INSERT INTO sankan_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","ಕಿಮಯಂ ಸೂತ್ರಧಾರಸ್ಯ ಪುತ್ರೋ ನಹಿ? ಏತಸ್ಯ ಮಾತು ರ್ನಾಮ ಚ ಕಿಂ ಮರಿಯಮ್ ನಹಿ? ಯಾಕುಬ್-ಯೂಷಫ್-ಶಿಮೋನ್-ಯಿಹೂದಾಶ್ಚ ಕಿಮೇತಸ್ಯ ಭ್ರಾತರೋ ನಹಿ? ");
INSERT INTO sankan_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ಏತಸ್ಯ ಭಗಿನ್ಯಶ್ಚ ಕಿಮಸ್ಮಾಕಂ ಮಧ್ಯೇ ನ ಸನ್ತಿ? ತರ್ಹಿ ಕಸ್ಮಾದಯಮೇತಾನಿ ಲಬ್ಧವಾನ್? ಇತ್ಥಂ ಸ ತೇಷಾಂ ವಿಘ್ನರೂಪೋ ಬಭೂವ; ");
INSERT INTO sankan_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ತತೋ ಯೀಶುನಾ ನಿಗದಿತಂ ಸ್ವದೇಶೀಯಜನಾನಾಂ ಮಧ್ಯಂ ವಿನಾ ಭವಿಷ್ಯದ್ವಾದೀ ಕುತ್ರಾಪ್ಯನ್ಯತ್ರ ನಾಸಮ್ಮಾನ್ಯೋ ಭವತೀ| ");
INSERT INTO sankan_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","ತೇಷಾಮವಿಶ್ವಾಸಹೇತೋಃ ಸ ತತ್ರ ಸ್ಥಾನೇ ಬಹ್ವಾಶ್ಚರ್ಯ್ಯಕರ್ಮ್ಮಾಣಿ ನ ಕೃತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","ತದಾನೀಂ ರಾಜಾ ಹೇರೋದ್ ಯೀಶೋ ರ್ಯಶಃ ಶ್ರುತ್ವಾ ನಿಜದಾಸೇಯಾನ್ ಜಗಾದ್, ");
INSERT INTO sankan_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ಏಷ ಮಜ್ಜಯಿತಾ ಯೋಹನ್, ಪ್ರಮಿತೇಭಯಸ್ತಸ್ಯೋತ್ಥಾನಾತ್ ತೇನೇತ್ಥಮದ್ಭುತಂ ಕರ್ಮ್ಮ ಪ್ರಕಾಶ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","ಪುರಾ ಹೇರೋದ್ ನಿಜಭ್ರಾತು: ಫಿಲಿಪೋ ಜಾಯಾಯಾ ಹೇರೋದೀಯಾಯಾ ಅನುರೋಧಾದ್ ಯೋಹನಂ ಧಾರಯಿತ್ವಾ ಬದ್ಧಾ ಕಾರಾಯಾಂ ಸ್ಥಾಪಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ಯತೋ ಯೋಹನ್ ಉಕ್ತವಾನ್, ಏತ್ಸಯಾಃ ಸಂಗ್ರಹೋ ಭವತೋ ನೋಚಿತಃ| ");
INSERT INTO sankan_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ತಸ್ಮಾತ್ ನೃಪತಿಸ್ತಂ ಹನ್ತುಮಿಚ್ಛನ್ನಪಿ ಲೋಕೇಭ್ಯೋ ವಿಭಯಾಞ್ಚಕಾರ; ಯತಃ ಸರ್ವ್ವೇ ಯೋಹನಂ ಭವಿಷ್ಯದ್ವಾದಿನಂ ಮೇನಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","ಕಿನ್ತು ಹೇರೋದೋ ಜನ್ಮಾಹೀಯಮಹ ಉಪಸ್ಥಿತೇ ಹೇರೋದೀಯಾಯಾ ದುಹಿತಾ ತೇಷಾಂ ಸಮಕ್ಷಂ ನೃತಿತ್ವಾ ಹೇರೋದಮಪ್ರೀಣ್ಯತ್| ");
INSERT INTO sankan_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ತಸ್ಮಾತ್ ಭೂಪತಿಃ ಶಪಥಂ ಕುರ್ವ್ವನ್ ಇತಿ ಪ್ರತ್ಯಜ್ಞಾಸೀತ್, ತ್ವಯಾ ಯದ್ ಯಾಚ್ಯತೇ, ತದೇವಾಹಂ ದಾಸ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","ಸಾ ಕುಮಾರೀ ಸ್ವೀಯಮಾತುಃ ಶಿಕ್ಷಾಂ ಲಬ್ಧಾ ಬಭಾಷೇ, ಮಜ್ಜಯಿತುರ್ಯೋಹನ ಉತ್ತಮಾಙ್ಗಂ ಭಾಜನೇ ಸಮಾನೀಯ ಮಹ್ಯಂ ವಿಶ್ರಾಣಯ| ");
INSERT INTO sankan_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ತತೋ ರಾಜಾ ಶುಶೋಚ, ಕಿನ್ತು ಭೋಜನಾಯೋಪವಿಶತಾಂ ಸಙ್ಗಿನಾಂ ಸ್ವಕೃತಶಪಥಸ್ಯ ಚಾನುರೋಧಾತ್ ತತ್ ಪ್ರದಾತುಮ ಆದಿದೇಶ| ");
INSERT INTO sankan_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ಪಶ್ಚಾತ್ ಕಾರಾಂ ಪ್ರತಿ ನರಂ ಪ್ರಹಿತ್ಯ ಯೋಹನ ಉತ್ತಮಾಙ್ಗಂ ಛಿತ್ತ್ವಾ ");
INSERT INTO sankan_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ತತ್ ಭಾಜನ ಆನಾಯ್ಯ ತಸ್ಯೈ ಕುಮಾರ್ಯ್ಯೈ ವ್ಯಶ್ರಾಣಯತ್, ತತಃ ಸಾ ಸ್ವಜನನ್ಯಾಃ ಸಮೀಪಂ ತನ್ನಿನಾಯ| ");
INSERT INTO sankan_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ಪಶ್ಚಾತ್ ಯೋಹನಃ ಶಿಷ್ಯಾ ಆಗತ್ಯ ಕಾಯಂ ನೀತ್ವಾ ಶ್ಮಶಾನೇ ಸ್ಥಾಪಯಾಮಾಸುಸ್ತತೋ ಯೀಶೋಃ ಸನ್ನಿಧಿಂ ವ್ರಜಿತ್ವಾ ತದ್ವಾರ್ತ್ತಾಂ ಬಭಾಷಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","ಅನನ್ತರಂ ಯೀಶುರಿತಿ ನಿಶಭ್ಯ ನಾವಾ ನಿರ್ಜನಸ್ಥಾನಮ್ ಏಕಾಕೀ ಗತವಾನ್, ಪಶ್ಚಾತ್ ಮಾನವಾಸ್ತತ್ ಶ್ರುತ್ವಾ ನಾನಾನಗರೇಭ್ಯ ಆಗತ್ಯ ಪದೈಸ್ತತ್ಪಶ್ಚಾದ್ ಈಯುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ತದಾನೀಂ ಯೀಶು ರ್ಬಹಿರಾಗತ್ಯ ಮಹಾನ್ತಂ ಜನನಿವಹಂ ನಿರೀಕ್ಷ್ಯ ತೇಷು ಕಾರುಣಿಕಃ ಮನ್ ತೇಷಾಂ ಪೀಡಿತಜನಾನ್ ನಿರಾಮಯಾನ್ ಚಕಾರ| ");
INSERT INTO sankan_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ತತಃ ಪರಂ ಸನ್ಧ್ಯಾಯಾಂ ಶಿಷ್ಯಾಸ್ತದನ್ತಿಕಮಾಗತ್ಯ ಕಥಯಾಞ್ಚಕ್ರುಃ, ಇದಂ ನಿರ್ಜನಸ್ಥಾನಂ ವೇಲಾಪ್ಯವಸನ್ನಾ; ತಸ್ಮಾತ್ ಮನುಜಾನ್ ಸ್ವಸ್ವಗ್ರಾಮಂ ಗನ್ತುಂ ಸ್ವಾರ್ಥಂ ಭಕ್ಷ್ಯಾಣಿ ಕ್ರೇತುಞ್ಚ ಭವಾನ್ ತಾನ್ ವಿಸೃಜತು| ");
INSERT INTO sankan_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","ಕಿನ್ತು ಯೀಶುಸ್ತಾನವಾದೀತ್, ತೇಷಾಂ ಗಮನೇ ಪ್ರಯೋಜನಂ ನಾಸ್ತಿ, ಯೂಯಮೇವ ತಾನ್ ಭೋಜಯತ| ");
INSERT INTO sankan_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ತದಾ ತೇ ಪ್ರತ್ಯವದನ್, ಅಸ್ಮಾಕಮತ್ರ ಪೂಪಪಞ್ಚಕಂ ಮೀನದ್ವಯಞ್ಚಾಸ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ತದಾನೀಂ ತೇನೋಕ್ತಂ ತಾನಿ ಮದನ್ತಿಕಮಾನಯತ| ");
INSERT INTO sankan_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ಅನನ್ತರಂ ಸ ಮನುಜಾನ್ ಯವಸೋಪರ್ಯ್ಯುಪವೇಷ್ಟುಮ್ ಆಜ್ಞಾಪಯಾಮಾಸ; ಅಪರ ತತ್ ಪೂಪಪಞ್ಚಕಂ ಮೀನದ್ವಯಞ್ಚ ಗೃಹ್ಲನ್ ಸ್ವರ್ಗಂ ಪ್ರತಿ ನಿರೀಕ್ಷ್ಯೇಶ್ವರೀಯಗುಣಾನ್ ಅನೂದ್ಯ ಭಂಕ್ತ್ವಾ ಶಿಷ್ಯೇಭ್ಯೋ ದತ್ತವಾನ್, ಶಿಷ್ಯಾಶ್ಚ ಲೋಕೇಭ್ಯೋ ದದುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ತತಃ ಸರ್ವ್ವೇ ಭುಕ್ತ್ವಾ ಪರಿತೃಪ್ತವನ್ತಃ, ತತಸ್ತದವಶಿಷ್ಟಭಕ್ಷ್ಯೈಃ ಪೂರ್ಣಾನ್ ದ್ವಾದಶಡಲಕಾನ್ ಗೃಹೀತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","ತೇ ಭೋಕ್ತಾರಃ ಸ್ತ್ರೀರ್ಬಾಲಕಾಂಶ್ಚ ವಿಹಾಯ ಪ್ರಾಯೇಣ ಪಞ್ಚ ಸಹಸ್ರಾಣಿ ಪುಮಾಂಸ ಆಸನ್| ");
INSERT INTO sankan_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","ತದನನ್ತರಂ ಯೀಶು ರ್ಲೋಕಾನಾಂ ವಿಸರ್ಜನಕಾಲೇ ಶಿಷ್ಯಾನ್ ತರಣಿಮಾರೋಢುಂ ಸ್ವಾಗ್ರೇ ಪಾರಂ ಯಾತುಞ್ಚ ಗಾಢಮಾದಿಷ್ಟವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ತತೋ ಲೋಕೇಷು ವಿಸೃಷ್ಟೇಷು ಸ ವಿವಿಕ್ತೇ ಪ್ರಾರ್ಥಯಿತುಂ ಗಿರಿಮೇಕಂ ಗತ್ವಾ ಸನ್ಧ್ಯಾಂ ಯಾವತ್ ತತ್ರೈಕಾಕೀ ಸ್ಥಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ಕಿನ್ತು ತದಾನೀಂ ಸಮ್ಮುಖವಾತತ್ವಾತ್ ಸರಿತ್ಪತೇ ರ್ಮಧ್ಯೇ ತರಙ್ಗೈಸ್ತರಣಿರ್ದೋಲಾಯಮಾನಾಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","ತದಾ ಸ ಯಾಮಿನ್ಯಾಶ್ಚತುರ್ಥಪ್ರಹರೇ ಪದ್ಭ್ಯಾಂ ವ್ರಜನ್ ತೇಷಾಮನ್ತಿಕಂ ಗತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ಕಿನ್ತು ಶಿಷ್ಯಾಸ್ತಂ ಸಾಗರೋಪರಿ ವ್ರಜನ್ತಂ ವಿಲೋಕ್ಯ ಸಮುದ್ವಿಗ್ನಾ ಜಗದುಃ, ಏಷ ಭೂತ ಇತಿ ಶಙ್ಕಮಾನಾ ಉಚ್ಚೈಃ ಶಬ್ದಾಯಾಞ್ಚಕ್ರಿರೇ ಚ| ");
INSERT INTO sankan_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ತದೈವ ಯೀಶುಸ್ತಾನವದತ್, ಸುಸ್ಥಿರಾ ಭವತ, ಮಾ ಭೈಷ್ಟ, ಏಷೋಽಹಮ್| ");
INSERT INTO sankan_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","ತತಃ ಪಿತರ ಇತ್ಯುಕ್ತವಾನ್, ಹೇ ಪ್ರಭೋ, ಯದಿ ಭವಾನೇವ, ತರ್ಹಿ ಮಾಂ ಭವತ್ಸಮೀಪಂ ಯಾತುಮಾಜ್ಞಾಪಯತು| ");
INSERT INTO sankan_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ತತಃ ತೇನಾದಿಷ್ಟಃ ಪಿತರಸ್ತರಣಿತೋಽವರುಹ್ಯ ಯೀಶೇाರನ್ತಿಕಂ ಪ್ರಾಪ್ತುಂ ತೋಯೋಪರಿ ವವ್ರಾಜ| ");
INSERT INTO sankan_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ಕಿನ್ತು ಪ್ರಚಣ್ಡಂ ಪವನಂ ವಿಲೋಕ್ಯ ಭಯಾತ್ ತೋಯೇ ಮಂಕ್ತುಮ್ ಆರೇಭೇ, ತಸ್ಮಾದ್ ಉಚ್ಚೈಃ ಶಬ್ದಾಯಮಾನಃ ಕಥಿತವಾನ್, ಹೇ ಪ್ರಭೋ, ಮಾಮವತು| ");
INSERT INTO sankan_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ಯೀಶುಸ್ತತ್ಕ್ಷಣಾತ್ ಕರಂ ಪ್ರಸಾರ್ಯ್ಯ ತಂ ಧರನ್ ಉಕ್ತವಾನ್, ಹ ಸ್ತೋಕಪ್ರತ್ಯಯಿನ್ ತ್ವಂ ಕುತಃ ಸಮಶೇಥಾಃ? ");
INSERT INTO sankan_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","ಅನನ್ತರಂ ತಯೋಸ್ತರಣಿಮಾರೂಢಯೋಃ ಪವನೋ ನಿವವೃತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ತದಾನೀಂ ಯೇ ತರಣ್ಯಾಮಾಸನ್, ತ ಆಗತ್ಯ ತಂ ಪ್ರಣಭ್ಯ ಕಥಿತವನ್ತಃ, ಯಥಾರ್ಥಸ್ತ್ವಮೇವೇಶ್ವರಸುತಃ| ");
INSERT INTO sankan_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ಅನನ್ತರಂ ಪಾರಂ ಪ್ರಾಪ್ಯ ತೇ ಗಿನೇಷರನ್ನಾಮಕಂ ನಗರಮುಪತಸ್ಥುಃ, ");
INSERT INTO sankan_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ತದಾ ತತ್ರತ್ಯಾ ಜನಾ ಯೀಶುಂ ಪರಿಚೀಯ ತದ್ದೇಶ್ಸ್ಯ ಚತುರ್ದಿಶೋ ವಾರ್ತ್ತಾಂ ಪ್ರಹಿತ್ಯ ಯತ್ರ ಯಾವನ್ತಃ ಪೀಡಿತಾ ಆಸನ್, ತಾವತಏವ ತದನ್ತಿಕಮಾನಯಾಮಾಸುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ಅಪರಂ ತದೀಯವಸನಸ್ಯ ಗ್ರನ್ಥಿಮಾತ್ರಂ ಸ್ಪ್ರಷ್ಟುಂ ವಿನೀಯ ಯಾವನ್ತೋ ಜನಾಸ್ತತ್ ಸ್ಪರ್ಶಂ ಚಕ್ರಿರೇ, ತೇ ಸರ್ವ್ವಏವ ನಿರಾಮಯಾ ಬಭೂವುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","ಅಪರಂ ಯಿರೂಶಾಲಮ್ನಗರೀಯಾಃ ಕತಿಪಯಾ ಅಧ್ಯಾಪಕಾಃ ಫಿರೂಶಿನಶ್ಚ ಯೀಶೋಃ ಸಮೀಪಮಾಗತ್ಯ ಕಥಯಾಮಾಸುಃ, ");
INSERT INTO sankan_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","ತವ ಶಿಷ್ಯಾಃ ಕಿಮರ್ಥಮ್ ಅಪ್ರಕ್ಷಾಲಿತಕರೈ ರ್ಭಕ್ಷಿತ್ವಾ ಪರಮ್ಪರಾಗತಂ ಪ್ರಾಚೀನಾನಾಂ ವ್ಯವಹಾರಂ ಲಙ್ವನ್ತೇ? ");
INSERT INTO sankan_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ತತೋ ಯೀಶುಃ ಪ್ರತ್ಯುವಾಚ, ಯೂಯಂ ಪರಮ್ಪರಾಗತಾಚಾರೇಣ ಕುತ ಈಶ್ವರಾಜ್ಞಾಂ ಲಙ್ವಧ್ವೇ| ");
INSERT INTO sankan_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ಈಶ್ವರ ಇತ್ಯಾಜ್ಞಾಪಯತ್, ತ್ವಂ ನಿಜಪಿತರೌ ಸಂಮನ್ಯೇಥಾಃ, ಯೇನ ಚ ನಿಜಪಿತರೌ ನಿನ್ದ್ಯೇತೇ, ಸ ನಿಶ್ಚಿತಂ ಮ್ರಿಯೇತ; ");
INSERT INTO sankan_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","ಕಿನ್ತು ಯೂಯಂ ವದಥ, ಯಃ ಸ್ವಜನಕಂ ಸ್ವಜನನೀಂ ವಾ ವಾಕ್ಯಮಿದಂ ವದತಿ, ಯುವಾಂ ಮತ್ತೋ ಯಲ್ಲಭೇಥೇ, ತತ್ ನ್ಯವಿದ್ಯತ, ");
INSERT INTO sankan_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ಸ ನಿಜಪಿತರೌ ಪುನ ರ್ನ ಸಂಮಂಸ್ಯತೇ| ಇತ್ಥಂ ಯೂಯಂ ಪರಮ್ಪರಾಗತೇನ ಸ್ವೇಷಾಮಾಚಾರೇಣೇಶ್ವರೀಯಾಜ್ಞಾಂ ಲುಮ್ಪಥ| ");
INSERT INTO sankan_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ರೇ ಕಪಟಿನಃ ಸರ್ವ್ವೇ ಯಿಶಯಿಯೋ ಯುಷ್ಮಾನಧಿ ಭವಿಷ್ಯದ್ವಚನಾನ್ಯೇತಾನಿ ಸಮ್ಯಗ್ ಉಕ್ತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","ವದನೈ ರ್ಮನುಜಾ ಏತೇ ಸಮಾಯಾನ್ತಿ ಮದನ್ತಿಕಂ| ತಥಾಧರೈ ರ್ಮದೀಯಞ್ಚ ಮಾನಂ ಕುರ್ವ್ವನ್ತಿ ತೇ ನರಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ಕಿನ್ತು ತೇಷಾಂ ಮನೋ ಮತ್ತೋ ವಿದೂರಏವ ತಿಷ್ಠತಿ| ಶಿಕ್ಷಯನ್ತೋ ವಿಧೀನ್ ನ್ರಾಜ್ಞಾ ಭಜನ್ತೇ ಮಾಂ ಮುಧೈವ ತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ತತೋ ಯೀಶು ರ್ಲೋಕಾನ್ ಆಹೂಯ ಪ್ರೋಕ್ತವಾನ್, ಯೂಯಂ ಶ್ರುತ್ವಾ ಬುಧ್ಯಧ್ಬಂ| ");
INSERT INTO sankan_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ಯನ್ಮುಖಂ ಪ್ರವಿಶತಿ, ತತ್ ಮನುಜಮ್ ಅಮೇಧ್ಯಂ ನ ಕರೋತಿ, ಕಿನ್ತು ಯದಾಸ್ಯಾತ್ ನಿರ್ಗಚ್ಛತಿ, ತದೇವ ಮಾನುಷಮಮೇಧ್ಯೀ ಕರೋತೀ| ");
INSERT INTO sankan_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","ತದಾನೀಂ ಶಿಷ್ಯಾ ಆಗತ್ಯ ತಸ್ಮೈ ಕಥಯಾಞ್ಚಕ್ರುಃ, ಏತಾಂ ಕಥಾಂ ಶ್ರುತ್ವಾ ಫಿರೂಶಿನೋ ವ್ಯರಜ್ಯನ್ತ, ತತ್ ಕಿಂ ಭವತಾ ಜ್ಞಾಯತೇ? ");
INSERT INTO sankan_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ಸ ಪ್ರತ್ಯವದತ್, ಮಮ ಸ್ವರ್ಗಸ್ಥಃ ಪಿತಾ ಯಂ ಕಞ್ಚಿದಙ್ಕುರಂ ನಾರೋಪಯತ್, ಸ ಉತ್ಪಾವ್ದ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","ತೇ ತಿಷ್ಠನ್ತು, ತೇ ಅನ್ಧಮನುಜಾನಾಮ್ ಅನ್ಧಮಾರ್ಗದರ್ಶಕಾ ಏವ; ಯದ್ಯನ್ಧೋಽನ್ಧಂ ಪನ್ಥಾನಂ ದರ್ಶಯತಿ, ತರ್ಹ್ಯುಭೌ ಗರ್ತ್ತೇ ಪತತಃ| ");
INSERT INTO sankan_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ತದಾ ಪಿತರಸ್ತಂ ಪ್ರತ್ಯವದತ್, ದೃಷ್ಟಾನ್ತಮಿಮಮಸ್ಮಾನ್ ಬೋಧಯತು| ");
INSERT INTO sankan_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ಯೀಶುನಾ ಪ್ರೋಕ್ತಂ, ಯೂಯಮದ್ಯ ಯಾವತ್ ಕಿಮಬೋಧಾಃ ಸ್ಥ? ");
INSERT INTO sankan_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","ಕಥಾಮಿಮಾಂ ಕಿಂ ನ ಬುಧ್ಯಧ್ಬೇ ? ಯದಾಸ್ಯಂ ಪ್ರೇವಿಶತಿ, ತದ್ ಉದರೇ ಪತನ್ ಬಹಿರ್ನಿರ್ಯಾತಿ, ");
INSERT INTO sankan_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","ಕಿನ್ತ್ವಾಸ್ಯಾದ್ ಯನ್ನಿರ್ಯಾತಿ, ತದ್ ಅನ್ತಃಕರಣಾತ್ ನಿರ್ಯಾತತ್ವಾತ್ ಮನುಜಮಮೇಧ್ಯಂ ಕರೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","ಯತೋಽನ್ತಃಕರಣಾತ್ ಕುಚಿನ್ತಾ ಬಧಃ ಪಾರದಾರಿಕತಾ ವೇಶ್ಯಾಗಮನಂ ಚೈರ್ಯ್ಯಂ ಮಿಥ್ಯಾಸಾಕ್ಷ್ಯಮ್ ಈಶ್ವರನಿನ್ದಾ ಚೈತಾನಿ ಸರ್ವ್ವಾಣಿ ನಿರ್ಯ್ಯಾನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ಏತಾನಿ ಮನುಷ್ಯಮಪವಿತ್ರೀ ಕುರ್ವ್ವನ್ತಿ ಕಿನ್ತ್ವಪ್ರಕ್ಷಾಲಿತಕರೇಣ ಭೋಜನಂ ಮನುಜಮಮೇಧ್ಯಂ ನ ಕರೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ಅನನ್ತರಂ ಯೀಶುಸ್ತಸ್ಮಾತ್ ಸ್ಥಾನಾತ್ ಪ್ರಸ್ಥಾಯ ಸೋರಸೀದೋನ್ನಗರಯೋಃ ಸೀಮಾಮುಪತಸ್ಯೌ| ");
INSERT INTO sankan_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ತದಾ ತತ್ಸೀಮಾತಃ ಕಾಚಿತ್ ಕಿನಾನೀಯಾ ಯೋಷಿದ್ ಆಗತ್ಯ ತಮುಚ್ಚೈರುವಾಚ, ಹೇ ಪ್ರಭೋ ದಾಯೂದಃ ಸನ್ತಾನ, ಮಮೈಕಾ ದುಹಿತಾಸ್ತೇ ಸಾ ಭೂತಗ್ರಸ್ತಾ ಸತೀ ಮಹಾಕ್ಲೇಶಂ ಪ್ರಾಪ್ನೋತಿ ಮಮ ದಯಸ್ವ| ");
INSERT INTO sankan_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","ಕಿನ್ತು ಯೀಶುಸ್ತಾಂ ಕಿಮಪಿ ನೋಕ್ತವಾನ್, ತತಃ ಶಿಷ್ಯಾ ಆಗತ್ಯ ತಂ ನಿವೇದಯಾಮಾಸುಃ, ಏಷಾ ಯೋಷಿದ್ ಅಸ್ಮಾಕಂ ಪಶ್ಚಾದ್ ಉಚ್ಚೈರಾಹೂಯಾಗಚ್ಛತಿ, ಏನಾಂ ವಿಸೃಜತು| ");
INSERT INTO sankan_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ತದಾ ಸ ಪ್ರತ್ಯವದತ್, ಇಸ್ರಾಯೇಲ್ಗೋತ್ರಸ್ಯ ಹಾರಿತಮೇಷಾನ್ ವಿನಾ ಕಸ್ಯಾಪ್ಯನ್ಯಸ್ಯ ಸಮೀಪಂ ನಾಹಂ ಪ್ರೇಷಿತೋಸ್ಮಿ| ");
INSERT INTO sankan_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","ತತಃ ಸಾ ನಾರೀಸಮಾಗತ್ಯ ತಂ ಪ್ರಣಮ್ಯ ಜಗಾದ, ಹೇ ಪ್ರಭೋ ಮಾಮುಪಕುರು| ");
INSERT INTO sankan_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ಸ ಉಕ್ತವಾನ್, ಬಾಲಕಾನಾಂ ಭಕ್ಷ್ಯಮಾದಾಯ ಸಾರಮೇಯೇಭ್ಯೋ ದಾನಂ ನೋಚಿತಂ| ");
INSERT INTO sankan_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ತದಾ ಸಾ ಬಭಾಷೇ, ಹೇ ಪ್ರಭೋ, ತತ್ ಸತ್ಯಂ, ತಥಾಪಿ ಪ್ರಭೋ ರ್ಭಞ್ಚಾದ್ ಯದುಚ್ಛಿಷ್ಟಂ ಪತತಿ, ತತ್ ಸಾರಮೇಯಾಃ ಖಾದನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ತತೋ ಯೀಶುಃ ಪ್ರತ್ಯವದತ್, ಹೇ ಯೋಷಿತ್, ತವ ವಿಶ್ವಾಸೋ ಮಹಾನ್ ತಸ್ಮಾತ್ ತವ ಮನೋಭಿಲಷಿತಂ ಸಿದ್ಯ್ಯತು, ತೇನ ತಸ್ಯಾಃ ಕನ್ಯಾ ತಸ್ಮಿನ್ನೇವ ದಣ್ಡೇ ನಿರಾಮಯಾಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ಅನನ್ತರಂ ಯೀಶಸ್ತಸ್ಮಾತ್ ಸ್ಥಾನಾತ್ ಪ್ರಸ್ಥಾಯ ಗಾಲೀಲ್ಸಾಗರಸ್ಯ ಸನ್ನಿಧಿಮಾಗತ್ಯ ಧರಾಧರಮಾರುಹ್ಯ ತತ್ರೋಪವಿವೇಶ| ");
INSERT INTO sankan_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ಪಶ್ಚಾತ್ ಜನನಿವಹೋ ಬಹೂನ್ ಖಞ್ಚಾನ್ಧಮೂಕಶುಷ್ಕಕರಮಾನುಷಾನ್ ಆದಾಯ ಯೀಶೋಃ ಸಮೀಪಮಾಗತ್ಯ ತಚ್ಚರಣಾನ್ತಿಕೇ ಸ್ಥಾಪಯಾಮಾಸುಃ, ತತಃ ಸಾ ತಾನ್ ನಿರಾಮಯಾನ್ ಅಕರೋತ್| ");
INSERT INTO sankan_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ಇತ್ಥಂ ಮೂಕಾ ವಾಕ್ಯಂ ವದನ್ತಿ, ಶುಷ್ಕಕರಾಃ ಸ್ವಾಸ್ಥ್ಯಮಾಯಾನ್ತಿ, ಪಙ್ಗವೋ ಗಚ್ಛನ್ತಿ, ಅನ್ಧಾ ವೀಕ್ಷನ್ತೇ, ಇತಿ ವಿಲೋಕ್ಯ ಲೋಕಾ ವಿಸ್ಮಯಂ ಮನ್ಯಮಾನಾ ಇಸ್ರಾಯೇಲ ಈಶ್ವರಂ ಧನ್ಯಂ ಬಭಾಷಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","ತದಾನೀಂ ಯೀಶುಃ ಸ್ವಶಿಷ್ಯಾನ್ ಆಹೂಯ ಗದಿತವಾನ್, ಏತಜ್ಜನನಿವಹೇಷು ಮಮ ದಯಾ ಜಾಯತೇ, ಏತೇ ದಿನತ್ರಯಂ ಮಯಾ ಸಾಕಂ ಸನ್ತಿ, ಏಷಾಂ ಭಕ್ಷ್ಯವಸ್ತು ಚ ಕಞ್ಚಿದಪಿ ನಾಸ್ತಿ, ತಸ್ಮಾದಹಮೇತಾನಕೃತಾಹಾರಾನ್ ನ ವಿಸ್ರಕ್ಷ್ಯಾಮಿ, ತಥಾತ್ವೇ ವರ್ತ್ಮಮಧ್ಯೇ ಕ್ಲಾಮ್ಯೇಷುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","ತದಾ ಶಿಷ್ಯಾ ಊಚುಃ, ಏತಸ್ಮಿನ್ ಪ್ರಾನ್ತರಮಧ್ಯ ಏತಾವತೋ ಮರ್ತ್ಯಾನ್ ತರ್ಪಯಿತುಂ ವಯಂ ಕುತ್ರ ಪೂಪಾನ್ ಪ್ರಾಪ್ಸ್ಯಾಮಃ? ");
INSERT INTO sankan_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ಯೀಶುರಪೃಚ್ಛತ್, ಯುಷ್ಮಾಕಂ ನಿಕಟೇ ಕತಿ ಪೂಪಾ ಆಸತೇ? ತ ಊಚುಃ, ಸಪ್ತಪೂಪಾ ಅಲ್ಪಾಃ ಕ್ಷುದ್ರಮೀನಾಶ್ಚ ಸನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","ತದಾನೀಂ ಸ ಲೋಕನಿವಹಂ ಭೂಮಾವುಪವೇಷ್ಟುಮ್ ಆದಿಶ್ಯ ");
INSERT INTO sankan_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ತಾನ್ ಸಪ್ತಪೂಪಾನ್ ಮೀನಾಂಶ್ಚ ಗೃಹ್ಲನ್ ಈಶ್ವರೀಯಗುಣಾನ್ ಅನೂದ್ಯ ಭಂಕ್ತ್ವಾ ಶಿಷ್ಯೇಭ್ಯೋ ದದೌ, ಶಿಷ್ಯಾ ಲೋಕೇಭ್ಯೋ ದದುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ತತಃ ಸರ್ವ್ವೇ ಭುಕ್ತ್ವಾ ತೃಪ್ತವನ್ತಃ; ತದವಶಿಷ್ಟಭಕ್ಷ್ಯೇಣ ಸಪ್ತಡಲಕಾನ್ ಪರಿಪೂರ್ಯ್ಯ ಸಂಜಗೃಹುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","ತೇ ಭೋಕ್ತಾರೋ ಯೋಷಿತೋ ಬಾಲಕಾಂಶ್ಚ ವಿಹಾಯ ಪ್ರಾಯೇಣ ಚತುಃಸಹಸ್ರಾಣಿ ಪುರುಷಾ ಆಸನ್| ");
INSERT INTO sankan_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","ತತಃ ಪರಂ ಸ ಜನನಿವಹಂ ವಿಸೃಜ್ಯ ತರಿಮಾರುಹ್ಯ ಮಗ್ದಲಾಪ್ರದೇಶಂ ಗತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ತದಾನೀಂ ಫಿರೂಶಿನಃ ಸಿದೂಕಿನಶ್ಚಾಗತ್ಯ ತಂ ಪರೀಕ್ಷಿತುಂ ನಭಮೀಯಂ ಕಿಞ್ಚನ ಲಕ್ಷ್ಮ ದರ್ಶಯಿತುಂ ತಸ್ಮೈ ನಿವೇದಯಾಮಾಸುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ತತಃ ಸ ಉಕ್ತವಾನ್, ಸನ್ಧ್ಯಾಯಾಂ ನಭಸೋ ರಕ್ತತ್ವಾದ್ ಯೂಯಂ ವದಥ, ಶ್ವೋ ನಿರ್ಮ್ಮಲಂ ದಿನಂ ಭವಿಷ್ಯತಿ; ");
INSERT INTO sankan_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ಪ್ರಾತಃಕಾಲೇ ಚ ನಭಸೋ ರಕ್ತತ್ವಾತ್ ಮಲಿನತ್ವಾಞ್ಚ ವದಥ, ಝಞ್ಭ್ಶದ್ಯ ಭವಿಷ್ಯತಿ| ಹೇ ಕಪಟಿನೋ ಯದಿ ಯೂಯಮ್ ಅನ್ತರೀಕ್ಷಸ್ಯ ಲಕ್ಷ್ಮ ಬೋದ್ಧುಂ ಶಕ್ನುಥ, ತರ್ಹಿ ಕಾಲಸ್ಯೈತಸ್ಯ ಲಕ್ಷ್ಮ ಕಥಂ ಬೋದ್ಧುಂ ನ ಶಕ್ನುಥ? ");
INSERT INTO sankan_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ಏತತ್ಕಾಲಸ್ಯ ದುಷ್ಟೋ ವ್ಯಭಿಚಾರೀ ಚ ವಂಶೋ ಲಕ್ಷ್ಮ ಗವೇಷಯತಿ, ಕಿನ್ತು ಯೂನಸೋ ಭವಿಷ್ಯದ್ವಾದಿನೋ ಲಕ್ಷ್ಮ ವಿನಾನ್ಯತ್ ಕಿಮಪಿ ಲಕ್ಷ್ಮ ತಾನ್ ನ ದರ್ಶಯಿಯ್ಯತೇ| ತದಾನೀಂ ಸ ತಾನ್ ವಿಹಾಯ ಪ್ರತಸ್ಥೇ| ");
INSERT INTO sankan_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","ಅನನ್ತರಮನ್ಯಪಾರಗಮನಕಾಲೇ ತಸ್ಯ ಶಿಷ್ಯಾಃ ಪೂಪಮಾನೇತುಂ ವಿಸ್ಮೃತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ಯೀಶುಸ್ತಾನವಾದೀತ್, ಯೂಯಂ ಫಿರೂಶಿನಾಂ ಸಿದೂಕಿನಾಞ್ಚ ಕಿಣ್ವಂ ಪ್ರತಿ ಸಾವಧಾನಾಃ ಸತರ್ಕಾಶ್ಚ ಭವತ| ");
INSERT INTO sankan_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","ತೇನ ತೇ ಪರಸ್ಪರಂ ವಿವಿಚ್ಯ ಕಥಯಿತುಮಾರೇಭಿರೇ, ವಯಂ ಪೂಪಾನಾನೇತುಂ ವಿಸ್ಮೃತವನ್ತ ಏತತ್ಕಾರಣಾದ್ ಇತಿ ಕಥಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","ಕಿನ್ತು ಯೀಶುಸ್ತದ್ವಿಜ್ಞಾಯ ತಾನವೋಚತ್, ಹೇ ಸ್ತೋಕವಿಶ್ವಾಸಿನೋ ಯೂಯಂ ಪೂಪಾನಾನಯನಮಧಿ ಕುತಃ ಪರಸ್ಪರಮೇತದ್ ವಿವಿಂಕ್ಯ? ");
INSERT INTO sankan_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","ಯುಷ್ಮಾಭಿಃ ಕಿಮದ್ಯಾಪಿ ನ ಜ್ಞಾಯತೇ? ಪಞ್ಚಭಿಃ ಪೂಪೈಃ ಪಞ್ಚಸಹಸ್ರಪುರುಷೇಷು ಭೋಜಿತೇಷು ಭಕ್ಷ್ಯೋಚ್ಛಿಷ್ಟಪೂರ್ಣಾನ್ ಕತಿ ಡಲಕಾನ್ ಸಮಗೃಹ್ಲೀತಂ; ");
INSERT INTO sankan_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ತಥಾ ಸಪ್ತಭಿಃ ಪೂಪೈಶ್ಚತುಃಸಹಸ್ರಪುರುಷೇಷು ಭೇಜಿತೇಷು ಕತಿ ಡಲಕಾನ್ ಸಮಗೃಹ್ಲೀತ, ತತ್ ಕಿಂ ಯುಷ್ಮಾಭಿರ್ನ ಸ್ಮರ್ಯ್ಯತೇ? ");
INSERT INTO sankan_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","ತಸ್ಮಾತ್ ಫಿರೂಶಿನಾಂ ಸಿದೂಕಿನಾಞ್ಚ ಕಿಣ್ವಂ ಪ್ರತಿ ಸಾವಧಾನಾಸ್ತಿಷ್ಠತ, ಕಥಾಮಿಮಾಮ್ ಅಹಂ ಪೂಪಾನಧಿ ನಾಕಥಯಂ, ಏತದ್ ಯೂಯಂ ಕುತೋ ನ ಬುಧ್ಯಧ್ವೇ? ");
INSERT INTO sankan_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","ತದಾನೀಂ ಪೂಪಕಿಣ್ವಂ ಪ್ರತಿ ಸಾವಧಾನಾಸ್ತಿಷ್ಠತೇತಿ ನೋಕ್ತ್ವಾ ಫಿರೂಶಿನಾಂ ಸಿದೂಕಿನಾಞ್ಚ ಉಪದೇಶಂ ಪ್ರತಿ ಸಾವಧಾನಾಸ್ತಿಷ್ಠತೇತಿ ಕಥಿತವಾನ್, ಇತಿ ತೈರಬೋಧಿ| ");
INSERT INTO sankan_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","ಅಪರಞ್ಚ ಯೀಶುಃ ಕೈಸರಿಯಾ-ಫಿಲಿಪಿಪ್ರದೇಶಮಾಗತ್ಯ ಶಿಷ್ಯಾನ್ ಅಪೃಚ್ಛತ್, ಯೋಽಹಂ ಮನುಜಸುತಃ ಸೋಽಹಂ ಕಃ? ಲೋಕೈರಹಂ ಕಿಮುಚ್ಯೇ? ");
INSERT INTO sankan_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","ತದಾನೀಂ ತೇ ಕಥಿತವನ್ತಃ, ಕೇಚಿದ್ ವದನ್ತಿ ತ್ವಂ ಮಜ್ಜಯಿತಾ ಯೋಹನ್, ಕೇಚಿದ್ವದನ್ತಿ, ತ್ವಮ್ ಏಲಿಯಃ, ಕೇಚಿಚ್ಚ ವದನ್ತಿ, ತ್ವಂ ಯಿರಿಮಿಯೋ ವಾ ಕಶ್ಚಿದ್ ಭವಿಷ್ಯದ್ವಾದೀತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ಪಶ್ಚಾತ್ ಸ ತಾನ್ ಪಪ್ರಚ್ಛ, ಯೂಯಂ ಮಾಂ ಕಂ ವದಥ? ತತಃ ಶಿಮೋನ್ ಪಿತರ ಉವಾಚ, ");
INSERT INTO sankan_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ತ್ವಮಮರೇಶ್ವರಸ್ಯಾಭಿಷಿಕ್ತಪುತ್ರಃ| ");
INSERT INTO sankan_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ತತೋ ಯೀಶುಃ ಕಥಿತವಾನ್, ಹೇ ಯೂನಸಃ ಪುತ್ರ ಶಿಮೋನ್ ತ್ವಂ ಧನ್ಯಃ; ಯತಃ ಕೋಪಿ ಅನುಜಸ್ತ್ವಯ್ಯೇತಜ್ಜ್ಞಾನಂ ನೋದಪಾದಯತ್, ಕಿನ್ತು ಮಮ ಸ್ವರ್ಗಸ್ಯಃ ಪಿತೋದಪಾದಯತ್| ");
INSERT INTO sankan_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","ಅತೋಽಹಂ ತ್ವಾಂ ವದಾಮಿ, ತ್ವಂ ಪಿತರಃ (ಪ್ರಸ್ತರಃ) ಅಹಞ್ಚ ತಸ್ಯ ಪ್ರಸ್ತರಸ್ಯೋಪರಿ ಸ್ವಮಣ್ಡಲೀಂ ನಿರ್ಮ್ಮಾಸ್ಯಾಮಿ, ತೇನ ನಿರಯೋ ಬಲಾತ್ ತಾಂ ಪರಾಜೇತುಂ ನ ಶಕ್ಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","ಅಹಂ ತುಭ್ಯಂ ಸ್ವರ್ಗೀಯರಾಜ್ಯಸ್ಯ ಕುಞ್ಜಿಕಾಂ ದಾಸ್ಯಾಮಿ, ತೇನ ಯತ್ ಕಿಞ್ಚನ ತ್ವಂ ಪೃಥಿವ್ಯಾಂ ಭಂತ್ಸ್ಯಸಿ ತತ್ಸ್ವರ್ಗೇ ಭಂತ್ಸ್ಯತೇ, ಯಚ್ಚ ಕಿಞ್ಚನ ಮಹ್ಯಾಂ ಮೋಕ್ಷ್ಯಸಿ ತತ್ ಸ್ವರ್ಗೇ ಮೋಕ್ಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","ಪಶ್ಚಾತ್ ಸ ಶಿಷ್ಯಾನಾದಿಶತ್, ಅಹಮಭಿಷಿಕ್ತೋ ಯೀಶುರಿತಿ ಕಥಾಂ ಕಸ್ಮೈಚಿದಪಿ ಯೂಯಂ ಮಾ ಕಥಯತ| ");
INSERT INTO sankan_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ಅನ್ಯಞ್ಚ ಯಿರೂಶಾಲಮ್ನಗರಂ ಗತ್ವಾ ಪ್ರಾಚೀನಲೋಕೇಭ್ಯಃ ಪ್ರಧಾನಯಾಜಕೇಭ್ಯ ಉಪಾಧ್ಯಾಯೇಭ್ಯಶ್ಚ ಬಹುದುಃಖಭೋಗಸ್ತೈ ರ್ಹತತ್ವಂ ತೃತೀಯದಿನೇ ಪುನರುತ್ಥಾನಞ್ಚ ಮಮಾವಶ್ಯಕಮ್ ಏತಾಃ ಕಥಾ ಯೀಶುಸ್ತತ್ಕಾಲಮಾರಭ್ಯ ಶಿಷ್ಯಾನ್ ಜ್ಞಾಪಯಿತುಮ್ ಆರಬ್ಧವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ತದಾನೀಂ ಪಿತರಸ್ತಸ್ಯ ಕರಂ ಘೃತ್ವಾ ತರ್ಜಯಿತ್ವಾ ಕಥಯಿತುಮಾರಬ್ಧವಾನ್, ಹೇ ಪ್ರಭೋ, ತತ್ ತ್ವತ್ತೋ ದೂರಂ ಯಾತು, ತ್ವಾಂ ಪ್ರತಿ ಕದಾಪಿ ನ ಘಟಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ಕಿನ್ತು ಸ ವದನಂ ಪರಾವರ್ತ್ಯ ಪಿತರಂ ಜಗಾದ, ಹೇ ವಿಘ್ನಕಾರಿನ್, ಮತ್ಸಮ್ಮುಖಾದ್ ದೂರೀಭವ, ತ್ವಂ ಮಾಂ ಬಾಧಸೇ, ಈಶ್ವರೀಯಕಾರ್ಯ್ಯಾತ್ ಮಾನುಷೀಯಕಾರ್ಯ್ಯಂ ತುಭ್ಯಂ ರೋಚತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","ಅನನ್ತರಂ ಯೀಶುಃ ಸ್ವೀಯಶಿಷ್ಯಾನ್ ಉಕ್ತವಾನ್ ಯಃ ಕಶ್ಚಿತ್ ಮಮ ಪಶ್ಚಾದ್ಗಾಮೀ ಭವಿತುಮ್ ಇಚ್ಛತಿ, ಸ ಸ್ವಂ ದಾಮ್ಯತು, ತಥಾ ಸ್ವಕ್ರುಶಂ ಗೃಹ್ಲನ್ ಮತ್ಪಶ್ಚಾದಾಯಾತು| ");
INSERT INTO sankan_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","ಯತೋ ಯಃ ಪ್ರಾಣಾನ್ ರಕ್ಷಿತುಮಿಚ್ಛತಿ, ಸ ತಾನ್ ಹಾರಯಿಷ್ಯತಿ, ಕಿನ್ತು ಯೋ ಮದರ್ಥಂ ನಿಜಪ್ರಾಣಾನ್ ಹಾರಯತಿ, ಸ ತಾನ್ ಪ್ರಾಪ್ಸ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","ಮಾನುಷೋ ಯದಿ ಸರ್ವ್ವಂ ಜಗತ್ ಲಭತೇ ನಿಜಪ್ರಣಾನ್ ಹಾರಯತಿ, ತರ್ಹಿ ತಸ್ಯ ಕೋ ಲಾಭಃ? ಮನುಜೋ ನಿಜಪ್ರಾಣಾನಾಂ ವಿನಿಮಯೇನ ವಾ ಕಿಂ ದಾತುಂ ಶಕ್ನೋತಿ? ");
INSERT INTO sankan_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","ಮನುಜಸುತಃ ಸ್ವದೂತೈಃ ಸಾಕಂ ಪಿತುಃ ಪ್ರಭಾವೇಣಾಗಮಿಷ್ಯತಿ; ತದಾ ಪ್ರತಿಮನುಜಂ ಸ್ವಸ್ವಕರ್ಮ್ಮಾನುಸಾರಾತ್ ಫಲಂ ದಾಸ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","ಅಹಂ ಯುಷ್ಮಾನ್ ತಥ್ಯಂ ವಚ್ಮಿ, ಸರಾಜ್ಯಂ ಮನುಜಸುತಮ್ ಆಗತಂ ನ ಪಶ್ಯನ್ತೋ ಮೃತ್ಯುಂ ನ ಸ್ವಾದಿಷ್ಯನ್ತಿ, ಏತಾದೃಶಾಃ ಕತಿಪಯಜನಾ ಅತ್ರಾಪಿ ದಣ್ಡಾಯಮಾನಾಃ ಸನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","ಅನನ್ತರಂ ಷಡ್ದಿನೇಭ್ಯಃ ಪರಂ ಯೀಶುಃ ಪಿತರಂ ಯಾಕೂಬಂ ತತ್ಸಹಜಂ ಯೋಹನಞ್ಚ ಗೃಹ್ಲನ್ ಉಚ್ಚಾದ್ರೇ ರ್ವಿವಿಕ್ತಸ್ಥಾನಮ್ ಆಗತ್ಯ ತೇಷಾಂ ಸಮಕ್ಷಂ ರೂಪಮನ್ಯತ್ ದಧಾರ| ");
INSERT INTO sankan_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ತೇನ ತದಾಸ್ಯಂ ತೇಜಸ್ವಿ, ತದಾಭರಣಮ್ ಆಲೋಕವತ್ ಪಾಣ್ಡರಮಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ಅನ್ಯಚ್ಚ ತೇನ ಸಾಕಂ ಸಂಲಪನ್ತೌ ಮೂಸಾ ಏಲಿಯಶ್ಚ ತೇಭ್ಯೋ ದರ್ಶನಂ ದದತುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ತದಾನೀಂ ಪಿತರೋ ಯೀಶುಂ ಜಗಾದ, ಹೇ ಪ್ರಭೋ ಸ್ಥಿತಿರತ್ರಾಸ್ಮಾಕಂ ಶುಭಾ, ಯದಿ ಭವತಾನುಮನ್ಯತೇ, ತರ್ಹಿ ಭವದರ್ಥಮೇಕಂ ಮೂಸಾರ್ಥಮೇಕಮ್ ಏಲಿಯಾರ್ಥಞ್ಚೈಕಮ್ ಇತಿ ತ್ರೀಣಿ ದೂಷ್ಯಾಣಿ ನಿರ್ಮ್ಮಮ| ");
INSERT INTO sankan_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ಏತತ್ಕಥನಕಾಲ ಏಕ ಉಜ್ಜವಲಃ ಪಯೋದಸ್ತೇಷಾಮುಪರಿ ಛಾಯಾಂ ಕೃತವಾನ್, ವಾರಿದಾದ್ ಏಷಾ ನಭಸೀಯಾ ವಾಗ್ ಬಭೂವ, ಮಮಾಯಂ ಪ್ರಿಯಃ ಪುತ್ರಃ, ಅಸ್ಮಿನ್ ಮಮ ಮಹಾಸನ್ತೋಷ ಏತಸ್ಯ ವಾಕ್ಯಂ ಯೂಯಂ ನಿಶಾಮಯತ| ");
INSERT INTO sankan_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","ಕಿನ್ತು ವಾಚಮೇತಾಂ ಶೃಣ್ವನ್ತಏವ ಶಿಷ್ಯಾ ಮೃಶಂ ಶಙ್ಕಮಾನಾ ನ್ಯುಬ್ಜಾ ನ್ಯಪತನ್| ");
INSERT INTO sankan_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ತದಾ ಯೀಶುರಾಗತ್ಯ ತೇಷಾಂ ಗಾತ್ರಾಣಿ ಸ್ಪೃಶನ್ ಉವಾಚ, ಉತ್ತಿಷ್ಠತ, ಮಾ ಭೈಷ್ಟ| ");
INSERT INTO sankan_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ತದಾನೀಂ ನೇತ್ರಾಣ್ಯುನ್ಮೀಲ್ಯ ಯೀಶುಂ ವಿನಾ ಕಮಪಿ ನ ದದೃಶುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ತತಃ ಪರಮ್ ಅದ್ರೇರವರೋಹಣಕಾಲೇ ಯೀಶುಸ್ತಾನ್ ಇತ್ಯಾದಿದೇಶ, ಮನುಜಸುತಸ್ಯ ಮೃತಾನಾಂ ಮಧ್ಯಾದುತ್ಥಾನಂ ಯಾವನ್ನ ಜಾಯತೇ, ತಾವತ್ ಯುಷ್ಮಾಭಿರೇತದ್ದರ್ಶನಂ ಕಸ್ಮೈಚಿದಪಿ ನ ಕಥಯಿತವ್ಯಂ| ");
INSERT INTO sankan_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","ತದಾ ಶಿಷ್ಯಾಸ್ತಂ ಪಪ್ರಚ್ಛುಃ, ಪ್ರಥಮಮ್ ಏಲಿಯ ಆಯಾಸ್ಯತೀತಿ ಕುತ ಉಪಾಧ್ಯಾಯೈರುಚ್ಯತೇ? ");
INSERT INTO sankan_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ತತೋ ಯೀಶುಃ ಪ್ರತ್ಯವಾದೀತ್, ಏಲಿಯಃ ಪ್ರಾಗೇತ್ಯ ಸರ್ವ್ವಾಣಿ ಸಾಧಯಿಷ್ಯತೀತಿ ಸತ್ಯಂ, ");
INSERT INTO sankan_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","ಕಿನ್ತ್ವಹಂ ಯುಷ್ಮಾನ್ ವಚ್ಮಿ, ಏಲಿಯ ಏತ್ಯ ಗತಃ, ತೇ ತಮಪರಿಚಿತ್ಯ ತಸ್ಮಿನ್ ಯಥೇಚ್ಛಂ ವ್ಯವಜಹುಃ; ಮನುಜಸುತೇನಾಪಿ ತೇಷಾಮನ್ತಿಕೇ ತಾದೃಗ್ ದುಃಖಂ ಭೋಕ್ತವ್ಯಂ| ");
INSERT INTO sankan_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","ತದಾನೀಂ ಸ ಮಜ್ಜಯಿತಾರಂ ಯೋಹನಮಧಿ ಕಥಾಮೇತಾಂ ವ್ಯಾಹೃತವಾನ್, ಇತ್ಥಂ ತಚ್ಛಿಷ್ಯಾ ಬುಬುಧಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ಪಶ್ಚಾತ್ ತೇಷು ಜನನಿವಹಸ್ಯಾನ್ತಿಕಮಾಗತೇಷು ಕಶ್ಚಿತ್ ಮನುಜಸ್ತದನ್ತಿಕಮೇತ್ಯ ಜಾನೂನೀ ಪಾತಯಿತ್ವಾ ಕಥಿತವಾನ್, ");
INSERT INTO sankan_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ಹೇ ಪ್ರಭೋ, ಮತ್ಪುತ್ರಂ ಪ್ರತಿ ಕೃಪಾಂ ವಿದಧಾತು, ಸೋಪಸ್ಮಾರಾಮಯೇನ ಭೃಶಂ ವ್ಯಥಿತಃ ಸನ್ ಪುನಃ ಪುನ ರ್ವಹ್ನೌ ಮುಹು ರ್ಜಲಮಧ್ಯೇ ಪತತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","ತಸ್ಮಾದ್ ಭವತಃ ಶಿಷ್ಯಾಣಾಂ ಸಮೀಪೇ ತಮಾನಯಂ ಕಿನ್ತು ತೇ ತಂ ಸ್ವಾಸ್ಥಂ ಕರ್ತ್ತುಂ ನ ಶಕ್ತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ತದಾ ಯೀಶುಃ ಕಥಿತವಾನ್ ರೇ ಅವಿಶ್ವಾಸಿನಃ, ರೇ ವಿಪಥಗಾಮಿನಃ, ಪುನಃ ಕತಿಕಾಲಾನ್ ಅಹಂ ಯುಷ್ಮಾಕಂ ಸನ್ನಿಧೌ ಸ್ಥಾಸ್ಯಾಮಿ? ಕತಿಕಾಲಾನ್ ವಾ ಯುಷ್ಮಾನ್ ಸಹಿಷ್ಯೇ? ತಮತ್ರ ಮಮಾನ್ತಿಕಮಾನಯತ| ");
INSERT INTO sankan_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ಪಶ್ಚಾದ್ ಯೀಶುನಾ ತರ್ಜತಏವ ಸ ಭೂತಸ್ತಂ ವಿಹಾಯ ಗತವಾನ್, ತದ್ದಣ್ಡಏವ ಸ ಬಾಲಕೋ ನಿರಾಮಯೋಽಭೂತ್| ");
INSERT INTO sankan_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ತತಃ ಶಿಷ್ಯಾ ಗುಪ್ತಂ ಯೀಶುಮುಪಾಗತ್ಯ ಬಭಾಷಿರೇ, ಕುತೋ ವಯಂ ತಂ ಭೂತಂ ತ್ಯಾಜಯಿತುಂ ನ ಶಕ್ತಾಃ? ");
INSERT INTO sankan_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ಯೀಶುನಾ ತೇ ಪ್ರೋಕ್ತಾಃ, ಯುಷ್ಮಾಕಮಪ್ರತ್ಯಯಾತ್; ");
INSERT INTO sankan_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","ಯುಷ್ಮಾನಹಂ ತಥ್ಯಂ ವಚ್ಮಿ ಯದಿ ಯುಷ್ಮಾಕಂ ಸರ್ಷಪೈಕಮಾತ್ರೋಪಿ ವಿಶ್ವಾಸೋ ಜಾಯತೇ, ತರ್ಹಿ ಯುಷ್ಮಾಭಿರಸ್ಮಿನ್ ಶೈಲೇ ತ್ವಮಿತಃ ಸ್ಥಾನಾತ್ ತತ್ ಸ್ಥಾನಂ ಯಾಹೀತಿ ಬ್ರೂತೇ ಸ ತದೈವ ಚಲಿಷ್ಯತಿ, ಯುಷ್ಮಾಕಂ ಕಿಮಪ್ಯಸಾಧ್ಯಞ್ಚ ಕರ್ಮ್ಮ ನ ಸ್ಥಾಸ್ಯಾತಿ| ಕಿನ್ತು ಪ್ರಾರ್ಥನೋಪವಾಸೌ ವಿನೈತಾದೃಶೋ ಭೂತೋ ನ ತ್ಯಾಜ್ಯೇತ| ");
INSERT INTO sankan_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","ಅಪರಂ ತೇಷಾಂ ಗಾಲೀಲ್ಪ್ರದೇಶೇ ಭ್ರಮಣಕಾಲೇ ಯೀಶುನಾ ತೇ ಗದಿತಾಃ, ಮನುಜಸುತೋ ಜನಾನಾಂ ಕರೇಷು ಸಮರ್ಪಯಿಷ್ಯತೇ ತೈ ರ್ಹನಿಷ್ಯತೇ ಚ, ");
INSERT INTO sankan_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ಕಿನ್ತು ತೃತೀಯೇಽಹಿ्ನ ಮ ಉತ್ಥಾಪಿಷ್ಯತೇ, ತೇನ ತೇ ಭೃಶಂ ದುಃಖಿತಾ ಬಭೂವಃ| ");
INSERT INTO sankan_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","ತದನನ್ತರಂ ತೇಷು ಕಫರ್ನಾಹೂಮ್ನಗರಮಾಗತೇಷು ಕರಸಂಗ್ರಾಹಿಣಃ ಪಿತರಾನ್ತಿಕಮಾಗತ್ಯ ಪಪ್ರಚ್ಛುಃ, ಯುಷ್ಮಾಕಂ ಗುರುಃ ಕಿಂ ಮನ್ದಿರಾರ್ಥಂ ಕರಂ ನ ದದಾತಿ? ತತಃ ಪಿತರಃ ಕಥಿತವಾನ್ ದದಾತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ತತಸ್ತಸ್ಮಿನ್ ಗೃಹಮಧ್ಯಮಾಗತೇ ತಸ್ಯ ಕಥಾಕಥನಾತ್ ಪೂರ್ವ್ವಮೇವ ಯೀಶುರುವಾಚ, ಹೇ ಶಿಮೋನ್, ಮೇದಿನ್ಯಾ ರಾಜಾನಃ ಸ್ವಸ್ವಾಪತ್ಯೇಭ್ಯಃ ಕಿಂ ವಿದೇಶಿಭ್ಯಃ ಕೇಭ್ಯಃ ಕರಂ ಗೃಹ್ಲನ್ತಿ? ಅತ್ರ ತ್ವಂ ಕಿಂ ಬುಧ್ಯಸೇ? ತತಃ ಪಿತರ ಉಕ್ತವಾನ್, ವಿದೇಶಿಭ್ಯಃ| ");
INSERT INTO sankan_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ತದಾ ಯೀಶುರುಕ್ತವಾನ್, ತರ್ಹಿ ಸನ್ತಾನಾ ಮುಕ್ತಾಃ ಸನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","ತಥಾಪಿ ಯಥಾಸ್ಮಾಭಿಸ್ತೇಷಾಮನ್ತರಾಯೋ ನ ಜನ್ಯತೇ, ತತ್ಕೃತೇ ಜಲಧೇಸ್ತೀರಂ ಗತ್ವಾ ವಡಿಶಂ ಕ್ಷಿಪ, ತೇನಾದೌ ಯೋ ಮೀನ ಉತ್ಥಾಸ್ಯತಿ, ತಂ ಘೃತ್ವಾ ತನ್ಮುಖೇ ಮೋಚಿತೇ ತೋಲಕೈಕಂ ರೂಪ್ಯಂ ಪ್ರಾಪ್ಸ್ಯಸಿ, ತದ್ ಗೃಹೀತ್ವಾ ತವ ಮಮ ಚ ಕೃತೇ ತೇಭ್ಯೋ ದೇಹಿ| ");
INSERT INTO sankan_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","ತದಾನೀಂ ಶಿಷ್ಯಾ ಯೀಶೋಃ ಸಮೀಪಮಾಗತ್ಯ ಪೃಷ್ಟವನ್ತಃ ಸ್ವರ್ಗರಾಜ್ಯೇ ಕಃ ಶ್ರೇಷ್ಠಃ? ");
INSERT INTO sankan_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ತತೋ ಯೀಶುಃ ಕ್ಷುದ್ರಮೇಕಂ ಬಾಲಕಂ ಸ್ವಸಮೀಪಮಾನೀಯ ತೇಷಾಂ ಮಧ್ಯೇ ನಿಧಾಯ ಜಗಾದ, ");
INSERT INTO sankan_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ಯುಷ್ಮಾನಹಂ ಸತ್ಯಂ ಬ್ರವೀಮಿ, ಯೂಯಂ ಮನೋವಿನಿಮಯೇನ ಕ್ಷುದ್ರಬಾಲವತ್ ನ ಸನ್ತಃ ಸ್ವರ್ಗರಾಜ್ಯಂ ಪ್ರವೇಷ್ಟುಂ ನ ಶಕ್ನುಥ| ");
INSERT INTO sankan_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","ಯಃ ಕಶ್ಚಿದ್ ಏತಸ್ಯ ಕ್ಷುದ್ರಬಾಲಕಸ್ಯ ಸಮಮಾತ್ಮಾನಂ ನಮ್ರೀಕರೋತಿ, ಸಏವ ಸ್ವರ್ಗರಾಜಯೇ ಶ್ರೇಷ್ಠಃ| ");
INSERT INTO sankan_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ಯಃ ಕಶ್ಚಿದ್ ಏತಾದೃಶಂ ಕ್ಷುದ್ರಬಾಲಕಮೇಕಂ ಮಮ ನಾಮ್ನಿ ಗೃಹ್ಲಾತಿ, ಸ ಮಾಮೇವ ಗೃಹ್ಲಾತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","ಕಿನ್ತು ಯೋ ಜನೋ ಮಯಿ ಕೃತವಿಶ್ವಾಸಾನಾಮೇತೇಷಾಂ ಕ್ಷುದ್ರಪ್ರಾಣಿನಾಮ್ ಏಕಸ್ಯಾಪಿ ವಿಧ್ನಿಂ ಜನಯತಿ, ಕಣ್ಠಬದ್ಧಪೇಷಣೀಕಸ್ಯ ತಸ್ಯ ಸಾಗರಾಗಾಧಜಲೇ ಮಜ್ಜನಂ ಶ್ರೇಯಃ| ");
INSERT INTO sankan_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","ವಿಘ್ನಾತ್ ಜಗತಃ ಸನ್ತಾಪೋ ಭವಿಷ್ಯತಿ, ವಿಘ್ನೋಽವಶ್ಯಂ ಜನಯಿಷ್ಯತೇ, ಕಿನ್ತು ಯೇನ ಮನುಜೇನ ವಿಘ್ನೋ ಜನಿಷ್ಯತೇ ತಸ್ಯೈವ ಸನ್ತಾಪೋ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","ತಸ್ಮಾತ್ ತವ ಕರಶ್ಚರಣೋ ವಾ ಯದಿ ತ್ವಾಂ ಬಾಧತೇ, ತರ್ಹಿ ತಂ ಛಿತ್ತ್ವಾ ನಿಕ್ಷಿಪ, ದ್ವಿಕರಸ್ಯ ದ್ವಿಪದಸ್ಯ ವಾ ತವಾನಪ್ತವಹ್ನೌ ನಿಕ್ಷೇಪಾತ್, ಖಞ್ಜಸ್ಯ ವಾ ಛಿನ್ನಹಸ್ತಸ್ಯ ತವ ಜೀವನೇ ಪ್ರವೇಶೋ ವರಂ| ");
INSERT INTO sankan_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","ಅಪರಂ ತವ ನೇತ್ರಂ ಯದಿ ತ್ವಾಂ ಬಾಧತೇ, ತರ್ಹಿ ತದಪ್ಯುತ್ಪಾವ್ಯ ನಿಕ್ಷಿಪ, ದ್ವಿನೇತ್ರಸ್ಯ ನರಕಾಗ್ನೌ ನಿಕ್ಷೇಪಾತ್ ಕಾಣಸ್ಯ ತವ ಜೀವನೇ ಪ್ರವೇಶೋ ವರಂ| ");
INSERT INTO sankan_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","ತಸ್ಮಾದವಧದ್ಧಂ, ಏತೇಷಾಂ ಕ್ಷುದ್ರಪ್ರಾಣಿನಾಮ್ ಏಕಮಪಿ ಮಾ ತುಚ್ಛೀಕುರುತ, ");
INSERT INTO sankan_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","ಯತೋ ಯುಷ್ಮಾನಹಂ ತಥ್ಯಂ ಬ್ರವೀಮಿ, ಸ್ವರ್ಗೇ ತೇಷಾಂ ದೂತಾ ಮಮ ಸ್ವರ್ಗಸ್ಥಸ್ಯ ಪಿತುರಾಸ್ಯಂ ನಿತ್ಯಂ ಪಶ್ಯನ್ತಿ| ಏವಂ ಯೇ ಯೇ ಹಾರಿತಾಸ್ತಾನ್ ರಕ್ಷಿತುಂ ಮನುಜಪುತ್ರ ಆಗಚ್ಛತ್| ");
INSERT INTO sankan_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","ಯೂಯಮತ್ರ ಕಿಂ ವಿವಿಂಗ್ಘ್ವೇ? ಕಸ್ಯಚಿದ್ ಯದಿ ಶತಂ ಮೇಷಾಃ ಸನ್ತಿ, ತೇಷಾಮೇಕೋ ಹಾರ್ಯ್ಯತೇ ಚ, ತರ್ಹಿ ಸ ಏಕೋನಶತಂ ಮೇಷಾನ್ ವಿಹಾಯ ಪರ್ವ್ವತಂ ಗತ್ವಾ ತಂ ಹಾರಿತಮೇಕಂ ಕಿಂ ನ ಮೃಗಯತೇ? ");
INSERT INTO sankan_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ಯದಿ ಚ ಕದಾಚಿತ್ ತನ್ಮೇಷೋದ್ದೇಶಂ ಲಮತೇ, ತರ್ಹಿ ಯುಷ್ಮಾನಹಂ ಸತ್ಯಂ ಕಥಯಾಮಿ, ಸೋಽವಿಪಥಗಾಮಿಭ್ಯ ಏಕೋನಶತಮೇಷೇಭ್ಯೋಪಿ ತದೇಕಹೇತೋರಧಿಕಮ್ ಆಹ್ಲಾದತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","ತದ್ವದ್ ಏತೇಷಾಂ ಕ್ಷುದ್ರಪ್ರಾಏिನಾಮ್ ಏಕೋಪಿ ನಶ್ಯತೀತಿ ಯುಷ್ಮಾಕಂ ಸ್ವರ್ಗಸ್ಥಪಿತು ರ್ನಾಭಿಮತಮ್| ");
INSERT INTO sankan_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","ಯದ್ಯಪಿ ತವ ಭ್ರಾತಾ ತ್ವಯಿ ಕಿಮಪ್ಯಪರಾಧ್ಯತಿ, ತರ್ಹಿ ಗತ್ವಾ ಯುವಯೋರ್ದ್ವಯೋಃ ಸ್ಥಿತಯೋಸ್ತಸ್ಯಾಪರಾಧಂ ತಂ ಜ್ಞಾಪಯ| ತತ್ರ ಸ ಯದಿ ತವ ವಾಕ್ಯಂ ಶೃಣೋತಿ, ತರ್ಹಿ ತ್ವಂ ಸ್ವಭ್ರಾತರಂ ಪ್ರಾಪ್ತವಾನ್, ");
INSERT INTO sankan_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","ಕಿನ್ತು ಯದಿ ನ ಶೃಣೋತಿ, ತರ್ಹಿ ದ್ವಾಭ್ಯಾಂ ತ್ರಿಭಿ ರ್ವಾ ಸಾಕ್ಷೀಭಿಃ ಸರ್ವ್ವಂ ವಾಕ್ಯಂ ಯಥಾ ನಿಶ್ಚಿತಂ ಜಾಯತೇ, ತದರ್ಥಮ್ ಏಕಂ ದ್ವೌ ವಾ ಸಾಕ್ಷಿಣೌ ಗೃಹೀತ್ವಾ ಯಾಹಿ| ");
INSERT INTO sankan_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","ತೇನ ಸ ಯದಿ ತಯೋ ರ್ವಾಕ್ಯಂ ನ ಮಾನ್ಯತೇ, ತರ್ಹಿ ಸಮಾಜಂ ತಜ್ಜ್ಞಾಪಯ, ಕಿನ್ತು ಯದಿ ಸಮಾಜಸ್ಯಾಪಿ ವಾಕ್ಯಂ ನ ಮಾನ್ಯತೇ,ತರ್ಹಿ ಸ ತವ ಸಮೀಪೇ ದೇವಪೂಜಕಇವ ಚಣ್ಡಾಲಇವ ಚ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","ಅಹಂ ಯುಷ್ಮಾನ್ ಸತ್ಯಂ ವದಾಮಿ, ಯುಷ್ಮಾಭಿಃ ಪೃಥಿವ್ಯಾಂ ಯದ್ ಬಧ್ಯತೇ ತತ್ ಸ್ವರ್ಗೇ ಭಂತ್ಸ್ಯತೇ; ಮೇದಿನ್ಯಾಂ ಯತ್ ಭೋಚ್ಯತೇ, ಸ್ವರ್ಗೇಽಪಿ ತತ್ ಮೋಕ್ಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","ಪುನರಹಂ ಯುಷ್ಮಾನ್ ವದಾಮಿ, ಮೇದಿನ್ಯಾಂ ಯುಷ್ಮಾಕಂ ಯದಿ ದ್ವಾವೇಕವಾಕ್ಯೀಭೂಯ ಕಿಞ್ಚಿತ್ ಪ್ರಾರ್ಥಯೇತೇ, ತರ್ಹಿ ಮಮ ಸ್ವರ್ಗಸ್ಥಪಿತ್ರಾ ತತ್ ತಯೋಃ ಕೃತೇ ಸಮ್ಪನ್ನಂ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","ಯತೋ ಯತ್ರ ದ್ವೌ ತ್ರಯೋ ವಾ ಮಮ ನಾನ್ನಿ ಮಿಲನ್ತಿ, ತತ್ರೈವಾಹಂ ತೇಷಾಂ ಮಧ್ಯೇಽಸ್ಮಿ| ");
INSERT INTO sankan_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","ತದಾನೀಂ ಪಿತರಸ್ತತ್ಸಮೀಪಮಾಗತ್ಯ ಕಥಿತವಾನ್ ಹೇ ಪ್ರಭೋ, ಮಮ ಭ್ರಾತಾ ಮಮ ಯದ್ಯಪರಾಧ್ಯತಿ, ತರ್ಹಿ ತಂ ಕತಿಕೃತ್ವಃ ಕ್ಷಮಿಷ್ಯೇ? ");
INSERT INTO sankan_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","ಕಿಂ ಸಪ್ತಕೃತ್ವಃ? ಯೀಶುಸ್ತಂ ಜಗಾದ, ತ್ವಾಂ ಕೇವಲಂ ಸಪ್ತಕೃತ್ವೋ ಯಾವತ್ ನ ವದಾಮಿ, ಕಿನ್ತು ಸಪ್ತತ್ಯಾ ಗುಣಿತಂ ಸಪ್ತಕೃತ್ವೋ ಯಾವತ್| ");
INSERT INTO sankan_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","ಅಪರಂ ನಿಜದಾಸೈಃ ಸಹ ಜಿಗಣಯಿಷುಃ ಕಶ್ಚಿದ್ ರಾಜೇವ ಸ್ವರ್ಗರಾಜಯಂ| ");
INSERT INTO sankan_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ಆರಬ್ಧೇ ತಸ್ಮಿನ್ ಗಣನೇ ಸಾರ್ದ್ಧಸಹಸ್ರಮುದ್ರಾಪೂರಿತಾನಾಂ ದಶಸಹಸ್ರಪುಟಕಾನಾಮ್ ಏಕೋಽಘಮರ್ಣಸ್ತತ್ಸಮಕ್ಷಮಾನಾಯಿ| ");
INSERT INTO sankan_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ತಸ್ಯ ಪರಿಶೋಧನಾಯ ದ್ರವ್ಯಾಭಾವಾತ್ ಪರಿಶೋಧನಾರ್ಥಂ ಸ ತದೀಯಭಾರ್ಯ್ಯಾಪುತ್ರಾದಿಸರ್ವ್ವಸ್ವಞ್ಚ ವಿಕ್ರೀಯತಾಮಿತಿ ತತ್ಪ್ರಭುರಾದಿದೇಶ| ");
INSERT INTO sankan_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","ತೇನ ಸ ದಾಸಸ್ತಸ್ಯ ಪಾದಯೋಃ ಪತನ್ ಪ್ರಣಮ್ಯ ಕಥಿತವಾನ್ , ಹೇ ಪ್ರಭೋ ಭವತಾ ಘೈರ್ಯ್ಯೇ ಕೃತೇ ಮಯಾ ಸರ್ವ್ವಂ ಪರಿಶೋಧಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","ತದಾನೀಂ ದಾಸಸ್ಯ ಪ್ರಭುಃ ಸಕರುಣಃ ಸನ್ ಸಕಲರ್ಣಂ ಕ್ಷಮಿತ್ವಾ ತಂ ತತ್ಯಾಜ| ");
INSERT INTO sankan_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","ಕಿನ್ತು ತಸ್ಮಿನ್ ದಾಸೇ ಬಹಿ ರ್ಯಾತೇ, ತಸ್ಯ ಶತಂ ಮುದ್ರಾಚತುರ್ಥಾಂಶಾನ್ ಯೋ ಧಾರಯತಿ, ತಂ ಸಹದಾಸಂ ದೃಷ್ದ್ವಾ ತಸ್ಯ ಕಣ್ಠಂ ನಿಷ್ಪೀಡ್ಯ ಗದಿತವಾನ್, ಮಮ ಯತ್ ಪ್ರಾಪ್ಯಂ ತತ್ ಪರಿಶೋಧಯ| ");
INSERT INTO sankan_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","ತದಾ ತಸ್ಯ ಸಹದಾಸಸ್ತತ್ಪಾದಯೋಃ ಪತಿತ್ವಾ ವಿನೀಯ ಬಭಾಷೇ, ತ್ವಯಾ ಧೈರ್ಯ್ಯೇ ಕೃತೇ ಮಯಾ ಸರ್ವ್ವಂ ಪರಿಶೋಧಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","ತಥಾಪಿ ಸ ತತ್ ನಾಙಗೀಕೃತ್ಯ ಯಾವತ್ ಸರ್ವ್ವಮೃಣಂ ನ ಪರಿಶೋಧಿತವಾನ್ ತಾವತ್ ತಂ ಕಾರಾಯಾಂ ಸ್ಥಾಪಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ತದಾ ತಸ್ಯ ಸಹದಾಸಾಸ್ತಸ್ಯೈತಾದೃಗ್ ಆಚರಣಂ ವಿಲೋಕ್ಯ ಪ್ರಭೋಃ ಸಮೀಪಂ ಗತ್ವಾ ಸರ್ವ್ವಂ ವೃತ್ತಾನ್ತಂ ನಿವೇದಯಾಮಾಸುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","ತದಾ ತಸ್ಯ ಪ್ರಭುಸ್ತಮಾಹೂಯ ಜಗಾದ, ರೇ ದುಷ್ಟ ದಾಸ, ತ್ವಯಾ ಮತ್ಸನ್ನಿಧೌ ಪ್ರಾರ್ಥಿತೇ ಮಯಾ ತವ ಸರ್ವ್ವಮೃಣಂ ತ್ಯಕ್ತಂ; ");
INSERT INTO sankan_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ಯಥಾ ಚಾಹಂ ತ್ವಯಿ ಕರುಣಾಂ ಕೃತವಾನ್, ತಥೈವ ತ್ವತ್ಸಹದಾಸೇ ಕರುಣಾಕರಣಂ ಕಿಂ ತವ ನೋಚಿತಂ? ");
INSERT INTO sankan_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ಇತಿ ಕಥಯಿತ್ವಾ ತಸ್ಯ ಪ್ರಭುಃ ಕ್ರುದ್ಧ್ಯನ್ ನಿಜಪ್ರಾಪ್ಯಂ ಯಾವತ್ ಸ ನ ಪರಿಶೋಧಿತವಾನ್, ತಾವತ್ ಪ್ರಹಾರಕಾನಾಂ ಕರೇಷು ತಂ ಸಮರ್ಪಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","ಯದಿ ಯೂಯಂ ಸ್ವಾನ್ತಃಕರಣೈಃ ಸ್ವಸ್ವಸಹಜಾನಾಮ್ ಅಪರಾಧಾನ್ ನ ಕ್ಷಮಧ್ವೇ, ತರ್ಹಿ ಮಮ ಸ್ವರ್ಗಸ್ಯಃ ಪಿತಾಪಿ ಯುಷ್ಮಾನ್ ಪ್ರತೀತ್ಥಂ ಕರಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","ಅನನ್ತರಮ್ ಏತಾಸು ಕಥಾಸು ಸಮಾಪ್ತಾಸು ಯೀಶು ರ್ಗಾಲೀಲಪ್ರದೇಶಾತ್ ಪ್ರಸ್ಥಾಯ ಯರ್ದನ್ತೀರಸ್ಥಂ ಯಿಹೂದಾಪ್ರದೇಶಂ ಪ್ರಾಪ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ತದಾ ತತ್ಪಶ್ಚಾತ್ ಜನನಿವಹೇ ಗತೇ ಸ ತತ್ರ ತಾನ್ ನಿರಾಮಯಾನ್ ಅಕರೋತ್| ");
INSERT INTO sankan_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ತದನನ್ತರಂ ಫಿರೂಶಿನಸ್ತತ್ಸಮೀಪಮಾಗತ್ಯ ಪಾರೀಕ್ಷಿತುಂ ತಂ ಪಪ್ರಚ್ಛುಃ, ಕಸ್ಮಾದಪಿ ಕಾರಣಾತ್ ನರೇಣ ಸ್ವಜಾಯಾ ಪರಿತ್ಯಾಜ್ಯಾ ನ ವಾ? ");
INSERT INTO sankan_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ಸ ಪ್ರತ್ಯುವಾಚ, ಪ್ರಥಮಮ್ ಈಶ್ವರೋ ನರತ್ವೇನ ನಾರೀತ್ವೇನ ಚ ಮನುಜಾನ್ ಸಸರ್ಜ, ತಸ್ಮಾತ್ ಕಥಿತವಾನ್, ");
INSERT INTO sankan_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ಮಾನುಷಃ ಸ್ವಪಿತರೌ ಪರಿತ್ಯಜ್ಯ ಸ್ವಪತ್ನ್ಯಾಮ್ ಆಸಕ್ಷ್ಯತೇ, ತೌ ದ್ವೌ ಜನಾವೇಕಾಙ್ಗೌ ಭವಿಷ್ಯತಃ, ಕಿಮೇತದ್ ಯುಷ್ಮಾಭಿ ರ್ನ ಪಠಿತಮ್? ");
INSERT INTO sankan_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","ಅತಸ್ತೌ ಪುನ ರ್ನ ದ್ವೌ ತಯೋರೇಕಾಙ್ಗತ್ವಂ ಜಾತಂ, ಈಶ್ವರೇಣ ಯಚ್ಚ ಸಮಯುಜ್ಯತ, ಮನುಜೋ ನ ತದ್ ಭಿನ್ದ್ಯಾತ್| ");
INSERT INTO sankan_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ತದಾನೀಂ ತೇ ತಂ ಪ್ರತ್ಯವದನ್, ತಥಾತ್ವೇ ತ್ಯಾಜ್ಯಪತ್ರಂ ದತ್ತ್ವಾ ಸ್ವಾಂ ಸ್ವಾಂ ಜಾಯಾಂ ತ್ಯಕ್ತುಂ ವ್ಯವಸ್ಥಾಂ ಮೂಸಾಃ ಕಥಂ ಲಿಲೇಖ? ");
INSERT INTO sankan_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ತತಃ ಸ ಕಥಿತವಾನ್, ಯುಷ್ಮಾಕಂ ಮನಸಾಂ ಕಾಠಿನ್ಯಾದ್ ಯುಷ್ಮಾನ್ ಸ್ವಾಂ ಸ್ವಾಂ ಜಾಯಾಂ ತ್ಯಕ್ತುಮ್ ಅನ್ವಮನ್ಯತ ಕಿನ್ತು ಪ್ರಥಮಾದ್ ಏಷೋ ವಿಧಿರ್ನಾಸೀತ್| ");
INSERT INTO sankan_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","ಅತೋ ಯುಷ್ಮಾನಹಂ ವದಾಮಿ, ವ್ಯಭಿಚಾರಂ ವಿನಾ ಯೋ ನಿಜಜಾಯಾಂ ತ್ಯಜೇತ್ ಅನ್ಯಾಞ್ಚ ವಿವಹೇತ್, ಸ ಪರದಾರಾನ್ ಗಚ್ಛತಿ; ಯಶ್ಚ ತ್ಯಕ್ತಾಂ ನಾರೀಂ ವಿವಹತಿ ಸೋಪಿ ಪರದಾರೇಷು ರಮತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ತದಾ ತಸ್ಯ ಶಿಷ್ಯಾಸ್ತಂ ಬಭಾಷಿರೇ, ಯದಿ ಸ್ವಜಾಯಯಾ ಸಾಕಂ ಪುಂಸ ಏತಾದೃಕ್ ಸಮ್ಬನ್ಧೋ ಜಾಯತೇ, ತರ್ಹಿ ವಿವಹನಮೇವ ನ ಭದ್ರಂ| ");
INSERT INTO sankan_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ತತಃ ಸ ಉಕ್ತವಾನ್, ಯೇಭ್ಯಸ್ತತ್ಸಾಮರ್ಥ್ಯಂ ಆದಾಯಿ, ತಾನ್ ವಿನಾನ್ಯಃ ಕೋಪಿ ಮನುಜ ಏತನ್ಮತಂ ಗ್ರಹೀತುಂ ನ ಶಕ್ನೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","ಕತಿಪಯಾ ಜನನಕ್ಲೀಬಃ ಕತಿಪಯಾ ನರಕೃತಕ್ಲೀಬಃ ಸ್ವರ್ಗರಾಜ್ಯಾಯ ಕತಿಪಯಾಃ ಸ್ವಕೃತಕ್ಲೀಬಾಶ್ಚ ಸನ್ತಿ, ಯೇ ಗ್ರಹೀತುಂ ಶಕ್ನುವನ್ತಿ ತೇ ಗೃಹ್ಲನ್ತು| ");
INSERT INTO sankan_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","ಅಪರಮ್ ಯಥಾ ಸ ಶಿಶೂನಾಂ ಗಾತ್ರೇಷು ಹಸ್ತಂ ದತ್ವಾ ಪ್ರಾರ್ಥಯತೇ, ತದರ್ಥಂ ತತ್ಸಮೀಂಪಂ ಶಿಶವ ಆನೀಯನ್ತ, ತತ ಆನಯಿತೃನ್ ಶಿಷ್ಯಾಸ್ತಿರಸ್ಕೃತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ಕಿನ್ತು ಯೀಶುರುವಾಚ, ಶಿಶವೋ ಮದನ್ತಿಕಮ್ ಆಗಚ್ಛನ್ತು, ತಾನ್ ಮಾ ವಾರಯತ, ಏತಾದೃಶಾಂ ಶಿಶೂನಾಮೇವ ಸ್ವರ್ಗರಾಜ್ಯಂ| ");
INSERT INTO sankan_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ತತಃ ಸ ತೇಷಾಂ ಗಾತ್ರೇಷು ಹಸ್ತಂ ದತ್ವಾ ತಸ್ಮಾತ್ ಸ್ಥಾನಾತ್ ಪ್ರತಸ್ಥೇ| ");
INSERT INTO sankan_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","ಅಪರಮ್ ಏಕ ಆಗತ್ಯ ತಂ ಪಪ್ರಚ್ಛ, ಹೇ ಪರಮಗುರೋ, ಅನನ್ತಾಯುಃ ಪ್ರಾಪ್ತುಂ ಮಯಾ ಕಿಂ ಕಿಂ ಸತ್ಕರ್ಮ್ಮ ಕರ್ತ್ತವ್ಯಂ? ");
INSERT INTO sankan_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ತತಃ ಸ ಉವಾಚ, ಮಾಂ ಪರಮಂ ಕುತೋ ವದಸಿ? ವಿನೇಶ್ಚರಂ ನ ಕೋಪಿ ಪರಮಃ, ಕಿನ್ತು ಯದ್ಯನನ್ತಾಯುಃ ಪ್ರಾಪ್ತುಂ ವಾಞ್ಛಸಿ, ತರ್ಹ್ಯಾಜ್ಞಾಃ ಪಾಲಯ| ");
INSERT INTO sankan_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","ತದಾ ಸ ಪೃಷ್ಟವಾನ್, ಕಾಃ ಕಾ ಆಜ್ಞಾಃ? ತತೋ ಯೀಶುಃ ಕಥಿತವಾನ್, ನರಂ ಮಾ ಹನ್ಯಾಃ, ಪರದಾರಾನ್ ಮಾ ಗಚ್ಛೇಃ, ಮಾ ಚೋರಯೇಃ, ಮೃಷಾಸಾಕ್ಷ್ಯಂ ಮಾ ದದ್ಯಾಃ, ");
INSERT INTO sankan_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ನಿಜಪಿತರೌ ಸಂಮನ್ಯಸ್ವ, ಸ್ವಸಮೀಪವಾಸಿನಿ ಸ್ವವತ್ ಪ್ರೇಮ ಕುರು| ");
INSERT INTO sankan_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ಸ ಯುವಾ ಕಥಿತವಾನ್, ಆ ಬಾಲ್ಯಾದ್ ಏತಾಃ ಪಾಲಯಾಮಿ, ಇದಾನೀಂ ಕಿಂ ನ್ಯೂನಮಾಸ್ತೇ? ");
INSERT INTO sankan_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ತತೋ ಯೀಶುರವದತ್, ಯದಿ ಸಿದ್ಧೋ ಭವಿತುಂ ವಾಞ್ಛಸಿ, ತರ್ಹಿ ಗತ್ವಾ ನಿಜಸರ್ವ್ವಸ್ವಂ ವಿಕ್ರೀಯ ದರಿದ್ರೇಭ್ಯೋ ವಿತರ, ತತಃ ಸ್ವರ್ಗೇ ವಿತ್ತಂ ಲಪ್ಸ್ಯಸೇ; ಆಗಚ್ಛ, ಮತ್ಪಶ್ಚಾದ್ವರ್ತ್ತೀ ಚ ಭವ| ");
INSERT INTO sankan_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ಏತಾಂ ವಾಚಂ ಶ್ರುತ್ವಾ ಸ ಯುವಾ ಸ್ವೀಯಬಹುಸಮ್ಪತ್ತೇ ರ್ವಿಷಣಃ ಸನ್ ಚಲಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ತದಾ ಯೀಶುಃ ಸ್ವಶಿಷ್ಯಾನ್ ಅವದತ್, ಧನಿನಾಂ ಸ್ವರ್ಗರಾಜ್ಯಪ್ರವೇಶೋ ಮಹಾದುಷ್ಕರ ಇತಿ ಯುಷ್ಮಾನಹಂ ತಥ್ಯಂ ವದಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","ಪುನರಪಿ ಯುಷ್ಮಾನಹಂ ವದಾಮಿ, ಧನಿನಾಂ ಸ್ವರ್ಗರಾಜ್ಯಪ್ರವೇಶಾತ್ ಸೂಚೀಛಿದ್ರೇಣ ಮಹಾಙ್ಗಗಮನಂ ಸುಕರಂ| ");
INSERT INTO sankan_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ಇತಿ ವಾಕ್ಯಂ ನಿಶಮ್ಯ ಶಿಷ್ಯಾ ಅತಿಚಮತ್ಕೃತ್ಯ ಕಥಯಾಮಾಸುಃ; ತರ್ಹಿ ಕಸ್ಯ ಪರಿತ್ರಾಣಂ ಭವಿತುಂ ಶಕ್ನೋತಿ? ");
INSERT INTO sankan_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ತದಾ ಸ ತಾನ್ ದೃಷ್ದ್ವಾ ಕಥಯಾಮಾಸ, ತತ್ ಮಾನುಷಾಣಾಮಶಕ್ಯಂ ಭವತಿ, ಕಿನ್ತ್ವೀಶ್ವರಸ್ಯ ಸರ್ವ್ವಂ ಶಕ್ಯಮ್| ");
INSERT INTO sankan_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","ತದಾ ಪಿತರಸ್ತಂ ಗದಿತವಾನ್, ಪಶ್ಯ, ವಯಂ ಸರ್ವ್ವಂ ಪರಿತ್ಯಜ್ಯ ಭವತಃ ಪಶ್ಚಾದ್ವರ್ತ್ತಿನೋ ಽಭವಾಮ; ವಯಂ ಕಿಂ ಪ್ರಾಪ್ಸ್ಯಾಮಃ? ");
INSERT INTO sankan_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ತತೋ ಯೀಶುಃ ಕಥಿತವಾನ್, ಯುಷ್ಮಾನಹಂ ತಥ್ಯಂ ವದಾಮಿ, ಯೂಯಂ ಮಮ ಪಶ್ಚಾದ್ವರ್ತ್ತಿನೋ ಜಾತಾ ಇತಿ ಕಾರಣಾತ್ ನವೀನಸೃಷ್ಟಿಕಾಲೇ ಯದಾ ಮನುಜಸುತಃ ಸ್ವೀಯೈಶ್ಚರ್ಯ್ಯಸಿಂಹಾಸನ ಉಪವೇಕ್ಷ್ಯತಿ, ತದಾ ಯೂಯಮಪಿ ದ್ವಾದಶಸಿಂಹಾಸನೇಷೂಪವಿಶ್ಯ ಇಸ್ರಾಯೇಲೀಯದ್ವಾದಶವಂಶಾನಾಂ ವಿಚಾರಂ ಕರಿಷ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","ಅನ್ಯಚ್ಚ ಯಃ ಕಶ್ಚಿತ್ ಮಮ ನಾಮಕಾರಣಾತ್ ಗೃಹಂ ವಾ ಭ್ರಾತರಂ ವಾ ಭಗಿನೀಂ ವಾ ಪಿತರಂ ವಾ ಮಾತರಂ ವಾ ಜಾಯಾಂ ವಾ ಬಾಲಕಂ ವಾ ಭೂಮಿಂ ಪರಿತ್ಯಜತಿ, ಸ ತೇಷಾಂ ಶತಗುಣಂ ಲಪ್ಸ್ಯತೇ, ಅನನ್ತಾಯುಮೋಽಧಿಕಾರಿತ್ವಞ್ಚ ಪ್ರಾಪ್ಸ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","ಕಿನ್ತು ಅಗ್ರೀಯಾ ಅನೇಕೇ ಜನಾಃ ಪಶ್ಚಾತ್, ಪಶ್ಚಾತೀಯಾಶ್ಚಾನೇಕೇ ಲೋಕಾ ಅಗ್ರೇ ಭವಿಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","ಸ್ವರ್ಗರಾಜ್ಯಮ್ ಏತಾದೃಶಾ ಕೇನಚಿದ್ ಗೃಹಸ್ಯೇನ ಸಮಂ, ಯೋಽತಿಪ್ರಭಾತೇ ನಿಜದ್ರಾಕ್ಷಾಕ್ಷೇತ್ರೇ ಕೃಷಕಾನ್ ನಿಯೋಕ್ತುಂ ಗತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ಪಶ್ಚಾತ್ ತೈಃ ಸಾಕಂ ದಿನೈಕಭೃತಿಂ ಮುದ್ರಾಚತುರ್ಥಾಂಶಂ ನಿರೂಪ್ಯ ತಾನ್ ದ್ರಾಕ್ಷಾಕ್ಷೇತ್ರಂ ಪ್ರೇರಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","ಅನನ್ತರಂ ಪ್ರಹರೈಕವೇಲಾಯಾಂ ಗತ್ವಾ ಹಟ್ಟೇ ಕತಿಪಯಾನ್ ನಿಷ್ಕರ್ಮ್ಮಕಾನ್ ವಿಲೋಕ್ಯ ತಾನವದತ್, ");
INSERT INTO sankan_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ಯೂಯಮಪಿ ಮಮ ದ್ರಾಕ್ಷಾಕ್ಷೇತ್ರಂ ಯಾತ, ಯುಷ್ಮಭ್ಯಮಹಂ ಯೋಗ್ಯಭೃತಿಂ ದಾಸ್ಯಾಮಿ, ತತಸ್ತೇ ವವ್ರಜುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","ಪುನಶ್ಚ ಸ ದ್ವಿತೀಯತೃತೀಯಯೋಃ ಪ್ರಹರಯೋ ರ್ಬಹಿ ರ್ಗತ್ವಾ ತಥೈವ ಕೃತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","ತತೋ ದಣ್ಡದ್ವಯಾವಶಿಷ್ಟಾಯಾಂ ವೇಲಾಯಾಂ ಬಹಿ ರ್ಗತ್ವಾಪರಾನ್ ಕತಿಪಯಜನಾನ್ ನಿಷ್ಕರ್ಮ್ಮಕಾನ್ ವಿಲೋಕ್ಯ ಪೃಷ್ಟವಾನ್, ಯೂಯಂ ಕಿಮರ್ಥಮ್ ಅತ್ರ ಸರ್ವ್ವಂ ದಿನಂ ನಿಷ್ಕರ್ಮ್ಮಾಣಸ್ತಿಷ್ಠಥ? ");
INSERT INTO sankan_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","ತೇ ಪ್ರತ್ಯವದನ್, ಅಸ್ಮಾನ್ ನ ಕೋಪಿ ಕರ್ಮಮಣಿ ನಿಯುಂಕ್ತೇ| ತದಾನೀಂ ಸ ಕಥಿತವಾನ್, ಯೂಯಮಪಿ ಮಮ ದ್ರಾಕ್ಷಾಕ್ಷೇತ್ರಂ ಯಾತ, ತೇನ ಯೋಗ್ಯಾಂ ಭೃತಿಂ ಲಪ್ಸ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","ತದನನ್ತರಂ ಸನ್ಧ್ಯಾಯಾಂ ಸತ್ಯಾಂ ಸಏವ ದ್ರಾಕ್ಷಾಕ್ಷೇತ್ರಪತಿರಧ್ಯಕ್ಷಂ ಗದಿವಾನ್, ಕೃಷಕಾನ್ ಆಹೂಯ ಶೇಷಜನಮಾರಭ್ಯ ಪ್ರಥಮಂ ಯಾವತ್ ತೇಭ್ಯೋ ಭೃತಿಂ ದೇಹಿ| ");
INSERT INTO sankan_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","ತೇನ ಯೇ ದಣ್ಡದ್ವಯಾವಸ್ಥಿತೇ ಸಮಾಯಾತಾಸ್ತೇಷಾಮ್ ಏಕೈಕೋ ಜನೋ ಮುದ್ರಾಚತುರ್ಥಾಂಶಂ ಪ್ರಾಪ್ನೋತ್| ");
INSERT INTO sankan_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ತದಾನೀಂ ಪ್ರಥಮನಿಯುಕ್ತಾ ಜನಾ ಆಗತ್ಯಾನುಮಿತವನ್ತೋ ವಯಮಧಿಕಂ ಪ್ರಪ್ಸ್ಯಾಮಃ, ಕಿನ್ತು ತೈರಪಿ ಮುದ್ರಾಚತುರ್ಥಾಂಶೋಽಲಾಭಿ| ");
INSERT INTO sankan_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ತತಸ್ತೇ ತಂ ಗೃಹೀತ್ವಾ ತೇನ ಕ್ಷೇತ್ರಪತಿನಾ ಸಾಕಂ ವಾಗ್ಯುದ್ಧಂ ಕುರ್ವ್ವನ್ತಃ ಕಥಯಾಮಾಸುಃ, ");
INSERT INTO sankan_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ವಯಂ ಕೃತ್ಸ್ನಂ ದಿನಂ ತಾಪಕ್ಲೇಶೌ ಸೋಢವನ್ತಃ, ಕಿನ್ತು ಪಶ್ಚಾತಾಯಾ ಸೇ ಜನಾ ದಣ್ಡದ್ವಯಮಾತ್ರಂ ಪರಿಶ್ರಾನ್ತವನ್ತಸ್ತೇಽಸ್ಮಾಭಿಃ ಸಮಾನಾಂಶಾಃ ಕೃತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","ತತಃ ಸ ತೇಷಾಮೇಕಂ ಪ್ರತ್ಯುವಾಚ, ಹೇ ವತ್ಸ, ಮಯಾ ತ್ವಾಂ ಪ್ರತಿ ಕೋಪ್ಯನ್ಯಾಯೋ ನ ಕೃತಃ ಕಿಂ ತ್ವಯಾ ಮತ್ಸಮಕ್ಷಂ ಮುದ್ರಾಚತುರ್ಥಾಂಶೋ ನಾಙ್ಗೀಕೃತಃ? ");
INSERT INTO sankan_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ತಸ್ಮಾತ್ ತವ ಯತ್ ಪ್ರಾಪ್ಯಂ ತದಾದಾಯ ಯಾಹಿ, ತುಭ್ಯಂ ಯತಿ, ಪಶ್ಚಾತೀಯನಿಯುಕ್ತಲೋಕಾಯಾಪಿ ತತಿ ದಾತುಮಿಚ್ಛಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ಸ್ವೇಚ್ಛಯಾ ನಿಜದ್ರವ್ಯವ್ಯವಹರಣಂ ಕಿಂ ಮಯಾ ನ ಕರ್ತ್ತವ್ಯಂ? ಮಮ ದಾತೃತ್ವಾತ್ ತ್ವಯಾ ಕಿಮ್ ಈರ್ಷ್ಯಾದೃಷ್ಟಿಃ ಕ್ರಿಯತೇ? ");
INSERT INTO sankan_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","ಇತ್ಥಮ್ ಅಗ್ರೀಯಲೋಕಾಃ ಪಶ್ಚತೀಯಾ ಭವಿಷ್ಯನ್ತಿ, ಪಶ್ಚಾತೀಯಜನಾಶ್ಚಗ್ರೀಯಾ ಭವಿಷ್ಯನ್ತಿ, ಅಹೂತಾ ಬಹವಃ ಕಿನ್ತ್ವಲ್ಪೇ ಮನೋಭಿಲಷಿತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ತದನನ್ತರಂ ಯೀಶು ರ್ಯಿರೂಶಾಲಮ್ನಗರಂ ಗಚ್ಛನ್ ಮಾರ್ಗಮಧ್ಯೇ ಶಿಷ್ಯಾನ್ ಏಕಾನ್ತೇ ವಭಾಷೇ, ");
INSERT INTO sankan_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","ಪಶ್ಯ ವಯಂ ಯಿರೂಶಾಲಮ್ನಗರಂ ಯಾಮಃ, ತತ್ರ ಪ್ರಧಾನಯಾಜಕಾಧ್ಯಾಪಕಾನಾಂ ಕರೇಷು ಮನುಷ್ಯಪುತ್ರಃ ಸಮರ್ಪಿಷ್ಯತೇ; ");
INSERT INTO sankan_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ತೇ ಚ ತಂ ಹನ್ತುಮಾಜ್ಞಾಪ್ಯ ತಿರಸ್ಕೃತ್ಯ ವೇತ್ರೇಣ ಪ್ರಹರ್ತ್ತುಂ ಕ್ರುಶೇ ಧಾತಯಿತುಞ್ಚಾನ್ಯದೇಶೀಯಾನಾಂ ಕರೇಷು ಸಮರ್ಪಯಿಷ್ಯನ್ತಿ, ಕಿನ್ತು ಸ ತೃತೀಯದಿವಸೇ ಶ್ಮಶಾನಾದ್ ಉತ್ಥಾಪಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","ತದಾನೀಂ ಸಿವದೀಯಸ್ಯ ನಾರೀ ಸ್ವಪುತ್ರಾವಾದಾಯ ಯೀಶೋಃ ಸಮೀಪಮ್ ಏತ್ಯ ಪ್ರಣಮ್ಯ ಕಞ್ಚನಾನುಗ್ರಹಂ ತಂ ಯಯಾಚೇ| ");
INSERT INTO sankan_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ತದಾ ಯೀಶುಸ್ತಾಂ ಪ್ರೋಕ್ತವಾನ್, ತ್ವಂ ಕಿಂ ಯಾಚಸೇ? ತತಃ ಸಾ ಬಭಾಷೇ, ಭವತೋ ರಾಜತ್ವೇ ಮಮಾನಯೋಃ ಸುತಯೋರೇಕಂ ಭವದ್ದಕ್ಷಿಣಪಾರ್ಶ್ವೇ ದ್ವಿತೀಯಂ ವಾಮಪಾರ್ಶ್ವ ಉಪವೇಷ್ಟುಮ್ ಆಜ್ಞಾಪಯತು| ");
INSERT INTO sankan_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ಯೀಶುಃ ಪ್ರತ್ಯುವಾಚ, ಯುವಾಭ್ಯಾಂ ಯದ್ ಯಾಚ್ಯತೇ, ತನ್ನ ಬುಧ್ಯತೇ, ಅಹಂ ಯೇನ ಕಂಸೇನ ಪಾಸ್ಯಾಮಿ ಯುವಾಭ್ಯಾಂ ಕಿಂ ತೇನ ಪಾತುಂ ಶಕ್ಯತೇ? ಅಹಞ್ಚ ಯೇನ ಮಜ್ಜೇನೇನ ಮಜ್ಜಿಷ್ಯೇ, ಯುವಾಭ್ಯಾಂ ಕಿಂ ತೇನ ಮಜ್ಜಯಿತುಂ ಶಕ್ಯತೇ? ತೇ ಜಗದುಃ ಶಕ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ತದಾ ಸ ಉಕ್ತವಾನ್, ಯುವಾಂ ಮಮ ಕಂಸೇನಾವಶ್ಯಂ ಪಾಸ್ಯಥಃ, ಮಮ ಮಜ್ಜನೇನ ಚ ಯುವಾಮಪಿ ಮಜ್ಜಿಷ್ಯೇಥೇ, ಕಿನ್ತು ಯೇಷಾಂ ಕೃತೇ ಮತ್ತಾತೇನ ನಿರೂಪಿತಮ್ ಇದಂ ತಾನ್ ವಿಹಾಯಾನ್ಯಂ ಕಮಪಿ ಮದ್ದಕ್ಷಿಣಪಾರ್ಶ್ವೇ ವಾಮಪಾರ್ಶ್ವೇ ಚ ಸಮುಪವೇಶಯಿತುಂ ಮಮಾಧಿಕಾರೋ ನಾಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ಏತಾಂ ಕಥಾಂ ಶ್ರುತ್ವಾನ್ಯೇ ದಶಶಿಷ್ಯಾಸ್ತೌ ಭ್ರಾತರೌ ಪ್ರತಿ ಚುಕುಪುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ಕಿನ್ತು ಯೀಶುಃ ಸ್ವಸಮೀಪಂ ತಾನಾಹೂಯ ಜಗಾದ, ಅನ್ಯದೇಶೀಯಲೋಕಾನಾಂ ನರಪತಯಸ್ತಾನ್ ಅಧಿಕುರ್ವ್ವನ್ತಿ, ಯೇ ತು ಮಹಾನ್ತಸ್ತೇ ತಾನ್ ಶಾಸತಿ, ಇತಿ ಯೂಯಂ ಜಾನೀಥ| ");
INSERT INTO sankan_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","ಕಿನ್ತು ಯುಷ್ಮಾಕಂ ಮಧ್ಯೇ ನ ತಥಾ ಭವೇತ್, ಯುಷ್ಮಾಕಂ ಯಃ ಕಶ್ಚಿತ್ ಮಹಾನ್ ಬುಭೂಷತಿ, ಸ ಯುಷ್ಮಾನ್ ಸೇವೇತ; ");
INSERT INTO sankan_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ಯಶ್ಚ ಯುಷ್ಮಾಕಂ ಮಧ್ಯೇ ಮುಖ್ಯೋ ಬುಭೂಷತಿ, ಸ ಯುಷ್ಮಾಕಂ ದಾಸೋ ಭವೇತ್| ");
INSERT INTO sankan_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ಇತ್ಥಂ ಮನುಜಪುತ್ರಃ ಸೇವ್ಯೋ ಭವಿತುಂ ನಹಿ, ಕಿನ್ತು ಸೇವಿತುಂ ಬಹೂನಾಂ ಪರಿತ್ರಾಣಮೂಲ್ಯಾರ್ಥಂ ಸ್ವಪ್ರಾಣಾನ್ ದಾತುಞ್ಚಾಗತಃ| ");
INSERT INTO sankan_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","ಅನನ್ತರಂ ಯಿರೀಹೋನಗರಾತ್ ತೇಷಾಂ ಬಹಿರ್ಗಮನಸಮಯೇ ತಸ್ಯ ಪಶ್ಚಾದ್ ಬಹವೋ ಲೋಕಾ ವವ್ರಜುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ಅಪರಂ ವರ್ತ್ಮಪಾರ್ಶ್ವ ಉಪವಿಶನ್ತೌ ದ್ವಾವನ್ಧೌ ತೇನ ಮಾರ್ಗೇಣ ಯೀಶೋ ರ್ಗಮನಂ ನಿಶಮ್ಯ ಪ್ರೋಚ್ಚೈಃ ಕಥಯಾಮಾಸತುಃ, ಹೇ ಪ್ರಭೋ ದಾಯೂದಃ ಸನ್ತಾನ, ಆವಯೋ ರ್ದಯಾಂ ವಿಧೇಹಿ| ");
INSERT INTO sankan_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ತತೋ ಲೋಕಾಃ ಸರ್ವ್ವೇ ತುಷ್ಣೀಮ್ಭವತಮಿತ್ಯುಕ್ತ್ವಾ ತೌ ತರ್ಜಯಾಮಾಸುಃ; ತಥಾಪಿ ತೌ ಪುನರುಚ್ಚೈಃ ಕಥಯಾಮಾಸತುಃ ಹೇ ಪ್ರಭೋ ದಾಯೂದಃ ಸನ್ತಾನ, ಆವಾಂ ದಯಸ್ವ| ");
INSERT INTO sankan_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ತದಾನೀಂ ಯೀಶುಃ ಸ್ಥಗಿತಃ ಸನ್ ತಾವಾಹೂಯ ಭಾಷಿತವಾನ್, ಯುವಯೋಃ ಕೃತೇ ಮಯಾ ಕಿಂ ಕರ್ತ್ತರ್ವ್ಯಂ? ಯುವಾಂ ಕಿಂ ಕಾಮಯೇಥೇ? ");
INSERT INTO sankan_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ತದಾ ತಾವುಕ್ತವನ್ತೌ, ಪ್ರಭೋ ನೇತ್ರಾಣಿ ನೌ ಪ್ರಸನ್ನಾನಿ ಭವೇಯುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ತದಾನೀಂ ಯೀಶುಸ್ತೌ ಪ್ರತಿ ಪ್ರಮನ್ನಃ ಸನ್ ತಯೋ ರ್ನೇತ್ರಾಣಿ ಪಸ್ಪರ್ಶ, ತೇನೈವ ತೌ ಸುವೀಕ್ಷಾಞ್ಚಕ್ರಾತೇ ತತ್ಪಶ್ಚಾತ್ ಜಗ್ಮುತುಶ್ಚ| ");
INSERT INTO sankan_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","ಅನನ್ತರಂ ತೇಷು ಯಿರೂಶಾಲಮ್ನಗರಸ್ಯ ಸಮೀಪವೇರ್ತ್ತಿನೋ ಜೈತುನನಾಮಕಧರಾಧರಸ್ಯ ಸಮೀಪಸ್ಥ್ತಿಂ ಬೈತ್ಫಗಿಗ್ರಾಮಮ್ ಆಗತೇಷು, ಯೀಶುಃ ಶಿಷ್ಯದ್ವಯಂ ಪ್ರೇಷಯನ್ ಜಗಾದ, ");
INSERT INTO sankan_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ಯುವಾಂ ಸಮ್ಮುಖಸ್ಥಗ್ರಾಮಂ ಗತ್ವಾ ಬದ್ಧಾಂ ಯಾಂ ಸವತ್ಸಾಂ ಗರ್ದ್ದಭೀಂ ಹಠಾತ್ ಪ್ರಾಪ್ಸ್ಯಥಃ, ತಾಂ ಮೋಚಯಿತ್ವಾ ಮದನ್ತಿಕಮ್ ಆನಯತಂ| ");
INSERT INTO sankan_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","ತತ್ರ ಯದಿ ಕಶ್ಚಿತ್ ಕಿಞ್ಚಿದ್ ವಕ್ಷ್ಯತಿ, ತರ್ಹಿ ವದಿಷ್ಯಥಃ, ಏತಸ್ಯಾಂ ಪ್ರಭೋಃ ಪ್ರಯೋಜನಮಾಸ್ತೇ, ತೇನ ಸ ತತ್ಕ್ಷಣಾತ್ ಪ್ರಹೇಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ಸೀಯೋನಃ ಕನ್ಯಕಾಂ ಯೂಯಂ ಭಾಷಧ್ವಮಿತಿ ಭಾರತೀಂ| ಪಶ್ಯ ತೇ ನಮ್ರಶೀಲಃ ಸನ್ ನೃಪ ಆರುಹ್ಯ ಗರ್ದಭೀಂ| ಅರ್ಥಾದಾರುಹ್ಯ ತದ್ವತ್ಸಮಾಯಾಸ್ಯತಿ ತ್ವದನ್ತಿಕಂ| ");
INSERT INTO sankan_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","ಭವಿಷ್ಯದ್ವಾದಿನೋಕ್ತಂ ವಚನಮಿದಂ ತದಾ ಸಫಲಮಭೂತ್| ");
INSERT INTO sankan_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","ಅನನ್ತರಂ ತೌ ಶ್ಷ್ಯಿौ ಯೀಶೋ ರ್ಯಥಾನಿದೇಶಂ ತಂ ಗ್ರಾಮಂ ಗತ್ವಾ ");
INSERT INTO sankan_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ಗರ್ದಭೀಂ ತದ್ವತ್ಸಞ್ಚ ಸಮಾನೀತವನ್ತೌ, ಪಶ್ಚಾತ್ ತದುಪರಿ ಸ್ವೀಯವಸನಾನೀ ಪಾತಯಿತ್ವಾ ತಮಾರೋಹಯಾಮಾಸತುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ತತೋ ಬಹವೋ ಲೋಕಾ ನಿಜವಸನಾನಿ ಪಥಿ ಪ್ರಸಾರಯಿತುಮಾರೇಭಿರೇ, ಕತಿಪಯಾ ಜನಾಶ್ಚ ಪಾದಪಪರ್ಣಾದಿಕಂ ಛಿತ್ವಾ ಪಥಿ ವಿಸ್ತಾರಯಾಮಾಸುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ಅಗ್ರಗಾಮಿನಃ ಪಶ್ಚಾದ್ಗಾಮಿನಶ್ಚ ಮನುಜಾ ಉಚ್ಚೈರ್ಜಯ ಜಯ ದಾಯೂದಃ ಸನ್ತಾನೇತಿ ಜಗದುಃ ಪರಮೇಶ್ವರಸ್ಯ ನಾಮ್ನಾ ಯ ಆಯಾತಿ ಸ ಧನ್ಯಃ, ಸರ್ವ್ವೋಪರಿಸ್ಥಸ್ವರ್ಗೇಪಿ ಜಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ಇತ್ಥಂ ತಸ್ಮಿನ್ ಯಿರೂಶಾಲಮಂ ಪ್ರವಿಷ್ಟೇ ಕೋಽಯಮಿತಿ ಕಥನಾತ್ ಕೃತ್ಸ್ನಂ ನಗರಂ ಚಞ್ಚಲಮಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","ತತ್ರ ಲೋಕೋಃ ಕಥಯಾಮಾಸುಃ, ಏಷ ಗಾಲೀಲ್ಪ್ರದೇಶೀಯ-ನಾಸರತೀಯ-ಭವಿಷ್ಯದ್ವಾದೀ ಯೀಶುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ಅನನ್ತರಂ ಯೀಶುರೀಶ್ವರಸ್ಯ ಮನ್ದಿರಂ ಪ್ರವಿಶ್ಯ ತನ್ಮಧ್ಯಾತ್ ಕ್ರಯವಿಕ್ರಯಿಣೋ ವಹಿಶ್ಚಕಾರ; ವಣಿಜಾಂ ಮುದ್ರಾಸನಾನೀ ಕಪೋತವಿಕ್ರಯಿಣಾಞ್ಚಸನಾನೀ ಚ ನ್ಯುವ್ಜಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ಅಪರಂ ತಾನುವಾಚ, ಏಷಾ ಲಿಪಿರಾಸ್ತೇ, \"ಮಮ ಗೃಹಂ ಪ್ರಾರ್ಥನಾಗೃಹಮಿತಿ ವಿಖ್ಯಾಸ್ಯತಿ\", ಕಿನ್ತು ಯೂಯಂ ತದ್ ದಸ್ಯೂನಾಂ ಗಹ್ವರಂ ಕೃತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","ತದನನ್ತರಮ್ ಅನ್ಧಖಞ್ಚಲೋಕಾಸ್ತಸ್ಯ ಸಮೀಪಮಾಗತಾಃ, ಸ ತಾನ್ ನಿರಾಮಯಾನ್ ಕೃತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ಯದಾ ಪ್ರಧಾನಯಾಜಕಾ ಅಧ್ಯಾಪಕಾಶ್ಚ ತೇನ ಕೃತಾನ್ಯೇತಾನಿ ಚಿತ್ರಕರ್ಮ್ಮಾಣಿ ದದೃಶುಃ, ಜಯ ಜಯ ದಾಯೂದಃ ಸನ್ತಾನ, ಮನ್ದಿರೇ ಬಾಲಕಾನಾಮ್ ಏತಾದೃಶಮ್ ಉಚ್ಚಧ್ವನಿಂ ಶುಶ್ರುವುಶ್ಚ, ತದಾ ಮಹಾಕ್ರುದ್ಧಾ ಬಭೂವಃ, ");
INSERT INTO sankan_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ತಂ ಪಪ್ರಚ್ಛುಶ್ಚ, ಇಮೇ ಯದ್ ವದನ್ತಿ, ತತ್ ಕಿಂ ತ್ವಂ ಶೃಣೋಷಿ? ತತೋ ಯೀಶುಸ್ತಾನ್ ಅವೋಚತ್, ಸತ್ಯಮ್; ಸ್ತನ್ಯಪಾಯಿಶಿಶೂನಾಞ್ಚ ಬಾಲಕಾನಾಞ್ಚ ವಕ್ತ್ರತಃ| ಸ್ವಕೀಯಂ ಮಹಿಮಾನಂ ತ್ವಂ ಸಂಪ್ರಕಾಶಯಸಿ ಸ್ವಯಂ| ಏತದ್ವಾಕ್ಯಂ ಯೂಯಂ ಕಿಂ ನಾಪಠತ? ");
INSERT INTO sankan_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ತತಸ್ತಾನ್ ವಿಹಾಯ ಸ ನಗರಾದ್ ಬೈಥನಿಯಾಗ್ರಾಮಂ ಗತ್ವಾ ತತ್ರ ರಜನೀಂ ಯಾಪಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","ಅನನ್ತರಂ ಪ್ರಭಾತೇ ಸತಿ ಯೀಶುಃ ಪುನರಪಿ ನಗರಮಾಗಚ್ಛನ್ ಕ್ಷುಧಾರ್ತ್ತೋ ಬಭೂವ| ");
INSERT INTO sankan_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ತತೋ ಮಾರ್ಗಪಾರ್ಶ್ವ ಉಡುಮ್ಬರವೃಕ್ಷಮೇಕಂ ವಿಲೋಕ್ಯ ತತ್ಸಮೀಪಂ ಗತ್ವಾ ಪತ್ರಾಣಿ ವಿನಾ ಕಿಮಪಿ ನ ಪ್ರಾಪ್ಯ ತಂ ಪಾದಪಂ ಪ್ರೋವಾಚ, ಅದ್ಯಾರಭ್ಯ ಕದಾಪಿ ತ್ವಯಿ ಫಲಂ ನ ಭವತು; ತೇನ ತತ್ಕ್ಷಣಾತ್ ಸ ಉಡುಮ್ಬರಮಾಹೀರುಹಃ ಶುಷ್ಕತಾಂ ಗತಃ| ");
INSERT INTO sankan_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ತದ್ ದೃಷ್ಟ್ವಾ ಶಿಷ್ಯಾ ಆಶ್ಚರ್ಯ್ಯಂ ವಿಜ್ಞಾಯ ಕಥಯಾಮಾಸುಃ, ಆಃ, ಉಡುಮ್ವರಪಾದಪೋಽತಿತೂರ್ಣಂ ಶುಷ್ಕೋಽಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ತತೋ ಯೀಶುಸ್ತಾನುವಾಚ, ಯುಷ್ಮಾನಹಂ ಸತ್ಯಂ ವದಾಮಿ, ಯದಿ ಯೂಯಮಸನ್ದಿಗ್ಧಾಃ ಪ್ರತೀಥ, ತರ್ಹಿ ಯೂಯಮಪಿ ಕೇವಲೋಡುಮ್ವರಪಾದಪಂ ಪ್ರತೀತ್ಥಂ ಕರ್ತ್ತುಂ ಶಕ್ಷ್ಯಥ, ತನ್ನ, ತ್ವಂ ಚಲಿತ್ವಾ ಸಾಗರೇ ಪತೇತಿ ವಾಕ್ಯಂ ಯುಷ್ಮಾಭಿರಸ್ಮಿನ ಶೈಲೇ ಪ್ರೋಕ್ತೇಪಿ ತದೈವ ತದ್ ಘಟಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","ತಥಾ ವಿಶ್ವಸ್ಯ ಪ್ರಾರ್ಥ್ಯ ಯುಷ್ಮಾಭಿ ರ್ಯದ್ ಯಾಚಿಷ್ಯತೇ, ತದೇವ ಪ್ರಾಪ್ಸ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","ಅನನ್ತರಂ ಮನ್ದಿರಂ ಪ್ರವಿಶ್ಯೋಪದೇಶನಸಮಯೇ ತತ್ಸಮೀಪಂ ಪ್ರಧಾನಯಾಜಕಾಃ ಪ್ರಾಚೀನಲೋಕಾಶ್ಚಾಗತ್ಯ ಪಪ್ರಚ್ಛುಃ, ತ್ವಯಾ ಕೇನ ಸಾಮರ್ಥ್ಯನೈತಾನಿ ಕರ್ಮ್ಮಾಣಿ ಕ್ರಿಯನ್ತೇ? ಕೇನ ವಾ ತುಭ್ಯಮೇತಾನಿ ಸಾಮರ್ಥ್ಯಾನಿ ದತ್ತಾನಿ? ");
INSERT INTO sankan_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ತತೋ ಯೀಶುಃ ಪ್ರತ್ಯವದತ್, ಅಹಮಪಿ ಯುಷ್ಮಾನ್ ವಾಚಮೇಕಾಂ ಪೃಚ್ಛಾಮಿ, ಯದಿ ಯೂಯಂ ತದುತ್ತರಂ ದಾತುಂ ಶಕ್ಷ್ಯಥ, ತದಾ ಕೇನ ಸಾಮರ್ಥ್ಯೇನ ಕರ್ಮ್ಮಾಣ್ಯೇತಾನಿ ಕರೋಮಿ, ತದಹಂ ಯುಷ್ಮಾನ್ ವಕ್ಷ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","ಯೋಹನೋ ಮಜ್ಜನಂ ಕಸ್ಯಾಜ್ಞಯಾಭವತ್? ಕಿಮೀಶ್ವರಸ್ಯ ಮನುಷ್ಯಸ್ಯ ವಾ? ತತಸ್ತೇ ಪರಸ್ಪರಂ ವಿವಿಚ್ಯ ಕಥಯಾಮಾಸುಃ, ಯದೀಶ್ವರಸ್ಯೇತಿ ವದಾಮಸ್ತರ್ಹಿ ಯೂಯಂ ತಂ ಕುತೋ ನ ಪ್ರತ್ಯೈತ? ವಾಚಮೇತಾಂ ವಕ್ಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","ಮನುಷ್ಯಸ್ಯೇತಿ ವಕ್ತುಮಪಿ ಲೋಕೇಭ್ಯೋ ಬಿಭೀಮಃ, ಯತಃ ಸರ್ವ್ವೈರಪಿ ಯೋಹನ್ ಭವಿಷ್ಯದ್ವಾದೀತಿ ಜ್ಞಾಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","ತಸ್ಮಾತ್ ತೇ ಯೀಶುಂ ಪ್ರತ್ಯವದನ್, ತದ್ ವಯಂ ನ ವಿದ್ಮಃ| ತದಾ ಸ ತಾನುಕ್ತವಾನ್, ತರ್ಹಿ ಕೇನ ಸಾಮರಥ್ಯೇನ ಕರ್ಮ್ಮಾಣ್ಯೇತಾನ್ಯಹಂ ಕರೋಮಿ, ತದಪ್ಯಹಂ ಯುಷ್ಮಾನ್ ನ ವಕ್ಷ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","ಕಸ್ಯಚಿಜ್ಜನಸ್ಯ ದ್ವೌ ಸುತಾವಾಸ್ತಾಂ ಸ ಏಕಸ್ಯ ಸುತಸ್ಯ ಸಮೀಪಂ ಗತ್ವಾ ಜಗಾದ, ಹೇ ಸುತ, ತ್ವಮದ್ಯ ಮಮ ದ್ರಾಕ್ಷಾಕ್ಷೇತ್ರೇ ಕರ್ಮ್ಮ ಕರ್ತುಂ ವ್ರಜ| ");
INSERT INTO sankan_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ತತಃ ಸ ಉಕ್ತವಾನ್, ನ ಯಾಸ್ಯಾಮಿ, ಕಿನ್ತು ಶೇಷೇಽನುತಪ್ಯ ಜಗಾಮ| ");
INSERT INTO sankan_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","ಅನನ್ತರಂ ಸೋನ್ಯಸುತಸ್ಯ ಸಮೀಪಂ ಗತ್ವಾ ತಥೈವ ಕಥ್ತಿವಾನ್; ತತಃ ಸ ಪ್ರತ್ಯುವಾಚ, ಮಹೇಚ್ಛ ಯಾಮಿ, ಕಿನ್ತು ನ ಗತಃ| ");
INSERT INTO sankan_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","ಏತಯೋಃ ಪುತ್ರಯೋ ರ್ಮಧ್ಯೇ ಪಿತುರಭಿಮತಂ ಕೇನ ಪಾಲಿತಂ? ಯುಷ್ಮಾಭಿಃ ಕಿಂ ಬುಧ್ಯತೇ? ತತಸ್ತೇ ಪ್ರತ್ಯೂಚುಃ, ಪ್ರಥಮೇನ ಪುुತ್ರೇಣ| ತದಾನೀಂ ಯೀಶುಸ್ತಾನುವಾಚ, ಅಹಂ ಯುಷ್ಮಾನ್ ತಥ್ಯಂ ವದಾಮಿ, ಚಣ್ಡಾಲಾ ಗಣಿಕಾಶ್ಚ ಯುಷ್ಮಾಕಮಗ್ರತ ಈಶ್ವರಸ್ಯ ರಾಜ್ಯಂ ಪ್ರವಿಶನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ಯತೋ ಯುಷ್ಮಾಕಂ ಸಮೀಪಂ ಯೋಹನಿ ಧರ್ಮ್ಮಪಥೇನಾಗತೇ ಯೂಯಂ ತಂ ನ ಪ್ರತೀಥ, ಕಿನ್ತು ಚಣ್ಡಾಲಾ ಗಣಿಕಾಶ್ಚ ತಂ ಪ್ರತ್ಯಾಯನ್, ತದ್ ವಿಲೋಕ್ಯಾಪಿ ಯೂಯಂ ಪ್ರತ್ಯೇತುಂ ನಾಖಿದ್ಯಧ್ವಂ| ");
INSERT INTO sankan_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","ಅಪರಮೇಕಂ ದೃಷ್ಟಾನ್ತಂ ಶೃಣುತ, ಕಶ್ಚಿದ್ ಗೃಹಸ್ಥಃ ಕ್ಷೇತ್ರೇ ದ್ರಾಕ್ಷಾಲತಾ ರೋಪಯಿತ್ವಾ ತಚ್ಚತುರ್ದಿಕ್ಷು ವಾರಣೀಂ ವಿಧಾಯ ತನ್ಮಧ್ಯೇ ದ್ರಾಕ್ಷಾಯನ್ತ್ರಂ ಸ್ಥಾಪಿತವಾನ್, ಮಾಞ್ಚಞ್ಚ ನಿರ್ಮ್ಮಿತವಾನ್, ತತಃ ಕೃಷಕೇಷು ತತ್ ಕ್ಷೇತ್ರಂ ಸಮರ್ಪ್ಯ ಸ್ವಯಂ ದೂರದೇಶಂ ಜಗಾಮ| ");
INSERT INTO sankan_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","ತದನನ್ತರಂ ಫಲಸಮಯ ಉಪಸ್ಥಿತೇ ಸ ಫಲಾನಿ ಪ್ರಾಪ್ತುಂ ಕೃಷೀವಲಾನಾಂ ಸಮೀಪಂ ನಿಜದಾಸಾನ್ ಪ್ರೇಷಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","ಕಿನ್ತು ಕೃಷೀವಲಾಸ್ತಸ್ಯ ತಾನ್ ದಾಸೇಯಾನ್ ಧೃತ್ವಾ ಕಞ್ಚನ ಪ್ರಹೃತವನ್ತಃ, ಕಞ್ಚನ ಪಾಷಾಣೈರಾಹತವನ್ತಃ, ಕಞ್ಚನ ಚ ಹತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","ಪುನರಪಿ ಸ ಪ್ರಭುಃ ಪ್ರಥಮತೋಽಧಿಕದಾಸೇಯಾನ್ ಪ್ರೇಷಯಾಮಾಸ, ಕಿನ್ತು ತೇ ತಾನ್ ಪ್ರತ್ಯಪಿ ತಥೈವ ಚಕ್ರುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","ಅನನ್ತರಂ ಮಮ ಸುತೇ ಗತೇ ತಂ ಸಮಾದರಿಷ್ಯನ್ತೇ, ಇತ್ಯುಕ್ತ್ವಾ ಶೇಷೇ ಸ ನಿಜಸುತಂ ತೇಷಾಂ ಸನ್ನಿಧಿಂ ಪ್ರೇಷಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","ಕಿನ್ತು ತೇ ಕೃಷೀವಲಾಃ ಸುತಂ ವೀಕ್ಷ್ಯ ಪರಸ್ಪರಮ್ ಇತಿ ಮನ್ತ್ರಯಿತುಮ್ ಆರೇಭಿರೇ, ಅಯಮುತ್ತರಾಧಿಕಾರೀ ವಯಮೇನಂ ನಿಹತ್ಯಾಸ್ಯಾಧಿಕಾರಂ ಸ್ವವಶೀಕರಿಷ್ಯಾಮಃ| ");
INSERT INTO sankan_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","ಪಶ್ಚಾತ್ ತೇ ತಂ ಧೃತ್ವಾ ದ್ರಾಕ್ಷಾಕ್ಷೇತ್ರಾದ್ ಬಹಿಃ ಪಾತಯಿತ್ವಾಬಧಿಷುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","ಯದಾ ಸ ದ್ರಾಕ್ಷಾಕ್ಷೇತ್ರಪತಿರಾಗಮಿಷ್ಯತಿ, ತದಾ ತಾನ್ ಕೃಷೀವಲಾನ್ ಕಿಂ ಕರಿಷ್ಯತಿ? ");
INSERT INTO sankan_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ತತಸ್ತೇ ಪ್ರತ್ಯವದನ್, ತಾನ್ ಕಲುಷಿಣೋ ದಾರುಣಯಾತನಾಭಿರಾಹನಿಷ್ಯತಿ, ಯೇ ಚ ಸಮಯಾನುಕ್ರಮಾತ್ ಫಲಾನಿ ದಾಸ್ಯನ್ತಿ, ತಾದೃಶೇಷು ಕೃಷೀವಲೇಷು ಕ್ಷೇತ್ರಂ ಸಮರ್ಪಯಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ತದಾ ಯೀಶುನಾ ತೇ ಗದಿತಾಃ, ಗ್ರಹಣಂ ನ ಕೃತಂ ಯಸ್ಯ ಪಾಷಾಣಸ್ಯ ನಿಚಾಯಕೈಃ| ಪ್ರಧಾನಪ್ರಸ್ತರಃ ಕೋಣೇ ಸಏವ ಸಂಭವಿಷ್ಯತಿ| ಏತತ್ ಪರೇಶಿತುಃ ಕರ್ಮ್ಮಾಸ್ಮದೃಷ್ಟಾವದ್ಭುತಂ ಭವೇತ್| ಧರ್ಮ್ಮಗ್ರನ್ಥೇ ಲಿಖಿತಮೇತದ್ವಚನಂ ಯುಷ್ಮಾಭಿಃ ಕಿಂ ನಾಪಾಠಿ? ");
INSERT INTO sankan_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","ತಸ್ಮಾದಹಂ ಯುಷ್ಮಾನ್ ವದಾಮಿ, ಯುಷ್ಮತ್ತ ಈಶ್ವರೀಯರಾಜ್ಯಮಪನೀಯ ಫಲೋತ್ಪಾದಯಿತ್ರನ್ಯಜಾತಯೇ ದಾಯಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","ಯೋ ಜನ ಏತತ್ಪಾಷಾಣೋಪರಿ ಪತಿಷ್ಯತಿ, ತಂ ಸ ಭಂಕ್ಷ್ಯತೇ, ಕಿನ್ತ್ವಯಂ ಪಾಷಾಣೋ ಯಸ್ಯೋಪರಿ ಪತಿಷ್ಯತಿ, ತಂ ಸ ಧೂಲಿವತ್ ಚೂರ್ಣೀಕರಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","ತದಾನೀಂ ಪ್ರಾಧನಯಾಜಕಾಃ ಫಿರೂಶಿನಶ್ಚ ತಸ್ಯೇಮಾಂ ದೃಷ್ಟಾನ್ತಕಥಾಂ ಶ್ರುತ್ವಾ ಸೋಽಸ್ಮಾನುದ್ದಿಶ್ಯ ಕಥಿತವಾನ್, ಇತಿ ವಿಜ್ಞಾಯ ತಂ ಧರ್ತ್ತುಂ ಚೇಷ್ಟಿತವನ್ತಃ; ");
INSERT INTO sankan_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ಕಿನ್ತು ಲೋಕೇಭ್ಯೋ ಬಿಭ್ಯುಃ, ಯತೋ ಲೋಕೈಃ ಸ ಭವಿಷ್ಯದ್ವಾದೀತ್ಯಜ್ಞಾಯಿ| ");
INSERT INTO sankan_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","ಅನನ್ತರಂ ಯೀಶುಃ ಪುನರಪಿ ದೃಷ್ಟಾನ್ತೇನ ತಾನ್ ಅವಾದೀತ್, ");
INSERT INTO sankan_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","ಸ್ವರ್ಗೀಯರಾಜ್ಯಮ್ ಏತಾದೃಶಸ್ಯ ನೃಪತೇಃ ಸಮಂ, ಯೋ ನಿಜ ಪುತ್ರಂ ವಿವಾಹಯನ್ ಸರ್ವ್ವಾನ್ ನಿಮನ್ತ್ರಿತಾನ್ ಆನೇತುಂ ದಾಸೇಯಾನ್ ಪ್ರಹಿತವಾನ್, ");
INSERT INTO sankan_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ಕಿನ್ತು ತೇ ಸಮಾಗನ್ತುಂ ನೇಷ್ಟವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ತತೋ ರಾಜಾ ಪುನರಪಿ ದಾಸಾನನ್ಯಾನ್ ಇತ್ಯುಕ್ತ್ವಾ ಪ್ರೇಷಯಾಮಾಸ, ನಿಮನ್ತ್ರಿತಾನ್ ವದತ, ಪಶ್ಯತ, ಮಮ ಭೇಜ್ಯಮಾಸಾದಿತಮಾಸ್ತೇ, ನಿಜವ್ಟಷಾದಿಪುಷ್ಟಜನ್ತೂನ್ ಮಾರಯಿತ್ವಾ ಸರ್ವ್ವಂ ಖಾದ್ಯದ್ರವ್ಯಮಾಸಾದಿತವಾನ್, ಯೂಯಂ ವಿವಾಹಮಾಗಚ್ಛತ| ");
INSERT INTO sankan_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","ತಥಪಿ ತೇ ತುಚ್ಛೀಕೃತ್ಯ ಕೇಚಿತ್ ನಿಜಕ್ಷೇತ್ರಂ ಕೇಚಿದ್ ವಾಣಿಜ್ಯಂ ಪ್ರತಿ ಸ್ವಸ್ವಮಾರ್ಗೇಣ ಚಲಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ಅನ್ಯೇ ಲೋಕಾಸ್ತಸ್ಯ ದಾಸೇಯಾನ್ ಧೃತ್ವಾ ದೌರಾತ್ಮ್ಯಂ ವ್ಯವಹೃತ್ಯ ತಾನವಧಿಷುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","ಅನನ್ತರಂ ಸ ನೃಪತಿಸ್ತಾಂ ವಾರ್ತ್ತಾಂ ಶ್ರುತ್ವಾ ಕ್ರುಧ್ಯನ್ ಸೈನ್ಯಾನಿ ಪ್ರಹಿತ್ಯ ತಾನ್ ಘಾತಕಾನ್ ಹತ್ವಾ ತೇಷಾಂ ನಗರಂ ದಾಹಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","ತತಃ ಸ ನಿಜದಾಸೇಯಾನ್ ಬಭಾಷೇ, ವಿವಾಹೀಯಂ ಭೋಜ್ಯಮಾಸಾದಿತಮಾಸ್ತೇ, ಕಿನ್ತು ನಿಮನ್ತ್ರಿತಾ ಜನಾ ಅಯೋಗ್ಯಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ತಸ್ಮಾದ್ ಯೂಯಂ ರಾಜಮಾರ್ಗಂ ಗತ್ವಾ ಯಾವತೋ ಮನುಜಾನ್ ಪಶ್ಯತ, ತಾವತಏವ ವಿವಾಹೀಯಭೋಜ್ಯಾಯ ನಿಮನ್ತ್ರಯತ| ");
INSERT INTO sankan_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","ತದಾ ತೇ ದಾಸೇಯಾ ರಾಜಮಾರ್ಗಂ ಗತ್ವಾ ಭದ್ರಾನ್ ಅಭದ್ರಾನ್ ವಾ ಯಾವತೋ ಜನಾನ್ ದದೃಶುಃ, ತಾವತಏವ ಸಂಗೃಹ್ಯಾನಯನ್; ತತೋಽಭ್ಯಾಗತಮನುಜೈ ರ್ವಿವಾಹಗೃಹಮ್ ಅಪೂರ್ಯ್ಯತ| ");
INSERT INTO sankan_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","ತದಾನೀಂ ಸ ರಾಜಾ ಸರ್ವ್ವಾನಭ್ಯಾಗತಾನ್ ದ್ರಷ್ಟುಮ್ ಅಭ್ಯನ್ತರಮಾಗತವಾನ್; ತದಾ ತತ್ರ ವಿವಾಹೀಯವಸನಹೀನಮೇಕಂ ಜನಂ ವೀಕ್ಷ್ಯ ತಂ ಜಗಾದ್, ");
INSERT INTO sankan_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ಹೇ ಮಿತ್ರ,ತ್ವಂ ವಿವಾಹೀಯವಸನಂ ವಿನಾ ಕಥಮತ್ರ ಪ್ರವಿಷ್ಟವಾನ್? ತೇನ ಸ ನಿರುತ್ತರೋ ಬಭೂವ| ");
INSERT INTO sankan_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","ತದಾ ರಾಜಾ ನಿಜಾನುಚರಾನ್ ಅವದತ್, ಏತಸ್ಯ ಕರಚರಣಾನ್ ಬದ್ಧಾ ಯತ್ರ ರೋದನಂ ದನ್ತೈರ್ದನ್ತಘರ್ಷಣಞ್ಚ ಭವತಿ, ತತ್ರ ವಹಿರ್ಭೂತತಮಿಸ್ರೇ ತಂ ನಿಕ್ಷಿಪತ| ");
INSERT INTO sankan_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","ಇತ್ಥಂ ಬಹವ ಆಹೂತಾ ಅಲ್ಪೇ ಮನೋಭಿಮತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","ಅನನ್ತರಂ ಫಿರೂಶಿನಃ ಪ್ರಗತ್ಯ ಯಥಾ ಸಂಲಾಪೇನ ತಮ್ ಉನ್ಮಾಥೇ ಪಾತಯೇಯುಸ್ತಥಾ ಮನ್ತ್ರಯಿತ್ವಾ ");
INSERT INTO sankan_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ಹೇರೋದೀಯಮನುಜೈಃ ಸಾಕಂ ನಿಜಶಿಷ್ಯಗಣೇನ ತಂ ಪ್ರತಿ ಕಥಯಾಮಾಸುಃ, ಹೇ ಗುರೋ, ಭವಾನ್ ಸತ್ಯಃ ಸತ್ಯಮೀಶ್ವರೀಯಮಾರ್ಗಮುಪದಿಶತಿ, ಕಮಪಿ ಮಾನುಷಂ ನಾನುರುಧ್ಯತೇ, ಕಮಪಿ ನಾಪೇಕ್ಷತೇ ಚ, ತದ್ ವಯಂ ಜಾನೀಮಃ| ");
INSERT INTO sankan_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","ಅತಃ ಕೈಸರಭೂಪಾಯ ಕರೋಽಸ್ಮಾಕಂ ದಾತವ್ಯೋ ನ ವಾ? ಅತ್ರ ಭವತಾ ಕಿಂ ಬುಧ್ಯತೇ? ತದ್ ಅಸ್ಮಾನ್ ವದತು| ");
INSERT INTO sankan_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ತತೋ ಯೀಶುಸ್ತೇಷಾಂ ಖಲತಾಂ ವಿಜ್ಞಾಯ ಕಥಿತವಾನ್, ರೇ ಕಪಟಿನಃ ಯುಯಂ ಕುತೋ ಮಾಂ ಪರಿಕ್ಷಧ್ವೇ? ");
INSERT INTO sankan_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","ತತ್ಕರದಾನಸ್ಯ ಮುದ್ರಾಂ ಮಾಂ ದರ್ಶಯತ| ತದಾನೀಂ ತೈಸ್ತಸ್ಯ ಸಮೀಪಂ ಮುದ್ರಾಚತುರ್ಥಭಾಗ ಆನೀತೇ ");
INSERT INTO sankan_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ಸ ತಾನ್ ಪಪ್ರಚ್ಛ, ಅತ್ರ ಕಸ್ಯೇಯಂ ಮೂರ್ತ್ತಿ ರ್ನಾಮ ಚಾಸ್ತೇ? ತೇ ಜಗದುಃ, ಕೈಸರಭೂಪಸ್ಯ| ");
INSERT INTO sankan_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ತತಃ ಸ ಉಕ್ತವಾನ, ಕೈಸರಸ್ಯ ಯತ್ ತತ್ ಕೈಸರಾಯ ದತ್ತ, ಈಶ್ವರಸ್ಯ ಯತ್ ತದ್ ಈಶ್ವರಾಯ ದತ್ತ| ");
INSERT INTO sankan_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ಇತಿ ವಾಕ್ಯಂ ನಿಶಮ್ಯ ತೇ ವಿಸ್ಮಯಂ ವಿಜ್ಞಾಯ ತಂ ವಿಹಾಯ ಚಲಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","ತಸ್ಮಿನ್ನಹನಿ ಸಿದೂಕಿನೋಽರ್ಥಾತ್ ಶ್ಮಶಾನಾತ್ ನೋತ್ಥಾಸ್ಯನ್ತೀತಿ ವಾಕ್ಯಂ ಯೇ ವದನ್ತಿ, ತೇ ಯೀಶೇाರನ್ತಿಕಮ್ ಆಗತ್ಯ ಪಪ್ರಚ್ಛುಃ, ");
INSERT INTO sankan_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ಹೇ ಗುರೋ, ಕಶ್ಚಿನ್ಮನುಜಶ್ಚೇತ್ ನಿಃಸನ್ತಾನಃ ಸನ್ ಪ್ರಾಣಾನ್ ತ್ಯಜತಿ, ತರ್ಹಿ ತಸ್ಯ ಭ್ರಾತಾ ತಸ್ಯ ಜಾಯಾಂ ವ್ಯುಹ್ಯ ಭ್ರಾತುಃ ಸನ್ತಾನಮ್ ಉತ್ಪಾದಯಿಷ್ಯತೀತಿ ಮೂಸಾ ಆದಿಷ್ಟವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ಕಿನ್ತ್ವಸ್ಮಾಕಮತ್ರ ಕೇಽಪಿ ಜನಾಃ ಸಪ್ತಸಹೋದರಾ ಆಸನ್, ತೇಷಾಂ ಜ್ಯೇಷ್ಠ ಏಕಾಂ ಕನ್ಯಾಂ ವ್ಯವಹಾತ್, ಅಪರಂ ಪ್ರಾಣತ್ಯಾಗಕಾಲೇ ಸ್ವಯಂ ನಿಃಸನ್ತಾನಃ ಸನ್ ತಾಂ ಸ್ತ್ರಿಯಂ ಸ್ವಭ್ರಾತರಿ ಸಮರ್ಪಿತವಾನ್, ");
INSERT INTO sankan_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ತತೋ ದ್ವಿತೀಯಾದಿಸಪ್ತಮಾನ್ತಾಶ್ಚ ತಥೈವ ಚಕ್ರುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ಶೇಷೇ ಸಾಪೀ ನಾರೀ ಮಮಾರ| ");
INSERT INTO sankan_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","ಮೃತಾನಾಮ್ ಉತ್ಥಾನಸಮಯೇ ತೇಷಾಂ ಸಪ್ತಾನಾಂ ಮಧ್ಯೇ ಸಾ ನಾರೀ ಕಸ್ಯ ಭಾರ್ಯ್ಯಾ ಭವಿಷ್ಯತಿ? ಯಸ್ಮಾತ್ ಸರ್ವ್ವಏವ ತಾಂ ವ್ಯವಹನ್| ");
INSERT INTO sankan_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ತತೋ ಯೀಶುಃ ಪ್ರತ್ಯವಾದೀತ್, ಯೂಯಂ ಧರ್ಮ್ಮಪುಸ್ತಕಮ್ ಈಶ್ವರೀಯಾಂ ಶಕ್ತಿಞ್ಚ ನ ವಿಜ್ಞಾಯ ಭ್ರಾನ್ತಿಮನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","ಉತ್ಥಾನಪ್ರಾಪ್ತಾ ಲೋಕಾ ನ ವಿವಹನ್ತಿ, ನ ಚ ವಾಚಾ ದೀಯನ್ತೇ, ಕಿನ್ತ್ವೀಶ್ವರಸ್ಯ ಸ್ವರ್ಗಸ್ಥದೂತಾನಾಂ ಸದೃಶಾ ಭವನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","ಅಪರಂ ಮೃತಾನಾಮುತ್ಥಾನಮಧಿ ಯುಷ್ಮಾನ್ ಪ್ರತೀಯಮೀಶ್ವರೋಕ್ತಿಃ, ");
INSERT INTO sankan_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","\"ಅಹಮಿಬ್ರಾಹೀಮ ಈಶ್ವರ ಇಸ್ಹಾಕ ಈಶ್ವರೋ ಯಾಕೂಬ ಈಶ್ವರ\" ಇತಿ ಕಿಂ ಯುಷ್ಮಾಭಿ ರ್ನಾಪಾಠಿ? ಕಿನ್ತ್ವೀಶ್ವರೋ ಜೀವತಾಮ್ ಈಶ್ವರ:, ಸ ಮೃತಾನಾಮೀಶ್ವರೋ ನಹಿ| ");
INSERT INTO sankan_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ಇತಿ ಶ್ರುತ್ವಾ ಸರ್ವ್ವೇ ಲೋಕಾಸ್ತಸ್ಯೋಪದೇಶಾದ್ ವಿಸ್ಮಯಂ ಗತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","ಅನನ್ತರಂ ಸಿದೂಕಿನಾಮ್ ನಿರುತ್ತರತ್ವವಾರ್ತಾಂ ನಿಶಮ್ಯ ಫಿರೂಶಿನ ಏಕತ್ರ ಮಿಲಿತವನ್ತಃ, ");
INSERT INTO sankan_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ತೇಷಾಮೇಕೋ ವ್ಯವಸ್ಥಾಪಕೋ ಯೀಶುಂ ಪರೀಕ್ಷಿತುಂ ಪಪಚ್ಛ, ");
INSERT INTO sankan_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","ಹೇ ಗುರೋ ವ್ಯವಸ್ಥಾಶಾಸ್ತ್ರಮಧ್ಯೇ ಕಾಜ್ಞಾ ಶ್ರೇಷ್ಠಾ? ");
INSERT INTO sankan_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ತತೋ ಯೀಶುರುವಾಚ, ತ್ವಂ ಸರ್ವ್ವಾನ್ತಃಕರಣೈಃ ಸರ್ವ್ವಪ್ರಾಣೈಃ ಸರ್ವ್ವಚಿತ್ತೈಶ್ಚ ಸಾಕಂ ಪ್ರಭೌ ಪರಮೇಶ್ವರೇ ಪ್ರೀಯಸ್ವ, ");
INSERT INTO sankan_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ಏಷಾ ಪ್ರಥಮಮಹಾಜ್ಞಾ| ತಸ್ಯಾಃ ಸದೃಶೀ ದ್ವಿತೀಯಾಜ್ಞೈಷಾ, ");
INSERT INTO sankan_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ತವ ಸಮೀಪವಾಸಿನಿ ಸ್ವಾತ್ಮನೀವ ಪ್ರೇಮ ಕುರು| ");
INSERT INTO sankan_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","ಅನಯೋ ರ್ದ್ವಯೋರಾಜ್ಞಯೋಃ ಕೃತ್ಸ್ನವ್ಯವಸ್ಥಾಯಾ ಭವಿಷ್ಯದ್ವಕ್ತೃಗ್ರನ್ಥಸ್ಯ ಚ ಭಾರಸ್ತಿಷ್ಠತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ಅನನ್ತರಂ ಫಿರೂಶಿನಾಮ್ ಏಕತ್ರ ಸ್ಥಿತಿಕಾಲೇ ಯೀಶುಸ್ತಾನ್ ಪಪ್ರಚ್ಛ, ");
INSERT INTO sankan_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","ಖ್ರೀಷ್ಟಮಧಿ ಯುಷ್ಮಾಕಂ ಕೀದೃಗ್ಬೋಧೋ ಜಾಯತೇ? ಸ ಕಸ್ಯ ಸನ್ತಾನಃ? ತತಸ್ತೇ ಪ್ರತ್ಯವದನ್, ದಾಯೂದಃ ಸನ್ತಾನಃ| ");
INSERT INTO sankan_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","ತದಾ ಸ ಉಕ್ತವಾನ್, ತರ್ಹಿ ದಾಯೂದ್ ಕಥಮ್ ಆತ್ಮಾಧಿಷ್ಠಾನೇನ ತಂ ಪ್ರಭುಂ ವದತಿ ? ");
INSERT INTO sankan_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","ಯಥಾ ಮಮ ಪ್ರಭುಮಿದಂ ವಾಕ್ಯಮವದತ್ ಪರಮೇಶ್ವರಃ| ತವಾರೀನ್ ಪಾದಪೀಠಂ ತೇ ಯಾವನ್ನಹಿ ಕರೋಮ್ಯಹಂ| ತಾವತ್ ಕಾಲಂ ಮದೀಯೇ ತ್ವಂ ದಕ್ಷಪಾರ್ಶ್ವ ಉಪಾವಿಶ| ಅತೋ ಯದಿ ದಾಯೂದ್ ತಂ ಪ್ರಭುಂ ವದತಿ, ರ್ತಿಹ ಸ ಕಥಂ ತಸ್ಯ ಸನ್ತಾನೋ ಭವತಿ? ");
INSERT INTO sankan_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","ತದಾನೀಂ ತೇಷಾಂ ಕೋಪಿ ತದ್ವಾಕ್ಯಸ್ಯ ಕಿಮಪ್ಯುತ್ತರಂ ದಾತುಂ ನಾಶಕ್ನೋತ್; ");
INSERT INTO sankan_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ತದ್ದಿನಮಾರಭ್ಯ ತಂ ಕಿಮಪಿ ವಾಕ್ಯಂ ಪ್ರಷ್ಟುಂ ಕಸ್ಯಾಪಿ ಸಾಹಸೋ ನಾಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","ಅನನ್ತರಂ ಯೀಶು ರ್ಜನನಿವಹಂ ಶಿಷ್ಯಾಂಶ್ಚಾವದತ್, ");
INSERT INTO sankan_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","ಅಧ್ಯಾಪಕಾಃ ಫಿರೂಶಿನಶ್ಚ ಮೂಸಾಸನೇ ಉಪವಿಶನ್ತಿ, ");
INSERT INTO sankan_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ಅತಸ್ತೇ ಯುಷ್ಮಾನ್ ಯದ್ಯತ್ ಮನ್ತುಮ್ ಆಜ್ಞಾಪಯನ್ತಿ, ತತ್ ಮನ್ಯಧ್ವಂ ಪಾಲಯಧ್ವಞ್ಚ, ಕಿನ್ತು ತೇಷಾಂ ಕರ್ಮ್ಮಾನುರೂಪಂ ಕರ್ಮ್ಮ ನ ಕುರುಧ್ವಂ; ಯತಸ್ತೇಷಾಂ ವಾಕ್ಯಮಾತ್ರಂ ಸಾರಂ ಕಾರ್ಯ್ಯೇ ಕಿಮಪಿ ನಾಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","ತೇ ದುರ್ವ್ವಹಾನ್ ಗುರುತರಾನ್ ಭಾರಾನ್ ಬದ್ವ್ವಾ ಮನುಷ್ಯಾಣಾಂ ಸ್ಕನ್ಧೇಪರಿ ಸಮರ್ಪಯನ್ತಿ, ಕಿನ್ತು ಸ್ವಯಮಙ್ಗುಲ್ಯೈಕಯಾಪಿ ನ ಚಾಲಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","ಕೇವಲಂ ಲೋಕದರ್ಶನಾಯ ಸರ್ವ್ವಕರ್ಮ್ಮಾಣಿ ಕುರ್ವ್ವನ್ತಿ; ಫಲತಃ ಪಟ್ಟಬನ್ಧಾನ್ ಪ್ರಸಾರ್ಯ್ಯ ಧಾರಯನ್ತಿ, ಸ್ವವಸ್ತ್ರೇಷು ಚ ದೀರ್ಘಗ್ರನ್ಥೀನ್ ಧಾರಯನ್ತಿ; ");
INSERT INTO sankan_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ಭೋಜನಭವನ ಉಚ್ಚಸ್ಥಾನಂ, ಭಜನಭವನೇ ಪ್ರಧಾನಮಾಸನಂ, ");
INSERT INTO sankan_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ಹಟ್ಠೇ ನಮಸ್ಕಾರಂ ಗುರುರಿತಿ ಸಮ್ಬೋಧನಞ್ಚೈತಾನಿ ಸರ್ವ್ವಾಣಿ ವಾಞ್ಛನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","ಕಿನ್ತು ಯೂಯಂ ಗುರವ ಇತಿ ಸಮ್ಬೋಧನೀಯಾ ಮಾ ಭವತ, ಯತೋ ಯುಷ್ಮಾಕಮ್ ಏಕಃ ಖ್ರೀಷ್ಟಏವ ಗುರು ");
INSERT INTO sankan_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ರ್ಯೂಯಂ ಸರ್ವ್ವೇ ಮಿಥೋ ಭ್ರಾತರಶ್ಚ| ಪುನಃ ಪೃಥಿವ್ಯಾಂ ಕಮಪಿ ಪಿತೇತಿ ಮಾ ಸಮ್ಬುಧ್ಯಧ್ವಂ, ಯತೋ ಯುಷ್ಮಾಕಮೇಕಃ ಸ್ವರ್ಗಸ್ಥಏವ ಪಿತಾ| ");
INSERT INTO sankan_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ಯೂಯಂ ನಾಯಕೇತಿ ಸಮ್ಭಾಷಿತಾ ಮಾ ಭವತ, ಯತೋ ಯುಷ್ಮಾಕಮೇಕಃ ಖ್ರೀಷ್ಟಏವ ನಾಯಕಃ| ");
INSERT INTO sankan_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","ಅಪರಂ ಯುಷ್ಮಾಕಂ ಮಧ್ಯೇ ಯಃ ಪುಮಾನ್ ಶ್ರೇಷ್ಠಃ ಸ ಯುಷ್ಮಾನ್ ಸೇವಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ಯತೋ ಯಃ ಸ್ವಮುನ್ನಮತಿ, ಸ ನತಃ ಕರಿಷ್ಯತೇ; ಕಿನ್ತು ಯಃ ಕಶ್ಚಿತ್ ಸ್ವಮವನತಂ ಕರೋತಿ, ಸ ಉನ್ನತಃ ಕರಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","ಹನ್ತ ಕಪಟಿನ ಉಪಾಧ್ಯಾಯಾಃ ಫಿರೂಶಿನಶ್ಚ, ಯೂಯಂ ಮನುಜಾನಾಂ ಸಮಕ್ಷಂ ಸ್ವರ್ಗದ್ವಾರಂ ರುನ್ಧ, ಯೂಯಂ ಸ್ವಯಂ ತೇನ ನ ಪ್ರವಿಶಥ, ಪ್ರವಿವಿಕ್ಷೂನಪಿ ವಾರಯಥ| ವತ ಕಪಟಿನ ಉಪಾಧ್ಯಾಯಾಃ ಫಿರೂಶಿನಶ್ಚ ಯೂಯಂ ಛಲಾದ್ ದೀರ್ಘಂ ಪ್ರಾರ್ಥ್ಯ ವಿಧವಾನಾಂ ಸರ್ವ್ವಸ್ವಂ ಗ್ರಸಥ, ಯುಷ್ಮಾಕಂ ಘೋರತರದಣ್ಡೋ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","ಹನ್ತ ಕಪಟಿನ ಉಪಾಧ್ಯಾಯಾಃ ಫಿರೂಶಿನಶ್ಚ, ಯೂಯಮೇಕಂ ಸ್ವಧರ್ಮ್ಮಾವಲಮ್ಬಿನಂ ಕರ್ತ್ತುಂ ಸಾಗರಂ ಭೂಮಣ್ಡಲಞ್ಚ ಪ್ರದಕ್ಷಿಣೀಕುರುಥ, ");
INSERT INTO sankan_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","ಕಞ್ಚನ ಪ್ರಾಪ್ಯ ಸ್ವತೋ ದ್ವಿಗುಣನರಕಭಾಜನಂ ತಂ ಕುರುಥ| ");
INSERT INTO sankan_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","ವತ ಅನ್ಧಪಥದರ್ಶಕಾಃ ಸರ್ವ್ವೇ, ಯೂಯಂ ವದಥ, ಮನ್ದಿರಸ್ಯ ಶಪಥಕರಣಾತ್ ಕಿಮಪಿ ನ ದೇಯಂ; ಕಿನ್ತು ಮನ್ದಿರಸ್ಥಸುವರ್ಣಸ್ಯ ಶಪಥಕರಣಾದ್ ದೇಯಂ| ");
INSERT INTO sankan_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ಹೇ ಮೂಢಾ ಹೇ ಅನ್ಧಾಃ ಸುವರ್ಣಂ ತತ್ಸುವರ್ಣಪಾವಕಮನ್ದಿರಮ್ ಏತಯೋರುಭಯೋ ರ್ಮಧ್ಯೇ ಕಿಂ ಶ್ರೇಯಃ? ");
INSERT INTO sankan_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","ಅನ್ಯಚ್ಚ ವದಥ, ಯಜ್ಞವೇದ್ಯಾಃ ಶಪಥಕರಣಾತ್ ಕಿಮಪಿ ನ ದೇಯಂ, ಕಿನ್ತು ತದುಪರಿಸ್ಥಿತಸ್ಯ ನೈವೇದ್ಯಸ್ಯ ಶಪಥಕರಣಾದ್ ದೇಯಂ| ");
INSERT INTO sankan_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ಹೇ ಮೂಢಾ ಹೇ ಅನ್ಧಾಃ, ನೈವೇದ್ಯಂ ತನ್ನೈವೇದ್ಯಪಾವಕವೇದಿರೇತಯೋರುಭಯೋ ರ್ಮಧ್ಯೇ ಕಿಂ ಶ್ರೇಯಃ? ");
INSERT INTO sankan_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ಅತಃ ಕೇನಚಿದ್ ಯಜ್ಞವೇದ್ಯಾಃ ಶಪಥೇ ಕೃತೇ ತದುಪರಿಸ್ಥಸ್ಯ ಸರ್ವ್ವಸ್ಯ ಶಪಥಃ ಕ್ರಿಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ಕೇನಚಿತ್ ಮನ್ದಿರಸ್ಯ ಶಪಥೇ ಕೃತೇ ಮನ್ದಿರತನ್ನಿವಾಸಿನೋಃ ಶಪಥಃ ಕ್ರಿಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ಕೇನಚಿತ್ ಸ್ವರ್ಗಸ್ಯ ಶಪಥೇ ಕೃತೇ ಈಶ್ವರೀಯಸಿಂಹಾಸನತದುಪರ್ಯ್ಯುಪವಿಷ್ಟಯೋಃ ಶಪಥಃ ಕ್ರಿಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","ಹನ್ತ ಕಪಟಿನ ಉಪಾಧ್ಯಾಯಾಃ ಫಿರೂಶಿನಶ್ಚ, ಯೂಯಂ ಪೋದಿನಾಯಾಃ ಸಿತಚ್ಛತ್ರಾಯಾ ಜೀರಕಸ್ಯ ಚ ದಶಮಾಂಶಾನ್ ದತ್ಥ, ಕಿನ್ತು ವ್ಯವಸ್ಥಾಯಾ ಗುರುತರಾನ್ ನ್ಯಾಯದಯಾವಿಶ್ವಾಸಾನ್ ಪರಿತ್ಯಜಥ; ಇಮೇ ಯುಷ್ಮಾಭಿರಾಚರಣೀಯಾ ಅಮೀ ಚ ನ ಲಂಘನೀಯಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ಹೇ ಅನ್ಧಪಥದರ್ಶಕಾ ಯೂಯಂ ಮಶಕಾನ್ ಅಪಸಾರಯಥ, ಕಿನ್ತು ಮಹಾಙ್ಗಾನ್ ಗ್ರಸಥ| ");
INSERT INTO sankan_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","ಹನ್ತ ಕಪಟಿನ ಉಪಾಧ್ಯಾಯಾಃ ಫಿರೂಶಿನಶ್ಚ, ಯೂಯಂ ಪಾನಪಾತ್ರಾಣಾಂ ಭೋಜನಪಾತ್ರಾಣಾಞ್ಚ ಬಹಿಃ ಪರಿಷ್ಕುರುಥ; ಕಿನ್ತು ತದಭ್ಯನ್ತರಂ ದುರಾತ್ಮತಯಾ ಕಲುಷೇಣ ಚ ಪರಿಪೂರ್ಣಮಾಸ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ಹೇ ಅನ್ಧಾಃ ಫಿರೂಶಿಲೋಕಾ ಆದೌ ಪಾನಪಾತ್ರಾಣಾಂ ಭೋಜನಪಾತ್ರಾಣಾಞ್ಚಾಭ್ಯನ್ತರಂ ಪರಿಷ್ಕುರುತ, ತೇನ ತೇಷಾಂ ಬಹಿರಪಿ ಪರಿಷ್ಕಾರಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","ಹನ್ತ ಕಪಟಿನ ಉಪಾಧ್ಯಾಯಾಃ ಫಿರೂಶಿನಶ್ಚ, ಯೂಯಂ ಶುಕ್ಲೀಕೃತಶ್ಮಶಾನಸ್ವರೂಪಾ ಭವಥ, ಯಥಾ ಶ್ಮಶಾನಭವನಸ್ಯ ಬಹಿಶ್ಚಾರು, ಕಿನ್ತ್ವಭ್ಯನ್ತರಂ ಮೃತಲೋಕಾನಾಂ ಕೀಕಶೈಃ ಸರ್ವ್ವಪ್ರಕಾರಮಲೇನ ಚ ಪರಿಪೂರ್ಣಮ್; ");
INSERT INTO sankan_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","ತಥೈವ ಯೂಯಮಪಿ ಲೋಕಾನಾಂ ಸಮಕ್ಷಂ ಬಹಿರ್ಧಾರ್ಮ್ಮಿಕಾಃ ಕಿನ್ತ್ವನ್ತಃಕರಣೇಷು ಕೇವಲಕಾಪಟ್ಯಾಧರ್ಮ್ಮಾಭ್ಯಾಂ ಪರಿಪೂರ್ಣಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","ಹಾ ಹಾ ಕಪಟಿನ ಉಪಾಧ್ಯಾಯಾಃ ಫಿರೂಶಿನಶ್ಚ, ಯೂಯಂ ಭವಿಷ್ಯದ್ವಾದಿನಾಂ ಶ್ಮಶಾನಗೇಹಂ ನಿರ್ಮ್ಮಾಥ, ಸಾಧೂನಾಂ ಶ್ಮಶಾನನಿಕೇತನಂ ಶೋಭಯಥ ");
INSERT INTO sankan_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ವದಥ ಚ ಯದಿ ವಯಂ ಸ್ವೇಷಾಂ ಪೂರ್ವ್ವಪುರುಷಾಣಾಂ ಕಾಲ ಅಸ್ಥಾಸ್ಯಾಮ, ತರ್ಹಿ ಭವಿಷ್ಯದ್ವಾದಿನಾಂ ಶೋಣಿತಪಾತನೇ ತೇಷಾಂ ಸಹಭಾಗಿನೋ ನಾಭವಿಷ್ಯಾಮ| ");
INSERT INTO sankan_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ಅತೋ ಯೂಯಂ ಭವಿಷ್ಯದ್ವಾದಿಘಾತಕಾನಾಂ ಸನ್ತಾನಾ ಇತಿ ಸ್ವಯಮೇವ ಸ್ವೇಷಾಂ ಸಾಕ್ಷ್ಯಂ ದತ್ಥ| ");
INSERT INTO sankan_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","ಅತೋ ಯೂಯಂ ನಿಜಪೂರ್ವ್ವಪುರುಷಾಣಾಂ ಪರಿಮಾಣಪಾತ್ರಂ ಪರಿಪೂರಯತ| ");
INSERT INTO sankan_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","ರೇ ಭುಜಗಾಃ ಕೃಷ್ಣಭುಜಗವಂಶಾಃ, ಯೂಯಂ ಕಥಂ ನರಕದಣ್ಡಾದ್ ರಕ್ಷಿಷ್ಯಧ್ವೇ| ");
INSERT INTO sankan_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","ಪಶ್ಯತ, ಯುಷ್ಮಾಕಮನ್ತಿಕಮ್ ಅಹಂ ಭವಿಷ್ಯದ್ವಾದಿನೋ ಬುದ್ಧಿಮತ ಉಪಾಧ್ಯಾಯಾಂಶ್ಚ ಪ್ರೇಷಯಿಷ್ಯಾಮಿ, ಕಿನ್ತು ತೇಷಾಂ ಕತಿಪಯಾ ಯುಷ್ಮಾಭಿ ರ್ಘಾನಿಷ್ಯನ್ತೇ, ಕ್ರುಶೇ ಚ ಘಾನಿಷ್ಯನ್ತೇ, ಕೇಚಿದ್ ಭಜನಭವನೇ ಕಷಾಭಿರಾಘಾನಿಷ್ಯನ್ತೇ, ನಗರೇ ನಗರೇ ತಾಡಿಷ್ಯನ್ತೇ ಚ; ");
INSERT INTO sankan_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","ತೇನ ಸತ್ಪುರುಷಸ್ಯ ಹಾಬಿಲೋ ರಕ್ತಪಾತಮಾರಭ್ಯ ಬೇರಿಖಿಯಃ ಪುತ್ರಂ ಯಂ ಸಿಖರಿಯಂ ಯೂಯಂ ಮನ್ದಿರಯಜ್ಞವೇದ್ಯೋ ರ್ಮಧ್ಯೇ ಹತವನ್ತಃ, ತದೀಯಶೋಣಿತಪಾತಂ ಯಾವದ್ ಅಸ್ಮಿನ್ ದೇಶೇ ಯಾವತಾಂ ಸಾಧುಪುರುಷಾಣಾಂ ಶೋಣಿತಪಾತೋ ಽಭವತ್ ತತ್ ಸರ್ವ್ವೇಷಾಮಾಗಸಾಂ ದಣ್ಡಾ ಯುಷ್ಮಾಸು ವರ್ತ್ತಿಷ್ಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ಅಹಂ ಯುಷ್ಮಾನ್ತ ತಥ್ಯಂ ವದಾಮಿ, ವಿದ್ಯಮಾನೇಽಸ್ಮಿನ್ ಪುರುಷೇ ಸರ್ವ್ವೇ ವರ್ತ್ತಿಷ್ಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","ಹೇ ಯಿರೂಶಾಲಮ್ ಹೇ ಯಿರೂಶಾಲಮ್ ನಗರಿ ತ್ವಂ ಭವಿಷ್ಯದ್ವಾದಿನೋ ಹತವತೀ, ತವ ಸಮೀಪಂ ಪ್ರೇರಿತಾಂಶ್ಚ ಪಾಷಾಣೈರಾಹತವತೀ, ಯಥಾ ಕುಕ್ಕುಟೀ ಶಾವಕಾನ್ ಪಕ್ಷಾಧಃ ಸಂಗೃಹ್ಲಾತಿ, ತಥಾ ತವ ಸನ್ತಾನಾನ್ ಸಂಗ್ರಹೀತುಂ ಅಹಂ ಬಹುವಾರಮ್ ಐಚ್ಛಂ; ಕಿನ್ತು ತ್ವಂ ನ ಸಮಮನ್ಯಥಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ಪಶ್ಯತ ಯಷ್ಮಾಕಂ ವಾಸಸ್ಥಾನಮ್ ಉಚ್ಛಿನ್ನಂ ತ್ಯಕ್ಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ಅಹಂ ಯುಷ್ಮಾನ್ ತಥ್ಯಂ ವದಾಮಿ, ಯಃ ಪರಮೇಶ್ವರಸ್ಯ ನಾಮ್ನಾಗಚ್ಛತಿ, ಸ ಧನ್ಯ ಇತಿ ವಾಣೀಂ ಯಾವನ್ನ ವದಿಷ್ಯಥ, ತಾವತ್ ಮಾಂ ಪುನ ರ್ನ ದ್ರಕ್ಷ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","ಅನನ್ತರಂ ಯೀಶು ರ್ಯದಾ ಮನ್ದಿರಾದ್ ಬಹಿ ರ್ಗಚ್ಛತಿ, ತದಾನೀಂ ಶಿಷ್ಯಾಸ್ತಂ ಮನ್ದಿರನಿರ್ಮ್ಮಾಣಂ ದರ್ಶಯಿತುಮಾಗತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ತತೋ ಯೀಶುಸ್ತಾನುವಾಚ, ಯೂಯಂ ಕಿಮೇತಾನಿ ನ ಪಶ್ಯಥ? ಯುಷ್ಮಾನಹಂ ಸತ್ಯಂ ವದಾಮಿ, ಏತನ್ನಿಚಯನಸ್ಯ ಪಾಷಾಣೈಕಮಪ್ಯನ್ಯಪಾಷಾಣೇाಪರಿ ನ ಸ್ಥಾಸ್ಯತಿ ಸರ್ವ್ವಾಣಿ ಭೂಮಿಸಾತ್ ಕಾರಿಷ್ಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","ಅನನ್ತರಂ ತಸ್ಮಿನ್ ಜೈತುನಪರ್ವ್ವತೋಪರಿ ಸಮುಪವಿಷ್ಟೇ ಶಿಷ್ಯಾಸ್ತಸ್ಯ ಸಮೀಪಮಾಗತ್ಯ ಗುಪ್ತಂ ಪಪ್ರಚ್ಛುಃ, ಏತಾ ಘಟನಾಃ ಕದಾ ಭವಿಷ್ಯನ್ತಿ? ಭವತ ಆಗಮನಸ್ಯ ಯುಗಾನ್ತಸ್ಯ ಚ ಕಿಂ ಲಕ್ಷ್ಮ? ತದಸ್ಮಾನ್ ವದತು| ");
INSERT INTO sankan_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ತದಾನೀಂ ಯೀಶುಸ್ತಾನವೋಚತ್, ಅವಧದ್ವ್ವಂ, ಕೋಪಿ ಯುಷ್ಮಾನ್ ನ ಭ್ರಮಯೇತ್| ");
INSERT INTO sankan_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ಬಹವೋ ಮಮ ನಾಮ ಗೃಹ್ಲನ್ತ ಆಗಮಿಷ್ಯನ್ತಿ, ಖ್ರೀಷ್ಟೋಽಹಮೇವೇತಿ ವಾಚಂ ವದನ್ತೋ ಬಹೂನ್ ಭ್ರಮಯಿಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","ಯೂಯಞ್ಚ ಸಂಗ್ರಾಮಸ್ಯ ರಣಸ್ಯ ಚಾಡಮ್ಬರಂ ಶ್ರೋಷ್ಯಥ, ಅವಧದ್ವ್ವಂ ತೇನ ಚಞ್ಚಲಾ ಮಾ ಭವತ, ಏತಾನ್ಯವಶ್ಯಂ ಘಟಿಷ್ಯನ್ತೇ, ಕಿನ್ತು ತದಾ ಯುಗಾನ್ತೋ ನಹಿ| ");
INSERT INTO sankan_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","ಅಪರಂ ದೇಶಸ್ಯ ವಿಪಕ್ಷೋ ದೇಶೋ ರಾಜ್ಯಸ್ಯ ವಿಪಕ್ಷೋ ರಾಜ್ಯಂ ಭವಿಷ್ಯತಿ, ಸ್ಥಾನೇ ಸ್ಥಾನೇ ಚ ದುರ್ಭಿಕ್ಷಂ ಮಹಾಮಾರೀ ಭೂಕಮ್ಪಶ್ಚ ಭವಿಷ್ಯನ್ತಿ, ");
INSERT INTO sankan_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ಏತಾನಿ ದುಃಖೋಪಕ್ರಮಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","ತದಾನೀಂ ಲೋಕಾ ದುಃಖಂ ಭೋಜಯಿತುಂ ಯುಷ್ಮಾನ್ ಪರಕರೇಷು ಸಮರ್ಪಯಿಷ್ಯನ್ತಿ ಹನಿಷ್ಯನ್ತಿ ಚ, ತಥಾ ಮಮ ನಾಮಕಾರಣಾದ್ ಯೂಯಂ ಸರ್ವ್ವದೇಶೀಯಮನುಜಾನಾಂ ಸಮೀಪೇ ಘೃಣಾರ್ಹಾ ಭವಿಷ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","ಬಹುಷು ವಿಘ್ನಂ ಪ್ರಾಪ್ತವತ್ಸು ಪರಸ್ಪರಮ್ ಋृತೀಯಾಂ ಕೃತವತ್ಸು ಚ ಏಕೋಽಪರಂ ಪರಕರೇಷು ಸಮರ್ಪಯಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ತಥಾ ಬಹವೋ ಮೃಷಾಭವಿಷ್ಯದ್ವಾದಿನ ಉಪಸ್ಥಾಯ ಬಹೂನ್ ಭ್ರಮಯಿಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","ದುಷ್ಕರ್ಮ್ಮಣಾಂ ಬಾಹುಲ್ಯಾಞ್ಚ ಬಹೂನಾಂ ಪ್ರೇಮ ಶೀತಲಂ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","ಕಿನ್ತು ಯಃ ಕಶ್ಚಿತ್ ಶೇಷಂ ಯಾವದ್ ಧೈರ್ಯ್ಯಮಾಶ್ರಯತೇ, ಸಏವ ಪರಿತ್ರಾಯಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","ಅಪರಂ ಸರ್ವ್ವದೇಶೀಯಲೋಕಾನ್ ಪ್ರತಿಮಾಕ್ಷೀ ಭವಿತುಂ ರಾಜಸ್ಯ ಶುಭಸಮಾಚಾರಃ ಸರ್ವ್ವಜಗತಿ ಪ್ರಚಾರಿಷ್ಯತೇ, ಏತಾದೃಶಿ ಸತಿ ಯುಗಾನ್ತ ಉಪಸ್ಥಾಸ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","ಅತೋ ಯತ್ ಸರ್ವ್ವನಾಶಕೃದ್ಘೃಣಾರ್ಹಂ ವಸ್ತು ದಾನಿಯೇಲ್ಭವಿಷ್ಯದ್ವದಿನಾ ಪ್ರೋಕ್ತಂ ತದ್ ಯದಾ ಪುಣ್ಯಸ್ಥಾನೇ ಸ್ಥಾಪಿತಂ ದ್ರಕ್ಷ್ಯಥ, (ಯಃ ಪಠತಿ, ಸ ಬುಧ್ಯತಾಂ) ");
INSERT INTO sankan_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ತದಾನೀಂ ಯೇ ಯಿಹೂದೀಯದೇಶೇ ತಿಷ್ಠನ್ತಿ, ತೇ ಪರ್ವ್ವತೇಷು ಪಲಾಯನ್ತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ಯಃ ಕಶ್ಚಿದ್ ಗೃಹಪೃಷ್ಠೇ ತಿಷ್ಠತಿ, ಸ ಗೃಹಾತ್ ಕಿಮಪಿ ವಸ್ತ್ವಾನೇತುಮ್ ಅಧೇा ನಾವರೋಹೇತ್| ");
INSERT INTO sankan_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ಯಶ್ಚ ಕ್ಷೇತ್ರೇ ತಿಷ್ಠತಿ, ಸೋಪಿ ವಸ್ತ್ರಮಾನೇತುಂ ಪರಾವೃತ್ಯ ನ ಯಾಯಾತ್| ");
INSERT INTO sankan_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","ತದಾನೀಂ ಗರ್ಭಿಣೀಸ್ತನ್ಯಪಾಯಯಿತ್ರೀಣಾಂ ದುರ್ಗತಿ ರ್ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ಅತೋ ಯಷ್ಮಾಕಂ ಪಲಾಯನಂ ಶೀತಕಾಲೇ ವಿಶ್ರಾಮವಾರೇ ವಾ ಯನ್ನ ಭವೇತ್, ತದರ್ಥಂ ಪ್ರಾರ್ಥಯಧ್ವಮ್| ");
INSERT INTO sankan_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ಆ ಜಗದಾರಮ್ಭಾದ್ ಏತತ್ಕಾಲಪರ್ಯ್ಯನನ್ತಂ ಯಾದೃಶಃ ಕದಾಪಿ ನಾಭವತ್ ನ ಚ ಭವಿಷ್ಯತಿ ತಾದೃಶೋ ಮಹಾಕ್ಲೇಶಸ್ತದಾನೀಮ್ ಉಪಸ್ಥಾಸ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","ತಸ್ಯ ಕ್ಲೇಶಸ್ಯ ಸಮಯೋ ಯದಿ ಹ್ಸ್ವೋ ನ ಕ್ರಿಯೇತ, ತರ್ಹಿ ಕಸ್ಯಾಪಿ ಪ್ರಾಣಿನೋ ರಕ್ಷಣಂ ಭವಿತುಂ ನ ಶಕ್ನುಯಾತ್, ಕಿನ್ತು ಮನೋನೀತಮನುಜಾನಾಂ ಕೃತೇ ಸ ಕಾಲೋ ಹ್ಸ್ವೀಕರಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","ಅಪರಞ್ಚ ಪಶ್ಯತ, ಖ್ರೀಷ್ಟೋಽತ್ರ ವಿದ್ಯತೇ, ವಾ ತತ್ರ ವಿದ್ಯತೇ, ತದಾನೀಂ ಯದೀ ಕಶ್ಚಿದ್ ಯುಷ್ಮಾನ ಇತಿ ವಾಕ್ಯಂ ವದತಿ, ತಥಾಪಿ ತತ್ ನ ಪ್ರತೀತ್| ");
INSERT INTO sankan_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","ಯತೋ ಭಾಕ್ತಖ್ರೀಷ್ಟಾ ಭಾಕ್ತಭವಿಷ್ಯದ್ವಾದಿನಶ್ಚ ಉಪಸ್ಥಾಯ ಯಾನಿ ಮಹನ್ತಿ ಲಕ್ಷ್ಮಾಣಿ ಚಿತ್ರಕರ್ಮ್ಮಾಣಿ ಚ ಪ್ರಕಾಶಯಿಷ್ಯನ್ತಿ, ತೈ ರ್ಯದಿ ಸಮ್ಭವೇತ್ ತರ್ಹಿ ಮನೋನೀತಮಾನವಾ ಅಪಿ ಭ್ರಾಮಿಷ್ಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","ಪಶ್ಯತ, ಘಟನಾತಃ ಪೂರ್ವ್ವಂ ಯುಷ್ಮಾನ್ ವಾರ್ತ್ತಾಮ್ ಅವಾದಿಷಮ್| ");
INSERT INTO sankan_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","ಅತಃ ಪಶ್ಯತ, ಸ ಪ್ರಾನ್ತರೇ ವಿದ್ಯತ ಇತಿ ವಾಕ್ಯೇ ಕೇನಚಿತ್ ಕಥಿತೇಪಿ ಬಹಿ ರ್ಮಾ ಗಚ್ಛತ, ವಾ ಪಶ್ಯತ, ಸೋನ್ತಃಪುರೇ ವಿದ್ಯತೇ, ಏತದ್ವಾಕ್ಯ ಉಕ್ತೇಪಿ ಮಾ ಪ್ರತೀತ| ");
INSERT INTO sankan_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","ಯತೋ ಯಥಾ ವಿದ್ಯುತ್ ಪೂರ್ವ್ವದಿಶೋ ನಿರ್ಗತ್ಯ ಪಶ್ಚಿಮದಿಶಂ ಯಾವತ್ ಪ್ರಕಾಶತೇ, ತಥಾ ಮಾನುಷಪುತ್ರಸ್ಯಾಪ್ಯಾಗಮನಂ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","ಯತ್ರ ಶವಸ್ತಿಷ್ಠತಿ, ತತ್ರೇವ ಗೃಧ್ರಾ ಮಿಲನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","ಅಪರಂ ತಸ್ಯ ಕ್ಲೇಶಸಮಯಸ್ಯಾವ್ಯವಹಿತಪರತ್ರ ಸೂರ್ಯ್ಯಸ್ಯ ತೇಜೋ ಲೋಪ್ಸ್ಯತೇ, ಚನ್ದ್ರಮಾ ಜ್ಯೋಸ್ನಾಂ ನ ಕರಿಷ್ಯತಿ, ನಭಸೋ ನಕ್ಷತ್ರಾಣಿ ಪತಿಷ್ಯನ್ತಿ, ಗಗಣೀಯಾ ಗ್ರಹಾಶ್ಚ ವಿಚಲಿಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","ತದಾನೀಮ್ ಆಕಾಶಮಧ್ಯೇ ಮನುಜಸುತಸ್ಯ ಲಕ್ಷ್ಮ ದರ್ಶಿಷ್ಯತೇ, ತತೋ ನಿಜಪರಾಕ್ರಮೇಣ ಮಹಾತೇಜಸಾ ಚ ಮೇಘಾರೂಢಂ ಮನುಜಸುತಂ ನಭಸಾಗಚ್ಛನ್ತಂ ವಿಲೋಕ್ಯ ಪೃಥಿವ್ಯಾಃ ಸರ್ವ್ವವಂಶೀಯಾ ವಿಲಪಿಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ತದಾನೀಂ ಸ ಮಹಾಶಬ್ದಾಯಮಾನತೂರ್ಯ್ಯಾ ವಾದಕಾನ್ ನಿಜದೂತಾನ್ ಪ್ರಹೇಷ್ಯತಿ, ತೇ ವ್ಯೋಮ್ನ ಏಕಸೀಮಾತೋಽಪರಸೀಮಾಂ ಯಾವತ್ ಚತುರ್ದಿಶಸ್ತಸ್ಯ ಮನೋನೀತಜನಾನ್ ಆನೀಯ ಮೇಲಯಿಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","ಉಡುಮ್ಬರಪಾದಪಸ್ಯ ದೃಷ್ಟಾನ್ತಂ ಶಿಕ್ಷಧ್ವಂ; ಯದಾ ತಸ್ಯ ನವೀನಾಃ ಶಾಖಾ ಜಾಯನ್ತೇ, ಪಲ್ಲವಾದಿಶ್ಚ ನಿರ್ಗಚ್ಛತಿ, ತದಾ ನಿದಾಘಕಾಲಃ ಸವಿಧೋ ಭವತೀತಿ ಯೂಯಂ ಜಾನೀಥ; ");
INSERT INTO sankan_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ತದ್ವದ್ ಏತಾ ಘಟನಾ ದೃಷ್ಟ್ವಾ ಸ ಸಮಯೋ ದ್ವಾರ ಉಪಾಸ್ಥಾದ್ ಇತಿ ಜಾನೀತ| ");
INSERT INTO sankan_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","ಯುಷ್ಮಾನಹಂ ತಥ್ಯಂ ವದಾಮಿ, ಇದಾನೀನ್ತನಜನಾನಾಂ ಗಮನಾತ್ ಪೂರ್ವ್ವಮೇವ ತಾನಿ ಸರ್ವ್ವಾಣಿ ಘಟಿಷ್ಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ನಭೋಮೇದಿನ್ಯೋ ರ್ಲುಪ್ತಯೋರಪಿ ಮಮ ವಾಕ್ ಕದಾಪಿ ನ ಲೋಪ್ಸ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","ಅಪರಂ ಮಮ ತಾತಂ ವಿನಾ ಮಾನುಷಃ ಸ್ವರ್ಗಸ್ಥೋ ದೂತೋ ವಾ ಕೋಪಿ ತದ್ದಿನಂ ತದ್ದಣ್ಡಞ್ಚ ನ ಜ್ಞಾಪಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","ಅಪರಂ ನೋಹೇ ವಿದ್ಯಮಾನೇ ಯಾದೃಶಮಭವತ್ ತಾದೃಶಂ ಮನುಜಸುತಸ್ಯಾಗಮನಕಾಲೇಪಿ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ಫಲತೋ ಜಲಾಪ್ಲಾವನಾತ್ ಪೂರ್ವ್ವಂ ಯದ್ದಿನಂ ಯಾವತ್ ನೋಹಃ ಪೋತಂ ನಾರೋಹತ್, ತಾವತ್ಕಾಲಂ ಯಥಾ ಮನುಷ್ಯಾ ಭೋಜನೇ ಪಾನೇ ವಿವಹನೇ ವಿವಾಹನೇ ಚ ಪ್ರವೃತ್ತಾ ಆಸನ್; ");
INSERT INTO sankan_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ಅಪರಮ್ ಆಪ್ಲಾವಿತೋಯಮಾಗತ್ಯ ಯಾವತ್ ಸಕಲಮನುಜಾನ್ ಪ್ಲಾವಯಿತ್ವಾ ನಾನಯತ್, ತಾವತ್ ತೇ ಯಥಾ ನ ವಿದಾಮಾಸುಃ, ತಥಾ ಮನುಜಸುತಾಗಮನೇಪಿ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","ತದಾ ಕ್ಷೇತ್ರಸ್ಥಿತಯೋರ್ದ್ವಯೋರೇಕೋ ಧಾರಿಷ್ಯತೇ, ಅಪರಸ್ತ್ಯಾಜಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ತಥಾ ಪೇಷಣ್ಯಾ ಪಿಂಷತ್ಯೋರುಭಯೋ ರ್ಯೋಷಿತೋರೇಕಾ ಧಾರಿಷ್ಯತೇಽಪರಾ ತ್ಯಾಜಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","ಯುಷ್ಮಾಕಂ ಪ್ರಭುಃ ಕಸ್ಮಿನ್ ದಣ್ಡ ಆಗಮಿಷ್ಯತಿ, ತದ್ ಯುಷ್ಮಾಭಿ ರ್ನಾವಗಮ್ಯತೇ, ತಸ್ಮಾತ್ ಜಾಗ್ರತಃ ಸನ್ತಸ್ತಿಷ್ಠತ| ");
INSERT INTO sankan_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","ಕುತ್ರ ಯಾಮೇ ಸ್ತೇನ ಆಗಮಿಷ್ಯತೀತಿ ಚೇದ್ ಗೃಹಸ್ಥೋ ಜ್ಞಾತುಮ್ ಅಶಕ್ಷ್ಯತ್, ತರ್ಹಿ ಜಾಗರಿತ್ವಾ ತಂ ಸನ್ಧಿಂ ಕರ್ತ್ತಿತುಮ್ ಅವಾರಯಿಷ್ಯತ್ ತದ್ ಜಾನೀತ| ");
INSERT INTO sankan_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","ಯುಷ್ಮಾಭಿರವಧೀಯತಾಂ, ಯತೋ ಯುಷ್ಮಾಭಿ ರ್ಯತ್ರ ನ ಬುಧ್ಯತೇ, ತತ್ರೈವ ದಣ್ಡೇ ಮನುಜಸುತ ಆಯಾಸ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","ಪ್ರಭು ರ್ನಿಜಪರಿವಾರಾನ್ ಯಥಾಕಾಲಂ ಭೋಜಯಿತುಂ ಯಂ ದಾಸಮ್ ಅಧ್ಯಕ್ಷೀಕೃತ್ಯ ಸ್ಥಾಪಯತಿ, ತಾದೃಶೋ ವಿಶ್ವಾಸ್ಯೋ ಧೀಮಾನ್ ದಾಸಃ ಕಃ? ");
INSERT INTO sankan_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ಪ್ರಭುರಾಗತ್ಯ ಯಂ ದಾಸಂ ತಥಾಚರನ್ತಂ ವೀಕ್ಷತೇ, ಸಏವ ಧನ್ಯಃ| ");
INSERT INTO sankan_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","ಯುಷ್ಮಾನಹಂ ಸತ್ಯಂ ವದಾಮಿ, ಸ ತಂ ನಿಜಸರ್ವ್ವಸ್ವಸ್ಯಾಧಿಪಂ ಕರಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","ಕಿನ್ತು ಪ್ರಭುರಾಗನ್ತುಂ ವಿಲಮ್ಬತ ಇತಿ ಮನಸಿ ಚಿನ್ತಯಿತ್ವಾ ಯೋ ದುಷ್ಟೋ ದಾಸೋ ");
INSERT INTO sankan_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ಽಪರದಾಸಾನ್ ಪ್ರಹರ್ತ್ತುಂ ಮತ್ತಾನಾಂ ಸಙ್ಗೇ ಭೋಕ್ತುಂ ಪಾತುಞ್ಚ ಪ್ರವರ್ತ್ತತೇ, ");
INSERT INTO sankan_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ಸ ದಾಸೋ ಯದಾ ನಾಪೇಕ್ಷತೇ, ಯಞ್ಚ ದಣ್ಡಂ ನ ಜಾನಾತಿ, ತತ್ಕಾಲಏವ ತತ್ಪ್ರಭುರುಪಸ್ಥಾಸ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ತದಾ ತಂ ದಣ್ಡಯಿತ್ವಾ ಯತ್ರ ಸ್ಥಾನೇ ರೋದನಂ ದನ್ತಘರ್ಷಣಞ್ಚಾಸಾತೇ, ತತ್ರ ಕಪಟಿಭಿಃ ಸಾಕಂ ತದ್ದಶಾಂ ನಿರೂಪಯಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","ಯಾ ದಶ ಕನ್ಯಾಃ ಪ್ರದೀಪಾನ್ ಗೃಹ್ಲತ್ಯೋ ವರಂ ಸಾಕ್ಷಾತ್ ಕರ್ತ್ತುಂ ಬಹಿರಿತಾಃ, ತಾಭಿಸ್ತದಾ ಸ್ವರ್ಗೀಯರಾಜ್ಯಸ್ಯ ಸಾದೃಶ್ಯಂ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ತಾಸಾಂ ಕನ್ಯಾನಾಂ ಮಧ್ಯೇ ಪಞ್ಚ ಸುಧಿಯಃ ಪಞ್ಚ ದುರ್ಧಿಯ ಆಸನ್| ");
INSERT INTO sankan_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ಯಾ ದುರ್ಧಿಯಸ್ತಾಃ ಪ್ರದೀಪಾನ್ ಸಙ್ಗೇ ಗೃಹೀತ್ವಾ ತೈಲಂ ನ ಜಗೃಹುಃ, ");
INSERT INTO sankan_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ಕಿನ್ತು ಸುಧಿಯಃ ಪ್ರದೀಪಾನ್ ಪಾತ್ರೇಣ ತೈಲಞ್ಚ ಜಗೃಹುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","ಅನನ್ತರಂ ವರೇ ವಿಲಮ್ಬಿತೇ ತಾಃ ಸರ್ವ್ವಾ ನಿದ್ರಾವಿಷ್ಟಾ ನಿದ್ರಾಂ ಜಗ್ಮುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","ಅನನ್ತರಮ್ ಅರ್ದ್ಧರಾತ್ರೇ ಪಶ್ಯತ ವರ ಆಗಚ್ಛತಿ, ತಂ ಸಾಕ್ಷಾತ್ ಕರ್ತ್ತುಂ ಬಹಿರ್ಯಾತೇತಿ ಜನರವಾತ್ ");
INSERT INTO sankan_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","ತಾಃ ಸರ್ವ್ವಾಃ ಕನ್ಯಾ ಉತ್ಥಾಯ ಪ್ರದೀಪಾನ್ ಆಸಾದಯಿತುಂ ಆರಭನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ತತೋ ದುರ್ಧಿಯಃ ಸುಧಿಯ ಊಚುಃ, ಕಿಞ್ಚಿತ್ ತೈಲಂ ದತ್ತ, ಪ್ರದೀಪಾ ಅಸ್ಮಾಕಂ ನಿರ್ವ್ವಾಣಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","ಕಿನ್ತು ಸುಧಿಯಃ ಪ್ರತ್ಯವದನ್, ದತ್ತೇ ಯುಷ್ಮಾನಸ್ಮಾಂಶ್ಚ ಪ್ರತಿ ತೈಲಂ ನ್ಯೂನೀಭವೇತ್, ತಸ್ಮಾದ್ ವಿಕ್ರೇತೃಣಾಂ ಸಮೀಪಂ ಗತ್ವಾ ಸ್ವಾರ್ಥಂ ತೈಲಂ ಕ್ರೀಣೀತ| ");
INSERT INTO sankan_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","ತದಾ ತಾಸು ಕ್ರೇತುಂ ಗತಾಸು ವರ ಆಜಗಾಮ, ತತೋ ಯಾಃ ಸಜ್ಜಿತಾ ಆಸನ್, ತಾಸ್ತೇನ ಸಾಕಂ ವಿವಾಹೀಯಂ ವೇಶ್ಮ ಪ್ರವಿವಿಶುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","ಅನನ್ತರಂ ದ್ವಾರೇ ರುದ್ಧೇ ಅಪರಾಃ ಕನ್ಯಾ ಆಗತ್ಯ ಜಗದುಃ, ಹೇ ಪ್ರಭೋ, ಹೇ ಪ್ರಭೋ, ಅಸ್ಮಾನ್ ಪ್ರತಿ ದ್ವಾರಂ ಮೋಚಯ| ");
INSERT INTO sankan_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ಕಿನ್ತು ಸ ಉಕ್ತವಾನ್, ತಥ್ಯಂ ವದಾಮಿ, ಯುಷ್ಮಾನಹಂ ನ ವೇದ್ಮಿ| ");
INSERT INTO sankan_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","ಅತೋ ಜಾಗ್ರತಃ ಸನ್ತಸ್ತಿಷ್ಠತ, ಮನುಜಸುತಃ ಕಸ್ಮಿನ್ ದಿನೇ ಕಸ್ಮಿನ್ ದಣ್ಡೇ ವಾಗಮಿಷ್ಯತಿ, ತದ್ ಯುಷ್ಮಾಭಿ ರ್ನ ಜ್ಞಾಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","ಅಪರಂ ಸ ಏತಾದೃಶಃ ಕಸ್ಯಚಿತ್ ಪುಂಸಸ್ತುಲ್ಯಃ, ಯೋ ದೂರದೇಶಂ ಪ್ರತಿ ಯಾತ್ರಾಕಾಲೇ ನಿಜದಾಸಾನ್ ಆಹೂಯ ತೇಷಾಂ ಸ್ವಸ್ವಸಾಮರ್ಥ್ಯಾನುರೂಪಮ್ ");
INSERT INTO sankan_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ಏಕಸ್ಮಿನ್ ಮುದ್ರಾಣಾಂ ಪಞ್ಚ ಪೋಟಲಿಕಾಃ ಅನ್ಯಸ್ಮಿಂಶ್ಚ ದ್ವೇ ಪೋಟಲಿಕೇ ಅಪರಸ್ಮಿಂಶ್ಚ ಪೋಟಲಿಕೈಕಾಮ್ ಇತ್ಥಂ ಪ್ರತಿಜನಂ ಸಮರ್ಪ್ಯ ಸ್ವಯಂ ಪ್ರವಾಸಂ ಗತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","ಅನನ್ತರಂ ಯೋ ದಾಸಃ ಪಞ್ಚ ಪೋಟಲಿಕಾಃ ಲಬ್ಧವಾನ್, ಸ ಗತ್ವಾ ವಾಣಿಜ್ಯಂ ವಿಧಾಯ ತಾ ದ್ವಿಗುಣೀಚಕಾರ| ");
INSERT INTO sankan_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ಯಶ್ಚ ದಾಸೋ ದ್ವೇ ಪೋಟಲಿಕೇ ಅಲಭತ, ಸೋಪಿ ತಾ ಮುದ್ರಾ ದ್ವಿಗುಣೀಚಕಾರ| ");
INSERT INTO sankan_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","ಕಿನ್ತು ಯೋ ದಾಸ ಏಕಾಂ ಪೋಟಲಿಕಾಂ ಲಬ್ಧವಾನ್, ಸ ಗತ್ವಾ ಭೂಮಿಂ ಖನಿತ್ವಾ ತನ್ಮಧ್ಯೇ ನಿಜಪ್ರಭೋಸ್ತಾ ಮುದ್ರಾ ಗೋಪಯಾಞ್ಚಕಾರ| ");
INSERT INTO sankan_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","ತದನನ್ತರಂ ಬಹುತಿಥೇ ಕಾಲೇ ಗತೇ ತೇಷಾಂ ದಾಸಾನಾಂ ಪ್ರಭುರಾಗತ್ಯ ತೈರ್ದಾಸೈಃ ಸಮಂ ಗಣಯಾಞ್ಚಕಾರ| ");
INSERT INTO sankan_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","ತದಾನೀಂ ಯಃ ಪಞ್ಚ ಪೋಟಲಿಕಾಃ ಪ್ರಾಪ್ತವಾನ್ ಸ ತಾ ದ್ವಿಗುಣೀಕೃತಮುದ್ರಾ ಆನೀಯ ಜಗಾದ; ಹೇ ಪ್ರಭೋ, ಭವತಾ ಮಯಿ ಪಞ್ಚ ಪೋಟಲಿಕಾಃ ಸಮರ್ಪಿತಾಃ, ಪಶ್ಯತು, ತಾ ಮಯಾ ದ್ವಿಗುಣೀಕೃತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ತದಾನೀಂ ತಸ್ಯ ಪ್ರಭುಸ್ತಮುವಾಚ, ಹೇ ಉತ್ತಮ ವಿಶ್ವಾಸ್ಯ ದಾಸ, ತ್ವಂ ಧನ್ಯೋಸಿ, ಸ್ತೋಕೇನ ವಿಶ್ವಾಸ್ಯೋ ಜಾತಃ, ತಸ್ಮಾತ್ ತ್ವಾಂ ಬಹುವಿತ್ತಾಧಿಪಂ ಕರೋಮಿ, ತ್ವಂ ಸ್ವಪ್ರಭೋಃ ಸುಖಸ್ಯ ಭಾಗೀ ಭವ| ");
INSERT INTO sankan_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","ತತೋ ಯೇನ ದ್ವೇ ಪೋಟಲಿಕೇ ಲಬ್ಧೇ ಸೋಪ್ಯಾಗತ್ಯ ಜಗಾದ, ಹೇ ಪ್ರಭೋ, ಭವತಾ ಮಯಿ ದ್ವೇ ಪೋಟಲಿಕೇ ಸಮರ್ಪಿತೇ, ಪಶ್ಯತು ತೇ ಮಯಾ ದ್ವಿಗುಣೀಕೃತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ತೇನ ತಸ್ಯ ಪ್ರಭುಸ್ತಮವೋಚತ್, ಹೇ ಉತ್ತಮ ವಿಶ್ವಾಸ್ಯ ದಾಸ, ತ್ವಂ ಧನ್ಯೋಸಿ, ಸ್ತೋಕೇನ ವಿಶ್ವಾಸ್ಯೋ ಜಾತಃ, ತಸ್ಮಾತ್ ತ್ವಾಂ ಬಹುದ್ರವಿಣಾಧಿಪಂ ಕರೋಮಿ, ತ್ವಂ ನಿಜಪ್ರಭೋಃ ಸುಖಸ್ಯ ಭಾಗೀ ಭವ| ");
INSERT INTO sankan_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","ಅನನ್ತರಂ ಯ ಏಕಾಂ ಪೋಟಲಿಕಾಂ ಲಬ್ಧವಾನ್, ಸ ಏತ್ಯ ಕಥಿತವಾನ್, ಹೇ ಪ್ರಭೋ, ತ್ವಾಂ ಕಠಿನನರಂ ಜ್ಞಾತವಾನ್, ತ್ವಯಾ ಯತ್ರ ನೋಪ್ತಂ, ತತ್ರೈವ ಕೃತ್ಯತೇ, ಯತ್ರ ಚ ನ ಕೀರ್ಣಂ, ತತ್ರೈವ ಸಂಗೃಹ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ಅತೋಹಂ ಸಶಙ್ಕಃ ಸನ್ ಗತ್ವಾ ತವ ಮುದ್ರಾ ಭೂಮಧ್ಯೇ ಸಂಗೋಪ್ಯ ಸ್ಥಾಪಿತವಾನ್, ಪಶ್ಯ, ತವ ಯತ್ ತದೇವ ಗೃಹಾಣ| ");
INSERT INTO sankan_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","ತದಾ ತಸ್ಯ ಪ್ರಭುಃ ಪ್ರತ್ಯವದತ್ ರೇ ದುಷ್ಟಾಲಸ ದಾಸ, ಯತ್ರಾಹಂ ನ ವಪಾಮಿ, ತತ್ರ ಛಿನದ್ಮಿ, ಯತ್ರ ಚ ನ ಕಿರಾಮಿ, ತತ್ರೇವ ಸಂಗೃಹ್ಲಾಮೀತಿ ಚೇದಜಾನಾಸ್ತರ್ಹಿ ");
INSERT INTO sankan_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ವಣಿಕ್ಷು ಮಮ ವಿತ್ತಾರ್ಪಣಂ ತವೋಚಿತಮಾಸೀತ್, ಯೇನಾಹಮಾಗತ್ಯ ವೃದ್ವ್ಯಾ ಸಾಕಂ ಮೂಲಮುದ್ರಾಃ ಪ್ರಾಪ್ಸ್ಯಮ್| ");
INSERT INTO sankan_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","ಅತೋಸ್ಮಾತ್ ತಾಂ ಪೋಟಲಿಕಾಮ್ ಆದಾಯ ಯಸ್ಯ ದಶ ಪೋಟಲಿಕಾಃ ಸನ್ತಿ ತಸ್ಮಿನ್ನರ್ಪಯತ| ");
INSERT INTO sankan_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ಯೇನ ವರ್ದ್ವ್ಯತೇ ತಸ್ಮಿನ್ನೈವಾರ್ಪಿಷ್ಯತೇ, ತಸ್ಯೈವ ಚ ಬಾಹುಲ್ಯಂ ಭವಿಷ್ಯತಿ, ಕಿನ್ತು ಯೇನ ನ ವರ್ದ್ವ್ಯತೇ, ತಸ್ಯಾನ್ತಿಕೇ ಯತ್ ಕಿಞ್ಚನ ತಿಷ್ಠತಿ, ತದಪಿ ಪುನರ್ನೇಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","ಅಪರಂ ಯೂಯಂ ತಮಕರ್ಮ್ಮಣ್ಯಂ ದಾಸಂ ನೀತ್ವಾ ಯತ್ರ ಸ್ಥಾನೇ ಕ್ರನ್ದನಂ ದನ್ತಘರ್ಷಣಞ್ಚ ವಿದ್ಯೇತೇ, ತಸ್ಮಿನ್ ಬಹಿರ್ಭೂತತಮಸಿ ನಿಕ್ಷಿಪತ| ");
INSERT INTO sankan_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","ಯದಾ ಮನುಜಸುತಃ ಪವಿತ್ರದೂತಾನ್ ಸಙ್ಗಿನಃ ಕೃತ್ವಾ ನಿಜಪ್ರಭಾವೇನಾಗತ್ಯ ನಿಜತೇಜೋಮಯೇ ಸಿಂಹಾಸನೇ ನಿವೇಕ್ಷ್ಯತಿ, ");
INSERT INTO sankan_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ತದಾ ತತ್ಸಮ್ಮುಖೇ ಸರ್ವ್ವಜಾತೀಯಾ ಜನಾ ಸಂಮೇಲಿಷ್ಯನ್ತಿ| ತತೋ ಮೇಷಪಾಲಕೋ ಯಥಾ ಛಾಗೇಭ್ಯೋಽವೀನ್ ಪೃಥಕ್ ಕರೋತಿ ತಥಾ ಸೋಪ್ಯೇಕಸ್ಮಾದನ್ಯಮ್ ಇತ್ಥಂ ತಾನ್ ಪೃಥಕ ಕೃತ್ವಾವೀನ್ ");
INSERT INTO sankan_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ದಕ್ಷಿಣೇ ಛಾಗಾಂಶ್ಚ ವಾಮೇ ಸ್ಥಾಪಯಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","ತತಃ ಪರಂ ರಾಜಾ ದಕ್ಷಿಣಸ್ಥಿತಾನ್ ಮಾನವಾನ್ ವದಿಷ್ಯತಿ, ಆಗಚ್ಛತ ಮತ್ತಾತಸ್ಯಾನುಗ್ರಹಭಾಜನಾನಿ, ಯುಷ್ಮತ್ಕೃತ ಆ ಜಗದಾರಮ್ಭತ್ ಯದ್ ರಾಜ್ಯಮ್ ಆಸಾದಿತಂ ತದಧಿಕುರುತ| ");
INSERT INTO sankan_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ಯತೋ ಬುಭುಕ್ಷಿತಾಯ ಮಹ್ಯಂ ಭೋಜ್ಯಮ್ ಅದತ್ತ, ಪಿಪಾಸಿತಾಯ ಪೇಯಮದತ್ತ, ವಿದೇಶಿನಂ ಮಾಂ ಸ್ವಸ್ಥಾನಮನಯತ, ");
INSERT INTO sankan_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ವಸ್ತ್ರಹೀನಂ ಮಾಂ ವಸನಂ ಪರ್ಯ್ಯಧಾಪಯತ, ಪೀಡೀತಂ ಮಾಂ ದ್ರಷ್ಟುಮಾಗಚ್ಛತ, ಕಾರಾಸ್ಥಞ್ಚ ಮಾಂ ವೀಕ್ಷಿತುಮ ಆಗಚ್ಛತ| ");
INSERT INTO sankan_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","ತದಾ ಧಾರ್ಮ್ಮಿಕಾಃ ಪ್ರತಿವದಿಷ್ಯನ್ತಿ, ಹೇ ಪ್ರಭೋ, ಕದಾ ತ್ವಾಂ ಕ್ಷುಧಿತಂ ವೀಕ್ಷ್ಯ ವಯಮಭೋಜಯಾಮ? ವಾ ಪಿಪಾಸಿತಂ ವೀಕ್ಷ್ಯ ಅಪಾಯಯಾಮ? ");
INSERT INTO sankan_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ಕದಾ ವಾ ತ್ವಾಂ ವಿದೇಶಿನಂ ವಿಲೋಕ್ಯ ಸ್ವಸ್ಥಾನಮನಯಾಮ? ಕದಾ ವಾ ತ್ವಾಂ ನಗ್ನಂ ವೀಕ್ಷ್ಯ ವಸನಂ ಪರ್ಯ್ಯಧಾಪಯಾಮ? ");
INSERT INTO sankan_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ಕದಾ ವಾ ತ್ವಾಂ ಪೀಡಿತಂ ಕಾರಾಸ್ಥಞ್ಚ ವೀಕ್ಷ್ಯ ತ್ವದನ್ತಿಕಮಗಚ್ಛಾಮ? ");
INSERT INTO sankan_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","ತದಾನೀಂ ರಾಜಾ ತಾನ್ ಪ್ರತಿವದಿಷ್ಯತಿ, ಯುಷ್ಮಾನಹಂ ಸತ್ಯಂ ವದಾಮಿ, ಮಮೈತೇಷಾಂ ಭ್ರಾತೃಣಾಂ ಮಧ್ಯೇ ಕಞ್ಚನೈಕಂ ಕ್ಷುದ್ರತಮಂ ಪ್ರತಿ ಯದ್ ಅಕುರುತ, ತನ್ಮಾಂ ಪ್ರತ್ಯಕುರುತ| ");
INSERT INTO sankan_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","ಪಶ್ಚಾತ್ ಸ ವಾಮಸ್ಥಿತಾನ್ ಜನಾನ್ ವದಿಷ್ಯತಿ, ರೇ ಶಾಪಗ್ರಸ್ತಾಃ ಸರ್ವ್ವೇ, ಶೈತಾನೇ ತಸ್ಯ ದೂತೇಭ್ಯಶ್ಚ ಯೋಽನನ್ತವಹ್ನಿರಾಸಾದಿತ ಆಸ್ತೇ, ಯೂಯಂ ಮದನ್ತಿಕಾತ್ ತಮಗ್ನಿಂ ಗಚ್ಛತ| ");
INSERT INTO sankan_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ಯತೋ ಕ್ಷುಧಿತಾಯ ಮಹ್ಯಮಾಹಾರಂ ನಾದತ್ತ, ಪಿಪಾಸಿತಾಯ ಮಹ್ಯಂ ಪೇಯಂ ನಾದತ್ತ, ");
INSERT INTO sankan_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ವಿದೇಶಿನಂ ಮಾಂ ಸ್ವಸ್ಥಾನಂ ನಾನಯತ, ವಸನಹೀನಂ ಮಾಂ ವಸನಂ ನ ಪರ್ಯ್ಯಧಾಪಯತ, ಪೀಡಿತಂ ಕಾರಾಸ್ಥಞ್ಚ ಮಾಂ ವೀಕ್ಷಿತುಂ ನಾಗಚ್ಛತ| ");
INSERT INTO sankan_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","ತದಾ ತೇ ಪ್ರತಿವದಿಷ್ಯನ್ತಿ, ಹೇ ಪ್ರಭೋ, ಕದಾ ತ್ವಾಂ ಕ್ಷುಧಿತಂ ವಾ ಪಿಪಾಸಿತಂ ವಾ ವಿದೇಶಿನಂ ವಾ ನಗ್ನಂ ವಾ ಪೀಡಿತಂ ವಾ ಕಾರಾಸ್ಥಂ ವೀಕ್ಷ್ಯ ತ್ವಾಂ ನಾಸೇವಾಮಹಿ? ");
INSERT INTO sankan_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","ತದಾ ಸ ತಾನ್ ವದಿಷ್ಯತಿ, ತಥ್ಯಮಹಂ ಯುಷ್ಮಾನ್ ಬ್ರವೀಮಿ, ಯುಷ್ಮಾಭಿರೇಷಾಂ ಕಞ್ಚನ ಕ್ಷೋದಿಷ್ಠಂ ಪ್ರತಿ ಯನ್ನಾಕಾರಿ, ತನ್ಮಾಂ ಪ್ರತ್ಯೇವ ನಾಕಾರಿ| ");
INSERT INTO sankan_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","ಪಶ್ಚಾದಮ್ಯನನ್ತಶಾಸ್ತಿಂ ಕಿನ್ತು ಧಾರ್ಮ್ಮಿಕಾ ಅನನ್ತಾಯುಷಂ ಭೋಕ್ತುಂ ಯಾಸ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","ಯೀಶುರೇತಾನ್ ಪ್ರಸ್ತಾವಾನ್ ಸಮಾಪ್ಯ ಶಿಷ್ಯಾನೂಚೇ, ");
INSERT INTO sankan_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","ಯುಷ್ಮಾಭಿ ರ್ಜ್ಞಾತಂ ದಿನದ್ವಯಾತ್ ಪರಂ ನಿಸ್ತಾರಮಹ ಉಪಸ್ಥಾಸ್ಯತಿ, ತತ್ರ ಮನುಜಸುತಃ ಕ್ರುಶೇನ ಹನ್ತುಂ ಪರಕರೇಷು ಸಮರ್ಪಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","ತತಃ ಪರಂ ಪ್ರಧಾನಯಾಜಕಾಧ್ಯಾಪಕಪ್ರಾಞ್ಚಃ ಕಿಯಫಾನಾಮ್ನೋ ಮಹಾಯಾಜಕಸ್ಯಾಟ್ಟಾಲಿಕಾಯಾಂ ಮಿಲಿತ್ವಾ ");
INSERT INTO sankan_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ಕೇನೋಪಾಯೇನ ಯೀಶುಂ ಧೃತ್ವಾ ಹನ್ತುಂ ಶಕ್ನುಯುರಿತಿ ಮನ್ತ್ರಯಾಞ್ಚಕ್ರುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ಕಿನ್ತು ತೈರುಕ್ತಂ ಮಹಕಾಲೇ ನ ಧರ್ತ್ತವ್ಯಃ, ಧೃತೇ ಪ್ರಜಾನಾಂ ಕಲಹೇನ ಭವಿತುಂ ಶಕ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","ತತೋ ಬೈಥನಿಯಾಪುರೇ ಶಿಮೋನಾಖ್ಯಸ್ಯ ಕುಷ್ಠಿನೋ ವೇಶ್ಮನಿ ಯೀಶೌ ತಿಷ್ಠತಿ ");
INSERT INTO sankan_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ಕಾಚನ ಯೋಷಾ ಶ್ವೇತೋಪಲಭಾಜನೇನ ಮಹಾರ್ಘ್ಯಂ ಸುಗನ್ಧಿ ತೈಲಮಾನೀಯ ಭೋಜನಾಯೋಪವಿಶತಸ್ತಸ್ಯ ಶಿರೋಭ್ಯಷೇಚತ್| ");
INSERT INTO sankan_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ಕಿನ್ತು ತದಾಲೋಕ್ಯ ತಚ್ಛಿಷ್ಯೈಃ ಕುಪಿತೈರುಕ್ತಂ, ಕುತ ಇತ್ಥಮಪವ್ಯಯತೇ? ");
INSERT INTO sankan_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ಚೇದಿದಂ ವ್ಯಕ್ರೇಷ್ಯತ, ತರ್ಹಿ ಭೂರಿಮೂಲ್ಯಂ ಪ್ರಾಪ್ಯ ದರಿದ್ರೇಭ್ಯೋ ವ್ಯತಾರಿಷ್ಯತ| ");
INSERT INTO sankan_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","ಯೀಶುನಾ ತದವಗತ್ಯ ತೇ ಸಮುದಿತಾಃ, ಯೋಷಾಮೇನಾಂ ಕುತೋ ದುಃಖಿನೀಂ ಕುರುಥ, ಸಾ ಮಾಂ ಪ್ರತಿ ಸಾಧು ಕರ್ಮ್ಮಾಕಾರ್ಷೀತ್| ");
INSERT INTO sankan_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","ಯುಷ್ಮಾಕಮಂ ಸಮೀಪೇ ದರಿದ್ರಾಃ ಸತತಮೇವಾಸತೇ, ಕಿನ್ತು ಯುಷ್ಮಾಕಮನ್ತಿಕೇಹಂ ನಾಸೇ ಸತತಂ| ");
INSERT INTO sankan_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ಸಾ ಮಮ ಕಾಯೋಪರಿ ಸುಗನ್ಧಿತೈಲಂ ಸಿಕ್ತ್ವಾ ಮಮ ಶ್ಮಶಾನದಾನಕರ್ಮ್ಮಾಕಾರ್ಷೀತ್| ");
INSERT INTO sankan_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","ಅತೋಹಂ ಯುಷ್ಮಾನ್ ತಥ್ಯಂ ವದಾಮಿ ಸರ್ವ್ವಸ್ಮಿನ್ ಜಗತಿ ಯತ್ರ ಯತ್ರೈಷ ಸುಸಮಾಚಾರಃ ಪ್ರಚಾರಿಷ್ಯತೇ, ತತ್ರ ತತ್ರೈತಸ್ಯಾ ನಾರ್ಯ್ಯಾಃ ಸ್ಮರಣಾರ್ಥಮ್ ಕರ್ಮ್ಮೇದಂ ಪ್ರಚಾರಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","ತತೋ ದ್ವಾದಶಶಿಷ್ಯಾಣಾಮ್ ಈಷ್ಕರಿಯೋತೀಯಯಿಹೂದಾನಾಮಕ ಏಕಃ ಶಿಷ್ಯಃ ಪ್ರಧಾನಯಾಜಕಾನಾಮನ್ತಿಕಂ ಗತ್ವಾ ಕಥಿತವಾನ್, ");
INSERT INTO sankan_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ಯದಿ ಯುಷ್ಮಾಕಂ ಕರೇಷು ಯೀಶುಂ ಸಮರ್ಪಯಾಮಿ, ತರ್ಹಿ ಕಿಂ ದಾಸ್ಯಥ? ತದಾನೀಂ ತೇ ತಸ್ಮೈ ತ್ರಿಂಶನ್ಮುದ್ರಾ ದಾತುಂ ಸ್ಥಿರೀಕೃತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ಸ ತದಾರಭ್ಯ ತಂ ಪರಕರೇಷು ಸಮರ್ಪಯಿತುಂ ಸುಯೋಗಂ ಚೇಷ್ಟಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","ಅನನ್ತರಂ ಕಿಣ್ವಶೂನ್ಯಪೂಪಪರ್ವ್ವಣಃ ಪ್ರಥಮೇಹ್ನಿ ಶಿಷ್ಯಾ ಯೀಶುಮ್ ಉಪಗತ್ಯ ಪಪ್ರಚ್ಛುಃ ಭವತ್ಕೃತೇ ಕುತ್ರ ವಯಂ ನಿಸ್ತಾರಮಹಭೋಜ್ಯಮ್ ಆಯೋಜಯಿಷ್ಯಾಮಃ? ಭವತಃ ಕೇಚ್ಛಾ? ");
INSERT INTO sankan_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ತದಾ ಸ ಗದಿತವಾನ್, ಮಧ್ಯೇನಗರಮಮುಕಪುಂಸಃ ಸಮೀಪಂ ವ್ರಜಿತ್ವಾ ವದತ, ಗುರು ರ್ಗದಿತವಾನ್, ಮತ್ಕಾಲಃ ಸವಿಧಃ, ಸಹ ಶಿಷ್ಯೈಸ್ತ್ವದಾಲಯೇ ನಿಸ್ತಾರಮಹಭೋಜ್ಯಂ ಭೋಕ್ಷ್ಯೇ| ");
INSERT INTO sankan_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ತದಾ ಶಿಷ್ಯಾ ಯೀಶೋಸ್ತಾದೃಶನಿದೇಶಾನುರೂಪಕರ್ಮ್ಮ ವಿಧಾಯ ತತ್ರ ನಿಸ್ತಾರಮಹಭೋಜ್ಯಮಾಸಾದಯಾಮಾಸುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ತತಃ ಸನ್ಧ್ಯಾಯಾಂ ಸತ್ಯಾಂ ದ್ವಾದಶಭಿಃ ಶಿಷ್ಯೈಃ ಸಾಕಂ ಸ ನ್ಯವಿಶತ್| ");
INSERT INTO sankan_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ಅಪರಂ ಭುಞ್ಜಾನ ಉಕ್ತವಾನ್ ಯುಷ್ಮಾನ್ ತಥ್ಯಂ ವದಾಮಿ, ಯುಷ್ಮಾಕಮೇಕೋ ಮಾಂ ಪರಕರೇಷು ಸಮರ್ಪಯಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ತದಾ ತೇಽತೀವ ದುಃಖಿತಾ ಏಕೈಕಶೋ ವಕ್ತುಮಾರೇಭಿರೇ, ಹೇ ಪ್ರಭೋ, ಸ ಕಿಮಹಂ? ");
INSERT INTO sankan_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ತತಃ ಸ ಜಗಾದ, ಮಯಾ ಸಾಕಂ ಯೋ ಜನೋ ಭೋಜನಪಾತ್ರೇ ಕರಂ ಸಂಕ್ಷಿಪತಿ, ಸ ಏವ ಮಾಂ ಪರಕರೇಷು ಸಮರ್ಪಯಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","ಮನುಜಸುತಮಧಿ ಯಾದೃಶಂ ಲಿಖಿತಮಾಸ್ತೇ, ತದನುರೂಪಾ ತದ್ಗತಿ ರ್ಭವಿಷ್ಯತಿ; ಕಿನ್ತು ಯೇನ ಪುಂಸಾ ಸ ಪರಕರೇಷು ಸಮರ್ಪಯಿಷ್ಯತೇ, ಹಾ ಹಾ ಚೇತ್ ಸ ನಾಜನಿಷ್ಯತ, ತದಾ ತಸ್ಯ ಕ್ಷೇಮಮಭವಿಷ್ಯತ್| ");
INSERT INTO sankan_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ತದಾ ಯಿಹೂದಾನಾಮಾ ಯೋ ಜನಸ್ತಂ ಪರಕರೇಷು ಸಮರ್ಪಯಿಷ್ಯತಿ, ಸ ಉಕ್ತವಾನ್, ಹೇ ಗುರೋ, ಸ ಕಿಮಹಂ? ತತಃ ಸ ಪ್ರತ್ಯುಕ್ತವಾನ್, ತ್ವಯಾ ಸತ್ಯಂ ಗದಿತಮ್| ");
INSERT INTO sankan_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","ಅನನ್ತರಂ ತೇಷಾಮಶನಕಾಲೇ ಯೀಶುಃ ಪೂಪಮಾದಾಯೇಶ್ವರೀಯಗುಣಾನನೂದ್ಯ ಭಂಕ್ತ್ವಾ ಶಿಷ್ಯೇಭ್ಯಃ ಪ್ರದಾಯ ಜಗಾದ, ಮದ್ವಪುಃಸ್ವರೂಪಮಿಮಂ ಗೃಹೀತ್ವಾ ಖಾದತ| ");
INSERT INTO sankan_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ಪಶ್ಚಾತ್ ಸ ಕಂಸಂ ಗೃಹ್ಲನ್ ಈಶ್ವರೀಯಗುಣಾನನೂದ್ಯ ತೇಭ್ಯಃ ಪ್ರದಾಯ ಕಥಿತವಾನ್, ಸರ್ವ್ವೈ ರ್ಯುಷ್ಮಾಭಿರನೇನ ಪಾತವ್ಯಂ, ");
INSERT INTO sankan_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ಯಸ್ಮಾದನೇಕೇಷಾಂ ಪಾಪಮರ್ಷಣಾಯ ಪಾತಿತಂ ಯನ್ಮನ್ನೂತ್ನನಿಯಮರೂಪಶೋಣಿತಂ ತದೇತತ್| ");
INSERT INTO sankan_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","ಅಪರಮಹಂ ನೂತ್ನಗೋಸ್ತನೀರಸಂ ನ ಪಾಸ್ಯಾಮಿ, ತಾವತ್ ಗೋಸ್ತನೀಫಲರಸಂ ಪುನಃ ಕದಾಪಿ ನ ಪಾಸ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ಪಶ್ಚಾತ್ ತೇ ಗೀತಮೇಕಂ ಸಂಗೀಯ ಜೈತುನಾಖ್ಯಗಿರಿಂ ಗತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","ತದಾನೀಂ ಯೀಶುಸ್ತಾನವೋಚತ್, ಅಸ್ಯಾಂ ರಜನ್ಯಾಮಹಂ ಯುಷ್ಮಾಕಂ ಸರ್ವ್ವೇಷಾಂ ವಿಘ್ನರೂಪೋ ಭವಿಷ್ಯಾಮಿ, ಯತೋ ಲಿಖಿತಮಾಸ್ತೇ, \"ಮೇಷಾಣಾಂ ರಕ್ಷಕೋ ಯಸ್ತಂ ಪ್ರಹರಿಷ್ಯಾಮ್ಯಹಂ ತತಃ| ಮೇಷಾಣಾಂ ನಿವಹೋ ನೂನಂ ಪ್ರವಿಕೀರ್ಣೋ ಭವಿಷ್ಯತಿ\"|| ");
INSERT INTO sankan_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","ಕಿನ್ತು ಶ್ಮಶಾನಾತ್ ಸಮುತ್ಥಾಯ ಯುಷ್ಮಾಕಮಗ್ರೇಽಹಂ ಗಾಲೀಲಂ ಗಮಿಷ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ಪಿತರಸ್ತಂ ಪ್ರೋವಾಚ, ಭವಾಂಶ್ಚೇತ್ ಸರ್ವ್ವೇಷಾಂ ವಿಘ್ನರೂಪೋ ಭವತಿ, ತಥಾಪಿ ಮಮ ನ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ತತೋ ಯೀಶುನಾ ಸ ಉಕ್ತಃ, ತುಭ್ಯಮಹಂ ತಥ್ಯಂ ಕಥಯಾಮಿ, ಯಾಮಿನ್ಯಾಮಸ್ಯಾಂ ಚರಣಾಯುಧಸ್ಯ ರವಾತ್ ಪೂರ್ವ್ವಂ ತ್ವಂ ಮಾಂ ತ್ರಿ ರ್ನಾಙ್ಗೀಕರಿಷ್ಯಸಿ| ");
INSERT INTO sankan_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ತತಃ ಪಿತರ ಉದಿತವಾನ್, ಯದ್ಯಪಿ ತ್ವಯಾ ಸಮಂ ಮರ್ತ್ತವ್ಯಂ, ತಥಾಪಿ ಕದಾಪಿ ತ್ವಾಂ ನ ನಾಙ್ಗೀಕರಿಷ್ಯಾಮಿ; ತಥೈವ ಸರ್ವ್ವೇ ಶಿಷ್ಯಾಶ್ಚೋಚುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","ಅನನ್ತರಂ ಯೀಶುಃ ಶಿಷ್ಯೈಃ ಸಾಕಂ ಗೇತ್ಶಿಮಾನೀನಾಮಕಂ ಸ್ಥಾನಂ ಪ್ರಸ್ಥಾಯ ತೇಭ್ಯಃ ಕಥಿತವಾನ್, ಅದಃ ಸ್ಥಾನಂ ಗತ್ವಾ ಯಾವದಹಂ ಪ್ರಾರ್ಥಯಿಷ್ಯೇ ತಾವದ್ ಯೂಯಮತ್ರೋಪವಿಶತ| ");
INSERT INTO sankan_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ಪಶ್ಚಾತ್ ಸ ಪಿತರಂ ಸಿವದಿಯಸುತೌ ಚ ಸಙ್ಗಿನಃ ಕೃತ್ವಾ ಗತವಾನ್, ಶೋಕಾಕುಲೋಽತೀವ ವ್ಯಥಿತಶ್ಚ ಬಭೂವ| ");
INSERT INTO sankan_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ತಾನವಾದೀಚ್ಚ ಮೃತಿಯಾತನೇವ ಮತ್ಪ್ರಾಣಾನಾಂ ಯಾತನಾ ಜಾಯತೇ, ಯೂಯಮತ್ರ ಮಯಾ ಸಾರ್ದ್ಧಂ ಜಾಗೃತ| ");
INSERT INTO sankan_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ತತಃ ಸ ಕಿಞ್ಚಿದ್ದೂರಂ ಗತ್ವಾಧೋಮುಖಃ ಪತನ್ ಪ್ರಾರ್ಥಯಾಞ್ಚಕ್ರೇ, ಹೇ ಮತ್ಪಿತರ್ಯದಿ ಭವಿತುಂ ಶಕ್ನೋತಿ, ತರ್ಹಿ ಕಂಸೋಽಯಂ ಮತ್ತೋ ದೂರಂ ಯಾತು; ಕಿನ್ತು ಮದಿಚ್ಛಾವತ್ ನ ಭವತು, ತ್ವದಿಚ್ಛಾವದ್ ಭವತು| ");
INSERT INTO sankan_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ತತಃ ಸ ಶಿಷ್ಯಾನುಪೇತ್ಯ ತಾನ್ ನಿದ್ರತೋ ನಿರೀಕ್ಷ್ಯ ಪಿತರಾಯ ಕಥಯಾಮಾಸ, ಯೂಯಂ ಮಯಾ ಸಾಕಂ ದಣ್ಡಮೇಕಮಪಿ ಜಾಗರಿತುಂ ನಾಶನ್ಕುತ? ");
INSERT INTO sankan_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","ಪರೀಕ್ಷಾಯಾಂ ನ ಪತಿತುಂ ಜಾಗೃತ ಪ್ರಾರ್ಥಯಧ್ವಞ್ಚ; ಆತ್ಮಾ ಸಮುದ್ಯತೋಸ್ತಿ, ಕಿನ್ತು ವಪು ರ್ದುರ್ಬ್ಬಲಂ| ");
INSERT INTO sankan_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ಸ ದ್ವಿತೀಯವಾರಂ ಪ್ರಾರ್ಥಯಾಞ್ಚಕ್ರೇ, ಹೇ ಮತ್ತಾತ, ನ ಪೀತೇ ಯದಿ ಕಂಸಮಿದಂ ಮತ್ತೋ ದೂರಂ ಯಾತುಂ ನ ಶಕ್ನೋತಿ, ತರ್ಹಿ ತ್ವದಿಚ್ಛಾವದ್ ಭವತು| ");
INSERT INTO sankan_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ಸ ಪುನರೇತ್ಯ ತಾನ್ ನಿದ್ರತೋ ದದರ್ಶ, ಯತಸ್ತೇಷಾಂ ನೇತ್ರಾಣಿ ನಿದ್ರಯಾ ಪೂರ್ಣಾನ್ಯಾಸನ್| ");
INSERT INTO sankan_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ಪಶ್ಚಾತ್ ಸ ತಾನ್ ವಿಹಾಯ ವ್ರಜಿತ್ವಾ ತೃತೀಯವಾರಂ ಪೂರ್ವ್ವವತ್ ಕಥಯನ್ ಪ್ರಾರ್ಥಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ತತಃ ಶಿಷ್ಯಾನುಪಾಗತ್ಯ ಗದಿತವಾನ್, ಸಾಮ್ಪ್ರತಂ ಶಯಾನಾಃ ಕಿಂ ವಿಶ್ರಾಮ್ಯಥ? ಪಶ್ಯತ, ಸಮಯ ಉಪಾಸ್ಥಾತ್, ಮನುಜಸುತಃ ಪಾಪಿನಾಂ ಕರೇಷು ಸಮರ್ಪ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ಉತ್ತಿಷ್ಠತ, ವಯಂ ಯಾಮಃ, ಯೋ ಮಾಂ ಪರಕರೇಷು ಮಸರ್ಪಯಿಷ್ಯತಿ, ಪಶ್ಯತ, ಸ ಸಮೀಪಮಾಯಾತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ಏತತ್ಕಥಾಕಥನಕಾಲೇ ದ್ವಾದಶಶಿಷ್ಯಾಣಾಮೇಕೋ ಯಿಹೂದಾನಾಮಕೋ ಮುಖ್ಯಯಾಜಕಲೋಕಪ್ರಾಚೀನೈಃ ಪ್ರಹಿತಾನ್ ಅಸಿಧಾರಿಯಷ್ಟಿಧಾರಿಣೋ ಮನುಜಾನ್ ಗೃಹೀತ್ವಾ ತತ್ಸಮೀಪಮುಪತಸ್ಥೌ| ");
INSERT INTO sankan_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ಅಸೌ ಪರಕರೇಷ್ವರ್ಪಯಿತಾ ಪೂರ್ವ್ವಂ ತಾನ್ ಇತ್ಥಂ ಸಙ್ಕೇತಯಾಮಾಸ, ಯಮಹಂ ಚುಮ್ಬಿಷ್ಯೇ, ಸೋಽಸೌ ಮನುಜಃ,ಸಏವ ಯುಷ್ಮಾಭಿ ರ್ಧಾರ್ಯ್ಯತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ತದಾ ಸ ಸಪದಿ ಯೀಶುಮುಪಾಗತ್ಯ ಹೇ ಗುರೋ, ಪ್ರಣಮಾಮೀತ್ಯುಕ್ತ್ವಾ ತಂ ಚುಚುಮ್ಬೇ| ");
INSERT INTO sankan_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ತದಾ ಯೀಶುಸ್ತಮುವಾಚ, ಹೇ ಮಿತ್ರಂ ಕಿಮರ್ಥಮಾಗತೋಸಿ? ತದಾ ತೈರಾಗತ್ಯ ಯೀಶುರಾಕ್ರಮ್ಯ ದಘ್ರೇ| ");
INSERT INTO sankan_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ತತೋ ಯೀಶೋಃ ಸಙ್ಗಿನಾಮೇಕಃ ಕರಂ ಪ್ರಸಾರ್ಯ್ಯ ಕೋಷಾದಸಿಂ ಬಹಿಷ್ಕೃತ್ಯ ಮಹಾಯಾಜಕಸ್ಯ ದಾಸಮೇಕಮಾಹತ್ಯ ತಸ್ಯ ಕರ್ಣಂ ಚಿಚ್ಛೇದ| ");
INSERT INTO sankan_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","ತತೋ ಯೀಶುಸ್ತಂ ಜಗಾದ, ಖಡ್ಗಂ ಸ್ವಸ್ಥಾನೇे ನಿಧೇಹಿ ಯತೋ ಯೇ ಯೇ ಜನಾ ಅಸಿಂ ಧಾರಯನ್ತಿ, ತಏವಾಸಿನಾ ವಿನಶ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","ಅಪರಂ ಪಿತಾ ಯಥಾ ಮದನ್ತಿಕಂ ಸ್ವರ್ಗೀಯದೂತಾನಾಂ ದ್ವಾದಶವಾಹಿನೀತೋಽಧಿಕಂ ಪ್ರಹಿಣುಯಾತ್ ಮಯಾ ತಮುದ್ದಿಶ್ಯೇದಾನೀಮೇವ ತಥಾ ಪ್ರಾರ್ಥಯಿತುಂ ನ ಶಕ್ಯತೇ, ತ್ವಯಾ ಕಿಮಿತ್ಥಂ ಜ್ಞಾಯತೇ? ");
INSERT INTO sankan_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","ತಥಾ ಸತೀತ್ಥಂ ಘಟಿಷ್ಯತೇ ಧರ್ಮ್ಮಪುಸ್ತಕಸ್ಯ ಯದಿದಂ ವಾಕ್ಯಂ ತತ್ ಕಥಂ ಸಿಧ್ಯೇತ್? ");
INSERT INTO sankan_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","ತದಾನೀಂ ಯೀಶು ರ್ಜನನಿವಹಂ ಜಗಾದ, ಯೂಯಂ ಖಡ್ಗಯಷ್ಟೀನ್ ಆದಾಯ ಮಾಂ ಕಿಂ ಚೌರಂ ಧರ್ತ್ತುಮಾಯಾತಾಃ? ಅಹಂ ಪ್ರತ್ಯಹಂ ಯುಷ್ಮಾಭಿಃ ಸಾಕಮುಪವಿಶ್ಯ ಸಮುಪಾದಿಶಂ, ತದಾ ಮಾಂ ನಾಧರತ; ");
INSERT INTO sankan_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","ಕಿನ್ತು ಭವಿಷ್ಯದ್ವಾದಿನಾಂ ವಾಕ್ಯಾನಾಂ ಸಂಸಿದ್ಧಯೇ ಸರ್ವ್ವಮೇತದಭೂತ್| ತದಾ ಸರ್ವ್ವೇ ಶಿಷ್ಯಾಸ್ತಂ ವಿಹಾಯ ಪಲಾಯನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","ಅನನ್ತರಂ ತೇ ಮನುಜಾ ಯೀಶುಂ ಧೃತ್ವಾ ಯತ್ರಾಧ್ಯಾಪಕಪ್ರಾಞ್ಚಃ ಪರಿಷದಂ ಕುರ್ವ್ವನ್ತ ಉಪಾವಿಶನ್ ತತ್ರ ಕಿಯಫಾನಾाಮಕಮಹಾಯಾಜಕಸ್ಯಾನ್ತಿಕಂ ನಿನ್ಯುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ಕಿನ್ತು ಶೇಷೇ ಕಿಂ ಭವಿಷ್ಯತೀತಿ ವೇತ್ತುಂ ಪಿತರೋ ದೂರೇ ತತ್ಪಶ್ಚಾದ್ ವ್ರಜಿತ್ವಾ ಮಹಾಯಾಜಕಸ್ಯಾಟ್ಟಾಲಿಕಾಂ ಪ್ರವಿಶ್ಯ ದಾಸೈಃ ಸಹಿತ ಉಪಾವಿಶತ್| ");
INSERT INTO sankan_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ತದಾನೀಂ ಪ್ರಧಾನಯಾಜಕಪ್ರಾಚೀನಮನ್ತ್ರಿಣಃ ಸರ್ವ್ವೇ ಯೀಶುಂ ಹನ್ತುಂ ಮೃಷಾಸಾಕ್ಷ್ಯಮ್ ಅಲಿಪ್ಸನ್ತ, ");
INSERT INTO sankan_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ಕಿನ್ತು ನ ಲೇಭಿರೇ| ಅನೇಕೇಷು ಮೃಷಾಸಾಕ್ಷಿಷ್ವಾಗತೇಷ್ವಪಿ ತನ್ನ ಪ್ರಾಪುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ಶೇಷೇ ದ್ವೌ ಮೃಷಾಸಾಕ್ಷಿಣಾವಾಗತ್ಯ ಜಗದತುಃ, ಪುಮಾನಯಮಕಥಯತ್, ಅಹಮೀಶ್ವರಮನ್ದಿರಂ ಭಂಕ್ತ್ವಾ ದಿನತ್ರಯಮಧ್ಯೇ ತನ್ನಿರ್ಮ್ಮಾತುಂ ಶಕ್ನೋಮಿ| ");
INSERT INTO sankan_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ತದಾ ಮಹಾಯಾಜಕ ಉತ್ಥಾಯ ಯೀಶುಮ್ ಅವಾದೀತ್| ತ್ವಂ ಕಿಮಪಿ ನ ಪ್ರತಿವದಸಿ? ತ್ವಾಮಧಿ ಕಿಮೇತೇ ಸಾಕ್ಷ್ಯಂ ವದನ್ತಿ? ");
INSERT INTO sankan_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","ಕಿನ್ತು ಯೀಶು ರ್ಮೌನೀಭೂಯ ತಸ್ಯೌ| ತತೋ ಮಹಾಯಾಜಕ ಉಕ್ತವಾನ್, ತ್ವಾಮ್ ಅಮರೇಶ್ವರನಾಮ್ನಾ ಶಪಯಾಮಿ, ತ್ವಮೀಶ್ವರಸ್ಯ ಪುತ್ರೋಽಭಿಷಿಕ್ತೋ ಭವಸಿ ನವೇತಿ ವದ| ");
INSERT INTO sankan_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ಯೀಶುಃ ಪ್ರತ್ಯವದತ್, ತ್ವಂ ಸತ್ಯಮುಕ್ತವಾನ್; ಅಹಂ ಯುಷ್ಮಾನ್ ತಥ್ಯಂ ವದಾಮಿ, ಇತಃಪರಂ ಮನುಜಸುತಂ ಸರ್ವ್ವಶಕ್ತಿಮತೋ ದಕ್ಷಿಣಪಾರ್ಶ್ವೇ ಸ್ಥಾತುಂ ಗಗಣಸ್ಥಂ ಜಲಧರಾನಾರುಹ್ಯಾಯಾನ್ತಂ ವೀಕ್ಷಧ್ವೇ| ");
INSERT INTO sankan_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ತದಾ ಮಹಾಯಾಜಕೋ ನಿಜವಸನಂ ಛಿತ್ತ್ವಾ ಜಗಾದ, ಏಷ ಈಶ್ವರಂ ನಿನ್ದಿತವಾನ್, ಅಸ್ಮಾಕಮಪರಸಾಕ್ಷ್ಯೇಣ ಕಿಂ ಪ್ರಯೋಜನಂ? ಪಶ್ಯತ, ಯೂಯಮೇವಾಸ್ಯಾಸ್ಯಾದ್ ಈಶ್ವರನಿನ್ದಾಂ ಶ್ರುತವನ್ತಃ, ");
INSERT INTO sankan_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","ಯುಷ್ಮಾಭಿಃ ಕಿಂ ವಿವಿಚ್ಯತೇ? ತೇ ಪ್ರತ್ಯೂಚುಃ, ವಧಾರ್ಹೋಽಯಂ| ");
INSERT INTO sankan_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ತತೋ ಲೋಕೈಸ್ತದಾಸ್ಯೇ ನಿಷ್ಠೀವಿತಂ ಕೇಚಿತ್ ಪ್ರತಲಮಾಹತ್ಯ ಕೇಚಿಚ್ಚ ಚಪೇಟಮಾಹತ್ಯ ಬಭಾಷಿರೇ, ");
INSERT INTO sankan_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ಹೇ ಖ್ರೀಷ್ಟ ತ್ವಾಂ ಕಶ್ಚಪೇಟಮಾಹತವಾನ್? ಇತಿ ಗಣಯಿತ್ವಾ ವದಾಸ್ಮಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ಪಿತರೋ ಬಹಿರಙ್ಗನ ಉಪವಿಶತಿ, ತದಾನೀಮೇಕಾ ದಾಸೀ ತಮುಪಾಗತ್ಯ ಬಭಾಷೇ, ತ್ವಂ ಗಾಲೀಲೀಯಯೀಶೋಃ ಸಹಚರಏಕಃ| ");
INSERT INTO sankan_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","ಕಿನ್ತು ಸ ಸರ್ವ್ವೇಷಾಂ ಸಮಕ್ಷಮ್ ಅನಙ್ಗೀಕೃತ್ಯಾವಾದೀತ್, ತ್ವಯಾ ಯದುಚ್ಯತೇ, ತದರ್ಥಮಹಂ ನ ವೇದ್ಮಿ| ");
INSERT INTO sankan_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ತದಾ ತಸ್ಮಿನ್ ಬಹಿರ್ದ್ವಾರಂ ಗತೇ ಽನ್ಯಾ ದಾಸೀ ತಂ ನಿರೀಕ್ಷ್ಯ ತತ್ರತ್ಯಜನಾನವದತ್, ಅಯಮಪಿ ನಾಸರತೀಯಯೀಶುನಾ ಸಾರ್ದ್ಧಮ್ ಆಸೀತ್| ");
INSERT INTO sankan_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ತತಃ ಸ ಶಪಥೇನ ಪುನರನಙ್ಗೀಕೃತ್ಯ ಕಥಿತವಾನ್, ತಂ ನರಂ ನ ಪರಿಚಿನೋಮಿ| ");
INSERT INTO sankan_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ಕ್ಷಣಾತ್ ಪರಂ ತಿಷ್ಠನ್ತೋ ಜನಾ ಏತ್ಯ ಪಿತರಮ್ ಅವದನ್, ತ್ವಮವಶ್ಯಂ ತೇಷಾಮೇಕ ಇತಿ ತ್ವದುಚ್ಚಾರಣಮೇವ ದ್ಯೋತಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","ಕಿನ್ತು ಸೋಽಭಿಶಪ್ಯ ಕಥಿತವಾನ್, ತಂ ಜನಂ ನಾಹಂ ಪರಿಚಿನೋಮಿ, ತದಾ ಸಪದಿ ಕುಕ್ಕುಟೋ ರುರಾವ| ");
INSERT INTO sankan_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ಕುಕ್ಕುಟರವಾತ್ ಪ್ರಾಕ್ ತ್ವಂ ಮಾಂ ತ್ರಿರಪಾಹ್ನೋಷ್ಯಸೇ, ಯೈಷಾ ವಾಗ್ ಯೀಶುನಾವಾದಿ ತಾಂ ಪಿತರಃ ಸಂಸ್ಮೃತ್ಯ ಬಹಿರಿತ್ವಾ ಖೇದಾದ್ ಭೃಶಂ ಚಕ್ರನ್ದ| ");
INSERT INTO sankan_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ಪ್ರಭಾತೇ ಜಾತೇ ಪ್ರಧಾನಯಾಜಕಲೋಕಪ್ರಾಚೀನಾ ಯೀಶುಂ ಹನ್ತುಂ ತತ್ಪ್ರತಿಕೂಲಂ ಮನ್ತ್ರಯಿತ್ವಾ ");
INSERT INTO sankan_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ತಂ ಬದ್ವ್ವಾ ನೀತ್ವಾ ಪನ್ತೀಯಪೀಲಾತಾಖ್ಯಾಧಿಪೇ ಸಮರ್ಪಯಾಮಾಸುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","ತತೋ ಯೀಶೋಃ ಪರಕರೇವ್ವರ್ಪಯಿತಾ ಯಿಹೂದಾಸ್ತತ್ಪ್ರಾಣಾದಣ್ಡಾಜ್ಞಾಂ ವಿದಿತ್ವಾ ಸನ್ತಪ್ತಮನಾಃ ಪ್ರಧಾನಯಾಜಕಲೋಕಪ್ರಾಚೀನಾನಾಂ ಸಮಕ್ಷಂ ತಾಸ್ತ್ರೀಂಶನ್ಮುದ್ರಾಃ ಪ್ರತಿದಾಯಾವಾದೀತ್, ");
INSERT INTO sankan_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ಏತನ್ನಿರಾಗೋನರಪ್ರಾಣಪರಕರಾರ್ಪಣಾತ್ ಕಲುಷಂ ಕೃತವಾನಹಂ| ತದಾ ತ ಉದಿತವನ್ತಃ, ತೇನಾಸ್ಮಾಕಂ ಕಿಂ? ತ್ವಯಾ ತದ್ ಬುಧ್ಯತಾಮ್| ");
INSERT INTO sankan_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ತತೋ ಯಿಹೂದಾ ಮನ್ದಿರಮಧ್ಯೇ ತಾ ಮುದ್ರಾ ನಿಕ್ಷಿಪ್ಯ ಪ್ರಸ್ಥಿತವಾನ್ ಇತ್ವಾ ಚ ಸ್ವಯಮಾತ್ಮಾನಮುದ್ಬಬನ್ಧ| ");
INSERT INTO sankan_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","ಪಶ್ಚಾತ್ ಪ್ರಧಾನಯಾಜಕಾಸ್ತಾ ಮುದ್ರಾ ಆದಾಯ ಕಥಿತವನ್ತಃ, ಏತಾ ಮುದ್ರಾಃ ಶೋಣಿತಮೂಲ್ಯಂ ತಸ್ಮಾದ್ ಭಾಣ್ಡಾಗಾರೇ ನ ನಿಧಾತವ್ಯಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ಅನನ್ತರಂ ತೇ ಮನ್ತ್ರಯಿತ್ವಾ ವಿದೇಶಿನಾಂ ಶ್ಮಶಾನಸ್ಥಾನಾಯ ತಾಭಿಃ ಕುಲಾಲಸ್ಯ ಕ್ಷೇತ್ರಮಕ್ರೀಣನ್| ");
INSERT INTO sankan_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ಅತೋಽದ್ಯಾಪಿ ತತ್ಸ್ಥಾನಂ ರಕ್ತಕ್ಷೇತ್ರಂ ವದನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ಇತ್ಥಂ ಸತಿ ಇಸ್ರಾಯೇಲೀಯಸನ್ತಾನೈ ರ್ಯಸ್ಯ ಮೂಲ್ಯಂ ನಿರುಪಿತಂ, ತಸ್ಯ ತ್ರಿಂಶನ್ಮುದ್ರಾಮಾನಂ ಮೂಲ್ಯಂ ");
INSERT INTO sankan_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ಮಾಂ ಪ್ರತಿ ಪರಮೇಶ್ವರಸ್ಯಾದೇಶಾತ್ ತೇಭ್ಯ ಆದೀಯತ, ತೇನ ಚ ಕುಲಾಲಸ್ಯ ಕ್ಷೇತ್ರಂ ಕ್ರೀತಮಿತಿ ಯದ್ವಚನಂ ಯಿರಿಮಿಯಭವಿಷ್ಯದ್ವಾದಿನಾ ಪ್ರೋಕ್ತಂ ತತ್ ತದಾಸಿಧ್ಯತ್| ");
INSERT INTO sankan_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ಅನನ್ತರಂ ಯೀಶೌ ತದಧಿಪತೇಃ ಸಮ್ಮುಖ ಉಪತಿಷ್ಠತಿ ಸ ತಂ ಪಪ್ರಚ್ಛ, ತ್ವಂ ಕಿಂ ಯಿಹೂದೀಯಾನಾಂ ರಾಜಾ? ತದಾ ಯೀಶುಸ್ತಮವದತ್, ತ್ವಂ ಸತ್ಯಮುಕ್ತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","ಕಿನ್ತು ಪ್ರಧಾನಯಾಜಕಪ್ರಾಚೀನೈರಭಿಯುಕ್ತೇನ ತೇನ ಕಿಮಪಿ ನ ಪ್ರತ್ಯವಾದಿ| ");
INSERT INTO sankan_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","ತತಃ ಪೀಲಾತೇನ ಸ ಉದಿತಃ, ಇಮೇ ತ್ವತ್ಪ್ರತಿಕೂಲತಃ ಕತಿ ಕತಿ ಸಾಕ್ಷ್ಯಂ ದದತಿ, ತತ್ ತ್ವಂ ನ ಶೃಣೋಷಿ? ");
INSERT INTO sankan_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","ತಥಾಪಿ ಸ ತೇಷಾಮೇಕಸ್ಯಾಪಿ ವಚಸ ಉತ್ತರಂ ನೋದಿತವಾನ್; ತೇನ ಸೋಽಧಿಪತಿ ರ್ಮಹಾಚಿತ್ರಂ ವಿದಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","ಅನ್ಯಚ್ಚ ತನ್ಮಹಕಾಲೇಽಧಿಪತೇರೇತಾದೃಶೀ ರಾತಿರಾಸೀತ್, ಪ್ರಜಾ ಯಂ ಕಞ್ಚನ ಬನ್ಧಿನಂ ಯಾಚನ್ತೇ, ತಮೇವ ಸ ಮೋಚಯತೀತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ತದಾನೀಂ ಬರಬ್ಬಾನಾಮಾ ಕಶ್ಚಿತ್ ಖ್ಯಾತಬನ್ಧ್ಯಾಸೀತ್| ");
INSERT INTO sankan_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ತತಃ ಪೀಲಾತಸ್ತತ್ರ ಮಿಲಿತಾನ್ ಲೋಕಾನ್ ಅಪೃಚ್ಛತ್, ಏಷ ಬರಬ್ಬಾ ಬನ್ಧೀ ಖ್ರೀಷ್ಟವಿಖ್ಯಾತೋ ಯೀಶುಶ್ಚೈತಯೋಃ ಕಂ ಮೋಚಯಿಷ್ಯಾಮಿ? ಯುಷ್ಮಾಕಂ ಕಿಮೀಪ್ಸಿತಂ? ");
INSERT INTO sankan_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","ತೈರೀರ್ಷ್ಯಯಾ ಸ ಸಮರ್ಪಿತ ಇತಿ ಸ ಜ್ಞಾತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ಅಪರಂ ವಿಚಾರಾಸನೋಪವೇಶನಕಾಲೇ ಪೀಲಾತಸ್ಯ ಪತ್ನೀ ಭೃತ್ಯಂ ಪ್ರಹಿತ್ಯ ತಸ್ಮೈ ಕಥಯಾಮಾಸ, ತಂ ಧಾರ್ಮ್ಮಿಕಮನುಜಂ ಪ್ರತಿ ತ್ವಯಾ ಕಿಮಪಿ ನ ಕರ್ತ್ತವ್ಯಂ; ಯಸ್ಮಾತ್ ತತ್ಕೃತೇಽದ್ಯಾಹಂ ಸ್ವಪ್ನೇ ಪ್ರಭೂತಕಷ್ಟಮಲಭೇ| ");
INSERT INTO sankan_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","ಅನನ್ತರಂ ಪ್ರಧಾನಯಾಜಕಪ್ರಾಚೀನಾ ಬರಬ್ಬಾಂ ಯಾಚಿತ್ವಾದಾತುಂ ಯೀಶುಞ್ಚ ಹನ್ತುಂ ಸಕಲಲೋಕಾನ್ ಪ್ರಾವರ್ತ್ತಯನ್| ");
INSERT INTO sankan_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ತತೋಽಧಿಪತಿಸ್ತಾನ್ ಪೃಷ್ಟವಾನ್, ಏತಯೋಃ ಕಮಹಂ ಮೋಚಯಿಷ್ಯಾಮಿ? ಯುಷ್ಮಾಕಂ ಕೇಚ್ಛಾ? ತೇ ಪ್ರೋಚು ರ್ಬರಬ್ಬಾಂ| ");
INSERT INTO sankan_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ತದಾ ಪೀಲಾತಃ ಪಪ್ರಚ್ಛ, ತರ್ಹಿ ಯಂ ಖ್ರೀಷ್ಟಂ ವದನ್ತಿ, ತಂ ಯೀಶುಂ ಕಿಂ ಕರಿಷ್ಯಾಮಿ? ಸರ್ವ್ವೇ ಕಥಯಾಮಾಸುಃ, ಸ ಕ್ರುಶೇನ ವಿಧ್ಯತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ತತೋಽಧಿಪತಿರವಾದೀತ್, ಕುತಃ? ಕಿಂ ತೇನಾಪರಾದ್ಧಂ? ಕಿನ್ತು ತೇ ಪುನರುಚೈ ರ್ಜಗದುಃ, ಸ ಕ್ರುಶೇನ ವಿಧ್ಯತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ತದಾ ನಿಜವಾಕ್ಯಮಗ್ರಾಹ್ಯಮಭೂತ್, ಕಲಹಶ್ಚಾಪ್ಯಭೂತ್, ಪೀಲಾತ ಇತಿ ವಿಲೋಕ್ಯ ಲೋಕಾನಾಂ ಸಮಕ್ಷಂ ತೋಯಮಾದಾಯ ಕರೌ ಪ್ರಕ್ಷಾಲ್ಯಾವೋಚತ್, ಏತಸ್ಯ ಧಾರ್ಮ್ಮಿಕಮನುಷ್ಯಸ್ಯ ಶೋಣಿತಪಾತೇ ನಿರ್ದೋಷೋಽಹಂ, ಯುಷ್ಮಾಭಿರೇವ ತದ್ ಬುಧ್ಯತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ತದಾ ಸರ್ವ್ವಾಃ ಪ್ರಜಾಃ ಪ್ರತ್ಯವೋಚನ್, ತಸ್ಯ ಶೋಣಿತಪಾತಾಪರಾಧೋಽಸ್ಮಾಕಮ್ ಅಸ್ಮತ್ಸನ್ತಾನಾನಾಞ್ಚೋಪರಿ ಭವತು| ");
INSERT INTO sankan_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","ತತಃ ಸ ತೇಷಾಂ ಸಮೀಪೇ ಬರಬ್ಬಾಂ ಮೋಚಯಾಮಾಸ ಯೀಶುನ್ತು ಕಷಾಭಿರಾಹತ್ಯ ಕ್ರುಶೇನ ವೇಧಿತುಂ ಸಮರ್ಪಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","ಅನನ್ತರಮ್ ಅಧಿಪತೇಃ ಸೇನಾ ಅಧಿಪತೇ ರ್ಗೃಹಂ ಯೀಶುಮಾನೀಯ ತಸ್ಯ ಸಮೀಪೇ ಸೇನಾಸಮೂಹಂ ಸಂಜಗೃಹುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ತತಸ್ತೇ ತಸ್ಯ ವಸನಂ ಮೋಚಯಿತ್ವಾ ಕೃಷ್ಣಲೋಹಿತವರ್ಣವಸನಂ ಪರಿಧಾಪಯಾಮಾಸುಃ ");
INSERT INTO sankan_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ಕಣ್ಟಕಾನಾಂ ಮುಕುಟಂ ನಿರ್ಮ್ಮಾಯ ತಚ್ಛಿರಸಿ ದದುಃ, ತಸ್ಯ ದಕ್ಷಿಣಕರೇ ವೇತ್ರಮೇಕಂ ದತ್ತ್ವಾ ತಸ್ಯ ಸಮ್ಮುಖೇ ಜಾನೂನಿ ಪಾತಯಿತ್ವಾ, ಹೇ ಯಿಹೂದೀಯಾನಾಂ ರಾಜನ್, ತುಭ್ಯಂ ನಮ ಇತ್ಯುಕ್ತ್ವಾ ತಂ ತಿರಶ್ಚಕ್ರುಃ, ");
INSERT INTO sankan_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ತತಸ್ತಸ್ಯ ಗಾತ್ರೇ ನಿಷ್ಠೀವಂ ದತ್ವಾ ತೇನ ವೇತ್ರೇಣ ಶಿರ ಆಜಘ್ನುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ಇತ್ಥಂ ತಂ ತಿರಸ್ಕೃತ್ಯ ತದ್ ವಸನಂ ಮೋಚಯಿತ್ವಾ ಪುನರ್ನಿಜವಸನಂ ಪರಿಧಾಪಯಾಞ್ಚಕ್ರುಃ, ತಂ ಕ್ರುಶೇನ ವೇಧಿತುಂ ನೀತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ಪಶ್ಚಾತ್ತೇ ಬಹಿರ್ಭೂಯ ಕುರೀಣೀಯಂ ಶಿಮೋನ್ನಾಮಕಮೇಕಂ ವಿಲೋಕ್ಯ ಕ್ರುಶಂ ವೋಢುಂ ತಮಾದದಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ಅನನ್ತರಂ ಗುಲ್ಗಲ್ತಾಮ್ ಅರ್ಥಾತ್ ಶಿರಸ್ಕಪಾಲನಾಮಕಸ್ಥಾನಮು ಪಸ್ಥಾಯ ತೇ ಯೀಶವೇ ಪಿತ್ತಮಿಶ್ರಿತಾಮ್ಲರಸಂ ಪಾತುಂ ದದುಃ, ");
INSERT INTO sankan_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ಕಿನ್ತು ಸ ತಮಾಸ್ವಾದ್ಯ ನ ಪಪೌ| ");
INSERT INTO sankan_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ತದಾನೀಂ ತೇ ತಂ ಕ್ರುಶೇನ ಸಂವಿಧ್ಯ ತಸ್ಯ ವಸನಾನಿ ಗುಟಿಕಾಪಾತೇನ ವಿಭಜ್ಯ ಜಗೃಹುಃ, ತಸ್ಮಾತ್, ವಿಭಜನ್ತೇಽಧರೀಯಂ ಮೇ ತೇ ಮನುಷ್ಯಾಃ ಪರಸ್ಪರಂ| ಮದುತ್ತರೀಯವಸ್ತ್ರಾರ್ಥಂ ಗುಟಿಕಾಂ ಪಾತಯನ್ತಿ ಚ|| ಯದೇತದ್ವಚನಂ ಭವಿಷ್ಯದ್ವಾದಿಭಿರುಕ್ತಮಾಸೀತ್, ತದಾ ತದ್ ಅಸಿಧ್ಯತ್, ");
INSERT INTO sankan_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ಪಶ್ಚಾತ್ ತೇ ತತ್ರೋಪವಿಶ್ಯ ತದ್ರಕ್ಷಣಕರ್ವ್ವಣಿ ನಿಯುಕ್ತಾಸ್ತಸ್ಥುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ಅಪರಮ್ ಏಷ ಯಿಹೂದೀಯಾನಾಂ ರಾಜಾ ಯೀಶುರಿತ್ಯಪವಾದಲಿಪಿಪತ್ರಂ ತಚ್ಛಿರಸ ಊರ್ದ್ವ್ವೇ ಯೋಜಯಾಮಾಸುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ತತಸ್ತಸ್ಯ ವಾಮೇ ದಕ್ಷಿಣೇ ಚ ದ್ವೌ ಚೈರೌ ತೇನ ಸಾಕಂ ಕ್ರುಶೇನ ವಿವಿಧುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","ತದಾ ಪಾನ್ಥಾ ನಿಜಶಿರೋ ಲಾಡಯಿತ್ವಾ ತಂ ನಿನ್ದನ್ತೋ ಜಗದುಃ, ");
INSERT INTO sankan_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ಹೇ ಈಶ್ವರಮನ್ದಿರಭಞ್ಜಕ ದಿನತ್ರಯೇ ತನ್ನಿರ್ಮ್ಮಾತಃ ಸ್ವಂ ರಕ್ಷ, ಚೇತ್ತ್ವಮೀಶ್ವರಸುತಸ್ತರ್ಹಿ ಕ್ರುಶಾದವರೋಹ| ");
INSERT INTO sankan_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ಪ್ರಧಾನಯಾಜಕಾಧ್ಯಾಪಕಪ್ರಾಚೀನಾಶ್ಚ ತಥಾ ತಿರಸ್ಕೃತ್ಯ ಜಗದುಃ, ");
INSERT INTO sankan_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","ಸೋಽನ್ಯಜನಾನಾವತ್, ಕಿನ್ತು ಸ್ವಮವಿತುಂ ನ ಶಕ್ನೋತಿ| ಯದೀಸ್ರಾಯೇಲೋ ರಾಜಾ ಭವೇತ್, ತರ್ಹೀದಾನೀಮೇವ ಕ್ರುಶಾದವರೋಹತು, ತೇನ ತಂ ವಯಂ ಪ್ರತ್ಯೇಷ್ಯಾಮಃ| ");
INSERT INTO sankan_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ಸ ಈಶ್ವರೇ ಪ್ರತ್ಯಾಶಾಮಕರೋತ್, ಯದೀಶ್ವರಸ್ತಸ್ಮಿನ್ ಸನ್ತುಷ್ಟಸ್ತರ್ಹೀದಾನೀಮೇವ ತಮವೇತ್, ಯತಃ ಸ ಉಕ್ತವಾನ್ ಅಹಮೀಶ್ವರಸುತಃ| ");
INSERT INTO sankan_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ಯೌ ಸ್ತೇನೌ ಸಾಕಂ ತೇನ ಕ್ರುಶೇನ ವಿದ್ಧೌ ತೌ ತದ್ವದೇವ ತಂ ನಿನಿನ್ದತುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","ತದಾ ದ್ವಿತೀಯಯಾಮಾತ್ ತೃತೀಯಯಾಮಂ ಯಾವತ್ ಸರ್ವ್ವದೇಶೇ ತಮಿರಂ ಬಭೂವ, ");
INSERT INTO sankan_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ತೃತೀಯಯಾಮೇ \"ಏಲೀ ಏಲೀ ಲಾಮಾ ಶಿವಕ್ತನೀ\", ಅರ್ಥಾತ್ ಮದೀಶ್ವರ ಮದೀಶ್ವರ ಕುತೋ ಮಾಮತ್ಯಾಕ್ಷೀಃ? ಯೀಶುರುಚ್ಚೈರಿತಿ ಜಗಾದ| ");
INSERT INTO sankan_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ತದಾ ತತ್ರ ಸ್ಥಿತಾಃ ಕೇಚಿತ್ ತತ್ ಶ್ರುತ್ವಾ ಬಭಾಷಿರೇ, ಅಯಮ್ ಏಲಿಯಮಾಹೂಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ತೇಷಾಂ ಮಧ್ಯಾದ್ ಏಕಃ ಶೀಘ್ರಂ ಗತ್ವಾ ಸ್ಪಞ್ಜಂ ಗೃಹೀತ್ವಾ ತತ್ರಾಮ್ಲರಸಂ ದತ್ತ್ವಾ ನಲೇನ ಪಾತುಂ ತಸ್ಮೈ ದದೌ| ");
INSERT INTO sankan_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ಇತರೇಽಕಥಯನ್ ತಿಷ್ಠತ, ತಂ ರಕ್ಷಿತುಮ್ ಏಲಿಯ ಆಯಾತಿ ನವೇತಿ ಪಶ್ಯಾಮಃ| ");
INSERT INTO sankan_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","ಯೀಶುಃ ಪುನರುಚೈರಾಹೂಯ ಪ್ರಾಣಾನ್ ಜಹೌ| ");
INSERT INTO sankan_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","ತತೋ ಮನ್ದಿರಸ್ಯ ವಿಚ್ಛೇದವಸನಮ್ ಊರ್ದ್ವ್ವಾದಧೋ ಯಾವತ್ ಛಿದ್ಯಮಾನಂ ದ್ವಿಧಾಭವತ್, ");
INSERT INTO sankan_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ಭೂಮಿಶ್ಚಕಮ್ಪೇ ಭೂಧರೋವ್ಯದೀರ್ಯ್ಯತ ಚ| ಶ್ಮಶಾನೇ ಮುಕ್ತೇ ಭೂರಿಪುಣ್ಯವತಾಂ ಸುಪ್ತದೇಹಾ ಉದತಿಷ್ಠನ್, ");
INSERT INTO sankan_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ಶ್ಮಶಾನಾದ್ ವಹಿರ್ಭೂಯ ತದುತ್ಥಾನಾತ್ ಪರಂ ಪುಣ್ಯಪುರಂ ಗತ್ವಾ ಬಹುಜನಾನ್ ದರ್ಶಯಾಮಾಸುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ಯೀಶುರಕ್ಷಣಾಯ ನಿಯುಕ್ತಃ ಶತಸೇನಾಪತಿಸ್ತತ್ಸಙ್ಗಿನಶ್ಚ ತಾದೃಶೀಂ ಭೂಕಮ್ಪಾದಿಘಟನಾಂ ದೃಷ್ಟ್ವಾ ಭೀತಾ ಅವದನ್, ಏಷ ಈಶ್ವರಪುತ್ರೋ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ಯಾ ಬಹುಯೋಷಿತೋ ಯೀಶುಂ ಸೇವಮಾನಾ ಗಾಲೀಲಸ್ತತ್ಪಶ್ಚಾದಾಗತಾಸ್ತಾಸಾಂ ಮಧ್ಯೇ ");
INSERT INTO sankan_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ಮಗ್ದಲೀನೀ ಮರಿಯಮ್ ಯಾಕೂಬ್ಯೋಶ್ಯೋ ರ್ಮಾತಾ ಯಾ ಮರಿಯಮ್ ಸಿಬದಿಯಪುತ್ರಯೋ ರ್ಮಾತಾ ಚ ಯೋಷಿತ ಏತಾ ದೂರೇ ತಿಷ್ಠನ್ತ್ಯೋ ದದೃಶುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","ಸನ್ಧ್ಯಾಯಾಂ ಸತ್ಯಮ್ ಅರಿಮಥಿಯಾನಗರಸ್ಯ ಯೂಷಫ್ನಾಮಾ ಧನೀ ಮನುಜೋ ಯೀಶೋಃ ಶಿಷ್ಯತ್ವಾತ್ ");
INSERT INTO sankan_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ಪೀಲಾತಸ್ಯ ಸಮೀಪಂ ಗತ್ವಾ ಯೀಶೋಃ ಕಾಯಂ ಯಯಾಚೇ, ತೇನ ಪೀಲಾತಃ ಕಾಯಂ ದಾತುಮ್ ಆದಿದೇಶ| ");
INSERT INTO sankan_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ಯೂಷಫ್ ತತ್ಕಾಯಂ ನೀತ್ವಾ ಶುಚಿವಸ್ತ್ರೇಣಾಚ್ಛಾದ್ಯ ");
INSERT INTO sankan_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ಸ್ವಾರ್ಥಂ ಶೈಲೇ ಯತ್ ಶ್ಮಶಾನಂ ಚಖಾನ, ತನ್ಮಧ್ಯೇ ತತ್ಕಾಯಂ ನಿಧಾಯ ತಸ್ಯ ದ್ವಾರಿ ವೃಹತ್ಪಾಷಾಣಂ ದದೌ| ");
INSERT INTO sankan_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","ಕಿನ್ತು ಮಗ್ದಲೀನೀ ಮರಿಯಮ್ ಅನ್ಯಮರಿಯಮ್ ಏತೇ ಸ್ತ್ರಿಯೌ ತತ್ರ ಶ್ಮಶಾನಸಮ್ಮುಖ ಉಪವಿವಿಶತುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","ತದನನ್ತರಂ ನಿಸ್ತಾರೋತ್ಸವಸ್ಯಾಯೋಜನದಿನಾತ್ ಪರೇಽಹನಿ ಪ್ರಧಾನಯಾಜಕಾಃ ಫಿರೂಶಿನಶ್ಚ ಮಿಲಿತ್ವಾ ಪೀಲಾತಮುಪಾಗತ್ಯಾಕಥಯನ್, ");
INSERT INTO sankan_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ಹೇ ಮಹೇಚ್ಛ ಸ ಪ್ರತಾರಕೋ ಜೀವನ ಅಕಥಯತ್, ದಿನತ್ರಯಾತ್ ಪರಂ ಶ್ಮಶಾನಾದುತ್ಥಾಸ್ಯಾಮಿ ತದ್ವಾಕ್ಯಂ ಸ್ಮರಾಮೋ ವಯಂ; ");
INSERT INTO sankan_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ತಸ್ಮಾತ್ ತೃತೀಯದಿನಂ ಯಾವತ್ ತತ್ ಶ್ಮಶಾನಂ ರಕ್ಷಿತುಮಾದಿಶತು, ನೋಚೇತ್ ತಚ್ಛಿಷ್ಯಾ ಯಾಮಿನ್ಯಾಮಾಗತ್ಯ ತಂ ಹೃತ್ವಾ ಲೋಕಾನ್ ವದಿಷ್ಯನ್ತಿ, ಸ ಶ್ಮಶಾನಾದುದತಿಷ್ಠತ್, ತಥಾ ಸತಿ ಪ್ರಥಮಭ್ರಾನ್ತೇಃ ಶೇಷೀಯಭ್ರಾನ್ತಿ ರ್ಮಹತೀ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ತದಾ ಪೀಲಾತ ಅವಾದೀತ್, ಯುಷ್ಮಾಕಂ ಸಮೀಪೇ ರಕ್ಷಿಗಣ ಆಸ್ತೇ, ಯೂಯಂ ಗತ್ವಾ ಯಥಾ ಸಾಧ್ಯಂ ರಕ್ಷಯತ| ");
INSERT INTO sankan_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ತತಸ್ತೇ ಗತ್ವಾ ತದ್ದೂाರಪಾಷಾಣಂ ಮುದ್ರಾಙ್ಕಿತಂ ಕೃತ್ವಾ ರಕ್ಷಿಗಣಂ ನಿಯೋಜ್ಯ ಶ್ಮಶಾನಂ ರಕ್ಷಯಾಮಾಸುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ತತಃ ಪರಂ ವಿಶ್ರಾಮವಾರಸ್ಯ ಶೇಷೇ ಸಪ್ತಾಹಪ್ರಥಮದಿನಸ್ಯ ಪ್ರಭೋತೇ ಜಾತೇ ಮಗ್ದಲೀನೀ ಮರಿಯಮ್ ಅನ್ಯಮರಿಯಮ್ ಚ ಶ್ಮಶಾನಂ ದ್ರಷ್ಟುಮಾಗತಾ| ");
INSERT INTO sankan_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ತದಾ ಮಹಾನ್ ಭೂಕಮ್ಪೋಽಭವತ್; ಪರಮೇಶ್ವರೀಯದೂತಃ ಸ್ವರ್ಗಾದವರುಹ್ಯ ಶ್ಮಶಾನದ್ವಾರಾತ್ ಪಾಷಾಣಮಪಸಾರ್ಯ್ಯ ತದುಪರ್ಯ್ಯುಪವಿವೇಶ| ");
INSERT INTO sankan_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ತದ್ವದನಂ ವಿದ್ಯುದ್ವತ್ ತೇಜೋಮಯಂ ವಸನಂ ಹಿಮಶುಭ್ರಞ್ಚ| ");
INSERT INTO sankan_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ತದಾನೀಂ ರಕ್ಷಿಣಸ್ತದ್ಭಯಾತ್ ಕಮ್ಪಿತಾ ಮೃತವದ್ ಬಭೂವಃ| ");
INSERT INTO sankan_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ಸ ದೂತೋ ಯೋಷಿತೋ ಜಗಾದ, ಯೂಯಂ ಮಾ ಭೈಷ್ಟ, ಕ್ರುಶಹತಯೀಶುಂ ಮೃಗಯಧ್ವೇ ತದಹಂ ವೇದ್ಮಿ| ");
INSERT INTO sankan_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ಸೋಽತ್ರ ನಾಸ್ತಿ, ಯಥಾವದತ್ ತಥೋತ್ಥಿತವಾನ್; ಏತತ್ ಪ್ರಭೋಃ ಶಯನಸ್ಥಾನಂ ಪಶ್ಯತ| ");
INSERT INTO sankan_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ತೂರ್ಣಂ ಗತ್ವಾ ತಚ್ಛಿಷ್ಯಾನ್ ಇತಿ ವದತ, ಸ ಶ್ಮಶಾನಾದ್ ಉದತಿಷ್ಠತ್, ಯುಷ್ಮಾಕಮಗ್ರೇ ಗಾಲೀಲಂ ಯಾಸ್ಯತಿ ಯೂಯಂ ತತ್ರ ತಂ ವೀಕ್ಷಿಷ್ಯಧ್ವೇ, ಪಶ್ಯತಾಹಂ ವಾರ್ತ್ತಾಮಿಮಾಂ ಯುಷ್ಮಾನವಾದಿಷಂ| ");
INSERT INTO sankan_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ತತಸ್ತಾ ಭಯಾತ್ ಮಹಾನನ್ದಾಞ್ಚ ಶ್ಮಶಾನಾತ್ ತೂರ್ಣಂ ಬಹಿರ್ಭೂಯ ತಚ್ಛಿಷ್ಯಾನ್ ವಾರ್ತ್ತಾಂ ವಕ್ತುಂ ಧಾವಿತವತ್ಯಃ| ಕಿನ್ತು ಶಿಷ್ಯಾನ್ ವಾರ್ತ್ತಾಂ ವಕ್ತುಂ ಯಾನ್ತಿ, ತದಾ ಯೀಶು ರ್ದರ್ಶನಂ ದತ್ತ್ವಾ ತಾ ಜಗಾದ, ");
INSERT INTO sankan_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ಯುಷ್ಮಾಕಂ ಕಲ್ಯಾಣಂ ಭೂಯಾತ್, ತತಸ್ತಾ ಆಗತ್ಯ ತತ್ಪಾದಯೋಃ ಪತಿತ್ವಾ ಪ್ರಣೇಮುಃ| ");
INSERT INTO sankan_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","ಯೀಶುಸ್ತಾ ಅವಾದೀತ್, ಮಾ ಬಿಭೀತ, ಯೂಯಂ ಗತ್ವಾ ಮಮ ಭ್ರಾತೃನ್ ಗಾಲೀಲಂ ಯಾತುಂ ವದತ, ತತ್ರ ತೇ ಮಾಂ ದ್ರಕ್ಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","ಸ್ತ್ರಿಯೋ ಗಚ್ಛನ್ತಿ, ತದಾ ರಕ್ಷಿಣಾಂ ಕೇಚಿತ್ ಪುರಂ ಗತ್ವಾ ಯದ್ಯದ್ ಘಟಿತಂ ತತ್ಸರ್ವ್ವಂ ಪ್ರಧಾನಯಾಜಕಾನ್ ಜ್ಞಾಪಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ತೇ ಪ್ರಾಚೀನೈಃ ಸಮಂ ಸಂಸದಂ ಕೃತ್ವಾ ಮನ್ತ್ರಯನ್ತೋ ಬಹುಮುದ್ರಾಃ ಸೇನಾಭ್ಯೋ ದತ್ತ್ವಾವದನ್, ");
INSERT INTO sankan_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ಅಸ್ಮಾಸು ನಿದ್ರಿತೇಷು ತಚ್ಛಿಷ್ಯಾ ಯಾಮಿನ್ಯಾಮಾಗತ್ಯ ತಂ ಹೃತ್ವಾನಯನ್, ಇತಿ ಯೂಯಂ ಪ್ರಚಾರಯತ| ");
INSERT INTO sankan_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ಯದ್ಯೇತದಧಿಪತೇಃ ಶ್ರೋತ್ರಗೋಚರೀಭವೇತ್, ತರ್ಹಿ ತಂ ಬೋಧಯಿತ್ವಾ ಯುಷ್ಮಾನವಿಷ್ಯಾಮಃ| ");
INSERT INTO sankan_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","ತತಸ್ತೇ ಮುದ್ರಾ ಗೃಹೀತ್ವಾ ಶಿಕ್ಷಾನುರೂಪಂ ಕರ್ಮ್ಮ ಚಕ್ರುಃ, ಯಿಹೂದೀಯಾನಾಂ ಮಧ್ಯೇ ತಸ್ಯಾದ್ಯಾಪಿ ಕಿಂವದನ್ತೀ ವಿದ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ಏಕಾದಶ ಶಿಷ್ಯಾ ಯೀಶುನಿರೂಪಿತಾಗಾಲೀಲಸ್ಯಾದ್ರಿಂ ಗತ್ವಾ ");
INSERT INTO sankan_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ತತ್ರ ತಂ ಸಂವೀಕ್ಷ್ಯ ಪ್ರಣೇಮುಃ, ಕಿನ್ತು ಕೇಚಿತ್ ಸನ್ದಿಗ್ಧವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ಯೀಶುಸ್ತೇಷಾಂ ಸಮೀಪಮಾಗತ್ಯ ವ್ಯಾಹೃತವಾನ್, ಸ್ವರ್ಗಮೇದಿನ್ಯೋಃ ಸರ್ವ್ವಾಧಿಪತಿತ್ವಭಾರೋ ಮಯ್ಯರ್ಪಿತ ಆಸ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ಅತೋ ಯೂಯಂ ಪ್ರಯಾಯ ಸರ್ವ್ವದೇಶೀಯಾನ್ ಶಿಷ್ಯಾನ್ ಕೃತ್ವಾ ಪಿತುಃ ಪುತ್ರಸ್ಯ ಪವಿತ್ರಸ್ಯಾತ್ಮನಶ್ಚ ನಾಮ್ನಾ ತಾನವಗಾಹಯತ; ಅಹಂ ಯುಷ್ಮಾನ್ ಯದ್ಯದಾದಿಶಂ ತದಪಿ ಪಾಲಯಿತುಂ ತಾನುಪಾದಿಶತ| ");
INSERT INTO sankan_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ಪಶ್ಯತ, ಜಗದನ್ತಂ ಯಾವತ್ ಸದಾಹಂ ಯುಷ್ಮಾಭಿಃ ಸಾಕಂ ತಿಷ್ಠಾಮಿ| ಇತಿ|");
INSERT INTO sankan_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ಈಶ್ವರಪುತ್ರಸ್ಯ ಯೀಶುಖ್ರೀಷ್ಟಸ್ಯ ಸುಸಂವಾದಾರಮ್ಭಃ| ");
INSERT INTO sankan_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ಭವಿಷ್ಯದ್ವಾದಿನಾಂ ಗ್ರನ್ಥೇಷು ಲಿಪಿರಿತ್ಥಮಾಸ್ತೇ, ಪಶ್ಯ ಸ್ವಕೀಯದೂತನ್ತು ತವಾಗ್ರೇ ಪ್ರೇಷಯಾಮ್ಯಹಮ್| ಗತ್ವಾ ತ್ವದೀಯಪನ್ಥಾನಂ ಸ ಹಿ ಪರಿಷ್ಕರಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","\"ಪರಮೇಶಸ್ಯ ಪನ್ಥಾನಂ ಪರಿಷ್ಕುರುತ ಸರ್ವ್ವತಃ| ತಸ್ಯ ರಾಜಪಥಞ್ಚೈವ ಸಮಾನಂ ಕುರುತಾಧುನಾ| \" ಇತ್ಯೇತತ್ ಪ್ರಾನ್ತರೇ ವಾಕ್ಯಂ ವದತಃ ಕಸ್ಯಚಿದ್ರವಃ|| ");
INSERT INTO sankan_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","ಸಏವ ಯೋಹನ್ ಪ್ರಾನ್ತರೇ ಮಜ್ಜಿತವಾನ್ ತಥಾ ಪಾಪಮಾರ್ಜನನಿಮಿತ್ತಂ ಮನೋವ್ಯಾವರ್ತ್ತಕಮಜ್ಜನಸ್ಯ ಕಥಾಞ್ಚ ಪ್ರಚಾರಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ತತೋ ಯಿಹೂದಾದೇಶಯಿರೂಶಾಲಮ್ನಗರನಿವಾಸಿನಃ ಸರ್ವ್ವೇ ಲೋಕಾ ಬಹಿ ರ್ಭೂತ್ವಾ ತಸ್ಯ ಸಮೀಪಮಾಗತ್ಯ ಸ್ವಾನಿ ಸ್ವಾನಿ ಪಾಪಾನ್ಯಙ್ಗೀಕೃತ್ಯ ಯರ್ದ್ದನನದ್ಯಾಂ ತೇನ ಮಜ್ಜಿತಾ ಬಭೂವುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ಅಸ್ಯ ಯೋಹನಃ ಪರಿಧೇಯಾನಿ ಕ್ರಮೇಲಕಲೋಮಜಾನಿ, ತಸ್ಯ ಕಟಿಬನ್ಧನಂ ಚರ್ಮ್ಮಜಾತಮ್, ತಸ್ಯ ಭಕ್ಷ್ಯಾಣಿ ಚ ಶೂಕಕೀಟಾ ವನ್ಯಮಧೂನಿ ಚಾಸನ್| ");
INSERT INTO sankan_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ಸ ಪ್ರಚಾರಯನ್ ಕಥಯಾಞ್ಚಕ್ರೇ, ಅಹಂ ನಮ್ರೀಭೂಯ ಯಸ್ಯ ಪಾದುಕಾಬನ್ಧನಂ ಮೋಚಯಿತುಮಪಿ ನ ಯೋಗ್ಯೋಸ್ಮಿ, ತಾದೃಶೋ ಮತ್ತೋ ಗುರುತರ ಏಕಃ ಪುರುಷೋ ಮತ್ಪಶ್ಚಾದಾಗಚ್ಛತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ಅಹಂ ಯುಷ್ಮಾನ್ ಜಲೇ ಮಜ್ಜಿತವಾನ್ ಕಿನ್ತು ಸ ಪವಿತ್ರ ಆತ್ಮಾನಿ ಸಂಮಜ್ಜಯಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","ಅಪರಞ್ಚ ತಸ್ಮಿನ್ನೇವ ಕಾಲೇ ಗಾಲೀಲ್ಪ್ರದೇಶಸ್ಯ ನಾಸರದ್ಗ್ರಾಮಾದ್ ಯೀಶುರಾಗತ್ಯ ಯೋಹನಾ ಯರ್ದ್ದನನದ್ಯಾಂ ಮಜ್ಜಿತೋಽಭೂತ್| ");
INSERT INTO sankan_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ಸ ಜಲಾದುತ್ಥಿತಮಾತ್ರೋ ಮೇಘದ್ವಾರಂ ಮುಕ್ತಂ ಕಪೋತವತ್ ಸ್ವಸ್ಯೋಪರಿ ಅವರೋಹನ್ತಮಾತ್ಮಾನಞ್ಚ ದೃಷ್ಟವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ತ್ವಂ ಮಮ ಪ್ರಿಯಃ ಪುತ್ರಸ್ತ್ವಯ್ಯೇವ ಮಮಮಹಾಸನ್ತೋಷ ಇಯಮಾಕಾಶೀಯಾ ವಾಣೀ ಬಭೂವ| ");
INSERT INTO sankan_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","ತಸ್ಮಿನ್ ಕಾಲೇ ಆತ್ಮಾ ತಂ ಪ್ರಾನ್ತರಮಧ್ಯಂ ನಿನಾಯ| ");
INSERT INTO sankan_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ಅಥ ಸ ಚತ್ವಾರಿಂಶದ್ದಿನಾನಿ ತಸ್ಮಿನ್ ಸ್ಥಾನೇ ವನ್ಯಪಶುಭಿಃ ಸಹ ತಿಷ್ಠನ್ ಶೈತಾನಾ ಪರೀಕ್ಷಿತಃ; ಪಶ್ಚಾತ್ ಸ್ವರ್ಗೀಯದೂತಾಸ್ತಂ ಸಿಷೇವಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","ಅನನ್ತರಂ ಯೋಹನಿ ಬನ್ಧನಾಲಯೇ ಬದ್ಧೇ ಸತಿ ಯೀಶು ರ್ಗಾಲೀಲ್ಪ್ರದೇಶಮಾಗತ್ಯ ಈಶ್ವರರಾಜ್ಯಸ್ಯ ಸುಸಂವಾದಂ ಪ್ರಚಾರಯನ್ ಕಥಯಾಮಾಸ, ");
INSERT INTO sankan_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ಕಾಲಃ ಸಮ್ಪೂರ್ಣ ಈಶ್ವರರಾಜ್ಯಞ್ಚ ಸಮೀಪಮಾಗತಂ; ಅತೋಹೇತೋ ರ್ಯೂಯಂ ಮನಾಂಸಿ ವ್ಯಾವರ್ತ್ತಯಧ್ವಂ ಸುಸಂವಾದೇ ಚ ವಿಶ್ವಾಸಿತ| ");
INSERT INTO sankan_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ತದನನ್ತರಂ ಸ ಗಾಲೀಲೀಯಸಮುದ್ರಸ್ಯ ತೀರೇ ಗಚ್ಛನ್ ಶಿಮೋನ್ ತಸ್ಯ ಭ್ರಾತಾ ಅನ್ದ್ರಿಯನಾಮಾ ಚ ಇಮೌ ದ್ವೌ ಜನೌ ಮತ್ಸ್ಯಧಾರಿಣೌ ಸಾಗರಮಧ್ಯೇ ಜಾಲಂ ಪ್ರಕ್ಷಿಪನ್ತೌ ದೃಷ್ಟ್ವಾ ತಾವವದತ್, ");
INSERT INTO sankan_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ಯುವಾಂ ಮಮ ಪಶ್ಚಾದಾಗಚ್ಛತಂ, ಯುವಾಮಹಂ ಮನುಷ್ಯಧಾರಿಣೌ ಕರಿಷ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ತತಸ್ತೌ ತತ್ಕ್ಷಣಮೇವ ಜಾಲಾನಿ ಪರಿತ್ಯಜ್ಯ ತಸ್ಯ ಪಶ್ಚಾತ್ ಜಗ್ಮತುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ತತಃ ಪರಂ ತತ್ಸ್ಥಾನಾತ್ ಕಿಞ್ಚಿದ್ ದೂರಂ ಗತ್ವಾ ಸ ಸಿವದೀಪುತ್ರಯಾಕೂಬ್ ತದ್ಭ್ರಾತೃಯೋಹನ್ ಚ ಇಮೌ ನೌಕಾಯಾಂ ಜಾಲಾನಾಂ ಜೀರ್ಣಮುದ್ಧಾರಯನ್ತೌ ದೃಷ್ಟ್ವಾ ತಾವಾಹೂಯತ್| ");
INSERT INTO sankan_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ತತಸ್ತೌ ನೌಕಾಯಾಂ ವೇತನಭುಗ್ಭಿಃ ಸಹಿತಂ ಸ್ವಪಿತರಂ ವಿಹಾಯ ತತ್ಪಶ್ಚಾದೀಯತುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ತತಃ ಪರಂ ಕಫರ್ನಾಹೂಮ್ನಾಮಕಂ ನಗರಮುಪಸ್ಥಾಯ ಸ ವಿಶ್ರಾಮದಿವಸೇ ಭಜನಗ್ರಹಂ ಪ್ರವಿಶ್ಯ ಸಮುಪದಿದೇಶ| ");
INSERT INTO sankan_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ತಸ್ಯೋಪದೇಶಾಲ್ಲೋಕಾ ಆಶ್ಚರ್ಯ್ಯಂ ಮೇನಿರೇ ಯತಃ ಸೋಧ್ಯಾಪಕಾಇವ ನೋಪದಿಶನ್ ಪ್ರಭಾವವಾನಿವ ಪ್ರೋಪದಿದೇಶ| ");
INSERT INTO sankan_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","ಅಪರಞ್ಚ ತಸ್ಮಿನ್ ಭಜನಗೃಹೇ ಅಪವಿತ್ರಭೂತೇನ ಗ್ರಸ್ತ ಏಕೋ ಮಾನುಷ ಆಸೀತ್| ಸ ಚೀತ್ಶಬ್ದಂ ಕೃತ್ವಾ ಕಥಯಾಞ್ಚಕೇ ");
INSERT INTO sankan_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ಭೋ ನಾಸರತೀಯ ಯೀಶೋ ತ್ವಮಸ್ಮಾನ್ ತ್ಯಜ, ತ್ವಯಾ ಸಹಾಸ್ಮಾಕಂ ಕಃ ಸಮ್ಬನ್ಧಃ? ತ್ವಂ ಕಿಮಸ್ಮಾನ್ ನಾಶಯಿತುಂ ಸಮಾಗತಃ? ತ್ವಮೀಶ್ವರಸ್ಯ ಪವಿತ್ರಲೋಕ ಇತ್ಯಹಂ ಜಾನಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ತದಾ ಯೀಶುಸ್ತಂ ತರ್ಜಯಿತ್ವಾ ಜಗಾದ ತೂಷ್ಣೀಂ ಭವ ಇತೋ ಬಹಿರ್ಭವ ಚ| ");
INSERT INTO sankan_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ತತಃ ಸೋಽಪವಿತ್ರಭೂತಸ್ತಂ ಸಮ್ಪೀಡ್ಯ ಅತ್ಯುಚೈಶ್ಚೀತ್ಕೃತ್ಯ ನಿರ್ಜಗಾಮ| ");
INSERT INTO sankan_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ತೇನೈವ ಸರ್ವ್ವೇ ಚಮತ್ಕೃತ್ಯ ಪರಸ್ಪರಂ ಕಥಯಾಞ್ಚಕ್ರಿರೇ, ಅಹೋ ಕಿಮಿದಂ? ಕೀದೃಶೋಽಯಂ ನವ್ಯ ಉಪದೇಶಃ? ಅನೇನ ಪ್ರಭಾವೇನಾಪವಿತ್ರಭೂತೇಷ್ವಾಜ್ಞಾಪಿತೇಷು ತೇ ತದಾಜ್ಞಾನುವರ್ತ್ತಿನೋ ಭವನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","ತದಾ ತಸ್ಯ ಯಶೋ ಗಾಲೀಲಶ್ಚತುರ್ದಿಕ್ಸ್ಥಸರ್ವ್ವದೇಶಾನ್ ವ್ಯಾಪ್ನೋತ್| ");
INSERT INTO sankan_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ಅಪರಞ್ಚ ತೇ ಭಜನಗೃಹಾದ್ ಬಹಿ ರ್ಭೂತ್ವಾ ಯಾಕೂಬ್ಯೋಹನ್ಭ್ಯಾಂ ಸಹ ಶಿಮೋನ ಆನ್ದ್ರಿಯಸ್ಯ ಚ ನಿವೇಶನಂ ಪ್ರವಿವಿಶುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ತದಾ ಪಿತರಸ್ಯ ಶ್ವಶ್ರೂರ್ಜ್ವರಪೀಡಿತಾ ಶಯ್ಯಾಯಾಮಾಸ್ತ ಇತಿ ತೇ ತಂ ಝಟಿತಿ ವಿಜ್ಞಾಪಯಾಞ್ಚಕ್ರುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ತತಃ ಸ ಆಗತ್ಯ ತಸ್ಯಾ ಹಸ್ತಂ ಧೃತ್ವಾ ತಾಮುದಸ್ಥಾಪಯತ್; ತದೈವ ತಾಂ ಜ್ವರೋಽತ್ಯಾಕ್ಷೀತ್ ತತಃ ಪರಂ ಸಾ ತಾನ್ ಸಿಷೇವೇ| ");
INSERT INTO sankan_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","ಅಥಾಸ್ತಂ ಗತೇ ರವೌ ಸನ್ಧ್ಯಾಕಾಲೇ ಸತಿ ಲೋಕಾಸ್ತತ್ಸಮೀಪಂ ಸರ್ವ್ವಾನ್ ರೋಗಿಣೋ ಭೂತಧೃತಾಂಶ್ಚ ಸಮಾನಿನ್ಯುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ಸರ್ವ್ವೇ ನಾಗರಿಕಾ ಲೋಕಾ ದ್ವಾರಿ ಸಂಮಿಲಿತಾಶ್ಚ| ");
INSERT INTO sankan_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ತತಃ ಸ ನಾನಾವಿಧರೋಗಿಣೋ ಬಹೂನ್ ಮನುಜಾನರೋಗಿಣಶ್ಚಕಾರ ತಥಾ ಬಹೂನ್ ಭೂತಾನ್ ತ್ಯಾಜಯಾಞ್ಚಕಾರ ತಾನ್ ಭೂತಾನ್ ಕಿಮಪಿ ವಾಕ್ಯಂ ವಕ್ತುಂ ನಿಷಿಷೇಧ ಚ ಯತೋಹೇತೋಸ್ತೇ ತಮಜಾನನ್| ");
INSERT INTO sankan_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","ಅಪರಞ್ಚ ಸೋಽತಿಪ್ರತ್ಯೂಷೇ ವಸ್ತುತಸ್ತು ರಾತ್ರಿಶೇಷೇ ಸಮುತ್ಥಾಯ ಬಹಿರ್ಭೂಯ ನಿರ್ಜನಂ ಸ್ಥಾನಂ ಗತ್ವಾ ತತ್ರ ಪ್ರಾರ್ಥಯಾಞ್ಚಕ್ರೇ| ");
INSERT INTO sankan_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ಅನನ್ತರಂ ಶಿಮೋನ್ ತತ್ಸಙ್ಗಿನಶ್ಚ ತಸ್ಯ ಪಶ್ಚಾದ್ ಗತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ತದುದ್ದೇಶಂ ಪ್ರಾಪ್ಯ ತಮವದನ್ ಸರ್ವ್ವೇ ಲೋಕಾಸ್ತ್ವಾಂ ಮೃಗಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","ತದಾ ಸೋಽಕಥಯತ್ ಆಗಚ್ಛತ ವಯಂ ಸಮೀಪಸ್ಥಾನಿ ನಗರಾಣಿ ಯಾಮಃ, ಯತೋಽಹಂ ತತ್ರ ಕಥಾಂ ಪ್ರಚಾರಯಿತುಂ ಬಹಿರಾಗಮಮ್| ");
INSERT INTO sankan_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","ಅಥ ಸ ತೇಷಾಂ ಗಾಲೀಲ್ಪ್ರದೇಶಸ್ಯ ಸರ್ವ್ವೇಷು ಭಜನಗೃಹೇಷು ಕಥಾಃ ಪ್ರಚಾರಯಾಞ್ಚಕ್ರೇ ಭೂತಾನತ್ಯಾಜಯಞ್ಚ| ");
INSERT INTO sankan_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ಅನನ್ತರಮೇಕಃ ಕುಷ್ಠೀ ಸಮಾಗತ್ಯ ತತ್ಸಮ್ಮುಖೇ ಜಾನುಪಾತಂ ವಿನಯಞ್ಚ ಕೃತ್ವಾ ಕಥಿತವಾನ್ ಯದಿ ಭವಾನ್ ಇಚ್ಛತಿ ತರ್ಹಿ ಮಾಂ ಪರಿಷ್ಕರ್ತ್ತುಂ ಶಕ್ನೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ತತಃ ಕೃಪಾಲು ರ್ಯೀಶುಃ ಕರೌ ಪ್ರಸಾರ್ಯ್ಯ ತಂ ಸ್ಪಷ್ಟ್ವಾ ಕಥಯಾಮಾಸ ");
INSERT INTO sankan_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ಮಮೇಚ್ಛಾ ವಿದ್ಯತೇ ತ್ವಂ ಪರಿಷ್ಕೃತೋ ಭವ| ಏತತ್ಕಥಾಯಾಃ ಕಥನಮಾತ್ರಾತ್ ಸ ಕುಷ್ಠೀ ರೋಗಾನ್ಮುಕ್ತಃ ಪರಿಷ್ಕೃತೋಽಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","ತದಾ ಸ ತಂ ವಿಸೃಜನ್ ಗಾಢಮಾದಿಶ್ಯ ಜಗಾದ ");
INSERT INTO sankan_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ಸಾವಧಾನೋ ಭವ ಕಥಾಮಿಮಾಂ ಕಮಪಿ ಮಾ ವದ; ಸ್ವಾತ್ಮಾನಂ ಯಾಜಕಂ ದರ್ಶಯ, ಲೋಕೇಭ್ಯಃ ಸ್ವಪರಿಷ್ಕೃತೇಃ ಪ್ರಮಾಣದಾನಾಯ ಮೂಸಾನಿರ್ಣೀತಂ ಯದ್ದಾನಂ ತದುತ್ಸೃಜಸ್ವ ಚ| ");
INSERT INTO sankan_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ಕಿನ್ತು ಸ ಗತ್ವಾ ತತ್ ಕರ್ಮ್ಮ ಇತ್ಥಂ ವಿಸ್ತಾರ್ಯ್ಯ ಪ್ರಚಾರಯಿತುಂ ಪ್ರಾರೇಭೇ ತೇನೈವ ಯೀಶುಃ ಪುನಃ ಸಪ್ರಕಾಶಂ ನಗರಂ ಪ್ರವೇಷ್ಟುಂ ನಾಶಕ್ನೋತ್ ತತೋಹೇತೋರ್ಬಹಿಃ ಕಾನನಸ್ಥಾನೇ ತಸ್ಯೌ; ತಥಾಪಿ ಚತುರ್ದ್ದಿಗ್ಭ್ಯೋ ಲೋಕಾಸ್ತಸ್ಯ ಸಮೀಪಮಾಯಯುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","ತದನನ್ತರಂ ಯೀಶೈ ಕತಿಪಯದಿನಾನಿ ವಿಲಮ್ಬ್ಯ ಪುನಃ ಕಫರ್ನಾಹೂಮ್ನಗರಂ ಪ್ರವಿಷ್ಟೇ ಸ ಗೃಹ ಆಸ್ತ ಇತಿ ಕಿಂವದನ್ತ್ಯಾ ತತ್ಕ್ಷಣಂ ತತ್ಸಮೀಪಂ ಬಹವೋ ಲೋಕಾ ಆಗತ್ಯ ಸಮುಪತಸ್ಥುಃ, ");
INSERT INTO sankan_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ತಸ್ಮಾದ್ ಗೃಹಮಧ್ಯೇ ಸರ್ವ್ವೇಷಾಂ ಕೃತೇ ಸ್ಥಾನಂ ನಾಭವದ್ ದ್ವಾರಸ್ಯ ಚತುರ್ದಿಕ್ಷ್ವಪಿ ನಾಭವತ್, ತತ್ಕಾಲೇ ಸ ತಾನ್ ಪ್ರತಿ ಕಥಾಂ ಪ್ರಚಾರಯಾಞ್ಚಕ್ರೇ| ");
INSERT INTO sankan_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ತತಃ ಪರಂ ಲೋಕಾಶ್ಚತುರ್ಭಿ ರ್ಮಾನವೈರೇಕಂ ಪಕ್ಷಾಘಾತಿನಂ ವಾಹಯಿತ್ವಾ ತತ್ಸಮೀಪಮ್ ಆನಿನ್ಯುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ಕಿನ್ತು ಜನಾನಾಂ ಬಹುತ್ವಾತ್ ತಂ ಯೀಶೋಃ ಸಮ್ಮುಖಮಾನೇತುಂ ನ ಶಕ್ನುವನ್ತೋ ಯಸ್ಮಿನ್ ಸ್ಥಾನೇ ಸ ಆಸ್ತೇ ತದುಪರಿಗೃಹಪೃಷ್ಠಂ ಖನಿತ್ವಾ ಛಿದ್ರಂ ಕೃತ್ವಾ ತೇನ ಮಾರ್ಗೇಣ ಸಶಯ್ಯಂ ಪಕ್ಷಾಘಾತಿನಮ್ ಅವರೋಹಯಾಮಾಸುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ತತೋ ಯೀಶುಸ್ತೇಷಾಂ ವಿಶ್ವಾಸಂ ದೃಷ್ಟ್ವಾ ತಂ ಪಕ್ಷಾಘಾತಿನಂ ಬಭಾಷೇ ಹೇ ವತ್ಸ ತವ ಪಾಪಾನಾಂ ಮಾರ್ಜನಂ ಭವತು| ");
INSERT INTO sankan_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ತದಾ ಕಿಯನ್ತೋಽಧ್ಯಾಪಕಾಸ್ತತ್ರೋಪವಿಶನ್ತೋ ಮನೋಭಿ ರ್ವಿತರ್ಕಯಾಞ್ಚಕ್ರುಃ, ಏಷ ಮನುಷ್ಯ ಏತಾದೃಶೀಮೀಶ್ವರನಿನ್ದಾಂ ಕಥಾಂ ಕುತಃ ಕಥಯತಿ? ");
INSERT INTO sankan_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","ಈಶ್ವರಂ ವಿನಾ ಪಾಪಾನಿ ಮಾರ್ಷ್ಟುಂ ಕಸ್ಯ ಸಾಮರ್ಥ್ಯಮ್ ಆಸ್ತೇ? ");
INSERT INTO sankan_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ಇತ್ಥಂ ತೇ ವಿತರ್ಕಯನ್ತಿ ಯೀಶುಸ್ತತ್ಕ್ಷಣಂ ಮನಸಾ ತದ್ ಬುದ್ವ್ವಾ ತಾನವದದ್ ಯೂಯಮನ್ತಃಕರಣೈಃ ಕುತ ಏತಾನಿ ವಿತರ್ಕಯಥ? ");
INSERT INTO sankan_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","ತದನನ್ತರಂ ಯೀಶುಸ್ತತ್ಸ್ಥಾನಾತ್ ಪುನಃ ಸಮುದ್ರತಟಂ ಯಯೌ; ಲೋಕನಿವಹೇ ತತ್ಸಮೀಪಮಾಗತೇ ಸ ತಾನ್ ಸಮುಪದಿದೇಶ| ");
INSERT INTO sankan_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","ಕಿನ್ತು ಪೃಥಿವ್ಯಾಂ ಪಾಪಾನಿ ಮಾರ್ಷ್ಟುಂ ಮನುಷ್ಯಪುತ್ರಸ್ಯ ಸಾಮರ್ಥ್ಯಮಸ್ತಿ, ಏತದ್ ಯುಷ್ಮಾನ್ ಜ್ಞಾಪಯಿತುಂ (ಸ ತಸ್ಮೈ ಪಕ್ಷಾಘಾತಿನೇ ಕಥಯಾಮಾಸ) ");
INSERT INTO sankan_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","ಉತ್ತಿಷ್ಠ ತವ ಶಯ್ಯಾಂ ಗೃಹೀತ್ವಾ ಸ್ವಗೃಹಂ ಯಾಹಿ, ಅಹಂ ತ್ವಾಮಿದಮ್ ಆಜ್ಞಾಪಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ತತಃ ಸ ತತ್ಕ್ಷಣಮ್ ಉತ್ಥಾಯ ಶಯ್ಯಾಂ ಗೃಹೀತ್ವಾ ಸರ್ವ್ವೇಷಾಂ ಸಾಕ್ಷಾತ್ ಜಗಾಮ; ಸರ್ವ್ವೇ ವಿಸ್ಮಿತಾ ಏತಾದೃಶಂ ಕರ್ಮ್ಮ ವಯಮ್ ಕದಾಪಿ ನಾಪಶ್ಯಾಮ, ಇಮಾಂ ಕಥಾಂ ಕಥಯಿತ್ವೇಶ್ವರಂ ಧನ್ಯಮಬ್ರುವನ್| ");
INSERT INTO sankan_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","ತದನನ್ತರಂ ಯೀಶುಸ್ತತ್ಸ್ಥಾನಾತ್ ಪುನಃ ಸಮುದ್ರತಟಂ ಯಯೌ; ಲೋಕನಿವಹೇ ತತ್ಸಮೀಪಮಾಗತೇ ಸ ತಾನ್ ಸಮುಪದಿದೇಶ| ");
INSERT INTO sankan_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ಅಥ ಗಚ್ಛನ್ ಕರಸಞ್ಚಯಗೃಹ ಉಪವಿಷ್ಟಮ್ ಆಲ್ಫೀಯಪುತ್ರಂ ಲೇವಿಂ ದೃಷ್ಟ್ವಾ ತಮಾಹೂಯ ಕಥಿತವಾನ್ ಮತ್ಪಶ್ಚಾತ್ ತ್ವಾಮಾಮಚ್ಛ ತತಃ ಸ ಉತ್ಥಾಯ ತತ್ಪಶ್ಚಾದ್ ಯಯೌ| ");
INSERT INTO sankan_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","ಅನನ್ತರಂ ಯೀಶೌ ತಸ್ಯ ಗೃಹೇ ಭೋಕ್ತುಮ್ ಉಪವಿಷ್ಟೇ ಬಹವಃ ಕರಮಞ್ಚಾಯಿನಃ ಪಾಪಿನಶ್ಚ ತೇನ ತಚ್ಛಿಷ್ಯೈಶ್ಚ ಸಹೋಪವಿವಿಶುಃ, ಯತೋ ಬಹವಸ್ತತ್ಪಶ್ಚಾದಾಜಗ್ಮುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ತದಾ ಸ ಕರಮಞ್ಚಾಯಿಭಿಃ ಪಾಪಿಭಿಶ್ಚ ಸಹ ಖಾದತಿ, ತದ್ ದೃಷ್ಟ್ವಾಧ್ಯಾಪಕಾಃ ಫಿರೂಶಿನಶ್ಚ ತಸ್ಯ ಶಿಷ್ಯಾನೂಚುಃ ಕರಮಞ್ಚಾಯಿಭಿಃ ಪಾಪಿಭಿಶ್ಚ ಸಹಾಯಂ ಕುತೋ ಭುಂಕ್ತೇ ಪಿವತಿ ಚ? ");
INSERT INTO sankan_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ತದ್ವಾಕ್ಯಂ ಶ್ರುತ್ವಾ ಯೀಶುಃ ಪ್ರತ್ಯುವಾಚ,ಅರೋಗಿಲೋಕಾನಾಂ ಚಿಕಿತ್ಸಕೇನ ಪ್ರಯೋಜನಂ ನಾಸ್ತಿ, ಕಿನ್ತು ರೋಗಿಣಾಮೇವ; ಅಹಂ ಧಾರ್ಮ್ಮಿಕಾನಾಹ್ವಾತುಂ ನಾಗತಃ ಕಿನ್ತು ಮನೋ ವ್ಯಾವರ್ತ್ತಯಿತುಂ ಪಾಪಿನ ಏವ| ");
INSERT INTO sankan_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ತತಃ ಪರಂ ಯೋಹನಃ ಫಿರೂಶಿನಾಞ್ಚೋಪವಾಸಾಚಾರಿಶಿಷ್ಯಾ ಯೀಶೋಃ ಸಮೀಪಮ್ ಆಗತ್ಯ ಕಥಯಾಮಾಸುಃ, ಯೋಹನಃ ಫಿರೂಶಿನಾಞ್ಚ ಶಿಷ್ಯಾ ಉಪವಸನ್ತಿ ಕಿನ್ತು ಭವತಃ ಶಿಷ್ಯಾ ನೋಪವಸನ್ತಿ ಕಿಂ ಕಾರಣಮಸ್ಯ? ");
INSERT INTO sankan_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","ತದಾ ಯೀಶುಸ್ತಾನ್ ಬಭಾಷೇ ಯಾವತ್ ಕಾಲಂ ಸಖಿಭಿಃ ಸಹ ಕನ್ಯಾಯಾ ವರಸ್ತಿಷ್ಠತಿ ತಾವತ್ಕಾಲಂ ತೇ ಕಿಮುಪವಸ್ತುಂ ಶಕ್ನುವನ್ತಿ? ಯಾವತ್ಕಾಲಂ ವರಸ್ತೈಃ ಸಹ ತಿಷ್ಠತಿ ತಾವತ್ಕಾಲಂ ತ ಉಪವಸ್ತುಂ ನ ಶಕ್ನುವನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","ಯಸ್ಮಿನ್ ಕಾಲೇ ತೇಭ್ಯಃ ಸಕಾಶಾದ್ ವರೋ ನೇಷ್ಯತೇ ಸ ಕಾಲ ಆಗಚ್ಛತಿ, ತಸ್ಮಿನ್ ಕಾಲೇ ತೇ ಜನಾ ಉಪವತ್ಸ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","ಕೋಪಿ ಜನಃ ಪುರಾತನವಸ್ತ್ರೇ ನೂತನವಸ್ತ್ರಂ ನ ಸೀವ್ಯತಿ, ಯತೋ ನೂತನವಸ್ತ್ರೇಣ ಸಹ ಸೇವನೇ ಕೃತೇ ಜೀರ್ಣಂ ವಸ್ತ್ರಂ ಛಿದ್ಯತೇ ತಸ್ಮಾತ್ ಪುನ ರ್ಮಹತ್ ಛಿದ್ರಂ ಜಾಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","ಕೋಪಿ ಜನಃ ಪುರಾತನಕುತೂಷು ನೂತನಂ ದ್ರಾಕ್ಷಾರಸಂ ನ ಸ್ಥಾಪಯತಿ, ಯತೋ ನೂತನದ್ರಾಕ್ಷಾರಸಸ್ಯ ತೇಜಸಾ ತಾಃ ಕುತ್ವೋ ವಿದೀರ್ಯ್ಯನ್ತೇ ತತೋ ದ್ರಾಕ್ಷಾರಸಶ್ಚ ಪತತಿ ಕುತ್ವಶ್ಚ ನಶ್ಯನ್ತಿ, ಅತಏವ ನೂತನದ್ರಾಕ್ಷಾರಸೋ ನೂತನಕುತೂಷು ಸ್ಥಾಪನೀಯಃ| ");
INSERT INTO sankan_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","ತದನನ್ತರಂ ಯೀಶು ರ್ಯದಾ ವಿಶ್ರಾಮವಾರೇ ಶಸ್ಯಕ್ಷೇತ್ರೇಣ ಗಚ್ಛತಿ ತದಾ ತಸ್ಯ ಶಿಷ್ಯಾ ಗಚ್ಛನ್ತಃ ಶಸ್ಯಮಞ್ಜರೀಶ್ಛೇತ್ತುಂ ಪ್ರವೃತ್ತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ಅತಃ ಫಿರೂಶಿನೋ ಯೀಶವೇ ಕಥಯಾಮಾಸುಃ ಪಶ್ಯತು ವಿಶ್ರಾಮವಾಸರೇ ಯತ್ ಕರ್ಮ್ಮ ನ ಕರ್ತ್ತವ್ಯಂ ತದ್ ಇಮೇ ಕುತಃ ಕುರ್ವ್ವನ್ತಿ? ");
INSERT INTO sankan_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ತದಾ ಸ ತೇಭ್ಯೋಽಕಥಯತ್ ದಾಯೂದ್ ತತ್ಸಂಙ್ಗಿನಶ್ಚ ಭಕ್ಷ್ಯಾಭಾವಾತ್ ಕ್ಷುಧಿತಾಃ ಸನ್ತೋ ಯತ್ ಕರ್ಮ್ಮ ಕೃತವನ್ತಸ್ತತ್ ಕಿಂ ಯುಷ್ಮಾಭಿ ರ್ನ ಪಠಿತಮ್? ");
INSERT INTO sankan_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ಅಬಿಯಾಥರ್ನಾಮಕೇ ಮಹಾಯಾಜಕತಾಂ ಕುರ್ವ್ವತಿ ಸ ಕಥಮೀಶ್ವರಸ್ಯಾವಾಸಂ ಪ್ರವಿಶ್ಯ ಯೇ ದರ್ಶನೀಯಪೂಪಾ ಯಾಜಕಾನ್ ವಿನಾನ್ಯಸ್ಯ ಕಸ್ಯಾಪಿ ನ ಭಕ್ಷ್ಯಾಸ್ತಾನೇವ ಬುಭುಜೇ ಸಙ್ಗಿಲೋಕೇಭ್ಯೋಽಪಿ ದದೌ| ");
INSERT INTO sankan_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","ಸೋಽಪರಮಪಿ ಜಗಾದ, ವಿಶ್ರಾಮವಾರೋ ಮನುಷ್ಯಾರ್ಥಮೇವ ನಿರೂಪಿತೋಽಸ್ತಿ ಕಿನ್ತು ಮನುಷ್ಯೋ ವಿಶ್ರಾಮವಾರಾರ್ಥಂ ನೈವ| ");
INSERT INTO sankan_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","ಮನುಷ್ಯಪುತ್ರೋ ವಿಶ್ರಾಮವಾರಸ್ಯಾಪಿ ಪ್ರಭುರಾಸ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ಅನನ್ತರಂ ಯೀಶುಃ ಪುನ ರ್ಭಜನಗೃಹಂ ಪ್ರವಿಷ್ಟಸ್ತಸ್ಮಿನ್ ಸ್ಥಾನೇ ಶುಷ್ಕಹಸ್ತ ಏಕೋ ಮಾನವ ಆಸೀತ್| ");
INSERT INTO sankan_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ಸ ವಿಶ್ರಾಮವಾರೇ ತಮರೋಗಿಣಂ ಕರಿಷ್ಯತಿ ನವೇತ್ಯತ್ರ ಬಹವಸ್ತಮ್ ಅಪವದಿತುಂ ಛಿದ್ರಮಪೇಕ್ಷಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ತದಾ ಸ ತಂ ಶುಷ್ಕಹಸ್ತಂ ಮನುಷ್ಯಂ ಜಗಾದ ಮಧ್ಯಸ್ಥಾನೇ ತ್ವಮುತ್ತಿಷ್ಠ| ");
INSERT INTO sankan_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ತತಃ ಪರಂ ಸ ತಾನ್ ಪಪ್ರಚ್ಛ ವಿಶ್ರಾಮವಾರೇ ಹಿತಮಹಿತಂ ತಥಾ ಹಿ ಪ್ರಾಣರಕ್ಷಾ ವಾ ಪ್ರಾಣನಾಶ ಏಷಾಂ ಮಧ್ಯೇ ಕಿಂ ಕರಣೀಯಂ ? ಕಿನ್ತು ತೇ ನಿಃಶಬ್ದಾಸ್ತಸ್ಥುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ತದಾ ಸ ತೇಷಾಮನ್ತಃಕರಣಾನಾಂ ಕಾಠಿನ್ಯಾದ್ಧೇತೋ ರ್ದುಃಖಿತಃ ಕ್ರೋಧಾತ್ ಚರ್ತುिದಶೋ ದೃಷ್ಟವಾನ್ ತಂ ಮಾನುಷಂ ಗದಿತವಾನ್ ತಂ ಹಸ್ತಂ ವಿಸ್ತಾರಯ, ತತಸ್ತೇನ ಹಸ್ತೇ ವಿಸ್ತೃತೇ ತದ್ಧಸ್ತೋಽನ್ಯಹಸ್ತವದ್ ಅರೋಗೋ ಜಾತಃ| ");
INSERT INTO sankan_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ಅಥ ಫಿರೂಶಿನಃ ಪ್ರಸ್ಥಾಯ ತಂ ನಾಶಯಿತುಂ ಹೇರೋದೀಯೈಃ ಸಹ ಮನ್ತ್ರಯಿತುಮಾರೇಭಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ಅತಏವ ಯೀಶುಸ್ತತ್ಸ್ಥಾನಂ ಪರಿತ್ಯಜ್ಯ ಶಿಷ್ಯೈಃ ಸಹ ಪುನಃ ಸಾಗರಸಮೀಪಂ ಗತಃ; ");
INSERT INTO sankan_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ತತೋ ಗಾಲೀಲ್ಯಿಹೂದಾ-ಯಿರೂಶಾಲಮ್-ಇದೋಮ್-ಯರ್ದನ್ನದೀಪಾರಸ್ಥಾನೇಭ್ಯೋ ಲೋಕಸಮೂಹಸ್ತಸ್ಯ ಪಶ್ಚಾದ್ ಗತಃ; ತದನ್ಯಃ ಸೋರಸೀದನೋಃ ಸಮೀಪವಾಸಿಲೋಕಸಮೂಹಶ್ಚ ತಸ್ಯ ಮಹಾಕರ್ಮ್ಮಣಾಂ ವಾರ್ತ್ತಂ ಶ್ರುತ್ವಾ ತಸ್ಯ ಸನ್ನಿಧಿಮಾಗತಃ| ");
INSERT INTO sankan_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","ತದಾ ಲೋಕಸಮೂಹಶ್ಚೇತ್ ತಸ್ಯೋಪರಿ ಪತತಿ ಇತ್ಯಾಶಙ್ಕ್ಯ ಸ ನಾವಮೇಕಾಂ ನಿಕಟೇ ಸ್ಥಾಪಯಿತುಂ ಶಿಷ್ಯಾನಾದಿಷ್ಟವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ಯತೋಽನೇಕಮನುಷ್ಯಾಣಾಮಾರೋಗ್ಯಕರಣಾದ್ ವ್ಯಾಧಿಗ್ರಸ್ತಾಃ ಸರ್ವ್ವೇ ತಂ ಸ್ಪ್ರಷ್ಟುಂ ಪರಸ್ಪರಂ ಬಲೇನ ಯತ್ನವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ಅಪರಞ್ಚ ಅಪವಿತ್ರಭೂತಾಸ್ತಂ ದೃಷ್ಟ್ವಾ ತಚ್ಚರಣಯೋಃ ಪತಿತ್ವಾ ಪ್ರೋಚೈಃ ಪ್ರೋಚುಃ, ತ್ವಮೀಶ್ವರಸ್ಯ ಪುತ್ರಃ| ");
INSERT INTO sankan_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","ಕಿನ್ತು ಸ ತಾನ್ ದೃಢಮ್ ಆಜ್ಞಾಪ್ಯ ಸ್ವಂ ಪರಿಚಾಯಿತುಂ ನಿಷಿದ್ಧವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","ಅನನ್ತರಂ ಸ ಪರ್ವ್ವತಮಾರುಹ್ಯ ಯಂ ಯಂ ಪ್ರತಿಚ್ಛಾ ತಂ ತಮಾಹೂತವಾನ್ ತತಸ್ತೇ ತತ್ಸಮೀಪಮಾಗತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ತದಾ ಸ ದ್ವಾದಶಜನಾನ್ ಸ್ವೇನ ಸಹ ಸ್ಥಾತುಂ ಸುಸಂವಾದಪ್ರಚಾರಾಯ ಪ್ರೇರಿತಾ ಭವಿತುಂ ");
INSERT INTO sankan_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ಸರ್ವ್ವಪ್ರಕಾರವ್ಯಾಧೀನಾಂ ಶಮನಕರಣಾಯ ಪ್ರಭಾವಂ ಪ್ರಾಪ್ತುಂ ಭೂತಾನ್ ತ್ಯಾಜಯಿತುಞ್ಚ ನಿಯುಕ್ತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ತೇಷಾಂ ನಾಮಾನೀಮಾನಿ, ಶಿಮೋನ್ ಸಿವದಿಪುತ್ರೋ ");
INSERT INTO sankan_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ಯಾಕೂಬ್ ತಸ್ಯ ಭ್ರಾತಾ ಯೋಹನ್ ಚ ಆನ್ದ್ರಿಯಃ ಫಿಲಿಪೋ ಬರ್ಥಲಮಯಃ, ");
INSERT INTO sankan_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ಮಥೀ ಥೋಮಾ ಚ ಆಲ್ಫೀಯಪುತ್ರೋ ಯಾಕೂಬ್ ಥದ್ದೀಯಃ ಕಿನಾನೀಯಃ ಶಿಮೋನ್ ಯಸ್ತಂ ಪರಹಸ್ತೇಷ್ವರ್ಪಯಿಷ್ಯತಿ ಸ ಈಷ್ಕರಿಯೋತೀಯಯಿಹೂದಾಶ್ಚ| ");
INSERT INTO sankan_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ಸ ಶಿಮೋನೇ ಪಿತರ ಇತ್ಯುಪನಾಮ ದದೌ ಯಾಕೂಬ್ಯೋಹನ್ಭ್ಯಾಂ ಚ ಬಿನೇರಿಗಿಶ್ ಅರ್ಥತೋ ಮೇಘನಾದಪುತ್ರಾವಿತ್ಯುಪನಾಮ ದದೌ| ");
INSERT INTO sankan_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ಅನನ್ತರಂ ತೇ ನಿವೇಶನಂ ಗತಾಃ, ಕಿನ್ತು ತತ್ರಾಪಿ ಪುನರ್ಮಹಾನ್ ಜನಸಮಾಗಮೋ ಽಭವತ್ ತಸ್ಮಾತ್ತೇ ಭೋಕ್ತುಮಪ್ಯವಕಾಶಂ ನ ಪ್ರಾಪ್ತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ತತಸ್ತಸ್ಯ ಸುಹೃಲ್ಲೋಕಾ ಇಮಾಂ ವಾರ್ತ್ತಾಂ ಪ್ರಾಪ್ಯ ಸ ಹತಜ್ಞಾನೋಭೂದ್ ಇತಿ ಕಥಾಂ ಕಥಯಿತ್ವಾ ತಂ ಧೃತ್ವಾನೇತುಂ ಗತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","ಅಪರಞ್ಚ ಯಿರೂಶಾಲಮ ಆಗತಾ ಯೇ ಯೇಽಧ್ಯಾಪಕಾಸ್ತೇ ಜಗದುರಯಂ ಪುರುಷೋ ಭೂತಪತ್ಯಾಬಿಷ್ಟಸ್ತೇನ ಭೂತಪತಿನಾ ಭೂತಾನ್ ತ್ಯಾಜಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","ತತಸ್ತಾನಾಹೂಯ ಯೀಶು ರ್ದೃಷ್ಟಾನ್ತೈಃ ಕಥಾಂ ಕಥಿತವಾನ್ ಶೈತಾನ್ ಕಥಂ ಶೈತಾನಂ ತ್ಯಾಜಯಿತುಂ ಶಕ್ನೋತಿ? ");
INSERT INTO sankan_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","ಕಿಞ್ಚನ ರಾಜ್ಯಂ ಯದಿ ಸ್ವವಿರೋಧೇನ ಪೃಥಗ್ ಭವತಿ ತರ್ಹಿ ತದ್ ರಾಜ್ಯಂ ಸ್ಥಿರಂ ಸ್ಥಾತುಂ ನ ಶಕ್ನೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ತಥಾ ಕಸ್ಯಾಪಿ ಪರಿವಾರೋ ಯದಿ ಪರಸ್ಪರಂ ವಿರೋಧೀ ಭವತಿ ತರ್ಹಿ ಸೋಪಿ ಪರಿವಾರಃ ಸ್ಥಿರಂ ಸ್ಥಾತುಂ ನ ಶಕ್ನೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","ತದ್ವತ್ ಶೈತಾನ್ ಯದಿ ಸ್ವವಿಪಕ್ಷತಯಾ ಉತ್ತಿಷ್ಠನ್ ಭಿನ್ನೋ ಭವತಿ ತರ್ಹಿ ಸೋಪಿ ಸ್ಥಿರಂ ಸ್ಥಾತುಂ ನ ಶಕ್ನೋತಿ ಕಿನ್ತೂಚ್ಛಿನ್ನೋ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","ಅಪರಞ್ಚ ಪ್ರಬಲಂ ಜನಂ ಪ್ರಥಮಂ ನ ಬದ್ಧಾ ಕೋಪಿ ತಸ್ಯ ಗೃಹಂ ಪ್ರವಿಶ್ಯ ದ್ರವ್ಯಾಣಿ ಲುಣ್ಠಯಿತುಂ ನ ಶಕ್ನೋತಿ, ತಂ ಬದ್ವ್ವೈವ ತಸ್ಯ ಗೃಹಸ್ಯ ದ್ರವ್ಯಾಣಿ ಲುಣ್ಠಯಿತುಂ ಶಕ್ನೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","ಅತೋಹೇತೋ ರ್ಯುಷ್ಮಭ್ಯಮಹಂ ಸತ್ಯಂ ಕಥಯಾಮಿ ಮನುಷ್ಯಾಣಾಂ ಸನ್ತಾನಾ ಯಾನಿ ಯಾನಿ ಪಾಪಾನೀಶ್ವರನಿನ್ದಾಞ್ಚ ಕುರ್ವ್ವನ್ತಿ ತೇಷಾಂ ತತ್ಸರ್ವ್ವೇಷಾಮಪರಾಧಾನಾಂ ಕ್ಷಮಾ ಭವಿತುಂ ಶಕ್ನೋತಿ, ");
INSERT INTO sankan_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ಕಿನ್ತು ಯಃ ಕಶ್ಚಿತ್ ಪವಿತ್ರಮಾತ್ಮಾನಂ ನಿನ್ದತಿ ತಸ್ಯಾಪರಾಧಸ್ಯ ಕ್ಷಮಾ ಕದಾಪಿ ನ ಭವಿಷ್ಯತಿ ಸೋನನ್ತದಣ್ಡಸ್ಯಾರ್ಹೋ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","ತಸ್ಯಾಪವಿತ್ರಭೂತೋಽಸ್ತಿ ತೇಷಾಮೇತತ್ಕಥಾಹೇತೋಃ ಸ ಇತ್ಥಂ ಕಥಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ಅಥ ತಸ್ಯ ಮಾತಾ ಭ್ರಾತೃಗಣಶ್ಚಾಗತ್ಯ ಬಹಿಸ್ತಿಷ್ಠನತೋ ಲೋಕಾನ್ ಪ್ರೇಷ್ಯ ತಮಾಹೂತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ತತಸ್ತತ್ಸನ್ನಿಧೌ ಸಮುಪವಿಷ್ಟಾ ಲೋಕಾಸ್ತಂ ಬಭಾಷಿರೇ ಪಶ್ಯ ಬಹಿಸ್ತವ ಮಾತಾ ಭ್ರಾತರಶ್ಚ ತ್ವಾಮ್ ಅನ್ವಿಚ್ಛನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ತದಾ ಸ ತಾನ್ ಪ್ರತ್ಯುವಾಚ ಮಮ ಮಾತಾ ಕಾ ಭ್ರಾತರೋ ವಾ ಕೇ? ತತಃ ಪರಂ ಸ ಸ್ವಮೀಪೋಪವಿಷ್ಟಾನ್ ಶಿಷ್ಯಾನ್ ಪ್ರತಿ ಅವಲೋಕನಂ ಕೃತ್ವಾ ಕಥಯಾಮಾಸ ");
INSERT INTO sankan_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ಪಶ್ಯತೈತೇ ಮಮ ಮಾತಾ ಭ್ರಾತರಶ್ಚ| ");
INSERT INTO sankan_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ಯಃ ಕಶ್ಚಿದ್ ಈಶ್ವರಸ್ಯೇಷ್ಟಾಂ ಕ್ರಿಯಾಂ ಕರೋತಿ ಸ ಏವ ಮಮ ಭ್ರಾತಾ ಭಗಿನೀ ಮಾತಾ ಚ| ");
INSERT INTO sankan_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","ಅನನ್ತರಂ ಸ ಸಮುದ್ರತಟೇ ಪುನರುಪದೇಷ್ಟುಂ ಪ್ರಾರೇಭೇ, ತತಸ್ತತ್ರ ಬಹುಜನಾನಾಂ ಸಮಾಗಮಾತ್ ಸ ಸಾಗರೋಪರಿ ನೌಕಾಮಾರುಹ್ಯ ಸಮುಪವಿಷ್ಟಃ; ಸರ್ವ್ವೇ ಲೋಕಾಃ ಸಮುದ್ರಕೂಲೇ ತಸ್ಥುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ತದಾ ಸ ದೃಷ್ಟಾನ್ತಕಥಾಭಿ ರ್ಬಹೂಪದಿಷ್ಟವಾನ್ ಉಪದಿಶಂಶ್ಚ ಕಥಿತವಾನ್, ");
INSERT INTO sankan_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","ಅವಧಾನಂ ಕುರುತ, ಏಕೋ ಬೀಜವಪ್ತಾ ಬೀಜಾನಿ ವಪ್ತುಂ ಗತಃ; ");
INSERT INTO sankan_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ವಪನಕಾಲೇ ಕಿಯನ್ತಿ ಬೀಜಾನಿ ಮಾರ್ಗಪಾಶ್ವೇ ಪತಿತಾನಿ, ತತ ಆಕಾಶೀಯಪಕ್ಷಿಣ ಏತ್ಯ ತಾನಿ ಚಖಾದುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","ಕಿಯನ್ತಿ ಬೀಜಾನಿ ಸ್ವಲ್ಪಮೃತ್ತಿಕಾವತ್ಪಾಷಾಣಭೂಮೌ ಪತಿತಾನಿ ತಾನಿ ಮೃದೋಲ್ಪತ್ವಾತ್ ಶೀಘ್ರಮಙ್ಕುರಿತಾನಿ; ");
INSERT INTO sankan_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ಕಿನ್ತೂದಿತೇ ಸೂರ್ಯ್ಯೇ ದಗ್ಧಾನಿ ತಥಾ ಮೂಲಾನೋ ನಾಧೋಗತತ್ವಾತ್ ಶುಷ್ಕಾಣಿ ಚ| ");
INSERT INTO sankan_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","ಕಿಯನ್ತಿ ಬೀಜಾನಿ ಕಣ್ಟಕಿವನಮಧ್ಯೇ ಪತಿತಾನಿ ತತಃ ಕಣ್ಟಕಾನಿ ಸಂವೃದ್ವ್ಯ ತಾನಿ ಜಗ್ರಸುಸ್ತಾನಿ ನ ಚ ಫಲಿತಾನಿ| ");
INSERT INTO sankan_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","ತಥಾ ಕಿಯನ್ತಿ ಬೀಜಾನ್ಯುತ್ತಮಭೂಮೌ ಪತಿತಾನಿ ತಾನಿ ಸಂವೃದ್ವ್ಯ ಫಲಾನ್ಯುತ್ಪಾದಿತಾನಿ ಕಿಯನ್ತಿ ಬೀಜಾನಿ ತ್ರಿಂಶದ್ಗುಣಾನಿ ಕಿಯನ್ತಿ ಷಷ್ಟಿಗುಣಾನಿ ಕಿಯನ್ತಿ ಶತಗುಣಾನಿ ಫಲಾನಿ ಫಲಿತವನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ಅಥ ಸ ತಾನವದತ್ ಯಸ್ಯ ಶ್ರೋತುಂ ಕರ್ಣೌ ಸ್ತಃ ಸ ಶೃಣೋತು| ");
INSERT INTO sankan_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","ತದನನ್ತರಂ ನಿರ್ಜನಸಮಯೇ ತತ್ಸಙ್ಗಿನೋ ದ್ವಾದಶಶಿಷ್ಯಾಶ್ಚ ತಂ ತದ್ದೃಷ್ಟಾನ್ತವಾಕ್ಯಸ್ಯಾರ್ಥಂ ಪಪ್ರಚ್ಛುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ತದಾ ಸ ತಾನುದಿತವಾನ್ ಈಶ್ವರರಾಜ್ಯಸ್ಯ ನಿಗೂಢವಾಕ್ಯಂ ಬೋದ್ಧುಂ ಯುಷ್ಮಾಕಮಧಿಕಾರೋಽಸ್ತಿ; ");
INSERT INTO sankan_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ಕಿನ್ತು ಯೇ ವಹಿರ್ಭೂತಾಃ \"ತೇ ಪಶ್ಯನ್ತಃ ಪಶ್ಯನ್ತಿ ಕಿನ್ತು ನ ಜಾನನ್ತಿ, ಶೃಣ್ವನ್ತಃ ಶೃಣ್ವನ್ತಿ ಕಿನ್ತು ನ ಬುಧ್ಯನ್ತೇ, ಚೇತ್ತೈ ರ್ಮನಃಸು ಕದಾಪಿ ಪರಿವರ್ತ್ತಿತೇಷು ತೇಷಾಂ ಪಾಪಾನ್ಯಮೋಚಯಿಷ್ಯನ್ತ,\" ಅತೋಹೇತೋಸ್ತಾನ್ ಪ್ರತಿ ದೃಷ್ಟಾನ್ತೈರೇವ ತಾನಿ ಮಯಾ ಕಥಿತಾನಿ| ");
INSERT INTO sankan_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","ಅಥ ಸ ಕಥಿತವಾನ್ ಯೂಯಂ ಕಿಮೇತದ್ ದೃಷ್ಟಾನ್ತವಾಕ್ಯಂ ನ ಬುಧ್ಯಧ್ವೇ? ತರ್ಹಿ ಕಥಂ ಸರ್ವ್ವಾನ್ ದೃಷ್ಟಾನ್ತಾನ ಭೋತ್ಸ್ಯಧ್ವೇ? ");
INSERT INTO sankan_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ಬೀಜವಪ್ತಾ ವಾಕ್ಯರೂಪಾಣಿ ಬೀಜಾನಿ ವಪತಿ; ");
INSERT INTO sankan_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ತತ್ರ ಯೇ ಯೇ ಲೋಕಾ ವಾಕ್ಯಂ ಶೃಣ್ವನ್ತಿ, ಕಿನ್ತು ಶ್ರುತಮಾತ್ರಾತ್ ಶೈತಾನ್ ಶೀಘ್ರಮಾಗತ್ಯ ತೇಷಾಂ ಮನಃಸೂಪ್ತಾನಿ ತಾನಿ ವಾಕ್ಯರೂಪಾಣಿ ಬೀಜಾನ್ಯಪನಯತಿ ತಏವ ಉಪ್ತಬೀಜಮಾರ್ಗಪಾರ್ಶ್ವೇಸ್ವರೂಪಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ಯೇ ಜನಾ ವಾಕ್ಯಂ ಶ್ರುತ್ವಾ ಸಹಸಾ ಪರಮಾನನ್ದೇನ ಗೃಹ್ಲನ್ತಿ, ಕಿನ್ತು ಹೃದಿ ಸ್ಥೈರ್ಯ್ಯಾಭಾವಾತ್ ಕಿಞ್ಚಿತ್ ಕಾಲಮಾತ್ರಂ ತಿಷ್ಠನ್ತಿ ತತ್ಪಶ್ಚಾತ್ ತದ್ವಾಕ್ಯಹೇತೋಃ ");
INSERT INTO sankan_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ಕುತ್ರಚಿತ್ ಕ್ಲೇಶೇ ಉಪದ್ರವೇ ವಾ ಸಮುಪಸ್ಥಿತೇ ತದೈವ ವಿಘ್ನಂ ಪ್ರಾಪ್ನುವನ್ತಿ ತಏವ ಉಪ್ತಬೀಜಪಾಷಾಣಭೂಮಿಸ್ವರೂಪಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","ಯೇ ಜನಾಃ ಕಥಾಂ ಶೃಣ್ವನ್ತಿ ಕಿನ್ತು ಸಾಂಸಾರಿಕೀ ಚಿನ್ತಾ ಧನಭ್ರಾನ್ತಿ ರ್ವಿಷಯಲೋಭಶ್ಚ ಏತೇ ಸರ್ವ್ವೇ ಉಪಸ್ಥಾಯ ತಾಂ ಕಥಾಂ ಗ್ರಸನ್ತಿ ತತಃ ಮಾ ವಿಫಲಾ ಭವತಿ ");
INSERT INTO sankan_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ತಏವ ಉಪ್ತಬೀಜಸಕಣ್ಟಕಭೂಮಿಸ್ವರೂಪಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ಯೇ ಜನಾ ವಾಕ್ಯಂ ಶ್ರುತ್ವಾ ಗೃಹ್ಲನ್ತಿ ತೇಷಾಂ ಕಸ್ಯ ವಾ ತ್ರಿಂಶದ್ಗುಣಾನಿ ಕಸ್ಯ ವಾ ಷಷ್ಟಿಗುಣಾನಿ ಕಸ್ಯ ವಾ ಶತಗುಣಾನಿ ಫಲಾನಿ ಭವನ್ತಿ ತಏವ ಉಪ್ತಬೀಜೋರ್ವ್ವರಭೂಮಿಸ್ವರೂಪಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ತದಾ ಸೋಽಪರಮಪಿ ಕಥಿತವಾನ್ ಕೋಪಿ ಜನೋ ದೀಪಾಧಾರಂ ಪರಿತ್ಯಜ್ಯ ದ್ರೋಣಸ್ಯಾಧಃ ಖಟ್ವಾಯಾ ಅಧೇ ವಾ ಸ್ಥಾಪಯಿತುಂ ದೀಪಮಾನಯತಿ ಕಿಂ? ");
INSERT INTO sankan_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","ಅತೋಹೇತೋ ರ್ಯನ್ನ ಪ್ರಕಾಶಯಿಷ್ಯತೇ ತಾದೃಗ್ ಲುಕ್ಕಾಯಿತಂ ಕಿಮಪಿ ವಸ್ತು ನಾಸ್ತಿ; ಯದ್ ವ್ಯಕ್ತಂ ನ ಭವಿಷ್ಯತಿ ತಾದೃಶಂ ಗುಪ್ತಂ ಕಿಮಪಿ ವಸ್ತು ನಾಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ಯಸ್ಯ ಶ್ರೋತುಂ ಕರ್ಣೌ ಸ್ತಃ ಸ ಶೃಣೋತು| ");
INSERT INTO sankan_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","ಅಪರಮಪಿ ಕಥಿತವಾನ್ ಯೂಯಂ ಯದ್ ಯದ್ ವಾಕ್ಯಂ ಶೃಣುಥ ತತ್ರ ಸಾವಧಾನಾ ಭವತ, ಯತೋ ಯೂಯಂ ಯೇನ ಪರಿಮಾಣೇನ ಪರಿಮಾಥ ತೇನೈವ ಪರಿಮಾಣೇನ ಯುಷ್ಮದರ್ಥಮಪಿ ಪರಿಮಾಸ್ಯತೇ; ಶ್ರೋತಾರೋ ಯೂಯಂ ಯುಷ್ಮಭ್ಯಮಧಿಕಂ ದಾಸ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","ಯಸ್ಯಾಶ್ರಯೇ ವರ್ದ್ಧತೇ ತಸ್ಮೈ ಅಪರಮಪಿ ದಾಸ್ಯತೇ, ಕಿನ್ತು ಯಸ್ಯಾಶ್ರಯೇ ನ ವರ್ದ್ಧತೇ ತಸ್ಯ ಯತ್ ಕಿಞ್ಚಿದಸ್ತಿ ತದಪಿ ತಸ್ಮಾನ್ ನೇಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","ಅನನ್ತರಂ ಸ ಕಥಿತವಾನ್ ಏಕೋ ಲೋಕಃ ಕ್ಷೇತ್ರೇ ಬೀಜಾನ್ಯುಪ್ತ್ವಾ ");
INSERT INTO sankan_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ಜಾಗರಣನಿದ್ರಾಭ್ಯಾಂ ದಿವಾನಿಶಂ ಗಮಯತಿ, ಪರನ್ತು ತದ್ವೀಜಂ ತಸ್ಯಾಜ್ಞಾತರೂಪೇಣಾಙ್ಕುರಯತಿ ವರ್ದ್ಧತೇ ಚ; ");
INSERT INTO sankan_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ಯತೋಹೇತೋಃ ಪ್ರಥಮತಃ ಪತ್ರಾಣಿ ತತಃ ಪರಂ ಕಣಿಶಾನಿ ತತ್ಪಶ್ಚಾತ್ ಕಣಿಶಪೂರ್ಣಾನಿ ಶಸ್ಯಾನಿ ಭೂಮಿಃ ಸ್ವಯಮುತ್ಪಾದಯತಿ; ");
INSERT INTO sankan_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ಕಿನ್ತು ಫಲೇಷು ಪಕ್ಕೇಷು ಶಸ್ಯಚ್ಛೇದನಕಾಲಂ ಜ್ಞಾತ್ವಾ ಸ ತತ್ಕ್ಷಣಂ ಶಸ್ಯಾನಿ ಛಿನತ್ತಿ, ಅನೇನ ತುಲ್ಯಮೀಶ್ವರರಾಜ್ಯಂ| ");
INSERT INTO sankan_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","ಪುನಃ ಸೋಽಕಥಯದ್ ಈಶ್ವರರಾಜ್ಯಂ ಕೇನ ಸಮಂ? ಕೇನ ವಸ್ತುನಾ ಸಹ ವಾ ತದುಪಮಾಸ್ಯಾಮಿ? ");
INSERT INTO sankan_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","ತತ್ ಸರ್ಷಪೈಕೇನ ತುಲ್ಯಂ ಯತೋ ಮೃದಿ ವಪನಕಾಲೇ ಸರ್ಷಪಬೀಜಂ ಸರ್ವ್ವಪೃಥಿವೀಸ್ಥಬೀಜಾತ್ ಕ್ಷುದ್ರಂ ");
INSERT INTO sankan_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ಕಿನ್ತು ವಪನಾತ್ ಪರಮ್ ಅಙ್ಕುರಯಿತ್ವಾ ಸರ್ವ್ವಶಾಕಾದ್ ಬೃಹದ್ ಭವತಿ, ತಸ್ಯ ಬೃಹತ್ಯಃ ಶಾಖಾಶ್ಚ ಜಾಯನ್ತೇ ತತಸ್ತಚ್ಛಾಯಾಂ ಪಕ್ಷಿಣ ಆಶ್ರಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ಇತ್ಥಂ ತೇಷಾಂ ಬೋಧಾನುರೂಪಂ ಸೋಽನೇಕದೃಷ್ಟಾನ್ತೈಸ್ತಾನುಪದಿಷ್ಟವಾನ್, ");
INSERT INTO sankan_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ದೃಷ್ಟಾನ್ತಂ ವಿನಾ ಕಾಮಪಿ ಕಥಾಂ ತೇಭ್ಯೋ ನ ಕಥಿತವಾನ್ ಪಶ್ಚಾನ್ ನಿರ್ಜನೇ ಸ ಶಿಷ್ಯಾನ್ ಸರ್ವ್ವದೃಷ್ಟಾನ್ತಾರ್ಥಂ ಬೋಧಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","ತದ್ದಿನಸ್ಯ ಸನ್ಧ್ಯಾಯಾಂ ಸ ತೇಭ್ಯೋಽಕಥಯದ್ ಆಗಚ್ಛತ ವಯಂ ಪಾರಂ ಯಾಮ| ");
INSERT INTO sankan_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ತದಾ ತೇ ಲೋಕಾನ್ ವಿಸೃಜ್ಯ ತಮವಿಲಮ್ಬಂ ಗೃಹೀತ್ವಾ ನೌಕಯಾ ಪ್ರತಸ್ಥಿರೇ; ಅಪರಾ ಅಪಿ ನಾವಸ್ತಯಾ ಸಹ ಸ್ಥಿತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ತತಃ ಪರಂ ಮಹಾಝಞ್ಭ್ಶಗಮಾತ್ ನೌ ರ್ದೋಲಾಯಮಾನಾ ತರಙ್ಗೇಣ ಜಲೈಃ ಪೂರ್ಣಾಭವಚ್ಚ| ");
INSERT INTO sankan_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ತದಾ ಸ ನೌಕಾಚಶ್ಚಾದ್ಭಾಗೇ ಉಪಧಾನೇ ಶಿರೋ ನಿಧಾಯ ನಿದ್ರಿತ ಆಸೀತ್ ತತಸ್ತೇ ತಂ ಜಾಗರಯಿತ್ವಾ ಜಗದುಃ, ಹೇ ಪ್ರಭೋ, ಅಸ್ಮಾಕಂ ಪ್ರಾಣಾ ಯಾನ್ತಿ ಕಿಮತ್ರ ಭವತಶ್ಚಿನ್ತಾ ನಾಸ್ತಿ? ");
INSERT INTO sankan_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ತದಾ ಸ ಉತ್ಥಾಯ ವಾಯುಂ ತರ್ಜಿತವಾನ್ ಸಮುದ್ರಞ್ಚೋಕ್ತವಾನ್ ಶಾನ್ತಃ ಸುಸ್ಥಿರಶ್ಚ ಭವ; ತತೋ ವಾಯೌ ನಿವೃತ್ತೇಽಬ್ಧಿರ್ನಿಸ್ತರಙ್ಗೋಭೂತ್| ");
INSERT INTO sankan_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","ತದಾ ಸ ತಾನುವಾಚ ಯೂಯಂ ಕುತ ಏತಾದೃಕ್ಶಙ್ಕಾಕುಲಾ ಭವತ? ಕಿಂ ವೋ ವಿಶ್ವಾಸೋ ನಾಸ್ತಿ? ");
INSERT INTO sankan_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ತಸ್ಮಾತ್ತೇಽತೀವಭೀತಾಃ ಪರಸ್ಪರಂ ವಕ್ತುಮಾರೇಭಿರೇ, ಅಹೋ ವಾಯುಃ ಸಿನ್ಧುಶ್ಚಾಸ್ಯ ನಿದೇಶಗ್ರಾಹಿಣೌ ಕೀದೃಗಯಂ ಮನುಜಃ| ");
INSERT INTO sankan_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ಅಥ ತೂ ಸಿನ್ಧುಪಾರಂ ಗತ್ವಾ ಗಿದೇರೀಯಪ್ರದೇಶ ಉಪತಸ್ಥುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ನೌಕಾತೋ ನಿರ್ಗತಮಾತ್ರಾದ್ ಅಪವಿತ್ರಭೂತಗ್ರಸ್ತ ಏಕಃ ಶ್ಮಶಾನಾದೇತ್ಯ ತಂ ಸಾಕ್ಷಾಚ್ ಚಕಾರ| ");
INSERT INTO sankan_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ಸ ಶ್ಮಶಾನೇಽವಾತ್ಸೀತ್ ಕೋಪಿ ತಂ ಶೃಙ್ಖಲೇನ ಬದ್ವ್ವಾ ಸ್ಥಾಪಯಿತುಂ ನಾಶಕ್ನೋತ್| ");
INSERT INTO sankan_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ಜನೈರ್ವಾರಂ ನಿಗಡೈಃ ಶೃಙ್ಖಲೈಶ್ಚ ಸ ಬದ್ಧೋಪಿ ಶೃಙ್ಖಲಾನ್ಯಾಕೃಷ್ಯ ಮೋಚಿತವಾನ್ ನಿಗಡಾನಿ ಚ ಭಂಕ್ತ್ವಾ ಖಣ್ಡಂ ಖಣ್ಡಂ ಕೃತವಾನ್ ಕೋಪಿ ತಂ ವಶೀಕರ್ತ್ತುಂ ನ ಶಶಕ| ");
INSERT INTO sankan_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ದಿವಾನಿಶಂ ಸದಾ ಪರ್ವ್ವತಂ ಶ್ಮಶಾನಞ್ಚ ಭ್ರಮಿತ್ವಾ ಚೀತ್ಶಬ್ದಂ ಕೃತವಾನ್ ಗ್ರಾವಭಿಶ್ಚ ಸ್ವಯಂ ಸ್ವಂ ಕೃತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ಸ ಯೀಶುಂ ದೂರಾತ್ ಪಶ್ಯನ್ನೇವ ಧಾವನ್ ತಂ ಪ್ರಣನಾಮ ಉಚೈರುವಂಶ್ಚೋವಾಚ, ");
INSERT INTO sankan_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ಹೇ ಸರ್ವ್ವೋಪರಿಸ್ಥೇಶ್ವರಪುತ್ರ ಯೀಶೋ ಭವತಾ ಸಹ ಮೇ ಕಃ ಸಮ್ಬನ್ಧಃ? ಅಹಂ ತ್ವಾಮೀಶ್ವರೇಣ ಶಾಪಯೇ ಮಾಂ ಮಾ ಯಾತಯ| ");
INSERT INTO sankan_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","ಯತೋ ಯೀಶುಸ್ತಂ ಕಥಿತವಾನ್ ರೇ ಅಪವಿತ್ರಭೂತ, ಅಸ್ಮಾನ್ನರಾದ್ ಬಹಿರ್ನಿರ್ಗಚ್ಛ| ");
INSERT INTO sankan_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","ಅಥ ಸ ತಂ ಪೃಷ್ಟವಾನ್ ಕಿನ್ತೇ ನಾಮ? ತೇನ ಪ್ರತ್ಯುಕ್ತಂ ವಯಮನೇಕೇ ಽಸ್ಮಸ್ತತೋಽಸ್ಮನ್ನಾಮ ಬಾಹಿನೀ| ");
INSERT INTO sankan_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ತತೋಸ್ಮಾನ್ ದೇಶಾನ್ನ ಪ್ರೇಷಯೇತಿ ತೇ ತಂ ಪ್ರಾರ್ಥಯನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ತದಾನೀಂ ಪರ್ವ್ವತಂ ನಿಕಷಾ ಬೃಹನ್ ವರಾಹವ್ರಜಶ್ಚರನ್ನಾಸೀತ್| ");
INSERT INTO sankan_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ತಸ್ಮಾದ್ ಭೂತಾ ವಿನಯೇನ ಜಗದುಃ, ಅಮುಂ ವರಾಹವ್ರಜಮ್ ಆಶ್ರಯಿತುಮ್ ಅಸ್ಮಾನ್ ಪ್ರಹಿಣು| ");
INSERT INTO sankan_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ಯೀಶುನಾನುಜ್ಞಾತಾಸ್ತೇಽಪವಿತ್ರಭೂತಾ ಬಹಿರ್ನಿರ್ಯಾಯ ವರಾಹವ್ರಜಂ ಪ್ರಾವಿಶನ್ ತತಃ ಸರ್ವ್ವೇ ವರಾಹಾ ವಸ್ತುತಸ್ತು ಪ್ರಾಯೋದ್ವಿಸಹಸ್ರಸಂಙ್ಖ್ಯಕಾಃ ಕಟಕೇನ ಮಹಾಜವಾದ್ ಧಾವನ್ತಃ ಸಿನ್ಧೌ ಪ್ರಾಣಾನ್ ಜಹುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ತಸ್ಮಾದ್ ವರಾಹಪಾಲಕಾಃ ಪಲಾಯಮಾನಾಃ ಪುರೇ ಗ್ರಾಮೇ ಚ ತದ್ವಾರ್ತ್ತಂ ಕಥಯಾಞ್ಚಕ್ರುಃ| ತದಾ ಲೋಕಾ ಘಟಿತಂ ತತ್ಕಾರ್ಯ್ಯಂ ದ್ರಷ್ಟುಂ ಬಹಿರ್ಜಗ್ಮುಃ ");
INSERT INTO sankan_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ಯೀಶೋಃ ಸನ್ನಿಧಿಂ ಗತ್ವಾ ತಂ ಭೂತಗ್ರಸ್ತಮ್ ಅರ್ಥಾದ್ ಬಾಹಿನೀಭೂತಗ್ರಸ್ತಂ ನರಂ ಸವಸ್ತ್ರಂ ಸಚೇತನಂ ಸಮುಪವಿಷ್ಟಞ್ಚ ದೃृಷ್ಟ್ವಾ ಬಿಭ್ಯುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ತತೋ ದೃಷ್ಟತತ್ಕಾರ್ಯ್ಯಲೋಕಾಸ್ತಸ್ಯ ಭೂತಗ್ರಸ್ತನರಸ್ಯ ವರಾಹವ್ರಜಸ್ಯಾಪಿ ತಾಂ ಧಟನಾಂ ವರ್ಣಯಾಮಾಸುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ತತಸ್ತೇ ಸ್ವಸೀಮಾತೋ ಬಹಿರ್ಗನ್ತುಂ ಯೀಶುಂ ವಿನೇತುಮಾರೇಭಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ಅಥ ತಸ್ಯ ನೌಕಾರೋಹಣಕಾಲೇ ಸ ಭೂತಮುಕ್ತೋ ನಾ ಯೀಶುನಾ ಸಹ ಸ್ಥಾತುಂ ಪ್ರಾರ್ಥಯತೇ; ");
INSERT INTO sankan_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","ಕಿನ್ತು ಸ ತಮನನುಮತ್ಯ ಕಥಿತವಾನ್ ತ್ವಂ ನಿಜಾತ್ಮೀಯಾನಾಂ ಸಮೀಪಂ ಗೃಹಞ್ಚ ಗಚ್ಛ ಪ್ರಭುಸ್ತ್ವಯಿ ಕೃಪಾಂ ಕೃತ್ವಾ ಯಾನಿ ಕರ್ಮ್ಮಾಣಿ ಕೃತವಾನ್ ತಾನಿ ತಾನ್ ಜ್ಞಾಪಯ| ");
INSERT INTO sankan_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ಅತಃ ಸ ಪ್ರಸ್ಥಾಯ ಯೀಶುನಾ ಕೃತಂ ತತ್ಸರ್ವ್ವಾಶ್ಚರ್ಯ್ಯಂ ಕರ್ಮ್ಮ ದಿಕಾಪಲಿದೇಶೇ ಪ್ರಚಾರಯಿತುಂ ಪ್ರಾರಬ್ಧವಾನ್ ತತಃ ಸರ್ವ್ವೇ ಲೋಕಾ ಆಶ್ಚರ್ಯ್ಯಂ ಮೇನಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","ಅನನ್ತರಂ ಯೀಶೌ ನಾವಾ ಪುನರನ್ಯಪಾರ ಉತ್ತೀರ್ಣೇ ಸಿನ್ಧುತಟೇ ಚ ತಿಷ್ಠತಿ ಸತಿ ತತ್ಸಮೀಪೇ ಬಹುಲೋಕಾನಾಂ ಸಮಾಗಮೋಽಭೂತ್| ");
INSERT INTO sankan_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ಅಪರಂ ಯಾಯೀರ್ ನಾಮ್ನಾ ಕಶ್ಚಿದ್ ಭಜನಗೃಹಸ್ಯಾಧಿಪ ಆಗತ್ಯ ತಂ ದೃಷ್ಟ್ವೈವ ಚರಣಯೋಃ ಪತಿತ್ವಾ ಬಹು ನಿವೇದ್ಯ ಕಥಿತವಾನ್; ");
INSERT INTO sankan_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ಮಮ ಕನ್ಯಾ ಮೃತಪ್ರಾಯಾಭೂದ್ ಅತೋ ಭವಾನೇತ್ಯ ತದಾರೋಗ್ಯಾಯ ತಸ್ಯಾ ಗಾತ್ರೇ ಹಸ್ತಮ್ ಅರ್ಪಯತು ತೇನೈವ ಸಾ ಜೀವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ತದಾ ಯೀಶುಸ್ತೇನ ಸಹ ಚಲಿತಃ ಕಿನ್ತು ತತ್ಪಶ್ಚಾದ್ ಬಹುಲೋಕಾಶ್ಚಲಿತ್ವಾ ತಾದ್ಗಾತ್ರೇ ಪತಿತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","ಅಥ ದ್ವಾದಶವರ್ಷಾಣಿ ಪ್ರದರರೋಗೇಣ ");
INSERT INTO sankan_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ಶೀರ್ಣಾ ಚಿಕಿತ್ಸಕಾನಾಂ ನಾನಾಚಿಕಿತ್ಸಾಭಿಶ್ಚ ದುಃಖಂ ಭುಕ್ತವತೀ ಚ ಸರ್ವ್ವಸ್ವಂ ವ್ಯಯಿತ್ವಾಪಿ ನಾರೋಗ್ಯಂ ಪ್ರಾಪ್ತಾ ಚ ಪುನರಪಿ ಪೀಡಿತಾಸೀಚ್ಚ ");
INSERT INTO sankan_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ಯಾ ಸ್ತ್ರೀ ಸಾ ಯೀಶೋ ರ್ವಾರ್ತ್ತಾಂ ಪ್ರಾಪ್ಯ ಮನಸಾಕಥಯತ್ ಯದ್ಯಹಂ ತಸ್ಯ ವಸ್ತ್ರಮಾತ್ರ ಸ್ಪ್ರಷ್ಟುಂ ಲಭೇಯಂ ತದಾ ರೋಗಹೀನಾ ಭವಿಷ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ಅತೋಹೇತೋಃ ಸಾ ಲೋಕಾರಣ್ಯಮಧ್ಯೇ ತತ್ಪಶ್ಚಾದಾಗತ್ಯ ತಸ್ಯ ವಸ್ತ್ರಂ ಪಸ್ಪರ್ಶ| ");
INSERT INTO sankan_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ತೇನೈವ ತತ್ಕ್ಷಣಂ ತಸ್ಯಾ ರಕ್ತಸ್ರೋತಃ ಶುಷ್ಕಂ ಸ್ವಯಂ ತಸ್ಮಾದ್ ರೋಗಾನ್ಮುಕ್ತಾ ಇತ್ಯಪಿ ದೇಹೇಽನುಭೂತಾ| ");
INSERT INTO sankan_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","ಅಥ ಸ್ವಸ್ಮಾತ್ ಶಕ್ತಿ ರ್ನಿರ್ಗತಾ ಯೀಶುರೇತನ್ಮನಸಾ ಜ್ಞಾತ್ವಾ ಲೋಕನಿವಹಂ ಪ್ರತಿ ಮುಖಂ ವ್ಯಾವೃತ್ಯ ಪೃಷ್ಟವಾನ್ ಕೇನ ಮದ್ವಸ್ತ್ರಂ ಸ್ಪೃಷ್ಟಂ? ");
INSERT INTO sankan_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ತತಸ್ತಸ್ಯ ಶಿಷ್ಯಾ ಊಚುಃ ಭವತೋ ವಪುಷಿ ಲೋಕಾಃ ಸಂಘರ್ಷನ್ತಿ ತದ್ ದೃಷ್ಟ್ವಾ ಕೇನ ಮದ್ವಸ್ತ್ರಂ ಸ್ಪೃಷ್ಟಮಿತಿ ಕುತಃ ಕಥಯತಿ? ");
INSERT INTO sankan_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","ಕಿನ್ತು ಕೇನ ತತ್ ಕರ್ಮ್ಮ ಕೃತಂ ತದ್ ದ್ರಷ್ಟುಂ ಯೀಶುಶ್ಚತುರ್ದಿಶೋ ದೃಷ್ಟವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ತತಃ ಸಾ ಸ್ತ್ರೀ ಭೀತಾ ಕಮ್ಪಿತಾ ಚ ಸತೀ ಸ್ವಸ್ಯಾ ರುಕ್ಪ್ರತಿಕ್ರಿಯಾ ಜಾತೇತಿ ಜ್ಞಾತ್ವಾಗತ್ಯ ತತ್ಸಮ್ಮುಖೇ ಪತಿತ್ವಾ ಸರ್ವ್ವವೃತ್ತಾನ್ತಂ ಸತ್ಯಂ ತಸ್ಮೈ ಕಥಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ತದಾನೀಂ ಯೀಶುಸ್ತಾಂ ಗದಿತವಾನ್, ಹೇ ಕನ್ಯೇ ತವ ಪ್ರತೀತಿಸ್ತ್ವಾಮ್ ಅರೋಗಾಮಕರೋತ್ ತ್ವಂ ಕ್ಷೇಮೇಣ ವ್ರಜ ಸ್ವರೋಗಾನ್ಮುಕ್ತಾ ಚ ತಿಷ್ಠ| ");
INSERT INTO sankan_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ಇತಿವಾಕ್ಯವದನಕಾಲೇ ಭಜನಗೃಹಾಧಿಪಸ್ಯ ನಿವೇಶನಾಲ್ ಲೋಕಾ ಏತ್ಯಾಧಿಪಂ ಬಭಾಷಿರೇ ತವ ಕನ್ಯಾ ಮೃತಾ ತಸ್ಮಾದ್ ಗುರುಂ ಪುನಃ ಕುತಃ ಕ್ಲಿಶ್ನಾಸಿ? ");
INSERT INTO sankan_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","ಕಿನ್ತು ಯೀಶುಸ್ತದ್ ವಾಕ್ಯಂ ಶ್ರುತ್ವೈವ ಭಜನಗೃಹಾಧಿಪಂ ಗದಿತವಾನ್ ಮಾ ಭೈಷೀಃ ಕೇವಲಂ ವಿಶ್ವಾಸಿಹಿ| ");
INSERT INTO sankan_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","ಅಥ ಪಿತರೋ ಯಾಕೂಬ್ ತದ್ಭ್ರಾತಾ ಯೋಹನ್ ಚ ಏತಾನ್ ವಿನಾ ಕಮಪಿ ಸ್ವಪಶ್ಚಾದ್ ಯಾತುಂ ನಾನ್ವಮನ್ಯತ| ");
INSERT INTO sankan_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ತಸ್ಯ ಭಜನಗೃಹಾಧಿಪಸ್ಯ ನಿವೇಶನಸಮೀಪಮ್ ಆಗತ್ಯ ಕಲಹಂ ಬಹುರೋದನಂ ವಿಲಾಪಞ್ಚ ಕುರ್ವ್ವತೋ ಲೋಕಾನ್ ದದರ್ಶ| ");
INSERT INTO sankan_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ತಸ್ಮಾನ್ ನಿವೇಶನಂ ಪ್ರವಿಶ್ಯ ಪ್ರೋಕ್ತವಾನ್ ಯೂಯಂ ಕುತ ಇತ್ಥಂ ಕಲಹಂ ರೋದನಞ್ಚ ಕುರುಥ? ಕನ್ಯಾ ನ ಮೃತಾ ನಿದ್ರಾತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","ತಸ್ಮಾತ್ತೇ ತಮುಪಜಹಸುಃ ಕಿನ್ತು ಯೀಶುಃ ಸರ್ವ್ವಾನ ಬಹಿಷ್ಕೃತ್ಯ ಕನ್ಯಾಯಾಃ ಪಿತರೌ ಸ್ವಸಙ್ಗಿನಶ್ಚ ಗೃಹೀತ್ವಾ ಯತ್ರ ಕನ್ಯಾಸೀತ್ ತತ್ ಸ್ಥಾನಂ ಪ್ರವಿಷ್ಟವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","ಅಥ ಸ ತಸ್ಯಾಃ ಕನ್ಯಾಯಾ ಹಸ್ತೌ ಧೃತ್ವಾ ತಾಂ ಬಭಾಷೇ ಟಾಲೀಥಾ ಕೂಮೀ, ಅರ್ಥತೋ ಹೇ ಕನ್ಯೇ ತ್ವಮುತ್ತಿಷ್ಠ ಇತ್ಯಾಜ್ಞಾಪಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ತುನೈವ ತತ್ಕ್ಷಣಂ ಸಾ ದ್ವಾದಶವರ್ಷವಯಸ್ಕಾ ಕನ್ಯಾ ಪೋತ್ಥಾಯ ಚಲಿತುಮಾರೇಭೇ, ಇತಃ ಸರ್ವ್ವೇ ಮಹಾವಿಸ್ಮಯಂ ಗತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","ತತ ಏತಸ್ಯೈ ಕಿಞ್ಚಿತ್ ಖಾದ್ಯಂ ದತ್ತೇತಿ ಕಥಯಿತ್ವಾ ಏತತ್ಕರ್ಮ್ಮ ಕಮಪಿ ನ ಜ್ಞಾಪಯತೇತಿ ದೃಢಮಾದಿಷ್ಟವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","ಅನನ್ತರಂ ಸ ತತ್ಸ್ಥಾನಾತ್ ಪ್ರಸ್ಥಾಯ ಸ್ವಪ್ರದೇಶಮಾಗತಃ ಶಿಷ್ಯಾಶ್ಚ ತತ್ಪಶ್ಚಾದ್ ಗತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ಅಥ ವಿಶ್ರಾಮವಾರೇ ಸತಿ ಸ ಭಜನಗೃಹೇ ಉಪದೇಷ್ಟುಮಾರಬ್ಧವಾನ್ ತತೋಽನೇಕೇ ಲೋಕಾಸ್ತತ್ಕಥಾಂ ಶ್ರುತ್ವಾ ವಿಸ್ಮಿತ್ಯ ಜಗದುಃ, ಅಸ್ಯ ಮನುಜಸ್ಯ ಈದೃಶೀ ಆಶ್ಚರ್ಯ್ಯಕ್ರಿಯಾ ಕಸ್ಮಾಜ್ ಜಾತಾ? ತಥಾ ಸ್ವಕರಾಭ್ಯಾಮ್ ಇತ್ಥಮದ್ಭುತಂ ಕರ್ಮ್ಮ ಕರ್ತ್ತಾुಮ್ ಏತಸ್ಮೈ ಕಥಂ ಜ್ಞಾನಂ ದತ್ತಮ್? ");
INSERT INTO sankan_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","ಕಿಮಯಂ ಮರಿಯಮಃ ಪುತ್ರಸ್ತಜ್ಞಾ ನೋ? ಕಿಮಯಂ ಯಾಕೂಬ್-ಯೋಸಿ-ಯಿಹುದಾ-ಶಿಮೋನಾಂ ಭ್ರಾತಾ ನೋ? ಅಸ್ಯ ಭಗಿನ್ಯಃ ಕಿಮಿಹಾಸ್ಮಾಭಿಃ ಸಹ ನೋ? ಇತ್ಥಂ ತೇ ತದರ್ಥೇ ಪ್ರತ್ಯೂಹಂ ಗತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ತದಾ ಯೀಶುಸ್ತೇಭ್ಯೋಽಕಥಯತ್ ಸ್ವದೇಶಂ ಸ್ವಕುಟುಮ್ಬಾನ್ ಸ್ವಪರಿಜನಾಂಶ್ಚ ವಿನಾ ಕುತ್ರಾಪಿ ಭವಿಷ್ಯದ್ವಾದೀ ಅಸತ್ಕೃತೋ ನ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ಅಪರಞ್ಚ ತೇಷಾಮಪ್ರತ್ಯಯಾತ್ ಸ ವಿಸ್ಮಿತಃ ಕಿಯತಾಂ ರೋಗಿಣಾಂ ವಪುಃಷು ಹಸ್ತಮ್ ಅರ್ಪಯಿತ್ವಾ ಕೇವಲಂ ತೇಷಾಮಾರೋಗ್ಯಕರಣಾದ್ ಅನ್ಯತ್ ಕಿಮಪಿ ಚಿತ್ರಕಾರ್ಯ್ಯಂ ಕರ್ತ್ತಾಂ ನ ಶಕ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ಅಥ ಸ ಚತುರ್ದಿಕ್ಸ್ಥ ಗ್ರಾಮಾನ್ ಭ್ರಮಿತ್ವಾ ಉಪದಿಷ್ಟವಾನ್ ");
INSERT INTO sankan_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ದ್ವಾದಶಶಿಷ್ಯಾನ್ ಆಹೂಯ ಅಮೇಧ್ಯಭೂತಾನ್ ವಶೀಕರ್ತ್ತಾಂ ಶಕ್ತಿಂ ದತ್ತ್ವಾ ತೇಷಾಂ ದ್ವೌ ದ್ವೌ ಜನೋ ಪ್ರೇಷಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ಪುನರಿತ್ಯಾದಿಶದ್ ಯೂಯಮ್ ಏಕೈಕಾಂ ಯಷ್ಟಿಂ ವಿನಾ ವಸ್ತ್ರಸಂಪುಟಃ ಪೂಪಃ ಕಟಿಬನ್ಧೇ ತಾಮ್ರಖಣ್ಡಞ್ಚ ಏಷಾಂ ಕಿಮಪಿ ಮಾ ಗ್ರಹ್ಲೀತ, ");
INSERT INTO sankan_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ಮಾರ್ಗಯಾತ್ರಾಯೈ ಪಾದೇಷೂಪಾನಹೌ ದತ್ತ್ವಾ ದ್ವೇ ಉತ್ತರೀಯೇ ಮಾ ಪರಿಧದ್ವ್ವಂ| ");
INSERT INTO sankan_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","ಅಪರಮಪ್ಯುಕ್ತಂ ತೇನ ಯೂಯಂ ಯಸ್ಯಾಂ ಪುರ್ಯ್ಯಾಂ ಯಸ್ಯ ನಿವೇಶನಂ ಪ್ರವೇಕ್ಷ್ಯಥ ತಾಂ ಪುರೀಂ ಯಾವನ್ನ ತ್ಯಕ್ಷ್ಯಥ ತಾವತ್ ತನ್ನಿವೇಶನೇ ಸ್ಥಾಸ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","ತತ್ರ ಯದಿ ಕೇಪಿ ಯುಷ್ಮಾಕಮಾತಿಥ್ಯಂ ನ ವಿದಧತಿ ಯುಷ್ಮಾಕಂ ಕಥಾಶ್ಚ ನ ಶೃಣ್ವನ್ತಿ ತರ್ಹಿ ತತ್ಸ್ಥಾನಾತ್ ಪ್ರಸ್ಥಾನಸಮಯೇ ತೇಷಾಂ ವಿರುದ್ಧಂ ಸಾಕ್ಷ್ಯಂ ದಾತುಂ ಸ್ವಪಾದಾನಾಸ್ಫಾಲ್ಯ ರಜಃ ಸಮ್ಪಾತಯತ; ಅಹಂ ಯುಷ್ಮಾನ್ ಯಥಾರ್ಥಂ ವಚ್ಮಿ ವಿಚಾರದಿನೇ ತನ್ನಗರಸ್ಯಾವಸ್ಥಾತಃ ಸಿದೋಮಾಮೋರಯೋ ರ್ನಗರಯೋರವಸ್ಥಾ ಸಹ್ಯತರಾ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","ಅಥ ತೇ ಗತ್ವಾ ಲೋಕಾನಾಂ ಮನಃಪರಾವರ್ತ್ತನೀಃ ಕಥಾ ಪ್ರಚಾರಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ಏವಮನೇಕಾನ್ ಭೂತಾಂಶ್ಚ ತ್ಯಾಜಿತವನ್ತಸ್ತಥಾ ತೈಲೇನ ಮರ್ದ್ದಯಿತ್ವಾ ಬಹೂನ್ ಜನಾನರೋಗಾನಕಾರ್ಷುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ಇತ್ಥಂ ತಸ್ಯ ಸುಖ್ಯಾತಿಶ್ಚತುರ್ದಿಶೋ ವ್ಯಾಪ್ತಾ ತದಾ ಹೇರೋದ್ ರಾಜಾ ತನ್ನಿಶಮ್ಯ ಕಥಿತವಾನ್, ಯೋಹನ್ ಮಜ್ಜಕಃ ಶ್ಮಶಾನಾದ್ ಉತ್ಥಿತ ಅತೋಹೇತೋಸ್ತೇನ ಸರ್ವ್ವಾ ಏತಾ ಅದ್ಭುತಕ್ರಿಯಾಃ ಪ್ರಕಾಶನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","ಅನ್ಯೇಽಕಥಯನ್ ಅಯಮ್ ಏಲಿಯಃ, ಕೇಪಿ ಕಥಿತವನ್ತ ಏಷ ಭವಿಷ್ಯದ್ವಾದೀ ಯದ್ವಾ ಭವಿಷ್ಯದ್ವಾದಿನಾಂ ಸದೃಶ ಏಕೋಯಮ್| ");
INSERT INTO sankan_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","ಕಿನ್ತು ಹೇರೋದ್ ಇತ್ಯಾಕರ್ಣ್ಯ ಭಾಷಿತವಾನ್ ಯಸ್ಯಾಹಂ ಶಿರಶ್ಛಿನ್ನವಾನ್ ಸ ಏವ ಯೋಹನಯಂ ಸ ಶ್ಮಶಾನಾದುದತಿಷ್ಠತ್| ");
INSERT INTO sankan_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","ಪೂರ್ವ್ವಂ ಸ್ವಭ್ರಾತುಃ ಫಿಲಿಪಸ್ಯ ಪತ್ನ್ಯಾ ಉದ್ವಾಹಂ ಕೃತವನ್ತಂ ಹೇರೋದಂ ಯೋಹನವಾದೀತ್ ಸ್ವಭಾತೃವಧೂ ರ್ನ ವಿವಾಹ್ಯಾ| ");
INSERT INTO sankan_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ಅತಃ ಕಾರಣಾತ್ ಹೇರೋದ್ ಲೋಕಂ ಪ್ರಹಿತ್ಯ ಯೋಹನಂ ಧೃತ್ವಾ ಬನ್ಧನಾಲಯೇ ಬದ್ಧವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ಹೇರೋದಿಯಾ ತಸ್ಮೈ ಯೋಹನೇ ಪ್ರಕುಪ್ಯ ತಂ ಹನ್ತುಮ್ ಐಚ್ಛತ್ ಕಿನ್ತು ನ ಶಕ್ತಾ, ");
INSERT INTO sankan_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ಯಸ್ಮಾದ್ ಹೇರೋದ್ ತಂ ಧಾರ್ಮ್ಮಿಕಂ ಸತ್ಪುರುಷಞ್ಚ ಜ್ಞಾತ್ವಾ ಸಮ್ಮನ್ಯ ರಕ್ಷಿತವಾನ್; ತತ್ಕಥಾಂ ಶ್ರುತ್ವಾ ತದನುಸಾರೇಣ ಬಹೂನಿ ಕರ್ಮ್ಮಾಣಿ ಕೃತವಾನ್ ಹೃಷ್ಟಮನಾಸ್ತದುಪದೇಶಂ ಶ್ರುತವಾಂಶ್ಚ| ");
INSERT INTO sankan_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","ಕಿನ್ತು ಹೇರೋದ್ ಯದಾ ಸ್ವಜನ್ಮದಿನೇ ಪ್ರಧಾನಲೋಕೇಭ್ಯಃ ಸೇನಾನೀಭ್ಯಶ್ಚ ಗಾಲೀಲ್ಪ್ರದೇಶೀಯಶ್ರೇಷ್ಠಲೋಕೇಭ್ಯಶ್ಚ ರಾತ್ರೌ ಭೋಜ್ಯಮೇಕಂ ಕೃತವಾನ್ ");
INSERT INTO sankan_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ತಸ್ಮಿನ್ ಶುಭದಿನೇ ಹೇರೋದಿಯಾಯಾಃ ಕನ್ಯಾ ಸಮೇತ್ಯ ತೇಷಾಂ ಸಮಕ್ಷಂ ಸಂನೃತ್ಯ ಹೇರೋದಸ್ತೇನ ಸಹೋಪವಿಷ್ಟಾನಾಞ್ಚ ತೋಷಮಜೀಜನತ್ ತತಾ ನೃಪಃ ಕನ್ಯಾಮಾಹ ಸ್ಮ ಮತ್ತೋ ಯದ್ ಯಾಚಸೇ ತದೇವ ತುಭ್ಯಂ ದಾಸ್ಯೇ| ");
INSERT INTO sankan_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ಶಪಥಂ ಕೃತ್ವಾಕಥಯತ್ ಚೇದ್ ರಾಜ್ಯಾರ್ದ್ಧಮಪಿ ಯಾಚಸೇ ತದಪಿ ತುಭ್ಯಂ ದಾಸ್ಯೇ| ");
INSERT INTO sankan_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ತತಃ ಸಾ ಬಹಿ ರ್ಗತ್ವಾ ಸ್ವಮಾತರಂ ಪಪ್ರಚ್ಛ ಕಿಮಹಂ ಯಾಚಿಷ್ಯೇ? ತದಾ ಸಾಕಥಯತ್ ಯೋಹನೋ ಮಜ್ಜಕಸ್ಯ ಶಿರಃ| ");
INSERT INTO sankan_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","ಅಥ ತೂರ್ಣಂ ಭೂಪಸಮೀಪಮ್ ಏತ್ಯ ಯಾಚಮಾನಾವದತ್ ಕ್ಷಣೇಸ್ಮಿನ್ ಯೋಹನೋ ಮಜ್ಜಕಸ್ಯ ಶಿರಃ ಪಾತ್ರೇ ನಿಧಾಯ ದೇಹಿ, ಏತದ್ ಯಾಚೇಽಹಂ| ");
INSERT INTO sankan_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ತಸ್ಮಾತ್ ಭೂಪೋಽತಿದುಃಖಿತಃ, ತಥಾಪಿ ಸ್ವಶಪಥಸ್ಯ ಸಹಭೋಜಿನಾಞ್ಚಾನುರೋಧಾತ್ ತದನಙ್ಗೀಕರ್ತ್ತುಂ ನ ಶಕ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ತತ್ಕ್ಷಣಂ ರಾಜಾ ಘಾತಕಂ ಪ್ರೇಷ್ಯ ತಸ್ಯ ಶಿರ ಆನೇತುಮಾದಿಷ್ಟವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ತತಃ ಸ ಕಾರಾಗಾರಂ ಗತ್ವಾ ತಚ್ಛಿರಶ್ಛಿತ್ವಾ ಪಾತ್ರೇ ನಿಧಾಯಾನೀಯ ತಸ್ಯೈ ಕನ್ಯಾಯೈ ದತ್ತವಾನ್ ಕನ್ಯಾ ಚ ಸ್ವಮಾತ್ರೇ ದದೌ| ");
INSERT INTO sankan_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ಅನನತರಂ ಯೋಹನಃ ಶಿಷ್ಯಾಸ್ತದ್ವಾರ್ತ್ತಾಂ ಪ್ರಾಪ್ಯಾಗತ್ಯ ತಸ್ಯ ಕುಣಪಂ ಶ್ಮಶಾನೇಽಸ್ಥಾಪಯನ್| ");
INSERT INTO sankan_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","ಅಥ ಪ್ರೇಷಿತಾ ಯೀಶೋಃ ಸನ್ನಿಧೌ ಮಿಲಿತಾ ಯದ್ ಯಚ್ ಚಕ್ರುಃ ಶಿಕ್ಷಯಾಮಾಸುಶ್ಚ ತತ್ಸರ್ವ್ವವಾರ್ತ್ತಾಸ್ತಸ್ಮೈ ಕಥಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ಸ ತಾನುವಾಚ ಯೂಯಂ ವಿಜನಸ್ಥಾನಂ ಗತ್ವಾ ವಿಶ್ರಾಮ್ಯತ ಯತಸ್ತತ್ಸನ್ನಿಧೌ ಬಹುಲೋಕಾನಾಂ ಸಮಾಗಮಾತ್ ತೇ ಭೋಕ್ತುಂ ನಾವಕಾಶಂ ಪ್ರಾಪ್ತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ತತಸ್ತೇ ನಾವಾ ವಿಜನಸ್ಥಾನಂ ಗುಪ್ತಂ ಗಗ್ಮುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ತತೋ ಲೋಕನಿವಹಸ್ತೇಷಾಂ ಸ್ಥಾನಾನ್ತರಯಾನಂ ದದರ್ಶ, ಅನೇಕೇ ತಂ ಪರಿಚಿತ್ಯ ನಾನಾಪುರೇಭ್ಯಃ ಪದೈರ್ವ್ರಜಿತ್ವಾ ಜವೇನ ತೈಷಾಮಗ್ರೇ ಯೀಶೋಃ ಸಮೀಪ ಉಪತಸ್ಥುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","ತದಾ ಯೀಶು ರ್ನಾವೋ ಬಹಿರ್ಗತ್ಯ ಲೋಕಾರಣ್ಯಾನೀಂ ದೃಷ್ಟ್ವಾ ತೇಷು ಕರುಣಾಂ ಕೃತವಾನ್ ಯತಸ್ತೇಽರಕ್ಷಕಮೇಷಾ ಇವಾಸನ್ ತದಾ ಸ ತಾನ ನಾನಾಪ್ರಸಙ್ಗಾನ್ ಉಪದಿಷ್ಟವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ಅಥ ದಿವಾನ್ತೇ ಸತಿ ಶಿಷ್ಯಾ ಏತ್ಯ ಯೀಶುಮೂಚಿರೇ, ಇದಂ ವಿಜನಸ್ಥಾನಂ ದಿನಞ್ಚಾವಸನ್ನಂ| ");
INSERT INTO sankan_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ಲೋಕಾನಾಂ ಕಿಮಪಿ ಖಾದ್ಯಂ ನಾಸ್ತಿ, ಅತಶ್ಚತುರ್ದಿಕ್ಷು ಗ್ರಾಮಾನ್ ಗನ್ತುಂ ಭೋಜ್ಯದ್ರವ್ಯಾಣಿ ಕ್ರೇತುಞ್ಚ ಭವಾನ್ ತಾನ್ ವಿಸೃಜತು| ");
INSERT INTO sankan_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ತದಾ ಸ ತಾನುವಾಚ ಯೂಯಮೇವ ತಾನ್ ಭೋಜಯತ; ತತಸ್ತೇ ಜಗದು ರ್ವಯಂ ಗತ್ವಾ ದ್ವಿಶತಸಂಖ್ಯಕೈ ರ್ಮುದ್ರಾಪಾದೈಃ ಪೂಪಾನ್ ಕ್ರೀತ್ವಾ ಕಿಂ ತಾನ್ ಭೋಜಯಿಷ್ಯಾಮಃ? ");
INSERT INTO sankan_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ತದಾ ಸ ತಾನ್ ಪೃಷ್ಠವಾನ್ ಯುಷ್ಮಾಕಂ ಸನ್ನಿಧೌ ಕತಿ ಪೂಪಾ ಆಸತೇ? ಗತ್ವಾ ಪಶ್ಯತ; ತತಸ್ತೇ ದೃಷ್ಟ್ವಾ ತಮವದನ್ ಪಞ್ಚ ಪೂಪಾ ದ್ವೌ ಮತ್ಸ್ಯೌ ಚ ಸನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","ತದಾ ಸ ಲೋಕಾನ್ ಶಸ್ಪೋಪರಿ ಪಂಕ್ತಿಭಿರುಪವೇಶಯಿತುಮ್ ಆದಿಷ್ಟವಾನ್, ");
INSERT INTO sankan_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ತತಸ್ತೇ ಶತಂ ಶತಂ ಜನಾಃ ಪಞ್ಚಾಶತ್ ಪಞ್ಚಾಶಜ್ಜನಾಶ್ಚ ಪಂಕ್ತಿಭಿ ರ್ಭುವಿ ಸಮುಪವಿವಿಶುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","ಅಥ ಸ ತಾನ್ ಪಞ್ಚಪೂಪಾನ್ ಮತ್ಸ್ಯದ್ವಯಞ್ಚ ಧೃತ್ವಾ ಸ್ವರ್ಗಂ ಪಶ್ಯನ್ ಈಶ್ವರಗುಣಾನ್ ಅನ್ವಕೀರ್ತ್ತಯತ್ ತಾನ್ ಪೂಪಾನ್ ಭಂಕ್ತ್ವಾ ಲೋಕೇಭ್ಯಃ ಪರಿವೇಷಯಿತುಂ ಶಿಷ್ಯೇಭ್ಯೋ ದತ್ತವಾನ್ ದ್ವಾ ಮತ್ಸ್ಯೌ ಚ ವಿಭಜ್ಯ ಸರ್ವ್ವೇಭ್ಯೋ ದತ್ತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ತತಃ ಸರ್ವ್ವೇ ಭುಕ್ತ್ವಾತೃಪ್ಯನ್| ");
INSERT INTO sankan_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ಅನನ್ತರಂ ಶಿಷ್ಯಾ ಅವಶಿಷ್ಟೈಃ ಪೂಪೈ ರ್ಮತ್ಸ್ಯೈಶ್ಚ ಪೂರ್ಣಾನ್ ದ್ವದಶ ಡಲ್ಲಕಾನ್ ಜಗೃಹುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","ತೇ ಭೋಕ್ತಾರಃ ಪ್ರಾಯಃ ಪಞ್ಚ ಸಹಸ್ರಾಣಿ ಪುರುಷಾ ಆಸನ್| ");
INSERT INTO sankan_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ಅಥ ಸ ಲೋಕಾನ್ ವಿಸೃಜನ್ನೇವ ನಾವಮಾರೋಢುಂ ಸ್ವಸ್ಮಾದಗ್ರೇ ಪಾರೇ ಬೈತ್ಸೈದಾಪುರಂ ಯಾತುಞ್ಚ ಶ್ಷ್ಯಿाನ್ ವಾಢಮಾದಿಷ್ಟವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ತದಾ ಸ ಸರ್ವ್ವಾನ್ ವಿಸೃಜ್ಯ ಪ್ರಾರ್ಥಯಿತುಂ ಪರ್ವ್ವತಂ ಗತಃ| ");
INSERT INTO sankan_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ತತಃ ಸನ್ಧ್ಯಾಯಾಂ ಸತ್ಯಾಂ ನೌಃ ಸಿನ್ಧುಮಧ್ಯ ಉಪಸ್ಥಿತಾ ಕಿನ್ತು ಸ ಏಕಾಕೀ ಸ್ಥಲೇ ಸ್ಥಿತಃ| ");
INSERT INTO sankan_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ಅಥ ಸಮ್ಮುಖವಾತವಹನಾತ್ ಶಿಷ್ಯಾ ನಾವಂ ವಾಹಯಿತ್ವಾ ಪರಿಶ್ರಾನ್ತಾ ಇತಿ ಜ್ಞಾತ್ವಾ ಸ ನಿಶಾಚತುರ್ಥಯಾಮೇ ಸಿನ್ಧೂಪರಿ ಪದ್ಭ್ಯಾಂ ವ್ರಜನ್ ತೇಷಾಂ ಸಮೀಪಮೇತ್ಯ ತೇಷಾಮಗ್ರೇ ಯಾತುಮ್ ಉದ್ಯತಃ| ");
INSERT INTO sankan_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ಕಿನ್ತು ಶಿಷ್ಯಾಃ ಸಿನ್ಧೂಪರಿ ತಂ ವ್ರಜನ್ತಂ ದೃಷ್ಟ್ವಾ ಭೂತಮನುಮಾಯ ರುರುವುಃ, ");
INSERT INTO sankan_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ಯತಃ ಸರ್ವ್ವೇ ತಂ ದೃಷ್ಟ್ವಾ ವ್ಯಾಕುಲಿತಾಃ| ಅತಏವ ಯೀಶುಸ್ತತ್ಕ್ಷಣಂ ತೈಃ ಸಹಾಲಪ್ಯ ಕಥಿತವಾನ್, ಸುಸ್ಥಿರಾ ಭೂತ, ಅಯಮಹಂ ಮಾ ಭೈಷ್ಟ| ");
INSERT INTO sankan_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ಅಥ ನೌಕಾಮಾರುಹ್ಯ ತಸ್ಮಿನ್ ತೇಷಾಂ ಸನ್ನಿಧಿಂ ಗತೇ ವಾತೋ ನಿವೃತ್ತಃ; ತಸ್ಮಾತ್ತೇ ಮನಃಸು ವಿಸ್ಮಿತಾ ಆಶ್ಚರ್ಯ್ಯಂ ಮೇನಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ಯತಸ್ತೇ ಮನಸಾಂ ಕಾಠಿನ್ಯಾತ್ ತತ್ ಪೂಪೀಯಮ್ ಆಶ್ಚರ್ಯ್ಯಂ ಕರ್ಮ್ಮ ನ ವಿವಿಕ್ತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ಅಥ ತೇ ಪಾರಂ ಗತ್ವಾ ಗಿನೇಷರತ್ಪ್ರದೇಶಮೇತ್ಯ ತಟ ಉಪಸ್ಥಿತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ತೇಷು ನೌಕಾತೋ ಬಹಿರ್ಗತೇಷು ತತ್ಪ್ರದೇಶೀಯಾ ಲೋಕಾಸ್ತಂ ಪರಿಚಿತ್ಯ ");
INSERT INTO sankan_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ಚತುರ್ದಿಕ್ಷು ಧಾವನ್ತೋ ಯತ್ರ ಯತ್ರ ರೋಗಿಣೋ ನರಾ ಆಸನ್ ತಾನ್ ಸರ್ವ್ವಾನ ಖಟ್ವೋಪರಿ ನಿಧಾಯ ಯತ್ರ ಕುತ್ರಚಿತ್ ತದ್ವಾರ್ತ್ತಾಂ ಪ್ರಾಪುಃ ತತ್ ಸ್ಥಾನಮ್ ಆನೇತುಮ್ ಆರೇಭಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","ತಥಾ ಯತ್ರ ಯತ್ರ ಗ್ರಾಮೇ ಯತ್ರ ಯತ್ರ ಪುರೇ ಯತ್ರ ಯತ್ರ ಪಲ್ಲ್ಯಾಞ್ಚ ತೇನ ಪ್ರವೇಶಃ ಕೃತಸ್ತದ್ವರ್ತ್ಮಮಧ್ಯೇ ಲೋಕಾಃ ಪೀಡಿತಾನ್ ಸ್ಥಾಪಯಿತ್ವಾ ತಸ್ಯ ಚೇಲಗ್ರನ್ಥಿಮಾತ್ರಂ ಸ್ಪ್ರಷ್ಟುಮ್ ತೇಷಾಮರ್ಥೇ ತದನುಜ್ಞಾಂ ಪ್ರಾರ್ಥಯನ್ತಃ ಯಾವನ್ತೋ ಲೋಕಾಃ ಪಸ್ಪೃಶುಸ್ತಾವನ್ತ ಏವ ಗದಾನ್ಮುಕ್ತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","ಅನನ್ತರಂ ಯಿರೂಶಾಲಮ ಆಗತಾಃ ಫಿರೂಶಿನೋಽಧ್ಯಾಪಕಾಶ್ಚ ಯೀಶೋಃ ಸಮೀಪಮ್ ಆಗತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ತೇ ತಸ್ಯ ಕಿಯತಃ ಶಿಷ್ಯಾನ್ ಅಶುಚಿಕರೈರರ್ಥಾದ ಅಪ್ರಕ್ಷಾಲಿತಹಸ್ತೈ ರ್ಭುಞ್ಜತೋ ದೃಷ್ಟ್ವಾ ತಾನದೂಷಯನ್| ");
INSERT INTO sankan_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ಯತಃ ಫಿರೂಶಿನಃ ಸರ್ವ್ವಯಿಹೂದೀಯಾಶ್ಚ ಪ್ರಾಚಾಂ ಪರಮ್ಪರಾಗತವಾಕ್ಯಂ ಸಮ್ಮನ್ಯ ಪ್ರತಲೇನ ಹಸ್ತಾನ್ ಅಪ್ರಕ್ಷಾಲ್ಯ ನ ಭುಞ್ಜತೇ| ");
INSERT INTO sankan_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ಆಪನಾದಾಗತ್ಯ ಮಜ್ಜನಂ ವಿನಾ ನ ಖಾದನ್ತಿ; ತಥಾ ಪಾನಪಾತ್ರಾಣಾಂ ಜಲಪಾತ್ರಾಣಾಂ ಪಿತ್ತಲಪಾತ್ರಾಣಾಮ್ ಆಸನಾನಾಞ್ಚ ಜಲೇ ಮಜ್ಜನಮ್ ಇತ್ಯಾದಯೋನ್ಯೇಪಿ ಬಹವಸ್ತೇಷಾಮಾಚಾರಾಃ ಸನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ತೇ ಫಿರೂಶಿನೋಽಧ್ಯಾಪಕಾಶ್ಚ ಯೀಶುಂ ಪಪ್ರಚ್ಛುಃ, ತವ ಶಿಷ್ಯಾಃ ಪ್ರಾಚಾಂ ಪರಮ್ಪರಾಗತವಾಕ್ಯಾನುಸಾರೇಣ ನಾಚರನ್ತೋಽಪ್ರಕ್ಷಾಲಿತಕರೈಃ ಕುತೋ ಭುಜಂತೇ? ");
INSERT INTO sankan_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ತತಃ ಸ ಪ್ರತ್ಯುವಾಚ ಕಪಟಿನೋ ಯುಷ್ಮಾನ್ ಉದ್ದಿಶ್ಯ ಯಿಶಯಿಯಭವಿಷ್ಯದ್ವಾದೀ ಯುಕ್ತಮವಾದೀತ್| ಯಥಾ ಸ್ವಕೀಯೈರಧರೈರೇತೇ ಸಮ್ಮನ್ಯನತೇ ಸದೈವ ಮಾಂ| ಕಿನ್ತು ಮತ್ತೋ ವಿಪ್ರಕರ್ಷೇ ಸನ್ತಿ ತೇಷಾಂ ಮನಾಂಸಿ ಚ| ");
INSERT INTO sankan_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ಶಿಕ್ಷಯನ್ತೋ ಬಿಧೀನ್ ನ್ನಾಜ್ಞಾ ಭಜನ್ತೇ ಮಾಂ ಮುಧೈವ ತೇ| ");
INSERT INTO sankan_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","ಯೂಯಂ ಜಲಪಾತ್ರಪಾನಪಾತ್ರಾದೀನಿ ಮಜ್ಜಯನ್ತೋ ಮನುಜಪರಮ್ಪರಾಗತವಾಕ್ಯಂ ರಕ್ಷಥ ಕಿನ್ತು ಈಶ್ವರಾಜ್ಞಾಂ ಲಂಘಧ್ವೇ; ಅಪರಾ ಈದೃಶ್ಯೋನೇಕಾಃ ಕ್ರಿಯಾ ಅಪಿ ಕುರುಧ್ವೇ| ");
INSERT INTO sankan_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","ಅನ್ಯಞ್ಚಾಕಥಯತ್ ಯೂಯಂ ಸ್ವಪರಮ್ಪರಾಗತವಾಕ್ಯಸ್ಯ ರಕ್ಷಾರ್ಥಂ ಸ್ಪಷ್ಟರೂಪೇಣ ಈಶ್ವರಾಜ್ಞಾಂ ಲೋಪಯಥ| ");
INSERT INTO sankan_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","ಯತೋ ಮೂಸಾದ್ವಾರಾ ಪ್ರೋಕ್ತಮಸ್ತಿ ಸ್ವಪಿತರೌ ಸಮ್ಮನ್ಯಧ್ವಂ ಯಸ್ತು ಮಾತರಂ ಪಿತರಂ ವಾ ದುರ್ವ್ವಾಕ್ಯಂ ವಕ್ತಿ ಸ ನಿತಾನ್ತಂ ಹನ್ಯತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","ಕಿನ್ತು ಮದೀಯೇನ ಯೇನ ದ್ರವ್ಯೇಣ ತವೋಪಕಾರೋಭವತ್ ತತ್ ಕರ್ಬ್ಬಾಣಮರ್ಥಾದ್ ಈಶ್ವರಾಯ ನಿವೇದಿತಮ್ ಇದಂ ವಾಕ್ಯಂ ಯದಿ ಕೋಪಿ ಪಿತರಂ ಮಾತರಂ ವಾ ವಕ್ತಿ ");
INSERT INTO sankan_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ತರ್ಹಿ ಯೂಯಂ ಮಾತುಃ ಪಿತು ರ್ವೋಪಕಾರಂ ಕರ್ತ್ತಾಂ ತಂ ವಾರಯಥ| ");
INSERT INTO sankan_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ಇತ್ಥಂ ಸ್ವಪ್ರಚಾರಿತಪರಮ್ಪರಾಗತವಾಕ್ಯೇನ ಯೂಯಮ್ ಈಶ್ವರಾಜ್ಞಾಂ ಮುಧಾ ವಿಧದ್ವ್ವೇ, ಈದೃಶಾನ್ಯನ್ಯಾನ್ಯನೇಕಾನಿ ಕರ್ಮ್ಮಾಣಿ ಕುರುಧ್ವೇ| ");
INSERT INTO sankan_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","ಅಥ ಸ ಲೋಕಾನಾಹೂಯ ಬಭಾಷೇ ಯೂಯಂ ಸರ್ವ್ವೇ ಮದ್ವಾಕ್ಯಂ ಶೃಣುತ ಬುಧ್ಯಧ್ವಞ್ಚ| ");
INSERT INTO sankan_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ಬಾಹ್ಯಾದನ್ತರಂ ಪ್ರವಿಶ್ಯ ನರಮಮೇಧ್ಯಂ ಕರ್ತ್ತಾಂ ಶಕ್ನೋತಿ ಈದೃಶಂ ಕಿಮಪಿ ವಸ್ತು ನಾಸ್ತಿ, ವರಮ್ ಅನ್ತರಾದ್ ಬಹಿರ್ಗತಂ ಯದ್ವಸ್ತು ತನ್ಮನುಜಮ್ ಅಮೇಧ್ಯಂ ಕರೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","ಯಸ್ಯ ಶ್ರೋತುಂ ಶ್ರೋತ್ರೇ ಸ್ತಃ ಸ ಶೃಣೋತು| ");
INSERT INTO sankan_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ತತಃ ಸ ಲೋಕಾನ್ ಹಿತ್ವಾ ಗೃಹಮಧ್ಯಂ ಪ್ರವಿಷ್ಟಸ್ತದಾ ಶಿಷ್ಯಾಸ್ತದೃಷ್ಟಾನ್ತವಾಕ್ಯಾರ್ಥಂ ಪಪ್ರಚ್ಛುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","ತಸ್ಮಾತ್ ಸ ತಾನ್ ಜಗಾದ ಯೂಯಮಪಿ ಕಿಮೇತಾದೃಗಬೋಧಾಃ? ಕಿಮಪಿ ದ್ರವ್ಯಂ ಬಾಹ್ಯಾದನ್ತರಂ ಪ್ರವಿಶ್ಯ ನರಮಮೇಧ್ಯಂ ಕರ್ತ್ತಾಂ ನ ಶಕ್ನೋತಿ ಕಥಾಮಿಮಾಂ ಕಿಂ ನ ಬುಧ್ಯಧ್ವೇ? ");
INSERT INTO sankan_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ತತ್ ತದನ್ತರ್ನ ಪ್ರವಿಶತಿ ಕಿನ್ತು ಕುಕ್ಷಿಮಧ್ಯಂ ಪ್ರವಿಶತಿ ಶೇಷೇ ಸರ್ವ್ವಭುಕ್ತವಸ್ತುಗ್ರಾಹಿಣಿ ಬಹಿರ್ದೇಶೇ ನಿರ್ಯಾತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ಅಪರಮಪ್ಯವಾದೀದ್ ಯನ್ನರಾನ್ನಿರೇತಿ ತದೇವ ನರಮಮೇಧ್ಯಂ ಕರೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ಯತೋಽನ್ತರಾದ್ ಅರ್ಥಾನ್ ಮಾನವಾನಾಂ ಮನೋಭ್ಯಃ ಕುಚಿನ್ತಾ ಪರಸ್ತ್ರೀವೇಶ್ಯಾಗಮನಂ ");
INSERT INTO sankan_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ನರವಧಶ್ಚೌರ್ಯ್ಯಂ ಲೋಭೋ ದುಷ್ಟತಾ ಪ್ರವಞ್ಚನಾ ಕಾಮುಕತಾ ಕುದೃಷ್ಟಿರೀಶ್ವರನಿನ್ದಾ ಗರ್ವ್ವಸ್ತಮ ಇತ್ಯಾದೀನಿ ನಿರ್ಗಚ್ಛನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ಏತಾನಿ ಸರ್ವ್ವಾಣಿ ದುರಿತಾನ್ಯನ್ತರಾದೇತ್ಯ ನರಮಮೇಧ್ಯಂ ಕುರ್ವ್ವನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","ಅಥ ಸ ಉತ್ಥಾಯ ತತ್ಸ್ಥಾನಾತ್ ಸೋರಸೀದೋನ್ಪುರಪ್ರದೇಶಂ ಜಗಾಮ ತತ್ರ ಕಿಮಪಿ ನಿವೇಶನಂ ಪ್ರವಿಶ್ಯ ಸರ್ವ್ವೈರಜ್ಞಾತಃ ಸ್ಥಾತುಂ ಮತಿಞ್ಚಕ್ರೇ ಕಿನ್ತು ಗುಪ್ತಃ ಸ್ಥಾತುಂ ನ ಶಶಾಕ| ");
INSERT INTO sankan_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ಯತಃ ಸುರಫೈನಿಕೀದೇಶೀಯಯೂನಾನೀವಂಶೋದ್ಭವಸ್ತ್ರಿಯಾಃ ಕನ್ಯಾ ಭೂತಗ್ರಸ್ತಾಸೀತ್| ಸಾ ಸ್ತ್ರೀ ತದ್ವಾರ್ತ್ತಾಂ ಪ್ರಾಪ್ಯ ತತ್ಸಮೀಪಮಾಗತ್ಯ ತಚ್ಚರಣಯೋಃ ಪತಿತ್ವಾ ");
INSERT INTO sankan_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ಸ್ವಕನ್ಯಾತೋ ಭೂತಂ ನಿರಾಕರ್ತ್ತಾಂ ತಸ್ಮಿನ್ ವಿನಯಂ ಕೃತವತೀ| ");
INSERT INTO sankan_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ಕಿನ್ತು ಯೀಶುಸ್ತಾಮವದತ್ ಪ್ರಥಮಂ ಬಾಲಕಾಸ್ತೃಪ್ಯನ್ತು ಯತೋ ಬಾಲಕಾನಾಂ ಖಾದ್ಯಂ ಗೃಹೀತ್ವಾ ಕುಕ್ಕುರೇಭ್ಯೋ ನಿಕ್ಷೇಪೋಽನುಚಿತಃ| ");
INSERT INTO sankan_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","ತದಾ ಸಾ ಸ್ತ್ರೀ ತಮವಾದೀತ್ ಭೋಃ ಪ್ರಭೋ ತತ್ ಸತ್ಯಂ ತಥಾಪಿ ಮಞ್ಚಾಧಃಸ್ಥಾಃ ಕುಕ್ಕುರಾ ಬಾಲಾನಾಂ ಕರಪತಿತಾನಿ ಖಾದ್ಯಖಣ್ಡಾನಿ ಖಾದನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ತತಃ ಸೋಽಕಥಯದ್ ಏತತ್ಕಥಾಹೇತೋಃ ಸಕುಶಲಾ ಯಾಹಿ ತವ ಕನ್ಯಾಂ ತ್ಯಕ್ತ್ವಾ ಭೂತೋ ಗತಃ| ");
INSERT INTO sankan_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ಅಥ ಸಾ ಸ್ತ್ರೀ ಗೃಹಂ ಗತ್ವಾ ಕನ್ಯಾಂ ಭೂತತ್ಯಕ್ತಾಂ ಶಯ್ಯಾಸ್ಥಿತಾಂ ದದರ್ಶ| ");
INSERT INTO sankan_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","ಪುನಶ್ಚ ಸ ಸೋರಸೀದೋನ್ಪುರಪ್ರದೇಶಾತ್ ಪ್ರಸ್ಥಾಯ ದಿಕಾಪಲಿದೇಶಸ್ಯ ಪ್ರಾನ್ತರಭಾಗೇನ ಗಾಲೀಲ್ಜಲಧೇಃ ಸಮೀಪಂ ಗತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ತದಾ ಲೋಕೈರೇಕಂ ಬಧಿರಂ ಕದ್ವದಞ್ಚ ನರಂ ತನ್ನಿಕಟಮಾನೀಯ ತಸ್ಯ ಗಾತ್ರೇ ಹಸ್ತಮರ್ಪಯಿತುಂ ವಿನಯಃ ಕೃತಃ| ");
INSERT INTO sankan_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ತತೋ ಯೀಶು ರ್ಲೋಕಾರಣ್ಯಾತ್ ತಂ ನಿರ್ಜನಮಾನೀಯ ತಸ್ಯ ಕರ್ಣಯೋಙ್ಗುಲೀ ರ್ದದೌ ನಿಷ್ಠೀವಂ ದತ್ತ್ವಾ ಚ ತಜ್ಜಿಹ್ವಾಂ ಪಸ್ಪರ್ಶ| ");
INSERT INTO sankan_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ಅನನ್ತರಂ ಸ್ವರ್ಗಂ ನಿರೀಕ್ಷ್ಯ ದೀರ್ಘಂ ನಿಶ್ವಸ್ಯ ತಮವದತ್ ಇತಫತಃ ಅರ್ಥಾನ್ ಮುಕ್ತೋ ಭೂಯಾತ್| ");
INSERT INTO sankan_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ತತಸ್ತತ್ಕ್ಷಣಂ ತಸ್ಯ ಕರ್ಣೌ ಮುಕ್ತೌ ಜಿಹ್ವಾಯಾಶ್ಚ ಜಾಡ್ಯಾಪಗಮಾತ್ ಸ ಸುಸ್ಪಷ್ಟವಾಕ್ಯಮಕಥಯತ್| ");
INSERT INTO sankan_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","ಅಥ ಸ ತಾನ್ ವಾಢಮಿತ್ಯಾದಿದೇಶ ಯೂಯಮಿಮಾಂ ಕಥಾಂ ಕಸ್ಮೈಚಿದಪಿ ಮಾ ಕಥಯತ, ಕಿನ್ತು ಸ ಯತಿ ನ್ಯಷೇಧತ್ ತೇ ತತಿ ಬಾಹುಲ್ಯೇನ ಪ್ರಾಚಾರಯನ್; ");
INSERT INTO sankan_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ತೇಽತಿಚಮತ್ಕೃತ್ಯ ಪರಸ್ಪರಂ ಕಥಯಾಮಾಸುಃ ಸ ಬಧಿರಾಯ ಶ್ರವಣಶಕ್ತಿಂ ಮೂಕಾಯ ಚ ಕಥನಶಕ್ತಿಂ ದತ್ತ್ವಾ ಸರ್ವ್ವಂ ಕರ್ಮ್ಮೋತ್ತಮರೂಪೇಣ ಚಕಾರ| ");
INSERT INTO sankan_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ತದಾ ತತ್ಸಮೀಪಂ ಬಹವೋ ಲೋಕಾ ಆಯಾತಾ ಅತಸ್ತೇಷಾಂ ಭೋಜ್ಯದ್ರವ್ಯಾಭಾವಾದ್ ಯೀಶುಃ ಶಿಷ್ಯಾನಾಹೂಯ ಜಗಾದ,| ");
INSERT INTO sankan_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","ಲೋಕನಿವಹೇ ಮಮ ಕೃಪಾ ಜಾಯತೇ ತೇ ದಿನತ್ರಯಂ ಮಯಾ ಸಾರ್ದ್ಧಂ ಸನ್ತಿ ತೇಷಾಂ ಭೋಜ್ಯಂ ಕಿಮಪಿ ನಾಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ತೇಷಾಂ ಮಧ್ಯೇಽನೇಕೇ ದೂರಾದ್ ಆಗತಾಃ, ಅಭುಕ್ತೇಷು ತೇಷು ಮಯಾ ಸ್ವಗೃಹಮಭಿಪ್ರಹಿತೇಷು ತೇ ಪಥಿ ಕ್ಲಮಿಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ಶಿಷ್ಯಾ ಅವಾದಿಷುಃ, ಏತಾವತೋ ಲೋಕಾನ್ ತರ್ಪಯಿತುಮ್ ಅತ್ರ ಪ್ರನ್ತರೇ ಪೂಪಾನ್ ಪ್ರಾಪ್ತುಂ ಕೇನ ಶಕ್ಯತೇ? ");
INSERT INTO sankan_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ತತಃ ಸ ತಾನ್ ಪಪ್ರಚ್ಛ ಯುಷ್ಮಾಕಂ ಕತಿ ಪೂಪಾಃ ಸನ್ತಿ? ತೇಽಕಥಯನ್ ಸಪ್ತ| ");
INSERT INTO sankan_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","ತತಃ ಸ ತಾಲ್ಲೋಕಾನ್ ಭುವಿ ಸಮುಪವೇಷ್ಟುಮ್ ಆದಿಶ್ಯ ತಾನ್ ಸಪ್ತ ಪೂಪಾನ್ ಧೃತ್ವಾ ಈಶ್ವರಗುಣಾನ್ ಅನುಕೀರ್ತ್ತಯಾಮಾಸ, ಭಂಕ್ತ್ವಾ ಪರಿವೇಷಯಿತುಂ ಶಿಷ್ಯಾನ್ ಪ್ರತಿ ದದೌ, ತತಸ್ತೇ ಲೋಕೇಭ್ಯಃ ಪರಿವೇಷಯಾಮಾಸುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ತಥಾ ತೇಷಾಂ ಸಮೀಪೇ ಯೇ ಕ್ಷುದ್ರಮತ್ಸ್ಯಾ ಆಸನ್ ತಾನಪ್ಯಾದಾಯ ಈಶ್ವರಗುಣಾನ್ ಸಂಕೀರ್ತ್ಯ ಪರಿವೇಷಯಿತುಮ್ ಆದಿಷ್ಟವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ತತೋ ಲೋಕಾ ಭುಕ್ತ್ವಾ ತೃಪ್ತಿಂ ಗತಾ ಅವಶಿಷ್ಟಖಾದ್ಯೈಃ ಪೂರ್ಣಾಃ ಸಪ್ತಡಲ್ಲಕಾ ಗೃಹೀತಾಶ್ಚ| ");
INSERT INTO sankan_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ಏತೇ ಭೋಕ್ತಾರಃ ಪ್ರಾಯಶ್ಚತುಃ ಸಹಸ್ರಪುರುಷಾ ಆಸನ್ ತತಃ ಸ ತಾನ್ ವಿಸಸರ್ಜ| ");
INSERT INTO sankan_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ಅಥ ಸ ಶಿಷ್ಯಃ ಸಹ ನಾವಮಾರುಹ್ಯ ದಲ್ಮಾನೂಥಾಸೀಮಾಮಾಗತಃ| ");
INSERT INTO sankan_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ತತಃ ಪರಂ ಫಿರೂಶಿನ ಆಗತ್ಯ ತೇನ ಸಹ ವಿವದಮಾನಾಸ್ತಸ್ಯ ಪರೀಕ್ಷಾರ್ಥಮ್ ಆಕಾಶೀಯಚಿಹ್ನಂ ದ್ರಷ್ಟುಂ ಯಾಚಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","ತದಾ ಸೋಽನ್ತರ್ದೀರ್ಘಂ ನಿಶ್ವಸ್ಯಾಕಥಯತ್, ಏತೇ ವಿದ್ಯಮಾನನರಾಃ ಕುತಶ್ಚಿನ್ಹಂ ಮೃಗಯನ್ತೇ? ಯುಷ್ಮಾನಹಂ ಯಥಾರ್ಥಂ ಬ್ರವೀಮಿ ಲೋಕಾನೇತಾನ್ ಕಿಮಪಿ ಚಿಹ್ನಂ ನ ದರ್ಶಯಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ಅಥ ತಾನ್ ಹಿತ್ವಾ ಪುನ ರ್ನಾವಮ್ ಆರುಹ್ಯ ಪಾರಮಗಾತ್| ");
INSERT INTO sankan_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ಏತರ್ಹಿ ಶಿಷ್ಯೈಃ ಪೂಪೇಷು ವಿಸ್ಮೃತೇಷು ನಾವಿ ತೇಷಾಂ ಸನ್ನಿಧೌ ಪೂಪ ಏಕಏವ ಸ್ಥಿತಃ| ");
INSERT INTO sankan_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ತದಾನೀಂ ಯೀಶುಸ್ತಾನ್ ಆದಿಷ್ಟವಾನ್ ಫಿರೂಶಿನಾಂ ಹೇರೋದಶ್ಚ ಕಿಣ್ವಂ ಪ್ರತಿ ಸತರ್ಕಾಃ ಸಾವಧಾನಾಶ್ಚ ಭವತ| ");
INSERT INTO sankan_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ತತಸ್ತೇಽನ್ಯೋನ್ಯಂ ವಿವೇಚನಂ ಕರ್ತುಮ್ ಆರೇಭಿರೇ, ಅಸ್ಮಾಕಂ ಸನ್ನಿಧೌ ಪೂಪೋ ನಾಸ್ತೀತಿ ಹೇತೋರಿದಂ ಕಥಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ತದ್ ಬುದ್ವ್ವಾ ಯೀಶುಸ್ತೇಭ್ಯೋಽಕಥಯತ್ ಯುಷ್ಮಾಕಂ ಸ್ಥಾನೇ ಪೂಪಾಭಾವಾತ್ ಕುತ ಇತ್ಥಂ ವಿತರ್ಕಯಥ? ಯೂಯಂ ಕಿಮದ್ಯಾಪಿ ಕಿಮಪಿ ನ ಜಾನೀಥ? ಬೋದ್ಧುಞ್ಚ ನ ಶಕ್ನುಥ? ಯಾವದದ್ಯ ಕಿಂ ಯುಷ್ಮಾಕಂ ಮನಾಂಸಿ ಕಠಿನಾನಿ ಸನ್ತಿ? ");
INSERT INTO sankan_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","ಸತ್ಸು ನೇತ್ರೇಷು ಕಿಂ ನ ಪಶ್ಯಥ? ಸತ್ಸು ಕರ್ಣೇಷು ಕಿಂ ನ ಶೃಣುಥ? ನ ಸ್ಮರಥ ಚ? ");
INSERT INTO sankan_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ಯದಾಹಂ ಪಞ್ಚಪೂಪಾನ್ ಪಞ್ಚಸಹಸ್ರಾಣಾಂ ಪುರುಷಾಣಾಂ ಮಧ್ಯೇ ಭಂಕ್ತ್ವಾ ದತ್ತವಾನ್ ತದಾನೀಂ ಯೂಯಮ್ ಅವಶಿಷ್ಟಪೂಪೈಃ ಪೂರ್ಣಾನ್ ಕತಿ ಡಲ್ಲಕಾನ್ ಗೃಹೀತವನ್ತಃ? ತೇಽಕಥಯನ್ ದ್ವಾದಶಡಲ್ಲಕಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","ಅಪರಞ್ಚ ಯದಾ ಚತುಃಸಹಸ್ರಾಣಾಂ ಪುರುಷಾಣಾಂ ಮಧ್ಯೇ ಪೂಪಾನ್ ಭಂಕ್ತ್ವಾದದಾಂ ತದಾ ಯೂಯಮ್ ಅತಿರಿಕ್ತಪೂಪಾನಾಂ ಕತಿ ಡಲ್ಲಕಾನ್ ಗೃಹೀತವನ್ತಃ? ತೇ ಕಥಯಾಮಾಸುಃ ಸಪ್ತಡಲ್ಲಕಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ತದಾ ಸ ಕಥಿತವಾನ್ ತರ್ಹಿ ಯೂಯಮ್ ಅಧುನಾಪಿ ಕುತೋ ಬೋದ್ವ್ವುಂ ನ ಶಕ್ನುಥ? ");
INSERT INTO sankan_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","ಅನನ್ತರಂ ತಸ್ಮಿನ್ ಬೈತ್ಸೈದಾನಗರೇ ಪ್ರಾಪ್ತೇ ಲೋಕಾ ಅನ್ಧಮೇಕಂ ನರಂ ತತ್ಸಮೀಪಮಾನೀಯ ತಂ ಸ್ಪ್ರಷ್ಟುಂ ತಂ ಪ್ರಾರ್ಥಯಾಞ್ಚಕ್ರಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ತದಾ ತಸ್ಯಾನ್ಧಸ್ಯ ಕರೌ ಗೃಹೀತ್ವಾ ನಗರಾದ್ ಬಹಿರ್ದೇಶಂ ತಂ ನೀತವಾನ್; ತನ್ನೇತ್ರೇ ನಿಷ್ಠೀವಂ ದತ್ತ್ವಾ ತದ್ಗಾತ್ರೇ ಹಸ್ತಾವರ್ಪಯಿತ್ವಾ ತಂ ಪಪ್ರಚ್ಛ, ಕಿಮಪಿ ಪಶ್ಯಸಿ? ");
INSERT INTO sankan_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ಸ ನೇತ್ರೇ ಉನ್ಮೀಲ್ಯ ಜಗಾದ, ವೃಕ್ಷವತ್ ಮನುಜಾನ್ ಗಚ್ಛತೋ ನಿರೀಕ್ಷೇ| ");
INSERT INTO sankan_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ತತೋ ಯೀಶುಃ ಪುನಸ್ತಸ್ಯ ನಯನಯೋ ರ್ಹಸ್ತಾವರ್ಪಯಿತ್ವಾ ತಸ್ಯ ನೇತ್ರೇ ಉನ್ಮೀಲಯಾಮಾಸ; ತಸ್ಮಾತ್ ಸ ಸ್ವಸ್ಥೋ ಭೂತ್ವಾ ಸ್ಪಷ್ಟರೂಪಂ ಸರ್ವ್ವಲೋಕಾನ್ ದದರ್ಶ| ");
INSERT INTO sankan_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ತತಃ ಪರಂ ತ್ವಂ ಗ್ರಾಮಂ ಮಾ ಗಚ್ಛ ಗ್ರಾಮಸ್ಥಂ ಕಮಪಿ ಚ ಕಿಮಪ್ಯನುಕ್ತ್ವಾ ನಿಜಗೃಹಂ ಯಾಹೀತ್ಯಾದಿಶ್ಯ ಯೀಶುಸ್ತಂ ನಿಜಗೃಹಂ ಪ್ರಹಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","ಅನನ್ತರಂ ಶಿಷ್ಯೈಃ ಸಹಿತೋ ಯೀಶುಃ ಕೈಸರೀಯಾಫಿಲಿಪಿಪುರಂ ಜಗಾಮ, ಪಥಿ ಗಚ್ಛನ್ ತಾನಪೃಚ್ಛತ್ ಕೋಽಹಮ್ ಅತ್ರ ಲೋಕಾಃ ಕಿಂ ವದನ್ತಿ? ");
INSERT INTO sankan_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","ತೇ ಪ್ರತ್ಯೂಚುಃ ತ್ವಾಂ ಯೋಹನಂ ಮಜ್ಜಕಂ ವದನ್ತಿ ಕಿನ್ತು ಕೇಪಿ ಕೇಪಿ ಏಲಿಯಂ ವದನ್ತಿ; ಅಪರೇ ಕೇಪಿ ಕೇಪಿ ಭವಿಷ್ಯದ್ವಾದಿನಾಮ್ ಏಕೋ ಜನ ಇತಿ ವದನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","ಅಥ ಸ ತಾನಪೃಚ್ಛತ್ ಕಿನ್ತು ಕೋಹಮ್? ಇತ್ಯತ್ರ ಯೂಯಂ ಕಿಂ ವದಥ? ತದಾ ಪಿತರಃ ಪ್ರತ್ಯವದತ್ ಭವಾನ್ ಅಭಿಷಿಕ್ತಸ್ತ್ರಾತಾ| ");
INSERT INTO sankan_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","ತತಃ ಸ ತಾನ್ ಗಾಢಮಾದಿಶದ್ ಯೂಯಂ ಮಮ ಕಥಾ ಕಸ್ಮೈಚಿದಪಿ ಮಾ ಕಥಯತ| ");
INSERT INTO sankan_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","ಮನುಷ್ಯಪುತ್ರೇಣಾವಶ್ಯಂ ಬಹವೋ ಯಾತನಾ ಭೋಕ್ತವ್ಯಾಃ ಪ್ರಾಚೀನಲೋಕೈಃ ಪ್ರಧಾನಯಾಜಕೈರಧ್ಯಾಪಕೈಶ್ಚ ಸ ನಿನ್ದಿತಃ ಸನ್ ಘಾತಯಿಷ್ಯತೇ ತೃತೀಯದಿನೇ ಉತ್ಥಾಸ್ಯತಿ ಚ, ಯೀಶುಃ ಶಿಷ್ಯಾನುಪದೇಷ್ಟುಮಾರಭ್ಯ ಕಥಾಮಿಮಾಂ ಸ್ಪಷ್ಟಮಾಚಷ್ಟ| ");
INSERT INTO sankan_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ತಸ್ಮಾತ್ ಪಿತರಸ್ತಸ್ಯ ಹಸ್ತೌ ಧೃತ್ವಾ ತಂ ತರ್ಜ್ಜಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","ಕಿನ್ತು ಸ ಮುಖಂ ಪರಾವರ್ತ್ಯ ಶಿಷ್ಯಗಣಂ ನಿರೀಕ್ಷ್ಯ ಪಿತರಂ ತರ್ಜಯಿತ್ವಾವಾದೀದ್ ದೂರೀಭವ ವಿಘ್ನಕಾರಿನ್ ಈಶ್ವರೀಯಕಾರ್ಯ್ಯಾದಪಿ ಮನುಷ್ಯಕಾರ್ಯ್ಯಂ ತುಭ್ಯಂ ರೋಚತತರಾಂ| ");
INSERT INTO sankan_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ಅಥ ಸ ಲೋಕಾನ್ ಶಿಷ್ಯಾಂಶ್ಚಾಹೂಯ ಜಗಾದ ಯಃ ಕಶ್ಚಿನ್ ಮಾಮನುಗನ್ತುಮ್ ಇಚ್ಛತಿ ಸ ಆತ್ಮಾನಂ ದಾಮ್ಯತು, ಸ್ವಕ್ರುಶಂ ಗೃಹೀತ್ವಾ ಮತ್ಪಶ್ಚಾದ್ ಆಯಾತು| ");
INSERT INTO sankan_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ಯತೋ ಯಃ ಕಶ್ಚಿತ್ ಸ್ವಪ್ರಾಣಂ ರಕ್ಷಿತುಮಿಚ್ಛತಿ ಸ ತಂ ಹಾರಯಿಷ್ಯತಿ, ಕಿನ್ತು ಯಃ ಕಶ್ಚಿನ್ ಮದರ್ಥಂ ಸುಸಂವಾದಾರ್ಥಞ್ಚ ಪ್ರಾಣಂ ಹಾರಯತಿ ಸ ತಂ ರಕ್ಷಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","ಅಪರಞ್ಚ ಮನುಜಃ ಸರ್ವ್ವಂ ಜಗತ್ ಪ್ರಾಪ್ಯ ಯದಿ ಸ್ವಪ್ರಾಣಂ ಹಾರಯತಿ ತರ್ಹಿ ತಸ್ಯ ಕೋ ಲಾಭಃ? ");
INSERT INTO sankan_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","ನರಃ ಸ್ವಪ್ರಾಣವಿನಿಮಯೇನ ಕಿಂ ದಾತುಂ ಶಕ್ನೋತಿ? ");
INSERT INTO sankan_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ಏತೇಷಾಂ ವ್ಯಭಿಚಾರಿಣಾಂ ಪಾಪಿನಾಞ್ಚ ಲೋಕಾನಾಂ ಸಾಕ್ಷಾದ್ ಯದಿ ಕೋಪಿ ಮಾಂ ಮತ್ಕಥಾಞ್ಚ ಲಜ್ಜಾಸ್ಪದಂ ಜಾನಾತಿ ತರ್ಹಿ ಮನುಜಪುತ್ರೋ ಯದಾ ಧರ್ಮ್ಮದೂತೈಃ ಸಹ ಪಿತುಃ ಪ್ರಭಾವೇಣಾಗಮಿಷ್ಯತಿ ತದಾ ಸೋಪಿ ತಂ ಲಜ್ಜಾಸ್ಪದಂ ಜ್ಞಾಸ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","ಅಥ ಸ ತಾನವಾದೀತ್ ಯುಷ್ಮಭ್ಯಮಹಂ ಯಥಾರ್ಥಂ ಕಥಯಾಮಿ, ಈಶ್ವರರಾಜ್ಯಂ ಪರಾಕ್ರಮೇಣೋಪಸ್ಥಿತಂ ನ ದೃಷ್ಟ್ವಾ ಮೃತ್ಯುಂ ನಾಸ್ವಾದಿಷ್ಯನ್ತೇ, ಅತ್ರ ದಣ್ಡಾಯಮಾನಾನಾಂ ಮಧ್ಯೇಪಿ ತಾದೃಶಾ ಲೋಕಾಃ ಸನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","ಅಥ ಷಡ್ದಿನೇಭ್ಯಃ ಪರಂ ಯೀಶುಃ ಪಿತರಂ ಯಾಕೂಬಂ ಯೋಹನಞ್ಚ ಗೃಹೀತ್ವಾ ಗಿರೇರುಚ್ಚಸ್ಯ ನಿರ್ಜನಸ್ಥಾನಂ ಗತ್ವಾ ತೇಷಾಂ ಪ್ರತ್ಯಕ್ಷೇ ಮೂರ್ತ್ಯನ್ತರಂ ದಧಾರ| ");
INSERT INTO sankan_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ತತಸ್ತಸ್ಯ ಪರಿಧೇಯಮ್ ಈದೃಶಮ್ ಉಜ್ಜ್ವಲಹಿಮಪಾಣಡರಂ ಜಾತಂ ಯದ್ ಜಗತಿ ಕೋಪಿ ರಜಕೋ ನ ತಾದೃಕ್ ಪಾಣಡರಂ ಕರ್ತ್ತಾಂ ಶಕ್ನೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","ಅಪರಞ್ಚ ಏಲಿಯೋ ಮೂಸಾಶ್ಚ ತೇಭ್ಯೋ ದರ್ಶನಂ ದತ್ತ್ವಾ ಯೀಶುನಾ ಸಹ ಕಥನಂ ಕರ್ತ್ತುಮಾರೇಭಾತೇ| ");
INSERT INTO sankan_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ತದಾ ಪಿತರೋ ಯೀಶುಮವಾದೀತ್ ಹೇ ಗುರೋಽಸ್ಮಾಕಮತ್ರ ಸ್ಥಿತಿರುತ್ತಮಾ, ತತಏವ ವಯಂ ತ್ವತ್ಕೃತೇ ಏಕಾಂ ಮೂಸಾಕೃತೇ ಏಕಾಮ್ ಏಲಿಯಕೃತೇ ಚೈಕಾಂ, ಏತಾಸ್ತಿಸ್ರಃ ಕುಟೀ ರ್ನಿರ್ಮ್ಮಾಮ| ");
INSERT INTO sankan_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","ಕಿನ್ತು ಸ ಯದುಕ್ತವಾನ್ ತತ್ ಸ್ವಯಂ ನ ಬುಬುಧೇ ತತಃ ಸರ್ವ್ವೇ ಬಿಭಯಾಞ್ಚಕ್ರುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ಏತರ್ಹಿ ಪಯೋದಸ್ತಾನ್ ಛಾದಯಾಮಾಸ, ಮಮಯಾಂ ಪ್ರಿಯಃ ಪುತ್ರಃ ಕಥಾಸು ತಸ್ಯ ಮನಾಂಸಿ ನಿವೇಶಯತೇತಿ ನಭೋವಾಣೀ ತನ್ಮೇದ್ಯಾನ್ನಿರ್ಯಯೌ| ");
INSERT INTO sankan_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","ಅಥ ಹಠಾತ್ತೇ ಚತುರ್ದಿಶೋ ದೃಷ್ಟ್ವಾ ಯೀಶುಂ ವಿನಾ ಸ್ವೈಃ ಸಹಿತಂ ಕಮಪಿ ನ ದದೃಶುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ತತಃ ಪರಂ ಗಿರೇರವರೋಹಣಕಾಲೇ ಸ ತಾನ್ ಗಾಢಮ್ ದೂತ್ಯಾದಿದೇಶ ಯಾವನ್ನರಸೂನೋಃ ಶ್ಮಶಾನಾದುತ್ಥಾನಂ ನ ಭವತಿ, ತಾವತ್ ದರ್ಶನಸ್ಯಾಸ್ಯ ವಾರ್ತ್ತಾ ಯುಷ್ಮಾಭಿಃ ಕಸ್ಮೈಚಿದಪಿ ನ ವಕ್ತವ್ಯಾ| ");
INSERT INTO sankan_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ತದಾ ಶ್ಮಶಾನಾದುತ್ಥಾನಸ್ಯ ಕೋಭಿಪ್ರಾಯ ಇತಿ ವಿಚಾರ್ಯ್ಯ ತೇ ತದ್ವಾಕ್ಯಂ ಸ್ವೇಷು ಗೋಪಾಯಾಞ್ಚಕ್ರಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ಅಥ ತೇ ಯೀಶುಂ ಪಪ್ರಚ್ಛುಃ ಪ್ರಥಮತ ಏಲಿಯೇನಾಗನ್ತವ್ಯಮ್ ಇತಿ ವಾಕ್ಯಂ ಕುತ ಉಪಾಧ್ಯಾಯಾ ಆಹುಃ? ");
INSERT INTO sankan_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","ತದಾ ಸ ಪ್ರತ್ಯುವಾಚ , ಏಲಿಯಃ ಪ್ರಥಮಮೇತ್ಯ ಸರ್ವ್ವಕಾರ್ಯ್ಯಾಣಿ ಸಾಧಯಿಷ್ಯತಿ; ನರಪುತ್ರೇ ಚ ಲಿಪಿ ರ್ಯಥಾಸ್ತೇ ತಥೈವ ಸೋಪಿ ಬಹುದುಃಖಂ ಪ್ರಾಪ್ಯಾವಜ್ಞಾಸ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","ಕಿನ್ತ್ವಹಂ ಯುಷ್ಮಾನ್ ವದಾಮಿ , ಏಲಿಯಾರ್ಥೇ ಲಿಪಿ ರ್ಯಥಾಸ್ತೇ ತಥೈವ ಸ ಏತ್ಯ ಯಯೌ, ಲೋಕಾ: ಸ್ವೇಚ್ಛಾನುರೂಪಂ ತಮಭಿವ್ಯವಹರನ್ತಿ ಸ್ಮ| ");
INSERT INTO sankan_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","ಅನನ್ತರಂ ಸ ಶಿಷ್ಯಸಮೀಪಮೇತ್ಯ ತೇಷಾಂ ಚತುಃಪಾರ್ಶ್ವೇ ತೈಃ ಸಹ ಬಹುಜನಾನ್ ವಿವದಮಾನಾನ್ ಅಧ್ಯಾಪಕಾಂಶ್ಚ ದೃಷ್ಟವಾನ್; ");
INSERT INTO sankan_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ಕಿನ್ತು ಸರ್ವ್ವಲೋಕಾಸ್ತಂ ದೃಷ್ಟ್ವೈವ ಚಮತ್ಕೃತ್ಯ ತದಾಸನ್ನಂ ಧಾವನ್ತಸ್ತಂ ಪ್ರಣೇಮುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ತದಾ ಯೀಶುರಧ್ಯಾಪಕಾನಪ್ರಾಕ್ಷೀದ್ ಏತೈಃ ಸಹ ಯೂಯಂ ಕಿಂ ವಿವದಧ್ವೇ? ");
INSERT INTO sankan_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ತತೋ ಲೋಕಾನಾಂ ಕಶ್ಚಿದೇಕಃ ಪ್ರತ್ಯವಾದೀತ್ ಹೇ ಗುರೋ ಮಮ ಸೂನುಂ ಮೂಕಂ ಭೂತಧೃತಞ್ಚ ಭವದಾಸನ್ನಮ್ ಆನಯಂ| ");
INSERT INTO sankan_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ಯದಾಸೌ ಭೂತಸ್ತಮಾಕ್ರಮತೇ ತದೈವ ಪಾತಸತಿ ತಥಾ ಸ ಫೇಣಾಯತೇ, ದನ್ತೈರ್ದನ್ತಾನ್ ಘರ್ಷತಿ ಕ್ಷೀಣೋ ಭವತಿ ಚ; ತತೋ ಹೇತೋಸ್ತಂ ಭೂತಂ ತ್ಯಾಜಯಿತುಂ ಭವಚ್ಛಿಷ್ಯಾನ್ ನಿವೇದಿತವಾನ್ ಕಿನ್ತು ತೇ ನ ಶೇಕುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ತದಾ ಸ ತಮವಾದೀತ್, ರೇ ಅವಿಶ್ವಾಸಿನಃ ಸನ್ತಾನಾ ಯುಷ್ಮಾಭಿಃ ಸಹ ಕತಿ ಕಾಲಾನಹಂ ಸ್ಥಾಸ್ಯಾಮಿ? ಅಪರಾನ್ ಕತಿ ಕಾಲಾನ್ ವಾ ವ ಆಚಾರಾನ್ ಸಹಿಷ್ಯೇ? ತಂ ಮದಾಸನ್ನಮಾನಯತ| ");
INSERT INTO sankan_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ತತಸ್ತತ್ಸನ್ನಿಧಿಂ ಸ ಆನೀಯತ ಕಿನ್ತು ತಂ ದೃಷ್ಟ್ವೈವ ಭೂತೋ ಬಾಲಕಂ ಧೃತವಾನ್; ಸ ಚ ಭೂಮೌ ಪತಿತ್ವಾ ಫೇಣಾಯಮಾನೋ ಲುಲೋಠ| ");
INSERT INTO sankan_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","ತದಾ ಸ ತತ್ಪಿತರಂ ಪಪ್ರಚ್ಛ, ಅಸ್ಯೇದೃಶೀ ದಶಾ ಕತಿ ದಿನಾನಿ ಭೂತಾ? ತತಃ ಸೋವಾದೀತ್ ಬಾಲ್ಯಕಾಲಾತ್| ");
INSERT INTO sankan_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","ಭೂತೋಯಂ ತಂ ನಾಶಯಿತುಂ ಬಹುವಾರಾನ್ ವಹ್ನೌ ಜಲೇ ಚ ನ್ಯಕ್ಷಿಪತ್ ಕಿನ್ತು ಯದಿ ಭವಾನ ಕಿಮಪಿ ಕರ್ತ್ತಾಂ ಶಕ್ನೋತಿ ತರ್ಹಿ ದಯಾಂ ಕೃತ್ವಾಸ್ಮಾನ್ ಉಪಕರೋತು| ");
INSERT INTO sankan_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ತದಾ ಯೀಶುಸ್ತಮವದತ್ ಯದಿ ಪ್ರತ್ಯೇತುಂ ಶಕ್ನೋಷಿ ತರ್ಹಿ ಪ್ರತ್ಯಯಿನೇ ಜನಾಯ ಸರ್ವ್ವಂ ಸಾಧ್ಯಮ್| ");
INSERT INTO sankan_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ತತಸ್ತತ್ಕ್ಷಣಂ ತದ್ಬಾಲಕಸ್ಯ ಪಿತಾ ಪ್ರೋಚ್ಚೈ ರೂವನ್ ಸಾಶ್ರುನೇತ್ರಃ ಪ್ರೋವಾಚ, ಪ್ರಭೋ ಪ್ರತ್ಯೇಮಿ ಮಮಾಪ್ರತ್ಯಯಂ ಪ್ರತಿಕುರು| ");
INSERT INTO sankan_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","ಅಥ ಯೀಶು ರ್ಲೋಕಸಙ್ಘಂ ಧಾವಿತ್ವಾಯಾನ್ತಂ ದೃಷ್ಟ್ವಾ ತಮಪೂತಭೂತಂ ತರ್ಜಯಿತ್ವಾ ಜಗಾದ, ರೇ ಬಧಿರ ಮೂಕ ಭೂತ ತ್ವಮೇತಸ್ಮಾದ್ ಬಹಿರ್ಭವ ಪುನಃ ಕದಾಪಿ ಮಾಶ್ರಯೈನಂ ತ್ವಾಮಹಮ್ ಇತ್ಯಾದಿಶಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ತದಾ ಸ ಭೂತಶ್ಚೀತ್ಶಬ್ದಂ ಕೃತ್ವಾ ತಮಾಪೀಡ್ಯ ಬಹಿರ್ಜಜಾಮ, ತತೋ ಬಾಲಕೋ ಮೃತಕಲ್ಪೋ ಬಭೂವ ತಸ್ಮಾದಯಂ ಮೃತಇತ್ಯನೇಕೇ ಕಥಯಾಮಾಸುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","ಕಿನ್ತು ಕರಂ ಧೃತ್ವಾ ಯೀಶುನೋತ್ಥಾಪಿತಃ ಸ ಉತ್ತಸ್ಥೌ| ");
INSERT INTO sankan_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","ಅಥ ಯೀಶೌ ಗೃಹಂ ಪ್ರವಿಷ್ಟೇ ಶಿಷ್ಯಾ ಗುಪ್ತಂ ತಂ ಪಪ್ರಚ್ಛುಃ, ವಯಮೇನಂ ಭೂತಂ ತ್ಯಾಜಯಿತುಂ ಕುತೋ ನ ಶಕ್ತಾಃ? ");
INSERT INTO sankan_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ಸ ಉವಾಚ, ಪ್ರಾರ್ಥನೋಪವಾಸೌ ವಿನಾ ಕೇನಾಪ್ಯನ್ಯೇನ ಕರ್ಮ್ಮಣಾ ಭೂತಮೀದೃಶಂ ತ್ಯಾಜಯಿತುಂ ನ ಶಕ್ಯಂ| ");
INSERT INTO sankan_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","ಅನನ್ತರಂ ಸ ತತ್ಸ್ಥಾನಾದಿತ್ವಾ ಗಾಲೀಲ್ಮಧ್ಯೇನ ಯಯೌ, ಕಿನ್ತು ತತ್ ಕೋಪಿ ಜಾನೀಯಾದಿತಿ ಸ ನೈಚ್ಛತ್| ");
INSERT INTO sankan_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ಅಪರಞ್ಚ ಸ ಶಿಷ್ಯಾನುಪದಿಶನ್ ಬಭಾಷೇ, ನರಪುತ್ರೋ ನರಹಸ್ತೇಷು ಸಮರ್ಪಯಿಷ್ಯತೇ ತೇ ಚ ತಂ ಹನಿಷ್ಯನ್ತಿ ತೈಸ್ತಸ್ಮಿನ್ ಹತೇ ತೃತೀಯದಿನೇ ಸ ಉತ್ಥಾಸ್ಯತೀತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","ಕಿನ್ತು ತತ್ಕಥಾಂ ತೇ ನಾಬುಧ್ಯನ್ತ ಪ್ರಷ್ಟುಞ್ಚ ಬಿಭ್ಯಃ| ");
INSERT INTO sankan_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","ಅಥ ಯೀಶುಃ ಕಫರ್ನಾಹೂಮ್ಪುರಮಾಗತ್ಯ ಮಧ್ಯೇಗೃಹಞ್ಚೇತ್ಯ ತಾನಪೃಚ್ಛದ್ ವರ್ತ್ಮಮಧ್ಯೇ ಯೂಯಮನ್ಯೋನ್ಯಂ ಕಿಂ ವಿವದಧ್ವೇ ಸ್ಮ? ");
INSERT INTO sankan_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","ಕಿನ್ತು ತೇ ನಿರುತ್ತರಾಸ್ತಸ್ಥು ರ್ಯಸ್ಮಾತ್ತೇಷಾಂ ಕೋ ಮುಖ್ಯ ಇತಿ ವರ್ತ್ಮಾನಿ ತೇಽನ್ಯೋನ್ಯಂ ವ್ಯವದನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ತತಃ ಸ ಉಪವಿಶ್ಯ ದ್ವಾದಶಶಿಷ್ಯಾನ್ ಆಹೂಯ ಬಭಾಷೇ ಯಃ ಕಶ್ಚಿತ್ ಮುಖ್ಯೋ ಭವಿತುಮಿಚ್ಛತಿ ಸ ಸರ್ವ್ವೇಭ್ಯೋ ಗೌಣಃ ಸರ್ವ್ವೇಷಾಂ ಸೇವಕಶ್ಚ ಭವತು| ");
INSERT INTO sankan_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","ತದಾ ಸ ಬಾಲಕಮೇಕಂ ಗೃಹೀತ್ವಾ ಮಧ್ಯೇ ಸಮುಪಾವೇಶಯತ್ ತತಸ್ತಂ ಕ್ರೋಡೇ ಕೃತ್ವಾ ತಾನವಾದಾತ್ ");
INSERT INTO sankan_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","ಯಃ ಕಶ್ಚಿದೀದೃಶಸ್ಯ ಕಸ್ಯಾಪಿ ಬಾಲಸ್ಯಾತಿಥ್ಯಂ ಕರೋತಿ ಸ ಮಮಾತಿಥ್ಯಂ ಕರೋತಿ; ಯಃ ಕಶ್ಚಿನ್ಮಮಾತಿಥ್ಯಂ ಕರೋತಿ ಸ ಕೇವಲಮ್ ಮಮಾತಿಥ್ಯಂ ಕರೋತಿ ತನ್ನ ಮತ್ಪ್ರೇರಕಸ್ಯಾಪ್ಯಾತಿಥ್ಯಂ ಕರೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ಅಥ ಯೋಹನ್ ತಮಬ್ರವೀತ್ ಹೇ ಗುರೋ, ಅಸ್ಮಾಕಮನನುಗಾಮಿನಮ್ ಏಕಂ ತ್ವಾನ್ನಾಮ್ನಾ ಭೂತಾನ್ ತ್ಯಾಜಯನ್ತಂ ವಯಂ ದೃಷ್ಟವನ್ತಃ, ಅಸ್ಮಾಕಮಪಶ್ಚಾದ್ಗಾಮಿತ್ವಾಚ್ಚ ತಂ ನ್ಯಷೇಧಾಮ| ");
INSERT INTO sankan_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ಕಿನ್ತು ಯೀಶುರವದತ್ ತಂ ಮಾ ನಿಷೇಧತ್, ಯತೋ ಯಃ ಕಶ್ಚಿನ್ ಮನ್ನಾಮ್ನಾ ಚಿತ್ರಂ ಕರ್ಮ್ಮ ಕರೋತಿ ಸ ಸಹಸಾ ಮಾಂ ನಿನ್ದಿತುಂ ನ ಶಕ್ನೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ತಥಾ ಯಃ ಕಶ್ಚಿದ್ ಯುಷ್ಮಾಕಂ ವಿಪಕ್ಷತಾಂ ನ ಕರೋತಿ ಸ ಯುಷ್ಮಾಕಮೇವ ಸಪಕ್ಷಃ| ");
INSERT INTO sankan_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ಯಃ ಕಶ್ಚಿದ್ ಯುಷ್ಮಾನ್ ಖ್ರೀಷ್ಟಶಿಷ್ಯಾನ್ ಜ್ಞಾತ್ವಾ ಮನ್ನಾಮ್ನಾ ಕಂಸೈಕೇನ ಪಾನೀಯಂ ಪಾತುಂ ದದಾತಿ, ಯುಷ್ಮಾನಹಂ ಯಥಾರ್ಥಂ ವಚ್ಮಿ, ಸ ಫಲೇನ ವಞ್ಚಿತೋ ನ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","ಕಿನ್ತು ಯದಿ ಕಶ್ಚಿನ್ ಮಯಿ ವಿಶ್ವಾಸಿನಾಮೇಷಾಂ ಕ್ಷುದ್ರಪ್ರಾಣಿನಾಮ್ ಏಕಸ್ಯಾಪಿ ವಿಘ್ನಂ ಜನಯತಿ, ತರ್ಹಿ ತಸ್ಯೈತತ್ಕರ್ಮ್ಮ ಕರಣಾತ್ ಕಣ್ಠಬದ್ಧಪೇಷಣೀಕಸ್ಯ ತಸ್ಯ ಸಾಗರಾಗಾಧಜಲ ಮಜ್ಜನಂ ಭದ್ರಂ| ");
INSERT INTO sankan_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","ಅತಃ ಸ್ವಕರೋ ಯದಿ ತ್ವಾಂ ಬಾಧತೇ ತರ್ಹಿ ತಂ ಛಿನ್ಧಿ; ");
INSERT INTO sankan_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ಯಸ್ಮಾತ್ ಯತ್ರ ಕೀಟಾ ನ ಮ್ರಿಯನ್ತೇ ವಹ್ನಿಶ್ಚ ನ ನಿರ್ವ್ವಾತಿ, ತಸ್ಮಿನ್ ಅನಿರ್ವ್ವಾಣಾನಲನರಕೇ ಕರದ್ವಯವಸ್ತವ ಗಮನಾತ್ ಕರಹೀನಸ್ಯ ಸ್ವರ್ಗಪ್ರವೇಶಸ್ತವ ಕ್ಷೇಮಂ| ");
INSERT INTO sankan_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","ಯದಿ ತವ ಪಾದೋ ವಿಘ್ನಂ ಜನಯತಿ ತರ್ಹಿ ತಂ ಛಿನ್ಧಿ, ");
INSERT INTO sankan_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ಯತೋ ಯತ್ರ ಕೀಟಾ ನ ಮ್ರಿಯನ್ತೇ ವಹ್ನಿಶ್ಚ ನ ನಿರ್ವ್ವಾತಿ, ತಸ್ಮಿನ್ ಽನಿರ್ವ್ವಾಣವಹ್ನೌ ನರಕೇ ದ್ವಿಪಾದವತಸ್ತವ ನಿಕ್ಷೇಪಾತ್ ಪಾದಹೀನಸ್ಯ ಸ್ವರ್ಗಪ್ರವೇಶಸ್ತವ ಕ್ಷೇಮಂ| ");
INSERT INTO sankan_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","ಸ್ವನೇತ್ರಂ ಯದಿ ತ್ವಾಂ ಬಾಧತೇ ತರ್ಹಿ ತದಪ್ಯುತ್ಪಾಟಯ, ಯತೋ ಯತ್ರ ಕೀಟಾ ನ ಮ್ರಿಯನ್ತೇ ವಹ್ನಿಶ್ಚ ನ ನಿರ್ವ್ವಾತಿ, ");
INSERT INTO sankan_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ತಸ್ಮಿನ ಽನಿರ್ವ್ವಾಣವಹ್ನೌ ನರಕೇ ದ್ವಿನೇತ್ರಸ್ಯ ತವ ನಿಕ್ಷೇಪಾದ್ ಏಕನೇತ್ರವತ ಈಶ್ವರರಾಜ್ಯೇ ಪ್ರವೇಶಸ್ತವ ಕ್ಷೇಮಂ| ");
INSERT INTO sankan_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","ಯಥಾ ಸರ್ವ್ವೋ ಬಲಿ ರ್ಲವಣಾಕ್ತಃ ಕ್ರಿಯತೇ ತಥಾ ಸರ್ವ್ವೋ ಜನೋ ವಹ್ನಿರೂಪೇಣ ಲವಣಾಕ್ತಃ ಕಾರಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","ಲವಣಂ ಭದ್ರಂ ಕಿನ್ತು ಯದಿ ಲವಣೇ ಸ್ವಾದುತಾ ನ ತಿಷ್ಠತಿ, ತರ್ಹಿ ಕಥಮ್ ಆಸ್ವಾದ್ಯುಕ್ತಂ ಕರಿಷ್ಯಥ? ಯೂಯಂ ಲವಣಯುಕ್ತಾ ಭವತ ಪರಸ್ಪರಂ ಪ್ರೇಮ ಕುರುತ| ");
INSERT INTO sankan_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","ಅನನ್ತರಂ ಸ ತತ್ಸ್ಥಾನಾತ್ ಪ್ರಸ್ಥಾಯ ಯರ್ದ್ದನನದ್ಯಾಃ ಪಾರೇ ಯಿಹೂದಾಪ್ರದೇಶ ಉಪಸ್ಥಿತವಾನ್, ತತ್ರ ತದನ್ತಿಕೇ ಲೋಕಾನಾಂ ಸಮಾಗಮೇ ಜಾತೇ ಸ ನಿಜರೀತ್ಯನುಸಾರೇಣ ಪುನಸ್ತಾನ್ ಉಪದಿದೇಶ| ");
INSERT INTO sankan_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ತದಾ ಫಿರೂಶಿನಸ್ತತ್ಸಮೀಪಮ್ ಏತ್ಯ ತಂ ಪರೀಕ್ಷಿತುಂ ಪಪ್ರಚ್ಛಃ ಸ್ವಜಾಯಾ ಮನುಜಾನಾಂ ತ್ಯಜ್ಯಾ ನ ವೇತಿ? ");
INSERT INTO sankan_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ತತಃ ಸ ಪ್ರತ್ಯವಾದೀತ್, ಅತ್ರ ಕಾರ್ಯ್ಯೇ ಮೂಸಾ ಯುಷ್ಮಾನ್ ಪ್ರತಿ ಕಿಮಾಜ್ಞಾಪಯತ್? ");
INSERT INTO sankan_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ತ ಊಚುಃ ತ್ಯಾಗಪತ್ರಂ ಲೇಖಿತುಂ ಸ್ವಪತ್ನೀಂ ತ್ಯಕ್ತುಞ್ಚ ಮೂಸಾಽನುಮನ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","ತದಾ ಯೀಶುಃ ಪ್ರತ್ಯುವಾಚ, ಯುಷ್ಮಾಕಂ ಮನಸಾಂ ಕಾಠಿನ್ಯಾದ್ಧೇತೋ ರ್ಮೂಸಾ ನಿದೇಶಮಿಮಮ್ ಅಲಿಖತ್| ");
INSERT INTO sankan_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","ಕಿನ್ತು ಸೃಷ್ಟೇರಾದೌ ಈಶ್ವರೋ ನರಾನ್ ಪುಂರೂಪೇಣ ಸ್ತ್ರೀರೂಪೇಣ ಚ ಸಸರ್ಜ| ");
INSERT INTO sankan_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","\"ತತಃ ಕಾರಣಾತ್ ಪುಮಾನ್ ಪಿತರಂ ಮಾತರಞ್ಚ ತ್ಯಕ್ತ್ವಾ ಸ್ವಜಾಯಾಯಾಮ್ ಆಸಕ್ತೋ ಭವಿಷ್ಯತಿ, ");
INSERT INTO sankan_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ತೌ ದ್ವಾವ್ ಏಕಾಙ್ಗೌ ಭವಿಷ್ಯತಃ| \" ತಸ್ಮಾತ್ ತತ್ಕಾಲಮಾರಭ್ಯ ತೌ ನ ದ್ವಾವ್ ಏಕಾಙ್ಗೌ| ");
INSERT INTO sankan_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ಅತಃ ಕಾರಣಾದ್ ಈಶ್ವರೋ ಯದಯೋಜಯತ್ ಕೋಪಿ ನರಸ್ತನ್ನ ವಿಯೇಜಯೇತ್| ");
INSERT INTO sankan_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","ಅಥ ಯೀಶು ರ್ಗೃಹಂ ಪ್ರವಿಷ್ಟಸ್ತದಾ ಶಿಷ್ಯಾಃ ಪುನಸ್ತತ್ಕಥಾಂ ತಂ ಪಪ್ರಚ್ಛುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ತತಃ ಸೋವದತ್ ಕಶ್ಚಿದ್ ಯದಿ ಸ್ವಭಾರ್ಯ್ಯಾಂ ತ್ಯಕ್ತವಾನ್ಯಾಮ್ ಉದ್ವಹತಿ ತರ್ಹಿ ಸ ಸ್ವಭಾರ್ಯ್ಯಾಯಾಃ ಪ್ರಾತಿಕೂಲ್ಯೇನ ವ್ಯಭಿಚಾರೀ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ಕಾಚಿನ್ನಾರೀ ಯದಿ ಸ್ವಪತಿಂ ಹಿತ್ವಾನ್ಯಪುಂಸಾ ವಿವಾಹಿತಾ ಭವತಿ ತರ್ಹಿ ಸಾಪಿ ವ್ಯಭಿಚಾರಿಣೀ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","ಅಥ ಸ ಯಥಾ ಶಿಶೂನ್ ಸ್ಪೃಶೇತ್, ತದರ್ಥಂ ಲೋಕೈಸ್ತದನ್ತಿಕಂ ಶಿಶವ ಆನೀಯನ್ತ, ಕಿನ್ತು ಶಿಷ್ಯಾಸ್ತಾನಾನೀತವತಸ್ತರ್ಜಯಾಮಾಸುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ಯೀಶುಸ್ತದ್ ದೃಷ್ಟ್ವಾ ಕ್ರುಧ್ಯನ್ ಜಗಾದ, ಮನ್ನಿಕಟಮ್ ಆಗನ್ತುಂ ಶಿಶೂನ್ ಮಾ ವಾರಯತ, ಯತ ಏತಾದೃಶಾ ಈಶ್ವರರಾಜ್ಯಾಧಿಕಾರಿಣಃ| ");
INSERT INTO sankan_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","ಯುಷ್ಮಾನಹಂ ಯಥಾರ್ಥಂ ವಚ್ಮಿ, ಯಃ ಕಶ್ಚಿತ್ ಶಿಶುವದ್ ಭೂತ್ವಾ ರಾಜ್ಯಮೀಶ್ವರಸ್ಯ ನ ಗೃಹ್ಲೀಯಾತ್ ಸ ಕದಾಪಿ ತದ್ರಾಜ್ಯಂ ಪ್ರವೇಷ್ಟುಂ ನ ಶಕ್ನೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ಅನನತರಂ ಸ ಶಿಶೂನಙ್ಕೇ ನಿಧಾಯ ತೇಷಾಂ ಗಾತ್ರೇಷು ಹಸ್ತೌ ದತ್ತ್ವಾಶಿಷಂ ಬಭಾಷೇ| ");
INSERT INTO sankan_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","ಅಥ ಸ ವರ್ತ್ಮನಾ ಯಾತಿ, ಏತರ್ಹಿ ಜನ ಏಕೋ ಧಾವನ್ ಆಗತ್ಯ ತತ್ಸಮ್ಮುಖೇ ಜಾನುನೀ ಪಾತಯಿತ್ವಾ ಪೃಷ್ಟವಾನ್, ಭೋಃ ಪರಮಗುರೋ, ಅನನ್ತಾಯುಃ ಪ್ರಾಪ್ತಯೇ ಮಯಾ ಕಿಂ ಕರ್ತ್ತವ್ಯಂ? ");
INSERT INTO sankan_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","ತದಾ ಯೀಶುರುವಾಚ, ಮಾಂ ಪರಮಂ ಕುತೋ ವದಸಿ? ವಿನೇಶ್ವರಂ ಕೋಪಿ ಪರಮೋ ನ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","ಪರಸ್ತ್ರೀಂ ನಾಭಿಗಚ್ಛ; ನರಂ ಮಾ ಘಾತಯ; ಸ್ತೇಯಂ ಮಾ ಕುರು; ಮೃಷಾಸಾಕ್ಷ್ಯಂ ಮಾ ದೇಹಿ; ಹಿಂಸಾಞ್ಚ ಮಾ ಕುರು; ಪಿತರೌ ಸಮ್ಮನ್ಯಸ್ವ; ನಿದೇಶಾ ಏತೇ ತ್ವಯಾ ಜ್ಞಾತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ತತಸ್ತನ ಪ್ರತ್ಯುಕ್ತಂ, ಹೇ ಗುರೋ ಬಾಲ್ಯಕಾಲಾದಹಂ ಸರ್ವ್ವಾನೇತಾನ್ ಆಚರಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ತದಾ ಯೀಶುಸ್ತಂ ವಿಲೋಕ್ಯ ಸ್ನೇಹೇನ ಬಭಾಷೇ, ತವೈಕಸ್ಯಾಭಾವ ಆಸ್ತೇ; ತ್ವಂ ಗತ್ವಾ ಸರ್ವ್ವಸ್ವಂ ವಿಕ್ರೀಯ ದರಿದ್ರೇಭ್ಯೋ ವಿಶ್ರಾಣಯ, ತತಃ ಸ್ವರ್ಗೇ ಧನಂ ಪ್ರಾಪ್ಸ್ಯಸಿ; ತತಃ ಪರಮ್ ಏತ್ಯ ಕ್ರುಶಂ ವಹನ್ ಮದನುವರ್ತ್ತೀ ಭವ| ");
INSERT INTO sankan_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ಕಿನ್ತು ತಸ್ಯ ಬಹುಸಮ್ಪದ್ವಿದ್ಯಮಾನತ್ವಾತ್ ಸ ಇಮಾಂ ಕಥಾಮಾಕರ್ಣ್ಯ ವಿಷಣೋ ದುಃಖಿತಶ್ಚ ಸನ್ ಜಗಾಮ| ");
INSERT INTO sankan_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","ಅಥ ಯೀಶುಶ್ಚತುರ್ದಿಶೋ ನಿರೀಕ್ಷ್ಯ ಶಿಷ್ಯಾನ್ ಅವಾದೀತ್, ಧನಿಲೋಕಾನಾಮ್ ಈಶ್ವರರಾಜ್ಯಪ್ರವೇಶಃ ಕೀದೃಗ್ ದುಷ್ಕರಃ| ");
INSERT INTO sankan_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","ತಸ್ಯ ಕಥಾತಃ ಶಿಷ್ಯಾಶ್ಚಮಚ್ಚಕ್ರುಃ, ಕಿನ್ತು ಸ ಪುನರವದತ್, ಹೇ ಬಾಲಕಾ ಯೇ ಧನೇ ವಿಶ್ವಸನ್ತಿ ತೇಷಾಮ್ ಈಶ್ವರರಾಜ್ಯಪ್ರವೇಶಃ ಕೀದೃಗ್ ದುಷ್ಕರಃ| ");
INSERT INTO sankan_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ಈಶ್ವರರಾಜ್ಯೇ ಧನಿನಾಂ ಪ್ರವೇಶಾತ್ ಸೂಚಿರನ್ಧ್ರೇಣ ಮಹಾಙ್ಗಸ್ಯ ಗಮನಾಗಮನಂ ಸುಕರಂ| ");
INSERT INTO sankan_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","ತದಾ ಶಿಷ್ಯಾ ಅತೀವ ವಿಸ್ಮಿತಾಃ ಪರಸ್ಪರಂ ಪ್ರೋಚುಃ, ತರ್ಹಿ ಕಃ ಪರಿತ್ರಾಣಂ ಪ್ರಾಪ್ತುಂ ಶಕ್ನೋತಿ? ");
INSERT INTO sankan_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ತತೋ ಯೀಶುಸ್ತಾನ್ ವಿಲೋಕ್ಯ ಬಭಾಷೇ, ತನ್ ನರಸ್ಯಾಸಾಧ್ಯಂ ಕಿನ್ತು ನೇಶ್ವರಸ್ಯ, ಯತೋ ಹೇತೋರೀಶ್ವರಸ್ಯ ಸರ್ವ್ವಂ ಸಾಧ್ಯಮ್| ");
INSERT INTO sankan_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ತದಾ ಪಿತರ ಉವಾಚ, ಪಶ್ಯ ವಯಂ ಸರ್ವ್ವಂ ಪರಿತ್ಯಜ್ಯ ಭವತೋನುಗಾಮಿನೋ ಜಾತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","ತತೋ ಯೀಶುಃ ಪ್ರತ್ಯವದತ್, ಯುಷ್ಮಾನಹಂ ಯಥಾರ್ಥಂ ವದಾಮಿ, ಮದರ್ಥಂ ಸುಸಂವಾದಾರ್ಥಂ ವಾ ಯೋ ಜನಃ ಸದನಂ ಭ್ರಾತರಂ ಭಗಿನೀಂ ಪಿತರಂ ಮಾತರಂ ಜಾಯಾಂ ಸನ್ತಾನಾನ್ ಭೂಮಿ ವಾ ತ್ಯಕ್ತ್ವಾ ");
INSERT INTO sankan_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ಗೃಹಭ್ರಾತೃಭಗಿನೀಪಿತೃಮಾತೃಪತ್ನೀಸನ್ತಾನಭೂಮೀನಾಮಿಹ ಶತಗುಣಾನ್ ಪ್ರೇತ್ಯಾನನ್ತಾಯುಶ್ಚ ನ ಪ್ರಾಪ್ನೋತಿ ತಾದೃಶಃ ಕೋಪಿ ನಾಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","ಕಿನ್ತ್ವಗ್ರೀಯಾ ಅನೇಕೇ ಲೋಕಾಃ ಶೇಷಾಃ, ಶೇಷೀಯಾ ಅನೇಕೇ ಲೋಕಾಶ್ಚಾಗ್ರಾ ಭವಿಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","ಅಥ ಯಿರೂಶಾಲಮ್ಯಾನಕಾಲೇ ಯೀಶುಸ್ತೇಷಾಮ್ ಅಗ್ರಗಾಮೀ ಬಭೂವ, ತಸ್ಮಾತ್ತೇ ಚಿತ್ರಂ ಜ್ಞಾತ್ವಾ ಪಶ್ಚಾದ್ಗಾಮಿನೋ ಭೂತ್ವಾ ಬಿಭ್ಯುಃ| ತದಾ ಸ ಪುನ ರ್ದ್ವಾದಶಶಿಷ್ಯಾನ್ ಗೃಹೀತ್ವಾ ಸ್ವೀಯಂ ಯದ್ಯದ್ ಘಟಿಷ್ಯತೇ ತತ್ತತ್ ತೇಭ್ಯಃ ಕಥಯಿತುಂ ಪ್ರಾರೇಭೇ; ");
INSERT INTO sankan_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ಪಶ್ಯತ ವಯಂ ಯಿರೂಶಾಲಮ್ಪುರಂ ಯಾಮಃ, ತತ್ರ ಮನುಷ್ಯಪುತ್ರಃ ಪ್ರಧಾನಯಾಜಕಾನಾಮ್ ಉಪಾಧ್ಯಾಯಾನಾಞ್ಚ ಕರೇಷು ಸಮರ್ಪಯಿಷ್ಯತೇ; ತೇ ಚ ವಧದಣ್ಡಾಜ್ಞಾಂ ದಾಪಯಿತ್ವಾ ಪರದೇಶೀಯಾನಾಂ ಕರೇಷು ತಂ ಸಮರ್ಪಯಿಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ತೇ ತಮುಪಹಸ್ಯ ಕಶಯಾ ಪ್ರಹೃತ್ಯ ತದ್ವಪುಷಿ ನಿಷ್ಠೀವಂ ನಿಕ್ಷಿಪ್ಯ ತಂ ಹನಿಷ್ಯನ್ತಿ, ತತಃ ಸ ತೃತೀಯದಿನೇ ಪ್ರೋತ್ಥಾಸ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ತತಃ ಸಿವದೇಃ ಪುತ್ರೌ ಯಾಕೂಬ್ಯೋಹನೌ ತದನ್ತಿಕಮ್ ಏತ್ಯ ಪ್ರೋಚತುಃ, ಹೇ ಗುರೋ ಯದ್ ಆವಾಭ್ಯಾಂ ಯಾಚಿಷ್ಯತೇ ತದಸ್ಮದರ್ಥಂ ಭವಾನ್ ಕರೋತು ನಿವೇದನಮಿದಮಾವಯೋಃ| ");
INSERT INTO sankan_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ತತಃ ಸ ಕಥಿತವಾನ್, ಯುವಾಂ ಕಿಮಿಚ್ಛಥಃ? ಕಿಂ ಮಯಾ ಯುಷ್ಮದರ್ಥಂ ಕರಣೀಯಂ? ");
INSERT INTO sankan_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ತದಾ ತೌ ಪ್ರೋಚತುಃ, ಆವಯೋರೇಕಂ ದಕ್ಷಿಣಪಾರ್ಶ್ವೇ ವಾಮಪಾರ್ಶ್ವೇ ಚೈಕಂ ತವೈಶ್ವರ್ಯ್ಯಪದೇ ಸಮುಪವೇಷ್ಟುಮ್ ಆಜ್ಞಾಪಯ| ");
INSERT INTO sankan_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ಕಿನ್ತು ಯೀಶುಃ ಪ್ರತ್ಯುವಾಚ ಯುವಾಮಜ್ಞಾತ್ವೇದಂ ಪ್ರಾರ್ಥಯೇಥೇ, ಯೇನ ಕಂಸೇನಾಹಂ ಪಾಸ್ಯಾಮಿ ತೇನ ಯುವಾಭ್ಯಾಂ ಕಿಂ ಪಾತುಂ ಶಕ್ಷ್ಯತೇ? ಯಸ್ಮಿನ್ ಮಜ್ಜನೇನಾಹಂ ಮಜ್ಜಿಷ್ಯೇ ತನ್ಮಜ್ಜನೇ ಮಜ್ಜಯಿತುಂ ಕಿಂ ಯುವಾಭ್ಯಾಂ ಶಕ್ಷ್ಯತೇ? ತೌ ಪ್ರತ್ಯೂಚತುಃ ಶಕ್ಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","ತದಾ ಯೀಶುರವದತ್ ಯೇನ ಕಂಸೇನಾಹಂ ಪಾಸ್ಯಾಮಿ ತೇನಾವಶ್ಯಂ ಯುವಾಮಪಿ ಪಾಸ್ಯಥಃ, ಯೇನ ಮಜ್ಜನೇನ ಚಾಹಂ ಮಜ್ಜಿಯ್ಯೇ ತತ್ರ ಯುವಾಮಪಿ ಮಜ್ಜಿಷ್ಯೇಥೇ| ");
INSERT INTO sankan_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ಕಿನ್ತು ಯೇಷಾಮರ್ಥಮ್ ಇದಂ ನಿರೂಪಿತಂ, ತಾನ್ ವಿಹಾಯಾನ್ಯಂ ಕಮಪಿ ಮಮ ದಕ್ಷಿಣಪಾರ್ಶ್ವೇ ವಾಮಪಾರ್ಶ್ವೇ ವಾ ಸಮುಪವೇಶಯಿತುಂ ಮಮಾಧಿಕಾರೋ ನಾಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ಅಥಾನ್ಯದಶಶಿಷ್ಯಾ ಇಮಾಂ ಕಥಾಂ ಶ್ರುತ್ವಾ ಯಾಕೂಬ್ಯೋಹನ್ಭ್ಯಾಂ ಚುಕುಪುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ಕಿನ್ತು ಯೀಶುಸ್ತಾನ್ ಸಮಾಹೂಯ ಬಭಾಷೇ, ಅನ್ಯದೇಶೀಯಾನಾಂ ರಾಜತ್ವಂ ಯೇ ಕುರ್ವ್ವನ್ತಿ ತೇ ತೇಷಾಮೇವ ಪ್ರಭುತ್ವಂ ಕುರ್ವ್ವನ್ತಿ, ತಥಾ ಯೇ ಮಹಾಲೋಕಾಸ್ತೇ ತೇಷಾಮ್ ಅಧಿಪತಿತ್ವಂ ಕುರ್ವ್ವನ್ತೀತಿ ಯೂಯಂ ಜಾನೀಥ| ");
INSERT INTO sankan_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","ಕಿನ್ತು ಯುಷ್ಮಾಕಂ ಮಧ್ಯೇ ನ ತಥಾ ಭವಿಷ್ಯತಿ, ಯುಷ್ಮಾಕಂ ಮಧ್ಯೇ ಯಃ ಪ್ರಾಧಾನ್ಯಂ ವಾಞ್ಛತಿ ಸ ಯುಷ್ಮಾಕಂ ಸೇವಕೋ ಭವಿಷ್ಯತಿ, ");
INSERT INTO sankan_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ಯುಷ್ಮಾಕಂ ಯೋ ಮಹಾನ್ ಭವಿತುಮಿಚ್ಛತಿ ಸ ಸರ್ವ್ವೇಷಾಂ ಕಿಙ್ಕರೋ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","ಯತೋ ಮನುಷ್ಯಪುತ್ರಃ ಸೇವ್ಯೋ ಭವಿತುಂ ನಾಗತಃ ಸೇವಾಂ ಕರ್ತ್ತಾಂ ತಥಾನೇಕೇಷಾಂ ಪರಿತ್ರಾಣಸ್ಯ ಮೂಲ್ಯರೂಪಸ್ವಪ್ರಾಣಂ ದಾತುಞ್ಚಾಗತಃ| ");
INSERT INTO sankan_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ಅಥ ತೇ ಯಿರೀಹೋನಗರಂ ಪ್ರಾಪ್ತಾಸ್ತಸ್ಮಾತ್ ಶಿಷ್ಯೈ ರ್ಲೋಕೈಶ್ಚ ಸಹ ಯೀಶೋ ರ್ಗಮನಕಾಲೇ ಟೀಮಯಸ್ಯ ಪುತ್ರೋ ಬರ್ಟೀಮಯನಾಮಾ ಅನ್ಧಸ್ತನ್ಮಾರ್ಗಪಾರ್ಶ್ವೇ ಭಿಕ್ಷಾರ್ಥಮ್ ಉಪವಿಷ್ಟಃ| ");
INSERT INTO sankan_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ಸ ನಾಸರತೀಯಸ್ಯ ಯೀಶೋರಾಗಮನವಾರ್ತ್ತಾಂ ಪ್ರಾಪ್ಯ ಪ್ರೋಚೈ ರ್ವಕ್ತುಮಾರೇಭೇ, ಹೇ ಯೀಶೋ ದಾಯೂದಃ ಸನ್ತಾನ ಮಾಂ ದಯಸ್ವ| ");
INSERT INTO sankan_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ತತೋನೇಕೇ ಲೋಕಾ ಮೌನೀಭವೇತಿ ತಂ ತರ್ಜಯಾಮಾಸುಃ, ಕಿನ್ತು ಸ ಪುನರಧಿಕಮುಚ್ಚೈ ರ್ಜಗಾದ, ಹೇ ಯೀಶೋ ದಾಯೂದಃ ಸನ್ತಾನ ಮಾಂ ದಯಸ್ವ| ");
INSERT INTO sankan_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","ತದಾ ಯೀಶುಃ ಸ್ಥಿತ್ವಾ ತಮಾಹ್ವಾತುಂ ಸಮಾದಿದೇಶ, ತತೋ ಲೋಕಾಸ್ತಮನ್ಧಮಾಹೂಯ ಬಭಾಷಿರೇ, ಹೇ ನರ, ಸ್ಥಿರೋ ಭವ, ಉತ್ತಿಷ್ಠ, ಸ ತ್ವಾಮಾಹ್ವಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ತದಾ ಸ ಉತ್ತರೀಯವಸ್ತ್ರಂ ನಿಕ್ಷಿಪ್ಯ ಪ್ರೋತ್ಥಾಯ ಯೀಶೋಃ ಸಮೀಪಂ ಗತಃ| ");
INSERT INTO sankan_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ತತೋ ಯೀಶುಸ್ತಮವದತ್ ತ್ವಯಾ ಕಿಂ ಪ್ರಾರ್ಥ್ಯತೇ? ತುಭ್ಯಮಹಂ ಕಿಂ ಕರಿಷ್ಯಾಮೀ? ತದಾ ಸೋನ್ಧಸ್ತಮುವಾಚ, ಹೇ ಗುರೋ ಮದೀಯಾ ದೃಷ್ಟಿರ್ಭವೇತ್| ");
INSERT INTO sankan_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ತತೋ ಯೀಶುಸ್ತಮುವಾಚ ಯಾಹಿ ತವ ವಿಶ್ವಾಸಸ್ತ್ವಾಂ ಸ್ವಸ್ಥಮಕಾರ್ಷೀತ್, ತಸ್ಮಾತ್ ತತ್ಕ್ಷಣಂ ಸ ದೃಷ್ಟಿಂ ಪ್ರಾಪ್ಯ ಪಥಾ ಯೀಶೋಃ ಪಶ್ಚಾದ್ ಯಯೌ| ");
INSERT INTO sankan_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ಅನನ್ತರಂ ತೇಷು ಯಿರೂಶಾಲಮಃ ಸಮೀಪಸ್ಥಯೋ ರ್ಬೈತ್ಫಗೀಬೈಥನೀಯಪುರಯೋರನ್ತಿಕಸ್ಥಂ ಜೈತುನನಾಮಾದ್ರಿಮಾಗತೇಷು ಯೀಶುಃ ಪ್ರೇಷಣಕಾಲೇ ದ್ವೌ ಶಿಷ್ಯಾವಿದಂ ವಾಕ್ಯಂ ಜಗಾದ, ");
INSERT INTO sankan_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ಯುವಾಮಮುಂ ಸಮ್ಮುಖಸ್ಥಂ ಗ್ರಾಮಂ ಯಾತಂ, ತತ್ರ ಪ್ರವಿಶ್ಯ ಯೋ ನರಂ ನಾವಹತ್ ತಂ ಗರ್ದ್ದಭಶಾವಕಂ ದ್ರಕ್ಷ್ಯಥಸ್ತಂ ಮೋಚಯಿತ್ವಾನಯತಂ| ");
INSERT INTO sankan_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","ಕಿನ್ತು ಯುವಾಂ ಕರ್ಮ್ಮೇದಂ ಕುತಃ ಕುರುಥಃ? ಕಥಾಮಿಮಾಂ ಯದಿ ಕೋಪಿ ಪೃಚ್ಛತಿ ತರ್ಹಿ ಪ್ರಭೋರತ್ರ ಪ್ರಯೋಜನಮಸ್ತೀತಿ ಕಥಿತೇ ಸ ಶೀಘ್ರಂ ತಮತ್ರ ಪ್ರೇಷಯಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ತತಸ್ತೌ ಗತ್ವಾ ದ್ವಿಮಾರ್ಗಮೇಲನೇ ಕಸ್ಯಚಿದ್ ದ್ವಾರಸ್ಯ ಪಾರ್ಶ್ವೇ ತಂ ಗರ್ದ್ದಭಶಾವಕಂ ಪ್ರಾಪ್ಯ ಮೋಚಯತಃ, ");
INSERT INTO sankan_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ಏತರ್ಹಿ ತತ್ರೋಪಸ್ಥಿತಲೋಕಾನಾಂ ಕಶ್ಚಿದ್ ಅಪೃಚ್ಛತ್, ಗರ್ದ್ದಭಶಿಶುಂ ಕುತೋ ಮೋಚಯಥಃ? ");
INSERT INTO sankan_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ತದಾ ಯೀಶೋರಾಜ್ಞಾನುಸಾರೇಣ ತೇಭ್ಯಃ ಪ್ರತ್ಯುದಿತೇ ತತ್ಕ್ಷಣಂ ತಮಾದಾತುಂ ತೇಽನುಜಜ್ಞುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ಅಥ ತೌ ಯೀಶೋಃ ಸನ್ನಿಧಿಂ ಗರ್ದ್ದಭಶಿಶುಮ್ ಆನೀಯ ತದುಪರಿ ಸ್ವವಸ್ತ್ರಾಣಿ ಪಾತಯಾಮಾಸತುಃ; ತತಃ ಸ ತದುಪರಿ ಸಮುಪವಿಷ್ಟಃ| ");
INSERT INTO sankan_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ತದಾನೇಕೇ ಪಥಿ ಸ್ವವಾಸಾಂಸಿ ಪಾತಯಾಮಾಸುಃ, ಪರೈಶ್ಚ ತರುಶಾಖಾಶ್ಛಿತವಾ ಮಾರ್ಗೇ ವಿಕೀರ್ಣಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","ಅಪರಞ್ಚ ಪಶ್ಚಾದ್ಗಾಮಿನೋಽಗ್ರಗಾಮಿನಶ್ಚ ಸರ್ವ್ವೇ ಜನಾ ಉಚೈಃಸ್ವರೇಣ ವಕ್ತುಮಾರೇಭಿರೇ, ಜಯ ಜಯ ಯಃ ಪರಮೇಶ್ವರಸ್ಯ ನಾಮ್ನಾಗಚ್ಛತಿ ಸ ಧನ್ಯ ಇತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","ತಥಾಸ್ಮಾಕಮಂ ಪೂರ್ವ್ವಪುರುಷಸ್ಯ ದಾಯೂದೋ ಯದ್ರಾಜ್ಯಂ ಪರಮೇಶ್ವರನಾಮ್ನಾಯಾತಿ ತದಪಿ ಧನ್ಯಂ, ಸರ್ವ್ವಸ್ಮಾದುಚ್ಛ್ರಾಯೇ ಸ್ವರ್ಗೇ ಈಶ್ವರಸ್ಯ ಜಯೋ ಭವೇತ್| ");
INSERT INTO sankan_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ಇತ್ಥಂ ಯೀಶು ರ್ಯಿರೂಶಾಲಮಿ ಮನ್ದಿರಂ ಪ್ರವಿಶ್ಯ ಚತುರ್ದಿಕ್ಸ್ಥಾನಿ ಸರ್ವ್ವಾಣಿ ವಸ್ತೂನಿ ದೃಷ್ಟವಾನ್; ಅಥ ಸಾಯಂಕಾಲ ಉಪಸ್ಥಿತೇ ದ್ವಾದಶಶಿಷ್ಯಸಹಿತೋ ಬೈಥನಿಯಂ ಜಗಾಮ| ");
INSERT INTO sankan_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","ಅಪರೇಹನಿ ಬೈಥನಿಯಾದ್ ಆಗಮನಸಮಯೇ ಕ್ಷುಧಾರ್ತ್ತೋ ಬಭೂವ| ");
INSERT INTO sankan_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ತತೋ ದೂರೇ ಸಪತ್ರಮುಡುಮ್ಬರಪಾದಪಂ ವಿಲೋಕ್ಯ ತತ್ರ ಕಿಞ್ಚಿತ್ ಫಲಂ ಪ್ರಾಪ್ತುಂ ತಸ್ಯ ಸನ್ನಿಕೃಷ್ಟಂ ಯಯೌ, ತದಾನೀಂ ಫಲಪಾತನಸ್ಯ ಸಮಯೋ ನಾಗಚ್ಛತಿ| ತತಸ್ತತ್ರೋಪಸ್ಥಿತಃ ಪತ್ರಾಣಿ ವಿನಾ ಕಿಮಪ್ಯಪರಂ ನ ಪ್ರಾಪ್ಯ ಸ ಕಥಿತವಾನ್, ");
INSERT INTO sankan_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ಅದ್ಯಾರಭ್ಯ ಕೋಪಿ ಮಾನವಸ್ತ್ವತ್ತಃ ಫಲಂ ನ ಭುಞ್ಜೀತ; ಇಮಾಂ ಕಥಾಂ ತಸ್ಯ ಶಿಷ್ಯಾಃ ಶುಶ್ರುವುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","ತದನನ್ತರಂ ತೇಷು ಯಿರೂಶಾಲಮಮಾಯಾತೇಷು ಯೀಶು ರ್ಮನ್ದಿರಂ ಗತ್ವಾ ತತ್ರಸ್ಥಾನಾಂ ಬಣಿಜಾಂ ಮುದ್ರಾಸನಾನಿ ಪಾರಾವತವಿಕ್ರೇತೃಣಾಮ್ ಆಸನಾನಿ ಚ ನ್ಯುಬ್ಜಯಾಞ್ಚಕಾರ ಸರ್ವ್ವಾನ್ ಕ್ರೇತೃನ್ ವಿಕ್ರೇತೃಂಶ್ಚ ಬಹಿಶ್ಚಕಾರ| ");
INSERT INTO sankan_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ಅಪರಂ ಮನ್ದಿರಮಧ್ಯೇನ ಕಿಮಪಿ ಪಾತ್ರಂ ವೋಢುಂ ಸರ್ವ್ವಜನಂ ನಿವಾರಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ಲೋಕಾನುಪದಿಶನ್ ಜಗಾದ, ಮಮ ಗೃಹಂ ಸರ್ವ್ವಜಾತೀಯಾನಾಂ ಪ್ರಾರ್ಥನಾಗೃಹಮ್ ಇತಿ ನಾಮ್ನಾ ಪ್ರಥಿತಂ ಭವಿಷ್ಯತಿ ಏತತ್ ಕಿಂ ಶಾಸ್ತ್ರೇ ಲಿಖಿತಂ ನಾಸ್ತಿ? ಕಿನ್ತು ಯೂಯಂ ತದೇವ ಚೋರಾಣಾಂ ಗಹ್ವರಂ ಕುರುಥ| ");
INSERT INTO sankan_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ಇಮಾಂ ವಾಣೀಂ ಶ್ರುತ್ವಾಧ್ಯಾಪಕಾಃ ಪ್ರಧಾನಯಾಜಕಾಶ್ಚ ತಂ ಯಥಾ ನಾಶಯಿತುಂ ಶಕ್ನುವನ್ತಿ ತಥೋेಪಾಯಂ ಮೃಗಯಾಮಾಸುಃ, ಕಿನ್ತು ತಸ್ಯೋಪದೇಶಾತ್ ಸರ್ವ್ವೇ ಲೋಕಾ ವಿಸ್ಮಯಂ ಗತಾ ಅತಸ್ತೇ ತಸ್ಮಾದ್ ಬಿಭ್ಯುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ಅಥ ಸಾಯಂಸಮಯ ಉಪಸ್ಥಿತೇ ಯೀಶುರ್ನಗರಾದ್ ಬಹಿರ್ವವ್ರಾಜ| ");
INSERT INTO sankan_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","ಅನನ್ತರಂ ಪ್ರಾತಃಕಾಲೇ ತೇ ತೇನ ಮಾರ್ಗೇಣ ಗಚ್ಛನ್ತಸ್ತಮುಡುಮ್ಬರಮಹೀರುಹಂ ಸಮೂಲಂ ಶುಷ್ಕಂ ದದೃಶುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ತತಃ ಪಿತರಃ ಪೂರ್ವ್ವವಾಕ್ಯಂ ಸ್ಮರನ್ ಯೀಶುಂ ಬಭಾಷಂ, ಹೇ ಗುರೋ ಪಶ್ಯತು ಯ ಉಡುಮ್ಬರವಿಟಪೀ ಭವತಾ ಶಪ್ತಃ ಸ ಶುಷ್ಕೋ ಬಭೂವ| ");
INSERT INTO sankan_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ತತೋ ಯೀಶುಃ ಪ್ರತ್ಯವಾದೀತ್, ಯೂಯಮೀಶ್ವರೇ ವಿಶ್ವಸಿತ| ");
INSERT INTO sankan_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ಯುಷ್ಮಾನಹಂ ಯಥಾರ್ಥಂ ವದಾಮಿ ಕೋಪಿ ಯದ್ಯೇತದ್ಗಿರಿಂ ವದತಿ, ತ್ವಮುತ್ಥಾಯ ಗತ್ವಾ ಜಲಧೌ ಪತ, ಪ್ರೋಕ್ತಮಿದಂ ವಾಕ್ಯಮವಶ್ಯಂ ಘಟಿಷ್ಯತೇ, ಮನಸಾ ಕಿಮಪಿ ನ ಸನ್ದಿಹ್ಯ ಚೇದಿದಂ ವಿಶ್ವಸೇತ್ ತರ್ಹಿ ತಸ್ಯ ವಾಕ್ಯಾನುಸಾರೇಣ ತದ್ ಘಟಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ಅತೋ ಹೇತೋರಹಂ ಯುಷ್ಮಾನ್ ವಚ್ಮಿ, ಪ್ರಾರ್ಥನಾಕಾಲೇ ಯದ್ಯದಾಕಾಂಕ್ಷಿಷ್ಯಧ್ವೇ ತತ್ತದವಶ್ಯಂ ಪ್ರಾಪ್ಸ್ಯಥ, ಇತ್ಥಂ ವಿಶ್ವಸಿತ, ತತಃ ಪ್ರಾಪ್ಸ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","ಅಪರಞ್ಚ ಯುಷ್ಮಾಸು ಪ್ರಾರ್ಥಯಿತುಂ ಸಮುತ್ಥಿತೇಷು ಯದಿ ಕೋಪಿ ಯುಷ್ಮಾಕಮ್ ಅಪರಾಧೀ ತಿಷ್ಠತಿ, ತರ್ಹಿ ತಂ ಕ್ಷಮಧ್ವಂ, ತಥಾ ಕೃತೇ ಯುಷ್ಮಾಕಂ ಸ್ವರ್ಗಸ್ಥಃ ಪಿತಾಪಿ ಯುಷ್ಮಾಕಮಾಗಾಂಮಿ ಕ್ಷಮಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","ಕಿನ್ತು ಯದಿ ನ ಕ್ಷಮಧ್ವೇ ತರ್ಹಿ ವಃ ಸ್ವರ್ಗಸ್ಥಃ ಪಿತಾಪಿ ಯುಷ್ಮಾಕಮಾಗಾಂಸಿ ನ ಕ್ಷಮಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ಅನನ್ತರಂ ತೇ ಪುನ ರ್ಯಿರೂಶಾಲಮಂ ಪ್ರವಿವಿಶುಃ, ಯೀಶು ರ್ಯದಾ ಮಧ್ಯೇಮನ್ದಿರಮ್ ಇತಸ್ತತೋ ಗಚ್ಛತಿ, ತದಾನೀಂ ಪ್ರಧಾನಯಾಜಕಾ ಉಪಾಧ್ಯಾಯಾಃ ಪ್ರಾಞ್ಚಶ್ಚ ತದನ್ತಿಕಮೇತ್ಯ ಕಥಾಮಿಮಾಂ ಪಪ್ರಚ್ಛುಃ, ");
INSERT INTO sankan_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ತ್ವಂ ಕೇನಾದೇಶೇನ ಕರ್ಮ್ಮಾಣ್ಯೇತಾನಿ ಕರೋಷಿ? ತಥೈತಾನಿ ಕರ್ಮ್ಮಾಣಿ ಕರ್ತ್ತಾಂ ಕೇನಾದಿಷ್ಟೋಸಿ? ");
INSERT INTO sankan_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ತತೋ ಯೀಶುಃ ಪ್ರತಿಗದಿತವಾನ್ ಅಹಮಪಿ ಯುಷ್ಮಾನ್ ಏಕಕಥಾಂ ಪೃಚ್ಛಾಮಿ, ಯದಿ ಯೂಯಂ ತಸ್ಯಾ ಉತ್ತರಂ ಕುರುಥ, ತರ್ಹಿ ಕಯಾಜ್ಞಯಾಹಂ ಕರ್ಮ್ಮಾಣ್ಯೇತಾನಿ ಕರೋಮಿ ತದ್ ಯುಷ್ಮಭ್ಯಂ ಕಥಯಿಷ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ಯೋಹನೋ ಮಜ್ಜನಮ್ ಈಶ್ವರಾತ್ ಜಾತಂ ಕಿಂ ಮಾನವಾತ್? ತನ್ಮಹ್ಯಂ ಕಥಯತ| ");
INSERT INTO sankan_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","ತೇ ಪರಸ್ಪರಂ ವಿವೇಕ್ತುಂ ಪ್ರಾರೇಭಿರೇ, ತದ್ ಈಶ್ವರಾದ್ ಬಭೂವೇತಿ ಚೇದ್ ವದಾಮಸ್ತರ್ಹಿ ಕುತಸ್ತಂ ನ ಪ್ರತ್ಯೈತ? ಕಥಮೇತಾಂ ಕಥಯಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","ಮಾನವಾದ್ ಅಭವದಿತಿ ಚೇದ್ ವದಾಮಸ್ತರ್ಹಿ ಲೋಕೇಭ್ಯೋ ಭಯಮಸ್ತಿ ಯತೋ ಹೇತೋಃ ಸರ್ವ್ವೇ ಯೋಹನಂ ಸತ್ಯಂ ಭವಿಷ್ಯದ್ವಾದಿನಂ ಮನ್ಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ಅತಏವ ತೇ ಯೀಶುಂ ಪ್ರತ್ಯವಾದಿಷು ರ್ವಯಂ ತದ್ ವಕ್ತುಂ ನ ಶಕ್ನುಮಃ| ಯೀಶುರುವಾಚ, ತರ್ಹಿ ಯೇನಾದೇಶೇನ ಕರ್ಮ್ಮಾಣ್ಯೇತಾನಿ ಕರೋಮಿ, ಅಹಮಪಿ ಯುಷ್ಮಭ್ಯಂ ತನ್ನ ಕಥಯಿಷ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","ಅನನ್ತರಂ ಯೀಶು ರ್ದೃಷ್ಟಾನ್ತೇನ ತೇಭ್ಯಃ ಕಥಯಿತುಮಾರೇಭೇ, ಕಶ್ಚಿದೇಕೋ ದ್ರಾಕ್ಷಾಕ್ಷೇತ್ರಂ ವಿಧಾಯ ತಚ್ಚತುರ್ದಿಕ್ಷು ವಾರಣೀಂ ಕೃತ್ವಾ ತನ್ಮಧ್ಯೇ ದ್ರಾಕ್ಷಾಪೇಷಣಕುಣ್ಡಮ್ ಅಖನತ್, ತಥಾ ತಸ್ಯ ಗಡಮಪಿ ನಿರ್ಮ್ಮಿತವಾನ್ ತತಸ್ತತ್ಕ್ಷೇತ್ರಂ ಕೃಷೀವಲೇಷು ಸಮರ್ಪ್ಯ ದೂರದೇಶಂ ಜಗಾಮ| ");
INSERT INTO sankan_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","ತದನನ್ತರಂ ಫಲಕಾಲೇ ಕೃಷೀವಲೇಭ್ಯೋ ದ್ರಾಕ್ಷಾಕ್ಷೇತ್ರಫಲಾನಿ ಪ್ರಾಪ್ತುಂ ತೇಷಾಂ ಸವಿಧೇ ಭೃತ್ಯಮ್ ಏಕಂ ಪ್ರಾಹಿಣೋತ್| ");
INSERT INTO sankan_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","ಕಿನ್ತು ಕೃಷೀವಲಾಸ್ತಂ ಧೃತ್ವಾ ಪ್ರಹೃತ್ಯ ರಿಕ್ತಹಸ್ತಂ ವಿಸಸೃಜುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ತತಃ ಸ ಪುನರನ್ಯಮೇಕಂ ಭೃತ್ಯಂ ಪ್ರಷಯಾಮಾಸ, ಕಿನ್ತು ತೇ ಕೃಷೀವಲಾಃ ಪಾಷಾಣಾಘಾತೈಸ್ತಸ್ಯ ಶಿರೋ ಭಙ್ಕ್ತ್ವಾ ಸಾಪಮಾನಂ ತಂ ವ್ಯಸರ್ಜನ್| ");
INSERT INTO sankan_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ತತಃ ಪರಂ ಸೋಪರಂ ದಾಸಂ ಪ್ರಾಹಿಣೋತ್ ತದಾ ತೇ ತಂ ಜಘ್ನುಃ, ಏವಮ್ ಅನೇಕೇಷಾಂ ಕಸ್ಯಚಿತ್ ಪ್ರಹಾರಃ ಕಸ್ಯಚಿದ್ ವಧಶ್ಚ ತೈಃ ಕೃತಃ| ");
INSERT INTO sankan_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ತತಃ ಪರಂ ಮಯಾ ಸ್ವಪುತ್ರೇ ಪ್ರಹಿತೇ ತೇ ತಮವಶ್ಯಂ ಸಮ್ಮಂಸ್ಯನ್ತೇ, ಇತ್ಯುಕ್ತ್ವಾವಶೇಷೇ ತೇಷಾಂ ಸನ್ನಿಧೌ ನಿಜಪ್ರಿಯಮ್ ಅದ್ವಿತೀಯಂ ಪುತ್ರಂ ಪ್ರೇಷಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","ಕಿನ್ತು ಕೃಷೀವಲಾಃ ಪರಸ್ಪರಂ ಜಗದುಃ, ಏಷ ಉತ್ತರಾಧಿಕಾರೀ, ಆಗಚ್ಛತ ವಯಮೇನಂ ಹನ್ಮಸ್ತಥಾ ಕೃತೇ ಽಧಿಕಾರೋಯಮ್ ಅಸ್ಮಾಕಂ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ತತಸ್ತಂ ಧೃತ್ವಾ ಹತ್ವಾ ದ್ರಾಕ್ಷಾಕ್ಷೇತ್ರಾದ್ ಬಹಿಃ ಪ್ರಾಕ್ಷಿಪನ್| ");
INSERT INTO sankan_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","ಅನೇನಾಸೌ ದ್ರಾಕ್ಷಾಕ್ಷೇತ್ರಪತಿಃ ಕಿಂ ಕರಿಷ್ಯತಿ? ಸ ಏತ್ಯ ತಾನ್ ಕೃಷೀವಲಾನ್ ಸಂಹತ್ಯ ತತ್ಕ್ಷೇತ್ರಮ್ ಅನ್ಯೇಷು ಕೃಷೀವಲೇಷು ಸಮರ್ಪಯಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","ಅಪರಞ್ಚ, \"ಸ್ಥಪತಯಃ ಕರಿಷ್ಯನ್ತಿ ಗ್ರಾವಾಣಂ ಯನ್ತು ತುಚ್ಛಕಂ| ಪ್ರಾಧಾನಪ್ರಸ್ತರಃ ಕೋಣೇ ಸ ಏವ ಸಂಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ಏತತ್ ಕರ್ಮ್ಮ ಪರೇಶಸ್ಯಾಂದ್ಭುತಂ ನೋ ದೃಷ್ಟಿತೋ ಭವೇತ್|| \" ಇಮಾಂ ಶಾಸ್ತ್ರೀಯಾಂ ಲಿಪಿಂ ಯೂಯಂ ಕಿಂ ನಾಪಾಠಿಷ್ಟ? ");
INSERT INTO sankan_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ತದಾನೀಂ ಸ ತಾನುದ್ದಿಶ್ಯ ತಾಂ ದೃಷ್ಟಾನ್ತಕಥಾಂ ಕಥಿತವಾನ್, ತ ಇತ್ಥಂ ಬುದ್ವ್ವಾ ತಂ ಧರ್ತ್ತಾಮುದ್ಯತಾಃ, ಕಿನ್ತು ಲೋಕೇಭ್ಯೋ ಬಿಭ್ಯುಃ, ತದನನ್ತರಂ ತೇ ತಂ ವಿಹಾಯ ವವ್ರಜುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ಅಪರಞ್ಚ ತೇ ತಸ್ಯ ವಾಕ್ಯದೋಷಂ ಧರ್ತ್ತಾಂ ಕತಿಪಯಾನ್ ಫಿರೂಶಿನೋ ಹೇರೋದೀಯಾಂಶ್ಚ ಲೋಕಾನ್ ತದನ್ತಿಕಂ ಪ್ರೇಷಯಾಮಾಸುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ತ ಆಗತ್ಯ ತಮವದನ್, ಹೇ ಗುರೋ ಭವಾನ್ ತಥ್ಯಭಾಷೀ ಕಸ್ಯಾಪ್ಯನುರೋಧಂ ನ ಮನ್ಯತೇ, ಪಕ್ಷಪಾತಞ್ಚ ನ ಕರೋತಿ, ಯಥಾರ್ಥತ ಈಶ್ವರೀಯಂ ಮಾರ್ಗಂ ದರ್ಶಯತಿ ವಯಮೇತತ್ ಪ್ರಜಾನೀಮಃ, ಕೈಸರಾಯ ಕರೋ ದೇಯೋ ನ ವಾಂ? ವಯಂ ದಾಸ್ಯಾಮೋ ನ ವಾ? ");
INSERT INTO sankan_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","ಕಿನ್ತು ಸ ತೇಷಾಂ ಕಪಟಂ ಜ್ಞಾತ್ವಾ ಜಗಾದ, ಕುತೋ ಮಾಂ ಪರೀಕ್ಷಧ್ವೇ? ಏಕಂ ಮುದ್ರಾಪಾದಂ ಸಮಾನೀಯ ಮಾಂ ದರ್ಶಯತ| ");
INSERT INTO sankan_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ತದಾ ತೈರೇಕಸ್ಮಿನ್ ಮುದ್ರಾಪಾದೇ ಸಮಾನೀತೇ ಸ ತಾನ್ ಪಪ್ರಚ್ಛ, ಅತ್ರ ಲಿಖಿತಂ ನಾಮ ಮೂರ್ತ್ತಿ ರ್ವಾ ಕಸ್ಯ? ತೇ ಪ್ರತ್ಯೂಚುಃ, ಕೈಸರಸ್ಯ| ");
INSERT INTO sankan_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","ತದಾ ಯೀಶುರವದತ್ ತರ್ಹಿ ಕೈಸರಸ್ಯ ದ್ರವ್ಯಾಣಿ ಕೈಸರಾಯ ದತ್ತ, ಈಶ್ವರಸ್ಯ ದ್ರವ್ಯಾಣಿ ತು ಈಶ್ವರಾಯ ದತ್ತ; ತತಸ್ತೇ ವಿಸ್ಮಯಂ ಮೇನಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","ಅಥ ಮೃತಾನಾಮುತ್ಥಾನಂ ಯೇ ನ ಮನ್ಯನ್ತೇ ತೇ ಸಿದೂಕಿನೋ ಯೀಶೋಃ ಸಮೀಪಮಾಗತ್ಯ ತಂ ಪಪ್ರಚ್ಛುಃ; ");
INSERT INTO sankan_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","ಹೇ ಗುರೋ ಕಶ್ಚಿಜ್ಜನೋ ಯದಿ ನಿಃಸನ್ತತಿಃ ಸನ್ ಭಾರ್ಯ್ಯಾಯಾಂ ಸತ್ಯಾಂ ಮ್ರಿಯತೇ ತರ್ಹಿ ತಸ್ಯ ಭ್ರಾತಾ ತಸ್ಯ ಭಾರ್ಯ್ಯಾಂ ಗೃಹೀತ್ವಾ ಭ್ರಾತು ರ್ವಂಶೋತ್ಪತ್ತಿಂ ಕರಿಷ್ಯತಿ, ವ್ಯವಸ್ಥಾಮಿಮಾಂ ಮೂಸಾ ಅಸ್ಮಾನ್ ಪ್ರತಿ ವ್ಯಲಿಖತ್| ");
INSERT INTO sankan_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ಕಿನ್ತು ಕೇಚಿತ್ ಸಪ್ತ ಭ್ರಾತರ ಆಸನ್, ತತಸ್ತೇಷಾಂ ಜ್ಯೇಷ್ಠಭ್ರಾತಾ ವಿವಹ್ಯ ನಿಃಸನ್ತತಿಃ ಸನ್ ಅಮ್ರಿಯತ| ");
INSERT INTO sankan_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ತತೋ ದ್ವಿತೀಯೋ ಭ್ರಾತಾ ತಾಂ ಸ್ತ್ರಿಯಮಗೃಹಣತ್ ಕಿನ್ತು ಸೋಪಿ ನಿಃಸನ್ತತಿಃ ಸನ್ ಅಮ್ರಿಯತ; ಅಥ ತೃತೀಯೋಪಿ ಭ್ರಾತಾ ತಾದೃಶೋಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ಇತ್ಥಂ ಸಪ್ತೈವ ಭ್ರಾತರಸ್ತಾಂ ಸ್ತ್ರಿಯಂ ಗೃಹೀತ್ವಾ ನಿಃಸನ್ತಾನಾಃ ಸನ್ತೋಽಮ್ರಿಯನ್ತ, ಸರ್ವ್ವಶೇಷೇ ಸಾಪಿ ಸ್ತ್ರೀ ಮ್ರಿಯತೇ ಸ್ಮ| ");
INSERT INTO sankan_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ಅಥ ಮೃತಾನಾಮುತ್ಥಾನಕಾಲೇ ಯದಾ ತ ಉತ್ಥಾಸ್ಯನ್ತಿ ತದಾ ತೇಷಾಂ ಕಸ್ಯ ಭಾರ್ಯ್ಯಾ ಸಾ ಭವಿಷ್ಯತಿ? ಯತಸ್ತೇ ಸಪ್ತೈವ ತಾಂ ವ್ಯವಹನ್| ");
INSERT INTO sankan_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ತತೋ ಯೀಶುಃ ಪ್ರತ್ಯುವಾಚ ಶಾಸ್ತ್ರಮ್ ಈಶ್ವರಶಕ್ತಿಞ್ಚ ಯೂಯಮಜ್ಞಾತ್ವಾ ಕಿಮಭ್ರಾಮ್ಯತ ನ? ");
INSERT INTO sankan_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","ಮೃತಲೋಕಾನಾಮುತ್ಥಾನಂ ಸತಿ ತೇ ನ ವಿವಹನ್ತಿ ವಾಗ್ದತ್ತಾ ಅಪಿ ನ ಭವನ್ತಿ, ಕಿನ್ತು ಸ್ವರ್ಗೀಯದೂತಾನಾಂ ಸದೃಶಾ ಭವನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","ಪುನಶ್ಚ \"ಅಹಮ್ ಇಬ್ರಾಹೀಮ ಈಶ್ವರ ಇಸ್ಹಾಕ ಈಶ್ವರೋ ಯಾಕೂಬಶ್ಚೇಶ್ವರಃ\" ಯಾಮಿಮಾಂ ಕಥಾಂ ಸ್ತಮ್ಬಮಧ್ಯೇ ತಿಷ್ಠನ್ ಈಶ್ವರೋ ಮೂಸಾಮವಾದೀತ್ ಮೃತಾನಾಮುತ್ಥಾನಾರ್ಥೇ ಸಾ ಕಥಾ ಮೂಸಾಲಿಖಿತೇ ಪುಸ್ತಕೇ ಕಿಂ ಯುಷ್ಮಾಭಿ ರ್ನಾಪಾಠಿ? ");
INSERT INTO sankan_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ಈಶ್ವರೋ ಜೀವತಾಂ ಪ್ರಭುಃ ಕಿನ್ತು ಮೃತಾನಾಂ ಪ್ರಭು ರ್ನ ಭವತಿ, ತಸ್ಮಾದ್ಧೇತೋ ರ್ಯೂಯಂ ಮಹಾಭ್ರಮೇಣ ತಿಷ್ಠಥ| ");
INSERT INTO sankan_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ಏತರ್ಹಿ ಏಕೋಧ್ಯಾಪಕ ಏತ್ಯ ತೇಷಾಮಿತ್ಥಂ ವಿಚಾರಂ ಶುಶ್ರಾವ; ಯೀಶುಸ್ತೇಷಾಂ ವಾಕ್ಯಸ್ಯ ಸದುತ್ತರಂ ದತ್ತವಾನ್ ಇತಿ ಬುದ್ವ್ವಾ ತಂ ಪೃಷ್ಟವಾನ್ ಸರ್ವ್ವಾಸಾಮ್ ಆಜ್ಞಾನಾಂ ಕಾ ಶ್ರೇಷ್ಠಾ? ತತೋ ಯೀಶುಃ ಪ್ರತ್ಯುವಾಚ, ");
INSERT INTO sankan_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","\"ಹೇ ಇಸ್ರಾಯೇಲ್ಲೋಕಾ ಅವಧತ್ತ, ಅಸ್ಮಾಕಂ ಪ್ರಭುಃ ಪರಮೇಶ್ವರ ಏಕ ಏವ, ");
INSERT INTO sankan_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ಯೂಯಂ ಸರ್ವ್ವನ್ತಃಕರಣೈಃ ಸರ್ವ್ವಪ್ರಾಣೈಃ ಸರ್ವ್ವಚಿತ್ತೈಃ ಸರ್ವ್ವಶಕ್ತಿಭಿಶ್ಚ ತಸ್ಮಿನ್ ಪ್ರಭೌ ಪರಮೇಶ್ವರೇ ಪ್ರೀಯಧ್ವಂ,\" ಇತ್ಯಾಜ್ಞಾ ಶ್ರೇಷ್ಠಾ| ");
INSERT INTO sankan_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ತಥಾ \"ಸ್ವಪ್ರತಿವಾಸಿನಿ ಸ್ವವತ್ ಪ್ರೇಮ ಕುರುಧ್ವಂ,\" ಏಷಾ ಯಾ ದ್ವಿತೀಯಾಜ್ಞಾ ಸಾ ತಾದೃಶೀ; ಏತಾಭ್ಯಾಂ ದ್ವಾಭ್ಯಾಮ್ ಆಜ್ಞಾಭ್ಯಾಮ್ ಅನ್ಯಾ ಕಾಪ್ಯಾಜ್ಞಾ ಶ್ರೇಷ್ಠಾ ನಾಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ತದಾ ಸೋಧ್ಯಾಪಕಸ್ತಮವದತ್, ಹೇ ಗುರೋ ಸತ್ಯಂ ಭವಾನ್ ಯಥಾರ್ಥಂ ಪ್ರೋಕ್ತವಾನ್ ಯತ ಏಕಸ್ಮಾದ್ ಈಶ್ವರಾದ್ ಅನ್ಯೋ ದ್ವಿತೀಯ ಈಶ್ವರೋ ನಾಸ್ತಿ; ");
INSERT INTO sankan_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ಅಪರಂ ಸರ್ವ್ವಾನ್ತಃಕರಣೈಃ ಸರ್ವ್ವಪ್ರಾಣೈಃ ಸರ್ವ್ವಚಿತ್ತೈಃ ಸರ್ವ್ವಶಕ್ತಿಭಿಶ್ಚ ಈಶ್ವರೇ ಪ್ರೇಮಕರಣಂ ತಥಾ ಸ್ವಮೀಪವಾಸಿನಿ ಸ್ವವತ್ ಪ್ರೇಮಕರಣಞ್ಚ ಸರ್ವ್ವೇಭ್ಯೋ ಹೋಮಬಲಿದಾನಾದಿಭ್ಯಃ ಶ್ರಷ್ಠಂ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","ತತೋ ಯೀಶುಃ ಸುಬುದ್ಧೇರಿವ ತಸ್ಯೇದಮ್ ಉತ್ತರಂ ಶ್ರುತ್ವಾ ತಂ ಭಾಷಿತವಾನ್ ತ್ವಮೀಶ್ವರಸ್ಯ ರಾಜ್ಯಾನ್ನ ದೂರೋಸಿ| ಇತಃ ಪರಂ ತೇನ ಸಹ ಕಸ್ಯಾಪಿ ವಾಕ್ಯಸ್ಯ ವಿಚಾರಂ ಕರ್ತ್ತಾಂ ಕಸ್ಯಾಪಿ ಪ್ರಗಲ್ಭತಾ ನ ಜಾತಾ| ");
INSERT INTO sankan_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","ಅನನ್ತರಂ ಮಧ್ಯೇಮನ್ದಿರಮ್ ಉಪದಿಶನ್ ಯೀಶುರಿಮಂ ಪ್ರಶ್ನಂ ಚಕಾರ, ಅಧ್ಯಾಪಕಾ ಅಭಿಷಿಕ್ತಂ (ತಾರಕಂ) ಕುತೋ ದಾಯೂದಃ ಸನ್ತಾನಂ ವದನ್ತಿ? ");
INSERT INTO sankan_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ಸ್ವಯಂ ದಾಯೂದ್ ಪವಿತ್ರಸ್ಯಾತ್ಮನ ಆವೇಶೇನೇದಂ ಕಥಯಾಮಾಸ| ಯಥಾ| \"ಮಮ ಪ್ರಭುಮಿದಂ ವಾಕ್ಯವದತ್ ಪರಮೇಶ್ವರಃ| ತವ ಶತ್ರೂನಹಂ ಯಾವತ್ ಪಾದಪೀಠಂ ಕರೋಮಿ ನ| ತಾವತ್ ಕಾಲಂ ಮದೀಯೇ ತ್ವಂ ದಕ್ಷಪಾರ್ಶ್ವ್ ಉಪಾವಿಶ| \" ");
INSERT INTO sankan_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","ಯದಿ ದಾಯೂದ್ ತಂ ಪ್ರಭೂಂ ವದತಿ ತರ್ಹಿ ಕಥಂ ಸ ತಸ್ಯ ಸನ್ತಾನೋ ಭವಿತುಮರ್ಹತಿ? ಇತರೇ ಲೋಕಾಸ್ತತ್ಕಥಾಂ ಶ್ರುತ್ವಾನನನ್ದುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","ತದಾನೀಂ ಸ ತಾನುಪದಿಶ್ಯ ಕಥಿತವಾನ್ ಯೇ ನರಾ ದೀರ್ಘಪರಿಧೇಯಾನಿ ಹಟ್ಟೇ ವಿಪನೌ ಚ ");
INSERT INTO sankan_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ಲೋಕಕೃತನಮಸ್ಕಾರಾನ್ ಭಜನಗೃಹೇ ಪ್ರಧಾನಾಸನಾನಿ ಭೋಜನಕಾಲೇ ಪ್ರಧಾನಸ್ಥಾನಾನಿ ಚ ಕಾಙ್ಕ್ಷನ್ತೇ; ");
INSERT INTO sankan_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ವಿಧವಾನಾಂ ಸರ್ವ್ವಸ್ವಂ ಗ್ರಸಿತ್ವಾ ಛಲಾದ್ ದೀರ್ಘಕಾಲಂ ಪ್ರಾರ್ಥಯನ್ತೇ ತೇಭ್ಯ ಉಪಾಧ್ಯಾಯೇಭ್ಯಃ ಸಾವಧಾನಾ ಭವತ; ತೇಽಧಿಕತರಾನ್ ದಣ್ಡಾನ್ ಪ್ರಾಪ್ಸ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","ತದನನ್ತರಂ ಲೋಕಾ ಭಾಣ್ಡಾಗಾರೇ ಮುದ್ರಾ ಯಥಾ ನಿಕ್ಷಿಪನ್ತಿ ಭಾಣ್ಡಾಗಾರಸ್ಯ ಸಮ್ಮುಖೇ ಸಮುಪವಿಶ್ಯ ಯೀಶುಸ್ತದವಲುಲೋಕ; ತದಾನೀಂ ಬಹವೋ ಧನಿನಸ್ತಸ್ಯ ಮಧ್ಯೇ ಬಹೂನಿ ಧನಾನಿ ನಿರಕ್ಷಿಪನ್| ");
INSERT INTO sankan_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ಪಶ್ಚಾದ್ ಏಕಾ ದರಿದ್ರಾ ವಿಧವಾ ಸಮಾಗತ್ಯ ದ್ವಿಪಣಮೂಲ್ಯಾಂ ಮುದ್ರೈಕಾಂ ತತ್ರ ನಿರಕ್ಷಿಪತ್| ");
INSERT INTO sankan_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ತದಾ ಯೀಶುಃ ಶಿಷ್ಯಾನ್ ಆಹೂಯ ಕಥಿತವಾನ್ ಯುಷ್ಮಾನಹಂ ಯಥಾರ್ಥಂ ವದಾಮಿ ಯೇ ಯೇ ಭಾಣ್ಡಾಗಾರೇಽಸ್ಮಿನ ಧನಾನಿ ನಿಃಕ್ಷಿಪನ್ತಿ ಸ್ಮ ತೇಭ್ಯಃ ಸರ್ವ್ವೇಭ್ಯ ಇಯಂ ವಿಧವಾ ದರಿದ್ರಾಧಿಕಮ್ ನಿಃಕ್ಷಿಪತಿ ಸ್ಮ| ");
INSERT INTO sankan_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ಯತಸ್ತೇ ಪ್ರಭೂತಧನಸ್ಯ ಕಿಞ್ಚಿತ್ ನಿರಕ್ಷಿಪನ್ ಕಿನ್ತು ದೀನೇಯಂ ಸ್ವದಿನಯಾಪನಯೋಗ್ಯಂ ಕಿಞ್ಚಿದಪಿ ನ ಸ್ಥಾಪಯಿತ್ವಾ ಸರ್ವ್ವಸ್ವಂ ನಿರಕ್ಷಿಪತ್| ");
INSERT INTO sankan_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","ಅನನ್ತರಂ ಮನ್ದಿರಾದ್ ಬಹಿರ್ಗಮನಕಾಲೇ ತಸ್ಯ ಶಿಷ್ಯಾಣಾಮೇಕಸ್ತಂ ವ್ಯಾಹೃತವಾನ್ ಹೇ ಗುರೋ ಪಶ್ಯತು ಕೀದೃಶಾಃ ಪಾಷಾಣಾಃ ಕೀದೃಕ್ ಚ ನಿಚಯನಂ| ");
INSERT INTO sankan_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","ತದಾ ಯೀಶುಸ್ತಮ್ ಅವದತ್ ತ್ವಂ ಕಿಮೇತದ್ ಬೃಹನ್ನಿಚಯನಂ ಪಶ್ಯಸಿ? ಅಸ್ಯೈಕಪಾಷಾಣೋಪಿ ದ್ವಿತೀಯಪಾಷಾಣೋಪರಿ ನ ಸ್ಥಾಸ್ಯತಿ ಸರ್ವ್ವೇ ಽಧಃಕ್ಷೇಪ್ಸ್ಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","ಅಥ ಯಸ್ಮಿನ್ ಕಾಲೇ ಜೈತುನ್ಗಿರೌ ಮನ್ದಿರಸ್ಯ ಸಮ್ಮುಖೇ ಸ ಸಮುಪವಿಷ್ಟಸ್ತಸ್ಮಿನ್ ಕಾಲೇ ಪಿತರೋ ಯಾಕೂಬ್ ಯೋಹನ್ ಆನ್ದ್ರಿಯಶ್ಚೈತೇ ತಂ ರಹಸಿ ಪಪ್ರಚ್ಛುಃ, ");
INSERT INTO sankan_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","ಏತಾ ಘಟನಾಃ ಕದಾ ಭವಿಷ್ಯನ್ತಿ? ತಥೈತತ್ಸರ್ವ್ವಾಸಾಂ ಸಿದ್ಧ್ಯುಪಕ್ರಮಸ್ಯ ವಾ ಕಿಂ ಚಿಹ್ನಂ? ತದಸ್ಮಭ್ಯಂ ಕಥಯತು ಭವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ತತೋ ಯಾಶುಸ್ತಾನ್ ವಕ್ತುಮಾರೇಭೇ, ಕೋಪಿ ಯಥಾ ಯುಷ್ಮಾನ್ ನ ಭ್ರಾಮಯತಿ ತಥಾತ್ರ ಯೂಯಂ ಸಾವಧಾನಾ ಭವತ| ");
INSERT INTO sankan_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ಯತಃ ಖ್ರೀಷ್ಟೋಹಮಿತಿ ಕಥಯಿತ್ವಾ ಮಮ ನಾಮ್ನಾನೇಕೇ ಸಮಾಗತ್ಯ ಲೋಕಾನಾಂ ಭ್ರಮಂ ಜನಯಿಷ್ಯನ್ತಿ; ");
INSERT INTO sankan_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","ಕಿನ್ತು ಯೂಯಂ ರಣಸ್ಯ ವಾರ್ತ್ತಾಂ ರಣಾಡಮ್ಬರಞ್ಚ ಶ್ರುತ್ವಾ ಮಾ ವ್ಯಾಕುಲಾ ಭವತ, ಘಟನಾ ಏತಾ ಅವಶ್ಯಮ್ಮಾವಿನ್ಯಃ; ಕಿನ್ತ್ವಾಪಾತತೋ ನ ಯುಗಾನ್ತೋ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","ದೇಶಸ್ಯ ವಿಪಕ್ಷತಯಾ ದೇಶೋ ರಾಜ್ಯಸ್ಯ ವಿಪಕ್ಷತಯಾ ಚ ರಾಜ್ಯಮುತ್ಥಾಸ್ಯತಿ, ತಥಾ ಸ್ಥಾನೇ ಸ್ಥಾನೇ ಭೂಮಿಕಮ್ಪೋ ದುರ್ಭಿಕ್ಷಂ ಮಹಾಕ್ಲೇಶಾಶ್ಚ ಸಮುಪಸ್ಥಾಸ್ಯನ್ತಿ, ಸರ್ವ್ವ ಏತೇ ದುಃಖಸ್ಯಾರಮ್ಭಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","ಕಿನ್ತು ಯೂಯಮ್ ಆತ್ಮಾರ್ಥೇ ಸಾವಧಾನಾಸ್ತಿಷ್ಠತ, ಯತೋ ಲೋಕಾ ರಾಜಸಭಾಯಾಂ ಯುಷ್ಮಾನ್ ಸಮರ್ಪಯಿಷ್ಯನ್ತಿ, ತಥಾ ಭಜನಗೃಹೇ ಪ್ರಹರಿಷ್ಯನ್ತಿ; ಯೂಯಂ ಮದರ್ಥೇ ದೇಶಾಧಿಪಾನ್ ಭೂಪಾಂಶ್ಚ ಪ್ರತಿ ಸಾಕ್ಷ್ಯದಾನಾಯ ತೇಷಾಂ ಸಮ್ಮುಖೇ ಉಪಸ್ಥಾಪಯಿಷ್ಯಧ್ವೇ| ");
INSERT INTO sankan_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ಶೇಷೀಭವನಾತ್ ಪೂರ್ವ್ವಂ ಸರ್ವ್ವಾನ್ ದೇಶೀಯಾನ್ ಪ್ರತಿ ಸುಸಂವಾದಃ ಪ್ರಚಾರಯಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","ಕಿನ್ತು ಯದಾ ತೇ ಯುಷ್ಮಾನ್ ಧೃತ್ವಾ ಸಮರ್ಪಯಿಷ್ಯನ್ತಿ ತದಾ ಯೂಯಂ ಯದ್ಯದ್ ಉತ್ತರಂ ದಾಸ್ಯಥ, ತದಗ್ರ ತಸ್ಯ ವಿವೇಚನಂ ಮಾ ಕುರುತ ತದರ್ಥಂ ಕಿಞ್ಚಿದಪಿ ಮಾ ಚಿನ್ತಯತ ಚ, ತದಾನೀಂ ಯುಷ್ಮಾಕಂ ಮನಃಸು ಯದ್ಯದ್ ವಾಕ್ಯಮ್ ಉಪಸ್ಥಾಪಯಿಷ್ಯತೇ ತದೇವ ವದಿಷ್ಯಥ, ಯತೋ ಯೂಯಂ ನ ತದ್ವಕ್ತಾರಃ ಕಿನ್ತು ಪವಿತ್ರ ಆತ್ಮಾ ತಸ್ಯ ವಕ್ತಾ| ");
INSERT INTO sankan_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","ತದಾ ಭ್ರಾತಾ ಭ್ರಾತರಂ ಪಿತಾ ಪುತ್ರಂ ಘಾತನಾರ್ಥಂ ಪರಹಸ್ತೇಷು ಸಮರ್ಪಯಿಷ್ಯತೇ, ತಥಾ ಪತ್ಯಾನಿ ಮಾತಾಪಿತ್ರೋ ರ್ವಿಪಕ್ಷತಯಾ ತೌ ಘಾತಯಿಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","ಮಮ ನಾಮಹೇತೋಃ ಸರ್ವ್ವೇಷಾಂ ಸವಿಧೇ ಯೂಯಂ ಜುಗುಪ್ಸಿತಾ ಭವಿಷ್ಯಥ, ಕಿನ್ತು ಯಃ ಕಶ್ಚಿತ್ ಶೇಷಪರ್ಯ್ಯನ್ತಂ ಧೈರ್ಯ್ಯಮ್ ಆಲಮ್ಬಿಷ್ಯತೇ ಸಏವ ಪರಿತ್ರಾಸ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","ದಾನಿಯೇಲ್ಭವಿಷ್ಯದ್ವಾದಿನಾ ಪ್ರೋಕ್ತಂ ಸರ್ವ್ವನಾಶಿ ಜುಗುಪ್ಸಿತಞ್ಚ ವಸ್ತು ಯದಾ ತ್ವಯೋಗ್ಯಸ್ಥಾನೇ ವಿದ್ಯಮಾನಂ ದ್ರಕ್ಷಥ (ಯೋ ಜನಃ ಪಠತಿ ಸ ಬುಧ್ಯತಾಂ) ತದಾ ಯೇ ಯಿಹೂದೀಯದೇಶೇ ತಿಷ್ಠನ್ತಿ ತೇ ಮಹೀಧ್ರಂ ಪ್ರತಿ ಪಲಾಯನ್ತಾಂ; ");
INSERT INTO sankan_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ತಥಾ ಯೋ ನರೋ ಗೃಹೋಪರಿ ತಿಷ್ಠತಿ ಸ ಗೃಹಮಧ್ಯಂ ನಾವರೋಹತು, ತಥಾ ಕಿಮಪಿ ವಸ್ತು ಗ್ರಹೀತುಂ ಮಧ್ಯೇಗೃಹಂ ನ ಪ್ರವಿಶತು; ");
INSERT INTO sankan_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ತಥಾ ಚ ಯೋ ನರಃ ಕ್ಷೇತ್ರೇ ತಿಷ್ಠತಿ ಸೋಪಿ ಸ್ವವಸ್ತ್ರಂ ಗ್ರಹೀತುಂ ಪರಾವೃತ್ಯ ನ ವ್ರಜತು| ");
INSERT INTO sankan_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ತದಾನೀಂ ಗರ್ಬ್ಭವತೀನಾಂ ಸ್ತನ್ಯದಾತ್ರೀಣಾಞ್ಚ ಯೋಷಿತಾಂ ದುರ್ಗತಿ ರ್ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ಯುಷ್ಮಾಕಂ ಪಲಾಯನಂ ಶೀತಕಾಲೇ ಯಥಾ ನ ಭವತಿ ತದರ್ಥಂ ಪ್ರಾರ್ಥಯಧ್ವಂ| ");
INSERT INTO sankan_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ಯತಸ್ತದಾ ಯಾದೃಶೀ ದುರ್ಘಟನಾ ಘಟಿಷ್ಯತೇ ತಾದೃಶೀ ದುರ್ಘಟನಾ ಈಶ್ವರಸೃಷ್ಟೇಃ ಪ್ರಥಮಮಾರಭ್ಯಾದ್ಯ ಯಾವತ್ ಕದಾಪಿ ನ ಜಾತಾ ನ ಜನಿಷ್ಯತೇ ಚ| ");
INSERT INTO sankan_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","ಅಪರಞ್ಚ ಪರಮೇಶ್ವರೋ ಯದಿ ತಸ್ಯ ಸಮಯಸ್ಯ ಸಂಕ್ಷೇಪಂ ನ ಕರೋತಿ ತರ್ಹಿ ಕಸ್ಯಾಪಿ ಪ್ರಾಣಭೃತೋ ರಕ್ಷಾ ಭವಿತುಂ ನ ಶಕ್ಷ್ಯತಿ, ಕಿನ್ತು ಯಾನ್ ಜನಾನ್ ಮನೋನೀತಾನ್ ಅಕರೋತ್ ತೇಷಾಂ ಸ್ವಮನೋನೀತಾನಾಂ ಹೇತೋಃ ಸ ತದನೇಹಸಂ ಸಂಕ್ಷೇಪ್ಸ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","ಅನ್ಯಚ್ಚ ಪಶ್ಯತ ಖ್ರೀಷ್ಟೋತ್ರ ಸ್ಥಾನೇ ವಾ ತತ್ರ ಸ್ಥಾನೇ ವಿದ್ಯತೇ, ತಸ್ಮಿನ್ಕಾಲೇ ಯದಿ ಕಶ್ಚಿದ್ ಯುಷ್ಮಾನ್ ಏತಾದೃಶಂ ವಾಕ್ಯಂ ವ್ಯಾಹರತಿ, ತರ್ಹಿ ತಸ್ಮಿನ್ ವಾಕ್ಯೇ ಭೈವ ವಿಶ್ವಸಿತ| ");
INSERT INTO sankan_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ಯತೋನೇಕೇ ಮಿಥ್ಯಾಖ್ರೀಷ್ಟಾ ಮಿಥ್ಯಾಭವಿಷ್ಯದ್ವಾದಿನಶ್ಚ ಸಮುಪಸ್ಥಾಯ ಬಹೂನಿ ಚಿಹ್ನಾನ್ಯದ್ಭುತಾನಿ ಕರ್ಮ್ಮಾಣಿ ಚ ದರ್ಶಯಿಷ್ಯನ್ತಿ; ತಥಾ ಯದಿ ಸಮ್ಭವತಿ ತರ್ಹಿ ಮನೋನೀತಲೋಕಾನಾಮಪಿ ಮಿಥ್ಯಾಮತಿಂ ಜನಯಿಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","ಪಶ್ಯತ ಘಟನಾತಃ ಪೂರ್ವ್ವಂ ಸರ್ವ್ವಕಾರ್ಯ್ಯಸ್ಯ ವಾರ್ತ್ತಾಂ ಯುಷ್ಮಭ್ಯಮದಾಮ್, ಯೂಯಂ ಸಾವಧಾನಾಸ್ತಿಷ್ಠತ| ");
INSERT INTO sankan_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","ಅಪರಞ್ಚ ತಸ್ಯ ಕ್ಲೇಶಕಾಲಸ್ಯಾವ್ಯವಹಿತೇ ಪರಕಾಲೇ ಭಾಸ್ಕರಃ ಸಾನ್ಧಕಾರೋ ಭವಿಷ್ಯತಿ ತಥೈವ ಚನ್ದ್ರಶ್ಚನ್ದ್ರಿಕಾಂ ನ ದಾಸ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ನಭಃಸ್ಥಾನಿ ನಕ್ಷತ್ರಾಣಿ ಪತಿಷ್ಯನ್ತಿ, ವ್ಯೋಮಮಣ್ಡಲಸ್ಥಾ ಗ್ರಹಾಶ್ಚ ವಿಚಲಿಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","ತದಾನೀಂ ಮಹಾಪರಾಕ್ರಮೇಣ ಮಹೈಶ್ವರ್ಯ್ಯೇಣ ಚ ಮೇಘಮಾರುಹ್ಯ ಸಮಾಯಾನ್ತಂ ಮಾನವಸುತಂ ಮಾನವಾಃ ಸಮೀಕ್ಷಿಷ್ಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ಅನ್ಯಚ್ಚ ಸ ನಿಜದೂತಾನ್ ಪ್ರಹಿತ್ಯ ನಭೋಭೂಮ್ಯೋಃ ಸೀಮಾಂ ಯಾವದ್ ಜಗತಶ್ಚತುರ್ದಿಗ್ಭ್ಯಃ ಸ್ವಮನೋನೀತಲೋಕಾನ್ ಸಂಗ್ರಹೀಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","ಉಡುಮ್ಬರತರೋ ರ್ದೃಷ್ಟಾನ್ತಂ ಶಿಕ್ಷಧ್ವಂ ಯದೋಡುಮ್ಬರಸ್ಯ ತರೋ ರ್ನವೀನಾಃ ಶಾಖಾ ಜಾಯನ್ತೇ ಪಲ್ಲವಾದೀನಿ ಚ ರ್ನಿಗಚ್ಛನ್ತಿ, ತದಾ ನಿದಾಘಕಾಲಃ ಸವಿಧೋ ಭವತೀತಿ ಯೂಯಂ ಜ್ಞಾತುಂ ಶಕ್ನುಥ| ");
INSERT INTO sankan_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ತದ್ವದ್ ಏತಾ ಘಟನಾ ದೃಷ್ಟ್ವಾ ಸ ಕಾಲೋ ದ್ವಾರ್ಯ್ಯುಪಸ್ಥಿತ ಇತಿ ಜಾನೀತ| ");
INSERT INTO sankan_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ಯುಷ್ಮಾನಹಂ ಯಥಾರ್ಥಂ ವದಾಮಿ, ಆಧುನಿಕಲೋಕಾನಾಂ ಗಮನಾತ್ ಪೂರ್ವ್ವಂ ತಾನಿ ಸರ್ವ್ವಾಣಿ ಘಟಿಷ್ಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ದ್ಯಾವಾಪೃಥಿವ್ಯೋ ರ್ವಿಚಲಿತಯೋಃ ಸತ್ಯೋ ರ್ಮದೀಯಾ ವಾಣೀ ನ ವಿಚಲಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","ಅಪರಞ್ಚ ಸ್ವರ್ಗಸ್ಥದೂತಗಣೋ ವಾ ಪುತ್ರೋ ವಾ ತಾತಾದನ್ಯಃ ಕೋಪಿ ತಂ ದಿವಸಂ ತಂ ದಣ್ಡಂ ವಾ ನ ಜ್ಞಾಪಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ಅತಃ ಸ ಸಮಯಃ ಕದಾ ಭವಿಷ್ಯತಿ, ಏತಜ್ಜ್ಞಾನಾಭಾವಾದ್ ಯೂಯಂ ಸಾವಧಾನಾಸ್ತಿಷ್ಠತ, ಸತರ್ಕಾಶ್ಚ ಭೂತ್ವಾ ಪ್ರಾರ್ಥಯಧ್ವಂ; ");
INSERT INTO sankan_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ಯದ್ವತ್ ಕಶ್ಚಿತ್ ಪುಮಾನ್ ಸ್ವನಿವೇಶನಾದ್ ದೂರದೇಶಂ ಪ್ರತಿ ಯಾತ್ರಾಕರಣಕಾಲೇ ದಾಸೇಷು ಸ್ವಕಾರ್ಯ್ಯಸ್ಯ ಭಾರಮರ್ಪಯಿತ್ವಾ ಸರ್ವ್ವಾನ್ ಸ್ವೇ ಸ್ವೇ ಕರ್ಮ್ಮಣಿ ನಿಯೋಜಯತಿ; ಅಪರಂ ದೌವಾರಿಕಂ ಜಾಗರಿತುಂ ಸಮಾದಿಶ್ಯ ಯಾತಿ, ತದ್ವನ್ ನರಪುತ್ರಃ| ");
INSERT INTO sankan_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","ಗೃಹಪತಿಃ ಸಾಯಂಕಾಲೇ ನಿಶೀಥೇ ವಾ ತೃತೀಯಯಾಮೇ ವಾ ಪ್ರಾತಃಕಾಲೇ ವಾ ಕದಾಗಮಿಷ್ಯತಿ ತದ್ ಯೂಯಂ ನ ಜಾನೀಥ; ");
INSERT INTO sankan_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ಸ ಹಠಾದಾಗತ್ಯ ಯಥಾ ಯುಷ್ಮಾನ್ ನಿದ್ರಿತಾನ್ ನ ಪಶ್ಯತಿ, ತದರ್ಥಂ ಜಾಗರಿತಾಸ್ತಿಷ್ಠತ| ");
INSERT INTO sankan_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","ಯುಷ್ಮಾನಹಂ ಯದ್ ವದಾಮಿ ತದೇವ ಸರ್ವ್ವಾನ್ ವದಾಮಿ, ಜಾಗರಿತಾಸ್ತಿಷ್ಠತೇತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ತದಾ ನಿಸ್ತಾರೋತ್ಸವಕಿಣ್ವಹೀನಪೂಪೋತ್ಸವಯೋರಾರಮ್ಭಸ್ಯ ದಿನದ್ವಯೇ ಽವಶಿಷ್ಟೇ ಪ್ರಧಾನಯಾಜಕಾ ಅಧ್ಯಾಪಕಾಶ್ಚ ಕೇನಾಪಿ ಛಲೇನ ಯೀಶುಂ ಧರ್ತ್ತಾಂ ಹನ್ತುಞ್ಚ ಮೃಗಯಾಞ್ಚಕ್ರಿರೇ; ");
INSERT INTO sankan_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ಕಿನ್ತು ಲೋಕಾನಾಂ ಕಲಹಭಯಾದೂಚಿರೇ, ನಚೋತ್ಸವಕಾಲ ಉಚಿತಮೇತದಿತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","ಅನನ್ತರಂ ಬೈಥನಿಯಾಪುुರೇ ಶಿಮೋನಕುಷ್ಠಿನೋ ಗೃಹೇ ಯೋಶೌ ಭೋತ್ಕುಮುಪವಿಷ್ಟೇ ಸತಿ ಕಾಚಿದ್ ಯೋಷಿತ್ ಪಾಣ್ಡರಪಾಷಾಣಸ್ಯ ಸಮ್ಪುಟಕೇನ ಮಹಾರ್ಘ್ಯೋತ್ತಮತೈಲಮ್ ಆನೀಯ ಸಮ್ಪುಟಕಂ ಭಂಕ್ತ್ವಾ ತಸ್ಯೋತ್ತಮಾಙ್ಗೇ ತೈಲಧಾರಾಂ ಪಾತಯಾಞ್ಚಕ್ರೇ| ");
INSERT INTO sankan_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ತಸ್ಮಾತ್ ಕೇಚಿತ್ ಸ್ವಾನ್ತೇ ಕುಪ್ಯನ್ತಃ ಕಥಿತವಂನ್ತಃ ಕುತೋಯಂ ತೈಲಾಪವ್ಯಯಃ? ");
INSERT INTO sankan_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ಯದ್ಯೇತತ್ ತೈಲ ವ್ಯಕ್ರೇಷ್ಯತ ತರ್ಹಿ ಮುದ್ರಾಪಾದಶತತ್ರಯಾದಪ್ಯಧಿಕಂ ತಸ್ಯ ಪ್ರಾಪ್ತಮೂಲ್ಯಂ ದರಿದ್ರಲೋಕೇಭ್ಯೋ ದಾತುಮಶಕ್ಷ್ಯತ, ಕಥಾಮೇತಾಂ ಕಥಯಿತ್ವಾ ತಯಾ ಯೋಷಿತಾ ಸಾಕಂ ವಾಚಾಯುಹ್ಯನ್| ");
INSERT INTO sankan_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","ಕಿನ್ತು ಯೀಶುರುವಾಚ, ಕುತ ಏತಸ್ಯೈ ಕೃಚ್ಛ್ರಂ ದದಾಸಿ? ಮಹ್ಯಮಿಯಂ ಕರ್ಮ್ಮೋತ್ತಮಂ ಕೃತವತೀ| ");
INSERT INTO sankan_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ದರಿದ್ರಾಃ ಸರ್ವ್ವದಾ ಯುಷ್ಮಾಭಿಃ ಸಹ ತಿಷ್ಠನ್ತಿ, ತಸ್ಮಾದ್ ಯೂಯಂ ಯದೇಚ್ಛಥ ತದೈವ ತಾನುಪಕರ್ತ್ತಾಂ ಶಕ್ನುಥ, ಕಿನ್ತ್ವಹಂ ಯುಭಾಭಿಃ ಸಹ ನಿರನ್ತರಂ ನ ತಿಷ್ಠಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","ಅಸ್ಯಾ ಯಥಾಸಾಧ್ಯಂ ತಥೈವಾಕರೋದಿಯಂ, ಶ್ಮಶಾನಯಾಪನಾತ್ ಪೂರ್ವ್ವಂ ಸಮೇತ್ಯ ಮದ್ವಪುಷಿ ತೈಲಮ್ ಅಮರ್ದ್ದಯತ್| ");
INSERT INTO sankan_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","ಅಹಂ ಯುಷ್ಮಭ್ಯಂ ಯಥಾರ್ಥಂ ಕಥಯಾಮಿ, ಜಗತಾಂ ಮಧ್ಯೇ ಯತ್ರ ಯತ್ರ ಸುಸಂವಾದೋಯಂ ಪ್ರಚಾರಯಿಷ್ಯತೇ ತತ್ರ ತತ್ರ ಯೋಷಿತ ಏತಸ್ಯಾಃ ಸ್ಮರಣಾರ್ಥಂ ತತ್ಕೃತಕರ್ಮ್ಮೈತತ್ ಪ್ರಚಾರಯಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ತತಃ ಪರಂ ದ್ವಾದಶಾನಾಂ ಶಿಷ್ಯಾಣಾಮೇಕ ಈಷ್ಕರಿಯೋತೀಯಯಿಹೂದಾಖ್ಯೋ ಯೀಶುಂ ಪರಕರೇಷು ಸಮರ್ಪಯಿತುಂ ಪ್ರಧಾನಯಾಜಕಾನಾಂ ಸಮೀಪಮಿಯಾಯ| ");
INSERT INTO sankan_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ತೇ ತಸ್ಯ ವಾಕ್ಯಂ ಸಮಾಕರ್ಣ್ಯ ಸನ್ತುಷ್ಟಾಃ ಸನ್ತಸ್ತಸ್ಮೈ ಮುದ್ರಾ ದಾತುಂ ಪ್ರತ್ಯಜಾನತ; ತಸ್ಮಾತ್ ಸ ತಂ ತೇಷಾಂ ಕರೇಷು ಸಮರ್ಪಣಾಯೋಪಾಯಂ ಮೃಗಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","ಅನನ್ತರಂ ಕಿಣ್ವಶೂನ್ಯಪೂಪೋತ್ಸವಸ್ಯ ಪ್ರಥಮೇಽಹನಿ ನಿಸ್ತಾರೋತ್ಮವಾರ್ಥಂ ಮೇಷಮಾರಣಾಸಮಯೇ ಶಿಷ್ಯಾಸ್ತಂ ಪಪ್ರಚ್ಛಃ ಕುತ್ರ ಗತ್ವಾ ವಯಂ ನಿಸ್ತಾರೋತ್ಸವಸ್ಯ ಭೋಜ್ಯಮಾಸಾದಯಿಷ್ಯಾಮಃ? ಕಿಮಿಚ್ಛತಿ ಭವಾನ್? ");
INSERT INTO sankan_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","ತದಾನೀಂ ಸ ತೇಷಾಂ ದ್ವಯಂ ಪ್ರೇರಯನ್ ಬಭಾಷೇ ಯುವಯೋಃ ಪುರಮಧ್ಯಂ ಗತಯೋಃ ಸತೋ ರ್ಯೋ ಜನಃ ಸಜಲಕುಮ್ಭಂ ವಹನ್ ಯುವಾಂ ಸಾಕ್ಷಾತ್ ಕರಿಷ್ಯತಿ ತಸ್ಯೈವ ಪಶ್ಚಾದ್ ಯಾತಂ; ");
INSERT INTO sankan_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ಸ ಯತ್ ಸದನಂ ಪ್ರವೇಕ್ಷ್ಯತಿ ತದ್ಭವನಪತಿಂ ವದತಂ, ಗುರುರಾಹ ಯತ್ರ ಸಶಿಷ್ಯೋಹಂ ನಿಸ್ತಾರೋತ್ಸವೀಯಂ ಭೋಜನಂ ಕರಿಷ್ಯಾಮಿ, ಸಾ ಭೋಜನಶಾಲಾ ಕುತ್ರಾಸ್ತಿ? ");
INSERT INTO sankan_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ತತಃ ಸ ಪರಿಷ್ಕೃತಾಂ ಸುಸಜ್ಜಿತಾಂ ಬೃಹತೀಚಞ್ಚ ಯಾಂ ಶಾಲಾಂ ದರ್ಶಯಿಷ್ಯತಿ ತಸ್ಯಾಮಸ್ಮದರ್ಥಂ ಭೋಜ್ಯದ್ರವ್ಯಾಣ್ಯಾಸಾದಯತಂ| ");
INSERT INTO sankan_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ತತಃ ಶಿಷ್ಯೌ ಪ್ರಸ್ಥಾಯ ಪುರಂ ಪ್ರವಿಶ್ಯ ಸ ಯಥೋಕ್ತವಾನ್ ತಥೈವ ಪ್ರಾಪ್ಯ ನಿಸ್ತಾರೋತ್ಸವಸ್ಯ ಭೋಜ್ಯದ್ರವ್ಯಾಣಿ ಸಮಾಸಾದಯೇತಾಮ್| ");
INSERT INTO sankan_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ಅನನ್ತರಂ ಯೀಶುಃ ಸಾಯಂಕಾಲೇ ದ್ವಾದಶಭಿಃ ಶಿಷ್ಯೈಃ ಸಾರ್ದ್ಧಂ ಜಗಾಮ; ");
INSERT INTO sankan_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ಸರ್ವ್ವೇಷು ಭೋಜನಾಯ ಪ್ರೋಪವಿಷ್ಟೇಷು ಸ ತಾನುದಿತವಾನ್ ಯುಷ್ಮಾನಹಂ ಯಥಾರ್ಥಂ ವ್ಯಾಹರಾಮಿ, ಅತ್ರ ಯುಷ್ಮಾಕಮೇಕೋ ಜನೋ ಯೋ ಮಯಾ ಸಹ ಭುಂಕ್ತೇ ಮಾಂ ಪರಕೇರೇಷು ಸಮರ್ಪಯಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","ತದಾನೀಂ ತೇ ದುಃಖಿತಾಃ ಸನ್ತ ಏಕೈಕಶಸ್ತಂ ಪ್ರಷ್ಟುಮಾರಬ್ಧವನ್ತಃ ಸ ಕಿಮಹಂ? ಪಶ್ಚಾದ್ ಅನ್ಯ ಏಕೋಭಿದಧೇ ಸ ಕಿಮಹಂ? ");
INSERT INTO sankan_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ತತಃ ಸ ಪ್ರತ್ಯವದದ್ ಏತೇಷಾಂ ದ್ವಾದಶಾನಾಂ ಯೋ ಜನೋ ಮಯಾ ಸಮಂ ಭೋಜನಾಪಾತ್ರೇ ಪಾಣಿಂ ಮಜ್ಜಯಿಷ್ಯತಿ ಸ ಏವ| ");
INSERT INTO sankan_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","ಮನುಜತನಯಮಧಿ ಯಾದೃಶಂ ಲಿಖಿತಮಾಸ್ತೇ ತದನುರೂಪಾ ಗತಿಸ್ತಸ್ಯ ಭವಿಷ್ಯತಿ, ಕಿನ್ತು ಯೋ ಜನೋ ಮಾನವಸುತಂ ಸಮರ್ಪಯಿಷ್ಯತೇ ಹನ್ತ ತಸ್ಯ ಜನ್ಮಾಭಾವೇ ಸತಿ ಭದ್ರಮಭವಿಷ್ಯತ್| ");
INSERT INTO sankan_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ಅಪರಞ್ಚ ತೇಷಾಂ ಭೋಜನಸಮಯೇ ಯೀಶುಃ ಪೂಪಂ ಗೃಹೀತ್ವೇಶ್ವರಗುಣಾನ್ ಅನುಕೀರ್ತ್ಯ ಭಙ್ಕ್ತ್ವಾ ತೇಭ್ಯೋ ದತ್ತ್ವಾ ಬಭಾಷೇ, ಏತದ್ ಗೃಹೀತ್ವಾ ಭುಞ್ಜೀಧ್ವಮ್ ಏತನ್ಮಮ ವಿಗ್ರಹರೂಪಂ| ");
INSERT INTO sankan_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ಅನನ್ತರಂ ಸ ಕಂಸಂ ಗೃಹೀತ್ವೇಶ್ವರಸ್ಯ ಗುಣಾನ್ ಕೀರ್ತ್ತಯಿತ್ವಾ ತೇಭ್ಯೋ ದದೌ, ತತಸ್ತೇ ಸರ್ವ್ವೇ ಪಪುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ಅಪರಂ ಸ ತಾನವಾದೀದ್ ಬಹೂನಾಂ ನಿಮಿತ್ತಂ ಪಾತಿತಂ ಮಮ ನವೀನನಿಯಮರೂಪಂ ಶೋಣಿತಮೇತತ್| ");
INSERT INTO sankan_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","ಯುಷ್ಮಾನಹಂ ಯಥಾರ್ಥಂ ವದಾಮಿ, ಈಶ್ವರಸ್ಯ ರಾಜ್ಯೇ ಯಾವತ್ ಸದ್ಯೋಜಾತಂ ದ್ರಾಕ್ಷಾರಸಂ ನ ಪಾಸ್ಯಾಮಿ,ತಾವದಹಂ ದ್ರಾಕ್ಷಾಫಲರಸಂ ಪುನ ರ್ನ ಪಾಸ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ತದನನ್ತರಂ ತೇ ಗೀತಮೇಕಂ ಸಂಗೀಯ ಬಹಿ ರ್ಜೈತುನಂ ಶಿಖರಿಣಂ ಯಯುಃ ");
INSERT INTO sankan_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","ಅಥ ಯೀಶುಸ್ತಾನುವಾಚ ನಿಶಾಯಾಮಸ್ಯಾಂ ಮಯಿ ಯುಷ್ಮಾಕಂ ಸರ್ವ್ವೇಷಾಂ ಪ್ರತ್ಯೂಹೋ ಭವಿಷ್ಯತಿ ಯತೋ ಲಿಖಿತಮಾಸ್ತೇ ಯಥಾ, ಮೇಷಾಣಾಂ ರಕ್ಷಕಞ್ಚಾಹಂ ಪ್ರಹರಿಷ್ಯಾಮಿ ವೈ ತತಃ| ಮೇಷಾಣಾಂ ನಿವಹೋ ನೂನಂ ಪ್ರವಿಕೀರ್ಣೋ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","ಕನ್ತು ಮದುತ್ಥಾನೇ ಜಾತೇ ಯುಷ್ಮಾಕಮಗ್ರೇಽಹಂ ಗಾಲೀಲಂ ವ್ರಜಿಷ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ತದಾ ಪಿತರಃ ಪ್ರತಿಬಭಾಷೇ, ಯದ್ಯಪಿ ಸರ್ವ್ವೇಷಾಂ ಪ್ರತ್ಯೂಹೋ ಭವತಿ ತಥಾಪಿ ಮಮ ನೈವ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ತತೋ ಯೀಶುರುಕ್ತಾವಾನ್ ಅಹಂ ತುಭ್ಯಂ ತಥ್ಯಂ ಕಥಯಾಮಿ, ಕ್ಷಣಾದಾಯಾಮದ್ಯ ಕುಕ್ಕುಟಸ್ಯ ದ್ವಿತೀಯವಾರರವಣಾತ್ ಪೂರ್ವ್ವಂ ತ್ವಂ ವಾರತ್ರಯಂ ಮಾಮಪಹ್ನೋಷ್ಯಸೇ| ");
INSERT INTO sankan_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ಕಿನ್ತು ಸ ಗಾಢಂ ವ್ಯಾಹರದ್ ಯದ್ಯಪಿ ತ್ವಯಾ ಸಾರ್ದ್ಧಂ ಮಮ ಪ್ರಾಣೋ ಯಾತಿ ತಥಾಪಿ ಕಥಮಪಿ ತ್ವಾಂ ನಾಪಹ್ನೋಷ್ಯೇ; ಸರ್ವ್ವೇಽಪೀತರೇ ತಥೈವ ಬಭಾಷಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ಅಪರಞ್ಚ ತೇಷು ಗೇತ್ಶಿಮಾನೀನಾಮಕಂ ಸ್ಥಾನ ಗತೇಷು ಸ ಶಿಷ್ಯಾನ್ ಜಗಾದ, ಯಾವದಹಂ ಪ್ರಾರ್ಥಯೇ ತಾವದತ್ರ ಸ್ಥಾನೇ ಯೂಯಂ ಸಮುಪವಿಶತ| ");
INSERT INTO sankan_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","ಅಥ ಸ ಪಿತರಂ ಯಾಕೂಬಂ ಯೋಹನಞ್ಚ ಗೃಹೀತ್ವಾ ವವ್ರಾಜ; ಅತ್ಯನ್ತಂ ತ್ರಾಸಿತೋ ವ್ಯಾಕುಲಿತಶ್ಚ ತೇಭ್ಯಃ ಕಥಯಾಮಾಸ, ");
INSERT INTO sankan_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ನಿಧನಕಾಲವತ್ ಪ್ರಾಣೋ ಮೇಽತೀವ ದಃಖಮೇತಿ, ಯೂಯಂ ಜಾಗ್ರತೋತ್ರ ಸ್ಥಾನೇ ತಿಷ್ಠತ| ");
INSERT INTO sankan_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ತತಃ ಸ ಕಿಞ್ಚಿದ್ದೂರಂ ಗತ್ವಾ ಭೂಮಾವಧೋಮುಖಃ ಪತಿತ್ವಾ ಪ್ರಾರ್ಥಿತವಾನೇತತ್, ಯದಿ ಭವಿತುಂ ಶಕ್ಯಂ ತರ್ಹಿ ದುಃಖಸಮಯೋಯಂ ಮತ್ತೋ ದೂರೀಭವತು| ");
INSERT INTO sankan_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ಅಪರಮುದಿತವಾನ್ ಹೇ ಪಿತ ರ್ಹೇ ಪಿತಃ ಸರ್ವ್ವೇಂ ತ್ವಯಾ ಸಾಧ್ಯಂ, ತತೋ ಹೇತೋರಿಮಂ ಕಂಸಂ ಮತ್ತೋ ದೂರೀಕುರು, ಕಿನ್ತು ತನ್ ಮಮೇಚ್ಛಾತೋ ನ ತವೇಚ್ಛಾತೋ ಭವತು| ");
INSERT INTO sankan_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","ತತಃ ಪರಂ ಸ ಏತ್ಯ ತಾನ್ ನಿದ್ರಿತಾನ್ ನಿರೀಕ್ಷ್ಯ ಪಿತರಂ ಪ್ರೋವಾಚ, ಶಿಮೋನ್ ತ್ವಂ ಕಿಂ ನಿದ್ರಾಸಿ? ಘಟಿಕಾಮೇಕಾಮ್ ಅಪಿ ಜಾಗರಿತುಂ ನ ಶಕ್ನೋಷಿ? ");
INSERT INTO sankan_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","ಪರೀಕ್ಷಾಯಾಂ ಯಥಾ ನ ಪತಥ ತದರ್ಥಂ ಸಚೇತನಾಃ ಸನ್ತಃ ಪ್ರಾರ್ಥಯಧ್ವಂ; ಮನ ಉದ್ಯುಕ್ತಮಿತಿ ಸತ್ಯಂ ಕಿನ್ತು ವಪುರಶಕ್ತಿಕಂ| ");
INSERT INTO sankan_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ಅಥ ಸ ಪುನರ್ವ್ರಜಿತ್ವಾ ಪೂರ್ವ್ವವತ್ ಪ್ರಾರ್ಥಯಾಞ್ಚಕ್ರೇ| ");
INSERT INTO sankan_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ಪರಾವೃತ್ಯಾಗತ್ಯ ಪುನರಪಿ ತಾನ್ ನಿದ್ರಿತಾನ್ ದದರ್ಶ ತದಾ ತೇಷಾಂ ಲೋಚನಾನಿ ನಿದ್ರಯಾ ಪೂರ್ಣಾನಿ, ತಸ್ಮಾತ್ತಸ್ಮೈ ಕಾ ಕಥಾ ಕಥಯಿತವ್ಯಾ ತ ಏತದ್ ಬೋದ್ಧುಂ ನ ಶೇಕುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ತತಃಪರಂ ತೃತೀಯವಾರಂ ಆಗತ್ಯ ತೇಭ್ಯೋ ಽಕಥಯದ್ ಇದಾನೀಮಪಿ ಶಯಿತ್ವಾ ವಿಶ್ರಾಮ್ಯಥ? ಯಥೇಷ್ಟಂ ಜಾತಂ, ಸಮಯಶ್ಚೋಪಸ್ಥಿತಃ ಪಶ್ಯತ ಮಾನವತನಯಃ ಪಾಪಿಲೋಕಾನಾಂ ಪಾಣಿಷು ಸಮರ್ಪ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ಉತ್ತಿಷ್ಠತ, ವಯಂ ವ್ರಜಾಮೋ ಯೋ ಜನೋ ಮಾಂ ಪರಪಾಣಿಷು ಸಮರ್ಪಯಿಷ್ಯತೇ ಪಶ್ಯತ ಸ ಸಮೀಪಮಾಯಾತಃ| ");
INSERT INTO sankan_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ಇಮಾಂ ಕಥಾಂ ಕಥಯತಿ ಸ, ಏತರ್ಹಿದ್ವಾದಶಾನಾಮೇಕೋ ಯಿಹೂದಾ ನಾಮಾ ಶಿಷ್ಯಃ ಪ್ರಧಾನಯಾಜಕಾನಾಮ್ ಉಪಾಧ್ಯಾಯಾನಾಂ ಪ್ರಾಚೀನಲೋಕಾನಾಞ್ಚ ಸನ್ನಿಧೇಃ ಖಙ್ಗಲಗುಡಧಾರಿಣೋ ಬಹುಲೋಕಾನ್ ಗೃಹೀತ್ವಾ ತಸ್ಯ ಸಮೀಪ ಉಪಸ್ಥಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ಅಪರಞ್ಚಾಸೌ ಪರಪಾಣಿಷು ಸಮರ್ಪಯಿತಾ ಪೂರ್ವ್ವಮಿತಿ ಸಙ್ಕೇತಂ ಕೃತವಾನ್ ಯಮಹಂ ಚುಮ್ಬಿಷ್ಯಾಮಿ ಸ ಏವಾಸೌ ತಮೇವ ಧೃತ್ವಾ ಸಾವಧಾನಂ ನಯತ| ");
INSERT INTO sankan_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ಅತೋ ಹೇತೋಃ ಸ ಆಗತ್ಯೈವ ಯೋಶೋಃ ಸವಿಧಂ ಗತ್ವಾ ಹೇ ಗುರೋ ಹೇ ಗುರೋ, ಇತ್ಯುಕ್ತ್ವಾ ತಂ ಚುಚುಮ್ಬ| ");
INSERT INTO sankan_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ತದಾ ತೇ ತದುಪರಿ ಪಾಣೀನರ್ಪಯಿತ್ವಾ ತಂ ದಧ್ನುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ತತಸ್ತಸ್ಯ ಪಾರ್ಶ್ವಸ್ಥಾನಾಂ ಲೋಕಾನಾಮೇಕಃ ಖಙ್ಗಂ ನಿಷ್ಕೋಷಯನ್ ಮಹಾಯಾಜಕಸ್ಯ ದಾಸಮೇಕಂ ಪ್ರಹೃತ್ಯ ತಸ್ಯ ಕರ್ಣಂ ಚಿಚ್ಛೇದ| ");
INSERT INTO sankan_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","ಪಶ್ಚಾದ್ ಯೀಶುಸ್ತಾನ್ ವ್ಯಾಜಹಾರ ಖಙ್ಗಾನ್ ಲಗುಡಾಂಶ್ಚ ಗೃಹೀತ್ವಾ ಮಾಂ ಕಿಂ ಚೌರಂ ಧರ್ತ್ತಾಂ ಸಮಾಯಾತಾಃ? ");
INSERT INTO sankan_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","ಮಧ್ಯೇಮನ್ದಿರಂ ಸಮುಪದಿಶನ್ ಪ್ರತ್ಯಹಂ ಯುಷ್ಮಾಭಿಃ ಸಹ ಸ್ಥಿತವಾನತಹಂ, ತಸ್ಮಿನ್ ಕಾಲೇ ಯೂಯಂ ಮಾಂ ನಾದೀಧರತ, ಕಿನ್ತ್ವನೇನ ಶಾಸ್ತ್ರೀಯಂ ವಚನಂ ಸೇಧನೀಯಂ| ");
INSERT INTO sankan_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ತದಾ ಸರ್ವ್ವೇ ಶಿಷ್ಯಾಸ್ತಂ ಪರಿತ್ಯಜ್ಯ ಪಲಾಯಾಞ್ಚಕ್ರಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ಅಥೈಕೋ ಯುವಾ ಮಾನವೋ ನಗ್ನಕಾಯೇ ವಸ್ತ್ರಮೇಕಂ ನಿಧಾಯ ತಸ್ಯ ಪಶ್ಚಾದ್ ವ್ರಜನ್ ಯುವಲೋಕೈ ರ್ಧೃತೋ ");
INSERT INTO sankan_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ವಸ್ತ್ರಂ ವಿಹಾಯ ನಗ್ನಃ ಪಲಾಯಾಞ್ಚಕ್ರೇ| ");
INSERT INTO sankan_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ಅಪರಞ್ಚ ಯಸ್ಮಿನ್ ಸ್ಥಾನೇ ಪ್ರಧಾನಯಾಜಕಾ ಉಪಾಧ್ಯಾಯಾಃ ಪ್ರಾಚೀನಲೋಕಾಶ್ಚ ಮಹಾಯಾಜಕೇನ ಸಹ ಸದಸಿ ಸ್ಥಿತಾಸ್ತಸ್ಮಿನ್ ಸ್ಥಾನೇ ಮಹಾಯಾಜಕಸ್ಯ ಸಮೀಪಂ ಯೀಶುಂ ನಿನ್ಯುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ಪಿತರೋ ದೂರೇ ತತ್ಪಶ್ಚಾದ್ ಇತ್ವಾ ಮಹಾಯಾಜಕಸ್ಯಾಟ್ಟಾಲಿಕಾಂ ಪ್ರವಿಶ್ಯ ಕಿಙ್ಕರೈಃ ಸಹೋಪವಿಶ್ಯ ವಹ್ನಿತಾಪಂ ಜಗ್ರಾಹ| ");
INSERT INTO sankan_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ತದಾನೀಂ ಪ್ರಧಾನಯಾಜಕಾ ಮನ್ತ್ರಿಣಶ್ಚ ಯೀಶುಂ ಘಾತಯಿತುಂ ತತ್ಪ್ರಾತಿಕೂಲ್ಯೇನ ಸಾಕ್ಷಿಣೋ ಮೃಗಯಾಞ್ಚಕ್ರಿರೇ, ಕಿನ್ತು ನ ಪ್ರಾಪ್ತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ಅನೇಕೈಸ್ತದ್ವಿರುದ್ಧಂ ಮೃಷಾಸಾಕ್ಷ್ಯೇ ದತ್ತೇಪಿ ತೇಷಾಂ ವಾಕ್ಯಾನಿ ನ ಸಮಗಚ್ಛನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","ಸರ್ವ್ವಶೇಷೇ ಕಿಯನ್ತ ಉತ್ಥಾಯ ತಸ್ಯ ಪ್ರಾತಿಕೂಲ್ಯೇನ ಮೃಷಾಸಾಕ್ಷ್ಯಂ ದತ್ತ್ವಾ ಕಥಯಾಮಾಸುಃ, ");
INSERT INTO sankan_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","ಇದಂ ಕರಕೃತಮನ್ದಿರಂ ವಿನಾಶ್ಯ ದಿನತ್ರಯಮಧ್ಯೇ ಪುನರಪರಮ್ ಅಕರಕೃತಂ ಮನ್ದಿರಂ ನಿರ್ಮ್ಮಾಸ್ಯಾಮಿ, ಇತಿ ವಾಕ್ಯಮ್ ಅಸ್ಯ ಮುಖಾತ್ ಶ್ರುತಮಸ್ಮಾಭಿರಿತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","ಕಿನ್ತು ತತ್ರಾಪಿ ತೇಷಾಂ ಸಾಕ್ಷ್ಯಕಥಾ ನ ಸಙ್ಗಾತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ಅಥ ಮಹಾಯಾಜಕೋ ಮಧ್ಯೇಸಭಮ್ ಉತ್ಥಾಯ ಯೀಶುಂ ವ್ಯಾಜಹಾರ, ಏತೇ ಜನಾಸ್ತ್ವಯಿ ಯತ್ ಸಾಕ್ಷ್ಯಮದುಃ ತ್ವಮೇತಸ್ಯ ಕಿಮಪ್ಯುತ್ತರಂ ಕಿಂ ನ ದಾಸ್ಯಸಿ? ");
INSERT INTO sankan_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","ಕಿನ್ತು ಸ ಕಿಮಪ್ಯುತ್ತರಂ ನ ದತ್ವಾ ಮೌನೀಭೂಯ ತಸ್ಯೌ; ತತೋ ಮಹಾಯಾಜಕಃ ಪುನರಪಿ ತಂ ಪೃಷ್ಟಾವಾನ್ ತ್ವಂ ಸಚ್ಚಿದಾನನ್ದಸ್ಯ ತನಯೋ ಽಭಿಷಿಕ್ತಸ್ತ್ರತಾ? ");
INSERT INTO sankan_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","ತದಾ ಯೀಶುಸ್ತಂ ಪ್ರೋವಾಚ ಭವಾಮ್ಯಹಮ್ ಯೂಯಞ್ಚ ಸರ್ವ್ವಶಕ್ತಿಮತೋ ದಕ್ಷೀಣಪಾರ್ಶ್ವೇ ಸಮುಪವಿಶನ್ತಂ ಮೇಘ ಮಾರುಹ್ಯ ಸಮಾಯಾನ್ತಞ್ಚ ಮನುಷ್ಯಪುತ್ರಂ ಸನ್ದ್ರಕ್ಷ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ತದಾ ಮಹಾಯಾಜಕಃ ಸ್ವಂ ವಮನಂ ಛಿತ್ವಾ ವ್ಯಾವಹರತ್ ");
INSERT INTO sankan_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ಕಿಮಸ್ಮಾಕಂ ಸಾಕ್ಷಿಭಿಃ ಪ್ರಯೋಜನಮ್? ಈಶ್ವರನಿನ್ದಾವಾಕ್ಯಂ ಯುಷ್ಮಾಭಿರಶ್ರಾವಿ ಕಿಂ ವಿಚಾರಯಥ? ತದಾನೀಂ ಸರ್ವ್ವೇ ಜಗದುರಯಂ ನಿಧನದಣ್ಡಮರ್ಹತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","ತತಃ ಕಶ್ಚಿತ್ ಕಶ್ಚಿತ್ ತದ್ವಪುಷಿ ನಿಷ್ಠೀವಂ ನಿಚಿಕ್ಷೇಪ ತಥಾ ತನ್ಮುಖಮಾಚ್ಛಾದ್ಯ ಚಪೇಟೇನ ಹತ್ವಾ ಗದಿತವಾನ್ ಗಣಯಿತ್ವಾ ವದ, ಅನುಚರಾಶ್ಚ ಚಪೇಟೈಸ್ತಮಾಜಘ್ನುಃ ");
INSERT INTO sankan_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ತತಃ ಪರಂ ಪಿತರೇಽಟ್ಟಾಲಿಕಾಧಃಕೋಷ್ಠೇ ತಿಷ್ಠತಿ ಮಹಾಯಾಜಕಸ್ಯೈಕಾ ದಾಸೀ ಸಮೇತ್ಯ ");
INSERT INTO sankan_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ತಂ ವಿಹ್ನಿತಾಪಂ ಗೃಹ್ಲನ್ತಂ ವಿಲೋಕ್ಯ ತಂ ಸುನಿರೀಕ್ಷ್ಯ ಬಭಾಷೇ ತ್ವಮಪಿ ನಾಸರತೀಯಯೀಶೋಃ ಸಙ್ಗಿನಾಮ್ ಏಕೋ ಜನ ಆಸೀಃ| ");
INSERT INTO sankan_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","ಕಿನ್ತು ಸೋಪಹ್ನುತ್ಯ ಜಗಾದ ತಮಹಂ ನ ವದ್ಮಿ ತ್ವಂ ಯತ್ ಕಥಯಮಿ ತದಪ್ಯಹಂ ನ ಬುದ್ಧ್ಯೇ| ತದಾನೀಂ ಪಿತರೇ ಚತ್ವರಂ ಗತವತಿ ಕುेಕ್ಕುಟೋ ರುರಾವ| ");
INSERT INTO sankan_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ಅಥಾನ್ಯಾ ದಾಸೀ ಪಿತರಂ ದೃಷ್ಟ್ವಾ ಸಮೀಪಸ್ಥಾನ್ ಜನಾನ್ ಜಗಾದ ಅಯಂ ತೇಷಾಮೇಕೋ ಜನಃ| ");
INSERT INTO sankan_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ತತಃ ಸ ದ್ವಿತೀಯವಾರಮ್ ಅಪಹ್ನುತವಾನ್ ಪಶ್ಚಾತ್ ತತ್ರಸ್ಥಾ ಲೋಕಾಃ ಪಿತರಂ ಪ್ರೋಚುಸ್ತ್ವಮವಶ್ಯಂ ತೇಷಾಮೇಕೋ ಜನಃ ಯತಸ್ತ್ವಂ ಗಾಲೀಲೀಯೋ ನರ ಇತಿ ತವೋಚ್ಚಾರಣಂ ಪ್ರಕಾಶಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","ತದಾ ಸ ಶಪಥಾಭಿಶಾಪೌ ಕೃತ್ವಾ ಪ್ರೋವಾಚ ಯೂಯಂ ಕಥಾಂ ಕಥಯಥ ತಂ ನರಂ ನ ಜಾನೇಽಹಂ| ");
INSERT INTO sankan_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ತದಾನೀಂ ದ್ವಿತೀಯವಾರಂ ಕುಕ್ಕುಟೋ ಽರಾವೀತ್| ಕುಕ್ಕುಟಸ್ಯ ದ್ವಿತೀಯರವಾತ್ ಪೂರ್ವ್ವಂ ತ್ವಂ ಮಾಂ ವಾರತ್ರಯಮ್ ಅಪಹ್ನೋಷ್ಯಸಿ, ಇತಿ ಯದ್ವಾಕ್ಯಂ ಯೀಶುನಾ ಸಮುದಿತಂ ತತ್ ತದಾ ಸಂಸ್ಮೃತ್ಯ ಪಿತರೋ ರೋದಿತುಮ್ ಆರಭತ| ");
INSERT INTO sankan_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","ಅಥ ಪ್ರಭಾತೇ ಸತಿ ಪ್ರಧಾನಯಾಜಕಾಃ ಪ್ರಾಞ್ಚ ಉಪಾಧ್ಯಾಯಾಃ ಸರ್ವ್ವೇ ಮನ್ತ್ರಿಣಶ್ಚ ಸಭಾಂ ಕೃತ್ವಾ ಯೀಶುृಂ ಬನ್ಧಯಿತ್ವ ಪೀಲಾತಾಖ್ಯಸ್ಯ ದೇಶಾಧಿಪತೇಃ ಸವಿಧಂ ನೀತ್ವಾ ಸಮರ್ಪಯಾಮಾಸುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ತದಾ ಪೀಲಾತಸ್ತಂ ಪೃಷ್ಟವಾನ್ ತ್ವಂ ಕಿಂ ಯಿಹೂದೀಯಲೋಕಾನಾಂ ರಾಜಾ? ತತಃ ಸ ಪ್ರತ್ಯುಕ್ತವಾನ್ ಸತ್ಯಂ ವದಸಿ| ");
INSERT INTO sankan_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","ಅಪರಂ ಪ್ರಧಾನಯಾಜಕಾಸ್ತಸ್ಯ ಬಹುಷು ವಾಕ್ಯೇಷು ದೋಷಮಾರೋಪಯಾಞ್ಚಕ್ರುಃ ಕಿನ್ತು ಸ ಕಿಮಪಿ ನ ಪ್ರತ್ಯುವಾಚ| ");
INSERT INTO sankan_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ತದಾನೀಂ ಪೀಲಾತಸ್ತಂ ಪುನಃ ಪಪ್ರಚ್ಛ ತ್ವಂ ಕಿಂ ನೋತ್ತರಯಸಿ? ಪಶ್ಯೈತೇ ತ್ವದ್ವಿರುದ್ಧಂ ಕತಿಷು ಸಾಧ್ಯೇಷು ಸಾಕ್ಷಂ ದದತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ಕನ್ತು ಯೀಶುಸ್ತದಾಪಿ ನೋತ್ತರಂ ದದೌ ತತಃ ಪೀಲಾತ ಆಶ್ಚರ್ಯ್ಯಂ ಜಗಾಮ| ");
INSERT INTO sankan_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ಅಪರಞ್ಚ ಕಾರಾಬದ್ಧೇ ಕಸ್ತಿಂಶ್ಚಿತ್ ಜನೇ ತನ್ಮಹೋತ್ಸವಕಾಲೇ ಲೋಕೈ ರ್ಯಾಚಿತೇ ದೇಶಾಧಿಪತಿಸ್ತಂ ಮೋಚಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ಯೇ ಚ ಪೂರ್ವ್ವಮುಪಪ್ಲವಮಕಾರ್ಷುರುಪಪ್ಲವೇ ವಧಮಪಿ ಕೃತವನ್ತಸ್ತೇಷಾಂ ಮಧ್ಯೇ ತದಾನೋಂ ಬರಬ್ಬಾನಾಮಕ ಏಕೋ ಬದ್ಧ ಆಸೀತ್| ");
INSERT INTO sankan_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ಅತೋ ಹೇತೋಃ ಪೂರ್ವ್ವಾಪರೀಯಾಂ ರೀತಿಕಥಾಂ ಕಥಯಿತ್ವಾ ಲೋಕಾ ಉಚ್ಚೈರುವನ್ತಃ ಪೀಲಾತಸ್ಯ ಸಮಕ್ಷಂ ನಿವೇದಯಾಮಾಸುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ತದಾ ಪೀಲಾತಸ್ತಾನಾಚಖ್ಯೌ ತರ್ಹಿ ಕಿಂ ಯಿಹೂದೀಯಾನಾಂ ರಾಜಾನಂ ಮೋಚಯಿಷ್ಯಾಮಿ? ಯುಷ್ಮಾಭಿಃ ಕಿಮಿಷ್ಯತೇ? ");
INSERT INTO sankan_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ಯತಃ ಪ್ರಧಾನಯಾಜಕಾ ಈರ್ಷ್ಯಾತ ಏವ ಯೀಶುಂ ಸಮಾರ್ಪಯನ್ನಿತಿ ಸ ವಿವೇದ| ");
INSERT INTO sankan_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","ಕಿನ್ತು ಯಥಾ ಬರಬ್ಬಾಂ ಮೋಚಯತಿ ತಥಾ ಪ್ರಾರ್ಥಯಿತುಂ ಪ್ರಧಾನಯಾಜಕಾ ಲೋಕಾನ್ ಪ್ರವರ್ತ್ತಯಾಮಾಸುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ಅಥ ಪೀಲಾತಃ ಪುನಃ ಪೃಷ್ಟವಾನ್ ತರ್ಹಿ ಯಂ ಯಿಹೂದೀಯಾನಾಂ ರಾಜೇತಿ ವದಥ ತಸ್ಯ ಕಿಂ ಕರಿಷ್ಯಾಮಿ ಯುಷ್ಮಾಭಿಃ ಕಿಮಿಷ್ಯತೇ? ");
INSERT INTO sankan_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","ತದಾ ತೇ ಪುನರಪಿ ಪ್ರೋಚ್ಚೈಃ ಪ್ರೋಚುಸ್ತಂ ಕ್ರುಶೇ ವೇಧಯ| ");
INSERT INTO sankan_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ತಸ್ಮಾತ್ ಪೀಲಾತಃ ಕಥಿತವಾನ್ ಕುತಃ? ಸ ಕಿಂ ಕುಕರ್ಮ್ಮ ಕೃತವಾನ್? ಕಿನ್ತು ತೇ ಪುನಶ್ಚ ರುವನ್ತೋ ವ್ಯಾಜಹ್ರುಸ್ತಂ ಕ್ರುಶೇ ವೇಧಯ| ");
INSERT INTO sankan_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ತದಾ ಪೀಲಾತಃ ಸರ್ವ್ವಾಲ್ಲೋಕಾನ್ ತೋಷಯಿತುಮಿಚ್ಛನ್ ಬರಬ್ಬಾಂ ಮೋಚಯಿತ್ವಾ ಯೀಶುಂ ಕಶಾಭಿಃ ಪ್ರಹೃತ್ಯ ಕ್ರುಶೇ ವೇದ್ಧುಂ ತಂ ಸಮರ್ಪಯಾಮ್ಬಭೂವ| ");
INSERT INTO sankan_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ಅನನ್ತರಂ ಸೈನ್ಯಗಣೋಽಟ್ಟಾಲಿಕಾಮ್ ಅರ್ಥಾದ್ ಅಧಿಪತೇ ರ್ಗೃಹಂ ಯೀಶುಂ ನೀತ್ವಾ ಸೇನಾನಿವಹಂ ಸಮಾಹುಯತ್| ");
INSERT INTO sankan_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ಪಶ್ಚಾತ್ ತೇ ತಂ ಧೂಮಲವರ್ಣವಸ್ತ್ರಂ ಪರಿಧಾಪ್ಯ ಕಣ್ಟಕಮುಕುಟಂ ರಚಯಿತ್ವಾ ಶಿರಸಿ ಸಮಾರೋಪ್ಯ ");
INSERT INTO sankan_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ಹೇ ಯಿಹೂದೀಯಾನಾಂ ರಾಜನ್ ನಮಸ್ಕಾರ ಇತ್ಯುಕ್ತ್ವಾ ತಂ ನಮಸ್ಕರ್ತ್ತಾಮಾರೇಭಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ತಸ್ಯೋತ್ತಮಾಙ್ಗೇ ವೇತ್ರಾಘಾತಂ ಚಕ್ರುಸ್ತದ್ಗಾತ್ರೇ ನಿಷ್ಠೀವಞ್ಚ ನಿಚಿಕ್ಷಿಪುಃ, ತಥಾ ತಸ್ಯ ಸಮ್ಮುಖೇ ಜಾನುಪಾತಂ ಪ್ರಣೋಮುಃ ");
INSERT INTO sankan_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ಇತ್ಥಮುಪಹಸ್ಯ ಧೂಮ್ರವರ್ಣವಸ್ತ್ರಮ್ ಉತ್ತಾರ್ಯ್ಯ ತಸ್ಯ ವಸ್ತ್ರಂ ತಂ ಪರ್ಯ್ಯಧಾಪಯನ್ ಕ್ರುಶೇ ವೇದ್ಧುಂ ಬಹಿರ್ನಿನ್ಯುಶ್ಚ| ");
INSERT INTO sankan_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","ತತಃ ಪರಂ ಸೇಕನ್ದರಸ್ಯ ರುಫಸ್ಯ ಚ ಪಿತಾ ಶಿಮೋನ್ನಾಮಾ ಕುರೀಣೀಯಲೋಕ ಏಕಃ ಕುತಶ್ಚಿದ್ ಗ್ರಾಮಾದೇತ್ಯ ಪಥಿ ಯಾತಿ ತಂ ತೇ ಯೀಶೋಃ ಕ್ರುಶಂ ವೋಢುಂ ಬಲಾದ್ ದಧ್ನುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ಅಥ ಗುಲ್ಗಲ್ತಾ ಅರ್ಥಾತ್ ಶಿರಃಕಪಾಲನಾಮಕಂ ಸ್ಥಾನಂ ಯೀಶುಮಾನೀಯ ");
INSERT INTO sankan_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ತೇ ಗನ್ಧರಸಮಿಶ್ರಿತಂ ದ್ರಾಕ್ಷಾರಸಂ ಪಾತುಂ ತಸ್ಮೈ ದದುಃ ಕಿನ್ತು ಸ ನ ಜಗ್ರಾಹ| ");
INSERT INTO sankan_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ತಸ್ಮಿನ್ ಕ್ರುಶೇ ವಿದ್ಧೇ ಸತಿ ತೇಷಾಮೇಕೈಕಶಃ ಕಿಂ ಪ್ರಾಪ್ಸ್ಯತೀತಿ ನಿರ್ಣಯಾಯ ");
INSERT INTO sankan_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ತಸ್ಯ ಪರಿಧೇಯಾನಾಂ ವಿಭಾಗಾರ್ಥಂ ಗುಟಿಕಾಪಾತಂ ಚಕ್ರುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ಅಪರಮ್ ಏಷ ಯಿಹೂದೀಯಾನಾಂ ರಾಜೇತಿ ಲಿಖಿತಂ ದೋಷಪತ್ರಂ ತಸ್ಯ ಶಿರಊರ್ದ್ವ್ವಮ್ ಆರೋಪಯಾಞ್ಚಕ್ರುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ತಸ್ಯ ವಾಮದಕ್ಷಿಣಯೋ ರ್ದ್ವೌ ಚೌರೌ ಕ್ರುಶಯೋ ರ್ವಿವಿಧಾತೇ| ");
INSERT INTO sankan_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","ತೇನೈವ \"ಅಪರಾಧಿಜನೈಃ ಸಾರ್ದ್ಧಂ ಸ ಗಣಿತೋ ಭವಿಷ್ಯತಿ,\" ಇತಿ ಶಾಸ್ತ್ರೋಕ್ತಂ ವಚನಂ ಸಿದ್ಧಮಭೂತ| ");
INSERT INTO sankan_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","ಅನನ್ತರಂ ಮಾರ್ಗೇ ಯೇ ಯೇ ಲೋಕಾ ಗಮನಾಗಮನೇ ಚಕ್ರುಸ್ತೇ ಸರ್ವ್ವ ಏವ ಶಿರಾಂಸ್ಯಾನ್ದೋಲ್ಯ ನಿನ್ದನ್ತೋ ಜಗದುಃ, ರೇ ಮನ್ದಿರನಾಶಕ ರೇ ದಿನತ್ರಯಮಧ್ಯೇ ತನ್ನಿರ್ಮ್ಮಾಯಕ, ");
INSERT INTO sankan_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ಅಧುನಾತ್ಮಾನಮ್ ಅವಿತ್ವಾ ಕ್ರುಶಾದವರೋಹ| ");
INSERT INTO sankan_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","ಕಿಞ್ಚ ಪ್ರಧಾನಯಾಜಕಾ ಅಧ್ಯಾಪಕಾಶ್ಚ ತದ್ವತ್ ತಿರಸ್ಕೃತ್ಯ ಪರಸ್ಪರಂ ಚಚಕ್ಷಿರೇ ಏಷ ಪರಾನಾವತ್ ಕಿನ್ತು ಸ್ವಮವಿತುಂ ನ ಶಕ್ನೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ಯದೀಸ್ರಾಯೇಲೋ ರಾಜಾಭಿಷಿಕ್ತಸ್ತ್ರಾತಾ ಭವತಿ ತರ್ಹ್ಯಧುನೈನ ಕ್ರುಶಾದವರೋಹತು ವಯಂ ತದ್ ದೃಷ್ಟ್ವಾ ವಿಶ್ವಸಿಷ್ಯಾಮಃ; ಕಿಞ್ಚ ಯೌ ಲೋಕೌ ತೇನ ಸಾರ್ದ್ಧಂ ಕ್ರುಶೇ ಽವಿಧ್ಯೇತಾಂ ತಾವಪಿ ತಂ ನಿರ್ಭರ್ತ್ಸಯಾಮಾಸತುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","ಅಥ ದ್ವಿತೀಯಯಾಮಾತ್ ತೃತೀಯಯಾಮಂ ಯಾವತ್ ಸರ್ವ್ವೋ ದೇಶಃ ಸಾನ್ಧಕಾರೋಭೂತ್| ");
INSERT INTO sankan_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ತತಸ್ತೃತೀಯಪ್ರಹರೇ ಯೀಶುರುಚ್ಚೈರವದತ್ ಏಲೀ ಏಲೀ ಲಾಮಾ ಶಿವಕ್ತನೀ ಅರ್ಥಾದ್ \"ಹೇ ಮದೀಶ ಮದೀಶ ತ್ವಂ ಪರ್ಯ್ಯತ್ಯಾಕ್ಷೀಃ ಕುತೋ ಹಿ ಮಾಂ?\" ");
INSERT INTO sankan_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ತದಾ ಸಮೀಪಸ್ಥಲೋಕಾನಾಂ ಕೇಚಿತ್ ತದ್ವಾಕ್ಯಂ ನಿಶಮ್ಯಾಚಖ್ಯುಃ ಪಶ್ಯೈಷ ಏಲಿಯಮ್ ಆಹೂಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","ತತ ಏಕೋ ಜನೋ ಧಾವಿತ್ವಾಗತ್ಯ ಸ್ಪಞ್ಜೇ ಽಮ್ಲರಸಂ ಪೂರಯಿತ್ವಾ ತಂ ನಡಾಗ್ರೇ ನಿಧಾಯ ಪಾತುಂ ತಸ್ಮೈ ದತ್ತ್ವಾವದತ್ ತಿಷ್ಠ ಏಲಿಯ ಏನಮವರೋಹಯಿತುಮ್ ಏತಿ ನ ವೇತಿ ಪಶ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","ಅಥ ಯೀಶುರುಚ್ಚೈಃ ಸಮಾಹೂಯ ಪ್ರಾಣಾನ್ ಜಹೌ| ");
INSERT INTO sankan_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ತದಾ ಮನ್ದಿರಸ್ಯ ಜವನಿಕೋರ್ದ್ವ್ವಾದಧಃರ್ಯ್ಯನ್ತಾ ವಿದೀರ್ಣಾ ದ್ವಿಖಣ್ಡಾಭೂತ್| ");
INSERT INTO sankan_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","ಕಿಞ್ಚ ಇತ್ಥಮುಚ್ಚೈರಾಹೂಯ ಪ್ರಾಣಾನ್ ತ್ಯಜನ್ತಂ ತಂ ದೃಷ್ದ್ವಾ ತದ್ರಕ್ಷಣಾಯ ನಿಯುಕ್ತೋ ಯಃ ಸೇನಾಪತಿರಾಸೀತ್ ಸೋವದತ್ ನರೋಯಮ್ ಈಶ್ವರಪುತ್ರ ಇತಿ ಸತ್ಯಮ್| ");
INSERT INTO sankan_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","ತದಾನೀಂ ಮಗ್ದಲೀನೀ ಮರಿಸಮ್ ಕನಿಷ್ಠಯಾಕೂಬೋ ಯೋಸೇಶ್ಚ ಮಾತಾನ್ಯಮರಿಯಮ್ ಶಾಲೋಮೀ ಚ ಯಾಃ ಸ್ತ್ರಿಯೋ ");
INSERT INTO sankan_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","ಗಾಲೀಲ್ಪ್ರದೇಶೇ ಯೀಶುಂ ಸೇವಿತ್ವಾ ತದನುಗಾಮಿನ್ಯೋ ಜಾತಾ ಇಮಾಸ್ತದನ್ಯಾಶ್ಚ ಯಾ ಅನೇಕಾ ನಾರ್ಯೋ ಯೀಶುನಾ ಸಾರ್ದ್ಧಂ ಯಿರೂಶಾಲಮಮಾಯಾತಾಸ್ತಾಶ್ಚ ದೂರಾತ್ ತಾನಿ ದದೃಶುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","ಅಥಾಸಾದನದಿನಸ್ಯಾರ್ಥಾದ್ ವಿಶ್ರಾಮವಾರಾತ್ ಪೂರ್ವ್ವದಿನಸ್ಯ ಸಾಯಂಕಾಲ ಆಗತ ");
INSERT INTO sankan_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ಈಶ್ವರರಾಜ್ಯಾಪೇಕ್ಷ್ಯರಿಮಥೀಯಯೂಷಫನಾಮಾ ಮಾನ್ಯಮನ್ತ್ರೀ ಸಮೇತ್ಯ ಪೀಲಾತಸವಿಧಂ ನಿರ್ಭಯೋ ಗತ್ವಾ ಯೀಶೋರ್ದೇಹಂ ಯಯಾಚೇ| ");
INSERT INTO sankan_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ಕಿನ್ತು ಸ ಇದಾನೀಂ ಮೃತಃ ಪೀಲಾತ ಇತ್ಯಸಮ್ಭವಂ ಮತ್ವಾ ಶತಸೇನಾಪತಿಮಾಹೂಯ ಸ ಕದಾ ಮೃತ ಇತಿ ಪಪ್ರಚ್ಛ| ");
INSERT INTO sankan_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ಶತಸೇಮನಾಪತಿಮುಖಾತ್ ತಜ್ಜ್ಞಾತ್ವಾ ಯೂಷಫೇ ಯೀಶೋರ್ದೇಹಂ ದದೌ| ");
INSERT INTO sankan_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","ಪಶ್ಚಾತ್ ಸ ಸೂಕ್ಷ್ಮಂ ವಾಸಃ ಕ್ರೀತ್ವಾ ಯೀಶೋಃ ಕಾಯಮವರೋಹ್ಯ ತೇನ ವಾಸಸಾ ವೇಷ್ಟಾಯಿತ್ವಾ ಗಿರೌ ಖಾತಶ್ಮಶಾನೇ ಸ್ಥಾಪಿತವಾನ್ ಪಾಷಾಣಂ ಲೋಠಯಿತ್ವಾ ದ್ವಾರಿ ನಿದಧೇ| ");
INSERT INTO sankan_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","ಕಿನ್ತು ಯತ್ರ ಸೋಸ್ಥಾಪ್ಯತ ತತ ಮಗ್ದಲೀನೀ ಮರಿಯಮ್ ಯೋಸಿಮಾತೃಮರಿಯಮ್ ಚ ದದೃಶತೃಃ| ");
INSERT INTO sankan_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ಅಥ ವಿಶ್ರಾಮವಾರೇ ಗತೇ ಮಗ್ದಲೀನೀ ಮರಿಯಮ್ ಯಾಕೂಬಮಾತಾ ಮರಿಯಮ್ ಶಾಲೋಮೀ ಚೇಮಾಸ್ತಂ ಮರ್ದ್ದಯಿತುಂ ಸುಗನ್ಧಿದ್ರವ್ಯಾಣಿ ಕ್ರೀತ್ವಾ ");
INSERT INTO sankan_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ಸಪ್ತಾಹಪ್ರಥಮದಿನೇಽತಿಪ್ರತ್ಯೂಷೇ ಸೂರ್ಯ್ಯೋದಯಕಾಲೇ ಶ್ಮಶಾನಮುಪಗತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ಕಿನ್ತು ಶ್ಮಶಾನದ್ವಾರಪಾಷಾಣೋಽತಿಬೃಹನ್ ತಂ ಕೋಽಪಸಾರಯಿಷ್ಯತೀತಿ ತಾಃ ಪರಸ್ಪರಂ ಗದನ್ತಿ! ");
INSERT INTO sankan_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ಏತರ್ಹಿ ನಿರೀಕ್ಷ್ಯ ಪಾಷಾಣೋ ದ್ವಾರೋ ಽಪಸಾರಿತ ಇತಿ ದದೃಶುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ಪಶ್ಚಾತ್ತಾಃ ಶ್ಮಶಾನಂ ಪ್ರವಿಶ್ಯ ಶುಕ್ಲವರ್ಣದೀರ್ಘಪರಿಚ್ಛದಾವೃತಮೇಕಂ ಯುವಾನಂ ಶ್ಮಶಾನದಕ್ಷಿಣಪಾರ್ಶ್ವ ಉಪವಿಷ್ಟಂ ದೃಷ್ಟ್ವಾ ಚಮಚ್ಚಕ್ರುಃ| ");
INSERT INTO sankan_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ಸೋಽವದತ್, ಮಾಭೈಷ್ಟ ಯೂಯಂ ಕ್ರುಶೇ ಹತಂ ನಾಸರತೀಯಯೀಶುಂ ಗವೇಷಯಥ ಸೋತ್ರ ನಾಸ್ತಿ ಶ್ಮಶಾನಾದುದಸ್ಥಾತ್; ತೈ ರ್ಯತ್ರ ಸ ಸ್ಥಾಪಿತಃ ಸ್ಥಾನಂ ತದಿದಂ ಪಶ್ಯತ| ");
INSERT INTO sankan_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","ಕಿನ್ತು ತೇನ ಯಥೋಕ್ತಂ ತಥಾ ಯುಷ್ಮಾಕಮಗ್ರೇ ಗಾಲೀಲಂ ಯಾಸ್ಯತೇ ತತ್ರ ಸ ಯುಷ್ಮಾನ್ ಸಾಕ್ಷಾತ್ ಕರಿಷ್ಯತೇ ಯೂಯಂ ಗತ್ವಾ ತಸ್ಯ ಶಿಷ್ಯೇಭ್ಯಃ ಪಿತರಾಯ ಚ ವಾರ್ತ್ತಾಮಿಮಾಂ ಕಥಯತ| ");
INSERT INTO sankan_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ತಾಃ ಕಮ್ಪಿತಾ ವಿಸ್ತಿತಾಶ್ಚ ತೂರ್ಣಂ ಶ್ಮಶಾನಾದ್ ಬಹಿರ್ಗತ್ವಾ ಪಲಾಯನ್ತ ಭಯಾತ್ ಕಮಪಿ ಕಿಮಪಿ ನಾವದಂಶ್ಚ| ");
INSERT INTO sankan_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","ಅಪರಂ ಯೀಶುಃ ಸಪ್ತಾಹಪ್ರಥಮದಿನೇ ಪ್ರತ್ಯೂಷೇ ಶ್ಮಶಾನಾದುತ್ಥಾಯ ಯಸ್ಯಾಃ ಸಪ್ತಭೂತಾಸ್ತ್ಯಾಜಿತಾಸ್ತಸ್ಯೈ ಮಗ್ದಲೀನೀಮರಿಯಮೇ ಪ್ರಥಮಂ ದರ್ಶನಂ ದದೌ| ");
INSERT INTO sankan_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ತತಃ ಸಾ ಗತ್ವಾ ಶೋಕರೋದನಕೃದ್ಭ್ಯೋಽನುಗತಲೋಕೇಭ್ಯಸ್ತಾಂ ವಾರ್ತ್ತಾಂ ಕಥಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","ಕಿನ್ತು ಯೀಶುಃ ಪುನರ್ಜೀವನ್ ತಸ್ಯೈ ದರ್ಶನಂ ದತ್ತವಾನಿತಿ ಶ್ರುತ್ವಾ ತೇ ನ ಪ್ರತ್ಯಯನ್| ");
INSERT INTO sankan_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ಪಶ್ಚಾತ್ ತೇಷಾಂ ದ್ವಾಯೋ ರ್ಗ್ರಾಮಯಾನಕಾಲೇ ಯೀಶುರನ್ಯವೇಶಂ ಧೃತ್ವಾ ತಾಭ್ಯಾಂ ದರ್ಶನ ದದೌ! ");
INSERT INTO sankan_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ತಾವಪಿ ಗತ್ವಾನ್ಯಶಿಷ್ಯೇಭ್ಯಸ್ತಾಂ ಕಥಾಂ ಕಥಯಾಞ್ಚಕ್ರತುಃ ಕಿನ್ತು ತಯೋಃ ಕಥಾಮಪಿ ತೇ ನ ಪ್ರತ್ಯಯನ್| ");
INSERT INTO sankan_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ಶೇಷತ ಏಕಾದಶಶಿಷ್ಯೇಷು ಭೋಜನೋಪವಿಷ್ಟೇಷು ಯೀಶುಸ್ತೇಭ್ಯೋ ದರ್ಶನಂ ದದೌ ತಥೋತ್ಥಾನಾತ್ ಪರಂ ತದ್ದರ್ಶನಪ್ರಾಪ್ತಲೋಕಾನಾಂ ಕಥಾಯಾಮವಿಶ್ವಾಸಕರಣಾತ್ ತೇಷಾಮವಿಶ್ವಾಸಮನಃಕಾಠಿನ್ಯಾಭ್ಯಾಂ ಹೇತುಭ್ಯಾಂ ಸ ತಾಂಸ್ತರ್ಜಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ಅಥ ತಾನಾಚಖ್ಯೌ ಯೂಯಂ ಸರ್ವ್ವಜಗದ್ ಗತ್ವಾ ಸರ್ವ್ವಜನಾನ್ ಪ್ರತಿ ಸುಸಂವಾದಂ ಪ್ರಚಾರಯತ| ");
INSERT INTO sankan_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ತತ್ರ ಯಃ ಕಶ್ಚಿದ್ ವಿಶ್ವಸ್ಯ ಮಜ್ಜಿತೋ ಭವೇತ್ ಸ ಪರಿತ್ರಾಸ್ಯತೇ ಕಿನ್ತು ಯೋ ನ ವಿಶ್ವಸಿಷ್ಯತಿ ಸ ದಣ್ಡಯಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","ಕಿಞ್ಚ ಯೇ ಪ್ರತ್ಯೇಷ್ಯನ್ತಿ ತೈರೀದೃಗ್ ಆಶ್ಚರ್ಯ್ಯಂ ಕರ್ಮ್ಮ ಪ್ರಕಾಶಯಿಷ್ಯತೇ ತೇ ಮನ್ನಾಮ್ನಾ ಭೂತಾನ್ ತ್ಯಾಜಯಿಷ್ಯನ್ತಿ ಭಾಷಾ ಅನ್ಯಾಶ್ಚ ವದಿಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ಅಪರಂ ತೈಃ ಸರ್ಪೇಷು ಧೃತೇಷು ಪ್ರಾಣನಾಶಕವಸ್ತುನಿ ಪೀತೇ ಚ ತೇಷಾಂ ಕಾಪಿ ಕ್ಷತಿ ರ್ನ ಭವಿಷ್ಯತಿ; ರೋಗಿಣಾಂ ಗಾತ್ರೇಷು ಕರಾರ್ಪಿತೇ ತೇಽರೋಗಾ ಭವಿಷ್ಯನ್ತಿ ಚ| ");
INSERT INTO sankan_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","ಅಥ ಪ್ರಭುಸ್ತಾನಿತ್ಯಾದಿಶ್ಯ ಸ್ವರ್ಗಂ ನೀತಃ ಸನ್ ಪರಮೇಶ್ವರಸ್ಯ ದಕ್ಷಿಣ ಉಪವಿವೇಶ| ");
INSERT INTO sankan_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ತತಸ್ತೇ ಪ್ರಸ್ಥಾಯ ಸರ್ವ್ವತ್ರ ಸುಸಂವಾದೀಯಕಥಾಂ ಪ್ರಚಾರಯಿತುಮಾರೇಭಿರೇ ಪ್ರಭುಸ್ತು ತೇಷಾಂ ಸಹಾಯಃ ಸನ್ ಪ್ರಕಾಶಿತಾಶ್ಚರ್ಯ್ಯಕ್ರಿಯಾಭಿಸ್ತಾಂ ಕಥಾಂ ಪ್ರಮಾಣವತೀಂ ಚಕಾರ| ಇತಿ|");
INSERT INTO sankan_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","ಪ್ರಥಮತೋ ಯೇ ಸಾಕ್ಷಿಣೋ ವಾಕ್ಯಪ್ರಚಾರಕಾಶ್ಚಾಸನ್ ತೇಽಸ್ಮಾಕಂ ಮಧ್ಯೇ ಯದ್ಯತ್ ಸಪ್ರಮಾಣಂ ವಾಕ್ಯಮರ್ಪಯನ್ತಿ ಸ್ಮ ");
INSERT INTO sankan_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ತದನುಸಾರತೋಽನ್ಯೇಪಿ ಬಹವಸ್ತದ್ವೃತ್ತಾನ್ತಂ ರಚಯಿತುಂ ಪ್ರವೃತ್ತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ಅತಏವ ಹೇ ಮಹಾಮಹಿಮಥಿಯಫಿಲ್ ತ್ವಂ ಯಾ ಯಾಃ ಕಥಾ ಅಶಿಕ್ಷ್ಯಥಾಸ್ತಾಸಾಂ ದೃಢಪ್ರಮಾಣಾನಿ ಯಥಾ ಪ್ರಾಪ್ನೋಷಿ ");
INSERT INTO sankan_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ತದರ್ಥಂ ಪ್ರಥಮಮಾರಭ್ಯ ತಾನಿ ಸರ್ವ್ವಾಣಿ ಜ್ಞಾತ್ವಾಹಮಪಿ ಅನುಕ್ರಮಾತ್ ಸರ್ವ್ವವೃತ್ತಾನ್ತಾನ್ ತುಭ್ಯಂ ಲೇಖಿತುಂ ಮತಿಮಕಾರ್ಷಮ್| ");
INSERT INTO sankan_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ಯಿಹೂದಾದೇಶೀಯಹೇರೋದ್ನಾಮಕೇ ರಾಜತ್ವಂ ಕುರ್ವ್ವತಿ ಅಬೀಯಯಾಜಕಸ್ಯ ಪರ್ಯ್ಯಾಯಾಧಿಕಾರೀ ಸಿಖರಿಯನಾಮಕ ಏಕೋ ಯಾಜಕೋ ಹಾರೋಣವಂಶೋದ್ಭವಾ ಇಲೀಶೇವಾಖ್ಯಾ ");
INSERT INTO sankan_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ತಸ್ಯ ಜಾಯಾ ದ್ವಾವಿಮೌ ನಿರ್ದೋಷೌ ಪ್ರಭೋಃ ಸರ್ವ್ವಾಜ್ಞಾ ವ್ಯವಸ್ಥಾಶ್ಚ ಸಂಮನ್ಯ ಈಶ್ವರದೃಷ್ಟೌ ಧಾರ್ಮ್ಮಿಕಾವಾಸ್ತಾಮ್| ");
INSERT INTO sankan_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","ತಯೋಃ ಸನ್ತಾನ ಏಕೋಪಿ ನಾಸೀತ್, ಯತ ಇಲೀಶೇವಾ ಬನ್ಧ್ಯಾ ತೌ ದ್ವಾವೇವ ವೃದ್ಧಾವಭವತಾಮ್| ");
INSERT INTO sankan_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","ಯದಾ ಸ್ವಪರ್ಯ್ಯಾನುಕ್ರಮೇಣ ಸಿಖರಿಯ ಈಶ್ವಾಸ್ಯ ಸಮಕ್ಷಂ ಯಾಜಕೀಯಂ ಕರ್ಮ್ಮ ಕರೋತಿ ");
INSERT INTO sankan_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ತದಾ ಯಜ್ಞಸ್ಯ ದಿನಪರಿಪಾಯ್ಯಾ ಪರಮೇಶ್ವರಸ್ಯ ಮನ್ದಿರೇ ಪ್ರವೇಶಕಾಲೇ ಧೂಪಜ್ವಾಲನಂ ಕರ್ಮ್ಮ ತಸ್ಯ ಕರಣೀಯಮಾಸೀತ್| ");
INSERT INTO sankan_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ತದ್ಧೂಪಜ್ವಾಲನಕಾಲೇ ಲೋಕನಿವಹೇ ಪ್ರಾರ್ಥನಾಂ ಕರ್ತುಂ ಬಹಿಸ್ತಿಷ್ಠತಿ ");
INSERT INTO sankan_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ಸತಿ ಸಿಖರಿಯೋ ಯಸ್ಯಾಂ ವೇದ್ಯಾಂ ಧೂಪಂ ಜ್ವಾಲಯತಿ ತದ್ದಕ್ಷಿಣಪಾರ್ಶ್ವೇ ಪರಮೇಶ್ವರಸ್ಯ ದೂತ ಏಕ ಉಪಸ್ಥಿತೋ ದರ್ಶನಂ ದದೌ| ");
INSERT INTO sankan_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ತಂ ದೃಷ್ಟ್ವಾ ಸಿಖರಿಯ ಉದ್ವಿವಿಜೇ ಶಶಙ್ಕೇ ಚ| ");
INSERT INTO sankan_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","ತದಾ ಸ ದೂತಸ್ತಂ ಬಭಾಷೇ ಹೇ ಸಿಖರಿಯ ಮಾ ಭೈಸ್ತವ ಪ್ರಾರ್ಥನಾ ಗ್ರಾಹ್ಯಾ ಜಾತಾ ತವ ಭಾರ್ಯ್ಯಾ ಇಲೀಶೇವಾ ಪುತ್ರಂ ಪ್ರಸೋಷ್ಯತೇ ತಸ್ಯ ನಾಮ ಯೋेಹನ್ ಇತಿ ಕರಿಷ್ಯಸಿ| ");
INSERT INTO sankan_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ಕಿಞ್ಚ ತ್ವಂ ಸಾನನ್ದಃ ಸಹರ್ಷಶ್ಚ ಭವಿಷ್ಯಸಿ ತಸ್ಯ ಜನ್ಮನಿ ಬಹವ ಆನನ್ದಿಷ್ಯನ್ತಿ ಚ| ");
INSERT INTO sankan_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ಯತೋ ಹೇತೋಃ ಸ ಪರಮೇಶ್ವರಸ್ಯ ಗೋಚರೇ ಮಹಾನ್ ಭವಿಷ್ಯತಿ ತಥಾ ದ್ರಾಕ್ಷಾರಸಂ ಸುರಾಂ ವಾ ಕಿಮಪಿ ನ ಪಾಸ್ಯತಿ, ಅಪರಂ ಜನ್ಮಾರಭ್ಯ ಪವಿತ್ರೇಣಾತ್ಮನಾ ಪರಿಪೂರ್ಣಃ ");
INSERT INTO sankan_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","ಸನ್ ಇಸ್ರಾಯೇಲ್ವಂಶೀಯಾನ್ ಅನೇಕಾನ್ ಪ್ರಭೋಃ ಪರಮೇಶ್ವರಸ್ಯ ಮಾರ್ಗಮಾನೇಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","ಸನ್ತಾನಾನ್ ಪ್ರತಿ ಪಿತೃಣಾಂ ಮನಾಂಸಿ ಧರ್ಮ್ಮಜ್ಞಾನಂ ಪ್ರತ್ಯನಾಜ್ಞಾಗ್ರಾಹಿಣಶ್ಚ ಪರಾವರ್ತ್ತಯಿತುಂ, ಪ್ರಭೋಃ ಪರಮೇಶ್ವರಸ್ಯ ಸೇವಾರ್ಥಮ್ ಏಕಾಂ ಸಜ್ಜಿತಜಾತಿಂ ವಿಧಾತುಞ್ಚ ಸ ಏಲಿಯರೂಪಾತ್ಮಶಕ್ತಿಪ್ರಾಪ್ತಸ್ತಸ್ಯಾಗ್ರೇ ಗಮಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ತದಾ ಸಿಖರಿಯೋ ದೂತಮವಾದೀತ್ ಕಥಮೇತದ್ ವೇತ್ಸ್ಯಾಮಿ? ಯತೋಹಂ ವೃದ್ಧೋ ಮಮ ಭಾರ್ಯ್ಯಾ ಚ ವೃದ್ಧಾ| ");
INSERT INTO sankan_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ತತೋ ದೂತಃ ಪ್ರತ್ಯುವಾಚ ಪಶ್ಯೇಶ್ವರಸ್ಯ ಸಾಕ್ಷಾದ್ವರ್ತ್ತೀ ಜಿಬ್ರಾಯೇಲ್ನಾಮಾ ದೂತೋಹಂ ತ್ವಯಾ ಸಹ ಕಥಾಂ ಗದಿತುಂ ತುಭ್ಯಮಿಮಾಂ ಶುಭವಾರ್ತ್ತಾಂ ದಾತುಞ್ಚ ಪ್ರೇಷಿತಃ| ");
INSERT INTO sankan_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ಕಿನ್ತು ಮದೀಯಂ ವಾಕ್ಯಂ ಕಾಲೇ ಫಲಿಷ್ಯತಿ ತತ್ ತ್ವಯಾ ನ ಪ್ರತೀತಮ್ ಅತಃ ಕಾರಣಾದ್ ಯಾವದೇವ ತಾನಿ ನ ಸೇತ್ಸ್ಯನ್ತಿ ತಾವತ್ ತ್ವಂ ವಕ್ತುಂಮಶಕ್ತೋ ಮೂಕೋ ಭವ| ");
INSERT INTO sankan_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","ತದಾನೀಂ ಯೇ ಯೇ ಲೋಕಾಃ ಸಿಖರಿಯಮಪೈಕ್ಷನ್ತ ತೇ ಮಧ್ಯೇಮನ್ದಿರಂ ತಸ್ಯ ಬಹುವಿಲಮ್ಬಾದ್ ಆಶ್ಚರ್ಯ್ಯಂ ಮೇನಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ಸ ಬಹಿರಾಗತೋ ಯದಾ ಕಿಮಪಿ ವಾಕ್ಯಂ ವಕ್ತುಮಶಕ್ತಃ ಸಙ್ಕೇತಂ ಕೃತ್ವಾ ನಿಃಶಬ್ದಸ್ತಸ್ಯೌ ತದಾ ಮಧ್ಯೇಮನ್ದಿರಂ ಕಸ್ಯಚಿದ್ ದರ್ಶನಂ ತೇನ ಪ್ರಾಪ್ತಮ್ ಇತಿ ಸರ್ವ್ವೇ ಬುಬುಧಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ಅನನ್ತರಂ ತಸ್ಯ ಸೇವನಪರ್ಯ್ಯಾಯೇ ಸಮ್ಪೂರ್ಣೇ ಸತಿ ಸ ನಿಜಗೇಹಂ ಜಗಾಮ| ");
INSERT INTO sankan_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","ಕತಿಪಯದಿನೇಷು ಗತೇಷು ತಸ್ಯ ಭಾರ್ಯ್ಯಾ ಇಲೀಶೇವಾ ಗರ್ಬ್ಭವತೀ ಬಭೂವ ");
INSERT INTO sankan_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ಪಶ್ಚಾತ್ ಸಾ ಪಞ್ಚಮಾಸಾನ್ ಸಂಗೋಪ್ಯಾಕಥಯತ್ ಲೋಕಾನಾಂ ಸಮಕ್ಷಂ ಮಮಾಪಮಾನಂ ಖಣ್ಡಯಿತುಂ ಪರಮೇಶ್ವರೋ ಮಯಿ ದೃಷ್ಟಿಂ ಪಾತಯಿತ್ವಾ ಕರ್ಮ್ಮೇದೃಶಂ ಕೃತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ಅಪರಞ್ಚ ತಸ್ಯಾ ಗರ್ಬ್ಭಸ್ಯ ಷಷ್ಠೇ ಮಾಸೇ ಜಾತೇ ಗಾಲೀಲ್ಪ್ರದೇಶೀಯನಾಸರತ್ಪುರೇ ");
INSERT INTO sankan_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ದಾಯೂದೋ ವಂಶೀಯಾಯ ಯೂಷಫ್ನಾಮ್ನೇ ಪುರುಷಾಯ ಯಾ ಮರಿಯಮ್ನಾಮಕುಮಾರೀ ವಾಗ್ದತ್ತಾಸೀತ್ ತಸ್ಯಾಃ ಸಮೀಪಂ ಜಿಬ್ರಾಯೇಲ್ ದೂತ ಈಶ್ವರೇಣ ಪ್ರಹಿತಃ| ");
INSERT INTO sankan_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ಸ ಗತ್ವಾ ಜಗಾದ ಹೇ ಈಶ್ವರಾನುಗೃಹೀತಕನ್ಯೇ ತವ ಶುಭಂ ಭೂಯಾತ್ ಪ್ರಭುಃ ಪರಮೇಶ್ವರಸ್ತವ ಸಹಾಯೋಸ್ತಿ ನಾರೀಣಾಂ ಮಧ್ಯೇ ತ್ವಮೇವ ಧನ್ಯಾ| ");
INSERT INTO sankan_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","ತದಾನೀಂ ಸಾ ತಂ ದೃಷ್ಟ್ವಾ ತಸ್ಯ ವಾಕ್ಯತ ಉದ್ವಿಜ್ಯ ಕೀದೃಶಂ ಭಾಷಣಮಿದಮ್ ಇತಿ ಮನಸಾ ಚಿನ್ತಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ತತೋ ದೂತೋಽವದತ್ ಹೇ ಮರಿಯಮ್ ಭಯಂ ಮಾಕಾರ್ಷೀಃ, ತ್ವಯಿ ಪರಮೇಶ್ವರಸ್ಯಾನುಗ್ರಹೋಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ಪಶ್ಯ ತ್ವಂ ಗರ್ಬ್ಭಂ ಧೃತ್ವಾ ಪುತ್ರಂ ಪ್ರಸೋಷ್ಯಸೇ ತಸ್ಯ ನಾಮ ಯೀಶುರಿತಿ ಕರಿಷ್ಯಸಿ| ");
INSERT INTO sankan_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ಸ ಮಹಾನ್ ಭವಿಷ್ಯತಿ ತಥಾ ಸರ್ವ್ವೇಭ್ಯಃ ಶ್ರೇಷ್ಠಸ್ಯ ಪುತ್ರ ಇತಿ ಖ್ಯಾಸ್ಯತಿ; ಅಪರಂ ಪ್ರಭುಃ ಪರಮೇಶ್ವರಸ್ತಸ್ಯ ಪಿತುರ್ದಾಯೂದಃ ಸಿಂಹಾಸನಂ ತಸ್ಮೈ ದಾಸ್ಯತಿ; ");
INSERT INTO sankan_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ತಥಾ ಸ ಯಾಕೂಬೋ ವಂಶೋಪರಿ ಸರ್ವ್ವದಾ ರಾಜತ್ವಂ ಕರಿಷ್ಯತಿ, ತಸ್ಯ ರಾಜತ್ವಸ್ಯಾನ್ತೋ ನ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","ತದಾ ಮರಿಯಮ್ ತಂ ದೂತಂ ಬಭಾಷೇ ನಾಹಂ ಪುರುಷಸಙ್ಗಂ ಕರೋಮಿ ತರ್ಹಿ ಕಥಮೇತತ್ ಸಮ್ಭವಿಷ್ಯತಿ? ");
INSERT INTO sankan_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ತತೋ ದೂತೋಽಕಥಯತ್ ಪವಿತ್ರ ಆತ್ಮಾ ತ್ವಾಮಾಶ್ರಾಯಿಷ್ಯತಿ ತಥಾ ಸರ್ವ್ವಶ್ರೇಷ್ಠಸ್ಯ ಶಕ್ತಿಸ್ತವೋಪರಿ ಛಾಯಾಂ ಕರಿಷ್ಯತಿ ತತೋ ಹೇತೋಸ್ತವ ಗರ್ಬ್ಭಾದ್ ಯಃ ಪವಿತ್ರಬಾಲಕೋ ಜನಿಷ್ಯತೇ ಸ ಈಶ್ವರಪುತ್ರ ಇತಿ ಖ್ಯಾತಿಂ ಪ್ರಾಪ್ಸ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ಅಪರಞ್ಚ ಪಶ್ಯ ತವ ಜ್ಞಾತಿರಿಲೀಶೇವಾ ಯಾಂ ಸರ್ವ್ವೇ ಬನ್ಧ್ಯಾಮವದನ್ ಇದಾನೀಂ ಸಾ ವಾರ್ದ್ಧಕ್ಯೇ ಸನ್ತಾನಮೇಕಂ ಗರ್ಬ್ಭೇಽಧಾರಯತ್ ತಸ್ಯ ಷಷ್ಠಮಾಸೋಭೂತ್| ");
INSERT INTO sankan_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ಕಿಮಪಿ ಕರ್ಮ್ಮ ನಾಸಾಧ್ಯಮ್ ಈಶ್ವರಸ್ಯ| ");
INSERT INTO sankan_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","ತದಾ ಮರಿಯಮ್ ಜಗಾದ, ಪಶ್ಯ ಪ್ರಭೇರಹಂ ದಾಸೀ ಮಹ್ಯಂ ತವ ವಾಕ್ಯಾನುಸಾರೇಣ ಸರ್ವ್ವಮೇತದ್ ಘಟತಾಮ್; ಅನನತರಂ ದೂತಸ್ತಸ್ಯಾಃ ಸಮೀಪಾತ್ ಪ್ರತಸ್ಥೇ| ");
INSERT INTO sankan_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","ಅಥ ಕತಿಪಯದಿನಾತ್ ಪರಂ ಮರಿಯಮ್ ತಸ್ಮಾತ್ ಪರ್ವ್ವತಮಯಪ್ರದೇಶೀಯಯಿಹೂದಾಯಾ ನಗರಮೇಕಂ ಶೀಘ್ರಂ ಗತ್ವಾ ");
INSERT INTO sankan_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ಸಿಖರಿಯಯಾಜಕಸ್ಯ ಗೃಹಂ ಪ್ರವಿಶ್ಯ ತಸ್ಯ ಜಾಯಾಮ್ ಇಲೀಶೇವಾಂ ಸಮ್ಬೋಧ್ಯಾವದತ್| ");
INSERT INTO sankan_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ತತೋ ಮರಿಯಮಃ ಸಮ್ಬೋಧನವಾಕ್ಯೇ ಇಲೀಶೇವಾಯಾಃ ಕರ್ಣಯೋಃ ಪ್ರವಿಷ್ಟಮಾತ್ರೇ ಸತಿ ತಸ್ಯಾ ಗರ್ಬ್ಭಸ್ಥಬಾಲಕೋ ನನರ್ತ್ತ| ತತ ಇಲೀಶೇವಾ ಪವಿತ್ರೇಣಾತ್ಮನಾ ಪರಿಪೂರ್ಣಾ ಸತೀ ");
INSERT INTO sankan_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ಪ್ರೋಚ್ಚೈರ್ಗದಿತುಮಾರೇಭೇ, ಯೋಷಿತಾಂ ಮಧ್ಯೇ ತ್ವಮೇವ ಧನ್ಯಾ, ತವ ಗರ್ಬ್ಭಸ್ಥಃ ಶಿಶುಶ್ಚ ಧನ್ಯಃ| ");
INSERT INTO sankan_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ತ್ವಂ ಪ್ರಭೋರ್ಮಾತಾ, ಮಮ ನಿವೇಶನೇ ತ್ವಯಾ ಚರಣಾವರ್ಪಿತೌ, ಮಮಾದ್ಯ ಸೌಭಾಗ್ಯಮೇತತ್| ");
INSERT INTO sankan_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","ಪಶ್ಯ ತವ ವಾಕ್ಯೇ ಮಮ ಕರ್ಣಯೋಃ ಪ್ರವಿಷ್ಟಮಾತ್ರೇ ಸತಿ ಮಮೋದರಸ್ಥಃ ಶಿಶುರಾನನ್ದಾನ್ ನನರ್ತ್ತ| ");
INSERT INTO sankan_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","ಯಾ ಸ್ತ್ರೀ ವ್ಯಶ್ವಸೀತ್ ಸಾ ಧನ್ಯಾ, ಯತೋ ಹೇತೋಸ್ತಾಂ ಪ್ರತಿ ಪರಮೇಶ್ವರೋಕ್ತಂ ವಾಕ್ಯಂ ಸರ್ವ್ವಂ ಸಿದ್ಧಂ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ತದಾನೀಂ ಮರಿಯಮ್ ಜಗಾದ| ಧನ್ಯವಾದಂ ಪರೇಶಸ್ಯ ಕರೋತಿ ಮಾಮಕಂ ಮನಃ| ");
INSERT INTO sankan_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ಮಮಾತ್ಮಾ ತಾರಕೇಶೇ ಚ ಸಮುಲ್ಲಾಸಂ ಪ್ರಗಚ್ಛತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ಅಕರೋತ್ ಸ ಪ್ರಭು ರ್ದುಷ್ಟಿಂ ಸ್ವದಾಸ್ಯಾ ದುರ್ಗತಿಂ ಪ್ರತಿ| ಪಶ್ಯಾದ್ಯಾರಭ್ಯ ಮಾಂ ಧನ್ಯಾಂ ವಕ್ಷ್ಯನ್ತಿ ಪುರುಷಾಃ ಸದಾ| ");
INSERT INTO sankan_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ಯಃ ಸರ್ವ್ವಶಕ್ತಿಮಾನ್ ಯಸ್ಯ ನಾಮಾಪಿ ಚ ಪವಿತ್ರಕಂ| ಸ ಏವ ಸುಮಹತ್ಕರ್ಮ್ಮ ಕೃತವಾನ್ ಮನ್ನಿಮಿತ್ತಕಂ| ");
INSERT INTO sankan_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ಯೇ ಬಿಭ್ಯತಿ ಜನಾಸ್ತಸ್ಮಾತ್ ತೇಷಾಂ ಸನ್ತಾನಪಂಕ್ತಿಷು| ಅನುಕಮ್ಪಾ ತದೀಯಾ ಚ ಸರ್ವ್ವದೈವ ಸುತಿಷ್ಠತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ಸ್ವಬಾಹುಬಲತಸ್ತೇನ ಪ್ರಾಕಾಶ್ಯತ ಪರಾಕ್ರಮಃ| ಮನಃಕುಮನ್ತ್ರಣಾಸಾರ್ದ್ಧಂ ವಿಕೀರ್ಯ್ಯನ್ತೇಽಭಿಮಾನಿನಃ| ");
INSERT INTO sankan_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ಸಿಂಹಾಸನಗತಾಲ್ಲೋಕಾನ್ ಬಲಿನಶ್ಚಾವರೋಹ್ಯ ಸಃ| ಪದೇಷೂಚ್ಚೇಷು ಲೋಕಾಂಸ್ತು ಕ್ಷುದ್ರಾನ್ ಸಂಸ್ಥಾಪಯತ್ಯಪಿ| ");
INSERT INTO sankan_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ಕ್ಷುಧಿತಾನ್ ಮಾನವಾನ್ ದ್ರವ್ಯೈರುತ್ತಮೈಃ ಪರಿತರ್ಪ್ಯ ಸಃ| ಸಕಲಾನ್ ಧನಿನೋ ಲೋಕಾನ್ ವಿಸೃಜೇದ್ ರಿಕ್ತಹಸ್ತಕಾನ್| ");
INSERT INTO sankan_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ಇಬ್ರಾಹೀಮಿ ಚ ತದ್ವಂಶೇ ಯಾ ದಯಾಸ್ತಿ ಸದೈವ ತಾಂ| ಸ್ಮೃತ್ವಾ ಪುರಾ ಪಿತೃಣಾಂ ನೋ ಯಥಾ ಸಾಕ್ಷಾತ್ ಪ್ರತಿಶ್ರುತಂ| ");
INSERT INTO sankan_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ಇಸ್ರಾಯೇಲ್ಸೇವಕಸ್ತೇನ ತಥೋಪಕ್ರಿಯತೇ ಸ್ವಯಂ|| ");
INSERT INTO sankan_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","ಅನನ್ತರಂ ಮರಿಯಮ್ ಪ್ರಾಯೇಣ ಮಾಸತ್ರಯಮ್ ಇಲೀಶೇವಯಾ ಸಹೋಷಿತ್ವಾ ವ್ಯಾಘುಯ್ಯ ನಿಜನಿವೇಶನಂ ಯಯೌ| ");
INSERT INTO sankan_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","ತದನನ್ತರಮ್ ಇಲೀಶೇವಾಯಾಃ ಪ್ರಸವಕಾಲ ಉಪಸ್ಥಿತೇ ಸತಿ ಸಾ ಪುತ್ರಂ ಪ್ರಾಸೋಷ್ಟ| ");
INSERT INTO sankan_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ತತಃ ಪರಮೇಶ್ವರಸ್ತಸ್ಯಾಂ ಮಹಾನುಗ್ರಹಂ ಕೃತವಾನ್ ಏತತ್ ಶ್ರುತ್ವಾ ಸಮೀಪವಾಸಿನಃ ಕುಟುಮ್ಬಾಶ್ಚಾಗತ್ಯ ತಯಾ ಸಹ ಮುಮುದಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","ತಥಾಷ್ಟಮೇ ದಿನೇ ತೇ ಬಾಲಕಸ್ಯ ತ್ವಚಂ ಛೇತ್ತುಮ್ ಏತ್ಯ ತಸ್ಯ ಪಿತೃನಾಮಾನುರೂಪಂ ತನ್ನಾಮ ಸಿಖರಿಯ ಇತಿ ಕರ್ತ್ತುಮೀಷುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ಕಿನ್ತು ತಸ್ಯ ಮಾತಾಕಥಯತ್ ತನ್ನ, ನಾಮಾಸ್ಯ ಯೋಹನ್ ಇತಿ ಕರ್ತ್ತವ್ಯಮ್| ");
INSERT INTO sankan_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ತದಾ ತೇ ವ್ಯಾಹರನ್ ತವ ವಂಶಮಧ್ಯೇ ನಾಮೇದೃಶಂ ಕಸ್ಯಾಪಿ ನಾಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ತತಃ ಪರಂ ತಸ್ಯ ಪಿತರಂ ಸಿಖರಿಯಂ ಪ್ರತಿ ಸಙ್ಕೇತ್ಯ ಪಪ್ರಚ್ಛುಃ ಶಿಶೋಃ ಕಿಂ ನಾಮ ಕಾರಿಷ್ಯತೇ? ");
INSERT INTO sankan_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ತತಃ ಸ ಫಲಕಮೇಕಂ ಯಾಚಿತ್ವಾ ಲಿಲೇಖ ತಸ್ಯ ನಾಮ ಯೋಹನ್ ಭವಿಷ್ಯತಿ| ತಸ್ಮಾತ್ ಸರ್ವ್ವೇ ಆಶ್ಚರ್ಯ್ಯಂ ಮೇನಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ತತ್ಕ್ಷಣಂ ಸಿಖರಿಯಸ್ಯ ಜಿಹ್ವಾಜಾಡ್ಯೇಽಪಗತೇ ಸ ಮುಖಂ ವ್ಯಾದಾಯ ಸ್ಪಷ್ಟವರ್ಣಮುಚ್ಚಾರ್ಯ್ಯ ಈಶ್ವರಸ್ಯ ಗುಣಾನುವಾದಂ ಚಕಾರ| ");
INSERT INTO sankan_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","ತಸ್ಮಾಚ್ಚತುರ್ದಿಕ್ಸ್ಥಾಃ ಸಮೀಪವಾಸಿಲೋಕಾ ಭೀತಾ ಏವಮೇತಾಃ ಸರ್ವ್ವಾಃ ಕಥಾ ಯಿಹೂದಾಯಾಃ ಪರ್ವ್ವತಮಯಪ್ರದೇಶಸ್ಯ ಸರ್ವ್ವತ್ರ ಪ್ರಚಾರಿತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ತಸ್ಮಾತ್ ಶ್ರೋತಾರೋ ಮನಃಸು ಸ್ಥಾಪಯಿತ್ವಾ ಕಥಯಾಮ್ಬಭೂವುಃ ಕೀದೃಶೋಯಂ ಬಾಲೋ ಭವಿಷ್ಯತಿ? ಅಥ ಪರಮೇಶ್ವರಸ್ತಸ್ಯ ಸಹಾಯೋಭೂತ್| ");
INSERT INTO sankan_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ತದಾ ಯೋಹನಃ ಪಿತಾ ಸಿಖರಿಯಃ ಪವಿತ್ರೇಣಾತ್ಮನಾ ಪರಿಪೂರ್ಣಃ ಸನ್ ಏತಾದೃಶಂ ಭವಿಷ್ಯದ್ವಾಕ್ಯಂ ಕಥಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","ಇಸ್ರಾಯೇಲಃ ಪ್ರಭು ರ್ಯಸ್ತು ಸ ಧನ್ಯಃ ಪರಮೇಶ್ವರಃ| ಅನುಗೃಹ್ಯ ನಿಜಾಲ್ಲೋಕಾನ್ ಸ ಏವ ಪರಿಮೋಚಯೇತ್| ");
INSERT INTO sankan_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ವಿಪಕ್ಷಜನಹಸ್ತೇಭ್ಯೋ ಯಥಾ ಮೋಚ್ಯಾಮಹೇ ವಯಂ| ಯಾವಜ್ಜೀವಞ್ಚ ಧರ್ಮ್ಮೇಣ ಸಾರಲ್ಯೇನ ಚ ನಿರ್ಭಯಾಃ| ");
INSERT INTO sankan_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ಸೇವಾಮಹೈ ತಮೇವೈಕಮ್ ಏತತ್ಕಾರಣಮೇವ ಚ| ಸ್ವಕೀಯಂ ಸುಪವಿತ್ರಞ್ಚ ಸಂಸ್ಮೃತ್ಯ ನಿಯಮಂ ಸದಾ| ");
INSERT INTO sankan_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ಕೃಪಯಾ ಪುರುಷಾನ್ ಪೂರ್ವ್ವಾನ್ ನಿಕಷಾರ್ಥಾತ್ತು ನಃ ಪಿತುಃ| ಇಬ್ರಾಹೀಮಃ ಸಮೀಪೇ ಯಂ ಶಪಥಂ ಕೃತವಾನ್ ಪುರಾ| ");
INSERT INTO sankan_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ತಮೇವ ಸಫಲಂ ಕರ್ತ್ತಂ ತಥಾ ಶತ್ರುಗಣಸ್ಯ ಚ| ಋृತೀಯಾಕಾರಿಣಶ್ಚೈವ ಕರೇಭ್ಯೋ ರಕ್ಷಣಾಯ ನಃ| ");
INSERT INTO sankan_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ಸೃಷ್ಟೇಃ ಪ್ರಥಮತಃ ಸ್ವೀಯೈಃ ಪವಿತ್ರೈ ರ್ಭಾವಿವಾದಿಭಿಃ| ");
INSERT INTO sankan_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ಯಥೋಕ್ತವಾನ್ ತಥಾ ಸ್ವಸ್ಯ ದಾಯೂದಃ ಸೇವಕಸ್ಯ ತು| ");
INSERT INTO sankan_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ವಂಶೇ ತ್ರಾತಾರಮೇಕಂ ಸ ಸಮುತ್ಪಾದಿತವಾನ್ ಸ್ವಯಮ್| ");
INSERT INTO sankan_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ಅತೋ ಹೇ ಬಾಲಕ ತ್ವನ್ತು ಸರ್ವ್ವೇಭ್ಯಃ ಶ್ರೇಷ್ಠ ಏವ ಯಃ| ತಸ್ಯೈವ ಭಾವಿವಾದೀತಿ ಪ್ರವಿಖ್ಯಾತೋ ಭವಿಷ್ಯಸಿ| ಅಸ್ಮಾಕಂ ಚರಣಾನ್ ಕ್ಷೇಮೇ ಮಾರ್ಗೇ ಚಾಲಯಿತುಂ ಸದಾ| ಏವಂ ಧ್ವಾನ್ತೇಽರ್ಥತೋ ಮೃತ್ಯೋಶ್ಛಾಯಾಯಾಂ ಯೇ ತು ಮಾನವಾಃ| ");
INSERT INTO sankan_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ಉಪವಿಷ್ಟಾಸ್ತು ತಾನೇವ ಪ್ರಕಾಶಯಿತುಮೇವ ಹಿ| ಕೃತ್ವಾ ಮಹಾನುಕಮ್ಪಾಂ ಹಿ ಯಾಮೇವ ಪರಮೇಶ್ವರಃ| ");
INSERT INTO sankan_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ಊರ್ದ್ವ್ವಾತ್ ಸೂರ್ಯ್ಯಮುದಾಯ್ಯೈವಾಸ್ಮಭ್ಯಂ ಪ್ರಾದಾತ್ತು ದರ್ಶನಂ| ತಯಾನುಕಮ್ಪಯಾ ಸ್ವಸ್ಯ ಲೋಕಾನಾಂ ಪಾಪಮೋಚನೇ| ");
INSERT INTO sankan_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ಪರಿತ್ರಾಣಸ್ಯ ತೇಭ್ಯೋ ಹಿ ಜ್ಞಾನವಿಶ್ರಾಣನಾಯ ಚ| ಪ್ರಭೋ ರ್ಮಾರ್ಗಂ ಪರಿಷ್ಕರ್ತ್ತುಂ ತಸ್ಯಾಗ್ರಾಯೀ ಭವಿಷ್ಯಸಿ|| ");
INSERT INTO sankan_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","ಅಥ ಬಾಲಕಃ ಶರೀರೇಣ ಬುದ್ಧ್ಯಾ ಚ ವರ್ದ್ಧಿತುಮಾರೇಭೇ; ಅಪರಞ್ಚ ಸ ಇಸ್ರಾಯೇಲೋ ವಂಶೀಯಲೋಕಾನಾಂ ಸಮೀಪೇ ಯಾವನ್ನ ಪ್ರಕಟೀಭೂತಸ್ತಾಸ್ತಾವತ್ ಪ್ರಾನ್ತರೇ ನ್ಯವಸತ್| ");
INSERT INTO sankan_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","ಅಪರಞ್ಚ ತಸ್ಮಿನ್ ಕಾಲೇ ರಾಜ್ಯಸ್ಯ ಸರ್ವ್ವೇಷಾಂ ಲೋಕಾನಾಂ ನಾಮಾನಿ ಲೇಖಯಿತುಮ್ ಅಗಸ್ತಕೈಸರ ಆಜ್ಞಾಪಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ತದನುಸಾರೇಣ ಕುರೀಣಿಯನಾಮನಿ ಸುರಿಯಾದೇಶಸ್ಯ ಶಾಸಕೇ ಸತಿ ನಾಮಲೇಖನಂ ಪ್ರಾರೇಭೇ| ");
INSERT INTO sankan_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","ಅತೋ ಹೇತೋ ರ್ನಾಮ ಲೇಖಿತುಂ ಸರ್ವ್ವೇ ಜನಾಃ ಸ್ವೀಯಂ ಸ್ವೀಯಂ ನಗರಂ ಜಗ್ಮುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ತದಾನೀಂ ಯೂಷಫ್ ನಾಮ ಲೇಖಿತುಂ ವಾಗ್ದತ್ತಯಾ ಸ್ವಭಾರ್ಯ್ಯಯಾ ಗರ್ಬ್ಭವತ್ಯಾ ಮರಿಯಮಾ ಸಹ ಸ್ವಯಂ ದಾಯೂದಃ ಸಜಾತಿವಂಶ ಇತಿ ಕಾರಣಾದ್ ಗಾಲೀಲ್ಪ್ರದೇಶಸ್ಯ ನಾಸರತ್ನಗರಾದ್ ");
INSERT INTO sankan_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ಯಿಹೂದಾಪ್ರದೇಶಸ್ಯ ಬೈತ್ಲೇಹಮಾಖ್ಯಂ ದಾಯೂದ್ನಗರಂ ಜಗಾಮ| ");
INSERT INTO sankan_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ಅನ್ಯಚ್ಚ ತತ್ರ ಸ್ಥಾನೇ ತಯೋಸ್ತಿಷ್ಠತೋಃ ಸತೋ ರ್ಮರಿಯಮಃ ಪ್ರಸೂತಿಕಾಲ ಉಪಸ್ಥಿತೇ ");
INSERT INTO sankan_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ಸಾ ತಂ ಪ್ರಥಮಸುತಂ ಪ್ರಾಸೋಷ್ಟ ಕಿನ್ತು ತಸ್ಮಿನ್ ವಾಸಗೃಹೇ ಸ್ಥಾನಾಭಾವಾದ್ ಬಾಲಕಂ ವಸ್ತ್ರೇಣ ವೇಷ್ಟಯಿತ್ವಾ ಗೋಶಾಲಾಯಾಂ ಸ್ಥಾಪಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","ಅನನ್ತರಂ ಯೇ ಕಿಯನ್ತೋ ಮೇಷಪಾಲಕಾಃ ಸ್ವಮೇಷವ್ರಜರಕ್ಷಾಯೈ ತತ್ಪ್ರದೇಶೇ ಸ್ಥಿತ್ವಾ ರಜನ್ಯಾಂ ಪ್ರಾನ್ತರೇ ಪ್ರಹರಿಣಃ ಕರ್ಮ್ಮ ಕುರ್ವ್ವನ್ತಿ, ");
INSERT INTO sankan_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","ತೇಷಾಂ ಸಮೀಪಂ ಪರಮೇಶ್ವರಸ್ಯ ದೂತ ಆಗತ್ಯೋಪತಸ್ಥೌ; ತದಾ ಚತುಷ್ಪಾರ್ಶ್ವೇ ಪರಮೇಶ್ವರಸ್ಯ ತೇಜಸಃ ಪ್ರಕಾಶಿತತ್ವಾತ್ ತೇಽತಿಶಶಙ್ಕಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ತದಾ ಸ ದೂತ ಉವಾಚ ಮಾ ಭೈಷ್ಟ ಪಶ್ಯತಾದ್ಯ ದಾಯೂದಃ ಪುರೇ ಯುಷ್ಮನ್ನಿಮಿತ್ತಂ ತ್ರಾತಾ ಪ್ರಭುಃ ಖ್ರೀಷ್ಟೋಽಜನಿಷ್ಟ, ");
INSERT INTO sankan_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ಸರ್ವ್ವೇಷಾಂ ಲೋಕಾನಾಂ ಮಹಾನನ್ದಜನಕಮ್ ಇಮಂ ಮಙ್ಗಲವೃತ್ತಾನ್ತಂ ಯುಷ್ಮಾನ್ ಜ್ಞಾಪಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","ಯೂಯಂ (ತತ್ಸ್ಥಾನಂ ಗತ್ವಾ) ವಸ್ತ್ರವೇಷ್ಟಿತಂ ತಂ ಬಾಲಕಂ ಗೋಶಾಲಾಯಾಂ ಶಯನಂ ದ್ರಕ್ಷ್ಯಥ ಯುಷ್ಮಾನ್ ಪ್ರತೀದಂ ಚಿಹ್ನಂ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ದೂತ ಇಮಾಂ ಕಥಾಂ ಕಥಿತವತಿ ತತ್ರಾಕಸ್ಮಾತ್ ಸ್ವರ್ಗೀಯಾಃ ಪೃತನಾ ಆಗತ್ಯ ಕಥಾಮ್ ಇಮಾಂ ಕಥಯಿತ್ವೇಶ್ವರಸ್ಯ ಗುಣಾನನ್ವವಾದಿಷುಃ, ಯಥಾ, ");
INSERT INTO sankan_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","ಸರ್ವ್ವೋರ್ದ್ವ್ವಸ್ಥೈರೀಶ್ವರಸ್ಯ ಮಹಿಮಾ ಸಮ್ಪ್ರಕಾಶ್ಯತಾಂ| ಶಾನ್ತಿರ್ಭೂಯಾತ್ ಪೃಥಿವ್ಯಾಸ್ತು ಸನ್ತೋಷಶ್ಚ ನರಾನ್ ಪ್ರತಿ|| ");
INSERT INTO sankan_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ತತಃ ಪರಂ ತೇಷಾಂ ಸನ್ನಿಧೇ ರ್ದೂತಗಣೇ ಸ್ವರ್ಗಂ ಗತೇ ಮೇಷಪಾಲಕಾಃ ಪರಸ್ಪರಮ್ ಅವೇಚನ್ ಆಗಚ್ಛತ ಪ್ರಭುಃ ಪರಮೇಶ್ವರೋ ಯಾಂ ಘಟನಾಂ ಜ್ಞಾಪಿತವಾನ್ ತಸ್ಯಾ ಯಾಥರ್ಯಂ ಜ್ಞಾತುಂ ವಯಮಧುನಾ ಬೈತ್ಲೇಹಮ್ಪುರಂ ಯಾಮಃ| ");
INSERT INTO sankan_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ಪಶ್ಚಾತ್ ತೇ ತೂರ್ಣಂ ವ್ರಜಿತ್ವಾ ಮರಿಯಮಂ ಯೂಷಫಂ ಗೋಶಾಲಾಯಾಂ ಶಯನಂ ಬಾಲಕಞ್ಚ ದದೃಶುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ಇತ್ಥಂ ದೃಷ್ಟ್ವಾ ಬಾಲಕಸ್ಯಾರ್ಥೇ ಪ್ರೋಕ್ತಾಂ ಸರ್ವ್ವಕಥಾಂ ತೇ ಪ್ರಾಚಾರಯಾಞ್ಚಕ್ರುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ತತೋ ಯೇ ಲೋಕಾ ಮೇಷರಕ್ಷಕಾಣಾಂ ವದನೇಭ್ಯಸ್ತಾಂ ವಾರ್ತ್ತಾಂ ಶುಶ್ರುವುಸ್ತೇ ಮಹಾಶ್ಚರ್ಯ್ಯಂ ಮೇನಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ಕಿನ್ತು ಮರಿಯಮ್ ಏತತ್ಸರ್ವ್ವಘಟನಾನಾಂ ತಾತ್ಪರ್ಯ್ಯಂ ವಿವಿಚ್ಯ ಮನಸಿ ಸ್ಥಾಪಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","ತತ್ಪಶ್ಚಾದ್ ದೂತವಿಜ್ಞಪ್ತಾನುರೂಪಂ ಶ್ರುತ್ವಾ ದೃಷ್ಟ್ವಾ ಚ ಮೇಷಪಾಲಕಾ ಈಶ್ವರಸ್ಯ ಗುಣಾನುವಾದಂ ಧನ್ಯವಾದಞ್ಚ ಕುರ್ವ್ವಾಣಾಃ ಪರಾವೃತ್ಯ ಯಯುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","ಅಥ ಬಾಲಕಸ್ಯ ತ್ವಕ್ಛೇದನಕಾಲೇಽಷ್ಟಮದಿವಸೇ ಸಮುಪಸ್ಥಿತೇ ತಸ್ಯ ಗರ್ಬ್ಭಸ್ಥಿತೇಃ ಪುರ್ವ್ವಂ ಸ್ವರ್ಗೀಯದೂತೋ ಯಥಾಜ್ಞಾಪಯತ್ ತದನುರೂಪಂ ತೇ ತನ್ನಾಮಧೇಯಂ ಯೀಶುರಿತಿ ಚಕ್ರಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","ತತಃ ಪರಂ ಮೂಸಾಲಿಖಿತವ್ಯವಸ್ಥಾಯಾ ಅನುಸಾರೇಣ ಮರಿಯಮಃ ಶುಚಿತ್ವಕಾಲ ಉಪಸ್ಥಿತೇ, ");
INSERT INTO sankan_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","\"ಪ್ರಥಮಜಃ ಸರ್ವ್ವಃ ಪುರುಷಸನ್ತಾನಃ ಪರಮೇಶ್ವರೇ ಸಮರ್ಪ್ಯತಾಂ,\" ಇತಿ ಪರಮೇಶ್ವರಸ್ಯ ವ್ಯವಸ್ಥಯಾ ");
INSERT INTO sankan_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ಯೀಶುಂ ಪರಮೇಶ್ವರೇ ಸಮರ್ಪಯಿತುಮ್ ಶಾಸ್ತ್ರೀಯವಿಧ್ಯುಕ್ತಂ ಕಪೋತದ್ವಯಂ ಪಾರಾವತಶಾವಕದ್ವಯಂ ವಾ ಬಲಿಂ ದಾತುಂ ತೇ ತಂ ಗೃಹೀತ್ವಾ ಯಿರೂಶಾಲಮಮ್ ಆಯಯುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ಯಿರೂಶಾಲಮ್ಪುರನಿವಾಸೀ ಶಿಮಿಯೋನ್ನಾಮಾ ಧಾರ್ಮ್ಮಿಕ ಏಕ ಆಸೀತ್ ಸ ಇಸ್ರಾಯೇಲಃ ಸಾನ್ತ್ವನಾಮಪೇಕ್ಷ್ಯ ತಸ್ಥೌ ಕಿಞ್ಚ ಪವಿತ್ರ ಆತ್ಮಾ ತಸ್ಮಿನ್ನಾವಿರ್ಭೂತಃ| ");
INSERT INTO sankan_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ಅಪರಂ ಪ್ರಭುಣಾ ಪರಮೇಶ್ವರೇಣಾಭಿಷಿಕ್ತೇ ತ್ರಾತರಿ ತ್ವಯಾ ನ ದೃಷ್ಟೇ ತ್ವಂ ನ ಮರಿಷ್ಯಸೀತಿ ವಾಕ್ಯಂ ಪವಿತ್ರೇಣ ಆತ್ಮನಾ ತಸ್ಮ ಪ್ರಾಕಥ್ಯತ| ");
INSERT INTO sankan_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ಅಪರಞ್ಚ ಯದಾ ಯೀಶೋಃ ಪಿತಾ ಮಾತಾ ಚ ತದರ್ಥಂ ವ್ಯವಸ್ಥಾನುರೂಪಂ ಕರ್ಮ್ಮ ಕರ್ತ್ತುಂ ತಂ ಮನ್ದಿರಮ್ ಆನಿನ್ಯತುಸ್ತದಾ ");
INSERT INTO sankan_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ಶಿಮಿಯೋನ್ ಆತ್ಮನ ಆಕರ್ಷಣೇನ ಮನ್ದಿರಮಾಗತ್ಯ ತಂ ಕ್ರೋಡೇ ನಿಧಾಯ ಈಶ್ವರಸ್ಯ ಧನ್ಯವಾದಂ ಕೃತ್ವಾ ಕಥಯಾಮಾಸ, ಯಥಾ, ");
INSERT INTO sankan_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","ಹೇ ಪ್ರಭೋ ತವ ದಾಸೋಯಂ ನಿಜವಾಕ್ಯಾನುಸಾರತಃ| ಇದಾನೀನ್ತು ಸಕಲ್ಯಾಣೋ ಭವತಾ ಸಂವಿಸೃಜ್ಯತಾಮ್| ");
INSERT INTO sankan_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ಯತಃ ಸಕಲದೇಶಸ್ಯ ದೀಪ್ತಯೇ ದೀಪ್ತಿರೂಪಕಂ| ");
INSERT INTO sankan_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ಇಸ್ರಾಯೇಲೀಯಲೋಕಸ್ಯ ಮಹಾಗೌರವರೂಪಕಂ| ");
INSERT INTO sankan_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ಯಂ ತ್ರಾಯಕಂ ಜನಾನಾನ್ತು ಸಮ್ಮುಖೇ ತ್ವಮಜೀಜನಃ| ಸಏವ ವಿದ್ಯತೇಽಸ್ಮಾಕಂ ಧ್ರವಂ ನಯನನಗೋಚರೇ|| ");
INSERT INTO sankan_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ತದಾನೀಂ ತೇನೋಕ್ತಾ ಏತಾಃ ಸಕಲಾಃ ಕಥಾಃ ಶ್ರುತ್ವಾ ತಸ್ಯ ಮಾತಾ ಯೂಷಫ್ ಚ ವಿಸ್ಮಯಂ ಮೇನಾತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ತತಃ ಪರಂ ಶಿಮಿಯೋನ್ ತೇಭ್ಯ ಆಶಿಷಂ ದತ್ತ್ವಾ ತನ್ಮಾತರಂ ಮರಿಯಮಮ್ ಉವಾಚ, ಪಶ್ಯ ಇಸ್ರಾಯೇಲೋ ವಂಶಮಧ್ಯೇ ಬಹೂನಾಂ ಪಾತನಾಯೋತ್ಥಾಪನಾಯ ಚ ತಥಾ ವಿರೋಧಪಾತ್ರಂ ಭವಿತುಂ, ಬಹೂನಾಂ ಗುಪ್ತಮನೋಗತಾನಾಂ ಪ್ರಕಟೀಕರಣಾಯ ಬಾಲಕೋಯಂ ನಿಯುಕ್ತೋಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ತಸ್ಮಾತ್ ತವಾಪಿ ಪ್ರಾಣಾಃ ಶೂಲೇನ ವ್ಯತ್ಸ್ಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","ಅಪರಞ್ಚ ಆಶೇರಸ್ಯ ವಂಶೀಯಫಿನೂಯೇಲೋ ದುಹಿತಾ ಹನ್ನಾಖ್ಯಾ ಅತಿಜರತೀ ಭವಿಷ್ಯದ್ವಾದಿನ್ಯೇಕಾ ಯಾ ವಿವಾಹಾತ್ ಪರಂ ಸಪ್ತ ವತ್ಸರಾನ್ ಪತ್ಯಾ ಸಹ ನ್ಯವಸತ್ ತತೋ ವಿಧವಾ ಭೂತ್ವಾ ಚತುರಶೀತಿವರ್ಷವಯಃಪರ್ಯ್ಯನತಂ ");
INSERT INTO sankan_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ಮನ್ದಿರೇ ಸ್ಥಿತ್ವಾ ಪ್ರಾರ್ಥನೋಪವಾಸೈರ್ದಿವಾನಿಶಮ್ ಈಶ್ವರಮ್ ಅಸೇವತ ಸಾಪಿ ಸ್ತ್ರೀ ತಸ್ಮಿನ್ ಸಮಯೇ ಮನ್ದಿರಮಾಗತ್ಯ ");
INSERT INTO sankan_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","ಪರಮೇಶ್ವರಸ್ಯ ಧನ್ಯವಾದಂ ಚಕಾರ, ಯಿರೂಶಾಲಮ್ಪುರವಾಸಿನೋ ಯಾವನ್ತೋ ಲೋಕಾ ಮುಕ್ತಿಮಪೇಕ್ಷ್ಯ ಸ್ಥಿತಾಸ್ತಾನ್ ಯೀಶೋರ್ವೃತ್ತಾನ್ತಂ ಜ್ಞಾಪಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ಇತ್ಥಂ ಪರಮೇಶ್ವರಸ್ಯ ವ್ಯವಸ್ಥಾನುಸಾರೇಣ ಸರ್ವ್ವೇಷು ಕರ್ಮ್ಮಸು ಕೃತೇಷು ತೌ ಪುನಶ್ಚ ಗಾಲೀಲೋ ನಾಸರತ್ನಾಮಕಂ ನಿಜನಗರಂ ಪ್ರತಸ್ಥಾತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","ತತ್ಪಶ್ಚಾದ್ ಬಾಲಕಃ ಶರೀರೇಣ ವೃದ್ಧಿಮೇತ್ಯ ಜ್ಞಾನೇನ ಪರಿಪೂರ್ಣ ಆತ್ಮನಾ ಶಕ್ತಿಮಾಂಶ್ಚ ಭವಿತುಮಾರೇಭೇ ತಥಾ ತಸ್ಮಿನ್ ಈಶ್ವರಾನುಗ್ರಹೋ ಬಭೂವ| ");
INSERT INTO sankan_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","ತಸ್ಯ ಪಿತಾ ಮಾತಾ ಚ ಪ್ರತಿವರ್ಷಂ ನಿಸ್ತಾರೋತ್ಸವಸಮಯೇ ಯಿರೂಶಾಲಮಮ್ ಅಗಚ್ಛತಾಮ್| ");
INSERT INTO sankan_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","ಅಪರಞ್ಚ ಯೀಶೌ ದ್ವಾದಶವರ್ಷವಯಸ್ಕೇ ಸತಿ ತೌ ಪರ್ವ್ವಸಮಯಸ್ಯ ರೀತ್ಯನುಸಾರೇಣ ಯಿರೂಶಾಲಮಂ ಗತ್ವಾ ");
INSERT INTO sankan_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ಪಾರ್ವ್ವಣಂ ಸಮ್ಪಾದ್ಯ ಪುನರಪಿ ವ್ಯಾಘುಯ್ಯ ಯಾತಃ ಕಿನ್ತು ಯೀಶುರ್ಬಾಲಕೋ ಯಿರೂಶಾಲಮಿ ತಿಷ್ಠತಿ| ಯೂಷಫ್ ತನ್ಮಾತಾ ಚ ತದ್ ಅವಿದಿತ್ವಾ ");
INSERT INTO sankan_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ಸ ಸಙ್ಗಿಭಿಃ ಸಹ ವಿದ್ಯತ ಏತಚ್ಚ ಬುದ್ವ್ವಾ ದಿನೈಕಗಮ್ಯಮಾರ್ಗಂ ಜಗ್ಮತುಃ| ಕಿನ್ತು ಶೇಷೇ ಜ್ಞಾತಿಬನ್ಧೂನಾಂ ಸಮೀಪೇ ಮೃಗಯಿತ್ವಾ ತದುದ್ದೇेಶಮಪ್ರಾಪ್ಯ ");
INSERT INTO sankan_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ತೌ ಪುನರಪಿ ಯಿರೂಶಾಲಮಮ್ ಪರಾವೃತ್ಯಾಗತ್ಯ ತಂ ಮೃಗಯಾಞ್ಚಕ್ರತುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ಅಥ ದಿನತ್ರಯಾತ್ ಪರಂ ಪಣ್ಡಿತಾನಾಂ ಮಧ್ಯೇ ತೇಷಾಂ ಕಥಾಃ ಶೃಣ್ವನ್ ತತ್ತ್ವಂ ಪೃಚ್ಛಂಶ್ಚ ಮನ್ದಿರೇ ಸಮುಪವಿಷ್ಟಃ ಸ ತಾಭ್ಯಾಂ ದೃಷ್ಟಃ| ");
INSERT INTO sankan_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ತದಾ ತಸ್ಯ ಬುದ್ಧ್ಯಾ ಪ್ರತ್ಯುತ್ತರೈಶ್ಚ ಸರ್ವ್ವೇ ಶ್ರೋತಾರೋ ವಿಸ್ಮಯಮಾಪದ್ಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ತಾದೃಶಂ ದೃಷ್ಟ್ವಾ ತಸ್ಯ ಜನಕೋ ಜನನೀ ಚ ಚಮಚ್ಚಕ್ರತುಃ ಕಿಞ್ಚ ತಸ್ಯ ಮಾತಾ ತಮವದತ್, ಹೇ ಪುತ್ರ, ಕಥಮಾವಾಂ ಪ್ರತೀತ್ಥಂ ಸಮಾಚರಸ್ತ್ವಮ್? ಪಶ್ಯ ತವ ಪಿತಾಹಞ್ಚ ಶೋಕಾಕುಲೌ ಸನ್ತೌ ತ್ವಾಮನ್ವಿಚ್ಛಾವಃ ಸ್ಮ| ");
INSERT INTO sankan_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ತತಃ ಸೋವದತ್ ಕುತೋ ಮಾಮ್ ಅನ್ವೈಚ್ಛತಂ? ಪಿತುರ್ಗೃಹೇ ಮಯಾ ಸ್ಥಾತವ್ಯಮ್ ಏತತ್ ಕಿಂ ಯುವಾಭ್ಯಾಂ ನ ಜ್ಞಾಯತೇ? ");
INSERT INTO sankan_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","ಕಿನ್ತು ತೌ ತಸ್ಯೈತದ್ವಾಕ್ಯಸ್ಯ ತಾತ್ಪರ್ಯ್ಯಂ ಬೋದ್ಧುಂ ನಾಶಕ್ನುತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ತತಃ ಪರಂ ಸ ತಾಭ್ಯಾಂ ಸಹ ನಾಸರತಂ ಗತ್ವಾ ತಯೋರ್ವಶೀಭೂತಸ್ತಸ್ಥೌ ಕಿನ್ತು ಸರ್ವ್ವಾ ಏತಾಃ ಕಥಾಸ್ತಸ್ಯ ಮಾತಾ ಮನಸಿ ಸ್ಥಾಪಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","ಅಥ ಯೀಶೋ ರ್ಬುದ್ಧಿಃ ಶರೀರಞ್ಚ ತಥಾ ತಸ್ಮಿನ್ ಈಶ್ವರಸ್ಯ ಮಾನವಾನಾಞ್ಚಾನುಗ್ರಹೋ ವರ್ದ್ಧಿತುಮ್ ಆರೇಭೇ| ");
INSERT INTO sankan_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","ಅನನ್ತರಂ ತಿಬಿರಿಯಕೈಸರಸ್ಯ ರಾಜತ್ವಸ್ಯ ಪಞ್ಚದಶೇ ವತ್ಸರೇ ಸತಿ ಯದಾ ಪನ್ತೀಯಪೀಲಾತೋ ಯಿಹೂದಾದೇಶಾಧಿಪತಿ ರ್ಹೇರೋದ್ ತು ಗಾಲೀಲ್ಪ್ರದೇಶಸ್ಯ ರಾಜಾ ಫಿಲಿಪನಾಮಾ ತಸ್ಯ ಭ್ರಾತಾ ತು ಯಿತೂರಿಯಾಯಾಸ್ತ್ರಾಖೋನೀತಿಯಾಪ್ರದೇಶಸ್ಯ ಚ ರಾಜಾಸೀತ್ ಲುಷಾನೀಯನಾಮಾ ಅವಿಲೀನೀದೇಶಸ್ಯ ರಾಜಾಸೀತ್ ");
INSERT INTO sankan_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ಹಾನನ್ ಕಿಯಫಾಶ್ಚೇಮೌ ಪ್ರಧಾನಯಾಜಾಕಾವಾಸ್ತಾಂ ತದಾನೀಂ ಸಿಖರಿಯಸ್ಯ ಪುತ್ರಾಯ ಯೋಹನೇ ಮಧ್ಯೇಪ್ರಾನ್ತರಮ್ ಈಶ್ವರಸ್ಯ ವಾಕ್ಯೇ ಪ್ರಕಾಶಿತೇ ಸತಿ ");
INSERT INTO sankan_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ಸ ಯರ್ದ್ದನ ಉಭಯತಟಪ್ರದೇಶಾನ್ ಸಮೇತ್ಯ ಪಾಪಮೋಚನಾರ್ಥಂ ಮನಃಪರಾವರ್ತ್ತನಸ್ಯ ಚಿಹ್ನರೂಪಂ ಯನ್ಮಜ್ಜನಂ ತದೀಯಾಃ ಕಥಾಃ ಸರ್ವ್ವತ್ರ ಪ್ರಚಾರಯಿತುಮಾರೇಭೇ| ");
INSERT INTO sankan_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ಯಿಶಯಿಯಭವಿಷ್ಯದ್ವಕ್ತೃಗ್ರನ್ಥೇ ಯಾದೃಶೀ ಲಿಪಿರಾಸ್ತೇ ಯಥಾ, ಪರಮೇಶಸ್ಯ ಪನ್ಥಾನಂ ಪರಿಷ್ಕುರುತ ಸರ್ವ್ವತಃ| ತಸ್ಯ ರಾಜಪಥಞ್ಚೈವ ಸಮಾನಂ ಕುರುತಾಧುನಾ| ");
INSERT INTO sankan_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ಕಾರಿಷ್ಯನ್ತೇ ಸಮುಚ್ಛ್ರಾಯಾಃ ಸಕಲಾ ನಿಮ್ನಭೂಮಯಃ| ಕಾರಿಷ್ಯನ್ತೇ ನತಾಃ ಸರ್ವ್ವೇ ಪರ್ವ್ವತಾಶ್ಚೋಪಪರ್ವ್ವತಾಃ| ಕಾರಿಷ್ಯನ್ತೇ ಚ ಯಾ ವಕ್ರಾಸ್ತಾಃ ಸರ್ವ್ವಾಃ ಸರಲಾ ಭುವಃ| ಕಾರಿಷ್ಯನ್ತೇ ಸಮಾನಾಸ್ತಾ ಯಾ ಉಚ್ಚನೀಚಭೂಮಯಃ| ");
INSERT INTO sankan_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ಈಶ್ವರೇಣ ಕೃತಂ ತ್ರಾಣಂ ದ್ರಕ್ಷ್ಯನ್ತಿ ಸರ್ವ್ವಮಾನವಾಃ| ಇತ್ಯೇತತ್ ಪ್ರಾನ್ತರೇ ವಾಕ್ಯಂ ವದತಃ ಕಸ್ಯಚಿದ್ ರವಃ|| ");
INSERT INTO sankan_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ಯೇ ಯೇ ಲೋಕಾ ಮಜ್ಜನಾರ್ಥಂ ಬಹಿರಾಯಯುಸ್ತಾನ್ ಸೋವದತ್ ರೇ ರೇ ಸರ್ಪವಂಶಾ ಆಗಾಮಿನಃ ಕೋಪಾತ್ ಪಲಾಯಿತುಂ ಯುಷ್ಮಾನ್ ಕಶ್ಚೇತಯಾಮಾಸ? ");
INSERT INTO sankan_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","ತಸ್ಮಾದ್ ಇಬ್ರಾಹೀಮ್ ಅಸ್ಮಾಕಂ ಪಿತಾ ಕಥಾಮೀದೃಶೀಂ ಮನೋಭಿ ರ್ನ ಕಥಯಿತ್ವಾ ಯೂಯಂ ಮನಃಪರಿವರ್ತ್ತನಯೋಗ್ಯಂ ಫಲಂ ಫಲತ; ಯುಷ್ಮಾನಹಂ ಯಥಾರ್ಥಂ ವದಾಮಿ ಪಾಷಾಣೇಭ್ಯ ಏತೇಭ್ಯ ಈಶ್ವರ ಇಬ್ರಾಹೀಮಃ ಸನ್ತಾನೋತ್ಪಾದನೇ ಸಮರ್ಥಃ| ");
INSERT INTO sankan_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ಅಪರಞ್ಚ ತರುಮೂಲೇಽಧುನಾಪಿ ಪರಶುಃ ಸಂಲಗ್ನೋಸ್ತಿ ಯಸ್ತರುರುತ್ತಮಂ ಫಲಂ ನ ಫಲತಿ ಸ ಛಿದ್ಯತೇಽಗ್ನೌ ನಿಕ್ಷಿಪ್ಯತೇ ಚ| ");
INSERT INTO sankan_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","ತದಾನೀಂ ಲೋಕಾಸ್ತಂ ಪಪ್ರಚ್ಛುಸ್ತರ್ಹಿ ಕಿಂ ಕರ್ತ್ತವ್ಯಮಸ್ಮಾಭಿಃ? ");
INSERT INTO sankan_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ತತಃ ಸೋವಾದೀತ್ ಯಸ್ಯ ದ್ವೇ ವಸನೇ ವಿದ್ಯೇತೇ ಸ ವಸ್ತ್ರಹೀನಾಯೈಕಂ ವಿತರತು ಕಿಂಞ್ಚ ಯಸ್ಯ ಖಾದ್ಯದ್ರವ್ಯಂ ವಿದ್ಯತೇ ಸೋಪಿ ತಥೈವ ಕರೋತು| ");
INSERT INTO sankan_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ತತಃ ಪರಂ ಕರಸಞ್ಚಾಯಿನೋ ಮಜ್ಜನಾರ್ಥಮ್ ಆಗತ್ಯ ಪಪ್ರಚ್ಛುಃ ಹೇ ಗುರೋ ಕಿಂ ಕರ್ತ್ತವ್ಯಮಸ್ಮಾಭಿಃ? ");
INSERT INTO sankan_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ತತಃ ಸೋಕಥಯತ್ ನಿರೂಪಿತಾದಧಿಕಂ ನ ಗೃಹ್ಲಿತ| ");
INSERT INTO sankan_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","ಅನನ್ತರಂ ಸೇನಾಗಣ ಏತ್ಯ ಪಪ್ರಚ್ಛ ಕಿಮಸ್ಮಾಭಿ ರ್ವಾ ಕರ್ತ್ತವ್ಯಮ್? ತತಃ ಸೋಭಿದಧೇ ಕಸ್ಯ ಕಾಮಪಿ ಹಾನಿಂ ಮಾ ಕಾರ್ಷ್ಟ ತಥಾ ಮೃಷಾಪವಾದಂ ಮಾ ಕುರುತ ನಿಜವೇತನೇನ ಚ ಸನ್ತುಷ್ಯ ತಿಷ್ಠತ| ");
INSERT INTO sankan_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","ಅಪರಞ್ಚ ಲೋಕಾ ಅಪೇಕ್ಷಯಾ ಸ್ಥಿತ್ವಾ ಸರ್ವ್ವೇಪೀತಿ ಮನೋಭಿ ರ್ವಿತರ್ಕಯಾಞ್ಚಕ್ರುಃ, ಯೋಹನಯಮ್ ಅಭಿಷಿಕ್ತಸ್ತ್ರಾತಾ ನ ವೇತಿ? ");
INSERT INTO sankan_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ತದಾ ಯೋಹನ್ ಸರ್ವ್ವಾನ್ ವ್ಯಾಜಹಾರ, ಜಲೇಽಹಂ ಯುಷ್ಮಾನ್ ಮಜ್ಜಯಾಮಿ ಸತ್ಯಂ ಕಿನ್ತು ಯಸ್ಯ ಪಾದುಕಾಬನ್ಧನಂ ಮೋಚಯಿತುಮಪಿ ನ ಯೋಗ್ಯೋಸ್ಮಿ ತಾದೃಶ ಏಕೋ ಮತ್ತೋ ಗುರುತರಃ ಪುಮಾನ್ ಏತಿ, ಸ ಯುಷ್ಮಾನ್ ವಹ್ನಿರೂಪೇ ಪವಿತ್ರ ಆತ್ಮನಿ ಮಜ್ಜಯಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ಅಪರಞ್ಚ ತಸ್ಯ ಹಸ್ತೇ ಶೂರ್ಪ ಆಸ್ತೇ ಸ ಸ್ವಶಸ್ಯಾನಿ ಶುದ್ಧರೂಪಂ ಪ್ರಸ್ಫೋಟ್ಯ ಗೋಧೂಮಾನ್ ಸರ್ವ್ವಾನ್ ಭಾಣ್ಡಾಗಾರೇ ಸಂಗ್ರಹೀಷ್ಯತಿ ಕಿನ್ತು ಬೂಷಾಣಿ ಸರ್ವ್ವಾಣ್ಯನಿರ್ವ್ವಾಣವಹ್ನಿನಾ ದಾಹಯಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ಯೋಹನ್ ಉಪದೇಶೇನೇತ್ಥಂ ನಾನಾಕಥಾ ಲೋಕಾನಾಂ ಸಮಕ್ಷಂ ಪ್ರಚಾರಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ಅಪರಞ್ಚ ಹೇರೋದ್ ರಾಜಾ ಫಿಲಿಪ್ನಾಮ್ನಃ ಸಹೋದರಸ್ಯ ಭಾರ್ಯ್ಯಾಂ ಹೇರೋದಿಯಾಮಧಿ ತಥಾನ್ಯಾನಿ ಯಾನಿ ಯಾನಿ ಕುಕರ್ಮ್ಮಾಣಿ ಕೃತವಾನ್ ತದಧಿ ಚ ");
INSERT INTO sankan_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ಯೋಹನಾ ತಿರಸ್ಕೃತೋ ಭೂತ್ವಾ ಕಾರಾಗಾರೇ ತಸ್ಯ ಬನ್ಧನಾದ್ ಅಪರಮಪಿ ಕುಕರ್ಮ್ಮ ಚಕಾರ| ");
INSERT INTO sankan_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ಇತಃ ಪೂರ್ವ್ವಂ ಯಸ್ಮಿನ್ ಸಮಯೇ ಸರ್ವ್ವೇ ಯೋಹನಾ ಮಜ್ಜಿತಾಸ್ತದಾನೀಂ ಯೀಶುರಪ್ಯಾಗತ್ಯ ಮಜ್ಜಿತಃ| ");
INSERT INTO sankan_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ತದನನ್ತರಂ ತೇನ ಪ್ರಾರ್ಥಿತೇ ಮೇಘದ್ವಾರಂ ಮುಕ್ತಂ ತಸ್ಮಾಚ್ಚ ಪವಿತ್ರ ಆತ್ಮಾ ಮೂರ್ತ್ತಿಮಾನ್ ಭೂತ್ವಾ ಕಪೋತವತ್ ತದುಪರ್ಯ್ಯವರುರೋಹ; ತದಾ ತ್ವಂ ಮಮ ಪ್ರಿಯಃ ಪುತ್ರಸ್ತ್ವಯಿ ಮಮ ಪರಮಃ ಸನ್ತೋಷ ಇತ್ಯಾಕಾಶವಾಣೀ ಬಭೂವ| ");
INSERT INTO sankan_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","ತದಾನೀಂ ಯೀಶುಃ ಪ್ರಾಯೇಣ ತ್ರಿಂಶದ್ವರ್ಷವಯಸ್ಕ ಆಸೀತ್| ಲೌಕಿಕಜ್ಞಾನೇ ತು ಸ ಯೂಷಫಃ ಪುತ್ರಃ, ");
INSERT INTO sankan_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ಯೂಷಫ್ ಏಲೇಃ ಪುತ್ರಃ, ಏಲಿರ್ಮತ್ತತಃ ಪುತ್ರಃ, ಮತ್ತತ್ ಲೇವೇಃ ಪುತ್ರಃ, ಲೇವಿ ರ್ಮಲ್ಕೇಃ ಪುತ್ರಃ, ಮಲ್ಕಿರ್ಯಾನ್ನಸ್ಯ ಪುತ್ರಃ; ಯಾನ್ನೋ ಯೂಷಫಃ ಪುತ್ರಃ| ");
INSERT INTO sankan_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ಯೂಷಫ್ ಮತ್ತಥಿಯಸ್ಯ ಪುತ್ರಃ, ಮತ್ತಥಿಯ ಆಮೋಸಃ ಪುತ್ರಃ, ಆಮೋಸ್ ನಹೂಮಃ ಪುತ್ರಃ, ನಹೂಮ್ ಇಷ್ಲೇಃ ಪುತ್ರಃ ಇಷ್ಲಿರ್ನಗೇಃ ಪುತ್ರಃ| ");
INSERT INTO sankan_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ನಗಿರ್ಮಾಟಃ ಪುತ್ರಃ, ಮಾಟ್ ಮತ್ತಥಿಯಸ್ಯ ಪುತ್ರಃ, ಮತ್ತಥಿಯಃ ಶಿಮಿಯೇಃ ಪುತ್ರಃ, ಶಿಮಿಯಿರ್ಯೂಷಫಃ ಪುತ್ರಃ, ಯೂಷಫ್ ಯಿಹೂದಾಃ ಪುತ್ರಃ| ");
INSERT INTO sankan_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ಯಿಹೂದಾ ಯೋಹಾನಾಃ ಪುತ್ರಃ, ಯೋಹಾನಾ ರೀಷಾಃ ಪುತ್ರಃ, ರೀಷಾಃ ಸಿರುಬ್ಬಾಬಿಲಃ ಪುತ್ರಃ, ಸಿರುಬ್ಬಾಬಿಲ್ ಶಲ್ತೀಯೇಲಃ ಪುತ್ರಃ, ಶಲ್ತೀಯೇಲ್ ನೇರೇಃ ಪುತ್ರಃ| ");
INSERT INTO sankan_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ನೇರಿರ್ಮಲ್ಕೇಃ ಪುತ್ರಃ, ಮಲ್ಕಿಃ ಅದ್ಯಃ ಪುತ್ರಃ, ಅದ್ದೀ ಕೋಷಮಃ ಪುತ್ರಃ, ಕೋಷಮ್ ಇಲ್ಮೋದದಃ ಪುತ್ರಃ, ಇಲ್ಮೋದದ್ ಏರಃ ಪುತ್ರಃ| ");
INSERT INTO sankan_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ಏರ್ ಯೋಶೇಃ ಪುತ್ರಃ, ಯೋಶಿಃ ಇಲೀಯೇಷರಃ ಪುತ್ರಃ, ಇಲೀಯೇಷರ್ ಯೋರೀಮಃ ಪುತ್ರಃ, ಯೋರೀಮ್ ಮತ್ತತಃ ಪುತ್ರಃ, ಮತ್ತತ ಲೇವೇಃ ಪುತ್ರಃ| ");
INSERT INTO sankan_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ಲೇವಿಃ ಶಿಮಿಯೋನಃ ಪುತ್ರಃ, ಶಿಮಿಯೋನ್ ಯಿಹೂದಾಃ ಪುತ್ರಃ, ಯಿಹೂದಾ ಯೂಷುಫಃ ಪುತ್ರಃ, ಯೂಷುಫ್ ಯೋನನಃ ಪುತ್ರಃ, ಯಾನನ್ ಇಲೀಯಾಕೀಮಃ ಪುತ್ರಃ| ");
INSERT INTO sankan_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ಇಲಿಯಾಕೀಮ್ಃ ಮಿಲೇಯಾಃ ಪುತ್ರಃ, ಮಿಲೇಯಾ ಮೈನನಃ ಪುತ್ರಃ, ಮೈನನ್ ಮತ್ತತ್ತಸ್ಯ ಪುತ್ರಃ, ಮತ್ತತ್ತೋ ನಾಥನಃ ಪುತ್ರಃ, ನಾಥನ್ ದಾಯೂದಃ ಪುತ್ರಃ| ");
INSERT INTO sankan_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ದಾಯೂದ್ ಯಿಶಯಃ ಪುತ್ರಃ, ಯಿಶಯ ಓಬೇದಃ ಪುತ್ರ, ಓಬೇದ್ ಬೋಯಸಃ ಪುತ್ರಃ, ಬೋಯಸ್ ಸಲ್ಮೋನಃ ಪುತ್ರಃ, ಸಲ್ಮೋನ್ ನಹಶೋನಃ ಪುತ್ರಃ| ");
INSERT INTO sankan_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ನಹಶೋನ್ ಅಮ್ಮೀನಾದಬಃ ಪುತ್ರಃ, ಅಮ್ಮೀನಾದಬ್ ಅರಾಮಃ ಪುತ್ರಃ, ಅರಾಮ್ ಹಿಷ್ರೋಣಃ ಪುತ್ರಃ, ಹಿಷ್ರೋಣ್ ಪೇರಸಃ ಪುತ್ರಃ, ಪೇರಸ್ ಯಿಹೂದಾಃ ಪುತ್ರಃ| ");
INSERT INTO sankan_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ಯಿಹೂದಾ ಯಾಕೂಬಃ ಪುತ್ರಃ, ಯಾಕೂಬ್ ಇಸ್ಹಾಕಃ ಪುತ್ರಃ, ಇಸ್ಹಾಕ್ ಇಬ್ರಾಹೀಮಃ ಪುತ್ರಃ, ಇಬ್ರಾಹೀಮ್ ತೇರಹಃ ಪುತ್ರಃ, ತೇರಹ್ ನಾಹೋರಃ ಪುತ್ರಃ| ");
INSERT INTO sankan_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ನಾಹೋರ್ ಸಿರುಗಃ ಪುತ್ರಃ, ಸಿರುಗ್ ರಿಯ್ವಃ ಪುತ್ರಃ, ರಿಯೂಃ ಪೇಲಗಃ ಪುತ್ರಃ, ಪೇಲಗ್ ಏವರಃ ಪುತ್ರಃ, ಏವರ್ ಶೇಲಹಃ ಪುತ್ರಃ| ");
INSERT INTO sankan_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ಶೇಲಹ್ ಕೈನನಃ ಪುತ್ರಃ, ಕೈನನ್ ಅರ್ಫಕ್ಷದಃ ಪುತ್ರಃ, ಅರ್ಫಕ್ಷದ್ ಶಾಮಃ ಪುತ್ರಃ, ಶಾಮ್ ನೋಹಃ ಪುತ್ರಃ, ನೋಹೋ ಲೇಮಕಃ ಪುತ್ರಃ| ");
INSERT INTO sankan_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ಲೇಮಕ್ ಮಿಥೂಶೇಲಹಃ ಪುತ್ರಃ, ಮಿಥೂಶೇಲಹ್ ಹನೋಕಃ ಪುತ್ರಃ, ಹನೋಕ್ ಯೇರದಃ ಪುತ್ರಃ, ಯೇರದ್ ಮಹಲಲೇಲಃ ಪುತ್ರಃ, ಮಹಲಲೇಲ್ ಕೈನನಃ ಪುತ್ರಃ| ");
INSERT INTO sankan_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ಕೈನನ್ ಇನೋಶಃ ಪುತ್ರಃ, ಇನೋಶ್ ಶೇತಃ ಪುತ್ರಃ, ಶೇತ್ ಆದಮಃ ಪುತ್ರ, ಆದಮ್ ಈಶ್ವರಸ್ಯ ಪುತ್ರಃ| ");
INSERT INTO sankan_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ತತಃ ಪರಂ ಯೀಶುಃ ಪವಿತ್ರೇಣಾತ್ಮನಾ ಪೂರ್ಣಃ ಸನ್ ಯರ್ದ್ದನನದ್ಯಾಃ ಪರಾವೃತ್ಯಾತ್ಮನಾ ಪ್ರಾನ್ತರಂ ನೀತಃ ಸನ್ ಚತ್ವಾರಿಂಶದ್ದಿನಾನಿ ಯಾವತ್ ಶೈತಾನಾ ಪರೀಕ್ಷಿತೋಽಭೂತ್, ");
INSERT INTO sankan_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ಕಿಞ್ಚ ತಾನಿ ಸರ್ವ್ವದಿನಾನಿ ಭೋಜನಂ ವಿನಾ ಸ್ಥಿತತ್ವಾತ್ ಕಾಲೇ ಪೂರ್ಣೇ ಸ ಕ್ಷುಧಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ತತಃ ಶೈತಾನಾಗತ್ಯ ತಮವದತ್ ತ್ವಂ ಚೇದೀಶ್ವರಸ್ಯ ಪುತ್ರಸ್ತರ್ಹಿ ಪ್ರಸ್ತರಾನೇತಾನ್ ಆಜ್ಞಯಾ ಪೂಪಾನ್ ಕುರು| ");
INSERT INTO sankan_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","ತದಾ ಯೀಶುರುವಾಚ, ಲಿಪಿರೀದೃಶೀ ವಿದ್ಯತೇ ಮನುಜಃ ಕೇವಲೇನ ಪೂಪೇನ ನ ಜೀವತಿ ಕಿನ್ತ್ವೀಶ್ವರಸ್ಯ ಸರ್ವ್ವಾಭಿರಾಜ್ಞಾಭಿ ರ್ಜೀವತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ತದಾ ಶೈತಾನ್ ತಮುಚ್ಚಂ ಪರ್ವ್ವತಂ ನೀತ್ವಾ ನಿಮಿಷೈಕಮಧ್ಯೇ ಜಗತಃ ಸರ್ವ್ವರಾಜ್ಯಾನಿ ದರ್ಶಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ಪಶ್ಚಾತ್ ತಮವಾದೀತ್ ಸರ್ವ್ವಮ್ ಏತದ್ ವಿಭವಂ ಪ್ರತಾಪಞ್ಚ ತುಭ್ಯಂ ದಾಸ್ಯಾಮಿ ತನ್ ಮಯಿ ಸಮರ್ಪಿತಮಾಸ್ತೇ ಯಂ ಪ್ರತಿ ಮಮೇಚ್ಛಾ ಜಾಯತೇ ತಸ್ಮೈ ದಾತುಂ ಶಕ್ನೋಮಿ, ");
INSERT INTO sankan_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ತ್ವಂ ಚೇನ್ಮಾಂ ಭಜಸೇ ತರ್ಹಿ ಸರ್ವ್ವಮೇತತ್ ತವೈವ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","ತದಾ ಯೀಶುಸ್ತಂ ಪ್ರತ್ಯುಕ್ತವಾನ್ ದೂರೀ ಭವ ಶೈತಾನ್ ಲಿಪಿರಾಸ್ತೇ, ನಿಜಂ ಪ್ರಭುಂ ಪರಮೇಶ್ವರಂ ಭಜಸ್ವ ಕೇವಲಂ ತಮೇವ ಸೇವಸ್ವ ಚ| ");
INSERT INTO sankan_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ಅಥ ಶೈತಾನ್ ತಂ ಯಿರೂಶಾಲಮಂ ನೀತ್ವಾ ಮನ್ದಿರಸ್ಯ ಚೂಡಾಯಾ ಉಪರಿ ಸಮುಪವೇಶ್ಯ ಜಗಾದ ತ್ವಂ ಚೇದೀಶ್ವರಸ್ಯ ಪುತ್ರಸ್ತರ್ಹಿ ಸ್ಥಾನಾದಿತೋ ಲಮ್ಫಿತ್ವಾಧಃ ");
INSERT INTO sankan_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ಪತ ಯತೋ ಲಿಪಿರಾಸ್ತೇ, ಆಜ್ಞಾಪಯಿಷ್ಯತಿ ಸ್ವೀಯಾನ್ ದೂತಾನ್ ಸ ಪರಮೇಶ್ವರಃ| ");
INSERT INTO sankan_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ರಕ್ಷಿತುಂ ಸರ್ವ್ವಮಾರ್ಗೇ ತ್ವಾಂ ತೇನ ತ್ವಚ್ಚರಣೇ ಯಥಾ| ನ ಲಗೇತ್ ಪ್ರಸ್ತರಾಘಾತಸ್ತ್ವಾಂ ಧರಿಷ್ಯನ್ತಿ ತೇ ತಥಾ| ");
INSERT INTO sankan_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","ತದಾ ಯೀಶುನಾ ಪ್ರತ್ಯುಕ್ತಮ್ ಇದಮಪ್ಯುಕ್ತಮಸ್ತಿ ತ್ವಂ ಸ್ವಪ್ರಭುಂ ಪರೇಶಂ ಮಾ ಪರೀಕ್ಷಸ್ವ| ");
INSERT INTO sankan_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","ಪಶ್ಚಾತ್ ಶೈತಾನ್ ಸರ್ವ್ವಪರೀಕ್ಷಾಂ ಸಮಾಪ್ಯ ಕ್ಷಣಾತ್ತಂ ತ್ಯಕ್ತ್ವಾ ಯಯೌ| ");
INSERT INTO sankan_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","ತದಾ ಯೀಶುರಾತ್ಮಪ್ರಭಾವಾತ್ ಪುನರ್ಗಾಲೀಲ್ಪ್ರದೇಶಂ ಗತಸ್ತದಾ ತತ್ಸುಖ್ಯಾತಿಶ್ಚತುರ್ದಿಶಂ ವ್ಯಾನಶೇ| ");
INSERT INTO sankan_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ಸ ತೇಷಾಂ ಭಜನಗೃಹೇಷು ಉಪದಿಶ್ಯ ಸರ್ವ್ವೈಃ ಪ್ರಶಂಸಿತೋ ಬಭೂವ| ");
INSERT INTO sankan_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","ಅಥ ಸ ಸ್ವಪಾಲನಸ್ಥಾನಂ ನಾಸರತ್ಪುರಮೇತ್ಯ ವಿಶ್ರಾಮವಾರೇ ಸ್ವಾಚಾರಾದ್ ಭಜನಗೇಹಂ ಪ್ರವಿಶ್ಯ ಪಠಿತುಮುತ್ತಸ್ಥೌ| ");
INSERT INTO sankan_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ತತೋ ಯಿಶಯಿಯಭವಿಷ್ಯದ್ವಾದಿನಃ ಪುಸ್ತಕೇ ತಸ್ಯ ಕರದತ್ತೇ ಸತಿ ಸ ತತ್ ಪುಸ್ತಕಂ ವಿಸ್ತಾರ್ಯ್ಯ ಯತ್ರ ವಕ್ಷ್ಯಮಾಣಾನಿ ವಚನಾನಿ ಸನ್ತಿ ತತ್ ಸ್ಥಾನಂ ಪ್ರಾಪ್ಯ ಪಪಾಠ| ");
INSERT INTO sankan_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","ಆತ್ಮಾ ತು ಪರಮೇಶಸ್ಯ ಮದೀಯೋಪರಿ ವಿದ್ಯತೇ| ದರಿದ್ರೇಷು ಸುಸಂವಾದಂ ವಕ್ತುಂ ಮಾಂ ಸೋಭಿಷಿಕ್ತವಾನ್| ಭಗ್ನಾನ್ತಃ ಕರಣಾಲ್ಲೋಕಾನ್ ಸುಸ್ವಸ್ಥಾನ್ ಕರ್ತ್ತುಮೇವ ಚ| ಬನ್ದೀಕೃತೇಷು ಲೋಕೇಷು ಮುಕ್ತೇ ರ್ಘೋಷಯಿತುಂ ವಚಃ| ನೇತ್ರಾಣಿ ದಾತುಮನ್ಧೇಭ್ಯಸ್ತ್ರಾತುಂ ಬದ್ಧಜನಾನಪಿ| ");
INSERT INTO sankan_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ಪರೇಶಾನುಗ್ರಹೇ ಕಾಲಂ ಪ್ರಚಾರಯಿತುಮೇವ ಚ| ಸರ್ವ್ವೈತತ್ಕರಣಾರ್ಥಾಯ ಮಾಮೇವ ಪ್ರಹಿಣೋತಿ ಸಃ|| ");
INSERT INTO sankan_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ತತಃ ಪುಸ್ತಕಂ ಬದ್ವ್ವಾ ಪರಿಚಾರಕಸ್ಯ ಹಸ್ತೇ ಸಮರ್ಪ್ಯ ಚಾಸನೇ ಸಮುಪವಿಷ್ಟಃ, ತತೋ ಭಜನಗೃಹೇ ಯಾವನ್ತೋ ಲೋಕಾ ಆಸನ್ ತೇ ಸರ್ವ್ವೇಽನನ್ಯದೃಷ್ಟ್ಯಾ ತಂ ವಿಲುಲೋಕಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ಅನನ್ತರಮ್ ಅದ್ಯೈತಾನಿ ಸರ್ವ್ವಾಣಿ ಲಿಖಿತವಚನಾನಿ ಯುಷ್ಮಾಕಂ ಮಧ್ಯೇ ಸಿದ್ಧಾನಿ ಸ ಇಮಾಂ ಕಥಾಂ ತೇಭ್ಯಃ ಕಥಯಿತುಮಾರೇಭೇ| ");
INSERT INTO sankan_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ತತಃ ಸರ್ವ್ವೇ ತಸ್ಮಿನ್ ಅನ್ವರಜ್ಯನ್ತ, ಕಿಞ್ಚ ತಸ್ಯ ಮುಖಾನ್ನಿರ್ಗತಾಭಿರನುಗ್ರಹಸ್ಯ ಕಥಾಭಿಶ್ಚಮತ್ಕೃತ್ಯ ಕಥಯಾಮಾಸುಃ ಕಿಮಯಂ ಯೂಷಫಃ ಪುತ್ರೋ ನ? ");
INSERT INTO sankan_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ತದಾ ಸೋಽವಾದೀದ್ ಹೇ ಚಿಕಿತ್ಸಕ ಸ್ವಮೇವ ಸ್ವಸ್ಥಂ ಕುರು ಕಫರ್ನಾಹೂಮಿ ಯದ್ಯತ್ ಕೃತವಾನ್ ತದಶ್ರೌಷ್ಮ ತಾಃ ಸರ್ವಾಃ ಕ್ರಿಯಾ ಅತ್ರ ಸ್ವದೇಶೇ ಕುರು ಕಥಾಮೇತಾಂ ಯೂಯಮೇವಾವಶ್ಯಂ ಮಾಂ ವದಿಷ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ಪುನಃ ಸೋವಾದೀದ್ ಯುಷ್ಮಾನಹಂ ಯಥಾರ್ಥಂ ವದಾಮಿ, ಕೋಪಿ ಭವಿಷ್ಯದ್ವಾದೀ ಸ್ವದೇಶೇ ಸತ್ಕಾರಂ ನ ಪ್ರಾಪ್ನೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","ಅಪರಞ್ಚ ಯಥಾರ್ಥಂ ವಚ್ಮಿ, ಏಲಿಯಸ್ಯ ಜೀವನಕಾಲೇ ಯದಾ ಸಾರ್ದ್ಧತ್ರಿತಯವರ್ಷಾಣಿ ಯಾವತ್ ಜಲದಪ್ರತಿಬನ್ಧಾತ್ ಸರ್ವ್ವಸ್ಮಿನ್ ದೇಶೇ ಮಹಾದುರ್ಭಿಕ್ಷಮ್ ಅಜನಿಷ್ಟ ತದಾನೀಮ್ ಇಸ್ರಾಯೇಲೋ ದೇಶಸ್ಯ ಮಧ್ಯೇ ಬಹ್ವ್ಯೋ ವಿಧವಾ ಆಸನ್, ");
INSERT INTO sankan_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ಕಿನ್ತು ಸೀದೋನ್ಪ್ರದೇಶೀಯಸಾರಿಫತ್ಪುರನಿವಾಸಿನೀಮ್ ಏಕಾಂ ವಿಧವಾಂ ವಿನಾ ಕಸ್ಯಾಶ್ಚಿದಪಿ ಸಮೀಪೇ ಏಲಿಯಃ ಪ್ರೇರಿತೋ ನಾಭೂತ್| ");
INSERT INTO sankan_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","ಅಪರಞ್ಚ ಇಲೀಶಾಯಭವಿಷ್ಯದ್ವಾದಿವಿದ್ಯಮಾನತಾಕಾಲೇ ಇಸ್ರಾಯೇಲ್ದೇಶೇ ಬಹವಃ ಕುಷ್ಠಿನ ಆಸನ್ ಕಿನ್ತು ಸುರೀಯದೇಶೀಯಂ ನಾಮಾನ್ಕುಷ್ಠಿನಂ ವಿನಾ ಕೋಪ್ಯನ್ಯಃ ಪರಿಷ್ಕೃತೋ ನಾಭೂತ್| ");
INSERT INTO sankan_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ಇಮಾಂ ಕಥಾಂ ಶ್ರುತ್ವಾ ಭಜನಗೇಹಸ್ಥಿತಾ ಲೋಕಾಃ ಸಕ್ರೋಧಮ್ ಉತ್ಥಾಯ ");
INSERT INTO sankan_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ನಗರಾತ್ತಂ ಬಹಿಷ್ಕೃತ್ಯ ಯಸ್ಯ ಶಿಖರಿಣ ಉಪರಿ ತೇಷಾಂ ನಗರಂ ಸ್ಥಾಪಿತಮಾಸ್ತೇ ತಸ್ಮಾನ್ನಿಕ್ಷೇಪ್ತುಂ ತಸ್ಯ ಶಿಖರಂ ತಂ ನಿನ್ಯುಃ ");
INSERT INTO sankan_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","ಕಿನ್ತು ಸ ತೇಷಾಂ ಮಧ್ಯಾದಪಸೃತ್ಯ ಸ್ಥಾನಾನ್ತರಂ ಜಗಾಮ| ");
INSERT INTO sankan_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ತತಃ ಪರಂ ಯೀಶುರ್ಗಾಲೀಲ್ಪ್ರದೇಶೀಯಕಫರ್ನಾಹೂಮ್ನಗರ ಉಪಸ್ಥಾಯ ವಿಶ್ರಾಮವಾರೇ ಲೋಕಾನುಪದೇಷ್ಟುಮ್ ಆರಬ್ಧವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ತದುಪದೇಶಾತ್ ಸರ್ವ್ವೇ ಚಮಚ್ಚಕ್ರು ರ್ಯತಸ್ತಸ್ಯ ಕಥಾ ಗುರುತರಾ ಆಸನ್| ");
INSERT INTO sankan_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","ತದಾನೀಂ ತದ್ಭಜನಗೇಹಸ್ಥಿತೋಽಮೇಧ್ಯಭೂತಗ್ರಸ್ತ ಏಕೋ ಜನ ಉಚ್ಚೈಃ ಕಥಯಾಮಾಸ, ");
INSERT INTO sankan_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","ಹೇ ನಾಸರತೀಯಯೀಶೋಽಸ್ಮಾನ್ ತ್ಯಜ, ತ್ವಯಾ ಸಹಾಸ್ಮಾಕಂ ಕಃ ಸಮ್ಬನ್ಧಃ? ಕಿಮಸ್ಮಾನ್ ವಿನಾಶಯಿತುಮಾಯಾಸಿ? ತ್ವಮೀಶ್ವರಸ್ಯ ಪವಿತ್ರೋ ಜನ ಏತದಹಂ ಜಾನಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","ತದಾ ಯೀಶುಸ್ತಂ ತರ್ಜಯಿತ್ವಾವದತ್ ಮೌನೀ ಭವ ಇತೋ ಬಹಿರ್ಭವ; ತತಃ ಸೋಮೇಧ್ಯಭೂತಸ್ತಂ ಮಧ್ಯಸ್ಥಾನೇ ಪಾತಯಿತ್ವಾ ಕಿಞ್ಚಿದಪ್ಯಹಿಂಸಿತ್ವಾ ತಸ್ಮಾದ್ ಬಹಿರ್ಗತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ತತಃ ಸರ್ವ್ವೇ ಲೋಕಾಶ್ಚಮತ್ಕೃತ್ಯ ಪರಸ್ಪರಂ ವಕ್ತುಮಾರೇಭಿರೇ ಕೋಯಂ ಚಮತ್ಕಾರಃ| ಏಷ ಪ್ರಭಾವೇಣ ಪರಾಕ್ರಮೇಣ ಚಾಮೇಧ್ಯಭೂತಾನ್ ಆಜ್ಞಾಪಯತಿ ತೇನೈವ ತೇ ಬಹಿರ್ಗಚ್ಛನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ಅನನ್ತರಂ ಚತುರ್ದಿಕ್ಸ್ಥದೇಶಾನ್ ತಸ್ಯ ಸುಖ್ಯಾತಿರ್ವ್ಯಾಪ್ನೋತ್| ");
INSERT INTO sankan_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ತದನನ್ತರಂ ಸ ಭಜನಗೇಹಾದ್ ಬಹಿರಾಗತ್ಯ ಶಿಮೋನೋ ನಿವೇಶನಂ ಪ್ರವಿವೇಶ ತದಾ ತಸ್ಯ ಶ್ವಶ್ರೂರ್ಜ್ವರೇಣಾತ್ಯನ್ತಂ ಪೀಡಿತಾಸೀತ್ ಶಿಷ್ಯಾಸ್ತದರ್ಥಂ ತಸ್ಮಿನ್ ವಿನಯಂ ಚಕ್ರುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ತತಃ ಸ ತಸ್ಯಾಃ ಸಮೀಪೇ ಸ್ಥಿತ್ವಾ ಜ್ವರಂ ತರ್ಜಯಾಮಾಸ ತೇನೈವ ತಾಂ ಜ್ವರೋಽತ್ಯಾಕ್ಷೀತ್ ತತಃ ಸಾ ತತ್ಕ್ಷಣಮ್ ಉತ್ಥಾಯ ತಾನ್ ಸಿಷೇವೇ| ");
INSERT INTO sankan_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","ಅಥ ಸೂರ್ಯ್ಯಾಸ್ತಕಾಲೇ ಸ್ವೇಷಾಂ ಯೇ ಯೇ ಜನಾ ನಾನಾರೋಗೈಃ ಪೀಡಿತಾ ಆಸನ್ ಲೋಕಾಸ್ತಾನ್ ಯೀಶೋಃ ಸಮೀಪಮ್ ಆನಿನ್ಯುಃ, ತದಾ ಸ ಏಕೈಕಸ್ಯ ಗಾತ್ರೇ ಕರಮರ್ಪಯಿತ್ವಾ ತಾನರೋಗಾನ್ ಚಕಾರ| ");
INSERT INTO sankan_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ತತೋ ಭೂತಾ ಬಹುಭ್ಯೋ ನಿರ್ಗತ್ಯ ಚೀತ್ಶಬ್ದಂ ಕೃತ್ವಾ ಚ ಬಭಾಷಿರೇ ತ್ವಮೀಶ್ವರಸ್ಯ ಪುತ್ರೋಽಭಿಷಿಕ್ತತ್ರಾತಾ; ಕಿನ್ತು ಸೋಭಿಷಿಕ್ತತ್ರಾತೇತಿ ತೇ ವಿವಿದುರೇತಸ್ಮಾತ್ ಕಾರಣಾತ್ ತಾನ್ ತರ್ಜಯಿತ್ವಾ ತದ್ವಕ್ತುಂ ನಿಷಿಷೇಧ| ");
INSERT INTO sankan_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","ಅಪರಞ್ಚ ಪ್ರಭಾತೇ ಸತಿ ಸ ವಿಜನಸ್ಥಾನಂ ಪ್ರತಸ್ಥೇ ಪಶ್ಚಾತ್ ಜನಾಸ್ತಮನ್ವಿಚ್ಛನ್ತಸ್ತನ್ನಿಕಟಂ ಗತ್ವಾ ಸ್ಥಾನಾನ್ತರಗಮನಾರ್ಥಂ ತಮನ್ವರುನ್ಧನ್| ");
INSERT INTO sankan_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ಕಿನ್ತು ಸ ತಾನ್ ಜಗಾದ, ಈಶ್ವರೀಯರಾಜ್ಯಸ್ಯ ಸುಸಂವಾದಂ ಪ್ರಚಾರಯಿತುಮ್ ಅನ್ಯಾನಿ ಪುರಾಣ್ಯಪಿ ಮಯಾ ಯಾತವ್ಯಾನಿ ಯತಸ್ತದರ್ಥಮೇವ ಪ್ರೇರಿತೋಹಂ| ");
INSERT INTO sankan_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ಅಥ ಗಾಲೀಲೋ ಭಜನಗೇಹೇಷು ಸ ಉಪದಿದೇಶ| ");
INSERT INTO sankan_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","ಅನನ್ತರಂ ಯೀಶುರೇಕದಾ ಗಿನೇಷರಥ್ದಸ್ಯ ತೀರ ಉತ್ತಿಷ್ಠತಿ, ತದಾ ಲೋಕಾ ಈಶ್ವರೀಯಕಥಾಂ ಶ್ರೋತುಂ ತದುಪರಿ ಪ್ರಪತಿತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ತದಾನೀಂ ಸ ಹ್ದಸ್ಯ ತೀರಸಮೀಪೇ ನೌದ್ವಯಂ ದದರ್ಶ ಕಿಞ್ಚ ಮತ್ಸ್ಯೋಪಜೀವಿನೋ ನಾವಂ ವಿಹಾಯ ಜಾಲಂ ಪ್ರಕ್ಷಾಲಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ತತಸ್ತಯೋರ್ದ್ವಯೋ ರ್ಮಧ್ಯೇ ಶಿಮೋನೋ ನಾವಮಾರುಹ್ಯ ತೀರಾತ್ ಕಿಞ್ಚಿದ್ದೂರಂ ಯಾತುಂ ತಸ್ಮಿನ್ ವಿನಯಂ ಕೃತ್ವಾ ನೌಕಾಯಾಮುಪವಿಶ್ಯ ಲೋಕಾನ್ ಪ್ರೋಪದಿಷ್ಟವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ಪಶ್ಚಾತ್ ತಂ ಪ್ರಸ್ತಾವಂ ಸಮಾಪ್ಯ ಸ ಶಿಮೋನಂ ವ್ಯಾಜಹಾರ, ಗಭೀರಂ ಜಲಂ ಗತ್ವಾ ಮತ್ಸ್ಯಾನ್ ಧರ್ತ್ತುಂ ಜಾಲಂ ನಿಕ್ಷಿಪ| ");
INSERT INTO sankan_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ತತಃ ಶಿಮೋನ ಬಭಾಷೇ, ಹೇ ಗುರೋ ಯದ್ಯಪಿ ವಯಂ ಕೃತ್ಸ್ನಾಂ ಯಾಮಿನೀಂ ಪರಿಶ್ರಮ್ಯ ಮತ್ಸ್ಯೈಕಮಪಿ ನ ಪ್ರಾಪ್ತಾಸ್ತಥಾಪಿ ಭವತೋ ನಿದೇಶತೋ ಜಾಲಂ ಕ್ಷಿಪಾಮಃ| ");
INSERT INTO sankan_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ಅಥ ಜಾಲೇ ಕ್ಷಿಪ್ತೇ ಬಹುಮತ್ಸ್ಯಪತನಾದ್ ಆನಾಯಃ ಪ್ರಚ್ಛಿನ್ನಃ| ");
INSERT INTO sankan_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ತಸ್ಮಾದ್ ಉಪಕರ್ತ್ತುಮ್ ಅನ್ಯನೌಸ್ಥಾನ್ ಸಙ್ಗಿನ ಆಯಾತುಮ್ ಇಙ್ಗಿತೇನ ಸಮಾಹ್ವಯನ್ ತತಸ್ತ ಆಗತ್ಯ ಮತ್ಸ್ಯೈ ರ್ನೌದ್ವಯಂ ಪ್ರಪೂರಯಾಮಾಸು ರ್ಯೈ ರ್ನೌದ್ವಯಂ ಪ್ರಮಗ್ನಮ್| ");
INSERT INTO sankan_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ತದಾ ಶಿಮೋನ್ಪಿತರಸ್ತದ್ ವಿಲೋಕ್ಯ ಯೀಶೋಶ್ಚರಣಯೋಃ ಪತಿತ್ವಾ, ಹೇ ಪ್ರಭೋಹಂ ಪಾಪೀ ನರೋ ಮಮ ನಿಕಟಾದ್ ಭವಾನ್ ಯಾತು, ಇತಿ ಕಥಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","ಯತೋ ಜಾಲೇ ಪತಿತಾನಾಂ ಮತ್ಸ್ಯಾನಾಂ ಯೂಥಾತ್ ಶಿಮೋನ್ ತತ್ಸಙ್ಗಿನಶ್ಚ ಚಮತ್ಕೃತವನ್ತಃ; ಶಿಮೋನಃ ಸಹಕಾರಿಣೌ ಸಿವದೇಃ ಪುತ್ರೌ ಯಾಕೂಬ್ ಯೋಹನ್ ಚೇಮೌ ತಾದೃಶೌ ಬಭೂವತುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ತದಾ ಯೀಶುಃ ಶಿಮೋನಂ ಜಗಾದ ಮಾ ಭೈಷೀರದ್ಯಾರಭ್ಯ ತ್ವಂ ಮನುಷ್ಯಧರೋ ಭವಿಷ್ಯಸಿ| ");
INSERT INTO sankan_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ಅನನ್ತರಂ ಸರ್ವ್ವಾಸು ನೌಸು ತೀರಮ್ ಆನೀತಾಸು ತೇ ಸರ್ವ್ವಾನ್ ಪರಿತ್ಯಜ್ಯ ತಸ್ಯ ಪಶ್ಚಾದ್ಗಾಮಿನೋ ಬಭೂವುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","ತತಃ ಪರಂ ಯೀಶೌ ಕಸ್ಮಿಂಶ್ಚಿತ್ ಪುರೇ ತಿಷ್ಠತಿ ಜನ ಏಕಃ ಸರ್ವ್ವಾಙ್ಗಕುಷ್ಠಸ್ತಂ ವಿಲೋಕ್ಯ ತಸ್ಯ ಸಮೀಪೇ ನ್ಯುಬ್ಜಃ ಪತಿತ್ವಾ ಸವಿನಯಂ ವಕ್ತುಮಾರೇಭೇ, ಹೇ ಪ್ರಭೋ ಯದಿ ಭವಾನಿಚ್ಛತಿ ತರ್ಹಿ ಮಾಂ ಪರಿಷ್ಕರ್ತ್ತುಂ ಶಕ್ನೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","ತದಾನೀಂ ಸ ಪಾಣಿಂ ಪ್ರಸಾರ್ಯ್ಯ ತದಙ್ಗಂ ಸ್ಪೃಶನ್ ಬಭಾಷೇ ತ್ವಂ ಪರಿಷ್ಕ್ರಿಯಸ್ವೇತಿ ಮಮೇಚ್ಛಾಸ್ತಿ ತತಸ್ತತ್ಕ್ಷಣಂ ಸ ಕುಷ್ಠಾತ್ ಮುಕ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","ಪಶ್ಚಾತ್ ಸ ತಮಾಜ್ಞಾಪಯಾಮಾಸ ಕಥಾಮಿಮಾಂ ಕಸ್ಮೈಚಿದ್ ಅಕಥಯಿತ್ವಾ ಯಾಜಕಸ್ಯ ಸಮೀಪಞ್ಚ ಗತ್ವಾ ಸ್ವಂ ದರ್ಶಯ, ಲೋಕೇಭ್ಯೋ ನಿಜಪರಿಷ್ಕೃತತ್ವಸ್ಯ ಪ್ರಮಾಣದಾನಾಯ ಮೂಸಾಜ್ಞಾನುಸಾರೇಣ ದ್ರವ್ಯಮುತ್ಮೃಜಸ್ವ ಚ| ");
INSERT INTO sankan_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","ತಥಾಪಿ ಯೀಶೋಃ ಸುಖ್ಯಾತಿ ರ್ಬಹು ವ್ಯಾಪ್ತುಮಾರೇಭೇ ಕಿಞ್ಚ ತಸ್ಯ ಕಥಾಂ ಶ್ರೋತುಂ ಸ್ವೀಯರೋಗೇಭ್ಯೋ ಮೋಕ್ತುಞ್ಚ ಲೋಕಾ ಆಜಗ್ಮುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","ಅಥ ಸ ಪ್ರಾನ್ತರಂ ಗತ್ವಾ ಪ್ರಾರ್ಥಯಾಞ್ಚಕ್ರೇ| ");
INSERT INTO sankan_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","ಅಪರಞ್ಚ ಏಕದಾ ಯೀಶುರುಪದಿಶತಿ, ಏತರ್ಹಿ ಗಾಲೀಲ್ಯಿಹೂದಾಪ್ರದೇಶಯೋಃ ಸರ್ವ್ವನಗರೇಭ್ಯೋ ಯಿರೂಶಾಲಮಶ್ಚ ಕಿಯನ್ತಃ ಫಿರೂಶಿಲೋಕಾ ವ್ಯವಸ್ಥಾಪಕಾಶ್ಚ ಸಮಾಗತ್ಯ ತದನ್ತಿಕೇ ಸಮುಪವಿವಿಶುಃ, ತಸ್ಮಿನ್ ಕಾಲೇ ಲೋಕಾನಾಮಾರೋಗ್ಯಕಾರಣಾತ್ ಪ್ರಭೋಃ ಪ್ರಭಾವಃ ಪ್ರಚಕಾಶೇ| ");
INSERT INTO sankan_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","ಪಶ್ಚಾತ್ ಕಿಯನ್ತೋ ಲೋಕಾ ಏಕಂ ಪಕ್ಷಾಘಾತಿನಂ ಖಟ್ವಾಯಾಂ ನಿಧಾಯ ಯೀಶೋಃ ಸಮೀಪಮಾನೇತುಂ ಸಮ್ಮುಖೇ ಸ್ಥಾಪಯಿತುಞ್ಚ ವ್ಯಾಪ್ರಿಯನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ಕಿನ್ತು ಬಹುಜನನಿವಹಸಮ್ವಾಧಾತ್ ನ ಶಕ್ನುವನ್ತೋ ಗೃಹೋಪರಿ ಗತ್ವಾ ಗೃಹಪೃಷ್ಠಂ ಖನಿತ್ವಾ ತಂ ಪಕ್ಷಾಘಾತಿನಂ ಸಖಟ್ವಂ ಗೃಹಮಧ್ಯೇ ಯೀಶೋಃ ಸಮ್ಮುಖೇ ಽವರೋಹಯಾಮಾಸುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","ತದಾ ಯೀಶುಸ್ತೇಷಾಮ್ ಈದೃಶಂ ವಿಶ್ವಾಸಂ ವಿಲೋಕ್ಯ ತಂ ಪಕ್ಷಾಘಾತಿನಂ ವ್ಯಾಜಹಾರ, ಹೇ ಮಾನವ ತವ ಪಾಪಮಕ್ಷಮ್ಯತ| ");
INSERT INTO sankan_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ತಸ್ಮಾದ್ ಅಧ್ಯಾಪಕಾಃ ಫಿರೂಶಿನಶ್ಚ ಚಿತ್ತೈರಿತ್ಥಂ ಪ್ರಚಿನ್ತಿತವನ್ತಃ, ಏಷ ಜನ ಈಶ್ವರಂ ನಿನ್ದತಿ ಕೋಯಂ? ಕೇವಲಮೀಶ್ವರಂ ವಿನಾ ಪಾಪಂ ಕ್ಷನ್ತುಂ ಕಃ ಶಕ್ನೋತಿ? ");
INSERT INTO sankan_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","ತದಾ ಯೀಶುಸ್ತೇಷಾಮ್ ಇತ್ಥಂ ಚಿನ್ತನಂ ವಿದಿತ್ವಾ ತೇಭ್ಯೋಕಥಯದ್ ಯೂಯಂ ಮನೋಭಿಃ ಕುತೋ ವಿತರ್ಕಯಥ? ");
INSERT INTO sankan_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","ತವ ಪಾಪಕ್ಷಮಾ ಜಾತಾ ಯದ್ವಾ ತ್ವಮುತ್ಥಾಯ ವ್ರಜ ಏತಯೋ ರ್ಮಧ್ಯೇ ಕಾ ಕಥಾ ಸುಕಥ್ಯಾ? ");
INSERT INTO sankan_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","ಕಿನ್ತು ಪೃಥಿವ್ಯಾಂ ಪಾಪಂ ಕ್ಷನ್ತುಂ ಮಾನವಸುತಸ್ಯ ಸಾಮರ್ಥ್ಯಮಸ್ತೀತಿ ಯಥಾ ಯೂಯಂ ಜ್ಞಾತುಂ ಶಕ್ನುಥ ತದರ್ಥಂ (ಸ ತಂ ಪಕ್ಷಾಘಾತಿನಂ ಜಗಾದ) ಉತ್ತಿಷ್ಠ ಸ್ವಶಯ್ಯಾಂ ಗೃಹೀತ್ವಾ ಗೃಹಂ ಯಾಹೀತಿ ತ್ವಾಮಾದಿಶಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","ತಸ್ಮಾತ್ ಸ ತತ್ಕ್ಷಣಮ್ ಉತ್ಥಾಯ ಸರ್ವ್ವೇಷಾಂ ಸಾಕ್ಷಾತ್ ನಿಜಶಯನೀಯಂ ಗೃಹೀತ್ವಾ ಈಶ್ವರಂ ಧನ್ಯಂ ವದನ್ ನಿಜನಿವೇಶನಂ ಯಯೌ| ");
INSERT INTO sankan_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","ತಸ್ಮಾತ್ ಸರ್ವ್ವೇ ವಿಸ್ಮಯ ಪ್ರಾಪ್ತಾ ಮನಃಸು ಭೀತಾಶ್ಚ ವಯಮದ್ಯಾಸಮ್ಭವಕಾರ್ಯ್ಯಾಣ್ಯದರ್ಶಾಮ ಇತ್ಯುಕ್ತ್ವಾ ಪರಮೇಶ್ವರಂ ಧನ್ಯಂ ಪ್ರೋದಿತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","ತತಃ ಪರಂ ಬಹಿರ್ಗಚ್ಛನ್ ಕರಸಞ್ಚಯಸ್ಥಾನೇ ಲೇವಿನಾಮಾನಂ ಕರಸಞ್ಚಾಯಕಂ ದೃಷ್ಟ್ವಾ ಯೀಶುಸ್ತಮಭಿದಧೇ ಮಮ ಪಶ್ಚಾದೇಹಿ| ");
INSERT INTO sankan_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ತಸ್ಮಾತ್ ಸ ತತ್ಕ್ಷಣಾತ್ ಸರ್ವ್ವಂ ಪರಿತ್ಯಜ್ಯ ತಸ್ಯ ಪಶ್ಚಾದಿಯಾಯ| ");
INSERT INTO sankan_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","ಅನನ್ತರಂ ಲೇವಿ ರ್ನಿಜಗೃಹೇ ತದರ್ಥಂ ಮಹಾಭೋಜ್ಯಂ ಚಕಾರ, ತದಾ ತೈಃ ಸಹಾನೇಕೇ ಕರಸಞ್ಚಾಯಿನಸ್ತದನ್ಯಲೋಕಾಶ್ಚ ಭೋಕ್ತುಮುಪವಿವಿಶುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ತಸ್ಮಾತ್ ಕಾರಣಾತ್ ಚಣ್ಡಾಲಾನಾಂ ಪಾಪಿಲೋಕಾನಾಞ್ಚ ಸಙ್ಗೇ ಯೂಯಂ ಕುತೋ ಭಂಗ್ಧ್ವೇ ಪಿವಥ ಚೇತಿ ಕಥಾಂ ಕಥಯಿತ್ವಾ ಫಿರೂಶಿನೋಽಧ್ಯಾಪಕಾಶ್ಚ ತಸ್ಯ ಶಿಷ್ಯೈಃ ಸಹ ವಾಗ್ಯುದ್ಧಂ ಕರ್ತ್ತುಮಾರೇಭಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","ತಸ್ಮಾದ್ ಯೀಶುಸ್ತಾನ್ ಪ್ರತ್ಯವೋಚದ್ ಅರೋಗಲೋಕಾನಾಂ ಚಿಕಿತ್ಸಕೇನ ಪ್ರಯೋಜನಂ ನಾಸ್ತಿ ಕಿನ್ತು ಸರೋಗಾಣಾಮೇವ| ");
INSERT INTO sankan_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ಅಹಂ ಧಾರ್ಮ್ಮಿಕಾನ್ ಆಹ್ವಾತುಂ ನಾಗತೋಸ್ಮಿ ಕಿನ್ತು ಮನಃ ಪರಾವರ್ತ್ತಯಿತುಂ ಪಾಪಿನ ಏವ| ");
INSERT INTO sankan_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","ತತಸ್ತೇ ಪ್ರೋಚುಃ, ಯೋಹನಃ ಫಿರೂಶಿನಾಞ್ಚ ಶಿಷ್ಯಾ ವಾರಂವಾರಮ್ ಉಪವಸನ್ತಿ ಪ್ರಾರ್ಥಯನ್ತೇ ಚ ಕಿನ್ತು ತವ ಶಿಷ್ಯಾಃ ಕುತೋ ಭುಞ್ಜತೇ ಪಿವನ್ತಿ ಚ? ");
INSERT INTO sankan_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","ತದಾ ಸ ತಾನಾಚಖ್ಯೌ ವರೇ ಸಙ್ಗೇ ತಿಷ್ಠತಿ ವರಸ್ಯ ಸಖಿಗಣಂ ಕಿಮುಪವಾಸಯಿತುಂ ಶಕ್ನುಥ? ");
INSERT INTO sankan_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","ಕಿನ್ತು ಯದಾ ತೇಷಾಂ ನಿಕಟಾದ್ ವರೋ ನೇಷ್ಯತೇ ತದಾ ತೇ ಸಮುಪವತ್ಸ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ಸೋಪರಮಪಿ ದೃಷ್ಟಾನ್ತಂ ಕಥಯಾಮ್ಬಭೂವ ಪುರಾತನವಸ್ತ್ರೇ ಕೋಪಿ ನುತನವಸ್ತ್ರಂ ನ ಸೀವ್ಯತಿ ಯತಸ್ತೇನ ಸೇವನೇನ ಜೀರ್ಣವಸ್ತ್ರಂ ಛಿದ್ಯತೇ, ನೂತನಪುರಾತನವಸ್ತ್ರಯೋ ರ್ಮೇಲಞ್ಚ ನ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ಪುರಾತನ್ಯಾಂ ಕುತ್ವಾಂ ಕೋಪಿ ನುತನಂ ದ್ರಾಕ್ಷಾರಸಂ ನ ನಿದಧಾತಿ, ಯತೋ ನವೀನದ್ರಾಕ್ಷಾರಸಸ್ಯ ತೇಜಸಾ ಪುರಾತನೀ ಕುತೂ ರ್ವಿದೀರ್ಯ್ಯತೇ ತತೋ ದ್ರಾಕ್ಷಾರಸಃ ಪತತಿ ಕುತೂಶ್ಚ ನಶ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","ತತೋ ಹೇತೋ ರ್ನೂತನ್ಯಾಂ ಕುತ್ವಾಂ ನವೀನದ್ರಾಕ್ಷಾರಸಃ ನಿಧಾತವ್ಯಸ್ತೇನೋಭಯಸ್ಯ ರಕ್ಷಾ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","ಅಪರಞ್ಚ ಪುರಾತನಂ ದ್ರಾಕ್ಷಾರಸಂ ಪೀತ್ವಾ ಕೋಪಿ ನೂತನಂ ನ ವಾಞ್ಛತಿ, ಯತಃ ಸ ವಕ್ತಿ ನೂತನಾತ್ ಪುರಾತನಮ್ ಪ್ರಶಸ್ತಮ್| ");
INSERT INTO sankan_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ಅಚರಞ್ಚ ಪರ್ವ್ವಣೋ ದ್ವಿತೀಯದಿನಾತ್ ಪರಂ ಪ್ರಥಮವಿಶ್ರಾಮವಾರೇ ಶಸ್ಯಕ್ಷೇತ್ರೇಣ ಯೀಶೋರ್ಗಮನಕಾಲೇ ತಸ್ಯ ಶಿಷ್ಯಾಃ ಕಣಿಶಂ ಛಿತ್ತ್ವಾ ಕರೇಷು ಮರ್ದ್ದಯಿತ್ವಾ ಖಾದಿತುಮಾರೇಭಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ತಸ್ಮಾತ್ ಕಿಯನ್ತಃ ಫಿರೂಶಿನಸ್ತಾನವದನ್ ವಿಶ್ರಾಮವಾರೇ ಯತ್ ಕರ್ಮ್ಮ ನ ಕರ್ತ್ತವ್ಯಂ ತತ್ ಕುತಃ ಕುರುಥ? ");
INSERT INTO sankan_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","ಯೀಶುಃ ಪ್ರತ್ಯುವಾಚ ದಾಯೂದ್ ತಸ್ಯ ಸಙ್ಗಿನಶ್ಚ ಕ್ಷುಧಾರ್ತ್ತಾಃ ಕಿಂ ಚಕ್ರುಃ ಸ ಕಥಮ್ ಈಶ್ವರಸ್ಯ ಮನ್ದಿರಂ ಪ್ರವಿಶ್ಯ ");
INSERT INTO sankan_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ಯೇ ದರ್ಶನೀಯಾಃ ಪೂಪಾ ಯಾಜಕಾನ್ ವಿನಾನ್ಯಸ್ಯ ಕಸ್ಯಾಪ್ಯಭೋಜನೀಯಾಸ್ತಾನಾನೀಯ ಸ್ವಯಂ ಬುಭಜೇ ಸಙ್ಗಿಭ್ಯೋಪಿ ದದೌ ತತ್ ಕಿಂ ಯುಷ್ಮಾಭಿಃ ಕದಾಪಿ ನಾಪಾಠಿ? ");
INSERT INTO sankan_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ಪಶ್ಚಾತ್ ಸ ತಾನವದತ್ ಮನುಜಸುತೋ ವಿಶ್ರಾಮವಾರಸ್ಯಾಪಿ ಪ್ರಭು ರ್ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","ಅನನ್ತರಮ್ ಅನ್ಯವಿಶ್ರಾಮವಾರೇ ಸ ಭಜನಗೇಹಂ ಪ್ರವಿಶ್ಯ ಸಮುಪದಿಶತಿ| ತದಾ ತತ್ಸ್ಥಾನೇ ಶುಷ್ಕದಕ್ಷಿಣಕರ ಏಕಃ ಪುಮಾನ್ ಉಪತಸ್ಥಿವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ತಸ್ಮಾದ್ ಅಧ್ಯಾಪಕಾಃ ಫಿರೂಶಿನಶ್ಚ ತಸ್ಮಿನ್ ದೋಷಮಾರೋಪಯಿತುಂ ಸ ವಿಶ್ರಾಮವಾರೇ ತಸ್ಯ ಸ್ವಾಸ್ಥ್ಯಂ ಕರೋತಿ ನವೇತಿ ಪ್ರತೀಕ್ಷಿತುಮಾರೇಭಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","ತದಾ ಯೀಶುಸ್ತೇಷಾಂ ಚಿನ್ತಾಂ ವಿದಿತ್ವಾ ತಂ ಶುಷ್ಕಕರಂ ಪುಮಾಂಸಂ ಪ್ರೋವಾಚ, ತ್ವಮುತ್ಥಾಯ ಮಧ್ಯಸ್ಥಾನೇ ತಿಷ್ಠ| ");
INSERT INTO sankan_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ತಸ್ಮಾತ್ ತಸ್ಮಿನ್ ಉತ್ಥಿತವತಿ ಯೀಶುಸ್ತಾನ್ ವ್ಯಾಜಹಾರ, ಯುಷ್ಮಾನ್ ಇಮಾಂ ಕಥಾಂ ಪೃಚ್ಛಾಮಿ, ವಿಶ್ರಾಮವಾರೇ ಹಿತಮ್ ಅಹಿತಂ ವಾ, ಪ್ರಾಣರಕ್ಷಣಂ ಪ್ರಾಣನಾಶನಂ ವಾ, ಏತೇಷಾಂ ಕಿಂ ಕರ್ಮ್ಮಕರಣೀಯಮ್? ");
INSERT INTO sankan_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ಪಶ್ಚಾತ್ ಚತುರ್ದಿಕ್ಷು ಸರ್ವ್ವಾನ್ ವಿಲೋಕ್ಯ ತಂ ಮಾನವಂ ಬಭಾಷೇ, ನಿಜಕರಂ ಪ್ರಸಾರಯ; ತತಸ್ತೇನ ತಥಾ ಕೃತ ಇತರಕರವತ್ ತಸ್ಯ ಹಸ್ತಃ ಸ್ವಸ್ಥೋಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","ತಸ್ಮಾತ್ ತೇ ಪ್ರಚಣ್ಡಕೋಪಾನ್ವಿತಾ ಯೀಶುಂ ಕಿಂ ಕರಿಷ್ಯನ್ತೀತಿ ಪರಸ್ಪರಂ ಪ್ರಮನ್ತ್ರಿತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ತತಃ ಪರಂ ಸ ಪರ್ವ್ವತಮಾರುಹ್ಯೇಶ್ವರಮುದ್ದಿಶ್ಯ ಪ್ರಾರ್ಥಯಮಾನಃ ಕೃತ್ಸ್ನಾಂ ರಾತ್ರಿಂ ಯಾಪಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ಅಥ ದಿನೇ ಸತಿ ಸ ಸರ್ವ್ವಾನ್ ಶಿಷ್ಯಾನ್ ಆಹೂತವಾನ್ ತೇಷಾಂ ಮಧ್ಯೇ ");
INSERT INTO sankan_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ಪಿತರನಾಮ್ನಾ ಖ್ಯಾತಃ ಶಿಮೋನ್ ತಸ್ಯ ಭ್ರಾತಾ ಆನ್ದ್ರಿಯಶ್ಚ ಯಾಕೂಬ್ ಯೋಹನ್ ಚ ಫಿಲಿಪ್ ಬರ್ಥಲಮಯಶ್ಚ ");
INSERT INTO sankan_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ಮಥಿಃ ಥೋಮಾ ಆಲ್ಫೀಯಸ್ಯ ಪುತ್ರೋ ಯಾಕೂಬ್ ಜ್ವಲನ್ತನಾಮ್ನಾ ಖ್ಯಾತಃ ಶಿಮೋನ್ ");
INSERT INTO sankan_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ಚ ಯಾಕೂಬೋ ಭ್ರಾತಾ ಯಿಹೂದಾಶ್ಚ ತಂ ಯಃ ಪರಕರೇಷು ಸಮರ್ಪಯಿಷ್ಯತಿ ಸ ಈಷ್ಕರೀಯೋತೀಯಯಿಹೂದಾಶ್ಚೈತಾನ್ ದ್ವಾದಶ ಜನಾನ್ ಮನೋನೀತಾನ್ ಕೃತ್ವಾ ಸ ಜಗ್ರಾಹ ತಥಾ ಪ್ರೇರಿತ ಇತಿ ತೇಷಾಂ ನಾಮ ಚಕಾರ| ");
INSERT INTO sankan_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","ತತಃ ಪರಂ ಸ ತೈಃ ಸಹ ಪರ್ವ್ವತಾದವರುಹ್ಯ ಉಪತ್ಯಕಾಯಾಂ ತಸ್ಥೌ ತತಸ್ತಸ್ಯ ಶಿಷ್ಯಸಙ್ಘೋ ಯಿಹೂದಾದೇಶಾದ್ ಯಿರೂಶಾಲಮಶ್ಚ ಸೋರಃ ಸೀದೋನಶ್ಚ ಜಲಧೇ ರೋಧಸೋ ಜನನಿಹಾಶ್ಚ ಏತ್ಯ ತಸ್ಯ ಕಥಾಶ್ರವಣಾರ್ಥಂ ರೋಗಮುಕ್ತ್ಯರ್ಥಞ್ಚ ತಸ್ಯ ಸಮೀಪೇ ತಸ್ಥುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ಅಮೇಧ್ಯಭೂತಗ್ರಸ್ತಾಶ್ಚ ತನ್ನಿಕಟಮಾಗತ್ಯ ಸ್ವಾಸ್ಥ್ಯಂ ಪ್ರಾಪುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ಸರ್ವ್ವೇಷಾಂ ಸ್ವಾಸ್ಥ್ಯಕರಣಪ್ರಭಾವಸ್ಯ ಪ್ರಕಾಶಿತತ್ವಾತ್ ಸರ್ವ್ವೇ ಲೋಕಾ ಏತ್ಯ ತಂ ಸ್ಪ್ರಷ್ಟುಂ ಯೇತಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","ಪಶ್ಚಾತ್ ಸ ಶಿಷ್ಯಾನ್ ಪ್ರತಿ ದೃಷ್ಟಿಂ ಕುತ್ವಾ ಜಗಾದ, ಹೇ ದರಿದ್ರಾ ಯೂಯಂ ಧನ್ಯಾ ಯತ ಈಶ್ವರೀಯೇ ರಾಜ್ಯೇ ವೋಽಧಿಕಾರೋಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ಹೇ ಅಧುನಾ ಕ್ಷುಧಿತಲೋಕಾ ಯೂಯಂ ಧನ್ಯಾ ಯತೋ ಯೂಯಂ ತರ್ಪ್ಸ್ಯಥ; ಹೇ ಇಹ ರೋದಿನೋ ಜನಾ ಯೂಯಂ ಧನ್ಯಾ ಯತೋ ಯೂಯಂ ಹಸಿಷ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","ಯದಾ ಲೋಕಾ ಮನುಷ್ಯಸೂನೋ ರ್ನಾಮಹೇತೋ ರ್ಯುಷ್ಮಾನ್ ಋृತೀಯಿಷ್ಯನ್ತೇ ಪೃಥಕ್ ಕೃತ್ವಾ ನಿನ್ದಿಷ್ಯನ್ತಿ, ಅಧಮಾನಿವ ಯುಷ್ಮಾನ್ ಸ್ವಸಮೀಪಾದ್ ದೂರೀಕರಿಷ್ಯನ್ತಿ ಚ ತದಾ ಯೂಯಂ ಧನ್ಯಾಃ| ");
INSERT INTO sankan_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ಸ್ವರ್ಗೇ ಯುಷ್ಮಾಕಂ ಯಥೇಷ್ಟಂ ಫಲಂ ಭವಿಷ್ಯತಿ, ಏತದರ್ಥಂ ತಸ್ಮಿನ್ ದಿನೇ ಪ್ರೋಲ್ಲಸತ ಆನನ್ದೇನ ನೃತ್ಯತ ಚ, ತೇಷಾಂ ಪೂರ್ವ್ವಪುರುಷಾಶ್ಚ ಭವಿಷ್ಯದ್ವಾದಿನಃ ಪ್ರತಿ ತಥೈವ ವ್ಯವಾಹರನ್| ");
INSERT INTO sankan_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","ಕಿನ್ತು ಹಾ ಹಾ ಧನವನ್ತೋ ಯೂಯಂ ಸುಖಂ ಪ್ರಾಪ್ನುತ| ಹನ್ತ ಪರಿತೃಪ್ತಾ ಯೂಯಂ ಕ್ಷುಧಿತಾ ಭವಿಷ್ಯಥ; ");
INSERT INTO sankan_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ಇಹ ಹಸನ್ತೋ ಯೂಯಂ ವತ ಯುಷ್ಮಾಭಿಃ ಶೋಚಿತವ್ಯಂ ರೋದಿತವ್ಯಞ್ಚ| ");
INSERT INTO sankan_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","ಸರ್ವ್ವೈಲಾಕೈ ರ್ಯುಷ್ಮಾಕಂ ಸುಖ್ಯಾತೌ ಕೃತಾಯಾಂ ಯುಷ್ಮಾಕಂ ದುರ್ಗತಿ ರ್ಭವಿಷ್ಯತಿ ಯುಷ್ಮಾಕಂ ಪೂರ್ವ್ವಪುರುಷಾ ಮೃಷಾಭವಿಷ್ಯದ್ವಾದಿನಃ ಪ್ರತಿ ತದ್ವತ್ ಕೃತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","ಹೇ ಶ್ರೋತಾರೋ ಯುಷ್ಮಭ್ಯಮಹಂ ಕಥಯಾಮಿ, ಯೂಯಂ ಶತ್ರುಷು ಪ್ರೀಯಧ್ವಂ ಯೇ ಚ ಯುಷ್ಮಾನ್ ದ್ವಿಷನ್ತಿ ತೇಷಾಮಪಿ ಹಿತಂ ಕುರುತ| ");
INSERT INTO sankan_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ಯೇ ಚ ಯುಷ್ಮಾನ್ ಶಪನ್ತಿ ತೇಭ್ಯ ಆಶಿಷಂ ದತ್ತ ಯೇ ಚ ಯುಷ್ಮಾನ್ ಅವಮನ್ಯನ್ತೇ ತೇಷಾಂ ಮಙ್ಗಲಂ ಪ್ರಾರ್ಥಯಧ್ವಂ| ");
INSERT INTO sankan_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","ಯದಿ ಕಶ್ಚಿತ್ ತವ ಕಪೋಲೇ ಚಪೇಟಾಘಾತಂ ಕರೋತಿ ತರ್ಹಿ ತಂ ಪ್ರತಿ ಕಪೋಲಮ್ ಅನ್ಯಂ ಪರಾವರ್ತ್ತ್ಯ ಸಮ್ಮುಖೀಕುರು ಪುನಶ್ಚ ಯದಿ ಕಶ್ಚಿತ್ ತವ ಗಾತ್ರೀಯವಸ್ತ್ರಂ ಹರತಿ ತರ್ಹಿ ತಂ ಪರಿಧೇಯವಸ್ತ್ರಮ್ ಅಪಿ ಗ್ರಹೀತುಂ ಮಾ ವಾರಯ| ");
INSERT INTO sankan_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ಯಸ್ತ್ವಾಂ ಯಾಚತೇ ತಸ್ಮೈ ದೇಹಿ, ಯಶ್ಚ ತವ ಸಮ್ಪತ್ತಿಂ ಹರತಿ ತಂ ಮಾ ಯಾಚಸ್ವ| ");
INSERT INTO sankan_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","ಪರೇಭ್ಯಃ ಸ್ವಾನ್ ಪ್ರತಿ ಯಥಾಚರಣಮ್ ಅಪೇಕ್ಷಧ್ವೇ ಪರಾನ್ ಪ್ರತಿ ಯೂಯಮಪಿ ತಥಾಚರತ| ");
INSERT INTO sankan_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","ಯೇ ಜನಾ ಯುಷ್ಮಾಸು ಪ್ರೀಯನ್ತೇ ಕೇವಲಂ ತೇಷು ಪ್ರೀಯಮಾಣೇಷು ಯುಷ್ಮಾಕಂ ಕಿಂ ಫಲಂ? ಪಾಪಿಲೋಕಾ ಅಪಿ ಸ್ವೇಷು ಪ್ರೀಯಮಾಣೇಷು ಪ್ರೀಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","ಯದಿ ಹಿತಕಾರಿಣ ಏವ ಹಿತಂ ಕುರುಥ ತರ್ಹಿ ಯುಷ್ಮಾಕಂ ಕಿಂ ಫಲಂ? ಪಾಪಿಲೋಕಾ ಅಪಿ ತಥಾ ಕುರ್ವ್ವನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","ಯೇಭ್ಯ ಋಣಪರಿಶೋಧಸ್ಯ ಪ್ರಾಪ್ತಿಪ್ರತ್ಯಾಶಾಸ್ತೇ ಕೇವಲಂ ತೇಷು ಋಣೇ ಸಮರ್ಪಿತೇ ಯುಷ್ಮಾಕಂ ಕಿಂ ಫಲಂ? ಪುನಃ ಪ್ರಾಪ್ತ್ಯಾಶಯಾ ಪಾಪೀಲೋಕಾ ಅಪಿ ಪಾಪಿಜನೇಷು ಋಣಮ್ ಅರ್ಪಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","ಅತೋ ಯೂಯಂ ರಿಪುಷ್ವಪಿ ಪ್ರೀಯಧ್ವಂ, ಪರಹಿತಂ ಕುರುತ ಚ; ಪುನಃ ಪ್ರಾಪ್ತ್ಯಾಶಾಂ ತ್ಯಕ್ತ್ವಾ ಋಣಮರ್ಪಯತ, ತಥಾ ಕೃತೇ ಯುಷ್ಮಾಕಂ ಮಹಾಫಲಂ ಭವಿಷ್ಯತಿ, ಯೂಯಞ್ಚ ಸರ್ವ್ವಪ್ರಧಾನಸ್ಯ ಸನ್ತಾನಾ ಇತಿ ಖ್ಯಾತಿಂ ಪ್ರಾಪ್ಸ್ಯಥ, ಯತೋ ಯುಷ್ಮಾಕಂ ಪಿತಾ ಕೃತಘ್ನಾನಾಂ ದುರ್ವ್ಟತ್ತಾನಾಞ್ಚ ಹಿತಮಾಚರತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ಅತ ಏವ ಸ ಯಥಾ ದಯಾಲು ರ್ಯೂಯಮಪಿ ತಾದೃಶಾ ದಯಾಲವೋ ಭವತ| ");
INSERT INTO sankan_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","ಅಪರಞ್ಚ ಪರಾನ್ ದೋಷಿಣೋ ಮಾ ಕುರುತ ತಸ್ಮಾದ್ ಯೂಯಂ ದೋಷೀಕೃತಾ ನ ಭವಿಷ್ಯಥ; ಅದಣ್ಡ್ಯಾನ್ ಮಾ ದಣ್ಡಯತ ತಸ್ಮಾದ್ ಯೂಯಮಪಿ ದಣ್ಡಂ ನ ಪ್ರಾಪ್ಸ್ಯಥ; ಪರೇಷಾಂ ದೋಷಾನ್ ಕ್ಷಮಧ್ವಂ ತಸ್ಮಾದ್ ಯುಷ್ಮಾಕಮಪಿ ದೋಷಾಃ ಕ್ಷಮಿಷ್ಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","ದಾನಾನಿದತ್ತ ತಸ್ಮಾದ್ ಯೂಯಂ ದಾನಾನಿ ಪ್ರಾಪ್ಸ್ಯಥ, ವರಞ್ಚ ಲೋಕಾಃ ಪರಿಮಾಣಪಾತ್ರಂ ಪ್ರದಲಯ್ಯ ಸಞ್ಚಾಲ್ಯ ಪ್ರೋಞ್ಚಾಲ್ಯ ಪರಿಪೂರ್ಯ್ಯ ಯುಷ್ಮಾಕಂ ಕ್ರೋಡೇಷು ಸಮರ್ಪಯಿಷ್ಯನ್ತಿ; ಯೂಯಂ ಯೇನ ಪರಿಮಾಣೇನ ಪರಿಮಾಥ ತೇನೈವ ಪರಿಮಾಣೇನ ಯುಷ್ಮತ್ಕೃತೇ ಪರಿಮಾಸ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ಅಥ ಸ ತೇಭ್ಯೋ ದೃಷ್ಟಾನ್ತಕಥಾಮಕಥಯತ್, ಅನ್ಧೋ ಜನಃ ಕಿಮನ್ಧಂ ಪನ್ಥಾನಂ ದರ್ಶಯಿತುಂ ಶಕ್ನೋತಿ? ತಸ್ಮಾದ್ ಉಭಾವಪಿ ಕಿಂ ಗರ್ತ್ತೇ ನ ಪತಿಷ್ಯತಃ? ");
INSERT INTO sankan_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ಗುರೋಃ ಶಿಷ್ಯೋ ನ ಶ್ರೇಷ್ಠಃ ಕಿನ್ತು ಶಿಷ್ಯೇ ಸಿದ್ಧೇ ಸತಿ ಸ ಗುರುತುಲ್ಯೋ ಭವಿತುಂ ಶಕ್ನೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","ಅಪರಞ್ಚ ತ್ವಂ ಸ್ವಚಕ್ಷುुಷಿ ನಾಸಾಮ್ ಅದೃಷ್ಟ್ವಾ ತವ ಭ್ರಾತುಶ್ಚಕ್ಷುಷಿ ಯತ್ತೃಣಮಸ್ತಿ ತದೇವ ಕುತಃ ಪಶ್ಯಮಿ? ");
INSERT INTO sankan_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","ಸ್ವಚಕ್ಷುಷಿ ಯಾ ನಾಸಾ ವಿದ್ಯತೇ ತಾಮ್ ಅಜ್ಞಾತ್ವಾ, ಭ್ರಾತಸ್ತವ ನೇತ್ರಾತ್ ತೃಣಂ ಬಹಿಃ ಕರೋಮೀತಿ ವಾಕ್ಯಂ ಭ್ರಾತರಂ ಕಥಂ ವಕ್ತುಂ ಶಕ್ನೋಷಿ? ಹೇ ಕಪಟಿನ್ ಪೂರ್ವ್ವಂ ಸ್ವನಯನಾತ್ ನಾಸಾಂ ಬಹಿಃ ಕುರು ತತೋ ಭ್ರಾತುಶ್ಚಕ್ಷುಷಸ್ತೃಣಂ ಬಹಿಃ ಕರ್ತ್ತುಂ ಸುದೃಷ್ಟಿಂ ಪ್ರಾಪ್ಸ್ಯಸಿ| ");
INSERT INTO sankan_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","ಅನ್ಯಞ್ಚ ಉತ್ತಮಸ್ತರುಃ ಕದಾಪಿ ಫಲಮನುತ್ತಮಂ ನ ಫಲತಿ, ಅನುತ್ತಮತರುಶ್ಚ ಫಲಮುತ್ತಮಂ ನ ಫಲತಿ ಕಾರಣಾದತಃ ಫಲೈಸ್ತರವೋ ಜ್ಞಾಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","ಕಣ್ಟಕಿಪಾದಪಾತ್ ಕೋಪಿ ಉಡುಮ್ಬರಫಲಾನಿ ನ ಪಾತಯತಿ ತಥಾ ಶೃಗಾಲಕೋಲಿವೃಕ್ಷಾದಪಿ ಕೋಪಿ ದ್ರಾಕ್ಷಾಫಲಂ ನ ಪಾತಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","ತದ್ವತ್ ಸಾಧುಲೋಕೋಽನ್ತಃಕರಣರೂಪಾತ್ ಸುಭಾಣ್ಡಾಗಾರಾದ್ ಉತ್ತಮಾನಿ ದ್ರವ್ಯಾಣಿ ಬಹಿಃ ಕರೋತಿ, ದುಷ್ಟೋ ಲೋಕಶ್ಚಾನ್ತಃಕರಣರೂಪಾತ್ ಕುಭಾಣ್ಡಾಗಾರಾತ್ ಕುತ್ಸಿತಾನಿ ದ್ರವ್ಯಾಣಿ ನಿರ್ಗಮಯತಿ ಯತೋಽನ್ತಃಕರಣಾನಾಂ ಪೂರ್ಣಭಾವಾನುರೂಪಾಣಿ ವಚಾಂಸಿ ಮುಖಾನ್ನಿರ್ಗಚ್ಛನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","ಅಪರಞ್ಚ ಮಮಾಜ್ಞಾನುರೂಪಂ ನಾಚರಿತ್ವಾ ಕುತೋ ಮಾಂ ಪ್ರಭೋ ಪ್ರಭೋ ಇತಿ ವದಥ? ");
INSERT INTO sankan_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ಯಃ ಕಶ್ಚಿನ್ ಮಮ ನಿಕಟಮ್ ಆಗತ್ಯ ಮಮ ಕಥಾ ನಿಶಮ್ಯ ತದನುರೂಪಂ ಕರ್ಮ್ಮ ಕರೋತಿ ಸ ಕಸ್ಯ ಸದೃಶೋ ಭವತಿ ತದಹಂ ಯುಷ್ಮಾನ್ ಜ್ಞಾाಪಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ಯೋ ಜನೋ ಗಭೀರಂ ಖನಿತ್ವಾ ಪಾಷಾಣಸ್ಥಲೇ ಭಿತ್ತಿಂ ನಿರ್ಮ್ಮಾಯ ಸ್ವಗೃಹಂ ರಚಯತಿ ತೇನ ಸಹ ತಸ್ಯೋಪಮಾ ಭವತಿ; ಯತ ಆಪ್ಲಾವಿಜಲಮೇತ್ಯ ತಸ್ಯ ಮೂಲೇ ವೇಗೇನ ವಹದಪಿ ತದ್ಗೇಹಂ ಲಾಡಯಿತುಂ ನ ಶಕ್ನೋತಿ ಯತಸ್ತಸ್ಯ ಭಿತ್ತಿಃ ಪಾಷಾಣೋಪರಿ ತಿಷ್ಠತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","ಕಿನ್ತು ಯಃ ಕಶ್ಚಿನ್ ಮಮ ಕಥಾಃ ಶ್ರುತ್ವಾ ತದನುರೂಪಂ ನಾಚರತಿ ಸ ಭಿತ್ತಿಂ ವಿನಾ ಮೃृದುಪರಿ ಗೃಹನಿರ್ಮ್ಮಾತ್ರಾ ಸಮಾನೋ ಭವತಿ; ಯತ ಆಪ್ಲಾವಿಜಲಮಾಗತ್ಯ ವೇಗೇನ ಯದಾ ವಹತಿ ತದಾ ತದ್ಗೃಹಂ ಪತತಿ ತಸ್ಯ ಮಹತ್ ಪತನಂ ಜಾಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ತತಃ ಪರಂ ಸ ಲೋಕಾನಾಂ ಕರ್ಣಗೋಚರೇ ತಾನ್ ಸರ್ವ್ವಾನ್ ಉಪದೇಶಾನ್ ಸಮಾಪ್ಯ ಯದಾ ಕಫರ್ನಾಹೂಮ್ಪುರಂ ಪ್ರವಿಶತಿ ");
INSERT INTO sankan_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","ತದಾ ಶತಸೇನಾಪತೇಃ ಪ್ರಿಯದಾಸ ಏಕೋ ಮೃತಕಲ್ಪಃ ಪೀಡಿತ ಆಸೀತ್| ");
INSERT INTO sankan_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ಅತಃ ಸೇನಾಪತಿ ರ್ಯೀಶೋ ರ್ವಾರ್ತ್ತಾಂ ನಿಶಮ್ಯ ದಾಸಸ್ಯಾರೋಗ್ಯಕರಣಾಯ ತಸ್ಯಾಗಮನಾರ್ಥಂ ವಿನಯಕರಣಾಯ ಯಿಹೂದೀಯಾನ್ ಕಿಯತಃ ಪ್ರಾಚಃ ಪ್ರೇಷಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","ತೇ ಯೀಶೋರನ್ತಿಕಂ ಗತ್ವಾ ವಿನಯಾತಿಶಯಂ ವಕ್ತುಮಾರೇಭಿರೇ, ಸ ಸೇನಾಪತಿ ರ್ಭವತೋನುಗ್ರಹಂ ಪ್ರಾಪ್ತುಮ್ ಅರ್ಹತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ಯತಃ ಸೋಸ್ಮಜ್ಜಾತೀಯೇಷು ಲೋಕೇಷು ಪ್ರೀಯತೇ ತಥಾಸ್ಮತ್ಕೃತೇ ಭಜನಗೇಹಂ ನಿರ್ಮ್ಮಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ತಸ್ಮಾದ್ ಯೀಶುಸ್ತೈಃ ಸಹ ಗತ್ವಾ ನಿವೇಶನಸ್ಯ ಸಮೀಪಂ ಪ್ರಾಪ, ತದಾ ಸ ಶತಸೇನಾಪತಿ ರ್ವಕ್ಷ್ಯಮಾಣವಾಕ್ಯಂ ತಂ ವಕ್ತುಂ ಬನ್ಧೂನ್ ಪ್ರಾಹಿಣೋತ್| ಹೇ ಪ್ರಭೋ ಸ್ವಯಂ ಶ್ರಮೋ ನ ಕರ್ತ್ತವ್ಯೋ ಯದ್ ಭವತಾ ಮದ್ಗೇಹಮಧ್ಯೇ ಪಾದಾರ್ಪಣಂ ಕ್ರಿಯೇತ ತದಪ್ಯಹಂ ನಾರ್ಹಾಮಿ, ");
INSERT INTO sankan_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ಕಿಞ್ಚಾಹಂ ಭವತ್ಸಮೀಪಂ ಯಾತುಮಪಿ ನಾತ್ಮಾನಂ ಯೋಗ್ಯಂ ಬುದ್ಧವಾನ್, ತತೋ ಭವಾನ್ ವಾಕ್ಯಮಾತ್ರಂ ವದತು ತೇನೈವ ಮಮ ದಾಸಃ ಸ್ವಸ್ಥೋ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","ಯಸ್ಮಾದ್ ಅಹಂ ಪರಾಧೀನೋಪಿ ಮಮಾಧೀನಾ ಯಾಃ ಸೇನಾಃ ಸನ್ತಿ ತಾಸಾಮ್ ಏಕಜನಂ ಪ್ರತಿ ಯಾಹೀತಿ ಮಯಾ ಪ್ರೋಕ್ತೇ ಸ ಯಾತಿ; ತದನ್ಯಂ ಪ್ರತಿ ಆಯಾಹೀತಿ ಪ್ರೋಕ್ತೇ ಸ ಆಯಾತಿ; ತಥಾ ನಿಜದಾಸಂ ಪ್ರತಿ ಏತತ್ ಕುರ್ವ್ವಿತಿ ಪ್ರೋಕ್ತೇ ಸ ತದೇವ ಕರೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ಯೀಶುರಿದಂ ವಾಕ್ಯಂ ಶ್ರುತ್ವಾ ವಿಸ್ಮಯಂ ಯಯೌ, ಮುಖಂ ಪರಾವರ್ತ್ಯ ಪಶ್ಚಾದ್ವರ್ತ್ತಿನೋ ಲೋಕಾನ್ ಬಭಾಷೇ ಚ, ಯುಷ್ಮಾನಹಂ ವದಾಮಿ ಇಸ್ರಾಯೇಲೋ ವಂಶಮಧ್ಯೇಪಿ ವಿಶ್ವಾಸಮೀದೃಶಂ ನ ಪ್ರಾಪ್ನವಂ| ");
INSERT INTO sankan_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ತತಸ್ತೇ ಪ್ರೇಷಿತಾ ಗೃಹಂ ಗತ್ವಾ ತಂ ಪೀಡಿತಂ ದಾಸಂ ಸ್ವಸ್ಥಂ ದದೃಶುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","ಪರೇಽಹನಿ ಸ ನಾಯೀನಾಖ್ಯಂ ನಗರಂ ಜಗಾಮ ತಸ್ಯಾನೇಕೇ ಶಿಷ್ಯಾ ಅನ್ಯೇ ಚ ಲೋಕಾಸ್ತೇನ ಸಾರ್ದ್ಧಂ ಯಯುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ತೇಷು ತನ್ನಗರಸ್ಯ ದ್ವಾರಸನ್ನಿಧಿಂ ಪ್ರಾಪ್ತೇಷು ಕಿಯನ್ತೋ ಲೋಕಾ ಏಕಂ ಮೃತಮನುಜಂ ವಹನ್ತೋ ನಗರಸ್ಯ ಬಹಿರ್ಯಾನ್ತಿ, ಸ ತನ್ಮಾತುರೇಕಪುತ್ರಸ್ತನ್ಮಾತಾ ಚ ವಿಧವಾ; ತಯಾ ಸಾರ್ದ್ಧಂ ತನ್ನಗರೀಯಾ ಬಹವೋ ಲೋಕಾ ಆಸನ್| ");
INSERT INTO sankan_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ಪ್ರಭುಸ್ತಾಂ ವಿಲೋಕ್ಯ ಸಾನುಕಮ್ಪಃ ಕಥಯಾಮಾಸ, ಮಾ ರೋದೀಃ| ಸ ಸಮೀಪಮಿತ್ವಾ ಖಟ್ವಾಂ ಪಸ್ಪರ್ಶ ತಸ್ಮಾದ್ ವಾಹಕಾಃ ಸ್ಥಗಿತಾಸ್ತಮ್ಯುಃ; ");
INSERT INTO sankan_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ತದಾ ಸ ಉವಾಚ ಹೇ ಯುವಮನುಷ್ಯ ತ್ವಮುತ್ತಿಷ್ಠ, ತ್ವಾಮಹಮ್ ಆಜ್ಞಾಪಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","ತಸ್ಮಾತ್ ಸ ಮೃತೋ ಜನಸ್ತತ್ಕ್ಷಣಮುತ್ಥಾಯ ಕಥಾಂ ಪ್ರಕಥಿತಃ; ತತೋ ಯೀಶುಸ್ತಸ್ಯ ಮಾತರಿ ತಂ ಸಮರ್ಪಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","ತಸ್ಮಾತ್ ಸರ್ವ್ವೇ ಲೋಕಾಃ ಶಶಙ್ಕಿರೇ; ಏಕೋ ಮಹಾಭವಿಷ್ಯದ್ವಾದೀ ಮಧ್ಯೇಽಸ್ಮಾಕಮ್ ಸಮುದೈತ್, ಈಶ್ವರಶ್ಚ ಸ್ವಲೋಕಾನನ್ವಗೃಹ್ಲಾತ್ ಕಥಾಮಿಮಾಂ ಕಥಯಿತ್ವಾ ಈಶ್ವರಂ ಧನ್ಯಂ ಜಗದುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ತತಃ ಪರಂ ಸಮಸ್ತಂ ಯಿಹೂದಾದೇಶಂ ತಸ್ಯ ಚತುರ್ದಿಕ್ಸ್ಥದೇಶಞ್ಚ ತಸ್ಯೈತತ್ಕೀರ್ತ್ತಿ ರ್ವ್ಯಾನಶೇ| ");
INSERT INTO sankan_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ತತಃ ಪರಂ ಯೋಹನಃ ಶಿಷ್ಯೇಷು ತಂ ತದ್ವೃತ್ತಾನ್ತಂ ಜ್ಞಾಪಿತವತ್ಸು ");
INSERT INTO sankan_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ಸ ಸ್ವಶಿಷ್ಯಾಣಾಂ ದ್ವೌ ಜನಾವಾಹೂಯ ಯೀಶುಂ ಪ್ರತಿ ವಕ್ಷ್ಯಮಾಣಂ ವಾಕ್ಯಂ ವಕ್ತುಂ ಪ್ರೇಷಯಾಮಾಸ, ಯಸ್ಯಾಗಮನಮ್ ಅಪೇಕ್ಷ್ಯ ತಿಷ್ಠಾಮೋ ವಯಂ ಕಿಂ ಸ ಏವ ಜನಸ್ತ್ವಂ? ಕಿಂ ವಯಮನ್ಯಮಪೇಕ್ಷ್ಯ ಸ್ಥಾಸ್ಯಾಮಃ? ");
INSERT INTO sankan_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","ಪಶ್ಚಾತ್ತೌ ಮಾನವೌ ಗತ್ವಾ ಕಥಯಾಮಾಸತುಃ, ಯಸ್ಯಾಗಮನಮ್ ಅಪೇಕ್ಷ್ಯ ತಿಷ್ಠಾಮೋ ವಯಂ, ಕಿಂ ಸಏವ ಜನಸ್ತ್ವಂ? ಕಿಂ ವಯಮನ್ಯಮಪೇಕ್ಷ್ಯ ಸ್ಥಾಸ್ಯಾಮಃ? ಕಥಾಮಿಮಾಂ ತುಭ್ಯಂ ಕಥಯಿತುಂ ಯೋಹನ್ ಮಜ್ಜಕ ಆವಾಂ ಪ್ರೇಷಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ತಸ್ಮಿನ್ ದಣ್ಡೇ ಯೀಶೂರೋಗಿಣೋ ಮಹಾವ್ಯಾಧಿಮತೋ ದುಷ್ಟಭೂತಗ್ರಸ್ತಾಂಶ್ಚ ಬಹೂನ್ ಸ್ವಸ್ಥಾನ್ ಕೃತ್ವಾ, ಅನೇಕಾನ್ಧೇಭ್ಯಶ್ಚಕ್ಷುಂಷಿ ದತ್ತ್ವಾ ಪ್ರತ್ಯುವಾಚ, ");
INSERT INTO sankan_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ಯುವಾಂ ವ್ರಜತಮ್ ಅನ್ಧಾ ನೇತ್ರಾಣಿ ಖಞ್ಜಾಶ್ಚರಣಾನಿ ಚ ಪ್ರಾಪ್ನುವನ್ತಿ, ಕುಷ್ಠಿನಃ ಪರಿಷ್ಕ್ರಿಯನ್ತೇ, ಬಧಿರಾಃ ಶ್ರವಣಾನಿ ಮೃತಾಶ್ಚ ಜೀವನಾನಿ ಪ್ರಾಪ್ನುವನ್ತಿ, ದರಿದ್ರಾಣಾಂ ಸಮೀಪೇಷು ಸುಸಂವಾದಃ ಪ್ರಚಾರ್ಯ್ಯತೇ, ಯಂ ಪ್ರತಿ ವಿಘ್ನಸ್ವರೂಪೋಹಂ ನ ಭವಾಮಿ ಸ ಧನ್ಯಃ, ");
INSERT INTO sankan_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ಏತಾನಿ ಯಾನಿ ಪಶ್ಯಥಃ ಶೃಣುಥಶ್ಚ ತಾನಿ ಯೋಹನಂ ಜ್ಞಾಪಯತಮ್| ");
INSERT INTO sankan_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ತಯೋ ರ್ದೂತಯೋ ರ್ಗತಯೋಃ ಸತೋ ರ್ಯೋಹನಿ ಸ ಲೋಕಾನ್ ವಕ್ತುಮುಪಚಕ್ರಮೇ, ಯೂಯಂ ಮಧ್ಯೇಪ್ರಾನ್ತರಂ ಕಿಂ ದ್ರಷ್ಟುಂ ನಿರಗಮತ? ಕಿಂ ವಾಯುನಾ ಕಮ್ಪಿತಂ ನಡಂ? ");
INSERT INTO sankan_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ಯೂಯಂ ಕಿಂ ದ್ರಷ್ಟುಂ ನಿರಗಮತ? ಕಿಂ ಸೂಕ್ಷ್ಮವಸ್ತ್ರಪರಿಧಾಯಿನಂ ಕಮಪಿ ನರಂ? ಕಿನ್ತು ಯೇ ಸೂಕ್ಷ್ಮಮೃದುವಸ್ತ್ರಾಣಿ ಪರಿದಧತಿ ಸೂತ್ತಮಾನಿ ದ್ರವ್ಯಾಣಿ ಭುಞ್ಜತೇ ಚ ತೇ ರಾಜಧಾನೀಷು ತಿಷ್ಠನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ತರ್ಹಿ ಯೂಯಂ ಕಿಂ ದ್ರಷ್ಟುಂ ನಿರಗಮತ? ಕಿಮೇಕಂ ಭವಿಷ್ಯದ್ವಾದಿನಂ? ತದೇವ ಸತ್ಯಂ ಕಿನ್ತು ಸ ಪುಮಾನ್ ಭವಿಷ್ಯದ್ವಾದಿನೋಪಿ ಶ್ರೇಷ್ಠ ಇತ್ಯಹಂ ಯುಷ್ಮಾನ್ ವದಾಮಿ; ");
INSERT INTO sankan_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ಪಶ್ಯ ಸ್ವಕೀಯದೂತನ್ತು ತವಾಗ್ರ ಪ್ರೇಷಯಾಮ್ಯಹಂ| ಗತ್ವಾ ತ್ವದೀಯಮಾರ್ಗನ್ತು ಸ ಹಿ ಪರಿಷ್ಕರಿಷ್ಯತಿ| ಯದರ್ಥೇ ಲಿಪಿರಿಯಮ್ ಆಸ್ತೇ ಸ ಏವ ಯೋಹನ್| ");
INSERT INTO sankan_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","ಅತೋ ಯುಷ್ಮಾನಹಂ ವದಾಮಿ ಸ್ತ್ರಿಯಾ ಗರ್ಬ್ಭಜಾತಾನಾಂ ಭವಿಷ್ಯದ್ವಾದಿನಾಂ ಮಧ್ಯೇ ಯೋಹನೋ ಮಜ್ಜಕಾತ್ ಶ್ರೇಷ್ಠಃ ಕೋಪಿ ನಾಸ್ತಿ, ತತ್ರಾಪಿ ಈಶ್ವರಸ್ಯ ರಾಜ್ಯೇ ಯಃ ಸರ್ವ್ವಸ್ಮಾತ್ ಕ್ಷುದ್ರಃ ಸ ಯೋಹನೋಪಿ ಶ್ರೇಷ್ಠಃ| ");
INSERT INTO sankan_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","ಅಪರಞ್ಚ ಸರ್ವ್ವೇ ಲೋಕಾಃ ಕರಮಞ್ಚಾಯಿನಶ್ಚ ತಸ್ಯ ವಾಕ್ಯಾನಿ ಶ್ರುತ್ವಾ ಯೋಹನಾ ಮಜ್ಜನೇನ ಮಜ್ಜಿತಾಃ ಪರಮೇಶ್ವರಂ ನಿರ್ದೋಷಂ ಮೇನಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","ಕಿನ್ತು ಫಿರೂಶಿನೋ ವ್ಯವಸ್ಥಾಪಕಾಶ್ಚ ತೇನ ನ ಮಜ್ಜಿತಾಃ ಸ್ವಾನ್ ಪ್ರತೀಶ್ವರಸ್ಯೋಪದೇಶಂ ನಿಷ್ಫಲಮ್ ಅಕುರ್ವ್ವನ್| ");
INSERT INTO sankan_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","ಅಥ ಪ್ರಭುಃ ಕಥಯಾಮಾಸ, ಇದಾನೀನ್ತನಜನಾನ್ ಕೇನೋಪಮಾಮಿ? ತೇ ಕಸ್ಯ ಸದೃಶಾಃ? ");
INSERT INTO sankan_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ಯೇ ಬಾಲಕಾ ವಿಪಣ್ಯಾಮ್ ಉಪವಿಶ್ಯ ಪರಸ್ಪರಮ್ ಆಹೂಯ ವಾಕ್ಯಮಿದಂ ವದನ್ತಿ, ವಯಂ ಯುಷ್ಮಾಕಂ ನಿಕಟೇ ವಂಶೀರವಾದಿಷ್ಮ, ಕಿನ್ತು ಯೂಯಂ ನಾನರ್ತ್ತಿಷ್ಟ, ವಯಂ ಯುಷ್ಮಾಕಂ ನಿಕಟ ಅರೋದಿಷ್ಮ, ಕಿನ್ತು ಯುಯಂ ನ ವ್ಯಲಪಿಷ್ಟ, ಬಾಲಕೈರೇತಾದೃಶೈಸ್ತೇಷಾಮ್ ಉಪಮಾ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","ಯತೋ ಯೋಹನ್ ಮಜ್ಜಕ ಆಗತ್ಯ ಪೂಪಂ ನಾಖಾದತ್ ದ್ರಾಕ್ಷಾರಸಞ್ಚ ನಾಪಿವತ್ ತಸ್ಮಾದ್ ಯೂಯಂ ವದಥ, ಭೂತಗ್ರಸ್ತೋಯಮ್| ");
INSERT INTO sankan_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","ತತಃ ಪರಂ ಮಾನವಸುತ ಆಗತ್ಯಾಖಾದದಪಿವಞ್ಚ ತಸ್ಮಾದ್ ಯೂಯಂ ವದಥ, ಖಾದಕಃ ಸುರಾಪಶ್ಚಾಣ್ಡಾಲಪಾಪಿನಾಂ ಬನ್ಧುರೇಕೋ ಜನೋ ದೃಶ್ಯತಾಮ್| ");
INSERT INTO sankan_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","ಕಿನ್ತು ಜ್ಞಾನಿನೋ ಜ್ಞಾನಂ ನಿರ್ದೋಷಂ ವಿದುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ಪಶ್ಚಾದೇಕಃ ಫಿರೂಶೀ ಯೀಶುಂ ಭೋಜನಾಯ ನ್ಯಮನ್ತ್ರಯತ್ ತತಃ ಸ ತಸ್ಯ ಗೃಹಂ ಗತ್ವಾ ಭೋಕ್ತುಮುಪವಿಷ್ಟಃ| ");
INSERT INTO sankan_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ಏತರ್ಹಿ ತತ್ಫಿರೂಶಿನೋ ಗೃಹೇ ಯೀಶು ರ್ಭೇಕ್ತುಮ್ ಉಪಾವೇಕ್ಷೀತ್ ತಚ್ಛ್ರುತ್ವಾ ತನ್ನಗರವಾಸಿನೀ ಕಾಪಿ ದುಷ್ಟಾ ನಾರೀ ಪಾಣ್ಡರಪ್ರಸ್ತರಸ್ಯ ಸಮ್ಪುಟಕೇ ಸುಗನ್ಧಿತೈಲಮ್ ಆನೀಯ ");
INSERT INTO sankan_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ತಸ್ಯ ಪಶ್ಚಾತ್ ಪಾದಯೋಃ ಸನ್ನಿಧೌ ತಸ್ಯೌ ರುದತೀ ಚ ನೇತ್ರಾಮ್ಬುಭಿಸ್ತಸ್ಯ ಚರಣೌ ಪ್ರಕ್ಷಾಲ್ಯ ನಿಜಕಚೈರಮಾರ್ಕ್ಷೀತ್, ತತಸ್ತಸ್ಯ ಚರಣೌ ಚುಮ್ಬಿತ್ವಾ ತೇನ ಸುಗನ್ಧಿತೈಲೇನ ಮಮರ್ದ| ");
INSERT INTO sankan_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ತಸ್ಮಾತ್ ಸ ನಿಮನ್ತ್ರಯಿತಾ ಫಿರೂಶೀ ಮನಸಾ ಚಿನ್ತಯಾಮಾಸ, ಯದ್ಯಯಂ ಭವಿಷ್ಯದ್ವಾದೀ ಭವೇತ್ ತರ್ಹಿ ಏನಂ ಸ್ಪೃಶತಿ ಯಾ ಸ್ತ್ರೀ ಸಾ ಕಾ ಕೀದೃಶೀ ಚೇತಿ ಜ್ಞಾತುಂ ಶಕ್ನುಯಾತ್ ಯತಃ ಸಾ ದುಷ್ಟಾ| ");
INSERT INTO sankan_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ತದಾ ಯಾಶುಸ್ತಂ ಜಗಾದ, ಹೇ ಶಿಮೋನ್ ತ್ವಾಂ ಪ್ರತಿ ಮಮ ಕಿಞ್ಚಿದ್ ವಕ್ತವ್ಯಮಸ್ತಿ; ತಸ್ಮಾತ್ ಸ ಬಭಾಷೇ, ಹೇ ಗುರೋ ತದ್ ವದತು| ");
INSERT INTO sankan_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ಏಕೋತ್ತಮರ್ಣಸ್ಯ ದ್ವಾವಧಮರ್ಣಾವಾಸ್ತಾಂ, ತಯೋರೇಕಃ ಪಞ್ಚಶತಾನಿ ಮುದ್ರಾಪಾದಾನ್ ಅಪರಶ್ಚ ಪಞ್ಚಾಶತ್ ಮುದ್ರಾಪಾದಾನ್ ಧಾರಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","ತದನನ್ತರಂ ತಯೋಃ ಶೋಧ್ಯಾಭಾವಾತ್ ಸ ಉತ್ತಮರ್ಣಸ್ತಯೋ ರೃಣೇ ಚಕ್ಷಮೇ; ತಸ್ಮಾತ್ ತಯೋರ್ದ್ವಯೋಃ ಕಸ್ತಸ್ಮಿನ್ ಪ್ರೇಷ್ಯತೇ ಬಹು? ತದ್ ಬ್ರೂಹಿ| ");
INSERT INTO sankan_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ಶಿಮೋನ್ ಪ್ರತ್ಯುವಾಚ, ಮಯಾ ಬುಧ್ಯತೇ ಯಸ್ಯಾಧಿಕಮ್ ಋಣಂ ಚಕ್ಷಮೇ ಸ ಇತಿ; ತತೋ ಯೀಶುಸ್ತಂ ವ್ಯಾಜಹಾರ, ತ್ವಂ ಯಥಾರ್ಥಂ ವ್ಯಚಾರಯಃ| ");
INSERT INTO sankan_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ಅಥ ತಾಂ ನಾರೀಂ ಪ್ರತಿ ವ್ಯಾಘುಠ್ಯ ಶಿಮೋನಮವೋಚತ್, ಸ್ತ್ರೀಮಿಮಾಂ ಪಶ್ಯಸಿ? ತವ ಗೃಹೇ ಮಯ್ಯಾಗತೇ ತ್ವಂ ಪಾದಪ್ರಕ್ಷಾಲನಾರ್ಥಂ ಜಲಂ ನಾದಾಃ ಕಿನ್ತು ಯೋಷಿದೇಷಾ ನಯನಜಲೈ ರ್ಮಮ ಪಾದೌ ಪ್ರಕ್ಷಾಲ್ಯ ಕೇಶೈರಮಾರ್ಕ್ಷೀತ್| ");
INSERT INTO sankan_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ತ್ವಂ ಮಾಂ ನಾಚುಮ್ಬೀಃ ಕಿನ್ತು ಯೋಷಿದೇಷಾ ಸ್ವೀಯಾಗಮನಾದಾರಭ್ಯ ಮದೀಯಪಾದೌ ಚುಮ್ಬಿತುಂ ನ ವ್ಯರಂಸ್ತ| ");
INSERT INTO sankan_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ತ್ವಞ್ಚ ಮದೀಯೋತ್ತಮಾಙ್ಗೇ ಕಿಞ್ಚಿದಪಿ ತೈಲಂ ನಾಮರ್ದೀಃ ಕಿನ್ತು ಯೋಷಿದೇಷಾ ಮಮ ಚರಣೌ ಸುಗನ್ಧಿತೈಲೇನಾಮರ್ದ್ದೀತ್| ");
INSERT INTO sankan_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","ಅತಸ್ತ್ವಾಂ ವ್ಯಾಹರಾಮಿ, ಏತಸ್ಯಾ ಬಹು ಪಾಪಮಕ್ಷಮ್ಯತ ತತೋ ಬಹು ಪ್ರೀಯತೇ ಕಿನ್ತು ಯಸ್ಯಾಲ್ಪಪಾಪಂ ಕ್ಷಮ್ಯತೇ ಸೋಲ್ಪಂ ಪ್ರೀಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ತತಃ ಪರಂ ಸ ತಾಂ ಬಭಾಷೇ, ತ್ವದೀಯಂ ಪಾಪಮಕ್ಷಮ್ಯತ| ");
INSERT INTO sankan_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ತದಾ ತೇನ ಸಾರ್ದ್ಧಂ ಯೇ ಭೋಕ್ತುಮ್ ಉಪವಿವಿಶುಸ್ತೇ ಪರಸ್ಪರಂ ವಕ್ತುಮಾರೇಭಿರೇ, ಅಯಂ ಪಾಪಂ ಕ್ಷಮತೇ ಕ ಏಷಃ? ");
INSERT INTO sankan_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","ಕಿನ್ತು ಸ ತಾಂ ನಾರೀಂ ಜಗಾದ, ತವ ವಿಶ್ವಾಸಸ್ತ್ವಾಂ ಪರ್ಯ್ಯತ್ರಾಸ್ತ ತ್ವಂ ಕ್ಷೇಮೇಣ ವ್ರಜ| ");
INSERT INTO sankan_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ಅಪರಞ್ಚ ಯೀಶು ರ್ದ್ವಾದಶಭಿಃ ಶಿಷ್ಯೈಃ ಸಾರ್ದ್ಧಂ ನಾನಾನಗರೇಷು ನಾನಾಗ್ರಾಮೇಷು ಚ ಗಚ್ಛನ್ ಇಶ್ವರೀಯರಾಜತ್ವಸ್ಯ ಸುಸಂವಾದಂ ಪ್ರಚಾರಯಿತುಂ ಪ್ರಾರೇಭೇ| ");
INSERT INTO sankan_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ತದಾ ಯಸ್ಯಾಃ ಸಪ್ತ ಭೂತಾ ನಿರಗಚ್ಛನ್ ಸಾ ಮಗ್ದಲೀನೀತಿ ವಿಖ್ಯಾತಾ ಮರಿಯಮ್ ಹೇರೋದ್ರಾಜಸ್ಯ ಗೃಹಾಧಿಪತೇಃ ಹೋಷೇ ರ್ಭಾರ್ಯ್ಯಾ ಯೋಹನಾ ಶೂಶಾನಾ ");
INSERT INTO sankan_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ಪ್ರಭೃತಯೋ ಯಾ ಬಹ್ವ್ಯಃ ಸ್ತ್ರಿಯಃ ದುಷ್ಟಭೂತೇಭ್ಯೋ ರೋಗೇಭ್ಯಶ್ಚ ಮುಕ್ತಾಃ ಸತ್ಯೋ ನಿಜವಿಭೂತೀ ರ್ವ್ಯಯಿತ್ವಾ ತಮಸೇವನ್ತ, ತಾಃ ಸರ್ವ್ವಾಸ್ತೇನ ಸಾರ್ದ್ಧಮ್ ಆಸನ್| ");
INSERT INTO sankan_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","ಅನನ್ತರಂ ನಾನಾನಗರೇಭ್ಯೋ ಬಹವೋ ಲೋಕಾ ಆಗತ್ಯ ತಸ್ಯ ಸಮೀಪೇಽಮಿಲನ್, ತದಾ ಸ ತೇಭ್ಯ ಏಕಾಂ ದೃಷ್ಟಾನ್ತಕಥಾಂ ಕಥಯಾಮಾಸ| ಏಕಃ ಕೃಷೀಬಲೋ ಬೀಜಾನಿ ವಪ್ತುಂ ಬಹಿರ್ಜಗಾಮ, ");
INSERT INTO sankan_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","ತತೋ ವಪನಕಾಲೇ ಕತಿಪಯಾನಿ ಬೀಜಾನಿ ಮಾರ್ಗಪಾರ್ಶ್ವೇ ಪೇತುಃ, ತತಸ್ತಾನಿ ಪದತಲೈ ರ್ದಲಿತಾನಿ ಪಕ್ಷಿಭಿ ರ್ಭಕ್ಷಿತಾನಿ ಚ| ");
INSERT INTO sankan_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","ಕತಿಪಯಾನಿ ಬೀಜಾನಿ ಪಾಷಾಣಸ್ಥಲೇ ಪತಿತಾನಿ ಯದ್ಯಪಿ ತಾನ್ಯಙ್ಕುರಿತಾನಿ ತಥಾಪಿ ರಸಾಭಾವಾತ್ ಶುಶುಷುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","ಕತಿಪಯಾನಿ ಬೀಜಾನಿ ಕಣ್ಟಕಿವನಮಧ್ಯೇ ಪತಿತಾನಿ ತತಃ ಕಣ್ಟಕಿವನಾನಿ ಸಂವೃದ್ಧ್ಯ ತಾನಿ ಜಗ್ರಸುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","ತದನ್ಯಾನಿ ಕತಿಪಯಬೀಜಾನಿ ಚ ಭೂಮ್ಯಾಮುತ್ತಮಾಯಾಂ ಪೇತುಸ್ತತಸ್ತಾನ್ಯಙ್ಕುರಯಿತ್ವಾ ಶತಗುಣಾನಿ ಫಲಾನಿ ಫೇಲುಃ| ಸ ಇಮಾ ಕಥಾಂ ಕಥಯಿತ್ವಾ ಪ್ರೋಚ್ಚೈಃ ಪ್ರೋವಾಚ, ಯಸ್ಯ ಶ್ರೋತುಂ ಶ್ರೋತ್ರೇ ಸ್ತಃ ಸ ಶೃಣೋತು| ");
INSERT INTO sankan_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ತತಃ ಪರಂ ಶಿಷ್ಯಾಸ್ತಂ ಪಪ್ರಚ್ಛುರಸ್ಯ ದೃಷ್ಟಾನ್ತಸ್ಯ ಕಿಂ ತಾತ್ಪರ್ಯ್ಯಂ? ");
INSERT INTO sankan_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ತತಃ ಸ ವ್ಯಾಜಹಾರ, ಈಶ್ವರೀಯರಾಜ್ಯಸ್ಯ ಗುಹ್ಯಾನಿ ಜ್ಞಾತುಂ ಯುಷ್ಮಭ್ಯಮಧಿಕಾರೋ ದೀಯತೇ ಕಿನ್ತ್ವನ್ಯೇ ಯಥಾ ದೃಷ್ಟ್ವಾಪಿ ನ ಪಶ್ಯನ್ತಿ ಶ್ರುತ್ವಾಪಿ ಮ ಬುಧ್ಯನ್ತೇ ಚ ತದರ್ಥಂ ತೇಷಾಂ ಪುರಸ್ತಾತ್ ತಾಃ ಸರ್ವ್ವಾಃ ಕಥಾ ದೃಷ್ಟಾನ್ತೇನ ಕಥ್ಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","ದೃಷ್ಟಾನ್ತಸ್ಯಾಸ್ಯಾಭಿಪ್ರಾಯಃ, ಈಶ್ವರೀಯಕಥಾ ಬೀಜಸ್ವರೂಪಾ| ");
INSERT INTO sankan_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ಯೇ ಕಥಾಮಾತ್ರಂ ಶೃಣ್ವನ್ತಿ ಕಿನ್ತು ಪಶ್ಚಾದ್ ವಿಶ್ವಸ್ಯ ಯಥಾ ಪರಿತ್ರಾಣಂ ನ ಪ್ರಾಪ್ನುವನ್ತಿ ತದಾಶಯೇನ ಶೈತಾನೇತ್ಯ ಹೃದಯಾತೃ ತಾಂ ಕಥಾಮ್ ಅಪಹರತಿ ತ ಏವ ಮಾರ್ಗಪಾರ್ಶ್ವಸ್ಥಭೂಮಿಸ್ವರೂಪಾಃ| ");
INSERT INTO sankan_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ಯೇ ಕಥಂ ಶ್ರುತ್ವಾ ಸಾನನ್ದಂ ಗೃಹ್ಲನ್ತಿ ಕಿನ್ತ್ವಬದ್ಧಮೂಲತ್ವಾತ್ ಸ್ವಲ್ಪಕಾಲಮಾತ್ರಂ ಪ್ರತೀತ್ಯ ಪರೀಕ್ಷಾಕಾಲೇ ಭ್ರಶ್ಯನ್ತಿ ತಏವ ಪಾಷಾಣಭೂಮಿಸ್ವರೂಪಾಃ| ");
INSERT INTO sankan_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ಯೇ ಕಥಾಂ ಶ್ರುತ್ವಾ ಯಾನ್ತಿ ವಿಷಯಚಿನ್ತಾಯಾಂ ಧನಲೋಭೇನ ಏेಹಿಕಸುಖೇ ಚ ಮಜ್ಜನ್ತ ಉಪಯುಕ್ತಫಲಾನಿ ನ ಫಲನ್ತಿ ತ ಏವೋಪ್ತಬೀಜಕಣ್ಟಕಿಭೂಸ್ವರೂಪಾಃ| ");
INSERT INTO sankan_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","ಕಿನ್ತು ಯೇ ಶ್ರುತ್ವಾ ಸರಲೈಃ ಶುದ್ಧೈಶ್ಚಾನ್ತಃಕರಣೈಃ ಕಥಾಂ ಗೃಹ್ಲನ್ತಿ ಧೈರ್ಯ್ಯಮ್ ಅವಲಮ್ಬ್ಯ ಫಲಾನ್ಯುತ್ಪಾದಯನ್ತಿ ಚ ತ ಏವೋತ್ತಮಮೃತ್ಸ್ವರೂಪಾಃ| ");
INSERT INTO sankan_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","ಅಪರಞ್ಚ ಪ್ರದೀಪಂ ಪ್ರಜ್ವಾಲ್ಯ ಕೋಪಿ ಪಾತ್ರೇಣ ನಾಚ್ಛಾದಯತಿ ತಥಾ ಖಟ್ವಾಧೋಪಿ ನ ಸ್ಥಾಪಯತಿ, ಕಿನ್ತು ದೀಪಾಧಾರೋಪರ್ಯ್ಯೇವ ಸ್ಥಾಪಯತಿ, ತಸ್ಮಾತ್ ಪ್ರವೇಶಕಾ ದೀಪ್ತಿಂ ಪಶ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","ಯನ್ನ ಪ್ರಕಾಶಯಿಷ್ಯತೇ ತಾದೃಗ್ ಅಪ್ರಕಾಶಿತಂ ವಸ್ತು ಕಿಮಪಿ ನಾಸ್ತಿ ಯಚ್ಚ ನ ಸುವ್ಯಕ್ತಂ ಪ್ರಚಾರಯಿಷ್ಯತೇ ತಾದೃಗ್ ಗೃಪ್ತಂ ವಸ್ತು ಕಿಮಪಿ ನಾಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","ಅತೋ ಯೂಯಂ ಕೇನ ಪ್ರಕಾರೇಣ ಶೃಣುಥ ತತ್ರ ಸಾವಧಾನಾ ಭವತ, ಯಸ್ಯ ಸಮೀಪೇ ಬರ್ದ್ಧತೇ ತಸ್ಮೈ ಪುನರ್ದಾಸ್ಯತೇ ಕಿನ್ತು ಯಸ್ಯಾಶ್ರಯೇ ನ ಬರ್ದ್ಧತೇ ತಸ್ಯ ಯದ್ಯದಸ್ತಿ ತದಪಿ ತಸ್ಮಾತ್ ನೇಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ಅಪರಞ್ಚ ಯೀಶೋ ರ್ಮಾತಾ ಭ್ರಾತರಶ್ಚ ತಸ್ಯ ಸಮೀಪಂ ಜಿಗಮಿಷವಃ ");
INSERT INTO sankan_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","ಕಿನ್ತು ಜನತಾಸಮ್ಬಾಧಾತ್ ತತ್ಸನ್ನಿಧಿಂ ಪ್ರಾಪ್ತುಂ ನ ಶೇಕುಃ| ತತ್ಪಶ್ಚಾತ್ ತವ ಮಾತಾ ಭ್ರಾತರಶ್ಚ ತ್ವಾಂ ಸಾಕ್ಷಾತ್ ಚಿಕೀರ್ಷನ್ತೋ ಬಹಿಸ್ತಿಷ್ಠನತೀತಿ ವಾರ್ತ್ತಾಯಾಂ ತಸ್ಮೈ ಕಥಿತಾಯಾಂ ");
INSERT INTO sankan_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ಸ ಪ್ರತ್ಯುವಾಚ; ಯೇ ಜನಾ ಈಶ್ವರಸ್ಯ ಕಥಾಂ ಶ್ರುತ್ವಾ ತದನುರೂಪಮಾಚರನ್ತಿ ತಏವ ಮಮ ಮಾತಾ ಭ್ರಾತರಶ್ಚ| ");
INSERT INTO sankan_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","ಅನನ್ತರಂ ಏಕದಾ ಯೀಶುಃ ಶಿಷ್ಯೈಃ ಸಾರ್ದ್ಧಂ ನಾವಮಾರುಹ್ಯ ಜಗಾದ, ಆಯಾತ ವಯಂ ಹ್ರದಸ್ಯ ಪಾರಂ ಯಾಮಃ, ತತಸ್ತೇ ಜಗ್ಮುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ತೇಷು ನೌಕಾಂ ವಾಹಯತ್ಸು ಸ ನಿದದ್ರೌ; ");
INSERT INTO sankan_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ಅಥಾಕಸ್ಮಾತ್ ಪ್ರಬಲಝಞ್ಭ್ಶಗಮಾದ್ ಹ್ರದೇ ನೌಕಾಯಾಂ ತರಙ್ಗೈರಾಚ್ಛನ್ನಾಯಾಂ ವಿಪತ್ ತಾನ್ ಜಗ್ರಾಸ| ತಸ್ಮಾದ್ ಯೀಶೋರನ್ತಿಕಂ ಗತ್ವಾ ಹೇ ಗುರೋ ಹೇ ಗುರೋ ಪ್ರಾಣಾ ನೋ ಯಾನ್ತೀತಿ ಗದಿತ್ವಾ ತಂ ಜಾಗರಯಾಮ್ಬಭೂವುಃ| ತದಾ ಸ ಉತ್ಥಾಯ ವಾಯುಂ ತರಙ್ಗಾಂಶ್ಚ ತರ್ಜಯಾಮಾಸ ತಸ್ಮಾದುಭೌ ನಿವೃತ್ಯ ಸ್ಥಿರೌ ಬಭೂವತುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ಸ ತಾನ್ ಬಭಾಷೇ ಯುಷ್ಮಾಕಂ ವಿಶ್ವಾಸಃ ಕ? ತಸ್ಮಾತ್ತೇ ಭೀತಾ ವಿಸ್ಮಿತಾಶ್ಚ ಪರಸ್ಪರಂ ಜಗದುಃ, ಅಹೋ ಕೀದೃಗಯಂ ಮನುಜಃ ಪವನಂ ಪಾನೀಯಞ್ಚಾದಿಶತಿ ತದುಭಯಂ ತದಾದೇಶಂ ವಹತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ತತಃ ಪರಂ ಗಾಲೀಲ್ಪ್ರದೇಶಸ್ಯ ಸಮ್ಮುಖಸ್ಥಗಿದೇರೀಯಪ್ರದೇಶೇ ನೌಕಾಯಾಂ ಲಗನ್ತ್ಯಾಂ ತಟೇಽವರೋಹಮಾವಾದ್ ");
INSERT INTO sankan_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ಬಹುತಿಥಕಾಲಂ ಭೂತಗ್ರಸ್ತ ಏಕೋ ಮಾನುಷಃ ಪುರಾದಾಗತ್ಯ ತಂ ಸಾಕ್ಷಾಚ್ಚಕಾರ| ಸ ಮನುಷೋ ವಾಸೋ ನ ಪರಿದಧತ್ ಗೃಹೇ ಚ ನ ವಸನ್ ಕೇವಲಂ ಶ್ಮಶಾನಮ್ ಅಧ್ಯುವಾಸ| ");
INSERT INTO sankan_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ಸ ಯೀಶುಂ ದೃಷ್ಟ್ವೈವ ಚೀಚ್ಛಬ್ದಂ ಚಕಾರ ತಸ್ಯ ಸಮ್ಮುಖೇ ಪತಿತ್ವಾ ಪ್ರೋಚ್ಚೈರ್ಜಗಾದ ಚ, ಹೇ ಸರ್ವ್ವಪ್ರಧಾನೇಶ್ವರಸ್ಯ ಪುತ್ರ, ಮಯಾ ಸಹ ತವ ಕಃ ಸಮ್ಬನ್ಧಃ? ತ್ವಯಿ ವಿನಯಂ ಕರೋಮಿ ಮಾಂ ಮಾ ಯಾತಯ| ");
INSERT INTO sankan_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","ಯತಃ ಸ ತಂ ಮಾನುಷಂ ತ್ಯಕ್ತ್ವಾ ಯಾತುಮ್ ಅಮೇಧ್ಯಭೂತಮ್ ಆದಿದೇಶ; ಸ ಭೂತಸ್ತಂ ಮಾನುಷಮ್ ಅಸಕೃದ್ ದಧಾರ ತಸ್ಮಾಲ್ಲೋಕಾಃ ಶೃಙ್ಖಲೇನ ನಿಗಡೇನ ಚ ಬಬನ್ಧುಃ; ಸ ತದ್ ಭಂಕ್ತ್ವಾ ಭೂತವಶತ್ವಾತ್ ಮಧ್ಯೇಪ್ರಾನ್ತರಂ ಯಯೌ| ");
INSERT INTO sankan_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","ಅನನ್ತರಂ ಯೀಶುಸ್ತಂ ಪಪ್ರಚ್ಛ ತವ ಕಿನ್ನಾಮ? ಸ ಉವಾಚ, ಮಮ ನಾಮ ಬಾಹಿನೋ ಯತೋ ಬಹವೋ ಭೂತಾಸ್ತಮಾಶಿಶ್ರಿಯುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","ಅಥ ಭೂತಾ ವಿನಯೇನ ಜಗದುಃ, ಗಭೀರಂ ಗರ್ತ್ತಂ ಗನ್ತುಂ ಮಾಜ್ಞಾಪಯಾಸ್ಮಾನ್| ");
INSERT INTO sankan_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ತದಾ ಪರ್ವ್ವತೋಪರಿ ವರಾಹವ್ರಜಶ್ಚರತಿ ತಸ್ಮಾದ್ ಭೂತಾ ವಿನಯೇನ ಪ್ರೋಚುಃ, ಅಮುಂ ವರಾಹವ್ರಜಮ್ ಆಶ್ರಯಿತುಮ್ ಅಸ್ಮಾನ್ ಅನುಜಾನೀಹಿ; ತತಃ ಸೋನುಜಜ್ಞೌ| ");
INSERT INTO sankan_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ತತಃ ಪರಂ ಭೂತಾಸ್ತಂ ಮಾನುಷಂ ವಿಹಾಯ ವರಾಹವ್ರಜಮ್ ಆಶಿಶ್ರಿಯುಃ ವರಾಹವ್ರಜಾಶ್ಚ ತತ್ಕ್ಷಣಾತ್ ಕಟಕೇನ ಧಾವನ್ತೋ ಹ್ರದೇ ಪ್ರಾಣಾನ್ ವಿಜೃಹುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ತದ್ ದೃಷ್ಟ್ವಾ ಶೂಕರರಕ್ಷಕಾಃ ಪಲಾಯಮಾನಾ ನಗರಂ ಗ್ರಾಮಞ್ಚ ಗತ್ವಾ ತತ್ಸರ್ವ್ವವೃತ್ತಾನ್ತಂ ಕಥಯಾಮಾಸುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","ತತಃ ಕಿಂ ವೃತ್ತಮ್ ಏತದ್ದರ್ಶನಾರ್ಥಂ ಲೋಕಾ ನಿರ್ಗತ್ಯ ಯೀಶೋಃ ಸಮೀಪಂ ಯಯುಃ, ತಂ ಮಾನುಷಂ ತ್ಯಕ್ತಭೂತಂ ಪರಿಹಿತವಸ್ತ್ರಂ ಸ್ವಸ್ಥಮಾನುಷವದ್ ಯೀಶೋಶ್ಚರಣಸನ್ನಿಧೌ ಸೂಪವಿಶನ್ತಂ ವಿಲೋಕ್ಯ ಬಿಭ್ಯುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ಯೇ ಲೋಕಾಸ್ತಸ್ಯ ಭೂತಗ್ರಸ್ತಸ್ಯ ಸ್ವಾಸ್ಥ್ಯಕರಣಂ ದದೃಶುಸ್ತೇ ತೇಭ್ಯಃ ಸರ್ವ್ವವೃತ್ತಾನ್ತಂ ಕಥಯಾಮಾಸುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ತದನನ್ತರಂ ತಸ್ಯ ಗಿದೇರೀಯಪ್ರದೇಶಸ್ಯ ಚತುರ್ದಿಕ್ಸ್ಥಾ ಬಹವೋ ಜನಾ ಅತಿತ್ರಸ್ತಾ ವಿನಯೇನ ತಂ ಜಗದುಃ, ಭವಾನ್ ಅಸ್ಮಾಕಂ ನಿಕಟಾದ್ ವ್ರಜತು ತಸ್ಮಾತ್ ಸ ನಾವಮಾರುಹ್ಯ ತತೋ ವ್ಯಾಘುಟ್ಯ ಜಗಾಮ| ");
INSERT INTO sankan_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ತದಾನೀಂ ತ್ಯಕ್ತಭೂತಮನುಜಸ್ತೇನ ಸಹ ಸ್ಥಾತುಂ ಪ್ರಾರ್ಥಯಾಞ್ಚಕ್ರೇ ");
INSERT INTO sankan_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","ಕಿನ್ತು ತದರ್ಥಮ್ ಈಶ್ವರಃ ಕೀದೃಙ್ಮಹಾಕರ್ಮ್ಮ ಕೃತವಾನ್ ಇತಿ ನಿವೇಶನಂ ಗತ್ವಾ ವಿಜ್ಞಾಪಯ, ಯೀಶುಃ ಕಥಾಮೇತಾಂ ಕಥಯಿತ್ವಾ ತಂ ವಿಸಸರ್ಜ| ತತಃ ಸ ವ್ರಜಿತ್ವಾ ಯೀಶುಸ್ತದರ್ಥಂ ಯನ್ಮಹಾಕರ್ಮ್ಮ ಚಕಾರ ತತ್ ಪುರಸ್ಯ ಸರ್ವ್ವತ್ರ ಪ್ರಕಾಶಯಿತುಂ ಪ್ರಾರೇಭೇ| ");
INSERT INTO sankan_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","ಅಥ ಯೀಶೌ ಪರಾವೃತ್ಯಾಗತೇ ಲೋಕಾಸ್ತಂ ಆದರೇಣ ಜಗೃಹು ರ್ಯಸ್ಮಾತ್ತೇ ಸರ್ವ್ವೇ ತಮಪೇಕ್ಷಾಞ್ಚಕ್ರಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","ತದನನ್ತರಂ ಯಾಯೀರ್ನಾಮ್ನೋ ಭಜನಗೇಹಸ್ಯೈಕೋಧಿಪ ಆಗತ್ಯ ಯೀಶೋಶ್ಚರಣಯೋಃ ಪತಿತ್ವಾ ಸ್ವನಿವೇಶನಾಗಮನಾರ್ಥಂ ತಸ್ಮಿನ್ ವಿನಯಂ ಚಕಾರ, ");
INSERT INTO sankan_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ಯತಸ್ತಸ್ಯ ದ್ವಾದಶವರ್ಷವಯಸ್ಕಾ ಕನ್ಯೈಕಾಸೀತ್ ಸಾ ಮೃತಕಲ್ಪಾಭವತ್| ತತಸ್ತಸ್ಯ ಗಮನಕಾಲೇ ಮಾರ್ಗೇ ಲೋಕಾನಾಂ ಮಹಾನ್ ಸಮಾಗಮೋ ಬಭೂವ| ");
INSERT INTO sankan_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ದ್ವಾದಶವರ್ಷಾಣಿ ಪ್ರದರರೋಗಗ್ರಸ್ತಾ ನಾನಾ ವೈದ್ಯೈಶ್ಚಿಕಿತ್ಸಿತಾ ಸರ್ವ್ವಸ್ವಂ ವ್ಯಯಿತ್ವಾಪಿ ಸ್ವಾಸ್ಥ್ಯಂ ನ ಪ್ರಾಪ್ತಾ ಯಾ ಯೋಷಿತ್ ಸಾ ಯೀಶೋಃ ಪಶ್ಚಾದಾಗತ್ಯ ತಸ್ಯ ವಸ್ತ್ರಗ್ರನ್ಥಿಂ ಪಸ್ಪರ್ಶ| ");
INSERT INTO sankan_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ತಸ್ಮಾತ್ ತತ್ಕ್ಷಣಾತ್ ತಸ್ಯಾ ರಕ್ತಸ್ರಾವೋ ರುದ್ಧಃ| ");
INSERT INTO sankan_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ತದಾನೀಂ ಯೀಶುರವದತ್ ಕೇನಾಹಂ ಸ್ಪೃಷ್ಟಃ? ತತೋಽನೇಕೈರನಙ್ಗೀಕೃತೇ ಪಿತರಸ್ತಸ್ಯ ಸಙ್ಗಿನಶ್ಚಾವದನ್, ಹೇ ಗುರೋ ಲೋಕಾ ನಿಕಟಸ್ಥಾಃ ಸನ್ತಸ್ತವ ದೇಹೇ ಘರ್ಷಯನ್ತಿ, ತಥಾಪಿ ಕೇನಾಹಂ ಸ್ಪೃಷ್ಟಇತಿ ಭವಾನ್ ಕುತಃ ಪೃಚ್ಛತಿ? ");
INSERT INTO sankan_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","ಯೀಶುಃ ಕಥಯಾಮಾಸ, ಕೇನಾಪ್ಯಹಂ ಸ್ಪೃಷ್ಟೋ, ಯತೋ ಮತ್ತಃ ಶಕ್ತಿ ರ್ನಿರ್ಗತೇತಿ ಮಯಾ ನಿಶ್ಚಿತಮಜ್ಞಾಯಿ| ");
INSERT INTO sankan_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ತದಾ ಸಾ ನಾರೀ ಸ್ವಯಂ ನ ಗುಪ್ತೇತಿ ವಿದಿತ್ವಾ ಕಮ್ಪಮಾನಾ ಸತೀ ತಸ್ಯ ಸಮ್ಮುಖೇ ಪಪಾತ; ಯೇನ ನಿಮಿತ್ತೇನ ತಂ ಪಸ್ಪರ್ಶ ಸ್ಪರ್ಶಮಾತ್ರಾಚ್ಚ ಯೇನ ಪ್ರಕಾರೇಣ ಸ್ವಸ್ಥಾಭವತ್ ತತ್ ಸರ್ವ್ವಂ ತಸ್ಯ ಸಾಕ್ಷಾದಾಚಖ್ಯೌ| ");
INSERT INTO sankan_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ತತಃ ಸ ತಾಂ ಜಗಾದ ಹೇ ಕನ್ಯೇ ಸುಸ್ಥಿರಾ ಭವ, ತವ ವಿಶ್ವಾಸಸ್ತ್ವಾಂ ಸ್ವಸ್ಥಾಮ್ ಅಕಾರ್ಷೀತ್ ತ್ವಂ ಕ್ಷೇಮೇಣ ಯಾಹಿ| ");
INSERT INTO sankan_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","ಯೀಶೋರೇತದ್ವಾಕ್ಯವದನಕಾಲೇ ತಸ್ಯಾಧಿಪತೇ ರ್ನಿವೇಶನಾತ್ ಕಶ್ಚಿಲ್ಲೋಕ ಆಗತ್ಯ ತಂ ಬಭಾಷೇ, ತವ ಕನ್ಯಾ ಮೃತಾ ಗುರುಂ ಮಾ ಕ್ಲಿಶಾನ| ");
INSERT INTO sankan_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","ಕಿನ್ತು ಯೀಶುಸ್ತದಾಕರ್ಣ್ಯಾಧಿಪತಿಂ ವ್ಯಾಜಹಾರ, ಮಾ ಭೈಷೀಃ ಕೇವಲಂ ವಿಶ್ವಸಿಹಿ ತಸ್ಮಾತ್ ಸಾ ಜೀವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ಅಥ ತಸ್ಯ ನಿವೇಶನೇ ಪ್ರಾಪ್ತೇ ಸ ಪಿತರಂ ಯೋಹನಂ ಯಾಕೂಬಞ್ಚ ಕನ್ಯಾಯಾ ಮಾತರಂ ಪಿತರಞ್ಚ ವಿನಾ, ಅನ್ಯಂ ಕಞ್ಚನ ಪ್ರವೇಷ್ಟುಂ ವಾರಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","ಅಪರಞ್ಚ ಯೇ ರುದನ್ತಿ ವಿಲಪನ್ತಿ ಚ ತಾನ್ ಸರ್ವ್ವಾನ್ ಜನಾನ್ ಉವಾಚ, ಯೂಯಂ ಮಾ ರೋದಿಷ್ಟ ಕನ್ಯಾ ನ ಮೃತಾ ನಿದ್ರಾತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","ಕಿನ್ತು ಸಾ ನಿಶ್ಚಿತಂ ಮೃತೇತಿ ಜ್ಞಾತ್ವಾ ತೇ ತಮುಪಜಹಸುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","ಪಶ್ಚಾತ್ ಸ ಸರ್ವ್ವಾನ್ ಬಹಿಃ ಕೃತ್ವಾ ಕನ್ಯಾಯಾಃ ಕರೌ ಧೃತ್ವಾಜುಹುವೇ, ಹೇ ಕನ್ಯೇ ತ್ವಮುತ್ತಿಷ್ಠ, ");
INSERT INTO sankan_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ತಸ್ಮಾತ್ ತಸ್ಯಾಃ ಪ್ರಾಣೇಷು ಪುನರಾಗತೇಷು ಸಾ ತತ್ಕ್ಷಣಾದ್ ಉತ್ತಸ್ಯೌ| ತದಾನೀಂ ತಸ್ಯೈ ಕಿಞ್ಚಿದ್ ಭಕ್ಷ್ಯಂ ದಾತುಮ್ ಆದಿದೇಶ| ");
INSERT INTO sankan_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ತತಸ್ತಸ್ಯಾಃ ಪಿತರೌ ವಿಸ್ಮಯಂ ಗತೌ ಕಿನ್ತು ಸ ತಾವಾದಿದೇಶ ಘಟನಾಯಾ ಏತಸ್ಯಾಃ ಕಥಾಂ ಕಸ್ಮೈಚಿದಪಿ ಮಾ ಕಥಯತಂ| ");
INSERT INTO sankan_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","ತತಃ ಪರಂ ಸ ದ್ವಾದಶಶಿಷ್ಯಾನಾಹೂಯ ಭೂತಾನ್ ತ್ಯಾಜಯಿತುಂ ರೋಗಾನ್ ಪ್ರತಿಕರ್ತ್ತುಞ್ಚ ತೇಭ್ಯಃ ಶಕ್ತಿಮಾಧಿಪತ್ಯಞ್ಚ ದದೌ| ");
INSERT INTO sankan_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ಅಪರಞ್ಚ ಈಶ್ವರೀಯರಾಜ್ಯಸ್ಯ ಸುಸಂವಾದಂ ಪ್ರಕಾಶಯಿತುಮ್ ರೋಗಿಣಾಮಾರೋಗ್ಯಂ ಕರ್ತ್ತುಞ್ಚ ಪ್ರೇರಣಕಾಲೇ ತಾನ್ ಜಗಾದ| ");
INSERT INTO sankan_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ಯಾತ್ರಾರ್ಥಂ ಯಷ್ಟಿ ರ್ವಸ್ತ್ರಪುಟಕಂ ಭಕ್ಷ್ಯಂ ಮುದ್ರಾ ದ್ವಿತೀಯವಸ್ತ್ರಮ್, ಏಷಾಂ ಕಿಮಪಿ ಮಾ ಗೃಹ್ಲೀತ| ");
INSERT INTO sankan_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ಯೂಯಞ್ಚ ಯನ್ನಿವೇಶನಂ ಪ್ರವಿಶಥ ನಗರತ್ಯಾಗಪರ್ಯ್ಯನತಂ ತನ್ನಿವೇಶನೇ ತಿಷ್ಠತ| ");
INSERT INTO sankan_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","ತತ್ರ ಯದಿ ಕಸ್ಯಚಿತ್ ಪುರಸ್ಯ ಲೋಕಾ ಯುಷ್ಮಾಕಮಾತಿಥ್ಯಂ ನ ಕುರ್ವ್ವನ್ತಿ ತರ್ಹಿ ತಸ್ಮಾನ್ನಗರಾದ್ ಗಮನಕಾಲೇ ತೇಷಾಂ ವಿರುದ್ಧಂ ಸಾಕ್ಷ್ಯಾರ್ಥಂ ಯುಷ್ಮಾಕಂ ಪದಧೂಲೀಃ ಸಮ್ಪಾತಯತ| ");
INSERT INTO sankan_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","ಅಥ ತೇ ಪ್ರಸ್ಥಾಯ ಸರ್ವ್ವತ್ರ ಸುಸಂವಾದಂ ಪ್ರಚಾರಯಿತುಂ ಪೀಡಿತಾನ್ ಸ್ವಸ್ಥಾನ್ ಕರ್ತ್ತುಞ್ಚ ಗ್ರಾಮೇಷು ಭ್ರಮಿತುಂ ಪ್ರಾರೇಭಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ಏತರ್ಹಿ ಹೇರೋದ್ ರಾಜಾ ಯೀಶೋಃ ಸರ್ವ್ವಕರ್ಮ್ಮಣಾಂ ವಾರ್ತ್ತಾಂ ಶ್ರುತ್ವಾ ಭೃಶಮುದ್ವಿವಿಜೇ ");
INSERT INTO sankan_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ಯತಃ ಕೇಚಿದೂಚುರ್ಯೋಹನ್ ಶ್ಮಶಾನಾದುದತಿಷ್ಠತ್| ಕೇಚಿದೂಚುಃ, ಏಲಿಯೋ ದರ್ಶನಂ ದತ್ತವಾನ್; ಏವಮನ್ಯಲೋಕಾ ಊಚುಃ ಪೂರ್ವ್ವೀಯಃ ಕಶ್ಚಿದ್ ಭವಿಷ್ಯದ್ವಾದೀ ಸಮುತ್ಥಿತಃ| ");
INSERT INTO sankan_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","ಕಿನ್ತು ಹೇರೋದುವಾಚ ಯೋಹನಃ ಶಿರೋಽಹಮಛಿನದಮ್ ಇದಾನೀಂ ಯಸ್ಯೇದೃಕ್ಕರ್ಮ್ಮಣಾಂ ವಾರ್ತ್ತಾಂ ಪ್ರಾಪ್ನೋಮಿ ಸ ಕಃ? ಅಥ ಸ ತಂ ದ್ರಷ್ಟುಮ್ ಐಚ್ಛತ್| ");
INSERT INTO sankan_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","ಅನನ್ತರಂ ಪ್ರೇರಿತಾಃ ಪ್ರತ್ಯಾಗತ್ಯ ಯಾನಿ ಯಾನಿ ಕರ್ಮ್ಮಾಣಿ ಚಕ್ರುಸ್ತಾನಿ ಯೀಶವೇ ಕಥಯಾಮಾಸುಃ ತತಃ ಸ ತಾನ್ ಬೈತ್ಸೈದಾನಾಮಕನಗರಸ್ಯ ವಿಜನಂ ಸ್ಥಾನಂ ನೀತ್ವಾ ಗುಪ್ತಂ ಜಗಾಮ| ");
INSERT INTO sankan_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ಪಶ್ಚಾಲ್ ಲೋಕಾಸ್ತದ್ ವಿದಿತ್ವಾ ತಸ್ಯ ಪಶ್ಚಾದ್ ಯಯುಃ; ತತಃ ಸ ತಾನ್ ನಯನ್ ಈಶ್ವರೀಯರಾಜ್ಯಸ್ಯ ಪ್ರಸಙ್ಗಮುಕ್ತವಾನ್, ಯೇಷಾಂ ಚಿಕಿತ್ಸಯಾ ಪ್ರಯೋಜನಮ್ ಆಸೀತ್ ತಾನ್ ಸ್ವಸ್ಥಾನ್ ಚಕಾರ ಚ| ");
INSERT INTO sankan_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ಅಪರಞ್ಚ ದಿವಾವಸನ್ನೇ ಸತಿ ದ್ವಾದಶಶಿಷ್ಯಾ ಯೀಶೋರನ್ತಿಕಮ್ ಏತ್ಯ ಕಥಯಾಮಾಸುಃ, ವಯಮತ್ರ ಪ್ರಾನ್ತರಸ್ಥಾನೇ ತಿಷ್ಠಾಮಃ, ತತೋ ನಗರಾಣಿ ಗ್ರಾಮಾಣಿ ಗತ್ವಾ ವಾಸಸ್ಥಾನಾನಿ ಪ್ರಾಪ್ಯ ಭಕ್ಷ್ಯದ್ರವ್ಯಾಣಿ ಕ್ರೇತುಂ ಜನನಿವಹಂ ಭವಾನ್ ವಿಸೃಜತು| ");
INSERT INTO sankan_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","ತದಾ ಸ ಉವಾಚ, ಯೂಯಮೇವ ತಾನ್ ಭೇಜಯಧ್ವಂ; ತತಸ್ತೇ ಪ್ರೋಚುರಸ್ಮಾಕಂ ನಿಕಟೇ ಕೇವಲಂ ಪಞ್ಚ ಪೂಪಾ ದ್ವೌ ಮತ್ಸ್ಯೌ ಚ ವಿದ್ಯನ್ತೇ, ಅತಏವ ಸ್ಥಾನಾನ್ತರಮ್ ಇತ್ವಾ ನಿಮಿತ್ತಮೇತೇಷಾಂ ಭಕ್ಷ್ಯದ್ರವ್ಯೇಷು ನ ಕ್ರೀತೇಷು ನ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","ತತ್ರ ಪ್ರಾಯೇಣ ಪಞ್ಚಸಹಸ್ರಾಣಿ ಪುರುಷಾ ಆಸನ್| ");
INSERT INTO sankan_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","ತದಾ ಸ ಶಿಷ್ಯಾನ್ ಜಗಾದ ಪಞ್ಚಾಶತ್ ಪಞ್ಚಾಶಜ್ಜನೈಃ ಪಂಕ್ತೀಕೃತ್ಯ ತಾನುಪವೇಶಯತ, ತಸ್ಮಾತ್ ತೇ ತದನುಸಾರೇಣ ಸರ್ವ್ವಲೋಕಾನುಪವೇಶಯಾಪಾಸುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ತತಃ ಸ ತಾನ್ ಪಞ್ಚ ಪೂಪಾನ್ ಮೀನದ್ವಯಞ್ಚ ಗೃಹೀತ್ವಾ ಸ್ವರ್ಗಂ ವಿಲೋಕ್ಯೇಶ್ವರಗುಣಾನ್ ಕೀರ್ತ್ತಯಾಞ್ಚಕ್ರೇ ಭಙ್ಕ್ತಾ ಚ ಲೋಕೇಭ್ಯಃ ಪರಿವೇಷಣಾರ್ಥಂ ಶಿಷ್ಯೇಷು ಸಮರ್ಪಯಾಮ್ಬಭೂವ| ");
INSERT INTO sankan_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ತತಃ ಸರ್ವ್ವೇ ಭುಕ್ತ್ವಾ ತೃಪ್ತಿಂ ಗತಾ ಅವಶಿಷ್ಟಾನಾಞ್ಚ ದ್ವಾದಶ ಡಲ್ಲಕಾನ್ ಸಂಜಗೃಹುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","ಅಥೈಕದಾ ನಿರ್ಜನೇ ಶಿಷ್ಯೈಃ ಸಹ ಪ್ರಾರ್ಥನಾಕಾಲೇ ತಾನ್ ಪಪ್ರಚ್ಛ, ಲೋಕಾ ಮಾಂ ಕಂ ವದನ್ತಿ? ");
INSERT INTO sankan_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","ತತಸ್ತೇ ಪ್ರಾಚುಃ, ತ್ವಾಂ ಯೋಹನ್ಮಜ್ಜಕಂ ವದನ್ತಿ; ಕೇಚಿತ್ ತ್ವಾಮ್ ಏಲಿಯಂ ವದನ್ತಿ, ಪೂರ್ವ್ವಕಾಲಿಕಃ ಕಶ್ಚಿದ್ ಭವಿಷ್ಯದ್ವಾದೀ ಶ್ಮಶಾನಾದ್ ಉದತಿಷ್ಠದ್ ಇತ್ಯಪಿ ಕೇಚಿದ್ ವದನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ತದಾ ಸ ಉವಾಚ, ಯೂಯಂ ಮಾಂ ಕಂ ವದಥ? ತತಃ ಪಿತರ ಉಕ್ತವಾನ್ ತ್ವಮ್ ಈಶ್ವರಾಭಿಷಿಕ್ತಃ ಪುರುಷಃ| ");
INSERT INTO sankan_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","ತದಾ ಸ ತಾನ್ ದೃಢಮಾದಿದೇಶ, ಕಥಾಮೇತಾಂ ಕಸ್ಮೈಚಿದಪಿ ಮಾ ಕಥಯತ| ");
INSERT INTO sankan_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ಸ ಪುನರುವಾಚ, ಮನುಷ್ಯಪುತ್ರೇಣ ವಹುಯಾತನಾ ಭೋಕ್ತವ್ಯಾಃ ಪ್ರಾಚೀನಲೋಕೈಃ ಪ್ರಧಾನಯಾಜಕೈರಧ್ಯಾಪಕೈಶ್ಚ ಸೋವಜ್ಞಾಯ ಹನ್ತವ್ಯಃ ಕಿನ್ತು ತೃತೀಯದಿವಸೇ ಶ್ಮಶಾನಾತ್ ತೇನೋತ್ಥಾತವ್ಯಮ್| ");
INSERT INTO sankan_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ಅಪರಂ ಸ ಸರ್ವ್ವಾನುವಾಚ, ಕಶ್ಚಿದ್ ಯದಿ ಮಮ ಪಶ್ಚಾದ್ ಗನ್ತುಂ ವಾಞ್ಛತಿ ತರ್ಹಿ ಸ ಸ್ವಂ ದಾಮ್ಯತು, ದಿನೇ ದಿನೇ ಕ್ರುಶಂ ಗೃಹೀತ್ವಾ ಚ ಮಮ ಪಶ್ಚಾದಾಗಚ್ಛತು| ");
INSERT INTO sankan_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ಯತೋ ಯಃ ಕಶ್ಚಿತ್ ಸ್ವಪ್ರಾಣಾನ್ ರಿರಕ್ಷಿಷತಿ ಸ ತಾನ್ ಹಾರಯಿಷ್ಯತಿ, ಯಃ ಕಶ್ಚಿನ್ ಮದರ್ಥಂ ಪ್ರಾಣಾನ್ ಹಾರಯಿಷ್ಯತಿ ಸ ತಾನ್ ರಕ್ಷಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","ಕಶ್ಚಿದ್ ಯದಿ ಸರ್ವ್ವಂ ಜಗತ್ ಪ್ರಾಪ್ನೋತಿ ಕಿನ್ತು ಸ್ವಪ್ರಾಣಾನ್ ಹಾರಯತಿ ಸ್ವಯಂ ವಿನಶ್ಯತಿ ಚ ತರ್ಹಿ ತಸ್ಯ ಕೋ ಲಾಭಃ? ");
INSERT INTO sankan_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","ಪುನ ರ್ಯಃ ಕಶ್ಚಿನ್ ಮಾಂ ಮಮ ವಾಕ್ಯಂ ವಾ ಲಜ್ಜಾಸ್ಪದಂ ಜಾನಾತಿ ಮನುಷ್ಯಪುತ್ರೋ ಯದಾ ಸ್ವಸ್ಯ ಪಿತುಶ್ಚ ಪವಿತ್ರಾಣಾಂ ದೂತಾನಾಞ್ಚ ತೇಜೋಭಿಃ ಪರಿವೇಷ್ಟಿತ ಆಗಮಿಷ್ಯತಿ ತದಾ ಸೋಪಿ ತಂ ಲಜ್ಜಾಸ್ಪದಂ ಜ್ಞಾಸ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","ಕಿನ್ತು ಯುಷ್ಮಾನಹಂ ಯಥಾರ್ಥಂ ವದಾಮಿ, ಈಶ್ವರೀಯರಾಜತ್ವಂ ನ ದೃಷ್ಟವಾ ಮೃತ್ಯುಂ ನಾಸ್ವಾದಿಷ್ಯನ್ತೇ, ಏತಾದೃಶಾಃ ಕಿಯನ್ತೋ ಲೋಕಾ ಅತ್ರ ಸ್ಥನೇಽಪಿ ದಣ್ಡಾಯಮಾನಾಃ ಸನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ಏತದಾಖ್ಯಾನಕಥನಾತ್ ಪರಂ ಪ್ರಾಯೇಣಾಷ್ಟಸು ದಿನೇಷು ಗತೇಷು ಸ ಪಿತರಂ ಯೋಹನಂ ಯಾಕೂಬಞ್ಚ ಗೃಹೀತ್ವಾ ಪ್ರಾರ್ಥಯಿತುಂ ಪರ್ವ್ವತಮೇಕಂ ಸಮಾರುರೋಹ| ");
INSERT INTO sankan_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ಅಥ ತಸ್ಯ ಪ್ರಾರ್ಥನಕಾಲೇ ತಸ್ಯ ಮುಖಾಕೃತಿರನ್ಯರೂಪಾ ಜಾತಾ, ತದೀಯಂ ವಸ್ತ್ರಮುಜ್ಜ್ವಲಶುಕ್ಲಂ ಜಾತಂ| ");
INSERT INTO sankan_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","ಅಪರಞ್ಚ ಮೂಸಾ ಏಲಿಯಶ್ಚೋಭೌ ತೇಜಸ್ವಿನೌ ದೃಷ್ಟೌ ");
INSERT INTO sankan_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ತೌ ತೇನ ಯಿರೂಶಾಲಮ್ಪುರೇ ಯೋ ಮೃತ್ಯುಃ ಸಾಧಿಷ್ಯತೇ ತದೀಯಾಂ ಕಥಾಂ ತೇನ ಸಾರ್ದ್ಧಂ ಕಥಯಿತುಮ್ ಆರೇಭಾತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ತದಾ ಪಿತರಾದಯಃ ಸ್ವಸ್ಯ ಸಙ್ಗಿನೋ ನಿದ್ರಯಾಕೃಷ್ಟಾ ಆಸನ್ ಕಿನ್ತು ಜಾಗರಿತ್ವಾ ತಸ್ಯ ತೇಜಸ್ತೇನ ಸಾರ್ದ್ಧಮ್ ಉತ್ತಿಷ್ಠನ್ತೌ ಜನೌ ಚ ದದೃಶುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","ಅಥ ತಯೋರುಭಯೋ ರ್ಗಮನಕಾಲೇ ಪಿತರೋ ಯೀಶುಂ ಬಭಾಷೇ, ಹೇ ಗುರೋಽಸ್ಮಾಕಂ ಸ್ಥಾನೇಽಸ್ಮಿನ್ ಸ್ಥಿತಿಃ ಶುಭಾ, ತತ ಏಕಾ ತ್ವದರ್ಥಾ, ಏಕಾ ಮೂಸಾರ್ಥಾ, ಏಕಾ ಏಲಿಯಾರ್ಥಾ, ಇತಿ ತಿಸ್ರಃ ಕುಟ್ಯೋಸ್ಮಾಭಿ ರ್ನಿರ್ಮ್ಮೀಯನ್ತಾಂ, ಇಮಾಂ ಕಥಾಂ ಸ ನ ವಿವಿಚ್ಯ ಕಥಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","ಅಪರಞ್ಚ ತದ್ವಾಕ್ಯವದನಕಾಲೇ ಪಯೋದ ಏಕ ಆಗತ್ಯ ತೇಷಾಮುಪರಿ ಛಾಯಾಂ ಚಕಾರ, ತತಸ್ತನ್ಮಧ್ಯೇ ತಯೋಃ ಪ್ರವೇಶಾತ್ ತೇ ಶಶಙ್ಕಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ತದಾ ತಸ್ಮಾತ್ ಪಯೋದಾದ್ ಇಯಮಾಕಾಶೀಯಾ ವಾಣೀ ನಿರ್ಜಗಾಮ, ಮಮಾಯಂ ಪ್ರಿಯಃ ಪುತ್ರ ಏತಸ್ಯ ಕಥಾಯಾಂ ಮನೋ ನಿಧತ್ತ| ");
INSERT INTO sankan_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ಇತಿ ಶಬ್ದೇ ಜಾತೇ ತೇ ಯೀಶುಮೇಕಾಕಿನಂ ದದೃಶುಃ ಕಿನ್ತು ತೇ ತದಾನೀಂ ತಸ್ಯ ದರ್ಶನಸ್ಯ ವಾಚಮೇಕಾಮಪಿ ನೋಕ್ತ್ವಾ ಮನಃಸು ಸ್ಥಾಪಯಾಮಾಸುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","ಪರೇಽಹನಿ ತೇಷು ತಸ್ಮಾಚ್ಛೈಲಾದ್ ಅವರೂಢೇಷು ತಂ ಸಾಕ್ಷಾತ್ ಕರ್ತ್ತುಂ ಬಹವೋ ಲೋಕಾ ಆಜಗ್ಮುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ತೇಷಾಂ ಮಧ್ಯಾದ್ ಏಕೋ ಜನ ಉಚ್ಚೈರುವಾಚ, ಹೇ ಗುರೋ ಅಹಂ ವಿನಯಂ ಕರೋಮಿ ಮಮ ಪುತ್ರಂ ಪ್ರತಿ ಕೃಪಾದೃಷ್ಟಿಂ ಕರೋತು, ಮಮ ಸ ಏವೈಕಃ ಪುತ್ರಃ| ");
INSERT INTO sankan_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ಭೂತೇನ ಧೃತಃ ಸನ್ ಸಂ ಪ್ರಸಭಂ ಚೀಚ್ಛಬ್ದಂ ಕರೋತಿ ತನ್ಮುಖಾತ್ ಫೇಣಾ ನಿರ್ಗಚ್ಛನ್ತಿ ಚ, ಭೂತ ಇತ್ಥಂ ವಿದಾರ್ಯ್ಯ ಕ್ಲಿಷ್ಟ್ವಾ ಪ್ರಾಯಶಸ್ತಂ ನ ತ್ಯಜತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ತಸ್ಮಾತ್ ತಂ ಭೂತಂ ತ್ಯಾಜಯಿತುಂ ತವ ಶಿಷ್ಯಸಮೀಪೇ ನ್ಯವೇದಯಂ ಕಿನ್ತು ತೇ ನ ಶೇಕುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ತದಾ ಯೀಶುರವಾದೀತ್, ರೇ ಆವಿಶ್ವಾಸಿನ್ ವಿಪಥಗಾಮಿನ್ ವಂಶ ಕತಿಕಾಲಾನ್ ಯುಷ್ಮಾಭಿಃ ಸಹ ಸ್ಥಾಸ್ಯಾಮ್ಯಹಂ ಯುಷ್ಮಾಕಮ್ ಆಚರಣಾನಿ ಚ ಸಹಿಷ್ಯೇ? ತವ ಪುತ್ರಮಿಹಾನಯ| ");
INSERT INTO sankan_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ತತಸ್ತಸ್ಮಿನ್ನಾಗತಮಾತ್ರೇ ಭೂತಸ್ತಂ ಭೂಮೌ ಪಾತಯಿತ್ವಾ ವಿದದಾರ; ತದಾ ಯೀಶುಸ್ತಮಮೇಧ್ಯಂ ಭೂತಂ ತರ್ಜಯಿತ್ವಾ ಬಾಲಕಂ ಸ್ವಸ್ಥಂ ಕೃತ್ವಾ ತಸ್ಯ ಪಿತರಿ ಸಮರ್ಪಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ಈಶ್ವರಸ್ಯ ಮಹಾಶಕ್ತಿಮ್ ಇಮಾಂ ವಿಲೋಕ್ಯ ಸರ್ವ್ವೇ ಚಮಚ್ಚಕ್ರುಃ; ಇತ್ಥಂ ಯೀಶೋಃ ಸರ್ವ್ವಾಭಿಃ ಕ್ರಿಯಾಭಿಃ ಸರ್ವ್ವೈರ್ಲೋಕೈರಾಶ್ಚರ್ಯ್ಯೇ ಮನ್ಯಮಾನೇ ಸತಿ ಸ ಶಿಷ್ಯಾನ್ ಬಭಾಷೇ, ");
INSERT INTO sankan_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","ಕಥೇಯಂ ಯುಷ್ಮಾಕಂ ಕರ್ಣೇಷು ಪ್ರವಿಶತು, ಮನುಷ್ಯಪುತ್ರೋ ಮನುಷ್ಯಾಣಾಂ ಕರೇಷು ಸಮರ್ಪಯಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","ಕಿನ್ತು ತೇ ತಾಂ ಕಥಾಂ ನ ಬುಬುಧಿರೇ, ಸ್ಪಷ್ಟತ್ವಾಭಾವಾತ್ ತಸ್ಯಾ ಅಭಿಪ್ರಾಯಸ್ತೇಷಾಂ ಬೋಧಗಮ್ಯೋ ನ ಬಭೂವ; ತಸ್ಯಾ ಆಶಯಃ ಕ ಇತ್ಯಪಿ ತೇ ಭಯಾತ್ ಪ್ರಷ್ಟುಂ ನ ಶೇಕುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","ತದನನ್ತರಂ ತೇಷಾಂ ಮಧ್ಯೇ ಕಃ ಶ್ರೇಷ್ಠಃ ಕಥಾಮೇತಾಂ ಗೃಹೀತ್ವಾ ತೇ ಮಿಥೋ ವಿವಾದಂ ಚಕ್ರುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ತತೋ ಯೀಶುಸ್ತೇಷಾಂ ಮನೋಭಿಪ್ರಾಯಂ ವಿದಿತ್ವಾ ಬಾಲಕಮೇಕಂ ಗೃಹೀತ್ವಾ ಸ್ವಸ್ಯ ನಿಕಟೇ ಸ್ಥಾಪಯಿತ್ವಾ ತಾನ್ ಜಗಾದ, ");
INSERT INTO sankan_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ಯೋ ಜನೋ ಮಮ ನಾಮ್ನಾಸ್ಯ ಬಾಲಾಸ್ಯಾತಿಥ್ಯಂ ವಿದಧಾತಿ ಸ ಮಮಾತಿಥ್ಯಂ ವಿದಧಾತಿ, ಯಶ್ಚ ಮಮಾತಿಥ್ಯಂ ವಿದಧಾತಿ ಸ ಮಮ ಪ್ರೇರಕಸ್ಯಾತಿಥ್ಯಂ ವಿದಧಾತಿ, ಯುಷ್ಮಾಕಂ ಮಧ್ಯೇಯಃ ಸ್ವಂ ಸರ್ವ್ವಸ್ಮಾತ್ ಕ್ಷುದ್ರಂ ಜಾನೀತೇ ಸ ಏವ ಶ್ರೇಷ್ಠೋ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","ಅಪರಞ್ಚ ಯೋಹನ್ ವ್ಯಾಜಹಾರ ಹೇ ಪ್ರಭೇा ತವ ನಾಮ್ನಾ ಭೂತಾನ್ ತ್ಯಾಜಯನ್ತಂ ಮಾನುಷಮ್ ಏಕಂ ದೃಷ್ಟವನ್ತೋ ವಯಂ, ಕಿನ್ತ್ವಸ್ಮಾಕಮ್ ಅಪಶ್ಚಾದ್ ಗಾಮಿತ್ವಾತ್ ತಂ ನ್ಯಷೇಧಾಮ್| ತದಾನೀಂ ಯೀಶುರುವಾಚ, ");
INSERT INTO sankan_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","ತಂ ಮಾ ನಿಷೇಧತ, ಯತೋ ಯೋ ಜನೋಸ್ಮಾಕಂ ನ ವಿಪಕ್ಷಃ ಸ ಏವಾಸ್ಮಾಕಂ ಸಪಕ್ಷೋ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","ಅನನ್ತರಂ ತಸ್ಯಾರೋಹಣಸಮಯ ಉಪಸ್ಥಿತೇ ಸ ಸ್ಥಿರಚೇತಾ ಯಿರೂಶಾಲಮಂ ಪ್ರತಿ ಯಾತ್ರಾಂ ಕರ್ತ್ತುಂ ನಿಶ್ಚಿತ್ಯಾಗ್ರೇ ದೂತಾನ್ ಪ್ರೇಷಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ತಸ್ಮಾತ್ ತೇ ಗತ್ವಾ ತಸ್ಯ ಪ್ರಯೋಜನೀಯದ್ರವ್ಯಾಣಿ ಸಂಗ್ರಹೀತುಂ ಶೋಮಿರೋಣೀಯಾನಾಂ ಗ್ರಾಮಂ ಪ್ರವಿವಿಶುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ಕಿನ್ತು ಸ ಯಿರೂಶಾಲಮಂ ನಗರಂ ಯಾತಿ ತತೋ ಹೇತೋ ರ್ಲೋಕಾಸ್ತಸ್ಯಾತಿಥ್ಯಂ ನ ಚಕ್ರುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ಅತಏವ ಯಾಕೂಬ್ಯೋಹನೌ ತಸ್ಯ ಶಿಷ್ಯೌ ತದ್ ದೃಷ್ಟ್ವಾ ಜಗದತುಃ, ಹೇ ಪ್ರಭೋ ಏಲಿಯೋ ಯಥಾ ಚಕಾರ ತಥಾ ವಯಮಪಿ ಕಿಂ ಗಗಣಾದ್ ಆಗನ್ತುಮ್ ಏತಾನ್ ಭಸ್ಮೀಕರ್ತ್ತುಞ್ಚ ವಹ್ನಿಮಾಜ್ಞಾಪಯಾಮಃ? ಭವಾನ್ ಕಿಮಿಚ್ಛತಿ? ");
INSERT INTO sankan_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","ಕಿನ್ತು ಸ ಮುಖಂ ಪರಾವರ್ತ್ಯ ತಾನ್ ತರ್ಜಯಿತ್ವಾ ಗದಿತವಾನ್ ಯುಷ್ಮಾಕಂ ಮನೋಭಾವಃ ಕಃ, ಇತಿ ಯೂಯಂ ನ ಜಾನೀಥ| ");
INSERT INTO sankan_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ಮನುಜಸುತೋ ಮನುಜಾನಾಂ ಪ್ರಾಣಾನ್ ನಾಶಯಿತುಂ ನಾಗಚ್ಛತ್, ಕಿನ್ತು ರಕ್ಷಿತುಮ್ ಆಗಚ್ಛತ್| ಪಶ್ಚಾದ್ ಇತರಗ್ರಾಮಂ ತೇ ಯಯುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","ತದನನ್ತರಂ ಪಥಿ ಗಮನಕಾಲೇ ಜನ ಏಕಸ್ತಂ ಬಭಾಷೇ, ಹೇ ಪ್ರಭೋ ಭವಾನ್ ಯತ್ರ ಯಾತಿ ಭವತಾ ಸಹಾಹಮಪಿ ತತ್ರ ಯಾಸ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ತದಾನೀಂ ಯೀಶುಸ್ತಮುವಾಚ, ಗೋಮಾಯೂನಾಂ ಗರ್ತ್ತಾ ಆಸತೇ, ವಿಹಾಯಸೀಯವಿಹಗಾाನಾಂ ನೀಡಾನಿ ಚ ಸನ್ತಿ, ಕಿನ್ತು ಮಾನವತನಯಸ್ಯ ಶಿರಃ ಸ್ಥಾಪಯಿತುಂ ಸ್ಥಾನಂ ನಾಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ತತಃ ಪರಂ ಸ ಇತರಜನಂ ಜಗಾದ, ತ್ವಂ ಮಮ ಪಶ್ಚಾದ್ ಏಹಿ; ತತಃ ಸ ಉವಾಚ, ಹೇ ಪ್ರಭೋ ಪೂರ್ವ್ವಂ ಪಿತರಂ ಶ್ಮಶಾನೇ ಸ್ಥಾಪಯಿತುಂ ಮಾಮಾದಿಶತು| ");
INSERT INTO sankan_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ತದಾ ಯೀಶುರುವಾಚ, ಮೃತಾ ಮೃತಾನ್ ಶ್ಮಶಾನೇ ಸ್ಥಾಪಯನ್ತು ಕಿನ್ತು ತ್ವಂ ಗತ್ವೇಶ್ವರೀಯರಾಜ್ಯಸ್ಯ ಕಥಾಂ ಪ್ರಚಾರಯ| ");
INSERT INTO sankan_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ತತೋನ್ಯಃ ಕಥಯಾಮಾಸ, ಹೇ ಪ್ರಭೋ ಮಯಾಪಿ ಭವತಃ ಪಶ್ಚಾದ್ ಗಂಸ್ಯತೇ, ಕಿನ್ತು ಪೂರ್ವ್ವಂ ಮಮ ನಿವೇಶನಸ್ಯ ಪರಿಜನಾನಾಮ್ ಅನುಮತಿಂ ಗ್ರಹೀತುಮ್ ಅಹಮಾದಿಶ್ಯೈ ಭವತಾ| ");
INSERT INTO sankan_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ತದಾನೀಂ ಯೀಶುಸ್ತಂ ಪ್ರೋಕ್ತವಾನ್, ಯೋ ಜನೋ ಲಾಙ್ಗಲೇ ಕರಮರ್ಪಯಿತ್ವಾ ಪಶ್ಚಾತ್ ಪಶ್ಯತಿ ಸ ಈಶ್ವರೀಯರಾಜ್ಯಂ ನಾರ್ಹತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ತತಃ ಪರಂ ಪ್ರಭುರಪರಾನ್ ಸಪ್ತತಿಶಿಷ್ಯಾನ್ ನಿಯುಜ್ಯ ಸ್ವಯಂ ಯಾನಿ ನಗರಾಣಿ ಯಾನಿ ಸ್ಥಾನಾನಿ ಚ ಗಮಿಷ್ಯತಿ ತಾನಿ ನಗರಾಣಿ ತಾನಿ ಸ್ಥಾನಾನಿ ಚ ಪ್ರತಿ ದ್ವೌ ದ್ವೌ ಜನೌ ಪ್ರಹಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ತೇಭ್ಯಃ ಕಥಯಾಮಾಸ ಚ ಶಸ್ಯಾನಿ ಬಹೂನೀತಿ ಸತ್ಯಂ ಕಿನ್ತು ಛೇದಕಾ ಅಲ್ಪೇ; ತಸ್ಮಾದ್ಧೇತೋಃ ಶಸ್ಯಕ್ಷೇತ್ರೇ ಛೇದಕಾನ್ ಅಪರಾನಪಿ ಪ್ರೇಷಯಿತುಂ ಕ್ಷೇತ್ರಸ್ವಾಮಿನಂ ಪ್ರಾರ್ಥಯಧ್ವಂ| ");
INSERT INTO sankan_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","ಯೂಯಂ ಯಾತ, ಪಶ್ಯತ, ವೃಕಾಣಾಂ ಮಧ್ಯೇ ಮೇಷಶಾವಕಾನಿವ ಯುಷ್ಮಾನ್ ಪ್ರಹಿಣೋಮಿ| ");
INSERT INTO sankan_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","ಯೂಯಂ ಕ್ಷುದ್ರಂ ಮಹದ್ ವಾ ವಸನಸಮ್ಪುಟಕಂ ಪಾದುಕಾಶ್ಚ ಮಾ ಗೃಹ್ಲೀತ, ಮಾರ್ಗಮಧ್ಯೇ ಕಮಪಿ ಮಾ ನಮತ ಚ| ");
INSERT INTO sankan_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","ಅಪರಞ್ಚ ಯೂಯಂ ಯದ್ ಯತ್ ನಿವೇಶನಂ ಪ್ರವಿಶಥ ತತ್ರ ನಿವೇಶನಸ್ಯಾಸ್ಯ ಮಙ್ಗಲಂ ಭೂಯಾದಿತಿ ವಾಕ್ಯಂ ಪ್ರಥಮಂ ವದತ| ");
INSERT INTO sankan_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","ತಸ್ಮಾತ್ ತಸ್ಮಿನ್ ನಿವೇಶನೇ ಯದಿ ಮಙ್ಗಲಪಾತ್ರಂ ಸ್ಥಾಸ್ಯತಿ ತರ್ಹಿ ತನ್ಮಙ್ಗಲಂ ತಸ್ಯ ಭವಿಷ್ಯತಿ, ನೋಚೇತ್ ಯುಷ್ಮಾನ್ ಪ್ರತಿ ಪರಾವರ್ತ್ತಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","ಅಪರಞ್ಚ ತೇ ಯತ್ಕಿಞ್ಚಿದ್ ದಾಸ್ಯನ್ತಿ ತದೇವ ಭುಕ್ತ್ವಾ ಪೀತ್ವಾ ತಸ್ಮಿನ್ನಿವೇಶನೇ ಸ್ಥಾಸ್ಯಥ; ಯತಃ ಕರ್ಮ್ಮಕಾರೀ ಜನೋ ಭೃತಿಮ್ ಅರ್ಹತಿ; ಗೃಹಾದ್ ಗೃಹಂ ಮಾ ಯಾಸ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","ಅನ್ಯಚ್ಚ ಯುಷ್ಮಾಸು ಕಿಮಪಿ ನಗರಂ ಪ್ರವಿಷ್ಟೇಷು ಲೋಕಾ ಯದಿ ಯುಷ್ಮಾಕಮ್ ಆತಿಥ್ಯಂ ಕರಿಷ್ಯನ್ತಿ, ತರ್ಹಿ ಯತ್ ಖಾದ್ಯಮ್ ಉಪಸ್ಥಾಸ್ಯನ್ತಿ ತದೇವ ಖಾದಿಷ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ತನ್ನಗರಸ್ಥಾನ್ ರೋಗಿಣಃ ಸ್ವಸ್ಥಾನ್ ಕರಿಷ್ಯಥ, ಈಶ್ವರೀಯಂ ರಾಜ್ಯಂ ಯುಷ್ಮಾಕಮ್ ಅನ್ತಿಕಮ್ ಆಗಮತ್ ಕಥಾಮೇತಾಞ್ಚ ಪ್ರಚಾರಯಿಷ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","ಕಿನ್ತು ಕಿಮಪಿ ಪುರಂ ಯುಷ್ಮಾಸು ಪ್ರವಿಷ್ಟೇಷು ಲೋಕಾ ಯದಿ ಯುಷ್ಮಾಕಮ್ ಆತಿಥ್ಯಂ ನ ಕರಿಷ್ಯನ್ತಿ, ತರ್ಹಿ ತಸ್ಯ ನಗರಸ್ಯ ಪನ್ಥಾನಂ ಗತ್ವಾ ಕಥಾಮೇತಾಂ ವದಿಷ್ಯಥ, ");
INSERT INTO sankan_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","ಯುಷ್ಮಾಕಂ ನಗರೀಯಾ ಯಾ ಧೂಲ್ಯೋಽಸ್ಮಾಸು ಸಮಲಗನ್ ತಾ ಅಪಿ ಯುಷ್ಮಾಕಂ ಪ್ರಾತಿಕೂಲ್ಯೇನ ಸಾಕ್ಷ್ಯಾರ್ಥಂ ಸಮ್ಪಾತಯಾಮಃ; ತಥಾಪೀಶ್ವರರಾಜ್ಯಂ ಯುಷ್ಮಾಕಂ ಸಮೀಪಮ್ ಆಗತಮ್ ಇತಿ ನಿಶ್ಚಿತಂ ಜಾನೀತ| ");
INSERT INTO sankan_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","ಅಹಂ ಯುಷ್ಮಭ್ಯಂ ಯಥಾರ್ಥಂ ಕಥಯಾಮಿ, ವಿಚಾರದಿನೇ ತಸ್ಯ ನಗರಸ್ಯ ದಶಾತಃ ಸಿದೋಮೋ ದಶಾ ಸಹ್ಯಾ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","ಹಾ ಹಾ ಕೋರಾಸೀನ್ ನಗರ, ಹಾ ಹಾ ಬೈತ್ಸೈದಾನಗರ ಯುವಯೋರ್ಮಧ್ಯೇ ಯಾದೃಶಾನಿ ಆಶ್ಚರ್ಯ್ಯಾಣಿ ಕರ್ಮ್ಮಾಣ್ಯಕ್ರಿಯನ್ತ, ತಾನಿ ಕರ್ಮ್ಮಾಣಿ ಯದಿ ಸೋರಸೀದೋನೋ ರ್ನಗರಯೋರಕಾರಿಷ್ಯನ್ತ, ತದಾ ಇತೋ ಬಹುದಿನಪೂರ್ವ್ವಂ ತನ್ನಿವಾಸಿನಃ ಶಣವಸ್ತ್ರಾಣಿ ಪರಿಧಾಯ ಗಾತ್ರೇಷು ಭಸ್ಮ ವಿಲಿಪ್ಯ ಸಮುಪವಿಶ್ಯ ಸಮಖೇತ್ಸ್ಯನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","ಅತೋ ವಿಚಾರದಿವಸೇ ಯುಷ್ಮಾಕಂ ದಶಾತಃ ಸೋರಸೀದೋನ್ನಿವಾಸಿನಾಂ ದಶಾ ಸಹ್ಯಾ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ಹೇ ಕಫರ್ನಾಹೂಮ್, ತ್ವಂ ಸ್ವರ್ಗಂ ಯಾವದ್ ಉನ್ನತಾ ಕಿನ್ತು ನರಕಂ ಯಾವತ್ ನ್ಯಗ್ಭವಿಷ್ಯಸಿ| ");
INSERT INTO sankan_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ಯೋ ಜನೋ ಯುಷ್ಮಾಕಂ ವಾಕ್ಯಂ ಗೃಹ್ಲಾತಿ ಸ ಮಮೈವ ವಾಕ್ಯಂ ಗೃಹ್ಲಾತಿ; ಕಿಞ್ಚ ಯೋ ಜನೋ ಯುಷ್ಮಾಕಮ್ ಅವಜ್ಞಾಂ ಕರೋತಿ ಸ ಮಮೈವಾವಜ್ಞಾಂ ಕರೋತಿ; ಯೋ ಜನೋ ಮಮಾವಜ್ಞಾಂ ಕರೋತಿ ಚ ಸ ಮತ್ಪ್ರೇರಕಸ್ಯೈವಾವಜ್ಞಾಂ ಕರೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","ಅಥ ತೇ ಸಪ್ತತಿಶಿಷ್ಯಾ ಆನನ್ದೇನ ಪ್ರತ್ಯಾಗತ್ಯ ಕಥಯಾಮಾಸುಃ, ಹೇ ಪ್ರಭೋ ಭವತೋ ನಾಮ್ನಾ ಭೂತಾ ಅಪ್ಯಸ್ಮಾಕಂ ವಶೀಭವನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ತದಾನೀಂ ಸ ತಾನ್ ಜಗಾದ, ವಿದ್ಯುತಮಿವ ಸ್ವರ್ಗಾತ್ ಪತನ್ತಂ ಶೈತಾನಮ್ ಅದರ್ಶಮ್| ");
INSERT INTO sankan_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","ಪಶ್ಯತ ಸರ್ಪಾನ್ ವೃಶ್ಚಿಕಾನ್ ರಿಪೋಃ ಸರ್ವ್ವಪರಾಕ್ರಮಾಂಶ್ಚ ಪದತಲೈ ರ್ದಲಯಿತುಂ ಯುಷ್ಮಭ್ಯಂ ಶಕ್ತಿಂ ದದಾಮಿ ತಸ್ಮಾದ್ ಯುಷ್ಮಾಕಂ ಕಾಪಿ ಹಾನಿ ರ್ನ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","ಭೂತಾ ಯುಷ್ಮಾಕಂ ವಶೀಭವನ್ತಿ, ಏತನ್ನಿಮಿತ್ತತ್ ಮಾ ಸಮುಲ್ಲಸತ, ಸ್ವರ್ಗೇ ಯುಷ್ಮಾಕಂ ನಾಮಾನಿ ಲಿಖಿತಾನಿ ಸನ್ತೀತಿ ನಿಮಿತ್ತಂ ಸಮುಲ್ಲಸತ| ");
INSERT INTO sankan_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","ತದ್ಘಟಿಕಾಯಾಂ ಯೀಶು ರ್ಮನಸಿ ಜಾತಾಹ್ಲಾದಃ ಕಥಯಾಮಾಸ ಹೇ ಸ್ವರ್ಗಪೃಥಿವ್ಯೋರೇಕಾಧಿಪತೇ ಪಿತಸ್ತ್ವಂ ಜ್ಞಾನವತಾಂ ವಿದುಷಾಞ್ಚ ಲೋಕಾನಾಂ ಪುರಸ್ತಾತ್ ಸರ್ವ್ವಮೇತದ್ ಅಪ್ರಕಾಶ್ಯ ಬಾಲಕಾನಾಂ ಪುರಸ್ತಾತ್ ಪ್ರಾಕಾಶಯ ಏತಸ್ಮಾದ್ಧೇತೋಸ್ತ್ವಾಂ ಧನ್ಯಂ ವದಾಮಿ, ಹೇ ಪಿತರಿತ್ಥಂ ಭವತು ಯದ್ ಏತದೇವ ತವ ಗೋಚರ ಉತ್ತಮಮ್| ");
INSERT INTO sankan_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","ಪಿತ್ರಾ ಸರ್ವ್ವಾಣಿ ಮಯಿ ಸಮರ್ಪಿತಾನಿ ಪಿತರಂ ವಿನಾ ಕೋಪಿ ಪುತ್ರಂ ನ ಜಾನಾತಿ ಕಿಞ್ಚ ಪುತ್ರಂ ವಿನಾ ಯಸ್ಮೈ ಜನಾಯ ಪುತ್ರಸ್ತಂ ಪ್ರಕಾಶಿತವಾನ್ ತಞ್ಚ ವಿನಾ ಕೋಪಿ ಪಿತರಂ ನ ಜಾನಾತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ತಪಃ ಪರಂ ಸ ಶಿಷ್ಯಾನ್ ಪ್ರತಿ ಪರಾವೃತ್ಯ ಗುಪ್ತಂ ಜಗಾದ, ಯೂಯಮೇತಾನಿ ಸರ್ವ್ವಾಣಿ ಪಶ್ಯಥ ತತೋ ಯುಷ್ಮಾಕಂ ಚಕ್ಷೂಂಷಿ ಧನ್ಯಾನಿ| ");
INSERT INTO sankan_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ಯುಷ್ಮಾನಹಂ ವದಾಮಿ, ಯೂಯಂ ಯಾನಿ ಸರ್ವ್ವಾಣಿ ಪಶ್ಯಥ ತಾನಿ ಬಹವೋ ಭವಿಷ್ಯದ್ವಾದಿನೋ ಭೂಪತಯಶ್ಚ ದ್ರಷ್ಟುಮಿಚ್ಛನ್ತೋಪಿ ದ್ರಷ್ಟುಂ ನ ಪ್ರಾಪ್ನುವನ್, ಯುಷ್ಮಾಭಿ ರ್ಯಾ ಯಾಃ ಕಥಾಶ್ಚ ಶ್ರೂಯನ್ತೇ ತಾಃ ಶ್ರೋತುಮಿಚ್ಛನ್ತೋಪಿ ಶ್ರೋತುಂ ನಾಲಭನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","ಅನನ್ತರಮ್ ಏಕೋ ವ್ಯವಸ್ಥಾಪಕ ಉತ್ಥಾಯ ತಂ ಪರೀಕ್ಷಿತುಂ ಪಪ್ರಚ್ಛ, ಹೇ ಉಪದೇಶಕ ಅನನ್ತಾಯುಷಃ ಪ್ರಾಪ್ತಯೇ ಮಯಾ ಕಿಂ ಕರಣೀಯಂ? ");
INSERT INTO sankan_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ಯೀಶುಃ ಪ್ರತ್ಯುವಾಚ, ಅತ್ರಾರ್ಥೇ ವ್ಯವಸ್ಥಾಯಾಂ ಕಿಂ ಲಿಖಿತಮಸ್ತಿ? ತ್ವಂ ಕೀದೃಕ್ ಪಠಸಿ? ");
INSERT INTO sankan_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ತತಃ ಸೋವದತ್, ತ್ವಂ ಸರ್ವ್ವಾನ್ತಃಕರಣೈಃ ಸರ್ವ್ವಪ್ರಾಣೈಃ ಸರ್ವ್ವಶಕ್ತಿಭಿಃ ಸರ್ವ್ವಚಿತ್ತೈಶ್ಚ ಪ್ರಭೌ ಪರಮೇಶ್ವರೇ ಪ್ರೇಮ ಕುರು, ಸಮೀಪವಾಸಿನಿ ಸ್ವವತ್ ಪ್ರೇಮ ಕುರು ಚ| ");
INSERT INTO sankan_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ತದಾ ಸ ಕಥಯಾಮಾಸ, ತ್ವಂ ಯಥಾರ್ಥಂ ಪ್ರತ್ಯವೋಚಃ, ಇತ್ಥಮ್ ಆಚರ ತೇನೈವ ಜೀವಿಷ್ಯಸಿ| ");
INSERT INTO sankan_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","ಕಿನ್ತು ಸ ಜನಃ ಸ್ವಂ ನಿರ್ದ್ದೋಷಂ ಜ್ಞಾಪಯಿತುಂ ಯೀಶುಂ ಪಪ್ರಚ್ಛ, ಮಮ ಸಮೀಪವಾಸೀ ಕಃ? ತತೋ ಯೀಶುಃ ಪ್ರತ್ಯುವಾಚ, ");
INSERT INTO sankan_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ಏಕೋ ಜನೋ ಯಿರೂಶಾಲಮ್ಪುರಾದ್ ಯಿರೀಹೋಪುರಂ ಯಾತಿ, ಏತರ್ಹಿ ದಸ್ಯೂನಾಂ ಕರೇಷು ಪತಿತೇ ತೇ ತಸ್ಯ ವಸ್ತ್ರಾದಿಕಂ ಹೃತವನ್ತಃ ತಮಾಹತ್ಯ ಮೃತಪ್ರಾಯಂ ಕೃತ್ವಾ ತ್ಯಕ್ತ್ವಾ ಯಯುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ಅಕಸ್ಮಾದ್ ಏಕೋ ಯಾಜಕಸ್ತೇನ ಮಾರ್ಗೇಣ ಗಚ್ಛನ್ ತಂ ದೃಷ್ಟ್ವಾ ಮಾರ್ಗಾನ್ಯಪಾರ್ಶ್ವೇನ ಜಗಾಮ| ");
INSERT INTO sankan_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ಇತ್ಥಮ್ ಏಕೋ ಲೇವೀಯಸ್ತತ್ಸ್ಥಾನಂ ಪ್ರಾಪ್ಯ ತಸ್ಯಾನ್ತಿಕಂ ಗತ್ವಾ ತಂ ವಿಲೋಕ್ಯಾನ್ಯೇನ ಪಾರ್ಶ್ವೇನ ಜಗಾಮ| ");
INSERT INTO sankan_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","ಕಿನ್ತ್ವೇಕಃ ಶೋಮಿರೋಣೀಯೋ ಗಚ್ಛನ್ ತತ್ಸ್ಥಾನಂ ಪ್ರಾಪ್ಯ ತಂ ದೃಷ್ಟ್ವಾದಯತ| ");
INSERT INTO sankan_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ತಸ್ಯಾನ್ತಿಕಂ ಗತ್ವಾ ತಸ್ಯ ಕ್ಷತೇಷು ತೈಲಂ ದ್ರಾಕ್ಷಾರಸಞ್ಚ ಪ್ರಕ್ಷಿಪ್ಯ ಕ್ಷತಾನಿ ಬದ್ಧ್ವಾ ನಿಜವಾಹನೋಪರಿ ತಮುಪವೇಶ್ಯ ಪ್ರವಾಸೀಯಗೃಹಮ್ ಆನೀಯ ತಂ ಸಿಷೇವೇ| ");
INSERT INTO sankan_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","ಪರಸ್ಮಿನ್ ದಿವಸೇ ನಿಜಗಮನಕಾಲೇ ದ್ವೌ ಮುದ್ರಾಪಾದೌ ತದ್ಗೃಹಸ್ವಾಮಿನೇ ದತ್ತ್ವಾವದತ್ ಜನಮೇನಂ ಸೇವಸ್ವ ತತ್ರ ಯೋಽಧಿಕೋ ವ್ಯಯೋ ಭವಿಷ್ಯತಿ ತಮಹಂ ಪುನರಾಗಮನಕಾಲೇ ಪರಿಶೋತ್ಸ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","ಏಷಾಂ ತ್ರಯಾಣಾಂ ಮಧ್ಯೇ ತಸ್ಯ ದಸ್ಯುಹಸ್ತಪತಿತಸ್ಯ ಜನಸ್ಯ ಸಮೀಪವಾಸೀ ಕಃ? ತ್ವಯಾ ಕಿಂ ಬುಧ್ಯತೇ? ");
INSERT INTO sankan_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ತತಃ ಸ ವ್ಯವಸ್ಥಾಪಕಃ ಕಥಯಾಮಾಸ ಯಸ್ತಸ್ಮಿನ್ ದಯಾಂ ಚಕಾರ| ತದಾ ಯೀಶುಃ ಕಥಯಾಮಾಸ ತ್ವಮಪಿ ಗತ್ವಾ ತಥಾಚರ| ");
INSERT INTO sankan_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","ತತಃ ಪರಂ ತೇ ಗಚ್ಛನ್ತ ಏಕಂ ಗ್ರಾಮಂ ಪ್ರವಿವಿಶುಃ; ತದಾ ಮರ್ಥಾನಾಮಾ ಸ್ತ್ರೀ ಸ್ವಗೃಹೇ ತಸ್ಯಾತಿಥ್ಯಂ ಚಕಾರ| ");
INSERT INTO sankan_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","ತಸ್ಮಾತ್ ಮರಿಯಮ್ ನಾಮಧೇಯಾ ತಸ್ಯಾ ಭಗಿನೀ ಯೀಶೋಃ ಪದಸಮೀಪ ಉವವಿಶ್ಯ ತಸ್ಯೋಪದೇಶಕಥಾಂ ಶ್ರೋತುಮಾರೇಭೇ| ");
INSERT INTO sankan_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","ಕಿನ್ತು ಮರ್ಥಾ ನಾನಾಪರಿಚರ್ಯ್ಯಾಯಾಂ ವ್ಯಗ್ರಾ ಬಭೂವ ತಸ್ಮಾದ್ಧೇತೋಸ್ತಸ್ಯ ಸಮೀಪಮಾಗತ್ಯ ಬಭಾಷೇ; ಹೇ ಪ್ರಭೋ ಮಮ ಭಗಿನೀ ಕೇವಲಂ ಮಮೋಪರಿ ಸರ್ವ್ವಕರ್ಮ್ಮಣಾಂ ಭಾರಮ್ ಅರ್ಪಿತವತೀ ತತ್ರ ಭವತಾ ಕಿಞ್ಚಿದಪಿ ನ ಮನೋ ನಿಧೀಯತೇ ಕಿಮ್? ಮಮ ಸಾಹಾಯ್ಯಂ ಕರ್ತ್ತುಂ ಭವಾನ್ ತಾಮಾದಿಶತು| ");
INSERT INTO sankan_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ತತೋ ಯೀಶುಃ ಪ್ರತ್ಯುವಾಚ ಹೇ ಮರ್ಥೇ ಹೇ ಮರ್ಥೇ, ತ್ವಂ ನಾನಾಕಾರ್ಯ್ಯೇಷು ಚಿನ್ತಿತವತೀ ವ್ಯಗ್ರಾ ಚಾಸಿ, ");
INSERT INTO sankan_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ಕಿನ್ತು ಪ್ರಯೋಜನೀಯಮ್ ಏಕಮಾತ್ರಮ್ ಆಸ್ತೇ| ಅಪರಞ್ಚ ಯಮುತ್ತಮಂ ಭಾಗಂ ಕೋಪಿ ಹರ್ತ್ತುಂ ನ ಶಕ್ನೋತಿ ಸಏವ ಮರಿಯಮಾ ವೃತಃ| ");
INSERT INTO sankan_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","ಅನನ್ತರಂ ಸ ಕಸ್ಮಿಂಶ್ಚಿತ್ ಸ್ಥಾನೇ ಪ್ರಾರ್ಥಯತ ತತ್ಸಮಾಪ್ತೌ ಸತ್ಯಾಂ ತಸ್ಯೈಕಃ ಶಿಷ್ಯಸ್ತಂ ಜಗಾದ ಹೇ ಪ್ರಭೋ ಯೋಹನ್ ಯಥಾ ಸ್ವಶಿಷ್ಯಾನ್ ಪ್ರಾರ್ಥಯಿತುಮ್ ಉಪದಿಷ್ಟವಾನ್ ತಥಾ ಭವಾನಪ್ಯಸ್ಮಾನ್ ಉಪದಿಶತು| ");
INSERT INTO sankan_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","ತಸ್ಮಾತ್ ಸ ಕಥಯಾಮಾಸ, ಪ್ರಾರ್ಥನಕಾಲೇ ಯೂಯಮ್ ಇತ್ಥಂ ಕಥಯಧ್ವಂ, ಹೇ ಅಸ್ಮಾಕಂ ಸ್ವರ್ಗಸ್ಥಪಿತಸ್ತವ ನಾಮ ಪೂಜ್ಯಂ ಭವತು; ತವ ರಾಜತ್ವಂ ಭವತು; ಸ್ವರ್ಗೇ ಯಥಾ ತಥಾ ಪೃಥಿವ್ಯಾಮಪಿ ತವೇಚ್ಛಯಾ ಸರ್ವ್ವಂ ಭವತು| ");
INSERT INTO sankan_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ಪ್ರತ್ಯಹಮ್ ಅಸ್ಮಾಕಂ ಪ್ರಯೋಜನೀಯಂ ಭೋಜ್ಯಂ ದೇಹಿ| ");
INSERT INTO sankan_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ಯಥಾ ವಯಂ ಸರ್ವ್ವಾನ್ ಅಪರಾಧಿನಃ ಕ್ಷಮಾಮಹೇ ತಥಾ ತ್ವಮಪಿ ಪಾಪಾನ್ಯಸ್ಮಾಕಂ ಕ್ಷಮಸ್ವ| ಅಸ್ಮಾನ್ ಪರೀಕ್ಷಾಂ ಮಾನಯ ಕಿನ್ತು ಪಾಪಾತ್ಮನೋ ರಕ್ಷ| ");
INSERT INTO sankan_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ಪಶ್ಚಾತ್ ಸೋಪರಮಪಿ ಕಥಿತವಾನ್ ಯದಿ ಯುಷ್ಮಾಕಂ ಕಸ್ಯಚಿದ್ ಬನ್ಧುಸ್ತಿಷ್ಠತಿ ನಿಶೀಥೇ ಚ ತಸ್ಯ ಸಮೀಪಂ ಸ ಗತ್ವಾ ವದತಿ, ");
INSERT INTO sankan_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ಹೇ ಬನ್ಧೋ ಪಥಿಕ ಏಕೋ ಬನ್ಧು ರ್ಮಮ ನಿವೇಶನಮ್ ಆಯಾತಃ ಕಿನ್ತು ತಸ್ಯಾತಿಥ್ಯಂ ಕರ್ತ್ತುಂ ಮಮಾನ್ತಿಕೇ ಕಿಮಪಿ ನಾಸ್ತಿ, ಅತಏವ ಪೂಪತ್ರಯಂ ಮಹ್ಯಮ್ ಋಣಂ ದೇಹಿ; ");
INSERT INTO sankan_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ತದಾ ಸ ಯದಿ ಗೃಹಮಧ್ಯಾತ್ ಪ್ರತಿವದತಿ ಮಾಂ ಮಾ ಕ್ಲಿಶಾನ, ಇದಾನೀಂ ದ್ವಾರಂ ರುದ್ಧಂ ಶಯನೇ ಮಯಾ ಸಹ ಬಾಲಕಾಶ್ಚ ತಿಷ್ಠನ್ತಿ ತುಭ್ಯಂ ದಾತುಮ್ ಉತ್ಥಾತುಂ ನ ಶಕ್ನೋಮಿ, ");
INSERT INTO sankan_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","ತರ್ಹಿ ಯುಷ್ಮಾನಹಂ ವದಾಮಿ, ಸ ಯದಿ ಮಿತ್ರತಯಾ ತಸ್ಮೈ ಕಿಮಪಿ ದಾತುಂ ನೋತ್ತಿಷ್ಠತಿ ತಥಾಪಿ ವಾರಂ ವಾರಂ ಪ್ರಾರ್ಥನಾತ ಉತ್ಥಾಪಿತಃ ಸನ್ ಯಸ್ಮಿನ್ ತಸ್ಯ ಪ್ರಯೋಜನಂ ತದೇವ ದಾಸ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","ಅತಃ ಕಾರಣಾತ್ ಕಥಯಾಮಿ, ಯಾಚಧ್ವಂ ತತೋ ಯುಷ್ಮಭ್ಯಂ ದಾಸ್ಯತೇ, ಮೃಗಯಧ್ವಂ ತತ ಉದ್ದೇಶಂ ಪ್ರಾಪ್ಸ್ಯಥ, ದ್ವಾರಮ್ ಆಹತ ತತೋ ಯುಷ್ಮಭ್ಯಂ ದ್ವಾರಂ ಮೋಕ್ಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","ಯೋ ಯಾಚತೇ ಸ ಪ್ರಾಪ್ನೋತಿ, ಯೋ ಮೃಗಯತೇ ಸ ಏವೋದ್ದೇಶಂ ಪ್ರಾಪ್ನೋತಿ, ಯೋ ದ್ವಾರಮ್ ಆಹನ್ತಿ ತದರ್ಥಂ ದ್ವಾರಂ ಮೋಚ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","ಪುತ್ರೇಣ ಪೂಪೇ ಯಾಚಿತೇ ತಸ್ಮೈ ಪಾಷಾಣಂ ದದಾತಿ ವಾ ಮತ್ಸ್ಯೇ ಯಾಚಿತೇ ತಸ್ಮೈ ಸರ್ಪಂ ದದಾತಿ ");
INSERT INTO sankan_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ವಾ ಅಣ್ಡೇ ಯಾಚಿತೇ ತಸ್ಮೈ ವೃಶ್ಚಿಕಂ ದದಾತಿ ಯುಷ್ಮಾಕಂ ಮಧ್ಯೇ ಕ ಏತಾದೃಶಃ ಪಿತಾಸ್ತೇ? ");
INSERT INTO sankan_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ತಸ್ಮಾದೇವ ಯೂಯಮಭದ್ರಾ ಅಪಿ ಯದಿ ಸ್ವಸ್ವಬಾಲಕೇಭ್ಯ ಉತ್ತಮಾನಿ ದ್ರವ್ಯಾಣಿ ದಾತುಂ ಜಾನೀಥ ತರ್ಹ್ಯಸ್ಮಾಕಂ ಸ್ವರ್ಗಸ್ಥಃ ಪಿತಾ ನಿಜಯಾಚಕೇಭ್ಯಃ ಕಿಂ ಪವಿತ್ರಮ್ ಆತ್ಮಾನಂ ನ ದಾಸ್ಯತಿ? ");
INSERT INTO sankan_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","ಅನನ್ತರಂ ಯೀಶುನಾ ಕಸ್ಮಾಚ್ಚಿದ್ ಏಕಸ್ಮಿನ್ ಮೂಕಭೂತೇ ತ್ಯಾಜಿತೇ ಸತಿ ಸ ಭೂತತ್ಯಕ್ತೋ ಮಾನುಷೋ ವಾಕ್ಯಂ ವಕ್ತುಮ್ ಆರೇಭೇ; ತತೋ ಲೋಕಾಃ ಸಕಲಾ ಆಶ್ಚರ್ಯ್ಯಂ ಮೇನಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ಕಿನ್ತು ತೇಷಾಂ ಕೇಚಿದೂಚು ರ್ಜನೋಯಂ ಬಾಲಸಿಬೂಬಾ ಅರ್ಥಾದ್ ಭೂತರಾಜೇನ ಭೂತಾನ್ ತ್ಯಾಜಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ತಂ ಪರೀಕ್ಷಿತುಂ ಕೇಚಿದ್ ಆಕಾಶೀಯಮ್ ಏಕಂ ಚಿಹ್ನಂ ದರ್ಶಯಿತುಂ ತಂ ಪ್ರಾರ್ಥಯಾಞ್ಚಕ್ರಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","ತದಾ ಸ ತೇಷಾಂ ಮನಃಕಲ್ಪನಾಂ ಜ್ಞಾತ್ವಾ ಕಥಯಾಮಾಸ, ಕಸ್ಯಚಿದ್ ರಾಜ್ಯಸ್ಯ ಲೋಕಾ ಯದಿ ಪರಸ್ಪರಂ ವಿರುನ್ಧನ್ತಿ ತರ್ಹಿ ತದ್ ರಾಜ್ಯಮ್ ನಶ್ಯತಿ; ಕೇಚಿದ್ ಗೃಹಸ್ಥಾ ಯದಿ ಪರಸ್ಪರಂ ವಿರುನ್ಧನ್ತಿ ತರ್ಹಿ ತೇಪಿ ನಶ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","ತಥೈವ ಶೈತಾನಪಿ ಸ್ವಲೋಕಾನ್ ಯದಿ ವಿರುಣದ್ಧಿ ತದಾ ತಸ್ಯ ರಾಜ್ಯಂ ಕಥಂ ಸ್ಥಾಸ್ಯತಿ? ಬಾಲಸಿಬೂಬಾಹಂ ಭೂತಾನ್ ತ್ಯಾಜಯಾಮಿ ಯೂಯಮಿತಿ ವದಥ| ");
INSERT INTO sankan_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ಯದ್ಯಹಂ ಬಾಲಸಿಬೂಬಾ ಭೂತಾನ್ ತ್ಯಾಜಯಾಮಿ ತರ್ಹಿ ಯುಷ್ಮಾಕಂ ಸನ್ತಾನಾಃ ಕೇನ ತ್ಯಾಜಯನ್ತಿ? ತಸ್ಮಾತ್ ತಏವ ಕಥಾಯಾ ಏತಸ್ಯಾ ವಿಚಾರಯಿತಾರೋ ಭವಿಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","ಕಿನ್ತು ಯದ್ಯಹಮ್ ಈಶ್ವರಸ್ಯ ಪರಾಕ್ರಮೇಣ ಭೂತಾನ್ ತ್ಯಾಜಯಾಮಿ ತರ್ಹಿ ಯುಷ್ಮಾಕಂ ನಿಕಟಮ್ ಈಶ್ವರಸ್ಯ ರಾಜ್ಯಮವಶ್ಯಮ್ ಉಪತಿಷ್ಠತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","ಬಲವಾನ್ ಪುಮಾನ್ ಸುಸಜ್ಜಮಾನೋ ಯತಿಕಾಲಂ ನಿಜಾಟ್ಟಾಲಿಕಾಂ ರಕ್ಷತಿ ತತಿಕಾಲಂ ತಸ್ಯ ದ್ರವ್ಯಂ ನಿರುಪದ್ರವಂ ತಿಷ್ಠತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","ಕಿನ್ತು ತಸ್ಮಾದ್ ಅಧಿಕಬಲಃ ಕಶ್ಚಿದಾಗತ್ಯ ಯದಿ ತಂ ಜಯತಿ ತರ್ಹಿ ಯೇಷು ಶಸ್ತ್ರಾಸ್ತ್ರೇಷು ತಸ್ಯ ವಿಶ್ವಾಸ ಆಸೀತ್ ತಾನಿ ಸರ್ವ್ವಾಣಿ ಹೃತ್ವಾ ತಸ್ಯ ದ್ರವ್ಯಾಣಿ ಗೃಹ್ಲಾತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","ಅತಃ ಕಾರಣಾದ್ ಯೋ ಮಮ ಸಪಕ್ಷೋ ನ ಸ ವಿಪಕ್ಷಃ, ಯೋ ಮಯಾ ಸಹ ನ ಸಂಗೃಹ್ಲಾತಿ ಸ ವಿಕಿರತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","ಅಪರಞ್ಚ ಅಮೇಧ್ಯಭೂತೋ ಮಾನುಷಸ್ಯಾನ್ತರ್ನಿರ್ಗತ್ಯ ಶುಷ್ಕಸ್ಥಾನೇ ಭ್ರಾನ್ತ್ವಾ ವಿಶ್ರಾಮಂ ಮೃಗಯತೇ ಕಿನ್ತು ನ ಪ್ರಾಪ್ಯ ವದತಿ ಮಮ ಯಸ್ಮಾದ್ ಗೃಹಾದ್ ಆಗತೋಹಂ ಪುನಸ್ತದ್ ಗೃಹಂ ಪರಾವೃತ್ಯ ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ತತೋ ಗತ್ವಾ ತದ್ ಗೃಹಂ ಮಾರ್ಜಿತಂ ಶೋಭಿತಞ್ಚ ದೃಷ್ಟ್ವಾ ");
INSERT INTO sankan_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ತತ್ಕ್ಷಣಮ್ ಅಪಗತ್ಯ ಸ್ವಸ್ಮಾದಪಿ ದುರ್ಮ್ಮತೀನ್ ಅಪರಾನ್ ಸಪ್ತಭೂತಾನ್ ಸಹಾನಯತಿ ತೇ ಚ ತದ್ಗೃಹಂ ಪವಿಶ್ಯ ನಿವಸನ್ತಿ| ತಸ್ಮಾತ್ ತಸ್ಯ ಮನುಷ್ಯಸ್ಯ ಪ್ರಥಮದಶಾತಃ ಶೇಷದಶಾ ದುಃಖತರಾ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","ಅಸ್ಯಾಃ ಕಥಾಯಾಃ ಕಥನಕಾಲೇ ಜನತಾಮಧ್ಯಸ್ಥಾ ಕಾಚಿನ್ನಾರೀ ತಮುಚ್ಚೈಃಸ್ವರಂ ಪ್ರೋವಾಚ, ಯಾ ಯೋಷಿತ್ ತ್ವಾಂ ಗರ್ಬ್ಭೇಽಧಾರಯತ್ ಸ್ತನ್ಯಮಪಾಯಯಚ್ಚ ಸೈವ ಧನ್ಯಾ| ");
INSERT INTO sankan_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","ಕಿನ್ತು ಸೋಕಥಯತ್ ಯೇ ಪರಮೇಶ್ವರಸ್ಯ ಕಥಾಂ ಶ್ರುತ್ವಾ ತದನುರೂಪಮ್ ಆಚರನ್ತಿ ತಏವ ಧನ್ಯಾಃ| ");
INSERT INTO sankan_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","ತತಃ ಪರಂ ತಸ್ಯಾನ್ತಿಕೇ ಬಹುಲೋಕಾನಾಂ ಸಮಾಗಮೇ ಜಾತೇ ಸ ವಕ್ತುಮಾರೇಭೇ, ಆಧುನಿಕಾ ದುಷ್ಟಲೋಕಾಶ್ಚಿಹ್ನಂ ದ್ರಷ್ಟುಮಿಚ್ಛನ್ತಿ ಕಿನ್ತು ಯೂನಸ್ಭವಿಷ್ಯದ್ವಾದಿನಶ್ಚಿಹ್ನಂ ವಿನಾನ್ಯತ್ ಕಿಞ್ಚಿಚ್ಚಿಹ್ನಂ ತಾನ್ ನ ದರ್ಶಯಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","ಯೂನಸ್ ತು ಯಥಾ ನೀನಿವೀಯಲೋಕಾನಾಂ ಸಮೀಪೇ ಚಿಹ್ನರೂಪೋಭವತ್ ತಥಾ ವಿದ್ಯಮಾನಲೋಕಾನಾಮ್ ಏಷಾಂ ಸಮೀಪೇ ಮನುಷ್ಯಪುತ್ರೋಪಿ ಚಿಹ್ನರೂಪೋ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ವಿಚಾರಸಮಯೇ ಇದಾನೀನ್ತನಲೋಕಾನಾಂ ಪ್ರಾತಿಕೂಲ್ಯೇನ ದಕ್ಷಿಣದೇಶೀಯಾ ರಾಜ್ಞೀ ಪ್ರೋತ್ಥಾಯ ತಾನ್ ದೋಷಿಣಃ ಕರಿಷ್ಯತಿ, ಯತಃ ಸಾ ರಾಜ್ಞೀ ಸುಲೇಮಾನ ಉಪದೇಶಕಥಾಂ ಶ್ರೋತುಂ ಪೃಥಿವ್ಯಾಃ ಸೀಮಾತ ಆಗಚ್ಛತ್ ಕಿನ್ತು ಪಶ್ಯತ ಸುಲೇಮಾನೋಪಿ ಗುರುತರ ಏಕೋ ಜನೋಽಸ್ಮಿನ್ ಸ್ಥಾನೇ ವಿದ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","ಅಪರಞ್ಚ ವಿಚಾರಸಮಯೇ ನೀನಿವೀಯಲೋಕಾ ಅಪಿ ವರ್ತ್ತಮಾನಕಾಲಿಕಾನಾಂ ಲೋಕಾನಾಂ ವೈಪರೀತ್ಯೇನ ಪ್ರೋತ್ಥಾಯ ತಾನ್ ದೋಷಿಣಃ ಕರಿಷ್ಯನ್ತಿ, ಯತೋ ಹೇತೋಸ್ತೇ ಯೂನಸೋ ವಾಕ್ಯಾತ್ ಚಿತ್ತಾನಿ ಪರಿವರ್ತ್ತಯಾಮಾಸುಃ ಕಿನ್ತು ಪಶ್ಯತ ಯೂನಸೋತಿಗುರುತರ ಏಕೋ ಜನೋಽಸ್ಮಿನ್ ಸ್ಥಾನೇ ವಿದ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","ಪ್ರದೀಪಂ ಪ್ರಜ್ವಾಲ್ಯ ದ್ರೋಣಸ್ಯಾಧಃ ಕುತ್ರಾಪಿ ಗುಪ್ತಸ್ಥಾನೇ ವಾ ಕೋಪಿ ನ ಸ್ಥಾಪಯತಿ ಕಿನ್ತು ಗೃಹಪ್ರವೇಶಿಭ್ಯೋ ದೀಪ್ತಿಂ ದಾತಂ ದೀಪಾಧಾರೋಪರ್ಯ್ಯೇವ ಸ್ಥಾಪಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","ದೇಹಸ್ಯ ಪ್ರದೀಪಶ್ಚಕ್ಷುಸ್ತಸ್ಮಾದೇವ ಚಕ್ಷು ರ್ಯದಿ ಪ್ರಸನ್ನಂ ಭವತಿ ತರ್ಹಿ ತವ ಸರ್ವ್ವಶರೀರಂ ದೀಪ್ತಿಮದ್ ಭವಿಷ್ಯತಿ ಕಿನ್ತು ಚಕ್ಷು ರ್ಯದಿ ಮಲೀಮಸಂ ತಿಷ್ಠತಿ ತರ್ಹಿ ಸರ್ವ್ವಶರೀರಂ ಸಾನ್ಧಕಾರಂ ಸ್ಥಾಸ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","ಅಸ್ಮಾತ್ ಕಾರಣಾತ್ ತವಾನ್ತಃಸ್ಥಂ ಜ್ಯೋತಿ ರ್ಯಥಾನ್ಧಕಾರಮಯಂ ನ ಭವತಿ ತದರ್ಥೇ ಸಾವಧಾನೋ ಭವ| ");
INSERT INTO sankan_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","ಯತಃ ಶರೀರಸ್ಯ ಕುತ್ರಾಪ್ಯಂಶೇ ಸಾನ್ಧಕಾರೇ ನ ಜಾತೇ ಸರ್ವ್ವಂ ಯದಿ ದೀಪ್ತಿಮತ್ ತಿಷ್ಠತಿ ತರ್ಹಿ ತುಭ್ಯಂ ದೀಪ್ತಿದಾಯಿಪ್ರೋಜ್ಜ್ವಲನ್ ಪ್ರದೀಪ ಇವ ತವ ಸವರ್ವಶರೀರಂ ದೀಪ್ತಿಮದ್ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ಏತತ್ಕಥಾಯಾಃ ಕಥನಕಾಲೇ ಫಿರುಶ್ಯೇಕೋ ಭೇಜನಾಯ ತಂ ನಿಮನ್ತ್ರಯಾಮಾಸ, ತತಃ ಸ ಗತ್ವಾ ಭೋಕ್ತುಮ್ ಉಪವಿವೇಶ| ");
INSERT INTO sankan_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ಕಿನ್ತು ಭೋಜನಾತ್ ಪೂರ್ವ್ವಂ ನಾಮಾಙ್ಕ್ಷೀತ್ ಏತದ್ ದೃಷ್ಟ್ವಾ ಸ ಫಿರುಶ್ಯಾಶ್ಚರ್ಯ್ಯಂ ಮೇನೇ| ");
INSERT INTO sankan_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","ತದಾ ಪ್ರಭುಸ್ತಂ ಪ್ರೋವಾಚ ಯೂಯಂ ಫಿರೂಶಿಲೋಕಾಃ ಪಾನಪಾತ್ರಾಣಾಂ ಭೋಜನಪಾತ್ರಾಣಾಞ್ಚ ಬಹಿಃ ಪರಿಷ್ಕುರುಥ ಕಿನ್ತು ಯುಷ್ಮಾಕಮನ್ತ ರ್ದೌರಾತ್ಮ್ಯೈ ರ್ದುಷ್ಕ್ರಿಯಾಭಿಶ್ಚ ಪರಿಪೂರ್ಣಂ ತಿಷ್ಠತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ಹೇ ಸರ್ವ್ವೇ ನಿರ್ಬೋಧಾ ಯೋ ಬಹಿಃ ಸಸರ್ಜ ಸ ಏವ ಕಿಮನ್ತ ರ್ನ ಸಸರ್ಜ? ");
INSERT INTO sankan_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","ತತ ಏವ ಯುಷ್ಮಾಭಿರನ್ತಃಕರಣಂ (ಈಶ್ವರಾಯ) ನಿವೇದ್ಯತಾಂ ತಸ್ಮಿನ್ ಕೃತೇ ಯುಷ್ಮಾಕಂ ಸರ್ವ್ವಾಣಿ ಶುಚಿತಾಂ ಯಾಸ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","ಕಿನ್ತು ಹನ್ತ ಫಿರೂಶಿಗಣಾ ಯೂಯಂ ನ್ಯಾಯಮ್ ಈಶ್ವರೇ ಪ್ರೇಮ ಚ ಪರಿತ್ಯಜ್ಯ ಪೋದಿನಾಯಾ ಅರುದಾದೀನಾಂ ಸರ್ವ್ವೇಷಾಂ ಶಾಕಾನಾಞ್ಚ ದಶಮಾಂಶಾನ್ ದತ್ಥ ಕಿನ್ತು ಪ್ರಥಮಂ ಪಾಲಯಿತ್ವಾ ಶೇಷಸ್ಯಾಲಙ್ಘನಂ ಯುಷ್ಮಾಕಮ್ ಉಚಿತಮಾಸೀತ್| ");
INSERT INTO sankan_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","ಹಾ ಹಾ ಫಿರೂಶಿನೋ ಯೂಯಂ ಭಜನಗೇಹೇ ಪ್ರೋಚ್ಚಾಸನೇ ಆಪಣೇಷು ಚ ನಮಸ್ಕಾರೇಷು ಪ್ರೀಯಧ್ವೇ| ");
INSERT INTO sankan_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","ವತ ಕಪಟಿನೋಽಧ್ಯಾಪಕಾಃ ಫಿರೂಶಿನಶ್ಚ ಲೋಕಾಯತ್ ಶ್ಮಶಾನಮ್ ಅನುಪಲಭ್ಯ ತದುಪರಿ ಗಚ್ಛನ್ತಿ ಯೂಯಮ್ ತಾದೃಗಪ್ರಕಾಶಿತಶ್ಮಶಾನವಾದ್ ಭವಥ| ");
INSERT INTO sankan_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ತದಾನೀಂ ವ್ಯವಸ್ಥಾಪಕಾನಾಮ್ ಏಕಾ ಯೀಶುಮವದತ್, ಹೇ ಉಪದೇಶಕ ವಾಕ್ಯೇನೇದೃಶೇನಾಸ್ಮಾಸ್ವಪಿ ದೋಷಮ್ ಆರೋಪಯಸಿ| ");
INSERT INTO sankan_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ತತಃ ಸ ಉವಾಚ, ಹಾ ಹಾ ವ್ಯವಸ್ಥಾಪಕಾ ಯೂಯಮ್ ಮಾನುಷಾಣಾಮ್ ಉಪರಿ ದುಃಸಹ್ಯಾನ್ ಭಾರಾನ್ ನ್ಯಸ್ಯಥ ಕಿನ್ತು ಸ್ವಯಮ್ ಏಕಾಙ್ಗುुಲ್ಯಾಪಿ ತಾನ್ ಭಾರಾನ್ ನ ಸ್ಪೃಶಥ| ");
INSERT INTO sankan_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","ಹನ್ತ ಯುಷ್ಮಾಕಂ ಪೂರ್ವ್ವಪುರುಷಾ ಯಾನ್ ಭವಿಷ್ಯದ್ವಾದಿನೋಽವಧಿಷುಸ್ತೇಷಾಂ ಶ್ಮಶಾನಾನಿ ಯೂಯಂ ನಿರ್ಮ್ಮಾಥ| ");
INSERT INTO sankan_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","ತೇನೈವ ಯೂಯಂ ಸ್ವಪೂರ್ವ್ವಪುರುಷಾಣಾಂ ಕರ್ಮ್ಮಾಣಿ ಸಂಮನ್ಯಧ್ವೇ ತದೇವ ಸಪ್ರಮಾಣಂ ಕುರುಥ ಚ, ಯತಸ್ತೇ ತಾನವಧಿಷುಃ ಯೂಯಂ ತೇಷಾಂ ಶ್ಮಶಾನಾನಿ ನಿರ್ಮ್ಮಾಥ| ");
INSERT INTO sankan_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ಅತಏವ ಈಶ್ವರಸ್ಯ ಶಾಸ್ತ್ರೇ ಪ್ರೋಕ್ತಮಸ್ತಿ ತೇಷಾಮನ್ತಿಕೇ ಭವಿಷ್ಯದ್ವಾದಿನಃ ಪ್ರೇರಿತಾಂಶ್ಚ ಪ್ರೇಷಯಿಷ್ಯಾಮಿ ತತಸ್ತೇ ತೇಷಾಂ ಕಾಂಶ್ಚನ ಹನಿಷ್ಯನ್ತಿ ಕಾಂಶ್ಚನ ತಾಡಶ್ಷ್ಯಿನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ಏತಸ್ಮಾತ್ ಕಾರಣಾತ್ ಹಾಬಿಲಃ ಶೋಣಿತಪಾತಮಾರಭ್ಯ ಮನ್ದಿರಯಜ್ಞವೇದ್ಯೋ ರ್ಮಧ್ಯೇ ಹತಸ್ಯ ಸಿಖರಿಯಸ್ಯ ರಕ್ತಪಾತಪರ್ಯ್ಯನ್ತಂ ");
INSERT INTO sankan_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ಜಗತಃ ಸೃಷ್ಟಿಮಾರಭ್ಯ ಪೃಥಿವ್ಯಾಂ ಭವಿಷ್ಯದ್ವಾದಿನಾಂ ಯತಿರಕ್ತಪಾತಾ ಜಾತಾಸ್ತತೀನಾಮ್ ಅಪರಾಧದಣ್ಡಾ ಏಷಾಂ ವರ್ತ್ತಮಾನಲೋಕಾನಾಂ ಭವಿಷ್ಯನ್ತಿ, ಯುಷ್ಮಾನಹಂ ನಿಶ್ಚಿತಂ ವದಾಮಿ ಸರ್ವ್ವೇ ದಣ್ಡಾ ವಂಶಸ್ಯಾಸ್ಯ ಭವಿಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","ಹಾ ಹಾ ವ್ಯವಸ್ಥಪಕಾ ಯೂಯಂ ಜ್ಞಾನಸ್ಯ ಕುಞ್ಚಿಕಾಂ ಹೃತ್ವಾ ಸ್ವಯಂ ನ ಪ್ರವಿಷ್ಟಾ ಯೇ ಪ್ರವೇಷ್ಟುಞ್ಚ ಪ್ರಯಾಸಿನಸ್ತಾನಪಿ ಪ್ರವೇಷ್ಟುಂ ವಾರಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ಇತ್ಥಂ ಕಥಾಕಥನಾದ್ ಅಧ್ಯಾಪಕಾಃ ಫಿರೂಶಿನಶ್ಚ ಸತರ್ಕಾಃ ");
INSERT INTO sankan_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ಸನ್ತಸ್ತಮಪವದಿತುಂ ತಸ್ಯ ಕಥಾಯಾ ದೋಷಂ ಧರ್ತ್ತಮಿಚ್ಛನ್ತೋ ನಾನಾಖ್ಯಾನಕಥನಾಯ ತಂ ಪ್ರವರ್ತ್ತಯಿತುಂ ಕೋಪಯಿತುಞ್ಚ ಪ್ರಾರೇಭಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","ತದಾನೀಂ ಲೋಕಾಃ ಸಹಸ್ರಂ ಸಹಸ್ರಮ್ ಆಗತ್ಯ ಸಮುಪಸ್ಥಿತಾಸ್ತತ ಏಕೈಕೋ ಽನ್ಯೇಷಾಮುಪರಿ ಪತಿತುಮ್ ಉಪಚಕ್ರಮೇ; ತದಾ ಯೀಶುಃ ಶಿಷ್ಯಾನ್ ಬಭಾಷೇ, ಯೂಯಂ ಫಿರೂಶಿನಾಂ ಕಿಣ್ವರೂಪಕಾಪಟ್ಯೇ ವಿಶೇಷೇಣ ಸಾವಧಾನಾಸ್ತಿಷ್ಠತ| ");
INSERT INTO sankan_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","ಯತೋ ಯನ್ನ ಪ್ರಕಾಶಯಿಷ್ಯತೇ ತದಾಚ್ಛನ್ನಂ ವಸ್ತು ಕಿಮಪಿ ನಾಸ್ತಿ; ತಥಾ ಯನ್ನ ಜ್ಞಾಸ್ಯತೇ ತದ್ ಗುಪ್ತಂ ವಸ್ತು ಕಿಮಪಿ ನಾಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","ಅನ್ಧಕಾರೇ ತಿಷ್ಠನತೋ ಯಾಃ ಕಥಾ ಅಕಥಯತ ತಾಃ ಸರ್ವ್ವಾಃ ಕಥಾ ದೀಪ್ತೌ ಶ್ರೋಷ್ಯನ್ತೇ ನಿರ್ಜನೇ ಕರ್ಣೇ ಚ ಯದಕಥಯತ ಗೃಹಪೃಷ್ಠಾತ್ ತತ್ ಪ್ರಚಾರಯಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","ಹೇ ಬನ್ಧವೋ ಯುಷ್ಮಾನಹಂ ವದಾಮಿ, ಯೇ ಶರೀರಸ್ಯ ನಾಶಂ ವಿನಾ ಕಿಮಪ್ಯಪರಂ ಕರ್ತ್ತುಂ ನ ಶಕ್ರುವನ್ತಿ ತೇಭ್ಯೋ ಮಾ ಭೈಷ್ಟ| ");
INSERT INTO sankan_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","ತರ್ಹಿ ಕಸ್ಮಾದ್ ಭೇತವ್ಯಮ್ ಇತ್ಯಹಂ ವದಾಮಿ, ಯಃ ಶರೀರಂ ನಾಶಯಿತ್ವಾ ನರಕಂ ನಿಕ್ಷೇಪ್ತುಂ ಶಕ್ನೋತಿ ತಸ್ಮಾದೇವ ಭಯಂ ಕುರುತ, ಪುನರಪಿ ವದಾಮಿ ತಸ್ಮಾದೇವ ಭಯಂ ಕುರುತ| ");
INSERT INTO sankan_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","ಪಞ್ಚ ಚಟಕಪಕ್ಷಿಣಃ ಕಿಂ ದ್ವಾಭ್ಯಾಂ ತಾಮ್ರಖಣ್ಡಾಭ್ಯಾಂ ನ ವಿಕ್ರೀಯನ್ತೇ? ತಥಾಪೀಶ್ವರಸ್ತೇಷಾಮ್ ಏಕಮಪಿ ನ ವಿಸ್ಮರತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","ಯುಷ್ಮಾಕಂ ಶಿರಃಕೇಶಾ ಅಪಿ ಗಣಿತಾಃ ಸನ್ತಿ ತಸ್ಮಾತ್ ಮಾ ವಿಭೀತ ಬಹುಚಟಕಪಕ್ಷಿಭ್ಯೋಪಿ ಯೂಯಂ ಬಹುಮೂಲ್ಯಾಃ| ");
INSERT INTO sankan_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","ಅಪರಂ ಯುಷ್ಮಭ್ಯಂ ಕಥಯಾಮಿ ಯಃ ಕಶ್ಚಿನ್ ಮಾನುಷಾಣಾಂ ಸಾಕ್ಷಾನ್ ಮಾಂ ಸ್ವೀಕರೋತಿ ಮನುಷ್ಯಪುತ್ರ ಈಶ್ವರದೂತಾನಾಂ ಸಾಕ್ಷಾತ್ ತಂ ಸ್ವೀಕರಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","ಕಿನ್ತು ಯಃ ಕಶ್ಚಿನ್ಮಾನುಷಾಣಾಂ ಸಾಕ್ಷಾನ್ಮಾಮ್ ಅಸ್ವೀಕರೋತಿ ತಮ್ ಈಶ್ವರಸ್ಯ ದೂತಾನಾಂ ಸಾಕ್ಷಾದ್ ಅಹಮ್ ಅಸ್ವೀಕರಿಷ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","ಅನ್ಯಚ್ಚ ಯಃ ಕಶ್ಚಿನ್ ಮನುಜಸುತಸ್ಯ ನಿನ್ದಾಭಾವೇನ ಕಾಞ್ಚಿತ್ ಕಥಾಂ ಕಥಯತಿ ತಸ್ಯ ತತ್ಪಾಪಸ್ಯ ಮೋಚನಂ ಭವಿಷ್ಯತಿ ಕಿನ್ತು ಯದಿ ಕಶ್ಚಿತ್ ಪವಿತ್ರಮ್ ಆತ್ಮಾನಂ ನಿನ್ದತಿ ತರ್ಹಿ ತಸ್ಯ ತತ್ಪಾಪಸ್ಯ ಮೋಚನಂ ನ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","ಯದಾ ಲೋಕಾ ಯುಷ್ಮಾನ್ ಭಜನಗೇಹಂ ವಿಚಾರಕರ್ತೃರಾಜ್ಯಕರ್ತೃಣಾಂ ಸಮ್ಮುಖಞ್ಚ ನೇಷ್ಯನ್ತಿ ತದಾ ಕೇನ ಪ್ರಕಾರೇಣ ಕಿಮುತ್ತರಂ ವದಿಷ್ಯಥ ಕಿಂ ಕಥಯಿಷ್ಯಥ ಚೇತ್ಯತ್ರ ಮಾ ಚಿನ್ತಯತ; ");
INSERT INTO sankan_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ಯತೋ ಯುಷ್ಮಾಭಿರ್ಯದ್ ಯದ್ ವಕ್ತವ್ಯಂ ತತ್ ತಸ್ಮಿನ್ ಸಮಯಏವ ಪವಿತ್ರ ಆತ್ಮಾ ಯುಷ್ಮಾನ್ ಶಿಕ್ಷಯಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ತತಃ ಪರಂ ಜನತಾಮಧ್ಯಸ್ಥಃ ಕಶ್ಚಿಜ್ಜನಸ್ತಂ ಜಗಾದ ಹೇ ಗುರೋ ಮಯಾ ಸಹ ಪೈತೃಕಂ ಧನಂ ವಿಭಕ್ತುಂ ಮಮ ಭ್ರಾತರಮಾಜ್ಞಾಪಯತು ಭವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","ಕಿನ್ತು ಸ ತಮವದತ್ ಹೇ ಮನುಷ್ಯ ಯುವಯೋ ರ್ವಿಚಾರಂ ವಿಭಾಗಞ್ಚ ಕರ್ತ್ತುಂ ಮಾಂ ಕೋ ನಿಯುಕ್ತವಾನ್? ");
INSERT INTO sankan_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ಅನನ್ತರಂ ಸ ಲೋಕಾನವದತ್ ಲೋಭೇ ಸಾವಧಾನಾಃ ಸತರ್ಕಾಶ್ಚ ತಿಷ್ಠತ, ಯತೋ ಬಹುಸಮ್ಪತ್ತಿಪ್ರಾಪ್ತ್ಯಾ ಮನುಷ್ಯಸ್ಯಾಯು ರ್ನ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ಪಶ್ಚಾದ್ ದೃಷ್ಟಾನ್ತಕಥಾಮುತ್ಥಾಪ್ಯ ಕಥಯಾಮಾಸ, ಏಕಸ್ಯ ಧನಿನೋ ಭೂಮೌ ಬಹೂನಿ ಶಸ್ಯಾನಿ ಜಾತಾನಿ| ");
INSERT INTO sankan_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ತತಃ ಸ ಮನಸಾ ಚಿನ್ತಯಿತ್ವಾ ಕಥಯಾಮ್ಬಭೂವ ಮಮೈತಾನಿ ಸಮುತ್ಪನ್ನಾನಿ ದ್ರವ್ಯಾಣಿ ಸ್ಥಾಪಯಿತುಂ ಸ್ಥಾನಂ ನಾಸ್ತಿ ಕಿಂ ಕರಿಷ್ಯಾಮಿ? ");
INSERT INTO sankan_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ತತೋವದದ್ ಇತ್ಥಂ ಕರಿಷ್ಯಾಮಿ, ಮಮ ಸರ್ವ್ವಭಾಣ್ಡಾಗಾರಾಣಿ ಭಙ್ಕ್ತ್ವಾ ಬೃಹದ್ಭಾಣ್ಡಾಗಾರಾಣಿ ನಿರ್ಮ್ಮಾಯ ತನ್ಮಧ್ಯೇ ಸರ್ವ್ವಫಲಾನಿ ದ್ರವ್ಯಾಣಿ ಚ ಸ್ಥಾಪಯಿಷ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ಅಪರಂ ನಿಜಮನೋ ವದಿಷ್ಯಾಮಿ, ಹೇ ಮನೋ ಬಹುವತ್ಸರಾರ್ಥಂ ನಾನಾದ್ರವ್ಯಾಣಿ ಸಞ್ಚಿತಾನಿ ಸನ್ತಿ ವಿಶ್ರಾಮಂ ಕುರು ಭುಕ್ತ್ವಾ ಪೀತ್ವಾ ಕೌತುಕಞ್ಚ ಕುರು| ಕಿನ್ತ್ವೀಶ್ವರಸ್ತಮ್ ಅವದತ್, ");
INSERT INTO sankan_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","ರೇ ನಿರ್ಬೋಧ ಅದ್ಯ ರಾತ್ರೌ ತವ ಪ್ರಾಣಾಸ್ತ್ವತ್ತೋ ನೇಷ್ಯನ್ತೇ ತತ ಏತಾನಿ ಯಾನಿ ದ್ರವ್ಯಾಣಿ ತ್ವಯಾಸಾದಿತಾನಿ ತಾನಿ ಕಸ್ಯ ಭವಿಷ್ಯನ್ತಿ? ");
INSERT INTO sankan_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","ಅತಏವ ಯಃ ಕಶ್ಚಿದ್ ಈಶ್ವರಸ್ಯ ಸಮೀಪೇ ಧನಸಞ್ಚಯಮಕೃತ್ವಾ ಕೇವಲಂ ಸ್ವನಿಕಟೇ ಸಞ್ಚಯಂ ಕರೋತಿ ಸೋಪಿ ತಾದೃಶಃ| ");
INSERT INTO sankan_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","ಅಥ ಸ ಶಿಷ್ಯೇಭ್ಯಃ ಕಥಯಾಮಾಸ, ಯುಷ್ಮಾನಹಂ ವದಾಮಿ, ಕಿಂ ಖಾದಿಷ್ಯಾಮಃ? ಕಿಂ ಪರಿಧಾಸ್ಯಾಮಃ? ಇತ್ಯುಕ್ತ್ವಾ ಜೀವನಸ್ಯ ಶರೀರಸ್ಯ ಚಾರ್ಥಂ ಚಿನ್ತಾಂ ಮಾ ಕಾರ್ಷ್ಟ| ");
INSERT INTO sankan_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ಭಕ್ಷ್ಯಾಜ್ಜೀವನಂ ಭೂಷಣಾಚ್ಛರೀರಞ್ಚ ಶ್ರೇಷ್ಠಂ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","ಕಾಕಪಕ್ಷಿಣಾಂ ಕಾರ್ಯ್ಯಂ ವಿಚಾರಯತ, ತೇ ನ ವಪನ್ತಿ ಶಸ್ಯಾನಿ ಚ ನ ಛಿನ್ದನ್ತಿ, ತೇಷಾಂ ಭಾಣ್ಡಾಗಾರಾಣಿ ನ ಸನ್ತಿ ಕೋಷಾಶ್ಚ ನ ಸನ್ತಿ, ತಥಾಪೀಶ್ವರಸ್ತೇಭ್ಯೋ ಭಕ್ಷ್ಯಾಣಿ ದದಾತಿ, ಯೂಯಂ ಪಕ್ಷಿಭ್ಯಃ ಶ್ರೇಷ್ಠತರಾ ನ ಕಿಂ? ");
INSERT INTO sankan_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","ಅಪರಞ್ಚ ಭಾವಯಿತ್ವಾ ನಿಜಾಯುಷಃ ಕ್ಷಣಮಾತ್ರಂ ವರ್ದ್ಧಯಿತುಂ ಶಕ್ನೋತಿ, ಏತಾದೃಶೋ ಲಾಕೋ ಯುಷ್ಮಾಕಂ ಮಧ್ಯೇ ಕೋಸ್ತಿ? ");
INSERT INTO sankan_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","ಅತಏವ ಕ್ಷುದ್ರಂ ಕಾರ್ಯ್ಯಂ ಸಾಧಯಿತುಮ್ ಅಸಮರ್ಥಾ ಯೂಯಮ್ ಅನ್ಯಸ್ಮಿನ್ ಕಾರ್ಯ್ಯೇ ಕುತೋ ಭಾವಯಥ? ");
INSERT INTO sankan_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","ಅನ್ಯಚ್ಚ ಕಾಮ್ಪಿಲಪುಷ್ಪಂ ಕಥಂ ವರ್ದ್ಧತೇ ತದಾಪಿ ವಿಚಾರಯತ, ತತ್ ಕಞ್ಚನ ಶ್ರಮಂ ನ ಕರೋತಿ ತನ್ತೂಂಶ್ಚ ನ ಜನಯತಿ ಕಿನ್ತು ಯುಷ್ಮಭ್ಯಂ ಯಥಾರ್ಥಂ ಕಥಯಾಮಿ ಸುಲೇಮಾನ್ ಬಹ್ವೈಶ್ವರ್ಯ್ಯಾನ್ವಿತೋಪಿ ಪುಷ್ಪಸ್ಯಾಸ್ಯ ಸದೃಶೋ ವಿಭೂಷಿತೋ ನಾಸೀತ್| ");
INSERT INTO sankan_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ಅದ್ಯ ಕ್ಷೇತ್ರೇ ವರ್ತ್ತಮಾನಂ ಶ್ವಶ್ಚೂಲ್ಲ್ಯಾಂ ಕ್ಷೇಪ್ಸ್ಯಮಾನಂ ಯತ್ ತೃಣಂ, ತಸ್ಮೈ ಯದೀಶ್ವರ ಇತ್ಥಂ ಭೂಷಯತಿ ತರ್ಹಿ ಹೇ ಅಲ್ಪಪ್ರತ್ಯಯಿನೋ ಯುಷ್ಮಾನ ಕಿಂ ನ ಪರಿಧಾಪಯಿಷ್ಯತಿ? ");
INSERT INTO sankan_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","ಅತಏವ ಕಿಂ ಖಾದಿಷ್ಯಾಮಃ? ಕಿಂ ಪರಿಧಾಸ್ಯಾಮಃ? ಏತದರ್ಥಂ ಮಾ ಚೇಷ್ಟಧ್ವಂ ಮಾ ಸಂದಿಗ್ಧ್ವಞ್ಚ| ");
INSERT INTO sankan_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ಜಗತೋ ದೇವಾರ್ಚ್ಚಕಾ ಏತಾನಿ ಸರ್ವ್ವಾಣಿ ಚೇಷ್ಟನತೇ; ಏಷು ವಸ್ತುಷು ಯುಷ್ಮಾಕಂ ಪ್ರಯೋಜನಮಾಸ್ತೇ ಇತಿ ಯುಷ್ಮಾಕಂ ಪಿತಾ ಜಾನಾತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","ಅತಏವೇಶ್ವರಸ್ಯ ರಾಜ್ಯಾರ್ಥಂ ಸಚೇಷ್ಟಾ ಭವತ ತಥಾ ಕೃತೇ ಸರ್ವ್ವಾಣ್ಯೇತಾನಿ ದ್ರವ್ಯಾಣಿ ಯುಷ್ಮಭ್ಯಂ ಪ್ರದಾಯಿಷ್ಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","ಹೇ ಕ್ಷುದ್ರಮೇಷವ್ರಜ ಯೂಯಂ ಮಾ ಭೈಷ್ಟ ಯುಷ್ಮಭ್ಯಂ ರಾಜ್ಯಂ ದಾತುಂ ಯುಷ್ಮಾಕಂ ಪಿತುಃ ಸಮ್ಮತಿರಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ಅತಏವ ಯುಷ್ಮಾಕಂ ಯಾ ಯಾ ಸಮ್ಪತ್ತಿರಸ್ತಿ ತಾಂ ತಾಂ ವಿಕ್ರೀಯ ವಿತರತ, ಯತ್ ಸ್ಥಾನಂ ಚೌರಾ ನಾಗಚ್ಛನ್ತಿ, ಕೀಟಾಶ್ಚ ನ ಕ್ಷಾಯಯನ್ತಿ ತಾದೃಶೇ ಸ್ವರ್ಗೇ ನಿಜಾರ್ಥಮ್ ಅಜರೇ ಸಮ್ಪುಟಕೇ ಽಕ್ಷಯಂ ಧನಂ ಸಞ್ಚಿನುತ ಚ; ");
INSERT INTO sankan_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","ಯತೋ ಯತ್ರ ಯುಷ್ಮಾಕಂ ಧನಂ ವರ್ತ್ತತೇ ತತ್ರೇವ ಯುಷ್ಮಾಕಂ ಮನಃ| ");
INSERT INTO sankan_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","ಅಪರಞ್ಚ ಯೂಯಂ ಪ್ರದೀಪಂ ಜ್ವಾಲಯಿತ್ವಾ ಬದ್ಧಕಟಯಸ್ತಿಷ್ಠತ; ");
INSERT INTO sankan_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ಪ್ರಭು ರ್ವಿವಾಹಾದಾಗತ್ಯ ಯದೈವ ದ್ವಾರಮಾಹನ್ತಿ ತದೈವ ದ್ವಾರಂ ಮೋಚಯಿತುಂ ಯಥಾ ಭೃತ್ಯಾ ಅಪೇಕ್ಷ್ಯ ತಿಷ್ಠನ್ತಿ ತಥಾ ಯೂಯಮಪಿ ತಿಷ್ಠತ| ");
INSERT INTO sankan_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ಯತಃ ಪ್ರಭುರಾಗತ್ಯ ಯಾನ್ ದಾಸಾನ್ ಸಚೇತನಾನ್ ತಿಷ್ಠತೋ ದ್ರಕ್ಷ್ಯತಿ ತಏವ ಧನ್ಯಾಃ; ಅಹಂ ಯುಷ್ಮಾನ್ ಯಥಾರ್ಥಂ ವದಾಮಿ ಪ್ರಭುಸ್ತಾನ್ ಭೋಜನಾರ್ಥಮ್ ಉಪವೇಶ್ಯ ಸ್ವಯಂ ಬದ್ಧಕಟಿಃ ಸಮೀಪಮೇತ್ಯ ಪರಿವೇಷಯಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ಯದಿ ದ್ವಿತೀಯೇ ತೃತೀಯೇ ವಾ ಪ್ರಹರೇ ಸಮಾಗತ್ಯ ತಥೈವ ಪಶ್ಯತಿ, ತರ್ಹಿ ತಏವ ದಾಸಾ ಧನ್ಯಾಃ| ");
INSERT INTO sankan_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","ಅಪರಞ್ಚ ಕಸ್ಮಿನ್ ಕ್ಷಣೇ ಚೌರಾ ಆಗಮಿಷ್ಯನ್ತಿ ಇತಿ ಯದಿ ಗೃಹಪತಿ ರ್ಜ್ಞಾತುಂ ಶಕ್ನೋತಿ ತದಾವಶ್ಯಂ ಜಾಗ್ರನ್ ನಿಜಗೃಹೇ ಸನ್ಧಿಂ ಕರ್ತ್ತಯಿತುಂ ವಾರಯತಿ ಯೂಯಮೇತದ್ ವಿತ್ತ| ");
INSERT INTO sankan_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","ಅತಏವ ಯೂಯಮಪಿ ಸಜ್ಜಮಾನಾಸ್ತಿಷ್ಠತ ಯತೋ ಯಸ್ಮಿನ್ ಕ್ಷಣೇ ತಂ ನಾಪ್ರೇಕ್ಷಧ್ವೇ ತಸ್ಮಿನ್ನೇವ ಕ್ಷಣೇ ಮನುಷ್ಯಪುತ್ರ ಆಗಮಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ತದಾ ಪಿತರಃ ಪಪ್ರಚ್ಛ, ಹೇ ಪ್ರಭೋ ಭವಾನ್ ಕಿಮಸ್ಮಾನ್ ಉದ್ದಿಶ್ಯ ಕಿಂ ಸರ್ವ್ವಾನ್ ಉದ್ದಿಶ್ಯ ದೃಷ್ಟಾನ್ತಕಥಾಮಿಮಾಂ ವದತಿ? ");
INSERT INTO sankan_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ತತಃ ಪ್ರಭುಃ ಪ್ರೋವಾಚ, ಪ್ರಭುಃ ಸಮುಚಿತಕಾಲೇ ನಿಜಪರಿವಾರಾರ್ಥಂ ಭೋಜ್ಯಪರಿವೇಷಣಾಯ ಯಂ ತತ್ಪದೇ ನಿಯೋಕ್ಷ್ಯತಿ ತಾದೃಶೋ ವಿಶ್ವಾಸ್ಯೋ ಬೋದ್ಧಾ ಕರ್ಮ್ಮಾಧೀಶಃ ಕೋಸ್ತಿ? ");
INSERT INTO sankan_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ಪ್ರಭುರಾಗತ್ಯ ಯಮ್ ಏತಾದೃಶೇ ಕರ್ಮ್ಮಣಿ ಪ್ರವೃತ್ತಂ ದ್ರಕ್ಷ್ಯತಿ ಸಏವ ದಾಸೋ ಧನ್ಯಃ| ");
INSERT INTO sankan_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ಅಹಂ ಯುಷ್ಮಾನ್ ಯಥಾರ್ಥಂ ವದಾಮಿ ಸ ತಂ ನಿಜಸರ್ವ್ವಸ್ವಸ್ಯಾಧಿಪತಿಂ ಕರಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","ಕಿನ್ತು ಪ್ರಭುರ್ವಿಲಮ್ಬೇನಾಗಮಿಷ್ಯತಿ, ಇತಿ ವಿಚಿನ್ತ್ಯ ಸ ದಾಸೋ ಯದಿ ತದನ್ಯದಾಸೀದಾಸಾನ್ ಪ್ರಹರ್ತ್ತುಮ್ ಭೋಕ್ತುಂ ಪಾತುಂ ಮದಿತುಞ್ಚ ಪ್ರಾರಭತೇ, ");
INSERT INTO sankan_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ತರ್ಹಿ ಯದಾ ಪ್ರಭುಂ ನಾಪೇಕ್ಷಿಷ್ಯತೇ ಯಸ್ಮಿನ್ ಕ್ಷಣೇ ಸೋಽಚೇತನಶ್ಚ ಸ್ಥಾಸ್ಯತಿ ತಸ್ಮಿನ್ನೇವ ಕ್ಷಣೇ ತಸ್ಯ ಪ್ರಭುರಾಗತ್ಯ ತಂ ಪದಭ್ರಷ್ಟಂ ಕೃತ್ವಾ ವಿಶ್ವಾಸಹೀನೈಃ ಸಹ ತಸ್ಯ ಅಂಶಂ ನಿರೂಪಯಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","ಯೋ ದಾಸಃ ಪ್ರಭೇाರಾಜ್ಞಾಂ ಜ್ಞಾತ್ವಾಪಿ ಸಜ್ಜಿತೋ ನ ತಿಷ್ಠತಿ ತದಾಜ್ಞಾನುಸಾರೇಣ ಚ ಕಾರ್ಯ್ಯಂ ನ ಕರೋತಿ ಸೋನೇಕಾನ್ ಪ್ರಹಾರಾನ್ ಪ್ರಾಪ್ಸ್ಯತಿ; ");
INSERT INTO sankan_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","ಕಿನ್ತು ಯೋ ಜನೋಽಜ್ಞಾತ್ವಾ ಪ್ರಹಾರಾರ್ಹಂ ಕರ್ಮ್ಮ ಕರೋತಿ ಸೋಲ್ಪಪ್ರಹಾರಾನ್ ಪ್ರಾಪ್ಸ್ಯತಿ| ಯತೋ ಯಸ್ಮೈ ಬಾಹುಲ್ಯೇನ ದತ್ತಂ ತಸ್ಮಾದೇವ ಬಾಹುಲ್ಯೇನ ಗ್ರಹೀಷ್ಯತೇ, ಮಾನುಷಾ ಯಸ್ಯ ನಿಕಟೇ ಬಹು ಸಮರ್ಪಯನ್ತಿ ತಸ್ಮಾದ್ ಬಹು ಯಾಚನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","ಅಹಂ ಪೃಥಿವ್ಯಾಮ್ ಅನೈಕ್ಯರೂಪಂ ವಹ್ನಿ ನಿಕ್ಷೇಪ್ತುಮ್ ಆಗತೋಸ್ಮಿ, ಸ ಚೇದ್ ಇದಾನೀಮೇವ ಪ್ರಜ್ವಲತಿ ತತ್ರ ಮಮ ಕಾ ಚಿನ್ತಾ? ");
INSERT INTO sankan_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","ಕಿನ್ತು ಯೇನ ಮಜ್ಜನೇನಾಹಂ ಮಗ್ನೋ ಭವಿಷ್ಯಾಮಿ ಯಾವತ್ಕಾಲಂ ತಸ್ಯ ಸಿದ್ಧಿ ರ್ನ ಭವಿಷ್ಯತಿ ತಾವದಹಂ ಕತಿಕಷ್ಟಂ ಪ್ರಾಪ್ಸ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","ಮೇಲನಂ ಕರ್ತ್ತುಂ ಜಗದ್ ಆಗತೋಸ್ಮಿ ಯೂಯಂ ಕಿಮಿತ್ಥಂ ಬೋಧಧ್ವೇ? ಯುಷ್ಮಾನ್ ವದಾಮಿ ನ ತಥಾ, ಕಿನ್ತ್ವಹಂ ಮೇಲನಾಭಾವಂ ಕರ್ತ್ತುಂಮ್ ಆಗತೋಸ್ಮಿ| ");
INSERT INTO sankan_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ಯಸ್ಮಾದೇತತ್ಕಾಲಮಾರಭ್ಯ ಏಕತ್ರಸ್ಥಪರಿಜನಾನಾಂ ಮಧ್ಯೇ ಪಞ್ಚಜನಾಃ ಪೃಥಗ್ ಭೂತ್ವಾ ತ್ರಯೋ ಜನಾ ದ್ವಯೋರ್ಜನಯೋಃ ಪ್ರತಿಕೂಲಾ ದ್ವೌ ಜನೌ ಚ ತ್ರಯಾಣಾಂ ಜನಾನಾಂ ಪ್ರತಿಕೂಲೌ ಭವಿಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","ಪಿತಾ ಪುತ್ರಸ್ಯ ವಿಪಕ್ಷಃ ಪುತ್ರಶ್ಚ ಪಿತು ರ್ವಿಪಕ್ಷೋ ಭವಿಷ್ಯತಿ ಮಾತಾ ಕನ್ಯಾಯಾ ವಿಪಕ್ಷಾ ಕನ್ಯಾ ಚ ಮಾತು ರ್ವಿಪಕ್ಷಾ ಭವಿಷ್ಯತಿ, ತಥಾ ಶ್ವಶ್ರೂರ್ಬಧ್ವಾ ವಿಪಕ್ಷಾ ಬಧೂಶ್ಚ ಶ್ವಶ್ರ್ವಾ ವಿಪಕ್ಷಾ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ಸ ಲೋಕೇಭ್ಯೋಪರಮಪಿ ಕಥಯಾಮಾಸ, ಪಶ್ಚಿಮದಿಶಿ ಮೇಘೋದ್ಗಮಂ ದೃಷ್ಟ್ವಾ ಯೂಯಂ ಹಠಾದ್ ವದಥ ವೃಷ್ಟಿ ರ್ಭವಿಷ್ಯತಿ ತತಸ್ತಥೈವ ಜಾಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","ಅಪರಂ ದಕ್ಷಿಣತೋ ವಾಯೌ ವಾತಿ ಸತಿ ವದಥ ನಿದಾಘೋ ಭವಿಷ್ಯತಿ ತತಃ ಸೋಪಿ ಜಾಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ರೇ ರೇ ಕಪಟಿನ ಆಕಾಶಸ್ಯ ಭೂಮ್ಯಾಶ್ಚ ಲಕ್ಷಣಂ ಬೋದ್ಧುಂ ಶಕ್ನುಥ, ");
INSERT INTO sankan_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","ಕಿನ್ತು ಕಾಲಸ್ಯಾಸ್ಯ ಲಕ್ಷಣಂ ಕುತೋ ಬೋದ್ಧುಂ ನ ಶಕ್ನುಥ? ಯೂಯಞ್ಚ ಸ್ವಯಂ ಕುತೋ ನ ನ್ಯಾಷ್ಯಂ ವಿಚಾರಯಥ? ");
INSERT INTO sankan_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","ಅಪರಞ್ಚ ವಿವಾದಿನಾ ಸಾರ್ದ್ಧಂ ವಿಚಾರಯಿತುಃ ಸಮೀಪಂ ಗಚ್ಛನ್ ಪಥಿ ತಸ್ಮಾದುದ್ಧಾರಂ ಪ್ರಾಪ್ತುಂ ಯತಸ್ವ ನೋಚೇತ್ ಸ ತ್ವಾಂ ಧೃತ್ವಾ ವಿಚಾರಯಿತುಃ ಸಮೀಪಂ ನಯತಿ| ವಿಚಾರಯಿತಾ ಯದಿ ತ್ವಾಂ ಪ್ರಹರ್ತ್ತುಃ ಸಮೀಪಂ ಸಮರ್ಪಯತಿ ಪ್ರಹರ್ತ್ತಾ ತ್ವಾಂ ಕಾರಾಯಾಂ ಬಧ್ನಾತಿ ");
INSERT INTO sankan_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","ತರ್ಹಿ ತ್ವಾಮಹಂ ವದಾಮಿ ತ್ವಯಾ ನಿಃಶೇಷಂ ಕಪರ್ದಕೇಷು ನ ಪರಿಶೋಧಿತೇಷು ತ್ವಂ ತತೋ ಮುಕ್ತಿಂ ಪ್ರಾಪ್ತುಂ ನ ಶಕ್ಷ್ಯಸಿ| ");
INSERT INTO sankan_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","ಅಪರಞ್ಚ ಪೀಲಾತೋ ಯೇಷಾಂ ಗಾಲೀಲೀಯಾನಾಂ ರಕ್ತಾನಿ ಬಲೀನಾಂ ರಕ್ತೈಃ ಸಹಾಮಿಶ್ರಯತ್ ತೇಷಾಂ ಗಾಲೀಲೀಯಾನಾಂ ವೃತ್ತಾನ್ತಂ ಕತಿಪಯಜನಾ ಉಪಸ್ಥಾಪ್ಯ ಯೀಶವೇ ಕಥಯಾಮಾಸುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ತತಃ ಸ ಪ್ರತ್ಯುವಾಚ ತೇಷಾಂ ಲೋಕಾನಾಮ್ ಏತಾದೃಶೀ ದುರ್ಗತಿ ರ್ಘಟಿತಾ ತತ್ಕಾರಣಾದ್ ಯೂಯಂ ಕಿಮನ್ಯೇಭ್ಯೋ ಗಾಲೀಲೀಯೇಭ್ಯೋಪ್ಯಧಿಕಪಾಪಿನಸ್ತಾನ್ ಬೋಧಧ್ವೇ? ");
INSERT INTO sankan_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","ಯುಷ್ಮಾನಹಂ ವದಾಮಿ ತಥಾ ನ ಕಿನ್ತು ಮನಃಸು ನ ಪರಾವರ್ತ್ತಿತೇಷು ಯೂಯಮಪಿ ತಥಾ ನಂಕ್ಷ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","ಅಪರಞ್ಚ ಶೀಲೋಹನಾಮ್ನ ಉಚ್ಚಗೃಹಸ್ಯ ಪತನಾದ್ ಯೇಽಷ್ಟಾದಶಜನಾ ಮೃತಾಸ್ತೇ ಯಿರೂಶಾಲಮಿ ನಿವಾಸಿಸರ್ವ್ವಲೋಕೇಭ್ಯೋಽಧಿಕಾಪರಾಧಿನಃ ಕಿಂ ಯೂಯಮಿತ್ಯಂ ಬೋಧಧ್ವೇ? ");
INSERT INTO sankan_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","ಯುಷ್ಮಾನಹಂ ವದಾಮಿ ತಥಾ ನ ಕಿನ್ತು ಮನಃಸು ನ ಪರಿವರ್ತ್ತಿತೇಷು ಯೂಯಮಪಿ ತಥಾ ನಂಕ್ಷ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ಅನನ್ತರಂ ಸ ಇಮಾಂ ದೃಷ್ಟಾನ್ತಕಥಾಮಕಥಯದ್ ಏಕೋ ಜನೋ ದ್ರಾಕ್ಷಾಕ್ಷೇತ್ರಮಧ್ಯ ಏಕಮುಡುಮ್ಬರವೃಕ್ಷಂ ರೋಪಿತವಾನ್| ಪಶ್ಚಾತ್ ಸ ಆಗತ್ಯ ತಸ್ಮಿನ್ ಫಲಾನಿ ಗವೇಷಯಾಮಾಸ, ");
INSERT INTO sankan_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","ಕಿನ್ತು ಫಲಾಪ್ರಾಪ್ತೇಃ ಕಾರಣಾದ್ ಉದ್ಯಾನಕಾರಂ ಭೃತ್ಯಂ ಜಗಾದ, ಪಶ್ಯ ವತ್ಸರತ್ರಯಂ ಯಾವದಾಗತ್ಯ ಏತಸ್ಮಿನ್ನುಡುಮ್ಬರತರೌ ಕ್ಷಲಾನ್ಯನ್ವಿಚ್ಛಾಮಿ, ಕಿನ್ತು ನೈಕಮಪಿ ಪ್ರಪ್ನೋಮಿ ತರುರಯಂ ಕುತೋ ವೃಥಾ ಸ್ಥಾನಂ ವ್ಯಾಪ್ಯ ತಿಷ್ಠತಿ? ಏನಂ ಛಿನ್ಧಿ| ");
INSERT INTO sankan_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ತತೋ ಭೃತ್ಯಃ ಪ್ರತ್ಯುವಾಚ, ಹೇ ಪ್ರಭೋ ಪುನರ್ವರ್ಷಮೇಕಂ ಸ್ಥಾತುಮ್ ಆದಿಶ; ಏತಸ್ಯ ಮೂಲಸ್ಯ ಚತುರ್ದಿಕ್ಷು ಖನಿತ್ವಾಹಮ್ ಆಲವಾಲಂ ಸ್ಥಾಪಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ತತಃ ಫಲಿತುಂ ಶಕ್ನೋತಿ ಯದಿ ನ ಫಲತಿ ತರ್ಹಿ ಪಶ್ಚಾತ್ ಛೇತ್ಸ್ಯಸಿ| ");
INSERT INTO sankan_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","ಅಥ ವಿಶ್ರಾಮವಾರೇ ಭಜನಗೇಹೇ ಯೀಶುರುಪದಿಶತಿ ");
INSERT INTO sankan_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ತಸ್ಮಿತ್ ಸಮಯೇ ಭೂತಗ್ರಸ್ತತ್ವಾತ್ ಕುಬ್ಜೀಭೂಯಾಷ್ಟಾದಶವರ್ಷಾಣಿ ಯಾವತ್ ಕೇನಾಪ್ಯುಪಾಯೇನ ಋಜು ರ್ಭವಿತುಂ ನ ಶಕ್ನೋತಿ ಯಾ ದುರ್ಬ್ಬಲಾ ಸ್ತ್ರೀ, ");
INSERT INTO sankan_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ತಾಂ ತತ್ರೋಪಸ್ಥಿತಾಂ ವಿಲೋಕ್ಯ ಯೀಶುಸ್ತಾಮಾಹೂಯ ಕಥಿತವಾನ್ ಹೇ ನಾರಿ ತವ ದೌರ್ಬ್ಬಲ್ಯಾತ್ ತ್ವಂ ಮುಕ್ತಾ ಭವ| ");
INSERT INTO sankan_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ತತಃ ಪರಂ ತಸ್ಯಾ ಗಾತ್ರೇ ಹಸ್ತಾರ್ಪಣಮಾತ್ರಾತ್ ಸಾ ಋಜುರ್ಭೂತ್ವೇಶ್ವರಸ್ಯ ಧನ್ಯವಾದಂ ಕರ್ತ್ತುಮಾರೇಭೇ| ");
INSERT INTO sankan_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","ಕಿನ್ತು ವಿಶ್ರಾಮವಾರೇ ಯೀಶುನಾ ತಸ್ಯಾಃ ಸ್ವಾಸ್ಥ್ಯಕರಣಾದ್ ಭಜನಗೇಹಸ್ಯಾಧಿಪತಿಃ ಪ್ರಕುಪ್ಯ ಲೋಕಾನ್ ಉವಾಚ, ಷಟ್ಸು ದಿನೇಷು ಲೋಕೈಃ ಕರ್ಮ್ಮ ಕರ್ತ್ತವ್ಯಂ ತಸ್ಮಾದ್ಧೇತೋಃ ಸ್ವಾಸ್ಥ್ಯಾರ್ಥಂ ತೇಷು ದಿನೇಷು ಆಗಚ್ಛತ, ವಿಶ್ರಾಮವಾರೇ ಮಾಗಚ್ಛತ| ");
INSERT INTO sankan_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ತದಾ ಪಭುಃ ಪ್ರತ್ಯುವಾಚ ರೇ ಕಪಟಿನೋ ಯುಷ್ಮಾಕಮ್ ಏಕೈಕೋ ಜನೋ ವಿಶ್ರಾಮವಾರೇ ಸ್ವೀಯಂ ಸ್ವೀಯಂ ವೃಷಭಂ ಗರ್ದಭಂ ವಾ ಬನ್ಧನಾನ್ಮೋಚಯಿತ್ವಾ ಜಲಂ ಪಾಯಯಿತುಂ ಕಿಂ ನ ನಯತಿ? ");
INSERT INTO sankan_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","ತರ್ಹ್ಯಾಷ್ಟಾದಶವತ್ಸರಾನ್ ಯಾವತ್ ಶೈತಾನಾ ಬದ್ಧಾ ಇಬ್ರಾಹೀಮಃ ಸನ್ತತಿರಿಯಂ ನಾರೀ ಕಿಂ ವಿಶ್ರಾಮವಾರೇ ನ ಮೋಚಯಿತವ್ಯಾ? ");
INSERT INTO sankan_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ಏಷು ವಾಕ್ಯೇಷು ಕಥಿತೇಷು ತಸ್ಯ ವಿಪಕ್ಷಾಃ ಸಲಜ್ಜಾ ಜಾತಾಃ ಕಿನ್ತು ತೇನ ಕೃತಸರ್ವ್ವಮಹಾಕರ್ಮ್ಮಕಾರಣಾತ್ ಲೋಕನಿವಹಃ ಸಾನನ್ದೋಽಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ಅನನ್ತರಂ ಸೋವದದ್ ಈಶ್ವರಸ್ಯ ರಾಜ್ಯಂ ಕಸ್ಯ ಸದೃಶಂ? ಕೇನ ತದುಪಮಾಸ್ಯಾಮಿ? ");
INSERT INTO sankan_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ಯತ್ ಸರ್ಷಪಬೀಜಂ ಗೃಹೀತ್ವಾ ಕಶ್ಚಿಜ್ಜನ ಉದ್ಯಾನ ಉಪ್ತವಾನ್ ತದ್ ಬೀಜಮಙ್ಕುರಿತಂ ಸತ್ ಮಹಾವೃಕ್ಷೋಽಜಾಯತ, ತತಸ್ತಸ್ಯ ಶಾಖಾಸು ವಿಹಾಯಸೀಯವಿಹಗಾ ಆಗತ್ಯ ನ್ಯೂಷುಃ, ತದ್ರಾಜ್ಯಂ ತಾದೃಶೇನ ಸರ್ಷಪಬೀಜೇನ ತುಲ್ಯಂ| ");
INSERT INTO sankan_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ಪುನಃ ಕಥಯಾಮಾಸ, ಈಶ್ವರಸ್ಯ ರಾಜ್ಯಂ ಕಸ್ಯ ಸದೃಶಂ ವದಿಷ್ಯಾಮಿ? ಯತ್ ಕಿಣ್ವಂ ಕಾಚಿತ್ ಸ್ತ್ರೀ ಗೃಹೀತ್ವಾ ದ್ರೋಣತ್ರಯಪರಿಮಿತಗೋಧೂಮಚೂರ್ಣೇಷು ಸ್ಥಾಪಯಾಮಾಸ, ");
INSERT INTO sankan_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ತತಃ ಕ್ರಮೇಣ ತತ್ ಸರ್ವ್ವಗೋಧೂಮಚೂರ್ಣಂ ವ್ಯಾಪ್ನೋತಿ, ತಸ್ಯ ಕಿಣ್ವಸ್ಯ ತುಲ್ಯಮ್ ಈಶ್ವರಸ್ಯ ರಾಜ್ಯಂ| ");
INSERT INTO sankan_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ತತಃ ಸ ಯಿರೂಶಾಲಮ್ನಗರಂ ಪ್ರತಿ ಯಾತ್ರಾಂ ಕೃತ್ವಾ ನಗರೇ ನಗರೇ ಗ್ರಾಮೇ ಗ್ರಾಮೇ ಸಮುಪದಿಶನ್ ಜಗಾಮ| ");
INSERT INTO sankan_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ತದಾ ಕಶ್ಚಿಜ್ಜನಸ್ತಂ ಪಪ್ರಚ್ಛ, ಹೇ ಪ್ರಭೋ ಕಿಂ ಕೇವಲಮ್ ಅಲ್ಪೇ ಲೋಕಾಃ ಪರಿತ್ರಾಸ್ಯನ್ತೇ? ");
INSERT INTO sankan_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","ತತಃ ಸ ಲೋಕಾನ್ ಉವಾಚ, ಸಂಕೀರ್ಣದ್ವಾರೇಣ ಪ್ರವೇಷ್ಟುಂ ಯತಘ್ವಂ, ಯತೋಹಂ ಯುಷ್ಮಾನ್ ವದಾಮಿ, ಬಹವಃ ಪ್ರವೇಷ್ಟುಂ ಚೇಷ್ಟಿಷ್ಯನ್ತೇ ಕಿನ್ತು ನ ಶಕ್ಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ಗೃಹಪತಿನೋತ್ಥಾಯ ದ್ವಾರೇ ರುದ್ಧೇ ಸತಿ ಯದಿ ಯೂಯಂ ಬಹಿಃ ಸ್ಥಿತ್ವಾ ದ್ವಾರಮಾಹತ್ಯ ವದಥ, ಹೇ ಪ್ರಭೋ ಹೇ ಪ್ರಭೋ ಅಸ್ಮತ್ಕಾರಣಾದ್ ದ್ವಾರಂ ಮೋಚಯತು, ತತಃ ಸ ಇತಿ ಪ್ರತಿವಕ್ಷ್ಯತಿ, ಯೂಯಂ ಕುತ್ರತ್ಯಾ ಲೋಕಾ ಇತ್ಯಹಂ ನ ಜಾನಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","ತದಾ ಯೂಯಂ ವದಿಷ್ಯಥ, ತವ ಸಾಕ್ಷಾದ್ ವಯಂ ಭೇाಜನಂ ಪಾನಞ್ಚ ಕೃತವನ್ತಃ, ತ್ವಞ್ಚಾಸ್ಮಾಕಂ ನಗರಸ್ಯ ಪಥಿ ಸಮುಪದಿಷ್ಟವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","ಕಿನ್ತು ಸ ವಕ್ಷ್ಯತಿ, ಯುಷ್ಮಾನಹಂ ವದಾಮಿ, ಯೂಯಂ ಕುತ್ರತ್ಯಾ ಲೋಕಾ ಇತ್ಯಹಂ ನ ಜಾನಾಮಿ; ಹೇ ದುರಾಚಾರಿಣೋ ಯೂಯಂ ಮತ್ತೋ ದೂರೀಭವತ| ");
INSERT INTO sankan_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","ತದಾ ಇಬ್ರಾಹೀಮಂ ಇಸ್ಹಾಕಂ ಯಾಕೂಬಞ್ಚ ಸರ್ವ್ವಭವಿಷ್ಯದ್ವಾದಿನಶ್ಚ ಈಶ್ವರಸ್ಯ ರಾಜ್ಯಂ ಪ್ರಾಪ್ತಾನ್ ಸ್ವಾಂಶ್ಚ ಬಹಿಷ್ಕೃತಾನ್ ದೃಷ್ಟ್ವಾ ಯೂಯಂ ರೋದನಂ ದನ್ತೈರ್ದನ್ತಘರ್ಷಣಞ್ಚ ಕರಿಷ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","ಅಪರಞ್ಚ ಪೂರ್ವ್ವಪಶ್ಚಿಮದಕ್ಷಿಣೋತ್ತರದಿಗ್ಭ್ಯೋ ಲೋಕಾ ಆಗತ್ಯ ಈಶ್ವರಸ್ಯ ರಾಜ್ಯೇ ನಿವತ್ಸ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ಪಶ್ಯತೇತ್ಥಂ ಶೇಷೀಯಾ ಲೋಕಾ ಅಗ್ರಾ ಭವಿಷ್ಯನ್ತಿ, ಅಗ್ರೀಯಾ ಲೋಕಾಶ್ಚ ಶೇಷಾ ಭವಿಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","ಅಪರಞ್ಚ ತಸ್ಮಿನ್ ದಿನೇ ಕಿಯನ್ತಃ ಫಿರೂಶಿನ ಆಗತ್ಯ ಯೀಶುಂ ಪ್ರೋಚುಃ, ಬಹಿರ್ಗಚ್ಛ, ಸ್ಥಾನಾದಸ್ಮಾತ್ ಪ್ರಸ್ಥಾನಂ ಕುರು, ಹೇರೋದ್ ತ್ವಾಂ ಜಿಘಾಂಸತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ತತಃ ಸ ಪ್ರತ್ಯವೋಚತ್ ಪಶ್ಯತಾದ್ಯ ಶ್ವಶ್ಚ ಭೂತಾನ್ ವಿಹಾಪ್ಯ ರೋಗಿಣೋಽರೋಗಿಣಃ ಕೃತ್ವಾ ತೃತೀಯೇಹ್ನಿ ಸೇತ್ಸ್ಯಾಮಿ, ಕಥಾಮೇತಾಂ ಯೂಯಮಿತ್ವಾ ತಂ ಭೂರಿಮಾಯಂ ವದತ| ");
INSERT INTO sankan_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","ತತ್ರಾಪ್ಯದ್ಯ ಶ್ವಃ ಪರಶ್ವಶ್ಚ ಮಯಾ ಗಮನಾಗಮನೇ ಕರ್ತ್ತವ್ಯೇ, ಯತೋ ಹೇತೋ ರ್ಯಿರೂಶಾಲಮೋ ಬಹಿಃ ಕುತ್ರಾಪಿ ಕೋಪಿ ಭವಿಷ್ಯದ್ವಾದೀ ನ ಘಾನಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","ಹೇ ಯಿರೂಶಾಲಮ್ ಹೇ ಯಿರೂಶಾಲಮ್ ತ್ವಂ ಭವಿಷ್ಯದ್ವಾದಿನೋ ಹಂಸಿ ತವಾನ್ತಿಕೇ ಪ್ರೇರಿತಾನ್ ಪ್ರಸ್ತರೈರ್ಮಾರಯಸಿ ಚ, ಯಥಾ ಕುಕ್ಕುಟೀ ನಿಜಪಕ್ಷಾಧಃ ಸ್ವಶಾವಕಾನ್ ಸಂಗೃಹ್ಲಾತಿ, ತಥಾಹಮಪಿ ತವ ಶಿಶೂನ್ ಸಂಗ್ರಹೀತುಂ ಕತಿವಾರಾನ್ ಐಚ್ಛಂ ಕಿನ್ತು ತ್ವಂ ನೈಚ್ಛಃ| ");
INSERT INTO sankan_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ಪಶ್ಯತ ಯುಷ್ಮಾಕಂ ವಾಸಸ್ಥಾನಾನಿ ಪ್ರೋಚ್ಛಿದ್ಯಮಾನಾನಿ ಪರಿತ್ಯಕ್ತಾನಿ ಚ ಭವಿಷ್ಯನ್ತಿ; ಯುಷ್ಮಾನಹಂ ಯಥಾರ್ಥಂ ವದಾಮಿ, ಯಃ ಪ್ರಭೋ ರ್ನಾಮ್ನಾಗಚ್ಛತಿ ಸ ಧನ್ಯ ಇತಿ ವಾಚಂ ಯಾವತ್ಕಾಲಂ ನ ವದಿಷ್ಯಥ, ತಾವತ್ಕಾಲಂ ಯೂಯಂ ಮಾಂ ನ ದ್ರಕ್ಷ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ಅನನ್ತರಂ ವಿಶ್ರಾಮವಾರೇ ಯೀಶೌ ಪ್ರಧಾನಸ್ಯ ಫಿರೂಶಿನೋ ಗೃಹೇ ಭೋಕ್ತುಂ ಗತವತಿ ತೇ ತಂ ವೀಕ್ಷಿತುಮ್ ಆರೇಭಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ತದಾ ಜಲೋದರೀ ತಸ್ಯ ಸಮ್ಮುಖೇ ಸ್ಥಿತಃ| ");
INSERT INTO sankan_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ತತಃ ಸ ವ್ಯವಸ್ಥಾಪಕಾನ್ ಫಿರೂಶಿನಶ್ಚ ಪಪ್ರಚ್ಛ, ವಿಶ್ರಾಮವಾರೇ ಸ್ವಾಸ್ಥ್ಯಂ ಕರ್ತ್ತವ್ಯಂ ನ ವಾ? ತತಸ್ತೇ ಕಿಮಪಿ ನ ಪ್ರತ್ಯೂಚುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","ತದಾ ಸ ತಂ ರೋಗಿಣಂ ಸ್ವಸ್ಥಂ ಕೃತ್ವಾ ವಿಸಸರ್ಜ; ");
INSERT INTO sankan_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ತಾನುವಾಚ ಚ ಯುಷ್ಮಾಕಂ ಕಸ್ಯಚಿದ್ ಗರ್ದ್ದಭೋ ವೃಷಭೋ ವಾ ಚೇದ್ ಗರ್ತ್ತೇ ಪತತಿ ತರ್ಹಿ ವಿಶ್ರಾಮವಾರೇ ತತ್ಕ್ಷಣಂ ಸ ಕಿಂ ತಂ ನೋತ್ಥಾಪಯಿಷ್ಯತಿ? ");
INSERT INTO sankan_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ತತಸ್ತೇ ಕಥಾಯಾ ಏತಸ್ಯಾಃ ಕಿಮಪಿ ಪ್ರತಿವಕ್ತುಂ ನ ಶೇಕುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ಅಪರಞ್ಚ ಪ್ರಧಾನಸ್ಥಾನಮನೋನೀತತ್ವಕರಣಂ ವಿಲೋಕ್ಯ ಸ ನಿಮನ್ತ್ರಿತಾನ್ ಏತದುಪದೇಶಕಥಾಂ ಜಗಾದ, ");
INSERT INTO sankan_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","ತ್ವಂ ವಿವಾಹಾದಿಭೋಜ್ಯೇಷು ನಿಮನ್ತ್ರಿತಃ ಸನ್ ಪ್ರಧಾನಸ್ಥಾನೇ ಮೋಪಾವೇಕ್ಷೀಃ| ತ್ವತ್ತೋ ಗೌರವಾನ್ವಿತನಿಮನ್ತ್ರಿತಜನ ಆಯಾತೇ ");
INSERT INTO sankan_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ನಿಮನ್ತ್ರಯಿತಾಗತ್ಯ ಮನುಷ್ಯಾಯೈತಸ್ಮೈ ಸ್ಥಾನಂ ದೇಹೀತಿ ವಾಕ್ಯಂ ಚೇದ್ ವಕ್ಷ್ಯತಿ ತರ್ಹಿ ತ್ವಂ ಸಙ್ಕುಚಿತೋ ಭೂತ್ವಾ ಸ್ಥಾನ ಇತರಸ್ಮಿನ್ ಉಪವೇಷ್ಟುಮ್ ಉದ್ಯಂಸ್ಯಸಿ| ");
INSERT INTO sankan_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","ಅಸ್ಮಾತ್ ಕಾರಣಾದೇವ ತ್ವಂ ನಿಮನ್ತ್ರಿತೋ ಗತ್ವಾಽಪ್ರಧಾನಸ್ಥಾನ ಉಪವಿಶ, ತತೋ ನಿಮನ್ತ್ರಯಿತಾಗತ್ಯ ವದಿಷ್ಯತಿ, ಹೇ ಬನ್ಧೋ ಪ್ರೋಚ್ಚಸ್ಥಾನಂ ಗತ್ವೋಪವಿಶ, ತಥಾ ಸತಿ ಭೋಜನೋಪವಿಷ್ಟಾನಾಂ ಸಕಲಾನಾಂ ಸಾಕ್ಷಾತ್ ತ್ವಂ ಮಾನ್ಯೋ ಭವಿಷ್ಯಸಿ| ");
INSERT INTO sankan_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","ಯಃ ಕಶ್ಚಿತ್ ಸ್ವಮುನ್ನಮಯತಿ ಸ ನಮಯಿಷ್ಯತೇ, ಕಿನ್ತು ಯಃ ಕಶ್ಚಿತ್ ಸ್ವಂ ನಮಯತಿ ಸ ಉನ್ನಮಯಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ತದಾ ಸ ನಿಮನ್ತ್ರಯಿತಾರಂ ಜನಮಪಿ ಜಗಾದ, ಮಧ್ಯಾಹ್ನೇ ರಾತ್ರೌ ವಾ ಭೋಜ್ಯೇ ಕೃತೇ ನಿಜಬನ್ಧುಗಣೋ ವಾ ಭ್ರಾತೃृಗಣೋ ವಾ ಜ್ಞಾತಿಗಣೋ ವಾ ಧನಿಗಣೋ ವಾ ಸಮೀಪವಾಸಿಗಣೋ ವಾ ಏತಾನ್ ನ ನಿಮನ್ತ್ರಯ, ತಥಾ ಕೃತೇ ಚೇತ್ ತೇ ತ್ವಾಂ ನಿಮನ್ತ್ರಯಿಷ್ಯನ್ತಿ, ತರ್ಹಿ ಪರಿಶೋಧೋ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","ಕಿನ್ತು ಯದಾ ಭೇಜ್ಯಂ ಕರೋಷಿ ತದಾ ದರಿದ್ರಶುಷ್ಕಕರಖಞ್ಜಾನ್ಧಾನ್ ನಿಮನ್ತ್ರಯ, ");
INSERT INTO sankan_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ತತ ಆಶಿಷಂ ಲಪ್ಸ್ಯಸೇ, ತೇಷು ಪರಿಶೋಧಂ ಕರ್ತ್ತುಮಶಕ್ನುವತ್ಸು ಶ್ಮಶಾನಾದ್ಧಾರ್ಮ್ಮಿಕಾನಾಮುತ್ಥಾನಕಾಲೇ ತ್ವಂ ಫಲಾಂ ಲಪ್ಸ್ಯಸೇ| ");
INSERT INTO sankan_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ಅನನ್ತರಂ ತಾಂ ಕಥಾಂ ನಿಶಮ್ಯ ಭೋಜನೋಪವಿಷ್ಟಃ ಕಶ್ಚಿತ್ ಕಥಯಾಮಾಸ, ಯೋ ಜನ ಈಶ್ವರಸ್ಯ ರಾಜ್ಯೇ ಭೋಕ್ತುಂ ಲಪ್ಸ್ಯತೇ ಸಏವ ಧನ್ಯಃ| ");
INSERT INTO sankan_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ತತಃ ಸ ಉವಾಚ, ಕಶ್ಚಿತ್ ಜನೋ ರಾತ್ರೌ ಭೇाಜ್ಯಂ ಕೃತ್ವಾ ಬಹೂನ್ ನಿಮನ್ತ್ರಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ತತೋ ಭೋಜನಸಮಯೇ ನಿಮನ್ತ್ರಿತಲೋಕಾನ್ ಆಹ್ವಾತುಂ ದಾಸದ್ವಾರಾ ಕಥಯಾಮಾಸ, ಖದ್ಯದ್ರವ್ಯಾಣಿ ಸರ್ವ್ವಾಣಿ ಸಮಾಸಾದಿತಾನಿ ಸನ್ತಿ, ಯೂಯಮಾಗಚ್ಛತ| ");
INSERT INTO sankan_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","ಕಿನ್ತು ತೇ ಸರ್ವ್ವ ಏಕೈಕಂ ಛಲಂ ಕೃತ್ವಾ ಕ್ಷಮಾಂ ಪ್ರಾರ್ಥಯಾಞ್ಚಕ್ರಿರೇ| ಪ್ರಥಮೋ ಜನಃ ಕಥಯಾಮಾಸ, ಕ್ಷೇತ್ರಮೇಕಂ ಕ್ರೀತವಾನಹಂ ತದೇವ ದ್ರಷ್ಟುಂ ಮಯಾ ಗನ್ತವ್ಯಮ್, ಅತಏವ ಮಾಂ ಕ್ಷನ್ತುಂ ತಂ ನಿವೇದಯ| ");
INSERT INTO sankan_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","ಅನ್ಯೋ ಜನಃ ಕಥಯಾಮಾಸ, ದಶವೃಷಾನಹಂ ಕ್ರೀತವಾನ್ ತಾನ್ ಪರೀಕ್ಷಿತುಂ ಯಾಮಿ ತಸ್ಮಾದೇವ ಮಾಂ ಕ್ಷನ್ತುಂ ತಂ ನಿವೇದಯ| ");
INSERT INTO sankan_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","ಅಪರಃ ಕಥಯಾಮಾಸ, ವ್ಯೂಢವಾನಹಂ ತಸ್ಮಾತ್ ಕಾರಣಾದ್ ಯಾತುಂ ನ ಶಕ್ನೋಮಿ| ");
INSERT INTO sankan_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","ಪಶ್ಚಾತ್ ಸ ದಾಸೋ ಗತ್ವಾ ನಿಜಪ್ರಭೋಃ ಸಾಕ್ಷಾತ್ ಸರ್ವ್ವವೃತ್ತಾನ್ತಂ ನಿವೇದಯಾಮಾಸ, ತತೋಸೌ ಗೃಹಪತಿಃ ಕುಪಿತ್ವಾ ಸ್ವದಾಸಂ ವ್ಯಾಜಹಾರ, ತ್ವಂ ಸತ್ವರಂ ನಗರಸ್ಯ ಸನ್ನಿವೇಶಾನ್ ಮಾರ್ಗಾಂಶ್ಚ ಗತ್ವಾ ದರಿದ್ರಶುಷ್ಕಕರಖಞ್ಜಾನ್ಧಾನ್ ಅತ್ರಾನಯ| ");
INSERT INTO sankan_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","ತತೋ ದಾಸೋಽವದತ್, ಹೇ ಪ್ರಭೋ ಭವತ ಆಜ್ಞಾನುಸಾರೇಣಾಕ್ರಿಯತ ತಥಾಪಿ ಸ್ಥಾನಮಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","ತದಾ ಪ್ರಭುಃ ಪುನ ರ್ದಾಸಾಯಾಕಥಯತ್, ರಾಜಪಥಾನ್ ವೃಕ್ಷಮೂಲಾನಿ ಚ ಯಾತ್ವಾ ಮದೀಯಗೃಹಪೂರಣಾರ್ಥಂ ಲೋಕಾನಾಗನ್ತುಂ ಪ್ರವರ್ತ್ತಯ| ");
INSERT INTO sankan_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ಅಹಂ ಯುಷ್ಮಭ್ಯಂ ಕಥಯಾಮಿ, ಪೂರ್ವ್ವನಿಮನ್ತ್ರಿತಾನಮೇಕೋಪಿ ಮಮಾಸ್ಯ ರಾತ್ರಿಭೋಜ್ಯಸ್ಯಾಸ್ವಾದಂ ನ ಪ್ರಾಪ್ಸ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","ಅನನ್ತರಂ ಬಹುಷು ಲೋಕೇಷು ಯೀಶೋಃ ಪಶ್ಚಾದ್ ವ್ರಜಿತೇಷು ಸತ್ಸು ಸ ವ್ಯಾಘುಟ್ಯ ತೇಭ್ಯಃ ಕಥಯಾಮಾಸ, ");
INSERT INTO sankan_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","ಯಃ ಕಶ್ಚಿನ್ ಮಮ ಸಮೀಪಮ್ ಆಗತ್ಯ ಸ್ವಸ್ಯ ಮಾತಾ ಪಿತಾ ಪತ್ನೀ ಸನ್ತಾನಾ ಭ್ರಾತರೋ ಭಗಿಮ್ಯೋ ನಿಜಪ್ರಾಣಾಶ್ಚ, ಏತೇಭ್ಯಃ ಸರ್ವ್ವೇಭ್ಯೋ ಮಯ್ಯಧಿಕಂ ಪ್ರೇಮ ನ ಕರೋತಿ, ಸ ಮಮ ಶಿಷ್ಯೋ ಭವಿತುಂ ನ ಶಕ್ಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ಯಃ ಕಶ್ಚಿತ್ ಸ್ವೀಯಂ ಕ್ರುಶಂ ವಹನ್ ಮಮ ಪಶ್ಚಾನ್ನ ಗಚ್ಛತಿ, ಸೋಪಿ ಮಮ ಶಿಷ್ಯೋ ಭವಿತುಂ ನ ಶಕ್ಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","ದುರ್ಗನಿರ್ಮ್ಮಾಣೇ ಕತಿವ್ಯಯೋ ಭವಿಷ್ಯತಿ, ತಥಾ ತಸ್ಯ ಸಮಾಪ್ತಿಕರಣಾರ್ಥಂ ಸಮ್ಪತ್ತಿರಸ್ತಿ ನ ವಾ, ಪ್ರಥಮಮುಪವಿಶ್ಯ ಏತನ್ನ ಗಣಯತಿ, ಯುಷ್ಮಾಕಂ ಮಧ್ಯ ಏತಾದೃಶಃ ಕೋಸ್ತಿ? ");
INSERT INTO sankan_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","ನೋಚೇದ್ ಭಿತ್ತಿಂ ಕೃತ್ವಾ ಶೇಷೇ ಯದಿ ಸಮಾಪಯಿತುಂ ನ ಶಕ್ಷ್ಯತಿ, ");
INSERT INTO sankan_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ತರ್ಹಿ ಮಾನುಷೋಯಂ ನಿಚೇತುಮ್ ಆರಭತ ಸಮಾಪಯಿತುಂ ನಾಶಕ್ನೋತ್, ಇತಿ ವ್ಯಾಹೃತ್ಯ ಸರ್ವ್ವೇ ತಮುಪಹಸಿಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","ಅಪರಞ್ಚ ಭಿನ್ನಭೂಪತಿನಾ ಸಹ ಯುದ್ಧಂ ಕರ್ತ್ತುಮ್ ಉದ್ಯಮ್ಯ ದಶಸಹಸ್ರಾಣಿ ಸೈನ್ಯಾನಿ ಗೃಹೀತ್ವಾ ವಿಂಶತಿಸಹಸ್ರೇಃ ಸೈನ್ಯೈಃ ಸಹಿತಸ್ಯ ಸಮೀಪವಾಸಿನಃ ಸಮ್ಮುಖಂ ಯಾತುಂ ಶಕ್ಷ್ಯಾಮಿ ನ ವೇತಿ ಪ್ರಥಮಂ ಉಪವಿಶ್ಯ ನ ವಿಚಾರಯತಿ ಏತಾದೃಶೋ ಭೂಮಿಪತಿಃ ಕಃ? ");
INSERT INTO sankan_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","ಯದಿ ನ ಶಕ್ನೋತಿ ತರ್ಹಿ ರಿಪಾವತಿದೂರೇ ತಿಷ್ಠತಿ ಸತಿ ನಿಜದೂತಂ ಪ್ರೇಷ್ಯ ಸನ್ಧಿಂ ಕರ್ತ್ತುಂ ಪ್ರಾರ್ಥಯೇತ| ");
INSERT INTO sankan_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","ತದ್ವದ್ ಯುಷ್ಮಾಕಂ ಮಧ್ಯೇ ಯಃ ಕಶ್ಚಿನ್ ಮದರ್ಥಂ ಸರ್ವ್ವಸ್ವಂ ಹಾತುಂ ನ ಶಕ್ನೋತಿ ಸ ಮಮ ಶಿಷ್ಯೋ ಭವಿತುಂ ನ ಶಕ್ಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","ಲವಣಮ್ ಉತ್ತಮಮ್ ಇತಿ ಸತ್ಯಂ, ಕಿನ್ತು ಯದಿ ಲವಣಸ್ಯ ಲವಣತ್ವಮ್ ಅಪಗಚ್ಛತಿ ತರ್ಹಿ ತತ್ ಕಥಂ ಸ್ವಾದುಯುಕ್ತಂ ಭವಿಷ್ಯತಿ? ");
INSERT INTO sankan_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ತದ ಭೂಮ್ಯರ್ಥಮ್ ಆಲವಾಲರಾಶ್ಯರ್ಥಮಪಿ ಭದ್ರಂ ನ ಭವತಿ; ಲೋಕಾಸ್ತದ್ ಬಹಿಃ ಕ್ಷಿಪನ್ತಿ| ಯಸ್ಯ ಶ್ರೋತುಂ ಶ್ರೋತ್ರೇ ಸ್ತಃ ಸ ಶೃಣೋತು| ");
INSERT INTO sankan_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ತದಾ ಕರಸಞ್ಚಾಯಿನಃ ಪಾಪಿನಶ್ಚ ಲೋಕಾ ಉಪದೇಶ್ಕಥಾಂ ಶ್ರೋತುಂ ಯೀಶೋಃ ಸಮೀಪಮ್ ಆಗಚ್ಛನ್| ");
INSERT INTO sankan_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ತತಃ ಫಿರೂಶಿನ ಉಪಾಧ್ಯಾಯಾಶ್ಚ ವಿವದಮಾನಾಃ ಕಥಯಾಮಾಸುಃ ಏಷ ಮಾನುಷಃ ಪಾಪಿಭಿಃ ಸಹ ಪ್ರಣಯಂ ಕೃತ್ವಾ ತೈಃ ಸಾರ್ದ್ಧಂ ಭುಂಕ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ತದಾ ಸ ತೇಭ್ಯ ಇಮಾಂ ದೃಷ್ಟಾನ್ತಕಥಾಂ ಕಥಿತವಾನ್, ");
INSERT INTO sankan_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","ಕಸ್ಯಚಿತ್ ಶತಮೇಷೇಷು ತಿಷ್ಠತ್ಮು ತೇಷಾಮೇಕಂ ಸ ಯದಿ ಹಾರಯತಿ ತರ್ಹಿ ಮಧ್ಯೇಪ್ರಾನ್ತರಮ್ ಏಕೋನಶತಮೇಷಾನ್ ವಿಹಾಯ ಹಾರಿತಮೇಷಸ್ಯ ಉದ್ದೇಶಪ್ರಾಪ್ತಿಪರ್ಯ್ಯನತಂ ನ ಗವೇಷಯತಿ, ಏತಾದೃಶೋ ಲೋಕೋ ಯುಷ್ಮಾಕಂ ಮಧ್ಯೇ ಕ ಆಸ್ತೇ? ");
INSERT INTO sankan_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","ತಸ್ಯೋದ್ದೇಶಂ ಪ್ರಾಪ್ಯ ಹೃಷ್ಟಮನಾಸ್ತಂ ಸ್ಕನ್ಧೇ ನಿಧಾಯ ಸ್ವಸ್ಥಾನಮ್ ಆನೀಯ ಬನ್ಧುಬಾನ್ಧವಸಮೀಪವಾಸಿನ ಆಹೂಯ ವಕ್ತಿ, ");
INSERT INTO sankan_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ಹಾರಿತಂ ಮೇಷಂ ಪ್ರಾಪ್ತೋಹಮ್ ಅತೋ ಹೇತೋ ರ್ಮಯಾ ಸಾರ್ದ್ಧಮ್ ಆನನ್ದತ| ");
INSERT INTO sankan_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","ತದ್ವದಹಂ ಯುಷ್ಮಾನ್ ವದಾಮಿ, ಯೇಷಾಂ ಮನಃಪರಾವರ್ತ್ತನಸ್ಯ ಪ್ರಯೋಜನಂ ನಾಸ್ತಿ, ತಾದೃಶೈಕೋನಶತಧಾರ್ಮ್ಮಿಕಕಾರಣಾದ್ ಯ ಆನನ್ದಸ್ತಸ್ಮಾದ್ ಏಕಸ್ಯ ಮನಃಪರಿವರ್ತ್ತಿನಃ ಪಾಪಿನಃ ಕಾರಣಾತ್ ಸ್ವರ್ಗೇ ಽಧಿಕಾನನ್ದೋ ಜಾಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","ಅಪರಞ್ಚ ದಶಾನಾಂ ರೂಪ್ಯಖಣ್ಡಾನಾಮ್ ಏಕಖಣ್ಡೇ ಹಾರಿತೇ ಪ್ರದೀಪಂ ಪ್ರಜ್ವಾಲ್ಯ ಗೃಹಂ ಸಮ್ಮಾರ್ಜ್ಯ ತಸ್ಯ ಪ್ರಾಪ್ತಿಂ ಯಾವದ್ ಯತ್ನೇನ ನ ಗವೇಷಯತಿ, ಏತಾದೃಶೀ ಯೋಷಿತ್ ಕಾಸ್ತೇ? ");
INSERT INTO sankan_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ಪ್ರಾಪ್ತೇ ಸತಿ ಬನ್ಧುಬಾನ್ಧವಸಮೀಪವಾಸಿನೀರಾಹೂಯ ಕಥಯತಿ, ಹಾರಿತಂ ರೂಪ್ಯಖಣ್ಡಂ ಪ್ರಾಪ್ತಾಹಂ ತಸ್ಮಾದೇವ ಮಯಾ ಸಾರ್ದ್ಧಮ್ ಆನನ್ದತ| ");
INSERT INTO sankan_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","ತದ್ವದಹಂ ಯುಷ್ಮಾನ್ ವ್ಯಾಹರಾಮಿ, ಏಕೇನ ಪಾಪಿನಾ ಮನಸಿ ಪರಿವರ್ತ್ತಿತೇ, ಈಶ್ವರಸ್ಯ ದೂತಾನಾಂ ಮಧ್ಯೇಪ್ಯಾನನ್ದೋ ಜಾಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","ಅಪರಞ್ಚ ಸ ಕಥಯಾಮಾಸ, ಕಸ್ಯಚಿದ್ ದ್ವೌ ಪುತ್ರಾವಾಸ್ತಾಂ, ");
INSERT INTO sankan_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ತಯೋಃ ಕನಿಷ್ಠಃ ಪುತ್ರಃ ಪಿತ್ರೇ ಕಥಯಾಮಾಸ, ಹೇ ಪಿತಸ್ತವ ಸಮ್ಪತ್ತ್ಯಾ ಯಮಂಶಂ ಪ್ರಾಪ್ಸ್ಯಾಮ್ಯಹಂ ವಿಭಜ್ಯ ತಂ ದೇಹಿ, ತತಃ ಪಿತಾ ನಿಜಾಂ ಸಮ್ಪತ್ತಿಂ ವಿಭಜ್ಯ ತಾಭ್ಯಾಂ ದದೌ| ");
INSERT INTO sankan_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","ಕತಿಪಯಾತ್ ಕಾಲಾತ್ ಪರಂ ಸ ಕನಿಷ್ಠಪುತ್ರಃ ಸಮಸ್ತಂ ಧನಂ ಸಂಗೃಹ್ಯ ದೂರದೇಶಂ ಗತ್ವಾ ದುಷ್ಟಾಚರಣೇನ ಸರ್ವ್ವಾಂ ಸಮ್ಪತ್ತಿಂ ನಾಶಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ತಸ್ಯ ಸರ್ವ್ವಧನೇ ವ್ಯಯಂ ಗತೇ ತದ್ದೇಶೇ ಮಹಾದುರ್ಭಿಕ್ಷಂ ಬಭೂವ, ತತಸ್ತಸ್ಯ ದೈನ್ಯದಶಾ ಭವಿತುಮ್ ಆರೇಭೇ| ");
INSERT INTO sankan_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ತತಃ ಪರಂ ಸ ಗತ್ವಾ ತದ್ದೇಶೀಯಂ ಗೃಹಸ್ಥಮೇಕಮ್ ಆಶ್ರಯತ; ತತಃ ಸತಂ ಶೂಕರವ್ರಜಂ ಚಾರಯಿತುಂ ಪ್ರಾನ್ತರಂ ಪ್ರೇಷಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ಕೇನಾಪಿ ತಸ್ಮೈ ಭಕ್ಷ್ಯಾದಾನಾತ್ ಸ ಶೂಕರಫಲವಲ್ಕಲೇನ ಪಿಚಿಣ್ಡಪೂರಣಾಂ ವವಾಞ್ಛ| ");
INSERT INTO sankan_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ಶೇಷೇ ಸ ಮನಸಿ ಚೇತನಾಂ ಪ್ರಾಪ್ಯ ಕಥಯಾಮಾಸ, ಹಾ ಮಮ ಪಿತುಃ ಸಮೀಪೇ ಕತಿ ಕತಿ ವೇತನಭುಜೋ ದಾಸಾ ಯಥೇಷ್ಟಂ ತತೋಧಿಕಞ್ಚ ಭಕ್ಷ್ಯಂ ಪ್ರಾಪ್ನುವನ್ತಿ ಕಿನ್ತ್ವಹಂ ಕ್ಷುಧಾ ಮುಮೂರ್ಷುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ಅಹಮುತ್ಥಾಯ ಪಿತುಃ ಸಮೀಪಂ ಗತ್ವಾ ಕಥಾಮೇತಾಂ ವದಿಷ್ಯಾಮಿ, ಹೇ ಪಿತರ್ ಈಶ್ವರಸ್ಯ ತವ ಚ ವಿರುದ್ಧಂ ಪಾಪಮಕರವಮ್ ");
INSERT INTO sankan_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ತವ ಪುತ್ರಇತಿ ವಿಖ್ಯಾತೋ ಭವಿತುಂ ನ ಯೋಗ್ಯೋಸ್ಮಿ ಚ, ಮಾಂ ತವ ವೈತನಿಕಂ ದಾಸಂ ಕೃತ್ವಾ ಸ್ಥಾಪಯ| ");
INSERT INTO sankan_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","ಪಶ್ಚಾತ್ ಸ ಉತ್ಥಾಯ ಪಿತುಃ ಸಮೀಪಂ ಜಗಾಮ; ತತಸ್ತಸ್ಯ ಪಿತಾತಿದೂರೇ ತಂ ನಿರೀಕ್ಷ್ಯ ದಯಾಞ್ಚಕ್ರೇ, ಧಾವಿತ್ವಾ ತಸ್ಯ ಕಣ್ಠಂ ಗೃಹೀತ್ವಾ ತಂ ಚುಚುಮ್ಬ ಚ| ");
INSERT INTO sankan_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ತದಾ ಪುತ್ರ ಉವಾಚ, ಹೇ ಪಿತರ್ ಈಶ್ವರಸ್ಯ ತವ ಚ ವಿರುದ್ಧಂ ಪಾಪಮಕರವಂ, ತವ ಪುತ್ರಇತಿ ವಿಖ್ಯಾತೋ ಭವಿತುಂ ನ ಯೋಗ್ಯೋಸ್ಮಿ ಚ| ");
INSERT INTO sankan_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","ಕಿನ್ತು ತಸ್ಯ ಪಿತಾ ನಿಜದಾಸಾನ್ ಆದಿದೇಶ, ಸರ್ವ್ವೋತ್ತಮವಸ್ತ್ರಾಣ್ಯಾನೀಯ ಪರಿಧಾಪಯತೈನಂ ಹಸ್ತೇ ಚಾಙ್ಗುರೀಯಕಮ್ ಅರ್ಪಯತ ಪಾದಯೋಶ್ಚೋಪಾನಹೌ ಸಮರ್ಪಯತ; ");
INSERT INTO sankan_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ಪುಷ್ಟಂ ಗೋವತ್ಸಮ್ ಆನೀಯ ಮಾರಯತ ಚ ತಂ ಭುಕ್ತ್ವಾ ವಯಮ್ ಆನನ್ದಾಮ| ");
INSERT INTO sankan_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ಯತೋ ಮಮ ಪುತ್ರೋಯಮ್ ಅಮ್ರಿಯತ ಪುನರಜೀವೀದ್ ಹಾರಿತಶ್ಚ ಲಬ್ಧೋಭೂತ್ ತತಸ್ತ ಆನನ್ದಿತುಮ್ ಆರೇಭಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","ತತ್ಕಾಲೇ ತಸ್ಯ ಜ್ಯೇಷ್ಠಃ ಪುತ್ರಃ ಕ್ಷೇತ್ರ ಆಸೀತ್| ಅಥ ಸ ನಿವೇಶನಸ್ಯ ನಿಕಟಂ ಆಗಚ್ಛನ್ ನೃತ್ಯಾನಾಂ ವಾದ್ಯಾನಾಞ್ಚ ಶಬ್ದಂ ಶ್ರುತ್ವಾ ");
INSERT INTO sankan_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ದಾಸಾನಾಮ್ ಏಕಮ್ ಆಹೂಯ ಪಪ್ರಚ್ಛ, ಕಿಂ ಕಾರಣಮಸ್ಯ? ");
INSERT INTO sankan_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","ತತಃ ಸೋವಾದೀತ್, ತವ ಭ್ರಾತಾಗಮತ್, ತವ ತಾತಶ್ಚ ತಂ ಸುಶರೀರಂ ಪ್ರಾಪ್ಯ ಪುಷ್ಟಂ ಗೋವತ್ಸಂ ಮಾರಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","ತತಃ ಸ ಪ್ರಕುಪ್ಯ ನಿವೇಶನಾನ್ತಃ ಪ್ರವೇಷ್ಟುಂ ನ ಸಮ್ಮೇನೇ; ತತಸ್ತಸ್ಯ ಪಿತಾ ಬಹಿರಾಗತ್ಯ ತಂ ಸಾಧಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ತತಃ ಸ ಪಿತರಂ ಪ್ರತ್ಯುವಾಚ, ಪಶ್ಯ ತವ ಕಾಞ್ಚಿದಪ್ಯಾಜ್ಞಾಂ ನ ವಿಲಂಘ್ಯ ಬಹೂನ್ ವತ್ಸರಾನ್ ಅಹಂ ತ್ವಾಂ ಸೇವೇ ತಥಾಪಿ ಮಿತ್ರೈಃ ಸಾರ್ದ್ಧಮ್ ಉತ್ಸವಂ ಕರ್ತ್ತುಂ ಕದಾಪಿ ಛಾಗಮೇಕಮಪಿ ಮಹ್ಯಂ ನಾದದಾಃ; ");
INSERT INTO sankan_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","ಕಿನ್ತು ತವ ಯಃ ಪುತ್ರೋ ವೇಶ್ಯಾಗಮನಾದಿಭಿಸ್ತವ ಸಮ್ಪತ್ತಿಮ್ ಅಪವ್ಯಯಿತವಾನ್ ತಸ್ಮಿನ್ನಾಗತಮಾತ್ರೇ ತಸ್ಯೈವ ನಿಮಿತ್ತಂ ಪುಷ್ಟಂ ಗೋವತ್ಸಂ ಮಾರಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","ತದಾ ತಸ್ಯ ಪಿತಾವೋಚತ್, ಹೇ ಪುತ್ರ ತ್ವಂ ಸರ್ವ್ವದಾ ಮಯಾ ಸಹಾಸಿ ತಸ್ಮಾನ್ ಮಮ ಯದ್ಯದಾಸ್ತೇ ತತ್ಸರ್ವ್ವಂ ತವ| ");
INSERT INTO sankan_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","ಕಿನ್ತು ತವಾಯಂ ಭ್ರಾತಾ ಮೃತಃ ಪುನರಜೀವೀದ್ ಹಾರಿತಶ್ಚ ಭೂತ್ವಾ ಪ್ರಾಪ್ತೋಭೂತ್, ಏತಸ್ಮಾತ್ ಕಾರಣಾದ್ ಉತ್ಸವಾನನ್ದೌ ಕರ್ತ್ತುಮ್ ಉಚಿತಮಸ್ಮಾಕಮ್| ");
INSERT INTO sankan_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","ಅಪರಞ್ಚ ಯೀಶುಃ ಶಿಷ್ಯೇಭ್ಯೋನ್ಯಾಮೇಕಾಂ ಕಥಾಂ ಕಥಯಾಮಾಸ ಕಸ್ಯಚಿದ್ ಧನವತೋ ಮನುಷ್ಯಸ್ಯ ಗೃಹಕಾರ್ಯ್ಯಾಧೀಶೇ ಸಮ್ಪತ್ತೇರಪವ್ಯಯೇಽಪವಾದಿತೇ ಸತಿ ");
INSERT INTO sankan_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","ತಸ್ಯ ಪ್ರಭುಸ್ತಮ್ ಆಹೂಯ ಜಗಾದ, ತ್ವಯಿ ಯಾಮಿಮಾಂ ಕಥಾಂ ಶೃಣೋಮಿ ಸಾ ಕೀದೃಶೀ? ತ್ವಂ ಗೃಹಕಾರ್ಯ್ಯಾಧೀಶಕರ್ಮ್ಮಣೋ ಗಣನಾಂ ದರ್ಶಯ ಗೃಹಕಾರ್ಯ್ಯಾಧೀಶಪದೇ ತ್ವಂ ನ ಸ್ಥಾಸ್ಯಸಿ| ");
INSERT INTO sankan_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","ತದಾ ಸ ಗೃಹಕಾರ್ಯ್ಯಾಧೀಶೋ ಮನಸಾ ಚಿನ್ತಯಾಮಾಸ, ಪ್ರಭು ರ್ಯದಿ ಮಾಂ ಗೃಹಕಾರ್ಯ್ಯಾಧೀಶಪದಾದ್ ಭ್ರಂಶಯತಿ ತರ್ಹಿ ಕಿಂ ಕರಿಷ್ಯೇಽಹಂ? ಮೃದಂ ಖನಿತುಂ ಮಮ ಶಕ್ತಿ ರ್ನಾಸ್ತಿ ಭಿಕ್ಷಿತುಞ್ಚ ಲಜ್ಜಿಷ್ಯೇಽಹಂ| ");
INSERT INTO sankan_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ಅತಏವ ಮಯಿ ಗೃಹಕಾರ್ಯ್ಯಾಧೀಶಪದಾತ್ ಚ್ಯುತೇ ಸತಿ ಯಥಾ ಲೋಕಾ ಮಹ್ಯಮ್ ಆಶ್ರಯಂ ದಾಸ್ಯನ್ತಿ ತದರ್ಥಂ ಯತ್ಕರ್ಮ್ಮ ಮಯಾ ಕರಣೀಯಂ ತನ್ ನಿರ್ಣೀಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","ಪಶ್ಚಾತ್ ಸ ಸ್ವಪ್ರಭೋರೇಕೈಕಮ್ ಅಧಮರ್ಣಮ್ ಆಹೂಯ ಪ್ರಥಮಂ ಪಪ್ರಚ್ಛ, ತ್ವತ್ತೋ ಮೇ ಪ್ರಭುಣಾ ಕತಿ ಪ್ರಾಪ್ಯಮ್? ");
INSERT INTO sankan_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ತತಃ ಸ ಉವಾಚ, ಏಕಶತಾಢಕತೈಲಾನಿ; ತದಾ ಗೃಹಕಾರ್ಯ್ಯಾಧೀಶಃ ಪ್ರೋವಾಚ, ತವ ಪತ್ರಮಾನೀಯ ಶೀಘ್ರಮುಪವಿಶ್ಯ ತತ್ರ ಪಞ್ಚಾಶತಂ ಲಿಖ| ");
INSERT INTO sankan_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","ಪಶ್ಚಾದನ್ಯಮೇಕಂ ಪಪ್ರಚ್ಛ, ತ್ವತ್ತೋ ಮೇ ಪ್ರಭುಣಾ ಕತಿ ಪ್ರಾಪ್ಯಮ್? ತತಃ ಸೋವಾದೀದ್ ಏಕಶತಾಢಕಗೋಧೂಮಾಃ; ತದಾ ಸ ಕಥಯಾಮಾಸ, ತವ ಪತ್ರಮಾನೀಯ ಅಶೀತಿಂ ಲಿಖ| ");
INSERT INTO sankan_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","ತೇನೈವ ಪ್ರಭುಸ್ತಮಯಥಾರ್ಥಕೃತಮ್ ಅಧೀಶಂ ತದ್ಬುದ್ಧಿನೈಪುಣ್ಯಾತ್ ಪ್ರಶಶಂಸ; ಇತ್ಥಂ ದೀಪ್ತಿರೂಪಸನ್ತಾನೇಭ್ಯ ಏತತ್ಸಂಸಾರಸ್ಯ ಸನ್ತಾನಾ ವರ್ತ್ತಮಾನಕಾಲೇಽಧಿಕಬುದ್ಧಿಮನ್ತೋ ಭವನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","ಅತೋ ವದಾಮಿ ಯೂಯಮಪ್ಯಯಥಾರ್ಥೇನ ಧನೇನ ಮಿತ್ರಾಣಿ ಲಭಧ್ವಂ ತತೋ ಯುಷ್ಮಾಸು ಪದಭ್ರಷ್ಟೇಷ್ವಪಿ ತಾನಿ ಚಿರಕಾಲಮ್ ಆಶ್ರಯಂ ದಾಸ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ಯಃ ಕಶ್ಚಿತ್ ಕ್ಷುದ್ರೇ ಕಾರ್ಯ್ಯೇ ವಿಶ್ವಾಸ್ಯೋ ಭವತಿ ಸ ಮಹತಿ ಕಾರ್ಯ್ಯೇಪಿ ವಿಶ್ವಾಸ್ಯೋ ಭವತಿ, ಕಿನ್ತು ಯಃ ಕಶ್ಚಿತ್ ಕ್ಷುದ್ರೇ ಕಾರ್ಯ್ಯೇಽವಿಶ್ವಾಸ್ಯೋ ಭವತಿ ಸ ಮಹತಿ ಕಾರ್ಯ್ಯೇಪ್ಯವಿಶ್ವಾಸ್ಯೋ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ಅತಏವ ಅಯಥಾರ್ಥೇನ ಧನೇನ ಯದಿ ಯೂಯಮವಿಶ್ವಾಸ್ಯಾ ಜಾತಾಸ್ತರ್ಹಿ ಸತ್ಯಂ ಧನಂ ಯುಷ್ಮಾಕಂ ಕರೇಷು ಕಃ ಸಮರ್ಪಯಿಷ್ಯತಿ? ");
INSERT INTO sankan_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","ಯದಿ ಚ ಪರಧನೇನ ಯೂಯಮ್ ಅವಿಶ್ವಾಸ್ಯಾ ಭವಥ ತರ್ಹಿ ಯುಷ್ಮಾಕಂ ಸ್ವಕೀಯಧನಂ ಯುಷ್ಮಭ್ಯಂ ಕೋ ದಾಸ್ಯತಿ? ");
INSERT INTO sankan_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","ಕೋಪಿ ದಾಸ ಉಭೌ ಪ್ರಭೂ ಸೇವಿತುಂ ನ ಶಕ್ನೋತಿ, ಯತ ಏಕಸ್ಮಿನ್ ಪ್ರೀಯಮಾಣೋಽನ್ಯಸ್ಮಿನ್ನಪ್ರೀಯತೇ ಯದ್ವಾ ಏಕಂ ಜನಂ ಸಮಾದೃತ್ಯ ತದನ್ಯಂ ತುಚ್ಛೀಕರೋತಿ ತದ್ವದ್ ಯೂಯಮಪಿ ಧನೇಶ್ವರೌ ಸೇವಿತುಂ ನ ಶಕ್ನುಥ| ");
INSERT INTO sankan_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ತದೈತಾಃ ಸರ್ವ್ವಾಃ ಕಥಾಃ ಶ್ರುತ್ವಾ ಲೋಭಿಫಿರೂಶಿನಸ್ತಮುಪಜಹಸುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ತತಃ ಸ ಉವಾಚ, ಯೂಯಂ ಮನುಷ್ಯಾಣಾಂ ನಿಕಟೇ ಸ್ವಾನ್ ನಿರ್ದೋಷಾನ್ ದರ್ಶಯಥ ಕಿನ್ತು ಯುಷ್ಮಾಕಮ್ ಅನ್ತಃಕರಣಾನೀಶ್ವರೋ ಜಾನಾತಿ, ಯತ್ ಮನುಷ್ಯಾಣಾಮ್ ಅತಿ ಪ್ರಶಂಸ್ಯಂ ತದ್ ಈಶ್ವರಸ್ಯ ಘೃಣ್ಯಂ| ");
INSERT INTO sankan_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","ಯೋಹನ ಆಗಮನಪರ್ಯ್ಯನತಂ ಯುಷ್ಮಾಕಂ ಸಮೀಪೇ ವ್ಯವಸ್ಥಾಭವಿಷ್ಯದ್ವಾದಿನಾಂ ಲೇಖನಾನಿ ಚಾಸನ್ ತತಃ ಪ್ರಭೃತಿ ಈಶ್ವರರಾಜ್ಯಸ್ಯ ಸುಸಂವಾದಃ ಪ್ರಚರತಿ, ಏಕೈಕೋ ಲೋಕಸ್ತನ್ಮಧ್ಯಂ ಯತ್ನೇನ ಪ್ರವಿಶತಿ ಚ| ");
INSERT INTO sankan_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ವರಂ ನಭಸಃ ಪೃಥಿವ್ಯಾಶ್ಚ ಲೋಪೋ ಭವಿಷ್ಯತಿ ತಥಾಪಿ ವ್ಯವಸ್ಥಾಯಾ ಏಕಬಿನ್ದೋರಪಿ ಲೋಪೋ ನ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","ಯಃ ಕಶ್ಚಿತ್ ಸ್ವೀಯಾಂ ಭಾರ್ಯ್ಯಾಂ ವಿಹಾಯ ಸ್ತ್ರಿಯಮನ್ಯಾಂ ವಿವಹತಿ ಸ ಪರದಾರಾನ್ ಗಚ್ಛತಿ, ಯಶ್ಚ ತಾ ತ್ಯಕ್ತಾಂ ನಾರೀಂ ವಿವಹತಿ ಸೋಪಿ ಪರದಾರಾನ ಗಚ್ಛತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ಏಕೋ ಧನೀ ಮನುಷ್ಯಃ ಶುಕ್ಲಾನಿ ಸೂಕ್ಷ್ಮಾಣಿ ವಸ್ತ್ರಾಣಿ ಪರ್ಯ್ಯದಧಾತ್ ಪ್ರತಿದಿನಂ ಪರಿತೋಷರೂಪೇಣಾಭುಂಕ್ತಾಪಿವಚ್ಚ| ");
INSERT INTO sankan_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","ಸರ್ವ್ವಾಙ್ಗೇ ಕ್ಷತಯುಕ್ತ ಇಲಿಯಾಸರನಾಮಾ ಕಶ್ಚಿದ್ ದರಿದ್ರಸ್ತಸ್ಯ ಧನವತೋ ಭೋಜನಪಾತ್ರಾತ್ ಪತಿತಮ್ ಉಚ್ಛಿಷ್ಟಂ ಭೋಕ್ತುಂ ವಾಞ್ಛನ್ ತಸ್ಯ ದ್ವಾರೇ ಪತಿತ್ವಾತಿಷ್ಠತ್; ");
INSERT INTO sankan_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ಅಥ ಶ್ವಾನ ಆಗತ್ಯ ತಸ್ಯ ಕ್ಷತಾನ್ಯಲಿಹನ್| ");
INSERT INTO sankan_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","ಕಿಯತ್ಕಾಲಾತ್ಪರಂ ಸ ದರಿದ್ರಃ ಪ್ರಾಣಾನ್ ಜಹೌ; ತತಃ ಸ್ವರ್ಗೀಯದೂತಾಸ್ತಂ ನೀತ್ವಾ ಇಬ್ರಾಹೀಮಃ ಕ್ರೋಡ ಉಪವೇಶಯಾಮಾಸುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ಪಶ್ಚಾತ್ ಸ ಧನವಾನಪಿ ಮಮಾರ, ತಂ ಶ್ಮಶಾನೇ ಸ್ಥಾಪಯಾಮಾಸುಶ್ಚ; ಕಿನ್ತು ಪರಲೋಕೇ ಸ ವೇದನಾಕುಲಃ ಸನ್ ಊರ್ದ್ಧ್ವಾಂ ನಿರೀಕ್ಷ್ಯ ಬಹುದೂರಾದ್ ಇಬ್ರಾಹೀಮಂ ತತ್ಕ್ರೋಡ ಇಲಿಯಾಸರಞ್ಚ ವಿಲೋಕ್ಯ ರುವನ್ನುವಾಚ; ");
INSERT INTO sankan_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ಹೇ ಪಿತರ್ ಇಬ್ರಾಹೀಮ್ ಅನುಗೃಹ್ಯ ಅಙ್ಗುಲ್ಯಗ್ರಭಾಗಂ ಜಲೇ ಮಜ್ಜಯಿತ್ವಾ ಮಮ ಜಿಹ್ವಾಂ ಶೀತಲಾಂ ಕರ್ತ್ತುಮ್ ಇಲಿಯಾಸರಂ ಪ್ರೇರಯ, ಯತೋ ವಹ್ನಿಶಿಖಾತೋಹಂ ವ್ಯಥಿತೋಸ್ಮಿ| ");
INSERT INTO sankan_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","ತದಾ ಇಬ್ರಾಹೀಮ್ ಬಭಾಷೇ, ಹೇ ಪುತ್ರ ತ್ವಂ ಜೀವನ್ ಸಮ್ಪದಂ ಪ್ರಾಪ್ತವಾನ್ ಇಲಿಯಾಸರಸ್ತು ವಿಪದಂ ಪ್ರಾಪ್ತವಾನ್ ಏತತ್ ಸ್ಮರ, ಕಿನ್ತು ಸಮ್ಪ್ರತಿ ತಸ್ಯ ಸುಖಂ ತವ ಚ ದುಃಖಂ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","ಅಪರಮಪಿ ಯುಷ್ಮಾಕಮ್ ಅಸ್ಮಾಕಞ್ಚ ಸ್ಥಾನಯೋ ರ್ಮಧ್ಯೇ ಮಹದ್ವಿಚ್ಛೇದೋಽಸ್ತಿ ತತ ಏತತ್ಸ್ಥಾನಸ್ಯ ಲೋಕಾಸ್ತತ್ ಸ್ಥಾನಂ ಯಾತುಂ ಯದ್ವಾ ತತ್ಸ್ಥಾನಸ್ಯ ಲೋಕಾ ಏತತ್ ಸ್ಥಾನಮಾಯಾತುಂ ನ ಶಕ್ನುವನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","ತದಾ ಸ ಉಕ್ತವಾನ್, ಹೇ ಪಿತಸ್ತರ್ಹಿ ತ್ವಾಂ ನಿವೇದಯಾಮಿ ಮಮ ಪಿತು ರ್ಗೇಹೇ ಯೇ ಮಮ ಪಞ್ಚ ಭ್ರಾತರಃ ಸನ್ತಿ ");
INSERT INTO sankan_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ತೇ ಯಥೈತದ್ ಯಾತನಾಸ್ಥಾನಂ ನಾಯಾಸ್ಯನ್ತಿ ತಥಾ ಮನ್ತ್ರಣಾಂ ದಾತುಂ ತೇಷಾಂ ಸಮೀಪಮ್ ಇಲಿಯಾಸರಂ ಪ್ರೇರಯ| ");
INSERT INTO sankan_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","ತತ ಇಬ್ರಾಹೀಮ್ ಉವಾಚ, ಮೂಸಾಭವಿಷ್ಯದ್ವಾದಿನಾಞ್ಚ ಪುಸ್ತಕಾನಿ ತೇಷಾಂ ನಿಕಟೇ ಸನ್ತಿ ತೇ ತದ್ವಚನಾನಿ ಮನ್ಯನ್ತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","ತದಾ ಸ ನಿವೇದಯಾಮಾಸ, ಹೇ ಪಿತರ್ ಇಬ್ರಾಹೀಮ್ ನ ತಥಾ, ಕಿನ್ತು ಯದಿ ಮೃತಲೋಕಾನಾಂ ಕಶ್ಚಿತ್ ತೇಷಾಂ ಸಮೀಪಂ ಯಾತಿ ತರ್ಹಿ ತೇ ಮನಾಂಸಿ ವ್ಯಾಘೋಟಯಿಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","ತತ ಇಬ್ರಾಹೀಮ್ ಜಗಾದ, ತೇ ಯದಿ ಮೂಸಾಭವಿಷ್ಯದ್ವಾದಿನಾಞ್ಚ ವಚನಾನಿ ನ ಮನ್ಯನ್ತೇ ತರ್ಹಿ ಮೃತಲೋಕಾನಾಂ ಕಸ್ಮಿಂಶ್ಚಿದ್ ಉತ್ಥಿತೇಪಿ ತೇ ತಸ್ಯ ಮನ್ತ್ರಣಾಂ ನ ಮಂಸ್ಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ಇತಃ ಪರಂ ಯೀಶುಃ ಶಿಷ್ಯಾನ್ ಉವಾಚ, ವಿಘ್ನೈರವಶ್ಯಮ್ ಆಗನ್ತವ್ಯಂ ಕಿನ್ತು ವಿಘ್ನಾ ಯೇನ ಘಟಿಷ್ಯನ್ತೇ ತಸ್ಯ ದುರ್ಗತಿ ರ್ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ಏತೇಷಾಂ ಕ್ಷುದ್ರಪ್ರಾಣಿನಾಮ್ ಏಕಸ್ಯಾಪಿ ವಿಘ್ನಜನನಾತ್ ಕಣ್ಠಬದ್ಧಪೇಷಣೀಕಸ್ಯ ತಸ್ಯ ಸಾಗರಾಗಾಧಜಲೇ ಮಜ್ಜನಂ ಭದ್ರಂ| ");
INSERT INTO sankan_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","ಯೂಯಂ ಸ್ವೇಷು ಸಾವಧಾನಾಸ್ತಿಷ್ಠತ; ತವ ಭ್ರಾತಾ ಯದಿ ತವ ಕಿಞ್ಚಿದ್ ಅಪರಾಧ್ಯತಿ ತರ್ಹಿ ತಂ ತರ್ಜಯ, ತೇನ ಯದಿ ಮನಃ ಪರಿವರ್ತ್ತಯತಿ ತರ್ಹಿ ತಂ ಕ್ಷಮಸ್ವ| ");
INSERT INTO sankan_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","ಪುನರೇಕದಿನಮಧ್ಯೇ ಯದಿ ಸ ತವ ಸಪ್ತಕೃತ್ವೋಽಪರಾಧ್ಯತಿ ಕಿನ್ತು ಸಪ್ತಕೃತ್ವ ಆಗತ್ಯ ಮನಃ ಪರಿವರ್ತ್ಯ ಮಯಾಪರಾದ್ಧಮ್ ಇತಿ ವದತಿ ತರ್ಹಿ ತಂ ಕ್ಷಮಸ್ವ| ");
INSERT INTO sankan_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","ತದಾ ಪ್ರೇರಿತಾಃ ಪ್ರಭುಮ್ ಅವದನ್ ಅಸ್ಮಾಕಂ ವಿಶ್ವಾಸಂ ವರ್ದ್ಧಯ| ");
INSERT INTO sankan_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ಪ್ರಭುರುವಾಚ, ಯದಿ ಯುಷ್ಮಾಕಂ ಸರ್ಷಪೈಕಪ್ರಮಾಣೋ ವಿಶ್ವಾಸೋಸ್ತಿ ತರ್ಹಿ ತ್ವಂ ಸಮೂಲಮುತ್ಪಾಟಿತೋ ಭೂತ್ವಾ ಸಮುದ್ರೇ ರೋಪಿತೋ ಭವ ಕಥಾಯಾಮ್ ಏತಸ್ಯಾಮ್ ಏತದುಡುಮ್ಬರಾಯ ಕಥಿತಾಯಾಂ ಸ ಯುಷ್ಮಾಕಮಾಜ್ಞಾವಹೋ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","ಅಪರಂ ಸ್ವದಾಸೇ ಹಲಂ ವಾಹಯಿತ್ವಾ ವಾ ಪಶೂನ್ ಚಾರಯಿತ್ವಾ ಕ್ಷೇತ್ರಾದ್ ಆಗತೇ ಸತಿ ತಂ ವದತಿ, ಏಹಿ ಭೋಕ್ತುಮುಪವಿಶ, ಯುಷ್ಮಾಕಮ್ ಏತಾದೃಶಃ ಕೋಸ್ತಿ? ");
INSERT INTO sankan_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ವರಞ್ಚ ಪೂರ್ವ್ವಂ ಮಮ ಖಾದ್ಯಮಾಸಾದ್ಯ ಯಾವದ್ ಭುಞ್ಜೇ ಪಿವಾಮಿ ಚ ತಾವದ್ ಬದ್ಧಕಟಿಃ ಪರಿಚರ ಪಶ್ಚಾತ್ ತ್ವಮಪಿ ಭೋಕ್ಷ್ಯಸೇ ಪಾಸ್ಯಸಿ ಚ ಕಥಾಮೀದೃಶೀಂ ಕಿಂ ನ ವಕ್ಷ್ಯತಿ? ");
INSERT INTO sankan_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","ತೇನ ದಾಸೇನ ಪ್ರಭೋರಾಜ್ಞಾನುರೂಪೇ ಕರ್ಮ್ಮಣಿ ಕೃತೇ ಪ್ರಭುಃ ಕಿಂ ತಸ್ಮಿನ್ ಬಾಧಿತೋ ಜಾತಃ? ನೇತ್ಥಂ ಬುಧ್ಯತೇ ಮಯಾ| ");
INSERT INTO sankan_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ಇತ್ಥಂ ನಿರೂಪಿತೇಷು ಸರ್ವ್ವಕರ್ಮ್ಮಸು ಕೃತೇಷು ಸತ್ಮು ಯೂಯಮಪೀದಂ ವಾಕ್ಯಂ ವದಥ, ವಯಮ್ ಅನುಪಕಾರಿಣೋ ದಾಸಾ ಅಸ್ಮಾಭಿರ್ಯದ್ಯತ್ಕರ್ತ್ತವ್ಯಂ ತನ್ಮಾತ್ರಮೇವ ಕೃತಂ| ");
INSERT INTO sankan_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ಸ ಯಿರೂಶಾಲಮಿ ಯಾತ್ರಾಂ ಕುರ್ವ್ವನ್ ಶೋಮಿರೋಣ್ಗಾಲೀಲ್ಪ್ರದೇಶಮಧ್ಯೇನ ಗಚ್ಛತಿ, ");
INSERT INTO sankan_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ಏತರ್ಹಿ ಕುತ್ರಚಿದ್ ಗ್ರಾಮೇ ಪ್ರವೇಶಮಾತ್ರೇ ದಶಕುಷ್ಠಿನಸ್ತಂ ಸಾಕ್ಷಾತ್ ಕೃತ್ವಾ ");
INSERT INTO sankan_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ದೂರೇ ತಿಷ್ಠನತ ಉಚ್ಚೈ ರ್ವಕ್ತುಮಾರೇಭಿರೇ, ಹೇ ಪ್ರಭೋ ಯೀಶೋ ದಯಸ್ವಾಸ್ಮಾನ್| ");
INSERT INTO sankan_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ತತಃ ಸ ತಾನ್ ದೃಷ್ಟ್ವಾ ಜಗಾದ, ಯೂಯಂ ಯಾಜಕಾನಾಂ ಸಮೀಪೇ ಸ್ವಾನ್ ದರ್ಶಯತ, ತತಸ್ತೇ ಗಚ್ಛನ್ತೋ ರೋಗಾತ್ ಪರಿಷ್ಕೃತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","ತದಾ ತೇಷಾಮೇಕಃ ಸ್ವಂ ಸ್ವಸ್ಥಂ ದೃಷ್ಟ್ವಾ ಪ್ರೋಚ್ಚೈರೀಶ್ವರಂ ಧನ್ಯಂ ವದನ್ ವ್ಯಾಘುಟ್ಯಾಯಾತೋ ಯೀಶೋ ರ್ಗುಣಾನನುವದನ್ ತಚ್ಚರಣಾಧೋಭೂಮೌ ಪಪಾತ; ");
INSERT INTO sankan_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ಸ ಚಾಸೀತ್ ಶೋಮಿರೋಣೀ| ");
INSERT INTO sankan_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ತದಾ ಯೀಶುರವದತ್, ದಶಜನಾಃ ಕಿಂ ನ ಪರಿಷ್ಕೃತಾಃ? ತಹ್ಯನ್ಯೇ ನವಜನಾಃ ಕುತ್ರ? ");
INSERT INTO sankan_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ಈಶ್ವರಂ ಧನ್ಯಂ ವದನ್ತಮ್ ಏನಂ ವಿದೇಶಿನಂ ವಿನಾ ಕೋಪ್ಯನ್ಯೋ ನ ಪ್ರಾಪ್ಯತ| ");
INSERT INTO sankan_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ತದಾ ಸ ತಮುವಾಚ, ತ್ವಮುತ್ಥಾಯ ಯಾಹಿ ವಿಶ್ವಾಸಸ್ತೇ ತ್ವಾಂ ಸ್ವಸ್ಥಂ ಕೃತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","ಅಥ ಕದೇಶ್ವರಸ್ಯ ರಾಜತ್ವಂ ಭವಿಷ್ಯತೀತಿ ಫಿರೂಶಿಭಿಃ ಪೃಷ್ಟೇ ಸ ಪ್ರತ್ಯುವಾಚ, ಈಶ್ವರಸ್ಯ ರಾಜತ್ವಮ್ ಐಶ್ವರ್ಯ್ಯದರ್ಶನೇನ ನ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ಅತ ಏತಸ್ಮಿನ್ ಪಶ್ಯ ತಸ್ಮಿನ್ ವಾ ಪಶ್ಯ, ಇತಿ ವಾಕ್ಯಂ ಲೋಕಾ ವಕ್ತುಂ ನ ಶಕ್ಷ್ಯನ್ತಿ, ಈಶ್ವರಸ್ಯ ರಾಜತ್ವಂ ಯುಷ್ಮಾಕಮ್ ಅನ್ತರೇವಾಸ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ತತಃ ಸ ಶಿಷ್ಯಾನ್ ಜಗಾದ, ಯದಾ ಯುಷ್ಮಾಭಿ ರ್ಮನುಜಸುತಸ್ಯ ದಿನಮೇಕಂ ದ್ರಷ್ಟುಮ್ ವಾಞ್ಛಿಷ್ಯತೇ ಕಿನ್ತು ನ ದರ್ಶಿಷ್ಯತೇ, ಈದೃಕ್ಕಾಲ ಆಯಾತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","ತದಾತ್ರ ಪಶ್ಯ ವಾ ತತ್ರ ಪಶ್ಯೇತಿ ವಾಕ್ಯಂ ಲೋಕಾ ವಕ್ಷ್ಯನ್ತಿ, ಕಿನ್ತು ತೇಷಾಂ ಪಶ್ಚಾತ್ ಮಾ ಯಾತ, ಮಾನುಗಚ್ಛತ ಚ| ");
INSERT INTO sankan_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","ಯತಸ್ತಡಿದ್ ಯಥಾಕಾಶೈಕದಿಶ್ಯುದಿಯ ತದನ್ಯಾಮಪಿ ದಿಶಂ ವ್ಯಾಪ್ಯ ಪ್ರಕಾಶತೇ ತದ್ವತ್ ನಿಜದಿನೇ ಮನುಜಸೂನುಃ ಪ್ರಕಾಶಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","ಕಿನ್ತು ತತ್ಪೂರ್ವ್ವಂ ತೇನಾನೇಕಾನಿ ದುಃಖಾನಿ ಭೋಕ್ತವ್ಯಾನ್ಯೇತದ್ವರ್ತ್ತಮಾನಲೋಕೈಶ್ಚ ಸೋಽವಜ್ಞಾತವ್ಯಃ| ");
INSERT INTO sankan_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","ನೋಹಸ್ಯ ವಿದ್ಯಮಾನಕಾಲೇ ಯಥಾಭವತ್ ಮನುಷ್ಯಸೂನೋಃ ಕಾಲೇಪಿ ತಥಾ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ಯಾವತ್ಕಾಲಂ ನೋಹೋ ಮಹಾಪೋತಂ ನಾರೋಹದ್ ಆಪ್ಲಾವಿವಾರ್ಯ್ಯೇತ್ಯ ಸರ್ವ್ವಂ ನಾನಾಶಯಚ್ಚ ತಾವತ್ಕಾಲಂ ಯಥಾ ಲೋಕಾ ಅಭುಞ್ಜತಾಪಿವನ್ ವ್ಯವಹನ್ ವ್ಯವಾಹಯಂಶ್ಚ; ");
INSERT INTO sankan_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ಇತ್ಥಂ ಲೋಟೋ ವರ್ತ್ತಮಾನಕಾಲೇಪಿ ಯಥಾ ಲೋಕಾ ಭೋಜನಪಾನಕ್ರಯವಿಕ್ರಯರೋಪಣಗೃಹನಿರ್ಮ್ಮಾಣಕರ್ಮ್ಮಸು ಪ್ರಾವರ್ತ್ತನ್ತ, ");
INSERT INTO sankan_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ಕಿನ್ತು ಯದಾ ಲೋಟ್ ಸಿದೋಮೋ ನಿರ್ಜಗಾಮ ತದಾ ನಭಸಃ ಸಗನ್ಧಕಾಗ್ನಿವೃಷ್ಟಿ ರ್ಭೂತ್ವಾ ಸರ್ವ್ವಂ ವ್ಯನಾಶಯತ್ ");
INSERT INTO sankan_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","ತದ್ವನ್ ಮಾನವಪುತ್ರಪ್ರಕಾಶದಿನೇಪಿ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","ತದಾ ಯದಿ ಕಶ್ಚಿದ್ ಗೃಹೋಪರಿ ತಿಷ್ಠತಿ ತರ್ಹಿ ಸ ಗೃಹಮಧ್ಯಾತ್ ಕಿಮಪಿ ದ್ರವ್ಯಮಾನೇತುಮ್ ಅವರುಹ್ಯ ನೈತು; ಯಶ್ಚ ಕ್ಷೇತ್ರೇ ತಿಷ್ಠತಿ ಸೋಪಿ ವ್ಯಾಘುಟ್ಯ ನಾಯಾತು| ");
INSERT INTO sankan_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","ಲೋಟಃ ಪತ್ನೀಂ ಸ್ಮರತ| ");
INSERT INTO sankan_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ಯಃ ಪ್ರಾಣಾನ್ ರಕ್ಷಿತುಂ ಚೇಷ್ಟಿಷ್ಯತೇ ಸ ಪ್ರಾಣಾನ್ ಹಾರಯಿಷ್ಯತಿ ಯಸ್ತು ಪ್ರಾಣಾನ್ ಹಾರಯಿಷ್ಯತಿ ಸಏವ ಪ್ರಾಣಾನ್ ರಕ್ಷಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","ಯುಷ್ಮಾನಹಂ ವಚ್ಮಿ ತಸ್ಯಾಂ ರಾತ್ರೌ ಶಯ್ಯೈಕಗತಯೋ ರ್ಲೋಕಯೋರೇಕೋ ಧಾರಿಷ್ಯತೇ ಪರಸ್ತ್ಯಕ್ಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ಸ್ತ್ರಿಯೌ ಯುಗಪತ್ ಪೇಷಣೀಂ ವ್ಯಾವರ್ತ್ತಯಿಷ್ಯತಸ್ತಯೋರೇಕಾ ಧಾರಿಷ್ಯತೇ ಪರಾತ್ಯಕ್ಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","ಪುರುಷೌ ಕ್ಷೇತ್ರೇ ಸ್ಥಾಸ್ಯತಸ್ತಯೋರೇಕೋ ಧಾರಿಷ್ಯತೇ ಪರಸ್ತ್ಯಕ್ಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ತದಾ ತೇ ಪಪ್ರಚ್ಛುಃ, ಹೇ ಪ್ರಭೋ ಕುತ್ರೇತ್ಥಂ ಭವಿಷ್ಯತಿ? ತತಃ ಸ ಉವಾಚ, ಯತ್ರ ಶವಸ್ತಿಷ್ಠತಿ ತತ್ರ ಗೃಧ್ರಾ ಮಿಲನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ಅಪರಞ್ಚ ಲೋಕೈರಕ್ಲಾನ್ತೈ ರ್ನಿರನ್ತರಂ ಪ್ರಾರ್ಥಯಿತವ್ಯಮ್ ಇತ್ಯಾಶಯೇನ ಯೀಶುನಾ ದೃಷ್ಟಾನ್ತ ಏಕಃ ಕಥಿತಃ| ");
INSERT INTO sankan_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","ಕುತ್ರಚಿನ್ನಗರೇ ಕಶ್ಚಿತ್ ಪ್ರಾಡ್ವಿವಾಕ ಆಸೀತ್ ಸ ಈಶ್ವರಾನ್ನಾಬಿಭೇತ್ ಮಾನುಷಾಂಶ್ಚ ನಾಮನ್ಯತ| ");
INSERT INTO sankan_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","ಅಥ ತತ್ಪುರವಾಸಿನೀ ಕಾಚಿದ್ವಿಧವಾ ತತ್ಸಮೀಪಮೇತ್ಯ ವಿವಾದಿನಾ ಸಹ ಮಮ ವಿವಾದಂ ಪರಿಷ್ಕುರ್ವ್ವಿತಿ ನಿವೇದಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ತತಃ ಸ ಪ್ರಾಡ್ವಿವಾಕಃ ಕಿಯದ್ದಿನಾನಿ ನ ತದಙ್ಗೀಕೃತವಾನ್ ಪಶ್ಚಾಚ್ಚಿತ್ತೇ ಚಿನ್ತಯಾಮಾಸ, ಯದ್ಯಪೀಶ್ವರಾನ್ನ ಬಿಭೇಮಿ ಮನುಷ್ಯಾನಪಿ ನ ಮನ್ಯೇ ");
INSERT INTO sankan_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ತಥಾಪ್ಯೇಷಾ ವಿಧವಾ ಮಾಂ ಕ್ಲಿಶ್ನಾತಿ ತಸ್ಮಾದಸ್ಯಾ ವಿವಾದಂ ಪರಿಷ್ಕರಿಷ್ಯಾಮಿ ನೋಚೇತ್ ಸಾ ಸದಾಗತ್ಯ ಮಾಂ ವ್ಯಗ್ರಂ ಕರಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ಪಶ್ಚಾತ್ ಪ್ರಭುರವದದ್ ಅಸಾವನ್ಯಾಯಪ್ರಾಡ್ವಿವಾಕೋ ಯದಾಹ ತತ್ರ ಮನೋ ನಿಧಧ್ವಂ| ");
INSERT INTO sankan_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ಈಶ್ವರಸ್ಯ ಯೇ ಽಭಿರುಚಿತಲೋಕಾ ದಿವಾನಿಶಂ ಪ್ರಾರ್ಥಯನ್ತೇ ಸ ಬಹುದಿನಾನಿ ವಿಲಮ್ಬ್ಯಾಪಿ ತೇಷಾಂ ವಿವಾದಾನ್ ಕಿಂ ನ ಪರಿಷ್ಕರಿಷ್ಯತಿ? ");
INSERT INTO sankan_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","ಯುಷ್ಮಾನಹಂ ವದಾಮಿ ತ್ವರಯಾ ಪರಿಷ್ಕರಿಷ್ಯತಿ, ಕಿನ್ತು ಯದಾ ಮನುಷ್ಯಪುತ್ರ ಆಗಮಿಷ್ಯತಿ ತದಾ ಪೃಥಿವ್ಯಾಂ ಕಿಮೀದೃಶಂ ವಿಶ್ವಾಸಂ ಪ್ರಾಪ್ಸ್ಯತಿ? ");
INSERT INTO sankan_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ಯೇ ಸ್ವಾನ್ ಧಾರ್ಮ್ಮಿಕಾನ್ ಜ್ಞಾತ್ವಾ ಪರಾನ್ ತುಚ್ಛೀಕುರ್ವ್ವನ್ತಿ ಏತಾದೃಗ್ಭ್ಯಃ, ಕಿಯದ್ಭ್ಯ ಇಮಂ ದೃಷ್ಟಾನ್ತಂ ಕಥಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","ಏಕಃ ಫಿರೂಶ್ಯಪರಃ ಕರಸಞ್ಚಾಯೀ ದ್ವಾವಿಮೌ ಪ್ರಾರ್ಥಯಿತುಂ ಮನ್ದಿರಂ ಗತೌ| ");
INSERT INTO sankan_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ತತೋಽಸೌ ಫಿರೂಶ್ಯೇಕಪಾರ್ಶ್ವೇ ತಿಷ್ಠನ್ ಹೇ ಈಶ್ವರ ಅಹಮನ್ಯಲೋಕವತ್ ಲೋಠಯಿತಾನ್ಯಾಯೀ ಪಾರದಾರಿಕಶ್ಚ ನ ಭವಾಮಿ ಅಸ್ಯ ಕರಸಞ್ಚಾಯಿನಸ್ತುಲ್ಯಶ್ಚ ನ, ತಸ್ಮಾತ್ತ್ವಾಂ ಧನ್ಯಂ ವದಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","ಸಪ್ತಸು ದಿನೇಷು ದಿನದ್ವಯಮುಪವಸಾಮಿ ಸರ್ವ್ವಸಮ್ಪತ್ತೇ ರ್ದಶಮಾಂಶಂ ದದಾಮಿ ಚ, ಏತತ್ಕಥಾಂ ಕಥಯನ್ ಪ್ರಾರ್ಥಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","ಕಿನ್ತು ಸ ಕರಸಞ್ಚಾಯಿ ದೂರೇ ತಿಷ್ಠನ್ ಸ್ವರ್ಗಂ ದ್ರಷ್ಟುಂ ನೇಚ್ಛನ್ ವಕ್ಷಸಿ ಕರಾಘಾತಂ ಕುರ್ವ್ವನ್ ಹೇ ಈಶ್ವರ ಪಾಪಿಷ್ಠಂ ಮಾಂ ದಯಸ್ವ, ಇತ್ಥಂ ಪ್ರಾರ್ಥಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","ಯುಷ್ಮಾನಹಂ ವದಾಮಿ, ತಯೋರ್ದ್ವಯೋ ರ್ಮಧ್ಯೇ ಕೇವಲಃ ಕರಸಞ್ಚಾಯೀ ಪುಣ್ಯವತ್ತ್ವೇನ ಗಣಿತೋ ನಿಜಗೃಹಂ ಜಗಾಮ, ಯತೋ ಯಃ ಕಶ್ಚಿತ್ ಸ್ವಮುನ್ನಮಯತಿ ಸ ನಾಮಯಿಷ್ಯತೇ ಕಿನ್ತು ಯಃ ಕಶ್ಚಿತ್ ಸ್ವಂ ನಮಯತಿ ಸ ಉನ್ನಮಯಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","ಅಥ ಶಿಶೂನಾಂ ಗಾತ್ರಸ್ಪರ್ಶಾರ್ಥಂ ಲೋಕಾಸ್ತಾನ್ ತಸ್ಯ ಸಮೀಪಮಾನಿನ್ಯುಃ ಶಿಷ್ಯಾಸ್ತದ್ ದೃಷ್ಟ್ವಾನೇತೃನ್ ತರ್ಜಯಾಮಾಸುಃ, ");
INSERT INTO sankan_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","ಕಿನ್ತು ಯೀಶುಸ್ತಾನಾಹೂಯ ಜಗಾದ, ಮನ್ನಿಕಟಮ್ ಆಗನ್ತುಂ ಶಿಶೂನ್ ಅನುಜಾನೀಧ್ವಂ ತಾಂಶ್ಚ ಮಾ ವಾರಯತ; ಯತ ಈಶ್ವರರಾಜ್ಯಾಧಿಕಾರಿಣ ಏಷಾಂ ಸದೃಶಾಃ| ");
INSERT INTO sankan_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ಅಹಂ ಯುಷ್ಮಾನ್ ಯಥಾರ್ಥಂ ವದಾಮಿ, ಯೋ ಜನಃ ಶಿಶೋಃ ಸದೃಶೋ ಭೂತ್ವಾ ಈಶ್ವರರಾಜ್ಯಂ ನ ಗೃಹ್ಲಾತಿ ಸ ಕೇನಾಪಿ ಪ್ರಕಾರೇಣ ತತ್ ಪ್ರವೇಷ್ಟುಂ ನ ಶಕ್ನೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","ಅಪರಮ್ ಏಕೋಧಿಪತಿಸ್ತಂ ಪಪ್ರಚ್ಛ, ಹೇ ಪರಮಗುರೋ, ಅನನ್ತಾಯುಷಃ ಪ್ರಾಪ್ತಯೇ ಮಯಾ ಕಿಂ ಕರ್ತ್ತವ್ಯಂ? ");
INSERT INTO sankan_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ಯೀಶುರುವಾಚ, ಮಾಂ ಕುತಃ ಪರಮಂ ವದಸಿ? ಈಶ್ವರಂ ವಿನಾ ಕೋಪಿ ಪರಮೋ ನ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","ಪರದಾರಾನ್ ಮಾ ಗಚ್ಛ, ನರಂ ಮಾ ಜಹಿ, ಮಾ ಚೋರಯ, ಮಿಥ್ಯಾಸಾಕ್ಷ್ಯಂ ಮಾ ದೇಹಿ, ಮಾತರಂ ಪಿತರಞ್ಚ ಸಂಮನ್ಯಸ್ವ, ಏತಾ ಯಾ ಆಜ್ಞಾಃ ಸನ್ತಿ ತಾಸ್ತ್ವಂ ಜಾನಾಸಿ| ");
INSERT INTO sankan_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","ತದಾ ಸ ಉವಾಚ, ಬಾಲ್ಯಕಾಲಾತ್ ಸರ್ವ್ವಾ ಏತಾ ಆಚರಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ಇತಿ ಕಥಾಂ ಶ್ರುತ್ವಾ ಯೀಶುಸ್ತಮವದತ್, ತಥಾಪಿ ತವೈಕಂ ಕರ್ಮ್ಮ ನ್ಯೂನಮಾಸ್ತೇ, ನಿಜಂ ಸರ್ವ್ವಸ್ವಂ ವಿಕ್ರೀಯ ದರಿದ್ರೇಭ್ಯೋ ವಿತರ, ತಸ್ಮಾತ್ ಸ್ವರ್ಗೇ ಧನಂ ಪ್ರಾಪ್ಸ್ಯಸಿ; ತತ ಆಗತ್ಯ ಮಮಾನುಗಾಮೀ ಭವ| ");
INSERT INTO sankan_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","ಕಿನ್ತ್ವೇತಾಂ ಕಥಾಂ ಶ್ರುತ್ವಾ ಸೋಧಿಪತಿಃ ಶುಶೋಚ, ಯತಸ್ತಸ್ಯ ಬಹುಧನಮಾಸೀತ್| ");
INSERT INTO sankan_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ತದಾ ಯೀಶುಸ್ತಮತಿಶೋಕಾನ್ವಿತಂ ದೃಷ್ಟ್ವಾ ಜಗಾದ, ಧನವತಾಮ್ ಈಶ್ವರರಾಜ್ಯಪ್ರವೇಶಃ ಕೀದೃಗ್ ದುಷ್ಕರಃ| ");
INSERT INTO sankan_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ಈಶ್ವರರಾಜ್ಯೇ ಧನಿನಃ ಪ್ರವೇಶಾತ್ ಸೂಚೇಶ್ಛಿದ್ರೇಣ ಮಹಾಙ್ಗಸ್ಯ ಗಮನಾಗಮನೇ ಸುಕರೇ| ");
INSERT INTO sankan_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ಶ್ರೋತಾರಃ ಪಪ್ರಚ್ಛುಸ್ತರ್ಹಿ ಕೇನ ಪರಿತ್ರಾಣಂ ಪ್ರಾಪ್ಸ್ಯತೇ? ");
INSERT INTO sankan_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ಸ ಉಕ್ತವಾನ್, ಯನ್ ಮಾನುಷೇಣಾಶಕ್ಯಂ ತದ್ ಈಶ್ವರೇಣ ಶಕ್ಯಂ| ");
INSERT INTO sankan_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ತದಾ ಪಿತರ ಉವಾಚ, ಪಶ್ಯ ವಯಂ ಸರ್ವ್ವಸ್ವಂ ಪರಿತ್ಯಜ್ಯ ತವ ಪಶ್ಚಾದ್ಗಾಮಿನೋಽಭವಾಮ| ");
INSERT INTO sankan_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ತತಃ ಸ ಉವಾಚ, ಯುಷ್ಮಾನಹಂ ಯಥಾರ್ಥಂ ವದಾಮಿ, ಈಶ್ವರರಾಜ್ಯಾರ್ಥಂ ಗೃಹಂ ಪಿತರೌ ಭ್ರಾತೃಗಣಂ ಜಾಯಾಂ ಸನ್ತಾನಾಂಶ್ಚ ತ್ಯಕ್ತವಾ ");
INSERT INTO sankan_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ಇಹ ಕಾಲೇ ತತೋಽಧಿಕಂ ಪರಕಾಲೇ ಽನನ್ತಾಯುಶ್ಚ ನ ಪ್ರಾಪ್ಸ್ಯತಿ ಲೋಕ ಈದೃಶಃ ಕೋಪಿ ನಾಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","ಅನನ್ತರಂ ಸ ದ್ವಾದಶಶಿಷ್ಯಾನಾಹೂಯ ಬಭಾಷೇ, ಪಶ್ಯತ ವಯಂ ಯಿರೂಶಾಲಮ್ನಗರಂ ಯಾಮಃ, ತಸ್ಮಾತ್ ಮನುಷ್ಯಪುತ್ರೇ ಭವಿಷ್ಯದ್ವಾದಿಭಿರುಕ್ತಂ ಯದಸ್ತಿ ತದನುರೂಪಂ ತಂ ಪ್ರತಿ ಘಟಿಷ್ಯತೇ; ");
INSERT INTO sankan_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","ವಸ್ತುತಸ್ತು ಸೋಽನ್ಯದೇಶೀಯಾನಾಂ ಹಸ್ತೇಷು ಸಮರ್ಪಯಿಷ್ಯತೇ, ತೇ ತಮುಪಹಸಿಷ್ಯನ್ತಿ, ಅನ್ಯಾಯಮಾಚರಿಷ್ಯನ್ತಿ ತದ್ವಪುಷಿ ನಿಷ್ಠೀವಂ ನಿಕ್ಷೇಪ್ಸ್ಯನ್ತಿ, ಕಶಾಭಿಃ ಪ್ರಹೃತ್ಯ ತಂ ಹನಿಷ್ಯನ್ತಿ ಚ, ");
INSERT INTO sankan_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ಕಿನ್ತು ತೃತೀಯದಿನೇ ಸ ಶ್ಮಶಾನಾದ್ ಉತ್ಥಾಸ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ಏತಸ್ಯಾಃ ಕಥಾಯಾ ಅಭಿಪ್ರಾಯಂ ಕಿಞ್ಚಿದಪಿ ತೇ ಬೋದ್ಧುಂ ನ ಶೇಕುಃ ತೇಷಾಂ ನಿಕಟೇಽಸ್ಪಷ್ಟತವಾತ್ ತಸ್ಯೈತಾಸಾಂ ಕಥಾನಾಮ್ ಆಶಯಂ ತೇ ಜ್ಞಾತುಂ ನ ಶೇಕುಶ್ಚ| ");
INSERT INTO sankan_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","ಅಥ ತಸ್ಮಿನ್ ಯಿರೀಹೋಃ ಪುರಸ್ಯಾನ್ತಿಕಂ ಪ್ರಾಪ್ತೇ ಕಶ್ಚಿದನ್ಧಃ ಪಥಃ ಪಾರ್ಶ್ವ ಉಪವಿಶ್ಯ ಭಿಕ್ಷಾಮ್ ಅಕರೋತ್ ");
INSERT INTO sankan_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ಸ ಲೋಕಸಮೂಹಸ್ಯ ಗಮನಶಬ್ದಂ ಶ್ರುತ್ವಾ ತತ್ಕಾರಣಂ ಪೃಷ್ಟವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","ನಾಸರತೀಯಯೀಶುರ್ಯಾತೀತಿ ಲೋಕೈರುಕ್ತೇ ಸ ಉಚ್ಚೈರ್ವಕ್ತುಮಾರೇಭೇ, ");
INSERT INTO sankan_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ಹೇ ದಾಯೂದಃ ಸನ್ತಾನ ಯೀಶೋ ಮಾಂ ದಯಸ್ವ| ");
INSERT INTO sankan_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ತತೋಗ್ರಗಾಮಿನಸ್ತಂ ಮೌನೀ ತಿಷ್ಠೇತಿ ತರ್ಜಯಾಮಾಸುಃ ಕಿನ್ತು ಸ ಪುನಾರುವನ್ ಉವಾಚ, ಹೇ ದಾಯೂದಃ ಸನ್ತಾನ ಮಾಂ ದಯಸ್ವ| ");
INSERT INTO sankan_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","ತದಾ ಯೀಶುಃ ಸ್ಥಗಿತೋ ಭೂತ್ವಾ ಸ್ವಾನ್ತಿಕೇ ತಮಾನೇತುಮ್ ಆದಿದೇಶ| ");
INSERT INTO sankan_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","ತತಃ ಸ ತಸ್ಯಾನ್ತಿಕಮ್ ಆಗಮತ್, ತದಾ ಸ ತಂ ಪಪ್ರಚ್ಛ, ತ್ವಂ ಕಿಮಿಚ್ಛಸಿ? ತ್ವದರ್ಥಮಹಂ ಕಿಂ ಕರಿಷ್ಯಾಮಿ? ಸ ಉಕ್ತವಾನ್, ಹೇ ಪ್ರಭೋಽಹಂ ದ್ರಷ್ಟುಂ ಲಭೈ| ");
INSERT INTO sankan_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","ತದಾ ಯೀಶುರುವಾಚ, ದೃಷ್ಟಿಶಕ್ತಿಂ ಗೃಹಾಣ ತವ ಪ್ರತ್ಯಯಸ್ತ್ವಾಂ ಸ್ವಸ್ಥಂ ಕೃತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ತತಸ್ತತ್ಕ್ಷಣಾತ್ ತಸ್ಯ ಚಕ್ಷುಷೀ ಪ್ರಸನ್ನೇ; ತಸ್ಮಾತ್ ಸ ಈಶ್ವರಂ ಧನ್ಯಂ ವದನ್ ತತ್ಪಶ್ಚಾದ್ ಯಯೌ, ತದಾಲೋಕ್ಯ ಸರ್ವ್ವೇ ಲೋಕಾ ಈಶ್ವರಂ ಪ್ರಶಂಸಿತುಮ್ ಆರೇಭಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","ಯದಾ ಯೀಶು ರ್ಯಿರೀಹೋಪುರಂ ಪ್ರವಿಶ್ಯ ತನ್ಮಧ್ಯೇನ ಗಚ್ಛಂಸ್ತದಾ ");
INSERT INTO sankan_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ಸಕ್ಕೇಯನಾಮಾ ಕರಸಞ್ಚಾಯಿನಾಂ ಪ್ರಧಾನೋ ಧನವಾನೇಕೋ ");
INSERT INTO sankan_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ಯೀಶುಃ ಕೀದೃಗಿತಿ ದ್ರಷ್ಟುಂ ಚೇಷ್ಟಿತವಾನ್ ಕಿನ್ತು ಖರ್ವ್ವತ್ವಾಲ್ಲೋಕಸಂಘಮಧ್ಯೇ ತದ್ದರ್ಶನಮಪ್ರಾಪ್ಯ ");
INSERT INTO sankan_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","ಯೇನ ಪಥಾ ಸ ಯಾಸ್ಯತಿ ತತ್ಪಥೇಽಗ್ರೇ ಧಾವಿತ್ವಾ ತಂ ದ್ರಷ್ಟುಮ್ ಉಡುಮ್ಬರತರುಮಾರುರೋಹ| ");
INSERT INTO sankan_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","ಪಶ್ಚಾದ್ ಯೀಶುಸ್ತತ್ಸ್ಥಾನಮ್ ಇತ್ವಾ ಊರ್ದ್ಧ್ವಂ ವಿಲೋಕ್ಯ ತಂ ದೃಷ್ಟ್ವಾವಾದೀತ್, ಹೇ ಸಕ್ಕೇಯ ತ್ವಂ ಶೀಘ್ರಮವರೋಹ ಮಯಾದ್ಯ ತ್ವದ್ಗೇಹೇ ವಸ್ತವ್ಯಂ| ");
INSERT INTO sankan_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ತತಃ ಸ ಶೀಘ್ರಮವರುಹ್ಯ ಸಾಹ್ಲಾದಂ ತಂ ಜಗ್ರಾಹ| ");
INSERT INTO sankan_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ತದ್ ದೃಷ್ಟ್ವಾ ಸರ್ವ್ವೇ ವಿವದಮಾನಾ ವಕ್ತುಮಾರೇಭಿರೇ, ಸೋತಿಥಿತ್ವೇನ ದುಷ್ಟಲೋಕಗೃಹಂ ಗಚ್ಛತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ಕಿನ್ತು ಸಕ್ಕೇಯೋ ದಣ್ಡಾಯಮಾನೋ ವಕ್ತುಮಾರೇಭೇ, ಹೇ ಪ್ರಭೋ ಪಶ್ಯ ಮಮ ಯಾ ಸಮ್ಪತ್ತಿರಸ್ತಿ ತದರ್ದ್ಧಂ ದರಿದ್ರೇಭ್ಯೋ ದದೇ, ಅಪರಮ್ ಅನ್ಯಾಯಂ ಕೃತ್ವಾ ಕಸ್ಮಾದಪಿ ಯದಿ ಕದಾಪಿ ಕಿಞ್ಚಿತ್ ಮಯಾ ಗೃಹೀತಂ ತರ್ಹಿ ತಚ್ಚತುರ್ಗುಣಂ ದದಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ತದಾ ಯೀಶುಸ್ತಮುಕ್ತವಾನ್ ಅಯಮಪಿ ಇಬ್ರಾಹೀಮಃ ಸನ್ತಾನೋಽತಃ ಕಾರಣಾದ್ ಅದ್ಯಾಸ್ಯ ಗೃಹೇ ತ್ರಾಣಮುಪಸ್ಥಿತಂ| ");
INSERT INTO sankan_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","ಯದ್ ಹಾರಿತಂ ತತ್ ಮೃಗಯಿತುಂ ರಕ್ಷಿತುಞ್ಚ ಮನುಷ್ಯಪುತ್ರ ಆಗತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","ಅಥ ಸ ಯಿರೂಶಾಲಮಃ ಸಮೀಪ ಉಪಾತಿಷ್ಠದ್ ಈಶ್ವರರಾಜತ್ವಸ್ಯಾನುಷ್ಠಾನಂ ತದೈವ ಭವಿಷ್ಯತೀತಿ ಲೋಕೈರನ್ವಭೂಯತ, ತಸ್ಮಾತ್ ಸ ಶ್ರೋತೃಭ್ಯಃ ಪುನರ್ದೃಷ್ಟಾನ್ತಕಥಾಮ್ ಉತ್ಥಾಪ್ಯ ಕಥಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ಕೋಪಿ ಮಹಾಲ್ಲೋಕೋ ನಿಜಾರ್ಥಂ ರಾಜತ್ವಪದಂ ಗೃಹೀತ್ವಾ ಪುನರಾಗನ್ತುಂ ದೂರದೇಶಂ ಜಗಾಮ| ");
INSERT INTO sankan_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ಯಾತ್ರಾಕಾಲೇ ನಿಜಾನ್ ದಶದಾಸಾನ್ ಆಹೂಯ ದಶಸ್ವರ್ಣಮುದ್ರಾ ದತ್ತ್ವಾ ಮಮಾಗಮನಪರ್ಯ್ಯನ್ತಂ ವಾಣಿಜ್ಯಂ ಕುರುತೇತ್ಯಾದಿದೇಶ| ");
INSERT INTO sankan_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","ಕಿನ್ತು ತಸ್ಯ ಪ್ರಜಾಸ್ತಮವಜ್ಞಾಯ ಮನುಷ್ಯಮೇನಮ್ ಅಸ್ಮಾಕಮುಪರಿ ರಾಜತ್ವಂ ನ ಕಾರಯಿವ್ಯಾಮ ಇಮಾಂ ವಾರ್ತ್ತಾಂ ತನ್ನಿಕಟೇ ಪ್ರೇರಯಾಮಾಸುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","ಅಥ ಸ ರಾಜತ್ವಪದಂ ಪ್ರಾಪ್ಯಾಗತವಾನ್ ಏಕೈಕೋ ಜನೋ ಬಾಣಿಜ್ಯೇನ ಕಿಂ ಲಬ್ಧವಾನ್ ಇತಿ ಜ್ಞಾತುಂ ಯೇಷು ದಾಸೇಷು ಮುದ್ರಾ ಅರ್ಪಯತ್ ತಾನ್ ಆಹೂಯಾನೇತುಮ್ ಆದಿದೇಶ| ");
INSERT INTO sankan_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","ತದಾ ಪ್ರಥಮ ಆಗತ್ಯ ಕಥಿತವಾನ್, ಹೇ ಪ್ರಭೋ ತವ ತಯೈಕಯಾ ಮುದ್ರಯಾ ದಶಮುದ್ರಾ ಲಬ್ಧಾಃ| ");
INSERT INTO sankan_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","ತತಃ ಸ ಉವಾಚ ತ್ವಮುತ್ತಮೋ ದಾಸಃ ಸ್ವಲ್ಪೇನ ವಿಶ್ವಾಸ್ಯೋ ಜಾತ ಇತಃ ಕಾರಣಾತ್ ತ್ವಂ ದಶನಗರಾಣಾಮ್ ಅಧಿಪೋ ಭವ| ");
INSERT INTO sankan_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","ದ್ವಿತೀಯ ಆಗತ್ಯ ಕಥಿತವಾನ್, ಹೇ ಪ್ರಭೋ ತವೈಕಯಾ ಮುದ್ರಯಾ ಪಞ್ಚಮುದ್ರಾ ಲಬ್ಧಾಃ| ");
INSERT INTO sankan_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ತತಃ ಸ ಉವಾಚ, ತ್ವಂ ಪಞ್ಚಾನಾಂ ನಗರಾಣಾಮಧಿಪತಿ ರ್ಭವ| ");
INSERT INTO sankan_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","ತತೋನ್ಯ ಆಗತ್ಯ ಕಥಯಾಮಾಸ, ಹೇ ಪ್ರಭೋ ಪಶ್ಯ ತವ ಯಾ ಮುದ್ರಾ ಅಹಂ ವಸ್ತ್ರೇ ಬದ್ಧ್ವಾಸ್ಥಾಪಯಂ ಸೇಯಂ| ");
INSERT INTO sankan_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ತ್ವಂ ಕೃಪಣೋ ಯನ್ನಾಸ್ಥಾಪಯಸ್ತದಪಿ ಗೃಹ್ಲಾಸಿ, ಯನ್ನಾವಪಸ್ತದೇವ ಚ ಛಿನತ್ಸಿ ತತೋಹಂ ತ್ವತ್ತೋ ಭೀತಃ| ");
INSERT INTO sankan_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","ತದಾ ಸ ಜಗಾದ, ರೇ ದುಷ್ಟದಾಸ ತವ ವಾಕ್ಯೇನ ತ್ವಾಂ ದೋಷಿಣಂ ಕರಿಷ್ಯಾಮಿ, ಯದಹಂ ನಾಸ್ಥಾಪಯಂ ತದೇವ ಗೃಹ್ಲಾಮಿ, ಯದಹಂ ನಾವಪಞ್ಚ ತದೇವ ಛಿನದ್ಮಿ, ಏತಾದೃಶಃ ಕೃಪಣೋಹಮಿತಿ ಯದಿ ತ್ವಂ ಜಾನಾಸಿ, ");
INSERT INTO sankan_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ತರ್ಹಿ ಮಮ ಮುದ್ರಾ ಬಣಿಜಾಂ ನಿಕಟೇ ಕುತೋ ನಾಸ್ಥಾಪಯಃ? ತಯಾ ಕೃತೇಽಹಮ್ ಆಗತ್ಯ ಕುಸೀದೇನ ಸಾರ್ದ್ಧಂ ನಿಜಮುದ್ರಾ ಅಪ್ರಾಪ್ಸ್ಯಮ್| ");
INSERT INTO sankan_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","ಪಶ್ಚಾತ್ ಸ ಸಮೀಪಸ್ಥಾನ್ ಜನಾನ್ ಆಜ್ಞಾಪಯತ್ ಅಸ್ಮಾತ್ ಮುದ್ರಾ ಆನೀಯ ಯಸ್ಯ ದಶಮುದ್ರಾಃ ಸನ್ತಿ ತಸ್ಮೈ ದತ್ತ| ");
INSERT INTO sankan_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","ತೇ ಪ್ರೋಚುಃ ಪ್ರಭೋಽಸ್ಯ ದಶಮುದ್ರಾಃ ಸನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","ಯುಷ್ಮಾನಹಂ ವದಾಮಿ ಯಸ್ಯಾಶ್ರಯೇ ವದ್ಧತೇ ಽಧಿಕಂ ತಸ್ಮೈ ದಾಯಿಷ್ಯತೇ, ಕಿನ್ತು ಯಸ್ಯಾಶ್ರಯೇ ನ ವರ್ದ್ಧತೇ ತಸ್ಯ ಯದ್ಯದಸ್ತಿ ತದಪಿ ತಸ್ಮಾನ್ ನಾಯಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ಕಿನ್ತು ಮಮಾಧಿಪತಿತ್ವಸ್ಯ ವಶತ್ವೇ ಸ್ಥಾತುಮ್ ಅಸಮ್ಮನ್ಯಮಾನಾ ಯೇ ಮಮ ರಿಪವಸ್ತಾನಾನೀಯ ಮಮ ಸಮಕ್ಷಂ ಸಂಹರತ| ");
INSERT INTO sankan_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ಇತ್ಯುಪದೇಶಕಥಾಂ ಕಥಯಿತ್ವಾ ಸೋಗ್ರಗಃ ಸನ್ ಯಿರೂಶಾಲಮಪುರಂ ಯಯೌ| ");
INSERT INTO sankan_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ತತೋ ಬೈತ್ಫಗೀಬೈಥನೀಯಾಗ್ರಾಮಯೋಃ ಸಮೀಪೇ ಜೈತುನಾದ್ರೇರನ್ತಿಕಮ್ ಇತ್ವಾ ಶಿಷ್ಯದ್ವಯಮ್ ಇತ್ಯುಕ್ತ್ವಾ ಪ್ರೇಷಯಾಮಾಸ, ");
INSERT INTO sankan_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ಯುವಾಮಮುಂ ಸಮ್ಮುಖಸ್ಥಗ್ರಾಮಂ ಪ್ರವಿಶ್ಯೈವ ಯಂ ಕೋಪಿ ಮಾನುಷಃ ಕದಾಪಿ ನಾರೋಹತ್ ತಂ ಗರ್ದ್ದಭಶಾವಕಂ ಬದ್ಧಂ ದ್ರಕ್ಷ್ಯಥಸ್ತಂ ಮೋಚಯಿತ್ವಾನಯತಂ| ");
INSERT INTO sankan_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","ತತ್ರ ಕುತೋ ಮೋಚಯಥಃ? ಇತಿ ಚೇತ್ ಕೋಪಿ ವಕ್ಷ್ಯತಿ ತರ್ಹಿ ವಕ್ಷ್ಯಥಃ ಪ್ರಭೇाರತ್ರ ಪ್ರಯೋಜನಮ್ ಆಸ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ತದಾ ತೌ ಪ್ರರಿತೌ ಗತ್ವಾ ತತ್ಕಥಾाನುಸಾರೇಣ ಸರ್ವ್ವಂ ಪ್ರಾಪ್ತೌ| ");
INSERT INTO sankan_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ಗರ್ದಭಶಾವಕಮೋಚನಕಾಲೇ ತತ್ವಾಮಿನ ಊಚುಃ, ಗರ್ದಭಶಾವಕಂ ಕುತೋ ಮೋಚಯಥಃ? ");
INSERT INTO sankan_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","ತಾವೂಚತುಃ ಪ್ರಭೋರತ್ರ ಪ್ರಯೋಜನಮ್ ಆಸ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ಪಶ್ಚಾತ್ ತೌ ತಂ ಗರ್ದಭಶಾವಕಂ ಯೀಶೋರನ್ತಿಕಮಾನೀಯ ತತ್ಪೃಷ್ಠೇ ನಿಜವಸನಾನಿ ಪಾತಯಿತ್ವಾ ತದುಪರಿ ಯೀಶುಮಾರೋಹಯಾಮಾಸತುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ಅಥ ಯಾತ್ರಾಕಾಲೇ ಲೋಕಾಃ ಪಥಿ ಸ್ವವಸ್ತ್ರಾಣಿ ಪಾತಯಿತುಮ್ ಆರೇಭಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ಅಪರಂ ಜೈತುನಾದ್ರೇರುಪತ್ಯಕಾಮ್ ಇತ್ವಾ ಶಿಷ್ಯಸಂಘಃ ಪೂರ್ವ್ವದೃಷ್ಟಾನಿ ಮಹಾಕರ್ಮ್ಮಾಣಿ ಸ್ಮೃತ್ವಾ, ");
INSERT INTO sankan_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ಯೋ ರಾಜಾ ಪ್ರಭೋ ರ್ನಾಮ್ನಾಯಾತಿ ಸ ಧನ್ಯಃ ಸ್ವರ್ಗೇ ಕುಶಲಂ ಸರ್ವ್ವೋಚ್ಚೇ ಜಯಧ್ವನಿ ರ್ಭವತು, ಕಥಾಮೇತಾಂ ಕಥಯಿತ್ವಾ ಸಾನನ್ದಮ್ ಉಚೈರೀಶ್ವರಂ ಧನ್ಯಂ ವಕ್ತುಮಾರೇಭೇ| ");
INSERT INTO sankan_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","ತದಾ ಲೋಕಾರಣ್ಯಮಧ್ಯಸ್ಥಾಃ ಕಿಯನ್ತಃ ಫಿರೂಶಿನಸ್ತತ್ ಶ್ರುತ್ವಾ ಯೀಶುಂ ಪ್ರೋಚುಃ, ಹೇ ಉಪದೇಶಕ ಸ್ವಶಿಷ್ಯಾನ್ ತರ್ಜಯ| ");
INSERT INTO sankan_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ಸ ಉವಾಚ, ಯುಷ್ಮಾನಹಂ ವದಾಮಿ ಯದ್ಯಮೀ ನೀರವಾಸ್ತಿಷ್ಠನ್ತಿ ತರ್ಹಿ ಪಾಷಾಣಾ ಉಚೈಃ ಕಥಾಃ ಕಥಯಿಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","ಪಶ್ಚಾತ್ ತತ್ಪುರಾನ್ತಿಕಮೇತ್ಯ ತದವಲೋಕ್ಯ ಸಾಶ್ರುಪಾತಂ ಜಗಾದ, ");
INSERT INTO sankan_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ಹಾ ಹಾ ಚೇತ್ ತ್ವಮಗ್ರೇಽಜ್ಞಾಸ್ಯಥಾಃ, ತವಾಸ್ಮಿನ್ನೇವ ದಿನೇ ವಾ ಯದಿ ಸ್ವಮಙ್ಗಲಮ್ ಉಪಾಲಪ್ಸ್ಯಥಾಃ, ತರ್ಹ್ಯುತ್ತಮಮ್ ಅಭವಿಷ್ಯತ್, ಕಿನ್ತು ಕ್ಷಣೇಸ್ಮಿನ್ ತತ್ತವ ದೃಷ್ಟೇರಗೋಚರಮ್ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ತ್ವಂ ಸ್ವತ್ರಾಣಕಾಲೇ ನ ಮನೋ ನ್ಯಧತ್ಥಾ ಇತಿ ಹೇತೋ ರ್ಯತ್ಕಾಲೇ ತವ ರಿಪವಸ್ತ್ವಾಂ ಚತುರ್ದಿಕ್ಷು ಪ್ರಾಚೀರೇಣ ವೇಷ್ಟಯಿತ್ವಾ ರೋತ್ಸ್ಯನ್ತಿ ");
INSERT INTO sankan_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ಬಾಲಕೈಃ ಸಾರ್ದ್ಧಂ ಭೂಮಿಸಾತ್ ಕರಿಷ್ಯನ್ತಿ ಚ ತ್ವನ್ಮಧ್ಯೇ ಪಾಷಾಣೈಕೋಪಿ ಪಾಷಾಣೋಪರಿ ನ ಸ್ಥಾಸ್ಯತಿ ಚ, ಕಾಲ ಈದೃಶ ಉಪಸ್ಥಾಸ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","ಅಥ ಮಧ್ಯೇಮನ್ದಿರಂ ಪ್ರವಿಶ್ಯ ತತ್ರತ್ಯಾನ್ ಕ್ರಯಿವಿಕ್ರಯಿಣೋ ಬಹಿಷ್ಕುರ್ವ್ವನ್ ");
INSERT INTO sankan_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ಅವದತ್ ಮದ್ಗೃಹಂ ಪ್ರಾರ್ಥನಾಗೃಹಮಿತಿ ಲಿಪಿರಾಸ್ತೇ ಕಿನ್ತು ಯೂಯಂ ತದೇವ ಚೈರಾಣಾಂ ಗಹ್ವರಂ ಕುರುಥ| ");
INSERT INTO sankan_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","ಪಶ್ಚಾತ್ ಸ ಪ್ರತ್ಯಹಂ ಮಧ್ಯೇಮನ್ದಿರಮ್ ಉಪದಿದೇಶ; ತತಃ ಪ್ರಧಾನಯಾಜಕಾ ಅಧ್ಯಾಪಕಾಃ ಪ್ರಾಚೀನಾಶ್ಚ ತಂ ನಾಶಯಿತುಂ ಚಿಚೇಷ್ಟಿರೇ; ");
INSERT INTO sankan_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ಕಿನ್ತು ತದುಪದೇಶೇ ಸರ್ವ್ವೇ ಲೋಕಾ ನಿವಿಷ್ಟಚಿತ್ತಾಃ ಸ್ಥಿತಾಸ್ತಸ್ಮಾತ್ ತೇ ತತ್ಕರ್ತ್ತುಂ ನಾವಕಾಶಂ ಪ್ರಾಪುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","ಅಥೈಕದಾ ಯೀಶು ರ್ಮನಿದರೇ ಸುಸಂವಾದಂ ಪ್ರಚಾರಯನ್ ಲೋಕಾನುಪದಿಶತಿ, ಏತರ್ಹಿ ಪ್ರಧಾನಯಾಜಕಾ ಅಧ್ಯಾಪಕಾಃ ಪ್ರಾಞ್ಚಶ್ಚ ತನ್ನಿಕಟಮಾಗತ್ಯ ಪಪ್ರಚ್ಛುಃ ");
INSERT INTO sankan_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ಕಯಾಜ್ಞಯಾ ತ್ವಂ ಕರ್ಮ್ಮಾಣ್ಯೇತಾನಿ ಕರೋಷಿ? ಕೋ ವಾ ತ್ವಾಮಾಜ್ಞಾಪಯತ್? ತದಸ್ಮಾನ್ ವದ| ");
INSERT INTO sankan_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ಸ ಪ್ರತ್ಯುವಾಚ, ತರ್ಹಿ ಯುಷ್ಮಾನಪಿ ಕಥಾಮೇಕಾಂ ಪೃಚ್ಛಾಮಿ ತಸ್ಯೋತ್ತರಂ ವದತ| ");
INSERT INTO sankan_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ಯೋಹನೋ ಮಜ್ಜನಮ್ ಈಶ್ವರಸ್ಯ ಮಾನುಷಾಣಾಂ ವಾಜ್ಞಾತೋ ಜಾತಂ? ");
INSERT INTO sankan_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ತತಸ್ತೇ ಮಿಥೋ ವಿವಿಚ್ಯ ಜಗದುಃ, ಯದೀಶ್ವರಸ್ಯ ವದಾಮಸ್ತರ್ಹಿ ತಂ ಕುತೋ ನ ಪ್ರತ್ಯೈತ ಸ ಇತಿ ವಕ್ಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","ಯದಿ ಮನುಷ್ಯಸ್ಯೇತಿ ವದಾಮಸ್ತರ್ಹಿ ಸರ್ವ್ವೇ ಲೋಕಾ ಅಸ್ಮಾನ್ ಪಾಷಾಣೈ ರ್ಹನಿಷ್ಯನ್ತಿ ಯತೋ ಯೋಹನ್ ಭವಿಷ್ಯದ್ವಾದೀತಿ ಸರ್ವ್ವೇ ದೃಢಂ ಜಾನನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ಅತಏವ ತೇ ಪ್ರತ್ಯೂಚುಃ ಕಸ್ಯಾಜ್ಞಯಾ ಜಾತಮ್ ಇತಿ ವಕ್ತುಂ ನ ಶಕ್ನುಮಃ| ");
INSERT INTO sankan_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","ತದಾ ಯೀಶುರವದತ್ ತರ್ಹಿ ಕಯಾಜ್ಞಯಾ ಕರ್ಮ್ಮಾಣ್ಯೇತಾತಿ ಕರೋಮೀತಿ ಚ ಯುಷ್ಮಾನ್ ನ ವಕ್ಷ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","ಅಥ ಲೋಕಾನಾಂ ಸಾಕ್ಷಾತ್ ಸ ಇಮಾಂ ದೃಷ್ಟಾನ್ತಕಥಾಂ ವಕ್ತುಮಾರೇಭೇ, ಕಶ್ಚಿದ್ ದ್ರಾಕ್ಷಾಕ್ಷೇತ್ರಂ ಕೃತ್ವಾ ತತ್ ಕ್ಷೇತ್ರಂ ಕೃಷೀವಲಾನಾಂ ಹಸ್ತೇಷು ಸಮರ್ಪ್ಯ ಬಹುಕಾಲಾರ್ಥಂ ದೂರದೇಶಂ ಜಗಾಮ| ");
INSERT INTO sankan_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","ಅಥ ಫಲಕಾಲೇ ಫಲಾನಿ ಗ್ರಹೀತು ಕೃಷೀವಲಾನಾಂ ಸಮೀಪೇ ದಾಸಂ ಪ್ರಾಹಿಣೋತ್ ಕಿನ್ತು ಕೃಷೀವಲಾಸ್ತಂ ಪ್ರಹೃತ್ಯ ರಿಕ್ತಹಸ್ತಂ ವಿಸಸರ್ಜುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ತತಃ ಸೋಧಿಪತಿಃ ಪುನರನ್ಯಂ ದಾಸಂ ಪ್ರೇಷಯಾಮಾಸ, ತೇ ತಮಪಿ ಪ್ರಹೃತ್ಯ ಕುವ್ಯವಹೃತ್ಯ ರಿಕ್ತಹಸ್ತಂ ವಿಸಸೃಜುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ತತಃ ಸ ತೃತೀಯವಾರಮ್ ಅನ್ಯಂ ಪ್ರಾಹಿಣೋತ್ ತೇ ತಮಪಿ ಕ್ಷತಾಙ್ಗಂ ಕೃತ್ವಾ ಬಹಿ ರ್ನಿಚಿಕ್ಷಿಪುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ತದಾ ಕ್ಷೇತ್ರಪತಿ ರ್ವಿಚಾರಯಾಮಾಸ, ಮಮೇದಾನೀಂ ಕಿಂ ಕರ್ತ್ತವ್ಯಂ? ಮಮ ಪ್ರಿಯೇ ಪುತ್ರೇ ಪ್ರಹಿತೇ ತೇ ತಮವಶ್ಯಂ ದೃಷ್ಟ್ವಾ ಸಮಾದರಿಷ್ಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","ಕಿನ್ತು ಕೃಷೀವಲಾಸ್ತಂ ನಿರೀಕ್ಷ್ಯ ಪರಸ್ಪರಂ ವಿವಿಚ್ಯ ಪ್ರೋಚುಃ, ಅಯಮುತ್ತರಾಧಿಕಾರೀ ಆಗಚ್ಛತೈನಂ ಹನ್ಮಸ್ತತೋಧಿಕಾರೋಸ್ಮಾಕಂ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ತತಸ್ತೇ ತಂ ಕ್ಷೇತ್ರಾದ್ ಬಹಿ ರ್ನಿಪಾತ್ಯ ಜಘ್ನುಸ್ತಸ್ಮಾತ್ ಸ ಕ್ಷೇತ್ರಪತಿಸ್ತಾನ್ ಪ್ರತಿ ಕಿಂ ಕರಿಷ್ಯತಿ? ");
INSERT INTO sankan_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ಸ ಆಗತ್ಯ ತಾನ್ ಕೃಷೀವಲಾನ್ ಹತ್ವಾ ಪರೇಷಾಂ ಹಸ್ತೇಷು ತತ್ಕ್ಷೇತ್ರಂ ಸಮರ್ಪಯಿಷ್ಯತಿ; ಇತಿ ಕಥಾಂ ಶ್ರುತ್ವಾ ತೇ ಽವದನ್ ಏತಾದೃಶೀ ಘಟನಾ ನ ಭವತು| ");
INSERT INTO sankan_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ಕಿನ್ತು ಯೀಶುಸ್ತಾನವಲೋಕ್ಯ ಜಗಾದ, ತರ್ಹಿ, ಸ್ಥಪತಯಃ ಕರಿಷ್ಯನ್ತಿ ಗ್ರಾವಾಣಂ ಯನ್ತು ತುಚ್ಛಕಂ| ಪ್ರಧಾನಪ್ರಸ್ತರಃ ಕೋಣೇ ಸ ಏವ ಹಿ ಭವಿಷ್ಯತಿ| ಏತಸ್ಯ ಶಾಸ್ತ್ರೀಯವಚನಸ್ಯ ಕಿಂ ತಾತ್ಪರ್ಯ್ಯಂ? ");
INSERT INTO sankan_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","ಅಪರಂ ತತ್ಪಾಷಾಣೋಪರಿ ಯಃ ಪತಿಷ್ಯತಿ ಸ ಭಂಕ್ಷ್ಯತೇ ಕಿನ್ತು ಯಸ್ಯೋಪರಿ ಸ ಪಾಷಾಣಃ ಪತಿಷ್ಯತಿ ಸ ತೇನ ಧೂಲಿವಚ್ ಚೂರ್ಣೀಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ಸೋಸ್ಮಾಕಂ ವಿರುದ್ಧಂ ದೃಷ್ಟಾನ್ತಮಿಮಂ ಕಥಿತವಾನ್ ಇತಿ ಜ್ಞಾತ್ವಾ ಪ್ರಧಾನಯಾಜಕಾ ಅಧ್ಯಾಪಕಾಶ್ಚ ತದೈವ ತಂ ಧರ್ತುಂ ವವಾಞ್ಛುಃ ಕಿನ್ತು ಲೋಕೇಭ್ಯೋ ಬಿಭ್ಯುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ಅತಏವ ತಂ ಪ್ರತಿ ಸತರ್ಕಾಃ ಸನ್ತಃ ಕಥಂ ತದ್ವಾಕ್ಯದೋಷಂ ಧೃತ್ವಾ ತಂ ದೇಶಾಧಿಪಸ್ಯ ಸಾಧುವೇಶಧಾರಿಣಶ್ಚರಾನ್ ತಸ್ಯ ಸಮೀಪೇ ಪ್ರೇಷಯಾಮಾಸುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","ತದಾ ತೇ ತಂ ಪಪ್ರಚ್ಛುಃ, ಹೇ ಉಪದೇಶಕ ಭವಾನ್ ಯಥಾರ್ಥಂ ಕಥಯನ್ ಉಪದಿಶತಿ, ಕಮಪ್ಯನಪೇಕ್ಷ್ಯ ಸತ್ಯತ್ವೇನೈಶ್ವರಂ ಮಾರ್ಗಮುಪದಿಶತಿ, ವಯಮೇತಜ್ಜಾನೀಮಃ| ");
INSERT INTO sankan_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ಕೈಸರರಾಜಾಯ ಕರೋಸ್ಮಾಭಿ ರ್ದೇಯೋ ನ ವಾ? ");
INSERT INTO sankan_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ಸ ತೇಷಾಂ ವಞ್ಚನಂ ಜ್ಞಾತ್ವಾವದತ್ ಕುತೋ ಮಾಂ ಪರೀಕ್ಷಧ್ವೇ? ಮಾಂ ಮುದ್ರಾಮೇಕಂ ದರ್ಶಯತ| ");
INSERT INTO sankan_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","ಇಹ ಲಿಖಿತಾ ಮೂರ್ತಿರಿಯಂ ನಾಮ ಚ ಕಸ್ಯ? ತೇಽವದನ್ ಕೈಸರಸ್ಯ| ");
INSERT INTO sankan_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ತದಾ ಸ ಉವಾಚ, ತರ್ಹಿ ಕೈಸರಸ್ಯ ದ್ರವ್ಯಂ ಕೈಸರಾಯ ದತ್ತ; ಈಶ್ವರಸ್ಯ ತು ದ್ರವ್ಯಮೀಶ್ವರಾಯ ದತ್ತ| ");
INSERT INTO sankan_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ತಸ್ಮಾಲ್ಲೋಕಾನಾಂ ಸಾಕ್ಷಾತ್ ತತ್ಕಥಾಯಾಃ ಕಮಪಿ ದೋಷಂ ಧರ್ತುಮಪ್ರಾಪ್ಯ ತೇ ತಸ್ಯೋತ್ತರಾದ್ ಆಶ್ಚರ್ಯ್ಯಂ ಮನ್ಯಮಾನಾ ಮೌನಿನಸ್ತಸ್ಥುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","ಅಪರಞ್ಚ ಶ್ಮಶಾನಾದುತ್ಥಾನಾನಙ್ಗೀಕಾರಿಣಾಂ ಸಿದೂಕಿನಾಂ ಕಿಯನ್ತೋ ಜನಾ ಆಗತ್ಯ ತಂ ಪಪ್ರಚ್ಛುಃ, ");
INSERT INTO sankan_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","ಹೇ ಉಪದೇಶಕ ಶಾಸ್ತ್ರೇ ಮೂಸಾ ಅಸ್ಮಾನ್ ಪ್ರತೀತಿ ಲಿಲೇಖ ಯಸ್ಯ ಭ್ರಾತಾ ಭಾರ್ಯ್ಯಾಯಾಂ ಸತ್ಯಾಂ ನಿಃಸನ್ತಾನೋ ಮ್ರಿಯತೇ ಸ ತಜ್ಜಾಯಾಂ ವಿವಹ್ಯ ತದ್ವಂಶಮ್ ಉತ್ಪಾದಯಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ತಥಾಚ ಕೇಚಿತ್ ಸಪ್ತ ಭ್ರಾತರ ಆಸನ್ ತೇಷಾಂ ಜ್ಯೇಷ್ಠೋ ಭ್ರಾತಾ ವಿವಹ್ಯ ನಿರಪತ್ಯಃ ಪ್ರಾಣಾನ್ ಜಹೌ| ");
INSERT INTO sankan_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ಅಥ ದ್ವಿತೀಯಸ್ತಸ್ಯ ಜಾಯಾಂ ವಿವಹ್ಯ ನಿರಪತ್ಯಃ ಸನ್ ಮಮಾರ| ತೃತೀಯಶ್ಚ ತಾಮೇವ ವ್ಯುವಾಹ; ");
INSERT INTO sankan_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ಇತ್ಥಂ ಸಪ್ತ ಭ್ರಾತರಸ್ತಾಮೇವ ವಿವಹ್ಯ ನಿರಪತ್ಯಾಃ ಸನ್ತೋ ಮಮ್ರುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ಶೇಷೇ ಸಾ ಸ್ತ್ರೀ ಚ ಮಮಾರ| ");
INSERT INTO sankan_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ಅತಏವ ಶ್ಮಶಾನಾದುತ್ಥಾನಕಾಲೇ ತೇಷಾಂ ಸಪ್ತಜನಾನಾಂ ಕಸ್ಯ ಸಾ ಭಾರ್ಯ್ಯಾ ಭವಿಷ್ಯತಿ? ಯತಃ ಸಾ ತೇಷಾಂ ಸಪ್ತಾನಾಮೇವ ಭಾರ್ಯ್ಯಾಸೀತ್| ");
INSERT INTO sankan_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","ತದಾ ಯೀಶುಃ ಪ್ರತ್ಯುವಾಚ, ಏತಸ್ಯ ಜಗತೋ ಲೋಕಾ ವಿವಹನ್ತಿ ವಾಗ್ದತ್ತಾಶ್ಚ ಭವನ್ತಿ ");
INSERT INTO sankan_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ಕಿನ್ತು ಯೇ ತಜ್ಜಗತ್ಪ್ರಾಪ್ತಿಯೋಗ್ಯತ್ವೇನ ಗಣಿತಾಂ ಭವಿಷ್ಯನ್ತಿ ಶ್ಮಶಾನಾಚ್ಚೋತ್ಥಾಸ್ಯನ್ತಿ ತೇ ನ ವಿವಹನ್ತಿ ವಾಗ್ದತ್ತಾಶ್ಚ ನ ಭವನ್ತಿ, ");
INSERT INTO sankan_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ತೇ ಪುನ ರ್ನ ಮ್ರಿಯನ್ತೇ ಕಿನ್ತು ಶ್ಮಶಾನಾದುತ್ಥಾಪಿತಾಃ ಸನ್ತ ಈಶ್ವರಸ್ಯ ಸನ್ತಾನಾಃ ಸ್ವರ್ಗೀಯದೂತಾನಾಂ ಸದೃಶಾಶ್ಚ ಭವನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","ಅಧಿಕನ್ತು ಮೂಸಾಃ ಸ್ತಮ್ಬೋಪಾಖ್ಯಾನೇ ಪರಮೇಶ್ವರ ಈಬ್ರಾಹೀಮ ಈಶ್ವರ ಇಸ್ಹಾಕ ಈಶ್ವರೋ ಯಾಕೂಬಶ್ಚೇಶ್ವರ ಇತ್ಯುಕ್ತ್ವಾ ಮೃತಾನಾಂ ಶ್ಮಶಾನಾದ್ ಉತ್ಥಾನಸ್ಯ ಪ್ರಮಾಣಂ ಲಿಲೇಖ| ");
INSERT INTO sankan_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ಅತಏವ ಯ ಈಶ್ವರಃ ಸ ಮೃತಾನಾಂ ಪ್ರಭು ರ್ನ ಕಿನ್ತು ಜೀವತಾಮೇವ ಪ್ರಭುಃ, ತನ್ನಿಕಟೇ ಸರ್ವ್ವೇ ಜೀವನ್ತಃ ಸನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ಇತಿ ಶ್ರುತ್ವಾ ಕಿಯನ್ತೋಧ್ಯಾಪಕಾ ಊಚುಃ, ಹೇ ಉಪದೇಶಕ ಭವಾನ್ ಭದ್ರಂ ಪ್ರತ್ಯುಕ್ತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ಇತಃ ಪರಂ ತಂ ಕಿಮಪಿ ಪ್ರಷ್ಟಂ ತೇಷಾಂ ಪ್ರಗಲ್ಭತಾ ನಾಭೂತ್| ");
INSERT INTO sankan_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ಪಶ್ಚಾತ್ ಸ ತಾನ್ ಉವಾಚ, ಯಃ ಖ್ರೀಷ್ಟಃ ಸ ದಾಯೂದಃ ಸನ್ತಾನ ಏತಾಂ ಕಥಾಂ ಲೋಕಾಃ ಕಥಂ ಕಥಯನ್ತಿ? ");
INSERT INTO sankan_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","ಯತಃ ಮಮ ಪ್ರಭುಮಿದಂ ವಾಕ್ಯಮವದತ್ ಪರಮೇಶ್ವರಃ| ತವ ಶತ್ರೂನಹಂ ಯಾವತ್ ಪಾದಪೀಠಂ ಕರೋಮಿ ನ| ತಾವತ್ ಕಾಲಂ ಮದೀಯೇ ತ್ವಂ ದಕ್ಷಪಾರ್ಶ್ವ ಉಪಾವಿಶ| ");
INSERT INTO sankan_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ಇತಿ ಕಥಾಂ ದಾಯೂದ್ ಸ್ವಯಂ ಗೀತಗ್ರನ್ಥೇಽವದತ್| ");
INSERT INTO sankan_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","ಅತಏವ ಯದಿ ದಾಯೂದ್ ತಂ ಪ್ರಭುಂ ವದತಿ, ತರ್ಹಿ ಸ ಕಥಂ ತಸ್ಯ ಸನ್ತಾನೋ ಭವತಿ? ");
INSERT INTO sankan_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","ಪಶ್ಚಾದ್ ಯೀಶುಃ ಸರ್ವ್ವಜನಾನಾಂ ಕರ್ಣಗೋಚರೇ ಶಿಷ್ಯಾನುವಾಚ, ");
INSERT INTO sankan_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","ಯೇಽಧ್ಯಾಪಕಾ ದೀರ್ಘಪರಿಚ್ಛದಂ ಪರಿಧಾಯ ಭ್ರಮನ್ತಿ, ಹಟ್ಟಾಪಣಯೋ ರ್ನಮಸ್ಕಾರೇ ಭಜನಗೇಹಸ್ಯ ಪ್ರೋಚ್ಚಾಸನೇ ಭೋಜನಗೃಹಸ್ಯ ಪ್ರಧಾನಸ್ಥಾನೇ ಚ ಪ್ರೀಯನ್ತೇ ");
INSERT INTO sankan_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ವಿಧವಾನಾಂ ಸರ್ವ್ವಸ್ವಂ ಗ್ರಸಿತ್ವಾ ಛಲೇನ ದೀರ್ಘಕಾಲಂ ಪ್ರಾರ್ಥಯನ್ತೇ ಚ ತೇಷು ಸಾವಧಾನಾ ಭವತ, ತೇಷಾಮುಗ್ರದಣ್ಡೋ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","ಅಥ ಧನಿಲೋಕಾ ಭಾಣ್ಡಾಗಾರೇ ಧನಂ ನಿಕ್ಷಿಪನ್ತಿ ಸ ತದೇವ ಪಶ್ಯತಿ, ");
INSERT INTO sankan_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ಏತರ್ಹಿ ಕಾಚಿದ್ದೀನಾ ವಿಧವಾ ಪಣದ್ವಯಂ ನಿಕ್ಷಿಪತಿ ತದ್ ದದರ್ಶ| ");
INSERT INTO sankan_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ತತೋ ಯೀಶುರುವಾಚ ಯುಷ್ಮಾನಹಂ ಯಥಾರ್ಥಂ ವದಾಮಿ, ದರಿದ್ರೇಯಂ ವಿಧವಾ ಸರ್ವ್ವೇಭ್ಯೋಧಿಕಂ ನ್ಯಕ್ಷೇಪ್ಸೀತ್, ");
INSERT INTO sankan_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ಯತೋನ್ಯೇ ಸ್ವಪ್ರಾಜ್ಯಧನೇಭ್ಯ ಈಶ್ವರಾಯ ಕಿಞ್ಚಿತ್ ನ್ಯಕ್ಷೇಪ್ಸುಃ, ಕಿನ್ತು ದರಿದ್ರೇಯಂ ವಿಧವಾ ದಿನಯಾಪನಾರ್ಥಂ ಸ್ವಸ್ಯ ಯತ್ ಕಿಞ್ಚಿತ್ ಸ್ಥಿತಂ ತತ್ ಸರ್ವ್ವಂ ನ್ಯಕ್ಷೇಪ್ಸೀತ್| ");
INSERT INTO sankan_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","ಅಪರಞ್ಚ ಉತ್ತಮಪ್ರಸ್ತರೈರುತ್ಸೃಷ್ಟವ್ಯೈಶ್ಚ ಮನ್ದಿರಂ ಸುಶೋಭತೇತರಾಂ ಕೈಶ್ಚಿದಿತ್ಯುಕ್ತೇ ಸ ಪ್ರತ್ಯುವಾಚ ");
INSERT INTO sankan_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","ಯೂಯಂ ಯದಿದಂ ನಿಚಯನಂ ಪಶ್ಯಥ, ಅಸ್ಯ ಪಾಷಾಣೈಕೋಪ್ಯನ್ಯಪಾಷಾಣೋಪರಿ ನ ಸ್ಥಾಸ್ಯತಿ, ಸರ್ವ್ವೇ ಭೂಸಾದ್ಭವಿಷ್ಯನ್ತಿ ಕಾಲೋಯಮಾಯಾತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ತದಾ ತೇ ಪಪ್ರಚ್ಛುಃ, ಹೇ ಗುರೋ ಘಟನೇದೃಶೀ ಕದಾ ಭವಿಷ್ಯತಿ? ಘಟನಾಯಾ ಏತಸ್ಯಸಶ್ಚಿಹ್ನಂ ವಾ ಕಿಂ ಭವಿಷ್ಯತಿ? ");
INSERT INTO sankan_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ತದಾ ಸ ಜಗಾದ, ಸಾವಧಾನಾ ಭವತ ಯಥಾ ಯುಷ್ಮಾಕಂ ಭ್ರಮಂ ಕೋಪಿ ನ ಜನಯತಿ, ಖೀಷ್ಟೋಹಮಿತ್ಯುಕ್ತ್ವಾ ಮಮ ನಾಮ್ರಾ ಬಹವ ಉಪಸ್ಥಾಸ್ಯನ್ತಿ ಸ ಕಾಲಃ ಪ್ರಾಯೇಣೋಪಸ್ಥಿತಃ, ತೇಷಾಂ ಪಶ್ಚಾನ್ಮಾ ಗಚ್ಛತ| ");
INSERT INTO sankan_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","ಯುದ್ಧಸ್ಯೋಪಪ್ಲವಸ್ಯ ಚ ವಾರ್ತ್ತಾಂ ಶ್ರುತ್ವಾ ಮಾ ಶಙ್ಕಧ್ವಂ, ಯತಃ ಪ್ರಥಮಮ್ ಏತಾ ಘಟನಾ ಅವಶ್ಯಂ ಭವಿಷ್ಯನ್ತಿ ಕಿನ್ತು ನಾಪಾತೇ ಯುಗಾನ್ತೋ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","ಅಪರಞ್ಚ ಕಥಯಾಮಾಸ, ತದಾ ದೇಶಸ್ಯ ವಿಪಕ್ಷತ್ವೇನ ದೇಶೋ ರಾಜ್ಯಸ್ಯ ವಿಪಕ್ಷತ್ವೇನ ರಾಜ್ಯಮ್ ಉತ್ಥಾಸ್ಯತಿ, ");
INSERT INTO sankan_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ನಾನಾಸ್ಥಾನೇಷು ಮಹಾಭೂಕಮ್ಪೋ ದುರ್ಭಿಕ್ಷಂ ಮಾರೀ ಚ ಭವಿಷ್ಯನ್ತಿ, ತಥಾ ವ್ಯೋಮಮಣ್ಡಲಸ್ಯ ಭಯಙ್ಕರದರ್ಶನಾನ್ಯಶ್ಚರ್ಯ್ಯಲಕ್ಷಣಾನಿ ಚ ಪ್ರಕಾಶಯಿಷ್ಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","ಕಿನ್ತು ಸರ್ವ್ವಾಸಾಮೇತಾಸಾಂ ಘಟನಾನಾಂ ಪೂರ್ವ್ವಂ ಲೋಕಾ ಯುಷ್ಮಾನ್ ಧೃತ್ವಾ ತಾಡಯಿಷ್ಯನ್ತಿ, ಭಜನಾಲಯೇ ಕಾರಾಯಾಞ್ಚ ಸಮರ್ಪಯಿಷ್ಯನ್ತಿ ಮಮ ನಾಮಕಾರಣಾದ್ ಯುಷ್ಮಾನ್ ಭೂಪಾನಾಂ ಶಾಸಕಾನಾಞ್ಚ ಸಮ್ಮುಖಂ ನೇಷ್ಯನ್ತಿ ಚ| ");
INSERT INTO sankan_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ಸಾಕ್ಷ್ಯಾರ್ಥಮ್ ಏತಾನಿ ಯುಷ್ಮಾನ್ ಪ್ರತಿ ಘಟಿಷ್ಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ತದಾ ಕಿಮುತ್ತರಂ ವಕ್ತವ್ಯಮ್ ಏತತ್ ನ ಚಿನ್ತಯಿಷ್ಯಾಮ ಇತಿ ಮನಃಸು ನಿಶ್ಚಿತನುತ| ");
INSERT INTO sankan_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ವಿಪಕ್ಷಾ ಯಸ್ಮಾತ್ ಕಿಮಪ್ಯುತ್ತರಮ್ ಆಪತ್ತಿಞ್ಚ ಕರ್ತ್ತುಂ ನ ಶಕ್ಷ್ಯನ್ತಿ ತಾದೃಶಂ ವಾಕ್ಪಟುತ್ವಂ ಜ್ಞಾನಞ್ಚ ಯುಷ್ಮಭ್ಯಂ ದಾಸ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","ಕಿಞ್ಚ ಯೂಯಂ ಪಿತ್ರಾ ಮಾತ್ರಾ ಭ್ರಾತ್ರಾ ಬನ್ಧುನಾ ಜ್ಞಾತ್ಯಾ ಕುಟುಮ್ಬೇನ ಚ ಪರಕರೇಷು ಸಮರ್ಪಯಿಷ್ಯಧ್ವೇ; ತತಸ್ತೇ ಯುಷ್ಮಾಕಂ ಕಞ್ಚನ ಕಞ್ಚನ ಘಾತಯಿಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","ಮಮ ನಾಮ್ನಃ ಕಾರಣಾತ್ ಸರ್ವ್ವೈ ರ್ಮನುಷ್ಯೈ ರ್ಯೂಯಮ್ ಋತೀಯಿಷ್ಯಧ್ವೇ| ");
INSERT INTO sankan_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ಕಿನ್ತು ಯುಷ್ಮಾಕಂ ಶಿರಃಕೇಶೈಕೋಪಿ ನ ವಿನಂಕ್ಷ್ಯತಿ, ");
INSERT INTO sankan_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ತಸ್ಮಾದೇವ ಧೈರ್ಯ್ಯಮವಲಮ್ಬ್ಯ ಸ್ವಸ್ವಪ್ರಾಣಾನ್ ರಕ್ಷತ| ");
INSERT INTO sankan_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","ಅಪರಞ್ಚ ಯಿರೂಶಾಲಮ್ಪುರಂ ಸೈನ್ಯವೇಷ್ಟಿತಂ ವಿಲೋಕ್ಯ ತಸ್ಯೋಚ್ಛಿನ್ನತಾಯಾಃ ಸಮಯಃ ಸಮೀಪ ಇತ್ಯವಗಮಿಷ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","ತದಾ ಯಿಹೂದಾದೇಶಸ್ಥಾ ಲೋಕಾಃ ಪರ್ವ್ವತಂ ಪಲಾಯನ್ತಾಂ, ಯೇ ಚ ನಗರೇ ತಿಷ್ಠನ್ತಿ ತೇ ದೇಶಾನ್ತರಂ ಪಲಾಯನ್ತಾ, ಯೇ ಚ ಗ್ರಾಮೇ ತಿಷ್ಠನ್ತಿ ತೇ ನಗರಂ ನ ಪ್ರವಿಶನ್ತು, ");
INSERT INTO sankan_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","ಯತಸ್ತದಾ ಸಮುಚಿತದಣ್ಡನಾಯ ಧರ್ಮ್ಮಪುಸ್ತಕೇ ಯಾನಿ ಸರ್ವ್ವಾಣಿ ಲಿಖಿತಾನಿ ತಾನಿ ಸಫಲಾನಿ ಭವಿಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","ಕಿನ್ತು ಯಾ ಯಾಸ್ತದಾ ಗರ್ಭವತ್ಯಃ ಸ್ತನ್ಯದಾವ್ಯಶ್ಚ ತಾಮಾಂ ದುರ್ಗತಿ ರ್ಭವಿಷ್ಯತಿ, ಯತ ಏತಾಲ್ಲೋಕಾನ್ ಪ್ರತಿ ಕೋಪೋ ದೇಶೇ ಚ ವಿಷಮದುರ್ಗತಿ ರ್ಘಟಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","ವಸ್ತುತಸ್ತು ತೇ ಖಙ್ಗಧಾರಪರಿವ್ವಙ್ಗಂ ಲಪ್ಸ್ಯನ್ತೇ ಬದ್ಧಾಃ ಸನ್ತಃ ಸರ್ವ್ವದೇಶೇಷು ನಾಯಿಷ್ಯನ್ತೇ ಚ ಕಿಞ್ಚಾನ್ಯದೇಶೀಯಾನಾಂ ಸಮಯೋಪಸ್ಥಿತಿಪರ್ಯ್ಯನ್ತಂ ಯಿರೂಶಾಲಮ್ಪುರಂ ತೈಃ ಪದತಲೈ ರ್ದಲಯಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","ಸೂರ್ಯ್ಯಚನ್ದ್ರನಕ್ಷತ್ರೇಷು ಲಕ್ಷಣಾದಿ ಭವಿಷ್ಯನ್ತಿ, ಭುವಿ ಸರ್ವ್ವದೇಶೀಯಾನಾಂ ದುಃಖಂ ಚಿನ್ತಾ ಚ ಸಿನ್ಧೌ ವೀಚೀನಾಂ ತರ್ಜನಂ ಗರ್ಜನಞ್ಚ ಭವಿಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ಭೂಭೌ ಭಾವಿಘಟನಾಂ ಚಿನ್ತಯಿತ್ವಾ ಮನುಜಾ ಭಿಯಾಮೃತಕಲ್ಪಾ ಭವಿಷ್ಯನ್ತಿ, ಯತೋ ವ್ಯೋಮಮಣ್ಡಲೇ ತೇಜಸ್ವಿನೋ ದೋಲಾಯಮಾನಾ ಭವಿಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ತದಾ ಪರಾಕ್ರಮೇಣಾ ಮಹಾತೇಜಸಾ ಚ ಮೇಘಾರೂಢಂ ಮನುಷ್ಯಪುತ್ರಮ್ ಆಯಾನ್ತಂ ದ್ರಕ್ಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","ಕಿನ್ತ್ವೇತಾಸಾಂ ಘಟನಾನಾಮಾರಮ್ಭೇ ಸತಿ ಯೂಯಂ ಮಸ್ತಕಾನ್ಯುತ್ತೋಲ್ಯ ಊರ್ದಧ್ವಂ ದ್ರಕ್ಷ್ಯಥ, ಯತೋ ಯುಷ್ಮಾಕಂ ಮುಕ್ತೇಃ ಕಾಲಃ ಸವಿಧೋ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ತತಸ್ತೇನೈತದೃಷ್ಟಾನ್ತಕಥಾ ಕಥಿತಾ, ಪಶ್ಯತ ಉಡುಮ್ಬರಾದಿವೃಕ್ಷಾಣಾಂ ");
INSERT INTO sankan_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ನವೀನಪತ್ರಾಣಿ ಜಾತಾನೀತಿ ದೃಷ್ಟ್ವಾ ನಿದಾವಕಾಲ ಉಪಸ್ಥಿತ ಇತಿ ಯಥಾ ಯೂಯಂ ಜ್ಞಾತುಂ ಶಕ್ನುಥ, ");
INSERT INTO sankan_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ತಥಾ ಸರ್ವ್ವಾಸಾಮಾಸಾಂ ಘಟನಾನಾಮ್ ಆರಮ್ಭೇ ದೃಷ್ಟೇ ಸತೀಶ್ವರಸ್ಯ ರಾಜತ್ವಂ ನಿಕಟಮ್ ಇತ್ಯಪಿ ಜ್ಞಾಸ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","ಯುಷ್ಮಾನಹಂ ಯಥಾರ್ಥಂ ವದಾಮಿ, ವಿದ್ಯಮಾನಲೋಕಾನಾಮೇಷಾಂ ಗಮನಾತ್ ಪೂರ್ವ್ವಮ್ ಏತಾನಿ ಘಟಿಷ್ಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ನಭೋಭುವೋರ್ಲೋಪೋ ಭವಿಷ್ಯತಿ ಮಮ ವಾಕ್ ತು ಕದಾಪಿ ಲುಪ್ತಾ ನ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","ಅತಏವ ವಿಷಮಾಶನೇನ ಪಾನೇನ ಚ ಸಾಂಮಾರಿಕಚಿನ್ತಾಭಿಶ್ಚ ಯುಷ್ಮಾಕಂ ಚಿತ್ತೇಷು ಮತ್ತೇಷು ತದ್ದಿನಮ್ ಅಕಸ್ಮಾದ್ ಯುಷ್ಮಾನ್ ಪ್ರತಿ ಯಥಾ ನೋಪತಿಷ್ಠತಿ ತದರ್ಥಂ ಸ್ವೇಷು ಸಾವಧಾನಾಸ್ತಿಷ್ಠತ| ");
INSERT INTO sankan_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ಪೃಥಿವೀಸ್ಥಸರ್ವ್ವಲೋಕಾನ್ ಪ್ರತಿ ತದ್ದಿನಮ್ ಉನ್ಮಾಥ ಇವ ಉಪಸ್ಥಾಸ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ಯಥಾ ಯೂಯಮ್ ಏತದ್ಭಾವಿಘಟನಾ ಉತ್ತರ್ತ್ತುಂ ಮನುಜಸುತಸ್ಯ ಸಮ್ಮುಖೇ ಸಂಸ್ಥಾತುಞ್ಚ ಯೋಗ್ಯಾ ಭವಥ ಕಾರಣಾದಸ್ಮಾತ್ ಸಾವಧಾನಾಃ ಸನ್ತೋ ನಿರನ್ತರಂ ಪ್ರಾರ್ಥಯಧ್ವಂ| ");
INSERT INTO sankan_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ಅಪರಞ್ಚ ಸ ದಿವಾ ಮನ್ದಿರ ಉಪದಿಶ್ಯ ರಾಚೈ ಜೈತುನಾದ್ರಿಂ ಗತ್ವಾತಿಷ್ಠತ್| ");
INSERT INTO sankan_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ತತಃ ಪ್ರತ್ಯೂಷೇ ಲಾಕಾಸ್ತತ್ಕಥಾಂ ಶ್ರೋತುಂ ಮನ್ದಿರೇ ತದನ್ತಿಕಮ್ ಆಗಚ್ಛನ್| ");
INSERT INTO sankan_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","ಅಪರಞ್ಚ ಕಿಣ್ವಶೂನ್ಯಪೂಪೋತ್ಸವಸ್ಯ ಕಾಲ ಉಪಸ್ಥಿತೇ ");
INSERT INTO sankan_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ಪ್ರಧಾನಯಾಜಕಾ ಅಧ್ಯಾಯಕಾಶ್ಚ ಯಥಾ ತಂ ಹನ್ತುಂ ಶಕ್ನುವನ್ತಿ ತಥೋಪಾಯಾಮ್ ಅಚೇಷ್ಟನ್ತ ಕಿನ್ತು ಲೋಕೇಭ್ಯೋ ಬಿಭ್ಯುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ಏತಸ್ತಿನ್ ಸಮಯೇ ದ್ವಾದಶಶಿಷ್ಯೇಷು ಗಣಿತ ಈಷ್ಕರಿಯೋತೀಯರೂಢಿಮಾನ್ ಯೋ ಯಿಹೂದಾಸ್ತಸ್ಯಾನ್ತಃಕರಣಂ ಶೈತಾನಾಶ್ರಿತತ್ವಾತ್ ");
INSERT INTO sankan_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ಸ ಗತ್ವಾ ಯಥಾ ಯೀಶುಂ ತೇಷಾಂ ಕರೇಷು ಸಮರ್ಪಯಿತುಂ ಶಕ್ನೋತಿ ತಥಾ ಮನ್ತ್ರಣಾಂ ಪ್ರಧಾನಯಾಜಕೈಃ ಸೇನಾಪತಿಭಿಶ್ಚ ಸಹ ಚಕಾರ| ");
INSERT INTO sankan_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","ತೇನ ತೇ ತುಷ್ಟಾಸ್ತಸ್ಮೈ ಮುದ್ರಾಂ ದಾತುಂ ಪಣಂ ಚಕ್ರುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ತತಃ ಸೋಙ್ಗೀಕೃತ್ಯ ಯಥಾ ಲೋಕಾನಾಮಗೋಚರೇ ತಂ ಪರಕರೇಷು ಸಮರ್ಪಯಿತುಂ ಶಕ್ನೋತಿ ತಥಾವಕಾಶಂ ಚೇಷ್ಟಿತುಮಾರೇಭೇ| ");
INSERT INTO sankan_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","ಅಥ ಕಿಣ್ವಶೂನ್ಯಪೂಪೋತ್ಮವದಿನೇ, ಅರ್ಥಾತ್ ಯಸ್ಮಿನ್ ದಿನೇ ನಿಸ್ತಾರೋತ್ಸವಸ್ಯ ಮೇಷೋ ಹನ್ತವ್ಯಸ್ತಸ್ಮಿನ್ ದಿನೇ ");
INSERT INTO sankan_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ಯೀಶುಃ ಪಿತರಂ ಯೋಹನಞ್ಚಾಹೂಯ ಜಗಾದ, ಯುವಾಂ ಗತ್ವಾಸ್ಮಾಕಂ ಭೋಜನಾರ್ಥಂ ನಿಸ್ತಾರೋತ್ಸವಸ್ಯ ದ್ರವ್ಯಾಣ್ಯಾಸಾದಯತಂ| ");
INSERT INTO sankan_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ತದಾ ತೌ ಪಪ್ರಚ್ಛತುಃ ಕುಚಾಸಾದಯಾವೋ ಭವತಃ ಕೇಚ್ಛಾ? ");
INSERT INTO sankan_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ತದಾ ಸೋವಾದೀತ್, ನಗರೇ ಪ್ರವಿಷ್ಟೇ ಕಶ್ಚಿಜ್ಜಲಕುಮ್ಭಮಾದಾಯ ಯುವಾಂ ಸಾಕ್ಷಾತ್ ಕರಿಷ್ಯತಿ ಸ ಯನ್ನಿವೇಶನಂ ಪ್ರವಿಶತಿ ಯುವಾಮಪಿ ತನ್ನಿವೇಶನಂ ತತ್ಪಶ್ಚಾದಿತ್ವಾ ನಿವೇಶನಪತಿಮ್ ಇತಿ ವಾಕ್ಯಂ ವದತಂ, ");
INSERT INTO sankan_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ಯತ್ರಾಹಂ ನಿಸ್ತಾರೋತ್ಸವಸ್ಯ ಭೋಜ್ಯಂ ಶಿಷ್ಯೈಃ ಸಾರ್ದ್ಧಂ ಭೋಕ್ತುಂ ಶಕ್ನೋಮಿ ಸಾತಿಥಿಶಾಲಾा ಕುತ್ರ? ಕಥಾಮಿಮಾಂ ಪ್ರಭುಸ್ತ್ವಾಂ ಪೃಚ್ಛತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ತತಃ ಸ ಜನೋ ದ್ವಿತೀಯಪ್ರಕೋಷ್ಠೀಯಮ್ ಏಕಂ ಶಸ್ತಂ ಕೋಷ್ಠಂ ದರ್ಶಯಿಷ್ಯತಿ ತತ್ರ ಭೋಜ್ಯಮಾಸಾದಯತಂ| ");
INSERT INTO sankan_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ತತಸ್ತೌ ಗತ್ವಾ ತದ್ವಾಕ್ಯಾನುಸಾರೇಣ ಸರ್ವ್ವಂ ದೃಷ್ದ್ವಾ ತತ್ರ ನಿಸ್ತಾರೋತ್ಸವೀಯಂ ಭೋಜ್ಯಮಾಸಾದಯಾಮಾಸತುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","ಅಥ ಕಾಲ ಉಪಸ್ಥಿತೇ ಯೀಶು ರ್ದ್ವಾದಶಭಿಃ ಪ್ರೇರಿತೈಃ ಸಹ ಭೋಕ್ತುಮುಪವಿಶ್ಯ ಕಥಿತವಾನ್ ");
INSERT INTO sankan_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ಮಮ ದುಃಖಭೋಗಾತ್ ಪೂರ್ವ್ವಂ ಯುಭಾಭಿಃ ಸಹ ನಿಸ್ತಾರೋತ್ಸವಸ್ಯೈತಸ್ಯ ಭೋಜ್ಯಂ ಭೋಕ್ತುಂ ಮಯಾತಿವಾಞ್ಛಾ ಕೃತಾ| ");
INSERT INTO sankan_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","ಯುಷ್ಮಾನ್ ವದಾಮಿ, ಯಾವತ್ಕಾಲಮ್ ಈಶ್ವರರಾಜ್ಯೇ ಭೋಜನಂ ನ ಕರಿಷ್ಯೇ ತಾವತ್ಕಾಲಮ್ ಇದಂ ನ ಭೋಕ್ಷ್ಯೇ| ");
INSERT INTO sankan_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ತದಾ ಸ ಪಾನಪಾತ್ರಮಾದಾಯ ಈಶ್ವರಸ್ಯ ಗುಣಾನ್ ಕೀರ್ತ್ತಯಿತ್ವಾ ತೇಭ್ಯೋ ದತ್ವಾವದತ್, ಇದಂ ಗೃಹ್ಲೀತ ಯೂಯಂ ವಿಭಜ್ಯ ಪಿವತ| ");
INSERT INTO sankan_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ಯುಷ್ಮಾನ್ ವದಾಮಿ ಯಾವತ್ಕಾಲಮ್ ಈಶ್ವರರಾಜತ್ವಸ್ಯ ಸಂಸ್ಥಾಪನಂ ನ ಭವತಿ ತಾವದ್ ದ್ರಾಕ್ಷಾಫಲರಸಂ ನ ಪಾಸ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ತತಃ ಪೂಪಂ ಗೃಹೀತ್ವಾ ಈಶ್ವರಗುಣಾನ್ ಕೀರ್ತ್ತಯಿತ್ವಾ ಭಙ್ಕ್ತಾ ತೇಭ್ಯೋ ದತ್ವಾವದತ್, ಯುಷ್ಮದರ್ಥಂ ಸಮರ್ಪಿತಂ ಯನ್ಮಮ ವಪುಸ್ತದಿದಂ, ಏತತ್ ಕರ್ಮ್ಮ ಮಮ ಸ್ಮರಣಾರ್ಥಂ ಕುರುಧ್ವಂ| ");
INSERT INTO sankan_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","ಅಥ ಭೋಜನಾನ್ತೇ ತಾದೃಶಂ ಪಾತ್ರಂ ಗೃಹೀತ್ವಾವದತ್, ಯುಷ್ಮತ್ಕೃತೇ ಪಾತಿತಂ ಯನ್ಮಮ ರಕ್ತಂ ತೇನ ನಿರ್ಣೀತನವನಿಯಮರೂಪಂ ಪಾನಪಾತ್ರಮಿದಂ| ");
INSERT INTO sankan_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","ಪಶ್ಯತ ಯೋ ಮಾಂ ಪರಕರೇಷು ಸಮರ್ಪಯಿಷ್ಯತಿ ಸ ಮಯಾ ಸಹ ಭೋಜನಾಸನ ಉಪವಿಶತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","ಯಥಾ ನಿರೂಪಿತಮಾಸ್ತೇ ತದನುಸಾರೇಣಾ ಮನುಷ್ಯಪುुತ್ರಸ್ಯ ಗತಿ ರ್ಭವಿಷ್ಯತಿ ಕಿನ್ತು ಯಸ್ತಂ ಪರಕರೇಷು ಸಮರ್ಪಯಿಷ್ಯತಿ ತಸ್ಯ ಸನ್ತಾಪೋ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ತದಾ ತೇಷಾಂ ಕೋ ಜನ ಏತತ್ ಕರ್ಮ್ಮ ಕರಿಷ್ಯತಿ ತತ್ ತೇ ಪರಸ್ಪರಂ ಪ್ರಷ್ಟುಮಾರೇಭಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","ಅಪರಂ ತೇಷಾಂ ಕೋ ಜನಃ ಶ್ರೇಷ್ಠತ್ವೇನ ಗಣಯಿಷ್ಯತೇ, ಅತ್ರಾರ್ಥೇ ತೇಷಾಂ ವಿವಾದೋಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","ಅಸ್ಮಾತ್ ಕಾರಣಾತ್ ಸೋವದತ್, ಅನ್ಯದೇಶೀಯಾನಾಂ ರಾಜಾನಃ ಪ್ರಜಾನಾಮುಪರಿ ಪ್ರಭುತ್ವಂ ಕುರ್ವ್ವನ್ತಿ ದಾರುಣಶಾಸನಂ ಕೃತ್ವಾಪಿ ತೇ ಭೂಪತಿತ್ವೇನ ವಿಖ್ಯಾತಾ ಭವನ್ತಿ ಚ| ");
INSERT INTO sankan_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","ಕಿನ್ತು ಯುಷ್ಮಾಕಂ ತಥಾ ನ ಭವಿಷ್ಯತಿ, ಯೋ ಯುಷ್ಮಾಕಂ ಶ್ರೇಷ್ಠೋ ಭವಿಷ್ಯತಿ ಸ ಕನಿಷ್ಠವದ್ ಭವತು, ಯಶ್ಚ ಮುಖ್ಯೋ ಭವಿಷ್ಯತಿ ಸ ಸೇವಕವದ್ಭವತು| ");
INSERT INTO sankan_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","ಭೋಜನೋಪವಿಷ್ಟಪರಿಚಾರಕಯೋಃ ಕಃ ಶ್ರೇಷ್ಠಃ? ಯೋ ಭೋಜನಾಯೋಪವಿಶತಿ ಸ ಕಿಂ ಶ್ರೇಷ್ಠೋ ನ ಭವತಿ? ಕಿನ್ತು ಯುಷ್ಮಾಕಂ ಮಧ್ಯೇಽಹಂ ಪರಿಚಾರಕಇವಾಸ್ಮಿ| ");
INSERT INTO sankan_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","ಅಪರಞ್ಚ ಯುಯಂ ಮಮ ಪರೀಕ್ಷಾಕಾಲೇ ಪ್ರಥಮಮಾರಭ್ಯ ಮಯಾ ಸಹ ಸ್ಥಿತಾ ");
INSERT INTO sankan_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ಏತತ್ಕಾರಣಾತ್ ಪಿತ್ರಾ ಯಥಾ ಮದರ್ಥಂ ರಾಜ್ಯಮೇಕಂ ನಿರೂಪಿತಂ ತಥಾಹಮಪಿ ಯುಷ್ಮದರ್ಥಂ ರಾಜ್ಯಂ ನಿರೂಪಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ತಸ್ಮಾನ್ ಮಮ ರಾಜ್ಯೇ ಭೋಜನಾಸನೇ ಚ ಭೋಜನಪಾನೇ ಕರಿಷ್ಯಧ್ವೇ ಸಿಂಹಾಸನೇಷೂಪವಿಶ್ಯ ಚೇಸ್ರಾಯೇಲೀಯಾನಾಂ ದ್ವಾದಶವಂಶಾನಾಂ ವಿಚಾರಂ ಕರಿಷ್ಯಧ್ವೇ| ");
INSERT INTO sankan_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","ಅಪರಂ ಪ್ರಭುರುವಾಚ, ಹೇ ಶಿಮೋನ್ ಪಶ್ಯ ತಿತಉನಾ ಧಾನ್ಯಾನೀವ ಯುಷ್ಮಾನ್ ಶೈತಾನ್ ಚಾಲಯಿತುಮ್ ಐಚ್ಛತ್, ");
INSERT INTO sankan_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","ಕಿನ್ತು ತವ ವಿಶ್ವಾಸಸ್ಯ ಲೋಪೋ ಯಥಾ ನ ಭವತಿ ಏತತ್ ತ್ವದರ್ಥಂ ಪ್ರಾರ್ಥಿತಂ ಮಯಾ, ತ್ವನ್ಮನಸಿ ಪರಿವರ್ತ್ತಿತೇ ಚ ಭ್ರಾತೃಣಾಂ ಮನಾಂಸಿ ಸ್ಥಿರೀಕುರು| ");
INSERT INTO sankan_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ತದಾ ಸೋವದತ್, ಹೇ ಪ್ರಭೋಹಂ ತ್ವಯಾ ಸಾರ್ದ್ಧಂ ಕಾರಾಂ ಮೃತಿಞ್ಚ ಯಾತುಂ ಮಜ್ಜಿತೋಸ್ಮಿ| ");
INSERT INTO sankan_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ತತಃ ಸ ಉವಾಚ, ಹೇ ಪಿತರ ತ್ವಾಂ ವದಾಮಿ, ಅದ್ಯ ಕುಕ್ಕುಟರವಾತ್ ಪೂರ್ವ್ವಂ ತ್ವಂ ಮತ್ಪರಿಚಯಂ ವಾರತ್ರಯಮ್ ಅಪಹ್ವೋಷ್ಯಸೇ| ");
INSERT INTO sankan_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ಅಪರಂ ಸ ಪಪ್ರಚ್ಛ, ಯದಾ ಮುದ್ರಾಸಮ್ಪುಟಂ ಖಾದ್ಯಪಾತ್ರಂ ಪಾದುಕಾಞ್ಚ ವಿನಾ ಯುಷ್ಮಾನ್ ಪ್ರಾಹಿಣವಂ ತದಾ ಯುಷ್ಮಾಕಂ ಕಸ್ಯಾಪಿ ನ್ಯೂನತಾಸೀತ್? ತೇ ಪ್ರೋಚುಃ ಕಸ್ಯಾಪಿ ನ| ");
INSERT INTO sankan_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ತದಾ ಸೋವದತ್ ಕಿನ್ತ್ವಿದಾನೀಂ ಮುದ್ರಾಸಮ್ಪುಟಂ ಖಾದ್ಯಪಾತ್ರಂ ವಾ ಯಸ್ಯಾಸ್ತಿ ತೇನ ತದ್ಗ್ರಹೀತವ್ಯಂ, ಯಸ್ಯ ಚ ಕೃಪಾಣೋे ನಾಸ್ತಿ ತೇನ ಸ್ವವಸ್ತ್ರಂ ವಿಕ್ರೀಯ ಸ ಕ್ರೇತವ್ಯಃ| ");
INSERT INTO sankan_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","ಯತೋ ಯುಷ್ಮಾನಹಂ ವದಾಮಿ, ಅಪರಾಧಿಜನೈಃ ಸಾರ್ದ್ಧಂ ಗಣಿತಃ ಸ ಭವಿಷ್ಯತಿ| ಇದಂ ಯಚ್ಛಾಸ್ತ್ರೀಯಂ ವಚನಂ ಲಿಖಿತಮಸ್ತಿ ತನ್ಮಯಿ ಫಲಿಷ್ಯತಿ ಯತೋ ಮಮ ಸಮ್ಬನ್ಧೀಯಂ ಸರ್ವ್ವಂ ಸೇತ್ಸ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","ತದಾ ತೇ ಪ್ರೋಚುಃ ಪ್ರಭೋ ಪಶ್ಯ ಇಮೌ ಕೃಪಾಣೌ| ತತಃ ಸೋವದದ್ ಏತೌ ಯಥೇಷ್ಟೌ| ");
INSERT INTO sankan_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","ಅಥ ಸ ತಸ್ಮಾದ್ವಹಿ ರ್ಗತ್ವಾ ಸ್ವಾಚಾರಾನುಸಾರೇಣ ಜೈತುನನಾಮಾದ್ರಿಂ ಜಗಾಮ ಶಿಷ್ಯಾಶ್ಚ ತತ್ಪಶ್ಚಾದ್ ಯಯುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ತತ್ರೋಪಸ್ಥಾಯ ಸ ತಾನುವಾಚ, ಯಥಾ ಪರೀಕ್ಷಾಯಾಂ ನ ಪತಥ ತದರ್ಥಂ ಪ್ರಾರ್ಥಯಧ್ವಂ| ");
INSERT INTO sankan_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ಪಶ್ಚಾತ್ ಸ ತಸ್ಮಾದ್ ಏಕಶರಕ್ಷೇಪಾದ್ ಬಹಿ ರ್ಗತ್ವಾ ಜಾನುನೀ ಪಾತಯಿತ್ವಾ ಏತತ್ ಪ್ರಾರ್ಥಯಾಞ್ಚಕ್ರೇ, ");
INSERT INTO sankan_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ಹೇ ಪಿತ ರ್ಯದಿ ಭವಾನ್ ಸಮ್ಮನ್ಯತೇ ತರ್ಹಿ ಕಂಸಮೇನಂ ಮಮಾನ್ತಿಕಾದ್ ದೂರಯ ಕಿನ್ತು ಮದಿಚ್ಛಾನುರೂಪಂ ನ ತ್ವದಿಚ್ಛಾನುರೂಪಂ ಭವತು| ");
INSERT INTO sankan_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ತದಾ ತಸ್ಮೈ ಶಕ್ತಿಂ ದಾತುಂ ಸ್ವರ್ಗೀಯದೂತೋ ದರ್ಶನಂ ದದೌ| ");
INSERT INTO sankan_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ಪಶ್ಚಾತ್ ಸೋತ್ಯನ್ತಂ ಯಾತನಯಾ ವ್ಯಾಕುಲೋ ಭೂತ್ವಾ ಪುನರ್ದೃಢಂ ಪ್ರಾರ್ಥಯಾಞ್ಚಕ್ರೇ, ತಸ್ಮಾದ್ ಬೃಹಚ್ಛೋಣಿತಬಿನ್ದವ ಇವ ತಸ್ಯ ಸ್ವೇದಬಿನ್ದವಃ ಪೃಥಿವ್ಯಾಂ ಪತಿತುಮಾರೇಭಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","ಅಥ ಪ್ರಾರ್ಥನಾತ ಉತ್ಥಾಯ ಶಿಷ್ಯಾಣಾಂ ಸಮೀಪಮೇತ್ಯ ತಾನ್ ಮನೋದುಃಖಿನೋ ನಿದ್ರಿತಾನ್ ದೃಷ್ಟ್ವಾವದತ್ ");
INSERT INTO sankan_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ಕುತೋ ನಿದ್ರಾಥ? ಪರೀಕ್ಷಾಯಾಮ್ ಅಪತನಾರ್ಥಂ ಪ್ರರ್ಥಯಧ್ವಂ| ");
INSERT INTO sankan_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ಏತತ್ಕಥಾಯಾಃ ಕಥನಕಾಲೇ ದ್ವಾದಶಶಿಷ್ಯಾಣಾಂ ಮಧ್ಯೇ ಗಣಿತೋ ಯಿಹೂದಾನಾಮಾ ಜನತಾಸಹಿತಸ್ತೇಷಾಮ್ ಅಗ್ರೇ ಚಲಿತ್ವಾ ಯೀಶೋಶ್ಚುಮ್ಬನಾರ್ಥಂ ತದನ್ತಿಕಮ್ ಆಯಯೌ| ");
INSERT INTO sankan_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ತದಾ ಯೀಶುರುವಾಚ, ಹೇ ಯಿಹೂದಾ ಕಿಂ ಚುಮ್ಬನೇನ ಮನುಷ್ಯಪುತ್ರಂ ಪರಕರೇಷು ಸಮರ್ಪಯಸಿ? ");
INSERT INTO sankan_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ತದಾ ಯದ್ಯದ್ ಘಟಿಷ್ಯತೇ ತದನುಮಾಯ ಸಙ್ಗಿಭಿರುಕ್ತಂ, ಹೇ ಪ್ರಭೋ ವಯಂ ಕಿ ಖಙ್ಗೇನ ಘಾತಯಿಷ್ಯಾಮಃ? ");
INSERT INTO sankan_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ತತ ಏಕಃ ಕರವಾಲೇನಾಹತ್ಯ ಪ್ರಧಾನಯಾಜಕಸ್ಯ ದಾಸಸ್ಯ ದಕ್ಷಿಣಂ ಕರ್ಣಂ ಚಿಚ್ಛೇದ| ");
INSERT INTO sankan_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","ಅಧೂನಾ ನಿವರ್ತ್ತಸ್ವ ಇತ್ಯುಕ್ತ್ವಾ ಯೀಶುಸ್ತಸ್ಯ ಶ್ರುತಿಂ ಸ್ಪೃಷ್ಟ್ವಾ ಸ್ವಸ್ಯಂ ಚಕಾರ| ");
INSERT INTO sankan_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ಪಶ್ಚಾದ್ ಯೀಶುಃ ಸಮೀಪಸ್ಥಾನ್ ಪ್ರಧಾನಯಾಜಕಾನ್ ಮನ್ದಿರಸ್ಯ ಸೇನಾಪತೀನ್ ಪ್ರಾಚೀನಾಂಶ್ಚ ಜಗಾದ, ಯೂಯಂ ಕೃಪಾಣಾನ್ ಯಷ್ಟೀಂಶ್ಚ ಗೃಹೀತ್ವಾ ಮಾಂ ಕಿಂ ಚೋರಂ ಧರ್ತ್ತುಮಾಯಾತಾಃ? ");
INSERT INTO sankan_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ಯದಾಹಂ ಯುಷ್ಮಾಭಿಃ ಸಹ ಪ್ರತಿದಿನಂ ಮನ್ದಿರೇಽತಿಷ್ಠಂ ತದಾ ಮಾಂ ಧರ್ತ್ತಂ ನ ಪ್ರವೃತ್ತಾಃ, ಕಿನ್ತ್ವಿದಾನೀಂ ಯುಷ್ಮಾಕಂ ಸಮಯೋನ್ಧಕಾರಸ್ಯ ಚಾಧಿಪತ್ಯಮಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","ಅಥ ತೇ ತಂ ಧೃತ್ವಾ ಮಹಾಯಾಜಕಸ್ಯ ನಿವೇಶನಂ ನಿನ್ಯುಃ| ತತಃ ಪಿತರೋ ದೂರೇ ದೂರೇ ಪಶ್ಚಾದಿತ್ವಾ ");
INSERT INTO sankan_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","ಬೃಹತ್ಕೋಷ್ಠಸ್ಯ ಮಧ್ಯೇ ಯತ್ರಾಗ್ನಿಂ ಜ್ವಾಲಯಿತ್ವಾ ಲೋಕಾಃ ಸಮೇತ್ಯೋಪವಿಷ್ಟಾಸ್ತತ್ರ ತೈಃ ಸಾರ್ದ್ಧಮ್ ಉಪವಿವೇಶ| ");
INSERT INTO sankan_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ಅಥ ವಹ್ನಿಸನ್ನಿಧೌ ಸಮುಪವೇಶಕಾಲೇ ಕಾಚಿದ್ದಾಸೀ ಮನೋ ನಿವಿಶ್ಯ ತಂ ನಿರೀಕ್ಷ್ಯಾವದತ್ ಪುಮಾನಯಂ ತಸ್ಯ ಸಙ್ಗೇಽಸ್ಥಾತ್| ");
INSERT INTO sankan_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","ಕಿನ್ತು ಸ ತದ್ ಅಪಹ್ನುತ್ಯಾವಾದೀತ್ ಹೇ ನಾರಿ ತಮಹಂ ನ ಪರಿಚಿನೋಮಿ| ");
INSERT INTO sankan_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ಕ್ಷಣಾನ್ತರೇಽನ್ಯಜನಸ್ತಂ ದೃಷ್ಟ್ವಾಬ್ರವೀತ್ ತ್ವಮಪಿ ತೇಷಾಂ ನಿಕರಸ್ಯೈಕಜನೋಸಿ| ಪಿತರಃ ಪ್ರತ್ಯುವಾಚ ಹೇ ನರ ನಾಹಮಸ್ಮಿ| ");
INSERT INTO sankan_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ತತಃ ಸಾರ್ದ್ಧದಣ್ಡದ್ವಯಾತ್ ಪರಂ ಪುನರನ್ಯೋ ಜನೋ ನಿಶ್ಚಿತ್ಯ ಬಭಾಷೇ, ಏಷ ತಸ್ಯ ಸಙ್ಗೀತಿ ಸತ್ಯಂ ಯತೋಯಂ ಗಾಲೀಲೀಯೋ ಲೋಕಃ| ");
INSERT INTO sankan_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","ತದಾ ಪಿತರ ಉವಾಚ ಹೇ ನರ ತ್ವಂ ಯದ್ ವದಮಿ ತದಹಂ ಬೋದ್ಧುಂ ನ ಶಕ್ನೋಮಿ, ಇತಿ ವಾಕ್ಯೇ ಕಥಿತಮಾತ್ರೇ ಕುಕ್ಕುಟೋ ರುರಾವ| ");
INSERT INTO sankan_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ತದಾ ಪ್ರಭುಣಾ ವ್ಯಾಧುಟ್ಯ ಪಿತರೇ ನಿರೀಕ್ಷಿತೇ ಕೃಕವಾಕುರವಾತ್ ಪೂರ್ವ್ವಂ ಮಾಂ ತ್ರಿರಪಹ್ನೋಷ್ಯಸೇ ಇತಿ ಪೂರ್ವ್ವೋಕ್ತಂ ತಸ್ಯ ವಾಕ್ಯಂ ಪಿತರಃ ಸ್ಮೃತ್ವಾ ");
INSERT INTO sankan_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ಬಹಿರ್ಗತ್ವಾ ಮಹಾಖೇದೇನ ಚಕ್ರನ್ದ| ");
INSERT INTO sankan_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","ತದಾ ಯೈ ರ್ಯೀಶುರ್ಧೃತಸ್ತೇ ತಮುಪಹಸ್ಯ ಪ್ರಹರ್ತ್ತುಮಾರೇಭಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ವಸ್ತ್ರೇಣ ತಸ್ಯ ದೃಶೌ ಬದ್ಧ್ವಾ ಕಪೋಲೇ ಚಪೇಟಾಘಾತಂ ಕೃತ್ವಾ ಪಪ್ರಚ್ಛುಃ, ಕಸ್ತೇ ಕಪೋಲೇ ಚಪೇಟಾಘಾತಂ ಕೃತವಾನ? ಗಣಯಿತ್ವಾ ತದ್ ವದ| ");
INSERT INTO sankan_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ತದನ್ಯತ್ ತದ್ವಿರುದ್ಧಂ ಬಹುನಿನ್ದಾವಾಕ್ಯಂ ವಕ್ತುಮಾರೇಭಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","ಅಥ ಪ್ರಭಾತೇ ಸತಿ ಲೋಕಪ್ರಾಞ್ಚಃ ಪ್ರಧಾನಯಾಜಕಾ ಅಧ್ಯಾಪಕಾಶ್ಚ ಸಭಾಂ ಕೃತ್ವಾ ಮಧ್ಯೇಸಭಂ ಯೀಶುಮಾನೀಯ ಪಪ್ರಚ್ಛುಃ, ತ್ವಮ್ ಅಭಿಷಿಕತೋಸಿ ನ ವಾಸ್ಮಾನ್ ವದ| ");
INSERT INTO sankan_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ಸ ಪ್ರತ್ಯುವಾಚ, ಮಯಾ ತಸ್ಮಿನ್ನುಕ್ತೇಽಪಿ ಯೂಯಂ ನ ವಿಶ್ವಸಿಷ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ಕಸ್ಮಿಂಶ್ಚಿದ್ವಾಕ್ಯೇ ಯುಷ್ಮಾನ್ ಪೃಷ್ಟೇಽಪಿ ಮಾಂ ನ ತದುತ್ತರಂ ವಕ್ಷ್ಯಥ ನ ಮಾಂ ತ್ಯಕ್ಷ್ಯಥ ಚ| ");
INSERT INTO sankan_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","ಕಿನ್ತ್ವಿತಃ ಪರಂ ಮನುಜಸುತಃ ಸರ್ವ್ವಶಕ್ತಿಮತ ಈಶ್ವರಸ್ಯ ದಕ್ಷಿಣೇ ಪಾರ್ಶ್ವೇ ಸಮುಪವೇಕ್ಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ತತಸ್ತೇ ಪಪ್ರಚ್ಛುಃ, ರ್ತಿಹ ತ್ವಮೀಶ್ವರಸ್ಯ ಪುತ್ರಃ? ಸ ಕಥಯಾಮಾಸ, ಯೂಯಂ ಯಥಾರ್ಥಂ ವದಥ ಸ ಏವಾಹಂ| ");
INSERT INTO sankan_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ತದಾ ತೇ ಸರ್ವ್ವೇ ಕಥಯಾಮಾಸುಃ, ರ್ತಿಹ ಸಾಕ್ಷ್ಯೇಽನ್ಸಸ್ಮಿನ್ ಅಸ್ಮಾಕಂ ಕಿಂ ಪ್ರಯೋಜನಂ? ಅಸ್ಯ ಸ್ವಮುಖಾದೇವ ಸಾಕ್ಷ್ಯಂ ಪ್ರಾಪ್ತಮ್| ");
INSERT INTO sankan_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ತತಃ ಸಭಾಸ್ಥಾಃ ಸರ್ವ್ವಲೋಕಾ ಉತ್ಥಾಯ ತಂ ಪೀಲಾತಸಮ್ಮುಖಂ ನೀತ್ವಾಪ್ರೋದ್ಯ ವಕ್ತುಮಾರೇಭಿರೇ, ");
INSERT INTO sankan_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ಸ್ವಮಭಿಷಿಕ್ತಂ ರಾಜಾನಂ ವದನ್ತಂ ಕೈಮರರಾಜಾಯ ಕರದಾನಂ ನಿಷೇಧನ್ತಂ ರಾಜ್ಯವಿಪರ್ಯ್ಯಯಂ ಕುರ್ತ್ತುಂ ಪ್ರವರ್ತ್ತಮಾನಮ್ ಏನ ಪ್ರಾಪ್ತಾ ವಯಂ| ");
INSERT INTO sankan_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ತದಾ ಪೀಲಾತಸ್ತಂ ಪೃಷ್ಟವಾನ್ ತ್ವಂ ಕಿಂ ಯಿಹೂದೀಯಾನಾಂ ರಾಜಾ? ಸ ಪ್ರತ್ಯುವಾಚ ತ್ವಂ ಸತ್ಯಮುಕ್ತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ತದಾ ಪೀಲಾತಃ ಪ್ರಧಾನಯಾಜಕಾದಿಲೋಕಾನ್ ಜಗಾದ್, ಅಹಮೇತಸ್ಯ ಕಮಪ್ಯಪರಾಧಂ ನಾಪ್ತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","ತತಸ್ತೇ ಪುನಃ ಸಾಹಮಿನೋ ಭೂತ್ವಾವದನ್, ಏಷ ಗಾಲೀಲ ಏತತ್ಸ್ಥಾನಪರ್ಯ್ಯನ್ತೇ ಸರ್ವ್ವಸ್ಮಿನ್ ಯಿಹೂದಾದೇಶೇ ಸರ್ವ್ವಾಲ್ಲೋಕಾನುಪದಿಶ್ಯ ಕುಪ್ರವೃತ್ತಿಂ ಗ್ರಾಹೀತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ತದಾ ಪೀಲಾತೋ ಗಾಲೀಲಪ್ರದೇಶಸ್ಯ ನಾಮ ಶ್ರುತ್ವಾ ಪಪ್ರಚ್ಛ, ಕಿಮಯಂ ಗಾಲೀಲೀಯೋ ಲೋಕಃ? ");
INSERT INTO sankan_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ತತಃ ಸ ಗಾಲೀಲ್ಪ್ರದೇಶೀಯಹೇರೋದ್ರಾಜಸ್ಯ ತದಾ ಸ್ಥಿತೇಸ್ತಸ್ಯ ಸಮೀಪೇ ಯೀಶುಂ ಪ್ರೇಷಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ತದಾ ಹೇರೋದ್ ಯೀಶುಂ ವಿಲೋಕ್ಯ ಸನ್ತುತೋಷ, ಯತಃ ಸ ತಸ್ಯ ಬಹುವೃತ್ತಾನ್ತಶ್ರವಣಾತ್ ತಸ್ಯ ಕಿಞಿ्ಚದಾಶ್ಚರ್ಯ್ಯಕರ್ಮ್ಮ ಪಶ್ಯತಿ ಇತ್ಯಾಶಾಂ ಕೃತ್ವಾ ಬಹುಕಾಲಮಾರಭ್ಯ ತಂ ದ್ರಷ್ಟುಂ ಪ್ರಯಾಸಂ ಕೃತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ತಸ್ಮಾತ್ ತಂ ಬಹುಕಥಾಃ ಪಪ್ರಚ್ಛ ಕಿನ್ತು ಸ ತಸ್ಯ ಕಸ್ಯಾಪಿ ವಾಕ್ಯಸ್ಯ ಪ್ರತ್ಯುತ್ತರಂ ನೋವಾಚ| ");
INSERT INTO sankan_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","ಅಥ ಪ್ರಧಾನಯಾಜಕಾ ಅಧ್ಯಾಪಕಾಶ್ಚ ಪ್ರೋತ್ತಿಷ್ಠನ್ತಃ ಸಾಹಸೇನ ತಮಪವದಿತುಂ ಪ್ರಾರೇಭಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ಹೇರೋದ್ ತಸ್ಯ ಸೇನಾಗಣಶ್ಚ ತಮವಜ್ಞಾಯ ಉಪಹಾಸತ್ವೇನ ರಾಜವಸ್ತ್ರಂ ಪರಿಧಾಪ್ಯ ಪುನಃ ಪೀಲಾತಂ ಪ್ರತಿ ತಂ ಪ್ರಾಹಿಣೋತ್| ");
INSERT INTO sankan_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ಪೂರ್ವ್ವಂ ಹೇರೋದ್ಪೀಲಾತಯೋಃ ಪರಸ್ಪರಂ ವೈರಭಾವ ಆಸೀತ್ ಕಿನ್ತು ತದ್ದಿನೇ ದ್ವಯೋ ರ್ಮೇಲನಂ ಜಾತಮ್| ");
INSERT INTO sankan_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","ಪಶ್ಚಾತ್ ಪೀಲಾತಃ ಪ್ರಧಾನಯಾಜಕಾನ್ ಶಾಸಕಾನ್ ಲೋಕಾಂಶ್ಚ ಯುಗಪದಾಹೂಯ ಬಭಾಷೇ, ");
INSERT INTO sankan_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ರಾಜ್ಯವಿಪರ್ಯ್ಯಯಕಾರಕೋಯಮ್ ಇತ್ಯುಕ್ತ್ವಾ ಮನುಷ್ಯಮೇನಂ ಮಮ ನಿಕಟಮಾನೈಷ್ಟ ಕಿನ್ತು ಪಶ್ಯತ ಯುಷ್ಮಾಕಂ ಸಮಕ್ಷಮ್ ಅಸ್ಯ ವಿಚಾರಂ ಕೃತ್ವಾಪಿ ಪ್ರೋಕ್ತಾಪವಾದಾನುರೂಪೇಣಾಸ್ಯ ಕೋಪ್ಯಪರಾಧಃ ಸಪ್ರಮಾಣೋ ನ ಜಾತಃ, ");
INSERT INTO sankan_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ಯೂಯಞ್ಚ ಹೇರೋದಃ ಸನ್ನಿಧೌ ಪ್ರೇಷಿತಾ ಮಯಾ ತತ್ರಾಸ್ಯ ಕೋಪ್ಯಪರಾಧಸ್ತೇನಾಪಿ ನ ಪ್ರಾಪ್ತಃ| ಪಶ್ಯತಾನೇನ ವಧಹೇेತುಕಂ ಕಿಮಪಿ ನಾಪರಾದ್ಧಂ| ");
INSERT INTO sankan_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","ತಸ್ಮಾದೇನಂ ತಾಡಯಿತ್ವಾ ವಿಹಾಸ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","ತತ್ರೋತ್ಸವೇ ತೇಷಾಮೇಕೋ ಮೋಚಯಿತವ್ಯಃ| ");
INSERT INTO sankan_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ಇತಿ ಹೇತೋಸ್ತೇ ಪ್ರೋಚ್ಚೈರೇಕದಾ ಪ್ರೋಚುಃ, ಏನಂ ದೂರೀಕೃತ್ಯ ಬರಬ್ಬಾನಾಮಾನಂ ಮೋಚಯ| ");
INSERT INTO sankan_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","ಸ ಬರಬ್ಬಾ ನಗರ ಉಪಪ್ಲವವಧಾಪರಾಧಾಭ್ಯಾಂ ಕಾರಾಯಾಂ ಬದ್ಧ ಆಸೀತ್| ");
INSERT INTO sankan_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","ಕಿನ್ತು ಪೀಲಾತೋ ಯೀಶುಂ ಮೋಚಯಿತುಂ ವಾಞ್ಛನ್ ಪುನಸ್ತಾನುವಾಚ| ");
INSERT INTO sankan_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ತಥಾಪ್ಯೇನಂ ಕ್ರುಶೇ ವ್ಯಧ ಕ್ರುಶೇ ವ್ಯಧೇತಿ ವದನ್ತಸ್ತೇ ರುರುವುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ತತಃ ಸ ತೃತೀಯವಾರಂ ಜಗಾದ ಕುತಃ? ಸ ಕಿಂ ಕರ್ಮ್ಮ ಕೃತವಾನ್? ನಾಹಮಸ್ಯ ಕಮಪಿ ವಧಾಪರಾಧಂ ಪ್ರಾಪ್ತಃ ಕೇವಲಂ ತಾಡಯಿತ್ವಾಮುಂ ತ್ಯಜಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","ತಥಾಪಿ ತೇ ಪುನರೇನಂ ಕ್ರುಶೇ ವ್ಯಧ ಇತ್ಯುಕ್ತ್ವಾ ಪ್ರೋಚ್ಚೈರ್ದೃಢಂ ಪ್ರಾರ್ಥಯಾಞ್ಚಕ್ರಿರೇ; ");
INSERT INTO sankan_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ತತಃ ಪ್ರಧಾನಯಾಜಕಾದೀನಾಂ ಕಲರವೇ ಪ್ರಬಲೇ ಸತಿ ತೇಷಾಂ ಪ್ರಾರ್ಥನಾರೂಪಂ ಕರ್ತ್ತುಂ ಪೀಲಾತ ಆದಿದೇಶ| ");
INSERT INTO sankan_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ರಾಜದ್ರೋಹವಧಯೋರಪರಾಧೇನ ಕಾರಾಸ್ಥಂ ಯಂ ಜನಂ ತೇ ಯಯಾಚಿರೇ ತಂ ಮೋಚಯಿತ್ವಾ ಯೀಶುಂ ತೇಷಾಮಿಚ್ಛಾಯಾಂ ಸಮಾರ್ಪಯತ್| ");
INSERT INTO sankan_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","ಅಥ ತೇ ಯೀಶುಂ ಗೃಹೀತ್ವಾ ಯಾನ್ತಿ, ಏತರ್ಹಿ ಗ್ರಾಮಾದಾಗತಂ ಶಿಮೋನನಾಮಾನಂ ಕುರೀಣೀಯಂ ಜನಂ ಧೃತ್ವಾ ಯೀಶೋಃ ಪಶ್ಚಾನ್ನೇತುಂ ತಸ್ಯ ಸ್ಕನ್ಧೇ ಕ್ರುಶಮರ್ಪಯಾಮಾಸುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ತತೋ ಲೋाಕಾರಣ್ಯಮಧ್ಯೇ ಬಹುಸ್ತ್ರಿಯೋ ರುದತ್ಯೋ ವಿಲಪನ್ತ್ಯಶ್ಚ ಯೀಶೋಃ ಪಶ್ಚಾದ್ ಯಯುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","ಕಿನ್ತು ಸ ವ್ಯಾಘುಟ್ಯ ತಾ ಉವಾಚ, ಹೇ ಯಿರೂಶಾಲಮೋ ನಾರ್ಯ್ಯೋ ಯುಯಂ ಮದರ್ಥಂ ನ ರುದಿತ್ವಾ ಸ್ವಾರ್ಥಂ ಸ್ವಾಪತ್ಯಾರ್ಥಞ್ಚ ರುದಿತಿ; ");
INSERT INTO sankan_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ಪಶ್ಯತ ಯಃ ಕದಾಪಿ ಗರ್ಭವತ್ಯೋ ನಾಭವನ್ ಸ್ತನ್ಯಞ್ಚ ನಾಪಾಯಯನ್ ತಾದೃಶೀ ರ್ವನ್ಧ್ಯಾ ಯದಾ ಧನ್ಯಾ ವಕ್ಷ್ಯನ್ತಿ ಸ ಕಾಲ ಆಯಾತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","ತದಾ ಹೇ ಶೈಲಾ ಅಸ್ಮಾಕಮುಪರಿ ಪತತ, ಹೇ ಉಪಶೈಲಾ ಅಸ್ಮಾನಾಚ್ಛಾದಯತ ಕಥಾಮೀದೃಶೀಂ ಲೋಕಾ ವಕ್ಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","ಯತಃ ಸತೇಜಸಿ ಶಾಖಿನಿ ಚೇದೇತದ್ ಘಟತೇ ತರ್ಹಿ ಶುಷ್ಕಶಾಖಿನಿ ಕಿಂ ನ ಘಟಿಷ್ಯತೇ? ");
INSERT INTO sankan_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ತದಾ ತೇ ಹನ್ತುಂ ದ್ವಾವಪರಾಧಿನೌ ತೇನ ಸಾರ್ದ್ಧಂ ನಿನ್ಯುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","ಅಪರಂ ಶಿರಃಕಪಾಲನಾಮಕಸ್ಥಾನಂ ಪ್ರಾಪ್ಯ ತಂ ಕ್ರುಶೇ ವಿವಿಧುಃ; ತದ್ದ್ವಯೋರಪರಾಧಿನೋರೇಕಂ ತಸ್ಯ ದಕ್ಷಿಣೋ ತದನ್ಯಂ ವಾಮೇ ಕ್ರುಶೇ ವಿವಿಧುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ತದಾ ಯೀಶುರಕಥಯತ್, ಹೇ ಪಿತರೇತಾನ್ ಕ್ಷಮಸ್ವ ಯತ ಏತೇ ಯತ್ ಕರ್ಮ್ಮ ಕುರ್ವ್ವನ್ತಿ ತನ್ ನ ವಿದುಃ; ಪಶ್ಚಾತ್ತೇ ಗುಟಿಕಾಪಾತಂ ಕೃತ್ವಾ ತಸ್ಯ ವಸ್ತ್ರಾಣಿ ವಿಭಜ್ಯ ಜಗೃಹುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","ತತ್ರ ಲೋಕಸಂಘಸ್ತಿಷ್ಠನ್ ದದರ್ಶ; ತೇ ತೇಷಾಂ ಶಾಸಕಾಶ್ಚ ತಮುಪಹಸ್ಯ ಜಗದುಃ, ಏಷ ಇತರಾನ್ ರಕ್ಷಿತವಾನ್ ಯದೀಶ್ವರೇಣಾಭಿರುಚಿತೋ ಽಭಿಷಿಕ್ತಸ್ತ್ರಾತಾ ಭವತಿ ತರ್ಹಿ ಸ್ವಮಧುನಾ ರಕ್ಷತು| ");
INSERT INTO sankan_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","ತದನ್ಯಃ ಸೇನಾಗಣಾ ಏತ್ಯ ತಸ್ಮೈ ಅಮ್ಲರಸಂ ದತ್ವಾ ಪರಿಹಸ್ಯ ಪ್ರೋವಾಚ, ");
INSERT INTO sankan_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ಚೇತ್ತ್ವಂ ಯಿಹೂದೀಯಾನಾಂ ರಾಜಾಸಿ ತರ್ಹಿ ಸ್ವಂ ರಕ್ಷ| ");
INSERT INTO sankan_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ಯಿಹೂದೀಯಾನಾಂ ರಾಜೇತಿ ವಾಕ್ಯಂ ಯೂನಾನೀಯರೋಮೀಯೇಬ್ರೀಯಾಕ್ಷರೈ ರ್ಲಿಖಿತಂ ತಚ್ಛಿರಸ ಊರ್ದ್ಧ್ವೇಽಸ್ಥಾಪ್ಯತ| ");
INSERT INTO sankan_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","ತದೋಭಯಪಾರ್ಶ್ವಯೋ ರ್ವಿದ್ಧೌ ಯಾವಪರಾಧಿನೌ ತಯೋರೇಕಸ್ತಂ ವಿನಿನ್ದ್ಯ ಬಭಾಷೇ, ಚೇತ್ತ್ವಮ್ ಅಭಿಷಿಕ್ತೋಸಿ ತರ್ಹಿ ಸ್ವಮಾವಾಞ್ಚ ರಕ್ಷ| ");
INSERT INTO sankan_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","ಕಿನ್ತ್ವನ್ಯಸ್ತಂ ತರ್ಜಯಿತ್ವಾವದತ್, ಈಶ್ವರಾತ್ತವ ಕಿಞ್ಚಿದಪಿ ಭಯಂ ನಾಸ್ತಿ ಕಿಂ? ತ್ವಮಪಿ ಸಮಾನದಣ್ಡೋಸಿ, ");
INSERT INTO sankan_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ಯೋಗ್ಯಪಾತ್ರೇ ಆವಾಂ ಸ್ವಸ್ವಕರ್ಮ್ಮಣಾಂ ಸಮುಚಿತಫಲಂ ಪ್ರಾಪ್ನುವಃ ಕಿನ್ತ್ವನೇನ ಕಿಮಪಿ ನಾಪರಾದ್ಧಂ| ");
INSERT INTO sankan_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ಅಥ ಸ ಯೀಶುಂ ಜಗಾದ ಹೇ ಪ್ರಭೇ ಭವಾನ್ ಸ್ವರಾಜ್ಯಪ್ರವೇಶಕಾಲೇ ಮಾಂ ಸ್ಮರತು| ");
INSERT INTO sankan_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ತದಾ ಯೀಶುಃ ಕಥಿತವಾನ್ ತ್ವಾಂ ಯಥಾರ್ಥಂ ವದಾಮಿ ತ್ವಮದ್ಯೈವ ಮಯಾ ಸಾರ್ದ್ಧಂ ಪರಲೋಕಸ್ಯ ಸುಖಸ್ಥಾನಂ ಪ್ರಾಪ್ಸ್ಯಸಿ| ");
INSERT INTO sankan_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","ಅಪರಞ್ಚ ದ್ವಿತೀಯಯಾಮಾತ್ ತೃತೀಯಯಾಮಪರ್ಯ್ಯನ್ತಂ ರವೇಸ್ತೇಜಸೋನ್ತರ್ಹಿತತ್ವಾತ್ ಸರ್ವ್ವದೇಶೋಽನ್ಧಕಾರೇಣಾವೃತೋ ");
INSERT INTO sankan_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ಮನ್ದಿರಸ್ಯ ಯವನಿಕಾ ಚ ಛಿದ್ಯಮಾನಾ ದ್ವಿಧಾ ಬಭೂವ| ");
INSERT INTO sankan_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ತತೋ ಯೀಶುರುಚ್ಚೈರುವಾಚ, ಹೇ ಪಿತ ರ್ಮಮಾತ್ಮಾನಂ ತವ ಕರೇ ಸಮರ್ಪಯೇ, ಇತ್ಯುಕ್ತ್ವಾ ಸ ಪ್ರಾಣಾನ್ ಜಹೌ| ");
INSERT INTO sankan_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ತದೈತಾ ಘಟನಾ ದೃಷ್ಟ್ವಾ ಶತಸೇನಾಪತಿರೀಶ್ವರಂ ಧನ್ಯಮುಕ್ತ್ವಾ ಕಥಿತವಾನ್ ಅಯಂ ನಿತಾನ್ತಂ ಸಾಧುಮನುಷ್ಯ ಆಸೀತ್| ");
INSERT INTO sankan_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","ಅಥ ಯಾವನ್ತೋ ಲೋಕಾ ದ್ರಷ್ಟುಮ್ ಆಗತಾಸ್ತೇ ತಾ ಘಟನಾ ದೃಷ್ಟ್ವಾ ವಕ್ಷಃಸು ಕರಾಘಾತಂ ಕೃತ್ವಾ ವ್ಯಾಚುಟ್ಯ ಗತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","ಯೀಶೋ ರ್ಜ್ಞಾತಯೋ ಯಾ ಯಾ ಯೋಷಿತಶ್ಚ ಗಾಲೀಲಸ್ತೇನ ಸಾರ್ದ್ಧಮಾಯಾತಾಸ್ತಾ ಅಪಿ ದೂರೇ ಸ್ಥಿತ್ವಾ ತತ್ ಸರ್ವ್ವಂ ದದೃಶುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","ತದಾ ಯಿಹೂದೀಯಾನಾಂ ಮನ್ತ್ರಣಾಂ ಕ್ರಿಯಾಞ್ಚಾಸಮ್ಮನ್ಯಮಾನ ಈಶ್ವರಸ್ಯ ರಾಜತ್ವಮ್ ಅಪೇಕ್ಷಮಾಣೋ ");
INSERT INTO sankan_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ಯಿಹೂದಿದೇಶೀಯೋ ಽರಿಮಥೀಯನಗರೀಯೋ ಯೂಷಫ್ನಾಮಾ ಮನ್ತ್ರೀ ಭದ್ರೋ ಧಾರ್ಮ್ಮಿಕಶ್ಚ ಪುಮಾನ್ ");
INSERT INTO sankan_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ಪೀಲಾತಾನ್ತಿಕಂ ಗತ್ವಾ ಯೀಶೋ ರ್ದೇಹಂ ಯಯಾಚೇ| ");
INSERT INTO sankan_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ಪಶ್ಚಾದ್ ವಪುರವರೋಹ್ಯ ವಾಸಸಾ ಸಂವೇಷ್ಟ್ಯ ಯತ್ರ ಕೋಪಿ ಮಾನುಷೋ ನಾಸ್ಥಾಪ್ಯತ ತಸ್ಮಿನ್ ಶೈಲೇ ಸ್ವಾತೇ ಶ್ಮಶಾನೇ ತದಸ್ಥಾಪಯತ್| ");
INSERT INTO sankan_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ತದ್ದಿನಮಾಯೋಜನೀಯಂ ದಿನಂ ವಿಶ್ರಾಮವಾರಶ್ಚ ಸಮೀಪಃ| ");
INSERT INTO sankan_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","ಅಪರಂ ಯೀಶುನಾ ಸಾರ್ದ್ಧಂ ಗಾಲೀಲ ಆಗತಾ ಯೋಷಿತಃ ಪಶ್ಚಾದಿತ್ವಾ ಶ್ಮಶಾನೇ ತತ್ರ ಯಥಾ ವಪುಃ ಸ್ಥಾಪಿತಂ ತಚ್ಚ ದೃಷ್ಟ್ವಾ ");
INSERT INTO sankan_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ವ್ಯಾಘುಟ್ಯ ಸುಗನ್ಧಿದ್ರವ್ಯತೈಲಾನಿ ಕೃತ್ವಾ ವಿಧಿವದ್ ವಿಶ್ರಾಮವಾರೇ ವಿಶ್ರಾಮಂ ಚಕ್ರುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","ಅಥ ಸಪ್ತಾಹಪ್ರಥಮದಿನೇಽತಿಪ್ರತ್ಯೂಷೇ ತಾ ಯೋಷಿತಃ ಸಮ್ಪಾದಿತಂ ಸುಗನ್ಧಿದ್ರವ್ಯಂ ಗೃಹೀತ್ವಾ ತದನ್ಯಾಭಿಃ ಕಿಯತೀಭಿಃ ಸ್ತ್ರೀಭಿಃ ಸಹ ಶ್ಮಶಾನಂ ಯಯುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","ಕಿನ್ತು ಶ್ಮಶಾನದ್ವಾರಾತ್ ಪಾಷಾಣಮಪಸಾರಿತಂ ದೃಷ್ಟ್ವಾ ");
INSERT INTO sankan_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ತಾಃ ಪ್ರವಿಶ್ಯ ಪ್ರಭೋ ರ್ದೇಹಮಪ್ರಾಪ್ಯ ");
INSERT INTO sankan_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ವ್ಯಾಕುಲಾ ಭವನ್ತಿ ಏತರ್ಹಿ ತೇಜೋಮಯವಸ್ತ್ರಾನ್ವಿತೌ ದ್ವೌ ಪುರುಷೌ ತಾಸಾಂ ಸಮೀಪೇ ಸಮುಪಸ್ಥಿತೌ ");
INSERT INTO sankan_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ತಸ್ಮಾತ್ತಾಃ ಶಙ್ಕಾಯುಕ್ತಾ ಭೂಮಾವಧೋಮುಖ್ಯಸ್ಯಸ್ಥುಃ| ತದಾ ತೌ ತಾ ಊಚತು ರ್ಮೃತಾನಾಂ ಮಧ್ಯೇ ಜೀವನ್ತಂ ಕುತೋ ಮೃಗಯಥ? ");
INSERT INTO sankan_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","ಸೋತ್ರ ನಾಸ್ತಿ ಸ ಉದಸ್ಥಾತ್| ");
INSERT INTO sankan_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ಪಾಪಿನಾಂ ಕರೇಷು ಸಮರ್ಪಿತೇನ ಕ್ರುಶೇ ಹತೇನ ಚ ಮನುಷ್ಯಪುತ್ರೇಣ ತೃತೀಯದಿವಸೇ ಶ್ಮಶಾನಾದುತ್ಥಾತವ್ಯಮ್ ಇತಿ ಕಥಾಂ ಸ ಗಲೀಲಿ ತಿಷ್ಠನ್ ಯುಷ್ಮಭ್ಯಂ ಕಥಿತವಾನ್ ತಾಂ ಸ್ಮರತ| ");
INSERT INTO sankan_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","ತದಾ ತಸ್ಯ ಸಾ ಕಥಾ ತಾಸಾಂ ಮನಃಸು ಜಾತಾ| ");
INSERT INTO sankan_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ಅನನ್ತರಂ ಶ್ಮಶಾನಾದ್ ಗತ್ವಾ ತಾ ಏಕಾದಶಶಿಷ್ಯಾದಿಭ್ಯಃ ಸರ್ವ್ವೇಭ್ಯಸ್ತಾಂ ವಾರ್ತ್ತಾಂ ಕಥಯಾಮಾಸುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","ಮಗ್ದಲೀನೀಮರಿಯಮ್, ಯೋಹನಾ, ಯಾಕೂಬೋ ಮಾತಾ ಮರಿಯಮ್ ತದನ್ಯಾಃ ಸಙ್ಗಿನ್ಯೋ ಯೋಷಿತಶ್ಚ ಪ್ರೇರಿತೇಭ್ಯ ಏತಾಃ ಸರ್ವ್ವಾ ವಾರ್ತ್ತಾಃ ಕಥಯಾಮಾಸುಃ ");
INSERT INTO sankan_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ಕಿನ್ತು ತಾಸಾಂ ಕಥಾಮ್ ಅನರ್ಥಕಾಖ್ಯಾನಮಾತ್ರಂ ಬುದ್ಧ್ವಾ ಕೋಪಿ ನ ಪ್ರತ್ಯೈತ್| ");
INSERT INTO sankan_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","ತದಾ ಪಿತರ ಉತ್ಥಾಯ ಶ್ಮಶಾನಾನ್ತಿಕಂ ದಧಾವ, ತತ್ರ ಚ ಪ್ರಹ್ವೋ ಭೂತ್ವಾ ಪಾರ್ಶ್ವೈಕಸ್ಥಾಪಿತಂ ಕೇವಲಂ ವಸ್ತ್ರಂ ದದರ್ಶ; ತಸ್ಮಾದಾಶ್ಚರ್ಯ್ಯಂ ಮನ್ಯಮಾನೋ ಯದಘಟತ ತನ್ಮನಸಿ ವಿಚಾರಯನ್ ಪ್ರತಸ್ಥೇ| ");
INSERT INTO sankan_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","ತಸ್ಮಿನ್ನೇವ ದಿನೇ ದ್ವೌ ಶಿಯ್ಯೌ ಯಿರೂಶಾಲಮಶ್ಚತುಷ್ಕ್ರೋಶಾನ್ತರಿತಮ್ ಇಮ್ಮಾಯುಗ್ರಾಮಂ ಗಚ್ಛನ್ತೌ ");
INSERT INTO sankan_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ತಾಸಾಂ ಘಟನಾನಾಂ ಕಥಾಮಕಥಯತಾಂ ");
INSERT INTO sankan_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ತಯೋರಾಲಾಪವಿಚಾರಯೋಃ ಕಾಲೇ ಯೀಶುರಾಗತ್ಯ ತಾಭ್ಯಾಂ ಸಹ ಜಗಾಮ ");
INSERT INTO sankan_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ಕಿನ್ತು ಯಥಾ ತೌ ತಂ ನ ಪರಿಚಿನುತಸ್ತದರ್ಥಂ ತಯೋ ರ್ದೃಷ್ಟಿಃ ಸಂರುದ್ಧಾ| ");
INSERT INTO sankan_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ಸ ತೌ ಪೃಷ್ಟವಾನ್ ಯುವಾಂ ವಿಷಣ್ಣೌ ಕಿಂ ವಿಚಾರಯನ್ತೌ ಗಚ್ಛಥಃ? ");
INSERT INTO sankan_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ತತಸ್ತಯೋಃ ಕ್ಲಿಯಪಾನಾಮಾ ಪ್ರತ್ಯುವಾಚ ಯಿರೂಶಾಲಮಪುರೇಽಧುನಾ ಯಾನ್ಯಘಟನ್ತ ತ್ವಂ ಕೇವಲವಿದೇಶೀ ಕಿಂ ತದ್ವೃತ್ತಾನ್ತಂ ನ ಜಾನಾಸಿ? ");
INSERT INTO sankan_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ಸ ಪಪ್ರಚ್ಛ ಕಾ ಘಟನಾಃ? ತದಾ ತೌ ವಕ್ತುಮಾರೇಭಾತೇ ಯೀಶುನಾಮಾ ಯೋ ನಾಸರತೀಯೋ ಭವಿಷ್ಯದ್ವಾದೀ ಈಶ್ವರಸ್ಯ ಮಾನುಷಾಣಾಞ್ಚ ಸಾಕ್ಷಾತ್ ವಾಕ್ಯೇ ಕರ್ಮ್ಮಣಿ ಚ ಶಕ್ತಿಮಾನಾಸೀತ್ ");
INSERT INTO sankan_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ತಮ್ ಅಸ್ಮಾಕಂ ಪ್ರಧಾನಯಾಜಕಾ ವಿಚಾರಕಾಶ್ಚ ಕೇನಾಪಿ ಪ್ರಕಾರೇಣ ಕ್ರುಶೇ ವಿದ್ಧ್ವಾ ತಸ್ಯ ಪ್ರಾಣಾನನಾಶಯನ್ ತದೀಯಾ ಘಟನಾಃ; ");
INSERT INTO sankan_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","ಕಿನ್ತು ಯ ಇಸ್ರಾಯೇಲೀಯಲೋಕಾನ್ ಉದ್ಧಾರಯಿಷ್ಯತಿ ಸ ಏವಾಯಮ್ ಇತ್ಯಾಶಾಸ್ಮಾಭಿಃ ಕೃತಾ| ತದ್ಯಥಾ ತಥಾಸ್ತು ತಸ್ಯಾ ಘಟನಾಯಾ ಅದ್ಯ ದಿನತ್ರಯಂ ಗತಂ| ");
INSERT INTO sankan_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ಅಧಿಕನ್ತ್ವಸ್ಮಾಕಂ ಸಙ್ಗಿನೀನಾಂ ಕಿಯತ್ಸ್ತ್ರೀಣಾಂ ಮುಖೇಭ್ಯೋಽಸಮ್ಭವವಾಕ್ಯಮಿದಂ ಶ್ರುತಂ; ");
INSERT INTO sankan_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ತಾಃ ಪ್ರತ್ಯೂಷೇ ಶ್ಮಶಾನಂ ಗತ್ವಾ ತತ್ರ ತಸ್ಯ ದೇಹಮ್ ಅಪ್ರಾಪ್ಯ ವ್ಯಾಘುಟ್ಯೇತ್ವಾ ಪ್ರೋಕ್ತವತ್ಯಃ ಸ್ವರ್ಗೀಸದೂತೌ ದೃಷ್ಟಾವಸ್ಮಾಭಿಸ್ತೌ ಚಾವಾದಿಷ್ಟಾಂ ಸ ಜೀವಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ತತೋಸ್ಮಾಕಂ ಕೈಶ್ಚಿತ್ ಶ್ಮಶಾನಮಗಮ್ಯತ ತೇಽಪಿ ಸ್ತ್ರೀಣಾಂ ವಾಕ್ಯಾನುರೂಪಂ ದೃಷ್ಟವನ್ತಃ ಕಿನ್ತು ತಂ ನಾಪಶ್ಯನ್| ");
INSERT INTO sankan_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ತದಾ ಸ ತಾವುವಾಚ, ಹೇ ಅಬೋಧೌ ಹೇ ಭವಿಷ್ಯದ್ವಾದಿಭಿರುಕ್ತವಾಕ್ಯಂ ಪ್ರತ್ಯೇತುಂ ವಿಲಮ್ಬಮಾನೌ; ");
INSERT INTO sankan_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ಏತತ್ಸರ್ವ್ವದುಃಖಂ ಭುಕ್ತ್ವಾ ಸ್ವಭೂತಿಪ್ರಾಪ್ತಿಃ ಕಿಂ ಖ್ರೀಷ್ಟಸ್ಯ ನ ನ್ಯಾಯ್ಯಾ? ");
INSERT INTO sankan_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ತತಃ ಸ ಮೂಸಾಗ್ರನ್ಥಮಾರಭ್ಯ ಸರ್ವ್ವಭವಿಷ್ಯದ್ವಾದಿನಾಂ ಸರ್ವ್ವಶಾಸ್ತ್ರೇ ಸ್ವಸ್ಮಿನ್ ಲಿಖಿತಾಖ್ಯಾನಾಭಿಪ್ರಾಯಂ ಬೋಧಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","ಅಥ ಗಮ್ಯಗ್ರಾಮಾಭ್ಯರ್ಣಂ ಪ್ರಾಪ್ಯ ತೇನಾಗ್ರೇ ಗಮನಲಕ್ಷಣೇ ದರ್ಶಿತೇ ");
INSERT INTO sankan_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ತೌ ಸಾಧಯಿತ್ವಾವದತಾಂ ಸಹಾವಾಭ್ಯಾಂ ತಿಷ್ಠ ದಿನೇ ಗತೇ ಸತಿ ರಾತ್ರಿರಭೂತ್; ತತಃ ಸ ತಾಭ್ಯಾಂ ಸಾರ್ದ್ಧಂ ಸ್ಥಾತುಂ ಗೃಹಂ ಯಯೌ| ");
INSERT INTO sankan_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","ಪಶ್ಚಾದ್ಭೋಜನೋಪವೇಶಕಾಲೇ ಸ ಪೂಪಂ ಗೃಹೀತ್ವಾ ಈಶ್ವರಗುಣಾನ್ ಜಗಾದ ತಞ್ಚ ಭಂಕ್ತ್ವಾ ತಾಭ್ಯಾಂ ದದೌ| ");
INSERT INTO sankan_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ತದಾ ತಯೋ ರ್ದೃಷ್ಟೌ ಪ್ರಸನ್ನಾಯಾಂ ತಂ ಪ್ರತ್ಯಭಿಜ್ಞತುಃ ಕಿನ್ತು ಸ ತಯೋಃ ಸಾಕ್ಷಾದನ್ತರ್ದಧೇ| ");
INSERT INTO sankan_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ತತಸ್ತೌ ಮಿಥೋಭಿಧಾತುಮ್ ಆರಬ್ಧವನ್ತೌ ಗಮನಕಾಲೇ ಯದಾ ಕಥಾಮಕಥಯತ್ ಶಾಸ್ತ್ರಾರ್ಥಞ್ಚಬೋಧಯತ್ ತದಾವಯೋ ರ್ಬುದ್ಧಿಃ ಕಿಂ ನ ಪ್ರಾಜ್ವಲತ್? ");
INSERT INTO sankan_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","ತೌ ತತ್ಕ್ಷಣಾದುತ್ಥಾಯ ಯಿರೂಶಾಲಮಪುರಂ ಪ್ರತ್ಯಾಯಯತುಃ, ತತ್ಸ್ಥಾನೇ ಶಿಷ್ಯಾಣಾಮ್ ಏಕಾದಶಾನಾಂ ಸಙ್ಗಿನಾಞ್ಚ ದರ್ಶನಂ ಜಾತಂ| ");
INSERT INTO sankan_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ತೇ ಪ್ರೋಚುಃ ಪ್ರಭುರುದತಿಷ್ಠದ್ ಇತಿ ಸತ್ಯಂ ಶಿಮೋನೇ ದರ್ಶನಮದಾಚ್ಚ| ");
INSERT INTO sankan_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","ತತಃ ಪಥಃ ಸರ್ವ್ವಘಟನಾಯಾಃ ಪೂಪಭಞ್ಜನೇನ ತತ್ಪರಿಚಯಸ್ಯ ಚ ಸರ್ವ್ವವೃತ್ತಾನ್ತಂ ತೌ ವಕ್ತುಮಾರೇಭಾತೇ| ");
INSERT INTO sankan_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ಇತ್ಥಂ ತೇ ಪರಸ್ಪರಂ ವದನ್ತಿ ತತ್ಕಾಲೇ ಯೀಶುಃ ಸ್ವಯಂ ತೇಷಾಂ ಮಧ್ಯ ಪ್ರೋತ್ಥಯ ಯುಷ್ಮಾಕಂ ಕಲ್ಯಾಣಂ ಭೂಯಾದ್ ಇತ್ಯುವಾಚ, ");
INSERT INTO sankan_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ಕಿನ್ತು ಭೂತಂ ಪಶ್ಯಾಮ ಇತ್ಯನುಮಾಯ ತೇ ಸಮುದ್ವಿವಿಜಿರೇ ತ್ರೇಷುಶ್ಚ| ");
INSERT INTO sankan_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","ಸ ಉವಾಚ, ಕುತೋ ದುಃಖಿತಾ ಭವಥ? ಯುಷ್ಮಾಕಂ ಮನಃಸು ಸನ್ದೇಹ ಉದೇತಿ ಚ ಕುತಃ? ");
INSERT INTO sankan_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ಏಷೋಹಂ, ಮಮ ಕರೌ ಪಶ್ಯತ ವರಂ ಸ್ಪೃಷ್ಟ್ವಾ ಪಶ್ಯತ, ಮಮ ಯಾದೃಶಾನಿ ಪಶ್ಯಥ ತಾದೃಶಾನಿ ಭೂತಸ್ಯ ಮಾಂಸಾಸ್ಥೀನಿ ನ ಸನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ಇತ್ಯುಕ್ತ್ವಾ ಸ ಹಸ್ತಪಾದಾನ್ ದರ್ಶಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ತೇಽಸಮ್ಭವಂ ಜ್ಞಾತ್ವಾ ಸಾನನ್ದಾ ನ ಪ್ರತ್ಯಯನ್| ತತಃ ಸ ತಾನ್ ಪಪ್ರಚ್ಛ, ಅತ್ರ ಯುಷ್ಮಾಕಂ ಸಮೀಪೇ ಖಾದ್ಯಂ ಕಿಞ್ಚಿದಸ್ತಿ? ");
INSERT INTO sankan_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ತತಸ್ತೇ ಕಿಯದ್ದಗ್ಧಮತ್ಸ್ಯಂ ಮಧು ಚ ದದುಃ ");
INSERT INTO sankan_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ಸ ತದಾದಾಯ ತೇಷಾಂ ಸಾಕ್ಷಾದ್ ಬುಭುಜೇ ");
INSERT INTO sankan_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","ಕಥಯಾಮಾಸ ಚ ಮೂಸಾವ್ಯವಸ್ಥಾಯಾಂ ಭವಿಷ್ಯದ್ವಾದಿನಾಂ ಗ್ರನ್ಥೇಷು ಗೀತಪುಸ್ತಕೇ ಚ ಮಯಿ ಯಾನಿ ಸರ್ವ್ವಾಣಿ ವಚನಾನಿ ಲಿಖಿತಾನಿ ತದನುರೂಪಾಣಿ ಘಟಿಷ್ಯನ್ತೇ ಯುಷ್ಮಾಭಿಃ ಸಾರ್ದ್ಧಂ ಸ್ಥಿತ್ವಾಹಂ ಯದೇತದ್ವಾಕ್ಯಮ್ ಅವದಂ ತದಿದಾನೀಂ ಪ್ರತ್ಯಕ್ಷಮಭೂತ್| ");
INSERT INTO sankan_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","ಅಥ ತೇಭ್ಯಃ ಶಾಸ್ತ್ರಬೋಧಾಧಿಕಾರಂ ದತ್ವಾವದತ್, ");
INSERT INTO sankan_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ಖ್ರೀಷ್ಟೇನೇತ್ಥಂ ಮೃತಿಯಾತನಾ ಭೋಕ್ತವ್ಯಾ ತೃತೀಯದಿನೇ ಚ ಶ್ಮಶಾನಾದುತ್ಥಾತವ್ಯಞ್ಚೇತಿ ಲಿಪಿರಸ್ತಿ; ");
INSERT INTO sankan_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ತನ್ನಾಮ್ನಾ ಯಿರೂಶಾಲಮಮಾರಭ್ಯ ಸರ್ವ್ವದೇಶೇ ಮನಃಪರಾವರ್ತ್ತನಸ್ಯ ಪಾಪಮೋಚನಸ್ಯ ಚ ಸುಸಂವಾದಃ ಪ್ರಚಾರಯಿತವ್ಯಃ, ");
INSERT INTO sankan_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ಏಷು ಸರ್ವ್ವೇಷು ಯೂಯಂ ಸಾಕ್ಷಿಣಃ| ");
INSERT INTO sankan_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ಅಪರಞ್ಚ ಪಶ್ಯತ ಪಿತ್ರಾ ಯತ್ ಪ್ರತಿಜ್ಞಾತಂ ತತ್ ಪ್ರೇಷಯಿಷ್ಯಾಮಿ, ಅತಏವ ಯಾವತ್ಕಾಲಂ ಯೂಯಂ ಸ್ವರ್ಗೀಯಾಂ ಶಕ್ತಿಂ ನ ಪ್ರಾಪ್ಸ್ಯಥ ತಾವತ್ಕಾಲಂ ಯಿರೂಶಾಲಮ್ನಗರೇ ತಿಷ್ಠತ| ");
INSERT INTO sankan_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","ಅಥ ಸ ತಾನ್ ಬೈಥನೀಯಾಪರ್ಯ್ಯನ್ತಂ ನೀತ್ವಾ ಹಸ್ತಾವುತ್ತೋಲ್ಯ ಆಶಿಷ ವಕ್ತುಮಾರೇಭೇ ");
INSERT INTO sankan_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ಆಶಿಷಂ ವದನ್ನೇವ ಚ ತೇಭ್ಯಃ ಪೃಥಗ್ ಭೂತ್ವಾ ಸ್ವರ್ಗಾಯ ನೀತೋಽಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","ತದಾ ತೇ ತಂ ಭಜಮಾನಾ ಮಹಾನನ್ದೇನ ಯಿರೂಶಾಲಮಂ ಪ್ರತ್ಯಾಜಗ್ಮುಃ| ");
INSERT INTO sankan_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ತತೋ ನಿರನ್ತರಂ ಮನ್ದಿರೇ ತಿಷ್ಠನ್ತ ಈಶ್ವರಸ್ಯ ಪ್ರಶಂಸಾಂ ಧನ್ಯವಾದಞ್ಚ ಕರ್ತ್ತಮ್ ಆರೇಭಿರೇ| ಇತಿ||");
INSERT INTO sankan_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ಆದೌ ವಾದ ಆಸೀತ್ ಸ ಚ ವಾದ ಈಶ್ವರೇಣ ಸಾರ್ಧಮಾಸೀತ್ ಸ ವಾದಃ ಸ್ವಯಮೀಶ್ವರ ಏವ| ");
INSERT INTO sankan_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ಸ ಆದಾವೀಶ್ವರೇಣ ಸಹಾಸೀತ್| ");
INSERT INTO sankan_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ತೇನ ಸರ್ವ್ವಂ ವಸ್ತು ಸಸೃಜೇ ಸರ್ವ್ವೇಷು ಸೃಷ್ಟವಸ್ತುಷು ಕಿಮಪಿ ವಸ್ತು ತೇನಾಸೃಷ್ಟಂ ನಾಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ಸ ಜೀವನಸ್ಯಾಕಾರಃ, ತಚ್ಚ ಜೀವನಂ ಮನುಷ್ಯಾಣಾಂ ಜ್ಯೋತಿಃ ");
INSERT INTO sankan_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","ತಜ್ಜ್ಯೋತಿರನ್ಧಕಾರೇ ಪ್ರಚಕಾಶೇ ಕಿನ್ತ್ವನ್ಧಕಾರಸ್ತನ್ನ ಜಗ್ರಾಹ| ");
INSERT INTO sankan_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","ಯೋಹನ್ ನಾಮಕ ಏಕೋ ಮನುಜ ಈಶ್ವರೇಣ ಪ್ರೇಷಯಾಞ್ಚಕ್ರೇ| ");
INSERT INTO sankan_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ತದ್ವಾರಾ ಯಥಾ ಸರ್ವ್ವೇ ವಿಶ್ವಸನ್ತಿ ತದರ್ಥಂ ಸ ತಜ್ಜ್ಯೋತಿಷಿ ಪ್ರಮಾಣಂ ದಾತುಂ ಸಾಕ್ಷಿಸ್ವರೂಪೋ ಭೂತ್ವಾಗಮತ್, ");
INSERT INTO sankan_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ಸ ಸ್ವಯಂ ತಜ್ಜ್ಯೋತಿ ರ್ನ ಕಿನ್ತು ತಜ್ಜ್ಯೋತಿಷಿ ಪ್ರಮಾಣಂ ದಾತುಮಾಗಮತ್| ");
INSERT INTO sankan_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ಜಗತ್ಯಾಗತ್ಯ ಯಃ ಸರ್ವ್ವಮನುಜೇಭ್ಯೋ ದೀಪ್ತಿಂ ದದಾತಿ ತದೇವ ಸತ್ಯಜ್ಯೋತಿಃ| ");
INSERT INTO sankan_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ಸ ಯಜ್ಜಗದಸೃಜತ್ ತನ್ಮದ್ಯ ಏವ ಸ ಆಸೀತ್ ಕಿನ್ತು ಜಗತೋ ಲೋಕಾಸ್ತಂ ನಾಜಾನನ್| ");
INSERT INTO sankan_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","ನಿಜಾಧಿಕಾರಂ ಸ ಆಗಚ್ಛತ್ ಕಿನ್ತು ಪ್ರಜಾಸ್ತಂ ನಾಗೃಹ್ಲನ್| ");
INSERT INTO sankan_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","ತಥಾಪಿ ಯೇ ಯೇ ತಮಗೃಹ್ಲನ್ ಅರ್ಥಾತ್ ತಸ್ಯ ನಾಮ್ನಿ ವ್ಯಶ್ವಸನ್ ತೇಭ್ಯ ಈಶ್ವರಸ್ಯ ಪುತ್ರಾ ಭವಿತುಮ್ ಅಧಿಕಾರಮ್ ಅದದಾತ್| ");
INSERT INTO sankan_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ತೇಷಾಂ ಜನಿಃ ಶೋಣಿತಾನ್ನ ಶಾರೀರಿಕಾಭಿಲಾಷಾನ್ನ ಮಾನವಾನಾಮಿಚ್ಛಾತೋ ನ ಕಿನ್ತ್ವೀಶ್ವರಾದಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","ಸ ವಾದೋ ಮನುಷ್ಯರೂಪೇಣಾವತೀರ್ಯ್ಯ ಸತ್ಯತಾನುಗ್ರಹಾಭ್ಯಾಂ ಪರಿಪೂರ್ಣಃ ಸನ್ ಸಾರ್ಧಮ್ ಅಸ್ಮಾಭಿ ರ್ನ್ಯವಸತ್ ತತಃ ಪಿತುರದ್ವಿತೀಯಪುತ್ರಸ್ಯ ಯೋಗ್ಯೋ ಯೋ ಮಹಿಮಾ ತಂ ಮಹಿಮಾನಂ ತಸ್ಯಾಪಶ್ಯಾಮ| ");
INSERT INTO sankan_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ತತೋ ಯೋಹನಪಿ ಪ್ರಚಾರ್ಯ್ಯ ಸಾಕ್ಷ್ಯಮಿದಂ ದತ್ತವಾನ್ ಯೋ ಮಮ ಪಶ್ಚಾದ್ ಆಗಮಿಷ್ಯತಿ ಸ ಮತ್ತೋ ಗುರುತರಃ; ಯತೋ ಮತ್ಪೂರ್ವ್ವಂ ಸ ವಿದ್ಯಮಾನ ಆಸೀತ್; ಯದರ್ಥಮ್ ಅಹಂ ಸಾಕ್ಷ್ಯಮಿದಮ್ ಅದಾಂ ಸ ಏಷಃ| ");
INSERT INTO sankan_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ಅಪರಞ್ಚ ತಸ್ಯ ಪೂರ್ಣತಾಯಾ ವಯಂ ಸರ್ವ್ವೇ ಕ್ರಮಶಃ ಕ್ರಮಶೋನುಗ್ರಹಂ ಪ್ರಾಪ್ತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","ಮೂಸಾದ್ವಾರಾ ವ್ಯವಸ್ಥಾ ದತ್ತಾ ಕಿನ್ತ್ವನುಗ್ರಹಃ ಸತ್ಯತ್ವಞ್ಚ ಯೀಶುಖ್ರೀಷ್ಟದ್ವಾರಾ ಸಮುಪಾತಿಷ್ಠತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","ಕೋಪಿ ಮನುಜ ಈಶ್ವರಂ ಕದಾಪಿ ನಾಪಶ್ಯತ್ ಕಿನ್ತು ಪಿತುಃ ಕ್ರೋಡಸ್ಥೋಽದ್ವಿತೀಯಃ ಪುತ್ರಸ್ತಂ ಪ್ರಕಾಶಯತ್| ");
INSERT INTO sankan_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","ತ್ವಂ ಕಃ? ಇತಿ ವಾಕ್ಯಂ ಪ್ರೇಷ್ಟುಂ ಯದಾ ಯಿಹೂದೀಯಲೋಕಾ ಯಾಜಕಾನ್ ಲೇವಿಲೋಕಾಂಶ್ಚ ಯಿರೂಶಾಲಮೋ ಯೋಹನಃ ಸಮೀಪೇ ಪ್ರೇಷಯಾಮಾಸುಃ, ");
INSERT INTO sankan_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ತದಾ ಸ ಸ್ವೀಕೃತವಾನ್ ನಾಪಹ್ನೂತವಾನ್ ನಾಹಮ್ ಅಭಿಷಿಕ್ತ ಇತ್ಯಙ್ಗೀಕೃತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","ತದಾ ತೇಽಪೃಚ್ಛನ್ ತರ್ಹಿ ಕೋ ಭವಾನ್? ಕಿಂ ಏಲಿಯಃ? ಸೋವದತ್ ನ; ತತಸ್ತೇಽಪೃಚ್ಛನ್ ತರ್ಹಿ ಭವಾನ್ ಸ ಭವಿಷ್ಯದ್ವಾದೀ? ಸೋವದತ್ ನಾಹಂ ಸಃ| ");
INSERT INTO sankan_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","ತದಾ ತೇಽಪೃಚ್ಛನ್ ತರ್ಹಿ ಭವಾನ್ ಕಃ? ವಯಂ ಗತ್ವಾ ಪ್ರೇರಕಾನ್ ತ್ವಯಿ ಕಿಂ ವಕ್ಷ್ಯಾಮಃ? ಸ್ವಸ್ಮಿನ್ ಕಿಂ ವದಸಿ? ");
INSERT INTO sankan_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ತದಾ ಸೋವದತ್| ಪರಮೇಶಸ್ಯ ಪನ್ಥಾನಂ ಪರಿಷ್ಕುರುತ ಸರ್ವ್ವತಃ| ಇತೀದಂ ಪ್ರಾನ್ತರೇ ವಾಕ್ಯಂ ವದತಃ ಕಸ್ಯಚಿದ್ರವಃ| ಕಥಾಮಿಮಾಂ ಯಸ್ಮಿನ್ ಯಿಶಯಿಯೋ ಭವಿಷ್ಯದ್ವಾದೀ ಲಿಖಿತವಾನ್ ಸೋಹಮ್| ");
INSERT INTO sankan_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ಯೇ ಪ್ರೇಷಿತಾಸ್ತೇ ಫಿರೂಶಿಲೋಕಾಃ| ");
INSERT INTO sankan_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ತದಾ ತೇಽಪೃಚ್ಛನ್ ಯದಿ ನಾಭಿಷಿಕ್ತೋಸಿ ಏಲಿಯೋಸಿ ನ ಸ ಭವಿಷ್ಯದ್ವಾದ್ಯಪಿ ನಾಸಿ ಚ, ತರ್ಹಿ ಲೋಕಾನ್ ಮಜ್ಜಯಸಿ ಕುತಃ? ");
INSERT INTO sankan_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ತತೋ ಯೋಹನ್ ಪ್ರತ್ಯವೋಚತ್, ತೋಯೇಽಹಂ ಮಜ್ಜಯಾಮೀತಿ ಸತ್ಯಂ ಕಿನ್ತು ಯಂ ಯೂಯಂ ನ ಜಾನೀಥ ತಾದೃಶ ಏಕೋ ಜನೋ ಯುಷ್ಮಾಕಂ ಮಧ್ಯ ಉಪತಿಷ್ಠತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ಸ ಮತ್ಪಶ್ಚಾದ್ ಆಗತೋಪಿ ಮತ್ಪೂರ್ವ್ವಂ ವರ್ತ್ತಮಾನ ಆಸೀತ್ ತಸ್ಯ ಪಾದುಕಾಬನ್ಧನಂ ಮೋಚಯಿತುಮಪಿ ನಾಹಂ ಯೋಗ್ಯೋಸ್ಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ಯರ್ದ್ದನನದ್ಯಾಃ ಪಾರಸ್ಥಬೈಥಬಾರಾಯಾಂ ಯಸ್ಮಿನ್ಸ್ಥಾನೇ ಯೋಹನಮಜ್ಜಯತ್ ತಸ್ಮಿನ ಸ್ಥಾನೇ ಸರ್ವ್ವಮೇತದ್ ಅಘಟತ| ");
INSERT INTO sankan_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","ಪರೇಽಹನಿ ಯೋಹನ್ ಸ್ವನಿಕಟಮಾಗಚ್ಛನ್ತಂ ಯಿಶುಂ ವಿಲೋಕ್ಯ ಪ್ರಾವೋಚತ್ ಜಗತಃ ಪಾಪಮೋಚಕಮ್ ಈಶ್ವರಸ್ಯ ಮೇಷಶಾವಕಂ ಪಶ್ಯತ| ");
INSERT INTO sankan_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","ಯೋ ಮಮ ಪಶ್ಚಾದಾಗಮಿಷ್ಯತಿ ಸ ಮತ್ತೋ ಗುರುತರಃ, ಯತೋ ಹೇತೋರ್ಮತ್ಪೂರ್ವ್ವಂ ಸೋಽವರ್ತ್ತತ ಯಸ್ಮಿನ್ನಹಂ ಕಥಾಮಿಮಾಂ ಕಥಿತವಾನ್ ಸ ಏವಾಯಂ| ");
INSERT INTO sankan_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","ಅಪರಂ ನಾಹಮೇನಂ ಪ್ರತ್ಯಭಿಜ್ಞಾತವಾನ್ ಕಿನ್ತು ಇಸ್ರಾಯೇಲ್ಲೋಕಾ ಏನಂ ಯಥಾ ಪರಿಚಿನ್ವನ್ತಿ ತದಭಿಪ್ರಾಯೇಣಾಹಂ ಜಲೇ ಮಜ್ಜಯಿತುಮಾಗಚ್ಛಮ್| ");
INSERT INTO sankan_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","ಪುನಶ್ಚ ಯೋಹನಪರಮೇಕಂ ಪ್ರಮಾಣಂ ದತ್ವಾ ಕಥಿತವಾನ್ ವಿಹಾಯಸಃ ಕಪೋತವದ್ ಅವತರನ್ತಮಾತ್ಮಾನಮ್ ಅಸ್ಯೋಪರ್ಯ್ಯವತಿಷ್ಠನ್ತಂ ಚ ದೃಷ್ಟವಾನಹಮ್| ");
INSERT INTO sankan_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","ನಾಹಮೇನಂ ಪ್ರತ್ಯಭಿಜ್ಞಾತವಾನ್ ಇತಿ ಸತ್ಯಂ ಕಿನ್ತು ಯೋ ಜಲೇ ಮಜ್ಜಯಿತುಂ ಮಾಂ ಪ್ರೈರಯತ್ ಸ ಏವೇಮಾಂ ಕಥಾಮಕಥಯತ್ ಯಸ್ಯೋಪರ್ಯ್ಯಾತ್ಮಾನಮ್ ಅವತರನ್ತಮ್ ಅವತಿಷ್ಠನ್ತಞ್ಚ ದ್ರಕ್ಷಯಸಿ ಸಏವ ಪವಿತ್ರೇ ಆತ್ಮನಿ ಮಜ್ಜಯಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","ಅವಸ್ತನ್ನಿರೀಕ್ಷ್ಯಾಯಮ್ ಈಶ್ವರಸ್ಯ ತನಯ ಇತಿ ಪ್ರಮಾಣಂ ದದಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","ಪರೇಽಹನಿ ಯೋಹನ್ ದ್ವಾಭ್ಯಾಂ ಶಿಷ್ಯಾಭ್ಯಾಂ ಸಾರ್ದ್ಧೇಂ ತಿಷ್ಠನ್ ");
INSERT INTO sankan_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ಯಿಶುಂ ಗಚ್ಛನ್ತಂ ವಿಲೋಕ್ಯ ಗದಿತವಾನ್, ಈಶ್ವರಸ್ಯ ಮೇಷಶಾವಕಂ ಪಶ್ಯತಂ| ");
INSERT INTO sankan_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ಇಮಾಂ ಕಥಾಂ ಶ್ರುತ್ವಾ ದ್ವೌ ಶಿಷ್ಯೌ ಯೀಶೋಃ ಪಶ್ಚಾದ್ ಈಯತುಃ| ");
INSERT INTO sankan_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ತತೋ ಯೀಶುಃ ಪರಾವೃತ್ಯ ತೌ ಪಶ್ಚಾದ್ ಆಗಚ್ಛನ್ತೌ ದೃಷ್ಟ್ವಾ ಪೃಷ್ಟವಾನ್ ಯುವಾಂ ಕಿಂ ಗವೇಶಯಥಃ? ತಾವಪೃಚ್ಛತಾಂ ಹೇ ರಬ್ಬಿ ಅರ್ಥಾತ್ ಹೇ ಗುರೋ ಭವಾನ್ ಕುತ್ರ ತಿಷ್ಠತಿ? ");
INSERT INTO sankan_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ತತಃ ಸೋವಾದಿತ್ ಏತ್ಯ ಪಶ್ಯತಂ| ತತೋ ದಿವಸಸ್ಯ ತೃತೀಯಪ್ರಹರಸ್ಯ ಗತತ್ವಾತ್ ತೌ ತದ್ದಿನಂ ತಸ್ಯ ಸಙ್ಗೇಽಸ್ಥಾತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ಯೌ ದ್ವೌ ಯೋಹನೋ ವಾಕ್ಯಂ ಶ್ರುತ್ವಾ ಯಿಶೋಃ ಪಶ್ಚಾದ್ ಆಗಮತಾಂ ತಯೋಃ ಶಿಮೋನ್ಪಿತರಸ್ಯ ಭ್ರಾತಾ ಆನ್ದ್ರಿಯಃ ");
INSERT INTO sankan_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ಸ ಇತ್ವಾ ಪ್ರಥಮಂ ನಿಜಸೋದರಂ ಶಿಮೋನಂ ಸಾಕ್ಷಾತ್ಪ್ರಾಪ್ಯ ಕಥಿತವಾನ್ ವಯಂ ಖ್ರೀಷ್ಟಮ್ ಅರ್ಥಾತ್ ಅಭಿಷಿಕ್ತಪುರುಷಂ ಸಾಕ್ಷಾತ್ಕೃತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","ಪಶ್ಚಾತ್ ಸ ತಂ ಯಿಶೋಃ ಸಮೀಪಮ್ ಆನಯತ್| ತದಾ ಯೀಶುಸ್ತಂ ದೃಷ್ಟ್ವಾವದತ್ ತ್ವಂ ಯೂನಸಃ ಪುತ್ರಃ ಶಿಮೋನ್ ಕಿನ್ತು ತ್ವನ್ನಾಮಧೇಯಂ ಕೈಫಾಃ ವಾ ಪಿತರಃ ಅರ್ಥಾತ್ ಪ್ರಸ್ತರೋ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","ಪರೇಽಹನಿ ಯೀಶೌ ಗಾಲೀಲಂ ಗನ್ತುಂ ನಿಶ್ಚಿತಚೇತಸಿ ಸತಿ ಫಿಲಿಪನಾಮಾನಂ ಜನಂ ಸಾಕ್ಷಾತ್ಪ್ರಾಪ್ಯಾವೋಚತ್ ಮಮ ಪಶ್ಚಾದ್ ಆಗಚ್ಛ| ");
INSERT INTO sankan_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ಬೈತ್ಸೈದಾನಾಮ್ನಿ ಯಸ್ಮಿನ್ ಗ್ರಾಮೇ ಪಿತರಾನ್ದ್ರಿಯಯೋರ್ವಾಸ ಆಸೀತ್ ತಸ್ಮಿನ್ ಗ್ರಾಮೇ ತಸ್ಯ ಫಿಲಿಪಸ್ಯ ವಸತಿರಾಸೀತ್| ");
INSERT INTO sankan_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ಪಶ್ಚಾತ್ ಫಿಲಿಪೋ ನಿಥನೇಲಂ ಸಾಕ್ಷಾತ್ಪ್ರಾಪ್ಯಾವದತ್ ಮೂಸಾ ವ್ಯವಸ್ಥಾ ಗ್ರನ್ಥೇ ಭವಿಷ್ಯದ್ವಾದಿನಾಂ ಗ್ರನ್ಥೇಷು ಚ ಯಸ್ಯಾಖ್ಯಾನಂ ಲಿಖಿತಮಾಸ್ತೇ ತಂ ಯೂಷಫಃ ಪುತ್ರಂ ನಾಸರತೀಯಂ ಯೀಶುಂ ಸಾಕ್ಷಾದ್ ಅಕಾರ್ಷ್ಮ ವಯಂ| ");
INSERT INTO sankan_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","ತದಾ ನಿಥನೇಲ್ ಕಥಿತವಾನ್ ನಾಸರನ್ನಗರಾತ ಕಿಂ ಕಶ್ಚಿದುತ್ತಮ ಉತ್ಪನ್ತುಂ ಶಕ್ನೋತಿ? ತತಃ ಫಿಲಿಪೋ ಽವೋಚತ್ ಏತ್ಯ ಪಶ್ಯ| ");
INSERT INTO sankan_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ಅಪರಞ್ಚ ಯೀಶುಃ ಸ್ವಸ್ಯ ಸಮೀಪಂ ತಮ್ ಆಗಚ್ಛನ್ತಂ ದೃಷ್ಟ್ವಾ ವ್ಯಾಹೃತವಾನ್, ಪಶ್ಯಾಯಂ ನಿಷ್ಕಪಟಃ ಸತ್ಯ ಇಸ್ರಾಯೇಲ್ಲೋಕಃ| ");
INSERT INTO sankan_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","ತತಃ ಸೋವದದ್, ಭವಾನ್ ಮಾಂ ಕಥಂ ಪ್ರತ್ಯಭಿಜಾನಾತಿ? ಯೀಶುರವಾದೀತ್ ಫಿಲಿಪಸ್ಯ ಆಹ್ವಾನಾತ್ ಪೂರ್ವ್ವಂ ಯದಾ ತ್ವಮುಡುಮ್ಬರಸ್ಯ ತರೋರ್ಮೂಲೇಽಸ್ಥಾಸ್ತದಾ ತ್ವಾಮದರ್ಶಮ್| ");
INSERT INTO sankan_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","ನಿಥನೇಲ್ ಅಚಕಥತ್, ಹೇ ಗುರೋ ಭವಾನ್ ನಿತಾನ್ತಮ್ ಈಶ್ವರಸ್ಯ ಪುತ್ರೋಸಿ, ಭವಾನ್ ಇಸ್ರಾಯೇಲ್ವಂಶಸ್ಯ ರಾಜಾ| ");
INSERT INTO sankan_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ತತೋ ಯೀಶು ರ್ವ್ಯಾಹರತ್, ತ್ವಾಮುಡುಮ್ಬರಸ್ಯ ಪಾದಪಸ್ಯ ಮೂಲೇ ದೃಷ್ಟವಾನಾಹಂ ಮಮೈತಸ್ಮಾದ್ವಾಕ್ಯಾತ್ ಕಿಂ ತ್ವಂ ವ್ಯಶ್ವಸೀಃ? ಏತಸ್ಮಾದಪ್ಯಾಶ್ಚರ್ಯ್ಯಾಣಿ ಕಾರ್ಯ್ಯಾಣಿ ದ್ರಕ್ಷ್ಯಸಿ| ");
INSERT INTO sankan_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","ಅನ್ಯಚ್ಚಾವಾದೀದ್ ಯುಷ್ಮಾನಹಂ ಯಥಾರ್ಥಂ ವದಾಮಿ, ಇತಃ ಪರಂ ಮೋಚಿತೇ ಮೇಘದ್ವಾರೇ ತಸ್ಮಾನ್ಮನುಜಸೂನುನಾ ಈಶ್ವರಸ್ಯ ದೂತಗಣಮ್ ಅವರೋಹನ್ತಮಾರೋಹನ್ತಞ್ಚ ದ್ರಕ್ಷ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","ಅನನ್ತರಂ ತ್ರುತೀಯದಿವಸೇ ಗಾಲೀಲ್ ಪ್ರದೇಶಿಯೇ ಕಾನ್ನಾನಾಮ್ನಿ ನಗರೇ ವಿವಾಹ ಆಸೀತ್ ತತ್ರ ಚ ಯೀಶೋರ್ಮಾತಾ ತಿಷ್ಠತ್| ");
INSERT INTO sankan_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ತಸ್ಮೈ ವಿವಾಹಾಯ ಯೀಶುಸ್ತಸ್ಯ ಶಿಷ್ಯಾಶ್ಚ ನಿಮನ್ತ್ರಿತಾ ಆಸನ್| ");
INSERT INTO sankan_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ತದನನ್ತರಂ ದ್ರಾಕ್ಷಾರಸಸ್ಯ ನ್ಯೂನತ್ವಾದ್ ಯೀಶೋರ್ಮಾತಾ ತಮವದತ್ ಏತೇಷಾಂ ದ್ರಾಕ್ಷಾರಸೋ ನಾಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","ತದಾ ಸ ತಾಮವೋಚತ್ ಹೇ ನಾರಿ ಮಯಾ ಸಹ ತವ ಕಿಂ ಕಾರ್ಯ್ಯಂ? ಮಮ ಸಮಯ ಇದಾನೀಂ ನೋಪತಿಷ್ಠತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ತತಸ್ತಸ್ಯ ಮಾತಾ ದಾಸಾನವೋಚದ್ ಅಯಂ ಯದ್ ವದತಿ ತದೇವ ಕುರುತ| ");
INSERT INTO sankan_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ತಸ್ಮಿನ್ ಸ್ಥಾನೇ ಯಿಹೂದೀಯಾನಾಂ ಶುಚಿತ್ವಕರಣವ್ಯವಹಾರಾನುಸಾರೇಣಾಢಕೈಕಜಲಧರಾಣಿ ಪಾಷಾಣಮಯಾನಿ ಷಡ್ವೃಹತ್ಪಾತ್ರಾಣಿಆಸನ್| ");
INSERT INTO sankan_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ತದಾ ಯೀಶುಸ್ತಾನ್ ಸರ್ವ್ವಕಲಶಾನ್ ಜಲೈಃ ಪೂರಯಿತುಂ ತಾನಾಜ್ಞಾಪಯತ್, ತತಸ್ತೇ ಸರ್ವ್ವಾನ್ ಕುಮ್ಭಾನಾಕರ್ಣಂ ಜಲೈಃ ಪರ್ಯ್ಯಪೂರಯನ್| ");
INSERT INTO sankan_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ಅಥ ತೇಭ್ಯಃ ಕಿಞ್ಚಿದುತ್ತಾರ್ಯ್ಯ ಭೋಜ್ಯಾಧಿಪಾತೇಃಸಮೀಪಂ ನೇತುಂ ಸ ತಾನಾದಿಶತ್, ತೇ ತದನಯನ್| ");
INSERT INTO sankan_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ಅಪರಞ್ಚ ತಜ್ಜಲಂ ಕಥಂ ದ್ರಾಕ್ಷಾರಸೋಽಭವತ್ ತಜ್ಜಲವಾಹಕಾದಾಸಾ ಜ್ಞಾತುಂ ಶಕ್ತಾಃ ಕಿನ್ತು ತದ್ಭೋಜ್ಯಾಧಿಪೋ ಜ್ಞಾತುಂ ನಾಶಕ್ನೋತ್ ತದವಲಿಹ್ಯ ವರಂ ಸಂಮ್ಬೋದ್ಯಾವದತ, ");
INSERT INTO sankan_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ಲೋಕಾಃ ಪ್ರಥಮಂ ಉತ್ತಮದ್ರಾಕ್ಷಾರಸಂ ದದತಿ ತಷು ಯಥೇಷ್ಟಂ ಪಿತವತ್ಸು ತಸ್ಮಾ ಕಿಞ್ಚಿದನುತ್ತಮಞ್ಚ ದದತಿ ಕಿನ್ತು ತ್ವಮಿದಾನೀಂ ಯಾವತ್ ಉತ್ತಮದ್ರಾಕ್ಷಾರಸಂ ಸ್ಥಾಪಯಸಿ| ");
INSERT INTO sankan_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ಇತ್ಥಂ ಯೀಶುರ್ಗಾಲೀಲಪ್ರದೇಶೇ ಆಶ್ಚರ್ಯ್ಯಕಾರ್ಮ್ಮ ಪ್ರಾರಮ್ಭ ನಿಜಮಹಿಮಾನಂ ಪ್ರಾಕಾಶಯತ್ ತತಃ ಶಿಷ್ಯಾಸ್ತಸ್ಮಿನ್ ವ್ಯಶ್ವಸನ್| ");
INSERT INTO sankan_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ತತಃ ಪರಮ್ ಸ ನಿಜಮಾತ್ರುಭ್ರಾತ್ರುಸ್ಶಿಷ್ಯೈಃ ಸಾರ್ದ್ಧ್ಂ ಕಫರ್ನಾಹೂಮಮ್ ಆಗಮತ್ ಕಿನ್ತು ತತ್ರ ಬಹೂದಿನಾನಿ ಆತಿಷ್ಠತ್| ");
INSERT INTO sankan_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","ತದನನ್ತರಂ ಯಿಹೂದಿಯಾನಾಂ ನಿಸ್ತಾರೋತ್ಸವೇ ನಿಕಟಮಾಗತೇ ಯೀಶು ರ್ಯಿರೂಶಾಲಮ್ ನಗರಮ್ ಆಗಚ್ಛತ್| ");
INSERT INTO sankan_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ತತೋ ಮನ್ದಿರಸ್ಯ ಮಧ್ಯೇ ಗೋಮೇಷಪಾರಾವತವಿಕ್ರಯಿಣೋ ವಾಣಿಜಕ್ಷ್ಚೋಪವಿಷ್ಟಾನ್ ವಿಲೋಕ್ಯ ");
INSERT INTO sankan_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ರಜ್ಜುಭಿಃ ಕಶಾಂ ನಿರ್ಮ್ಮಾಯ ಸರ್ವ್ವಗೋಮೇಷಾದಿಭಿಃ ಸಾರ್ದ್ಧಂ ತಾನ್ ಮನ್ದಿರಾದ್ ದೂರೀಕೃತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ವಣಿಜಾಂ ಮುದ್ರಾದಿ ವಿಕೀರ್ಯ್ಯ ಆಸನಾನಿ ನ್ಯೂಬ್ಜೀಕೃತ್ಯ ಪಾರಾವತವಿಕ್ರಯಿಭ್ಯೋಽಕಥಯದ್ ಅಸ್ಮಾತ್ ಸ್ಥಾನಾತ್ ಸರ್ವಾಣ್ಯೇತಾನಿ ನಯತ, ಮಮ ಪಿತುಗೃಹಂ ವಾಣಿಜ್ಯಗೃಹಂ ಮಾ ಕಾರ್ಷ್ಟ| ");
INSERT INTO sankan_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","ತಸ್ಮಾತ್ ತನ್ಮನ್ದಿರಾರ್ಥ ಉದ್ಯೋಗೋ ಯಸ್ತು ಸ ಗ್ರಸತೀವ ಮಾಮ್| ಇಮಾಂ ಶಾಸ್ತ್ರೀಯಲಿಪಿಂ ಶಿಷ್ಯಾಃಸಮಸ್ಮರನ್| ");
INSERT INTO sankan_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ತತಃ ಪರಮ್ ಯಿಹೂದೀಯಲೋಕಾ ಯೀಷಿಮವದನ್ ತವಮಿದೃಶಕರ್ಮ್ಮಕರಣಾತ್ ಕಿಂ ಚಿಹ್ನಮಸ್ಮಾನ್ ದರ್ಶಯಸಿ? ");
INSERT INTO sankan_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ತತೋ ಯೀಶುಸ್ತಾನವೋಚದ್ ಯುಷ್ಮಾಭಿರೇ ತಸ್ಮಿನ್ ಮನ್ದಿರೇ ನಾಶಿತೇ ದಿನತ್ರಯಮಧ್ಯೇಽಹಂ ತದ್ ಉತ್ಥಾಪಯಿಷ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","ತದಾ ಯಿಹೂದಿಯಾ ವ್ಯಾಹಾರ್ಷುಃ, ಏತಸ್ಯ ಮನ್ದಿರಸ ನಿರ್ಮ್ಮಾಣೇನ ಷಟ್ಚತ್ವಾರಿಂಶದ್ ವತ್ಸರಾ ಗತಾಃ, ತ್ವಂ ಕಿಂ ದಿನತ್ರಯಮಧ್ಯೇ ತದ್ ಉತ್ಥಾಪಯಿಷ್ಯಸಿ? ");
INSERT INTO sankan_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","ಕಿನ್ತು ಸ ನಿಜದೇಹರೂಪಮನ್ದಿರೇ ಕಥಾಮಿಮಾಂ ಕಥಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ಸ ಯದೇತಾದೃಶಂ ಗದಿತವಾನ್ ತಚ್ಛಿಷ್ಯಾಃ ಶ್ಮಶಾನಾತ್ ತದೀಯೋತ್ಥಾನೇ ಸತಿ ಸ್ಮೃತ್ವಾ ಧರ್ಮ್ಮಗ್ರನ್ಥೇ ಯೀಶುನೋಕ್ತಕಥಾಯಾಂ ಚ ವ್ಯಶ್ವಸಿಷುಃ| ");
INSERT INTO sankan_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","ಅನನ್ತರಂ ನಿಸ್ತಾರೋತ್ಸವಸ್ಯ ಭೋಜ್ಯಸಮಯೇ ಯಿರೂಶಾಲಮ್ ನಗರೇ ತತ್ಕ್ರುತಾಶ್ಚರ್ಯ್ಯಕರ್ಮ್ಮಾಣಿ ವಿಲೋಕ್ಯ ಬಹುಭಿಸ್ತಸ್ಯ ನಾಮನಿ ವಿಶ್ವಸಿತಂ| ");
INSERT INTO sankan_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","ಕಿನ್ತು ಸ ತೇಷಾಂ ಕರೇಷು ಸ್ವಂ ನ ಸಮರ್ಪಯತ್, ಯತಃ ಸ ಸರ್ವ್ವಾನವೈತ್| ");
INSERT INTO sankan_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ಸ ಮಾನವೇಷು ಕಸ್ಯಚಿತ್ ಪ್ರಮಾಣಂ ನಾಪೇಕ್ಷತ ಯತೋ ಮನುಜಾನಾಂ ಮಧ್ಯೇ ಯದ್ಯದಸ್ತಿ ತತ್ತತ್ ಸೋಜಾನಾತ್| ");
INSERT INTO sankan_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","ನಿಕದಿಮನಾಮಾ ಯಿಹೂದೀಯಾನಾಮ್ ಅಧಿಪತಿಃ ಫಿರೂಶೀ ಕ್ಷಣದಾಯಾಂ ");
INSERT INTO sankan_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ಯೀಶೌರಭ್ಯರ್ಣಮ್ ಆವ್ರಜ್ಯ ವ್ಯಾಹಾರ್ಷೀತ್, ಹೇ ಗುರೋ ಭವಾನ್ ಈಶ್ವರಾದ್ ಆಗತ್ ಏಕ ಉಪದೇಷ್ಟಾ, ಏತದ್ ಅಸ್ಮಾಭಿರ್ಜ್ಞಾಯತೇ; ಯತೋ ಭವತಾ ಯಾನ್ಯಾಶ್ಚರ್ಯ್ಯಕರ್ಮ್ಮಾಣಿ ಕ್ರಿಯನ್ತೇ ಪರಮೇಶ್ವರಸ್ಯ ಸಾಹಾಯ್ಯಂ ವಿನಾ ಕೇನಾಪಿ ತತ್ತತ್ಕರ್ಮ್ಮಾಣಿ ಕರ್ತ್ತುಂ ನ ಶಕ್ಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","ತದಾ ಯೀಶುರುತ್ತರಂ ದತ್ತವಾನ್ ತವಾಹಂ ಯಥಾರ್ಥತರಂ ವ್ಯಾಹರಾಮಿ ಪುನರ್ಜನ್ಮನಿ ನ ಸತಿ ಕೋಪಿ ಮಾನವ ಈಶ್ವರಸ್ಯ ರಾಜ್ಯಂ ದ್ರಷ್ಟುಂ ನ ಶಕ್ನೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ತತೋ ನಿಕದೀಮಃ ಪ್ರತ್ಯವೋಚತ್ ಮನುಜೋ ವೃದ್ಧೋ ಭೂತ್ವಾ ಕಥಂ ಜನಿಷ್ಯತೇ? ಸ ಕಿಂ ಪುನ ರ್ಮಾತೃರ್ಜಠರಂ ಪ್ರವಿಶ್ಯ ಜನಿತುಂ ಶಕ್ನೋತಿ? ");
INSERT INTO sankan_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","ಯೀಶುರವಾದೀದ್ ಯಥಾರ್ಥತರಮ್ ಅಹಂ ಕಥಯಾಮಿ ಮನುಜೇ ತೋಯಾತ್ಮಭ್ಯಾಂ ಪುನ ರ್ನ ಜಾತೇ ಸ ಈಶ್ವರಸ್ಯ ರಾಜ್ಯಂ ಪ್ರವೇಷ್ಟುಂ ನ ಶಕ್ನೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","ಮಾಂಸಾದ್ ಯತ್ ಜಾಯತೇ ತನ್ ಮಾಂಸಮೇವ ತಥಾತ್ಮನೋ ಯೋ ಜಾಯತೇ ಸ ಆತ್ಮೈವ| ");
INSERT INTO sankan_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","ಯುಷ್ಮಾಭಿಃ ಪುನ ರ್ಜನಿತವ್ಯಂ ಮಮೈತಸ್ಯಾಂ ಕಥಾಯಾಮ್ ಆಶ್ಚರ್ಯಂ ಮಾ ಮಂಸ್ಥಾಃ| ");
INSERT INTO sankan_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","ಸದಾಗತಿರ್ಯಾಂ ದಿಶಮಿಚ್ಛತಿ ತಸ್ಯಾಮೇವ ದಿಶಿ ವಾತಿ, ತ್ವಂ ತಸ್ಯ ಸ್ವನಂ ಶುಣೋಷಿ ಕಿನ್ತು ಸ ಕುತ ಆಯಾತಿ ಕುತ್ರ ಯಾತಿ ವಾ ಕಿಮಪಿ ನ ಜಾನಾಸಿ ತದ್ವಾದ್ ಆತ್ಮನಃ ಸಕಾಶಾತ್ ಸರ್ವ್ವೇಷಾಂ ಮನುಜಾನಾಂ ಜನ್ಮ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","ತದಾ ನಿಕದೀಮಃ ಪೃಷ್ಟವಾನ್ ಏತತ್ ಕಥಂ ಭವಿತುಂ ಶಕ್ನೋತಿ? ");
INSERT INTO sankan_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","ಯೀಶುಃ ಪ್ರತ್ಯಕ್ತವಾನ್ ತ್ವಮಿಸ್ರಾಯೇಲೋ ಗುರುರ್ಭೂತ್ವಾಪಿ ಕಿಮೇತಾಂ ಕಥಾಂ ನ ವೇತ್ಸಿ? ");
INSERT INTO sankan_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","ತುಭ್ಯಂ ಯಥಾರ್ಥಂ ಕಥಯಾಮಿ, ವಯಂ ಯದ್ ವಿದ್ಮಸ್ತದ್ ವಚ್ಮಃ ಯಂಚ್ಚ ಪಶ್ಯಾಮಸ್ತಸ್ಯೈವ ಸಾಕ್ಷ್ಯಂ ದದ್ಮಃ ಕಿನ್ತು ಯುಷ್ಮಾಭಿರಸ್ಮಾಕಂ ಸಾಕ್ಷಿತ್ವಂ ನ ಗೃಹ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ಏತಸ್ಯ ಸಂಸಾರಸ್ಯ ಕಥಾಯಾಂ ಕಥಿತಾಯಾಂ ಯದಿ ಯೂಯಂ ನ ವಿಶ್ವಸಿಥ ತರ್ಹಿ ಸ್ವರ್ಗೀಯಾಯಾಂ ಕಥಾಯಾಂ ಕಥಂ ವಿಶ್ವಸಿಷ್ಯಥ? ");
INSERT INTO sankan_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ಯಃ ಸ್ವರ್ಗೇಽಸ್ತಿ ಯಂ ಚ ಸ್ವರ್ಗಾದ್ ಅವಾರೋಹತ್ ತಂ ಮಾನವತನಯಂ ವಿನಾ ಕೋಪಿ ಸ್ವರ್ಗಂ ನಾರೋಹತ್| ");
INSERT INTO sankan_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","ಅಪರಞ್ಚ ಮೂಸಾ ಯಥಾ ಪ್ರಾನ್ತರೇ ಸರ್ಪಂ ಪ್ರೋತ್ಥಾಪಿತವಾನ್ ಮನುಷ್ಯಪುತ್ರೋಽಪಿ ತಥೈವೋತ್ಥಾಪಿತವ್ಯಃ; ");
INSERT INTO sankan_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ತಸ್ಮಾದ್ ಯಃ ಕಶ್ಚಿತ್ ತಸ್ಮಿನ್ ವಿಶ್ವಸಿಷ್ಯತಿ ಸೋಽವಿನಾಶ್ಯಃ ಸನ್ ಅನನ್ತಾಯುಃ ಪ್ರಾಪ್ಸ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ಈಶ್ವರ ಇತ್ಥಂ ಜಗದದಯತ ಯತ್ ಸ್ವಮದ್ವಿತೀಯಂ ತನಯಂ ಪ್ರಾದದಾತ್ ತತೋ ಯಃ ಕಶ್ಚಿತ್ ತಸ್ಮಿನ್ ವಿಶ್ವಸಿಷ್ಯತಿ ಸೋಽವಿನಾಶ್ಯಃ ಸನ್ ಅನನ್ತಾಯುಃ ಪ್ರಾಪ್ಸ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ಈಶ್ವರೋ ಜಗತೋ ಲೋಕಾನ್ ದಣ್ಡಯಿತುಂ ಸ್ವಪುತ್ರಂ ನ ಪ್ರೇಷ್ಯ ತಾನ್ ಪರಿತ್ರಾತುಂ ಪ್ರೇಷಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ಅತಏವ ಯಃ ಕಶ್ಚಿತ್ ತಸ್ಮಿನ್ ವಿಶ್ವಸಿತಿ ಸ ದಣ್ಡಾರ್ಹೋ ನ ಭವತಿ ಕಿನ್ತು ಯಃ ಕಶ್ಚಿತ್ ತಸ್ಮಿನ್ ನ ವಿಶ್ವಸಿತಿ ಸ ಇದಾನೀಮೇವ ದಣ್ಡಾರ್ಹೋ ಭವತಿ,ಯತಃ ಸ ಈಶ್ವರಸ್ಯಾದ್ವಿತೀಯಪುತ್ರಸ್ಯ ನಾಮನಿ ಪ್ರತ್ಯಯಂ ನ ಕರೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","ಜಗತೋ ಮಧ್ಯೇ ಜ್ಯೋತಿಃ ಪ್ರಾಕಾಶತ ಕಿನ್ತು ಮನುಷ್ಯಾಣಾಂ ಕರ್ಮ್ಮಣಾಂ ದೃಷ್ಟತ್ವಾತ್ ತೇ ಜ್ಯೋತಿಷೋಪಿ ತಿಮಿರೇ ಪ್ರೀಯನ್ತೇ ಏತದೇವ ದಣ್ಡಸ್ಯ ಕಾರಣಾಂ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ಯಃ ಕುಕರ್ಮ್ಮ ಕರೋತಿ ತಸ್ಯಾಚಾರಸ್ಯ ದೃಷ್ಟತ್ವಾತ್ ಸ ಜ್ಯೋತಿರೄತೀಯಿತ್ವಾ ತನ್ನಿಕಟಂ ನಾಯಾತಿ; ");
INSERT INTO sankan_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","ಕಿನ್ತು ಯಃ ಸತ್ಕರ್ಮ್ಮ ಕರೋತಿ ತಸ್ಯ ಸರ್ವ್ವಾಣಿ ಕರ್ಮ್ಮಾಣೀಶ್ವರೇಣ ಕೃತಾನೀತಿ ಸಥಾ ಪ್ರಕಾಶತೇ ತದಭಿಪ್ರಾಯೇಣ ಸ ಜ್ಯೋತಿಷಃ ಸನ್ನಿಧಿಮ್ ಆಯಾತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ತತಃ ಪರಮ್ ಯೀಶುಃ ಶಿಷ್ಯೈಃ ಸಾರ್ದ್ಧಂ ಯಿಹೂದೀಯದೇಶಂ ಗತ್ವಾ ತತ್ರ ಸ್ಥಿತ್ವಾ ಮಜ್ಜಯಿತುಮ್ ಆರಭತ| ");
INSERT INTO sankan_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","ತದಾ ಶಾಲಮ್ ನಗರಸ್ಯ ಸಮೀಪಸ್ಥಾಯಿನಿ ಐನನ್ ಗ್ರಾಮೇ ಬಹುತರತೋಯಸ್ಥಿತೇಸ್ತತ್ರ ಯೋಹನ್ ಅಮಜ್ಜಯತ್ ತಥಾ ಚ ಲೋಕಾ ಆಗತ್ಯ ತೇನ ಮಜ್ಜಿತಾ ಅಭವನ್| ");
INSERT INTO sankan_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ತದಾ ಯೋಹನ್ ಕಾರಾಯಾಂ ನ ಬದ್ಧಃ| ");
INSERT INTO sankan_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","ಅಪರಞ್ಚ ಶಾಚಕರ್ಮ್ಮಣಿ ಯೋಹಾನಃ ಶಿಷ್ಯೈಃ ಸಹ ಯಿಹೂದೀಯಲೋಕಾನಾಂ ವಿವಾದೇ ಜಾತೇ, ತೇ ಯೋಹನಃ ಸಂನ್ನಿಧಿಂ ಗತ್ವಾಕಥಯನ್, ");
INSERT INTO sankan_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ಹೇ ಗುರೋ ಯರ್ದ್ದನನದ್ಯಾಃ ಪಾರೇ ಭವತಾ ಸಾರ್ದ್ಧಂ ಯ ಆಸೀತ್ ಯಸ್ಮಿಂಶ್ಚ ಭವಾನ್ ಸಾಕ್ಷ್ಯಂ ಪ್ರದದಾತ್ ಪಶ್ಯತು ಸೋಪಿ ಮಜ್ಜಯತಿ ಸರ್ವ್ವೇ ತಸ್ಯ ಸಮೀಪಂ ಯಾನ್ತಿ ಚ| ");
INSERT INTO sankan_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ತದಾ ಯೋಹನ್ ಪ್ರತ್ಯವೋಚದ್ ಈಶ್ವರೇಣ ನ ದತ್ತೇ ಕೋಪಿ ಮನುಜಃ ಕಿಮಪಿ ಪ್ರಾಪ್ತುಂ ನ ಶಕ್ನೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","ಅಹಂ ಅಭಿಷಿಕ್ತೋ ನ ಭವಾಮಿ ಕಿನ್ತು ತದಗ್ರೇ ಪ್ರೇಷಿತೋಸ್ಮಿ ಯಾಮಿಮಾಂ ಕಥಾಂ ಕಥಿತವಾನಾಹಂ ತತ್ರ ಯೂಯಂ ಸರ್ವ್ವೇ ಸಾಕ್ಷಿಣಃ ಸ್ಥ| ");
INSERT INTO sankan_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","ಯೋ ಜನಃ ಕನ್ಯಾಂ ಲಭತೇ ಸ ಏವ ವರಃ ಕಿನ್ತು ವರಸ್ಯ ಸನ್ನಿಧೌ ದಣ್ಡಾಯಮಾನಂ ತಸ್ಯ ಯನ್ಮಿತ್ರಂ ತೇನ ವರಸ್ಯ ಶಬ್ದೇ ಶ್ರುತೇಽತೀವಾಹ್ಲಾದ್ಯತೇ ಮಮಾಪಿ ತದ್ವದ್ ಆನನ್ದಸಿದ್ಧಿರ್ಜಾತಾ| ");
INSERT INTO sankan_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ತೇನ ಕ್ರಮಶೋ ವರ್ದ್ಧಿತವ್ಯಂ ಕಿನ್ತು ಮಯಾ ಹ್ಸಿತವ್ಯಂ| ");
INSERT INTO sankan_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ಯ ಊರ್ಧ್ವಾದಾಗಚ್ಛತ್ ಸ ಸರ್ವ್ವೇಷಾಂ ಮುಖ್ಯೋ ಯಶ್ಚ ಸಂಸಾರಾದ್ ಉದಪದ್ಯತ ಸ ಸಾಂಸಾರಿಕಃ ಸಂಸಾರೀಯಾಂ ಕಥಾಞ್ಚ ಕಥಯತಿ ಯಸ್ತು ಸ್ವರ್ಗಾದಾಗಚ್ಛತ್ ಸ ಸರ್ವ್ವೇಷಾಂ ಮುಖ್ಯಃ| ");
INSERT INTO sankan_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ಸ ಯದಪಶ್ಯದಶೃಣೋಚ್ಚ ತಸ್ಮಿನ್ನೇವ ಸಾಕ್ಷ್ಯಂ ದದಾತಿ ತಥಾಪಿ ಪ್ರಾಯಶಃ ಕಶ್ಚಿತ್ ತಸ್ಯ ಸಾಕ್ಷ್ಯಂ ನ ಗೃಹ್ಲಾತಿ; ");
INSERT INTO sankan_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ಕಿನ್ತು ಯೋ ಗೃಹ್ಲಾತಿ ಸ ಈಶ್ವರಸ್ಯ ಸತ್ಯವಾದಿತ್ವಂ ಮುದ್ರಾಙ್ಗಿತಂ ಕರೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ಈಶ್ವರೇಣ ಯಃ ಪ್ರೇರಿತಃ ಸಏವ ಈಶ್ವರೀಯಕಥಾಂ ಕಥಯತಿ ಯತ ಈಶ್ವರ ಆತ್ಮಾನಂ ತಸ್ಮೈ ಅಪರಿಮಿತಮ್ ಅದದಾತ್| ");
INSERT INTO sankan_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","ಪಿತಾ ಪುತ್ರೇ ಸ್ನೇಹಂ ಕೃತ್ವಾ ತಸ್ಯ ಹಸ್ತೇ ಸರ್ವ್ವಾಣಿ ಸಮರ್ಪಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ಯಃ ಕಶ್ಚಿತ್ ಪುತ್ರೇ ವಿಶ್ವಸಿತಿ ಸ ಏವಾನನ್ತಮ್ ಪರಮಾಯುಃ ಪ್ರಾಪ್ನೋತಿ ಕಿನ್ತು ಯಃ ಕಶ್ಚಿತ್ ಪುತ್ರೇ ನ ವಿಶ್ವಸಿತಿ ಸ ಪರಮಾಯುಷೋ ದರ್ಶನಂ ನ ಪ್ರಾಪ್ನೋತಿ ಕಿನ್ತ್ವೀಶ್ವರಸ್ಯ ಕೋಪಭಾಜನಂ ಭೂತ್ವಾ ತಿಷ್ಠತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","ಯೀಶುಃ ಸ್ವಯಂ ನಾಮಜ್ಜಯತ್ ಕೇವಲಂ ತಸ್ಯ ಶಿಷ್ಯಾ ಅಮಜ್ಜಯತ್ ಕಿನ್ತು ಯೋಹನೋಽಧಿಕಶಿಷ್ಯಾನ್ ಸ ಕರೋತಿ ಮಜ್ಜಯತಿ ಚ, ");
INSERT INTO sankan_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ಫಿರೂಶಿನ ಇಮಾಂ ವಾರ್ತ್ತಾಮಶೃಣ್ವನ್ ಇತಿ ಪ್ರಭುರವಗತ್ಯ ");
INSERT INTO sankan_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ಯಿಹೂದೀಯದೇಶಂ ವಿಹಾಯ ಪುನ ರ್ಗಾಲೀಲಮ್ ಆಗತ್| ");
INSERT INTO sankan_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ತತಃ ಶೋಮಿರೋಣಪ್ರದೇಶಸ್ಯ ಮದ್ಯೇನ ತೇನ ಗನ್ತವ್ಯೇ ಸತಿ ");
INSERT INTO sankan_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ಯಾಕೂಬ್ ನಿಜಪುತ್ರಾಯ ಯೂಷಫೇ ಯಾಂ ಭೂಮಿಮ್ ಅದದಾತ್ ತತ್ಸಮೀಪಸ್ಥಾಯಿ ಶೋಮಿರೋಣಪ್ರದೇಶಸ್ಯ ಸುಖಾರ್ ನಾಮ್ನಾ ವಿಖ್ಯಾತಸ್ಯ ನಗರಸ್ಯ ಸನ್ನಿಧಾವುಪಾಸ್ಥಾತ್| ");
INSERT INTO sankan_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ತತ್ರ ಯಾಕೂಬಃ ಪ್ರಹಿರಾಸೀತ್; ತದಾ ದ್ವಿತೀಯಯಾಮವೇಲಾಯಾಂ ಜಾತಾಯಾಂ ಸ ಮಾರ್ಗೇ ಶ್ರಮಾಪನ್ನಸ್ತಸ್ಯ ಪ್ರಹೇಃ ಪಾರ್ಶ್ವೇ ಉಪಾವಿಶತ್| ");
INSERT INTO sankan_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ಏತರ್ಹಿ ಕಾಚಿತ್ ಶೋಮಿರೋಣೀಯಾ ಯೋಷಿತ್ ತೋಯೋತ್ತೋಲನಾರ್ಥಮ್ ತತ್ರಾಗಮತ್ ");
INSERT INTO sankan_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","ತದಾ ಶಿಷ್ಯಾಃ ಖಾದ್ಯದ್ರವ್ಯಾಣಿ ಕ್ರೇತುಂ ನಗರಮ್ ಅಗಚ್ಛನ್| ");
INSERT INTO sankan_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","ಯೀಶುಃ ಶೋಮಿರೋಣೀಯಾಂ ತಾಂ ಯೋಷಿತಮ್ ವ್ಯಾಹಾರ್ಷೀತ್ ಮಹ್ಯಂ ಕಿಞ್ಚಿತ್ ಪಾನೀಯಂ ಪಾತುಂ ದೇಹಿ| ಕಿನ್ತು ಶೋಮಿರೋಣೀಯೈಃ ಸಾಕಂ ಯಿಹೂದೀಯಲೋಕಾ ನ ವ್ಯವಾಹರನ್ ತಸ್ಮಾದ್ಧೇತೋಃ ಸಾಕಥಯತ್ ಶೋಮಿರೋಣೀಯಾ ಯೋಷಿತದಹಂ ತ್ವಂ ಯಿಹೂದೀಯೋಸಿ ಕಥಂ ಮತ್ತಃ ಪಾನೀಯಂ ಪಾತುಮ್ ಇಚ್ಛಸಿ? ");
INSERT INTO sankan_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ತತೋ ಯೀಶುರವದದ್ ಈಶ್ವರಸ್ಯ ಯದ್ದಾನಂ ತತ್ಕೀದೃಕ್ ಪಾನೀಯಂ ಪಾತುಂ ಮಹ್ಯಂ ದೇಹಿ ಯ ಇತ್ಥಂ ತ್ವಾಂ ಯಾಚತೇ ಸ ವಾ ಕ ಇತಿ ಚೇದಜ್ಞಾಸ್ಯಥಾಸ್ತರ್ಹಿ ತಮಯಾಚಿಷ್ಯಥಾಃ ಸ ಚ ತುಭ್ಯಮಮೃತಂ ತೋಯಮದಾಸ್ಯತ್| ");
INSERT INTO sankan_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","ತದಾ ಸಾ ಸೀಮನ್ತಿನೀ ಭಾಷಿತವತಿ, ಹೇ ಮಹೇಚ್ಛ ಪ್ರಹಿರ್ಗಮ್ಭೀರೋ ಭವತೋ ನೀರೋತ್ತೋಲನಪಾತ್ರಂ ನಾಸ್ತೀ ಚ ತಸ್ಮಾತ್ ತದಮೃತಂ ಕೀಲಾಲಂ ಕುತಃ ಪ್ರಾಪ್ಸ್ಯಸಿ? ");
INSERT INTO sankan_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","ಯೋಸ್ಮಭ್ಯಮ್ ಇಮಮನ್ಧೂಂ ದದೌ, ಯಸ್ಯ ಚ ಪರಿಜನಾ ಗೋಮೇಷಾದಯಶ್ಚ ಸರ್ವ್ವೇಽಸ್ಯ ಪ್ರಹೇಃ ಪಾನೀಯಂ ಪಪುರೇತಾದೃಶೋ ಯೋಸ್ಮಾಕಂ ಪೂರ್ವ್ವಪುರುಷೋ ಯಾಕೂಬ್ ತಸ್ಮಾದಪಿ ಭವಾನ್ ಮಹಾನ್ ಕಿಂ? ");
INSERT INTO sankan_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ತತೋ ಯೀಶುರಕಥಯದ್ ಇದಂ ಪಾನೀಯಂ ಸಃ ಪಿವತಿ ಸ ಪುನಸ್ತೃಷಾರ್ತ್ತೋ ಭವಿಷ್ಯತಿ, ");
INSERT INTO sankan_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ಕಿನ್ತು ಮಯಾ ದತ್ತಂ ಪಾನೀಯಂ ಯಃ ಪಿವತಿ ಸ ಪುನಃ ಕದಾಪಿ ತೃಷಾರ್ತ್ತೋ ನ ಭವಿಷ್ಯತಿ| ಮಯಾ ದತ್ತಮ್ ಇದಂ ತೋಯಂ ತಸ್ಯಾನ್ತಃ ಪ್ರಸ್ರವಣರೂಪಂ ಭೂತ್ವಾ ಅನನ್ತಾಯುರ್ಯಾವತ್ ಸ್ರೋಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","ತದಾ ಸಾ ವನಿತಾಕಥಯತ್ ಹೇ ಮಹೇಚ್ಛ ತರ್ಹಿ ಮಮ ಪುನಃ ಪೀಪಾಸಾ ಯಥಾ ನ ಜಾಯತೇ ತೋಯೋತ್ತೋಲನಾಯ ಯಥಾತ್ರಾಗಮನಂ ನ ಭವತಿ ಚ ತದರ್ಥಂ ಮಹ್ಯಂ ತತ್ತೋಯಂ ದೇಹೀ| ");
INSERT INTO sankan_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ತತೋ ಯೀಶೂರವದದ್ಯಾಹಿ ತವ ಪತಿಮಾಹೂಯ ಸ್ಥಾನೇಽತ್ರಾಗಚ್ಛ| ");
INSERT INTO sankan_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","ಸಾ ವಾಮಾವದತ್ ಮಮ ಪತಿರ್ನಾಸ್ತಿ| ಯೀಶುರವದತ್ ಮಮ ಪತಿರ್ನಾಸ್ತೀತಿ ವಾಕ್ಯಂ ಭದ್ರಮವೋಚಃ| ");
INSERT INTO sankan_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ಯತಸ್ತವ ಪಞ್ಚ ಪತಯೋಭವನ್ ಅಧುನಾ ತು ತ್ವಯಾ ಸಾರ್ದ್ಧಂ ಯಸ್ತಿಷ್ಠತಿ ಸ ತವ ಭರ್ತ್ತಾ ನ ವಾಕ್ಯಮಿದಂ ಸತ್ಯಮವಾದಿಃ| ");
INSERT INTO sankan_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","ತದಾ ಸಾ ಮಹಿಲಾ ಗದಿತವತಿ ಹೇ ಮಹೇಚ್ಛ ಭವಾನ್ ಏಕೋ ಭವಿಷ್ಯದ್ವಾದೀತಿ ಬುದ್ಧಂ ಮಯಾ| ");
INSERT INTO sankan_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","ಅಸ್ಮಾಕಂ ಪಿತೃಲೋಕಾ ಏತಸ್ಮಿನ್ ಶಿಲೋಚ್ಚಯೇಽಭಜನ್ತ, ಕಿನ್ತು ಭವದ್ಭಿರುಚ್ಯತೇ ಯಿರೂಶಾಲಮ್ ನಗರೇ ಭಜನಯೋಗ್ಯಂ ಸ್ಥಾನಮಾಸ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","ಯೀಶುರವೋಚತ್ ಹೇ ಯೋಷಿತ್ ಮಮ ವಾಕ್ಯೇ ವಿಶ್ವಸಿಹಿ ಯದಾ ಯೂಯಂ ಕೇವಲಶೈಲೇಽಸ್ಮಿನ್ ವಾ ಯಿರೂಶಾಲಮ್ ನಗರೇ ಪಿತುರ್ಭಜನಂ ನ ಕರಿಷ್ಯಧ್ವೇ ಕಾಲ ಏತಾದೃಶ ಆಯಾತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ಯೂಯಂ ಯಂ ಭಜಧ್ವೇ ತಂ ನ ಜಾನೀಥ, ಕಿನ್ತು ವಯಂ ಯಂ ಭಜಾಮಹೇ ತಂ ಜಾನೀಮಹೇ, ಯತೋ ಯಿಹೂದೀಯಲೋಕಾನಾಂ ಮಧ್ಯಾತ್ ಪರಿತ್ರಾಣಂ ಜಾಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","ಕಿನ್ತು ಯದಾ ಸತ್ಯಭಕ್ತಾ ಆತ್ಮನಾ ಸತ್ಯರೂಪೇಣ ಚ ಪಿತುರ್ಭಜನಂ ಕರಿಷ್ಯನ್ತೇ ಸಮಯ ಏತಾದೃಶ ಆಯಾತಿ, ವರಮ್ ಇದಾನೀಮಪಿ ವಿದ್ಯತೇ ; ಯತ ಏತಾದೃಶೋ ಭತ್ಕಾನ್ ಪಿತಾ ಚೇಷ್ಟತೇ| ");
INSERT INTO sankan_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ಈಶ್ವರ ಆತ್ಮಾ; ತತಸ್ತಸ್ಯ ಯೇ ಭಕ್ತಾಸ್ತೈಃ ಸ ಆತ್ಮನಾ ಸತ್ಯರೂಪೇಣ ಚ ಭಜನೀಯಃ| ");
INSERT INTO sankan_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","ತದಾ ಸಾ ಮಹಿಲಾವಾದೀತ್ ಖ್ರೀಷ್ಟನಾಮ್ನಾ ವಿಖ್ಯಾತೋಽಭಿಷಿಕ್ತಃ ಪುರುಷ ಆಗಮಿಷ್ಯತೀತಿ ಜಾನಾಮಿ ಸ ಚ ಸರ್ವ್ವಾಃ ಕಥಾ ಅಸ್ಮಾನ್ ಜ್ಞಾಪಯಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ತತೋ ಯೀಶುರವದತ್ ತ್ವಯಾ ಸಾರ್ದ್ಧಂ ಕಥನಂ ಕರೋಮಿ ಯೋಽಹಮ್ ಅಹಮೇವ ಸ ಪುರುಷಃ| ");
INSERT INTO sankan_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ಏತಸ್ಮಿನ್ ಸಮಯೇ ಶಿಷ್ಯಾ ಆಗತ್ಯ ತಥಾ ಸ್ತ್ರಿಯಾ ಸಾರ್ದ್ಧಂ ತಸ್ಯ ಕಥೋಪಕಥನೇ ಮಹಾಶ್ಚರ್ಯ್ಯಮ್ ಅಮನ್ಯನ್ತ ತಥಾಪಿ ಭವಾನ್ ಕಿಮಿಚ್ಛತಿ? ಯದ್ವಾ ಕಿಮರ್ಥಮ್ ಏತಯಾ ಸಾರ್ದ್ಧಂ ಕಥಾಂ ಕಥಯತಿ? ಇತಿ ಕೋಪಿ ನಾಪೃಚ್ಛತ್| ");
INSERT INTO sankan_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","ತತಃ ಪರಂ ಸಾ ನಾರೀ ಕಲಶಂ ಸ್ಥಾಪಯಿತ್ವಾ ನಗರಮಧ್ಯಂ ಗತ್ವಾ ಲೋಕೇಭ್ಯೋಕಥಾಯದ್ ");
INSERT INTO sankan_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","ಅಹಂ ಯದ್ಯತ್ ಕರ್ಮ್ಮಾಕರವಂ ತತ್ಸರ್ವ್ವಂ ಮಹ್ಯಮಕಥಯದ್ ಏತಾದೃಶಂ ಮಾನವಮೇಕಮ್ ಆಗತ್ಯ ಪಶ್ಯತ ರು ಕಿಮ್ ಅಭಿಷಿಕ್ತೋ ನ ಭವತಿ ? ");
INSERT INTO sankan_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ತತಸ್ತೇ ನಗರಾದ್ ಬಹಿರಾಗತ್ಯ ತಾತಸ್ಯ ಸಮೀಪಮ್ ಆಯನ್| ");
INSERT INTO sankan_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ಏತರ್ಹಿ ಶಿಷ್ಯಾಃ ಸಾಧಯಿತ್ವಾ ತಂ ವ್ಯಾಹಾರ್ಷುಃ ಹೇ ಗುರೋ ಭವಾನ್ ಕಿಞ್ಚಿದ್ ಭೂಕ್ತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ತತಃ ಸೋವದದ್ ಯುಷ್ಮಾಭಿರ್ಯನ್ನ ಜ್ಞಾಯತೇ ತಾದೃಶಂ ಭಕ್ಷ್ಯಂ ಮಮಾಸ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","ತದಾ ಶಿಷ್ಯಾಃ ಪರಸ್ಪರಂ ಪ್ರಷ್ಟುಮ್ ಆರಮ್ಭನ್ತ, ಕಿಮಸ್ಮೈ ಕೋಪಿ ಕಿಮಪಿ ಭಕ್ಷ್ಯಮಾನೀಯ ದತ್ತವಾನ್? ");
INSERT INTO sankan_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","ಯೀಶುರವೋಚತ್ ಮತ್ಪ್ರೇರಕಸ್ಯಾಭಿಮತಾನುರೂಪಕರಣಂ ತಸ್ಯೈವ ಕರ್ಮ್ಮಸಿದ್ಧಿಕಾರಣಞ್ಚ ಮಮ ಭಕ್ಷ್ಯಂ| ");
INSERT INTO sankan_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","ಮಾಸಚತುಷ್ಟಯೇ ಜಾತೇ ಶಸ್ಯಕರ್ತ್ತನಸಮಯೋ ಭವಿಷ್ಯತೀತಿ ವಾಕ್ಯಂ ಯುಷ್ಮಾಭಿಃ ಕಿಂ ನೋದ್ಯತೇ? ಕಿನ್ತ್ವಹಂ ವದಾಮಿ, ಶಿರ ಉತ್ತೋಲ್ಯ ಕ್ಷೇತ್ರಾಣಿ ಪ್ರತಿ ನಿರೀಕ್ಷ್ಯ ಪಶ್ಯತ, ಇದಾನೀಂ ಕರ್ತ್ತನಯೋಗ್ಯಾನಿ ಶುಕ್ಲವರ್ಣಾನ್ಯಭವನ್| ");
INSERT INTO sankan_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","ಯಶ್ಛಿನತ್ತಿ ಸ ವೇತನಂ ಲಭತೇ ಅನನ್ತಾಯುಃಸ್ವರೂಪಂ ಶಸ್ಯಂ ಸ ಗೃಹ್ಲಾತಿ ಚ, ತೇನೈವ ವಪ್ತಾ ಛೇತ್ತಾ ಚ ಯುಗಪದ್ ಆನನ್ದತಃ| ");
INSERT INTO sankan_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ಇತ್ಥಂ ಸತಿ ವಪತ್ಯೇಕಶ್ಛಿನತ್ಯನ್ಯ ಇತಿ ವಚನಂ ಸಿದ್ಧ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","ಯತ್ರ ಯೂಯಂ ನ ಪರ್ಯ್ಯಶ್ರಾಮ್ಯತ ತಾದೃಶಂ ಶಸ್ಯಂ ಛೇತ್ತುಂ ಯುಷ್ಮಾನ್ ಪ್ರೈರಯಮ್ ಅನ್ಯೇ ಜನಾಃಪರ್ಯ್ಯಶ್ರಾಮ್ಯನ್ ಯೂಯಂ ತೇಷಾಂ ಶ್ರಗಸ್ಯ ಫಲಮ್ ಅಲಭಧ್ವಮ್| ");
INSERT INTO sankan_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ಯಸ್ಮಿನ್ ಕಾಲೇ ಯದ್ಯತ್ ಕರ್ಮ್ಮಾಕಾರ್ಷಂ ತತ್ಸರ್ವ್ವಂ ಸ ಮಹ್ಯಮ್ ಅಕಥಯತ್ ತಸ್ಯಾ ವನಿತಾಯಾ ಇದಂ ಸಾಕ್ಷ್ಯವಾಕ್ಯಂ ಶ್ರುತ್ವಾ ತನ್ನಗರನಿವಾಸಿನೋ ಬಹವಃ ಶೋಮಿರೋಣೀಯಲೋಕಾ ವ್ಯಶ್ವಸನ್| ");
INSERT INTO sankan_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ತಥಾ ಚ ತಸ್ಯಾನ್ತಿಕೇ ಸಮುಪಸ್ಥಾಯ ಸ್ವೇಷಾಂ ಸನ್ನಿಧೌ ಕತಿಚಿದ್ ದಿನಾನಿ ಸ್ಥಾತುಂ ತಸ್ಮಿನ್ ವಿನಯಮ್ ಅಕುರ್ವ್ವಾನ ತಸ್ಮಾತ್ ಸ ದಿನದ್ವಯಂ ತತ್ಸ್ಥಾನೇ ನ್ಯವಷ್ಟತ್ ");
INSERT INTO sankan_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ತತಸ್ತಸ್ಯೋಪದೇಶೇನ ಬಹವೋಽಪರೇ ವಿಶ್ವಸ್ಯ ");
INSERT INTO sankan_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ತಾಂ ಯೋಷಾಮವದನ್ ಕೇವಲಂ ತವ ವಾಕ್ಯೇನ ಪ್ರತೀಮ ಇತಿ ನ, ಕಿನ್ತು ಸ ಜಗತೋಽಭಿಷಿಕ್ತಸ್ತ್ರಾತೇತಿ ತಸ್ಯ ಕಥಾಂ ಶ್ರುತ್ವಾ ವಯಂ ಸ್ವಯಮೇವಾಜ್ಞಾಸಮಹಿ| ");
INSERT INTO sankan_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","ಸ್ವದೇಶೇ ಭವಿಷ್ಯದ್ವಕ್ತುಃ ಸತ್ಕಾರೋ ನಾಸ್ತೀತಿ ಯದ್ಯಪಿ ಯೀಶುಃ ಪ್ರಮಾಣಂ ದತ್ವಾಕಥಯತ್ ");
INSERT INTO sankan_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","ತಥಾಪಿ ದಿವಸದ್ವಯಾತ್ ಪರಂ ಸ ತಸ್ಮಾತ್ ಸ್ಥಾನಾದ್ ಗಾಲೀಲಂ ಗತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ಅನನ್ತರಂ ಯೇ ಗಾಲೀಲೀ ಲಿಯಲೋಕಾ ಉತ್ಸವೇ ಗತಾ ಉತ್ಸವಸಮಯೇ ಯಿರೂಶಲಮ್ ನಗರೇ ತಸ್ಯ ಸರ್ವ್ವಾಃ ಕ್ರಿಯಾ ಅಪಶ್ಯನ್ ತೇ ಗಾಲೀಲಮ್ ಆಗತಂ ತಮ್ ಆಗೃಹ್ಲನ್| ");
INSERT INTO sankan_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ತತಃ ಪರಮ್ ಯೀಶು ರ್ಯಸ್ಮಿನ್ ಕಾನ್ನಾನಗರೇ ಜಲಂ ದ್ರಾಕ್ಷಾರಸಮ್ ಆಕರೋತ್ ತತ್ ಸ್ಥಾನಂ ಪುನರಗಾತ್| ತಸ್ಮಿನ್ನೇವ ಸಮಯೇ ಕಸ್ಯಚಿದ್ ರಾಜಸಭಾಸ್ತಾರಸ್ಯ ಪುತ್ರಃ ಕಫರ್ನಾಹೂಮಪುರೀ ರೋಗಗ್ರಸ್ತ ಆಸೀತ್| ");
INSERT INTO sankan_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ಸ ಯೇಹೂದೀಯದೇಶಾದ್ ಯೀಶೋ ರ್ಗಾಲೀಲಾಗಮನವಾರ್ತ್ತಾಂ ನಿಶಮ್ಯ ತಸ್ಯ ಸಮೀಪಂ ಗತ್ವಾ ಪ್ರಾರ್ಥ್ಯ ವ್ಯಾಹೃತವಾನ್ ಮಮ ಪುತ್ರಸ್ಯ ಪ್ರಾಯೇಣ ಕಾಲ ಆಸನ್ನಃ ಭವಾನ್ ಆಗತ್ಯ ತಂ ಸ್ವಸ್ಥಂ ಕರೋತು| ");
INSERT INTO sankan_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","ತದಾ ಯೀಶುರಕಥಯದ್ ಆಶ್ಚರ್ಯ್ಯಂ ಕರ್ಮ್ಮ ಚಿತ್ರಂ ಚಿಹ್ನಂ ಚ ನ ದೃಷ್ಟಾ ಯೂಯಂ ನ ಪ್ರತ್ಯೇಷ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ತತಃ ಸ ಸಭಾಸದವದತ್ ಹೇ ಮಹೇಚ್ಛ ಮಮ ಪುತ್ರೇ ನ ಮೃತೇ ಭವಾನಾಗಚ್ಛತು| ");
INSERT INTO sankan_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","ಯೀಶುಸ್ತಮವದದ್ ಗಚ್ಛ ತವ ಪುತ್ರೋಽಜೀವೀತ್ ತದಾ ಯೀಶುನೋಕ್ತವಾಕ್ಯೇ ಸ ವಿಶ್ವಸ್ಯ ಗತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ಗಮನಕಾಲೇ ಮಾರ್ಗಮಧ್ಯೇ ದಾಸಾಸ್ತಂ ಸಾಕ್ಷಾತ್ಪ್ರಾಪ್ಯಾವದನ್ ಭವತಃ ಪುತ್ರೋಽಜೀವೀತ್| ");
INSERT INTO sankan_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ತತಃ ಕಂ ಕಾಲಮಾರಭ್ಯ ರೋಗಪ್ರತೀಕಾರಾರಮ್ಭೋ ಜಾತಾ ಇತಿ ಪೃಷ್ಟೇ ತೈರುಕ್ತಂ ಹ್ಯಃ ಸಾರ್ದ್ಧದಣ್ಡದ್ವಯಾಧಿಕದ್ವಿತೀಯಯಾಮೇ ತಸ್ಯ ಜ್ವರತ್ಯಾಗೋಽಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","ತದಾ ಯೀಶುಸ್ತಸ್ಮಿನ್ ಕ್ಷಣೇ ಪ್ರೋಕ್ತವಾನ್ ತವ ಪುತ್ರೋಽಜೀವೀತ್ ಪಿತಾ ತದ್ಬುದ್ಧ್ವಾ ಸಪರಿವಾರೋ ವ್ಯಶ್ವಸೀತ್| ");
INSERT INTO sankan_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ಯಿಹೂದೀಯದೇಶಾದ್ ಆಗತ್ಯ ಗಾಲೀಲಿ ಯೀಶುರೇತದ್ ದ್ವಿತೀಯಮ್ ಆಶ್ಚರ್ಯ್ಯಕರ್ಮ್ಮಾಕರೋತ್| ");
INSERT INTO sankan_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ತತಃ ಪರಂ ಯಿಹೂದೀಯಾನಾಮ್ ಉತ್ಸವ ಉಪಸ್ಥಿತೇ ಯೀಶು ರ್ಯಿರೂಶಾಲಮಂ ಗತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","ತಸ್ಮಿನ್ನಗರೇ ಮೇಷನಾಮ್ನೋ ದ್ವಾರಸ್ಯ ಸಮೀಪೇ ಇಬ್ರೀಯಭಾಷಯಾ ಬೈಥೇಸ್ದಾ ನಾಮ್ನಾ ಪಿಷ್ಕರಿಣೀ ಪಞ್ಚಘಟ್ಟಯುಕ್ತಾಸೀತ್| ");
INSERT INTO sankan_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ತಸ್ಯಾಸ್ತೇಷು ಘಟ್ಟೇಷು ಕಿಲಾಲಕಮ್ಪನಮ್ ಅಪೇಕ್ಷ್ಯ ಅನ್ಧಖಞ್ಚಶುಷ್ಕಾಙ್ಗಾದಯೋ ಬಹವೋ ರೋಗಿಣಃ ಪತನ್ತಸ್ತಿಷ್ಠನ್ತಿ ಸ್ಮ| ");
INSERT INTO sankan_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ಯತೋ ವಿಶೇಷಕಾಲೇ ತಸ್ಯ ಸರಸೋ ವಾರಿ ಸ್ವರ್ಗೀಯದೂತ ಏತ್ಯಾಕಮ್ಪಯತ್ ತತ್ಕೀಲಾಲಕಮ್ಪನಾತ್ ಪರಂ ಯಃ ಕಶ್ಚಿದ್ ರೋಗೀ ಪ್ರಥಮಂ ಪಾನೀಯಮವಾರೋಹತ್ ಸ ಏವ ತತ್ಕ್ಷಣಾದ್ ರೋಗಮುಕ್ತೋಽಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","ತದಾಷ್ಟಾತ್ರಿಂಶದ್ವರ್ಷಾಣಿ ಯಾವದ್ ರೋಗಗ್ರಸ್ತ ಏಕಜನಸ್ತಸ್ಮಿನ್ ಸ್ಥಾನೇ ಸ್ಥಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ಯೀಶುಸ್ತಂ ಶಯಿತಂ ದೃಷ್ಟ್ವಾ ಬಹುಕಾಲಿಕರೋಗೀತಿ ಜ್ಞಾತ್ವಾ ವ್ಯಾಹೃತವಾನ್ ತ್ವಂ ಕಿಂ ಸ್ವಸ್ಥೋ ಬುಭೂಷಸಿ? ");
INSERT INTO sankan_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ತತೋ ರೋಗೀ ಕಥಿತವಾನ್ ಹೇ ಮಹೇಚ್ಛ ಯದಾ ಕೀಲಾಲಂ ಕಮ್ಪತೇ ತದಾ ಮಾಂ ಪುಷ್ಕರಿಣೀಮ್ ಅವರೋಹಯಿತುಂ ಮಮ ಕೋಪಿ ನಾಸ್ತಿ, ತಸ್ಮಾನ್ ಮಮ ಗಮನಕಾಲೇ ಕಶ್ಚಿದನ್ಯೋಽಗ್ರೋ ಗತ್ವಾ ಅವರೋಹತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","ತದಾ ಯೀಶುರಕಥಯದ್ ಉತ್ತಿಷ್ಠ, ತವ ಶಯ್ಯಾಮುತ್ತೋಲ್ಯ ಗೃಹೀತ್ವಾ ಯಾಹಿ| ");
INSERT INTO sankan_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","ಸ ತತ್ಕ್ಷಣಾತ್ ಸ್ವಸ್ಥೋ ಭೂತ್ವಾ ಶಯ್ಯಾಮುತ್ತೋಲ್ಯಾದಾಯ ಗತವಾನ್ ಕಿನ್ತು ತದ್ದಿನಂ ವಿಶ್ರಾಮವಾರಃ| ");
INSERT INTO sankan_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ತಸ್ಮಾದ್ ಯಿಹೂದೀಯಾಃ ಸ್ವಸ್ಥಂ ನರಂ ವ್ಯಾಹರನ್ ಅದ್ಯ ವಿಶ್ರಾಮವಾರೇ ಶಯನೀಯಮಾದಾಯ ನ ಯಾತವ್ಯಮ್| ");
INSERT INTO sankan_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","ತತಃ ಸ ಪ್ರತ್ಯವೋಚದ್ ಯೋ ಮಾಂ ಸ್ವಸ್ಥಮ್ ಅಕಾರ್ಷೀತ್ ಶಯನೀಯಮ್ ಉತ್ತೋಲ್ಯಾದಾಯ ಯಾತುಂ ಮಾಂ ಸ ಏವಾದಿಶತ್| ");
INSERT INTO sankan_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ತದಾ ತೇಽಪೃಚ್ಛನ್ ಶಯನೀಯಮ್ ಉತ್ತೋಲ್ಯಾದಾಯ ಯಾತುಂ ಯ ಆಜ್ಞಾಪಯತ್ ಸ ಕಃ? ");
INSERT INTO sankan_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","ಕಿನ್ತು ಸ ಕ ಇತಿ ಸ್ವಸ್ಥೀಭೂತೋ ನಾಜಾನಾದ್ ಯತಸ್ತಸ್ಮಿನ್ ಸ್ಥಾನೇ ಜನತಾಸತ್ತ್ವಾದ್ ಯೀಶುಃ ಸ್ಥಾನಾನ್ತರಮ್ ಆಗಮತ್| ");
INSERT INTO sankan_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","ತತಃ ಪರಂ ಯೇಶು ರ್ಮನ್ದಿರೇ ತಂ ನರಂ ಸಾಕ್ಷಾತ್ಪ್ರಾಪ್ಯಾಕಥಯತ್ ಪಶ್ಯೇದಾನೀಮ್ ಅನಾಮಯೋ ಜಾತೋಸಿ ಯಥಾಧಿಕಾ ದುರ್ದಶಾ ನ ಘಟತೇ ತದ್ಧೇತೋಃ ಪಾಪಂ ಕರ್ಮ್ಮ ಪುನರ್ಮಾಕಾರ್ಷೀಃ| ");
INSERT INTO sankan_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ತತಃ ಸ ಗತ್ವಾ ಯಿಹೂದೀಯಾನ್ ಅವದದ್ ಯೀಶು ರ್ಮಾಮ್ ಅರೋಗಿಣಮ್ ಅಕಾರ್ಷೀತ್| ");
INSERT INTO sankan_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","ತತೋ ಯೀಶು ರ್ವಿಶ್ರಾಮವಾರೇ ಕರ್ಮ್ಮೇದೃಶಂ ಕೃತವಾನ್ ಇತಿ ಹೇತೋ ರ್ಯಿಹೂದೀಯಾಸ್ತಂ ತಾಡಯಿತ್ವಾ ಹನ್ತುಮ್ ಅಚೇಷ್ಟನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","ಯೀಶುಸ್ತಾನಾಖ್ಯತ್ ಮಮ ಪಿತಾ ಯತ್ ಕಾರ್ಯ್ಯಂ ಕರೋತಿ ತದನುರೂಪಮ್ ಅಹಮಪಿ ಕರೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","ತತೋ ಯಿಹೂದೀಯಾಸ್ತಂ ಹನ್ತುಂ ಪುನರಯತನ್ತ ಯತೋ ವಿಶ್ರಾಮವಾರಂ ನಾಮನ್ಯತ ತದೇವ ಕೇವಲಂ ನ ಅಧಿಕನ್ತು ಈಶ್ವರಂ ಸ್ವಪಿತರಂ ಪ್ರೋಚ್ಯ ಸ್ವಮಪೀಶ್ವರತುಲ್ಯಂ ಕೃತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","ಪಶ್ಚಾದ್ ಯೀಶುರವದದ್ ಯುಷ್ಮಾನಹಂ ಯಥಾರ್ಥತರಂ ವದಾಮಿ ಪುತ್ರಃ ಪಿತರಂ ಯದ್ಯತ್ ಕರ್ಮ್ಮ ಕುರ್ವ್ವನ್ತಂ ಪಶ್ಯತಿ ತದತಿರಿಕ್ತಂ ಸ್ವೇಚ್ಛಾತಃ ಕಿಮಪಿ ಕರ್ಮ್ಮ ಕರ್ತ್ತುಂ ನ ಶಕ್ನೋತಿ| ಪಿತಾ ಯತ್ ಕರೋತಿ ಪುತ್ರೋಪಿ ತದೇವ ಕರೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ಪಿತಾ ಪುತ್ರೇ ಸ್ನೇಹಂ ಕರೋತಿ ತಸ್ಮಾತ್ ಸ್ವಯಂ ಯದ್ಯತ್ ಕರ್ಮ್ಮ ಕರೋತಿ ತತ್ಸರ್ವ್ವಂ ಪುತ್ರಂ ದರ್ಶಯತಿ ; ಯಥಾ ಚ ಯುಷ್ಮಾಕಂ ಆಶ್ಚರ್ಯ್ಯಜ್ಞಾನಂ ಜನಿಷ್ಯತೇ ತದರ್ಥಮ್ ಇತೋಪಿ ಮಹಾಕರ್ಮ್ಮ ತಂ ದರ್ಶಯಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","ವಸ್ತುತಸ್ತು ಪಿತಾ ಯಥಾ ಪ್ರಮಿತಾನ್ ಉತ್ಥಾಪ್ಯ ಸಜಿವಾನ್ ಕರೋತಿ ತದ್ವತ್ ಪುತ್ರೋಪಿ ಯಂ ಯಂ ಇಚ್ಛತಿ ತಂ ತಂ ಸಜೀವಂ ಕರೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","ಸರ್ವ್ವೇ ಪಿತರಂ ಯಥಾ ಸತ್ಕುರ್ವ್ವನ್ತಿ ತಥಾ ಪುತ್ರಮಪಿ ಸತ್ಕಾರಯಿತುಂ ಪಿತಾ ಸ್ವಯಂ ಕಸ್ಯಾಪಿ ವಿಚಾರಮಕೃತ್ವಾ ಸರ್ವ್ವವಿಚಾರಾಣಾಂ ಭಾರಂ ಪುತ್ರೇ ಸಮರ್ಪಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ಯಃ ಪುತ್ರಂ ಸತ್ ಕರೋತಿ ಸ ತಸ್ಯ ಪ್ರೇರಕಮಪಿ ಸತ್ ಕರೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","ಯುಷ್ಮಾನಾಹಂ ಯಥಾರ್ಥತರಂ ವದಾಮಿ ಯೋ ಜನೋ ಮಮ ವಾಕ್ಯಂ ಶ್ರುತ್ವಾ ಮತ್ಪ್ರೇರಕೇ ವಿಶ್ವಸಿತಿ ಸೋನನ್ತಾಯುಃ ಪ್ರಾಪ್ನೋತಿ ಕದಾಪಿ ದಣ್ಡಬಾಜನಂ ನ ಭವತಿ ನಿಧನಾದುತ್ಥಾಯ ಪರಮಾಯುಃ ಪ್ರಾಪ್ನೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","ಅಹಂ ಯುಷ್ಮಾನತಿಯಥಾರ್ಥಂ ವದಾಮಿ ಯದಾ ಮೃತಾ ಈಶ್ವರಪುತ್ರಸ್ಯ ನಿನಾದಂ ಶ್ರೋಷ್ಯನ್ತಿ ಯೇ ಚ ಶ್ರೋಷ್ಯನ್ತಿ ತೇ ಸಜೀವಾ ಭವಿಷ್ಯನ್ತಿ ಸಮಯ ಏತಾದೃಶ ಆಯಾತಿ ವರಮ್ ಇದಾನೀಮಪ್ಯುಪತಿಷ್ಠತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","ಪಿತಾ ಯಥಾ ಸ್ವಯಞ್ಜೀವೀ ತಥಾ ಪುತ್ರಾಯ ಸ್ವಯಞ್ಜೀವಿತ್ವಾಧಿಕಾರಂ ದತ್ತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ಸ ಮನುಷ್ಯಪುತ್ರಃ ಏತಸ್ಮಾತ್ ಕಾರಣಾತ್ ಪಿತಾ ದಣ್ಡಕರಣಾಧಿಕಾರಮಪಿ ತಸ್ಮಿನ್ ಸಮರ್ಪಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","ಏತದರ್ಥೇ ಯೂಯಮ್ ಆಶ್ಚರ್ಯ್ಯಂ ನ ಮನ್ಯಧ್ವಂ ಯತೋ ಯಸ್ಮಿನ್ ಸಮಯೇ ತಸ್ಯ ನಿನಾದಂ ಶ್ರುತ್ವಾ ಶ್ಮಶಾನಸ್ಥಾಃ ಸರ್ವ್ವೇ ಬಹಿರಾಗಮಿಷ್ಯನ್ತಿ ಸಮಯ ಏತಾದೃಶ ಉಪಸ್ಥಾಸ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ತಸ್ಮಾದ್ ಯೇ ಸತ್ಕರ್ಮ್ಮಾಣಿ ಕೃತವನ್ತಸ್ತ ಉತ್ಥಾಯ ಆಯುಃ ಪ್ರಾಪ್ಸ್ಯನ್ತಿ ಯೇ ಚ ಕುಕರ್ಮಾಣಿ ಕೃತವನ್ತಸ್ತ ಉತ್ಥಾಯ ದಣ್ಡಂ ಪ್ರಾಪ್ಸ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","ಅಹಂ ಸ್ವಯಂ ಕಿಮಪಿ ಕರ್ತ್ತುಂ ನ ಶಕ್ನೋಮಿ ಯಥಾ ಶುಣೋಮಿ ತಥಾ ವಿಚಾರಯಾಮಿ ಮಮ ವಿಚಾರಞ್ಚ ನ್ಯಾಯ್ಯಃ ಯತೋಹಂ ಸ್ವೀಯಾಭೀಷ್ಟಂ ನೇಹಿತ್ವಾ ಮತ್ಪ್ರೇರಯಿತುಃ ಪಿತುರಿಷ್ಟಮ್ ಈಹೇ| ");
INSERT INTO sankan_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","ಯದಿ ಸ್ವಸ್ಮಿನ್ ಸ್ವಯಂ ಸಾಕ್ಷ್ಯಂ ದದಾಮಿ ತರ್ಹಿ ತತ್ಸಾಕ್ಷ್ಯಮ್ ಆಗ್ರಾಹ್ಯಂ ಭವತಿ ; ");
INSERT INTO sankan_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","ಕಿನ್ತು ಮದರ್ಥೇಽಪರೋ ಜನಃ ಸಾಕ್ಷ್ಯಂ ದದಾತಿ ಮದರ್ಥೇ ತಸ್ಯ ಯತ್ ಸಾಕ್ಷ್ಯಂ ತತ್ ಸತ್ಯಮ್ ಏತದಪ್ಯಹಂ ಜಾನಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","ಯುಷ್ಮಾಭಿ ರ್ಯೋಹನಂ ಪ್ರತಿ ಲೋಕೇಷು ಪ್ರೇರಿತೇಷು ಸ ಸತ್ಯಕಥಾಯಾಂ ಸಾಕ್ಷ್ಯಮದದಾತ್| ");
INSERT INTO sankan_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","ಮಾನುಷಾದಹಂ ಸಾಕ್ಷ್ಯಂ ನೋಪೇಕ್ಷೇ ತಥಾಪಿ ಯೂಯಂ ಯಥಾ ಪರಿತ್ರಯಧ್ವೇ ತದರ್ಥಮ್ ಇದಂ ವಾಕ್ಯಂ ವದಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","ಯೋಹನ್ ದೇದೀಪ್ಯಮಾನೋ ದೀಪ ಇವ ತೇಜಸ್ವೀ ಸ್ಥಿತವಾನ್ ಯೂಯಮ್ ಅಲ್ಪಕಾಲಂ ತಸ್ಯ ದೀಪ್ತ್ಯಾನನ್ದಿತುಂ ಸಮಮನ್ಯಧ್ವಂ| ");
INSERT INTO sankan_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","ಕಿನ್ತು ತತ್ಪ್ರಮಾಣಾದಪಿ ಮಮ ಗುರುತರಂ ಪ್ರಮಾಣಂ ವಿದ್ಯತೇ ಪಿತಾ ಮಾಂ ಪ್ರೇಷ್ಯ ಯದ್ಯತ್ ಕರ್ಮ್ಮ ಸಮಾಪಯಿತುಂ ಶಕ್ತ್ತಿಮದದಾತ್ ಮಯಾ ಕೃತಂ ತತ್ತತ್ ಕರ್ಮ್ಮ ಮದರ್ಥೇ ಪ್ರಮಾಣಂ ದದಾತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ಯಃ ಪಿತಾ ಮಾಂ ಪ್ರೇರಿತವಾನ್ ಮೋಪಿ ಮದರ್ಥೇ ಪ್ರಮಾಣಂ ದದಾತಿ| ತಸ್ಯ ವಾಕ್ಯಂ ಯುಷ್ಮಾಭಿಃ ಕದಾಪಿ ನ ಶ್ರುತಂ ತಸ್ಯ ರೂಪಞ್ಚ ನ ದೃಷ್ಟಂ ");
INSERT INTO sankan_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ತಸ್ಯ ವಾಕ್ಯಞ್ಚ ಯುಷ್ಮಾಕಮ್ ಅನ್ತಃ ಕದಾಪಿ ಸ್ಥಾನಂ ನಾಪ್ನೋತಿ ಯತಃ ಸ ಯಂ ಪ್ರೇಷಿತವಾನ್ ಯೂಯಂ ತಸ್ಮಿನ್ ನ ವಿಶ್ವಸಿಥ| ");
INSERT INTO sankan_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","ಧರ್ಮ್ಮಪುಸ್ತಕಾನಿ ಯೂಯಮ್ ಆಲೋಚಯಧ್ವಂ ತೈ ರ್ವಾಕ್ಯೈರನನ್ತಾಯುಃ ಪ್ರಾಪ್ಸ್ಯಾಮ ಇತಿ ಯೂಯಂ ಬುಧ್ಯಧ್ವೇ ತದ್ಧರ್ಮ್ಮಪುಸ್ತಕಾನಿ ಮದರ್ಥೇ ಪ್ರಮಾಣಂ ದದತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ತಥಾಪಿ ಯೂಯಂ ಪರಮಾಯುಃಪ್ರಾಪ್ತಯೇ ಮಮ ಸಂನಿಧಿಮ್ ನ ಜಿಗಮಿಷಥ| ");
INSERT INTO sankan_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","ಅಹಂ ಮಾನುಷೇಭ್ಯಃ ಸತ್ಕಾರಂ ನ ಗೃಹ್ಲಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ಅಹಂ ಯುಷ್ಮಾನ್ ಜಾನಾಮಿ; ಯುಷ್ಮಾಕಮನ್ತರ ಈಶ್ವರಪ್ರೇಮ ನಾಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ಅಹಂ ನಿಜಪಿತು ರ್ನಾಮ್ನಾಗತೋಸ್ಮಿ ತಥಾಪಿ ಮಾಂ ನ ಗೃಹ್ಲೀಥ ಕಿನ್ತು ಕಶ್ಚಿದ್ ಯದಿ ಸ್ವನಾಮ್ನಾ ಸಮಾಗಮಿಷ್ಯತಿ ತರ್ಹಿ ತಂ ಗ್ರಹೀಷ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","ಯೂಯಮ್ ಈಶ್ವರಾತ್ ಸತ್ಕಾರಂ ನ ಚಿಷ್ಟತ್ವಾ ಕೇವಲಂ ಪರಸ್ಪರಂ ಸತ್ಕಾರಮ್ ಚೇದ್ ಆದಧ್ವ್ವೇ ತರ್ಹಿ ಕಥಂ ವಿಶ್ವಸಿತುಂ ಶಕ್ನುಥ? ");
INSERT INTO sankan_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","ಪುತುಃ ಸಮೀಪೇಽಹಂ ಯುಷ್ಮಾನ್ ಅಪವದಿಷ್ಯಾಮೀತಿ ಮಾ ಚಿನ್ತಯತ ಯಸ್ಮಿನ್ , ಯಸ್ಮಿನ್ ಯುಷ್ಮಾಕಂ ವಿಶ್ವಸಃ ಸಏವ ಮೂಸಾ ಯುಷ್ಮಾನ್ ಅಪವದತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","ಯದಿ ಯೂಯಂ ತಸ್ಮಿನ್ ವ್ಯಶ್ವಸಿಷ್ಯತ ತರ್ಹಿ ಮಯ್ಯಪಿ ವ್ಯಶ್ವಸಿಷ್ಯತ, ಯತ್ ಸ ಮಯಿ ಲಿಖಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","ತತೋ ಯದಿ ತೇನ ಲಿಖಿತವಾನಿ ನ ಪ್ರತಿಥ ತರ್ಹಿ ಮಮ ವಾಕ್ಯಾನಿ ಕಥಂ ಪ್ರತ್ಯೇಷ್ಯಥ? ");
INSERT INTO sankan_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","ತತಃ ಪರಂ ಯೀಶು ರ್ಗಾಲೀಲ್ ಪ್ರದೇಶೀಯಸ್ಯ ತಿವಿರಿಯಾನಾಮ್ನಃ ಸಿನ್ಧೋಃ ಪಾರಂ ಗತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ತತೋ ವ್ಯಾಧಿಮಲ್ಲೋಕಸ್ವಾಸ್ಥ್ಯಕರಣರೂಪಾಣಿ ತಸ್ಯಾಶ್ಚರ್ಯ್ಯಾಣಿ ಕರ್ಮ್ಮಾಣಿ ದೃಷ್ಟ್ವಾ ಬಹವೋ ಜನಾಸ್ತತ್ಪಶ್ಚಾದ್ ಅಗಚ್ಛನ್| ");
INSERT INTO sankan_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ತತೋ ಯೀಶುಃ ಪರ್ವ್ವತಮಾರುಹ್ಯ ತತ್ರ ಶಿಷ್ಯೈಃ ಸಾಕಮ್| ");
INSERT INTO sankan_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","ತಸ್ಮಿನ್ ಸಮಯ ನಿಸ್ತಾರೋತ್ಸವನಾಮ್ನಿ ಯಿಹೂದೀಯಾನಾಮ ಉತ್ಸವ ಉಪಸ್ಥಿತೇ ");
INSERT INTO sankan_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","ಯೀಶು ರ್ನೇತ್ರೇ ಉತ್ತೋಲ್ಯ ಬಹುಲೋಕಾನ್ ಸ್ವಸಮೀಪಾಗತಾನ್ ವಿಲೋಕ್ಯ ಫಿಲಿಪಂ ಪೃಷ್ಟವಾನ್ ಏತೇಷಾಂ ಭೋಜನಾಯ ಭೋಜದ್ರವ್ಯಾಣಿ ವಯಂ ಕುತ್ರ ಕ್ರೇತುಂ ಶಕ್ರುಮಃ? ");
INSERT INTO sankan_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ವಾಕ್ಯಮಿದಂ ತಸ್ಯ ಪರೀಕ್ಷಾರ್ಥಮ್ ಅವಾದೀತ್ ಕಿನ್ತು ಯತ್ ಕರಿಷ್ಯತಿ ತತ್ ಸ್ವಯಮ್ ಅಜಾನಾತ್| ");
INSERT INTO sankan_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ಫಿಲಿಪಃ ಪ್ರತ್ಯವೋಚತ್ ಏತೇಷಾಮ್ ಏಕೈಕೋ ಯದ್ಯಲ್ಪಮ್ ಅಲ್ಪಂ ಪ್ರಾಪ್ನೋತಿ ತರ್ಹಿ ಮುದ್ರಾಪಾದದ್ವಿಶತೇನ ಕ್ರೀತಪೂಪಾ ಅಪಿ ನ್ಯೂನಾ ಭವಿಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ಶಿಮೋನ್ ಪಿತರಸ್ಯ ಭ್ರಾತಾ ಆನ್ದ್ರಿಯಾಖ್ಯಃ ಶಿಷ್ಯಾಣಾಮೇಕೋ ವ್ಯಾಹೃತವಾನ್ ");
INSERT INTO sankan_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","ಅತ್ರ ಕಸ್ಯಚಿದ್ ಬಾಲಕಸ್ಯ ಸಮೀಪೇ ಪಞ್ಚ ಯಾವಪೂಪಾಃ ಕ್ಷುದ್ರಮತ್ಸ್ಯದ್ವಯಞ್ಚ ಸನ್ತಿ ಕಿನ್ತು ಲೋಕಾನಾಂ ಏತಾವಾತಾಂ ಮಧ್ಯೇ ತೈಃ ಕಿಂ ಭವಿಷ್ಯತಿ? ");
INSERT INTO sankan_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","ಪಶ್ಚಾದ್ ಯೀಶುರವದತ್ ಲೋಕಾನುಪವೇಶಯತ ತತ್ರ ಬಹುಯವಸಸತ್ತ್ವಾತ್ ಪಞ್ಚಸಹಸ್ತ್ರೇಭ್ಯೋ ನ್ಯೂನಾ ಅಧಿಕಾ ವಾ ಪುರುಷಾ ಭೂಮ್ಯಾಮ್ ಉಪಾವಿಶನ್| ");
INSERT INTO sankan_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ತತೋ ಯೀಶುಸ್ತಾನ್ ಪೂಪಾನಾದಾಯ ಈಶ್ವರಸ್ಯ ಗುಣಾನ್ ಕೀರ್ತ್ತಯಿತ್ವಾ ಶಿಷ್ಯೇಷು ಸಮಾರ್ಪಯತ್ ತತಸ್ತೇ ತೇಭ್ಯ ಉಪವಿಷ್ಟಲೋಕೇಭ್ಯಃ ಪೂಪಾನ್ ಯಥೇಷ್ಟಮತ್ಸ್ಯಞ್ಚ ಪ್ರಾದುಃ| ");
INSERT INTO sankan_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ತೇಷು ತೃಪ್ತೇಷು ಸ ತಾನವೋಚದ್ ಏತೇಷಾಂ ಕಿಞ್ಚಿದಪಿ ಯಥಾ ನಾಪಚೀಯತೇ ತಥಾ ಸರ್ವ್ವಾಣ್ಯವಶಿಷ್ಟಾನಿ ಸಂಗೃಹ್ಲೀತ| ");
INSERT INTO sankan_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ತತಃ ಸರ್ವ್ವೇಷಾಂ ಭೋಜನಾತ್ ಪರಂ ತೇ ತೇಷಾಂ ಪಞ್ಚಾನಾಂ ಯಾವಪೂಪಾನಾಂ ಅವಶಿಷ್ಟಾನ್ಯಖಿಲಾನಿ ಸಂಗೃಹ್ಯ ದ್ವಾದಶಡಲ್ಲಕಾನ್ ಅಪೂರಯನ್| ");
INSERT INTO sankan_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","ಅಪರಂ ಯೀಶೋರೇತಾದೃಶೀಮ್ ಆಶ್ಚರ್ಯ್ಯಕ್ರಿಯಾಂ ದೃಷ್ಟ್ವಾ ಲೋಕಾ ಮಿಥೋ ವಕ್ತುಮಾರೇಭಿರೇ ಜಗತಿ ಯಸ್ಯಾಗಮನಂ ಭವಿಷ್ಯತಿ ಸ ಏವಾಯಮ್ ಅವಶ್ಯಂ ಭವಿಷ್ಯದ್ವಕ್ತ್ತಾ| ");
INSERT INTO sankan_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ಅತಏವ ಲೋಕಾ ಆಗತ್ಯ ತಮಾಕ್ರಮ್ಯ ರಾಜಾನಂ ಕರಿಷ್ಯನ್ತಿ ಯೀಶುಸ್ತೇಷಾಮ್ ಈದೃಶಂ ಮಾನಸಂ ವಿಜ್ಞಾಯ ಪುನಶ್ಚ ಪರ್ವ್ವತಮ್ ಏಕಾಕೀ ಗತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ಸಾಯಂಕಾಲ ಉಪಸ್ಥಿತೇ ಶಿಷ್ಯಾ ಜಲಧಿತಟಂ ವ್ರಜಿತ್ವಾ ನಾವಮಾರುಹ್ಯ ನಗರದಿಶಿ ಸಿನ್ಧೌ ವಾಹಯಿತ್ವಾಗಮನ್| ");
INSERT INTO sankan_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ತಸ್ಮಿನ್ ಸಮಯೇ ತಿಮಿರ ಉಪಾತಿಷ್ಠತ್ ಕಿನ್ತು ಯೀಷುಸ್ತೇಷಾಂ ಸಮೀಪಂ ನಾಗಚ್ಛತ್| ");
INSERT INTO sankan_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ತದಾ ಪ್ರಬಲಪವನವಹನಾತ್ ಸಾಗರೇ ಮಹಾತರಙ್ಗೋ ಭವಿತುಮ್ ಆರೇಭೇ| ");
INSERT INTO sankan_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ತತಸ್ತೇ ವಾಹಯಿತ್ವಾ ದ್ವಿತ್ರಾನ್ ಕ್ರೋಶಾನ್ ಗತಾಃ ಪಶ್ಚಾದ್ ಯೀಶುಂ ಜಲಧೇರುಪರಿ ಪದ್ಭ್ಯಾಂ ವ್ರಜನ್ತಂ ನೌಕಾನ್ತಿಕಮ್ ಆಗಚ್ಛನ್ತಂ ವಿಲೋಕ್ಯ ತ್ರಾಸಯುಕ್ತಾ ಅಭವನ್ ");
INSERT INTO sankan_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ಕಿನ್ತು ಸ ತಾನುಕ್ತ್ತವಾನ್ ಅಯಮಹಂ ಮಾ ಭೈಷ್ಟ| ");
INSERT INTO sankan_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ತದಾ ತೇ ತಂ ಸ್ವೈರಂ ನಾವಿ ಗೃಹೀತವನ್ತಃ ತದಾ ತತ್ಕ್ಷಣಾದ್ ಉದ್ದಿಷ್ಟಸ್ಥಾನೇ ನೌರುಪಾಸ್ಥಾತ್| ");
INSERT INTO sankan_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","ಯಯಾ ನಾವಾ ಶಿಷ್ಯಾ ಅಗಚ್ಛನ್ ತದನ್ಯಾ ಕಾಪಿ ನೌಕಾ ತಸ್ಮಿನ್ ಸ್ಥಾನೇ ನಾಸೀತ್ ತತೋ ಯೀಶುಃ ಶಿಷ್ಯೈಃ ಸಾಕಂ ನಾಗಮತ್ ಕೇವಲಾಃ ಶಿಷ್ಯಾ ಅಗಮನ್ ಏತತ್ ಪಾರಸ್ಥಾ ಲೋಕಾ ಜ್ಞಾತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","ಕಿನ್ತು ತತಃ ಪರಂ ಪ್ರಭು ರ್ಯತ್ರ ಈಶ್ವರಸ್ಯ ಗುಣಾನ್ ಅನುಕೀರ್ತ್ತ್ಯ ಲೋಕಾನ್ ಪೂಪಾನ್ ಅಭೋಜಯತ್ ತತ್ಸ್ಥಾನಸ್ಯ ಸಮೀಪಸ್ಥತಿವಿರಿಯಾಯಾ ಅಪರಾಸ್ತರಣಯ ಆಗಮನ್| ");
INSERT INTO sankan_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","ಯೀಶುಸ್ತತ್ರ ನಾಸ್ತಿ ಶಿಷ್ಯಾ ಅಪಿ ತತ್ರ ನಾ ಸನ್ತಿ ಲೋಕಾ ಇತಿ ವಿಜ್ಞಾಯ ಯೀಶುಂ ಗವೇಷಯಿತುಂ ತರಣಿಭಿಃ ಕಫರ್ನಾಹೂಮ್ ಪುರಂ ಗತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","ತತಸ್ತೇ ಸರಿತ್ಪತೇಃ ಪಾರೇ ತಂ ಸಾಕ್ಷಾತ್ ಪ್ರಾಪ್ಯ ಪ್ರಾವೋಚನ್ ಹೇ ಗುರೋ ಭವಾನ್ ಅತ್ರ ಸ್ಥಾನೇ ಕದಾಗಮತ್? ");
INSERT INTO sankan_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","ತದಾ ಯೀಶುಸ್ತಾನ್ ಪ್ರತ್ಯವಾದೀದ್ ಯುಷ್ಮಾನಹಂ ಯಥಾರ್ಥತರಂ ವದಾಮಿ ಆಶ್ಚರ್ಯ್ಯಕರ್ಮ್ಮದರ್ಶನಾದ್ಧೇತೋ ರ್ನ ಕಿನ್ತು ಪೂಪಭೋಜನಾತ್ ತೇನ ತೃಪ್ತತ್ವಾಞ್ಚ ಮಾಂ ಗವೇಷಯಥ| ");
INSERT INTO sankan_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ಕ್ಷಯಣೀಯಭಕ್ಷ್ಯಾರ್ಥಂ ಮಾ ಶ್ರಾಮಿಷ್ಟ ಕಿನ್ತ್ವನ್ತಾಯುರ್ಭಕ್ಷ್ಯಾರ್ಥಂ ಶ್ರಾಮ್ಯತ, ತಸ್ಮಾತ್ ತಾದೃಶಂ ಭಕ್ಷ್ಯಂ ಮನುಜಪುತ್ರೋ ಯುಷ್ಮಾಭ್ಯಂ ದಾಸ್ಯತಿ; ತಸ್ಮಿನ್ ತಾತ ಈಶ್ವರಃ ಪ್ರಮಾಣಂ ಪ್ರಾದಾತ್| ");
INSERT INTO sankan_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","ತದಾ ತೇಽಪೃಚ್ಛನ್ ಈಶ್ವರಾಭಿಮತಂ ಕರ್ಮ್ಮ ಕರ್ತ್ತುಮ್ ಅಸ್ಮಾಭಿಃ ಕಿಂ ಕರ್ತ್ತವ್ಯಂ? ");
INSERT INTO sankan_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","ತತೋ ಯೀಶುರವದದ್ ಈಶ್ವರೋ ಯಂ ಪ್ರೈರಯತ್ ತಸ್ಮಿನ್ ವಿಶ್ವಸನಮ್ ಈಶ್ವರಾಭಿಮತಂ ಕರ್ಮ್ಮ| ");
INSERT INTO sankan_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","ತದಾ ತೇ ವ್ಯಾಹರನ್ ಭವತಾ ಕಿಂ ಲಕ್ಷಣಂ ದರ್ಶಿತಂ ಯದ್ದೃಷ್ಟ್ವಾ ಭವತಿ ವಿಶ್ವಸಿಷ್ಯಾಮಃ? ತ್ವಯಾ ಕಿಂ ಕರ್ಮ್ಮ ಕೃತಂ? ");
INSERT INTO sankan_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","ಅಸ್ಮಾಕಂ ಪೂರ್ವ್ವಪುರುಷಾ ಮಹಾಪ್ರಾನ್ತರೇ ಮಾನ್ನಾಂ ಭೋಕ್ತ್ತುಂ ಪ್ರಾಪುಃ ಯಥಾ ಲಿಪಿರಾಸ್ತೇ| ಸ್ವರ್ಗೀಯಾಣಿ ತು ಭಕ್ಷ್ಯಾಣಿ ಪ್ರದದೌ ಪರಮೇಶ್ವರಃ| ");
INSERT INTO sankan_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","ತದಾ ಯೀಶುರವದದ್ ಅಹಂ ಯುಷ್ಮಾನತಿಯಥಾರ್ಥಂ ವದಾಮಿ ಮೂಸಾ ಯುಷ್ಮಾಭ್ಯಂ ಸ್ವರ್ಗೀಯಂ ಭಕ್ಷ್ಯಂ ನಾದಾತ್ ಕಿನ್ತು ಮಮ ಪಿತಾ ಯುಷ್ಮಾಭ್ಯಂ ಸ್ವರ್ಗೀಯಂ ಪರಮಂ ಭಕ್ಷ್ಯಂ ದದಾತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ಯಃ ಸ್ವರ್ಗಾದವರುಹ್ಯ ಜಗತೇ ಜೀವನಂ ದದಾತಿ ಸ ಈಶ್ವರದತ್ತಭಕ್ಷ್ಯರೂಪಃ| ");
INSERT INTO sankan_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","ತದಾ ತೇ ಪ್ರಾವೋಚನ್ ಹೇ ಪ್ರಭೋ ಭಕ್ಷ್ಯಮಿದಂ ನಿತ್ಯಮಸ್ಮಭ್ಯಂ ದದಾತು| ");
INSERT INTO sankan_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","ಯೀಶುರವದದ್ ಅಹಮೇವ ಜೀವನರೂಪಂ ಭಕ್ಷ್ಯಂ ಯೋ ಜನೋ ಮಮ ಸನ್ನಿಧಿಮ್ ಆಗಚ್ಛತಿ ಸ ಜಾತು ಕ್ಷುಧಾರ್ತ್ತೋ ನ ಭವಿಷ್ಯತಿ, ತಥಾ ಯೋ ಜನೋ ಮಾಂ ಪ್ರತ್ಯೇತಿ ಸ ಜಾತು ತೃಷಾರ್ತ್ತೋ ನ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","ಮಾಂ ದೃಷ್ಟ್ವಾಪಿ ಯೂಯಂ ನ ವಿಶ್ವಸಿಥ ಯುಷ್ಮಾನಹಮ್ ಇತ್ಯವೋಚಂ| ");
INSERT INTO sankan_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","ಪಿತಾ ಮಹ್ಯಂ ಯಾವತೋ ಲೋಕಾನದದಾತ್ ತೇ ಸರ್ವ್ವ ಏವ ಮಮಾನ್ತಿಕಮ್ ಆಗಮಿಷ್ಯನ್ತಿ ಯಃ ಕಶ್ಚಿಚ್ಚ ಮಮ ಸನ್ನಿಧಿಮ್ ಆಯಾಸ್ಯತಿ ತಂ ಕೇನಾಪಿ ಪ್ರಕಾರೇಣ ನ ದೂರೀಕರಿಷ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ನಿಜಾಭಿಮತಂ ಸಾಧಯಿತುಂ ನ ಹಿ ಕಿನ್ತು ಪ್ರೇರಯಿತುರಭಿಮತಂ ಸಾಧಯಿತುಂ ಸ್ವರ್ಗಾದ್ ಆಗತೋಸ್ಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ಸ ಯಾನ್ ಯಾನ್ ಲೋಕಾನ್ ಮಹ್ಯಮದದಾತ್ ತೇಷಾಮೇಕಮಪಿ ನ ಹಾರಯಿತ್ವಾ ಶೇಷದಿನೇ ಸರ್ವ್ವಾನಹಮ್ ಉತ್ಥಾಪಯಾಮಿ ಇದಂ ಮತ್ಪ್ರೇರಯಿತುಃ ಪಿತುರಭಿಮತಂ| ");
INSERT INTO sankan_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","ಯಃ ಕಶ್ಚಿನ್ ಮಾನವಸುತಂ ವಿಲೋಕ್ಯ ವಿಶ್ವಸಿತಿ ಸ ಶೇಷದಿನೇ ಮಯೋತ್ಥಾಪಿತಃ ಸನ್ ಅನನ್ತಾಯುಃ ಪ್ರಾಪ್ಸ್ಯತಿ ಇತಿ ಮತ್ಪ್ರೇರಕಸ್ಯಾಭಿಮತಂ| ");
INSERT INTO sankan_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","ತದಾ ಸ್ವರ್ಗಾದ್ ಯದ್ ಭಕ್ಷ್ಯಮ್ ಅವಾರೋಹತ್ ತದ್ ಭಕ್ಷ್ಯಮ್ ಅಹಮೇವ ಯಿಹೂದೀಯಲೋಕಾಸ್ತಸ್ಯೈತದ್ ವಾಕ್ಯೇ ವಿವದಮಾನಾ ವಕ್ತ್ತುಮಾರೇಭಿರೇ ");
INSERT INTO sankan_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ಯೂಷಫಃ ಪುತ್ರೋ ಯೀಶು ರ್ಯಸ್ಯ ಮಾತಾಪಿತರೌ ವಯಂ ಜಾನೀಮ ಏಷ ಕಿಂ ಸಏವ ನ? ತರ್ಹಿ ಸ್ವರ್ಗಾದ್ ಅವಾರೋಹಮ್ ಇತಿ ವಾಕ್ಯಂ ಕಥಂ ವಕ್ತ್ತಿ? ");
INSERT INTO sankan_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","ತದಾ ಯೀಶುಸ್ತಾನ್ ಪ್ರತ್ಯವದತ್ ಪರಸ್ಪರಂ ಮಾ ವಿವದಧ್ವಂ ");
INSERT INTO sankan_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","ಮತ್ಪ್ರೇರಕೇಣ ಪಿತ್ರಾ ನಾಕೃಷ್ಟಃ ಕೋಪಿ ಜನೋ ಮಮಾನ್ತಿಕಮ್ ಆಯಾತುಂ ನ ಶಕ್ನೋತಿ ಕಿನ್ತ್ವಾಗತಂ ಜನಂ ಚರಮೇಽಹ್ನಿ ಪ್ರೋತ್ಥಾಪಯಿಷ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","ತೇ ಸರ್ವ್ವ ಈಶ್ವರೇಣ ಶಿಕ್ಷಿತಾ ಭವಿಷ್ಯನ್ತಿ ಭವಿಷ್ಯದ್ವಾದಿನಾಂ ಗ್ರನ್ಥೇಷು ಲಿಪಿರಿತ್ಥಮಾಸ್ತೇ ಅತೋ ಯಃ ಕಶ್ಚಿತ್ ಪಿತುಃ ಸಕಾಶಾತ್ ಶ್ರುತ್ವಾ ಶಿಕ್ಷತೇ ಸ ಏವ ಮಮ ಸಮೀಪಮ್ ಆಗಮಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ಯ ಈಶ್ವರಾದ್ ಅಜಾಯತ ತಂ ವಿನಾ ಕೋಪಿ ಮನುಷ್ಯೋ ಜನಕಂ ನಾದರ್ಶತ್ ಕೇವಲಃ ಸಏವ ತಾತಮ್ ಅದ್ರಾಕ್ಷೀತ್| ");
INSERT INTO sankan_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","ಅಹಂ ಯುಷ್ಮಾನ್ ಯಥಾರ್ಥತರಂ ವದಾಮಿ ಯೋ ಜನೋ ಮಯಿ ವಿಶ್ವಾಸಂ ಕರೋತಿ ಸೋನನ್ತಾಯುಃ ಪ್ರಾಪ್ನೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ಅಹಮೇವ ತಜ್ಜೀವನಭಕ್ಷ್ಯಂ| ");
INSERT INTO sankan_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","ಯುಷ್ಮಾಕಂ ಪೂರ್ವ್ವಪುರುಷಾ ಮಹಾಪ್ರಾನ್ತರೇ ಮನ್ನಾಭಕ್ಷ್ಯಂ ಭೂಕ್ತ್ತಾಪಿ ಮೃತಾಃ ");
INSERT INTO sankan_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","ಕಿನ್ತು ಯದ್ಭಕ್ಷ್ಯಂ ಸ್ವರ್ಗಾದಾಗಚ್ಛತ್ ತದ್ ಯದಿ ಕಶ್ಚಿದ್ ಭುಙ್ಕ್ತ್ತೇ ತರ್ಹಿ ಸ ನ ಮ್ರಿಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","ಯಜ್ಜೀವನಭಕ್ಷ್ಯಂ ಸ್ವರ್ಗಾದಾಗಚ್ಛತ್ ಸೋಹಮೇವ ಇದಂ ಭಕ್ಷ್ಯಂ ಯೋ ಜನೋ ಭುಙ್ಕ್ತ್ತೇ ಸ ನಿತ್ಯಜೀವೀ ಭವಿಷ್ಯತಿ| ಪುನಶ್ಚ ಜಗತೋ ಜೀವನಾರ್ಥಮಹಂ ಯತ್ ಸ್ವಕೀಯಪಿಶಿತಂ ದಾಸ್ಯಾಮಿ ತದೇವ ಮಯಾ ವಿತರಿತಂ ಭಕ್ಷ್ಯಮ್| ");
INSERT INTO sankan_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","ತಸ್ಮಾದ್ ಯಿಹೂದೀಯಾಃ ಪರಸ್ಪರಂ ವಿವದಮಾನಾ ವಕ್ತ್ತುಮಾರೇಭಿರೇ ಏಷ ಭೋಜನಾರ್ಥಂ ಸ್ವೀಯಂ ಪಲಲಂ ಕಥಮ್ ಅಸ್ಮಭ್ಯಂ ದಾಸ್ಯತಿ? ");
INSERT INTO sankan_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ತದಾ ಯೀಶುಸ್ತಾನ್ ಆವೋಚದ್ ಯುಷ್ಮಾನಹಂ ಯಥಾರ್ಥತರಂ ವದಾಮಿ ಮನುಷ್ಯಪುತ್ರಸ್ಯಾಮಿಷೇ ಯುಷ್ಮಾಭಿ ರ್ನ ಭುಕ್ತ್ತೇ ತಸ್ಯ ರುಧಿರೇ ಚ ನ ಪೀತೇ ಜೀವನೇನ ಸಾರ್ದ್ಧಂ ಯುಷ್ಮಾಕಂ ಸಮ್ಬನ್ಧೋ ನಾಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ಯೋ ಮಮಾಮಿಷಂ ಸ್ವಾದತಿ ಮಮ ಸುಧಿರಞ್ಚ ಪಿವತಿ ಸೋನನ್ತಾಯುಃ ಪ್ರಾಪ್ನೋತಿ ತತಃ ಶೇಷೇಽಹ್ನಿ ತಮಹಮ್ ಉತ್ಥಾಪಯಿಷ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","ಯತೋ ಮದೀಯಮಾಮಿಷಂ ಪರಮಂ ಭಕ್ಷ್ಯಂ ತಥಾ ಮದೀಯಂ ಶೋಣಿತಂ ಪರಮಂ ಪೇಯಂ| ");
INSERT INTO sankan_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ಯೋ ಜನೋ ಮದೀಯಂ ಪಲಲಂ ಸ್ವಾದತಿ ಮದೀಯಂ ರುಧಿರಞ್ಚ ಪಿವತಿ ಸ ಮಯಿ ವಸತಿ ತಸ್ಮಿನ್ನಹಞ್ಚ ವಸಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","ಮತ್ಪ್ರೇರಯಿತ್ರಾ ಜೀವತಾ ತಾತೇನ ಯಥಾಹಂ ಜೀವಾಮಿ ತದ್ವದ್ ಯಃ ಕಶ್ಚಿನ್ ಮಾಮತ್ತಿ ಸೋಪಿ ಮಯಾ ಜೀವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","ಯದ್ಭಕ್ಷ್ಯಂ ಸ್ವರ್ಗಾದಾಗಚ್ಛತ್ ತದಿದಂ ಯನ್ಮಾನ್ನಾಂ ಸ್ವಾದಿತ್ವಾ ಯುಷ್ಮಾಕಂ ಪಿತರೋಽಮ್ರಿಯನ್ತ ತಾದೃಶಮ್ ಇದಂ ಭಕ್ಷ್ಯಂ ನ ಭವತಿ ಇದಂ ಭಕ್ಷ್ಯಂ ಯೋ ಭಕ್ಷತಿ ಸ ನಿತ್ಯಂ ಜೀವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ಯದಾ ಕಫರ್ನಾಹೂಮ್ ಪುರ್ಯ್ಯಾಂ ಭಜನಗೇಹೇ ಉಪಾದಿಶತ್ ತದಾ ಕಥಾ ಏತಾ ಅಕಥಯತ್| ");
INSERT INTO sankan_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","ತದೇತ್ಥಂ ಶ್ರುತ್ವಾ ತಸ್ಯ ಶಿಷ್ಯಾಣಾಮ್ ಅನೇಕೇ ಪರಸ್ಪರಮ್ ಅಕಥಯನ್ ಇದಂ ಗಾಢಂ ವಾಕ್ಯಂ ವಾಕ್ಯಮೀದೃಶಂ ಕಃ ಶ್ರೋತುಂ ಶಕ್ರುಯಾತ್? ");
INSERT INTO sankan_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","ಕಿನ್ತು ಯೀಶುಃ ಶಿಷ್ಯಾಣಾಮ್ ಇತ್ಥಂ ವಿವಾದಂ ಸ್ವಚಿತ್ತೇ ವಿಜ್ಞಾಯ ಕಥಿತವಾನ್ ಇದಂ ವಾಕ್ಯಂ ಕಿಂ ಯುಷ್ಮಾಕಂ ವಿಘ್ನಂ ಜನಯತಿ? ");
INSERT INTO sankan_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","ಯದಿ ಮನುಜಸುತಂ ಪೂರ್ವ್ವವಾಸಸ್ಥಾನಮ್ ಊರ್ದ್ವ್ವಂ ಗಚ್ಛನ್ತಂ ಪಶ್ಯಥ ತರ್ಹಿ ಕಿಂ ಭವಿಷ್ಯತಿ? ");
INSERT INTO sankan_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","ಆತ್ಮೈವ ಜೀವನದಾಯಕಃ ವಪು ರ್ನಿಷ್ಫಲಂ ಯುಷ್ಮಭ್ಯಮಹಂ ಯಾನಿ ವಚಾಂಸಿ ಕಥಯಾಮಿ ತಾನ್ಯಾತ್ಮಾ ಜೀವನಞ್ಚ| ");
INSERT INTO sankan_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","ಕಿನ್ತು ಯುಷ್ಮಾಕಂ ಮಧ್ಯೇ ಕೇಚನ ಅವಿಶ್ವಾಸಿನಃ ಸನ್ತಿ ಕೇ ಕೇ ನ ವಿಶ್ವಸನ್ತಿ ಕೋ ವಾ ತಂ ಪರಕರೇಷು ಸಮರ್ಪಯಿಷ್ಯತಿ ತಾನ್ ಯೀಶುರಾಪ್ರಥಮಾದ್ ವೇತ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","ಅಪರಮಪಿ ಕಥಿತವಾನ್ ಅಸ್ಮಾತ್ ಕಾರಣಾದ್ ಅಕಥಯಂ ಪಿತುಃ ಸಕಾಶಾತ್ ಶಕ್ತ್ತಿಮಪ್ರಾಪ್ಯ ಕೋಪಿ ಮಮಾನ್ತಿಕಮ್ ಆಗನ್ತುಂ ನ ಶಕ್ನೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","ತತ್ಕಾಲೇಽನೇಕೇ ಶಿಷ್ಯಾ ವ್ಯಾಘುಟ್ಯ ತೇನ ಸಾರ್ದ್ಧಂ ಪುನ ರ್ನಾಗಚ್ಛನ್| ");
INSERT INTO sankan_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","ತದಾ ಯೀಶು ರ್ದ್ವಾದಶಶಿಷ್ಯಾನ್ ಉಕ್ತ್ತವಾನ್ ಯೂಯಮಪಿ ಕಿಂ ಯಾಸ್ಯಥ? ");
INSERT INTO sankan_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ತತಃ ಶಿಮೋನ್ ಪಿತರಃ ಪ್ರತ್ಯವೋಚತ್ ಹೇ ಪ್ರಭೋ ಕಸ್ಯಾಭ್ಯರ್ಣಂ ಗಮಿಷ್ಯಾಮಃ? ");
INSERT INTO sankan_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ಅನನ್ತಜೀವನದಾಯಿನ್ಯೋ ಯಾಃ ಕಥಾಸ್ತಾಸ್ತವೈವ| ಭವಾನ್ ಅಮರೇಶ್ವರಸ್ಯಾಭಿಷಿಕ್ತ್ತಪುತ್ರ ಇತಿ ವಿಶ್ವಸ್ಯ ನಿಶ್ಚಿತಂ ಜಾನೀಮಃ| ");
INSERT INTO sankan_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","ತದಾ ಯೀಶುರವದತ್ ಕಿಮಹಂ ಯುಷ್ಮಾಕಂ ದ್ವಾದಶಜನಾನ್ ಮನೋನೀತಾನ್ ನ ಕೃತವಾನ್? ಕಿನ್ತು ಯುಷ್ಮಾಕಂ ಮಧ್ಯೇಪಿ ಕಶ್ಚಿದೇಕೋ ವಿಘ್ನಕಾರೀ ವಿದ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ಇಮಾಂ ಕಥಂ ಸ ಶಿಮೋನಃ ಪುತ್ರಮ್ ಈಷ್ಕರೀಯೋತೀಯಂ ಯಿಹೂದಾಮ್ ಉದ್ದಿಶ್ಯ ಕಥಿತವಾನ್ ಯತೋ ದ್ವಾದಶಾನಾಂ ಮಧ್ಯೇ ಗಣಿತಃ ಸ ತಂ ಪರಕರೇಷು ಸಮರ್ಪಯಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ತತಃ ಪರಂ ಯಿಹೂದೀಯಲೋಕಾಸ್ತಂ ಹನ್ತುಂ ಸಮೈಹನ್ತ ತಸ್ಮಾದ್ ಯೀಶು ರ್ಯಿಹೂದಾಪ್ರದೇಶೇ ಪರ್ಯ್ಯಟಿತುಂ ನೇಚ್ಛನ್ ಗಾಲೀಲ್ ಪ್ರದೇಶೇ ಪರ್ಯ್ಯಟಿತುಂ ಪ್ರಾರಭತ| ");
INSERT INTO sankan_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","ಕಿನ್ತು ತಸ್ಮಿನ್ ಸಮಯೇ ಯಿಹೂದೀಯಾನಾಂ ದೂಷ್ಯವಾಸನಾಮೋತ್ಸವ ಉಪಸ್ಥಿತೇ ");
INSERT INTO sankan_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ತಸ್ಯ ಭ್ರಾತರಸ್ತಮ್ ಅವದನ್ ಯಾನಿ ಕರ್ಮ್ಮಾಣಿ ತ್ವಯಾ ಕ್ರಿಯನ್ತೇ ತಾನಿ ಯಥಾ ತವ ಶಿಷ್ಯಾಃ ಪಶ್ಯನ್ತಿ ತದರ್ಥಂ ತ್ವಮಿತಃ ಸ್ಥಾನಾದ್ ಯಿಹೂದೀಯದೇಶಂ ವ್ರಜ| ");
INSERT INTO sankan_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ಯಃ ಕಶ್ಚಿತ್ ಸ್ವಯಂ ಪ್ರಚಿಕಾಶಿಷತಿ ಸ ಕದಾಪಿ ಗುಪ್ತಂ ಕರ್ಮ್ಮ ನ ಕರೋತಿ ಯದೀದೃಶಂ ಕರ್ಮ್ಮ ಕರೋಷಿ ತರ್ಹಿ ಜಗತಿ ನಿಜಂ ಪರಿಚಾಯಯ| ");
INSERT INTO sankan_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ಯತಸ್ತಸ್ಯ ಭ್ರಾತರೋಪಿ ತಂ ನ ವಿಶ್ವಸನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","ತದಾ ಯೀಶುಸ್ತಾನ್ ಅವೋಚತ್ ಮಮ ಸಮಯ ಇದಾನೀಂ ನೋಪತಿಷ್ಠತಿ ಕಿನ್ತು ಯುಷ್ಮಾಕಂ ಸಮಯಃ ಸತತಮ್ ಉಪತಿಷ್ಠತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","ಜಗತೋ ಲೋಕಾ ಯುಷ್ಮಾನ್ ಋತೀಯಿತುಂ ನ ಶಕ್ರುವನ್ತಿ ಕಿನ್ತು ಮಾಮೇವ ಋತೀಯನ್ತೇ ಯತಸ್ತೇಷಾಂ ಕರ್ಮಾಣಿ ದುಷ್ಟಾನಿ ತತ್ರ ಸಾಕ್ಷ್ಯಮಿದಮ್ ಅಹಂ ದದಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","ಅತಏವ ಯೂಯಮ್ ಉತ್ಸವೇಽಸ್ಮಿನ್ ಯಾತ ನಾಹಮ್ ಇದಾನೀಮ್ ಅಸ್ಮಿನ್ನುತ್ಸವೇ ಯಾಮಿ ಯತೋ ಮಮ ಸಮಯ ಇದಾನೀಂ ನ ಸಮ್ಪೂರ್ಣಃ| ");
INSERT INTO sankan_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ಇತಿ ವಾಕ್ಯಮ್ ಉಕ್ತ್ತ್ವಾ ಸ ಗಾಲೀಲಿ ಸ್ಥಿತವಾನ್ ");
INSERT INTO sankan_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","ಕಿನ್ತು ತಸ್ಯ ಭ್ರಾತೃಷು ತತ್ರ ಪ್ರಸ್ಥಿತೇಷು ಸತ್ಸು ಸೋಽಪ್ರಕಟ ಉತ್ಸವಮ್ ಅಗಚ್ಛತ್| ");
INSERT INTO sankan_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","ಅನನ್ತರಮ್ ಉತ್ಸವಮ್ ಉಪಸ್ಥಿತಾ ಯಿಹೂದೀಯಾಸ್ತಂ ಮೃಗಯಿತ್ವಾಪೃಚ್ಛನ್ ಸ ಕುತ್ರ? ");
INSERT INTO sankan_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","ತತೋ ಲೋಕಾನಾಂ ಮಧ್ಯೇ ತಸ್ಮಿನ್ ನಾನಾವಿಧಾ ವಿವಾದಾ ಭವಿತುಮ್ ಆರಬ್ಧವನ್ತಃ| ಕೇಚಿದ್ ಅವೋಚನ್ ಸ ಉತ್ತಮಃ ಪುರುಷಃ ಕೇಚಿದ್ ಅವೋಚನ್ ನ ತಥಾ ವರಂ ಲೋಕಾನಾಂ ಭ್ರಮಂ ಜನಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","ಕಿನ್ತು ಯಿಹೂದೀಯಾನಾಂ ಭಯಾತ್ ಕೋಪಿ ತಸ್ಯ ಪಕ್ಷೇ ಸ್ಪಷ್ಟಂ ನಾಕಥಯತ್| ");
INSERT INTO sankan_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ತತಃ ಪರಮ್ ಉತ್ಸವಸ್ಯ ಮಧ್ಯಸಮಯೇ ಯೀಶು ರ್ಮನ್ದಿರಂ ಗತ್ವಾ ಸಮುಪದಿಶತಿ ಸ್ಮ| ");
INSERT INTO sankan_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ತತೋ ಯಿಹೂದೀಯಾ ಲೋಕಾ ಆಶ್ಚರ್ಯ್ಯಂ ಜ್ಞಾತ್ವಾಕಥಯನ್ ಏಷಾ ಮಾನುಷೋ ನಾಧೀತ್ಯಾ ಕಥಮ್ ಏತಾದೃಶೋ ವಿದ್ವಾನಭೂತ್? ");
INSERT INTO sankan_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","ತದಾ ಯೀಶುಃ ಪ್ರತ್ಯವೋಚದ್ ಉಪದೇಶೋಯಂ ನ ಮಮ ಕಿನ್ತು ಯೋ ಮಾಂ ಪ್ರೇಷಿತವಾನ್ ತಸ್ಯ| ");
INSERT INTO sankan_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","ಯೋ ಜನೋ ನಿದೇಶಂ ತಸ್ಯ ಗ್ರಹೀಷ್ಯತಿ ಮಮೋಪದೇಶೋ ಮತ್ತೋ ಭವತಿ ಕಿಮ್ ಈಶ್ವರಾದ್ ಭವತಿ ಸ ಗನಸ್ತಜ್ಜ್ಞಾತುಂ ಶಕ್ಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","ಯೋ ಜನಃ ಸ್ವತಃ ಕಥಯತಿ ಸ ಸ್ವೀಯಂ ಗೌರವಮ್ ಈಹತೇ ಕಿನ್ತು ಯಃ ಪ್ರೇರಯಿತು ರ್ಗೌರವಮ್ ಈಹತೇ ಸ ಸತ್ಯವಾದೀ ತಸ್ಮಿನ್ ಕೋಪ್ಯಧರ್ಮ್ಮೋ ನಾಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","ಮೂಸಾ ಯುಷ್ಮಭ್ಯಂ ವ್ಯವಸ್ಥಾಗ್ರನ್ಥಂ ಕಿಂ ನಾದದಾತ್? ಕಿನ್ತು ಯುಷ್ಮಾಕಂ ಕೋಪಿ ತಾಂ ವ್ಯವಸ್ಥಾಂ ನ ಸಮಾಚರತಿ| ಮಾಂ ಹನ್ತುಂ ಕುತೋ ಯತಧ್ವೇ? ");
INSERT INTO sankan_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","ತದಾ ಲೋಕಾ ಅವದನ್ ತ್ವಂ ಭೂತಗ್ರಸ್ತಸ್ತ್ವಾಂ ಹನ್ತುಂ ಕೋ ಯತತೇ? ");
INSERT INTO sankan_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ತತೋ ಯೀಶುರವೋಚದ್ ಏಕಂ ಕರ್ಮ್ಮ ಮಯಾಕಾರಿ ತಸ್ಮಾದ್ ಯೂಯಂ ಸರ್ವ್ವ ಮಹಾಶ್ಚರ್ಯ್ಯಂ ಮನ್ಯಧ್ವೇ| ");
INSERT INTO sankan_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","ಮೂಸಾ ಯುಷ್ಮಭ್ಯಂ ತ್ವಕ್ಛೇದವಿಧಿಂ ಪ್ರದದೌ ಸ ಮೂಸಾತೋ ನ ಜಾತಃ ಕಿನ್ತು ಪಿತೃಪುರುಷೇಭ್ಯೋ ಜಾತಃ ತೇನ ವಿಶ್ರಾಮವಾರೇಽಪಿ ಮಾನುಷಾಣಾಂ ತ್ವಕ್ಛೇದಂ ಕುರುಥ| ");
INSERT INTO sankan_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ಅತಏವ ವಿಶ್ರಾಮವಾರೇ ಮನುಷ್ಯಾಣಾಂ ತ್ವಕ್ಛೇದೇ ಕೃತೇ ಯದಿ ಮೂಸಾವ್ಯವಸ್ಥಾಮಙ್ಗನಂ ನ ಭವತಿ ತರ್ಹಿ ಮಯಾ ವಿಶ್ರಾಮವಾರೇ ಮಾನುಷಃ ಸಮ್ಪೂರ್ಣರೂಪೇಣ ಸ್ವಸ್ಥೋಽಕಾರಿ ತತ್ಕಾರಣಾದ್ ಯೂಯಂ ಕಿಂ ಮಹ್ಯಂ ಕುಪ್ಯಥ? ");
INSERT INTO sankan_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","ಸಪಕ್ಷಪಾತಂ ವಿಚಾರಮಕೃತ್ವಾ ನ್ಯಾಯ್ಯಂ ವಿಚಾರಂ ಕುರುತ| ");
INSERT INTO sankan_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","ತದಾ ಯಿರೂಶಾಲಮ್ ನಿವಾಸಿನಃ ಕತಿಪಯಜನಾ ಅಕಥಯನ್ ಇಮೇ ಯಂ ಹನ್ತುಂ ಚೇಷ್ಟನ್ತೇ ಸ ಏವಾಯಂ ಕಿಂ ನ? ");
INSERT INTO sankan_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","ಕಿನ್ತು ಪಶ್ಯತ ನಿರ್ಭಯಃ ಸನ್ ಕಥಾಂ ಕಥಯತಿ ತಥಾಪಿ ಕಿಮಪಿ ಅ ವದನ್ತ್ಯೇತೇ ಅಯಮೇವಾಭಿಷಿಕ್ತ್ತೋ ಭವತೀತಿ ನಿಶ್ಚಿತಂ ಕಿಮಧಿಪತಯೋ ಜಾನನ್ತಿ? ");
INSERT INTO sankan_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","ಮನುಜೋಯಂ ಕಸ್ಮಾದಾಗಮದ್ ಇತಿ ವಯಂ ಜಾನೋಮಃ ಕಿನ್ತ್ವಭಿಷಿಕ್ತ್ತ ಆಗತೇ ಸ ಕಸ್ಮಾದಾಗತವಾನ್ ಇತಿ ಕೋಪಿ ಜ್ಞಾತುಂ ನ ಶಕ್ಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","ತದಾ ಯೀಶು ರ್ಮಧ್ಯೇಮನ್ದಿರಮ್ ಉಪದಿಶನ್ ಉಚ್ಚೈಃಕಾರಮ್ ಉಕ್ತ್ತವಾನ್ ಯೂಯಂ ಕಿಂ ಮಾಂ ಜಾನೀಥ? ಕಸ್ಮಾಚ್ಚಾಗತೋಸ್ಮಿ ತದಪಿ ಕಿಂ ಜಾನೀಥ? ನಾಹಂ ಸ್ವತ ಆಗತೋಸ್ಮಿ ಕಿನ್ತು ಯಃ ಸತ್ಯವಾದೀ ಸಏವ ಮಾಂ ಪ್ರೇಷಿತವಾನ್ ಯೂಯಂ ತಂ ನ ಜಾನೀಥ| ");
INSERT INTO sankan_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ತಮಹಂ ಜಾನೇ ತೇನಾಹಂ ಪ್ರೇರಿತ ಅಗತೋಸ್ಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","ತಸ್ಮಾದ್ ಯಿಹೂದೀಯಾಸ್ತಂ ಧರ್ತ್ತುಮ್ ಉದ್ಯತಾಸ್ತಥಾಪಿ ಕೋಪಿ ತಸ್ಯ ಗಾತ್ರೇ ಹಸ್ತಂ ನಾರ್ಪಯದ್ ಯತೋ ಹೇತೋಸ್ತದಾ ತಸ್ಯ ಸಮಯೋ ನೋಪತಿಷ್ಠತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","ಕಿನ್ತು ಬಹವೋ ಲೋಕಾಸ್ತಸ್ಮಿನ್ ವಿಶ್ವಸ್ಯ ಕಥಿತವಾನ್ತೋಽಭಿಷಿಕ್ತ್ತಪುರುಷ ಆಗತ್ಯ ಮಾನುಷಸ್ಯಾಸ್ಯ ಕ್ರಿಯಾಭ್ಯಃ ಕಿಮ್ ಅಧಿಕಾ ಆಶ್ಚರ್ಯ್ಯಾಃ ಕ್ರಿಯಾಃ ಕರಿಷ್ಯತಿ? ");
INSERT INTO sankan_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","ತತಃ ಪರಂ ಲೋಕಾಸ್ತಸ್ಮಿನ್ ಇತ್ಥಂ ವಿವದನ್ತೇ ಫಿರೂಶಿನಃ ಪ್ರಧಾನಯಾಜಕಾಞ್ಚೇತಿ ಶ್ರುತವನ್ತಸ್ತಂ ಧೃತ್ವಾ ನೇತುಂ ಪದಾತಿಗಣಂ ಪ್ರೇಷಯಾಮಾಸುಃ| ");
INSERT INTO sankan_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ತತೋ ಯೀಶುರವದದ್ ಅಹಮ್ ಅಲ್ಪದಿನಾನಿ ಯುಷ್ಮಾಭಿಃ ಸಾರ್ದ್ಧಂ ಸ್ಥಿತ್ವಾ ಮತ್ಪ್ರೇರಯಿತುಃ ಸಮೀಪಂ ಯಾಸ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","ಮಾಂ ಮೃಗಯಿಷ್ಯಧ್ವೇ ಕಿನ್ತೂದ್ದೇಶಂ ನ ಲಪ್ಸ್ಯಧ್ವೇ ರತ್ರ ಸ್ಥಾಸ್ಯಾಮಿ ತತ್ರ ಯೂಯಂ ಗನ್ತುಂ ನ ಶಕ್ಷ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","ತದಾ ಯಿಹೂದೀಯಾಃ ಪರಸ್ಪರಂ ವಕ್ತ್ತುಮಾರೇಭಿರೇ ಅಸ್ಯೋದ್ದೇಶಂ ನ ಪ್ರಾಪ್ಸ್ಯಾಮ ಏತಾದೃಶಂ ಕಿಂ ಸ್ಥಾನಂ ಯಾಸ್ಯತಿ? ಭಿನ್ನದೇಶೇ ವಿಕೀರ್ಣಾನಾಂ ಯಿಹೂದೀಯಾನಾಂ ಸನ್ನಿಧಿಮ್ ಏಷ ಗತ್ವಾ ತಾನ್ ಉಪದೇಕ್ಷ್ಯತಿ ಕಿಂ? ");
INSERT INTO sankan_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","ನೋ ಚೇತ್ ಮಾಂ ಗವೇಷಯಿಷ್ಯಥ ಕಿನ್ತೂದ್ದೇಶಂ ನ ಪ್ರಾಪ್ಸ್ಯಥ ಏಷ ಕೋದೃಶಂ ವಾಕ್ಯಮಿದಂ ವದತಿ? ");
INSERT INTO sankan_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","ಅನನ್ತರಮ್ ಉತ್ಸವಸ್ಯ ಚರಮೇಽಹನಿ ಅರ್ಥಾತ್ ಪ್ರಧಾನದಿನೇ ಯೀಶುರುತ್ತಿಷ್ಠನ್ ಉಚ್ಚೈಃಕಾರಮ್ ಆಹ್ವಯನ್ ಉದಿತವಾನ್ ಯದಿ ಕಶ್ಚಿತ್ ತೃಷಾರ್ತ್ತೋ ಭವತಿ ತರ್ಹಿ ಮಮಾನ್ತಿಕಮ್ ಆಗತ್ಯ ಪಿವತು| ");
INSERT INTO sankan_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ಯಃ ಕಶ್ಚಿನ್ಮಯಿ ವಿಶ್ವಸಿತಿ ಧರ್ಮ್ಮಗ್ರನ್ಥಸ್ಯ ವಚನಾನುಸಾರೇಣ ತಸ್ಯಾಭ್ಯನ್ತರತೋಽಮೃತತೋಯಸ್ಯ ಸ್ರೋತಾಂಸಿ ನಿರ್ಗಮಿಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ಯೇ ತಸ್ಮಿನ್ ವಿಶ್ವಸನ್ತಿ ತ ಆತ್ಮಾನಂ ಪ್ರಾಪ್ಸ್ಯನ್ತೀತ್ಯರ್ಥೇ ಸ ಇದಂ ವಾಕ್ಯಂ ವ್ಯಾಹೃತವಾನ್ ಏತತ್ಕಾಲಂ ಯಾವದ್ ಯೀಶು ರ್ವಿಭವಂ ನ ಪ್ರಾಪ್ತಸ್ತಸ್ಮಾತ್ ಪವಿತ್ರ ಆತ್ಮಾ ನಾದೀಯತ| ");
INSERT INTO sankan_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ಏತಾಂ ವಾಣೀಂ ಶ್ರುತ್ವಾ ಬಹವೋ ಲೋಕಾ ಅವದನ್ ಅಯಮೇವ ನಿಶ್ಚಿತಂ ಸ ಭವಿಷ್ಯದ್ವಾದೀ| ");
INSERT INTO sankan_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","ಕೇಚಿದ್ ಅಕಥಯನ್ ಏಷಏವ ಸೋಭಿಷಿಕ್ತ್ತಃ ಕಿನ್ತು ಕೇಚಿದ್ ಅವದನ್ ಸೋಭಿಷಿಕ್ತ್ತಃ ಕಿಂ ಗಾಲೀಲ್ ಪ್ರದೇಶೇ ಜನಿಷ್ಯತೇ? ");
INSERT INTO sankan_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","ಸೋಭಿಷಿಕ್ತ್ತೋ ದಾಯೂದೋ ವಂಶೇ ದಾಯೂದೋ ಜನ್ಮಸ್ಥಾನೇ ಬೈತ್ಲೇಹಮಿ ಪತ್ತನೇ ಜನಿಷ್ಯತೇ ಧರ್ಮ್ಮಗ್ರನ್ಥೇ ಕಿಮಿತ್ಥಂ ಲಿಖಿತಂ ನಾಸ್ತಿ? ");
INSERT INTO sankan_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ಇತ್ಥಂ ತಸ್ಮಿನ್ ಲೋಕಾನಾಂ ಭಿನ್ನವಾಕ್ಯತಾ ಜಾತಾ| ");
INSERT INTO sankan_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","ಕತಿಪಯಲೋಕಾಸ್ತಂ ಧರ್ತ್ತುಮ್ ಐಚ್ಛನ್ ತಥಾಪಿ ತದ್ವಪುಷಿ ಕೋಪಿ ಹಸ್ತಂ ನಾರ್ಪಯತ್| ");
INSERT INTO sankan_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","ಅನನ್ತರಂ ಪಾದಾತಿಗಣೇ ಪ್ರಧಾನಯಾಜಕಾನಾಂ ಫಿರೂಶಿನಾಞ್ಚ ಸಮೀಪಮಾಗತವತಿ ತೇ ತಾನ್ ಅಪೃಚ್ಛನ್ ಕುತೋ ಹೇತೋಸ್ತಂ ನಾನಯತ? ");
INSERT INTO sankan_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","ತದಾ ಪದಾತಯಃ ಪ್ರತ್ಯವದನ್ ಸ ಮಾನವ ಇವ ಕೋಪಿ ಕದಾಪಿ ನೋಪಾದಿಶತ್| ");
INSERT INTO sankan_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ತತಃ ಫಿರೂಶಿನಃ ಪ್ರಾವೋಚನ್ ಯೂಯಮಪಿ ಕಿಮಭ್ರಾಮಿಷ್ಟ? ");
INSERT INTO sankan_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","ಅಧಿಪತೀನಾಂ ಫಿರೂಶಿನಾಞ್ಚ ಕೋಪಿ ಕಿಂ ತಸ್ಮಿನ್ ವ್ಯಶ್ವಸೀತ್? ");
INSERT INTO sankan_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ಯೇ ಶಾಸ್ತ್ರಂ ನ ಜಾನನ್ತಿ ತ ಇಮೇಽಧಮಲೋಕಾಏವ ಶಾಪಗ್ರಸ್ತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ತದಾ ನಿಕದೀಮನಾಮಾ ತೇಷಾಮೇಕೋ ಯಃ ಕ್ಷಣದಾಯಾಂ ಯೀಶೋಃ ಸನ್ನಿಧಿಮ್ ಅಗಾತ್ ಸ ಉಕ್ತ್ತವಾನ್ ");
INSERT INTO sankan_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","ತಸ್ಯ ವಾಕ್ಯೇ ನ ಶ್ರುತೇ ಕರ್ಮ್ಮಣಿ ಚ ನ ವಿದಿತೇ ಽಸ್ಮಾಕಂ ವ್ಯವಸ್ಥಾ ಕಿಂ ಕಞ್ಚನ ಮನುಜಂ ದೋಷೀಕರೋತಿ? ");
INSERT INTO sankan_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ತತಸ್ತೇ ವ್ಯಾಹರನ್ ತ್ವಮಪಿ ಕಿಂ ಗಾಲೀಲೀಯಲೋಕಃ? ವಿವಿಚ್ಯ ಪಶ್ಯ ಗಲೀಲಿ ಕೋಪಿ ಭವಿಷ್ಯದ್ವಾದೀ ನೋತ್ಪದ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","ತತಃ ಪರಂ ಸರ್ವ್ವೇ ಸ್ವಂ ಸ್ವಂ ಗೃಹಂ ಗತಾಃ ಕಿನ್ತು ಯೀಶು ರ್ಜೈತುನನಾಮಾನಂ ಶಿಲೋಚ್ಚಯಂ ಗತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ಪ್ರತ್ಯೂಷೇ ಯೀಶುಃ ಪನರ್ಮನ್ದಿರಮ್ ಆಗಚ್ಛತ್ ");
INSERT INTO sankan_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ತತಃ ಸರ್ವ್ವೇಷು ಲೋಕೇಷು ತಸ್ಯ ಸಮೀಪ ಆಗತೇಷು ಸ ಉಪವಿಶ್ಯ ತಾನ್ ಉಪದೇಷ್ಟುಮ್ ಆರಭತ| ");
INSERT INTO sankan_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ತದಾ ಅಧ್ಯಾಪಕಾಃ ಫಿರೂಶಿನಞ್ಚ ವ್ಯಭಿಚಾರಕರ್ಮ್ಮಣಿ ಧೃತಂ ಸ್ತ್ರಿಯಮೇಕಾಮ್ ಆನಿಯ ಸರ್ವ್ವೇಷಾಂ ಮಧ್ಯೇ ಸ್ಥಾಪಯಿತ್ವಾ ವ್ಯಾಹರನ್ ");
INSERT INTO sankan_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ಹೇ ಗುರೋ ಯೋಷಿತಮ್ ಇಮಾಂ ವ್ಯಭಿಚಾರಕರ್ಮ್ಮ ಕುರ್ವ್ವಾಣಾಂ ಲೋಕಾ ಧೃತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ಏತಾದೃಶಲೋಕಾಃ ಪಾಷಾಣಾಘಾತೇನ ಹನ್ತವ್ಯಾ ಇತಿ ವಿಧಿರ್ಮೂಸಾವ್ಯವಸ್ಥಾಗ್ರನ್ಥೇ ಲಿಖಿತೋಸ್ತಿ ಕಿನ್ತು ಭವಾನ್ ಕಿಮಾದಿಶತಿ? ");
INSERT INTO sankan_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","ತೇ ತಮಪವದಿತುಂ ಪರೀಕ್ಷಾಭಿಪ್ರಾಯೇಣ ವಾಕ್ಯಮಿದಮ್ ಅಪೃಚ್ಛನ್ ಕಿನ್ತು ಸ ಪ್ರಹ್ವೀಭೂಯ ಭೂಮಾವಙ್ಗಲ್ಯಾ ಲೇಖಿತುಮ್ ಆರಭತ| ");
INSERT INTO sankan_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ತತಸ್ತೈಃ ಪುನಃ ಪುನಃ ಪೃಷ್ಟ ಉತ್ಥಾಯ ಕಥಿತವಾನ್ ಯುಷ್ಮಾಕಂ ಮಧ್ಯೇ ಯೋ ಜನೋ ನಿರಪರಾಧೀ ಸಏವ ಪ್ರಥಮಮ್ ಏನಾಂ ಪಾಷಾಣೇನಾಹನ್ತು| ");
INSERT INTO sankan_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ಪಶ್ಚಾತ್ ಸ ಪುನಶ್ಚ ಪ್ರಹ್ವೀಭೂಯ ಭೂಮೌ ಲೇಖಿತುಮ್ ಆರಭತ| ");
INSERT INTO sankan_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ತಾಂ ಕಥಂ ಶ್ರುತ್ವಾ ತೇ ಸ್ವಸ್ವಮನಸಿ ಪ್ರಬೋಧಂ ಪ್ರಾಪ್ಯ ಜ್ಯೇಷ್ಠಾನುಕ್ರಮಂ ಏಕೈಕಶಃ ಸರ್ವ್ವೇ ಬಹಿರಗಚ್ಛನ್ ತತೋ ಯೀಶುರೇಕಾಕೀ ತಯಕ್ತ್ತೋಭವತ್ ಮಧ್ಯಸ್ಥಾನೇ ದಣ್ಡಾಯಮಾನಾ ಸಾ ಯೋಷಾ ಚ ಸ್ಥಿತಾ| ");
INSERT INTO sankan_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ತತ್ಪಶ್ಚಾದ್ ಯೀಶುರುತ್ಥಾಯ ತಾಂ ವನಿತಾಂ ವಿನಾ ಕಮಪ್ಯಪರಂ ನ ವಿಲೋಕ್ಯ ಪೃಷ್ಟವಾನ್ ಹೇ ವಾಮೇ ತವಾಪವಾದಕಾಃ ಕುತ್ರ? ಕೋಪಿ ತ್ವಾಂ ಕಿಂ ನ ದಣ್ಡಯತಿ? ");
INSERT INTO sankan_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","ಸಾವದತ್ ಹೇ ಮಹೇಚ್ಛ ಕೋಪಿ ನ ತದಾ ಯೀಶುರವೋಚತ್ ನಾಹಮಪಿ ದಣ್ಡಯಾಮಿ ಯಾಹಿ ಪುನಃ ಪಾಪಂ ಮಾಕಾರ್ಷೀಃ| ");
INSERT INTO sankan_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ತತೋ ಯೀಶುಃ ಪುನರಪಿ ಲೋಕೇಭ್ಯ ಇತ್ಥಂ ಕಥಯಿತುಮ್ ಆರಭತ ಜಗತೋಹಂ ಜ್ಯೋತಿಃಸ್ವರೂಪೋ ಯಃ ಕಶ್ಚಿನ್ ಮತ್ಪಶ್ಚಾದ ಗಚ್ಛತಿ ಸ ತಿಮಿರೇ ನ ಭ್ರಮಿತ್ವಾ ಜೀವನರೂಪಾಂ ದೀಪ್ತಿಂ ಪ್ರಾಪ್ಸ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ತತಃ ಫಿರೂಶಿನೋಽವಾದಿಷುಸ್ತ್ವಂ ಸ್ವಾರ್ಥೇ ಸ್ವಯಂ ಸಾಕ್ಷ್ಯಂ ದದಾಸಿ ತಸ್ಮಾತ್ ತವ ಸಾಕ್ಷ್ಯಂ ಗ್ರಾಹ್ಯಂ ನ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","ತದಾ ಯೀಶುಃ ಪ್ರತ್ಯುದಿತವಾನ್ ಯದ್ಯಪಿ ಸ್ವಾರ್ಥೇಽಹಂ ಸ್ವಯಂ ಸಾಕ್ಷ್ಯಂ ದದಾಮಿ ತಥಾಪಿ ಮತ್ ಸಾಕ್ಷ್ಯಂ ಗ್ರಾಹ್ಯಂ ಯಸ್ಮಾದ್ ಅಹಂ ಕುತ ಆಗತೋಸ್ಮಿ ಕ್ವ ಯಾಮಿ ಚ ತದಹಂ ಜಾನಾಮಿ ಕಿನ್ತು ಕುತ ಆಗತೋಸ್ಮಿ ಕುತ್ರ ಗಚ್ಛಾಮಿ ಚ ತದ್ ಯೂಯಂ ನ ಜಾನೀಥ| ");
INSERT INTO sankan_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","ಯೂಯಂ ಲೌಕಿಕಂ ವಿಚಾರಯಥ ನಾಹಂ ಕಿಮಪಿ ವಿಚಾರಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","ಕಿನ್ತು ಯದಿ ವಿಚಾರಯಾಮಿ ತರ್ಹಿ ಮಮ ವಿಚಾರೋ ಗ್ರಹೀತವ್ಯೋ ಯತೋಹಮ್ ಏಕಾಕೀ ನಾಸ್ಮಿ ಪ್ರೇರಯಿತಾ ಪಿತಾ ಮಯಾ ಸಹ ವಿದ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","ದ್ವಯೋ ರ್ಜನಯೋಃ ಸಾಕ್ಷ್ಯಂ ಗ್ರಹಣೀಯಂ ಭವತೀತಿ ಯುಷ್ಮಾಕಂ ವ್ಯವಸ್ಥಾಗ್ರನ್ಥೇ ಲಿಖಿತಮಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ಅಹಂ ಸ್ವಾರ್ಥೇ ಸ್ವಯಂ ಸಾಕ್ಷಿತ್ವಂ ದದಾಮಿ ಯಶ್ಚ ಮಮ ತಾತೋ ಮಾಂ ಪ್ರೇರಿತವಾನ್ ಸೋಪಿ ಮದರ್ಥೇ ಸಾಕ್ಷ್ಯಂ ದದಾತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ತದಾ ತೇಽಪೃಚ್ಛನ್ ತವ ತಾತಃ ಕುತ್ರ? ತತೋ ಯೀಶುಃ ಪ್ರತ್ಯವಾದೀದ್ ಯೂಯಂ ಮಾಂ ನ ಜಾನೀಥ ಮತ್ಪಿತರಞ್ಚ ನ ಜಾನೀಥ ಯದಿ ಮಾಮ್ ಅಕ್ಷಾಸ್ಯತ ತರ್ಹಿ ಮಮ ತಾತಮಪ್ಯಕ್ಷಾಸ್ಯತ| ");
INSERT INTO sankan_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ಯೀಶು ರ್ಮನ್ದಿರ ಉಪದಿಶ್ಯ ಭಣ್ಡಾಗಾರೇ ಕಥಾ ಏತಾ ಅಕಥಯತ್ ತಥಾಪಿ ತಂ ಪ್ರತಿ ಕೋಪಿ ಕರಂ ನೋದತೋಲಯತ್| ");
INSERT INTO sankan_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ತತಃ ಪರಂ ಯೀಶುಃ ಪುನರುದಿತವಾನ್ ಅಧುನಾಹಂ ಗಚ್ಛಾಮಿ ಯೂಯಂ ಮಾಂ ಗವೇಷಯಿಷ್ಯಥ ಕಿನ್ತು ನಿಜೈಃ ಪಾಪೈ ರ್ಮರಿಷ್ಯಥ ಯತ್ ಸ್ಥಾನಮ್ ಅಹಂ ಯಾಸ್ಯಾಮಿ ತತ್ ಸ್ಥಾನಮ್ ಯೂಯಂ ಯಾತುಂ ನ ಶಕ್ಷ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","ತದಾ ಯಿಹೂದೀಯಾಃ ಪ್ರಾವೋಚನ್ ಕಿಮಯಮ್ ಆತ್ಮಘಾತಂ ಕರಿಷ್ಯತಿ? ಯತೋ ಯತ್ ಸ್ಥಾನಮ್ ಅಹಂ ಯಾಸ್ಯಾಮಿ ತತ್ ಸ್ಥಾನಮ್ ಯೂಯಂ ಯಾತುಂ ನ ಶಕ್ಷ್ಯಥ ಇತಿ ವಾಕ್ಯಂ ಬ್ರವೀತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ತತೋ ಯೀಶುಸ್ತೇಭ್ಯಃ ಕಥಿತವಾನ್ ಯೂಯಮ್ ಅಧಃಸ್ಥಾನೀಯಾ ಲೋಕಾ ಅಹಮ್ ಊರ್ದ್ವ್ವಸ್ಥಾನೀಯಃ ಯೂಯಮ್ ಏತಜ್ಜಗತ್ಸಮ್ಬನ್ಧೀಯಾ ಅಹಮ್ ಏತಜ್ಜಗತ್ಸಮ್ಬನ್ಧೀಯೋ ನ| ");
INSERT INTO sankan_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","ತಸ್ಮಾತ್ ಕಥಿತವಾನ್ ಯೂಯಂ ನಿಜೈಃ ಪಾಪೈ ರ್ಮರಿಷ್ಯಥ ಯತೋಹಂ ಸ ಪುಮಾನ್ ಇತಿ ಯದಿ ನ ವಿಶ್ವಸಿಥ ತರ್ಹಿ ನಿಜೈಃ ಪಾಪೈ ರ್ಮರಿಷ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ತದಾ ತೇ ಽಪೃಚ್ಛನ್ ಕಸ್ತ್ವಂ? ತತೋ ಯೀಶುಃ ಕಥಿತವಾನ್ ಯುಷ್ಮಾಕಂ ಸನ್ನಿಧೌ ಯಸ್ಯ ಪ್ರಸ್ತಾವಮ್ ಆ ಪ್ರಥಮಾತ್ ಕರೋಮಿ ಸಏವ ಪುರುಷೋಹಂ| ");
INSERT INTO sankan_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","ಯುಷ್ಮಾಸು ಮಯಾ ಬಹುವಾಕ್ಯಂ ವಕ್ತ್ತವ್ಯಂ ವಿಚಾರಯಿತವ್ಯಞ್ಚ ಕಿನ್ತು ಮತ್ಪ್ರೇರಯಿತಾ ಸತ್ಯವಾದೀ ತಸ್ಯ ಸಮೀಪೇ ಯದಹಂ ಶ್ರುತವಾನ್ ತದೇವ ಜಗತೇ ಕಥಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","ಕಿನ್ತು ಸ ಜನಕೇ ವಾಕ್ಯಮಿದಂ ಪ್ರೋಕ್ತ್ತವಾನ್ ಇತಿ ತೇ ನಾಬುಧ್ಯನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ತತೋ ಯೀಶುರಕಥಯದ್ ಯದಾ ಮನುಷ್ಯಪುತ್ರಮ್ ಊರ್ದ್ವ್ವ ಉತ್ಥಾಪಯಿಷ್ಯಥ ತದಾಹಂ ಸ ಪುಮಾನ್ ಕೇವಲಃ ಸ್ವಯಂ ಕಿಮಪಿ ಕರ್ಮ್ಮ ನ ಕರೋಮಿ ಕಿನ್ತು ತಾತೋ ಯಥಾ ಶಿಕ್ಷಯತಿ ತದನುಸಾರೇಣ ವಾಕ್ಯಮಿದಂ ವದಾಮೀತಿ ಚ ಯೂಯಂ ಜ್ಞಾತುಂ ಶಕ್ಷ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","ಮತ್ಪ್ರೇರಯಿತಾ ಪಿತಾ ಮಾಮ್ ಏಕಾಕಿನಂ ನ ತ್ಯಜತಿ ಸ ಮಯಾ ಸಾರ್ದ್ಧಂ ತಿಷ್ಠತಿ ಯತೋಹಂ ತದಭಿಮತಂ ಕರ್ಮ್ಮ ಸದಾ ಕರೋಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","ತದಾ ತಸ್ಯೈತಾನಿ ವಾಕ್ಯಾನಿ ಶ್ರುತ್ವಾ ಬಹುವಸ್ತಾಸ್ಮಿನ್ ವ್ಯಶ್ವಸನ್| ");
INSERT INTO sankan_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","ಯೇ ಯಿಹೂದೀಯಾ ವ್ಯಶ್ವಸನ್ ಯೀಶುಸ್ತೇಭ್ಯೋಽಕಥಯತ್ ");
INSERT INTO sankan_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ಮಮ ವಾಕ್ಯೇ ಯದಿ ಯೂಯಮ್ ಆಸ್ಥಾಂ ಕುರುಥ ತರ್ಹಿ ಮಮ ಶಿಷ್ಯಾ ಭೂತ್ವಾ ಸತ್ಯತ್ವಂ ಜ್ಞಾಸ್ಯಥ ತತಃ ಸತ್ಯತಯಾ ಯುಷ್ಮಾಕಂ ಮೋಕ್ಷೋ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","ತದಾ ತೇ ಪ್ರತ್ಯವಾದಿಷುಃ ವಯಮ್ ಇಬ್ರಾಹೀಮೋ ವಂಶಃ ಕದಾಪಿ ಕಸ್ಯಾಪಿ ದಾಸಾ ನ ಜಾತಾಸ್ತರ್ಹಿ ಯುಷ್ಮಾಕಂ ಮುಕ್ತ್ತಿ ರ್ಭವಿಷ್ಯತೀತಿ ವಾಕ್ಯಂ ಕಥಂ ಬ್ರವೀಷಿ? ");
INSERT INTO sankan_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","ತದಾ ಯೀಶುಃ ಪ್ರತ್ಯವದದ್ ಯುಷ್ಮಾನಹಂ ಯಥಾರ್ಥತರಂ ವದಾಮಿ ಯಃ ಪಾಪಂ ಕರೋತಿ ಸ ಪಾಪಸ್ಯ ದಾಸಃ| ");
INSERT INTO sankan_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","ದಾಸಶ್ಚ ನಿರನ್ತರಂ ನಿವೇಶನೇ ನ ತಿಷ್ಠತಿ ಕಿನ್ತು ಪುತ್ರೋ ನಿರನ್ತರಂ ತಿಷ್ಠತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","ಅತಃ ಪುತ್ರೋ ಯದಿ ಯುಷ್ಮಾನ್ ಮೋಚಯತಿ ತರ್ಹಿ ನಿತಾನ್ತಮೇವ ಮುಕ್ತ್ತಾ ಭವಿಷ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","ಯುಯಮ್ ಇಬ್ರಾಹೀಮೋ ವಂಶ ಇತ್ಯಹಂ ಜಾನಾಮಿ ಕಿನ್ತು ಮಮ ಕಥಾ ಯುಷ್ಮಾಕಮ್ ಅನ್ತಃಕರಣೇಷು ಸ್ಥಾನಂ ನ ಪ್ರಾಪ್ನುವನ್ತಿ ತಸ್ಮಾದ್ಧೇತೋ ರ್ಮಾಂ ಹನ್ತುಮ್ ಈಹಧ್ವೇ| ");
INSERT INTO sankan_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ಅಹಂ ಸ್ವಪಿತುಃ ಸಮೀಪೇ ಯದಪಶ್ಯಂ ತದೇವ ಕಥಯಾಮಿ ತಥಾ ಯೂಯಮಪಿ ಸ್ವಪಿತುಃ ಸಮೀಪೇ ಯದಪಶ್ಯತ ತದೇವ ಕುರುಧ್ವೇ| ");
INSERT INTO sankan_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","ತದಾ ತೇ ಪ್ರತ್ಯವೋಚನ್ ಇಬ್ರಾಹೀಮ್ ಅಸ್ಮಾಕಂ ಪಿತಾ ತತೋ ಯೀಶುರಕಥಯದ್ ಯದಿ ಯೂಯಮ್ ಇಬ್ರಾಹೀಮಃ ಸನ್ತಾನಾ ಅಭವಿಷ್ಯತ ತರ್ಹಿ ಇಬ್ರಾಹೀಮ ಆಚಾರಣವದ್ ಆಚರಿಷ್ಯತ| ");
INSERT INTO sankan_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ಈಶ್ವರಸ್ಯ ಮುಖಾತ್ ಸತ್ಯಂ ವಾಕ್ಯಂ ಶ್ರುತ್ವಾ ಯುಷ್ಮಾನ್ ಜ್ಞಾಪಯಾಮಿ ಯೋಹಂ ತಂ ಮಾಂ ಹನ್ತುಂ ಚೇಷ್ಟಧ್ವೇ ಇಬ್ರಾಹೀಮ್ ಏತಾದೃಶಂ ಕರ್ಮ್ಮ ನ ಚಕಾರ| ");
INSERT INTO sankan_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","ಯೂಯಂ ಸ್ವಸ್ವಪಿತುಃ ಕರ್ಮ್ಮಾಣಿ ಕುರುಥ ತದಾ ತೈರುಕ್ತ್ತಂ ನ ವಯಂ ಜಾರಜಾತಾ ಅಸ್ಮಾಕಮ್ ಏಕಏವ ಪಿತಾಸ್ತಿ ಸ ಏವೇಶ್ವರಃ ");
INSERT INTO sankan_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ತತೋ ಯೀಶುನಾ ಕಥಿತಮ್ ಈಶ್ವರೋ ಯದಿ ಯುಷ್ಮಾಕಂ ತಾತೋಭವಿಷ್ಯತ್ ತರ್ಹಿ ಯೂಯಂ ಮಯಿ ಪ್ರೇಮಾಕರಿಷ್ಯತ ಯತೋಹಮ್ ಈಶ್ವರಾನ್ನಿರ್ಗತ್ಯಾಗತೋಸ್ಮಿ ಸ್ವತೋ ನಾಗತೋಹಂ ಸ ಮಾಂ ಪ್ರಾಹಿಣೋತ್| ");
INSERT INTO sankan_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","ಯೂಯಂ ಮಮ ವಾಕ್ಯಮಿದಂ ನ ಬುಧ್ಯಧ್ವೇ ಕುತಃ? ಯತೋ ಯೂಯಂ ಮಮೋಪದೇಶಂ ಸೋಢುಂ ನ ಶಕ್ನುಥ| ");
INSERT INTO sankan_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","ಯೂಯಂ ಶೈತಾನ್ ಪಿತುಃ ಸನ್ತಾನಾ ಏತಸ್ಮಾದ್ ಯುಷ್ಮಾಕಂ ಪಿತುರಭಿಲಾಷಂ ಪೂರಯಥ ಸ ಆ ಪ್ರಥಮಾತ್ ನರಘಾತೀ ತದನ್ತಃ ಸತ್ಯತ್ವಸ್ಯ ಲೇಶೋಪಿ ನಾಸ್ತಿ ಕಾರಣಾದತಃ ಸ ಸತ್ಯತಾಯಾಂ ನಾತಿಷ್ಠತ್ ಸ ಯದಾ ಮೃಷಾ ಕಥಯತಿ ತದಾ ನಿಜಸ್ವಭಾವಾನುಸಾರೇಣೈವ ಕಥಯತಿ ಯತೋ ಸ ಮೃಷಾಭಾಷೀ ಮೃಷೋತ್ಪಾದಕಶ್ಚ| ");
INSERT INTO sankan_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","ಅಹಂ ತಥ್ಯವಾಕ್ಯಂ ವದಾಮಿ ಕಾರಣಾದಸ್ಮಾದ್ ಯೂಯಂ ಮಾಂ ನ ಪ್ರತೀಥ| ");
INSERT INTO sankan_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","ಮಯಿ ಪಾಪಮಸ್ತೀತಿ ಪ್ರಮಾಣಂ ಯುಷ್ಮಾಕಂ ಕೋ ದಾತುಂ ಶಕ್ನೋತಿ? ಯದ್ಯಹಂ ತಥ್ಯವಾಕ್ಯಂ ವದಾಮಿ ತರ್ಹಿ ಕುತೋ ಮಾಂ ನ ಪ್ರತಿಥ? ");
INSERT INTO sankan_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ಯಃ ಕಶ್ಚನ ಈಶ್ವರೀಯೋ ಲೋಕಃ ಸ ಈಶ್ವರೀಯಕಥಾಯಾಂ ಮನೋ ನಿಧತ್ತೇ ಯೂಯಮ್ ಈಶ್ವರೀಯಲೋಕಾ ನ ಭವಥ ತನ್ನಿದಾನಾತ್ ತತ್ರ ನ ಮನಾಂಸಿ ನಿಧದ್ವೇ| ");
INSERT INTO sankan_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","ತದಾ ಯಿಹೂದೀಯಾಃ ಪ್ರತ್ಯವಾದಿಷುಃ ತ್ವಮೇಕಃ ಶೋಮಿರೋಣೀಯೋ ಭೂತಗ್ರಸ್ತಶ್ಚ ವಯಂ ಕಿಮಿದಂ ಭದ್ರಂ ನಾವಾದಿಷ್ಮ? ");
INSERT INTO sankan_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ತತೋ ಯೀಶುಃ ಪ್ರತ್ಯವಾದೀತ್ ನಾಹಂ ಭೂತಗ್ರಸ್ತಃ ಕಿನ್ತು ನಿಜತಾತಂ ಸಮ್ಮನ್ಯೇ ತಸ್ಮಾದ್ ಯೂಯಂ ಮಾಮ್ ಅಪಮನ್ಯಧ್ವೇ| ");
INSERT INTO sankan_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","ಅಹಂ ಸ್ವಸುಖ್ಯಾತಿಂ ನ ಚೇಷ್ಟೇ ಕಿನ್ತು ಚೇಷ್ಟಿತಾ ವಿಚಾರಯಿತಾ ಚಾಪರ ಏಕ ಆಸ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ಅಹಂ ಯುಷ್ಮಭ್ಯಮ್ ಅತೀವ ಯಥಾರ್ಥಂ ಕಥಯಾಮಿ ಯೋ ನರೋ ಮದೀಯಂ ವಾಚಂ ಮನ್ಯತೇ ಸ ಕದಾಚನ ನಿಧನಂ ನ ದ್ರಕ್ಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","ಯಿಹೂದೀಯಾಸ್ತಮವದನ್ ತ್ವಂ ಭೂತಗ್ರಸ್ತ ಇತೀದಾನೀಮ್ ಅವೈಷ್ಮ| ಇಬ್ರಾಹೀಮ್ ಭವಿಷ್ಯದ್ವಾದಿನಞ್ಚ ಸರ್ವ್ವೇ ಮೃತಾಃ ಕಿನ್ತು ತ್ವಂ ಭಾಷಸೇ ಯೋ ನರೋ ಮಮ ಭಾರತೀಂ ಗೃಹ್ಲಾತಿ ಸ ಜಾತು ನಿಧಾನಾಸ್ವಾದಂ ನ ಲಪ್ಸ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","ತರ್ಹಿ ತ್ವಂ ಕಿಮ್ ಅಸ್ಮಾಕಂ ಪೂರ್ವ್ವಪುರುಷಾದ್ ಇಬ್ರಾಹೀಮೋಪಿ ಮಹಾನ್? ಯಸ್ಮಾತ್ ಸೋಪಿ ಮೃತಃ ಭವಿಷ್ಯದ್ವಾದಿನೋಪಿ ಮೃತಾಃ ತ್ವಂ ಸ್ವಂ ಕಂ ಪುಮಾಂಸಂ ಮನುಷೇ? ");
INSERT INTO sankan_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","ಯೀಶುಃ ಪ್ರತ್ಯವೋಚದ್ ಯದ್ಯಹಂ ಸ್ವಂ ಸ್ವಯಂ ಸಮ್ಮನ್ಯೇ ತರ್ಹಿ ಮಮ ತತ್ ಸಮ್ಮನನಂ ಕಿಮಪಿ ನ ಕಿನ್ತು ಮಮ ತಾತೋ ಯಂ ಯೂಯಂ ಸ್ವೀಯಮ್ ಈಶ್ವರಂ ಭಾಷಧ್ವೇ ಸಏವ ಮಾಂ ಸಮ್ಮನುತೇ| ");
INSERT INTO sankan_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ಯೂಯಂ ತಂ ನಾವಗಚ್ಛಥ ಕಿನ್ತ್ವಹಂ ತಮವಗಚ್ಛಾಮಿ ತಂ ನಾವಗಚ್ಛಾಮೀತಿ ವಾಕ್ಯಂ ಯದಿ ವದಾಮಿ ತರ್ಹಿ ಯೂಯಮಿವ ಮೃಷಾಭಾಷೀ ಭವಾಮಿ ಕಿನ್ತ್ವಹಂ ತಮವಗಚ್ಛಾಮಿ ತದಾಕ್ಷಾಮಪಿ ಗೃಹ್ಲಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","ಯುಷ್ಮಾಕಂ ಪೂರ್ವ್ವಪುರುಷ ಇಬ್ರಾಹೀಮ್ ಮಮ ಸಮಯಂ ದ್ರಷ್ಟುಮ್ ಅತೀವಾವಾಞ್ಛತ್ ತನ್ನಿರೀಕ್ಷ್ಯಾನನ್ದಚ್ಚ| ");
INSERT INTO sankan_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","ತದಾ ಯಿಹೂದೀಯಾ ಅಪೃಚ್ಛನ್ ತವ ವಯಃ ಪಞ್ಚಾಶದ್ವತ್ಸರಾ ನ ತ್ವಂ ಕಿಮ್ ಇಬ್ರಾಹೀಮಮ್ ಅದ್ರಾಕ್ಷೀಃ? ");
INSERT INTO sankan_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","ಯೀಶುಃ ಪ್ರತ್ಯವಾದೀದ್ ಯುಷ್ಮಾನಹಂ ಯಥಾರ್ಥತರಂ ವದಾಮಿ ಇಬ್ರಾಹೀಮೋ ಜನ್ಮನಃ ಪೂರ್ವ್ವಕಾಲಮಾರಭ್ಯಾಹಂ ವಿದ್ಯೇ| ");
INSERT INTO sankan_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ತದಾ ತೇ ಪಾಷಾಣಾನ್ ಉತ್ತೋಲ್ಯ ತಮಾಹನ್ತುಮ್ ಉದಯಚ್ಛನ್ ಕಿನ್ತು ಯೀಶು ರ್ಗುಪ್ತೋ ಮನ್ತಿರಾದ್ ಬಹಿರ್ಗತ್ಯ ತೇಷಾಂ ಮಧ್ಯೇನ ಪ್ರಸ್ಥಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","ತತಃ ಪರಂ ಯೀಶುರ್ಗಚ್ಛನ್ ಮಾರ್ಗಮಧ್ಯೇ ಜನ್ಮಾನ್ಧಂ ನರಮ್ ಅಪಶ್ಯತ್| ");
INSERT INTO sankan_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ತತಃ ಶಿಷ್ಯಾಸ್ತಮ್ ಅಪೃಚ್ಛನ್ ಹೇ ಗುರೋ ನರೋಯಂ ಸ್ವಪಾಪೇನ ವಾ ಸ್ವಪಿತ್ರಾಃ ಪಾಪೇನಾನ್ಧೋಽಜಾಯತ? ");
INSERT INTO sankan_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ತತಃ ಸ ಪ್ರತ್ಯುದಿತವಾನ್ ಏತಸ್ಯ ವಾಸ್ಯ ಪಿತ್ರೋಃ ಪಾಪಾದ್ ಏತಾದೃಶೋಭೂದ ಇತಿ ನಹಿ ಕಿನ್ತ್ವನೇನ ಯಥೇಶ್ವರಸ್ಯ ಕರ್ಮ್ಮ ಪ್ರಕಾಶ್ಯತೇ ತದ್ಧೇತೋರೇವ| ");
INSERT INTO sankan_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","ದಿನೇ ತಿಷ್ಠತಿ ಮತ್ಪ್ರೇರಯಿತುಃ ಕರ್ಮ್ಮ ಮಯಾ ಕರ್ತ್ತವ್ಯಂ ಯದಾ ಕಿಮಪಿ ಕರ್ಮ್ಮ ನ ಕ್ರಿಯತೇ ತಾದೃಶೀ ನಿಶಾಗಚ್ಛತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ಅಹಂ ಯಾವತ್ಕಾಲಂ ಜಗತಿ ತಿಷ್ಠಾಮಿ ತಾವತ್ಕಾಲಂ ಜಗತೋ ಜ್ಯೋತಿಃಸ್ವರೂಪೋಸ್ಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ಇತ್ಯುಕ್ತ್ತಾ ಭೂಮೌ ನಿಷ್ಠೀವಂ ನಿಕ್ಷಿಪ್ಯ ತೇನ ಪಙ್ಕಂ ಕೃತವಾನ್ ");
INSERT INTO sankan_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ಪಶ್ಚಾತ್ ತತ್ಪಙ್ಕೇನ ತಸ್ಯಾನ್ಧಸ್ಯ ನೇತ್ರೇ ಪ್ರಲಿಪ್ಯ ತಮಿತ್ಯಾದಿಶತ್ ಗತ್ವಾ ಶಿಲೋಹೇ ಽರ್ಥಾತ್ ಪ್ರೇರಿತನಾಮ್ನಿ ಸರಸಿ ಸ್ನಾಹಿ| ತತೋನ್ಧೋ ಗತ್ವಾ ತತ್ರಾಸ್ನಾತ್ ತತಃ ಪ್ರನ್ನಚಕ್ಷು ರ್ಭೂತ್ವಾ ವ್ಯಾಘುಟ್ಯಾಗಾತ್| ");
INSERT INTO sankan_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","ಅಪರಞ್ಚ ಸಮೀಪವಾಸಿನೋ ಲೋಕಾ ಯೇ ಚ ತಂ ಪೂರ್ವ್ವಮನ್ಧಮ್ ಅಪಶ್ಯನ್ ತೇ ಬಕ್ತ್ತುಮ್ ಆರಭನ್ತ ಯೋನ್ಧಲೋಕೋ ವರ್ತ್ಮನ್ಯುಪವಿಶ್ಯಾಭಿಕ್ಷತ ಸ ಏವಾಯಂ ಜನಃ ಕಿಂ ನ ಭವತಿ? ");
INSERT INTO sankan_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","ಕೇಚಿದವದನ್ ಸ ಏವ ಕೇಚಿದವೋಚನ್ ತಾದೃಶೋ ಭವತಿ ಕಿನ್ತು ಸ ಸ್ವಯಮಬ್ರವೀತ್ ಸ ಏವಾಹಂ ಭವಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ಅತಏವ ತೇ ಽಪೃಚ್ಛನ್ ತ್ವಂ ಕಥಂ ದೃಷ್ಟಿಂ ಪಾಪ್ತವಾನ್? ");
INSERT INTO sankan_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ತತಃ ಸೋವದದ್ ಯೀಶನಾಮಕ ಏಕೋ ಜನೋ ಮಮ ನಯನೇ ಪಙ್ಕೇನ ಪ್ರಲಿಪ್ಯ ಇತ್ಯಾಜ್ಞಾಪಯತ್ ಶಿಲೋಹಕಾಸಾರಂ ಗತ್ವಾ ತತ್ರ ಸ್ನಾಹಿ| ತತಸ್ತತ್ರ ಗತ್ವಾ ಮಯಿ ಸ್ನಾತೇ ದೃಷ್ಟಿಮಹಂ ಲಬ್ಧವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","ತದಾ ತೇ ಽವದನ್ ಸ ಪುಮಾನ್ ಕುತ್ರ? ತೇನೋಕ್ತ್ತಂ ನಾಹಂ ಜಾನಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","ಅಪರಂ ತಸ್ಮಿನ್ ಪೂರ್ವ್ವಾನ್ಧೇ ಜನೇ ಫಿರೂಶಿನಾಂ ನಿಕಟಮ್ ಆನೀತೇ ಸತಿ ಫಿರೂಶಿನೋಪಿ ತಮಪೃಚ್ಛನ್ ಕಥಂ ದೃಷ್ಟಿಂ ಪ್ರಾಪ್ತೋಸಿ? ");
INSERT INTO sankan_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ತತಃ ಸ ಕಥಿತವಾನ್ ಸ ಪಙ್ಕೇನ ಮಮ ನೇತ್ರೇ ಽಲಿಮ್ಪತ್ ಪಶ್ಚಾದ್ ಸ್ನಾತ್ವಾ ದೃಷ್ಟಿಮಲಭೇ| ");
INSERT INTO sankan_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","ಕಿನ್ತು ಯೀಶು ರ್ವಿಶ್ರಾಮವಾರೇ ಕರ್ದ್ದಮಂ ಕೃತ್ವಾ ತಸ್ಯ ನಯನೇ ಪ್ರಸನ್ನೇಽಕರೋದ್ ಇತಿಕಾರಣಾತ್ ಕತಿಪಯಫಿರೂಶಿನೋಽವದನ್ ");
INSERT INTO sankan_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ಸ ಪುಮಾನ್ ಈಶ್ವರಾನ್ನ ಯತಃ ಸ ವಿಶ್ರಾಮವಾರಂ ನ ಮನ್ಯತೇ| ತತೋನ್ಯೇ ಕೇಚಿತ್ ಪ್ರತ್ಯವದನ್ ಪಾಪೀ ಪುಮಾನ್ ಕಿಮ್ ಏತಾದೃಶಮ್ ಆಶ್ಚರ್ಯ್ಯಂ ಕರ್ಮ್ಮ ಕರ್ತ್ತುಂ ಶಕ್ನೋತಿ? ");
INSERT INTO sankan_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ಇತ್ಥಂ ತೇಷಾಂ ಪರಸ್ಪರಂ ಭಿನ್ನವಾಕ್ಯತ್ವಮ್ ಅಭವತ್| ಪಶ್ಚಾತ್ ತೇ ಪುನರಪಿ ತಂ ಪೂರ್ವ್ವಾನ್ಧಂ ಮಾನುಷಮ್ ಅಪ್ರಾಕ್ಷುಃ ಯೋ ಜನಸ್ತವ ಚಕ್ಷುಷೀ ಪ್ರಸನ್ನೇ ಕೃತವಾನ್ ತಸ್ಮಿನ್ ತ್ವಂ ಕಿಂ ವದಸಿ? ಸ ಉಕ್ತ್ತವಾನ್ ಸ ಭವಿಶದ್ವಾದೀ| ");
INSERT INTO sankan_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","ಸ ದೃಷ್ಟಿಮ್ ಆಪ್ತವಾನ್ ಇತಿ ಯಿಹೂದೀಯಾಸ್ತಸ್ಯ ದೃಷ್ಟಿಂ ಪ್ರಾಪ್ತಸ್ಯ ಜನಸ್ಯ ಪಿತ್ರೋ ರ್ಮುಖಾದ್ ಅಶ್ರುತ್ವಾ ನ ಪ್ರತ್ಯಯನ್| ");
INSERT INTO sankan_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ಅತಏವ ತೇ ತಾವಪೃಚ್ಛನ್ ಯುವಯೋ ರ್ಯಂ ಪುತ್ರಂ ಜನ್ಮಾನ್ಧಂ ವದಥಃ ಸ ಕಿಮಯಂ? ತರ್ಹೀದಾನೀಂ ಕಥಂ ದ್ರಷ್ಟುಂ ಶಕ್ನೋತಿ? ");
INSERT INTO sankan_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ತತಸ್ತಸ್ಯ ಪಿತರೌ ಪ್ರತ್ಯವೋಚತಾಮ್ ಅಯಮ್ ಆವಯೋಃ ಪುತ್ರ ಆ ಜನೇರನ್ಧಶ್ಚ ತದಪ್ಯಾವಾಂ ಜಾನೀವಃ ");
INSERT INTO sankan_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ಕಿನ್ತ್ವಧುನಾ ಕಥಂ ದೃಷ್ಟಿಂ ಪ್ರಾಪ್ತವಾನ್ ತದಾವಾಂ ನ್ ಜಾನೀವಃ ಕೋಸ್ಯ ಚಕ್ಷುಷೀ ಪ್ರಸನ್ನೇ ಕೃತವಾನ್ ತದಪಿ ನ ಜಾನೀವ ಏಷ ವಯಃಪ್ರಾಪ್ತ ಏನಂ ಪೃಚ್ಛತ ಸ್ವಕಥಾಂ ಸ್ವಯಂ ವಕ್ಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ಯಿಹೂದೀಯಾನಾಂ ಭಯಾತ್ ತಸ್ಯ ಪಿತರೌ ವಾಕ್ಯಮಿದಮ್ ಅವದತಾಂ ಯತಃ ಕೋಪಿ ಮನುಷ್ಯೋ ಯದಿ ಯೀಶುಮ್ ಅಭಿಷಿಕ್ತಂ ವದತಿ ತರ್ಹಿ ಸ ಭಜನಗೃಹಾದ್ ದೂರೀಕಾರಿಷ್ಯತೇ ಯಿಹೂದೀಯಾ ಇತಿ ಮನ್ತ್ರಣಾಮ್ ಅಕುರ್ವ್ವನ್ ");
INSERT INTO sankan_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","ಅತಸ್ತಸ್ಯ ಪಿತರೌ ವ್ಯಾಹರತಾಮ್ ಏಷ ವಯಃಪ್ರಾಪ್ತ ಏನಂ ಪೃಚ್ಛತ| ");
INSERT INTO sankan_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","ತದಾ ತೇ ಪುನಶ್ಚ ತಂ ಪೂರ್ವ್ವಾನ್ಧಮ್ ಆಹೂಯ ವ್ಯಾಹರನ್ ಈಶ್ವರಸ್ಯ ಗುಣಾನ್ ವದ ಏಷ ಮನುಷ್ಯಃ ಪಾಪೀತಿ ವಯಂ ಜಾನೀಮಃ| ");
INSERT INTO sankan_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","ತದಾ ಸ ಉಕ್ತ್ತವಾನ್ ಸ ಪಾಪೀ ನ ವೇತಿ ನಾಹಂ ಜಾನೇ ಪೂರ್ವಾಮನ್ಧ ಆಸಮಹಮ್ ಅಧುನಾ ಪಶ್ಯಾಮೀತಿ ಮಾತ್ರಂ ಜಾನಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ತೇ ಪುನರಪೃಚ್ಛನ್ ಸ ತ್ವಾಂ ಪ್ರತಿ ಕಿಮಕರೋತ್? ಕಥಂ ನೇತ್ರೇ ಪ್ರಸನ್ನೇ ಽಕರೋತ್? ");
INSERT INTO sankan_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","ತತಃ ಸೋವಾದೀದ್ ಏಕಕೃತ್ವೋಕಥಯಂ ಯೂಯಂ ನ ಶೃಣುಥ ತರ್ಹಿ ಕುತಃ ಪುನಃ ಶ್ರೋತುಮ್ ಇಚ್ಛಥ? ಯೂಯಮಪಿ ಕಿಂ ತಸ್ಯ ಶಿಷ್ಯಾ ಭವಿತುಮ್ ಇಚ್ಛಥ? ");
INSERT INTO sankan_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","ತದಾ ತೇ ತಂ ತಿರಸ್ಕೃತ್ಯ ವ್ಯಾಹರನ್ ತ್ವಂ ತಸ್ಯ ಶಿಷ್ಯೋ ವಯಂ ಮೂಸಾಃ ಶಿಷ್ಯಾಃ| ");
INSERT INTO sankan_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","ಮೂಸಾವಕ್ತ್ರೇಣೇಶ್ವರೋ ಜಗಾದ ತಜ್ಜಾನೀಮಃ ಕಿನ್ತ್ವೇಷ ಕುತ್ರತ್ಯಲೋಕ ಇತಿ ನ ಜಾನೀಮಃ| ");
INSERT INTO sankan_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","ಸೋವದದ್ ಏಷ ಮಮ ಲೋಚನೇ ಪ್ರಸನ್ನೇ ಽಕರೋತ್ ತಥಾಪಿ ಕುತ್ರತ್ಯಲೋಕ ಇತಿ ಯೂಯಂ ನ ಜಾನೀಥ ಏತದ್ ಆಶ್ಚರ್ಯ್ಯಂ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ಈಶ್ವರಃ ಪಾಪಿನಾಂ ಕಥಾಂ ನ ಶೃಣೋತಿ ಕಿನ್ತು ಯೋ ಜನಸ್ತಸ್ಮಿನ್ ಭಕ್ತಿಂ ಕೃತ್ವಾ ತದಿಷ್ಟಕ್ರಿಯಾಂ ಕರೋತಿ ತಸ್ಯೈವ ಕಥಾಂ ಶೃಣೋತಿ ಏತದ್ ವಯಂ ಜಾನೀಮಃ| ");
INSERT INTO sankan_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","ಕೋಪಿ ಮನುಷ್ಯೋ ಜನ್ಮಾನ್ಧಾಯ ಚಕ್ಷುಷೀ ಅದದಾತ್ ಜಗದಾರಮ್ಭಾದ್ ಏತಾದೃಶೀಂ ಕಥಾಂ ಕೋಪಿ ಕದಾಪಿ ನಾಶೃಣೋತ್| ");
INSERT INTO sankan_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","ಅಸ್ಮಾದ್ ಏಷ ಮನುಷ್ಯೋ ಯದೀಶ್ವರಾನ್ನಾಜಾಯತ ತರ್ಹಿ ಕಿಞ್ಚಿದಪೀದೃಶಂ ಕರ್ಮ್ಮ ಕರ್ತ್ತುಂ ನಾಶಕ್ನೋತ್| ");
INSERT INTO sankan_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","ತೇ ವ್ಯಾಹರನ್ ತ್ವಂ ಪಾಪಾದ್ ಅಜಾಯಥಾಃ ಕಿಮಸ್ಮಾನ್ ತ್ವಂ ಶಿಕ್ಷಯಸಿ? ಪಶ್ಚಾತ್ತೇ ತಂ ಬಹಿರಕುರ್ವ್ವನ್| ");
INSERT INTO sankan_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","ತದನನ್ತರಂ ಯಿಹೂದೀಯೈಃ ಸ ಬಹಿರಕ್ರಿಯತ ಯೀಶುರಿತಿ ವಾರ್ತ್ತಾಂ ಶ್ರುತ್ವಾ ತಂ ಸಾಕ್ಷಾತ್ ಪ್ರಾಪ್ಯ ಪೃಷ್ಟವಾನ್ ಈಶ್ವರಸ್ಯ ಪುತ್ರೇ ತ್ವಂ ವಿಶ್ವಸಿಷಿ? ");
INSERT INTO sankan_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","ತದಾ ಸ ಪ್ರತ್ಯವೋಚತ್ ಹೇ ಪ್ರಭೋ ಸ ಕೋ ಯತ್ ತಸ್ಮಿನ್ನಹಂ ವಿಶ್ವಸಿಮಿ? ");
INSERT INTO sankan_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ತತೋ ಯೀಶುಃ ಕಥಿತವಾನ್ ತ್ವಂ ತಂ ದೃಷ್ಟವಾನ್ ತ್ವಯಾ ಸಾಕಂ ಯಃ ಕಥಂ ಕಥಯತಿ ಸಏವ ಸಃ| ");
INSERT INTO sankan_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","ತದಾ ಹೇ ಪ್ರಭೋ ವಿಶ್ವಸಿಮೀತ್ಯುಕ್ತ್ವಾ ಸ ತಂ ಪ್ರಣಾಮತ್| ");
INSERT INTO sankan_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","ಪಶ್ಚಾದ್ ಯೀಶುಃ ಕಥಿತವಾನ್ ನಯನಹೀನಾ ನಯನಾನಿ ಪ್ರಾಪ್ನುವನ್ತಿ ನಯನವನ್ತಶ್ಚಾನ್ಧಾ ಭವನ್ತೀತ್ಯಭಿಪ್ರಾಯೇಣ ಜಗದಾಹಮ್ ಆಗಚ್ಛಮ್| ");
INSERT INTO sankan_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ಏತತ್ ಶ್ರುತ್ವಾ ನಿಕಟಸ್ಥಾಃ ಕತಿಪಯಾಃ ಫಿರೂಶಿನೋ ವ್ಯಾಹರನ್ ವಯಮಪಿ ಕಿಮನ್ಧಾಃ? ");
INSERT INTO sankan_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","ತದಾ ಯೀಶುರವಾದೀದ್ ಯದ್ಯನ್ಧಾ ಅಭವತ ತರ್ಹಿ ಪಾಪಾನಿ ನಾತಿಷ್ಠನ್ ಕಿನ್ತು ಪಶ್ಯಾಮೀತಿ ವಾಕ್ಯವದನಾದ್ ಯುಷ್ಮಾಕಂ ಪಾಪಾನಿ ತಿಷ್ಠನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ಅಹಂ ಯುಷ್ಮಾನತಿಯಥಾರ್ಥಂ ವದಾಮಿ, ಯೋ ಜನೋ ದ್ವಾರೇಣ ನ ಪ್ರವಿಶ್ಯ ಕೇನಾಪ್ಯನ್ಯೇನ ಮೇಷಗೃಹಂ ಪ್ರವಿಶತಿ ಸ ಏವ ಸ್ತೇನೋ ದಸ್ಯುಶ್ಚ| ");
INSERT INTO sankan_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","ಯೋ ದ್ವಾರೇಣ ಪ್ರವಿಶತಿ ಸ ಏವ ಮೇಷಪಾಲಕಃ| ");
INSERT INTO sankan_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ದೌವಾರಿಕಸ್ತಸ್ಮೈ ದ್ವಾರಂ ಮೋಚಯತಿ ಮೇಷಗಣಶ್ಚ ತಸ್ಯ ವಾಕ್ಯಂ ಶೃಣೋತಿ ಸ ನಿಜಾನ್ ಮೇಷಾನ್ ಸ್ವಸ್ವನಾಮ್ನಾಹೂಯ ಬಹಿಃ ಕೃತ್ವಾ ನಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","ತಥಾ ನಿಜಾನ್ ಮೇಷಾನ್ ಬಹಿಃ ಕೃತ್ವಾ ಸ್ವಯಂ ತೇಷಾಮ್ ಅಗ್ರೇ ಗಚ್ಛತಿ, ತತೋ ಮೇಷಾಸ್ತಸ್ಯ ಶಬ್ದಂ ಬುಧ್ಯನ್ತೇ, ತಸ್ಮಾತ್ ತಸ್ಯ ಪಶ್ಚಾದ್ ವ್ರಜನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","ಕಿನ್ತು ಪರಸ್ಯ ಶಬ್ದಂ ನ ಬುಧ್ಯನ್ತೇ ತಸ್ಮಾತ್ ತಸ್ಯ ಪಶ್ಚಾದ್ ವ್ರಜಿಷ್ಯನ್ತಿ ವರಂ ತಸ್ಯ ಸಮೀಪಾತ್ ಪಲಾಯಿಷ್ಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","ಯೀಶುಸ್ತೇಭ್ಯ ಇಮಾಂ ದೃಷ್ಟಾನ್ತಕಥಾಮ್ ಅಕಥಯತ್ ಕಿನ್ತು ತೇನ ಕಥಿತಕಥಾಯಾಸ್ತಾತ್ಪರ್ಯ್ಯಂ ತೇ ನಾಬುಧ್ಯನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","ಅತೋ ಯೀಶುಃ ಪುನರಕಥಯತ್, ಯುಷ್ಮಾನಾಹಂ ಯಥಾರ್ಥತರಂ ವ್ಯಾಹರಾಮಿ, ಮೇಷಗೃಹಸ್ಯ ದ್ವಾರಮ್ ಅಹಮೇವ| ");
INSERT INTO sankan_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ಮಯಾ ನ ಪ್ರವಿಶ್ಯ ಯ ಆಗಚ್ಛನ್ ತೇ ಸ್ತೇನಾ ದಸ್ಯವಶ್ಚ ಕಿನ್ತು ಮೇಷಾಸ್ತೇಷಾಂ ಕಥಾ ನಾಶೃಣ್ವನ್| ");
INSERT INTO sankan_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","ಅಹಮೇವ ದ್ವಾರಸ್ವರೂಪಃ, ಮಯಾ ಯಃ ಕಶ್ಚಿತ ಪ್ರವಿಶತಿ ಸ ರಕ್ಷಾಂ ಪ್ರಾಪ್ಸ್ಯತಿ ತಥಾ ಬಹಿರನ್ತಶ್ಚ ಗಮನಾಗಮನೇ ಕೃತ್ವಾ ಚರಣಸ್ಥಾನಂ ಪ್ರಾಪ್ಸ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","ಯೋ ಜನಸ್ತೇನಃ ಸ ಕೇವಲಂ ಸ್ತೈನ್ಯಬಧವಿನಾಶಾನ್ ಕರ್ತ್ತುಮೇವ ಸಮಾಯಾತಿ ಕಿನ್ತ್ವಹಮ್ ಆಯು ರ್ದಾತುಮ್ ಅರ್ಥಾತ್ ಬಾಹೂಲ್ಯೇನ ತದೇವ ದಾತುಮ್ ಆಗಚ್ಛಮ್| ");
INSERT INTO sankan_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","ಅಹಮೇವ ಸತ್ಯಮೇಷಪಾಲಕೋ ಯಸ್ತು ಸತ್ಯೋ ಮೇಷಪಾಲಕಃ ಸ ಮೇಷಾರ್ಥಂ ಪ್ರಾಣತ್ಯಾಗಂ ಕರೋತಿ; ");
INSERT INTO sankan_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","ಕಿನ್ತು ಯೋ ಜನೋ ಮೇಷಪಾಲಕೋ ನ, ಅರ್ಥಾದ್ ಯಸ್ಯ ಮೇಷಾ ನಿಜಾ ನ ಭವನ್ತಿ, ಯ ಏತಾದೃಶೋ ವೈತನಿಕಃ ಸ ವೃಕಮ್ ಆಗಚ್ಛನ್ತಂ ದೃಷ್ಟ್ವಾ ಮೇಜವ್ರಜಂ ವಿಹಾಯ ಪಲಾಯತೇ, ತಸ್ಮಾದ್ ವೃಕಸ್ತಂ ವ್ರಜಂ ಧೃತ್ವಾ ವಿಕಿರತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ವೈತನಿಕಃ ಪಲಾಯತೇ ಯತಃ ಸ ವೇತನಾರ್ಥೀ ಮೇಷಾರ್ಥಂ ನ ಚಿನ್ತಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","ಅಹಮೇವ ಸತ್ಯೋ ಮೇಷಪಾಲಕಃ, ಪಿತಾ ಮಾಂ ಯಥಾ ಜಾನಾತಿ, ಅಹಞ್ಚ ಯಥಾ ಪಿತರಂ ಜಾನಾಮಿ, ");
INSERT INTO sankan_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ತಥಾ ನಿಜಾನ್ ಮೇಷಾನಪಿ ಜಾನಾಮಿ, ಮೇಷಾಶ್ಚ ಮಾಂ ಜಾನಾನ್ತಿ, ಅಹಞ್ಚ ಮೇಷಾರ್ಥಂ ಪ್ರಾಣತ್ಯಾಗಂ ಕರೋಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","ಅಪರಞ್ಚ ಏತದ್ ಗೃಹೀಯ ಮೇಷೇಭ್ಯೋ ಭಿನ್ನಾ ಅಪಿ ಮೇಷಾ ಮಮ ಸನ್ತಿ ತೇ ಸಕಲಾ ಆನಯಿತವ್ಯಾಃ; ತೇ ಮಮ ಶಬ್ದಂ ಶ್ರೋಷ್ಯನ್ತಿ ತತ ಏಕೋ ವ್ರಜ ಏಕೋ ರಕ್ಷಕೋ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","ಪ್ರಾಣಾನಹಂ ತ್ಯಕ್ತ್ವಾ ಪುನಃ ಪ್ರಾಣಾನ್ ಗ್ರಹೀಷ್ಯಾಮಿ, ತಸ್ಮಾತ್ ಪಿತಾ ಮಯಿ ಸ್ನೇಹಂ ಕರೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","ಕಶ್ಚಿಜ್ಜನೋ ಮಮ ಪ್ರಾಣಾನ್ ಹನ್ತುಂ ನ ಶಕ್ನೋತಿ ಕಿನ್ತು ಸ್ವಯಂ ತಾನ್ ಸಮರ್ಪಯಾಮಿ ತಾನ್ ಸಮರ್ಪಯಿತುಂ ಪುನರ್ಗ್ರಹೀತುಞ್ಚ ಮಮ ಶಕ್ತಿರಾಸ್ತೇ ಭಾರಮಿಮಂ ಸ್ವಪಿತುಃ ಸಕಾಶಾತ್ ಪ್ರಾಪ್ತೋಹಮ್| ");
INSERT INTO sankan_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","ಅಸ್ಮಾದುಪದೇಶಾತ್ ಪುನಶ್ಚ ಯಿಹೂದೀಯಾನಾಂ ಮಧ್ಯೇ ಭಿನ್ನವಾಕ್ಯತಾ ಜಾತಾ| ");
INSERT INTO sankan_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ತತೋ ಬಹವೋ ವ್ಯಾಹರನ್ ಏಷ ಭೂತಗ್ರಸ್ತ ಉನ್ಮತ್ತಶ್ಚ, ಕುತ ಏತಸ್ಯ ಕಥಾಂ ಶೃಣುಥ? ");
INSERT INTO sankan_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","ಕೇಚಿದ್ ಅವದನ್ ಏತಸ್ಯ ಕಥಾ ಭೂತಗ್ರಸ್ತಸ್ಯ ಕಥಾವನ್ನ ಭವನ್ತಿ, ಭೂತಃ ಕಿಮ್ ಅನ್ಧಾಯ ಚಕ್ಷುಷೀ ದಾತುಂ ಶಕ್ನೋತಿ? ");
INSERT INTO sankan_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","ಶೀತಕಾಲೇ ಯಿರೂಶಾಲಮಿ ಮನ್ದಿರೋತ್ಸರ್ಗಪರ್ವ್ವಣ್ಯುಪಸ್ಥಿತೇ ");
INSERT INTO sankan_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ಯೀಶುಃ ಸುಲೇಮಾನೋ ನಿಃಸಾರೇಣ ಗಮನಾಗಮನೇ ಕರೋತಿ, ");
INSERT INTO sankan_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ಏತಸ್ಮಿನ್ ಸಮಯೇ ಯಿಹೂದೀಯಾಸ್ತಂ ವೇಷ್ಟಯಿತ್ವಾ ವ್ಯಾಹರನ್ ಕತಿ ಕಾಲಾನ್ ಅಸ್ಮಾಕಂ ವಿಚಿಕಿತ್ಸಾಂ ಸ್ಥಾಪಯಿಷ್ಯಾಮಿ? ಯದ್ಯಭಿಷಿಕ್ತೋ ಭವತಿ ತರ್ಹಿ ತತ್ ಸ್ಪಷ್ಟಂ ವದ| ");
INSERT INTO sankan_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","ತದಾ ಯೀಶುಃ ಪ್ರತ್ಯವದದ್ ಅಹಮ್ ಅಚಕಥಂ ಕಿನ್ತು ಯೂಯಂ ನ ಪ್ರತೀಥ, ನಿಜಪಿತು ರ್ನಾಮ್ನಾ ಯಾಂ ಯಾಂ ಕ್ರಿಯಾಂ ಕರೋಮಿ ಸಾ ಕ್ರಿಯೈವ ಮಮ ಸಾಕ್ಷಿಸ್ವರೂಪಾ| ");
INSERT INTO sankan_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ಕಿನ್ತ್ವಹಂ ಪೂರ್ವ್ವಮಕಥಯಂ ಯೂಯಂ ಮಮ ಮೇಷಾ ನ ಭವಥ, ಕಾರಣಾದಸ್ಮಾನ್ ನ ವಿಶ್ವಸಿಥ| ");
INSERT INTO sankan_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","ಮಮ ಮೇಷಾ ಮಮ ಶಬ್ದಂ ಶೃಣ್ವನ್ತಿ ತಾನಹಂ ಜಾನಾಮಿ ತೇ ಚ ಮಮ ಪಶ್ಚಾದ್ ಗಚ್ಛನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ಅಹಂ ತೇಭ್ಯೋಽನನ್ತಾಯು ರ್ದದಾಮಿ, ತೇ ಕದಾಪಿ ನ ನಂಕ್ಷ್ಯನ್ತಿ ಕೋಪಿ ಮಮ ಕರಾತ್ ತಾನ್ ಹರ್ತ್ತುಂ ನ ಶಕ್ಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","ಯೋ ಮಮ ಪಿತಾ ತಾನ್ ಮಹ್ಯಂ ದತ್ತವಾನ್ ಸ ಸರ್ವ್ವಸ್ಮಾತ್ ಮಹಾನ್, ಕೋಪಿ ಮಮ ಪಿತುಃ ಕರಾತ್ ತಾನ್ ಹರ್ತ್ತುಂ ನ ಶಕ್ಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ಅಹಂ ಪಿತಾ ಚ ದ್ವಯೋರೇಕತ್ವಮ್| ");
INSERT INTO sankan_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","ತತೋ ಯಿಹೂದೀಯಾಃ ಪುನರಪಿ ತಂ ಹನ್ತುಂ ಪಾಷಾಣಾನ್ ಉದತೋಲಯನ್| ");
INSERT INTO sankan_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ಯೀಶುಃ ಕಥಿತವಾನ್ ಪಿತುಃ ಸಕಾಶಾದ್ ಬಹೂನ್ಯುತ್ತಮಕರ್ಮ್ಮಾಣಿ ಯುಷ್ಮಾಕಂ ಪ್ರಾಕಾಶಯಂ ತೇಷಾಂ ಕಸ್ಯ ಕರ್ಮ್ಮಣಃ ಕಾರಣಾನ್ ಮಾಂ ಪಾಷಾಣೈರಾಹನ್ತುಮ್ ಉದ್ಯತಾಃ ಸ್ಥ? ");
INSERT INTO sankan_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","ಯಿಹೂದೀಯಾಃ ಪ್ರತ್ಯವದನ್ ಪ್ರಶಸ್ತಕರ್ಮ್ಮಹೇತೋ ರ್ನ ಕಿನ್ತು ತ್ವಂ ಮಾನುಷಃ ಸ್ವಮೀಶ್ವರಮ್ ಉಕ್ತ್ವೇಶ್ವರಂ ನಿನ್ದಸಿ ಕಾರಣಾದಸ್ಮಾತ್ ತ್ವಾಂ ಪಾಷಾಣೈರ್ಹನ್ಮಃ| ");
INSERT INTO sankan_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","ತದಾ ಯೀಶುಃ ಪ್ರತ್ಯುಕ್ತವಾನ್ ಮಯಾ ಕಥಿತಂ ಯೂಯಮ್ ಈಶ್ವರಾ ಏತದ್ವಚನಂ ಯುಷ್ಮಾಕಂ ಶಾಸ್ತ್ರೇ ಲಿಖಿತಂ ನಾಸ್ತಿ ಕಿಂ? ");
INSERT INTO sankan_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","ತಸ್ಮಾದ್ ಯೇಷಾಮ್ ಉದ್ದೇಶೇ ಈಶ್ವರಸ್ಯ ಕಥಾ ಕಥಿತಾ ತೇ ಯದೀಶ್ವರಗಣಾ ಉಚ್ಯನ್ತೇ ಧರ್ಮ್ಮಗ್ರನ್ಥಸ್ಯಾಪ್ಯನ್ಯಥಾ ಭವಿತುಂ ನ ಶಕ್ಯಂ, ");
INSERT INTO sankan_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ತರ್ಹ್ಯಾಹಮ್ ಈಶ್ವರಸ್ಯ ಪುತ್ರ ಇತಿ ವಾಕ್ಯಸ್ಯ ಕಥನಾತ್ ಯೂಯಂ ಪಿತ್ರಾಭಿಷಿಕ್ತಂ ಜಗತಿ ಪ್ರೇರಿತಞ್ಚ ಪುಮಾಂಸಂ ಕಥಮ್ ಈಶ್ವರನಿನ್ದಕಂ ವಾದಯ? ");
INSERT INTO sankan_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","ಯದ್ಯಹಂ ಪಿತುಃ ಕರ್ಮ್ಮ ನ ಕರೋಮಿ ತರ್ಹಿ ಮಾಂ ನ ಪ್ರತೀತ; ");
INSERT INTO sankan_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","ಕಿನ್ತು ಯದಿ ಕರೋಮಿ ತರ್ಹಿ ಮಯಿ ಯುಷ್ಮಾಭಿಃ ಪ್ರತ್ಯಯೇ ನ ಕೃತೇಽಪಿ ಕಾರ್ಯ್ಯೇ ಪ್ರತ್ಯಯಃ ಕ್ರಿಯತಾಂ, ತತೋ ಮಯಿ ಪಿತಾಸ್ತೀತಿ ಪಿತರ್ಯ್ಯಹಮ್ ಅಸ್ಮೀತಿ ಚ ಕ್ಷಾತ್ವಾ ವಿಶ್ವಸಿಷ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ತದಾ ತೇ ಪುನರಪಿ ತಂ ಧರ್ತ್ತುಮ್ ಅಚೇಷ್ಟನ್ತ ಕಿನ್ತು ಸ ತೇಷಾಂ ಕರೇಭ್ಯೋ ನಿಸ್ತೀರ್ಯ್ಯ ");
INSERT INTO sankan_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ಪುನ ರ್ಯರ್ದ್ದನ್ ಅದ್ಯಾಸ್ತಟೇ ಯತ್ರ ಪುರ್ವ್ವಂ ಯೋಹನ್ ಅಮಜ್ಜಯತ್ ತತ್ರಾಗತ್ಯ ನ್ಯವಸತ್| ");
INSERT INTO sankan_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ತತೋ ಬಹವೋ ಲೋಕಾಸ್ತತ್ಸಮೀಪಮ್ ಆಗತ್ಯ ವ್ಯಾಹರನ್ ಯೋಹನ್ ಕಿಮಪ್ಯಾಶ್ಚರ್ಯ್ಯಂ ಕರ್ಮ್ಮ ನಾಕರೋತ್ ಕಿನ್ತ್ವಸ್ಮಿನ್ ಮನುಷ್ಯೇ ಯಾ ಯಃ ಕಥಾ ಅಕಥಯತ್ ತಾಃ ಸರ್ವ್ವಾಃ ಸತ್ಯಾಃ; ");
INSERT INTO sankan_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ತತ್ರ ಚ ಬಹವೋ ಲೋಕಾಸ್ತಸ್ಮಿನ್ ವ್ಯಶ್ವಸನ್| ");
INSERT INTO sankan_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","ಅನನ್ತರಂ ಮರಿಯಮ್ ತಸ್ಯಾ ಭಗಿನೀ ಮರ್ಥಾ ಚ ಯಸ್ಮಿನ್ ವೈಥನೀಯಾಗ್ರಾಮೇ ವಸತಸ್ತಸ್ಮಿನ್ ಗ್ರಾಮೇ ಇಲಿಯಾಸರ್ ನಾಮಾ ಪೀಡಿತ ಏಕ ಆಸೀತ್| ");
INSERT INTO sankan_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ಯಾ ಮರಿಯಮ್ ಪ್ರಭುಂ ಸುಗನ್ಧಿತೇಲೈನ ಮರ್ದ್ದಯಿತ್ವಾ ಸ್ವಕೇಶೈಸ್ತಸ್ಯ ಚರಣೌ ಸಮಮಾರ್ಜತ್ ತಸ್ಯಾ ಭ್ರಾತಾ ಸ ಇಲಿಯಾಸರ್ ರೋಗೀ| ");
INSERT INTO sankan_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ಅಪರಞ್ಚ ಹೇ ಪ್ರಭೋ ಭವಾನ್ ಯಸ್ಮಿನ್ ಪ್ರೀಯತೇ ಸ ಏವ ಪೀಡಿತೋಸ್ತೀತಿ ಕಥಾಂ ಕಥಯಿತ್ವಾ ತಸ್ಯ ಭಗಿನ್ಯೌ ಪ್ರೇಷಿತವತ್ಯೌ| ");
INSERT INTO sankan_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ತದಾ ಯೀಶುರಿಮಾಂ ವಾರ್ತ್ತಾಂ ಶ್ರುತ್ವಾಕಥಯತ ಪೀಡೇಯಂ ಮರಣಾರ್ಥಂ ನ ಕಿನ್ತ್ವೀಶ್ವರಸ್ಯ ಮಹಿಮಾರ್ಥಮ್ ಈಶ್ವರಪುತ್ರಸ್ಯ ಮಹಿಮಪ್ರಕಾಶಾರ್ಥಞ್ಚ ಜಾತಾ| ");
INSERT INTO sankan_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","ಯೀಶು ರ್ಯದ್ಯಪಿಮರ್ಥಾಯಾಂ ತದ್ಭಗಿನ್ಯಾಮ್ ಇಲಿಯಾಸರಿ ಚಾಪ್ರೀಯತ, ");
INSERT INTO sankan_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ತಥಾಪಿ ಇಲಿಯಾಸರಃ ಪೀಡಾಯಾಃ ಕಥಂ ಶ್ರುತ್ವಾ ಯತ್ರ ಆಸೀತ್ ತತ್ರೈವ ದಿನದ್ವಯಮತಿಷ್ಠತ್| ");
INSERT INTO sankan_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ತತಃ ಪರಮ್ ಸ ಶಿಷ್ಯಾನಕಥಯದ್ ವಯಂ ಪುನ ರ್ಯಿಹೂದೀಯಪ್ರದೇಶಂ ಯಾಮಃ| ");
INSERT INTO sankan_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","ತತಸ್ತೇ ಪ್ರತ್ಯವದನ್, ಹೇ ಗುರೋ ಸ್ವಲ್ಪದಿನಾನಿ ಗತಾನಿ ಯಿಹೂದೀಯಾಸ್ತ್ವಾಂ ಪಾಷಾಣೈ ರ್ಹನ್ತುಮ್ ಉದ್ಯತಾಸ್ತಥಾಪಿ ಕಿಂ ಪುನಸ್ತತ್ರ ಯಾಸ್ಯಸಿ? ");
INSERT INTO sankan_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","ಯೀಶುಃ ಪ್ರತ್ಯವದತ್, ಏಕಸ್ಮಿನ್ ದಿನೇ ಕಿಂ ದ್ವಾದಶಘಟಿಕಾ ನ ಭವನ್ತಿ? ಕೋಪಿ ದಿವಾ ಗಚ್ಛನ್ ನ ಸ್ಖಲತಿ ಯತಃ ಸ ಏತಜ್ಜಗತೋ ದೀಪ್ತಿಂ ಪ್ರಾಪ್ನೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ಕಿನ್ತು ರಾತ್ರೌ ಗಚ್ಛನ್ ಸ್ಖಲತಿ ಯತೋ ಹೇತೋಸ್ತತ್ರ ದೀಪ್ತಿ ರ್ನಾಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ಇಮಾಂ ಕಥಾಂ ಕಥಯಿತ್ವಾ ಸ ತಾನವದದ್, ಅಸ್ಮಾಕಂ ಬನ್ಧುಃ ಇಲಿಯಾಸರ್ ನಿದ್ರಿತೋಭೂದ್ ಇದಾನೀಂ ತಂ ನಿದ್ರಾತೋ ಜಾಗರಯಿತುಂ ಗಚ್ಛಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","ಯೀಶು ರ್ಮೃತೌ ಕಥಾಮಿಮಾಂ ಕಥಿತವಾನ್ ಕಿನ್ತು ವಿಶ್ರಾಮಾರ್ಥಂ ನಿದ್ರಾಯಾಂ ಕಥಿತವಾನ್ ಇತಿ ಜ್ಞಾತ್ವಾ ಶಿಷ್ಯಾ ಅಕಥಯನ್, ");
INSERT INTO sankan_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ಹೇ ಗುರೋ ಸ ಯದಿ ನಿದ್ರಾತಿ ತರ್ಹಿ ಭದ್ರಮೇವ| ");
INSERT INTO sankan_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","ತದಾ ಯೀಶುಃ ಸ್ಪಷ್ಟಂ ತಾನ್ ವ್ಯಾಹರತ್, ಇಲಿಯಾಸರ್ ಅಮ್ರಿಯತ; ");
INSERT INTO sankan_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ಕಿನ್ತು ಯೂಯಂ ಯಥಾ ಪ್ರತೀಥ ತದರ್ಥಮಹಂ ತತ್ರ ನ ಸ್ಥಿತವಾನ್ ಇತ್ಯಸ್ಮಾದ್ ಯುಷ್ಮನ್ನಿಮಿತ್ತಮ್ ಆಹ್ಲಾದಿತೋಹಂ, ತಥಾಪಿ ತಸ್ಯ ಸಮೀಪೇ ಯಾಮ| ");
INSERT INTO sankan_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","ತದಾ ಥೋಮಾ ಯಂ ದಿದುಮಂ ವದನ್ತಿ ಸ ಸಙ್ಗಿನಃ ಶಿಷ್ಯಾನ್ ಅವದದ್ ವಯಮಪಿ ಗತ್ವಾ ತೇನ ಸಾರ್ದ್ಧಂ ಮ್ರಿಯಾಮಹೈ| ");
INSERT INTO sankan_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","ಯೀಶುಸ್ತತ್ರೋಪಸ್ಥಾಯ ಇಲಿಯಾಸರಃ ಶ್ಮಶಾನೇ ಸ್ಥಾಪನಾತ್ ಚತ್ವಾರಿ ದಿನಾನಿ ಗತಾನೀತಿ ವಾರ್ತ್ತಾಂ ಶ್ರುತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","ವೈಥನೀಯಾ ಯಿರೂಶಾಲಮಃ ಸಮೀಪಸ್ಥಾ ಕ್ರೋಶೈಕಮಾತ್ರಾನ್ತರಿತಾ; ");
INSERT INTO sankan_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ತಸ್ಮಾದ್ ಬಹವೋ ಯಿಹೂದೀಯಾ ಮರ್ಥಾಂ ಮರಿಯಮಞ್ಚ ಭ್ಯಾತೃಶೋಕಾಪನ್ನಾಂ ಸಾನ್ತ್ವಯಿತುಂ ತಯೋಃ ಸಮೀಪಮ್ ಆಗಚ್ಛನ್| ");
INSERT INTO sankan_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","ಮರ್ಥಾ ಯೀಶೋರಾಗಮನವಾರ್ತಾಂ ಶ್ರುತ್ವೈವ ತಂ ಸಾಕ್ಷಾದ್ ಅಕರೋತ್ ಕಿನ್ತು ಮರಿಯಮ್ ಗೇಹ ಉಪವಿಶ್ಯ ಸ್ಥಿತಾ| ");
INSERT INTO sankan_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","ತದಾ ಮರ್ಥಾ ಯೀಶುಮವಾದತ್, ಹೇ ಪ್ರಭೋ ಯದಿ ಭವಾನ್ ಅತ್ರಾಸ್ಥಾಸ್ಯತ್ ತರ್ಹಿ ಮಮ ಭ್ರಾತಾ ನಾಮರಿಷ್ಯತ್| ");
INSERT INTO sankan_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","ಕಿನ್ತ್ವಿದಾನೀಮಪಿ ಯದ್ ಈಶ್ವರೇ ಪ್ರಾರ್ಥಯಿಷ್ಯತೇ ಈಶ್ವರಸ್ತದ್ ದಾಸ್ಯತೀತಿ ಜಾನೇಽಹಂ| ");
INSERT INTO sankan_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","ಯೀಶುರವಾದೀತ್ ತವ ಭ್ರಾತಾ ಸಮುತ್ಥಾಸ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","ಮರ್ಥಾ ವ್ಯಾಹರತ್ ಶೇಷದಿವಸೇ ಸ ಉತ್ಥಾನಸಮಯೇ ಪ್ರೋತ್ಥಾಸ್ಯತೀತಿ ಜಾನೇಽಹಂ| ");
INSERT INTO sankan_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","ತದಾ ಯೀಶುಃ ಕಥಿತವಾನ್ ಅಹಮೇವ ಉತ್ಥಾಪಯಿತಾ ಜೀವಯಿತಾ ಚ ಯಃ ಕಶ್ಚನ ಮಯಿ ವಿಶ್ವಸಿತಿ ಸ ಮೃತ್ವಾಪಿ ಜೀವಿಷ್ಯತಿ; ");
INSERT INTO sankan_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ಯಃ ಕಶ್ಚನ ಚ ಜೀವನ್ ಮಯಿ ವಿಶ್ವಸಿತಿ ಸ ಕದಾಪಿ ನ ಮರಿಷ್ಯತಿ, ಅಸ್ಯಾಂ ಕಥಾಯಾಂ ಕಿಂ ವಿಶ್ವಸಿಷಿ? ");
INSERT INTO sankan_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ಸಾವದತ್ ಪ್ರಭೋ ಯಸ್ಯಾವತರಣಾಪೇಕ್ಷಾಸ್ತಿ ಭವಾನ್ ಸಏವಾಭಿಷಿಕ್ತ್ತ ಈಶ್ವರಪುತ್ರ ಇತಿ ವಿಶ್ವಸಿಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ಇತಿ ಕಥಾಂ ಕಥಯಿತ್ವಾ ಸಾ ಗತ್ವಾ ಸ್ವಾಂ ಭಗಿನೀಂ ಮರಿಯಮಂ ಗುಪ್ತಮಾಹೂಯ ವ್ಯಾಹರತ್ ಗುರುರುಪತಿಷ್ಠತಿ ತ್ವಾಮಾಹೂಯತಿ ಚ| ");
INSERT INTO sankan_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","ಕಥಾಮಿಮಾಂ ಶ್ರುತ್ವಾ ಸಾ ತೂರ್ಣಮ್ ಉತ್ಥಾಯ ತಸ್ಯ ಸಮೀಪಮ್ ಅಗಚ್ಛತ್| ");
INSERT INTO sankan_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ಯೀಶು ರ್ಗ್ರಾಮಮಧ್ಯಂ ನ ಪ್ರವಿಶ್ಯ ಯತ್ರ ಮರ್ಥಾ ತಂ ಸಾಕ್ಷಾದ್ ಅಕರೋತ್ ತತ್ರ ಸ್ಥಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","ಯೇ ಯಿಹೂದೀಯಾ ಮರಿಯಮಾ ಸಾಕಂ ಗೃಹೇ ತಿಷ್ಠನ್ತಸ್ತಾಮ್ ಅಸಾನ್ತ್ವಯನ ತೇ ತಾಂ ಕ್ಷಿಪ್ರಮ್ ಉತ್ಥಾಯ ಗಚ್ಛನ್ತಿಂ ವಿಲೋಕ್ಯ ವ್ಯಾಹರನ್, ಸ ಶ್ಮಶಾನೇ ರೋದಿತುಂ ಯಾತಿ, ಇತ್ಯುಕ್ತ್ವಾ ತೇ ತಸ್ಯಾಃ ಪಶ್ಚಾದ್ ಅಗಚ್ಛನ್| ");
INSERT INTO sankan_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","ಯತ್ರ ಯೀಶುರತಿಷ್ಠತ್ ತತ್ರ ಮರಿಯಮ್ ಉಪಸ್ಥಾಯ ತಂ ದೃಷ್ಟ್ವಾ ತಸ್ಯ ಚರಣಯೋಃ ಪತಿತ್ವಾ ವ್ಯಾಹರತ್ ಹೇ ಪ್ರಭೋ ಯದಿ ಭವಾನ್ ಅತ್ರಾಸ್ಥಾಸ್ಯತ್ ತರ್ಹಿ ಮಮ ಭ್ರಾತಾ ನಾಮರಿಷ್ಯತ್| ");
INSERT INTO sankan_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","ಯೀಶುಸ್ತಾಂ ತಸ್ಯಾಃ ಸಙ್ಗಿನೋ ಯಿಹೂದೀಯಾಂಶ್ಚ ರುದತೋ ವಿಲೋಕ್ಯ ಶೋಕಾರ್ತ್ತಃ ಸನ್ ದೀರ್ಘಂ ನಿಶ್ವಸ್ಯ ಕಥಿತವಾನ್ ತಂ ಕುತ್ರಾಸ್ಥಾಪಯತ? ");
INSERT INTO sankan_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ತೇ ವ್ಯಾಹರನ್, ಹೇ ಪ್ರಭೋ ಭವಾನ್ ಆಗತ್ಯ ಪಶ್ಯತು| ");
INSERT INTO sankan_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","ಯೀಶುನಾ ಕ್ರನ್ದಿತಂ| ");
INSERT INTO sankan_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ಅತಏವ ಯಿಹೂದೀಯಾ ಅವದನ್, ಪಶ್ಯತಾಯಂ ತಸ್ಮಿನ್ ಕಿದೃಗ್ ಅಪ್ರಿಯತ| ");
INSERT INTO sankan_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","ತೇಷಾಂ ಕೇಚಿದ್ ಅವದನ್ ಯೋನ್ಧಾಯ ಚಕ್ಷುಷೀ ದತ್ತವಾನ್ ಸ ಕಿಮ್ ಅಸ್ಯ ಮೃತ್ಯುಂ ನಿವಾರಯಿತುಂ ನಾಶಕ್ನೋತ್? ");
INSERT INTO sankan_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","ತತೋ ಯೀಶುಃ ಪುನರನ್ತರ್ದೀರ್ಘಂ ನಿಶ್ವಸ್ಯ ಶ್ಮಶಾನಾನ್ತಿಕಮ್ ಅಗಚ್ಛತ್| ತತ್ ಶ್ಮಶಾನಮ್ ಏಕಂ ಗಹ್ವರಂ ತನ್ಮುಖೇ ಪಾಷಾಣ ಏಕ ಆಸೀತ್| ");
INSERT INTO sankan_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","ತದಾ ಯೀಶುರವದದ್ ಏನಂ ಪಾಷಾಣಮ್ ಅಪಸಾರಯತ, ತತಃ ಪ್ರಮೀತಸ್ಯ ಭಗಿನೀ ಮರ್ಥಾವದತ್ ಪ್ರಭೋ, ಅಧುನಾ ತತ್ರ ದುರ್ಗನ್ಧೋ ಜಾತಃ, ಯತೋದ್ಯ ಚತ್ವಾರಿ ದಿನಾನಿ ಶ್ಮಶಾನೇ ಸ ತಿಷ್ಠತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","ತದಾ ಯೀಶುರವಾದೀತ್, ಯದಿ ವಿಶ್ವಸಿಷಿ ತರ್ಹೀಶ್ವರಸ್ಯ ಮಹಿಮಪ್ರಕಾಶಂ ದ್ರಕ್ಷ್ಯಸಿ ಕಥಾಮಿಮಾಂ ಕಿಂ ತುಭ್ಯಂ ನಾಕಥಯಂ? ");
INSERT INTO sankan_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","ತದಾ ಮೃತಸ್ಯ ಶ್ಮಶಾನಾತ್ ಪಾಷಾಣೋಽಪಸಾರಿತೇ ಯೀಶುರೂರ್ದ್ವ್ವಂ ಪಶ್ಯನ್ ಅಕಥಯತ್, ಹೇ ಪಿತ ರ್ಮಮ ನೇವೇಸನಮ್ ಅಶೃಣೋಃ ಕಾರಣಾದಸ್ಮಾತ್ ತ್ವಾಂ ಧನ್ಯಂ ವದಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ತ್ವಂ ಸತತಂ ಶೃಣೋಷಿ ತದಪ್ಯಹಂ ಜಾನಾಮಿ, ಕಿನ್ತು ತ್ವಂ ಮಾಂ ಯತ್ ಪ್ರೈರಯಸ್ತದ್ ಯಥಾಸ್ಮಿನ್ ಸ್ಥಾನೇ ಸ್ಥಿತಾ ಲೋಕಾ ವಿಶ್ವಸನ್ತಿ ತದರ್ಥಮ್ ಇದಂ ವಾಕ್ಯಂ ವದಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ಇಮಾಂ ಕಥಾಂ ಕಥಯಿತ್ವಾ ಸ ಪ್ರೋಚ್ಚೈರಾಹ್ವಯತ್, ಹೇ ಇಲಿಯಾಸರ್ ಬಹಿರಾಗಚ್ಛ| ");
INSERT INTO sankan_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","ತತಃ ಸ ಪ್ರಮೀತಃ ಶ್ಮಶಾನವಸ್ತ್ರೈ ರ್ಬದ್ಧಹಸ್ತಪಾದೋ ಗಾತ್ರಮಾರ್ಜನವಾಸಸಾ ಬದ್ಧಮುಖಶ್ಚ ಬಹಿರಾಗಚ್ಛತ್| ಯೀಶುರುದಿತವಾನ್ ಬನ್ಧನಾನಿ ಮೋಚಯಿತ್ವಾ ತ್ಯಜತೈನಂ| ");
INSERT INTO sankan_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","ಮರಿಯಮಃ ಸಮೀಪಮ್ ಆಗತಾ ಯೇ ಯಿಹೂದೀಯಲೋಕಾಸ್ತದಾ ಯೀಶೋರೇತತ್ ಕರ್ಮ್ಮಾಪಶ್ಯನ್ ತೇಷಾಂ ಬಹವೋ ವ್ಯಶ್ವಸನ್, ");
INSERT INTO sankan_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","ಕಿನ್ತು ಕೇಚಿದನ್ಯೇ ಫಿರೂಶಿನಾಂ ಸಮೀಪಂ ಗತ್ವಾ ಯೀಶೋರೇತಸ್ಯ ಕರ್ಮ್ಮಣೋ ವಾರ್ತ್ತಾಮ್ ಅವದನ್| ");
INSERT INTO sankan_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","ತತಃ ಪರಂ ಪ್ರಧಾನಯಾಜಕಾಃ ಫಿರೂಶಿನಾಶ್ಚ ಸಭಾಂ ಕೃತ್ವಾ ವ್ಯಾಹರನ್ ವಯಂ ಕಿಂ ಕುರ್ಮ್ಮಃ? ಏಷ ಮಾನವೋ ಬಹೂನ್ಯಾಶ್ಚರ್ಯ್ಯಕರ್ಮ್ಮಾಣಿ ಕರೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","ಯದೀದೃಶಂ ಕರ್ಮ್ಮ ಕರ್ತ್ತುಂ ನ ವಾರಯಾಮಸ್ತರ್ಹಿ ಸರ್ವ್ವೇ ಲೋಕಾಸ್ತಸ್ಮಿನ್ ವಿಶ್ವಸಿಷ್ಯನ್ತಿ ರೋಮಿಲೋಕಾಶ್ಚಾಗತ್ಯಾಸ್ಮಾಕಮ್ ಅನಯಾ ರಾಜಧಾನ್ಯಾ ಸಾರ್ದ್ಧಂ ರಾಜ್ಯಮ್ ಆಛೇತ್ಸ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","ತದಾ ತೇಷಾಂ ಕಿಯಫಾನಾಮಾ ಯಸ್ತಸ್ಮಿನ್ ವತ್ಸರೇ ಮಹಾಯಾಜಕಪದೇ ನ್ಯಯುಜ್ಯತ ಸ ಪ್ರತ್ಯವದದ್ ಯೂಯಂ ಕಿಮಪಿ ನ ಜಾನೀಥ; ");
INSERT INTO sankan_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ಸಮಗ್ರದೇಶಸ್ಯ ವಿನಾಶತೋಪಿ ಸರ್ವ್ವಲೋಕಾರ್ಥಮ್ ಏಕಸ್ಯ ಜನಸ್ಯ ಮರಣಮ್ ಅಸ್ಮಾಕಂ ಮಙ್ಗಲಹೇತುಕಮ್ ಏತಸ್ಯ ವಿವೇಚನಾಮಪಿ ನ ಕುರುಥ| ");
INSERT INTO sankan_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","ಏತಾಂ ಕಥಾಂ ಸ ನಿಜಬುದ್ಧ್ಯಾ ವ್ಯಾಹರದ್ ಇತಿ ನ, ");
INSERT INTO sankan_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ಕಿನ್ತು ಯೀಶೂಸ್ತದ್ದೇಶೀಯಾನಾಂ ಕಾರಣಾತ್ ಪ್ರಾಣಾನ್ ತ್ಯಕ್ಷ್ಯತಿ, ದಿಶಿ ದಿಶಿ ವಿಕೀರ್ಣಾನ್ ಈಶ್ವರಸ್ಯ ಸನ್ತಾನಾನ್ ಸಂಗೃಹ್ಯೈಕಜಾತಿಂ ಕರಿಷ್ಯತಿ ಚ, ತಸ್ಮಿನ್ ವತ್ಸರೇ ಕಿಯಫಾ ಮಹಾಯಾಜಕತ್ವಪದೇ ನಿಯುಕ್ತಃ ಸನ್ ಇದಂ ಭವಿಷ್ಯದ್ವಾಕ್ಯಂ ಕಥಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","ತದ್ದಿನಮಾರಭ್ಯ ತೇ ಕಥಂ ತಂ ಹನ್ತುಂ ಶಕ್ನುವನ್ತೀತಿ ಮನ್ತ್ರಣಾಂ ಕರ್ತ್ತುಂ ಪ್ರಾರೇಭಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ಅತಏವ ಯಿಹೂದೀಯಾನಾಂ ಮಧ್ಯೇ ಯೀಶುಃ ಸಪ್ರಕಾಶಂ ಗಮನಾಗಮನೇ ಅಕೃತ್ವಾ ತಸ್ಮಾದ್ ಗತ್ವಾ ಪ್ರಾನ್ತರಸ್ಯ ಸಮೀಪಸ್ಥಾಯಿಪ್ರದೇಶಸ್ಯೇಫ್ರಾಯಿಮ್ ನಾಮ್ನಿ ನಗರೇ ಶಿಷ್ಯೈಃ ಸಾಕಂ ಕಾಲಂ ಯಾಪಯಿತುಂ ಪ್ರಾರೇಭೇ| ");
INSERT INTO sankan_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","ಅನನ್ತರಂ ಯಿಹೂದೀಯಾನಾಂ ನಿಸ್ತಾರೋತ್ಸವೇ ನಿಕಟವರ್ತ್ತಿನಿ ಸತಿ ತದುತ್ಸವಾತ್ ಪೂರ್ವ್ವಂ ಸ್ವಾನ್ ಶುಚೀನ್ ಕರ್ತ್ತುಂ ಬಹವೋ ಜನಾ ಗ್ರಾಮೇಭ್ಯೋ ಯಿರೂಶಾಲಮ್ ನಗರಮ್ ಆಗಚ್ಛನ್, ");
INSERT INTO sankan_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ಯೀಶೋರನ್ವೇಷಣಂ ಕೃತ್ವಾ ಮನ್ದಿರೇ ದಣ್ಡಾಯಮಾನಾಃ ಸನ್ತಃ ಪರಸ್ಪರಂ ವ್ಯಾಹರನ್, ಯುಷ್ಮಾಕಂ ಕೀದೃಶೋ ಬೋಧೋ ಜಾಯತೇ? ಸ ಕಿಮ್ ಉತ್ಸವೇಽಸ್ಮಿನ್ ಅತ್ರಾಗಮಿಷ್ಯತಿ? ");
INSERT INTO sankan_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","ಸ ಚ ಕುತ್ರಾಸ್ತಿ ಯದ್ಯೇತತ್ ಕಶ್ಚಿದ್ ವೇತ್ತಿ ತರ್ಹಿ ದರ್ಶಯತು ಪ್ರಧಾನಯಾಜಕಾಃ ಫಿರೂಶಿನಶ್ಚ ತಂ ಧರ್ತ್ತುಂ ಪೂರ್ವ್ವಮ್ ಇಮಾಮ್ ಆಜ್ಞಾಂ ಪ್ರಾಚಾರಯನ್| ");
INSERT INTO sankan_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","ನಿಸ್ತಾರೋತ್ಸವಾತ್ ಪೂರ್ವ್ವಂ ದಿನಷಟ್ಕೇ ಸ್ಥಿತೇ ಯೀಶು ರ್ಯಂ ಪ್ರಮೀತಮ್ ಇಲಿಯಾಸರಂ ಶ್ಮಶಾನಾದ್ ಉದಸ್ಥಾಪರತ್ ತಸ್ಯ ನಿವಾಸಸ್ಥಾನಂ ಬೈಥನಿಯಾಗ್ರಾಮಮ್ ಆಗಚ್ಛತ್| ");
INSERT INTO sankan_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","ತತ್ರ ತದರ್ಥಂ ರಜನ್ಯಾಂ ಭೋಜ್ಯೇ ಕೃತೇ ಮರ್ಥಾ ಪರ್ಯ್ಯವೇಷಯದ್ ಇಲಿಯಾಸರ್ ಚ ತಸ್ಯ ಸಙ್ಗಿಭಿಃ ಸಾರ್ದ್ಧಂ ಭೋಜನಾಸನ ಉಪಾವಿಶತ್| ");
INSERT INTO sankan_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","ತದಾ ಮರಿಯಮ್ ಅರ್ದ್ಧಸೇಟಕಂ ಬಹುಮೂಲ್ಯಂ ಜಟಾಮಾಂಸೀಯಂ ತೈಲಮ್ ಆನೀಯ ಯೀಶೋಶ್ಚರಣಯೋ ರ್ಮರ್ದ್ದಯಿತ್ವಾ ನಿಜಕೇಶ ರ್ಮಾರ್ಷ್ಟುಮ್ ಆರಭತ; ತದಾ ತೈಲಸ್ಯ ಪರಿಮಲೇನ ಗೃಹಮ್ ಆಮೋದಿತಮ್ ಅಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ಯಃ ಶಿಮೋನಃ ಪುತ್ರ ರಿಷ್ಕರಿಯೋತೀಯೋ ಯಿಹೂದಾನಾಮಾ ಯೀಶುಂ ಪರಕರೇಷು ಸಮರ್ಪಯಿಷ್ಯತಿ ಸ ಶಿಷ್ಯಸ್ತದಾ ಕಥಿತವಾನ್, ");
INSERT INTO sankan_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","ಏತತ್ತೈಲಂ ತ್ರಿಭಿಃ ಶತೈ ರ್ಮುದ್ರಾಪದೈ ರ್ವಿಕ್ರೀತಂ ಸದ್ ದರಿದ್ರೇಭ್ಯಃ ಕುತೋ ನಾದೀಯತ? ");
INSERT INTO sankan_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ಸ ದರಿದ್ರಲೋಕಾರ್ಥಮ್ ಅಚಿನ್ತಯದ್ ಇತಿ ನ, ಕಿನ್ತು ಸ ಚೌರ ಏವಂ ತನ್ನಿಕಟೇ ಮುದ್ರಾಸಮ್ಪುಟಕಸ್ಥಿತ್ಯಾ ತನ್ಮಧ್ಯೇ ಯದತಿಷ್ಠತ್ ತದಪಾಹರತ್ ತಸ್ಮಾತ್ ಕಾರಣಾದ್ ಇಮಾಂ ಕಥಾಮಕಥಯತ್| ");
INSERT INTO sankan_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","ತದಾ ಯೀಶುರಕಥಯದ್ ಏನಾಂ ಮಾ ವಾರಯ ಸಾ ಮಮ ಶ್ಮಶಾನಸ್ಥಾಪನದಿನಾರ್ಥಂ ತದರಕ್ಷಯತ್| ");
INSERT INTO sankan_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","ದರಿದ್ರಾ ಯುಷ್ಮಾಕಂ ಸನ್ನಿಧೌ ಸರ್ವ್ವದಾ ತಿಷ್ಠನ್ತಿ ಕಿನ್ತ್ವಹಂ ಸರ್ವ್ವದಾ ಯುಷ್ಮಾಕಂ ಸನ್ನಿಧೌ ನ ತಿಷ್ಠಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","ತತಃ ಪರಂ ಯೀಶುಸ್ತತ್ರಾಸ್ತೀತಿ ವಾರ್ತ್ತಾಂ ಶ್ರುತ್ವಾ ಬಹವೋ ಯಿಹೂದೀಯಾಸ್ತಂ ಶ್ಮಶಾನಾದುತ್ಥಾಪಿತಮ್ ಇಲಿಯಾಸರಞ್ಚ ದ್ರಷ್ಟುಂ ತತ್ ಸ್ಥಾನಮ್ ಆಗಚ್ಛನ| ");
INSERT INTO sankan_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","ತದಾ ಪ್ರಧಾನಯಾಜಕಾಸ್ತಮ್ ಇಲಿಯಾಸರಮಪಿ ಸಂಹರ್ತ್ತುಮ್ ಅಮನ್ತ್ರಯನ್ ; ");
INSERT INTO sankan_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ಯತಸ್ತೇನ ಬಹವೋ ಯಿಹೂದೀಯಾ ಗತ್ವಾ ಯೀಶೌ ವ್ಯಶ್ವಸನ್| ");
INSERT INTO sankan_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","ಅನನ್ತರಂ ಯೀಶು ರ್ಯಿರೂಶಾಲಮ್ ನಗರಮ್ ಆಗಚ್ಛತೀತಿ ವಾರ್ತ್ತಾಂ ಶ್ರುತ್ವಾ ಪರೇಽಹನಿ ಉತ್ಸವಾಗತಾ ಬಹವೋ ಲೋಕಾಃ ");
INSERT INTO sankan_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ಖರ್ಜ್ಜೂರಪತ್ರಾದ್ಯಾನೀಯ ತಂ ಸಾಕ್ಷಾತ್ ಕರ್ತ್ತುಂ ಬಹಿರಾಗತ್ಯ ಜಯ ಜಯೇತಿ ವಾಚಂ ಪ್ರೋಚ್ಚೈ ರ್ವಕ್ತುಮ್ ಆರಭನ್ತ, ಇಸ್ರಾಯೇಲೋ ಯೋ ರಾಜಾ ಪರಮೇಶ್ವರಸ್ಯ ನಾಮ್ನಾಗಚ್ಛತಿ ಸ ಧನ್ಯಃ| ");
INSERT INTO sankan_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","ತದಾ \"ಹೇ ಸಿಯೋನಃ ಕನ್ಯೇ ಮಾ ಭೈಷೀಃ ಪಶ್ಯಾಯಂ ತವ ರಾಜಾ ಗರ್ದ್ದಭಶಾವಕಮ್ ಆರುಹ್ಯಾಗಚ್ಛತಿ\" ");
INSERT INTO sankan_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","ಇತಿ ಶಾಸ್ತ್ರೀಯವಚನಾನುಸಾರೇಣ ಯೀಶುರೇಕಂ ಯುವಗರ್ದ್ದಭಂ ಪ್ರಾಪ್ಯ ತದುಪರ್ಯ್ಯಾರೋಹತ್| ");
INSERT INTO sankan_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","ಅಸ್ಯಾಃ ಘಟನಾಯಾಸ್ತಾತ್ಪರ್ಯ್ಯಂ ಶಿಷ್ಯಾಃ ಪ್ರಥಮಂ ನಾಬುಧ್ಯನ್ತ, ಕಿನ್ತು ಯೀಶೌ ಮಹಿಮಾನಂ ಪ್ರಾಪ್ತೇ ಸತಿ ವಾಕ್ಯಮಿದಂ ತಸ್ಮಿನ ಅಕಥ್ಯತ ಲೋಕಾಶ್ಚ ತಮ್ಪ್ರತೀತ್ಥಮ್ ಅಕುರ್ವ್ವನ್ ಇತಿ ತೇ ಸ್ಮೃತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","ಸ ಇಲಿಯಾಸರಂ ಶ್ಮಶಾನಾದ್ ಆಗನ್ತುಮ್ ಆಹ್ವತವಾನ್ ಶ್ಮಶಾನಾಞ್ಚ ಉದಸ್ಥಾಪಯದ್ ಯೇ ಯೇ ಲೋಕಾಸ್ತತ್ಕರ್ಮ್ಯ ಸಾಕ್ಷಾದ್ ಅಪಶ್ಯನ್ ತೇ ಪ್ರಮಾಣಂ ದಾತುಮ್ ಆರಭನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ಸ ಏತಾದೃಶಮ್ ಅದ್ಭುತಂ ಕರ್ಮ್ಮಕರೋತ್ ತಸ್ಯ ಜನಶ್ರುತೇ ರ್ಲೋಕಾಸ್ತಂ ಸಾಕ್ಷಾತ್ ಕರ್ತ್ತುಮ್ ಆಗಚ್ಛನ್| ");
INSERT INTO sankan_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ತತಃ ಫಿರೂಶಿನಃ ಪರಸ್ಪರಂ ವಕ್ತುಮ್ ಆರಭನ್ತ ಯುಷ್ಮಾಕಂ ಸರ್ವ್ವಾಶ್ಚೇಷ್ಟಾ ವೃಥಾ ಜಾತಾಃ, ಇತಿ ಕಿಂ ಯೂಯಂ ನ ಬುಧ್ಯಧ್ವೇ? ಪಶ್ಯತ ಸರ್ವ್ವೇ ಲೋಕಾಸ್ತಸ್ಯ ಪಶ್ಚಾದ್ವರ್ತ್ತಿನೋಭವನ್| ");
INSERT INTO sankan_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ಭಜನಂ ಕರ್ತ್ತುಮ್ ಉತ್ಸವಾಗತಾನಾಂ ಲೋಕಾನಾಂ ಕತಿಪಯಾ ಜನಾ ಅನ್ಯದೇಶೀಯಾ ಆಸನ್ , ");
INSERT INTO sankan_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ತೇ ಗಾಲೀಲೀಯಬೈತ್ಸೈದಾನಿವಾಸಿನಃ ಫಿಲಿಪಸ್ಯ ಸಮೀಪಮ್ ಆಗತ್ಯ ವ್ಯಾಹರನ್ ಹೇ ಮಹೇಚ್ಛ ವಯಂ ಯೀಶುಂ ದ್ರಷ್ಟುಮ್ ಇಚ್ಛಾಮಃ| ");
INSERT INTO sankan_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ತತಃ ಫಿಲಿಪೋ ಗತ್ವಾ ಆನ್ದ್ರಿಯಮ್ ಅವದತ್ ಪಶ್ಚಾದ್ ಆನ್ದ್ರಿಯಫಿಲಿಪೌ ಯೀಶವೇ ವಾರ್ತ್ತಾಮ್ ಅಕಥಯತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","ತದಾ ಯೀಶುಃ ಪ್ರತ್ಯುದಿತವಾನ್ ಮಾನವಸುತಸ್ಯ ಮಹಿಮಪ್ರಾಪ್ತಿಸಮಯ ಉಪಸ್ಥಿತಃ| ");
INSERT INTO sankan_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ಅಹಂ ಯುಷ್ಮಾನತಿಯಥಾರ್ಥಂ ವದಾಮಿ, ಧಾನ್ಯಬೀಜಂ ಮೃತ್ತಿಕಾಯಾಂ ಪತಿತ್ವಾ ಯದಿ ನ ಮೃಯತೇ ತರ್ಹ್ಯೇಕಾಕೀ ತಿಷ್ಠತಿ ಕಿನ್ತು ಯದಿ ಮೃಯತೇ ತರ್ಹಿ ಬಹುಗುಣಂ ಫಲಂ ಫಲತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ಯೋ ಜನೇा ನಿಜಪ್ರಾಣಾನ್ ಪ್ರಿಯಾನ್ ಜಾನಾತಿ ಸ ತಾನ್ ಹಾರಯಿಷ್ಯತಿ ಕಿನ್ತು ಯೇा ಜನ ಇಹಲೋಕೇ ನಿಜಪ್ರಾಣಾನ್ ಅಪ್ರಿಯಾನ್ ಜಾನಾತಿ ಸೇाನನ್ತಾಯುಃ ಪ್ರಾಪ್ತುಂ ತಾನ್ ರಕ್ಷಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","ಕಶ್ಚಿದ್ ಯದಿ ಮಮ ಸೇವಕೋ ಭವಿತುಂ ವಾಞ್ಛತಿ ತರ್ಹಿ ಸ ಮಮ ಪಶ್ಚಾದ್ಗಾಮೀ ಭವತು, ತಸ್ಮಾದ್ ಅಹಂ ಯತ್ರ ತಿಷ್ಠಾಮಿ ಮಮ ಸೇವಕೇाಪಿ ತತ್ರ ಸ್ಥಾಸ್ಯತಿ; ಯೋ ಜನೋ ಮಾಂ ಸೇವತೇ ಮಮ ಪಿತಾಪಿ ತಂ ಸಮ್ಮಂಸ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","ಸಾಮ್ಪ್ರತಂ ಮಮ ಪ್ರಾಣಾ ವ್ಯಾಕುಲಾ ಭವನ್ತಿ, ತಸ್ಮಾದ್ ಹೇ ಪಿತರ ಏತಸ್ಮಾತ್ ಸಮಯಾನ್ ಮಾಂ ರಕ್ಷ, ಇತ್ಯಹಂ ಕಿಂ ಪ್ರಾರ್ಥಯಿಷ್ಯೇ? ಕಿನ್ತ್ವಹಮ್ ಏತತ್ಸಮಯಾರ್ಥಮ್ ಅವತೀರ್ಣವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ಹೇ ಪಿತ: ಸ್ವನಾಮ್ನೋ ಮಹಿಮಾನಂ ಪ್ರಕಾಶಯ; ತನೈವ ಸ್ವನಾಮ್ನೋ ಮಹಿಮಾನಮ್ ಅಹಂ ಪ್ರಾಕಾಶಯಂ ಪುನರಪಿ ಪ್ರಕಾಶಯಿಷ್ಯಾಮಿ, ಏಷಾ ಗಗಣೀಯಾ ವಾಣೀ ತಸ್ಮಿನ್ ಸಮಯೇಽಜಾಯತ| ");
INSERT INTO sankan_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","ತಚ್ಶ್ರುತ್ವಾ ಸಮೀಪಸ್ಥಲೋಕಾನಾಂ ಕೇಚಿದ್ ಅವದನ್ ಮೇಘೋಽಗರ್ಜೀತ್, ಕೇಚಿದ್ ಅವದನ್ ಸ್ವರ್ಗೀಯದೂತೋಽನೇನ ಸಹ ಕಥಾಮಚಕಥತ್| ");
INSERT INTO sankan_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","ತದಾ ಯೀಶುಃ ಪ್ರತ್ಯವಾದೀತ್, ಮದರ್ಥಂ ಶಬ್ದೋಯಂ ನಾಭೂತ್ ಯುಷ್ಮದರ್ಥಮೇವಾಭೂತ್| ");
INSERT INTO sankan_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","ಅಧುನಾ ಜಗತೋಸ್ಯ ವಿಚಾರ: ಸಮ್ಪತ್ಸ್ಯತೇ, ಅಧುನಾಸ್ಯ ಜಗತ: ಪತೀ ರಾಜ್ಯಾತ್ ಚ್ಯೋಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","ಯದ್ಯಈ ಪೃಥಿವ್ಯಾ ಊರ್ದ್ವ್ವೇ ಪ್ರೋತ್ಥಾಪಿತೋಸ್ಮಿ ತರ್ಹಿ ಸರ್ವ್ವಾನ್ ಮಾನವಾನ್ ಸ್ವಸಮೀಪಮ್ ಆಕರ್ಷಿಷ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","ಕಥಂ ತಸ್ಯ ಮೃತಿ ರ್ಭವಿಷ್ಯತಿ, ಏತದ್ ಬೋಧಯಿತುಂ ಸ ಇಮಾಂ ಕಥಾಮ್ ಅಕಥಯತ್| ");
INSERT INTO sankan_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","ತದಾ ಲೋಕಾ ಅಕಥಯನ್ ಸೋಭಿಷಿಕ್ತಃ ಸರ್ವ್ವದಾ ತಿಷ್ಠತೀತಿ ವ್ಯವಸ್ಥಾಗ್ರನ್ಥೇ ಶ್ರುತಮ್ ಅಸ್ಮಾಭಿಃ, ತರ್ಹಿ ಮನುಷ್ಯಪುತ್ರಃ ಪ್ರೋತ್ಥಾಪಿತೋ ಭವಿಷ್ಯತೀತಿ ವಾಕ್ಯಂ ಕಥಂ ವದಸಿ? ಮನುಷ್ಯಪುತ್ರೋಯಂ ಕಃ? ");
INSERT INTO sankan_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","ತದಾ ಯೀಶುರಕಥಾಯದ್ ಯುಷ್ಮಾಭಿಃ ಸಾರ್ದ್ಧಮ್ ಅಲ್ಪದಿನಾನಿ ಜ್ಯೋತಿರಾಸ್ತೇ, ಯಥಾ ಯುಷ್ಮಾನ್ ಅನ್ಧಕಾರೋ ನಾಚ್ಛಾದಯತಿ ತದರ್ಥಂ ಯಾವತ್ಕಾಲಂ ಯುಷ್ಮಾಭಿಃ ಸಾರ್ದ್ಧಂ ಜ್ಯೋತಿಸ್ತಿಷ್ಠತಿ ತಾವತ್ಕಾಲಂ ಗಚ್ಛತ; ಯೋ ಜನೋಽನ್ಧಕಾರೇ ಗಚ್ಛತಿ ಸ ಕುತ್ರ ಯಾತೀತಿ ನ ಜಾನಾತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ಅತಏವ ಯಾವತ್ಕಾಲಂ ಯುಷ್ಮಾಕಂ ನಿಕಟೇ ಜ್ಯೋತಿರಾಸ್ತೇ ತಾವತ್ಕಾಲಂ ಜ್ಯೋತೀರೂಪಸನ್ತಾನಾ ಭವಿತುಂ ಜ್ಯೋತಿಷಿ ವಿಶ್ವಸಿತ; ಇಮಾಂ ಕಥಾಂ ಕಥಯಿತ್ವಾ ಯೀಶುಃ ಪ್ರಸ್ಥಾಯ ತೇಭ್ಯಃ ಸ್ವಂ ಗುಪ್ತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","ಯದ್ಯಪಿ ಯೀಶುಸ್ತೇಷಾಂ ಸಮಕ್ಷಮ್ ಏತಾವದಾಶ್ಚರ್ಯ್ಯಕರ್ಮ್ಮಾಣಿ ಕೃತವಾನ್ ತಥಾಪಿ ತೇ ತಸ್ಮಿನ್ ನ ವ್ಯಶ್ವಸನ್| ");
INSERT INTO sankan_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ಅತಏವ ಕಃ ಪ್ರತ್ಯೇತಿ ಸುಸಂವಾದಂ ಪರೇಶಾಸ್ಮತ್ ಪ್ರಚಾರಿತಂ? ಪ್ರಕಾಶತೇ ಪರೇಶಸ್ಯ ಹಸ್ತಃ ಕಸ್ಯ ಚ ಸನ್ನಿಧೌ? ಯಿಶಯಿಯಭವಿಷ್ಯದ್ವಾದಿನಾ ಯದೇತದ್ ವಾಕ್ಯಮುಕ್ತಂ ತತ್ ಸಫಲಮ್ ಅಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","ತೇ ಪ್ರತ್ಯೇತುಂ ನಾಶನ್ಕುವನ್ ತಸ್ಮಿನ್ ಯಿಶಯಿಯಭವಿಷ್ಯದ್ವಾದಿ ಪುನರವಾದೀದ್, ");
INSERT INTO sankan_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","ಯದಾ, \"ತೇ ನಯನೈ ರ್ನ ಪಶ್ಯನ್ತಿ ಬುದ್ಧಿಭಿಶ್ಚ ನ ಬುಧ್ಯನ್ತೇ ತೈ ರ್ಮನಃಸು ಪರಿವರ್ತ್ತಿತೇಷು ಚ ತಾನಹಂ ಯಥಾ ಸ್ವಸ್ಥಾನ್ ನ ಕರೋಮಿ ತಥಾ ಸ ತೇಷಾಂ ಲೋಚನಾನ್ಯನ್ಧಾನಿ ಕೃತ್ವಾ ತೇಷಾಮನ್ತಃಕರಣಾನಿ ಗಾಢಾನಿ ಕರಿಷ್ಯತಿ| \" ");
INSERT INTO sankan_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","ಯಿಶಯಿಯೋ ಯದಾ ಯೀಶೋ ರ್ಮಹಿಮಾನಂ ವಿಲೋಕ್ಯ ತಸ್ಮಿನ್ ಕಥಾಮಕಥಯತ್ ತದಾ ಭವಿಷ್ಯದ್ವಾಕ್ಯಮ್ ಈದೃಶಂ ಪ್ರಕಾಶಯತ್| ");
INSERT INTO sankan_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ತಥಾಪ್ಯಧಿಪತಿನಾಂ ಬಹವಸ್ತಸ್ಮಿನ್ ಪ್ರತ್ಯಾಯನ್| ಕಿನ್ತು ಫಿರೂಶಿನಸ್ತಾನ್ ಭಜನಗೃಹಾದ್ ದೂರೀಕುರ್ವ್ವನ್ತೀತಿ ಭಯಾತ್ ತೇ ತಂ ನ ಸ್ವೀಕೃತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ಯತ ಈಶ್ವರಸ್ಯ ಪ್ರಶಂಸಾತೋ ಮಾನವಾನಾಂ ಪ್ರಶಂಸಾಯಾಂ ತೇಽಪ್ರಿಯನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","ತದಾ ಯೀಶುರುಚ್ಚೈಃಕಾರಮ್ ಅಕಥಯದ್ ಯೋ ಜನೋ ಮಯಿ ವಿಶ್ವಸಿತಿ ಸ ಕೇವಲೇ ಮಯಿ ವಿಶ್ವಸಿತೀತಿ ನ, ಸ ಮತ್ಪ್ರೇರಕೇಽಪಿ ವಿಶ್ವಸಿತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ಯೋ ಜನೋ ಮಾಂ ಪಶ್ಯತಿ ಸ ಮತ್ಪ್ರೇರಕಮಪಿ ಪಶ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","ಯೋ ಜನೋ ಮಾಂ ಪ್ರತ್ಯೇತಿ ಸ ಯಥಾನ್ಧಕಾರೇ ನ ತಿಷ್ಠತಿ ತದರ್ಥಮ್ ಅಹಂ ಜ್ಯೋತಿಃಸ್ವರೂಪೋ ಭೂತ್ವಾ ಜಗತ್ಯಸ್ಮಿನ್ ಅವತೀರ್ಣವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","ಮಮ ಕಥಾಂ ಶ್ರುತ್ವಾ ಯದಿ ಕಶ್ಚಿನ್ ನ ವಿಶ್ವಸಿತಿ ತರ್ಹಿ ತಮಹಂ ದೋಷಿಣಂ ನ ಕರೋಮಿ, ಯತೋ ಹೇತೋ ರ್ಜಗತೋ ಜನಾನಾಂ ದೋಷಾನ್ ನಿಶ್ಚಿತಾನ್ ಕರ್ತ್ತುಂ ನಾಗತ್ಯ ತಾನ್ ಪರಿಚಾತುಮ್ ಆಗತೋಸ್ಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ಯಃ ಕಶ್ಚಿನ್ ಮಾಂ ನ ಶ್ರದ್ಧಾಯ ಮಮ ಕಥಂ ನ ಗೃಹ್ಲಾತಿ, ಅನ್ಯಸ್ತಂ ದೋಷಿಣಂ ಕರಿಷ್ಯತಿ ವಸ್ತುತಸ್ತು ಯಾಂ ಕಥಾಮಹಮ್ ಅಚಕಥಂ ಸಾ ಕಥಾ ಚರಮೇಽನ್ಹಿ ತಂ ದೋಷಿಣಂ ಕರಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","ಯತೋ ಹೇತೋರಹಂ ಸ್ವತಃ ಕಿಮಪಿ ನ ಕಥಯಾಮಿ, ಕಿಂ ಕಿಂ ಮಯಾ ಕಥಯಿತವ್ಯಂ ಕಿಂ ಸಮುಪದೇಷ್ಟವ್ಯಞ್ಚ ಇತಿ ಮತ್ಪ್ರೇರಯಿತಾ ಪಿತಾ ಮಾಮಾಜ್ಞಾಪಯತ್| ");
INSERT INTO sankan_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ತಸ್ಯ ಸಾಜ್ಞಾ ಅನನ್ತಾಯುರಿತ್ಯಹಂ ಜಾನಾಮಿ, ಅತಏವಾಹಂ ಯತ್ ಕಥಯಾಮಿ ತತ್ ಪಿತಾ ಯಥಾಜ್ಞಾಪಯತ್ ತಥೈವ ಕಥಯಾಮ್ಯಹಮ್| ");
INSERT INTO sankan_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","ನಿಸ್ತಾರೋತ್ಸವಸ್ಯ ಕಿಞ್ಚಿತ್ಕಾಲಾತ್ ಪೂರ್ವ್ವಂ ಪೃಥಿವ್ಯಾಃ ಪಿತುಃ ಸಮೀಪಗಮನಸ್ಯ ಸಮಯಃ ಸನ್ನಿಕರ್ಷೋಭೂದ್ ಇತಿ ಜ್ಞಾತ್ವಾ ಯೀಶುರಾಪ್ರಥಮಾದ್ ಯೇಷು ಜಗತ್ಪ್ರವಾಸಿಷ್ವಾತ್ಮೀಯಲೋಕೇಷ ಪ್ರೇಮ ಕರೋತಿ ಸ್ಮ ತೇಷು ಶೇಷಂ ಯಾವತ್ ಪ್ರೇಮ ಕೃತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","ಪಿತಾ ತಸ್ಯ ಹಸ್ತೇ ಸರ್ವ್ವಂ ಸಮರ್ಪಿತವಾನ್ ಸ್ವಯಮ್ ಈಶ್ವರಸ್ಯ ಸಮೀಪಾದ್ ಆಗಚ್ಛದ್ ಈಶ್ವರಸ್ಯ ಸಮೀಪಂ ಯಾಸ್ಯತಿ ಚ, ಸರ್ವ್ವಾಣ್ಯೇತಾನಿ ಜ್ಞಾತ್ವಾ ರಜನ್ಯಾಂ ಭೋಜನೇ ಸಮ್ಪೂರ್ಣೇ ಸತಿ, ");
INSERT INTO sankan_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ಯದಾ ಶೈತಾನ್ ತಂ ಪರಹಸ್ತೇಷು ಸಮರ್ಪಯಿತುಂ ಶಿಮೋನಃ ಪುತ್ರಸ್ಯ ಈಷ್ಕಾರಿಯೋತಿಯಸ್ಯ ಯಿಹೂದಾ ಅನ್ತಃಕರಣೇ ಕುಪ್ರವೃತ್ತಿಂ ಸಮಾರ್ಪಯತ್, ");
INSERT INTO sankan_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ತದಾ ಯೀಶು ರ್ಭೋಜನಾಸನಾದ್ ಉತ್ಥಾಯ ಗಾತ್ರವಸ್ತ್ರಂ ಮೋಚಯಿತ್ವಾ ಗಾತ್ರಮಾರ್ಜನವಸ್ತ್ರಂ ಗೃಹೀತ್ವಾ ತೇನ ಸ್ವಕಟಿಮ್ ಅಬಧ್ನಾತ್, ");
INSERT INTO sankan_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ಪಶ್ಚಾದ್ ಏಕಪಾತ್ರೇ ಜಲಮ್ ಅಭಿಷಿಚ್ಯ ಶಿಷ್ಯಾಣಾಂ ಪಾದಾನ್ ಪ್ರಕ್ಷಾಲ್ಯ ತೇನ ಕಟಿಬದ್ಧಗಾತ್ರಮಾರ್ಜನವಾಸಸಾ ಮಾರ್ಷ್ಟುಂ ಪ್ರಾರಭತ| ");
INSERT INTO sankan_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ತತಃ ಶಿಮೋನ್ಪಿತರಸ್ಯ ಸಮೀಪಮಾಗತೇ ಸ ಉಕ್ತವಾನ್ ಹೇ ಪ್ರಭೋ ಭವಾನ್ ಕಿಂ ಮಮ ಪಾದೌ ಪ್ರಕ್ಷಾಲಯಿಷ್ಯತಿ? ");
INSERT INTO sankan_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ಯೀಶುರುದಿತವಾನ್ ಅಹಂ ಯತ್ ಕರೋಮಿ ತತ್ ಸಮ್ಪ್ರತಿ ನ ಜಾನಾಸಿ ಕಿನ್ತು ಪಶ್ಚಾಜ್ ಜ್ಞಾಸ್ಯಸಿ| ");
INSERT INTO sankan_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","ತತಃ ಪಿತರಃ ಕಥಿತವಾನ್ ಭವಾನ್ ಕದಾಪಿ ಮಮ ಪಾದೌ ನ ಪ್ರಕ್ಷಾಲಯಿಷ್ಯತಿ| ಯೀಶುರಕಥಯದ್ ಯದಿ ತ್ವಾಂ ನ ಪ್ರಕ್ಷಾಲಯೇ ತರ್ಹಿ ಮಯಿ ತವ ಕೋಪ್ಯಂಶೋ ನಾಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ತದಾ ಶಿಮೋನ್ಪಿತರಃ ಕಥಿತವಾನ್ ಹೇ ಪ್ರಭೋ ತರ್ಹಿ ಕೇವಲಪಾದೌ ನ, ಮಮ ಹಸ್ತೌ ಶಿರಶ್ಚ ಪ್ರಕ್ಷಾಲಯತು| ");
INSERT INTO sankan_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ತತೋ ಯೀಶುರವದದ್ ಯೋ ಜನೋ ಧೌತಸ್ತಸ್ಯ ಸರ್ವ್ವಾಙ್ಗಪರಿಷ್ಕೃತತ್ವಾತ್ ಪಾದೌ ವಿನಾನ್ಯಾಙ್ಗಸ್ಯ ಪ್ರಕ್ಷಾಲನಾಪೇಕ್ಷಾ ನಾಸ್ತಿ| ಯೂಯಂ ಪರಿಷ್ಕೃತಾ ಇತಿ ಸತ್ಯಂ ಕಿನ್ತು ನ ಸರ್ವ್ವೇ, ");
INSERT INTO sankan_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","ಯತೋ ಯೋ ಜನಸ್ತಂ ಪರಕರೇಷು ಸಮರ್ಪಯಿಷ್ಯತಿ ತಂ ಸ ಜ್ಞಾತವಾನ; ಅತಏವ ಯೂಯಂ ಸರ್ವ್ವೇ ನ ಪರಿಷ್ಕೃತಾ ಇಮಾಂ ಕಥಾಂ ಕಥಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ಇತ್ಥಂ ಯೀಶುಸ್ತೇಷಾಂ ಪಾದಾನ್ ಪ್ರಕ್ಷಾಲ್ಯ ವಸ್ತ್ರಂ ಪರಿಧಾಯಾಸನೇ ಸಮುಪವಿಶ್ಯ ಕಥಿತವಾನ್ ಅಹಂ ಯುಷ್ಮಾನ್ ಪ್ರತಿ ಕಿಂ ಕರ್ಮ್ಮಾಕಾರ್ಷಂ ಜಾನೀಥ? ");
INSERT INTO sankan_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","ಯೂಯಂ ಮಾಂ ಗುರುಂ ಪ್ರಭುಞ್ಚ ವದಥ ತತ್ ಸತ್ಯಮೇವ ವದಥ ಯತೋಹಂ ಸಏವ ಭವಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ಯದ್ಯಹಂ ಪ್ರಭು ರ್ಗುರುಶ್ಚ ಸನ್ ಯುಷ್ಮಾಕಂ ಪಾದಾನ್ ಪ್ರಕ್ಷಾಲಿತವಾನ್ ತರ್ಹಿ ಯುಷ್ಮಾಕಮಪಿ ಪರಸ್ಪರಂ ಪಾದಪ್ರಕ್ಷಾಲನಮ್ ಉಚಿತಮ್| ");
INSERT INTO sankan_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","ಅಹಂ ಯುಷ್ಮಾನ್ ಪ್ರತಿ ಯಥಾ ವ್ಯವಾಹರಂ ಯುಷ್ಮಾನ್ ತಥಾ ವ್ಯವಹರ್ತ್ತುಮ್ ಏಕಂ ಪನ್ಥಾನಂ ದರ್ಶಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","ಅಹಂ ಯುಷ್ಮಾನತಿಯಥಾರ್ಥಂ ವದಾಮಿ, ಪ್ರಭೋ ರ್ದಾಸೋ ನ ಮಹಾನ್ ಪ್ರೇರಕಾಚ್ಚ ಪ್ರೇರಿತೋ ನ ಮಹಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ಇಮಾಂ ಕಥಾಂ ವಿದಿತ್ವಾ ಯದಿ ತದನುಸಾರತಃ ಕರ್ಮ್ಮಾಣಿ ಕುರುಥ ತರ್ಹಿ ಯೂಯಂ ಧನ್ಯಾ ಭವಿಷ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","ಸರ್ವ್ವೇಷು ಯುಷ್ಮಾಸು ಕಥಾಮಿಮಾಂ ಕಥಯಾಮಿ ಇತಿ ನ, ಯೇ ಮಮ ಮನೋನೀತಾಸ್ತಾನಹಂ ಜಾನಾಮಿ, ಕಿನ್ತು ಮಮ ಭಕ್ಷ್ಯಾಣಿ ಯೋ ಭುಙ್ಕ್ತೇ ಮತ್ಪ್ರಾಣಪ್ರಾತಿಕೂಲ್ಯತಃ| ಉತ್ಥಾಪಯತಿ ಪಾದಸ್ಯ ಮೂಲಂ ಸ ಏಷ ಮಾನವಃ| ಯದೇತದ್ ಧರ್ಮ್ಮಪುಸ್ತಕಸ್ಯ ವಚನಂ ತದನುಸಾರೇಣಾವಶ್ಯಂ ಘಟಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","ಅಹಂ ಸ ಜನ ಇತ್ಯತ್ರ ಯಥಾ ಯುಷ್ಮಾಕಂ ವಿಶ್ವಾಸೋ ಜಾಯತೇ ತದರ್ಥಂ ಏತಾದೃಶಘಟನಾತ್ ಪೂರ್ವ್ವಮ್ ಅಹಮಿದಾನೀಂ ಯುಷ್ಮಭ್ಯಮಕಥಯಮ್| ");
INSERT INTO sankan_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","ಅಹಂ ಯುಷ್ಮಾನತೀವ ಯಥಾರ್ಥಂ ವದಾಮಿ, ಮಯಾ ಪ್ರೇರಿತಂ ಜನಂ ಯೋ ಗೃಹ್ಲಾತಿ ಸ ಮಾಮೇವ ಗೃಹ್ಲಾತಿ ಯಶ್ಚ ಮಾಂ ಗೃಹ್ಲಾತಿ ಸ ಮತ್ಪ್ರೇರಕಂ ಗೃಹ್ಲಾತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ಏತಾಂ ಕಥಾಂ ಕಥಯಿತ್ವಾ ಯೀಶು ರ್ದುಃಖೀ ಸನ್ ಪ್ರಮಾಣಂ ದತ್ತ್ವಾ ಕಥಿತವಾನ್ ಅಹಂ ಯುಷ್ಮಾನತಿಯಥಾರ್ಥಂ ವದಾಮಿ ಯುಷ್ಮಾಕಮ್ ಏಕೋ ಜನೋ ಮಾಂ ಪರಕರೇಷು ಸಮರ್ಪಯಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ತತಃ ಸ ಕಮುದ್ದಿಶ್ಯ ಕಥಾಮೇತಾಂ ಕಥಿತವಾನ್ ಇತ್ಯತ್ರ ಸನ್ದಿಗ್ಧಾಃ ಶಿಷ್ಯಾಃ ಪರಸ್ಪರಂ ಮುಖಮಾಲೋಕಯಿತುಂ ಪ್ರಾರಭನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ತಸ್ಮಿನ್ ಸಮಯೇ ಯೀಶು ರ್ಯಸ್ಮಿನ್ ಅಪ್ರೀಯತ ಸ ಶಿಷ್ಯಸ್ತಸ್ಯ ವಕ್ಷಃಸ್ಥಲಮ್ ಅವಾಲಮ್ಬತ| ");
INSERT INTO sankan_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ಶಿಮೋನ್ಪಿತರಸ್ತಂ ಸಙ್ಕೇತೇನಾವದತ್, ಅಯಂ ಕಮುದ್ದಿಶ್ಯ ಕಥಾಮೇತಾಮ್ ಕಥಯತೀತಿ ಪೃಚ್ಛ| ");
INSERT INTO sankan_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ತದಾ ಸ ಯೀಶೋ ರ್ವಕ್ಷಃಸ್ಥಲಮ್ ಅವಲಮ್ಬ್ಯ ಪೃಷ್ಠವಾನ್, ಹೇ ಪ್ರಭೋ ಸ ಜನಃ ಕಃ? ");
INSERT INTO sankan_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ತತೋ ಯೀಶುಃ ಪ್ರತ್ಯವದದ್ ಏಕಖಣ್ಡಂ ಪೂಪಂ ಮಜ್ಜಯಿತ್ವಾ ಯಸ್ಮೈ ದಾಸ್ಯಾಮಿ ಸಏವ ಸಃ; ಪಶ್ಚಾತ್ ಪೂಪಖಣ್ಡಮೇಕಂ ಮಜ್ಜಯಿತ್ವಾ ಶಿಮೋನಃ ಪುತ್ರಾಯ ಈಷ್ಕರಿಯೋತೀಯಾಯ ಯಿಹೂದೈ ದತ್ತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","ತಸ್ಮಿನ್ ದತ್ತೇ ಸತಿ ಶೈತಾನ್ ತಮಾಶ್ರಯತ್; ತದಾ ಯೀಶುಸ್ತಮ್ ಅವದತ್ ತ್ವಂ ಯತ್ ಕರಿಷ್ಯಸಿ ತತ್ ಕ್ಷಿಪ್ರಂ ಕುರು| ");
INSERT INTO sankan_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","ಕಿನ್ತು ಸ ಯೇನಾಶಯೇನ ತಾಂ ಕಥಾಮಕಥಾಯತ್ ತಮ್ ಉಪವಿಷ್ಟಲೋಕಾನಾಂ ಕೋಪಿ ನಾಬುಧ್ಯತ; ");
INSERT INTO sankan_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ಕಿನ್ತು ಯಿಹೂದಾಃ ಸಮೀಪೇ ಮುದ್ರಾಸಮ್ಪುಟಕಸ್ಥಿತೇಃ ಕೇಚಿದ್ ಇತ್ಥಮ್ ಅಬುಧ್ಯನ್ತ ಪಾರ್ವ್ವಣಾಸಾದನಾರ್ಥಂ ಕಿಮಪಿ ದ್ರವ್ಯಂ ಕ್ರೇತುಂ ವಾ ದರಿದ್ರೇಭ್ಯಃ ಕಿಞ್ಚಿದ್ ವಿತರಿತುಂ ಕಥಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ತದಾ ಪೂಪಖಣ್ಡಗ್ರಹಣಾತ್ ಪರಂ ಸ ತೂರ್ಣಂ ಬಹಿರಗಚ್ಛತ್; ರಾತ್ರಿಶ್ಚ ಸಮುಪಸ್ಯಿತಾ| ");
INSERT INTO sankan_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","ಯಿಹೂದೇ ಬಹಿರ್ಗತೇ ಯೀಶುರಕಥಯದ್ ಇದಾನೀಂ ಮಾನವಸುತಸ್ಯ ಮಹಿಮಾ ಪ್ರಕಾಶತೇ ತೇನೇಶ್ವರಸ್ಯಾಪಿ ಮಹಿಮಾ ಪ್ರಕಾಶತೇ| ");
INSERT INTO sankan_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ಯದಿ ತೇನೇಶ್ವರಸ್ಯ ಮಹಿಮಾ ಪ್ರಕಾಶತೇ ತರ್ಹೀಶ್ವರೋಪಿ ಸ್ವೇನ ತಸ್ಯ ಮಹಿಮಾನಂ ಪ್ರಕಾಶಯಿಷ್ಯತಿ ತೂರ್ಣಮೇವ ಪ್ರಕಾಶಯಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ಹೇ ವತ್ಸಾ ಅಹಂ ಯುಷ್ಮಾಭಿಃ ಸಾರ್ದ್ಧಂ ಕಿಞ್ಚಿತ್ಕಾಲಮಾತ್ರಮ್ ಆಸೇ, ತತಃ ಪರಂ ಮಾಂ ಮೃಗಯಿಷ್ಯಧ್ವೇ ಕಿನ್ತ್ವಹಂ ಯತ್ಸ್ಥಾನಂ ಯಾಮಿ ತತ್ಸ್ಥಾನಂ ಯೂಯಂ ಗನ್ತುಂ ನ ಶಕ್ಷ್ಯಥ, ಯಾಮಿಮಾಂ ಕಥಾಂ ಯಿಹೂದೀಯೇಭ್ಯಃ ಕಥಿತವಾನ್ ತಥಾಧುನಾ ಯುಷ್ಮಭ್ಯಮಪಿ ಕಥಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","ಯೂಯಂ ಪರಸ್ಪರಂ ಪ್ರೀಯಧ್ವಮ್ ಅಹಂ ಯುಷ್ಮಾಸು ಯಥಾ ಪ್ರೀಯೇ ಯೂಯಮಪಿ ಪರಸ್ಪರಮ್ ತಥೈವ ಪ್ರೀಯಧ್ವಂ, ಯುಷ್ಮಾನ್ ಇಮಾಂ ನವೀನಾಮ್ ಆಜ್ಞಾಮ್ ಆದಿಶಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","ತೇನೈವ ಯದಿ ಪರಸ್ಪರಂ ಪ್ರೀಯಧ್ವೇ ತರ್ಹಿ ಲಕ್ಷಣೇನಾನೇನ ಯೂಯಂ ಮಮ ಶಿಷ್ಯಾ ಇತಿ ಸರ್ವ್ವೇ ಜ್ಞಾತುಂ ಶಕ್ಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ಶಿಮೋನಪಿತರಃ ಪೃಷ್ಠವಾನ್ ಹೇ ಪ್ರಭೋ ಭವಾನ್ ಕುತ್ರ ಯಾಸ್ಯತಿ? ತತೋ ಯೀಶುಃ ಪ್ರತ್ಯವದತ್, ಅಹಂ ಯತ್ಸ್ಥಾನಂ ಯಾಮಿ ತತ್ಸ್ಥಾನಂ ಸಾಮ್ಪ್ರತಂ ಮಮ ಪಶ್ಚಾದ್ ಗನ್ತುಂ ನ ಶಕ್ನೋಷಿ ಕಿನ್ತು ಪಶ್ಚಾದ್ ಗಮಿಷ್ಯಸಿ| ");
INSERT INTO sankan_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","ತದಾ ಪಿತರಃ ಪ್ರತ್ಯುದಿತವಾನ್, ಹೇ ಪ್ರಭೋ ಸಾಮ್ಪ್ರತಂ ಕುತೋ ಹೇತೋಸ್ತವ ಪಶ್ಚಾದ್ ಗನ್ತುಂ ನ ಶಕ್ನೋಮಿ? ತ್ವದರ್ಥಂ ಪ್ರಾಣಾನ್ ದಾತುಂ ಶಕ್ನೋಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ತತೋ ಯೀಶುಃ ಪ್ರತ್ಯುಕ್ತವಾನ್ ಮನ್ನಿಮಿತ್ತಂ ಕಿಂ ಪ್ರಾಣಾನ್ ದಾತುಂ ಶಕ್ನೋಷಿ? ತ್ವಾಮಹಂ ಯಥಾರ್ಥಂ ವದಾಮಿ, ಕುಕ್ಕುಟರವಣಾತ್ ಪೂರ್ವ್ವಂ ತ್ವಂ ತ್ರಿ ರ್ಮಾಮ್ ಅಪಹ್ನೋಷ್ಯಸೇ| ");
INSERT INTO sankan_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","ಮನೋದುಃಖಿನೋ ಮಾ ಭೂತ; ಈಶ್ವರೇ ವಿಶ್ವಸಿತ ಮಯಿ ಚ ವಿಶ್ವಸಿತ| ");
INSERT INTO sankan_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","ಮಮ ಪಿತು ಗೃಹೇ ಬಹೂನಿ ವಾಸಸ್ಥಾನಿ ಸನ್ತಿ ನೋ ಚೇತ್ ಪೂರ್ವ್ವಂ ಯುಷ್ಮಾನ್ ಅಜ್ಞಾಪಯಿಷ್ಯಂ ಯುಷ್ಮದರ್ಥಂ ಸ್ಥಾನಂ ಸಜ್ಜಯಿತುಂ ಗಚ್ಛಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","ಯದಿ ಗತ್ವಾಹಂ ಯುಷ್ಮನ್ನಿಮಿತ್ತಂ ಸ್ಥಾನಂ ಸಜ್ಜಯಾಮಿ ತರ್ಹಿ ಪನರಾಗತ್ಯ ಯುಷ್ಮಾನ್ ಸ್ವಸಮೀಪಂ ನೇಷ್ಯಾಮಿ, ತತೋ ಯತ್ರಾಹಂ ತಿಷ್ಠಾಮಿ ತತ್ರ ಯೂಯಮಪಿ ಸ್ಥಾಸ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ಅಹಂ ಯತ್ಸ್ಥಾನಂ ಬ್ರಜಾಮಿ ತತ್ಸ್ಥಾನಂ ಯೂಯಂ ಜಾನೀಥ ತಸ್ಯ ಪನ್ಥಾನಮಪಿ ಜಾನೀಥ| ");
INSERT INTO sankan_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","ತದಾ ಥೋಮಾ ಅವದತ್, ಹೇ ಪ್ರಭೋ ಭವಾನ್ ಕುತ್ರ ಯಾತಿ ತದ್ವಯಂ ನ ಜಾನೀಮಃ, ತರ್ಹಿ ಕಥಂ ಪನ್ಥಾನಂ ಜ್ಞಾತುಂ ಶಕ್ನುಮಃ? ");
INSERT INTO sankan_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","ಯೀಶುರಕಥಯದ್ ಅಹಮೇವ ಸತ್ಯಜೀವನರೂಪಪಥೋ ಮಯಾ ನ ಗನ್ತಾ ಕೋಪಿ ಪಿತುಃ ಸಮೀಪಂ ಗನ್ತುಂ ನ ಶಕ್ನೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","ಯದಿ ಮಾಮ್ ಅಜ್ಞಾಸ್ಯತ ತರ್ಹಿ ಮಮ ಪಿತರಮಪ್ಯಜ್ಞಾಸ್ಯತ ಕಿನ್ತ್ವಧುನಾತಸ್ತಂ ಜಾನೀಥ ಪಶ್ಯಥ ಚ| ");
INSERT INTO sankan_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ತದಾ ಫಿಲಿಪಃ ಕಥಿತವಾನ್, ಹೇ ಪ್ರಭೋ ಪಿತರಂ ದರ್ಶಯ ತಸ್ಮಾದಸ್ಮಾಕಂ ಯಥೇಷ್ಟಂ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ತತೋ ಯೀಶುಃ ಪ್ರತ್ಯಾವಾದೀತ್, ಹೇ ಫಿಲಿಪ ಯುಷ್ಮಾಭಿಃ ಸಾರ್ದ್ಧಮ್ ಏತಾವದ್ದಿನಾನಿ ಸ್ಥಿತಮಪಿ ಮಾಂ ಕಿಂ ನ ಪ್ರತ್ಯಭಿಜಾನಾಸಿ? ಯೋ ಜನೋ ಮಾಮ್ ಅಪಶ್ಯತ್ ಸ ಪಿತರಮಪ್ಯಪಶ್ಯತ್ ತರ್ಹಿ ಪಿತರಮ್ ಅಸ್ಮಾನ್ ದರ್ಶಯೇತಿ ಕಥಾಂ ಕಥಂ ಕಥಯಸಿ? ");
INSERT INTO sankan_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ಅಹಂ ಪಿತರಿ ತಿಷ್ಠಾಮಿ ಪಿತಾ ಮಯಿ ತಿಷ್ಠತೀತಿ ಕಿಂ ತ್ವಂ ನ ಪ್ರತ್ಯಷಿ? ಅಹಂ ಯದ್ವಾಕ್ಯಂ ವದಾಮಿ ತತ್ ಸ್ವತೋ ನ ವದಾಮಿ ಕಿನ್ತು ಯಃ ಪಿತಾ ಮಯಿ ವಿರಾಜತೇ ಸ ಏವ ಸರ್ವ್ವಕರ್ಮ್ಮಾಣಿ ಕರಾತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ಅತಏವ ಪಿತರ್ಯ್ಯಹಂ ತಿಷ್ಠಾಮಿ ಪಿತಾ ಚ ಮಯಿ ತಿಷ್ಠತಿ ಮಮಾಸ್ಯಾಂ ಕಥಾಯಾಂ ಪ್ರತ್ಯಯಂ ಕುರುತ, ನೋ ಚೇತ್ ಕರ್ಮ್ಮಹೇತೋಃ ಪ್ರತ್ಯಯಂ ಕುರುತ| ");
INSERT INTO sankan_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","ಅಹಂ ಯುಷ್ಮಾನತಿಯಥಾರ್ಥಂ ವದಾಮಿ, ಯೋ ಜನೋ ಮಯಿ ವಿಶ್ವಸಿತಿ ಸೋಹಮಿವ ಕರ್ಮ್ಮಾಣಿ ಕರಿಷ್ಯತಿ ವರಂ ತತೋಪಿ ಮಹಾಕರ್ಮ್ಮಾಣಿ ಕರಿಷ್ಯತಿ ಯತೋ ಹೇತೋರಹಂ ಪಿತುಃ ಸಮೀಪಂ ಗಚ್ಛಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","ಯಥಾ ಪುತ್ರೇಣ ಪಿತು ರ್ಮಹಿಮಾ ಪ್ರಕಾಶತೇ ತದರ್ಥಂ ಮಮ ನಾಮ ಪ್ರೋಚ್ಯ ಯತ್ ಪ್ರಾರ್ಥಯಿಷ್ಯಧ್ವೇ ತತ್ ಸಫಲಂ ಕರಿಷ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","ಯದಿ ಮಮ ನಾಮ್ನಾ ಯತ್ ಕಿಞ್ಚಿದ್ ಯಾಚಧ್ವೇ ತರ್ಹಿ ತದಹಂ ಸಾಧಯಿಷ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","ಯದಿ ಮಯಿ ಪ್ರೀಯಧ್ವೇ ತರ್ಹಿ ಮಮಾಜ್ಞಾಃ ಸಮಾಚರತ| ");
INSERT INTO sankan_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ತತೋ ಮಯಾ ಪಿತುಃ ಸಮೀಪೇ ಪ್ರಾರ್ಥಿತೇ ಪಿತಾ ನಿರನ್ತರಂ ಯುಷ್ಮಾಭಿಃ ಸಾರ್ದ್ಧಂ ಸ್ಥಾತುಮ್ ಇತರಮೇಕಂ ಸಹಾಯಮ್ ಅರ್ಥಾತ್ ಸತ್ಯಮಯಮ್ ಆತ್ಮಾನಂ ಯುಷ್ಮಾಕಂ ನಿಕಟಂ ಪ್ರೇಷಯಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ಏತಜ್ಜಗತೋ ಲೋಕಾಸ್ತಂ ಗ್ರಹೀತುಂ ನ ಶಕ್ನುವನ್ತಿ ಯತಸ್ತೇ ತಂ ನಾಪಶ್ಯನ್ ನಾಜನಂಶ್ಚ ಕಿನ್ತು ಯೂಯಂ ಜಾನೀಥ ಯತೋ ಹೇತೋಃ ಸ ಯುಷ್ಮಾಕಮನ್ತ ರ್ನಿವಸತಿ ಯುಷ್ಮಾಕಂ ಮಧ್ಯೇ ಸ್ಥಾಸ್ಯತಿ ಚ| ");
INSERT INTO sankan_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","ಅಹಂ ಯುಷ್ಮಾನ್ ಅನಾಥಾನ್ ಕೃತ್ವಾ ನ ಯಾಸ್ಯಾಮಿ ಪುನರಪಿ ಯುಷ್ಮಾಕಂ ಸಮೀಪಮ್ ಆಗಮಿಷ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ಕಿಯತ್ಕಾಲರತ್ ಪರಮ್ ಅಸ್ಯ ಜಗತೋ ಲೋಕಾ ಮಾಂ ಪುನ ರ್ನ ದ್ರಕ್ಷ್ಯನ್ತಿ ಕಿನ್ತು ಯೂಯಂ ದ್ರಕ್ಷ್ಯಥ;ಅಹಂ ಜೀವಿಷ್ಯಾಮಿ ತಸ್ಮಾತ್ ಕಾರಣಾದ್ ಯೂಯಮಪಿ ಜೀವಿಷ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","ಪಿತರ್ಯ್ಯಹಮಸ್ಮಿ ಮಯಿ ಚ ಯೂಯಂ ಸ್ಥ, ತಥಾಹಂ ಯುಷ್ಮಾಸ್ವಸ್ಮಿ ತದಪಿ ತದಾ ಜ್ಞಾಸ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","ಯೋ ಜನೋ ಮಮಾಜ್ಞಾ ಗೃಹೀತ್ವಾ ತಾ ಆಚರತಿ ಸಏವ ಮಯಿ ಪ್ರೀಯತೇ; ಯೋ ಜನಶ್ಚ ಮಯಿ ಪ್ರೀಯತೇ ಸಏವ ಮಮ ಪಿತುಃ ಪ್ರಿಯಪಾತ್ರಂ ಭವಿಷ್ಯತಿ, ತಥಾಹಮಪಿ ತಸ್ಮಿನ್ ಪ್ರೀತ್ವಾ ತಸ್ಮೈ ಸ್ವಂ ಪ್ರಕಾಶಯಿಷ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","ತದಾ ಈಷ್ಕರಿಯೋತೀಯಾದ್ ಅನ್ಯೋ ಯಿಹೂದಾಸ್ತಮವದತ್, ಹೇ ಪ್ರಭೋ ಭವಾನ್ ಜಗತೋ ಲೋಕಾನಾಂ ಸನ್ನಿಧೌ ಪ್ರಕಾಶಿತೋ ನ ಭೂತ್ವಾಸ್ಮಾಕಂ ಸನ್ನಿಧೌ ಕುತಃ ಪ್ರಕಾಶಿತೋ ಭವಿಷ್ಯತಿ? ");
INSERT INTO sankan_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ತತೋ ಯೀಶುಃ ಪ್ರತ್ಯುದಿತವಾನ್, ಯೋ ಜನೋ ಮಯಿ ಪ್ರೀಯತೇ ಸ ಮಮಾಜ್ಞಾ ಅಪಿ ಗೃಹ್ಲಾತಿ, ತೇನ ಮಮ ಪಿತಾಪಿ ತಸ್ಮಿನ್ ಪ್ರೇಷ್ಯತೇ, ಆವಾಞ್ಚ ತನ್ನಿಕಟಮಾಗತ್ಯ ತೇನ ಸಹ ನಿವತ್ಸ್ಯಾವಃ| ");
INSERT INTO sankan_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ಯೋ ಜನೋ ಮಯಿ ನ ಪ್ರೀಯತೇ ಸ ಮಮ ಕಥಾ ಅಪಿ ನ ಗೃಹ್ಲಾತಿ ಪುನಶ್ಚ ಯಾಮಿಮಾಂ ಕಥಾಂ ಯೂಯಂ ಶೃಣುಥ ಸಾ ಕಥಾ ಕೇವಲಸ್ಯ ಮಮ ನ ಕಿನ್ತು ಮಮ ಪ್ರೇರಕೋ ಯಃ ಪಿತಾ ತಸ್ಯಾಪಿ ಕಥಾ| ");
INSERT INTO sankan_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","ಇದಾನೀಂ ಯುಷ್ಮಾಕಂ ನಿಕಟೇ ವಿದ್ಯಮಾನೋಹಮ್ ಏತಾಃ ಸಕಲಾಃ ಕಥಾಃ ಕಥಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ಕಿನ್ತ್ವಿತಃ ಪರಂ ಪಿತ್ರಾ ಯಃ ಸಹಾಯೋಽರ್ಥಾತ್ ಪವಿತ್ರ ಆತ್ಮಾ ಮಮ ನಾಮ್ನಿ ಪ್ರೇರಯಿಷ್ಯತಿ ಸ ಸರ್ವ್ವಂ ಶಿಕ್ಷಯಿತ್ವಾ ಮಯೋಕ್ತಾಃ ಸಮಸ್ತಾಃ ಕಥಾ ಯುಷ್ಮಾನ್ ಸ್ಮಾರಯಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","ಅಹಂ ಯುಷ್ಮಾಕಂ ನಿಕಟೇ ಶಾನ್ತಿಂ ಸ್ಥಾಪಯಿತ್ವಾ ಯಾಮಿ, ನಿಜಾಂ ಶಾನ್ತಿಂ ಯುಷ್ಮಭ್ಯಂ ದದಾಮಿ, ಜಗತೋ ಲೋಕಾ ಯಥಾ ದದಾತಿ ತಥಾಹಂ ನ ದದಾಮಿ; ಯುಷ್ಮಾಕಮ್ ಅನ್ತಃಕರಣಾನಿ ದುಃಖಿತಾನಿ ಭೀತಾನಿ ಚ ನ ಭವನ್ತು| ");
INSERT INTO sankan_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","ಅಹಂ ಗತ್ವಾ ಪುನರಪಿ ಯುಷ್ಮಾಕಂ ಸಮೀಪಮ್ ಆಗಮಿಷ್ಯಾಮಿ ಮಯೋಕ್ತಂ ವಾಕ್ಯಮಿದಂ ಯೂಯಮ್ ಅಶ್ರೌಷ್ಟ; ಯದಿ ಮಯ್ಯಪ್ರೇಷ್ಯಧ್ವಂ ತರ್ಹ್ಯಹಂ ಪಿತುಃ ಸಮೀಪಂ ಗಚ್ಛಾಮಿ ಮಮಾಸ್ಯಾಂ ಕಥಾಯಾಂ ಯೂಯಮ್ ಅಹ್ಲಾದಿಷ್ಯಧ್ವಂ ಯತೋ ಮಮ ಪಿತಾ ಮತ್ತೋಪಿ ಮಹಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","ತಸ್ಯಾ ಘಟನಾಯಾಃ ಸಮಯೇ ಯಥಾ ಯುಷ್ಮಾಕಂ ಶ್ರದ್ಧಾ ಜಾಯತೇ ತದರ್ಥಮ್ ಅಹಂ ತಸ್ಯಾ ಘಟನಾಯಾಃ ಪೂರ್ವ್ವಮ್ ಇದಾನೀಂ ಯುಷ್ಮಾನ್ ಏತಾಂ ವಾರ್ತ್ತಾಂ ವದಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ಇತಃ ಪರಂ ಯುಷ್ಮಾಭಿಃ ಸಹ ಮಮ ಬಹವ ಆಲಾಪಾ ನ ಭವಿಷ್ಯನ್ತಿ ಯತಃ ಕಾರಣಾದ್ ಏತಸ್ಯ ಜಗತಃ ಪತಿರಾಗಚ್ಛತಿ ಕಿನ್ತು ಮಯಾ ಸಹ ತಸ್ಯ ಕೋಪಿ ಸಮ್ಬನ್ಧೋ ನಾಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ಅಹಂ ಪಿತರಿ ಪ್ರೇಮ ಕರೋಮಿ ತಥಾ ಪಿತು ರ್ವಿಧಿವತ್ ಕರ್ಮ್ಮಾಣಿ ಕರೋಮೀತಿ ಯೇನ ಜಗತೋ ಲೋಕಾ ಜಾನನ್ತಿ ತದರ್ಥಮ್ ಉತ್ತಿಷ್ಠತ ವಯಂ ಸ್ಥಾನಾದಸ್ಮಾದ್ ಗಚ್ಛಾಮ| ");
INSERT INTO sankan_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","ಅಹಂ ಸತ್ಯದ್ರಾಕ್ಷಾಲತಾಸ್ವರೂಪೋ ಮಮ ಪಿತಾ ತೂದ್ಯಾನಪರಿಚಾರಕಸ್ವರೂಪಞ್ಚ| ");
INSERT INTO sankan_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","ಮಮ ಯಾಸು ಶಾಖಾಸು ಫಲಾನಿ ನ ಭವನ್ತಿ ತಾಃ ಸ ಛಿನತ್ತಿ ತಥಾ ಫಲವತ್ಯಃ ಶಾಖಾ ಯಥಾಧಿಕಫಲಾನಿ ಫಲನ್ತಿ ತದರ್ಥಂ ತಾಃ ಪರಿಷ್ಕರೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ಇದಾನೀಂ ಮಯೋಕ್ತೋಪದೇಶೇನ ಯೂಯಂ ಪರಿಷ್ಕೃತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ಅತಃ ಕಾರಣಾತ್ ಮಯಿ ತಿಷ್ಠತ ತೇನಾಹಮಪಿ ಯುಷ್ಮಾಸು ತಿಷ್ಠಾಮಿ, ಯತೋ ಹೇತೋ ರ್ದ್ರಾಕ್ಷಾಲತಾಯಾಮ್ ಅಸಂಲಗ್ನಾ ಶಾಖಾ ಯಥಾ ಫಲವತೀ ಭವಿತುಂ ನ ಶಕ್ನೋತಿ ತಥಾ ಯೂಯಮಪಿ ಮಯ್ಯತಿಷ್ಠನ್ತಃ ಫಲವನ್ತೋ ಭವಿತುಂ ನ ಶಕ್ನುಥ| ");
INSERT INTO sankan_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","ಅಹಂ ದ್ರಾಕ್ಷಾಲತಾಸ್ವರೂಪೋ ಯೂಯಞ್ಚ ಶಾಖಾಸ್ವರೂಪೋಃ; ಯೋ ಜನೋ ಮಯಿ ತಿಷ್ಠತಿ ಯತ್ರ ಚಾಹಂ ತಿಷ್ಠಾಮಿ, ಸ ಪ್ರಚೂರಫಲೈಃ ಫಲವಾನ್ ಭವತಿ, ಕಿನ್ತು ಮಾಂ ವಿನಾ ಯೂಯಂ ಕಿಮಪಿ ಕರ್ತ್ತುಂ ನ ಶಕ್ನುಥ| ");
INSERT INTO sankan_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ಯಃ ಕಶ್ಚಿನ್ ಮಯಿ ನ ತಿಷ್ಠತಿ ಸ ಶುಷ್ಕಶಾಖೇವ ಬಹಿ ರ್ನಿಕ್ಷಿಪ್ಯತೇ ಲೋಕಾಶ್ಚ ತಾ ಆಹೃತ್ಯ ವಹ್ನೌ ನಿಕ್ಷಿಪ್ಯ ದಾಹಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","ಯದಿ ಯೂಯಂ ಮಯಿ ತಿಷ್ಠಥ ಮಮ ಕಥಾ ಚ ಯುಷ್ಮಾಸು ತಿಷ್ಠತಿ ತರ್ಹಿ ಯದ್ ವಾಞ್ಛಿತ್ವಾ ಯಾಚಿಷ್ಯಧ್ವೇ ಯುಷ್ಮಾಕಂ ತದೇವ ಸಫಲಂ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","ಯದಿ ಯೂಯಂ ಪ್ರಚೂರಫಲವನ್ತೋ ಭವಥ ತರ್ಹಿ ತದ್ವಾರಾ ಮಮ ಪಿತು ರ್ಮಹಿಮಾ ಪ್ರಕಾಶಿಷ್ಯತೇ ತಥಾ ಯೂಯಂ ಮಮ ಶಿಷ್ಯಾ ಇತಿ ಪರಿಕ್ಷಾಯಿಷ್ಯಧ್ವೇ| ");
INSERT INTO sankan_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","ಪಿತಾ ಯಥಾ ಮಯಿ ಪ್ರೀತವಾನ್ ಅಹಮಪಿ ಯುಷ್ಮಾಸು ತಥಾ ಪ್ರೀತವಾನ್ ಅತೋ ಹೇತೋ ರ್ಯೂಯಂ ನಿರನ್ತರಂ ಮಮ ಪ್ರೇಮಪಾತ್ರಾಣಿ ಭೂತ್ವಾ ತಿಷ್ಠತ| ");
INSERT INTO sankan_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ಅಹಂ ಯಥಾ ಪಿತುರಾಜ್ಞಾ ಗೃಹೀತ್ವಾ ತಸ್ಯ ಪ್ರೇಮಭಾಜನಂ ತಿಷ್ಠಾಮಿ ತಥೈವ ಯೂಯಮಪಿ ಯದಿ ಮಮಾಜ್ಞಾ ಗುಹ್ಲೀಥ ತರ್ಹಿ ಮಮ ಪ್ರೇಮಭಾಜನಾನಿ ಸ್ಥಾಸ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","ಯುಷ್ಮನ್ನಿಮಿತ್ತಂ ಮಮ ಯ ಆಹ್ಲಾದಃ ಸ ಯಥಾ ಚಿರಂ ತಿಷ್ಠತಿ ಯುಷ್ಮಾಕಮ್ ಆನನ್ದಶ್ಚ ಯಥಾ ಪೂರ್ಯ್ಯತೇ ತದರ್ಥಂ ಯುಷ್ಮಭ್ಯಮ್ ಏತಾಃ ಕಥಾ ಅತ್ರಕಥಮ್| ");
INSERT INTO sankan_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","ಅಹಂ ಯುಷ್ಮಾಸು ಯಥಾ ಪ್ರೀಯೇ ಯೂಯಮಪಿ ಪರಸ್ಪರಂ ತಥಾ ಪ್ರೀಯಧ್ವಮ್ ಏಷಾ ಮಮಾಜ್ಞಾ| ");
INSERT INTO sankan_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","ಮಿತ್ರಾಣಾಂ ಕಾರಣಾತ್ ಸ್ವಪ್ರಾಣದಾನಪರ್ಯ್ಯನ್ತಂ ಯತ್ ಪ್ರೇಮ ತಸ್ಮಾನ್ ಮಹಾಪ್ರೇಮ ಕಸ್ಯಾಪಿ ನಾಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","ಅಹಂ ಯದ್ಯದ್ ಆದಿಶಾಮಿ ತತ್ತದೇವ ಯದಿ ಯೂಯಮ್ ಆಚರತ ತರ್ಹಿ ಯೂಯಮೇವ ಮಮ ಮಿತ್ರಾಣಿ| ");
INSERT INTO sankan_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","ಅದ್ಯಾರಭ್ಯ ಯುಷ್ಮಾನ್ ದಾಸಾನ್ ನ ವದಿಷ್ಯಾಮಿ ಯತ್ ಪ್ರಭು ರ್ಯತ್ ಕರೋತಿ ದಾಸಸ್ತದ್ ನ ಜಾನಾತಿ; ಕಿನ್ತು ಪಿತುಃ ಸಮೀಪೇ ಯದ್ಯದ್ ಅಶೃಣವಂ ತತ್ ಸರ್ವ್ವಂ ಯೂಷ್ಮಾನ್ ಅಜ್ಞಾಪಯಮ್ ತತ್ಕಾರಣಾದ್ ಯುಷ್ಮಾನ್ ಮಿತ್ರಾಣಿ ಪ್ರೋಕ್ತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","ಯೂಯಂ ಮಾಂ ರೋಚಿತವನ್ತ ಇತಿ ನ, ಕಿನ್ತ್ವಹಮೇವ ಯುಷ್ಮಾನ್ ರೋಚಿತವಾನ್ ಯೂಯಂ ಗತ್ವಾ ಯಥಾ ಫಲಾನ್ಯುತ್ಪಾದಯಥ ತಾನಿ ಫಲಾನಿ ಚಾಕ್ಷಯಾಣಿ ಭವನ್ತಿ, ತದರ್ಥಂ ಯುಷ್ಮಾನ್ ನ್ಯಜುನಜಂ ತಸ್ಮಾನ್ ಮಮ ನಾಮ ಪ್ರೋಚ್ಯ ಪಿತರಂ ಯತ್ ಕಿಞ್ಚಿದ್ ಯಾಚಿಷ್ಯಧ್ವೇ ತದೇವ ಸ ಯುಷ್ಮಭ್ಯಂ ದಾಸ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","ಯೂಯಂ ಪರಸ್ಪರಂ ಪ್ರೀಯಧ್ವಮ್ ಅಹಮ್ ಇತ್ಯಾಜ್ಞಾಪಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","ಜಗತೋ ಲೋಕೈ ರ್ಯುಷ್ಮಾಸು ಋತೀಯಿತೇಷು ತೇ ಪೂರ್ವ್ವಂ ಮಾಮೇವಾರ್ತ್ತೀಯನ್ತ ಇತಿ ಯೂಯಂ ಜಾನೀಥ| ");
INSERT INTO sankan_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","ಯದಿ ಯೂಯಂ ಜಗತೋ ಲೋಕಾ ಅಭವಿಷ್ಯತ ತರ್ಹಿ ಜಗತೋ ಲೋಕಾ ಯುಷ್ಮಾನ್ ಆತ್ಮೀಯಾನ್ ಬುದ್ಧ್ವಾಪ್ರೇಷ್ಯನ್ತ; ಕಿನ್ತು ಯೂಯಂ ಜಗತೋ ಲೋಕಾ ನ ಭವಥ, ಅಹಂ ಯುಷ್ಮಾನ್ ಅಸ್ಮಾಜ್ಜಗತೋಽರೋಚಯಮ್ ಏತಸ್ಮಾತ್ ಕಾರಣಾಜ್ಜಗತೋ ಲೋಕಾ ಯುಷ್ಮಾನ್ ಋತೀಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","ದಾಸಃ ಪ್ರಭೋ ರ್ಮಹಾನ್ ನ ಭವತಿ ಮಮೈತತ್ ಪೂರ್ವ್ವೀಯಂ ವಾಕ್ಯಂ ಸ್ಮರತ; ತೇ ಯದಿ ಮಾಮೇವಾತಾಡಯನ್ ತರ್ಹಿ ಯುಷ್ಮಾನಪಿ ತಾಡಯಿಷ್ಯನ್ತಿ, ಯದಿ ಮಮ ವಾಕ್ಯಂ ಗೃಹ್ಲನ್ತಿ ತರ್ಹಿ ಯುಷ್ಮಾಕಮಪಿ ವಾಕ್ಯಂ ಗ್ರಹೀಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","ಕಿನ್ತು ತೇ ಮಮ ನಾಮಕಾರಣಾದ್ ಯುಷ್ಮಾನ್ ಪ್ರತಿ ತಾದೃಶಂ ವ್ಯವಹರಿಷ್ಯನ್ತಿ ಯತೋ ಯೋ ಮಾಂ ಪ್ರೇರಿತವಾನ್ ತಂ ತೇ ನ ಜಾನನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","ತೇಷಾಂ ಸನ್ನಿಧಿಮ್ ಆಗತ್ಯ ಯದ್ಯಹಂ ನಾಕಥಯಿಷ್ಯಂ ತರ್ಹಿ ತೇಷಾಂ ಪಾಪಂ ನಾಭವಿಷ್ಯತ್ ಕಿನ್ತ್ವಧುನಾ ತೇಷಾಂ ಪಾಪಮಾಚ್ಛಾದಯಿತುಮ್ ಉಪಾಯೋ ನಾಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","ಯೋ ಜನೋ ಮಾಮ್ ಋತೀಯತೇ ಸ ಮಮ ಪಿತರಮಪಿ ಋತೀಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","ಯಾದೃಶಾನಿ ಕರ್ಮ್ಮಾಣಿ ಕೇನಾಪಿ ಕದಾಪಿ ನಾಕ್ರಿಯನ್ತ ತಾದೃಶಾನಿ ಕರ್ಮ್ಮಾಣಿ ಯದಿ ತೇಷಾಂ ಸಾಕ್ಷಾದ್ ಅಹಂ ನಾಕರಿಷ್ಯಂ ತರ್ಹಿ ತೇಷಾಂ ಪಾಪಂ ನಾಭವಿಷ್ಯತ್ ಕಿನ್ತ್ವಧುನಾ ತೇ ದೃಷ್ಟ್ವಾಪಿ ಮಾಂ ಮಮ ಪಿತರಞ್ಚಾರ್ತ್ತೀಯನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","ತಸ್ಮಾತ್ ತೇಽಕಾರಣಂ ಮಾಮ್ ಋತೀಯನ್ತೇ ಯದೇತದ್ ವಚನಂ ತೇಷಾಂ ಶಾಸ್ತ್ರೇ ಲಿಖಿತಮಾಸ್ತೇ ತತ್ ಸಫಲಮ್ ಅಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","ಕಿನ್ತು ಪಿತು ರ್ನಿರ್ಗತಂ ಯಂ ಸಹಾಯಮರ್ಥಾತ್ ಸತ್ಯಮಯಮ್ ಆತ್ಮಾನಂ ಪಿತುಃ ಸಮೀಪಾದ್ ಯುಷ್ಮಾಕಂ ಸಮೀಪೇ ಪ್ರೇಷಯಿಷ್ಯಾಮಿ ಸ ಆಗತ್ಯ ಮಯಿ ಪ್ರಮಾಣಂ ದಾಸ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ಯೂಯಂ ಪ್ರಥಮಮಾರಭ್ಯ ಮಯಾ ಸಾರ್ದ್ಧಂ ತಿಷ್ಠಥ ತಸ್ಮಾದ್ಧೇತೋ ರ್ಯೂಯಮಪಿ ಪ್ರಮಾಣಂ ದಾಸ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","ಯುಷ್ಮಾಕಂ ಯಥಾ ವಾಧಾ ನ ಜಾಯತೇ ತದರ್ಥಂ ಯುಷ್ಮಾನ್ ಏತಾನಿ ಸರ್ವ್ವವಾಕ್ಯಾನಿ ವ್ಯಾಹರಂ| ");
INSERT INTO sankan_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ಲೋಕಾ ಯುಷ್ಮಾನ್ ಭಜನಗೃಹೇಭ್ಯೋ ದೂರೀಕರಿಷ್ಯನ್ತಿ ತಥಾ ಯಸ್ಮಿನ್ ಸಮಯೇ ಯುಷ್ಮಾನ್ ಹತ್ವಾ ಈಶ್ವರಸ್ಯ ತುಷ್ಟಿ ಜನಕಂ ಕರ್ಮ್ಮಾಕುರ್ಮ್ಮ ಇತಿ ಮಂಸ್ಯನ್ತೇ ಸ ಸಮಯ ಆಗಚ್ಛನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","ತೇ ಪಿತರಂ ಮಾಞ್ಚ ನ ಜಾನನ್ತಿ, ತಸ್ಮಾದ್ ಯುಷ್ಮಾನ್ ಪ್ರತೀದೃಶಮ್ ಆಚರಿಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","ಅತೋ ಹೇತಾಃ ಸಮಯೇ ಸಮುಪಸ್ಥಿತೇ ಯಥಾ ಮಮ ಕಥಾ ಯುಷ್ಮಾಕಂ ಮನಃಸುಃ ಸಮುಪತಿಷ್ಠತಿ ತದರ್ಥಂ ಯುಷ್ಮಾಭ್ಯಮ್ ಏತಾಂ ಕಥಾಂ ಕಥಯಾಮಿ ಯುಷ್ಮಾಭಿಃ ಸಾರ್ದ್ಧಮ್ ಅಹಂ ತಿಷ್ಠನ್ ಪ್ರಥಮಂ ತಾಂ ಯುಷ್ಮಭ್ಯಂ ನಾಕಥಯಂ| ");
INSERT INTO sankan_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","ಸಾಮ್ಪ್ರತಂ ಸ್ವಸ್ಯ ಪ್ರೇರಯಿತುಃ ಸಮೀಪಂ ಗಚ್ಛಾಮಿ ತಥಾಪಿ ತ್ವಂ ಕ್ಕ ಗಚ್ಛಸಿ ಕಥಾಮೇತಾಂ ಯುಷ್ಮಾಕಂ ಕೋಪಿ ಮಾಂ ನ ಪೃಚ್ಛತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","ಕಿನ್ತು ಮಯೋಕ್ತಾಭಿರಾಭಿಃ ಕಥಾಭಿ ರ್ಯೂಷ್ಮಾಕಮ್ ಅನ್ತಃಕರಣಾನಿ ದುಃಖೇನ ಪೂರ್ಣಾನ್ಯಭವನ್| ");
INSERT INTO sankan_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","ತಥಾಪ್ಯಹಂ ಯಥಾರ್ಥಂ ಕಥಯಾಮಿ ಮಮ ಗಮನಂ ಯುಷ್ಮಾಕಂ ಹಿತಾರ್ಥಮೇವ, ಯತೋ ಹೇತೋ ರ್ಗಮನೇ ನ ಕೃತೇ ಸಹಾಯೋ ಯುಷ್ಮಾಕಂ ಸಮೀಪಂ ನಾಗಮಿಷ್ಯತಿ ಕಿನ್ತು ಯದಿ ಗಚ್ಛಾಮಿ ತರ್ಹಿ ಯುಷ್ಮಾಕಂ ಸಮೀಪೇ ತಂ ಪ್ರೇಷಯಿಷ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","ತತಃ ಸ ಆಗತ್ಯ ಪಾಪಪುಣ್ಯದಣ್ಡೇಷು ಜಗತೋ ಲೋಕಾನಾಂ ಪ್ರಬೋಧಂ ಜನಯಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ತೇ ಮಯಿ ನ ವಿಶ್ವಸನ್ತಿ ತಸ್ಮಾದ್ಧೇತೋಃ ಪಾಪಪ್ರಬೋಧಂ ಜನಯಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ಯುಷ್ಮಾಕಮ್ ಅದೃಶ್ಯಃ ಸನ್ನಹಂ ಪಿತುಃ ಸಮೀಪಂ ಗಚ್ಛಾಮಿ ತಸ್ಮಾದ್ ಪುಣ್ಯೇ ಪ್ರಬೋಧಂ ಜನಯಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ಏತಜ್ಜಗತೋಽಧಿಪತಿ ರ್ದಣ್ಡಾಜ್ಞಾಂ ಪ್ರಾಪ್ನೋತಿ ತಸ್ಮಾದ್ ದಣ್ಡೇ ಪ್ರಬೋಧಂ ಜನಯಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","ಯುಷ್ಮಭ್ಯಂ ಕಥಯಿತುಂ ಮಮಾನೇಕಾಃ ಕಥಾ ಆಸತೇ, ತಾಃ ಕಥಾ ಇದಾನೀಂ ಯೂಯಂ ಸೋಢುಂ ನ ಶಕ್ನುಥ; ");
INSERT INTO sankan_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","ಕಿನ್ತು ಸತ್ಯಮಯ ಆತ್ಮಾ ಯದಾ ಸಮಾಗಮಿಷ್ಯತಿ ತದಾ ಸರ್ವ್ವಂ ಸತ್ಯಂ ಯುಷ್ಮಾನ್ ನೇಷ್ಯತಿ, ಸ ಸ್ವತಃ ಕಿಮಪಿ ನ ವದಿಷ್ಯತಿ ಕಿನ್ತು ಯಚ್ಛ್ರೋಷ್ಯತಿ ತದೇವ ಕಥಯಿತ್ವಾ ಭಾವಿಕಾರ್ಯ್ಯಂ ಯುಷ್ಮಾನ್ ಜ್ಞಾಪಯಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","ಮಮ ಮಹಿಮಾನಂ ಪ್ರಕಾಶಯಿಷ್ಯತಿ ಯತೋ ಮದೀಯಾಂ ಕಥಾಂ ಗೃಹೀತ್ವಾ ಯುಷ್ಮಾನ್ ಬೋಧಯಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","ಪಿತು ರ್ಯದ್ಯದ್ ಆಸ್ತೇ ತತ್ ಸರ್ವ್ವಂ ಮಮ ತಸ್ಮಾದ್ ಕಾರಣಾದ್ ಅವಾದಿಷಂ ಸ ಮದೀಯಾಂ ಕಥಾಂ ಗೃಹೀತ್ವಾ ಯುಷ್ಮಾನ್ ಬೋಧಯಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","ಕಿಯತ್ಕಾಲಾತ್ ಪರಂ ಯೂಯಂ ಮಾಂ ದ್ರಷ್ಟುಂ ನ ಲಪ್ಸ್ಯಧ್ವೇ ಕಿನ್ತು ಕಿಯತ್ಕಾಲಾತ್ ಪರಂ ಪುನ ರ್ದ್ರಷ್ಟುಂ ಲಪ್ಸ್ಯಧ್ವೇ ಯತೋಹಂ ಪಿತುಃ ಸಮೀಪಂ ಗಚ್ಛಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ತತಃ ಶಿಷ್ಯಾಣಾಂ ಕಿಯನ್ತೋ ಜನಾಃ ಪರಸ್ಪರಂ ವದಿತುಮ್ ಆರಭನ್ತ, ಕಿಯತ್ಕಾಲಾತ್ ಪರಂ ಮಾಂ ದ್ರಷ್ಟುಂ ನ ಲಪ್ಸ್ಯಧ್ವೇ ಕಿನ್ತು ಕಿಯತ್ಕಾಲಾತ್ ಪರಂ ಪುನ ರ್ದ್ರಷ್ಟುಂ ಲಪ್ಸ್ಯಧ್ವೇ ಯತೋಹಂ ಪಿತುಃ ಸಮೀಪಂ ಗಚ್ಛಾಮಿ, ಇತಿ ಯದ್ ವಾಕ್ಯಮ್ ಅಯಂ ವದತಿ ತತ್ ಕಿಂ? ");
INSERT INTO sankan_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","ತತಃ ಕಿಯತ್ಕಾಲಾತ್ ಪರಮ್ ಇತಿ ತಸ್ಯ ವಾಕ್ಯಂ ಕಿಂ? ತಸ್ಯ ವಾಕ್ಯಸ್ಯಾಭಿಪ್ರಾಯಂ ವಯಂ ಬೋದ್ಧುಂ ನ ಶಕ್ನುಮಸ್ತೈರಿತಿ ");
INSERT INTO sankan_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","ನಿಗದಿತೇ ಯೀಶುಸ್ತೇಷಾಂ ಪ್ರಶ್ನೇಚ್ಛಾಂ ಜ್ಞಾತ್ವಾ ತೇಭ್ಯೋಽಕಥಯತ್ ಕಿಯತ್ಕಾಲಾತ್ ಪರಂ ಮಾಂ ದ್ರಷ್ಟುಂ ನ ಲಪ್ಸ್ಯಧ್ವೇ, ಕಿನ್ತು ಕಿಯತ್ಕಾಲಾತ್ ಪರಂ ಪೂನ ರ್ದ್ರಷ್ಟುಂ ಲಪ್ಸ್ಯಧ್ವೇ, ಯಾಮಿಮಾಂ ಕಥಾಮಕಥಯಂ ತಸ್ಯಾ ಅಭಿಪ್ರಾಯಂ ಕಿಂ ಯೂಯಂ ಪರಸ್ಪರಂ ಮೃಗಯಧ್ವೇ? ");
INSERT INTO sankan_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","ಯುಷ್ಮಾನಹಮ್ ಅತಿಯಥಾರ್ಥಂ ವದಾಮಿ ಯೂಯಂ ಕ್ರನ್ದಿಷ್ಯಥ ವಿಲಪಿಷ್ಯಥ ಚ, ಕಿನ್ತು ಜಗತೋ ಲೋಕಾ ಆನನ್ದಿಷ್ಯನ್ತಿ; ಯೂಯಂ ಶೋಕಾಕುಲಾ ಭವಿಷ್ಯಥ ಕಿನ್ತು ಶೋಕಾತ್ ಪರಂ ಆನನ್ದಯುಕ್ತಾ ಭವಿಷ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","ಪ್ರಸವಕಾಲ ಉಪಸ್ಥಿತೇ ನಾರೀ ಯಥಾ ಪ್ರಸವವೇದನಯಾ ವ್ಯಾಕುಲಾ ಭವತಿ ಕಿನ್ತು ಪುತ್ರೇ ಭೂಮಿಷ್ಠೇ ಸತಿ ಮನುಷ್ಯೈಕೋ ಜನ್ಮನಾ ನರಲೋಕೇ ಪ್ರವಿಷ್ಟ ಇತ್ಯಾನನ್ದಾತ್ ತಸ್ಯಾಸ್ತತ್ಸರ್ವ್ವಂ ದುಃಖಂ ಮನಸಿ ನ ತಿಷ್ಠತಿ, ");
INSERT INTO sankan_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","ತಥಾ ಯೂಯಮಪಿ ಸಾಮ್ಪ್ರತಂ ಶೋಕಾಕುಲಾ ಭವಥ ಕಿನ್ತು ಪುನರಪಿ ಯುಷ್ಮಭ್ಯಂ ದರ್ಶನಂ ದಾಸ್ಯಾಮಿ ತೇನ ಯುಷ್ಮಾಕಮ್ ಅನ್ತಃಕರಣಾನಿ ಸಾನನ್ದಾನಿ ಭವಿಷ್ಯನ್ತಿ, ಯುಷ್ಮಾಕಂ ತಮ್ ಆನನ್ದಞ್ಚ ಕೋಪಿ ಹರ್ತ್ತುಂ ನ ಶಕ್ಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","ತಸ್ಮಿನ್ ದಿವಸೇ ಕಾಮಪಿ ಕಥಾಂ ಮಾಂ ನ ಪ್ರಕ್ಷ್ಯಥ| ಯುಷ್ಮಾನಹಮ್ ಅತಿಯಥಾರ್ಥಂ ವದಾಮಿ, ಮಮ ನಾಮ್ನಾ ಯತ್ ಕಿಞ್ಚಿದ್ ಪಿತರಂ ಯಾಚಿಷ್ಯಧ್ವೇ ತದೇವ ಸ ದಾಸ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","ಪೂರ್ವ್ವೇ ಮಮ ನಾಮ್ನಾ ಕಿಮಪಿ ನಾಯಾಚಧ್ವಂ, ಯಾಚಧ್ವಂ ತತಃ ಪ್ರಾಪ್ಸ್ಯಥ ತಸ್ಮಾದ್ ಯುಷ್ಮಾಕಂ ಸಮ್ಪೂರ್ಣಾನನ್ದೋ ಜನಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","ಉಪಮಾಕಥಾಭಿಃ ಸರ್ವ್ವಾಣ್ಯೇತಾನಿ ಯುಷ್ಮಾನ್ ಜ್ಞಾಪಿತವಾನ್ ಕಿನ್ತು ಯಸ್ಮಿನ್ ಸಮಯೇ ಉಪಮಯಾ ನೋಕ್ತ್ವಾ ಪಿತುಃ ಕಥಾಂ ಸ್ಪಷ್ಟಂ ಜ್ಞಾಪಯಿಷ್ಯಾಮಿ ಸಮಯ ಏತಾದೃಶ ಆಗಚ್ಛತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ತದಾ ಮಮ ನಾಮ್ನಾ ಪ್ರಾರ್ಥಯಿಷ್ಯಧ್ವೇ ಽಹಂ ಯುಷ್ಮನ್ನಿಮಿತ್ತಂ ಪಿತರಂ ವಿನೇಷ್ಯೇ ಕಥಾಮಿಮಾಂ ನ ವದಾಮಿ; ");
INSERT INTO sankan_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ಯತೋ ಯೂಯಂ ಮಯಿ ಪ್ರೇಮ ಕುರುಥ, ತಥಾಹಮ್ ಈಶ್ವರಸ್ಯ ಸಮೀಪಾದ್ ಆಗತವಾನ್ ಇತ್ಯಪಿ ಪ್ರತೀಥ, ತಸ್ಮಾದ್ ಕಾರಣಾತ್ ಕಾರಣಾತ್ ಪಿತಾ ಸ್ವಯಂ ಯುಷ್ಮಾಸು ಪ್ರೀಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","ಪಿತುಃ ಸಮೀಪಾಜ್ಜಜದ್ ಆಗತೋಸ್ಮಿ ಜಗತ್ ಪರಿತ್ಯಜ್ಯ ಚ ಪುನರಪಿ ಪಿತುಃ ಸಮೀಪಂ ಗಚ್ಛಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ತದಾ ಶಿಷ್ಯಾ ಅವದನ್, ಹೇ ಪ್ರಭೋ ಭವಾನ್ ಉಪಮಯಾ ನೋಕ್ತ್ವಾಧುನಾ ಸ್ಪಷ್ಟಂ ವದತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ಭವಾನ್ ಸರ್ವ್ವಜ್ಞಃ ಕೇನಚಿತ್ ಪೃಷ್ಟೋ ಭವಿತುಮಪಿ ಭವತಃ ಪ್ರಯೋಜನಂ ನಾಸ್ತೀತ್ಯಧುನಾಸ್ಮಾಕಂ ಸ್ಥಿರಜ್ಞಾನಂ ಜಾತಂ ತಸ್ಮಾದ್ ಭವಾನ್ ಈಶ್ವರಸ್ಯ ಸಮೀಪಾದ್ ಆಗತವಾನ್ ಇತ್ಯತ್ರ ವಯಂ ವಿಶ್ವಸಿಮಃ| ");
INSERT INTO sankan_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ತತೋ ಯೀಶುಃ ಪ್ರತ್ಯವಾದೀದ್ ಇದಾನೀಂ ಕಿಂ ಯೂಯಂ ವಿಶ್ವಸಿಥ? ");
INSERT INTO sankan_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ಪಶ್ಯತ ಸರ್ವ್ವೇ ಯೂಯಂ ವಿಕೀರ್ಣಾಃ ಸನ್ತೋ ಮಾಮ್ ಏಕಾಕಿನಂ ಪೀರತ್ಯಜ್ಯ ಸ್ವಂ ಸ್ವಂ ಸ್ಥಾನಂ ಗಮಿಷ್ಯಥ, ಏತಾದೃಶಃ ಸಮಯ ಆಗಚ್ಛತಿ ವರಂ ಪ್ರಾಯೇಣೋಪಸ್ಥಿತವಾನ್; ತಥಾಪ್ಯಹಂ ನೈಕಾಕೀ ಭವಾಮಿ ಯತಃ ಪಿತಾ ಮಯಾ ಸಾರ್ದ್ಧಮ್ ಆಸ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","ಯಥಾ ಮಯಾ ಯುಷ್ಮಾಕಂ ಶಾನ್ತಿ ರ್ಜಾಯತೇ ತದರ್ಥಮ್ ಏತಾಃ ಕಥಾ ಯುಷ್ಮಭ್ಯಮ್ ಅಚಕಥಂ; ಅಸ್ಮಿನ್ ಜಗತಿ ಯುಷ್ಮಾಕಂ ಕ್ಲೇಶೋ ಘಟಿಷ್ಯತೇ ಕಿನ್ತ್ವಕ್ಷೋಭಾ ಭವತ ಯತೋ ಮಯಾ ಜಗಜ್ಜಿತಂ| ");
INSERT INTO sankan_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","ತತಃ ಪರಂ ಯೀಶುರೇತಾಃ ಕಥಾಃ ಕಥಯಿತ್ವಾ ಸ್ವರ್ಗಂ ವಿಲೋಕ್ಯೈತತ್ ಪ್ರಾರ್ಥಯತ್, ಹೇ ಪಿತಃ ಸಮಯ ಉಪಸ್ಥಿತವಾನ್; ಯಥಾ ತವ ಪುತ್ರಸ್ತವ ಮಹಿಮಾನಂ ಪ್ರಕಾಶಯತಿ ತದರ್ಥಂ ತ್ವಂ ನಿಜಪುತ್ರಸ್ಯ ಮಹಿಮಾನಂ ಪ್ರಕಾಶಯ| ");
INSERT INTO sankan_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ತ್ವಂ ಯೋಲ್ಲೋಕಾನ್ ತಸ್ಯ ಹಸ್ತೇ ಸಮರ್ಪಿತವಾನ್ ಸ ಯಥಾ ತೇಭ್ಯೋಽನನ್ತಾಯು ರ್ದದಾತಿ ತದರ್ಥಂ ತ್ವಂ ಪ್ರಾಣಿಮಾತ್ರಾಣಾಮ್ ಅಧಿಪತಿತ್ವಭಾರಂ ತಸ್ಮೈ ದತ್ತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","ಯಸ್ತ್ವಮ್ ಅದ್ವಿತೀಯಃ ಸತ್ಯ ಈಶ್ವರಸ್ತ್ವಯಾ ಪ್ರೇರಿತಶ್ಚ ಯೀಶುಃ ಖ್ರೀಷ್ಟ ಏತಯೋರುಭಯೋಃ ಪರಿಚಯೇ ಪ್ರಾಪ್ತೇಽನನ್ತಾಯು ರ್ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ತ್ವಂ ಯಸ್ಯ ಕರ್ಮ್ಮಣೋ ಭಾರಂ ಮಹ್ಯಂ ದತ್ತವಾನ್, ತತ್ ಸಮ್ಪನ್ನಂ ಕೃತ್ವಾ ಜಗತ್ಯಸ್ಮಿನ್ ತವ ಮಹಿಮಾನಂ ಪ್ರಾಕಾಶಯಂ| ");
INSERT INTO sankan_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ಅತಏವ ಹೇ ಪಿತ ರ್ಜಗತ್ಯವಿದ್ಯಮಾನೇ ತ್ವಯಾ ಸಹ ತಿಷ್ಠತೋ ಮಮ ಯೋ ಮಹಿಮಾಸೀತ್ ಸಮ್ಪ್ರತಿ ತವ ಸಮೀಪೇ ಮಾಂ ತಂ ಮಹಿಮಾನಂ ಪ್ರಾಪಯ| ");
INSERT INTO sankan_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","ಅನ್ಯಚ್ಚ ತ್ವಮ್ ಏತಜ್ಜಗತೋ ಯಾಲ್ಲೋಕಾನ್ ಮಹ್ಯಮ್ ಅದದಾ ಅಹಂ ತೇಭ್ಯಸ್ತವ ನಾಮ್ನಸ್ತತ್ತ್ವಜ್ಞಾನಮ್ ಅದದಾಂ, ತೇ ತವೈವಾಸನ್, ತ್ವಂ ತಾನ್ ಮಹ್ಯಮದದಾಃ, ತಸ್ಮಾತ್ತೇ ತವೋಪದೇಶಮ್ ಅಗೃಹ್ಲನ್| ");
INSERT INTO sankan_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ತ್ವಂ ಮಹ್ಯಂ ಯತ್ ಕಿಞ್ಚಿದ್ ಅದದಾಸ್ತತ್ಸರ್ವ್ವಂ ತ್ವತ್ತೋ ಜಾಯತೇ ಇತ್ಯಧುನಾಜಾನನ್| ");
INSERT INTO sankan_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ಮಹ್ಯಂ ಯಮುಪದೇಶಮ್ ಅದದಾ ಅಹಮಪಿ ತೇಭ್ಯಸ್ತಮುಪದೇಶಮ್ ಅದದಾಂ ತೇಪಿ ತಮಗೃಹ್ಲನ್ ತ್ವತ್ತೋಹಂ ನಿರ್ಗತ್ಯ ತ್ವಯಾ ಪ್ರೇರಿತೋಭವಮ್ ಅತ್ರ ಚ ವ್ಯಶ್ವಸನ್| ");
INSERT INTO sankan_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","ತೇಷಾಮೇವ ನಿಮಿತ್ತಂ ಪ್ರಾರ್ಥಯೇಽಹಂ ಜಗತೋ ಲೋಕನಿಮಿತ್ತಂ ನ ಪ್ರಾರ್ಥಯೇ ಕಿನ್ತು ಯಾಲ್ಲೋಕಾನ್ ಮಹ್ಯಮ್ ಅದದಾಸ್ತೇಷಾಮೇವ ನಿಮಿತ್ತಂ ಪ್ರಾರ್ಥಯೇಽಹಂ ಯತಸ್ತೇ ತವೈವಾಸತೇ| ");
INSERT INTO sankan_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ಯೇ ಮಮ ತೇ ತವ ಯೇ ಚ ತವ ತೇ ಮಮ ತಥಾ ತೈ ರ್ಮಮ ಮಹಿಮಾ ಪ್ರಕಾಶ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","ಸಾಮ್ಪ್ರತಮ್ ಅಸ್ಮಿನ್ ಜಗತಿ ಮಮಾವಸ್ಥಿತೇಃ ಶೇಷಮ್ ಅಭವತ್ ಅಹಂ ತವ ಸಮೀಪಂ ಗಚ್ಛಾಮಿ ಕಿನ್ತು ತೇ ಜಗತಿ ಸ್ಥಾಸ್ಯನ್ತಿ; ಹೇ ಪವಿತ್ರ ಪಿತರಾವಯೋ ರ್ಯಥೈಕತ್ವಮಾಸ್ತೇ ತಥಾ ತೇಷಾಮಪ್ಯೇಕತ್ವಂ ಭವತಿ ತದರ್ಥಂ ಯಾಲ್ಲೋಕಾನ್ ಮಹ್ಯಮ್ ಅದದಾಸ್ತಾನ್ ಸ್ವನಾಮ್ನಾ ರಕ್ಷ| ");
INSERT INTO sankan_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","ಯಾವನ್ತಿ ದಿನಾನಿ ಜಗತ್ಯಸ್ಮಿನ್ ತೈಃ ಸಹಾಹಮಾಸಂ ತಾವನ್ತಿ ದಿನಾನಿ ತಾನ್ ತವ ನಾಮ್ನಾಹಂ ರಕ್ಷಿತವಾನ್; ಯಾಲ್ಲೋಕಾನ್ ಮಹ್ಯಮ್ ಅದದಾಸ್ತಾನ್ ಸರ್ವ್ವಾನ್ ಅಹಮರಕ್ಷಂ, ತೇಷಾಂ ಮಧ್ಯೇ ಕೇವಲಂ ವಿನಾಶಪಾತ್ರಂ ಹಾರಿತಂ ತೇನ ಧರ್ಮ್ಮಪುಸ್ತಕಸ್ಯ ವಚನಂ ಪ್ರತ್ಯಕ್ಷಂ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","ಕಿನ್ತ್ವಧುನಾ ತವ ಸನ್ನಿಧಿಂ ಗಚ್ಛಾಮಿ ಮಯಾ ಯಥಾ ತೇಷಾಂ ಸಮ್ಪೂರ್ಣಾನನ್ದೋ ಭವತಿ ತದರ್ಥಮಹಂ ಜಗತಿ ತಿಷ್ಠನ್ ಏತಾಃ ಕಥಾ ಅಕಥಯಮ್| ");
INSERT INTO sankan_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","ತವೋಪದೇಶಂ ತೇಭ್ಯೋಽದದಾಂ ಜಗತಾ ಸಹ ಯಥಾ ಮಮ ಸಮ್ಬನ್ಧೋ ನಾಸ್ತಿ ತಥಾ ಜಜತಾ ಸಹ ತೇಷಾಮಪಿ ಸಮ್ಬನ್ಧಾಭಾವಾಜ್ ಜಗತೋ ಲೋಕಾಸ್ತಾನ್ ಋತೀಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ತ್ವಂ ಜಗತಸ್ತಾನ್ ಗೃಹಾಣೇತಿ ನ ಪ್ರಾರ್ಥಯೇ ಕಿನ್ತ್ವಶುಭಾದ್ ರಕ್ಷೇತಿ ಪ್ರಾರ್ಥಯೇಹಮ್| ");
INSERT INTO sankan_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ಅಹಂ ಯಥಾ ಜಗತ್ಸಮ್ಬನ್ಧೀಯೋ ನ ಭವಾಮಿ ತಥಾ ತೇಪಿ ಜಗತ್ಸಮ್ಬನ್ಧೀಯಾ ನ ಭವನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","ತವ ಸತ್ಯಕಥಯಾ ತಾನ್ ಪವಿತ್ರೀಕುರು ತವ ವಾಕ್ಯಮೇವ ಸತ್ಯಂ| ");
INSERT INTO sankan_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ತ್ವಂ ಯಥಾ ಮಾಂ ಜಗತಿ ಪ್ರೈರಯಸ್ತಥಾಹಮಪಿ ತಾನ್ ಜಗತಿ ಪ್ರೈರಯಂ| ");
INSERT INTO sankan_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","ತೇಷಾಂ ಹಿತಾರ್ಥಂ ಯಥಾಹಂ ಸ್ವಂ ಪವಿತ್ರೀಕರೋಮಿ ತಥಾ ಸತ್ಯಕಥಯಾ ತೇಪಿ ಪವಿತ್ರೀಭವನ್ತು| ");
INSERT INTO sankan_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","ಕೇವಲಂ ಏತೇಷಾಮರ್ಥೇ ಪ್ರಾರ್ಥಯೇಽಹಮ್ ಇತಿ ನ ಕಿನ್ತ್ವೇತೇಷಾಮುಪದೇಶೇನ ಯೇ ಜನಾ ಮಯಿ ವಿಶ್ವಸಿಷ್ಯನ್ತಿ ತೇಷಾಮಪ್ಯರ್ಥೇ ಪ್ರಾರ್ಥೇಯೇಽಹಮ್| ");
INSERT INTO sankan_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ಹೇ ಪಿತಸ್ತೇಷಾಂ ಸರ್ವ್ವೇಷಾಮ್ ಏಕತ್ವಂ ಭವತು ತವ ಯಥಾ ಮಯಿ ಮಮ ಚ ಯಥಾ ತ್ವಯ್ಯೇಕತ್ವಂ ತಥಾ ತೇಷಾಮಪ್ಯಾವಯೋರೇಕತ್ವಂ ಭವತು ತೇನ ತ್ವಂ ಮಾಂ ಪ್ರೇರಿತವಾನ್ ಇತಿ ಜಗತೋ ಲೋಕಾಃ ಪ್ರತಿಯನ್ತು| ");
INSERT INTO sankan_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","ಯಥಾವಯೋರೇಕತ್ವಂ ತಥಾ ತೇಷಾಮಪ್ಯೇಕತ್ವಂ ಭವತು ತೇಷ್ವಹಂ ಮಯಿ ಚ ತ್ವಮ್ ಇತ್ಥಂ ತೇಷಾಂ ಸಮ್ಪೂರ್ಣಮೇಕತ್ವಂ ಭವತು, ತ್ವಂ ಪ್ರೇರಿತವಾನ್ ತ್ವಂ ಮಯಿ ಯಥಾ ಪ್ರೀಯಸೇ ಚ ತಥಾ ತೇಷ್ವಪಿ ಪ್ರೀತವಾನ್ ಏತದ್ಯಥಾ ಜಗತೋ ಲೋಕಾ ಜಾನನ್ತಿ ");
INSERT INTO sankan_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ತದರ್ಥಂ ತ್ವಂ ಯಂ ಮಹಿಮಾನಂ ಮಹ್ಯಮ್ ಅದದಾಸ್ತಂ ಮಹಿಮಾನಮ್ ಅಹಮಪಿ ತೇಭ್ಯೋ ದತ್ತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","ಹೇ ಪಿತ ರ್ಜಗತೋ ನಿರ್ಮ್ಮಾಣಾತ್ ಪೂರ್ವ್ವಂ ಮಯಿ ಸ್ನೇಹಂ ಕೃತ್ವಾ ಯಂ ಮಹಿಮಾನಂ ದತ್ತವಾನ್ ಮಮ ತಂ ಮಹಿಮಾನಂ ಯಥಾ ತೇ ಪಶ್ಯನ್ತಿ ತದರ್ಥಂ ಯಾಲ್ಲೋಕಾನ್ ಮಹ್ಯಂ ದತ್ತವಾನ್ ಅಹಂ ಯತ್ರ ತಿಷ್ಠಾಮಿ ತೇಪಿ ಯಥಾ ತತ್ರ ತಿಷ್ಠನ್ತಿ ಮಮೈಷಾ ವಾಞ್ಛಾ| ");
INSERT INTO sankan_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ಹೇ ಯಥಾರ್ಥಿಕ ಪಿತ ರ್ಜಗತೋ ಲೋಕೈಸ್ತ್ವಯ್ಯಜ್ಞಾತೇಪಿ ತ್ವಾಮಹಂ ಜಾನೇ ತ್ವಂ ಮಾಂ ಪ್ರೇರಿತವಾನ್ ಇತೀಮೇ ಶಿಷ್ಯಾ ಜಾನನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","ಯಥಾಹಂ ತೇಷು ತಿಷ್ಠಾಮಿ ತಥಾ ಮಯಿ ಯೇನ ಪ್ರೇಮ್ನಾ ಪ್ರೇಮಾಕರೋಸ್ತತ್ ತೇಷು ತಿಷ್ಠತಿ ತದರ್ಥಂ ತವ ನಾಮಾಹಂ ತಾನ್ ಜ್ಞಾಪಿತವಾನ್ ಪುನರಪಿ ಜ್ಞಾಪಯಿಷ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","ತಾಃ ಕಥಾಃ ಕಥಯಿತ್ವಾ ಯೀಶುಃ ಶಿಷ್ಯಾನಾದಾಯ ಕಿದ್ರೋನ್ನಾಮಕಂ ಸ್ರೋತ ಉತ್ತೀರ್ಯ್ಯ ಶಿಷ್ಯೈಃ ಸಹ ತತ್ರತ್ಯೋದ್ಯಾನಂ ಪ್ರಾವಿಶತ್| ");
INSERT INTO sankan_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","ಕಿನ್ತು ವಿಶ್ವಾಸಘಾತಿಯಿಹೂದಾಸ್ತತ್ ಸ್ಥಾನಂ ಪರಿಚೀಯತೇ ಯತೋ ಯೀಶುಃ ಶಿಷ್ಯೈಃ ಸಾರ್ದ್ಧಂ ಕದಾಚಿತ್ ತತ್ ಸ್ಥಾನಮ್ ಅಗಚ್ಛತ್| ");
INSERT INTO sankan_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ತದಾ ಸ ಯಿಹೂದಾಃ ಸೈನ್ಯಗಣಂ ಪ್ರಧಾನಯಾಜಕಾನಾಂ ಫಿರೂಶಿನಾಞ್ಚ ಪದಾತಿಗಣಞ್ಚ ಗೃಹೀತ್ವಾ ಪ್ರದೀಪಾನ್ ಉಲ್ಕಾನ್ ಅಸ್ತ್ರಾಣಿ ಚಾದಾಯ ತಸ್ಮಿನ್ ಸ್ಥಾನ ಉಪಸ್ಥಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","ಸ್ವಂ ಪ್ರತಿ ಯದ್ ಘಟಿಷ್ಯತೇ ತಜ್ ಜ್ಞಾತ್ವಾ ಯೀಶುರಗ್ರೇಸರಃ ಸನ್ ತಾನಪೃಚ್ಛತ್ ಕಂ ಗವೇಷಯಥ? ");
INSERT INTO sankan_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","ತೇ ಪ್ರತ್ಯವದನ್, ನಾಸರತೀಯಂ ಯೀಶುಂ; ತತೋ ಯೀಶುರವಾದೀದ್ ಅಹಮೇವ ಸಃ; ತೈಃ ಸಹ ವಿಶ್ವಾಸಘಾತೀ ಯಿಹೂದಾಶ್ಚಾತಿಷ್ಠತ್| ");
INSERT INTO sankan_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ತದಾಹಮೇವ ಸ ತಸ್ಯೈತಾಂ ಕಥಾಂ ಶ್ರುತ್ವೈವ ತೇ ಪಶ್ಚಾದೇತ್ಯ ಭೂಮೌ ಪತಿತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","ತತೋ ಯೀಶುಃ ಪುನರಪಿ ಪೃಷ್ಠವಾನ್ ಕಂ ಗವೇಷಯಥ? ತತಸ್ತೇ ಪ್ರತ್ಯವದನ್ ನಾಸರತೀಯಂ ಯೀಶುಂ| ");
INSERT INTO sankan_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ತದಾ ಯೀಶುಃ ಪ್ರತ್ಯುದಿತವಾನ್ ಅಹಮೇವ ಸ ಇಮಾಂ ಕಥಾಮಚಕಥಮ್; ಯದಿ ಮಾಮನ್ವಿಚ್ಛಥ ತರ್ಹೀಮಾನ್ ಗನ್ತುಂ ಮಾ ವಾರಯತ| ");
INSERT INTO sankan_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ಇತ್ಥಂ ಭೂತೇ ಮಹ್ಯಂ ಯಾಲ್ಲೋಕಾನ್ ಅದದಾಸ್ತೇಷಾಮ್ ಏಕಮಪಿ ನಾಹಾರಯಮ್ ಇಮಾಂ ಯಾಂ ಕಥಾಂ ಸ ಸ್ವಯಮಕಥಯತ್ ಸಾ ಕಥಾ ಸಫಲಾ ಜಾತಾ| ");
INSERT INTO sankan_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","ತದಾ ಶಿಮೋನ್ಪಿತರಸ್ಯ ನಿಕಟೇ ಖಙ್ಗಲ್ಸ್ಥಿತೇಃ ಸ ತಂ ನಿಷ್ಕೋಷಂ ಕೃತ್ವಾ ಮಹಾಯಾಜಕಸ್ಯ ಮಾಲ್ಖನಾಮಾನಂ ದಾಸಮ್ ಆಹತ್ಯ ತಸ್ಯ ದಕ್ಷಿಣಕರ್ಣಂ ಛಿನ್ನವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ತತೋ ಯೀಶುಃ ಪಿತರಮ್ ಅವದತ್, ಖಙ್ಗಂ ಕೋಷೇ ಸ್ಥಾಪಯ ಮಮ ಪಿತಾ ಮಹ್ಯಂ ಪಾತುಂ ಯಂ ಕಂಸಮ್ ಅದದಾತ್ ತೇನಾಹಂ ಕಿಂ ನ ಪಾಸ್ಯಾಮಿ? ");
INSERT INTO sankan_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","ತದಾ ಸೈನ್ಯಗಣಃ ಸೇನಾಪತಿ ರ್ಯಿಹೂದೀಯಾನಾಂ ಪದಾತಯಶ್ಚ ಯೀಶುಂ ಘೃತ್ವಾ ಬದ್ಧ್ವಾ ಹಾನನ್ನಾಮ್ನಃ ಕಿಯಫಾಃ ಶ್ವಶುರಸ್ಯ ಸಮೀಪಂ ಪ್ರಥಮಮ್ ಅನಯನ್| ");
INSERT INTO sankan_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ಸ ಕಿಯಫಾಸ್ತಸ್ಮಿನ್ ವತ್ಸರೇ ಮಹಾಯಾಜತ್ವಪದೇ ನಿಯುಕ್ತಃ ");
INSERT INTO sankan_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ಸನ್ ಸಾಧಾರಣಲೋಕಾನಾಂ ಮಙ್ಗಲಾರ್ಥಮ್ ಏಕಜನಸ್ಯ ಮರಣಮುಚಿತಮ್ ಇತಿ ಯಿಹೂದೀಯೈಃ ಸಾರ್ದ್ಧಮ್ ಅಮನ್ತ್ರಯತ್| ");
INSERT INTO sankan_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","ತದಾ ಶಿಮೋನ್ಪಿತರೋಽನ್ಯೈಕಶಿಷ್ಯಶ್ಚ ಯೀಶೋಃ ಪಶ್ಚಾದ್ ಅಗಚ್ಛತಾಂ ತಸ್ಯಾನ್ಯಶಿಷ್ಯಸ್ಯ ಮಹಾಯಾಜಕೇನ ಪರಿಚಿತತ್ವಾತ್ ಸ ಯೀಶುನಾ ಸಹ ಮಹಾಯಾಜಕಸ್ಯಾಟ್ಟಾಲಿಕಾಂ ಪ್ರಾವಿಶತ್| ");
INSERT INTO sankan_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ಕಿನ್ತು ಪಿತರೋ ಬಹಿರ್ದ್ವಾರಸ್ಯ ಸಮೀಪೇಽತಿಷ್ಠದ್ ಅತಏವ ಮಹಾಯಾಜಕೇನ ಪರಿಚಿತಃ ಸ ಶಿಷ್ಯಃ ಪುನರ್ಬಹಿರ್ಗತ್ವಾ ದೌವಾಯಿಕಾಯೈ ಕಥಯಿತ್ವಾ ಪಿತರಮ್ ಅಭ್ಯನ್ತರಮ್ ಆನಯತ್| ");
INSERT INTO sankan_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ತದಾ ಸ ದ್ವಾರರಕ್ಷಿಕಾ ಪಿತರಮ್ ಅವದತ್ ತ್ವಂ ಕಿಂ ನ ತಸ್ಯ ಮಾನವಸ್ಯ ಶಿಷ್ಯಃ? ತತಃ ಸೋವದದ್ ಅಹಂ ನ ಭವಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ತತಃ ಪರಂ ಯತ್ಸ್ಥಾನೇ ದಾಸಾಃ ಪದಾತಯಶ್ಚ ಶೀತಹೇತೋರಙ್ಗಾರೈ ರ್ವಹ್ನಿಂ ಪ್ರಜ್ವಾಲ್ಯ ತಾಪಂ ಸೇವಿತವನ್ತಸ್ತತ್ಸ್ಥಾನೇ ಪಿತರಸ್ತಿಷ್ಠನ್ ತೈಃ ಸಹ ವಹ್ನಿತಾಪಂ ಸೇವಿತುಮ್ ಆರಭತ| ");
INSERT INTO sankan_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","ತದಾ ಶಿಷ್ಯೇಷೂಪದೇಶೇ ಚ ಮಹಾಯಾಜಕೇನ ಯೀಶುಃ ಪೃಷ್ಟಃ ");
INSERT INTO sankan_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","ಸನ್ ಪ್ರತ್ಯುಕ್ತವಾನ್ ಸರ್ವ್ವಲೋಕಾನಾಂ ಸಮಕ್ಷಂ ಕಥಾಮಕಥಯಂ ಗುಪ್ತಂ ಕಾಮಪಿ ಕಥಾಂ ನ ಕಥಯಿತ್ವಾ ಯತ್ ಸ್ಥಾನಂ ಯಿಹೂದೀಯಾಃ ಸತತಂ ಗಚ್ಛನ್ತಿ ತತ್ರ ಭಜನಗೇಹೇ ಮನ್ದಿರೇ ಚಾಶಿಕ್ಷಯಂ| ");
INSERT INTO sankan_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","ಮತ್ತಃ ಕುತಃ ಪೃಚ್ಛಸಿ? ಯೇ ಜನಾ ಮದುಪದೇಶಮ್ ಅಶೃಣ್ವನ್ ತಾನೇವ ಪೃಚ್ಛ ಯದ್ಯದ್ ಅವದಂ ತೇ ತತ್ ಜಾನಿನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","ತದೇತ್ಥಂ ಪ್ರತ್ಯುದಿತತ್ವಾತ್ ನಿಕಟಸ್ಥಪದಾತಿ ರ್ಯೀಶುಂ ಚಪೇಟೇನಾಹತ್ಯ ವ್ಯಾಹರತ್ ಮಹಾಯಾಜಕಮ್ ಏವಂ ಪ್ರತಿವದಸಿ? ");
INSERT INTO sankan_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ತತೋ ಯೀಶುಃ ಪ್ರತಿಗದಿತವಾನ್ ಯದ್ಯಯಥಾರ್ಥಮ್ ಅಚಕಥಂ ತರ್ಹಿ ತಸ್ಯಾಯಥಾರ್ಥಸ್ಯ ಪ್ರಮಾಣಂ ದೇಹಿ, ಕಿನ್ತು ಯದಿ ಯಥಾರ್ಥಂ ತರ್ಹಿ ಕುತೋ ಹೇತೋ ರ್ಮಾಮ್ ಅತಾಡಯಃ? ");
INSERT INTO sankan_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","ಪೂರ್ವ್ವಂ ಹಾನನ್ ಸಬನ್ಧನಂ ತಂ ಕಿಯಫಾಮಹಾಯಾಜಕಸ್ಯ ಸಮೀಪಂ ಪ್ರೈಷಯತ್| ");
INSERT INTO sankan_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ಶಿಮೋನ್ಪಿತರಸ್ತಿಷ್ಠನ್ ವಹ್ನಿತಾಪಂ ಸೇವತೇ, ಏತಸ್ಮಿನ್ ಸಮಯೇ ಕಿಯನ್ತಸ್ತಮ್ ಅಪೃಚ್ಛನ್ ತ್ವಂ ಕಿಮ್ ಏತಸ್ಯ ಜನಸ್ಯ ಶಿಷ್ಯೋ ನ? ತತಃ ಸೋಪಹ್ನುತ್ಯಾಬ್ರವೀದ್ ಅಹಂ ನ ಭವಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","ತದಾ ಮಹಾಯಾಜಕಸ್ಯ ಯಸ್ಯ ದಾಸಸ್ಯ ಪಿತರಃ ಕರ್ಣಮಚ್ಛಿನತ್ ತಸ್ಯ ಕುಟುಮ್ಬಃ ಪ್ರತ್ಯುದಿತವಾನ್ ಉದ್ಯಾನೇ ತೇನ ಸಹ ತಿಷ್ಠನ್ತಂ ತ್ವಾಂ ಕಿಂ ನಾಪಶ್ಯಂ? ");
INSERT INTO sankan_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","ಕಿನ್ತು ಪಿತರಃ ಪುನರಪಹ್ನುತ್ಯ ಕಥಿತವಾನ್; ತದಾನೀಂ ಕುಕ್ಕುಟೋಽರೌತ್| ");
INSERT INTO sankan_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","ತದನನ್ತರಂ ಪ್ರತ್ಯೂಷೇ ತೇ ಕಿಯಫಾಗೃಹಾದ್ ಅಧಿಪತೇ ರ್ಗೃಹಂ ಯೀಶುಮ್ ಅನಯನ್ ಕಿನ್ತು ಯಸ್ಮಿನ್ ಅಶುಚಿತ್ವೇ ಜಾತೇ ತೈ ರ್ನಿಸ್ತಾರೋತ್ಸವೇ ನ ಭೋಕ್ತವ್ಯಂ, ತಸ್ಯ ಭಯಾದ್ ಯಿಹೂದೀಯಾಸ್ತದ್ಗೃಹಂ ನಾವಿಶನ್| ");
INSERT INTO sankan_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","ಅಪರಂ ಪೀಲಾತೋ ಬಹಿರಾಗತ್ಯ ತಾನ್ ಪೃಷ್ಠವಾನ್ ಏತಸ್ಯ ಮನುಷ್ಯಸ್ಯ ಕಂ ದೋಷಂ ವದಥ? ");
INSERT INTO sankan_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ತದಾ ತೇ ಪೇತ್ಯವದನ್ ದುಷ್ಕರ್ಮ್ಮಕಾರಿಣಿ ನ ಸತಿ ಭವತಃ ಸಮೀಪೇ ನೈನಂ ಸಮಾರ್ಪಯಿಷ್ಯಾಮಃ| ");
INSERT INTO sankan_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ತತಃ ಪೀಲಾತೋಽವದದ್ ಯೂಯಮೇನಂ ಗೃಹೀತ್ವಾ ಸ್ವೇಷಾಂ ವ್ಯವಸ್ಥಯಾ ವಿಚಾರಯತ| ತದಾ ಯಿಹೂದೀಯಾಃ ಪ್ರತ್ಯವದನ್ ಕಸ್ಯಾಪಿ ಮನುಷ್ಯಸ್ಯ ಪ್ರಾಣದಣ್ಡಂ ಕರ್ತ್ತುಂ ನಾಸ್ಮಾಕಮ್ ಅಧಿಕಾರೋಽಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ಏವಂ ಸತಿ ಯೀಶುಃ ಸ್ವಸ್ಯ ಮೃತ್ಯೌ ಯಾಂ ಕಥಾಂ ಕಥಿತವಾನ್ ಸಾ ಸಫಲಾಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","ತದನನ್ತರಂ ಪೀಲಾತಃ ಪುನರಪಿ ತದ್ ರಾಜಗೃಹಂ ಗತ್ವಾ ಯೀಶುಮಾಹೂಯ ಪೃಷ್ಟವಾನ್ ತ್ವಂ ಕಿಂ ಯಿಹೂದೀಯಾನಾಂ ರಾಜಾ? ");
INSERT INTO sankan_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","ಯೀಶುಃ ಪ್ರತ್ಯವದತ್ ತ್ವಮ್ ಏತಾಂ ಕಥಾಂ ಸ್ವತಃ ಕಥಯಸಿ ಕಿಮನ್ಯಃ ಕಶ್ಚಿನ್ ಮಯಿ ಕಥಿತವಾನ್? ");
INSERT INTO sankan_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ಪೀಲಾತೋಽವದದ್ ಅಹಂ ಕಿಂ ಯಿಹೂದೀಯಃ? ತವ ಸ್ವದೇಶೀಯಾ ವಿಶೇಷತಃ ಪ್ರಧಾನಯಾಜಕಾ ಮಮ ನಿಕಟೇ ತ್ವಾಂ ಸಮಾರ್ಪಯನ, ತ್ವಂ ಕಿಂ ಕೃತವಾನ್? ");
INSERT INTO sankan_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","ಯೀಶುಃ ಪ್ರತ್ಯವದತ್ ಮಮ ರಾಜ್ಯಮ್ ಏತಜ್ಜಗತ್ಸಮ್ಬನ್ಧೀಯಂ ನ ಭವತಿ ಯದಿ ಮಮ ರಾಜ್ಯಂ ಜಗತ್ಸಮ್ಬನ್ಧೀಯಮ್ ಅಭವಿಷ್ಯತ್ ತರ್ಹಿ ಯಿಹೂದೀಯಾನಾಂ ಹಸ್ತೇಷು ಯಥಾ ಸಮರ್ಪಿತೋ ನಾಭವಂ ತದರ್ಥಂ ಮಮ ಸೇವಕಾ ಅಯೋತ್ಸ್ಯನ್ ಕಿನ್ತು ಮಮ ರಾಜ್ಯಮ್ ಐಹಿಕಂ ನ| ");
INSERT INTO sankan_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","ತದಾ ಪೀಲಾತಃ ಕಥಿತವಾನ್, ತರ್ಹಿ ತ್ವಂ ರಾಜಾ ಭವಸಿ? ಯೀಶುಃ ಪ್ರತ್ಯುಕ್ತವಾನ್ ತ್ವಂ ಸತ್ಯಂ ಕಥಯಸಿ, ರಾಜಾಹಂ ಭವಾಮಿ; ಸತ್ಯತಾಯಾಂ ಸಾಕ್ಷ್ಯಂ ದಾತುಂ ಜನಿಂ ಗೃಹೀತ್ವಾ ಜಗತ್ಯಸ್ಮಿನ್ ಅವತೀರ್ಣವಾನ್, ತಸ್ಮಾತ್ ಸತ್ಯಧರ್ಮ್ಮಪಕ್ಷಪಾತಿನೋ ಮಮ ಕಥಾಂ ಶೃಣ್ವನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","ತದಾ ಸತ್ಯಂ ಕಿಂ? ಏತಾಂ ಕಥಾಂ ಪಷ್ಟ್ವಾ ಪೀಲಾತಃ ಪುನರಪಿ ಬಹಿರ್ಗತ್ವಾ ಯಿಹೂದೀಯಾನ್ ಅಭಾಷತ, ಅಹಂ ತಸ್ಯ ಕಮಪ್ಯಪರಾಧಂ ನ ಪ್ರಾಪ್ನೋಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","ನಿಸ್ತಾರೋತ್ಸವಸಮಯೇ ಯುಷ್ಮಾಭಿರಭಿರುಚಿತ ಏಕೋ ಜನೋ ಮಯಾ ಮೋಚಯಿತವ್ಯ ಏಷಾ ಯುಷ್ಮಾಕಂ ರೀತಿರಸ್ತಿ, ಅತಏವ ಯುಷ್ಮಾಕಂ ನಿಕಟೇ ಯಿಹೂದೀಯಾನಾಂ ರಾಜಾನಂ ಕಿಂ ಮೋಚಯಾಮಿ, ಯುಷ್ಮಾಕಮ್ ಇಚ್ಛಾ ಕಾ? ");
INSERT INTO sankan_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","ತದಾ ತೇ ಸರ್ವ್ವೇ ರುವನ್ತೋ ವ್ಯಾಹರನ್ ಏನಂ ಮಾನುಷಂ ನಹಿ ಬರಬ್ಬಾಂ ಮೋಚಯ| ಕಿನ್ತು ಸ ಬರಬ್ಬಾ ದಸ್ಯುರಾಸೀತ್| ");
INSERT INTO sankan_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","ಪೀಲಾತೋ ಯೀಶುಮ್ ಆನೀಯ ಕಶಯಾ ಪ್ರಾಹಾರಯತ್| ");
INSERT INTO sankan_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ಪಶ್ಚಾತ್ ಸೇನಾಗಣಃ ಕಣ್ಟಕನಿರ್ಮ್ಮಿತಂ ಮುಕುಟಂ ತಸ್ಯ ಮಸ್ತಕೇ ಸಮರ್ಪ್ಯ ವಾರ್ತ್ತಾಕೀವರ್ಣಂ ರಾಜಪರಿಚ್ಛದಂ ಪರಿಧಾಪ್ಯ, ");
INSERT INTO sankan_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ಹೇ ಯಿಹೂದೀಯಾನಾಂ ರಾಜನ್ ನಮಸ್ಕಾರ ಇತ್ಯುಕ್ತ್ವಾ ತಂ ಚಪೇಟೇನಾಹನ್ತುಮ್ ಆರಭತ| ");
INSERT INTO sankan_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","ತದಾ ಪೀಲಾತಃ ಪುನರಪಿ ಬಹಿರ್ಗತ್ವಾ ಲೋಕಾನ್ ಅವದತ್, ಅಸ್ಯ ಕಮಪ್ಯಪರಾಧಂ ನ ಲಭೇಽಹಂ, ಪಶ್ಯತ ತದ್ ಯುಷ್ಮಾನ್ ಜ್ಞಾಪಯಿತುಂ ಯುಷ್ಮಾಕಂ ಸನ್ನಿಧೌ ಬಹಿರೇನಮ್ ಆನಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","ತತಃ ಪರಂ ಯೀಶುಃ ಕಣ್ಟಕಮುಕುಟವಾನ್ ವಾರ್ತ್ತಾಕೀವರ್ಣವಸನವಾಂಶ್ಚ ಬಹಿರಾಗಚ್ಛತ್| ತತಃ ಪೀಲಾತ ಉಕ್ತವಾನ್ ಏನಂ ಮನುಷ್ಯಂ ಪಶ್ಯತ| ");
INSERT INTO sankan_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ತದಾ ಪ್ರಧಾನಯಾಜಕಾಃ ಪದಾತಯಶ್ಚ ತಂ ದೃಷ್ಟ್ವಾ, ಏನಂ ಕ್ರುಶೇ ವಿಧ, ಏನಂ ಕ್ರುಶೇ ವಿಧ, ಇತ್ಯುಕ್ತ್ವಾ ರವಿತುಂ ಆರಭನ್ತ| ತತಃ ಪೀಲಾತಃ ಕಥಿತವಾನ್ ಯೂಯಂ ಸ್ವಯಮ್ ಏನಂ ನೀತ್ವಾ ಕ್ರುಶೇ ವಿಧತ, ಅಹಮ್ ಏತಸ್ಯ ಕಮಪ್ಯಪರಾಧಂ ನ ಪ್ರಾಪ್ತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","ಯಿಹೂದೀಯಾಃ ಪ್ರತ್ಯವದನ್ ಅಸ್ಮಾಕಂ ಯಾ ವ್ಯವಸ್ಥಾಸ್ತೇ ತದನುಸಾರೇಣಾಸ್ಯ ಪ್ರಾಣಹನನಮ್ ಉಚಿತಂ ಯತೋಯಂ ಸ್ವಮ್ ಈಶ್ವರಸ್ಯ ಪುತ್ರಮವದತ್| ");
INSERT INTO sankan_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ಪೀಲಾತ ಇಮಾಂ ಕಥಾಂ ಶ್ರುತ್ವಾ ಮಹಾತ್ರಾಸಯುಕ್ತಃ ");
INSERT INTO sankan_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ಸನ್ ಪುನರಪಿ ರಾಜಗೃಹ ಆಗತ್ಯ ಯೀಶುಂ ಪೃಷ್ಟವಾನ್ ತ್ವಂ ಕುತ್ರತ್ಯೋ ಲೋಕಃ? ಕಿನ್ತು ಯೀಶಸ್ತಸ್ಯ ಕಿಮಪಿ ಪ್ರತ್ಯುತ್ತರಂ ನಾವದತ್| ");
INSERT INTO sankan_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","೧॰ ತತಃ ಪೀಲಾತ್ ಕಥಿತವಾನ ತ್ವಂ ಕಿಂ ಮಯಾ ಸಾರ್ದ್ಧಂ ನ ಸಂಲಪಿಷ್ಯಸಿ ? ತ್ವಾಂ ಕ್ರುಶೇ ವೇಧಿತುಂ ವಾ ಮೋಚಯಿತುಂ ಶಕ್ತಿ ರ್ಮಮಾಸ್ತೇ ಇತಿ ಕಿಂ ತ್ವಂ ನ ಜಾನಾಸಿ ? ತದಾ ಯೀಶುಃ ಪ್ರತ್ಯವದದ್ ಈಶ್ವರೇಣಾದŸाಂ ಮಮೋಪರಿ ತವ ಕಿಮಪ್ಯಧಿಪತಿತ್ವಂ ನ ವಿದ್ಯತೇ, ತಥಾಪಿ ಯೋ ಜನೋ ಮಾಂ ತವ ಹಸ್ತೇ ಸಮಾರ್ಪಯತ್ ತಸ್ಯ ಮಹಾಪಾತಕಂ ಜಾತಮ್| ");
INSERT INTO sankan_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ತದಾ ಯೀಶುಃ ಪ್ರತ್ಯವದದ್ ಈಶ್ವರೇಣಾದತ್ತಂ ಮಮೋಪರಿ ತವ ಕಿಮಪ್ಯಧಿಪತಿತ್ವಂ ನ ವಿದ್ಯತೇ, ತಥಾಪಿ ಯೋ ಜನೋ ಮಾಂ ತವ ಹಸ್ತೇ ಸಮಾರ್ಪಯತ್ ತಸ್ಯ ಮಹಾಪಾತಕಂ ಜಾತಮ್| ");
INSERT INTO sankan_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ತದಾರಭ್ಯ ಪೀಲಾತಸ್ತಂ ಮೋಚಯಿತುಂ ಚೇಷ್ಟಿತವಾನ್ ಕಿನ್ತು ಯಿಹೂದೀಯಾ ರುವನ್ತೋ ವ್ಯಾಹರನ್ ಯದೀಮಂ ಮಾನವಂ ತ್ಯಜಸಿ ತರ್ಹಿ ತ್ವಂ ಕೈಸರಸ್ಯ ಮಿತ್ರಂ ನ ಭವಸಿ, ಯೋ ಜನಃ ಸ್ವಂ ರಾಜಾನಂ ವಕ್ತಿ ಸಏವ ಕೈಮರಸ್ಯ ವಿರುದ್ಧಾಂ ಕಥಾಂ ಕಥಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ಏತಾಂ ಕಥಾಂ ಶ್ರುತ್ವಾ ಪೀಲಾತೋ ಯೀಶುಂ ಬಹಿರಾನೀಯ ನಿಸ್ತಾರೋತ್ಸವಸ್ಯ ಆಸಾದನದಿನಸ್ಯ ದ್ವಿತೀಯಪ್ರಹರಾತ್ ಪೂರ್ವ್ವಂ ಪ್ರಸ್ತರಬನ್ಧನನಾಮ್ನಿ ಸ್ಥಾನೇ ಽರ್ಥಾತ್ ಇಬ್ರೀಯಭಾಷಯಾ ಯದ್ ಗಬ್ಬಿಥಾ ಕಥ್ಯತೇ ತಸ್ಮಿನ್ ಸ್ಥಾನೇ ವಿಚಾರಾಸನ ಉಪಾವಿಶತ್| ");
INSERT INTO sankan_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ಅನನ್ತರಂ ಪೀಲಾತೋ ಯಿಹೂದೀಯಾನ್ ಅವದತ್, ಯುಷ್ಮಾಕಂ ರಾಜಾನಂ ಪಶ್ಯತ| ");
INSERT INTO sankan_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","ಕಿನ್ತು ಏನಂ ದೂರೀಕುರು, ಏನಂ ದೂರೀಕುರು, ಏನಂ ಕ್ರುಶೇ ವಿಧ, ಇತಿ ಕಥಾಂ ಕಥಯಿತ್ವಾ ತೇ ರವಿತುಮ್ ಆರಭನ್ತ; ತದಾ ಪೀಲಾತಃ ಕಥಿತವಾನ್ ಯುಷ್ಮಾಕಂ ರಾಜಾನಂ ಕಿಂ ಕ್ರುಶೇ ವೇಧಿಷ್ಯಾಮಿ? ಪ್ರಧಾನಯಾಜಕಾ ಉತ್ತರಮ್ ಅವದನ್ ಕೈಸರಂ ವಿನಾ ಕೋಪಿ ರಾಜಾಸ್ಮಾಕಂ ನಾಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","ತತಃ ಪೀಲಾತೋ ಯೀಶುಂ ಕ್ರುಶೇ ವೇಧಿತುಂ ತೇಷಾಂ ಹಸ್ತೇಷು ಸಮಾರ್ಪಯತ್, ತತಸ್ತೇ ತಂ ಧೃತ್ವಾ ನೀತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ತತಃ ಪರಂ ಯೀಶುಃ ಕ್ರುಶಂ ವಹನ್ ಶಿರಃಕಪಾಲಮ್ ಅರ್ಥಾದ್ ಯದ್ ಇಬ್ರೀಯಭಾಷಯಾ ಗುಲ್ಗಲ್ತಾಂ ವದನ್ತಿ ತಸ್ಮಿನ್ ಸ್ಥಾನ ಉಪಸ್ಥಿತಃ| ");
INSERT INTO sankan_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ತತಸ್ತೇ ಮಧ್ಯಸ್ಥಾನೇ ತಂ ತಸ್ಯೋಭಯಪಾರ್ಶ್ವೇ ದ್ವಾವಪರೌ ಕ್ರುಶೇಽವಿಧನ್| ");
INSERT INTO sankan_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","ಅಪರಮ್ ಏಷ ಯಿಹೂದೀಯಾನಾಂ ರಾಜಾ ನಾಸರತೀಯಯೀಶುಃ, ಇತಿ ವಿಜ್ಞಾಪನಂ ಲಿಖಿತ್ವಾ ಪೀಲಾತಸ್ತಸ್ಯ ಕ್ರುಶೋಪರಿ ಸಮಯೋಜಯತ್| ");
INSERT INTO sankan_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","ಸಾ ಲಿಪಿಃ ಇಬ್ರೀಯಯೂನಾನೀಯರೋಮೀಯಭಾಷಾಭಿ ರ್ಲಿಖಿತಾ; ಯೀಶೋಃ ಕ್ರುಶವೇಧನಸ್ಥಾನಂ ನಗರಸ್ಯ ಸಮೀಪಂ, ತಸ್ಮಾದ್ ಬಹವೋ ಯಿಹೂದೀಯಾಸ್ತಾಂ ಪಠಿತುಮ್ ಆರಭನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","ಯಿಹೂದೀಯಾನಾಂ ಪ್ರಧಾನಯಾಜಕಾಃ ಪೀಲಾತಮಿತಿ ನ್ಯವೇದಯನ್ ಯಿಹೂದೀಯಾನಾಂ ರಾಜೇತಿ ವಾಕ್ಯಂ ನ ಕಿನ್ತು ಏಷ ಸ್ವಂ ಯಿಹೂದೀಯಾನಾಂ ರಾಜಾನಮ್ ಅವದದ್ ಇತ್ಥಂ ಲಿಖತು| ");
INSERT INTO sankan_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ತತಃ ಪೀಲಾತ ಉತ್ತರಂ ದತ್ತವಾನ್ ಯಲ್ಲೇಖನೀಯಂ ತಲ್ಲಿಖಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ಇತ್ಥಂ ಸೇನಾಗಣೋ ಯೀಶುಂ ಕ್ರುಶೇ ವಿಧಿತ್ವಾ ತಸ್ಯ ಪರಿಧೇಯವಸ್ತ್ರಂ ಚತುರೋ ಭಾಗಾನ್ ಕೃತ್ವಾ ಏಕೈಕಸೇನಾ ಏಕೈಕಭಾಗಮ್ ಅಗೃಹ್ಲತ್ ತಸ್ಯೋತ್ತರೀಯವಸ್ತ್ರಞ್ಚಾಗೃಹ್ಲತ್| ಕಿನ್ತೂತ್ತರೀಯವಸ್ತ್ರಂ ಸೂಚಿಸೇವನಂ ವಿನಾ ಸರ್ವ್ವಮ್ ಊತಂ| ");
INSERT INTO sankan_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ತಸ್ಮಾತ್ತೇ ವ್ಯಾಹರನ್ ಏತತ್ ಕಃ ಪ್ರಾಪ್ಸ್ಯತಿ? ತನ್ನ ಖಣ್ಡಯಿತ್ವಾ ತತ್ರ ಗುಟಿಕಾಪಾತಂ ಕರವಾಮ| ವಿಭಜನ್ತೇಽಧರೀಯಂ ಮೇ ವಸನಂ ತೇ ಪರಸ್ಪರಂ| ಮಮೋತ್ತರೀಯವಸ್ತ್ರಾರ್ಥಂ ಗುಟಿಕಾಂ ಪಾತಯನ್ತಿ ಚ| ಇತಿ ಯದ್ವಾಕ್ಯಂ ಧರ್ಮ್ಮಪುಸ್ತಕೇ ಲಿಖಿತಮಾಸ್ತೇ ತತ್ ಸೇನಾಗಣೇನೇತ್ಥಂ ವ್ಯವಹರಣಾತ್ ಸಿದ್ಧಮಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ತದಾನೀಂ ಯೀಶೋ ರ್ಮಾತಾ ಮಾತು ರ್ಭಗಿನೀ ಚ ಯಾ ಕ್ಲಿಯಪಾ ಭಾರ್ಯ್ಯಾ ಮರಿಯಮ್ ಮಗ್ದಲೀನೀ ಮರಿಯಮ್ ಚ ಏತಾಸ್ತಸ್ಯ ಕ್ರುಶಸ್ಯ ಸನ್ನಿಧೌ ಸಮತಿಷ್ಠನ್| ");
INSERT INTO sankan_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ತತೋ ಯೀಶುಃ ಸ್ವಮಾತರಂ ಪ್ರಿಯತಮಶಿಷ್ಯಞ್ಚ ಸಮೀಪೇ ದಣ್ಡಾಯಮಾನೌ ವಿಲೋಕ್ಯ ಮಾತರಮ್ ಅವದತ್, ಹೇ ಯೋಷಿದ್ ಏನಂ ತವ ಪುತ್ರಂ ಪಶ್ಯ, ");
INSERT INTO sankan_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ಶಿಷ್ಯನ್ತ್ವವದತ್, ಏನಾಂ ತವ ಮಾತರಂ ಪಶ್ಯ| ತತಃ ಸ ಶಿಷ್ಯಸ್ತದ್ಘಟಿಕಾಯಾಂ ತಾಂ ನಿಜಗೃಹಂ ನೀತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","ಅನನ್ತರಂ ಸರ್ವ್ವಂ ಕರ್ಮ್ಮಾಧುನಾ ಸಮ್ಪನ್ನಮಭೂತ್ ಯೀಶುರಿತಿ ಜ್ಞಾತ್ವಾ ಧರ್ಮ್ಮಪುಸ್ತಕಸ್ಯ ವಚನಂ ಯಥಾ ಸಿದ್ಧಂ ಭವತಿ ತದರ್ಥಮ್ ಅಕಥಯತ್ ಮಮ ಪಿಪಾಸಾ ಜಾತಾ| ");
INSERT INTO sankan_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ತತಸ್ತಸ್ಮಿನ್ ಸ್ಥಾನೇ ಅಮ್ಲರಸೇನ ಪೂರ್ಣಪಾತ್ರಸ್ಥಿತ್ಯಾ ತೇ ಸ್ಪಞ್ಜಮೇಕಂ ತದಮ್ಲರಸೇನಾರ್ದ್ರೀಕೃತ್ಯ ಏಸೋಬ್ನಲೇ ತದ್ ಯೋಜಯಿತ್ವಾ ತಸ್ಯ ಮುಖಸ್ಯ ಸನ್ನಿಧಾವಸ್ಥಾಪಯನ್| ");
INSERT INTO sankan_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ತದಾ ಯೀಶುರಮ್ಲರಸಂ ಗೃಹೀತ್ವಾ ಸರ್ವ್ವಂ ಸಿದ್ಧಮ್ ಇತಿ ಕಥಾಂ ಕಥಯಿತ್ವಾ ಮಸ್ತಕಂ ನಮಯನ್ ಪ್ರಾಣಾನ್ ಪರ್ಯ್ಯತ್ಯಜತ್| ");
INSERT INTO sankan_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","ತದ್ವಿನಮ್ ಆಸಾದನದಿನಂ ತಸ್ಮಾತ್ ಪರೇಽಹನಿ ವಿಶ್ರಾಮವಾರೇ ದೇಹಾ ಯಥಾ ಕ್ರುಶೋಪರಿ ನ ತಿಷ್ಠನ್ತಿ, ಯತಃ ಸ ವಿಶ್ರಾಮವಾರೋ ಮಹಾದಿನಮಾಸೀತ್, ತಸ್ಮಾದ್ ಯಿಹೂದೀಯಾಃ ಪೀಲಾತನಿಕಟಂ ಗತ್ವಾ ತೇಷಾಂ ಪಾದಭಞ್ಜನಸ್ಯ ಸ್ಥಾನಾನ್ತರನಯನಸ್ಯ ಚಾನುಮತಿಂ ಪ್ರಾರ್ಥಯನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ಅತಃ ಸೇನಾ ಆಗತ್ಯ ಯೀಶುನಾ ಸಹ ಕ್ರುಶೇ ಹತಯೋಃ ಪ್ರಥಮದ್ವಿತೀಯಚೋರಯೋಃ ಪಾದಾನ್ ಅಭಞ್ಜನ್; ");
INSERT INTO sankan_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ಕಿನ್ತು ಯೀಶೋಃ ಸನ್ನಿಧಿಂ ಗತ್ವಾ ಸ ಮೃತ ಇತಿ ದೃಷ್ಟ್ವಾ ತಸ್ಯ ಪಾದೌ ನಾಭಞ್ಜನ್| ");
INSERT INTO sankan_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","ಪಶ್ಚಾದ್ ಏಕೋ ಯೋದ್ಧಾ ಶೂಲಾಘಾತೇನ ತಸ್ಯ ಕುಕ್ಷಿಮ್ ಅವಿಧತ್ ತತ್ಕ್ಷಣಾತ್ ತಸ್ಮಾದ್ ರಕ್ತಂ ಜಲಞ್ಚ ನಿರಗಚ್ಛತ್| ");
INSERT INTO sankan_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","ಯೋ ಜನೋಽಸ್ಯ ಸಾಕ್ಷ್ಯಂ ದದಾತಿ ಸ ಸ್ವಯಂ ದೃಷ್ಟವಾನ್ ತಸ್ಯೇದಂ ಸಾಕ್ಷ್ಯಂ ಸತ್ಯಂ ತಸ್ಯ ಕಥಾ ಯುಷ್ಮಾಕಂ ವಿಶ್ವಾಸಂ ಜನಯಿತುಂ ಯೋಗ್ಯಾ ತತ್ ಸ ಜಾನಾತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","ತಸ್ಯೈಕಮ್ ಅಸ್ಧ್ಯಪಿ ನ ಭಂಕ್ಷ್ಯತೇ, ");
INSERT INTO sankan_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ತದ್ವದ್ ಅನ್ಯಶಾಸ್ತ್ರೇಪಿ ಲಿಖ್ಯತೇ, ಯಥಾ, \"ದೃಷ್ಟಿಪಾತಂ ಕರಿಷ್ಯನ್ತಿ ತೇಽವಿಧನ್ ಯನ್ತು ತಮ್ಪ್ರತಿ| \" ");
INSERT INTO sankan_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","ಅರಿಮಥೀಯನಗರಸ್ಯ ಯೂಷಫ್ನಾಮಾ ಶಿಷ್ಯ ಏಕ ಆಸೀತ್ ಕಿನ್ತು ಯಿಹೂದೀಯೇಭ್ಯೋ ಭಯಾತ್ ಪ್ರಕಾಶಿತೋ ನ ಭವತಿ; ಸ ಯೀಶೋ ರ್ದೇಹಂ ನೇತುಂ ಪೀಲಾತಸ್ಯಾನುಮತಿಂ ಪ್ರಾರ್ಥಯತ, ತತಃ ಪೀಲಾತೇನಾನುಮತೇ ಸತಿ ಸ ಗತ್ವಾ ಯೀಶೋ ರ್ದೇಹಮ್ ಅನಯತ್| ");
INSERT INTO sankan_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ಅಪರಂ ಯೋ ನಿಕದೀಮೋ ರಾತ್ರೌ ಯೀಶೋಃ ಸಮೀಪಮ್ ಅಗಚ್ಛತ್ ಸೋಪಿ ಗನ್ಧರಸೇನ ಮಿಶ್ರಿತಂ ಪ್ರಾಯೇಣ ಪಞ್ಚಾಶತ್ಸೇಟಕಮಗುರುಂ ಗೃಹೀತ್ವಾಗಚ್ಛತ್| ");
INSERT INTO sankan_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ತತಸ್ತೇ ಯಿಹೂದೀಯಾನಾಂ ಶ್ಮಶಾನೇ ಸ್ಥಾಪನರೀತ್ಯನುಸಾರೇಣ ತತ್ಸುಗನ್ಧಿದ್ರವ್ಯೇಣ ಸಹಿತಂ ತಸ್ಯ ದೇಹಂ ವಸ್ತ್ರೇಣಾವೇಷ್ಟಯನ್| ");
INSERT INTO sankan_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","ಅಪರಞ್ಚ ಯತ್ರ ಸ್ಥಾನೇ ತಂ ಕ್ರುಶೇಽವಿಧನ್ ತಸ್ಯ ನಿಕಟಸ್ಥೋದ್ಯಾನೇ ಯತ್ರ ಕಿಮಪಿ ಮೃತದೇಹಂ ಕದಾಪಿ ನಾಸ್ಥಾಪ್ಯತ ತಾದೃಶಮ್ ಏಕಂ ನೂತನಂ ಶ್ಮಶಾನಮ್ ಆಸೀತ್| ");
INSERT INTO sankan_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","ಯಿಹೂದೀಯಾನಾಮ್ ಆಸಾದನದಿನಾಗಮನಾತ್ ತೇ ತಸ್ಮಿನ್ ಸಮೀಪಸ್ಥಶ್ಮಶಾನೇ ಯೀಶುಮ್ ಅಶಾಯಯನ್| ");
INSERT INTO sankan_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","ಅನನ್ತರಂ ಸಪ್ತಾಹಸ್ಯ ಪ್ರಥಮದಿನೇ ಽತಿಪ್ರತ್ಯೂಷೇ ಽನ್ಧಕಾರೇ ತಿಷ್ಠತಿ ಮಗ್ದಲೀನೀ ಮರಿಯಮ್ ತಸ್ಯ ಶ್ಮಶಾನಸ್ಯ ನಿಕಟಂ ಗತ್ವಾ ಶ್ಮಶಾನಸ್ಯ ಮುಖಾತ್ ಪ್ರಸ್ತರಮಪಸಾರಿತಮ್ ಅಪಶ್ಯತ್| ");
INSERT INTO sankan_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","ಪಶ್ಚಾದ್ ಧಾವಿತ್ವಾ ಶಿಮೋನ್ಪಿತರಾಯ ಯೀಶೋಃ ಪ್ರಿಯತಮಶಿಷ್ಯಾಯ ಚೇದಮ್ ಅಕಥಯತ್, ಲೋಕಾಃ ಶ್ಮಶಾನಾತ್ ಪ್ರಭುಂ ನೀತ್ವಾ ಕುತ್ರಾಸ್ಥಾಪಯನ್ ತದ್ ವಕ್ತುಂ ನ ಶಕ್ನೋಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","ಅತಃ ಪಿತರಃ ಸೋನ್ಯಶಿಷ್ಯಶ್ಚ ಬರ್ಹಿ ರ್ಭುತ್ವಾ ಶ್ಮಶಾನಸ್ಥಾನಂ ಗನ್ತುಮ್ ಆರಭೇತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ಉಭಯೋರ್ಧಾವತೋಃ ಸೋನ್ಯಶಿಷ್ಯಃ ಪಿತರಂ ಪಶ್ಚಾತ್ ತ್ಯಕ್ತ್ವಾ ಪೂರ್ವ್ವಂ ಶ್ಮಶಾನಸ್ಥಾನ ಉಪಸ್ಥಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ತದಾ ಪ್ರಹ್ವೀಭೂಯ ಸ್ಥಾಪಿತವಸ್ತ್ರಾಣಿ ದೃಷ್ಟವಾನ್ ಕಿನ್ತು ನ ಪ್ರಾವಿಶತ್| ");
INSERT INTO sankan_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","ಅಪರಂ ಶಿಮೋನ್ಪಿತರ ಆಗತ್ಯ ಶ್ಮಶಾನಸ್ಥಾನಂ ಪ್ರವಿಶ್ಯ ");
INSERT INTO sankan_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ಸ್ಥಾಪಿತವಸ್ತ್ರಾಣಿ ಮಸ್ತಕಸ್ಯ ವಸ್ತ್ರಞ್ಚ ಪೃಥಕ್ ಸ್ಥಾನಾನ್ತರೇ ಸ್ಥಾಪಿತಂ ದೃಷ್ಟವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","ತತಃ ಶ್ಮಶಾನಸ್ಥಾನಂ ಪೂರ್ವ್ವಮ್ ಆಗತೋ ಯೋನ್ಯಶಿಷ್ಯಃ ಸೋಪಿ ಪ್ರವಿಶ್ಯ ತಾದೃಶಂ ದೃಷ್ಟಾ ವ್ಯಶ್ವಸೀತ್| ");
INSERT INTO sankan_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","ಯತಃ ಶ್ಮಶಾನಾತ್ ಸ ಉತ್ಥಾಪಯಿತವ್ಯ ಏತಸ್ಯ ಧರ್ಮ್ಮಪುಸ್ತಕವಚನಸ್ಯ ಭಾವಂ ತೇ ತದಾ ವೋದ್ಧುಂ ನಾಶನ್ಕುವನ್| ");
INSERT INTO sankan_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","ಅನನ್ತರಂ ತೌ ದ್ವೌ ಶಿಷ್ಯೌ ಸ್ವಂ ಸ್ವಂ ಗೃಹಂ ಪರಾವೃತ್ಯಾಗಚ್ಛತಾಮ್| ");
INSERT INTO sankan_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","ತತಃ ಪರಂ ಮರಿಯಮ್ ಶ್ಮಶಾನದ್ವಾರಸ್ಯ ಬಹಿಃ ಸ್ಥಿತ್ವಾ ರೋದಿತುಮ್ ಆರಭತ ತತೋ ರುದತೀ ಪ್ರಹ್ವೀಭೂಯ ಶ್ಮಶಾನಂ ವಿಲೋಕ್ಯ ");
INSERT INTO sankan_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ಯೀಶೋಃ ಶಯನಸ್ಥಾನಸ್ಯ ಶಿರಃಸ್ಥಾನೇ ಪದತಲೇ ಚ ದ್ವಯೋ ರ್ದಿಶೋ ದ್ವೌ ಸ್ವರ್ಗೀಯದೂತಾವುಪವಿಷ್ಟೌ ಸಮಪಶ್ಯತ್| ");
INSERT INTO sankan_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","ತೌ ಪೃಷ್ಟವನ್ತೌ ಹೇ ನಾರಿ ಕುತೋ ರೋದಿಷಿ? ಸಾವದತ್ ಲೋಕಾ ಮಮ ಪ್ರಭುಂ ನೀತ್ವಾ ಕುತ್ರಾಸ್ಥಾಪಯನ್ ಇತಿ ನ ಜಾನಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ಇತ್ಯುಕ್ತ್ವಾ ಮುಖಂ ಪರಾವೃತ್ಯ ಯೀಶುಂ ದಣ್ಡಾಯಮಾನಮ್ ಅಪಶ್ಯತ್ ಕಿನ್ತು ಸ ಯೀಶುರಿತಿ ಸಾ ಜ್ಞಾತುಂ ನಾಶಕ್ನೋತ್| ");
INSERT INTO sankan_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","ತದಾ ಯೀಶುಸ್ತಾಮ್ ಅಪೃಚ್ಛತ್ ಹೇ ನಾರಿ ಕುತೋ ರೋದಿಷಿ? ಕಂ ವಾ ಮೃಗಯಸೇ? ತತಃ ಸಾ ತಮ್ ಉದ್ಯಾನಸೇವಕಂ ಜ್ಞಾತ್ವಾ ವ್ಯಾಹರತ್, ಹೇ ಮಹೇಚ್ಛ ತ್ವಂ ಯದೀತಃ ಸ್ಥಾನಾತ್ ತಂ ನೀತವಾನ್ ತರ್ಹಿ ಕುತ್ರಾಸ್ಥಾಪಯಸ್ತದ್ ವದ ತತ್ಸ್ಥಾನಾತ್ ತಮ್ ಆನಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","ತದಾ ಯೀಶುಸ್ತಾಮ್ ಅವದತ್ ಹೇ ಮರಿಯಮ್| ತತಃ ಸಾ ಪರಾವೃತ್ಯ ಪ್ರತ್ಯವದತ್ ಹೇ ರಬ್ಬೂನೀ ಅರ್ಥಾತ್ ಹೇ ಗುರೋ| ");
INSERT INTO sankan_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","ತದಾ ಯೀಶುರವದತ್ ಮಾಂ ಮಾ ಧರ, ಇದಾನೀಂ ಪಿತುಃ ಸಮೀಪೇ ಊರ್ದ್ಧ್ವಗಮನಂ ನ ಕರೋಮಿ ಕಿನ್ತು ಯೋ ಮಮ ಯುಷ್ಮಾಕಞ್ಚ ಪಿತಾ ಮಮ ಯುಷ್ಮಾಕಞ್ಚೇಶ್ವರಸ್ತಸ್ಯ ನಿಕಟ ಊರ್ದ್ಧ್ವಗಮನಂ ಕರ್ತ್ತುಮ್ ಉದ್ಯತೋಸ್ಮಿ, ಇಮಾಂ ಕಥಾಂ ತ್ವಂ ಗತ್ವಾ ಮಮ ಭ್ರಾತೃಗಣಂ ಜ್ಞಾಪಯ| ");
INSERT INTO sankan_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","ತತೋ ಮಗ್ದಲೀನೀಮರಿಯಮ್ ತತ್ಕ್ಷಣಾದ್ ಗತ್ವಾ ಪ್ರಭುಸ್ತಸ್ಯೈ ದರ್ಶನಂ ದತ್ತ್ವಾ ಕಥಾ ಏತಾ ಅಕಥಯದ್ ಇತಿ ವಾರ್ತ್ತಾಂ ಶಿಷ್ಯೇಭ್ಯೋಽಕಥಯತ್| ");
INSERT INTO sankan_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ತತಃ ಪರಂ ಸಪ್ತಾಹಸ್ಯ ಪ್ರಥಮದಿನಸ್ಯ ಸನ್ಧ್ಯಾಸಮಯೇ ಶಿಷ್ಯಾ ಏಕತ್ರ ಮಿಲಿತ್ವಾ ಯಿಹೂದೀಯೇಭ್ಯೋ ಭಿಯಾ ದ್ವಾರರುದ್ಧಮ್ ಅಕುರ್ವ್ವನ್, ಏತಸ್ಮಿನ್ ಕಾಲೇ ಯೀಶುಸ್ತೇಷಾಂ ಮಧ್ಯಸ್ಥಾನೇ ತಿಷ್ಠನ್ ಅಕಥಯದ್ ಯುಷ್ಮಾಕಂ ಕಲ್ಯಾಣಂ ಭೂಯಾತ್| ");
INSERT INTO sankan_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ಇತ್ಯುಕ್ತ್ವಾ ನಿಜಹಸ್ತಂ ಕುಕ್ಷಿಞ್ಚ ದರ್ಶಿತವಾನ್, ತತಃ ಶಿಷ್ಯಾಃ ಪ್ರಭುಂ ದೃಷ್ಟ್ವಾ ಹೃಷ್ಟಾ ಅಭವನ್| ");
INSERT INTO sankan_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ಯೀಶುಃ ಪುನರವದದ್ ಯುಷ್ಮಾಕಂ ಕಲ್ಯಾಣಂ ಭೂಯಾತ್ ಪಿತಾ ಯಥಾ ಮಾಂ ಪ್ರೈಷಯತ್ ತಥಾಹಮಪಿ ಯುಷ್ಮಾನ್ ಪ್ರೇಷಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ಇತ್ಯುಕ್ತ್ವಾ ಸ ತೇಷಾಮುಪರಿ ದೀರ್ಘಪ್ರಶ್ವಾಸಂ ದತ್ತ್ವಾ ಕಥಿತವಾನ್ ಪವಿತ್ರಮ್ ಆತ್ಮಾನಂ ಗೃಹ್ಲೀತ| ");
INSERT INTO sankan_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","ಯೂಯಂ ಯೇಷಾಂ ಪಾಪಾನಿ ಮೋಚಯಿಷ್ಯಥ ತೇ ಮೋಚಯಿಷ್ಯನ್ತೇ ಯೇಷಾಞ್ಚ ಪಾಪಾತಿ ನ ಮೋಚಯಿಷ್ಯಥ ತೇ ನ ಮೋಚಯಿಷ್ಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","ದ್ವಾದಶಮಧ್ಯೇ ಗಣಿತೋ ಯಮಜೋ ಥೋಮಾನಾಮಾ ಶಿಷ್ಯೋ ಯೀಶೋರಾಗಮನಕಾಲೈ ತೈಃ ಸಾರ್ದ್ಧಂ ನಾಸೀತ್| ");
INSERT INTO sankan_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","ಅತೋ ವಯಂ ಪ್ರಭೂಮ್ ಅಪಶ್ಯಾಮೇತಿ ವಾಕ್ಯೇಽನ್ಯಶಿಷ್ಯೈರುಕ್ತೇ ಸೋವದತ್, ತಸ್ಯ ಹಸ್ತಯೋ ರ್ಲೌಹಕೀಲಕಾನಾಂ ಚಿಹ್ನಂ ನ ವಿಲೋಕ್ಯ ತಚ್ಚಿಹ್ನಮ್ ಅಙ್ಗುಲ್ಯಾ ನ ಸ್ಪೃಷ್ಟ್ವಾ ತಸ್ಯ ಕುಕ್ಷೌ ಹಸ್ತಂ ನಾರೋಪ್ಯ ಚಾಹಂ ನ ವಿಶ್ವಸಿಷ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","ಅಪರಮ್ ಅಷ್ಟಮೇಽಹ್ನಿ ಗತೇ ಸತಿ ಥೋಮಾಸಹಿತಃ ಶಿಷ್ಯಗಣ ಏಕತ್ರ ಮಿಲಿತ್ವಾ ದ್ವಾರಂ ರುದ್ಧ್ವಾಭ್ಯನ್ತರ ಆಸೀತ್, ಏತರ್ಹಿ ಯೀಶುಸ್ತೇಷಾಂ ಮಧ್ಯಸ್ಥಾನೇ ತಿಷ್ಠನ್ ಅಕಥಯತ್, ಯುಷ್ಮಾಕಂ ಕುಶಲಂ ಭೂಯಾತ್| ");
INSERT INTO sankan_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","ಪಶ್ಚಾತ್ ಥಾಮೈ ಕಥಿತವಾನ್ ತ್ವಮ್ ಅಙ್ಗುಲೀಮ್ ಅತ್ರಾರ್ಪಯಿತ್ವಾ ಮಮ ಕರೌ ಪಶ್ಯ ಕರಂ ಪ್ರಸಾರ್ಯ್ಯ ಮಮ ಕುಕ್ಷಾವರ್ಪಯ ನಾವಿಶ್ವಸ್ಯ| ");
INSERT INTO sankan_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ತದಾ ಥೋಮಾ ಅವದತ್, ಹೇ ಮಮ ಪ್ರಭೋ ಹೇ ಮದೀಶ್ವರ| ");
INSERT INTO sankan_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","ಯೀಶುರಕಥಯತ್, ಹೇ ಥೋಮಾ ಮಾಂ ನಿರೀಕ್ಷ್ಯ ವಿಶ್ವಸಿಷಿ ಯೇ ನ ದೃಷ್ಟ್ವಾ ವಿಶ್ವಸನ್ತಿ ತಏವ ಧನ್ಯಾಃ| ");
INSERT INTO sankan_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ಏತದನ್ಯಾನಿ ಪುಸ್ತಕೇಽಸ್ಮಿನ್ ಅಲಿಖಿತಾನಿ ಬಹೂನ್ಯಾಶ್ಚರ್ಯ್ಯಕರ್ಮ್ಮಾಣಿ ಯೀಶುಃ ಶಿಷ್ಯಾಣಾಂ ಪುರಸ್ತಾದ್ ಅಕರೋತ್| ");
INSERT INTO sankan_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ಕಿನ್ತು ಯೀಶುರೀಶ್ವರಸ್ಯಾಭಿಷಿಕ್ತಃ ಸುತ ಏವೇತಿ ಯಥಾ ಯೂಯಂ ವಿಶ್ವಸಿಥ ವಿಶ್ವಸ್ಯ ಚ ತಸ್ಯ ನಾಮ್ನಾ ಪರಮಾಯುಃ ಪ್ರಾಪ್ನುಥ ತದರ್ಥಮ್ ಏತಾನಿ ಸರ್ವ್ವಾಣ್ಯಲಿಖ್ಯನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","ತತಃ ಪರಂ ತಿಬಿರಿಯಾಜಲಧೇಸ್ತಟೇ ಯೀಶುಃ ಪುನರಪಿ ಶಿಷ್ಯೇಭ್ಯೋ ದರ್ಶನಂ ದತ್ತವಾನ್ ದರ್ಶನಸ್ಯಾಖ್ಯಾನಮಿದಮ್| ");
INSERT INTO sankan_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ಶಿಮೋನ್ಪಿತರಃ ಯಮಜಥೋಮಾ ಗಾಲೀಲೀಯಕಾನ್ನಾನಗರನಿವಾಸೀ ನಿಥನೇಲ್ ಸಿವದೇಃ ಪುತ್ರಾವನ್ಯೌ ದ್ವೌ ಶಿಷ್ಯೌ ಚೈತೇಷ್ವೇಕತ್ರ ಮಿಲಿತೇಷು ಶಿಮೋನ್ಪಿತರೋಽಕಥಯತ್ ಮತ್ಸ್ಯಾನ್ ಧರ್ತುಂ ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ತತಸ್ತೇ ವ್ಯಾಹರನ್ ತರ್ಹಿ ವಯಮಪಿ ತ್ವಯಾ ಸಾರ್ದ್ಧಂ ಯಾಮಃ ತದಾ ತೇ ಬಹಿರ್ಗತಾಃ ಸನ್ತಃ ಕ್ಷಿಪ್ರಂ ನಾವಮ್ ಆರೋಹನ್ ಕಿನ್ತು ತಸ್ಯಾಂ ರಜನ್ಯಾಮ್ ಏಕಮಪಿ ನ ಪ್ರಾಪ್ನುವನ್| ");
INSERT INTO sankan_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","ಪ್ರಭಾತೇ ಸತಿ ಯೀಶುಸ್ತಟೇ ಸ್ಥಿತವಾನ್ ಕಿನ್ತು ಸ ಯೀಶುರಿತಿ ಶಿಷ್ಯಾ ಜ್ಞಾತುಂ ನಾಶಕ್ನುವನ್| ");
INSERT INTO sankan_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","ತದಾ ಯೀಶುರಪೃಚ್ಛತ್, ಹೇ ವತ್ಸಾ ಸನ್ನಿಧೌ ಕಿಞ್ಚಿತ್ ಖಾದ್ಯದ್ರವ್ಯಮ್ ಆಸ್ತೇ? ತೇಽವದನ್ ಕಿಮಪಿ ನಾಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ತದಾ ಸೋಽವದತ್ ನೌಕಾಯಾ ದಕ್ಷಿಣಪಾರ್ಶ್ವೇ ಜಾಲಂ ನಿಕ್ಷಿಪತ ತತೋ ಲಪ್ಸ್ಯಧ್ವೇ, ತಸ್ಮಾತ್ ತೈ ರ್ನಿಕ್ಷಿಪ್ತೇ ಜಾಲೇ ಮತ್ಸ್ಯಾ ಏತಾವನ್ತೋಽಪತನ್ ಯೇನ ತೇ ಜಾಲಮಾಕೃಷ್ಯ ನೋತ್ತೋಲಯಿತುಂ ಶಕ್ತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","ತಸ್ಮಾದ್ ಯೀಶೋಃ ಪ್ರಿಯತಮಶಿಷ್ಯಃ ಪಿತರಾಯಾಕಥಯತ್ ಏಷ ಪ್ರಭು ರ್ಭವೇತ್, ಏಷ ಪ್ರಭುರಿತಿ ವಾಚಂ ಶ್ರುತ್ವೈವ ಶಿಮೋನ್ ನಗ್ನತಾಹೇತೋ ರ್ಮತ್ಸ್ಯಧಾರಿಣ ಉತ್ತರೀಯವಸ್ತ್ರಂ ಪರಿಧಾಯ ಹ್ರದಂ ಪ್ರತ್ಯುದಲಮ್ಫಯತ್| ");
INSERT INTO sankan_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","ಅಪರೇ ಶಿಷ್ಯಾ ಮತ್ಸ್ಯೈಃ ಸಾರ್ದ್ಧಂ ಜಾಲಮ್ ಆಕರ್ಷನ್ತಃ ಕ್ಷುದ್ರನೌಕಾಂ ವಾಹಯಿತ್ವಾ ಕೂಲಮಾನಯನ್ ತೇ ಕೂಲಾದ್ ಅತಿದೂರೇ ನಾಸನ್ ದ್ವಿಶತಹಸ್ತೇಭ್ಯೋ ದೂರ ಆಸನ್ ಇತ್ಯನುಮೀಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","ತೀರಂ ಪ್ರಾಪ್ತೈಸ್ತೈಸ್ತತ್ರ ಪ್ರಜ್ವಲಿತಾಗ್ನಿಸ್ತದುಪರಿ ಮತ್ಸ್ಯಾಃ ಪೂಪಾಶ್ಚ ದೃಷ್ಟಾಃ| ");
INSERT INTO sankan_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ತತೋ ಯೀಶುರಕಥಯದ್ ಯಾನ್ ಮತ್ಸ್ಯಾನ್ ಅಧರತ ತೇಷಾಂ ಕತಿಪಯಾನ್ ಆನಯತ| ");
INSERT INTO sankan_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ಅತಃ ಶಿಮೋನ್ಪಿತರಃ ಪರಾವೃತ್ಯ ಗತ್ವಾ ಬೃಹದ್ಭಿಸ್ತ್ರಿಪಞ್ಚಾಶದಧಿಕಶತಮತ್ಸ್ಯೈಃ ಪರಿಪೂರ್ಣಂ ತಜ್ಜಾಲಮ್ ಆಕೃಷ್ಯೋದತೋಲಯತ್ ಕಿನ್ತ್ವೇತಾವದ್ಭಿ ರ್ಮತ್ಸ್ಯೈರಪಿ ಜಾಲಂ ನಾಛಿದ್ಯತ| ");
INSERT INTO sankan_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","ಅನನ್ತರಂ ಯೀಶುಸ್ತಾನ್ ಅವಾದೀತ್ ಯೂಯಮಾಗತ್ಯ ಭುಂಗ್ಧ್ವಂ; ತದಾ ಸಏವ ಪ್ರಭುರಿತಿ ಜ್ಞಾತತ್ವಾತ್ ತ್ವಂ ಕಃ? ಇತಿ ಪ್ರಷ್ಟುಂ ಶಿಷ್ಯಾಣಾಂ ಕಸ್ಯಾಪಿ ಪ್ರಗಲ್ಭತಾ ನಾಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ತತೋ ಯೀಶುರಾಗತ್ಯ ಪೂಪಾನ್ ಮತ್ಸ್ಯಾಂಶ್ಚ ಗೃಹೀತ್ವಾ ತೇಭ್ಯಃ ಪರ್ಯ್ಯವೇಷಯತ್| ");
INSERT INTO sankan_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ಇತ್ಥಂ ಶ್ಮಶಾನಾದುತ್ಥಾನಾತ್ ಪರಂ ಯೀಶುಃ ಶಿಷ್ಯೇಭ್ಯಸ್ತೃತೀಯವಾರಂ ದರ್ಶನಂ ದತ್ತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ಭೋಜನೇ ಸಮಾಪ್ತೇ ಸತಿ ಯೀಶುಃ ಶಿಮೋನ್ಪಿತರಂ ಪೃಷ್ಟವಾನ್, ಹೇ ಯೂನಸಃ ಪುತ್ರ ಶಿಮೋನ್ ತ್ವಂ ಕಿಮ್ ಏತೇಭ್ಯೋಧಿಕಂ ಮಯಿ ಪ್ರೀಯಸೇ? ತತಃ ಸ ಉದಿತವಾನ್ ಸತ್ಯಂ ಪ್ರಭೋ ತ್ವಯಿ ಪ್ರೀಯೇಽಹಂ ತದ್ ಭವಾನ್ ಜಾನಾತಿ; ತದಾ ಯೀಶುರಕಥಯತ್ ತರ್ಹಿ ಮಮ ಮೇಷಶಾವಕಗಣಂ ಪಾಲಯ| ");
INSERT INTO sankan_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ತತಃ ಸ ದ್ವಿತೀಯವಾರಂ ಪೃಷ್ಟವಾನ್ ಹೇ ಯೂನಸಃ ಪುತ್ರ ಶಿಮೋನ್ ತ್ವಂ ಕಿಂ ಮಯಿ ಪ್ರೀಯಸೇ? ತತಃ ಸ ಉಕ್ತವಾನ್ ಸತ್ಯಂ ಪ್ರಭೋ ತ್ವಯಿ ಪ್ರೀಯೇಽಹಂ ತದ್ ಭವಾನ್ ಜಾನಾತಿ; ತದಾ ಯೀಶುರಕಥಯತ ತರ್ಹಿ ಮಮ ಮೇಷಗಣಂ ಪಾಲಯ| ");
INSERT INTO sankan_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ಪಶ್ಚಾತ್ ಸ ತೃತೀಯವಾರಂ ಪೃಷ್ಟವಾನ್, ಹೇ ಯೂನಸಃ ಪುತ್ರ ಶಿಮೋನ್ ತ್ವಂ ಕಿಂ ಮಯಿ ಪ್ರೀಯಸೇ? ಏತದ್ವಾಕ್ಯಂ ತೃತೀಯವಾರಂ ಪೃಷ್ಟವಾನ್ ತಸ್ಮಾತ್ ಪಿತರೋ ದುಃಖಿತೋ ಭೂತ್ವಾಽಕಥಯತ್ ಹೇ ಪ್ರಭೋ ಭವತಃ ಕಿಮಪ್ಯಗೋಚರಂ ನಾಸ್ತಿ ತ್ವಯ್ಯಹಂ ಪ್ರೀಯೇ ತದ್ ಭವಾನ್ ಜಾನಾತಿ; ತತೋ ಯೀಶುರವದತ್ ತರ್ಹಿ ಮಮ ಮೇಷಗಣಂ ಪಾಲಯ| ");
INSERT INTO sankan_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","ಅಹಂ ತುಭ್ಯಂ ಯಥಾರ್ಥಂ ಕಥಯಾಮಿ ಯೌವನಕಾಲೇ ಸ್ವಯಂ ಬದ್ಧಕಟಿ ರ್ಯತ್ರೇಚ್ಛಾ ತತ್ರ ಯಾತವಾನ್ ಕಿನ್ತ್ವಿತಃ ಪರಂ ವೃದ್ಧೇ ವಯಸಿ ಹಸ್ತಂ ವಿಸ್ತಾರಯಿಷ್ಯಸಿ, ಅನ್ಯಜನಸ್ತ್ವಾಂ ಬದ್ಧ್ವಾ ಯತ್ರ ಗನ್ತುಂ ತವೇಚ್ಛಾ ನ ಭವತಿ ತ್ವಾಂ ಧೃತ್ವಾ ತತ್ರ ನೇಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ಫಲತಃ ಕೀದೃಶೇನ ಮರಣೇನ ಸ ಈಶ್ವರಸ್ಯ ಮಹಿಮಾನಂ ಪ್ರಕಾಶಯಿಷ್ಯತಿ ತದ್ ಬೋಧಯಿತುಂ ಸ ಇತಿ ವಾಕ್ಯಂ ಪ್ರೋಕ್ತವಾನ್| ಇತ್ಯುಕ್ತೇ ಸತಿ ಸ ತಮವೋಚತ್ ಮಮ ಪಶ್ಚಾದ್ ಆಗಚ್ಛ| ");
INSERT INTO sankan_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","ಯೋ ಜನೋ ರಾತ್ರಿಕಾಲೇ ಯೀಶೋ ರ್ವಕ್ಷೋಽವಲಮ್ಬ್ಯ, ಹೇ ಪ್ರಭೋ ಕೋ ಭವನ್ತಂ ಪರಕರೇಷು ಸಮರ್ಪಯಿಷ್ಯತೀತಿ ವಾಕ್ಯಂ ಪೃಷ್ಟವಾನ್, ತಂ ಯೀಶೋಃ ಪ್ರಿಯತಮಶಿಷ್ಯಂ ಪಶ್ಚಾದ್ ಆಗಚ್ಛನ್ತಂ ");
INSERT INTO sankan_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ಪಿತರೋ ಮುಖಂ ಪರಾವರ್ತ್ತ್ಯ ವಿಲೋಕ್ಯ ಯೀಶುಂ ಪೃಷ್ಟವಾನ್, ಹೇ ಪ್ರಭೋ ಏತಸ್ಯ ಮಾನವಸ್ಯ ಕೀದೃಶೀ ಗತಿ ರ್ಭವಿಷ್ಯತಿ? ");
INSERT INTO sankan_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","ಸ ಪ್ರತ್ಯವದತ್, ಮಮ ಪುನರಾಗಮನಪರ್ಯ್ಯನ್ತಂ ಯದಿ ತಂ ಸ್ಥಾಪಯಿತುಮ್ ಇಚ್ಛಾಮಿ ತತ್ರ ತವ ಕಿಂ? ತ್ವಂ ಮಮ ಪಶ್ಚಾದ್ ಆಗಚ್ಛ| ");
INSERT INTO sankan_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","ತಸ್ಮಾತ್ ಸ ಶಿಷ್ಯೋ ನ ಮರಿಷ್ಯತೀತಿ ಭ್ರಾತೃಗಣಮಧ್ಯೇ ಕಿಂವದನ್ತೀ ಜಾತಾ ಕಿನ್ತು ಸ ನ ಮರಿಷ್ಯತೀತಿ ವಾಕ್ಯಂ ಯೀಶು ರ್ನಾವದತ್ ಕೇವಲಂ ಮಮ ಪುನರಾಗಮನಪರ್ಯ್ಯನ್ತಂ ಯದಿ ತಂ ಸ್ಥಾಪಯಿತುಮ್ ಇಚ್ಛಾಮಿ ತತ್ರ ತವ ಕಿಂ? ಇತಿ ವಾಕ್ಯಮ್ ಉಕ್ತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","ಯೋ ಜನ ಏತಾನಿ ಸರ್ವ್ವಾಣಿ ಲಿಖಿತವಾನ್ ಅತ್ರ ಸಾಕ್ಷ್ಯಞ್ಚ ದತ್ತವಾನ್ ಸಏವ ಸ ಶಿಷ್ಯಃ, ತಸ್ಯ ಸಾಕ್ಷ್ಯಂ ಪ್ರಮಾಣಮಿತಿ ವಯಂ ಜಾನೀಮಃ| ");
INSERT INTO sankan_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","ಯೀಶುರೇತೇಭ್ಯೋಽಪರಾಣ್ಯಪಿ ಬಹೂನಿ ಕರ್ಮ್ಮಾಣಿ ಕೃತವಾನ್ ತಾನಿ ಸರ್ವ್ವಾಣಿ ಯದ್ಯೇಕೈಕಂ ಕೃತ್ವಾ ಲಿಖ್ಯನ್ತೇ ತರ್ಹಿ ಗ್ರನ್ಥಾ ಏತಾವನ್ತೋ ಭವನ್ತಿ ತೇಷಾಂ ಧಾರಣೇ ಪೃಥಿವ್ಯಾಂ ಸ್ಥಾನಂ ನ ಭವತಿ| ಇತಿ||");
INSERT INTO sankan_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","ಹೇ ಥಿಯಫಿಲ, ಯೀಶುಃ ಸ್ವಮನೋನೀತಾನ್ ಪ್ರೇರಿತಾನ್ ಪವಿತ್ರೇಣಾತ್ಮನಾ ಸಮಾದಿಶ್ಯ ಯಸ್ಮಿನ್ ದಿನೇ ಸ್ವರ್ಗಮಾರೋಹತ್ ಯಾಂ ಯಾಂ ಕ್ರಿಯಾಮಕರೋತ್ ಯದ್ಯದ್ ಉಪಾದಿಶಚ್ಚ ತಾನಿ ಸರ್ವ್ವಾಣಿ ಪೂರ್ವ್ವಂ ಮಯಾ ಲಿಖಿತಾನಿ| ");
INSERT INTO sankan_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ಸ ಸ್ವನಿಧನದುಃಖಭೋಗಾತ್ ಪರಮ್ ಅನೇಕಪ್ರತ್ಯಯಕ್ಷಪ್ರಮಾಣೌಃ ಸ್ವಂ ಸಜೀವಂ ದರ್ಶಯಿತ್ವಾ ");
INSERT INTO sankan_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ಚತ್ವಾರಿಂಶದ್ದಿನಾನಿ ಯಾವತ್ ತೇಭ್ಯಃ ಪ್ರೇರಿತೇಭ್ಯೋ ದರ್ಶನಂ ದತ್ತ್ವೇಶ್ವರೀಯರಾಜ್ಯಸ್ಯ ವರ್ಣನಮ ಅಕರೋತ್| ");
INSERT INTO sankan_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","ಅನನ್ತರಂ ತೇಷಾಂ ಸಭಾಂ ಕೃತ್ವಾ ಇತ್ಯಾಜ್ಞಾಪಯತ್, ಯೂಯಂ ಯಿರೂಶಾಲಮೋಽನ್ಯತ್ರ ಗಮನಮಕೃತ್ವಾ ಯಸ್ತಿನ್ ಪಿತ್ರಾಙ್ಗೀಕೃತೇ ಮಮ ವದನಾತ್ ಕಥಾ ಅಶೃಣುತ ತತ್ಪ್ರಾಪ್ತಿಮ್ ಅಪೇಕ್ಷ್ಯ ತಿಷ್ಠತ| ");
INSERT INTO sankan_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","ಯೋಹನ್ ಜಲೇ ಮಜ್ಜಿತಾವಾನ್ ಕಿನ್ತ್ವಲ್ಪದಿನಮಧ್ಯೇ ಯೂಯಂ ಪವಿತ್ರ ಆತ್ಮನಿ ಮಜ್ಜಿತಾ ಭವಿಷ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","ಪಶ್ಚಾತ್ ತೇ ಸರ್ವ್ವೇ ಮಿಲಿತ್ವಾ ತಮ್ ಅಪೃಚ್ಛನ್ ಹೇ ಪ್ರಭೋ ಭವಾನ್ ಕಿಮಿದಾನೀಂ ಪುನರಪಿ ರಾಜ್ಯಮ್ ಇಸ್ರಾಯೇಲೀಯಲೋಕಾನಾಂ ಕರೇಷು ಸಮರ್ಪಯಿಷ್ಯತಿ? ");
INSERT INTO sankan_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ತತಃ ಸೋವದತ್ ಯಾನ್ ಸರ್ವ್ವಾನ್ ಕಾಲಾನ್ ಸಮಯಾಂಶ್ಚ ಪಿತಾ ಸ್ವವಶೇಽಸ್ಥಾಪಯತ್ ತಾನ್ ಜ್ಞಾತೃಂ ಯುಷ್ಮಾಕಮ್ ಅಧಿಕಾರೋ ನ ಜಾಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","ಕಿನ್ತು ಯುಷ್ಮಾಸು ಪವಿತ್ರಸ್ಯಾತ್ಮನ ಆವಿರ್ಭಾವೇ ಸತಿ ಯೂಯಂ ಶಕ್ತಿಂ ಪ್ರಾಪ್ಯ ಯಿರೂಶಾಲಮಿ ಸಮಸ್ತಯಿಹೂದಾಶೋಮಿರೋಣದೇಶಯೋಃ ಪೃಥಿವ್ಯಾಃ ಸೀಮಾಂ ಯಾವದ್ ಯಾವನ್ತೋ ದೇಶಾಸ್ತೇಷು ಯರ್ವ್ವೇಷು ಚ ಮಯಿ ಸಾಕ್ಷ್ಯಂ ದಾಸ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ಇತಿ ವಾಕ್ಯಮುಕ್ತ್ವಾ ಸ ತೇಷಾಂ ಸಮಕ್ಷಂ ಸ್ವರ್ಗಂ ನೀತೋಽಭವತ್, ತತೋ ಮೇಘಮಾರುಹ್ಯ ತೇಷಾಂ ದೃಷ್ಟೇರಗೋಚರೋಽಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ಯಸ್ಮಿನ್ ಸಮಯೇ ತೇ ವಿಹಾಯಸಂ ಪ್ರತ್ಯನನ್ಯದೃಷ್ಟ್ಯಾ ತಸ್ಯ ತಾದೃಶಮ್ ಊರ್ದ್ವ್ವಗಮನಮ್ ಅಪಶ್ಯನ್ ತಸ್ಮಿನ್ನೇವ ಸಮಯೇ ಶುಕ್ಲವಸ್ತ್ರೌ ದ್ವೌ ಜನೌ ತೇಷಾಂ ಸನ್ನಿಧೌ ದಣ್ಡಾಯಮಾನೌ ಕಥಿತವನ್ತೌ, ");
INSERT INTO sankan_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ಹೇ ಗಾಲೀಲೀಯಲೋಕಾ ಯೂಯಂ ಕಿಮರ್ಥಂ ಗಗಣಂ ಪ್ರತಿ ನಿರೀಕ್ಷ್ಯ ದಣ್ಡಾಯಮಾನಾಸ್ತಿಷ್ಠಥ? ಯುಷ್ಮಾಕಂ ಸಮೀಪಾತ್ ಸ್ವರ್ಗಂ ನೀತೋ ಯೋ ಯೀಶುಸ್ತಂ ಯೂಯಂ ಯಥಾ ಸ್ವರ್ಗಮ್ ಆರೋಹನ್ತಮ್ ಅದರ್ಶಮ್ ತಥಾ ಸ ಪುನಶ್ಚಾಗಮಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ತತಃ ಪರಂ ತೇ ಜೈತುನನಾಮ್ನಃ ಪರ್ವ್ವತಾದ್ ವಿಶ್ರಾಮವಾರಸ್ಯ ಪಥಃ ಪರಿಮಾಣಮ್ ಅರ್ಥಾತ್ ಪ್ರಾಯೇಣಾರ್ದ್ಧಕ್ರೋಶಂ ದುರಸ್ಥಂ ಯಿರೂಶಾಲಮ್ನಗರಂ ಪರಾವೃತ್ಯಾಗಚ್ಛನ್| ");
INSERT INTO sankan_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","ನಗರಂ ಪ್ರವಿಶ್ಯ ಪಿತರೋ ಯಾಕೂಬ್ ಯೋಹನ್ ಆನ್ದ್ರಿಯಃ ಫಿಲಿಪಃ ಥೋಮಾ ಬರ್ಥಜಮಯೋ ಮಥಿರಾಲ್ಫೀಯಪುತ್ರೋ ಯಾಕೂಬ್ ಉದ್ಯೋಗಾी ಶಿಮೋನ್ ಯಾಕೂಬೋ ಭ್ರಾತಾ ಯಿಹೂದಾ ಏತೇ ಸರ್ವ್ವೇ ಯತ್ರ ಸ್ಥಾನೇ ಪ್ರವಸನ್ತಿ ತಸ್ಮಿನ್ ಉಪರಿತನಪ್ರಕೋಷ್ಠೇ ಪ್ರಾವಿಶನ್| ");
INSERT INTO sankan_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ಪಶ್ಚಾದ್ ಇಮೇ ಕಿಯತ್ಯಃ ಸ್ತ್ರಿಯಶ್ಚ ಯೀಶೋ ರ್ಮಾತಾ ಮರಿಯಮ್ ತಸ್ಯ ಭ್ರಾತರಶ್ಚೈತೇ ಸರ್ವ್ವ ಏಕಚಿತ್ತೀಭೂತ ಸತತಂ ವಿನಯೇನ ವಿನಯೇನ ಪ್ರಾರ್ಥಯನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","ತಸ್ಮಿನ್ ಸಮಯೇ ತತ್ರ ಸ್ಥಾನೇ ಸಾಕಲ್ಯೇನ ವಿಂಶತ್ಯಧಿಕಶತಂ ಶಿಷ್ಯಾ ಆಸನ್| ತತಃ ಪಿತರಸ್ತೇಷಾಂ ಮಧ್ಯೇ ತಿಷ್ಠನ್ ಉಕ್ತವಾನ್ ");
INSERT INTO sankan_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","ಹೇ ಭ್ರಾತೃಗಣ ಯೀಶುಧಾರಿಣಾಂ ಲೋಕಾನಾಂ ಪಥದರ್ಶಕೋ ಯೋ ಯಿಹೂದಾಸ್ತಸ್ಮಿನ್ ದಾಯೂದಾ ಪವಿತ್ರ ಆತ್ಮಾ ಯಾಂ ಕಥಾಂ ಕಥಯಾಮಾಸ ತಸ್ಯಾಃ ಪ್ರತ್ಯಕ್ಷೀಭವನಸ್ಯಾವಶ್ಯಕತ್ವಮ್ ಆಸೀತ್| ");
INSERT INTO sankan_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ಸ ಜನೋಽಸ್ಮಾಕಂ ಮಧ್ಯವರ್ತ್ತೀ ಸನ್ ಅಸ್ಯಾಃ ಸೇವಾಯಾ ಅಂಶಮ್ ಅಲಭತ| ");
INSERT INTO sankan_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","ತದನನ್ತರಂ ಕುಕರ್ಮ್ಮಣಾ ಲಬ್ಧಂ ಯನ್ಮೂಲ್ಯಂ ತೇನ ಕ್ಷೇತ್ರಮೇಕಂ ಕ್ರೀತಮ್ ಅಪರಂ ತಸ್ಮಿನ್ ಅಧೋಮುಖೇ ಭೃಮೌ ಪತಿತೇ ಸತಿ ತಸ್ಯೋದರಸ್ಯ ವಿದೀರ್ಣತ್ವಾತ್ ಸರ್ವ್ವಾ ನಾಡ್ಯೋ ನಿರಗಚ್ಛನ್| ");
INSERT INTO sankan_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ಏತಾಂ ಕಥಾಂ ಯಿರೂಶಾಲಮ್ನಿವಾಸಿನಃ ಸರ್ವ್ವೇ ಲೋಕಾ ವಿದಾನ್ತಿ; ತೇಷಾಂ ನಿಜಭಾಷಯಾ ತತ್ಕ್ಷೇತ್ರಞ್ಚ ಹಕಲ್ದಾಮಾ, ಅರ್ಥಾತ್ ರಕ್ತಕ್ಷೇತ್ರಮಿತಿ ವಿಖ್ಯಾತಮಾಸ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","ಅನ್ಯಚ್ಚ, ನಿಕೇತನಂ ತದೀಯನ್ತು ಶುನ್ಯಮೇವ ಭವಿಷ್ಯತಿ| ತಸ್ಯ ದೂಷ್ಯೇ ನಿವಾಸಾರ್ಥಂ ಕೋಪಿ ಸ್ಥಾಸ್ಯತಿ ನೈವ ಹಿ| ಅನ್ಯ ಏವ ಜನಸ್ತಸ್ಯ ಪದಂ ಸಂಪ್ರಾಪ್ಸ್ಯತಿ ಧ್ರುವಂ| ಇತ್ಥಂ ಗೀತಪುಸ್ತಕೇ ಲಿಖಿತಮಾಸ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","ಅತೋ ಯೋಹನೋ ಮಜ್ಜನಮ್ ಆರಭ್ಯಾಸ್ಮಾಕಂ ಸಮೀಪಾತ್ ಪ್ರಭೋ ರ್ಯೀಶೋಃ ಸ್ವರ್ಗಾರೋಹಣದಿನಂ ಯಾವತ್ ಸೋಸ್ಮಾಕಂ ಮಧ್ಯೇ ಯಾವನ್ತಿ ದಿನಾನಿ ಯಾಪಿತವಾನ್ ");
INSERT INTO sankan_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ತಾವನ್ತಿ ದಿನಾನಿ ಯೇ ಮಾನವಾ ಅಸ್ಮಾಭಿಃ ಸಾರ್ದ್ಧಂ ತಿಷ್ಠನ್ತಿ ತೇಷಾಮ್ ಏಕೇನ ಜನೇನಾಸ್ಮಾಭಿಃ ಸಾರ್ದ್ಧಂ ಯೀಶೋರುತ್ಥಾನೇ ಸಾಕ್ಷಿಣಾ ಭವಿತವ್ಯಂ| ");
INSERT INTO sankan_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","ಅತೋ ಯಸ್ಯ ರೂಢಿ ರ್ಯುಷ್ಟೋ ಯಂ ಬರ್ಶಬ್ಬೇತ್ಯುಕ್ತ್ವಾಹೂಯನ್ತಿ ಸ ಯೂಷಫ್ ಮತಥಿಶ್ಚ ದ್ವಾವೇತೌ ಪೃಥಕ್ ಕೃತ್ವಾ ತ ಈಶ್ವರಸ್ಯ ಸನ್ನಿಧೌ ಪ್ರಾರ್ಯ್ಯ ಕಥಿತವನ್ತಃ, ");
INSERT INTO sankan_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","ಹೇ ಸರ್ವ್ವಾನ್ತರ್ಯ್ಯಾಮಿನ್ ಪರಮೇಶ್ವರ, ಯಿಹೂದಾಃ ಸೇವನಪ್ರೇರಿತತ್ವಪದಚ್ಯುತಃ ");
INSERT INTO sankan_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ಸನ್ ನಿಜಸ್ಥಾನಮ್ ಅಗಚ್ಛತ್, ತತ್ಪದಂ ಲಬ್ಧುಮ್ ಏನಯೋ ರ್ಜನಯೋ ರ್ಮಧ್ಯೇ ಭವತಾ ಕೋಽಭಿರುಚಿತಸ್ತದಸ್ಮಾನ್ ದರ್ಶ್ಯತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ತತೋ ಗುಟಿಕಾಪಾಟೇ ಕೃತೇ ಮತಥಿರ್ನಿರಚೀಯತ ತಸ್ಮಾತ್ ಸೋನ್ಯೇಷಾಮ್ ಏಕಾದಶಾನಾಂ ಪ್ರರಿತಾನಾಂ ಮಧ್ಯೇ ಗಣಿತೋಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","ಅಪರಞ್ಚ ನಿಸ್ತಾರೋತ್ಸವಾತ್ ಪರಂ ಪಞ್ಚಾಶತ್ತಮೇ ದಿನೇ ಸಮುಪಸ್ಥಿತೇ ಸತಿ ತೇ ಸರ್ವ್ವೇ ಏಕಾಚಿತ್ತೀಭೂಯ ಸ್ಥಾನ ಏಕಸ್ಮಿನ್ ಮಿಲಿತಾ ಆಸನ್| ");
INSERT INTO sankan_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ಏತಸ್ಮಿನ್ನೇವ ಸಮಯೇಽಕಸ್ಮಾದ್ ಆಕಾಶಾತ್ ಪ್ರಚಣ್ಡಾತ್ಯುಗ್ರವಾಯೋಃ ಶಬ್ದವದ್ ಏಕಃ ಶಬ್ದ ಆಗತ್ಯ ಯಸ್ಮಿನ್ ಗೃಹೇ ತ ಉಪಾವಿಶನ್ ತದ್ ಗೃಹಂ ಸಮಸ್ತಂ ವ್ಯಾಪ್ನೋತ್| ");
INSERT INTO sankan_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ತತಃ ಪರಂ ವಹ್ನಿಶಿಖಾಸ್ವರೂಪಾ ಜಿಹ್ವಾಃ ಪ್ರತ್ಯಕ್ಷೀಭೂಯ ವಿಭಕ್ತಾಃ ಸತ್ಯಃ ಪ್ರತಿಜನೋರ್ದ್ಧ್ವೇ ಸ್ಥಗಿತಾ ಅಭೂವನ್| ");
INSERT INTO sankan_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","ತಸ್ಮಾತ್ ಸರ್ವ್ವೇ ಪವಿತ್ರೇಣಾತ್ಮನಾ ಪರಿಪೂರ್ಣಾಃ ಸನ್ತ ಆತ್ಮಾ ಯಥಾ ವಾಚಿತವಾನ್ ತದನುಸಾರೇಣಾನ್ಯದೇಶೀಯಾನಾಂ ಭಾಷಾ ಉಕ್ತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","ತಸ್ಮಿನ್ ಸಮಯೇ ಪೃಥಿವೀಸ್ಥಸರ್ವ್ವದೇಶೇಭ್ಯೋ ಯಿಹೂದೀಯಮತಾವಲಮ್ಬಿನೋ ಭಕ್ತಲೋಕಾ ಯಿರೂಶಾಲಮಿ ಪ್ರಾವಸನ್; ");
INSERT INTO sankan_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ತಸ್ಯಾಃ ಕಥಾಯಾಃ ಕಿಂವದನ್ತ್ಯಾ ಜಾತತ್ವಾತ್ ಸರ್ವ್ವೇ ಲೋಕಾ ಮಿಲಿತ್ವಾ ನಿಜನಿಜಭಾಷಯಾ ಶಿಷ್ಯಾಣಾಂ ಕಥಾಕಥನಂ ಶ್ರುತ್ವಾ ಸಮುದ್ವಿಗ್ನಾ ಅಭವನ್| ");
INSERT INTO sankan_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ಸರ್ವ್ವಏವ ವಿಸ್ಮಯಾಪನ್ನಾ ಆಶ್ಚರ್ಯ್ಯಾನ್ವಿತಾಶ್ಚ ಸನ್ತಃ ಪರಸ್ಪರಂ ಉಕ್ತವನ್ತಃ ಪಶ್ಯತ ಯೇ ಕಥಾಂ ಕಥಯನ್ತಿ ತೇ ಸರ್ವ್ವೇ ಗಾಲೀಲೀಯಲೋಕಾಃ ಕಿಂ ನ ಭವನ್ತಿ? ");
INSERT INTO sankan_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ತರ್ಹಿ ವಯಂ ಪ್ರತ್ಯೇಕಶಃ ಸ್ವಸ್ವಜನ್ಮದೇಶೀಯಭಾಷಾಭಿಃ ಕಥಾ ಏತೇಷಾಂ ಶೃಣುಮಃ ಕಿಮಿದಂ? ");
INSERT INTO sankan_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","ಪಾರ್ಥೀ-ಮಾದೀ-ಅರಾಮ್ನಹರಯಿಮ್ದೇಶನಿವಾಸಿಮನೋ ಯಿಹೂದಾ-ಕಪ್ಪದಕಿಯಾ-ಪನ್ತ-ಆಶಿಯಾ- ");
INSERT INTO sankan_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ಫ್ರುಗಿಯಾ-ಪಮ್ಫುಲಿಯಾ-ಮಿಸರನಿವಾಸಿನಃ ಕುರೀಣೀನಿಕಟವರ್ತ್ತಿಲೂಬೀಯಪ್ರದೇಶನಿವಾಸಿನೋ ರೋಮನಗರಾದ್ ಆಗತಾ ಯಿಹೂದೀಯಲೋಕಾ ಯಿಹೂದೀಯಮತಗ್ರಾಹಿಣಃ ಕ್ರೀತೀಯಾ ಅರಾಬೀಯಾದಯೋ ಲೋಕಾಶ್ಚ ಯೇ ವಯಮ್ ");
INSERT INTO sankan_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ಅಸ್ಮಾಕಂ ನಿಜನಿಜಭಾಷಾಭಿರೇತೇಷಾಮ್ ಈಶ್ವರೀಯಮಹಾಕರ್ಮ್ಮವ್ಯಾಖ್ಯಾನಂ ಶೃಣುಮಃ| ");
INSERT INTO sankan_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ಇತ್ಥಂ ತೇ ಸರ್ವ್ವಏವ ವಿಸ್ಮಯಾಪನ್ನಾಃ ಸನ್ದಿಗ್ಧಚಿತ್ತಾಃ ಸನ್ತಃ ಪರಸ್ಪರಮೂಚುಃ, ಅಸ್ಯ ಕೋ ಭಾವಃ? ");
INSERT INTO sankan_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","ಅಪರೇ ಕೇಚಿತ್ ಪರಿಹಸ್ಯ ಕಥಿತವನ್ತ ಏತೇ ನವೀನದ್ರಾಕ್ಷಾರಸೇನ ಮತ್ತಾ ಅಭವನ್| ");
INSERT INTO sankan_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","ತದಾ ಪಿತರ ಏಕಾದಶಭಿ ರ್ಜನೈಃ ಸಾಕಂ ತಿಷ್ಠನ್ ತಾಲ್ಲೋಕಾನ್ ಉಚ್ಚೈಃಕಾರಮ್ ಅವದತ್, ಹೇ ಯಿಹೂದೀಯಾ ಹೇ ಯಿರೂಶಾಲಮ್ನಿವಾಸಿನಃ ಸರ್ವ್ವೇ, ಅವಧಾನಂ ಕೃತ್ವಾ ಮದೀಯವಾಕ್ಯಂ ಬುಧ್ಯಧ್ವಂ| ");
INSERT INTO sankan_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ಇದಾನೀಮ್ ಏಕಯಾಮಾದ್ ಅಧಿಕಾ ವೇಲಾ ನಾಸ್ತಿ ತಸ್ಮಾದ್ ಯೂಯಂ ಯದ್ ಅನುಮಾಥ ಮಾನವಾ ಇಮೇ ಮದ್ಯಪಾನೇನ ಮತ್ತಾಸ್ತನ್ನ| ");
INSERT INTO sankan_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","ಕಿನ್ತು ಯೋಯೇಲ್ಭವಿಷ್ಯದ್ವಕ್ತ್ರೈತದ್ವಾಕ್ಯಮುಕ್ತಂ ಯಥಾ, ");
INSERT INTO sankan_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","ಈಶ್ವರಃ ಕಥಯಾಮಾಸ ಯುಗಾನ್ತಸಮಯೇ ತ್ವಹಮ್| ವರ್ಷಿಷ್ಯಾಮಿ ಸ್ವಮಾತ್ಮಾನಂ ಸರ್ವ್ವಪ್ರಾಣ್ಯುಪರಿ ಧ್ರುವಮ್| ಭಾವಿವಾಕ್ಯಂ ವದಿಷ್ಯನ್ತಿ ಕನ್ಯಾಃ ಪುತ್ರಾಶ್ಚ ವಸ್ತುತಃ| ಪ್ರತ್ಯಾದೇಶಞ್ಚ ಪ್ರಾಪ್ಸ್ಯನ್ತಿ ಯುಷ್ಮಾಕಂ ಯುವಮಾನವಾಃ| ತಥಾ ಪ್ರಾಚೀನಲೋಕಾಸ್ತು ಸ್ವಪ್ನಾನ್ ದ್ರಕ್ಷ್ಯನ್ತಿ ನಿಶ್ಚಿತಂ| ");
INSERT INTO sankan_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","ವರ್ಷಿಷ್ಯಾಮಿ ತದಾತ್ಮಾನಂ ದಾಸದಾಸೀಜನೋಪಿರಿ| ತೇನೈವ ಭಾವಿವಾಕ್ಯಂ ತೇ ವದಿಷ್ಯನ್ತಿ ಹಿ ಸರ್ವ್ವಶಃ| ");
INSERT INTO sankan_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ಊರ್ದ್ಧ್ವಸ್ಥೇ ಗಗಣೇ ಚೈವ ನೀಚಸ್ಥೇ ಪೃಥಿವೀತಲೇ| ಶೋಣಿತಾನಿ ಬೃಹದ್ಭಾನೂನ್ ಘನಧೂಮಾದಿಕಾನಿ ಚ| ಚಿಹ್ನಾನಿ ದರ್ಶಯಿಷ್ಯಾಮಿ ಮಹಾಶ್ಚರ್ಯ್ಯಕ್ರಿಯಾಸ್ತಥಾ| ");
INSERT INTO sankan_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","ಮಹಾಭಯಾನಕಸ್ಯೈವ ತದ್ದಿನಸ್ಯ ಪರೇಶಿತುಃ| ಪುರಾಗಮಾದ್ ರವಿಃ ಕೃಷ್ಣೋ ರಕ್ತಶ್ಚನ್ದ್ರೋ ಭವಿಷ್ಯತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","ಕಿನ್ತು ಯಃ ಪರಮೇಶಸ್ಯ ನಾಮ್ನಿ ಸಮ್ಪ್ರಾರ್ಥಯಿಷ್ಯತೇ| ಸಏವ ಮನುಜೋ ನೂನಂ ಪರಿತ್ರಾತೋ ಭವಿಷ್ಯತಿ|| ");
INSERT INTO sankan_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","ಅತೋ ಹೇ ಇಸ್ರಾಯೇಲ್ವಂಶೀಯಲೋಕಾಃ ಸರ್ವ್ವೇ ಕಥಾಯಾಮೇತಸ್ಯಾಮ್ ಮನೋ ನಿಧದ್ಧ್ವಂ ನಾಸರತೀಯೋ ಯೀಶುರೀಶ್ವರಸ್ಯ ಮನೋನೀತಃ ಪುಮಾನ್ ಏತದ್ ಈಶ್ವರಸ್ತತ್ಕೃತೈರಾಶ್ಚರ್ಯ್ಯಾದ್ಭುತಕರ್ಮ್ಮಭಿ ರ್ಲಕ್ಷಣೈಶ್ಚ ಯುಷ್ಮಾಕಂ ಸಾಕ್ಷಾದೇವ ಪ್ರತಿಪಾದಿತವಾನ್ ಇತಿ ಯೂಯಂ ಜಾನೀಥ| ");
INSERT INTO sankan_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","ತಸ್ಮಿನ್ ಯೀಶೌ ಈಶ್ವರಸ್ಯ ಪೂರ್ವ್ವನಿಶ್ಚಿತಮನ್ತ್ರಣಾನಿರೂಪಣಾನುಸಾರೇಣ ಮೃತ್ಯೌ ಸಮರ್ಪಿತೇ ಸತಿ ಯೂಯಂ ತಂ ಧೃತ್ವಾ ದುಷ್ಟಲೋಕಾನಾಂ ಹಸ್ತೈಃ ಕ್ರುಶೇ ವಿಧಿತ್ವಾಹತ| ");
INSERT INTO sankan_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","ಕಿನ್ತ್ವೀಶ್ವರಸ್ತಂ ನಿಧನಸ್ಯ ಬನ್ಧನಾನ್ಮೋಚಯಿತ್ವಾ ಉದಸ್ಥಾಪಯತ್ ಯತಃ ಸ ಮೃತ್ಯುನಾ ಬದ್ಧಸ್ತಿಷ್ಠತೀತಿ ನ ಸಮ್ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ಏತಸ್ತಿನ್ ದಾಯೂದಪಿ ಕಥಿತವಾನ್ ಯಥಾ, ಸರ್ವ್ವದಾ ಮಮ ಸಾಕ್ಷಾತ್ತಂ ಸ್ಥಾಪಯ ಪರಮೇಶ್ವರಂ| ಸ್ಥಿತೇ ಮದ್ದಕ್ಷಿಣೇ ತಸ್ಮಿನ್ ಸ್ಖಲಿಷ್ಯಾಮಿ ತ್ವಹಂ ನಹಿ| ");
INSERT INTO sankan_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ಆನನ್ದಿಷ್ಯತಿ ತದ್ಧೇತೋ ರ್ಮಾಮಕೀನಂ ಮನಸ್ತು ವೈ| ಆಹ್ಲಾದಿಷ್ಯತಿ ಜಿಹ್ವಾಪಿ ಮದೀಯಾ ತು ತಥೈವ ಚ| ಪ್ರತ್ಯಾಶಯಾ ಶರೀರನ್ತು ಮದೀಯಂ ವೈಶಯಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ಪರಲೋಕೇ ಯತೋ ಹೇತೋಸ್ತ್ವಂ ಮಾಂ ನೈವ ಹಿ ತ್ಯಕ್ಷ್ಯಸಿ| ಸ್ವಕೀಯಂ ಪುಣ್ಯವನ್ತಂ ತ್ವಂ ಕ್ಷಯಿತುಂ ನೈವ ದಾಸ್ಯಸಿ| ಏವಂ ಜೀವನಮಾರ್ಗಂ ತ್ವಂ ಮಾಮೇವ ದರ್ಶಯಿಷ್ಯಸಿ| ");
INSERT INTO sankan_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","ಸ್ವಸಮ್ಮುಖೇ ಯ ಆನನ್ದೋ ದಕ್ಷಿಣೇ ಸ್ವಸ್ಯ ಯತ್ ಸುಖಂ| ಅನನ್ತಂ ತೇನ ಮಾಂ ಪೂರ್ಣಂ ಕರಿಷ್ಯಸಿ ನ ಸಂಶಯಃ|| ");
INSERT INTO sankan_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","ಹೇ ಭ್ರಾತರೋಽಸ್ಮಾಕಂ ತಸ್ಯ ಪೂರ್ವ್ವಪುರುಷಸ್ಯ ದಾಯೂದಃ ಕಥಾಂ ಸ್ಪಷ್ಟಂ ಕಥಯಿತುಂ ಮಾಮ್ ಅನುಮನ್ಯಧ್ವಂ, ಸ ಪ್ರಾಣಾನ್ ತ್ಯಕ್ತ್ವಾ ಶ್ಮಶಾನೇ ಸ್ಥಾಪಿತೋಭವದ್ ಅದ್ಯಾಪಿ ತತ್ ಶ್ಮಶಾನಮ್ ಅಸ್ಮಾಕಂ ಸನ್ನಿಧೌ ವಿದ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","ಫಲತೋ ಲೌಕಿಕಭಾವೇನ ದಾಯೂದೋ ವಂಶೇ ಖ್ರೀಷ್ಟಂ ಜನ್ಮ ಗ್ರಾಹಯಿತ್ವಾ ತಸ್ಯೈವ ಸಿಂಹಾಸನೇ ಸಮುವೇಷ್ಟುಂ ತಮುತ್ಥಾಪಯಿಷ್ಯತಿ ಪರಮೇಶ್ವರಃ ಶಪಥಂ ಕುತ್ವಾ ದಾಯೂದಃ ಸಮೀಪ ಇಮಮ್ ಅಙ್ಗೀಕಾರಂ ಕೃತವಾನ್, ");
INSERT INTO sankan_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ಇತಿ ಜ್ಞಾತ್ವಾ ದಾಯೂದ್ ಭವಿಷ್ಯದ್ವಾದೀ ಸನ್ ಭವಿಷ್ಯತ್ಕಾಲೀಯಜ್ಞಾನೇನ ಖ್ರೀಷ್ಟೋತ್ಥಾನೇ ಕಥಾಮಿಮಾಂ ಕಥಯಾಮಾಸ ಯಥಾ ತಸ್ಯಾತ್ಮಾ ಪರಲೋಕೇ ನ ತ್ಯಕ್ಷ್ಯತೇ ತಸ್ಯ ಶರೀರಞ್ಚ ನ ಕ್ಷೇಷ್ಯತಿ; ");
INSERT INTO sankan_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","ಅತಃ ಪರಮೇಶ್ವರ ಏನಂ ಯೀಶುಂ ಶ್ಮಶಾನಾದ್ ಉದಸ್ಥಾಪಯತ್ ತತ್ರ ವಯಂ ಸರ್ವ್ವೇ ಸಾಕ್ಷಿಣ ಆಸ್ಮಹೇ| ");
INSERT INTO sankan_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ಸ ಈಶ್ವರಸ್ಯ ದಕ್ಷಿಣಕರೇಣೋನ್ನತಿಂ ಪ್ರಾಪ್ಯ ಪವಿತ್ರ ಆತ್ಮಿನ ಪಿತಾ ಯಮಙ್ಗೀಕಾರಂ ಕೃತವಾನ್ ತಸ್ಯ ಫಲಂ ಪ್ರಾಪ್ಯ ಯತ್ ಪಶ್ಯಥ ಶೃಣುಥ ಚ ತದವರ್ಷತ್| ");
INSERT INTO sankan_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","ಯತೋ ದಾಯೂದ್ ಸ್ವರ್ಗಂ ನಾರುರೋಹ ಕಿನ್ತು ಸ್ವಯಮ್ ಇಮಾಂ ಕಥಾಮ್ ಅಕಥಯದ್ ಯಥಾ, ಮಮ ಪ್ರಭುಮಿದಂ ವಾಕ್ಯಮವದತ್ ಪರಮೇಶ್ವರಃ| ");
INSERT INTO sankan_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ತವ ಶತ್ರೂನಹಂ ಯಾವತ್ ಪಾದಪೀಠಂ ಕರೋಮಿ ನ| ತಾವತ್ ಕಾಲಂ ಮದೀಯೇ ತ್ವಂ ದಕ್ಷವಾರ್ಶ್ವ ಉಪಾವಿಶ| ");
INSERT INTO sankan_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","ಅತೋ ಯಂ ಯೀಶುಂ ಯೂಯಂ ಕ್ರುಶೇಽಹತ ಪರಮೇಶ್ವರಸ್ತಂ ಪ್ರಭುತ್ವಾಭಿಷಿಕ್ತತ್ವಪದೇ ನ್ಯಯುಂಕ್ತೇತಿ ಇಸ್ರಾಯೇಲೀಯಾ ಲೋಕಾ ನಿಶ್ಚಿತಂ ಜಾನನ್ತು| ");
INSERT INTO sankan_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ಏತಾದೃಶೀಂ ಕಥಾಂ ಶ್ರುತ್ವಾ ತೇಷಾಂ ಹೃದಯಾನಾಂ ವಿದೀರ್ಣತ್ವಾತ್ ತೇ ಪಿತರಾಯ ತದನ್ಯಪ್ರೇರಿತೇಭ್ಯಶ್ಚ ಕಥಿತವನ್ತಃ, ಹೇ ಭ್ರಾತೃಗಣ ವಯಂ ಕಿಂ ಕರಿಷ್ಯಾಮಃ? ");
INSERT INTO sankan_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","ತತಃ ಪಿತರಃ ಪ್ರತ್ಯವದದ್ ಯೂಯಂ ಸರ್ವ್ವೇ ಸ್ವಂ ಸ್ವಂ ಮನಃ ಪರಿವರ್ತ್ತಯಧ್ವಂ ತಥಾ ಪಾಪಮೋಚನಾರ್ಥಂ ಯೀಶುಖ್ರೀಷ್ಟಸ್ಯ ನಾಮ್ನಾ ಮಜ್ಜಿತಾಶ್ಚ ಭವತ, ತಸ್ಮಾದ್ ದಾನರೂಪಂ ಪರಿತ್ರಮ್ ಆತ್ಮಾನಂ ಲಪ್ಸ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","ಯತೋ ಯುಷ್ಮಾಕಂ ಯುಷ್ಮತ್ಸನ್ತಾನಾನಾಞ್ಚ ದೂರಸ್ಥಸರ್ವ್ವಲೋಕಾನಾಞ್ಚ ನಿಮಿತ್ತಮ್ ಅರ್ಥಾದ್ ಅಸ್ಮಾಕಂ ಪ್ರಭುಃ ಪರಮೇಶ್ವರೋ ಯಾವತೋ ಲಾಕಾನ್ ಆಹ್ವಾಸ್ಯತಿ ತೇಷಾಂ ಸರ್ವ್ವೇಷಾಂ ನಿಮಿತ್ತಮ್ ಅಯಮಙ್ಗೀಕಾರ ಆಸ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ಏತದನ್ಯಾಭಿ ರ್ಬಹುಕಥಾಭಿಃ ಪ್ರಮಾಣಂ ದತ್ವಾಕಥಯತ್ ಏತೇಭ್ಯೋ ವಿಪಥಗಾಮಿಭ್ಯೋ ವರ್ತ್ತಮಾನಲೋಕೇಭ್ಯಃ ಸ್ವಾನ್ ರಕ್ಷತ| ");
INSERT INTO sankan_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ತತಃ ಪರಂ ಯೇ ಸಾನನ್ದಾಸ್ತಾಂ ಕಥಾಮ್ ಅಗೃಹ್ಲನ್ ತೇ ಮಜ್ಜಿತಾ ಅಭವನ್| ತಸ್ಮಿನ್ ದಿವಸೇ ಪ್ರಾಯೇಣ ತ್ರೀಣಿ ಸಹಸ್ರಾಣಿ ಲೋಕಾಸ್ತೇಷಾಂ ಸಪಕ್ಷಾಃ ಸನ್ತಃ ");
INSERT INTO sankan_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ಪ್ರೇರಿತಾನಾಮ್ ಉಪದೇಶೇ ಸಙ್ಗತೌ ಪೂಪಭಞ್ಜನೇ ಪ್ರಾರ್ಥನಾಸು ಚ ಮನಃಸಂಯೋಗಂ ಕೃತ್ವಾತಿಷ್ಠನ್| ");
INSERT INTO sankan_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","ಪ್ರೇರಿತೈ ರ್ನಾನಾಪ್ರಕಾರಲಕ್ಷಣೇಷು ಮಹಾಶ್ಚರ್ಯ್ಯಕರ್ಮಮಸು ಚ ದರ್ಶಿತೇಷು ಸರ್ವ್ವಲೋಕಾನಾಂ ಭಯಮುಪಸ್ಥಿತಂ| ");
INSERT INTO sankan_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","ವಿಶ್ವಾಸಕಾರಿಣಃ ಸರ್ವ್ವ ಚ ಸಹ ತಿಷ್ಠನತಃ| ಸ್ವೇಷಾಂ ಸರ್ವ್ವಾಃ ಸಮ್ಪತ್ತೀಃ ಸಾಧಾರಣ್ಯೇನ ಸ್ಥಾಪಯಿತ್ವಾಭುಞ್ಜತ| ");
INSERT INTO sankan_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ಫಲತೋ ಗೃಹಾಣಿ ದ್ರವ್ಯಾಣಿ ಚ ಸರ್ವ್ವಾಣಿ ವಿಕ್ರೀಯ ಸರ್ವ್ವೇಷಾಂ ಸ್ವಸ್ವಪ್ರಯೋಜನಾನುಸಾರೇಣ ವಿಭಜ್ಯ ಸರ್ವ್ವೇಭ್ಯೋಽದದನ್| ");
INSERT INTO sankan_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","ಸರ್ವ್ವ ಏಕಚಿತ್ತೀಭೂಯ ದಿನೇ ದಿನೇ ಮನ್ದಿರೇ ಸನ್ತಿಷ್ಠಮಾನಾ ಗೃಹೇ ಗೃಹೇ ಚ ಪೂಪಾನಭಞ್ಜನ್ತ ಈಶ್ವರಸ್ಯ ಧನ್ಯವಾದಂ ಕುರ್ವ್ವನ್ತೋ ಲೋಕೈಃ ಸಮಾದೃತಾಃ ಪರಮಾನನ್ದೇನ ಸರಲಾನ್ತಃಕರಣೇನ ಭೋಜನಂ ಪಾನಞ್ಚಕುರ್ವ್ವನ್| ");
INSERT INTO sankan_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ಪರಮೇಶ್ವರೋ ದಿನೇ ದಿನೇ ಪರಿತ್ರಾಣಭಾಜನೈ ರ್ಮಣ್ಡಲೀಮ್ ಅವರ್ದ್ಧಯತ್| ");
INSERT INTO sankan_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","ತೃತೀಯಯಾಮವೇಲಾಯಾಂ ಸತ್ಯಾಂ ಪ್ರಾರ್ಥನಾಯಾಃ ಸಮಯೇ ಪಿತರಯೋಹನೌ ಸಮ್ಭೂಯ ಮನ್ದಿರಂ ಗಚ್ಛತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ತಸ್ಮಿನ್ನೇವ ಸಮಯೇ ಮನ್ದಿರಪ್ರವೇಶಕಾನಾಂ ಸಮೀಪೇ ಭಿಕ್ಷಾರಣಾರ್ಥಂ ಯಂ ಜನ್ಮಖಞ್ಜಮಾನುಷಂ ಲೋಕಾ ಮನ್ದಿರಸ್ಯ ಸುನ್ದರನಾಮ್ನಿ ದ್ವಾರೇ ಪ್ರತಿದಿನಮ್ ಅಸ್ಥಾಪಯನ್ ತಂ ವಹನ್ತಸ್ತದ್ವಾರಂ ಆನಯನ್| ");
INSERT INTO sankan_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ತದಾ ಪಿತರಯೋಹನೌ ಮನ್ತಿರಂ ಪ್ರವೇಷ್ಟುಮ್ ಉದ್ಯತೌ ವಿಲೋಕ್ಯ ಸ ಖಞ್ಜಸ್ತೌ ಕಿಞ್ಚಿದ್ ಭಿಕ್ಷಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","ತಸ್ಮಾದ್ ಯೋಹನಾ ಸಹಿತಃ ಪಿತರಸ್ತಮ್ ಅನನ್ಯದೃಷ್ಟ್ಯಾ ನಿರೀಕ್ಷ್ಯ ಪ್ರೋಕ್ತವಾನ್ ಆವಾಂ ಪ್ರತಿ ದೃಷ್ಟಿಂ ಕುರು| ");
INSERT INTO sankan_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ತತಃ ಸ ಕಿಞ್ಚಿತ್ ಪ್ರಾಪ್ತ್ಯಾಶಯಾ ತೌ ಪ್ರತಿ ದೃಷ್ಟಿಂ ಕೃತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","ತದಾ ಪಿತರೋ ಗದಿತವಾನ್ ಮಮ ನಿಕಟೇ ಸ್ವರ್ಣರೂಪ್ಯಾದಿ ಕಿಮಪಿ ನಾಸ್ತಿ ಕಿನ್ತು ಯದಾಸ್ತೇ ತದ್ ದದಾಮಿ ನಾಸರತೀಯಸ್ಯ ಯೀಶುಖ್ರೀಷ್ಟಸ್ಯ ನಾಮ್ನಾ ತ್ವಮುತ್ಥಾಯ ಗಮನಾಗಮನೇ ಕುರು| ");
INSERT INTO sankan_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ತತಃ ಪರಂ ಸ ತಸ್ಯ ದಕ್ಷಿಣಕರಂ ಧೃತ್ವಾ ತಮ್ ಉದತೋಲಯತ್; ತೇನ ತತ್ಕ್ಷಣಾತ್ ತಸ್ಯ ಜನಸ್ಯ ಪಾದಗುಲ್ಫಯೋಃ ಸಬಲತ್ವಾತ್ ಸ ಉಲ್ಲಮ್ಫ್ಯ ಪ್ರೋತ್ಥಾಯ ಗಮನಾಗಮನೇ ಽಕರೋತ್| ");
INSERT INTO sankan_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ತತೋ ಗಮನಾಗಮನೇ ಕುರ್ವ್ವನ್ ಉಲ್ಲಮ್ಫನ್ ಈಶ್ವರಂ ಧನ್ಯಂ ವದನ್ ತಾಭ್ಯಾಂ ಸಾರ್ದ್ಧಂ ಮನ್ದಿರಂ ಪ್ರಾವಿಶತ್| ");
INSERT INTO sankan_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ತತಃ ಸರ್ವ್ವೇ ಲೋಕಾಸ್ತಂ ಗಮನಾಗಮನೇ ಕುರ್ವ್ವನ್ತಮ್ ಈಶ್ವರಂ ಧನ್ಯಂ ವದನ್ತಞ್ಚ ವಿಲೋಕ್ಯ ");
INSERT INTO sankan_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ಮನ್ದಿರಸ್ಯ ಸುನ್ದರೇ ದ್ವಾರೇ ಯ ಉಪವಿಶ್ಯ ಭಿಕ್ಷಿತವಾನ್ ಸಏವಾಯಮ್ ಇತಿ ಜ್ಞಾತ್ವಾ ತಂ ಪ್ರತಿ ತಯಾ ಘಟನಯಾ ಚಮತ್ಕೃತಾ ವಿಸ್ಮಯಾಪನ್ನಾಶ್ಚಾಭವನ್| ");
INSERT INTO sankan_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","ಯಃ ಖಞ್ಜಃ ಸ್ವಸ್ಥೋಭವತ್ ತೇನ ಪಿತರಯೋಹನೋಃ ಕರಯೋರ್ಧ್ಟತಯೋಃ ಸತೋಃ ಸರ್ವ್ವೇ ಲೋಕಾ ಸನ್ನಿಧಿಮ್ ಆಗಚ್ಛನ್| ");
INSERT INTO sankan_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ತದ್ ದೃಷ್ಟ್ವಾ ಪಿತರಸ್ತೇಭ್ಯೋಽಕಥಯತ್, ಹೇ ಇಸ್ರಾಯೇಲೀಯಲೋಕಾ ಯೂಯಂ ಕುತೋ ಽನೇನಾಶ್ಚರ್ಯ್ಯಂ ಮನ್ಯಧ್ವೇ? ಆವಾಂ ನಿಜಶಕ್ತ್ಯಾ ಯದ್ವಾ ನಿಜಪುಣ್ಯೇನ ಖಞ್ಜಮನುಷ್ಯಮೇನಂ ಗಮಿತವನ್ತಾವಿತಿ ಚಿನ್ತಯಿತ್ವಾ ಆವಾಂ ಪ್ರತಿ ಕುತೋಽನನ್ಯದೃಷ್ಟಿಂ ಕುರುಥ? ");
INSERT INTO sankan_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","ಯಂ ಯೀಶುಂ ಯೂಯಂ ಪರಕರೇಷು ಸಮಾರ್ಪಯತ ತತೋ ಯಂ ಪೀಲಾತೋ ಮೋಚಯಿತುಮ್ ಏैಚ್ಛತ್ ತಥಾಪಿ ಯೂಯಂ ತಸ್ಯ ಸಾಕ್ಷಾನ್ ನಾಙ್ಗೀಕೃತವನ್ತ ಇಬ್ರಾಹೀಮ ಇಸ್ಹಾಕೋ ಯಾಕೂಬಶ್ಚೇಶ್ವರೋಽರ್ಥಾದ್ ಅಸ್ಮಾಕಂ ಪೂರ್ವ್ವಪುರುಷಾಣಾಮ್ ಈಶ್ವರಃ ಸ್ವಪುತ್ರಸ್ಯ ತಸ್ಯ ಯೀಶೋ ರ್ಮಹಿಮಾನಂ ಪ್ರಾಕಾಶಯತ್| ");
INSERT INTO sankan_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","ಕಿನ್ತು ಯೂಯಂ ತಂ ಪವಿತ್ರಂ ಧಾರ್ಮ್ಮಿಕಂ ಪುಮಾಂಸಂ ನಾಙ್ಗೀಕೃತ್ಯ ಹತ್ಯಾಕಾರಿಣಮೇಕಂ ಸ್ವೇಭ್ಯೋ ದಾತುಮ್ ಅಯಾಚಧ್ವಂ| ");
INSERT INTO sankan_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ಪಶ್ಚಾತ್ ತಂ ಜೀವನಸ್ಯಾಧಿಪತಿಮ್ ಅಹತ ಕಿನ್ತ್ವೀಶ್ವರಃ ಶ್ಮಶಾನಾತ್ ತಮ್ ಉದಸ್ಥಾಪಯತ ತತ್ರ ವಯಂ ಸಾಕ್ಷಿಣ ಆಸ್ಮಹೇ| ");
INSERT INTO sankan_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ಇಮಂ ಯಂ ಮಾನುಷಂ ಯೂಯಂ ಪಶ್ಯಥ ಪರಿಚಿನುಥ ಚ ಸ ತಸ್ಯ ನಾಮ್ನಿ ವಿಶ್ವಾಸಕರಣಾತ್ ಚಲನಶಕ್ತಿಂ ಲಬ್ಧವಾನ್ ತಸ್ಮಿನ್ ತಸ್ಯ ಯೋ ವಿಶ್ವಾಸಃ ಸ ತಂ ಯುಷ್ಮಾಕಂ ಸರ್ವ್ವೇಷಾಂ ಸಾಕ್ಷಾತ್ ಸಮ್ಪೂರ್ಣರೂಪೇಣ ಸ್ವಸ್ಥಮ್ ಅಕಾರ್ಷೀತ್| ");
INSERT INTO sankan_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","ಹೇ ಭ್ರಾತರೋ ಯೂಯಂ ಯುಷ್ಮಾಕಮ್ ಅಧಿಪತಯಶ್ಚ ಅಜ್ಞಾತ್ವಾ ಕರ್ಮ್ಮಾಣ್ಯೇತಾನಿ ಕೃತವನ್ತ ಇದಾನೀಂ ಮಮೈಷ ಬೋಧೋ ಜಾಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","ಕಿನ್ತ್ವೀಶ್ವರಃ ಖ್ರೀಷ್ಟಸ್ಯ ದುಃಖಭೋಗೇ ಭವಿಷ್ಯದ್ವಾದಿನಾಂ ಮುಖೇಭ್ಯೋ ಯಾಂ ಯಾಂ ಕಥಾಂ ಪೂರ್ವ್ವಮಕಥಯತ್ ತಾಃ ಕಥಾ ಇತ್ಥಂ ಸಿದ್ಧಾ ಅಕರೋತ್| ");
INSERT INTO sankan_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","ಅತಃ ಸ್ವೇಷಾಂ ಪಾಪಮೋಚನಾರ್ಥಂ ಖೇದಂ ಕೃತ್ವಾ ಮನಾಂಸಿ ಪರಿವರ್ತ್ತಯಧ್ವಂ, ತಸ್ಮಾದ್ ಈಶ್ವರಾತ್ ಸಾನ್ತ್ವನಾಪ್ರಾಪ್ತೇಃ ಸಮಯ ಉಪಸ್ಥಾಸ್ಯತಿ; ");
INSERT INTO sankan_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ಪುನಶ್ಚ ಪೂರ್ವ್ವಕಾಲಮ್ ಆರಭ್ಯ ಪ್ರಚಾರಿತೋ ಯೋ ಯೀಶುಖ್ರೀಷ್ಟಸ್ತಮ್ ಈಶ್ವರೋ ಯುಷ್ಮಾನ್ ಪ್ರತಿ ಪ್ರೇಷಯಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","ಕಿನ್ತು ಜಗತಃ ಸೃಷ್ಟಿಮಾರಭ್ಯ ಈಶ್ವರೋ ನಿಜಪವಿತ್ರಭವಿಷ್ಯದ್ವಾದಿಗಣೋನ ಯಥಾ ಕಥಿತವಾನ್ ತದನುಸಾರೇಣ ಸರ್ವ್ವೇಷಾಂ ಕಾರ್ಯ್ಯಾಣಾಂ ಸಿದ್ಧಿಪರ್ಯ್ಯನ್ತಂ ತೇನ ಸ್ವರ್ಗೇ ವಾಸಃ ಕರ್ತ್ತವ್ಯಃ| ");
INSERT INTO sankan_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","ಯುಷ್ಮಾಕಂ ಪ್ರಭುಃ ಪರಮೇಶ್ವರೋ ಯುಷ್ಮಾಕಂ ಭ್ರಾತೃಗಣಮಧ್ಯಾತ್ ಮತ್ಸದೃಶಂ ಭವಿಷ್ಯದ್ವಕ್ತಾರಮ್ ಉತ್ಪಾದಯಿಷ್ಯತಿ, ತತಃ ಸ ಯತ್ ಕಿಞ್ಚಿತ್ ಕಥಯಿಷ್ಯತಿ ತತ್ರ ಯೂಯಂ ಮನಾಂಸಿ ನಿಧದ್ಧ್ವಂ| ");
INSERT INTO sankan_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","ಕಿನ್ತು ಯಃ ಕಶ್ಚಿತ್ ಪ್ರಾಣೀ ತಸ್ಯ ಭವಿಷ್ಯದ್ವಾದಿನಃ ಕಥಾಂ ನ ಗ್ರಹೀಷ್ಯತಿ ಸ ನಿಜಲೋಕಾನಾಂ ಮಧ್ಯಾದ್ ಉಚ್ಛೇತ್ಸ್ಯತೇ,\" ಇಮಾಂ ಕಥಾಮ್ ಅಸ್ಮಾಕಂ ಪೂರ್ವ್ವಪುರುಷೇಭ್ಯಃ ಕೇವಲೋ ಮೂಸಾಃ ಕಥಯಾಮಾಸ ಇತಿ ನಹಿ, ");
INSERT INTO sankan_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","ಶಿಮೂಯೇಲ್ಭವಿಷ್ಯದ್ವಾದಿನಮ್ ಆರಭ್ಯ ಯಾವನ್ತೋ ಭವಿಷ್ಯದ್ವಾಕ್ಯಮ್ ಅಕಥಯನ್ ತೇ ಸರ್ವ್ವಏವ ಸಮಯಸ್ಯೈತಸ್ಯ ಕಥಾಮ್ ಅಕಥಯನ್| ");
INSERT INTO sankan_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","ಯೂಯಮಪಿ ತೇಷಾಂ ಭವಿಷ್ಯದ್ವಾದಿನಾಂ ಸನ್ತಾನಾಃ, \"ತವ ವಂಶೋದ್ಭವಪುಂಸಾ ಸರ್ವ್ವದೇಶೀಯಾ ಲೋಕಾ ಆಶಿಷಂ ಪ್ರಾಪ್ತಾ ಭವಿಷ್ಯನ್ತಿ\", ಇಬ್ರಾಹೀಮೇ ಕಥಾಮೇತಾಂ ಕಥಯಿತ್ವಾ ಈಶ್ವರೋಸ್ಮಾಕಂ ಪೂರ್ವ್ವಪುರುಷೈಃ ಸಾರ್ದ್ಧಂ ಯಂ ನಿಯಮಂ ಸ್ಥಿರೀಕೃತವಾನ್ ತಸ್ಯ ನಿಯಮಸ್ಯಾಧಿಕಾರಿಣೋಪಿ ಯೂಯಂ ಭವಥ| ");
INSERT INTO sankan_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ಅತ ಈಶ್ವರೋ ನಿಜಪುತ್ರಂ ಯೀಶುಮ್ ಉತ್ಥಾಪ್ಯ ಯುಷ್ಮಾಕಂ ಸರ್ವ್ವೇಷಾಂ ಸ್ವಸ್ವಪಾಪಾತ್ ಪರಾವರ್ತ್ತ್ಯ ಯುಷ್ಮಭ್ಯಮ್ ಆಶಿಷಂ ದಾತುಂ ಪ್ರಥಮತಸ್ತಂ ಯುಷ್ಮಾಕಂ ನಿಕಟಂ ಪ್ರೇಷಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","ಯಸ್ಮಿನ್ ಸಮಯೇ ಪಿತರಯೋಹನೌ ಲೋಕಾನ್ ಉಪದಿಶತಸ್ತಸ್ಮಿನ್ ಸಮಯೇ ಯಾಜಕಾ ಮನ್ದಿರಸ್ಯ ಸೇನಾಪತಯಃ ಸಿದೂಕೀಗಣಶ್ಚ ");
INSERT INTO sankan_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ತಯೋರ್ ಉಪದೇಶಕರಣೇ ಖ್ರೀಷ್ಟಸ್ಯೋತ್ಥಾನಮ್ ಉಪಲಕ್ಷ್ಯ ಸರ್ವ್ವೇಷಾಂ ಮೃತಾನಾಮ್ ಉತ್ಥಾನಪ್ರಸ್ತಾವೇ ಚ ವ್ಯಗ್ರಾಃ ಸನ್ತಸ್ತಾವುಪಾಗಮನ್| ");
INSERT INTO sankan_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","ತೌ ಧೃತ್ವಾ ದಿನಾವಸಾನಕಾರಣಾತ್ ಪರದಿನಪರ್ಯ್ಯನನ್ತಂ ರುದ್ಧ್ವಾ ಸ್ಥಾಪಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","ತಥಾಪಿ ಯೇ ಲೋಕಾಸ್ತಯೋರುಪದೇಶಮ್ ಅಶೃಣ್ವನ್ ತೇಷಾಂ ಪ್ರಾಯೇಣ ಪಞ್ಚಸಹಸ್ರಾಣಿ ಜನಾ ವ್ಯಶ್ವಸನ್| ");
INSERT INTO sankan_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","ಪರೇಽಹನಿ ಅಧಿಪತಯಃ ಪ್ರಾಚೀನಾ ಅಧ್ಯಾಪಕಾಶ್ಚ ಹಾನನನಾಮಾ ಮಹಾಯಾಜಕಃ ");
INSERT INTO sankan_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ಕಿಯಫಾ ಯೋಹನ್ ಸಿಕನ್ದರ ಇತ್ಯಾದಯೋ ಮಹಾಯಾಜಕಸ್ಯ ಜ್ಞಾತಯಃ ಸರ್ವ್ವೇ ಯಿರೂಶಾಲಮ್ನಗರೇ ಮಿಲಿತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","ಅನನ್ತರಂ ಪ್ರೇರಿತೌ ಮಧ್ಯೇ ಸ್ಥಾಪಯಿತ್ವಾಪೃಚ್ಛನ್ ಯುವಾಂ ಕಯಾ ಶಕ್ತಯಾ ವಾ ಕೇನ ನಾಮ್ನಾ ಕರ್ಮ್ಮಾಣ್ಯೇತಾನಿ ಕುರುಥಃ? ");
INSERT INTO sankan_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","ತದಾ ಪಿತರಃ ಪವಿತ್ರೇಣಾತ್ಮನಾ ಪರಿಪೂರ್ಣಃ ಸನ್ ಪ್ರತ್ಯವಾದೀತ್, ಹೇ ಲೋಕಾನಾಮ್ ಅಧಿಪತಿಗಣ ಹೇ ಇಸ್ರಾಯೇಲೀಯಪ್ರಾಚೀನಾಃ, ");
INSERT INTO sankan_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ಏತಸ್ಯ ದುರ್ಬ್ಬಲಮಾನುಷಸ್ಯ ಹಿತಂ ಯತ್ ಕರ್ಮ್ಮಾಕ್ರಿಯತ, ಅರ್ಥಾತ್, ಸ ಯೇನ ಪ್ರಕಾರೇಣ ಸ್ವಸ್ಥೋಭವತ್ ತಚ್ಚೇದ್ ಅದ್ಯಾವಾಂ ಪೃಚ್ಛಥ, ");
INSERT INTO sankan_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ತರ್ಹಿ ಸರ್ವ್ವ ಇಸ್ರಾಯೇेಲೀಯಲೋಕಾ ಯೂಯಂ ಜಾನೀತ ನಾಸರತೀಯೋ ಯೋ ಯೀಶುಖ್ರೀಷ್ಟಃ ಕ್ರುಶೇ ಯುಷ್ಮಾಭಿರವಿಧ್ಯತ ಯಶ್ಚೇಶ್ವರೇಣ ಶ್ಮಶಾನಾದ್ ಉತ್ಥಾಪಿತಃ, ತಸ್ಯ ನಾಮ್ನಾ ಜನೋಯಂ ಸ್ವಸ್ಥಃ ಸನ್ ಯುಷ್ಮಾಕಂ ಸಮ್ಮುಖೇ ಪ್ರೋತ್ತಿಷ್ಠತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","ನಿಚೇತೃಭಿ ರ್ಯುಷ್ಮಾಭಿರಯಂ ಯಃ ಪ್ರಸ್ತರೋಽವಜ್ಞಾತೋಽಭವತ್ ಸ ಪ್ರಧಾನಕೋಣಸ್ಯ ಪ್ರಸ್ತರೋಽಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","ತದ್ಭಿನ್ನಾದಪರಾತ್ ಕಸ್ಮಾದಪಿ ಪರಿತ್ರಾಣಂ ಭವಿತುಂ ನ ಶಕ್ನೋತಿ, ಯೇನ ತ್ರಾಣಂ ಪ್ರಾಪ್ಯೇತ ಭೂಮಣ್ಡಲಸ್ಯಲೋಕಾನಾಂ ಮಧ್ಯೇ ತಾದೃಶಂ ಕಿಮಪಿ ನಾಮ ನಾಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ತದಾ ಪಿತರಯೋಹನೋರೇತಾದೃಶೀಮ್ ಅಕ್ಷೇಭತಾಂ ದೃಷ್ಟ್ವಾ ತಾವವಿದ್ವಾಂಸೌ ನೀಚಲೋಕಾವಿತಿ ಬುದ್ಧ್ವಾ ಆಶ್ಚರ್ಯ್ಯಮ್ ಅಮನ್ಯನ್ತ ತೌ ಚ ಯೀಶೋಃ ಸಙ್ಗಿನೌ ಜಾತಾವಿತಿ ಜ್ಞಾತುಮ್ ಅಶಕ್ನುವನ್| ");
INSERT INTO sankan_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","ಕಿನ್ತು ತಾಭ್ಯಾಂ ಸಾರ್ದ್ಧಂ ತಂ ಸ್ವಸ್ಥಮಾನುಷಂ ತಿಷ್ಠನ್ತಂ ದೃಷ್ಟ್ವಾ ತೇ ಕಾಮಪ್ಯಪರಾಮ್ ಆಪತ್ತಿಂ ಕರ್ತ್ತಂ ನಾಶಕ್ನುನ್| ");
INSERT INTO sankan_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","ತದಾ ತೇ ಸಭಾತಃ ಸ್ಥಾನಾನ್ತರಂ ಗನ್ತುಂ ತಾನ್ ಆಜ್ಞಾಪ್ಯ ಸ್ವಯಂ ಪರಸ್ಪರಮ್ ಇತಿ ಮನ್ತ್ರಣಾಮಕುರ್ವ್ವನ್ ");
INSERT INTO sankan_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ತೌ ಮಾನವೌ ಪ್ರತಿ ಕಿಂ ಕರ್ತ್ತವ್ಯಂ? ತಾವೇಕಂ ಪ್ರಸಿದ್ಧಮ್ ಆಶ್ಚರ್ಯ್ಯಂ ಕರ್ಮ್ಮ ಕೃತವನ್ತೌ ತದ್ ಯಿರೂಶಾಲಮ್ನಿವಾಸಿನಾಂ ಸರ್ವ್ವೇಷಾಂ ಲೋಕಾನಾಂ ಸಮೀಪೇ ಪ್ರಾಕಾಶತ ತಚ್ಚ ವಯಮಪಹ್ನೋತುಂ ನ ಶಕ್ನುಮಃ| ");
INSERT INTO sankan_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","ಕಿನ್ತು ಲೋಕಾನಾಂ ಮಧ್ಯಮ್ ಏತದ್ ಯಥಾ ನ ವ್ಯಾಪ್ನೋತಿ ತದರ್ಥಂ ತೌ ಭಯಂ ಪ್ರದರ್ಶ್ಯ ತೇನ ನಾಮ್ನಾ ಕಮಪಿ ಮನುಷ್ಯಂ ನೋಪದಿಶತಮ್ ಇತಿ ದೃಢಂ ನಿಷೇಧಾಮಃ| ");
INSERT INTO sankan_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ತತಸ್ತೇ ಪ್ರೇರಿತಾವಾಹೂಯ ಏತದಾಜ್ಞಾಪಯನ್ ಇತಃ ಪರಂ ಯೀಶೋ ರ್ನಾಮ್ನಾ ಕದಾಪಿ ಕಾಮಪಿ ಕಥಾಂ ಮಾ ಕಥಯತಂ ಕಿಮಪಿ ನೋಪದಿಶಞ್ಚ| ");
INSERT INTO sankan_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","ತತಃ ಪಿತರಯೋಹನೌ ಪ್ರತ್ಯವದತಾಮ್ ಈಶ್ವರಸ್ಯಾಜ್ಞಾಗ್ರಹಣಂ ವಾ ಯುಷ್ಮಾಕಮ್ ಆಜ್ಞಾಗ್ರಹಣಮ್ ಏತಯೋ ರ್ಮಧ್ಯೇ ಈಶ್ವರಸ್ಯ ಗೋಚರೇ ಕಿಂ ವಿಹಿತಂ? ಯೂಯಂ ತಸ್ಯ ವಿವೇಚನಾಂ ಕುರುತ| ");
INSERT INTO sankan_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","ವಯಂ ಯದ್ ಅಪಶ್ಯಾಮ ಯದಶೃಣುಮ ಚ ತನ್ನ ಪ್ರಚಾರಯಿಷ್ಯಾಮ ಏತತ್ ಕದಾಪಿ ಭವಿತುಂ ನ ಶಕ್ನೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","ಯದಘಟತ ತದ್ ದೃಷ್ಟಾ ಸರ್ವ್ವೇ ಲೋಕಾ ಈಶ್ವರಸ್ಯ ಗುಣಾನ್ ಅನ್ವವದನ್ ತಸ್ಮಾತ್ ಲೋಕಭಯಾತ್ ತೌ ದಣ್ಡಯಿತುಂ ಕಮಪ್ಯುಪಾಯಂ ನ ಪ್ರಾಪ್ಯ ತೇ ಪುನರಪಿ ತರ್ಜಯಿತ್ವಾ ತಾವತ್ಯಜನ್| ");
INSERT INTO sankan_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ಯಸ್ಯ ಮಾನುಷಸ್ಯೈತತ್ ಸ್ವಾಸ್ಥ್ಯಕರಣಮ್ ಆಶ್ಚರ್ಯ್ಯಂ ಕರ್ಮ್ಮಾಕ್ರಿಯತ ತಸ್ಯ ವಯಶ್ಚತ್ವಾರಿಂಶದ್ವತ್ಸರಾ ವ್ಯತೀತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ತತಃ ಪರಂ ತೌ ವಿಸೃಷ್ಟೌ ಸನ್ತೌ ಸ್ವಸಙ್ಗಿನಾಂ ಸನ್ನಿಧಿಂ ಗತ್ವಾ ಪ್ರಧಾನಯಾಜಕೈಃ ಪ್ರಾಚೀನಲೋಕೈಶ್ಚ ಪ್ರೋಕ್ತಾಃ ಸರ್ವ್ವಾಃ ಕಥಾ ಜ್ಞಾಪಿತವನ್ತೌ| ");
INSERT INTO sankan_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ತಚ್ಛ್ರುತ್ವಾ ಸರ್ವ್ವ ಏಕಚಿತ್ತೀಭೂಯ ಈಶ್ವರಮುದ್ದಿಶ್ಯ ಪ್ರೋಚ್ಚೈರೇತತ್ ಪ್ರಾರ್ಥಯನ್ತ, ಹೇ ಪ್ರಭೋ ಗಗಣಪೃಥಿವೀಪಯೋಧೀನಾಂ ತೇಷು ಚ ಯದ್ಯದ್ ಆಸ್ತೇ ತೇಷಾಂ ಸ್ರಷ್ಟೇಶ್ವರಸ್ತ್ವಂ| ");
INSERT INTO sankan_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ತ್ವಂ ನಿಜಸೇವಕೇನ ದಾಯೂದಾ ವಾಕ್ಯಮಿದಮ್ ಉವಚಿಥ, ಮನುಷ್ಯಾ ಅನ್ಯದೇಶೀಯಾಃ ಕುರ್ವ್ವನ್ತಿ ಕಲಹಂ ಕುತಃ| ಲೋಕಾಃ ಸರ್ವ್ವೇ ಕಿಮರ್ಥಂ ವಾ ಚಿನ್ತಾಂ ಕುರ್ವ್ವನ್ತಿ ನಿಷ್ಫಲಾಂ| ");
INSERT INTO sankan_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ಪರಮೇಶಸ್ಯ ತೇನೈವಾಭಿಷಿಕ್ತಸ್ಯ ಜನಸ್ಯ ಚ| ವಿರುದ್ಧಮಭಿತಿಷ್ಠನ್ತಿ ಪೃಥಿವ್ಯಾಃ ಪತಯಃ ಕುತಃ|| ");
INSERT INTO sankan_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","ಫಲತಸ್ತವ ಹಸ್ತೇನ ಮನ್ತ್ರಣಯಾ ಚ ಪೂರ್ವ್ವ ಯದ್ಯತ್ ಸ್ಥಿರೀಕೃತಂ ತದ್ ಯಥಾ ಸಿದ್ಧಂ ಭವತಿ ತದರ್ಥಂ ತ್ವಂ ಯಮ್ ಅಥಿಷಿಕ್ತವಾನ್ ಸ ಏವ ಪವಿತ್ರೋ ಯೀಶುಸ್ತಸ್ಯ ಪ್ರಾತಿಕೂಲ್ಯೇನ ಹೇರೋದ್ ಪನ್ತೀಯಪೀಲಾತೋ ");
INSERT INTO sankan_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ಽನ್ಯದೇಶೀಯಲೋಕಾ ಇಸ್ರಾಯೇಲ್ಲೋಕಾಶ್ಚ ಸರ್ವ್ವ ಏತೇ ಸಭಾಯಾಮ್ ಅತಿಷ್ಠನ್| ");
INSERT INTO sankan_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ಹೇ ಪರಮೇಶ್ವರ ಅಧುನಾ ತೇಷಾಂ ತರ್ಜನಂ ಗರ್ಜನಞ್ಚ ಶೃಣು; ");
INSERT INTO sankan_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ತಥಾ ಸ್ವಾಸ್ಥ್ಯಕರಣಕರ್ಮ್ಮಣಾ ತವ ಬಾಹುಬಲಪ್ರಕಾಶಪೂರ್ವ್ವಕಂ ತವ ಸೇವಕಾನ್ ನಿರ್ಭಯೇನ ತವ ವಾಕ್ಯಂ ಪ್ರಚಾರಯಿತುಂ ತವ ಪವಿತ್ರಪುತ್ರಸ್ಯ ಯೀಶೋ ರ್ನಾಮ್ನಾ ಆಶ್ಚರ್ಯ್ಯಾಣ್ಯಸಮ್ಭವಾನಿ ಚ ಕರ್ಮ್ಮಾಣಿ ಕರ್ತ್ತುಞ್ಚಾಜ್ಞಾಪಯ| ");
INSERT INTO sankan_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ಇತ್ಥಂ ಪ್ರಾರ್ಥನಯಾ ಯತ್ರ ಸ್ಥಾನೇ ತೇ ಸಭಾಯಾಮ್ ಆಸನ್ ತತ್ ಸ್ಥಾನಂ ಪ್ರಾಕಮ್ಪತ; ತತಃ ಸರ್ವ್ವೇ ಪವಿತ್ರೇಣಾತ್ಮನಾ ಪರಿಪೂರ್ಣಾಃ ಸನ್ತ ಈಶ್ವರಸ್ಯ ಕಥಾಮ್ ಅಕ್ಷೋಭೇಣ ಪ್ರಾಚಾರಯನ್| ");
INSERT INTO sankan_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","ಅಪರಞ್ಚ ಪ್ರತ್ಯಯಕಾರಿಲೋಕಸಮೂಹಾ ಏಕಮನಸ ಏಕಚಿತ್ತೀಭೂಯ ಸ್ಥಿತಾಃ| ತೇಷಾಂ ಕೇಪಿ ನಿಜಸಮ್ಪತ್ತಿಂ ಸ್ವೀಯಾಂ ನಾಜಾನನ್ ಕಿನ್ತು ತೇಷಾಂ ಸರ್ವ್ವಾಃ ಸಮ್ಪತ್ತ್ಯಃ ಸಾಧಾರಣ್ಯೇನ ಸ್ಥಿತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","ಅನ್ಯಚ್ಚ ಪ್ರೇರಿತಾ ಮಹಾಶಕ್ತಿಪ್ರಕಾಶಪೂರ್ವ್ವಕಂ ಪ್ರಭೋ ರ್ಯೀಶೋರುತ್ಥಾನೇ ಸಾಕ್ಷ್ಯಮ್ ಅದದುಃ, ತೇಷು ಸರ್ವ್ವೇಷು ಮಹಾನುಗ್ರಹೋಽಭವಚ್ಚ| ");
INSERT INTO sankan_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","ತೇಷಾಂ ಮಧ್ಯೇ ಕಸ್ಯಾಪಿ ದ್ರವ್ಯನ್ಯೂನತಾ ನಾಭವದ್ ಯತಸ್ತೇಷಾಂ ಗೃಹಭೂಮ್ಯಾದ್ಯಾ ಯಾಃ ಸಮ್ಪತ್ತಯ ಆಸನ್ ತಾ ವಿಕ್ರೀಯ ");
INSERT INTO sankan_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ತನ್ಮೂಲ್ಯಮಾನೀಯ ಪ್ರೇರಿತಾನಾಂ ಚರಣೇಷು ತೈಃ ಸ್ಥಾಪಿತಂ; ತತಃ ಪ್ರತ್ಯೇಕಶಃ ಪ್ರಯೋಜನಾನುಸಾರೇಣ ದತ್ತಮಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","ವಿಶೇಷತಃ ಕುಪ್ರೋಪದ್ವೀಪೀಯೋ ಯೋಸಿನಾಮಕೋ ಲೇವಿವಂಶಜಾತ ಏಕೋ ಜನೋ ಭೂಮ್ಯಧಿಕಾರೀ, ಯಂ ಪ್ರೇರಿತಾ ಬರ್ಣಬ್ಬಾ ಅರ್ಥಾತ್ ಸಾನ್ತ್ವನಾದಾಯಕ ಇತ್ಯುಕ್ತ್ವಾ ಸಮಾಹೂಯನ್, ");
INSERT INTO sankan_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ಸ ಜನೋ ನಿಜಭೂಮಿಂ ವಿಕ್ರೀಯ ತನ್ಮೂಲ್ಯಮಾನೀಯ ಪ್ರೇರಿತಾನಾಂ ಚರಣೇಷು ಸ್ಥಾಪಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","ತದಾ ಅನಾನಿಯನಾಮಕ ಏಕೋ ಜನೋ ಯಸ್ಯ ಭಾರ್ಯ್ಯಾಯಾ ನಾಮ ಸಫೀರಾ ಸ ಸ್ವಾಧಿಕಾರಂ ವಿಕ್ರೀಯ ");
INSERT INTO sankan_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ಸ್ವಭಾರ್ಯ್ಯಾಂ ಜ್ಞಾಪಯಿತ್ವಾ ತನ್ಮೂಲ್ಯಸ್ಯೈಕಾಂಶಂ ಸಙ್ಗೋಪ್ಯ ಸ್ಥಾಪಯಿತ್ವಾ ತದನ್ಯಾಂಶಮಾತ್ರಮಾನೀಯ ಪ್ರೇರಿತಾನಾಂ ಚರಣೇಷು ಸಮರ್ಪಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ತಸ್ಮಾತ್ ಪಿತರೋಕಥಯತ್ ಹೇ ಅನಾನಿಯ ಭೂಮೇ ರ್ಮೂಲ್ಯಂ ಕಿಞ್ಚಿತ್ ಸಙ್ಗೋಪ್ಯ ಸ್ಥಾಪಯಿತುಂ ಪವಿತ್ರಸ್ಯಾತ್ಮನಃ ಸನ್ನಿಧೌ ಮೃಷಾವಾಕ್ಯಂ ಕಥಯಿತುಞ್ಚ ಶೈತಾನ್ ಕುತಸ್ತವಾನ್ತಃಕರಣೇ ಪ್ರವೃತ್ತಿಮಜನಯತ್? ");
INSERT INTO sankan_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","ಸಾ ಭೂಮಿ ರ್ಯದಾ ತವ ಹಸ್ತಗತಾ ತದಾ ಕಿಂ ತವ ಸ್ವೀಯಾ ನಾಸೀತ್? ತರ್ಹಿ ಸ್ವಾನ್ತಃಕರಣೇ ಕುತ ಏತಾದೃಶೀ ಕುಕಲ್ಪನಾ ತ್ವಯಾ ಕೃತಾ? ತ್ವಂ ಕೇವಲಮನುಷ್ಯಸ್ಯ ನಿಕಟೇ ಮೃಷಾವಾಕ್ಯಂ ನಾವಾದೀಃ ಕಿನ್ತ್ವೀಶ್ವರಸ್ಯ ನಿಕಟೇಽಪಿ| ");
INSERT INTO sankan_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ಏತಾಂ ಕಥಾಂ ಶ್ರುತ್ವೈವ ಸೋಽನಾನಿಯೋ ಭೂಮೌ ಪತನ್ ಪ್ರಾಣಾನ್ ಅತ್ಯಜತ್, ತದ್ವೃತ್ತಾನ್ತಂ ಯಾವನ್ತೋ ಲೋಕಾ ಅಶೃಣ್ವನ್ ತೇಷಾಂ ಸರ್ವ್ವೇಷಾಂ ಮಹಾಭಯಮ್ ಅಜಾಯತ್| ");
INSERT INTO sankan_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","ತದಾ ಯುವಲೋಕಾಸ್ತಂ ವಸ್ತ್ರೇಣಾಚ್ಛಾದ್ಯ ಬಹಿ ರ್ನೀತ್ವಾ ಶ್ಮಶಾನೇಽಸ್ಥಾಪಯನ್| ");
INSERT INTO sankan_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","ತತಃ ಪ್ರಹರೈಕಾನನ್ತರಂ ಕಿಂ ವೃತ್ತಂ ತನ್ನಾವಗತ್ಯ ತಸ್ಯ ಭಾರ್ಯ್ಯಾಪಿ ತತ್ರ ಸಮುಪಸ್ಥಿತಾ| ");
INSERT INTO sankan_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ತತಃ ಪಿತರಸ್ತಾಮ್ ಅಪೃಚ್ಛತ್, ಯುವಾಭ್ಯಾಮ್ ಏತಾವನ್ಮುದ್ರಾಭ್ಯೋ ಭೂಮಿ ರ್ವಿಕ್ರೀತಾ ನ ವಾ? ಏತತ್ವಂ ವದ; ತದಾ ಸಾ ಪ್ರತ್ಯವಾದೀತ್ ಸತ್ಯಮ್ ಏತಾವದ್ಭ್ಯೋ ಮುದ್ರಾಭ್ಯ ಏವ| ");
INSERT INTO sankan_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ತತಃ ಪಿತರೋಕಥಯತ್ ಯುವಾಂ ಕಥಂ ಪರಮೇಶ್ವರಸ್ಯಾತ್ಮಾನಂ ಪರೀಕ್ಷಿತುಮ್ ಏಕಮನ್ತ್ರಣಾವಭವತಾಂ? ಪಶ್ಯ ಯೇ ತವ ಪತಿಂ ಶ್ಮಶಾನೇ ಸ್ಥಾಪಿತವನ್ತಸ್ತೇ ದ್ವಾರಸ್ಯ ಸಮೀಪೇ ಸಮುಪತಿಷ್ಠನ್ತಿ ತ್ವಾಮಪಿ ಬಹಿರ್ನೇಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ತತಃ ಸಾಪಿ ತಸ್ಯ ಚರಣಸನ್ನಿಧೌ ಪತಿತ್ವಾ ಪ್ರಾಣಾನ್ ಅತ್ಯಾಕ್ಷೀತ್| ಪಶ್ಚಾತ್ ತೇ ಯುವಾನೋಽಭ್ಯನ್ತರಮ್ ಆಗತ್ಯ ತಾಮಪಿ ಮೃತಾಂ ದೃಷ್ಟ್ವಾ ಬಹಿ ರ್ನೀತ್ವಾ ತಸ್ಯಾಃ ಪತ್ಯುಃ ಪಾರ್ಶ್ವೇ ಶ್ಮಶಾನೇ ಸ್ಥಾಪಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","ತಸ್ಮಾತ್ ಮಣ್ಡಲ್ಯಾಃ ಸರ್ವ್ವೇ ಲೋಕಾ ಅನ್ಯಲೋಕಾಶ್ಚ ತಾಂ ವಾರ್ತ್ತಾಂ ಶ್ರುತ್ವಾ ಸಾಧ್ವಸಂ ಗತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","ತತಃ ಪರಂ ಪ್ರೇರಿತಾನಾಂ ಹಸ್ತೈ ರ್ಲೋಕಾನಾಂ ಮಧ್ಯೇ ಬಹ್ವಾಶ್ಚರ್ಯ್ಯಾಣ್ಯದ್ಭುತಾನಿ ಕರ್ಮ್ಮಾಣ್ಯಕ್ರಿಯನ್ತ; ತದಾ ಶಿಷ್ಯಾಃ ಸರ್ವ್ವ ಏಕಚಿತ್ತೀಭೂಯ ಸುಲೇಮಾನೋ ಽಲಿನ್ದೇ ಸಮ್ಭೂಯಾಸನ್| ");
INSERT INTO sankan_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","ತೇಷಾಂ ಸಙ್ಘಾನ್ತರ್ಗೋ ಭವಿತುಂ ಕೋಪಿ ಪ್ರಗಲ್ಭತಾಂ ನಾಗಮತ್ ಕಿನ್ತು ಲೋಕಾಸ್ತಾನ್ ಸಮಾದ್ರಿಯನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","ಸ್ತ್ರಿಯಃ ಪುರುಷಾಶ್ಚ ಬಹವೋ ಲೋಕಾ ವಿಶ್ವಾಸ್ಯ ಪ್ರಭುಂ ಶರಣಮಾಪನ್ನಾಃ| ");
INSERT INTO sankan_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","ಪಿತರಸ್ಯ ಗಮನಾಗಮನಾಭ್ಯಾಂ ಕೇನಾಪಿ ಪ್ರಕಾರೇಣ ತಸ್ಯ ಛಾಯಾ ಕಸ್ಮಿಂಶ್ಚಿಜ್ಜನೇ ಲಗಿಷ್ಯತೀತ್ಯಾಶಯಾ ಲೋಕಾ ರೋಗಿಣಃ ಶಿವಿಕಯಾ ಖಟ್ವಯಾ ಚಾನೀಯ ಪಥಿ ಪಥಿ ಸ್ಥಾಪಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","ಚತುರ್ದಿಕ್ಸ್ಥನಗರೇಭ್ಯೋ ಬಹವೋ ಲೋಕಾಃ ಸಮ್ಭೂಯ ರೋಗಿಣೋಽಪವಿತ್ರಭುತಗ್ರಸ್ತಾಂಶ್ಚ ಯಿರೂಶಾಲಮಮ್ ಆನಯನ್ ತತಃ ಸರ್ವ್ವೇ ಸ್ವಸ್ಥಾ ಅಕ್ರಿಯನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","ಅನನ್ತರಂ ಮಹಾಯಾಜಕಃ ಸಿದೂಕಿನಾಂ ಮತಗ್ರಾಹಿಣಸ್ತೇಷಾಂ ಸಹಚರಾಶ್ಚ ");
INSERT INTO sankan_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ಮಹಾಕ್ರೋಧಾನ್ತ್ವಿತಾಃ ಸನ್ತಃ ಪ್ರೇರಿತಾನ್ ಧೃತ್ವಾ ನೀಚಲೋಕಾನಾಂ ಕಾರಾಯಾಂ ಬದ್ಧ್ವಾ ಸ್ಥಾಪಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","ಕಿನ್ತು ರಾತ್ರೌ ಪರಮೇಶ್ವರಸ್ಯ ದೂತಃ ಕಾರಾಯಾ ದ್ವಾರಂ ಮೋಚಯಿತ್ವಾ ತಾನ್ ಬಹಿರಾನೀಯಾಕಥಯತ್, ");
INSERT INTO sankan_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","ಯೂಯಂ ಗತ್ವಾ ಮನ್ದಿರೇ ದಣ್ಡಾಯಮಾನಾಃ ಸನ್ತೋ ಲೋಕಾನ್ ಪ್ರತೀಮಾಂ ಜೀವನದಾಯಿಕಾಂ ಸರ್ವ್ವಾಂ ಕಥಾಂ ಪ್ರಚಾರಯತ| ");
INSERT INTO sankan_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ಇತಿ ಶ್ರುತ್ವಾ ತೇ ಪ್ರತ್ಯೂಷೇ ಮನ್ದಿರ ಉಪಸ್ಥಾಯ ಉಪದಿಷ್ಟವನ್ತಃ| ತದಾ ಸಹಚರಗಣೇನ ಸಹಿತೋ ಮಹಾಯಾಜಕ ಆಗತ್ಯ ಮನ್ತ್ರಿಗಣಮ್ ಇಸ್ರಾಯೇಲ್ವಂಶಸ್ಯ ಸರ್ವ್ವಾನ್ ರಾಜಸಭಾಸದಃ ಸಭಾಸ್ಥಾನ್ ಕೃತ್ವಾ ಕಾರಾಯಾಸ್ತಾನ್ ಆಪಯಿತುಂ ಪದಾತಿಗಣಂ ಪ್ರೇರಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","ತತಸ್ತೇ ಗತ್ವಾ ಕಾರಾಯಾಂ ತಾನ್ ಅಪ್ರಾಪ್ಯ ಪ್ರತ್ಯಾಗತ್ಯ ಇತಿ ವಾರ್ತ್ತಾಮ್ ಅವಾದಿಷುಃ, ");
INSERT INTO sankan_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ವಯಂ ತತ್ರ ಗತ್ವಾ ನಿರ್ವ್ವಿಘ್ನಂ ಕಾರಾಯಾ ದ್ವಾರಂ ರುದ್ಧಂ ರಕ್ಷಕಾಂಶ್ಚ ದ್ವಾರಸ್ಯ ಬಹಿರ್ದಣ್ಡಾಯಮಾನಾನ್ ಅದರ್ಶಾಮ ಏವ ಕಿನ್ತು ದ್ವಾರಂ ಮೋಚಯಿತ್ವಾ ತನ್ಮಧ್ಯೇ ಕಮಪಿ ದ್ರಷ್ಟುಂ ನ ಪ್ರಾಪ್ತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ಏತಾಂ ಕಥಾಂ ಶ್ರುತ್ವಾ ಮಹಾಯಾಜಕೋ ಮನ್ದಿರಸ್ಯ ಸೇನಾಪತಿಃ ಪ್ರಧಾನಯಾಜಕಾಶ್ಚ, ಇತ ಪರಂ ಕಿಮಪರಂ ಭವಿಷ್ಯತೀತಿ ಚಿನ್ತಯಿತ್ವಾ ಸನ್ದಿಗ್ಧಚಿತ್ತಾ ಅಭವನ್| ");
INSERT INTO sankan_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ಏತಸ್ಮಿನ್ನೇವ ಸಮಯೇ ಕಶ್ಚಿತ್ ಜನ ಆಗತ್ಯ ವಾರ್ತ್ತಾಮೇತಾಮ್ ಅವದತ್ ಪಶ್ಯತ ಯೂಯಂ ಯಾನ್ ಮಾನವಾನ್ ಕಾರಾಯಾಮ್ ಅಸ್ಥಾಪಯತ ತೇ ಮನ್ದಿರೇ ತಿಷ್ಠನ್ತೋ ಲೋಕಾನ್ ಉಪದಿಶನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","ತದಾ ಮನ್ದಿರಸ್ಯ ಸೇನಾಪತಿಃ ಪದಾತಯಶ್ಚ ತತ್ರ ಗತ್ವಾ ಚೇಲ್ಲೋಕಾಃ ಪಾಷಾಣಾನ್ ನಿಕ್ಷಿಪ್ಯಾಸ್ಮಾನ್ ಮಾರಯನ್ತೀತಿ ಭಿಯಾ ವಿನತ್ಯಾಚಾರಂ ತಾನ್ ಆನಯನ್| ");
INSERT INTO sankan_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","ತೇ ಮಹಾಸಭಾಯಾ ಮಧ್ಯೇ ತಾನ್ ಅಸ್ಥಾಪಯನ್ ತತಃ ಪರಂ ಮಹಾಯಾಜಕಸ್ತಾನ್ ಅಪೃಚ್ಛತ್, ");
INSERT INTO sankan_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","ಅನೇನ ನಾಮ್ನಾ ಸಮುಪದೇಷ್ಟುಂ ವಯಂ ಕಿಂ ದೃಢಂ ನ ನ್ಯಷೇಧಾಮ? ತಥಾಪಿ ಪಶ್ಯತ ಯೂಯಂ ಸ್ವೇಷಾಂ ತೇನೋಪದೇಶೇನೇ ಯಿರೂಶಾಲಮಂ ಪರಿಪೂರ್ಣಂ ಕೃತ್ವಾ ತಸ್ಯ ಜನಸ್ಯ ರಕ್ತಪಾತಜನಿತಾಪರಾಧಮ್ ಅಸ್ಮಾನ್ ಪ್ರತ್ಯಾನೇತುಂ ಚೇಷ್ಟಧ್ವೇ| ");
INSERT INTO sankan_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","ತತಃ ಪಿತರೋನ್ಯಪ್ರೇರಿತಾಶ್ಚ ಪ್ರತ್ಯವದನ್ ಮಾನುಷಸ್ಯಾಜ್ಞಾಗ್ರಹಣಾದ್ ಈಶ್ವರಸ್ಯಾಜ್ಞಾಗ್ರಹಣಮ್ ಅಸ್ಮಾಕಮುಚಿತಮ್| ");
INSERT INTO sankan_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","ಯಂ ಯೀಶುಂ ಯೂಯಂ ಕ್ರುಶೇ ವೇಧಿತ್ವಾಹತ ತಮ್ ಅಸ್ಮಾಕಂ ಪೈತೃಕ ಈಶ್ವರ ಉತ್ಥಾಪ್ಯ ");
INSERT INTO sankan_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ಇಸ್ರಾಯೇಲ್ವಂಶಾನಾಂ ಮನಃಪರಿವರ್ತ್ತನಂ ಪಾಪಕ್ಷಮಾಞ್ಚ ಕರ್ತ್ತುಂ ರಾಜಾನಂ ಪರಿತ್ರಾತಾರಞ್ಚ ಕೃತ್ವಾ ಸ್ವದಕ್ಷಿಣಪಾರ್ಶ್ವೇ ತಸ್ಯಾನ್ನತಿಮ್ ಅಕರೋತ್| ");
INSERT INTO sankan_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ಏತಸ್ಮಿನ್ ವಯಮಪಿ ಸಾಕ್ಷಿಣ ಆಸ್ಮಹೇ, ತತ್ ಕೇವಲಂ ನಹಿ, ಈಶ್ವರ ಆಜ್ಞಾಗ್ರಾಹಿಭ್ಯೋ ಯಂ ಪವಿತ್ರಮ್ ಆತ್ಮನಂ ದತ್ತವಾನ್ ಸೋಪಿ ಸಾಕ್ಷ್ಯಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","ಏತದ್ವಾಕ್ಯೇ ಶ್ರುತೇ ತೇಷಾಂ ಹೃದಯಾನಿ ವಿದ್ಧಾನ್ಯಭವನ್ ತತಸ್ತೇ ತಾನ್ ಹನ್ತುಂ ಮನ್ತ್ರಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ಏತಸ್ಮಿನ್ನೇವ ಸಮಯೇ ತತ್ಸಭಾಸ್ಥಾನಾಂ ಸರ್ವ್ವಲೋಕಾನಾಂ ಮಧ್ಯೇ ಸುಖ್ಯಾತೋ ಗಮಿಲೀಯೇಲ್ನಾಮಕ ಏಕೋ ಜನೋ ವ್ಯವಸ್ಥಾಪಕಃ ಫಿರೂಶಿಲೋಕ ಉತ್ಥಾಯ ಪ್ರೇರಿತಾನ್ ಕ್ಷಣಾರ್ಥಂ ಸ್ಥಾನಾನ್ತರಂ ಗನ್ತುಮ್ ಆದಿಶ್ಯ ಕಥಿತವಾನ್, ");
INSERT INTO sankan_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ಹೇ ಇಸ್ರಾಯೇಲ್ವಂಶೀಯಾಃ ಸರ್ವ್ವೇ ಯೂಯಮ್ ಏತಾನ್ ಮಾನುಷಾನ್ ಪ್ರತಿ ಯತ್ ಕರ್ತ್ತುಮ್ ಉದ್ಯತಾಸ್ತಸ್ಮಿನ್ ಸಾವಧಾನಾ ಭವತ| ");
INSERT INTO sankan_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","ಇತಃ ಪೂರ್ವ್ವಂ ಥೂದಾನಾಮೈಕೋ ಜನ ಉಪಸ್ಥಾಯ ಸ್ವಂ ಕಮಪಿ ಮಹಾಪುರುಷಮ್ ಅವದತ್, ತತಃ ಪ್ರಾಯೇಣ ಚತುಃಶತಲೋಕಾಸ್ತಸ್ಯ ಮತಗ್ರಾಹಿಣೋಭವನ್ ಪಶ್ಚಾತ್ ಸ ಹತೋಭವತ್ ತಸ್ಯಾಜ್ಞಾಗ್ರಾಹಿಣೋ ಯಾವನ್ತೋ ಲೋಕಾಸ್ತೇ ಸರ್ವ್ವೇ ವಿರ್ಕೀರ್ಣಾಃ ಸನ್ತೋ ಽಕೃತಕಾರ್ಯ್ಯಾ ಅಭವನ್| ");
INSERT INTO sankan_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","ತಸ್ಮಾಜ್ಜನಾತ್ ಪರಂ ನಾಮಲೇಖನಸಮಯೇ ಗಾಲೀಲೀಯಯಿಹೂದಾನಾಮೈಕೋ ಜನ ಉಪಸ್ಥಾಯ ಬಹೂಲ್ಲೋಕಾನ್ ಸ್ವಮತಂ ಗ್ರಾಹೀತವಾನ್ ತತಃ ಸೋಪಿ ವ್ಯನಶ್ಯತ್ ತಸ್ಯಾಜ್ಞಾಗ್ರಾಹಿಣೋ ಯಾವನ್ತೋ ಲೋಕಾ ಆಸನ್ ತೇ ಸರ್ವ್ವೇ ವಿಕೀರ್ಣಾ ಅಭವನ್| ");
INSERT INTO sankan_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","ಅಧುನಾ ವದಾಮಿ, ಯೂಯಮ್ ಏತಾನ್ ಮನುಷ್ಯಾನ್ ಪ್ರತಿ ಕಿಮಪಿ ನ ಕೃತ್ವಾ ಕ್ಷಾನ್ತಾ ಭವತ, ಯತ ಏಷ ಸಙ್ಕಲ್ಪ ಏತತ್ ಕರ್ಮ್ಮ ಚ ಯದಿ ಮನುಷ್ಯಾದಭವತ್ ತರ್ಹಿ ವಿಫಲಂ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ಯದೀಶ್ವರಾದಭವತ್ ತರ್ಹಿ ಯೂಯಂ ತಸ್ಯಾನ್ಯಥಾ ಕರ್ತ್ತುಂ ನ ಶಕ್ಷ್ಯಥ, ವರಮ್ ಈಶ್ವರರೋಧಕಾ ಭವಿಷ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ತದಾ ತಸ್ಯ ಮನ್ತ್ರಣಾಂ ಸ್ವೀಕೃತ್ಯ ತೇ ಪ್ರೇರಿತಾನ್ ಆಹೂಯ ಪ್ರಹೃತ್ಯ ಯೀಶೋ ರ್ನಾಮ್ನಾ ಕಾಮಪಿ ಕಥಾಂ ಕಥಯಿತುಂ ನಿಷಿಧ್ಯ ವ್ಯಸರ್ಜನ್| ");
INSERT INTO sankan_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","ಕಿನ್ತು ತಸ್ಯ ನಾಮಾರ್ಥಂ ವಯಂ ಲಜ್ಜಾಭೋಗಸ್ಯ ಯೋಗ್ಯತ್ವೇನ ಗಣಿತಾ ಇತ್ಯತ್ರ ತೇ ಸಾನನ್ದಾಃ ಸನ್ತಃ ಸಭಾಸ್ಥಾನಾಂ ಸಾಕ್ಷಾದ್ ಅಗಚ್ಛನ್| ");
INSERT INTO sankan_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ತತಃ ಪರಂ ಪ್ರತಿದಿನಂ ಮನ್ದಿರೇ ಗೃಹೇ ಗೃಹೇ ಚಾವಿಶ್ರಾಮಮ್ ಉಪದಿಶ್ಯ ಯೀಶುಖ್ರೀಷ್ಟಸ್ಯ ಸುಸಂವಾದಂ ಪ್ರಚಾರಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","ತಸ್ಮಿನ್ ಸಮಯೇ ಶಿಷ್ಯಾಣಾಂ ಬಾಹುಲ್ಯಾತ್ ಪ್ರಾತ್ಯಹಿಕದಾನಸ್ಯ ವಿಶ್ರಾಣನೈ ರ್ಭಿನ್ನದೇಶೀಯಾನಾಂ ವಿಧವಾಸ್ತ್ರೀಗಣ ಉಪೇಕ್ಷಿತೇ ಸತಿ ಇಬ್ರೀಯಲೋಕೈಃ ಸಹಾನ್ಯದೇಶೀಯಾನಾಂ ವಿವಾದ ಉಪಾತಿಷ್ಠತ್| ");
INSERT INTO sankan_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","ತದಾ ದ್ವಾದಶಪ್ರೇರಿತಾಃ ಸರ್ವ್ವಾನ್ ಶಿಷ್ಯಾನ್ ಸಂಗೃಹ್ಯಾಕಥಯನ್ ಈಶ್ವರಸ್ಯ ಕಥಾಪ್ರಚಾರಂ ಪರಿತ್ಯಜ್ಯ ಭೋಜನಗವೇಷಣಮ್ ಅಸ್ಮಾಕಮ್ ಉಚಿತಂ ನಹಿ| ");
INSERT INTO sankan_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ಅತೋ ಹೇ ಭ್ರಾತೃಗಣ ವಯಮ್ ಏತತ್ಕರ್ಮ್ಮಣೋ ಭಾರಂ ಯೇಭ್ಯೋ ದಾತುಂ ಶಕ್ನುಮ ಏತಾದೃಶಾನ್ ಸುಖ್ಯಾತ್ಯಾಪನ್ನಾನ್ ಪವಿತ್ರೇಣಾತ್ಮನಾ ಜ್ಞಾನೇನ ಚ ಪೂರ್ಣಾನ್ ಸಪ್ಪ್ರಜನಾನ್ ಯೂಯಂ ಸ್ವೇಷಾಂ ಮಧ್ಯೇ ಮನೋನೀತಾನ್ ಕುರುತ, ");
INSERT INTO sankan_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ಕಿನ್ತು ವಯಂ ಪ್ರಾರ್ಥನಾಯಾಂ ಕಥಾಪ್ರಚಾರಕರ್ಮ್ಮಣಿ ಚ ನಿತ್ಯಪ್ರವೃತ್ತಾಃ ಸ್ಥಾಸ್ಯಾಮಃ| ");
INSERT INTO sankan_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ಏತಸ್ಯಾಂ ಕಥಾಯಾಂ ಸರ್ವ್ವೇ ಲೋಕಾಃ ಸನ್ತುಷ್ಟಾಃ ಸನ್ತಃ ಸ್ವೇಷಾಂ ಮಧ್ಯಾತ್ ಸ್ತಿಫಾನಃ ಫಿಲಿಪಃ ಪ್ರಖರೋ ನಿಕಾನೋರ್ ತೀಮನ್ ಪರ್ಮ್ಮಿಣಾ ಯಿಹೂದಿಮತಗ್ರಾಹೀ-ಆನ್ತಿಯಖಿಯಾನಗರೀಯೋ ನಿಕಲಾ ಏತಾನ್ ಪರಮಭಕ್ತಾನ್ ಪವಿತ್ರೇಣಾತ್ಮನಾ ಪರಿಪೂರ್ಣಾನ್ ಸಪ್ತ ಜನಾನ್ ");
INSERT INTO sankan_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ಪ್ರೇರಿತಾನಾಂ ಸಮಕ್ಷಮ್ ಆನಯನ್, ತತಸ್ತೇ ಪ್ರಾರ್ಥನಾಂ ಕೃತ್ವಾ ತೇಷಾಂ ಶಿರಃಸು ಹಸ್ತಾನ್ ಆರ್ಪಯನ್| ");
INSERT INTO sankan_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","ಅಪರಞ್ಚ ಈಶ್ವರಸ್ಯ ಕಥಾ ದೇಶಂ ವ್ಯಾಪ್ನೋತ್ ವಿಶೇಷತೋ ಯಿರೂಶಾಲಮಿ ನಗರೇ ಶಿಷ್ಯಾಣಾಂ ಸಂಖ್ಯಾ ಪ್ರಭೂತರೂಪೇಣಾವರ್ದ್ಧತ ಯಾಜಕಾನಾಂ ಮಧ್ಯೇಪಿ ಬಹವಃ ಖ್ರೀಷ್ಟಮತಗ್ರಾಹಿಣೋಽಭವನ್| ");
INSERT INTO sankan_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","ಸ್ತಿಫಾನೋे ವಿಶ್ವಾಸೇನ ಪರಾಕ್ರಮೇಣ ಚ ಪರಿಪೂರ್ಣಃ ಸನ್ ಲೋಕಾನಾಂ ಮಧ್ಯೇ ಬಹುವಿಧಮ್ ಅದ್ಭುತಮ್ ಆಶ್ಚರ್ಯ್ಯಂ ಕರ್ಮ್ಮಾಕರೋತ್| ");
INSERT INTO sankan_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","ತೇನ ಲಿಬರ್ತ್ತಿನೀಯನಾಮ್ನಾ ವಿಖ್ಯಾತಸಙ್ಘಸ್ಯ ಕತಿಪಯಜನಾಃ ಕುರೀಣೀಯಸಿಕನ್ದರೀಯ-ಕಿಲಿಕೀಯಾಶೀಯಾದೇಶೀಯಾಃ ಕಿಯನ್ತೋ ಜನಾಶ್ಚೋತ್ಥಾಯ ಸ್ತಿಫಾನೇನ ಸಾರ್ದ್ಧಂ ವ್ಯವದನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ಕಿನ್ತು ಸ್ತಿಫಾನೋ ಜ್ಞಾನೇನ ಪವಿತ್ರೇಣಾತ್ಮನಾ ಚ ಈದೃಶೀಂ ಕಥಾಂ ಕಥಿತವಾನ್ ಯಸ್ಯಾಸ್ತೇ ಆಪತ್ತಿಂ ಕರ್ತ್ತುಂ ನಾಶಕ್ನುವನ್| ");
INSERT INTO sankan_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","ಪಶ್ಚಾತ್ ತೈ ರ್ಲೋಭಿತಾಃ ಕತಿಪಯಜನಾಃ ಕಥಾಮೇನಾಮ್ ಅಕಥಯನ್, ವಯಂ ತಸ್ಯ ಮುಖತೋ ಮೂಸಾ ಈಶ್ವರಸ್ಯ ಚ ನಿನ್ದಾವಾಕ್ಯಮ್ ಅಶ್ರೌಷ್ಮ| ");
INSERT INTO sankan_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ತೇ ಲೋಕಾನಾಂ ಲೋಕಪ್ರಾಚೀನಾನಾಮ್ ಅಧ್ಯಾಪಕಾನಾಞ್ಚ ಪ್ರವೃತ್ತಿಂ ಜನಯಿತ್ವಾ ಸ್ತಿಫಾನಸ್ಯ ಸನ್ನಿಧಿಮ್ ಆಗತ್ಯ ತಂ ಧೃತ್ವಾ ಮಹಾಸಭಾಮಧ್ಯಮ್ ಆನಯನ್| ");
INSERT INTO sankan_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ತದನನ್ತರಂ ಕತಿಪಯಜನೇಷು ಮಿಥ್ಯಾಸಾಕ್ಷಿಷು ಸಮಾನೀತೇಷು ತೇಽಕಥಯನ್ ಏಷ ಜನ ಏತತ್ಪುಣ್ಯಸ್ಥಾನವ್ಯವಸ್ಥಯೋ ರ್ನಿನ್ದಾತಃ ಕದಾಪಿ ನ ನಿವರ್ತ್ತತೇ| ");
INSERT INTO sankan_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ಫಲತೋ ನಾಸರತೀಯಯೀಶುಃ ಸ್ಥಾನಮೇತದ್ ಉಚ್ಛಿನ್ನಂ ಕರಿಷ್ಯತಿ ಮೂಸಾಸಮರ್ಪಿತಮ್ ಅಸ್ಮಾಕಂ ವ್ಯವಹರಣಮ್ ಅನ್ಯರೂಪಂ ಕರಿಷ್ಯತಿ ತಸ್ಯೈತಾದೃಶೀಂ ಕಥಾಂ ವಯಮ್ ಅಶೃಣುಮ| ");
INSERT INTO sankan_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","ತದಾ ಮಹಾಸಭಾಸ್ಥಾಃ ಸರ್ವ್ವೇ ತಂ ಪ್ರತಿ ಸ್ಥಿರಾಂ ದೃಷ್ಟಿಂ ಕೃತ್ವಾ ಸ್ವರ್ಗದೂತಮುಖಸದೃಶಂ ತಸ್ಯ ಮುಖಮ್ ಅಪಶ್ಯನ್| ");
INSERT INTO sankan_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ತತಃ ಪರಂ ಮಹಾಯಾಜಕಃ ಪೃಷ್ಟವಾನ್, ಏಷಾ ಕಥಾಂ ಕಿಂ ಸತ್ಯಾ? ");
INSERT INTO sankan_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","ತತಃ ಸ ಪ್ರತ್ಯವದತ್, ಹೇ ಪಿತರೋ ಹೇ ಭ್ರಾತರಃ ಸರ್ವ್ವೇ ಲಾಕಾ ಮನಾಂಸಿ ನಿಧದ್ಧ್ವಂ| ಅಸ್ಮಾಕಂ ಪೂರ್ವ್ವಪುರುಷ ಇಬ್ರಾಹೀಮ್ ಹಾರಣ್ನಗರೇ ವಾಸಕರಣಾತ್ ಪೂರ್ವ್ವಂ ಯದಾ ಅರಾಮ್-ನಹರಯಿಮದೇಶೇ ಆಸೀತ್ ತದಾ ತೇಜೋಮಯ ಈಶ್ವರೋ ದರ್ಶನಂ ದತ್ವಾ ");
INSERT INTO sankan_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ತಮವದತ್ ತ್ವಂ ಸ್ವದೇಶಜ್ಞಾತಿಮಿತ್ರಾಣಿ ಪರಿತ್ಯಜ್ಯ ಯಂ ದೇಶಮಹಂ ದರ್ಶಯಿಷ್ಯಾಮಿ ತಂ ದೇಶಂ ವ್ರಜ| ");
INSERT INTO sankan_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","ಅತಃ ಸ ಕಸ್ದೀಯದೇಶಂ ವಿಹಾಯ ಹಾರಣ್ನಗರೇ ನ್ಯವಸತ್, ತದನನ್ತರಂ ತಸ್ಯ ಪಿತರಿ ಮೃತೇ ಯತ್ರ ದೇಶೇ ಯೂಯಂ ನಿವಸಥ ಸ ಏನಂ ದೇಶಮಾಗಚ್ಛತ್| ");
INSERT INTO sankan_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","ಕಿನ್ತ್ವೀಶ್ವರಸ್ತಸ್ಮೈ ಕಮಪ್ಯಧಿಕಾರಮ್ ಅರ್ಥಾದ್ ಏಕಪದಪರಿಮಿತಾಂ ಭೂಮಿಮಪಿ ನಾದದಾತ್; ತದಾ ತಸ್ಯ ಕೋಪಿ ಸನ್ತಾನೋ ನಾಸೀತ್ ತಥಾಪಿ ಸನ್ತಾನೈಃ ಸಾರ್ದ್ಧಮ್ ಏತಸ್ಯ ದೇಶಸ್ಯಾಧಿಕಾರೀ ತ್ವಂ ಭವಿಷ್ಯಸೀತಿ ತಮ್ಪ್ರತ್ಯಙ್ಗೀಕೃತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ಈಶ್ವರ ಇತ್ಥಮ್ ಅಪರಮಪಿ ಕಥಿತವಾನ್ ತವ ಸನ್ತಾನಾಃ ಪರದೇಶೇ ನಿವತ್ಸ್ಯನ್ತಿ ತತಸ್ತದ್ದೇಶೀಯಲೋಕಾಶ್ಚತುಃಶತವತ್ಸರಾನ್ ಯಾವತ್ ತಾನ್ ದಾಸತ್ವೇ ಸ್ಥಾಪಯಿತ್ವಾ ತಾನ್ ಪ್ರತಿ ಕುವ್ಯವಹಾರಂ ಕರಿಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","ಅಪರಮ್ ಈಶ್ವರ ಏನಾಂ ಕಥಾಮಪಿ ಕಥಿತವಾನ್, ಯೇ ಲೋಕಾಸ್ತಾನ್ ದಾಸತ್ವೇ ಸ್ಥಾಪಯಿಷ್ಯನ್ತಿ ತಾಲ್ಲೋಕಾನ್ ಅಹಂ ದಣ್ಡಯಿಷ್ಯಾಮಿ, ತತಃ ಪರಂ ತೇ ಬಹಿರ್ಗತಾಃ ಸನ್ತೋ ಮಾಮ್ ಅತ್ರ ಸ್ಥಾನೇ ಸೇವಿಷ್ಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","ಪಶ್ಚಾತ್ ಸ ತಸ್ಮೈ ತ್ವಕ್ಛೇದಸ್ಯ ನಿಯಮಂ ದತ್ತವಾನ್, ಅತ ಇಸ್ಹಾಕನಾಮ್ನಿ ಇಬ್ರಾಹೀಮ ಏಕಪುತ್ರೇ ಜಾತೇ, ಅಷ್ಟಮದಿನೇ ತಸ್ಯ ತ್ವಕ್ಛೇದಮ್ ಅಕರೋತ್| ತಸ್ಯ ಇಸ್ಹಾಕಃ ಪುತ್ರೋ ಯಾಕೂಬ್, ತತಸ್ತಸ್ಯ ಯಾಕೂಬೋಽಸ್ಮಾಕಂ ದ್ವಾದಶ ಪೂರ್ವ್ವಪುರುಷಾ ಅಜಾಯನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","ತೇ ಪೂರ್ವ್ವಪುರುಷಾ ಈರ್ಷ್ಯಯಾ ಪರಿಪೂರ್ಣಾ ಮಿಸರದೇಶಂ ಪ್ರೇಷಯಿತುಂ ಯೂಷಫಂ ವ್ಯಕ್ರೀಣನ್| ");
INSERT INTO sankan_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ಕಿನ್ತ್ವೀಶ್ವರಸ್ತಸ್ಯ ಸಹಾಯೋ ಭೂತ್ವಾ ಸರ್ವ್ವಸ್ಯಾ ದುರ್ಗತೇ ರಕ್ಷಿತ್ವಾ ತಸ್ಮೈ ಬುದ್ಧಿಂ ದತ್ತ್ವಾ ಮಿಸರದೇಶಸ್ಯ ರಾಜ್ಞಃ ಫಿರೌಣಃ ಪ್ರಿಯಪಾತ್ರಂ ಕೃತವಾನ್ ತತೋ ರಾಜಾ ಮಿಸರದೇಶಸ್ಯ ಸ್ವೀಯಸರ್ವ್ವಪರಿವಾರಸ್ಯ ಚ ಶಾಸನಪದಂ ತಸ್ಮೈ ದತ್ತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","ತಸ್ಮಿನ್ ಸಮಯೇ ಮಿಸರ-ಕಿನಾನದೇಶಯೋ ರ್ದುರ್ಭಿಕ್ಷಹೇತೋರತಿಕ್ಲಿಷ್ಟತ್ವಾತ್ ನಃ ಪೂರ್ವ್ವಪುರುಷಾ ಭಕ್ಷ್ಯದ್ರವ್ಯಂ ನಾಲಭನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","ಕಿನ್ತು ಮಿಸರದೇಶೇ ಶಸ್ಯಾನಿ ಸನ್ತಿ, ಯಾಕೂಬ್ ಇಮಾಂ ವಾರ್ತ್ತಾಂ ಶ್ರುತ್ವಾ ಪ್ರಥಮಮ್ ಅಸ್ಮಾಕಂ ಪೂರ್ವ್ವಪುರುಷಾನ್ ಮಿಸರಂ ಪ್ರೇಷಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ತತೋ ದ್ವಿತೀಯವಾರಗಮನೇ ಯೂಷಫ್ ಸ್ವಭ್ರಾತೃಭಿಃ ಪರಿಚಿತೋಽಭವತ್; ಯೂಷಫೋ ಭ್ರಾತರಃ ಫಿರೌಣ್ ರಾಜೇನ ಪರಿಚಿತಾ ಅಭವನ್| ");
INSERT INTO sankan_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","ಅನನ್ತರಂ ಯೂಷಫ್ ಭ್ರಾತೃಗಣಂ ಪ್ರೇಷ್ಯ ನಿಜಪಿತರಂ ಯಾಕೂಬಂ ನಿಜಾನ್ ಪಞ್ಚಾಧಿಕಸಪ್ತತಿಸಂಖ್ಯಕಾನ್ ಜ್ಞಾತಿಜನಾಂಶ್ಚ ಸಮಾಹೂತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","ತಸ್ಮಾದ್ ಯಾಕೂಬ್ ಮಿಸರದೇಶಂ ಗತ್ವಾ ಸ್ವಯಮ್ ಅಸ್ಮಾಕಂ ಪೂರ್ವ್ವಪುರುಷಾಶ್ಚ ತಸ್ಮಿನ್ ಸ್ಥಾನೇಽಮ್ರಿಯನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ತತಸ್ತೇ ಶಿಖಿಮಂ ನೀತಾ ಯತ್ ಶ್ಮಶಾನಮ್ ಇಬ್ರಾಹೀಮ್ ಮುದ್ರಾದತ್ವಾ ಶಿಖಿಮಃ ಪಿತು ರ್ಹಮೋರಃ ಪುತ್ರೇಭ್ಯಃ ಕ್ರೀತವಾನ್ ತತ್ಶ್ಮಶಾನೇ ಸ್ಥಾಪಯಾಞ್ಚಕ್ರಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","ತತಃ ಪರಮ್ ಈಶ್ವರ ಇಬ್ರಾಹೀಮಃ ಸನ್ನಿಧೌ ಶಪಥಂ ಕೃತ್ವಾ ಯಾಂ ಪ್ರತಿಜ್ಞಾಂ ಕೃತವಾನ್ ತಸ್ಯಾಃ ಪ್ರತಿಜ್ಞಾಯಾಃ ಫಲನಸಮಯೇ ನಿಕಟೇ ಸತಿ ಇಸ್ರಾಯೇಲ್ಲೋಕಾ ಸಿಮರದೇಶೇ ವರ್ದ್ಧಮಾನಾ ಬಹುಸಂಖ್ಯಾ ಅಭವನ್| ");
INSERT INTO sankan_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ಶೇಷೇ ಯೂಷಫಂ ಯೋ ನ ಪರಿಚಿನೋತಿ ತಾದೃಶ ಏಕೋ ನರಪತಿರುಪಸ್ಥಾಯ ");
INSERT INTO sankan_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ಅಸ್ಮಾಕಂ ಜ್ಞಾತಿಭಿಃ ಸಾರ್ದ್ಧಂ ಧೂರ್ತ್ತತಾಂ ವಿಧಾಯ ಪೂರ್ವ್ವಪುರುಷಾನ್ ಪ್ರತಿ ಕುವ್ಯವಹರಣಪೂರ್ವ್ವಕಂ ತೇಷಾಂ ವಂಶನಾಶನಾಯ ತೇಷಾಂ ನವಜಾತಾನ್ ಶಿಶೂನ್ ಬಹಿ ರ್ನಿರಕ್ಷೇಪಯತ್| ");
INSERT INTO sankan_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","ಏತಸ್ಮಿನ್ ಸಮಯೇ ಮೂಸಾ ಜಜ್ಞೇ, ಸ ತು ಪರಮಸುನ್ದರೋಽಭವತ್ ತಥಾ ಪಿತೃಗೃಹೇ ಮಾಸತ್ರಯಪರ್ಯ್ಯನ್ತಂ ಪಾಲಿತೋಽಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ಕಿನ್ತು ತಸ್ಮಿನ್ ಬಹಿರ್ನಿಕ್ಷಿಪ್ತೇ ಸತಿ ಫಿರೌಣರಾಜಸ್ಯ ಕನ್ಯಾ ತಮ್ ಉತ್ತೋಲ್ಯ ನೀತ್ವಾ ದತ್ತಕಪುತ್ರಂ ಕೃತ್ವಾ ಪಾಲಿತವತೀ| ");
INSERT INTO sankan_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","ತಸ್ಮಾತ್ ಸ ಮೂಸಾ ಮಿಸರದೇಶೀಯಾಯಾಃ ಸರ್ವ್ವವಿದ್ಯಾಯಾಃ ಪಾರದೃಷ್ವಾ ಸನ್ ವಾಕ್ಯೇ ಕ್ರಿಯಾಯಾಞ್ಚ ಶಕ್ತಿಮಾನ್ ಅಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","ಸ ಸಮ್ಪೂರ್ಣಚತ್ವಾರಿಂಶದ್ವತ್ಸರವಯಸ್ಕೋ ಭೂತ್ವಾ ಇಸ್ರಾಯೇಲೀಯವಂಶನಿಜಭ್ರಾತೃನ್ ಸಾಕ್ಷಾತ್ ಕರ್ತುಂ ಮತಿಂ ಚಕ್ರೇ| ");
INSERT INTO sankan_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","ತೇಷಾಂ ಜನಮೇಕಂ ಹಿಂಸಿತಂ ದೃಷ್ಟ್ವಾ ತಸ್ಯ ಸಪಕ್ಷಃ ಸನ್ ಹಿಂಸಿತಜನಮ್ ಉಪಕೃತ್ಯ ಮಿಸರೀಯಜನಂ ಜಘಾನ| ");
INSERT INTO sankan_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ತಸ್ಯ ಹಸ್ತೇನೇಶ್ವರಸ್ತಾನ್ ಉದ್ಧರಿಷ್ಯತಿ ತಸ್ಯ ಭ್ರಾತೃಗಣ ಇತಿ ಜ್ಞಾಸ್ಯತಿ ಸ ಇತ್ಯನುಮಾನಂ ಚಕಾರ, ಕಿನ್ತು ತೇ ನ ಬುಬುಧಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","ತತ್ಪರೇ ಽಹನಿ ತೇಷಾಮ್ ಉಭಯೋ ರ್ಜನಯೋ ರ್ವಾಕ್ಕಲಹ ಉಪಸ್ಥಿತೇ ಸತಿ ಮೂಸಾಃ ಸಮೀಪಂ ಗತ್ವಾ ತಯೋ ರ್ಮೇಲನಂ ಕರ್ತ್ತುಂ ಮತಿಂ ಕೃತ್ವಾ ಕಥಯಾಮಾಸ, ಹೇ ಮಹಾಶಯೌ ಯುವಾಂ ಭ್ರಾತರೌ ಪರಸ್ಪರಮ್ ಅನ್ಯಾಯಂ ಕುತಃ ಕುರುಥಃ? ");
INSERT INTO sankan_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","ತತಃ ಸಮೀಪವಾಸಿನಂ ಪ್ರತಿ ಯೋ ಜನೋಽನ್ಯಾಯಂ ಚಕಾರ ಸ ತಂ ದೂರೀಕೃತ್ಯ ಕಥಯಾಮಾಸ, ಅಸ್ಮಾಕಮುಪರಿ ಶಾಸ್ತೃತ್ವವಿಚಾರಯಿತೃತ್ವಪದಯೋಃ ಕಸ್ತ್ವಾಂ ನಿಯುಕ್ತವಾನ್? ");
INSERT INTO sankan_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","ಹ್ಯೋ ಯಥಾ ಮಿಸರೀಯಂ ಹತವಾನ್ ತಥಾ ಕಿಂ ಮಾಮಪಿ ಹನಿಷ್ಯಸಿ? ");
INSERT INTO sankan_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ತದಾ ಮೂಸಾ ಏತಾದೃಶೀಂ ಕಥಾಂ ಶ್ರುತ್ವಾ ಪಲಾಯನಂ ಚಕ್ರೇ, ತತೋ ಮಿದಿಯನದೇಶಂ ಗತ್ವಾ ಪ್ರವಾಸೀ ಸನ್ ತಸ್ಥೌ, ತತಸ್ತತ್ರ ದ್ವೌ ಪುತ್ರೌ ಜಜ್ಞಾತೇ| ");
INSERT INTO sankan_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","ಅನನ್ತರಂ ಚತ್ವಾರಿಂಶದ್ವತ್ಸರೇಷು ಗತೇಷು ಸೀನಯಪರ್ವ್ವತಸ್ಯ ಪ್ರಾನ್ತರೇ ಪ್ರಜ್ವಲಿತಸ್ತಮ್ಬಸ್ಯ ವಹ್ನಿಶಿಖಾಯಾಂ ಪರಮೇಶ್ವರದೂತಸ್ತಸ್ಮೈ ದರ್ಶನಂ ದದೌ| ");
INSERT INTO sankan_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","ಮೂಸಾಸ್ತಸ್ಮಿನ್ ದರ್ಶನೇ ವಿಸ್ಮಯಂ ಮತ್ವಾ ವಿಶೇಷಂ ಜ್ಞಾತುಂ ನಿಕಟಂ ಗಚ್ಛತಿ, ");
INSERT INTO sankan_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","ಏತಸ್ಮಿನ್ ಸಮಯೇ, ಅಹಂ ತವ ಪೂರ್ವ್ವಪುರುಷಾಣಾಮ್ ಈಶ್ವರೋಽರ್ಥಾದ್ ಇಬ್ರಾಹೀಮ ಈಶ್ವರ ಇಸ್ಹಾಕ ಈಶ್ವರೋ ಯಾಕೂಬ ಈಶ್ವರಶ್ಚ, ಮೂಸಾಮುದ್ದಿಶ್ಯ ಪರಮೇಶ್ವರಸ್ಯೈತಾದೃಶೀ ವಿಹಾಯಸೀಯಾ ವಾಣೀ ಬಭೂವ, ತತಃ ಸ ಕಮ್ಪಾನ್ವಿತಃ ಸನ್ ಪುನ ರ್ನಿರೀಕ್ಷಿತುಂ ಪ್ರಗಲ್ಭೋ ನ ಬಭೂವ| ");
INSERT INTO sankan_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","ಪರಮೇಶ್ವರಸ್ತಂ ಜಗಾದ, ತವ ಪಾದಯೋಃ ಪಾದುಕೇ ಮೋಚಯ ಯತ್ರ ತಿಷ್ಠಸಿ ಸಾ ಪವಿತ್ರಭೂಮಿಃ| ");
INSERT INTO sankan_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ಅಹಂ ಮಿಸರದೇಶಸ್ಥಾನಾಂ ನಿಜಲೋಕಾನಾಂ ದುರ್ದ್ದಶಾಂ ನಿತಾನ್ತಮ್ ಅಪಶ್ಯಂ, ತೇಷಾಂ ಕಾತರ್ಯ್ಯೋಕ್ತಿಞ್ಚ ಶ್ರುತವಾನ್ ತಸ್ಮಾತ್ ತಾನ್ ಉದ್ಧರ್ತ್ತುಮ್ ಅವರುಹ್ಯಾಗಮಮ್; ಇದಾನೀಮ್ ಆಗಚ್ಛ ಮಿಸರದೇಶಂ ತ್ವಾಂ ಪ್ರೇಷಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","ಕಸ್ತ್ವಾಂ ಶಾಸ್ತೃತ್ವವಿಚಾರಯಿತೃತ್ವಪದಯೋ ರ್ನಿಯುಕ್ತವಾನ್, ಇತಿ ವಾಕ್ಯಮುಕ್ತ್ವಾ ತೈ ರ್ಯೋ ಮೂಸಾ ಅವಜ್ಞಾತಸ್ತಮೇವ ಈಶ್ವರಃ ಸ್ತಮ್ಬಮಧ್ಯೇ ದರ್ಶನದಾತ್ರಾ ತೇನ ದೂತೇನ ಶಾಸ್ತಾರಂ ಮುಕ್ತಿದಾತಾರಞ್ಚ ಕೃತ್ವಾ ಪ್ರೇಷಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","ಸ ಚ ಮಿಸರದೇಶೇ ಸೂಫ್ನಾಮ್ನಿ ಸಮುದ್ರೇ ಚ ಪಶ್ಚಾತ್ ಚತ್ವಾರಿಂಶದ್ವತ್ಸರಾನ್ ಯಾವತ್ ಮಹಾಪ್ರಾನ್ತರೇ ನಾನಾಪ್ರಕಾರಾಣ್ಯದ್ಭುತಾನಿ ಕರ್ಮ್ಮಾಣಿ ಲಕ್ಷಣಾನಿ ಚ ದರ್ಶಯಿತ್ವಾ ತಾನ್ ಬಹಿಃ ಕೃತ್ವಾ ಸಮಾನಿನಾಯ| ");
INSERT INTO sankan_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","ಪ್ರಭುಃ ಪರಮೇಶ್ವರೋ ಯುಷ್ಮಾಕಂ ಭ್ರಾತೃಗಣಸ್ಯ ಮಧ್ಯೇ ಮಾದೃಶಮ್ ಏಕಂ ಭವಿಷ್ಯದ್ವಕ್ತಾರಮ್ ಉತ್ಪಾದಯಿಷ್ಯತಿ ತಸ್ಯ ಕಥಾಯಾಂ ಯೂಯಂ ಮನೋ ನಿಧಾಸ್ಯಥ, ಯೋ ಜನ ಇಸ್ರಾಯೇಲಃ ಸನ್ತಾನೇಭ್ಯ ಏನಾಂ ಕಥಾಂ ಕಥಯಾಮಾಸ ಸ ಏಷ ಮೂಸಾಃ| ");
INSERT INTO sankan_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","ಮಹಾಪ್ರಾನ್ತರಸ್ಥಮಣ್ಡಲೀಮಧ್ಯೇಽಪಿ ಸ ಏವ ಸೀನಯಪರ್ವ್ವತೋಪರಿ ತೇನ ಸಾರ್ದ್ಧಂ ಸಂಲಾಪಿನೋ ದೂತಸ್ಯ ಚಾಸ್ಮತ್ಪಿತೃಗಣಸ್ಯ ಮಧ್ಯಸ್ಥಃ ಸನ್ ಅಸ್ಮಭ್ಯಂ ದಾತವ್ಯನಿ ಜೀವನದಾಯಕಾನಿ ವಾಕ್ಯಾನಿ ಲೇಭೇ| ");
INSERT INTO sankan_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","ಅಸ್ಮಾಕಂ ಪೂರ್ವ್ವಪುರುಷಾಸ್ತಮ್ ಅಮಾನ್ಯಂ ಕತ್ವಾ ಸ್ವೇಭ್ಯೋ ದೂರೀಕೃತ್ಯ ಮಿಸರದೇಶಂ ಪರಾವೃತ್ಯ ಗನ್ತುಂ ಮನೋಭಿರಭಿಲಷ್ಯ ಹಾರೋಣಂ ಜಗದುಃ, ");
INSERT INTO sankan_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ಅಸ್ಮಾಕಮ್ ಅಗ್ರೇಽಗ್ರೇ ಗನ್ತುुಮ್ ಅಸ್ಮದರ್ಥಂ ದೇವಗಣಂ ನಿರ್ಮ್ಮಾಹಿ ಯತೋ ಯೋ ಮೂಸಾ ಅಸ್ಮಾನ್ ಮಿಸರದೇಶಾದ್ ಬಹಿಃ ಕೃತ್ವಾನೀತವಾನ್ ತಸ್ಯ ಕಿಂ ಜಾತಂ ತದಸ್ಮಾಭಿ ರ್ನ ಜ್ಞಾಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","ತಸ್ಮಿನ್ ಸಮಯೇ ತೇ ಗೋವತ್ಸಾಕೃತಿಂ ಪ್ರತಿಮಾಂ ನಿರ್ಮ್ಮಾಯ ತಾಮುದ್ದಿಶ್ಯ ನೈವೇದ್ಯಮುತ್ಮೃಜ್ಯ ಸ್ವಹಸ್ತಕೃತವಸ್ತುನಾ ಆನನ್ದಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","ತಸ್ಮಾದ್ ಈಶ್ವರಸ್ತೇಷಾಂ ಪ್ರತಿ ವಿಮುಖಃ ಸನ್ ಆಕಾಶಸ್ಥಂ ಜ್ಯೋತಿರ್ಗಣಂ ಪೂಜಯಿತುಂ ತೇಭ್ಯೋಽನುಮತಿಂ ದದೌ, ಯಾದೃಶಂ ಭವಿಷ್ಯದ್ವಾದಿನಾಂ ಗ್ರನ್ಥೇಷು ಲಿಖಿತಮಾಸ್ತೇ, ಯಥಾ, ಇಸ್ರಾಯೇಲೀಯವಂಶಾ ರೇ ಚತ್ವಾರಿಂಶತ್ಸಮಾನ್ ಪುರಾ| ಮಹತಿ ಪ್ರಾನ್ತರೇ ಸಂಸ್ಥಾ ಯೂಯನ್ತು ಯಾನಿ ಚ| ಬಲಿಹೋಮಾದಿಕರ್ಮ್ಮಾಣಿ ಕೃತವನ್ತಸ್ತು ತಾನಿ ಕಿಂ| ಮಾಂ ಸಮುದ್ದಿಶ್ಯ ಯುಷ್ಮಾಭಿಃ ಪ್ರಕೃತಾನೀತಿ ನೈವ ಚ| ");
INSERT INTO sankan_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","ಕಿನ್ತು ವೋ ಮೋಲಕಾಖ್ಯಸ್ಯ ದೇವಸ್ಯ ದೂಷ್ಯಮೇವ ಚ| ಯುಷ್ಮಾಕಂ ರಿಮ್ಫನಾಖ್ಯಾಯಾ ದೇವತಾಯಾಶ್ಚ ತಾರಕಾ| ಏತಯೋರುಭಯೋ ರ್ಮೂರ್ತೀ ಯುಷ್ಮಾಭಿಃ ಪರಿಪೂಜಿತೇ| ಅತೋ ಯುಷ್ಮಾಂಸ್ತು ಬಾಬೇಲಃ ಪಾರಂ ನೇಷ್ಯಾಮಿ ನಿಶ್ಚಿತಂ| ");
INSERT INTO sankan_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","ಅಪರಞ್ಚ ಯನ್ನಿದರ್ಶನಮ್ ಅಪಶ್ಯಸ್ತದನುಸಾರೇಣ ದೂಷ್ಯಂ ನಿರ್ಮ್ಮಾಹಿ ಯಸ್ಮಿನ್ ಈಶ್ವರೋ ಮೂಸಾಮ್ ಏತದ್ವಾಕ್ಯಂ ಬಭಾಷೇ ತತ್ ತಸ್ಯ ನಿರೂಪಿತಂ ಸಾಕ್ಷ್ಯಸ್ವರೂಪಂ ದೂಷ್ಯಮ್ ಅಸ್ಮಾಕಂ ಪೂರ್ವ್ವಪುರುಷೈಃ ಸಹ ಪ್ರಾನ್ತರೇ ತಸ್ಥೌ| ");
INSERT INTO sankan_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","ಪಶ್ಚಾತ್ ಯಿಹೋಶೂಯೇನ ಸಹಿತೈಸ್ತೇಷಾಂ ವಂಶಜಾತೈರಸ್ಮತ್ಪೂರ್ವ್ವಪುರುಷೈಃ ಸ್ವೇಷಾಂ ಸಮ್ಮುಖಾದ್ ಈಶ್ವರೇಣ ದೂರೀಕೃತಾನಾಮ್ ಅನ್ಯದೇಶೀಯಾನಾಂ ದೇಶಾಧಿಕೃತಿಕಾಲೇ ಸಮಾನೀತಂ ತದ್ ದೂಷ್ಯಂ ದಾಯೂದೋಧಿಕಾರಂ ಯಾವತ್ ತತ್ರ ಸ್ಥಾನ ಆಸೀತ್| ");
INSERT INTO sankan_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ಸ ದಾಯೂದ್ ಪರಮೇಶ್ವರಸ್ಯಾನುಗ್ರಹಂ ಪ್ರಾಪ್ಯ ಯಾಕೂಬ್ ಈಶ್ವರಾರ್ಥಮ್ ಏಕಂ ದೂಷ್ಯಂ ನಿರ್ಮ್ಮಾತುಂ ವವಾಞ್ಛ; ");
INSERT INTO sankan_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","ಕಿನ್ತು ಸುಲೇಮಾನ್ ತದರ್ಥಂ ಮನ್ದಿರಮ್ ಏಕಂ ನಿರ್ಮ್ಮಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","ತಥಾಪಿ ಯಃ ಸರ್ವ್ವೋಪರಿಸ್ಥಃ ಸ ಕಸ್ಮಿಂಶ್ಚಿದ್ ಹಸ್ತಕೃತೇ ಮನ್ದಿರೇ ನಿವಸತೀತಿ ನಹಿ, ಭವಿಷ್ಯದ್ವಾದೀ ಕಥಾಮೇತಾಂ ಕಥಯತಿ, ಯಥಾ, ");
INSERT INTO sankan_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","ಪರೇಶೋ ವದತಿ ಸ್ವರ್ಗೋ ರಾಜಸಿಂಹಾಸನಂ ಮಮ| ಮದೀಯಂ ಪಾದಪೀಠಞ್ಚ ಪೃಥಿವೀ ಭವತಿ ಧ್ರುವಂ| ತರ್ಹಿ ಯೂಯಂ ಕೃತೇ ಮೇ ಕಿಂ ಪ್ರನಿರ್ಮ್ಮಾಸ್ಯಥ ಮನ್ದಿರಂ| ವಿಶ್ರಾಮಾಯ ಮದೀಯಂ ವಾ ಸ್ಥಾನಂ ಕಿಂ ವಿದ್ಯತೇ ತ್ವಿಹ| ");
INSERT INTO sankan_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","ಸರ್ವ್ವಾಣ್ಯೇತಾನಿ ವಸ್ತೂನಿ ಕಿಂ ಮೇ ಹಸ್ತಕೃತಾನಿ ನ|| ");
INSERT INTO sankan_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","ಹೇ ಅನಾಜ್ಞಾಗ್ರಾಹಕಾ ಅನ್ತಃಕರಣೇ ಶ್ರವಣೇ ಚಾಪವಿತ್ರಲೋಕಾಃ ಯೂಯಮ್ ಅನವರತಂ ಪವಿತ್ರಸ್ಯಾತ್ಮನಃ ಪ್ರಾತಿಕೂಲ್ಯಮ್ ಆಚರಥ, ಯುಷ್ಮಾಕಂ ಪೂರ್ವ್ವಪುರುಷಾ ಯಾದೃಶಾ ಯೂಯಮಪಿ ತಾದೃಶಾಃ| ");
INSERT INTO sankan_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","ಯುಷ್ಮಾಕಂ ಪೂರ್ವ್ವಪುರುಷಾಃ ಕಂ ಭವಿಷ್ಯದ್ವಾದಿನಂ ನಾತಾಡಯನ್? ಯೇ ತಸ್ಯ ಧಾರ್ಮ್ಮಿಕಸ್ಯ ಜನಸ್ಯಾಗಮನಕಥಾಂ ಕಥಿತವನ್ತಸ್ತಾನ್ ಅಘ್ನನ್ ಯೂಯಮ್ ಅಧೂನಾ ವಿಶ್ವಾಸಘಾತಿನೋ ಭೂತ್ವಾ ತಂ ಧಾರ್ಮ್ಮಿಕಂ ಜನಮ್ ಅಹತ| ");
INSERT INTO sankan_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","ಯೂಯಂ ಸ್ವರ್ಗೀಯದೂತಗಣೇನ ವ್ಯವಸ್ಥಾಂ ಪ್ರಾಪ್ಯಾಪಿ ತಾಂ ನಾಚರಥ| ");
INSERT INTO sankan_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ಇಮಾಂ ಕಥಾಂ ಶ್ರುತ್ವಾ ತೇ ಮನಃಸು ಬಿದ್ಧಾಃ ಸನ್ತಸ್ತಂ ಪ್ರತಿ ದನ್ತಘರ್ಷಣಮ್ ಅಕುರ್ವ್ವನ್| ");
INSERT INTO sankan_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","ಕಿನ್ತು ಸ್ತಿಫಾನಃ ಪವಿತ್ರೇಣಾತ್ಮನಾ ಪೂರ್ಣೋ ಭೂತ್ವಾ ಗಗಣಂ ಪ್ರತಿ ಸ್ಥಿರದೃಷ್ಟಿಂ ಕೃತ್ವಾ ಈಶ್ವರಸ್ಯ ದಕ್ಷಿಣೇ ದಣ್ಡಾಯಮಾನಂ ಯೀಶುಞ್ಚ ವಿಲೋಕ್ಯ ಕಥಿತವಾನ್; ");
INSERT INTO sankan_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","ಪಶ್ಯ,ಮೇಘದ್ವಾರಂ ಮುಕ್ತಮ್ ಈಶ್ವರಸ್ಯ ದಕ್ಷಿಣೇ ಸ್ಥಿತಂ ಮಾನವಸುತಞ್ಚ ಪಶ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","ತದಾ ತೇ ಪ್ರೋಚ್ಚೈಃ ಶಬ್ದಂ ಕೃತ್ವಾ ಕರ್ಣೇಷ್ವಙ್ಗುಲೀ ರ್ನಿಧಾಯ ಏಕಚಿತ್ತೀಭೂಯ ತಮ್ ಆಕ್ರಮನ್| ");
INSERT INTO sankan_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ಪಶ್ಚಾತ್ ತಂ ನಗರಾದ್ ಬಹಿಃ ಕೃತ್ವಾ ಪ್ರಸ್ತರೈರಾಘ್ನನ್ ಸಾಕ್ಷಿಣೋ ಲಾಕಾಃ ಶೌಲನಾಮ್ನೋ ಯೂನಶ್ಚರಣಸನ್ನಿಧೌ ನಿಜವಸ್ತ್ರಾಣಿ ಸ್ಥಾಪಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","ಅನನ್ತರಂ ಹೇ ಪ್ರಭೋ ಯೀಶೇ ಮದೀಯಮಾತ್ಮಾನಂ ಗೃಹಾಣ ಸ್ತಿಫಾನಸ್ಯೇತಿ ಪ್ರಾರ್ಥನವಾಕ್ಯವದನಸಮಯೇ ತೇ ತಂ ಪ್ರಸ್ತರೈರಾಘ್ನನ್| ");
INSERT INTO sankan_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ತಸ್ಮಾತ್ ಸ ಜಾನುನೀ ಪಾತಯಿತ್ವಾ ಪ್ರೋಚ್ಚೈಃ ಶಬ್ದಂ ಕೃತ್ವಾ, ಹೇ ಪ್ರಭೇ ಪಾಪಮೇತದ್ ಏತೇಷು ಮಾ ಸ್ಥಾಪಯ, ಇತ್ಯುಕ್ತ್ವಾ ಮಹಾನಿದ್ರಾಂ ಪ್ರಾಪ್ನೋತ್| ");
INSERT INTO sankan_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","ತಸ್ಯ ಹತ್ಯಾಕರಣಂ ಶೌಲೋಪಿ ಸಮಮನ್ಯತ| ತಸ್ಮಿನ್ ಸಮಯೇ ಯಿರೂಶಾಲಮ್ನಗರಸ್ಥಾಂ ಮಣ್ಡಲೀಂ ಪ್ರತಿ ಮಹಾತಾಡನಾಯಾಂ ಜಾತಾಯಾಂ ಪ್ರೇರಿತಲೋಕಾನ್ ಹಿತ್ವಾ ಸರ್ವ್ವೇಽಪರೇ ಯಿಹೂದಾಶೋಮಿರೋಣದೇಶಯೋ ರ್ನಾನಾಸ್ಥಾನೇ ವಿಕೀರ್ಣಾಃ ಸನ್ತೋ ಗತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","ಅನ್ಯಚ್ಚ ಭಕ್ತಲೋಕಾಸ್ತಂ ಸ್ತಿಫಾನಂ ಶ್ಮಶಾನೇ ಸ್ಥಾಪಯಿತ್ವಾ ಬಹು ವ್ಯಲಪನ್| ");
INSERT INTO sankan_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","ಕಿನ್ತು ಶೌಲೋ ಗೃಹೇ ಗೃಹೇ ಭ್ರಮಿತ್ವಾ ಸ್ತ್ರಿಯಃ ಪುರುಷಾಂಶ್ಚ ಧೃತ್ವಾ ಕಾರಾಯಾಂ ಬದ್ಧ್ವಾ ಮಣ್ಡಲ್ಯಾ ಮಹೋತ್ಪಾತಂ ಕೃತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","ಅನ್ಯಚ್ಚ ಯೇ ವಿಕೀರ್ಣಾ ಅಭವನ್ ತೇ ಸರ್ವ್ವತ್ರ ಭ್ರಮಿತ್ವಾ ಸುಸಂವಾದಂ ಪ್ರಾಚಾರಯನ್| ");
INSERT INTO sankan_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ತದಾ ಫಿಲಿಪಃ ಶೋಮಿರೋಣ್ನಗರಂ ಗತ್ವಾ ಖ್ರೀಷ್ಟಾಖ್ಯಾನಂ ಪ್ರಾಚಾರಯತ್; ");
INSERT INTO sankan_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ತತೋಽಶುಚಿ-ಭೃತಗ್ರಸ್ತಲೋಕೇಭ್ಯೋ ಭೂತಾಶ್ಚೀತ್ಕೃತ್ಯಾಗಚ್ಛನ್ ತಥಾ ಬಹವಃ ಪಕ್ಷಾಘಾತಿನಃ ಖಞ್ಜಾ ಲೋಕಾಶ್ಚ ಸ್ವಸ್ಥಾ ಅಭವನ್| ");
INSERT INTO sankan_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","ತಸ್ಮಾತ್ ಲಾಕಾ ಈದೃಶಂ ತಸ್ಯಾಶ್ಚರ್ಯ್ಯಂ ಕರ್ಮ್ಮ ವಿಲೋಕ್ಯ ನಿಶಮ್ಯ ಚ ಸರ್ವ್ವ ಏಕಚಿತ್ತೀಭೂಯ ತೇನೋಕ್ತಾಖ್ಯಾನೇ ಮನಾಂಸಿ ನ್ಯದಧುಃ| ");
INSERT INTO sankan_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","ತಸ್ಮಿನ್ನಗರೇ ಮಹಾನನ್ದಶ್ಚಾಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ತತಃ ಪೂರ್ವ್ವಂ ತಸ್ಮಿನ್ನಗರೇ ಶಿಮೋನ್ನಾಮಾ ಕಶ್ಚಿಜ್ಜನೋ ಬಹ್ವೀ ರ್ಮಾಯಾಕ್ರಿಯಾಃ ಕೃತ್ವಾ ಸ್ವಂ ಕಞ್ಚನ ಮಹಾಪುರುಷಂ ಪ್ರೋಚ್ಯ ಶೋಮಿರೋಣೀಯಾನಾಂ ಮೋಹಂ ಜನಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ತಸ್ಮಾತ್ ಸ ಮಾನುಷ ಈಶ್ವರಸ್ಯ ಮಹಾಶಕ್ತಿಸ್ವರೂಪ ಇತ್ಯುಕ್ತ್ವಾ ಬಾಲವೃದ್ಧವನಿತಾಃ ಸರ್ವ್ವೇ ಲಾಕಾಸ್ತಸ್ಮಿನ್ ಮನಾಂಸಿ ನ್ಯದಧುಃ| ");
INSERT INTO sankan_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ಸ ಬಹುಕಾಲಾನ್ ಮಾಯಾವಿಕ್ರಿಯಯಾ ಸರ್ವ್ವಾನ್ ಅತೀವ ಮೋಹಯಾಞ್ಚಕಾರ, ತಸ್ಮಾತ್ ತೇ ತಂ ಮೇನಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","ಕಿನ್ತ್ವೀಶ್ವರಸ್ಯ ರಾಜ್ಯಸ್ಯ ಯೀಶುಖ್ರೀಷ್ಟಸ್ಯ ನಾಮ್ನಶ್ಚಾಖ್ಯಾನಪ್ರಚಾರಿಣಃ ಫಿಲಿಪಸ್ಯ ಕಥಾಯಾಂ ವಿಶ್ವಸ್ಯ ತೇಷಾಂ ಸ್ತ್ರೀಪುರುಷೋಭಯಲೋಕಾ ಮಜ್ಜಿತಾ ಅಭವನ್| ");
INSERT INTO sankan_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ಶೇಷೇ ಸ ಶಿಮೋನಪಿ ಸ್ವಯಂ ಪ್ರತ್ಯೈತ್ ತತೋ ಮಜ್ಜಿತಃ ಸನ್ ಫಿಲಿಪೇನ ಕೃತಾಮ್ ಆಶ್ಚರ್ಯ್ಯಕ್ರಿಯಾಂ ಲಕ್ಷಣಞ್ಚ ವಿಲೋಕ್ಯಾಸಮ್ಭವಂ ಮನ್ಯಮಾನಸ್ತೇನ ಸಹ ಸ್ಥಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ಇತ್ಥಂ ಶೋಮಿರೋಣ್ದೇಶೀಯಲೋಕಾ ಈಶ್ವರಸ್ಯ ಕಥಾಮ್ ಅಗೃಹ್ಲನ್ ಇತಿ ವಾರ್ತ್ತಾಂ ಯಿರೂಶಾಲಮ್ನಗರಸ್ಥಪ್ರೇರಿತಾಃ ಪ್ರಾಪ್ಯ ಪಿತರಂ ಯೋಹನಞ್ಚ ತೇಷಾಂ ನಿಕಟೇ ಪ್ರೇಷಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ತತಸ್ತೌ ತತ್ ಸ್ಥಾನಮ್ ಉಪಸ್ಥಾಯ ಲೋಕಾ ಯಥಾ ಪವಿತ್ರಮ್ ಆತ್ಮಾನಂ ಪ್ರಾಪ್ನುವನ್ತಿ ತದರ್ಥಂ ಪ್ರಾರ್ಥಯೇತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ಯತಸ್ತೇ ಪುರಾ ಕೇವಲಪ್ರಭುಯೀಶೋ ರ್ನಾಮ್ನಾ ಮಜ್ಜಿತಮಾತ್ರಾ ಅಭವನ್, ನ ತು ತೇಷಾಂ ಮಧ್ಯೇ ಕಮಪಿ ಪ್ರತಿ ಪವಿತ್ರಸ್ಯಾತ್ಮನ ಆವಿರ್ಭಾವೋ ಜಾತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","ಕಿನ್ತು ಪ್ರೇರಿತಾಭ್ಯಾಂ ತೇಷಾಂ ಗಾತ್ರೇಷು ಕರೇಷ್ವರ್ಪಿತೇಷು ಸತ್ಸು ತೇ ಪವಿತ್ರಮ್ ಆತ್ಮಾನಮ್ ಪ್ರಾಪ್ನುವನ್| ");
INSERT INTO sankan_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","ಇತ್ಥಂ ಲೋಕಾನಾಂ ಗಾತ್ರೇಷು ಪ್ರೇರಿತಯೋಃ ಕರಾರ್ಪಣೇನ ತಾನ್ ಪವಿತ್ರಮ್ ಆತ್ಮಾನಂ ಪ್ರಾಪ್ತಾನ್ ದೃಷ್ಟ್ವಾ ಸ ಶಿಮೋನ್ ತಯೋಃ ಸಮೀಪೇ ಮುದ್ರಾ ಆನೀಯ ಕಥಿತವಾನ್; ");
INSERT INTO sankan_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ಅಹಂ ಯಸ್ಯ ಗಾತ್ರೇ ಹಸ್ತಮ್ ಅರ್ಪಯಿಷ್ಯಾಮಿ ತಸ್ಯಾಪಿ ಯಥೇತ್ಥಂ ಪವಿತ್ರಾತ್ಮಪ್ರಾಪ್ತಿ ರ್ಭವತಿ ತಾದೃಶೀಂ ಶಕ್ತಿಂ ಮಹ್ಯಂ ದತ್ತಂ| ");
INSERT INTO sankan_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","ಕಿನ್ತು ಪಿತರಸ್ತಂ ಪ್ರತ್ಯವದತ್ ತವ ಮುದ್ರಾಸ್ತ್ವಯಾ ವಿನಶ್ಯನ್ತು ಯತ ಈಶ್ವರಸ್ಯ ದಾನಂ ಮುದ್ರಾಭಿಃ ಕ್ರೀಯತೇ ತ್ವಮಿತ್ಥಂ ಬುದ್ಧವಾನ್; ");
INSERT INTO sankan_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ಈಶ್ವರಾಯ ತಾವನ್ತಃಕರಣಂ ಸರಲಂ ನಹಿ, ತಸ್ಮಾದ್ ಅತ್ರ ತವಾಂಶೋಽಧಿಕಾರಶ್ಚ ಕೋಪಿ ನಾಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ಅತ ಏತತ್ಪಾಪಹೇತೋಃ ಖೇದಾನ್ವಿತಃ ಸನ್ ಕೇನಾಪಿ ಪ್ರಕಾರೇಣ ತವ ಮನಸ ಏತಸ್ಯಾಃ ಕುಕಲ್ಪನಾಯಾಃ ಕ್ಷಮಾ ಭವತಿ, ಏತದರ್ಥಮ್ ಈಶ್ವರೇ ಪ್ರಾರ್ಥನಾಂ ಕುರು; ");
INSERT INTO sankan_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","ಯತಸ್ತ್ವಂ ತಿಕ್ತಪಿತ್ತೇ ಪಾಪಸ್ಯ ಬನ್ಧನೇ ಚ ಯದಸಿ ತನ್ಮಯಾ ಬುದ್ಧಮ್| ");
INSERT INTO sankan_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","ತದಾ ಶಿಮೋನ್ ಅಕಥಯತ್ ತರ್ಹಿ ಯುವಾಭ್ಯಾಮುದಿತಾ ಕಥಾ ಮಯಿ ಯಥಾ ನ ಫಲತಿ ತದರ್ಥಂ ಯುವಾಂ ಮನ್ನಿಮಿತ್ತಂ ಪ್ರಭೌ ಪ್ರಾರ್ಥನಾಂ ಕುರುತಂ| ");
INSERT INTO sankan_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","ಅನೇನ ಪ್ರಕಾರೇಣ ತೌ ಸಾಕ್ಷ್ಯಂ ದತ್ತ್ವಾ ಪ್ರಭೋಃ ಕಥಾಂ ಪ್ರಚಾರಯನ್ತೌ ಶೋಮಿರೋಣೀಯಾನಾಮ್ ಅನೇಕಗ್ರಾಮೇಷು ಸುಸಂವಾದಞ್ಚ ಪ್ರಚಾರಯನ್ತೌ ಯಿರೂಶಾಲಮ್ನಗರಂ ಪರಾವೃತ್ಯ ಗತೌ| ");
INSERT INTO sankan_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ತತಃ ಪರಮ್ ಈಶ್ವರಸ್ಯ ದೂತಃ ಫಿಲಿಪಮ್ ಇತ್ಯಾದಿಶತ್, ತ್ವಮುತ್ಥಾಯ ದಕ್ಷಿಣಸ್ಯಾಂ ದಿಶಿ ಯೋ ಮಾರ್ಗೋ ಪ್ರಾನ್ತರಸ್ಯ ಮಧ್ಯೇನ ಯಿರೂಶಾಲಮೋ ಽಸಾನಗರಂ ಯಾತಿ ತಂ ಮಾರ್ಗಂ ಗಚ್ಛ| ");
INSERT INTO sankan_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ತತಃ ಸ ಉತ್ಥಾಯ ಗತವಾನ್; ತದಾ ಕನ್ದಾಕೀನಾಮ್ನಃ ಕೂಶ್ಲೋಕಾನಾಂ ರಾಜ್ಞ್ಯಾಃ ಸರ್ವ್ವಸಮ್ಪತ್ತೇರಧೀಶಃ ಕೂಶದೇಶೀಯ ಏಕಃ ಷಣ್ಡೋ ಭಜನಾರ್ಥಂ ಯಿರೂಶಾಲಮ್ನಗರಮ್ ಆಗತ್ಯ ");
INSERT INTO sankan_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ಪುನರಪಿ ರಥಮಾರುಹ್ಯ ಯಿಶಯಿಯನಾಮ್ನೋ ಭವಿಷ್ಯದ್ವಾದಿನೋ ಗ್ರನ್ಥಂ ಪಠನ್ ಪ್ರತ್ಯಾಗಚ್ಛತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ಏತಸ್ಮಿನ್ ಸಮಯೇ ಆತ್ಮಾ ಫಿಲಿಪಮ್ ಅವದತ್, ತ್ವಮ್ ರಥಸ್ಯ ಸಮೀಪಂ ಗತ್ವಾ ತೇನ ಸಾರ್ದ್ಧಂ ಮಿಲ| ");
INSERT INTO sankan_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","ತಸ್ಮಾತ್ ಸ ಧಾವನ್ ತಸ್ಯ ಸನ್ನಿಧಾವುಪಸ್ಥಾಯ ತೇನ ಪಠ್ಯಮಾನಂ ಯಿಶಯಿಯಥವಿಷ್ಯದ್ವಾದಿನೋ ವಾಕ್ಯಂ ಶ್ರುತ್ವಾ ಪೃಷ್ಟವಾನ್ ಯತ್ ಪಠಸಿ ತತ್ ಕಿಂ ಬುಧ್ಯಸೇ? ");
INSERT INTO sankan_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","ತತಃ ಸ ಕಥಿತವಾನ್ ಕೇನಚಿನ್ನ ಬೋಧಿತೋಹಂ ಕಥಂ ಬುಧ್ಯೇಯ? ತತಃ ಸ ಫಿಲಿಪಂ ರಥಮಾರೋಢುಂ ಸ್ವೇನ ಸಾರ್ದ್ಧಮ್ ಉಪವೇಷ್ಟುಞ್ಚ ನ್ಯವೇದಯತ್| ");
INSERT INTO sankan_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ಸ ಶಾಸ್ತ್ರಸ್ಯೇತದ್ವಾಕ್ಯಂ ಪಠಿತವಾನ್ ಯಥಾ, ಸಮಾನೀಯತ ಘಾತಾಯ ಸ ಯಥಾ ಮೇಷಶಾವಕಃ| ಲೋಮಚ್ಛೇದಕಸಾಕ್ಷಾಚ್ಚ ಮೇಷಶ್ಚ ನೀರವೋ ಯಥಾ| ಆಬಧ್ಯ ವದನಂ ಸ್ವೀಯಂ ತಥಾ ಸ ಸಮತಿಷ್ಠತ| ");
INSERT INTO sankan_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ಅನ್ಯಾಯೇನ ವಿಚಾರೇಣ ಸ ಉಚ್ಛಿನ್ನೋ ಽಭವತ್ ತದಾ| ತತ್ಕಾಲೀನಮನುಷ್ಯಾನ್ ಕೋ ಜನೋ ವರ್ಣಯಿತುಂ ಕ್ಷಮಃ| ಯತೋ ಜೀವನ್ನೃಣಾಂ ದೇಶಾತ್ ಸ ಉಚ್ಛಿನ್ನೋ ಽಭವತ್ ಧ್ರುವಂ| ");
INSERT INTO sankan_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","ಅನನ್ತರಂ ಸ ಫಿಲಿಪಮ್ ಅವದತ್ ನಿವೇದಯಾಮಿ, ಭವಿಷ್ಯದ್ವಾದೀ ಯಾಮಿಮಾಂ ಕಥಾಂ ಕಥಯಾಮಾಸ ಸ ಕಿಂ ಸ್ವಸ್ಮಿನ್ ವಾ ಕಸ್ಮಿಂಶ್ಚಿದ್ ಅನ್ಯಸ್ಮಿನ್? ");
INSERT INTO sankan_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ತತಃ ಫಿಲಿಪಸ್ತತ್ಪ್ರಕರಣಮ್ ಆರಭ್ಯ ಯೀಶೋರುಪಾಖ್ಯಾನಂ ತಸ್ಯಾಗ್ರೇ ಪ್ರಾಸ್ತೌತ್| ");
INSERT INTO sankan_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ಇತ್ಥಂ ಮಾರ್ಗೇಣ ಗಚ್ಛನ್ತೌ ಜಲಾಶಯಸ್ಯ ಸಮೀಪ ಉಪಸ್ಥಿತೌ; ತದಾ ಕ್ಲೀಬೋಽವಾದೀತ್ ಪಶ್ಯಾತ್ರ ಸ್ಥಾನೇ ಜಲಮಾಸ್ತೇ ಮಮ ಮಜ್ಜನೇ ಕಾ ಬಾಧಾ? ");
INSERT INTO sankan_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","ತತಃ ಫಿಲಿಪ ಉತ್ತರಂ ವ್ಯಾಹರತ್ ಸ್ವಾನ್ತಃಕರಣೇನ ಸಾಕಂ ಯದಿ ಪ್ರತ್ಯೇಷಿ ತರ್ಹಿ ಬಾಧಾ ನಾಸ್ತಿ| ತತಃ ಸ ಕಥಿತವಾನ್ ಯೀಶುಖ್ರೀಷ್ಟ ಈಶ್ವರಸ್ಯ ಪುತ್ರ ಇತ್ಯಹಂ ಪ್ರತ್ಯೇಮಿ| ");
INSERT INTO sankan_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","ತದಾ ರಥಂ ಸ್ಥಗಿತಂ ಕರ್ತ್ತುಮ್ ಆದಿಷ್ಟೇ ಫಿಲಿಪಕ್ಲೀಬೌ ದ್ವೌ ಜಲಮ್ ಅವಾರುಹತಾಂ; ತದಾ ಫಿಲಿಪಸ್ತಮ್ ಮಜ್ಜಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","ತತ್ಪಶ್ಚಾತ್ ಜಲಮಧ್ಯಾದ್ ಉತ್ಥಿತಯೋಃ ಸತೋಃ ಪರಮೇಶ್ವರಸ್ಯಾತ್ಮಾ ಫಿಲಿಪಂ ಹೃತ್ವಾ ನೀತವಾನ್, ತಸ್ಮಾತ್ ಕ್ಲೀಬಃ ಪುನಸ್ತಂ ನ ದೃಷ್ಟವಾನ್ ತಥಾಪಿ ಹೃಷ್ಟಚಿತ್ತಃ ಸನ್ ಸ್ವಮಾರ್ಗೇಣ ಗತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ಫಿಲಿಪಶ್ಚಾಸ್ದೋದ್ನಗರಮ್ ಉಪಸ್ಥಾಯ ತಸ್ಮಾತ್ ಕೈಸರಿಯಾನಗರ ಉಪಸ್ಥಿತಿಕಾಲಪರ್ಯ್ಯನತಂ ಸರ್ವ್ವಸ್ಮಿನ್ನಗರೇ ಸುಸಂವಾದಂ ಪ್ರಚಾರಯನ್ ಗತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","ತತ್ಕಾಲಪರ್ಯ್ಯನತಂ ಶೌಲಃ ಪ್ರಭೋಃ ಶಿಷ್ಯಾಣಾಂ ಪ್ರಾತಿಕೂಲ್ಯೇನ ತಾಡನಾಬಧಯೋಃ ಕಥಾಂ ನಿಃಸಾರಯನ್ ಮಹಾಯಾಜಕಸ್ಯ ಸನ್ನಿಧಿಂ ಗತ್ವಾ ");
INSERT INTO sankan_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ಸ್ತ್ರಿಯಂ ಪುರುಷಞ್ಚ ತನ್ಮತಗ್ರಾಹಿಣಂ ಯಂ ಕಞ್ಚಿತ್ ಪಶ್ಯತಿ ತಾನ್ ಧೃತ್ವಾ ಬದ್ಧ್ವಾ ಯಿರೂಶಾಲಮಮ್ ಆನಯತೀತ್ಯಾಶಯೇನ ದಮ್ಮೇಷಕ್ನಗರೀಯಂ ಧರ್ಮ್ಮಸಮಾಜಾನ್ ಪ್ರತಿ ಪತ್ರಂ ಯಾಚಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","ಗಚ್ಛನ್ ತು ದಮ್ಮೇಷಕ್ನಗರನಿಕಟ ಉಪಸ್ಥಿತವಾನ್; ತತೋಽಕಸ್ಮಾದ್ ಆಕಾಶಾತ್ ತಸ್ಯ ಚತುರ್ದಿಕ್ಷು ತೇಜಸಃ ಪ್ರಕಾಶನಾತ್ ಸ ಭೂಮಾವಪತತ್| ");
INSERT INTO sankan_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ಪಶ್ಚಾತ್ ಹೇ ಶೌಲ ಹೇ ಶೌಲ ಕುತೋ ಮಾಂ ತಾಡಯಸಿ? ಸ್ವಂ ಪ್ರತಿ ಪ್ರೋಕ್ತಮ್ ಏತಂ ಶಬ್ದಂ ಶ್ರುತ್ವಾ ");
INSERT INTO sankan_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ಸ ಪೃಷ್ಟವಾನ್, ಹೇ ಪ್ರಭೋ ಭವಾನ್ ಕಃ? ತದಾ ಪ್ರಭುರಕಥಯತ್ ಯಂ ಯೀಶುಂ ತ್ವಂ ತಾಡಯಸಿ ಸ ಏವಾಹಂ; ಕಣ್ಟಕಸ್ಯ ಮುಖೇ ಪದಾಘಾತಕರಣಂ ತವ ಕಷ್ಟಮ್| ");
INSERT INTO sankan_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","ತದಾ ಕಮ್ಪಮಾನೋ ವಿಸ್ಮಯಾಪನ್ನಶ್ಚ ಸೋವದತ್ ಹೇ ಪ್ರಭೋ ಮಯಾ ಕಿಂ ಕರ್ತ್ತವ್ಯಂ? ಭವತ ಇಚ್ಛಾ ಕಾ? ತತಃ ಪ್ರಭುರಾಜ್ಞಾಪಯದ್ ಉತ್ಥಾಯ ನಗರಂ ಗಚ್ಛ ತತ್ರ ತ್ವಯಾ ಯತ್ ಕರ್ತ್ತವ್ಯಂ ತದ್ ವದಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","ತಸ್ಯ ಸಙ್ಗಿನೋ ಲೋಕಾ ಅಪಿ ತಂ ಶಬ್ದಂ ಶ್ರುತವನ್ತಃ ಕಿನ್ತು ಕಮಪಿ ನ ದೃಷ್ಟ್ವಾ ಸ್ತಬ್ಧಾಃ ಸನ್ತಃ ಸ್ಥಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","ಅನನ್ತರಂ ಶೌಲೋ ಭೂಮಿತ ಉತ್ಥಾಯ ಚಕ್ಷುಷೀ ಉನ್ಮೀಲ್ಯ ಕಮಪಿ ನ ದೃಷ್ಟವಾನ್| ತದಾ ಲೋಕಾಸ್ತಸ್ಯ ಹಸ್ತೌ ಧೃತ್ವಾ ದಮ್ಮೇಷಕ್ನಗರಮ್ ಆನಯನ್| ");
INSERT INTO sankan_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ತತಃ ಸ ದಿನತ್ರಯಂ ಯಾವದ್ ಅನ್ಧೋ ಭೂತ್ವಾ ನ ಭುಕ್ತವಾನ್ ಪೀತವಾಂಶ್ಚ| ");
INSERT INTO sankan_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","ತದನನ್ತರಂ ಪ್ರಭುಸ್ತದ್ದಮ್ಮೇಷಕ್ನಗರವಾಸಿನ ಏಕಸ್ಮೈ ಶಿಷ್ಯಾಯ ದರ್ಶನಂ ದತ್ವಾ ಆಹೂತವಾನ್ ಹೇ ಅನನಿಯ| ತತಃ ಸ ಪ್ರತ್ಯವಾದೀತ್, ಹೇ ಪ್ರಭೋ ಪಶ್ಯ ಶೃಣೋಮಿ| ");
INSERT INTO sankan_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ತದಾ ಪ್ರಭುಸ್ತಮಾಜ್ಞಾಪಯತ್ ತ್ವಮುತ್ಥಾಯ ಸರಲನಾಮಾನಂ ಮಾರ್ಗಂ ಗತ್ವಾ ಯಿಹೂದಾನಿವೇಶನೇ ತಾರ್ಷನಗರೀಯಂ ಶೌಲನಾಮಾನಂ ಜನಂ ಗವೇಷಯನ್ ಪೃಚ್ಛ; ");
INSERT INTO sankan_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ಪಶ್ಯ ಸ ಪ್ರಾರ್ಥಯತೇ, ತಥಾ ಅನನಿಯನಾಮಕ ಏಕೋ ಜನಸ್ತಸ್ಯ ಸಮೀಪಮ್ ಆಗತ್ಯ ತಸ್ಯ ಗಾತ್ರೇ ಹಸ್ತಾರ್ಪಣಂ ಕೃತ್ವಾ ದೃಷ್ಟಿಂ ದದಾತೀತ್ಥಂ ಸ್ವಪ್ನೇ ದೃಷ್ಟವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","ತಸ್ಮಾದ್ ಅನನಿಯಃ ಪ್ರತ್ಯವದತ್ ಹೇ ಪ್ರಭೋ ಯಿರೂಶಾಲಮಿ ಪವಿತ್ರಲೋಕಾನ್ ಪ್ರತಿ ಸೋಽನೇಕಹಿಂಸಾಂ ಕೃತವಾನ್; ");
INSERT INTO sankan_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","ಅತ್ರ ಸ್ಥಾನೇ ಚ ಯೇ ಲೋಕಾಸ್ತವ ನಾಮ್ನಿ ಪ್ರಾರ್ಥಯನ್ತಿ ತಾನಪಿ ಬದ್ಧುಂ ಸ ಪ್ರಧಾನಯಾಜಕೇಭ್ಯಃ ಶಕ್ತಿಂ ಪ್ರಾಪ್ತವಾನ್, ಇಮಾಂ ಕಥಾಮ್ ಅಹಮ್ ಅನೇಕೇಷಾಂ ಮುಖೇಭ್ಯಃ ಶ್ರುತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","ಕಿನ್ತು ಪ್ರಭುರಕಥಯತ್, ಯಾಹಿ ಭಿನ್ನದೇಶೀಯಲೋಕಾನಾಂ ಭೂಪತೀನಾಮ್ ಇಸ್ರಾಯೇಲ್ಲೋಕಾನಾಞ್ಚ ನಿಕಟೇ ಮಮ ನಾಮ ಪ್ರಚಾರಯಿತುಂ ಸ ಜನೋ ಮಮ ಮನೋನೀತಪಾತ್ರಮಾಸ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","ಮಮ ನಾಮನಿಮಿತ್ತಞ್ಚ ತೇನ ಕಿಯಾನ್ ಮಹಾನ್ ಕ್ಲೇಶೋ ಭೋಕ್ತವ್ಯ ಏತತ್ ತಂ ದರ್ಶಯಿಷ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ತತೋ ಽನನಿಯೋ ಗತ್ವಾ ಗೃಹಂ ಪ್ರವಿಶ್ಯ ತಸ್ಯ ಗಾತ್ರೇ ಹಸ್ತಾರ್ಪ್ರಣಂ ಕೃತ್ವಾ ಕಥಿತವಾನ್, ಹೇ ಭ್ರಾತಃ ಶೌಲ ತ್ವಂ ಯಥಾ ದೃಷ್ಟಿಂ ಪ್ರಾಪ್ನೋಷಿ ಪವಿತ್ರೇಣಾತ್ಮನಾ ಪರಿಪೂರ್ಣೋ ಭವಸಿ ಚ, ತದರ್ಥಂ ತವಾಗಮನಕಾಲೇ ಯಃ ಪ್ರಭುಯೀಶುಸ್ತುಭ್ಯಂ ದರ್ಶನಮ್ ಅದದಾತ್ ಸ ಮಾಂ ಪ್ರೇಷಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ಇತ್ಯುಕ್ತಮಾತ್ರೇ ತಸ್ಯ ಚಕ್ಷುರ್ಭ್ಯಾಮ್ ಮೀನಶಲ್ಕವದ್ ವಸ್ತುನಿ ನಿರ್ಗತೇ ತತ್ಕ್ಷಣಾತ್ ಸ ಪ್ರಸನ್ನಚಕ್ಷು ರ್ಭೂತ್ವಾ ಪ್ರೋತ್ಥಾಯ ಮಜ್ಜಿತೋಽಭವತ್ ಭುಕ್ತ್ವಾ ಪೀತ್ವಾ ಸಬಲೋಭವಚ್ಚ| ");
INSERT INTO sankan_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ತತಃ ಪರಂ ಶೌಲಃ ಶಿಷ್ಯೈಃ ಸಹ ಕತಿಪಯದಿವಸಾನ್ ತಸ್ಮಿನ್ ದಮ್ಮೇಷಕನಗರೇ ಸ್ಥಿತ್ವಾಽವಿಲಮ್ಬಂ ");
INSERT INTO sankan_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ಸರ್ವ್ವಭಜನಭವನಾನಿ ಗತ್ವಾ ಯೀಶುರೀಶ್ವರಸ್ಯ ಪುತ್ರ ಇಮಾಂ ಕಥಾಂ ಪ್ರಾಚಾರಯತ್| ");
INSERT INTO sankan_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","ತಸ್ಮಾತ್ ಸರ್ವ್ವೇ ಶ್ರೋತಾರಶ್ಚಮತ್ಕೃತ್ಯ ಕಥಿತವನ್ತೋ ಯೋ ಯಿರೂಶಾಲಮ್ನಗರ ಏತನ್ನಾಮ್ನಾ ಪ್ರಾರ್ಥಯಿತೃಲೋಕಾನ್ ವಿನಾಶಿತವಾನ್ ಏವಮ್ ಏತಾದೃಶಲೋಕಾನ್ ಬದ್ಧ್ವಾ ಪ್ರಧಾನಯಾಜಕನಿಕಟಂ ನಯತೀತ್ಯಾಶಯಾ ಏತತ್ಸ್ಥಾನಮಪ್ಯಾಗಚ್ಛತ್ ಸಏವ ಕಿಮಯಂ ನ ಭವತಿ? ");
INSERT INTO sankan_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","ಕಿನ್ತು ಶೌಲಃ ಕ್ರಮಶ ಉತ್ಸಾಹವಾನ್ ಭೂತ್ವಾ ಯೀಶುರೀಶ್ವರೇಣಾಭಿಷಿಕ್ತೋ ಜನ ಏತಸ್ಮಿನ್ ಪ್ರಮಾಣಂ ದತ್ವಾ ದಮ್ಮೇಷಕ್-ನಿವಾಸಿಯಿಹೂದೀಯಲೋಕಾನ್ ನಿರುತ್ತರಾನ್ ಅಕರೋತ್| ");
INSERT INTO sankan_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ಇತ್ಥಂ ಬಹುತಿಥೇ ಕಾಲೇ ಗತೇ ಯಿಹೂದೀಯಲೋಕಾಸ್ತಂ ಹನ್ತುಂ ಮನ್ತ್ರಯಾಮಾಸುಃ ");
INSERT INTO sankan_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ಕಿನ್ತು ಶೌಲಸ್ತೇಷಾಮೇತಸ್ಯಾ ಮನ್ತ್ರಣಾಯಾ ವಾರ್ತ್ತಾಂ ಪ್ರಾಪ್ತವಾನ್| ತೇ ತಂ ಹನ್ತುಂ ತು ದಿವಾನಿಶಂ ಗುಪ್ತಾಃ ಸನ್ತೋ ನಗರಸ್ಯ ದ್ವಾರೇಽತಿಷ್ಠನ್; ");
INSERT INTO sankan_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ತಸ್ಮಾತ್ ಶಿಷ್ಯಾಸ್ತಂ ನೀತ್ವಾ ರಾತ್ರೌ ಪಿಟಕೇ ನಿಧಾಯ ಪ್ರಾಚೀರೇಣಾವಾರೋಹಯನ್| ");
INSERT INTO sankan_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","ತತಃ ಪರಂ ಶೌಲೋ ಯಿರೂಶಾಲಮಂ ಗತ್ವಾ ಶಿಷ್ಯಗಣೇನ ಸಾರ್ದ್ಧಂ ಸ್ಥಾತುಮ್ ಐಹತ್, ಕಿನ್ತು ಸರ್ವ್ವೇ ತಸ್ಮಾದಬಿಭಯುಃ ಸ ಶಿಷ್ಯ ಇತಿ ಚ ನ ಪ್ರತ್ಯಯನ್| ");
INSERT INTO sankan_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","ಏತಸ್ಮಾದ್ ಬರ್ಣಬ್ಬಾಸ್ತಂ ಗೃಹೀತ್ವಾ ಪ್ರೇರಿತಾನಾಂ ಸಮೀಪಮಾನೀಯ ಮಾರ್ಗಮಧ್ಯೇ ಪ್ರಭುಃ ಕಥಂ ತಸ್ಮೈ ದರ್ಶನಂ ದತ್ತವಾನ್ ಯಾಃ ಕಥಾಶ್ಚ ಕಥಿತವಾನ್ ಸ ಚ ಯಥಾಕ್ಷೋಭಃ ಸನ್ ದಮ್ಮೇಷಕ್ನಗರೇ ಯೀಶೋ ರ್ನಾಮ ಪ್ರಾಚಾರಯತ್ ಏತಾನ್ ಸರ್ವ್ವವೃತ್ತಾನ್ತಾನ್ ತಾನ್ ಜ್ಞಾಪಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","ತತಃ ಶೌಲಸ್ತೈಃ ಸಹ ಯಿರೂಶಾಲಮಿ ಕಾಲಂ ಯಾಪಯನ್ ನಿರ್ಭಯಂ ಪ್ರಭೋ ರ್ಯೀಶೋ ರ್ನಾಮ ಪ್ರಾಚಾರಯತ್| ");
INSERT INTO sankan_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ತಸ್ಮಾದ್ ಅನ್ಯದೇಶೀಯಲೋಕೈಃ ಸಾರ್ದ್ಧಂ ವಿವಾದಸ್ಯೋಪಸ್ಥಿತತ್ವಾತ್ ತೇ ತಂ ಹನ್ತುಮ್ ಅಚೇಷ್ಟನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","ಕಿನ್ತು ಭ್ರಾತೃಗಣಸ್ತಜ್ಜ್ಞಾತ್ವಾ ತಂ ಕೈಸರಿಯಾನಗರಂ ನೀತ್ವಾ ತಾರ್ಷನಗರಂ ಪ್ರೇಷಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ಇತ್ಥಂ ಸತಿ ಯಿಹೂದಿಯಾಗಾಲೀಲ್ಶೋಮಿರೋಣದೇಶೀಯಾಃ ಸರ್ವ್ವಾ ಮಣ್ಡಲ್ಯೋ ವಿಶ್ರಾಮಂ ಪ್ರಾಪ್ತಾಸ್ತತಸ್ತಾಸಾಂ ನಿಷ್ಠಾಭವತ್ ಪ್ರಭೋ ರ್ಭಿಯಾ ಪವಿತ್ರಸ್ಯಾತ್ಮನಃ ಸಾನ್ತ್ವನಯಾ ಚ ಕಾಲಂ ಕ್ಷೇಪಯಿತ್ವಾ ಬಹುಸಂಖ್ಯಾ ಅಭವನ್| ");
INSERT INTO sankan_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","ತತಃ ಪರಂ ಪಿತರಃ ಸ್ಥಾನೇ ಸ್ಥಾನೇ ಭ್ರಮಿತ್ವಾ ಶೇಷೇ ಲೋದ್ನಗರನಿವಾಸಿಪವಿತ್ರಲೋಕಾನಾಂ ಸಮೀಪೇ ಸ್ಥಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ತದಾ ತತ್ರ ಪಕ್ಷಾಘಾತವ್ಯಾಧಿನಾಷ್ಟೌ ವತ್ಸರಾನ್ ಶಯ್ಯಾಗತಮ್ ಐನೇಯನಾಮಾನಂ ಮನುಷ್ಯಂ ಸಾಕ್ಷತ್ ಪ್ರಾಪ್ಯ ತಮವದತ್, ");
INSERT INTO sankan_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ಹೇ ಐನೇಯ ಯೀಶುಖ್ರೀಷ್ಟಸ್ತ್ವಾಂ ಸ್ವಸ್ಥಮ್ ಅಕಾರ್ಷೀತ್, ತ್ವಮುತ್ಥಾಯ ಸ್ವಶಯ್ಯಾಂ ನಿಕ್ಷಿಪ, ಇತ್ಯುಕ್ತಮಾತ್ರೇ ಸ ಉದತಿಷ್ಠತ್| ");
INSERT INTO sankan_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ಏತಾದೃಶಂ ದೃಷ್ಟ್ವಾ ಲೋದ್ಶಾರೋಣನಿವಾಸಿನೋ ಲೋಕಾಃ ಪ್ರಭುಂ ಪ್ರತಿ ಪರಾವರ್ತ್ತನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","ಅಪರಞ್ಚ ಭಿಕ್ಷಾದಾನಾದಿಷು ನಾನಕ್ರಿಯಾಸು ನಿತ್ಯಂ ಪ್ರವೃತ್ತಾ ಯಾ ಯಾಫೋನಗರನಿವಾಸಿನೀ ಟಾಬಿಥಾನಾಮಾ ಶಿಷ್ಯಾ ಯಾಂ ದರ್ಕ್ಕಾಂ ಅರ್ಥಾದ್ ಹರಿಣೀಮಯುಕ್ತ್ವಾ ಆಹ್ವಯನ್ ಸಾ ನಾರೀ ");
INSERT INTO sankan_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","ತಸ್ಮಿನ್ ಸಮಯೇ ರುಗ್ನಾ ಸತೀ ಪ್ರಾಣಾನ್ ಅತ್ಯಜತ್, ತತೋ ಲೋಕಾಸ್ತಾಂ ಪ್ರಕ್ಷಾಲ್ಯೋಪರಿಸ್ಥಪ್ರಕೋಷ್ಠೇ ಶಾಯಯಿತ್ವಾಸ್ಥಾಪಯನ್| ");
INSERT INTO sankan_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","ಲೋದ್ನಗರಂ ಯಾಫೋನಗರಸ್ಯ ಸಮೀಪಸ್ಥಂ ತಸ್ಮಾತ್ತತ್ರ ಪಿತರ ಆಸ್ತೇ, ಇತಿ ವಾರ್ತ್ತಾಂ ಶ್ರುತ್ವಾ ತೂರ್ಣಂ ತಸ್ಯಾಗಮನಾರ್ಥಂ ತಸ್ಮಿನ್ ವಿನಯಮುಕ್ತ್ವಾ ಶಿಷ್ಯಗಣೋ ದ್ವೌ ಮನುಜೌ ಪ್ರೇಷಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","ತಸ್ಮಾತ್ ಪಿತರ ಉತ್ಥಾಯ ತಾಭ್ಯಾಂ ಸಾರ್ದ್ಧಮ್ ಆಗಚ್ಛತ್, ತತ್ರ ತಸ್ಮಿನ್ ಉಪಸ್ಥಿತ ಉಪರಿಸ್ಥಪ್ರಕೋಷ್ಠಂ ಸಮಾನೀತೇ ಚ ವಿಧವಾಃ ಸ್ವಾಭಿಃ ಸಹ ಸ್ಥಿತಿಕಾಲೇ ದರ್ಕ್ಕಯಾ ಕೃತಾನಿ ಯಾನ್ಯುತ್ತರೀಯಾಣಿ ಪರಿಧೇಯಾನಿ ಚ ತಾನಿ ಸರ್ವ್ವಾಣಿ ತಂ ದರ್ಶಯಿತ್ವಾ ರುದತ್ಯಶ್ಚತಸೃಷು ದಿಕ್ಷ್ವತಿಷ್ಠನ್| ");
INSERT INTO sankan_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","ಕಿನ್ತು ಪಿತರಸ್ತಾಃ ಸರ್ವ್ವಾ ಬಹಿಃ ಕೃತ್ವಾ ಜಾನುನೀ ಪಾತಯಿತ್ವಾ ಪ್ರಾರ್ಥಿತವಾನ್; ಪಶ್ಚಾತ್ ಶವಂ ಪ್ರತಿ ದೃಷ್ಟಿಂ ಕೃತ್ವಾ ಕಥಿತವಾನ್, ಹೇ ಟಾಬೀಥೇ ತ್ವಮುತ್ತಿಷ್ಠ, ಇತಿ ವಾಕ್ಯ ಉಕ್ತೇ ಸಾ ಸ್ತ್ರೀ ಚಕ್ಷುಷೀ ಪ್ರೋನ್ಮೀಲ್ಯ ಪಿತರಮ್ ಅವಲೋಕ್ಯೋತ್ಥಾಯೋಪಾವಿಶತ್| ");
INSERT INTO sankan_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","ತತಃ ಪಿತರಸ್ತಸ್ಯಾಃ ಕರೌ ಧೃತ್ವಾ ಉತ್ತೋಲ್ಯ ಪವಿತ್ರಲೋಕಾನ್ ವಿಧವಾಶ್ಚಾಹೂಯ ತೇಷಾಂ ನಿಕಟೇ ಸಜೀವಾಂ ತಾಂ ಸಮಾರ್ಪಯತ್| ");
INSERT INTO sankan_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ಏಷಾ ಕಥಾ ಸಮಸ್ತಯಾಫೋನಗರಂ ವ್ಯಾಪ್ತಾ ತಸ್ಮಾದ್ ಅನೇಕೇ ಲೋಕಾಃ ಪ್ರಭೌ ವ್ಯಶ್ವಸನ್| ");
INSERT INTO sankan_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","ಅಪರಞ್ಚ ಪಿತರಸ್ತದ್ಯಾಫೋನಗರೀಯಸ್ಯ ಕಸ್ಯಚಿತ್ ಶಿಮೋನ್ನಾಮ್ನಶ್ಚರ್ಮ್ಮಕಾರಸ್ಯ ಗೃಹೇ ಬಹುದಿನಾನಿ ನ್ಯವಸತ್| ");
INSERT INTO sankan_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","ಕೈಸರಿಯಾನಗರ ಇತಾಲಿಯಾಖ್ಯಸೈನ್ಯಾನ್ತರ್ಗತಃ ಕರ್ಣೀಲಿಯನಾಮಾ ಸೇನಾಪತಿರಾಸೀತ್ ");
INSERT INTO sankan_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ಸ ಸಪರಿವಾರೋ ಭಕ್ತ ಈಶ್ವರಪರಾಯಣಶ್ಚಾಸೀತ್; ಲೋಕೇಭ್ಯೋ ಬಹೂನಿ ದಾನಾದೀನಿ ದತ್ವಾ ನಿರನ್ತರಮ್ ಈಶ್ವರೇ ಪ್ರಾರ್ಥಯಾಞ್ಚಕ್ರೇ| ");
INSERT INTO sankan_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ಏಕದಾ ತೃತೀಯಪ್ರಹರವೇಲಾಯಾಂ ಸ ದೃಷ್ಟವಾನ್ ಈಶ್ವರಸ್ಯೈಕೋ ದೂತಃ ಸಪ್ರಕಾಶಂ ತತ್ಸಮೀಪಮ್ ಆಗತ್ಯ ಕಥಿತವಾನ್, ಹೇ ಕರ್ಣೀಲಿಯ| ");
INSERT INTO sankan_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","ಕಿನ್ತು ಸ ತಂ ದೃಷ್ಟ್ವಾ ಭೀತೋಽಕಥಯತ್, ಹೇ ಪ್ರಭೋ ಕಿಂ? ತದಾ ತಮವದತ್ ತವ ಪ್ರಾರ್ಥನಾ ದಾನಾದಿ ಚ ಸಾಕ್ಷಿಸ್ವರೂಪಂ ಭೂತ್ವೇಶ್ವರಸ್ಯ ಗೋಚರಮಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ಇದಾನೀಂ ಯಾಫೋನಗರಂ ಪ್ರತಿ ಲೋಕಾನ್ ಪ್ರೇಷ್ಯ ಸಮುದ್ರತೀರೇ ಶಿಮೋನ್ನಾಮ್ನಶ್ಚರ್ಮ್ಮಕಾರಸ್ಯ ಗೃಹೇ ಪ್ರವಾಸಕಾರೀ ಪಿತರನಾಮ್ನಾ ವಿಖ್ಯಾತೋ ಯಃ ಶಿಮೋನ್ ತಮ್ ಆಹ್ವಾಯಯ; ");
INSERT INTO sankan_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ತಸ್ಮಾತ್ ತ್ವಯಾ ಯದ್ಯತ್ ಕರ್ತ್ತವ್ಯಂ ತತ್ತತ್ ಸ ವದಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ಇತ್ಯುಪದಿಶ್ಯ ದೂತೇ ಪ್ರಸ್ಥಿತೇ ಸತಿ ಕರ್ಣೀಲಿಯಃ ಸ್ವಗೃಹಸ್ಥಾನಾಂ ದಾಸಾನಾಂ ದ್ವೌ ಜನೌ ನಿತ್ಯಂ ಸ್ವಸಙ್ಗಿನಾಂ ಸೈನ್ಯಾನಾಮ್ ಏಕಾಂ ಭಕ್ತಸೇನಾಞ್ಚಾಹೂಯ ");
INSERT INTO sankan_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ಸಕಲಮೇತಂ ವೃತ್ತಾನ್ತಂ ವಿಜ್ಞಾಪ್ಯ ಯಾಫೋನಗರಂ ತಾನ್ ಪ್ರಾಹಿಣೋತ್| ");
INSERT INTO sankan_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","ಪರಸ್ಮಿನ್ ದಿನೇ ತೇ ಯಾತ್ರಾಂ ಕೃತ್ವಾ ಯದಾ ನಗರಸ್ಯ ಸಮೀಪ ಉಪಾತಿಷ್ಠನ್, ತದಾ ಪಿತರೋ ದ್ವಿತೀಯಪ್ರಹರವೇಲಾಯಾಂ ಪ್ರಾರ್ಥಯಿತುಂ ಗೃಹಪೃಷ್ಠಮ್ ಆರೋಹತ್| ");
INSERT INTO sankan_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ಏತಸ್ಮಿನ್ ಸಮಯೇ ಕ್ಷುಧಾರ್ತ್ತಃ ಸನ್ ಕಿಞ್ಚಿದ್ ಭೋಕ್ತುಮ್ ಐಚ್ಛತ್ ಕಿನ್ತು ತೇಷಾಮ್ ಅನ್ನಾಸಾದನಸಮಯೇ ಸ ಮೂರ್ಚ್ಛಿತಃ ಸನ್ನಪತತ್| ");
INSERT INTO sankan_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ತತೋ ಮೇಘದ್ವಾರಂ ಮುಕ್ತಂ ಚತುರ್ಭಿಃ ಕೋಣೈ ರ್ಲಮ್ಬಿತಂ ಬೃಹದ್ವಸ್ತ್ರಮಿವ ಕಿಞ್ಚನ ಭಾಜನಮ್ ಆಕಾಶಾತ್ ಪೃಥಿವೀಮ್ ಅವಾರೋಹತೀತಿ ದೃಷ್ಟವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ತನ್ಮಧ್ಯೇ ನಾನಪ್ರಕಾರಾ ಗ್ರಾಮ್ಯವನ್ಯಪಶವಃ ಖೇಚರೋರೋಗಾಮಿಪ್ರಭೃತಯೋ ಜನ್ತವಶ್ಚಾಸನ್| ");
INSERT INTO sankan_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","ಅನನ್ತರಂ ಹೇ ಪಿತರ ಉತ್ಥಾಯ ಹತ್ವಾ ಭುಂಕ್ಷ್ವ ತಮ್ಪ್ರತೀಯಂ ಗಗಣೀಯಾ ವಾಣೀ ಜಾತಾ| ");
INSERT INTO sankan_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","ತದಾ ಪಿತರಃ ಪ್ರತ್ಯವದತ್, ಹೇ ಪ್ರಭೋ ಈದೃಶಂ ಮಾ ಭವತು, ಅಹಮ್ ಏತತ್ ಕಾಲಂ ಯಾವತ್ ನಿಷಿದ್ಧಮ್ ಅಶುಚಿ ವಾ ದ್ರವ್ಯಂ ಕಿಞ್ಚಿದಪಿ ನ ಭುಕ್ತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ತತಃ ಪುನರಪಿ ತಾದೃಶೀ ವಿಹಯಸೀಯಾ ವಾಣೀ ಜಾತಾ ಯದ್ ಈಶ್ವರಃ ಶುಚಿ ಕೃತವಾನ್ ತತ್ ತ್ವಂ ನಿಷಿದ್ಧಂ ನ ಜಾನೀಹಿ| ");
INSERT INTO sankan_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ಇತ್ಥಂ ತ್ರಿಃ ಸತಿ ತತ್ ಪಾತ್ರಂ ಪುನರಾಕೃಷ್ಟಂ ಆಕಾಶಮ್ ಅಗಚ್ಛತ್| ");
INSERT INTO sankan_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ತತಃ ಪರಂ ಯದ್ ದರ್ಶನಂ ಪ್ರಾಪ್ತವಾನ್ ತಸ್ಯ ಕೋ ಭಾವ ಇತ್ಯತ್ರ ಪಿತರೋ ಮನಸಾ ಸನ್ದೇಗ್ಧಿ, ಏತಸ್ಮಿನ್ ಸಮಯೇ ಕರ್ಣೀಲಿಯಸ್ಯ ತೇ ಪ್ರೇಷಿತಾ ಮನುಷ್ಯಾ ದ್ವಾರಸ್ಯ ಸನ್ನಿಧಾವುಪಸ್ಥಾಯ, ");
INSERT INTO sankan_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ಶಿಮೋನೋ ಗೃಹಮನ್ವಿಚ್ಛನ್ತಃ ಸಮ್ಪೃಛ್ಯಾಹೂಯ ಕಥಿತವನ್ತಃ ಪಿತರನಾಮ್ನಾ ವಿಖ್ಯಾತೋ ಯಃ ಶಿಮೋನ್ ಸ ಕಿಮತ್ರ ಪ್ರವಸತಿ? ");
INSERT INTO sankan_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","ಯದಾ ಪಿತರಸ್ತದ್ದರ್ಶನಸ್ಯ ಭಾವಂ ಮನಸಾನ್ದೋಲಯತಿ ತದಾತ್ಮಾ ತಮವದತ್, ಪಶ್ಯ ತ್ರಯೋ ಜನಾಸ್ತ್ವಾಂ ಮೃಗಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ತ್ವಮ್ ಉತ್ಥಾಯಾವರುಹ್ಯ ನಿಃಸನ್ದೇಹಂ ತೈಃ ಸಹ ಗಚ್ಛ ಮಯೈವ ತೇ ಪ್ರೇಷಿತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","ತಸ್ಮಾತ್ ಪಿತರೋಽವರುಹ್ಯ ಕರ್ಣೀಲಿಯಪ್ರೇರಿತಲೋಕಾನಾಂ ನಿಕಟಮಾಗತ್ಯ ಕಥಿತವಾನ್ ಪಶ್ಯತ ಯೂಯಂ ಯಂ ಮೃಗಯಧ್ವೇ ಸ ಜನೋಹಂ, ಯೂಯಂ ಕಿನ್ನಿಮಿತ್ತಮ್ ಆಗತಾಃ? ");
INSERT INTO sankan_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ತತಸ್ತೇ ಪ್ರತ್ಯವದನ್ ಕರ್ಣೀಲಿಯನಾಮಾ ಶುದ್ಧಸತ್ತ್ವ ಈಶ್ವರಪರಾಯಣೋ ಯಿಹೂದೀಯದೇಶಸ್ಥಾನಾಂ ಸರ್ವ್ವೇಷಾಂ ಸನ್ನಿಧೌ ಸುಖ್ಯಾತ್ಯಾಪನ್ನ ಏಕಃ ಸೇನಾಪತಿ ರ್ನಿಜಗೃಹಂ ತ್ವಾಮಾಹೂಯ ನೇತುಂ ತ್ವತ್ತಃ ಕಥಾ ಶ್ರೋತುಞ್ಚ ಪವಿತ್ರದೂತೇನ ಸಮಾದಿಷ್ಟಃ| ");
INSERT INTO sankan_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","ತದಾ ಪಿತರಸ್ತಾನಭ್ಯನ್ತರಂ ನೀತ್ವಾ ತೇಷಾಮಾತಿಥ್ಯಂ ಕೃತವಾನ್, ಪರೇಽಹನಿ ತೈಃ ಸಾರ್ದ್ಧಂ ಯಾತ್ರಾಮಕರೋತ್, ಯಾಫೋನಿವಾಸಿನಾಂ ಭ್ರಾತೃಣಾಂ ಕಿಯನ್ತೋ ಜನಾಶ್ಚ ತೇನ ಸಹ ಗತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","ಪರಸ್ಮಿನ್ ದಿವಸೇ ಕೈಸರಿಯಾನಗರಮಧ್ಯಪ್ರವೇಶಸಮಯೇ ಕರ್ಣೀಲಿಯೋ ಜ್ಞಾತಿಬನ್ಧೂನ್ ಆಹೂಯಾನೀಯ ತಾನ್ ಅಪೇಕ್ಷ್ಯ ಸ್ಥಿತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","ಪಿತರೇ ಗೃಹ ಉಪಸ್ಥಿತೇ ಕರ್ಣೀಲಿಯಸ್ತಂ ಸಾಕ್ಷಾತ್ಕೃತ್ಯ ಚರಣಯೋಃ ಪತಿತ್ವಾ ಪ್ರಾಣಮತ್| ");
INSERT INTO sankan_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","ಪಿತರಸ್ತಮುತ್ಥಾಪ್ಯ ಕಥಿತವಾನ್, ಉತ್ತಿಷ್ಠಾಹಮಪಿ ಮಾನುಷಃ| ");
INSERT INTO sankan_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ತದಾ ಕರ್ಣೀಲಿಯೇನ ಸಾಕಮ್ ಆಲಪನ್ ಗೃಹಂ ಪ್ರಾವಿಶತ್ ತನ್ಮಧ್ಯೇ ಚ ಬಹುಲೋಕಾನಾಂ ಸಮಾಗಮಂ ದೃಷ್ಟ್ವಾ ತಾನ್ ಅವದತ್, ");
INSERT INTO sankan_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ಅನ್ಯಜಾತೀಯಲೋಕೈಃ ಮಹಾಲಪನಂ ವಾ ತೇಷಾಂ ಗೃಹಮಧ್ಯೇ ಪ್ರವೇಶನಂ ಯಿಹೂದೀಯಾನಾಂ ನಿಷಿದ್ಧಮ್ ಅಸ್ತೀತಿ ಯೂಯಮ್ ಅವಗಚ್ಛಥ; ಕಿನ್ತು ಕಮಪಿ ಮಾನುಷಮ್ ಅವ್ಯವಹಾರ್ಯ್ಯಮ್ ಅಶುಚಿಂ ವಾ ಜ್ಞಾತುಂ ಮಮ ನೋಚಿತಮ್ ಇತಿ ಪರಮೇಶ್ವರೋ ಮಾಂ ಜ್ಞಾಪಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ಇತಿ ಹೇತೋರಾಹ್ವಾನಶ್ರವಣಮಾತ್ರಾತ್ ಕಾಞ್ಚನಾಪತ್ತಿಮ್ ಅಕೃತ್ವಾ ಯುಷ್ಮಾಕಂ ಸಮೀಪಮ್ ಆಗತೋಸ್ಮಿ; ಪೃಚ್ಛಾಮಿ ಯೂಯಂ ಕಿನ್ನಿಮಿತ್ತಂ ಮಾಮ್ ಆಹೂಯತ? ");
INSERT INTO sankan_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","ತದಾ ಕರ್ಣೀಲಿಯಃ ಕಥಿತವಾನ್, ಅದ್ಯ ಚತ್ವಾರಿ ದಿನಾನಿ ಜಾತಾನಿ ಏತಾವದ್ವೇಲಾಂ ಯಾವದ್ ಅಹಮ್ ಅನಾಹಾರ ಆಸನ್ ತತಸ್ತೃತೀಯಪ್ರಹರೇ ಸತಿ ಗೃಹೇ ಪ್ರಾರ್ಥನಸಮಯೇ ತೇಜೋಮಯವಸ್ತ್ರಭೃದ್ ಏಕೋ ಜನೋ ಮಮ ಸಮಕ್ಷಂ ತಿಷ್ಠನ್ ಏತಾಂ ಕಥಾಮ್ ಅಕಥಯತ್, ");
INSERT INTO sankan_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ಹೇ ಕರ್ಣೀಲಿಯ ತ್ವದೀಯಾ ಪ್ರಾರ್ಥನಾ ಈಶ್ವರಸ್ಯ ಕರ್ಣಗೋಚರೀಭೂತಾ ತವ ದಾನಾದಿ ಚ ಸಾಕ್ಷಿಸ್ವರೂಪಂ ಭೂತ್ವಾ ತಸ್ಯ ದೃಷ್ಟಿಗೋಚರಮಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ಅತೋ ಯಾಫೋನಗರಂ ಪ್ರತಿ ಲೋಕಾನ್ ಪ್ರಹಿತ್ಯ ತತ್ರ ಸಮುದ್ರತೀರೇ ಶಿಮೋನ್ನಾಮ್ನಃ ಕಸ್ಯಚಿಚ್ಚರ್ಮ್ಮಕಾರಸ್ಯ ಗೃಹೇ ಪ್ರವಾಸಕಾರೀ ಪಿತರನಾಮ್ನಾ ವಿಖ್ಯಾತೋ ಯಃ ಶಿಮೋನ್ ತಮಾಹೂाಯಯ; ತತಃ ಸ ಆಗತ್ಯ ತ್ವಾಮ್ ಉಪದೇಕ್ಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ಇತಿ ಕಾರಣಾತ್ ತತ್ಕ್ಷಣಾತ್ ತವ ನಿಕಟೇ ಲೋಕಾನ್ ಪ್ರೇಷಿತವಾನ್, ತ್ವಮಾಗತವಾನ್ ಇತಿ ಭದ್ರಂ ಕೃತವಾನ್| ಈಶ್ವರೋ ಯಾನ್ಯಾಖ್ಯಾನಾನಿ ಕಥಯಿತುಮ್ ಆದಿಶತ್ ತಾನಿ ಶ್ರೋತುಂ ವಯಂ ಸರ್ವ್ವೇ ಸಾಮ್ಪ್ರತಮ್ ಈಶ್ವರಸ್ಯ ಸಾಕ್ಷಾದ್ ಉಪಸ್ಥಿತಾಃ ಸ್ಮಃ| ");
INSERT INTO sankan_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","ತದಾ ಪಿತರ ಇಮಾಂ ಕಥಾಂ ಕಥಯಿತುಮ್ ಆರಬ್ಧವಾನ್, ಈಶ್ವರೋ ಮನುಷ್ಯಾಣಾಮ್ ಅಪಕ್ಷಪಾತೀ ಸನ್ ");
INSERT INTO sankan_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ಯಸ್ಯ ಕಸ್ಯಚಿದ್ ದೇಶಸ್ಯ ಯೋ ಲೋಕಾಸ್ತಸ್ಮಾದ್ಭೀತ್ವಾ ಸತ್ಕರ್ಮ್ಮ ಕರೋತಿ ಸ ತಸ್ಯ ಗ್ರಾಹ್ಯೋ ಭವತಿ, ಏತಸ್ಯ ನಿಶ್ಚಯಮ್ ಉಪಲಬ್ಧವಾನಹಮ್| ");
INSERT INTO sankan_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","ಸರ್ವ್ವೇಷಾಂ ಪ್ರಭು ರ್ಯೋ ಯೀಶುಖ್ರೀಷ್ಟಸ್ತೇನ ಈಶ್ವರ ಇಸ್ರಾಯೇಲ್ವಂಶಾನಾಂ ನಿಕಟೇ ಸುಸಂವಾದಂ ಪ್ರೇಷ್ಯ ಸಮ್ಮೇಲನಸ್ಯ ಯಂ ಸಂವಾದಂ ಪ್ರಾಚಾರಯತ್ ತಂ ಸಂವಾದಂ ಯೂಯಂ ಶ್ರುತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","ಯತೋ ಯೋಹನಾ ಮಜ್ಜನೇ ಪ್ರಚಾರಿತೇ ಸತಿ ಸ ಗಾಲೀಲದೇಶಮಾರಭ್ಯ ಸಮಸ್ತಯಿಹೂದೀಯದೇಶಂ ವ್ಯಾಪ್ನೋತ್; ");
INSERT INTO sankan_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ಫಲತ ಈಶ್ವರೇಣ ಪವಿತ್ರೇಣಾತ್ಮನಾ ಶಕ್ತ್ಯಾ ಚಾಭಿಷಿಕ್ತೋ ನಾಸರತೀಯಯೀಶುಃ ಸ್ಥಾನೇ ಸ್ಥಾನೇ ಭ್ರಮನ್ ಸುಕ್ರಿಯಾಂ ಕುರ್ವ್ವನ್ ಶೈತಾನಾ ಕ್ಲಿಷ್ಟಾನ್ ಸರ್ವ್ವಲೋಕಾನ್ ಸ್ವಸ್ಥಾನ್ ಅಕರೋತ್, ಯತ ಈಶ್ವರಸ್ತಸ್ಯ ಸಹಾಯ ಆಸೀತ್; ");
INSERT INTO sankan_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","ವಯಞ್ಚ ಯಿಹೂದೀಯದೇಶೇ ಯಿರೂಶಾಲಮ್ನಗರೇ ಚ ತೇನ ಕೃತಾನಾಂ ಸರ್ವ್ವೇಷಾಂ ಕರ್ಮ್ಮಣಾಂ ಸಾಕ್ಷಿಣೋ ಭವಾಮಃ| ಲೋಕಾಸ್ತಂ ಕ್ರುಶೇ ವಿದ್ಧ್ವಾ ಹತವನ್ತಃ, ");
INSERT INTO sankan_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ಕಿನ್ತು ತೃತೀಯದಿವಸೇ ಈಶ್ವರಸ್ತಮುತ್ಥಾಪ್ಯ ಸಪ್ರಕಾಶಮ್ ಅದರ್ಶಯತ್| ");
INSERT INTO sankan_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ಸರ್ವ್ವಲೋಕಾನಾಂ ನಿಕಟ ಇತಿ ನ ಹಿ, ಕಿನ್ತು ತಸ್ಮಿನ್ ಶ್ಮಶಾನಾದುತ್ಥಿತೇ ಸತಿ ತೇನ ಸಾರ್ದ್ಧಂ ಭೋಜನಂ ಪಾನಞ್ಚ ಕೃತವನ್ತ ಏತಾದೃಶಾ ಈಶ್ವರಸ್ಯ ಮನೋನೀತಾಃ ಸಾಕ್ಷಿಣೋ ಯೇ ವಯಮ್ ಅಸ್ಮಾಕಂ ನಿಕಟೇ ತಮದರ್ಶಯತ್| ");
INSERT INTO sankan_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ಜೀವಿತಮೃತೋಭಯಲೋಕಾನಾಂ ವಿಚಾರಂ ಕರ್ತ್ತುಮ್ ಈಶ್ವರೋ ಯಂ ನಿಯುಕ್ತವಾನ್ ಸ ಏವ ಸ ಜನಃ, ಇಮಾಂ ಕಥಾಂ ಪ್ರಚಾರಯಿತುಂ ತಸ್ಮಿನ್ ಪ್ರಮಾಣಂ ದಾತುಞ್ಚ ಸೋಽಸ್ಮಾನ್ ಆಜ್ಞಾಪಯತ್| ");
INSERT INTO sankan_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ಯಸ್ತಸ್ಮಿನ್ ವಿಶ್ವಸಿತಿ ಸ ತಸ್ಯ ನಾಮ್ನಾ ಪಾಪಾನ್ಮುಕ್ತೋ ಭವಿಷ್ಯತಿ ತಸ್ಮಿನ್ ಸರ್ವ್ವೇ ಭವಿಷ್ಯದ್ವಾದಿನೋಪಿ ಏತಾದೃಶಂ ಸಾಕ್ಷ್ಯಂ ದದತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","ಪಿತರಸ್ಯೈತತ್ಕಥಾಕಥನಕಾಲೇ ಸರ್ವ್ವೇಷಾಂ ಶ್ರೋತೃಣಾಮುಪರಿ ಪವಿತ್ರ ಆತ್ಮಾವಾರೋಹತ್| ");
INSERT INTO sankan_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ತತಃ ಪಿತರೇಣ ಸಾರ್ದ್ಧಮ್ ಆಗತಾಸ್ತ್ವಕ್ಛೇದಿನೋ ವಿಶ್ವಾಸಿನೋ ಲೋಕಾ ಅನ್ಯದೇಶೀಯೇಭ್ಯಃ ಪವಿತ್ರ ಆತ್ಮನಿ ದತ್ತೇ ಸತಿ ");
INSERT INTO sankan_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ತೇ ನಾನಾಜಾತೀಯಭಾಷಾಭಿಃ ಕಥಾಂ ಕಥಯನ್ತ ಈಶ್ವರಂ ಪ್ರಶಂಸನ್ತಿ, ಇತಿ ದೃಷ್ಟ್ವಾ ಶ್ರುತ್ವಾ ಚ ವಿಸ್ಮಯಮ್ ಆಪದ್ಯನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","ತದಾ ಪಿತರಃ ಕಥಿತವಾನ್, ವಯಮಿವ ಯೇ ಪವಿತ್ರಮ್ ಆತ್ಮಾನಂ ಪ್ರಾಪ್ತಾಸ್ತೇಷಾಂ ಜಲಮಜ್ಜನಂ ಕಿಂ ಕೋಪಿ ನಿಷೇದ್ಧುಂ ಶಕ್ನೋತಿ? ");
INSERT INTO sankan_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","ತತಃ ಪ್ರಭೋ ರ್ನಾಮ್ನಾ ಮಜ್ಜಿತಾ ಭವತೇತಿ ತಾನಾಜ್ಞಾಪಯತ್| ಅನನ್ತರಂ ತೇ ಸ್ವೈಃ ಸಾರ್ದ್ಧಂ ಕತಿಪಯದಿನಾನಿ ಸ್ಥಾತುಂ ಪ್ರಾರ್ಥಯನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ಇತ್ಥಂ ಭಿನ್ನದೇಶೀಯಲೋಕಾ ಅಪೀಶ್ವರಸ್ಯ ವಾಕ್ಯಮ್ ಅಗೃಹ್ಲನ್ ಇಮಾಂ ವಾರ್ತ್ತಾಂ ಯಿಹೂದೀಯದೇಶಸ್ಥಪ್ರೇರಿತಾ ಭ್ರಾತೃಗಣಶ್ಚ ಶ್ರುತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ತತಃ ಪಿತರೇ ಯಿರೂಶಾಲಮ್ನಗರಂ ಗತವತಿ ತ್ವಕ್ಛೇದಿನೋ ಲೋಕಾಸ್ತೇನ ಸಹ ವಿವದಮಾನಾ ಅವದನ್, ");
INSERT INTO sankan_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ತ್ವಮ್ ಅತ್ವಕ್ಛೇದಿಲೋಕಾನಾಂ ಗೃಹಂ ಗತ್ವಾ ತೈಃ ಸಾರ್ದ್ಧಂ ಭುಕ್ತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","ತತಃ ಪಿತರ ಆದಿತಃ ಕ್ರಮಶಸ್ತತ್ಕಾರ್ಯ್ಯಸ್ಯ ಸರ್ವ್ವವೃತ್ತಾನ್ತಮಾಖ್ಯಾತುಮ್ ಆರಬ್ಧವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","ಯಾಫೋನಗರ ಏಕದಾಹಂ ಪ್ರಾರ್ಥಯಮಾನೋ ಮೂರ್ಚ್ಛಿತಃ ಸನ್ ದರ್ಶನೇನ ಚತುರ್ಷು ಕೋಣೇಷು ಲಮ್ಬನಮಾನಂ ವೃಹದ್ವಸ್ತ್ರಮಿವ ಪಾತ್ರಮೇಕಮ್ ಆಕಾಶದವರುಹ್ಯ ಮನ್ನಿಕಟಮ್ ಆಗಚ್ಛದ್ ಅಪಶ್ಯಮ್| ");
INSERT INTO sankan_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ಪಶ್ಚಾತ್ ತದ್ ಅನನ್ಯದೃಷ್ಟ್ಯಾ ದೃಷ್ಟ್ವಾ ವಿವಿಚ್ಯ ತಸ್ಯ ಮಧ್ಯೇ ನಾನಾಪ್ರಕಾರಾನ್ ಗ್ರಾಮ್ಯವನ್ಯಪಶೂನ್ ಉರೋಗಾಮಿಖೇಚರಾಂಶ್ಚ ದೃಷ್ಟವಾನ್; ");
INSERT INTO sankan_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","ಹೇ ಪಿತರ ತ್ವಮುತ್ಥಾಯ ಗತ್ವಾ ಭುಂಕ್ಷ್ವ ಮಾಂ ಸಮ್ಬೋಧ್ಯ ಕಥಯನ್ತಂ ಶಬ್ದಮೇಕಂ ಶ್ರುತವಾಂಶ್ಚ| ");
INSERT INTO sankan_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","ತತೋಹಂ ಪ್ರತ್ಯವದಂ, ಹೇ ಪ್ರಭೋ ನೇತ್ಥಂ ಭವತು, ಯತಃ ಕಿಞ್ಚನ ನಿಷಿದ್ಧಮ್ ಅಶುಚಿ ದ್ರವ್ಯಂ ವಾ ಮಮ ಮುಖಮಧ್ಯಂ ಕದಾಪಿ ನ ಪ್ರಾವಿಶತ್| ");
INSERT INTO sankan_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","ಅಪರಮ್ ಈಶ್ವರೋ ಯತ್ ಶುಚಿ ಕೃತವಾನ್ ತನ್ನಿಷಿದ್ಧಂ ನ ಜಾನೀಹಿ ದ್ವಿ ರ್ಮಾಮ್ಪ್ರತೀದೃಶೀ ವಿಹಾಯಸೀಯಾ ವಾಣೀ ಜಾತಾ| ");
INSERT INTO sankan_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","ತ್ರಿರಿತ್ಥಂ ಸತಿ ತತ್ ಸರ್ವ್ವಂ ಪುನರಾಕಾಶಮ್ ಆಕೃಷ್ಟಂ| ");
INSERT INTO sankan_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","ಪಶ್ಚಾತ್ ಕೈಸರಿಯಾನಗರಾತ್ ತ್ರಯೋ ಜನಾ ಮನ್ನಿಕಟಂ ಪ್ರೇಷಿತಾ ಯತ್ರ ನಿವೇಶನೇ ಸ್ಥಿತೋಹಂ ತಸ್ಮಿನ್ ಸಮಯೇ ತತ್ರೋಪಾತಿಷ್ಠನ್| ");
INSERT INTO sankan_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","ತದಾ ನಿಃಸನ್ದೇಹಂ ತೈಃ ಸಾರ್ದ್ಧಂ ಯಾತುಮ್ ಆತ್ಮಾ ಮಾಮಾದಿಷ್ಟವಾನ್; ತತಃ ಪರಂ ಮಯಾ ಸಹೈತೇಷು ಷಡ್ಭ್ರಾತೃಷು ಗತೇಷು ವಯಂ ತಸ್ಯ ಮನುಜಸ್ಯ ಗೃಹಂ ಪ್ರಾವಿಶಾಮ| ");
INSERT INTO sankan_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ಸೋಸ್ಮಾಕಂ ನಿಕಟೇ ಕಥಾಮೇತಾಮ್ ಅಕಥಯತ್ ಏಕದಾ ದೂತ ಏಕಃ ಪ್ರತ್ಯಕ್ಷೀಭೂಯ ಮಮ ಗೃಹಮಧ್ಯೇ ತಿಷ್ಟನ್ ಮಾಮಿತ್ಯಾಜ್ಞಾಪಿತವಾನ್, ಯಾಫೋನಗರಂ ಪ್ರತಿ ಲೋಕಾನ್ ಪ್ರಹಿತ್ಯ ಪಿತರನಾಮ್ನಾ ವಿಖ್ಯಾತಂ ಶಿಮೋನಮ್ ಆಹೂಯಯ; ");
INSERT INTO sankan_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ತತಸ್ತವ ತ್ವದೀಯಪರಿವಾರಾಣಾಞ್ಚ ಯೇನ ಪರಿತ್ರಾಣಂ ಭವಿಷ್ಯತಿ ತತ್ ಸ ಉಪದೇಕ್ಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","ಅಹಂ ತಾಂ ಕಥಾಮುತ್ಥಾಪ್ಯ ಕಥಿತವಾನ್ ತೇನ ಪ್ರಥಮಮ್ ಅಸ್ಮಾಕಮ್ ಉಪರಿ ಯಥಾ ಪವಿತ್ರ ಆತ್ಮಾವರೂಢವಾನ್ ತಥಾ ತೇಷಾಮಪ್ಯುಪರಿ ಸಮವರೂಢವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","ತೇನ ಯೋಹನ್ ಜಲೇ ಮಜ್ಜಿತವಾನ್ ಇತಿ ಸತ್ಯಂ ಕಿನ್ತು ಯೂಯಂ ಪವಿತ್ರ ಆತ್ಮನಿ ಮಜ್ಜಿತಾ ಭವಿಷ್ಯಥ, ಇತಿ ಯದ್ವಾಕ್ಯಂ ಪ್ರಭುರುದಿತವಾನ್ ತತ್ ತದಾ ಮಯಾ ಸ್ಮೃತಮ್| ");
INSERT INTO sankan_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","ಅತಃ ಪ್ರಭಾ ಯೀಶುಖ್ರೀಷ್ಟೇ ಪ್ರತ್ಯಯಕಾರಿಣೋ ಯೇ ವಯಮ್ ಅಸ್ಮಭ್ಯಮ್ ಈಶ್ವರೋ ಯದ್ ದತ್ತವಾನ್ ತತ್ ತೇಭ್ಯೋ ಲೋಕೇಭ್ಯೋಪಿ ದತ್ತವಾನ್ ತತಃ ಕೋಹಂ? ಕಿಮಹಮ್ ಈಶ್ವರಂ ವಾರಯಿತುಂ ಶಕ್ನೋಮಿ? ");
INSERT INTO sankan_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","ಕಥಾಮೇತಾಂ ಶ್ರುವಾ ತೇ ಕ್ಷಾನ್ತಾ ಈಶ್ವರಸ್ಯ ಗುಣಾನ್ ಅನುಕೀರ್ತ್ತ್ಯ ಕಥಿತವನ್ತಃ, ತರ್ಹಿ ಪರಮಾಯುಃಪ್ರಾಪ್ತಿನಿಮಿತ್ತಮ್ ಈಶ್ವರೋನ್ಯದೇಶೀಯಲೋಕೇಭ್ಯೋಪಿ ಮನಃಪರಿವರ್ತ್ತನರೂಪಂ ದಾನಮ್ ಅದಾತ್| ");
INSERT INTO sankan_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","ಸ್ತಿಫಾನಂ ಪ್ರತಿ ಉಪದ್ರವೇ ಘಟಿತೇ ಯೇ ವಿಕೀರ್ಣಾ ಅಭವನ್ ತೈ ಫೈನೀಕೀಕುಪ್ರಾನ್ತಿಯಖಿಯಾಸು ಭ್ರಮಿತ್ವಾ ಕೇವಲಯಿಹೂದೀಯಲೋಕಾನ್ ವಿನಾ ಕಸ್ಯಾಪ್ಯನ್ಯಸ್ಯ ಸಮೀಪ ಈಶ್ವರಸ್ಯ ಕಥಾಂ ನ ಪ್ರಾಚಾರಯನ್| ");
INSERT INTO sankan_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","ಅಪರಂ ತೇಷಾಂ ಕುಪ್ರೀಯಾಃ ಕುರೀನೀಯಾಶ್ಚ ಕಿಯನ್ತೋ ಜನಾ ಆನ್ತಿಯಖಿಯಾನಗರಂ ಗತ್ವಾ ಯೂನಾನೀಯಲೋಕಾನಾಂ ಸಮೀಪೇಪಿ ಪ್ರಭೋರ್ಯೀಶೋಃ ಕಥಾಂ ಪ್ರಾಚಾರಯನ್| ");
INSERT INTO sankan_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ಪ್ರಭೋಃ ಕರಸ್ತೇಷಾಂ ಸಹಾಯ ಆಸೀತ್ ತಸ್ಮಾದ್ ಅನೇಕೇ ಲೋಕಾ ವಿಶ್ವಸ್ಯ ಪ್ರಭುಂ ಪ್ರತಿ ಪರಾವರ್ತ್ತನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ಇತಿ ವಾರ್ತ್ತಾಯಾಂ ಯಿರೂಶಾಲಮಸ್ಥಮಣ್ಡಲೀಯಲೋಕಾನಾಂ ಕರ್ಣಗೋಚರೀಭೂತಾಯಾಮ್ ಆನ್ತಿಯಖಿಯಾನಗರಂ ಗನ್ತು ತೇ ಬರ್ಣಬ್ಬಾಂ ಪ್ರೈರಯನ್| ");
INSERT INTO sankan_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ತತೋ ಬರ್ಣಬ್ಬಾಸ್ತತ್ರ ಉಪಸ್ಥಿತಃ ಸನ್ ಈಶ್ವರಸ್ಯಾನುಗ್ರಹಸ್ಯ ಫಲಂ ದೃಷ್ಟ್ವಾ ಸಾನನ್ದೋ ಜಾತಃ, ");
INSERT INTO sankan_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ಸ ಸ್ವಯಂ ಸಾಧು ರ್ವಿಶ್ವಾಸೇನ ಪವಿತ್ರೇಣಾತ್ಮನಾ ಚ ಪರಿಪೂರ್ಣಃ ಸನ್ ಗನೋನಿಷ್ಟಯಾ ಪ್ರಭಾವಾಸ್ಥಾಂ ಕರ್ತ್ತುಂ ಸರ್ವ್ವಾನ್ ಉಪದಿಷ್ಟವಾನ್ ತೇನ ಪ್ರಭೋಃ ಶಿಷ್ಯಾ ಅನೇಕೇ ಬಭೂವುಃ| ");
INSERT INTO sankan_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","ಶೇಷೇ ಶೌಲಂ ಮೃಗಯಿತುಂ ಬರ್ಣಬ್ಬಾಸ್ತಾರ್ಷನಗರಂ ಪ್ರಸ್ಥಿತವಾನ್| ತತ್ರ ತಸ್ಯೋದ್ದೇಶಂ ಪ್ರಾಪ್ಯ ತಮ್ ಆನ್ತಿಯಖಿಯಾನಗರಮ್ ಆನಯತ್; ");
INSERT INTO sankan_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ತತಸ್ತೌ ಮಣ್ಡಲೀಸ್ಥಲೋಕೈಃ ಸಭಾಂ ಕೃತ್ವಾ ಸಂವತ್ಸರಮೇಕಂ ಯಾವದ್ ಬಹುಲೋಕಾನ್ ಉಪಾದಿಶತಾಂ; ತಸ್ಮಿನ್ ಆನ್ತಿಯಖಿಯಾನಗರೇ ಶಿಷ್ಯಾಃ ಪ್ರಥಮಂ ಖ್ರೀಷ್ಟೀಯನಾಮ್ನಾ ವಿಖ್ಯಾತಾ ಅಭವನ್| ");
INSERT INTO sankan_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","ತತಃ ಪರಂ ಭವಿಷ್ಯದ್ವಾದಿಗಣೇ ಯಿರೂಶಾಲಮ ಆನ್ತಿಯಖಿಯಾನಗರಮ್ ಆಗತೇ ಸತಿ ");
INSERT INTO sankan_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ಆಗಾಬನಾಮಾ ತೇಷಾಮೇಕ ಉತ್ಥಾಯ ಆತ್ಮನಃ ಶಿಕ್ಷಯಾ ಸರ್ವ್ವದೇಶೇ ದುರ್ಭಿಕ್ಷಂ ಭವಿಷ್ಯತೀತಿ ಜ್ಞಾಪಿತವಾನ್; ತತಃ ಕ್ಲೌದಿಯಕೈಸರಸ್ಯಾಧಿಕಾರೇ ಸತಿ ತತ್ ಪ್ರತ್ಯಕ್ಷಮ್ ಅಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","ತಸ್ಮಾತ್ ಶಿಷ್ಯಾ ಏಕೈಕಶಃ ಸ್ವಸ್ವಶಕ್ತ್ಯನುಸಾರತೋ ಯಿಹೂದೀಯದೇಶನಿವಾಸಿನಾಂ ಭ್ರತೃಣಾಂ ದಿನಯಾಪನಾರ್ಥಂ ಧನಂ ಪ್ರೇಷಯಿತುಂ ನಿಶ್ಚಿತ್ಯ ");
INSERT INTO sankan_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ಬರ್ಣಬ್ಬಾಶೌಲಯೋ ರ್ದ್ವಾರಾ ಪ್ರಾಚೀನಲೋಕಾನಾಂ ಸಮೀಪಂ ತತ್ ಪ್ರೇಷಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","ತಸ್ಮಿನ್ ಸಮಯೇ ಹೇರೋದ್‌ರಾಜೋ ಮಣ್ಡಲ್ಯಾಃ ಕಿಯಜ್ಜನೇಭ್ಯೋ ದುಃಖಂ ದಾತುಂ ಪ್ರಾರಭತ್| ");
INSERT INTO sankan_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ವಿಶೇಷತೋ ಯೋಹನಃ ಸೋದರಂ ಯಾಕೂಬಂ ಕರವಾಲಾಘಾತೇನ್ ಹತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ತಸ್ಮಾದ್ ಯಿಹೂದೀಯಾಃ ಸನ್ತುಷ್ಟಾ ಅಭವನ್ ಇತಿ ವಿಜ್ಞಾಯ ಸ ಪಿತರಮಪಿ ಧರ್ತ್ತುಂ ಗತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ತದಾ ಕಿಣ್ವಶೂನ್ಯಪೂಪೋತ್ಸವಸಮಯ ಉಪಾತಿಷ್ಟತ್; ಅತ ಉತ್ಸವೇ ಗತೇ ಸತಿ ಲೋಕಾನಾಂ ಸಮಕ್ಷಂ ತಂ ಬಹಿರಾನೇಯ್ಯಾಮೀತಿ ಮನಸಿ ಸ್ಥಿರೀಕೃತ್ಯ ಸ ತಂ ಧಾರಯಿತ್ವಾ ರಕ್ಷ್ಣಾರ್ಥಮ್ ಯೇಷಾಮ್ ಏಕೈಕಸಂಘೇ ಚತ್ವಾರೋ ಜನಾಃ ಸನ್ತಿ ತೇಷಾಂ ಚತುರ್ಣಾಂ ರಕ್ಷಕಸಂಘಾನಾಂ ಸಮೀಪೇ ತಂ ಸಮರ್ಪ್ಯ ಕಾರಾಯಾಂ ಸ್ಥಾಪಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","ಕಿನ್ತುಂ ಪಿತರಸ್ಯ ಕಾರಾಸ್ಥಿತಿಕಾರಣಾತ್ ಮಣ್ಡಲ್ಯಾ ಲೋಕಾ ಅವಿಶ್ರಾಮಮ್ ಈಶ್ವರಸ್ಯ ಸಮೀಪೇ ಪ್ರಾರ್ಥಯನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","ಅನನ್ತರಂ ಹೇರೋದಿ ತಂ ಬಹಿರಾನಾಯಿತುಂ ಉದ್ಯತೇ ಸತಿ ತಸ್ಯಾಂ ರಾತ್ರೌ ಪಿತರೋ ರಕ್ಷಕದ್ವಯಮಧ್ಯಸ್ಥಾನೇ ಶೃಙ್ಖಲದ್ವಯೇನ ಬದ್ಧ್ವಃ ಸನ್ ನಿದ್ರಿತ ಆಸೀತ್, ದೌವಾರಿಕಾಶ್ಚ ಕಾರಾಯಾಃ ಸಮ್ಮುಖೇ ತಿಷ್ಠನತೋ ದ್ವಾರಮ್ ಅರಕ್ಷಿಷುಃ| ");
INSERT INTO sankan_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ಏತಸ್ಮಿನ್ ಸಮಯೇ ಪರಮೇಶ್ವರಸ್ಯ ದೂತೇ ಸಮುಪಸ್ಥಿತೇ ಕಾರಾ ದೀಪ್ತಿಮತೀ ಜಾತಾ; ತತಃ ಸ ದೂತಃ ಪಿತರಸ್ಯ ಕುಕ್ಷಾವಾವಾತಂ ಕೃತ್ವಾ ತಂ ಜಾಗರಯಿತ್ವಾ ಭಾಷಿತವಾನ್ ತೂರ್ಣಮುತ್ತಿಷ್ಠ; ತತಸ್ತಸ್ಯ ಹಸ್ತಸ್ಥಶೃಙ್ಖಲದ್ವಯಂ ಗಲತ್ ಪತಿತಂ| ");
INSERT INTO sankan_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ಸ ದೂತಸ್ತಮವದತ್, ಬದ್ಧಕಟಿಃ ಸನ್ ಪಾದಯೋಃ ಪಾದುಕೇ ಅರ್ಪಯ; ತೇನ ತಥಾ ಕೃತೇ ಸತಿ ದೂತಸ್ತಮ್ ಉಕ್ತವಾನ್ ಗಾತ್ರೀಯವಸ್ತ್ರಂ ಗಾತ್ರೇ ನಿಧಾಯ ಮಮ ಪಶ್ಚಾದ್ ಏಹಿ| ");
INSERT INTO sankan_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ತತಃ ಪಿತರಸ್ತಸ್ಯ ಪಶ್ಚಾದ್ ವ್ರಜನ ಬಹಿರಗಚ್ಛತ್, ಕಿನ್ತು ದೂತೇನ ಕರ್ಮ್ಮೈತತ್ ಕೃತಮಿತಿ ಸತ್ಯಮಜ್ಞಾತ್ವಾ ಸ್ವಪ್ನದರ್ಶನಂ ಜ್ಞಾತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ಇತ್ಥಂ ತೌ ಪ್ರಥಮಾಂ ದ್ವಿತೀಯಾಞ್ಚ ಕಾರಾಂ ಲಙ್ಘಿತ್ವಾ ಯೇನ ಲೌಹನಿರ್ಮ್ಮಿತದ್ವಾರೇಣ ನಗರಂ ಗಮ್ಯತೇ ತತ್ಸಮೀಪಂ ಪ್ರಾಪ್ನುತಾಂ; ತತಸ್ತಸ್ಯ ಕವಾಟಂ ಸ್ವಯಂ ಮುಕ್ತಮಭವತ್ ತತಸ್ತೌ ತತ್ಸ್ಥಾನಾದ್ ಬಹಿ ರ್ಭೂತ್ವಾ ಮಾರ್ಗೈಕಸ್ಯ ಸೀಮಾಂ ಯಾವದ್ ಗತೌ; ತತೋಽಕಸ್ಮಾತ್ ಸ ದೂತಃ ಪಿತರಂ ತ್ಯಕ್ತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","ತದಾ ಸ ಚೇತನಾಂ ಪ್ರಾಪ್ಯ ಕಥಿತವಾನ್ ನಿಜದೂತಂ ಪ್ರಹಿತ್ಯ ಪರಮೇಶ್ವರೋ ಹೇರೋದೋ ಹಸ್ತಾದ್ ಯಿಹೂದೀಯಲೋಕಾನಾಂ ಸರ್ವ್ವಾಶಾಯಾಶ್ಚ ಮಾಂ ಸಮುದ್ಧೃತವಾನ್ ಇತ್ಯಹಂ ನಿಶ್ಚಯಂ ಜ್ಞಾತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ಸ ವಿವಿಚ್ಯ ಮಾರ್ಕನಾಮ್ರಾ ವಿಖ್ಯಾತಸ್ಯ ಯೋಹನೋ ಮಾತು ರ್ಮರಿಯಮೋ ಯಸ್ಮಿನ್ ಗೃಹೇ ಬಹವಃ ಸಮ್ಭೂಯ ಪ್ರಾರ್ಥಯನ್ತ ತನ್ನಿವೇಶನಂ ಗತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","ಪಿತರೇಣ ಬಹಿರ್ದ್ವಾರ ಆಹತೇ ಸತಿ ರೋದಾನಾಮಾ ಬಾಲಿಕಾ ದ್ರಷ್ಟುಂ ಗತಾ| ");
INSERT INTO sankan_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","ತತಃ ಪಿತರಸ್ಯ ಸ್ವರಂ ಶ್ರುವಾ ಸಾ ಹರ್ಷಯುಕ್ತಾ ಸತೀ ದ್ವಾರಂ ನ ಮೋಚಯಿತ್ವಾ ಪಿತರೋ ದ್ವಾರೇ ತಿಷ್ಠತೀತಿ ವಾರ್ತ್ತಾಂ ವಕ್ತುಮ್ ಅಭ್ಯನ್ತರಂ ಧಾವಿತ್ವಾ ಗತವತೀ| ");
INSERT INTO sankan_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","ತೇ ಪ್ರಾವೋಚನ್ ತ್ವಮುನ್ಮತ್ತಾ ಜಾತಾಸಿ ಕಿನ್ತು ಸಾ ಮುಹುರ್ಮುಹುರುಕ್ತವತೀ ಸತ್ಯಮೇವೈತತ್| ");
INSERT INTO sankan_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","ತದಾ ತೇ ಕಥಿತವನ್ತಸ್ತರ್ಹಿ ತಸ್ಯ ದೂತೋ ಭವೇತ್| ");
INSERT INTO sankan_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","ಪಿತರೋ ದ್ವಾರಮಾಹತವಾನ್ ಏತಸ್ಮಿನ್ನನ್ತರೇ ದ್ವಾರಂ ಮೋಚಯಿತ್ವಾ ಪಿತರಂ ದೃಷ್ಟ್ವಾ ವಿಸ್ಮಯಂ ಪ್ರಾಪ್ತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","ತತಃ ಪಿತರೋ ನಿಃಶಬ್ದಂ ಸ್ಥಾತುಂ ತಾನ್ ಪ್ರತಿ ಹಸ್ತೇನ ಸಙ್ಕೇತಂ ಕೃತ್ವಾ ಪರಮೇಶ್ವರೋ ಯೇನ ಪ್ರಕಾರೇಣ ತಂ ಕಾರಾಯಾ ಉದ್ಧೃತ್ಯಾನೀತವಾನ್ ತಸ್ಯ ವೃತ್ತಾನ್ತಂ ತಾನಜ್ಞಾಪಯತ್, ಯೂಯಂ ಗತ್ವಾ ಯಾಕುಬಂ ಭ್ರಾತೃಗಣಞ್ಚ ವಾರ್ತ್ತಾಮೇತಾಂ ವದತೇತ್ಯುಕ್ತಾ ಸ್ಥಾನಾನ್ತರಂ ಪ್ರಸ್ಥಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ಪ್ರಭಾತೇ ಸತಿ ಪಿತರಃ ಕ್ವ ಗತ ಇತ್ಯತ್ರ ರಕ್ಷಕಾಣಾಂ ಮಧ್ಯೇ ಮಹಾನ್ ಕಲಹೋ ಜಾತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ಹೇರೋದ್ ಬಹು ಮೃಗಯಿತ್ವಾ ತಸ್ಯೋದ್ದೇಶೇ ನ ಪ್ರಾಪ್ತೇ ಸತಿ ರಕ್ಷಕಾನ್ ಸಂಪೃಚ್ಛ್ಯ ತೇಷಾಂ ಪ್ರಾಣಾನ್ ಹನ್ತುಮ್ ಆದಿಷ್ಟವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ಪಶ್ಚಾತ್ ಸ ಯಿಹೂದೀಯಪ್ರದೇಶಾತ್ ಕೈಸರಿಯಾನಗರಂ ಗತ್ವಾ ತತ್ರಾವಾತಿಷ್ಠತ್| ");
INSERT INTO sankan_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","ಸೋರಸೀದೋನದೇಶಯೋ ರ್ಲೋಕೇಭ್ಯೋ ಹೇರೋದಿ ಯುಯುತ್ಸೌ ಸತಿ ತೇ ಸರ್ವ್ವ ಏಕಮನ್ತ್ರಣಾಃ ಸನ್ತಸ್ತಸ್ಯ ಸಮೀಪ ಉಪಸ್ಥಾಯ ಲ್ವಾಸ್ತನಾಮಾನಂ ತಸ್ಯ ವಸ್ತ್ರಗೃಹಾಧೀಶಂ ಸಹಾಯಂ ಕೃತ್ವಾ ಹೇರೋದಾ ಸಾರ್ದ್ಧಂ ಸನ್ಧಿಂ ಪ್ರಾರ್ಥಯನ್ತ ಯತಸ್ತಸ್ಯ ರಾಜ್ಞೋ ದೇಶೇನ ತೇಷಾಂ ದೇಶೀಯಾನಾಂ ಭರಣಮ್ ಅಭವತ್ಂ ");
INSERT INTO sankan_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","ಅತಃ ಕುತ್ರಚಿನ್ ನಿರುಪಿತದಿನೇ ಹೇರೋದ್ ರಾಜಕೀಯಂ ಪರಿಚ್ಛದಂ ಪರಿಧಾಯ ಸಿಂಹಾಸನೇ ಸಮುಪವಿಶ್ಯ ತಾನ್ ಪ್ರತಿ ಕಥಾಮ್ ಉಕ್ತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","ತತೋ ಲೋಕಾ ಉಚ್ಚೈಃಕಾರಂ ಪ್ರತ್ಯವದನ್, ಏಷ ಮನುಜರವೋ ನ ಹಿ, ಈಶ್ವರೀಯರವಃ| ");
INSERT INTO sankan_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","ತದಾ ಹೇರೋದ್ ಈಶ್ವರಸ್ಯ ಸಮ್ಮಾನಂ ನಾಕರೋತ್; ತಸ್ಮಾದ್ಧೇತೋಃ ಪರಮೇಶ್ವರಸ್ಯ ದೂತೋ ಹಠಾತ್ ತಂ ಪ್ರಾಹರತ್ ತೇನೈವ ಸ ಕೀಟೈಃ ಕ್ಷೀಣಃ ಸನ್ ಪ್ರಾಣಾನ್ ಅಜಹಾತ್| ಕಿನ್ತ್ವೀಶ್ವರಸ್ಯ ಕಥಾ ದೇಶಂ ವ್ಯಾಪ್ಯ ಪ್ರಬಲಾಭವತ್| ತತಃ ಪರಂ ಬರ್ಣಬ್ಬಾಶೌಲೌ ಯಸ್ಯ ಕರ್ಮ್ಮಣೋ ಭಾರಂ ಪ್ರಾಪ್ನುತಾಂ ತಾಭ್ಯಾಂ ತಸ್ಮಿನ್ ಸಮ್ಪಾದಿತೇ ಸತಿ ಮಾರ್ಕನಾಮ್ನಾ ವಿಖ್ಯಾತೋ ಯೋ ಯೋಹನ್ ತಂ ಸಙ್ಗಿನಂ ಕೃತ್ವಾ ಯಿರೂಶಾಲಮ್ನಗರಾತ್ ಪ್ರತ್ಯಾಗತೌ| ");
INSERT INTO sankan_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","ಅಪರಞ್ಚ ಬರ್ಣಬ್ಬಾಃ, ಶಿಮೋನ್ ಯಂ ನಿಗ್ರಂ ವದನ್ತಿ, ಕುರೀನೀಯಲೂಕಿಯೋ ಹೇರೋದಾ ರಾಜ್ಞಾ ಸಹ ಕೃತವಿದ್ಯಾाಭ್ಯಾಸೋ ಮಿನಹೇಮ್, ಶೌಲಶ್ಚೈತೇ ಯೇ ಕಿಯನ್ತೋ ಜನಾ ಭವಿಷ್ಯದ್ವಾದಿನ ಉಪದೇಷ್ಟಾರಶ್ಚಾನ್ತಿಯಖಿಯಾನಗರಸ್ಥಮಣ್ಡಲ್ಯಾಮ್ ಆಸನ್, ");
INSERT INTO sankan_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","ತೇ ಯದೋಪವಾಸಂ ಕೃತ್ವೇಶ್ವರಮ್ ಅಸೇವನ್ತ ತಸ್ಮಿನ್ ಸಮಯೇ ಪವಿತ್ರ ಆತ್ಮಾ ಕಥಿತವಾನ್ ಅಹಂ ಯಸ್ಮಿನ್ ಕರ್ಮ್ಮಣಿ ಬರ್ಣಬ್ಬಾಶೈಲೌ ನಿಯುಕ್ತವಾನ್ ತತ್ಕರ್ಮ್ಮ ಕರ್ತ್ತುಂ ತೌ ಪೃಥಕ್ ಕುರುತ| ");
INSERT INTO sankan_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","ತತಸ್ತೈರುಪವಾಸಪ್ರಾರ್ಥನಯೋಃ ಕೃತಯೋಃ ಸತೋಸ್ತೇ ತಯೋ ರ್ಗಾತ್ರಯೋ ರ್ಹಸ್ತಾರ್ಪಣಂ ಕೃತ್ವಾ ತೌ ವ್ಯಸೃಜನ್| ");
INSERT INTO sankan_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","ತತಃ ಪರಂ ತೌ ಪವಿತ್ರೇಣಾತ್ಮನಾ ಪ್ರೇರಿತೌ ಸನ್ತೌ ಸಿಲೂಕಿಯಾನಗರಮ್ ಉಪಸ್ಥಾಯ ಸಮುದ್ರಪಥೇನ ಕುಪ್ರೋಪದ್ವೀಪಮ್ ಅಗಚ್ಛತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ತತಃ ಸಾಲಾಮೀನಗರಮ್ ಉಪಸ್ಥಾಯ ತತ್ರ ಯಿಹೂದೀಯಾನಾಂ ಭಜನಭವನಾನಿ ಗತ್ವೇಶ್ವರಸ್ಯ ಕಥಾಂ ಪ್ರಾಚಾರಯತಾಂ; ಯೋಹನಪಿ ತತ್ಸಹಚರೋಽಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ಇತ್ಥಂ ತೇ ತಸ್ಯೋಪದ್ವೀಪಸ್ಯ ಸರ್ವ್ವತ್ರ ಭ್ರಮನ್ತಃ ಪಾಫನಗರಮ್ ಉಪಸ್ಥಿತಾಃ; ತತ್ರ ಸುವಿವೇಚಕೇನ ಸರ್ಜಿಯಪೌಲನಾಮ್ನಾ ತದ್ದೇಶಾಧಿಪತಿನಾ ಸಹ ಭವಿಷ್ಯದ್ವಾದಿನೋ ವೇಶಧಾರೀ ಬರ್ಯೀಶುನಾಮಾ ಯೋ ಮಾಯಾವೀ ಯಿಹೂದೀ ಆಸೀತ್ ತಂ ಸಾಕ್ಷಾತ್ ಪ್ರಾಪ್ತವತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","ತದ್ದೇಶಾಧಿಪ ಈಶ್ವರಸ್ಯ ಕಥಾಂ ಶ್ರೋತುಂ ವಾಞ್ಛನ್ ಪೌಲಬರ್ಣಬ್ಬೌ ನ್ಯಮನ್ತ್ರಯತ್| ");
INSERT INTO sankan_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","ಕಿನ್ತ್ವಿಲುಮಾ ಯಂ ಮಾಯಾವಿನಂ ವದನ್ತಿ ಸ ದೇಶಾಧಿಪತಿಂ ಧರ್ಮ್ಮಮಾರ್ಗಾದ್ ಬಹಿರ್ಭೂತಂ ಕರ್ತ್ತುಮ್ ಅಯತತ| ");
INSERT INTO sankan_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","ತಸ್ಮಾತ್ ಶೋಲೋಽರ್ಥಾತ್ ಪೌಲಃ ಪವಿತ್ರೇಣಾತ್ಮನಾ ಪರಿಪೂರ್ಣಃ ಸನ್ ತಂ ಮಾಯಾವಿನಂ ಪ್ರತ್ಯನನ್ಯದೃಷ್ಟಿಂ ಕೃತ್ವಾಕಥಯತ್, ");
INSERT INTO sankan_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ಹೇ ನರಕಿನ್ ಧರ್ಮ್ಮದ್ವೇಷಿನ್ ಕೌಟಿಲ್ಯದುಷ್ಕರ್ಮ್ಮಪರಿಪೂರ್ಣ, ತ್ವಂ ಕಿಂ ಪ್ರಭೋಃ ಸತ್ಯಪಥಸ್ಯ ವಿಪರ್ಯ್ಯಯಕರಣಾತ್ ಕದಾಪಿ ನ ನಿವರ್ತ್ತಿಷ್ಯಸೇ? ");
INSERT INTO sankan_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","ಅಧುನಾ ಪರಮೇಶ್ವರಸ್ತವ ಸಮುಚಿತಂ ಕರಿಷ್ಯತಿ ತೇನ ಕತಿಪಯದಿನಾನಿ ತ್ವಮ್ ಅನ್ಧಃ ಸನ್ ಸೂರ್ಯ್ಯಮಪಿ ನ ದ್ರಕ್ಷ್ಯಸಿ| ತತ್ಕ್ಷಣಾದ್ ರಾತ್ರಿವದ್ ಅನ್ಧಕಾರಸ್ತಸ್ಯ ದೃಷ್ಟಿಮ್ ಆಚ್ಛಾದಿತವಾನ್; ತಸ್ಮಾತ್ ತಸ್ಯ ಹಸ್ತಂ ಧರ್ತ್ತುಂ ಸ ಲೋಕಮನ್ವಿಚ್ಛನ್ ಇತಸ್ತತೋ ಭ್ರಮಣಂ ಕೃತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ಏನಾಂ ಘಟನಾಂ ದೃಷ್ಟ್ವಾ ಸ ದೇಶಾಧಿಪತಿಃ ಪ್ರಭೂಪದೇಶಾದ್ ವಿಸ್ಮಿತ್ಯ ವಿಶ್ವಾಸಂ ಕೃತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","ತದನನ್ತರಂ ಪೌಲಸ್ತತ್ಸಙ್ಗಿನೌ ಚ ಪಾಫನಗರಾತ್ ಪ್ರೋತಂ ಚಾಲಯಿತ್ವಾ ಪಮ್ಫುಲಿಯಾದೇಶಸ್ಯ ಪರ್ಗೀನಗರಮ್ ಅಗಚ್ಛನ್ ಕಿನ್ತು ಯೋಹನ್ ತಯೋಃ ಸಮೀಪಾದ್ ಏತ್ಯ ಯಿರೂಶಾಲಮಂ ಪ್ರತ್ಯಾಗಚ್ಛತ್| ");
INSERT INTO sankan_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","ಪಶ್ಚಾತ್ ತೌ ಪರ್ಗೀತೋ ಯಾತ್ರಾಂ ಕೃತ್ವಾ ಪಿಸಿದಿಯಾದೇಶಸ್ಯ ಆನ್ತಿಯಖಿಯಾನಗರಮ್ ಉಪಸ್ಥಾಯ ವಿಶ್ರಾಮವಾರೇ ಭಜನಭವನಂ ಪ್ರವಿಶ್ಯ ಸಮುಪಾವಿಶತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ವ್ಯವಸ್ಥಾಭವಿಷ್ಯದ್ವಾಕ್ಯಯೋಃ ಪಠಿತಯೋಃ ಸತೋ ರ್ಹೇ ಭ್ರಾತರೌ ಲೋಕಾನ್ ಪ್ರತಿ ಯುವಯೋಃ ಕಾಚಿದ್ ಉಪದೇಶಕಥಾ ಯದ್ಯಸ್ತಿ ತರ್ಹಿ ತಾಂ ವದತಂ ತೌ ಪ್ರತಿ ತಸ್ಯ ಭಜನಭವನಸ್ಯಾಧಿಪತಯಃ ಕಥಾಮ್ ಏತಾಂ ಕಥಯಿತ್ವಾ ಪ್ರೈಷಯನ್| ");
INSERT INTO sankan_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ಅತಃ ಪೌಲ ಉತ್ತಿಷ್ಠನ್ ಹಸ್ತೇನ ಸಙ್ಕೇತಂ ಕುರ್ವ್ವನ್ ಕಥಿತವಾನ್ ಹೇ ಇಸ್ರಾಯೇಲೀಯಮನುಷ್ಯಾ ಈಶ್ವರಪರಾಯಣಾಃ ಸರ್ವ್ವೇ ಲೋಕಾ ಯೂಯಮ್ ಅವಧದ್ಧಂ| ");
INSERT INTO sankan_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ಏತೇಷಾಮಿಸ್ರಾಯೇಲ್ಲೋಕಾನಾಮ್ ಈಶ್ವರೋಽಸ್ಮಾಕಂ ಪೂರ್ವ್ವಪರುಷಾನ್ ಮನೋನೀತಾನ್ ಕತ್ವಾ ಗೃಹೀತವಾನ್ ತತೋ ಮಿಸರಿ ದೇಶೇ ಪ್ರವಸನಕಾಲೇ ತೇಷಾಮುನ್ನತಿಂ ಕೃತ್ವಾ ತಸ್ಮಾತ್ ಸ್ವೀಯಬಾಹುಬಲೇನ ತಾನ್ ಬಹಿಃ ಕೃತ್ವಾ ಸಮಾನಯತ್| ");
INSERT INTO sankan_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ಚತ್ವಾರಿಂಶದ್ವತ್ಸರಾನ್ ಯಾವಚ್ಚ ಮಹಾಪ್ರಾನ್ತರೇ ತೇಷಾಂ ಭರಣಂ ಕೃತ್ವಾ ");
INSERT INTO sankan_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ಕಿನಾನ್ದೇಶಾನ್ತರ್ವ್ವರ್ತ್ತೀಣಿ ಸಪ್ತರಾಜ್ಯಾನಿ ನಾಶಯಿತ್ವಾ ಗುಟಿಕಾಪಾತೇನ ತೇಷು ಸರ್ವ್ವದೇಶೇಷು ತೇಭ್ಯೋಽಧಿಕಾರಂ ದತ್ತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ಪಞ್ಚಾಶದಧಿಕಚತುಃಶತೇಷು ವತ್ಸರೇಷು ಗತೇಷು ಚ ಶಿಮೂಯೇಲ್ಭವಿಷ್ಯದ್ವಾದಿಪರ್ಯ್ಯನ್ತಂ ತೇಷಾಮುಪರಿ ವಿಚಾರಯಿತೃನ್ ನಿಯುಕ್ತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","ತೈಶ್ಚ ರಾಜ್ಞಿ ಪ್ರಾರ್ಥಿತೇ, ಈಶ್ವರೋ ಬಿನ್ಯಾಮೀನೋ ವಂಶಜಾತಸ್ಯ ಕೀಶಃ ಪುತ್ರಂ ಶೌಲಂ ಚತ್ವಾರಿಂಶದ್ವರ್ಷಪರ್ಯ್ಯನ್ತಂ ತೇಷಾಮುಪರಿ ರಾಜಾನಂ ಕೃತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","ಪಶ್ಚಾತ್ ತಂ ಪದಚ್ಯುತಂ ಕೃತ್ವಾ ಯೋ ಮದಿಷ್ಟಕ್ರಿಯಾಃ ಸರ್ವ್ವಾಃ ಕರಿಷ್ಯತಿ ತಾದೃಶಂ ಮಮ ಮನೋಭಿಮತಮ್ ಏಕಂ ಜನಂ ಯಿಶಯಃ ಪುತ್ರಂ ದಾಯೂದಂ ಪ್ರಾಪ್ತವಾನ್ ಇದಂ ಪ್ರಮಾಣಂ ಯಸ್ಮಿನ್ ದಾಯೂದಿ ಸ ದತ್ತವಾನ್ ತಂ ದಾಯೂದಂ ತೇಷಾಮುಪರಿ ರಾಜತ್ವಂ ಕರ್ತ್ತುಮ್ ಉತ್ಪಾದಿತವಾನ| ");
INSERT INTO sankan_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","ತಸ್ಯ ಸ್ವಪ್ರತಿಶ್ರುತಸ್ಯ ವಾಕ್ಯಸ್ಯಾನುಸಾರೇಣ ಇಸ್ರಾಯೇಲ್ಲೋಕಾನಾಂ ನಿಮಿತ್ತಂ ತೇಷಾಂ ಮನುಷ್ಯಾಣಾಂ ವಂಶಾದ್ ಈಶ್ವರ ಏಕಂ ಯೀಶುಂ (ತ್ರಾತಾರಮ್) ಉದಪಾದಯತ್| ");
INSERT INTO sankan_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","ತಸ್ಯ ಪ್ರಕಾಶನಾತ್ ಪೂರ್ವ್ವಂ ಯೋಹನ್ ಇಸ್ರಾಯೇಲ್ಲೋಕಾನಾಂ ಸನ್ನಿಧೌ ಮನಃಪರಾವರ್ತ್ತನರೂಪಂ ಮಜ್ಜನಂ ಪ್ರಾಚಾರಯತ್| ");
INSERT INTO sankan_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ಯಸ್ಯ ಚ ಕರ್ಮ್ಮಣೋे ಭಾರಂ ಪ್ರಪ್ತವಾನ್ ಯೋಹನ್ ತನ್ ನಿಷ್ಪಾದಯನ್ ಏತಾಂ ಕಥಾಂ ಕಥಿತವಾನ್, ಯೂಯಂ ಮಾಂ ಕಂ ಜನಂ ಜಾನೀಥ? ಅಹಮ್ ಅಭಿಷಿಕ್ತತ್ರಾತಾ ನಹಿ, ಕಿನ್ತು ಪಶ್ಯತ ಯಸ್ಯ ಪಾದಯೋಃ ಪಾದುಕಯೋ ರ್ಬನ್ಧನೇ ಮೋಚಯಿತುಮಪಿ ಯೋಗ್ಯೋ ನ ಭವಾಮಿ ತಾದೃಶ ಏಕೋ ಜನೋ ಮಮ ಪಶ್ಚಾದ್ ಉಪತಿಷ್ಠತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","ಹೇ ಇಬ್ರಾಹೀಮೋ ವಂಶಜಾತಾ ಭ್ರಾತರೋ ಹೇ ಈಶ್ವರಭೀತಾಃ ಸರ್ವ್ವಲೋಕಾ ಯುಷ್ಮಾನ್ ಪ್ರತಿ ಪರಿತ್ರಾಣಸ್ಯ ಕಥೈಷಾ ಪ್ರೇರಿತಾ| ");
INSERT INTO sankan_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","ಯಿರೂಶಾಲಮ್ನಿವಾಸಿನಸ್ತೇಷಾಮ್ ಅಧಿಪತಯಶ್ಚ ತಸ್ಯ ಯೀಶೋಃ ಪರಿಚಯಂ ನ ಪ್ರಾಪ್ಯ ಪ್ರತಿವಿಶ್ರಾಮವಾರಂ ಪಠ್ಯಮಾನಾನಾಂ ಭವಿಷ್ಯದ್ವಾದಿಕಥಾನಾಮ್ ಅಭಿಪ್ರಾಯಮ್ ಅಬುದ್ಧ್ವಾ ಚ ತಸ್ಯ ವಧೇನ ತಾಃ ಕಥಾಃ ಸಫಲಾ ಅಕುರ್ವ್ವನ್| ");
INSERT INTO sankan_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","ಪ್ರಾಣಹನನಸ್ಯ ಕಮಪಿ ಹೇತುಮ್ ಅಪ್ರಾಪ್ಯಾಪಿ ಪೀಲಾತಸ್ಯ ನಿಕಟೇ ತಸ್ಯ ವಧಂ ಪ್ರಾರ್ಥಯನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","ತಸ್ಮಿನ್ ಯಾಃ ಕಥಾ ಲಿಖಿತಾಃ ಸನ್ತಿ ತದನುಸಾರೇಣ ಕರ್ಮ್ಮ ಸಮ್ಪಾದ್ಯ ತಂ ಕ್ರುಶಾದ್ ಅವತಾರ್ಯ್ಯ ಶ್ಮಶಾನೇ ಶಾಯಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","ಕಿನ್ತ್ವೀಶ್ವರಃ ಶ್ಮಶಾನಾತ್ ತಮುದಸ್ಥಾಪಯತ್, ");
INSERT INTO sankan_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ಪುನಶ್ಚ ಗಾಲೀಲಪ್ರದೇಶಾದ್ ಯಿರೂಶಾಲಮನಗರಂ ತೇನ ಸಾರ್ದ್ಧಂ ಯೇ ಲೋಕಾ ಆಗಚ್ಛನ್ ಸ ಬಹುದಿನಾನಿ ತೇಭ್ಯೋ ದರ್ಶನಂ ದತ್ತವಾನ್, ಅತಸ್ತ ಇದಾನೀಂ ಲೋಕಾನ್ ಪ್ರತಿ ತಸ್ಯ ಸಾಕ್ಷಿಣಃ ಸನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","ಅಸ್ಮಾಕಂ ಪೂರ್ವ್ವಪುರುಷಾಣಾಂ ಸಮಕ್ಷಮ್ ಈಶ್ವರೋ ಯಸ್ಮಿನ್ ಪ್ರತಿಜ್ಞಾತವಾನ್ ಯಥಾ, ತ್ವಂ ಮೇ ಪುತ್ರೋಸಿ ಚಾದ್ಯ ತ್ವಾಂ ಸಮುತ್ಥಾಪಿತವಾನಹಮ್| ");
INSERT INTO sankan_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ಇದಂ ಯದ್ವಚನಂ ದ್ವಿತೀಯಗೀತೇ ಲಿಖಿತಮಾಸ್ತೇ ತದ್ ಯೀಶೋರುತ್ಥಾನೇನ ತೇಷಾಂ ಸನ್ತಾನಾ ಯೇ ವಯಮ್ ಅಸ್ಮಾಕಂ ಸನ್ನಿಧೌ ತೇನ ಪ್ರತ್ಯಕ್ಷೀ ಕೃತಂ, ಯುಷ್ಮಾನ್ ಇಮಂ ಸುಸಂವಾದಂ ಜ್ಞಾಪಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","ಪರಮೇಶ್ವರೇಣ ಶ್ಮಶಾನಾದ್ ಉತ್ಥಾಪಿತಂ ತದೀಯಂ ಶರೀರಂ ಕದಾಪಿ ನ ಕ್ಷೇಷ್ಯತೇ, ಏತಸ್ಮಿನ್ ಸ ಸ್ವಯಂ ಕಥಿತವಾನ್ ಯಥಾ ದಾಯೂದಂ ಪ್ರತಿ ಪ್ರತಿಜ್ಞಾತೋ ಯೋ ವರಸ್ತಮಹಂ ತುಭ್ಯಂ ದಾಸ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","ಏತದನ್ಯಸ್ಮಿನ್ ಗೀತೇಽಪಿ ಕಥಿತವಾನ್| ಸ್ವಕೀಯಂ ಪುಣ್ಯವನ್ತಂ ತ್ವಂ ಕ್ಷಯಿತುಂ ನ ಚ ದಾಸ್ಯಸಿ| ");
INSERT INTO sankan_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","ದಾಯೂದಾ ಈಶ್ವರಾಭಿಮತಸೇವಾಯೈ ನಿಜಾಯುಷಿ ವ್ಯಯಿತೇ ಸತಿ ಸ ಮಹಾನಿದ್ರಾಂ ಪ್ರಾಪ್ಯ ನಿಜೈಃ ಪೂರ್ವ್ವಪುರುಷೈಃ ಸಹ ಮಿಲಿತಃ ಸನ್ ಅಕ್ಷೀಯತ; ");
INSERT INTO sankan_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","ಕಿನ್ತು ಯಮೀಶ್ವರಃ ಶ್ಮಶಾನಾದ್ ಉದಸ್ಥಾಪಯತ್ ಸ ನಾಕ್ಷೀಯತ| ");
INSERT INTO sankan_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","ಅತೋ ಹೇ ಭ್ರಾತರಃ, ಅನೇನ ಜನೇನ ಪಾಪಮೋಚನಂ ಭವತೀತಿ ಯುಷ್ಮಾನ್ ಪ್ರತಿ ಪ್ರಚಾರಿತಮ್ ಆಸ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ಫಲತೋ ಮೂಸಾವ್ಯವಸ್ಥಯಾ ಯೂಯಂ ಯೇಭ್ಯೋ ದೋಷೇಭ್ಯೋ ಮುಕ್ತಾ ಭವಿತುಂ ನ ಶಕ್ಷ್ಯಥ ತೇಭ್ಯಃ ಸರ್ವ್ವದೋಷೇಭ್ಯ ಏತಸ್ಮಿನ್ ಜನೇ ವಿಶ್ವಾಸಿನಃ ಸರ್ವ್ವೇ ಮುಕ್ತಾ ಭವಿಷ್ಯನ್ತೀತಿ ಯುಷ್ಮಾಭಿ ರ್ಜ್ಞಾಯತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","ಅಪರಞ್ಚ| ಅವಜ್ಞಾಕಾರಿಣೋ ಲೋಕಾಶ್ಚಕ್ಷುರುನ್ಮೀಲ್ಯ ಪಶ್ಯತ| ತಥೈವಾಸಮ್ಭವಂ ಜ್ಞಾತ್ವಾ ಸ್ಯಾತ ಯೂಯಂ ವಿಲಜ್ಜಿತಾಃ| ಯತೋ ಯುಷ್ಮಾಸು ತಿಷ್ಠತ್ಸು ಕರಿಷ್ಯೇ ಕರ್ಮ್ಮ ತಾದೃಶಂ| ಯೇನೈವ ತಸ್ಯ ವೃತ್ತಾನ್ತೇ ಯುಷ್ಮಭ್ಯಂ ಕಥಿತೇಽಪಿ ಹಿ| ಯೂಯಂ ನ ತನ್ತು ವೃತ್ತಾನ್ತಂ ಪ್ರತ್ಯೇಷ್ಯಥ ಕದಾಚನ|| ");
INSERT INTO sankan_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","ಯೇಯಂ ಕಥಾ ಭವಿಷ್ಯದ್ವಾದಿನಾಂ ಗ್ರನ್ಥೇಷು ಲಿಖಿತಾಸ್ತೇ ಸಾವಧಾನಾ ಭವತ ಸ ಕಥಾ ಯಥಾ ಯುಷ್ಮಾನ್ ಪ್ರತಿ ನ ಘಟತೇ| ");
INSERT INTO sankan_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ಯಿಹೂದೀಯಭಜನಭವನಾನ್ ನಿರ್ಗತಯೋಸ್ತಯೋ ರ್ಭಿನ್ನದೇಶೀಯೈ ರ್ವಕ್ಷ್ಯಮಾಣಾ ಪ್ರಾರ್ಥನಾ ಕೃತಾ, ಆಗಾಮಿನಿ ವಿಶ್ರಾಮವಾರೇಽಪಿ ಕಥೇಯಮ್ ಅಸ್ಮಾನ್ ಪ್ರತಿ ಪ್ರಚಾರಿತಾ ಭವತ್ವಿತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","ಸಭಾಯಾ ಭಙ್ಗೇ ಸತಿ ಬಹವೋ ಯಿಹೂದೀಯಲೋಕಾ ಯಿಹೂದೀಯಮತಗ್ರಾಹಿಣೋ ಭಕ್ತಲೋಕಾಶ್ಚ ಬರ್ಣಬ್ಬಾಪೌಲಯೋಃ ಪಶ್ಚಾದ್ ಆಗಚ್ಛನ್, ತೇನ ತೌ ತೈಃ ಸಹ ನಾನಾಕಥಾಃ ಕಥಯಿತ್ವೇಶ್ವರಾನುಗ್ರಹಾಶ್ರಯೇ ಸ್ಥಾತುಂ ತಾನ್ ಪ್ರಾವರ್ತ್ತಯತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","ಪರವಿಶ್ರಾಮವಾರೇ ನಗರಸ್ಯ ಪ್ರಾಯೇಣ ಸರ್ವ್ವೇ ಲಾಕಾ ಈಶ್ವರೀಯಾಂ ಕಥಾಂ ಶ್ರೋತುಂ ಮಿಲಿತಾಃ, ");
INSERT INTO sankan_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","ಕಿನ್ತು ಯಿಹೂದೀಯಲೋಕಾ ಜನನಿವಹಂ ವಿಲೋಕ್ಯ ಈರ್ಷ್ಯಯಾ ಪರಿಪೂರ್ಣಾಃ ಸನ್ತೋ ವಿಪರೀತಕಥಾಕಥನೇನೇಶ್ವರನಿನ್ದಯಾ ಚ ಪೌಲೇನೋಕ್ತಾಂ ಕಥಾಂ ಖಣ್ಡಯಿತುಂ ಚೇಷ್ಟಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","ತತಃ ಪೌैಲಬರ್ಣಬ್ಬಾವಕ್ಷೋಭೌ ಕಥಿತವನ್ತೌ ಪ್ರಥಮಂ ಯುಷ್ಮಾಕಂ ಸನ್ನಿಧಾವೀಶ್ವರೀಯಕಥಾಯಾಃ ಪ್ರಚಾರಣಮ್ ಉಚಿತಮಾಸೀತ್ ಕಿನ್ತುಂ ತದಗ್ರಾಹ್ಯತ್ವಕರಣೇನ ಯೂಯಂ ಸ್ವಾನ್ ಅನನ್ತಾಯುಷೋಽಯೋಗ್ಯಾನ್ ದರ್ಶಯಥ, ಏತತ್ಕಾರಣಾದ್ ವಯಮ್ ಅನ್ಯದೇಶೀಯಲೋಕಾನಾಂ ಸಮೀಪಂ ಗಚ್ಛಾಮಃ| ");
INSERT INTO sankan_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ಪ್ರಭುರಸ್ಮಾನ್ ಇತ್ಥಮ್ ಆದಿಷ್ಟವಾನ್ ಯಥಾ, ಯಾವಚ್ಚ ಜಗತಃ ಸೀಮಾಂ ಲೋಕಾನಾಂ ತ್ರಾಣಕಾರಣಾತ್| ಮಯಾನ್ಯದೇಶಮಧ್ಯೇ ತ್ವಂ ಸ್ಥಾಪಿತೋ ಭೂಃ ಪ್ರದೀಪವತ್|| ");
INSERT INTO sankan_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","ತದಾ ಕಥಾಮೀದೃಶೀಂ ಶ್ರುತ್ವಾ ಭಿನ್ನದೇಶೀಯಾ ಆಹ್ಲಾದಿತಾಃ ಸನ್ತಃ ಪ್ರಭೋಃ ಕಥಾಂ ಧನ್ಯಾಂ ಧನ್ಯಾಮ್ ಅವದನ್, ಯಾವನ್ತೋ ಲೋಕಾಶ್ಚ ಪರಮಾಯುಃ ಪ್ರಾಪ್ತಿನಿಮಿತ್ತಂ ನಿರೂಪಿತಾ ಆಸನ್ ತೇे ವ್ಯಶ್ವಸನ್| ");
INSERT INTO sankan_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ಇತ್ಥಂ ಪ್ರಭೋಃ ಕಥಾ ಸರ್ವ್ವೇದೇಶಂ ವ್ಯಾಪ್ನೋತ್| ");
INSERT INTO sankan_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","ಕಿನ್ತು ಯಿಹೂದೀಯಾ ನಗರಸ್ಯ ಪ್ರಧಾನಪುರುಷಾನ್ ಸಮ್ಮಾನ್ಯಾಃ ಕಥಿಪಯಾ ಭಕ್ತಾ ಯೋಷಿತಶ್ಚ ಕುಪ್ರವೃತ್ತಿಂ ಗ್ರಾಹಯಿತ್ವಾ ಪೌಲಬರ್ಣಬ್ಬೌ ತಾಡಯಿತ್ವಾ ತಸ್ಮಾತ್ ಪ್ರದೇಶಾದ್ ದೂರೀಕೃತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","ಅತಃ ಕಾರಣಾತ್ ತೌ ನಿಜಪದಧೂಲೀಸ್ತೇಷಾಂ ಪ್ರಾತಿಕೂಲ್ಯೇನ ಪಾತಯಿತ್ವೇेಕನಿಯಂ ನಗರಂ ಗತೌ| ");
INSERT INTO sankan_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","ತತಃ ಶಿಷ್ಯಗಣ ಆನನ್ದೇನ ಪವಿತ್ರೇಣಾತ್ಮನಾ ಚ ಪರಿಪೂರ್ಣೋಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","ತೌ ದ್ವೌ ಜನೌ ಯುಗಪದ್ ಇಕನಿಯನಗರಸ್ಥಯಿಹೂದೀಯಾನಾಂ ಭಜನಭವನಂ ಗತ್ವಾ ಯಥಾ ಬಹವೋ ಯಿಹೂದೀಯಾ ಅನ್ಯದೇेಶೀಯಲೋಕಾಶ್ಚ ವ್ಯಶ್ವಸನ್ ತಾದೃಶೀಂ ಕಥಾಂ ಕಥಿತವನ್ತೌ| ");
INSERT INTO sankan_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","ಕಿನ್ತು ವಿಶ್ವಾಸಹೀನಾ ಯಿಹೂದೀಯಾ ಅನ್ಯದೇಶೀಯಲೋಕಾನ್ ಕುಪ್ರವೃತ್ತಿಂ ಗ್ರಾಹಯಿತ್ವಾ ಭ್ರಾತೃಗಣಂ ಪ್ರತಿ ತೇಷಾಂ ವೈರಂ ಜನಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ಅತಃ ಸ್ವಾನುಗ್ರಹಕಥಾಯಾಃ ಪ್ರಮಾಣಂ ದತ್ವಾ ತಯೋ ರ್ಹಸ್ತೈ ರ್ಬಹುಲಕ್ಷಣಮ್ ಅದ್ಭುತಕರ್ಮ್ಮ ಚ ಪ್ರಾಕಾಶಯದ್ ಯಃ ಪ್ರಭುಸ್ತಸ್ಯ ಕಥಾ ಅಕ್ಷೋಭೇನ ಪ್ರಚಾರ್ಯ್ಯ ತೌ ತತ್ರ ಬಹುದಿನಾನಿ ಸಮವಾತಿಷ್ಠೇತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","ಕಿನ್ತು ಕಿಯನ್ತೋ ಲೋಕಾ ಯಿಹೂದೀಯಾನಾಂ ಸಪಕ್ಷಾಃ ಕಿಯನ್ತೋ ಲೋಕಾಃ ಪ್ರೇರಿತಾನಾಂ ಸಪಕ್ಷಾ ಜಾತಾಃ, ಅತೋ ನಾಗರಿಕಜನನಿವಹಮಧ್ಯೇ ಭಿನ್ನವಾಕ್ಯತ್ವಮ್ ಅಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","ಅನ್ಯದೇಶೀಯಾ ಯಿಹೂದೀಯಾಸ್ತೇಷಾಮ್ ಅಧಿಪತಯಶ್ಚ ದೌರಾತ್ಮ್ಯಂ ಕುತ್ವಾ ತೌ ಪ್ರಸ್ತರೈರಾಹನ್ತುಮ್ ಉದ್ಯತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ತೌ ತದ್ವಾರ್ತ್ತಾಂ ಪ್ರಾಪ್ಯ ಪಲಾಯಿತ್ವಾ ಲುಕಾಯನಿಯಾದೇಶಸ್ಯಾನ್ತರ್ವ್ವರ್ತ್ತಿಲುಸ್ತ್ರಾದರ್ಬ್ಬೋ ");
INSERT INTO sankan_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ತತ್ಸಮೀಪಸ್ಥದೇಶಞ್ಚ ಗತ್ವಾ ತತ್ರ ಸುಸಂವಾದಂ ಪ್ರಚಾರಯತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","ತತ್ರೋಭಯಪಾದಯೋಶ್ಚಲನಶಕ್ತಿಹೀನೋ ಜನ್ಮಾರಭ್ಯ ಖಞ್ಜಃ ಕದಾಪಿ ಗಮನಂ ನಾಕರೋತ್ ಏತಾದೃಶ ಏಕೋ ಮಾನುಷೋ ಲುಸ್ತ್ರಾನಗರ ಉಪವಿಶ್ಯ ಪೌಲಸ್ಯ ಕಥಾಂ ಶ್ರುತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ಏತಸ್ಮಿನ್ ಸಮಯೇ ಪೌಲಸ್ತಮ್ಪ್ರತಿ ದೃಷ್ಟಿಂ ಕೃತ್ವಾ ತಸ್ಯ ಸ್ವಾಸ್ಥ್ಯೇ ವಿಶ್ವಾಸಂ ವಿದಿತ್ವಾ ಪ್ರೋಚ್ಚೈಃ ಕಥಿತವಾನ್ ");
INSERT INTO sankan_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ಪದ್ಭ್ಯಾಮುತ್ತಿಷ್ಠನ್ ಋಜು ರ್ಭವ| ತತಃ ಸ ಉಲ್ಲಮ್ಫಂ ಕೃತ್ವಾ ಗಮನಾಗಮನೇ ಕುತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","ತದಾ ಲೋಕಾಃ ಪೌಲಸ್ಯ ತತ್ ಕಾರ್ಯ್ಯಂ ವಿಲೋಕ್ಯ ಲುಕಾಯನೀಯಭಾಷಯಾ ಪ್ರೋಚ್ಚೈಃ ಕಥಾಮೇತಾಂ ಕಥಿತವನ್ತಃ, ದೇವಾ ಮನುಷ್ಯರೂಪಂ ಧೃತ್ವಾಸ್ಮಾಕಂ ಸಮೀಪಮ್ ಅವಾರೋಹನ್| ");
INSERT INTO sankan_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","ತೇ ಬರ್ಣಬ್ಬಾಂ ಯೂಪಿತರಮ್ ಅವದನ್ ಪೌಲಶ್ಚ ಮುಖ್ಯೋ ವಕ್ತಾ ತಸ್ಮಾತ್ ತಂ ಮರ್ಕುರಿಯಮ್ ಅವದನ್| ");
INSERT INTO sankan_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ತಸ್ಯ ನಗರಸ್ಯ ಸಮ್ಮುಖೇ ಸ್ಥಾಪಿತಸ್ಯ ಯೂಪಿತರವಿಗ್ರಹಸ್ಯ ಯಾಜಕೋ ವೃಷಾನ್ ಪುಷ್ಪಮಾಲಾಶ್ಚ ದ್ವಾರಸಮೀಪಮ್ ಆನೀಯ ಲೋಕೈಃ ಸರ್ದ್ಧಂ ತಾವುದ್ದಿಶ್ಯ ಸಮುತ್ಸೃಜ್ಯ ದಾತುಮ್ ಉದ್ಯತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","ತದ್ವಾರ್ತ್ತಾಂ ಶ್ರುತ್ವಾ ಬರ್ಣಬ್ಬಾಪೌಲೌ ಸ್ವೀಯವಸ್ತ್ರಾಣಿ ಛಿತ್ವಾ ಲೋಕಾನಾಂ ಮಧ್ಯಂ ವೇಗೇನ ಪ್ರವಿಶ್ಯ ಪ್ರೋಚ್ಚೈಃ ಕಥಿತವನ್ತೌ, ");
INSERT INTO sankan_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","ಹೇ ಮಹೇಚ್ಛಾಃ ಕುತ ಏತಾದೃಶಂ ಕರ್ಮ್ಮ ಕುರುಥ? ಆವಾಮಪಿ ಯುಷ್ಮಾದೃಶೌ ಸುಖದುಃಖಭೋಗಿನೌ ಮನುಷ್ಯೌ, ಯುಯಮ್ ಏತಾಃ ಸರ್ವ್ವಾ ವೃಥಾಕಲ್ಪನಾಃ ಪರಿತ್ಯಜ್ಯ ಯಥಾ ಗಗಣವಸುನ್ಧರಾಜಲನಿಧೀನಾಂ ತನ್ಮಧ್ಯಸ್ಥಾನಾಂ ಸರ್ವ್ವೇಷಾಞ್ಚ ಸ್ರಷ್ಟಾರಮಮರಮ್ ಈಶ್ವರಂ ಪ್ರತಿ ಪರಾವರ್ತ್ತಧ್ವೇ ತದರ್ಥಮ್ ಆವಾಂ ಯುಷ್ಮಾಕಂ ಸನ್ನಿಧೌ ಸುಸಂವಾದಂ ಪ್ರಚಾರಯಾವಃ| ");
INSERT INTO sankan_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ಸ ಈಶ್ವರಃ ಪೂರ್ವ್ವಕಾಲೇ ಸರ್ವ್ವದೇಶೀಯಲೋಕಾನ್ ಸ್ವಸ್ವಮಾರ್ಗೇ ಚಲಿತುಮನುಮತಿಂ ದತ್ತವಾನ್, ");
INSERT INTO sankan_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ತಥಾಪಿ ಆಕಾಶಾತ್ ತೋಯವರ್ಷಣೇನ ನಾನಾಪ್ರಕಾರಶಸ್ಯೋತ್ಪತ್ಯಾ ಚ ಯುಷ್ಮಾಕಂ ಹಿತೈಷೀ ಸನ್ ಭಕ್ಷ್ಯೈರಾನನದೇನ ಚ ಯುಷ್ಮಾಕಮ್ ಅನ್ತಃಕರಣಾನಿ ತರ್ಪಯನ್ ತಾನಿ ದಾನಾನಿ ನಿಜಸಾಕ್ಷಿಸ್ವರೂಪಾಣಿ ಸ್ಥಪಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","ಕಿನ್ತು ತಾದೃಶಾಯಾಂ ಕಥಾಯಾಂ ಕಥಿತಾಯಾಮಪಿ ತಯೋಃ ಸಮೀಪ ಉತ್ಸರ್ಜನಾತ್ ಲೋಕನಿವಹಂ ಪ್ರಾಯೇಣ ನಿವರ್ತ್ತಯಿತುಂ ನಾಶಕ್ನುತಾಮ್| ");
INSERT INTO sankan_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","ಆನ್ತಿಯಖಿಯಾ-ಇಕನಿಯನಗರಾಭ್ಯಾಂ ಕತಿಪಯಯಿಹೂದೀಯಲೋಕಾ ಆಗತ್ಯ ಲೋಕಾನ್ ಪ್ರಾವರ್ತ್ತಯನ್ತ ತಸ್ಮಾತ್ ತೈ ಪೌಲಂ ಪ್ರಸ್ತರೈರಾಘ್ನನ್ ತೇನ ಸ ಮೃತ ಇತಿ ವಿಜ್ಞಾಯ ನಗರಸ್ಯ ಬಹಿಸ್ತಮ್ ಆಕೃಷ್ಯ ನೀತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","ಕಿನ್ತು ಶಿಷ್ಯಗಣೇ ತಸ್ಯ ಚತುರ್ದಿಶಿ ತಿಷ್ಠತಿ ಸತಿ ಸ ಸ್ವಯಮ್ ಉತ್ಥಾಯ ಪುನರಪಿ ನಗರಮಧ್ಯಂ ಪ್ರಾವಿಶತ್ ತತ್ಪರೇಽಹನಿ ಬರ್ಣಬ್ಬಾಸಹಿತೋ ದರ್ಬ್ಬೀನಗರಂ ಗತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","ತತ್ರ ಸುಸಂವಾದಂ ಪ್ರಚಾರ್ಯ್ಯ ಬಹುಲೋಕಾನ್ ಶಿಷ್ಯಾನ್ ಕೃತ್ವಾ ತೌ ಲುಸ್ತ್ರಾಮ್ ಇಕನಿಯಮ್ ಆನ್ತಿಯಖಿಯಾಞ್ಚ ಪರಾವೃತ್ಯ ಗತೌ| ");
INSERT INTO sankan_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ಬಹುದುಃಖಾನಿ ಭುಕ್ತ್ವಾಪೀಶ್ವರರಾಜ್ಯಂ ಪ್ರವೇಷ್ಟವ್ಯಮ್ ಇತಿ ಕಾರಣಾದ್ ಧರ್ಮ್ಮಮಾರ್ಗೇ ಸ್ಥಾತುಂ ವಿನಯಂ ಕೃತ್ವಾ ಶಿಷ್ಯಗಣಸ್ಯ ಮನಃಸ್ಥೈರ್ಯ್ಯಮ್ ಅಕುರುತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","ಮಣ್ಡಲೀನಾಂ ಪ್ರಾಚೀನವರ್ಗಾನ್ ನಿಯುಜ್ಯ ಪ್ರಾರ್ಥನೋಪವಾಸೌ ಕೃತ್ವಾ ಯತ್ಪ್ರಭೌ ತೇ ವ್ಯಶ್ವಸನ್ ತಸ್ಯ ಹಸ್ತೇ ತಾನ್ ಸಮರ್ಪ್ಯ ");
INSERT INTO sankan_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","ಪಿಸಿದಿಯಾಮಧ್ಯೇನ ಪಾಮ್ಫುಲಿಯಾದೇಶಂ ಗತವನ್ತೌ| ");
INSERT INTO sankan_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ಪಶ್ಚಾತ್ ಪರ್ಗಾನಗರಂ ಗತ್ವಾ ಸುಸಂವಾದಂ ಪ್ರಚಾರ್ಯ್ಯ ಅತ್ತಾಲಿಯಾನಗರಂ ಪ್ರಸ್ಥಿತವನ್ತೌ| ");
INSERT INTO sankan_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ತಸ್ಮಾತ್ ಸಮುದ್ರಪಥೇನ ಗತ್ವಾ ತಾಭ್ಯಾಂ ಯತ್ ಕರ್ಮ್ಮ ಸಮ್ಪನ್ನಂ ತತ್ಕರ್ಮ್ಮ ಸಾಧಯಿತುಂ ಯನ್ನಗರೇ ದಯಾಲೋರೀಶ್ವರಸ್ಯ ಹಸ್ತೇ ಸಮರ್ಪಿತೌ ಜಾತೌ ತದ್ ಆನ್ತಿಯಖಿಯಾನಗರಂ ಗತವನ್ತಾ| ");
INSERT INTO sankan_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","ತತ್ರೋಪಸ್ಥಾಯ ತನ್ನಗರಸ್ಥಮಣ್ಡಲೀಂ ಸಂಗೃಹ್ಯ ಸ್ವಾಭ್ಯಾಮ ಈಶ್ವರೋ ಯದ್ಯತ್ ಕರ್ಮ್ಮಕರೋತ್ ತಥಾ ಯೇನ ಪ್ರಕಾರೇಣ ಭಿನ್ನದೇಶೀಯಲೋಕಾನ್ ಪ್ರತಿ ವಿಶ್ವಾಸರೂಪದ್ವಾರಮ್ ಅಮೋಚಯದ್ ಏತಾನ್ ಸರ್ವ್ವವೃತ್ತಾನ್ತಾನ್ ತಾನ್ ಜ್ಞಾಪಿತವನ್ತೌ| ");
INSERT INTO sankan_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ತತಸ್ತೌ ಶಿರ್ಯ್ಯೈಃ ಸಾರ್ದ್ಧಂ ತತ್ರ ಬಹುದಿನಾನಿ ನ್ಯವಸತಾಮ್| ");
INSERT INTO sankan_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","ಯಿಹೂದಾದೇಶಾತ್ ಕಿಯನ್ತೋ ಜನಾ ಆಗತ್ಯ ಭ್ರಾತೃಗಣಮಿತ್ಥಂ ಶಿಕ್ಷಿತವನ್ತೋ ಮೂಸಾವ್ಯವಸ್ಥಯಾ ಯದಿ ಯುಷ್ಮಾಕಂ ತ್ವಕ್ಛೇದೋ ನ ಭವತಿ ತರ್ಹಿ ಯೂಯಂ ಪರಿತ್ರಾಣಂ ಪ್ರಾಪ್ತುಂ ನ ಶಕ್ಷ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","ಪೌಲಬರ್ಣಬ್ಬೌ ತೈಃ ಸಹ ಬಹೂನ್ ವಿಚಾರಾನ್ ವಿವಾದಾಂಶ್ಚ ಕೃತವನ್ತೌ, ತತೋ ಮಣ್ಡಲೀಯನೋಕಾ ಏತಸ್ಯಾಃ ಕಥಾಯಾಸ್ತತ್ತ್ವಂ ಜ್ಞಾತುಂ ಯಿರೂಶಾಲಮ್ನಗರಸ್ಥಾನ್ ಪ್ರೇರಿತಾನ್ ಪ್ರಾಚೀನಾಂಶ್ಚ ಪ್ರತಿ ಪೌಲಬರ್ಣಬ್ಬಾಪ್ರಭೃತೀನ್ ಕತಿಪಯಜನಾನ್ ಪ್ರೇಷಯಿತುಂ ನಿಶ್ಚಯಂ ಕೃತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","ತೇ ಮಣ್ಡಲ್ಯಾ ಪ್ರೇರಿತಾಃ ಸನ್ತಃ ಫೈಣೀಕೀಶೋಮಿರೋನ್ದೇಶಾಭ್ಯಾಂ ಗತ್ವಾ ಭಿನ್ನದೇಶೀಯಾನಾಂ ಮನಃಪರಿವರ್ತ್ತನಸ್ಯ ವಾರ್ತ್ತಯಾ ಭ್ರಾತೃಣಾಂ ಪರಮಾಹ್ಲಾದಮ್ ಅಜನಯನ್| ");
INSERT INTO sankan_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","ಯಿರೂಶಾಲಮ್ಯುಪಸ್ಥಾಯ ಪ್ರೇರಿತಗಣೇನ ಲೋಕಪ್ರಾಚೀನಗಣೇನ ಸಮಾಜೇನ ಚ ಸಮುಪಗೃಹೀತಾಃ ಸನ್ತಃ ಸ್ವೈರೀಶ್ವರೋ ಯಾನಿ ಕರ್ಮ್ಮಾಣಿ ಕೃತವಾನ್ ತೇಷಾಂ ಸರ್ವ್ವವೃತ್ತಾನ್ತಾನ್ ತೇಷಾಂ ಸಮಕ್ಷಮ್ ಅಕಥಯನ್| ");
INSERT INTO sankan_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","ಕಿನ್ತು ವಿಶ್ವಾಸಿನಃ ಕಿಯನ್ತಃ ಫಿರೂಶಿಮತಗ್ರಾಹಿಣೋ ಲೋಕಾ ಉತ್ಥಾಯ ಕಥಾಮೇತಾಂ ಕಥಿತವನ್ತೋ ಭಿನ್ನದೇಶೀಯಾನಾಂ ತ್ವಕ್ಛೇದಂ ಕರ್ತ್ತುಂ ಮೂಸಾವ್ಯವಸ್ಥಾಂ ಪಾಲಯಿತುಞ್ಚ ಸಮಾದೇಷ್ಟವ್ಯಮ್| ");
INSERT INTO sankan_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","ತತಃ ಪ್ರೇರಿತಾ ಲೋಕಪ್ರಾಚೀನಾಶ್ಚ ತಸ್ಯ ವಿವೇಚನಾಂ ಕರ್ತ್ತುಂ ಸಭಾಯಾಂ ಸ್ಥಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","ಬಹುವಿಚಾರೇಷು ಜಾತಷು ಪಿತರ ಉತ್ಥಾಯ ಕಥಿತವಾನ್, ಹೇ ಭ್ರಾತರೋ ಯಥಾ ಭಿನ್ನದೇಶೀಯಲೋಕಾ ಮಮ ಮುಖಾತ್ ಸುಸಂವಾದಂ ಶ್ರುತ್ವಾ ವಿಶ್ವಸನ್ತಿ ತದರ್ಥಂ ಬಹುದಿನಾತ್ ಪೂರ್ವ್ವಮ್ ಈಶ್ವರೋಸ್ಮಾಕಂ ಮಧ್ಯೇ ಮಾಂ ವೃತ್ವಾ ನಿಯುಕ್ತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","ಅನ್ತರ್ಯ್ಯಾಮೀಶ್ವರೋ ಯಥಾಸ್ಮಭ್ಯಂ ತಥಾ ಭಿನ್ನದೇಶೀಯೇಭ್ಯಃ ಪವಿತ್ರಮಾತ್ಮಾನಂ ಪ್ರದಾಯ ವಿಶ್ವಾಸೇನ ತೇಷಾಮ್ ಅನ್ತಃಕರಣಾನಿ ಪವಿತ್ರಾಣಿ ಕೃತ್ವಾ ");
INSERT INTO sankan_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ತೇಷಾಮ್ ಅಸ್ಮಾಕಞ್ಚ ಮಧ್ಯೇ ಕಿಮಪಿ ವಿಶೇಷಂ ನ ಸ್ಥಾಪಯಿತ್ವಾ ತಾನಧಿ ಸ್ವಯಂ ಪ್ರಮಾಣಂ ದತ್ತವಾನ್ ಇತಿ ಯೂಯಂ ಜಾನೀಥ| ");
INSERT INTO sankan_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","ಅತಏವಾಸ್ಮಾಕಂ ಪೂರ್ವ್ವಪುರುಷಾ ವಯಞ್ಚ ಸ್ವಯಂ ಯದ್ಯುಗಸ್ಯ ಭಾರಂ ಸೋಢುಂ ನ ಶಕ್ತಾಃ ಸಮ್ಪ್ರತಿ ತಂ ಶಿಷ್ಯಗಣಸ್ಯ ಸ್ಕನ್ಧೇಷು ನ್ಯಸಿತುಂ ಕುತ ಈಶ್ವರಸ್ಯ ಪರೀಕ್ಷಾಂ ಕರಿಷ್ಯಥ? ");
INSERT INTO sankan_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","ಪ್ರಭೋ ರ್ಯೀಶುಖ್ರೀಷ್ಟಸ್ಯಾನುಗ್ರಹೇಣ ತೇ ಯಥಾ ವಯಮಪಿ ತಥಾ ಪರಿತ್ರಾಣಂ ಪ್ರಾಪ್ತುಮ್ ಆಶಾಂ ಕುರ್ಮ್ಮಃ| ");
INSERT INTO sankan_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","ಅನನ್ತರಂ ಬರ್ಣಬ್ಬಾಪೌಲಾಭ್ಯಾಮ್ ಈಶ್ವರೋ ಭಿನ್ನದೇಶೀಯಾನಾಂ ಮಧ್ಯೇ ಯದ್ಯದ್ ಆಶ್ಚರ್ಯ್ಯಮ್ ಅದ್ಭುತಞ್ಚ ಕರ್ಮ್ಮ ಕೃತವಾನ್ ತದ್ವೃತ್ತಾನ್ತಂ ತೌ ಸ್ವಮುಖಾಭ್ಯಾಮ್ ಅವರ್ಣಯತಾಂ ಸಭಾಸ್ಥಾಃ ಸರ್ವ್ವೇ ನೀರವಾಃ ಸನ್ತಃ ಶ್ರುತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","ತಯೋಃ ಕಥಾಯಾಂ ಸಮಾಪ್ತಾಯಾಂ ಸತ್ಯಾಂ ಯಾಕೂಬ್ ಕಥಯಿತುಮ್ ಆರಬ್ಧವಾನ್ ");
INSERT INTO sankan_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ಹೇ ಭ್ರಾತರೋ ಮಮ ಕಥಾಯಾಮ್ ಮನೋ ನಿಧತ್ತ| ಈಶ್ವರಃ ಸ್ವನಾಮಾರ್ಥಂ ಭಿನ್ನದೇಶೀಯಲೋಕಾನಾಮ್ ಮಧ್ಯಾದ್ ಏಕಂ ಲೋಕಸಂಘಂ ಗ್ರಹೀತುಂ ಮತಿಂ ಕೃತ್ವಾ ಯೇನ ಪ್ರಕಾರೇಣ ಪ್ರಥಮಂ ತಾನ್ ಪ್ರತಿ ಕೃಪಾವಲೇಕನಂ ಕೃತವಾನ್ ತಂ ಶಿಮೋನ್ ವರ್ಣಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ಭವಿಷ್ಯದ್ವಾದಿಭಿರುಕ್ತಾನಿ ಯಾನಿ ವಾಕ್ಯಾನಿ ತೈಃ ಸಾರ್ದ್ಧಮ್ ಏತಸ್ಯೈಕ್ಯಂ ಭವತಿ ಯಥಾ ಲಿಖಿತಮಾಸ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","ಸರ್ವ್ವೇಷಾಂ ಕರ್ಮ್ಮಣಾಂ ಯಸ್ತು ಸಾಧಕಃ ಪರಮೇಶ್ವರಃ| ಸ ಏವೇದಂ ವದೇದ್ವಾಕ್ಯಂ ಶೇಷಾಃ ಸಕಲಮಾನವಾಃ| ಭಿನ್ನದೇಶೀಯಲೋಕಾಶ್ಚ ಯಾವನ್ತೋ ಮಮ ನಾಮತಃ| ಭವನ್ತಿ ಹಿ ಸುವಿಖ್ಯಾತಾಸ್ತೇ ಯಥಾ ಪರಮೇಶಿತುಃ| ");
INSERT INTO sankan_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ತತ್ವಂ ಸಮ್ಯಕ್ ಸಮೀಹನ್ತೇ ತನ್ನಿಮಿತ್ತಮಹಂ ಕಿಲ| ಪರಾವೃತ್ಯ ಸಮಾಗತ್ಯ ದಾಯೂದಃ ಪತಿತಂ ಪುನಃ| ದೂಷ್ಯಮುತ್ಥಾಪಯಿಷ್ಯಾಮಿ ತದೀಯಂ ಸರ್ವ್ವವಸ್ತು ಚ| ಪತಿತಂ ಪುನರುಥಾಪ್ಯ ಸಜ್ಜಯಿಷ್ಯಾಮಿ ಸರ್ವ್ವಥಾ|| ");
INSERT INTO sankan_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ಆ ಪ್ರಥಮಾದ್ ಈಶ್ವರಃ ಸ್ವೀಯಾನಿ ಸರ್ವ್ವಕರ್ಮ್ಮಾಣಿ ಜಾನಾತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","ಅತಏವ ಮಮ ನಿವೇದನಮಿದಂ ಭಿನ್ನದೇಶೀಯಲೋಕಾನಾಂ ಮಧ್ಯೇ ಯೇ ಜನಾ ಈಶ್ವರಂ ಪ್ರತಿ ಪರಾವರ್ತ್ತನ್ತ ತೇಷಾಮುಪರಿ ಅನ್ಯಂ ಕಮಪಿ ಭಾರಂ ನ ನ್ಯಸ್ಯ ");
INSERT INTO sankan_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ದೇವತಾಪ್ರಸಾದಾಶುಚಿಭಕ್ಷ್ಯಂ ವ್ಯಭಿಚಾರಕರ್ಮ್ಮ ಕಣ್ಠಸಮ್ಪೀಡನಮಾರಿತಪ್ರಾಣಿಭಕ್ಷ್ಯಂ ರಕ್ತಭಕ್ಷ್ಯಞ್ಚ ಏತಾನಿ ಪರಿತ್ಯಕ್ತುಂ ಲಿಖಾಮಃ| ");
INSERT INTO sankan_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","ಯತಃ ಪೂರ್ವ್ವಕಾಲತೋ ಮೂಸಾವ್ಯವಸ್ಥಾಪ್ರಚಾರಿಣೋ ಲೋಕಾ ನಗರೇ ನಗರೇ ಸನ್ತಿ ಪ್ರತಿವಿಶ್ರಾಮವಾರಞ್ಚ ಭಜನಭವನೇ ತಸ್ಯಾಃ ಪಾಠೋ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","ತತಃ ಪರಂ ಪ್ರೇರಿತಗಣೋ ಲೋಕಪ್ರಾಚೀನಗಣಃ ಸರ್ವ್ವಾ ಮಣ್ಡಲೀ ಚ ಸ್ವೇಷಾಂ ಮಧ್ಯೇ ಬರ್ಶಬ್ಬಾ ನಾಮ್ನಾ ವಿಖ್ಯಾತೋ ಮನೋನೀತೌ ಕೃತ್ವಾ ಪೌಲಬರ್ಣಬ್ಬಾಭ್ಯಾಂ ಸಾರ್ದ್ಧಮ್ ಆನ್ತಿಯಖಿಯಾನಗರಂ ಪ್ರತಿ ಪ್ರೇಷಣಮ್ ಉಚಿತಂ ಬುದ್ಧ್ವಾ ತಾಭ್ಯಾಂ ಪತ್ರಂ ಪ್ರೈಷಯನ್| ");
INSERT INTO sankan_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ತಸ್ಮಿನ್ ಪತ್ರೇ ಲಿಖಿತಮಿಂದ, ಆನ್ತಿಯಖಿಯಾ-ಸುರಿಯಾ-ಕಿಲಿಕಿಯಾದೇಶಸ್ಥಭಿನ್ನದೇಶೀಯಭ್ರಾತೃಗಣಾಯ ಪ್ರೇರಿತಗಣಸ್ಯ ಲೋಕಪ್ರಾಚೀನಗಣಸ್ಯ ಭ್ರಾತೃಗಣಸ್ಯ ಚ ನಮಸ್ಕಾರಃ| ");
INSERT INTO sankan_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","ವಿಶೇಷತೋಽಸ್ಮಾಕಮ್ ಆಜ್ಞಾಮ್ ಅಪ್ರಾಪ್ಯಾಪಿ ಕಿಯನ್ತೋ ಜನಾ ಅಸ್ಮಾಕಂ ಮಧ್ಯಾದ್ ಗತ್ವಾ ತ್ವಕ್ಛೇದೋ ಮೂಸಾವ್ಯವಸ್ಥಾ ಚ ಪಾಲಯಿತವ್ಯಾವಿತಿ ಯುಷ್ಮಾನ್ ಶಿಕ್ಷಯಿತ್ವಾ ಯುಷ್ಮಾಕಂ ಮನಸಾಮಸ್ಥೈರ್ಯ್ಯಂ ಕೃತ್ವಾ ಯುಷ್ಮಾನ್ ಸಸನ್ದೇಹಾನ್ ಅಕುರ್ವ್ವನ್ ಏತಾಂ ಕಥಾಂ ವಯಮ್ ಅಶೃನ್ಮ| ");
INSERT INTO sankan_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","ತತ್ಕಾರಣಾದ್ ವಯಮ್ ಏಕಮನ್ತ್ರಣಾಃ ಸನ್ತಃ ಸಭಾಯಾಂ ಸ್ಥಿತ್ವಾ ಪ್ರಭೋ ರ್ಯೀಶುಖ್ರೀಷ್ಟಸ್ಯ ನಾಮನಿಮಿತ್ತಂ ಮೃತ್ಯುಮುಖಗತಾಭ್ಯಾಮಸ್ಮಾಕಂ ");
INSERT INTO sankan_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ಪ್ರಿಯಬರ್ಣಬ್ಬಾಪೌಲಾಭ್ಯಾಂ ಸಾರ್ದ್ಧಂ ಮನೋನೀತಲೋಕಾನಾಂ ಕೇಷಾಞ್ಚಿದ್ ಯುಷ್ಮಾಕಂ ಸನ್ನಿಧೌ ಪ್ರೇಷಣಮ್ ಉಚಿತಂ ಬುದ್ಧವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","ಅತೋ ಯಿಹೂದಾಸೀಲೌ ಯುಷ್ಮಾನ್ ಪ್ರತಿ ಪ್ರೇಷಿತವನ್ತಃ, ಏತಯೋ ರ್ಮುಖಾಭ್ಯಾಂ ಸರ್ವ್ವಾಂ ಕಥಾಂ ಜ್ಞಾಸ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","ದೇವತಾಪ್ರಸಾದಭಕ್ಷ್ಯಂ ರಕ್ತಭಕ್ಷ್ಯಂ ಗಲಪೀಡನಮಾರಿತಪ್ರಾಣಿಭಕ್ಷ್ಯಂ ವ್ಯಭಿಚಾರಕರ್ಮ್ಮ ಚೇಮಾನಿ ಸರ್ವ್ವಾಣಿ ಯುಷ್ಮಾಭಿಸ್ತ್ಯಾಜ್ಯಾನಿ; ಏತತ್ಪ್ರಯೋಜನೀಯಾಜ್ಞಾವ್ಯತಿರೇಕೇನ ಯುಷ್ಮಾಕಮ್ ಉಪರಿ ಭಾರಮನ್ಯಂ ನ ನ್ಯಸಿತುಂ ಪವಿತ್ರಸ್ಯಾತ್ಮನೋಽಸ್ಮಾಕಞ್ಚ ಉಚಿತಜ್ಞಾನಮ್ ಅಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ಅತಏವ ತೇಭ್ಯಃ ಸರ್ವ್ವೇಭ್ಯಃ ಸ್ವೇಷು ರಕ್ಷಿತೇಷು ಯೂಯಂ ಭದ್ರಂ ಕರ್ಮ್ಮ ಕರಿಷ್ಯಥ| ಯುಷ್ಮಾಕಂ ಮಙ್ಗಲಂ ಭೂಯಾತ್| ");
INSERT INTO sankan_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","ತೇे ವಿಸೃಷ್ಟಾಃ ಸನ್ತ ಆನ್ತಿಯಖಿಯಾನಗರ ಉಪಸ್ಥಾಯ ಲೋಕನಿವಹಂ ಸಂಗೃಹ್ಯ ಪತ್ರಮ್ ಅದದನ್| ");
INSERT INTO sankan_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ತತಸ್ತೇ ತತ್ಪತ್ರಂ ಪಠಿತ್ವಾ ಸಾನ್ತ್ವನಾಂ ಪ್ರಾಪ್ಯ ಸಾನನ್ದಾ ಅಭವನ್| ");
INSERT INTO sankan_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ಯಿಹೂದಾಸೀಲೌ ಚ ಸ್ವಯಂ ಪ್ರಚಾರಕೌ ಭೂತ್ವಾ ಭ್ರಾತೃಗಣಂ ನಾನೋಪದಿಶ್ಯ ತಾನ್ ಸುಸ್ಥಿರಾನ್ ಅಕುರುತಾಮ್| ");
INSERT INTO sankan_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ಇತ್ಥಂ ತೌ ತತ್ರ ತೈಃ ಸಾಕಂ ಕತಿಪಯದಿನಾನಿ ಯಾಪಯಿತ್ವಾ ಪಶ್ಚಾತ್ ಪ್ರೇರಿತಾನಾಂ ಸಮೀಪೇ ಪ್ರತ್ಯಾಗಮನಾರ್ಥಂ ತೇಷಾಂ ಸನ್ನಿಧೇಃ ಕಲ್ಯಾಣೇನ ವಿಸೃಷ್ಟಾವಭವತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","ಕಿನ್ತು ಸೀಲಸ್ತತ್ರ ಸ್ಥಾತುಂ ವಾಞ್ಛಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","ಅಪರಂ ಪೌಲಬರ್ಣಬ್ಬೌ ಬಹವಃ ಶಿಷ್ಯಾಶ್ಚ ಲೋಕಾನ್ ಉಪದಿಶ್ಯ ಪ್ರಭೋಃ ಸುಸಂವಾದಂ ಪ್ರಚಾರಯನ್ತ ಆನ್ತಿಯಖಿಯಾಯಾಂ ಕಾಲಂ ಯಾಪಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","ಕತಿಪಯದಿನೇಷು ಗತೇಷು ಪೌಲೋ ಬರ್ಣಬ್ಬಾಮ್ ಅವದತ್ ಆಗಚ್ಛಾವಾಂ ಯೇಷು ನಗರೇಷ್ವೀಶ್ವರಸ್ಯ ಸುಸಂವಾದಂ ಪ್ರಚಾರಿತವನ್ತೌ ತಾನಿ ಸರ್ವ್ವನಗರಾಣಿ ಪುನರ್ಗತ್ವಾ ಭ್ರಾತರಃ ಕೀದೃಶಾಃ ಸನ್ತೀತಿ ದ್ರಷ್ಟುಂ ತಾನ್ ಸಾಕ್ಷಾತ್ ಕುರ್ವ್ವಃ| ");
INSERT INTO sankan_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","ತೇನ ಮಾರ್ಕನಾಮ್ನಾ ವಿಖ್ಯಾತಂ ಯೋಹನಂ ಸಙ್ಗಿನಂ ಕರ್ತ್ತುಂ ಬರ್ಣಬ್ಬಾ ಮತಿಮಕರೋತ್, ");
INSERT INTO sankan_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ಕಿನ್ತು ಸ ಪೂರ್ವ್ವಂ ತಾಭ್ಯಾಂ ಸಹ ಕಾರ್ಯ್ಯಾರ್ಥಂ ನ ಗತ್ವಾ ಪಾಮ್ಫೂಲಿಯಾದೇಶೇ ತೌ ತ್ಯಕ್ತವಾನ್ ತತ್ಕಾರಣಾತ್ ಪೌಲಸ್ತಂ ಸಙ್ಗಿನಂ ಕರ್ತ್ತುಮ್ ಅನುಚಿತಂ ಜ್ಞಾತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ಇತ್ಥಂ ತಯೋರತಿಶಯವಿರೋಧಸ್ಯೋಪಸ್ಥಿತತ್ವಾತ್ ತೌ ಪರಸ್ಪರಂ ಪೃಥಗಭವತಾಂ ತತೋ ಬರ್ಣಬ್ಬಾ ಮಾರ್ಕಂ ಗೃಹೀತ್ವಾ ಪೋತೇನ ಕುಪ್ರೋಪದ್ವೀಪಂ ಗತವಾನ್; ");
INSERT INTO sankan_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","ಕಿನ್ತು ಪೌಲಃ ಸೀಲಂ ಮನೋನೀತಂ ಕೃತ್ವಾ ಭ್ರಾತೃಭಿರೀಶ್ವರಾನುಗ್ರಹೇ ಸಮರ್ಪಿತಃ ಸನ್ ಪ್ರಸ್ಥಾಯ ");
INSERT INTO sankan_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","ಸುರಿಯಾಕಿಲಿಕಿಯಾದೇಶಾಭ್ಯಾಂ ಮಣ್ಡಲೀಃ ಸ್ಥಿರೀಕುರ್ವ್ವನ್ ಅಗಚ್ಛತ್| ");
INSERT INTO sankan_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","ಪೌಲೋ ದರ್ಬ್ಬೀಲುಸ್ತ್ರಾನಗರಯೋರುಪಸ್ಥಿತೋಭವತ್ ತತ್ರ ತೀಮಥಿಯನಾಮಾ ಶಿಷ್ಯ ಏಕ ಆಸೀತ್; ಸ ವಿಶ್ವಾಸಿನ್ಯಾ ಯಿಹೂದೀಯಾಯಾ ಯೋಷಿತೋ ಗರ್ಬ್ಭಜಾತಃ ಕಿನ್ತು ತಸ್ಯ ಪಿತಾನ್ಯದೇಶೀಯಲೋಕಃ| ");
INSERT INTO sankan_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","ಸ ಜನೋ ಲುಸ್ತ್ರಾ-ಇಕನಿಯನಗರಸ್ಥಾನಾಂ ಭ್ರಾತೃಣಾಂ ಸಮೀಪೇಪಿ ಸುಖ್ಯಾತಿಮಾನ್ ಆಸೀತ್| ");
INSERT INTO sankan_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","ಪೌಲಸ್ತಂ ಸ್ವಸಙ್ಗಿನಂ ಕರ್ತ್ತುಂ ಮತಿಂ ಕೃತ್ವಾ ತಂ ಗೃಹೀತ್ವಾ ತದ್ದೇಶನಿವಾಸಿನಾಂ ಯಿಹೂದೀಯಾನಾಮ್ ಅನುರೋಧಾತ್ ತಸ್ಯ ತ್ವಕ್ಛೇದಂ ಕೃತವಾನ್ ಯತಸ್ತಸ್ಯ ಪಿತಾ ಭಿನ್ನದೇಶೀಯಲೋಕ ಇತಿ ಸರ್ವ್ವೈರಜ್ಞಾಯತ| ");
INSERT INTO sankan_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","ತತಃ ಪರಂ ತೇ ನಗರೇ ನಗರೇ ಭ್ರಮಿತ್ವಾ ಯಿರೂಶಾಲಮಸ್ಥೈಃ ಪ್ರೇರಿತೈ ರ್ಲೋಕಪ್ರಾಚೀನೈಶ್ಚ ನಿರೂಪಿತಂ ಯದ್ ವ್ಯವಸ್ಥಾಪತ್ರಂ ತದನುಸಾರೇಣಾಚರಿತುಂ ಲೋಕೇಭ್ಯಸ್ತದ್ ದತ್ತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","ತೇನೈವ ಸರ್ವ್ವೇ ಧರ್ಮ್ಮಸಮಾಜಾಃ ಖ್ರೀಷ್ಟಧರ್ಮ್ಮೇ ಸುಸ್ಥಿರಾಃ ಸನ್ತಃ ಪ್ರತಿದಿನಂ ವರ್ದ್ಧಿತಾ ಅಭವನ್| ");
INSERT INTO sankan_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","ತೇಷು ಫ್ರುಗಿಯಾಗಾಲಾತಿಯಾದೇಶಮಧ್ಯೇನ ಗತೇಷು ಸತ್ಸು ಪವಿತ್ರ ಆತ್ಮಾ ತಾನ್ ಆಶಿಯಾದೇಶೇ ಕಥಾಂ ಪ್ರಕಾಶಯಿತುಂ ಪ್ರತಿಷಿದ್ಧವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ತಥಾ ಮುಸಿಯಾದೇಶ ಉಪಸ್ಥಾಯ ಬಿಥುನಿಯಾಂ ಗನ್ತುಂ ತೈರುದ್ಯೋಗೇ ಕೃತೇ ಆತ್ಮಾ ತಾನ್ ನಾನ್ವಮನ್ಯತ| ");
INSERT INTO sankan_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","ತಸ್ಮಾತ್ ತೇ ಮುಸಿಯಾದೇಶಂ ಪರಿತ್ಯಜ್ಯ ತ್ರೋಯಾನಗರಂ ಗತ್ವಾ ಸಮುಪಸ್ಥಿತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ರಾತ್ರೌ ಪೌಲಃ ಸ್ವಪ್ನೇ ದೃಷ್ಟವಾನ್ ಏಕೋ ಮಾಕಿದನಿಯಲೋಕಸ್ತಿಷ್ಠನ್ ವಿನಯಂ ಕೃತ್ವಾ ತಸ್ಮೈ ಕಥಯತಿ, ಮಾಕಿದನಿಯಾದೇಶಮ್ ಆಗತ್ಯಾಸ್ಮಾನ್ ಉಪಕುರ್ವ್ವಿತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ತಸ್ಯೇತ್ಥಂ ಸ್ವಪ್ನದರ್ಶನಾತ್ ಪ್ರಭುಸ್ತದ್ದೇಶೀಯಲೋಕಾನ್ ಪ್ರತಿ ಸುಸಂವಾದಂ ಪ್ರಚಾರಯಿತುಮ್ ಅಸ್ಮಾನ್ ಆಹೂಯತೀತಿ ನಿಶ್ಚಿತಂ ಬುದ್ಧ್ವಾ ವಯಂ ತೂರ್ಣಂ ಮಾಕಿದನಿಯಾದೇಶಂ ಗನ್ತುಮ್ ಉದ್ಯೋಗಮ್ ಅಕುರ್ಮ್ಮ| ");
INSERT INTO sankan_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","ತತಃ ಪರಂ ವಯಂ ತ್ರೋಯಾನಗರಾದ್ ಪ್ರಸ್ಥಾಯ ಋಜುಮಾರ್ಗೇಣ ಸಾಮಥ್ರಾಕಿಯೋಪದ್ವೀಪೇನ ಗತ್ವಾ ಪರೇಽಹನಿ ನಿಯಾಪಲಿನಗರ ಉಪಸ್ಥಿತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ತಸ್ಮಾದ್ ಗತ್ವಾ ಮಾಕಿದನಿಯಾನ್ತರ್ವ್ವರ್ತ್ತಿ ರೋಮೀಯವಸತಿಸ್ಥಾನಂ ಯತ್ ಫಿಲಿಪೀನಾಮಪ್ರಧಾನನಗರಂ ತತ್ರೋಪಸ್ಥಾಯ ಕತಿಪಯದಿನಾನಿ ತತ್ರ ಸ್ಥಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","ವಿಶ್ರಾಮವಾರೇ ನಗರಾದ್ ಬಹಿ ರ್ಗತ್ವಾ ನದೀತಟೇ ಯತ್ರ ಪ್ರಾರ್ಥನಾಚಾರ ಆಸೀತ್ ತತ್ರೋಪವಿಶ್ಯ ಸಮಾಗತಾ ನಾರೀಃ ಪ್ರತಿ ಕಥಾಂ ಪ್ರಾಚಾರಯಾಮ| ");
INSERT INTO sankan_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","ತತಃ ಥುಯಾತೀರಾನಗರೀಯಾ ಧೂಷರಾಮ್ಬರವಿಕ್ರಾಯಿಣೀ ಲುದಿಯಾನಾಮಿಕಾ ಯಾ ಈಶ್ವರಸೇವಿಕಾ ಯೋಷಿತ್ ಶ್ರೋತ್ರೀಣಾಂ ಮಧ್ಯ ಆಸೀತ್ ತಯಾ ಪೌಲೋಕ್ತವಾಕ್ಯಾನಿ ಯದ್ ಗೃಹ್ಯನ್ತೇ ತದರ್ಥಂ ಪ್ರಭುಸ್ತಸ್ಯಾ ಮನೋದ್ವಾರಂ ಮುಕ್ತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ಅತಃ ಸಾ ಯೋಷಿತ್ ಸಪರಿವಾರಾ ಮಜ್ಜಿತಾ ಸತೀ ವಿನಯಂ ಕೃತ್ವಾ ಕಥಿತವತೀ, ಯುಷ್ಮಾಕಂ ವಿಚಾರಾದ್ ಯದಿ ಪ್ರಭೌ ವಿಶ್ವಾಸಿನೀ ಜಾತಾಹಂ ತರ್ಹಿ ಮಮ ಗೃಹಮ್ ಆಗತ್ಯ ತಿಷ್ಠತ| ಇತ್ಥಂ ಸಾ ಯತ್ನೇನಾಸ್ಮಾನ್ ಅಸ್ಥಾಪಯತ್| ");
INSERT INTO sankan_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","ಯಸ್ಯಾ ಗಣನಯಾ ತದಧಿಪತೀನಾಂ ಬಹುಧನೋಪಾರ್ಜನಂ ಜಾತಂ ತಾದೃಶೀ ಗಣಕಭೂತಗ್ರಸ್ತಾ ಕಾಚನ ದಾಸೀ ಪ್ರಾರ್ಥನಾಸ್ಥಾನಗಮನಕಾಲ ಆಗತ್ಯಾಸ್ಮಾನ್ ಸಾಕ್ಷಾತ್ ಕೃತವತೀ| ");
INSERT INTO sankan_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","ಸಾಸ್ಮಾಕಂ ಪೌಲಸ್ಯ ಚ ಪಶ್ಚಾದ್ ಏತ್ಯ ಪ್ರೋಚ್ಚೈಃ ಕಥಾಮಿಮಾಂ ಕಥಿತವತೀ, ಮನುಷ್ಯಾ ಏತೇ ಸರ್ವ್ವೋಪರಿಸ್ಥಸ್ಯೇಶ್ವರಸ್ಯ ಸೇವಕಾಃ ಸನ್ತೋಽಸ್ಮಾನ್ ಪ್ರತಿ ಪರಿತ್ರಾಣಸ್ಯ ಮಾರ್ಗಂ ಪ್ರಕಾಶಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","ಸಾ ಕನ್ಯಾ ಬಹುದಿನಾನಿ ತಾದೃಶಮ್ ಅಕರೋತ್ ತಸ್ಮಾತ್ ಪೌಲೋ ದುಃಖಿತಃ ಸನ್ ಮುಖಂ ಪರಾವರ್ತ್ಯ ತಂ ಭೂತಮವದದ್, ಅಹಂ ಯೀಶುಖ್ರೀಷ್ಟಸ್ಯ ನಾಮ್ನಾ ತ್ವಾಮಾಜ್ಞಾಪಯಾಮಿ ತ್ವಮಸ್ಯಾ ಬಹಿರ್ಗಚ್ಛ; ತೇನೈವ ತತ್ಕ್ಷಣಾತ್ ಸ ಭೂತಸ್ತಸ್ಯಾ ಬಹಿರ್ಗತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","ತತಃ ಸ್ವೇಷಾಂ ಲಾಭಸ್ಯ ಪ್ರತ್ಯಾಶಾ ವಿಫಲಾ ಜಾತೇತಿ ವಿಲೋಕ್ಯ ತಸ್ಯಾಃ ಪ್ರಭವಃ ಪೌಲಂ ಸೀಲಞ್ಚ ಧೃತ್ವಾಕೃಷ್ಯ ವಿಚಾರಸ್ಥಾನೇಽಧಿಪತೀನಾಂ ಸಮೀಪಮ್ ಆನಯನ್| ");
INSERT INTO sankan_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ತತಃ ಶಾಸಕಾನಾಂ ನಿಕಟಂ ನೀತ್ವಾ ರೋಮಿಲೋಕಾ ವಯಮ್ ಅಸ್ಮಾಕಂ ಯದ್ ವ್ಯವಹರಣಂ ಗ್ರಹೀತುಮ್ ಆಚರಿತುಞ್ಚ ನಿಷಿದ್ಧಂ, ");
INSERT INTO sankan_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ಇಮೇ ಯಿಹೂದೀಯಲೋಕಾಃ ಸನ್ತೋಪಿ ತದೇವ ಶಿಕ್ಷಯಿತ್ವಾ ನಗರೇಽಸ್ಮಾಕಮ್ ಅತೀವ ಕಲಹಂ ಕುರ್ವ್ವನ್ತಿ, ");
INSERT INTO sankan_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","ಇತಿ ಕಥಿತೇ ಸತಿ ಲೋಕನಿವಹಸ್ತಯೋಃ ಪ್ರಾತಿಕೂಲ್ಯೇನೋದತಿಷ್ಠತ್ ತಥಾ ಶಾಸಕಾಸ್ತಯೋ ರ್ವಸ್ತ್ರಾಣಿ ಛಿತ್ವಾ ವೇತ್ರಾಘಾತಂ ಕರ್ತ್ತುಮ್ ಆಜ್ಞಾಪಯನ್| ");
INSERT INTO sankan_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","ಅಪರಂ ತೇ ತೌ ಬಹು ಪ್ರಹಾರ್ಯ್ಯ ತ್ವಮೇತೌ ಕಾರಾಂ ನೀತ್ವಾ ಸಾವಧಾನಂ ರಕ್ಷಯೇತಿ ಕಾರಾರಕ್ಷಕಮ್ ಆದಿಶನ್| ");
INSERT INTO sankan_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ಇತ್ಥಮ್ ಆಜ್ಞಾಂ ಪ್ರಾಪ್ಯ ಸ ತಾವಭ್ಯನ್ತರಸ್ಥಕಾರಾಂ ನೀತ್ವಾ ಪಾದೇಷು ಪಾದಪಾಶೀಭಿ ರ್ಬದ್ಧ್ವಾ ಸ್ಥಾಪಿತಾವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","ಅಥ ನಿಶೀಥಸಮಯೇ ಪೌಲಸೀಲಾವೀಶ್ವರಮುದ್ದಿಶ್ಯ ಪ್ರಾಥನಾಂ ಗಾನಞ್ಚ ಕೃತವನ್ತೌ, ಕಾರಾಸ್ಥಿತಾ ಲೋಕಾಶ್ಚ ತದಶೃಣ್ವನ್ ");
INSERT INTO sankan_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ತದಾಕಸ್ಮಾತ್ ಮಹಾನ್ ಭೂಮಿಕಮ್ಪೋಽಭವತ್ ತೇನ ಭಿತ್ತಿಮೂಲೇನ ಸಹ ಕಾರಾ ಕಮ್ಪಿತಾಭೂತ್ ತತ್ಕ್ಷಣಾತ್ ಸರ್ವ್ವಾಣಿ ದ್ವಾರಾಣಿ ಮುಕ್ತಾನಿ ಜಾತಾನಿ ಸರ್ವ್ವೇಷಾಂ ಬನ್ಧನಾನಿ ಚ ಮುಕ್ತಾನಿ| ");
INSERT INTO sankan_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","ಅತಏವ ಕಾರಾರಕ್ಷಕೋ ನಿದ್ರಾತೋ ಜಾಗರಿತ್ವಾ ಕಾರಾಯಾ ದ್ವಾರಾಣಿ ಮುಕ್ತಾನಿ ದೃಷ್ಟ್ವಾ ಬನ್ದಿಲೋಕಾಃ ಪಲಾಯಿತಾ ಇತ್ಯನುಮಾಯ ಕೋಷಾತ್ ಖಙ್ಗಂ ಬಹಿಃ ಕೃತ್ವಾತ್ಮಘಾತಂ ಕರ್ತ್ತುಮ್ ಉದ್ಯತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","ಕಿನ್ತು ಪೌಲಃ ಪ್ರೋಚ್ಚೈಸ್ತಮಾಹೂಯ ಕಥಿತವಾನ್ ಪಶ್ಯ ವಯಂ ಸರ್ವ್ವೇಽತ್ರಾಸ್ಮಹೇ, ತ್ವಂ ನಿಜಪ್ರಾಣಹಿಂಸಾಂ ಮಾಕಾರ್ಷೀಃ| ");
INSERT INTO sankan_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","ತದಾ ಪ್ರದೀಪಮ್ ಆನೇತುಮ್ ಉಕ್ತ್ವಾ ಸ ಕಮ್ಪಮಾನಃ ಸನ್ ಉಲ್ಲಮ್ಪ್ಯಾಭ್ಯನ್ತರಮ್ ಆಗತ್ಯ ಪೌಲಸೀಲಯೋಃ ಪಾದೇಷು ಪತಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ಪಶ್ಚಾತ್ ಸ ತೌ ಬಹಿರಾನೀಯ ಪೃಷ್ಟವಾನ್ ಹೇ ಮಹೇಚ್ಛೌ ಪರಿತ್ರಾಣಂ ಪ್ರಾಪ್ತುಂ ಮಯಾ ಕಿಂ ಕರ್ತ್ತವ್ಯಂ? ");
INSERT INTO sankan_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","ಪಶ್ಚಾತ್ ತೌ ಸ್ವಗೃಹಮಾನೀಯ ತಯೋಃ ಸಮ್ಮುಖೇ ಖಾದ್ಯದ್ರವ್ಯಾಣಿ ಸ್ಥಾಪಿತವಾನ್ ತಥಾ ಸ ಸ್ವಯಂ ತದೀಯಾಃ ಸರ್ವ್ವೇ ಪರಿವಾರಾಶ್ಚೇಶ್ವರೇ ವಿಶ್ವಸನ್ತಃ ಸಾನನ್ದಿತಾ ಅಭವನ್| ");
INSERT INTO sankan_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ತಸ್ಮೈ ತಸ್ಯ ಗೃಹಸ್ಥಿತಸರ್ವ್ವಲೋಕೇಭ್ಯಶ್ಚ ಪ್ರಭೋಃ ಕಥಾಂ ಕಥಿತವನ್ತೌ| ");
INSERT INTO sankan_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","ತಥಾ ರಾತ್ರೇಸ್ತಸ್ಮಿನ್ನೇವ ದಣ್ಡೇ ಸ ತೌ ಗೃಹೀತ್ವಾ ತಯೋಃ ಪ್ರಹಾರಾಣಾಂ ಕ್ಷತಾನಿ ಪ್ರಕ್ಷಾಲಿತವಾನ್ ತತಃ ಸ ಸ್ವಯಂ ತಸ್ಯ ಸರ್ವ್ವೇ ಪರಿಜನಾಶ್ಚ ಮಜ್ಜಿತಾ ಅಭವನ್| ");
INSERT INTO sankan_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","ಪಶ್ಚಾತ್ ತೌ ಸ್ವಗೃಹಮಾನೀಯ ತಯೋಃ ಸಮ್ಮುಖೇ ಖಾದ್ಯದ್ರವ್ಯಾಣಿ ಸ್ಥಾಪಿತವಾನ್ ತಥಾ ಸ ಸ್ವಯಂ ತದೀಯಾಃ ಸರ್ವ್ವೇ ಪರಿವಾರಾಶ್ಚೇಶ್ವರೇ ವಿಶ್ವಸನ್ತಃ ಸಾನನ್ದಿತಾ ಅಭವನ್| ");
INSERT INTO sankan_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","ದಿನ ಉಪಸ್ಥಿತೇ ತೌ ಲೋಕೌ ಮೋಚಯೇತಿ ಕಥಾಂ ಕಥಯಿತುಂ ಶಾಸಕಾಃ ಪದಾತಿಗಣಂ ಪ್ರೇಷಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","ತತಃ ಕಾರಾರಕ್ಷಕಃ ಪೌಲಾಯ ತಾಂ ವಾರ್ತ್ತಾಂ ಕಥಿತವಾನ್ ಯುವಾಂ ತ್ಯಾಜಯಿತುಂ ಶಾಸಕಾ ಲೋಕಾನ ಪ್ರೇಷಿತವನ್ತ ಇದಾನೀಂ ಯುವಾಂ ಬಹಿ ರ್ಭೂತ್ವಾ ಕುಶಲೇನ ಪ್ರತಿಷ್ಠೇತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","ಕಿನ್ತು ಪೌಲಸ್ತಾನ್ ಅವದತ್ ರೋಮಿಲೋಕಯೋರಾವಯೋಃ ಕಮಪಿ ದೋಷಮ್ ನ ನಿಶ್ಚಿತ್ಯ ಸರ್ವ್ವೇಷಾಂ ಸಮಕ್ಷಮ್ ಆವಾಂ ಕಶಯಾ ತಾಡಯಿತ್ವಾ ಕಾರಾಯಾಂ ಬದ್ಧವನ್ತ ಇದಾನೀಂ ಕಿಮಾವಾಂ ಗುಪ್ತಂ ವಿಸ್ತ್ರಕ್ಷ್ಯನ್ತಿ? ತನ್ನ ಭವಿಷ್ಯತಿ, ಸ್ವಯಮಾಗತ್ಯಾವಾಂ ಬಹಿಃ ಕೃತ್ವಾ ನಯನ್ತು| ");
INSERT INTO sankan_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","ತದಾ ಪದಾತಿಭಿಃ ಶಾಸಕೇಭ್ಯ ಏತದ್ವಾರ್ತ್ತಾಯಾಂ ಕಥಿತಾಯಾಂ ತೌ ರೋಮಿಲೋಕಾವಿತಿ ಕಥಾಂ ಶ್ರುತ್ವಾ ತೇ ಭೀತಾಃ ");
INSERT INTO sankan_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","ಸನ್ತಸ್ತಯೋಃ ಸನ್ನಿಧಿಮಾಗತ್ಯ ವಿನಯಮ್ ಅಕುರ್ವ್ವನ್ ಅಪರಂ ಬಹಿಃ ಕೃತ್ವಾ ನಗರಾತ್ ಪ್ರಸ್ಥಾತುಂ ಪ್ರಾರ್ಥಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ತತಸ್ತೌ ಕಾರಾಯಾ ನಿರ್ಗತ್ಯ ಲುದಿಯಾಯಾ ಗೃಹಂ ಗತವನ್ತೌ ತತ್ರ ಭ್ರಾತೃಗಣಂ ಸಾಕ್ಷಾತ್ಕೃತ್ಯ ತಾನ್ ಸಾನ್ತ್ವಯಿತ್ವಾ ತಸ್ಮಾತ್ ಸ್ಥಾನಾತ್ ಪ್ರಸ್ಥಿತೌ| ");
INSERT INTO sankan_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","ಪೌಲಸೀಲೌ ಆಮ್ಫಿಪಲ್ಯಾಪಲ್ಲೋನಿಯಾನಗರಾಭ್ಯಾಂ ಗತ್ವಾ ಯತ್ರ ಯಿಹೂದೀಯಾನಾಂ ಭಜನಭವನಮೇಕಮ್ ಆಸ್ತೇ ತತ್ರ ಥಿಷಲನೀಕೀನಗರ ಉಪಸ್ಥಿತೌ| ");
INSERT INTO sankan_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","ತದಾ ಪೌಲಃ ಸ್ವಾಚಾರಾನುಸಾರೇಣ ತೇಷಾಂ ಸಮೀಪಂ ಗತ್ವಾ ವಿಶ್ರಾಮವಾರತ್ರಯೇ ತೈಃ ಸಾರ್ದ್ಧಂ ಧರ್ಮ್ಮಪುಸ್ತಕೀಯಕಥಾಯಾ ವಿಚಾರಂ ಕೃತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ಫಲತಃ ಖ್ರೀಷ್ಟೇನ ದುಃಖಭೋಗಃ ಕರ್ತ್ತವ್ಯಃ ಶ್ಮಶಾನದುತ್ಥಾನಞ್ಚ ಕರ್ತ್ತವ್ಯಂ ಯುಷ್ಮಾಕಂ ಸನ್ನಿಧೌ ಯಸ್ಯ ಯೀಶೋಃ ಪ್ರಸ್ತಾವಂ ಕರೋಮಿ ಸ ಈಶ್ವರೇಣಾಭಿಷಿಕ್ತಃ ಸ ಏತಾಃ ಕಥಾಃ ಪ್ರಕಾಶ್ಯ ಪ್ರಮಾಣಂ ದತ್ವಾ ಸ್ಥಿರೀಕೃತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","ತಸ್ಮಾತ್ ತೇಷಾಂ ಕತಿಪಯಜನಾ ಅನ್ಯದೇಶೀಯಾ ಬಹವೋ ಭಕ್ತಲೋಕಾ ಬಹ್ಯಃ ಪ್ರಧಾನನಾರ್ಯ್ಯಶ್ಚ ವಿಶ್ವಸ್ಯ ಪೌಲಸೀಲಯೋಃ ಪಶ್ಚಾದ್ಗಾಮಿನೋ ಜಾತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","ಕಿನ್ತು ವಿಶ್ವಾಸಹೀನಾ ಯಿಹೂದೀಯಲೋಕಾ ಈರ್ಷ್ಯಯಾ ಪರಿಪೂರ್ಣಾಃ ಸನ್ತೋ ಹಟಟ್ಸ್ಯ ಕತಿನಯಲಮ್ಪಟಲೋಕಾನ್ ಸಙ್ಗಿನಃ ಕೃತ್ವಾ ಜನತಯಾ ನಗರಮಧ್ಯೇ ಮಹಾಕಲಹಂ ಕೃತ್ವಾ ಯಾಸೋನೋ ಗೃಹಮ್ ಆಕ್ರಮ್ಯ ಪ್ರೇರಿತಾನ್ ಧೃತ್ವಾ ಲೋಕನಿವಹಸ್ಯ ಸಮೀಪಮ್ ಆನೇತುಂ ಚೇಷ್ಟಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","ತೇಷಾಮುದ್ದೇಶಮ್ ಅಪ್ರಾಪ್ಯ ಚ ಯಾಸೋನಂ ಕತಿಪಯಾನ್ ಭ್ರಾತೃಂಶ್ಚ ಧೃತ್ವಾ ನಗರಾಧಿಪತೀನಾಂ ನಿಕಟಮಾನೀಯ ಪ್ರೋಚ್ಚೈಃ ಕಥಿತವನ್ತೋ ಯೇ ಮನುಷ್ಯಾ ಜಗದುದ್ವಾಟಿತವನ್ತಸ್ತೇ ಽತ್ರಾಪ್ಯುಪಸ್ಥಿತಾಃ ಸನ್ತಿ, ");
INSERT INTO sankan_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ಏಷ ಯಾಸೋನ್ ಆತಿಥ್ಯಂ ಕೃತ್ವಾ ತಾನ್ ಗೃಹೀತವಾನ್| ಯೀಶುನಾಮಕ ಏಕೋ ರಾಜಸ್ತೀತಿ ಕಥಯನ್ತಸ್ತೇ ಕೈಸರಸ್ಯಾಜ್ಞಾವಿರುದ್ಧಂ ಕರ್ಮ್ಮ ಕುರ್ವ್ವತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","ತೇಷಾಂ ಕಥಾಮಿಮಾಂ ಶ್ರುತ್ವಾ ಲೋಕನಿವಹೋ ನಗರಾಧಿಪತಯಶ್ಚ ಸಮುದ್ವಿಗ್ನಾ ಅಭವನ್| ");
INSERT INTO sankan_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ತದಾ ಯಾಸೋನಸ್ತದನ್ಯೇಷಾಞ್ಚ ಧನದಣ್ಡಂ ಗೃಹೀತ್ವಾ ತಾನ್ ಪರಿತ್ಯಕ್ತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","ತತಃ ಪರಂ ಭ್ರಾತೃಗಣೋ ರಜನ್ಯಾಂ ಪೌಲಸೀಲೌ ಶೀಘ್ರಂ ಬಿರಯಾನಗರಂ ಪ್ರೇಷಿತವಾನ್ ತೌ ತತ್ರೋಪಸ್ಥಾಯ ಯಿಹೂದೀಯಾನಾಂ ಭಜನಭವನಂ ಗತವನ್ತೌ| ");
INSERT INTO sankan_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","ತತ್ರಸ್ಥಾ ಲೋಕಾಃ ಥಿಷಲನೀಕೀಸ್ಥಲೋಕೇಭ್ಯೋ ಮಹಾತ್ಮಾನ ಆಸನ್ ಯತ ಇತ್ಥಂ ಭವತಿ ನ ವೇತಿ ಜ್ಞಾತುಂ ದಿನೇ ದಿನೇ ಧರ್ಮ್ಮಗ್ರನ್ಥಸ್ಯಾಲೋಚನಾಂ ಕೃತ್ವಾ ಸ್ವೈರಂ ಕಥಾಮ್ ಅಗೃಹ್ಲನ್| ");
INSERT INTO sankan_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ತಸ್ಮಾದ್ ಅನೇಕೇ ಯಿಹೂದೀಯಾ ಅನ್ಯದೇಶೀಯಾನಾಂ ಮಾನ್ಯಾ ಸ್ತ್ರಿಯಃ ಪುರುಷಾಶ್ಚಾನೇಕೇ ವ್ಯಶ್ವಸನ್| ");
INSERT INTO sankan_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","ಕಿನ್ತು ಬಿರಯಾನಗರೇ ಪೌಲೇನೇಶ್ವರೀಯಾ ಕಥಾ ಪ್ರಚಾರ್ಯ್ಯತ ಇತಿ ಥಿಷಲನೀಕೀಸ್ಥಾ ಯಿಹೂದೀಯಾ ಜ್ಞಾತ್ವಾ ತತ್ಸ್ಥಾನಮಪ್ಯಾಗತ್ಯ ಲೋಕಾನಾಂ ಕುಪ್ರವೃತ್ತಿಮ್ ಅಜನಯನ್| ");
INSERT INTO sankan_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","ಅತಏವ ತಸ್ಮಾತ್ ಸ್ಥಾನಾತ್ ಸಮುದ್ರೇಣ ಯಾನ್ತೀತಿ ದರ್ಶಯಿತ್ವಾ ಭ್ರಾತರಃ ಕ್ಷಿಪ್ರಂ ಪೌಲಂ ಪ್ರಾಹಿಣ್ವನ್ ಕಿನ್ತು ಸೀಲತೀಮಥಿಯೌ ತತ್ರ ಸ್ಥಿತವನ್ತೌ| ");
INSERT INTO sankan_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","ತತಃ ಪರಂ ಪೌಲಸ್ಯ ಮಾರ್ಗದರ್ಶಕಾಸ್ತಮ್ ಆಥೀನೀನಗರ ಉಪಸ್ಥಾಪಯನ್ ಪಶ್ಚಾದ್ ಯುವಾಂ ತೂರ್ಣಮ್ ಏತತ್ ಸ್ಥಾನಂ ಆಗಮಿಷ್ಯಥಃ ಸೀಲತೀಮಥಿಯೌ ಪ್ರತೀಮಾಮ್ ಆಜ್ಞಾಂ ಪ್ರಾಪ್ಯ ತೇ ಪ್ರತ್ಯಾಗತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","ಪೌಲ ಆಥೀನೀನಗರೇ ತಾವಪೇಕ್ಷ್ಯ ತಿಷ್ಠನ್ ತನ್ನಗರಂ ಪ್ರತಿಮಾಭಿಃ ಪರಿಪೂರ್ಣಂ ದೃಷ್ಟ್ವಾ ಸನ್ತಪ್ತಹೃದಯೋ ಽಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","ತತಃ ಸ ಭಜನಭವನೇ ಯಾನ್ ಯಿಹೂದೀಯಾನ್ ಭಕ್ತಲೋಕಾಂಶ್ಚ ಹಟ್ಟೇ ಚ ಯಾನ್ ಅಪಶ್ಯತ್ ತೈಃ ಸಹ ಪ್ರತಿದಿನಂ ವಿಚಾರಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","ಕಿನ್ತ್ವಿಪಿಕೂರೀಯಮತಗ್ರಹಿಣಃ ಸ್ತೋಯಿಕೀಯಮತಗ್ರಾಹಿಣಶ್ಚ ಕಿಯನ್ತೋ ಜನಾಸ್ತೇನ ಸಾರ್ದ್ಧಂ ವ್ಯವದನ್ತ| ತತ್ರ ಕೇಚಿದ್ ಅಕಥಯನ್ ಏಷ ವಾಚಾಲಃ ಕಿಂ ವಕ್ತುಮ್ ಇಚ್ಛತಿ? ಅಪರೇ ಕೇಚಿದ್ ಏಷ ಜನಃ ಕೇಷಾಞ್ಚಿದ್ ವಿದೇಶೀಯದೇವಾನಾಂ ಪ್ರಚಾರಕ ಇತ್ಯನುಮೀಯತೇ ಯತಃ ಸ ಯೀಶುಮ್ ಉತ್ಥಿತಿಞ್ಚ ಪ್ರಚಾರಯತ್| ");
INSERT INTO sankan_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","ತೇ ತಮ್ ಅರೇಯಪಾಗನಾಮ ವಿಚಾರಸ್ಥಾನಮ್ ಆನೀಯ ಪ್ರಾವೋಚನ್ ಇದಂ ಯನ್ನವೀನಂ ಮತಂ ತ್ವಂ ಪ್ರಾಚೀಕಶ ಇದಂ ಕೀದೃಶಂ ಏತದ್ ಅಸ್ಮಾನ್ ಶ್ರಾವಯ; ");
INSERT INTO sankan_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","ಯಾಮಿಮಾಮ್ ಅಸಮ್ಭವಕಥಾಮ್ ಅಸ್ಮಾಕಂ ಕರ್ಣಗೋಚರೀಕೃತವಾನ್ ಅಸ್ಯಾ ಭಾವಾರ್ಥಃ ಕ ಇತಿ ವಯಂ ಜ್ಞಾತುಮ್ ಇಚ್ಛಾಮಃ| ");
INSERT INTO sankan_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","ತದಾಥೀನೀನಿವಾಸಿನಸ್ತನ್ನಗರಪ್ರವಾಸಿನಶ್ಚ ಕೇವಲಂ ಕಸ್ಯಾಶ್ಚನ ನವೀನಕಥಾಯಾಃ ಶ್ರವಣೇನ ಪ್ರಚಾರಣೇನ ಚ ಕಾಲಮ್ ಅಯಾಪಯನ್| ");
INSERT INTO sankan_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","ಪೌಲೋಽರೇಯಪಾಗಸ್ಯ ಮಧ್ಯೇ ತಿಷ್ಠನ್ ಏತಾಂ ಕಥಾಂ ಪ್ರಚಾರಿತವಾನ್, ಹೇ ಆಥೀನೀಯಲೋಕಾ ಯೂಯಂ ಸರ್ವ್ವಥಾ ದೇವಪೂಜಾಯಾಮ್ ಆಸಕ್ತಾ ಇತ್ಯಹ ಪ್ರತ್ಯಕ್ಷಂ ಪಶ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","ಯತಃ ಪರ್ಯ್ಯಟನಕಾಲೇ ಯುಷ್ಮಾಕಂ ಪೂಜನೀಯಾನಿ ಪಶ್ಯನ್ ‘ಅವಿಜ್ಞಾತೇಶ್ವರಾಯ’ ಏತಲ್ಲಿಪಿಯುಕ್ತಾಂ ಯಜ್ಞವೇದೀಮೇಕಾಂ ದೃಷ್ಟವಾನ್; ಅತೋ ನ ವಿದಿತ್ವಾ ಯಂ ಪೂಜಯಧ್ವೇ ತಸ್ಯೈವ ತತ್ವಂ ಯುಷ್ಮಾನ್ ಪ್ರತಿ ಪ್ರಚಾರಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ಜಗತೋ ಜಗತ್ಸ್ಥಾನಾಂ ಸರ್ವ್ವವಸ್ತೂನಾಞ್ಚ ಸ್ರಷ್ಟಾ ಯ ಈಶ್ವರಃ ಸ ಸ್ವರ್ಗಪೃಥಿವ್ಯೋರೇಕಾಧಿಪತಿಃ ಸನ್ ಕರನಿರ್ಮ್ಮಿತಮನ್ದಿರೇಷು ನ ನಿವಸತಿ; ");
INSERT INTO sankan_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ಸ ಏವ ಸರ್ವ್ವೇಭ್ಯೋ ಜೀವನಂ ಪ್ರಾಣಾನ್ ಸರ್ವ್ವಸಾಮಗ್ರೀಶ್ಚ ಪ್ರದದಾತಿ; ಅತಏವ ಸ ಕಸ್ಯಾಶ್ಚಿತ್ ಸಾಮಗ್ಯ್ರಾ ಅಭಾವಹೇತೋ ರ್ಮನುಷ್ಯಾಣಾಂ ಹಸ್ತೈಃ ಸೇವಿತೋ ಭವತೀತಿ ನ| ");
INSERT INTO sankan_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ಸ ಭೂಮಣ್ಡಲೇ ನಿವಾಸಾರ್ಥಮ್ ಏಕಸ್ಮಾತ್ ಶೋಣಿತಾತ್ ಸರ್ವ್ವಾನ್ ಮನುಷ್ಯಾನ್ ಸೃಷ್ಟ್ವಾ ತೇಷಾಂ ಪೂರ್ವ್ವನಿರೂಪಿತಸಮಯಂ ವಸತಿಸೀಮಾಞ್ಚ ನಿರಚಿನೋತ್; ");
INSERT INTO sankan_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ತಸ್ಮಾತ್ ಲೋಕೈಃ ಕೇನಾಪಿ ಪ್ರಕಾರೇಣ ಮೃಗಯಿತ್ವಾ ಪರಮೇಶ್ವರಸ್ಯ ತತ್ವಂ ಪ್ರಾಪ್ತುಂ ತಸ್ಯ ಗವೇಷಣಂ ಕರಣೀಯಮ್| ");
INSERT INTO sankan_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","ಕಿನ್ತು ಸೋಽಸ್ಮಾಕಂ ಕಸ್ಮಾಚ್ಚಿದಪಿ ದೂರೇ ತಿಷ್ಠತೀತಿ ನಹಿ, ವಯಂ ತೇನ ನಿಶ್ವಸನಪ್ರಶ್ವಸನಗಮನಾಗಮನಪ್ರಾಣಧಾರಣಾನಿ ಕುರ್ಮ್ಮಃ, ಪುुನಶ್ಚ ಯುಷ್ಮಾಕಮೇವ ಕತಿಪಯಾಃ ಕವಯಃ ಕಥಯನ್ತಿ ‘ತಸ್ಯ ವಂಶಾ ವಯಂ ಸ್ಮೋ ಹಿ’ ಇತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","ಅತಏವ ಯದಿ ವಯಮ್ ಈಶ್ವರಸ್ಯ ವಂಶಾ ಭವಾಮಸ್ತರ್ಹಿ ಮನುಷ್ಯೈ ರ್ವಿದ್ಯಯಾ ಕೌಶಲೇನ ಚ ತಕ್ಷಿತಂ ಸ್ವರ್ಣಂ ರೂಪ್ಯಂ ದೃಷದ್ ವೈತೇಷಾಮೀಶ್ವರತ್ವಮ್ ಅಸ್ಮಾಭಿ ರ್ನ ಜ್ಞಾತವ್ಯಂ| ");
INSERT INTO sankan_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","ತೇಷಾಂ ಪೂರ್ವ್ವೀಯಲೋಕಾನಾಮ್ ಅಜ್ಞಾನತಾಂ ಪ್ರತೀಶ್ವರೋ ಯದ್ಯಪಿ ನಾವಾಧತ್ತ ತಥಾಪೀದಾನೀಂ ಸರ್ವ್ವತ್ರ ಸರ್ವ್ವಾನ್ ಮನಃ ಪರಿವರ್ತ್ತಯಿತುಮ್ ಆಜ್ಞಾಪಯತಿ, ");
INSERT INTO sankan_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","ಯತಃ ಸ್ವನಿಯುಕ್ತೇನ ಪುರುಷೇಣ ಯದಾ ಸ ಪೃಥಿವೀಸ್ಥಾನಾಂ ಸರ್ವ್ವಲೋಕಾನಾಂ ವಿಚಾರಂ ಕರಿಷ್ಯತಿ ತದ್ದಿನಂ ನ್ಯರೂಪಯತ್; ತಸ್ಯ ಶ್ಮಶಾನೋತ್ಥಾಪನೇನ ತಸ್ಮಿನ್ ಸರ್ವ್ವೇಭ್ಯಃ ಪ್ರಮಾಣಂ ಪ್ರಾದಾತ್| ");
INSERT INTO sankan_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","ತದಾ ಶ್ಮಶಾನಾದ್ ಉತ್ಥಾನಸ್ಯ ಕಥಾಂ ಶ್ರುತ್ವಾ ಕೇಚಿದ್ ಉಪಾಹಮನ್, ಕೇಚಿದವದನ್ ಏನಾಂ ಕಥಾಂ ಪುನರಪಿ ತ್ವತ್ತಃ ಶ್ರೋಷ್ಯಾಮಃ| ");
INSERT INTO sankan_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","ತತಃ ಪೌಲಸ್ತೇಷಾಂ ಸಮೀಪಾತ್ ಪ್ರಸ್ಥಿाತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","ತಥಾಪಿ ಕೇಚಿಲ್ಲೋಕಾಸ್ತೇನ ಸಾರ್ದ್ಧಂ ಮಿಲಿತ್ವಾ ವ್ಯಶ್ವಸನ್ ತೇಷಾಂ ಮಧ್ಯೇ ಽರೇಯಪಾಗೀಯದಿಯನುಸಿಯೋ ದಾಮಾರೀನಾಮಾ ಕಾಚಿನ್ನಾರೀ ಕಿಯನ್ತೋ ನರಾಶ್ಚಾಸನ್| ");
INSERT INTO sankan_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","ತದ್ಘಟನಾತಃ ಪರಂ ಪೌಲ ಆಥೀನೀನಗರಾದ್ ಯಾತ್ರಾಂ ಕೃತ್ವಾ ಕರಿನ್ಥನಗರಮ್ ಆಗಚ್ಛತ್| ");
INSERT INTO sankan_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","ತಸ್ಮಿನ್ ಸಮಯೇ ಕ್ಲೌದಿಯಃ ಸರ್ವ್ವಾನ್ ಯಿಹೂದೀಯಾನ್ ರೋಮಾನಗರಂ ವಿಹಾಯ ಗನ್ತುಮ್ ಆಜ್ಞಾಪಯತ್, ತಸ್ಮಾತ್ ಪ್ರಿಸ್ಕಿಲ್ಲಾನಾಮ್ನಾ ಜಾಯಯಾ ಸಾರ್ದ್ಧಮ್ ಇತಾಲಿಯಾದೇಶಾತ್ ಕಿಞ್ಚಿತ್ಪೂರ್ವ್ವಮ್ ಆಗಮತ್ ಯಃ ಪನ್ತದೇಶೇ ಜಾತ ಆಕ್ಕಿಲನಾಮಾ ಯಿಹೂದೀಯಲೋಕಃ ಪೌಲಸ್ತಂ ಸಾಕ್ಷಾತ್ ಪ್ರಾಪ್ಯ ತಯೋಃ ಸಮೀಪಮಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ತೌ ದೂಷ್ಯನಿರ್ಮ್ಮಾಣಜೀವಿನೌ, ತಸ್ಮಾತ್ ಪರಸ್ಪರಮ್ ಏಕವೃತ್ತಿಕತ್ವಾತ್ ಸ ತಾಭ್ಯಾಂ ಸಹ ಉಷಿತ್ವಾ ತತ್ ಕರ್ಮ್ಮಾಕರೋತ್| ");
INSERT INTO sankan_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","ಪೌಲಃ ಪ್ರತಿವಿಶ್ರಾಮವಾರಂ ಭಜನಭವನಂ ಗತ್ವಾ ವಿಚಾರಂ ಕೃತ್ವಾ ಯಿಹೂದೀಯಾನ್ ಅನ್ಯದೇಶೀಯಾಂಶ್ಚ ಪ್ರವೃತ್ತಿಂ ಗ್ರಾಹಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","ಸೀಲತೀಮಥಿಯಯೋ ರ್ಮಾಕಿದನಿಯಾದೇಶಾತ್ ಸಮೇತಯೋಃ ಸತೋಃ ಪೌಲ ಉತ್ತಪ್ತಮನಾ ಭೂತ್ವಾ ಯೀಶುರೀಶ್ವರೇಣಾಭಿಷಿಕ್ತೋ ಭವತೀತಿ ಪ್ರಮಾಣಂ ಯಿಹೂದೀಯಾನಾಂ ಸಮೀಪೇ ಪ್ರಾದಾತ್| ");
INSERT INTO sankan_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","ಕಿನ್ತು ತೇ ಽತೀವ ವಿರೋಧಂ ವಿಧಾಯ ಪಾಷಣ್ಡೀಯಕಥಾಂ ಕಥಿತವನ್ತಸ್ತತಃ ಪೌಲೋ ವಸ್ತ್ರಂ ಧುನ್ವನ್ ಏತಾಂ ಕಥಾಂ ಕಥಿತವಾನ್, ಯುಷ್ಮಾಕಂ ಶೋಣಿತಪಾತಾಪರಾಧೋ ಯುಷ್ಮಾನ್ ಪ್ರತ್ಯೇವ ಭವತು, ತೇನಾಹಂ ನಿರಪರಾಧೋ ಽದ್ಯಾರಭ್ಯ ಭಿನ್ನದೇಶೀಯಾನಾಂ ಸಮೀಪಂ ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","ಸ ತಸ್ಮಾತ್ ಪ್ರಸ್ಥಾಯ ಭಜನಭವನಸಮೀಪಸ್ಥಸ್ಯ ಯುಸ್ತನಾಮ್ನ ಈಶ್ವರಭಕ್ತಸ್ಯ ಭಿನ್ನದೇಶೀಯಸ್ಯ ನಿವೇಶನಂ ಪ್ರಾವಿಶತ್| ");
INSERT INTO sankan_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","ತತಃ ಕ್ರೀಷ್ಪನಾಮಾ ಭಜನಭವನಾಧಿಪತಿಃ ಸಪರಿವಾರಃ ಪ್ರಭೌ ವ್ಯಶ್ವಸೀತ್, ಕರಿನ್ಥನಗರೀಯಾ ಬಹವೋ ಲೋಕಾಶ್ಚ ಸಮಾಕರ್ಣ್ಯ ವಿಶ್ವಸ್ಯ ಮಜ್ಜಿತಾ ಅಭವನ್| ");
INSERT INTO sankan_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","ಕ್ಷಣದಾಯಾಂ ಪ್ರಭುಃ ಪೌಲಂ ದರ್ಶನಂ ದತ್ವಾ ಭಾಷಿತವಾನ್, ಮಾ ಭೈಷೀಃ, ಮಾ ನಿರಸೀಃ ಕಥಾಂ ಪ್ರಚಾರಯ| ");
INSERT INTO sankan_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ಅಹಂ ತ್ವಯಾ ಸಾರ್ದ್ಧಮ್ ಆಸ ಹಿಂಸಾರ್ಥಂ ಕೋಪಿ ತ್ವಾಂ ಸ್ಪ್ರಷ್ಟುಂ ನ ಶಕ್ಷ್ಯತಿ ನಗರೇಽಸ್ಮಿನ್ ಮದೀಯಾ ಲೋಕಾ ಬಹವ ಆಸತೇ| ");
INSERT INTO sankan_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","ತಸ್ಮಾತ್ ಪೌಲಸ್ತನ್ನಗರೇ ಪ್ರಾಯೇಣ ಸಾರ್ದ್ಧವತ್ಸರಪರ್ಯ್ಯನ್ತಂ ಸಂಸ್ಥಾಯೇಶ್ವರಸ್ಯ ಕಥಾಮ್ ಉಪಾದಿಶತ್| ");
INSERT INTO sankan_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","ಗಾಲ್ಲಿಯನಾಮಾ ಕಶ್ಚಿದ್ ಆಖಾಯಾದೇಶಸ್ಯ ಪ್ರಾಡ್ವಿವಾಕಃ ಸಮಭವತ್, ತತೋ ಯಿಹೂದೀಯಾ ಏಕವಾಕ್ಯಾಃ ಸನ್ತಃ ಪೌಲಮ್ ಆಕ್ರಮ್ಯ ವಿಚಾರಸ್ಥಾನಂ ನೀತ್ವಾ ");
INSERT INTO sankan_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","ಮಾನುಷ ಏಷ ವ್ಯವಸ್ಥಾಯ ವಿರುದ್ಧಮ್ ಈಶ್ವರಭಜನಂ ಕರ್ತ್ತುಂ ಲೋಕಾನ್ ಕುಪ್ರವೃತ್ತಿಂ ಗ್ರಾಹಯತೀತಿ ನಿವೇದಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","ತತಃ ಪೌಲೇ ಪ್ರತ್ಯುತ್ತರಂ ದಾತುಮ್ ಉದ್ಯತೇ ಸತಿ ಗಾಲ್ಲಿಯಾ ಯಿಹೂದೀಯಾನ್ ವ್ಯಾಹರತ್, ಯದಿ ಕಸ್ಯಚಿದ್ ಅನ್ಯಾಯಸ್ಯ ವಾತಿಶಯದುಷ್ಟತಾಚರಣಸ್ಯ ವಿಚಾರೋಽಭವಿಷ್ಯತ್ ತರ್ಹಿ ಯುಷ್ಮಾಕಂ ಕಥಾ ಮಯಾ ಸಹನೀಯಾಭವಿಷ್ಯತ್| ");
INSERT INTO sankan_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","ಕಿನ್ತು ಯದಿ ಕೇವಲಂ ಕಥಾಯಾ ವಾ ನಾಮ್ನೋ ವಾ ಯುಷ್ಮಾಕಂ ವ್ಯವಸ್ಥಾಯಾ ವಿವಾದೋ ಭವತಿ ತರ್ಹಿ ತಸ್ಯ ವಿಚಾರಮಹಂ ನ ಕರಿಷ್ಯಾಮಿ, ಯೂಯಂ ತಸ್ಯ ಮೀಮಾಂಸಾಂ ಕುರುತ| ");
INSERT INTO sankan_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","ತತಃ ಸ ತಾನ್ ವಿಚಾರಸ್ಥಾನಾದ್ ದೂರೀಕೃತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","ತದಾ ಭಿನ್ನದೇಶೀಯಾಃ ಸೋಸ್ಥಿನಿನಾಮಾನಂ ಭಜನಭವನಸ್ಯ ಪ್ರಧಾನಾಧಿಪತಿಂ ಧೃತ್ವಾ ವಿಚಾರಸ್ಥಾನಸ್ಯ ಸಮ್ಮುಖೇ ಪ್ರಾಹರನ್ ತಥಾಪಿ ಗಾಲ್ಲಿಯಾ ತೇಷು ಸರ್ವ್ವಕರ್ಮ್ಮಸು ನ ಮನೋ ನ್ಯದಧಾತ್| ");
INSERT INTO sankan_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","ಪೌಲಸ್ತತ್ರ ಪುನರ್ಬಹುದಿನಾನಿ ನ್ಯವಸತ್, ತತೋ ಭ್ರಾತೃಗಣಾದ್ ವಿಸರ್ಜನಂ ಪ್ರಾಪ್ಯ ಕಿಞ್ಚನವ್ರತನಿಮಿತ್ತಂ ಕಿಂಕ್ರಿಯಾನಗರೇ ಶಿರೋ ಮುಣ್ಡಯಿತ್ವಾ ಪ್ರಿಸ್ಕಿಲ್ಲಾಕ್ಕಿಲಾಭ್ಯಾಂ ಸಹಿತೋ ಜಲಪಥೇನ ಸುರಿಯಾದೇಶಂ ಗತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","ತತ ಇಫಿಷನಗರ ಉಪಸ್ಥಾಯ ತತ್ರ ತೌ ವಿಸೃಜ್ಯ ಸ್ವಯಂ ಭಜನಭ್ವನಂ ಪ್ರವಿಶ್ಯ ಯಿಹೂದೀಯೈಃ ಸಹ ವಿಚಾರಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","ತೇ ಸ್ವೈಃ ಸಾರ್ದ್ಧಂ ಪುನಃ ಕತಿಪಯದಿನಾನಿ ಸ್ಥಾತುಂ ತಂ ವ್ಯನಯನ್, ಸ ತದನುರರೀಕೃತ್ಯ ಕಥಾಮೇತಾಂ ಕಥಿತವಾನ್, ");
INSERT INTO sankan_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ಯಿರೂಶಾಲಮಿ ಆಗಾಮ್ಯುತ್ಸವಪಾಲನಾರ್ಥಂ ಮಯಾ ಗಮನೀಯಂ; ಪಶ್ಚಾದ್ ಈಶ್ವರೇಚ್ಛಾಯಾಂ ಜಾತಾಯಾಂ ಯುಷ್ಮಾಕಂ ಸಮೀಪಂ ಪ್ರತ್ಯಾಗಮಿಷ್ಯಾಮಿ| ತತಃ ಪರಂ ಸ ತೈ ರ್ವಿಸೃಷ್ಟಃ ಸನ್ ಜಲಪಥೇನ ಇಫಿಷನಗರಾತ್ ಪ್ರಸ್ಥಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","ತತಃ ಕೈಸರಿಯಾಮ್ ಉಪಸ್ಥಿತಃ ಸನ್ ನಗರಂ ಗತ್ವಾ ಸಮಾಜಂ ನಮಸ್ಕೃತ್ಯ ತಸ್ಮಾದ್ ಆನ್ತಿಯಖಿಯಾನಗರಂ ಪ್ರಸ್ಥಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","ತತ್ರ ಕಿಯತ್ಕಾಲಂ ಯಾಪಯಿತ್ವಾ ತಸ್ಮಾತ್ ಪ್ರಸ್ಥಾಯ ಸರ್ವ್ವೇಷಾಂ ಶಿಷ್ಯಾಣಾಂ ಮನಾಂಸಿ ಸುಸ್ಥಿರಾಣಿ ಕೃತ್ವಾ ಕ್ರಮಶೋ ಗಲಾತಿಯಾಫ್ರುಗಿಯಾದೇಶಯೋ ರ್ಭ್ರಮಿತ್ವಾ ಗತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","ತಸ್ಮಿನ್ನೇವ ಸಮಯೇ ಸಿಕನ್ದರಿಯಾನಗರೇ ಜಾತ ಆಪಲ್ಲೋನಾಮಾ ಶಾಸ್ತ್ರವಿತ್ ಸುವಕ್ತಾ ಯಿಹೂದೀಯ ಏಕೋ ಜನ ಇಫಿಷನಗರಮ್ ಆಗತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","ಸ ಶಿಕ್ಷಿತಪ್ರಭುಮಾರ್ಗೋ ಮನಸೋದ್ಯೋಗೀ ಚ ಸನ್ ಯೋಹನೋ ಮಜ್ಜನಮಾತ್ರಂ ಜ್ಞಾತ್ವಾ ಯಥಾರ್ಥತಯಾ ಪ್ರಭೋಃ ಕಥಾಂ ಕಥಯನ್ ಸಮುಪಾದಿಶತ್| ");
INSERT INTO sankan_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ಏಷ ಜನೋ ನಿರ್ಭಯತ್ವೇನ ಭಜನಭವನೇ ಕಥಯಿತುಮ್ ಆರಬ್ಧವಾನ್, ತತಃ ಪ್ರಿಸ್ಕಿಲ್ಲಾಕ್ಕಿಲೌ ತಸ್ಯೋಪದೇಶಕಥಾಂ ನಿಶಮ್ಯ ತಂ ಸ್ವಯೋಃ ಸಮೀಪಮ್ ಆನೀಯ ಶುದ್ಧರೂಪೇಣೇಶ್ವರಸ್ಯ ಕಥಾಮ್ ಅಬೋಧಯತಾಮ್| ");
INSERT INTO sankan_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","ಪಶ್ಚಾತ್ ಸ ಆಖಾಯಾದೇಶಂ ಗನ್ತುಂ ಮತಿಂ ಕೃತವಾನ್, ತದಾ ತತ್ರತ್ಯಃ ಶಿಷ್ಯಗಣೋ ಯಥಾ ತಂ ಗೃಹ್ಲಾತಿ ತದರ್ಥಂ ಭ್ರಾತೃಗಣೇನ ಸಮಾಶ್ವಸ್ಯ ಪತ್ರೇ ಲಿಖಿತೇ ಸತಿ, ಆಪಲ್ಲಾಸ್ತತ್ರೋಪಸ್ಥಿತಃ ಸನ್ ಅನುಗ್ರಹೇಣ ಪ್ರತ್ಯಯಿನಾಂ ಬಹೂಪಕಾರಾನ್ ಅಕರೋತ್, ");
INSERT INTO sankan_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ಫಲತೋ ಯೀಶುರಭಿಷಿಕ್ತಸ್ತ್ರಾತೇತಿ ಶಾಸ್ತ್ರಪ್ರಮಾಣಂ ದತ್ವಾ ಪ್ರಕಾಶರೂಪೇಣ ಪ್ರತಿಪನ್ನಂ ಕೃತ್ವಾ ಯಿಹೂದೀಯಾನ್ ನಿರುತ್ತರಾನ್ ಕೃತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","ಕರಿನ್ಥನಗರ ಆಪಲ್ಲಸಃ ಸ್ಥಿತಿಕಾಲೇ ಪೌಲ ಉತ್ತರಪ್ರದೇಶೈರಾಗಚ್ಛನ್ ಇಫಿಷನಗರಮ್ ಉಪಸ್ಥಿತವಾನ್| ತತ್ರ ಕತಿಪಯಶಿಷ್ಯಾನ್ ಸಾಕ್ಷತ್ ಪ್ರಾಪ್ಯ ತಾನ್ ಅಪೃಚ್ಛತ್, ");
INSERT INTO sankan_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ಯೂಯಂ ವಿಶ್ವಸ್ಯ ಪವಿತ್ರಮಾತ್ಮಾನಂ ಪ್ರಾಪ್ತಾ ನ ವಾ? ತತಸ್ತೇ ಪ್ರತ್ಯವದನ್ ಪವಿತ್ರ ಆತ್ಮಾ ದೀಯತೇ ಇತ್ಯಸ್ಮಾಭಿಃ ಶ್ರುತಮಪಿ ನಹಿ| ");
INSERT INTO sankan_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","ತದಾ ಸಾಽವದತ್ ತರ್ಹಿ ಯೂಯಂ ಕೇನ ಮಜ್ಜಿತಾ ಅಭವತ? ತೇಽಕಥಯನ್ ಯೋಹನೋ ಮಜ್ಜನೇನ| ");
INSERT INTO sankan_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","ತದಾ ಪೌಲ ಉಕ್ತವಾನ್ ಇತಃ ಪರಂ ಯ ಉಪಸ್ಥಾಸ್ಯತಿ ತಸ್ಮಿನ್ ಅರ್ಥತ ಯೀಶುಖ್ರೀಷ್ಟೇ ವಿಶ್ವಸಿತವ್ಯಮಿತ್ಯುಕ್ತ್ವಾ ಯೋಹನ್ ಮನಃಪರಿವರ್ತ್ತನಸೂಚಕೇನ ಮಜ್ಜನೇನ ಜಲೇ ಲೋಕಾನ್ ಅಮಜ್ಜಯತ್| ");
INSERT INTO sankan_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ತಾದೃಶೀಂ ಕಥಾಂ ಶ್ರುತ್ವಾ ತೇ ಪ್ರಭೋ ರ್ಯೀಶುಖ್ರೀಷ್ಟಸ್ಯ ನಾಮ್ನಾ ಮಜ್ಜಿತಾ ಅಭವನ್| ");
INSERT INTO sankan_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ತತಃ ಪೌಲೇನ ತೇಷಾಂ ಗಾತ್ರೇಷು ಕರೇಽರ್ಪಿತೇ ತೇಷಾಮುಪರಿ ಪವಿತ್ರ ಆತ್ಮಾವರೂಢವಾನ್, ತಸ್ಮಾತ್ ತೇ ನಾನಾದೇಶೀಯಾ ಭಾಷಾ ಭವಿಷ್ಯತ್ಕಥಾಶ್ಚ ಕಥಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","ತೇ ಪ್ರಾಯೇಣ ದ್ವಾದಶಜನಾ ಆಸನ್| ");
INSERT INTO sankan_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","ಪೌಲೋ ಭಜನಭವನಂ ಗತ್ವಾ ಪ್ರಾಯೇಣ ಮಾಸತ್ರಯಮ್ ಈಶ್ವರಸ್ಯ ರಾಜ್ಯಸ್ಯ ವಿಚಾರಂ ಕೃತ್ವಾ ಲೋಕಾನ್ ಪ್ರವರ್ತ್ಯ ಸಾಹಸೇನ ಕಥಾಮಕಥಯತ್| ");
INSERT INTO sankan_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","ಕಿನ್ತು ಕಠಿನಾನ್ತಃಕರಣತ್ವಾತ್ ಕಿಯನ್ತೋ ಜನಾ ನ ವಿಶ್ವಸ್ಯ ಸರ್ವ್ವೇಷಾಂ ಸಮಕ್ಷಮ್ ಏತತ್ಪಥಸ್ಯ ನಿನ್ದಾಂ ಕರ್ತ್ತುಂ ಪ್ರವೃತ್ತಾಃ, ಅತಃ ಪೌಲಸ್ತೇಷಾಂ ಸಮೀಪಾತ್ ಪ್ರಸ್ಥಾಯ ಶಿಷ್ಯಗಣಂ ಪೃಥಕ್ಕೃತ್ವಾ ಪ್ರತ್ಯಹಂ ತುರಾನ್ನನಾಮ್ನಃ ಕಸ್ಯಚಿತ್ ಜನಸ್ಯ ಪಾಠಶಾಲಾಯಾಂ ವಿಚಾರಂ ಕೃತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ಇತ್ಥಂ ವತ್ಸರದ್ವಯಂ ಗತಂ ತಸ್ಮಾದ್ ಆಶಿಯಾದೇಶನಿವಾಸಿನಃ ಸರ್ವ್ವೇ ಯಿಹೂದೀಯಾ ಅನ್ಯದೇಶೀಯಲೋಕಾಶ್ಚ ಪ್ರಭೋ ರ್ಯೀಶೋಃ ಕಥಾಮ್ ಅಶ್ರೌಷನ್| ");
INSERT INTO sankan_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","ಪೌಲೇನ ಚ ಈಶ್ವರ ಏತಾದೃಶಾನ್ಯದ್ಭುತಾನಿ ಕರ್ಮ್ಮಾಣಿ ಕೃತವಾನ್ ");
INSERT INTO sankan_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ಯತ್ ಪರಿಧೇಯೇ ಗಾತ್ರಮಾರ್ಜನವಸ್ತ್ರೇ ವಾ ತಸ್ಯ ದೇಹಾತ್ ಪೀಡಿತಲೋಕಾನಾಮ್ ಸಮೀಪಮ್ ಆನೀತೇ ತೇ ನಿರಾಮಯಾ ಜಾತಾ ಅಪವಿತ್ರಾ ಭೂತಾಶ್ಚ ತೇಭ್ಯೋ ಬಹಿರ್ಗತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","ತದಾ ದೇಶಾಟನಕಾರಿಣಃ ಕಿಯನ್ತೋ ಯಿಹೂದೀಯಾ ಭೂತಾಪಸಾರಿಣೋ ಭೂತಗ್ರಸ್ತನೋಕಾನಾಂ ಸನ್ನಿಧೌ ಪ್ರಭೇ ರ್ಯೀಶೋ ರ್ನಾಮ ಜಪ್ತ್ವಾ ವಾಕ್ಯಮಿದಮ್ ಅವದನ್, ಯಸ್ಯ ಕಥಾಂ ಪೌಲಃ ಪ್ರಚಾರಯತಿ ತಸ್ಯ ಯೀಶೋ ರ್ನಾಮ್ನಾ ಯುಷ್ಮಾನ್ ಆಜ್ಞಾಪಯಾಮಃ| ");
INSERT INTO sankan_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","ಸ್ಕಿವನಾಮ್ನೋ ಯಿಹೂದೀಯಾನಾಂ ಪ್ರಧಾನಯಾಜಕಸ್ಯ ಸಪ್ತಭಿಃ ಪುತ್ತೈಸ್ತಥಾ ಕೃತೇ ಸತಿ ");
INSERT INTO sankan_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","ಕಶ್ಚಿದ್ ಅಪವಿತ್ರೋ ಭೂತಃ ಪ್ರತ್ಯುದಿತವಾನ್, ಯೀಶುಂ ಜಾನಾಮಿ ಪೌಲಞ್ಚ ಪರಿಚಿನೋಮಿ ಕಿನ್ತು ಕೇ ಯೂಯಂ? ");
INSERT INTO sankan_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ಇತ್ಯುಕ್ತ್ವಾ ಸೋಪವಿತ್ರಭೂತಗ್ರಸ್ತೋ ಮನುಷ್ಯೋ ಲಮ್ಫಂ ಕೃತ್ವಾ ತೇಷಾಮುಪರಿ ಪತಿತ್ವಾ ಬಲೇನ ತಾನ್ ಜಿತವಾನ್, ತಸ್ಮಾತ್ತೇ ನಗ್ನಾಃ ಕ್ಷತಾಙ್ಗಾಶ್ಚ ಸನ್ತಸ್ತಸ್ಮಾದ್ ಗೇಹಾತ್ ಪಲಾಯನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","ಸಾ ವಾಗ್ ಇಫಿಷನಗರನಿವಾಸಿನಸಂ ಸರ್ವ್ವೇಷಾಂ ಯಿಹೂದೀಯಾನಾಂ ಭಿನ್ನದೇಶೀಯಾನಾಂ ಲೋಕಾನಾಞ್ಚ ಶ್ರವೋಗೋಚರೀಭೂತಾ; ತತಃ ಸರ್ವ್ವೇ ಭಯಂ ಗತಾಃ ಪ್ರಭೋ ರ್ಯೀಶೋ ರ್ನಾಮ್ನೋ ಯಶೋ ಽವರ್ದ್ಧತ| ");
INSERT INTO sankan_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","ಯೇಷಾಮನೇಕೇಷಾಂ ಲೋಕಾನಾಂ ಪ್ರತೀತಿರಜಾಯತ ತ ಆಗತ್ಯ ಸ್ವೈಃ ಕೃತಾಃ ಕ್ರಿಯಾಃ ಪ್ರಕಾಶರೂಪೇಣಾಙ್ಗೀಕೃತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","ಬಹವೋ ಮಾಯಾಕರ್ಮ್ಮಕಾರಿಣಃ ಸ್ವಸ್ವಗ್ರನ್ಥಾನ್ ಆನೀಯ ರಾಶೀಕೃತ್ಯ ಸರ್ವ್ವೇಷಾಂ ಸಮಕ್ಷಮ್ ಅದಾಹಯನ್, ತತೋ ಗಣನಾಂ ಕೃತ್ವಾಬುಧ್ಯನ್ತ ಪಞ್ಚಾಯುತರೂಪ್ಯಮುದ್ರಾಮೂಲ್ಯಪುಸ್ತಕಾನಿ ದಗ್ಧಾನಿ| ");
INSERT INTO sankan_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ಇತ್ಥಂ ಪ್ರಭೋಃ ಕಥಾ ಸರ್ವ್ವದೇಶಂ ವ್ಯಾಪ್ಯ ಪ್ರಬಲಾ ಜಾತಾ| ");
INSERT INTO sankan_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","ಸರ್ವ್ವೇಷ್ವೇತೇಷು ಕರ್ಮ್ಮಸು ಸಮ್ಪನ್ನೇಷು ಸತ್ಸು ಪೌಲೋ ಮಾಕಿದನಿಯಾಖಾಯಾದೇಶಾಭ್ಯಾಂ ಯಿರೂಶಾಲಮಂ ಗನ್ತುಂ ಮತಿಂ ಕೃತ್ವಾ ಕಥಿತವಾನ್ ತತ್ಸ್ಥಾನಂ ಯಾತ್ರಾಯಾಂ ಕೃತಾಯಾಂ ಸತ್ಯಾಂ ಮಯಾ ರೋಮಾನಗರಂ ದ್ರಷ್ಟವ್ಯಂ| ");
INSERT INTO sankan_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","ಸ್ವಾನುಗತಲೋಕಾನಾಂ ತೀಮಥಿಯೇರಾಸ್ತೌ ದ್ವೌ ಜನೌ ಮಾಕಿದನಿಯಾದೇಶಂ ಪ್ರತಿ ಪ್ರಹಿತ್ಯ ಸ್ವಯಮ್ ಆಶಿಯಾದೇಶೇ ಕತಿಪಯದಿನಾನಿ ಸ್ಥಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","ಕಿನ್ತು ತಸ್ಮಿನ್ ಸಮಯೇ ಮತೇಽಸ್ಮಿನ್ ಕಲಹೋ ಜಾತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","ತತ್ಕಾರಣಮಿದಂ, ಅರ್ತ್ತಿಮೀದೇವ್ಯಾ ರೂಪ್ಯಮನ್ದಿರನಿರ್ಮ್ಮಾಣೇನ ಸರ್ವ್ವೇಷಾಂ ಶಿಲ್ಪಿನಾಂ ಯಥೇಷ್ಟಲಾಭಮ್ ಅಜನಯತ್ ಯೋ ದೀಮೀತ್ರಿಯನಾಮಾ ನಾಡೀನ್ಧಮಃ ");
INSERT INTO sankan_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ಸ ತಾನ್ ತತ್ಕರ್ಮ್ಮಜೀವಿನಃ ಸರ್ವ್ವಲೋಕಾಂಶ್ಚ ಸಮಾಹೂಯ ಭಾಷಿತವಾನ್ ಹೇ ಮಹೇಚ್ಛಾ ಏತೇನ ಮನ್ದಿರನಿರ್ಮ್ಮಾಣೇನಾಸ್ಮಾಕಂ ಜೀವಿಕಾ ಭವತಿ, ಏತದ್ ಯೂಯಂ ವಿತ್ಥ; ");
INSERT INTO sankan_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","ಕಿನ್ತು ಹಸ್ತನಿರ್ಮ್ಮಿತೇಶ್ವರಾ ಈಶ್ವರಾ ನಹಿ ಪೌಲನಾಮ್ನಾ ಕೇನಚಿಜ್ಜನೇನ ಕಥಾಮಿಮಾಂ ವ್ಯಾಹೃತ್ಯ ಕೇವಲೇಫಿಷನಗರೇ ನಹಿ ಪ್ರಾಯೇಣ ಸರ್ವ್ವಸ್ಮಿನ್ ಆಶಿಯಾದೇಶೇ ಪ್ರವೃತ್ತಿಂ ಗ್ರಾಹಯಿತ್ವಾ ಬಹುಲೋಕಾನಾಂ ಶೇಮುಷೀ ಪರಾವರ್ತ್ತಿತಾ, ಏತದ್ ಯುಷ್ಮಾಭಿ ರ್ದೃಶ್ಯತೇ ಶ್ರೂಯತೇ ಚ| ");
INSERT INTO sankan_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","ತೇನಾಸ್ಮಾಕಂ ವಾಣಿಜ್ಯಸ್ಯ ಸರ್ವ್ವಥಾ ಹಾನೇಃ ಸಮ್ಭವನಂ ಕೇವಲಮಿತಿ ನಹಿ, ಆಶಿಯಾದೇಶಸ್ಥೈ ರ್ವಾ ಸರ್ವ್ವಜಗತ್ಸ್ಥೈ ರ್ಲೋಕೈಃ ಪೂಜ್ಯಾ ಯಾರ್ತಿಮೀ ಮಹಾದೇವೀ ತಸ್ಯಾ ಮನ್ದಿರಸ್ಯಾವಜ್ಞಾನಸ್ಯ ತಸ್ಯಾ ಐಶ್ವರ್ಯ್ಯಸ್ಯ ನಾಶಸ್ಯ ಚ ಸಮ್ಭಾವನಾ ವಿದ್ಯತೇे| ");
INSERT INTO sankan_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","ಏತಾದೃಶೀಂ ಕಥಾಂ ಶ್ರುತ್ವಾ ತೇ ಮಹಾಕ್ರೋಧಾನ್ವಿತಾಃ ಸನ್ತ ಉಚ್ಚೈಃಕಾರಂ ಕಥಿತವನ್ತ ಇಫಿಷೀಯಾನಾಮ್ ಅರ್ತ್ತಿಮೀ ದೇವೀ ಮಹತೀ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","ತತಃ ಸರ್ವ್ವನಗರಂ ಕಲಹೇನ ಪರಿಪೂರ್ಣಮಭವತ್, ತತಃ ಪರಂ ತೇ ಮಾಕಿದನೀಯಗಾಯಾರಿಸ್ತಾರ್ಖನಾಮಾನೌ ಪೌಲಸ್ಯ ದ್ವೌ ಸಹಚರೌ ಧೃತ್ವೈಕಚಿತ್ತಾ ರಙ್ಗಭೂಮಿಂ ಜವೇನ ಧಾವಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","ತತಃ ಪೌಲೋ ಲೋಕಾನಾಂ ಸನ್ನಿಧಿಂ ಯಾತುಮ್ ಉದ್ಯತವಾನ್ ಕಿನ್ತು ಶಿಷ್ಯಗಣಸ್ತಂ ವಾರಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","ಪೌಲಸ್ಯತ್ಮೀಯಾ ಆಶಿಯಾದೇಶಸ್ಥಾಃ ಕತಿಪಯಾಃ ಪ್ರಧಾನಲೋಕಾಸ್ತಸ್ಯ ಸಮೀಪಂ ನರಮೇಕಂ ಪ್ರೇಷ್ಯ ತ್ವಂ ರಙ್ಗಭೂಮಿಂ ಮಾಗಾ ಇತಿ ನ್ಯವೇದಯನ್| ");
INSERT INTO sankan_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","ತತೋ ನಾನಾಲೋಕಾನಾಂ ನಾನಾಕಥಾಕಥನಾತ್ ಸಭಾ ವ್ಯಾಕುಲಾ ಜಾತಾ ಕಿಂ ಕಾರಣಾದ್ ಏತಾವತೀ ಜನತಾಭವತ್ ಏತದ್ ಅಧಿಕೈ ರ್ಲೋಕೈ ರ್ನಾಜ್ಞಾಯಿ| ");
INSERT INTO sankan_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","ತತಃ ಪರಂ ಜನತಾಮಧ್ಯಾದ್ ಯಿಹೂದೀಯೈರ್ಬಹಿಷ್ಕೃತಃ ಸಿಕನ್ದರೋ ಹಸ್ತೇನ ಸಙ್ಕೇತಂ ಕೃತ್ವಾ ಲೋಕೇಭ್ಯ ಉತ್ತರಂ ದಾತುಮುದ್ಯತವಾನ್, ");
INSERT INTO sankan_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","ಕಿನ್ತು ಸ ಯಿಹೂದೀಯಲೋಕ ಇತಿ ನಿಶ್ಚಿತೇ ಸತಿ ಇಫಿಷೀಯಾನಾಮ್ ಅರ್ತ್ತಿಮೀ ದೇವೀ ಮಹತೀತಿ ವಾಕ್ಯಂ ಪ್ರಾಯೇಣ ಪಞ್ಚ ದಣ್ಡಾನ್ ಯಾವದ್ ಏಕಸ್ವರೇಣ ಲೋಕನಿವಹೈಃ ಪ್ರೋಕ್ತಂ| ");
INSERT INTO sankan_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","ತತೋ ನಗರಾಧಿಪತಿಸ್ತಾನ್ ಸ್ಥಿರಾನ್ ಕೃತ್ವಾ ಕಥಿತವಾನ್ ಹೇ ಇಫಿಷಾಯಾಃ ಸರ್ವ್ವೇ ಲೋಕಾ ಆಕರ್ಣಯತ, ಅರ್ತಿಮೀಮಹಾದೇವ್ಯಾ ಮಹಾದೇವಾತ್ ಪತಿತಾಯಾಸ್ತತ್ಪ್ರತಿಮಾಯಾಶ್ಚ ಪೂಜನಮ ಇಫಿಷನಗರಸ್ಥಾಃ ಸರ್ವ್ವೇ ಲೋಕಾಃ ಕುರ್ವ್ವನ್ತಿ, ಏತತ್ ಕೇ ನ ಜಾನನ್ತಿ? ");
INSERT INTO sankan_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","ತಸ್ಮಾದ್ ಏತತ್ಪ್ರತಿಕೂಲಂ ಕೇಪಿ ಕಥಯಿತುಂ ನ ಶಕ್ನುವನ್ತಿ, ಇತಿ ಜ್ಞಾತ್ವಾ ಯುಷ್ಮಾಭಿಃ ಸುಸ್ಥಿರತ್ವೇನ ಸ್ಥಾತವ್ಯಮ್ ಅವಿವಿಚ್ಯ ಕಿಮಪಿ ಕರ್ಮ್ಮ ನ ಕರ್ತ್ತವ್ಯಞ್ಚ| ");
INSERT INTO sankan_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","ಯಾನ್ ಏತಾನ್ ಮನುಷ್ಯಾನ್ ಯೂಯಮತ್ರ ಸಮಾನಯತ ತೇ ಮನ್ದಿರದ್ರವ್ಯಾಪಹಾರಕಾ ಯುಷ್ಮಾಕಂ ದೇವ್ಯಾ ನಿನ್ದಕಾಶ್ಚ ನ ಭವನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","ಯದಿ ಕಞ್ಚನ ಪ್ರತಿ ದೀಮೀತ್ರಿಯಸ್ಯ ತಸ್ಯ ಸಹಾಯಾನಾಞ್ಚ ಕಾಚಿದ್ ಆಪತ್ತಿ ರ್ವಿದ್ಯತೇ ತರ್ಹಿ ಪ್ರತಿನಿಧಿಲೋಕಾ ವಿಚಾರಸ್ಥಾನಞ್ಚ ಸನ್ತಿ, ತೇ ತತ್ ಸ್ಥಾನಂ ಗತ್ವಾ ಉತ್ತರಪ್ರತ್ಯುತ್ತರೇ ಕುರ್ವ್ವನ್ತು| ");
INSERT INTO sankan_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","ಕಿನ್ತು ಯುಷ್ಮಾಕಂ ಕಾಚಿದಪರಾ ಕಥಾ ಯದಿ ತಿಷ್ಠತಿ ತರ್ಹಿ ನಿಯಮಿತಾಯಾಂ ಸಭಾಯಾಂ ತಸ್ಯಾ ನಿಷ್ಪತ್ತಿ ರ್ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","ಕಿನ್ತ್ವೇತಸ್ಯ ವಿರೋಧಸ್ಯೋತ್ತರಂ ಯೇನ ದಾತುಂ ಶಕ್ನುಮ್ ಏತಾದೃಶಸ್ಯ ಕಸ್ಯಚಿತ್ ಕಾರಣಸ್ಯಾಭಾವಾದ್ ಅದ್ಯತನಘಟನಾಹೇತೋ ರಾಜದ್ರೋಹಿಣಾಮಿವಾಸ್ಮಾಕಮ್ ಅಭಿಯೋಗೋ ಭವಿಷ್ಯತೀತಿ ಶಙ್ಕಾ ವಿದ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","ಇತಿ ಕಥಯಿತ್ವಾ ಸ ಸಭಾಸ್ಥಲೋಕಾನ್ ವಿಸೃಷ್ಟವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ಇತ್ಥಂ ಕಲಹೇ ನಿವೃತ್ತೇ ಸತಿ ಪೌಲಃ ಶಿಷ್ಯಗಣಮ್ ಆಹೂಯ ವಿಸರ್ಜನಂ ಪ್ರಾಪ್ಯ ಮಾಕಿದನಿಯಾದೇಶಂ ಪ್ರಸ್ಥಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","ತೇನ ಸ್ಥಾನೇನ ಗಚ್ಛನ್ ತದ್ದೇಶೀಯಾನ್ ಶಿಷ್ಯಾನ್ ಬಹೂಪದಿಶ್ಯ ಯೂನಾನೀಯದೇಶಮ್ ಉಪಸ್ಥಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ತತ್ರ ಮಾಸತ್ರಯಂ ಸ್ಥಿತ್ವಾ ತಸ್ಮಾತ್ ಸುರಿಯಾದೇಶಂ ಯಾತುಮ್ ಉದ್ಯತಃ, ಕಿನ್ತು ಯಿಹೂದೀಯಾಸ್ತಂ ಹನ್ತುಂ ಗುಪ್ತಾ ಅತಿಷ್ಠನ್ ತಸ್ಮಾತ್ ಸ ಪುನರಪಿ ಮಾಕಿದನಿಯಾಮಾರ್ಗೇಣ ಪ್ರತ್ಯಾಗನ್ತುಂ ಮತಿಂ ಕೃತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","ಬಿರಯಾನಗರೀಯಸೋಪಾತ್ರಃ ಥಿಷಲನೀಕೀಯಾರಿಸ್ತಾರ್ಖಸಿಕುನ್ದೌ ದರ್ಬ್ಬೋನಗರೀಯಗಾಯತೀಮಥಿಯೌ ಆಶಿಯಾದೇಶೀಯತುಖಿಕತ್ರಫಿಮೌ ಚ ತೇನ ಸಾರ್ದ್ಧಂ ಆಶಿಯಾದೇಶಂ ಯಾವದ್ ಗತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ಏತೇ ಸರ್ವ್ವೇ ಽಗ್ರಸರಾಃ ಸನ್ತೋ ಽಸ್ಮಾನ್ ಅಪೇಕ್ಷ್ಯ ತ್ರೋಯಾನಗರೇ ಸ್ಥಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","ಕಿಣ್ವಶೂನ್ಯಪೂಪೋತ್ಸವದಿನೇ ಚ ಗತೇ ಸತಿ ವಯಂ ಫಿಲಿಪೀನಗರಾತ್ ತೋಯಪಥೇನ ಗತ್ವಾ ಪಞ್ಚಭಿ ರ್ದಿನೈಸ್ತ್ರೋಯಾನಗರಮ್ ಉಪಸ್ಥಾಯ ತತ್ರ ಸಪ್ತದಿನಾನ್ಯವಾತಿಷ್ಠಾಮ| ");
INSERT INTO sankan_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","ಸಪ್ತಾಹಸ್ಯ ಪ್ರಥಮದಿನೇ ಪೂಪಾನ್ ಭಂಕ್ತು ಶಿಷ್ಯೇಷು ಮಿಲಿತೇಷು ಪೌಲಃ ಪರದಿನೇ ತಸ್ಮಾತ್ ಪ್ರಸ್ಥಾತುಮ್ ಉದ್ಯತಃ ಸನ್ ತದಹ್ನಿ ಪ್ರಾಯೇಣ ಕ್ಷಪಾಯಾ ಯಾಮದ್ವಯಂ ಯಾವತ್ ಶಿಷ್ಯೇಭ್ಯೋ ಧರ್ಮ್ಮಕಥಾಮ್ ಅಕಥಯತ್| ");
INSERT INTO sankan_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ಉಪರಿಸ್ಥೇ ಯಸ್ಮಿನ್ ಪ್ರಕೋಷ್ಠೇ ಸಭಾಂ ಕೃತ್ವಾಸನ್ ತತ್ರ ಬಹವಃ ಪ್ರದೀಪಾಃ ಪ್ರಾಜ್ವಲನ್| ");
INSERT INTO sankan_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ಉತುಖನಾಮಾ ಕಶ್ಚನ ಯುವಾ ಚ ವಾತಾಯನ ಉಪವಿಶನ್ ಘೋರತರನಿದ್ರಾಗ್ರಸ್ತೋ ಽಭೂತ್ ತದಾ ಪೌಲೇನ ಬಹುಕ್ಷಣಂ ಕಥಾಯಾಂ ಪ್ರಚಾರಿತಾಯಾಂ ನಿದ್ರಾಮಗ್ನಃ ಸ ತಸ್ಮಾದ್ ಉಪರಿಸ್ಥತೃತೀಯಪ್ರಕೋಷ್ಠಾದ್ ಅಪತತ್, ತತೋ ಲೋಕಾಸ್ತಂ ಮೃತಕಲ್ಪಂ ಧೃತ್ವೋದತೋಲಯನ್| ");
INSERT INTO sankan_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","ತತಃ ಪೌಲೋಽವರುಹ್ಯ ತಸ್ಯ ಗಾತ್ರೇ ಪತಿತ್ವಾ ತಂ ಕ್ರೋಡೇ ನಿಧಾಯ ಕಥಿತವಾನ್, ಯೂಯಂ ವ್ಯಾಕುಲಾ ಮಾ ಭೂತ ನಾಯಂ ಪ್ರಾಣೈ ರ್ವಿಯುಕ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","ಪಶ್ಚಾತ್ ಸ ಪುನಶ್ಚೋಪರಿ ಗತ್ವಾ ಪೂಪಾನ್ ಭಂಕ್ತ್ವಾ ಪ್ರಭಾತಂ ಯಾವತ್ ಕಥೋಪಕಥನೇ ಕೃತ್ವಾ ಪ್ರಸ್ಥಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","ತೇ ಚ ತಂ ಜೀವನ್ತಂ ಯುವಾನಂ ಗೃಹೀತ್ವಾ ಗತ್ವಾ ಪರಮಾಪ್ಯಾಯಿತಾ ಜಾತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","ಅನನ್ತರಂ ವಯಂ ಪೋತೇನಾಗ್ರಸರಾ ಭೂತ್ವಾಸ್ಮನಗರಮ್ ಉತ್ತೀರ್ಯ್ಯ ಪೌಲಂ ಗ್ರಹೀತುಂ ಮತಿಮ್ ಅಕುರ್ಮ್ಮ ಯತಃ ಸ ತತ್ರ ಪದ್ಭ್ಯಾಂ ವ್ರಜಿತುಂ ಮತಿಂ ಕೃತ್ವೇತಿ ನಿರೂಪಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","ತಸ್ಮಾತ್ ತತ್ರಾಸ್ಮಾಭಿಃ ಸಾರ್ದ್ಧಂ ತಸ್ಮಿನ್ ಮಿಲಿತೇ ಸತಿ ವಯಂ ತಂ ನೀತ್ವಾ ಮಿತುಲೀನ್ಯುಪದ್ವೀಪಂ ಪ್ರಾಪ್ತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","ತಸ್ಮಾತ್ ಪೋತಂ ಮೋಚಯಿತ್ವಾ ಪರೇಽಹನಿ ಖೀಯೋಪದ್ವೀಪಸ್ಯ ಸಮ್ಮುಖಂ ಲಬ್ಧವನ್ತಸ್ತಸ್ಮಾದ್ ಏಕೇನಾಹ್ನಾ ಸಾಮೋಪದ್ವೀಪಂ ಗತ್ವಾ ಪೋತಂ ಲಾಗಯಿತ್ವಾ ತ್ರೋಗುಲ್ಲಿಯೇ ಸ್ಥಿತ್ವಾ ಪರಸ್ಮಿನ್ ದಿವಸೇे ಮಿಲೀತನಗರಮ್ ಉಪಾತಿಷ್ಠಾಮ| ");
INSERT INTO sankan_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","ಯತಃ ಪೌಲ ಆಶಿಯಾದೇಶೇ ಕಾಲಂ ಯಾಪಯಿತುಮ್ ನಾಭಿಲಷನ್ ಇಫಿಷನಗರಂ ತ್ಯಕ್ತ್ವಾ ಯಾತುಂ ಮನ್ತ್ರಣಾಂ ಸ್ಥಿರೀಕೃತವಾನ್; ಯಸ್ಮಾದ್ ಯದಿ ಸಾಧ್ಯಂ ಭವತಿ ತರ್ಹಿ ನಿಸ್ತಾರೋತ್ಸವಸ್ಯ ಪಞ್ಚಾಶತ್ತಮದಿನೇ ಸ ಯಿರೂಶಾಲಮ್ಯುಪಸ್ಥಾತುಂ ಮತಿಂ ಕೃತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","ಪೌಲೋ ಮಿಲೀತಾದ್ ಇಫಿಷಂ ಪ್ರತಿ ಲೋಕಂ ಪ್ರಹಿತ್ಯ ಸಮಾಜಸ್ಯ ಪ್ರಾಚೀನಾನ್ ಆಹೂಯಾನೀತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","ತೇಷು ತಸ್ಯ ಸಮೀಪಮ್ ಉಪಸ್ಥಿತೇಷು ಸ ತೇಭ್ಯ ಇಮಾಂ ಕಥಾಂ ಕಥಿತವಾನ್, ಅಹಮ್ ಆಶಿಯಾದೇಶೇ ಪ್ರಥಮಾಗಮನಮ್ ಆರಭ್ಯಾದ್ಯ ಯಾವದ್ ಯುಷ್ಮಾಕಂ ಸನ್ನಿಧೌ ಸ್ಥಿತ್ವಾ ಸರ್ವ್ವಸಮಯೇ ಯಥಾಚರಿತವಾನ್ ತದ್ ಯೂಯಂ ಜಾನೀಥ; ");
INSERT INTO sankan_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ಫಲತಃ ಸರ್ವ್ವಥಾ ನಮ್ರಮನಾಃ ಸನ್ ಬಹುಶ್ರುಪಾತೇನ ಯಿಹುದೀಯಾನಾಮ್ ಕುಮನ್ತ್ರಣಾಜಾತನಾನಾಪರೀಕ್ಷಾಭಿಃ ಪ್ರಭೋಃ ಸೇವಾಮಕರವಂ| ");
INSERT INTO sankan_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","ಕಾಮಪಿ ಹಿತಕಥಾाಂ ನ ಗೋಪಾಯಿತವಾನ್ ತಾಂ ಪ್ರಚಾರ್ಯ್ಯ ಸಪ್ರಕಾಶಂ ಗೃಹೇ ಗೃಹೇ ಸಮುಪದಿಶ್ಯೇಶ್ವರಂ ಪ್ರತಿ ಮನಃ ಪರಾವರ್ತ್ತನೀಯಂ ಪ್ರಭೌ ಯೀಶುಖ್ರೀಷ್ಟೇ ವಿಶ್ವಸನೀಯಂ ");
INSERT INTO sankan_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","ಯಿಹೂದೀಯಾನಾಮ್ ಅನ್ಯದೇಶೀಯಲೋಕಾನಾಞ್ಚ ಸಮೀಪ ಏತಾದೃಶಂ ಸಾಕ್ಷ್ಯಂ ದದಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","ಪಶ್ಯತ ಸಾಮ್ಪ್ರತಮ್ ಆತ್ಮನಾಕೃಷ್ಟಃ ಸನ್ ಯಿರೂಶಾಲಮ್ನಗರೇ ಯಾತ್ರಾಂ ಕರೋಮಿ, ತತ್ರ ಮಾಮ್ಪ್ರತಿ ಯದ್ಯದ್ ಘಟಿಷ್ಯತೇ ತಾನ್ಯಹಂ ನ ಜಾನಾಮಿ; ");
INSERT INTO sankan_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","ಕಿನ್ತು ಮಯಾ ಬನ್ಧನಂ ಕ್ಲೇಶಶ್ಚ ಭೋಕ್ತವ್ಯ ಇತಿ ಪವಿತ್ರ ಆತ್ಮಾ ನಗರೇ ನಗರೇ ಪ್ರಮಾಣಂ ದದಾತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","ತಥಾಪಿ ತಂ ಕ್ಲೇಶಮಹಂ ತೃಣಾಯ ನ ಮನ್ಯೇ; ಈಶ್ವರಸ್ಯಾನುಗ್ರಹವಿಷಯಕಸ್ಯ ಸುಸಂವಾದಸ್ಯ ಪ್ರಮಾಣಂ ದಾತುಂ, ಪ್ರಭೋ ರ್ಯೀಶೋಃ ಸಕಾಶಾದ ಯಸ್ಯಾಃ ಸೇವಾಯಾಃ ಭಾರಂ ಪ್ರಾಪ್ನವಂ ತಾಂ ಸೇವಾಂ ಸಾಧಯಿತುಂ ಸಾನನ್ದಂ ಸ್ವಮಾರ್ಗಂ ಸಮಾಪಯಿತುुಞ್ಚ ನಿಜಪ್ರಾಣಾನಪಿ ಪ್ರಿಯಾನ್ ನ ಮನ್ಯೇ| ");
INSERT INTO sankan_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","ಅಧುನಾ ಪಶ್ಯತ ಯೇಷಾಂ ಸಮೀಪೇಽಹಮ್ ಈಶ್ವರೀಯರಾಜ್ಯಸ್ಯ ಸುಸಂವಾದಂ ಪ್ರಚಾರ್ಯ್ಯ ಭ್ರಮಣಂ ಕೃತವಾನ್ ಏತಾದೃಶಾ ಯೂಯಂ ಮಮ ವದನಂ ಪುನ ರ್ದ್ರಷ್ಟುಂ ನ ಪ್ರಾಪ್ಸ್ಯಥ ಏತದಪ್ಯಹಂ ಜಾನಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","ಯುಷ್ಮಭ್ಯಮ್ ಅಹಮ್ ಈಶ್ವರಸ್ಯ ಸರ್ವ್ವಾನ್ ಆದೇಶಾನ್ ಪ್ರಕಾಶಯಿತುಂ ನ ನ್ಯವರ್ತ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","ಅಹಂ ಸರ್ವ್ವೇಷಾಂ ಲೋಕಾನಾಂ ರಕ್ತಪಾತದೋಷಾದ್ ಯನ್ನಿರ್ದೋಷ ಆಸೇ ತಸ್ಯಾದ್ಯ ಯುಷ್ಮಾನ್ ಸಾಕ್ಷಿಣಃ ಕರೋಮಿ| ");
INSERT INTO sankan_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","ಯೂಯಂ ಸ್ವೇಷು ತಥಾ ಯಸ್ಯ ವ್ರಜಸ್ಯಾಧ್ಯಕ್ಷನ್ ಆತ್ಮಾ ಯುಷ್ಮಾನ್ ವಿಧಾಯ ನ್ಯಯುಙ್ಕ್ತ ತತ್ಸರ್ವ್ವಸ್ಮಿನ್ ಸಾವಧಾನಾ ಭವತ, ಯ ಸಮಾಜಞ್ಚ ಪ್ರಭು ರ್ನಿಜರಕ್ತಮೂಲ್ಯೇನ ಕ್ರೀತವಾನ ತಮ್ ಅವತ, ");
INSERT INTO sankan_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","ಯತೋ ಮಯಾ ಗಮನೇ ಕೃತಏವ ದುರ್ಜಯಾ ವೃಕಾ ಯುಷ್ಮಾಕಂ ಮಧ್ಯಂ ಪ್ರವಿಶ್ಯ ವ್ರಜಂ ಪ್ರತಿ ನಿರ್ದಯತಾಮ್ ಆಚರಿಷ್ಯನ್ತಿ, ");
INSERT INTO sankan_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","ಯುಷ್ಮಾಕಮೇವ ಮಧ್ಯಾದಪಿ ಲೋಕಾ ಉತ್ಥಾಯ ಶಿಷ್ಯಗಣಮ್ ಅಪಹನ್ತುಂ ವಿಪರೀತಮ್ ಉಪದೇಕ್ಷ್ಯನ್ತೀತ್ಯಹಂ ಜಾನಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","ಇತಿ ಹೇತೋ ರ್ಯೂಯಂ ಸಚೈತನ್ಯಾಃ ಸನ್ತಸ್ತಿಷ್ಟತ, ಅಹಞ್ಚ ಸಾಶ್ರುಪಾತಃ ಸನ್ ವತ್ಸರತ್ರಯಂ ಯಾವದ್ ದಿವಾನಿಶಂ ಪ್ರತಿಜನಂ ಬೋಧಯಿತುಂ ನ ನ್ಯವರ್ತ್ತೇ ತದಪಿ ಸ್ಮರತ| ");
INSERT INTO sankan_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","ಇದಾನೀಂ ಹೇ ಭ್ರಾತರೋ ಯುಷ್ಮಾಕಂ ನಿಷ್ಠಾಂ ಜನಯಿತುಂ ಪವಿತ್ರೀಕೃತಲೋಕಾನಾಂ ಮಧ್ಯೇಽಧಿಕಾರಞ್ಚ ದಾತುಂ ಸಮರ್ಥೋ ಯ ಈಶ್ವರಸ್ತಸ್ಯಾನುಗ್ರಹಸ್ಯ ಯೋ ವಾದಶ್ಚ ತಯೋರುಭಯೋ ರ್ಯುಷ್ಮಾನ್ ಸಮಾರ್ಪಯಮ್| ");
INSERT INTO sankan_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","ಕಸ್ಯಾಪಿ ಸ್ವರ್ಣಂ ರೂಪ್ಯಂ ವಸ್ತ್ರಂ ವಾ ಪ್ರತಿ ಮಯಾ ಲೋಭೋ ನ ಕೃತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","ಕಿನ್ತು ಮಮ ಮತ್ಸಹಚರಲೋಕಾನಾಞ್ಚಾವಶ್ಯಕವ್ಯಯಾಯ ಮದೀಯಮಿದಂ ಕರದ್ವಯಮ್ ಅಶ್ರಾಮ್ಯದ್ ಏತದ್ ಯೂಯಂ ಜಾನೀಥ| ");
INSERT INTO sankan_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","ಅನೇನ ಪ್ರಕಾರೇಣ ಗ್ರಹಣದ್ ದಾನಂ ಭದ್ರಮಿತಿ ಯದ್ವಾಕ್ಯಂ ಪ್ರಭು ರ್ಯೀಶುಃ ಕಥಿತವಾನ್ ತತ್ ಸ್ಮರ್ತ್ತುಂ ದರಿದ್ರಲೋಕಾನಾಮುಪಕಾರಾರ್ಥಂ ಶ್ರಮಂ ಕರ್ತ್ತುಞ್ಚ ಯುಷ್ಮಾಕಮ್ ಉಚಿತಮ್ ಏತತ್ಸರ್ವ್ವಂ ಯುಷ್ಮಾನಹಮ್ ಉಪದಿಷ್ಟವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ಏತಾಂ ಕಥಾಂ ಕಥಯಿತ್ವಾ ಸ ಜಾನುನೀ ಪಾತಯಿತ್ವಾ ಸರ್ವೈಃ ಸಹ ಪ್ರಾರ್ಥಯತ| ");
INSERT INTO sankan_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","ತೇನ ತೇ ಕ್ರನ್ದ್ರನ್ತಃ ");
INSERT INTO sankan_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ಪುನ ರ್ಮಮ ಮುಖಂ ನ ದ್ರಕ್ಷ್ಯಥ ವಿಶೇಷತ ಏಷಾ ಯಾ ಕಥಾ ತೇನಾಕಥಿ ತತ್ಕಾರಣಾತ್ ಶೋಕಂ ವಿಲಾಪಞ್ಚ ಕೃತ್ವಾ ಕಣ್ಠಂ ಧೃತ್ವಾ ಚುಮ್ಬಿತವನ್ತಃ| ಪಶ್ಚಾತ್ ತೇ ತಂ ಪೋತಂ ನೀತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","ತೈ ರ್ವಿಸೃಷ್ಟಾಃ ಸನ್ತೋ ವಯಂ ಪೋತಂ ಬಾಹಯಿತ್ವಾ ಋಜುಮಾರ್ಗೇಣ ಕೋಷಮ್ ಉಪದ್ವೀಪಮ್ ಆಗತ್ಯ ಪರೇಽಹನಿ ರೋದಿಯೋಪದ್ವೀಪಮ್ ಆಗಚ್ಛಾಮ ತತಸ್ತಸ್ಮಾತ್ ಪಾತಾರಾಯಾಮ್ ಉಪಾತಿಷ್ಠಾಮ| ");
INSERT INTO sankan_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","ತತ್ರ ಫೈನೀಕಿಯಾದೇಶಗಾಮಿನಮ್ ಪೋತಮೇಕಂ ಪ್ರಾಪ್ಯ ತಮಾರುಹ್ಯ ಗತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","ಕುಪ್ರೋಪದ್ವೀಪಂ ದೃಷ್ಟ್ವಾ ತಂ ಸವ್ಯದಿಶಿ ಸ್ಥಾಪಯಿತ್ವಾ ಸುರಿಯಾದೇಶಂ ಗತ್ವಾ ಪೋತಸ್ಥದ್ರವ್ಯಾಣ್ಯವರೋಹಯಿತುಂ ಸೋರನಗರೇ ಲಾಗಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","ತತ್ರ ಶಿಷ್ಯಗಣಸ್ಯ ಸಾಕ್ಷಾತ್ಕರಣಾಯ ವಯಂ ತತ್ರ ಸಪ್ತದಿನಾನಿ ಸ್ಥಿತವನ್ತಃ ಪಶ್ಚಾತ್ತೇ ಪವಿತ್ರೇಣಾತ್ಮನಾ ಪೌಲಂ ವ್ಯಾಹರನ್ ತ್ವಂ ಯಿರೂಶಾಲಮ್ನಗರಂ ಮಾ ಗಮಃ| ");
INSERT INTO sankan_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","ತತಸ್ತೇಷು ಸಪ್ತಸು ದಿನೇಷು ಯಾಪಿತೇಷು ಸತ್ಸು ವಯಂ ತಸ್ಮಾತ್ ಸ್ಥಾನಾತ್ ನಿಜವರ್ತ್ಮನಾ ಗತವನ್ತಃ, ತಸ್ಮಾತ್ ತೇ ಸಬಾಲವೃದ್ಧವನಿತಾ ಅಸ್ಮಾಭಿಃ ಸಹ ನಗರಸ್ಯ ಪರಿಸರಪರ್ಯ್ಯನ್ತಮ್ ಆಗತಾಃ ಪಶ್ಚಾದ್ವಯಂ ಜಲಧಿತಟೇ ಜಾನುಪಾತಂ ಪ್ರಾರ್ಥಯಾಮಹಿ| ");
INSERT INTO sankan_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ತತಃ ಪರಸ್ಪರಂ ವಿಸೃಷ್ಟಾಃ ಸನ್ತೋ ವಯಂ ಪೋತಂ ಗತಾಸ್ತೇ ತು ಸ್ವಸ್ವಗೃಹಂ ಪ್ರತ್ಯಾಗತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","ವಯಂ ಸೋರನಗರಾತ್ ನಾವಾ ಪ್ರಸ್ಥಾಯ ತಲಿಮಾಯಿನಗರಮ್ ಉಪಾತಿಷ್ಠಾಮ ತತ್ರಾಸ್ಮಾಕಂ ಸಮುದ್ರೀಯಮಾರ್ಗಸ್ಯಾನ್ತೋಽಭವತ್ ತತ್ರ ಭ್ರಾತೃಗಣಂ ನಮಸ್ಕೃತ್ಯ ದಿನಮೇಕಂ ತೈಃ ಸಾರ್ದ್ಧಮ್ ಉಷತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","ಪರೇ ಽಹನಿ ಪೌಲಸ್ತಸ್ಯ ಸಙ್ಗಿನೋ ವಯಞ್ಚ ಪ್ರತಿಷ್ಠಮಾನಾಃ ಕೈಸರಿಯಾನಗರಮ್ ಆಗತ್ಯ ಸುಸಂವಾದಪ್ರಚಾರಕಾನಾಂ ಸಪ್ತಜನಾನಾಂ ಫಿಲಿಪನಾಮ್ನ ಏಕಸ್ಯ ಗೃಹಂ ಪ್ರವಿಶ್ಯಾವತಿಷ್ಠಾಮ| ");
INSERT INTO sankan_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","ತಸ್ಯ ಚತಸ್ರೋ ದುಹಿತರೋಽನೂಢಾ ಭವಿಷ್ಯದ್ವಾದಿನ್ಯ ಆಸನ್| ");
INSERT INTO sankan_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","ತತ್ರಾಸ್ಮಾಸು ಬಹುದಿನಾನಿ ಪ್ರೋಷಿತೇಷು ಯಿಹೂದೀಯದೇಶಾದ್ ಆಗತ್ಯಾಗಾಬನಾಮಾ ಭವಿಷ್ಯದ್ವಾದೀ ಸಮುಪಸ್ಥಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ಸೋಸ್ಮಾಕಂ ಸಮೀಪಮೇತ್ಯ ಪೌಲಸ್ಯ ಕಟಿಬನ್ಧನಂ ಗೃಹೀತ್ವಾ ನಿಜಹಸ್ತಾಪಾದಾನ್ ಬದ್ಧ್ವಾ ಭಾಷಿತವಾನ್ ಯಸ್ಯೇದಂ ಕಟಿಬನ್ಧನಂ ತಂ ಯಿಹೂದೀಯಲೋಕಾ ಯಿರೂಶಾಲಮನಗರ ಇತ್ಥಂ ಬದ್ಧ್ವಾ ಭಿನ್ನದೇಶೀಯಾನಾಂ ಕರೇಷು ಸಮರ್ಪಯಿಷ್ಯನ್ತೀತಿ ವಾಕ್ಯಂ ಪವಿತ್ರ ಆತ್ಮಾ ಕಥಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ಏತಾದೃಶೀಂ ಕಥಾಂ ಶ್ರುತ್ವಾ ವಯಂ ತನ್ನಗರವಾಸಿನೋ ಭ್ರಾತರಶ್ಚ ಯಿರೂಶಾಲಮಂ ನ ಯಾತುಂ ಪೌಲಂ ವ್ಯನಯಾಮಹಿ; ");
INSERT INTO sankan_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","ಕಿನ್ತು ಸ ಪ್ರತ್ಯಾವಾದೀತ್, ಯೂಯಂ ಕಿಂ ಕುರುಥ? ಕಿಂ ಕ್ರನ್ದನೇನ ಮಮಾನ್ತಃಕರಣಂ ವಿದೀರ್ಣಂ ಕರಿಷ್ಯಥ? ಪ್ರಭೋ ರ್ಯೀಶೋ ರ್ನಾಮ್ನೋ ನಿಮಿತ್ತಂ ಯಿರೂಶಾಲಮಿ ಬದ್ಧೋ ಭವಿತುಂ ಕೇವಲ ತನ್ನ ಪ್ರಾಣಾನ್ ದಾತುಮಪಿ ಸಸಜ್ಜೋಸ್ಮಿ| ");
INSERT INTO sankan_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","ತೇನಾಸ್ಮಾಕಂ ಕಥಾಯಾಮ್ ಅಗೃಹೀತಾಯಾಮ್ ಈಶ್ವರಸ್ಯ ಯಥೇಚ್ಛಾ ತಥೈವ ಭವತ್ವಿತ್ಯುಕ್ತ್ವಾ ವಯಂ ನಿರಸ್ಯಾಮ| ");
INSERT INTO sankan_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","ಪರೇಽಹನಿ ಪಾಥೇಯದ್ರವ್ಯಾಣಿ ಗೃಹೀತ್ವಾ ಯಿರೂಶಾಲಮಂ ಪ್ರತಿ ಯಾತ್ರಾಮ್ ಅಕುರ್ಮ್ಮ| ");
INSERT INTO sankan_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","ತತಃ ಕೈಸರಿಯಾನಗರನಿವಾಸಿನಃ ಕತಿಪಯಾಃ ಶಿಷ್ಯಾ ಅಸ್ಮಾಭಿಃ ಸಾರ್ದ್ಧಮ್ ಇತ್ವಾ ಕೃಪ್ರೀಯೇನ ಮ್ನಾಸನ್ನಾಮ್ನಾ ಯೇನ ಪ್ರಾಚೀನಶಿಷ್ಯೇನ ಸಾರ್ದ್ಧಮ್ ಅಸ್ಮಾಭಿ ರ್ವಸ್ತವ್ಯಂ ತಸ್ಯ ಸಮೀಪಮ್ ಅಸ್ಮಾನ್ ನೀತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","ಅಸ್ಮಾಸು ಯಿರೂಶಾಲಮ್ಯುಪಸ್ಥಿತೇಷು ತತ್ರಸ್ಥಭ್ರಾತೃಗಣೋಽಸ್ಮಾನ್ ಆಹ್ಲಾದೇನ ಗೃಹೀತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","ಪರಸ್ಮಿನ್ ದಿವಸೇ ಪೌಲೇಽಸ್ಮಾಭಿಃ ಸಹ ಯಾಕೂಬೋ ಗೃಹಂ ಪ್ರವಿಷ್ಟೇ ಲೋಕಪ್ರಾಚೀನಾಃ ಸರ್ವ್ವೇ ತತ್ರ ಪರಿಷದಿ ಸಂಸ್ಥಿತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","ಅನನ್ತರಂ ಸ ತಾನ್ ನತ್ವಾ ಸ್ವೀಯಪ್ರಚಾರಣೇನ ಭಿನ್ನದೇಶೀಯಾನ್ ಪ್ರತೀಶ್ವರೋ ಯಾನಿ ಕರ್ಮ್ಮಾಣಿ ಸಾಧಿತವಾನ್ ತದೀಯಾಂ ಕಥಾಮ್ ಅನುಕ್ರಮಾತ್ ಕಥಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ಇತಿ ಶ್ರುತ್ವಾ ತೇ ಪ್ರಭುಂ ಧನ್ಯಂ ಪ್ರೋಚ್ಯ ವಾಕ್ಯಮಿದಮ್ ಅಭಾಷನ್ತ, ಹೇ ಭ್ರಾತ ರ್ಯಿಹೂದೀಯಾನಾಂ ಮಧ್ಯೇ ಬಹುಸಹಸ್ರಾಣಿ ಲೋಕಾ ವಿಶ್ವಾಸಿನ ಆಸತೇ ಕಿನ್ತು ತೇ ಸರ್ವ್ವೇ ವ್ಯವಸ್ಥಾಮತಾಚಾರಿಣ ಏತತ್ ಪ್ರತ್ಯಕ್ಷಂ ಪಶ್ಯಸಿ| ");
INSERT INTO sankan_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","ಶಿಶೂನಾಂ ತ್ವಕ್ಛೇದನಾದ್ಯಾಚರಣಂ ಪ್ರತಿಷಿಧ್ಯ ತ್ವಂ ಭಿನ್ನದೇಶನಿವಾಸಿನೋ ಯಿಹೂದೀಯಲೋಕಾನ್ ಮೂಸಾವಾಕ್ಯಮ್ ಅಶ್ರದ್ಧಾತುಮ್ ಉಪದಿಶಸೀತಿ ತೈಃ ಶ್ರುತಮಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","ತ್ವಮತ್ರಾಗತೋಸೀತಿ ವಾರ್ತ್ತಾಂ ಸಮಾಕರ್ಣ್ಯ ಜನನಿವಹೋ ಮಿಲಿತ್ವಾವಶ್ಯಮೇವಾಗಮಿಷ್ಯತಿ; ಅತಏವ ಕಿಂ ಕರಣೀಯಮ್? ಅತ್ರ ವಯಂ ಮನ್ತ್ರಯಿತ್ವಾ ಸಮುಪಾಯಂ ತ್ವಾಂ ವದಾಮಸ್ತಂ ತ್ವಮಾಚರ| ");
INSERT INTO sankan_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","ವ್ರತಂ ಕರ್ತ್ತುಂ ಕೃತಸಙ್ಕಲ್ಪಾ ಯೇಽಸ್ಮಾಂಕ ಚತ್ವಾರೋ ಮಾನವಾಃ ಸನ್ತಿ ");
INSERT INTO sankan_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","ತಾನ್ ಗೃಹೀತ್ವಾ ತೈಃ ಸಹಿತಃ ಸ್ವಂ ಶುಚಿಂ ಕುರು ತಥಾ ತೇಷಾಂ ಶಿರೋಮುಣ್ಡನೇ ಯೋ ವ್ಯಯೋ ಭವತಿ ತಂ ತ್ವಂ ದೇಹಿ| ತಥಾ ಕೃತೇ ತ್ವದೀಯಾಚಾರೇ ಯಾ ಜನಶ್ರುತಿ ರ್ಜಾಯತೇ ಸಾಲೀಕಾ ಕಿನ್ತು ತ್ವಂ ವಿಧಿಂ ಪಾಲಯನ್ ವ್ಯವಸ್ಥಾನುಸಾರೇಣೇವಾಚರಸೀತಿ ತೇ ಭೋತ್ಸನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","ಭಿನ್ನದೇಶೀಯಾನಾಂ ವಿಶ್ವಾಸಿಲೋಕಾನಾಂ ನಿಕಟೇ ವಯಂ ಪತ್ರಂ ಲಿಖಿತ್ವೇತ್ಥಂ ಸ್ಥಿರೀಕೃತವನ್ತಃ, ದೇವಪ್ರಸಾದಭೋಜನಂ ರಕ್ತಂ ಗಲಪೀಡನಮಾರಿತಪ್ರಾಣಿಭೋಜನಂ ವ್ಯಭಿಚಾರಶ್ಚೈತೇಭ್ಯಃ ಸ್ವರಕ್ಷಣವ್ಯತಿರೇಕೇಣ ತೇಷಾಮನ್ಯವಿಧಿಪಾಲನಂ ಕರಣೀಯಂ ನ| ");
INSERT INTO sankan_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","ತತಃ ಪೌಲಸ್ತಾನ್ ಮಾನುಷಾನಾದಾಯ ಪರಸ್ಮಿನ್ ದಿವಸೇ ತೈಃ ಸಹ ಶುಚಿ ರ್ಭೂತ್ವಾ ಮನ್ದಿರಂ ಗತ್ವಾ ಶೌಚಕರ್ಮ್ಮಣೋ ದಿನೇಷು ಸಮ್ಪೂರ್ಣೇಷು ತೇಷಾಮ್ ಏಕೈಕಾರ್ಥಂ ನೈವೇದ್ಯಾದ್ಯುತ್ಸರ್ಗೋ ಭವಿಷ್ಯತೀತಿ ಜ್ಞಾಪಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","ತೇಷು ಸಪ್ತಸು ದಿನೇಷು ಸಮಾಪ್ತಕಲ್ಪೇಷು ಆಶಿಯಾದೇಶನಿವಾಸಿನೋ ಯಿಹೂದೀಯಾಸ್ತಂ ಮಧ್ಯೇಮನ್ದಿರಂ ವಿಲೋಕ್ಯ ಜನನಿವಹಸ್ಯ ಮನಃಸು ಕುಪ್ರವೃತ್ತಿಂ ಜನಯಿತ್ವಾ ತಂ ಧೃತ್ವಾ ");
INSERT INTO sankan_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ಪ್ರೋಚ್ಚೈಃ ಪ್ರಾವೋಚನ್, ಹೇ ಇಸ್ರಾಯೇಲ್ಲೋಕಾಃ ಸರ್ವ್ವೇ ಸಾಹಾಯ್ಯಂ ಕುರುತ| ಯೋ ಮನುಜ ಏತೇಷಾಂ ಲೋಕಾನಾಂ ಮೂಸಾವ್ಯವಸ್ಥಾಯಾ ಏತಸ್ಯ ಸ್ಥಾನಸ್ಯಾಪಿ ವಿಪರೀತಂ ಸರ್ವ್ವತ್ರ ಸರ್ವ್ವಾನ್ ಶಿಕ್ಷಯತಿ ಸ ಏಷಃ; ವಿಶೇಷತಃ ಸ ಭಿನ್ನದೇಶೀಯಲೋಕಾನ್ ಮನ್ದಿರಮ್ ಆನೀಯ ಪವಿತ್ರಸ್ಥಾನಮೇತದ್ ಅಪವಿತ್ರಮಕರೋತ್| ");
INSERT INTO sankan_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","ಪೂರ್ವ್ವಂ ತೇ ಮಧ್ಯೇನಗರಮ್ ಇಫಿಷನಗರೀಯಂ ತ್ರಫಿಮಂ ಪೌಲೇನ ಸಹಿತಂ ದೃಷ್ಟವನ್ತ ಏತಸ್ಮಾತ್ ಪೌಲಸ್ತಂ ಮನ್ದಿರಮಧ್ಯಮ್ ಆನಯದ್ ಇತ್ಯನ್ವಮಿಮತ| ");
INSERT INTO sankan_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","ಅತಏವ ಸರ್ವ್ವಸ್ಮಿನ್ ನಗರೇ ಕಲಹೋತ್ಪನ್ನತ್ವಾತ್ ಧಾವನ್ತೋ ಲೋಕಾ ಆಗತ್ಯ ಪೌಲಂ ಧೃತ್ವಾ ಮನ್ದಿರಸ್ಯ ಬಹಿರಾಕೃಷ್ಯಾನಯನ್ ತತ್ಕ್ಷಣಾದ್ ದ್ವಾರಾಣಿ ಸರ್ವ್ವಾಣಿ ಚ ರುದ್ಧಾನಿ| ");
INSERT INTO sankan_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","ತೇಷು ತಂ ಹನ್ತುಮುದ್ಯತೇेಷು ಯಿರೂಶಾಲಮ್ನಗರೇ ಮಹಾನುಪದ್ರವೋ ಜಾತ ಇತಿ ವಾರ್ತ್ತಾಯಾಂ ಸಹಸ್ರಸೇನಾಪತೇಃ ಕರ್ಣಗೋಚರೀಭೂತಾಯಾಂ ಸತ್ಯಾಂ ಸ ತತ್ಕ್ಷಣಾತ್ ಸೈನ್ಯಾನಿ ಸೇನಾಪತಿಗಣಞ್ಚ ಗೃಹೀತ್ವಾ ಜವೇನಾಗತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","ತತೋ ಲೋಕಾಃ ಸೇನಾಗಣೇನ ಸಹ ಸಹಸ್ರಸೇನಾಪತಿಮ್ ಆಗಚ್ಛನ್ತಂ ದೃಷ್ಟ್ವಾ ಪೌಲತಾಡನಾತೋ ನ್ಯವರ್ತ್ತನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","ಸ ಸಹಸ್ರಸೇನಾಪತಿಃ ಸನ್ನಿಧಾವಾಗಮ್ಯ ಪೌಲಂ ಧೃತ್ವಾ ಶೃಙ್ಖಲದ್ವಯೇನ ಬದ್ಧಮ್ ಆದಿಶ್ಯ ತಾನ್ ಪೃಷ್ಟವಾನ್ ಏಷ ಕಃ? ಕಿಂ ಕರ್ಮ್ಮ ಚಾಯಂ ಕೃತವಾನ್? ");
INSERT INTO sankan_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","ತತೋ ಜನಸಮೂಹಸ್ಯ ಕಶ್ಚಿದ್ ಏಕಪ್ರಕಾರಂ ಕಶ್ಚಿದ್ ಅನ್ಯಪ್ರಕಾರಂ ವಾಕ್ಯಮ್ ಅರೌತ್ ಸ ತತ್ರ ಸತ್ಯಂ ಜ್ಞಾತುಮ್ ಕಲಹಕಾರಣಾದ್ ಅಶಕ್ತಃ ಸನ್ ತಂ ದುರ್ಗಂ ನೇತುಮ್ ಆಜ್ಞಾಪಯತ್| ");
INSERT INTO sankan_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","ತೇಷು ಸೋಪಾನಸ್ಯೋಪರಿ ಪ್ರಾಪ್ತೇಷು ಲೋಕಾನಾಂ ಸಾಹಸಕಾರಣಾತ್ ಸೇನಾಗಣಃ ಪೌಲಮುತ್ತೋಲ್ಯ ನೀತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ತತಃ ಸರ್ವ್ವೇ ಲೋಕಾಃ ಪಶ್ಚಾದ್ಗಾಮಿನಃ ಸನ್ತ ಏನಂ ದುರೀಕುರುತೇತಿ ವಾಕ್ಯಮ್ ಉಚ್ಚೈರವದನ್| ");
INSERT INTO sankan_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","ಪೌಲಸ್ಯ ದುರ್ಗಾನಯನಸಮಯೇ ಸ ತಸ್ಮೈ ಸಹಸ್ರಸೇನಾಪತಯೇ ಕಥಿತವಾನ್, ಭವತಃ ಪುರಸ್ತಾತ್ ಕಥಾಂ ಕಥಯಿತುಂ ಕಿಮ್ ಅನುಮನ್ಯತೇ? ಸ ತಮಪೃಚ್ಛತ್ ತ್ವಂ ಕಿಂ ಯೂನಾನೀಯಾಂ ಭಾಷಾಂ ಜಾನಾಸಿ? ");
INSERT INTO sankan_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","ಯೋ ಮಿಸರೀಯೋ ಜನಃ ಪೂರ್ವ್ವಂ ವಿರೋಧಂ ಕೃತ್ವಾ ಚತ್ವಾರಿ ಸಹಸ್ರಾಣಿ ಘಾತಕಾನ್ ಸಙ್ಗಿನಃ ಕೃತ್ವಾ ವಿಪಿನಂ ಗತವಾನ್ ತ್ವಂ ಕಿಂ ಸಏವ ನ ಭವಸಿ? ");
INSERT INTO sankan_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","ತದಾ ಪೌಲೋಽಕಥಯತ್ ಅಹಂ ಕಿಲಿಕಿಯಾದೇಶಸ್ಯ ತಾರ್ಷನಗರೀಯೋ ಯಿಹೂದೀಯೋ, ನಾಹಂ ಸಾಮಾನ್ಯನಗರೀಯೋ ಮಾನವಃ; ಅತಏವ ವಿನಯೇಽಹಂ ಲಾಕಾನಾಂ ಸಮಕ್ಷಂ ಕಥಾಂ ಕಥಯಿತುಂ ಮಾಮನುಜಾನೀಷ್ವ| ");
INSERT INTO sankan_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","ತೇನಾನುಜ್ಞಾತಃ ಪೌಲಃ ಸೋಪಾನೋಪರಿ ತಿಷ್ಠನ್ ಹಸ್ತೇನೇಙ್ಗಿತಂ ಕೃತವಾನ್, ತಸ್ಮಾತ್ ಸರ್ವ್ವೇ ಸುಸ್ಥಿರಾ ಅಭವನ್| ತದಾ ಪೌಲ ಇಬ್ರೀಯಭಾಷಯಾ ಕಥಯಿತುಮ್ ಆರಭತ, ");
INSERT INTO sankan_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","ಹೇ ಪಿತೃಗಣಾ ಹೇ ಭ್ರಾತೃಗಣಾಃ, ಇದಾನೀಂ ಮಮ ನಿವೇದನೇ ಸಮವಧತ್ತ| ");
INSERT INTO sankan_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","ತದಾ ಸ ಇಬ್ರೀಯಭಾಷಯಾ ಕಥಾಂ ಕಥಯತೀತಿ ಶ್ರುತ್ವಾ ಸರ್ವ್ವೇ ಲೋಕಾ ಅತೀವ ನಿಃಶಬ್ದಾ ಸನ್ತೋಽತಿಷ್ಠನ್| ");
INSERT INTO sankan_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","ಪಶ್ಚಾತ್ ಸೋಽಕಥಯದ್ ಅಹಂ ಯಿಹೂದೀಯ ಇತಿ ನಿಶ್ಚಯಃ ಕಿಲಿಕಿಯಾದೇಶಸ್ಯ ತಾರ್ಷನಗರಂ ಮಮ ಜನ್ಮಭೂಮಿಃ,ಏತನ್ನಗರೀಯಸ್ಯ ಗಮಿಲೀಯೇಲನಾಮ್ನೋಽಧ್ಯಾಪಕಸ್ಯ ಶಿಷ್ಯೋ ಭೂತ್ವಾ ಪೂರ್ವ್ವಪುರುಷಾಣಾಂ ವಿಧಿವ್ಯವಸ್ಥಾನುಸಾರೇಣ ಸಮ್ಪೂರ್ಣರೂಪೇಣ ಶಿಕ್ಷಿತೋಽಭವಮ್ ಇದಾನೀನ್ತನಾ ಯೂಯಂ ಯಾದೃಶಾ ಭವಥ ತಾದೃಶೋಽಹಮಪೀಶ್ವರಸೇವಾಯಾಮ್ ಉದ್ಯೋಗೀ ಜಾತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","ಮತಮೇತದ್ ದ್ವಿಷ್ಟ್ವಾ ತದ್ಗ್ರಾಹಿನಾರೀಪುರುಷಾನ್ ಕಾರಾಯಾಂ ಬದ್ಧ್ವಾ ತೇಷಾಂ ಪ್ರಾಣನಾಶಪರ್ಯ್ಯನ್ತಾಂ ವಿಪಕ್ಷತಾಮ್ ಅಕರವಮ್| ");
INSERT INTO sankan_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","ಮಹಾಯಾಜಕಃ ಸಭಾಸದಃ ಪ್ರಾಚೀನಲೋಕಾಶ್ಚ ಮಮೈತಸ್ಯಾಃ ಕಥಾಯಾಃ ಪ್ರಮಾಣಂ ದಾತುಂ ಶಕ್ನುವನ್ತಿ, ಯಸ್ಮಾತ್ ತೇಷಾಂ ಸಮೀಪಾದ್ ದಮ್ಮೇಷಕನಗರನಿವಾಸಿಭ್ರಾತೃಗಣಾರ್ಥಮ್ ಆಜ್ಞಾಪತ್ರಾಣಿ ಗೃಹೀತ್ವಾ ಯೇ ತತ್ರ ಸ್ಥಿತಾಸ್ತಾನ್ ದಣ್ಡಯಿತುಂ ಯಿರೂಶಾಲಮಮ್ ಆನಯನಾರ್ಥಂ ದಮ್ಮೇಷಕನಗರಂ ಗತೋಸ್ಮಿ| ");
INSERT INTO sankan_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","ಕಿನ್ತು ಗಚ್ಛನ್ ತನ್ನಗರಸ್ಯ ಸಮೀಪಂ ಪ್ರಾಪ್ತವಾನ್ ತದಾ ದ್ವಿತೀಯಪ್ರಹರವೇಲಾಯಾಂ ಸತ್ಯಾಮ್ ಅಕಸ್ಮಾದ್ ಗಗಣಾನ್ನಿರ್ಗತ್ಯ ಮಹತೀ ದೀಪ್ತಿ ರ್ಮಮ ಚತುರ್ದಿಶಿ ಪ್ರಕಾಶಿತವತೀ| ");
INSERT INTO sankan_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ತತೋ ಮಯಿ ಭೂಮೌै ಪತಿತೇ ಸತಿ, ಹೇ ಶೌಲ ಹೇ ಶೌಲ ಕುತೋ ಮಾಂ ತಾಡಯಸಿ? ಮಾಮ್ಪ್ರತಿ ಭಾಷಿತ ಏತಾದೃಶ ಏಕೋ ರವೋಪಿ ಮಯಾ ಶ್ರುತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","ತದಾಹಂ ಪ್ರತ್ಯವದಂ, ಹೇ ಪ್ರಭೇ ಕೋ ಭವಾನ್? ತತಃ ಸೋಽವಾದೀತ್ ಯಂ ತ್ವಂ ತಾಡಯಸಿ ಸ ನಾಸರತೀಯೋ ಯೀಶುರಹಂ| ");
INSERT INTO sankan_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","ಮಮ ಸಙ್ಗಿನೋ ಲೋಕಾಸ್ತಾಂ ದೀಪ್ತಿಂ ದೃಷ್ಟ್ವಾ ಭಿಯಂ ಪ್ರಾಪ್ತಾಃ, ಕಿನ್ತು ಮಾಮ್ಪ್ರತ್ಯುದಿತಂ ತದ್ವಾಕ್ಯಂ ತೇे ನಾಬುಧ್ಯನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","ತತಃ ಪರಂ ಪೃಷ್ಟವಾನಹಂ, ಹೇ ಪ್ರಭೋ ಮಯಾ ಕಿಂ ಕರ್ತ್ತವ್ಯಂ? ತತಃ ಪ್ರಭುರಕಥಯತ್, ಉತ್ಥಾಯ ದಮ್ಮೇಷಕನಗರಂ ಯಾಹಿ ತ್ವಯಾ ಯದ್ಯತ್ ಕರ್ತ್ತವ್ಯಂ ನಿರೂಪಿತಮಾಸ್ತೇ ತತ್ ತತ್ರ ತ್ವಂ ಜ್ಞಾಪಯಿಷ್ಯಸೇ| ");
INSERT INTO sankan_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","ಅನನ್ತರಂ ತಸ್ಯಾಃ ಖರತರದೀಪ್ತೇಃ ಕಾರಣಾತ್ ಕಿಮಪಿ ನ ದೃಷ್ಟ್ವಾ ಸಙ್ಗಿಗಣೇನ ಧೃತಹಸ್ತಃ ಸನ್ ದಮ್ಮೇಷಕನಗರಂ ವ್ರಜಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","ತನ್ನಗರನಿವಾಸಿನಾಂ ಸರ್ವ್ವೇಷಾಂ ಯಿಹೂದೀಯಾನಾಂ ಮಾನ್ಯೋ ವ್ಯವಸ್ಥಾನುಸಾರೇಣ ಭಕ್ತಶ್ಚ ಹನಾನೀಯನಾಮಾ ಮಾನವ ಏಕೋ ");
INSERT INTO sankan_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","ಮಮ ಸನ್ನಿಧಿಮ್ ಏತ್ಯ ತಿಷ್ಠನ್ ಅಕಥಯತ್, ಹೇ ಭ್ರಾತಃ ಶೌಲ ಸುದೃಷ್ಟಿ ರ್ಭವ ತಸ್ಮಿನ್ ದಣ್ಡೇಽಹಂ ಸಮ್ಯಕ್ ತಂ ದೃಷ್ಟವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","ತತಃ ಸ ಮಹ್ಯಂ ಕಥಿತವಾನ್ ಯಥಾ ತ್ವಮ್ ಈಶ್ವರಸ್ಯಾಭಿಪ್ರಾಯಂ ವೇತ್ಸಿ ತಸ್ಯ ಶುದ್ಧಸತ್ತ್ವಜನಸ್ಯ ದರ್ಶನಂ ಪ್ರಾಪ್ಯ ತಸ್ಯ ಶ್ರೀಮುಖಸ್ಯ ವಾಕ್ಯಂ ಶೃಣೋಷಿ ತನ್ನಿಮಿತ್ತಮ್ ಅಸ್ಮಾಕಂ ಪೂರ್ವ್ವಪುರುಷಾಣಾಮ್ ಈಶ್ವರಸ್ತ್ವಾಂ ಮನೋನೀತಂ ಕೃತವಾನಂ| ");
INSERT INTO sankan_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","ಯತೋ ಯದ್ಯದ್ ಅದ್ರಾಕ್ಷೀರಶ್ರೌಷೀಶ್ಚ ಸರ್ವ್ವೇಷಾಂ ಮಾನವಾನಾಂ ಸಮೀಪೇ ತ್ವಂ ತೇಷಾಂ ಸಾಕ್ಷೀ ಭವಿಷ್ಯಸಿ| ");
INSERT INTO sankan_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","ಅತಏವ ಕುತೋ ವಿಲಮ್ಬಸೇ? ಪ್ರಭೋ ರ್ನಾಮ್ನಾ ಪ್ರಾರ್ಥ್ಯ ನಿಜಪಾಪಪ್ರಕ್ಷಾಲನಾರ್ಥಂ ಮಜ್ಜನಾಯ ಸಮುತ್ತಿಷ್ಠ| ");
INSERT INTO sankan_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","ತತಃ ಪರಂ ಯಿರೂಶಾಲಮ್ನಗರಂ ಪ್ರತ್ಯಾಗತ್ಯ ಮನ್ದಿರೇಽಹಮ್ ಏಕದಾ ಪ್ರಾರ್ಥಯೇ, ತಸ್ಮಿನ್ ಸಮಯೇಽಹಮ್ ಅಭಿಭೂತಃ ಸನ್ ಪ್ರಭೂಂ ಸಾಕ್ಷಾತ್ ಪಶ್ಯನ್, ");
INSERT INTO sankan_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ತ್ವಂ ತ್ವರಯಾ ಯಿರೂಶಾಲಮಃ ಪ್ರತಿಷ್ಠಸ್ವ ಯತೋ ಲೋಕಾಮಯಿ ತವ ಸಾಕ್ಷ್ಯಂ ನ ಗ್ರಹೀಷ್ಯನ್ತಿ, ಮಾಮ್ಪ್ರತ್ಯುದಿತಂ ತಸ್ಯೇದಂ ವಾಕ್ಯಮ್ ಅಶ್ರೌಷಮ್| ");
INSERT INTO sankan_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","ತತೋಹಂ ಪ್ರತ್ಯವಾದಿಷಮ್ ಹೇ ಪ್ರಭೋ ಪ್ರತಿಭಜನಭವನಂ ತ್ವಯಿ ವಿಶ್ವಾಸಿನೋ ಲೋಕಾನ್ ಬದ್ಧ್ವಾ ಪ್ರಹೃತವಾನ್, ");
INSERT INTO sankan_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","ತಥಾ ತವ ಸಾಕ್ಷಿಣಃ ಸ್ತಿಫಾನಸ್ಯ ರಕ್ತಪಾತನಸಮಯೇ ತಸ್ಯ ವಿನಾಶಂ ಸಮ್ಮನ್ಯ ಸನ್ನಿಧೌ ತಿಷ್ಠನ್ ಹನ್ತೃಲೋಕಾನಾಂ ವಾಸಾಂಸಿ ರಕ್ಷಿತವಾನ್, ಏತತ್ ತೇ ವಿದುಃ| ");
INSERT INTO sankan_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","ತತಃ ಸೋಽಕಥಯತ್ ಪ್ರತಿಷ್ಠಸ್ವ ತ್ವಾಂ ದೂರಸ್ಥಭಿನ್ನದೇಶೀಯಾನಾಂ ಸಮೀಪಂ ಪ್ರೇಷಯಿಷ್ಯೇ| ");
INSERT INTO sankan_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","ತದಾ ಲೋಕಾ ಏತಾವತ್ಪರ್ಯ್ಯನ್ತಾಂ ತದೀಯಾಂ ಕಥಾಂ ಶ್ರುತ್ವಾ ಪ್ರೋಚ್ಚೈರಕಥಯನ್, ಏನಂ ಭೂಮಣ್ಡಲಾದ್ ದೂರೀಕುರುತ, ಏತಾದೃಶಜನಸ್ಯ ಜೀವನಂ ನೋಚಿತಮ್| ");
INSERT INTO sankan_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ಇತ್ಯುಚ್ಚೈಃ ಕಥಯಿತ್ವಾ ವಸನಾನಿ ಪರಿತ್ಯಜ್ಯ ಗಗಣಂ ಪ್ರತಿ ಧೂಲೀರಕ್ಷಿಪನ್ ");
INSERT INTO sankan_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ತತಃ ಸಹಸ್ರಸೇನಾಪತಿಃ ಪೌಲಂ ದುರ್ಗಾಭ್ಯನ್ತರ ನೇತುಂ ಸಮಾದಿಶತ್| ಏತಸ್ಯ ಪ್ರತಿಕೂಲಾಃ ಸನ್ತೋ ಲೋಕಾಃ ಕಿನ್ನಿಮಿತ್ತಮ್ ಏತಾವದುಚ್ಚೈಃಸ್ವರಮ್ ಅಕುರ್ವ್ವನ್, ಏತದ್ ವೇತ್ತುಂ ತಂ ಕಶಯಾ ಪ್ರಹೃತ್ಯ ತಸ್ಯ ಪರೀಕ್ಷಾಂ ಕರ್ತ್ತುಮಾದಿಶತ್| ");
INSERT INTO sankan_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","ಪದಾತಯಶ್ಚರ್ಮ್ಮನಿರ್ಮ್ಮಿತರಜ್ಜುಭಿಸ್ತಸ್ಯ ಬನ್ಧನಂ ಕರ್ತ್ತುಮುದ್ಯತಾಸ್ತಾಸ್ತದಾನೀಂ ಪೌಲಃ ಸಮ್ಮುಖಸ್ಥಿತಂ ಶತಸೇನಾಪತಿಮ್ ಉಕ್ತವಾನ್ ದಣ್ಡಾಜ್ಞಾಯಾಮ್ ಅಪ್ರಾಪ್ತಾಯಾಂ ಕಿಂ ರೋಮಿಲೋಕಂ ಪ್ರಹರ್ತ್ತುಂ ಯುಷ್ಮಾಕಮ್ ಅಧಿಕಾರೋಸ್ತಿ? ");
INSERT INTO sankan_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","ಏನಾಂ ಕಥಾಂ ಶ್ರುತ್ವಾ ಸ ಸಹಸ್ರಸೇನಾಪತೇಃ ಸನ್ನಿಧಿಂ ಗತ್ವಾ ತಾಂ ವಾರ್ತ್ತಾಮವದತ್ ಸ ರೋಮಿಲೋಕ ಏತಸ್ಮಾತ್ ಸಾವಧಾನಃ ಸನ್ ಕರ್ಮ್ಮ ಕುರು| ");
INSERT INTO sankan_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","ತಸ್ಮಾತ್ ಸಹಸ್ರಸೇನಾಪತಿ ರ್ಗತ್ವಾ ತಮಪ್ರಾಕ್ಷೀತ್ ತ್ವಂ ಕಿಂ ರೋಮಿಲೋಕಃ? ಇತಿ ಮಾಂ ಬ್ರೂಹಿ| ಸೋಽಕಥಯತ್ ಸತ್ಯಮ್| ");
INSERT INTO sankan_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","ತತಃ ಸಹಸ್ರಸೇನಾಪತಿಃ ಕಥಿತವಾನ್ ಬಹುದ್ರವಿಣಂ ದತ್ತ್ವಾಹಂ ತತ್ ಪೌರಸಖ್ಯಂ ಪ್ರಾಪ್ತವಾನ್; ಕಿನ್ತು ಪೌಲಃ ಕಥಿತವಾನ್ ಅಹಂ ಜನುನಾ ತತ್ ಪ್ರಾಪ್ತೋಽಸ್ಮಿ| ");
INSERT INTO sankan_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","ಇತ್ಥಂ ಸತಿ ಯೇ ಪ್ರಹಾರೇಣ ತಂ ಪರೀಕ್ಷಿತುಂ ಸಮುದ್ಯತಾ ಆಸನ್ ತೇ ತಸ್ಯ ಸಮೀಪಾತ್ ಪ್ರಾತಿಷ್ಠನ್ತ; ಸಹಸ್ರಸೇನಾಪತಿಸ್ತಂ ರೋಮಿಲೋಕಂ ವಿಜ್ಞಾಯ ಸ್ವಯಂ ಯತ್ ತಸ್ಯ ಬನ್ಧನಮ್ ಅಕಾರ್ಷೀತ್ ತತ್ಕಾರಣಾದ್ ಅಬಿಭೇತ್| ");
INSERT INTO sankan_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","ಯಿಹೂದೀಯಲೋಕಾಃ ಪೌಲಂ ಕುತೋಽಪವದನ್ತೇ ತಸ್ಯ ವೃತ್ತಾನ್ತಂ ಜ್ಞಾತುಂ ವಾಞ್ಛನ್ ಸಹಸ್ರಸೇನಾಪತಿಃ ಪರೇಽಹನಿ ಪೌಲಂ ಬನ್ಧನಾತ್ ಮೋಚಯಿತ್ವಾ ಪ್ರಧಾನಯಾಜಕಾನ್ ಮಹಾಸಭಾಯಾಃ ಸರ್ವ್ವಲೋಕಾಶ್ಚ ಸಮುಪಸ್ಥಾತುಮ್ ಆದಿಶ್ಯ ತೇಷಾಂ ಸನ್ನಿಧೌ ಪೌಲಮ್ ಅವರೋಹ್ಯ ಸ್ಥಾಪಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","ಸಭಾಸದ್ಲೋಕಾನ್ ಪ್ರತಿ ಪೌಲೋಽನನ್ಯದೃಷ್ಟ್ಯಾ ಪಶ್ಯನ್ ಅಕಥಯತ್, ಹೇ ಭ್ರಾತೃಗಣಾ ಅದ್ಯ ಯಾವತ್ ಸರಲೇನ ಸರ್ವ್ವಾನ್ತಃಕರಣೇನೇಶ್ವರಸ್ಯ ಸಾಕ್ಷಾದ್ ಆಚರಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","ಅನೇನ ಹನಾನೀಯನಾಮಾ ಮಹಾಯಾಜಕಸ್ತಂ ಕಪೋಲೇ ಚಪೇಟೇನಾಹನ್ತುಂ ಸಮೀಪಸ್ಥಲೋಕಾನ್ ಆದಿಷ್ಟವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","ತದಾ ಪೌಲಸ್ತಮವದತ್, ಹೇ ಬಹಿಷ್ಪರಿಷ್ಕೃತ, ಈಶ್ವರಸ್ತ್ವಾಂ ಪ್ರಹರ್ತ್ತುಮ್ ಉದ್ಯತೋಸ್ತಿ, ಯತೋ ವ್ಯವಸ್ಥಾನುಸಾರೇಣ ವಿಚಾರಯಿತುಮ್ ಉಪವಿಶ್ಯ ವ್ಯವಸ್ಥಾಂ ಲಙ್ಘಿತ್ವಾ ಮಾಂ ಪ್ರಹರ್ತ್ತುಮ್ ಆಜ್ಞಾಪಯಸಿ| ");
INSERT INTO sankan_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","ತತೋ ನಿಕಟಸ್ಥಾ ಲೋಕಾ ಅಕಥಯನ್, ತ್ವಂ ಕಿಮ್ ಈಶ್ವರಸ್ಯ ಮಹಾಯಾಜಕಂ ನಿನ್ದಸಿ? ");
INSERT INTO sankan_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","ತತಃ ಪೌಲಃ ಪ್ರತಿಭಾಷಿತವಾನ್ ಹೇ ಭ್ರಾತೃಗಣ ಮಹಾಯಾಜಕ ಏಷ ಇತಿ ನ ಬುದ್ಧಂ ಮಯಾ ತದನ್ಯಚ್ಚ ಸ್ವಲೋಕಾನಾಮ್ ಅಧಿಪತಿಂ ಪ್ರತಿ ದುರ್ವ್ವಾಕ್ಯಂ ಮಾ ಕಥಯ, ಏತಾದೃಶೀ ಲಿಪಿರಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","ಅನನ್ತರಂ ಪೌಲಸ್ತೇಷಾಮ್ ಅರ್ದ್ಧಂ ಸಿದೂಕಿಲೋಕಾ ಅರ್ದ್ಧಂ ಫಿರೂಶಿಲೋಕಾ ಇತಿ ದೃಷ್ಟ್ವಾ ಪ್ರೋಚ್ಚೈಃ ಸಭಾಸ್ಥಲೋಕಾನ್ ಅವದತ್ ಹೇ ಭ್ರಾತೃಗಣ ಅಹಂ ಫಿರೂಶಿಮತಾವಲಮ್ಬೀ ಫಿರೂಶಿನಃ ಸತ್ನಾನಶ್ಚ, ಮೃತಲೋಕಾನಾಮ್ ಉತ್ಥಾನೇ ಪ್ರತ್ಯಾಶಾಕರಣಾದ್ ಅಹಮಪವಾದಿತೋಸ್ಮಿ| ");
INSERT INTO sankan_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ಇತಿ ಕಥಾಯಾಂ ಕಥಿತಾಯಾಂ ಫಿರೂಶಿಸಿದೂಕಿನೋಃ ಪರಸ್ಪರಂ ಭಿನ್ನವಾಕ್ಯತ್ವಾತ್ ಸಭಾಯಾ ಮಧ್ಯೇ ದ್ವೌ ಸಂಘೌ ಜಾತೌ| ");
INSERT INTO sankan_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","ಯತಃ ಸಿದೂಕಿಲೋಕಾ ಉತ್ಥಾನಂ ಸ್ವರ್ಗೀಯದೂತಾ ಆತ್ಮಾನಶ್ಚ ಸರ್ವ್ವೇಷಾಮ್ ಏತೇಷಾಂ ಕಮಪಿ ನ ಮನ್ಯನ್ತೇ, ಕಿನ್ತು ಫಿರೂಶಿನಃ ಸರ್ವ್ವಮ್ ಅಙ್ಗೀಕುರ್ವ್ವನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","ತತಃ ಪರಸ್ಪರಮ್ ಅತಿಶಯಕೋಲಾಹಲೇ ಸಮುಪಸ್ಥಿತೇ ಫಿರೂಶಿನಾಂ ಪಕ್ಷೀಯಾಃ ಸಭಾಸ್ಥಾ ಅಧ್ಯಾಪಕಾಃ ಪ್ರತಿಪಕ್ಷಾ ಉತ್ತಿಷ್ಠನ್ತೋ ಽಕಥಯನ್, ಏತಸ್ಯ ಮಾನವಸ್ಯ ಕಮಪಿ ದೋಷಂ ನ ಪಶ್ಯಾಮಃ; ಯದಿ ಕಶ್ಚಿದ್ ಆತ್ಮಾ ವಾ ಕಶ್ಚಿದ್ ದೂತ ಏನಂ ಪ್ರತ್ಯಾದಿಶತ್ ತರ್ಹಿ ವಯಮ್ ಈಶ್ವರಸ್ಯ ಪ್ರಾತಿಕೂಲ್ಯೇನ ನ ಯೋತ್ಸ್ಯಾಮಃ| ");
INSERT INTO sankan_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","ತಸ್ಮಾದ್ ಅತೀವ ಭಿನ್ನವಾಕ್ಯತ್ವೇ ಸತಿ ತೇ ಪೌಲಂ ಖಣ್ಡಂ ಖಣ್ಡಂ ಕರಿಷ್ಯನ್ತೀತ್ಯಾಶಙ್ಕಯಾ ಸಹಸ್ರಸೇನಾಪತಿಃ ಸೇನಾಗಣಂ ತತ್ಸ್ಥಾನಂ ಯಾತುಂ ಸಭಾತೋ ಬಲಾತ್ ಪೌಲಂ ಧೃತ್ವಾ ದುರ್ಗಂ ನೇತಞ್ಚಾಜ್ಞಾಪಯತ್| ");
INSERT INTO sankan_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","ರಾತ್ರೋ ಪ್ರಭುಸ್ತಸ್ಯ ಸಮೀಪೇ ತಿಷ್ಠನ್ ಕಥಿತವಾನ್ ಹೇ ಪೌಲ ನಿರ್ಭಯೋ ಭವ ಯಥಾ ಯಿರೂಶಾಲಮ್ನಗರೇ ಮಯಿ ಸಾಕ್ಷ್ಯಂ ದತ್ತವಾನ್ ತಥಾ ರೋಮಾನಗರೇಪಿ ತ್ವಯಾ ದಾತವ್ಯಮ್| ");
INSERT INTO sankan_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","ದಿನೇ ಸಮುಪಸ್ಥಿತೇ ಸತಿ ಕಿಯನ್ತೋ ಯಿಹೂದೀಯಲೋಕಾ ಏಕಮನ್ತ್ರಣಾಃ ಸನ್ತಃ ಪೌಲಂ ನ ಹತ್ವಾ ಭೋಜನಪಾನೇ ಕರಿಷ್ಯಾಮ ಇತಿ ಶಪಥೇನ ಸ್ವಾನ್ ಅಬಧ್ನನ್| ");
INSERT INTO sankan_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","ಚತ್ವಾರಿಂಶಜ್ಜನೇಭ್ಯೋಽಧಿಕಾ ಲೋಕಾ ಇತಿ ಪಣಮ್ ಅಕುರ್ವ್ವನ್| ");
INSERT INTO sankan_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","ತೇ ಮಹಾಯಾಜಕಾನಾಂ ಪ್ರಾಚೀನಲೋಕಾನಾಞ್ಚ ಸಮೀಪಂ ಗತ್ವಾ ಕಥಯನ್, ವಯಂ ಪೌಲಂ ನ ಹತ್ವಾ ಕಿಮಪಿ ನ ಭೋಕ್ಷ್ಯಾಮಹೇ ದೃಢೇನಾನೇನ ಶಪಥೇನ ಬದ್ಧ್ವಾ ಅಭವಾಮ| ");
INSERT INTO sankan_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","ಅತಏವ ಸಾಮ್ಪ್ರತಂ ಸಭಾಸದ್ಲೋಕೈಃ ಸಹ ವಯಂ ತಸ್ಮಿನ್ ಕಞ್ಚಿದ್ ವಿಶೇಷವಿಚಾರಂ ಕರಿಷ್ಯಾಮಸ್ತದರ್ಥಂ ಭವಾನ್ ಶ್ವೋ ಽಸ್ಮಾಕಂ ಸಮೀಪಂ ತಮ್ ಆನಯತ್ವಿತಿ ಸಹಸ್ರಸೇನಾಪತಯೇ ನಿವೇದನಂ ಕುರುತ ತೇನ ಯುಷ್ಮಾಕಂ ಸಮೀಪಂ ಉಪಸ್ಥಿತೇಃ ಪೂರ್ವ್ವಂ ವಯಂ ತಂ ಹನ್ತು ಸಜ್ಜಿಷ್ಯಾಮ| ");
INSERT INTO sankan_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","ತದಾ ಪೌಲಸ್ಯ ಭಾಗಿನೇಯಸ್ತೇಷಾಮಿತಿ ಮನ್ತ್ರಣಾಂ ವಿಜ್ಞಾಯ ದುರ್ಗಂ ಗತ್ವಾ ತಾಂ ವಾರ್ತ್ತಾಂ ಪೌಲಮ್ ಉಕ್ತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","ತಸ್ಮಾತ್ ಪೌಲ ಏಕಂ ಶತಸೇನಾಪತಿಮ್ ಆಹೂಯ ವಾಕ್ಯಮಿದಮ್ ಭಾಷಿತವಾನ್ ಸಹಸ್ರಸೇನಾಪತೇಃ ಸಮೀಪೇಽಸ್ಯ ಯುವಮನುಷ್ಯಸ್ಯ ಕಿಞ್ಚಿನ್ನಿವೇದನಮ್ ಆಸ್ತೇ, ತಸ್ಮಾತ್ ತತ್ಸವಿಧಮ್ ಏನಂ ನಯ| ");
INSERT INTO sankan_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","ತತಃ ಸ ತಮಾದಾಯ ಸಹಸ್ರಸೇನಾಪತೇಃ ಸಮೀಪಮ್ ಉಪಸ್ಥಾಯ ಕಥಿತವಾನ್, ಭವತಃ ಸಮೀಪೇಽಸ್ಯ ಕಿಮಪಿ ನಿವೇದನಮಾಸ್ತೇ ತಸ್ಮಾತ್ ಬನ್ದಿಃ ಪೌಲೋ ಮಾಮಾಹೂಯ ಭವತಃ ಸಮೀಪಮ್ ಏನಮ್ ಆನೇತುಂ ಪ್ರಾರ್ಥಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","ತದಾ ಸಹಸ್ರಸೇನಾಪತಿಸ್ತಸ್ಯ ಹಸ್ತಂ ಧೃತ್ವಾ ನಿರ್ಜನಸ್ಥಾನಂ ನೀತ್ವಾ ಪೃಷ್ಠವಾನ್ ತವ ಕಿಂ ನಿವೇದನಂ? ತತ್ ಕಥಯ| ");
INSERT INTO sankan_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","ತತಃ ಸೋಕಥಯತ್, ಯಿಹೂದೀಯಲಾಕಾಃ ಪೌಲೇ ಕಮಪಿ ವಿಶೇಷವಿಚಾರಂ ಛಲಂ ಕೃತ್ವಾ ತಂ ಸಭಾಂ ನೇತುಂ ಭವತಃ ಸಮೀಪೇ ನಿವೇದಯಿತುಂ ಅಮನ್ತ್ರಯನ್| ");
INSERT INTO sankan_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","ಕಿನ್ತು ಮವತಾ ತನ್ನ ಸ್ವೀಕರ್ತ್ತವ್ಯಂ ಯತಸ್ತೇಷಾಂ ಮಧ್ಯೇವರ್ತ್ತಿನಶ್ಚತ್ವಾರಿಂಶಜ್ಜನೇಭ್ಯೋ ಽಧಿಕಲೋಕಾ ಏಕಮನ್ತ್ರಣಾ ಭೂತ್ವಾ ಪೌಲಂ ನ ಹತ್ವಾ ಭೋಜನಂ ಪಾನಞ್ಚ ನ ಕರಿಷ್ಯಾಮ ಇತಿ ಶಪಥೇನ ಬದ್ಧಾಃ ಸನ್ತೋ ಘಾತಕಾ ಇವ ಸಜ್ಜಿತಾ ಇದಾನೀಂ ಕೇವಲಂ ಭವತೋ ಽನುಮತಿಮ್ ಅಪೇಕ್ಷನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","ಯಾಮಿಮಾಂ ಕಥಾಂ ತ್ವಂ ನಿವೇದಿತವಾನ್ ತಾಂ ಕಸ್ಮೈಚಿದಪಿ ಮಾ ಕಥಯೇತ್ಯುಕ್ತ್ವಾ ಸಹಸ್ರಸೇನಾಪತಿಸ್ತಂ ಯುವಾನಂ ವಿಸೃಷ್ಟವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","ಅನನ್ತರಂ ಸಹಸ್ರಸೇನಾಪತಿ ರ್ದ್ವೌ ಶತಸೇನಾಪತೀ ಆಹೂಯೇದಮ್ ಆದಿಶತ್, ಯುವಾಂ ರಾತ್ರೌ ಪ್ರಹರೈಕಾವಶಿಷ್ಟಾಯಾಂ ಸತ್ಯಾಂ ಕೈಸರಿಯಾನಗರಂ ಯಾತುಂ ಪದಾತಿಸೈನ್ಯಾನಾಂ ದ್ವೇ ಶತೇ ಘೋಟಕಾರೋಹಿಸೈನ್ಯಾನಾಂ ಸಪ್ತತಿಂ ಶಕ್ತಿಧಾರಿಸೈನ್ಯಾನಾಂ ದ್ವೇ ಶತೇ ಚ ಜನಾನ್ ಸಜ್ಜಿತಾನ್ ಕುರುತಂ| ");
INSERT INTO sankan_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","ಪೌಲಮ್ ಆರೋಹಯಿತುಂ ಫೀಲಿಕ್ಷಾಧಿಪತೇಃ ಸಮೀಪಂ ನಿರ್ವ್ವಿಘ್ನಂ ನೇತುಞ್ಚ ವಾಹನಾನಿ ಸಮುಪಸ್ಥಾಪಯತಂ| ");
INSERT INTO sankan_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","ಅಪರಂ ಸ ಪತ್ರಂ ಲಿಖಿತ್ವಾ ದತ್ತವಾನ್ ತಲ್ಲಿಖಿತಮೇತತ್, ");
INSERT INTO sankan_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","ಮಹಾಮಹಿಮಶ್ರೀಯುಕ್ತಫೀಲಿಕ್ಷಾಧಿಪತಯೇ ಕ್ಲೌದಿಯಲುಷಿಯಸ್ಯ ನಮಸ್ಕಾರಃ| ");
INSERT INTO sankan_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","ಯಿಹೂದೀಯಲೋಕಾಃ ಪೂರ್ವ್ವಮ್ ಏನಂ ಮಾನವಂ ಧೃತ್ವಾ ಸ್ವಹಸ್ತೈ ರ್ಹನ್ತುಮ್ ಉದ್ಯತಾ ಏತಸ್ಮಿನ್ನನ್ತರೇ ಸಸೈನ್ಯೋಹಂ ತತ್ರೋಪಸ್ಥಾಯ ಏಷ ಜನೋ ರೋಮೀಯ ಇತಿ ವಿಜ್ಞಾಯ ತಂ ರಕ್ಷಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","ಕಿನ್ನಿಮಿತ್ತಂ ತೇ ತಮಪವದನ್ತೇ ತಜ್ಜ್ಞಾತುಂ ತೇಷಾ ಸಭಾಂ ತಮಾನಾಯಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","ತತಸ್ತೇಷಾಂ ವ್ಯವಸ್ಥಾಯಾ ವಿರುದ್ಧಯಾ ಕಯಾಚನ ಕಥಯಾ ಸೋಽಪವಾದಿತೋಽಭವತ್, ಕಿನ್ತು ಸ ಶೃಙ್ಖಲಬನ್ಧನಾರ್ಹೋ ವಾ ಪ್ರಾಣನಾಶಾರ್ಹೋ ಭವತೀದೃಶಃ ಕೋಪ್ಯಪರಾಧೋ ಮಯಾಸ್ಯ ನ ದೃಷ್ಟಃ| ");
INSERT INTO sankan_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","ತಥಾಪಿ ಮನುಷ್ಯಸ್ಯಾಸ್ಯ ವಧಾರ್ಥಂ ಯಿಹೂದೀಯಾ ಘಾತಕಾಇವ ಸಜ್ಜಿತಾ ಏತಾಂ ವಾರ್ತ್ತಾಂ ಶ್ರುತ್ವಾ ತತ್ಕ್ಷಣಾತ್ ತವ ಸಮೀಪಮೇನಂ ಪ್ರೇಷಿತವಾನ್ ಅಸ್ಯಾಪವಾದಕಾಂಶ್ಚ ತವ ಸಮೀಪಂ ಗತ್ವಾಪವದಿತುಮ್ ಆಜ್ಞಾಪಯಮ್| ಭವತಃ ಕುಶಲಂ ಭೂಯಾತ್| ");
INSERT INTO sankan_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","ಸೈನ್ಯಗಣ ಆಜ್ಞಾನುಸಾರೇಣ ಪೌಲಂ ಗೃಹೀತ್ವಾ ತಸ್ಯಾಂ ರಜನ್ಯಾಮ್ ಆನ್ತಿಪಾತ್ರಿನಗರಮ್ ಆನಯತ್| ");
INSERT INTO sankan_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","ಪರೇಽಹನಿ ತೇನ ಸಹ ಯಾತುಂ ಘೋಟಕಾರೂಢಸೈನ್ಯಗಣಂ ಸ್ಥಾಪಯಿತ್ವಾ ಪರಾವೃತ್ಯ ದುರ್ಗಂ ಗತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","ತತಃ ಪರೇ ಘೋಟಕಾರೋಹಿಸೈನ್ಯಗಣಃ ಕೈಸರಿಯಾನಗರಮ್ ಉಪಸ್ಥಾಯ ತತ್ಪತ್ರಮ್ ಅಧಿಪತೇಃ ಕರೇ ಸಮರ್ಪ್ಯ ತಸ್ಯ ಸಮೀಪೇ ಪೌಲಮ್ ಉಪಸ್ಥಾಪಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","ತದಾಧಿಪತಿಸ್ತತ್ಪತ್ರಂ ಪಠಿತ್ವಾ ಪೃಷ್ಠವಾನ್ ಏಷ ಕಿಮ್ಪ್ರದೇಶೀಯೋ ಜನಃ? ಸ ಕಿಲಿಕಿಯಾಪ್ರದೇಶೀಯ ಏಕೋ ಜನ ಇತಿ ಜ್ಞಾತ್ವಾ ಕಥಿತವಾನ್, ");
INSERT INTO sankan_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ತವಾಪವಾದಕಗಣ ಆಗತೇ ತವ ಕಥಾಂ ಶ್ರೋಷ್ಯಾಮಿ| ಹೇರೋದ್ರಾಜಗೃಹೇ ತಂ ಸ್ಥಾಪಯಿತುಮ್ ಆದಿಷ್ಟವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","ಪಞ್ಚಭ್ಯೋ ದಿನೇಭ್ಯಃ ಪರಂ ಹನಾನೀಯನಾಮಾ ಮಹಾಯಾಜಕೋಽಧಿಪತೇಃ ಸಮಕ್ಷಂ ಪೌಲಸ್ಯ ಪ್ರಾತಿಕೂಲ್ಯೇನ ನಿವೇದಯಿತುಂ ತರ್ತುಲ್ಲನಾಮಾನಂ ಕಞ್ಚನ ವಕ್ತಾರಂ ಪ್ರಾಚೀನಜನಾಂಶ್ಚ ಸಙ್ಗಿನಃ ಕೃತ್ವಾ ಕೈಸರಿಯಾನಗರಮ್ ಆಗಚ್ಛತ್| ");
INSERT INTO sankan_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","ತತಃ ಪೌಲೇ ಸಮಾನೀತೇ ಸತಿ ತರ್ತುಲ್ಲಸ್ತಸ್ಯಾಪವಾದಕಥಾಂ ಕಥಯಿತುಮ್ ಆರಭತ ಹೇ ಮಹಾಮಹಿಮಫೀಲಿಕ್ಷ ಭವತೋ ವಯಮ್ ಅತಿನಿರ್ವ್ವಿಘ್ನಂ ಕಾಲಂ ಯಾಪಯಾಮೋ ಭವತಃ ಪರಿಣಾಮದರ್ಶಿತಯಾ ಏತದ್ದೇಶೀಯಾನಾಂ ಬಹೂನಿ ಮಙ್ಗಲಾನಿ ಘಟಿತಾನಿ, ");
INSERT INTO sankan_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","ಇತಿ ಹೇತೋ ರ್ವಯಮತಿಕೃತಜ್ಞಾಃ ಸನ್ತಃ ಸರ್ವ್ವತ್ರ ಸರ್ವ್ವದಾ ಭವತೋ ಗುಣಾನ್ ಗಾಯಮಃ| ");
INSERT INTO sankan_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","ಕಿನ್ತು ಬಹುಭಿಃ ಕಥಾಭಿ ರ್ಭವನ್ತಂ ಯೇನ ನ ವಿರಞ್ಜಯಾಮಿ ತಸ್ಮಾದ್ ವಿನಯೇ ಭವಾನ್ ಬನುಕಮ್ಪ್ಯ ಮದಲ್ಪಕಥಾಂ ಶೃಣೋತು| ");
INSERT INTO sankan_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","ಏಷ ಮಹಾಮಾರೀಸ್ವರೂಪೋ ನಾಸರತೀಯಮತಗ್ರಾಹಿಸಂಘಾತಸ್ಯ ಮುಖ್ಯೋ ಭೂತ್ವಾ ಸರ್ವ್ವದೇಶೇಷು ಸರ್ವ್ವೇಷಾಂ ಯಿಹೂದೀಯಾನಾಂ ರಾಜದ್ರೋಹಾಚರಣಪ್ರವೃತ್ತಿಂ ಜನಯತೀತ್ಯಸ್ಮಾಭಿ ರ್ನಿಶ್ಚಿತಂ| ");
INSERT INTO sankan_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","ಸ ಮನ್ದಿರಮಪಿ ಅಶುಚಿ ಕರ್ತ್ತುಂ ಚೇಷ್ಟಿತವಾನ್; ಇತಿ ಕಾರಣಾದ್ ವಯಮ್ ಏನಂ ಧೃತ್ವಾ ಸ್ವವ್ಯವಸ್ಥಾನುಸಾರೇಣ ವಿಚಾರಯಿತುಂ ಪ್ರಾವರ್ತ್ತಾಮಹಿ; ");
INSERT INTO sankan_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","ಕಿನ್ತು ಲುಷಿಯಃ ಸಹಸ್ರಸೇನಾಪತಿರಾಗತ್ಯ ಬಲಾದ್ ಅಸ್ಮಾಕಂ ಕರೇಭ್ಯ ಏನಂ ಗೃಹೀತ್ವಾ ");
INSERT INTO sankan_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ಏತಸ್ಯಾಪವಾದಕಾನ್ ಭವತಃ ಸಮೀಪಮ್ ಆಗನ್ತುಮ್ ಆಜ್ಞಾಪಯತ್| ವಯಂ ಯಸ್ಮಿನ್ ತಮಪವಾದಾಮೋ ಭವತಾ ಪದಪವಾದಕಥಾಯಾಂ ವಿಚಾರಿತಾಯಾಂ ಸತ್ಯಾಂ ಸರ್ವ್ವಂ ವೃತ್ತಾನ್ತಂ ವೇದಿತುಂ ಶಕ್ಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","ತತೋ ಯಿಹೂದೀಯಾ ಅಪಿ ಸ್ವೀಕೃತ್ಯ ಕಥಿತವನ್ತ ಏಷಾ ಕಥಾ ಪ್ರಮಾಣಮ್| ");
INSERT INTO sankan_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","ಅಧಿಪತೌ ಕಥಾಂ ಕಥಯಿತುಂ ಪೌಲಂ ಪ್ರತೀಙ್ಗಿತಂ ಕೃತವತಿ ಸ ಕಥಿತವಾನ್ ಭವಾನ್ ಬಹೂನ್ ವತ್ಸರಾನ್ ಯಾವದ್ ಏತದ್ದೇಶಸ್ಯ ಶಾಸನಂ ಕರೋತೀತಿ ವಿಜ್ಞಾಯ ಪ್ರತ್ಯುತ್ತರಂ ದಾತುಮ್ ಅಕ್ಷೋಭೋಽಭವಮ್| ");
INSERT INTO sankan_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","ಅದ್ಯ ಕೇವಲಂ ದ್ವಾದಶ ದಿನಾನಿ ಯಾತಾನಿ, ಅಹಮ್ ಆರಾಧನಾಂ ಕರ್ತ್ತುಂ ಯಿರೂಶಾಲಮನಗರಂ ಗತವಾನ್ ಏಷಾ ಕಥಾ ಭವತಾ ಜ್ಞಾತುಂ ಶಕ್ಯತೇ; ");
INSERT INTO sankan_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","ಕಿನ್ತ್ವಿಭೇ ಮಾಂ ಮಧ್ಯೇಮನ್ದಿರಂ ಕೇನಾಪಿ ಸಹ ವಿತಣ್ಡಾಂ ಕುರ್ವ್ವನ್ತಂ ಕುತ್ರಾಪಿ ಭಜನಭವನೇ ನಗರೇ ವಾ ಲೋಕಾನ್ ಕುಪ್ರವೃತ್ತಿಂ ಜನಯನ್ತುಂ ನ ದೃಷ್ಟವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","ಇದಾನೀಂ ಯಸ್ಮಿನ್ ಯಸ್ಮಿನ್ ಮಾಮ್ ಅಪವದನ್ತೇ ತಸ್ಯ ಕಿಮಪಿ ಪ್ರಮಾಣಂ ದಾತುಂ ನ ಶಕ್ನುವನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","ಕಿನ್ತು ಭವಿಷ್ಯದ್ವಾಕ್ಯಗ್ರನ್ಥೇ ವ್ಯವಸ್ಥಾಗ್ರನ್ಥೇ ಚ ಯಾ ಯಾ ಕಥಾ ಲಿಖಿತಾಸ್ತೇ ತಾಸು ಸರ್ವ್ವಾಸು ವಿಶ್ವಸ್ಯ ಯನ್ಮತಮ್ ಇಮೇ ವಿಧರ್ಮ್ಮಂ ಜಾನನ್ತಿ ತನ್ಮತಾನುಸಾರೇಣಾಹಂ ನಿಜಪಿತೃಪುರುಷಾಣಾಮ್ ಈಶ್ವರಮ್ ಆರಾಧಯಾಮೀತ್ಯಹಂ ಭವತಃ ಸಮಕ್ಷಮ್ ಅಙ್ಗೀಕರೋಮಿ| ");
INSERT INTO sankan_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","ಧಾರ್ಮ್ಮಿಕಾಣಾಮ್ ಅಧಾರ್ಮ್ಮಿಕಾಣಾಞ್ಚ ಪ್ರಮೀತಲೋಕಾನಾಮೇವೋತ್ಥಾನಂ ಭವಿಷ್ಯತೀತಿ ಕಥಾಮಿಮೇ ಸ್ವೀಕುರ್ವ್ವನ್ತಿ ತಥಾಹಮಪಿ ತಸ್ಮಿನ್ ಈಶ್ವರೇ ಪ್ರತ್ಯಾಶಾಂ ಕರೋಮಿ; ");
INSERT INTO sankan_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","ಈಶ್ವರಸ್ಯ ಮಾನವಾನಾಞ್ಚ ಸಮೀಪೇ ಯಥಾ ನಿರ್ದೋಷೋ ಭವಾಮಿ ತದರ್ಥಂ ಸತತಂ ಯತ್ನವಾನ್ ಅಸ್ಮಿ| ");
INSERT INTO sankan_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","ಬಹುಷು ವತ್ಸರೇಷು ಗತೇಷು ಸ್ವದೇಶೀಯಲೋಕಾನಾಂ ನಿಮಿತ್ತಂ ದಾನೀಯದ್ರವ್ಯಾಣಿ ನೈವೇದ್ಯಾನಿ ಚ ಸಮಾದಾಯ ಪುನರಾಗಮನಂ ಕೃತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","ತತೋಹಂ ಶುಚಿ ರ್ಭೂತ್ವಾ ಲೋಕಾನಾಂ ಸಮಾಗಮಂ ಕಲಹಂ ವಾ ನ ಕಾರಿತವಾನ್ ತಥಾಪ್ಯಾಶಿಯಾದೇಶೀಯಾಃ ಕಿಯನ್ತೋ ಯಿಹುದೀಯಲೋಕಾ ಮಧ್ಯೇಮನ್ದಿರಂ ಮಾಂ ಧೃತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","ಮಮೋಪರಿ ಯದಿ ಕಾಚಿದಪವಾದಕಥಾಸ್ತಿ ತರ್ಹಿ ಭವತಃ ಸಮೀಪಮ್ ಉಪಸ್ಥಾಯ ತೇಷಾಮೇವ ಸಾಕ್ಷ್ಯದಾನಮ್ ಉಚಿತಮ್| ");
INSERT INTO sankan_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","ನೋಚೇತ್ ಪೂರ್ವ್ವೇ ಮಹಾಸಭಾಸ್ಥಾನಾಂ ಲೋಕಾನಾಂ ಸನ್ನಿಧೌ ಮಮ ದಣ್ಡಾಯಮಾನತ್ವಸಮಯೇ, ಅಹಮದ್ಯ ಮೃತಾನಾಮುತ್ಥಾನೇ ಯುಷ್ಮಾಭಿ ರ್ವಿಚಾರಿತೋಸ್ಮಿ, ");
INSERT INTO sankan_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","ತೇಷಾಂ ಮಧ್ಯೇ ತಿಷ್ಠನ್ನಹಂ ಯಾಮಿಮಾಂ ಕಥಾಮುಚ್ಚೈಃ ಸ್ವರೇಣ ಕಥಿತವಾನ್ ತದನ್ಯೋ ಮಮ ಕೋಪಿ ದೋಷೋಽಲಭ್ಯತ ನ ವೇತಿ ವರಮ್ ಏತೇ ಸಮುಪಸ್ಥಿತಲೋಕಾ ವದನ್ತು| ");
INSERT INTO sankan_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","ತದಾ ಫೀಲಿಕ್ಷ ಏತಾಂ ಕಥಾಂ ಶ್ರುತ್ವಾ ತನ್ಮತಸ್ಯ ವಿಶೇಷವೃತ್ತಾನ್ತಂ ವಿಜ್ಞಾತುಂ ವಿಚಾರಂ ಸ್ಥಗಿತಂ ಕೃತ್ವಾ ಕಥಿತವಾನ್ ಲುಷಿಯೇ ಸಹಸ್ರಸೇನಾಪತೌ ಸಮಾಯಾತೇ ಸತಿ ಯುಷ್ಮಾಕಂ ವಿಚಾರಮ್ ಅಹಂ ನಿಷ್ಪಾದಯಿಷ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","ಅನನ್ತರಂ ಬನ್ಧನಂ ವಿನಾ ಪೌಲಂ ರಕ್ಷಿತುಂ ತಸ್ಯ ಸೇವನಾಯ ಸಾಕ್ಷಾತ್ಕರಣಾಯ ವಾ ತದೀಯಾತ್ಮೀಯಬನ್ಧುಜನಾನ್ ನ ವಾರಯಿತುಞ್ಚ ಶಮಸೇನಾಪತಿಮ್ ಆದಿಷ್ಟವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","ಅಲ್ಪದಿನಾತ್ ಪರಂ ಫೀಲಿಕ್ಷೋಽಧಿಪತಿ ರ್ದ್ರುಷಿಲ್ಲಾನಾಮ್ನಾ ಯಿಹೂದೀಯಯಾ ಸ್ವಭಾರ್ಯ್ಯಯಾ ಸಹಾಗತ್ಯ ಪೌಲಮಾಹೂಯ ತಸ್ಯ ಮುಖಾತ್ ಖ್ರೀಷ್ಟಧರ್ಮ್ಮಸ್ಯ ವೃತ್ತಾನ್ತಮ್ ಅಶ್ರೌಷೀತ್| ");
INSERT INTO sankan_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","ಪೌಲೇನ ನ್ಯಾಯಸ್ಯ ಪರಿಮಿತಭೋಗಸ್ಯ ಚರಮವಿಚಾರಸ್ಯ ಚ ಕಥಾಯಾಂ ಕಥಿತಾಯಾಂ ಸತ್ಯಾಂ ಫೀಲಿಕ್ಷಃ ಕಮ್ಪಮಾನಃ ಸನ್ ವ್ಯಾಹರದ್ ಇದಾನೀಂ ಯಾಹಿ, ಅಹಮ್ ಅವಕಾಶಂ ಪ್ರಾಪ್ಯ ತ್ವಾಮ್ ಆಹೂಸ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","ಮುಕ್ತಿಪ್ರಪ್ತ್ಯರ್ಥಂ ಪೌಲೇನ ಮಹ್ಯಂ ಮುದ್ರಾದಾಸ್ಯನ್ತೇ ಇತಿ ಪತ್ಯಾಶಾಂ ಕೃತ್ವಾ ಸ ಪುನಃ ಪುನಸ್ತಮಾಹೂಯ ತೇನ ಸಾಕಂ ಕಥೋಪಕಥನಂ ಕೃತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","ಕಿನ್ತು ವತ್ಸರದ್ವಯಾತ್ ಪರಂ ಪರ್ಕಿಯಫೀಷ್ಟ ಫಾಲಿಕ್ಷಸ್ಯ ಪದಂ ಪ್ರಾಪ್ತೇ ಸತಿ ಫೀಲಿಕ್ಷೋ ಯಿಹೂದೀಯಾನ್ ಸನ್ತುಷ್ಟಾನ್ ಚಿಕೀರ್ಷನ್ ಪೌಲಂ ಬದ್ಧಂ ಸಂಸ್ಥಾಪ್ಯ ಗತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","ಅನನ್ತರಂ ಫೀಷ್ಟೋ ನಿಜರಾಜ್ಯಮ್ ಆಗತ್ಯ ದಿನತ್ರಯಾತ್ ಪರಂ ಕೈಸರಿಯಾತೋ ಯಿರೂಶಾಲಮ್ನಗರಮ್ ಆಗಮತ್| ");
INSERT INTO sankan_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","ತದಾ ಮಹಾಯಾಜಕೋ ಯಿಹೂದೀಯಾನಾಂ ಪ್ರಧಾನಲೋಕಾಶ್ಚ ತಸ್ಯ ಸಮಕ್ಷಂ ಪೌಲಮ್ ಅಪಾವದನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ಭವಾನ್ ತಂ ಯಿರೂಶಾಲಮಮ್ ಆನೇತುಮ್ ಆಜ್ಞಾಪಯತ್ವಿತಿ ವಿನೀಯ ತೇ ತಸ್ಮಾದ್ ಅನುಗ್ರಹಂ ವಾಞ್ಛಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","ಯತಃ ಪಥಿಮಧ್ಯೇ ಗೋಪನೇನ ಪೌಲಂ ಹನ್ತುಂ ತೈ ರ್ಘಾತಕಾ ನಿಯುಕ್ತಾಃ| ಫೀಷ್ಟ ಉತ್ತರಂ ದತ್ತವಾನ್ ಪೌಲಃ ಕೈಸರಿಯಾಯಾಂ ಸ್ಥಾಸ್ಯತಿ ಪುನರಲ್ಪದಿನಾತ್ ಪರಮ್ ಅಹಂ ತತ್ರ ಯಾಸ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","ತತಸ್ತಸ್ಯ ಮಾನುಷಸ್ಯ ಯದಿ ಕಶ್ಚಿದ್ ಅಪರಾಧಸ್ತಿಷ್ಠತಿ ತರ್ಹಿ ಯುಷ್ಮಾಕಂ ಯೇ ಶಕ್ನುವನ್ತಿ ತೇ ಮಯಾ ಸಹ ತತ್ರ ಗತ್ವಾ ತಮಪವದನ್ತು ಸ ಏತಾಂ ಕಥಾಂ ಕಥಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","ದಶದಿವಸೇಭ್ಯೋಽಧಿಕಂ ವಿಲಮ್ಬ್ಯ ಫೀಷ್ಟಸ್ತಸ್ಮಾತ್ ಕೈಸರಿಯಾನಗರಂ ಗತ್ವಾ ಪರಸ್ಮಿನ್ ದಿವಸೇ ವಿಚಾರಾಸನ ಉಪದಿಶ್ಯ ಪೌಲಮ್ ಆನೇತುಮ್ ಆಜ್ಞಾಪಯತ್| ");
INSERT INTO sankan_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","ಪೌಲೇ ಸಮುಪಸ್ಥಿತೇ ಸತಿ ಯಿರೂಶಾಲಮ್ನಗರಾದ್ ಆಗತಾ ಯಿಹೂದೀಯಲೋಕಾಸ್ತಂ ಚತುರ್ದಿಶಿ ಸಂವೇಷ್ಟ್ಯ ತಸ್ಯ ವಿರುದ್ಧಂ ಬಹೂನ್ ಮಹಾದೋಷಾನ್ ಉತ್ಥಾಪಿತವನ್ತಃ ಕಿನ್ತು ತೇಷಾಂ ಕಿಮಪಿ ಪ್ರಮಾಣಂ ದಾತುಂ ನ ಶಕ್ನುವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","ತತಃ ಪೌಲಃ ಸ್ವಸ್ಮಿನ್ ಉತ್ತರಮಿದಮ್ ಉದಿತವಾನ್, ಯಿಹೂದೀಯಾನಾಂ ವ್ಯವಸ್ಥಾಯಾ ಮನ್ದಿರಸ್ಯ ಕೈಸರಸ್ಯ ವಾ ಪ್ರತಿಕೂಲಂ ಕಿಮಪಿ ಕರ್ಮ್ಮ ನಾಹಂ ಕೃತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","ಕಿನ್ತು ಫೀಷ್ಟೋ ಯಿಹೂದೀಯಾನ್ ಸನ್ತುಷ್ಟಾನ್ ಕರ್ತ್ತುಮ್ ಅಭಿಲಷನ್ ಪೌಲಮ್ ಅಭಾಷತ ತ್ವಂ ಕಿಂ ಯಿರೂಶಾಲಮಂ ಗತ್ವಾಸ್ಮಿನ್ ಅಭಿಯೋಗೇ ಮಮ ಸಾಕ್ಷಾದ್ ವಿಚಾರಿತೋ ಭವಿಷ್ಯಸಿ? ");
INSERT INTO sankan_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","ತತಃ ಪೌಲ ಉತ್ತರಂ ಪ್ರೋಕ್ತವಾನ್, ಯತ್ರ ಮಮ ವಿಚಾರೋ ಭವಿತುಂ ಯೋಗ್ಯಃ ಕೈಸರಸ್ಯ ತತ್ರ ವಿಚಾರಾಸನ ಏವ ಸಮುಪಸ್ಥಿತೋಸ್ಮಿ; ಅಹಂ ಯಿಹೂದೀಯಾನಾಂ ಕಾಮಪಿ ಹಾನಿಂ ನಾಕಾರ್ಷಮ್ ಇತಿ ಭವಾನ್ ಯಥಾರ್ಥತೋ ವಿಜಾನಾತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","ಕಞ್ಚಿದಪರಾಧಂ ಕಿಞ್ಚನ ವಧಾರ್ಹಂ ಕರ್ಮ್ಮ ವಾ ಯದ್ಯಹಮ್ ಅಕರಿಷ್ಯಂ ತರ್ಹಿ ಪ್ರಾಣಹನನದಣ್ಡಮಪಿ ಭೋಕ್ತುಮ್ ಉದ್ಯತೋಽಭವಿಷ್ಯಂ, ಕಿನ್ತು ತೇ ಮಮ ಸಮಪವಾದಂ ಕುರ್ವ್ವನ್ತಿ ಸ ಯದಿ ಕಲ್ಪಿತಮಾತ್ರೋ ಭವತಿ ತರ್ಹಿ ತೇಷಾಂ ಕರೇಷು ಮಾಂ ಸಮರ್ಪಯಿತುಂ ಕಸ್ಯಾಪ್ಯಧಿಕಾರೋ ನಾಸ್ತಿ, ಕೈಸರಸ್ಯ ನಿಕಟೇ ಮಮ ವಿಚಾರೋ ಭವತು| ");
INSERT INTO sankan_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","ತದಾ ಫೀಷ್ಟೋ ಮನ್ತ್ರಿಭಿಃ ಸಾರ್ದ್ಧಂ ಸಂಮನ್ತ್ರ್ಯ ಪೌಲಾಯ ಕಥಿತವಾನ್, ಕೈಸರಸ್ಯ ನಿಕಟೇ ಕಿಂ ತವ ವಿಚಾರೋ ಭವಿಷ್ಯತಿ? ಕೈಸರಸ್ಯ ಸಮೀಪಂ ಗಮಿಷ್ಯಸಿ| ");
INSERT INTO sankan_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","ಕಿಯದ್ದಿನೇಭ್ಯಃ ಪರಮ್ ಆಗ್ರಿಪ್ಪರಾಜಾ ಬರ್ಣೀಕೀ ಚ ಫೀಷ್ಟಂ ಸಾಕ್ಷಾತ್ ಕರ್ತ್ತುಂ ಕೈಸರಿಯಾನಗರಮ್ ಆಗತವನ್ತೌ| ");
INSERT INTO sankan_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","ತದಾ ತೌ ಬಹುದಿನಾನಿ ತತ್ರ ಸ್ಥಿತೌ ತತಃ ಫೀಷ್ಟಸ್ತಂ ರಾಜಾನಂ ಪೌಲಸ್ಯ ಕಥಾಂ ವಿಜ್ಞಾಪ್ಯ ಕಥಯಿತುಮ್ ಆರಭತ ಪೌಲನಾಮಾನಮ್ ಏಕಂ ಬನ್ದಿ ಫೀಲಿಕ್ಷೋ ಬದ್ಧಂ ಸಂಸ್ಥಾಪ್ಯ ಗತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","ಯಿರೂಶಾಲಮಿ ಮಮ ಸ್ಥಿತಿಕಾಲೇ ಮಹಾಯಾಜಕೋ ಯಿಹೂದೀಯಾನಾಂ ಪ್ರಾಚೀನಲೋಕಾಶ್ಚ ತಮ್ ಅಪೋದ್ಯ ತಮ್ಪ್ರತಿ ದಣ್ಡಾಜ್ಞಾಂ ಪ್ರಾರ್ಥಯನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","ತತೋಹಮ್ ಇತ್ಯುತ್ತರಮ್ ಅವದಂ ಯಾವದ್ ಅಪೋದಿತೋ ಜನಃ ಸ್ವಾಪವಾದಕಾನ್ ಸಾಕ್ಷಾತ್ ಕೃತ್ವಾ ಸ್ವಸ್ಮಿನ್ ಯೋಽಪರಾಧ ಆರೋಪಿತಸ್ತಸ್ಯ ಪ್ರತ್ಯುತ್ತರಂ ದಾತುಂ ಸುಯೋಗಂ ನ ಪ್ರಾಪ್ನೋತಿ, ತಾವತ್ಕಾಲಂ ಕಸ್ಯಾಪಿ ಮಾನುಷಸ್ಯ ಪ್ರಾಣನಾಶಾಜ್ಞಾಪನಂ ರೋಮಿಲೋಕಾನಾಂ ರೀತಿ ರ್ನಹಿ| ");
INSERT INTO sankan_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","ತತಸ್ತೇಷ್ವತ್ರಾಗತೇಷು ಪರಸ್ಮಿನ್ ದಿವಸೇಽಹಮ್ ಅವಿಲಮ್ಬಂ ವಿಚಾರಾಸನ ಉಪವಿಶ್ಯ ತಂ ಮಾನುಷಮ್ ಆನೇತುಮ್ ಆಜ್ಞಾಪಯಮ್| ");
INSERT INTO sankan_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","ತದನನ್ತರಂ ತಸ್ಯಾಪವಾದಕಾ ಉಪಸ್ಥಾಯ ಯಾದೃಶಮ್ ಅಹಂ ಚಿನ್ತಿತವಾನ್ ತಾದೃಶಂ ಕಞ್ಚನ ಮಹಾಪವಾದಂ ನೋತ್ಥಾಪ್ಯ ");
INSERT INTO sankan_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","ಸ್ವೇಷಾಂ ಮತೇ ತಥಾ ಪೌಲೋ ಯಂ ಸಜೀವಂ ವದತಿ ತಸ್ಮಿನ್ ಯೀಶುನಾಮನಿ ಮೃತಜನೇ ಚ ತಸ್ಯ ವಿರುದ್ಧಂ ಕಥಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","ತತೋಹಂ ತಾದೃಗ್ವಿಚಾರೇ ಸಂಶಯಾನಃ ಸನ್ ಕಥಿತವಾನ್ ತ್ವಂ ಯಿರೂಶಾಲಮಂ ಗತ್ವಾ ಕಿಂ ತತ್ರ ವಿಚಾರಿತೋ ಭವಿತುಮ್ ಇಚ್ಛಸಿ? ");
INSERT INTO sankan_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","ತದಾ ಪೌಲೋ ಮಹಾರಾಜಸ್ಯ ನಿಕಟೇ ವಿಚಾರಿತೋ ಭವಿತುಂ ಪ್ರಾರ್ಥಯತ, ತಸ್ಮಾದ್ ಯಾವತ್ಕಾಲಂ ತಂ ಕೈಸರಸ್ಯ ಸಮೀಪಂ ಪ್ರೇಷಯಿತುಂ ನ ಶಕ್ನೋಮಿ ತಾವತ್ಕಾಲಂ ತಮತ್ರ ಸ್ಥಾಪಯಿತುಮ್ ಆದಿಷ್ಟವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","ತತ ಆಗ್ರಿಪ್ಪಃ ಫೀಷ್ಟಮ್ ಉಕ್ತವಾನ್, ಅಹಮಪಿ ತಸ್ಯ ಮಾನುಷಸ್ಯ ಕಥಾಂ ಶ್ರೋತುಮ್ ಅಭಿಲಷಾಮಿ| ತದಾ ಫೀಷ್ಟೋ ವ್ಯಾಹರತ್ ಶ್ವಸ್ತದೀಯಾಂ ಕಥಾಂ ತ್ವಂ ಶ್ರೋಷ್ಯಸಿ| ");
INSERT INTO sankan_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","ಪರಸ್ಮಿನ್ ದಿವಸೇ ಆಗ್ರಿಪ್ಪೋ ಬರ್ಣೀಕೀ ಚ ಮಹಾಸಮಾಗಮಂ ಕೃತ್ವಾ ಪ್ರಧಾನವಾಹಿನೀಪತಿಭಿ ರ್ನಗರಸ್ಥಪ್ರಧಾನಲೋಕೈಶ್ಚ ಸಹ ಮಿಲಿತ್ವಾ ರಾಜಗೃಹಮಾಗತ್ಯ ಸಮುಪಸ್ಥಿತೌ ತದಾ ಫೀಷ್ಟಸ್ಯಾಜ್ಞಯಾ ಪೌಲ ಆನೀತೋಽಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","ತದಾ ಫೀಷ್ಟಃ ಕಥಿತವಾನ್ ಹೇ ರಾಜನ್ ಆಗ್ರಿಪ್ಪ ಹೇ ಉಪಸ್ಥಿತಾಃ ಸರ್ವ್ವೇ ಲೋಕಾ ಯಿರೂಶಾಲಮ್ನಗರೇ ಯಿಹೂದೀಯಲೋಕಸಮೂಹೋ ಯಸ್ಮಿನ್ ಮಾನುಷೇ ಮಮ ಸಮೀಪೇ ನಿವೇದನಂ ಕೃತ್ವಾ ಪ್ರೋಚ್ಚೈಃ ಕಥಾಮಿಮಾಂ ಕಥಿತವಾನ್ ಪುನರಲ್ಪಕಾಲಮಪಿ ತಸ್ಯ ಜೀವನಂ ನೋಚಿತಂ ತಮೇತಂ ಮಾನುಷಂ ಪಶ್ಯತ| ");
INSERT INTO sankan_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","ಕಿನ್ತ್ವೇಷ ಜನಃ ಪ್ರಾಣನಾಶರ್ಹಂ ಕಿಮಪಿ ಕರ್ಮ್ಮ ನ ಕೃತವಾನ್ ಇತ್ಯಜಾನಾಂ ತಥಾಪಿ ಸ ಮಹಾರಾಜಸ್ಯ ಸನ್ನಿಧೌ ವಿಚಾರಿತೋ ಭವಿತುಂ ಪ್ರಾರ್ಥಯತ ತಸ್ಮಾತ್ ತಸ್ಯ ಸಮೀಪಂ ತಂ ಪ್ರೇಷಯಿತುಂ ಮತಿಮಕರವಮ್| ");
INSERT INTO sankan_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","ಕಿನ್ತು ಶ್ರೀಯುಕ್ತಸ್ಯ ಸಮೀಪಮ್ ಏತಸ್ಮಿನ್ ಕಿಂ ಲೇಖನೀಯಮ್ ಇತ್ಯಸ್ಯ ಕಸ್ಯಚಿನ್ ನಿರ್ಣಯಸ್ಯ ನ ಜಾತತ್ವಾದ್ ಏತಸ್ಯ ವಿಚಾರೇ ಸತಿ ಯಥಾಹಂ ಲೇಖಿತುಂ ಕಿಞ್ಚನ ನಿಶ್ಚಿತಂ ಪ್ರಾಪ್ನೋಮಿ ತದರ್ಥಂ ಯುಷ್ಮಾಕಂ ಸಮಕ್ಷಂ ವಿಶೇಷತೋ ಹೇ ಆಗ್ರಿಪ್ಪರಾಜ ಭವತಃ ಸಮಕ್ಷಮ್ ಏತಮ್ ಆನಯೇ| ");
INSERT INTO sankan_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","ಯತೋ ಬನ್ದಿಪ್ರೇಷಣಸಮಯೇ ತಸ್ಯಾಭಿಯೋಗಸ್ಯ ಕಿಞ್ಚಿದಲೇಖನಮ್ ಅಹಮ್ ಅಯುಕ್ತಂ ಜಾನಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","ತತ ಆಗ್ರಿಪ್ಪಃ ಪೌಲಮ್ ಅವಾದೀತ್, ನಿಜಾಂ ಕಥಾಂ ಕಥಯಿತುಂ ತುಭ್ಯಮ್ ಅನುಮತಿ ರ್ದೀಯತೇ| ತಸ್ಮಾತ್ ಪೌಲಃ ಕರಂ ಪ್ರಸಾರ್ಯ್ಯ ಸ್ವಸ್ಮಿನ್ ಉತ್ತರಮ್ ಅವಾದೀತ್| ");
INSERT INTO sankan_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","ಹೇ ಆಗ್ರಿಪ್ಪರಾಜ ಯತ್ಕಾರಣಾದಹಂ ಯಿಹೂದೀಯೈರಪವಾದಿತೋ ಽಭವಂ ತಸ್ಯ ವೃತ್ತಾನ್ತಮ್ ಅದ್ಯ ಭವತಃ ಸಾಕ್ಷಾನ್ ನಿವೇದಯಿತುಮನುಮತೋಹಮ್ ಇದಂ ಸ್ವೀಯಂ ಪರಮಂ ಭಾಗ್ಯಂ ಮನ್ಯೇ; ");
INSERT INTO sankan_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","ಯತೋ ಯಿಹೂದೀಯಲೋಕಾನಾಂ ಮಧ್ಯೇ ಯಾ ಯಾ ರೀತಿಃ ಸೂಕ್ಷ್ಮವಿಚಾರಾಶ್ಚ ಸನ್ತಿ ತೇಷು ಭವಾನ್ ವಿಜ್ಞತಮಃ; ಅತಏವ ಪ್ರಾರ್ಥಯೇ ಧೈರ್ಯ್ಯಮವಲಮ್ಬ್ಯ ಮಮ ನಿವೇದನಂ ಶೃಣೋತು| ");
INSERT INTO sankan_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","ಅಹಂ ಯಿರೂಶಾಲಮ್ನಗರೇ ಸ್ವದೇಶೀಯಲೋಕಾನಾಂ ಮಧ್ಯೇ ತಿಷ್ಠನ್ ಆ ಯೌವನಕಾಲಾದ್ ಯದ್ರೂಪಮ್ ಆಚರಿತವಾನ್ ತದ್ ಯಿಹೂದೀಯಲೋಕಾಃ ಸರ್ವ್ವೇ ವಿದನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","ಅಸ್ಮಾಕಂ ಸರ್ವ್ವೇಭ್ಯಃ ಶುದ್ಧತಮಂ ಯತ್ ಫಿರೂಶೀಯಮತಂ ತದವಲಮ್ಬೀ ಭೂತ್ವಾಹಂ ಕಾಲಂ ಯಾಪಿತವಾನ್ ಯೇ ಜನಾ ಆ ಬಾಲ್ಯಕಾಲಾನ್ ಮಾಂ ಜಾನಾನ್ತಿ ತೇ ಏತಾದೃಶಂ ಸಾಕ್ಷ್ಯಂ ಯದಿ ದದಾತಿ ತರ್ಹಿ ದಾತುಂ ಶಕ್ನುವನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","ಕಿನ್ತು ಹೇ ಆಗ್ರಿಪ್ಪರಾಜ ಈಶ್ವರೋಽಸ್ಮಾಕಂ ಪೂರ್ವ್ವಪುರುಷಾಣಾಂ ನಿಕಟೇ ಯದ್ ಅಙ್ಗೀಕೃತವಾನ್ ತಸ್ಯ ಪ್ರತ್ಯಾಶಾಹೇತೋರಹಮ್ ಇದಾನೀಂ ವಿಚಾರಸ್ಥಾನೇ ದಣ್ಡಾಯಮಾನೋಸ್ಮಿ| ");
INSERT INTO sankan_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","ತಸ್ಯಾಙ್ಗೀಕಾರಸ್ಯ ಫಲಂ ಪ್ರಾಪ್ತುಮ್ ಅಸ್ಮಾಕಂ ದ್ವಾದಶವಂಶಾ ದಿವಾನಿಶಂ ಮಹಾಯತ್ನಾದ್ ಈಶ್ವರಸೇವನಂ ಕೃತ್ವಾ ಯಾಂ ಪ್ರತ್ಯಾಶಾಂ ಕುರ್ವ್ವನ್ತಿ ತಸ್ಯಾಃ ಪ್ರತ್ಯಾಶಾಯಾ ಹೇತೋರಹಂ ಯಿಹೂದೀಯೈರಪವಾದಿತೋಽಭವಮ್| ");
INSERT INTO sankan_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","ಈಶ್ವರೋ ಮೃತಾನ್ ಉತ್ಥಾಪಯಿಷ್ಯತೀತಿ ವಾಕ್ಯಂ ಯುಷ್ಮಾಕಂ ನಿಕಟೇಽಸಮ್ಭವಂ ಕುತೋ ಭವೇತ್? ");
INSERT INTO sankan_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","ನಾಸರತೀಯಯೀಶೋ ರ್ನಾಮ್ನೋ ವಿರುದ್ಧಂ ನಾನಾಪ್ರಕಾರಪ್ರತಿಕೂಲಾಚರಣಮ್ ಉಚಿತಮ್ ಇತ್ಯಹಂ ಮನಸಿ ಯಥಾರ್ಥಂ ವಿಜ್ಞಾಯ ");
INSERT INTO sankan_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","ಯಿರೂಶಾಲಮನಗರೇ ತದಕರವಂ ಫಲತಃ ಪ್ರಧಾನಯಾಜಕಸ್ಯ ನಿಕಟಾತ್ ಕ್ಷಮತಾಂ ಪ್ರಾಪ್ಯ ಬಹೂನ್ ಪವಿತ್ರಲೋಕಾನ್ ಕಾರಾಯಾಂ ಬದ್ಧವಾನ್ ವಿಶೇಷತಸ್ತೇಷಾಂ ಹನನಸಮಯೇ ತೇಷಾಂ ವಿರುದ್ಧಾಂ ನಿಜಾಂ ಸಮ್ಮತಿಂ ಪ್ರಕಾಶಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","ವಾರಂ ವಾರಂ ಭಜನಭವನೇಷು ತೇಭ್ಯೋ ದಣ್ಡಂ ಪ್ರದತ್ತವಾನ್ ಬಲಾತ್ ತಂ ಧರ್ಮ್ಮಂ ನಿನ್ದಯಿತವಾಂಶ್ಚ ಪುನಶ್ಚ ತಾನ್ ಪ್ರತಿ ಮಹಾಕ್ರೋಧಾದ್ ಉನ್ಮತ್ತಃ ಸನ್ ವಿದೇಶೀಯನಗರಾಣಿ ಯಾವತ್ ತಾನ್ ತಾಡಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","ಇತ್ಥಂ ಪ್ರಧಾನಯಾಜಕಸ್ಯ ಸಮೀಪಾತ್ ಶಕ್ತಿಮ್ ಆಜ್ಞಾಪತ್ರಞ್ಚ ಲಬ್ಧ್ವಾ ದಮ್ಮೇಷಕ್ನಗರಂ ಗತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","ತದಾಹಂ ಹೇ ರಾಜನ್ ಮಾರ್ಗಮಧ್ಯೇ ಮಧ್ಯಾಹ್ನಕಾಲೇ ಮಮ ಮದೀಯಸಙ್ಗಿನಾಂ ಲೋಕಾನಾಞ್ಚ ಚತಸೃಷು ದಿಕ್ಷು ಗಗಣಾತ್ ಪ್ರಕಾಶಮಾನಾಂ ಭಾಸ್ಕರತೋಪಿ ತೇಜಸ್ವತೀಂ ದೀಪ್ತಿಂ ದೃಷ್ಟವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","ತಸ್ಮಾದ್ ಅಸ್ಮಾಸು ಸರ್ವ್ವೇಷು ಭೂಮೌ ಪತಿತೇಷು ಸತ್ಸು ಹೇ ಶೌಲ ಹೈ ಶೌಲ ಕುತೋ ಮಾಂ ತಾಡಯಸಿ? ಕಣ್ಟಕಾನಾಂ ಮುಖೇ ಪಾದಾಹನನಂ ತವ ದುಃಸಾಧ್ಯಮ್ ಇಬ್ರೀಯಭಾಷಯಾ ಗದಿತ ಏತಾದೃಶ ಏಕಃ ಶಬ್ದೋ ಮಯಾ ಶ್ರುತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","ತದಾಹಂ ಪೃಷ್ಟವಾನ್ ಹೇ ಪ್ರಭೋ ಕೋ ಭವಾನ್? ತತಃ ಸ ಕಥಿತವಾನ್ ಯಂ ಯೀಶುಂ ತ್ವಂ ತಾಡಯಸಿ ಸೋಹಂ, ");
INSERT INTO sankan_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","ಕಿನ್ತು ಸಮುತ್ತಿಷ್ಠ ತ್ವಂ ಯದ್ ದೃಷ್ಟವಾನ್ ಇತಃ ಪುನಞ್ಚ ಯದ್ಯತ್ ತ್ವಾಂ ದರ್ಶಯಿಷ್ಯಾಮಿ ತೇಷಾಂ ಸರ್ವ್ವೇಷಾಂ ಕಾರ್ಯ್ಯಾಣಾಂ ತ್ವಾಂ ಸಾಕ್ಷಿಣಂ ಮಮ ಸೇವಕಞ್ಚ ಕರ್ತ್ತುಮ್ ದರ್ಶನಮ್ ಅದಾಮ್| ");
INSERT INTO sankan_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","ವಿಶೇಷತೋ ಯಿಹೂದೀಯಲೋಕೇಭ್ಯೋ ಭಿನ್ನಜಾತೀಯೇಭ್ಯಶ್ಚ ತ್ವಾಂ ಮನೋನೀತಂ ಕೃತ್ವಾ ತೇಷಾಂ ಯಥಾ ಪಾಪಮೋಚನಂ ಭವತಿ ");
INSERT INTO sankan_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ಯಥಾ ತೇ ಮಯಿ ವಿಶ್ವಸ್ಯ ಪವಿತ್ರೀಕೃತಾನಾಂ ಮಧ್ಯೇ ಭಾಗಂ ಪ್ರಾಪ್ನುವನ್ತಿ ತದಭಿಪ್ರಾಯೇಣ ತೇಷಾಂ ಜ್ಞಾನಚಕ್ಷೂಂಷಿ ಪ್ರಸನ್ನಾನಿ ಕರ್ತ್ತುಂ ತಥಾನ್ಧಕಾರಾದ್ ದೀಪ್ತಿಂ ಪ್ರತಿ ಶೈತಾನಾಧಿಕಾರಾಚ್ಚ ಈಶ್ವರಂ ಪ್ರತಿ ಮತೀಃ ಪರಾವರ್ತ್ತಯಿತುಂ ತೇಷಾಂ ಸಮೀಪಂ ತ್ವಾಂ ಪ್ರೇಷ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","ಹೇ ಆಗ್ರಿಪ್ಪರಾಜ ಏತಾದೃಶಂ ಸ್ವರ್ಗೀಯಪ್ರತ್ಯಾದೇಶಂ ಅಗ್ರಾಹ್ಯಮ್ ಅಕೃತ್ವಾಹಂ ");
INSERT INTO sankan_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","ಪ್ರಥಮತೋ ದಮ್ಮೇಷಕ್ನಗರೇ ತತೋ ಯಿರೂಶಾಲಮಿ ಸರ್ವ್ವಸ್ಮಿನ್ ಯಿಹೂದೀಯದೇಶೇ ಅನ್ಯೇಷು ದೇಶೇಷು ಚ ಯೇेನ ಲೋಕಾ ಮತಿಂ ಪರಾವರ್ತ್ತ್ಯ ಈಶ್ವರಂ ಪ್ರತಿ ಪರಾವರ್ತ್ತಯನ್ತೇ, ಮನಃಪರಾವರ್ತ್ತನಯೋಗ್ಯಾನಿ ಕರ್ಮ್ಮಾಣಿ ಚ ಕುರ್ವ್ವನ್ತಿ ತಾದೃಶಮ್ ಉಪದೇಶಂ ಪ್ರಚಾರಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","ಏತತ್ಕಾರಣಾದ್ ಯಿಹೂದೀಯಾ ಮಧ್ಯೇಮನ್ದಿರಂ ಮಾಂ ಧೃತ್ವಾ ಹನ್ತುಮ್ ಉದ್ಯತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","ತಥಾಪಿ ಖ್ರೀಷ್ಟೋ ದುಃಖಂ ಭುಕ್ತ್ವಾ ಸರ್ವ್ವೇಷಾಂ ಪೂರ್ವ್ವಂ ಶ್ಮಶಾನಾದ್ ಉತ್ಥಾಯ ನಿಜದೇಶೀಯಾನಾಂ ಭಿನ್ನದೇಶೀಯಾನಾಞ್ಚ ಸಮೀಪೇ ದೀಪ್ತಿಂ ಪ್ರಕಾಶಯಿಷ್ಯತಿ ");
INSERT INTO sankan_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","ಭವಿಷ್ಯದ್ವಾದಿಗಣೋ ಮೂಸಾಶ್ಚ ಭಾವಿಕಾರ್ಯ್ಯಸ್ಯ ಯದಿದಂ ಪ್ರಮಾಣಮ್ ಅದದುರೇತದ್ ವಿನಾನ್ಯಾಂ ಕಥಾಂ ನ ಕಥಯಿತ್ವಾ ಈಶ್ವರಾದ್ ಅನುಗ್ರಹಂ ಲಬ್ಧ್ವಾ ಮಹತಾಂ ಕ್ಷುದ್ರಾಣಾಞ್ಚ ಸರ್ವ್ವೇಷಾಂ ಸಮೀಪೇ ಪ್ರಮಾಣಂ ದತ್ತ್ವಾದ್ಯ ಯಾವತ್ ತಿಷ್ಠಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","ತಸ್ಯಮಾಂ ಕಥಾಂ ನಿಶಮ್ಯ ಫೀಷ್ಟ ಉಚ್ಚೈಃ ಸ್ವರೇಣ ಕಥಿತವಾನ್ ಹೇ ಪೌಲ ತ್ವಮ್ ಉನ್ಮತ್ತೋಸಿ ಬಹುವಿದ್ಯಾಭ್ಯಾಸೇನ ತ್ವಂ ಹತಜ್ಞಾನೋ ಜಾತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","ಸ ಉಕ್ತವಾನ್ ಹೇ ಮಹಾಮಹಿಮ ಫೀಷ್ಟ ನಾಹಮ್ ಉನ್ಮತ್ತಃ ಕಿನ್ತು ಸತ್ಯಂ ವಿವೇಚನೀಯಞ್ಚ ವಾಕ್ಯಂ ಪ್ರಸ್ತೌಮಿ| ");
INSERT INTO sankan_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","ಯಸ್ಯ ಸಾಕ್ಷಾದ್ ಅಕ್ಷೋಭಃ ಸನ್ ಕಥಾಂ ಕಥಯಾಮಿ ಸ ರಾಜಾ ತದ್ವೃತ್ತಾನ್ತಂ ಜಾನಾತಿ ತಸ್ಯ ಸಮೀಪೇ ಕಿಮಪಿ ಗುಪ್ತಂ ನೇತಿ ಮಯಾ ನಿಶ್ಚಿತಂ ಬುಧ್ಯತೇ ಯತಸ್ತದ್ ವಿಜನೇ ನ ಕೃತಂ| ");
INSERT INTO sankan_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","ಹೇ ಆಗ್ರಿಪ್ಪರಾಜ ಭವಾನ್ ಕಿಂ ಭವಿಷ್ಯದ್ವಾದಿಗಣೋಕ್ತಾನಿ ವಾಕ್ಯಾನಿ ಪ್ರತ್ಯೇತಿ? ಭವಾನ್ ಪ್ರತ್ಯೇತಿ ತದಹಂ ಜಾನಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","ತತ ಆಗ್ರಿಪ್ಪಃ ಪೌಲಮ್ ಅಭಿಹಿತವಾನ್ ತ್ವಂ ಪ್ರವೃತ್ತಿಂ ಜನಯಿತ್ವಾ ಪ್ರಾಯೇಣ ಮಾಮಪಿ ಖ್ರೀಷ್ಟೀಯಂ ಕರೋಷಿ| ");
INSERT INTO sankan_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","ತತಃ ಸೋಽವಾದೀತ್ ಭವಾನ್ ಯೇ ಯೇ ಲೋಕಾಶ್ಚ ಮಮ ಕಥಾಮ್ ಅದ್ಯ ಶೃಣ್ವನ್ತಿ ಪ್ರಾಯೇಣ ಇತಿ ನಹಿ ಕಿನ್ತ್ವೇತತ್ ಶೃಙ್ಖಲಬನ್ಧನಂ ವಿನಾ ಸರ್ವ್ವಥಾ ತೇ ಸರ್ವ್ವೇ ಮಾದೃಶಾ ಭವನ್ತ್ವಿತೀಶ್ವಸ್ಯ ಸಮೀಪೇ ಪ್ರಾರ್ಥಯೇಽಹಮ್| ");
INSERT INTO sankan_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","ಏತಸ್ಯಾಂ ಕಥಾಯಾಂ ಕಥಿತಾಯಾಂ ಸ ರಾಜಾ ಸೋಽಧಿಪತಿ ರ್ಬರ್ಣೀಕೀ ಸಭಾಸ್ಥಾ ಲೋಕಾಶ್ಚ ತಸ್ಮಾದ್ ಉತ್ಥಾಯ ");
INSERT INTO sankan_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ಗೋಪನೇ ಪರಸ್ಪರಂ ವಿವಿಚ್ಯ ಕಥಿತವನ್ತ ಏಷ ಜನೋ ಬನ್ಧನಾರ್ಹಂ ಪ್ರಾಣಹನನಾರ್ಹಂ ವಾ ಕಿಮಪಿ ಕರ್ಮ್ಮ ನಾಕರೋತ್| ");
INSERT INTO sankan_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","ತತ ಆಗ್ರಿಪ್ಪಃ ಫೀಷ್ಟಮ್ ಅವದತ್, ಯದ್ಯೇಷ ಮಾನುಷಃ ಕೈಸರಸ್ಯ ನಿಕಟೇ ವಿಚಾರಿತೋ ಭವಿತುಂ ನ ಪ್ರಾರ್ಥಯಿಷ್ಯತ್ ತರ್ಹಿ ಮುಕ್ತೋ ಭವಿತುಮ್ ಅಶಕ್ಷ್ಯತ್| ");
INSERT INTO sankan_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","ಜಲಪಥೇನಾಸ್ಮಾಕಮ್ ಇತೋಲಿಯಾದೇಶಂ ಪ್ರತಿ ಯಾತ್ರಾಯಾಂ ನಿಶ್ಚಿತಾಯಾಂ ಸತ್ಯಾಂ ತೇ ಯೂಲಿಯನಾಮ್ನೋ ಮಹಾರಾಜಸ್ಯ ಸಂಘಾತಾನ್ತರ್ಗತಸ್ಯ ಸೇನಾಪತೇಃ ಸಮೀಪೇ ಪೌಲಂ ತದನ್ಯಾನ್ ಕತಿನಯಜನಾಂಶ್ಚ ಸಮಾರ್ಪಯನ್| ");
INSERT INTO sankan_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","ವಯಮ್ ಆದ್ರಾಮುತ್ತೀಯಂ ಪೋತಮೇಕಮ್ ಆರುಹ್ಯ ಆಶಿಯಾದೇಶಸ್ಯ ತಟಸಮೀಪೇನ ಯಾತುಂ ಮತಿಂ ಕೃತ್ವಾ ಲಙ್ಗರಮ್ ಉತ್ಥಾಪ್ಯ ಪೋತಮ್ ಅಮೋಚಯಾಮ; ಮಾಕಿದನಿಯಾದೇಶಸ್ಥಥಿಷಲನೀಕೀನಿವಾಸ್ಯಾರಿಸ್ತಾರ್ಖನಾಮಾ ಕಶ್ಚಿದ್ ಜನೋಽಸ್ಮಾಭಿಃ ಸಾರ್ದ್ಧಮ್ ಆಸೀತ್| ");
INSERT INTO sankan_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","ಪರಸ್ಮಿನ್ ದಿವಸೇ ಽಸ್ಮಾಭಿಃ ಸೀದೋನ್ನಗರೇ ಪೋತೇ ಲಾಗಿತೇ ತತ್ರ ಯೂಲಿಯಃ ಸೇನಾಪತಿಃ ಪೌಲಂ ಪ್ರತಿ ಸೌಜನ್ಯಂ ಪ್ರದರ್ಥ್ಯ ಸಾನ್ತ್ವನಾರ್ಥಂ ಬನ್ಧುಬಾನ್ಧವಾನ್ ಉಪಯಾತುಮ್ ಅನುಜಜ್ಞೌ| ");
INSERT INTO sankan_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","ತಸ್ಮಾತ್ ಪೋತೇ ಮೋಚಿತೇ ಸತಿ ಸಮ್ಮುಖವಾಯೋಃ ಸಮ್ಭವಾದ್ ವಯಂ ಕುಪ್ರೋಪದ್ವೀಪಸ್ಯ ತೀರಸಮೀಪೇನ ಗತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","ಕಿಲಿಕಿಯಾಯಾಃ ಪಾಮ್ಫೂಲಿಯಾಯಾಶ್ಚ ಸಮುದ್ರಸ್ಯ ಪಾರಂ ಗತ್ವಾ ಲೂಕಿಯಾದೇಶಾನ್ತರ್ಗತಂ ಮುರಾನಗರಮ್ ಉಪಾತಿಷ್ಠಾಮ| ");
INSERT INTO sankan_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","ತತ್ಸ್ಥಾನಾದ್ ಇತಾಲಿಯಾದೇಶಂ ಗಚ್ಛತಿ ಯಃ ಸಿಕನ್ದರಿಯಾನಗರಸ್ಯ ಪೋತಸ್ತಂ ತತ್ರ ಪ್ರಾಪ್ಯ ಶತಸೇನಾಪತಿಸ್ತಂ ಪೋತಮ್ ಅಸ್ಮಾನ್ ಆರೋಹಯತ್| ");
INSERT INTO sankan_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","ತತಃ ಪರಂ ಬಹೂನಿ ದಿನಾನಿ ಶನೈಃ ಶನೈಃ ರ್ಗತ್ವಾ ಕ್ನೀದಪಾರ್ಶ್ವೋಪಸ್ಥ್ತಿेಃ ಪೂರ್ವ್ವಂ ಪ್ರತಿಕೂಲೇನ ಪವನೇನ ವಯಂ ಸಲ್ಮೋನ್ಯಾಃ ಸಮ್ಮುಖಮ್ ಉಪಸ್ಥಾಯ ಕ್ರೀತ್ಯುಪದ್ವೀಪಸ್ಯ ತೀರಸಮೀಪೇನ ಗತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","ಕಷ್ಟೇನ ತಮುತ್ತೀರ್ಯ್ಯ ಲಾಸೇಯಾನಗರಸ್ಯಾಧಃ ಸುನ್ದರನಾಮಕಂ ಖಾತಮ್ ಉಪಾತಿಷ್ಠಾಮ| ");
INSERT INTO sankan_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","ಇತ್ಥಂ ಬಹುತಿಥಃ ಕಾಲೋ ಯಾಪಿತ ಉಪವಾಸದಿನಞ್ಚಾತೀತಂ, ತತ್ಕಾರಣಾತ್ ನೌವರ್ತ್ಮನಿ ಭಯಙ್ಕರೇ ಸತಿ ಪೌಲೋ ವಿನಯೇನ ಕಥಿತವಾನ್, ");
INSERT INTO sankan_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","ಹೇ ಮಹೇಚ್ಛಾ ಅಹಂ ನಿಶ್ಚಯಂ ಜಾನಾಮಿ ಯಾತ್ರಾಯಾಮಸ್ಯಾಮ್ ಅಸ್ಮಾಕಂ ಕ್ಲೇಶಾ ಬಹೂನಾಮಪಚಯಾಶ್ಚ ಭವಿಷ್ಯನ್ತಿ, ತೇ ಕೇವಲಂ ಪೋತಸಾಮಗ್ರ್ಯೋರಿತಿ ನಹಿ, ಕಿನ್ತ್ವಸ್ಮಾಕಂ ಪ್ರಾಣಾನಾಮಪಿ| ");
INSERT INTO sankan_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","ತದಾ ಶತಸೇನಾಪತಿಃ ಪೌैेಲೋಕ್ತವಾಕ್ಯತೋಪಿ ಕರ್ಣಧಾರಸ್ಯ ಪೋತವಣಿಜಶ್ಚ ವಾಕ್ಯಂ ಬಹುಮಂಸ್ತ| ");
INSERT INTO sankan_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","ತತ್ ಖಾತಂ ಶೀತಕಾಲೇ ವಾಸಾರ್ಹಸ್ಥಾನಂ ನ ತಸ್ಮಾದ್ ಅವಾಚೀಪ್ರತೀಚೋರ್ದಿಶೋಃ ಕ್ರೀತ್ಯಾಃ ಫೈನೀಕಿಯಖಾತಂ ಯಾತುಂ ಯದಿ ಶಕ್ನುವನ್ತಸ್ತರ್ಹಿ ತತ್ರ ಶೀತಕಾಲಂ ಯಾಪಯಿತುಂ ಪ್ರಾಯೇಣ ಸರ್ವ್ವೇ ಮನ್ತ್ರಯಾಮಾಸುಃ| ");
INSERT INTO sankan_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","ತತಃ ಪರಂ ದಕ್ಷಿಣವಾಯು ರ್ಮನ್ದಂ ವಹತೀತಿ ವಿಲೋಕ್ಯ ನಿಜಾಭಿಪ್ರಾಯಸ್ಯ ಸಿದ್ಧೇಃ ಸುಯೋಗೋ ಭವತೀತಿ ಬುದ್ಧ್ವಾ ಪೋತಂ ಮೋಚಯಿತ್ವಾ ಕ್ರೀತ್ಯುಪದ್ವೀಪಸ್ಯ ತೀರಸಮೀಪೇನ ಚಲಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","ಕಿನ್ತ್ವಲ್ಪಕ್ಷಣಾತ್ ಪರಮೇವ ಉರಕ್ಲುದೋನ್ನಾಮಾ ಪ್ರತಿಕೂಲಃ ಪ್ರಚಣ್ಡೋ ವಾಯು ರ್ವಹನ್ ಪೋತೇಽಲಗೀತ್ ");
INSERT INTO sankan_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","ತಸ್ಯಾಭಿಮುಖಂ ಗನ್ತುಮ್ ಪೋತಸ್ಯಾಶಕ್ತತ್ವಾದ್ ವಯಂ ವಾಯುನಾ ಸ್ವಯಂ ನೀತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","ಅನನ್ತರಂ ಕ್ಲೌದೀನಾಮ್ನ ಉಪದ್ವೀಪಸ್ಯ ಕೂಲಸಮೀಪೇನ ಪೋತಂ ಗಮಯಿತ್ವಾ ಬಹುನಾ ಕಷ್ಟೇನ ಕ್ಷುದ್ರನಾವಮ್ ಅರಕ್ಷಾಮ| ");
INSERT INTO sankan_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","ತೇ ತಾಮಾರುಹ್ಯ ರಜ್ಜ್ಚಾ ಪೋತಸ್ಯಾಧೋಭಾಗಮ್ ಅಬಧ್ನನ್ ತದನನ್ತರಂ ಚೇತ್ ಪೋತೋ ಸೈಕತೇ ಲಗತೀತಿ ಭಯಾದ್ ವಾತವಸನಾನ್ಯಮೋಚಯನ್ ತತಃ ಪೋತೋ ವಾಯುನಾ ಚಾಲಿತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","ಕಿನ್ತು ಕ್ರಮಶೋ ವಾಯೋಃ ಪ್ರಬಲತ್ವಾತ್ ಪೋತೋ ದೋಲಾಯಮಾನೋಽಭವತ್ ಪರಸ್ಮಿನ್ ದಿವಸೇ ಪೋತಸ್ಥಾನಿ ಕತಿಪಯಾನಿ ದ್ರವ್ಯಾಣಿ ತೋಯೇ ನಿಕ್ಷಿಪ್ತಾನಿ| ");
INSERT INTO sankan_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","ತೃತೀಯದಿವಸೇ ವಯಂ ಸ್ವಹಸ್ತೈಃ ಪೋತಸಜ್ಜನದ್ರವ್ಯಾಣಿ ನಿಕ್ಷಿಪ್ತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","ತತೋ ಬಹುದಿನಾನಿ ಯಾವತ್ ಸೂರ್ಯ್ಯನಕ್ಷತ್ರಾದೀನಿ ಸಮಾಚ್ಛನ್ನಾನಿ ತತೋ ಽತೀವ ವಾತ್ಯಾಗಮಾದ್ ಅಸ್ಮಾಕಂ ಪ್ರಾಣರಕ್ಷಾಯಾಃ ಕಾಪಿ ಪ್ರತ್ಯಾಶಾ ನಾತಿಷ್ಠತ್| ");
INSERT INTO sankan_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","ಬಹುದಿನೇಷು ಲೋಕೈರನಾಹಾರೇಣ ಯಾಪಿತೇಷು ಸರ್ವ್ವೇಷಾಂ ಸಾಕ್ಷತ್ ಪೌಲಸ್ತಿಷ್ಠನ್ ಅಕಥಯತ್, ಹೇ ಮಹೇಚ್ಛಾಃ ಕ್ರೀತ್ಯುಪದ್ವೀಪಾತ್ ಪೋತಂ ನ ಮೋಚಯಿತುಮ್ ಅಹಂ ಪೂರ್ವ್ವಂ ಯದ್ ಅವದಂ ತದ್ಗ್ರಹಣಂ ಯುಷ್ಮಾಕಮ್ ಉಚಿತಮ್ ಆಸೀತ್ ತಥಾ ಕೃತೇ ಯುಷ್ಮಾಕಮ್ ಏಷಾ ವಿಪದ್ ಏಷೋಽಪಚಯಶ್ಚ ನಾಘಟಿಷ್ಯೇತಾಮ್| ");
INSERT INTO sankan_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","ಕಿನ್ತು ಸಾಮ್ಪ್ರತಂ ಯುಷ್ಮಾನ್ ವಿನೀಯ ಬ್ರವೀಮ್ಯಹಂ, ಯೂಯಂ ನ ಕ್ಷುಭ್ಯತ ಯುಷ್ಮಾಕಮ್ ಏಕಸ್ಯಾಪಿ ಪ್ರಾಣಿನೋ ಹಾನಿ ರ್ನ ಭವಿಷ್ಯತಿ, ಕೇವಲಸ್ಯ ಪೋತಸ್ಯ ಹಾನಿ ರ್ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","ಯತೋ ಯಸ್ಯೇಶ್ವರಸ್ಯ ಲೋಕೋಽಹಂ ಯಞ್ಚಾಹಂ ಪರಿಚರಾಮಿ ತದೀಯ ಏಕೋ ದೂತೋ ಹ್ಯೋ ರಾತ್ರೌ ಮಮಾನ್ತಿಕೇ ತಿಷ್ಠನ್ ಕಥಿತವಾನ್, ");
INSERT INTO sankan_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ಹೇ ಪೌಲ ಮಾ ಭೈಷೀಃ ಕೈಸರಸ್ಯ ಸಮ್ಮುಖೇ ತ್ವಯೋಪಸ್ಥಾತವ್ಯಂ; ತವೈತಾನ್ ಸಙ್ಗಿನೋ ಲೋಕಾನ್ ಈಶ್ವರಸ್ತುಭ್ಯಂ ದತ್ತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","ಅತಏವ ಹೇ ಮಹೇಚ್ಛಾ ಯೂಯಂ ಸ್ಥಿರಮನಸೋ ಭವತ ಮಹ್ಯಂ ಯಾ ಕಥಾಕಥಿ ಸಾವಶ್ಯಂ ಘಟಿಷ್ಯತೇ ಮಮೈತಾದೃಶೀ ವಿಶ್ವಾಸ ಈಶ್ವರೇ ವಿದ್ಯತೇ, ");
INSERT INTO sankan_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","ಕಿನ್ತು ಕಸ್ಯಚಿದ್ ಉಪದ್ವೀಪಸ್ಯೋಪರಿ ಪತಿತವ್ಯಮ್ ಅಸ್ಮಾಭಿಃ| ");
INSERT INTO sankan_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","ತತಃ ಪರಮ್ ಆದ್ರಿಯಾಸಮುದ್ರೇ ಪೋತಸ್ತಥೈವ ದೋಲಾಯಮಾನಃ ಸನ್ ಇತಸ್ತತೋ ಗಚ್ಛನ್ ಚತುರ್ದಶದಿವಸಸ್ಯ ರಾತ್ರೇ ರ್ದ್ವಿತೀಯಪ್ರಹರಸಮಯೇ ಕಸ್ಯಚಿತ್ ಸ್ಥಲಸ್ಯ ಸಮೀಪಮುಪತಿಷ್ಠತೀತಿ ಪೋತೀಯಲೋಕಾ ಅನ್ವಮನ್ಯನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","ತತಸ್ತೇ ಜಲಂ ಪರಿಮಾಯ ತತ್ರ ವಿಂಶತಿ ರ್ವ್ಯಾಮಾ ಜಲಾನೀತಿ ಜ್ಞಾತವನ್ತಃ| ಕಿಞ್ಚಿದ್ದೂರಂ ಗತ್ವಾ ಪುನರಪಿ ಜಲಂ ಪರಿಮಿತವನ್ತಃ| ತತ್ರ ಪಞ್ಚದಶ ವ್ಯಾಮಾ ಜಲಾನಿ ದೃಷ್ಟ್ವಾ ");
INSERT INTO sankan_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","ಚೇತ್ ಪಾಷಾಣೇ ಲಗತೀತಿ ಭಯಾತ್ ಪೋತಸ್ಯ ಪಶ್ಚಾದ್ಭಾಗತಶ್ಚತುರೋ ಲಙ್ಗರಾನ್ ನಿಕ್ಷಿಪ್ಯ ದಿವಾಕರಮ್ ಅಪೇಕ್ಷ್ಯ ಸರ್ವ್ವೇ ಸ್ಥಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","ಕಿನ್ತು ಪೋತೀಯಲೋಕಾಃ ಪೋತಾಗ್ರಭಾಗೇ ಲಙ್ಗರನಿಕ್ಷೇಪಂ ಛಲಂ ಕೃತ್ವಾ ಜಲಧೌ ಕ್ಷುದ್ರನಾವಮ್ ಅವರೋಹ್ಯ ಪಲಾಯಿತುಮ್ ಅಚೇಷ್ಟನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","ತತಃ ಪೌಲಃ ಸೇನಾಪತಯೇ ಸೈನ್ಯಗಣಾಯ ಚ ಕಥಿತವಾನ್, ಏತೇ ಯದಿ ಪೋತಮಧ್ಯೇ ನ ತಿಷ್ಠನ್ತಿ ತರ್ಹಿ ಯುಷ್ಮಾಕಂ ರಕ್ಷಣಂ ನ ಶಕ್ಯಂ| ");
INSERT INTO sankan_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","ತದಾ ಸೇನಾಗಣೋ ರಜ್ಜೂನ್ ಛಿತ್ವಾ ನಾವಂ ಜಲೇ ಪತಿತುಮ್ ಅದದಾತ್| ");
INSERT INTO sankan_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","ಪ್ರಭಾತಸಮಯೇ ಪೌಲಃ ಸರ್ವ್ವಾನ್ ಜನಾನ್ ಭೋಜನಾರ್ಥಂ ಪ್ರಾರ್ಥ್ಯ ವ್ಯಾಹರತ್, ಅದ್ಯ ಚತುರ್ದಶದಿನಾನಿ ಯಾವದ್ ಯೂಯಮ್ ಅಪೇಕ್ಷಮಾನಾ ಅನಾಹಾರಾಃ ಕಾಲಮ್ ಅಯಾಪಯತ ಕಿಮಪಿ ನಾಭುಂಗ್ಧಂ| ");
INSERT INTO sankan_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","ಅತೋ ವಿನಯೇेಽಹಂ ಭಕ್ಷ್ಯಂ ಭುಜ್ಯತಾಂ ತತೋ ಯುಷ್ಮಾಕಂ ಮಙ್ಗಲಂ ಭವಿಷ್ಯತಿ, ಯುಷ್ಮಾಕಂ ಕಸ್ಯಚಿಜ್ಜನಸ್ಯ ಶಿರಸಃ ಕೇಶೈಕೋಪಿ ನ ನಂಕ್ಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","ಇತಿ ವ್ಯಾಹೃತ್ಯ ಪೌಲಂ ಪೂಪಂ ಗೃಹೀತ್ವೇಶ್ವರಂ ಧನ್ಯಂ ಭಾಷಮಾಣಸ್ತಂ ಭಂಕ್ತ್ವಾ ಭೋಕ್ತುಮ್ ಆರಬ್ಧವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","ಅನನ್ತರಂ ಸರ್ವ್ವೇ ಚ ಸುಸ್ಥಿರಾಃ ಸನ್ತಃ ಖಾದ್ಯಾನಿ ಪರ್ಪ್ಯಗೃಹ್ಲನ್| ");
INSERT INTO sankan_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","ಅಸ್ಮಾಕಂ ಪೋತೇ ಷಟ್ಸಪ್ತತ್ಯಧಿಕಶತದ್ವಯಲೋಕಾ ಆಸನ್| ");
INSERT INTO sankan_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","ಸರ್ವ್ವೇಷು ಲೋಕೇಷು ಯಥೇಷ್ಟಂ ಭುಕ್ತವತ್ಸು ಪೋತಸ್ಥನ್ ಗೋಧೂಮಾನ್ ಜಲಧೌ ನಿಕ್ಷಿಪ್ಯ ತೈಃ ಪೋತಸ್ಯ ಭಾರೋ ಲಘೂಕೃತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","ದಿನೇ ಜಾತೇಽಪಿ ಸ ಕೋ ದೇಶ ಇತಿ ತದಾ ನ ಪರ್ಯ್ಯಚೀಯತ; ಕಿನ್ತು ತತ್ರ ಸಮತಟಮ್ ಏಕಂ ಖಾತಂ ದೃಷ್ಟ್ವಾ ಯದಿ ಶಕ್ನುಮಸ್ತರ್ಹಿ ವಯಂ ತಸ್ಯಾಭ್ಯನ್ತರಂ ಪೋತಂ ಗಮಯಾಮ ಇತಿ ಮತಿಂ ಕೃತ್ವಾ ತೇ ಲಙ್ಗರಾನ್ ಛಿತ್ತ್ವಾ ಜಲಧೌ ತ್ಯಕ್ತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","ತಥಾ ಕರ್ಣಬನ್ಧನಂ ಮೋಚಯಿತ್ವಾ ಪ್ರಧಾನಂ ವಾತವಸನಮ್ ಉತ್ತೋಲ್ಯ ತೀರಸಮೀಪಂ ಗತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","ಕಿನ್ತು ದ್ವಯೋಃ ಸಮುದ್ರಯೋಃ ಸಙ್ಗಮಸ್ಥಾನೇ ಸೈಕತೋಪರಿ ಪೋತೇ ನಿಕ್ಷಿಪ್ತೇ ಽಗ್ರಭಾಗೇ ಬಾಧಿತೇ ಪಶ್ಚಾದ್ಭಾಗೇ ಪ್ರಬಲತರಙ್ಗೋಽಲಗತ್ ತೇನ ಪೋತೋ ಭಗ್ನಃ| ");
INSERT INTO sankan_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","ತಸ್ಮಾದ್ ಬನ್ದಯಶ್ಚೇದ್ ಬಾಹುಭಿಸ್ತರನ್ತಃ ಪಲಾಯನ್ತೇ ಇತ್ಯಾಶಙ್ಕಯಾ ಸೇನಾಗಣಸ್ತಾನ್ ಹನ್ತುಮ್ ಅಮನ್ತ್ರಯತ್; ");
INSERT INTO sankan_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","ಕಿನ್ತು ಶತಸೇನಾಪತಿಃ ಪೌಲಂ ರಕ್ಷಿತುಂ ಪ್ರಯತ್ನಂ ಕೃತ್ವಾ ತಾನ್ ತಚ್ಚೇಷ್ಟಾಯಾ ನಿವರ್ತ್ಯ ಇತ್ಯಾದಿಷ್ಟವಾನ್, ಯೇ ಬಾಹುತರಣಂ ಜಾನನ್ತಿ ತೇಽಗ್ರೇ ಪ್ರೋಲ್ಲಮ್ಪ್ಯ ಸಮುದ್ರೇ ಪತಿತ್ವಾ ಬಾಹುಭಿಸ್ತೀರ್ತ್ತ್ವಾ ಕೂಲಂ ಯಾನ್ತು| ");
INSERT INTO sankan_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","ಅಪರಮ್ ಅವಶಿಷ್ಟಾ ಜನಾಃ ಕಾಷ್ಠಂ ಪೋತೀಯಂ ದ್ರವ್ಯಂ ವಾ ಯೇನ ಯತ್ ಪ್ರಾಪ್ಯತೇ ತದವಲಮ್ಬ್ಯ ಯಾನ್ತು; ಇತ್ಥಂ ಸರ್ವ್ವೇ ಭೂಮಿಂ ಪ್ರಾಪ್ಯ ಪ್ರಾಣೈ ರ್ಜೀವಿತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","ಇತ್ಥಂ ಸರ್ವ್ವೇಷು ರಕ್ಷಾಂ ಪ್ರಾಪ್ತೇಷು ತತ್ರತ್ಯೋಪದ್ವೀಪಸ್ಯ ನಾಮ ಮಿಲೀತೇತಿ ತೇ ಜ್ಞಾತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","ಅಸಭ್ಯಲೋಕಾ ಯಥೇಷ್ಟಮ್ ಅನುಕಮ್ಪಾಂ ಕೃತ್ವಾ ವರ್ತ್ತಮಾನವೃಷ್ಟೇಃ ಶೀತಾಚ್ಚ ವಹ್ನಿಂ ಪ್ರಜ್ಜ್ವಾಲ್ಯಾಸ್ಮಾಕಮ್ ಆತಿಥ್ಯಮ್ ಅಕುರ್ವ್ವನ್| ");
INSERT INTO sankan_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","ಕಿನ್ತು ಪೌಲ ಇನ್ಧನಾನಿ ಸಂಗೃಹ್ಯ ಯದಾ ತಸ್ಮಿನ್ ಅಗ್ರೌ ನಿರಕ್ಷಿಪತ್, ತದಾ ವಹ್ನೇಃ ಪ್ರತಾಪಾತ್ ಏಕಃ ಕೃಷ್ಣಸರ್ಪೋ ನಿರ್ಗತ್ಯ ತಸ್ಯ ಹಸ್ತೇ ದ್ರಷ್ಟವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","ತೇಽಸಭ್ಯಲೋಕಾಸ್ತಸ್ಯ ಹಸ್ತೇ ಸರ್ಪಮ್ ಅವಲಮ್ಬಮಾನಂ ದೃಷ್ಟ್ವಾ ಪರಸ್ಪರಮ್ ಉಕ್ತವನ್ತ ಏಷ ಜನೋಽವಶ್ಯಂ ನರಹಾ ಭವಿಷ್ಯತಿ, ಯತೋ ಯದ್ಯಪಿ ಜಲಧೇ ರಕ್ಷಾಂ ಪ್ರಾಪ್ತವಾನ್ ತಥಾಪಿ ಪ್ರತಿಫಲದಾಯಕ ಏನಂ ಜೀವಿತುಂ ನ ದದಾತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","ಕಿನ್ತು ಸ ಹಸ್ತಂ ವಿಧುನ್ವನ್ ತಂ ಸರ್ಪಮ್ ಅಗ್ನಿಮಧ್ಯೇ ನಿಕ್ಷಿಪ್ಯ ಕಾಮಪಿ ಪೀಡಾಂ ನಾಪ್ತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","ತತೋ ವಿಷಜ್ವಾಲಯಾ ಏತಸ್ಯ ಶರೀರಂ ಸ್ಫೀತಂ ಭವಿಷ್ಯತಿ ಯದ್ವಾ ಹಠಾದಯಂ ಪ್ರಾಣಾನ್ ತ್ಯಕ್ಷ್ಯತೀತಿ ನಿಶ್ಚಿತ್ಯ ಲೋಕಾ ಬಹುಕ್ಷಣಾನಿ ಯಾವತ್ ತದ್ ದ್ರಷ್ಟುಂ ಸ್ಥಿತವನ್ತಃ ಕಿನ್ತು ತಸ್ಯ ಕಸ್ಯಾಶ್ಚಿದ್ ವಿಪದೋಽಘಟನಾತ್ ತೇ ತದ್ವಿಪರೀತಂ ವಿಜ್ಞಾಯ ಭಾಷಿತವನ್ತ ಏಷ ಕಶ್ಚಿದ್ ದೇವೋ ಭವೇತ್| ");
INSERT INTO sankan_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","ಪುಬ್ಲಿಯನಾಮಾ ಜನ ಏಕಸ್ತಸ್ಯೋಪದ್ವೀಪಸ್ಯಾಧಿಪತಿರಾಸೀತ್ ತತ್ರ ತಸ್ಯ ಭೂಮ್ಯಾದಿ ಚ ಸ್ಥಿತಂ| ಸ ಜನೋಽಸ್ಮಾನ್ ನಿಜಗೃಹಂ ನೀತ್ವಾ ಸೌಜನ್ಯಂ ಪ್ರಕಾಶ್ಯ ದಿನತ್ರಯಂ ಯಾವದ್ ಅಸ್ಮಾಕಂ ಆತಿಥ್ಯಮ್ ಅಕರೋತ್| ");
INSERT INTO sankan_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","ತದಾ ತಸ್ಯ ಪುಬ್ಲಿಯಸ್ಯ ಪಿತಾ ಜ್ವರಾತಿಸಾರೇಣ ಪೀಡ್ಯಮಾನಃ ಸನ್ ಶಯ್ಯಾಯಾಮ್ ಆಸೀತ್; ತತಃ ಪೌಲಸ್ತಸ್ಯ ಸಮೀಪಂ ಗತ್ವಾ ಪ್ರಾರ್ಥನಾಂ ಕೃತ್ವಾ ತಸ್ಯ ಗಾತ್ರೇ ಹಸ್ತಂ ಸಮರ್ಪ್ಯ ತಂ ಸ್ವಸ್ಥಂ ಕೃತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","ಇತ್ಥಂ ಭೂತೇ ತದ್ವೀಪನಿವಾಸಿನ ಇತರೇಪಿ ರೋಗಿಲೋಕಾ ಆಗತ್ಯ ನಿರಾಮಯಾ ಅಭವನ್| ");
INSERT INTO sankan_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","ತಸ್ಮಾತ್ತೇಽಸ್ಮಾಕಮ್ ಅತೀವ ಸತ್ಕಾರಂ ಕೃತವನ್ತಃ, ವಿಶೇಷತಃ ಪ್ರಸ್ಥಾನಸಮಯೇ ಪ್ರಯೋಜನೀಯಾನಿ ನಾನದ್ರವ್ಯಾಣಿ ದತ್ತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","ಇತ್ಥಂ ತತ್ರ ತ್ರಿಷು ಮಾಸೇಷು ಗತೇಷು ಯಸ್ಯ ಚಿಹ್ನಂ ದಿಯಸ್ಕೂರೀ ತಾದೃಶ ಏಕಃ ಸಿಕನ್ದರೀಯನಗರಸ್ಯ ಪೋತಃ ಶೀತಕಾಲಂ ಯಾಪಯನ್ ತಸ್ಮಿನ್ ಉಪದ್ವೀಪೇ ಽತಿಷ್ಠತ್ ತಮೇವ ಪೋತಂ ವಯಮ್ ಆರುಹ್ಯ ಯಾತ್ರಾಮ್ ಅಕುರ್ಮ್ಮ| ");
INSERT INTO sankan_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","ತತಃ ಪ್ರಥಮತಃ ಸುರಾಕೂಸನಗರಮ್ ಉಪಸ್ಥಾಯ ತತ್ರ ತ್ರೀಣಿ ದಿನಾನಿ ಸ್ಥಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","ತಸ್ಮಾದ್ ಆವೃತ್ಯ ರೀಗಿಯನಗರಮ್ ಉಪಸ್ಥಿತಾಃ ದಿನೈಕಸ್ಮಾತ್ ಪರಂ ದಕ್ಷಿಣವಯೌ ಸಾನುಕೂಲ್ಯೇ ಸತಿ ಪರಸ್ಮಿನ್ ದಿವಸೇ ಪತಿಯಲೀನಗರಮ್ ಉಪಾತಿಷ್ಠಾಮ| ");
INSERT INTO sankan_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","ತತೋಽಸ್ಮಾಸು ತತ್ರತ್ಯಂ ಭ್ರಾತೃಗಣಂ ಪ್ರಾಪ್ತೇಷು ತೇ ಸ್ವೈಃ ಸಾರ್ದ್ಧಮ್ ಅಸ್ಮಾನ್ ಸಪ್ತ ದಿನಾನಿ ಸ್ಥಾಪಯಿತುಮ್ ಅಯತನ್ತ, ಇತ್ಥಂ ವಯಂ ರೋಮಾನಗರಮ್ ಪ್ರತ್ಯಗಚ್ಛಾಮ| ");
INSERT INTO sankan_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","ತಸ್ಮಾತ್ ತತ್ರತ್ಯಾಃ ಭ್ರಾತರೋಽಸ್ಮಾಕಮ್ ಆಗಮನವಾರ್ತ್ತಾಂ ಶ್ರುತ್ವಾ ಆಪ್ಪಿಯಫರಂ ತ್ರಿಷ್ಟಾವರ್ಣೀಞ್ಚ ಯಾವದ್ ಅಗ್ರೇಸರಾಃ ಸನ್ತೋಸ್ಮಾನ್ ಸಾಕ್ಷಾತ್ ಕರ್ತ್ತುಮ್ ಆಗಮನ್; ತೇಷಾಂ ದರ್ಶನಾತ್ ಪೌಲ ಈಶ್ವರಂ ಧನ್ಯಂ ವದನ್ ಆಶ್ವಾಸಮ್ ಆಪ್ತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","ಅಸ್ಮಾಸು ರೋಮಾನಗರಂ ಗತೇಷು ಶತಸೇನಾಪತಿಃ ಸರ್ವ್ವಾನ್ ಬನ್ದೀನ್ ಪ್ರಧಾನಸೇನಾಪತೇಃ ಸಮೀಪೇ ಸಮಾರ್ಪಯತ್ ಕಿನ್ತು ಪೌಲಾಯ ಸ್ವರಕ್ಷಕಪದಾತಿನಾ ಸಹ ಪೃಥಗ್ ವಸ್ತುಮ್ ಅನುಮತಿಂ ದತ್ತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","ದಿನತ್ರಯಾತ್ ಪರಂ ಪೌಲಸ್ತದ್ದೇಶಸ್ಥಾನ್ ಪ್ರಧಾನಯಿಹೂದಿನ ಆಹೂತವಾನ್ ತತಸ್ತೇಷು ಸಮುಪಸ್ಥಿತೇಷು ಸ ಕಥಿತವಾನ್, ಹೇ ಭ್ರಾತೃಗಣ ನಿಜಲೋಕಾನಾಂ ಪೂರ್ವ್ವಪುರುಷಾಣಾಂ ವಾ ರೀತೇ ರ್ವಿಪರೀತಂ ಕಿಞ್ಚನ ಕರ್ಮ್ಮಾಹಂ ನಾಕರವಂ ತಥಾಪಿ ಯಿರೂಶಾಲಮನಿವಾಸಿನೋ ಲೋಕಾ ಮಾಂ ಬನ್ದಿಂ ಕೃತ್ವಾ ರೋಮಿಲೋಕಾನಾಂ ಹಸ್ತೇಷು ಸಮರ್ಪಿತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","ರೋಮಿಲೋಕಾ ವಿಚಾರ್ಯ್ಯ ಮಮ ಪ್ರಾಣಹನನಾರ್ಹಂ ಕಿಮಪಿ ಕಾರಣಂ ನ ಪ್ರಾಪ್ಯ ಮಾಂ ಮೋಚಯಿತುಮ್ ಐಚ್ಛನ್; ");
INSERT INTO sankan_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","ಕಿನ್ತು ಯಿಹೂದಿಲೋಕಾನಾಮ್ ಆಪತ್ತ್ಯಾ ಮಯಾ ಕೈಸರರಾಜಸ್ಯ ಸಮೀಪೇ ವಿಚಾರಸ್ಯ ಪ್ರಾರ್ಥನಾ ಕರ್ತ್ತವ್ಯಾ ಜಾತಾ ನೋಚೇತ್ ನಿಜದೇಶೀಯಲೋಕಾನ್ ಪ್ರತಿ ಮಮ ಕೋಪ್ಯಭಿಯೋಗೋ ನಾಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","ಏತತ್ಕಾರಣಾದ್ ಅಹಂ ಯುಷ್ಮಾನ್ ದ್ರಷ್ಟುಂ ಸಂಲಪಿತುಞ್ಚಾಹೂಯಮ್ ಇಸ್ರಾಯೇಲ್ವಶೀಯಾನಾಂ ಪ್ರತ್ಯಾಶಾಹೇತೋಹಮ್ ಏತೇನ ಶುಙ್ಖಲೇನ ಬದ್ಧೋಽಭವಮ್| ");
INSERT INTO sankan_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","ತದಾ ತೇ ತಮ್ ಅವಾದಿಷುಃ, ಯಿಹೂದೀಯದೇಶಾದ್ ವಯಂ ತ್ವಾಮಧಿ ಕಿಮಪಿ ಪತ್ರಂ ನ ಪ್ರಾಪ್ತಾ ಯೇ ಭ್ರಾತರಃ ಸಮಾಯಾತಾಸ್ತೇಷಾಂ ಕೋಪಿ ತವ ಕಾಮಪಿ ವಾರ್ತ್ತಾಂ ನಾವದತ್ ಅಭದ್ರಮಪಿ ನಾಕಥಯಚ್ಚ| ");
INSERT INTO sankan_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","ತವ ಮತಂ ಕಿಮಿತಿ ವಯಂ ತ್ವತ್ತಃ ಶ್ರೋತುಮಿಚ್ಛಾಮಃ| ಯದ್ ಇದಂ ನವೀನಂ ಮತಮುತ್ಥಿತಂ ತತ್ ಸರ್ವ್ವತ್ರ ಸರ್ವ್ವೇಷಾಂ ನಿಕಟೇ ನಿನ್ದಿತಂ ಜಾತಮ ಇತಿ ವಯಂ ಜಾನೀಮಃ| ");
INSERT INTO sankan_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","ತೈಸ್ತದರ್ಥಮ್ ಏಕಸ್ಮಿನ್ ದಿನೇ ನಿರೂಪಿತೇ ತಸ್ಮಿನ್ ದಿನೇ ಬಹವ ಏಕತ್ರ ಮಿಲಿತ್ವಾ ಪೌಲಸ್ಯ ವಾಸಗೃಹಮ್ ಆಗಚ್ಛನ್ ತಸ್ಮಾತ್ ಪೌಲ ಆ ಪ್ರಾತಃಕಾಲಾತ್ ಸನ್ಧ್ಯಾಕಾಲಂ ಯಾವನ್ ಮೂಸಾವ್ಯವಸ್ಥಾಗ್ರನ್ಥಾದ್ ಭವಿಷ್ಯದ್ವಾದಿನಾಂ ಗ್ರನ್ಥೇಭ್ಯಶ್ಚ ಯೀಶೋಃ ಕಥಾಮ್ ಉತ್ಥಾಪ್ಯ ಈಶ್ವರಸ್ಯ ರಾಜ್ಯೇ ಪ್ರಮಾಣಂ ದತ್ವಾ ತೇಷಾಂ ಪ್ರವೃತ್ತಿಂ ಜನಯಿತುಂ ಚೇಷ್ಟಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","ಕೇಚಿತ್ತು ತಸ್ಯ ಕಥಾಂ ಪ್ರತ್ಯಾಯನ್ ಕೇಚಿತ್ತು ನ ಪ್ರತ್ಯಾಯನ್; ");
INSERT INTO sankan_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","ಏತತ್ಕಾರಣಾತ್ ತೇಷಾಂ ಪರಸ್ಪರಮ್ ಅನೈಕ್ಯಾತ್ ಸರ್ವ್ವೇ ಚಲಿತವನ್ತಃ; ತಥಾಪಿ ಪೌಲ ಏತಾಂ ಕಥಾಮೇಕಾಂ ಕಥಿತವಾನ್ ಪವಿತ್ರ ಆತ್ಮಾ ಯಿಶಯಿಯಸ್ಯ ಭವಿಷ್ಯದ್ವಕ್ತು ರ್ವದನಾದ್ ಅಸ್ಮಾಕಂ ಪಿತೃಪುರುಷೇಭ್ಯ ಏತಾಂ ಕಥಾಂ ಭದ್ರಂ ಕಥಯಾಮಾಸ, ಯಥಾ, ");
INSERT INTO sankan_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","\"ಉಪಗತ್ಯ ಜನಾನೇತಾನ್ ತ್ವಂ ಭಾಷಸ್ವ ವಚಸ್ತ್ವಿದಂ| ಕರ್ಣೈಃ ಶ್ರೋಷ್ಯಥ ಯೂಯಂ ಹಿ ಕಿನ್ತು ಯೂಯಂ ನ ಭೋತ್ಸ್ಯಥ| ನೇತ್ರೈ ರ್ದ್ರಕ್ಷ್ಯಥ ಯೂಯಞ್ಚ ಜ್ಞಾತುಂ ಯೂಯಂ ನ ಶಕ್ಷ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","ತೇ ಮಾನುಷಾ ಯಥಾ ನೇತ್ರೈಃ ಪರಿಪಶ್ಯನ್ತಿ ನೈವ ಹಿ| ಕರ್ಣೈಃ ರ್ಯಥಾ ನ ಶೃಣ್ವನ್ತಿ ಬುಧ್ಯನ್ತೇ ನ ಚ ಮಾನಸೈಃ| ವ್ಯಾವರ್ತ್ತಯತ್ಸು ಚಿತ್ತಾನಿ ಕಾಲೇ ಕುತ್ರಾಪಿ ತೇಷು ವೈ| ಮತ್ತಸ್ತೇ ಮನುಜಾಃ ಸ್ವಸ್ಥಾ ಯಥಾ ನೈವ ಭವನ್ತಿ ಚ| ತಥಾ ತೇಷಾಂ ಮನುಷ್ಯಾಣಾಂ ಸನ್ತಿ ಸ್ಥೂಲಾ ಹಿ ಬುದ್ಧಯಃ| ಬಧಿರೀಭೂತಕರ್ಣಾಶ್ಚ ಜಾತಾಶ್ಚ ಮುದ್ರಿತಾ ದೃಶಃ|| ");
INSERT INTO sankan_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","ಅತ ಈಶ್ವರಾದ್ ಯತ್ ಪರಿತ್ರಾಣಂ ತಸ್ಯ ವಾರ್ತ್ತಾ ಭಿನ್ನದೇಶೀಯಾನಾಂ ಸಮೀಪಂ ಪ್ರೇಷಿತಾ ತಏವ ತಾಂ ಗ್ರಹೀಷ್ಯನ್ತೀತಿ ಯೂಯಂ ಜಾನೀತ| ");
INSERT INTO sankan_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","ಏತಾದೃಶ್ಯಾಂ ಕಥಾಯಾಂ ಕಥಿತಾಯಾಂ ಸತ್ಯಾಂ ಯಿಹೂದಿನಃ ಪರಸ್ಪರಂ ಬಹುವಿಚಾರಂ ಕುರ್ವ್ವನ್ತೋ ಗತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","ಇತ್ಥಂ ಪೌಲಃ ಸಮ್ಪೂರ್ಣಂ ವತ್ಸರದ್ವಯಂ ಯಾವದ್ ಭಾಟಕೀಯೇ ವಾಸಗೃಹೇ ವಸನ್ ಯೇ ಲೋಕಾಸ್ತಸ್ಯ ಸನ್ನಿಧಿಮ್ ಆಗಚ್ಛನ್ತಿ ತಾನ್ ಸರ್ವ್ವಾನೇವ ಪರಿಗೃಹ್ಲನ್, ");
INSERT INTO sankan_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","ನಿರ್ವಿಘ್ನಮ್ ಅತಿಶಯನಿಃಕ್ಷೋಭಮ್ ಈಶ್ವರೀಯರಾಜತ್ವಸ್ಯ ಕಥಾಂ ಪ್ರಚಾರಯನ್ ಪ್ರಭೌ ಯೀಶೌ ಖ್ರೀಷ್ಟೇ ಕಥಾಃ ಸಮುಪಾದಿಶತ್| ಇತಿ||");
INSERT INTO sankan_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","ಈಶ್ವರೋ ನಿಜಪುತ್ರಮಧಿ ಯಂ ಸುಸಂವಾದಂ ಭವಿಷ್ಯದ್ವಾದಿಭಿ ರ್ಧರ್ಮ್ಮಗ್ರನ್ಥೇ ಪ್ರತಿಶ್ರುತವಾನ್ ತಂ ಸುಸಂವಾದಂ ಪ್ರಚಾರಯಿತುಂ ಪೃಥಕ್ಕೃತ ಆಹೂತಃ ಪ್ರೇರಿತಶ್ಚ ಪ್ರಭೋ ರ್ಯೀಶುಖ್ರೀಷ್ಟಸ್ಯ ಸೇವಕೋ ಯಃ ಪೌಲಃ ");
INSERT INTO sankan_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","ಸ ರೋಮಾನಗರಸ್ಥಾನ್ ಈಶ್ವರಪ್ರಿಯಾನ್ ಆಹೂತಾಂಶ್ಚ ಪವಿತ್ರಲೋಕಾನ್ ಪ್ರತಿ ಪತ್ರಂ ಲಿಖತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","ಅಸ್ಮಾಕಂ ಸ ಪ್ರಭು ರ್ಯೀಶುಃ ಖ್ರೀಷ್ಟಃ ಶಾರೀರಿಕಸಮ್ಬನ್ಧೇನ ದಾಯೂದೋ ವಂಶೋದ್ಭವಃ ");
INSERT INTO sankan_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","ಪವಿತ್ರಸ್ಯಾತ್ಮನಃ ಸಮ್ಬನ್ಧೇನ ಚೇಶ್ವರಸ್ಯ ಪ್ರಭಾವವಾನ್ ಪುತ್ರ ಇತಿ ಶ್ಮಶಾನಾತ್ ತಸ್ಯೋತ್ಥಾನೇನ ಪ್ರತಿಪನ್ನಂ| ");
INSERT INTO sankan_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","ಅಪರಂ ಯೇಷಾಂ ಮಧ್ಯೇ ಯೀಶುನಾ ಖ್ರೀಷ್ಟೇನ ಯೂಯಮಪ್ಯಾಹೂತಾಸ್ತೇ ಽನ್ಯದೇಶೀಯಲೋಕಾಸ್ತಸ್ಯ ನಾಮ್ನಿ ವಿಶ್ವಸ್ಯ ನಿದೇಶಗ್ರಾಹಿಣೋ ಯಥಾ ಭವನ್ತಿ ");
INSERT INTO sankan_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","ತದಭಿಪ್ರಾಯೇಣ ವಯಂ ತಸ್ಮಾದ್ ಅನುಗ್ರಹಂ ಪ್ರೇರಿತತ್ವಪದಞ್ಚ ಪ್ರಾಪ್ತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","ತಾತೇನಾಸ್ಮಾಕಮ್ ಈಶ್ವರೇಣ ಪ್ರಭುಣಾ ಯೀಶುಖ್ರೀಷ್ಟೇನ ಚ ಯುಷ್ಮಭ್ಯಮ್ ಅನುಗ್ರಹಃ ಶಾನ್ತಿಶ್ಚ ಪ್ರದೀಯೇತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","ಪ್ರಥಮತಃ ಸರ್ವ್ವಸ್ಮಿನ್ ಜಗತಿ ಯುಷ್ಮಾಕಂ ವಿಶ್ವಾಸಸ್ಯ ಪ್ರಕಾಶಿತತ್ವಾದ್ ಅಹಂ ಯುಷ್ಮಾಕಂ ಸರ್ವ್ವೇಷಾಂ ನಿಮಿತ್ತಂ ಯೀಶುಖ್ರೀಷ್ಟಸ್ಯ ನಾಮ ಗೃಹ್ಲನ್ ಈಶ್ವರಸ್ಯ ಧನ್ಯವಾದಂ ಕರೋಮಿ| ");
INSERT INTO sankan_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","ಅಪರಮ್ ಈಶ್ವರಸ್ಯ ಪ್ರಸಾದಾದ್ ಬಹುಕಾಲಾತ್ ಪರಂ ಸಾಮ್ಪ್ರತಂ ಯುಷ್ಮಾಕಂ ಸಮೀಪಂ ಯಾತುಂ ಕಥಮಪಿ ಯತ್ ಸುಯೋಗಂ ಪ್ರಾಪ್ನೋಮಿ, ಏತದರ್ಥಂ ನಿರನ್ತರಂ ನಾಮಾನ್ಯುಚ್ಚಾರಯನ್ ನಿಜಾಸು ಸರ್ವ್ವಪ್ರಾರ್ಥನಾಸು ಸರ್ವ್ವದಾ ನಿವೇದಯಾಮಿ, ");
INSERT INTO sankan_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ಏತಸ್ಮಿನ್ ಯಮಹಂ ತತ್ಪುತ್ರೀಯಸುಸಂವಾದಪ್ರಚಾರಣೇನ ಮನಸಾ ಪರಿಚರಾಮಿ ಸ ಈಶ್ವರೋ ಮಮ ಸಾಕ್ಷೀ ವಿದ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","ಯತೋ ಯುಷ್ಮಾಕಂ ಮಮ ಚ ವಿಶ್ವಾಸೇನ ವಯಮ್ ಉಭಯೇ ಯಥಾ ಶಾನ್ತಿಯುಕ್ತಾ ಭವಾಮ ಇತಿ ಕಾರಣಾದ್ ");
INSERT INTO sankan_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","ಯುಷ್ಮಾಕಂ ಸ್ಥೈರ್ಯ್ಯಕರಣಾರ್ಥಂ ಯುಷ್ಮಭ್ಯಂ ಕಿಞ್ಚಿತ್ಪರಮಾರ್ಥದಾನದಾನಾಯ ಯುಷ್ಮಾನ್ ಸಾಕ್ಷಾತ್ ಕರ್ತ್ತುಂ ಮದೀಯಾ ವಾಞ್ಛಾ| ");
INSERT INTO sankan_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","ಹೇ ಭ್ರಾತೃಗಣ ಭಿನ್ನದೇಶೀಯಲೋಕಾನಾಂ ಮಧ್ಯೇ ಯದ್ವತ್ ತದ್ವದ್ ಯುಷ್ಮಾಕಂ ಮಧ್ಯೇಪಿ ಯಥಾ ಫಲಂ ಭುಞ್ಜೇ ತದಭಿಪ್ರಾಯೇಣ ಮುಹುರ್ಮುಹು ರ್ಯುಷ್ಮಾಕಂ ಸಮೀಪಂ ಗನ್ತುಮ್ ಉದ್ಯತೋಽಹಂ ಕಿನ್ತು ಯಾವದ್ ಅದ್ಯ ತಸ್ಮಿನ್ ಗಮನೇ ಮಮ ವಿಘ್ನೋ ಜಾತ ಇತಿ ಯೂಯಂ ಯದ್ ಅಜ್ಞಾತಾಸ್ತಿಷ್ಠಥ ತದಹಮ್ ಉಚಿತಂ ನ ಬುಧ್ಯೇ| ");
INSERT INTO sankan_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","ಅಹಂ ಸಭ್ಯಾಸಭ್ಯಾನಾಂ ವಿದ್ವದವಿದ್ವತಾಞ್ಚ ಸರ್ವ್ವೇಷಾಮ್ ಋಣೀ ವಿದ್ಯೇ| ");
INSERT INTO sankan_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","ಅತಏವ ರೋಮಾನಿವಾಸಿನಾಂ ಯುಷ್ಮಾಕಂ ಸಮೀಪೇಽಪಿ ಯಥಾಶಕ್ತಿ ಸುಸಂವಾದಂ ಪ್ರಚಾರಯಿತುಮ್ ಅಹಮ್ ಉದ್ಯತೋಸ್ಮಿ| ");
INSERT INTO sankan_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","ಯತಃ ಖ್ರೀಷ್ಟಸ್ಯ ಸುಸಂವಾದೋ ಮಮ ಲಜ್ಜಾಸ್ಪದಂ ನಹಿ ಸ ಈಶ್ವರಸ್ಯ ಶಕ್ತಿಸ್ವರೂಪಃ ಸನ್ ಆ ಯಿಹೂದೀಯೇಭ್ಯೋ ಽನ್ಯಜಾತೀಯಾನ್ ಯಾವತ್ ಸರ್ವ್ವಜಾತೀಯಾನಾಂ ಮಧ್ಯೇ ಯಃ ಕಶ್ಚಿದ್ ತತ್ರ ವಿಶ್ವಸಿತಿ ತಸ್ಯೈವ ತ್ರಾಣಂ ಜನಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","ಯತಃ ಪ್ರತ್ಯಯಸ್ಯ ಸಮಪರಿಮಾಣಮ್ ಈಶ್ವರದತ್ತಂ ಪುಣ್ಯಂ ತತ್ಸುಸಂವಾದೇ ಪ್ರಕಾಶತೇ| ತದಧಿ ಧರ್ಮ್ಮಪುಸ್ತಕೇಪಿ ಲಿಖಿತಮಿದಂ \"ಪುಣ್ಯವಾನ್ ಜನೋ ವಿಶ್ವಾಸೇನ ಜೀವಿಷ್ಯತಿ\"| ");
INSERT INTO sankan_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","ಅತಏವ ಯೇ ಮಾನವಾಃ ಪಾಪಕರ್ಮ್ಮಣಾ ಸತ್ಯತಾಂ ರುನ್ಧನ್ತಿ ತೇಷಾಂ ಸರ್ವ್ವಸ್ಯ ದುರಾಚರಣಸ್ಯಾಧರ್ಮ್ಮಸ್ಯ ಚ ವಿರುದ್ಧಂ ಸ್ವರ್ಗಾದ್ ಈಶ್ವರಸ್ಯ ಕೋಪಃ ಪ್ರಕಾಶತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","ಯತ ಈಶ್ವರಮಧಿ ಯದ್ಯದ್ ಜ್ಞೇಯಂ ತದ್ ಈಶ್ವರಃ ಸ್ವಯಂ ತಾನ್ ಪ್ರತಿ ಪ್ರಕಾಶಿತವಾನ್ ತಸ್ಮಾತ್ ತೇಷಾಮ್ ಅಗೋಚರಂ ನಹಿ| ");
INSERT INTO sankan_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","ಫಲತಸ್ತಸ್ಯಾನನ್ತಶಕ್ತೀಶ್ವರತ್ವಾದೀನ್ಯದೃಶ್ಯಾನ್ಯಪಿ ಸೃಷ್ಟಿಕಾಲಮ್ ಆರಭ್ಯ ಕರ್ಮ್ಮಸು ಪ್ರಕಾಶಮಾನಾನಿ ದೃಶ್ಯನ್ತೇ ತಸ್ಮಾತ್ ತೇಷಾಂ ದೋಷಪ್ರಕ್ಷಾಲನಸ್ಯ ಪನ್ಥಾ ನಾಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","ಅಪರಮ್ ಈಶ್ವರಂ ಜ್ಞಾತ್ವಾಪಿ ತೇ ತಮ್ ಈಶ್ವರಜ್ಞಾನೇನ ನಾದ್ರಿಯನ್ತ ಕೃತಜ್ಞಾ ವಾ ನ ಜಾತಾಃ; ತಸ್ಮಾತ್ ತೇಷಾಂ ಸರ್ವ್ವೇ ತರ್ಕಾ ವಿಫಲೀಭೂತಾಃ, ಅಪರಞ್ಚ ತೇಷಾಂ ವಿವೇಕಶೂನ್ಯಾನಿ ಮನಾಂಸಿ ತಿಮಿರೇ ಮಗ್ನಾನಿ| ");
INSERT INTO sankan_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","ತೇ ಸ್ವಾನ್ ಜ್ಞಾನಿನೋ ಜ್ಞಾತ್ವಾ ಜ್ಞಾನಹೀನಾ ಅಭವನ್ ");
INSERT INTO sankan_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","ಅನಶ್ವರಸ್ಯೇಶ್ವರಸ್ಯ ಗೌರವಂ ವಿಹಾಯ ನಶ್ವರಮನುಷ್ಯಪಶುಪಕ್ಷ್ಯುರೋಗಾಮಿಪ್ರಭೃತೇರಾಕೃತಿವಿಶಿಷ್ಟಪ್ರತಿಮಾಸ್ತೈರಾಶ್ರಿತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","ಇತ್ಥಂ ತ ಈಶ್ವರಸ್ಯ ಸತ್ಯತಾಂ ವಿಹಾಯ ಮೃಷಾಮತಮ್ ಆಶ್ರಿತವನ್ತಃ ಸಚ್ಚಿದಾನನ್ದಂ ಸೃಷ್ಟಿಕರ್ತ್ತಾರಂ ತ್ಯಕ್ತ್ವಾ ಸೃಷ್ಟವಸ್ತುನಃ ಪೂಜಾಂ ಸೇವಾಞ್ಚ ಕೃತವನ್ತಃ; ");
INSERT INTO sankan_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","ಇತಿ ಹೇತೋರೀಶ್ವರಸ್ತಾನ್ ಕುಕ್ರಿಯಾಯಾಂ ಸಮರ್ಪ್ಯ ನಿಜನಿಜಕುಚಿನ್ತಾಭಿಲಾಷಾಭ್ಯಾಂ ಸ್ವಂ ಸ್ವಂ ಶರೀರಂ ಪರಸ್ಪರಮ್ ಅಪಮಾನಿತಂ ಕರ್ತ್ತುಮ್ ಅದದಾತ್| ");
INSERT INTO sankan_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","ಈಶ್ವರೇಣ ತೇಷು ಕ್ವಭಿಲಾಷೇ ಸಮರ್ಪಿತೇಷು ತೇಷಾಂ ಯೋಷಿತಃ ಸ್ವಾಭಾವಿಕಾಚರಣಮ್ ಅಪಹಾಯ ವಿಪರೀತಕೃತ್ಯೇ ಪ್ರಾವರ್ತ್ತನ್ತ; ");
INSERT INTO sankan_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","ತಥಾ ಪುರುಷಾ ಅಪಿ ಸ್ವಾಭಾವಿಕಯೋಷಿತ್ಸಙ್ಗಮಂ ವಿಹಾಯ ಪರಸ್ಪರಂ ಕಾಮಕೃಶಾನುನಾ ದಗ್ಧಾಃ ಸನ್ತಃ ಪುಮಾಂಸಃ ಪುಂಭಿಃ ಸಾಕಂ ಕುಕೃತ್ಯೇ ಸಮಾಸಜ್ಯ ನಿಜನಿಜಭ್ರಾನ್ತೇಃ ಸಮುಚಿತಂ ಫಲಮ್ ಅಲಭನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","ತೇ ಸ್ವೇಷಾಂ ಮನಃಸ್ವೀಶ್ವರಾಯ ಸ್ಥಾನಂ ದಾತುಮ್ ಅನಿಚ್ಛುಕಾಸ್ತತೋ ಹೇತೋರೀಶ್ವರಸ್ತಾನ್ ಪ್ರತಿ ದುಷ್ಟಮನಸ್ಕತ್ವಮ್ ಅವಿಹಿತಕ್ರಿಯತ್ವಞ್ಚ ದತ್ತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","ಅತಏವ ತೇ ಸರ್ವ್ವೇ ಽನ್ಯಾಯೋ ವ್ಯಭಿಚಾರೋ ದುಷ್ಟತ್ವಂ ಲೋಭೋ ಜಿಘಾಂಸಾ ಈರ್ಷ್ಯಾ ವಧೋ ವಿವಾದಶ್ಚಾತುರೀ ಕುಮತಿರಿತ್ಯಾದಿಭಿ ರ್ದುಷ್ಕರ್ಮ್ಮಭಿಃ ಪರಿಪೂರ್ಣಾಃ ಸನ್ತಃ ");
INSERT INTO sankan_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","ಕರ್ಣೇಜಪಾ ಅಪವಾದಿನ ಈಶ್ವರದ್ವೇಷಕಾ ಹಿಂಸಕಾ ಅಹಙ್ಕಾರಿಣ ಆತ್ಮಶ್ಲಾಘಿನಃ ಕುಕರ್ಮ್ಮೋತ್ಪಾದಕಾಃ ಪಿತ್ರೋರಾಜ್ಞಾಲಙ್ಘಕಾ ");
INSERT INTO sankan_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","ಅವಿಚಾರಕಾ ನಿಯಮಲಙ್ಘಿನಃ ಸ್ನೇಹರಹಿತಾ ಅತಿದ್ವೇಷಿಣೋ ನಿರ್ದಯಾಶ್ಚ ಜಾತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","ಯೇ ಜನಾ ಏತಾದೃಶಂ ಕರ್ಮ್ಮ ಕುರ್ವ್ವನ್ತಿ ತಏವ ಮೃತಿಯೋಗ್ಯಾ ಈಶ್ವರಸ್ಯ ವಿಚಾರಮೀದೃಶಂ ಜ್ಞಾತ್ವಾಪಿ ತ ಏತಾದೃಶಂ ಕರ್ಮ್ಮ ಸ್ವಯಂ ಕುರ್ವ್ವನ್ತಿ ಕೇವಲಮಿತಿ ನಹಿ ಕಿನ್ತು ತಾದೃಶಕರ್ಮ್ಮಕಾರಿಷು ಲೋಕೇಷ್ವಪಿ ಪ್ರೀಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","ಹೇ ಪರದೂಷಕ ಮನುಷ್ಯ ಯಃ ಕಶ್ಚನ ತ್ವಂ ಭವಸಿ ತವೋತ್ತರದಾನಾಯ ಪನ್ಥಾ ನಾಸ್ತಿ ಯತೋ ಯಸ್ಮಾತ್ ಕರ್ಮ್ಮಣಃ ಪರಸ್ತ್ವಯಾ ದೂಷ್ಯತೇ ತಸ್ಮಾತ್ ತ್ವಮಪಿ ದೂಷ್ಯಸೇ, ಯತಸ್ತಂ ದೂಷಯನ್ನಪಿ ತ್ವಂ ತದ್ವದ್ ಆಚರಸಿ| ");
INSERT INTO sankan_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","ಕಿನ್ತ್ವೇತಾದೃಗಾಚಾರಿಭ್ಯೋ ಯಂ ದಣ್ಡಮ್ ಈಶ್ವರೋ ನಿಶ್ಚಿನೋತಿ ಸ ಯಥಾರ್ಥ ಇತಿ ವಯಂ ಜಾನೀಮಃ| ");
INSERT INTO sankan_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","ಅತಏವ ಹೇ ಮಾನುಷ ತ್ವಂ ಯಾದೃಗಾಚಾರಿಣೋ ದೂಷಯಸಿ ಸ್ವಯಂ ಯದಿ ತಾದೃಗಾಚರಸಿ ತರ್ಹಿ ತ್ವಮ್ ಈಶ್ವರದಣ್ಡಾತ್ ಪಲಾಯಿತುಂ ಶಕ್ಷ್ಯಸೀತಿ ಕಿಂ ಬುಧ್ಯಸೇ? ");
INSERT INTO sankan_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","ಅಪರಂ ತವ ಮನಸಃ ಪರಿವರ್ತ್ತನಂ ಕರ್ತ್ತುಮ್ ಇಶ್ವರಸ್ಯಾನುಗ್ರಹೋ ಭವತಿ ತನ್ನ ಬುದ್ಧ್ವಾ ತ್ವಂ ಕಿಂ ತದೀಯಾನುಗ್ರಹಕ್ಷಮಾಚಿರಸಹಿಷ್ಣುತ್ವನಿಧಿಂ ತುಚ್ಛೀಕರೋಷಿ? ");
INSERT INTO sankan_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","ತಥಾ ಸ್ವಾನ್ತಃಕರಣಸ್ಯ ಕಠೋರತ್ವಾತ್ ಖೇದರಾಹಿತ್ಯಾಚ್ಚೇಶ್ವರಸ್ಯ ನ್ಯಾಯ್ಯವಿಚಾರಪ್ರಕಾಶನಸ್ಯ ಕ್ರೋಧಸ್ಯ ಚ ದಿನಂ ಯಾವತ್ ಕಿಂ ಸ್ವಾರ್ಥಂ ಕೋಪಂ ಸಞ್ಚಿನೋಷಿ? ");
INSERT INTO sankan_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","ಕಿನ್ತು ಸ ಏಕೈಕಮನುಜಾಯ ತತ್ಕರ್ಮ್ಮಾನುಸಾರೇಣ ಪ್ರತಿಫಲಂ ದಾಸ್ಯತಿ; ");
INSERT INTO sankan_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","ವಸ್ತುತಸ್ತು ಯೇ ಜನಾ ಧೈರ್ಯ್ಯಂ ಧೃತ್ವಾ ಸತ್ಕರ್ಮ್ಮ ಕುರ್ವ್ವನ್ತೋ ಮಹಿಮಾ ಸತ್ಕಾರೋಽಮರತ್ವಞ್ಚೈತಾನಿ ಮೃಗಯನ್ತೇ ತೇಭ್ಯೋಽನನ್ತಾಯು ರ್ದಾಸ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","ಅಪರಂ ಯೇ ಜನಾಃ ಸತ್ಯಧರ್ಮ್ಮಮ್ ಅಗೃಹೀತ್ವಾ ವಿಪರೀತಧರ್ಮ್ಮಮ್ ಗೃಹ್ಲನ್ತಿ ತಾದೃಶಾ ವಿರೋಧಿಜನಾಃ ಕೋಪಂ ಕ್ರೋಧಞ್ಚ ಭೋಕ್ಷ್ಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","ಆ ಯಿಹೂದಿನೋಽನ್ಯದೇಶಿನಃ ಪರ್ಯ್ಯನ್ತಂ ಯಾವನ್ತಃ ಕುಕರ್ಮ್ಮಕಾರಿಣಃ ಪ್ರಾಣಿನಃ ಸನ್ತಿ ತೇ ಸರ್ವ್ವೇ ದುಃಖಂ ಯಾತನಾಞ್ಚ ಗಮಿಷ್ಯನ್ತಿ; ");
INSERT INTO sankan_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","ಕಿನ್ತು ಆ ಯಿಹೂದಿನೋ ಭಿನ್ನದೇಶಿಪರ್ಯ್ಯನ್ತಾ ಯಾವನ್ತಃ ಸತ್ಕರ್ಮ್ಮಕಾರಿಣೋ ಲೋಕಾಃ ಸನ್ತಿ ತಾನ್ ಪ್ರತಿ ಮಹಿಮಾ ಸತ್ಕಾರಃ ಶಾನ್ತಿಶ್ಚ ಭವಿಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","ಈಶ್ವರಸ್ಯ ವಿಚಾರೇ ಪಕ್ಷಪಾತೋ ನಾಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","ಅಲಬ್ಧವ್ಯವಸ್ಥಾಶಾಸ್ತ್ರೈ ರ್ಯೈಃ ಪಾಪಾನಿ ಕೃತಾನಿ ವ್ಯವಸ್ಥಾಶಾಸ್ತ್ರಾಲಬ್ಧತ್ವಾನುರೂಪಸ್ತೇಷಾಂ ವಿನಾಶೋ ಭವಿಷ್ಯತಿ; ಕಿನ್ತು ಲಬ್ಧವ್ಯವಸ್ಥಾಶಾಸ್ತ್ರಾ ಯೇ ಪಾಪಾನ್ಯಕುರ್ವ್ವನ್ ವ್ಯವಸ್ಥಾನುಸಾರಾದೇವ ತೇಷಾಂ ವಿಚಾರೋ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","ವ್ಯವಸ್ಥಾಶ್ರೋತಾರ ಈಶ್ವರಸ್ಯ ಸಮೀಪೇ ನಿಷ್ಪಾಪಾ ಭವಿಷ್ಯನ್ತೀತಿ ನಹಿ ಕಿನ್ತು ವ್ಯವಸ್ಥಾಚಾರಿಣ ಏವ ಸಪುಣ್ಯಾ ಭವಿಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","ಯತೋ ಽಲಬ್ಧವ್ಯವಸ್ಥಾಶಾಸ್ತ್ರಾ ಭಿನ್ನದೇಶೀಯಲೋಕಾ ಯದಿ ಸ್ವಭಾವತೋ ವ್ಯವಸ್ಥಾನುರೂಪಾನ್ ಆಚಾರಾನ್ ಕುರ್ವ್ವನ್ತಿ ತರ್ಹ್ಯಲಬ್ಧಶಾಸ್ತ್ರಾಃ ಸನ್ತೋಽಪಿ ತೇ ಸ್ವೇಷಾಂ ವ್ಯವಸ್ಥಾಶಾಸ್ತ್ರಮಿವ ಸ್ವಯಮೇವ ಭವನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","ತೇಷಾಂ ಮನಸಿ ಸಾಕ್ಷಿಸ್ವರೂಪೇ ಸತಿ ತೇಷಾಂ ವಿತರ್ಕೇಷು ಚ ಕದಾ ತಾನ್ ದೋಷಿಣಃ ಕದಾ ವಾ ನಿರ್ದೋಷಾನ್ ಕೃತವತ್ಸು ತೇ ಸ್ವಾನ್ತರ್ಲಿಖಿತಸ್ಯ ವ್ಯವಸ್ಥಾಶಾಸ್ತ್ರಸ್ಯ ಪ್ರಮಾಣಂ ಸ್ವಯಮೇವ ದದತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","ಯಸ್ಮಿನ್ ದಿನೇ ಮಯಾ ಪ್ರಕಾಶಿತಸ್ಯ ಸುಸಂವಾದಸ್ಯಾನುಸಾರಾದ್ ಈಶ್ವರೋ ಯೀಶುಖ್ರೀಷ್ಟೇನ ಮಾನುಷಾಣಾಮ್ ಅನ್ತಃಕರಣಾನಾಂ ಗೂಢಾಭಿಪ್ರಾಯಾನ್ ಧೃತ್ವಾ ವಿಚಾರಯಿಷ್ಯತಿ ತಸ್ಮಿನ್ ವಿಚಾರದಿನೇ ತತ್ ಪ್ರಕಾಶಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","ಪಶ್ಯ ತ್ವಂ ಸ್ವಯಂ ಯಿಹೂದೀತಿ ವಿಖ್ಯಾತೋ ವ್ಯವಸ್ಥೋಪರಿ ವಿಶ್ವಾಸಂ ಕರೋಷಿ, ");
INSERT INTO sankan_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ಈಶ್ವರಮುದ್ದಿಶ್ಯ ಸ್ವಂ ಶ್ಲಾಘಸೇ, ತಥಾ ವ್ಯವಸ್ಥಯಾ ಶಿಕ್ಷಿತೋ ಭೂತ್ವಾ ತಸ್ಯಾಭಿಮತಂ ಜಾನಾಸಿ, ಸರ್ವ್ವಾಸಾಂ ಕಥಾನಾಂ ಸಾರಂ ವಿವಿಂಕ್ಷೇ, ");
INSERT INTO sankan_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","ಅಪರಂ ಜ್ಞಾನಸ್ಯ ಸತ್ಯತಾಯಾಶ್ಚಾಕರಸ್ವರೂಪಂ ಶಾಸ್ತ್ರಂ ಮಮ ಸಮೀಪೇ ವಿದ್ಯತ ಅತೋ ಽನ್ಧಲೋಕಾನಾಂ ಮಾರ್ಗದರ್ಶಯಿತಾ ");
INSERT INTO sankan_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","ತಿಮಿರಸ್ಥಿತಲೋಕಾನಾಂ ಮಧ್ಯೇ ದೀಪ್ತಿಸ್ವರೂಪೋಽಜ್ಞಾನಲೋಕೇಭ್ಯೋ ಜ್ಞಾನದಾತಾ ಶಿಶೂನಾಂ ಶಿಕ್ಷಯಿತಾಹಮೇವೇತಿ ಮನ್ಯಸೇ| ");
INSERT INTO sankan_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","ಪರಾನ್ ಶಿಕ್ಷಯನ್ ಸ್ವಯಂ ಸ್ವಂ ಕಿಂ ನ ಶಿಕ್ಷಯಸಿ? ವಸ್ತುತಶ್ಚೌರ್ಯ್ಯನಿಷೇಧವ್ಯವಸ್ಥಾಂ ಪ್ರಚಾರಯನ್ ತ್ವಂ ಕಿಂ ಸ್ವಯಮೇವ ಚೋರಯಸಿ? ");
INSERT INTO sankan_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","ತಥಾ ಪರದಾರಗಮನಂ ಪ್ರತಿಷೇಧನ್ ಸ್ವಯಂ ಕಿಂ ಪರದಾರಾನ್ ಗಚ್ಛಸಿ? ತಥಾ ತ್ವಂ ಸ್ವಯಂ ಪ್ರತಿಮಾದ್ವೇಷೀ ಸನ್ ಕಿಂ ಮನ್ದಿರಸ್ಯ ದ್ರವ್ಯಾಣಿ ಹರಸಿ? ");
INSERT INTO sankan_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","ಯಸ್ತ್ವಂ ವ್ಯವಸ್ಥಾಂ ಶ್ಲಾಘಸೇ ಸ ತ್ವಂ ಕಿಂ ವ್ಯವಸ್ಥಾಮ್ ಅವಮತ್ಯ ನೇಶ್ವರಂ ಸಮ್ಮನ್ಯಸೇ? ");
INSERT INTO sankan_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","ಶಾಸ್ತ್ರೇ ಯಥಾ ಲಿಖತಿ \"ಭಿನ್ನದೇಶಿನಾಂ ಸಮೀಪೇ ಯುಷ್ಮಾಕಂ ದೋಷಾದ್ ಈಶ್ವರಸ್ಯ ನಾಮ್ನೋ ನಿನ್ದಾ ಭವತಿ| \" ");
INSERT INTO sankan_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","ಯದಿ ವ್ಯವಸ್ಥಾಂ ಪಾಲಯಸಿ ತರ್ಹಿ ತವ ತ್ವಕ್ಛೇದಕ್ರಿಯಾ ಸಫಲಾ ಭವತಿ; ಯತಿ ವ್ಯವಸ್ಥಾಂ ಲಙ್ಘಸೇ ತರ್ಹಿ ತವ ತ್ವಕ್ಛೇದೋಽತ್ವಕ್ಛೇದೋ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","ಯತೋ ವ್ಯವಸ್ಥಾಶಾಸ್ತ್ರಾದಿಷ್ಟಧರ್ಮ್ಮಕರ್ಮ್ಮಾಚಾರೀ ಪುಮಾನ್ ಅತ್ವಕ್ಛೇದೀ ಸನ್ನಪಿ ಕಿಂ ತ್ವಕ್ಛೇದಿನಾಂ ಮಧ್ಯೇ ನ ಗಣಯಿಷ್ಯತೇ? ");
INSERT INTO sankan_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","ಕಿನ್ತು ಲಬ್ಧಶಾಸ್ತ್ರಶ್ಛಿನ್ನತ್ವಕ್ ಚ ತ್ವಂ ಯದಿ ವ್ಯವಸ್ಥಾಲಙ್ಘನಂ ಕರೋಷಿ ತರ್ಹಿ ವ್ಯವಸ್ಥಾಪಾಲಕಾಃ ಸ್ವಾಭಾವಿಕಾಚ್ಛಿನ್ನತ್ವಚೋ ಲೋಕಾಸ್ತ್ವಾಂ ಕಿಂ ನ ದೂಷಯಿಷ್ಯನ್ತಿ? ");
INSERT INTO sankan_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","ತಸ್ಮಾದ್ ಯೋ ಬಾಹ್ಯೇ ಯಿಹೂದೀ ಸ ಯಿಹೂದೀ ನಹಿ ತಥಾಙ್ಗಸ್ಯ ಯಸ್ತ್ವಕ್ಛೇದಃ ಸ ತ್ವಕ್ಛೇದೋ ನಹಿ; ");
INSERT INTO sankan_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","ಕಿನ್ತು ಯೋ ಜನ ಆನ್ತರಿಕೋ ಯಿಹೂದೀ ಸ ಏವ ಯಿಹೂದೀ ಅಪರಞ್ಚ ಕೇವಲಲಿಖಿತಯಾ ವ್ಯವಸ್ಥಯಾ ನ ಕಿನ್ತು ಮಾನಸಿಕೋ ಯಸ್ತ್ವಕ್ಛೇದೋ ಯಸ್ಯ ಚ ಪ್ರಶಂಸಾ ಮನುಷ್ಯೇಭ್ಯೋ ನ ಭೂತ್ವಾ ಈಶ್ವರಾದ್ ಭವತಿ ಸ ಏವ ತ್ವಕ್ಛೇದಃ| ");
INSERT INTO sankan_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","ಅಪರಞ್ಚ ಯಿಹೂದಿನಃ ಕಿಂ ಶ್ರೇಷ್ಠತ್ವಂ? ತಥಾ ತ್ವಕ್ಛೇದಸ್ಯ ವಾ ಕಿಂ ಫಲಂ? ");
INSERT INTO sankan_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","ಸರ್ವ್ವಥಾ ಬಹೂನಿ ಫಲಾನಿ ಸನ್ತಿ, ವಿಶೇಷತ ಈಶ್ವರಸ್ಯ ಶಾಸ್ತ್ರಂ ತೇಭ್ಯೋಽದೀಯತ| ");
INSERT INTO sankan_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","ಕೈಶ್ಚಿದ್ ಅವಿಶ್ವಸನೇ ಕೃತೇ ತೇಷಾಮ್ ಅವಿಶ್ವಸನಾತ್ ಕಿಮ್ ಈಶ್ವರಸ್ಯ ವಿಶ್ವಾಸ್ಯತಾಯಾ ಹಾನಿರುತ್ಪತ್ಸ್ಯತೇ? ");
INSERT INTO sankan_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","ಕೇನಾಪಿ ಪ್ರಕಾರೇಣ ನಹಿ| ಯದ್ಯಪಿ ಸರ್ವ್ವೇ ಮನುಷ್ಯಾ ಮಿಥ್ಯಾವಾದಿನಸ್ತಥಾಪೀಶ್ವರಃ ಸತ್ಯವಾದೀ| ಶಾಸ್ತ್ರೇ ಯಥಾ ಲಿಖಿತಮಾಸ್ತೇ, ಅತಸ್ತ್ವನ್ತು ಸ್ವವಾಕ್ಯೇನ ನಿರ್ದ್ದೋಷೋ ಹಿ ಭವಿಷ್ಯಸಿ| ವಿಚಾರೇ ಚೈವ ನಿಷ್ಪಾಪೋ ಭವಿಷ್ಯಸಿ ನ ಸಂಶಯಃ| ");
INSERT INTO sankan_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","ಅಸ್ಮಾಕಮ್ ಅನ್ಯಾಯೇನ ಯದೀಶ್ವರಸ್ಯ ನ್ಯಾಯಃ ಪ್ರಕಾಶತೇ ತರ್ಹಿ ಕಿಂ ವದಿಷ್ಯಾಮಃ? ಅಹಂ ಮಾನುಷಾಣಾಂ ಕಥಾಮಿವ ಕಥಾಂ ಕಥಯಾಮಿ, ಈಶ್ವರಃ ಸಮುಚಿತಂ ದಣ್ಡಂ ದತ್ತ್ವಾ ಕಿಮ್ ಅನ್ಯಾಯೀ ಭವಿಷ್ಯತಿ? ");
INSERT INTO sankan_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","ಇತ್ಥಂ ನ ಭವತು, ತಥಾ ಸತೀಶ್ವರಃ ಕಥಂ ಜಗತೋ ವಿಚಾರಯಿತಾ ಭವಿಷ್ಯತಿ? ");
INSERT INTO sankan_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","ಮಮ ಮಿಥ್ಯಾವಾಕ್ಯವದನಾದ್ ಯದೀಶ್ವರಸ್ಯ ಸತ್ಯತ್ವೇನ ತಸ್ಯ ಮಹಿಮಾ ವರ್ದ್ಧತೇ ತರ್ಹಿ ಕಸ್ಮಾದಹಂ ವಿಚಾರೇಽಪರಾಧಿತ್ವೇನ ಗಣ್ಯೋ ಭವಾಮಿ? ");
INSERT INTO sankan_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","ಮಙ್ಗಲಾರ್ಥಂ ಪಾಪಮಪಿ ಕರಣೀಯಮಿತಿ ವಾಕ್ಯಂ ತ್ವಯಾ ಕುತೋ ನೋಚ್ಯತೇ? ಕಿನ್ತು ಯೈರುಚ್ಯತೇ ತೇ ನಿತಾನ್ತಂ ದಣ್ಡಸ್ಯ ಪಾತ್ರಾಣಿ ಭವನ್ತಿ; ತಥಾಪಿ ತದ್ವಾಕ್ಯಮ್ ಅಸ್ಮಾಭಿರಪ್ಯುಚ್ಯತ ಇತ್ಯಸ್ಮಾಕಂ ಗ್ಲಾನಿಂ ಕುರ್ವ್ವನ್ತಃ ಕಿಯನ್ತೋ ಲೋಕಾ ವದನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","ಅನ್ಯಲೋಕೇಭ್ಯೋ ವಯಂ ಕಿಂ ಶ್ರೇಷ್ಠಾಃ? ಕದಾಚನ ನಹಿ ಯತೋ ಯಿಹೂದಿನೋ ಽನ್ಯದೇಶಿನಶ್ಚ ಸರ್ವ್ವಏವ ಪಾಪಸ್ಯಾಯತ್ತಾ ಇತ್ಯಸ್ಯ ಪ್ರಮಾಣಂ ವಯಂ ಪೂರ್ವ್ವಮ್ ಅದದಾಮ| ");
INSERT INTO sankan_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","ಲಿಪಿ ರ್ಯಥಾಸ್ತೇ, ನೈಕೋಪಿ ಧಾರ್ಮ್ಮಿಕೋ ಜನಃ| ");
INSERT INTO sankan_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","ತಥಾ ಜ್ಞಾನೀಶ್ವರಜ್ಞಾನೀ ಮಾನವಃ ಕೋಪಿ ನಾಸ್ತಿ ಹಿ| ");
INSERT INTO sankan_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","ವಿಮಾರ್ಗಗಾಮಿನಃ ಸರ್ವ್ವೇ ಸರ್ವ್ವೇ ದುಷ್ಕರ್ಮ್ಮಕಾರಿಣಃ| ಏಕೋ ಜನೋಪಿ ನೋ ತೇಷಾಂ ಸಾಧುಕರ್ಮ್ಮ ಕರೋತಿ ಚ| ");
INSERT INTO sankan_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","ತಥಾ ತೇಷಾನ್ತು ವೈ ಕಣ್ಠಾ ಅನಾವೃತಶ್ಮಶಾನವತ್| ಸ್ತುತಿವಾದಂ ಪ್ರಕುರ್ವ್ವನ್ತಿ ಜಿಹ್ವಾಭಿಸ್ತೇ ತು ಕೇವಲಂ| ತೇಷಾಮೋಷ್ಠಸ್ಯ ನಿಮ್ನೇ ತು ವಿಷಂ ತಿಷ್ಠತಿ ಸರ್ಪ್ಪವತ್| ");
INSERT INTO sankan_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","ಮುಖಂ ತೇಷಾಂ ಹಿ ಶಾಪೇನ ಕಪಟೇನ ಚ ಪೂರ್ಯ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","ರಕ್ತಪಾತಾಯ ತೇಷಾಂ ತು ಪದಾನಿ ಕ್ಷಿಪ್ರಗಾನಿ ಚ| ");
INSERT INTO sankan_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","ಪಥಿ ತೇಷಾಂ ಮನುಷ್ಯಾಣಾಂ ನಾಶಃ ಕ್ಲೇಶಶ್ಚ ಕೇವಲಃ| ");
INSERT INTO sankan_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","ತೇ ಜನಾ ನಹಿ ಜಾನನ್ತಿ ಪನ್ಥಾನಂ ಸುಖದಾಯಿನಂ| ");
INSERT INTO sankan_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","ಪರಮೇಶಾದ್ ಭಯಂ ಯತ್ತತ್ ತಚ್ಚಕ್ಷುಷೋರಗೋಚರಂ| ");
INSERT INTO sankan_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","ವ್ಯವಸ್ಥಾಯಾಂ ಯದ್ಯಲ್ಲಿಖತಿ ತದ್ ವ್ಯವಸ್ಥಾಧೀನಾನ್ ಲೋಕಾನ್ ಉದ್ದಿಶ್ಯ ಲಿಖತೀತಿ ವಯಂ ಜಾನೀಮಃ| ತತೋ ಮನುಷ್ಯಮಾತ್ರೋ ನಿರುತ್ತರಃ ಸನ್ ಈಶ್ವರಸ್ಯ ಸಾಕ್ಷಾದ್ ಅಪರಾಧೀ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","ಅತಏವ ವ್ಯವಸ್ಥಾನುರೂಪೈಃ ಕರ್ಮ್ಮಭಿಃ ಕಶ್ಚಿದಪಿ ಪ್ರಾಣೀಶ್ವರಸ್ಯ ಸಾಕ್ಷಾತ್ ಸಪುಣ್ಯೀಕೃತೋ ಭವಿತುಂ ನ ಶಕ್ಷ್ಯತಿ ಯತೋ ವ್ಯವಸ್ಥಯಾ ಪಾಪಜ್ಞಾನಮಾತ್ರಂ ಜಾಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","ಕಿನ್ತು ವ್ಯವಸ್ಥಾಯಾಃ ಪೃಥಗ್ ಈಶ್ವರೇಣ ದೇಯಂ ಯತ್ ಪುಣ್ಯಂ ತದ್ ವ್ಯವಸ್ಥಾಯಾ ಭವಿಷ್ಯದ್ವಾದಿಗಣಸ್ಯ ಚ ವಚನೈಃ ಪ್ರಮಾಣೀಕೃತಂ ಸದ್ ಇದಾನೀಂ ಪ್ರಕಾಶತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","ಯೀಶುಖ್ರೀಷ್ಟೇ ವಿಶ್ವಾಸಕರಣಾದ್ ಈಶ್ವರೇಣ ದತ್ತಂ ತತ್ ಪುಣ್ಯಂ ಸಕಲೇಷು ಪ್ರಕಾಶಿತಂ ಸತ್ ಸರ್ವ್ವಾನ್ ವಿಶ್ವಾಸಿನಃ ಪ್ರತಿ ವರ್ತ್ತತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","ತೇಷಾಂ ಕೋಪಿ ಪ್ರಭೇದೋ ನಾಸ್ತಿ, ಯತಃ ಸರ್ವ್ವಏವ ಪಾಪಿನ ಈಶ್ವರೀಯತೇಜೋಹೀನಾಶ್ಚ ಜಾತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","ತ ಈಶ್ವರಸ್ಯಾನುಗ್ರಹಾದ್ ಮೂಲ್ಯಂ ವಿನಾ ಖ್ರೀಷ್ಟಕೃತೇನ ಪರಿತ್ರಾಣೇನ ಸಪುಣ್ಯೀಕೃತಾ ಭವನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","ಯಸ್ಮಾತ್ ಸ್ವಶೋಣಿತೇನ ವಿಶ್ವಾಸಾತ್ ಪಾಪನಾಶಕೋ ಬಲೀ ಭವಿತುಂ ಸ ಏವ ಪೂರ್ವ್ವಮ್ ಈಶ್ವರೇಣ ನಿಶ್ಚಿತಃ, ಇತ್ಥಮ್ ಈಶ್ವರೀಯಸಹಿಷ್ಣುತ್ವಾತ್ ಪುರಾಕೃತಪಾಪಾನಾಂ ಮಾರ್ಜ್ಜನಕರಣೇ ಸ್ವೀಯಯಾಥಾರ್ಥ್ಯಂ ತೇನ ಪ್ರಕಾಶ್ಯತೇ, ");
INSERT INTO sankan_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","ವರ್ತ್ತಮಾನಕಾಲೀಯಮಪಿ ಸ್ವಯಾಥಾರ್ಥ್ಯಂ ತೇನ ಪ್ರಕಾಶ್ಯತೇ, ಅಪರಂ ಯೀಶೌ ವಿಶ್ವಾಸಿನಂ ಸಪುಣ್ಯೀಕುರ್ವ್ವನ್ನಪಿ ಸ ಯಾಥಾರ್ಥಿಕಸ್ತಿಷ್ಠತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","ತರ್ಹಿ ಕುತ್ರಾತ್ಮಶ್ಲಾಘಾ? ಸಾ ದೂರೀಕೃತಾ; ಕಯಾ ವ್ಯವಸ್ಥಯಾ? ಕಿಂ ಕ್ರಿಯಾರೂಪವ್ಯವಸ್ಥಯಾ? ಇತ್ಥಂ ನಹಿ ಕಿನ್ತು ತತ್ ಕೇವಲವಿಶ್ವಾಸರೂಪಯಾ ವ್ಯವಸ್ಥಯೈವ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","ಅತಏವ ವ್ಯವಸ್ಥಾನುರೂಪಾಃ ಕ್ರಿಯಾ ವಿನಾ ಕೇವಲೇನ ವಿಶ್ವಾಸೇನ ಮಾನವಃ ಸಪುಣ್ಯೀಕೃತೋ ಭವಿತುಂ ಶಕ್ನೋತೀತ್ಯಸ್ಯ ರಾದ್ಧಾನ್ತಂ ದರ್ಶಯಾಮಃ| ");
INSERT INTO sankan_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","ಸ ಕಿಂ ಕೇವಲಯಿಹೂದಿನಾಮ್ ಈಶ್ವರೋ ಭವತಿ? ಭಿನ್ನದೇಶಿನಾಮ್ ಈಶ್ವರೋ ನ ಭವತಿ? ಭಿನ್ನದೇಶಿನಾಮಪಿ ಭವತಿ; ");
INSERT INTO sankan_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","ಯಸ್ಮಾದ್ ಏಕ ಈಶ್ವರೋ ವಿಶ್ವಾಸಾತ್ ತ್ವಕ್ಛೇದಿನೋ ವಿಶ್ವಾಸೇನಾತ್ವಕ್ಛೇದಿನಶ್ಚ ಸಪುಣ್ಯೀಕರಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","ತರ್ಹಿ ವಿಶ್ವಾಸೇನ ವಯಂ ಕಿಂ ವ್ಯವಸ್ಥಾಂ ಲುಮ್ಪಾಮ? ಇತ್ಥಂ ನ ಭವತು ವಯಂ ವ್ಯವಸ್ಥಾಂ ಸಂಸ್ಥಾಪಯಾಮ ಏವ| ");
INSERT INTO sankan_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","ಅಸ್ಮಾಕಂ ಪೂರ್ವ್ವಪುರುಷ ಇಬ್ರಾಹೀಮ್ ಕಾಯಿಕಕ್ರಿಯಯಾ ಕಿಂ ಲಬ್ಧವಾನ್ ಏತದಧಿ ಕಿಂ ವದಿಷ್ಯಾಮಃ? ");
INSERT INTO sankan_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","ಸ ಯದಿ ನಿಜಕ್ರಿಯಾಭ್ಯಃ ಸಪುಣ್ಯೋ ಭವೇತ್ ತರ್ಹಿ ತಸ್ಯಾತ್ಮಶ್ಲಾಘಾಂ ಕರ್ತ್ತುಂ ಪನ್ಥಾ ಭವೇದಿತಿ ಸತ್ಯಂ, ಕಿನ್ತ್ವೀಶ್ವರಸ್ಯ ಸಮೀಪೇ ನಹಿ| ");
INSERT INTO sankan_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","ಶಾಸ್ತ್ರೇ ಕಿಂ ಲಿಖತಿ? ಇಬ್ರಾಹೀಮ್ ಈಶ್ವರೇ ವಿಶ್ವಸನಾತ್ ಸ ವಿಶ್ವಾಸಸ್ತಸ್ಮೈ ಪುಣ್ಯಾರ್ಥಂ ಗಣಿತೋ ಬಭೂವ| ");
INSERT INTO sankan_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","ಕರ್ಮ್ಮಕಾರಿಣೋ ಯದ್ ವೇತನಂ ತದ್ ಅನುಗ್ರಹಸ್ಯ ಫಲಂ ನಹಿ ಕಿನ್ತು ತೇನೋಪಾರ್ಜಿತಂ ಮನ್ತವ್ಯಮ್| ");
INSERT INTO sankan_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","ಕಿನ್ತು ಯಃ ಪಾಪಿನಂ ಸಪುಣ್ಯೀಕರೋತಿ ತಸ್ಮಿನ್ ವಿಶ್ವಾಸಿನಃ ಕರ್ಮ್ಮಹೀನಸ್ಯ ಜನಸ್ಯ ಯೋ ವಿಶ್ವಾಸಃ ಸ ಪುಣ್ಯಾರ್ಥಂ ಗಣ್ಯೋ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","ಅಪರಂ ಯಂ ಕ್ರಿಯಾಹೀನಮ್ ಈಶ್ವರಃ ಸಪುಣ್ಯೀಕರೋತಿ ತಸ್ಯ ಧನ್ಯವಾದಂ ದಾಯೂದ್ ವರ್ಣಯಾಮಾಸ, ಯಥಾ, ");
INSERT INTO sankan_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","ಸ ಧನ್ಯೋಽಘಾನಿ ಮೃಷ್ಟಾನಿ ಯಸ್ಯಾಗಾಂಸ್ಯಾವೃತಾನಿ ಚ| ");
INSERT INTO sankan_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","ಸ ಚ ಧನ್ಯಃ ಪರೇಶೇನ ಪಾಪಂ ಯಸ್ಯ ನ ಗಣ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","ಏಷ ಧನ್ಯವಾದಸ್ತ್ವಕ್ಛೇದಿನಮ್ ಅತ್ವಕ್ಛೇದಿನಂ ವಾ ಕಂ ಪ್ರತಿ ಭವತಿ? ಇಬ್ರಾಹೀಮೋ ವಿಶ್ವಾಸಃ ಪುಣ್ಯಾರ್ಥಂ ಗಣಿತ ಇತಿ ವಯಂ ವದಾಮಃ| ");
INSERT INTO sankan_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","ಸ ವಿಶ್ವಾಸಸ್ತಸ್ಯ ತ್ವಕ್ಛೇದಿತ್ವಾವಸ್ಥಾಯಾಂ ಕಿಮ್ ಅತ್ವಕ್ಛೇದಿತ್ವಾವಸ್ಥಾಯಾಂ ಕಸ್ಮಿನ್ ಸಮಯೇ ಪುಣ್ಯಮಿವ ಗಣಿತಃ? ತ್ವಕ್ಛೇದಿತ್ವಾವಸ್ಥಾಯಾಂ ನಹಿ ಕಿನ್ತ್ವತ್ವಕ್ಛೇದಿತ್ವಾವಸ್ಥಾಯಾಂ| ");
INSERT INTO sankan_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","ಅಪರಞ್ಚ ಸ ಯತ್ ಸರ್ವ್ವೇಷಾಮ್ ಅತ್ವಕ್ಛೇದಿನಾಂ ವಿಶ್ವಾಸಿನಾಮ್ ಆದಿಪುರುಷೋ ಭವೇತ್, ತೇ ಚ ಪುಣ್ಯವತ್ತ್ವೇನ ಗಣ್ಯೇರನ್; ");
INSERT INTO sankan_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","ಯೇ ಚ ಲೋಕಾಃ ಕೇವಲಂ ಛಿನ್ನತ್ವಚೋ ನ ಸನ್ತೋ ಽಸ್ಮತ್ಪೂರ್ವ್ವಪುರುಷ ಇಬ್ರಾಹೀಮ್ ಅಛಿನ್ನತ್ವಕ್ ಸನ್ ಯೇನ ವಿಶ್ವಾಸಮಾರ್ಗೇಣ ಗತವಾನ್ ತೇನೈವ ತಸ್ಯ ಪಾದಚಿಹ್ನೇನ ಗಚ್ಛನ್ತಿ ತೇಷಾಂ ತ್ವಕ್ಛೇದಿನಾಮಪ್ಯಾದಿಪುರುಷೋ ಭವೇತ್ ತದರ್ಥಮ್ ಅತ್ವಕ್ಛೇದಿನೋ ಮಾನವಸ್ಯ ವಿಶ್ವಾಸಾತ್ ಪುಣ್ಯಮ್ ಉತ್ಪದ್ಯತ ಇತಿ ಪ್ರಮಾಣಸ್ವರೂಪಂ ತ್ವಕ್ಛೇದಚಿಹ್ನಂ ಸ ಪ್ರಾಪ್ನೋತ್| ");
INSERT INTO sankan_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","ಇಬ್ರಾಹೀಮ್ ಜಗತೋಽಧಿಕಾರೀ ಭವಿಷ್ಯತಿ ಯೈಷಾ ಪ್ರತಿಜ್ಞಾ ತಂ ತಸ್ಯ ವಂಶಞ್ಚ ಪ್ರತಿ ಪೂರ್ವ್ವಮ್ ಅಕ್ರಿಯತ ಸಾ ವ್ಯವಸ್ಥಾಮೂಲಿಕಾ ನಹಿ ಕಿನ್ತು ವಿಶ್ವಾಸಜನ್ಯಪುಣ್ಯಮೂಲಿಕಾ| ");
INSERT INTO sankan_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","ಯತೋ ವ್ಯವಸ್ಥಾವಲಮ್ಬಿನೋ ಯದ್ಯಧಿಕಾರಿಣೋ ಭವನ್ತಿ ತರ್ಹಿ ವಿಶ್ವಾಸೋ ವಿಫಲೋ ಜಾಯತೇ ಸಾ ಪ್ರತಿಜ್ಞಾಪಿ ಲುಪ್ತೈವ| ");
INSERT INTO sankan_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","ಅಧಿಕನ್ತು ವ್ಯವಸ್ಥಾ ಕೋಪಂ ಜನಯತಿ ಯತೋ ಽವಿದ್ಯಮಾನಾಯಾಂ ವ್ಯವಸ್ಥಾಯಾಮ್ ಆಜ್ಞಾಲಙ್ಘನಂ ನ ಸಮ್ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","ಅತಏವ ಸಾ ಪ್ರತಿಜ್ಞಾ ಯದ್ ಅನುಗ್ರಹಸ್ಯ ಫಲಂ ಭವೇತ್ ತದರ್ಥಂ ವಿಶ್ವಾಸಮೂಲಿಕಾ ಯತಸ್ತಥಾತ್ವೇ ತದ್ವಂಶಸಮುದಾಯಂ ಪ್ರತಿ ಅರ್ಥತೋ ಯೇ ವ್ಯವಸ್ಥಯಾ ತದ್ವಂಶಸಮ್ಭವಾಃ ಕೇವಲಂ ತಾನ್ ಪ್ರತಿ ನಹಿ ಕಿನ್ತು ಯ ಇಬ್ರಾಹೀಮೀಯವಿಶ್ವಾಸೇನ ತತ್ಸಮ್ಭವಾಸ್ತಾನಪಿ ಪ್ರತಿ ಸಾ ಪ್ರತಿಜ್ಞಾ ಸ್ಥಾಸ್ನುರ್ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","ಯೋ ನಿರ್ಜೀವಾನ್ ಸಜೀವಾನ್ ಅವಿದ್ಯಮಾನಾನಿ ವಸ್ತೂನಿ ಚ ವಿದ್ಯಮಾನಾನಿ ಕರೋತಿ ಇಬ್ರಾಹೀಮೋ ವಿಶ್ವಾಸಭೂಮೇಸ್ತಸ್ಯೇಶ್ವರಸ್ಯ ಸಾಕ್ಷಾತ್ ಸೋಽಸ್ಮಾಕಂ ಸರ್ವ್ವೇಷಾಮ್ ಆದಿಪುರುಷ ಆಸ್ತೇ, ಯಥಾ ಲಿಖಿತಂ ವಿದ್ಯತೇ, ಅಹಂ ತ್ವಾಂ ಬಹುಜಾತೀನಾಮ್ ಆದಿಪುರುಷಂ ಕೃತ್ವಾ ನಿಯುಕ್ತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","ತ್ವದೀಯಸ್ತಾದೃಶೋ ವಂಶೋ ಜನಿಷ್ಯತೇ ಯದಿದಂ ವಾಕ್ಯಂ ಪ್ರತಿಶ್ರುತಂ ತದನುಸಾರಾದ್ ಇಬ್ರಾಹೀಮ್ ಬಹುದೇಶೀಯಲೋಕಾನಾಮ್ ಆದಿಪುರುಷೋ ಯದ್ ಭವತಿ ತದರ್ಥಂ ಸೋಽನಪೇಕ್ಷಿತವ್ಯಮಪ್ಯಪೇಕ್ಷಮಾಣೋ ವಿಶ್ವಾಸಂ ಕೃತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","ಅಪರಞ್ಚ ಕ್ಷೀಣವಿಶ್ವಾಸೋ ನ ಭೂತ್ವಾ ಶತವತ್ಸರವಯಸ್ಕತ್ವಾತ್ ಸ್ವಶರೀರಸ್ಯ ಜರಾಂ ಸಾರಾನಾಮ್ನಃ ಸ್ವಭಾರ್ಯ್ಯಾಯಾ ರಜೋನಿವೃತ್ತಿಞ್ಚ ತೃಣಾಯ ನ ಮೇನೇ| ");
INSERT INTO sankan_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","ಅಪರಮ್ ಅವಿಶ್ವಾಸಾದ್ ಈಶ್ವರಸ್ಯ ಪ್ರತಿಜ್ಞಾವಚನೇ ಕಮಪಿ ಸಂಶಯಂ ನ ಚಕಾರ; ");
INSERT INTO sankan_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","ಕಿನ್ತ್ವೀಶ್ವರೇಣ ಯತ್ ಪ್ರತಿಶ್ರುತಂ ತತ್ ಸಾಧಯಿತುಂ ಶಕ್ಯತ ಇತಿ ನಿಶ್ಚಿತಂ ವಿಜ್ಞಾಯ ದೃಢವಿಶ್ವಾಸಃ ಸನ್ ಈಶ್ವರಸ್ಯ ಮಹಿಮಾನಂ ಪ್ರಕಾಶಯಾಞ್ಚಕಾರ| ");
INSERT INTO sankan_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","ಇತಿ ಹೇತೋಸ್ತಸ್ಯ ಸ ವಿಶ್ವಾಸಸ್ತದೀಯಪುಣ್ಯಮಿವ ಗಣಯಾಞ್ಚಕ್ರೇ| ");
INSERT INTO sankan_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","ಪುಣ್ಯಮಿವಾಗಣ್ಯತ ತತ್ ಕೇವಲಸ್ಯ ತಸ್ಯ ನಿಮಿತ್ತಂ ಲಿಖಿತಂ ನಹಿ, ಅಸ್ಮಾಕಂ ನಿಮಿತ್ತಮಪಿ, ");
INSERT INTO sankan_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","ಯತೋಽಸ್ಮಾಕಂ ಪಾಪನಾಶಾರ್ಥಂ ಸಮರ್ಪಿತೋಽಸ್ಮಾಕಂ ಪುಣ್ಯಪ್ರಾಪ್ತ್ಯರ್ಥಞ್ಚೋತ್ಥಾಪಿತೋಽಭವತ್ ಯೋಽಸ್ಮಾಕಂ ಪ್ರಭು ರ್ಯೀಶುಸ್ತಸ್ಯೋತ್ಥಾಪಯಿತರೀಶ್ವರೇ ");
INSERT INTO sankan_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","ಯದಿ ವಯಂ ವಿಶ್ವಸಾಮಸ್ತರ್ಹ್ಯಸ್ಮಾಕಮಪಿ ಸಏವ ವಿಶ್ವಾಸಃ ಪುಣ್ಯಮಿವ ಗಣಯಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","ವಿಶ್ವಾಸೇನ ಸಪುಣ್ಯೀಕೃತಾ ವಯಮ್ ಈಶ್ವರೇಣ ಸಾರ್ದ್ಧಂ ಪ್ರಭುಣಾಸ್ಮಾಕಂ ಯೀಶುಖ್ರೀಷ್ಟೇನ ಮೇಲನಂ ಪ್ರಾಪ್ತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","ಅಪರಂ ವಯಂ ಯಸ್ಮಿನ್ ಅನುಗ್ರಹಾಶ್ರಯೇ ತಿಷ್ಠಾಮಸ್ತನ್ಮಧ್ಯಂ ವಿಶ್ವಾಸಮಾರ್ಗೇಣ ತೇನೈವಾನೀತಾ ವಯಮ್ ಈಶ್ವರೀಯವಿಭವಪ್ರಾಪ್ತಿಪ್ರತ್ಯಾಶಯಾ ಸಮಾನನ್ದಾಮಃ| ");
INSERT INTO sankan_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","ತತ್ ಕೇವಲಂ ನಹಿ ಕಿನ್ತು ಕ್ಲೇಶಭೋಗೇಽಪ್ಯಾನನ್ದಾಮೋ ಯತಃ ಕ್ಲೇಶಾाದ್ ಧೈರ್ಯ್ಯಂ ಜಾಯತ ಇತಿ ವಯಂ ಜಾನೀಮಃ, ");
INSERT INTO sankan_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ಧೈರ್ಯ್ಯಾಚ್ಚ ಪರೀಕ್ಷಿತತ್ವಂ ಜಾಯತೇ, ಪರೀಕ್ಷಿತತ್ವಾತ್ ಪ್ರತ್ಯಾಶಾ ಜಾಯತೇ, ");
INSERT INTO sankan_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","ಪ್ರತ್ಯಾಶಾತೋ ವ್ರೀಡಿತತ್ವಂ ನ ಜಾಯತೇ, ಯಸ್ಮಾದ್ ಅಸ್ಮಭ್ಯಂ ದತ್ತೇನ ಪವಿತ್ರೇಣಾತ್ಮನಾಸ್ಮಾಕಮ್ ಅನ್ತಃಕರಣಾನೀಶ್ವರಸ್ಯ ಪ್ರೇಮವಾರಿಣಾ ಸಿಕ್ತಾನಿ| ");
INSERT INTO sankan_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","ಅಸ್ಮಾಸು ನಿರುಪಾಯೇಷು ಸತ್ಸು ಖ್ರೀಷ್ಟ ಉಪಯುಕ್ತೇ ಸಮಯೇ ಪಾಪಿನಾಂ ನಿಮಿತ್ತಂ ಸ್ವೀಯಾನ್ ಪ್ರಣಾನ್ ಅತ್ಯಜತ್| ");
INSERT INTO sankan_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","ಹಿತಕಾರಿಣೋ ಜನಸ್ಯ ಕೃತೇ ಕೋಪಿ ಪ್ರಣಾನ್ ತ್ಯಕ್ತುಂ ಸಾಹಸಂ ಕರ್ತ್ತುಂ ಶಕ್ನೋತಿ, ಕಿನ್ತು ಧಾರ್ಮ್ಮಿಕಸ್ಯ ಕೃತೇ ಪ್ರಾಯೇಣ ಕೋಪಿ ಪ್ರಾಣಾನ್ ನ ತ್ಯಜತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","ಕಿನ್ತ್ವಸ್ಮಾಸು ಪಾಪಿಷು ಸತ್ಸ್ವಪಿ ನಿಮಿತ್ತಮಸ್ಮಾಕಂ ಖ್ರೀಷ್ಟಃ ಸ್ವಪ್ರಾಣಾನ್ ತ್ಯಕ್ತವಾನ್, ತತ ಈಶ್ವರೋಸ್ಮಾನ್ ಪ್ರತಿ ನಿಜಂ ಪರಮಪ್ರೇಮಾಣಂ ದರ್ಶಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","ಅತಏವ ತಸ್ಯ ರಕ್ತಪಾತೇನ ಸಪುಣ್ಯೀಕೃತಾ ವಯಂ ನಿತಾನ್ತಂ ತೇನ ಕೋಪಾದ್ ಉದ್ಧಾರಿಷ್ಯಾಮಹೇ| ");
INSERT INTO sankan_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","ಫಲತೋ ವಯಂ ಯದಾ ರಿಪವ ಆಸ್ಮ ತದೇಶ್ವರಸ್ಯ ಪುತ್ರಸ್ಯ ಮರಣೇನ ತೇನ ಸಾರ್ದ್ಧಂ ಯದ್ಯಸ್ಮಾಕಂ ಮೇಲನಂ ಜಾತಂ ತರ್ಹಿ ಮೇಲನಪ್ರಾಪ್ತಾಃ ಸನ್ತೋಽವಶ್ಯಂ ತಸ್ಯ ಜೀವನೇನ ರಕ್ಷಾಂ ಲಪ್ಸ್ಯಾಮಹೇ| ");
INSERT INTO sankan_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","ತತ್ ಕೇವಲಂ ನಹಿ ಕಿನ್ತು ಯೇನ ಮೇಲನಮ್ ಅಲಭಾಮಹಿ ತೇನಾಸ್ಮಾಕಂ ಪ್ರಭುಣಾ ಯೀಶುಖ್ರೀಷ್ಟೇನ ಸಾಮ್ಪ್ರತಮ್ ಈಶ್ವರೇ ಸಮಾನನ್ದಾಮಶ್ಚ| ");
INSERT INTO sankan_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","ತಥಾ ಸತಿ, ಏಕೇನ ಮಾನುಷೇಣ ಪಾಪಂ ಪಾಪೇನ ಚ ಮರಣಂ ಜಗತೀಂ ಪ್ರಾವಿಶತ್ ಅಪರಂ ಸರ್ವ್ವೇಷಾಂ ಪಾಪಿತ್ವಾತ್ ಸರ್ವ್ವೇ ಮಾನುಷಾ ಮೃತೇ ರ್ನಿಘ್ನಾ ಅಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","ಯತೋ ವ್ಯವಸ್ಥಾದಾನಸಮಯಂ ಯಾವತ್ ಜಗತಿ ಪಾಪಮ್ ಆಸೀತ್ ಕಿನ್ತು ಯತ್ರ ವ್ಯವಸ್ಥಾ ನ ವಿದ್ಯತೇ ತತ್ರ ಪಾಪಸ್ಯಾಪಿ ಗಣನಾ ನ ವಿದ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","ತಥಾಪ್ಯಾದಮಾ ಯಾದೃಶಂ ಪಾಪಂ ಕೃತಂ ತಾದೃಶಂ ಪಾಪಂ ಯೈ ರ್ನಾಕಾರಿ ಆದಮಮ್ ಆರಭ್ಯ ಮೂಸಾಂ ಯಾವತ್ ತೇಷಾಮಪ್ಯುಪರಿ ಮೃತ್ಯೂ ರಾಜತ್ವಮ್ ಅಕರೋತ್ ಸ ಆದಮ್ ಭಾವ್ಯಾದಮೋ ನಿದರ್ಶನಮೇವಾಸ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","ಕಿನ್ತು ಪಾಪಕರ್ಮ್ಮಣೋ ಯಾದೃಶೋ ಭಾವಸ್ತಾದೃಗ್ ದಾನಕರ್ಮ್ಮಣೋ ಭಾವೋ ನ ಭವತಿ ಯತ ಏಕಸ್ಯ ಜನಸ್ಯಾಪರಾಧೇನ ಯದಿ ಬಹೂನಾಂ ಮರಣಮ್ ಅಘಟತ ತಥಾಪೀಶ್ವರಾನುಗ್ರಹಸ್ತದನುಗ್ರಹಮೂಲಕಂ ದಾನಞ್ಚೈಕೇನ ಜನೇನಾರ್ಥಾದ್ ಯೀಶುನಾ ಖ್ರೀಷ್ಟೇನ ಬಹುಷು ಬಾಹುಲ್ಯಾತಿಬಾಹುಲ್ಯೇನ ಫಲತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","ಅಪರಮ್ ಏಕಸ್ಯ ಜನಸ್ಯ ಪಾಪಕರ್ಮ್ಮ ಯಾದೃಕ್ ಫಲಯುಕ್ತಂ ದಾನಕರ್ಮ್ಮ ತಾದೃಕ್ ನ ಭವತಿ ಯತೋ ವಿಚಾರಕರ್ಮ್ಮೈಕಂ ಪಾಪಮ್ ಆರಭ್ಯ ದಣ್ಡಜನಕಂ ಬಭೂವ, ಕಿನ್ತು ದಾನಕರ್ಮ್ಮ ಬಹುಪಾಪಾನ್ಯಾರಭ್ಯ ಪುಣ್ಯಜನಕಂ ಬಭೂವ| ");
INSERT INTO sankan_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","ಯತ ಏಕಸ್ಯ ಜನಸ್ಯ ಪಾಪಕರ್ಮ್ಮತಸ್ತೇನೈಕೇನ ಯದಿ ಮರಣಸ್ಯ ರಾಜತ್ವಂ ಜಾತಂ ತರ್ಹಿ ಯೇ ಜನಾ ಅನುಗ್ರಹಸ್ಯ ಬಾಹುಲ್ಯಂ ಪುಣ್ಯದಾನಞ್ಚ ಪ್ರಾಪ್ನುವನ್ತಿ ತ ಏಕೇನ ಜನೇನ, ಅರ್ಥಾತ್ ಯೀಶುಖ್ರೀಷ್ಟೇನ, ಜೀವನೇ ರಾಜತ್ವಮ್ ಅವಶ್ಯಂ ಕರಿಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","ಏಕೋಽಪರಾಧೋ ಯದ್ವತ್ ಸರ್ವ್ವಮಾನವಾನಾಂ ದಣ್ಡಗಾಮೀ ಮಾರ್ಗೋ ಽಭವತ್ ತದ್ವದ್ ಏಕಂ ಪುಣ್ಯದಾನಂ ಸರ್ವ್ವಮಾನವಾನಾಂ ಜೀವನಯುಕ್ತಪುಣ್ಯಗಾಮೀ ಮಾರ್ಗ ಏವ| ");
INSERT INTO sankan_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","ಅಪರಮ್ ಏಕಸ್ಯ ಜನಸ್ಯಾಜ್ಞಾಲಙ್ಘನಾದ್ ಯಥಾ ಬಹವೋ ಽಪರಾಧಿನೋ ಜಾತಾಸ್ತದ್ವದ್ ಏಕಸ್ಯಾಜ್ಞಾಚರಣಾದ್ ಬಹವಃ ಸಪುಣ್ಯೀಕೃತಾ ಭವನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","ಅಧಿಕನ್ತು ವ್ಯವಸ್ಥಾಗಮನಾದ್ ಅಪರಾಧಸ್ಯ ಬಾಹುಲ್ಯಂ ಜಾತಂ ಕಿನ್ತು ಯತ್ರ ಪಾಪಸ್ಯ ಬಾಹುಲ್ಯಂ ತತ್ರೈವ ತಸ್ಮಾದ್ ಅನುಗ್ರಹಸ್ಯ ಬಾಹುಲ್ಯಮ್ ಅಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","ತೇನ ಮೃತ್ಯುನಾ ಯದ್ವತ್ ಪಾಪಸ್ಯ ರಾಜತ್ವಮ್ ಅಭವತ್ ತದ್ವದ್ ಅಸ್ಮಾಕಂ ಪ್ರಭುಯೀಶುಖ್ರೀಷ್ಟದ್ವಾರಾನನ್ತಜೀವನದಾಯಿಪುಣ್ಯೇನಾನುಗ್ರಹಸ್ಯ ರಾಜತ್ವಂ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","ಪ್ರಭೂತರೂಪೇಣ ಯದ್ ಅನುಗ್ರಹಃ ಪ್ರಕಾಶತೇ ತದರ್ಥಂ ಪಾಪೇ ತಿಷ್ಠಾಮ ಇತಿ ವಾಕ್ಯಂ ಕಿಂ ವಯಂ ವದಿಷ್ಯಾಮಃ? ತನ್ನ ಭವತು| ");
INSERT INTO sankan_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","ಪಾಪಂ ಪ್ರತಿ ಮೃತಾ ವಯಂ ಪುನಸ್ತಸ್ಮಿನ್ ಕಥಮ್ ಜೀವಿಷ್ಯಾಮಃ? ");
INSERT INTO sankan_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","ವಯಂ ಯಾವನ್ತೋ ಲೋಕಾ ಯೀಶುಖ್ರೀಷ್ಟೇ ಮಜ್ಜಿತಾ ಅಭವಾಮ ತಾವನ್ತ ಏವ ತಸ್ಯ ಮರಣೇ ಮಜ್ಜಿತಾ ಇತಿ ಕಿಂ ಯೂಯಂ ನ ಜಾನೀಥ? ");
INSERT INTO sankan_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","ತತೋ ಯಥಾ ಪಿತುಃ ಪರಾಕ್ರಮೇಣ ಶ್ಮಶಾನಾತ್ ಖ್ರೀಷ್ಟ ಉತ್ಥಾಪಿತಸ್ತಥಾ ವಯಮಪಿ ಯತ್ ನೂತನಜೀವಿನ ಇವಾಚರಾಮಸ್ತದರ್ಥಂ ಮಜ್ಜನೇನ ತೇನ ಸಾರ್ದ್ಧಂ ಮೃತ್ಯುರೂಪೇ ಶ್ಮಶಾನೇ ಸಂಸ್ಥಾಪಿತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","ಅಪರಂ ವಯಂ ಯದಿ ತೇನ ಸಂಯುಕ್ತಾಃ ಸನ್ತಃ ಸ ಇವ ಮರಣಭಾಗಿನೋ ಜಾತಾಸ್ತರ್ಹಿ ಸ ಇವೋತ್ಥಾನಭಾಗಿನೋಽಪಿ ಭವಿಷ್ಯಾಮಃ| ");
INSERT INTO sankan_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","ವಯಂ ಯತ್ ಪಾಪಸ್ಯ ದಾಸಾಃ ಪುನ ರ್ನ ಭವಾಮಸ್ತದರ್ಥಮ್ ಅಸ್ಮಾಕಂ ಪಾಪರೂಪಶರೀರಸ್ಯ ವಿನಾಶಾರ್ಥಮ್ ಅಸ್ಮಾಕಂ ಪುರಾತನಪುರುಷಸ್ತೇನ ಸಾಕಂ ಕ್ರುಶೇಽಹನ್ಯತೇತಿ ವಯಂ ಜಾನೀಮಃ| ");
INSERT INTO sankan_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","ಯೋ ಹತಃ ಸ ಪಾಪಾತ್ ಮುಕ್ತ ಏವ| ");
INSERT INTO sankan_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","ಅತಏವ ಯದಿ ವಯಂ ಖ್ರೀಷ್ಟೇನ ಸಾರ್ದ್ಧಮ್ ಅಹನ್ಯಾಮಹಿ ತರ್ಹಿ ಪುನರಪಿ ತೇನ ಸಹಿತಾ ಜೀವಿಷ್ಯಾಮ ಇತ್ಯತ್ರಾಸ್ಮಾಕಂ ವಿಶ್ವಾಸೋ ವಿದ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","ಯತಃ ಶ್ಮಶಾನಾದ್ ಉತ್ಥಾಪಿತಃ ಖ್ರೀಷ್ಟೋ ಪುನ ರ್ನ ಮ್ರಿಯತ ಇತಿ ವಯಂ ಜಾನೀಮಃ| ತಸ್ಮಿನ್ ಕೋಪ್ಯಧಿಕಾರೋ ಮೃತ್ಯೋ ರ್ನಾಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","ಅಪರಞ್ಚ ಸ ಯದ್ ಅಮ್ರಿಯತ ತೇನೈಕದಾ ಪಾಪಮ್ ಉದ್ದಿಶ್ಯಾಮ್ರಿಯತ, ಯಚ್ಚ ಜೀವತಿ ತೇನೇಶ್ವರಮ್ ಉದ್ದಿಶ್ಯ ಜೀವತಿ; ");
INSERT INTO sankan_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","ತದ್ವದ್ ಯೂಯಮಪಿ ಸ್ವಾನ್ ಪಾಪಮ್ ಉದ್ದಿಶ್ಯ ಮೃತಾನ್ ಅಸ್ಮಾಕಂ ಪ್ರಭುಣಾ ಯೀಶುಖ್ರೀಷ್ಟೇನೇಶ್ವರಮ್ ಉದ್ದಿಶ್ಯ ಜೀವನ್ತೋ ಜಾನೀತ| ");
INSERT INTO sankan_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","ಅಪರಞ್ಚ ಕುತ್ಸಿತಾಭಿಲಾಷಾाನ್ ಪೂರಯಿತುಂ ಯುಷ್ಮಾಕಂ ಮರ್ತ್ಯದೇಹೇಷು ಪಾಪಮ್ ಆಧಿಪತ್ಯಂ ನ ಕರೋತು| ");
INSERT INTO sankan_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","ಅಪರಂ ಸ್ವಂ ಸ್ವಮ್ ಅಙ್ಗಮ್ ಅಧರ್ಮ್ಮಸ್ಯಾಸ್ತ್ರಂ ಕೃತ್ವಾ ಪಾಪಸೇವಾಯಾಂ ನ ಸಮರ್ಪಯತ, ಕಿನ್ತು ಶ್ಮಶಾನಾದ್ ಉತ್ಥಿತಾನಿವ ಸ್ವಾನ್ ಈಶ್ವರೇ ಸಮರ್ಪಯತ ಸ್ವಾನ್ಯಙ್ಗಾನಿ ಚ ಧರ್ಮ್ಮಾಸ್ತ್ರಸ್ವರೂಪಾಣೀಶ್ವರಮ್ ಉದ್ದಿಶ್ಯ ಸಮರ್ಪಯತ| ");
INSERT INTO sankan_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","ಯುಷ್ಮಾಕಮ್ ಉಪರಿ ಪಾಪಸ್ಯಾಧಿಪತ್ಯಂ ಪುನ ರ್ನ ಭವಿಷ್ಯತಿ, ಯಸ್ಮಾದ್ ಯೂಯಂ ವ್ಯವಸ್ಥಾಯಾ ಅನಾಯತ್ತಾ ಅನುಗ್ರಹಸ್ಯ ಚಾಯತ್ತಾ ಅಭವತ| ");
INSERT INTO sankan_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","ಕಿನ್ತು ವಯಂ ವ್ಯವಸ್ಥಾಯಾ ಅನಾಯತ್ತಾ ಅನುಗ್ರಹಸ್ಯ ಚಾಯತ್ತಾ ಅಭವಾಮ, ಇತಿ ಕಾರಣಾತ್ ಕಿಂ ಪಾಪಂ ಕರಿಷ್ಯಾಮಃ? ತನ್ನ ಭವತು| ");
INSERT INTO sankan_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","ಯತೋ ಮೃತಿಜನಕಂ ಪಾಪಂ ಪುಣ್ಯಜನಕಂ ನಿದೇಶಾಚರಣಞ್ಚೈತಯೋರ್ದ್ವಯೋ ರ್ಯಸ್ಮಿನ್ ಆಜ್ಞಾಪಾಲನಾರ್ಥಂ ಭೃತ್ಯಾನಿವ ಸ್ವಾನ್ ಸಮರ್ಪಯಥ, ತಸ್ಯೈವ ಭೃತ್ಯಾ ಭವಥ, ಏತತ್ ಕಿಂ ಯೂಯಂ ನ ಜಾನೀಥ? ");
INSERT INTO sankan_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","ಅಪರಞ್ಚ ಪೂರ್ವ್ವಂ ಯೂಯಂ ಪಾಪಸ್ಯ ಭೃತ್ಯಾ ಆಸ್ತೇತಿ ಸತ್ಯಂ ಕಿನ್ತು ಯಸ್ಯಾಂ ಶಿಕ್ಷಾರೂಪಾಯಾಂ ಮೂಷಾಯಾಂ ನಿಕ್ಷಿಪ್ತಾ ಅಭವತ ತಸ್ಯಾ ಆಕೃತಿಂ ಮನೋಭಿ ರ್ಲಬ್ಧವನ್ತ ಇತಿ ಕಾರಣಾದ್ ಈಶ್ವರಸ್ಯ ಧನ್ಯವಾದೋ ಭವತು| ");
INSERT INTO sankan_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","ಇತ್ಥಂ ಯೂಯಂ ಪಾಪಸೇವಾತೋ ಮುಕ್ತಾಃ ಸನ್ತೋ ಧರ್ಮ್ಮಸ್ಯ ಭೃತ್ಯಾ ಜಾತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","ಯುಷ್ಮಾಕಂ ಶಾರೀರಿಕ್ಯಾ ದುರ್ಬ್ಬಲತಾಯಾ ಹೇತೋ ರ್ಮಾನವವದ್ ಅಹಮ್ ಏತದ್ ಬ್ರವೀಮಿ; ಪುನಃ ಪುನರಧರ್ಮ್ಮಕರಣಾರ್ಥಂ ಯದ್ವತ್ ಪೂರ್ವ್ವಂ ಪಾಪಾಮೇಧ್ಯಯೋ ರ್ಭೃತ್ಯತ್ವೇ ನಿಜಾಙ್ಗಾನಿ ಸಮಾರ್ಪಯತ ತದ್ವದ್ ಇದಾನೀಂ ಸಾಧುಕರ್ಮ್ಮಕರಣಾರ್ಥಂ ಧರ್ಮ್ಮಸ್ಯ ಭೃತ್ಯತ್ವೇ ನಿಜಾಙ್ಗಾನಿ ಸಮರ್ಪಯತ| ");
INSERT INTO sankan_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","ಯದಾ ಯೂಯಂ ಪಾಪಸ್ಯ ಭೃತ್ಯಾ ಆಸ್ತ ತದಾ ಧರ್ಮ್ಮಸ್ಯ ನಾಯತ್ತಾ ಆಸ್ತ| ");
INSERT INTO sankan_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","ತರ್ಹಿ ಯಾನಿ ಕರ್ಮ್ಮಾಣಿ ಯೂಯಮ್ ಇದಾನೀಂ ಲಜ್ಜಾಜನಕಾನಿ ಬುಧ್ಯಧ್ವೇ ಪೂರ್ವ್ವಂ ತೈ ರ್ಯುಷ್ಮಾಕಂ ಕೋ ಲಾಭ ಆಸೀತ್? ತೇಷಾಂ ಕರ್ಮ್ಮಣಾಂ ಫಲಂ ಮರಣಮೇವ| ");
INSERT INTO sankan_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","ಕಿನ್ತು ಸಾಮ್ಪ್ರತಂ ಯೂಯಂ ಪಾಪಸೇವಾತೋ ಮುಕ್ತಾಃ ಸನ್ತ ಈಶ್ವರಸ್ಯ ಭೃತ್ಯಾಽಭವತ ತಸ್ಮಾದ್ ಯುಷ್ಮಾಕಂ ಪವಿತ್ರತ್ವರೂಪಂ ಲಭ್ಯಮ್ ಅನನ್ತಜೀವನರೂಪಞ್ಚ ಫಲಮ್ ಆಸ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","ಯತಃ ಪಾಪಸ್ಯ ವೇತನಂ ಮರಣಂ ಕಿನ್ತ್ವಸ್ಮಾಕಂ ಪ್ರಭುಣಾ ಯೀಶುಖ್ರೀಷ್ಟೇನಾನನ್ತಜೀವನಮ್ ಈಶ್ವರದತ್ತಂ ಪಾರಿತೋಷಿಕಮ್ ಆಸ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","ಹೇ ಭ್ರಾತೃಗಣ ವ್ಯವಸ್ಥಾವಿದಃ ಪ್ರತಿ ಮಮೇದಂ ನಿವೇದನಂ| ವಿಧಿಃ ಕೇವಲಂ ಯಾವಜ್ಜೀವಂ ಮಾನವೋಪರ್ಯ್ಯಧಿಪತಿತ್ವಂ ಕರೋತೀತಿ ಯೂಯಂ ಕಿಂ ನ ಜಾನೀಥ? ");
INSERT INTO sankan_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","ಯಾವತ್ಕಾಲಂ ಪತಿ ರ್ಜೀವತಿ ತಾವತ್ಕಾಲಮ್ ಊಢಾ ಭಾರ್ಯ್ಯಾ ವ್ಯವಸ್ಥಯಾ ತಸ್ಮಿನ್ ಬದ್ಧಾ ತಿಷ್ಠತಿ ಕಿನ್ತು ಯದಿ ಪತಿ ರ್ಮ್ರಿಯತೇ ತರ್ಹಿ ಸಾ ನಾರೀ ಪತ್ಯು ರ್ವ್ಯವಸ್ಥಾತೋ ಮುಚ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","ಏತತ್ಕಾರಣಾತ್ ಪತ್ಯುರ್ಜೀವನಕಾಲೇ ನಾರೀ ಯದ್ಯನ್ಯಂ ಪುರುಷಂ ವಿವಹತಿ ತರ್ಹಿ ಸಾ ವ್ಯಭಿಚಾರಿಣೀ ಭವತಿ ಕಿನ್ತು ಯದಿ ಸ ಪತಿ ರ್ಮ್ರಿಯತೇ ತರ್ಹಿ ಸಾ ತಸ್ಯಾ ವ್ಯವಸ್ಥಾಯಾ ಮುಕ್ತಾ ಸತೀ ಪುರುಷಾನ್ತರೇಣ ವ್ಯೂಢಾಪಿ ವ್ಯಭಿಚಾರಿಣೀ ನ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","ಹೇ ಮಮ ಭ್ರಾತೃಗಣ, ಈಶ್ವರನಿಮಿತ್ತಂ ಯದಸ್ಮಾಕಂ ಫಲಂ ಜಾಯತೇ ತದರ್ಥಂ ಶ್ಮಶಾನಾದ್ ಉತ್ಥಾಪಿತೇನ ಪುರುಷೇಣ ಸಹ ಯುಷ್ಮಾಕಂ ವಿವಾಹೋ ಯದ್ ಭವೇತ್ ತದರ್ಥಂ ಖ್ರೀಷ್ಟಸ್ಯ ಶರೀರೇಣ ಯೂಯಂ ವ್ಯವಸ್ಥಾಂ ಪ್ರತಿ ಮೃತವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","ಯತೋಽಸ್ಮಾಕಂ ಶಾರೀರಿಕಾಚರಣಸಮಯೇ ಮರಣನಿಮಿತ್ತಂ ಫಲಮ್ ಉತ್ಪಾದಯಿತುಂ ವ್ಯವಸ್ಥಯಾ ದೂಷಿತಃ ಪಾಪಾಭಿಲಾಷೋಽಸ್ಮಾಕಮ್ ಅಙ್ಗೇಷು ಜೀವನ್ ಆಸೀತ್| ");
INSERT INTO sankan_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","ಕಿನ್ತು ತದಾ ಯಸ್ಯಾ ವ್ಯವಸ್ಥಾಯಾ ವಶೇ ಆಸ್ಮಹಿ ಸಾಮ್ಪ್ರತಂ ತಾಂ ಪ್ರತಿ ಮೃತತ್ವಾದ್ ವಯಂ ತಸ್ಯಾ ಅಧೀನತ್ವಾತ್ ಮುಕ್ತಾ ಇತಿ ಹೇತೋರೀಶ್ವರೋಽಸ್ಮಾಭಿಃ ಪುರಾತನಲಿಖಿತಾನುಸಾರಾತ್ ನ ಸೇವಿತವ್ಯಃ ಕಿನ್ತು ನವೀನಸ್ವಭಾವೇನೈವ ಸೇವಿತವ್ಯಃ ");
INSERT INTO sankan_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","ತರ್ಹಿ ವಯಂ ಕಿಂ ಬ್ರೂಮಃ? ವ್ಯವಸ್ಥಾ ಕಿಂ ಪಾಪಜನಿಕಾ ಭವತಿ? ನೇತ್ಥಂ ಭವತು| ವ್ಯವಸ್ಥಾಮ್ ಅವಿದ್ಯಮಾನಾಯಾಂ ಪಾಪಂ ಕಿಮ್ ಇತ್ಯಹಂ ನಾವೇದಂ; ಕಿಞ್ಚ ಲೋಭಂ ಮಾ ಕಾರ್ಷೀರಿತಿ ಚೇದ್ ವ್ಯವಸ್ಥಾಗ್ರನ್ಥೇ ಲಿಖಿತಂ ನಾಭವಿಷ್ಯತ್ ತರ್ಹಿ ಲೋಭಃ ಕಿಮ್ಭೂತಸ್ತದಹಂ ನಾಜ್ಞಾಸ್ಯಂ| ");
INSERT INTO sankan_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","ಕಿನ್ತು ವ್ಯವಸ್ಥಯಾ ಪಾಪಂ ಛಿದ್ರಂ ಪ್ರಾಪ್ಯಾಸ್ಮಾಕಮ್ ಅನ್ತಃ ಸರ್ವ್ವವಿಧಂ ಕುತ್ಸಿತಾಭಿಲಾಷಮ್ ಅಜನಯತ್; ಯತೋ ವ್ಯವಸ್ಥಾಯಾಮ್ ಅವಿದ್ಯಮಾನಾಯಾಂ ಪಾಪಂ ಮೃತಂ| ");
INSERT INTO sankan_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","ಅಪರಂ ಪೂರ್ವ್ವಂ ವ್ಯವಸ್ಥಾಯಾಮ್ ಅವಿದ್ಯಮಾನಾಯಾಮ್ ಅಹಮ್ ಅಜೀವಂ ತತಃ ಪರಮ್ ಆಜ್ಞಾಯಾಮ್ ಉಪಸ್ಥಿತಾಯಾಮ್ ಪಾಪಮ್ ಅಜೀವತ್ ತದಾಹಮ್ ಅಮ್ರಿಯೇ| ");
INSERT INTO sankan_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","ಇತ್ಥಂ ಸತಿ ಜೀವನನಿಮಿತ್ತಾ ಯಾಜ್ಞಾ ಸಾ ಮಮ ಮೃತ್ಯುಜನಿಕಾಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","ಯತಃ ಪಾಪಂ ಛಿದ್ರಂ ಪ್ರಾಪ್ಯ ವ್ಯವಸ್ಥಿತಾದೇಶೇನ ಮಾಂ ವಞ್ಚಯಿತ್ವಾ ತೇನ ಮಾಮ್ ಅಹನ್| ");
INSERT INTO sankan_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","ಅತಏವ ವ್ಯವಸ್ಥಾ ಪವಿತ್ರಾ, ಆದೇಶಶ್ಚ ಪವಿತ್ರೋ ನ್ಯಾಯ್ಯೋ ಹಿತಕಾರೀ ಚ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","ತರ್ಹಿ ಯತ್ ಸ್ವಯಂ ಹಿತಕೃತ್ ತತ್ ಕಿಂ ಮಮ ಮೃತ್ಯುಜನಕಮ್ ಅಭವತ್? ನೇತ್ಥಂ ಭವತು; ಕಿನ್ತು ಪಾಪಂ ಯತ್ ಪಾತಕಮಿವ ಪ್ರಕಾಶತೇ ತಥಾ ನಿದೇಶೇನ ಪಾಪಂ ಯದತೀವ ಪಾತಕಮಿವ ಪ್ರಕಾಶತೇ ತದರ್ಥಂ ಹಿತೋಪಾಯೇನ ಮಮ ಮರಣಮ್ ಅಜನಯತ್| ");
INSERT INTO sankan_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","ವ್ಯವಸ್ಥಾತ್ಮಬೋಧಿಕೇತಿ ವಯಂ ಜಾನೀಮಃ ಕಿನ್ತ್ವಹಂ ಶಾರೀರತಾಚಾರೀ ಪಾಪಸ್ಯ ಕ್ರೀತಕಿಙ್ಕರೋ ವಿದ್ಯೇ| ");
INSERT INTO sankan_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","ಯತೋ ಯತ್ ಕರ್ಮ್ಮ ಕರೋಮಿ ತತ್ ಮಮ ಮನೋಽಭಿಮತಂ ನಹಿ; ಅಪರಂ ಯನ್ ಮಮ ಮನೋಽಭಿಮತಂ ತನ್ನ ಕರೋಮಿ ಕಿನ್ತು ಯದ್ ಋತೀಯೇ ತತ್ ಕರೋಮಿ| ");
INSERT INTO sankan_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","ತಥಾತ್ವೇ ಯನ್ ಮಮಾನಭಿಮತಂ ತದ್ ಯದಿ ಕರೋಮಿ ತರ್ಹಿ ವ್ಯವಸ್ಥಾ ಸೂತ್ತಮೇತಿ ಸ್ವೀಕರೋಮಿ| ");
INSERT INTO sankan_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","ಅತಏವ ಸಮ್ಪ್ರತಿ ತತ್ ಕರ್ಮ್ಮ ಮಯಾ ಕ್ರಿಯತ ಇತಿ ನಹಿ ಕಿನ್ತು ಮಮ ಶರೀರಸ್ಥೇನ ಪಾಪೇನೈವ ಕ್ರಿಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","ಯತೋ ಮಯಿ, ಅರ್ಥತೋ ಮಮ ಶರೀರೇ, ಕಿಮಪ್ಯುತ್ತಮಂ ನ ವಸತಿ, ಏತದ್ ಅಹಂ ಜಾನಾಮಿ; ಮಮೇಚ್ಛುಕತಾಯಾಂ ತಿಷ್ಠನ್ತ್ಯಾಮಪ್ಯಹಮ್ ಉತ್ತಮಕರ್ಮ್ಮಸಾಧನೇ ಸಮರ್ಥೋ ನ ಭವಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","ಯತೋ ಯಾಮುತ್ತಮಾಂ ಕ್ರಿಯಾಂ ಕರ್ತ್ತುಮಹಂ ವಾಞ್ಛಾಮಿ ತಾಂ ನ ಕರೋಮಿ ಕಿನ್ತು ಯತ್ ಕುತ್ಸಿತಂ ಕರ್ಮ್ಮ ಕರ್ತ್ತುಮ್ ಅನಿಚ್ಛುಕೋಽಸ್ಮಿ ತದೇವ ಕರೋಮಿ| ");
INSERT INTO sankan_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","ಅತಏವ ಯದ್ಯತ್ ಕರ್ಮ್ಮ ಕರ್ತ್ತುಂ ಮಮೇಚ್ಛಾ ನ ಭವತಿ ತದ್ ಯದಿ ಕರೋಮಿ ತರ್ಹಿ ತತ್ ಮಯಾ ನ ಕ್ರಿಯತೇ, ಮಮಾನ್ತರ್ವರ್ತ್ತಿನಾ ಪಾಪೇನೈವ ಕ್ರಿಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","ಭದ್ರಂ ಕರ್ತ್ತುಮ್ ಇಚ್ಛುಕಂ ಮಾಂ ಯೋ ಽಭದ್ರಂ ಕರ್ತ್ತುಂ ಪ್ರವರ್ತ್ತಯತಿ ತಾದೃಶಂ ಸ್ವಭಾವಮೇಕಂ ಮಯಿ ಪಶ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","ಅಹಮ್ ಆನ್ತರಿಕಪುರುಷೇಣೇಶ್ವರವ್ಯವಸ್ಥಾಯಾಂ ಸನ್ತುಷ್ಟ ಆಸೇ; ");
INSERT INTO sankan_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","ಕಿನ್ತು ತದ್ವಿಪರೀತಂ ಯುಧ್ಯನ್ತಂ ತದನ್ಯಮೇಕಂ ಸ್ವಭಾವಂ ಮದೀಯಾಙ್ಗಸ್ಥಿತಂ ಪ್ರಪಶ್ಯಾಮಿ, ಸ ಮದೀಯಾಙ್ಗಸ್ಥಿತಪಾಪಸ್ವಭಾವಸ್ಯಾಯತ್ತಂ ಮಾಂ ಕರ್ತ್ತುಂ ಚೇಷ್ಟತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","ಹಾ ಹಾ ಯೋಽಹಂ ದುರ್ಭಾಗ್ಯೋ ಮನುಜಸ್ತಂ ಮಾಮ್ ಏತಸ್ಮಾನ್ ಮೃತಾಚ್ಛರೀರಾತ್ ಕೋ ನಿಸ್ತಾರಯಿಷ್ಯತಿ? ");
INSERT INTO sankan_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","ಅಸ್ಮಾಕಂ ಪ್ರಭುಣಾ ಯೀಶುಖ್ರೀಷ್ಟೇನ ನಿಸ್ತಾರಯಿತಾರಮ್ ಈಶ್ವರಂ ಧನ್ಯಂ ವದಾಮಿ| ಅತಏವ ಶರೀರೇಣ ಪಾಪವ್ಯವಸ್ಥಾಯಾ ಮನಸಾ ತು ಈಶ್ವರವ್ಯವಸ್ಥಾಯಾಃ ಸೇವನಂ ಕರೋಮಿ| ");
INSERT INTO sankan_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","ಯೇ ಜನಾಃ ಖ್ರೀಷ್ಟಂ ಯೀಶುಮ್ ಆಶ್ರಿತ್ಯ ಶಾರೀರಿಕಂ ನಾಚರನ್ತ ಆತ್ಮಿಕಮಾಚರನ್ತಿ ತೇಽಧುನಾ ದಣ್ಡಾರ್ಹಾ ನ ಭವನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","ಜೀವನದಾಯಕಸ್ಯಾತ್ಮನೋ ವ್ಯವಸ್ಥಾ ಖ್ರೀಷ್ಟಯೀಶುನಾ ಪಾಪಮರಣಯೋ ರ್ವ್ಯವಸ್ಥಾತೋ ಮಾಮಮೋಚಯತ್| ");
INSERT INTO sankan_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","ಯಸ್ಮಾಚ್ಛಾರೀರಸ್ಯ ದುರ್ಬ್ಬಲತ್ವಾದ್ ವ್ಯವಸ್ಥಯಾ ಯತ್ ಕರ್ಮ್ಮಾಸಾಧ್ಯಮ್ ಈಶ್ವರೋ ನಿಜಪುತ್ರಂ ಪಾಪಿಶರೀರರೂಪಂ ಪಾಪನಾಶಕಬಲಿರೂಪಞ್ಚ ಪ್ರೇಷ್ಯ ತಸ್ಯ ಶರೀರೇ ಪಾಪಸ್ಯ ದಣ್ಡಂ ಕುರ್ವ್ವನ್ ತತ್ಕರ್ಮ್ಮ ಸಾಧಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","ತತಃ ಶಾರೀರಿಕಂ ನಾಚರಿತ್ವಾಸ್ಮಾಭಿರಾತ್ಮಿಕಮ್ ಆಚರದ್ಭಿರ್ವ್ಯವಸ್ಥಾಗ್ರನ್ಥೇ ನಿರ್ದ್ದಿಷ್ಟಾನಿ ಪುಣ್ಯಕರ್ಮ್ಮಾಣಿ ಸರ್ವ್ವಾಣಿ ಸಾಧ್ಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","ಯೇ ಶಾರೀರಿಕಾಚಾರಿಣಸ್ತೇ ಶಾರೀರಿಕಾನ್ ವಿಷಯಾನ್ ಭಾವಯನ್ತಿ ಯೇ ಚಾತ್ಮಿಕಾಚಾರಿಣಸ್ತೇ ಆತ್ಮನೋ ವಿಷಯಾನ್ ಭಾವಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","ಶಾರೀರಿಕಭಾವಸ್ಯ ಫಲಂ ಮೃತ್ಯುಃ ಕಿಞ್ಚಾತ್ಮಿಕಭಾವಸ್ಯ ಫಲೇ ಜೀವನಂ ಶಾನ್ತಿಶ್ಚ| ");
INSERT INTO sankan_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","ಯತಃ ಶಾರೀರಿಕಭಾವ ಈಶ್ವರಸ್ಯ ವಿರುದ್ಧಃ ಶತ್ರುತಾಭಾವ ಏವ ಸ ಈಶ್ವರಸ್ಯ ವ್ಯವಸ್ಥಾಯಾ ಅಧೀನೋ ನ ಭವತಿ ಭವಿತುಞ್ಚ ನ ಶಕ್ನೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","ಏತಸ್ಮಾತ್ ಶಾರೀರಿಕಾಚಾರಿಷು ತೋಷ್ಟುಮ್ ಈಶ್ವರೇಣ ನ ಶಕ್ಯಂ| ");
INSERT INTO sankan_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","ಕಿನ್ತ್ವೀಶ್ವರಸ್ಯಾತ್ಮಾ ಯದಿ ಯುಷ್ಮಾಕಂ ಮಧ್ಯೇ ವಸತಿ ತರ್ಹಿ ಯೂಯಂ ಶಾರೀರಿಕಾಚಾರಿಣೋ ನ ಸನ್ತ ಆತ್ಮಿಕಾಚಾರಿಣೋ ಭವಥಃ| ಯಸ್ಮಿನ್ ತು ಖ್ರೀಷ್ಟಸ್ಯಾತ್ಮಾ ನ ವಿದ್ಯತೇ ಸ ತತ್ಸಮ್ಭವೋ ನಹಿ| ");
INSERT INTO sankan_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","ಯದಿ ಖ್ರೀಷ್ಟೋ ಯುಷ್ಮಾನ್ ಅಧಿತಿಷ್ಠತಿ ತರ್ಹಿ ಪಾಪಮ್ ಉದ್ದಿಶ್ಯ ಶರೀರಂ ಮೃತಂ ಕಿನ್ತು ಪುಣ್ಯಮುದ್ದಿಶ್ಯಾತ್ಮಾ ಜೀವತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","ಮೃತಗಣಾದ್ ಯೀಶು ರ್ಯೇನೋತ್ಥಾಪಿತಸ್ತಸ್ಯಾತ್ಮಾ ಯದಿ ಯುಷ್ಮನ್ಮಧ್ಯೇ ವಸತಿ ತರ್ಹಿ ಮೃತಗಣಾತ್ ಖ್ರೀಷ್ಟಸ್ಯ ಸ ಉತ್ಥಾಪಯಿತಾ ಯುಷ್ಮನ್ಮಧ್ಯವಾಸಿನಾ ಸ್ವಕೀಯಾತ್ಮನಾ ಯುಷ್ಮಾಕಂ ಮೃತದೇಹಾನಪಿ ಪುನ ರ್ಜೀವಯಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","ಹೇ ಭ್ರಾತೃಗಣ ಶರೀರಸ್ಯ ವಯಮಧಮರ್ಣಾ ನ ಭವಾಮೋಽತಃ ಶಾರೀರಿಕಾಚಾರೋಽಸ್ಮಾಭಿ ರ್ನ ಕರ್ತ್ತವ್ಯಃ| ");
INSERT INTO sankan_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","ಯದಿ ಯೂಯಂ ಶರೀರಿಕಾಚಾರಿಣೋ ಭವೇತ ತರ್ಹಿ ಯುಷ್ಮಾಭಿ ರ್ಮರ್ತ್ತವ್ಯಮೇವ ಕಿನ್ತ್ವಾತ್ಮನಾ ಯದಿ ಶರೀರಕರ್ಮ್ಮಾಣಿ ಘಾತಯೇತ ತರ್ಹಿ ಜೀವಿಷ್ಯಥ| ");
INSERT INTO sankan_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","ಯತೋ ಯಾವನ್ತೋ ಲೋಕಾ ಈಶ್ವರಸ್ಯಾತ್ಮನಾಕೃಷ್ಯನ್ತೇ ತೇ ಸರ್ವ್ವ ಈಶ್ವರಸ್ಯ ಸನ್ತಾನಾ ಭವನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","ಯೂಯಂ ಪುನರಪಿ ಭಯಜನಕಂ ದಾಸ್ಯಭಾವಂ ನ ಪ್ರಾಪ್ತಾಃ ಕಿನ್ತು ಯೇನ ಭಾವೇನೇಶ್ವರಂ ಪಿತಃ ಪಿತರಿತಿ ಪ್ರೋಚ್ಯ ಸಮ್ಬೋಧಯಥ ತಾದೃಶಂ ದತ್ತಕಪುತ್ರತ್ವಭಾವಮ್ ಪ್ರಾಪ್ನುತ| ");
INSERT INTO sankan_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","ಅಪರಞ್ಚ ವಯಮ್ ಈಶ್ವರಸ್ಯ ಸನ್ತಾನಾ ಏತಸ್ಮಿನ್ ಪವಿತ್ರ ಆತ್ಮಾ ಸ್ವಯಮ್ ಅಸ್ಮಾಕಮ್ ಆತ್ಮಾಭಿಃ ಸಾರ್ದ್ಧಂ ಪ್ರಮಾಣಂ ದದಾತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","ಅತಏವ ವಯಂ ಯದಿ ಸನ್ತಾನಾಸ್ತರ್ಹ್ಯಧಿಕಾರಿಣಃ, ಅರ್ಥಾದ್ ಈಶ್ವರಸ್ಯ ಸ್ವತ್ತ್ವಾಧಿಕಾರಿಣಃ ಖ್ರೀಷ್ಟೇನ ಸಹಾಧಿಕಾರಿಣಶ್ಚ ಭವಾಮಃ; ಅಪರಂ ತೇನ ಸಾರ್ದ್ಧಂ ಯದಿ ದುಃಖಭಾಗಿನೋ ಭವಾಮಸ್ತರ್ಹಿ ತಸ್ಯ ವಿಭವಸ್ಯಾಪಿ ಭಾಗಿನೋ ಭವಿಷ್ಯಾಮಃ| ");
INSERT INTO sankan_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","ಕಿನ್ತ್ವಸ್ಮಾಸು ಯೋ ಭಾವೀವಿಭವಃ ಪ್ರಕಾಶಿಷ್ಯತೇ ತಸ್ಯ ಸಮೀಪೇ ವರ್ತ್ತಮಾನಕಾಲೀನಂ ದುಃಖಮಹಂ ತೃಣಾಯ ಮನ್ಯೇ| ");
INSERT INTO sankan_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","ಯತಃ ಪ್ರಾಣಿಗಣ ಈಶ್ವರಸ್ಯ ಸನ್ತಾನಾನಾಂ ವಿಭವಪ್ರಾಪ್ತಿಮ್ ಆಕಾಙ್ಕ್ಷನ್ ನಿತಾನ್ತಮ್ ಅಪೇಕ್ಷತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","ಅಪರಞ್ಚ ಪ್ರಾಣಿಗಣಃ ಸ್ವೈರಮ್ ಅಲೀಕತಾಯಾ ವಶೀಕೃತೋ ನಾಭವತ್ ");
INSERT INTO sankan_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","ಕಿನ್ತು ಪ್ರಾಣಿಗಣೋಽಪಿ ನಶ್ವರತಾಧೀನತ್ವಾತ್ ಮುಕ್ತಃ ಸನ್ ಈಶ್ವರಸ್ಯ ಸನ್ತಾನಾನಾಂ ಪರಮಮುಕ್ತಿಂ ಪ್ರಾಪ್ಸ್ಯತೀತ್ಯಭಿಪ್ರಾಯೇಣ ವಶೀಕರ್ತ್ರಾ ವಶೀಚಕ್ರೇ| ");
INSERT INTO sankan_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","ಅಪರಞ್ಚ ಪ್ರಸೂಯಮಾನಾವದ್ ವ್ಯಥಿತಃ ಸನ್ ಇದಾನೀಂ ಯಾವತ್ ಕೃತ್ಸ್ನಃ ಪ್ರಾಣಿಗಣ ಆರ್ತ್ತಸ್ವರಂ ಕರೋತೀತಿ ವಯಂ ಜಾನೀಮಃ| ");
INSERT INTO sankan_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","ಕೇವಲಃ ಸ ಇತಿ ನಹಿ ಕಿನ್ತು ಪ್ರಥಮಜಾತಫಲಸ್ವರೂಪಮ್ ಆತ್ಮಾನಂ ಪ್ರಾಪ್ತಾ ವಯಮಪಿ ದತ್ತಕಪುತ್ರತ್ವಪದಪ್ರಾಪ್ತಿಮ್ ಅರ್ಥಾತ್ ಶರೀರಸ್ಯ ಮುಕ್ತಿಂ ಪ್ರತೀಕ್ಷಮಾಣಾಸ್ತದ್ವದ್ ಅನ್ತರಾರ್ತ್ತರಾವಂ ಕುರ್ಮ್ಮಃ| ");
INSERT INTO sankan_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","ವಯಂ ಪ್ರತ್ಯಾಶಯಾ ತ್ರಾಣಮ್ ಅಲಭಾಮಹಿ ಕಿನ್ತು ಪ್ರತ್ಯಕ್ಷವಸ್ತುನೋ ಯಾ ಪ್ರತ್ಯಾಶಾ ಸಾ ಪ್ರತ್ಯಾಶಾ ನಹಿ, ಯತೋ ಮನುಷ್ಯೋ ಯತ್ ಸಮೀಕ್ಷತೇ ತಸ್ಯ ಪ್ರತ್ಯಾಶಾಂ ಕುತಃ ಕರಿಷ್ಯತಿ? ");
INSERT INTO sankan_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","ಯದ್ ಅಪ್ರತ್ಯಕ್ಷಂ ತಸ್ಯ ಪ್ರತ್ಯಾಶಾಂ ಯದಿ ವಯಂ ಕುರ್ವ್ವೀಮಹಿ ತರ್ಹಿ ಧೈರ್ಯ್ಯಮ್ ಅವಲಮ್ಬ್ಯ ಪ್ರತೀಕ್ಷಾಮಹೇ| ");
INSERT INTO sankan_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","ತತ ಆತ್ಮಾಪಿ ಸ್ವಯಮ್ ಅಸ್ಮಾಕಂ ದುರ್ಬ್ಬಲತಾಯಾಃ ಸಹಾಯತ್ವಂ ಕರೋತಿ; ಯತಃ ಕಿಂ ಪ್ರಾರ್ಥಿತವ್ಯಂ ತದ್ ಬೋದ್ಧುಂ ವಯಂ ನ ಶಕ್ನುಮಃ, ಕಿನ್ತ್ವಸ್ಪಷ್ಟೈರಾರ್ತ್ತರಾವೈರಾತ್ಮಾ ಸ್ವಯಮ್ ಅಸ್ಮನ್ನಿಮಿತ್ತಂ ನಿವೇದಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","ಅಪರಮ್ ಈಶ್ವರಾಭಿಮತರೂಪೇಣ ಪವಿತ್ರಲೋಕಾನಾಂ ಕೃತೇ ನಿವೇದಯತಿ ಯ ಆತ್ಮಾ ತಸ್ಯಾಭಿಪ್ರಾಯೋಽನ್ತರ್ಯ್ಯಾಮಿನಾ ಜ್ಞಾಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","ಅಪರಮ್ ಈಶ್ವರೀಯನಿರೂಪಣಾನುಸಾರೇಣಾಹೂತಾಃ ಸನ್ತೋ ಯೇ ತಸ್ಮಿನ್ ಪ್ರೀಯನ್ತೇ ಸರ್ವ್ವಾಣಿ ಮಿಲಿತ್ವಾ ತೇಷಾಂ ಮಙ್ಗಲಂ ಸಾಧಯನ್ತಿ, ಏತದ್ ವಯಂ ಜಾನೀಮಃ| ");
INSERT INTO sankan_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","ಯತ ಈಶ್ವರೋ ಬಹುಭ್ರಾತೃಣಾಂ ಮಧ್ಯೇ ಸ್ವಪುತ್ರಂ ಜ್ಯೇಷ್ಠಂ ಕರ್ತ್ತುಮ್ ಇಚ್ಛನ್ ಯಾನ್ ಪೂರ್ವ್ವಂ ಲಕ್ಷ್ಯೀಕೃತವಾನ್ ತಾನ್ ತಸ್ಯ ಪ್ರತಿಮೂರ್ತ್ಯಾಃ ಸಾದೃಶ್ಯಪ್ರಾಪ್ತ್ಯರ್ಥಂ ನ್ಯಯುಂಕ್ತ| ");
INSERT INTO sankan_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","ಅಪರಞ್ಚ ತೇನ ಯೇ ನಿಯುಕ್ತಾಸ್ತ ಆಹೂತಾ ಅಪಿ ಯೇ ಚ ತೇನಾಹೂತಾಸ್ತೇ ಸಪುಣ್ಯೀಕೃತಾಃ, ಯೇ ಚ ತೇನ ಸಪುಣ್ಯೀಕೃತಾಸ್ತೇ ವಿಭವಯುಕ್ತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","ಇತ್ಯತ್ರ ವಯಂ ಕಿಂ ಬ್ರೂಮಃ? ಈಶ್ವರೋ ಯದ್ಯಸ್ಮಾಕಂ ಸಪಕ್ಷೋ ಭವತಿ ತರ್ಹಿ ಕೋ ವಿಪಕ್ಷೋಽಸ್ಮಾಕಂ? ");
INSERT INTO sankan_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","ಆತ್ಮಪುತ್ರಂ ನ ರಕ್ಷಿತ್ವಾ ಯೋಽಸ್ಮಾಕಂ ಸರ್ವ್ವೇಷಾಂ ಕೃತೇ ತಂ ಪ್ರದತ್ತವಾನ್ ಸ ಕಿಂ ತೇನ ಸಹಾಸ್ಮಭ್ಯಮ್ ಅನ್ಯಾನಿ ಸರ್ವ್ವಾಣಿ ನ ದಾಸ್ಯತಿ? ");
INSERT INTO sankan_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","ಈಶ್ವರಸ್ಯಾಭಿರುಚಿತೇಷು ಕೇನ ದೋಷ ಆರೋಪಯಿಷ್ಯತೇ? ಯ ಈಶ್ವರಸ್ತಾನ್ ಪುಣ್ಯವತ ಇವ ಗಣಯತಿ ಕಿಂ ತೇನ? ");
INSERT INTO sankan_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","ಅಪರಂ ತೇಭ್ಯೋ ದಣ್ಡದಾನಾಜ್ಞಾ ವಾ ಕೇನ ಕರಿಷ್ಯತೇ? ಯೋಽಸ್ಮನ್ನಿಮಿತ್ತಂ ಪ್ರಾಣಾನ್ ತ್ಯಕ್ತವಾನ್ ಕೇವಲಂ ತನ್ನ ಕಿನ್ತು ಮೃತಗಣಮಧ್ಯಾದ್ ಉತ್ಥಿತವಾನ್, ಅಪಿ ಚೇಶ್ವರಸ್ಯ ದಕ್ಷಿಣೇ ಪಾರ್ಶ್ವೇ ತಿಷ್ಠನ್ ಅದ್ಯಾಪ್ಯಸ್ಮಾಕಂ ನಿಮಿತ್ತಂ ಪ್ರಾರ್ಥತ ಏವಮ್ಭೂತೋ ಯಃ ಖ್ರೀಷ್ಟಃ ಕಿಂ ತೇನ? ");
INSERT INTO sankan_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","ಅಸ್ಮಾಭಿಃ ಸಹ ಖ್ರೀಷ್ಟಸ್ಯ ಪ್ರೇಮವಿಚ್ಛೇದಂ ಜನಯಿತುಂ ಕಃ ಶಕ್ನೋತಿ? ಕ್ಲೇಶೋ ವ್ಯಸನಂ ವಾ ತಾಡನಾ ವಾ ದುರ್ಭಿಕ್ಷಂ ವಾ ವಸ್ತ್ರಹೀನತ್ವಂ ವಾ ಪ್ರಾಣಸಂಶಯೋ ವಾ ಖಙ್ಗೋ ವಾ ಕಿಮೇತಾನಿ ಶಕ್ನುವನ್ತಿ? ");
INSERT INTO sankan_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","ಕಿನ್ತು ಲಿಖಿತಮ್ ಆಸ್ತೇ, ಯಥಾ, ವಯಂ ತವ ನಿಮಿತ್ತಂ ಸ್ಮೋ ಮೃತ್ಯುವಕ್ತ್ರೇಽಖಿಲಂ ದಿನಂ| ಬಲಿರ್ದೇಯೋ ಯಥಾ ಮೇಷೋ ವಯಂ ಗಣ್ಯಾಮಹೇ ತಥಾ| ");
INSERT INTO sankan_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","ಅಪರಂ ಯೋಽಸ್ಮಾಸು ಪ್ರೀಯತೇ ತೇನೈತಾಸು ವಿಪತ್ಸು ವಯಂ ಸಮ್ಯಗ್ ವಿಜಯಾಮಹೇ| ");
INSERT INTO sankan_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","ಯತೋಽಸ್ಮಾಕಂ ಪ್ರಭುನಾ ಯೀಶುಖ್ರೀಷ್ಟೇನೇಶ್ವರಸ್ಯ ಯತ್ ಪ್ರೇಮ ತಸ್ಮಾದ್ ಅಸ್ಮಾಕಂ ವಿಚ್ಛೇದಂ ಜನಯಿತುಂ ಮೃತ್ಯು ರ್ಜೀವನಂ ವಾ ದಿವ್ಯದೂತಾ ವಾ ಬಲವನ್ತೋ ಮುಖ್ಯದೂತಾ ವಾ ವರ್ತ್ತಮಾನೋ ವಾ ಭವಿಷ್ಯನ್ ಕಾಲೋ ವಾ ಉಚ್ಚಪದಂ ವಾ ನೀಚಪದಂ ವಾಪರಂ ಕಿಮಪಿ ಸೃಷ್ಟವಸ್ತು ");
INSERT INTO sankan_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ವೈತೇಷಾಂ ಕೇನಾಪಿ ನ ಶಕ್ಯಮಿತ್ಯಸ್ಮಿನ್ ದೃಢವಿಶ್ವಾಸೋ ಮಮಾಸ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","ಅಹಂ ಕಾಞ್ಚಿದ್ ಕಲ್ಪಿತಾಂ ಕಥಾಂ ನ ಕಥಯಾಮಿ, ಖ್ರೀಷ್ಟಸ್ಯ ಸಾಕ್ಷಾತ್ ಸತ್ಯಮೇವ ಬ್ರವೀಮಿ ಪವಿತ್ರಸ್ಯಾತ್ಮನಃ ಸಾಕ್ಷಾನ್ ಮದೀಯಂ ಮನ ಏತತ್ ಸಾಕ್ಷ್ಯಂ ದದಾತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","ಮಮಾನ್ತರತಿಶಯದುಃಖಂ ನಿರನ್ತರಂ ಖೇದಶ್ಚ ");
INSERT INTO sankan_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","ತಸ್ಮಾದ್ ಅಹಂ ಸ್ವಜಾತೀಯಭ್ರಾತೃಣಾಂ ನಿಮಿತ್ತಾತ್ ಸ್ವಯಂ ಖ್ರೀಷ್ಟಾಚ್ಛಾಪಾಕ್ರಾನ್ತೋ ಭವಿತುಮ್ ಐಚ್ಛಮ್| ");
INSERT INTO sankan_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","ಯತಸ್ತ ಇಸ್ರಾಯೇಲಸ್ಯ ವಂಶಾ ಅಪಿ ಚ ದತ್ತಕಪುತ್ರತ್ವಂ ತೇಜೋ ನಿಯಮೋ ವ್ಯವಸ್ಥಾದಾನಂ ಮನ್ದಿರೇ ಭಜನಂ ಪ್ರತಿಜ್ಞಾಃ ಪಿತೃಪುರುಷಗಣಶ್ಚೈತೇಷು ಸರ್ವ್ವೇಷು ತೇಷಾಮ್ ಅಧಿಕಾರೋಽಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","ತತ್ ಕೇವಲಂ ನಹಿ ಕಿನ್ತು ಸರ್ವ್ವಾಧ್ಯಕ್ಷಃ ಸರ್ವ್ವದಾ ಸಚ್ಚಿದಾನನ್ದ ಈಶ್ವರೋ ಯಃ ಖ್ರೀಷ್ಟಃ ಸೋಽಪಿ ಶಾರೀರಿಕಸಮ್ಬನ್ಧೇನ ತೇಷಾಂ ವಂಶಸಮ್ಭವಃ| ");
INSERT INTO sankan_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","ಈಶ್ವರಸ್ಯ ವಾಕ್ಯಂ ವಿಫಲಂ ಜಾತಮ್ ಇತಿ ನಹಿ ಯತ್ಕಾರಣಾದ್ ಇಸ್ರಾಯೇಲೋ ವಂಶೇ ಯೇ ಜಾತಾಸ್ತೇ ಸರ್ವ್ವೇ ವಸ್ತುತ ಇಸ್ರಾಯೇಲೀಯಾ ನ ಭವನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","ಅಪರಮ್ ಇಬ್ರಾಹೀಮೋ ವಂಶೇ ಜಾತಾ ಅಪಿ ಸರ್ವ್ವೇ ತಸ್ಯೈವ ಸನ್ತಾನಾ ನ ಭವನ್ತಿ ಕಿನ್ತು ಇಸ್ಹಾಕೋ ನಾಮ್ನಾ ತವ ವಂಶೋ ವಿಖ್ಯಾತೋ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","ಅರ್ಥಾತ್ ಶಾರೀರಿಕಸಂಸರ್ಗಾತ್ ಜಾತಾಃ ಸನ್ತಾನಾ ಯಾವನ್ತಸ್ತಾವನ್ತ ಏವೇಶ್ವರಸ್ಯ ಸನ್ತಾನಾ ನ ಭವನ್ತಿ ಕಿನ್ತು ಪ್ರತಿಶ್ರವಣಾದ್ ಯೇ ಜಾಯನ್ತೇ ತಏವೇಶ್ವರವಂಶೋ ಗಣ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","ಯತಸ್ತತ್ಪ್ರತಿಶ್ರುತೇ ರ್ವಾಕ್ಯಮೇತತ್, ಏತಾದೃಶೇ ಸಮಯೇ ಽಹಂ ಪುನರಾಗಮಿಷ್ಯಾಮಿ ತತ್ಪೂರ್ವ್ವಂ ಸಾರಾಯಾಃ ಪುತ್ರ ಏಕೋ ಜನಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","ಅಪರಮಪಿ ವದಾಮಿ ಸ್ವಮನೋಽಭಿಲಾಷತ ಈಶ್ವರೇಣ ಯನ್ನಿರೂಪಿತಂ ತತ್ ಕರ್ಮ್ಮತೋ ನಹಿ ಕಿನ್ತ್ವಾಹ್ವಯಿತು ರ್ಜಾತಮೇತದ್ ಯಥಾ ಸಿದ್ಧ್ಯತಿ ");
INSERT INTO sankan_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","ತದರ್ಥಂ ರಿಬ್ಕಾನಾಮಿಕಯಾ ಯೋಷಿತಾ ಜನೈಕಸ್ಮಾದ್ ಅರ್ಥಾದ್ ಅಸ್ಮಾಕಮ್ ಇಸ್ಹಾಕಃ ಪೂರ್ವ್ವಪುರುಷಾದ್ ಗರ್ಭೇ ಧೃತೇ ತಸ್ಯಾಃ ಸನ್ತಾನಯೋಃ ಪ್ರಸವಾತ್ ಪೂರ್ವ್ವಂ ಕಿಞ್ಚ ತಯೋಃ ಶುಭಾಶುಭಕರ್ಮ್ಮಣಃ ಕರಣಾತ್ ಪೂರ್ವ್ವಂ ");
INSERT INTO sankan_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","ತಾಂ ಪ್ರತೀದಂ ವಾಕ್ಯಮ್ ಉಕ್ತಂ, ಜ್ಯೇಷ್ಠಃ ಕನಿಷ್ಠಂ ಸೇವಿಷ್ಯತೇ, ");
INSERT INTO sankan_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","ಯಥಾ ಲಿಖಿತಮ್ ಆಸ್ತೇ, ತಥಾಪ್ಯೇಷಾವಿ ನ ಪ್ರೀತ್ವಾ ಯಾಕೂಬಿ ಪ್ರೀತವಾನ್ ಅಹಂ| ");
INSERT INTO sankan_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","ತರ್ಹಿ ವಯಂ ಕಿಂ ಬ್ರೂಮಃ? ಈಶ್ವರಃ ಕಿಮ್ ಅನ್ಯಾಯಕಾರೀ? ತಥಾ ನ ಭವತು| ");
INSERT INTO sankan_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","ಯತಃ ಸ ಸ್ವಯಂ ಮೂಸಾಮ್ ಅವದತ್; ಅಹಂ ಯಸ್ಮಿನ್ ಅನುಗ್ರಹಂ ಚಿಕೀರ್ಷಾಮಿ ತಮೇವಾನುಗೃಹ್ಲಾಮಿ, ಯಞ್ಚ ದಯಿತುಮ್ ಇಚ್ಛಾಮಿ ತಮೇವ ದಯೇ| ");
INSERT INTO sankan_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","ಅತಏವೇಚ್ಛತಾ ಯತಮಾನೇನ ವಾ ಮಾನವೇನ ತನ್ನ ಸಾಧ್ಯತೇ ದಯಾಕಾರಿಣೇಶ್ವರೇಣೈವ ಸಾಧ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","ಫಿರೌಣಿ ಶಾಸ್ತ್ರೇ ಲಿಖತಿ, ಅಹಂ ತ್ವದ್ದ್ವಾರಾ ಮತ್ಪರಾಕ್ರಮಂ ದರ್ಶಯಿತುಂ ಸರ್ವ್ವಪೃಥಿವ್ಯಾಂ ನಿಜನಾಮ ಪ್ರಕಾಶಯಿತುಞ್ಚ ತ್ವಾಂ ಸ್ಥಾಪಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","ಅತಃ ಸ ಯಮ್ ಅನುಗ್ರಹೀತುಮ್ ಇಚ್ಛತಿ ತಮೇವಾನುಗೃಹ್ಲಾತಿ, ಯಞ್ಚ ನಿಗ್ರಹೀತುಮ್ ಇಚ್ಛತಿ ತಂ ನಿಗೃಹ್ಲಾತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","ಯದಿ ವದಸಿ ತರ್ಹಿ ಸ ದೋಷಂ ಕುತೋ ಗೃಹ್ಲಾತಿ? ತದೀಯೇಚ್ಛಾಯಾಃ ಪ್ರತಿಬನ್ಧಕತ್ವಂ ಕರ್ತ್ತಂ ಕಸ್ಯ ಸಾಮರ್ಥ್ಯಂ ವಿದ್ಯತೇ? ");
INSERT INTO sankan_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","ಹೇ ಈಶ್ವರಸ್ಯ ಪ್ರತಿಪಕ್ಷ ಮರ್ತ್ಯ ತ್ವಂ ಕಃ? ಏತಾದೃಶಂ ಮಾಂ ಕುತಃ ಸೃಷ್ಟವಾನ್? ಇತಿ ಕಥಾಂ ಸೃಷ್ಟವಸ್ತು ಸ್ರಷ್ಟ್ರೇ ಕಿಂ ಕಥಯಿಷ್ಯತಿ? ");
INSERT INTO sankan_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","ಏಕಸ್ಮಾನ್ ಮೃತ್ಪಿಣ್ಡಾದ್ ಉತ್ಕೃಷ್ಟಾಪಕೃಷ್ಟೌ ದ್ವಿವಿಧೌ ಕಲಶೌ ಕರ್ತ್ತುಂ ಕಿಂ ಕುಲಾಲಸ್ಯ ಸಾಮರ್ಥ್ಯಂ ನಾಸ್ತಿ? ");
INSERT INTO sankan_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","ಈಶ್ವರಃ ಕೋಪಂ ಪ್ರಕಾಶಯಿತುಂ ನಿಜಶಕ್ತಿಂ ಜ್ಞಾಪಯಿತುಞ್ಚೇಚ್ಛನ್ ಯದಿ ವಿನಾಶಸ್ಯ ಯೋಗ್ಯಾನಿ ಕ್ರೋಧಭಾಜನಾನಿ ಪ್ರತಿ ಬಹುಕಾಲಂ ದೀರ್ಘಸಹಿಷ್ಣುತಾಮ್ ಆಶ್ರಯತಿ; ");
INSERT INTO sankan_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","ಅಪರಞ್ಚ ವಿಭವಪ್ರಾಪ್ತ್ಯರ್ಥಂ ಪೂರ್ವ್ವಂ ನಿಯುಕ್ತಾನ್ಯನುಗ್ರಹಪಾತ್ರಾಣಿ ಪ್ರತಿ ನಿಜವಿಭವಸ್ಯ ಬಾಹುಲ್ಯಂ ಪ್ರಕಾಶಯಿತುಂ ಕೇವಲಯಿಹೂದಿನಾಂ ನಹಿ ಭಿನ್ನದೇಶಿನಾಮಪಿ ಮಧ್ಯಾದ್ ");
INSERT INTO sankan_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","ಅಸ್ಮಾನಿವ ತಾನ್ಯಾಹ್ವಯತಿ ತತ್ರ ತವ ಕಿಂ? ");
INSERT INTO sankan_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","ಹೋಶೇಯಗ್ರನ್ಥೇ ಯಥಾ ಲಿಖಿತಮ್ ಆಸ್ತೇ, ಯೋ ಲೋಕೋ ಮಮ ನಾಸೀತ್ ತಂ ವದಿಷ್ಯಾಮಿ ಮದೀಯಕಂ| ಯಾ ಜಾತಿ ರ್ಮೇಽಪ್ರಿಯಾ ಚಾಸೀತ್ ತಾಂ ವದಿಷ್ಯಾಮ್ಯಹಂ ಪ್ರಿಯಾಂ| ");
INSERT INTO sankan_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","ಯೂಯಂ ಮದೀಯಲೋಕಾ ನ ಯತ್ರೇತಿ ವಾಕ್ಯಮೌಚ್ಯತ| ಅಮರೇಶಸ್ಯ ಸನ್ತಾನಾ ಇತಿ ಖ್ಯಾಸ್ಯನ್ತಿ ತತ್ರ ತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","ಇಸ್ರಾಯೇಲೀಯಲೋಕೇಷು ಯಿಶಾಯಿಯೋಽಪಿ ವಾಚಮೇತಾಂ ಪ್ರಾಚಾರಯತ್, ಇಸ್ರಾಯೇಲೀಯವಂಶಾನಾಂ ಯಾ ಸಂಖ್ಯಾ ಸಾ ತು ನಿಶ್ಚಿತಂ| ಸಮುದ್ರಸಿಕತಾಸಂಖ್ಯಾಸಮಾನಾ ಯದಿ ಜಾಯತೇ| ತಥಾಪಿ ಕೇವಲಂ ಲೋಕೈರಲ್ಪೈಸ್ತ್ರಾಣಂ ವ್ರಜಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","ಯತೋ ನ್ಯಾಯೇನ ಸ್ವಂ ಕರ್ಮ್ಮ ಪರೇಶಃ ಸಾಧಯಿಷ್ಯತಿ| ದೇಶೇ ಸಏವ ಸಂಕ್ಷೇಪಾನ್ನಿಜಂ ಕರ್ಮ್ಮ ಕರಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","ಯಿಶಾಯಿಯೋಽಪರಮಪಿ ಕಥಯಾಮಾಸ, ಸೈನ್ಯಾಧ್ಯಕ್ಷಪರೇಶೇನ ಚೇತ್ ಕಿಞ್ಚಿನ್ನೋದಶಿಷ್ಯತ| ತದಾ ವಯಂ ಸಿದೋಮೇವಾಭವಿಷ್ಯಾಮ ವಿನಿಶ್ಚಿತಂ| ಯದ್ವಾ ವಯಮ್ ಅಮೋರಾಯಾ ಅಗಮಿಷ್ಯಾಮ ತುಲ್ಯತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","ತರ್ಹಿ ವಯಂ ಕಿಂ ವಕ್ಷ್ಯಾಮಃ? ಇತರದೇಶೀಯಾ ಲೋಕಾ ಅಪಿ ಪುಣ್ಯಾರ್ಥಮ್ ಅಯತಮಾನಾ ವಿಶ್ವಾಸೇನ ಪುಣ್ಯಮ್ ಅಲಭನ್ತ; ");
INSERT INTO sankan_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","ಕಿನ್ತ್ವಿಸ್ರಾಯೇಲ್ಲೋಕಾ ವ್ಯವಸ್ಥಾಪಾಲನೇನ ಪುಣ್ಯಾರ್ಥಂ ಯತಮಾನಾಸ್ತನ್ ನಾಲಭನ್ತ| ");
INSERT INTO sankan_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","ತಸ್ಯ ಕಿಂ ಕಾರಣಂ? ತೇ ವಿಶ್ವಾಸೇನ ನಹಿ ಕಿನ್ತು ವ್ಯವಸ್ಥಾಯಾಃ ಕ್ರಿಯಯಾ ಚೇಷ್ಟಿತ್ವಾ ತಸ್ಮಿನ್ ಸ್ಖಲನಜನಕೇ ಪಾಷಾಣೇ ಪಾದಸ್ಖಲನಂ ಪ್ರಾಪ್ತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","ಲಿಖಿತಂ ಯಾದೃಶಮ್ ಆಸ್ತೇ, ಪಶ್ಯ ಪಾದಸ್ಖಲಾರ್ಥಂ ಹಿ ಸೀಯೋನಿ ಪ್ರಸ್ತರನ್ತಥಾ| ಬಾಧಾಕಾರಞ್ಚ ಪಾಷಾಣಂ ಪರಿಸ್ಥಾಪಿತವಾನಹಮ್| ವಿಶ್ವಸಿಷ್ಯತಿ ಯಸ್ತತ್ರ ಸ ಜನೋ ನ ತ್ರಪಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","ಹೇ ಭ್ರಾತರ ಇಸ್ರಾಯೇಲೀಯಲೋಕಾ ಯತ್ ಪರಿತ್ರಾಣಂ ಪ್ರಾಪ್ನುವನ್ತಿ ತದಹಂ ಮನಸಾಭಿಲಷನ್ ಈಶ್ವರಸ್ಯ ಸಮೀಪೇ ಪ್ರಾರ್ಥಯೇ| ");
INSERT INTO sankan_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","ಯತ ಈಶ್ವರೇ ತೇಷಾಂ ಚೇಷ್ಟಾ ವಿದ್ಯತ ಇತ್ಯತ್ರಾಹಂ ಸಾಕ್ಷ್ಯಸ್ಮಿ; ಕಿನ್ತು ತೇಷಾಂ ಸಾ ಚೇಷ್ಟಾ ಸಜ್ಞಾನಾ ನಹಿ, ");
INSERT INTO sankan_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","ಯತಸ್ತ ಈಶ್ವರದತ್ತಂ ಪುಣ್ಯಮ್ ಅವಿಜ್ಞಾಯ ಸ್ವಕೃತಪುಣ್ಯಂ ಸ್ಥಾಪಯಿತುಮ್ ಚೇಷ್ಟಮಾನಾ ಈಶ್ವರದತ್ತಸ್ಯ ಪುಣ್ಯಸ್ಯ ನಿಘ್ನತ್ವಂ ನ ಸ್ವೀಕುರ್ವ್ವನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","ಖ್ರೀಷ್ಟ ಏಕೈಕವಿಶ್ವಾಸಿಜನಾಯ ಪುಣ್ಯಂ ದಾತುಂ ವ್ಯವಸ್ಥಾಯಾಃ ಫಲಸ್ವರೂಪೋ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","ವ್ಯವಸ್ಥಾಪಾಲನೇನ ಯತ್ ಪುಣ್ಯಂ ತತ್ ಮೂಸಾ ವರ್ಣಯಾಮಾಸ, ಯಥಾ, ಯೋ ಜನಸ್ತಾಂ ಪಾಲಯಿಷ್ಯತಿ ಸ ತದ್ದ್ವಾರಾ ಜೀವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","ಕಿನ್ತು ಪ್ರತ್ಯಯೇನ ಯತ್ ಪುಣ್ಯಂ ತದ್ ಏತಾದೃಶಂ ವಾಕ್ಯಂ ವದತಿ, ಕಃ ಸ್ವರ್ಗಮ್ ಆರುಹ್ಯ ಖ್ರೀಷ್ಟಮ್ ಅವರೋಹಯಿಷ್ಯತಿ? ");
INSERT INTO sankan_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","ಕೋ ವಾ ಪ್ರೇತಲೋಕಮ್ ಅವರುಹ್ಯ ಖ್ರೀಷ್ಟಂ ಮೃತಗಣಮಧ್ಯಾದ್ ಆನೇಷ್ಯತೀತಿ ವಾಕ್ ಮನಸಿ ತ್ವಯಾ ನ ಗದಿತವ್ಯಾ| ");
INSERT INTO sankan_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","ತರ್ಹಿ ಕಿಂ ಬ್ರವೀತಿ? ತದ್ ವಾಕ್ಯಂ ತವ ಸಮೀಪಸ್ಥಮ್ ಅರ್ಥಾತ್ ತವ ವದನೇ ಮನಸಿ ಚಾಸ್ತೇ, ತಚ್ಚ ವಾಕ್ಯಮ್ ಅಸ್ಮಾಭಿಃ ಪ್ರಚಾರ್ಯ್ಯಮಾಣಂ ವಿಶ್ವಾಸಸ್ಯ ವಾಕ್ಯಮೇವ| ");
INSERT INTO sankan_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","ವಸ್ತುತಃ ಪ್ರಭುಂ ಯೀಶುಂ ಯದಿ ವದನೇನ ಸ್ವೀಕರೋಷಿ, ತಥೇಶ್ವರಸ್ತಂ ಶ್ಮಶಾನಾದ್ ಉದಸ್ಥಾಪಯದ್ ಇತಿ ಯದ್ಯನ್ತಃಕರಣೇನ ವಿಶ್ವಸಿಷಿ ತರ್ಹಿ ಪರಿತ್ರಾಣಂ ಲಪ್ಸ್ಯಸೇ| ");
INSERT INTO sankan_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","ಯಸ್ಮಾತ್ ಪುಣ್ಯಪ್ರಾಪ್ತ್ಯರ್ಥಮ್ ಅನ್ತಃಕರಣೇನ ವಿಶ್ವಸಿತವ್ಯಂ ಪರಿತ್ರಾಣಾರ್ಥಞ್ಚ ವದನೇನ ಸ್ವೀಕರ್ತ್ತವ್ಯಂ| ");
INSERT INTO sankan_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","ಶಾಸ್ತ್ರೇ ಯಾದೃಶಂ ಲಿಖತಿ ವಿಶ್ವಸಿಷ್ಯತಿ ಯಸ್ತತ್ರ ಸ ಜನೋ ನ ತ್ರಪಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","ಇತ್ಯತ್ರ ಯಿಹೂದಿನಿ ತದನ್ಯಲೋಕೇ ಚ ಕೋಪಿ ವಿಶೇಷೋ ನಾಸ್ತಿ ಯಸ್ಮಾದ್ ಯಃ ಸರ್ವ್ವೇಷಾಮ್ ಅದ್ವಿತೀಯಃ ಪ್ರಭುಃ ಸ ನಿಜಯಾಚಕಾನ ಸರ್ವ್ವಾನ್ ಪ್ರತಿ ವದಾನ್ಯೋ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","ಯತಃ, ಯಃ ಕಶ್ಚಿತ್ ಪರಮೇಶಸ್ಯ ನಾಮ್ನಾ ಹಿ ಪ್ರಾರ್ಥಯಿಷ್ಯತೇ| ಸ ಏವ ಮನುಜೋ ನೂನಂ ಪರಿತ್ರಾತೋ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","ಯಂ ಯೇ ಜನಾ ನ ಪ್ರತ್ಯಾಯನ್ ತೇ ತಮುದ್ದಿಶ್ಯ ಕಥಂ ಪ್ರಾರ್ಥಯಿಷ್ಯನ್ತೇ? ಯೇ ವಾ ಯಸ್ಯಾಖ್ಯಾನಂ ಕದಾಪಿ ನ ಶ್ರುತವನ್ತಸ್ತೇ ತಂ ಕಥಂ ಪ್ರತ್ಯೇಷ್ಯನ್ತಿ? ಅಪರಂ ಯದಿ ಪ್ರಚಾರಯಿತಾರೋ ನ ತಿಷ್ಠನ್ತಿ ತದಾ ಕಥಂ ತೇ ಶ್ರೋಷ್ಯನ್ತಿ? ");
INSERT INTO sankan_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","ಯದಿ ವಾ ಪ್ರೇರಿತಾ ನ ಭವನ್ತಿ ತದಾ ಕಥಂ ಪ್ರಚಾರಯಿಷ್ಯನ್ತಿ? ಯಾದೃಶಂ ಲಿಖಿತಮ್ ಆಸ್ತೇ, ಯಥಾ, ಮಾಙ್ಗಲಿಕಂ ಸುಸಂವಾದಂ ದದತ್ಯಾನೀಯ ಯೇ ನರಾಃ| ಪ್ರಚಾರಯನ್ತಿ ಶಾನ್ತೇಶ್ಚ ಸುಸಂವಾದಂ ಜನಾಸ್ತು ಯೇ| ತೇಷಾಂ ಚರಣಪದ್ಮಾನಿ ಕೀದೃಕ್ ಶೋಭಾನ್ವಿತಾನಿ ಹಿ| ");
INSERT INTO sankan_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","ಕಿನ್ತು ತೇ ಸರ್ವ್ವೇ ತಂ ಸುಸಂವಾದಂ ನ ಗೃಹೀತವನ್ತಃ| ಯಿಶಾಯಿಯೋ ಯಥಾ ಲಿಖಿತವಾನ್| ಅಸ್ಮತ್ಪ್ರಚಾರಿತೇ ವಾಕ್ಯೇ ವಿಶ್ವಾಸಮಕರೋದ್ಧಿ ಕಃ| ");
INSERT INTO sankan_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","ಅತಏವ ಶ್ರವಣಾದ್ ವಿಶ್ವಾಸ ಐಶ್ವರವಾಕ್ಯಪ್ರಚಾರಾತ್ ಶ್ರವಣಞ್ಚ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","ತರ್ಹ್ಯಹಂ ಬ್ರವೀಮಿ ತೈಃ ಕಿಂ ನಾಶ್ರಾವಿ? ಅವಶ್ಯಮ್ ಅಶ್ರಾವಿ, ಯಸ್ಮಾತ್ ತೇಷಾಂ ಶಬ್ದೋ ಮಹೀಂ ವ್ಯಾಪ್ನೋದ್ ವಾಕ್ಯಞ್ಚ ನಿಖಿಲಂ ಜಗತ್| ");
INSERT INTO sankan_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","ಅಪರಮಪಿ ವದಾಮಿ, ಇಸ್ರಾಯೇಲೀಯಲೋಕಾಃ ಕಿಮ್ ಏತಾಂ ಕಥಾಂ ನ ಬುಧ್ಯನ್ತೇ? ಪ್ರಥಮತೋ ಮೂಸಾ ಇದಂ ವಾಕ್ಯಂ ಪ್ರೋವಾಚ, ಅಹಮುತ್ತಾಪಯಿಷ್ಯೇ ತಾನ್ ಅಗಣ್ಯಮಾನವೈರಪಿ| ಕ್ಲೇಕ್ಷ್ಯಾಮಿ ಜಾತಿಮ್ ಏತಾಞ್ಚ ಪ್ರೋನ್ಮತ್ತಭಿನ್ನಜಾತಿಭಿಃ| ");
INSERT INTO sankan_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","ಅಪರಞ್ಚ ಯಿಶಾಯಿಯೋಽತಿಶಯಾಕ್ಷೋಭೇಣ ಕಥಯಾಮಾಸ, ಯಥಾ, ಅಧಿ ಮಾಂ ಯೈಸ್ತು ನಾಚೇಷ್ಟಿ ಸಮ್ಪ್ರಾಪ್ತಸ್ತೈ ರ್ಜನೈರಹಂ| ಅಧಿ ಮಾಂ ಯೈ ರ್ನ ಸಮ್ಪೃಷ್ಟಂ ವಿಜ್ಞಾತಸ್ತೈ ರ್ಜನೈರಹಂ|| ");
INSERT INTO sankan_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","ಕಿನ್ತ್ವಿಸ್ರಾಯೇಲೀಯಲೋಕಾನ್ ಅಧಿ ಕಥಯಾಞ್ಚಕಾರ, ಯೈರಾಜ್ಞಾಲಙ್ಘಿಭಿ ರ್ಲೋಕೈ ರ್ವಿರುದ್ಧಂ ವಾಕ್ಯಮುಚ್ಯತೇ| ತಾನ್ ಪ್ರತ್ಯೇವ ದಿನಂ ಕೃತ್ಸ್ನಂ ಹಸ್ತೌ ವಿಸ್ತಾರಯಾಮ್ಯಹಂ|| ");
INSERT INTO sankan_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","ಈಶ್ವರೇಣ ಸ್ವೀಕೀಯಲೋಕಾ ಅಪಸಾರಿತಾ ಅಹಂ ಕಿಮ್ ಈದೃಶಂ ವಾಕ್ಯಂ ಬ್ರವೀಮಿ? ತನ್ನ ಭವತು ಯತೋಽಹಮಪಿ ಬಿನ್ಯಾಮೀನಗೋತ್ರೀಯ ಇಬ್ರಾಹೀಮವಂಶೀಯ ಇಸ್ರಾಯೇಲೀಯಲೋಕೋಽಸ್ಮಿ| ");
INSERT INTO sankan_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","ಈಶ್ವರೇಣ ಪೂರ್ವ್ವಂ ಯೇ ಪ್ರದೃಷ್ಟಾಸ್ತೇ ಸ್ವಕೀಯಲೋಕಾ ಅಪಸಾರಿತಾ ಇತಿ ನಹಿ| ಅಪರಮ್ ಏಲಿಯೋಪಾಖ್ಯಾನೇ ಶಾಸ್ತ್ರೇ ಯಲ್ಲಿಖಿತಮ್ ಆಸ್ತೇ ತದ್ ಯೂಯಂ ಕಿಂ ನ ಜಾನೀಥ? ");
INSERT INTO sankan_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","ಹೇ ಪರಮೇಶ್ವರ ಲೋಕಾಸ್ತ್ವದೀಯಾಃ ಸರ್ವ್ವಾ ಯಜ್ಞವೇದೀರಭಞ್ಜನ್ ತಥಾ ತವ ಭವಿಷ್ಯದ್ವಾದಿನಃ ಸರ್ವ್ವಾನ್ ಅಘ್ನನ್ ಕೇವಲ ಏಕೋಽಹಮ್ ಅವಶಿಷ್ಟ ಆಸೇ ತೇ ಮಮಾಪಿ ಪ್ರಾಣಾನ್ ನಾಶಯಿತುಂ ಚೇಷ್ಟನತೇ, ಏತಾಂ ಕಥಾಮ್ ಇಸ್ರಾಯೇಲೀಯಲೋಕಾನಾಂ ವಿರುದ್ಧಮ್ ಏಲಿಯ ಈಶ್ವರಾಯ ನಿವೇದಯಾಮಾಸ| ");
INSERT INTO sankan_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","ತತಸ್ತಂ ಪ್ರತೀಶ್ವರಸ್ಯೋತ್ತರಂ ಕಿಂ ಜಾತಂ? ಬಾಲ್ನಾಮ್ನೋ ದೇವಸ್ಯ ಸಾಕ್ಷಾತ್ ಯೈ ರ್ಜಾನೂನಿ ನ ಪಾತಿತಾನಿ ತಾದೃಶಾಃ ಸಪ್ತ ಸಹಸ್ರಾಣಿ ಲೋಕಾ ಅವಶೇಷಿತಾ ಮಯಾ| ");
INSERT INTO sankan_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","ತದ್ವದ್ ಏತಸ್ಮಿನ್ ವರ್ತ್ತಮಾನಕಾಲೇಽಪಿ ಅನುಗ್ರಹೇಣಾಭಿರುಚಿತಾಸ್ತೇಷಾಮ್ ಅವಶಿಷ್ಟಾಃ ಕತಿಪಯಾ ಲೋಕಾಃ ಸನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","ಅತಏವ ತದ್ ಯದ್ಯನುಗ್ರಹೇಣ ಭವತಿ ತರ್ಹಿ ಕ್ರಿಯಯಾ ನ ಭವತಿ ನೋ ಚೇದ್ ಅನುಗ್ರಹೋಽನನುಗ್ರಹ ಏವ, ಯದಿ ವಾ ಕ್ರಿಯಯಾ ಭವತಿ ತರ್ಹ್ಯನುಗ್ರಹೇಣ ನ ಭವತಿ ನೋ ಚೇತ್ ಕ್ರಿಯಾ ಕ್ರಿಯೈವ ನ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","ತರ್ಹಿ ಕಿಂ? ಇಸ್ರಾಯೇಲೀಯಲೋಕಾ ಯದ್ ಅಮೃಗಯನ್ತ ತನ್ನ ಪ್ರಾಪುಃ| ಕಿನ್ತ್ವಭಿರುಚಿತಲೋಕಾಸ್ತತ್ ಪ್ರಾಪುಸ್ತದನ್ಯೇ ಸರ್ವ್ವ ಅನ್ಧೀಭೂತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","ಯಥಾ ಲಿಖಿತಮ್ ಆಸ್ತೇ, ಘೋರನಿದ್ರಾಲುತಾಭಾವಂ ದೃಷ್ಟಿಹೀನೇ ಚ ಲೋಚನೇ| ಕರ್ಣೌ ಶ್ರುತಿವಿಹೀನೌ ಚ ಪ್ರದದೌ ತೇಭ್ಯ ಈಶ್ವರಃ|| ");
INSERT INTO sankan_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","ಏತೇಸ್ಮಿನ್ ದಾಯೂದಪಿ ಲಿಖಿತವಾನ್ ಯಥಾ, ಅತೋ ಭುಕ್ತ್ಯಾಸನಂ ತೇಷಾಮ್ ಉನ್ಮಾಥವದ್ ಭವಿಷ್ಯತಿ| ವಾ ವಂಶಯನ್ತ್ರವದ್ ಬಾಧಾ ದಣ್ಡವದ್ ವಾ ಭವಿಷ್ಯತಿ|| ");
INSERT INTO sankan_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","ಭವಿಷ್ಯನ್ತಿ ತಥಾನ್ಧಾಸ್ತೇ ನೇತ್ರೈಃ ಪಶ್ಯನ್ತಿ ನೋ ಯಥಾ| ವೇಪಥುಃ ಕಟಿದೇಶಸ್ಯ ತೇಷಾಂ ನಿತ್ಯಂ ಭವಿಷ್ಯತಿ|| ");
INSERT INTO sankan_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","ಪತನಾರ್ಥಂ ತೇ ಸ್ಖಲಿತವನ್ತ ಇತಿ ವಾಚಂ ಕಿಮಹಂ ವದಾಮಿ? ತನ್ನ ಭವತು ಕಿನ್ತು ತಾನ್ ಉದ್ಯೋಗಿನಃ ಕರ್ತ್ತುಂ ತೇಷಾಂ ಪತನಾದ್ ಇತರದೇಶೀಯಲೋಕೈಃ ಪರಿತ್ರಾಣಂ ಪ್ರಾಪ್ತಂ| ");
INSERT INTO sankan_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","ತೇಷಾಂ ಪತನಂ ಯದಿ ಜಗತೋ ಲೋಕಾನಾಂ ಲಾಭಜನಕಮ್ ಅಭವತ್ ತೇಷಾಂ ಹ್ರಾಸೋಽಪಿ ಯದಿ ಭಿನ್ನದೇಶಿನಾಂ ಲಾಭಜನಕೋಽಭವತ್ ತರ್ಹಿ ತೇಷಾಂ ವೃದ್ಧಿಃ ಕತಿ ಲಾಭಜನಿಕಾ ಭವಿಷ್ಯತಿ? ");
INSERT INTO sankan_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","ಅತೋ ಹೇ ಅನ್ಯದೇಶಿನೋ ಯುಷ್ಮಾನ್ ಸಮ್ಬೋಧ್ಯ ಕಥಯಾಮಿ ನಿಜಾನಾಂ ಜ್ಞಾತಿಬನ್ಧೂನಾಂ ಮನಃಸೂದ್ಯೋಗಂ ಜನಯನ್ ತೇಷಾಂ ಮಧ್ಯೇ ಕಿಯತಾಂ ಲೋಕಾನಾಂ ಯಥಾ ಪರಿತ್ರಾಣಂ ಸಾಧಯಾಮಿ ");
INSERT INTO sankan_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","ತನ್ನಿಮಿತ್ತಮ್ ಅನ್ಯದೇಶಿನಾಂ ನಿಕಟೇ ಪ್ರೇರಿತಃ ಸನ್ ಅಹಂ ಸ್ವಪದಸ್ಯ ಮಹಿಮಾನಂ ಪ್ರಕಾಶಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","ತೇಷಾಂ ನಿಗ್ರಹೇಣ ಯದೀಶ್ವರೇಣ ಸಹ ಜಗತೋ ಜನಾನಾಂ ಮೇಲನಂ ಜಾತಂ ತರ್ಹಿ ತೇಷಾಮ್ ಅನುಗೃಹೀತತ್ವಂ ಮೃತದೇಹೇ ಯಥಾ ಜೀವನಲಾಭಸ್ತದ್ವತ್ ಕಿಂ ನ ಭವಿಷ್ಯತಿ? ");
INSERT INTO sankan_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","ಅಪರಂ ಪ್ರಥಮಜಾತಂ ಫಲಂ ಯದಿ ಪವಿತ್ರಂ ಭವತಿ ತರ್ಹಿ ಸರ್ವ್ವಮೇವ ಫಲಂ ಪವಿತ್ರಂ ಭವಿಷ್ಯತಿ; ತಥಾ ಮೂಲಂ ಯದಿ ಪವಿತ್ರಂ ಭವತಿ ತರ್ಹಿ ಶಾಖಾ ಅಪಿ ತಥೈವ ಭವಿಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","ಕಿಯತೀನಾಂ ಶಾಖಾನಾಂ ಛೇದನೇ ಕೃತೇ ತ್ವಂ ವನ್ಯಜಿತವೃಕ್ಷಸ್ಯ ಶಾಖಾ ಭೂತ್ವಾ ಯದಿ ತಚ್ಛಾಖಾನಾಂ ಸ್ಥಾನೇ ರೋಪಿತಾ ಸತಿ ಜಿತವೃಕ್ಷೀಯಮೂಲಸ್ಯ ರಸಂ ಭುಂಕ್ಷೇ, ");
INSERT INTO sankan_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","ತರ್ಹಿ ತಾಸಾಂ ಭಿನ್ನಶಾಖಾನಾಂ ವಿರುದ್ಧಂ ಮಾಂ ಗರ್ವ್ವೀಃ; ಯದಿ ಗರ್ವ್ವಸಿ ತರ್ಹಿ ತ್ವಂ ಮೂಲಂ ಯನ್ನ ಧಾರಯಸಿ ಕಿನ್ತು ಮೂಲಂ ತ್ವಾಂ ಧಾರಯತೀತಿ ಸಂಸ್ಮರ| ");
INSERT INTO sankan_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","ಅಪರಞ್ಚ ಯದಿ ವದಸಿ ಮಾಂ ರೋಪಯಿತುಂ ತಾಃ ಶಾಖಾ ವಿಭನ್ನಾ ಅಭವನ್; ");
INSERT INTO sankan_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","ಭದ್ರಮ್, ಅಪ್ರತ್ಯಯಕಾರಣಾತ್ ತೇ ವಿಭಿನ್ನಾ ಜಾತಾಸ್ತಥಾ ವಿಶ್ವಾಸಕಾರಣಾತ್ ತ್ವಂ ರೋಪಿತೋ ಜಾತಸ್ತಸ್ಮಾದ್ ಅಹಙ್ಕಾರಮ್ ಅಕೃತ್ವಾ ಸಸಾಧ್ವಸೋ ಭವ| ");
INSERT INTO sankan_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","ಯತ ಈಶ್ವರೋ ಯದಿ ಸ್ವಾಭಾವಿಕೀಃ ಶಾಖಾ ನ ರಕ್ಷತಿ ತರ್ಹಿ ಸಾವಧಾನೋ ಭವ ಚೇತ್ ತ್ವಾಮಪಿ ನ ಸ್ಥಾಪಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","ಇತ್ಯತ್ರೇಶ್ವರಸ್ಯ ಯಾದೃಶೀ ಕೃಪಾ ತಾದೃಶಂ ಭಯಾನಕತ್ವಮಪಿ ತ್ವಯಾ ದೃಶ್ಯತಾಂ; ಯೇ ಪತಿತಾಸ್ತಾನ್ ಪ್ರತಿ ತಸ್ಯ ಭಯಾನಕತ್ವಂ ದೃಶ್ಯತಾಂ, ತ್ವಞ್ಚ ಯದಿ ತತ್ಕೃಪಾಶ್ರಿತಸ್ತಿಷ್ಠಸಿ ತರ್ಹಿ ತ್ವಾಂ ಪ್ರತಿ ಕೃಪಾ ದ್ರಕ್ಷ್ಯತೇ; ನೋ ಚೇತ್ ತ್ವಮಪಿ ತದ್ವತ್ ಛಿನ್ನೋ ಭವಿಷ್ಯಸಿ| ");
INSERT INTO sankan_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","ಅಪರಞ್ಚ ತೇ ಯದ್ಯಪ್ರತ್ಯಯೇ ನ ತಿಷ್ಠನ್ತಿ ತರ್ಹಿ ಪುನರಪಿ ರೋಪಯಿಷ್ಯನ್ತೇ ಯಸ್ಮಾತ್ ತಾನ್ ಪುನರಪಿ ರೋಪಯಿತುಮ್ ಇಶ್ವರಸ್ಯ ಶಕ್ತಿರಾಸ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","ವನ್ಯಜಿತವೃಕ್ಷಸ್ಯ ಶಾಖಾ ಸನ್ ತ್ವಂ ಯದಿ ತತಶ್ಛಿನ್ನೋ ರೀತಿವ್ಯತ್ಯಯೇನೋತ್ತಮಜಿತವೃಕ್ಷೇ ರೋेेಪಿತೋಽಭವಸ್ತರ್ಹಿ ತಸ್ಯ ವೃಕ್ಷಸ್ಯ ಸ್ವೀಯಾ ಯಾಃ ಶಾಖಾಸ್ತಾಃ ಕಿಂ ಪುನಃ ಸ್ವವೃಕ್ಷೇ ಸಂಲಗಿತುಂ ನ ಶಕ್ನುವನ್ತಿ? ");
INSERT INTO sankan_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","ಹೇ ಭ್ರಾತರೋ ಯುಷ್ಮಾಕಮ್ ಆತ್ಮಾಭಿಮಾನೋ ಯನ್ನ ಜಾಯತೇ ತದರ್ಥಂ ಮಮೇದೃಶೀ ವಾಞ್ಛಾ ಭವತಿ ಯೂಯಂ ಏತನ್ನಿಗೂಢತತ್ತ್ವಮ್ ಅಜಾನನ್ತೋ ಯನ್ನ ತಿಷ್ಠಥ; ವಸ್ತುತೋ ಯಾವತ್ಕಾಲಂ ಸಮ್ಪೂರ್ಣರೂಪೇಣ ಭಿನ್ನದೇಶಿನಾಂ ಸಂಗ್ರಹೋ ನ ಭವಿಷ್ಯತಿ ತಾವತ್ಕಾಲಮ್ ಅಂಶತ್ವೇನ ಇಸ್ರಾಯೇಲೀಯಲೋಕಾನಾಮ್ ಅನ್ಧತಾ ಸ್ಥಾಸ್ಯತಿ; ");
INSERT INTO sankan_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","ಪಶ್ಚಾತ್ ತೇ ಸರ್ವ್ವೇ ಪರಿತ್ರಾಸ್ಯನ್ತೇ; ಏತಾದೃಶಂ ಲಿಖಿತಮಪ್ಯಾಸ್ತೇ, ಆಗಮಿಷ್ಯತಿ ಸೀಯೋನಾದ್ ಏಕೋ ಯಸ್ತ್ರಾಣದಾಯಕಃ| ಅಧರ್ಮ್ಮಂ ಯಾಕುಬೋ ವಂಶಾತ್ ಸ ತು ದೂರೀಕರಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","ತಥಾ ದೂರೀಕರಿಷ್ಯಾಮಿ ತೇಷಾಂ ಪಾಪಾನ್ಯಹಂ ಯದಾ| ತದಾ ತೈರೇವ ಸಾರ್ದ್ಧಂ ಮೇ ನಿಯಮೋಽಯಂ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","ಸುಸಂವಾದಾತ್ ತೇ ಯುಷ್ಮಾಕಂ ವಿಪಕ್ಷಾ ಅಭವನ್ ಕಿನ್ತ್ವಭಿರುಚಿತತ್ವಾತ್ ತೇ ಪಿತೃಲೋಕಾನಾಂ ಕೃತೇ ಪ್ರಿಯಪಾತ್ರಾಣಿ ಭವನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","ಯತ ಈಶ್ವರಸ್ಯ ದಾನಾದ್ ಆಹ್ವಾನಾಞ್ಚ ಪಶ್ಚಾತ್ತಾಪೋ ನ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","ಅತಏವ ಪೂರ್ವ್ವಮ್ ಈಶ್ವರೇಽವಿಶ್ವಾಸಿನಃ ಸನ್ತೋಽಪಿ ಯೂಯಂ ಯದ್ವತ್ ಸಮ್ಪ್ರತಿ ತೇಷಾಮ್ ಅವಿಶ್ವಾಸಕಾರಣಾದ್ ಈಶ್ವರಸ್ಯ ಕೃಪಾಪಾತ್ರಾಣಿ ಜಾತಾಸ್ತದ್ವದ್ ");
INSERT INTO sankan_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","ಇದಾನೀಂ ತೇಽವಿಶ್ವಾಸಿನಃ ಸನ್ತಿ ಕಿನ್ತು ಯುಷ್ಮಾಭಿ ರ್ಲಬ್ಧಕೃಪಾಕಾರಣಾತ್ ತೈರಪಿ ಕೃಪಾ ಲಪ್ಸ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","ಈಶ್ವರಃ ಸರ್ವ್ವಾನ್ ಪ್ರತಿ ಕೃಪಾಂ ಪ್ರಕಾಶಯಿತುಂ ಸರ್ವ್ವಾನ್ ಅವಿಶ್ವಾಸಿತ್ವೇನ ಗಣಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","ಅಹೋ ಈಶ್ವರಸ್ಯ ಜ್ಞಾನಬುದ್ಧಿರೂಪಯೋ ರ್ಧನಯೋಃ ಕೀದೃಕ್ ಪ್ರಾಚುರ್ಯ್ಯಂ| ತಸ್ಯ ರಾಜಶಾಸನಸ್ಯ ತತ್ತ್ವಂ ಕೀದೃಗ್ ಅಪ್ರಾಪ್ಯಂ| ತಸ್ಯ ಮಾರ್ಗಾಶ್ಚ ಕೀದೃಗ್ ಅನುಪಲಕ್ಷ್ಯಾಃ| ");
INSERT INTO sankan_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","ಪರಮೇಶ್ವರಸ್ಯ ಸಙ್ಕಲ್ಪಂ ಕೋ ಜ್ಞಾತವಾನ್? ತಸ್ಯ ಮನ್ತ್ರೀ ವಾ ಕೋಽಭವತ್? ");
INSERT INTO sankan_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","ಕೋ ವಾ ತಸ್ಯೋಪಕಾರೀ ಭೃತ್ವಾ ತತ್ಕೃತೇ ತೇನ ಪ್ರತ್ಯುಪಕರ್ತ್ತವ್ಯಃ? ");
INSERT INTO sankan_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","ಯತೋ ವಸ್ತುಮಾತ್ರಮೇವ ತಸ್ಮಾತ್ ತೇನ ತಸ್ಮೈ ಚಾಭವತ್ ತದೀಯೋ ಮಹಿಮಾ ಸರ್ವ್ವದಾ ಪ್ರಕಾಶಿತೋ ಭವತು| ಇತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","ಹೇ ಭ್ರಾತರ ಈಶ್ವರಸ್ಯ ಕೃಪಯಾಹಂ ಯುಷ್ಮಾನ್ ವಿನಯೇ ಯೂಯಂ ಸ್ವಂ ಸ್ವಂ ಶರೀರಂ ಸಜೀವಂ ಪವಿತ್ರಂ ಗ್ರಾಹ್ಯಂ ಬಲಿಮ್ ಈಶ್ವರಮುದ್ದಿಶ್ಯ ಸಮುತ್ಸೃಜತ, ಏಷಾ ಸೇವಾ ಯುಷ್ಮಾಕಂ ಯೋಗ್ಯಾ| ");
INSERT INTO sankan_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","ಅಪರಂ ಯೂಯಂ ಸಾಂಸಾರಿಕಾ ಇವ ಮಾಚರತ, ಕಿನ್ತು ಸ್ವಂ ಸ್ವಂ ಸ್ವಭಾವಂ ಪರಾವರ್ತ್ಯ ನೂತನಾಚಾರಿಣೋ ಭವತ, ತತ ಈಶ್ವರಸ್ಯ ನಿದೇಶಃ ಕೀದೃಗ್ ಉತ್ತಮೋ ಗ್ರಹಣೀಯಃ ಸಮ್ಪೂರ್ಣಶ್ಚೇತಿ ಯುಷ್ಮಾಭಿರನುಭಾವಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","ಕಶ್ಚಿದಪಿ ಜನೋ ಯೋಗ್ಯತ್ವಾದಧಿಕಂ ಸ್ವಂ ನ ಮನ್ಯತಾಂ ಕಿನ್ತು ಈಶ್ವರೋ ಯಸ್ಮೈ ಪ್ರತ್ಯಯಸ್ಯ ಯತ್ಪರಿಮಾಣಮ್ ಅದದಾತ್ ಸ ತದನುಸಾರತೋ ಯೋಗ್ಯರೂಪಂ ಸ್ವಂ ಮನುತಾಮ್, ಈಶ್ವರಾದ್ ಅನುಗ್ರಹಂ ಪ್ರಾಪ್ತಃ ಸನ್ ಯುಷ್ಮಾಕಮ್ ಏಕೈಕಂ ಜನಮ್ ಇತ್ಯಾಜ್ಞಾಪಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","ಯತೋ ಯದ್ವದಸ್ಮಾಕಮ್ ಏಕಸ್ಮಿನ್ ಶರೀರೇ ಬಹೂನ್ಯಙ್ಗಾನಿ ಸನ್ತಿ ಕಿನ್ತು ಸರ್ವ್ವೇಷಾಮಙ್ಗಾನಾಂ ಕಾರ್ಯ್ಯಂ ಸಮಾನಂ ನಹಿ; ");
INSERT INTO sankan_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","ತದ್ವದಸ್ಮಾಕಂ ಬಹುತ್ವೇಽಪಿ ಸರ್ವ್ವೇ ವಯಂ ಖ್ರೀಷ್ಟೇ ಏಕಶರೀರಾಃ ಪರಸ್ಪರಮ್ ಅಙ್ಗಪ್ರತ್ಯಙ್ಗತ್ವೇನ ಭವಾಮಃ| ");
INSERT INTO sankan_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","ಅಸ್ಮಾದ್ ಈಶ್ವರಾನುಗ್ರಹೇಣ ವಿಶೇಷಂ ವಿಶೇಷಂ ದಾನಮ್ ಅಸ್ಮಾಸು ಪ್ರಾಪ್ತೇಷು ಸತ್ಸು ಕೋಪಿ ಯದಿ ಭವಿಷ್ಯದ್ವಾಕ್ಯಂ ವದತಿ ತರ್ಹಿ ಪ್ರತ್ಯಯಸ್ಯ ಪರಿಮಾಣಾನುಸಾರತಃ ಸ ತದ್ ವದತು; ");
INSERT INTO sankan_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","ಯದ್ವಾ ಯದಿ ಕಶ್ಚಿತ್ ಸೇವನಕಾರೀ ಭವತಿ ತರ್ಹಿ ಸ ತತ್ಸೇವನಂ ಕರೋತು; ಅಥವಾ ಯದಿ ಕಶ್ಚಿದ್ ಅಧ್ಯಾಪಯಿತಾ ಭವತಿ ತರ್ಹಿ ಸೋಽಧ್ಯಾಪಯತು; ");
INSERT INTO sankan_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","ತಥಾ ಯ ಉಪದೇಷ್ಟಾ ಭವತಿ ಸ ಉಪದಿಶತು ಯಶ್ಚ ದಾತಾ ಸ ಸರಲತಯಾ ದದಾತು ಯಸ್ತ್ವಧಿಪತಿಃ ಸ ಯತ್ನೇನಾಧಿಪತಿತ್ವಂ ಕರೋತು ಯಶ್ಚ ದಯಾಲುಃ ಸ ಹೃಷ್ಟಮನಸಾ ದಯತಾಮ್| ");
INSERT INTO sankan_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","ಅಪರಞ್ಚ ಯುಷ್ಮಾಕಂ ಪ್ರೇಮ ಕಾಪಟ್ಯವರ್ಜಿತಂ ಭವತು ಯದ್ ಅಭದ್ರಂ ತದ್ ಋತೀಯಧ್ವಂ ಯಚ್ಚ ಭದ್ರಂ ತಸ್ಮಿನ್ ಅನುರಜ್ಯಧ್ವಮ್| ");
INSERT INTO sankan_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","ಅಪರಂ ಭ್ರಾತೃತ್ವಪ್ರೇಮ್ನಾ ಪರಸ್ಪರಂ ಪ್ರೀಯಧ್ವಂ ಸಮಾದರಾದ್ ಏಕೋಽಪರಜನಂ ಶ್ರೇಷ್ಠಂ ಜಾನೀಧ್ವಮ್| ");
INSERT INTO sankan_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","ತಥಾ ಕಾರ್ಯ್ಯೇ ನಿರಾಲಸ್ಯಾ ಮನಸಿ ಚ ಸೋದ್ಯೋಗಾಃ ಸನ್ತಃ ಪ್ರಭುಂ ಸೇವಧ್ವಮ್| ");
INSERT INTO sankan_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","ಅಪರಂ ಪ್ರತ್ಯಾಶಾಯಾಮ್ ಆನನ್ದಿತಾ ದುಃಖಸಮಯೇ ಚ ಧೈರ್ಯ್ಯಯುಕ್ತಾ ಭವತ; ಪ್ರಾರ್ಥನಾಯಾಂ ಸತತಂ ಪ್ರವರ್ತ್ತಧ್ವಂ| ");
INSERT INTO sankan_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","ಪವಿತ್ರಾಣಾಂ ದೀನತಾಂ ದೂರೀಕುರುಧ್ವಮ್ ಅತಿಥಿಸೇವಾಯಾಮ್ ಅನುರಜ್ಯಧ್ವಮ್| ");
INSERT INTO sankan_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","ಯೇ ಜನಾ ಯುಷ್ಮಾನ್ ತಾಡಯನ್ತಿ ತಾನ್ ಆಶಿಷಂ ವದತ ಶಾಪಮ್ ಅದತ್ತ್ವಾ ದದ್ಧ್ವಮಾಶಿಷಮ್| ");
INSERT INTO sankan_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","ಯೇ ಜನಾ ಆನನ್ದನ್ತಿ ತೈಃ ಸಾರ್ದ್ಧಮ್ ಆನನ್ದತ ಯೇ ಚ ರುದನ್ತಿ ತೈಃ ಸಹ ರುದಿತ| ");
INSERT INTO sankan_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","ಅಪರಞ್ಚ ಯುಷ್ಮಾಕಂ ಮನಸಾಂ ಪರಸ್ಪರಮ್ ಏಕೋಭಾವೋ ಭವತು; ಅಪರಮ್ ಉಚ್ಚಪದಮ್ ಅನಾಕಾಙ್ಕ್ಷ್ಯ ನೀಚಲೋಕೈಃ ಸಹಾಪಿ ಮಾರ್ದವಮ್ ಆಚರತ; ಸ್ವಾನ್ ಜ್ಞಾನಿನೋ ನ ಮನ್ಯಧ್ವಂ| ");
INSERT INTO sankan_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","ಪರಸ್ಮಾದ್ ಅಪಕಾರಂ ಪ್ರಾಪ್ಯಾಪಿ ಪರಂ ನಾಪಕುರುತ| ಸರ್ವ್ವೇಷಾಂ ದೃಷ್ಟಿತೋ ಯತ್ ಕರ್ಮ್ಮೋತ್ತಮಂ ತದೇವ ಕುರುತ| ");
INSERT INTO sankan_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","ಯದಿ ಭವಿತುಂ ಶಕ್ಯತೇ ತರ್ಹಿ ಯಥಾಶಕ್ತಿ ಸರ್ವ್ವಲೋಕೈಃ ಸಹ ನಿರ್ವ್ವಿರೋಧೇನ ಕಾಲಂ ಯಾಪಯತ| ");
INSERT INTO sankan_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","ಹೇ ಪ್ರಿಯಬನ್ಧವಃ, ಕಸ್ಮೈಚಿದ್ ಅಪಕಾರಸ್ಯ ಸಮುಚಿತಂ ದಣ್ಡಂ ಸ್ವಯಂ ನ ದದ್ಧ್ವಂ, ಕಿನ್ತ್ವೀಶ್ವರೀಯಕ್ರೋಧಾಯ ಸ್ಥಾನಂ ದತ್ತ ಯತೋ ಲಿಖಿತಮಾಸ್ತೇ ಪರಮೇಶ್ವರಃ ಕಥಯತಿ, ದಾನಂ ಫಲಸ್ಯ ಮತ್ಕರ್ಮ್ಮ ಸೂಚಿತಂ ಪ್ರದದಾಮ್ಯಹಂ| ");
INSERT INTO sankan_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","ಇತಿಕಾರಣಾದ್ ರಿಪು ರ್ಯದಿ ಕ್ಷುಧಾರ್ತ್ತಸ್ತೇ ತರ್ಹಿ ತಂ ತ್ವಂ ಪ್ರಭೋಜಯ| ತಥಾ ಯದಿ ತೃಷಾರ್ತ್ತಃ ಸ್ಯಾತ್ ತರ್ಹಿ ತಂ ಪರಿಪಾಯಯ| ತೇನ ತ್ವಂ ಮಸ್ತಕೇ ತಸ್ಯ ಜ್ವಲದಗ್ನಿಂ ನಿಧಾಸ್ಯಸಿ| ");
INSERT INTO sankan_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","ಕುಕ್ರಿಯಯಾ ಪರಾಜಿತಾ ನ ಸನ್ತ ಉತ್ತಮಕ್ರಿಯಯಾ ಕುಕ್ರಿಯಾಂ ಪರಾಜಯತ| ");
INSERT INTO sankan_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","ಯುಷ್ಮಾಕಮ್ ಏಕೈಕಜನಃ ಶಾಸನಪದಸ್ಯ ನಿಘ್ನೋ ಭವತು ಯತೋ ಯಾನಿ ಶಾಸನಪದಾನಿ ಸನ್ತಿ ತಾನಿ ಸರ್ವ್ವಾಣೀಶ್ವರೇಣ ಸ್ಥಾಪಿತಾನಿ; ಈಶ್ವರಂ ವಿನಾ ಪದಸ್ಥಾಪನಂ ನ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","ಇತಿ ಹೇತೋಃ ಶಾಸನಪದಸ್ಯ ಯತ್ ಪ್ರಾತಿಕೂಲ್ಯಂ ತದ್ ಈಶ್ವರೀಯನಿರೂಪಣಸ್ಯ ಪ್ರಾತಿಕೂಲ್ಯಮೇವ; ಅಪರಂ ಯೇ ಪ್ರಾತಿಕೂಲ್ಯಮ್ ಆಚರನ್ತಿ ತೇ ಸ್ವೇಷಾಂ ಸಮುಚಿತಂ ದಣ್ಡಂ ಸ್ವಯಮೇವ ಘಟಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","ಶಾಸ್ತಾ ಸದಾಚಾರಿಣಾಂ ಭಯಪ್ರದೋ ನಹಿ ದುರಾಚಾರಿಣಾಮೇವ ಭಯಪ್ರದೋ ಭವತಿ; ತ್ವಂ ಕಿಂ ತಸ್ಮಾನ್ ನಿರ್ಭಯೋ ಭವಿತುಮ್ ಇಚ್ಛಸಿ? ತರ್ಹಿ ಸತ್ಕರ್ಮ್ಮಾಚರ, ತಸ್ಮಾದ್ ಯಶೋ ಲಪ್ಸ್ಯಸೇ, ");
INSERT INTO sankan_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","ಯತಸ್ತವ ಸದಾಚರಣಾಯ ಸ ಈಶ್ವರಸ್ಯ ಭೃತ್ಯೋಽಸ್ತಿ| ಕಿನ್ತು ಯದಿ ಕುಕರ್ಮ್ಮಾಚರಸಿ ತರ್ಹಿ ತ್ವಂ ಶಙ್ಕಸ್ವ ಯತಃ ಸ ನಿರರ್ಥಕಂ ಖಙ್ಗಂ ನ ಧಾರಯತಿ; ಕುಕರ್ಮ್ಮಾಚಾರಿಣಂ ಸಮುಚಿತಂ ದಣ್ಡಯಿತುಮ್ ಸ ಈಶ್ವರಸ್ಯ ದಣ್ಡದಭೃತ್ಯ ಏವ| ");
INSERT INTO sankan_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","ಅತಏವ ಕೇವಲದಣ್ಡಭಯಾನ್ನಹಿ ಕಿನ್ತು ಸದಸದ್ಬೋಧಾದಪಿ ತಸ್ಯ ವಶ್ಯೇನ ಭವಿತವ್ಯಂ| ");
INSERT INTO sankan_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","ಏತಸ್ಮಾದ್ ಯುಷ್ಮಾಕಂ ರಾಜಕರದಾನಮಪ್ಯುಚಿತಂ ಯಸ್ಮಾದ್ ಯೇ ಕರಂ ಗೃಹ್ಲನ್ತಿ ತ ಈಶ್ವರಸ್ಯ ಕಿಙ್ಕರಾ ಭೂತ್ವಾ ಸತತಮ್ ಏತಸ್ಮಿನ್ ಕರ್ಮ್ಮಣಿ ನಿವಿಷ್ಟಾಸ್ತಿಷ್ಠನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","ಅಸ್ಮಾತ್ ಕರಗ್ರಾಹಿಣೇ ಕರಂ ದತ್ತ, ತಥಾ ಶುಲ್ಕಗ್ರಾಹಿಣೇ ಶುಲ್ಕಂ ದತ್ತ, ಅಪರಂ ಯಸ್ಮಾದ್ ಭೇತವ್ಯಂ ತಸ್ಮಾದ್ ಬಿಭೀತ, ಯಶ್ಚ ಸಮಾದರಣೀಯಸ್ತಂ ಸಮಾದ್ರಿಯಧ್ವಮ್; ಇತ್ಥಂ ಯಸ್ಯ ಯತ್ ಪ್ರಾಪ್ಯಂ ತತ್ ತಸ್ಮೈ ದತ್ತ| ");
INSERT INTO sankan_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","ಯುಷ್ಮಾಕಂ ಪರಸ್ಪರಂ ಪ್ರೇಮ ವಿನಾ ಽನ್ಯತ್ ಕಿಮಪಿ ದೇಯಮ್ ಋಣಂ ನ ಭವತು, ಯತೋ ಯಃ ಪರಸ್ಮಿನ್ ಪ್ರೇಮ ಕರೋತಿ ತೇನ ವ್ಯವಸ್ಥಾ ಸಿಧ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","ವಸ್ತುತಃ ಪರದಾರಾನ್ ಮಾ ಗಚ್ಛ, ನರಹತ್ಯಾಂ ಮಾ ಕಾರ್ಷೀಃ, ಚೈರ್ಯ್ಯಂ ಮಾ ಕಾರ್ಷೀಃ, ಮಿಥ್ಯಾಸಾಕ್ಷ್ಯಂ ಮಾ ದೇಹಿ, ಲೋಭಂ ಮಾ ಕಾರ್ಷೀಃ, ಏತಾಃ ಸರ್ವ್ವಾ ಆಜ್ಞಾ ಏತಾಭ್ಯೋ ಭಿನ್ನಾ ಯಾ ಕಾಚಿದ್ ಆಜ್ಞಾಸ್ತಿ ಸಾಪಿ ಸ್ವಸಮೀಪವಾಸಿನಿ ಸ್ವವತ್ ಪ್ರೇಮ ಕುರ್ವ್ವಿತ್ಯನೇನ ವಚನೇನ ವೇದಿತಾ| ");
INSERT INTO sankan_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","ಯತಃ ಪ್ರೇಮ ಸಮೀಪವಾಸಿನೋಽಶುಭಂ ನ ಜನಯತಿ ತಸ್ಮಾತ್ ಪ್ರೇಮ್ನಾ ಸರ್ವ್ವಾ ವ್ಯವಸ್ಥಾ ಪಾಲ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","ಪ್ರತ್ಯಯೀಭವನಕಾಲೇಽಸ್ಮಾಕಂ ಪರಿತ್ರಾಣಸ್ಯ ಸಾಮೀಪ್ಯಾದ್ ಇದಾನೀಂ ತಸ್ಯ ಸಾಮೀಪ್ಯಮ್ ಅವ್ಯವಹಿತಂ; ಅತಃ ಸಮಯಂ ವಿವಿಚ್ಯಾಸ್ಮಾಭಿಃ ಸಾಮ್ಪ್ರತಮ್ ಅವಶ್ಯಮೇವ ನಿದ್ರಾತೋ ಜಾಗರ್ತ್ತವ್ಯಂ| ");
INSERT INTO sankan_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","ಬಹುತರಾ ಯಾಮಿನೀ ಗತಾ ಪ್ರಭಾತಂ ಸನ್ನಿಧಿಂ ಪ್ರಾಪ್ತಂ ತಸ್ಮಾತ್ ತಾಮಸೀಯಾಃ ಕ್ರಿಯಾಃ ಪರಿತ್ಯಜ್ಯಾಸ್ಮಾಭಿ ರ್ವಾಸರೀಯಾ ಸಜ್ಜಾ ಪರಿಧಾತವ್ಯಾ| ");
INSERT INTO sankan_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","ಅತೋ ಹೇತೋ ರ್ವಯಂ ದಿವಾ ವಿಹಿತಂ ಸದಾಚರಣಮ್ ಆಚರಿಷ್ಯಾಮಃ| ರಙ್ಗರಸೋ ಮತ್ತತ್ವಂ ಲಮ್ಪಟತ್ವಂ ಕಾಮುಕತ್ವಂ ವಿವಾದ ಈರ್ಷ್ಯಾ ಚೈತಾನಿ ಪರಿತ್ಯಕ್ಷ್ಯಾಮಃ| ");
INSERT INTO sankan_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","ಯೂಯಂ ಪ್ರಭುಯೀಶುಖ್ರೀಷ್ಟರೂಪಂ ಪರಿಚ್ಛದಂ ಪರಿಧದ್ಧ್ವಂ ಸುಖಾಭಿಲಾಷಪೂರಣಾಯ ಶಾರೀರಿಕಾಚರಣಂ ಮಾಚರತ| ");
INSERT INTO sankan_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","ಯೋ ಜನೋಽದೃಢವಿಶ್ವಾಸಸ್ತಂ ಯುಷ್ಮಾಕಂ ಸಙ್ಗಿನಂ ಕುರುತ ಕಿನ್ತು ಸನ್ದೇಹವಿಚಾರಾರ್ಥಂ ನಹಿ| ");
INSERT INTO sankan_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","ಯತೋ ನಿಷಿದ್ಧಂ ಕಿಮಪಿ ಖಾದ್ಯದ್ರವ್ಯಂ ನಾಸ್ತಿ, ಕಸ್ಯಚಿಜ್ಜನಸ್ಯ ಪ್ರತ್ಯಯ ಏತಾದೃಶೋ ವಿದ್ಯತೇ ಕಿನ್ತ್ವದೃಢವಿಶ್ವಾಸಃ ಕಶ್ಚಿದಪರೋ ಜನಃ ಕೇವಲಂ ಶಾಕಂ ಭುಙ್ಕ್ತಂ| ");
INSERT INTO sankan_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","ತರ್ಹಿ ಯೋ ಜನಃ ಸಾಧಾರಣಂ ದ್ರವ್ಯಂ ಭುಙ್ಕ್ತೇ ಸ ವಿಶೇಷದ್ರವ್ಯಭೋಕ್ತಾರಂ ನಾವಜಾನೀಯಾತ್ ತಥಾ ವಿಶೇಷದ್ರವ್ಯಭೋಕ್ತಾಪಿ ಸಾಧಾರಣದ್ರವ್ಯಭೋಕ್ತಾರಂ ದೋಷಿಣಂ ನ ಕುರ್ಯ್ಯಾತ್, ಯಸ್ಮಾದ್ ಈಶ್ವರಸ್ತಮ್ ಅಗೃಹ್ಲಾತ್| ");
INSERT INTO sankan_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","ಹೇ ಪರದಾಸಸ್ಯ ದೂಷಯಿತಸ್ತ್ವಂ ಕಃ? ನಿಜಪ್ರಭೋಃ ಸಮೀಪೇ ತೇನ ಪದಸ್ಥೇನ ಪದಚ್ಯುತೇನ ವಾ ಭವಿತವ್ಯಂ ಸ ಚ ಪದಸ್ಥ ಏವ ಭವಿಷ್ಯತಿ ಯತ ಈಶ್ವರಸ್ತಂ ಪದಸ್ಥಂ ಕರ್ತ್ತುಂ ಶಕ್ನೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","ಅಪರಞ್ಚ ಕಶ್ಚಿಜ್ಜನೋ ದಿನಾದ್ ದಿನಂ ವಿಶೇಷಂ ಮನ್ಯತೇ ಕಶ್ಚಿತ್ತುु ಸರ್ವ್ವಾಣಿ ದಿನಾನಿ ಸಮಾನಾನಿ ಮನ್ಯತೇ, ಏಕೈಕೋ ಜನಃ ಸ್ವೀಯಮನಸಿ ವಿವಿಚ್ಯ ನಿಶ್ಚಿನೋತು| ");
INSERT INTO sankan_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","ಯೋ ಜನಃ ಕಿಞ್ಚನ ದಿನಂ ವಿಶೇಷಂ ಮನ್ಯತೇ ಸ ಪ್ರಭುಭಕ್ತ್ಯಾ ತನ್ ಮನ್ಯತೇ, ಯಶ್ಚ ಜನಃ ಕಿಮಪಿ ದಿನಂ ವಿಶೇಷಂ ನ ಮನ್ಯತೇ ಸೋಽಪಿ ಪ್ರಭುಭಕ್ತ್ಯಾ ತನ್ನ ಮನ್ಯತೇ; ಅಪರಞ್ಚ ಯಃ ಸರ್ವ್ವಾಣಿ ಭಕ್ಷ್ಯದ್ರವ್ಯಾಣಿ ಭುಙ್ಕ್ತೇ ಸ ಪ್ರಭುಭಕ್ತಯಾ ತಾನಿ ಭುಙ್ಕ್ತೇ ಯತಃ ಸ ಈಶ್ವರಂ ಧನ್ಯಂ ವಕ್ತಿ, ಯಶ್ಚ ನ ಭುಙ್ಕ್ತೇ ಸೋಽಪಿ ಪ್ರಭುಭಕ್ತ್ಯೈವ ನ ಭುಞ್ಜಾನ ಈಶ್ವರಂ ಧನ್ಯಂ ಬ್ರೂತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","ಅಪರಮ್ ಅಸ್ಮಾಕಂ ಕಶ್ಚಿತ್ ನಿಜನಿಮಿತ್ತಂ ಪ್ರಾಣಾನ್ ಧಾರಯತಿ ನಿಜನಿಮಿತ್ತಂ ಮ್ರಿಯತೇ ವಾ ತನ್ನ; ");
INSERT INTO sankan_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","ಕಿನ್ತು ಯದಿ ವಯಂ ಪ್ರಾಣಾನ್ ಧಾರಯಾಮಸ್ತರ್ಹಿ ಪ್ರಭುನಿಮಿತ್ತಂ ಧಾರಯಾಮಃ, ಯದಿ ಚ ಪ್ರಾಣಾನ್ ತ್ಯಜಾಮಸ್ತರ್ಹ್ಯಪಿ ಪ್ರಭುನಿಮಿತ್ತಂ ತ್ಯಜಾಮಃ, ಅತಏವ ಜೀವನೇ ಮರಣೇ ವಾ ವಯಂ ಪ್ರಭೋರೇವಾಸ್ಮಹೇ| ");
INSERT INTO sankan_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","ಯತೋ ಜೀವನ್ತೋ ಮೃತಾಶ್ಚೇತ್ಯುಭಯೇಷಾಂ ಲೋಕಾನಾಂ ಪ್ರಭುತ್ವಪ್ರಾಪ್ತ್ಯರ್ಥಂ ಖ್ರೀಷ್ಟೋ ಮೃತ ಉತ್ಥಿತಃ ಪುನರ್ಜೀವಿತಶ್ಚ| ");
INSERT INTO sankan_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","ಕಿನ್ತು ತ್ವಂ ನಿಜಂ ಭ್ರಾತರಂ ಕುತೋ ದೂಷಯಸಿ? ತಥಾ ತ್ವಂ ನಿಜಂ ಭ್ರಾತರಂ ಕುತಸ್ತುಚ್ಛಂ ಜಾನಾಸಿ? ಖ್ರೀಷ್ಟಸ್ಯ ವಿಚಾರಸಿಂಹಾಸನಸ್ಯ ಸಮ್ಮುಖೇ ಸರ್ವ್ವೈರಸ್ಮಾಭಿರುಪಸ್ಥಾತವ್ಯಂ; ");
INSERT INTO sankan_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","ಯಾದೃಶಂ ಲಿಖಿತಮ್ ಆಸ್ತೇ, ಪರೇಶಃ ಶಪಥಂ ಕುರ್ವ್ವನ್ ವಾಕ್ಯಮೇತತ್ ಪುರಾವದತ್| ಸರ್ವ್ವೋ ಜನಃ ಸಮೀಪೇ ಮೇ ಜಾನುಪಾತಂ ಕರಿಷ್ಯತಿ| ಜಿಹ್ವೈಕೈಕಾ ತಥೇಶಸ್ಯ ನಿಘ್ನತ್ವಂ ಸ್ವೀಕರಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","ಅತಏವ ಈಶ್ವರಸಮೀಪೇಽಸ್ಮಾಕಮ್ ಏಕೈಕಜನೇನ ನಿಜಾ ಕಥಾ ಕಥಯಿತವ್ಯಾ| ");
INSERT INTO sankan_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","ಇತ್ಥಂ ಸತಿ ವಯಮ್ ಅದ್ಯಾರಭ್ಯ ಪರಸ್ಪರಂ ನ ದೂಷಯನ್ತಃ ಸ್ವಭ್ರಾತು ರ್ವಿಘ್ನೋ ವ್ಯಾಘಾತೋ ವಾ ಯನ್ನ ಜಾಯೇತ ತಾದೃಶೀಮೀಹಾಂ ಕುರ್ಮ್ಮಹೇ| ");
INSERT INTO sankan_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","ಕಿಮಪಿ ವಸ್ತು ಸ್ವಭಾವತೋ ನಾಶುಚಿ ಭವತೀತ್ಯಹಂ ಜಾನೇ ತಥಾ ಪ್ರಭುನಾ ಯೀಶುಖ್ರೀಷ್ಟೇನಾಪಿ ನಿಶ್ಚಿತಂ ಜಾನೇ, ಕಿನ್ತು ಯೋ ಜನೋ ಯದ್ ದ್ರವ್ಯಮ್ ಅಪವಿತ್ರಂ ಜಾನೀತೇ ತಸ್ಯ ಕೃತೇ ತದ್ ಅಪವಿತ್ರಮ್ ಆಸ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","ಅತಏವ ತವ ಭಕ್ಷ್ಯದ್ರವ್ಯೇಣ ತವ ಭ್ರಾತಾ ಶೋಕಾನ್ವಿತೋ ಭವತಿ ತರ್ಹಿ ತ್ವಂ ಭ್ರಾತರಂ ಪ್ರತಿ ಪ್ರೇಮ್ನಾ ನಾಚರಸಿ| ಖ್ರೀಷ್ಟೋ ಯಸ್ಯ ಕೃತೇ ಸ್ವಪ್ರಾಣಾನ್ ವ್ಯಯಿತವಾನ್ ತ್ವಂ ನಿಜೇನ ಭಕ್ಷ್ಯದ್ರವ್ಯೇಣ ತಂ ನ ನಾಶಯ| ");
INSERT INTO sankan_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","ಅಪರಂ ಯುಷ್ಮಾಕಮ್ ಉತ್ತಮಂ ಕರ್ಮ್ಮ ನಿನ್ದಿತಂ ನ ಭವತು| ");
INSERT INTO sankan_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","ಭಕ್ಷ್ಯಂ ಪೇಯಞ್ಚೇಶ್ವರರಾಜ್ಯಸ್ಯ ಸಾರೋ ನಹಿ, ಕಿನ್ತು ಪುಣ್ಯಂ ಶಾನ್ತಿಶ್ಚ ಪವಿತ್ರೇಣಾತ್ಮನಾ ಜಾತ ಆನನ್ದಶ್ಚ| ");
INSERT INTO sankan_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","ಏತೈ ರ್ಯೋ ಜನಃ ಖ್ರೀಷ್ಟಂ ಸೇವತೇ, ಸ ಏವೇಶ್ವರಸ್ಯ ತುಷ್ಟಿಕರೋ ಮನುಷ್ಯೈಶ್ಚ ಸುಖ್ಯಾತಃ| ");
INSERT INTO sankan_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","ಅತಏವ ಯೇನಾಸ್ಮಾಕಂ ಸರ್ವ್ವೇಷಾಂ ಪರಸ್ಪರಮ್ ಐಕ್ಯಂ ನಿಷ್ಠಾ ಚ ಜಾಯತೇ ತದೇವಾಸ್ಮಾಭಿ ರ್ಯತಿತವ್ಯಂ| ");
INSERT INTO sankan_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","ಭಕ್ಷ್ಯಾರ್ಥಮ್ ಈಶ್ವರಸ್ಯ ಕರ್ಮ್ಮಣೋ ಹಾನಿಂ ಮಾ ಜನಯತ; ಸರ್ವ್ವಂ ವಸ್ತು ಪವಿತ್ರಮಿತಿ ಸತ್ಯಂ ತಥಾಪಿ ಯೋ ಜನೋ ಯದ್ ಭುಕ್ತ್ವಾ ವಿಘ್ನಂ ಲಭತೇ ತದರ್ಥಂ ತದ್ ಭದ್ರಂ ನಹಿ| ");
INSERT INTO sankan_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","ತವ ಮಾಂಸಭಕ್ಷಣಸುರಾಪಾನಾದಿಭಿಃ ಕ್ರಿಯಾಭಿ ರ್ಯದಿ ತವ ಭ್ರಾತುಃ ಪಾದಸ್ಖಲನಂ ವಿಘ್ನೋ ವಾ ಚಾಞ್ಚಲ್ಯಂ ವಾ ಜಾಯತೇ ತರ್ಹಿ ತದ್ಭೋಜನಪಾನಯೋಸ್ತ್ಯಾಗೋ ಭದ್ರಃ| ");
INSERT INTO sankan_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","ಯದಿ ತವ ಪ್ರತ್ಯಯಸ್ತಿಷ್ಠತಿ ತರ್ಹೀಶ್ವರಸ್ಯ ಗೋಚರೇ ಸ್ವಾನ್ತರೇ ತಂ ಗೋಪಯ; ಯೋ ಜನಃ ಸ್ವಮತೇನ ಸ್ವಂ ದೋಷಿಣಂ ನ ಕರೋತಿ ಸ ಏವ ಧನ್ಯಃ| ");
INSERT INTO sankan_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","ಕಿನ್ತು ಯಃ ಕಶ್ಚಿತ್ ಸಂಶಯ್ಯ ಭುಙ್ಕ್ತೇಽರ್ಥಾತ್ ನ ಪ್ರತೀತ್ಯ ಭುಙ್ಕ್ತೇ, ಸ ಏವಾವಶ್ಯಂ ದಣ್ಡಾರ್ಹೋ ಭವಿಷ್ಯತಿ, ಯತೋ ಯತ್ ಪ್ರತ್ಯಯಜಂ ನಹಿ ತದೇವ ಪಾಪಮಯಂ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","ಬಲವದ್ಭಿರಸ್ಮಾಭಿ ರ್ದುರ್ಬ್ಬಲಾನಾಂ ದೌರ್ಬ್ಬಲ್ಯಂ ಸೋಢವ್ಯಂ ನ ಚ ಸ್ವೇಷಾಮ್ ಇಷ್ಟಾಚಾರ ಆಚರಿತವ್ಯಃ| ");
INSERT INTO sankan_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","ಅಸ್ಮಾಕಮ್ ಏಕೈಕೋ ಜನಃ ಸ್ವಸಮೀಪವಾಸಿನೋ ಹಿತಾರ್ಥಂ ನಿಷ್ಠಾರ್ಥಞ್ಚ ತಸ್ಯೈವೇಷ್ಟಾಚಾರಮ್ ಆಚರತು| ");
INSERT INTO sankan_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","ಯತಃ ಖ್ರೀಷ್ಟೋಽಪಿ ನಿಜೇಷ್ಟಾಚಾರಂ ನಾಚರಿತವಾನ್, ಯಥಾ ಲಿಖಿತಮ್ ಆಸ್ತೇ, ತ್ವನ್ನಿನ್ದಕಗಣಸ್ಯೈವ ನಿನ್ದಾಭಿ ರ್ನಿನ್ದಿತೋಽಸ್ಮ್ಯಹಂ| ");
INSERT INTO sankan_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","ಅಪರಞ್ಚ ವಯಂ ಯತ್ ಸಹಿಷ್ಣುತಾಸಾನ್ತ್ವನಯೋ ರ್ಜನಕೇನ ಶಾಸ್ತ್ರೇಣ ಪ್ರತ್ಯಾಶಾಂ ಲಭೇಮಹಿ ತನ್ನಿಮಿತ್ತಂ ಪೂರ್ವ್ವಕಾಲೇ ಲಿಖಿತಾನಿ ಸರ್ವ್ವವಚನಾನ್ಯಸ್ಮಾಕಮ್ ಉಪದೇಶಾರ್ಥಮೇವ ಲಿಲಿಖಿರೇ| ");
INSERT INTO sankan_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","ಸಹಿಷ್ಣುತಾಸಾನ್ತ್ವನಯೋರಾಕರೋ ಯ ಈಶ್ವರಃ ಸ ಏವಂ ಕರೋತು ಯತ್ ಪ್ರಭು ರ್ಯೀಶುಖ್ರೀಷ್ಟ ಇವ ಯುಷ್ಮಾಕಮ್ ಏಕಜನೋಽನ್ಯಜನೇನ ಸಾರ್ದ್ಧಂ ಮನಸ ಐಕ್ಯಮ್ ಆಚರೇತ್; ");
INSERT INTO sankan_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","ಯೂಯಞ್ಚ ಸರ್ವ್ವ ಏಕಚಿತ್ತಾ ಭೂತ್ವಾ ಮುಖೈಕೇನೇವಾಸ್ಮತ್ಪ್ರಭುಯೀಶುಖ್ರೀಷ್ಟಸ್ಯ ಪಿತುರೀಶ್ವರಸ್ಯ ಗುಣಾನ್ ಕೀರ್ತ್ತಯೇತ| ");
INSERT INTO sankan_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","ಅಪರಮ್ ಈಶ್ವರಸ್ಯ ಮಹಿಮ್ನಃ ಪ್ರಕಾಶಾರ್ಥಂ ಖ್ರೀಷ್ಟೋ ಯಥಾ ಯುಷ್ಮಾನ್ ಪ್ರತ್ಯಗೃಹ್ಲಾತ್ ತಥಾ ಯುಷ್ಮಾಕಮಪ್ಯೇಕೋ ಜನೋಽನ್ಯಜನಂ ಪ್ರತಿಗೃಹ್ಲಾತು| ");
INSERT INTO sankan_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","ಯಥಾ ಲಿಖಿತಮ್ ಆಸ್ತೇ, ಅತೋಽಹಂ ಸಮ್ಮುಖೇ ತಿಷ್ಠನ್ ಭಿನ್ನದೇಶನಿವಾಸಿನಾಂ| ಸ್ತುವಂಸ್ತ್ವಾಂ ಪರಿಗಾಸ್ಯಾಮಿ ತವ ನಾಮ್ನಿ ಪರೇಶ್ವರ|| ");
INSERT INTO sankan_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","ತಸ್ಯ ದಯಾಲುತ್ವಾಚ್ಚ ಭಿನ್ನಜಾತೀಯಾ ಯದ್ ಈಶ್ವರಸ್ಯ ಗುಣಾನ್ ಕೀರ್ತ್ತಯೇಯುಸ್ತದರ್ಥಂ ಯೀಶುಃ ಖ್ರೀಷ್ಟಸ್ತ್ವಕ್ಛೇದನಿಯಮಸ್ಯ ನಿಘ್ನೋಽಭವದ್ ಇತ್ಯಹಂ ವದಾಮಿ| ಯಥಾ ಲಿಖಿತಮ್ ಆಸ್ತೇ, ಅತೋಽಹಂ ಸಮ್ಮುಖೇ ತಿಷ್ಠನ್ ಭಿನ್ನದೇಶನಿವಾಸಿನಾಂ| ಸ್ತುವಂಸ್ತ್ವಾಂ ಪರಿಗಾಸ್ಯಾಮಿ ತವ ನಾಮ್ನಿ ಪರೇಶ್ವರ|| ");
INSERT INTO sankan_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","ಅಪರಮಪಿ ಲಿಖಿತಮ್ ಆಸ್ತೇ, ಹೇ ಅನ್ಯಜಾತಯೋ ಯೂಯಂ ಸಮಂ ನನ್ದತ ತಜ್ಜನೈಃ| ");
INSERT INTO sankan_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","ಪುನಶ್ಚ ಲಿಖಿತಮ್ ಆಸ್ತೇ, ಹೇ ಸರ್ವ್ವದೇಶಿನೋ ಯೂಯಂ ಧನ್ಯಂ ಬ್ರೂತ ಪರೇಶ್ವರಂ| ಹೇ ತದೀಯನರಾ ಯೂಯಂ ಕುರುಧ್ವಂ ತತ್ಪ್ರಶಂಸನಂ|| ");
INSERT INTO sankan_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","ಅಪರ ಯೀಶಾಯಿಯೋಽಪಿ ಲಿಲೇಖ, ಯೀಶಯಸ್ಯ ತು ಯತ್ ಮೂಲಂ ತತ್ ಪ್ರಕಾಶಿಷ್ಯತೇ ತದಾ| ಸರ್ವ್ವಜಾತೀಯನೃಣಾಞ್ಚ ಶಾಸಕಃ ಸಮುದೇಷ್ಯತಿ| ತತ್ರಾನ್ಯದೇಶಿಲೋಕೈಶ್ಚ ಪ್ರತ್ಯಾಶಾ ಪ್ರಕರಿಷ್ಯತೇ|| ");
INSERT INTO sankan_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","ಅತಏವ ಯೂಯಂ ಪವಿತ್ರಸ್ಯಾತ್ಮನಃ ಪ್ರಭಾವಾದ್ ಯತ್ ಸಮ್ಪೂರ್ಣಾಂ ಪ್ರತ್ಯಾಶಾಂ ಲಪ್ಸ್ಯಧ್ವೇ ತದರ್ಥಂ ತತ್ಪ್ರತ್ಯಾಶಾಜನಕ ಈಶ್ವರಃ ಪ್ರತ್ಯಯೇನ ಯುಷ್ಮಾನ್ ಶಾನ್ತ್ಯಾನನ್ದಾಭ್ಯಾಂ ಸಮ್ಪೂರ್ಣಾನ್ ಕರೋತು| ");
INSERT INTO sankan_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","ಹೇ ಭ್ರಾತರೋ ಯೂಯಂ ಸದ್ಭಾವಯುಕ್ತಾಃ ಸರ್ವ್ವಪ್ರಕಾರೇಣ ಜ್ಞಾನೇನ ಚ ಸಮ್ಪೂರ್ಣಾಃ ಪರಸ್ಪರೋಪದೇಶೇ ಚ ತತ್ಪರಾ ಇತ್ಯಹಂ ನಿಶ್ಚಿತಂ ಜಾನಾಮಿ, ");
INSERT INTO sankan_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","ತಥಾಪ್ಯಹಂ ಯತ್ ಪ್ರಗಲ್ಭತರೋ ಭವನ್ ಯುಷ್ಮಾನ್ ಪ್ರಬೋಧಯಾಮಿ ತಸ್ಯೈಕಂ ಕಾರಣಮಿದಂ| ");
INSERT INTO sankan_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","ಭಿನ್ನಜಾತೀಯಾಃ ಪವಿತ್ರೇಣಾತ್ಮನಾ ಪಾವಿತನೈವೇದ್ಯರೂಪಾ ಭೂತ್ವಾ ಯದ್ ಗ್ರಾಹ್ಯಾ ಭವೇಯುಸ್ತನ್ನಿಮಿತ್ತಮಹಮ್ ಈಶ್ವರಸ್ಯ ಸುಸಂವಾದಂ ಪ್ರಚಾರಯಿತುಂ ಭಿನ್ನಜಾತೀಯಾನಾಂ ಮಧ್ಯೇ ಯೀಶುಖ್ರೀಷ್ಟಸ್ಯ ಸೇವಕತ್ವಂ ದಾನಂ ಈಶ್ವರಾತ್ ಲಬ್ಧವಾನಸ್ಮಿ| ");
INSERT INTO sankan_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","ಈಶ್ವರಂ ಪ್ರತಿ ಯೀಶುಖ್ರೀಷ್ಟೇನ ಮಮ ಶ್ಲಾಘಾಕರಣಸ್ಯ ಕಾರಣಮ್ ಆಸ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","ಭಿನ್ನದೇಶಿನ ಆಜ್ಞಾಗ್ರಾಹಿಣಃ ಕರ್ತ್ತುಂ ಖ್ರೀಷ್ಟೋ ವಾಕ್ಯೇನ ಕ್ರಿಯಯಾ ಚ, ಆಶ್ಚರ್ಯ್ಯಲಕ್ಷಣೈಶ್ಚಿತ್ರಕ್ರಿಯಾಭಿಃ ಪವಿತ್ರಸ್ಯಾತ್ಮನಃ ಪ್ರಭಾವೇನ ಚ ಯಾನಿ ಕರ್ಮ್ಮಾಣಿ ಮಯಾ ಸಾಧಿತವಾನ್, ");
INSERT INTO sankan_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","ಕೇವಲಂ ತಾನ್ಯೇವ ವಿನಾನ್ಯಸ್ಯ ಕಸ್ಯಚಿತ್ ಕರ್ಮ್ಮಣೋ ವರ್ಣನಾಂ ಕರ್ತ್ತುಂ ಪ್ರಗಲ್ಭೋ ನ ಭವಾಮಿ| ತಸ್ಮಾತ್ ಆ ಯಿರೂಶಾಲಮ ಇಲ್ಲೂರಿಕಂ ಯಾವತ್ ಸರ್ವ್ವತ್ರ ಖ್ರೀಷ್ಟಸ್ಯ ಸುಸಂವಾದಂ ಪ್ರಾಚಾರಯಂ| ");
INSERT INTO sankan_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","ಅನ್ಯೇನ ನಿಚಿತಾಯಾಂ ಭಿತ್ತಾವಹಂ ಯನ್ನ ನಿಚಿನೋಮಿ ತನ್ನಿಮಿತ್ತಂ ಯತ್ರ ಯತ್ರ ಸ್ಥಾನೇ ಖ್ರೀಷ್ಟಸ್ಯ ನಾಮ ಕದಾಪಿ ಕೇನಾಪಿ ನ ಜ್ಞಾಪಿತಂ ತತ್ರ ತತ್ರ ಸುಸಂವಾದಂ ಪ್ರಚಾರಯಿತುಮ್ ಅಹಂ ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","ಯಾದೃಶಂ ಲಿಖಿತಮ್ ಆಸ್ತೇ, ಯೈ ರ್ವಾರ್ತ್ತಾ ತಸ್ಯ ನ ಪ್ರಾಪ್ತಾ ದರ್ಶನಂ ತೈಸ್ತು ಲಪ್ಸ್ಯತೇ| ಯೈಶ್ಚ ನೈವ ಶ್ರುತಂ ಕಿಞ್ಚಿತ್ ಬೋದ್ಧುಂ ಶಕ್ಷ್ಯನ್ತಿ ತೇ ಜನಾಃ|| ");
INSERT INTO sankan_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","ತಸ್ಮಾದ್ ಯುಷ್ಮತ್ಸಮೀಪಗಮನಾದ್ ಅಹಂ ಮುಹುರ್ಮುಹು ರ್ನಿವಾರಿತೋಽಭವಂ| ");
INSERT INTO sankan_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","ಕಿನ್ತ್ವಿದಾನೀಮ್ ಅತ್ರ ಪ್ರದೇಶೇಷು ಮಯಾ ನ ಗತಂ ಸ್ಥಾನಂ ಕಿಮಪಿ ನಾವಶಿಷ್ಯತೇ ಯುಷ್ಮತ್ಸಮೀಪಂ ಗನ್ತುಂ ಬಹುವತ್ಸರಾನಾರಭ್ಯ ಮಾಮಕೀನಾಕಾಙ್ಕ್ಷಾ ಚ ವಿದ್ಯತ ಇತಿ ಹೇತೋಃ ");
INSERT INTO sankan_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","ಸ್ಪಾನಿಯಾದೇಶಗಮನಕಾಲೇಽಹಂ ಯುಷ್ಮನ್ಮಧ್ಯೇನ ಗಚ್ಛನ್ ಯುಷ್ಮಾನ್ ಆಲೋಕಿಷ್ಯೇ, ತತಃ ಪರಂ ಯುಷ್ಮತ್ಸಮ್ಭಾಷಣೇನ ತೃಪ್ತಿಂ ಪರಿಲಭ್ಯ ತದ್ದೇಶಗಮನಾರ್ಥಂ ಯುಷ್ಮಾಭಿ ರ್ವಿಸರ್ಜಯಿಷ್ಯೇ, ಈದೃಶೀ ಮದೀಯಾ ಪ್ರತ್ಯಾಶಾ ವಿದ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","ಕಿನ್ತು ಸಾಮ್ಪ್ರತಂ ಪವಿತ್ರಲೋಕಾನಾಂ ಸೇವನಾಯ ಯಿರೂಶಾಲಮ್ನಗರಂ ವ್ರಜಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","ಯತೋ ಯಿರೂಶಾಲಮಸ್ಥಪವಿತ್ರಲೋಕಾನಾಂ ಮಧ್ಯೇ ಯೇ ದರಿದ್ರಾ ಅರ್ಥವಿಶ್ರಾಣನೇನ ತಾನುಪಕರ್ತ್ತುಂ ಮಾಕಿದನಿಯಾದೇಶೀಯಾ ಆಖಾಯಾದೇಶೀಯಾಶ್ಚ ಲೋಕಾ ಐಚ್ಛನ್| ");
INSERT INTO sankan_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","ಏಷಾ ತೇಷಾಂ ಸದಿಚ್ಛಾ ಯತಸ್ತೇ ತೇಷಾಮ್ ಋಣಿನಃ ಸನ್ತಿ ಯತೋ ಹೇತೋ ರ್ಭಿನ್ನಜಾತೀಯಾ ಯೇಷಾಂ ಪರಮಾರ್ಥಸ್ಯಾಂಶಿನೋ ಜಾತಾ ಐಹಿಕವಿಷಯೇ ತೇಷಾಮುಪಕಾರಸ್ತೈಃ ಕರ್ತ್ತವ್ಯಃ| ");
INSERT INTO sankan_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","ಅತೋ ಮಯಾ ತತ್ ಕರ್ಮ್ಮ ಸಾಧಯಿತ್ವಾ ತಸ್ಮಿನ್ ಫಲೇ ತೇಭ್ಯಃ ಸಮರ್ಪಿತೇ ಯುಷ್ಮನ್ಮಧ್ಯೇನ ಸ್ಪಾನಿಯಾದೇಶೋ ಗಮಿಷ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","ಯುಷ್ಮತ್ಸಮೀಪೇ ಮಮಾಗಮನಸಮಯೇ ಖ್ರೀಷ್ಟಸ್ಯ ಸುಸಂವಾದಸ್ಯ ಪೂರ್ಣವರೇಣ ಸಮ್ಬಲಿತಃ ಸನ್ ಅಹಮ್ ಆಗಮಿಷ್ಯಾಮಿ ಇತಿ ಮಯಾ ಜ್ಞಾಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","ಹೇ ಭ್ರಾತೃಗಣ ಪ್ರಭೋ ರ್ಯೀಶುಖ್ರೀಷ್ಟಸ್ಯ ನಾಮ್ನಾ ಪವಿತ್ರಸ್ಯಾತ್ಮಾನಃ ಪ್ರೇಮ್ನಾ ಚ ವಿನಯೇಽಹಂ ");
INSERT INTO sankan_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","ಯಿಹೂದಾದೇಶಸ್ಥಾನಾಮ್ ಅವಿಶ್ವಾಸಿಲೋಕಾನಾಂ ಕರೇಭ್ಯೋ ಯದಹಂ ರಕ್ಷಾಂ ಲಭೇಯ ಮದೀಯೈತೇನ ಸೇವನಕರ್ಮ್ಮಣಾ ಚ ಯದ್ ಯಿರೂಶಾಲಮಸ್ಥಾಃ ಪವಿತ್ರಲೋಕಾಸ್ತುಷ್ಯೇಯುಃ, ");
INSERT INTO sankan_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","ತದರ್ಥಂ ಯೂಯಂ ಮತ್ಕೃತ ಈಶ್ವರಾಯ ಪ್ರಾರ್ಥಯಮಾಣಾ ಯತಧ್ವಂ ತೇನಾಹಮ್ ಈಶ್ವರೇಚ್ಛಯಾ ಸಾನನ್ದಂ ಯುಷ್ಮತ್ಸಮೀಪಂ ಗತ್ವಾ ಯುಷ್ಮಾಭಿಃ ಸಹಿತಃ ಪ್ರಾಣಾನ್ ಆಪ್ಯಾಯಿತುಂ ಪಾರಯಿಷ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","ಶಾನ್ತಿದಾಯಕ ಈಶ್ವರೋ ಯುಷ್ಮಾಕಂ ಸರ್ವ್ವೇಷಾಂ ಸಙ್ಗೀ ಭೂಯಾತ್| ಇತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","ಕಿಂಕ್ರೀಯಾನಗರೀಯಧರ್ಮ್ಮಸಮಾಜಸ್ಯ ಪರಿಚಾರಿಕಾ ಯಾ ಫೈಬೀನಾಮಿಕಾಸ್ಮಾಕಂ ಧರ್ಮ್ಮಭಗಿನೀ ತಸ್ಯಾಃ ಕೃತೇಽಹಂ ಯುಷ್ಮಾನ್ ನಿವೇದಯಾಮಿ, ");
INSERT INTO sankan_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","ಯೂಯಂ ತಾಂ ಪ್ರಭುಮಾಶ್ರಿತಾಂ ವಿಜ್ಞಾಯ ತಸ್ಯಾ ಆತಿಥ್ಯಂ ಪವಿತ್ರಲೋಕಾರ್ಹಂ ಕುರುಧ್ವಂ, ಯುಷ್ಮತ್ತಸ್ತಸ್ಯಾ ಯ ಉಪಕಾರೋ ಭವಿತುಂ ಶಕ್ನೋತಿ ತಂ ಕುರುಧ್ವಂ, ಯಸ್ಮಾತ್ ತಯಾ ಬಹೂನಾಂ ಮಮ ಚೋಪಕಾರಃ ಕೃತಃ| ");
INSERT INTO sankan_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","ಅಪರಞ್ಚ ಖ್ರೀಷ್ಟಸ್ಯ ಯೀಶೋಃ ಕರ್ಮ್ಮಣಿ ಮಮ ಸಹಕಾರಿಣೌ ಮಮ ಪ್ರಾಣರಕ್ಷಾರ್ಥಞ್ಚ ಸ್ವಪ್ರಾಣಾನ್ ಪಣೀಕೃತವನ್ತೌ ಯೌ ಪ್ರಿಷ್ಕಿಲ್ಲಾಕ್ಕಿಲೌ ತೌ ಮಮ ನಮಸ್ಕಾರಂ ಜ್ಞಾಪಯಧ್ವಂ| ");
INSERT INTO sankan_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","ತಾಭ್ಯಾಮ್ ಉಪಕಾರಾಪ್ತಿಃ ಕೇವಲಂ ಮಯಾ ಸ್ವೀಕರ್ತ್ತವ್ಯೇತಿ ನಹಿ ಭಿನ್ನದೇಶೀಯೈಃ ಸರ್ವ್ವಧರ್ಮ್ಮಸಮಾಜೈರಪಿ| ");
INSERT INTO sankan_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","ಅಪರಞ್ಚ ತಯೋ ರ್ಗೃಹೇ ಸ್ಥಿತಾನ್ ಧರ್ಮ್ಮಸಮಾಜಲೋಕಾನ್ ಮಮ ನಮಸ್ಕಾರಂ ಜ್ಞಾಪಯಧ್ವಂ| ತದ್ವತ್ ಆಶಿಯಾದೇಶೇ ಖ್ರೀಷ್ಟಸ್ಯ ಪಕ್ಷೇ ಪ್ರಥಮಜಾತಫಲಸ್ವರೂಪೋ ಯ ಇಪೇನಿತನಾಮಾ ಮಮ ಪ್ರಿಯಬನ್ಧುಸ್ತಮಪಿ ಮಮ ನಮಸ್ಕಾರಂ ಜ್ಞಾಪಯಧ್ವಂ| ");
INSERT INTO sankan_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","ಅಪರಂ ಬಹುಶ್ರಮೇಣಾಸ್ಮಾನ್ ಅಸೇವತ ಯಾ ಮರಿಯಮ್ ತಾಮಪಿ ನಮಸ್ಕಾರಂ ಜ್ಞಾಪಯಧ್ವಂ| ");
INSERT INTO sankan_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","ಅಪರಞ್ಚ ಪ್ರೇರಿತೇಷು ಖ್ಯಾತಕೀರ್ತ್ತೀ ಮದಗ್ರೇ ಖ್ರೀಷ್ಟಾಶ್ರಿತೌ ಮಮ ಸ್ವಜಾತೀಯೌ ಸಹಬನ್ದಿನೌ ಚ ಯಾವಾನ್ದ್ರನೀಕಯೂನಿಯೌ ತೌ ಮಮ ನಮಸ್ಕಾರಂ ಜ್ಞಾಪಯಧ್ವಂ| ");
INSERT INTO sankan_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","ತಥಾ ಪ್ರಭೌ ಮತ್ಪ್ರಿಯತಮಮ್ ಆಮ್ಪ್ಲಿಯಮಪಿ ಮಮ ನಮಸ್ಕಾರಂ ಜ್ಞಾಪಯಧ್ವಂ| ");
INSERT INTO sankan_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","ಅಪರಂ ಖ್ರೀಷ್ಟಸೇವಾಯಾಂ ಮಮ ಸಹಕಾರಿಣಮ್ ಊರ್ಬ್ಬಾಣಂ ಮಮ ಪ್ರಿಯತಮಂ ಸ್ತಾಖುಞ್ಚ ಮಮ ನಮಸ್ಕಾರಂ ಜ್ಞಾಪಯಧ್ವಂ| ");
INSERT INTO sankan_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","ಅಪರಂ ಖ್ರೀಷ್ಟೇನ ಪರೀಕ್ಷಿತಮ್ ಆಪಿಲ್ಲಿಂ ಮಮ ನಮಸ್ಕಾರಂ ವದತ, ಆರಿಷ್ಟಬೂಲಸ್ಯ ಪರಿಜನಾಂಶ್ಚ ಮಮ ನಮಸ್ಕಾರಂ ಜ್ಞಾಪಯಧ್ವಂ| ");
INSERT INTO sankan_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","ಅಪರಂ ಮಮ ಜ್ಞಾತಿಂ ಹೇರೋದಿಯೋನಂ ಮಮ ನಮಸ್ಕಾರಂ ವದತ, ತಥಾ ನಾರ್ಕಿಸಸ್ಯ ಪರಿವಾರಾಣಾಂ ಮಧ್ಯೇ ಯೇ ಪ್ರಭುಮಾಶ್ರಿತಾಸ್ತಾನ್ ಮಮ ನಮಸ್ಕಾರಂ ವದತ| ");
INSERT INTO sankan_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","ಅಪರಂ ಪ್ರಭೋಃ ಸೇವಾಯಾಂ ಪರಿಶ್ರಮಕಾರಿಣ್ಯೌ ತ್ರುಫೇನಾತ್ರುಫೋಷೇ ಮಮ ನಮಸ್ಕಾರಂ ವದತ, ತಥಾ ಪ್ರಭೋಃ ಸೇವಾಯಾಮ್ ಅತ್ಯನ್ತಂ ಪರಿಶ್ರಮಕಾರಿಣೀ ಯಾ ಪ್ರಿಯಾ ಪರ್ಷಿಸ್ತಾಂ ನಮಸ್ಕಾರಂ ಜ್ಞಾಪಯಧ್ವಂ| ");
INSERT INTO sankan_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","ಅಪರಂ ಪ್ರಭೋರಭಿರುಚಿತಂ ರೂಫಂ ಮಮ ಧರ್ಮ್ಮಮಾತಾ ಯಾ ತಸ್ಯ ಮಾತಾ ತಾಮಪಿ ನಮಸ್ಕಾರಂ ವದತ| ");
INSERT INTO sankan_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","ಅಪರಮ್ ಅಸುಂಕೃತಂ ಫ್ಲಿಗೋನಂ ಹರ್ಮ್ಮಂ ಪಾತ್ರಬಂ ಹರ್ಮ್ಮಿಮ್ ಏತೇಷಾಂ ಸಙ್ಗಿಭ್ರಾತೃಗಣಞ್ಚ ನಮಸ್ಕಾರಂ ಜ್ಞಾಪಯಧ್ವಂ| ");
INSERT INTO sankan_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","ಅಪರಂ ಫಿಲಲಗೋ ಯೂಲಿಯಾ ನೀರಿಯಸ್ತಸ್ಯ ಭಗಿನ್ಯಲುಮ್ಪಾ ಚೈತಾನ್ ಏತೈಃ ಸಾರ್ದ್ಧಂ ಯಾವನ್ತಃ ಪವಿತ್ರಲೋಕಾ ಆಸತೇ ತಾನಪಿ ನಮಸ್ಕಾರಂ ಜ್ಞಾಪಯಧ್ವಂ| ");
INSERT INTO sankan_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","ಯೂಯಂ ಪರಸ್ಪರಂ ಪವಿತ್ರಚುಮ್ಬನೇನ ನಮಸ್ಕುರುಧ್ವಂ| ಖ್ರೀಷ್ಟಸ್ಯ ಧರ್ಮ್ಮಸಮಾಜಗಣೋ ಯುಷ್ಮಾನ್ ನಮಸ್ಕುರುತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","ಹೇ ಭ್ರಾತರೋ ಯುಷ್ಮಾನ್ ವಿನಯೇಽಹಂ ಯುಷ್ಮಾಭಿ ರ್ಯಾ ಶಿಕ್ಷಾ ಲಬ್ಧಾ ತಾಮ್ ಅತಿಕ್ರಮ್ಯ ಯೇ ವಿಚ್ಛೇದಾನ್ ವಿಘ್ನಾಂಶ್ಚ ಕುರ್ವ್ವನ್ತಿ ತಾನ್ ನಿಶ್ಚಿನುತ ತೇಷಾಂ ಸಙ್ಗಂ ವರ್ಜಯತ ಚ| ");
INSERT INTO sankan_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","ಯತಸ್ತಾದೃಶಾ ಲೋಕಾ ಅಸ್ಮಾಕಂ ಪ್ರಭೋ ರ್ಯೀಶುಖ್ರೀಷ್ಟಸ್ಯ ದಾಸಾ ಇತಿ ನಹಿ ಕಿನ್ತು ಸ್ವೋದರಸ್ಯೈವ ದಾಸಾಃ; ಅಪರಂ ಪ್ರಣಯವಚನೈ ರ್ಮಧುರವಾಕ್ಯೈಶ್ಚ ಸರಲಲೋಕಾನಾಂ ಮನಾಂಸಿ ಮೋಹಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","ಯುಷ್ಮಾಕಮ್ ಆಜ್ಞಾಗ್ರಾಹಿತ್ವಂ ಸರ್ವ್ವತ್ರ ಸರ್ವ್ವೈ ರ್ಜ್ಞಾತಂ ತತೋಽಹಂ ಯುಷ್ಮಾಸು ಸಾನನ್ದೋಽಭವಂ ತಥಾಪಿ ಯೂಯಂ ಯತ್ ಸತ್ಜ್ಞಾನೇನ ಜ್ಞಾನಿನಃ ಕುಜ್ಞಾನೇे ಚಾತತ್ಪರಾ ಭವೇತೇತಿ ಮಮಾಭಿಲಾಷಃ| ");
INSERT INTO sankan_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","ಅಧಿಕನ್ತು ಶಾನ್ತಿದಾಯಕ ಈಶ್ವರಃ ಶೈತಾನಮ್ ಅವಿಲಮ್ಬಂ ಯುಷ್ಮಾಕಂ ಪದಾನಾಮ್ ಅಧೋ ಮರ್ದ್ದಿಷ್ಯತಿ| ಅಸ್ಮಾಕಂ ಪ್ರಭು ರ್ಯೀಶುಖ್ರೀಷ್ಟೋ ಯುಷ್ಮಾಸು ಪ್ರಸಾದಂ ಕ್ರಿಯಾತ್| ಇತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","ಮಮ ಸಹಕಾರೀ ತೀಮಥಿಯೋ ಮಮ ಜ್ಞಾತಯೋ ಲೂಕಿಯೋ ಯಾಸೋನ್ ಸೋಸಿಪಾತ್ರಶ್ಚೇಮೇ ಯುಷ್ಮಾನ್ ನಮಸ್ಕುರ್ವ್ವನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","ಅಪರಮ್ ಏತತ್ಪತ್ರಲೇಖಕಸ್ತರ್ತ್ತಿಯನಾಮಾಹಮಪಿ ಪ್ರಭೋ ರ್ನಾಮ್ನಾ ಯುಷ್ಮಾನ್ ನಮಸ್ಕರೋಮಿ| ");
INSERT INTO sankan_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","ತಥಾ ಕೃತ್ಸ್ನಧರ್ಮ್ಮಸಮಾಜಸ್ಯ ಮಮ ಚಾತಿಥ್ಯಕಾರೀ ಗಾಯೋ ಯುಷ್ಮಾನ್ ನಮಸ್ಕರೋತಿ| ಅಪರಮ್ ಏತನ್ನಗರಸ್ಯ ಧನರಕ್ಷಕ ಇರಾಸ್ತಃ ಕ್ಕಾರ್ತ್ತನಾಮಕಶ್ಚೈಕೋ ಭ್ರಾತಾ ತಾವಪಿ ಯುಷ್ಮಾನ್ ನಮಸ್ಕುರುತಃ| ");
INSERT INTO sankan_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","ಅಸ್ಮಾಕಂ ಪ್ರಭು ರ್ಯೀಶುಖ್ರೀಷ್ಟಾ ಯುಷ್ಮಾಸು ಸರ್ವ್ವೇಷು ಪ್ರಸಾದಂ ಕ್ರಿಯಾತ್| ಇತಿ| ");
INSERT INTO sankan_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","ಪೂರ್ವ್ವಕಾಲಿಕಯುಗೇಷು ಪ್ರಚ್ಛನ್ನಾ ಯಾ ಮನ್ತ್ರಣಾಧುನಾ ಪ್ರಕಾಶಿತಾ ಭೂತ್ವಾ ಭವಿಷ್ಯದ್ವಾದಿಲಿಖಿತಗ್ರನ್ಥಗಣಸ್ಯ ಪ್ರಮಾಣಾದ್ ವಿಶ್ವಾಸೇನ ಗ್ರಹಣಾರ್ಥಂ ಸದಾತನಸ್ಯೇಶ್ವರಸ್ಯಾಜ್ಞಯಾ ಸರ್ವ್ವದೇಶೀಯಲೋಕಾನ್ ಜ್ಞಾಪ್ಯತೇ, ");
INSERT INTO sankan_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","ತಸ್ಯಾ ಮನ್ತ್ರಣಾಯಾ ಜ್ಞಾನಂ ಲಬ್ಧ್ವಾ ಮಯಾ ಯಃ ಸುಸಂವಾದೋ ಯೀಶುಖ್ರೀಷ್ಟಮಧಿ ಪ್ರಚಾರ್ಯ್ಯತೇ, ತದನುಸಾರಾದ್ ಯುಷ್ಮಾನ್ ಧರ್ಮ್ಮೇ ಸುಸ್ಥಿರಾನ್ ಕರ್ತ್ತುಂ ಸಮರ್ಥೋ ಯೋಽದ್ವಿತೀಯಃ ");
INSERT INTO sankan_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","ಸರ್ವ್ವಜ್ಞ ಈಶ್ವರಸ್ತಸ್ಯ ಧನ್ಯವಾದೋ ಯೀಶುಖ್ರೀಷ್ಟೇನ ಸನ್ತತಂ ಭೂಯಾತ್| ಇತಿ|");
INSERT INTO sankan_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","ಯಾವನ್ತಃ ಪವಿತ್ರಾ ಲೋಕಾಃ ಸ್ವೇಷಾಮ್ ಅಸ್ಮಾಕಞ್ಚ ವಸತಿಸ್ಥಾನೇಷ್ವಸ್ಮಾಕಂ ಪ್ರಭೋ ರ್ಯೀಶೋಃ ಖ್ರೀಷ್ಟಸ್ಯ ನಾಮ್ನಾ ಪ್ರಾರ್ಥಯನ್ತೇ ತೈಃ ಸಹಾಹೂತಾನಾಂ ಖ್ರೀಷ್ಟೇನ ಯೀಶುನಾ ಪವಿತ್ರೀಕೃತಾನಾಂ ಲೋಕಾನಾಂ ಯ ಈಶ್ವರೀಯಧರ್ಮ್ಮಸಮಾಜಃ ಕರಿನ್ಥನಗರೇ ವಿದ್ಯತೇ ");
INSERT INTO sankan_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","ತಂ ಪ್ರತೀಶ್ವರಸ್ಯೇಚ್ಛಯಾಹೂತೋ ಯೀಶುಖ್ರೀಷ್ಟಸ್ಯ ಪ್ರೇರಿತಃ ಪೌಲಃ ಸೋಸ್ಥಿನಿನಾಮಾ ಭ್ರಾತಾ ಚ ಪತ್ರಂ ಲಿಖತಿ| ");
INSERT INTO sankan_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","ಅಸ್ಮಾಕಂ ಪಿತ್ರೇಶ್ವರೇಣ ಪ್ರಭುನಾ ಯೀಶುಖ್ರೀಷ್ಟೇನ ಚ ಪ್ರಸಾದಃ ಶಾನ್ತಿಶ್ಚ ಯುಷ್ಮಭ್ಯಂ ದೀಯತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","ಈಶ್ವರೋ ಯೀಶುಖ್ರೀಷ್ಟೇನ ಯುಷ್ಮಾನ್ ಪ್ರತಿ ಪ್ರಸಾದಂ ಪ್ರಕಾಶಿತವಾನ್, ತಸ್ಮಾದಹಂ ಯುಷ್ಮನ್ನಿಮಿತ್ತಂ ಸರ್ವ್ವದಾ ಮದೀಯೇಶ್ವರಂ ಧನ್ಯಂ ವದಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","ಖ್ರೀಷ್ಟಸಮ್ಬನ್ಧೀಯಂ ಸಾಕ್ಷ್ಯಂ ಯುಷ್ಮಾಕಂ ಮಧ್ಯೇ ಯೇನ ಪ್ರಕಾರೇಣ ಸಪ್ರಮಾಣಮ್ ಅಭವತ್ ");
INSERT INTO sankan_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","ತೇನ ಯೂಯಂ ಖ್ರೀಷ್ಟಾತ್ ಸರ್ವ್ವವಿಧವಕ್ತೃತಾಜ್ಞಾನಾದೀನಿ ಸರ್ವ್ವಧನಾನಿ ಲಬ್ಧವನ್ತಃ| ");
INSERT INTO sankan_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","ತತೋಽಸ್ಮತ್ಪ್ರಭೋ ರ್ಯೀಶುಖ್ರೀಷ್ಟಸ್ಯ ಪುನರಾಗಮನಂ ಪ್ರತೀಕ್ಷಮಾಣಾನಾಂ ಯುಷ್ಮಾಕಂ ಕಸ್ಯಾಪಿ ವರಸ್ಯಾಭಾವೋ ನ ಭವತಿ| ");
INSERT INTO sankan_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","ಅಪರಮ್ ಅಸ್ಮಾಕಂ ಪ್ರಭೋ ರ್ಯೀಶುಖ್ರೀಷ್ಟಸ್ಯ ದಿವಸೇ ಯೂಯಂ ಯನ್ನಿರ್ದ್ದೋಷಾ ಭವೇತ ತದರ್ಥಂ ಸಏವ ಯಾವದನ್ತಂ ಯುಷ್ಮಾನ್ ಸುಸ್ಥಿರಾನ್ ಕರಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","ಯ ಈಶ್ವರಃ ಸ್ವಪುತ್ರಸ್ಯಾಸ್ಮತ್ಪ್ರಭೋ ರ್ಯೀಶುಖ್ರೀಷ್ಟಸ್ಯಾಂಶಿನಃ ಕರ್ತ್ತುಂ ಯುಷ್ಮಾನ್ ಆಹೂತವಾನ್ ಸ ವಿಶ್ವಸನೀಯಃ| ");
INSERT INTO sankan_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","ಹೇ ಭ್ರಾತರಃ, ಅಸ್ಮಾಕಂ ಪ್ರಭುಯೀಶುಖ್ರೀಷ್ಟಸ್ಯ ನಾಮ್ನಾ ಯುಷ್ಮಾನ್ ವಿನಯೇಽಹಂ ಸರ್ವ್ವೈ ರ್ಯುಷ್ಮಾಭಿರೇಕರೂಪಾಣಿ ವಾಕ್ಯಾನಿ ಕಥ್ಯನ್ತಾಂ ಯುಷ್ಮನ್ಮಧ್ಯೇ ಭಿನ್ನಸಙ್ಘಾತಾ ನ ಭವನ್ತು ಮನೋವಿಚಾರಯೋರೈಕ್ಯೇನ ಯುಷ್ಮಾಕಂ ಸಿದ್ಧತ್ವಂ ಭವತು| ");
INSERT INTO sankan_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","ಹೇ ಮಮ ಭ್ರಾತರೋ ಯುಷ್ಮನ್ಮಧ್ಯೇ ವಿವಾದಾ ಜಾತಾ ಇತಿ ವಾರ್ತ್ತಾಮಹಂ ಕ್ಲೋಯ್ಯಾಃ ಪರಿಜನೈ ರ್ಜ್ಞಾಪಿತಃ| ");
INSERT INTO sankan_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","ಮಮಾಭಿಪ್ರೇತಮಿದಂ ಯುಷ್ಮಾಕಂ ಕಶ್ಚಿತ್ ಕಶ್ಚಿದ್ ವದತಿ ಪೌಲಸ್ಯ ಶಿಷ್ಯೋಽಹಮ್ ಆಪಲ್ಲೋಃ ಶಿಷ್ಯೋಽಹಂ ಕೈಫಾಃ ಶಿಷ್ಯೋಽಹಂ ಖ್ರೀಷ್ಟಸ್ಯ ಶಿಷ್ಯೋಽಹಮಿತಿ ಚ| ");
INSERT INTO sankan_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","ಖ್ರೀಷ್ಟಸ್ಯ ಕಿಂ ವಿಭೇದಃ ಕೃತಃ? ಪೌಲಃ ಕಿಂ ಯುಷ್ಮತ್ಕೃತೇ ಕ್ರುಶೇ ಹತಃ? ಪೌಲಸ್ಯ ನಾಮ್ನಾ ವಾ ಯೂಯಂ ಕಿಂ ಮಜ್ಜಿತಾಃ? ");
INSERT INTO sankan_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","ಕ್ರಿಷ್ಪಗಾಯೌ ವಿನಾ ಯುಷ್ಮಾಕಂ ಮಧ್ಯೇಽನ್ಯಃ ಕೋಽಪಿ ಮಯಾ ನ ಮಜ್ಜಿತ ಇತಿ ಹೇತೋರಹಮ್ ಈಶ್ವರಂ ಧನ್ಯಂ ವದಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","ಏತೇನ ಮಮ ನಾಮ್ನಾ ಮಾನವಾ ಮಯಾ ಮಜ್ಜಿತಾ ಇತಿ ವಕ್ತುಂ ಕೇನಾಪಿ ನ ಶಕ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","ಅಪರಂ ಸ್ತಿಫಾನಸ್ಯ ಪರಿಜನಾ ಮಯಾ ಮಜ್ಜಿತಾಸ್ತದನ್ಯಃ ಕಶ್ಚಿದ್ ಯನ್ಮಯಾ ಮಜ್ಜಿತಸ್ತದಹಂ ನ ವೇದ್ಮಿ| ");
INSERT INTO sankan_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","ಖ್ರೀಷ್ಟೇನಾಹಂ ಮಜ್ಜನಾರ್ಥಂ ನ ಪ್ರೇರಿತಃ ಕಿನ್ತು ಸುಸಂವಾದಸ್ಯ ಪ್ರಚಾರಾರ್ಥಮೇವ; ಸೋಽಪಿ ವಾಕ್ಪಟುತಯಾ ಮಯಾ ನ ಪ್ರಚಾರಿತವ್ಯಃ, ಯತಸ್ತಥಾ ಪ್ರಚಾರಿತೇ ಖ್ರೀಷ್ಟಸ್ಯ ಕ್ರುಶೇ ಮೃತ್ಯುಃ ಫಲಹೀನೋ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","ಯತೋ ಹೇತೋ ರ್ಯೇ ವಿನಶ್ಯನ್ತಿ ತೇ ತಾಂ ಕ್ರುಶಸ್ಯ ವಾರ್ತ್ತಾಂ ಪ್ರಲಾಪಮಿವ ಮನ್ಯನ್ತೇ ಕಿಞ್ಚ ಪರಿತ್ರಾಣಂ ಲಭಮಾನೇಷ್ವಸ್ಮಾಸು ಸಾ ಈಶ್ವರೀಯಶಕ್ತಿಸ್ವರೂಪಾ| ");
INSERT INTO sankan_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","ತಸ್ಮಾದಿತ್ಥಂ ಲಿಖಿತಮಾಸ್ತೇ, ಜ್ಞಾನವತಾನ್ತು ಯತ್ ಜ್ಞಾನಂ ತನ್ಮಯಾ ನಾಶಯಿಷ್ಯತೇ| ವಿಲೋಪಯಿಷ್ಯತೇ ತದ್ವದ್ ಬುದ್ಧಿ ರ್ಬದ್ಧಿಮತಾಂ ಮಯಾ|| ");
INSERT INTO sankan_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","ಜ್ಞಾನೀ ಕುತ್ರ? ಶಾಸ್ತ್ರೀ ವಾ ಕುತ್ರ? ಇಹಲೋಕಸ್ಯ ವಿಚಾರತತ್ಪರೋ ವಾ ಕುತ್ರ? ಇಹಲೋಕಸ್ಯ ಜ್ಞಾನಂ ಕಿಮೀಶ್ವರೇಣ ಮೋಹೀಕೃತಂ ನಹಿ? ");
INSERT INTO sankan_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","ಈಶ್ವರಸ್ಯ ಜ್ಞಾನಾದ್ ಇಹಲೋಕಸ್ಯ ಮಾನವಾಃ ಸ್ವಜ್ಞಾನೇನೇಶ್ವರಸ್ಯ ತತ್ತ್ವಬೋಧಂ ನ ಪ್ರಾಪ್ತವನ್ತಸ್ತಸ್ಮಾದ್ ಈಶ್ವರಃ ಪ್ರಚಾರರೂಪಿಣಾ ಪ್ರಲಾಪೇನ ವಿಶ್ವಾಸಿನಃ ಪರಿತ್ರಾತುಂ ರೋಚಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","ಯಿಹೂದೀಯಲೋಕಾ ಲಕ್ಷಣಾನಿ ದಿದೃಕ್ಷನ್ತಿ ಭಿನ್ನದೇಶೀಯಲೋಕಾಸ್ತು ವಿದ್ಯಾಂ ಮೃಗಯನ್ತೇ, ");
INSERT INTO sankan_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","ವಯಞ್ಚ ಕ್ರುಶೇ ಹತಂ ಖ್ರೀಷ್ಟಂ ಪ್ರಚಾರಯಾಮಃ| ತಸ್ಯ ಪ್ರಚಾರೋ ಯಿಹೂದೀಯೈ ರ್ವಿಘ್ನ ಇವ ಭಿನ್ನದೇಶೀಯೈಶ್ಚ ಪ್ರಲಾಪ ಇವ ಮನ್ಯತೇ, ");
INSERT INTO sankan_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","ಕಿನ್ತು ಯಿಹೂದೀಯಾನಾಂ ಭಿನ್ನದೇಶೀಯಾನಾಞ್ಚ ಮಧ್ಯೇ ಯೇ ಆಹೂತಾಸ್ತೇಷು ಸ ಖ್ರೀಷ್ಟ ಈಶ್ವರೀಯಶಕ್ತಿರಿವೇಶ್ವರೀಯಜ್ಞಾನಮಿವ ಚ ಪ್ರಕಾಶತೇ| ");
INSERT INTO sankan_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","ಯತ ಈಶ್ವರೇ ಯಃ ಪ್ರಲಾಪ ಆರೋಪ್ಯತೇ ಸ ಮಾನವಾತಿರಿಕ್ತಂ ಜ್ಞಾನಮೇವ ಯಚ್ಚ ದೌರ್ಬ್ಬಲ್ಯಮ್ ಈಶ್ವರ ಆರೋಪ್ಯತೇ ತತ್ ಮಾನವಾತಿರಿಕ್ತಂ ಬಲಮೇವ| ");
INSERT INTO sankan_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","ಹೇ ಭ್ರಾತರಃ, ಆಹೂತಯುಷ್ಮದ್ಗಣೋ ಯಷ್ಮಾಭಿರಾಲೋಕ್ಯತಾಂ ತನ್ಮಧ್ಯೇ ಸಾಂಸಾರಿಕಜ್ಞಾನೇನ ಜ್ಞಾನವನ್ತಃ ಪರಾಕ್ರಮಿಣೋ ವಾ ಕುಲೀನಾ ವಾ ಬಹವೋ ನ ವಿದ್ಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","ಯತ ಈಶ್ವರೋ ಜ್ಞಾನವತಸ್ತ್ರಪಯಿತುಂ ಮೂರ್ಖಲೋಕಾನ್ ರೋಚಿತವಾನ್ ಬಲಾನಿ ಚ ತ್ರಪಯಿತುಮ್ ಈಶ್ವರೋ ದುರ್ಬ್ಬಲಾನ್ ರೋಚಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","ತಥಾ ವರ್ತ್ತಮಾನಲೋಕಾನ್ ಸಂಸ್ಥಿತಿಭ್ರಷ್ಟಾನ್ ಕರ್ತ್ತುಮ್ ಈಶ್ವರೋ ಜಗತೋಽಪಕೃಷ್ಟಾನ್ ಹೇಯಾನ್ ಅವರ್ತ್ತಮಾನಾಂಶ್ಚಾಭಿರೋಚಿತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","ತತ ಈಶ್ವರಸ್ಯ ಸಾಕ್ಷಾತ್ ಕೇನಾಪ್ಯಾತ್ಮಶ್ಲಾಘಾ ನ ಕರ್ತ್ತವ್ಯಾ| ");
INSERT INTO sankan_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","ಯೂಯಞ್ಚ ತಸ್ಮಾತ್ ಖ್ರೀಷ್ಟೇ ಯೀಶೌ ಸಂಸ್ಥಿತಿಂ ಪ್ರಾಪ್ತವನ್ತಃ ಸ ಈಶ್ವರಾದ್ ಯುಷ್ಮಾಕಂ ಜ್ಞಾನಂ ಪುಣ್ಯಂ ಪವಿತ್ರತ್ವಂ ಮುಕ್ತಿಶ್ಚ ಜಾತಾ| ");
INSERT INTO sankan_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","ಅತಏವ ಯದ್ವದ್ ಲಿಖಿತಮಾಸ್ತೇ ತದ್ವತ್, ಯಃ ಕಶ್ಚಿತ್ ಶ್ಲಾಘಮಾನಃ ಸ್ಯಾತ್ ಶ್ಲಾಘತಾಂ ಪ್ರಭುನಾ ಸ ಹಿ| ");
INSERT INTO sankan_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","ಹೇ ಭ್ರಾತರೋ ಯುಷ್ಮತ್ಸಮೀಪೇ ಮಮಾಗಮನಕಾಲೇಽಹಂ ವಕ್ತೃತಾಯಾ ವಿದ್ಯಾಯಾ ವಾ ನೈಪುಣ್ಯೇನೇಶ್ವರಸ್ಯ ಸಾಕ್ಷ್ಯಂ ಪ್ರಚಾರಿತವಾನ್ ತನ್ನಹಿ; ");
INSERT INTO sankan_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","ಯತೋ ಯೀಶುಖ್ರೀಷ್ಟಂ ತಸ್ಯ ಕ್ರುಶೇ ಹತತ್ವಞ್ಚ ವಿನಾ ನಾನ್ಯತ್ ಕಿಮಪಿ ಯುಷ್ಮನ್ಮಧ್ಯೇ ಜ್ಞಾಪಯಿತುಂ ವಿಹಿತಂ ಬುದ್ಧವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","ಅಪರಞ್ಚಾತೀವ ದೌರ್ಬ್ಬಲ್ಯಭೀತಿಕಮ್ಪಯುಕ್ತೋ ಯುಷ್ಮಾಭಿಃ ಸಾರ್ದ್ಧಮಾಸಂ| ");
INSERT INTO sankan_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","ಅಪರಂ ಯುಷ್ಮಾಕಂ ವಿಶ್ವಾಸೋ ಯತ್ ಮಾನುಷಿಕಜ್ಞಾನಸ್ಯ ಫಲಂ ನ ಭವೇತ್ ಕಿನ್ತ್ವೀಶ್ವರೀಯಶಕ್ತೇಃ ಫಲಂ ಭವೇತ್, ");
INSERT INTO sankan_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","ತದರ್ಥಂ ಮಮ ವಕ್ತೃತಾ ಮದೀಯಪ್ರಚಾರಶ್ಚ ಮಾನುಷಿಕಜ್ಞಾನಸ್ಯ ಮಧುರವಾಕ್ಯಸಮ್ಬಲಿತೌ ನಾಸ್ತಾಂ ಕಿನ್ತ್ವಾತ್ಮನಃ ಶಕ್ತೇಶ್ಚ ಪ್ರಮಾಣಯುಕ್ತಾವಾಸ್ತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","ವಯಂ ಜ್ಞಾನಂ ಭಾಷಾಮಹೇ ತಚ್ಚ ಸಿದ್ಧಲೋಕೈ ರ್ಜ್ಞಾನಮಿವ ಮನ್ಯತೇ, ತದಿಹಲೋಕಸ್ಯ ಜ್ಞಾನಂ ನಹಿ, ಇಹಲೋಕಸ್ಯ ನಶ್ವರಾಣಾಮ್ ಅಧಿಪತೀನಾಂ ವಾ ಜ್ಞಾನಂ ನಹಿ; ");
INSERT INTO sankan_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","ಕಿನ್ತು ಕಾಲಾವಸ್ಥಾಯಾಃ ಪೂರ್ವ್ವಸ್ಮಾದ್ ಯತ್ ಜ್ಞಾನಮ್ ಅಸ್ಮಾಕಂ ವಿಭವಾರ್ಥಮ್ ಈಶ್ವರೇಣ ನಿಶ್ಚಿತ್ಯ ಪ್ರಚ್ಛನ್ನಂ ತನ್ನಿಗೂಢಮ್ ಈಶ್ವರೀಯಜ್ಞಾನಂ ಪ್ರಭಾಷಾಮಹೇ| ");
INSERT INTO sankan_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","ಇಹಲೋಕಸ್ಯಾಧಿಪತೀನಾಂ ಕೇನಾಪಿ ತತ್ ಜ್ಞಾನಂ ನ ಲಬ್ಧಂ, ಲಬ್ಧೇ ಸತಿ ತೇ ಪ್ರಭಾವವಿಶಿಷ್ಟಂ ಪ್ರಭುಂ ಕ್ರುಶೇ ನಾಹನಿಷ್ಯನ್| ");
INSERT INTO sankan_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","ತದ್ವಲ್ಲಿಖಿತಮಾಸ್ತೇ, ನೇತ್ರೇಣ ಕ್ಕಾಪಿ ನೋ ದೃಷ್ಟಂ ಕರ್ಣೇನಾಪಿ ಚ ನ ಶ್ರುತಂ| ಮನೋಮಧ್ಯೇ ತು ಕಸ್ಯಾಪಿ ನ ಪ್ರವಿಷ್ಟಂ ಕದಾಪಿ ಯತ್| ಈಶ್ವರೇ ಪ್ರೀಯಮಾಣಾನಾಂ ಕೃತೇ ತತ್ ತೇನ ಸಞ್ಚಿತಂ| ");
INSERT INTO sankan_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","ಅಪರಮೀಶ್ವರಃ ಸ್ವಾತ್ಮನಾ ತದಸ್ಮಾಕಂ ಸಾಕ್ಷಾತ್ ಪ್ರಾಕಾಶಯತ್; ಯತ ಆತ್ಮಾ ಸರ್ವ್ವಮೇವಾನುಸನ್ಧತ್ತೇ ತೇನ ಚೇಶ್ವರಸ್ಯ ಮರ್ಮ್ಮತತ್ತ್ವಮಪಿ ಬುಧ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","ಮನುಜಸ್ಯಾನ್ತಃಸ್ಥಮಾತ್ಮಾನಂ ವಿನಾ ಕೇನ ಮನುಜೇನ ತಸ್ಯ ಮನುಜಸ್ಯ ತತ್ತ್ವಂ ಬುಧ್ಯತೇ? ತದ್ವದೀಶ್ವರಸ್ಯಾತ್ಮಾನಂ ವಿನಾ ಕೇನಾಪೀಶ್ವರಸ್ಯ ತತ್ತ್ವಂ ನ ಬುಧ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","ವಯಞ್ಚೇಹಲೋಕಸ್ಯಾತ್ಮಾನಂ ಲಬ್ಧವನ್ತಸ್ತನ್ನಹಿ ಕಿನ್ತ್ವೀಶ್ವರಸ್ಯೈವಾತ್ಮಾನಂ ಲಬ್ಧವನ್ತಃ, ತತೋ ಹೇತೋರೀಶ್ವರೇಣ ಸ್ವಪ್ರಸಾದಾದ್ ಅಸ್ಮಭ್ಯಂ ಯದ್ ಯದ್ ದತ್ತಂ ತತ್ಸರ್ವ್ವಮ್ ಅಸ್ಮಾಭಿ ರ್ಜ್ಞಾತುಂ ಶಕ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","ತಚ್ಚಾಸ್ಮಾಭಿ ರ್ಮಾನುಷಿಕಜ್ಞಾನಸ್ಯ ವಾಕ್ಯಾನಿ ಶಿಕ್ಷಿತ್ವಾ ಕಥ್ಯತ ಇತಿ ನಹಿ ಕಿನ್ತ್ವಾತ್ಮತೋ ವಾಕ್ಯಾನಿ ಶಿಕ್ಷಿತ್ವಾತ್ಮಿಕೈ ರ್ವಾಕ್ಯೈರಾತ್ಮಿಕಂ ಭಾವಂ ಪ್ರಕಾಶಯದ್ಭಿಃ ಕಥ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","ಪ್ರಾಣೀ ಮನುಷ್ಯ ಈಶ್ವರೀಯಾತ್ಮನಃ ಶಿಕ್ಷಾಂ ನ ಗೃಹ್ಲಾತಿ ಯತ ಆತ್ಮಿಕವಿಚಾರೇಣ ಸಾ ವಿಚಾರ್ಯ್ಯೇತಿ ಹೇತೋಃ ಸ ತಾಂ ಪ್ರಲಾಪಮಿವ ಮನ್ಯತೇ ಬೋದ್ಧುಞ್ಚ ನ ಶಕ್ನೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","ಆತ್ಮಿಕೋ ಮಾನವಃ ಸರ್ವ್ವಾಣಿ ವಿಚಾರಯತಿ ಕಿನ್ತು ಸ್ವಯಂ ಕೇನಾಪಿ ನ ವಿಚಾರ್ಯ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","ಯತ ಈಶ್ವರಸ್ಯ ಮನೋ ಜ್ಞಾತ್ವಾ ತಮುಪದೇಷ್ಟುಂ ಕಃ ಶಕ್ನೋತಿ? ಕಿನ್ತು ಖ್ರೀಷ್ಟಸ್ಯ ಮನೋಽಸ್ಮಾಭಿ ರ್ಲಬ್ಧಂ| ");
INSERT INTO sankan_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","ಹೇ ಭ್ರಾತರಃ, ಅಹಮಾತ್ಮಿಕೈರಿವ ಯುಷ್ಮಾಭಿಃ ಸಮಂ ಸಮ್ಭಾಷಿತುಂ ನಾಶಕ್ನವಂ ಕಿನ್ತು ಶಾರೀರಿಕಾಚಾರಿಭಿಃ ಖ್ರೀಷ್ಟಧರ್ಮ್ಮೇ ಶಿಶುತುಲ್ಯೈಶ್ಚ ಜನೈರಿವ ಯುಷ್ಮಾಭಿಃ ಸಹ ಸಮಭಾಷೇ| ");
INSERT INTO sankan_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","ಯುಷ್ಮಾನ್ ಕಠಿನಭಕ್ಷ್ಯಂ ನ ಭೋಜಯನ್ ದುಗ್ಧಮ್ ಅಪಾಯಯಂ ಯತೋ ಯೂಯಂ ಭಕ್ಷ್ಯಂ ಗ್ರಹೀತುಂ ತದಾ ನಾಶಕ್ನುತ ಇದಾನೀಮಪಿ ನ ಶಕ್ನುಥ, ಯತೋ ಹೇತೋರಧುನಾಪಿ ಶಾರೀರಿಕಾಚಾರಿಣ ಆಧ್ವೇ| ");
INSERT INTO sankan_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","ಯುಷ್ಮನ್ಮಧ್ಯೇ ಮಾತ್ಸರ್ಯ್ಯವಿವಾದಭೇದಾ ಭವನ್ತಿ ತತಃ ಕಿಂ ಶಾರೀರಿಕಾಚಾರಿಣೋ ನಾಧ್ವೇ ಮಾನುಷಿಕಮಾರ್ಗೇಣ ಚ ನ ಚರಥ? ");
INSERT INTO sankan_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","ಪೌಲಸ್ಯಾಹಮಿತ್ಯಾಪಲ್ಲೋರಹಮಿತಿ ವಾ ಯದ್ವಾಕ್ಯಂ ಯುಷ್ಮಾಕಂ ಕೈಶ್ಚಿತ್ ಕೈಶ್ಚಿತ್ ಕಥ್ಯತೇ ತಸ್ಮಾದ್ ಯೂಯಂ ಶಾರೀರಿಕಾಚಾರಿಣ ನ ಭವಥ? ");
INSERT INTO sankan_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","ಪೌಲಃ ಕಃ? ಆಪಲ್ಲೋ ರ್ವಾ ಕಃ? ತೌ ಪರಿಚಾರಕಮಾತ್ರೌ ತಯೋರೇಕೈಕಸ್ಮೈ ಚ ಪ್ರಭು ರ್ಯಾದೃಕ್ ಫಲಮದದಾತ್ ತದ್ವತ್ ತಯೋರ್ದ್ವಾರಾ ಯೂಯಂ ವಿಶ್ವಾಸಿನೋ ಜಾತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","ಅಹಂ ರೋಪಿತವಾನ್ ಆಪಲ್ಲೋಶ್ಚ ನಿಷಿಕ್ತವಾನ್ ಈಶ್ವರಶ್ಚಾವರ್ದ್ಧಯತ್| ");
INSERT INTO sankan_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","ಅತೋ ರೋಪಯಿತೃಸೇಕ್ತಾರಾವಸಾರೌ ವರ್ದ್ಧಯಿತೇಶ್ವರ ಏವ ಸಾರಃ| ");
INSERT INTO sankan_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","ರೋಪಯಿತೃಸೇಕ್ತಾರೌ ಚ ಸಮೌ ತಯೋರೇಕೈಕಶ್ಚ ಸ್ವಶ್ರಮಯೋಗ್ಯಂ ಸ್ವವೇತನಂ ಲಪ್ಸ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","ಆವಾಮೀಶ್ವರೇಣ ಸಹ ಕರ್ಮ್ಮಕಾರಿಣೌ, ಈಶ್ವರಸ್ಯ ಯತ್ ಕ್ಷೇತ್ರಮ್ ಈಶ್ವರಸ್ಯ ಯಾ ನಿರ್ಮ್ಮಿತಿಃ ಸಾ ಯೂಯಮೇವ| ");
INSERT INTO sankan_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","ಈಶ್ವರಸ್ಯ ಪ್ರಸಾದಾತ್ ಮಯಾ ಯತ್ ಪದಂ ಲಬ್ಧಂ ತಸ್ಮಾತ್ ಜ್ಞಾನಿನಾ ಗೃಹಕಾರಿಣೇವ ಮಯಾ ಭಿತ್ತಿಮೂಲಂ ಸ್ಥಾಪಿತಂ ತದುಪರಿ ಚಾನ್ಯೇನ ನಿಚೀಯತೇ| ಕಿನ್ತು ಯೇನ ಯನ್ನಿಚೀಯತೇ ತತ್ ತೇನ ವಿವಿಚ್ಯತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","ಯತೋ ಯೀಶುಖ್ರೀಷ್ಟರೂಪಂ ಯದ್ ಭಿತ್ತಿಮೂಲಂ ಸ್ಥಾಪಿತಂ ತದನ್ಯತ್ ಕಿಮಪಿ ಭಿತ್ತಿಮೂಲಂ ಸ್ಥಾಪಯಿತುಂ ಕೇನಾಪಿ ನ ಶಕ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","ಏತದ್ಭಿತ್ತಿಮೂಲಸ್ಯೋಪರಿ ಯದಿ ಕೇಚಿತ್ ಸ್ವರ್ಣರೂಪ್ಯಮಣಿಕಾಷ್ಠತೃಣನಲಾನ್ ನಿಚಿನ್ವನ್ತಿ, ");
INSERT INTO sankan_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","ತರ್ಹ್ಯೇಕೈಕಸ್ಯ ಕರ್ಮ್ಮ ಪ್ರಕಾಶಿಷ್ಯತೇ ಯತಃ ಸ ದಿವಸಸ್ತತ್ ಪ್ರಕಾಶಯಿಷ್ಯತಿ| ಯತೋ ಹತೋಸ್ತನ ದಿವಸೇನ ವಹ್ನಿಮಯೇನೋದೇತವ್ಯಂ ತತ ಏಕೈಕಸ್ಯ ಕರ್ಮ್ಮ ಕೀದೃಶಮೇತಸ್ಯ ಪರೀಕ್ಷಾ ಬಹ್ನಿನಾ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","ಯಸ್ಯ ನಿಚಯನರೂಪಂ ಕರ್ಮ್ಮ ಸ್ಥಾಸ್ನು ಭವಿಷ್ಯತಿ ಸ ವೇತನಂ ಲಪ್ಸ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","ಯಸ್ಯ ಚ ಕರ್ಮ್ಮ ಧಕ್ಷ್ಯತೇ ತಸ್ಯ ಕ್ಷತಿ ರ್ಭವಿಷ್ಯತಿ ಕಿನ್ತು ವಹ್ನೇ ರ್ನಿರ್ಗತಜನ ಇವ ಸ ಸ್ವಯಂ ಪರಿತ್ರಾಣಂ ಪ್ರಾಪ್ಸ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","ಯೂಯಮ್ ಈಶ್ವರಸ್ಯ ಮನ್ದಿರಂ ಯುಷ್ಮನ್ಮಧ್ಯೇ ಚೇಶ್ವರಸ್ಯಾತ್ಮಾ ನಿವಸತೀತಿ ಕಿಂ ನ ಜಾನೀಥ? ");
INSERT INTO sankan_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","ಈಶ್ವರಸ್ಯ ಮನ್ದಿರಂ ಯೇನ ವಿನಾಶ್ಯತೇ ಸೋಽಪೀಶ್ವರೇಣ ವಿನಾಶಯಿಷ್ಯತೇ ಯತ ಈಶ್ವರಸ್ಯ ಮನ್ದಿರಂ ಪವಿತ್ರಮೇವ ಯೂಯಂ ತು ತನ್ಮನ್ದಿರಮ್ ಆಧ್ವೇ| ");
INSERT INTO sankan_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","ಕೋಪಿ ಸ್ವಂ ನ ವಞ್ಚಯತಾಂ| ಯುಷ್ಮಾಕಂ ಕಶ್ಚನ ಚೇದಿಹಲೋಕಸ್ಯ ಜ್ಞಾನೇನ ಜ್ಞಾನವಾನಹಮಿತಿ ಬುಧ್ಯತೇ ತರ್ಹಿ ಸ ಯತ್ ಜ್ಞಾನೀ ಭವೇತ್ ತದರ್ಥಂ ಮೂಢೋ ಭವತು| ");
INSERT INTO sankan_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","ಯಸ್ಮಾದಿಹಲೋಕಸ್ಯ ಜ್ಞಾನಮ್ ಈಶ್ವರಸ್ಯ ಸಾಕ್ಷಾತ್ ಮೂಢತ್ವಮೇವ| ಏತಸ್ಮಿನ್ ಲಿಖಿತಮಪ್ಯಾಸ್ತೇ, ತೀಕ್ಷ್ಣಾ ಯಾ ಜ್ಞಾನಿನಾಂ ಬುದ್ಧಿಸ್ತಯಾ ತಾನ್ ಧರತೀಶ್ವರಃ| ");
INSERT INTO sankan_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","ಪುನಶ್ಚ| ಜ್ಞಾನಿನಾಂ ಕಲ್ಪನಾ ವೇತ್ತಿ ಪರಮೇಶೋ ನಿರರ್ಥಕಾಃ| ");
INSERT INTO sankan_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","ಅತಏವ ಕೋಽಪಿ ಮನುಜೈರಾತ್ಮಾನಂ ನ ಶ್ಲಾಘತಾಂ ಯತಃ ಸರ್ವ್ವಾಣಿ ಯುಷ್ಮಾಕಮೇವ, ");
INSERT INTO sankan_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","ಪೌಲ ವಾ ಆಪಲ್ಲೋ ರ್ವಾ ಕೈಫಾ ವಾ ಜಗದ್ ವಾ ಜೀವನಂ ವಾ ಮರಣಂ ವಾ ವರ್ತ್ತಮಾನಂ ವಾ ಭವಿಷ್ಯದ್ವಾ ಸರ್ವ್ವಾಣ್ಯೇವ ಯುಷ್ಮಾಕಂ, ");
INSERT INTO sankan_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","ಯೂಯಞ್ಚ ಖ್ರೀಷ್ಟಸ್ಯ, ಖ್ರೀಷ್ಟಶ್ಚೇಶ್ವರಸ್ಯ| ");
INSERT INTO sankan_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","ಲೋಕಾ ಅಸ್ಮಾನ್ ಖ್ರೀಷ್ಟಸ್ಯ ಪರಿಚಾರಕಾನ್ ಈಶ್ವರಸ್ಯ ನಿಗೂಠವಾಕ್ಯಧನಸ್ಯಾಧ್ಯಕ್ಷಾಂಶ್ಚ ಮನ್ಯನ್ತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","ಕಿಞ್ಚ ಧನಾಧ್ಯಕ್ಷೇಣ ವಿಶ್ವಸನೀಯೇನ ಭವಿತವ್ಯಮೇತದೇವ ಲೋಕೈ ರ್ಯಾಚ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","ಅತೋ ವಿಚಾರಯದ್ಭಿ ರ್ಯುಷ್ಮಾಭಿರನ್ಯೈಃ ಕೈಶ್ಚಿನ್ ಮನುಜೈ ರ್ವಾ ಮಮ ಪರೀಕ್ಷಣಂ ಮಯಾತೀವ ಲಘು ಮನ್ಯತೇ ಽಹಮಪ್ಯಾತ್ಮಾನಂ ನ ವಿಚಾರಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","ಮಯಾ ಕಿಮಪ್ಯಪರಾದ್ಧಮಿತ್ಯಹಂ ನ ವೇದ್ಮಿ ಕಿನ್ತ್ವೇತೇನ ಮಮ ನಿರಪರಾಧತ್ವಂ ನ ನಿಶ್ಚೀಯತೇ ಪ್ರಭುರೇವ ಮಮ ವಿಚಾರಯಿತಾಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","ಅತ ಉಪಯುಕ್ತಸಮಯಾತ್ ಪೂರ್ವ್ವಮ್ ಅರ್ಥತಃ ಪ್ರಭೋರಾಗಮನಾತ್ ಪೂರ್ವ್ವಂ ಯುಷ್ಮಾಭಿ ರ್ವಿಚಾರೋ ನ ಕ್ರಿಯತಾಂ| ಪ್ರಭುರಾಗತ್ಯ ತಿಮಿರೇಣ ಪ್ರಚ್ಛನ್ನಾನಿ ಸರ್ವ್ವಾಣಿ ದೀಪಯಿಷ್ಯತಿ ಮನಸಾಂ ಮನ್ತ್ರಣಾಶ್ಚ ಪ್ರಕಾಶಯಿಷ್ಯತಿ ತಸ್ಮಿನ್ ಸಮಯ ಈಶ್ವರಾದ್ ಏಕೈಕಸ್ಯ ಪ್ರಶಂಸಾ ಭವಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","ಹೇ ಭ್ರಾತರಃ ಸರ್ವ್ವಾಣ್ಯೇತಾನಿ ಮಯಾತ್ಮಾನಮ್ ಆಪಲ್ಲವಞ್ಚೋದ್ದಿಶ್ಯ ಕಥಿತಾನಿ ತಸ್ಯೈತತ್ ಕಾರಣಂ ಯುಯಂ ಯಥಾ ಶಾಸ್ತ್ರೀಯವಿಧಿಮತಿಕ್ರಮ್ಯ ಮಾನವಮ್ ಅತೀವ ನಾದರಿಷ್ಯಧ್ಬ ಈತ್ಥಞ್ಚೈಕೇನ ವೈಪರೀತ್ಯಾದ್ ಅಪರೇಣ ನ ಶ್ಲಾಘಿಷ್ಯಧ್ಬ ಏತಾದೃಶೀಂ ಶಿಕ್ಷಾಮಾವಯೋರ್ದೃಷ್ಟಾನ್ತಾತ್ ಲಪ್ಸ್ಯಧ್ವೇ| ");
INSERT INTO sankan_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","ಅಪರಾತ್ ಕಸ್ತ್ವಾಂ ವಿಶೇಷಯತಿ? ತುಭ್ಯಂ ಯನ್ನ ದತ್ತ ತಾದೃಶಂ ಕಿಂ ಧಾರಯಸಿ? ಅದತ್ತೇನೇವ ದತ್ತೇನ ವಸ್ತುನಾ ಕುತಃ ಶ್ಲಾಘಸೇ? ");
INSERT INTO sankan_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","ಇದಾನೀಮೇವ ಯೂಯಂ ಕಿಂ ತೃಪ್ತಾ ಲಬ್ಧಧನಾ ವಾ? ಅಸ್ಮಾಸ್ವವಿದ್ಯಮಾನೇಷು ಯೂಯಂ ಕಿಂ ರಾಜತ್ವಪದಂ ಪ್ರಾಪ್ತಾಃ? ಯುಷ್ಮಾಕಂ ರಾಜತ್ವಂ ಮಯಾಭಿಲಷಿತಂ ಯತಸ್ತೇನ ಯುಷ್ಮಾಭಿಃ ಸಹ ವಯಮಪಿ ರಾಜ್ಯಾಂಶಿನೋ ಭವಿಷ್ಯಾಮಃ| ");
INSERT INTO sankan_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","ಪ್ರೇರಿತಾ ವಯಂ ಶೇಷಾ ಹನ್ತವ್ಯಾಶ್ಚೇವೇಶ್ವರೇಣ ನಿದರ್ಶಿತಾಃ| ಯತೋ ವಯಂ ಸರ್ವ್ವಲೋಕಾನಾಮ್ ಅರ್ಥತಃ ಸ್ವರ್ಗೀಯದೂತಾನಾಂ ಮಾನವಾನಾಞ್ಚ ಕೌತುಕಾಸ್ಪದಾನಿ ಜಾತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","ಖ್ರೀಷ್ಟಸ್ಯ ಕೃತೇ ವಯಂ ಮೂಢಾಃ ಕಿನ್ತು ಯೂಯಂ ಖ್ರೀಷ್ಟೇನ ಜ್ಞಾನಿನಃ, ವಯಂ ದುರ್ಬ್ಬಲಾ ಯೂಯಞ್ಚ ಸಬಲಾಃ, ಯೂಯಂ ಸಮ್ಮಾನಿತಾ ವಯಞ್ಚಾಪಮಾನಿತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","ವಯಮದ್ಯಾಪಿ ಕ್ಷುಧಾರ್ತ್ತಾಸ್ತೃಷ್ಣಾರ್ತ್ತಾ ವಸ್ತ್ರಹೀನಾಸ್ತಾಡಿತಾ ಆಶ್ರಮರಹಿತಾಶ್ಚ ಸನ್ತಃ ");
INSERT INTO sankan_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","ಕರ್ಮ್ಮಣಿ ಸ್ವಕರಾನ್ ವ್ಯಾಪಾರಯನ್ತಶ್ಚ ದುಃಖೈಃ ಕಾಲಂ ಯಾಪಯಾಮಃ| ಗರ್ಹಿತೈರಸ್ಮಾಭಿರಾಶೀಃ ಕಥ್ಯತೇ ದೂರೀಕೃತೈಃ ಸಹ್ಯತೇ ನಿನ್ದಿತೈಃ ಪ್ರಸಾದ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","ವಯಮದ್ಯಾಪಿ ಜಗತಃ ಸಮ್ಮಾರ್ಜನೀಯೋಗ್ಯಾ ಅವಕರಾ ಇವ ಸರ್ವ್ವೈ ರ್ಮನ್ಯಾಮಹೇ| ");
INSERT INTO sankan_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","ಯುಷ್ಮಾನ್ ತ್ರಪಯಿತುಮಹಮೇತಾನಿ ಲಿಖಾಮೀತಿ ನಹಿ ಕಿನ್ತು ಪ್ರಿಯಾತ್ಮಜಾನಿವ ಯುಷ್ಮಾನ್ ಪ್ರಬೋಧಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","ಯತಃ ಖ್ರೀಷ್ಟಧರ್ಮ್ಮೇ ಯದ್ಯಪಿ ಯುಷ್ಮಾಕಂ ದಶಸಹಸ್ರಾಣಿ ವಿನೇತಾರೋ ಭವನ್ತಿ ತಥಾಪಿ ಬಹವೋ ಜನಕಾ ನ ಭವನ್ತಿ ಯತೋಽಹಮೇವ ಸುಸಂವಾದೇನ ಯೀಶುಖ್ರೀಷ್ಟೇ ಯುಷ್ಮಾನ್ ಅಜನಯಂ| ");
INSERT INTO sankan_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","ಅತೋ ಯುಷ್ಮಾನ್ ವಿನಯೇಽಹಂ ಯೂಯಂ ಮದನುಗಾಮಿನೋ ಭವತ| ");
INSERT INTO sankan_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","ಇತ್ಯರ್ಥಂ ಸರ್ವ್ವೇಷು ಧರ್ಮ್ಮಸಮಾಜೇಷು ಸರ್ವ್ವತ್ರ ಖ್ರೀಷ್ಟಧರ್ಮ್ಮಯೋಗ್ಯಾ ಯೇ ವಿಧಯೋ ಮಯೋಪದಿಶ್ಯನ್ತೇ ತಾನ್ ಯೋ ಯುಷ್ಮಾನ್ ಸ್ಮಾರಯಿಷ್ಯತ್ಯೇವಮ್ಭೂತಂ ಪ್ರಭೋಃ ಕೃತೇ ಪ್ರಿಯಂ ವಿಶ್ವಾಸಿನಞ್ಚ ಮದೀಯತನಯಂ ತೀಮಥಿಯಂ ಯುಷ್ಮಾಕಂ ಸಮೀಪಂ ಪ್ರೇಷಿತವಾನಹಂ| ");
INSERT INTO sankan_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","ಅಪರಮಹಂ ಯುಷ್ಮಾಕಂ ಸಮೀಪಂ ನ ಗಮಿಷ್ಯಾಮೀತಿ ಬುದ್ಧ್ವಾ ಯುಷ್ಮಾಕಂ ಕಿಯನ್ತೋ ಲೋಕಾ ಗರ್ವ್ವನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","ಕಿನ್ತು ಯದಿ ಪ್ರಭೇರಿಚ್ಛಾ ಭವತಿ ತರ್ಹ್ಯಹಮವಿಲಮ್ಬಂ ಯುಷ್ಮತ್ಸಮೀಪಮುಪಸ್ಥಾಯ ತೇಷಾಂ ದರ್ಪಧ್ಮಾತಾನಾಂ ಲೋಕಾನಾಂ ವಾಚಂ ಜ್ಞಾಸ್ಯಾಮೀತಿ ನಹಿ ಸಾಮರ್ಥ್ಯಮೇವ ಜ್ಞಾಸ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","ಯಸ್ಮಾದೀಶ್ವರಸ್ಯ ರಾಜತ್ವಂ ವಾಗ್ಯುಕ್ತಂ ನಹಿ ಕಿನ್ತು ಸಾಮರ್ಥ್ಯಯುಕ್ತಂ| ");
INSERT INTO sankan_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","ಯುಷ್ಮಾಕಂ ಕಾ ವಾಞ್ಛಾ? ಯುಷ್ಮತ್ಸಮೀಪೇ ಮಯಾ ಕಿಂ ದಣ್ಡಪಾಣಿನಾ ಗನ್ತವ್ಯಮುತ ಪ್ರೇಮನಮ್ರತಾತ್ಮಯುಕ್ತೇನ ವಾ? ");
INSERT INTO sankan_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","ಅಪರಂ ಯುಷ್ಮಾಕಂ ಮಧ್ಯೇ ವ್ಯಭಿಚಾರೋ ವಿದ್ಯತೇ ಸ ಚ ವ್ಯಭಿಚಾರಸ್ತಾದೃಶೋ ಯದ್ ದೇವಪೂಜಕಾನಾಂ ಮಧ್ಯೇಽಪಿ ತತ್ತುಲ್ಯೋ ನ ವಿದ್ಯತೇ ಫಲತೋ ಯುಷ್ಮಾಕಮೇಕೋ ಜನೋ ವಿಮಾತೃಗಮನಂ ಕೃರುತ ಇತಿ ವಾರ್ತ್ತಾ ಸರ್ವ್ವತ್ರ ವ್ಯಾಪ್ತಾ| ");
INSERT INTO sankan_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","ತಥಾಚ ಯೂಯಂ ದರ್ಪಧ್ಮಾತಾ ಆಧ್ಬೇ, ತತ್ ಕರ್ಮ್ಮ ಯೇನ ಕೃತಂ ಸ ಯಥಾ ಯುಷ್ಮನ್ಮಧ್ಯಾದ್ ದೂರೀಕ್ರಿಯತೇ ತಥಾ ಶೋಕೋ ಯುಷ್ಮಾಭಿ ರ್ನ ಕ್ರಿಯತೇ ಕಿಮ್ ಏತತ್? ");
INSERT INTO sankan_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","ಅವಿದ್ಯಮಾನೇ ಮದೀಯಶರೀರೇ ಮಮಾತ್ಮಾ ಯುಷ್ಮನ್ಮಧ್ಯೇ ವಿದ್ಯತೇ ಅತೋಽಹಂ ವಿದ್ಯಮಾನ ಇವ ತತ್ಕರ್ಮ್ಮಕಾರಿಣೋ ವಿಚಾರಂ ನಿಶ್ಚಿತವಾನ್, ");
INSERT INTO sankan_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","ಅಸ್ಮತ್ಪ್ರಭೋ ರ್ಯೀಶುಖ್ರೀಷ್ಟಸ್ಯ ನಾಮ್ನಾ ಯುಷ್ಮಾಕಂ ಮದೀಯಾತ್ಮನಶ್ಚ ಮಿಲನೇ ಜಾತೇ ಽಸ್ಮತ್ಪ್ರಭೋ ರ್ಯೀಶುಖ್ರೀಷ್ಟಸ್ಯ ಶಕ್ತೇಃ ಸಾಹಾಯ್ಯೇನ ");
INSERT INTO sankan_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","ಸ ನರಃ ಶರೀರನಾಶಾರ್ಥಮಸ್ಮಾಭಿಃ ಶಯತಾನೋ ಹಸ್ತೇ ಸಮರ್ಪಯಿತವ್ಯಸ್ತತೋಽಸ್ಮಾಕಂ ಪ್ರಭೋ ರ್ಯೀಶೋ ರ್ದಿವಸೇ ತಸ್ಯಾತ್ಮಾ ರಕ್ಷಾಂ ಗನ್ತುಂ ಶಕ್ಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","ಯುಷ್ಮಾಕಂ ದರ್ಪೋ ನ ಭದ್ರಾಯ ಯೂಯಂ ಕಿಮೇತನ್ನ ಜಾನೀಥ, ಯಥಾ, ವಿಕಾರಃ ಕೃತ್ಸ್ನಶಕ್ತೂನಾಂ ಸ್ವಲ್ಪಕಿಣ್ವೇನ ಜಾಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","ಯೂಯಂ ಯತ್ ನವೀನಶಕ್ತುಸ್ವರೂಪಾ ಭವೇತ ತದರ್ಥಂ ಪುರಾತನಂ ಕಿಣ್ವಮ್ ಅವಮಾರ್ಜ್ಜತ ಯತೋ ಯುಷ್ಮಾಭಿಃ ಕಿಣ್ವಶೂನ್ಯೈ ರ್ಭವಿತವ್ಯಂ| ಅಪರಮ್ ಅಸ್ಮಾಕಂ ನಿಸ್ತಾರೋತ್ಸವೀಯಮೇಷಶಾವಕೋ ಯಃ ಖ್ರೀಷ್ಟಃ ಸೋಽಸ್ಮದರ್ಥಂ ಬಲೀಕೃತೋ ಽಭವತ್| ");
INSERT INTO sankan_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","ಅತಃ ಪುರಾತನಕಿಣ್ವೇನಾರ್ಥತೋ ದುಷ್ಟತಾಜಿಘಾಂಸಾರೂಪೇಣ ಕಿಣ್ವೇನ ತನ್ನಹಿ ಕಿನ್ತು ಸಾರಲ್ಯಸತ್ಯತ್ವರೂಪಯಾ ಕಿಣ್ವಶೂನ್ಯತಯಾಸ್ಮಾಭಿರುತ್ಸವಃ ಕರ್ತ್ತವ್ಯಃ| ");
INSERT INTO sankan_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","ವ್ಯಾಭಿಚಾರಿಣಾಂ ಸಂಸರ್ಗೋ ಯುಷ್ಮಾಭಿ ರ್ವಿಹಾತವ್ಯ ಇತಿ ಮಯಾ ಪತ್ರೇ ಲಿಖಿತಂ| ");
INSERT INTO sankan_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","ಕಿನ್ತ್ವೈಹಿಕಲೋಕಾನಾಂ ಮಧ್ಯೇ ಯೇ ವ್ಯಭಿಚಾರಿಣೋ ಲೋಭಿನ ಉಪದ್ರಾವಿಣೋ ದೇವಪೂಜಕಾ ವಾ ತೇಷಾಂ ಸಂಸರ್ಗಃ ಸರ್ವ್ವಥಾ ವಿಹಾತವ್ಯ ಇತಿ ನಹಿ, ವಿಹಾತವ್ಯೇ ಸತಿ ಯುಷ್ಮಾಭಿ ರ್ಜಗತೋ ನಿರ್ಗನ್ತವ್ಯಮೇವ| ");
INSERT INTO sankan_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","ಕಿನ್ತು ಭ್ರಾತೃತ್ವೇನ ವಿಖ್ಯಾತಃ ಕಶ್ಚಿಜ್ಜನೋ ಯದಿ ವ್ಯಭಿಚಾರೀ ಲೋಭೀ ದೇವಪೂಜಕೋ ನಿನ್ದಕೋ ಮದ್ಯಪ ಉಪದ್ರಾವೀ ವಾ ಭವೇತ್ ತರ್ಹಿ ತಾದೃಶೇನ ಮಾನವೇನ ಸಹ ಭೋಜನಪಾನೇಽಪಿ ಯುಷ್ಮಾಭಿ ರ್ನ ಕರ್ತ್ತವ್ಯೇ ಇತ್ಯಧುನಾ ಮಯಾ ಲಿಖಿತಂ| ");
INSERT INTO sankan_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","ಸಮಾಜಬಹಿಃಸ್ಥಿತಾನಾಂ ಲೋಕಾನಾಂ ವಿಚಾರಕರಣೇ ಮಮ ಕೋಽಧಿಕಾರಃ? ಕಿನ್ತು ತದನ್ತರ್ಗತಾನಾಂ ವಿಚಾರಣಂ ಯುಷ್ಮಾಭಿಃ ಕಿಂ ನ ಕರ್ತ್ತವ್ಯಂ ಭವೇತ್? ");
INSERT INTO sankan_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","ಬಹಿಃಸ್ಥಾನಾಂ ತು ವಿಚಾರ ಈಶ್ವರೇಣ ಕಾರಿಷ್ಯತೇ| ಅತೋ ಯುಷ್ಮಾಭಿಃ ಸ ಪಾತಕೀ ಸ್ವಮಧ್ಯಾದ್ ಬಹಿಷ್ಕ್ರಿಯತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","ಯುಷ್ಮಾಕಮೇಕಸ್ಯ ಜನಸ್ಯಾಪರೇಣ ಸಹ ವಿವಾದೇ ಜಾತೇ ಸ ಪವಿತ್ರಲೋಕೈ ರ್ವಿಚಾರಮಕಾರಯನ್ ಕಿಮ್ ಅಧಾರ್ಮ್ಮಿಕಲೋಕೈ ರ್ವಿಚಾರಯಿತುಂ ಪ್ರೋತ್ಸಹತೇ? ");
INSERT INTO sankan_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","ಜಗತೋಽಪಿ ವಿಚಾರಣಂ ಪವಿತ್ರಲೋಕೈಃ ಕಾರಿಷ್ಯತ ಏತದ್ ಯೂಯಂ ಕಿಂ ನ ಜಾನೀಥ? ಅತೋ ಜಗದ್ ಯದಿ ಯುಷ್ಮಾಭಿ ರ್ವಿಚಾರಯಿತವ್ಯಂ ತರ್ಹಿ ಕ್ಷುದ್ರತಮವಿಚಾರೇಷು ಯೂಯಂ ಕಿಮಸಮರ್ಥಾಃ? ");
INSERT INTO sankan_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","ದೂತಾ ಅಪ್ಯಸ್ಮಾಭಿ ರ್ವಿಚಾರಯಿಷ್ಯನ್ತ ಇತಿ ಕಿಂ ನ ಜಾನೀಥ? ಅತ ಐಹಿಕವಿಷಯಾಃ ಕಿಮ್ ಅಸ್ಮಾಭಿ ರ್ನ ವಿಚಾರಯಿತವ್ಯಾ ಭವೇಯುಃ? ");
INSERT INTO sankan_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","ಐಹಿಕವಿಷಯಸ್ಯ ವಿಚಾರೇ ಯುಷ್ಮಾಭಿಃ ಕರ್ತ್ತವ್ಯೇ ಯೇ ಲೋಕಾಃ ಸಮಿತೌ ಕ್ಷುದ್ರತಮಾಸ್ತ ಏವ ನಿಯುಜ್ಯನ್ತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","ಅಹಂ ಯುಷ್ಮಾನ್ ತ್ರಪಯಿತುಮಿಚ್ಛನ್ ವದಾಮಿ ಯೃಷ್ಮನ್ಮಧ್ಯೇ ಕಿಮೇಕೋಽಪಿ ಮನುಷ್ಯಸ್ತಾದೃಗ್ ಬುದ್ಧಿಮಾನ್ನಹಿ ಯೋ ಭ್ರಾತೃವಿವಾದವಿಚಾರಣೇ ಸಮರ್ಥಃ ಸ್ಯಾತ್? ");
INSERT INTO sankan_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","ಕಿಞ್ಚೈಕೋ ಭ್ರಾತಾ ಭ್ರಾತ್ರಾನ್ಯೇನ ಕಿಮವಿಶ್ವಾಸಿನಾಂ ವಿಚಾರಕಾಣಾಂ ಸಾಕ್ಷಾದ್ ವಿವದತೇ? ಯಷ್ಮನ್ಮಧ್ಯೇ ವಿವಾದಾ ವಿದ್ಯನ್ತ ಏತದಪಿ ಯುಷ್ಮಾಕಂ ದೋಷಃ| ");
INSERT INTO sankan_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","ಯೂಯಂ ಕುತೋಽನ್ಯಾಯಸಹನಂ ಕ್ಷತಿಸಹನಂ ವಾ ಶ್ರೇಯೋ ನ ಮನ್ಯಧ್ವೇ? ");
INSERT INTO sankan_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","ಕಿನ್ತು ಯೂಯಮಪಿ ಭ್ರಾತೃನೇವ ಪ್ರತ್ಯನ್ಯಾಯಂ ಕ್ಷತಿಞ್ಚ ಕುರುಥ ಕಿಮೇತತ್? ");
INSERT INTO sankan_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","ಈಶ್ವರಸ್ಯ ರಾಜ್ಯೇಽನ್ಯಾಯಕಾರಿಣಾಂ ಲೋಕಾನಾಮಧಿಕಾರೋ ನಾಸ್ತ್ಯೇತದ್ ಯೂಯಂ ಕಿಂ ನ ಜಾನೀಥ? ಮಾ ವಞ್ಚ್ಯಧ್ವಂ, ಯೇ ವ್ಯಭಿಚಾರಿಣೋ ದೇವಾರ್ಚ್ಚಿನಃ ಪಾರದಾರಿಕಾಃ ಸ್ತ್ರೀವದಾಚಾರಿಣಃ ಪುಂಮೈಥುನಕಾರಿಣಸ್ತಸ್ಕರಾ ");
INSERT INTO sankan_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","ಲೋಭಿನೋ ಮದ್ಯಪಾ ನಿನ್ದಕಾ ಉಪದ್ರಾವಿಣೋ ವಾ ತ ಈಶ್ವರಸ್ಯ ರಾಜ್ಯಭಾಗಿನೋ ನ ಭವಿಷ್ಯನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","ಯೂಯಞ್ಚೈವಂವಿಧಾ ಲೋಕಾ ಆಸ್ತ ಕಿನ್ತು ಪ್ರಭೋ ರ್ಯೀಶೋ ರ್ನಾಮ್ನಾಸ್ಮದೀಶ್ವರಸ್ಯಾತ್ಮನಾ ಚ ಯೂಯಂ ಪ್ರಕ್ಷಾಲಿತಾಃ ಪಾವಿತಾಃ ಸಪುಣ್ಯೀಕೃತಾಶ್ಚ| ");
INSERT INTO sankan_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","ಮದರ್ಥಂ ಸರ್ವ್ವಂ ದ್ರವ್ಯಮ್ ಅಪ್ರತಿಷಿದ್ಧಂ ಕಿನ್ತು ನ ಸರ್ವ್ವಂ ಹಿತಜನಕಂ| ಮದರ್ಥಂ ಸರ್ವ್ವಮಪ್ರತಿಷಿದ್ಧಂ ತಥಾಪ್ಯಹಂ ಕಸ್ಯಾಪಿ ದ್ರವ್ಯಸ್ಯ ವಶೀಕೃತೋ ನ ಭವಿಷ್ಯಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","ಉದರಾಯ ಭಕ್ಷ್ಯಾಣಿ ಭಕ್ಷ್ಯೇಭ್ಯಶ್ಚೋದರಂ, ಕಿನ್ತು ಭಕ್ಷ್ಯೋದರೇ ಈಶ್ವರೇಣ ನಾಶಯಿಷ್ಯೇತೇ; ಅಪರಂ ದೇಹೋ ನ ವ್ಯಭಿಚಾರಾಯ ಕಿನ್ತು ಪ್ರಭವೇ ಪ್ರಭುಶ್ಚ ದೇಹಾಯ| ");
INSERT INTO sankan_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","ಯಶ್ಚೇಶ್ವರಃ ಪ್ರಭುಮುತ್ಥಾಪಿತವಾನ್ ಸ ಸ್ವಶಕ್ತ್ಯಾಸ್ಮಾನಪ್ಯುತ್ಥಾಪಯಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","ಯುಷ್ಮಾಕಂ ಯಾನಿ ಶರೀರಾಣಿ ತಾನಿ ಖ್ರೀಷ್ಟಸ್ಯಾಙ್ಗಾನೀತಿ ಕಿಂ ಯೂಯಂ ನ ಜಾನೀಥ? ಅತಃ ಖ್ರೀಷ್ಟಸ್ಯ ಯಾನ್ಯಙ್ಗಾನಿ ತಾನಿ ಮಯಾಪಹೃತ್ಯ ವೇಶ್ಯಾಯಾ ಅಙ್ಗಾನಿ ಕಿಂ ಕಾರಿಷ್ಯನ್ತೇ? ತನ್ನ ಭವತು| ");
INSERT INTO sankan_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","ಯಃ ಕಶ್ಚಿದ್ ವೇಶ್ಯಾಯಾಮ್ ಆಸಜ್ಯತೇ ಸ ತಯಾ ಸಹೈಕದೇಹೋ ಭವತಿ ಕಿಂ ಯೂಯಮೇತನ್ನ ಜಾನೀಥ? ಯತೋ ಲಿಖಿತಮಾಸ್ತೇ, ಯಥಾ, ತೌ ದ್ವೌ ಜನಾವೇಕಾಙ್ಗೌ ಭವಿಷ್ಯತಃ| ");
INSERT INTO sankan_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","ಮಾನವಾ ಯಾನ್ಯನ್ಯಾನಿ ಕಲುಷಾಣಿ ಕುರ್ವ್ವತೇ ತಾನಿ ವಪು ರ್ನ ಸಮಾವಿಶನ್ತಿ ಕಿನ್ತು ವ್ಯಭಿಚಾರಿಣಾ ಸ್ವವಿಗ್ರಹಸ್ಯ ವಿರುದ್ಧಂ ಕಲ್ಮಷಂ ಕ್ರಿಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","ಮಾನವಾ ಯಾನ್ಯನ್ಯಾನಿ ಕಲುಷಾಣಿ ಕುರ್ವ್ವತೇ ತಾನಿ ವಪು ರ್ನ ಸಮಾವಿಶನ್ತಿ ಕಿನ್ತು ವ್ಯಭಿಚಾರಿಣಾ ಸ್ವವಿಗ್ರಹಸ್ಯ ವಿರುದ್ಧಂ ಕಲ್ಮಷಂ ಕ್ರಿಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","ಯುಷ್ಮಾಕಂ ಯಾನಿ ವಪೂಂಸಿ ತಾನಿ ಯುಷ್ಮದನ್ತಃಸ್ಥಿತಸ್ಯೇಶ್ವರಾಲ್ಲಬ್ಧಸ್ಯ ಪವಿತ್ರಸ್ಯಾತ್ಮನೋ ಮನ್ದಿರಾಣಿ ಯೂಯಞ್ಚ ಸ್ವೇಷಾಂ ಸ್ವಾಮಿನೋ ನಾಧ್ವೇ ಕಿಮೇತದ್ ಯುಷ್ಮಾಭಿ ರ್ನ ಜ್ಞಾಯತೇ? ");
INSERT INTO sankan_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","ಯೂಯಂ ಮೂಲ್ಯೇನ ಕ್ರೀತಾ ಅತೋ ವಪುರ್ಮನೋಭ್ಯಾಮ್ ಈಶ್ವರೋ ಯುಷ್ಮಾಭಿಃ ಪೂಜ್ಯತಾಂ ಯತ ಈಶ್ವರ ಏವ ತಯೋಃ ಸ್ವಾಮೀ| ");
INSERT INTO sankan_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","ಅಪರಞ್ಚ ಯುಷ್ಮಾಭಿ ರ್ಮಾಂ ಪ್ರತಿ ಯತ್ ಪತ್ರಮಲೇಖಿ ತಸ್ಯೋತ್ತರಮೇತತ್, ಯೋಷಿತೋಽಸ್ಪರ್ಶನಂ ಮನುಜಸ್ಯ ವರಂ; ");
INSERT INTO sankan_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","ಕಿನ್ತು ವ್ಯಭಿಚಾರಭಯಾದ್ ಏಕೈಕಸ್ಯ ಪುಂಸಃ ಸ್ವಕೀಯಭಾರ್ಯ್ಯಾ ಭವತು ತದ್ವದ್ ಏಕೈಕಸ್ಯಾ ಯೋಷಿತೋ ಽಪಿ ಸ್ವಕೀಯಭರ್ತ್ತಾ ಭವತು| ");
INSERT INTO sankan_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","ಭಾರ್ಯ್ಯಾಯೈ ಭರ್ತ್ರಾ ಯದ್ಯದ್ ವಿತರಣೀಯಂ ತದ್ ವಿತೀರ್ಯ್ಯತಾಂ ತದ್ವದ್ ಭರ್ತ್ರೇಽಪಿ ಭಾರ್ಯ್ಯಯಾ ವಿತರಣೀಯಂ ವಿತೀರ್ಯ್ಯತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","ಭಾರ್ಯ್ಯಾಯಾಃ ಸ್ವದೇಹೇ ಸ್ವತ್ವಂ ನಾಸ್ತಿ ಭರ್ತ್ತುರೇವ, ತದ್ವದ್ ಭರ್ತ್ತುರಪಿ ಸ್ವದೇಹೇ ಸ್ವತ್ವಂ ನಾಸ್ತಿ ಭಾರ್ಯ್ಯಾಯಾ ಏವ| ");
INSERT INTO sankan_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","ಉಪೋಷಣಪ್ರಾರ್ಥನಯೋಃ ಸೇವನಾರ್ಥಮ್ ಏಕಮನ್ತ್ರಣಾನಾಂ ಯುಷ್ಮಾಕಂ ಕಿಯತ್ಕಾಲಂ ಯಾವದ್ ಯಾ ಪೃಥಕ್ಸ್ಥಿತಿ ರ್ಭವತಿ ತದನ್ಯೋ ವಿಚ್ಛೇದೋ ಯುಷ್ಮನ್ಮಧ್ಯೇ ನ ಭವತು, ತತಃ ಪರಮ್ ಇನ್ದ್ರಿಯಾಣಾಮ್ ಅಧೈರ್ಯ್ಯಾತ್ ಶಯತಾನ್ ಯದ್ ಯುಷ್ಮಾನ್ ಪರೀಕ್ಷಾಂ ನ ನಯೇತ್ ತದರ್ಥಂ ಪುನರೇಕತ್ರ ಮಿಲತ| ");
INSERT INTO sankan_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","ಏತದ್ ಆದೇಶತೋ ನಹಿ ಕಿನ್ತ್ವನುಜ್ಞಾತ ಏವ ಮಯಾ ಕಥ್ಯತೇ, ");
INSERT INTO sankan_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","ಯತೋ ಮಮಾವಸ್ಥೇವ ಸರ್ವ್ವಮಾನವಾನಾಮವಸ್ಥಾ ಭವತ್ವಿತಿ ಮಮ ವಾಞ್ಛಾ ಕಿನ್ತ್ವೀಶ್ವರಾದ್ ಏಕೇನೈಕೋ ವರೋಽನ್ಯೇನ ಚಾನ್ಯೋ ವರ ಇತ್ಥಮೇಕೈಕೇನ ಸ್ವಕೀಯವರೋ ಲಬ್ಧಃ| ");
INSERT INTO sankan_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","ಅಪರಮ್ ಅಕೃತವಿವಾಹಾನ್ ವಿಧವಾಶ್ಚ ಪ್ರತಿ ಮಮೈತನ್ನಿವೇದನಂ ಮಮೇವ ತೇಷಾಮವಸ್ಥಿತಿ ರ್ಭದ್ರಾ; ");
INSERT INTO sankan_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","ಕಿಞ್ಚ ಯದಿ ತೈರಿನ್ದ್ರಿಯಾಣಿ ನಿಯನ್ತುಂ ನ ಶಕ್ಯನ್ತೇ ತರ್ಹಿ ವಿವಾಹಃ ಕ್ರಿಯತಾಂ ಯತಃ ಕಾಮದಹನಾದ್ ವ್ಯೂಢತ್ವಂ ಭದ್ರಂ| ");
INSERT INTO sankan_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","ಯೇ ಚ ಕೃತವಿವಾಹಾಸ್ತೇ ಮಯಾ ನಹಿ ಪ್ರಭುನೈವೈತದ್ ಆಜ್ಞಾಪ್ಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","ಭಾರ್ಯ್ಯಾ ಭರ್ತ್ತೃತಃ ಪೃಥಕ್ ನ ಭವತು| ಯದಿ ವಾ ಪೃಥಗ್ಭೂತಾ ಸ್ಯಾತ್ ತರ್ಹಿ ನಿರ್ವಿವಾಹಾ ತಿಷ್ಠತು ಸ್ವೀಯಪತಿನಾ ವಾ ಸನ್ದಧಾತು ಭರ್ತ್ತಾಪಿ ಭಾರ್ಯ್ಯಾಂ ನ ತ್ಯಜತು| ");
INSERT INTO sankan_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","ಇತರಾನ್ ಜನಾನ್ ಪ್ರತಿ ಪ್ರಭು ರ್ನ ಬ್ರವೀತಿ ಕಿನ್ತ್ವಹಂ ಬ್ರವೀಮಿ; ಕಸ್ಯಚಿದ್ ಭ್ರಾತುರ್ಯೋಷಿದ್ ಅವಿಶ್ವಾಸಿನೀ ಸತ್ಯಪಿ ಯದಿ ತೇನ ಸಹವಾಸೇ ತುಷ್ಯತಿ ತರ್ಹಿ ಸಾ ತೇನ ನ ತ್ಯಜ್ಯತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","ತದ್ವತ್ ಕಸ್ಯಾಶ್ಚಿದ್ ಯೋಷಿತಃ ಪತಿರವಿಶ್ವಾಸೀ ಸನ್ನಪಿ ಯದಿ ತಯಾ ಸಹವಾಸೇ ತುಷ್ಯತಿ ತರ್ಹಿ ಸ ತಯಾ ನ ತ್ಯಜ್ಯತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","ಯತೋಽವಿಶ್ವಾಸೀ ಭರ್ತ್ತಾ ಭಾರ್ಯ್ಯಯಾ ಪವಿತ್ರೀಭೂತಃ, ತದ್ವದವಿಶ್ವಾಸಿನೀ ಭಾರ್ಯ್ಯಾ ಭರ್ತ್ರಾ ಪವಿತ್ರೀಭೂತಾ; ನೋಚೇದ್ ಯುಷ್ಮಾಕಮಪತ್ಯಾನ್ಯಶುಚೀನ್ಯಭವಿಷ್ಯನ್ ಕಿನ್ತ್ವಧುನಾ ತಾನಿ ಪವಿತ್ರಾಣಿ ಸನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","ಅವಿಶ್ವಾಸೀ ಜನೋ ಯದಿ ವಾ ಪೃಥಗ್ ಭವತಿ ತರ್ಹಿ ಪೃಥಗ್ ಭವತು; ಏತೇನ ಭ್ರಾತಾ ಭಗಿನೀ ವಾ ನ ನಿಬಧ್ಯತೇ ತಥಾಪಿ ವಯಮೀಶ್ವರೇಣ ಶಾನ್ತಯೇ ಸಮಾಹೂತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","ಹೇ ನಾರಿ ತವ ಭರ್ತ್ತುಃ ಪರಿತ್ರಾಣಂ ತ್ವತ್ತೋ ಭವಿಷ್ಯತಿ ನ ವೇತಿ ತ್ವಯಾ ಕಿಂ ಜ್ಞಾಯತೇ? ಹೇ ನರ ತವ ಜಾಯಾಯಾಃ ಪರಿತ್ರಾಣಂ ತ್ವತ್ತೇा ಭವಿಷ್ಯತಿ ನ ವೇತಿ ತ್ವಯಾ ಕಿಂ ಜ್ಞಾಯತೇ? ");
INSERT INTO sankan_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","ಏಕೈಕೋ ಜನಃ ಪರಮೇಶ್ವರಾಲ್ಲಬ್ಧಂ ಯದ್ ಭಜತೇ ಯಸ್ಯಾಞ್ಚಾವಸ್ಥಾಯಾಮ್ ಈಶ್ವರೇಣಾಹ್ವಾಯಿ ತದನುಸಾರೇಣೈವಾಚರತು ತದಹಂ ಸರ್ವ್ವಸಮಾಜಸ್ಥಾನ್ ಆದಿಶಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","ಛಿನ್ನತ್ವಗ್ ಭೃತ್ವಾ ಯ ಆಹೂತಃ ಸ ಪ್ರಕೃಷ್ಟತ್ವಕ್ ನ ಭವತು, ತದ್ವದ್ ಅಛಿನ್ನತ್ವಗ್ ಭೂತ್ವಾ ಯ ಆಹೂತಃ ಸ ಛಿನ್ನತ್ವಕ್ ನ ಭವತು| ");
INSERT INTO sankan_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","ತ್ವಕ್ಛೇದಃ ಸಾರೋ ನಹಿ ತದ್ವದತ್ವಕ್ಛೇದೋಽಪಿ ಸಾರೋ ನಹಿ ಕಿನ್ತ್ವೀಶ್ವರಸ್ಯಾಜ್ಞಾನಾಂ ಪಾಲನಮೇವ| ");
INSERT INTO sankan_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","ಯೋ ಜನೋ ಯಸ್ಯಾಮವಸ್ಥಾಯಾಮಾಹ್ವಾಯಿ ಸ ತಸ್ಯಾಮೇವಾವತಿಷ್ಠತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","ದಾಸಃ ಸನ್ ತ್ವಂ ಕಿಮಾಹೂತೋಽಸಿ? ತನ್ಮಾ ಚಿನ್ತಯ, ತಥಾಚ ಯದಿ ಸ್ವತನ್ತ್ರೋ ಭವಿತುಂ ಶಕ್ನುಯಾಸ್ತರ್ಹಿ ತದೇವ ವೃಣು| ");
INSERT INTO sankan_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","ಯತಃ ಪ್ರಭುನಾಹೂತೋ ಯೋ ದಾಸಃ ಸ ಪ್ರಭೋ ರ್ಮೋಚಿತಜನಃ| ತದ್ವದ್ ತೇನಾಹೂತಃ ಸ್ವತನ್ತ್ರೋ ಜನೋಽಪಿ ಖ್ರೀಷ್ಟಸ್ಯ ದಾಸ ಏವ| ");
INSERT INTO sankan_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","ಯೂಯಂ ಮೂಲ್ಯೇನ ಕ್ರೀತಾ ಅತೋ ಹೇತೋ ರ್ಮಾನವಾನಾಂ ದಾಸಾ ಮಾ ಭವತ| ");
INSERT INTO sankan_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","ಹೇ ಭ್ರಾತರೋ ಯಸ್ಯಾಮವಸ್ಥಾಯಾಂ ಯಸ್ಯಾಹ್ವಾನಮಭವತ್ ತಯಾ ಸ ಈಶ್ವರಸ್ಯ ಸಾಕ್ಷಾತ್ ತಿಷ್ಠತು| ");
INSERT INTO sankan_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","ಅಪರಮ್ ಅಕೃತವಿವಾಹಾನ್ ಜನಾನ್ ಪ್ರತಿ ಪ್ರಭೋಃ ಕೋಽಪ್ಯಾದೇಶೋ ಮಯಾ ನ ಲಬ್ಧಃ ಕಿನ್ತು ಪ್ರಭೋರನುಕಮ್ಪಯಾ ವಿಶ್ವಾಸ್ಯೋ ಭೂತೋಽಹಂ ಯದ್ ಭದ್ರಂ ಮನ್ಯೇ ತದ್ ವದಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","ವರ್ತ್ತಮಾನಾತ್ ಕ್ಲೇಶಸಮಯಾತ್ ಮನುಷ್ಯಸ್ಯಾನೂಢತ್ವಂ ಭದ್ರಮಿತಿ ಮಯಾ ಬುಧ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","ತ್ವಂ ಕಿಂ ಯೋಷಿತಿ ನಿಬದ್ಧೋಽಸಿ ತರ್ಹಿ ಮೋಚನಂ ಪ್ರಾಪ್ತುಂ ಮಾ ಯತಸ್ವ| ಕಿಂ ವಾ ಯೋಷಿತೋ ಮುಕ್ತೋಽಸಿ? ತರ್ಹಿ ಜಾಯಾಂ ಮಾ ಗವೇಷಯ| ");
INSERT INTO sankan_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","ವಿವಾಹಂ ಕುರ್ವ್ವತಾ ತ್ವಯಾ ಕಿಮಪಿ ನಾಪಾರಾಧ್ಯತೇ ತದ್ವದ್ ವ್ಯೂಹ್ಯಮಾನಯಾ ಯುವತ್ಯಾಪಿ ಕಿಮಪಿ ನಾಪರಾಧ್ಯತೇ ತಥಾಚ ತಾದೃಶೌ ದ್ವೌ ಜನೌ ಶಾರೀರಿಕಂ ಕ್ಲೇಶಂ ಲಪ್ಸ್ಯೇತೇ ಕಿನ್ತು ಯುಷ್ಮಾನ್ ಪ್ರತಿ ಮಮ ಕರುಣಾ ವಿದ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","ಹೇ ಭ್ರಾತರೋಽಹಮಿದಂ ಬ್ರವೀಮಿ, ಇತಃ ಪರಂ ಸಮಯೋಽತೀವ ಸಂಕ್ಷಿಪ್ತಃ, ");
INSERT INTO sankan_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","ಅತಃ ಕೃತದಾರೈರಕೃತದಾರೈರಿವ ರುದದ್ಭಿಶ್ಚಾರುದದ್ಭಿರಿವ ಸಾನನ್ದೈಶ್ಚ ನಿರಾನನ್ದೈರಿವ ಕ್ರೇತೃಭಿಶ್ಚಾಭಾಗಿಭಿರಿವಾಚರಿತವ್ಯಂ ");
INSERT INTO sankan_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","ಯೇ ಚ ಸಂಸಾರೇ ಚರನ್ತಿ ತೈ ರ್ನಾತಿಚರಿತವ್ಯಂ ಯತ ಇಹಲೇाಕಸ್ಯ ಕೌತುಕೋ ವಿಚಲತಿ| ");
INSERT INTO sankan_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","ಕಿನ್ತು ಯೂಯಂ ಯನ್ನಿಶ್ಚಿನ್ತಾ ಭವೇತೇತಿ ಮಮ ವಾಞ್ಛಾ| ಅಕೃತವಿವಾಹೋ ಜನೋ ಯಥಾ ಪ್ರಭುಂ ಪರಿತೋಷಯೇತ್ ತಥಾ ಪ್ರಭುಂ ಚಿನ್ತಯತಿ, ");
INSERT INTO sankan_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","ಕಿನ್ತು ಕೃತವಿವಾಹೋ ಜನೋ ಯಥಾ ಭಾರ್ಯ್ಯಾಂ ಪರಿತೋಷಯೇತ್ ತಥಾ ಸಂಸಾರಂ ಚಿನ್ತಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","ತದ್ವದ್ ಊಢಯೋಷಿತೋ ಽನೂಢಾ ವಿಶಿಷ್ಯತೇ| ಯಾನೂಢಾ ಸಾ ಯಥಾ ಕಾಯಮನಸೋಃ ಪವಿತ್ರಾ ಭವೇತ್ ತಥಾ ಪ್ರಭುಂ ಚಿನ್ತಯತಿ ಯಾ ಚೋಢಾ ಸಾ ಯಥಾ ಭರ್ತ್ತಾರಂ ಪರಿತೋಷಯೇತ್ ತಥಾ ಸಂಸಾರಂ ಚಿನ್ತಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","ಅಹಂ ಯದ್ ಯುಷ್ಮಾನ್ ಮೃಗಬನ್ಧಿನ್ಯಾ ಪರಿಕ್ಷಿಪೇಯಂ ತದರ್ಥಂ ನಹಿ ಕಿನ್ತು ಯೂಯಂ ಯದನಿನ್ದಿತಾ ಭೂತ್ವಾ ಪ್ರಭೋಃ ಸೇವನೇಽಬಾಧಮ್ ಆಸಕ್ತಾ ಭವೇತ ತದರ್ಥಮೇತಾನಿ ಸರ್ವ್ವಾಣಿ ಯುಷ್ಮಾಕಂ ಹಿತಾಯ ಮಯಾ ಕಥ್ಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","ಕಸ್ಯಚಿತ್ ಕನ್ಯಾಯಾಂ ಯೌವನಪ್ರಾಪ್ತಾಯಾಂ ಯದಿ ಸ ತಸ್ಯಾ ಅನೂಢತ್ವಂ ನಿನ್ದನೀಯಂ ವಿವಾಹಶ್ಚ ಸಾಧಯಿತವ್ಯ ಇತಿ ಮನ್ಯತೇ ತರ್ಹಿ ಯಥಾಭಿಲಾಷಂ ಕರೋತು, ಏತೇನ ಕಿಮಪಿ ನಾಪರಾತ್ಸ್ಯತಿ ವಿವಾಹಃ ಕ್ರಿಯತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","ಕಿನ್ತು ದುಃಖೇನಾಕ್ಲಿಷ್ಟಃ ಕಶ್ಚಿತ್ ಪಿತಾ ಯದಿ ಸ್ಥಿರಮನೋಗತಃ ಸ್ವಮನೋಽಭಿಲಾಷಸಾಧನೇ ಸಮರ್ಥಶ್ಚ ಸ್ಯಾತ್ ಮಮ ಕನ್ಯಾ ಮಯಾ ರಕ್ಷಿತವ್ಯೇತಿ ಮನಸಿ ನಿಶ್ಚಿನೋತಿ ಚ ತರ್ಹಿ ಸ ಭದ್ರಂ ಕರ್ಮ್ಮ ಕರೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","ಅತೋ ಯೋ ವಿವಾಹಂ ಕರೋತಿ ಸ ಭದ್ರಂ ಕರ್ಮ್ಮ ಕರೋತಿ ಯಶ್ಚ ವಿವಾಹಂ ನ ಕರೋತಿ ಸ ಭದ್ರತರಂ ಕರ್ಮ್ಮ ಕರೋತಿ| ");
INSERT INTO sankan_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","ಯಾವತ್ಕಾಲಂ ಪತಿ ರ್ಜೀವತಿ ತಾವದ್ ಭಾರ್ಯ್ಯಾ ವ್ಯವಸ್ಥಯಾ ನಿಬದ್ಧಾ ತಿಷ್ಠತಿ ಕಿನ್ತು ಪತ್ಯೌ ಮಹಾನಿದ್ರಾಂ ಗತೇ ಸಾ ಮುಕ್ತೀಭೂಯ ಯಮಭಿಲಷತಿ ತೇನ ಸಹ ತಸ್ಯಾ ವಿವಾಹೋ ಭವಿತುಂ ಶಕ್ನೋತಿ, ಕಿನ್ತ್ವೇತತ್ ಕೇವಲಂ ಪ್ರಭುಭಕ್ತಾನಾಂ ಮಧ್ಯೇ| ");
INSERT INTO sankan_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","ತಥಾಚ ಸಾ ಯದಿ ನಿಷ್ಪತಿಕಾ ತಿಷ್ಠತಿ ತರ್ಹಿ ತಸ್ಯಾಃ ಕ್ಷೇಮಂ ಭವಿಷ್ಯತೀತಿ ಮಮ ಭಾವಃ| ಅಪರಮ್ ಈಶ್ವರಸ್ಯಾತ್ಮಾ ಮಮಾಪ್ಯನ್ತ ರ್ವಿದ್ಯತ ಇತಿ ಮಯಾ ಬುಧ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","ದೇವಪ್ರಸಾದೇ ಸರ್ವ್ವೇಷಾಮ್ ಅಸ್ಮಾಕಂ ಜ್ಞಾನಮಾಸ್ತೇ ತದ್ವಯಂ ವಿದ್ಮಃ| ತಥಾಪಿ ಜ್ಞಾನಂ ಗರ್ವ್ವಂ ಜನಯತಿ ಕಿನ್ತು ಪ್ರೇಮತೋ ನಿಷ್ಠಾ ಜಾಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","ಅತಃ ಕಶ್ಚನ ಯದಿ ಮನ್ಯತೇ ಮಮ ಜ್ಞಾನಮಾಸ್ತ ಇತಿ ತರ್ಹಿ ತೇನ ಯಾದೃಶಂ ಜ್ಞಾನಂ ಚೇಷ್ಟಿತವ್ಯಂ ತಾದೃಶಂ ಕಿಮಪಿ ಜ್ಞಾನಮದ್ಯಾಪಿ ನ ಲಬ್ಧಂ| ");
INSERT INTO sankan_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","ಕಿನ್ತು ಯ ಈಶ್ವರೇ ಪ್ರೀಯತೇ ಸ ಈಶ್ವರೇಣಾಪಿ ಜ್ಞಾಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","ದೇವತಾಬಲಿಪ್ರಸಾದಭಕ್ಷಣೇ ವಯಮಿದಂ ವಿದ್ಮೋ ಯತ್ ಜಗನ್ಮಧ್ಯೇ ಕೋಽಪಿ ದೇವೋ ನ ವಿದ್ಯತೇ, ಏಕಶ್ಚೇಶ್ವರೋ ದ್ವಿತೀಯೋ ನಾಸ್ತೀತಿ| ");
INSERT INTO sankan_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","ಸ್ವರ್ಗೇ ಪೃಥಿವ್ಯಾಂ ವಾ ಯದ್ಯಪಿ ಕೇಷುಚಿದ್ ಈಶ್ವರ ಇತಿ ನಾಮಾರೋಪ್ಯತೇ ತಾದೃಶಾಶ್ಚ ಬಹವ ಈಶ್ವರಾ ಬಹವಶ್ಚ ಪ್ರಭವೋ ವಿದ್ಯನ್ತೇ ");
INSERT INTO sankan_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","ತಥಾಪ್ಯಸ್ಮಾಕಮದ್ವಿತೀಯ ಈಶ್ವರಃ ಸ ಪಿತಾ ಯಸ್ಮಾತ್ ಸರ್ವ್ವೇಷಾಂ ಯದರ್ಥಞ್ಚಾಸ್ಮಾಕಂ ಸೃಷ್ಟಿ ರ್ಜಾತಾ, ಅಸ್ಮಾಕಞ್ಚಾದ್ವಿತೀಯಃ ಪ್ರಭುಃ ಸ ಯೀಶುಃ ಖ್ರೀಷ್ಟೋ ಯೇನ ಸರ್ವ್ವವಸ್ತೂನಾಂ ಯೇನಾಸ್ಮಾಕಮಪಿ ಸೃಷ್ಟಿಃ ಕೃತಾ| ");
INSERT INTO sankan_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","ಅಧಿಕನ್ತು ಜ್ಞಾನಂ ಸರ್ವ್ವೇಷಾಂ ನಾಸ್ತಿ ಯತಃ ಕೇಚಿದದ್ಯಾಪಿ ದೇವತಾಂ ಸಮ್ಮನ್ಯ ದೇವಪ್ರಸಾದಮಿವ ತದ್ ಭಕ್ಷ್ಯಂ ಭುಞ್ಜತೇ ತೇನ ದುರ್ಬ್ಬಲತಯಾ ತೇಷಾಂ ಸ್ವಾನ್ತಾನಿ ಮಲೀಮಸಾನಿ ಭವನ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","ಕಿನ್ತು ಭಕ್ಷ್ಯದ್ರವ್ಯಾದ್ ವಯಮ್ ಈಶ್ವರೇಣ ಗ್ರಾಹ್ಯಾ ಭವಾಮಸ್ತನ್ನಹಿ ಯತೋ ಭುಙ್ಕ್ತ್ವಾ ವಯಮುತ್ಕೃಷ್ಟಾ ನ ಭವಾಮಸ್ತದ್ವದಭುಙ್ಕ್ತ್ವಾಪ್ಯಪಕೃಷ್ಟಾ ನ ಭವಾಮಃ| ");
INSERT INTO sankan_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","ಅತೋ ಯುಷ್ಮಾಕಂ ಯಾ ಕ್ಷಮತಾ ಸಾ ದುರ್ಬ್ಬಲಾನಾಮ್ ಉನ್ಮಾಥಸ್ವರೂಪಾ ಯನ್ನ ಭವೇತ್ ತದರ್ಥಂ ಸಾವಧಾನಾ ಭವತ| ");
INSERT INTO sankan_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","ಯತೋ ಜ್ಞಾನವಿಶಿಷ್ಟಸ್ತ್ವಂ ಯದಿ ದೇವಾಲಯೇ ಉಪವಿಷ್ಟಃ ಕೇನಾಪಿ ದೃಶ್ಯಸೇ ತರ್ಹಿ ತಸ್ಯ ದುರ್ಬ್ಬಲಸ್ಯ ಮನಸಿ ಕಿಂ ಪ್ರಸಾದಭಕ್ಷಣ ಉತ್ಸಾಹೋ ನ ಜನಿಷ್ಯತೇ? ");
INSERT INTO sankan_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","ತಥಾ ಸತಿ ಯಸ್ಯ ಕೃತೇ ಖ್ರೀಷ್ಟೋ ಮಮಾರ ತವ ಸ ದುರ್ಬ್ಬಲೋ ಭ್ರಾತಾ ತವ ಜ್ಞಾನಾತ್ ಕಿಂ ನ ವಿನಂಕ್ಷ್ಯತಿ? ");
INSERT INTO sankan_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","ಇತ್ಯನೇನ ಪ್ರಕಾರೇಣ ಭ್ರಾತೃಣಾಂ ವಿರುದ್ಧಮ್ ಅಪರಾಧ್ಯದ್ಭಿಸ್ತೇಷಾಂ ದುರ್ಬ್ಬಲಾನಿ ಮನಾಂಸಿ ವ್ಯಾಘಾತಯದ್ಭಿಶ್ಚ ಯುಷ್ಮಾಭಿಃ ಖ್ರೀಷ್ಟಸ್ಯ ವೈಪರೀತ್ಯೇನಾಪರಾಧ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","ಅತೋ ಹೇತೋಃ ಪಿಶಿತಾಶನಂ ಯದಿ ಮಮ ಭ್ರಾತು ರ್ವಿಘ್ನಸ್ವರೂಪಂ ಭವೇತ್ ತರ್ಹ್ಯಹಂ ಯತ್ ಸ್ವಭ್ರಾತು ರ್ವಿಘ್ನಜನಕೋ ನ ಭವೇಯಂ ತದರ್ಥಂ ಯಾವಜ್ಜೀವನಂ ಪಿಶಿತಂ ನ ಭೋಕ್ಷ್ಯೇ| ");
INSERT INTO sankan_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","ಅಹಂ ಕಿಮ್ ಏಕಃ ಪ್ರೇರಿತೋ ನಾಸ್ಮಿ? ಕಿಮಹಂ ಸ್ವತನ್ತ್ರೋ ನಾಸ್ಮಿ? ಅಸ್ಮಾಕಂ ಪ್ರಭು ರ್ಯೀಶುಃ ಖ್ರೀಷ್ಟಃ ಕಿಂ ಮಯಾ ನಾದರ್ಶಿ? ಯೂಯಮಪಿ ಕಿಂ ಪ್ರಭುನಾ ಮದೀಯಶ್ರಮಫಲಸ್ವರೂಪಾ ನ ಭವಥ? ");
INSERT INTO sankan_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","ಅನ್ಯಲೋಕಾನಾಂ ಕೃತೇ ಯದ್ಯಪ್ಯಹಂ ಪ್ರೇರಿತೋ ನ ಭವೇಯಂ ತಥಾಚ ಯುಷ್ಮತ್ಕೃತೇ ಪ್ರೇರಿತೋಽಸ್ಮಿ ಯತಃ ಪ್ರಭುನಾ ಮಮ ಪ್ರೇರಿತತ್ವಪದಸ್ಯ ಮುದ್ರಾಸ್ವರೂಪಾ ಯೂಯಮೇವಾಧ್ವೇ| ");
INSERT INTO sankan_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","ಯೇ ಲೋಕಾ ಮಯಿ ದೋಷಮಾರೋಪಯನ್ತಿ ತಾನ್ ಪ್ರತಿ ಮಮ ಪ್ರತ್ಯುತ್ತರಮೇತತ್| ");
INSERT INTO sankan_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","ಭೋಜನಪಾನಯೋಃ ಕಿಮಸ್ಮಾಕಂ ಕ್ಷಮತಾ ನಾಸ್ತಿ? ");
INSERT INTO sankan_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","ಅನ್ಯೇ ಪ್ರೇರಿತಾಃ ಪ್ರಭೋ ರ್ಭ್ರಾತರೌ ಕೈಫಾಶ್ಚ ಯತ್ ಕುರ್ವ್ವನ್ತಿ ತದ್ವತ್ ಕಾಞ್ಚಿತ್ ಧರ್ಮ್ಮಭಗಿನೀಂ ವ್ಯೂಹ್ಯ ತಯಾ ಸಾರ್ದ್ಧಂ ಪರ್ಯ್ಯಟಿತುಂ ವಯಂ ಕಿಂ ನ ಶಕ್ನುಮಃ? ");
INSERT INTO sankan_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","ಸಾಂಸಾರಿಕಶ್ರಮಸ್ಯ ಪರಿತ್ಯಾಗಾತ್ ಕಿಂ ಕೇವಲಮಹಂ ಬರ್ಣಬ್ಬಾಶ್ಚ ನಿವಾರಿತೌ? ");
INSERT INTO sankan_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","ನಿಜಧನವ್ಯಯೇನ ಕಃ ಸಂಗ್ರಾಮಂ ಕರೋತಿ? ಕೋ ವಾ ದ್ರಾಕ್ಷಾಕ್ಷೇತ್ರಂ ಕೃತ್ವಾ ತತ್ಫಲಾನಿ ನ ಭುಙ್ಕ್ತೇ? ಕೋ ವಾ ಪಶುವ್ರಜಂ ಪಾಲಯನ್ ತತ್ಪಯೋ ನ ಪಿವತಿ? ");
INSERT INTO sankan_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","ಕಿಮಹಂ ಕೇವಲಾಂ ಮಾನುಷಿಕಾಂ ವಾಚಂ ವದಾಮಿ? ವ್ಯವಸ್ಥಾಯಾಂ ಕಿಮೇತಾದೃಶಂ ವಚನಂ ನ ವಿದ್ಯತೇ? ");
INSERT INTO sankan_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","ಮೂಸಾವ್ಯವಸ್ಥಾಗ್ರನ್ಥೇ ಲಿಖಿತಮಾಸ್ತೇ, ತ್ವಂ ಶಸ್ಯಮರ್ದ್ದಕವೃಷಸ್ಯಾಸ್ಯಂ ನ ಭಂತ್ಸ್ಯಸೀತಿ| ಈಶ್ವರೇಣ ಬಲೀವರ್ದ್ದಾನಾಮೇವ ಚಿನ್ತಾ ಕಿಂ ಕ್ರಿಯತೇ? ");
INSERT INTO sankan_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","ಕಿಂ ವಾ ಸರ್ವ್ವಥಾಸ್ಮಾಕಂ ಕೃತೇ ತದ್ವಚನಂ ತೇನೋಕ್ತಂ? ಅಸ್ಮಾಕಮೇವ ಕೃತೇ ತಲ್ಲಿಖಿತಂ| ಯಃ ಕ್ಷೇತ್ರಂ ಕರ್ಷತಿ ತೇನ ಪ್ರತ್ಯಾಶಾಯುಕ್ತೇನ ಕರ್ಷ್ಟವ್ಯಂ, ಯಶ್ಚ ಶಸ್ಯಾನಿ ಮರ್ದ್ದಯತಿ ತೇನ ಲಾಭಪ್ರತ್ಯಾಶಾಯುಕ್ತೇನ ಮರ್ದ್ದಿತವ್ಯಂ| ");
INSERT INTO sankan_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","ಯುಷ್ಮತ್ಕೃತೇಽಸ್ಮಾಭಿಃ ಪಾರತ್ರಿಕಾಣಿ ಬೀಜಾನಿ ರೋಪಿತಾನಿ, ಅತೋ ಯುಷ್ಮಾಕಮೈಹಿಕಫಲಾನಾಂ ವಯಮ್ ಅಂಶಿನೋ ಭವಿಷ್ಯಾಮಃ ಕಿಮೇತತ್ ಮಹತ್ ಕರ್ಮ್ಮ? ");
INSERT INTO sankan_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","ಯುಷ್ಮಾಸು ಯೋಽಧಿಕಾರಸ್ತಸ್ಯ ಭಾಗಿನೋ ಯದ್ಯನ್ಯೇ ಭವೇಯುಸ್ತರ್ಹ್ಯಸ್ಮಾಭಿಸ್ತತೋಽಧಿಕಂ ಕಿಂ ತಸ್ಯ ಭಾಗಿಭಿ ರ್ನ ಭವಿತವ್ಯಂ? ಅಧಿಕನ್ತು ವಯಂ ತೇನಾಧಿಕಾರೇಣ ನ ವ್ಯವಹೃತವನ್ತಃ ಕಿನ್ತು ಖ್ರೀಷ್ಟೀಯಸುಸಂವಾದಸ್ಯ ಕೋಽಪಿ ವ್ಯಾಘಾತೋಽಸ್ಮಾಭಿರ್ಯನ್ನ ಜಾಯೇತ ತದರ್ಥಂ ಸರ್ವ್ವಂ ಸಹಾಮಹೇ| ");
INSERT INTO sankan_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","ಅಪರಂ ಯೇ ಪವಿತ್ರವಸ್ತೂನಾಂ ಪರಿಚರ್ಯ್ಯಾಂ ಕುರ್ವ್ವನ್ತಿ ತೇ ಪವಿತ್ರವಸ್ತುತೋ ಭಕ್ಷ್ಯಾಣಿ ಲಭನ್ತೇ, ಯೇ ಚ ವೇದ್ಯಾಃ ಪರಿಚರ್ಯ್ಯಾಂ ಕುರ್ವ್ವನ್ತಿ ತೇ ವೇದಿಸ್ಥವಸ್ತೂನಾಮ್ ಅಂಶಿನೋ ಭವನ್ತ್ಯೇತದ್ ಯೂಯಂ ಕಿಂ ನ ವಿದ? ");
INSERT INTO sankan_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","ತದ್ವದ್ ಯೇ ಸುಸಂವಾದಂ ಘೋಷಯನ್ತಿ ತೈಃ ಸುಸಂವಾದೇನ ಜೀವಿತವ್ಯಮಿತಿ ಪ್ರಭುನಾದಿಷ್ಟಂ| ");
INSERT INTO sankan_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","ಅಹಮೇತೇಷಾಂ ಸರ್ವ್ವೇಷಾಂ ಕಿಮಪಿ ನಾಶ್ರಿತವಾನ್ ಮಾಂ ಪ್ರತಿ ತದನುಸಾರಾತ್ ಆಚರಿತವ್ಯಮಿತ್ಯಾಶಯೇನಾಪಿ ಪತ್ರಮಿದಂ ಮಯಾ ನ ಲಿಖ್ಯತೇ ಯತಃ ಕೇನಾಪಿ ಜನೇನ ಮಮ ಯಶಸೋ ಮುಧಾಕರಣಾತ್ ಮಮ ಮರಣಂ ವರಂ| ");
INSERT INTO sankan_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","ಸುಸಂವಾದಘೇಷಣಾತ್ ಮಮ ಯಶೋ ನ ಜಾಯತೇ ಯತಸ್ತದ್ಘೋಷಣಂ ಮಮಾವಶ್ಯಕಂ ಯದ್ಯಹಂ ಸುಸಂವಾದಂ ನ ಘೋಷಯೇಯಂ ತರ್ಹಿ ಮಾಂ ಧಿಕ್| ");
INSERT INTO sankan_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","ಇಚ್ಛುಕೇನ ತತ್ ಕುರ್ವ್ವತಾ ಮಯಾ ಫಲಂ ಲಪ್ಸ್ಯತೇ ಕಿನ್ತ್ವನಿಚ್ಛುಕೇಽಪಿ ಮಯಿ ತತ್ಕರ್ಮ್ಮಣೋ ಭಾರೋಽರ್ಪಿತೋಽಸ್ತಿ| ");
INSERT INTO sankan_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","ಏತೇನ ಮಯಾ ಲಭ್ಯಂ ಫಲಂ ಕಿಂ? ಸುಸಂವಾದೇನ ಮಮ ಯೋಽಧಿಕಾರ ಆಸ್ತೇ ತಂ ಯದಭದ್ರಭಾವೇನ ನಾಚರೇಯಂ ತದರ್ಥಂ ಸುಸಂವಾದಘೋಷಣಸಮಯೇ ತಸ್ಯ ಖ್ರೀಷ್ಟೀಯಸುಸಂವಾದಸ್ಯ ನಿರ್ವ್ಯಯೀಕರಣಮೇವ ಮಮ ಫಲಂ| ");
INSERT INTO sankan_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","ಸರ್ವ್ವೇಷಾಮ್ ಅನಾಯತ್ತೋಽಹಂ ಯದ್ ಭೂರಿಶೋ ಲೋಕಾನ್ ಪ್ರತಿಪದ್ಯೇ ತದರ್ಥಂ ಸರ್ವ್ವೇಷಾಂ ದಾಸತ್ವಮಙ್ಗೀಕೃತವಾನ್| ");
INSERT INTO sankan_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","ಯಿಹೂದೀಯಾನ್ ಯತ್ ಪ್ರತಿಪದ್ಯೇ ತದರ್ಥಂ ಯಿಹೂದೀಯಾನಾಂ ಕೃತೇ ಯಿಹೂದೀಯಇವಾಭವಂ| ಯೇ ಚ ವ್ಯವಸ್ಥಾಯತ್ತಾಸ್ತಾನ್ ಯತ್ ಪ್ರತಿಪದ್ಯೇ ತದರ್ಥಂ ವ್ಯವಸ್ಥಾನಾಯತ್ತೋ ಯೋಽಹಂ ಸೋಽಹಂ ವ್ಯವಸ್ಥಾಯತ್ತಾನಾಂ ಕೃತೇ ವ್ಯವಸ್ಥಾಯತ್ತಇವಾಭವಂ| ");
INSERT INTO sankan_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","ಯೇ ಚಾಲಬ್ಧವ್ಯವಸ್ಥಾಸ್ತಾನ್ ಯತ್ ಪ್ರತಿಪದ್ಯೇ ತದರ್ಥಮ್ ಈಶ್ವರಸ್ಯ ಸಾಕ್ಷಾದ್ ಅಲಬ್ಧವ್ಯವಸ್ಥೋ ನ ಭೂತ್ವಾ ಖ್ರೀಷ್ಟೇನ ಲಬ್ಧವ್ಯವಸ್ಥೋ ಯೋಽಹಂ ಸೋಽಹಮ್ ಅಲಬ್ಧವ್ಯವಸ್ಥಾನಾಂ ಕೃತೇಽಲಬ್ಧವ್ಯವಸ್ಥ ಇವಾಭವಂ| ");
INSERT INTO sankan_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","ದುರ್ಬ್ಬಲಾನ್ ಯತ್ ಪ್ರತಿಪದ್ಯೇ ತದರ್ಥಮಹಂ ದುರ್ಬ್ಬಲಾನಾಂ ಕೃತೇ ದುರ್ಬ್ಬಲಇವಾಭವಂ| ಇತ್ಥಂ ಕೇನಾಪಿ ಪ್ರಕಾರೇಣ ಕತಿಪಯಾ ಲೋಕಾ ಯನ್ಮಯಾ ಪರಿತ್ರಾಣಂ ಪ್ರಾಪ್ನುಯುಸ್ತದರ್ಥಂ ಯೋ ಯಾದೃಶ ಆಸೀತ್ ತಸ್ಯ ಕೃತೇ ಽಹಂ ತಾದೃಶಇವಾಭವಂ| ");
INSERT INTO sankan_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","ಇದೃಶ ಆಚಾರಃ ಸುಸಂವಾದಾರ್ಥಂ ಮಯಾ ಕ್ರಿಯತೇ ಯತೋಽಹಂ ತಸ್ಯ ಫಲಾನಾಂ ಸಹಭಾಗೀ ಭವಿತುಮಿಚ್ಛಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","ಪಣ್ಯಲಾಭಾರ್ಥಂ ಯೇ ಧಾವನ್ತಿ ಧಾವತಾಂ ತೇಷಾಂ ಸರ್ವ್ವೇಷಾಂ ಕೇವಲ ಏಕಃ ಪಣ್ಯಂ ಲಭತೇ ಯುಷ್ಮಾಭಿಃ ಕಿಮೇತನ್ನ ಜ್ಞಾಯತೇ? ಅತೋ ಯೂಯಂ ಯಥಾ ಪಣ್ಯಂ ಲಪ್ಸ್ಯಧ್ವೇ ತಥೈವ ಧಾವತ| ");
INSERT INTO sankan_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","ಮಲ್ಲಾ ಅಪಿ ಸರ್ವ್ವಭೋಗೇ ಪರಿಮಿತಭೋಗಿನೋ ಭವನ್ತಿ ತೇ ತು ಮ್ಲಾನಾಂ ಸ್ರಜಂ ಲಿಪ್ಸನ್ತೇ ಕಿನ್ತು ವಯಮ್ ಅಮ್ಲಾನಾಂ ಲಿಪ್ಸಾಮಹೇ| ");
INSERT INTO sankan_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","ತಸ್ಮಾದ್ ಅಹಮಪಿ ಧಾವಾಮಿ ಕಿನ್ತು ಲಕ್ಷ್ಯಮನುದ್ದಿಶ್ಯ ಧಾವಾಮಿ ತನ್ನಹಿ| ಅಹಂ ಮಲ್ಲಇವ ಯುಧ್ಯಾಮಿ ಚ ಕಿನ್ತು ಛಾಯಾಮಾಘಾತಯನ್ನಿವ ಯುಧ್ಯಾಮಿ ತನ್ನಹಿ| ");
INSERT INTO sankan_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","ಇತರಾನ್ ಪ್ರತಿ ಸುಸಂವಾದಂ ಘೋಷಯಿತ್ವಾಹಂ ಯತ್ ಸ್ವಯಮಗ್ರಾಹ್ಯೋ ನ ಭವಾಮಿ ತದರ್ಥಂ ದೇಹಮ್ ಆಹನ್ಮಿ ವಶೀಕುರ್ವ್ವೇ ಚ| ");
INSERT INTO sankan_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","ಹೇ ಭ್ರಾತರಃ, ಅಸ್ಮತ್ಪಿತೃಪುರುಷಾನಧಿ ಯೂಯಂ ಯದಜ್ಞಾತಾ ನ ತಿಷ್ಠತೇತಿ ಮಮ ವಾಞ್ಛಾ, ತೇ ಸರ್ವ್ವೇ ಮೇಘಾಧಃಸ್ಥಿತಾ ಬಭೂವುಃ ಸರ್ವ್ವೇ ಸಮುದ್ರಮಧ್ಯೇನ ವವ್ರಜುಃ, ");
INSERT INTO sankan_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","ಸರ್ವ್ವೇ ಮೂಸಾಮುದ್ದಿಶ್ಯ ಮೇಘಸಮುದ್ರಯೋ ರ್ಮಜ್ಜಿತಾ ಬಭೂವುಃ ");
INSERT INTO sankan_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","ಸರ್ವ್ವ ಏಕಮ್ ಆತ್ಮಿಕಂ ಭಕ್ಷ್ಯಂ ಬುಭುಜಿರ ಏಕಮ್ ಆತ್ಮಿಕಂ ಪೇಯಂ ಪಪುಶ್ಚ ");
INSERT INTO sankan_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","ಯತಸ್ತೇಽನುಚರತ ಆತ್ಮಿಕಾದ್ ಅಚಲಾತ್ ಲಬ್ಧಂ ತೋಯಂ ಪಪುಃ ಸೋಽಚಲಃ ಖ್ರೀಷ್ಟಏವ| ");
INSERT INTO sankan_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","ತಥಾ ಸತ್ಯಪಿ ತೇಷಾಂ ಮಧ್ಯೇಽಧಿಕೇಷು ಲೋಕೇಷ್ವೀಶ್ವರೋ ನ ಸನ್ತುತೋಷೇತಿ ಹೇತೋಸ್ತೇ ಪ್ರನ್ತರೇ ನಿಪಾತಿತಾಃ| ");
INSERT INTO sankan_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","ಏತಸ್ಮಿನ್ ತೇ ಽಸ್ಮಾಕಂ ನಿದರ್ಶನಸ್ವರೂಪಾ ಬಭೂವುಃ; ಅತಸ್ತೇ ಯಥಾ ಕುತ್ಸಿತಾಭಿಲಾಷಿಣೋ ಬಭೂವುರಸ್ಮಾಭಿಸ್ತಥಾ ಕುತ್ಸಿತಾಭಿಲಾಷಿಭಿ ರ್ನ ಭವಿತವ್ಯಂ| ");
INSERT INTO sankan_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","ಲಿಖಿತಮಾಸ್ತೇ, ಲೋಕಾ ಭೋಕ್ತುಂ ಪಾತುಞ್ಚೋಪವಿವಿಶುಸ್ತತಃ ಕ್ರೀಡಿತುಮುತ್ಥಿತಾ ಇತಯನೇನ ಪ್ರಕಾರೇಣ ತೇಷಾಂ ಕೈಶ್ಚಿದ್ ಯದ್ವದ್ ದೇವಪೂಜಾ ಕೃತಾ ಯುಷ್ಮಾಭಿಸ್ತದ್ವತ್ ನ ಕ್ರಿಯತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","ಅಪರಂ ತೇಷಾಂ ಕೈಶ್ಚಿದ್ ಯದ್ವದ್ ವ್ಯಭಿಚಾರಃ ಕೃತಸ್ತೇನ ಚೈಕಸ್ಮಿನ್ ದಿನೇ ತ್ರಯೋವಿಂಶತಿಸಹಸ್ರಾಣಿ ಲೋಕಾ ನಿಪಾತಿತಾಸ್ತದ್ವದ್ ಅಸ್ಮಾಭಿ ರ್ವ್ಯಭಿಚಾರೋ ನ ಕರ್ತ್ತವ್ಯಃ| ");
INSERT INTO sankan_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","ತೇಷಾಂ ಕೇಚಿದ್ ಯದ್ವತ್ ಖ್ರೀಷ್ಟಂ ಪರೀಕ್ಷಿತವನ್ತಸ್ತಸ್ಮಾದ್ ಭುಜಙ್ಗೈ ರ್ನಷ್ಟಾಶ್ಚ ತದ್ವದ್ ಅಸ್ಮಾಭಿಃ ಖ್ರೀಷ್ಟೋ ನ ಪರೀಕ್ಷಿತವ್ಯಃ| ");
INSERT INTO sankan_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","ತೇಷಾಂ ಕೇಚಿದ್ ಯಥಾ ವಾಕ್ಕಲಹಂ ಕೃತವನ್ತಸ್ತತ್ಕಾರಣಾತ್ ಹನ್ತ್ರಾ ವಿನಾಶಿತಾಶ್ಚ ಯುಷ್ಮಾಭಿಸ್ತದ್ವದ್ ವಾಕ್ಕಲಹೋ ನ ಕ್ರಿಯತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","ತಾನ್ ಪ್ರತಿ ಯಾನ್ಯೇತಾನಿ ಜಘಟಿರೇ ತಾನ್ಯಸ್ಮಾಕಂ ನಿದರ್ಶನಾನಿ ಜಗತಃ ಶೇಷಯುಗೇ ವರ್ತ್ತಮಾನಾನಾಮ್ ಅಸ್ಮಾಕಂ ಶಿಕ್ಷಾರ್ಥಂ ಲಿಖಿತಾನಿ ಚ ಬಭೂವುಃ| ");
INSERT INTO sankan_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","ಅತಏವ ಯಃ ಕಶ್ಚಿದ್ ಸುಸ್ಥಿರಂಮನ್ಯಃ ಸ ಯನ್ನ ಪತೇತ್ ತತ್ರ ಸಾವಧಾನೋ ಭವತು| ");
INSERT INTO sankan_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","ಮಾನುಷಿಕಪರೀಕ್ಷಾತಿರಿಕ್ತಾ ಕಾಪಿ ಪರೀಕ್ಷಾ ಯುಷ್ಮಾನ್ ನಾಕ್ರಾಮತ್, ಈಶ್ವರಶ್ಚ ವಿಶ್ವಾಸ್ಯಃ ಸೋಽತಿಶಕ್ತ್ಯಾಂ ಪರೀಕ್ಷಾಯಾಂ ಪತನಾತ್ ಯುಷ್ಮಾನ್ ರಕ್ಷಿಷ್ಯತಿ, ಪರೀಕ್ಷಾ ಚ ಯದ್ ಯುಷ್ಮಾಭಿಃ ಸೋಢುಂ ಶಕ್ಯತೇ ತದರ್ಥಂ ತಯಾ ಸಹ ನಿಸ್ತಾರಸ್ಯ ಪನ್ಥಾನಂ ನಿರೂಪಯಿಷ್ಯತಿ| ");
INSERT INTO sankan_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","ಹೇ ಪ್ರಿಯಭ್ರಾತರಃ, ದೇವಪೂಜಾತೋ ದೂರಮ್ ಅಪಸರತ| ");
INSERT INTO sankan_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","ಅಹಂ ಯುಷ್ಮಾನ್ ವಿಜ್ಞಾನ್ ಮತ್ವಾ ಪ್ರಭಾಷೇ ಮಯಾ ಯತ್ ಕಥ್ಯತೇ ತದ್ ಯುಷ್ಮಾಭಿ ರ್ವಿವಿಚ್ಯತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","ಯದ್ ಧನ್ಯವಾದಪಾತ್ರಮ್ ಅಸ್ಮಾಭಿ ರ್ಧನ್ಯಂ ಗದ್ಯತೇ ತತ್ ಕಿಂ ಖ್ರೀಷ್ಟಸ್ಯ ಶೋಣಿತಸ್ಯ ಸಹಭಾಗಿತ್ವಂ ನಹಿ? ಯಶ್ಚ ಪೂಪೋಽಸ್ಮಾಭಿ ರ್ಭಜ್ಯತೇ ಸ ಕಿಂ ಖ್ರೀಷ್ಟಸ್ಯ ವಪುಷಃ ಸಹಭಾಗಿತ್ವಂ ನಹಿ? ");
INSERT INTO sankan_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","ವಯಂ ಬಹವಃ ಸನ್ತೋಽಪ್ಯೇಕಪೂಪಸ್ವರೂಪಾ ಏಕವಪುಃಸ್ವರೂಪಾಶ್ಚ ಭವಾಮಃ, ಯತೋ ವಯಂ ಸರ್ವ್ವ ಏಕಪೂಪಸ್ಯ ಸಹಭಾಗಿನಃ| ");
INSERT INTO sankan_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","ಯೂಯಂ ಶಾರೀರಿಕಮ್ ಇಸ್ರಾಯೇಲೀಯವಂಶಂ ನಿರೀಕ್ಷಧ್ವಂ| ಯೇ ಬಲೀನಾಂ ಮಾಂಸಾನಿ ಭುಞ್ಜತೇ ತೇ ಕಿಂ ಯಜ್ಞವೇದ್ಯಾಃ ಸಹಭಾಗಿನೋ ನ ಭವನ್ತಿ? ");
INSERT INTO sankan_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","ಇತ್ಯನೇನ ಮಯಾ ಕಿಂ ಕಥ್ಯತೇ? ದೇವತಾ ವಾಸ್ತವಿಕೀ ದೇವತಾಯೈ ಬಲಿದಾನಂ ವಾ ವಾಸ್ತವಿಕಂ ಕಿಂ ಭವೇತ್? ");
INSERT INTO sankan_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","ತನ್ನಹಿ ಕಿನ್ತು ಭಿನ್ನಜಾತಿಭಿ ರ್ಯೇ ಬಲಯೋ ದೀಯನ್ತೇ ತ ಈಶ್ವರಾಯ ತನ್ನಹಿ ಭೂತೇಭ್ಯಏವ ದೀಯನ್ತೇ ತಸ್ಮಾದ್ ಯೂಯಂ ಯದ್ ಭೂತಾನಾಂ ಸಹಭಾಗಿನೋ ಭವಥೇತ್ಯಹಂ ನಾಭಿಲಷಾಮಿ| ");
INSERT INTO sankan_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","ಪ್ರಭೋಃ ಕಂಸೇನ ಭೂತಾನಾಮಪಿ ಕಂಸೇನ ಪಾನಂ ಯುಷ್ಮಾಭಿರಸಾಧ್ಯಂ; ಯೂಯಂ ಪ್ರಭೋ ರ್ಭೋಜ್ಯಸ್ಯ ಭೂತಾನಾಮಪಿ ಭೋಜ್ಯಸ್ಯ ಸಹಭಾಗಿನೋ ಭವಿತುಂ ನ ಶಕ್ನುಥ| ");
INSERT INTO sankan_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","ವಯಂ ಕಿಂ ಪ್ರಭುಂ ಸ್ಪರ್ದ್ಧಿಷ್ಯಾಮಹೇ? ವಯಂ ಕಿಂ ತಸ್ಮಾದ್ ಬಲವನ್ತಃ? ");
INSERT INTO sankan_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","ಮಾಂ ಪ್ರತಿ ಸರ್ವ್ವಂ ಕರ್ಮ್ಮಾಪ್ರತಿಷಿದ್ಧಂ ಕಿನ್ತು ನ ಸರ್ವ್ವಂ ಹಿತಜನಕಂ ಸರ್ವ್ವಮ್ ಅಪ್ರತಿಷಿದ್ಧಂ ಕಿನ್ತು ನ ಸರ್ವ್ವಂ ನಿಷ್ಠಾಜನಕಂ| ");
INSERT INTO sankan_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","ಆತ್ಮಹಿತಃ ಕೇನಾಪಿ ನ ಚೇಷ್ಟಿತವ್ಯಃ ಕಿನ್ತು ಸರ್ವ್ವೈಃ ಪರಹಿತಶ್ಚೇಷ್ಟಿತವ್ಯಃ| ");
INSERT INTO sankan_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","ಆಪಣೇ ಯತ್ ಕ್ರಯ್ಯಂ ತದ್ ಯುಷ್ಮಾಭಿಃ ಸಂವೇದಸ್ಯಾರ್ಥಂ ಕಿಮಪಿ ನ ಪೃಷ್ಟ್ವಾ ಭುಜ್ಯತಾಂ ");
INSERT INTO sankan_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","ಯತಃ ಪೃಥಿವೀ ತನ್ಮಧ್ಯಸ್ಥಞ್ಚ ಸರ್ವ್ವಂ ಪರಮೇಶ್ವರಸ್ಯ| ");
INSERT INTO sankan_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","ಅಪರಮ್ ಅವಿಶ್ವಾಸಿಲೋಕಾನಾಂ ಕೇನಚಿತ್ ನಿಮನ್ತ್ರಿತಾ ಯೂಯಂ ಯದಿ ತತ್ರ ಜಿಗಮಿಷಥ ತರ್ಹಿ ತೇನ ಯದ್ ಯದ್ ಉಪಸ್ಥಾಪ್ಯತೇ ತದ್ ಯುಷ್ಮಾಭಿಃ ಸಂವೇದಸ್ಯಾರ್ಥಂ ಕಿಮಪಿ ನ ಪೃಷ್ಟ್ವಾ ಭುಜ್ಯತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","ಕಿನ್ತು ತತ್ರ ಯದಿ ಕಶ್ಚಿದ್ ಯುಷ್ಮಾನ್ ವದೇತ್ ಭಕ್ಷ್ಯಮೇತದ್ ದೇವತಾಯಾಃ ಪ್ರಸಾದ ಇತಿ ತರ್ಹಿ ತಸ್ಯ ಜ್ಞಾಪಯಿತುರನುರೋಧಾತ್ ಸಂವೇದಸ್ಯಾರ್ಥಞ್ಚ ತದ್ ಯುಷ್ಮಾಭಿ ರ್ನ ಭೋಕ್ತವ್ಯಂ| ಪೃಥಿವೀ ತನ್ಮಧ್ಯಸ್ಥಞ್ಚ ಸರ್ವ್ವಂ ಪರಮೇಶ್ವರಸ್ಯ, ");
INSERT INTO sankan_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","ಸತ್ಯಮೇತತ್, ಕಿನ್ತು ಮಯಾ ಯಃ ಸಂವೇದೋ ನಿರ್ದ್ದಿಶ್ಯತೇ ಸ ತವ ನಹಿ ಪರಸ್ಯೈವ| ");
INSERT INTO sankan_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","ಅನುಗ್ರಹಪಾತ್ರೇಣ ಮಯಾ ಧನ್ಯವಾದಂ ಕೃತ್ವಾ ಯದ್ ಭುಜ್ಯತೇ ತತ್ಕಾರಣಾದ್ ಅಹಂ ಕುತೋ ನಿನ್ದಿಷ್ಯೇ? ");
INSERT INTO sankan_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","ತಸ್ಮಾದ್ ಭೋಜನಂ ಪಾನಮ್ ಅನ್ಯದ್ವಾ ಕರ್ಮ್ಮ ಕುರ್ವ್ವದ್ಭಿ ರ್ಯುಷ್ಮಾಭಿಃ ಸರ್ವ್ವಮೇವೇಶ್ವರಸ್ಯ ಮಹಿಮ್ನಃ ಪ್ರಕಾಶಾರ್ಥಂ ಕ್ರಿಯತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","ಯಿಹೂದೀಯಾನಾಂ ಭಿನ್ನಜಾತೀಯಾನಾಮ್ ಈಶ್ವರಸ್ಯ ಸಮಾಜಸ್ಯ ವಾ ವಿಘ್ನಜನಕೈ ರ್ಯುಷ್ಮಾಭಿ ರ್ನ ಭವಿತವ್ಯಂ| ");
INSERT INTO sankan_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","ಅಹಮಪ್ಯಾತ್ಮಹಿತಮ್ ಅಚೇಷ್ಟಮಾನೋ ಬಹೂನಾಂ ಪರಿತ್ರಾಣಾರ್ಥಂ ತೇಷಾಂ ಹಿತಂ ಚೇಷ್ಟಮಾನಃ ಸರ್ವ್ವವಿಷಯೇ ಸರ್ವ್ವೇಷಾಂ ತುಷ್ಟಿಕರೋ ಭವಾಮೀತ್ಯನೇನಾಹಂ ಯದ್ವತ್ ಖ್ರೀಷ್ಟಸ್ಯಾನುಗಾಮೀ ತದ್ವದ್ ಯೂಯಂ ಮಮಾನುಗಾಮಿನೋ ಭವತ| ");
INSERT INTO sankan_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","ಹೇ ಭ್ರಾತರಃ, ಯೂಯಂ ಸರ್ವ್ವಸ್ಮಿನ್ ಕಾರ್ಯ್ಯೇ ಮಾಂ ಸ್ಮರಥ ಮಯಾ ಚ ಯಾದೃಗುಪದಿಷ್ಟಾಸ್ತಾದೃಗಾಚರಥೈತತ್ಕಾರಣಾತ್ ಮಯಾ ಪ್ರಶಂಸನೀಯಾ ಆಧ್ಬೇ| ");
INSERT INTO sankan_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","ತಥಾಪಿ ಮಮೈಷಾ ವಾಞ್ಛಾ ಯದ್ ಯೂಯಮಿದಮ್ ಅವಗತಾ ಭವಥ, ");
INSERT INTO sankan_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","ಏಕೈಕಸ್ಯ ಪುರುಷಸ್ಯೋತ್ತಮಾಙ್ಗಸ್ವರೂಪಃ ಖ್ರೀಷ್ಟಃ, ಯೋಷಿತಶ್ಚೋತ್ತಮಾಙ್ಗಸ್ವರೂಪಃ ಪುಮಾನ್, ಖ್ರೀಷ್ಟಸ್ಯ ಚೋತ್ತಮಾಙ್ಗಸ್ವರೂಪ ಈಶ್ವರಃ| ");
INSERT INTO sankan_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","ಅಪರಮ್ ಆಚ್ಛಾದಿತೋತ್ತಮಾಙ್ಗೇನ ಯೇನ ಪುಂಸಾ ಪ್ರಾರ್ಥನಾ ಕ್ರಿಯತ ಈಶ್ವರೀಯವಾಣೀ ಕಥ್ಯತೇ ವಾ ತೇನ ಸ್ವೀಯೋತ್ತಮಾಙ್ಗಮ್ ಅವಜ್ಞಾಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","ಅನಾಚ್ಛಾದಿತೋತ್ತಮಾಙ್ಗಯಾ ಯಯಾ ಯೋಷಿತಾ ಚ ಪ್ರಾರ್ಥನಾ ಕ್ರಿಯತ ಈಶ್ವರೀಯವಾಣೀ ಕಥ್ಯತೇ ವಾ ತಯಾಪಿ ಸ್ವೀಯೋತ್ತಮಾಙ್ಗಮ್ ಅವಜ್ಞಾಯತೇ ಯತಃ ಸಾ ಮುಣ್ಡಿತಶಿರಃಸದೃಶಾ| ");
INSERT INTO sankan_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","ಅನಾಚ್ಛಾದಿತಮಸ್ತಕಾ ಯಾ ಯೋಷಿತ್ ತಸ್ಯಾಃ ಶಿರಃ ಮುಣ್ಡನೀಯಮೇವ ಕಿನ್ತು ಯೋಷಿತಃ ಕೇಶಚ್ಛೇದನಂ ಶಿರೋಮುಣ್ಡನಂ ವಾ ಯದಿ ಲಜ್ಜಾಜನಕಂ ಭವೇತ್ ತರ್ಹಿ ತಯಾ ಸ್ವಶಿರ ಆಚ್ಛಾದ್ಯತಾಂ| ");
INSERT INTO sankan_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","ಪುಮಾನ್ ಈಶ್ವರಸ್ಯ ಪ್ರತಿಮೂರ್ತ್ತಿಃ ಪ್ರತಿತೇಜಃಸ್ವರೂಪಶ್ಚ ತಸ್ಮಾತ್ ತೇನ ಶಿರೋ ನಾಚ್ಛಾದನೀಯಂ ಕಿನ್ತು ಸೀಮನ್ತಿನೀ ಪುಂಸಃ ಪ್ರತಿಬಿಮ್ಬಸ್ವರೂಪಾ| ");
INSERT INTO sankan_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","ಯತೋ ಯೋಷಾತಃ ಪುಮಾನ್ ನೋದಪಾದಿ ಕಿನ್ತು ಪುಂಸೋ ಯೋಷಿದ್ ಉದಪಾದಿ| ");
INSERT INTO sankan_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","ಅಧಿಕನ್ತು ಯೋಷಿತಃ ಕೃತೇ ಪುಂಸಃ ಸೃಷ್ಟಿ ರ್ನ ಬಭೂವ ಕಿನ್ತು ಪುಂಸಃ ಕೃತೇ ಯೋಷಿತಃ ಸೃಷ್ಟಿ ರ್ಬಭೂವ| ");
INSERT INTO sankan_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","ಇತಿ ಹೇತೋ ರ್ದೂತಾನಾಮ್ ಆದರಾದ್ ಯೋಷಿತಾ ಶಿರಸ್ಯಧೀನತಾಸೂಚಕಮ್ ಆವರಣಂ ಧರ್ತ್ತವ್ಯಂ| ");
INSERT INTO sankan_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","ತಥಾಪಿ ಪ್ರಭೋ ರ್ವಿಧಿನಾ ಪುಮಾಂಸಂ ವಿನಾ ಯೋಷಿನ್ನ ಜಾಯತೇ ಯೋಷಿತಞ್ಚ ವಿನಾ ಪುಮಾನ್ ನ ಜಾಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","ಯತೋ ಯಥಾ ಪುಂಸೋ ಯೋಷಿದ್ ಉದಪಾದಿ ತಥಾ ಯೋಷಿತಃ ಪುಮಾನ್ ಜಾಯತೇ, ಸರ್ವ್ವವಸ್ತೂನಿ ಚೇಶ್ವರಾದ್ ಉತ್ಪದ್ಯನ್ತೇ| ");
INSERT INTO sankan_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","ಯುಷ್ಮಾಭಿರೇವೈತದ್ ವಿವಿಚ್ಯತಾಂ, ಅನಾವೃತಯಾ ಯೋಷಿತಾ ಪ್ರಾರ್ಥನಂ ಕಿಂ ಸುದೃಶ್ಯಂ ಭವೇತ್? ");
INSERT INTO sankan_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","ಪುರುಷಸ್ಯ ದೀರ್ಘಕೇಶತ್ವಂ ತಸ್ಯ ಲಜ್ಜಾಜನಕಂ, ಕಿನ್ತು ಯೋಷಿತೋ ದೀರ್ಘಕೇಶತ್ವಂ ತಸ್ಯಾ ಗೌರವಜನಕಂ ");
INSERT INTO sankan_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","ಯತ ಆಚ್ಛಾದನಾಯ ತಸ್ಯೈ ಕೇಶಾ ದತ್ತಾ ಇತಿ ಕಿಂ ಯುಷ್ಮಾಭಿಃ ಸ್ವಭಾವತೋ ನ ಶಿಕ್ಷ್ಯತೇ? ");
INSERT INTO sankan_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","ಅತ್ರ ಯದಿ ಕಶ್ಚಿದ್ ವಿವದಿತುಮ್ ಇಚ್ಛೇತ್ ತರ್ಹ್ಯಸ್ಮಾಕಮ್ ಈಶ್ವರೀಯಸಮಿತೀನಾಞ್ಚ ತಾದೃಶೀ ರೀತಿ ರ್ನ ವಿದ್ಯತೇ| ");
INSERT INTO sankan_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","ಯುಷ್ಮಾಭಿ ರ್ನ ಭದ್ರಾಯ ಕಿನ್ತು ಕುತ್ಸಿತಾಯ ಸಮಾಗಮ್ಯತೇ ತಸ್ಮಾದ್ ಏತಾನಿ ಭಾಷಮಾಣೇನ ಮಯಾ ಯೂಯಂ ನ ಪ್ರಶಂಸನೀಯಾಃ| ");
INSERT INTO sankan_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","ಪ್ರಥಮತಃ ಸಮಿತೌ ಸಮಾಗತಾನಾಂ ಯುಷ್ಮಾಕಂ ಮಧ್ಯೇ ಭೇದಾಃ ಸನ್ತೀತಿ ವಾರ್ತ್ತಾ ಮಯಾ ಶ್ರೂಯತೇ ತನ್ಮಧ್ಯೇ ಕಿಞ್ಚಿತ್ ಸತ್ಯಂ ಮನ್ಯತೇ ಚ| ");
INSERT INTO sankan_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","ಯತೋ ಹೇತೋ ರ್ಯುಷ್ಮನ್ಮಧ್ಯೇ ಯೇ ಪರೀಕ್ಷಿತಾಸ್ತೇ ಯತ್ ಪ್ರಕಾಶ್ಯನ್ತೇ ತದರ್ಥಂ ಭೇದೈ ರ್ಭವಿತವ್ಯಮೇವ| ");
INSERT INTO sankan_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","ಏಕತ್ರ ಸಮಾಗತೈ ರ್ಯುಷ್ಮಾಭಿಃ ಪ್ರಭಾವಂ ಭೇाಜ್ಯಂ ಭುಜ್ಯತ ಇತಿ ನಹಿ; ");
INSERT INTO sankan_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","ಯತೋ ಭೋಜನಕಾಲೇ ಯುಷ್ಮಾಕಮೇಕೈಕೇನ ಸ್ವಕೀಯಂ ಭಕ್ಷ್ಯಂ ತೂರ್ಣಂ ಗ್ರಸ್ಯತೇ ತಸ್ಮಾದ್ ಏಕೋ ಜನೋ ಬುಭುಕ್ಷಿತಸ್ತಿಷ್ಠತಿ, ಅನ್ಯಶ್ಚ ಪರಿತೃಪ್ತೋ ಭವತಿ| ");
INSERT INTO sanka