﻿USE sofia;
DROP TABLE IF EXISTS sofia.sanitr_vpl;
CREATE TABLE sanitr_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sanitr_vpl WRITE;
INSERT INTO sanitr_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ibrAhImaH santAno dAyUd tasya santAno yIshukhrIShTastasya pUrvvapuruShavaMshashreNI| ");
INSERT INTO sanitr_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ibrAhImaH putra ishAk tasya putro yAkUb tasya putro yihUdAstasya bhrAtarashcha| ");
INSERT INTO sanitr_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","tasmAd yihUdAtastAmaro garbhe perasserahau jaj nAte, tasya perasaH putro hiShroN tasya putro .arAm| ");
INSERT INTO sanitr_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","tasya putro .ammInAdab tasya putro nahashon tasya putraH salmon| ");
INSERT INTO sanitr_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","tasmAd rAhabo garbhe boyam jaj ne, tasmAd rUto garbhe obed jaj ne, tasya putro yishayaH| ");
INSERT INTO sanitr_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","tasya putro dAyUd rAjaH tasmAd mR^itoriyasya jAyAyAM sulemAn jaj ne| ");
INSERT INTO sanitr_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","tasya putro rihabiyAm, tasya putro.abiyaH, tasya putra AsA:| ");
INSERT INTO sanitr_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","tasya suto yihoshAphaT tasya suto yihorAma tasya suta uShiyaH| ");
INSERT INTO sanitr_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","tasya suto yotham tasya suta Aham tasya suto hiShkiyaH| ");
INSERT INTO sanitr_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","tasya suto minashiH, tasya suta Amon tasya suto yoshiyaH| ");
INSERT INTO sanitr_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","bAbilnagare pravasanAt pUrvvaM sa yoshiyo yikhaniyaM tasya bhrAtR^iMshcha janayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","tato bAbili pravasanakAle yikhaniyaH shaltIyelaM janayAmAsa, tasya sutaH sirubbAvil| ");
INSERT INTO sanitr_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","tasya suto .abohud tasya suta ilIyAkIm tasya suto.asor| ");
INSERT INTO sanitr_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","asoraH sutaH sAdok tasya suta AkhIm tasya suta ilIhUd| ");
INSERT INTO sanitr_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","tasya suta iliyAsar tasya suto mattan| ");
INSERT INTO sanitr_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","tasya suto yAkUb tasya suto yUShaph tasya jAyA mariyam; tasya garbhe yIshurajani, tameva khrIShTam (arthAd abhiShiktaM) vadanti| ");
INSERT INTO sanitr_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ittham ibrAhImo dAyUdaM yAvat sAkalyena chaturdashapuruShAH; A dAyUdaH kAlAd bAbili pravasanakAlaM yAvat chaturdashapuruShA bhavanti| bAbili pravAsanakAlAt khrIShTasya kAlaM yAvat chaturdashapuruShA bhavanti| ");
INSERT INTO sanitr_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","yIshukhrIShTasya janma kaththate| mariyam nAmikA kanyA yUShaphe vAgdattAsIt, tadA tayoH sa NgamAt prAk sA kanyA  pavitreNAtmanA garbhavatI babhUva| ");
INSERT INTO sanitr_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","tatra tasyAH pati ryUShaph saujanyAt tasyAH kala NgaM prakAshayitum anichChan gopanene tAM pArityaktuM manashchakre| ");
INSERT INTO sanitr_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","sa tathaiva bhAvayati, tadAnIM parameshvarasya dUtaH svapne taM darshanaM dattvA vyAjahAra, he dAyUdaH santAna yUShaph tvaM nijAM jAyAM mariyamam AdAtuM mA bhaiShIH| ");
INSERT INTO sanitr_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","yatastasyA garbhaH pavitrAdAtmano.abhavat, sA cha putraM prasaviShyate, tadA tvaM tasya nAma yIshum (arthAt trAtAraM) karIShyase, yasmAt sa nijamanujAn teShAM kaluShebhya uddhariShyati| ");
INSERT INTO sanitr_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","itthaM sati, pashya garbhavatI kanyA tanayaM prasaviShyate| immAnUyel tadIya ncha nAmadheyaM bhaviShyati|| immAnUyel asmAkaM sa NgIshvara_ityarthaH| ");
INSERT INTO sanitr_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","iti yad vachanaM purvvaM bhaviShyadvaktrA IshvaraH kathAyAmAsa, tat tadAnIM siddhamabhavat| ");
INSERT INTO sanitr_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","anantaraM yUShaph nidrAto jAgarita utthAya parameshvarIyadUtasya nideshAnusAreNa nijAM jAyAM jagrAha, ");
INSERT INTO sanitr_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","kintu yAvat sA nijaM prathamasutaM a suShuve, tAvat tAM nopAgachChat, tataH sutasya nAma yIshuM chakre| ");
INSERT INTO sanitr_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","anantaraM herod saMj nake rAj ni rAjyaM shAsati yihUdIyadeshasya baitlehami nagare yIshau jAtavati cha, katipayA jyotirvvudaH pUrvvasyA disho yirUshAlamnagaraM sametya kathayamAsuH, ");
INSERT INTO sanitr_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","yo yihUdIyAnAM rAjA jAtavAn, sa kutrAste? vayaM pUrvvasyAM dishi tiShThantastadIyAM tArakAm apashyAma tasmAt taM praNantum aाgamAma| ");
INSERT INTO sanitr_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","tadA herod rAjA kathAmetAM nishamya yirUshAlamnagarasthitaiH sarvvamAnavaiH sArddham udvijya ");
INSERT INTO sanitr_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","sarvvAn pradhAnayAjakAn adhyApakAMshcha samAhUyAnIya paprachCha, khrIShTaH kutra janiShyate? ");
INSERT INTO sanitr_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","tadA te kathayAmAsuH, yihUdIyadeshasya baitlehami nagare, yato bhaviShyadvAdinA itthaM likhitamAste, ");
INSERT INTO sanitr_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","sarvvAbhyo rAjadhAnIbhyo yihUdIyasya nIvR^itaH| he yIhUdIyadeshasye baitleham tvaM na chAvarA|isrAyelIyalokAn me yato yaH pAlayiShyati| tAdR^igeko mahArAjastvanmadhya udbhaviShyatI|| ");
INSERT INTO sanitr_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","tadAnIM herod rAjA tAn jyotirvvido gopanam AhUya sA tArakA kadA dR^iShTAbhavat , tad vinishchayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","aparaM tAn baitlehamaM prahItya gaditavAn, yUyaM yAta, yatnAt taM shishum anviShya taduddeshe prApte mahyaM vArttAM dAsyatha, tato mayApi gatvA sa praNaMsyate| ");
INSERT INTO sanitr_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","tadAnIM rAj na etAdR^ishIm Aj nAM prApya te pratasthire, tataH pUrvvarsyAM dishi sthitaistai ryA tArakA dR^iShTA sA tArakA teShAmagre gatvA yatra sthAne shishUrAste, tasya sthAnasyopari sthagitA tasyau| ");
INSERT INTO sanitr_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","tad dR^iShTvA te mahAnanditA babhUvuH, ");
INSERT INTO sanitr_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","tato gehamadhya pravishya tasya mAtrA mariyamA sAddhaM taM shishuM nirIkShaya daNDavad bhUtvA praNemuH, aparaM sveShAM ghanasampattiM mochayitvA suvarNaM kunduruM gandharama ncha tasmai darshanIyaM dattavantaH| ");
INSERT INTO sanitr_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","pashchAd herod rAjasya samIpaM punarapi gantuM svapna IshvareNa niShiddhAH santo .anyena pathA te nijadeshaM prati pratasthire| ");
INSERT INTO sanitr_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","anantaraM teShu gatavatmu parameshvarasya dUto yUShaphe svapne darshanaM datvA jagAda, tvam utthAya shishuM tanmAtara ncha gR^ihItvA misardeshaM palAyasva, aparaM yAvadahaM tubhyaM vArttAM na kathayiShyAmi, tAvat tatraiva nivasa, yato rAjA herod shishuM nAshayituM mR^igayiShyate| ");
INSERT INTO sanitr_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","tadAnIM yUShaph utthAya rajanyAM shishuM tanmAtara ncha gR^ihItvA misardeshaM prati pratasthe, ");
INSERT INTO sanitr_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","gatvA cha herodo nR^ipate rmaraNaparyyantaM tatra deshe nyuvAsa, tena misardeshAdahaM putraM svakIyaM samupAhUyam| yadetadvachanam IshvareNa bhaviShyadvAdinA kathitaM tat saphalamabhUt| ");
INSERT INTO sanitr_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","anantaraM herod jyotirvidbhirAtmAnaM prava nchitaM vij nAya bhR^ishaM chukopa; aparaM jyotirvvidbhyastena vinishchitaM yad dinaM taddinAd gaNayitvA dvitIyavatsaraM praviShTA yAvanto bAlakA asmin baitlehamnagare tatsImamadhye chAsan, lokAn prahitya tAn sarvvAn ghAtayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ataH anekasya vilApasya ninAda: krandanasya cha| shokena kR^itashabdashcha rAmAyAM saMnishamyate| svabAlagaNahetorvai rAhel nArI tu rodinI| na manyate prabodhantu yataste naiva manti hi|| ");
INSERT INTO sanitr_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","yadetad vachanaM yirImiyanAmakabhaviShyadvAdinA kathitaM tat tadAnIM saphalam abhUt| ");
INSERT INTO sanitr_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","tadanantaraM heredi rAjani mR^ite parameshvarasya dUto misardeshe svapne darshanaM dattvA yUShaphe kathitavAn ");
INSERT INTO sanitr_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","tvam utthAya shishuM tanmAtara ncha gR^ihItvA punarapIsrAyelo deshaM yAhI, ye janAH shishuM nAshayitum amR^igayanta, te mR^itavantaH| ");
INSERT INTO sanitr_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","tadAnIM sa utthAya shishuM tanmAtara ncha gR^ihlan isrAyeldesham AjagAma| ");
INSERT INTO sanitr_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","kintu yihUdIyadeshe arkhilAyanAma rAjakumAro nijapitu rherodaH padaM prApya rAjatvaM karotIti nishamya tat sthAnaM yAtuM sha NkitavAn, pashchAt svapna IshvarAt prabodhaM prApya gAlIldeshasya pradeshaikaM prasthAya nAsarannAma nagaraM gatvA tatra nyuShitavAn, ");
INSERT INTO sanitr_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","tena taM nAsaratIyaM kathayiShyanti, yadetadvAkyaM bhaviShyadvAdibhirukttaM tat saphalamabhavat| ");
INSERT INTO sanitr_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","tadAnoM yohnnAmA majjayitA yihUdIyadeshasya prAntaram upasthAya prachArayan kathayAmAsa, ");
INSERT INTO sanitr_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","manAMsi parAvarttayata, svargIyarAjatvaM samIpamAgatam| ");
INSERT INTO sanitr_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","parameshasya panthAnaM pariShkuruta sarvvataH| tasya rAjapathAMshchaiva samIkuruta sarvvathA| ityetat prAntare vAkyaM vadataH kasyachid ravaH|| ");
INSERT INTO sanitr_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","etadvachanaM yishayiyabhaviShyadvAdinA yohanamuddishya bhAShitam| yohano vasanaM mahA NgaromajaM tasya kaTau charmmakaTibandhanaM; sa cha shUkakITAn madhu cha bhuktavAn| ");
INSERT INTO sanitr_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","tadAnIM yirUshAlamnagaranivAsinaH sarvve yihUdideshIyA yarddantaTinyA ubhayataTasthAshcha mAnavA bahirAgatya tasya samIpe ");
INSERT INTO sanitr_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","svIyaM svIyaM duritam a NgIkR^itya tasyAM yarddani tena majjitA babhUvuH| ");
INSERT INTO sanitr_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","aparaM bahUn phirUshinaH sidUkinashcha manujAn maMktuM svasamIpam AgachChto vilokya sa tAn abhidadhau, re re bhujagavaMshA AgAmInaH kopAt palAyituM yuShmAn kashchetitavAn? ");
INSERT INTO sanitr_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","manaHparAvarttanasya samuchitaM phalaM phalata| ");
INSERT INTO sanitr_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","kintvasmAkaM tAta ibrAhIm astIti sveShu manaHsu chIntayanto mA vyAharata| yato yuShmAn ahaM vadAmi, Ishvara etebhyaH pAShANebhya ibrAhImaH santAnAn utpAdayituM shaknoti| ");
INSERT INTO sanitr_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","aparaM pAdapAnAM mUle kuThAra idAnImapi lagan Aste, tasmAd yasmin pAdape uttamaM phalaM na bhavati, sa kR^itto madhye.agniM nikShepsyate| ");
INSERT INTO sanitr_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","aparam ahaM manaHparAvarttanasUchakena majjanena yuShmAn majjayAmIti satyaM, kintu mama pashchAd ya AgachChati, sa mattopi mahAn, ahaM tadIyopAnahau voDhumapi nahi yogyosmi, sa yuShmAn vahnirUpe pavitra Atmani saMmajjayiShyati| ");
INSERT INTO sanitr_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","tasya kAre sUrpa Aste, sa svIyashasyAni samyak prasphoTya nijAn sakalagodhUmAn saMgR^ihya bhANDAgAre sthApayiShyati, kiMntu sarvvANi vuShANyanirvvANavahninA dAhayiShyati| ");
INSERT INTO sanitr_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","anantaraM yIshu ryohanA majjito bhavituM gAlIlpradeshAd yarddani tasya samIpam AjagAma| ");
INSERT INTO sanitr_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","kintu yohan taM niShidhya babhAShe, tvaM kiM mama samIpam AgachChasi? varaM tvayA majjanaM mama prayojanam Aste| ");
INSERT INTO sanitr_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","tadAnIM yIshuH pratyavochat; IdAnIm anumanyasva, yata itthaM sarvvadharmmasAdhanam asmAkaM karttavyaM, tataH so.anvamanyata| ");
INSERT INTO sanitr_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","anantaraM yIshurammasi majjituH san tatkShaNAt toyamadhyAd utthAya jagAma, tadA jImUtadvAre mukte jAte, sa IshvarasyAtmAnaM kapotavad avaruhya svoparyyAgachChantaM vIkShA nchakre| ");
INSERT INTO sanitr_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","aparam eSha mama priyaH putra etasminneva mama mahAsantoSha etAdR^ishI vyomajA vAg babhUva| ");
INSERT INTO sanitr_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","tataH paraM yIshuH pratArakeNa parIkShito bhavitum AtmanA prAntaram AkR^iShTaH ");
INSERT INTO sanitr_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","san chatvAriMshadahorAtrAn anAhArastiShThan kShudhito babhUva| ");
INSERT INTO sanitr_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","tadAnIM parIkShitA tatsamIpam Agatya vyAhR^itavAn, yadi tvamIshvarAtmajo bhavestarhyAj nayA pAShANAnetAn pUpAn vidhehi| ");
INSERT INTO sanitr_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","tataH sa pratyabravIt, itthaM likhitamAste, \"manujaH kevalapUpena na jIviShyati, kintvIshvarasya vadanAd yAni yAni vachAMsi niHsaranti taireva jIviShyati|\" ");
INSERT INTO sanitr_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","tadA pratArakastaM puNyanagaraM nItvA mandirasya chUDopari nidhAya gaditavAn, ");
INSERT INTO sanitr_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","tvaM yadishvarasya tanayo bhavestarhIto.adhaH pata, yata itthaM likhitamAste, AdekShyati nijAn dUtAn rakShituM tvAM parameshvaraH| yathA sarvveShu mArgeShu tvadIyacharaNadvaye| na laget prastarAghAtastvAM ghariShyanti te karaiH|| ");
INSERT INTO sanitr_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","tadAnIM yIshustasmai kathitavAn etadapi likhitamAste, \"tvaM nijaprabhuM parameshvaraM mA parIkShasva|\" ");
INSERT INTO sanitr_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","anantaraM pratArakaH punarapi tam atyu nchadharAdharopari nItvA jagataH sakalarAjyAni tadaishvaryyANi cha darshayAshchakAra kathayA nchakAra cha, ");
INSERT INTO sanitr_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","yadi tvaM daNDavad bhavan mAM praNamestarhyaham etAni tubhyaM pradAsyAmi| ");
INSERT INTO sanitr_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","tadAnIM yIshustamavochat, dUrIbhava pratAraka, likhitamidam Aste, \"tvayA nijaH prabhuH parameshvaraH praNamyaH kevalaH sa sevyashcha|\" ");
INSERT INTO sanitr_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","tataH pratArakeNa sa paryyatyAji, tadA svargIyadUtairAgatya sa siSheve| ");
INSERT INTO sanitr_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","tadanantaraM yohan kArAyAM babandhe, tadvArttAM nishamya yIshunA gAlIl prAsthIyata| ");
INSERT INTO sanitr_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","tataH paraM sa nAsarannagaraM vihAya jalaghestaTe sibUlUnnaptAlI etayoruvabhayoH pradeshayoH sImnormadhyavarttI ya: kapharnAhUm tannagaram itvA nyavasat| ");
INSERT INTO sanitr_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","tasmAt, anyAdeshIyagAlIli yarddanpAre.abdhirodhasi| naptAlisibUlUndeshau yatra sthAne sthitau purA| ");
INSERT INTO sanitr_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","tatratyA manujA ye ye paryyabhrAmyan tamisrake| tairjanairbR^ihadAlokaH paridarshiShyate tadA| avasan ye janA deshe mR^ityuchChAyAsvarUpake| teShAmupari lokAnAmAlokaH saMprakAshitaH|| ");
INSERT INTO sanitr_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","yadetadvachanaM yishayiyabhaviShyadvAdinA proktaM, tat tadA saphalam abhUt| ");
INSERT INTO sanitr_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","anantaraM yIshuH susaMvAdaM prachArayan etAM kathAM kathayitum Arebhe, manAMsi parAvarttayata, svargIyarAjatvaM savidhamabhavat| ");
INSERT INTO sanitr_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","tataH paraM yIshu rgAlIlo jaladhestaTena gachChan gachChan Andriyastasya bhrAtA shimon arthato yaM pitaraM vadanti etAvubhau jalaghau jAlaM kShipantau dadarsha, yatastau mInadhAriNAvAstAm| ");
INSERT INTO sanitr_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","tadA sa tAvAhUya vyAjahAra, yuvAM mama pashchAd AgachChataM, yuvAmahaM manujadhAriNau kariShyAmi| ");
INSERT INTO sanitr_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","tenaiva tau jAlaM vihAya tasya pashchAt AgachChatAm| ");
INSERT INTO sanitr_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","anantaraM tasmAt sthAnAt vrajan vrajan sivadiyasya sutau yAkUb yohannAmAnau dvau sahajau tAtena sArddhaM naukopari jAlasya jIrNoddhAraM kurvvantau vIkShya tAvAhUtavAn| ");
INSERT INTO sanitr_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","tatkShaNAt tau nAvaM svatAta ncha vihAya tasya pashchAdgAminau babhUvatuH| ");
INSERT INTO sanitr_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","anantaraM bhajanabhavane samupadishan rAjyasya susaMvAdaM prachArayan manujAnAM sarvvaprakArAn rogAn sarvvaprakArapIDAshcha shamayan yIshuH kR^itsnaM gAlIldeshaM bhramitum Arabhata| ");
INSERT INTO sanitr_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","tena kR^itsnasuriyAdeshasya madhyaM tasya yasho vyApnot, aparaM bhUtagrastA apasmArargINaH pakShAdhAtiprabhR^itayashcha yAvanto manujA nAnAvidhavyAdhibhiH kliShTA Asan, teShu sarvveShu tasya samIpam AnIteShu sa tAn svasthAn chakAra| ");
INSERT INTO sanitr_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","etena gAlIl-dikApani-yirUshAlam-yihUdIyadeshebhyo yarddanaH pArA ncha bahavo manujAstasya pashchAd AgachChan| ");
INSERT INTO sanitr_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","anantaraM sa jananivahaM nirIkShya bhUdharopari vrajitvA samupavivesha| ");
INSERT INTO sanitr_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","tadAnIM shiShyeShu tasya samIpamAgateShu tena tebhya eShA kathA kathyA nchakre| ");
INSERT INTO sanitr_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","abhimAnahInA janA dhanyAH, yataste svargIyarAjyam adhikariShyanti| ");
INSERT INTO sanitr_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","khidyamAnA manujA dhanyAH, yasmAt te sAntvanAM prApsanti| ");
INSERT INTO sanitr_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","namrA mAnavAshcha dhanyAH, yasmAt te medinIm adhikariShyanti| ");
INSERT INTO sanitr_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","dharmmAya bubhukShitAH tR^iShArttAshcha manujA dhanyAH, yasmAt te paritarpsyanti| ");
INSERT INTO sanitr_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","kR^ipAlavo mAnavA dhanyAH, yasmAt te kR^ipAM prApsyanti| ");
INSERT INTO sanitr_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","nirmmalahR^idayA manujAshcha dhanyAH, yasmAt ta IshcharaM drakShyanti| ");
INSERT INTO sanitr_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","melayitAro mAnavA dhanyAH, yasmAt ta Ishcharasya santAnatvena vikhyAsyanti| ");
INSERT INTO sanitr_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","dharmmakAraNAt tADitA manujA dhanyA, yasmAt svargIyarAjye teShAmadhikaro vidyate| ");
INSERT INTO sanitr_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","yadA manujA mama nAmakR^ite yuShmAn nindanti tADayanti mR^iShA nAnAdurvvAkyAni vadanti cha, tadA yuyaM dhanyAH| ");
INSERT INTO sanitr_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","tadA Anandata, tathA bhR^ishaM hlAdadhva ncha, yataH svarge bhUyAMsi phalAni lapsyadhve; te yuShmAkaM purAtanAn bhaviShyadvAdino.api tAdR^ig atADayan| ");
INSERT INTO sanitr_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","yuyaM medinyAM lavaNarUpAH, kintu yadi lavaNasya lavaNatvam apayAti, tarhi tat kena prakAreNa svAduyuktaM bhaviShyati? tat kasyApi kAryyasyAyogyatvAt kevalaM bahiH prakSheptuM narANAM padatalena dalayitu ncha yogyaM bhavati| ");
INSERT INTO sanitr_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","yUyaM jagati dIptirUpAH, bhUdharopari sthitaM nagaraM guptaM bhavituM nahi shakShyati| ");
INSERT INTO sanitr_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","aparaM manujAH pradIpAn prajvAlya droNAdho na sthApayanti, kintu dIpAdhAroparyyeva sthApayanti, tena te dIpA gehasthitAn sakalAn prakAshayanti| ");
INSERT INTO sanitr_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","yena mAnavA yuShmAkaM satkarmmANi vilokya yuShmAkaM svargasthaM pitaraM dhanyaM vadanti, teShAM samakShaM yuShmAkaM dIptistAdR^ik prakAshatAm| ");
INSERT INTO sanitr_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","ahaM vyavasthAM bhaviShyadvAkya ncha loptum AgatavAn, itthaM mAnubhavata, te dve loptuM nAgatavAn, kintu saphale karttum Agatosmi| ");
INSERT INTO sanitr_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","aparaM yuShmAn ahaM tathyaM vadAmi yAvat vyomamedinyo rdhvaMso na bhaviShyati, tAvat sarvvasmin saphale na jAte vyavasthAyA ekA mAtrA bindurekopi vA na lopsyate| ");
INSERT INTO sanitr_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","tasmAt yo jana etAsAm Aj nAnAm atikShudrAm ekAj nAmapI laMghate manujAM ncha tathaiva shikShayati, sa svargIyarAjye sarvvebhyaH kShudratvena vikhyAsyate, kintu yo janastAM pAlayati, tathaiva shikShayati cha, sa svargIyarAjye pradhAnatvena vikhyAsyate| ");
INSERT INTO sanitr_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","aparaM yuShmAn ahaM vadAmi, adhyApakaphirUshimAnavAnAM dharmmAnuShThAnAt yuShmAkaM dharmmAnuShThAne nottame jAte yUyam IshvarIyarAjyaM praveShTuM na shakShyatha| ");
INSERT INTO sanitr_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","apara ncha tvaM naraM mA vadhIH, yasmAt yo naraM hanti, sa vichArasabhAyAM daNDArho bhaviShyati, pUrvvakAlInajanebhya iti kathitamAsIt, yuShmAbhirashrAvi| ");
INSERT INTO sanitr_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","kintvahaM yuShmAn vadAmi, yaH kashchit kAraNaM vinA nijabhrAtre kupyati, sa vichArasabhAyAM daNDArho bhaviShyati; yaH kashchichcha svIyasahajaM nirbbodhaM vadati, sa mahAsabhAyAM daNDArho bhaviShyati; punashcha tvaM mUDha iti vAkyaM yadi kashchit svIyabhrAtaraM vakti, tarhi narakAgnau sa daNDArho bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","ato vedyAH samIpaM nijanaivedye samAnIte.api nijabhrAtaraM prati kasmAchchit kAraNAt tvaM yadi doShI vidyase, tadAnIM tava tasya smR^iti rjAyate cha, ");
INSERT INTO sanitr_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tarhi tasyA vedyAH samIpe nijanaivaidyaM nidhAya tadaiva gatvA pUrvvaM tena sArddhaM mila, pashchAt Agatya nijanaivedyaM nivedaya| ");
INSERT INTO sanitr_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","anya ncha yAvat vivAdinA sArddhaM vartmani tiShThasi, tAvat tena sArddhaM melanaM kuru; no chet vivAdI vichArayituH samIpe tvAM samarpayati vichArayitA cha rakShiNaH sannidhau samarpayati tadA tvaM kArAyAM badhyethAH| ");
INSERT INTO sanitr_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","tarhi tvAmahaM taththaM bravImi, sheShakapardake.api na parishodhite tasmAt sthAnAt kadApi bahirAgantuM na shakShyasi| ");
INSERT INTO sanitr_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","aparaM tvaM mA vyabhichara, yadetad vachanaM pUrvvakAlInalokebhyaH kathitamAsIt, tad yUyaM shrutavantaH; ");
INSERT INTO sanitr_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","kintvahaM yuShmAn vadAmi, yadi kashchit kAmataH kA nchana yoShitaM pashyati, tarhi sa manasA tadaiva vyabhicharitavAn| ");
INSERT INTO sanitr_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","tasmAt tava dakShiNaM netraM yadi tvAM bAdhate, tarhi tannetram utpATya dUre nikShipa, yasmAt tava sarvvavapuSho narake nikShepAt tavaikA Ngasya nAsho varaM| ");
INSERT INTO sanitr_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","yadvA tava dakShiNaH karo yadi tvAM bAdhate, tarhi taM karaM ChittvA dUre nikShipa, yataH sarvvavapuSho narake nikShepAt ekA Ngasya nAsho varaM| ");
INSERT INTO sanitr_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","uktamAste, yadi kashchin nijajAyAM parityakttum ichChati, tarhi sa tasyai tyAgapatraM dadAtu| ");
INSERT INTO sanitr_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","kintvahaM yuShmAn vyAharAmi, vyabhichAradoShe na jAte yadi kashchin nijajAyAM parityajati, tarhi sa tAM vyabhichArayati; yashcha tAM tyaktAM striyaM vivahati, sopi vyabhicharati| ");
INSERT INTO sanitr_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","punashcha tvaM mR^iShA shapatham na kurvvan IshcharAya nijashapathaM pAlaya, pUrvvakAlInalokebhyo yaiShA kathA kathitA, tAmapi yUyaM shrutavantaH| ");
INSERT INTO sanitr_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","kintvahaM yuShmAn vadAmi, kamapi shapathaM mA kArShTa, arthataH svarganAmnA na, yataH sa Ishvarasya siMhAsanaM; ");
INSERT INTO sanitr_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","pR^ithivyA nAmnApi na, yataH sA tasya pAdapIThaM; yirUshAlamo nAmnApi na, yataH sA mahArAjasya purI; ");
INSERT INTO sanitr_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","nijashironAmnApi na, yasmAt tasyaikaM kachamapi sitam asitaM vA karttuM tvayA na shakyate| ");
INSERT INTO sanitr_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","aparaM yUyaM saMlApasamaye kevalaM bhavatIti na bhavatIti cha vadata yata ito.adhikaM yat tat pApAtmano jAyate| ");
INSERT INTO sanitr_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","aparaM lochanasya vinimayena lochanaM dantasya vinimayena dantaH pUrvvaktamidaM vachana ncha yuShmAbhirashrUyata| ");
INSERT INTO sanitr_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","kintvahaM yuShmAn vadAmi yUyaM hiMsakaM naraM mA vyAghAtayata| kintu kenachit tava dakShiNakapole chapeTAghAte kR^ite taM prati vAmaM kapola ncha vyAghoTaya| ");
INSERT INTO sanitr_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","aparaM kenachit tvayA sArdhdaM vivAdaM kR^itvA tava paridheyavasane jighR^itite tasmAyuttarIyavasanamapi dehi| ");
INSERT INTO sanitr_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","yadi kashchit tvAM kroshamekaM nayanArthaM anyAyato dharati, tadA tena sArdhdaM kroshadvayaM yAhi| ");
INSERT INTO sanitr_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","yashcha mAnavastvAM yAchate, tasmai dehi, yadi kashchit tubhyaM dhArayitum ichChati, tarhi taM prati parAMmukho mA bhUH| ");
INSERT INTO sanitr_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","nijasamIpavasini prema kuru, kintu shatruM prati dveShaM kuru, yadetat puroktaM vachanaM etadapi yUyaM shrutavantaH| ");
INSERT INTO sanitr_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","kintvahaM yuShmAn vadAmi, yUyaM ripuvvapi prema kuruta, ye cha yuShmAn shapante, tAna, AshiShaM vadata, ye cha yuShmAn R^iृtIyante, teShAM ma NgalaM kuruta, ye cha yuShmAn nindanti, tADayanti cha, teShAM kR^ite prArthayadhvaM| ");
INSERT INTO sanitr_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","tatra yaH satAmasatA nchopari prabhAkaram udAyayati, tathA dhArmmikAnAmadhArmmikAnA nchopari nIraM varShayati tAdR^isho yo yuShmAkaM svargasthaH pitA, yUyaM tasyaiva santAnA bhaviShyatha| ");
INSERT INTO sanitr_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ye yuShmAsu prema kurvvanti, yUyaM yadi kevalaM tevveva prema kurutha, tarhi yuShmAkaM kiM phalaM bhaviShyati? chaNDAlA api tAdR^ishaM kiM na kurvvanti? ");
INSERT INTO sanitr_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","aparaM yUyaM yadi kevalaM svIyabhrAtR^itvena namata, tarhi kiM mahat karmma kurutha? chaNDAlA api tAdR^ishaM kiM na kurvvanti? ");
INSERT INTO sanitr_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","tasmAt yuShmAkaM svargasthaH pitA yathA pUrNo bhavati, yUyamapi tAdR^ishA bhavata| ");
INSERT INTO sanitr_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","sAvadhAnA bhavata, manujAn darshayituM teShAM gochare dharmmakarmma mA kuruta, tathA kR^ite yuShmAkaM svargasthapituH sakAshAt ki nchana phalaM na prApsyatha| ");
INSERT INTO sanitr_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","tvaM yadA dadAsi tadA kapaTino janA yathA manujebhyaH prashaMsAM prAptuM bhajanabhavane rAjamArge cha tUrIM vAdayanti, tathA mA kuriु, ahaM tubhyaM yathArthaM kathayAmi, te svakAyaM phalam alabhanta| ");
INSERT INTO sanitr_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","kintu tvaM yadA dadAsi, tadA nijadakShiNakaro yat karoti, tad vAmakaraM mA j nApaya| ");
INSERT INTO sanitr_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","tena tava dAnaM guptaM bhaviShyati yastu tava pitA guptadarshI, sa prakAshya tubhyaM phalaM dAsyati| ");
INSERT INTO sanitr_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","aparaM yadA prArthayase, tadA kapaTina_iva mA kuru, yasmAt te bhajanabhavane rAjamArgasya koNe tiShThanto lokAn darshayantaH prArthayituM prIyante; ahaM yuShmAn tathyaM vadAmi, te svakIyaphalaM prApnuvan| ");
INSERT INTO sanitr_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","tasmAt prArthanAkAle antarAgAraM pravishya dvAraM rudvvA guptaM pashyatastava pituH samIpe prArthayasva; tena tava yaH pitA guptadarshI, sa prakAshya tubhyaM phalaM dAsyatil ");
INSERT INTO sanitr_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","aparaM prArthanAkAle devapUjakAiva mudhA punaruktiM mA kuru, yasmAt te bodhante, bahuvAraM kathAyAM kathitAyAM teShAM prArthanA grAhiShyate| ");
INSERT INTO sanitr_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","yUyaM teShAmiva mA kuruta, yasmAt yuShmAkaM yad yat prayojanaM yAchanAtaH prAgeva yuShmAkaM pitA tat jAnAti| ");
INSERT INTO sanitr_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","ataeva yUyama IdR^ik prArthayadhvaM, he asmAkaM svargasthapitaH, tava nAma pUjyaM bhavatu| ");
INSERT INTO sanitr_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","tava rAjatvaM bhavatu; tavechChA svarge yathA tathaiva medinyAmapi saphalA bhavatu| ");
INSERT INTO sanitr_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","asmAkaM prayojanIyam AhAram adya dehi| ");
INSERT INTO sanitr_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","vayaM yathA nijAparAdhinaH kShamAmahe, tathaivAsmAkam aparAdhAn kShamasva| ");
INSERT INTO sanitr_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","asmAn parIkShAM mAnaya, kintu pApAtmano rakSha; rAjatvaM gauravaM parAkramaH ete sarvve sarvvadA tava; tathAstu| ");
INSERT INTO sanitr_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","yadi yUyam anyeShAm aparAdhAn kShamadhve tarhi yuShmAkaM svargasthapitApi yuShmAn kShamiShyate; ");
INSERT INTO sanitr_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","kintu yadi yUyam anyeShAm aparAdhAn na kShamadhve, tarhi yuShmAkaM janakopi yuShmAkam aparAdhAn na kShamiShyate| ");
INSERT INTO sanitr_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","aparam upavAsakAle kapaTino janA mAnuShAn upavAsaM j nApayituM sveShAM vadanAni mlAnAni kurvvanti, yUyaM ta_iva viShaNavadanA mA bhavata; ahaM yuShmAn tathyaM vadAmi te svakIyaphalam alabhanta| ");
INSERT INTO sanitr_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","yadA tvam upavasasi, tadA yathA lokaistvaM upavAsIva na dR^ishyase, kintu tava yo.agocharaH pitA tenaiva dR^ishyase, tatkR^ite nijashirasi tailaM marddaya vadana ncha prakShAlaya; ");
INSERT INTO sanitr_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","tena tava yaH pitA guptadarshI sa prakAshya tubhyaM phalaM dAsyati| ");
INSERT INTO sanitr_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","aparaM yatra sthAne kITAH kala NkAshcha kShayaM nayanti, chaurAshcha sandhiM karttayitvA chorayituM shaknuvanti, tAdR^ishyAM medinyAM svArthaM dhanaM mA saMchinuta| ");
INSERT INTO sanitr_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","kintu yatra sthAne kITAH kala NkAshcha kShayaM na nayanti, chaurAshcha sandhiM karttayitvA chorayituM na shaknuvanti, tAdR^ishe svarge dhanaM sa nchinuta| ");
INSERT INTO sanitr_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","yasmAt yatra sthAne yuShmAMka dhanaM tatraiva khAne yuShmAkaM manAMsi| ");
INSERT INTO sanitr_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","lochanaM dehasya pradIpakaM, tasmAt yadi tava lochanaM prasannaM bhavati, tarhi tava kR^itsnaM vapu rdIptiyuktaM bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","kintu lochane.aprasanne tava kR^itsnaM vapuH tamisrayuktaM bhaviShyati| ataeva yA dIptistvayi vidyate, sA yadi tamisrayuktA bhavati, tarhi tat tamisraM kiyan mahat| ");
INSERT INTO sanitr_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","kopi manujo dvau prabhU sevituM na shaknoti, yasmAd ekaM saMmanya tadanyaM na sammanyate, yadvA ekatra mano nidhAya tadanyam avamanyate; tathA yUyamapIshvaraM lakShmI nchetyubhe sevituM na shaknutha| ");
INSERT INTO sanitr_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","aparam ahaM yuShmabhyaM tathyaM kathayAmi, kiM bhakShiShyAmaH? kiM pAsyAmaH? iti prANadhAraNAya mA chintayata; kiM paridhAsyAmaH? iti kAyarakShaNAya na chintayata; bhakShyAt prANA vasanA ncha vapUMShi kiM shreShThANi na hi? ");
INSERT INTO sanitr_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","vihAyaso viha NgamAn vilokayata; tai rnopyate na kR^ityate bhANDAgAre na sa nchIyate.api; tathApi yuShmAkaM svargasthaH pitA tebhya AhAraM vitarati| ");
INSERT INTO sanitr_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","yUyaM tebhyaH kiM shreShThA na bhavatha? yuShmAkaM kashchit manujaH chintayan nijAyuShaH kShaNamapi varddhayituM shaknoti? ");
INSERT INTO sanitr_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","aparaM vasanAya kutashchintayata? kShetrotpannAni puShpANi kathaM varddhante tadAlochayata| tAni tantUn notpAdayanti kimapi kAryyaM na kurvvanti; ");
INSERT INTO sanitr_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","tathApyahaM yuShmAn vadAmi, sulemAn tAdR^ig aishvaryyavAnapi tatpuShpamiva vibhUShito nAsIt| ");
INSERT INTO sanitr_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","tasmAt kShadya vidyamAnaM shchaH chullyAM nikShepsyate tAdR^ishaM yat kShetrasthitaM kusumaM tat yadIshchara itthaM bibhUShayati, tarhi he stokapratyayino yuShmAn kiM na paridhApayiShyati? ");
INSERT INTO sanitr_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","tasmAt asmAbhiH kimatsyate? ki ncha pAyiShyate? kiM vA paridhAyiShyate, iti na chintayata| ");
INSERT INTO sanitr_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","yasmAt devArchchakA apIti cheShTante; eteShu dravyeShu prayojanamastIti yuShmAkaM svargasthaH pitA jAnAti| ");
INSERT INTO sanitr_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ataeva prathamata IshvarIyarAjyaM dharmma ncha cheShTadhvaM, tata etAni vastUni yuShmabhyaM pradAyiShyante| ");
INSERT INTO sanitr_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","shvaH kR^ite mA chintayata, shvaeva svayaM svamuddishya chintayiShyati; adyatanI yA chintA sAdyakR^ite prachuratarA| ");
INSERT INTO sanitr_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","yathA yUyaM doShIkR^itA na bhavatha, tatkR^ite.anyaM doShiNaM mA kuruta| ");
INSERT INTO sanitr_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","yato yAdR^ishena doSheNa yUyaM parAn doShiNaH kurutha, tAdR^ishena doSheNa yUyamapi doShIkR^itA bhaviShyatha, anya ncha yena parimANena yuShmAbhiH parimIyate, tenaiva parimANena yuShmatkR^ite parimAyiShyate| ");
INSERT INTO sanitr_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","apara ncha nijanayane yA nAsA vidyate, tAm anAlochya tava sahajasya lochane yat tR^iNam Aste, tadeva kuto vIkShase? ");
INSERT INTO sanitr_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","tava nijalochane nAsAyAM vidyamAnAyAM, he bhrAtaH, tava nayanAt tR^iNaM bahiShyartuM anujAnIhi, kathAmetAM nijasahajAya kathaM kathayituM shaknoShi? ");
INSERT INTO sanitr_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","he kapaTin, Adau nijanayanAt nAsAM bahiShkuru tato nijadR^iShTau suprasannAyAM tava bhrAtR^i rlochanAt tR^iNaM bahiShkartuM shakShyasi| ");
INSERT INTO sanitr_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","anya ncha sArameyebhyaH pavitravastUni mA vitarata, varAhANAM samakSha ncha muktA mA nikShipata; nikShepaNAt te tAH sarvvAH padai rdalayiShyanti, parAvR^itya yuShmAnapi vidArayiShyanti| ");
INSERT INTO sanitr_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","yAchadhvaM tato yuShmabhyaM dAyiShyate; mR^igayadhvaM tata uddeshaM lapsyadhve; dvAram Ahata, tato yuShmatkR^ite muktaM bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","yasmAd yena yAchyate, tena labhyate; yena mR^igyate tenoddeshaH prApyate; yena cha dvAram Ahanyate, tatkR^ite dvAraM mochyate| ");
INSERT INTO sanitr_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Atmajena pUpe prArthite tasmai pAShANaM vishrANayati, ");
INSERT INTO sanitr_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","mIne yAchite cha tasmai bhujagaM vitarati, etAdR^ishaH pitA yuShmAkaM madhye ka Aste? ");
INSERT INTO sanitr_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","tasmAd yUyam abhadrAH santo.api yadi nijabAlakebhya uttamaM dravyaM dAtuM jAnItha, tarhi yuShmAkaM svargasthaH pitA svIyayAchakebhyaH kimuttamAni vastUni na dAsyati? ");
INSERT INTO sanitr_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","yUShmAn pratItareShAM yAdR^isho vyavahAro yuShmAkaM priyaH, yUyaM tAn prati tAdR^ishAneva vyavahArAn vidhatta; yasmAd vyavasthAbhaviShyadvAdinAM vachanAnAm iti sAram| ");
INSERT INTO sanitr_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","sa NkIrNadvAreNa pravishata; yato narakagamanAya yad dvAraM tad vistIrNaM yachcha vartma tad bR^ihat tena bahavaH pravishanti| ");
INSERT INTO sanitr_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","aparaM svargagamanAya yad dvAraM tat kIdR^ik saMkIrNaM| yachcha vartma tat kIdR^ig durgamam| taduddeShTAraH kiyanto.alpAH| ");
INSERT INTO sanitr_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","apara ncha ye janA meShaveshena yuShmAkaM samIpam AgachChanti, kintvantardurantA vR^ikA etAdR^ishebhyo bhaviShyadvAdibhyaH sAvadhAnA bhavata, yUyaM phalena tAn parichetuM shaknutha| ");
INSERT INTO sanitr_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","manujAH kiM kaNTakino vR^ikShAd drAkShAphalAni shR^igAlakolitashcha uDumbaraphalAni shAtayanti? ");
INSERT INTO sanitr_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","tadvad uttama eva pAdapa uttamaphalAni janayati, adhamapAdapaevAdhamaphalAni janayati| ");
INSERT INTO sanitr_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","kintUttamapAdapaH kadApyadhamaphalAni janayituM na shaknoti, tathAdhamopi pAdapa uttamaphalAni janayituM na shaknoti| ");
INSERT INTO sanitr_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","aparaM ye ye pAdapA adhamaphalAni janayanti, te kR^ittA vahnau kShipyante| ");
INSERT INTO sanitr_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ataeva yUyaM phalena tAn paricheShyatha| ");
INSERT INTO sanitr_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","ye janA mAM prabhuM vadanti, te sarvve svargarAjyaM pravekShyanti tanna, kintu yo mAnavo mama svargasthasya pituriShTaM karmma karoti sa eva pravekShyati| ");
INSERT INTO sanitr_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","tad dine bahavo mAM vadiShyanti, he prabho he prabho, tava nAmnA kimasmAmi rbhaviShyadvAkyaM na vyAhR^itaM? tava nAmnA bhUtAH kiM na tyAjitAH? tava nAmnA kiM nAnAdbhutAni karmmANi na kR^itAni? ");
INSERT INTO sanitr_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","tadAhaM vadiShyAmi, he kukarmmakAriNo yuShmAn ahaM na vedmi, yUyaM matsamIpAd dUrIbhavata| ");
INSERT INTO sanitr_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","yaH kashchit mamaitAH kathAH shrutvA pAlayati, sa pAShANopari gR^ihanirmmAtrA j nAninA saha mayopamIyate| ");
INSERT INTO sanitr_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","yato vR^iShTau satyAm AplAva Agate vAyau vAte cha teShu tadgehaM lagneShu pAShANopari tasya bhittestanna patatil ");
INSERT INTO sanitr_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","kintu yaH kashchit mamaitAH kathAH shrutvA na pAlayati sa saikate gehanirmmAtrA .aj nAninA upamIyate| ");
INSERT INTO sanitr_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","yato jalavR^iShTau satyAm AplAva Agate pavane vAte cha tai rgR^ihe samAghAte tat patati tatpatanaM mahad bhavati| ");
INSERT INTO sanitr_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","yIshunaiteShu vAkyeShu samApiteShu mAnavAstadIyopadesham AshcharyyaM menire| ");
INSERT INTO sanitr_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","yasmAt sa upAdhyAyA iva tAn nopadidesha kintu samarthapuruSha_iva samupadidesha| ");
INSERT INTO sanitr_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","yadA sa parvvatAd avArohat tadA bahavo mAnavAstatpashchAd vavrajuH| ");
INSERT INTO sanitr_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ekaH kuShThavAn Agatya taM praNamya babhAShe, he prabho, yadi bhavAn saMmanyate, tarhi mAM nirAmayaM karttuM shaknoti| ");
INSERT INTO sanitr_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","tato yIshuH karaM prasAryya tasyA NgaM spR^ishan vyAjahAra, sammanye.ahaM tvaM nirAmayo bhava; tena sa tatkShaNAt kuShThenAmochi| ");
INSERT INTO sanitr_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","tato yIshustaM jagAda, avadhehi kathAmetAM kashchidapi mA brUhi, kintu yAjakasya sannidhiM gatvA svAtmAnaM darshaya manujebhyo nijanirAmayatvaM pramANayituM mUsAnirUpitaM dravyam utsR^ija cha| ");
INSERT INTO sanitr_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","tadanantaraM yIshunA kapharnAhUmnAmani nagare praviShTe kashchit shatasenApatistatsamIpam Agatya vinIya babhAShe, ");
INSERT INTO sanitr_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","he prabho, madIya eko dAsaH pakShAghAtavyAdhinA bhR^ishaM vyathitaH, satu shayanIya Aste| ");
INSERT INTO sanitr_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","tadAnIM yIshustasmai kathitavAn, ahaM gatvA taM nirAmayaM kariShyAmi| ");
INSERT INTO sanitr_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","tataH sa shatasenApatiH pratyavadat, he prabho, bhavAn yat mama gehamadhyaM yAti tadyogyabhAjanaM nAhamasmi; vA NmAtram Adishatu, tenaiva mama dAso nirAmayo bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","yato mayi paranidhne.api mama nideshavashyAH kati kati senAH santi, tata ekasmin yAhItyukte sa yAti, tadanyasmin ehItyukte sa AyAti, tathA mama nijadAse karmmaitat kurvvityukte sa tat karoti| ");
INSERT INTO sanitr_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","tadAnIM yIshustasyaitat vacho nishamya vismayApanno.abhUt; nijapashchAdgAmino mAnavAn avochcha, yuShmAn tathyaM vachmi, isrAyelIyalokAnAM madhye.api naitAdR^isho vishvAso mayA prAptaH| ");
INSERT INTO sanitr_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","anyachchAhaM yuShmAn vadAmi, bahavaH pUrvvasyAH pashchimAyAshcha disha Agatya ibrAhImA ishAkA yAkUbA cha sAkam militvA samupavekShyanti; ");
INSERT INTO sanitr_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","kintu yatra sthAne rodanadantagharShaNe bhavatastasmin bahirbhUtatamisre rAjyasya santAnA nikShesyante| ");
INSERT INTO sanitr_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","tataH paraM yIshustaM shatasenApatiM jagAda, yAhi, tava pratItyanusArato ma NgalaM bhUyAt; tadA tasminneva daNDe tadIyadAso nirAmayo babhUva| ");
INSERT INTO sanitr_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","anantaraM yIshuH pitarasya gehamupasthAya jvareNa pIDitAM shayanIyasthitAM tasya shvashrUM vIkShA nchakre| ");
INSERT INTO sanitr_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","tatastena tasyAH karasya spR^iShTatavAt jvarastAM tatyAja, tadA sA samutthAya tAn siSheve| ");
INSERT INTO sanitr_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","anantaraM sandhyAyAM satyAM bahusho bhUtagrastamanujAn tasya samIpam AninyuH sa cha vAkyena bhUtAn tyAjayAmAsa, sarvvaprakArapIDitajanAMshcha nirAmayAn chakAra; ");
INSERT INTO sanitr_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","tasmAt, sarvvA durbbalatAsmAkaM tenaiva paridhAritA| asmAkaM sakalaM vyAdhiM saeva saMgR^ihItavAn| yadetadvachanaM yishayiyabhaviShyadvAdinoktamAsIt, tattadA saphalamabhavat| ");
INSERT INTO sanitr_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","anantaraM yIshushchaturdikShu jananivahaM vilokya taTinyAH pAraM yAtuM shiShyAn Adidesha| ");
INSERT INTO sanitr_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","tadAnIm eka upAdhyAya Agatya kathitavAn, he guro, bhavAn yatra yAsyati tatrAhamapi bhavataH pashchAd yAsyAmi| ");
INSERT INTO sanitr_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","tato yIshu rjagAda, kroShTuH sthAtuM sthAnaM vidyate, vihAyaso viha NgamAnAM nIDAni cha santi; kintu manuShyaputrasya shiraH sthApayituM sthAnaM na vidyate| ");
INSERT INTO sanitr_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","anantaram apara ekaH shiShyastaM babhAShe, he prabho, prathamato mama pitaraM shmashAne nidhAtuM gamanArthaM mAm anumanyasva| ");
INSERT INTO sanitr_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","tato yIshuruktavAn mR^itA mR^itAn shmashAne nidadhatu, tvaM mama pashchAd AgachCha| ");
INSERT INTO sanitr_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","anantaraM tasmin nAvamArUDhe tasya shiShyAstatpashchAt jagmuH| ");
INSERT INTO sanitr_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","pashchAt sAgarasya madhyaM teShu gateShu tAdR^ishaH prabalo jha nbhshanila udatiShThat, yena mahAtara Nga utthAya taraNiM ChAditavAn, kintu sa nidrita AsIt| ");
INSERT INTO sanitr_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","tadA shiShyA Agatya tasya nidrAbha NgaM kR^itvA kathayAmAsuH, he prabho, vayaM mriyAmahe, bhavAn asmAkaM prANAn rakShatu| ");
INSERT INTO sanitr_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","tadA sa tAn uktavAn, he alpavishvAsino yUyaM kuto vibhItha? tataH sa utthAya vAtaM sAgara ncha tarjayAmAsa, tato nirvvAtamabhavat| ");
INSERT INTO sanitr_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","aparaM manujA vismayaM vilokya kathayAmAsuH, aho vAtasaritpatI asya kimAj nAgrAhiNau? kIdR^isho.ayaM mAnavaH| ");
INSERT INTO sanitr_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","anantaraM sa pAraM gatvA giderIyadesham upasthitavAn; tadA dvau bhUtagrastamanujau shmashAnasthAnAd bahi rbhUtvA taM sAkShAt kR^itavantau, tAvetAdR^ishau prachaNDAvAstAM yat tena sthAnena kopi yAtuM nAshaknot| ");
INSERT INTO sanitr_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","tAvuchaiH kathayAmAsatuH, he Ishvarasya sUno yIsho, tvayA sAkam AvayoH kaH sambandhaH? nirUpitakAlAt prAgeva kimAvAbhyAM yAtanAM dAtum atrAgatosi? ");
INSERT INTO sanitr_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","tadAnIM tAbhyAM ki nchid dUre varAhANAm eko mahAvrajo.acharat| ");
INSERT INTO sanitr_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","tato bhUtau tau tasyAntike vinIya kathayAmAsatuH, yadyAvAM tyAjayasi, tarhi varAhANAM madhyevrajam AvAM preraya| ");
INSERT INTO sanitr_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","tadA yIshuravadat yAtaM, anantaraM tau yadA manujau vihAya varAhAn Ashritavantau, tadA te sarvve varAhA uchchasthAnAt mahAjavena dhAvantaH sAgarIyatoye majjanto mamruH| ");
INSERT INTO sanitr_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","tato varAharakShakAH palAyamAnA madhyenagaraM tau bhUtagrastau prati yadyad aghaTata, tAH sarvvavArttA avadan| ");
INSERT INTO sanitr_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","tato nAgarikAH sarvve manujA yIshuM sAkShAt karttuM bahirAyAtAH ta ncha vilokya prArthayA nchakrire bhavAn asmAkaM sImAto yAtu| ");
INSERT INTO sanitr_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","anantaraM yIshu rnaukAmAruhya punaH pAramAgatya nijagrAmam Ayayau| ");
INSERT INTO sanitr_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","tataH katipayA janA ekaM pakShAghAtinaM svaTTopari shAyayitvA tatsamIpam Anayan; tato yIshusteShAM pratItiM vij nAya taM pakShAghAtinaM jagAda, he putra, susthiro bhava, tava kaluShasya marShaNaM jAtam| ");
INSERT INTO sanitr_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","tAM kathAM nishamya kiyanta upAdhyAyA manaHsu chintitavanta eSha manuja IshvaraM nindati| ");
INSERT INTO sanitr_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","tataH sa teShAm etAdR^ishIM chintAM vij nAya kathitavAn, yUyaM manaHsu kR^ita etAdR^ishIM kuchintAM kurutha? ");
INSERT INTO sanitr_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","tava pApamarShaNaM jAtaM, yadvA tvamutthAya gachCha, dvayoranayo rvAkyayoH kiM vAkyaM vaktuM sugamaM? ");
INSERT INTO sanitr_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","kintu medinyAM kaluShaM kShamituM manujasutasya sAmarthyamastIti yUyaM yathA jAnItha, tadarthaM sa taM pakShAghAtinaM gaditavAn, uttiShTha, nijashayanIyaM AdAya gehaM gachCha| ");
INSERT INTO sanitr_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","tataH sa tatkShaNAd utthAya nijagehaM prasthitavAn| ");
INSERT INTO sanitr_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","mAnavA itthaM vilokya vismayaM menire, IshvareNa mAnavAya sAmarthyam IdR^ishaM dattaM iti kAraNAt taM dhanyaM babhAShire cha| ");
INSERT INTO sanitr_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","anantaraM yIshustatsthAnAd gachChan gachChan karasaMgrahasthAne samupaviShTaM mathinAmAnam ekaM manujaM vilokya taM babhAShe, mama pashchAd AgachCha, tataH sa utthAya tasya pashchAd vavrAja| ");
INSERT INTO sanitr_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","tataH paraM yIshau gR^ihe bhoktum upaviShTe bahavaH karasaMgrAhiNaH kaluShiNashcha mAnavA Agatya tena sAkaM tasya shiShyaishcha sAkam upavivishuH| ");
INSERT INTO sanitr_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","phirUshinastad dR^iShTvA tasya shiShyAn babhAShire, yuShmAkaM guruH kiM nimittaM karasaMgrAhibhiH kaluShibhishcha sAkaM bhuMkte? ");
INSERT INTO sanitr_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","yIshustat shrutvA tAn pratyavadat, nirAmayalokAnAM chikitsakena prayojanaM nAsti, kintu sAmayalokAnAM prayojanamAste| ");
INSERT INTO sanitr_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","ato yUyaM yAtvA vachanasyAsyArthaM shikShadhvam, dayAyAM me yathA prIti rna tathA yaj nakarmmaNi|yato.ahaM dhArmmikAn AhvAtuM nAgato.asmi kintu manaH parivarttayituM pApina AhvAtum Agato.asmi| ");
INSERT INTO sanitr_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","anantaraM yohanaH shiShyAstasya samIpam Agatya kathayAmAsuH, phirUshino vaya ncha punaH punarupavasAmaH, kintu tava shiShyA nopavasanti, kutaH? ");
INSERT INTO sanitr_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","tadA yIshustAn avochat yAvat sakhInAM saM Nge kanyAyA varastiShThati, tAvat kiM te vilApaM karttuM shakluvanti? kintu yadA teShAM saM NgAd varaM nayanti, tAdR^ishaH samaya AgamiShyati, tadA te upavatsyanti| ");
INSERT INTO sanitr_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","purAtanavasane kopi navInavastraM na yojayati, yasmAt tena yojitena purAtanavasanaM Chinatti tachChidra ncha bahukutsitaM dR^ishyate| ");
INSERT INTO sanitr_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","anya ncha purAtanakutvAM kopi navAnagostanIrasaM na nidadhAti, yasmAt tathA kR^ite kutU rvidIryyate tena gostanIrasaH patati kutUshcha nashyati; tasmAt navInAyAM kutvAM navIno gostanIrasaH sthApyate, tena dvayoravanaM bhavati| ");
INSERT INTO sanitr_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","aparaM tenaitatkathAkathanakAle eko.adhipatistaM praNamya babhAShe, mama duhitA prAyeNaitAvatkAle mR^itA, tasmAd bhavAnAgatya tasyA gAtre hastamarpayatu, tena sA jIviShyati| ");
INSERT INTO sanitr_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","tadAnIM yIshuH shiShyaiH sAkam utthAya tasya pashchAd vavrAja| ");
INSERT INTO sanitr_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ityanantare dvAdashavatsarAn yAvat pradarAmayena shIrNaikA nArI tasya pashchAd Agatya tasya vasanasya granthiM pasparsha; ");
INSERT INTO sanitr_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","yasmAt mayA kevalaM tasya vasanaM spR^iShTvA svAsthyaM prApsyate, sA nArIti manasi nishchitavatI| ");
INSERT INTO sanitr_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","tato yIshurvadanaM parAvarttya tAM jagAda, he kanye, tvaM susthirA bhava, tava vishvAsastvAM svasthAmakArShIt| etadvAkye gaditaeva sA yoShit svasthAbhUt| ");
INSERT INTO sanitr_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","aparaM yIshustasyAdhyakShasya gehaM gatvA vAdakaprabhR^itIn bahUn lokAn shabdAyamAnAn vilokya tAn avadat, ");
INSERT INTO sanitr_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","panthAnaM tyaja, kanyeyaM nAmriyata nidritAste; kathAmetAM shrutvA te tamupajahasuH| ");
INSERT INTO sanitr_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","kintu sarvveShu bahiShkR^iteShu so.abhyantaraM gatvA kanyAyAH karaM dhR^itavAn, tena sodatiShThat; ");
INSERT INTO sanitr_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","tatastatkarmmaNo yashaH kR^itsnaM taM deshaM vyAptavat| ");
INSERT INTO sanitr_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","tataH paraM yIshustasmAt sthAnAd yAtrAM chakAra; tadA he dAyUdaH santAna, asmAn dayasva, iti vadantau dvau janAvandhau prochairAhUyantau tatpashchAd vavrajatuH| ");
INSERT INTO sanitr_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","tato yIshau gehamadhyaM praviShTaM tAvapi tasya samIpam upasthitavantau, tadAnIM sa tau pR^iShTavAn karmmaitat karttuM mama sAmarthyam Aste, yuvAM kimiti pratIthaH? tadA tau pratyUchatuH, satyaM prabho| ");
INSERT INTO sanitr_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","tadAnIM sa tayo rlochanAni spR^ishan babhAShe, yuvayoH pratItyanusArAd yuvayo rma NgalaM bhUyAt| tena tatkShaNAt tayo rnetrANi prasannAnyabhavan, ");
INSERT INTO sanitr_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","pashchAd yIshustau dR^iDhamAj nApya jagAda, avadhattam etAM kathAM kopi manujo ma jAnIyAt| ");
INSERT INTO sanitr_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","kintu tau prasthAya tasmin kR^itsne deshe tasya kIrttiM prakAshayAmAsatuH| ");
INSERT INTO sanitr_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","aparaM tau bahiryAta etasminnantare manujA ekaM bhUtagrastamUkaM tasya samIpam AnItavantaH| ");
INSERT INTO sanitr_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","tena bhUte tyAjite sa mUkaH kathAM kathayituM prArabhata, tena janA vismayaM vij nAya kathayAmAsuH, isrAyelo vaMshe kadApi nedR^igadR^ishyata; ");
INSERT INTO sanitr_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","kintu phirUshinaH kathayA nchakruH bhUtAdhipatinA sa bhUtAn tyAjayati| ");
INSERT INTO sanitr_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","tataH paraM yIshusteShAM bhajanabhavana upadishan rAjyasya susaMvAdaM prachArayan lokAnAM yasya ya Amayo yA cha pIDAsIt, tAn shamayan shamayaMshcha sarvvANi nagarANi grAmAMshcha babhrAma| ");
INSERT INTO sanitr_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","anya ncha manujAn vyAkulAn arakShakameShAniva cha tyaktAn nirIkShya teShu kAruNikaH san shiShyAn avadat, ");
INSERT INTO sanitr_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","shasyAni prachurANi santi, kintu ChettAraH stokAH| ");
INSERT INTO sanitr_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","kShetraM pratyaparAn ChedakAn prahetuM shasyasvAminaM prArthayadhvam| ");
INSERT INTO sanitr_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","anantaraM yIshu rdvAdashashiShyAn AhUyAmedhyabhUtAn tyAjayituM sarvvaprakArarogAn pIDAshcha shamayituM tebhyaH sAmarthyamadAt| ");
INSERT INTO sanitr_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","teShAM dvAdashapreShyANAM nAmAnyetAni| prathamaM shimon yaM pitaraM vadanti, tataH paraM tasya sahaja AndriyaH, sivadiyasya putro yAkUb ");
INSERT INTO sanitr_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","tasya sahajo yohan; philip barthalamay thomAH karasaMgrAhI mathiH, Alpheyaputro yAkUb, ");
INSERT INTO sanitr_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","kinAnIyaH shimon, ya IShkariyotIyayihUdAH khrIShTaM parakare.arpayat| ");
INSERT INTO sanitr_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","etAn dvAdashashiShyAn yIshuH preShayan ityAj nApayat, yUyam anyadeshIyAnAM padavIM shemiroNIyAnAM kimapi nagara ncha na pravishye ");
INSERT INTO sanitr_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","isrAyelgotrasya hAritA ye ye meShAsteShAmeva samIpaM yAta| ");
INSERT INTO sanitr_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","gatvA gatvA svargasya rAjatvaM savidhamabhavat, etAM kathAM prachArayata| ");
INSERT INTO sanitr_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","AmayagrastAn svasthAn kuruta, kuShThinaH pariShkuruta, mR^italokAn jIvayata, bhUtAn tyAjayata, vinA mUlyaM yUyam alabhadhvaM vinaiva mUlyaM vishrANayata| ");
INSERT INTO sanitr_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","kintu sveShAM kaTibandheShu svarNarUpyatAmrANAM kimapi na gR^ihlIta| ");
INSERT INTO sanitr_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","anyachcha yAtrAyai chelasampuTaM vA dvitIyavasanaM vA pAduke vA yaShTiH, etAn mA gR^ihlIta, yataH kAryyakR^it bharttuM yogyo bhavati| ");
INSERT INTO sanitr_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","aparaM yUyaM yat puraM ya ncha grAmaM pravishatha, tatra yo jano yogyapAtraM tamavagatya yAnakAlaM yAvat tatra tiShThata| ");
INSERT INTO sanitr_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","yadA yUyaM tadgehaM pravishatha, tadA tamAshiShaM vadata| ");
INSERT INTO sanitr_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","yadi sa yogyapAtraM bhavati, tarhi tatkalyANaM tasmai bhaviShyati, nochet sAshIryuShmabhyameva bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","kintu ye janA yuShmAkamAtithyaM na vidadhati yuShmAkaM kathA ncha na shR^iNvanti teShAM gehAt purAdvA prasthAnakAle svapadUlIH pAtayata| ");
INSERT INTO sanitr_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","yuShmAnahaM tathyaM vachmi vichAradine tatpurasya dashAtaH sidomamorApurayordashA sahyatarA bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","pashyata, vR^ikayUthamadhye meShaH yathAvistathA yuShmAna prahiNomi, tasmAd yUyam ahiriva satarkAH kapotAivAhiMsakA bhavata| ");
INSERT INTO sanitr_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","nR^ibhyaH sAvadhAnA bhavata; yatastai ryUyaM rAjasaMsadi samarpiShyadhve teShAM bhajanagehe prahAriShyadhve| ");
INSERT INTO sanitr_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","yUyaM mannAmahetoH shAstR^iNAM rAj nA ncha samakShaM tAnanyadeshinashchAdhi sAkShitvArthamAneShyadhve| ");
INSERT INTO sanitr_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","kintvitthaM samarpitA yUyaM kathaM kimuttaraM vakShyatha tatra mA chintayata, yatastadA yuShmAbhi ryad vaktavyaM tat taddaNDe yuShmanmanaH su samupasthAsyati| ");
INSERT INTO sanitr_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","yasmAt tadA yo vakShyati sa na yUyaM kintu yuShmAkamantarasthaH pitrAtmA| ");
INSERT INTO sanitr_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","sahajaH sahajaM tAtaH suta ncha mR^itau samarpayiShyati, apatyAgi svasvapitroे rvipakShIbhUya tau ghAtayiShyanti| ");
INSERT INTO sanitr_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","mannamahetoH sarvve janA yuShmAn R^iृtIyiShyante, kintu yaH sheShaM yAvad dhairyyaM ghR^itvA sthAsyati, sa trAyiShyate| ");
INSERT INTO sanitr_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","tai ryadA yUyamekapure tADiShyadhve, tadA yUyamanyapuraM palAyadhvaM yuShmAnahaM tathyaM vachmi yAvanmanujasuto naiti tAvad isrAyeldeshIyasarvvanagarabhramaNaM samApayituM na shakShyatha| ");
INSERT INTO sanitr_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","guroH shiShyo na mahAn, prabhordAso na mahAn| ");
INSERT INTO sanitr_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","yadi shiShyo nijaguro rdAsashcha svaprabhoH samAno bhavati tarhi tad yatheShTaM| chettairgR^ihapatirbhUtarAja uchyate, tarhi parivArAH kiM tathA na vakShyante? ");
INSERT INTO sanitr_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","kintu tebhyo yUyaM mA bibhIta, yato yanna prakAshiShyate, tAdR^ik ChAditaM kimapi nAsti, yachcha na vya nchiShyate, tAdR^ig guptaM kimapi nAsti| ");
INSERT INTO sanitr_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","yadahaM yuShmAn tamasi vachmi tad yuShmAbhirdIptau kathyatAM; karNAbhyAM yat shrUyate tad gehopari prachAryyatAM| ");
INSERT INTO sanitr_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ye kAyaM hantuM shaknuvanti nAtmAnaM, tebhyo mA bhaiShTa; yaH kAyAtmAnau niraye nAshayituM, shaknoti, tato bibhIta| ");
INSERT INTO sanitr_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","dvau chaTakau kimekatAmramudrayA na vikrIyete? tathApi yuShmattAtAnumatiM vinA teShAmekopi bhuvi na patati| ");
INSERT INTO sanitr_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","yuShmachChirasAM sarvvakachA gaNitAMH santi| ");
INSERT INTO sanitr_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ato mA bibhIta, yUyaM bahuchaTakebhyo bahumUlyAH| ");
INSERT INTO sanitr_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","yo manujasAkShAnmAma NgIkurute tamahaM svargasthatAtasAkShAda NgIkariShye| ");
INSERT INTO sanitr_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","pR^ithvyAmahaM shAntiM dAtumAgata_iti mAnubhavata, shAntiM dAtuM na kintvasiM| ");
INSERT INTO sanitr_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","pitR^imAtR^ishchashrUbhiH sAkaM sutasutAbadhU rvirodhayitu nchAgateाsmi| ");
INSERT INTO sanitr_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","tataH svasvaparivAraeva nR^ishatru rbhavitA| ");
INSERT INTO sanitr_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","yaH pitari mAtari vA mattodhikaM prIyate, sa na madarhaH; ");
INSERT INTO sanitr_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","yashcha sute sutAyAM vA mattodhikaM prIyate, seाpi na madarhaH| ");
INSERT INTO sanitr_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","yaH svakrushaM gR^ihlan matpashchAnnaiti, seाpi na madarhaH| ");
INSERT INTO sanitr_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","yaH svaprANAnavati, sa tAn hArayiShyate, yastu matkR^ite svaprANAn hArayati, sa tAnavati| ");
INSERT INTO sanitr_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","yo yuShmAkamAtithyaM vidadhAti, sa mamAtithyaM vidadhAti, yashcha mamAtithyaM vidadhAti, sa matprerakasyAtithyaM vidadhAti| ");
INSERT INTO sanitr_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","yo bhaviShyadvAdIti j nAtvA tasyAtithyaM vidhatte, sa bhaviShyadvAdinaH phalaM lapsyate, yashcha dhArmmika iti viditvA tasyAtithyaM vidhatte sa dhArmmikamAnavasya phalaM prApsyati| ");
INSERT INTO sanitr_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","yashcha kashchit eteShAM kShudranarANAm yaM ka nchanaikaM shiShya iti viditvA kaMsaikaM shItalasalilaM tasmai datte, yuShmAnahaM tathyaM vadAmi, sa kenApi prakAreNa phalena na va nchiShyate| ");
INSERT INTO sanitr_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","itthaM yIshuH svadvAdashashiShyANAmAj nApanaM samApya pure pura upadeShTuM susaMvAdaM prachArayituM tatsthAnAt pratasthe| ");
INSERT INTO sanitr_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","anantaraM yohan kArAyAM tiShThan khriShTasya karmmaNAM vArttaM prApya yasyAgamanavArttAsIt saeva kiM tvaM? vA vayamanyam apekShiShyAmahe? ");
INSERT INTO sanitr_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","etat praShTuM nijau dvau shiShyau prAhiNot| ");
INSERT INTO sanitr_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","yIshuH pratyavochat, andhA netrANi labhante, kha nchA gachChanti, kuShThinaH svasthA bhavanti, badhirAH shR^iNvanti, mR^itA jIvanta uttiShThanti, daridrANAM samIpe susaMvAdaH prachAryyata, ");
INSERT INTO sanitr_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","etAni yadyad yuvAM shR^iNuthaH pashyathashcha gatvA tadvArttAM yohanaM gadataM| ");
INSERT INTO sanitr_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","yasyAhaM na vighnIbhavAmi, saeva dhanyaH| ");
INSERT INTO sanitr_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","anantaraM tayoH prasthitayo ryIshu ryohanam uddishya janAn jagAda, yUyaM kiM draShTuM vahirmadhyeprAntaram agachChata? kiM vAtena kampitaM nalaM? ");
INSERT INTO sanitr_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","vA kiM vIkShituM vahirgatavantaH? kiM parihitasUkShmavasanaM manujamekaM? pashyata, ye sUkShmavasanAni paridadhati, te rAjadhAnyAM tiShThanti| ");
INSERT INTO sanitr_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","tarhi yUyaM kiM draShTuM bahiragamata, kimekaM bhaviShyadvAdinaM? tadeva satyaM| yuShmAnahaM vadAmi, sa bhaviShyadvAdinopi mahAn; ");
INSERT INTO sanitr_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","yataH, pashya svakIyadUtoyaM tvadagre preShyate mayA| sa gatvA tava panthAnaM smayak pariShkariShyati|| etadvachanaM yamadhi likhitamAste so.ayaM yohan| ");
INSERT INTO sanitr_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","aparaM yuShmAnahaM tathyaM bravImi, majjayitu ryohanaH shreShThaH kopi nArIto nAjAyata; tathApi svargarAjyamadhye sarvvebhyo yaH kShudraH sa yohanaH shreShThaH| ");
INSERT INTO sanitr_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","apara ncha A yohano.adya yAvat svargarAjyaM balAdAkrAntaM bhavati Akraminashcha janA balena tadadhikurvvanti| ");
INSERT INTO sanitr_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","yato yohanaM yAvat sarvvabhaviShyadvAdibhi rvyavasthayA cha upadeshaH prAkAshyata| ");
INSERT INTO sanitr_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","yadi yUyamidaM vAkyaM grahItuM shaknutha, tarhi shreyaH, yasyAgamanasya vachanamAste so.ayam eliyaH| ");
INSERT INTO sanitr_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","yasya shrotuM karNau staH sa shR^iNotu| ");
INSERT INTO sanitr_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","ete vidyamAnajanAH kai rmayopamIyante? ye bAlakA haTTa upavishya svaM svaM bandhumAhUya vadanti, ");
INSERT INTO sanitr_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","vayaM yuShmAkaM samIpe vaMshIravAdayAma, kintu yUyaM nAnR^ityata; yuShmAkaM samIpe cha vayamarodima, kintu yUyaM na vyalapata, tAdR^ishai rbAlakaista upamAyiShyante| ");
INSERT INTO sanitr_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","yato yohan Agatya na bhuktavAn na pItavAMshcha, tena lokA vadanti, sa bhUtagrasta iti| ");
INSERT INTO sanitr_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","manujasuta Agatya bhuktavAn pItavAMshcha, tena lokA vadanti, pashyata eSha bhoktA madyapAtA chaNDAlapApinAM bandhashcha, kintu j nAnino j nAnavyavahAraM nirdoShaM jAnanti| ");
INSERT INTO sanitr_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","sa yatra yatra pure bahvAshcharyyaM karmma kR^itavAn, tannivAsinAM manaHparAvR^ittyabhAvAt tAni nagarANi prati hantetyuktA kathitavAn, ");
INSERT INTO sanitr_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","hA korAsIn, hA baitsaide, yuShmanmadhye yadyadAshcharyyaM karmma kR^itaM yadi tat sorasIdonnagara akAriShyata, tarhi pUrvvameva tannivAsinaH shANavasane bhasmani chopavishanto manAMsi parAvarttiShyanta| ");
INSERT INTO sanitr_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","tasmAdahaM yuShmAn vadAmi, vichAradine yuShmAkaM dashAtaH sorasIdono rdashA sahyatarA bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","apara ncha bata kapharnAhUm, tvaM svargaM yAvadunnatosi, kintu narake nikShepsyase, yasmAt tvayi yAnyAshcharyyANi karmmaNyakAriShata, yadi tAni sidomnagara akAriShyanta, tarhi tadadya yAvadasthAsyat| ");
INSERT INTO sanitr_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","kintvahaM yuShmAn vadAmi, vichAradine tava daNDataH sidomo daNDo sahyataro bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","etasminneva samaye yIshuH punaruvAcha, he svargapR^ithivyorekAdhipate pitastvaM j nAnavato viduShashcha lokAn pratyetAni na prakAshya bAlakAn prati prakAshitavAn, iti hetostvAM dhanyaM vadAmi| ");
INSERT INTO sanitr_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","he pitaH, itthaM bhavet yata idaM tvadR^iShTAvuttamaM| ");
INSERT INTO sanitr_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","pitrA mayi sarvvANi samarpitAni, pitaraM vinA kopi putraM na jAnAti, yAn prati putreNa pitA prakAshyate tAn vinA putrAd anyaH kopi pitaraM na jAnAti| ");
INSERT INTO sanitr_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","he parishrAntA bhArAkrAntAshcha lokA yUyaM matsannidhim AgachChata, ahaM yuShmAn vishramayiShyAmi| ");
INSERT INTO sanitr_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ahaM kShamaNashIlo namramanAshcha, tasmAt mama yugaM sveShAmupari dhArayata mattaH shikShadhva ncha, tena yUyaM sve sve manasi vishrAmaM lapsyadhbe| ");
INSERT INTO sanitr_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","yato mama yugam anAyAsaM mama bhArashcha laghuH| ");
INSERT INTO sanitr_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","anantaraM yIshu rvishrAmavAre shsyamadhyena gachChati, tadA tachChiShyA bubhukShitAH santaH shsyama njarIshChatvA ChitvA khAditumArabhanta| ");
INSERT INTO sanitr_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","tad vilokya phirUshino yIshuM jagaduH, pashya vishrAmavAre yat karmmAkarttavyaM tadeva tava shiShyAH kurvvanti| ");
INSERT INTO sanitr_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","sa tAn pratyAvadata, dAyUd tatsa Nginashcha bubhukShitAH santo yat karmmAkurvvan tat kiM yuShmAbhi rnApAThi? ");
INSERT INTO sanitr_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ye darshanIyAH pUpAH yAjakAn vinA tasya tatsa NgimanujAnA nchAbhojanIyAsta IshvarAvAsaM praviShTena tena bhuktAH| ");
INSERT INTO sanitr_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","anyachcha vishrAmavAre madhyemandiraM vishrAmavArIyaM niyamaM la Nvantopi yAjakA nirdoShA bhavanti, shAstramadhye kimidamapi yuShmAbhi rna paThitaM? ");
INSERT INTO sanitr_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","yuShmAnahaM vadAmi, atra sthAne mandirAdapi garIyAn eka Aste| ");
INSERT INTO sanitr_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","kintu dayAyAM me yathA prIti rna tathA yaj nakarmmaNi| etadvachanasyArthaM yadi yuyam aj nAsiShTa tarhi nirdoShAn doShiNo nAkArShTa| ");
INSERT INTO sanitr_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","anyachcha manujasuto vishrAmavArasyApi patirAste| ");
INSERT INTO sanitr_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","anantaraM sa tatsthAnAt prasthAya teShAM bhajanabhavanaM praviShTavAn, tadAnIm ekaH shuShkakarAmayavAn upasthitavAn| ");
INSERT INTO sanitr_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","tato yIshum apavadituM mAnuShAH paprachChuH, vishrAmavAre nirAmayatvaM karaNIyaM na vA? ");
INSERT INTO sanitr_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","tena sa pratyuvAcha, vishrAmavAre yadi kasyachid avi rgartte patati, tarhi yastaM ghR^itvA na tolayati, etAdR^isho manujo yuShmAkaM madhye ka Aste? ");
INSERT INTO sanitr_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ave rmAnavaH kiM nahi shreyAn? ato vishrAmavAre hitakarmma karttavyaM| ");
INSERT INTO sanitr_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","anantaraM sa taM mAnavaM gaditavAn, karaM prasAraya; tena kare prasArite sonyakaravat svastho.abhavat| ");
INSERT INTO sanitr_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","tadA phirUshino bahirbhUya kathaM taM haniShyAma iti kumantraNAM tatprAtikUlyena chakruH| ");
INSERT INTO sanitr_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","tato yIshustad viditvA sthanAntaraM gatavAn; anyeShu bahunareShu tatpashchAd gateShu tAn sa nirAmayAn kR^itvA ityAj nApayat, ");
INSERT INTO sanitr_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","yUyaM mAM na parichAyayata| ");
INSERT INTO sanitr_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","tasmAt mama prIyo manonIto manasastuShTikArakaH| madIyaH sevako yastu vidyate taM samIkShatAM| tasyopari svakIyAtmA mayA saMsthApayiShyate| tenAnyadeshajAteShu vyavasthA saMprakAshyate| ");
INSERT INTO sanitr_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","kenApi na virodhaM sa vivAda ncha kariShyati| na cha rAjapathe tena vachanaM shrAvayiShyate| ");
INSERT INTO sanitr_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","vyavasthA chalitA yAvat nahi tena kariShyate| tAvat nalo vidIrNo.api bhaMkShyate nahi tena cha| tathA sadhUmavartti ncha na sa nirvvApayiShyate| ");
INSERT INTO sanitr_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","pratyAshA ncha kariShyanti tannAmni bhinnadeshajAH| ");
INSERT INTO sanitr_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","yAnyetAni vachanAni yishayiyabhaviShyadvAdinA proktAnyAsan, tAni saphalAnyabhavan| ");
INSERT INTO sanitr_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","anantaraM lokai statsamIpam AnIto bhUtagrastAndhamUkaikamanujastena svasthIkR^itaH, tataH so.andho mUko draShTuM vaktu nchArabdhavAn| ");
INSERT INTO sanitr_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","anena sarvve vismitAH kathayA nchakruH, eShaH kiM dAyUdaH santAno nahi? ");
INSERT INTO sanitr_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","kintu phirUshinastat shrutvA gaditavantaH, bAlsibUbnAmno bhUtarAjasya sAhAyyaM vinA nAyaM bhUtAn tyAjayati| ");
INSERT INTO sanitr_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","tadAnIM yIshusteShAm iti mAnasaM vij nAya tAn avadat ki nchana rAjyaM yadi svavipakShAd bhidyate, tarhi tat uchChidyate; yachcha ki nchana nagaraM vA gR^ihaM svavipakShAd vibhidyate, tat sthAtuM na shaknoti| ");
INSERT INTO sanitr_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","tadvat shayatAno yadi shayatAnaM bahiH kR^itvA svavipakShAt pR^ithak pR^ithak bhavati, tarhi tasya rAjyaM kena prakAreNa sthAsyati? ");
INSERT INTO sanitr_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","aha ncha yadi bAlsibUbA bhUtAn tyAjayAmi, tarhi yuShmAkaM santAnAH kena bhUtAn tyAjayanti? tasmAd yuShmAkam etadvichArayitArasta eva bhaviShyanti| ");
INSERT INTO sanitr_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","kintavahaM yadIshvarAtmanA bhUtAn tyAjayAmi, tarhIshvarasya rAjyaM yuShmAkaM sannidhimAgatavat| ");
INSERT INTO sanitr_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","anya ncha kopi balavanta janaM prathamato na badvvA kena prakAreNa tasya gR^ihaM pravishya taddravyAdi loThayituM shaknoti? kintu tat kR^itvA tadIyagR^isya dravyAdi loThayituM shaknoti| ");
INSERT INTO sanitr_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","yaH kashchit mama svapakShIyo nahi sa vipakShIya Aste, yashcha mayA sAkaM na saMgR^ihlAti, sa vikirati| ");
INSERT INTO sanitr_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ataeva yuShmAnahaM vadAmi, manujAnAM sarvvaprakArapApAnAM nindAyAshcha marShaNaM bhavituM shaknoti, kintu pavitrasyAtmano viruddhanindAyA marShaNaM bhavituM na shaknoti| ");
INSERT INTO sanitr_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","yo manujasutasya viruddhAM kathAM kathayati, tasyAparAdhasya kShamA bhavituM shaknoti, kintu yaH kashchit pavitrasyAtmano viruddhAM kathAM kathayati nehaloke na pretya tasyAparAdhasya kShamA bhavituM shaknoti| ");
INSERT INTO sanitr_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","pAdapaM yadi bhadraM vadatha, tarhi tasya phalamapi sAdhu vaktavyaM, yadi cha pAdapaM asAdhuM vadatha, tarhi tasya phalamapyasAdhu vaktavyaM; yataH svIyasvIyaphalena pAdapaH parichIyate| ");
INSERT INTO sanitr_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","re bhujagavaMshA yUyamasAdhavaH santaH kathaM sAdhu vAkyaM vaktuM shakShyatha? yasmAd antaHkaraNasya pUrNabhAvAnusArAd vadanAd vacho nirgachChati| ");
INSERT INTO sanitr_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","tena sAdhurmAnavo.antaHkaraNarUpAt sAdhubhANDAgArAt sAdhu dravyaM nirgamayati, asAdhurmAnuShastvasAdhubhANDAgArAd asAdhuvastUni nirgamayati| ");
INSERT INTO sanitr_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","kintvahaM yuShmAn vadAmi, manujA yAvantyAlasyavachAMsi vadanti, vichAradine taduttaramavashyaM dAtavyaM, ");
INSERT INTO sanitr_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","yatastvaM svIyavachobhi rniraparAdhaH svIyavachobhishcha sAparAdho gaNiShyase| ");
INSERT INTO sanitr_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","tadAnIM katipayA upAdhyAyAH phirUshinashcha jagaduH, he guro vayaM bhavattaH ki nchana lakShma didR^ikShAmaH| ");
INSERT INTO sanitr_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","tadA sa pratyuktavAn, duShTo vyabhichArI cha vaMsho lakShma mR^igayate, kintu bhaviShyadvAdino yUnaso lakShma vihAyAnyat kimapi lakShma te na pradarshayiShyante| ");
INSERT INTO sanitr_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","yato yUnam yathA tryahorAtraM bR^ihanmInasya kukShAvAsIt, tathA manujaputropi tryahorAtraM medinyA madhye sthAsyati| ");
INSERT INTO sanitr_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","aparaM nInivIyA mAnavA vichAradina etadvaMshIyAnAM pratikUlam utthAya tAn doShiNaH kariShyanti, yasmAtte yUnasa upadeshAt manAMsi parAvarttayA nchakrire, kintvatra yUnasopi gurutara eka Aste| ");
INSERT INTO sanitr_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","punashcha dakShiNadeshIyA rAj nI vichAradina etadvaMshIyAnAM pratikUlamutthAya tAn doShiNaH kariShyati yataH sA rAj nI sulemano vidyAyAH kathAM shrotuM medinyAH sImna AgachChat, kintu sulemanopi gurutara eko jano.atra Aste| ");
INSERT INTO sanitr_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","aparaM manujAd bahirgato .apavitrabhUtaH shuShkasthAnena gatvA vishrAmaM gaveShayati, kintu tadalabhamAnaH sa vakti, yasmA; niketanAd AgamaM, tadeva veshma pakAvR^itya yAmi| ");
INSERT INTO sanitr_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","pashchAt sa tat sthAnam upasthAya tat shUnyaM mArjjitaM shobhita ncha vilokya vrajan svatopi duShTatarAn anyasaptabhUtAn sa NginaH karoti| ");
INSERT INTO sanitr_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","tataste tat sthAnaM pravishya nivasanti, tena tasya manujasya sheShadashA pUrvvadashAtotIvAshubhA bhavati, eteShAM duShTavaMshyAnAmapi tathaiva ghaTiShyate| ");
INSERT INTO sanitr_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","mAnavebhya etAsAM kathanAM kathanakAle tasya mAtA sahajAshcha tena sAkaM kA nchit kathAM kathayituM vA nChanto bahireva sthitavantaH| ");
INSERT INTO sanitr_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","tataH kashchit tasmai kathitavAn, pashya tava jananI sahajAshcha tvayA sAkaM kA nchana kathAM kathayituM kAmayamAnA bahistiShThanti| ");
INSERT INTO sanitr_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","kintu sa taM pratyavadat, mama kA jananI? ke vA mama sahajAH? ");
INSERT INTO sanitr_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","pashchAt shiShyAn prati karaM prasAryya kathitavAn, pashya mama jananI mama sahajAshchaite; ");
INSERT INTO sanitr_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","yaH kashchit mama svargasthasya pituriShTaM karmma kurute, saeva mama bhrAtA bhaginI jananI cha| ");
INSERT INTO sanitr_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","apara ncha tasmin dine yIshuH sadmano gatvA saritpate rodhasi samupavivesha| ");
INSERT INTO sanitr_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","tatra tatsannidhau bahujanAnAM nivahopasthiteH sa taraNimAruhya samupAvishat, tena mAnavA rodhasi sthitavantaH| ");
INSERT INTO sanitr_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","tadAnIM sa dR^iShTAntaistAn itthaM bahusha upadiShTavAn| pashyata, kashchit kR^iShIvalo bIjAni vaptuM bahirjagAma, ");
INSERT INTO sanitr_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","tasya vapanakAle katipayabIjeShu mArgapArshve patiteShu vihagAstAni bhakShitavantaH| ");
INSERT INTO sanitr_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","aparaM katipayabIjeShu stokamR^idyuktapAShANe patiteShu mR^idalpatvAt tatkShaNAt tAnya NkuritAni, ");
INSERT INTO sanitr_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","kintu ravAvudite dagdhAni teShAM mUlApraviShTatvAt shuShkatAM gatAni cha| ");
INSERT INTO sanitr_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","aparaM katipayabIjeShu kaNTakAnAM madhye patiteShu kaNTakAnyedhitvA tAni jagrasuH| ");
INSERT INTO sanitr_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","apara ncha katipayabIjAni urvvarAyAM patitAni; teShAM madhye kAnichit shataguNAni kAnichit ShaShTiguNAni kAnichit triMshaguMNAni phalAni phalitavanti| ");
INSERT INTO sanitr_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","shrotuM yasya shrutI AsAte sa shR^iNuyAt| ");
INSERT INTO sanitr_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","anantaraM shiShyairAgatya so.apR^ichChyata, bhavatA tebhyaH kuto dR^iShTAntakathA kathyate? ");
INSERT INTO sanitr_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","tataH sa pratyavadat, svargarAjyasya nigUDhAM kathAM vedituM yuShmabhyaM sAmarthyamadAyi, kintu tebhyo nAdAyi| ");
INSERT INTO sanitr_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","yasmAd yasyAntike varddhate, tasmAyeva dAyiShyate, tasmAt tasya bAhulyaM bhaviShyati, kintu yasyAntike na varddhate, tasya yat ki nchanAste, tadapi tasmAd AdAyiShyate| ");
INSERT INTO sanitr_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","te pashyantopi na pashyanti, shR^iNvantopi na shR^iNvanti, budhyamAnA api na budhyante cha, tasmAt tebhyo dR^iShTAntakathA kathyate| ");
INSERT INTO sanitr_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","yathA karNaiH shroShyatha yUyaM vai kintu yUyaM na bhotsyatha| netrairdrakShyatha yUya ncha parij nAtuM na shakShyatha| te mAnuShA yathA naiva paripashyanti lochanaiH| karNai ryathA na shR^iNvanti na budhyante cha mAnasaiH| vyAvarttiteShu chitteShu kAle kutrApi tairjanaiH| mattaste manujAH svasthA yathA naiva bhavanti cha| tathA teShAM manuShyANAM kriyante sthUlabuddhayaH| badhirIbhUtakarNAshcha jAtAshcha mudritA dR^ishaH| ");
INSERT INTO sanitr_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","yadetAni vachanAni yishayiyabhaviShyadvAdinA proktAni teShu tAni phalanti| ");
INSERT INTO sanitr_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","kintu yuShmAkaM nayanAni dhanyAni, yasmAt tAni vIkShante; dhanyAshcha yuShmAkaM shabdagrahAH, yasmAt tairAkarNyate| ");
INSERT INTO sanitr_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","mayA yUyaM tathyaM vachAmi yuShmAbhi ryadyad vIkShyate, tad bahavo bhaviShyadvAdino dhArmmikAshcha mAnavA didR^ikShantopi draShTuM nAlabhanta, punashcha yUyaM yadyat shR^iNutha, tat te shushrUShamANA api shrotuM nAlabhanta| ");
INSERT INTO sanitr_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","kR^iShIvalIyadR^iShTAntasyArthaM shR^iNuta| ");
INSERT INTO sanitr_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","mArgapArshve bIjAnyuptAni tasyArtha eShaH, yadA kashchit rAjyasya kathAM nishamya na budhyate, tadA pApAtmAgatya tadIyamanasa uptAM kathAM haran nayati| ");
INSERT INTO sanitr_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","aparaM pAShANasthale bIjAnyuptAni tasyArtha eShaH; kashchit kathAM shrutvaiva harShachittena gR^ihlAti, ");
INSERT INTO sanitr_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","kintu tasya manasi mUlApraviShTatvAt sa ki nchitkAlamAtraM sthirastiShThati; pashchAta tatkathAkAraNAt kopi klestADanA vA chet jAyate, tarhi sa tatkShaNAd vighnameti| ");
INSERT INTO sanitr_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","aparaM kaNTakAnAM madhye bIjAnyuptAni tadartha eShaH; kenachit kathAyAM shrutAyAM sAMsArikachintAbhi rbhrAntibhishcha sA grasyate, tena sA mA viphalA bhavati| ");
INSERT INTO sanitr_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","aparam urvvarAyAM bIjAnyuptAni tadartha eShaH; ye tAM kathAM shrutvA vudhyante, te phalitAH santaH kechit shataguNAni kechita ShaShTiguNAni kechichcha triMshadguNAni phalAni janayanti| ");
INSERT INTO sanitr_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","anantaraM soparAmekAM dR^iShTAntakathAmupasthApya tebhyaH kathayAmAsa; svargIyarAjyaM tAdR^ishena kenachid gR^ihasthenopamIyate, yena svIyakShetre prashastabIjAnyaupyanta| ");
INSERT INTO sanitr_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","kintu kShaNadAyAM sakalalokeShu supteShu tasya ripurAgatya teShAM godhUmabIjAnAM madhye vanyayavamabIjAnyuptvA vavrAja| ");
INSERT INTO sanitr_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","tato yadA bIjebhyo.a NkarA jAyamAnAH kaNishAni ghR^itavantaH; tadA vanyayavasAnyapi dR^ishyamAnAnyabhavan| ");
INSERT INTO sanitr_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","tato gR^ihasthasya dAseyA Agamya tasmai kathayA nchakruH, he mahechCha, bhavatA kiM kShetre bhadrabIjAni naupyanta? tathAtve vanyayavasAni kR^ita Ayan? ");
INSERT INTO sanitr_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","tadAnIM tena te pratigaditAH, kenachit ripuNA karmmadamakAri| dAseyAH kathayAmAsuH, vayaM gatvA tAnyutpAyya kShipAmo bhavataH kIdR^ishIchChA jAyate? ");
INSERT INTO sanitr_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","tenAvAdi, nahi, sha Nke.ahaM vanyayavasotpATanakAle yuShmAbhistaiH sAkaM godhUmA apyutpATiShyante| ");
INSERT INTO sanitr_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ataH shsyakarttanakAlaM yAvad ubhayAnyapi saha varddhantAM, pashchAt karttanakAle karttakAn vakShyAmi, yUyamAdau vanyayavasAni saMgR^ihya dAhayituM vITikA badvvA sthApayata; kintu sarvve godhUmA yuShmAbhi rbhANDAgAraM nItvA sthApyantAm| ");
INSERT INTO sanitr_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","anantaraM soparAmekAM dR^iShTAntakathAmutthApya tebhyaH kathitavAn kashchinmanujaH sarShapabIjamekaM nItvA svakShetra uvApa| ");
INSERT INTO sanitr_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","sarShapabIjaM sarvvasmAd bIjAt kShudramapi sada NkuritaM sarvvasmAt shAkAt bR^ihad bhavati; sa tAdR^ishastaru rbhavati, yasya shAkhAsu nabhasaH khagA Agatya nivasanti; svargIyarAjyaM tAdR^ishasya sarShapaikasya samam| ");
INSERT INTO sanitr_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","punarapi sa upamAkathAmekAM tebhyaH kathayA nchakAra; kAchana yoShit yat kiNvamAdAya droNatrayamitagodhUmachUrNAnAM madhye sarvveShAM mishrIbhavanaparyyantaM samAchChAdya nidhattavatI, tatkiNvamiva svargarAjyaM| ");
INSERT INTO sanitr_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","itthaM yIshu rmanujanivahAnAM sannidhAvupamAkathAbhiretAnyAkhyAnAni kathitavAn upamAM vinA tebhyaH kimapi kathAM nAkathayat| ");
INSERT INTO sanitr_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","etena dR^iShTAntIyena vAkyena vyAdAya vadanaM nijaM| ahaM prakAshayiShyAmi guptavAkyaM purAbhavaM| yadetadvachanaM bhaviShyadvAdinA proktamAsIt, tat siddhamabhavat| ");
INSERT INTO sanitr_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","sarvvAn manujAn visR^ijya yIshau gR^ihaM praviShTe tachChiShyA Agatya yIshave kathitavantaH, kShetrasya vanyayavasIyadR^iShTAntakathAm bhavAna asmAn spaShTIkR^itya vadatu| ");
INSERT INTO sanitr_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","tataH sa pratyuvAcha, yena bhadrabIjAnyupyante sa manujaputraH, ");
INSERT INTO sanitr_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","kShetraM jagat, bhadrabIjAnI rAjyasya santAnAH, ");
INSERT INTO sanitr_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","vanyayavasAni pApAtmanaH santAnAH| yena ripuNA tAnyuptAni sa shayatAnaH, karttanasamayashcha jagataH sheShaH, karttakAH svargIyadUtAH| ");
INSERT INTO sanitr_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","yathA vanyayavasAni saMgR^ihya dAhyante, tathA jagataH sheShe bhaviShyati; ");
INSERT INTO sanitr_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","arthAt manujasutaH svAMyadUtAn preShayiShyati, tena te cha tasya rAjyAt sarvvAn vighnakAriNo.adhArmmikalokAMshcha saMgR^ihya ");
INSERT INTO sanitr_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","yatra rodanaM dantagharShaNa ncha bhavati, tatrAgnikuNDe nikShepsyanti| ");
INSERT INTO sanitr_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","tadAnIM dhArmmikalokAH sveShAM pitU rAjye bhAskara_iva tejasvino bhaviShyanti| shrotuM yasya shrutI AsAte, ma shR^iNuyAt| ");
INSERT INTO sanitr_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","apara ncha kShetramadhye nidhiM pashyan yo gopayati, tataH paraM sAnando gatvA svIyasarvvasvaM vikrIya ttakShetraM krINAti, sa iva svargarAjyaM| ");
INSERT INTO sanitr_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","anya ncha yo vaNik uttamAM muktAM gaveShayan ");
INSERT INTO sanitr_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","mahArghAM muktAM vilokya nijasarvvasvaM vikrIya tAM krINAti, sa iva svargarAjyaM| ");
INSERT INTO sanitr_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","punashcha samudro nikShiptaH sarvvaprakAramInasaMgrAhyAnAya_iva svargarAjyaM| ");
INSERT INTO sanitr_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","tasmin AnAye pUrNe janA yathA rodhasyuttolya samupavishya prashastamInAn saMgrahya bhAjaneShu nidadhate, kutsitAn nikShipanti; ");
INSERT INTO sanitr_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","tathaiva jagataH sheShe bhaviShyati, phalataH svargIyadUtA Agatya puNyavajjanAnAM madhyAt pApinaH pR^ithak kR^itvA vahnikuNDe nikShepsyanti, ");
INSERT INTO sanitr_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","tatra rodanaM dantai rdantagharShaNa ncha bhaviShyataH| ");
INSERT INTO sanitr_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","yIshunA te pR^iShTA yuShmAbhiH kimetAnyAkhyAnAnyabudhyanta? tadA te pratyavadan, satyaM prabho| ");
INSERT INTO sanitr_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","tadAnIM sa kathitavAn, nijabhANDAgArAt navInapurAtanAni vastUni nirgamayati yo gR^ihasthaH sa iva svargarAjyamadhi shikShitAH svarva upadeShTAraH| ");
INSERT INTO sanitr_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","anantaraM yIshuretAH sarvvA dR^iShTAntakathAH samApya tasmAt sthAnAt pratasthe| aparaM svadeshamAgatya janAn bhajanabhavana upadiShTavAn; ");
INSERT INTO sanitr_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","te vismayaM gatvA kathitavanta etasyaitAdR^ishaM j nAnam AshcharyyaM karmma cha kasmAd ajAyata? ");
INSERT INTO sanitr_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","kimayaM sUtradhArasya putro nahi? etasya mAtu rnAma cha kiM mariyam nahi? yAkub-yUShaph-shimon-yihUdAshcha kimetasya bhrAtaro nahi? ");
INSERT INTO sanitr_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","etasya bhaginyashcha kimasmAkaM madhye na santi? tarhi kasmAdayametAni labdhavAn? itthaM sa teShAM vighnarUpo babhUva; ");
INSERT INTO sanitr_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","tato yIshunA nigaditaM svadeshIyajanAnAM madhyaM vinA bhaviShyadvAdI kutrApyanyatra nAsammAnyo bhavatI| ");
INSERT INTO sanitr_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","teShAmavishvAsahetoH sa tatra sthAne bahvAshcharyyakarmmANi na kR^itavAn| ");
INSERT INTO sanitr_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","tadAnIM rAjA herod yIsho ryashaH shrutvA nijadAseyAn jagAd, ");
INSERT INTO sanitr_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","eSha majjayitA yohan, pramitebhayastasyotthAnAt tenetthamadbhutaM karmma prakAshyate| ");
INSERT INTO sanitr_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","purA herod nijabhrAtu: philipo jAyAyA herodIyAyA anurodhAd yohanaM dhArayitvA baddhA kArAyAM sthApitavAn| ");
INSERT INTO sanitr_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","yato yohan uktavAn, etsayAH saMgraho bhavato nochitaH| ");
INSERT INTO sanitr_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","tasmAt nR^ipatistaM hantumichChannapi lokebhyo vibhayA nchakAra; yataH sarvve yohanaM bhaviShyadvAdinaM menire| ");
INSERT INTO sanitr_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","kintu herodo janmAhIyamaha upasthite herodIyAyA duhitA teShAM samakShaM nR^ititvA herodamaprINyat| ");
INSERT INTO sanitr_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","tasmAt bhUpatiH shapathaM kurvvan iti pratyaj nAsIt, tvayA yad yAchyate, tadevAhaM dAsyAmi| ");
INSERT INTO sanitr_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","sA kumArI svIyamAtuH shikShAM labdhA babhAShe, majjayituryohana uttamA NgaM bhAjane samAnIya mahyaM vishrANaya| ");
INSERT INTO sanitr_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","tato rAjA shushocha, kintu bhojanAyopavishatAM sa NginAM svakR^itashapathasya chAnurodhAt tat pradAtuma Adidesha| ");
INSERT INTO sanitr_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","pashchAt kArAM prati naraM prahitya yohana uttamA NgaM ChittvA ");
INSERT INTO sanitr_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","tat bhAjana AnAyya tasyai kumAryyai vyashrANayat, tataH sA svajananyAH samIpaM tanninAya| ");
INSERT INTO sanitr_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","pashchAt yohanaH shiShyA Agatya kAyaM nItvA shmashAne sthApayAmAsustato yIshoH sannidhiM vrajitvA tadvArttAM babhAShire| ");
INSERT INTO sanitr_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","anantaraM yIshuriti nishabhya nAvA nirjanasthAnam ekAkI gatavAn, pashchAt mAnavAstat shrutvA nAnAnagarebhya Agatya padaistatpashchAd IyuH| ");
INSERT INTO sanitr_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","tadAnIM yIshu rbahirAgatya mahAntaM jananivahaM nirIkShya teShu kAruNikaH man teShAM pIDitajanAn nirAmayAn chakAra| ");
INSERT INTO sanitr_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","tataH paraM sandhyAyAM shiShyAstadantikamAgatya kathayA nchakruH, idaM nirjanasthAnaM velApyavasannA; tasmAt manujAn svasvagrAmaM gantuM svArthaM bhakShyANi kretu ncha bhavAn tAn visR^ijatu| ");
INSERT INTO sanitr_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","kintu yIshustAnavAdIt, teShAM gamane prayojanaM nAsti, yUyameva tAn bhojayata| ");
INSERT INTO sanitr_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","tadA te pratyavadan, asmAkamatra pUpapa nchakaM mInadvaya nchAste| ");
INSERT INTO sanitr_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","tadAnIM tenoktaM tAni madantikamAnayata| ");
INSERT INTO sanitr_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","anantaraM sa manujAn yavasoparyyupaveShTum Aj nApayAmAsa; apara tat pUpapa nchakaM mInadvaya ncha gR^ihlan svargaM prati nirIkShyeshvarIyaguNAn anUdya bhaMktvA shiShyebhyo dattavAn, shiShyAshcha lokebhyo daduH| ");
INSERT INTO sanitr_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","tataH sarvve bhuktvA paritR^iptavantaH, tatastadavashiShTabhakShyaiH pUrNAn dvAdashaDalakAn gR^ihItavantaH| ");
INSERT INTO sanitr_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","te bhoktAraH strIrbAlakAMshcha vihAya prAyeNa pa ncha sahasrANi pumAMsa Asan| ");
INSERT INTO sanitr_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","tadanantaraM yIshu rlokAnAM visarjanakAle shiShyAn taraNimAroDhuM svAgre pAraM yAtu ncha gADhamAdiShTavAn| ");
INSERT INTO sanitr_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","tato lokeShu visR^iShTeShu sa vivikte prArthayituM girimekaM gatvA sandhyAM yAvat tatraikAkI sthitavAn| ");
INSERT INTO sanitr_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","kintu tadAnIM sammukhavAtatvAt saritpate rmadhye tara NgaistaraNirdolAyamAnAbhavat| ");
INSERT INTO sanitr_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","tadA sa yAminyAshchaturthaprahare padbhyAM vrajan teShAmantikaM gatavAn| ");
INSERT INTO sanitr_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","kintu shiShyAstaM sAgaropari vrajantaM vilokya samudvignA jagaduH, eSha bhUta iti sha NkamAnA uchchaiH shabdAyA nchakrire cha| ");
INSERT INTO sanitr_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","tadaiva yIshustAnavadat, susthirA bhavata, mA bhaiShTa, eSho.aham| ");
INSERT INTO sanitr_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","tataH pitara ityuktavAn, he prabho, yadi bhavAneva, tarhi mAM bhavatsamIpaM yAtumAj nApayatu| ");
INSERT INTO sanitr_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","tataH tenAdiShTaH pitarastaraNito.avaruhya yIsheाrantikaM prAptuM toyopari vavrAja| ");
INSERT INTO sanitr_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","kintu prachaNDaM pavanaM vilokya bhayAt toye maMktum Arebhe, tasmAd uchchaiH shabdAyamAnaH kathitavAn, he prabho, mAmavatu| ");
INSERT INTO sanitr_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","yIshustatkShaNAt karaM prasAryya taM dharan uktavAn, ha stokapratyayin tvaM kutaH samashethAH? ");
INSERT INTO sanitr_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","anantaraM tayostaraNimArUDhayoH pavano nivavR^ite| ");
INSERT INTO sanitr_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","tadAnIM ye taraNyAmAsan, ta Agatya taM praNabhya kathitavantaH, yathArthastvameveshvarasutaH| ");
INSERT INTO sanitr_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","anantaraM pAraM prApya te gineSharannAmakaM nagaramupatasthuH, ");
INSERT INTO sanitr_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","tadA tatratyA janA yIshuM parichIya taddeshsya chaturdisho vArttAM prahitya yatra yAvantaH pIDitA Asan, tAvataeva tadantikamAnayAmAsuH| ");
INSERT INTO sanitr_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","aparaM tadIyavasanasya granthimAtraM spraShTuM vinIya yAvanto janAstat sparshaM chakrire, te sarvvaeva nirAmayA babhUvuH| ");
INSERT INTO sanitr_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","aparaM yirUshAlamnagarIyAH katipayA adhyApakAH phirUshinashcha yIshoH samIpamAgatya kathayAmAsuH, ");
INSERT INTO sanitr_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","tava shiShyAH kimartham aprakShAlitakarai rbhakShitvA paramparAgataM prAchInAnAM vyavahAraM la Nvante? ");
INSERT INTO sanitr_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","tato yIshuH pratyuvAcha, yUyaM paramparAgatAchAreNa kuta IshvarAj nAM la Nvadhve| ");
INSERT INTO sanitr_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ishvara ityAj nApayat, tvaM nijapitarau saMmanyethAH, yena cha nijapitarau nindyete, sa nishchitaM mriyeta; ");
INSERT INTO sanitr_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","kintu yUyaM vadatha, yaH svajanakaM svajananIM vA vAkyamidaM vadati, yuvAM matto yallabhethe, tat nyavidyata, ");
INSERT INTO sanitr_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","sa nijapitarau puna rna saMmaMsyate| itthaM yUyaM paramparAgatena sveShAmAchAreNeshvarIyAj nAM lumpatha| ");
INSERT INTO sanitr_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","re kapaTinaH sarvve yishayiyo yuShmAnadhi bhaviShyadvachanAnyetAni samyag uktavAn| ");
INSERT INTO sanitr_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","vadanai rmanujA ete samAyAnti madantikaM| tathAdharai rmadIya ncha mAnaM kurvvanti te narAH| ");
INSERT INTO sanitr_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","kintu teShAM mano matto vidUraeva tiShThati| shikShayanto vidhIn nrAj nA bhajante mAM mudhaiva te| ");
INSERT INTO sanitr_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","tato yIshu rlokAn AhUya proktavAn, yUyaM shrutvA budhyadhbaM| ");
INSERT INTO sanitr_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","yanmukhaM pravishati, tat manujam amedhyaM na karoti, kintu yadAsyAt nirgachChati, tadeva mAnuShamamedhyI karotI| ");
INSERT INTO sanitr_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","tadAnIM shiShyA Agatya tasmai kathayA nchakruH, etAM kathAM shrutvA phirUshino vyarajyanta, tat kiM bhavatA j nAyate? ");
INSERT INTO sanitr_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","sa pratyavadat, mama svargasthaH pitA yaM ka nchida NkuraM nAropayat, sa utpAvdyate| ");
INSERT INTO sanitr_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","te tiShThantu, te andhamanujAnAm andhamArgadarshakA eva; yadyandho.andhaM panthAnaM darshayati, tarhyubhau gartte patataH| ");
INSERT INTO sanitr_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","tadA pitarastaM pratyavadat, dR^iShTAntamimamasmAn bodhayatu| ");
INSERT INTO sanitr_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","yIshunA proktaM, yUyamadya yAvat kimabodhAH stha? ");
INSERT INTO sanitr_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","kathAmimAM kiM na budhyadhbe ? yadAsyaM previshati, tad udare patan bahirniryAti, ");
INSERT INTO sanitr_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","kintvAsyAd yanniryAti, tad antaHkaraNAt niryAtatvAt manujamamedhyaM karoti| ");
INSERT INTO sanitr_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","yato.antaHkaraNAt kuchintA badhaH pAradArikatA veshyAgamanaM chairyyaM mithyAsAkShyam IshvaranindA chaitAni sarvvANi niryyAnti| ");
INSERT INTO sanitr_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","etAni manuShyamapavitrI kurvvanti kintvaprakShAlitakareNa bhojanaM manujamamedhyaM na karoti| ");
INSERT INTO sanitr_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","anantaraM yIshustasmAt sthAnAt prasthAya sorasIdonnagarayoH sImAmupatasyau| ");
INSERT INTO sanitr_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","tadA tatsImAtaH kAchit kinAnIyA yoShid Agatya tamuchchairuvAcha, he prabho dAyUdaH santAna, mamaikA duhitAste sA bhUtagrastA satI mahAkleshaM prApnoti mama dayasva| ");
INSERT INTO sanitr_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","kintu yIshustAM kimapi noktavAn, tataH shiShyA Agatya taM nivedayAmAsuH, eShA yoShid asmAkaM pashchAd uchchairAhUyAgachChati, enAM visR^ijatu| ");
INSERT INTO sanitr_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","tadA sa pratyavadat, isrAyelgotrasya hAritameShAn vinA kasyApyanyasya samIpaM nAhaM preShitosmi| ");
INSERT INTO sanitr_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","tataH sA nArIsamAgatya taM praNamya jagAda, he prabho mAmupakuru| ");
INSERT INTO sanitr_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","sa uktavAn, bAlakAnAM bhakShyamAdAya sArameyebhyo dAnaM nochitaM| ");
INSERT INTO sanitr_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","tadA sA babhAShe, he prabho, tat satyaM, tathApi prabho rbha nchAd yaduchChiShTaM patati, tat sArameyAH khAdanti| ");
INSERT INTO sanitr_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","tato yIshuH pratyavadat, he yoShit, tava vishvAso mahAn tasmAt tava manobhilaShitaM sidyyatu, tena tasyAH kanyA tasminneva daNDe nirAmayAbhavat| ");
INSERT INTO sanitr_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","anantaraM yIshastasmAt sthAnAt prasthAya gAlIlsAgarasya sannidhimAgatya dharAdharamAruhya tatropavivesha| ");
INSERT INTO sanitr_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","pashchAt jananivaho bahUn kha nchAndhamUkashuShkakaramAnuShAn AdAya yIshoH samIpamAgatya tachcharaNAntike sthApayAmAsuH, tataH sA tAn nirAmayAn akarot| ");
INSERT INTO sanitr_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","itthaM mUkA vAkyaM vadanti, shuShkakarAH svAsthyamAyAnti, pa Ngavo gachChanti, andhA vIkShante, iti vilokya lokA vismayaM manyamAnA isrAyela IshvaraM dhanyaM babhAShire| ");
INSERT INTO sanitr_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","tadAnIM yIshuH svashiShyAn AhUya gaditavAn, etajjananivaheShu mama dayA jAyate, ete dinatrayaM mayA sAkaM santi, eShAM bhakShyavastu cha ka nchidapi nAsti, tasmAdahametAnakR^itAhArAn na visrakShyAmi, tathAtve vartmamadhye klAmyeShuH| ");
INSERT INTO sanitr_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","tadA shiShyA UchuH, etasmin prAntaramadhya etAvato martyAn tarpayituM vayaM kutra pUpAn prApsyAmaH? ");
INSERT INTO sanitr_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","yIshurapR^ichChat, yuShmAkaM nikaTe kati pUpA Asate? ta UchuH, saptapUpA alpAH kShudramInAshcha santi| ");
INSERT INTO sanitr_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","tadAnIM sa lokanivahaM bhUmAvupaveShTum Adishya ");
INSERT INTO sanitr_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","tAn saptapUpAn mInAMshcha gR^ihlan IshvarIyaguNAn anUdya bhaMktvA shiShyebhyo dadau, shiShyA lokebhyo daduH| ");
INSERT INTO sanitr_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","tataH sarvve bhuktvA tR^iptavantaH; tadavashiShTabhakShyeNa saptaDalakAn paripUryya saMjagR^ihuH| ");
INSERT INTO sanitr_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","te bhoktAro yoShito bAlakAMshcha vihAya prAyeNa chatuHsahasrANi puruShA Asan| ");
INSERT INTO sanitr_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","tataH paraM sa jananivahaM visR^ijya tarimAruhya magdalApradeshaM gatavAn| ");
INSERT INTO sanitr_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","tadAnIM phirUshinaH sidUkinashchAgatya taM parIkShituM nabhamIyaM ki nchana lakShma darshayituM tasmai nivedayAmAsuH| ");
INSERT INTO sanitr_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","tataH sa uktavAn, sandhyAyAM nabhaso raktatvAd yUyaM vadatha, shvo nirmmalaM dinaM bhaviShyati; ");
INSERT INTO sanitr_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","prAtaHkAle cha nabhaso raktatvAt malinatvA ncha vadatha, jha nbhshadya bhaviShyati| he kapaTino yadi yUyam antarIkShasya lakShma boddhuM shaknutha, tarhi kAlasyaitasya lakShma kathaM boddhuM na shaknutha? ");
INSERT INTO sanitr_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","etatkAlasya duShTo vyabhichArI cha vaMsho lakShma gaveShayati, kintu yUnaso bhaviShyadvAdino lakShma vinAnyat kimapi lakShma tAn na darshayiyyate| tadAnIM sa tAn vihAya pratasthe| ");
INSERT INTO sanitr_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","anantaramanyapAragamanakAle tasya shiShyAH pUpamAnetuM vismR^itavantaH| ");
INSERT INTO sanitr_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","yIshustAnavAdIt, yUyaM phirUshinAM sidUkinA ncha kiNvaM prati sAvadhAnAH satarkAshcha bhavata| ");
INSERT INTO sanitr_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","tena te parasparaM vivichya kathayitumArebhire, vayaM pUpAnAnetuM vismR^itavanta etatkAraNAd iti kathayati| ");
INSERT INTO sanitr_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","kintu yIshustadvij nAya tAnavochat, he stokavishvAsino yUyaM pUpAnAnayanamadhi kutaH parasparametad viviMkya? ");
INSERT INTO sanitr_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","yuShmAbhiH kimadyApi na j nAyate? pa nchabhiH pUpaiH pa nchasahasrapuruSheShu bhojiteShu bhakShyochChiShTapUrNAn kati DalakAn samagR^ihlItaM; ");
INSERT INTO sanitr_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","tathA saptabhiH pUpaishchatuHsahasrapuruSheShu bhejiteShu kati DalakAn samagR^ihlIta, tat kiM yuShmAbhirna smaryyate? ");
INSERT INTO sanitr_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","tasmAt phirUshinAM sidUkinA ncha kiNvaM prati sAvadhAnAstiShThata, kathAmimAm ahaM pUpAnadhi nAkathayaM, etad yUyaM kuto na budhyadhve? ");
INSERT INTO sanitr_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","tadAnIM pUpakiNvaM prati sAvadhAnAstiShThateti noktvA phirUshinAM sidUkinA ncha upadeshaM prati sAvadhAnAstiShThateti kathitavAn, iti tairabodhi| ");
INSERT INTO sanitr_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","apara ncha yIshuH kaisariyA-philipipradeshamAgatya shiShyAn apR^ichChat, yo.ahaM manujasutaH so.ahaM kaH? lokairahaM kimuchye? ");
INSERT INTO sanitr_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","tadAnIM te kathitavantaH, kechid vadanti tvaM majjayitA yohan, kechidvadanti, tvam eliyaH, kechichcha vadanti, tvaM yirimiyo vA kashchid bhaviShyadvAdIti| ");
INSERT INTO sanitr_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","pashchAt sa tAn paprachCha, yUyaM mAM kaM vadatha? tataH shimon pitara uvAcha, ");
INSERT INTO sanitr_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","tvamamareshvarasyAbhiShiktaputraH| ");
INSERT INTO sanitr_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","tato yIshuH kathitavAn, he yUnasaH putra shimon tvaM dhanyaH; yataH kopi anujastvayyetajj nAnaM nodapAdayat, kintu mama svargasyaH pitodapAdayat| ");
INSERT INTO sanitr_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","ato.ahaM tvAM vadAmi, tvaM pitaraH (prastaraH) aha ncha tasya prastarasyopari svamaNDalIM nirmmAsyAmi, tena nirayo balAt tAM parAjetuM na shakShyati| ");
INSERT INTO sanitr_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","ahaM tubhyaM svargIyarAjyasya ku njikAM dAsyAmi, tena yat ki nchana tvaM pR^ithivyAM bhaMtsyasi tatsvarge bhaMtsyate, yachcha ki nchana mahyAM mokShyasi tat svarge mokShyate| ");
INSERT INTO sanitr_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","pashchAt sa shiShyAnAdishat, ahamabhiShikto yIshuriti kathAM kasmaichidapi yUyaM mA kathayata| ");
INSERT INTO sanitr_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","anya ncha yirUshAlamnagaraM gatvA prAchInalokebhyaH pradhAnayAjakebhya upAdhyAyebhyashcha bahuduHkhabhogastai rhatatvaM tR^itIyadine punarutthAna ncha mamAvashyakam etAH kathA yIshustatkAlamArabhya shiShyAn j nApayitum ArabdhavAn| ");
INSERT INTO sanitr_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","tadAnIM pitarastasya karaM ghR^itvA tarjayitvA kathayitumArabdhavAn, he prabho, tat tvatto dUraM yAtu, tvAM prati kadApi na ghaTiShyate| ");
INSERT INTO sanitr_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","kintu sa vadanaM parAvartya pitaraM jagAda, he vighnakArin, matsammukhAd dUrIbhava, tvaM mAM bAdhase, IshvarIyakAryyAt mAnuShIyakAryyaM tubhyaM rochate| ");
INSERT INTO sanitr_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","anantaraM yIshuH svIyashiShyAn uktavAn yaH kashchit mama pashchAdgAmI bhavitum ichChati, sa svaM dAmyatu, tathA svakrushaM gR^ihlan matpashchAdAyAtu| ");
INSERT INTO sanitr_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","yato yaH prANAn rakShitumichChati, sa tAn hArayiShyati, kintu yo madarthaM nijaprANAn hArayati, sa tAn prApsyati| ");
INSERT INTO sanitr_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","mAnuSho yadi sarvvaM jagat labhate nijapraNAn hArayati, tarhi tasya ko lAbhaH? manujo nijaprANAnAM vinimayena vA kiM dAtuM shaknoti? ");
INSERT INTO sanitr_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","manujasutaH svadUtaiH sAkaM pituH prabhAveNAgamiShyati; tadA pratimanujaM svasvakarmmAnusArAt phalaM dAsyati| ");
INSERT INTO sanitr_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","ahaM yuShmAn tathyaM vachmi, sarAjyaM manujasutam AgataM na pashyanto mR^ityuM na svAdiShyanti, etAdR^ishAH katipayajanA atrApi daNDAyamAnAH santi| ");
INSERT INTO sanitr_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","anantaraM ShaDdinebhyaH paraM yIshuH pitaraM yAkUbaM tatsahajaM yohana ncha gR^ihlan uchchAdre rviviktasthAnam Agatya teShAM samakShaM rUpamanyat dadhAra| ");
INSERT INTO sanitr_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","tena tadAsyaM tejasvi, tadAbharaNam Alokavat pANDaramabhavat| ");
INSERT INTO sanitr_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","anyachcha tena sAkaM saMlapantau mUsA eliyashcha tebhyo darshanaM dadatuH| ");
INSERT INTO sanitr_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","tadAnIM pitaro yIshuM jagAda, he prabho sthitiratrAsmAkaM shubhA, yadi bhavatAnumanyate, tarhi bhavadarthamekaM mUsArthamekam eliyArtha nchaikam iti trINi dUShyANi nirmmama| ");
INSERT INTO sanitr_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","etatkathanakAla eka ujjavalaH payodasteShAmupari ChAyAM kR^itavAn, vAridAd eShA nabhasIyA vAg babhUva, mamAyaM priyaH putraH, asmin mama mahAsantoSha etasya vAkyaM yUyaM nishAmayata| ");
INSERT INTO sanitr_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","kintu vAchametAM shR^iNvantaeva shiShyA mR^ishaM sha NkamAnA nyubjA nyapatan| ");
INSERT INTO sanitr_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","tadA yIshurAgatya teShAM gAtrANi spR^ishan uvAcha, uttiShThata, mA bhaiShTa| ");
INSERT INTO sanitr_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","tadAnIM netrANyunmIlya yIshuM vinA kamapi na dadR^ishuH| ");
INSERT INTO sanitr_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","tataH param adreravarohaNakAle yIshustAn ityAdidesha, manujasutasya mR^itAnAM madhyAdutthAnaM yAvanna jAyate, tAvat yuShmAbhiretaddarshanaM kasmaichidapi na kathayitavyaM| ");
INSERT INTO sanitr_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","tadA shiShyAstaM paprachChuH, prathamam eliya AyAsyatIti kuta upAdhyAyairuchyate? ");
INSERT INTO sanitr_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","tato yIshuH pratyavAdIt, eliyaH prAgetya sarvvANi sAdhayiShyatIti satyaM, ");
INSERT INTO sanitr_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","kintvahaM yuShmAn vachmi, eliya etya gataH, te tamaparichitya tasmin yathechChaM vyavajahuH; manujasutenApi teShAmantike tAdR^ig duHkhaM bhoktavyaM| ");
INSERT INTO sanitr_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","tadAnIM sa majjayitAraM yohanamadhi kathAmetAM vyAhR^itavAn, itthaM tachChiShyA bubudhire| ");
INSERT INTO sanitr_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","pashchAt teShu jananivahasyAntikamAgateShu kashchit manujastadantikametya jAnUnI pAtayitvA kathitavAn, ");
INSERT INTO sanitr_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","he prabho, matputraM prati kR^ipAM vidadhAtu, sopasmArAmayena bhR^ishaM vyathitaH san punaH puna rvahnau muhu rjalamadhye patati| ");
INSERT INTO sanitr_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","tasmAd bhavataH shiShyANAM samIpe tamAnayaM kintu te taM svAsthaM karttuM na shaktAH| ");
INSERT INTO sanitr_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","tadA yIshuH kathitavAn re avishvAsinaH, re vipathagAminaH, punaH katikAlAn ahaM yuShmAkaM sannidhau sthAsyAmi? katikAlAn vA yuShmAn sahiShye? tamatra mamAntikamAnayata| ");
INSERT INTO sanitr_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","pashchAd yIshunA tarjataeva sa bhUtastaM vihAya gatavAn, taddaNDaeva sa bAlako nirAmayo.abhUt| ");
INSERT INTO sanitr_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","tataH shiShyA guptaM yIshumupAgatya babhAShire, kuto vayaM taM bhUtaM tyAjayituM na shaktAH? ");
INSERT INTO sanitr_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","yIshunA te proktAH, yuShmAkamapratyayAt; ");
INSERT INTO sanitr_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","yuShmAnahaM tathyaM vachmi yadi yuShmAkaM sarShapaikamAtropi vishvAso jAyate, tarhi yuShmAbhirasmin shaile tvamitaH sthAnAt tat sthAnaM yAhIti brUte sa tadaiva chaliShyati, yuShmAkaM kimapyasAdhya ncha karmma na sthAsyAti| kintu prArthanopavAsau vinaitAdR^isho bhUto na tyAjyeta| ");
INSERT INTO sanitr_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","aparaM teShAM gAlIlpradeshe bhramaNakAle yIshunA te gaditAH, manujasuto janAnAM kareShu samarpayiShyate tai rhaniShyate cha, ");
INSERT INTO sanitr_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","kintu tR^itIye.ahi्na ma utthApiShyate, tena te bhR^ishaM duHkhitA babhUvaH| ");
INSERT INTO sanitr_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","tadanantaraM teShu kapharnAhUmnagaramAgateShu karasaMgrAhiNaH pitarAntikamAgatya paprachChuH, yuShmAkaM guruH kiM mandirArthaM karaM na dadAti? tataH pitaraH kathitavAn dadAti| ");
INSERT INTO sanitr_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","tatastasmin gR^ihamadhyamAgate tasya kathAkathanAt pUrvvameva yIshuruvAcha, he shimon, medinyA rAjAnaH svasvApatyebhyaH kiM videshibhyaH kebhyaH karaM gR^ihlanti? atra tvaM kiM budhyase? tataH pitara uktavAn, videshibhyaH| ");
INSERT INTO sanitr_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","tadA yIshuruktavAn, tarhi santAnA muktAH santi| ");
INSERT INTO sanitr_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","tathApi yathAsmAbhisteShAmantarAyo na janyate, tatkR^ite jaladhestIraM gatvA vaDishaM kShipa, tenAdau yo mIna utthAsyati, taM ghR^itvA tanmukhe mochite tolakaikaM rUpyaM prApsyasi, tad gR^ihItvA tava mama cha kR^ite tebhyo dehi| ");
INSERT INTO sanitr_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","tadAnIM shiShyA yIshoH samIpamAgatya pR^iShTavantaH svargarAjye kaH shreShThaH? ");
INSERT INTO sanitr_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","tato yIshuH kShudramekaM bAlakaM svasamIpamAnIya teShAM madhye nidhAya jagAda, ");
INSERT INTO sanitr_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","yuShmAnahaM satyaM bravImi, yUyaM manovinimayena kShudrabAlavat na santaH svargarAjyaM praveShTuM na shaknutha| ");
INSERT INTO sanitr_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","yaH kashchid etasya kShudrabAlakasya samamAtmAnaM namrIkaroti, saeva svargarAjaye shreShThaH| ");
INSERT INTO sanitr_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","yaH kashchid etAdR^ishaM kShudrabAlakamekaM mama nAmni gR^ihlAti, sa mAmeva gR^ihlAti| ");
INSERT INTO sanitr_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","kintu yo jano mayi kR^itavishvAsAnAmeteShAM kShudraprANinAm ekasyApi vidhniM janayati, kaNThabaddhapeShaNIkasya tasya sAgarAgAdhajale majjanaM shreyaH| ");
INSERT INTO sanitr_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","vighnAt jagataH santApo bhaviShyati, vighno.avashyaM janayiShyate, kintu yena manujena vighno janiShyate tasyaiva santApo bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","tasmAt tava karashcharaNo vA yadi tvAM bAdhate, tarhi taM ChittvA nikShipa, dvikarasya dvipadasya vA tavAnaptavahnau nikShepAt, kha njasya vA Chinnahastasya tava jIvane pravesho varaM| ");
INSERT INTO sanitr_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","aparaM tava netraM yadi tvAM bAdhate, tarhi tadapyutpAvya nikShipa, dvinetrasya narakAgnau nikShepAt kANasya tava jIvane pravesho varaM| ");
INSERT INTO sanitr_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","tasmAdavadhaddhaM, eteShAM kShudraprANinAm ekamapi mA tuchChIkuruta, ");
INSERT INTO sanitr_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","yato yuShmAnahaM tathyaM bravImi, svarge teShAM dUtA mama svargasthasya piturAsyaM nityaM pashyanti| evaM ye ye hAritAstAn rakShituM manujaputra AgachChat| ");
INSERT INTO sanitr_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","yUyamatra kiM viviMgghve? kasyachid yadi shataM meShAH santi, teShAmeko hAryyate cha, tarhi sa ekonashataM meShAn vihAya parvvataM gatvA taM hAritamekaM kiM na mR^igayate? ");
INSERT INTO sanitr_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","yadi cha kadAchit tanmeShoddeshaM lamate, tarhi yuShmAnahaM satyaM kathayAmi, so.avipathagAmibhya ekonashatameShebhyopi tadekahetoradhikam AhlAdate| ");
INSERT INTO sanitr_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","tadvad eteShAM kShudraprAeिnAm ekopi nashyatIti yuShmAkaM svargasthapitu rnAbhimatam| ");
INSERT INTO sanitr_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","yadyapi tava bhrAtA tvayi kimapyaparAdhyati, tarhi gatvA yuvayordvayoH sthitayostasyAparAdhaM taM j nApaya| tatra sa yadi tava vAkyaM shR^iNoti, tarhi tvaM svabhrAtaraM prAptavAn, ");
INSERT INTO sanitr_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","kintu yadi na shR^iNoti, tarhi dvAbhyAM tribhi rvA sAkShIbhiH sarvvaM vAkyaM yathA nishchitaM jAyate, tadartham ekaM dvau vA sAkShiNau gR^ihItvA yAhi| ");
INSERT INTO sanitr_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","tena sa yadi tayo rvAkyaM na mAnyate, tarhi samAjaM tajj nApaya, kintu yadi samAjasyApi vAkyaM na mAnyate,tarhi sa tava samIpe devapUjaka_iva chaNDAla_iva cha bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","ahaM yuShmAn satyaM vadAmi, yuShmAbhiH pR^ithivyAM yad badhyate tat svarge bhaMtsyate; medinyAM yat bhochyate, svarge.api tat mokShyate| ");
INSERT INTO sanitr_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","punarahaM yuShmAn vadAmi, medinyAM yuShmAkaM yadi dvAvekavAkyIbhUya ki nchit prArthayete, tarhi mama svargasthapitrA tat tayoH kR^ite sampannaM bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","yato yatra dvau trayo vA mama nAnni milanti, tatraivAhaM teShAM madhye.asmi| ");
INSERT INTO sanitr_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","tadAnIM pitarastatsamIpamAgatya kathitavAn he prabho, mama bhrAtA mama yadyaparAdhyati, tarhi taM katikR^itvaH kShamiShye? ");
INSERT INTO sanitr_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","kiM saptakR^itvaH? yIshustaM jagAda, tvAM kevalaM saptakR^itvo yAvat na vadAmi, kintu saptatyA guNitaM saptakR^itvo yAvat| ");
INSERT INTO sanitr_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","aparaM nijadAsaiH saha jigaNayiShuH kashchid rAjeva svargarAjayaM| ");
INSERT INTO sanitr_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Arabdhe tasmin gaNane sArddhasahasramudrApUritAnAM dashasahasrapuTakAnAm eko.aghamarNastatsamakShamAnAyi| ");
INSERT INTO sanitr_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","tasya parishodhanAya dravyAbhAvAt parishodhanArthaM sa tadIyabhAryyAputrAdisarvvasva ncha vikrIyatAmiti tatprabhurAdidesha| ");
INSERT INTO sanitr_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","tena sa dAsastasya pAdayoH patan praNamya kathitavAn , he prabho bhavatA ghairyye kR^ite mayA sarvvaM parishodhiShyate| ");
INSERT INTO sanitr_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","tadAnIM dAsasya prabhuH sakaruNaH san sakalarNaM kShamitvA taM tatyAja| ");
INSERT INTO sanitr_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","kintu tasmin dAse bahi ryAte, tasya shataM mudrAchaturthAMshAn yo dhArayati, taM sahadAsaM dR^iShdvA tasya kaNThaM niShpIDya gaditavAn, mama yat prApyaM tat parishodhaya| ");
INSERT INTO sanitr_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","tadA tasya sahadAsastatpAdayoH patitvA vinIya babhAShe, tvayA dhairyye kR^ite mayA sarvvaM parishodhiShyate| ");
INSERT INTO sanitr_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","tathApi sa tat nA NagIkR^itya yAvat sarvvamR^iNaM na parishodhitavAn tAvat taM kArAyAM sthApayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","tadA tasya sahadAsAstasyaitAdR^ig AcharaNaM vilokya prabhoH samIpaM gatvA sarvvaM vR^ittAntaM nivedayAmAsuH| ");
INSERT INTO sanitr_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","tadA tasya prabhustamAhUya jagAda, re duShTa dAsa, tvayA matsannidhau prArthite mayA tava sarvvamR^iNaM tyaktaM; ");
INSERT INTO sanitr_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","yathA chAhaM tvayi karuNAM kR^itavAn, tathaiva tvatsahadAse karuNAkaraNaM kiM tava nochitaM? ");
INSERT INTO sanitr_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","iti kathayitvA tasya prabhuH kruddhyan nijaprApyaM yAvat sa na parishodhitavAn, tAvat prahArakAnAM kareShu taM samarpitavAn| ");
INSERT INTO sanitr_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","yadi yUyaM svAntaHkaraNaiH svasvasahajAnAm aparAdhAn na kShamadhve, tarhi mama svargasyaH pitApi yuShmAn pratItthaM kariShyati| ");
INSERT INTO sanitr_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","anantaram etAsu kathAsu samAptAsu yIshu rgAlIlapradeshAt prasthAya yardantIrasthaM yihUdApradeshaM prAptaH| ");
INSERT INTO sanitr_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","tadA tatpashchAt jananivahe gate sa tatra tAn nirAmayAn akarot| ");
INSERT INTO sanitr_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","tadanantaraM phirUshinastatsamIpamAgatya pArIkShituM taM paprachChuH, kasmAdapi kAraNAt nareNa svajAyA parityAjyA na vA? ");
INSERT INTO sanitr_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","sa pratyuvAcha, prathamam Ishvaro naratvena nArItvena cha manujAn sasarja, tasmAt kathitavAn, ");
INSERT INTO sanitr_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","mAnuShaH svapitarau parityajya svapatnyAm AsakShyate, tau dvau janAvekA Ngau bhaviShyataH, kimetad yuShmAbhi rna paThitam? ");
INSERT INTO sanitr_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","atastau puna rna dvau tayorekA NgatvaM jAtaM, IshvareNa yachcha samayujyata, manujo na tad bhindyAt| ");
INSERT INTO sanitr_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","tadAnIM te taM pratyavadan, tathAtve tyAjyapatraM dattvA svAM svAM jAyAM tyaktuM vyavasthAM mUsAH kathaM lilekha? ");
INSERT INTO sanitr_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","tataH sa kathitavAn, yuShmAkaM manasAM kAThinyAd yuShmAn svAM svAM jAyAM tyaktum anvamanyata kintu prathamAd eSho vidhirnAsIt| ");
INSERT INTO sanitr_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","ato yuShmAnahaM vadAmi, vyabhichAraM vinA yo nijajAyAM tyajet anyA ncha vivahet, sa paradArAn gachChati; yashcha tyaktAM nArIM vivahati sopi paradAreShu ramate| ");
INSERT INTO sanitr_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","tadA tasya shiShyAstaM babhAShire, yadi svajAyayA sAkaM puMsa etAdR^ik sambandho jAyate, tarhi vivahanameva na bhadraM| ");
INSERT INTO sanitr_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","tataH sa uktavAn, yebhyastatsAmarthyaM AdAyi, tAn vinAnyaH kopi manuja etanmataM grahItuM na shaknoti| ");
INSERT INTO sanitr_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","katipayA jananaklIbaH katipayA narakR^itaklIbaH svargarAjyAya katipayAH svakR^itaklIbAshcha santi, ye grahItuM shaknuvanti te gR^ihlantu| ");
INSERT INTO sanitr_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","aparam yathA sa shishUnAM gAtreShu hastaM datvA prArthayate, tadarthaM tatsamIMpaM shishava AnIyanta, tata AnayitR^in shiShyAstiraskR^itavantaH| ");
INSERT INTO sanitr_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","kintu yIshuruvAcha, shishavo madantikam AgachChantu, tAn mA vArayata, etAdR^ishAM shishUnAmeva svargarAjyaM| ");
INSERT INTO sanitr_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","tataH sa teShAM gAtreShu hastaM datvA tasmAt sthAnAt pratasthe| ");
INSERT INTO sanitr_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","aparam eka Agatya taM paprachCha, he paramaguro, anantAyuH prAptuM mayA kiM kiM satkarmma karttavyaM? ");
INSERT INTO sanitr_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","tataH sa uvAcha, mAM paramaM kuto vadasi? vineshcharaM na kopi paramaH, kintu yadyanantAyuH prAptuM vA nChasi, tarhyAj nAH pAlaya| ");
INSERT INTO sanitr_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","tadA sa pR^iShTavAn, kAH kA Aj nAH? tato yIshuH kathitavAn, naraM mA hanyAH, paradArAn mA gachCheH, mA chorayeH, mR^iShAsAkShyaM mA dadyAH, ");
INSERT INTO sanitr_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","nijapitarau saMmanyasva, svasamIpavAsini svavat prema kuru| ");
INSERT INTO sanitr_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","sa yuvA kathitavAn, A bAlyAd etAH pAlayAmi, idAnIM kiM nyUnamAste? ");
INSERT INTO sanitr_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","tato yIshuravadat, yadi siddho bhavituM vA nChasi, tarhi gatvA nijasarvvasvaM vikrIya daridrebhyo vitara, tataH svarge vittaM lapsyase; AgachCha, matpashchAdvarttI cha bhava| ");
INSERT INTO sanitr_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","etAM vAchaM shrutvA sa yuvA svIyabahusampatte rviShaNaH san chalitavAn| ");
INSERT INTO sanitr_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","tadA yIshuH svashiShyAn avadat, dhaninAM svargarAjyapravesho mahAduShkara iti yuShmAnahaM tathyaM vadAmi| ");
INSERT INTO sanitr_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","punarapi yuShmAnahaM vadAmi, dhaninAM svargarAjyapraveshAt sUchIChidreNa mahA NgagamanaM sukaraM| ");
INSERT INTO sanitr_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","iti vAkyaM nishamya shiShyA atichamatkR^itya kathayAmAsuH; tarhi kasya paritrANaM bhavituM shaknoti? ");
INSERT INTO sanitr_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","tadA sa tAn dR^iShdvA kathayAmAsa, tat mAnuShANAmashakyaM bhavati, kintvIshvarasya sarvvaM shakyam| ");
INSERT INTO sanitr_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","tadA pitarastaM gaditavAn, pashya, vayaM sarvvaM parityajya bhavataH pashchAdvarttino .abhavAma; vayaM kiM prApsyAmaH? ");
INSERT INTO sanitr_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","tato yIshuH kathitavAn, yuShmAnahaM tathyaM vadAmi, yUyaM mama pashchAdvarttino jAtA iti kAraNAt navInasR^iShTikAle yadA manujasutaH svIyaishcharyyasiMhAsana upavekShyati, tadA yUyamapi dvAdashasiMhAsaneShUpavishya isrAyelIyadvAdashavaMshAnAM vichAraM kariShyatha| ");
INSERT INTO sanitr_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","anyachcha yaH kashchit mama nAmakAraNAt gR^ihaM vA bhrAtaraM vA bhaginIM vA pitaraM vA mAtaraM vA jAyAM vA bAlakaM vA bhUmiM parityajati, sa teShAM shataguNaM lapsyate, anantAyumo.adhikAritva ncha prApsyati| ");
INSERT INTO sanitr_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","kintu agrIyA aneke janAH pashchAt, pashchAtIyAshchAneke lokA agre bhaviShyanti| ");
INSERT INTO sanitr_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","svargarAjyam etAdR^ishA kenachid gR^ihasyena samaM, yo.atiprabhAte nijadrAkShAkShetre kR^iShakAn niyoktuM gatavAn| ");
INSERT INTO sanitr_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","pashchAt taiH sAkaM dinaikabhR^itiM mudrAchaturthAMshaM nirUpya tAn drAkShAkShetraM prerayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","anantaraM praharaikavelAyAM gatvA haTTe katipayAn niShkarmmakAn vilokya tAnavadat, ");
INSERT INTO sanitr_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","yUyamapi mama drAkShAkShetraM yAta, yuShmabhyamahaM yogyabhR^itiM dAsyAmi, tataste vavrajuH| ");
INSERT INTO sanitr_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","punashcha sa dvitIyatR^itIyayoH praharayo rbahi rgatvA tathaiva kR^itavAn| ");
INSERT INTO sanitr_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","tato daNDadvayAvashiShTAyAM velAyAM bahi rgatvAparAn katipayajanAn niShkarmmakAn vilokya pR^iShTavAn, yUyaM kimartham atra sarvvaM dinaM niShkarmmANastiShThatha? ");
INSERT INTO sanitr_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","te pratyavadan, asmAn na kopi karmamaNi niyuMkte| tadAnIM sa kathitavAn, yUyamapi mama drAkShAkShetraM yAta, tena yogyAM bhR^itiM lapsyatha| ");
INSERT INTO sanitr_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","tadanantaraM sandhyAyAM satyAM saeva drAkShAkShetrapatiradhyakShaM gadivAn, kR^iShakAn AhUya sheShajanamArabhya prathamaM yAvat tebhyo bhR^itiM dehi| ");
INSERT INTO sanitr_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","tena ye daNDadvayAvasthite samAyAtAsteShAm ekaiko jano mudrAchaturthAMshaM prApnot| ");
INSERT INTO sanitr_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","tadAnIM prathamaniyuktA janA AgatyAnumitavanto vayamadhikaM prapsyAmaH, kintu tairapi mudrAchaturthAMsho.alAbhi| ");
INSERT INTO sanitr_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","tataste taM gR^ihItvA tena kShetrapatinA sAkaM vAgyuddhaM kurvvantaH kathayAmAsuH, ");
INSERT INTO sanitr_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","vayaM kR^itsnaM dinaM tApakleshau soDhavantaH, kintu pashchAtAyA se janA daNDadvayamAtraM parishrAntavantaste.asmAbhiH samAnAMshAH kR^itAH| ");
INSERT INTO sanitr_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","tataH sa teShAmekaM pratyuvAcha, he vatsa, mayA tvAM prati kopyanyAyo na kR^itaH kiM tvayA matsamakShaM mudrAchaturthAMsho nA NgIkR^itaH? ");
INSERT INTO sanitr_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","tasmAt tava yat prApyaM tadAdAya yAhi, tubhyaM yati, pashchAtIyaniyuktalokAyApi tati dAtumichChAmi| ");
INSERT INTO sanitr_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","svechChayA nijadravyavyavaharaNaM kiM mayA na karttavyaM? mama dAtR^itvAt tvayA kim IrShyAdR^iShTiH kriyate? ");
INSERT INTO sanitr_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","ittham agrIyalokAH pashchatIyA bhaviShyanti, pashchAtIyajanAshchagrIyA bhaviShyanti, ahUtA bahavaH kintvalpe manobhilaShitAH| ");
INSERT INTO sanitr_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","tadanantaraM yIshu ryirUshAlamnagaraM gachChan mArgamadhye shiShyAn ekAnte vabhAShe, ");
INSERT INTO sanitr_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","pashya vayaM yirUshAlamnagaraM yAmaH, tatra pradhAnayAjakAdhyApakAnAM kareShu manuShyaputraH samarpiShyate; ");
INSERT INTO sanitr_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","te cha taM hantumAj nApya tiraskR^itya vetreNa praharttuM krushe dhAtayitu nchAnyadeshIyAnAM kareShu samarpayiShyanti, kintu sa tR^itIyadivase shmashAnAd utthApiShyate| ");
INSERT INTO sanitr_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","tadAnIM sivadIyasya nArI svaputrAvAdAya yIshoH samIpam etya praNamya ka nchanAnugrahaM taM yayAche| ");
INSERT INTO sanitr_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","tadA yIshustAM proktavAn, tvaM kiM yAchase? tataH sA babhAShe, bhavato rAjatve mamAnayoH sutayorekaM bhavaddakShiNapArshve dvitIyaM vAmapArshva upaveShTum Aj nApayatu| ");
INSERT INTO sanitr_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","yIshuH pratyuvAcha, yuvAbhyAM yad yAchyate, tanna budhyate, ahaM yena kaMsena pAsyAmi yuvAbhyAM kiM tena pAtuM shakyate? aha ncha yena majjenena majjiShye, yuvAbhyAM kiM tena majjayituM shakyate? te jagaduH shakyate| ");
INSERT INTO sanitr_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","tadA sa uktavAn, yuvAM mama kaMsenAvashyaM pAsyathaH, mama majjanena cha yuvAmapi majjiShyethe, kintu yeShAM kR^ite mattAtena nirUpitam idaM tAn vihAyAnyaM kamapi maddakShiNapArshve vAmapArshve cha samupaveshayituM mamAdhikAro nAsti| ");
INSERT INTO sanitr_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","etAM kathAM shrutvAnye dashashiShyAstau bhrAtarau prati chukupuH| ");
INSERT INTO sanitr_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","kintu yIshuH svasamIpaM tAnAhUya jagAda, anyadeshIyalokAnAM narapatayastAn adhikurvvanti, ye tu mahAntaste tAn shAsati, iti yUyaM jAnItha| ");
INSERT INTO sanitr_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","kintu yuShmAkaM madhye na tathA bhavet, yuShmAkaM yaH kashchit mahAn bubhUShati, sa yuShmAn seveta; ");
INSERT INTO sanitr_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","yashcha yuShmAkaM madhye mukhyo bubhUShati, sa yuShmAkaM dAso bhavet| ");
INSERT INTO sanitr_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","itthaM manujaputraH sevyo bhavituM nahi, kintu sevituM bahUnAM paritrANamUlyArthaM svaprANAn dAtu nchAgataH| ");
INSERT INTO sanitr_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","anantaraM yirIhonagarAt teShAM bahirgamanasamaye tasya pashchAd bahavo lokA vavrajuH| ");
INSERT INTO sanitr_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","aparaM vartmapArshva upavishantau dvAvandhau tena mArgeNa yIsho rgamanaM nishamya prochchaiH kathayAmAsatuH, he prabho dAyUdaH santAna, Avayo rdayAM vidhehi| ");
INSERT INTO sanitr_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","tato lokAH sarvve tuShNImbhavatamityuktvA tau tarjayAmAsuH; tathApi tau punaruchchaiH kathayAmAsatuH he prabho dAyUdaH santAna, AvAM dayasva| ");
INSERT INTO sanitr_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","tadAnIM yIshuH sthagitaH san tAvAhUya bhAShitavAn, yuvayoH kR^ite mayA kiM karttarvyaM? yuvAM kiM kAmayethe? ");
INSERT INTO sanitr_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","tadA tAvuktavantau, prabho netrANi nau prasannAni bhaveyuH| ");
INSERT INTO sanitr_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","tadAnIM yIshustau prati pramannaH san tayo rnetrANi pasparsha, tenaiva tau suvIkShA nchakrAte tatpashchAt jagmutushcha| ");
INSERT INTO sanitr_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","anantaraM teShu yirUshAlamnagarasya samIpaverttino jaitunanAmakadharAdharasya samIpasthtiM baitphagigrAmam AgateShu, yIshuH shiShyadvayaM preShayan jagAda, ");
INSERT INTO sanitr_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","yuvAM sammukhasthagrAmaM gatvA baddhAM yAM savatsAM garddabhIM haThAt prApsyathaH, tAM mochayitvA madantikam AnayataM| ");
INSERT INTO sanitr_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","tatra yadi kashchit ki nchid vakShyati, tarhi vadiShyathaH, etasyAM prabhoH prayojanamAste, tena sa tatkShaNAt praheShyati| ");
INSERT INTO sanitr_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","sIyonaH kanyakAM yUyaM bhAShadhvamiti bhAratIM| pashya te namrashIlaH san nR^ipa Aruhya gardabhIM| arthAdAruhya tadvatsamAyAsyati tvadantikaM| ");
INSERT INTO sanitr_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","bhaviShyadvAdinoktaM vachanamidaM tadA saphalamabhUt| ");
INSERT INTO sanitr_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","anantaraM tau shShyiौ yIsho ryathAnideshaM taM grAmaM gatvA ");
INSERT INTO sanitr_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","gardabhIM tadvatsa ncha samAnItavantau, pashchAt tadupari svIyavasanAnI pAtayitvA tamArohayAmAsatuH| ");
INSERT INTO sanitr_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","tato bahavo lokA nijavasanAni pathi prasArayitumArebhire, katipayA janAshcha pAdapaparNAdikaM ChitvA pathi vistArayAmAsuH| ");
INSERT INTO sanitr_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","agragAminaH pashchAdgAminashcha manujA uchchairjaya jaya dAyUdaH santAneti jagaduH parameshvarasya nAmnA ya AyAti sa dhanyaH, sarvvoparisthasvargepi jayati| ");
INSERT INTO sanitr_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","itthaM tasmin yirUshAlamaM praviShTe ko.ayamiti kathanAt kR^itsnaM nagaraM cha nchalamabhavat| ");
INSERT INTO sanitr_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","tatra lokoH kathayAmAsuH, eSha gAlIlpradeshIya-nAsaratIya-bhaviShyadvAdI yIshuH| ");
INSERT INTO sanitr_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","anantaraM yIshurIshvarasya mandiraM pravishya tanmadhyAt krayavikrayiNo vahishchakAra; vaNijAM mudrAsanAnI kapotavikrayiNA nchasanAnI cha nyuvjayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","aparaM tAnuvAcha, eShA lipirAste, \"mama gR^ihaM prArthanAgR^ihamiti vikhyAsyati\", kintu yUyaM tad dasyUnAM gahvaraM kR^itavantaH| ");
INSERT INTO sanitr_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","tadanantaram andhakha nchalokAstasya samIpamAgatAH, sa tAn nirAmayAn kR^itavAn| ");
INSERT INTO sanitr_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","yadA pradhAnayAjakA adhyApakAshcha tena kR^itAnyetAni chitrakarmmANi dadR^ishuH, jaya jaya dAyUdaH santAna, mandire bAlakAnAm etAdR^isham uchchadhvaniM shushruvushcha, tadA mahAkruddhA babhUvaH, ");
INSERT INTO sanitr_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","taM paprachChushcha, ime yad vadanti, tat kiM tvaM shR^iNoShi? tato yIshustAn avochat, satyam; stanyapAyishishUnA ncha bAlakAnA ncha vaktrataH| svakIyaM mahimAnaM tvaM saMprakAshayasi svayaM| etadvAkyaM yUyaM kiM nApaThata? ");
INSERT INTO sanitr_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","tatastAn vihAya sa nagarAd baithaniyAgrAmaM gatvA tatra rajanIM yApayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","anantaraM prabhAte sati yIshuH punarapi nagaramAgachChan kShudhArtto babhUva| ");
INSERT INTO sanitr_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","tato mArgapArshva uDumbaravR^ikShamekaM vilokya tatsamIpaM gatvA patrANi vinA kimapi na prApya taM pAdapaM provAcha, adyArabhya kadApi tvayi phalaM na bhavatu; tena tatkShaNAt sa uDumbaramAhIruhaH shuShkatAM gataH| ");
INSERT INTO sanitr_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","tad dR^iShTvA shiShyA AshcharyyaM vij nAya kathayAmAsuH, AH, uDumvarapAdapo.atitUrNaM shuShko.abhavat| ");
INSERT INTO sanitr_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","tato yIshustAnuvAcha, yuShmAnahaM satyaM vadAmi, yadi yUyamasandigdhAH pratItha, tarhi yUyamapi kevaloDumvarapAdapaM pratItthaM karttuM shakShyatha, tanna, tvaM chalitvA sAgare pateti vAkyaM yuShmAbhirasmina shaile proktepi tadaiva tad ghaTiShyate| ");
INSERT INTO sanitr_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","tathA vishvasya prArthya yuShmAbhi ryad yAchiShyate, tadeva prApsyate| ");
INSERT INTO sanitr_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","anantaraM mandiraM pravishyopadeshanasamaye tatsamIpaM pradhAnayAjakAH prAchInalokAshchAgatya paprachChuH, tvayA kena sAmarthyanaitAni karmmANi kriyante? kena vA tubhyametAni sAmarthyAni dattAni? ");
INSERT INTO sanitr_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","tato yIshuH pratyavadat, ahamapi yuShmAn vAchamekAM pR^ichChAmi, yadi yUyaM taduttaraM dAtuM shakShyatha, tadA kena sAmarthyena karmmANyetAni karomi, tadahaM yuShmAn vakShyAmi| ");
INSERT INTO sanitr_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","yohano majjanaM kasyAj nayAbhavat? kimIshvarasya manuShyasya vA? tataste parasparaM vivichya kathayAmAsuH, yadIshvarasyeti vadAmastarhi yUyaM taM kuto na pratyaita? vAchametAM vakShyati| ");
INSERT INTO sanitr_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","manuShyasyeti vaktumapi lokebhyo bibhImaH, yataH sarvvairapi yohan bhaviShyadvAdIti j nAyate| ");
INSERT INTO sanitr_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","tasmAt te yIshuM pratyavadan, tad vayaM na vidmaH| tadA sa tAnuktavAn, tarhi kena sAmarathyena karmmANyetAnyahaM karomi, tadapyahaM yuShmAn na vakShyAmi| ");
INSERT INTO sanitr_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","kasyachijjanasya dvau sutAvAstAM sa ekasya sutasya samIpaM gatvA jagAda, he suta, tvamadya mama drAkShAkShetre karmma kartuM vraja| ");
INSERT INTO sanitr_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","tataH sa uktavAn, na yAsyAmi, kintu sheShe.anutapya jagAma| ");
INSERT INTO sanitr_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","anantaraM sonyasutasya samIpaM gatvA tathaiva kathtivAn; tataH sa pratyuvAcha, mahechCha yAmi, kintu na gataH| ");
INSERT INTO sanitr_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","etayoH putrayo rmadhye piturabhimataM kena pAlitaM? yuShmAbhiH kiM budhyate? tataste pratyUchuH, prathamena puुtreNa| tadAnIM yIshustAnuvAcha, ahaM yuShmAn tathyaM vadAmi, chaNDAlA gaNikAshcha yuShmAkamagrata Ishvarasya rAjyaM pravishanti| ");
INSERT INTO sanitr_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","yato yuShmAkaM samIpaM yohani dharmmapathenAgate yUyaM taM na pratItha, kintu chaNDAlA gaNikAshcha taM pratyAyan, tad vilokyApi yUyaM pratyetuM nAkhidyadhvaM| ");
INSERT INTO sanitr_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","aparamekaM dR^iShTAntaM shR^iNuta, kashchid gR^ihasthaH kShetre drAkShAlatA ropayitvA tachchaturdikShu vAraNIM vidhAya tanmadhye drAkShAyantraM sthApitavAn, mA ncha ncha nirmmitavAn, tataH kR^iShakeShu tat kShetraM samarpya svayaM dUradeshaM jagAma| ");
INSERT INTO sanitr_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","tadanantaraM phalasamaya upasthite sa phalAni prAptuM kR^iShIvalAnAM samIpaM nijadAsAn preShayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","kintu kR^iShIvalAstasya tAn dAseyAn dhR^itvA ka nchana prahR^itavantaH, ka nchana pAShANairAhatavantaH, ka nchana cha hatavantaH| ");
INSERT INTO sanitr_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","punarapi sa prabhuH prathamato.adhikadAseyAn preShayAmAsa, kintu te tAn pratyapi tathaiva chakruH| ");
INSERT INTO sanitr_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","anantaraM mama sute gate taM samAdariShyante, ityuktvA sheShe sa nijasutaM teShAM sannidhiM preShayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","kintu te kR^iShIvalAH sutaM vIkShya parasparam iti mantrayitum Arebhire, ayamuttarAdhikArI vayamenaM nihatyAsyAdhikAraM svavashIkariShyAmaH| ");
INSERT INTO sanitr_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","pashchAt te taM dhR^itvA drAkShAkShetrAd bahiH pAtayitvAbadhiShuH| ");
INSERT INTO sanitr_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","yadA sa drAkShAkShetrapatirAgamiShyati, tadA tAn kR^iShIvalAn kiM kariShyati? ");
INSERT INTO sanitr_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","tataste pratyavadan, tAn kaluShiNo dAruNayAtanAbhirAhaniShyati, ye cha samayAnukramAt phalAni dAsyanti, tAdR^isheShu kR^iShIvaleShu kShetraM samarpayiShyati| ");
INSERT INTO sanitr_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","tadA yIshunA te gaditAH, grahaNaM na kR^itaM yasya pAShANasya nichAyakaiH| pradhAnaprastaraH koNe saeva saMbhaviShyati| etat pareshituH karmmAsmadR^iShTAvadbhutaM bhavet| dharmmagranthe likhitametadvachanaM yuShmAbhiH kiM nApAThi? ");
INSERT INTO sanitr_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","tasmAdahaM yuShmAn vadAmi, yuShmatta IshvarIyarAjyamapanIya phalotpAdayitranyajAtaye dAyiShyate| ");
INSERT INTO sanitr_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","yo jana etatpAShANopari patiShyati, taM sa bhaMkShyate, kintvayaM pAShANo yasyopari patiShyati, taM sa dhUlivat chUrNIkariShyati| ");
INSERT INTO sanitr_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","tadAnIM prAdhanayAjakAH phirUshinashcha tasyemAM dR^iShTAntakathAM shrutvA so.asmAnuddishya kathitavAn, iti vij nAya taM dharttuM cheShTitavantaH; ");
INSERT INTO sanitr_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","kintu lokebhyo bibhyuH, yato lokaiH sa bhaviShyadvAdItyaj nAyi| ");
INSERT INTO sanitr_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","anantaraM yIshuH punarapi dR^iShTAntena tAn avAdIt, ");
INSERT INTO sanitr_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","svargIyarAjyam etAdR^ishasya nR^ipateH samaM, yo nija putraM vivAhayan sarvvAn nimantritAn AnetuM dAseyAn prahitavAn, ");
INSERT INTO sanitr_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","kintu te samAgantuM neShTavantaH| ");
INSERT INTO sanitr_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","tato rAjA punarapi dAsAnanyAn ityuktvA preShayAmAsa, nimantritAn vadata, pashyata, mama bhejyamAsAditamAste, nijavTaShAdipuShTajantUn mArayitvA sarvvaM khAdyadravyamAsAditavAn, yUyaM vivAhamAgachChata| ");
INSERT INTO sanitr_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","tathapi te tuchChIkR^itya kechit nijakShetraM kechid vANijyaM prati svasvamArgeNa chalitavantaH| ");
INSERT INTO sanitr_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","anye lokAstasya dAseyAn dhR^itvA daurAtmyaM vyavahR^itya tAnavadhiShuH| ");
INSERT INTO sanitr_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","anantaraM sa nR^ipatistAM vArttAM shrutvA krudhyan sainyAni prahitya tAn ghAtakAn hatvA teShAM nagaraM dAhayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","tataH sa nijadAseyAn babhAShe, vivAhIyaM bhojyamAsAditamAste, kintu nimantritA janA ayogyAH| ");
INSERT INTO sanitr_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","tasmAd yUyaM rAjamArgaM gatvA yAvato manujAn pashyata, tAvataeva vivAhIyabhojyAya nimantrayata| ");
INSERT INTO sanitr_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","tadA te dAseyA rAjamArgaM gatvA bhadrAn abhadrAn vA yAvato janAn dadR^ishuH, tAvataeva saMgR^ihyAnayan; tato.abhyAgatamanujai rvivAhagR^iham apUryyata| ");
INSERT INTO sanitr_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","tadAnIM sa rAjA sarvvAnabhyAgatAn draShTum abhyantaramAgatavAn; tadA tatra vivAhIyavasanahInamekaM janaM vIkShya taM jagAd, ");
INSERT INTO sanitr_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","he mitra,tvaM vivAhIyavasanaM vinA kathamatra praviShTavAn? tena sa niruttaro babhUva| ");
INSERT INTO sanitr_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","tadA rAjA nijAnucharAn avadat, etasya karacharaNAn baddhA yatra rodanaM dantairdantagharShaNa ncha bhavati, tatra vahirbhUtatamisre taM nikShipata| ");
INSERT INTO sanitr_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","itthaM bahava AhUtA alpe manobhimatAH| ");
INSERT INTO sanitr_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","anantaraM phirUshinaH pragatya yathA saMlApena tam unmAthe pAtayeyustathA mantrayitvA ");
INSERT INTO sanitr_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","herodIyamanujaiH sAkaM nijashiShyagaNena taM prati kathayAmAsuH, he guro, bhavAn satyaH satyamIshvarIyamArgamupadishati, kamapi mAnuShaM nAnurudhyate, kamapi nApekShate cha, tad vayaM jAnImaH| ");
INSERT INTO sanitr_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","ataH kaisarabhUpAya karo.asmAkaM dAtavyo na vA? atra bhavatA kiM budhyate? tad asmAn vadatu| ");
INSERT INTO sanitr_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","tato yIshusteShAM khalatAM vij nAya kathitavAn, re kapaTinaH yuyaM kuto mAM parikShadhve? ");
INSERT INTO sanitr_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","tatkaradAnasya mudrAM mAM darshayata| tadAnIM taistasya samIpaM mudrAchaturthabhAga AnIte ");
INSERT INTO sanitr_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","sa tAn paprachCha, atra kasyeyaM mUrtti rnAma chAste? te jagaduH, kaisarabhUpasya| ");
INSERT INTO sanitr_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","tataH sa uktavAna, kaisarasya yat tat kaisarAya datta, Ishvarasya yat tad IshvarAya datta| ");
INSERT INTO sanitr_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","iti vAkyaM nishamya te vismayaM vij nAya taM vihAya chalitavantaH| ");
INSERT INTO sanitr_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","tasminnahani sidUkino.arthAt shmashAnAt notthAsyantIti vAkyaM ye vadanti, te yIsheाrantikam Agatya paprachChuH, ");
INSERT INTO sanitr_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","he guro, kashchinmanujashchet niHsantAnaH san prANAn tyajati, tarhi tasya bhrAtA tasya jAyAM vyuhya bhrAtuH santAnam utpAdayiShyatIti mUsA AdiShTavAn| ");
INSERT INTO sanitr_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","kintvasmAkamatra ke.api janAH saptasahodarA Asan, teShAM jyeShTha ekAM kanyAM vyavahAt, aparaM prANatyAgakAle svayaM niHsantAnaH san tAM striyaM svabhrAtari samarpitavAn, ");
INSERT INTO sanitr_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","tato dvitIyAdisaptamAntAshcha tathaiva chakruH| ");
INSERT INTO sanitr_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","sheShe sApI nArI mamAra| ");
INSERT INTO sanitr_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","mR^itAnAm utthAnasamaye teShAM saptAnAM madhye sA nArI kasya bhAryyA bhaviShyati? yasmAt sarvvaeva tAM vyavahan| ");
INSERT INTO sanitr_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","tato yIshuH pratyavAdIt, yUyaM dharmmapustakam IshvarIyAM shakti ncha na vij nAya bhrAntimantaH| ");
INSERT INTO sanitr_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","utthAnaprAptA lokA na vivahanti, na cha vAchA dIyante, kintvIshvarasya svargasthadUtAnAM sadR^ishA bhavanti| ");
INSERT INTO sanitr_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","aparaM mR^itAnAmutthAnamadhi yuShmAn pratIyamIshvaroktiH, ");
INSERT INTO sanitr_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","\"ahamibrAhIma Ishvara ishAka Ishvaro yAkUba Ishvara\" iti kiM yuShmAbhi rnApAThi? kintvIshvaro jIvatAm Ishvara:, sa mR^itAnAmIshvaro nahi| ");
INSERT INTO sanitr_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","iti shrutvA sarvve lokAstasyopadeshAd vismayaM gatAH| ");
INSERT INTO sanitr_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","anantaraM sidUkinAm niruttaratvavArtAM nishamya phirUshina ekatra militavantaH, ");
INSERT INTO sanitr_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","teShAmeko vyavasthApako yIshuM parIkShituM papachCha, ");
INSERT INTO sanitr_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","he guro vyavasthAshAstramadhye kAj nA shreShThA? ");
INSERT INTO sanitr_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","tato yIshuruvAcha, tvaM sarvvAntaHkaraNaiH sarvvaprANaiH sarvvachittaishcha sAkaM prabhau parameshvare prIyasva, ");
INSERT INTO sanitr_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","eShA prathamamahAj nA| tasyAH sadR^ishI dvitIyAj naiShA, ");
INSERT INTO sanitr_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","tava samIpavAsini svAtmanIva prema kuru| ");
INSERT INTO sanitr_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","anayo rdvayorAj nayoH kR^itsnavyavasthAyA bhaviShyadvaktR^igranthasya cha bhArastiShThati| ");
INSERT INTO sanitr_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","anantaraM phirUshinAm ekatra sthitikAle yIshustAn paprachCha, ");
INSERT INTO sanitr_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","khrIShTamadhi yuShmAkaM kIdR^igbodho jAyate? sa kasya santAnaH? tataste pratyavadan, dAyUdaH santAnaH| ");
INSERT INTO sanitr_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","tadA sa uktavAn, tarhi dAyUd katham AtmAdhiShThAnena taM prabhuM vadati ? ");
INSERT INTO sanitr_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","yathA mama prabhumidaM vAkyamavadat parameshvaraH| tavArIn pAdapIThaM te yAvannahi karomyahaM| tAvat kAlaM madIye tvaM dakShapArshva upAvisha| ato yadi dAyUd taM prabhuM vadati, rtiha sa kathaM tasya santAno bhavati? ");
INSERT INTO sanitr_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","tadAnIM teShAM kopi tadvAkyasya kimapyuttaraM dAtuM nAshaknot; ");
INSERT INTO sanitr_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","taddinamArabhya taM kimapi vAkyaM praShTuM kasyApi sAhaso nAbhavat| ");
INSERT INTO sanitr_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","anantaraM yIshu rjananivahaM shiShyAMshchAvadat, ");
INSERT INTO sanitr_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","adhyApakAH phirUshinashcha mUsAsane upavishanti, ");
INSERT INTO sanitr_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ataste yuShmAn yadyat mantum Aj nApayanti, tat manyadhvaM pAlayadhva ncha, kintu teShAM karmmAnurUpaM karmma na kurudhvaM; yatasteShAM vAkyamAtraM sAraM kAryye kimapi nAsti| ");
INSERT INTO sanitr_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","te durvvahAn gurutarAn bhArAn badvvA manuShyANAM skandhepari samarpayanti, kintu svayama NgulyaikayApi na chAlayanti| ");
INSERT INTO sanitr_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","kevalaM lokadarshanAya sarvvakarmmANi kurvvanti; phalataH paTTabandhAn prasAryya dhArayanti, svavastreShu cha dIrghagranthIn dhArayanti; ");
INSERT INTO sanitr_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","bhojanabhavana uchchasthAnaM, bhajanabhavane pradhAnamAsanaM, ");
INSERT INTO sanitr_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","haTThe namaskAraM gururiti sambodhana nchaitAni sarvvANi vA nChanti| ");
INSERT INTO sanitr_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","kintu yUyaM gurava iti sambodhanIyA mA bhavata, yato yuShmAkam ekaH khrIShTaeva guru ");
INSERT INTO sanitr_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ryUyaM sarvve mitho bhrAtarashcha| punaH pR^ithivyAM kamapi piteti mA sambudhyadhvaM, yato yuShmAkamekaH svargasthaeva pitA| ");
INSERT INTO sanitr_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","yUyaM nAyaketi sambhAShitA mA bhavata, yato yuShmAkamekaH khrIShTaeva nAyakaH| ");
INSERT INTO sanitr_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","aparaM yuShmAkaM madhye yaH pumAn shreShThaH sa yuShmAn seviShyate| ");
INSERT INTO sanitr_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","yato yaH svamunnamati, sa nataH kariShyate; kintu yaH kashchit svamavanataM karoti, sa unnataH kariShyate| ");
INSERT INTO sanitr_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","hanta kapaTina upAdhyAyAH phirUshinashcha, yUyaM manujAnAM samakShaM svargadvAraM rundha, yUyaM svayaM tena na pravishatha, pravivikShUnapi vArayatha| vata kapaTina upAdhyAyAH phirUshinashcha yUyaM ChalAd dIrghaM prArthya vidhavAnAM sarvvasvaM grasatha, yuShmAkaM ghorataradaNDo bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","hanta kapaTina upAdhyAyAH phirUshinashcha, yUyamekaM svadharmmAvalambinaM karttuM sAgaraM bhUmaNDala ncha pradakShiNIkurutha, ");
INSERT INTO sanitr_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","ka nchana prApya svato dviguNanarakabhAjanaM taM kurutha| ");
INSERT INTO sanitr_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","vata andhapathadarshakAH sarvve, yUyaM vadatha, mandirasya shapathakaraNAt kimapi na deyaM; kintu mandirasthasuvarNasya shapathakaraNAd deyaM| ");
INSERT INTO sanitr_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","he mUDhA he andhAH suvarNaM tatsuvarNapAvakamandiram etayorubhayo rmadhye kiM shreyaH? ");
INSERT INTO sanitr_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","anyachcha vadatha, yaj navedyAH shapathakaraNAt kimapi na deyaM, kintu taduparisthitasya naivedyasya shapathakaraNAd deyaM| ");
INSERT INTO sanitr_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","he mUDhA he andhAH, naivedyaM tannaivedyapAvakavediretayorubhayo rmadhye kiM shreyaH? ");
INSERT INTO sanitr_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ataH kenachid yaj navedyAH shapathe kR^ite taduparisthasya sarvvasya shapathaH kriyate| ");
INSERT INTO sanitr_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","kenachit mandirasya shapathe kR^ite mandiratannivAsinoH shapathaH kriyate| ");
INSERT INTO sanitr_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","kenachit svargasya shapathe kR^ite IshvarIyasiMhAsanataduparyyupaviShTayoH shapathaH kriyate| ");
INSERT INTO sanitr_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","hanta kapaTina upAdhyAyAH phirUshinashcha, yUyaM podinAyAH sitachChatrAyA jIrakasya cha dashamAMshAn dattha, kintu vyavasthAyA gurutarAn nyAyadayAvishvAsAn parityajatha; ime yuShmAbhirAcharaNIyA amI cha na laMghanIyAH| ");
INSERT INTO sanitr_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","he andhapathadarshakA yUyaM mashakAn apasArayatha, kintu mahA NgAn grasatha| ");
INSERT INTO sanitr_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","hanta kapaTina upAdhyAyAH phirUshinashcha, yUyaM pAnapAtrANAM bhojanapAtrANA ncha bahiH pariShkurutha; kintu tadabhyantaraM durAtmatayA kaluSheNa cha paripUrNamAste| ");
INSERT INTO sanitr_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","he andhAH phirUshilokA Adau pAnapAtrANAM bhojanapAtrANA nchAbhyantaraM pariShkuruta, tena teShAM bahirapi pariShkAriShyate| ");
INSERT INTO sanitr_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","hanta kapaTina upAdhyAyAH phirUshinashcha, yUyaM shuklIkR^itashmashAnasvarUpA bhavatha, yathA shmashAnabhavanasya bahishchAru, kintvabhyantaraM mR^italokAnAM kIkashaiH sarvvaprakAramalena cha paripUrNam; ");
INSERT INTO sanitr_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","tathaiva yUyamapi lokAnAM samakShaM bahirdhArmmikAH kintvantaHkaraNeShu kevalakApaTyAdharmmAbhyAM paripUrNAH| ");
INSERT INTO sanitr_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","hA hA kapaTina upAdhyAyAH phirUshinashcha, yUyaM bhaviShyadvAdinAM shmashAnagehaM nirmmAtha, sAdhUnAM shmashAnaniketanaM shobhayatha ");
INSERT INTO sanitr_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","vadatha cha yadi vayaM sveShAM pUrvvapuruShANAM kAla asthAsyAma, tarhi bhaviShyadvAdinAM shoNitapAtane teShAM sahabhAgino nAbhaviShyAma| ");
INSERT INTO sanitr_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ato yUyaM bhaviShyadvAdighAtakAnAM santAnA iti svayameva sveShAM sAkShyaM dattha| ");
INSERT INTO sanitr_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","ato yUyaM nijapUrvvapuruShANAM parimANapAtraM paripUrayata| ");
INSERT INTO sanitr_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","re bhujagAH kR^iShNabhujagavaMshAH, yUyaM kathaM narakadaNDAd rakShiShyadhve| ");
INSERT INTO sanitr_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","pashyata, yuShmAkamantikam ahaM bhaviShyadvAdino buddhimata upAdhyAyAMshcha preShayiShyAmi, kintu teShAM katipayA yuShmAbhi rghAniShyante, krushe cha ghAniShyante, kechid bhajanabhavane kaShAbhirAghAniShyante, nagare nagare tADiShyante cha; ");
INSERT INTO sanitr_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","tena satpuruShasya hAbilo raktapAtamArabhya berikhiyaH putraM yaM sikhariyaM yUyaM mandirayaj navedyo rmadhye hatavantaH, tadIyashoNitapAtaM yAvad asmin deshe yAvatAM sAdhupuruShANAM shoNitapAto .abhavat tat sarvveShAmAgasAM daNDA yuShmAsu varttiShyante| ");
INSERT INTO sanitr_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ahaM yuShmAnta tathyaM vadAmi, vidyamAne.asmin puruShe sarvve varttiShyante| ");
INSERT INTO sanitr_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","he yirUshAlam he yirUshAlam nagari tvaM bhaviShyadvAdino hatavatI, tava samIpaM preritAMshcha pAShANairAhatavatI, yathA kukkuTI shAvakAn pakShAdhaH saMgR^ihlAti, tathA tava santAnAn saMgrahItuM ahaM bahuvAram aichChaM; kintu tvaM na samamanyathAH| ");
INSERT INTO sanitr_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","pashyata yaShmAkaM vAsasthAnam uchChinnaM tyakShyate| ");
INSERT INTO sanitr_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ahaM yuShmAn tathyaM vadAmi, yaH parameshvarasya nAmnAgachChati, sa dhanya iti vANIM yAvanna vadiShyatha, tAvat mAM puna rna drakShyatha| ");
INSERT INTO sanitr_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","anantaraM yIshu ryadA mandirAd bahi rgachChati, tadAnIM shiShyAstaM mandiranirmmANaM darshayitumAgatAH| ");
INSERT INTO sanitr_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","tato yIshustAnuvAcha, yUyaM kimetAni na pashyatha? yuShmAnahaM satyaM vadAmi, etannichayanasya pAShANaikamapyanyapAShANeाpari na sthAsyati sarvvANi bhUmisAt kAriShyante| ");
INSERT INTO sanitr_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","anantaraM tasmin jaitunaparvvatopari samupaviShTe shiShyAstasya samIpamAgatya guptaM paprachChuH, etA ghaTanAH kadA bhaviShyanti? bhavata Agamanasya yugAntasya cha kiM lakShma? tadasmAn vadatu| ");
INSERT INTO sanitr_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","tadAnIM yIshustAnavochat, avadhadvvaM, kopi yuShmAn na bhramayet| ");
INSERT INTO sanitr_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","bahavo mama nAma gR^ihlanta AgamiShyanti, khrIShTo.ahameveti vAchaM vadanto bahUn bhramayiShyanti| ");
INSERT INTO sanitr_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","yUya ncha saMgrAmasya raNasya chADambaraM shroShyatha, avadhadvvaM tena cha nchalA mA bhavata, etAnyavashyaM ghaTiShyante, kintu tadA yugAnto nahi| ");
INSERT INTO sanitr_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","aparaM deshasya vipakSho desho rAjyasya vipakSho rAjyaM bhaviShyati, sthAne sthAne cha durbhikShaM mahAmArI bhUkampashcha bhaviShyanti, ");
INSERT INTO sanitr_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","etAni duHkhopakramAH| ");
INSERT INTO sanitr_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","tadAnIM lokA duHkhaM bhojayituM yuShmAn parakareShu samarpayiShyanti haniShyanti cha, tathA mama nAmakAraNAd yUyaM sarvvadeshIyamanujAnAM samIpe ghR^iNArhA bhaviShyatha| ");
INSERT INTO sanitr_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","bahuShu vighnaM prAptavatsu parasparam R^iृtIyAM kR^itavatsu cha eko.aparaM parakareShu samarpayiShyati| ");
INSERT INTO sanitr_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","tathA bahavo mR^iShAbhaviShyadvAdina upasthAya bahUn bhramayiShyanti| ");
INSERT INTO sanitr_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","duShkarmmaNAM bAhulyA ncha bahUnAM prema shItalaM bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","kintu yaH kashchit sheShaM yAvad dhairyyamAshrayate, saeva paritrAyiShyate| ");
INSERT INTO sanitr_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","aparaM sarvvadeshIyalokAn pratimAkShI bhavituM rAjasya shubhasamAchAraH sarvvajagati prachAriShyate, etAdR^ishi sati yugAnta upasthAsyati| ");
INSERT INTO sanitr_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","ato yat sarvvanAshakR^idghR^iNArhaM vastu dAniyelbhaviShyadvadinA proktaM tad yadA puNyasthAne sthApitaM drakShyatha, (yaH paThati, sa budhyatAM) ");
INSERT INTO sanitr_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","tadAnIM ye yihUdIyadeshe tiShThanti, te parvvateShu palAyantAM| ");
INSERT INTO sanitr_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","yaH kashchid gR^ihapR^iShThe tiShThati, sa gR^ihAt kimapi vastvAnetum adheा nAvarohet| ");
INSERT INTO sanitr_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","yashcha kShetre tiShThati, sopi vastramAnetuM parAvR^itya na yAyAt| ");
INSERT INTO sanitr_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","tadAnIM garbhiNIstanyapAyayitrINAM durgati rbhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ato yaShmAkaM palAyanaM shItakAle vishrAmavAre vA yanna bhavet, tadarthaM prArthayadhvam| ");
INSERT INTO sanitr_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","A jagadArambhAd etatkAlaparyyanantaM yAdR^ishaH kadApi nAbhavat na cha bhaviShyati tAdR^isho mahAkleshastadAnIm upasthAsyati| ");
INSERT INTO sanitr_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","tasya kleshasya samayo yadi hsvo na kriyeta, tarhi kasyApi prANino rakShaNaM bhavituM na shaknuyAt, kintu manonItamanujAnAM kR^ite sa kAlo hsvIkariShyate| ");
INSERT INTO sanitr_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","apara ncha pashyata, khrIShTo.atra vidyate, vA tatra vidyate, tadAnIM yadI kashchid yuShmAna iti vAkyaM vadati, tathApi tat na pratIt| ");
INSERT INTO sanitr_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","yato bhAktakhrIShTA bhAktabhaviShyadvAdinashcha upasthAya yAni mahanti lakShmANi chitrakarmmANi cha prakAshayiShyanti, tai ryadi sambhavet tarhi manonItamAnavA api bhrAmiShyante| ");
INSERT INTO sanitr_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","pashyata, ghaTanAtaH pUrvvaM yuShmAn vArttAm avAdiSham| ");
INSERT INTO sanitr_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","ataH pashyata, sa prAntare vidyata iti vAkye kenachit kathitepi bahi rmA gachChata, vA pashyata, sontaHpure vidyate, etadvAkya uktepi mA pratIta| ");
INSERT INTO sanitr_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","yato yathA vidyut pUrvvadisho nirgatya pashchimadishaM yAvat prakAshate, tathA mAnuShaputrasyApyAgamanaM bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","yatra shavastiShThati, tatreva gR^idhrA milanti| ");
INSERT INTO sanitr_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","aparaM tasya kleshasamayasyAvyavahitaparatra sUryyasya tejo lopsyate, chandramA jyosnAM na kariShyati, nabhaso nakShatrANi patiShyanti, gagaNIyA grahAshcha vichaliShyanti| ");
INSERT INTO sanitr_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","tadAnIm AkAshamadhye manujasutasya lakShma darshiShyate, tato nijaparAkrameNa mahAtejasA cha meghArUDhaM manujasutaM nabhasAgachChantaM vilokya pR^ithivyAH sarvvavaMshIyA vilapiShyanti| ");
INSERT INTO sanitr_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","tadAnIM sa mahAshabdAyamAnatUryyA vAdakAn nijadUtAn praheShyati, te vyomna ekasImAto.aparasImAM yAvat chaturdishastasya manonItajanAn AnIya melayiShyanti| ");
INSERT INTO sanitr_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","uDumbarapAdapasya dR^iShTAntaM shikShadhvaM; yadA tasya navInAH shAkhA jAyante, pallavAdishcha nirgachChati, tadA nidAghakAlaH savidho bhavatIti yUyaM jAnItha; ");
INSERT INTO sanitr_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","tadvad etA ghaTanA dR^iShTvA sa samayo dvAra upAsthAd iti jAnIta| ");
INSERT INTO sanitr_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","yuShmAnahaM tathyaM vadAmi, idAnIntanajanAnAM gamanAt pUrvvameva tAni sarvvANi ghaTiShyante| ");
INSERT INTO sanitr_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","nabhomedinyo rluptayorapi mama vAk kadApi na lopsyate| ");
INSERT INTO sanitr_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","aparaM mama tAtaM vinA mAnuShaH svargastho dUto vA kopi taddinaM taddaNDa ncha na j nApayati| ");
INSERT INTO sanitr_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","aparaM nohe vidyamAne yAdR^ishamabhavat tAdR^ishaM manujasutasyAgamanakAlepi bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","phalato jalAplAvanAt pUrvvaM yaddinaM yAvat nohaH potaM nArohat, tAvatkAlaM yathA manuShyA bhojane pAne vivahane vivAhane cha pravR^ittA Asan; ");
INSERT INTO sanitr_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","aparam AplAvitoyamAgatya yAvat sakalamanujAn plAvayitvA nAnayat, tAvat te yathA na vidAmAsuH, tathA manujasutAgamanepi bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","tadA kShetrasthitayordvayoreko dhAriShyate, aparastyAjiShyate| ");
INSERT INTO sanitr_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","tathA peShaNyA piMShatyorubhayo ryoShitorekA dhAriShyate.aparA tyAjiShyate| ");
INSERT INTO sanitr_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","yuShmAkaM prabhuH kasmin daNDa AgamiShyati, tad yuShmAbhi rnAvagamyate, tasmAt jAgrataH santastiShThata| ");
INSERT INTO sanitr_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","kutra yAme stena AgamiShyatIti ched gR^ihastho j nAtum ashakShyat, tarhi jAgaritvA taM sandhiM karttitum avArayiShyat tad jAnIta| ");
INSERT INTO sanitr_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","yuShmAbhiravadhIyatAM, yato yuShmAbhi ryatra na budhyate, tatraiva daNDe manujasuta AyAsyati| ");
INSERT INTO sanitr_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","prabhu rnijaparivArAn yathAkAlaM bhojayituM yaM dAsam adhyakShIkR^itya sthApayati, tAdR^isho vishvAsyo dhImAn dAsaH kaH? ");
INSERT INTO sanitr_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","prabhurAgatya yaM dAsaM tathAcharantaM vIkShate, saeva dhanyaH| ");
INSERT INTO sanitr_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","yuShmAnahaM satyaM vadAmi, sa taM nijasarvvasvasyAdhipaM kariShyati| ");
INSERT INTO sanitr_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","kintu prabhurAgantuM vilambata iti manasi chintayitvA yo duShTo dAso ");
INSERT INTO sanitr_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49",".aparadAsAn praharttuM mattAnAM sa Nge bhoktuM pAtu ncha pravarttate, ");
INSERT INTO sanitr_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","sa dAso yadA nApekShate, ya ncha daNDaM na jAnAti, tatkAlaeva tatprabhurupasthAsyati| ");
INSERT INTO sanitr_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","tadA taM daNDayitvA yatra sthAne rodanaM dantagharShaNa nchAsAte, tatra kapaTibhiH sAkaM taddashAM nirUpayiShyati| ");
INSERT INTO sanitr_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","yA dasha kanyAH pradIpAn gR^ihlatyo varaM sAkShAt karttuM bahiritAH, tAbhistadA svargIyarAjyasya sAdR^ishyaM bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","tAsAM kanyAnAM madhye pa ncha sudhiyaH pa ncha durdhiya Asan| ");
INSERT INTO sanitr_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","yA durdhiyastAH pradIpAn sa Nge gR^ihItvA tailaM na jagR^ihuH, ");
INSERT INTO sanitr_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","kintu sudhiyaH pradIpAn pAtreNa taila ncha jagR^ihuH| ");
INSERT INTO sanitr_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","anantaraM vare vilambite tAH sarvvA nidrAviShTA nidrAM jagmuH| ");
INSERT INTO sanitr_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","anantaram arddharAtre pashyata vara AgachChati, taM sAkShAt karttuM bahiryAteti janaravAt ");
INSERT INTO sanitr_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","tAH sarvvAH kanyA utthAya pradIpAn AsAdayituM Arabhanta| ");
INSERT INTO sanitr_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","tato durdhiyaH sudhiya UchuH, ki nchit tailaM datta, pradIpA asmAkaM nirvvANAH| ");
INSERT INTO sanitr_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","kintu sudhiyaH pratyavadan, datte yuShmAnasmAMshcha prati tailaM nyUnIbhavet, tasmAd vikretR^iNAM samIpaM gatvA svArthaM tailaM krINIta| ");
INSERT INTO sanitr_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","tadA tAsu kretuM gatAsu vara AjagAma, tato yAH sajjitA Asan, tAstena sAkaM vivAhIyaM veshma pravivishuH| ");
INSERT INTO sanitr_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","anantaraM dvAre ruddhe aparAH kanyA Agatya jagaduH, he prabho, he prabho, asmAn prati dvAraM mochaya| ");
INSERT INTO sanitr_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","kintu sa uktavAn, tathyaM vadAmi, yuShmAnahaM na vedmi| ");
INSERT INTO sanitr_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","ato jAgrataH santastiShThata, manujasutaH kasmin dine kasmin daNDe vAgamiShyati, tad yuShmAbhi rna j nAyate| ");
INSERT INTO sanitr_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","aparaM sa etAdR^ishaH kasyachit puMsastulyaH, yo dUradeshaM prati yAtrAkAle nijadAsAn AhUya teShAM svasvasAmarthyAnurUpam ");
INSERT INTO sanitr_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ekasmin mudrANAM pa ncha poTalikAH anyasmiMshcha dve poTalike aparasmiMshcha poTalikaikAm itthaM pratijanaM samarpya svayaM pravAsaM gatavAn| ");
INSERT INTO sanitr_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","anantaraM yo dAsaH pa ncha poTalikAH labdhavAn, sa gatvA vANijyaM vidhAya tA dviguNIchakAra| ");
INSERT INTO sanitr_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","yashcha dAso dve poTalike alabhata, sopi tA mudrA dviguNIchakAra| ");
INSERT INTO sanitr_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","kintu yo dAsa ekAM poTalikAM labdhavAn, sa gatvA bhUmiM khanitvA tanmadhye nijaprabhostA mudrA gopayA nchakAra| ");
INSERT INTO sanitr_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","tadanantaraM bahutithe kAle gate teShAM dAsAnAM prabhurAgatya tairdAsaiH samaM gaNayA nchakAra| ");
INSERT INTO sanitr_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","tadAnIM yaH pa ncha poTalikAH prAptavAn sa tA dviguNIkR^itamudrA AnIya jagAda; he prabho, bhavatA mayi pa ncha poTalikAH samarpitAH, pashyatu, tA mayA dviguNIkR^itAH| ");
INSERT INTO sanitr_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","tadAnIM tasya prabhustamuvAcha, he uttama vishvAsya dAsa, tvaM dhanyosi, stokena vishvAsyo jAtaH, tasmAt tvAM bahuvittAdhipaM karomi, tvaM svaprabhoH sukhasya bhAgI bhava| ");
INSERT INTO sanitr_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","tato yena dve poTalike labdhe sopyAgatya jagAda, he prabho, bhavatA mayi dve poTalike samarpite, pashyatu te mayA dviguNIkR^ite| ");
INSERT INTO sanitr_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","tena tasya prabhustamavochat, he uttama vishvAsya dAsa, tvaM dhanyosi, stokena vishvAsyo jAtaH, tasmAt tvAM bahudraviNAdhipaM karomi, tvaM nijaprabhoH sukhasya bhAgI bhava| ");
INSERT INTO sanitr_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","anantaraM ya ekAM poTalikAM labdhavAn, sa etya kathitavAn, he prabho, tvAM kaThinanaraM j nAtavAn, tvayA yatra noptaM, tatraiva kR^ityate, yatra cha na kIrNaM, tatraiva saMgR^ihyate| ");
INSERT INTO sanitr_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","atohaM sasha NkaH san gatvA tava mudrA bhUmadhye saMgopya sthApitavAn, pashya, tava yat tadeva gR^ihANa| ");
INSERT INTO sanitr_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","tadA tasya prabhuH pratyavadat re duShTAlasa dAsa, yatrAhaM na vapAmi, tatra Chinadmi, yatra cha na kirAmi, tatreva saMgR^ihlAmIti chedajAnAstarhi ");
INSERT INTO sanitr_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","vaNikShu mama vittArpaNaM tavochitamAsIt, yenAhamAgatya vR^idvyA sAkaM mUlamudrAH prApsyam| ");
INSERT INTO sanitr_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","atosmAt tAM poTalikAm AdAya yasya dasha poTalikAH santi tasminnarpayata| ");
INSERT INTO sanitr_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","yena vardvyate tasminnaivArpiShyate, tasyaiva cha bAhulyaM bhaviShyati, kintu yena na vardvyate, tasyAntike yat ki nchana tiShThati, tadapi punarneShyate| ");
INSERT INTO sanitr_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","aparaM yUyaM tamakarmmaNyaM dAsaM nItvA yatra sthAne krandanaM dantagharShaNa ncha vidyete, tasmin bahirbhUtatamasi nikShipata| ");
INSERT INTO sanitr_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","yadA manujasutaH pavitradUtAn sa NginaH kR^itvA nijaprabhAvenAgatya nijatejomaye siMhAsane nivekShyati, ");
INSERT INTO sanitr_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","tadA tatsammukhe sarvvajAtIyA janA saMmeliShyanti| tato meShapAlako yathA ChAgebhyo.avIn pR^ithak karoti tathA sopyekasmAdanyam itthaM tAn pR^ithaka kR^itvAvIn ");
INSERT INTO sanitr_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","dakShiNe ChAgAMshcha vAme sthApayiShyati| ");
INSERT INTO sanitr_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","tataH paraM rAjA dakShiNasthitAn mAnavAn vadiShyati, AgachChata mattAtasyAnugrahabhAjanAni, yuShmatkR^ita A jagadArambhat yad rAjyam AsAditaM tadadhikuruta| ");
INSERT INTO sanitr_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","yato bubhukShitAya mahyaM bhojyam adatta, pipAsitAya peyamadatta, videshinaM mAM svasthAnamanayata, ");
INSERT INTO sanitr_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","vastrahInaM mAM vasanaM paryyadhApayata, pIDItaM mAM draShTumAgachChata, kArAstha ncha mAM vIkShituma AgachChata| ");
INSERT INTO sanitr_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","tadA dhArmmikAH prativadiShyanti, he prabho, kadA tvAM kShudhitaM vIkShya vayamabhojayAma? vA pipAsitaM vIkShya apAyayAma? ");
INSERT INTO sanitr_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","kadA vA tvAM videshinaM vilokya svasthAnamanayAma? kadA vA tvAM nagnaM vIkShya vasanaM paryyadhApayAma? ");
INSERT INTO sanitr_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","kadA vA tvAM pIDitaM kArAstha ncha vIkShya tvadantikamagachChAma? ");
INSERT INTO sanitr_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","tadAnIM rAjA tAn prativadiShyati, yuShmAnahaM satyaM vadAmi, mamaiteShAM bhrAtR^iNAM madhye ka nchanaikaM kShudratamaM prati yad akuruta, tanmAM pratyakuruta| ");
INSERT INTO sanitr_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","pashchAt sa vAmasthitAn janAn vadiShyati, re shApagrastAH sarvve, shaitAne tasya dUtebhyashcha yo.anantavahnirAsAdita Aste, yUyaM madantikAt tamagniM gachChata| ");
INSERT INTO sanitr_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","yato kShudhitAya mahyamAhAraM nAdatta, pipAsitAya mahyaM peyaM nAdatta, ");
INSERT INTO sanitr_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","videshinaM mAM svasthAnaM nAnayata, vasanahInaM mAM vasanaM na paryyadhApayata, pIDitaM kArAstha ncha mAM vIkShituM nAgachChata| ");
INSERT INTO sanitr_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","tadA te prativadiShyanti, he prabho, kadA tvAM kShudhitaM vA pipAsitaM vA videshinaM vA nagnaM vA pIDitaM vA kArAsthaM vIkShya tvAM nAsevAmahi? ");
INSERT INTO sanitr_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","tadA sa tAn vadiShyati, tathyamahaM yuShmAn bravImi, yuShmAbhireShAM ka nchana kShodiShThaM prati yannAkAri, tanmAM pratyeva nAkAri| ");
INSERT INTO sanitr_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","pashchAdamyanantashAstiM kintu dhArmmikA anantAyuShaM bhoktuM yAsyanti| ");
INSERT INTO sanitr_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","yIshuretAn prastAvAn samApya shiShyAnUche, ");
INSERT INTO sanitr_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","yuShmAbhi rj nAtaM dinadvayAt paraM nistAramaha upasthAsyati, tatra manujasutaH krushena hantuM parakareShu samarpiShyate| ");
INSERT INTO sanitr_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","tataH paraM pradhAnayAjakAdhyApakaprA nchaH kiyaphAnAmno mahAyAjakasyATTAlikAyAM militvA ");
INSERT INTO sanitr_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","kenopAyena yIshuM dhR^itvA hantuM shaknuyuriti mantrayA nchakruH| ");
INSERT INTO sanitr_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","kintu tairuktaM mahakAle na dharttavyaH, dhR^ite prajAnAM kalahena bhavituM shakyate| ");
INSERT INTO sanitr_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","tato baithaniyApure shimonAkhyasya kuShThino veshmani yIshau tiShThati ");
INSERT INTO sanitr_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","kAchana yoShA shvetopalabhAjanena mahArghyaM sugandhi tailamAnIya bhojanAyopavishatastasya shirobhyaShechat| ");
INSERT INTO sanitr_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","kintu tadAlokya tachChiShyaiH kupitairuktaM, kuta itthamapavyayate? ");
INSERT INTO sanitr_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","chedidaM vyakreShyata, tarhi bhUrimUlyaM prApya daridrebhyo vyatAriShyata| ");
INSERT INTO sanitr_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","yIshunA tadavagatya te samuditAH, yoShAmenAM kuto duHkhinIM kurutha, sA mAM prati sAdhu karmmAkArShIt| ");
INSERT INTO sanitr_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","yuShmAkamaM samIpe daridrAH satatamevAsate, kintu yuShmAkamantikehaM nAse satataM| ");
INSERT INTO sanitr_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","sA mama kAyopari sugandhitailaM siktvA mama shmashAnadAnakarmmAkArShIt| ");
INSERT INTO sanitr_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","atohaM yuShmAn tathyaM vadAmi sarvvasmin jagati yatra yatraiSha susamAchAraH prachAriShyate, tatra tatraitasyA nAryyAH smaraNArtham karmmedaM prachAriShyate| ");
INSERT INTO sanitr_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","tato dvAdashashiShyANAm IShkariyotIyayihUdAnAmaka ekaH shiShyaH pradhAnayAjakAnAmantikaM gatvA kathitavAn, ");
INSERT INTO sanitr_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","yadi yuShmAkaM kareShu yIshuM samarpayAmi, tarhi kiM dAsyatha? tadAnIM te tasmai triMshanmudrA dAtuM sthirIkR^itavantaH| ");
INSERT INTO sanitr_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","sa tadArabhya taM parakareShu samarpayituM suyogaM cheShTitavAn| ");
INSERT INTO sanitr_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","anantaraM kiNvashUnyapUpaparvvaNaH prathamehni shiShyA yIshum upagatya paprachChuH bhavatkR^ite kutra vayaM nistAramahabhojyam AyojayiShyAmaH? bhavataH kechChA? ");
INSERT INTO sanitr_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","tadA sa gaditavAn, madhyenagaramamukapuMsaH samIpaM vrajitvA vadata, guru rgaditavAn, matkAlaH savidhaH, saha shiShyaistvadAlaye nistAramahabhojyaM bhokShye| ");
INSERT INTO sanitr_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","tadA shiShyA yIshostAdR^ishanideshAnurUpakarmma vidhAya tatra nistAramahabhojyamAsAdayAmAsuH| ");
INSERT INTO sanitr_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","tataH sandhyAyAM satyAM dvAdashabhiH shiShyaiH sAkaM sa nyavishat| ");
INSERT INTO sanitr_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","aparaM bhu njAna uktavAn yuShmAn tathyaM vadAmi, yuShmAkameko mAM parakareShu samarpayiShyati| ");
INSERT INTO sanitr_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","tadA te.atIva duHkhitA ekaikasho vaktumArebhire, he prabho, sa kimahaM? ");
INSERT INTO sanitr_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","tataH sa jagAda, mayA sAkaM yo jano bhojanapAtre karaM saMkShipati, sa eva mAM parakareShu samarpayiShyati| ");
INSERT INTO sanitr_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","manujasutamadhi yAdR^ishaM likhitamAste, tadanurUpA tadgati rbhaviShyati; kintu yena puMsA sa parakareShu samarpayiShyate, hA hA chet sa nAjaniShyata, tadA tasya kShemamabhaviShyat| ");
INSERT INTO sanitr_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","tadA yihUdAnAmA yo janastaM parakareShu samarpayiShyati, sa uktavAn, he guro, sa kimahaM? tataH sa pratyuktavAn, tvayA satyaM gaditam| ");
INSERT INTO sanitr_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","anantaraM teShAmashanakAle yIshuH pUpamAdAyeshvarIyaguNAnanUdya bhaMktvA shiShyebhyaH pradAya jagAda, madvapuHsvarUpamimaM gR^ihItvA khAdata| ");
INSERT INTO sanitr_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","pashchAt sa kaMsaM gR^ihlan IshvarIyaguNAnanUdya tebhyaH pradAya kathitavAn, sarvvai ryuShmAbhiranena pAtavyaM, ");
INSERT INTO sanitr_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","yasmAdanekeShAM pApamarShaNAya pAtitaM yanmannUtnaniyamarUpashoNitaM tadetat| ");
INSERT INTO sanitr_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","aparamahaM nUtnagostanIrasaM na pAsyAmi, tAvat gostanIphalarasaM punaH kadApi na pAsyAmi| ");
INSERT INTO sanitr_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","pashchAt te gItamekaM saMgIya jaitunAkhyagiriM gatavantaH| ");
INSERT INTO sanitr_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","tadAnIM yIshustAnavochat, asyAM rajanyAmahaM yuShmAkaM sarvveShAM vighnarUpo bhaviShyAmi, yato likhitamAste, \"meShANAM rakShako yastaM prahariShyAmyahaM tataH| meShANAM nivaho nUnaM pravikIrNo bhaviShyati\"|| ");
INSERT INTO sanitr_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","kintu shmashAnAt samutthAya yuShmAkamagre.ahaM gAlIlaM gamiShyAmi| ");
INSERT INTO sanitr_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","pitarastaM provAcha, bhavAMshchet sarvveShAM vighnarUpo bhavati, tathApi mama na bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","tato yIshunA sa uktaH, tubhyamahaM tathyaM kathayAmi, yAminyAmasyAM charaNAyudhasya ravAt pUrvvaM tvaM mAM tri rnA NgIkariShyasi| ");
INSERT INTO sanitr_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","tataH pitara uditavAn, yadyapi tvayA samaM marttavyaM, tathApi kadApi tvAM na nA NgIkariShyAmi; tathaiva sarvve shiShyAshchochuH| ");
INSERT INTO sanitr_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","anantaraM yIshuH shiShyaiH sAkaM getshimAnInAmakaM sthAnaM prasthAya tebhyaH kathitavAn, adaH sthAnaM gatvA yAvadahaM prArthayiShye tAvad yUyamatropavishata| ");
INSERT INTO sanitr_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","pashchAt sa pitaraM sivadiyasutau cha sa NginaH kR^itvA gatavAn, shokAkulo.atIva vyathitashcha babhUva| ");
INSERT INTO sanitr_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","tAnavAdIchcha mR^itiyAtaneva matprANAnAM yAtanA jAyate, yUyamatra mayA sArddhaM jAgR^ita| ");
INSERT INTO sanitr_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","tataH sa ki nchiddUraM gatvAdhomukhaH patan prArthayA nchakre, he matpitaryadi bhavituM shaknoti, tarhi kaMso.ayaM matto dUraM yAtu; kintu madichChAvat na bhavatu, tvadichChAvad bhavatu| ");
INSERT INTO sanitr_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","tataH sa shiShyAnupetya tAn nidrato nirIkShya pitarAya kathayAmAsa, yUyaM mayA sAkaM daNDamekamapi jAgarituM nAshankuta? ");
INSERT INTO sanitr_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","parIkShAyAM na patituM jAgR^ita prArthayadhva ncha; AtmA samudyatosti, kintu vapu rdurbbalaM| ");
INSERT INTO sanitr_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","sa dvitIyavAraM prArthayA nchakre, he mattAta, na pIte yadi kaMsamidaM matto dUraM yAtuM na shaknoti, tarhi tvadichChAvad bhavatu| ");
INSERT INTO sanitr_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","sa punaretya tAn nidrato dadarsha, yatasteShAM netrANi nidrayA pUrNAnyAsan| ");
INSERT INTO sanitr_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","pashchAt sa tAn vihAya vrajitvA tR^itIyavAraM pUrvvavat kathayan prArthitavAn| ");
INSERT INTO sanitr_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","tataH shiShyAnupAgatya gaditavAn, sAmprataM shayAnAH kiM vishrAmyatha? pashyata, samaya upAsthAt, manujasutaH pApinAM kareShu samarpyate| ");
INSERT INTO sanitr_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","uttiShThata, vayaM yAmaH, yo mAM parakareShu masarpayiShyati, pashyata, sa samIpamAyAti| ");
INSERT INTO sanitr_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","etatkathAkathanakAle dvAdashashiShyANAmeko yihUdAnAmako mukhyayAjakalokaprAchInaiH prahitAn asidhAriyaShTidhAriNo manujAn gR^ihItvA tatsamIpamupatasthau| ");
INSERT INTO sanitr_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","asau parakareShvarpayitA pUrvvaM tAn itthaM sa NketayAmAsa, yamahaM chumbiShye, so.asau manujaH,saeva yuShmAbhi rdhAryyatAM| ");
INSERT INTO sanitr_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","tadA sa sapadi yIshumupAgatya he guro, praNamAmItyuktvA taM chuchumbe| ");
INSERT INTO sanitr_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","tadA yIshustamuvAcha, he mitraM kimarthamAgatosi? tadA tairAgatya yIshurAkramya daghre| ");
INSERT INTO sanitr_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","tato yIshoH sa NginAmekaH karaM prasAryya koShAdasiM bahiShkR^itya mahAyAjakasya dAsamekamAhatya tasya karNaM chichCheda| ");
INSERT INTO sanitr_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","tato yIshustaM jagAda, khaDgaM svasthAneे nidhehi yato ye ye janA asiM dhArayanti, taevAsinA vinashyanti| ");
INSERT INTO sanitr_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","aparaM pitA yathA madantikaM svargIyadUtAnAM dvAdashavAhinIto.adhikaM prahiNuyAt mayA tamuddishyedAnImeva tathA prArthayituM na shakyate, tvayA kimitthaM j nAyate? ");
INSERT INTO sanitr_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","tathA satItthaM ghaTiShyate dharmmapustakasya yadidaM vAkyaM tat kathaM sidhyet? ");
INSERT INTO sanitr_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","tadAnIM yIshu rjananivahaM jagAda, yUyaM khaDgayaShTIn AdAya mAM kiM chauraM dharttumAyAtAH? ahaM pratyahaM yuShmAbhiH sAkamupavishya samupAdishaM, tadA mAM nAdharata; ");
INSERT INTO sanitr_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","kintu bhaviShyadvAdinAM vAkyAnAM saMsiddhaye sarvvametadabhUt|tadA sarvve shiShyAstaM vihAya palAyanta| ");
INSERT INTO sanitr_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","anantaraM te manujA yIshuM dhR^itvA yatrAdhyApakaprA nchaH pariShadaM kurvvanta upAvishan tatra kiyaphAnAाmakamahAyAjakasyAntikaM ninyuH| ");
INSERT INTO sanitr_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","kintu sheShe kiM bhaviShyatIti vettuM pitaro dUre tatpashchAd vrajitvA mahAyAjakasyATTAlikAM pravishya dAsaiH sahita upAvishat| ");
INSERT INTO sanitr_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","tadAnIM pradhAnayAjakaprAchInamantriNaH sarvve yIshuM hantuM mR^iShAsAkShyam alipsanta, ");
INSERT INTO sanitr_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","kintu na lebhire| anekeShu mR^iShAsAkShiShvAgateShvapi tanna prApuH| ");
INSERT INTO sanitr_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","sheShe dvau mR^iShAsAkShiNAvAgatya jagadatuH, pumAnayamakathayat, ahamIshvaramandiraM bhaMktvA dinatrayamadhye tannirmmAtuM shaknomi| ");
INSERT INTO sanitr_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","tadA mahAyAjaka utthAya yIshum avAdIt| tvaM kimapi na prativadasi? tvAmadhi kimete sAkShyaM vadanti? ");
INSERT INTO sanitr_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","kintu yIshu rmaunIbhUya tasyau| tato mahAyAjaka uktavAn, tvAm amareshvaranAmnA shapayAmi, tvamIshvarasya putro.abhiShikto bhavasi naveti vada| ");
INSERT INTO sanitr_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","yIshuH pratyavadat, tvaM satyamuktavAn; ahaM yuShmAn tathyaM vadAmi, itaHparaM manujasutaM sarvvashaktimato dakShiNapArshve sthAtuM gagaNasthaM jaladharAnAruhyAyAntaM vIkShadhve| ");
INSERT INTO sanitr_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","tadA mahAyAjako nijavasanaM ChittvA jagAda, eSha IshvaraM ninditavAn, asmAkamaparasAkShyeNa kiM prayojanaM? pashyata, yUyamevAsyAsyAd IshvaranindAM shrutavantaH, ");
INSERT INTO sanitr_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","yuShmAbhiH kiM vivichyate? te pratyUchuH, vadhArho.ayaM| ");
INSERT INTO sanitr_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","tato lokaistadAsye niShThIvitaM kechit pratalamAhatya kechichcha chapeTamAhatya babhAShire, ");
INSERT INTO sanitr_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","he khrIShTa tvAM kashchapeTamAhatavAn? iti gaNayitvA vadAsmAn| ");
INSERT INTO sanitr_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","pitaro bahira Ngana upavishati, tadAnImekA dAsI tamupAgatya babhAShe, tvaM gAlIlIyayIshoH sahacharaekaH| ");
INSERT INTO sanitr_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","kintu sa sarvveShAM samakSham ana NgIkR^ityAvAdIt, tvayA yaduchyate, tadarthamahaM na vedmi| ");
INSERT INTO sanitr_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","tadA tasmin bahirdvAraM gate .anyA dAsI taM nirIkShya tatratyajanAnavadat, ayamapi nAsaratIyayIshunA sArddham AsIt| ");
INSERT INTO sanitr_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","tataH sa shapathena punarana NgIkR^itya kathitavAn, taM naraM na parichinomi| ");
INSERT INTO sanitr_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","kShaNAt paraM tiShThanto janA etya pitaram avadan, tvamavashyaM teShAmeka iti tvaduchchAraNameva dyotayati| ");
INSERT INTO sanitr_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","kintu so.abhishapya kathitavAn, taM janaM nAhaM parichinomi, tadA sapadi kukkuTo rurAva| ");
INSERT INTO sanitr_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","kukkuTaravAt prAk tvaM mAM trirapAhnoShyase, yaiShA vAg yIshunAvAdi tAM pitaraH saMsmR^itya bahiritvA khedAd bhR^ishaM chakranda| ");
INSERT INTO sanitr_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","prabhAte jAte pradhAnayAjakalokaprAchInA yIshuM hantuM tatpratikUlaM mantrayitvA ");
INSERT INTO sanitr_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","taM badvvA nItvA pantIyapIlAtAkhyAdhipe samarpayAmAsuH| ");
INSERT INTO sanitr_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","tato yIshoH parakarevvarpayitA yihUdAstatprANAdaNDAj nAM viditvA santaptamanAH pradhAnayAjakalokaprAchInAnAM samakShaM tAstrIMshanmudrAH pratidAyAvAdIt, ");
INSERT INTO sanitr_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","etannirAgonaraprANaparakarArpaNAt kaluShaM kR^itavAnahaM| tadA ta uditavantaH, tenAsmAkaM kiM? tvayA tad budhyatAm| ");
INSERT INTO sanitr_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","tato yihUdA mandiramadhye tA mudrA nikShipya prasthitavAn itvA cha svayamAtmAnamudbabandha| ");
INSERT INTO sanitr_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","pashchAt pradhAnayAjakAstA mudrA AdAya kathitavantaH, etA mudrAH shoNitamUlyaM tasmAd bhANDAgAre na nidhAtavyAH| ");
INSERT INTO sanitr_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","anantaraM te mantrayitvA videshinAM shmashAnasthAnAya tAbhiH kulAlasya kShetramakrINan| ");
INSERT INTO sanitr_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ato.adyApi tatsthAnaM raktakShetraM vadanti| ");
INSERT INTO sanitr_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","itthaM sati isrAyelIyasantAnai ryasya mUlyaM nirupitaM, tasya triMshanmudrAmAnaM mUlyaM ");
INSERT INTO sanitr_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","mAM prati parameshvarasyAdeshAt tebhya AdIyata, tena cha kulAlasya kShetraM krItamiti yadvachanaM yirimiyabhaviShyadvAdinA proktaM tat tadAsidhyat| ");
INSERT INTO sanitr_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","anantaraM yIshau tadadhipateH sammukha upatiShThati sa taM paprachCha, tvaM kiM yihUdIyAnAM rAjA? tadA yIshustamavadat, tvaM satyamuktavAn| ");
INSERT INTO sanitr_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","kintu pradhAnayAjakaprAchInairabhiyuktena tena kimapi na pratyavAdi| ");
INSERT INTO sanitr_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","tataH pIlAtena sa uditaH, ime tvatpratikUlataH kati kati sAkShyaM dadati, tat tvaM na shR^iNoShi? ");
INSERT INTO sanitr_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","tathApi sa teShAmekasyApi vachasa uttaraM noditavAn; tena so.adhipati rmahAchitraM vidAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","anyachcha tanmahakAle.adhipateretAdR^ishI rAtirAsIt, prajA yaM ka nchana bandhinaM yAchante, tameva sa mochayatIti| ");
INSERT INTO sanitr_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","tadAnIM barabbAnAmA kashchit khyAtabandhyAsIt| ");
INSERT INTO sanitr_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","tataH pIlAtastatra militAn lokAn apR^ichChat, eSha barabbA bandhI khrIShTavikhyAto yIshushchaitayoH kaM mochayiShyAmi? yuShmAkaM kimIpsitaM? ");
INSERT INTO sanitr_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","tairIrShyayA sa samarpita iti sa j nAtavAn| ");
INSERT INTO sanitr_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","aparaM vichArAsanopaveshanakAle pIlAtasya patnI bhR^ityaM prahitya tasmai kathayAmAsa, taM dhArmmikamanujaM prati tvayA kimapi na karttavyaM; yasmAt tatkR^ite.adyAhaM svapne prabhUtakaShTamalabhe| ");
INSERT INTO sanitr_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","anantaraM pradhAnayAjakaprAchInA barabbAM yAchitvAdAtuM yIshu ncha hantuM sakalalokAn prAvarttayan| ");
INSERT INTO sanitr_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","tato.adhipatistAn pR^iShTavAn, etayoH kamahaM mochayiShyAmi? yuShmAkaM kechChA? te prochu rbarabbAM| ");
INSERT INTO sanitr_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","tadA pIlAtaH paprachCha, tarhi yaM khrIShTaM vadanti, taM yIshuM kiM kariShyAmi? sarvve kathayAmAsuH, sa krushena vidhyatAM| ");
INSERT INTO sanitr_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","tato.adhipatiravAdIt, kutaH? kiM tenAparAddhaM? kintu te punaruchai rjagaduH, sa krushena vidhyatAM| ");
INSERT INTO sanitr_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","tadA nijavAkyamagrAhyamabhUt, kalahashchApyabhUt, pIlAta iti vilokya lokAnAM samakShaM toyamAdAya karau prakShAlyAvochat, etasya dhArmmikamanuShyasya shoNitapAte nirdoSho.ahaM, yuShmAbhireva tad budhyatAM| ");
INSERT INTO sanitr_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","tadA sarvvAH prajAH pratyavochan, tasya shoNitapAtAparAdho.asmAkam asmatsantAnAnA nchopari bhavatu| ");
INSERT INTO sanitr_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","tataH sa teShAM samIpe barabbAM mochayAmAsa yIshuntu kaShAbhirAhatya krushena vedhituM samarpayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","anantaram adhipateH senA adhipate rgR^ihaM yIshumAnIya tasya samIpe senAsamUhaM saMjagR^ihuH| ");
INSERT INTO sanitr_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","tataste tasya vasanaM mochayitvA kR^iShNalohitavarNavasanaM paridhApayAmAsuH ");
INSERT INTO sanitr_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","kaNTakAnAM mukuTaM nirmmAya tachChirasi daduH, tasya dakShiNakare vetramekaM dattvA tasya sammukhe jAnUni pAtayitvA, he yihUdIyAnAM rAjan, tubhyaM nama ityuktvA taM tirashchakruH, ");
INSERT INTO sanitr_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","tatastasya gAtre niShThIvaM datvA tena vetreNa shira AjaghnuH| ");
INSERT INTO sanitr_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","itthaM taM tiraskR^itya tad vasanaM mochayitvA punarnijavasanaM paridhApayA nchakruH, taM krushena vedhituM nItavantaH| ");
INSERT INTO sanitr_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","pashchAtte bahirbhUya kurINIyaM shimonnAmakamekaM vilokya krushaM voDhuM tamAdadire| ");
INSERT INTO sanitr_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","anantaraM gulgaltAm arthAt shiraskapAlanAmakasthAnamu pasthAya te yIshave pittamishritAmlarasaM pAtuM daduH, ");
INSERT INTO sanitr_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","kintu sa tamAsvAdya na papau| ");
INSERT INTO sanitr_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","tadAnIM te taM krushena saMvidhya tasya vasanAni guTikApAtena vibhajya jagR^ihuH, tasmAt, vibhajante.adharIyaM me te manuShyAH parasparaM| maduttarIyavastrArthaM guTikAM pAtayanti cha||yadetadvachanaM bhaviShyadvAdibhiruktamAsIt, tadA tad asidhyat, ");
INSERT INTO sanitr_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","pashchAt te tatropavishya tadrakShaNakarvvaNi niyuktAstasthuH| ");
INSERT INTO sanitr_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","aparam eSha yihUdIyAnAM rAjA yIshurityapavAdalipipatraM tachChirasa Urdvve yojayAmAsuH| ");
INSERT INTO sanitr_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","tatastasya vAme dakShiNe cha dvau chairau tena sAkaM krushena vividhuH| ");
INSERT INTO sanitr_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","tadA pAnthA nijashiro lADayitvA taM nindanto jagaduH, ");
INSERT INTO sanitr_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","he Ishvaramandirabha njaka dinatraye tannirmmAtaH svaM rakSha, chettvamIshvarasutastarhi krushAdavaroha| ");
INSERT INTO sanitr_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","pradhAnayAjakAdhyApakaprAchInAshcha tathA tiraskR^itya jagaduH, ");
INSERT INTO sanitr_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","so.anyajanAnAvat, kintu svamavituM na shaknoti| yadIsrAyelo rAjA bhavet, tarhIdAnImeva krushAdavarohatu, tena taM vayaM pratyeShyAmaH| ");
INSERT INTO sanitr_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","sa Ishvare pratyAshAmakarot, yadIshvarastasmin santuShTastarhIdAnImeva tamavet, yataH sa uktavAn ahamIshvarasutaH| ");
INSERT INTO sanitr_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","yau stenau sAkaM tena krushena viddhau tau tadvadeva taM ninindatuH| ");
INSERT INTO sanitr_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","tadA dvitIyayAmAt tR^itIyayAmaM yAvat sarvvadeshe tamiraM babhUva, ");
INSERT INTO sanitr_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","tR^itIyayAme \"elI elI lAmA shivaktanI\", arthAt madIshvara madIshvara kuto mAmatyAkShIH? yIshuruchchairiti jagAda| ");
INSERT INTO sanitr_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","tadA tatra sthitAH kechit tat shrutvA babhAShire, ayam eliyamAhUyati| ");
INSERT INTO sanitr_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","teShAM madhyAd ekaH shIghraM gatvA spa njaM gR^ihItvA tatrAmlarasaM dattvA nalena pAtuM tasmai dadau| ");
INSERT INTO sanitr_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","itare.akathayan tiShThata, taM rakShitum eliya AyAti naveti pashyAmaH| ");
INSERT INTO sanitr_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","yIshuH punaruchairAhUya prANAn jahau| ");
INSERT INTO sanitr_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","tato mandirasya vichChedavasanam UrdvvAdadho yAvat ChidyamAnaM dvidhAbhavat, ");
INSERT INTO sanitr_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","bhUmishchakampe bhUdharovyadIryyata cha| shmashAne mukte bhUripuNyavatAM suptadehA udatiShThan, ");
INSERT INTO sanitr_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","shmashAnAd vahirbhUya tadutthAnAt paraM puNyapuraM gatvA bahujanAn darshayAmAsuH| ");
INSERT INTO sanitr_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","yIshurakShaNAya niyuktaH shatasenApatistatsa Nginashcha tAdR^ishIM bhUkampAdighaTanAM dR^iShTvA bhItA avadan, eSha Ishvaraputro bhavati| ");
INSERT INTO sanitr_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","yA bahuyoShito yIshuM sevamAnA gAlIlastatpashchAdAgatAstAsAM madhye ");
INSERT INTO sanitr_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","magdalInI mariyam yAkUbyoshyo rmAtA yA mariyam sibadiyaputrayo rmAtA cha yoShita etA dUre tiShThantyo dadR^ishuH| ");
INSERT INTO sanitr_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","sandhyAyAM satyam arimathiyAnagarasya yUShaphnAmA dhanI manujo yIshoH shiShyatvAt ");
INSERT INTO sanitr_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","pIlAtasya samIpaM gatvA yIshoH kAyaM yayAche, tena pIlAtaH kAyaM dAtum Adidesha| ");
INSERT INTO sanitr_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","yUShaph tatkAyaM nItvA shuchivastreNAchChAdya ");
INSERT INTO sanitr_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","svArthaM shaile yat shmashAnaM chakhAna, tanmadhye tatkAyaM nidhAya tasya dvAri vR^ihatpAShANaM dadau| ");
INSERT INTO sanitr_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","kintu magdalInI mariyam anyamariyam ete striyau tatra shmashAnasammukha upavivishatuH| ");
INSERT INTO sanitr_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","tadanantaraM nistArotsavasyAyojanadinAt pare.ahani pradhAnayAjakAH phirUshinashcha militvA pIlAtamupAgatyAkathayan, ");
INSERT INTO sanitr_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","he mahechCha sa pratArako jIvana akathayat, dinatrayAt paraM shmashAnAdutthAsyAmi tadvAkyaM smarAmo vayaM; ");
INSERT INTO sanitr_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","tasmAt tR^itIyadinaM yAvat tat shmashAnaM rakShitumAdishatu, nochet tachChiShyA yAminyAmAgatya taM hR^itvA lokAn vadiShyanti, sa shmashAnAdudatiShThat, tathA sati prathamabhrAnteH sheShIyabhrAnti rmahatI bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","tadA pIlAta avAdIt, yuShmAkaM samIpe rakShigaNa Aste, yUyaM gatvA yathA sAdhyaM rakShayata| ");
INSERT INTO sanitr_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","tataste gatvA taddUाrapAShANaM mudrA NkitaM kR^itvA rakShigaNaM niyojya shmashAnaM rakShayAmAsuH| ");
INSERT INTO sanitr_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","tataH paraM vishrAmavArasya sheShe saptAhaprathamadinasya prabhote jAte magdalInI mariyam anyamariyam cha shmashAnaM draShTumAgatA| ");
INSERT INTO sanitr_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","tadA mahAn bhUkampo.abhavat; parameshvarIyadUtaH svargAdavaruhya shmashAnadvArAt pAShANamapasAryya taduparyyupavivesha| ");
INSERT INTO sanitr_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","tadvadanaM vidyudvat tejomayaM vasanaM himashubhra ncha| ");
INSERT INTO sanitr_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","tadAnIM rakShiNastadbhayAt kampitA mR^itavad babhUvaH| ");
INSERT INTO sanitr_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","sa dUto yoShito jagAda, yUyaM mA bhaiShTa, krushahatayIshuM mR^igayadhve tadahaM vedmi| ");
INSERT INTO sanitr_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","so.atra nAsti, yathAvadat tathotthitavAn; etat prabhoH shayanasthAnaM pashyata| ");
INSERT INTO sanitr_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","tUrNaM gatvA tachChiShyAn iti vadata, sa shmashAnAd udatiShThat, yuShmAkamagre gAlIlaM yAsyati yUyaM tatra taM vIkShiShyadhve, pashyatAhaM vArttAmimAM yuShmAnavAdiShaM| ");
INSERT INTO sanitr_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","tatastA bhayAt mahAnandA ncha shmashAnAt tUrNaM bahirbhUya tachChiShyAn vArttAM vaktuM dhAvitavatyaH| kintu shiShyAn vArttAM vaktuM yAnti, tadA yIshu rdarshanaM dattvA tA jagAda, ");
INSERT INTO sanitr_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","yuShmAkaM kalyANaM bhUyAt, tatastA Agatya tatpAdayoH patitvA praNemuH| ");
INSERT INTO sanitr_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","yIshustA avAdIt, mA bibhIta, yUyaM gatvA mama bhrAtR^in gAlIlaM yAtuM vadata, tatra te mAM drakShyanti| ");
INSERT INTO sanitr_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","striyo gachChanti, tadA rakShiNAM kechit puraM gatvA yadyad ghaTitaM tatsarvvaM pradhAnayAjakAn j nApitavantaH| ");
INSERT INTO sanitr_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","te prAchInaiH samaM saMsadaM kR^itvA mantrayanto bahumudrAH senAbhyo dattvAvadan, ");
INSERT INTO sanitr_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","asmAsu nidriteShu tachChiShyA yAminyAmAgatya taM hR^itvAnayan, iti yUyaM prachArayata| ");
INSERT INTO sanitr_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","yadyetadadhipateH shrotragocharIbhavet, tarhi taM bodhayitvA yuShmAnaviShyAmaH| ");
INSERT INTO sanitr_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","tataste mudrA gR^ihItvA shikShAnurUpaM karmma chakruH, yihUdIyAnAM madhye tasyAdyApi kiMvadantI vidyate| ");
INSERT INTO sanitr_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ekAdasha shiShyA yIshunirUpitAgAlIlasyAdriM gatvA ");
INSERT INTO sanitr_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","tatra taM saMvIkShya praNemuH, kintu kechit sandigdhavantaH| ");
INSERT INTO sanitr_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","yIshusteShAM samIpamAgatya vyAhR^itavAn, svargamedinyoH sarvvAdhipatitvabhAro mayyarpita Aste| ");
INSERT INTO sanitr_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ato yUyaM prayAya sarvvadeshIyAn shiShyAn kR^itvA pituH putrasya pavitrasyAtmanashcha nAmnA tAnavagAhayata; ahaM yuShmAn yadyadAdishaM tadapi pAlayituM tAnupAdishata| ");
INSERT INTO sanitr_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","pashyata, jagadantaM yAvat sadAhaM yuShmAbhiH sAkaM tiShThAmi| iti|");
INSERT INTO sanitr_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ishvaraputrasya yIshukhrIShTasya susaMvAdArambhaH| ");
INSERT INTO sanitr_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","bhaviShyadvAdinAM grantheShu lipiritthamAste, pashya svakIyadUtantu tavAgre preShayAmyaham| gatvA tvadIyapanthAnaM sa hi pariShkariShyati| ");
INSERT INTO sanitr_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","\"parameshasya panthAnaM pariShkuruta sarvvataH| tasya rAjapatha nchaiva samAnaM kurutAdhunA|\" ityetat prAntare vAkyaM vadataH kasyachidravaH|| ");
INSERT INTO sanitr_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","saeva yohan prAntare majjitavAn tathA pApamArjananimittaM manovyAvarttakamajjanasya kathA ncha prachAritavAn| ");
INSERT INTO sanitr_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","tato yihUdAdeshayirUshAlamnagaranivAsinaH sarvve lokA bahi rbhUtvA tasya samIpamAgatya svAni svAni pApAnya NgIkR^itya yarddananadyAM tena majjitA babhUvuH| ");
INSERT INTO sanitr_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","asya yohanaH paridheyAni kramelakalomajAni, tasya kaTibandhanaM charmmajAtam, tasya bhakShyANi cha shUkakITA vanyamadhUni chAsan| ");
INSERT INTO sanitr_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","sa prachArayan kathayA nchakre, ahaM namrIbhUya yasya pAdukAbandhanaM mochayitumapi na yogyosmi, tAdR^isho matto gurutara ekaH puruSho matpashchAdAgachChati| ");
INSERT INTO sanitr_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ahaM yuShmAn jale majjitavAn kintu sa pavitra AtmAni saMmajjayiShyati| ");
INSERT INTO sanitr_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","apara ncha tasminneva kAle gAlIlpradeshasya nAsaradgrAmAd yIshurAgatya yohanA yarddananadyAM majjito.abhUt| ");
INSERT INTO sanitr_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","sa jalAdutthitamAtro meghadvAraM muktaM kapotavat svasyopari avarohantamAtmAna ncha dR^iShTavAn| ");
INSERT INTO sanitr_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","tvaM mama priyaH putrastvayyeva mamamahAsantoSha iyamAkAshIyA vANI babhUva| ");
INSERT INTO sanitr_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","tasmin kAle AtmA taM prAntaramadhyaM ninAya| ");
INSERT INTO sanitr_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","atha sa chatvAriMshaddinAni tasmin sthAne vanyapashubhiH saha tiShThan shaitAnA parIkShitaH; pashchAt svargIyadUtAstaM siShevire| ");
INSERT INTO sanitr_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","anantaraM yohani bandhanAlaye baddhe sati yIshu rgAlIlpradeshamAgatya IshvararAjyasya susaMvAdaM prachArayan kathayAmAsa, ");
INSERT INTO sanitr_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","kAlaH sampUrNa IshvararAjya ncha samIpamAgataM; atoheto ryUyaM manAMsi vyAvarttayadhvaM susaMvAde cha vishvAsita| ");
INSERT INTO sanitr_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","tadanantaraM sa gAlIlIyasamudrasya tIre gachChan shimon tasya bhrAtA andriyanAmA cha imau dvau janau matsyadhAriNau sAgaramadhye jAlaM prakShipantau dR^iShTvA tAvavadat, ");
INSERT INTO sanitr_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","yuvAM mama pashchAdAgachChataM, yuvAmahaM manuShyadhAriNau kariShyAmi| ");
INSERT INTO sanitr_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","tatastau tatkShaNameva jAlAni parityajya tasya pashchAt jagmatuH| ");
INSERT INTO sanitr_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","tataH paraM tatsthAnAt ki nchid dUraM gatvA sa sivadIputrayAkUb tadbhrAtR^iyohan cha imau naukAyAM jAlAnAM jIrNamuddhArayantau dR^iShTvA tAvAhUyat| ");
INSERT INTO sanitr_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","tatastau naukAyAM vetanabhugbhiH sahitaM svapitaraM vihAya tatpashchAdIyatuH| ");
INSERT INTO sanitr_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","tataH paraM kapharnAhUmnAmakaM nagaramupasthAya sa vishrAmadivase bhajanagrahaM pravishya samupadidesha| ");
INSERT INTO sanitr_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","tasyopadeshAllokA AshcharyyaM menire yataH sodhyApakAiva nopadishan prabhAvavAniva propadidesha| ");
INSERT INTO sanitr_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","apara ncha tasmin bhajanagR^ihe apavitrabhUtena grasta eko mAnuSha AsIt| sa chItshabdaM kR^itvA kathayA nchake ");
INSERT INTO sanitr_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","bho nAsaratIya yIsho tvamasmAn tyaja, tvayA sahAsmAkaM kaH sambandhaH? tvaM kimasmAn nAshayituM samAgataH? tvamIshvarasya pavitraloka ityahaM jAnAmi| ");
INSERT INTO sanitr_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","tadA yIshustaM tarjayitvA jagAda tUShNIM bhava ito bahirbhava cha| ");
INSERT INTO sanitr_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","tataH so.apavitrabhUtastaM sampIDya atyuchaishchItkR^itya nirjagAma| ");
INSERT INTO sanitr_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","tenaiva sarvve chamatkR^itya parasparaM kathayA nchakrire, aho kimidaM? kIdR^isho.ayaM navya upadeshaH? anena prabhAvenApavitrabhUteShvAj nApiteShu te tadAj nAnuvarttino bhavanti| ");
INSERT INTO sanitr_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","tadA tasya yasho gAlIlashchaturdiksthasarvvadeshAn vyApnot| ");
INSERT INTO sanitr_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","apara ncha te bhajanagR^ihAd bahi rbhUtvA yAkUbyohanbhyAM saha shimona Andriyasya cha niveshanaM pravivishuH| ");
INSERT INTO sanitr_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","tadA pitarasya shvashrUrjvarapIDitA shayyAyAmAsta iti te taM jhaTiti vij nApayA nchakruH| ");
INSERT INTO sanitr_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","tataH sa Agatya tasyA hastaM dhR^itvA tAmudasthApayat; tadaiva tAM jvaro.atyAkShIt tataH paraM sA tAn siSheve| ");
INSERT INTO sanitr_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","athAstaM gate ravau sandhyAkAle sati lokAstatsamIpaM sarvvAn rogiNo bhUtadhR^itAMshcha samAninyuH| ");
INSERT INTO sanitr_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","sarvve nAgarikA lokA dvAri saMmilitAshcha| ");
INSERT INTO sanitr_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","tataH sa nAnAvidharogiNo bahUn manujAnarogiNashchakAra tathA bahUn bhUtAn tyAjayA nchakAra tAn bhUtAn kimapi vAkyaM vaktuM niShiShedha cha yatohetoste tamajAnan| ");
INSERT INTO sanitr_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","apara ncha so.atipratyUShe vastutastu rAtrisheShe samutthAya bahirbhUya nirjanaM sthAnaM gatvA tatra prArthayA nchakre| ");
INSERT INTO sanitr_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","anantaraM shimon tatsa Nginashcha tasya pashchAd gatavantaH| ");
INSERT INTO sanitr_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","taduddeshaM prApya tamavadan sarvve lokAstvAM mR^igayante| ");
INSERT INTO sanitr_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","tadA so.akathayat AgachChata vayaM samIpasthAni nagarANi yAmaH, yato.ahaM tatra kathAM prachArayituM bahirAgamam| ");
INSERT INTO sanitr_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","atha sa teShAM gAlIlpradeshasya sarvveShu bhajanagR^iheShu kathAH prachArayA nchakre bhUtAnatyAjaya ncha| ");
INSERT INTO sanitr_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","anantaramekaH kuShThI samAgatya tatsammukhe jAnupAtaM vinaya ncha kR^itvA kathitavAn yadi bhavAn ichChati tarhi mAM pariShkarttuM shaknoti| ");
INSERT INTO sanitr_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","tataH kR^ipAlu ryIshuH karau prasAryya taM spaShTvA kathayAmAsa ");
INSERT INTO sanitr_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","mamechChA vidyate tvaM pariShkR^ito bhava| etatkathAyAH kathanamAtrAt sa kuShThI rogAnmuktaH pariShkR^ito.abhavat| ");
INSERT INTO sanitr_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","tadA sa taM visR^ijan gADhamAdishya jagAda ");
INSERT INTO sanitr_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","sAvadhAno bhava kathAmimAM kamapi mA vada; svAtmAnaM yAjakaM darshaya, lokebhyaH svapariShkR^iteH pramANadAnAya mUsAnirNItaM yaddAnaM tadutsR^ijasva cha| ");
INSERT INTO sanitr_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","kintu sa gatvA tat karmma itthaM vistAryya prachArayituM prArebhe tenaiva yIshuH punaH saprakAshaM nagaraM praveShTuM nAshaknot tatohetorbahiH kAnanasthAne tasyau; tathApi chaturddigbhyo lokAstasya samIpamAyayuH| ");
INSERT INTO sanitr_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","tadanantaraM yIshai katipayadinAni vilambya punaH kapharnAhUmnagaraM praviShTe sa gR^iha Asta iti kiMvadantyA tatkShaNaM tatsamIpaM bahavo lokA Agatya samupatasthuH, ");
INSERT INTO sanitr_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","tasmAd gR^ihamadhye sarvveShAM kR^ite sthAnaM nAbhavad dvArasya chaturdikShvapi nAbhavat, tatkAle sa tAn prati kathAM prachArayA nchakre| ");
INSERT INTO sanitr_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","tataH paraM lokAshchaturbhi rmAnavairekaM pakShAghAtinaM vAhayitvA tatsamIpam AninyuH| ");
INSERT INTO sanitr_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","kintu janAnAM bahutvAt taM yIshoH sammukhamAnetuM na shaknuvanto yasmin sthAne sa Aste taduparigR^ihapR^iShThaM khanitvA ChidraM kR^itvA tena mArgeNa sashayyaM pakShAghAtinam avarohayAmAsuH| ");
INSERT INTO sanitr_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","tato yIshusteShAM vishvAsaM dR^iShTvA taM pakShAghAtinaM babhAShe he vatsa tava pApAnAM mArjanaM bhavatu| ");
INSERT INTO sanitr_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","tadA kiyanto.adhyApakAstatropavishanto manobhi rvitarkayA nchakruH, eSha manuShya etAdR^ishImIshvaranindAM kathAM kutaH kathayati? ");
INSERT INTO sanitr_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","IshvaraM vinA pApAni mArShTuM kasya sAmarthyam Aste? ");
INSERT INTO sanitr_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","itthaM te vitarkayanti yIshustatkShaNaM manasA tad budvvA tAnavadad yUyamantaHkaraNaiH kuta etAni vitarkayatha? ");
INSERT INTO sanitr_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","tadanantaraM yIshustatsthAnAt punaH samudrataTaM yayau; lokanivahe tatsamIpamAgate sa tAn samupadidesha| ");
INSERT INTO sanitr_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","kintu pR^ithivyAM pApAni mArShTuM manuShyaputrasya sAmarthyamasti, etad yuShmAn j nApayituM (sa tasmai pakShAghAtine kathayAmAsa) ");
INSERT INTO sanitr_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","uttiShTha tava shayyAM gR^ihItvA svagR^ihaM yAhi, ahaM tvAmidam Aj nApayAmi| ");
INSERT INTO sanitr_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","tataH sa tatkShaNam utthAya shayyAM gR^ihItvA sarvveShAM sAkShAt jagAma; sarvve vismitA etAdR^ishaM karmma vayam kadApi nApashyAma, imAM kathAM kathayitveshvaraM dhanyamabruvan| ");
INSERT INTO sanitr_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","tadanantaraM yIshustatsthAnAt punaH samudrataTaM yayau; lokanivahe tatsamIpamAgate sa tAn samupadidesha| ");
INSERT INTO sanitr_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","atha gachChan karasa nchayagR^iha upaviShTam AlphIyaputraM leviM dR^iShTvA tamAhUya kathitavAn matpashchAt tvAmAmachCha tataH sa utthAya tatpashchAd yayau| ");
INSERT INTO sanitr_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","anantaraM yIshau tasya gR^ihe bhoktum upaviShTe bahavaH karama nchAyinaH pApinashcha tena tachChiShyaishcha sahopavivishuH, yato bahavastatpashchAdAjagmuH| ");
INSERT INTO sanitr_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","tadA sa karama nchAyibhiH pApibhishcha saha khAdati, tad dR^iShTvAdhyApakAH phirUshinashcha tasya shiShyAnUchuH karama nchAyibhiH pApibhishcha sahAyaM kuto bhuMkte pivati cha? ");
INSERT INTO sanitr_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","tadvAkyaM shrutvA yIshuH pratyuvAcha,arogilokAnAM chikitsakena prayojanaM nAsti, kintu rogiNAmeva; ahaM dhArmmikAnAhvAtuM nAgataH kintu mano vyAvarttayituM pApina eva| ");
INSERT INTO sanitr_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","tataH paraM yohanaH phirUshinA nchopavAsAchArishiShyA yIshoH samIpam Agatya kathayAmAsuH, yohanaH phirUshinA ncha shiShyA upavasanti kintu bhavataH shiShyA nopavasanti kiM kAraNamasya? ");
INSERT INTO sanitr_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","tadA yIshustAn babhAShe yAvat kAlaM sakhibhiH saha kanyAyA varastiShThati tAvatkAlaM te kimupavastuM shaknuvanti? yAvatkAlaM varastaiH saha tiShThati tAvatkAlaM ta upavastuM na shaknuvanti| ");
INSERT INTO sanitr_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","yasmin kAle tebhyaH sakAshAd varo neShyate sa kAla AgachChati, tasmin kAle te janA upavatsyanti| ");
INSERT INTO sanitr_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","kopi janaH purAtanavastre nUtanavastraM na sIvyati, yato nUtanavastreNa saha sevane kR^ite jIrNaM vastraM Chidyate tasmAt puna rmahat ChidraM jAyate| ");
INSERT INTO sanitr_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","kopi janaH purAtanakutUShu nUtanaM drAkShArasaM na sthApayati, yato nUtanadrAkShArasasya tejasA tAH kutvo vidIryyante tato drAkShArasashcha patati kutvashcha nashyanti, ataeva nUtanadrAkShAraso nUtanakutUShu sthApanIyaH| ");
INSERT INTO sanitr_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","tadanantaraM yIshu ryadA vishrAmavAre shasyakShetreNa gachChati tadA tasya shiShyA gachChantaH shasyama njarIshChettuM pravR^ittAH| ");
INSERT INTO sanitr_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ataH phirUshino yIshave kathayAmAsuH pashyatu vishrAmavAsare yat karmma na karttavyaM tad ime kutaH kurvvanti? ");
INSERT INTO sanitr_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","tadA sa tebhyo.akathayat dAyUd tatsaM Nginashcha bhakShyAbhAvAt kShudhitAH santo yat karmma kR^itavantastat kiM yuShmAbhi rna paThitam? ");
INSERT INTO sanitr_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","abiyAtharnAmake mahAyAjakatAM kurvvati sa kathamIshvarasyAvAsaM pravishya ye darshanIyapUpA yAjakAn vinAnyasya kasyApi na bhakShyAstAneva bubhuje sa Ngilokebhyo.api dadau| ");
INSERT INTO sanitr_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","so.aparamapi jagAda, vishrAmavAro manuShyArthameva nirUpito.asti kintu manuShyo vishrAmavArArthaM naiva| ");
INSERT INTO sanitr_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","manuShyaputro vishrAmavArasyApi prabhurAste| ");
INSERT INTO sanitr_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","anantaraM yIshuH puna rbhajanagR^ihaM praviShTastasmin sthAne shuShkahasta eko mAnava AsIt| ");
INSERT INTO sanitr_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","sa vishrAmavAre tamarogiNaM kariShyati navetyatra bahavastam apavadituM ChidramapekShitavantaH| ");
INSERT INTO sanitr_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","tadA sa taM shuShkahastaM manuShyaM jagAda madhyasthAne tvamuttiShTha| ");
INSERT INTO sanitr_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","tataH paraM sa tAn paprachCha vishrAmavAre hitamahitaM tathA hi prANarakShA vA prANanAsha eShAM madhye kiM karaNIyaM ? kintu te niHshabdAstasthuH| ");
INSERT INTO sanitr_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","tadA sa teShAmantaHkaraNAnAM kAThinyAddheto rduHkhitaH krodhAt chartuिdasho dR^iShTavAn taM mAnuShaM gaditavAn taM hastaM vistAraya, tatastena haste vistR^ite taddhasto.anyahastavad arogo jAtaH| ");
INSERT INTO sanitr_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","atha phirUshinaH prasthAya taM nAshayituM herodIyaiH saha mantrayitumArebhire| ");
INSERT INTO sanitr_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ataeva yIshustatsthAnaM parityajya shiShyaiH saha punaH sAgarasamIpaM gataH; ");
INSERT INTO sanitr_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","tato gAlIlyihUdA-yirUshAlam-idom-yardannadIpArasthAnebhyo lokasamUhastasya pashchAd gataH; tadanyaH sorasIdanoH samIpavAsilokasamUhashcha tasya mahAkarmmaNAM vArttaM shrutvA tasya sannidhimAgataH| ");
INSERT INTO sanitr_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","tadA lokasamUhashchet tasyopari patati ityAsha Nkya sa nAvamekAM nikaTe sthApayituM shiShyAnAdiShTavAn| ");
INSERT INTO sanitr_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","yato.anekamanuShyANAmArogyakaraNAd vyAdhigrastAH sarvve taM spraShTuM parasparaM balena yatnavantaH| ");
INSERT INTO sanitr_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","apara ncha apavitrabhUtAstaM dR^iShTvA tachcharaNayoH patitvA prochaiH prochuH, tvamIshvarasya putraH| ");
INSERT INTO sanitr_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","kintu sa tAn dR^iDham Aj nApya svaM parichAyituM niShiddhavAn| ");
INSERT INTO sanitr_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","anantaraM sa parvvatamAruhya yaM yaM pratichChA taM tamAhUtavAn tataste tatsamIpamAgatAH| ");
INSERT INTO sanitr_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","tadA sa dvAdashajanAn svena saha sthAtuM susaMvAdaprachArAya preritA bhavituM ");
INSERT INTO sanitr_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","sarvvaprakAravyAdhInAM shamanakaraNAya prabhAvaM prAptuM bhUtAn tyAjayitu ncha niyuktavAn| ");
INSERT INTO sanitr_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","teShAM nAmAnImAni, shimon sivadiputro ");
INSERT INTO sanitr_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","yAkUb tasya bhrAtA yohan cha AndriyaH philipo barthalamayaH, ");
INSERT INTO sanitr_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","mathI thomA cha AlphIyaputro yAkUb thaddIyaH kinAnIyaH shimon yastaM parahasteShvarpayiShyati sa IShkariyotIyayihUdAshcha| ");
INSERT INTO sanitr_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","sa shimone pitara ityupanAma dadau yAkUbyohanbhyAM cha binerigish arthato meghanAdaputrAvityupanAma dadau| ");
INSERT INTO sanitr_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","anantaraM te niveshanaM gatAH, kintu tatrApi punarmahAn janasamAgamo .abhavat tasmAtte bhoktumapyavakAshaM na prAptAH| ");
INSERT INTO sanitr_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","tatastasya suhR^illokA imAM vArttAM prApya sa hataj nAnobhUd iti kathAM kathayitvA taM dhR^itvAnetuM gatAH| ");
INSERT INTO sanitr_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","apara ncha yirUshAlama AgatA ye ye.adhyApakAste jagadurayaM puruSho bhUtapatyAbiShTastena bhUtapatinA bhUtAn tyAjayati| ");
INSERT INTO sanitr_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","tatastAnAhUya yIshu rdR^iShTAntaiH kathAM kathitavAn shaitAn kathaM shaitAnaM tyAjayituM shaknoti? ");
INSERT INTO sanitr_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","ki nchana rAjyaM yadi svavirodhena pR^ithag bhavati tarhi tad rAjyaM sthiraM sthAtuM na shaknoti| ");
INSERT INTO sanitr_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","tathA kasyApi parivAro yadi parasparaM virodhI bhavati tarhi sopi parivAraH sthiraM sthAtuM na shaknoti| ");
INSERT INTO sanitr_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","tadvat shaitAn yadi svavipakShatayA uttiShThan bhinno bhavati tarhi sopi sthiraM sthAtuM na shaknoti kintUchChinno bhavati| ");
INSERT INTO sanitr_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","apara ncha prabalaM janaM prathamaM na baddhA kopi tasya gR^ihaM pravishya dravyANi luNThayituM na shaknoti, taM badvvaiva tasya gR^ihasya dravyANi luNThayituM shaknoti| ");
INSERT INTO sanitr_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","atoheto ryuShmabhyamahaM satyaM kathayAmi manuShyANAM santAnA yAni yAni pApAnIshvaranindA ncha kurvvanti teShAM tatsarvveShAmaparAdhAnAM kShamA bhavituM shaknoti, ");
INSERT INTO sanitr_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","kintu yaH kashchit pavitramAtmAnaM nindati tasyAparAdhasya kShamA kadApi na bhaviShyati sonantadaNDasyArho bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","tasyApavitrabhUto.asti teShAmetatkathAhetoH sa itthaM kathitavAn| ");
INSERT INTO sanitr_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","atha tasya mAtA bhrAtR^igaNashchAgatya bahistiShThanato lokAn preShya tamAhUtavantaH| ");
INSERT INTO sanitr_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","tatastatsannidhau samupaviShTA lokAstaM babhAShire pashya bahistava mAtA bhrAtarashcha tvAm anvichChanti| ");
INSERT INTO sanitr_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","tadA sa tAn pratyuvAcha mama mAtA kA bhrAtaro vA ke? tataH paraM sa svamIpopaviShTAn shiShyAn prati avalokanaM kR^itvA kathayAmAsa ");
INSERT INTO sanitr_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","pashyataite mama mAtA bhrAtarashcha| ");
INSERT INTO sanitr_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","yaH kashchid IshvarasyeShTAM kriyAM karoti sa eva mama bhrAtA bhaginI mAtA cha| ");
INSERT INTO sanitr_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","anantaraM sa samudrataTe punarupadeShTuM prArebhe, tatastatra bahujanAnAM samAgamAt sa sAgaropari naukAmAruhya samupaviShTaH; sarvve lokAH samudrakUle tasthuH| ");
INSERT INTO sanitr_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","tadA sa dR^iShTAntakathAbhi rbahUpadiShTavAn upadishaMshcha kathitavAn, ");
INSERT INTO sanitr_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","avadhAnaM kuruta, eko bIjavaptA bIjAni vaptuM gataH; ");
INSERT INTO sanitr_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","vapanakAle kiyanti bIjAni mArgapAshve patitAni, tata AkAshIyapakShiNa etya tAni chakhAduH| ");
INSERT INTO sanitr_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","kiyanti bIjAni svalpamR^ittikAvatpAShANabhUmau patitAni tAni mR^idolpatvAt shIghrama NkuritAni; ");
INSERT INTO sanitr_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","kintUdite sUryye dagdhAni tathA mUlAno nAdhogatatvAt shuShkANi cha| ");
INSERT INTO sanitr_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","kiyanti bIjAni kaNTakivanamadhye patitAni tataH kaNTakAni saMvR^idvya tAni jagrasustAni na cha phalitAni| ");
INSERT INTO sanitr_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","tathA kiyanti bIjAnyuttamabhUmau patitAni tAni saMvR^idvya phalAnyutpAditAni kiyanti bIjAni triMshadguNAni kiyanti ShaShTiguNAni kiyanti shataguNAni phalAni phalitavanti| ");
INSERT INTO sanitr_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","atha sa tAnavadat yasya shrotuM karNau staH sa shR^iNotu| ");
INSERT INTO sanitr_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","tadanantaraM nirjanasamaye tatsa Ngino dvAdashashiShyAshcha taM taddR^iShTAntavAkyasyArthaM paprachChuH| ");
INSERT INTO sanitr_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","tadA sa tAnuditavAn IshvararAjyasya nigUDhavAkyaM boddhuM yuShmAkamadhikAro.asti; ");
INSERT INTO sanitr_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","kintu ye vahirbhUtAH \"te pashyantaH pashyanti kintu na jAnanti, shR^iNvantaH shR^iNvanti kintu na budhyante, chettai rmanaHsu kadApi parivarttiteShu teShAM pApAnyamochayiShyanta,\" atohetostAn prati dR^iShTAntaireva tAni mayA kathitAni| ");
INSERT INTO sanitr_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","atha sa kathitavAn yUyaM kimetad dR^iShTAntavAkyaM na budhyadhve? tarhi kathaM sarvvAn dR^iShTAntAna bhotsyadhve? ");
INSERT INTO sanitr_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","bIjavaptA vAkyarUpANi bIjAni vapati; ");
INSERT INTO sanitr_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","tatra ye ye lokA vAkyaM shR^iNvanti, kintu shrutamAtrAt shaitAn shIghramAgatya teShAM manaHsUptAni tAni vAkyarUpANi bIjAnyapanayati taeva uptabIjamArgapArshvesvarUpAH| ");
INSERT INTO sanitr_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ye janA vAkyaM shrutvA sahasA paramAnandena gR^ihlanti, kintu hR^idi sthairyyAbhAvAt ki nchit kAlamAtraM tiShThanti tatpashchAt tadvAkyahetoH ");
INSERT INTO sanitr_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","kutrachit kleshe upadrave vA samupasthite tadaiva vighnaM prApnuvanti taeva uptabIjapAShANabhUmisvarUpAH| ");
INSERT INTO sanitr_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","ye janAH kathAM shR^iNvanti kintu sAMsArikI chintA dhanabhrAnti rviShayalobhashcha ete sarvve upasthAya tAM kathAM grasanti tataH mA viphalA bhavati ");
INSERT INTO sanitr_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","taeva uptabIjasakaNTakabhUmisvarUpAH| ");
INSERT INTO sanitr_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ye janA vAkyaM shrutvA gR^ihlanti teShAM kasya vA triMshadguNAni kasya vA ShaShTiguNAni kasya vA shataguNAni phalAni bhavanti taeva uptabIjorvvarabhUmisvarUpAH| ");
INSERT INTO sanitr_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","tadA so.aparamapi kathitavAn kopi jano dIpAdhAraM parityajya droNasyAdhaH khaTvAyA adhe vA sthApayituM dIpamAnayati kiM? ");
INSERT INTO sanitr_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","atoheto ryanna prakAshayiShyate tAdR^ig lukkAyitaM kimapi vastu nAsti; yad vyaktaM na bhaviShyati tAdR^ishaM guptaM kimapi vastu nAsti| ");
INSERT INTO sanitr_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","yasya shrotuM karNau staH sa shR^iNotu| ");
INSERT INTO sanitr_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","aparamapi kathitavAn yUyaM yad yad vAkyaM shR^iNutha tatra sAvadhAnA bhavata, yato yUyaM yena parimANena parimAtha tenaiva parimANena yuShmadarthamapi parimAsyate; shrotAro yUyaM yuShmabhyamadhikaM dAsyate| ");
INSERT INTO sanitr_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","yasyAshraye varddhate tasmai aparamapi dAsyate, kintu yasyAshraye na varddhate tasya yat ki nchidasti tadapi tasmAn neShyate| ");
INSERT INTO sanitr_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","anantaraM sa kathitavAn eko lokaH kShetre bIjAnyuptvA ");
INSERT INTO sanitr_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","jAgaraNanidrAbhyAM divAnishaM gamayati, parantu tadvIjaM tasyAj nAtarUpeNA Nkurayati varddhate cha; ");
INSERT INTO sanitr_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","yatohetoH prathamataH patrANi tataH paraM kaNishAni tatpashchAt kaNishapUrNAni shasyAni bhUmiH svayamutpAdayati; ");
INSERT INTO sanitr_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","kintu phaleShu pakkeShu shasyachChedanakAlaM j nAtvA sa tatkShaNaM shasyAni Chinatti, anena tulyamIshvararAjyaM| ");
INSERT INTO sanitr_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","punaH so.akathayad IshvararAjyaM kena samaM? kena vastunA saha vA tadupamAsyAmi? ");
INSERT INTO sanitr_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","tat sarShapaikena tulyaM yato mR^idi vapanakAle sarShapabIjaM sarvvapR^ithivIsthabIjAt kShudraM ");
INSERT INTO sanitr_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","kintu vapanAt param a NkurayitvA sarvvashAkAd bR^ihad bhavati, tasya bR^ihatyaH shAkhAshcha jAyante tatastachChAyAM pakShiNa Ashrayante| ");
INSERT INTO sanitr_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","itthaM teShAM bodhAnurUpaM so.anekadR^iShTAntaistAnupadiShTavAn, ");
INSERT INTO sanitr_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","dR^iShTAntaM vinA kAmapi kathAM tebhyo na kathitavAn pashchAn nirjane sa shiShyAn sarvvadR^iShTAntArthaM bodhitavAn| ");
INSERT INTO sanitr_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","taddinasya sandhyAyAM sa tebhyo.akathayad AgachChata vayaM pAraM yAma| ");
INSERT INTO sanitr_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","tadA te lokAn visR^ijya tamavilambaM gR^ihItvA naukayA pratasthire; aparA api nAvastayA saha sthitAH| ");
INSERT INTO sanitr_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","tataH paraM mahAjha nbhshagamAt nau rdolAyamAnA tara NgeNa jalaiH pUrNAbhavachcha| ");
INSERT INTO sanitr_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","tadA sa naukAchashchAdbhAge upadhAne shiro nidhAya nidrita AsIt tataste taM jAgarayitvA jagaduH, he prabho, asmAkaM prANA yAnti kimatra bhavatashchintA nAsti? ");
INSERT INTO sanitr_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","tadA sa utthAya vAyuM tarjitavAn samudra nchoktavAn shAntaH susthirashcha bhava; tato vAyau nivR^itte.abdhirnistara NgobhUt| ");
INSERT INTO sanitr_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","tadA sa tAnuvAcha yUyaM kuta etAdR^iksha NkAkulA bhavata? kiM vo vishvAso nAsti? ");
INSERT INTO sanitr_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","tasmAtte.atIvabhItAH parasparaM vaktumArebhire, aho vAyuH sindhushchAsya nideshagrAhiNau kIdR^igayaM manujaH| ");
INSERT INTO sanitr_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","atha tU sindhupAraM gatvA giderIyapradesha upatasthuH| ");
INSERT INTO sanitr_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","naukAto nirgatamAtrAd apavitrabhUtagrasta ekaH shmashAnAdetya taM sAkShAch chakAra| ");
INSERT INTO sanitr_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","sa shmashAne.avAtsIt kopi taM shR^i Nkhalena badvvA sthApayituM nAshaknot| ");
INSERT INTO sanitr_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","janairvAraM nigaDaiH shR^i Nkhalaishcha sa baddhopi shR^i NkhalAnyAkR^iShya mochitavAn nigaDAni cha bhaMktvA khaNDaM khaNDaM kR^itavAn kopi taM vashIkarttuM na shashaka| ");
INSERT INTO sanitr_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","divAnishaM sadA parvvataM shmashAna ncha bhramitvA chItshabdaM kR^itavAn grAvabhishcha svayaM svaM kR^itavAn| ");
INSERT INTO sanitr_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","sa yIshuM dUrAt pashyanneva dhAvan taM praNanAma uchairuvaMshchovAcha, ");
INSERT INTO sanitr_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","he sarvvoparistheshvaraputra yIsho bhavatA saha me kaH sambandhaH? ahaM tvAmIshvareNa shApaye mAM mA yAtaya| ");
INSERT INTO sanitr_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","yato yIshustaM kathitavAn re apavitrabhUta, asmAnnarAd bahirnirgachCha| ");
INSERT INTO sanitr_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","atha sa taM pR^iShTavAn kinte nAma? tena pratyuktaM vayamaneke .asmastato.asmannAma bAhinI| ");
INSERT INTO sanitr_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","tatosmAn deshAnna preShayeti te taM prArthayanta| ");
INSERT INTO sanitr_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","tadAnIM parvvataM nikaShA bR^ihan varAhavrajashcharannAsIt| ");
INSERT INTO sanitr_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","tasmAd bhUtA vinayena jagaduH, amuM varAhavrajam Ashrayitum asmAn prahiNu| ");
INSERT INTO sanitr_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","yIshunAnuj nAtAste.apavitrabhUtA bahirniryAya varAhavrajaM prAvishan tataH sarvve varAhA vastutastu prAyodvisahasrasaM NkhyakAH kaTakena mahAjavAd dhAvantaH sindhau prANAn jahuH| ");
INSERT INTO sanitr_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","tasmAd varAhapAlakAH palAyamAnAH pure grAme cha tadvArttaM kathayA nchakruH| tadA lokA ghaTitaM tatkAryyaM draShTuM bahirjagmuH ");
INSERT INTO sanitr_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","yIshoH sannidhiM gatvA taM bhUtagrastam arthAd bAhinIbhUtagrastaM naraM savastraM sachetanaM samupaviShTa ncha dR^iृShTvA bibhyuH| ");
INSERT INTO sanitr_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","tato dR^iShTatatkAryyalokAstasya bhUtagrastanarasya varAhavrajasyApi tAM dhaTanAM varNayAmAsuH| ");
INSERT INTO sanitr_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","tataste svasImAto bahirgantuM yIshuM vinetumArebhire| ");
INSERT INTO sanitr_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","atha tasya naukArohaNakAle sa bhUtamukto nA yIshunA saha sthAtuM prArthayate; ");
INSERT INTO sanitr_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","kintu sa tamananumatya kathitavAn tvaM nijAtmIyAnAM samIpaM gR^iha ncha gachCha prabhustvayi kR^ipAM kR^itvA yAni karmmANi kR^itavAn tAni tAn j nApaya| ");
INSERT INTO sanitr_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ataH sa prasthAya yIshunA kR^itaM tatsarvvAshcharyyaM karmma dikApalideshe prachArayituM prArabdhavAn tataH sarvve lokA AshcharyyaM menire| ");
INSERT INTO sanitr_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","anantaraM yIshau nAvA punaranyapAra uttIrNe sindhutaTe cha tiShThati sati tatsamIpe bahulokAnAM samAgamo.abhUt| ");
INSERT INTO sanitr_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","aparaM yAyIr nAmnA kashchid bhajanagR^ihasyAdhipa Agatya taM dR^iShTvaiva charaNayoH patitvA bahu nivedya kathitavAn; ");
INSERT INTO sanitr_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","mama kanyA mR^itaprAyAbhUd ato bhavAnetya tadArogyAya tasyA gAtre hastam arpayatu tenaiva sA jIviShyati| ");
INSERT INTO sanitr_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","tadA yIshustena saha chalitaH kintu tatpashchAd bahulokAshchalitvA tAdgAtre patitAH| ");
INSERT INTO sanitr_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","atha dvAdashavarShANi pradararogeNa ");
INSERT INTO sanitr_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","shIrNA chikitsakAnAM nAnAchikitsAbhishcha duHkhaM bhuktavatI cha sarvvasvaM vyayitvApi nArogyaM prAptA cha punarapi pIDitAsIchcha ");
INSERT INTO sanitr_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","yA strI sA yIsho rvArttAM prApya manasAkathayat yadyahaM tasya vastramAtra spraShTuM labheyaM tadA rogahInA bhaviShyAmi| ");
INSERT INTO sanitr_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","atohetoH sA lokAraNyamadhye tatpashchAdAgatya tasya vastraM pasparsha| ");
INSERT INTO sanitr_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","tenaiva tatkShaNaM tasyA raktasrotaH shuShkaM svayaM tasmAd rogAnmuktA ityapi dehe.anubhUtA| ");
INSERT INTO sanitr_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","atha svasmAt shakti rnirgatA yIshuretanmanasA j nAtvA lokanivahaM prati mukhaM vyAvR^itya pR^iShTavAn kena madvastraM spR^iShTaM? ");
INSERT INTO sanitr_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","tatastasya shiShyA UchuH bhavato vapuShi lokAH saMgharShanti tad dR^iShTvA kena madvastraM spR^iShTamiti kutaH kathayati? ");
INSERT INTO sanitr_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","kintu kena tat karmma kR^itaM tad draShTuM yIshushchaturdisho dR^iShTavAn| ");
INSERT INTO sanitr_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","tataH sA strI bhItA kampitA cha satI svasyA rukpratikriyA jAteti j nAtvAgatya tatsammukhe patitvA sarvvavR^ittAntaM satyaM tasmai kathayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","tadAnIM yIshustAM gaditavAn, he kanye tava pratItistvAm arogAmakarot tvaM kShemeNa vraja svarogAnmuktA cha tiShTha| ");
INSERT INTO sanitr_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","itivAkyavadanakAle bhajanagR^ihAdhipasya niveshanAl lokA etyAdhipaM babhAShire tava kanyA mR^itA tasmAd guruM punaH kutaH klishnAsi? ");
INSERT INTO sanitr_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","kintu yIshustad vAkyaM shrutvaiva bhajanagR^ihAdhipaM gaditavAn mA bhaiShIH kevalaM vishvAsihi| ");
INSERT INTO sanitr_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","atha pitaro yAkUb tadbhrAtA yohan cha etAn vinA kamapi svapashchAd yAtuM nAnvamanyata| ");
INSERT INTO sanitr_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","tasya bhajanagR^ihAdhipasya niveshanasamIpam Agatya kalahaM bahurodanaM vilApa ncha kurvvato lokAn dadarsha| ");
INSERT INTO sanitr_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","tasmAn niveshanaM pravishya proktavAn yUyaM kuta itthaM kalahaM rodana ncha kurutha? kanyA na mR^itA nidrAti| ");
INSERT INTO sanitr_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","tasmAtte tamupajahasuH kintu yIshuH sarvvAna bahiShkR^itya kanyAyAH pitarau svasa Nginashcha gR^ihItvA yatra kanyAsIt tat sthAnaM praviShTavAn| ");
INSERT INTO sanitr_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","atha sa tasyAH kanyAyA hastau dhR^itvA tAM babhAShe TAlIthA kUmI, arthato he kanye tvamuttiShTha ityAj nApayAmi| ");
INSERT INTO sanitr_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","tunaiva tatkShaNaM sA dvAdashavarShavayaskA kanyA potthAya chalitumArebhe, itaH sarvve mahAvismayaM gatAH| ");
INSERT INTO sanitr_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","tata etasyai ki nchit khAdyaM datteti kathayitvA etatkarmma kamapi na j nApayateti dR^iDhamAdiShTavAn| ");
INSERT INTO sanitr_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","anantaraM sa tatsthAnAt prasthAya svapradeshamAgataH shiShyAshcha tatpashchAd gatAH| ");
INSERT INTO sanitr_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","atha vishrAmavAre sati sa bhajanagR^ihe upadeShTumArabdhavAn tato.aneke lokAstatkathAM shrutvA vismitya jagaduH, asya manujasya IdR^ishI AshcharyyakriyA kasmAj jAtA? tathA svakarAbhyAm itthamadbhutaM karmma karttAुm etasmai kathaM j nAnaM dattam? ");
INSERT INTO sanitr_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","kimayaM mariyamaH putrastaj nA no? kimayaM yAkUb-yosi-yihudA-shimonAM bhrAtA no? asya bhaginyaH kimihAsmAbhiH saha no? itthaM te tadarthe pratyUhaM gatAH| ");
INSERT INTO sanitr_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","tadA yIshustebhyo.akathayat svadeshaM svakuTumbAn svaparijanAMshcha vinA kutrApi bhaviShyadvAdI asatkR^ito na bhavati| ");
INSERT INTO sanitr_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","apara ncha teShAmapratyayAt sa vismitaH kiyatAM rogiNAM vapuHShu hastam arpayitvA kevalaM teShAmArogyakaraNAd anyat kimapi chitrakAryyaM karttAM na shaktaH| ");
INSERT INTO sanitr_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","atha sa chaturdikstha grAmAn bhramitvA upadiShTavAn ");
INSERT INTO sanitr_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","dvAdashashiShyAn AhUya amedhyabhUtAn vashIkarttAM shaktiM dattvA teShAM dvau dvau jano preShitavAn| ");
INSERT INTO sanitr_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","punarityAdishad yUyam ekaikAM yaShTiM vinA vastrasaMpuTaH pUpaH kaTibandhe tAmrakhaNDa ncha eShAM kimapi mA grahlIta, ");
INSERT INTO sanitr_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","mArgayAtrAyai pAdeShUpAnahau dattvA dve uttarIye mA paridhadvvaM| ");
INSERT INTO sanitr_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","aparamapyuktaM tena yUyaM yasyAM puryyAM yasya niveshanaM pravekShyatha tAM purIM yAvanna tyakShyatha tAvat tanniveshane sthAsyatha| ");
INSERT INTO sanitr_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","tatra yadi kepi yuShmAkamAtithyaM na vidadhati yuShmAkaM kathAshcha na shR^iNvanti tarhi tatsthAnAt prasthAnasamaye teShAM viruddhaM sAkShyaM dAtuM svapAdAnAsphAlya rajaH sampAtayata; ahaM yuShmAn yathArthaM vachmi vichAradine tannagarasyAvasthAtaH sidomAmorayo rnagarayoravasthA sahyatarA bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","atha te gatvA lokAnAM manaHparAvarttanIH kathA prachAritavantaH| ");
INSERT INTO sanitr_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","evamanekAn bhUtAMshcha tyAjitavantastathA tailena marddayitvA bahUn janAnarogAnakArShuH| ");
INSERT INTO sanitr_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","itthaM tasya sukhyAtishchaturdisho vyAptA tadA herod rAjA tannishamya kathitavAn, yohan majjakaH shmashAnAd utthita atohetostena sarvvA etA adbhutakriyAH prakAshante| ");
INSERT INTO sanitr_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","anye.akathayan ayam eliyaH, kepi kathitavanta eSha bhaviShyadvAdI yadvA bhaviShyadvAdinAM sadR^isha ekoyam| ");
INSERT INTO sanitr_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","kintu herod ityAkarNya bhAShitavAn yasyAhaM shirashChinnavAn sa eva yohanayaM sa shmashAnAdudatiShThat| ");
INSERT INTO sanitr_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","pUrvvaM svabhrAtuH philipasya patnyA udvAhaM kR^itavantaM herodaM yohanavAdIt svabhAtR^ivadhU rna vivAhyA| ");
INSERT INTO sanitr_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ataH kAraNAt herod lokaM prahitya yohanaM dhR^itvA bandhanAlaye baddhavAn| ");
INSERT INTO sanitr_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","herodiyA tasmai yohane prakupya taM hantum aichChat kintu na shaktA, ");
INSERT INTO sanitr_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","yasmAd herod taM dhArmmikaM satpuruSha ncha j nAtvA sammanya rakShitavAn; tatkathAM shrutvA tadanusAreNa bahUni karmmANi kR^itavAn hR^iShTamanAstadupadeshaM shrutavAMshcha| ");
INSERT INTO sanitr_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","kintu herod yadA svajanmadine pradhAnalokebhyaH senAnIbhyashcha gAlIlpradeshIyashreShThalokebhyashcha rAtrau bhojyamekaM kR^itavAn ");
INSERT INTO sanitr_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","tasmin shubhadine herodiyAyAH kanyA sametya teShAM samakShaM saMnR^itya herodastena sahopaviShTAnA ncha toShamajIjanat tatA nR^ipaH kanyAmAha sma matto yad yAchase tadeva tubhyaM dAsye| ");
INSERT INTO sanitr_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","shapathaM kR^itvAkathayat ched rAjyArddhamapi yAchase tadapi tubhyaM dAsye| ");
INSERT INTO sanitr_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","tataH sA bahi rgatvA svamAtaraM paprachCha kimahaM yAchiShye? tadA sAkathayat yohano majjakasya shiraH| ");
INSERT INTO sanitr_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","atha tUrNaM bhUpasamIpam etya yAchamAnAvadat kShaNesmin yohano majjakasya shiraH pAtre nidhAya dehi, etad yAche.ahaM| ");
INSERT INTO sanitr_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","tasmAt bhUpo.atiduHkhitaH, tathApi svashapathasya sahabhojinA nchAnurodhAt tadana NgIkarttuM na shaktaH| ");
INSERT INTO sanitr_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","tatkShaNaM rAjA ghAtakaM preShya tasya shira AnetumAdiShTavAn| ");
INSERT INTO sanitr_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","tataH sa kArAgAraM gatvA tachChirashChitvA pAtre nidhAyAnIya tasyai kanyAyai dattavAn kanyA cha svamAtre dadau| ");
INSERT INTO sanitr_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ananataraM yohanaH shiShyAstadvArttAM prApyAgatya tasya kuNapaM shmashAne.asthApayan| ");
INSERT INTO sanitr_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","atha preShitA yIshoH sannidhau militA yad yach chakruH shikShayAmAsushcha tatsarvvavArttAstasmai kathitavantaH| ");
INSERT INTO sanitr_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","sa tAnuvAcha yUyaM vijanasthAnaM gatvA vishrAmyata yatastatsannidhau bahulokAnAM samAgamAt te bhoktuM nAvakAshaM prAptAH| ");
INSERT INTO sanitr_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","tataste nAvA vijanasthAnaM guptaM gagmuH| ");
INSERT INTO sanitr_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","tato lokanivahasteShAM sthAnAntarayAnaM dadarsha, aneke taM parichitya nAnApurebhyaH padairvrajitvA javena taiShAmagre yIshoH samIpa upatasthuH| ");
INSERT INTO sanitr_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","tadA yIshu rnAvo bahirgatya lokAraNyAnIM dR^iShTvA teShu karuNAM kR^itavAn yataste.arakShakameShA ivAsan tadA sa tAna nAnAprasa NgAn upadiShTavAn| ");
INSERT INTO sanitr_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","atha divAnte sati shiShyA etya yIshumUchire, idaM vijanasthAnaM dina nchAvasannaM| ");
INSERT INTO sanitr_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","lokAnAM kimapi khAdyaM nAsti, atashchaturdikShu grAmAn gantuM bhojyadravyANi kretu ncha bhavAn tAn visR^ijatu| ");
INSERT INTO sanitr_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","tadA sa tAnuvAcha yUyameva tAn bhojayata; tataste jagadu rvayaM gatvA dvishatasaMkhyakai rmudrApAdaiH pUpAn krItvA kiM tAn bhojayiShyAmaH? ");
INSERT INTO sanitr_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","tadA sa tAn pR^iShThavAn yuShmAkaM sannidhau kati pUpA Asate? gatvA pashyata; tataste dR^iShTvA tamavadan pa ncha pUpA dvau matsyau cha santi| ");
INSERT INTO sanitr_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","tadA sa lokAn shaspopari paMktibhirupaveshayitum AdiShTavAn, ");
INSERT INTO sanitr_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","tataste shataM shataM janAH pa nchAshat pa nchAshajjanAshcha paMktibhi rbhuvi samupavivishuH| ");
INSERT INTO sanitr_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","atha sa tAn pa nchapUpAn matsyadvaya ncha dhR^itvA svargaM pashyan IshvaraguNAn anvakIrttayat tAn pUpAn bhaMktvA lokebhyaH pariveShayituM shiShyebhyo dattavAn dvA matsyau cha vibhajya sarvvebhyo dattavAn| ");
INSERT INTO sanitr_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","tataH sarvve bhuktvAtR^ipyan| ");
INSERT INTO sanitr_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","anantaraM shiShyA avashiShTaiH pUpai rmatsyaishcha pUrNAn dvadasha DallakAn jagR^ihuH| ");
INSERT INTO sanitr_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","te bhoktAraH prAyaH pa ncha sahasrANi puruShA Asan| ");
INSERT INTO sanitr_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","atha sa lokAn visR^ijanneva nAvamAroDhuM svasmAdagre pAre baitsaidApuraM yAtu ncha shShyiाn vADhamAdiShTavAn| ");
INSERT INTO sanitr_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","tadA sa sarvvAn visR^ijya prArthayituM parvvataM gataH| ");
INSERT INTO sanitr_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","tataH sandhyAyAM satyAM nauH sindhumadhya upasthitA kintu sa ekAkI sthale sthitaH| ");
INSERT INTO sanitr_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","atha sammukhavAtavahanAt shiShyA nAvaM vAhayitvA parishrAntA iti j nAtvA sa nishAchaturthayAme sindhUpari padbhyAM vrajan teShAM samIpametya teShAmagre yAtum udyataH| ");
INSERT INTO sanitr_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","kintu shiShyAH sindhUpari taM vrajantaM dR^iShTvA bhUtamanumAya ruruvuH, ");
INSERT INTO sanitr_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","yataH sarvve taM dR^iShTvA vyAkulitAH| ataeva yIshustatkShaNaM taiH sahAlapya kathitavAn, susthirA bhUta, ayamahaM mA bhaiShTa| ");
INSERT INTO sanitr_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","atha naukAmAruhya tasmin teShAM sannidhiM gate vAto nivR^ittaH; tasmAtte manaHsu vismitA AshcharyyaM menire| ");
INSERT INTO sanitr_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","yataste manasAM kAThinyAt tat pUpIyam AshcharyyaM karmma na viviktavantaH| ");
INSERT INTO sanitr_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","atha te pAraM gatvA gineSharatpradeshametya taTa upasthitAH| ");
INSERT INTO sanitr_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","teShu naukAto bahirgateShu tatpradeshIyA lokAstaM parichitya ");
INSERT INTO sanitr_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","chaturdikShu dhAvanto yatra yatra rogiNo narA Asan tAn sarvvAna khaTvopari nidhAya yatra kutrachit tadvArttAM prApuH tat sthAnam Anetum Arebhire| ");
INSERT INTO sanitr_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","tathA yatra yatra grAme yatra yatra pure yatra yatra pallyA ncha tena praveshaH kR^itastadvartmamadhye lokAH pIDitAn sthApayitvA tasya chelagranthimAtraM spraShTum teShAmarthe tadanuj nAM prArthayantaH yAvanto lokAH paspR^ishustAvanta eva gadAnmuktAH| ");
INSERT INTO sanitr_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","anantaraM yirUshAlama AgatAH phirUshino.adhyApakAshcha yIshoH samIpam AgatAH| ");
INSERT INTO sanitr_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","te tasya kiyataH shiShyAn ashuchikarairarthAda aprakShAlitahastai rbhu njato dR^iShTvA tAnadUShayan| ");
INSERT INTO sanitr_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","yataH phirUshinaH sarvvayihUdIyAshcha prAchAM paramparAgatavAkyaM sammanya pratalena hastAn aprakShAlya na bhu njate| ");
INSERT INTO sanitr_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ApanAdAgatya majjanaM vinA na khAdanti; tathA pAnapAtrANAM jalapAtrANAM pittalapAtrANAm AsanAnA ncha jale majjanam ityAdayonyepi bahavasteShAmAchArAH santi| ");
INSERT INTO sanitr_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","te phirUshino.adhyApakAshcha yIshuM paprachChuH, tava shiShyAH prAchAM paramparAgatavAkyAnusAreNa nAcharanto.aprakShAlitakaraiH kuto bhujaMte? ");
INSERT INTO sanitr_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","tataH sa pratyuvAcha kapaTino yuShmAn uddishya yishayiyabhaviShyadvAdI yuktamavAdIt| yathA svakIyairadharairete sammanyanate sadaiva mAM| kintu matto viprakarShe santi teShAM manAMsi cha| ");
INSERT INTO sanitr_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","shikShayanto bidhIn nnAj nA bhajante mAM mudhaiva te| ");
INSERT INTO sanitr_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","yUyaM jalapAtrapAnapAtrAdIni majjayanto manujaparamparAgatavAkyaM rakShatha kintu IshvarAj nAM laMghadhve; aparA IdR^ishyonekAH kriyA api kurudhve| ");
INSERT INTO sanitr_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","anya nchAkathayat yUyaM svaparamparAgatavAkyasya rakShArthaM spaShTarUpeNa IshvarAj nAM lopayatha| ");
INSERT INTO sanitr_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","yato mUsAdvArA proktamasti svapitarau sammanyadhvaM yastu mAtaraM pitaraM vA durvvAkyaM vakti sa nitAntaM hanyatAM| ");
INSERT INTO sanitr_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","kintu madIyena yena dravyeNa tavopakArobhavat tat karbbANamarthAd IshvarAya niveditam idaM vAkyaM yadi kopi pitaraM mAtaraM vA vakti ");
INSERT INTO sanitr_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","tarhi yUyaM mAtuH pitu rvopakAraM karttAM taM vArayatha| ");
INSERT INTO sanitr_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","itthaM svaprachAritaparamparAgatavAkyena yUyam IshvarAj nAM mudhA vidhadvve, IdR^ishAnyanyAnyanekAni karmmANi kurudhve| ");
INSERT INTO sanitr_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","atha sa lokAnAhUya babhAShe yUyaM sarvve madvAkyaM shR^iNuta budhyadhva ncha| ");
INSERT INTO sanitr_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","bAhyAdantaraM pravishya naramamedhyaM karttAM shaknoti IdR^ishaM kimapi vastu nAsti, varam antarAd bahirgataM yadvastu tanmanujam amedhyaM karoti| ");
INSERT INTO sanitr_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","yasya shrotuM shrotre staH sa shR^iNotu| ");
INSERT INTO sanitr_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","tataH sa lokAn hitvA gR^ihamadhyaM praviShTastadA shiShyAstadR^iShTAntavAkyArthaM paprachChuH| ");
INSERT INTO sanitr_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","tasmAt sa tAn jagAda yUyamapi kimetAdR^igabodhAH? kimapi dravyaM bAhyAdantaraM pravishya naramamedhyaM karttAM na shaknoti kathAmimAM kiM na budhyadhve? ");
INSERT INTO sanitr_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","tat tadantarna pravishati kintu kukShimadhyaM pravishati sheShe sarvvabhuktavastugrAhiNi bahirdeshe niryAti| ");
INSERT INTO sanitr_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","aparamapyavAdId yannarAnnireti tadeva naramamedhyaM karoti| ");
INSERT INTO sanitr_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","yato.antarAd arthAn mAnavAnAM manobhyaH kuchintA parastrIveshyAgamanaM ");
INSERT INTO sanitr_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","naravadhashchauryyaM lobho duShTatA prava nchanA kAmukatA kudR^iShTirIshvaranindA garvvastama ityAdIni nirgachChanti| ");
INSERT INTO sanitr_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","etAni sarvvANi duritAnyantarAdetya naramamedhyaM kurvvanti| ");
INSERT INTO sanitr_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","atha sa utthAya tatsthAnAt sorasIdonpurapradeshaM jagAma tatra kimapi niveshanaM pravishya sarvvairaj nAtaH sthAtuM mati nchakre kintu guptaH sthAtuM na shashAka| ");
INSERT INTO sanitr_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","yataH suraphainikIdeshIyayUnAnIvaMshodbhavastriyAH kanyA bhUtagrastAsIt| sA strI tadvArttAM prApya tatsamIpamAgatya tachcharaNayoH patitvA ");
INSERT INTO sanitr_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","svakanyAto bhUtaM nirAkarttAM tasmin vinayaM kR^itavatI| ");
INSERT INTO sanitr_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","kintu yIshustAmavadat prathamaM bAlakAstR^ipyantu yato bAlakAnAM khAdyaM gR^ihItvA kukkurebhyo nikShepo.anuchitaH| ");
INSERT INTO sanitr_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","tadA sA strI tamavAdIt bhoH prabho tat satyaM tathApi ma nchAdhaHsthAH kukkurA bAlAnAM karapatitAni khAdyakhaNDAni khAdanti| ");
INSERT INTO sanitr_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","tataH so.akathayad etatkathAhetoH sakushalA yAhi tava kanyAM tyaktvA bhUto gataH| ");
INSERT INTO sanitr_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","atha sA strI gR^ihaM gatvA kanyAM bhUtatyaktAM shayyAsthitAM dadarsha| ");
INSERT INTO sanitr_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","punashcha sa sorasIdonpurapradeshAt prasthAya dikApalideshasya prAntarabhAgena gAlIljaladheH samIpaM gatavAn| ");
INSERT INTO sanitr_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","tadA lokairekaM badhiraM kadvada ncha naraM tannikaTamAnIya tasya gAtre hastamarpayituM vinayaH kR^itaH| ");
INSERT INTO sanitr_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","tato yIshu rlokAraNyAt taM nirjanamAnIya tasya karNayo NgulI rdadau niShThIvaM dattvA cha tajjihvAM pasparsha| ");
INSERT INTO sanitr_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","anantaraM svargaM nirIkShya dIrghaM nishvasya tamavadat itaphataH arthAn mukto bhUyAt| ");
INSERT INTO sanitr_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","tatastatkShaNaM tasya karNau muktau jihvAyAshcha jADyApagamAt sa suspaShTavAkyamakathayat| ");
INSERT INTO sanitr_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","atha sa tAn vADhamityAdidesha yUyamimAM kathAM kasmaichidapi mA kathayata, kintu sa yati nyaShedhat te tati bAhulyena prAchArayan; ");
INSERT INTO sanitr_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","te.atichamatkR^itya parasparaM kathayAmAsuH sa badhirAya shravaNashaktiM mUkAya cha kathanashaktiM dattvA sarvvaM karmmottamarUpeNa chakAra| ");
INSERT INTO sanitr_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","tadA tatsamIpaM bahavo lokA AyAtA atasteShAM bhojyadravyAbhAvAd yIshuH shiShyAnAhUya jagAda,| ");
INSERT INTO sanitr_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","lokanivahe mama kR^ipA jAyate te dinatrayaM mayA sArddhaM santi teShAM bhojyaM kimapi nAsti| ");
INSERT INTO sanitr_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","teShAM madhye.aneke dUrAd AgatAH, abhukteShu teShu mayA svagR^ihamabhiprahiteShu te pathi klamiShyanti| ");
INSERT INTO sanitr_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","shiShyA avAdiShuH, etAvato lokAn tarpayitum atra prantare pUpAn prAptuM kena shakyate? ");
INSERT INTO sanitr_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","tataH sa tAn paprachCha yuShmAkaM kati pUpAH santi? te.akathayan sapta| ");
INSERT INTO sanitr_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","tataH sa tAllokAn bhuvi samupaveShTum Adishya tAn sapta pUpAn dhR^itvA IshvaraguNAn anukIrttayAmAsa, bhaMktvA pariveShayituM shiShyAn prati dadau, tataste lokebhyaH pariveShayAmAsuH| ");
INSERT INTO sanitr_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","tathA teShAM samIpe ye kShudramatsyA Asan tAnapyAdAya IshvaraguNAn saMkIrtya pariveShayitum AdiShTavAn| ");
INSERT INTO sanitr_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","tato lokA bhuktvA tR^iptiM gatA avashiShTakhAdyaiH pUrNAH saptaDallakA gR^ihItAshcha| ");
INSERT INTO sanitr_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ete bhoktAraH prAyashchatuH sahasrapuruShA Asan tataH sa tAn visasarja| ");
INSERT INTO sanitr_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","atha sa shiShyaH saha nAvamAruhya dalmAnUthAsImAmAgataH| ");
INSERT INTO sanitr_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","tataH paraM phirUshina Agatya tena saha vivadamAnAstasya parIkShArtham AkAshIyachihnaM draShTuM yAchitavantaH| ");
INSERT INTO sanitr_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","tadA so.antardIrghaM nishvasyAkathayat, ete vidyamAnanarAH kutashchinhaM mR^igayante? yuShmAnahaM yathArthaM bravImi lokAnetAn kimapi chihnaM na darshayiShyate| ");
INSERT INTO sanitr_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","atha tAn hitvA puna rnAvam Aruhya pAramagAt| ");
INSERT INTO sanitr_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","etarhi shiShyaiH pUpeShu vismR^iteShu nAvi teShAM sannidhau pUpa ekaeva sthitaH| ");
INSERT INTO sanitr_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","tadAnIM yIshustAn AdiShTavAn phirUshinAM herodashcha kiNvaM prati satarkAH sAvadhAnAshcha bhavata| ");
INSERT INTO sanitr_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","tataste.anyonyaM vivechanaM kartum Arebhire, asmAkaM sannidhau pUpo nAstIti hetoridaM kathayati| ");
INSERT INTO sanitr_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","tad budvvA yIshustebhyo.akathayat yuShmAkaM sthAne pUpAbhAvAt kuta itthaM vitarkayatha? yUyaM kimadyApi kimapi na jAnItha? boddhu ncha na shaknutha? yAvadadya kiM yuShmAkaM manAMsi kaThinAni santi? ");
INSERT INTO sanitr_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","satsu netreShu kiM na pashyatha? satsu karNeShu kiM na shR^iNutha? na smaratha cha? ");
INSERT INTO sanitr_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","yadAhaM pa nchapUpAn pa nchasahasrANAM puruShANAM madhye bhaMktvA dattavAn tadAnIM yUyam avashiShTapUpaiH pUrNAn kati DallakAn gR^ihItavantaH? te.akathayan dvAdashaDallakAn| ");
INSERT INTO sanitr_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","apara ncha yadA chatuHsahasrANAM puruShANAM madhye pUpAn bhaMktvAdadAM tadA yUyam atiriktapUpAnAM kati DallakAn gR^ihItavantaH? te kathayAmAsuH saptaDallakAn| ");
INSERT INTO sanitr_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","tadA sa kathitavAn tarhi yUyam adhunApi kuto bodvvuM na shaknutha? ");
INSERT INTO sanitr_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","anantaraM tasmin baitsaidAnagare prApte lokA andhamekaM naraM tatsamIpamAnIya taM spraShTuM taM prArthayA nchakrire| ");
INSERT INTO sanitr_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","tadA tasyAndhasya karau gR^ihItvA nagarAd bahirdeshaM taM nItavAn; tannetre niShThIvaM dattvA tadgAtre hastAvarpayitvA taM paprachCha, kimapi pashyasi? ");
INSERT INTO sanitr_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","sa netre unmIlya jagAda, vR^ikShavat manujAn gachChato nirIkShe| ");
INSERT INTO sanitr_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","tato yIshuH punastasya nayanayo rhastAvarpayitvA tasya netre unmIlayAmAsa; tasmAt sa svastho bhUtvA spaShTarUpaM sarvvalokAn dadarsha| ");
INSERT INTO sanitr_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","tataH paraM tvaM grAmaM mA gachCha grAmasthaM kamapi cha kimapyanuktvA nijagR^ihaM yAhItyAdishya yIshustaM nijagR^ihaM prahitavAn| ");
INSERT INTO sanitr_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","anantaraM shiShyaiH sahito yIshuH kaisarIyAphilipipuraM jagAma, pathi gachChan tAnapR^ichChat ko.aham atra lokAH kiM vadanti? ");
INSERT INTO sanitr_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","te pratyUchuH tvAM yohanaM majjakaM vadanti kintu kepi kepi eliyaM vadanti; apare kepi kepi bhaviShyadvAdinAm eko jana iti vadanti| ");
INSERT INTO sanitr_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","atha sa tAnapR^ichChat kintu koham? ityatra yUyaM kiM vadatha? tadA pitaraH pratyavadat bhavAn abhiShiktastrAtA| ");
INSERT INTO sanitr_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","tataH sa tAn gADhamAdishad yUyaM mama kathA kasmaichidapi mA kathayata| ");
INSERT INTO sanitr_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","manuShyaputreNAvashyaM bahavo yAtanA bhoktavyAH prAchInalokaiH pradhAnayAjakairadhyApakaishcha sa ninditaH san ghAtayiShyate tR^itIyadine utthAsyati cha, yIshuH shiShyAnupadeShTumArabhya kathAmimAM spaShTamAchaShTa| ");
INSERT INTO sanitr_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","tasmAt pitarastasya hastau dhR^itvA taM tarjjitavAn| ");
INSERT INTO sanitr_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","kintu sa mukhaM parAvartya shiShyagaNaM nirIkShya pitaraM tarjayitvAvAdId dUrIbhava vighnakArin IshvarIyakAryyAdapi manuShyakAryyaM tubhyaM rochatatarAM| ");
INSERT INTO sanitr_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","atha sa lokAn shiShyAMshchAhUya jagAda yaH kashchin mAmanugantum ichChati sa AtmAnaM dAmyatu, svakrushaM gR^ihItvA matpashchAd AyAtu| ");
INSERT INTO sanitr_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","yato yaH kashchit svaprANaM rakShitumichChati sa taM hArayiShyati, kintu yaH kashchin madarthaM susaMvAdArtha ncha prANaM hArayati sa taM rakShiShyati| ");
INSERT INTO sanitr_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","apara ncha manujaH sarvvaM jagat prApya yadi svaprANaM hArayati tarhi tasya ko lAbhaH? ");
INSERT INTO sanitr_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","naraH svaprANavinimayena kiM dAtuM shaknoti? ");
INSERT INTO sanitr_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","eteShAM vyabhichAriNAM pApinA ncha lokAnAM sAkShAd yadi kopi mAM matkathA ncha lajjAspadaM jAnAti tarhi manujaputro yadA dharmmadUtaiH saha pituH prabhAveNAgamiShyati tadA sopi taM lajjAspadaM j nAsyati| ");
INSERT INTO sanitr_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","atha sa tAnavAdIt yuShmabhyamahaM yathArthaM kathayAmi, IshvararAjyaM parAkrameNopasthitaM na dR^iShTvA mR^ityuM nAsvAdiShyante, atra daNDAyamAnAnAM madhyepi tAdR^ishA lokAH santi| ");
INSERT INTO sanitr_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","atha ShaDdinebhyaH paraM yIshuH pitaraM yAkUbaM yohana ncha gR^ihItvA gireruchchasya nirjanasthAnaM gatvA teShAM pratyakShe mUrtyantaraM dadhAra| ");
INSERT INTO sanitr_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","tatastasya paridheyam IdR^isham ujjvalahimapANaDaraM jAtaM yad jagati kopi rajako na tAdR^ik pANaDaraM karttAM shaknoti| ");
INSERT INTO sanitr_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","apara ncha eliyo mUsAshcha tebhyo darshanaM dattvA yIshunA saha kathanaM karttumArebhAte| ");
INSERT INTO sanitr_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","tadA pitaro yIshumavAdIt he guro.asmAkamatra sthitiruttamA, tataeva vayaM tvatkR^ite ekAM mUsAkR^ite ekAm eliyakR^ite chaikAM, etAstisraH kuTI rnirmmAma| ");
INSERT INTO sanitr_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","kintu sa yaduktavAn tat svayaM na bubudhe tataH sarvve bibhayA nchakruH| ");
INSERT INTO sanitr_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","etarhi payodastAn ChAdayAmAsa, mamayAM priyaH putraH kathAsu tasya manAMsi niveshayateti nabhovANI tanmedyAnniryayau| ");
INSERT INTO sanitr_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","atha haThAtte chaturdisho dR^iShTvA yIshuM vinA svaiH sahitaM kamapi na dadR^ishuH| ");
INSERT INTO sanitr_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","tataH paraM gireravarohaNakAle sa tAn gADham dUtyAdidesha yAvannarasUnoH shmashAnAdutthAnaM na bhavati, tAvat darshanasyAsya vArttA yuShmAbhiH kasmaichidapi na vaktavyA| ");
INSERT INTO sanitr_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","tadA shmashAnAdutthAnasya kobhiprAya iti vichAryya te tadvAkyaM sveShu gopAyA nchakrire| ");
INSERT INTO sanitr_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","atha te yIshuM paprachChuH prathamata eliyenAgantavyam iti vAkyaM kuta upAdhyAyA AhuH? ");
INSERT INTO sanitr_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","tadA sa pratyuvAcha , eliyaH prathamametya sarvvakAryyANi sAdhayiShyati; naraputre cha lipi ryathAste tathaiva sopi bahuduHkhaM prApyAvaj nAsyate| ");
INSERT INTO sanitr_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","kintvahaM yuShmAn vadAmi , eliyArthe lipi ryathAste tathaiva sa etya yayau, lokA: svechChAnurUpaM tamabhivyavaharanti sma| ");
INSERT INTO sanitr_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","anantaraM sa shiShyasamIpametya teShAM chatuHpArshve taiH saha bahujanAn vivadamAnAn adhyApakAMshcha dR^iShTavAn; ");
INSERT INTO sanitr_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","kintu sarvvalokAstaM dR^iShTvaiva chamatkR^itya tadAsannaM dhAvantastaM praNemuH| ");
INSERT INTO sanitr_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","tadA yIshuradhyApakAnaprAkShId etaiH saha yUyaM kiM vivadadhve? ");
INSERT INTO sanitr_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","tato lokAnAM kashchidekaH pratyavAdIt he guro mama sUnuM mUkaM bhUtadhR^ita ncha bhavadAsannam AnayaM| ");
INSERT INTO sanitr_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","yadAsau bhUtastamAkramate tadaiva pAtasati tathA sa pheNAyate, dantairdantAn gharShati kShINo bhavati cha; tato hetostaM bhUtaM tyAjayituM bhavachChiShyAn niveditavAn kintu te na shekuH| ");
INSERT INTO sanitr_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","tadA sa tamavAdIt, re avishvAsinaH santAnA yuShmAbhiH saha kati kAlAnahaM sthAsyAmi? aparAn kati kAlAn vA va AchArAn sahiShye? taM madAsannamAnayata| ");
INSERT INTO sanitr_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","tatastatsannidhiM sa AnIyata kintu taM dR^iShTvaiva bhUto bAlakaM dhR^itavAn; sa cha bhUmau patitvA pheNAyamAno luloTha| ");
INSERT INTO sanitr_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","tadA sa tatpitaraM paprachCha, asyedR^ishI dashA kati dinAni bhUtA? tataH sovAdIt bAlyakAlAt| ");
INSERT INTO sanitr_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","bhUtoyaM taM nAshayituM bahuvArAn vahnau jale cha nyakShipat kintu yadi bhavAna kimapi karttAM shaknoti tarhi dayAM kR^itvAsmAn upakarotu| ");
INSERT INTO sanitr_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","tadA yIshustamavadat yadi pratyetuM shaknoShi tarhi pratyayine janAya sarvvaM sAdhyam| ");
INSERT INTO sanitr_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","tatastatkShaNaM tadbAlakasya pitA prochchai rUvan sAshrunetraH provAcha, prabho pratyemi mamApratyayaM pratikuru| ");
INSERT INTO sanitr_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","atha yIshu rlokasa NghaM dhAvitvAyAntaM dR^iShTvA tamapUtabhUtaM tarjayitvA jagAda, re badhira mUka bhUta tvametasmAd bahirbhava punaH kadApi mAshrayainaM tvAmaham ityAdishAmi| ");
INSERT INTO sanitr_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","tadA sa bhUtashchItshabdaM kR^itvA tamApIDya bahirjajAma, tato bAlako mR^itakalpo babhUva tasmAdayaM mR^ita_ityaneke kathayAmAsuH| ");
INSERT INTO sanitr_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","kintu karaM dhR^itvA yIshunotthApitaH sa uttasthau| ");
INSERT INTO sanitr_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","atha yIshau gR^ihaM praviShTe shiShyA guptaM taM paprachChuH, vayamenaM bhUtaM tyAjayituM kuto na shaktAH? ");
INSERT INTO sanitr_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","sa uvAcha, prArthanopavAsau vinA kenApyanyena karmmaNA bhUtamIdR^ishaM tyAjayituM na shakyaM| ");
INSERT INTO sanitr_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","anantaraM sa tatsthAnAditvA gAlIlmadhyena yayau, kintu tat kopi jAnIyAditi sa naichChat| ");
INSERT INTO sanitr_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","apara ncha sa shiShyAnupadishan babhAShe, naraputro narahasteShu samarpayiShyate te cha taM haniShyanti taistasmin hate tR^itIyadine sa utthAsyatIti| ");
INSERT INTO sanitr_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","kintu tatkathAM te nAbudhyanta praShTu ncha bibhyaH| ");
INSERT INTO sanitr_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","atha yIshuH kapharnAhUmpuramAgatya madhyegR^iha nchetya tAnapR^ichChad vartmamadhye yUyamanyonyaM kiM vivadadhve sma? ");
INSERT INTO sanitr_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","kintu te niruttarAstasthu ryasmAtteShAM ko mukhya iti vartmAni te.anyonyaM vyavadanta| ");
INSERT INTO sanitr_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","tataH sa upavishya dvAdashashiShyAn AhUya babhAShe yaH kashchit mukhyo bhavitumichChati sa sarvvebhyo gauNaH sarvveShAM sevakashcha bhavatu| ");
INSERT INTO sanitr_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","tadA sa bAlakamekaM gR^ihItvA madhye samupAveshayat tatastaM kroDe kR^itvA tAnavAdAt ");
INSERT INTO sanitr_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","yaH kashchidIdR^ishasya kasyApi bAlasyAtithyaM karoti sa mamAtithyaM karoti; yaH kashchinmamAtithyaM karoti sa kevalam mamAtithyaM karoti tanna matprerakasyApyAtithyaM karoti| ");
INSERT INTO sanitr_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","atha yohan tamabravIt he guro, asmAkamananugAminam ekaM tvAnnAmnA bhUtAn tyAjayantaM vayaM dR^iShTavantaH, asmAkamapashchAdgAmitvAchcha taM nyaShedhAma| ");
INSERT INTO sanitr_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","kintu yIshuravadat taM mA niShedhat, yato yaH kashchin mannAmnA chitraM karmma karoti sa sahasA mAM nindituM na shaknoti| ");
INSERT INTO sanitr_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","tathA yaH kashchid yuShmAkaM vipakShatAM na karoti sa yuShmAkameva sapakShaH| ");
INSERT INTO sanitr_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","yaH kashchid yuShmAn khrIShTashiShyAn j nAtvA mannAmnA kaMsaikena pAnIyaM pAtuM dadAti, yuShmAnahaM yathArthaM vachmi, sa phalena va nchito na bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","kintu yadi kashchin mayi vishvAsinAmeShAM kShudraprANinAm ekasyApi vighnaM janayati, tarhi tasyaitatkarmma karaNAt kaNThabaddhapeShaNIkasya tasya sAgarAgAdhajala majjanaM bhadraM| ");
INSERT INTO sanitr_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","ataH svakaro yadi tvAM bAdhate tarhi taM Chindhi; ");
INSERT INTO sanitr_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","yasmAt yatra kITA na mriyante vahnishcha na nirvvAti, tasmin anirvvANAnalanarake karadvayavastava gamanAt karahInasya svargapraveshastava kShemaM| ");
INSERT INTO sanitr_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","yadi tava pAdo vighnaM janayati tarhi taM Chindhi, ");
INSERT INTO sanitr_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","yato yatra kITA na mriyante vahnishcha na nirvvAti, tasmin .anirvvANavahnau narake dvipAdavatastava nikShepAt pAdahInasya svargapraveshastava kShemaM| ");
INSERT INTO sanitr_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","svanetraM yadi tvAM bAdhate tarhi tadapyutpATaya, yato yatra kITA na mriyante vahnishcha na nirvvAti, ");
INSERT INTO sanitr_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","tasmina .anirvvANavahnau narake dvinetrasya tava nikShepAd ekanetravata IshvararAjye praveshastava kShemaM| ");
INSERT INTO sanitr_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","yathA sarvvo bali rlavaNAktaH kriyate tathA sarvvo jano vahnirUpeNa lavaNAktaH kAriShyate| ");
INSERT INTO sanitr_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","lavaNaM bhadraM kintu yadi lavaNe svAdutA na tiShThati, tarhi katham AsvAdyuktaM kariShyatha? yUyaM lavaNayuktA bhavata parasparaM prema kuruta| ");
INSERT INTO sanitr_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","anantaraM sa tatsthAnAt prasthAya yarddananadyAH pAre yihUdApradesha upasthitavAn, tatra tadantike lokAnAM samAgame jAte sa nijarItyanusAreNa punastAn upadidesha| ");
INSERT INTO sanitr_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","tadA phirUshinastatsamIpam etya taM parIkShituM paprachChaH svajAyA manujAnAM tyajyA na veti? ");
INSERT INTO sanitr_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","tataH sa pratyavAdIt, atra kAryye mUsA yuShmAn prati kimAj nApayat? ");
INSERT INTO sanitr_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ta UchuH tyAgapatraM lekhituM svapatnIM tyaktu ncha mUsA.anumanyate| ");
INSERT INTO sanitr_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","tadA yIshuH pratyuvAcha, yuShmAkaM manasAM kAThinyAddheto rmUsA nideshamimam alikhat| ");
INSERT INTO sanitr_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","kintu sR^iShTerAdau Ishvaro narAn puMrUpeNa strIrUpeNa cha sasarja| ");
INSERT INTO sanitr_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","\"tataH kAraNAt pumAn pitaraM mAtara ncha tyaktvA svajAyAyAm Asakto bhaviShyati, ");
INSERT INTO sanitr_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","tau dvAv ekA Ngau bhaviShyataH|\" tasmAt tatkAlamArabhya tau na dvAv ekA Ngau| ");
INSERT INTO sanitr_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ataH kAraNAd Ishvaro yadayojayat kopi narastanna viyejayet| ");
INSERT INTO sanitr_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","atha yIshu rgR^ihaM praviShTastadA shiShyAH punastatkathAM taM paprachChuH| ");
INSERT INTO sanitr_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","tataH sovadat kashchid yadi svabhAryyAM tyaktavAnyAm udvahati tarhi sa svabhAryyAyAH prAtikUlyena vyabhichArI bhavati| ");
INSERT INTO sanitr_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","kAchinnArI yadi svapatiM hitvAnyapuMsA vivAhitA bhavati tarhi sApi vyabhichAriNI bhavati| ");
INSERT INTO sanitr_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","atha sa yathA shishUn spR^ishet, tadarthaM lokaistadantikaM shishava AnIyanta, kintu shiShyAstAnAnItavatastarjayAmAsuH| ");
INSERT INTO sanitr_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","yIshustad dR^iShTvA krudhyan jagAda, mannikaTam AgantuM shishUn mA vArayata, yata etAdR^ishA IshvararAjyAdhikAriNaH| ");
INSERT INTO sanitr_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","yuShmAnahaM yathArthaM vachmi, yaH kashchit shishuvad bhUtvA rAjyamIshvarasya na gR^ihlIyAt sa kadApi tadrAjyaM praveShTuM na shaknoti| ");
INSERT INTO sanitr_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ananataraM sa shishUna Nke nidhAya teShAM gAtreShu hastau dattvAshiShaM babhAShe| ");
INSERT INTO sanitr_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","atha sa vartmanA yAti, etarhi jana eko dhAvan Agatya tatsammukhe jAnunI pAtayitvA pR^iShTavAn, bhoH paramaguro, anantAyuH prAptaye mayA kiM karttavyaM? ");
INSERT INTO sanitr_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","tadA yIshuruvAcha, mAM paramaM kuto vadasi? vineshvaraM kopi paramo na bhavati| ");
INSERT INTO sanitr_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","parastrIM nAbhigachCha; naraM mA ghAtaya; steyaM mA kuru; mR^iShAsAkShyaM mA dehi; hiMsA ncha mA kuru; pitarau sammanyasva; nideshA ete tvayA j nAtAH| ");
INSERT INTO sanitr_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","tatastana pratyuktaM, he guro bAlyakAlAdahaM sarvvAnetAn AcharAmi| ");
INSERT INTO sanitr_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","tadA yIshustaM vilokya snehena babhAShe, tavaikasyAbhAva Aste; tvaM gatvA sarvvasvaM vikrIya daridrebhyo vishrANaya, tataH svarge dhanaM prApsyasi; tataH param etya krushaM vahan madanuvarttI bhava| ");
INSERT INTO sanitr_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","kintu tasya bahusampadvidyamAnatvAt sa imAM kathAmAkarNya viShaNo duHkhitashcha san jagAma| ");
INSERT INTO sanitr_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","atha yIshushchaturdisho nirIkShya shiShyAn avAdIt, dhanilokAnAm IshvararAjyapraveshaH kIdR^ig duShkaraH| ");
INSERT INTO sanitr_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","tasya kathAtaH shiShyAshchamachchakruH, kintu sa punaravadat, he bAlakA ye dhane vishvasanti teShAm IshvararAjyapraveshaH kIdR^ig duShkaraH| ");
INSERT INTO sanitr_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","IshvararAjye dhaninAM praveshAt sUchirandhreNa mahA Ngasya gamanAgamanaM sukaraM| ");
INSERT INTO sanitr_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","tadA shiShyA atIva vismitAH parasparaM prochuH, tarhi kaH paritrANaM prAptuM shaknoti? ");
INSERT INTO sanitr_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","tato yIshustAn vilokya babhAShe, tan narasyAsAdhyaM kintu neshvarasya, yato hetorIshvarasya sarvvaM sAdhyam| ");
INSERT INTO sanitr_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","tadA pitara uvAcha, pashya vayaM sarvvaM parityajya bhavatonugAmino jAtAH| ");
INSERT INTO sanitr_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","tato yIshuH pratyavadat, yuShmAnahaM yathArthaM vadAmi, madarthaM susaMvAdArthaM vA yo janaH sadanaM bhrAtaraM bhaginIM pitaraM mAtaraM jAyAM santAnAn bhUmi vA tyaktvA ");
INSERT INTO sanitr_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","gR^ihabhrAtR^ibhaginIpitR^imAtR^ipatnIsantAnabhUmInAmiha shataguNAn pretyAnantAyushcha na prApnoti tAdR^ishaH kopi nAsti| ");
INSERT INTO sanitr_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","kintvagrIyA aneke lokAH sheShAH, sheShIyA aneke lokAshchAgrA bhaviShyanti| ");
INSERT INTO sanitr_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","atha yirUshAlamyAnakAle yIshusteShAm agragAmI babhUva, tasmAtte chitraM j nAtvA pashchAdgAmino bhUtvA bibhyuH| tadA sa puna rdvAdashashiShyAn gR^ihItvA svIyaM yadyad ghaTiShyate tattat tebhyaH kathayituM prArebhe; ");
INSERT INTO sanitr_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","pashyata vayaM yirUshAlampuraM yAmaH, tatra manuShyaputraH pradhAnayAjakAnAm upAdhyAyAnA ncha kareShu samarpayiShyate; te cha vadhadaNDAj nAM dApayitvA paradeshIyAnAM kareShu taM samarpayiShyanti| ");
INSERT INTO sanitr_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","te tamupahasya kashayA prahR^itya tadvapuShi niShThIvaM nikShipya taM haniShyanti, tataH sa tR^itIyadine protthAsyati| ");
INSERT INTO sanitr_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","tataH sivadeH putrau yAkUbyohanau tadantikam etya prochatuH, he guro yad AvAbhyAM yAchiShyate tadasmadarthaM bhavAn karotu nivedanamidamAvayoH| ");
INSERT INTO sanitr_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","tataH sa kathitavAn, yuvAM kimichChathaH? kiM mayA yuShmadarthaM karaNIyaM? ");
INSERT INTO sanitr_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","tadA tau prochatuH, AvayorekaM dakShiNapArshve vAmapArshve chaikaM tavaishvaryyapade samupaveShTum Aj nApaya| ");
INSERT INTO sanitr_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","kintu yIshuH pratyuvAcha yuvAmaj nAtvedaM prArthayethe, yena kaMsenAhaM pAsyAmi tena yuvAbhyAM kiM pAtuM shakShyate? yasmin majjanenAhaM majjiShye tanmajjane majjayituM kiM yuvAbhyAM shakShyate? tau pratyUchatuH shakShyate| ");
INSERT INTO sanitr_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","tadA yIshuravadat yena kaMsenAhaM pAsyAmi tenAvashyaM yuvAmapi pAsyathaH, yena majjanena chAhaM majjiyye tatra yuvAmapi majjiShyethe| ");
INSERT INTO sanitr_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","kintu yeShAmartham idaM nirUpitaM, tAn vihAyAnyaM kamapi mama dakShiNapArshve vAmapArshve vA samupaveshayituM mamAdhikAro nAsti| ");
INSERT INTO sanitr_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","athAnyadashashiShyA imAM kathAM shrutvA yAkUbyohanbhyAM chukupuH| ");
INSERT INTO sanitr_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","kintu yIshustAn samAhUya babhAShe, anyadeshIyAnAM rAjatvaM ye kurvvanti te teShAmeva prabhutvaM kurvvanti, tathA ye mahAlokAste teShAm adhipatitvaM kurvvantIti yUyaM jAnItha| ");
INSERT INTO sanitr_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","kintu yuShmAkaM madhye na tathA bhaviShyati, yuShmAkaM madhye yaH prAdhAnyaM vA nChati sa yuShmAkaM sevako bhaviShyati, ");
INSERT INTO sanitr_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","yuShmAkaM yo mahAn bhavitumichChati sa sarvveShAM ki Nkaro bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","yato manuShyaputraH sevyo bhavituM nAgataH sevAM karttAM tathAnekeShAM paritrANasya mUlyarUpasvaprANaM dAtu nchAgataH| ");
INSERT INTO sanitr_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","atha te yirIhonagaraM prAptAstasmAt shiShyai rlokaishcha saha yIsho rgamanakAle TImayasya putro barTImayanAmA andhastanmArgapArshve bhikShArtham upaviShTaH| ");
INSERT INTO sanitr_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","sa nAsaratIyasya yIshorAgamanavArttAM prApya prochai rvaktumArebhe, he yIsho dAyUdaH santAna mAM dayasva| ");
INSERT INTO sanitr_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","tatoneke lokA maunIbhaveti taM tarjayAmAsuH, kintu sa punaradhikamuchchai rjagAda, he yIsho dAyUdaH santAna mAM dayasva| ");
INSERT INTO sanitr_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","tadA yIshuH sthitvA tamAhvAtuM samAdidesha, tato lokAstamandhamAhUya babhAShire, he nara, sthiro bhava, uttiShTha, sa tvAmAhvayati| ");
INSERT INTO sanitr_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","tadA sa uttarIyavastraM nikShipya protthAya yIshoH samIpaM gataH| ");
INSERT INTO sanitr_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","tato yIshustamavadat tvayA kiM prArthyate? tubhyamahaM kiM kariShyAmI? tadA sondhastamuvAcha, he guro madIyA dR^iShTirbhavet| ");
INSERT INTO sanitr_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","tato yIshustamuvAcha yAhi tava vishvAsastvAM svasthamakArShIt, tasmAt tatkShaNaM sa dR^iShTiM prApya pathA yIshoH pashchAd yayau| ");
INSERT INTO sanitr_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","anantaraM teShu yirUshAlamaH samIpasthayo rbaitphagIbaithanIyapurayorantikasthaM jaitunanAmAdrimAgateShu yIshuH preShaNakAle dvau shiShyAvidaM vAkyaM jagAda, ");
INSERT INTO sanitr_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","yuvAmamuM sammukhasthaM grAmaM yAtaM, tatra pravishya yo naraM nAvahat taM garddabhashAvakaM drakShyathastaM mochayitvAnayataM| ");
INSERT INTO sanitr_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","kintu yuvAM karmmedaM kutaH kuruthaH? kathAmimAM yadi kopi pR^ichChati tarhi prabhoratra prayojanamastIti kathite sa shIghraM tamatra preShayiShyati| ");
INSERT INTO sanitr_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","tatastau gatvA dvimArgamelane kasyachid dvArasya pArshve taM garddabhashAvakaM prApya mochayataH, ");
INSERT INTO sanitr_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","etarhi tatropasthitalokAnAM kashchid apR^ichChat, garddabhashishuM kuto mochayathaH? ");
INSERT INTO sanitr_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","tadA yIshorAj nAnusAreNa tebhyaH pratyudite tatkShaNaM tamAdAtuM te.anujaj nuH| ");
INSERT INTO sanitr_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","atha tau yIshoH sannidhiM garddabhashishum AnIya tadupari svavastrANi pAtayAmAsatuH; tataH sa tadupari samupaviShTaH| ");
INSERT INTO sanitr_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","tadAneke pathi svavAsAMsi pAtayAmAsuH, paraishcha tarushAkhAshChitavA mArge vikIrNAH| ");
INSERT INTO sanitr_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","apara ncha pashchAdgAmino.agragAminashcha sarvve janA uchaiHsvareNa vaktumArebhire, jaya jaya yaH parameshvarasya nAmnAgachChati sa dhanya iti| ");
INSERT INTO sanitr_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","tathAsmAkamaM pUrvvapuruShasya dAyUdo yadrAjyaM parameshvaranAmnAyAti tadapi dhanyaM, sarvvasmAduchChrAye svarge Ishvarasya jayo bhavet| ");
INSERT INTO sanitr_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","itthaM yIshu ryirUshAlami mandiraM pravishya chaturdiksthAni sarvvANi vastUni dR^iShTavAn; atha sAyaMkAla upasthite dvAdashashiShyasahito baithaniyaM jagAma| ");
INSERT INTO sanitr_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","aparehani baithaniyAd Agamanasamaye kShudhArtto babhUva| ");
INSERT INTO sanitr_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","tato dUre sapatramuDumbarapAdapaM vilokya tatra ki nchit phalaM prAptuM tasya sannikR^iShTaM yayau, tadAnIM phalapAtanasya samayo nAgachChati| tatastatropasthitaH patrANi vinA kimapyaparaM na prApya sa kathitavAn, ");
INSERT INTO sanitr_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","adyArabhya kopi mAnavastvattaH phalaM na bhu njIta; imAM kathAM tasya shiShyAH shushruvuH| ");
INSERT INTO sanitr_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","tadanantaraM teShu yirUshAlamamAyAteShu yIshu rmandiraM gatvA tatrasthAnAM baNijAM mudrAsanAni pArAvatavikretR^iNAm AsanAni cha nyubjayA nchakAra sarvvAn kretR^in vikretR^iMshcha bahishchakAra| ");
INSERT INTO sanitr_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","aparaM mandiramadhyena kimapi pAtraM voDhuM sarvvajanaM nivArayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","lokAnupadishan jagAda, mama gR^ihaM sarvvajAtIyAnAM prArthanAgR^iham iti nAmnA prathitaM bhaviShyati etat kiM shAstre likhitaM nAsti? kintu yUyaM tadeva chorANAM gahvaraM kurutha| ");
INSERT INTO sanitr_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","imAM vANIM shrutvAdhyApakAH pradhAnayAjakAshcha taM yathA nAshayituM shaknuvanti tathoेpAyaM mR^igayAmAsuH, kintu tasyopadeshAt sarvve lokA vismayaM gatA ataste tasmAd bibhyuH| ");
INSERT INTO sanitr_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","atha sAyaMsamaya upasthite yIshurnagarAd bahirvavrAja| ");
INSERT INTO sanitr_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","anantaraM prAtaHkAle te tena mArgeNa gachChantastamuDumbaramahIruhaM samUlaM shuShkaM dadR^ishuH| ");
INSERT INTO sanitr_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","tataH pitaraH pUrvvavAkyaM smaran yIshuM babhAShaM, he guro pashyatu ya uDumbaraviTapI bhavatA shaptaH sa shuShko babhUva| ");
INSERT INTO sanitr_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","tato yIshuH pratyavAdIt, yUyamIshvare vishvasita| ");
INSERT INTO sanitr_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","yuShmAnahaM yathArthaM vadAmi kopi yadyetadgiriM vadati, tvamutthAya gatvA jaladhau pata, proktamidaM vAkyamavashyaM ghaTiShyate, manasA kimapi na sandihya chedidaM vishvaset tarhi tasya vAkyAnusAreNa tad ghaTiShyate| ");
INSERT INTO sanitr_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ato hetorahaM yuShmAn vachmi, prArthanAkAle yadyadAkAMkShiShyadhve tattadavashyaM prApsyatha, itthaM vishvasita, tataH prApsyatha| ");
INSERT INTO sanitr_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","apara ncha yuShmAsu prArthayituM samutthiteShu yadi kopi yuShmAkam aparAdhI tiShThati, tarhi taM kShamadhvaM, tathA kR^ite yuShmAkaM svargasthaH pitApi yuShmAkamAgAMmi kShamiShyate| ");
INSERT INTO sanitr_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","kintu yadi na kShamadhve tarhi vaH svargasthaH pitApi yuShmAkamAgAMsi na kShamiShyate| ");
INSERT INTO sanitr_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","anantaraM te puna ryirUshAlamaM pravivishuH, yIshu ryadA madhyemandiram itastato gachChati, tadAnIM pradhAnayAjakA upAdhyAyAH prA nchashcha tadantikametya kathAmimAM paprachChuH, ");
INSERT INTO sanitr_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","tvaM kenAdeshena karmmANyetAni karoShi? tathaitAni karmmANi karttAM kenAdiShTosi? ");
INSERT INTO sanitr_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","tato yIshuH pratigaditavAn ahamapi yuShmAn ekakathAM pR^ichChAmi, yadi yUyaM tasyA uttaraM kurutha, tarhi kayAj nayAhaM karmmANyetAni karomi tad yuShmabhyaM kathayiShyAmi| ");
INSERT INTO sanitr_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","yohano majjanam IshvarAt jAtaM kiM mAnavAt? tanmahyaM kathayata| ");
INSERT INTO sanitr_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","te parasparaM vivektuM prArebhire, tad IshvarAd babhUveti ched vadAmastarhi kutastaM na pratyaita? kathametAM kathayiShyati| ");
INSERT INTO sanitr_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","mAnavAd abhavaditi ched vadAmastarhi lokebhyo bhayamasti yato hetoH sarvve yohanaM satyaM bhaviShyadvAdinaM manyante| ");
INSERT INTO sanitr_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ataeva te yIshuM pratyavAdiShu rvayaM tad vaktuM na shaknumaH| yIshuruvAcha, tarhi yenAdeshena karmmANyetAni karomi, ahamapi yuShmabhyaM tanna kathayiShyAmi| ");
INSERT INTO sanitr_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","anantaraM yIshu rdR^iShTAntena tebhyaH kathayitumArebhe, kashchideko drAkShAkShetraM vidhAya tachchaturdikShu vAraNIM kR^itvA tanmadhye drAkShApeShaNakuNDam akhanat, tathA tasya gaDamapi nirmmitavAn tatastatkShetraM kR^iShIvaleShu samarpya dUradeshaM jagAma| ");
INSERT INTO sanitr_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","tadanantaraM phalakAle kR^iShIvalebhyo drAkShAkShetraphalAni prAptuM teShAM savidhe bhR^ityam ekaM prAhiNot| ");
INSERT INTO sanitr_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","kintu kR^iShIvalAstaM dhR^itvA prahR^itya riktahastaM visasR^ijuH| ");
INSERT INTO sanitr_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","tataH sa punaranyamekaM bhR^ityaM praShayAmAsa, kintu te kR^iShIvalAH pAShANAghAtaistasya shiro bha NktvA sApamAnaM taM vyasarjan| ");
INSERT INTO sanitr_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","tataH paraM soparaM dAsaM prAhiNot tadA te taM jaghnuH, evam anekeShAM kasyachit prahAraH kasyachid vadhashcha taiH kR^itaH| ");
INSERT INTO sanitr_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","tataH paraM mayA svaputre prahite te tamavashyaM sammaMsyante, ityuktvAvasheShe teShAM sannidhau nijapriyam advitIyaM putraM preShayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","kintu kR^iShIvalAH parasparaM jagaduH, eSha uttarAdhikArI, AgachChata vayamenaM hanmastathA kR^ite .adhikAroyam asmAkaM bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","tatastaM dhR^itvA hatvA drAkShAkShetrAd bahiH prAkShipan| ");
INSERT INTO sanitr_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","anenAsau drAkShAkShetrapatiH kiM kariShyati? sa etya tAn kR^iShIvalAn saMhatya tatkShetram anyeShu kR^iShIvaleShu samarpayiShyati| ");
INSERT INTO sanitr_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","apara ncha, \"sthapatayaH kariShyanti grAvANaM yantu tuchChakaM| prAdhAnaprastaraH koNe sa eva saMbhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","etat karmma pareshasyAMdbhutaM no dR^iShTito bhavet||\" imAM shAstrIyAM lipiM yUyaM kiM nApAThiShTa? ");
INSERT INTO sanitr_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","tadAnIM sa tAnuddishya tAM dR^iShTAntakathAM kathitavAn, ta itthaM budvvA taM dharttAmudyatAH, kintu lokebhyo bibhyuH, tadanantaraM te taM vihAya vavrajuH| ");
INSERT INTO sanitr_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","apara ncha te tasya vAkyadoShaM dharttAM katipayAn phirUshino herodIyAMshcha lokAn tadantikaM preShayAmAsuH| ");
INSERT INTO sanitr_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ta Agatya tamavadan, he guro bhavAn tathyabhAShI kasyApyanurodhaM na manyate, pakShapAta ncha na karoti, yathArthata IshvarIyaM mArgaM darshayati vayametat prajAnImaH, kaisarAya karo deyo na vAM? vayaM dAsyAmo na vA? ");
INSERT INTO sanitr_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","kintu sa teShAM kapaTaM j nAtvA jagAda, kuto mAM parIkShadhve? ekaM mudrApAdaM samAnIya mAM darshayata| ");
INSERT INTO sanitr_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","tadA tairekasmin mudrApAde samAnIte sa tAn paprachCha, atra likhitaM nAma mUrtti rvA kasya? te pratyUchuH, kaisarasya| ");
INSERT INTO sanitr_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","tadA yIshuravadat tarhi kaisarasya dravyANi kaisarAya datta, Ishvarasya dravyANi tu IshvarAya datta; tataste vismayaM menire| ");
INSERT INTO sanitr_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","atha mR^itAnAmutthAnaM ye na manyante te sidUkino yIshoH samIpamAgatya taM paprachChuH; ");
INSERT INTO sanitr_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","he guro kashchijjano yadi niHsantatiH san bhAryyAyAM satyAM mriyate tarhi tasya bhrAtA tasya bhAryyAM gR^ihItvA bhrAtu rvaMshotpattiM kariShyati, vyavasthAmimAM mUsA asmAn prati vyalikhat| ");
INSERT INTO sanitr_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","kintu kechit sapta bhrAtara Asan, tatasteShAM jyeShThabhrAtA vivahya niHsantatiH san amriyata| ");
INSERT INTO sanitr_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","tato dvitIyo bhrAtA tAM striyamagR^ihaNat kintu sopi niHsantatiH san amriyata; atha tR^itIyopi bhrAtA tAdR^ishobhavat| ");
INSERT INTO sanitr_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","itthaM saptaiva bhrAtarastAM striyaM gR^ihItvA niHsantAnAH santo.amriyanta, sarvvasheShe sApi strI mriyate sma| ");
INSERT INTO sanitr_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","atha mR^itAnAmutthAnakAle yadA ta utthAsyanti tadA teShAM kasya bhAryyA sA bhaviShyati? yataste saptaiva tAM vyavahan| ");
INSERT INTO sanitr_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","tato yIshuH pratyuvAcha shAstram Ishvarashakti ncha yUyamaj nAtvA kimabhrAmyata na? ");
INSERT INTO sanitr_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","mR^italokAnAmutthAnaM sati te na vivahanti vAgdattA api na bhavanti, kintu svargIyadUtAnAM sadR^ishA bhavanti| ");
INSERT INTO sanitr_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","punashcha \"aham ibrAhIma Ishvara ishAka Ishvaro yAkUbashcheshvaraH\" yAmimAM kathAM stambamadhye tiShThan Ishvaro mUsAmavAdIt mR^itAnAmutthAnArthe sA kathA mUsAlikhite pustake kiM yuShmAbhi rnApAThi? ");
INSERT INTO sanitr_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ishvaro jIvatAM prabhuH kintu mR^itAnAM prabhu rna bhavati, tasmAddheto ryUyaM mahAbhrameNa tiShThatha| ");
INSERT INTO sanitr_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","etarhi ekodhyApaka etya teShAmitthaM vichAraM shushrAva; yIshusteShAM vAkyasya saduttaraM dattavAn iti budvvA taM pR^iShTavAn sarvvAsAm Aj nAnAM kA shreShThA? tato yIshuH pratyuvAcha, ");
INSERT INTO sanitr_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","\"he isrAyellokA avadhatta, asmAkaM prabhuH parameshvara eka eva, ");
INSERT INTO sanitr_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","yUyaM sarvvantaHkaraNaiH sarvvaprANaiH sarvvachittaiH sarvvashaktibhishcha tasmin prabhau parameshvare prIyadhvaM,\" ityAj nA shreShThA| ");
INSERT INTO sanitr_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","tathA \"svaprativAsini svavat prema kurudhvaM,\" eShA yA dvitIyAj nA sA tAdR^ishI; etAbhyAM dvAbhyAm Aj nAbhyAm anyA kApyAj nA shreShThA nAsti| ");
INSERT INTO sanitr_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","tadA sodhyApakastamavadat, he guro satyaM bhavAn yathArthaM proktavAn yata ekasmAd IshvarAd anyo dvitIya Ishvaro nAsti; ");
INSERT INTO sanitr_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","aparaM sarvvAntaHkaraNaiH sarvvaprANaiH sarvvachittaiH sarvvashaktibhishcha Ishvare premakaraNaM tathA svamIpavAsini svavat premakaraNa ncha sarvvebhyo homabalidAnAdibhyaH shraShThaM bhavati| ");
INSERT INTO sanitr_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","tato yIshuH subuddheriva tasyedam uttaraM shrutvA taM bhAShitavAn tvamIshvarasya rAjyAnna dUrosi|itaH paraM tena saha kasyApi vAkyasya vichAraM karttAM kasyApi pragalbhatA na jAtA| ");
INSERT INTO sanitr_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","anantaraM madhyemandiram upadishan yIshurimaM prashnaM chakAra, adhyApakA abhiShiktaM (tArakaM) kuto dAyUdaH santAnaM vadanti? ");
INSERT INTO sanitr_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","svayaM dAyUd pavitrasyAtmana AveshenedaM kathayAmAsa| yathA| \"mama prabhumidaM vAkyavadat parameshvaraH| tava shatrUnahaM yAvat pAdapIThaM karomi na| tAvat kAlaM madIye tvaM dakShapArshv upAvisha|\" ");
INSERT INTO sanitr_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","yadi dAyUd taM prabhUM vadati tarhi kathaM sa tasya santAno bhavitumarhati? itare lokAstatkathAM shrutvAnananduH| ");
INSERT INTO sanitr_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","tadAnIM sa tAnupadishya kathitavAn ye narA dIrghaparidheyAni haTTe vipanau cha ");
INSERT INTO sanitr_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","lokakR^itanamaskArAn bhajanagR^ihe pradhAnAsanAni bhojanakAle pradhAnasthAnAni cha kA NkShante; ");
INSERT INTO sanitr_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","vidhavAnAM sarvvasvaM grasitvA ChalAd dIrghakAlaM prArthayante tebhya upAdhyAyebhyaH sAvadhAnA bhavata; te.adhikatarAn daNDAn prApsyanti| ");
INSERT INTO sanitr_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","tadanantaraM lokA bhANDAgAre mudrA yathA nikShipanti bhANDAgArasya sammukhe samupavishya yIshustadavaluloka; tadAnIM bahavo dhaninastasya madhye bahUni dhanAni nirakShipan| ");
INSERT INTO sanitr_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","pashchAd ekA daridrA vidhavA samAgatya dvipaNamUlyAM mudraikAM tatra nirakShipat| ");
INSERT INTO sanitr_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","tadA yIshuH shiShyAn AhUya kathitavAn yuShmAnahaM yathArthaM vadAmi ye ye bhANDAgAre.asmina dhanAni niHkShipanti sma tebhyaH sarvvebhya iyaM vidhavA daridrAdhikam niHkShipati sma| ");
INSERT INTO sanitr_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","yataste prabhUtadhanasya ki nchit nirakShipan kintu dIneyaM svadinayApanayogyaM ki nchidapi na sthApayitvA sarvvasvaM nirakShipat| ");
INSERT INTO sanitr_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","anantaraM mandirAd bahirgamanakAle tasya shiShyANAmekastaM vyAhR^itavAn he guro pashyatu kIdR^ishAH pAShANAH kIdR^ik cha nichayanaM| ");
INSERT INTO sanitr_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","tadA yIshustam avadat tvaM kimetad bR^ihannichayanaM pashyasi? asyaikapAShANopi dvitIyapAShANopari na sthAsyati sarvve .adhaHkShepsyante| ");
INSERT INTO sanitr_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","atha yasmin kAle jaitungirau mandirasya sammukhe sa samupaviShTastasmin kAle pitaro yAkUb yohan Andriyashchaite taM rahasi paprachChuH, ");
INSERT INTO sanitr_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","etA ghaTanAH kadA bhaviShyanti? tathaitatsarvvAsAM siddhyupakramasya vA kiM chihnaM? tadasmabhyaM kathayatu bhavAn| ");
INSERT INTO sanitr_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","tato yAshustAn vaktumArebhe, kopi yathA yuShmAn na bhrAmayati tathAtra yUyaM sAvadhAnA bhavata| ");
INSERT INTO sanitr_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","yataH khrIShTohamiti kathayitvA mama nAmnAneke samAgatya lokAnAM bhramaM janayiShyanti; ");
INSERT INTO sanitr_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","kintu yUyaM raNasya vArttAM raNADambara ncha shrutvA mA vyAkulA bhavata, ghaTanA etA avashyammAvinyaH; kintvApAtato na yugAnto bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","deshasya vipakShatayA desho rAjyasya vipakShatayA cha rAjyamutthAsyati, tathA sthAne sthAne bhUmikampo durbhikShaM mahAkleshAshcha samupasthAsyanti, sarvva ete duHkhasyArambhAH| ");
INSERT INTO sanitr_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","kintu yUyam AtmArthe sAvadhAnAstiShThata, yato lokA rAjasabhAyAM yuShmAn samarpayiShyanti, tathA bhajanagR^ihe prahariShyanti; yUyaM madarthe deshAdhipAn bhUpAMshcha prati sAkShyadAnAya teShAM sammukhe upasthApayiShyadhve| ");
INSERT INTO sanitr_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","sheShIbhavanAt pUrvvaM sarvvAn deshIyAn prati susaMvAdaH prachArayiShyate| ");
INSERT INTO sanitr_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","kintu yadA te yuShmAn dhR^itvA samarpayiShyanti tadA yUyaM yadyad uttaraM dAsyatha, tadagra tasya vivechanaM mA kuruta tadarthaM ki nchidapi mA chintayata cha, tadAnIM yuShmAkaM manaHsu yadyad vAkyam upasthApayiShyate tadeva vadiShyatha, yato yUyaM na tadvaktAraH kintu pavitra AtmA tasya vaktA| ");
INSERT INTO sanitr_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","tadA bhrAtA bhrAtaraM pitA putraM ghAtanArthaM parahasteShu samarpayiShyate, tathA patyAni mAtApitro rvipakShatayA tau ghAtayiShyanti| ");
INSERT INTO sanitr_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","mama nAmahetoH sarvveShAM savidhe yUyaM jugupsitA bhaviShyatha, kintu yaH kashchit sheShaparyyantaM dhairyyam AlambiShyate saeva paritrAsyate| ");
INSERT INTO sanitr_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","dAniyelbhaviShyadvAdinA proktaM sarvvanAshi jugupsita ncha vastu yadA tvayogyasthAne vidyamAnaM drakShatha (yo janaH paThati sa budhyatAM) tadA ye yihUdIyadeshe tiShThanti te mahIdhraM prati palAyantAM; ");
INSERT INTO sanitr_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","tathA yo naro gR^ihopari tiShThati sa gR^ihamadhyaM nAvarohatu, tathA kimapi vastu grahItuM madhyegR^ihaM na pravishatu; ");
INSERT INTO sanitr_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","tathA cha yo naraH kShetre tiShThati sopi svavastraM grahItuM parAvR^itya na vrajatu| ");
INSERT INTO sanitr_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","tadAnIM garbbhavatInAM stanyadAtrINA ncha yoShitAM durgati rbhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","yuShmAkaM palAyanaM shItakAle yathA na bhavati tadarthaM prArthayadhvaM| ");
INSERT INTO sanitr_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","yatastadA yAdR^ishI durghaTanA ghaTiShyate tAdR^ishI durghaTanA IshvarasR^iShTeH prathamamArabhyAdya yAvat kadApi na jAtA na janiShyate cha| ");
INSERT INTO sanitr_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","apara ncha parameshvaro yadi tasya samayasya saMkShepaM na karoti tarhi kasyApi prANabhR^ito rakShA bhavituM na shakShyati, kintu yAn janAn manonItAn akarot teShAM svamanonItAnAM hetoH sa tadanehasaM saMkShepsyati| ");
INSERT INTO sanitr_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","anyachcha pashyata khrIShTotra sthAne vA tatra sthAne vidyate, tasminkAle yadi kashchid yuShmAn etAdR^ishaM vAkyaM vyAharati, tarhi tasmin vAkye bhaiva vishvasita| ");
INSERT INTO sanitr_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","yatoneke mithyAkhrIShTA mithyAbhaviShyadvAdinashcha samupasthAya bahUni chihnAnyadbhutAni karmmANi cha darshayiShyanti; tathA yadi sambhavati tarhi manonItalokAnAmapi mithyAmatiM janayiShyanti| ");
INSERT INTO sanitr_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","pashyata ghaTanAtaH pUrvvaM sarvvakAryyasya vArttAM yuShmabhyamadAm, yUyaM sAvadhAnAstiShThata| ");
INSERT INTO sanitr_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","apara ncha tasya kleshakAlasyAvyavahite parakAle bhAskaraH sAndhakAro bhaviShyati tathaiva chandrashchandrikAM na dAsyati| ");
INSERT INTO sanitr_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","nabhaHsthAni nakShatrANi patiShyanti, vyomamaNDalasthA grahAshcha vichaliShyanti| ");
INSERT INTO sanitr_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","tadAnIM mahAparAkrameNa mahaishvaryyeNa cha meghamAruhya samAyAntaM mAnavasutaM mAnavAH samIkShiShyante| ");
INSERT INTO sanitr_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","anyachcha sa nijadUtAn prahitya nabhobhUmyoH sImAM yAvad jagatashchaturdigbhyaH svamanonItalokAn saMgrahIShyati| ");
INSERT INTO sanitr_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","uDumbarataro rdR^iShTAntaM shikShadhvaM yadoDumbarasya taro rnavInAH shAkhA jAyante pallavAdIni cha rnigachChanti, tadA nidAghakAlaH savidho bhavatIti yUyaM j nAtuM shaknutha| ");
INSERT INTO sanitr_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","tadvad etA ghaTanA dR^iShTvA sa kAlo dvAryyupasthita iti jAnIta| ");
INSERT INTO sanitr_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","yuShmAnahaM yathArthaM vadAmi, AdhunikalokAnAM gamanAt pUrvvaM tAni sarvvANi ghaTiShyante| ");
INSERT INTO sanitr_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","dyAvApR^ithivyo rvichalitayoH satyo rmadIyA vANI na vichaliShyati| ");
INSERT INTO sanitr_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","apara ncha svargasthadUtagaNo vA putro vA tAtAdanyaH kopi taM divasaM taM daNDaM vA na j nApayati| ");
INSERT INTO sanitr_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ataH sa samayaH kadA bhaviShyati, etajj nAnAbhAvAd yUyaM sAvadhAnAstiShThata, satarkAshcha bhUtvA prArthayadhvaM; ");
INSERT INTO sanitr_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","yadvat kashchit pumAn svaniveshanAd dUradeshaM prati yAtrAkaraNakAle dAseShu svakAryyasya bhAramarpayitvA sarvvAn sve sve karmmaNi niyojayati; aparaM dauvArikaM jAgarituM samAdishya yAti, tadvan naraputraH| ");
INSERT INTO sanitr_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","gR^ihapatiH sAyaMkAle nishIthe vA tR^itIyayAme vA prAtaHkAle vA kadAgamiShyati tad yUyaM na jAnItha; ");
INSERT INTO sanitr_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","sa haThAdAgatya yathA yuShmAn nidritAn na pashyati, tadarthaM jAgaritAstiShThata| ");
INSERT INTO sanitr_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","yuShmAnahaM yad vadAmi tadeva sarvvAn vadAmi, jAgaritAstiShThateti| ");
INSERT INTO sanitr_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","tadA nistArotsavakiNvahInapUpotsavayorArambhasya dinadvaye .avashiShTe pradhAnayAjakA adhyApakAshcha kenApi Chalena yIshuM dharttAM hantu ncha mR^igayA nchakrire; ");
INSERT INTO sanitr_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","kintu lokAnAM kalahabhayAdUchire, nachotsavakAla uchitametaditi| ");
INSERT INTO sanitr_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","anantaraM baithaniyApuुre shimonakuShThino gR^ihe yoshau bhotkumupaviShTe sati kAchid yoShit pANDarapAShANasya sampuTakena mahArghyottamatailam AnIya sampuTakaM bhaMktvA tasyottamA Nge tailadhArAM pAtayA nchakre| ");
INSERT INTO sanitr_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","tasmAt kechit svAnte kupyantaH kathitavaMntaH kutoyaM tailApavyayaH? ");
INSERT INTO sanitr_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","yadyetat taila vyakreShyata tarhi mudrApAdashatatrayAdapyadhikaM tasya prAptamUlyaM daridralokebhyo dAtumashakShyata, kathAmetAM kathayitvA tayA yoShitA sAkaM vAchAyuhyan| ");
INSERT INTO sanitr_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","kintu yIshuruvAcha, kuta etasyai kR^ichChraM dadAsi? mahyamiyaM karmmottamaM kR^itavatI| ");
INSERT INTO sanitr_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","daridrAH sarvvadA yuShmAbhiH saha tiShThanti, tasmAd yUyaM yadechChatha tadaiva tAnupakarttAM shaknutha, kintvahaM yubhAbhiH saha nirantaraM na tiShThAmi| ");
INSERT INTO sanitr_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","asyA yathAsAdhyaM tathaivAkarodiyaM, shmashAnayApanAt pUrvvaM sametya madvapuShi tailam amarddayat| ");
INSERT INTO sanitr_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","ahaM yuShmabhyaM yathArthaM kathayAmi, jagatAM madhye yatra yatra susaMvAdoyaM prachArayiShyate tatra tatra yoShita etasyAH smaraNArthaM tatkR^itakarmmaitat prachArayiShyate| ");
INSERT INTO sanitr_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","tataH paraM dvAdashAnAM shiShyANAmeka IShkariyotIyayihUdAkhyo yIshuM parakareShu samarpayituM pradhAnayAjakAnAM samIpamiyAya| ");
INSERT INTO sanitr_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","te tasya vAkyaM samAkarNya santuShTAH santastasmai mudrA dAtuM pratyajAnata; tasmAt sa taM teShAM kareShu samarpaNAyopAyaM mR^igayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","anantaraM kiNvashUnyapUpotsavasya prathame.ahani nistArotmavArthaM meShamAraNAsamaye shiShyAstaM paprachChaH kutra gatvA vayaM nistArotsavasya bhojyamAsAdayiShyAmaH? kimichChati bhavAn? ");
INSERT INTO sanitr_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","tadAnIM sa teShAM dvayaM prerayan babhAShe yuvayoH puramadhyaM gatayoH sato ryo janaH sajalakumbhaM vahan yuvAM sAkShAt kariShyati tasyaiva pashchAd yAtaM; ");
INSERT INTO sanitr_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","sa yat sadanaM pravekShyati tadbhavanapatiM vadataM, gururAha yatra sashiShyohaM nistArotsavIyaM bhojanaM kariShyAmi, sA bhojanashAlA kutrAsti? ");
INSERT INTO sanitr_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","tataH sa pariShkR^itAM susajjitAM bR^ihatIcha ncha yAM shAlAM darshayiShyati tasyAmasmadarthaM bhojyadravyANyAsAdayataM| ");
INSERT INTO sanitr_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","tataH shiShyau prasthAya puraM pravishya sa yathoktavAn tathaiva prApya nistArotsavasya bhojyadravyANi samAsAdayetAm| ");
INSERT INTO sanitr_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","anantaraM yIshuH sAyaMkAle dvAdashabhiH shiShyaiH sArddhaM jagAma; ");
INSERT INTO sanitr_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","sarvveShu bhojanAya propaviShTeShu sa tAnuditavAn yuShmAnahaM yathArthaM vyAharAmi, atra yuShmAkameko jano yo mayA saha bhuMkte mAM parakereShu samarpayiShyate| ");
INSERT INTO sanitr_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","tadAnIM te duHkhitAH santa ekaikashastaM praShTumArabdhavantaH sa kimahaM? pashchAd anya ekobhidadhe sa kimahaM? ");
INSERT INTO sanitr_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","tataH sa pratyavadad eteShAM dvAdashAnAM yo jano mayA samaM bhojanApAtre pANiM majjayiShyati sa eva| ");
INSERT INTO sanitr_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","manujatanayamadhi yAdR^ishaM likhitamAste tadanurUpA gatistasya bhaviShyati, kintu yo jano mAnavasutaM samarpayiShyate hanta tasya janmAbhAve sati bhadramabhaviShyat| ");
INSERT INTO sanitr_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","apara ncha teShAM bhojanasamaye yIshuH pUpaM gR^ihItveshvaraguNAn anukIrtya bha NktvA tebhyo dattvA babhAShe, etad gR^ihItvA bhu njIdhvam etanmama vigraharUpaM| ");
INSERT INTO sanitr_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","anantaraM sa kaMsaM gR^ihItveshvarasya guNAn kIrttayitvA tebhyo dadau, tataste sarvve papuH| ");
INSERT INTO sanitr_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","aparaM sa tAnavAdId bahUnAM nimittaM pAtitaM mama navInaniyamarUpaM shoNitametat| ");
INSERT INTO sanitr_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","yuShmAnahaM yathArthaM vadAmi, Ishvarasya rAjye yAvat sadyojAtaM drAkShArasaM na pAsyAmi,tAvadahaM drAkShAphalarasaM puna rna pAsyAmi| ");
INSERT INTO sanitr_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","tadanantaraM te gItamekaM saMgIya bahi rjaitunaM shikhariNaM yayuH ");
INSERT INTO sanitr_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","atha yIshustAnuvAcha nishAyAmasyAM mayi yuShmAkaM sarvveShAM pratyUho bhaviShyati yato likhitamAste yathA, meShANAM rakShaka nchAhaM prahariShyAmi vai tataH| meShANAM nivaho nUnaM pravikIrNo bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","kantu madutthAne jAte yuShmAkamagre.ahaM gAlIlaM vrajiShyAmi| ");
INSERT INTO sanitr_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","tadA pitaraH pratibabhAShe, yadyapi sarvveShAM pratyUho bhavati tathApi mama naiva bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","tato yIshuruktAvAn ahaM tubhyaM tathyaM kathayAmi, kShaNAdAyAmadya kukkuTasya dvitIyavAraravaNAt pUrvvaM tvaM vAratrayaM mAmapahnoShyase| ");
INSERT INTO sanitr_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","kintu sa gADhaM vyAharad yadyapi tvayA sArddhaM mama prANo yAti tathApi kathamapi tvAM nApahnoShye; sarvve.apItare tathaiva babhAShire| ");
INSERT INTO sanitr_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","apara ncha teShu getshimAnInAmakaM sthAna gateShu sa shiShyAn jagAda, yAvadahaM prArthaye tAvadatra sthAne yUyaM samupavishata| ");
INSERT INTO sanitr_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","atha sa pitaraM yAkUbaM yohana ncha gR^ihItvA vavrAja; atyantaM trAsito vyAkulitashcha tebhyaH kathayAmAsa, ");
INSERT INTO sanitr_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","nidhanakAlavat prANo me.atIva daHkhameti, yUyaM jAgratotra sthAne tiShThata| ");
INSERT INTO sanitr_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","tataH sa ki nchiddUraM gatvA bhUmAvadhomukhaH patitvA prArthitavAnetat, yadi bhavituM shakyaM tarhi duHkhasamayoyaM matto dUrIbhavatu| ");
INSERT INTO sanitr_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","aparamuditavAn he pita rhe pitaH sarvveM tvayA sAdhyaM, tato hetorimaM kaMsaM matto dUrIkuru, kintu tan mamechChAto na tavechChAto bhavatu| ");
INSERT INTO sanitr_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","tataH paraM sa etya tAn nidritAn nirIkShya pitaraM provAcha, shimon tvaM kiM nidrAsi? ghaTikAmekAm api jAgarituM na shaknoShi? ");
INSERT INTO sanitr_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","parIkShAyAM yathA na patatha tadarthaM sachetanAH santaH prArthayadhvaM; mana udyuktamiti satyaM kintu vapurashaktikaM| ");
INSERT INTO sanitr_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","atha sa punarvrajitvA pUrvvavat prArthayA nchakre| ");
INSERT INTO sanitr_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","parAvR^ityAgatya punarapi tAn nidritAn dadarsha tadA teShAM lochanAni nidrayA pUrNAni, tasmAttasmai kA kathA kathayitavyA ta etad boddhuM na shekuH| ");
INSERT INTO sanitr_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","tataHparaM tR^itIyavAraM Agatya tebhyo .akathayad idAnImapi shayitvA vishrAmyatha? yatheShTaM jAtaM, samayashchopasthitaH pashyata mAnavatanayaH pApilokAnAM pANiShu samarpyate| ");
INSERT INTO sanitr_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","uttiShThata, vayaM vrajAmo yo jano mAM parapANiShu samarpayiShyate pashyata sa samIpamAyAtaH| ");
INSERT INTO sanitr_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","imAM kathAM kathayati sa, etarhidvAdashAnAmeko yihUdA nAmA shiShyaH pradhAnayAjakAnAm upAdhyAyAnAM prAchInalokAnA ncha sannidheH kha NgalaguDadhAriNo bahulokAn gR^ihItvA tasya samIpa upasthitavAn| ");
INSERT INTO sanitr_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","apara nchAsau parapANiShu samarpayitA pUrvvamiti sa NketaM kR^itavAn yamahaM chumbiShyAmi sa evAsau tameva dhR^itvA sAvadhAnaM nayata| ");
INSERT INTO sanitr_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ato hetoH sa Agatyaiva yoshoH savidhaM gatvA he guro he guro, ityuktvA taM chuchumba| ");
INSERT INTO sanitr_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","tadA te tadupari pANInarpayitvA taM dadhnuH| ");
INSERT INTO sanitr_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","tatastasya pArshvasthAnAM lokAnAmekaH kha NgaM niShkoShayan mahAyAjakasya dAsamekaM prahR^itya tasya karNaM chichCheda| ");
INSERT INTO sanitr_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","pashchAd yIshustAn vyAjahAra kha NgAn laguDAMshcha gR^ihItvA mAM kiM chauraM dharttAM samAyAtAH? ");
INSERT INTO sanitr_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","madhyemandiraM samupadishan pratyahaM yuShmAbhiH saha sthitavAnatahaM, tasmin kAle yUyaM mAM nAdIdharata, kintvanena shAstrIyaM vachanaM sedhanIyaM| ");
INSERT INTO sanitr_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","tadA sarvve shiShyAstaM parityajya palAyA nchakrire| ");
INSERT INTO sanitr_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","athaiko yuvA mAnavo nagnakAye vastramekaM nidhAya tasya pashchAd vrajan yuvalokai rdhR^ito ");
INSERT INTO sanitr_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","vastraM vihAya nagnaH palAyA nchakre| ");
INSERT INTO sanitr_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","apara ncha yasmin sthAne pradhAnayAjakA upAdhyAyAH prAchInalokAshcha mahAyAjakena saha sadasi sthitAstasmin sthAne mahAyAjakasya samIpaM yIshuM ninyuH| ");
INSERT INTO sanitr_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","pitaro dUre tatpashchAd itvA mahAyAjakasyATTAlikAM pravishya ki NkaraiH sahopavishya vahnitApaM jagrAha| ");
INSERT INTO sanitr_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","tadAnIM pradhAnayAjakA mantriNashcha yIshuM ghAtayituM tatprAtikUlyena sAkShiNo mR^igayA nchakrire, kintu na prAptAH| ");
INSERT INTO sanitr_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","anekaistadviruddhaM mR^iShAsAkShye dattepi teShAM vAkyAni na samagachChanta| ");
INSERT INTO sanitr_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","sarvvasheShe kiyanta utthAya tasya prAtikUlyena mR^iShAsAkShyaM dattvA kathayAmAsuH, ");
INSERT INTO sanitr_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","idaM karakR^itamandiraM vinAshya dinatrayamadhye punaraparam akarakR^itaM mandiraM nirmmAsyAmi, iti vAkyam asya mukhAt shrutamasmAbhiriti| ");
INSERT INTO sanitr_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","kintu tatrApi teShAM sAkShyakathA na sa NgAtAH| ");
INSERT INTO sanitr_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","atha mahAyAjako madhyesabham utthAya yIshuM vyAjahAra, ete janAstvayi yat sAkShyamaduH tvametasya kimapyuttaraM kiM na dAsyasi? ");
INSERT INTO sanitr_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","kintu sa kimapyuttaraM na datvA maunIbhUya tasyau; tato mahAyAjakaH punarapi taM pR^iShTAvAn tvaM sachchidAnandasya tanayo .abhiShiktastratA? ");
INSERT INTO sanitr_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","tadA yIshustaM provAcha bhavAmyaham yUya ncha sarvvashaktimato dakShINapArshve samupavishantaM megha mAruhya samAyAnta ncha manuShyaputraM sandrakShyatha| ");
INSERT INTO sanitr_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","tadA mahAyAjakaH svaM vamanaM ChitvA vyAvaharat ");
INSERT INTO sanitr_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","kimasmAkaM sAkShibhiH prayojanam? IshvaranindAvAkyaM yuShmAbhirashrAvi kiM vichArayatha? tadAnIM sarvve jagadurayaM nidhanadaNDamarhati| ");
INSERT INTO sanitr_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","tataH kashchit kashchit tadvapuShi niShThIvaM nichikShepa tathA tanmukhamAchChAdya chapeTena hatvA gaditavAn gaNayitvA vada, anucharAshcha chapeTaistamAjaghnuH ");
INSERT INTO sanitr_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","tataH paraM pitare.aTTAlikAdhaHkoShThe tiShThati mahAyAjakasyaikA dAsI sametya ");
INSERT INTO sanitr_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","taM vihnitApaM gR^ihlantaM vilokya taM sunirIkShya babhAShe tvamapi nAsaratIyayIshoH sa NginAm eko jana AsIH| ");
INSERT INTO sanitr_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","kintu sopahnutya jagAda tamahaM na vadmi tvaM yat kathayami tadapyahaM na buddhye| tadAnIM pitare chatvaraM gatavati kuेkkuTo rurAva| ");
INSERT INTO sanitr_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","athAnyA dAsI pitaraM dR^iShTvA samIpasthAn janAn jagAda ayaM teShAmeko janaH| ");
INSERT INTO sanitr_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","tataH sa dvitIyavAram apahnutavAn pashchAt tatrasthA lokAH pitaraM prochustvamavashyaM teShAmeko janaH yatastvaM gAlIlIyo nara iti tavochchAraNaM prakAshayati| ");
INSERT INTO sanitr_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","tadA sa shapathAbhishApau kR^itvA provAcha yUyaM kathAM kathayatha taM naraM na jAne.ahaM| ");
INSERT INTO sanitr_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","tadAnIM dvitIyavAraM kukkuTo .arAvIt| kukkuTasya dvitIyaravAt pUrvvaM tvaM mAM vAratrayam apahnoShyasi, iti yadvAkyaM yIshunA samuditaM tat tadA saMsmR^itya pitaro roditum Arabhata| ");
INSERT INTO sanitr_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","atha prabhAte sati pradhAnayAjakAH prA ncha upAdhyAyAH sarvve mantriNashcha sabhAM kR^itvA yIshuृM bandhayitva pIlAtAkhyasya deshAdhipateH savidhaM nItvA samarpayAmAsuH| ");
INSERT INTO sanitr_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","tadA pIlAtastaM pR^iShTavAn tvaM kiM yihUdIyalokAnAM rAjA? tataH sa pratyuktavAn satyaM vadasi| ");
INSERT INTO sanitr_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","aparaM pradhAnayAjakAstasya bahuShu vAkyeShu doShamAropayA nchakruH kintu sa kimapi na pratyuvAcha| ");
INSERT INTO sanitr_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","tadAnIM pIlAtastaM punaH paprachCha tvaM kiM nottarayasi? pashyaite tvadviruddhaM katiShu sAdhyeShu sAkShaM dadati| ");
INSERT INTO sanitr_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","kantu yIshustadApi nottaraM dadau tataH pIlAta AshcharyyaM jagAma| ");
INSERT INTO sanitr_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","apara ncha kArAbaddhe kastiMshchit jane tanmahotsavakAle lokai ryAchite deshAdhipatistaM mochayati| ");
INSERT INTO sanitr_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ye cha pUrvvamupaplavamakArShurupaplave vadhamapi kR^itavantasteShAM madhye tadAnoM barabbAnAmaka eko baddha AsIt| ");
INSERT INTO sanitr_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ato hetoH pUrvvAparIyAM rItikathAM kathayitvA lokA uchchairuvantaH pIlAtasya samakShaM nivedayAmAsuH| ");
INSERT INTO sanitr_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","tadA pIlAtastAnAchakhyau tarhi kiM yihUdIyAnAM rAjAnaM mochayiShyAmi? yuShmAbhiH kimiShyate? ");
INSERT INTO sanitr_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","yataH pradhAnayAjakA IrShyAta eva yIshuM samArpayanniti sa viveda| ");
INSERT INTO sanitr_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","kintu yathA barabbAM mochayati tathA prArthayituM pradhAnayAjakA lokAn pravarttayAmAsuH| ");
INSERT INTO sanitr_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","atha pIlAtaH punaH pR^iShTavAn tarhi yaM yihUdIyAnAM rAjeti vadatha tasya kiM kariShyAmi yuShmAbhiH kimiShyate? ");
INSERT INTO sanitr_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","tadA te punarapi prochchaiH prochustaM krushe vedhaya| ");
INSERT INTO sanitr_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","tasmAt pIlAtaH kathitavAn kutaH? sa kiM kukarmma kR^itavAn? kintu te punashcha ruvanto vyAjahrustaM krushe vedhaya| ");
INSERT INTO sanitr_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","tadA pIlAtaH sarvvAllokAn toShayitumichChan barabbAM mochayitvA yIshuM kashAbhiH prahR^itya krushe veddhuM taM samarpayAmbabhUva| ");
INSERT INTO sanitr_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","anantaraM sainyagaNo.aTTAlikAm arthAd adhipate rgR^ihaM yIshuM nItvA senAnivahaM samAhuyat| ");
INSERT INTO sanitr_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","pashchAt te taM dhUmalavarNavastraM paridhApya kaNTakamukuTaM rachayitvA shirasi samAropya ");
INSERT INTO sanitr_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","he yihUdIyAnAM rAjan namaskAra ityuktvA taM namaskarttAmArebhire| ");
INSERT INTO sanitr_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","tasyottamA Nge vetrAghAtaM chakrustadgAtre niShThIva ncha nichikShipuH, tathA tasya sammukhe jAnupAtaM praNomuH ");
INSERT INTO sanitr_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","itthamupahasya dhUmravarNavastram uttAryya tasya vastraM taM paryyadhApayan krushe veddhuM bahirninyushcha| ");
INSERT INTO sanitr_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","tataH paraM sekandarasya ruphasya cha pitA shimonnAmA kurINIyaloka ekaH kutashchid grAmAdetya pathi yAti taM te yIshoH krushaM voDhuM balAd dadhnuH| ");
INSERT INTO sanitr_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","atha gulgaltA arthAt shiraHkapAlanAmakaM sthAnaM yIshumAnIya ");
INSERT INTO sanitr_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","te gandharasamishritaM drAkShArasaM pAtuM tasmai daduH kintu sa na jagrAha| ");
INSERT INTO sanitr_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","tasmin krushe viddhe sati teShAmekaikashaH kiM prApsyatIti nirNayAya ");
INSERT INTO sanitr_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","tasya paridheyAnAM vibhAgArthaM guTikApAtaM chakruH| ");
INSERT INTO sanitr_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","aparam eSha yihUdIyAnAM rAjeti likhitaM doShapatraM tasya shiraUrdvvam AropayA nchakruH| ");
INSERT INTO sanitr_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","tasya vAmadakShiNayo rdvau chaurau krushayo rvividhAte| ");
INSERT INTO sanitr_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","tenaiva \"aparAdhijanaiH sArddhaM sa gaNito bhaviShyati,\" iti shAstroktaM vachanaM siddhamabhUta| ");
INSERT INTO sanitr_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","anantaraM mArge ye ye lokA gamanAgamane chakruste sarvva eva shirAMsyAndolya nindanto jagaduH, re mandiranAshaka re dinatrayamadhye tannirmmAyaka, ");
INSERT INTO sanitr_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","adhunAtmAnam avitvA krushAdavaroha| ");
INSERT INTO sanitr_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","ki ncha pradhAnayAjakA adhyApakAshcha tadvat tiraskR^itya parasparaM chachakShire eSha parAnAvat kintu svamavituM na shaknoti| ");
INSERT INTO sanitr_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","yadIsrAyelo rAjAbhiShiktastrAtA bhavati tarhyadhunaina krushAdavarohatu vayaM tad dR^iShTvA vishvasiShyAmaH; ki ncha yau lokau tena sArddhaM krushe .avidhyetAM tAvapi taM nirbhartsayAmAsatuH| ");
INSERT INTO sanitr_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","atha dvitIyayAmAt tR^itIyayAmaM yAvat sarvvo deshaH sAndhakArobhUt| ");
INSERT INTO sanitr_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","tatastR^itIyaprahare yIshuruchchairavadat elI elI lAmA shivaktanI arthAd \"he madIsha madIsha tvaM paryyatyAkShIH kuto hi mAM?\" ");
INSERT INTO sanitr_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","tadA samIpasthalokAnAM kechit tadvAkyaM nishamyAchakhyuH pashyaiSha eliyam AhUyati| ");
INSERT INTO sanitr_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","tata eko jano dhAvitvAgatya spa nje .amlarasaM pUrayitvA taM naDAgre nidhAya pAtuM tasmai dattvAvadat tiShTha eliya enamavarohayitum eti na veti pashyAmi| ");
INSERT INTO sanitr_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","atha yIshuruchchaiH samAhUya prANAn jahau| ");
INSERT INTO sanitr_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","tadA mandirasya javanikordvvAdadhaHryyantA vidIrNA dvikhaNDAbhUt| ");
INSERT INTO sanitr_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","ki ncha itthamuchchairAhUya prANAn tyajantaM taM dR^iShdvA tadrakShaNAya niyukto yaH senApatirAsIt sovadat naroyam Ishvaraputra iti satyam| ");
INSERT INTO sanitr_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","tadAnIM magdalInI marisam kaniShThayAkUbo yoseshcha mAtAnyamariyam shAlomI cha yAH striyo ");
INSERT INTO sanitr_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","gAlIlpradeshe yIshuM sevitvA tadanugAminyo jAtA imAstadanyAshcha yA anekA nAryo yIshunA sArddhaM yirUshAlamamAyAtAstAshcha dUrAt tAni dadR^ishuH| ");
INSERT INTO sanitr_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","athAsAdanadinasyArthAd vishrAmavArAt pUrvvadinasya sAyaMkAla Agata ");
INSERT INTO sanitr_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","IshvararAjyApekShyarimathIyayUShaphanAmA mAnyamantrI sametya pIlAtasavidhaM nirbhayo gatvA yIshordehaM yayAche| ");
INSERT INTO sanitr_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","kintu sa idAnIM mR^itaH pIlAta ityasambhavaM matvA shatasenApatimAhUya sa kadA mR^ita iti paprachCha| ");
INSERT INTO sanitr_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","shatasemanApatimukhAt tajj nAtvA yUShaphe yIshordehaM dadau| ");
INSERT INTO sanitr_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","pashchAt sa sUkShmaM vAsaH krItvA yIshoH kAyamavarohya tena vAsasA veShTAyitvA girau khAtashmashAne sthApitavAn pAShANaM loThayitvA dvAri nidadhe| ");
INSERT INTO sanitr_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","kintu yatra sosthApyata tata magdalInI mariyam yosimAtR^imariyam cha dadR^ishatR^iH| ");
INSERT INTO sanitr_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","atha vishrAmavAre gate magdalInI mariyam yAkUbamAtA mariyam shAlomI chemAstaM marddayituM sugandhidravyANi krItvA ");
INSERT INTO sanitr_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","saptAhaprathamadine.atipratyUShe sUryyodayakAle shmashAnamupagatAH| ");
INSERT INTO sanitr_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","kintu shmashAnadvArapAShANo.atibR^ihan taM ko.apasArayiShyatIti tAH parasparaM gadanti! ");
INSERT INTO sanitr_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","etarhi nirIkShya pAShANo dvAro .apasArita iti dadR^ishuH| ");
INSERT INTO sanitr_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","pashchAttAH shmashAnaM pravishya shuklavarNadIrghaparichChadAvR^itamekaM yuvAnaM shmashAnadakShiNapArshva upaviShTaM dR^iShTvA chamachchakruH| ");
INSERT INTO sanitr_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","so.avadat, mAbhaiShTa yUyaM krushe hataM nAsaratIyayIshuM gaveShayatha sotra nAsti shmashAnAdudasthAt; tai ryatra sa sthApitaH sthAnaM tadidaM pashyata| ");
INSERT INTO sanitr_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","kintu tena yathoktaM tathA yuShmAkamagre gAlIlaM yAsyate tatra sa yuShmAn sAkShAt kariShyate yUyaM gatvA tasya shiShyebhyaH pitarAya cha vArttAmimAM kathayata| ");
INSERT INTO sanitr_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","tAH kampitA vistitAshcha tUrNaM shmashAnAd bahirgatvA palAyanta bhayAt kamapi kimapi nAvadaMshcha| ");
INSERT INTO sanitr_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","aparaM yIshuH saptAhaprathamadine pratyUShe shmashAnAdutthAya yasyAH saptabhUtAstyAjitAstasyai magdalInImariyame prathamaM darshanaM dadau| ");
INSERT INTO sanitr_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","tataH sA gatvA shokarodanakR^idbhyo.anugatalokebhyastAM vArttAM kathayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","kintu yIshuH punarjIvan tasyai darshanaM dattavAniti shrutvA te na pratyayan| ");
INSERT INTO sanitr_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","pashchAt teShAM dvAyo rgrAmayAnakAle yIshuranyaveshaM dhR^itvA tAbhyAM darshana dadau! ");
INSERT INTO sanitr_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","tAvapi gatvAnyashiShyebhyastAM kathAM kathayA nchakratuH kintu tayoH kathAmapi te na pratyayan| ");
INSERT INTO sanitr_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","sheShata ekAdashashiShyeShu bhojanopaviShTeShu yIshustebhyo darshanaM dadau tathotthAnAt paraM taddarshanaprAptalokAnAM kathAyAmavishvAsakaraNAt teShAmavishvAsamanaHkAThinyAbhyAM hetubhyAM sa tAMstarjitavAn| ");
INSERT INTO sanitr_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","atha tAnAchakhyau yUyaM sarvvajagad gatvA sarvvajanAn prati susaMvAdaM prachArayata| ");
INSERT INTO sanitr_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","tatra yaH kashchid vishvasya majjito bhavet sa paritrAsyate kintu yo na vishvasiShyati sa daNDayiShyate| ");
INSERT INTO sanitr_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","ki ncha ye pratyeShyanti tairIdR^ig AshcharyyaM karmma prakAshayiShyate te mannAmnA bhUtAn tyAjayiShyanti bhAShA anyAshcha vadiShyanti| ");
INSERT INTO sanitr_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","aparaM taiH sarpeShu dhR^iteShu prANanAshakavastuni pIte cha teShAM kApi kShati rna bhaviShyati; rogiNAM gAtreShu karArpite te.arogA bhaviShyanti cha| ");
INSERT INTO sanitr_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","atha prabhustAnityAdishya svargaM nItaH san parameshvarasya dakShiNa upavivesha| ");
INSERT INTO sanitr_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","tataste prasthAya sarvvatra susaMvAdIyakathAM prachArayitumArebhire prabhustu teShAM sahAyaH san prakAshitAshcharyyakriyAbhistAM kathAM pramANavatIM chakAra| iti|");
INSERT INTO sanitr_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","prathamato ye sAkShiNo vAkyaprachArakAshchAsan te.asmAkaM madhye yadyat sapramANaM vAkyamarpayanti sma ");
INSERT INTO sanitr_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","tadanusArato.anyepi bahavastadvR^ittAntaM rachayituM pravR^ittAH| ");
INSERT INTO sanitr_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ataeva he mahAmahimathiyaphil tvaM yA yAH kathA ashikShyathAstAsAM dR^iDhapramANAni yathA prApnoShi ");
INSERT INTO sanitr_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","tadarthaM prathamamArabhya tAni sarvvANi j nAtvAhamapi anukramAt sarvvavR^ittAntAn tubhyaM lekhituM matimakArSham| ");
INSERT INTO sanitr_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","yihUdAdeshIyaherodnAmake rAjatvaM kurvvati abIyayAjakasya paryyAyAdhikArI sikhariyanAmaka eko yAjako hAroNavaMshodbhavA ilIshevAkhyA ");
INSERT INTO sanitr_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","tasya jAyA dvAvimau nirdoShau prabhoH sarvvAj nA vyavasthAshcha saMmanya IshvaradR^iShTau dhArmmikAvAstAm| ");
INSERT INTO sanitr_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","tayoH santAna ekopi nAsIt, yata ilIshevA bandhyA tau dvAveva vR^iddhAvabhavatAm| ");
INSERT INTO sanitr_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","yadA svaparyyAnukrameNa sikhariya IshvAsya samakShaM yAjakIyaM karmma karoti ");
INSERT INTO sanitr_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","tadA yaj nasya dinaparipAyyA parameshvarasya mandire praveshakAle dhUpajvAlanaM karmma tasya karaNIyamAsIt| ");
INSERT INTO sanitr_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","taddhUpajvAlanakAle lokanivahe prArthanAM kartuM bahistiShThati ");
INSERT INTO sanitr_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","sati sikhariyo yasyAM vedyAM dhUpaM jvAlayati taddakShiNapArshve parameshvarasya dUta eka upasthito darshanaM dadau| ");
INSERT INTO sanitr_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","taM dR^iShTvA sikhariya udvivije shasha Nke cha| ");
INSERT INTO sanitr_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","tadA sa dUtastaM babhAShe he sikhariya mA bhaistava prArthanA grAhyA jAtA tava bhAryyA ilIshevA putraM prasoShyate tasya nAma yoेhan iti kariShyasi| ");
INSERT INTO sanitr_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ki ncha tvaM sAnandaH saharShashcha bhaviShyasi tasya janmani bahava AnandiShyanti cha| ");
INSERT INTO sanitr_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","yato hetoH sa parameshvarasya gochare mahAn bhaviShyati tathA drAkShArasaM surAM vA kimapi na pAsyati, aparaM janmArabhya pavitreNAtmanA paripUrNaH ");
INSERT INTO sanitr_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","san isrAyelvaMshIyAn anekAn prabhoH parameshvarasya mArgamAneShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","santAnAn prati pitR^iNAM manAMsi dharmmaj nAnaM pratyanAj nAgrAhiNashcha parAvarttayituM, prabhoH parameshvarasya sevArtham ekAM sajjitajAtiM vidhAtu ncha sa eliyarUpAtmashaktiprAptastasyAgre gamiShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","tadA sikhariyo dUtamavAdIt kathametad vetsyAmi? yatohaM vR^iddho mama bhAryyA cha vR^iddhA| ");
INSERT INTO sanitr_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","tato dUtaH pratyuvAcha pashyeshvarasya sAkShAdvarttI jibrAyelnAmA dUtohaM tvayA saha kathAM gadituM tubhyamimAM shubhavArttAM dAtu ncha preShitaH| ");
INSERT INTO sanitr_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","kintu madIyaM vAkyaM kAle phaliShyati tat tvayA na pratItam ataH kAraNAd yAvadeva tAni na setsyanti tAvat tvaM vaktuMmashakto mUko bhava| ");
INSERT INTO sanitr_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","tadAnIM ye ye lokAH sikhariyamapaikShanta te madhyemandiraM tasya bahuvilambAd AshcharyyaM menire| ");
INSERT INTO sanitr_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","sa bahirAgato yadA kimapi vAkyaM vaktumashaktaH sa NketaM kR^itvA niHshabdastasyau tadA madhyemandiraM kasyachid darshanaM tena prAptam iti sarvve bubudhire| ");
INSERT INTO sanitr_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","anantaraM tasya sevanaparyyAye sampUrNe sati sa nijagehaM jagAma| ");
INSERT INTO sanitr_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","katipayadineShu gateShu tasya bhAryyA ilIshevA garbbhavatI babhUva ");
INSERT INTO sanitr_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","pashchAt sA pa nchamAsAn saMgopyAkathayat lokAnAM samakShaM mamApamAnaM khaNDayituM parameshvaro mayi dR^iShTiM pAtayitvA karmmedR^ishaM kR^itavAn| ");
INSERT INTO sanitr_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","apara ncha tasyA garbbhasya ShaShThe mAse jAte gAlIlpradeshIyanAsaratpure ");
INSERT INTO sanitr_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","dAyUdo vaMshIyAya yUShaphnAmne puruShAya yA mariyamnAmakumArI vAgdattAsIt tasyAH samIpaM jibrAyel dUta IshvareNa prahitaH| ");
INSERT INTO sanitr_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","sa gatvA jagAda he IshvarAnugR^ihItakanye tava shubhaM bhUyAt prabhuH parameshvarastava sahAyosti nArINAM madhye tvameva dhanyA| ");
INSERT INTO sanitr_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","tadAnIM sA taM dR^iShTvA tasya vAkyata udvijya kIdR^ishaM bhAShaNamidam iti manasA chintayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","tato dUto.avadat he mariyam bhayaM mAkArShIH, tvayi parameshvarasyAnugrahosti| ");
INSERT INTO sanitr_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","pashya tvaM garbbhaM dhR^itvA putraM prasoShyase tasya nAma yIshuriti kariShyasi| ");
INSERT INTO sanitr_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","sa mahAn bhaviShyati tathA sarvvebhyaH shreShThasya putra iti khyAsyati; aparaM prabhuH parameshvarastasya piturdAyUdaH siMhAsanaM tasmai dAsyati; ");
INSERT INTO sanitr_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","tathA sa yAkUbo vaMshopari sarvvadA rAjatvaM kariShyati, tasya rAjatvasyAnto na bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","tadA mariyam taM dUtaM babhAShe nAhaM puruShasa NgaM karomi tarhi kathametat sambhaviShyati? ");
INSERT INTO sanitr_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","tato dUto.akathayat pavitra AtmA tvAmAshrAyiShyati tathA sarvvashreShThasya shaktistavopari ChAyAM kariShyati tato hetostava garbbhAd yaH pavitrabAlako janiShyate sa Ishvaraputra iti khyAtiM prApsyati| ");
INSERT INTO sanitr_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","apara ncha pashya tava j nAtirilIshevA yAM sarvve bandhyAmavadan idAnIM sA vArddhakye santAnamekaM garbbhe.adhArayat tasya ShaShThamAsobhUt| ");
INSERT INTO sanitr_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","kimapi karmma nAsAdhyam Ishvarasya| ");
INSERT INTO sanitr_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","tadA mariyam jagAda, pashya prabherahaM dAsI mahyaM tava vAkyAnusAreNa sarvvametad ghaTatAm; ananataraM dUtastasyAH samIpAt pratasthe| ");
INSERT INTO sanitr_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","atha katipayadinAt paraM mariyam tasmAt parvvatamayapradeshIyayihUdAyA nagaramekaM shIghraM gatvA ");
INSERT INTO sanitr_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","sikhariyayAjakasya gR^ihaM pravishya tasya jAyAm ilIshevAM sambodhyAvadat| ");
INSERT INTO sanitr_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","tato mariyamaH sambodhanavAkye ilIshevAyAH karNayoH praviShTamAtre sati tasyA garbbhasthabAlako nanartta| tata ilIshevA pavitreNAtmanA paripUrNA satI ");
INSERT INTO sanitr_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","prochchairgaditumArebhe, yoShitAM madhye tvameva dhanyA, tava garbbhasthaH shishushcha dhanyaH| ");
INSERT INTO sanitr_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","tvaM prabhormAtA, mama niveshane tvayA charaNAvarpitau, mamAdya saubhAgyametat| ");
INSERT INTO sanitr_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","pashya tava vAkye mama karNayoH praviShTamAtre sati mamodarasthaH shishurAnandAn nanartta| ");
INSERT INTO sanitr_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","yA strI vyashvasIt sA dhanyA, yato hetostAM prati parameshvaroktaM vAkyaM sarvvaM siddhaM bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","tadAnIM mariyam jagAda| dhanyavAdaM pareshasya karoti mAmakaM manaH| ");
INSERT INTO sanitr_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","mamAtmA tArakeshe cha samullAsaM pragachChati| ");
INSERT INTO sanitr_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","akarot sa prabhu rduShTiM svadAsyA durgatiM prati| pashyAdyArabhya mAM dhanyAM vakShyanti puruShAH sadA| ");
INSERT INTO sanitr_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","yaH sarvvashaktimAn yasya nAmApi cha pavitrakaM| sa eva sumahatkarmma kR^itavAn mannimittakaM| ");
INSERT INTO sanitr_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ye bibhyati janAstasmAt teShAM santAnapaMktiShu| anukampA tadIyA cha sarvvadaiva sutiShThati| ");
INSERT INTO sanitr_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","svabAhubalatastena prAkAshyata parAkramaH| manaHkumantraNAsArddhaM vikIryyante.abhimAninaH| ");
INSERT INTO sanitr_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","siMhAsanagatAllokAn balinashchAvarohya saH| padeShUchcheShu lokAMstu kShudrAn saMsthApayatyapi| ");
INSERT INTO sanitr_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","kShudhitAn mAnavAn dravyairuttamaiH paritarpya saH| sakalAn dhanino lokAn visR^ijed riktahastakAn| ");
INSERT INTO sanitr_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ibrAhImi cha tadvaMshe yA dayAsti sadaiva tAM| smR^itvA purA pitR^iNAM no yathA sAkShAt pratishrutaM| ");
INSERT INTO sanitr_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","isrAyelsevakastena tathopakriyate svayaM|| ");
INSERT INTO sanitr_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","anantaraM mariyam prAyeNa mAsatrayam ilIshevayA sahoShitvA vyAghuyya nijaniveshanaM yayau| ");
INSERT INTO sanitr_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","tadanantaram ilIshevAyAH prasavakAla upasthite sati sA putraM prAsoShTa| ");
INSERT INTO sanitr_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","tataH parameshvarastasyAM mahAnugrahaM kR^itavAn etat shrutvA samIpavAsinaH kuTumbAshchAgatya tayA saha mumudire| ");
INSERT INTO sanitr_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","tathAShTame dine te bAlakasya tvachaM Chettum etya tasya pitR^inAmAnurUpaM tannAma sikhariya iti karttumIShuH| ");
INSERT INTO sanitr_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","kintu tasya mAtAkathayat tanna, nAmAsya yohan iti karttavyam| ");
INSERT INTO sanitr_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","tadA te vyAharan tava vaMshamadhye nAmedR^ishaM kasyApi nAsti| ");
INSERT INTO sanitr_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","tataH paraM tasya pitaraM sikhariyaM prati sa Nketya paprachChuH shishoH kiM nAma kAriShyate? ");
INSERT INTO sanitr_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","tataH sa phalakamekaM yAchitvA lilekha tasya nAma yohan bhaviShyati| tasmAt sarvve AshcharyyaM menire| ");
INSERT INTO sanitr_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","tatkShaNaM sikhariyasya jihvAjADye.apagate sa mukhaM vyAdAya spaShTavarNamuchchAryya Ishvarasya guNAnuvAdaM chakAra| ");
INSERT INTO sanitr_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","tasmAchchaturdiksthAH samIpavAsilokA bhItA evametAH sarvvAH kathA yihUdAyAH parvvatamayapradeshasya sarvvatra prachAritAH| ");
INSERT INTO sanitr_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","tasmAt shrotAro manaHsu sthApayitvA kathayAmbabhUvuH kIdR^ishoyaM bAlo bhaviShyati? atha parameshvarastasya sahAyobhUt| ");
INSERT INTO sanitr_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","tadA yohanaH pitA sikhariyaH pavitreNAtmanA paripUrNaH san etAdR^ishaM bhaviShyadvAkyaM kathayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","isrAyelaH prabhu ryastu sa dhanyaH parameshvaraH| anugR^ihya nijAllokAn sa eva parimochayet| ");
INSERT INTO sanitr_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","vipakShajanahastebhyo yathA mochyAmahe vayaM| yAvajjIva ncha dharmmeNa sAralyena cha nirbhayAH| ");
INSERT INTO sanitr_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","sevAmahai tamevaikam etatkAraNameva cha| svakIyaM supavitra ncha saMsmR^itya niyamaM sadA| ");
INSERT INTO sanitr_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","kR^ipayA puruShAn pUrvvAn nikaShArthAttu naH pituH| ibrAhImaH samIpe yaM shapathaM kR^itavAn purA| ");
INSERT INTO sanitr_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","tameva saphalaM karttaM tathA shatrugaNasya cha| R^iृtIyAkAriNashchaiva karebhyo rakShaNAya naH| ");
INSERT INTO sanitr_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","sR^iShTeH prathamataH svIyaiH pavitrai rbhAvivAdibhiH| ");
INSERT INTO sanitr_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","yathoktavAn tathA svasya dAyUdaH sevakasya tu| ");
INSERT INTO sanitr_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","vaMshe trAtAramekaM sa samutpAditavAn svayam| ");
INSERT INTO sanitr_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ato he bAlaka tvantu sarvvebhyaH shreShTha eva yaH| tasyaiva bhAvivAdIti pravikhyAto bhaviShyasi| asmAkaM charaNAn kSheme mArge chAlayituM sadA| evaM dhvAnte.arthato mR^ityoshChAyAyAM ye tu mAnavAH| ");
INSERT INTO sanitr_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","upaviShTAstu tAneva prakAshayitumeva hi| kR^itvA mahAnukampAM hi yAmeva parameshvaraH| ");
INSERT INTO sanitr_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","UrdvvAt sUryyamudAyyaivAsmabhyaM prAdAttu darshanaM| tayAnukampayA svasya lokAnAM pApamochane| ");
INSERT INTO sanitr_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","paritrANasya tebhyo hi j nAnavishrANanAya cha| prabho rmArgaM pariShkarttuM tasyAgrAyI bhaviShyasi|| ");
INSERT INTO sanitr_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","atha bAlakaH sharIreNa buddhyA cha varddhitumArebhe; apara ncha sa isrAyelo vaMshIyalokAnAM samIpe yAvanna prakaTIbhUtastAstAvat prAntare nyavasat| ");
INSERT INTO sanitr_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","apara ncha tasmin kAle rAjyasya sarvveShAM lokAnAM nAmAni lekhayitum agastakaisara Aj nApayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","tadanusAreNa kurINiyanAmani suriyAdeshasya shAsake sati nAmalekhanaM prArebhe| ");
INSERT INTO sanitr_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","ato heto rnAma lekhituM sarvve janAH svIyaM svIyaM nagaraM jagmuH| ");
INSERT INTO sanitr_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","tadAnIM yUShaph nAma lekhituM vAgdattayA svabhAryyayA garbbhavatyA mariyamA saha svayaM dAyUdaH sajAtivaMsha iti kAraNAd gAlIlpradeshasya nAsaratnagarAd ");
INSERT INTO sanitr_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","yihUdApradeshasya baitlehamAkhyaM dAyUdnagaraM jagAma| ");
INSERT INTO sanitr_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","anyachcha tatra sthAne tayostiShThatoH sato rmariyamaH prasUtikAla upasthite ");
INSERT INTO sanitr_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","sA taM prathamasutaM prAsoShTa kintu tasmin vAsagR^ihe sthAnAbhAvAd bAlakaM vastreNa veShTayitvA goshAlAyAM sthApayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","anantaraM ye kiyanto meShapAlakAH svameShavrajarakShAyai tatpradeshe sthitvA rajanyAM prAntare prahariNaH karmma kurvvanti, ");
INSERT INTO sanitr_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","teShAM samIpaM parameshvarasya dUta Agatyopatasthau; tadA chatuShpArshve parameshvarasya tejasaH prakAshitatvAt te.atishasha Nkire| ");
INSERT INTO sanitr_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","tadA sa dUta uvAcha mA bhaiShTa pashyatAdya dAyUdaH pure yuShmannimittaM trAtA prabhuH khrIShTo.ajaniShTa, ");
INSERT INTO sanitr_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","sarvveShAM lokAnAM mahAnandajanakam imaM ma NgalavR^ittAntaM yuShmAn j nApayAmi| ");
INSERT INTO sanitr_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","yUyaM (tatsthAnaM gatvA) vastraveShTitaM taM bAlakaM goshAlAyAM shayanaM drakShyatha yuShmAn pratIdaM chihnaM bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","dUta imAM kathAM kathitavati tatrAkasmAt svargIyAH pR^itanA Agatya kathAm imAM kathayitveshvarasya guNAnanvavAdiShuH, yathA, ");
INSERT INTO sanitr_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","sarvvordvvasthairIshvarasya mahimA samprakAshyatAM| shAntirbhUyAt pR^ithivyAstu santoShashcha narAn prati|| ");
INSERT INTO sanitr_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","tataH paraM teShAM sannidhe rdUtagaNe svargaM gate meShapAlakAH parasparam avechan AgachChata prabhuH parameshvaro yAM ghaTanAM j nApitavAn tasyA yAtharyaM j nAtuM vayamadhunA baitlehampuraM yAmaH| ");
INSERT INTO sanitr_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","pashchAt te tUrNaM vrajitvA mariyamaM yUShaphaM goshAlAyAM shayanaM bAlaka ncha dadR^ishuH| ");
INSERT INTO sanitr_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","itthaM dR^iShTvA bAlakasyArthe proktAM sarvvakathAM te prAchArayA nchakruH| ");
INSERT INTO sanitr_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","tato ye lokA meSharakShakANAM vadanebhyastAM vArttAM shushruvuste mahAshcharyyaM menire| ");
INSERT INTO sanitr_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","kintu mariyam etatsarvvaghaTanAnAM tAtparyyaM vivichya manasi sthApayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","tatpashchAd dUtavij naptAnurUpaM shrutvA dR^iShTvA cha meShapAlakA Ishvarasya guNAnuvAdaM dhanyavAda ncha kurvvANAH parAvR^itya yayuH| ");
INSERT INTO sanitr_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","atha bAlakasya tvakChedanakAle.aShTamadivase samupasthite tasya garbbhasthiteH purvvaM svargIyadUto yathAj nApayat tadanurUpaM te tannAmadheyaM yIshuriti chakrire| ");
INSERT INTO sanitr_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","tataH paraM mUsAlikhitavyavasthAyA anusAreNa mariyamaH shuchitvakAla upasthite, ");
INSERT INTO sanitr_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","\"prathamajaH sarvvaH puruShasantAnaH parameshvare samarpyatAM,\" iti parameshvarasya vyavasthayA ");
INSERT INTO sanitr_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","yIshuM parameshvare samarpayitum shAstrIyavidhyuktaM kapotadvayaM pArAvatashAvakadvayaM vA baliM dAtuM te taM gR^ihItvA yirUshAlamam AyayuH| ");
INSERT INTO sanitr_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","yirUshAlampuranivAsI shimiyonnAmA dhArmmika eka AsIt sa isrAyelaH sAntvanAmapekShya tasthau ki ncha pavitra AtmA tasminnAvirbhUtaH| ");
INSERT INTO sanitr_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","aparaM prabhuNA parameshvareNAbhiShikte trAtari tvayA na dR^iShTe tvaM na mariShyasIti vAkyaM pavitreNa AtmanA tasma prAkathyata| ");
INSERT INTO sanitr_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","apara ncha yadA yIshoH pitA mAtA cha tadarthaM vyavasthAnurUpaM karmma karttuM taM mandiram AninyatustadA ");
INSERT INTO sanitr_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","shimiyon Atmana AkarShaNena mandiramAgatya taM kroDe nidhAya Ishvarasya dhanyavAdaM kR^itvA kathayAmAsa, yathA, ");
INSERT INTO sanitr_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","he prabho tava dAsoyaM nijavAkyAnusArataH| idAnIntu sakalyANo bhavatA saMvisR^ijyatAm| ");
INSERT INTO sanitr_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","yataH sakaladeshasya dIptaye dIptirUpakaM| ");
INSERT INTO sanitr_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","isrAyelIyalokasya mahAgauravarUpakaM| ");
INSERT INTO sanitr_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","yaM trAyakaM janAnAntu sammukhe tvamajIjanaH| saeva vidyate.asmAkaM dhravaM nayananagochare|| ");
INSERT INTO sanitr_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","tadAnIM tenoktA etAH sakalAH kathAH shrutvA tasya mAtA yUShaph cha vismayaM menAte| ");
INSERT INTO sanitr_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","tataH paraM shimiyon tebhya AshiShaM dattvA tanmAtaraM mariyamam uvAcha, pashya isrAyelo vaMshamadhye bahUnAM pAtanAyotthApanAya cha tathA virodhapAtraM bhavituM, bahUnAM guptamanogatAnAM prakaTIkaraNAya bAlakoyaM niyuktosti| ");
INSERT INTO sanitr_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","tasmAt tavApi prANAH shUlena vyatsyante| ");
INSERT INTO sanitr_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","apara ncha Asherasya vaMshIyaphinUyelo duhitA hannAkhyA atijaratI bhaviShyadvAdinyekA yA vivAhAt paraM sapta vatsarAn patyA saha nyavasat tato vidhavA bhUtvA chaturashItivarShavayaHparyyanataM ");
INSERT INTO sanitr_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","mandire sthitvA prArthanopavAsairdivAnisham Ishvaram asevata sApi strI tasmin samaye mandiramAgatya ");
INSERT INTO sanitr_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","parameshvarasya dhanyavAdaM chakAra, yirUshAlampuravAsino yAvanto lokA muktimapekShya sthitAstAn yIshorvR^ittAntaM j nApayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","itthaM parameshvarasya vyavasthAnusAreNa sarvveShu karmmasu kR^iteShu tau punashcha gAlIlo nAsaratnAmakaM nijanagaraM pratasthAte| ");
INSERT INTO sanitr_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","tatpashchAd bAlakaH sharIreNa vR^iddhimetya j nAnena paripUrNa AtmanA shaktimAMshcha bhavitumArebhe tathA tasmin IshvarAnugraho babhUva| ");
INSERT INTO sanitr_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","tasya pitA mAtA cha prativarShaM nistArotsavasamaye yirUshAlamam agachChatAm| ");
INSERT INTO sanitr_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","apara ncha yIshau dvAdashavarShavayaske sati tau parvvasamayasya rItyanusAreNa yirUshAlamaM gatvA ");
INSERT INTO sanitr_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","pArvvaNaM sampAdya punarapi vyAghuyya yAtaH kintu yIshurbAlako yirUshAlami tiShThati| yUShaph tanmAtA cha tad aviditvA ");
INSERT INTO sanitr_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","sa sa NgibhiH saha vidyata etachcha budvvA dinaikagamyamArgaM jagmatuH| kintu sheShe j nAtibandhUnAM samIpe mR^igayitvA taduddeेshamaprApya ");
INSERT INTO sanitr_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","tau punarapi yirUshAlamam parAvR^ityAgatya taM mR^igayA nchakratuH| ");
INSERT INTO sanitr_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","atha dinatrayAt paraM paNDitAnAM madhye teShAM kathAH shR^iNvan tattvaM pR^ichChaMshcha mandire samupaviShTaH sa tAbhyAM dR^iShTaH| ");
INSERT INTO sanitr_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","tadA tasya buddhyA pratyuttaraishcha sarvve shrotAro vismayamApadyante| ");
INSERT INTO sanitr_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","tAdR^ishaM dR^iShTvA tasya janako jananI cha chamachchakratuH ki ncha tasya mAtA tamavadat, he putra, kathamAvAM pratItthaM samAcharastvam? pashya tava pitAha ncha shokAkulau santau tvAmanvichChAvaH sma| ");
INSERT INTO sanitr_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","tataH sovadat kuto mAm anvaichChataM? piturgR^ihe mayA sthAtavyam etat kiM yuvAbhyAM na j nAyate? ");
INSERT INTO sanitr_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","kintu tau tasyaitadvAkyasya tAtparyyaM boddhuM nAshaknutAM| ");
INSERT INTO sanitr_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","tataH paraM sa tAbhyAM saha nAsarataM gatvA tayorvashIbhUtastasthau kintu sarvvA etAH kathAstasya mAtA manasi sthApayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","atha yIsho rbuddhiH sharIra ncha tathA tasmin Ishvarasya mAnavAnA nchAnugraho varddhitum Arebhe| ");
INSERT INTO sanitr_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","anantaraM tibiriyakaisarasya rAjatvasya pa nchadashe vatsare sati yadA pantIyapIlAto yihUdAdeshAdhipati rherod tu gAlIlpradeshasya rAjA philipanAmA tasya bhrAtA tu yitUriyAyAstrAkhonItiyApradeshasya cha rAjAsIt luShAnIyanAmA avilInIdeshasya rAjAsIt ");
INSERT INTO sanitr_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","hAnan kiyaphAshchemau pradhAnayAjAkAvAstAM tadAnIM sikhariyasya putrAya yohane madhyeprAntaram Ishvarasya vAkye prakAshite sati ");
INSERT INTO sanitr_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","sa yarddana ubhayataTapradeshAn sametya pApamochanArthaM manaHparAvarttanasya chihnarUpaM yanmajjanaM tadIyAH kathAH sarvvatra prachArayitumArebhe| ");
INSERT INTO sanitr_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","yishayiyabhaviShyadvaktR^igranthe yAdR^ishI lipirAste yathA, parameshasya panthAnaM pariShkuruta sarvvataH| tasya rAjapatha nchaiva samAnaM kurutAdhunA| ");
INSERT INTO sanitr_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","kAriShyante samuchChrAyAH sakalA nimnabhUmayaH| kAriShyante natAH sarvve parvvatAshchopaparvvatAH| kAriShyante cha yA vakrAstAH sarvvAH saralA bhuvaH| kAriShyante samAnAstA yA uchchanIchabhUmayaH| ");
INSERT INTO sanitr_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","IshvareNa kR^itaM trANaM drakShyanti sarvvamAnavAH| ityetat prAntare vAkyaM vadataH kasyachid ravaH|| ");
INSERT INTO sanitr_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ye ye lokA majjanArthaM bahirAyayustAn sovadat re re sarpavaMshA AgAminaH kopAt palAyituM yuShmAn kashchetayAmAsa? ");
INSERT INTO sanitr_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","tasmAd ibrAhIm asmAkaM pitA kathAmIdR^ishIM manobhi rna kathayitvA yUyaM manaHparivarttanayogyaM phalaM phalata; yuShmAnahaM yathArthaM vadAmi pAShANebhya etebhya Ishvara ibrAhImaH santAnotpAdane samarthaH| ");
INSERT INTO sanitr_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","apara ncha tarumUle.adhunApi parashuH saMlagnosti yastaruruttamaM phalaM na phalati sa Chidyate.agnau nikShipyate cha| ");
INSERT INTO sanitr_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","tadAnIM lokAstaM paprachChustarhi kiM karttavyamasmAbhiH? ");
INSERT INTO sanitr_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","tataH sovAdIt yasya dve vasane vidyete sa vastrahInAyaikaM vitaratu kiM ncha yasya khAdyadravyaM vidyate sopi tathaiva karotu| ");
INSERT INTO sanitr_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","tataH paraM karasa nchAyino majjanArtham Agatya paprachChuH he guro kiM karttavyamasmAbhiH? ");
INSERT INTO sanitr_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","tataH sokathayat nirUpitAdadhikaM na gR^ihlita| ");
INSERT INTO sanitr_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","anantaraM senAgaNa etya paprachCha kimasmAbhi rvA karttavyam? tataH sobhidadhe kasya kAmapi hAniM mA kArShTa tathA mR^iShApavAdaM mA kuruta nijavetanena cha santuShya tiShThata| ");
INSERT INTO sanitr_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","apara ncha lokA apekShayA sthitvA sarvvepIti manobhi rvitarkayA nchakruH, yohanayam abhiShiktastrAtA na veti? ");
INSERT INTO sanitr_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","tadA yohan sarvvAn vyAjahAra, jale.ahaM yuShmAn majjayAmi satyaM kintu yasya pAdukAbandhanaM mochayitumapi na yogyosmi tAdR^isha eko matto gurutaraH pumAn eti, sa yuShmAn vahnirUpe pavitra Atmani majjayiShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","apara ncha tasya haste shUrpa Aste sa svashasyAni shuddharUpaM prasphoTya godhUmAn sarvvAn bhANDAgAre saMgrahIShyati kintu bUShANi sarvvANyanirvvANavahninA dAhayiShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","yohan upadeshenetthaM nAnAkathA lokAnAM samakShaM prachArayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","apara ncha herod rAjA philipnAmnaH sahodarasya bhAryyAM herodiyAmadhi tathAnyAni yAni yAni kukarmmANi kR^itavAn tadadhi cha ");
INSERT INTO sanitr_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","yohanA tiraskR^ito bhUtvA kArAgAre tasya bandhanAd aparamapi kukarmma chakAra| ");
INSERT INTO sanitr_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","itaH pUrvvaM yasmin samaye sarvve yohanA majjitAstadAnIM yIshurapyAgatya majjitaH| ");
INSERT INTO sanitr_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","tadanantaraM tena prArthite meghadvAraM muktaM tasmAchcha pavitra AtmA mUrttimAn bhUtvA kapotavat taduparyyavaruroha; tadA tvaM mama priyaH putrastvayi mama paramaH santoSha ityAkAshavANI babhUva| ");
INSERT INTO sanitr_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","tadAnIM yIshuH prAyeNa triMshadvarShavayaska AsIt| laukikaj nAne tu sa yUShaphaH putraH, ");
INSERT INTO sanitr_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","yUShaph eleH putraH, elirmattataH putraH, mattat leveH putraH, levi rmalkeH putraH, malkiryAnnasya putraH; yAnno yUShaphaH putraH| ");
INSERT INTO sanitr_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","yUShaph mattathiyasya putraH, mattathiya AmosaH putraH, Amos nahUmaH putraH, nahUm iShleH putraH iShlirnageH putraH| ");
INSERT INTO sanitr_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","nagirmATaH putraH, mAT mattathiyasya putraH, mattathiyaH shimiyeH putraH, shimiyiryUShaphaH putraH, yUShaph yihUdAH putraH| ");
INSERT INTO sanitr_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","yihUdA yohAnAH putraH, yohAnA rIShAH putraH, rIShAH sirubbAbilaH putraH, sirubbAbil shaltIyelaH putraH, shaltIyel nereH putraH| ");
INSERT INTO sanitr_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","nerirmalkeH putraH, malkiH adyaH putraH, addI koShamaH putraH, koSham ilmodadaH putraH, ilmodad eraH putraH| ");
INSERT INTO sanitr_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","er yosheH putraH, yoshiH ilIyeSharaH putraH, ilIyeShar yorImaH putraH, yorIm mattataH putraH, mattata leveH putraH| ");
INSERT INTO sanitr_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","leviH shimiyonaH putraH, shimiyon yihUdAH putraH, yihUdA yUShuphaH putraH, yUShuph yonanaH putraH, yAnan ilIyAkImaH putraH| ");
INSERT INTO sanitr_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","iliyAkImH mileyAH putraH, mileyA mainanaH putraH, mainan mattattasya putraH, mattatto nAthanaH putraH, nAthan dAyUdaH putraH| ");
INSERT INTO sanitr_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","dAyUd yishayaH putraH, yishaya obedaH putra, obed boyasaH putraH, boyas salmonaH putraH, salmon nahashonaH putraH| ");
INSERT INTO sanitr_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","nahashon ammInAdabaH putraH, ammInAdab arAmaH putraH, arAm hiShroNaH putraH, hiShroN perasaH putraH, peras yihUdAH putraH| ");
INSERT INTO sanitr_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","yihUdA yAkUbaH putraH, yAkUb ishAkaH putraH, ishAk ibrAhImaH putraH, ibrAhIm terahaH putraH, terah nAhoraH putraH| ");
INSERT INTO sanitr_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","nAhor sirugaH putraH, sirug riyvaH putraH, riyUH pelagaH putraH, pelag evaraH putraH, evar shelahaH putraH| ");
INSERT INTO sanitr_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","shelah kainanaH putraH, kainan arphakShadaH putraH, arphakShad shAmaH putraH, shAm nohaH putraH, noho lemakaH putraH| ");
INSERT INTO sanitr_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","lemak mithUshelahaH putraH, mithUshelah hanokaH putraH, hanok yeradaH putraH, yerad mahalalelaH putraH, mahalalel kainanaH putraH| ");
INSERT INTO sanitr_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","kainan inoshaH putraH, inosh shetaH putraH, shet AdamaH putra, Adam Ishvarasya putraH| ");
INSERT INTO sanitr_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","tataH paraM yIshuH pavitreNAtmanA pUrNaH san yarddananadyAH parAvR^ityAtmanA prAntaraM nItaH san chatvAriMshaddinAni yAvat shaitAnA parIkShito.abhUt, ");
INSERT INTO sanitr_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ki ncha tAni sarvvadinAni bhojanaM vinA sthitatvAt kAle pUrNe sa kShudhitavAn| ");
INSERT INTO sanitr_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","tataH shaitAnAgatya tamavadat tvaM chedIshvarasya putrastarhi prastarAnetAn Aj nayA pUpAn kuru| ");
INSERT INTO sanitr_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","tadA yIshuruvAcha, lipirIdR^ishI vidyate manujaH kevalena pUpena na jIvati kintvIshvarasya sarvvAbhirAj nAbhi rjIvati| ");
INSERT INTO sanitr_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","tadA shaitAn tamuchchaM parvvataM nItvA nimiShaikamadhye jagataH sarvvarAjyAni darshitavAn| ");
INSERT INTO sanitr_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","pashchAt tamavAdIt sarvvam etad vibhavaM pratApa ncha tubhyaM dAsyAmi tan mayi samarpitamAste yaM prati mamechChA jAyate tasmai dAtuM shaknomi, ");
INSERT INTO sanitr_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","tvaM chenmAM bhajase tarhi sarvvametat tavaiva bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","tadA yIshustaM pratyuktavAn dUrI bhava shaitAn lipirAste, nijaM prabhuM parameshvaraM bhajasva kevalaM tameva sevasva cha| ");
INSERT INTO sanitr_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","atha shaitAn taM yirUshAlamaM nItvA mandirasya chUDAyA upari samupaveshya jagAda tvaM chedIshvarasya putrastarhi sthAnAdito lamphitvAdhaH ");
INSERT INTO sanitr_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","pata yato lipirAste, Aj nApayiShyati svIyAn dUtAn sa parameshvaraH| ");
INSERT INTO sanitr_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","rakShituM sarvvamArge tvAM tena tvachcharaNe yathA| na laget prastarAghAtastvAM dhariShyanti te tathA| ");
INSERT INTO sanitr_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","tadA yIshunA pratyuktam idamapyuktamasti tvaM svaprabhuM pareshaM mA parIkShasva| ");
INSERT INTO sanitr_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","pashchAt shaitAn sarvvaparIkShAM samApya kShaNAttaM tyaktvA yayau| ");
INSERT INTO sanitr_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","tadA yIshurAtmaprabhAvAt punargAlIlpradeshaM gatastadA tatsukhyAtishchaturdishaM vyAnashe| ");
INSERT INTO sanitr_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","sa teShAM bhajanagR^iheShu upadishya sarvvaiH prashaMsito babhUva| ");
INSERT INTO sanitr_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","atha sa svapAlanasthAnaM nAsaratpurametya vishrAmavAre svAchArAd bhajanagehaM pravishya paThitumuttasthau| ");
INSERT INTO sanitr_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","tato yishayiyabhaviShyadvAdinaH pustake tasya karadatte sati sa tat pustakaM vistAryya yatra vakShyamANAni vachanAni santi tat sthAnaM prApya papATha| ");
INSERT INTO sanitr_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","AtmA tu parameshasya madIyopari vidyate| daridreShu susaMvAdaM vaktuM mAM sobhiShiktavAn| bhagnAntaH karaNAllokAn susvasthAn karttumeva cha| bandIkR^iteShu lokeShu mukte rghoShayituM vachaH| netrANi dAtumandhebhyastrAtuM baddhajanAnapi| ");
INSERT INTO sanitr_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","pareshAnugrahe kAlaM prachArayitumeva cha| sarvvaitatkaraNArthAya mAmeva prahiNoti saH|| ");
INSERT INTO sanitr_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","tataH pustakaM badvvA parichArakasya haste samarpya chAsane samupaviShTaH, tato bhajanagR^ihe yAvanto lokA Asan te sarvve.ananyadR^iShTyA taM vilulokire| ");
INSERT INTO sanitr_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","anantaram adyaitAni sarvvANi likhitavachanAni yuShmAkaM madhye siddhAni sa imAM kathAM tebhyaH kathayitumArebhe| ");
INSERT INTO sanitr_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","tataH sarvve tasmin anvarajyanta, ki ncha tasya mukhAnnirgatAbhiranugrahasya kathAbhishchamatkR^itya kathayAmAsuH kimayaM yUShaphaH putro na? ");
INSERT INTO sanitr_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","tadA so.avAdId he chikitsaka svameva svasthaM kuru kapharnAhUmi yadyat kR^itavAn tadashrauShma tAH sarvAH kriyA atra svadeshe kuru kathAmetAM yUyamevAvashyaM mAM vadiShyatha| ");
INSERT INTO sanitr_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","punaH sovAdId yuShmAnahaM yathArthaM vadAmi, kopi bhaviShyadvAdI svadeshe satkAraM na prApnoti| ");
INSERT INTO sanitr_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","apara ncha yathArthaM vachmi, eliyasya jIvanakAle yadA sArddhatritayavarShANi yAvat jaladapratibandhAt sarvvasmin deshe mahAdurbhikSham ajaniShTa tadAnIm isrAyelo deshasya madhye bahvyo vidhavA Asan, ");
INSERT INTO sanitr_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","kintu sIdonpradeshIyasAriphatpuranivAsinIm ekAM vidhavAM vinA kasyAshchidapi samIpe eliyaH prerito nAbhUt| ");
INSERT INTO sanitr_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","apara ncha ilIshAyabhaviShyadvAdividyamAnatAkAle isrAyeldeshe bahavaH kuShThina Asan kintu surIyadeshIyaM nAmAnkuShThinaM vinA kopyanyaH pariShkR^ito nAbhUt| ");
INSERT INTO sanitr_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","imAM kathAM shrutvA bhajanagehasthitA lokAH sakrodham utthAya ");
INSERT INTO sanitr_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","nagarAttaM bahiShkR^itya yasya shikhariNa upari teShAM nagaraM sthApitamAste tasmAnnikSheptuM tasya shikharaM taM ninyuH ");
INSERT INTO sanitr_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","kintu sa teShAM madhyAdapasR^itya sthAnAntaraM jagAma| ");
INSERT INTO sanitr_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","tataH paraM yIshurgAlIlpradeshIyakapharnAhUmnagara upasthAya vishrAmavAre lokAnupadeShTum ArabdhavAn| ");
INSERT INTO sanitr_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","tadupadeshAt sarvve chamachchakru ryatastasya kathA gurutarA Asan| ");
INSERT INTO sanitr_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","tadAnIM tadbhajanagehasthito.amedhyabhUtagrasta eko jana uchchaiH kathayAmAsa, ");
INSERT INTO sanitr_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","he nAsaratIyayIsho.asmAn tyaja, tvayA sahAsmAkaM kaH sambandhaH? kimasmAn vinAshayitumAyAsi? tvamIshvarasya pavitro jana etadahaM jAnAmi| ");
INSERT INTO sanitr_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","tadA yIshustaM tarjayitvAvadat maunI bhava ito bahirbhava; tataH somedhyabhUtastaM madhyasthAne pAtayitvA ki nchidapyahiMsitvA tasmAd bahirgatavAn| ");
INSERT INTO sanitr_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","tataH sarvve lokAshchamatkR^itya parasparaM vaktumArebhire koyaM chamatkAraH| eSha prabhAveNa parAkrameNa chAmedhyabhUtAn Aj nApayati tenaiva te bahirgachChanti| ");
INSERT INTO sanitr_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","anantaraM chaturdiksthadeshAn tasya sukhyAtirvyApnot| ");
INSERT INTO sanitr_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","tadanantaraM sa bhajanagehAd bahirAgatya shimono niveshanaM pravivesha tadA tasya shvashrUrjvareNAtyantaM pIDitAsIt shiShyAstadarthaM tasmin vinayaM chakruH| ");
INSERT INTO sanitr_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","tataH sa tasyAH samIpe sthitvA jvaraM tarjayAmAsa tenaiva tAM jvaro.atyAkShIt tataH sA tatkShaNam utthAya tAn siSheve| ");
INSERT INTO sanitr_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","atha sUryyAstakAle sveShAM ye ye janA nAnArogaiH pIDitA Asan lokAstAn yIshoH samIpam AninyuH, tadA sa ekaikasya gAtre karamarpayitvA tAnarogAn chakAra| ");
INSERT INTO sanitr_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","tato bhUtA bahubhyo nirgatya chItshabdaM kR^itvA cha babhAShire tvamIshvarasya putro.abhiShiktatrAtA; kintu sobhiShiktatrAteti te vividuretasmAt kAraNAt tAn tarjayitvA tadvaktuM niShiShedha| ");
INSERT INTO sanitr_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","apara ncha prabhAte sati sa vijanasthAnaM pratasthe pashchAt janAstamanvichChantastannikaTaM gatvA sthAnAntaragamanArthaM tamanvarundhan| ");
INSERT INTO sanitr_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","kintu sa tAn jagAda, IshvarIyarAjyasya susaMvAdaM prachArayitum anyAni purANyapi mayA yAtavyAni yatastadarthameva preritohaM| ");
INSERT INTO sanitr_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","atha gAlIlo bhajanageheShu sa upadidesha| ");
INSERT INTO sanitr_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","anantaraM yIshurekadA gineSharathdasya tIra uttiShThati, tadA lokA IshvarIyakathAM shrotuM tadupari prapatitAH| ");
INSERT INTO sanitr_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","tadAnIM sa hdasya tIrasamIpe naudvayaM dadarsha ki ncha matsyopajIvino nAvaM vihAya jAlaM prakShAlayanti| ");
INSERT INTO sanitr_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","tatastayordvayo rmadhye shimono nAvamAruhya tIrAt ki nchiddUraM yAtuM tasmin vinayaM kR^itvA naukAyAmupavishya lokAn propadiShTavAn| ");
INSERT INTO sanitr_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","pashchAt taM prastAvaM samApya sa shimonaM vyAjahAra, gabhIraM jalaM gatvA matsyAn dharttuM jAlaM nikShipa| ");
INSERT INTO sanitr_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","tataH shimona babhAShe, he guro yadyapi vayaM kR^itsnAM yAminIM parishramya matsyaikamapi na prAptAstathApi bhavato nideshato jAlaM kShipAmaH| ");
INSERT INTO sanitr_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","atha jAle kShipte bahumatsyapatanAd AnAyaH prachChinnaH| ");
INSERT INTO sanitr_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","tasmAd upakarttum anyanausthAn sa Ngina AyAtum i Ngitena samAhvayan tatasta Agatya matsyai rnaudvayaM prapUrayAmAsu ryai rnaudvayaM pramagnam| ");
INSERT INTO sanitr_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","tadA shimonpitarastad vilokya yIshoshcharaNayoH patitvA, he prabhohaM pApI naro mama nikaTAd bhavAn yAtu, iti kathitavAn| ");
INSERT INTO sanitr_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","yato jAle patitAnAM matsyAnAM yUthAt shimon tatsa Nginashcha chamatkR^itavantaH; shimonaH sahakAriNau sivadeH putrau yAkUb yohan chemau tAdR^ishau babhUvatuH| ");
INSERT INTO sanitr_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","tadA yIshuH shimonaM jagAda mA bhaiShIradyArabhya tvaM manuShyadharo bhaviShyasi| ");
INSERT INTO sanitr_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","anantaraM sarvvAsu nausu tIram AnItAsu te sarvvAn parityajya tasya pashchAdgAmino babhUvuH| ");
INSERT INTO sanitr_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","tataH paraM yIshau kasmiMshchit pure tiShThati jana ekaH sarvvA NgakuShThastaM vilokya tasya samIpe nyubjaH patitvA savinayaM vaktumArebhe, he prabho yadi bhavAnichChati tarhi mAM pariShkarttuM shaknoti| ");
INSERT INTO sanitr_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","tadAnIM sa pANiM prasAryya tada NgaM spR^ishan babhAShe tvaM pariShkriyasveti mamechChAsti tatastatkShaNaM sa kuShThAt muktaH| ");
INSERT INTO sanitr_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","pashchAt sa tamAj nApayAmAsa kathAmimAM kasmaichid akathayitvA yAjakasya samIpa ncha gatvA svaM darshaya, lokebhyo nijapariShkR^itatvasya pramANadAnAya mUsAj nAnusAreNa dravyamutmR^ijasva cha| ");
INSERT INTO sanitr_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","tathApi yIshoH sukhyAti rbahu vyAptumArebhe ki ncha tasya kathAM shrotuM svIyarogebhyo moktu ncha lokA AjagmuH| ");
INSERT INTO sanitr_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","atha sa prAntaraM gatvA prArthayA nchakre| ");
INSERT INTO sanitr_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","apara ncha ekadA yIshurupadishati, etarhi gAlIlyihUdApradeshayoH sarvvanagarebhyo yirUshAlamashcha kiyantaH phirUshilokA vyavasthApakAshcha samAgatya tadantike samupavivishuH, tasmin kAle lokAnAmArogyakAraNAt prabhoH prabhAvaH prachakAshe| ");
INSERT INTO sanitr_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","pashchAt kiyanto lokA ekaM pakShAghAtinaM khaTvAyAM nidhAya yIshoH samIpamAnetuM sammukhe sthApayitu ncha vyApriyanta| ");
INSERT INTO sanitr_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","kintu bahujananivahasamvAdhAt na shaknuvanto gR^ihopari gatvA gR^ihapR^iShThaM khanitvA taM pakShAghAtinaM sakhaTvaM gR^ihamadhye yIshoH sammukhe .avarohayAmAsuH| ");
INSERT INTO sanitr_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","tadA yIshusteShAm IdR^ishaM vishvAsaM vilokya taM pakShAghAtinaM vyAjahAra, he mAnava tava pApamakShamyata| ");
INSERT INTO sanitr_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","tasmAd adhyApakAH phirUshinashcha chittairitthaM prachintitavantaH, eSha jana IshvaraM nindati koyaM? kevalamIshvaraM vinA pApaM kShantuM kaH shaknoti? ");
INSERT INTO sanitr_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","tadA yIshusteShAm itthaM chintanaM viditvA tebhyokathayad yUyaM manobhiH kuto vitarkayatha? ");
INSERT INTO sanitr_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","tava pApakShamA jAtA yadvA tvamutthAya vraja etayo rmadhye kA kathA sukathyA? ");
INSERT INTO sanitr_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","kintu pR^ithivyAM pApaM kShantuM mAnavasutasya sAmarthyamastIti yathA yUyaM j nAtuM shaknutha tadarthaM (sa taM pakShAghAtinaM jagAda) uttiShTha svashayyAM gR^ihItvA gR^ihaM yAhIti tvAmAdishAmi| ");
INSERT INTO sanitr_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","tasmAt sa tatkShaNam utthAya sarvveShAM sAkShAt nijashayanIyaM gR^ihItvA IshvaraM dhanyaM vadan nijaniveshanaM yayau| ");
INSERT INTO sanitr_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","tasmAt sarvve vismaya prAptA manaHsu bhItAshcha vayamadyAsambhavakAryyANyadarshAma ityuktvA parameshvaraM dhanyaM proditAH| ");
INSERT INTO sanitr_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","tataH paraM bahirgachChan karasa nchayasthAne levinAmAnaM karasa nchAyakaM dR^iShTvA yIshustamabhidadhe mama pashchAdehi| ");
INSERT INTO sanitr_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","tasmAt sa tatkShaNAt sarvvaM parityajya tasya pashchAdiyAya| ");
INSERT INTO sanitr_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","anantaraM levi rnijagR^ihe tadarthaM mahAbhojyaM chakAra, tadA taiH sahAneke karasa nchAyinastadanyalokAshcha bhoktumupavivishuH| ");
INSERT INTO sanitr_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","tasmAt kAraNAt chaNDAlAnAM pApilokAnA ncha sa Nge yUyaM kuto bhaMgdhve pivatha cheti kathAM kathayitvA phirUshino.adhyApakAshcha tasya shiShyaiH saha vAgyuddhaM karttumArebhire| ");
INSERT INTO sanitr_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","tasmAd yIshustAn pratyavochad arogalokAnAM chikitsakena prayojanaM nAsti kintu sarogANAmeva| ");
INSERT INTO sanitr_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ahaM dhArmmikAn AhvAtuM nAgatosmi kintu manaH parAvarttayituM pApina eva| ");
INSERT INTO sanitr_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","tataste prochuH, yohanaH phirUshinA ncha shiShyA vAraMvAram upavasanti prArthayante cha kintu tava shiShyAH kuto bhu njate pivanti cha? ");
INSERT INTO sanitr_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","tadA sa tAnAchakhyau vare sa Nge tiShThati varasya sakhigaNaM kimupavAsayituM shaknutha? ");
INSERT INTO sanitr_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","kintu yadA teShAM nikaTAd varo neShyate tadA te samupavatsyanti| ");
INSERT INTO sanitr_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","soparamapi dR^iShTAntaM kathayAmbabhUva purAtanavastre kopi nutanavastraM na sIvyati yatastena sevanena jIrNavastraM Chidyate, nUtanapurAtanavastrayo rmela ncha na bhavati| ");
INSERT INTO sanitr_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","purAtanyAM kutvAM kopi nutanaM drAkShArasaM na nidadhAti, yato navInadrAkShArasasya tejasA purAtanI kutU rvidIryyate tato drAkShArasaH patati kutUshcha nashyati| ");
INSERT INTO sanitr_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","tato heto rnUtanyAM kutvAM navInadrAkShArasaH nidhAtavyastenobhayasya rakShA bhavati| ");
INSERT INTO sanitr_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","apara ncha purAtanaM drAkShArasaM pItvA kopi nUtanaM na vA nChati, yataH sa vakti nUtanAt purAtanam prashastam| ");
INSERT INTO sanitr_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","achara ncha parvvaNo dvitIyadinAt paraM prathamavishrAmavAre shasyakShetreNa yIshorgamanakAle tasya shiShyAH kaNishaM ChittvA kareShu marddayitvA khAditumArebhire| ");
INSERT INTO sanitr_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","tasmAt kiyantaH phirUshinastAnavadan vishrAmavAre yat karmma na karttavyaM tat kutaH kurutha? ");
INSERT INTO sanitr_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","yIshuH pratyuvAcha dAyUd tasya sa Nginashcha kShudhArttAH kiM chakruH sa katham Ishvarasya mandiraM pravishya ");
INSERT INTO sanitr_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ye darshanIyAH pUpA yAjakAn vinAnyasya kasyApyabhojanIyAstAnAnIya svayaM bubhaje sa Ngibhyopi dadau tat kiM yuShmAbhiH kadApi nApAThi? ");
INSERT INTO sanitr_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","pashchAt sa tAnavadat manujasuto vishrAmavArasyApi prabhu rbhavati| ");
INSERT INTO sanitr_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","anantaram anyavishrAmavAre sa bhajanagehaM pravishya samupadishati| tadA tatsthAne shuShkadakShiNakara ekaH pumAn upatasthivAn| ");
INSERT INTO sanitr_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","tasmAd adhyApakAH phirUshinashcha tasmin doShamAropayituM sa vishrAmavAre tasya svAsthyaM karoti naveti pratIkShitumArebhire| ");
INSERT INTO sanitr_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","tadA yIshusteShAM chintAM viditvA taM shuShkakaraM pumAMsaM provAcha, tvamutthAya madhyasthAne tiShTha| ");
INSERT INTO sanitr_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","tasmAt tasmin utthitavati yIshustAn vyAjahAra, yuShmAn imAM kathAM pR^ichChAmi, vishrAmavAre hitam ahitaM vA, prANarakShaNaM prANanAshanaM vA, eteShAM kiM karmmakaraNIyam? ");
INSERT INTO sanitr_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","pashchAt chaturdikShu sarvvAn vilokya taM mAnavaM babhAShe, nijakaraM prasAraya; tatastena tathA kR^ita itarakaravat tasya hastaH svasthobhavat| ");
INSERT INTO sanitr_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","tasmAt te prachaNDakopAnvitA yIshuM kiM kariShyantIti parasparaM pramantritAH| ");
INSERT INTO sanitr_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","tataH paraM sa parvvatamAruhyeshvaramuddishya prArthayamAnaH kR^itsnAM rAtriM yApitavAn| ");
INSERT INTO sanitr_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","atha dine sati sa sarvvAn shiShyAn AhUtavAn teShAM madhye ");
INSERT INTO sanitr_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","pitaranAmnA khyAtaH shimon tasya bhrAtA Andriyashcha yAkUb yohan cha philip barthalamayashcha ");
INSERT INTO sanitr_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","mathiH thomA AlphIyasya putro yAkUb jvalantanAmnA khyAtaH shimon ");
INSERT INTO sanitr_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","cha yAkUbo bhrAtA yihUdAshcha taM yaH parakareShu samarpayiShyati sa IShkarIyotIyayihUdAshchaitAn dvAdasha janAn manonItAn kR^itvA sa jagrAha tathA prerita iti teShAM nAma chakAra| ");
INSERT INTO sanitr_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","tataH paraM sa taiH saha parvvatAdavaruhya upatyakAyAM tasthau tatastasya shiShyasa Ngho yihUdAdeshAd yirUshAlamashcha soraH sIdonashcha jaladhe rodhaso jananihAshcha etya tasya kathAshravaNArthaM rogamuktyartha ncha tasya samIpe tasthuH| ");
INSERT INTO sanitr_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","amedhyabhUtagrastAshcha tannikaTamAgatya svAsthyaM prApuH| ");
INSERT INTO sanitr_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","sarvveShAM svAsthyakaraNaprabhAvasya prakAshitatvAt sarvve lokA etya taM spraShTuM yetire| ");
INSERT INTO sanitr_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","pashchAt sa shiShyAn prati dR^iShTiM kutvA jagAda, he daridrA yUyaM dhanyA yata IshvarIye rAjye vo.adhikArosti| ");
INSERT INTO sanitr_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","he adhunA kShudhitalokA yUyaM dhanyA yato yUyaM tarpsyatha; he iha rodino janA yUyaM dhanyA yato yUyaM hasiShyatha| ");
INSERT INTO sanitr_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","yadA lokA manuShyasUno rnAmaheto ryuShmAn R^iृtIyiShyante pR^ithak kR^itvA nindiShyanti, adhamAniva yuShmAn svasamIpAd dUrIkariShyanti cha tadA yUyaM dhanyAH| ");
INSERT INTO sanitr_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","svarge yuShmAkaM yatheShTaM phalaM bhaviShyati, etadarthaM tasmin dine prollasata Anandena nR^ityata cha, teShAM pUrvvapuruShAshcha bhaviShyadvAdinaH prati tathaiva vyavAharan| ");
INSERT INTO sanitr_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","kintu hA hA dhanavanto yUyaM sukhaM prApnuta| hanta paritR^iptA yUyaM kShudhitA bhaviShyatha; ");
INSERT INTO sanitr_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","iha hasanto yUyaM vata yuShmAbhiH shochitavyaM roditavya ncha| ");
INSERT INTO sanitr_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","sarvvailAkai ryuShmAkaM sukhyAtau kR^itAyAM yuShmAkaM durgati rbhaviShyati yuShmAkaM pUrvvapuruShA mR^iShAbhaviShyadvAdinaH prati tadvat kR^itavantaH| ");
INSERT INTO sanitr_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","he shrotAro yuShmabhyamahaM kathayAmi, yUyaM shatruShu prIyadhvaM ye cha yuShmAn dviShanti teShAmapi hitaM kuruta| ");
INSERT INTO sanitr_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ye cha yuShmAn shapanti tebhya AshiShaM datta ye cha yuShmAn avamanyante teShAM ma NgalaM prArthayadhvaM| ");
INSERT INTO sanitr_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","yadi kashchit tava kapole chapeTAghAtaM karoti tarhi taM prati kapolam anyaM parAvarttya sammukhIkuru punashcha yadi kashchit tava gAtrIyavastraM harati tarhi taM paridheyavastram api grahItuM mA vAraya| ");
INSERT INTO sanitr_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","yastvAM yAchate tasmai dehi, yashcha tava sampattiM harati taM mA yAchasva| ");
INSERT INTO sanitr_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","parebhyaH svAn prati yathAcharaNam apekShadhve parAn prati yUyamapi tathAcharata| ");
INSERT INTO sanitr_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","ye janA yuShmAsu prIyante kevalaM teShu prIyamANeShu yuShmAkaM kiM phalaM? pApilokA api sveShu prIyamANeShu prIyante| ");
INSERT INTO sanitr_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","yadi hitakAriNa eva hitaM kurutha tarhi yuShmAkaM kiM phalaM? pApilokA api tathA kurvvanti| ");
INSERT INTO sanitr_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","yebhya R^iNaparishodhasya prAptipratyAshAste kevalaM teShu R^iNe samarpite yuShmAkaM kiM phalaM? punaH prAptyAshayA pApIlokA api pApijaneShu R^iNam arpayanti| ");
INSERT INTO sanitr_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","ato yUyaM ripuShvapi prIyadhvaM, parahitaM kuruta cha; punaH prAptyAshAM tyaktvA R^iNamarpayata, tathA kR^ite yuShmAkaM mahAphalaM bhaviShyati, yUya ncha sarvvapradhAnasya santAnA iti khyAtiM prApsyatha, yato yuShmAkaM pitA kR^itaghnAnAM durvTattAnA ncha hitamAcharati| ");
INSERT INTO sanitr_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ata eva sa yathA dayAlu ryUyamapi tAdR^ishA dayAlavo bhavata| ");
INSERT INTO sanitr_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","apara ncha parAn doShiNo mA kuruta tasmAd yUyaM doShIkR^itA na bhaviShyatha; adaNDyAn mA daNDayata tasmAd yUyamapi daNDaM na prApsyatha; pareShAM doShAn kShamadhvaM tasmAd yuShmAkamapi doShAH kShamiShyante| ");
INSERT INTO sanitr_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","dAnAnidatta tasmAd yUyaM dAnAni prApsyatha, vara ncha lokAH parimANapAtraM pradalayya sa nchAlya pro nchAlya paripUryya yuShmAkaM kroDeShu samarpayiShyanti; yUyaM yena parimANena parimAtha tenaiva parimANena yuShmatkR^ite parimAsyate| ");
INSERT INTO sanitr_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","atha sa tebhyo dR^iShTAntakathAmakathayat, andho janaH kimandhaM panthAnaM darshayituM shaknoti? tasmAd ubhAvapi kiM gartte na patiShyataH? ");
INSERT INTO sanitr_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","guroH shiShyo na shreShThaH kintu shiShye siddhe sati sa gurutulyo bhavituM shaknoti| ");
INSERT INTO sanitr_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","apara ncha tvaM svachakShuुShi nAsAm adR^iShTvA tava bhrAtushchakShuShi yattR^iNamasti tadeva kutaH pashyami? ");
INSERT INTO sanitr_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","svachakShuShi yA nAsA vidyate tAm aj nAtvA, bhrAtastava netrAt tR^iNaM bahiH karomIti vAkyaM bhrAtaraM kathaM vaktuM shaknoShi? he kapaTin pUrvvaM svanayanAt nAsAM bahiH kuru tato bhrAtushchakShuShastR^iNaM bahiH karttuM sudR^iShTiM prApsyasi| ");
INSERT INTO sanitr_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","anya ncha uttamastaruH kadApi phalamanuttamaM na phalati, anuttamatarushcha phalamuttamaM na phalati kAraNAdataH phalaistaravo j nAyante| ");
INSERT INTO sanitr_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","kaNTakipAdapAt kopi uDumbaraphalAni na pAtayati tathA shR^igAlakolivR^ikShAdapi kopi drAkShAphalaM na pAtayati| ");
INSERT INTO sanitr_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","tadvat sAdhuloko.antaHkaraNarUpAt subhANDAgArAd uttamAni dravyANi bahiH karoti, duShTo lokashchAntaHkaraNarUpAt kubhANDAgArAt kutsitAni dravyANi nirgamayati yato.antaHkaraNAnAM pUrNabhAvAnurUpANi vachAMsi mukhAnnirgachChanti| ");
INSERT INTO sanitr_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","apara ncha mamAj nAnurUpaM nAcharitvA kuto mAM prabho prabho iti vadatha? ");
INSERT INTO sanitr_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","yaH kashchin mama nikaTam Agatya mama kathA nishamya tadanurUpaM karmma karoti sa kasya sadR^isho bhavati tadahaM yuShmAn j nAाpayAmi| ");
INSERT INTO sanitr_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","yo jano gabhIraM khanitvA pAShANasthale bhittiM nirmmAya svagR^ihaM rachayati tena saha tasyopamA bhavati; yata AplAvijalametya tasya mUle vegena vahadapi tadgehaM lADayituM na shaknoti yatastasya bhittiH pAShANopari tiShThati| ");
INSERT INTO sanitr_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","kintu yaH kashchin mama kathAH shrutvA tadanurUpaM nAcharati sa bhittiM vinA mR^iृdupari gR^ihanirmmAtrA samAno bhavati; yata AplAvijalamAgatya vegena yadA vahati tadA tadgR^ihaM patati tasya mahat patanaM jAyate| ");
INSERT INTO sanitr_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","tataH paraM sa lokAnAM karNagochare tAn sarvvAn upadeshAn samApya yadA kapharnAhUmpuraM pravishati ");
INSERT INTO sanitr_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","tadA shatasenApateH priyadAsa eko mR^itakalpaH pIDita AsIt| ");
INSERT INTO sanitr_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ataH senApati ryIsho rvArttAM nishamya dAsasyArogyakaraNAya tasyAgamanArthaM vinayakaraNAya yihUdIyAn kiyataH prAchaH preShayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","te yIshorantikaM gatvA vinayAtishayaM vaktumArebhire, sa senApati rbhavatonugrahaM prAptum arhati| ");
INSERT INTO sanitr_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","yataH sosmajjAtIyeShu lokeShu prIyate tathAsmatkR^ite bhajanagehaM nirmmitavAn| ");
INSERT INTO sanitr_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","tasmAd yIshustaiH saha gatvA niveshanasya samIpaM prApa, tadA sa shatasenApati rvakShyamANavAkyaM taM vaktuM bandhUn prAhiNot| he prabho svayaM shramo na karttavyo yad bhavatA madgehamadhye pAdArpaNaM kriyeta tadapyahaM nArhAmi, ");
INSERT INTO sanitr_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ki nchAhaM bhavatsamIpaM yAtumapi nAtmAnaM yogyaM buddhavAn, tato bhavAn vAkyamAtraM vadatu tenaiva mama dAsaH svastho bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","yasmAd ahaM parAdhInopi mamAdhInA yAH senAH santi tAsAm ekajanaM prati yAhIti mayA prokte sa yAti; tadanyaM prati AyAhIti prokte sa AyAti; tathA nijadAsaM prati etat kurvviti prokte sa tadeva karoti| ");
INSERT INTO sanitr_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","yIshuridaM vAkyaM shrutvA vismayaM yayau, mukhaM parAvartya pashchAdvarttino lokAn babhAShe cha, yuShmAnahaM vadAmi isrAyelo vaMshamadhyepi vishvAsamIdR^ishaM na prApnavaM| ");
INSERT INTO sanitr_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","tataste preShitA gR^ihaM gatvA taM pIDitaM dAsaM svasthaM dadR^ishuH| ");
INSERT INTO sanitr_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","pare.ahani sa nAyInAkhyaM nagaraM jagAma tasyAneke shiShyA anye cha lokAstena sArddhaM yayuH| ");
INSERT INTO sanitr_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","teShu tannagarasya dvArasannidhiM prApteShu kiyanto lokA ekaM mR^itamanujaM vahanto nagarasya bahiryAnti, sa tanmAturekaputrastanmAtA cha vidhavA; tayA sArddhaM tannagarIyA bahavo lokA Asan| ");
INSERT INTO sanitr_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","prabhustAM vilokya sAnukampaH kathayAmAsa, mA rodIH| sa samIpamitvA khaTvAM pasparsha tasmAd vAhakAH sthagitAstamyuH; ");
INSERT INTO sanitr_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","tadA sa uvAcha he yuvamanuShya tvamuttiShTha, tvAmaham Aj nApayAmi| ");
INSERT INTO sanitr_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","tasmAt sa mR^ito janastatkShaNamutthAya kathAM prakathitaH; tato yIshustasya mAtari taM samarpayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","tasmAt sarvve lokAH shasha Nkire; eko mahAbhaviShyadvAdI madhye.asmAkam samudait, Ishvarashcha svalokAnanvagR^ihlAt kathAmimAM kathayitvA IshvaraM dhanyaM jagaduH| ");
INSERT INTO sanitr_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","tataH paraM samastaM yihUdAdeshaM tasya chaturdiksthadesha ncha tasyaitatkIrtti rvyAnashe| ");
INSERT INTO sanitr_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","tataH paraM yohanaH shiShyeShu taM tadvR^ittAntaM j nApitavatsu ");
INSERT INTO sanitr_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","sa svashiShyANAM dvau janAvAhUya yIshuM prati vakShyamANaM vAkyaM vaktuM preShayAmAsa, yasyAgamanam apekShya tiShThAmo vayaM kiM sa eva janastvaM? kiM vayamanyamapekShya sthAsyAmaH? ");
INSERT INTO sanitr_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","pashchAttau mAnavau gatvA kathayAmAsatuH, yasyAgamanam apekShya tiShThAmo vayaM, kiM saeva janastvaM? kiM vayamanyamapekShya sthAsyAmaH? kathAmimAM tubhyaM kathayituM yohan majjaka AvAM preShitavAn| ");
INSERT INTO sanitr_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","tasmin daNDe yIshUrogiNo mahAvyAdhimato duShTabhUtagrastAMshcha bahUn svasthAn kR^itvA, anekAndhebhyashchakShuMShi dattvA pratyuvAcha, ");
INSERT INTO sanitr_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","yuvAM vrajatam andhA netrANi kha njAshcharaNAni cha prApnuvanti, kuShThinaH pariShkriyante, badhirAH shravaNAni mR^itAshcha jIvanAni prApnuvanti, daridrANAM samIpeShu susaMvAdaH prachAryyate, yaM prati vighnasvarUpohaM na bhavAmi sa dhanyaH, ");
INSERT INTO sanitr_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","etAni yAni pashyathaH shR^iNuthashcha tAni yohanaM j nApayatam| ");
INSERT INTO sanitr_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","tayo rdUtayo rgatayoH sato ryohani sa lokAn vaktumupachakrame, yUyaM madhyeprAntaraM kiM draShTuM niragamata? kiM vAyunA kampitaM naDaM? ");
INSERT INTO sanitr_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","yUyaM kiM draShTuM niragamata? kiM sUkShmavastraparidhAyinaM kamapi naraM? kintu ye sUkShmamR^iduvastrANi paridadhati sUttamAni dravyANi bhu njate cha te rAjadhAnIShu tiShThanti| ");
INSERT INTO sanitr_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","tarhi yUyaM kiM draShTuM niragamata? kimekaM bhaviShyadvAdinaM? tadeva satyaM kintu sa pumAn bhaviShyadvAdinopi shreShTha ityahaM yuShmAn vadAmi; ");
INSERT INTO sanitr_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","pashya svakIyadUtantu tavAgra preShayAmyahaM| gatvA tvadIyamArgantu sa hi pariShkariShyati| yadarthe lipiriyam Aste sa eva yohan| ");
INSERT INTO sanitr_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","ato yuShmAnahaM vadAmi striyA garbbhajAtAnAM bhaviShyadvAdinAM madhye yohano majjakAt shreShThaH kopi nAsti, tatrApi Ishvarasya rAjye yaH sarvvasmAt kShudraH sa yohanopi shreShThaH| ");
INSERT INTO sanitr_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","apara ncha sarvve lokAH karama nchAyinashcha tasya vAkyAni shrutvA yohanA majjanena majjitAH parameshvaraM nirdoShaM menire| ");
INSERT INTO sanitr_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","kintu phirUshino vyavasthApakAshcha tena na majjitAH svAn pratIshvarasyopadeshaM niShphalam akurvvan| ");
INSERT INTO sanitr_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","atha prabhuH kathayAmAsa, idAnIntanajanAn kenopamAmi? te kasya sadR^ishAH? ");
INSERT INTO sanitr_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ye bAlakA vipaNyAm upavishya parasparam AhUya vAkyamidaM vadanti, vayaM yuShmAkaM nikaTe vaMshIravAdiShma, kintu yUyaM nAnarttiShTa, vayaM yuShmAkaM nikaTa arodiShma, kintu yuyaM na vyalapiShTa, bAlakairetAdR^ishaisteShAm upamA bhavati| ");
INSERT INTO sanitr_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","yato yohan majjaka Agatya pUpaM nAkhAdat drAkShArasa ncha nApivat tasmAd yUyaM vadatha, bhUtagrastoyam| ");
INSERT INTO sanitr_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","tataH paraM mAnavasuta AgatyAkhAdadapiva ncha tasmAd yUyaM vadatha, khAdakaH surApashchANDAlapApinAM bandhureko jano dR^ishyatAm| ");
INSERT INTO sanitr_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","kintu j nAnino j nAnaM nirdoShaM viduH| ");
INSERT INTO sanitr_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","pashchAdekaH phirUshI yIshuM bhojanAya nyamantrayat tataH sa tasya gR^ihaM gatvA bhoktumupaviShTaH| ");
INSERT INTO sanitr_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","etarhi tatphirUshino gR^ihe yIshu rbhektum upAvekShIt tachChrutvA tannagaravAsinI kApi duShTA nArI pANDaraprastarasya sampuTake sugandhitailam AnIya ");
INSERT INTO sanitr_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","tasya pashchAt pAdayoH sannidhau tasyau rudatI cha netrAmbubhistasya charaNau prakShAlya nijakachairamArkShIt, tatastasya charaNau chumbitvA tena sugandhitailena mamarda| ");
INSERT INTO sanitr_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","tasmAt sa nimantrayitA phirUshI manasA chintayAmAsa, yadyayaM bhaviShyadvAdI bhavet tarhi enaM spR^ishati yA strI sA kA kIdR^ishI cheti j nAtuM shaknuyAt yataH sA duShTA| ");
INSERT INTO sanitr_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","tadA yAshustaM jagAda, he shimon tvAM prati mama ki nchid vaktavyamasti; tasmAt sa babhAShe, he guro tad vadatu| ");
INSERT INTO sanitr_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ekottamarNasya dvAvadhamarNAvAstAM, tayorekaH pa nchashatAni mudrApAdAn aparashcha pa nchAshat mudrApAdAn dhArayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","tadanantaraM tayoH shodhyAbhAvAt sa uttamarNastayo rR^iNe chakShame; tasmAt tayordvayoH kastasmin preShyate bahu? tad brUhi| ");
INSERT INTO sanitr_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","shimon pratyuvAcha, mayA budhyate yasyAdhikam R^iNaM chakShame sa iti; tato yIshustaM vyAjahAra, tvaM yathArthaM vyachArayaH| ");
INSERT INTO sanitr_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","atha tAM nArIM prati vyAghuThya shimonamavochat, strImimAM pashyasi? tava gR^ihe mayyAgate tvaM pAdaprakShAlanArthaM jalaM nAdAH kintu yoShideShA nayanajalai rmama pAdau prakShAlya keshairamArkShIt| ");
INSERT INTO sanitr_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","tvaM mAM nAchumbIH kintu yoShideShA svIyAgamanAdArabhya madIyapAdau chumbituM na vyaraMsta| ");
INSERT INTO sanitr_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","tva ncha madIyottamA Nge ki nchidapi tailaM nAmardIH kintu yoShideShA mama charaNau sugandhitailenAmarddIt| ");
INSERT INTO sanitr_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","atastvAM vyAharAmi, etasyA bahu pApamakShamyata tato bahu prIyate kintu yasyAlpapApaM kShamyate solpaM prIyate| ");
INSERT INTO sanitr_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","tataH paraM sa tAM babhAShe, tvadIyaM pApamakShamyata| ");
INSERT INTO sanitr_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","tadA tena sArddhaM ye bhoktum upavivishuste parasparaM vaktumArebhire, ayaM pApaM kShamate ka eShaH? ");
INSERT INTO sanitr_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","kintu sa tAM nArIM jagAda, tava vishvAsastvAM paryyatrAsta tvaM kShemeNa vraja| ");
INSERT INTO sanitr_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","apara ncha yIshu rdvAdashabhiH shiShyaiH sArddhaM nAnAnagareShu nAnAgrAmeShu cha gachChan ishvarIyarAjatvasya susaMvAdaM prachArayituM prArebhe| ");
INSERT INTO sanitr_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","tadA yasyAH sapta bhUtA niragachChan sA magdalInIti vikhyAtA mariyam herodrAjasya gR^ihAdhipateH hoShe rbhAryyA yohanA shUshAnA ");
INSERT INTO sanitr_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","prabhR^itayo yA bahvyaH striyaH duShTabhUtebhyo rogebhyashcha muktAH satyo nijavibhUtI rvyayitvA tamasevanta, tAH sarvvAstena sArddham Asan| ");
INSERT INTO sanitr_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","anantaraM nAnAnagarebhyo bahavo lokA Agatya tasya samIpe.amilan, tadA sa tebhya ekAM dR^iShTAntakathAM kathayAmAsa| ekaH kR^iShIbalo bIjAni vaptuM bahirjagAma, ");
INSERT INTO sanitr_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","tato vapanakAle katipayAni bIjAni mArgapArshve petuH, tatastAni padatalai rdalitAni pakShibhi rbhakShitAni cha| ");
INSERT INTO sanitr_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","katipayAni bIjAni pAShANasthale patitAni yadyapi tAnya NkuritAni tathApi rasAbhAvAt shushuShuH| ");
INSERT INTO sanitr_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","katipayAni bIjAni kaNTakivanamadhye patitAni tataH kaNTakivanAni saMvR^iddhya tAni jagrasuH| ");
INSERT INTO sanitr_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","tadanyAni katipayabIjAni cha bhUmyAmuttamAyAM petustatastAnya NkurayitvA shataguNAni phalAni pheluH| sa imA kathAM kathayitvA prochchaiH provAcha, yasya shrotuM shrotre staH sa shR^iNotu| ");
INSERT INTO sanitr_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","tataH paraM shiShyAstaM paprachChurasya dR^iShTAntasya kiM tAtparyyaM? ");
INSERT INTO sanitr_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","tataH sa vyAjahAra, IshvarIyarAjyasya guhyAni j nAtuM yuShmabhyamadhikAro dIyate kintvanye yathA dR^iShTvApi na pashyanti shrutvApi ma budhyante cha tadarthaM teShAM purastAt tAH sarvvAH kathA dR^iShTAntena kathyante| ");
INSERT INTO sanitr_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","dR^iShTAntasyAsyAbhiprAyaH, IshvarIyakathA bIjasvarUpA| ");
INSERT INTO sanitr_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ye kathAmAtraM shR^iNvanti kintu pashchAd vishvasya yathA paritrANaM na prApnuvanti tadAshayena shaitAnetya hR^idayAtR^i tAM kathAm apaharati ta eva mArgapArshvasthabhUmisvarUpAH| ");
INSERT INTO sanitr_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ye kathaM shrutvA sAnandaM gR^ihlanti kintvabaddhamUlatvAt svalpakAlamAtraM pratItya parIkShAkAle bhrashyanti taeva pAShANabhUmisvarUpAH| ");
INSERT INTO sanitr_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ye kathAM shrutvA yAnti viShayachintAyAM dhanalobhena eेhikasukhe cha majjanta upayuktaphalAni na phalanti ta evoptabIjakaNTakibhUsvarUpAH| ");
INSERT INTO sanitr_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","kintu ye shrutvA saralaiH shuddhaishchAntaHkaraNaiH kathAM gR^ihlanti dhairyyam avalambya phalAnyutpAdayanti cha ta evottamamR^itsvarUpAH| ");
INSERT INTO sanitr_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","apara ncha pradIpaM prajvAlya kopi pAtreNa nAchChAdayati tathA khaTvAdhopi na sthApayati, kintu dIpAdhAroparyyeva sthApayati, tasmAt praveshakA dIptiM pashyanti| ");
INSERT INTO sanitr_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","yanna prakAshayiShyate tAdR^ig aprakAshitaM vastu kimapi nAsti yachcha na suvyaktaM prachArayiShyate tAdR^ig gR^iptaM vastu kimapi nAsti| ");
INSERT INTO sanitr_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","ato yUyaM kena prakAreNa shR^iNutha tatra sAvadhAnA bhavata, yasya samIpe barddhate tasmai punardAsyate kintu yasyAshraye na barddhate tasya yadyadasti tadapi tasmAt neShyate| ");
INSERT INTO sanitr_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","apara ncha yIsho rmAtA bhrAtarashcha tasya samIpaM jigamiShavaH ");
INSERT INTO sanitr_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","kintu janatAsambAdhAt tatsannidhiM prAptuM na shekuH| tatpashchAt tava mAtA bhrAtarashcha tvAM sAkShAt chikIrShanto bahistiShThanatIti vArttAyAM tasmai kathitAyAM ");
INSERT INTO sanitr_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","sa pratyuvAcha; ye janA Ishvarasya kathAM shrutvA tadanurUpamAcharanti taeva mama mAtA bhrAtarashcha| ");
INSERT INTO sanitr_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","anantaraM ekadA yIshuH shiShyaiH sArddhaM nAvamAruhya jagAda, AyAta vayaM hradasya pAraM yAmaH, tataste jagmuH| ");
INSERT INTO sanitr_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","teShu naukAM vAhayatsu sa nidadrau; ");
INSERT INTO sanitr_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","athAkasmAt prabalajha nbhshagamAd hrade naukAyAM tara NgairAchChannAyAM vipat tAn jagrAsa|tasmAd yIshorantikaM gatvA he guro he guro prANA no yAntIti gaditvA taM jAgarayAmbabhUvuH|tadA sa utthAya vAyuM tara NgAMshcha tarjayAmAsa tasmAdubhau nivR^itya sthirau babhUvatuH| ");
INSERT INTO sanitr_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","sa tAn babhAShe yuShmAkaM vishvAsaH ka? tasmAtte bhItA vismitAshcha parasparaM jagaduH, aho kIdR^igayaM manujaH pavanaM pAnIya nchAdishati tadubhayaM tadAdeshaM vahati| ");
INSERT INTO sanitr_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","tataH paraM gAlIlpradeshasya sammukhasthagiderIyapradeshe naukAyAM lagantyAM taTe.avarohamAvAd ");
INSERT INTO sanitr_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","bahutithakAlaM bhUtagrasta eko mAnuShaH purAdAgatya taM sAkShAchchakAra| sa manuSho vAso na paridadhat gR^ihe cha na vasan kevalaM shmashAnam adhyuvAsa| ");
INSERT INTO sanitr_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","sa yIshuM dR^iShTvaiva chIchChabdaM chakAra tasya sammukhe patitvA prochchairjagAda cha, he sarvvapradhAneshvarasya putra, mayA saha tava kaH sambandhaH? tvayi vinayaM karomi mAM mA yAtaya| ");
INSERT INTO sanitr_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","yataH sa taM mAnuShaM tyaktvA yAtum amedhyabhUtam Adidesha; sa bhUtastaM mAnuSham asakR^id dadhAra tasmAllokAH shR^i Nkhalena nigaDena cha babandhuH; sa tad bhaMktvA bhUtavashatvAt madhyeprAntaraM yayau| ");
INSERT INTO sanitr_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","anantaraM yIshustaM paprachCha tava kinnAma? sa uvAcha, mama nAma bAhino yato bahavo bhUtAstamAshishriyuH| ");
INSERT INTO sanitr_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","atha bhUtA vinayena jagaduH, gabhIraM garttaM gantuM mAj nApayAsmAn| ");
INSERT INTO sanitr_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","tadA parvvatopari varAhavrajashcharati tasmAd bhUtA vinayena prochuH, amuM varAhavrajam Ashrayitum asmAn anujAnIhi; tataH sonujaj nau| ");
INSERT INTO sanitr_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","tataH paraM bhUtAstaM mAnuShaM vihAya varAhavrajam AshishriyuH varAhavrajAshcha tatkShaNAt kaTakena dhAvanto hrade prANAn vijR^ihuH| ");
INSERT INTO sanitr_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","tad dR^iShTvA shUkararakShakAH palAyamAnA nagaraM grAma ncha gatvA tatsarvvavR^ittAntaM kathayAmAsuH| ");
INSERT INTO sanitr_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","tataH kiM vR^ittam etaddarshanArthaM lokA nirgatya yIshoH samIpaM yayuH, taM mAnuShaM tyaktabhUtaM parihitavastraM svasthamAnuShavad yIshoshcharaNasannidhau sUpavishantaM vilokya bibhyuH| ");
INSERT INTO sanitr_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ye lokAstasya bhUtagrastasya svAsthyakaraNaM dadR^ishuste tebhyaH sarvvavR^ittAntaM kathayAmAsuH| ");
INSERT INTO sanitr_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","tadanantaraM tasya giderIyapradeshasya chaturdiksthA bahavo janA atitrastA vinayena taM jagaduH, bhavAn asmAkaM nikaTAd vrajatu tasmAt sa nAvamAruhya tato vyAghuTya jagAma| ");
INSERT INTO sanitr_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","tadAnIM tyaktabhUtamanujastena saha sthAtuM prArthayA nchakre ");
INSERT INTO sanitr_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","kintu tadartham IshvaraH kIdR^i NmahAkarmma kR^itavAn iti niveshanaM gatvA vij nApaya, yIshuH kathAmetAM kathayitvA taM visasarja| tataH sa vrajitvA yIshustadarthaM yanmahAkarmma chakAra tat purasya sarvvatra prakAshayituM prArebhe| ");
INSERT INTO sanitr_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","atha yIshau parAvR^ityAgate lokAstaM AdareNa jagR^ihu ryasmAtte sarvve tamapekShA nchakrire| ");
INSERT INTO sanitr_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","tadanantaraM yAyIrnAmno bhajanagehasyaikodhipa Agatya yIshoshcharaNayoH patitvA svaniveshanAgamanArthaM tasmin vinayaM chakAra, ");
INSERT INTO sanitr_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","yatastasya dvAdashavarShavayaskA kanyaikAsIt sA mR^itakalpAbhavat| tatastasya gamanakAle mArge lokAnAM mahAn samAgamo babhUva| ");
INSERT INTO sanitr_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","dvAdashavarShANi pradararogagrastA nAnA vaidyaishchikitsitA sarvvasvaM vyayitvApi svAsthyaM na prAptA yA yoShit sA yIshoH pashchAdAgatya tasya vastragranthiM pasparsha| ");
INSERT INTO sanitr_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","tasmAt tatkShaNAt tasyA raktasrAvo ruddhaH| ");
INSERT INTO sanitr_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","tadAnIM yIshuravadat kenAhaM spR^iShTaH? tato.anekairana NgIkR^ite pitarastasya sa NginashchAvadan, he guro lokA nikaTasthAH santastava dehe gharShayanti, tathApi kenAhaM spR^iShTa_iti bhavAn kutaH pR^ichChati? ");
INSERT INTO sanitr_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","yIshuH kathayAmAsa, kenApyahaM spR^iShTo, yato mattaH shakti rnirgateti mayA nishchitamaj nAyi| ");
INSERT INTO sanitr_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","tadA sA nArI svayaM na gupteti viditvA kampamAnA satI tasya sammukhe papAta; yena nimittena taM pasparsha sparshamAtrAchcha yena prakAreNa svasthAbhavat tat sarvvaM tasya sAkShAdAchakhyau| ");
INSERT INTO sanitr_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","tataH sa tAM jagAda he kanye susthirA bhava, tava vishvAsastvAM svasthAm akArShIt tvaM kShemeNa yAhi| ");
INSERT INTO sanitr_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","yIshoretadvAkyavadanakAle tasyAdhipate rniveshanAt kashchilloka Agatya taM babhAShe, tava kanyA mR^itA guruM mA klishAna| ");
INSERT INTO sanitr_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","kintu yIshustadAkarNyAdhipatiM vyAjahAra, mA bhaiShIH kevalaM vishvasihi tasmAt sA jIviShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","atha tasya niveshane prApte sa pitaraM yohanaM yAkUba ncha kanyAyA mAtaraM pitara ncha vinA, anyaM ka nchana praveShTuM vArayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","apara ncha ye rudanti vilapanti cha tAn sarvvAn janAn uvAcha, yUyaM mA rodiShTa kanyA na mR^itA nidrAti| ");
INSERT INTO sanitr_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","kintu sA nishchitaM mR^iteti j nAtvA te tamupajahasuH| ");
INSERT INTO sanitr_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","pashchAt sa sarvvAn bahiH kR^itvA kanyAyAH karau dhR^itvAjuhuve, he kanye tvamuttiShTha, ");
INSERT INTO sanitr_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","tasmAt tasyAH prANeShu punarAgateShu sA tatkShaNAd uttasyau| tadAnIM tasyai ki nchid bhakShyaM dAtum Adidesha| ");
INSERT INTO sanitr_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","tatastasyAH pitarau vismayaM gatau kintu sa tAvAdidesha ghaTanAyA etasyAH kathAM kasmaichidapi mA kathayataM| ");
INSERT INTO sanitr_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","tataH paraM sa dvAdashashiShyAnAhUya bhUtAn tyAjayituM rogAn pratikarttu ncha tebhyaH shaktimAdhipatya ncha dadau| ");
INSERT INTO sanitr_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","apara ncha IshvarIyarAjyasya susaMvAdaM prakAshayitum rogiNAmArogyaM karttu ncha preraNakAle tAn jagAda| ");
INSERT INTO sanitr_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","yAtrArthaM yaShTi rvastrapuTakaM bhakShyaM mudrA dvitIyavastram, eShAM kimapi mA gR^ihlIta| ");
INSERT INTO sanitr_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","yUya ncha yanniveshanaM pravishatha nagaratyAgaparyyanataM tanniveshane tiShThata| ");
INSERT INTO sanitr_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","tatra yadi kasyachit purasya lokA yuShmAkamAtithyaM na kurvvanti tarhi tasmAnnagarAd gamanakAle teShAM viruddhaM sAkShyArthaM yuShmAkaM padadhUlIH sampAtayata| ");
INSERT INTO sanitr_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","atha te prasthAya sarvvatra susaMvAdaM prachArayituM pIDitAn svasthAn karttu ncha grAmeShu bhramituM prArebhire| ");
INSERT INTO sanitr_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","etarhi herod rAjA yIshoH sarvvakarmmaNAM vArttAM shrutvA bhR^ishamudvivije ");
INSERT INTO sanitr_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","yataH kechidUchuryohan shmashAnAdudatiShThat| kechidUchuH, eliyo darshanaM dattavAn; evamanyalokA UchuH pUrvvIyaH kashchid bhaviShyadvAdI samutthitaH| ");
INSERT INTO sanitr_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","kintu heroduvAcha yohanaH shiro.ahamaChinadam idAnIM yasyedR^ikkarmmaNAM vArttAM prApnomi sa kaH? atha sa taM draShTum aichChat| ");
INSERT INTO sanitr_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","anantaraM preritAH pratyAgatya yAni yAni karmmANi chakrustAni yIshave kathayAmAsuH tataH sa tAn baitsaidAnAmakanagarasya vijanaM sthAnaM nItvA guptaM jagAma| ");
INSERT INTO sanitr_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","pashchAl lokAstad viditvA tasya pashchAd yayuH; tataH sa tAn nayan IshvarIyarAjyasya prasa NgamuktavAn, yeShAM chikitsayA prayojanam AsIt tAn svasthAn chakAra cha| ");
INSERT INTO sanitr_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","apara ncha divAvasanne sati dvAdashashiShyA yIshorantikam etya kathayAmAsuH, vayamatra prAntarasthAne tiShThAmaH, tato nagarANi grAmANi gatvA vAsasthAnAni prApya bhakShyadravyANi kretuM jananivahaM bhavAn visR^ijatu| ");
INSERT INTO sanitr_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","tadA sa uvAcha, yUyameva tAn bhejayadhvaM; tataste prochurasmAkaM nikaTe kevalaM pa ncha pUpA dvau matsyau cha vidyante, ataeva sthAnAntaram itvA nimittameteShAM bhakShyadravyeShu na krIteShu na bhavati| ");
INSERT INTO sanitr_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","tatra prAyeNa pa nchasahasrANi puruShA Asan| ");
INSERT INTO sanitr_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","tadA sa shiShyAn jagAda pa nchAshat pa nchAshajjanaiH paMktIkR^itya tAnupaveshayata, tasmAt te tadanusAreNa sarvvalokAnupaveshayApAsuH| ");
INSERT INTO sanitr_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","tataH sa tAn pa ncha pUpAn mInadvaya ncha gR^ihItvA svargaM vilokyeshvaraguNAn kIrttayA nchakre bha NktA cha lokebhyaH pariveShaNArthaM shiShyeShu samarpayAmbabhUva| ");
INSERT INTO sanitr_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","tataH sarvve bhuktvA tR^iptiM gatA avashiShTAnA ncha dvAdasha DallakAn saMjagR^ihuH| ");
INSERT INTO sanitr_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","athaikadA nirjane shiShyaiH saha prArthanAkAle tAn paprachCha, lokA mAM kaM vadanti? ");
INSERT INTO sanitr_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","tataste prAchuH, tvAM yohanmajjakaM vadanti; kechit tvAm eliyaM vadanti, pUrvvakAlikaH kashchid bhaviShyadvAdI shmashAnAd udatiShThad ityapi kechid vadanti| ");
INSERT INTO sanitr_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","tadA sa uvAcha, yUyaM mAM kaM vadatha? tataH pitara uktavAn tvam IshvarAbhiShiktaH puruShaH| ");
INSERT INTO sanitr_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","tadA sa tAn dR^iDhamAdidesha, kathAmetAM kasmaichidapi mA kathayata| ");
INSERT INTO sanitr_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","sa punaruvAcha, manuShyaputreNa vahuyAtanA bhoktavyAH prAchInalokaiH pradhAnayAjakairadhyApakaishcha sovaj nAya hantavyaH kintu tR^itIyadivase shmashAnAt tenotthAtavyam| ");
INSERT INTO sanitr_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","aparaM sa sarvvAnuvAcha, kashchid yadi mama pashchAd gantuM vA nChati tarhi sa svaM dAmyatu, dine dine krushaM gR^ihItvA cha mama pashchAdAgachChatu| ");
INSERT INTO sanitr_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","yato yaH kashchit svaprANAn rirakShiShati sa tAn hArayiShyati, yaH kashchin madarthaM prANAn hArayiShyati sa tAn rakShiShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","kashchid yadi sarvvaM jagat prApnoti kintu svaprANAn hArayati svayaM vinashyati cha tarhi tasya ko lAbhaH? ");
INSERT INTO sanitr_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","puna ryaH kashchin mAM mama vAkyaM vA lajjAspadaM jAnAti manuShyaputro yadA svasya pitushcha pavitrANAM dUtAnA ncha tejobhiH pariveShTita AgamiShyati tadA sopi taM lajjAspadaM j nAsyati| ");
INSERT INTO sanitr_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","kintu yuShmAnahaM yathArthaM vadAmi, IshvarIyarAjatvaM na dR^iShTavA mR^ityuM nAsvAdiShyante, etAdR^ishAH kiyanto lokA atra sthane.api daNDAyamAnAH santi| ");
INSERT INTO sanitr_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","etadAkhyAnakathanAt paraM prAyeNAShTasu dineShu gateShu sa pitaraM yohanaM yAkUba ncha gR^ihItvA prArthayituM parvvatamekaM samAruroha| ");
INSERT INTO sanitr_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","atha tasya prArthanakAle tasya mukhAkR^itiranyarUpA jAtA, tadIyaM vastramujjvalashuklaM jAtaM| ");
INSERT INTO sanitr_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","apara ncha mUsA eliyashchobhau tejasvinau dR^iShTau ");
INSERT INTO sanitr_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","tau tena yirUshAlampure yo mR^ityuH sAdhiShyate tadIyAM kathAM tena sArddhaM kathayitum ArebhAte| ");
INSERT INTO sanitr_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","tadA pitarAdayaH svasya sa Ngino nidrayAkR^iShTA Asan kintu jAgaritvA tasya tejastena sArddham uttiShThantau janau cha dadR^ishuH| ");
INSERT INTO sanitr_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","atha tayorubhayo rgamanakAle pitaro yIshuM babhAShe, he guro.asmAkaM sthAne.asmin sthitiH shubhA, tata ekA tvadarthA, ekA mUsArthA, ekA eliyArthA, iti tisraH kuTyosmAbhi rnirmmIyantAM, imAM kathAM sa na vivichya kathayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","apara ncha tadvAkyavadanakAle payoda eka Agatya teShAmupari ChAyAM chakAra, tatastanmadhye tayoH praveshAt te shasha Nkire| ");
INSERT INTO sanitr_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","tadA tasmAt payodAd iyamAkAshIyA vANI nirjagAma, mamAyaM priyaH putra etasya kathAyAM mano nidhatta| ");
INSERT INTO sanitr_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","iti shabde jAte te yIshumekAkinaM dadR^ishuH kintu te tadAnIM tasya darshanasya vAchamekAmapi noktvA manaHsu sthApayAmAsuH| ");
INSERT INTO sanitr_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","pare.ahani teShu tasmAchChailAd avarUDheShu taM sAkShAt karttuM bahavo lokA AjagmuH| ");
INSERT INTO sanitr_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","teShAM madhyAd eko jana uchchairuvAcha, he guro ahaM vinayaM karomi mama putraM prati kR^ipAdR^iShTiM karotu, mama sa evaikaH putraH| ");
INSERT INTO sanitr_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","bhUtena dhR^itaH san saM prasabhaM chIchChabdaM karoti tanmukhAt pheNA nirgachChanti cha, bhUta itthaM vidAryya kliShTvA prAyashastaM na tyajati| ");
INSERT INTO sanitr_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","tasmAt taM bhUtaM tyAjayituM tava shiShyasamIpe nyavedayaM kintu te na shekuH| ");
INSERT INTO sanitr_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","tadA yIshuravAdIt, re AvishvAsin vipathagAmin vaMsha katikAlAn yuShmAbhiH saha sthAsyAmyahaM yuShmAkam AcharaNAni cha sahiShye? tava putramihAnaya| ");
INSERT INTO sanitr_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","tatastasminnAgatamAtre bhUtastaM bhUmau pAtayitvA vidadAra; tadA yIshustamamedhyaM bhUtaM tarjayitvA bAlakaM svasthaM kR^itvA tasya pitari samarpayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ishvarasya mahAshaktim imAM vilokya sarvve chamachchakruH; itthaM yIshoH sarvvAbhiH kriyAbhiH sarvvairlokairAshcharyye manyamAne sati sa shiShyAn babhAShe, ");
INSERT INTO sanitr_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","katheyaM yuShmAkaM karNeShu pravishatu, manuShyaputro manuShyANAM kareShu samarpayiShyate| ");
INSERT INTO sanitr_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","kintu te tAM kathAM na bubudhire, spaShTatvAbhAvAt tasyA abhiprAyasteShAM bodhagamyo na babhUva; tasyA AshayaH ka ityapi te bhayAt praShTuM na shekuH| ");
INSERT INTO sanitr_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","tadanantaraM teShAM madhye kaH shreShThaH kathAmetAM gR^ihItvA te mitho vivAdaM chakruH| ");
INSERT INTO sanitr_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","tato yIshusteShAM manobhiprAyaM viditvA bAlakamekaM gR^ihItvA svasya nikaTe sthApayitvA tAn jagAda, ");
INSERT INTO sanitr_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","yo jano mama nAmnAsya bAlAsyAtithyaM vidadhAti sa mamAtithyaM vidadhAti, yashcha mamAtithyaM vidadhAti sa mama prerakasyAtithyaM vidadhAti, yuShmAkaM madhyeyaH svaM sarvvasmAt kShudraM jAnIte sa eva shreShTho bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","apara ncha yohan vyAjahAra he prabheा tava nAmnA bhUtAn tyAjayantaM mAnuSham ekaM dR^iShTavanto vayaM, kintvasmAkam apashchAd gAmitvAt taM nyaShedhAm| tadAnIM yIshuruvAcha, ");
INSERT INTO sanitr_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","taM mA niShedhata, yato yo janosmAkaM na vipakShaH sa evAsmAkaM sapakSho bhavati| ");
INSERT INTO sanitr_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","anantaraM tasyArohaNasamaya upasthite sa sthirachetA yirUshAlamaM prati yAtrAM karttuM nishchityAgre dUtAn preShayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","tasmAt te gatvA tasya prayojanIyadravyANi saMgrahItuM shomiroNIyAnAM grAmaM pravivishuH| ");
INSERT INTO sanitr_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","kintu sa yirUshAlamaM nagaraM yAti tato heto rlokAstasyAtithyaM na chakruH| ");
INSERT INTO sanitr_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ataeva yAkUbyohanau tasya shiShyau tad dR^iShTvA jagadatuH, he prabho eliyo yathA chakAra tathA vayamapi kiM gagaNAd Agantum etAn bhasmIkarttu ncha vahnimAj nApayAmaH? bhavAn kimichChati? ");
INSERT INTO sanitr_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","kintu sa mukhaM parAvartya tAn tarjayitvA gaditavAn yuShmAkaM manobhAvaH kaH, iti yUyaM na jAnItha| ");
INSERT INTO sanitr_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","manujasuto manujAnAM prANAn nAshayituM nAgachChat, kintu rakShitum AgachChat| pashchAd itaragrAmaM te yayuH| ");
INSERT INTO sanitr_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","tadanantaraM pathi gamanakAle jana ekastaM babhAShe, he prabho bhavAn yatra yAti bhavatA sahAhamapi tatra yAsyAmi| ");
INSERT INTO sanitr_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","tadAnIM yIshustamuvAcha, gomAyUnAM garttA Asate, vihAyasIyavihagAाnAM nIDAni cha santi, kintu mAnavatanayasya shiraH sthApayituM sthAnaM nAsti| ");
INSERT INTO sanitr_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","tataH paraM sa itarajanaM jagAda, tvaM mama pashchAd ehi; tataH sa uvAcha, he prabho pUrvvaM pitaraM shmashAne sthApayituM mAmAdishatu| ");
INSERT INTO sanitr_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","tadA yIshuruvAcha, mR^itA mR^itAn shmashAne sthApayantu kintu tvaM gatveshvarIyarAjyasya kathAM prachAraya| ");
INSERT INTO sanitr_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","tatonyaH kathayAmAsa, he prabho mayApi bhavataH pashchAd gaMsyate, kintu pUrvvaM mama niveshanasya parijanAnAm anumatiM grahItum ahamAdishyai bhavatA| ");
INSERT INTO sanitr_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","tadAnIM yIshustaM proktavAn, yo jano lA Ngale karamarpayitvA pashchAt pashyati sa IshvarIyarAjyaM nArhati| ");
INSERT INTO sanitr_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","tataH paraM prabhuraparAn saptatishiShyAn niyujya svayaM yAni nagarANi yAni sthAnAni cha gamiShyati tAni nagarANi tAni sthAnAni cha prati dvau dvau janau prahitavAn| ");
INSERT INTO sanitr_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","tebhyaH kathayAmAsa cha shasyAni bahUnIti satyaM kintu ChedakA alpe; tasmAddhetoH shasyakShetre ChedakAn aparAnapi preShayituM kShetrasvAminaM prArthayadhvaM| ");
INSERT INTO sanitr_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","yUyaM yAta, pashyata, vR^ikANAM madhye meShashAvakAniva yuShmAn prahiNomi| ");
INSERT INTO sanitr_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","yUyaM kShudraM mahad vA vasanasampuTakaM pAdukAshcha mA gR^ihlIta, mArgamadhye kamapi mA namata cha| ");
INSERT INTO sanitr_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","apara ncha yUyaM yad yat niveshanaM pravishatha tatra niveshanasyAsya ma NgalaM bhUyAditi vAkyaM prathamaM vadata| ");
INSERT INTO sanitr_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","tasmAt tasmin niveshane yadi ma NgalapAtraM sthAsyati tarhi tanma NgalaM tasya bhaviShyati, nochet yuShmAn prati parAvarttiShyate| ");
INSERT INTO sanitr_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","apara ncha te yatki nchid dAsyanti tadeva bhuktvA pItvA tasminniveshane sthAsyatha; yataH karmmakArI jano bhR^itim arhati; gR^ihAd gR^ihaM mA yAsyatha| ");
INSERT INTO sanitr_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","anyachcha yuShmAsu kimapi nagaraM praviShTeShu lokA yadi yuShmAkam AtithyaM kariShyanti, tarhi yat khAdyam upasthAsyanti tadeva khAdiShyatha| ");
INSERT INTO sanitr_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","tannagarasthAn rogiNaH svasthAn kariShyatha, IshvarIyaM rAjyaM yuShmAkam antikam Agamat kathAmetA ncha prachArayiShyatha| ");
INSERT INTO sanitr_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","kintu kimapi puraM yuShmAsu praviShTeShu lokA yadi yuShmAkam AtithyaM na kariShyanti, tarhi tasya nagarasya panthAnaM gatvA kathAmetAM vadiShyatha, ");
INSERT INTO sanitr_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","yuShmAkaM nagarIyA yA dhUlyo.asmAsu samalagan tA api yuShmAkaM prAtikUlyena sAkShyArthaM sampAtayAmaH; tathApIshvararAjyaM yuShmAkaM samIpam Agatam iti nishchitaM jAnIta| ");
INSERT INTO sanitr_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","ahaM yuShmabhyaM yathArthaM kathayAmi, vichAradine tasya nagarasya dashAtaH sidomo dashA sahyA bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","hA hA korAsIn nagara, hA hA baitsaidAnagara yuvayormadhye yAdR^ishAni AshcharyyANi karmmANyakriyanta, tAni karmmANi yadi sorasIdono rnagarayorakAriShyanta, tadA ito bahudinapUrvvaM tannivAsinaH shaNavastrANi paridhAya gAtreShu bhasma vilipya samupavishya samakhetsyanta| ");
INSERT INTO sanitr_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","ato vichAradivase yuShmAkaM dashAtaH sorasIdonnivAsinAM dashA sahyA bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","he kapharnAhUm, tvaM svargaM yAvad unnatA kintu narakaM yAvat nyagbhaviShyasi| ");
INSERT INTO sanitr_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","yo jano yuShmAkaM vAkyaM gR^ihlAti sa mamaiva vAkyaM gR^ihlAti; ki ncha yo jano yuShmAkam avaj nAM karoti sa mamaivAvaj nAM karoti; yo jano mamAvaj nAM karoti cha sa matprerakasyaivAvaj nAM karoti| ");
INSERT INTO sanitr_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","atha te saptatishiShyA Anandena pratyAgatya kathayAmAsuH, he prabho bhavato nAmnA bhUtA apyasmAkaM vashIbhavanti| ");
INSERT INTO sanitr_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","tadAnIM sa tAn jagAda, vidyutamiva svargAt patantaM shaitAnam adarsham| ");
INSERT INTO sanitr_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","pashyata sarpAn vR^ishchikAn ripoH sarvvaparAkramAMshcha padatalai rdalayituM yuShmabhyaM shaktiM dadAmi tasmAd yuShmAkaM kApi hAni rna bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","bhUtA yuShmAkaM vashIbhavanti, etannimittat mA samullasata, svarge yuShmAkaM nAmAni likhitAni santIti nimittaM samullasata| ");
INSERT INTO sanitr_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","tadghaTikAyAM yIshu rmanasi jAtAhlAdaH kathayAmAsa he svargapR^ithivyorekAdhipate pitastvaM j nAnavatAM viduShA ncha lokAnAM purastAt sarvvametad aprakAshya bAlakAnAM purastAt prAkAshaya etasmAddhetostvAM dhanyaM vadAmi, he pitaritthaM bhavatu yad etadeva tava gochara uttamam| ");
INSERT INTO sanitr_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","pitrA sarvvANi mayi samarpitAni pitaraM vinA kopi putraM na jAnAti ki ncha putraM vinA yasmai janAya putrastaM prakAshitavAn ta ncha vinA kopi pitaraM na jAnAti| ");
INSERT INTO sanitr_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","tapaH paraM sa shiShyAn prati parAvR^itya guptaM jagAda, yUyametAni sarvvANi pashyatha tato yuShmAkaM chakShUMShi dhanyAni| ");
INSERT INTO sanitr_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","yuShmAnahaM vadAmi, yUyaM yAni sarvvANi pashyatha tAni bahavo bhaviShyadvAdino bhUpatayashcha draShTumichChantopi draShTuM na prApnuvan, yuShmAbhi ryA yAH kathAshcha shrUyante tAH shrotumichChantopi shrotuM nAlabhanta| ");
INSERT INTO sanitr_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","anantaram eko vyavasthApaka utthAya taM parIkShituM paprachCha, he upadeshaka anantAyuShaH prAptaye mayA kiM karaNIyaM? ");
INSERT INTO sanitr_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","yIshuH pratyuvAcha, atrArthe vyavasthAyAM kiM likhitamasti? tvaM kIdR^ik paThasi? ");
INSERT INTO sanitr_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","tataH sovadat, tvaM sarvvAntaHkaraNaiH sarvvaprANaiH sarvvashaktibhiH sarvvachittaishcha prabhau parameshvare prema kuru, samIpavAsini svavat prema kuru cha| ");
INSERT INTO sanitr_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","tadA sa kathayAmAsa, tvaM yathArthaM pratyavochaH, ittham Achara tenaiva jIviShyasi| ");
INSERT INTO sanitr_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","kintu sa janaH svaM nirddoShaM j nApayituM yIshuM paprachCha, mama samIpavAsI kaH? tato yIshuH pratyuvAcha, ");
INSERT INTO sanitr_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","eko jano yirUshAlampurAd yirIhopuraM yAti, etarhi dasyUnAM kareShu patite te tasya vastrAdikaM hR^itavantaH tamAhatya mR^itaprAyaM kR^itvA tyaktvA yayuH| ");
INSERT INTO sanitr_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","akasmAd eko yAjakastena mArgeNa gachChan taM dR^iShTvA mArgAnyapArshvena jagAma| ");
INSERT INTO sanitr_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ittham eko levIyastatsthAnaM prApya tasyAntikaM gatvA taM vilokyAnyena pArshvena jagAma| ");
INSERT INTO sanitr_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","kintvekaH shomiroNIyo gachChan tatsthAnaM prApya taM dR^iShTvAdayata| ");
INSERT INTO sanitr_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","tasyAntikaM gatvA tasya kShateShu tailaM drAkShArasa ncha prakShipya kShatAni baddhvA nijavAhanopari tamupaveshya pravAsIyagR^iham AnIya taM siSheve| ");
INSERT INTO sanitr_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","parasmin divase nijagamanakAle dvau mudrApAdau tadgR^ihasvAmine dattvAvadat janamenaM sevasva tatra yo.adhiko vyayo bhaviShyati tamahaM punarAgamanakAle parishotsyAmi| ");
INSERT INTO sanitr_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","eShAM trayANAM madhye tasya dasyuhastapatitasya janasya samIpavAsI kaH? tvayA kiM budhyate? ");
INSERT INTO sanitr_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","tataH sa vyavasthApakaH kathayAmAsa yastasmin dayAM chakAra| tadA yIshuH kathayAmAsa tvamapi gatvA tathAchara| ");
INSERT INTO sanitr_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","tataH paraM te gachChanta ekaM grAmaM pravivishuH; tadA marthAnAmA strI svagR^ihe tasyAtithyaM chakAra| ");
INSERT INTO sanitr_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","tasmAt mariyam nAmadheyA tasyA bhaginI yIshoH padasamIpa uvavishya tasyopadeshakathAM shrotumArebhe| ");
INSERT INTO sanitr_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","kintu marthA nAnAparicharyyAyAM vyagrA babhUva tasmAddhetostasya samIpamAgatya babhAShe; he prabho mama bhaginI kevalaM mamopari sarvvakarmmaNAM bhAram arpitavatI tatra bhavatA ki nchidapi na mano nidhIyate kim? mama sAhAyyaM karttuM bhavAn tAmAdishatu| ");
INSERT INTO sanitr_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","tato yIshuH pratyuvAcha he marthe he marthe, tvaM nAnAkAryyeShu chintitavatI vyagrA chAsi, ");
INSERT INTO sanitr_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","kintu prayojanIyam ekamAtram Aste| apara ncha yamuttamaM bhAgaM kopi harttuM na shaknoti saeva mariyamA vR^itaH| ");
INSERT INTO sanitr_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","anantaraM sa kasmiMshchit sthAne prArthayata tatsamAptau satyAM tasyaikaH shiShyastaM jagAda he prabho yohan yathA svashiShyAn prArthayitum upadiShTavAn tathA bhavAnapyasmAn upadishatu| ");
INSERT INTO sanitr_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","tasmAt sa kathayAmAsa, prArthanakAle yUyam itthaM kathayadhvaM, he asmAkaM svargasthapitastava nAma pUjyaM bhavatu; tava rAjatvaM bhavatu; svarge yathA tathA pR^ithivyAmapi tavechChayA sarvvaM bhavatu| ");
INSERT INTO sanitr_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","pratyaham asmAkaM prayojanIyaM bhojyaM dehi| ");
INSERT INTO sanitr_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","yathA vayaM sarvvAn aparAdhinaH kShamAmahe tathA tvamapi pApAnyasmAkaM kShamasva| asmAn parIkShAM mAnaya kintu pApAtmano rakSha| ");
INSERT INTO sanitr_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","pashchAt soparamapi kathitavAn yadi yuShmAkaM kasyachid bandhustiShThati nishIthe cha tasya samIpaM sa gatvA vadati, ");
INSERT INTO sanitr_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","he bandho pathika eko bandhu rmama niveshanam AyAtaH kintu tasyAtithyaM karttuM mamAntike kimapi nAsti, ataeva pUpatrayaM mahyam R^iNaM dehi; ");
INSERT INTO sanitr_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","tadA sa yadi gR^ihamadhyAt prativadati mAM mA klishAna, idAnIM dvAraM ruddhaM shayane mayA saha bAlakAshcha tiShThanti tubhyaM dAtum utthAtuM na shaknomi, ");
INSERT INTO sanitr_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","tarhi yuShmAnahaM vadAmi, sa yadi mitratayA tasmai kimapi dAtuM nottiShThati tathApi vAraM vAraM prArthanAta utthApitaH san yasmin tasya prayojanaM tadeva dAsyati| ");
INSERT INTO sanitr_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","ataH kAraNAt kathayAmi, yAchadhvaM tato yuShmabhyaM dAsyate, mR^igayadhvaM tata uddeshaM prApsyatha, dvAram Ahata tato yuShmabhyaM dvAraM mokShyate| ");
INSERT INTO sanitr_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","yo yAchate sa prApnoti, yo mR^igayate sa evoddeshaM prApnoti, yo dvAram Ahanti tadarthaM dvAraM mochyate| ");
INSERT INTO sanitr_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","putreNa pUpe yAchite tasmai pAShANaM dadAti vA matsye yAchite tasmai sarpaM dadAti ");
INSERT INTO sanitr_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","vA aNDe yAchite tasmai vR^ishchikaM dadAti yuShmAkaM madhye ka etAdR^ishaH pitAste? ");
INSERT INTO sanitr_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","tasmAdeva yUyamabhadrA api yadi svasvabAlakebhya uttamAni dravyANi dAtuM jAnItha tarhyasmAkaM svargasthaH pitA nijayAchakebhyaH kiM pavitram AtmAnaM na dAsyati? ");
INSERT INTO sanitr_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","anantaraM yIshunA kasmAchchid ekasmin mUkabhUte tyAjite sati sa bhUtatyakto mAnuSho vAkyaM vaktum Arebhe; tato lokAH sakalA AshcharyyaM menire| ");
INSERT INTO sanitr_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","kintu teShAM kechidUchu rjanoyaM bAlasibUbA arthAd bhUtarAjena bhUtAn tyAjayati| ");
INSERT INTO sanitr_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","taM parIkShituM kechid AkAshIyam ekaM chihnaM darshayituM taM prArthayA nchakrire| ");
INSERT INTO sanitr_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","tadA sa teShAM manaHkalpanAM j nAtvA kathayAmAsa, kasyachid rAjyasya lokA yadi parasparaM virundhanti tarhi tad rAjyam nashyati; kechid gR^ihasthA yadi parasparaM virundhanti tarhi tepi nashyanti| ");
INSERT INTO sanitr_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","tathaiva shaitAnapi svalokAn yadi viruNaddhi tadA tasya rAjyaM kathaM sthAsyati? bAlasibUbAhaM bhUtAn tyAjayAmi yUyamiti vadatha| ");
INSERT INTO sanitr_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","yadyahaM bAlasibUbA bhUtAn tyAjayAmi tarhi yuShmAkaM santAnAH kena tyAjayanti? tasmAt taeva kathAyA etasyA vichArayitAro bhaviShyanti| ");
INSERT INTO sanitr_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","kintu yadyaham Ishvarasya parAkrameNa bhUtAn tyAjayAmi tarhi yuShmAkaM nikaTam Ishvarasya rAjyamavashyam upatiShThati| ");
INSERT INTO sanitr_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","balavAn pumAn susajjamAno yatikAlaM nijATTAlikAM rakShati tatikAlaM tasya dravyaM nirupadravaM tiShThati| ");
INSERT INTO sanitr_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","kintu tasmAd adhikabalaH kashchidAgatya yadi taM jayati tarhi yeShu shastrAstreShu tasya vishvAsa AsIt tAni sarvvANi hR^itvA tasya dravyANi gR^ihlAti| ");
INSERT INTO sanitr_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","ataH kAraNAd yo mama sapakSho na sa vipakShaH, yo mayA saha na saMgR^ihlAti sa vikirati| ");
INSERT INTO sanitr_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","apara ncha amedhyabhUto mAnuShasyAntarnirgatya shuShkasthAne bhrAntvA vishrAmaM mR^igayate kintu na prApya vadati mama yasmAd gR^ihAd AgatohaM punastad gR^ihaM parAvR^itya yAmi| ");
INSERT INTO sanitr_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","tato gatvA tad gR^ihaM mArjitaM shobhita ncha dR^iShTvA ");
INSERT INTO sanitr_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","tatkShaNam apagatya svasmAdapi durmmatIn aparAn saptabhUtAn sahAnayati te cha tadgR^ihaM pavishya nivasanti| tasmAt tasya manuShyasya prathamadashAtaH sheShadashA duHkhatarA bhavati| ");
INSERT INTO sanitr_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","asyAH kathAyAH kathanakAle janatAmadhyasthA kAchinnArI tamuchchaiHsvaraM provAcha, yA yoShit tvAM garbbhe.adhArayat stanyamapAyayachcha saiva dhanyA| ");
INSERT INTO sanitr_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","kintu sokathayat ye parameshvarasya kathAM shrutvA tadanurUpam Acharanti taeva dhanyAH| ");
INSERT INTO sanitr_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","tataH paraM tasyAntike bahulokAnAM samAgame jAte sa vaktumArebhe, AdhunikA duShTalokAshchihnaM draShTumichChanti kintu yUnasbhaviShyadvAdinashchihnaM vinAnyat ki nchichchihnaM tAn na darshayiShyate| ");
INSERT INTO sanitr_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","yUnas tu yathA nInivIyalokAnAM samIpe chihnarUpobhavat tathA vidyamAnalokAnAm eShAM samIpe manuShyaputropi chihnarUpo bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","vichArasamaye idAnIntanalokAnAM prAtikUlyena dakShiNadeshIyA rAj nI protthAya tAn doShiNaH kariShyati, yataH sA rAj nI sulemAna upadeshakathAM shrotuM pR^ithivyAH sImAta AgachChat kintu pashyata sulemAnopi gurutara eko jano.asmin sthAne vidyate| ");
INSERT INTO sanitr_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","apara ncha vichArasamaye nInivIyalokA api varttamAnakAlikAnAM lokAnAM vaiparItyena protthAya tAn doShiNaH kariShyanti, yato hetoste yUnaso vAkyAt chittAni parivarttayAmAsuH kintu pashyata yUnasotigurutara eko jano.asmin sthAne vidyate| ");
INSERT INTO sanitr_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","pradIpaM prajvAlya droNasyAdhaH kutrApi guptasthAne vA kopi na sthApayati kintu gR^ihapraveshibhyo dIptiM dAtaM dIpAdhAroparyyeva sthApayati| ");
INSERT INTO sanitr_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","dehasya pradIpashchakShustasmAdeva chakShu ryadi prasannaM bhavati tarhi tava sarvvasharIraM dIptimad bhaviShyati kintu chakShu ryadi malImasaM tiShThati tarhi sarvvasharIraM sAndhakAraM sthAsyati| ");
INSERT INTO sanitr_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","asmAt kAraNAt tavAntaHsthaM jyoti ryathAndhakAramayaM na bhavati tadarthe sAvadhAno bhava| ");
INSERT INTO sanitr_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","yataH sharIrasya kutrApyaMshe sAndhakAre na jAte sarvvaM yadi dIptimat tiShThati tarhi tubhyaM dIptidAyiprojjvalan pradIpa iva tava savarvasharIraM dIptimad bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","etatkathAyAH kathanakAle phirushyeko bhejanAya taM nimantrayAmAsa, tataH sa gatvA bhoktum upavivesha| ");
INSERT INTO sanitr_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","kintu bhojanAt pUrvvaM nAmA NkShIt etad dR^iShTvA sa phirushyAshcharyyaM mene| ");
INSERT INTO sanitr_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","tadA prabhustaM provAcha yUyaM phirUshilokAH pAnapAtrANAM bhojanapAtrANA ncha bahiH pariShkurutha kintu yuShmAkamanta rdaurAtmyai rduShkriyAbhishcha paripUrNaM tiShThati| ");
INSERT INTO sanitr_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","he sarvve nirbodhA yo bahiH sasarja sa eva kimanta rna sasarja? ");
INSERT INTO sanitr_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","tata eva yuShmAbhirantaHkaraNaM (IshvarAya) nivedyatAM tasmin kR^ite yuShmAkaM sarvvANi shuchitAM yAsyanti| ");
INSERT INTO sanitr_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","kintu hanta phirUshigaNA yUyaM nyAyam Ishvare prema cha parityajya podinAyA arudAdInAM sarvveShAM shAkAnA ncha dashamAMshAn dattha kintu prathamaM pAlayitvA sheShasyAla NghanaM yuShmAkam uchitamAsIt| ");
INSERT INTO sanitr_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","hA hA phirUshino yUyaM bhajanagehe prochchAsane ApaNeShu cha namaskAreShu prIyadhve| ");
INSERT INTO sanitr_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","vata kapaTino.adhyApakAH phirUshinashcha lokAyat shmashAnam anupalabhya tadupari gachChanti yUyam tAdR^igaprakAshitashmashAnavAd bhavatha| ");
INSERT INTO sanitr_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","tadAnIM vyavasthApakAnAm ekA yIshumavadat, he upadeshaka vAkyenedR^ishenAsmAsvapi doSham Aropayasi| ");
INSERT INTO sanitr_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","tataH sa uvAcha, hA hA vyavasthApakA yUyam mAnuShANAm upari duHsahyAn bhArAn nyasyatha kintu svayam ekA NguुlyApi tAn bhArAn na spR^ishatha| ");
INSERT INTO sanitr_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","hanta yuShmAkaM pUrvvapuruShA yAn bhaviShyadvAdino.avadhiShusteShAM shmashAnAni yUyaM nirmmAtha| ");
INSERT INTO sanitr_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","tenaiva yUyaM svapUrvvapuruShANAM karmmANi saMmanyadhve tadeva sapramANaM kurutha cha, yataste tAnavadhiShuH yUyaM teShAM shmashAnAni nirmmAtha| ");
INSERT INTO sanitr_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ataeva Ishvarasya shAstre proktamasti teShAmantike bhaviShyadvAdinaH preritAMshcha preShayiShyAmi tataste teShAM kAMshchana haniShyanti kAMshchana tADashShyinti| ");
INSERT INTO sanitr_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","etasmAt kAraNAt hAbilaH shoNitapAtamArabhya mandirayaj navedyo rmadhye hatasya sikhariyasya raktapAtaparyyantaM ");
INSERT INTO sanitr_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","jagataH sR^iShTimArabhya pR^ithivyAM bhaviShyadvAdinAM yatiraktapAtA jAtAstatInAm aparAdhadaNDA eShAM varttamAnalokAnAM bhaviShyanti, yuShmAnahaM nishchitaM vadAmi sarvve daNDA vaMshasyAsya bhaviShyanti| ");
INSERT INTO sanitr_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","hA hA vyavasthapakA yUyaM j nAnasya ku nchikAM hR^itvA svayaM na praviShTA ye praveShTu ncha prayAsinastAnapi praveShTuM vAritavantaH| ");
INSERT INTO sanitr_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","itthaM kathAkathanAd adhyApakAH phirUshinashcha satarkAH ");
INSERT INTO sanitr_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","santastamapavadituM tasya kathAyA doShaM dharttamichChanto nAnAkhyAnakathanAya taM pravarttayituM kopayitu ncha prArebhire| ");
INSERT INTO sanitr_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","tadAnIM lokAH sahasraM sahasram Agatya samupasthitAstata ekaiko .anyeShAmupari patitum upachakrame; tadA yIshuH shiShyAn babhAShe, yUyaM phirUshinAM kiNvarUpakApaTye visheSheNa sAvadhAnAstiShThata| ");
INSERT INTO sanitr_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","yato yanna prakAshayiShyate tadAchChannaM vastu kimapi nAsti; tathA yanna j nAsyate tad guptaM vastu kimapi nAsti| ");
INSERT INTO sanitr_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","andhakAre tiShThanato yAH kathA akathayata tAH sarvvAH kathA dIptau shroShyante nirjane karNe cha yadakathayata gR^ihapR^iShThAt tat prachArayiShyate| ");
INSERT INTO sanitr_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","he bandhavo yuShmAnahaM vadAmi, ye sharIrasya nAshaM vinA kimapyaparaM karttuM na shakruvanti tebhyo mA bhaiShTa| ");
INSERT INTO sanitr_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","tarhi kasmAd bhetavyam ityahaM vadAmi, yaH sharIraM nAshayitvA narakaM nikSheptuM shaknoti tasmAdeva bhayaM kuruta, punarapi vadAmi tasmAdeva bhayaM kuruta| ");
INSERT INTO sanitr_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","pa ncha chaTakapakShiNaH kiM dvAbhyAM tAmrakhaNDAbhyAM na vikrIyante? tathApIshvarasteShAm ekamapi na vismarati| ");
INSERT INTO sanitr_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","yuShmAkaM shiraHkeshA api gaNitAH santi tasmAt mA vibhIta bahuchaTakapakShibhyopi yUyaM bahumUlyAH| ");
INSERT INTO sanitr_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","aparaM yuShmabhyaM kathayAmi yaH kashchin mAnuShANAM sAkShAn mAM svIkaroti manuShyaputra IshvaradUtAnAM sAkShAt taM svIkariShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","kintu yaH kashchinmAnuShANAM sAkShAnmAm asvIkaroti tam Ishvarasya dUtAnAM sAkShAd aham asvIkariShyAmi| ");
INSERT INTO sanitr_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","anyachcha yaH kashchin manujasutasya nindAbhAvena kA nchit kathAM kathayati tasya tatpApasya mochanaM bhaviShyati kintu yadi kashchit pavitram AtmAnaM nindati tarhi tasya tatpApasya mochanaM na bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","yadA lokA yuShmAn bhajanagehaM vichArakartR^irAjyakartR^iNAM sammukha ncha neShyanti tadA kena prakAreNa kimuttaraM vadiShyatha kiM kathayiShyatha chetyatra mA chintayata; ");
INSERT INTO sanitr_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","yato yuShmAbhiryad yad vaktavyaM tat tasmin samayaeva pavitra AtmA yuShmAn shikShayiShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","tataH paraM janatAmadhyasthaH kashchijjanastaM jagAda he guro mayA saha paitR^ikaM dhanaM vibhaktuM mama bhrAtaramAj nApayatu bhavAn| ");
INSERT INTO sanitr_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","kintu sa tamavadat he manuShya yuvayo rvichAraM vibhAga ncha karttuM mAM ko niyuktavAn? ");
INSERT INTO sanitr_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","anantaraM sa lokAnavadat lobhe sAvadhAnAH satarkAshcha tiShThata, yato bahusampattiprAptyA manuShyasyAyu rna bhavati| ");
INSERT INTO sanitr_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","pashchAd dR^iShTAntakathAmutthApya kathayAmAsa, ekasya dhanino bhUmau bahUni shasyAni jAtAni| ");
INSERT INTO sanitr_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","tataH sa manasA chintayitvA kathayAmbabhUva mamaitAni samutpannAni dravyANi sthApayituM sthAnaM nAsti kiM kariShyAmi? ");
INSERT INTO sanitr_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","tatovadad itthaM kariShyAmi, mama sarvvabhANDAgArANi bha NktvA bR^ihadbhANDAgArANi nirmmAya tanmadhye sarvvaphalAni dravyANi cha sthApayiShyAmi| ");
INSERT INTO sanitr_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","aparaM nijamano vadiShyAmi, he mano bahuvatsarArthaM nAnAdravyANi sa nchitAni santi vishrAmaM kuru bhuktvA pItvA kautuka ncha kuru| kintvIshvarastam avadat, ");
INSERT INTO sanitr_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","re nirbodha adya rAtrau tava prANAstvatto neShyante tata etAni yAni dravyANi tvayAsAditAni tAni kasya bhaviShyanti? ");
INSERT INTO sanitr_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","ataeva yaH kashchid Ishvarasya samIpe dhanasa nchayamakR^itvA kevalaM svanikaTe sa nchayaM karoti sopi tAdR^ishaH| ");
INSERT INTO sanitr_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","atha sa shiShyebhyaH kathayAmAsa, yuShmAnahaM vadAmi, kiM khAdiShyAmaH? kiM paridhAsyAmaH? ityuktvA jIvanasya sharIrasya chArthaM chintAM mA kArShTa| ");
INSERT INTO sanitr_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","bhakShyAjjIvanaM bhUShaNAchCharIra ncha shreShThaM bhavati| ");
INSERT INTO sanitr_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","kAkapakShiNAM kAryyaM vichArayata, te na vapanti shasyAni cha na Chindanti, teShAM bhANDAgArANi na santi koShAshcha na santi, tathApIshvarastebhyo bhakShyANi dadAti, yUyaM pakShibhyaH shreShThatarA na kiM? ");
INSERT INTO sanitr_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","apara ncha bhAvayitvA nijAyuShaH kShaNamAtraM varddhayituM shaknoti, etAdR^isho lAko yuShmAkaM madhye kosti? ");
INSERT INTO sanitr_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","ataeva kShudraM kAryyaM sAdhayitum asamarthA yUyam anyasmin kAryye kuto bhAvayatha? ");
INSERT INTO sanitr_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","anyachcha kAmpilapuShpaM kathaM varddhate tadApi vichArayata, tat ka nchana shramaM na karoti tantUMshcha na janayati kintu yuShmabhyaM yathArthaM kathayAmi sulemAn bahvaishvaryyAnvitopi puShpasyAsya sadR^isho vibhUShito nAsIt| ");
INSERT INTO sanitr_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","adya kShetre varttamAnaM shvashchUllyAM kShepsyamAnaM yat tR^iNaM, tasmai yadIshvara itthaM bhUShayati tarhi he alpapratyayino yuShmAna kiM na paridhApayiShyati? ");
INSERT INTO sanitr_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","ataeva kiM khAdiShyAmaH? kiM paridhAsyAmaH? etadarthaM mA cheShTadhvaM mA saMdigdhva ncha| ");
INSERT INTO sanitr_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","jagato devArchchakA etAni sarvvANi cheShTanate; eShu vastuShu yuShmAkaM prayojanamAste iti yuShmAkaM pitA jAnAti| ");
INSERT INTO sanitr_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","ataeveshvarasya rAjyArthaM sacheShTA bhavata tathA kR^ite sarvvANyetAni dravyANi yuShmabhyaM pradAyiShyante| ");
INSERT INTO sanitr_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","he kShudrameShavraja yUyaM mA bhaiShTa yuShmabhyaM rAjyaM dAtuM yuShmAkaM pituH sammatirasti| ");
INSERT INTO sanitr_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ataeva yuShmAkaM yA yA sampattirasti tAM tAM vikrIya vitarata, yat sthAnaM chaurA nAgachChanti, kITAshcha na kShAyayanti tAdR^ishe svarge nijArtham ajare sampuTake .akShayaM dhanaM sa nchinuta cha; ");
INSERT INTO sanitr_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","yato yatra yuShmAkaM dhanaM varttate tatreva yuShmAkaM manaH| ");
INSERT INTO sanitr_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","apara ncha yUyaM pradIpaM jvAlayitvA baddhakaTayastiShThata; ");
INSERT INTO sanitr_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","prabhu rvivAhAdAgatya yadaiva dvAramAhanti tadaiva dvAraM mochayituM yathA bhR^ityA apekShya tiShThanti tathA yUyamapi tiShThata| ");
INSERT INTO sanitr_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","yataH prabhurAgatya yAn dAsAn sachetanAn tiShThato drakShyati taeva dhanyAH; ahaM yuShmAn yathArthaM vadAmi prabhustAn bhojanArtham upaveshya svayaM baddhakaTiH samIpametya pariveShayiShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","yadi dvitIye tR^itIye vA prahare samAgatya tathaiva pashyati, tarhi taeva dAsA dhanyAH| ");
INSERT INTO sanitr_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","apara ncha kasmin kShaNe chaurA AgamiShyanti iti yadi gR^ihapati rj nAtuM shaknoti tadAvashyaM jAgran nijagR^ihe sandhiM karttayituM vArayati yUyametad vitta| ");
INSERT INTO sanitr_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","ataeva yUyamapi sajjamAnAstiShThata yato yasmin kShaNe taM nAprekShadhve tasminneva kShaNe manuShyaputra AgamiShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","tadA pitaraH paprachCha, he prabho bhavAn kimasmAn uddishya kiM sarvvAn uddishya dR^iShTAntakathAmimAM vadati? ");
INSERT INTO sanitr_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","tataH prabhuH provAcha, prabhuH samuchitakAle nijaparivArArthaM bhojyapariveShaNAya yaM tatpade niyokShyati tAdR^isho vishvAsyo boddhA karmmAdhIshaH kosti? ");
INSERT INTO sanitr_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","prabhurAgatya yam etAdR^ishe karmmaNi pravR^ittaM drakShyati saeva dAso dhanyaH| ");
INSERT INTO sanitr_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ahaM yuShmAn yathArthaM vadAmi sa taM nijasarvvasvasyAdhipatiM kariShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","kintu prabhurvilambenAgamiShyati, iti vichintya sa dAso yadi tadanyadAsIdAsAn praharttum bhoktuM pAtuM maditu ncha prArabhate, ");
INSERT INTO sanitr_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","tarhi yadA prabhuM nApekShiShyate yasmin kShaNe so.achetanashcha sthAsyati tasminneva kShaNe tasya prabhurAgatya taM padabhraShTaM kR^itvA vishvAsahInaiH saha tasya aMshaM nirUpayiShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","yo dAsaH prabheाrAj nAM j nAtvApi sajjito na tiShThati tadAj nAnusAreNa cha kAryyaM na karoti sonekAn prahArAn prApsyati; ");
INSERT INTO sanitr_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","kintu yo jano.aj nAtvA prahArArhaM karmma karoti solpaprahArAn prApsyati| yato yasmai bAhulyena dattaM tasmAdeva bAhulyena grahIShyate, mAnuShA yasya nikaTe bahu samarpayanti tasmAd bahu yAchante| ");
INSERT INTO sanitr_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","ahaM pR^ithivyAm anaikyarUpaM vahni nikSheptum Agatosmi, sa ched idAnImeva prajvalati tatra mama kA chintA? ");
INSERT INTO sanitr_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","kintu yena majjanenAhaM magno bhaviShyAmi yAvatkAlaM tasya siddhi rna bhaviShyati tAvadahaM katikaShTaM prApsyAmi| ");
INSERT INTO sanitr_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","melanaM karttuM jagad Agatosmi yUyaM kimitthaM bodhadhve? yuShmAn vadAmi na tathA, kintvahaM melanAbhAvaM karttuMm Agatosmi| ");
INSERT INTO sanitr_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","yasmAdetatkAlamArabhya ekatrasthaparijanAnAM madhye pa nchajanAH pR^ithag bhUtvA trayo janA dvayorjanayoH pratikUlA dvau janau cha trayANAM janAnAM pratikUlau bhaviShyanti| ");
INSERT INTO sanitr_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","pitA putrasya vipakShaH putrashcha pitu rvipakSho bhaviShyati mAtA kanyAyA vipakShA kanyA cha mAtu rvipakShA bhaviShyati, tathA shvashrUrbadhvA vipakShA badhUshcha shvashrvA vipakShA bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","sa lokebhyoparamapi kathayAmAsa, pashchimadishi meghodgamaM dR^iShTvA yUyaM haThAd vadatha vR^iShTi rbhaviShyati tatastathaiva jAyate| ");
INSERT INTO sanitr_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","aparaM dakShiNato vAyau vAti sati vadatha nidAgho bhaviShyati tataH sopi jAyate| ");
INSERT INTO sanitr_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","re re kapaTina AkAshasya bhUmyAshcha lakShaNaM boddhuM shaknutha, ");
INSERT INTO sanitr_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","kintu kAlasyAsya lakShaNaM kuto boddhuM na shaknutha? yUya ncha svayaM kuto na nyAShyaM vichArayatha? ");
INSERT INTO sanitr_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","apara ncha vivAdinA sArddhaM vichArayituH samIpaM gachChan pathi tasmAduddhAraM prAptuM yatasva nochet sa tvAM dhR^itvA vichArayituH samIpaM nayati| vichArayitA yadi tvAM praharttuH samIpaM samarpayati praharttA tvAM kArAyAM badhnAti ");
INSERT INTO sanitr_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","tarhi tvAmahaM vadAmi tvayA niHsheShaM kapardakeShu na parishodhiteShu tvaM tato muktiM prAptuM na shakShyasi| ");
INSERT INTO sanitr_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","apara ncha pIlAto yeShAM gAlIlIyAnAM raktAni balInAM raktaiH sahAmishrayat teShAM gAlIlIyAnAM vR^ittAntaM katipayajanA upasthApya yIshave kathayAmAsuH| ");
INSERT INTO sanitr_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","tataH sa pratyuvAcha teShAM lokAnAm etAdR^ishI durgati rghaTitA tatkAraNAd yUyaM kimanyebhyo gAlIlIyebhyopyadhikapApinastAn bodhadhve? ");
INSERT INTO sanitr_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","yuShmAnahaM vadAmi tathA na kintu manaHsu na parAvarttiteShu yUyamapi tathA naMkShyatha| ");
INSERT INTO sanitr_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","apara ncha shIlohanAmna uchchagR^ihasya patanAd ye.aShTAdashajanA mR^itAste yirUshAlami nivAsisarvvalokebhyo.adhikAparAdhinaH kiM yUyamityaM bodhadhve? ");
INSERT INTO sanitr_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","yuShmAnahaM vadAmi tathA na kintu manaHsu na parivarttiteShu yUyamapi tathA naMkShyatha| ");
INSERT INTO sanitr_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","anantaraM sa imAM dR^iShTAntakathAmakathayad eko jano drAkShAkShetramadhya ekamuDumbaravR^ikShaM ropitavAn| pashchAt sa Agatya tasmin phalAni gaveShayAmAsa, ");
INSERT INTO sanitr_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","kintu phalAprApteH kAraNAd udyAnakAraM bhR^ityaM jagAda, pashya vatsaratrayaM yAvadAgatya etasminnuDumbaratarau kShalAnyanvichChAmi, kintu naikamapi prapnomi tarurayaM kuto vR^ithA sthAnaM vyApya tiShThati? enaM Chindhi| ");
INSERT INTO sanitr_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","tato bhR^ityaH pratyuvAcha, he prabho punarvarShamekaM sthAtum Adisha; etasya mUlasya chaturdikShu khanitvAham AlavAlaM sthApayAmi| ");
INSERT INTO sanitr_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","tataH phalituM shaknoti yadi na phalati tarhi pashchAt Chetsyasi| ");
INSERT INTO sanitr_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","atha vishrAmavAre bhajanagehe yIshurupadishati ");
INSERT INTO sanitr_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","tasmit samaye bhUtagrastatvAt kubjIbhUyAShTAdashavarShANi yAvat kenApyupAyena R^iju rbhavituM na shaknoti yA durbbalA strI, ");
INSERT INTO sanitr_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","tAM tatropasthitAM vilokya yIshustAmAhUya kathitavAn he nAri tava daurbbalyAt tvaM muktA bhava| ");
INSERT INTO sanitr_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","tataH paraM tasyA gAtre hastArpaNamAtrAt sA R^ijurbhUtveshvarasya dhanyavAdaM karttumArebhe| ");
INSERT INTO sanitr_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","kintu vishrAmavAre yIshunA tasyAH svAsthyakaraNAd bhajanagehasyAdhipatiH prakupya lokAn uvAcha, ShaTsu dineShu lokaiH karmma karttavyaM tasmAddhetoH svAsthyArthaM teShu dineShu AgachChata, vishrAmavAre mAgachChata| ");
INSERT INTO sanitr_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","tadA pabhuH pratyuvAcha re kapaTino yuShmAkam ekaiko jano vishrAmavAre svIyaM svIyaM vR^iShabhaM gardabhaM vA bandhanAnmochayitvA jalaM pAyayituM kiM na nayati? ");
INSERT INTO sanitr_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","tarhyAShTAdashavatsarAn yAvat shaitAnA baddhA ibrAhImaH santatiriyaM nArI kiM vishrAmavAre na mochayitavyA? ");
INSERT INTO sanitr_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","eShu vAkyeShu kathiteShu tasya vipakShAH salajjA jAtAH kintu tena kR^itasarvvamahAkarmmakAraNAt lokanivahaH sAnando.abhavat| ");
INSERT INTO sanitr_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","anantaraM sovadad Ishvarasya rAjyaM kasya sadR^ishaM? kena tadupamAsyAmi? ");
INSERT INTO sanitr_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","yat sarShapabIjaM gR^ihItvA kashchijjana udyAna uptavAn tad bIjama NkuritaM sat mahAvR^ikSho.ajAyata, tatastasya shAkhAsu vihAyasIyavihagA Agatya nyUShuH, tadrAjyaM tAdR^ishena sarShapabIjena tulyaM| ");
INSERT INTO sanitr_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","punaH kathayAmAsa, Ishvarasya rAjyaM kasya sadR^ishaM vadiShyAmi? yat kiNvaM kAchit strI gR^ihItvA droNatrayaparimitagodhUmachUrNeShu sthApayAmAsa, ");
INSERT INTO sanitr_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","tataH krameNa tat sarvvagodhUmachUrNaM vyApnoti, tasya kiNvasya tulyam Ishvarasya rAjyaM| ");
INSERT INTO sanitr_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","tataH sa yirUshAlamnagaraM prati yAtrAM kR^itvA nagare nagare grAme grAme samupadishan jagAma| ");
INSERT INTO sanitr_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","tadA kashchijjanastaM paprachCha, he prabho kiM kevalam alpe lokAH paritrAsyante? ");
INSERT INTO sanitr_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","tataH sa lokAn uvAcha, saMkIrNadvAreNa praveShTuM yataghvaM, yatohaM yuShmAn vadAmi, bahavaH praveShTuM cheShTiShyante kintu na shakShyanti| ");
INSERT INTO sanitr_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","gR^ihapatinotthAya dvAre ruddhe sati yadi yUyaM bahiH sthitvA dvAramAhatya vadatha, he prabho he prabho asmatkAraNAd dvAraM mochayatu, tataH sa iti prativakShyati, yUyaM kutratyA lokA ityahaM na jAnAmi| ");
INSERT INTO sanitr_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","tadA yUyaM vadiShyatha, tava sAkShAd vayaM bheाjanaM pAna ncha kR^itavantaH, tva nchAsmAkaM nagarasya pathi samupadiShTavAn| ");
INSERT INTO sanitr_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","kintu sa vakShyati, yuShmAnahaM vadAmi, yUyaM kutratyA lokA ityahaM na jAnAmi; he durAchAriNo yUyaM matto dUrIbhavata| ");
INSERT INTO sanitr_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","tadA ibrAhImaM ishAkaM yAkUba ncha sarvvabhaviShyadvAdinashcha Ishvarasya rAjyaM prAptAn svAMshcha bahiShkR^itAn dR^iShTvA yUyaM rodanaM dantairdantagharShaNa ncha kariShyatha| ");
INSERT INTO sanitr_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","apara ncha pUrvvapashchimadakShiNottaradigbhyo lokA Agatya Ishvarasya rAjye nivatsyanti| ");
INSERT INTO sanitr_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","pashyatetthaM sheShIyA lokA agrA bhaviShyanti, agrIyA lokAshcha sheShA bhaviShyanti| ");
INSERT INTO sanitr_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","apara ncha tasmin dine kiyantaH phirUshina Agatya yIshuM prochuH, bahirgachCha, sthAnAdasmAt prasthAnaM kuru, herod tvAM jighAMsati| ");
INSERT INTO sanitr_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","tataH sa pratyavochat pashyatAdya shvashcha bhUtAn vihApya rogiNo.arogiNaH kR^itvA tR^itIyehni setsyAmi, kathAmetAM yUyamitvA taM bhUrimAyaM vadata| ");
INSERT INTO sanitr_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","tatrApyadya shvaH parashvashcha mayA gamanAgamane karttavye, yato heto ryirUshAlamo bahiH kutrApi kopi bhaviShyadvAdI na ghAniShyate| ");
INSERT INTO sanitr_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","he yirUshAlam he yirUshAlam tvaM bhaviShyadvAdino haMsi tavAntike preritAn prastarairmArayasi cha, yathA kukkuTI nijapakShAdhaH svashAvakAn saMgR^ihlAti, tathAhamapi tava shishUn saMgrahItuM kativArAn aichChaM kintu tvaM naichChaH| ");
INSERT INTO sanitr_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","pashyata yuShmAkaM vAsasthAnAni prochChidyamAnAni parityaktAni cha bhaviShyanti; yuShmAnahaM yathArthaM vadAmi, yaH prabho rnAmnAgachChati sa dhanya iti vAchaM yAvatkAlaM na vadiShyatha, tAvatkAlaM yUyaM mAM na drakShyatha| ");
INSERT INTO sanitr_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","anantaraM vishrAmavAre yIshau pradhAnasya phirUshino gR^ihe bhoktuM gatavati te taM vIkShitum Arebhire| ");
INSERT INTO sanitr_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","tadA jalodarI tasya sammukhe sthitaH| ");
INSERT INTO sanitr_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","tataH sa vyavasthApakAn phirUshinashcha paprachCha, vishrAmavAre svAsthyaM karttavyaM na vA? tataste kimapi na pratyUchuH| ");
INSERT INTO sanitr_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","tadA sa taM rogiNaM svasthaM kR^itvA visasarja; ");
INSERT INTO sanitr_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","tAnuvAcha cha yuShmAkaM kasyachid garddabho vR^iShabho vA ched gartte patati tarhi vishrAmavAre tatkShaNaM sa kiM taM notthApayiShyati? ");
INSERT INTO sanitr_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","tataste kathAyA etasyAH kimapi prativaktuM na shekuH| ");
INSERT INTO sanitr_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","apara ncha pradhAnasthAnamanonItatvakaraNaM vilokya sa nimantritAn etadupadeshakathAM jagAda, ");
INSERT INTO sanitr_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","tvaM vivAhAdibhojyeShu nimantritaH san pradhAnasthAne mopAvekShIH| tvatto gauravAnvitanimantritajana AyAte ");
INSERT INTO sanitr_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","nimantrayitAgatya manuShyAyaitasmai sthAnaM dehIti vAkyaM ched vakShyati tarhi tvaM sa Nkuchito bhUtvA sthAna itarasmin upaveShTum udyaMsyasi| ");
INSERT INTO sanitr_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","asmAt kAraNAdeva tvaM nimantrito gatvA.apradhAnasthAna upavisha, tato nimantrayitAgatya vadiShyati, he bandho prochchasthAnaM gatvopavisha, tathA sati bhojanopaviShTAnAM sakalAnAM sAkShAt tvaM mAnyo bhaviShyasi| ");
INSERT INTO sanitr_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","yaH kashchit svamunnamayati sa namayiShyate, kintu yaH kashchit svaM namayati sa unnamayiShyate| ");
INSERT INTO sanitr_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","tadA sa nimantrayitAraM janamapi jagAda, madhyAhne rAtrau vA bhojye kR^ite nijabandhugaNo vA bhrAtR^iृgaNo vA j nAtigaNo vA dhanigaNo vA samIpavAsigaNo vA etAn na nimantraya, tathA kR^ite chet te tvAM nimantrayiShyanti, tarhi parishodho bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","kintu yadA bhejyaM karoShi tadA daridrashuShkakarakha njAndhAn nimantraya, ");
INSERT INTO sanitr_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","tata AshiShaM lapsyase, teShu parishodhaM karttumashaknuvatsu shmashAnAddhArmmikAnAmutthAnakAle tvaM phalAM lapsyase| ");
INSERT INTO sanitr_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","anantaraM tAM kathAM nishamya bhojanopaviShTaH kashchit kathayAmAsa, yo jana Ishvarasya rAjye bhoktuM lapsyate saeva dhanyaH| ");
INSERT INTO sanitr_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","tataH sa uvAcha, kashchit jano rAtrau bheाjyaM kR^itvA bahUn nimantrayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","tato bhojanasamaye nimantritalokAn AhvAtuM dAsadvArA kathayAmAsa, khadyadravyANi sarvvANi samAsAditAni santi, yUyamAgachChata| ");
INSERT INTO sanitr_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","kintu te sarvva ekaikaM ChalaM kR^itvA kShamAM prArthayA nchakrire| prathamo janaH kathayAmAsa, kShetramekaM krItavAnahaM tadeva draShTuM mayA gantavyam, ataeva mAM kShantuM taM nivedaya| ");
INSERT INTO sanitr_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","anyo janaH kathayAmAsa, dashavR^iShAnahaM krItavAn tAn parIkShituM yAmi tasmAdeva mAM kShantuM taM nivedaya| ");
INSERT INTO sanitr_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","aparaH kathayAmAsa, vyUDhavAnahaM tasmAt kAraNAd yAtuM na shaknomi| ");
INSERT INTO sanitr_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","pashchAt sa dAso gatvA nijaprabhoH sAkShAt sarvvavR^ittAntaM nivedayAmAsa, tatosau gR^ihapatiH kupitvA svadAsaM vyAjahAra, tvaM satvaraM nagarasya sanniveshAn mArgAMshcha gatvA daridrashuShkakarakha njAndhAn atrAnaya| ");
INSERT INTO sanitr_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","tato dAso.avadat, he prabho bhavata Aj nAnusAreNAkriyata tathApi sthAnamasti| ");
INSERT INTO sanitr_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","tadA prabhuH puna rdAsAyAkathayat, rAjapathAn vR^ikShamUlAni cha yAtvA madIyagR^ihapUraNArthaM lokAnAgantuM pravarttaya| ");
INSERT INTO sanitr_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ahaM yuShmabhyaM kathayAmi, pUrvvanimantritAnamekopi mamAsya rAtribhojyasyAsvAdaM na prApsyati| ");
INSERT INTO sanitr_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","anantaraM bahuShu lokeShu yIshoH pashchAd vrajiteShu satsu sa vyAghuTya tebhyaH kathayAmAsa, ");
INSERT INTO sanitr_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","yaH kashchin mama samIpam Agatya svasya mAtA pitA patnI santAnA bhrAtaro bhagimyo nijaprANAshcha, etebhyaH sarvvebhyo mayyadhikaM prema na karoti, sa mama shiShyo bhavituM na shakShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","yaH kashchit svIyaM krushaM vahan mama pashchAnna gachChati, sopi mama shiShyo bhavituM na shakShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","durganirmmANe kativyayo bhaviShyati, tathA tasya samAptikaraNArthaM sampattirasti na vA, prathamamupavishya etanna gaNayati, yuShmAkaM madhya etAdR^ishaH kosti? ");
INSERT INTO sanitr_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","noched bhittiM kR^itvA sheShe yadi samApayituM na shakShyati, ");
INSERT INTO sanitr_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","tarhi mAnuShoyaM nichetum Arabhata samApayituM nAshaknot, iti vyAhR^itya sarvve tamupahasiShyanti| ");
INSERT INTO sanitr_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","apara ncha bhinnabhUpatinA saha yuddhaM karttum udyamya dashasahasrANi sainyAni gR^ihItvA viMshatisahasreH sainyaiH sahitasya samIpavAsinaH sammukhaM yAtuM shakShyAmi na veti prathamaM upavishya na vichArayati etAdR^isho bhUmipatiH kaH? ");
INSERT INTO sanitr_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","yadi na shaknoti tarhi ripAvatidUre tiShThati sati nijadUtaM preShya sandhiM karttuM prArthayeta| ");
INSERT INTO sanitr_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","tadvad yuShmAkaM madhye yaH kashchin madarthaM sarvvasvaM hAtuM na shaknoti sa mama shiShyo bhavituM na shakShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","lavaNam uttamam iti satyaM, kintu yadi lavaNasya lavaNatvam apagachChati tarhi tat kathaM svAduyuktaM bhaviShyati? ");
INSERT INTO sanitr_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","tada bhUmyartham AlavAlarAshyarthamapi bhadraM na bhavati; lokAstad bahiH kShipanti|yasya shrotuM shrotre staH sa shR^iNotu| ");
INSERT INTO sanitr_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","tadA karasa nchAyinaH pApinashcha lokA upadeshkathAM shrotuM yIshoH samIpam AgachChan| ");
INSERT INTO sanitr_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","tataH phirUshina upAdhyAyAshcha vivadamAnAH kathayAmAsuH eSha mAnuShaH pApibhiH saha praNayaM kR^itvA taiH sArddhaM bhuMkte| ");
INSERT INTO sanitr_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","tadA sa tebhya imAM dR^iShTAntakathAM kathitavAn, ");
INSERT INTO sanitr_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","kasyachit shatameSheShu tiShThatmu teShAmekaM sa yadi hArayati tarhi madhyeprAntaram ekonashatameShAn vihAya hAritameShasya uddeshaprAptiparyyanataM na gaveShayati, etAdR^isho loko yuShmAkaM madhye ka Aste? ");
INSERT INTO sanitr_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","tasyoddeshaM prApya hR^iShTamanAstaM skandhe nidhAya svasthAnam AnIya bandhubAndhavasamIpavAsina AhUya vakti, ");
INSERT INTO sanitr_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","hAritaM meShaM prAptoham ato heto rmayA sArddham Anandata| ");
INSERT INTO sanitr_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","tadvadahaM yuShmAn vadAmi, yeShAM manaHparAvarttanasya prayojanaM nAsti, tAdR^ishaikonashatadhArmmikakAraNAd ya AnandastasmAd ekasya manaHparivarttinaH pApinaH kAraNAt svarge .adhikAnando jAyate| ");
INSERT INTO sanitr_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","apara ncha dashAnAM rUpyakhaNDAnAm ekakhaNDe hArite pradIpaM prajvAlya gR^ihaM sammArjya tasya prAptiM yAvad yatnena na gaveShayati, etAdR^ishI yoShit kAste? ");
INSERT INTO sanitr_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","prApte sati bandhubAndhavasamIpavAsinIrAhUya kathayati, hAritaM rUpyakhaNDaM prAptAhaM tasmAdeva mayA sArddham Anandata| ");
INSERT INTO sanitr_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","tadvadahaM yuShmAn vyAharAmi, ekena pApinA manasi parivarttite, Ishvarasya dUtAnAM madhyepyAnando jAyate| ");
INSERT INTO sanitr_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","apara ncha sa kathayAmAsa, kasyachid dvau putrAvAstAM, ");
INSERT INTO sanitr_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","tayoH kaniShThaH putraH pitre kathayAmAsa, he pitastava sampattyA yamaMshaM prApsyAmyahaM vibhajya taM dehi, tataH pitA nijAM sampattiM vibhajya tAbhyAM dadau| ");
INSERT INTO sanitr_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","katipayAt kAlAt paraM sa kaniShThaputraH samastaM dhanaM saMgR^ihya dUradeshaM gatvA duShTAcharaNena sarvvAM sampattiM nAshayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","tasya sarvvadhane vyayaM gate taddeshe mahAdurbhikShaM babhUva, tatastasya dainyadashA bhavitum Arebhe| ");
INSERT INTO sanitr_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","tataH paraM sa gatvA taddeshIyaM gR^ihasthamekam Ashrayata; tataH sataM shUkaravrajaM chArayituM prAntaraM preShayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","kenApi tasmai bhakShyAdAnAt sa shUkaraphalavalkalena pichiNDapUraNAM vavA nCha| ");
INSERT INTO sanitr_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","sheShe sa manasi chetanAM prApya kathayAmAsa, hA mama pituH samIpe kati kati vetanabhujo dAsA yatheShTaM tatodhika ncha bhakShyaM prApnuvanti kintvahaM kShudhA mumUrShuH| ");
INSERT INTO sanitr_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ahamutthAya pituH samIpaM gatvA kathAmetAM vadiShyAmi, he pitar Ishvarasya tava cha viruddhaM pApamakaravam ");
INSERT INTO sanitr_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","tava putra_iti vikhyAto bhavituM na yogyosmi cha, mAM tava vaitanikaM dAsaM kR^itvA sthApaya| ");
INSERT INTO sanitr_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","pashchAt sa utthAya pituH samIpaM jagAma; tatastasya pitAtidUre taM nirIkShya dayA nchakre, dhAvitvA tasya kaNThaM gR^ihItvA taM chuchumba cha| ");
INSERT INTO sanitr_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","tadA putra uvAcha, he pitar Ishvarasya tava cha viruddhaM pApamakaravaM, tava putra_iti vikhyAto bhavituM na yogyosmi cha| ");
INSERT INTO sanitr_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","kintu tasya pitA nijadAsAn Adidesha, sarvvottamavastrANyAnIya paridhApayatainaM haste chA NgurIyakam arpayata pAdayoshchopAnahau samarpayata; ");
INSERT INTO sanitr_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","puShTaM govatsam AnIya mArayata cha taM bhuktvA vayam AnandAma| ");
INSERT INTO sanitr_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","yato mama putroyam amriyata punarajIvId hAritashcha labdhobhUt tatasta Ananditum Arebhire| ");
INSERT INTO sanitr_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","tatkAle tasya jyeShThaH putraH kShetra AsIt| atha sa niveshanasya nikaTaM AgachChan nR^ityAnAM vAdyAnA ncha shabdaM shrutvA ");
INSERT INTO sanitr_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","dAsAnAm ekam AhUya paprachCha, kiM kAraNamasya? ");
INSERT INTO sanitr_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","tataH sovAdIt, tava bhrAtAgamat, tava tAtashcha taM susharIraM prApya puShTaM govatsaM mAritavAn| ");
INSERT INTO sanitr_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","tataH sa prakupya niveshanAntaH praveShTuM na sammene; tatastasya pitA bahirAgatya taM sAdhayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","tataH sa pitaraM pratyuvAcha, pashya tava kA nchidapyAj nAM na vilaMghya bahUn vatsarAn ahaM tvAM seve tathApi mitraiH sArddham utsavaM karttuM kadApi ChAgamekamapi mahyaM nAdadAH; ");
INSERT INTO sanitr_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","kintu tava yaH putro veshyAgamanAdibhistava sampattim apavyayitavAn tasminnAgatamAtre tasyaiva nimittaM puShTaM govatsaM mAritavAn| ");
INSERT INTO sanitr_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","tadA tasya pitAvochat, he putra tvaM sarvvadA mayA sahAsi tasmAn mama yadyadAste tatsarvvaM tava| ");
INSERT INTO sanitr_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","kintu tavAyaM bhrAtA mR^itaH punarajIvId hAritashcha bhUtvA prAptobhUt, etasmAt kAraNAd utsavAnandau karttum uchitamasmAkam| ");
INSERT INTO sanitr_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","apara ncha yIshuH shiShyebhyonyAmekAM kathAM kathayAmAsa kasyachid dhanavato manuShyasya gR^ihakAryyAdhIshe sampatterapavyaye.apavAdite sati ");
INSERT INTO sanitr_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","tasya prabhustam AhUya jagAda, tvayi yAmimAM kathAM shR^iNomi sA kIdR^ishI? tvaM gR^ihakAryyAdhIshakarmmaNo gaNanAM darshaya gR^ihakAryyAdhIshapade tvaM na sthAsyasi| ");
INSERT INTO sanitr_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","tadA sa gR^ihakAryyAdhIsho manasA chintayAmAsa, prabhu ryadi mAM gR^ihakAryyAdhIshapadAd bhraMshayati tarhi kiM kariShye.ahaM? mR^idaM khanituM mama shakti rnAsti bhikShitu ncha lajjiShye.ahaM| ");
INSERT INTO sanitr_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ataeva mayi gR^ihakAryyAdhIshapadAt chyute sati yathA lokA mahyam AshrayaM dAsyanti tadarthaM yatkarmma mayA karaNIyaM tan nirNIyate| ");
INSERT INTO sanitr_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","pashchAt sa svaprabhorekaikam adhamarNam AhUya prathamaM paprachCha, tvatto me prabhuNA kati prApyam? ");
INSERT INTO sanitr_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","tataH sa uvAcha, ekashatADhakatailAni; tadA gR^ihakAryyAdhIshaH provAcha, tava patramAnIya shIghramupavishya tatra pa nchAshataM likha| ");
INSERT INTO sanitr_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","pashchAdanyamekaM paprachCha, tvatto me prabhuNA kati prApyam? tataH sovAdId ekashatADhakagodhUmAH; tadA sa kathayAmAsa, tava patramAnIya ashItiM likha| ");
INSERT INTO sanitr_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","tenaiva prabhustamayathArthakR^itam adhIshaM tadbuddhinaipuNyAt prashashaMsa; itthaM dIptirUpasantAnebhya etatsaMsArasya santAnA varttamAnakAle.adhikabuddhimanto bhavanti| ");
INSERT INTO sanitr_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","ato vadAmi yUyamapyayathArthena dhanena mitrANi labhadhvaM tato yuShmAsu padabhraShTeShvapi tAni chirakAlam AshrayaM dAsyanti| ");
INSERT INTO sanitr_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","yaH kashchit kShudre kAryye vishvAsyo bhavati sa mahati kAryyepi vishvAsyo bhavati, kintu yaH kashchit kShudre kAryye.avishvAsyo bhavati sa mahati kAryyepyavishvAsyo bhavati| ");
INSERT INTO sanitr_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ataeva ayathArthena dhanena yadi yUyamavishvAsyA jAtAstarhi satyaM dhanaM yuShmAkaM kareShu kaH samarpayiShyati? ");
INSERT INTO sanitr_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","yadi cha paradhanena yUyam avishvAsyA bhavatha tarhi yuShmAkaM svakIyadhanaM yuShmabhyaM ko dAsyati? ");
INSERT INTO sanitr_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","kopi dAsa ubhau prabhU sevituM na shaknoti, yata ekasmin prIyamANo.anyasminnaprIyate yadvA ekaM janaM samAdR^itya tadanyaM tuchChIkaroti tadvad yUyamapi dhaneshvarau sevituM na shaknutha| ");
INSERT INTO sanitr_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","tadaitAH sarvvAH kathAH shrutvA lobhiphirUshinastamupajahasuH| ");
INSERT INTO sanitr_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","tataH sa uvAcha, yUyaM manuShyANAM nikaTe svAn nirdoShAn darshayatha kintu yuShmAkam antaHkaraNAnIshvaro jAnAti, yat manuShyANAm ati prashaMsyaM tad Ishvarasya ghR^iNyaM| ");
INSERT INTO sanitr_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","yohana AgamanaparyyanataM yuShmAkaM samIpe vyavasthAbhaviShyadvAdinAM lekhanAni chAsan tataH prabhR^iti IshvararAjyasya susaMvAdaH pracharati, ekaiko lokastanmadhyaM yatnena pravishati cha| ");
INSERT INTO sanitr_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","varaM nabhasaH pR^ithivyAshcha lopo bhaviShyati tathApi vyavasthAyA ekabindorapi lopo na bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","yaH kashchit svIyAM bhAryyAM vihAya striyamanyAM vivahati sa paradArAn gachChati, yashcha tA tyaktAM nArIM vivahati sopi paradArAna gachChati| ");
INSERT INTO sanitr_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","eko dhanI manuShyaH shuklAni sUkShmANi vastrANi paryyadadhAt pratidinaM paritoSharUpeNAbhuMktApivachcha| ");
INSERT INTO sanitr_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","sarvvA Nge kShatayukta iliyAsaranAmA kashchid daridrastasya dhanavato bhojanapAtrAt patitam uchChiShTaM bhoktuM vA nChan tasya dvAre patitvAtiShThat; ");
INSERT INTO sanitr_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","atha shvAna Agatya tasya kShatAnyalihan| ");
INSERT INTO sanitr_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","kiyatkAlAtparaM sa daridraH prANAn jahau; tataH svargIyadUtAstaM nItvA ibrAhImaH kroDa upaveshayAmAsuH| ");
INSERT INTO sanitr_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","pashchAt sa dhanavAnapi mamAra, taM shmashAne sthApayAmAsushcha; kintu paraloke sa vedanAkulaH san UrddhvAM nirIkShya bahudUrAd ibrAhImaM tatkroDa iliyAsara ncha vilokya ruvannuvAcha; ");
INSERT INTO sanitr_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","he pitar ibrAhIm anugR^ihya a NgulyagrabhAgaM jale majjayitvA mama jihvAM shItalAM karttum iliyAsaraM preraya, yato vahnishikhAtohaM vyathitosmi| ");
INSERT INTO sanitr_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","tadA ibrAhIm babhAShe, he putra tvaM jIvan sampadaM prAptavAn iliyAsarastu vipadaM prAptavAn etat smara, kintu samprati tasya sukhaM tava cha duHkhaM bhavati| ");
INSERT INTO sanitr_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","aparamapi yuShmAkam asmAka ncha sthAnayo rmadhye mahadvichChedo.asti tata etatsthAnasya lokAstat sthAnaM yAtuM yadvA tatsthAnasya lokA etat sthAnamAyAtuM na shaknuvanti| ");
INSERT INTO sanitr_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","tadA sa uktavAn, he pitastarhi tvAM nivedayAmi mama pitu rgehe ye mama pa ncha bhrAtaraH santi ");
INSERT INTO sanitr_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","te yathaitad yAtanAsthAnaM nAyAsyanti tathA mantraNAM dAtuM teShAM samIpam iliyAsaraM preraya| ");
INSERT INTO sanitr_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","tata ibrAhIm uvAcha, mUsAbhaviShyadvAdinA ncha pustakAni teShAM nikaTe santi te tadvachanAni manyantAM| ");
INSERT INTO sanitr_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","tadA sa nivedayAmAsa, he pitar ibrAhIm na tathA, kintu yadi mR^italokAnAM kashchit teShAM samIpaM yAti tarhi te manAMsi vyAghoTayiShyanti| ");
INSERT INTO sanitr_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","tata ibrAhIm jagAda, te yadi mUsAbhaviShyadvAdinA ncha vachanAni na manyante tarhi mR^italokAnAM kasmiMshchid utthitepi te tasya mantraNAM na maMsyante| ");
INSERT INTO sanitr_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","itaH paraM yIshuH shiShyAn uvAcha, vighnairavashyam AgantavyaM kintu vighnA yena ghaTiShyante tasya durgati rbhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","eteShAM kShudraprANinAm ekasyApi vighnajananAt kaNThabaddhapeShaNIkasya tasya sAgarAgAdhajale majjanaM bhadraM| ");
INSERT INTO sanitr_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","yUyaM sveShu sAvadhAnAstiShThata; tava bhrAtA yadi tava ki nchid aparAdhyati tarhi taM tarjaya, tena yadi manaH parivarttayati tarhi taM kShamasva| ");
INSERT INTO sanitr_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","punarekadinamadhye yadi sa tava saptakR^itvo.aparAdhyati kintu saptakR^itva Agatya manaH parivartya mayAparAddham iti vadati tarhi taM kShamasva| ");
INSERT INTO sanitr_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","tadA preritAH prabhum avadan asmAkaM vishvAsaM varddhaya| ");
INSERT INTO sanitr_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","prabhuruvAcha, yadi yuShmAkaM sarShapaikapramANo vishvAsosti tarhi tvaM samUlamutpATito bhUtvA samudre ropito bhava kathAyAm etasyAm etaduDumbarAya kathitAyAM sa yuShmAkamAj nAvaho bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","aparaM svadAse halaM vAhayitvA vA pashUn chArayitvA kShetrAd Agate sati taM vadati, ehi bhoktumupavisha, yuShmAkam etAdR^ishaH kosti? ");
INSERT INTO sanitr_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","vara ncha pUrvvaM mama khAdyamAsAdya yAvad bhu nje pivAmi cha tAvad baddhakaTiH parichara pashchAt tvamapi bhokShyase pAsyasi cha kathAmIdR^ishIM kiM na vakShyati? ");
INSERT INTO sanitr_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","tena dAsena prabhorAj nAnurUpe karmmaNi kR^ite prabhuH kiM tasmin bAdhito jAtaH? netthaM budhyate mayA| ");
INSERT INTO sanitr_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","itthaM nirUpiteShu sarvvakarmmasu kR^iteShu satmu yUyamapIdaM vAkyaM vadatha, vayam anupakAriNo dAsA asmAbhiryadyatkarttavyaM tanmAtrameva kR^itaM| ");
INSERT INTO sanitr_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","sa yirUshAlami yAtrAM kurvvan shomiroNgAlIlpradeshamadhyena gachChati, ");
INSERT INTO sanitr_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","etarhi kutrachid grAme praveshamAtre dashakuShThinastaM sAkShAt kR^itvA ");
INSERT INTO sanitr_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","dUre tiShThanata uchchai rvaktumArebhire, he prabho yIsho dayasvAsmAn| ");
INSERT INTO sanitr_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","tataH sa tAn dR^iShTvA jagAda, yUyaM yAjakAnAM samIpe svAn darshayata, tataste gachChanto rogAt pariShkR^itAH| ");
INSERT INTO sanitr_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","tadA teShAmekaH svaM svasthaM dR^iShTvA prochchairIshvaraM dhanyaM vadan vyAghuTyAyAto yIsho rguNAnanuvadan tachcharaNAdhobhUmau papAta; ");
INSERT INTO sanitr_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","sa chAsIt shomiroNI| ");
INSERT INTO sanitr_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","tadA yIshuravadat, dashajanAH kiM na pariShkR^itAH? tahyanye navajanAH kutra? ");
INSERT INTO sanitr_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","IshvaraM dhanyaM vadantam enaM videshinaM vinA kopyanyo na prApyata| ");
INSERT INTO sanitr_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","tadA sa tamuvAcha, tvamutthAya yAhi vishvAsaste tvAM svasthaM kR^itavAn| ");
INSERT INTO sanitr_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","atha kadeshvarasya rAjatvaM bhaviShyatIti phirUshibhiH pR^iShTe sa pratyuvAcha, Ishvarasya rAjatvam aishvaryyadarshanena na bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ata etasmin pashya tasmin vA pashya, iti vAkyaM lokA vaktuM na shakShyanti, Ishvarasya rAjatvaM yuShmAkam antarevAste| ");
INSERT INTO sanitr_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","tataH sa shiShyAn jagAda, yadA yuShmAbhi rmanujasutasya dinamekaM draShTum vA nChiShyate kintu na darshiShyate, IdR^ikkAla AyAti| ");
INSERT INTO sanitr_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","tadAtra pashya vA tatra pashyeti vAkyaM lokA vakShyanti, kintu teShAM pashchAt mA yAta, mAnugachChata cha| ");
INSERT INTO sanitr_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","yatastaDid yathAkAshaikadishyudiya tadanyAmapi dishaM vyApya prakAshate tadvat nijadine manujasUnuH prakAshiShyate| ");
INSERT INTO sanitr_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","kintu tatpUrvvaM tenAnekAni duHkhAni bhoktavyAnyetadvarttamAnalokaishcha so.avaj nAtavyaH| ");
INSERT INTO sanitr_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","nohasya vidyamAnakAle yathAbhavat manuShyasUnoH kAlepi tathA bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","yAvatkAlaM noho mahApotaM nArohad AplAvivAryyetya sarvvaM nAnAshayachcha tAvatkAlaM yathA lokA abhu njatApivan vyavahan vyavAhayaMshcha; ");
INSERT INTO sanitr_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","itthaM loTo varttamAnakAlepi yathA lokA bhojanapAnakrayavikrayaropaNagR^ihanirmmANakarmmasu prAvarttanta, ");
INSERT INTO sanitr_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","kintu yadA loT sidomo nirjagAma tadA nabhasaH sagandhakAgnivR^iShTi rbhUtvA sarvvaM vyanAshayat ");
INSERT INTO sanitr_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","tadvan mAnavaputraprakAshadinepi bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","tadA yadi kashchid gR^ihopari tiShThati tarhi sa gR^ihamadhyAt kimapi dravyamAnetum avaruhya naitu; yashcha kShetre tiShThati sopi vyAghuTya nAyAtu| ");
INSERT INTO sanitr_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","loTaH patnIM smarata| ");
INSERT INTO sanitr_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","yaH prANAn rakShituM cheShTiShyate sa prANAn hArayiShyati yastu prANAn hArayiShyati saeva prANAn rakShiShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","yuShmAnahaM vachmi tasyAM rAtrau shayyaikagatayo rlokayoreko dhAriShyate parastyakShyate| ");
INSERT INTO sanitr_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","striyau yugapat peShaNIM vyAvarttayiShyatastayorekA dhAriShyate parAtyakShyate| ");
INSERT INTO sanitr_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","puruShau kShetre sthAsyatastayoreko dhAriShyate parastyakShyate| ");
INSERT INTO sanitr_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","tadA te paprachChuH, he prabho kutretthaM bhaviShyati? tataH sa uvAcha, yatra shavastiShThati tatra gR^idhrA milanti| ");
INSERT INTO sanitr_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","apara ncha lokairaklAntai rnirantaraM prArthayitavyam ityAshayena yIshunA dR^iShTAnta ekaH kathitaH| ");
INSERT INTO sanitr_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","kutrachinnagare kashchit prADvivAka AsIt sa IshvarAnnAbibhet mAnuShAMshcha nAmanyata| ");
INSERT INTO sanitr_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","atha tatpuravAsinI kAchidvidhavA tatsamIpametya vivAdinA saha mama vivAdaM pariShkurvviti nivedayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","tataH sa prADvivAkaH kiyaddinAni na tada NgIkR^itavAn pashchAchchitte chintayAmAsa, yadyapIshvarAnna bibhemi manuShyAnapi na manye ");
INSERT INTO sanitr_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","tathApyeShA vidhavA mAM klishnAti tasmAdasyA vivAdaM pariShkariShyAmi nochet sA sadAgatya mAM vyagraM kariShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","pashchAt prabhuravadad asAvanyAyaprADvivAko yadAha tatra mano nidhadhvaM| ");
INSERT INTO sanitr_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ishvarasya ye .abhiruchitalokA divAnishaM prArthayante sa bahudinAni vilambyApi teShAM vivAdAn kiM na pariShkariShyati? ");
INSERT INTO sanitr_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","yuShmAnahaM vadAmi tvarayA pariShkariShyati, kintu yadA manuShyaputra AgamiShyati tadA pR^ithivyAM kimIdR^ishaM vishvAsaM prApsyati? ");
INSERT INTO sanitr_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ye svAn dhArmmikAn j nAtvA parAn tuchChIkurvvanti etAdR^igbhyaH, kiyadbhya imaM dR^iShTAntaM kathayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","ekaH phirUshyaparaH karasa nchAyI dvAvimau prArthayituM mandiraM gatau| ");
INSERT INTO sanitr_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","tato.asau phirUshyekapArshve tiShThan he Ishvara ahamanyalokavat loThayitAnyAyI pAradArikashcha na bhavAmi asya karasa nchAyinastulyashcha na, tasmAttvAM dhanyaM vadAmi| ");
INSERT INTO sanitr_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","saptasu dineShu dinadvayamupavasAmi sarvvasampatte rdashamAMshaM dadAmi cha, etatkathAM kathayan prArthayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","kintu sa karasa nchAyi dUre tiShThan svargaM draShTuM nechChan vakShasi karAghAtaM kurvvan he Ishvara pApiShThaM mAM dayasva, itthaM prArthayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","yuShmAnahaM vadAmi, tayordvayo rmadhye kevalaH karasa nchAyI puNyavattvena gaNito nijagR^ihaM jagAma, yato yaH kashchit svamunnamayati sa nAmayiShyate kintu yaH kashchit svaM namayati sa unnamayiShyate| ");
INSERT INTO sanitr_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","atha shishUnAM gAtrasparshArthaM lokAstAn tasya samIpamAninyuH shiShyAstad dR^iShTvAnetR^in tarjayAmAsuH, ");
INSERT INTO sanitr_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","kintu yIshustAnAhUya jagAda, mannikaTam AgantuM shishUn anujAnIdhvaM tAMshcha mA vArayata; yata IshvararAjyAdhikAriNa eShAM sadR^ishAH| ");
INSERT INTO sanitr_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ahaM yuShmAn yathArthaM vadAmi, yo janaH shishoH sadR^isho bhUtvA IshvararAjyaM na gR^ihlAti sa kenApi prakAreNa tat praveShTuM na shaknoti| ");
INSERT INTO sanitr_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","aparam ekodhipatistaM paprachCha, he paramaguro, anantAyuShaH prAptaye mayA kiM karttavyaM? ");
INSERT INTO sanitr_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","yIshuruvAcha, mAM kutaH paramaM vadasi? IshvaraM vinA kopi paramo na bhavati| ");
INSERT INTO sanitr_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","paradArAn mA gachCha, naraM mA jahi, mA choraya, mithyAsAkShyaM mA dehi, mAtaraM pitara ncha saMmanyasva, etA yA Aj nAH santi tAstvaM jAnAsi| ");
INSERT INTO sanitr_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","tadA sa uvAcha, bAlyakAlAt sarvvA etA AcharAmi| ");
INSERT INTO sanitr_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","iti kathAM shrutvA yIshustamavadat, tathApi tavaikaM karmma nyUnamAste, nijaM sarvvasvaM vikrIya daridrebhyo vitara, tasmAt svarge dhanaM prApsyasi; tata Agatya mamAnugAmI bhava| ");
INSERT INTO sanitr_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","kintvetAM kathAM shrutvA sodhipatiH shushocha, yatastasya bahudhanamAsIt| ");
INSERT INTO sanitr_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","tadA yIshustamatishokAnvitaM dR^iShTvA jagAda, dhanavatAm IshvararAjyapraveshaH kIdR^ig duShkaraH| ");
INSERT INTO sanitr_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","IshvararAjye dhaninaH praveshAt sUcheshChidreNa mahA Ngasya gamanAgamane sukare| ");
INSERT INTO sanitr_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","shrotAraH paprachChustarhi kena paritrANaM prApsyate? ");
INSERT INTO sanitr_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","sa uktavAn, yan mAnuSheNAshakyaM tad IshvareNa shakyaM| ");
INSERT INTO sanitr_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","tadA pitara uvAcha, pashya vayaM sarvvasvaM parityajya tava pashchAdgAmino.abhavAma| ");
INSERT INTO sanitr_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","tataH sa uvAcha, yuShmAnahaM yathArthaM vadAmi, IshvararAjyArthaM gR^ihaM pitarau bhrAtR^igaNaM jAyAM santAnAMshcha tyaktavA ");
INSERT INTO sanitr_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","iha kAle tato.adhikaM parakAle .anantAyushcha na prApsyati loka IdR^ishaH kopi nAsti| ");
INSERT INTO sanitr_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","anantaraM sa dvAdashashiShyAnAhUya babhAShe, pashyata vayaM yirUshAlamnagaraM yAmaH, tasmAt manuShyaputre bhaviShyadvAdibhiruktaM yadasti tadanurUpaM taM prati ghaTiShyate; ");
INSERT INTO sanitr_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","vastutastu so.anyadeshIyAnAM hasteShu samarpayiShyate, te tamupahasiShyanti, anyAyamAchariShyanti tadvapuShi niShThIvaM nikShepsyanti, kashAbhiH prahR^itya taM haniShyanti cha, ");
INSERT INTO sanitr_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","kintu tR^itIyadine sa shmashAnAd utthAsyati| ");
INSERT INTO sanitr_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","etasyAH kathAyA abhiprAyaM ki nchidapi te boddhuM na shekuH teShAM nikaTe.aspaShTatavAt tasyaitAsAM kathAnAm AshayaM te j nAtuM na shekushcha| ");
INSERT INTO sanitr_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","atha tasmin yirIhoH purasyAntikaM prApte kashchidandhaH pathaH pArshva upavishya bhikShAm akarot ");
INSERT INTO sanitr_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","sa lokasamUhasya gamanashabdaM shrutvA tatkAraNaM pR^iShTavAn| ");
INSERT INTO sanitr_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","nAsaratIyayIshuryAtIti lokairukte sa uchchairvaktumArebhe, ");
INSERT INTO sanitr_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","he dAyUdaH santAna yIsho mAM dayasva| ");
INSERT INTO sanitr_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","tatogragAminastaM maunI tiShTheti tarjayAmAsuH kintu sa punAruvan uvAcha, he dAyUdaH santAna mAM dayasva| ");
INSERT INTO sanitr_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","tadA yIshuH sthagito bhUtvA svAntike tamAnetum Adidesha| ");
INSERT INTO sanitr_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","tataH sa tasyAntikam Agamat, tadA sa taM paprachCha, tvaM kimichChasi? tvadarthamahaM kiM kariShyAmi? sa uktavAn, he prabho.ahaM draShTuM labhai| ");
INSERT INTO sanitr_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","tadA yIshuruvAcha, dR^iShTishaktiM gR^ihANa tava pratyayastvAM svasthaM kR^itavAn| ");
INSERT INTO sanitr_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","tatastatkShaNAt tasya chakShuShI prasanne; tasmAt sa IshvaraM dhanyaM vadan tatpashchAd yayau, tadAlokya sarvve lokA IshvaraM prashaMsitum Arebhire| ");
INSERT INTO sanitr_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","yadA yIshu ryirIhopuraM pravishya tanmadhyena gachChaMstadA ");
INSERT INTO sanitr_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","sakkeyanAmA karasa nchAyinAM pradhAno dhanavAneko ");
INSERT INTO sanitr_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","yIshuH kIdR^igiti draShTuM cheShTitavAn kintu kharvvatvAllokasaMghamadhye taddarshanamaprApya ");
INSERT INTO sanitr_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","yena pathA sa yAsyati tatpathe.agre dhAvitvA taM draShTum uDumbaratarumAruroha| ");
INSERT INTO sanitr_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","pashchAd yIshustatsthAnam itvA UrddhvaM vilokya taM dR^iShTvAvAdIt, he sakkeya tvaM shIghramavaroha mayAdya tvadgehe vastavyaM| ");
INSERT INTO sanitr_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","tataH sa shIghramavaruhya sAhlAdaM taM jagrAha| ");
INSERT INTO sanitr_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","tad dR^iShTvA sarvve vivadamAnA vaktumArebhire, sotithitvena duShTalokagR^ihaM gachChati| ");
INSERT INTO sanitr_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","kintu sakkeyo daNDAyamAno vaktumArebhe, he prabho pashya mama yA sampattirasti tadarddhaM daridrebhyo dade, aparam anyAyaM kR^itvA kasmAdapi yadi kadApi ki nchit mayA gR^ihItaM tarhi tachchaturguNaM dadAmi| ");
INSERT INTO sanitr_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","tadA yIshustamuktavAn ayamapi ibrAhImaH santAno.ataH kAraNAd adyAsya gR^ihe trANamupasthitaM| ");
INSERT INTO sanitr_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","yad hAritaM tat mR^igayituM rakShitu ncha manuShyaputra AgatavAn| ");
INSERT INTO sanitr_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","atha sa yirUshAlamaH samIpa upAtiShThad IshvararAjatvasyAnuShThAnaM tadaiva bhaviShyatIti lokairanvabhUyata, tasmAt sa shrotR^ibhyaH punardR^iShTAntakathAm utthApya kathayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","kopi mahAlloko nijArthaM rAjatvapadaM gR^ihItvA punarAgantuM dUradeshaM jagAma| ");
INSERT INTO sanitr_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","yAtrAkAle nijAn dashadAsAn AhUya dashasvarNamudrA dattvA mamAgamanaparyyantaM vANijyaM kurutetyAdidesha| ");
INSERT INTO sanitr_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","kintu tasya prajAstamavaj nAya manuShyamenam asmAkamupari rAjatvaM na kArayivyAma imAM vArttAM tannikaTe prerayAmAsuH| ");
INSERT INTO sanitr_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","atha sa rAjatvapadaM prApyAgatavAn ekaiko jano bANijyena kiM labdhavAn iti j nAtuM yeShu dAseShu mudrA arpayat tAn AhUyAnetum Adidesha| ");
INSERT INTO sanitr_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","tadA prathama Agatya kathitavAn, he prabho tava tayaikayA mudrayA dashamudrA labdhAH| ");
INSERT INTO sanitr_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","tataH sa uvAcha tvamuttamo dAsaH svalpena vishvAsyo jAta itaH kAraNAt tvaM dashanagarANAm adhipo bhava| ");
INSERT INTO sanitr_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","dvitIya Agatya kathitavAn, he prabho tavaikayA mudrayA pa nchamudrA labdhAH| ");
INSERT INTO sanitr_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","tataH sa uvAcha, tvaM pa nchAnAM nagarANAmadhipati rbhava| ");
INSERT INTO sanitr_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","tatonya Agatya kathayAmAsa, he prabho pashya tava yA mudrA ahaM vastre baddhvAsthApayaM seyaM| ");
INSERT INTO sanitr_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","tvaM kR^ipaNo yannAsthApayastadapi gR^ihlAsi, yannAvapastadeva cha Chinatsi tatohaM tvatto bhItaH| ");
INSERT INTO sanitr_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","tadA sa jagAda, re duShTadAsa tava vAkyena tvAM doShiNaM kariShyAmi, yadahaM nAsthApayaM tadeva gR^ihlAmi, yadahaM nAvapa ncha tadeva Chinadmi, etAdR^ishaH kR^ipaNohamiti yadi tvaM jAnAsi, ");
INSERT INTO sanitr_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","tarhi mama mudrA baNijAM nikaTe kuto nAsthApayaH? tayA kR^ite.aham Agatya kusIdena sArddhaM nijamudrA aprApsyam| ");
INSERT INTO sanitr_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","pashchAt sa samIpasthAn janAn Aj nApayat asmAt mudrA AnIya yasya dashamudrAH santi tasmai datta| ");
INSERT INTO sanitr_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","te prochuH prabho.asya dashamudrAH santi| ");
INSERT INTO sanitr_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","yuShmAnahaM vadAmi yasyAshraye vaddhate .adhikaM tasmai dAyiShyate, kintu yasyAshraye na varddhate tasya yadyadasti tadapi tasmAn nAyiShyate| ");
INSERT INTO sanitr_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","kintu mamAdhipatitvasya vashatve sthAtum asammanyamAnA ye mama ripavastAnAnIya mama samakShaM saMharata| ");
INSERT INTO sanitr_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ityupadeshakathAM kathayitvA sogragaH san yirUshAlamapuraM yayau| ");
INSERT INTO sanitr_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","tato baitphagIbaithanIyAgrAmayoH samIpe jaitunAdrerantikam itvA shiShyadvayam ityuktvA preShayAmAsa, ");
INSERT INTO sanitr_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","yuvAmamuM sammukhasthagrAmaM pravishyaiva yaM kopi mAnuShaH kadApi nArohat taM garddabhashAvakaM baddhaM drakShyathastaM mochayitvAnayataM| ");
INSERT INTO sanitr_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","tatra kuto mochayathaH? iti chet kopi vakShyati tarhi vakShyathaH prabheाratra prayojanam Aste| ");
INSERT INTO sanitr_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","tadA tau praritau gatvA tatkathAाnusAreNa sarvvaM prAptau| ");
INSERT INTO sanitr_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","gardabhashAvakamochanakAle tatvAmina UchuH, gardabhashAvakaM kuto mochayathaH? ");
INSERT INTO sanitr_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","tAvUchatuH prabhoratra prayojanam Aste| ");
INSERT INTO sanitr_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","pashchAt tau taM gardabhashAvakaM yIshorantikamAnIya tatpR^iShThe nijavasanAni pAtayitvA tadupari yIshumArohayAmAsatuH| ");
INSERT INTO sanitr_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","atha yAtrAkAle lokAH pathi svavastrANi pAtayitum Arebhire| ");
INSERT INTO sanitr_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","aparaM jaitunAdrerupatyakAm itvA shiShyasaMghaH pUrvvadR^iShTAni mahAkarmmANi smR^itvA, ");
INSERT INTO sanitr_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","yo rAjA prabho rnAmnAyAti sa dhanyaH svarge kushalaM sarvvochche jayadhvani rbhavatu, kathAmetAM kathayitvA sAnandam uchairIshvaraM dhanyaM vaktumArebhe| ");
INSERT INTO sanitr_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","tadA lokAraNyamadhyasthAH kiyantaH phirUshinastat shrutvA yIshuM prochuH, he upadeshaka svashiShyAn tarjaya| ");
INSERT INTO sanitr_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","sa uvAcha, yuShmAnahaM vadAmi yadyamI nIravAstiShThanti tarhi pAShANA uchaiH kathAH kathayiShyanti| ");
INSERT INTO sanitr_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","pashchAt tatpurAntikametya tadavalokya sAshrupAtaM jagAda, ");
INSERT INTO sanitr_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","hA hA chet tvamagre.aj nAsyathAH, tavAsminneva dine vA yadi svama Ngalam upAlapsyathAH, tarhyuttamam abhaviShyat, kintu kShaNesmin tattava dR^iShTeragocharam bhavati| ");
INSERT INTO sanitr_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","tvaM svatrANakAle na mano nyadhatthA iti heto ryatkAle tava ripavastvAM chaturdikShu prAchIreNa veShTayitvA rotsyanti ");
INSERT INTO sanitr_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","bAlakaiH sArddhaM bhUmisAt kariShyanti cha tvanmadhye pAShANaikopi pAShANopari na sthAsyati cha, kAla IdR^isha upasthAsyati| ");
INSERT INTO sanitr_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","atha madhyemandiraM pravishya tatratyAn krayivikrayiNo bahiShkurvvan ");
INSERT INTO sanitr_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","avadat madgR^ihaM prArthanAgR^ihamiti lipirAste kintu yUyaM tadeva chairANAM gahvaraM kurutha| ");
INSERT INTO sanitr_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","pashchAt sa pratyahaM madhyemandiram upadidesha; tataH pradhAnayAjakA adhyApakAH prAchInAshcha taM nAshayituM chicheShTire; ");
INSERT INTO sanitr_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","kintu tadupadeshe sarvve lokA niviShTachittAH sthitAstasmAt te tatkarttuM nAvakAshaM prApuH| ");
INSERT INTO sanitr_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","athaikadA yIshu rmanidare susaMvAdaM prachArayan lokAnupadishati, etarhi pradhAnayAjakA adhyApakAH prA nchashcha tannikaTamAgatya paprachChuH ");
INSERT INTO sanitr_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","kayAj nayA tvaM karmmANyetAni karoShi? ko vA tvAmAj nApayat? tadasmAn vada| ");
INSERT INTO sanitr_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","sa pratyuvAcha, tarhi yuShmAnapi kathAmekAM pR^ichChAmi tasyottaraM vadata| ");
INSERT INTO sanitr_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","yohano majjanam Ishvarasya mAnuShANAM vAj nAto jAtaM? ");
INSERT INTO sanitr_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","tataste mitho vivichya jagaduH, yadIshvarasya vadAmastarhi taM kuto na pratyaita sa iti vakShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","yadi manuShyasyeti vadAmastarhi sarvve lokA asmAn pAShANai rhaniShyanti yato yohan bhaviShyadvAdIti sarvve dR^iDhaM jAnanti| ");
INSERT INTO sanitr_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ataeva te pratyUchuH kasyAj nayA jAtam iti vaktuM na shaknumaH| ");
INSERT INTO sanitr_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","tadA yIshuravadat tarhi kayAj nayA karmmANyetAti karomIti cha yuShmAn na vakShyAmi| ");
INSERT INTO sanitr_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","atha lokAnAM sAkShAt sa imAM dR^iShTAntakathAM vaktumArebhe, kashchid drAkShAkShetraM kR^itvA tat kShetraM kR^iShIvalAnAM hasteShu samarpya bahukAlArthaM dUradeshaM jagAma| ");
INSERT INTO sanitr_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","atha phalakAle phalAni grahItu kR^iShIvalAnAM samIpe dAsaM prAhiNot kintu kR^iShIvalAstaM prahR^itya riktahastaM visasarjuH| ");
INSERT INTO sanitr_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","tataH sodhipatiH punaranyaM dAsaM preShayAmAsa, te tamapi prahR^itya kuvyavahR^itya riktahastaM visasR^ijuH| ");
INSERT INTO sanitr_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","tataH sa tR^itIyavAram anyaM prAhiNot te tamapi kShatA NgaM kR^itvA bahi rnichikShipuH| ");
INSERT INTO sanitr_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","tadA kShetrapati rvichArayAmAsa, mamedAnIM kiM karttavyaM? mama priye putre prahite te tamavashyaM dR^iShTvA samAdariShyante| ");
INSERT INTO sanitr_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","kintu kR^iShIvalAstaM nirIkShya parasparaM vivichya prochuH, ayamuttarAdhikArI AgachChatainaM hanmastatodhikArosmAkaM bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","tataste taM kShetrAd bahi rnipAtya jaghnustasmAt sa kShetrapatistAn prati kiM kariShyati? ");
INSERT INTO sanitr_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","sa Agatya tAn kR^iShIvalAn hatvA pareShAM hasteShu tatkShetraM samarpayiShyati; iti kathAM shrutvA te .avadan etAdR^ishI ghaTanA na bhavatu| ");
INSERT INTO sanitr_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","kintu yIshustAnavalokya jagAda, tarhi, sthapatayaH kariShyanti grAvANaM yantu tuchChakaM| pradhAnaprastaraH koNe sa eva hi bhaviShyati| etasya shAstrIyavachanasya kiM tAtparyyaM? ");
INSERT INTO sanitr_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","aparaM tatpAShANopari yaH patiShyati sa bhaMkShyate kintu yasyopari sa pAShANaH patiShyati sa tena dhUlivach chUrNIbhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","sosmAkaM viruddhaM dR^iShTAntamimaM kathitavAn iti j nAtvA pradhAnayAjakA adhyApakAshcha tadaiva taM dhartuM vavA nChuH kintu lokebhyo bibhyuH| ");
INSERT INTO sanitr_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ataeva taM prati satarkAH santaH kathaM tadvAkyadoShaM dhR^itvA taM deshAdhipasya sAdhuveshadhAriNashcharAn tasya samIpe preShayAmAsuH| ");
INSERT INTO sanitr_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","tadA te taM paprachChuH, he upadeshaka bhavAn yathArthaM kathayan upadishati, kamapyanapekShya satyatvenaishvaraM mArgamupadishati, vayametajjAnImaH| ");
INSERT INTO sanitr_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","kaisararAjAya karosmAbhi rdeyo na vA? ");
INSERT INTO sanitr_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","sa teShAM va nchanaM j nAtvAvadat kuto mAM parIkShadhve? mAM mudrAmekaM darshayata| ");
INSERT INTO sanitr_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","iha likhitA mUrtiriyaM nAma cha kasya? te.avadan kaisarasya| ");
INSERT INTO sanitr_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","tadA sa uvAcha, tarhi kaisarasya dravyaM kaisarAya datta; Ishvarasya tu dravyamIshvarAya datta| ");
INSERT INTO sanitr_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","tasmAllokAnAM sAkShAt tatkathAyAH kamapi doShaM dhartumaprApya te tasyottarAd AshcharyyaM manyamAnA mauninastasthuH| ");
INSERT INTO sanitr_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","apara ncha shmashAnAdutthAnAna NgIkAriNAM sidUkinAM kiyanto janA Agatya taM paprachChuH, ");
INSERT INTO sanitr_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","he upadeshaka shAstre mUsA asmAn pratIti lilekha yasya bhrAtA bhAryyAyAM satyAM niHsantAno mriyate sa tajjAyAM vivahya tadvaMsham utpAdayiShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","tathAcha kechit sapta bhrAtara Asan teShAM jyeShTho bhrAtA vivahya nirapatyaH prANAn jahau| ");
INSERT INTO sanitr_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","atha dvitIyastasya jAyAM vivahya nirapatyaH san mamAra| tR^itIyashcha tAmeva vyuvAha; ");
INSERT INTO sanitr_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","itthaM sapta bhrAtarastAmeva vivahya nirapatyAH santo mamruH| ");
INSERT INTO sanitr_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","sheShe sA strI cha mamAra| ");
INSERT INTO sanitr_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ataeva shmashAnAdutthAnakAle teShAM saptajanAnAM kasya sA bhAryyA bhaviShyati? yataH sA teShAM saptAnAmeva bhAryyAsIt| ");
INSERT INTO sanitr_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","tadA yIshuH pratyuvAcha, etasya jagato lokA vivahanti vAgdattAshcha bhavanti ");
INSERT INTO sanitr_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","kintu ye tajjagatprAptiyogyatvena gaNitAM bhaviShyanti shmashAnAchchotthAsyanti te na vivahanti vAgdattAshcha na bhavanti, ");
INSERT INTO sanitr_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","te puna rna mriyante kintu shmashAnAdutthApitAH santa Ishvarasya santAnAH svargIyadUtAnAM sadR^ishAshcha bhavanti| ");
INSERT INTO sanitr_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","adhikantu mUsAH stambopAkhyAne parameshvara IbrAhIma Ishvara ishAka Ishvaro yAkUbashcheshvara ityuktvA mR^itAnAM shmashAnAd utthAnasya pramANaM lilekha| ");
INSERT INTO sanitr_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ataeva ya IshvaraH sa mR^itAnAM prabhu rna kintu jIvatAmeva prabhuH, tannikaTe sarvve jIvantaH santi| ");
INSERT INTO sanitr_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","iti shrutvA kiyantodhyApakA UchuH, he upadeshaka bhavAn bhadraM pratyuktavAn| ");
INSERT INTO sanitr_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","itaH paraM taM kimapi praShTaM teShAM pragalbhatA nAbhUt| ");
INSERT INTO sanitr_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","pashchAt sa tAn uvAcha, yaH khrIShTaH sa dAyUdaH santAna etAM kathAM lokAH kathaM kathayanti? ");
INSERT INTO sanitr_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","yataH mama prabhumidaM vAkyamavadat parameshvaraH| tava shatrUnahaM yAvat pAdapIThaM karomi na| tAvat kAlaM madIye tvaM dakShapArshva upAvisha| ");
INSERT INTO sanitr_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","iti kathAM dAyUd svayaM gItagranthe.avadat| ");
INSERT INTO sanitr_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","ataeva yadi dAyUd taM prabhuM vadati, tarhi sa kathaM tasya santAno bhavati? ");
INSERT INTO sanitr_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","pashchAd yIshuH sarvvajanAnAM karNagochare shiShyAnuvAcha, ");
INSERT INTO sanitr_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","ye.adhyApakA dIrghaparichChadaM paridhAya bhramanti, haTTApaNayo rnamaskAre bhajanagehasya prochchAsane bhojanagR^ihasya pradhAnasthAne cha prIyante ");
INSERT INTO sanitr_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","vidhavAnAM sarvvasvaM grasitvA Chalena dIrghakAlaM prArthayante cha teShu sAvadhAnA bhavata, teShAmugradaNDo bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","atha dhanilokA bhANDAgAre dhanaM nikShipanti sa tadeva pashyati, ");
INSERT INTO sanitr_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","etarhi kAchiddInA vidhavA paNadvayaM nikShipati tad dadarsha| ");
INSERT INTO sanitr_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","tato yIshuruvAcha yuShmAnahaM yathArthaM vadAmi, daridreyaM vidhavA sarvvebhyodhikaM nyakShepsIt, ");
INSERT INTO sanitr_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","yatonye svaprAjyadhanebhya IshvarAya ki nchit nyakShepsuH, kintu daridreyaM vidhavA dinayApanArthaM svasya yat ki nchit sthitaM tat sarvvaM nyakShepsIt| ");
INSERT INTO sanitr_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","apara ncha uttamaprastarairutsR^iShTavyaishcha mandiraM sushobhatetarAM kaishchidityukte sa pratyuvAcha ");
INSERT INTO sanitr_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","yUyaM yadidaM nichayanaM pashyatha, asya pAShANaikopyanyapAShANopari na sthAsyati, sarvve bhUsAdbhaviShyanti kAloyamAyAti| ");
INSERT INTO sanitr_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","tadA te paprachChuH, he guro ghaTanedR^ishI kadA bhaviShyati? ghaTanAyA etasyasashchihnaM vA kiM bhaviShyati? ");
INSERT INTO sanitr_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","tadA sa jagAda, sAvadhAnA bhavata yathA yuShmAkaM bhramaM kopi na janayati, khIShTohamityuktvA mama nAmrA bahava upasthAsyanti sa kAlaH prAyeNopasthitaH, teShAM pashchAnmA gachChata| ");
INSERT INTO sanitr_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","yuddhasyopaplavasya cha vArttAM shrutvA mA sha NkadhvaM, yataH prathamam etA ghaTanA avashyaM bhaviShyanti kintu nApAte yugAnto bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","apara ncha kathayAmAsa, tadA deshasya vipakShatvena desho rAjyasya vipakShatvena rAjyam utthAsyati, ");
INSERT INTO sanitr_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","nAnAsthAneShu mahAbhUkampo durbhikShaM mArI cha bhaviShyanti, tathA vyomamaNDalasya bhaya NkaradarshanAnyashcharyyalakShaNAni cha prakAshayiShyante| ");
INSERT INTO sanitr_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","kintu sarvvAsAmetAsAM ghaTanAnAM pUrvvaM lokA yuShmAn dhR^itvA tADayiShyanti, bhajanAlaye kArAyA ncha samarpayiShyanti mama nAmakAraNAd yuShmAn bhUpAnAM shAsakAnA ncha sammukhaM neShyanti cha| ");
INSERT INTO sanitr_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","sAkShyArtham etAni yuShmAn prati ghaTiShyante| ");
INSERT INTO sanitr_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","tadA kimuttaraM vaktavyam etat na chintayiShyAma iti manaHsu nishchitanuta| ");
INSERT INTO sanitr_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","vipakShA yasmAt kimapyuttaram Apatti ncha karttuM na shakShyanti tAdR^ishaM vAkpaTutvaM j nAna ncha yuShmabhyaM dAsyAmi| ");
INSERT INTO sanitr_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","ki ncha yUyaM pitrA mAtrA bhrAtrA bandhunA j nAtyA kuTumbena cha parakareShu samarpayiShyadhve; tataste yuShmAkaM ka nchana ka nchana ghAtayiShyanti| ");
INSERT INTO sanitr_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","mama nAmnaH kAraNAt sarvvai rmanuShyai ryUyam R^itIyiShyadhve| ");
INSERT INTO sanitr_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","kintu yuShmAkaM shiraHkeshaikopi na vinaMkShyati, ");
INSERT INTO sanitr_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","tasmAdeva dhairyyamavalambya svasvaprANAn rakShata| ");
INSERT INTO sanitr_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","apara ncha yirUshAlampuraM sainyaveShTitaM vilokya tasyochChinnatAyAH samayaH samIpa ityavagamiShyatha| ");
INSERT INTO sanitr_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","tadA yihUdAdeshasthA lokAH parvvataM palAyantAM, ye cha nagare tiShThanti te deshAntaraM palAyantA, ye cha grAme tiShThanti te nagaraM na pravishantu, ");
INSERT INTO sanitr_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","yatastadA samuchitadaNDanAya dharmmapustake yAni sarvvANi likhitAni tAni saphalAni bhaviShyanti| ");
INSERT INTO sanitr_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","kintu yA yAstadA garbhavatyaH stanyadAvyashcha tAmAM durgati rbhaviShyati, yata etAllokAn prati kopo deshe cha viShamadurgati rghaTiShyate| ");
INSERT INTO sanitr_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","vastutastu te kha NgadhAraparivva NgaM lapsyante baddhAH santaH sarvvadesheShu nAyiShyante cha ki nchAnyadeshIyAnAM samayopasthitiparyyantaM yirUshAlampuraM taiH padatalai rdalayiShyate| ");
INSERT INTO sanitr_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","sUryyachandranakShatreShu lakShaNAdi bhaviShyanti, bhuvi sarvvadeshIyAnAM duHkhaM chintA cha sindhau vIchInAM tarjanaM garjana ncha bhaviShyanti| ");
INSERT INTO sanitr_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","bhUbhau bhAvighaTanAM chintayitvA manujA bhiyAmR^itakalpA bhaviShyanti, yato vyomamaNDale tejasvino dolAyamAnA bhaviShyanti| ");
INSERT INTO sanitr_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","tadA parAkrameNA mahAtejasA cha meghArUDhaM manuShyaputram AyAntaM drakShyanti| ");
INSERT INTO sanitr_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","kintvetAsAM ghaTanAnAmArambhe sati yUyaM mastakAnyuttolya UrdadhvaM drakShyatha, yato yuShmAkaM mukteH kAlaH savidho bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","tatastenaitadR^iShTAntakathA kathitA, pashyata uDumbarAdivR^ikShANAM ");
INSERT INTO sanitr_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","navInapatrANi jAtAnIti dR^iShTvA nidAvakAla upasthita iti yathA yUyaM j nAtuM shaknutha, ");
INSERT INTO sanitr_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","tathA sarvvAsAmAsAM ghaTanAnAm Arambhe dR^iShTe satIshvarasya rAjatvaM nikaTam ityapi j nAsyatha| ");
INSERT INTO sanitr_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","yuShmAnahaM yathArthaM vadAmi, vidyamAnalokAnAmeShAM gamanAt pUrvvam etAni ghaTiShyante| ");
INSERT INTO sanitr_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","nabhobhuvorlopo bhaviShyati mama vAk tu kadApi luptA na bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","ataeva viShamAshanena pAnena cha sAMmArikachintAbhishcha yuShmAkaM chitteShu matteShu taddinam akasmAd yuShmAn prati yathA nopatiShThati tadarthaM sveShu sAvadhAnAstiShThata| ");
INSERT INTO sanitr_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","pR^ithivIsthasarvvalokAn prati taddinam unmAtha iva upasthAsyati| ");
INSERT INTO sanitr_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","yathA yUyam etadbhAvighaTanA uttarttuM manujasutasya sammukhe saMsthAtu ncha yogyA bhavatha kAraNAdasmAt sAvadhAnAH santo nirantaraM prArthayadhvaM| ");
INSERT INTO sanitr_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","apara ncha sa divA mandira upadishya rAchai jaitunAdriM gatvAtiShThat| ");
INSERT INTO sanitr_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","tataH pratyUShe lAkAstatkathAM shrotuM mandire tadantikam AgachChan| ");
INSERT INTO sanitr_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","apara ncha kiNvashUnyapUpotsavasya kAla upasthite ");
INSERT INTO sanitr_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","pradhAnayAjakA adhyAyakAshcha yathA taM hantuM shaknuvanti tathopAyAm acheShTanta kintu lokebhyo bibhyuH| ");
INSERT INTO sanitr_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","etastin samaye dvAdashashiShyeShu gaNita IShkariyotIyarUDhimAn yo yihUdAstasyAntaHkaraNaM shaitAnAshritatvAt ");
INSERT INTO sanitr_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","sa gatvA yathA yIshuM teShAM kareShu samarpayituM shaknoti tathA mantraNAM pradhAnayAjakaiH senApatibhishcha saha chakAra| ");
INSERT INTO sanitr_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","tena te tuShTAstasmai mudrAM dAtuM paNaM chakruH| ");
INSERT INTO sanitr_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","tataH so NgIkR^itya yathA lokAnAmagochare taM parakareShu samarpayituM shaknoti tathAvakAshaM cheShTitumArebhe| ");
INSERT INTO sanitr_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","atha kiNvashUnyapUpotmavadine, arthAt yasmin dine nistArotsavasya meSho hantavyastasmin dine ");
INSERT INTO sanitr_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","yIshuH pitaraM yohana nchAhUya jagAda, yuvAM gatvAsmAkaM bhojanArthaM nistArotsavasya dravyANyAsAdayataM| ");
INSERT INTO sanitr_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","tadA tau paprachChatuH kuchAsAdayAvo bhavataH kechChA? ");
INSERT INTO sanitr_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","tadA sovAdIt, nagare praviShTe kashchijjalakumbhamAdAya yuvAM sAkShAt kariShyati sa yanniveshanaM pravishati yuvAmapi tanniveshanaM tatpashchAditvA niveshanapatim iti vAkyaM vadataM, ");
INSERT INTO sanitr_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","yatrAhaM nistArotsavasya bhojyaM shiShyaiH sArddhaM bhoktuM shaknomi sAtithishAlAा kutra? kathAmimAM prabhustvAM pR^ichChati| ");
INSERT INTO sanitr_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","tataH sa jano dvitIyaprakoShThIyam ekaM shastaM koShThaM darshayiShyati tatra bhojyamAsAdayataM| ");
INSERT INTO sanitr_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","tatastau gatvA tadvAkyAnusAreNa sarvvaM dR^iShdvA tatra nistArotsavIyaM bhojyamAsAdayAmAsatuH| ");
INSERT INTO sanitr_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","atha kAla upasthite yIshu rdvAdashabhiH preritaiH saha bhoktumupavishya kathitavAn ");
INSERT INTO sanitr_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","mama duHkhabhogAt pUrvvaM yubhAbhiH saha nistArotsavasyaitasya bhojyaM bhoktuM mayAtivA nChA kR^itA| ");
INSERT INTO sanitr_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","yuShmAn vadAmi, yAvatkAlam IshvararAjye bhojanaM na kariShye tAvatkAlam idaM na bhokShye| ");
INSERT INTO sanitr_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","tadA sa pAnapAtramAdAya Ishvarasya guNAn kIrttayitvA tebhyo datvAvadat, idaM gR^ihlIta yUyaM vibhajya pivata| ");
INSERT INTO sanitr_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","yuShmAn vadAmi yAvatkAlam IshvararAjatvasya saMsthApanaM na bhavati tAvad drAkShAphalarasaM na pAsyAmi| ");
INSERT INTO sanitr_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","tataH pUpaM gR^ihItvA IshvaraguNAn kIrttayitvA bha NktA tebhyo datvAvadat, yuShmadarthaM samarpitaM yanmama vapustadidaM, etat karmma mama smaraNArthaM kurudhvaM| ");
INSERT INTO sanitr_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","atha bhojanAnte tAdR^ishaM pAtraM gR^ihItvAvadat, yuShmatkR^ite pAtitaM yanmama raktaM tena nirNItanavaniyamarUpaM pAnapAtramidaM| ");
INSERT INTO sanitr_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","pashyata yo mAM parakareShu samarpayiShyati sa mayA saha bhojanAsana upavishati| ");
INSERT INTO sanitr_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","yathA nirUpitamAste tadanusAreNA manuShyapuुtrasya gati rbhaviShyati kintu yastaM parakareShu samarpayiShyati tasya santApo bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","tadA teShAM ko jana etat karmma kariShyati tat te parasparaM praShTumArebhire| ");
INSERT INTO sanitr_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","aparaM teShAM ko janaH shreShThatvena gaNayiShyate, atrArthe teShAM vivAdobhavat| ");
INSERT INTO sanitr_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","asmAt kAraNAt sovadat, anyadeshIyAnAM rAjAnaH prajAnAmupari prabhutvaM kurvvanti dAruNashAsanaM kR^itvApi te bhUpatitvena vikhyAtA bhavanti cha| ");
INSERT INTO sanitr_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","kintu yuShmAkaM tathA na bhaviShyati, yo yuShmAkaM shreShTho bhaviShyati sa kaniShThavad bhavatu, yashcha mukhyo bhaviShyati sa sevakavadbhavatu| ");
INSERT INTO sanitr_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","bhojanopaviShTaparichArakayoH kaH shreShThaH? yo bhojanAyopavishati sa kiM shreShTho na bhavati? kintu yuShmAkaM madhye.ahaM parichAraka_ivAsmi| ");
INSERT INTO sanitr_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","apara ncha yuyaM mama parIkShAkAle prathamamArabhya mayA saha sthitA ");
INSERT INTO sanitr_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","etatkAraNAt pitrA yathA madarthaM rAjyamekaM nirUpitaM tathAhamapi yuShmadarthaM rAjyaM nirUpayAmi| ");
INSERT INTO sanitr_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","tasmAn mama rAjye bhojanAsane cha bhojanapAne kariShyadhve siMhAsaneShUpavishya chesrAyelIyAnAM dvAdashavaMshAnAM vichAraM kariShyadhve| ");
INSERT INTO sanitr_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","aparaM prabhuruvAcha, he shimon pashya tita_unA dhAnyAnIva yuShmAn shaitAn chAlayitum aichChat, ");
INSERT INTO sanitr_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","kintu tava vishvAsasya lopo yathA na bhavati etat tvadarthaM prArthitaM mayA, tvanmanasi parivarttite cha bhrAtR^iNAM manAMsi sthirIkuru| ");
INSERT INTO sanitr_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","tadA sovadat, he prabhohaM tvayA sArddhaM kArAM mR^iti ncha yAtuM majjitosmi| ");
INSERT INTO sanitr_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","tataH sa uvAcha, he pitara tvAM vadAmi, adya kukkuTaravAt pUrvvaM tvaM matparichayaM vAratrayam apahvoShyase| ");
INSERT INTO sanitr_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","aparaM sa paprachCha, yadA mudrAsampuTaM khAdyapAtraM pAdukA ncha vinA yuShmAn prAhiNavaM tadA yuShmAkaM kasyApi nyUnatAsIt? te prochuH kasyApi na| ");
INSERT INTO sanitr_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","tadA sovadat kintvidAnIM mudrAsampuTaM khAdyapAtraM vA yasyAsti tena tadgrahItavyaM, yasya cha kR^ipANoे nAsti tena svavastraM vikrIya sa kretavyaH| ");
INSERT INTO sanitr_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","yato yuShmAnahaM vadAmi, aparAdhijanaiH sArddhaM gaNitaH sa bhaviShyati| idaM yachChAstrIyaM vachanaM likhitamasti tanmayi phaliShyati yato mama sambandhIyaM sarvvaM setsyati| ");
INSERT INTO sanitr_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","tadA te prochuH prabho pashya imau kR^ipANau| tataH sovadad etau yatheShTau| ");
INSERT INTO sanitr_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","atha sa tasmAdvahi rgatvA svAchArAnusAreNa jaitunanAmAdriM jagAma shiShyAshcha tatpashchAd yayuH| ");
INSERT INTO sanitr_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","tatropasthAya sa tAnuvAcha, yathA parIkShAyAM na patatha tadarthaM prArthayadhvaM| ");
INSERT INTO sanitr_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","pashchAt sa tasmAd ekasharakShepAd bahi rgatvA jAnunI pAtayitvA etat prArthayA nchakre, ");
INSERT INTO sanitr_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","he pita ryadi bhavAn sammanyate tarhi kaMsamenaM mamAntikAd dUraya kintu madichChAnurUpaM na tvadichChAnurUpaM bhavatu| ");
INSERT INTO sanitr_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","tadA tasmai shaktiM dAtuM svargIyadUto darshanaM dadau| ");
INSERT INTO sanitr_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","pashchAt sotyantaM yAtanayA vyAkulo bhUtvA punardR^iDhaM prArthayA nchakre, tasmAd bR^ihachChoNitabindava iva tasya svedabindavaH pR^ithivyAM patitumArebhire| ");
INSERT INTO sanitr_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","atha prArthanAta utthAya shiShyANAM samIpametya tAn manoduHkhino nidritAn dR^iShTvAvadat ");
INSERT INTO sanitr_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","kuto nidrAtha? parIkShAyAm apatanArthaM prarthayadhvaM| ");
INSERT INTO sanitr_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","etatkathAyAH kathanakAle dvAdashashiShyANAM madhye gaNito yihUdAnAmA janatAsahitasteShAm agre chalitvA yIshoshchumbanArthaM tadantikam Ayayau| ");
INSERT INTO sanitr_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","tadA yIshuruvAcha, he yihUdA kiM chumbanena manuShyaputraM parakareShu samarpayasi? ");
INSERT INTO sanitr_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","tadA yadyad ghaTiShyate tadanumAya sa NgibhiruktaM, he prabho vayaM ki kha Ngena ghAtayiShyAmaH? ");
INSERT INTO sanitr_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","tata ekaH karavAlenAhatya pradhAnayAjakasya dAsasya dakShiNaM karNaM chichCheda| ");
INSERT INTO sanitr_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","adhUnA nivarttasva ityuktvA yIshustasya shrutiM spR^iShTvA svasyaM chakAra| ");
INSERT INTO sanitr_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","pashchAd yIshuH samIpasthAn pradhAnayAjakAn mandirasya senApatIn prAchInAMshcha jagAda, yUyaM kR^ipANAn yaShTIMshcha gR^ihItvA mAM kiM choraM dharttumAyAtAH? ");
INSERT INTO sanitr_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","yadAhaM yuShmAbhiH saha pratidinaM mandire.atiShThaM tadA mAM dharttaM na pravR^ittAH, kintvidAnIM yuShmAkaM samayondhakArasya chAdhipatyamasti| ");
INSERT INTO sanitr_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","atha te taM dhR^itvA mahAyAjakasya niveshanaM ninyuH| tataH pitaro dUre dUre pashchAditvA ");
INSERT INTO sanitr_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","bR^ihatkoShThasya madhye yatrAgniM jvAlayitvA lokAH sametyopaviShTAstatra taiH sArddham upavivesha| ");
INSERT INTO sanitr_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","atha vahnisannidhau samupaveshakAle kAchiddAsI mano nivishya taM nirIkShyAvadat pumAnayaM tasya sa Nge.asthAt| ");
INSERT INTO sanitr_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","kintu sa tad apahnutyAvAdIt he nAri tamahaM na parichinomi| ");
INSERT INTO sanitr_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","kShaNAntare.anyajanastaM dR^iShTvAbravIt tvamapi teShAM nikarasyaikajanosi| pitaraH pratyuvAcha he nara nAhamasmi| ");
INSERT INTO sanitr_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","tataH sArddhadaNDadvayAt paraM punaranyo jano nishchitya babhAShe, eSha tasya sa NgIti satyaM yatoyaM gAlIlIyo lokaH| ");
INSERT INTO sanitr_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","tadA pitara uvAcha he nara tvaM yad vadami tadahaM boddhuM na shaknomi, iti vAkye kathitamAtre kukkuTo rurAva| ");
INSERT INTO sanitr_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","tadA prabhuNA vyAdhuTya pitare nirIkShite kR^ikavAkuravAt pUrvvaM mAM trirapahnoShyase iti pUrvvoktaM tasya vAkyaM pitaraH smR^itvA ");
INSERT INTO sanitr_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","bahirgatvA mahAkhedena chakranda| ");
INSERT INTO sanitr_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","tadA yai ryIshurdhR^itaste tamupahasya praharttumArebhire| ");
INSERT INTO sanitr_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","vastreNa tasya dR^ishau baddhvA kapole chapeTAghAtaM kR^itvA paprachChuH, kaste kapole chapeTAghAtaM kR^itavAna? gaNayitvA tad vada| ");
INSERT INTO sanitr_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","tadanyat tadviruddhaM bahunindAvAkyaM vaktumArebhire| ");
INSERT INTO sanitr_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","atha prabhAte sati lokaprA nchaH pradhAnayAjakA adhyApakAshcha sabhAM kR^itvA madhyesabhaM yIshumAnIya paprachChuH, tvam abhiShikatosi na vAsmAn vada| ");
INSERT INTO sanitr_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","sa pratyuvAcha, mayA tasminnukte.api yUyaM na vishvasiShyatha| ");
INSERT INTO sanitr_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","kasmiMshchidvAkye yuShmAn pR^iShTe.api mAM na taduttaraM vakShyatha na mAM tyakShyatha cha| ");
INSERT INTO sanitr_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","kintvitaH paraM manujasutaH sarvvashaktimata Ishvarasya dakShiNe pArshve samupavekShyati| ");
INSERT INTO sanitr_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","tataste paprachChuH, rtiha tvamIshvarasya putraH? sa kathayAmAsa, yUyaM yathArthaM vadatha sa evAhaM| ");
INSERT INTO sanitr_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","tadA te sarvve kathayAmAsuH, rtiha sAkShye.ansasmin asmAkaM kiM prayojanaM? asya svamukhAdeva sAkShyaM prAptam| ");
INSERT INTO sanitr_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","tataH sabhAsthAH sarvvalokA utthAya taM pIlAtasammukhaM nItvAprodya vaktumArebhire, ");
INSERT INTO sanitr_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","svamabhiShiktaM rAjAnaM vadantaM kaimararAjAya karadAnaM niShedhantaM rAjyaviparyyayaM kurttuM pravarttamAnam ena prAptA vayaM| ");
INSERT INTO sanitr_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","tadA pIlAtastaM pR^iShTavAn tvaM kiM yihUdIyAnAM rAjA? sa pratyuvAcha tvaM satyamuktavAn| ");
INSERT INTO sanitr_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","tadA pIlAtaH pradhAnayAjakAdilokAn jagAd, ahametasya kamapyaparAdhaM nAptavAn| ");
INSERT INTO sanitr_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","tataste punaH sAhamino bhUtvAvadan, eSha gAlIla etatsthAnaparyyante sarvvasmin yihUdAdeshe sarvvAllokAnupadishya kupravR^ittiM grAhItavAn| ");
INSERT INTO sanitr_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","tadA pIlAto gAlIlapradeshasya nAma shrutvA paprachCha, kimayaM gAlIlIyo lokaH? ");
INSERT INTO sanitr_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","tataH sa gAlIlpradeshIyaherodrAjasya tadA sthitestasya samIpe yIshuM preShayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","tadA herod yIshuM vilokya santutoSha, yataH sa tasya bahuvR^ittAntashravaNAt tasya ki ni्chadAshcharyyakarmma pashyati ityAshAM kR^itvA bahukAlamArabhya taM draShTuM prayAsaM kR^itavAn| ");
INSERT INTO sanitr_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","tasmAt taM bahukathAH paprachCha kintu sa tasya kasyApi vAkyasya pratyuttaraM novAcha| ");
INSERT INTO sanitr_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","atha pradhAnayAjakA adhyApakAshcha prottiShThantaH sAhasena tamapavadituM prArebhire| ");
INSERT INTO sanitr_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","herod tasya senAgaNashcha tamavaj nAya upahAsatvena rAjavastraM paridhApya punaH pIlAtaM prati taM prAhiNot| ");
INSERT INTO sanitr_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","pUrvvaM herodpIlAtayoH parasparaM vairabhAva AsIt kintu taddine dvayo rmelanaM jAtam| ");
INSERT INTO sanitr_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","pashchAt pIlAtaH pradhAnayAjakAn shAsakAn lokAMshcha yugapadAhUya babhAShe, ");
INSERT INTO sanitr_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","rAjyaviparyyayakArakoyam ityuktvA manuShyamenaM mama nikaTamAnaiShTa kintu pashyata yuShmAkaM samakSham asya vichAraM kR^itvApi proktApavAdAnurUpeNAsya kopyaparAdhaH sapramANo na jAtaH, ");
INSERT INTO sanitr_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","yUya ncha herodaH sannidhau preShitA mayA tatrAsya kopyaparAdhastenApi na prAptaH|pashyatAnena vadhaheेtukaM kimapi nAparAddhaM| ");
INSERT INTO sanitr_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","tasmAdenaM tADayitvA vihAsyAmi| ");
INSERT INTO sanitr_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","tatrotsave teShAmeko mochayitavyaH| ");
INSERT INTO sanitr_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","iti hetoste prochchairekadA prochuH, enaM dUrIkR^itya barabbAnAmAnaM mochaya| ");
INSERT INTO sanitr_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","sa barabbA nagara upaplavavadhAparAdhAbhyAM kArAyAM baddha AsIt| ");
INSERT INTO sanitr_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","kintu pIlAto yIshuM mochayituM vA nChan punastAnuvAcha| ");
INSERT INTO sanitr_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","tathApyenaM krushe vyadha krushe vyadheti vadantaste ruruvuH| ");
INSERT INTO sanitr_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","tataH sa tR^itIyavAraM jagAda kutaH? sa kiM karmma kR^itavAn? nAhamasya kamapi vadhAparAdhaM prAptaH kevalaM tADayitvAmuM tyajAmi| ");
INSERT INTO sanitr_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","tathApi te punarenaM krushe vyadha ityuktvA prochchairdR^iDhaM prArthayA nchakrire; ");
INSERT INTO sanitr_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","tataH pradhAnayAjakAdInAM kalarave prabale sati teShAM prArthanArUpaM karttuM pIlAta Adidesha| ");
INSERT INTO sanitr_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","rAjadrohavadhayoraparAdhena kArAsthaM yaM janaM te yayAchire taM mochayitvA yIshuM teShAmichChAyAM samArpayat| ");
INSERT INTO sanitr_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","atha te yIshuM gR^ihItvA yAnti, etarhi grAmAdAgataM shimonanAmAnaM kurINIyaM janaM dhR^itvA yIshoH pashchAnnetuM tasya skandhe krushamarpayAmAsuH| ");
INSERT INTO sanitr_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","tato loाkAraNyamadhye bahustriyo rudatyo vilapantyashcha yIshoH pashchAd yayuH| ");
INSERT INTO sanitr_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","kintu sa vyAghuTya tA uvAcha, he yirUshAlamo nAryyo yuyaM madarthaM na ruditvA svArthaM svApatyArtha ncha ruditi; ");
INSERT INTO sanitr_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","pashyata yaH kadApi garbhavatyo nAbhavan stanya ncha nApAyayan tAdR^ishI rvandhyA yadA dhanyA vakShyanti sa kAla AyAti| ");
INSERT INTO sanitr_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","tadA he shailA asmAkamupari patata, he upashailA asmAnAchChAdayata kathAmIdR^ishIM lokA vakShyanti| ");
INSERT INTO sanitr_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","yataH satejasi shAkhini chedetad ghaTate tarhi shuShkashAkhini kiM na ghaTiShyate? ");
INSERT INTO sanitr_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","tadA te hantuM dvAvaparAdhinau tena sArddhaM ninyuH| ");
INSERT INTO sanitr_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","aparaM shiraHkapAlanAmakasthAnaM prApya taM krushe vividhuH; taddvayoraparAdhinorekaM tasya dakShiNo tadanyaM vAme krushe vividhuH| ");
INSERT INTO sanitr_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","tadA yIshurakathayat, he pitaretAn kShamasva yata ete yat karmma kurvvanti tan na viduH; pashchAtte guTikApAtaM kR^itvA tasya vastrANi vibhajya jagR^ihuH| ");
INSERT INTO sanitr_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","tatra lokasaMghastiShThan dadarsha; te teShAM shAsakAshcha tamupahasya jagaduH, eSha itarAn rakShitavAn yadIshvareNAbhiruchito .abhiShiktastrAtA bhavati tarhi svamadhunA rakShatu| ");
INSERT INTO sanitr_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","tadanyaH senAgaNA etya tasmai amlarasaM datvA parihasya provAcha, ");
INSERT INTO sanitr_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","chettvaM yihUdIyAnAM rAjAsi tarhi svaM rakSha| ");
INSERT INTO sanitr_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","yihUdIyAnAM rAjeti vAkyaM yUnAnIyaromIyebrIyAkSharai rlikhitaM tachChirasa Urddhve.asthApyata| ");
INSERT INTO sanitr_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","tadobhayapArshvayo rviddhau yAvaparAdhinau tayorekastaM vinindya babhAShe, chettvam abhiShiktosi tarhi svamAvA ncha rakSha| ");
INSERT INTO sanitr_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","kintvanyastaM tarjayitvAvadat, IshvarAttava ki nchidapi bhayaM nAsti kiM? tvamapi samAnadaNDosi, ");
INSERT INTO sanitr_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","yogyapAtre AvAM svasvakarmmaNAM samuchitaphalaM prApnuvaH kintvanena kimapi nAparAddhaM| ");
INSERT INTO sanitr_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","atha sa yIshuM jagAda he prabhe bhavAn svarAjyapraveshakAle mAM smaratu| ");
INSERT INTO sanitr_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","tadA yIshuH kathitavAn tvAM yathArthaM vadAmi tvamadyaiva mayA sArddhaM paralokasya sukhasthAnaM prApsyasi| ");
INSERT INTO sanitr_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","apara ncha dvitIyayAmAt tR^itIyayAmaparyyantaM ravestejasontarhitatvAt sarvvadesho.andhakAreNAvR^ito ");
INSERT INTO sanitr_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","mandirasya yavanikA cha ChidyamAnA dvidhA babhUva| ");
INSERT INTO sanitr_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","tato yIshuruchchairuvAcha, he pita rmamAtmAnaM tava kare samarpaye, ityuktvA sa prANAn jahau| ");
INSERT INTO sanitr_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","tadaitA ghaTanA dR^iShTvA shatasenApatirIshvaraM dhanyamuktvA kathitavAn ayaM nitAntaM sAdhumanuShya AsIt| ");
INSERT INTO sanitr_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","atha yAvanto lokA draShTum AgatAste tA ghaTanA dR^iShTvA vakShaHsu karAghAtaM kR^itvA vyAchuTya gatAH| ");
INSERT INTO sanitr_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","yIsho rj nAtayo yA yA yoShitashcha gAlIlastena sArddhamAyAtAstA api dUre sthitvA tat sarvvaM dadR^ishuH| ");
INSERT INTO sanitr_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","tadA yihUdIyAnAM mantraNAM kriyA nchAsammanyamAna Ishvarasya rAjatvam apekShamANo ");
INSERT INTO sanitr_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","yihUdideshIyo .arimathIyanagarIyo yUShaphnAmA mantrI bhadro dhArmmikashcha pumAn ");
INSERT INTO sanitr_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","pIlAtAntikaM gatvA yIsho rdehaM yayAche| ");
INSERT INTO sanitr_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","pashchAd vapuravarohya vAsasA saMveShTya yatra kopi mAnuSho nAsthApyata tasmin shaile svAte shmashAne tadasthApayat| ");
INSERT INTO sanitr_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","taddinamAyojanIyaM dinaM vishrAmavArashcha samIpaH| ");
INSERT INTO sanitr_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","aparaM yIshunA sArddhaM gAlIla AgatA yoShitaH pashchAditvA shmashAne tatra yathA vapuH sthApitaM tachcha dR^iShTvA ");
INSERT INTO sanitr_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","vyAghuTya sugandhidravyatailAni kR^itvA vidhivad vishrAmavAre vishrAmaM chakruH| ");
INSERT INTO sanitr_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","atha saptAhaprathamadine.atipratyUShe tA yoShitaH sampAditaM sugandhidravyaM gR^ihItvA tadanyAbhiH kiyatIbhiH strIbhiH saha shmashAnaM yayuH| ");
INSERT INTO sanitr_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","kintu shmashAnadvArAt pAShANamapasAritaM dR^iShTvA ");
INSERT INTO sanitr_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","tAH pravishya prabho rdehamaprApya ");
INSERT INTO sanitr_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","vyAkulA bhavanti etarhi tejomayavastrAnvitau dvau puruShau tAsAM samIpe samupasthitau ");
INSERT INTO sanitr_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","tasmAttAH sha NkAyuktA bhUmAvadhomukhyasyasthuH| tadA tau tA Uchatu rmR^itAnAM madhye jIvantaM kuto mR^igayatha? ");
INSERT INTO sanitr_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","sotra nAsti sa udasthAt| ");
INSERT INTO sanitr_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","pApinAM kareShu samarpitena krushe hatena cha manuShyaputreNa tR^itIyadivase shmashAnAdutthAtavyam iti kathAM sa galIli tiShThan yuShmabhyaM kathitavAn tAM smarata| ");
INSERT INTO sanitr_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","tadA tasya sA kathA tAsAM manaHsu jAtA| ");
INSERT INTO sanitr_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","anantaraM shmashAnAd gatvA tA ekAdashashiShyAdibhyaH sarvvebhyastAM vArttAM kathayAmAsuH| ");
INSERT INTO sanitr_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","magdalInImariyam, yohanA, yAkUbo mAtA mariyam tadanyAH sa Nginyo yoShitashcha preritebhya etAH sarvvA vArttAH kathayAmAsuH ");
INSERT INTO sanitr_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","kintu tAsAM kathAm anarthakAkhyAnamAtraM buddhvA kopi na pratyait| ");
INSERT INTO sanitr_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","tadA pitara utthAya shmashAnAntikaM dadhAva, tatra cha prahvo bhUtvA pArshvaikasthApitaM kevalaM vastraM dadarsha; tasmAdAshcharyyaM manyamAno yadaghaTata tanmanasi vichArayan pratasthe| ");
INSERT INTO sanitr_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","tasminneva dine dvau shiyyau yirUshAlamashchatuShkroshAntaritam immAyugrAmaM gachChantau ");
INSERT INTO sanitr_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","tAsAM ghaTanAnAM kathAmakathayatAM ");
INSERT INTO sanitr_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","tayorAlApavichArayoH kAle yIshurAgatya tAbhyAM saha jagAma ");
INSERT INTO sanitr_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","kintu yathA tau taM na parichinutastadarthaM tayo rdR^iShTiH saMruddhA| ");
INSERT INTO sanitr_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","sa tau pR^iShTavAn yuvAM viShaNNau kiM vichArayantau gachChathaH? ");
INSERT INTO sanitr_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","tatastayoH kliyapAnAmA pratyuvAcha yirUshAlamapure.adhunA yAnyaghaTanta tvaM kevalavideshI kiM tadvR^ittAntaM na jAnAsi? ");
INSERT INTO sanitr_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","sa paprachCha kA ghaTanAH? tadA tau vaktumArebhAte yIshunAmA yo nAsaratIyo bhaviShyadvAdI Ishvarasya mAnuShANA ncha sAkShAt vAkye karmmaNi cha shaktimAnAsIt ");
INSERT INTO sanitr_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","tam asmAkaM pradhAnayAjakA vichArakAshcha kenApi prakAreNa krushe viddhvA tasya prANAnanAshayan tadIyA ghaTanAH; ");
INSERT INTO sanitr_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","kintu ya isrAyelIyalokAn uddhArayiShyati sa evAyam ityAshAsmAbhiH kR^itA|tadyathA tathAstu tasyA ghaTanAyA adya dinatrayaM gataM| ");
INSERT INTO sanitr_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","adhikantvasmAkaM sa NginInAM kiyatstrINAM mukhebhyo.asambhavavAkyamidaM shrutaM; ");
INSERT INTO sanitr_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","tAH pratyUShe shmashAnaM gatvA tatra tasya deham aprApya vyAghuTyetvA proktavatyaH svargIsadUtau dR^iShTAvasmAbhistau chAvAdiShTAM sa jIvitavAn| ");
INSERT INTO sanitr_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","tatosmAkaM kaishchit shmashAnamagamyata te.api strINAM vAkyAnurUpaM dR^iShTavantaH kintu taM nApashyan| ");
INSERT INTO sanitr_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","tadA sa tAvuvAcha, he abodhau he bhaviShyadvAdibhiruktavAkyaM pratyetuM vilambamAnau; ");
INSERT INTO sanitr_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","etatsarvvaduHkhaM bhuktvA svabhUtiprAptiH kiM khrIShTasya na nyAyyA? ");
INSERT INTO sanitr_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","tataH sa mUsAgranthamArabhya sarvvabhaviShyadvAdinAM sarvvashAstre svasmin likhitAkhyAnAbhiprAyaM bodhayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","atha gamyagrAmAbhyarNaM prApya tenAgre gamanalakShaNe darshite ");
INSERT INTO sanitr_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","tau sAdhayitvAvadatAM sahAvAbhyAM tiShTha dine gate sati rAtrirabhUt; tataH sa tAbhyAM sArddhaM sthAtuM gR^ihaM yayau| ");
INSERT INTO sanitr_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","pashchAdbhojanopaveshakAle sa pUpaM gR^ihItvA IshvaraguNAn jagAda ta ncha bhaMktvA tAbhyAM dadau| ");
INSERT INTO sanitr_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","tadA tayo rdR^iShTau prasannAyAM taM pratyabhij natuH kintu sa tayoH sAkShAdantardadhe| ");
INSERT INTO sanitr_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","tatastau mithobhidhAtum Arabdhavantau gamanakAle yadA kathAmakathayat shAstrArtha nchabodhayat tadAvayo rbuddhiH kiM na prAjvalat? ");
INSERT INTO sanitr_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","tau tatkShaNAdutthAya yirUshAlamapuraM pratyAyayatuH, tatsthAne shiShyANAm ekAdashAnAM sa NginA ncha darshanaM jAtaM| ");
INSERT INTO sanitr_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","te prochuH prabhurudatiShThad iti satyaM shimone darshanamadAchcha| ");
INSERT INTO sanitr_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","tataH pathaH sarvvaghaTanAyAH pUpabha njanena tatparichayasya cha sarvvavR^ittAntaM tau vaktumArebhAte| ");
INSERT INTO sanitr_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","itthaM te parasparaM vadanti tatkAle yIshuH svayaM teShAM madhya protthaya yuShmAkaM kalyANaM bhUyAd ityuvAcha, ");
INSERT INTO sanitr_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","kintu bhUtaM pashyAma ityanumAya te samudvivijire treShushcha| ");
INSERT INTO sanitr_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","sa uvAcha, kuto duHkhitA bhavatha? yuShmAkaM manaHsu sandeha udeti cha kutaH? ");
INSERT INTO sanitr_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","eShohaM, mama karau pashyata varaM spR^iShTvA pashyata, mama yAdR^ishAni pashyatha tAdR^ishAni bhUtasya mAMsAsthIni na santi| ");
INSERT INTO sanitr_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ityuktvA sa hastapAdAn darshayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","te.asambhavaM j nAtvA sAnandA na pratyayan| tataH sa tAn paprachCha, atra yuShmAkaM samIpe khAdyaM ki nchidasti? ");
INSERT INTO sanitr_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","tataste kiyaddagdhamatsyaM madhu cha daduH ");
INSERT INTO sanitr_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","sa tadAdAya teShAM sAkShAd bubhuje ");
INSERT INTO sanitr_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","kathayAmAsa cha mUsAvyavasthAyAM bhaviShyadvAdinAM grantheShu gItapustake cha mayi yAni sarvvANi vachanAni likhitAni tadanurUpANi ghaTiShyante yuShmAbhiH sArddhaM sthitvAhaM yadetadvAkyam avadaM tadidAnIM pratyakShamabhUt| ");
INSERT INTO sanitr_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","atha tebhyaH shAstrabodhAdhikAraM datvAvadat, ");
INSERT INTO sanitr_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","khrIShTenetthaM mR^itiyAtanA bhoktavyA tR^itIyadine cha shmashAnAdutthAtavya ncheti lipirasti; ");
INSERT INTO sanitr_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","tannAmnA yirUshAlamamArabhya sarvvadeshe manaHparAvarttanasya pApamochanasya cha susaMvAdaH prachArayitavyaH, ");
INSERT INTO sanitr_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","eShu sarvveShu yUyaM sAkShiNaH| ");
INSERT INTO sanitr_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","apara ncha pashyata pitrA yat pratij nAtaM tat preShayiShyAmi, ataeva yAvatkAlaM yUyaM svargIyAM shaktiM na prApsyatha tAvatkAlaM yirUshAlamnagare tiShThata| ");
INSERT INTO sanitr_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","atha sa tAn baithanIyAparyyantaM nItvA hastAvuttolya AshiSha vaktumArebhe ");
INSERT INTO sanitr_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","AshiShaM vadanneva cha tebhyaH pR^ithag bhUtvA svargAya nIto.abhavat| ");
INSERT INTO sanitr_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","tadA te taM bhajamAnA mahAnandena yirUshAlamaM pratyAjagmuH| ");
INSERT INTO sanitr_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","tato nirantaraM mandire tiShThanta Ishvarasya prashaMsAM dhanyavAda ncha karttam Arebhire| iti||");
INSERT INTO sanitr_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Adau vAda AsIt sa cha vAda IshvareNa sArdhamAsIt sa vAdaH svayamIshvara eva| ");
INSERT INTO sanitr_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","sa AdAvIshvareNa sahAsIt| ");
INSERT INTO sanitr_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","tena sarvvaM vastu sasR^ije sarvveShu sR^iShTavastuShu kimapi vastu tenAsR^iShTaM nAsti| ");
INSERT INTO sanitr_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","sa jIvanasyAkAraH, tachcha jIvanaM manuShyANAM jyotiH ");
INSERT INTO sanitr_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","tajjyotirandhakAre prachakAshe kintvandhakArastanna jagrAha| ");
INSERT INTO sanitr_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","yohan nAmaka eko manuja IshvareNa preShayA nchakre| ");
INSERT INTO sanitr_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","tadvArA yathA sarvve vishvasanti tadarthaM sa tajjyotiShi pramANaM dAtuM sAkShisvarUpo bhUtvAgamat, ");
INSERT INTO sanitr_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","sa svayaM tajjyoti rna kintu tajjyotiShi pramANaM dAtumAgamat| ");
INSERT INTO sanitr_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","jagatyAgatya yaH sarvvamanujebhyo dIptiM dadAti tadeva satyajyotiH| ");
INSERT INTO sanitr_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","sa yajjagadasR^ijat tanmadya eva sa AsIt kintu jagato lokAstaM nAjAnan| ");
INSERT INTO sanitr_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","nijAdhikAraM sa AgachChat kintu prajAstaM nAgR^ihlan| ");
INSERT INTO sanitr_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","tathApi ye ye tamagR^ihlan arthAt tasya nAmni vyashvasan tebhya Ishvarasya putrA bhavitum adhikAram adadAt| ");
INSERT INTO sanitr_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","teShAM janiH shoNitAnna shArIrikAbhilAShAnna mAnavAnAmichChAto na kintvIshvarAdabhavat| ");
INSERT INTO sanitr_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","sa vAdo manuShyarUpeNAvatIryya satyatAnugrahAbhyAM paripUrNaH san sArdham asmAbhi rnyavasat tataH pituradvitIyaputrasya yogyo yo mahimA taM mahimAnaM tasyApashyAma| ");
INSERT INTO sanitr_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","tato yohanapi prachAryya sAkShyamidaM dattavAn yo mama pashchAd AgamiShyati sa matto gurutaraH; yato matpUrvvaM sa vidyamAna AsIt; yadartham ahaM sAkShyamidam adAM sa eShaH| ");
INSERT INTO sanitr_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","apara ncha tasya pUrNatAyA vayaM sarvve kramashaH kramashonugrahaM prAptAH| ");
INSERT INTO sanitr_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","mUsAdvArA vyavasthA dattA kintvanugrahaH satyatva ncha yIshukhrIShTadvArA samupAtiShThatAM| ");
INSERT INTO sanitr_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","kopi manuja IshvaraM kadApi nApashyat kintu pituH kroDastho.advitIyaH putrastaM prakAshayat| ");
INSERT INTO sanitr_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","tvaM kaH? iti vAkyaM preShTuM yadA yihUdIyalokA yAjakAn levilokAMshcha yirUshAlamo yohanaH samIpe preShayAmAsuH, ");
INSERT INTO sanitr_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","tadA sa svIkR^itavAn nApahnUtavAn nAham abhiShikta itya NgIkR^itavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","tadA te.apR^ichChan tarhi ko bhavAn? kiM eliyaH? sovadat na; tataste.apR^ichChan tarhi bhavAn sa bhaviShyadvAdI? sovadat nAhaM saH| ");
INSERT INTO sanitr_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","tadA te.apR^ichChan tarhi bhavAn kaH? vayaM gatvA prerakAn tvayi kiM vakShyAmaH? svasmin kiM vadasi? ");
INSERT INTO sanitr_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","tadA sovadat| parameshasya panthAnaM pariShkuruta sarvvataH| itIdaM prAntare vAkyaM vadataH kasyachidravaH| kathAmimAM yasmin yishayiyo bhaviShyadvAdI likhitavAn soham| ");
INSERT INTO sanitr_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ye preShitAste phirUshilokAH| ");
INSERT INTO sanitr_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","tadA te.apR^ichChan yadi nAbhiShiktosi eliyosi na sa bhaviShyadvAdyapi nAsi cha, tarhi lokAn majjayasi kutaH? ");
INSERT INTO sanitr_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","tato yohan pratyavochat, toye.ahaM majjayAmIti satyaM kintu yaM yUyaM na jAnItha tAdR^isha eko jano yuShmAkaM madhya upatiShThati| ");
INSERT INTO sanitr_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","sa matpashchAd Agatopi matpUrvvaM varttamAna AsIt tasya pAdukAbandhanaM mochayitumapi nAhaM yogyosmi| ");
INSERT INTO sanitr_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","yarddananadyAH pArasthabaithabArAyAM yasminsthAne yohanamajjayat tasmina sthAne sarvvametad aghaTata| ");
INSERT INTO sanitr_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","pare.ahani yohan svanikaTamAgachChantaM yishuM vilokya prAvochat jagataH pApamochakam Ishvarasya meShashAvakaM pashyata| ");
INSERT INTO sanitr_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","yo mama pashchAdAgamiShyati sa matto gurutaraH, yato hetormatpUrvvaM so.avarttata yasminnahaM kathAmimAM kathitavAn sa evAyaM| ");
INSERT INTO sanitr_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","aparaM nAhamenaM pratyabhij nAtavAn kintu isrAyellokA enaM yathA parichinvanti tadabhiprAyeNAhaM jale majjayitumAgachCham| ");
INSERT INTO sanitr_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","punashcha yohanaparamekaM pramANaM datvA kathitavAn vihAyasaH kapotavad avatarantamAtmAnam asyoparyyavatiShThantaM cha dR^iShTavAnaham| ");
INSERT INTO sanitr_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","nAhamenaM pratyabhij nAtavAn iti satyaM kintu yo jale majjayituM mAM prairayat sa evemAM kathAmakathayat yasyoparyyAtmAnam avatarantam avatiShThanta ncha drakShayasi saeva pavitre Atmani majjayiShyati| ");
INSERT INTO sanitr_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","avastannirIkShyAyam Ishvarasya tanaya iti pramANaM dadAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","pare.ahani yohan dvAbhyAM shiShyAbhyAM sArddheM tiShThan ");
INSERT INTO sanitr_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","yishuM gachChantaM vilokya gaditavAn, Ishvarasya meShashAvakaM pashyataM| ");
INSERT INTO sanitr_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","imAM kathAM shrutvA dvau shiShyau yIshoH pashchAd IyatuH| ");
INSERT INTO sanitr_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","tato yIshuH parAvR^itya tau pashchAd AgachChantau dR^iShTvA pR^iShTavAn yuvAM kiM gaveshayathaH? tAvapR^ichChatAM he rabbi arthAt he guro bhavAn kutra tiShThati? ");
INSERT INTO sanitr_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","tataH sovAdit etya pashyataM| tato divasasya tR^itIyapraharasya gatatvAt tau taddinaM tasya sa Nge.asthAtAM| ");
INSERT INTO sanitr_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","yau dvau yohano vAkyaM shrutvA yishoH pashchAd AgamatAM tayoH shimonpitarasya bhrAtA AndriyaH ");
INSERT INTO sanitr_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","sa itvA prathamaM nijasodaraM shimonaM sAkShAtprApya kathitavAn vayaM khrIShTam arthAt abhiShiktapuruShaM sAkShAtkR^itavantaH| ");
INSERT INTO sanitr_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","pashchAt sa taM yishoH samIpam Anayat| tadA yIshustaM dR^iShTvAvadat tvaM yUnasaH putraH shimon kintu tvannAmadheyaM kaiphAH vA pitaraH arthAt prastaro bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","pare.ahani yIshau gAlIlaM gantuM nishchitachetasi sati philipanAmAnaM janaM sAkShAtprApyAvochat mama pashchAd AgachCha| ");
INSERT INTO sanitr_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","baitsaidAnAmni yasmin grAme pitarAndriyayorvAsa AsIt tasmin grAme tasya philipasya vasatirAsIt| ");
INSERT INTO sanitr_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","pashchAt philipo nithanelaM sAkShAtprApyAvadat mUsA vyavasthA granthe bhaviShyadvAdinAM grantheShu cha yasyAkhyAnaM likhitamAste taM yUShaphaH putraM nAsaratIyaM yIshuM sAkShAd akArShma vayaM| ");
INSERT INTO sanitr_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","tadA nithanel kathitavAn nAsarannagarAta kiM kashchiduttama utpantuM shaknoti? tataH philipo .avochat etya pashya| ");
INSERT INTO sanitr_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","apara ncha yIshuH svasya samIpaM tam AgachChantaM dR^iShTvA vyAhR^itavAn, pashyAyaM niShkapaTaH satya isrAyellokaH| ");
INSERT INTO sanitr_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","tataH sovadad, bhavAn mAM kathaM pratyabhijAnAti? yIshuravAdIt philipasya AhvAnAt pUrvvaM yadA tvamuDumbarasya tarormUle.asthAstadA tvAmadarsham| ");
INSERT INTO sanitr_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","nithanel achakathat, he guro bhavAn nitAntam Ishvarasya putrosi, bhavAn isrAyelvaMshasya rAjA| ");
INSERT INTO sanitr_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","tato yIshu rvyAharat, tvAmuDumbarasya pAdapasya mUle dR^iShTavAnAhaM mamaitasmAdvAkyAt kiM tvaM vyashvasIH? etasmAdapyAshcharyyANi kAryyANi drakShyasi| ");
INSERT INTO sanitr_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","anyachchAvAdId yuShmAnahaM yathArthaM vadAmi, itaH paraM mochite meghadvAre tasmAnmanujasUnunA Ishvarasya dUtagaNam avarohantamArohanta ncha drakShyatha| ");
INSERT INTO sanitr_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","anantaraM trutIyadivase gAlIl pradeshiye kAnnAnAmni nagare vivAha AsIt tatra cha yIshormAtA tiShThat| ");
INSERT INTO sanitr_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","tasmai vivAhAya yIshustasya shiShyAshcha nimantritA Asan| ");
INSERT INTO sanitr_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","tadanantaraM drAkShArasasya nyUnatvAd yIshormAtA tamavadat eteShAM drAkShAraso nAsti| ");
INSERT INTO sanitr_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","tadA sa tAmavochat he nAri mayA saha tava kiM kAryyaM? mama samaya idAnIM nopatiShThati| ");
INSERT INTO sanitr_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","tatastasya mAtA dAsAnavochad ayaM yad vadati tadeva kuruta| ");
INSERT INTO sanitr_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","tasmin sthAne yihUdIyAnAM shuchitvakaraNavyavahArAnusAreNADhakaikajaladharANi pAShANamayAni ShaDvR^ihatpAtrANiAsan| ");
INSERT INTO sanitr_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","tadA yIshustAn sarvvakalashAn jalaiH pUrayituM tAnAj nApayat, tataste sarvvAn kumbhAnAkarNaM jalaiH paryyapUrayan| ");
INSERT INTO sanitr_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","atha tebhyaH ki nchiduttAryya bhojyAdhipAteHsamIpaM netuM sa tAnAdishat, te tadanayan| ");
INSERT INTO sanitr_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","apara ncha tajjalaM kathaM drAkShAraso.abhavat tajjalavAhakAdAsA j nAtuM shaktAH kintu tadbhojyAdhipo j nAtuM nAshaknot tadavalihya varaM saMmbodyAvadata, ");
INSERT INTO sanitr_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","lokAH prathamaM uttamadrAkShArasaM dadati taShu yatheShTaM pitavatsu tasmA ki nchidanuttama ncha dadati kintu tvamidAnIM yAvat uttamadrAkShArasaM sthApayasi| ");
INSERT INTO sanitr_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","itthaM yIshurgAlIlapradeshe AshcharyyakArmma prArambha nijamahimAnaM prAkAshayat tataH shiShyAstasmin vyashvasan| ");
INSERT INTO sanitr_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","tataH param sa nijamAtrubhrAtrusshiShyaiH sArddhM kapharnAhUmam Agamat kintu tatra bahUdinAni AtiShThat| ");
INSERT INTO sanitr_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","tadanantaraM yihUdiyAnAM nistArotsave nikaTamAgate yIshu ryirUshAlam nagaram AgachChat| ");
INSERT INTO sanitr_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","tato mandirasya madhye gomeShapArAvatavikrayiNo vANijakShchopaviShTAn vilokya ");
INSERT INTO sanitr_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","rajjubhiH kashAM nirmmAya sarvvagomeShAdibhiH sArddhaM tAn mandirAd dUrIkR^itavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","vaNijAM mudrAdi vikIryya AsanAni nyUbjIkR^itya pArAvatavikrayibhyo.akathayad asmAt sthAnAt sarvANyetAni nayata, mama pitugR^ihaM vANijyagR^ihaM mA kArShTa| ");
INSERT INTO sanitr_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","tasmAt tanmandirArtha udyogo yastu sa grasatIva mAm| imAM shAstrIyalipiM shiShyAHsamasmaran| ");
INSERT INTO sanitr_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","tataH param yihUdIyalokA yIShimavadan tavamidR^ishakarmmakaraNAt kiM chihnamasmAn darshayasi? ");
INSERT INTO sanitr_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","tato yIshustAnavochad yuShmAbhire tasmin mandire nAshite dinatrayamadhye.ahaM tad utthApayiShyAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","tadA yihUdiyA vyAhArShuH, etasya mandirasa nirmmANena ShaTchatvAriMshad vatsarA gatAH, tvaM kiM dinatrayamadhye tad utthApayiShyasi? ");
INSERT INTO sanitr_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","kintu sa nijadeharUpamandire kathAmimAM kathitavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","sa yadetAdR^ishaM gaditavAn tachChiShyAH shmashAnAt tadIyotthAne sati smR^itvA dharmmagranthe yIshunoktakathAyAM cha vyashvasiShuH| ");
INSERT INTO sanitr_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","anantaraM nistArotsavasya bhojyasamaye yirUshAlam nagare tatkrutAshcharyyakarmmANi vilokya bahubhistasya nAmani vishvasitaM| ");
INSERT INTO sanitr_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","kintu sa teShAM kareShu svaM na samarpayat, yataH sa sarvvAnavait| ");
INSERT INTO sanitr_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","sa mAnaveShu kasyachit pramANaM nApekShata yato manujAnAM madhye yadyadasti tattat sojAnAt| ");
INSERT INTO sanitr_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","nikadimanAmA yihUdIyAnAm adhipatiH phirUshI kShaNadAyAM ");
INSERT INTO sanitr_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","yIshaurabhyarNam Avrajya vyAhArShIt, he guro bhavAn IshvarAd Agat eka upadeShTA, etad asmAbhirj nAyate; yato bhavatA yAnyAshcharyyakarmmANi kriyante parameshvarasya sAhAyyaM vinA kenApi tattatkarmmANi karttuM na shakyante| ");
INSERT INTO sanitr_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","tadA yIshuruttaraM dattavAn tavAhaM yathArthataraM vyAharAmi punarjanmani na sati kopi mAnava Ishvarasya rAjyaM draShTuM na shaknoti| ");
INSERT INTO sanitr_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","tato nikadImaH pratyavochat manujo vR^iddho bhUtvA kathaM janiShyate? sa kiM puna rmAtR^irjaTharaM pravishya janituM shaknoti? ");
INSERT INTO sanitr_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","yIshuravAdId yathArthataram ahaM kathayAmi manuje toyAtmabhyAM puna rna jAte sa Ishvarasya rAjyaM praveShTuM na shaknoti| ");
INSERT INTO sanitr_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","mAMsAd yat jAyate tan mAMsameva tathAtmano yo jAyate sa Atmaiva| ");
INSERT INTO sanitr_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","yuShmAbhiH puna rjanitavyaM mamaitasyAM kathAyAm AshcharyaM mA maMsthAH| ");
INSERT INTO sanitr_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","sadAgatiryAM dishamichChati tasyAmeva dishi vAti, tvaM tasya svanaM shuNoShi kintu sa kuta AyAti kutra yAti vA kimapi na jAnAsi tadvAd AtmanaH sakAshAt sarvveShAM manujAnAM janma bhavati| ");
INSERT INTO sanitr_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","tadA nikadImaH pR^iShTavAn etat kathaM bhavituM shaknoti? ");
INSERT INTO sanitr_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","yIshuH pratyaktavAn tvamisrAyelo gururbhUtvApi kimetAM kathAM na vetsi? ");
INSERT INTO sanitr_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","tubhyaM yathArthaM kathayAmi, vayaM yad vidmastad vachmaH yaMchcha pashyAmastasyaiva sAkShyaM dadmaH kintu yuShmAbhirasmAkaM sAkShitvaM na gR^ihyate| ");
INSERT INTO sanitr_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","etasya saMsArasya kathAyAM kathitAyAM yadi yUyaM na vishvasitha tarhi svargIyAyAM kathAyAM kathaM vishvasiShyatha? ");
INSERT INTO sanitr_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","yaH svarge.asti yaM cha svargAd avArohat taM mAnavatanayaM vinA kopi svargaM nArohat| ");
INSERT INTO sanitr_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","apara ncha mUsA yathA prAntare sarpaM protthApitavAn manuShyaputro.api tathaivotthApitavyaH; ");
INSERT INTO sanitr_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","tasmAd yaH kashchit tasmin vishvasiShyati so.avinAshyaH san anantAyuH prApsyati| ");
INSERT INTO sanitr_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ishvara itthaM jagadadayata yat svamadvitIyaM tanayaM prAdadAt tato yaH kashchit tasmin vishvasiShyati so.avinAshyaH san anantAyuH prApsyati| ");
INSERT INTO sanitr_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ishvaro jagato lokAn daNDayituM svaputraM na preShya tAn paritrAtuM preShitavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ataeva yaH kashchit tasmin vishvasiti sa daNDArho na bhavati kintu yaH kashchit tasmin na vishvasiti sa idAnImeva daNDArho bhavati,yataH sa IshvarasyAdvitIyaputrasya nAmani pratyayaM na karoti| ");
INSERT INTO sanitr_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","jagato madhye jyotiH prAkAshata kintu manuShyANAM karmmaNAM dR^iShTatvAt te jyotiShopi timire prIyante etadeva daNDasya kAraNAM bhavati| ");
INSERT INTO sanitr_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","yaH kukarmma karoti tasyAchArasya dR^iShTatvAt sa jyotirR^ItIyitvA tannikaTaM nAyAti; ");
INSERT INTO sanitr_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","kintu yaH satkarmma karoti tasya sarvvANi karmmANIshvareNa kR^itAnIti sathA prakAshate tadabhiprAyeNa sa jyotiShaH sannidhim AyAti| ");
INSERT INTO sanitr_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","tataH param yIshuH shiShyaiH sArddhaM yihUdIyadeshaM gatvA tatra sthitvA majjayitum Arabhata| ");
INSERT INTO sanitr_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","tadA shAlam nagarasya samIpasthAyini ainan grAme bahutaratoyasthitestatra yohan amajjayat tathA cha lokA Agatya tena majjitA abhavan| ");
INSERT INTO sanitr_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","tadA yohan kArAyAM na baddhaH| ");
INSERT INTO sanitr_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","apara ncha shAchakarmmaNi yohAnaH shiShyaiH saha yihUdIyalokAnAM vivAde jAte, te yohanaH saMnnidhiM gatvAkathayan, ");
INSERT INTO sanitr_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","he guro yarddananadyAH pAre bhavatA sArddhaM ya AsIt yasmiMshcha bhavAn sAkShyaM pradadAt pashyatu sopi majjayati sarvve tasya samIpaM yAnti cha| ");
INSERT INTO sanitr_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","tadA yohan pratyavochad IshvareNa na datte kopi manujaH kimapi prAptuM na shaknoti| ");
INSERT INTO sanitr_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","ahaM abhiShikto na bhavAmi kintu tadagre preShitosmi yAmimAM kathAM kathitavAnAhaM tatra yUyaM sarvve sAkShiNaH stha| ");
INSERT INTO sanitr_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","yo janaH kanyAM labhate sa eva varaH kintu varasya sannidhau daNDAyamAnaM tasya yanmitraM tena varasya shabde shrute.atIvAhlAdyate mamApi tadvad AnandasiddhirjAtA| ");
INSERT INTO sanitr_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","tena kramasho varddhitavyaM kintu mayA hsitavyaM| ");
INSERT INTO sanitr_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ya UrdhvAdAgachChat sa sarvveShAM mukhyo yashcha saMsArAd udapadyata sa sAMsArikaH saMsArIyAM kathA ncha kathayati yastu svargAdAgachChat sa sarvveShAM mukhyaH| ");
INSERT INTO sanitr_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","sa yadapashyadashR^iNochcha tasminneva sAkShyaM dadAti tathApi prAyashaH kashchit tasya sAkShyaM na gR^ihlAti; ");
INSERT INTO sanitr_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","kintu yo gR^ihlAti sa Ishvarasya satyavAditvaM mudrA NgitaM karoti| ");
INSERT INTO sanitr_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","IshvareNa yaH preritaH saeva IshvarIyakathAM kathayati yata Ishvara AtmAnaM tasmai aparimitam adadAt| ");
INSERT INTO sanitr_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","pitA putre snehaM kR^itvA tasya haste sarvvANi samarpitavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","yaH kashchit putre vishvasiti sa evAnantam paramAyuH prApnoti kintu yaH kashchit putre na vishvasiti sa paramAyuSho darshanaM na prApnoti kintvIshvarasya kopabhAjanaM bhUtvA tiShThati| ");
INSERT INTO sanitr_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","yIshuH svayaM nAmajjayat kevalaM tasya shiShyA amajjayat kintu yohano.adhikashiShyAn sa karoti majjayati cha, ");
INSERT INTO sanitr_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","phirUshina imAM vArttAmashR^iNvan iti prabhuravagatya ");
INSERT INTO sanitr_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","yihUdIyadeshaM vihAya puna rgAlIlam Agat| ");
INSERT INTO sanitr_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","tataH shomiroNapradeshasya madyena tena gantavye sati ");
INSERT INTO sanitr_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","yAkUb nijaputrAya yUShaphe yAM bhUmim adadAt tatsamIpasthAyi shomiroNapradeshasya sukhAr nAmnA vikhyAtasya nagarasya sannidhAvupAsthAt| ");
INSERT INTO sanitr_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","tatra yAkUbaH prahirAsIt; tadA dvitIyayAmavelAyAM jAtAyAM sa mArge shramApannastasya praheH pArshve upAvishat| ");
INSERT INTO sanitr_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","etarhi kAchit shomiroNIyA yoShit toyottolanArtham tatrAgamat ");
INSERT INTO sanitr_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","tadA shiShyAH khAdyadravyANi kretuM nagaram agachChan| ");
INSERT INTO sanitr_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","yIshuH shomiroNIyAM tAM yoShitam vyAhArShIt mahyaM ki nchit pAnIyaM pAtuM dehi| kintu shomiroNIyaiH sAkaM yihUdIyalokA na vyavAharan tasmAddhetoH sAkathayat shomiroNIyA yoShitadahaM tvaM yihUdIyosi kathaM mattaH pAnIyaM pAtum ichChasi? ");
INSERT INTO sanitr_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","tato yIshuravadad Ishvarasya yaddAnaM tatkIdR^ik pAnIyaM pAtuM mahyaM dehi ya itthaM tvAM yAchate sa vA ka iti chedaj nAsyathAstarhi tamayAchiShyathAH sa cha tubhyamamR^itaM toyamadAsyat| ");
INSERT INTO sanitr_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","tadA sA sImantinI bhAShitavati, he mahechCha prahirgambhIro bhavato nIrottolanapAtraM nAstI cha tasmAt tadamR^itaM kIlAlaM kutaH prApsyasi? ");
INSERT INTO sanitr_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","yosmabhyam imamandhUM dadau, yasya cha parijanA gomeShAdayashcha sarvve.asya praheH pAnIyaM papuretAdR^isho yosmAkaM pUrvvapuruSho yAkUb tasmAdapi bhavAn mahAn kiM? ");
INSERT INTO sanitr_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","tato yIshurakathayad idaM pAnIyaM saH pivati sa punastR^iShArtto bhaviShyati, ");
INSERT INTO sanitr_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","kintu mayA dattaM pAnIyaM yaH pivati sa punaH kadApi tR^iShArtto na bhaviShyati| mayA dattam idaM toyaM tasyAntaH prasravaNarUpaM bhUtvA anantAyuryAvat sroShyati| ");
INSERT INTO sanitr_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","tadA sA vanitAkathayat he mahechCha tarhi mama punaH pIpAsA yathA na jAyate toyottolanAya yathAtrAgamanaM na bhavati cha tadarthaM mahyaM tattoyaM dehI| ");
INSERT INTO sanitr_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","tato yIshUravadadyAhi tava patimAhUya sthAne.atrAgachCha| ");
INSERT INTO sanitr_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","sA vAmAvadat mama patirnAsti| yIshuravadat mama patirnAstIti vAkyaM bhadramavochaH| ");
INSERT INTO sanitr_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","yatastava pa ncha patayobhavan adhunA tu tvayA sArddhaM yastiShThati sa tava bharttA na vAkyamidaM satyamavAdiH| ");
INSERT INTO sanitr_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","tadA sA mahilA gaditavati he mahechCha bhavAn eko bhaviShyadvAdIti buddhaM mayA| ");
INSERT INTO sanitr_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","asmAkaM pitR^ilokA etasmin shilochchaye.abhajanta, kintu bhavadbhiruchyate yirUshAlam nagare bhajanayogyaM sthAnamAste| ");
INSERT INTO sanitr_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","yIshuravochat he yoShit mama vAkye vishvasihi yadA yUyaM kevalashaile.asmin vA yirUshAlam nagare piturbhajanaM na kariShyadhve kAla etAdR^isha AyAti| ");
INSERT INTO sanitr_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","yUyaM yaM bhajadhve taM na jAnItha, kintu vayaM yaM bhajAmahe taM jAnImahe, yato yihUdIyalokAnAM madhyAt paritrANaM jAyate| ");
INSERT INTO sanitr_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","kintu yadA satyabhaktA AtmanA satyarUpeNa cha piturbhajanaM kariShyante samaya etAdR^isha AyAti, varam idAnImapi vidyate ; yata etAdR^isho bhatkAn pitA cheShTate| ");
INSERT INTO sanitr_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ishvara AtmA; tatastasya ye bhaktAstaiH sa AtmanA satyarUpeNa cha bhajanIyaH| ");
INSERT INTO sanitr_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","tadA sA mahilAvAdIt khrIShTanAmnA vikhyAto.abhiShiktaH puruSha AgamiShyatIti jAnAmi sa cha sarvvAH kathA asmAn j nApayiShyati| ");
INSERT INTO sanitr_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","tato yIshuravadat tvayA sArddhaM kathanaM karomi yo.aham ahameva sa puruShaH| ");
INSERT INTO sanitr_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","etasmin samaye shiShyA Agatya tathA striyA sArddhaM tasya kathopakathane mahAshcharyyam amanyanta tathApi bhavAn kimichChati? yadvA kimartham etayA sArddhaM kathAM kathayati? iti kopi nApR^ichChat| ");
INSERT INTO sanitr_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","tataH paraM sA nArI kalashaM sthApayitvA nagaramadhyaM gatvA lokebhyokathAyad ");
INSERT INTO sanitr_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","ahaM yadyat karmmAkaravaM tatsarvvaM mahyamakathayad etAdR^ishaM mAnavamekam Agatya pashyata ru kim abhiShikto na bhavati ? ");
INSERT INTO sanitr_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","tataste nagarAd bahirAgatya tAtasya samIpam Ayan| ");
INSERT INTO sanitr_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","etarhi shiShyAH sAdhayitvA taM vyAhArShuH he guro bhavAn ki nchid bhUktAM| ");
INSERT INTO sanitr_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","tataH sovadad yuShmAbhiryanna j nAyate tAdR^ishaM bhakShyaM mamAste| ");
INSERT INTO sanitr_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","tadA shiShyAH parasparaM praShTum Arambhanta, kimasmai kopi kimapi bhakShyamAnIya dattavAn? ");
INSERT INTO sanitr_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","yIshuravochat matprerakasyAbhimatAnurUpakaraNaM tasyaiva karmmasiddhikAraNa ncha mama bhakShyaM| ");
INSERT INTO sanitr_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","mAsachatuShTaye jAte shasyakarttanasamayo bhaviShyatIti vAkyaM yuShmAbhiH kiM nodyate? kintvahaM vadAmi, shira uttolya kShetrANi prati nirIkShya pashyata, idAnIM karttanayogyAni shuklavarNAnyabhavan| ");
INSERT INTO sanitr_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","yashChinatti sa vetanaM labhate anantAyuHsvarUpaM shasyaM sa gR^ihlAti cha, tenaiva vaptA ChettA cha yugapad AnandataH| ");
INSERT INTO sanitr_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","itthaM sati vapatyekashChinatyanya iti vachanaM siddhyati| ");
INSERT INTO sanitr_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","yatra yUyaM na paryyashrAmyata tAdR^ishaM shasyaM ChettuM yuShmAn prairayam anye janAHparyyashrAmyan yUyaM teShAM shragasya phalam alabhadhvam| ");
INSERT INTO sanitr_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","yasmin kAle yadyat karmmAkArShaM tatsarvvaM sa mahyam akathayat tasyA vanitAyA idaM sAkShyavAkyaM shrutvA tannagaranivAsino bahavaH shomiroNIyalokA vyashvasan| ");
INSERT INTO sanitr_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","tathA cha tasyAntike samupasthAya sveShAM sannidhau katichid dinAni sthAtuM tasmin vinayam akurvvAna tasmAt sa dinadvayaM tatsthAne nyavaShTat ");
INSERT INTO sanitr_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","tatastasyopadeshena bahavo.apare vishvasya ");
INSERT INTO sanitr_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","tAM yoShAmavadan kevalaM tava vAkyena pratIma iti na, kintu sa jagato.abhiShiktastrAteti tasya kathAM shrutvA vayaM svayamevAj nAsamahi| ");
INSERT INTO sanitr_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","svadeshe bhaviShyadvaktuH satkAro nAstIti yadyapi yIshuH pramANaM datvAkathayat ");
INSERT INTO sanitr_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","tathApi divasadvayAt paraM sa tasmAt sthAnAd gAlIlaM gatavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","anantaraM ye gAlIlI liyalokA utsave gatA utsavasamaye yirUshalam nagare tasya sarvvAH kriyA apashyan te gAlIlam AgataM tam AgR^ihlan| ");
INSERT INTO sanitr_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","tataH param yIshu ryasmin kAnnAnagare jalaM drAkShArasam Akarot tat sthAnaM punaragAt| tasminneva samaye kasyachid rAjasabhAstArasya putraH kapharnAhUmapurI rogagrasta AsIt| ");
INSERT INTO sanitr_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","sa yehUdIyadeshAd yIsho rgAlIlAgamanavArttAM nishamya tasya samIpaM gatvA prArthya vyAhR^itavAn mama putrasya prAyeNa kAla AsannaH bhavAn Agatya taM svasthaM karotu| ");
INSERT INTO sanitr_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","tadA yIshurakathayad AshcharyyaM karmma chitraM chihnaM cha na dR^iShTA yUyaM na pratyeShyatha| ");
INSERT INTO sanitr_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","tataH sa sabhAsadavadat he mahechCha mama putre na mR^ite bhavAnAgachChatu| ");
INSERT INTO sanitr_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","yIshustamavadad gachCha tava putro.ajIvIt tadA yIshunoktavAkye sa vishvasya gatavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","gamanakAle mArgamadhye dAsAstaM sAkShAtprApyAvadan bhavataH putro.ajIvIt| ");
INSERT INTO sanitr_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","tataH kaM kAlamArabhya rogapratIkArArambho jAtA iti pR^iShTe tairuktaM hyaH sArddhadaNDadvayAdhikadvitIyayAme tasya jvaratyAgo.abhavat| ");
INSERT INTO sanitr_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","tadA yIshustasmin kShaNe proktavAn tava putro.ajIvIt pitA tadbuddhvA saparivAro vyashvasIt| ");
INSERT INTO sanitr_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","yihUdIyadeshAd Agatya gAlIli yIshuretad dvitIyam AshcharyyakarmmAkarot| ");
INSERT INTO sanitr_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","tataH paraM yihUdIyAnAm utsava upasthite yIshu ryirUshAlamaM gatavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","tasminnagare meShanAmno dvArasya samIpe ibrIyabhAShayA baithesdA nAmnA piShkariNI pa nchaghaTTayuktAsIt| ");
INSERT INTO sanitr_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","tasyAsteShu ghaTTeShu kilAlakampanam apekShya andhakha nchashuShkA NgAdayo bahavo rogiNaH patantastiShThanti sma| ");
INSERT INTO sanitr_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","yato visheShakAle tasya saraso vAri svargIyadUta etyAkampayat tatkIlAlakampanAt paraM yaH kashchid rogI prathamaM pAnIyamavArohat sa eva tatkShaNAd rogamukto.abhavat| ");
INSERT INTO sanitr_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","tadAShTAtriMshadvarShANi yAvad rogagrasta ekajanastasmin sthAne sthitavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","yIshustaM shayitaM dR^iShTvA bahukAlikarogIti j nAtvA vyAhR^itavAn tvaM kiM svastho bubhUShasi? ");
INSERT INTO sanitr_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","tato rogI kathitavAn he mahechCha yadA kIlAlaM kampate tadA mAM puShkariNIm avarohayituM mama kopi nAsti, tasmAn mama gamanakAle kashchidanyo.agro gatvA avarohati| ");
INSERT INTO sanitr_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","tadA yIshurakathayad uttiShTha, tava shayyAmuttolya gR^ihItvA yAhi| ");
INSERT INTO sanitr_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","sa tatkShaNAt svastho bhUtvA shayyAmuttolyAdAya gatavAn kintu taddinaM vishrAmavAraH| ");
INSERT INTO sanitr_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","tasmAd yihUdIyAH svasthaM naraM vyAharan adya vishrAmavAre shayanIyamAdAya na yAtavyam| ");
INSERT INTO sanitr_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","tataH sa pratyavochad yo mAM svastham akArShIt shayanIyam uttolyAdAya yAtuM mAM sa evAdishat| ");
INSERT INTO sanitr_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","tadA te.apR^ichChan shayanIyam uttolyAdAya yAtuM ya Aj nApayat sa kaH? ");
INSERT INTO sanitr_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","kintu sa ka iti svasthIbhUto nAjAnAd yatastasmin sthAne janatAsattvAd yIshuH sthAnAntaram Agamat| ");
INSERT INTO sanitr_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","tataH paraM yeshu rmandire taM naraM sAkShAtprApyAkathayat pashyedAnIm anAmayo jAtosi yathAdhikA durdashA na ghaTate taddhetoH pApaM karmma punarmAkArShIH| ");
INSERT INTO sanitr_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","tataH sa gatvA yihUdIyAn avadad yIshu rmAm arogiNam akArShIt| ");
INSERT INTO sanitr_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","tato yIshu rvishrAmavAre karmmedR^ishaM kR^itavAn iti heto ryihUdIyAstaM tADayitvA hantum acheShTanta| ");
INSERT INTO sanitr_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","yIshustAnAkhyat mama pitA yat kAryyaM karoti tadanurUpam ahamapi karoti| ");
INSERT INTO sanitr_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","tato yihUdIyAstaM hantuM punarayatanta yato vishrAmavAraM nAmanyata tadeva kevalaM na adhikantu IshvaraM svapitaraM prochya svamapIshvaratulyaM kR^itavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","pashchAd yIshuravadad yuShmAnahaM yathArthataraM vadAmi putraH pitaraM yadyat karmma kurvvantaM pashyati tadatiriktaM svechChAtaH kimapi karmma karttuM na shaknoti| pitA yat karoti putropi tadeva karoti| ");
INSERT INTO sanitr_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","pitA putre snehaM karoti tasmAt svayaM yadyat karmma karoti tatsarvvaM putraM darshayati ; yathA cha yuShmAkaM Ashcharyyaj nAnaM janiShyate tadartham itopi mahAkarmma taM darshayiShyati| ");
INSERT INTO sanitr_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","vastutastu pitA yathA pramitAn utthApya sajivAn karoti tadvat putropi yaM yaM ichChati taM taM sajIvaM karoti| ");
INSERT INTO sanitr_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","sarvve pitaraM yathA satkurvvanti tathA putramapi satkArayituM pitA svayaM kasyApi vichAramakR^itvA sarvvavichArANAM bhAraM putre samarpitavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","yaH putraM sat karoti sa tasya prerakamapi sat karoti| ");
INSERT INTO sanitr_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","yuShmAnAhaM yathArthataraM vadAmi yo jano mama vAkyaM shrutvA matprerake vishvasiti sonantAyuH prApnoti kadApi daNDabAjanaM na bhavati nidhanAdutthAya paramAyuH prApnoti| ");
INSERT INTO sanitr_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","ahaM yuShmAnatiyathArthaM vadAmi yadA mR^itA Ishvaraputrasya ninAdaM shroShyanti ye cha shroShyanti te sajIvA bhaviShyanti samaya etAdR^isha AyAti varam idAnImapyupatiShThati| ");
INSERT INTO sanitr_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","pitA yathA svaya njIvI tathA putrAya svaya njIvitvAdhikAraM dattavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","sa manuShyaputraH etasmAt kAraNAt pitA daNDakaraNAdhikAramapi tasmin samarpitavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","etadarthe yUyam AshcharyyaM na manyadhvaM yato yasmin samaye tasya ninAdaM shrutvA shmashAnasthAH sarvve bahirAgamiShyanti samaya etAdR^isha upasthAsyati| ");
INSERT INTO sanitr_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","tasmAd ye satkarmmANi kR^itavantasta utthAya AyuH prApsyanti ye cha kukarmANi kR^itavantasta utthAya daNDaM prApsyanti| ");
INSERT INTO sanitr_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","ahaM svayaM kimapi karttuM na shaknomi yathA shuNomi tathA vichArayAmi mama vichAra ncha nyAyyaH yatohaM svIyAbhIShTaM nehitvA matprerayituH pituriShTam Ihe| ");
INSERT INTO sanitr_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","yadi svasmin svayaM sAkShyaM dadAmi tarhi tatsAkShyam AgrAhyaM bhavati ; ");
INSERT INTO sanitr_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","kintu madarthe.aparo janaH sAkShyaM dadAti madarthe tasya yat sAkShyaM tat satyam etadapyahaM jAnAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","yuShmAbhi ryohanaM prati lokeShu preriteShu sa satyakathAyAM sAkShyamadadAt| ");
INSERT INTO sanitr_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","mAnuShAdahaM sAkShyaM nopekShe tathApi yUyaM yathA paritrayadhve tadartham idaM vAkyaM vadAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","yohan dedIpyamAno dIpa iva tejasvI sthitavAn yUyam alpakAlaM tasya dIptyAnandituM samamanyadhvaM| ");
INSERT INTO sanitr_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","kintu tatpramANAdapi mama gurutaraM pramANaM vidyate pitA mAM preShya yadyat karmma samApayituM shakttimadadAt mayA kR^itaM tattat karmma madarthe pramANaM dadAti| ");
INSERT INTO sanitr_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","yaH pitA mAM preritavAn mopi madarthe pramANaM dadAti| tasya vAkyaM yuShmAbhiH kadApi na shrutaM tasya rUpa ncha na dR^iShTaM ");
INSERT INTO sanitr_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","tasya vAkya ncha yuShmAkam antaH kadApi sthAnaM nApnoti yataH sa yaM preShitavAn yUyaM tasmin na vishvasitha| ");
INSERT INTO sanitr_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","dharmmapustakAni yUyam AlochayadhvaM tai rvAkyairanantAyuH prApsyAma iti yUyaM budhyadhve taddharmmapustakAni madarthe pramANaM dadati| ");
INSERT INTO sanitr_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","tathApi yUyaM paramAyuHprAptaye mama saMnidhim na jigamiShatha| ");
INSERT INTO sanitr_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","ahaM mAnuShebhyaH satkAraM na gR^ihlAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ahaM yuShmAn jAnAmi; yuShmAkamantara Ishvaraprema nAsti| ");
INSERT INTO sanitr_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ahaM nijapitu rnAmnAgatosmi tathApi mAM na gR^ihlItha kintu kashchid yadi svanAmnA samAgamiShyati tarhi taM grahIShyatha| ");
INSERT INTO sanitr_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","yUyam IshvarAt satkAraM na chiShTatvA kevalaM parasparaM satkAram ched Adadhvve tarhi kathaM vishvasituM shaknutha? ");
INSERT INTO sanitr_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","putuH samIpe.ahaM yuShmAn apavadiShyAmIti mA chintayata yasmin , yasmin yuShmAkaM vishvasaH saeva mUsA yuShmAn apavadati| ");
INSERT INTO sanitr_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","yadi yUyaM tasmin vyashvasiShyata tarhi mayyapi vyashvasiShyata, yat sa mayi likhitavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","tato yadi tena likhitavAni na pratitha tarhi mama vAkyAni kathaM pratyeShyatha? ");
INSERT INTO sanitr_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","tataH paraM yIshu rgAlIl pradeshIyasya tiviriyAnAmnaH sindhoH pAraM gatavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","tato vyAdhimallokasvAsthyakaraNarUpANi tasyAshcharyyANi karmmANi dR^iShTvA bahavo janAstatpashchAd agachChan| ");
INSERT INTO sanitr_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","tato yIshuH parvvatamAruhya tatra shiShyaiH sAkam| ");
INSERT INTO sanitr_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","tasmin samaya nistArotsavanAmni yihUdIyAnAma utsava upasthite ");
INSERT INTO sanitr_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","yIshu rnetre uttolya bahulokAn svasamIpAgatAn vilokya philipaM pR^iShTavAn eteShAM bhojanAya bhojadravyANi vayaM kutra kretuM shakrumaH? ");
INSERT INTO sanitr_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","vAkyamidaM tasya parIkShArtham avAdIt kintu yat kariShyati tat svayam ajAnAt| ");
INSERT INTO sanitr_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","philipaH pratyavochat eteShAm ekaiko yadyalpam alpaM prApnoti tarhi mudrApAdadvishatena krItapUpA api nyUnA bhaviShyanti| ");
INSERT INTO sanitr_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","shimon pitarasya bhrAtA AndriyAkhyaH shiShyANAmeko vyAhR^itavAn ");
INSERT INTO sanitr_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","atra kasyachid bAlakasya samIpe pa ncha yAvapUpAH kShudramatsyadvaya ncha santi kintu lokAnAM etAvAtAM madhye taiH kiM bhaviShyati? ");
INSERT INTO sanitr_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","pashchAd yIshuravadat lokAnupaveshayata tatra bahuyavasasattvAt pa nchasahastrebhyo nyUnA adhikA vA puruShA bhUmyAm upAvishan| ");
INSERT INTO sanitr_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","tato yIshustAn pUpAnAdAya Ishvarasya guNAn kIrttayitvA shiShyeShu samArpayat tataste tebhya upaviShTalokebhyaH pUpAn yatheShTamatsya ncha prAduH| ");
INSERT INTO sanitr_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","teShu tR^ipteShu sa tAnavochad eteShAM ki nchidapi yathA nApachIyate tathA sarvvANyavashiShTAni saMgR^ihlIta| ");
INSERT INTO sanitr_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","tataH sarvveShAM bhojanAt paraM te teShAM pa nchAnAM yAvapUpAnAM avashiShTAnyakhilAni saMgR^ihya dvAdashaDallakAn apUrayan| ");
INSERT INTO sanitr_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","aparaM yIshoretAdR^ishIm AshcharyyakriyAM dR^iShTvA lokA mitho vaktumArebhire jagati yasyAgamanaM bhaviShyati sa evAyam avashyaM bhaviShyadvakttA| ");
INSERT INTO sanitr_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ataeva lokA Agatya tamAkramya rAjAnaM kariShyanti yIshusteShAm IdR^ishaM mAnasaM vij nAya punashcha parvvatam ekAkI gatavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","sAyaMkAla upasthite shiShyA jaladhitaTaM vrajitvA nAvamAruhya nagaradishi sindhau vAhayitvAgaman| ");
INSERT INTO sanitr_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","tasmin samaye timira upAtiShThat kintu yIShusteShAM samIpaM nAgachChat| ");
INSERT INTO sanitr_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","tadA prabalapavanavahanAt sAgare mahAtara Ngo bhavitum Arebhe| ");
INSERT INTO sanitr_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","tataste vAhayitvA dvitrAn kroshAn gatAH pashchAd yIshuM jaladherupari padbhyAM vrajantaM naukAntikam AgachChantaM vilokya trAsayuktA abhavan ");
INSERT INTO sanitr_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","kintu sa tAnukttavAn ayamahaM mA bhaiShTa| ");
INSERT INTO sanitr_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","tadA te taM svairaM nAvi gR^ihItavantaH tadA tatkShaNAd uddiShTasthAne naurupAsthAt| ");
INSERT INTO sanitr_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","yayA nAvA shiShyA agachChan tadanyA kApi naukA tasmin sthAne nAsIt tato yIshuH shiShyaiH sAkaM nAgamat kevalAH shiShyA agaman etat pArasthA lokA j nAtavantaH| ");
INSERT INTO sanitr_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","kintu tataH paraM prabhu ryatra Ishvarasya guNAn anukIrttya lokAn pUpAn abhojayat tatsthAnasya samIpasthativiriyAyA aparAstaraNaya Agaman| ");
INSERT INTO sanitr_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","yIshustatra nAsti shiShyA api tatra nA santi lokA iti vij nAya yIshuM gaveShayituM taraNibhiH kapharnAhUm puraM gatAH| ");
INSERT INTO sanitr_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","tataste saritpateH pAre taM sAkShAt prApya prAvochan he guro bhavAn atra sthAne kadAgamat? ");
INSERT INTO sanitr_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","tadA yIshustAn pratyavAdId yuShmAnahaM yathArthataraM vadAmi AshcharyyakarmmadarshanAddheto rna kintu pUpabhojanAt tena tR^iptatvA ncha mAM gaveShayatha| ");
INSERT INTO sanitr_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","kShayaNIyabhakShyArthaM mA shrAmiShTa kintvantAyurbhakShyArthaM shrAmyata, tasmAt tAdR^ishaM bhakShyaM manujaputro yuShmAbhyaM dAsyati; tasmin tAta IshvaraH pramANaM prAdAt| ");
INSERT INTO sanitr_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","tadA te.apR^ichChan IshvarAbhimataM karmma karttum asmAbhiH kiM karttavyaM? ");
INSERT INTO sanitr_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","tato yIshuravadad Ishvaro yaM prairayat tasmin vishvasanam IshvarAbhimataM karmma| ");
INSERT INTO sanitr_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","tadA te vyAharan bhavatA kiM lakShaNaM darshitaM yaddR^iShTvA bhavati vishvasiShyAmaH? tvayA kiM karmma kR^itaM? ");
INSERT INTO sanitr_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","asmAkaM pUrvvapuruShA mahAprAntare mAnnAM bhokttuM prApuH yathA lipirAste| svargIyANi tu bhakShyANi pradadau parameshvaraH| ");
INSERT INTO sanitr_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","tadA yIshuravadad ahaM yuShmAnatiyathArthaM vadAmi mUsA yuShmAbhyaM svargIyaM bhakShyaM nAdAt kintu mama pitA yuShmAbhyaM svargIyaM paramaM bhakShyaM dadAti| ");
INSERT INTO sanitr_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","yaH svargAdavaruhya jagate jIvanaM dadAti sa IshvaradattabhakShyarUpaH| ");
INSERT INTO sanitr_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","tadA te prAvochan he prabho bhakShyamidaM nityamasmabhyaM dadAtu| ");
INSERT INTO sanitr_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","yIshuravadad ahameva jIvanarUpaM bhakShyaM yo jano mama sannidhim AgachChati sa jAtu kShudhArtto na bhaviShyati, tathA yo jano mAM pratyeti sa jAtu tR^iShArtto na bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","mAM dR^iShTvApi yUyaM na vishvasitha yuShmAnaham ityavochaM| ");
INSERT INTO sanitr_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","pitA mahyaM yAvato lokAnadadAt te sarvva eva mamAntikam AgamiShyanti yaH kashchichcha mama sannidhim AyAsyati taM kenApi prakAreNa na dUrIkariShyAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","nijAbhimataM sAdhayituM na hi kintu prerayiturabhimataM sAdhayituM svargAd Agatosmi| ");
INSERT INTO sanitr_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","sa yAn yAn lokAn mahyamadadAt teShAmekamapi na hArayitvA sheShadine sarvvAnaham utthApayAmi idaM matprerayituH piturabhimataM| ");
INSERT INTO sanitr_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","yaH kashchin mAnavasutaM vilokya vishvasiti sa sheShadine mayotthApitaH san anantAyuH prApsyati iti matprerakasyAbhimataM| ");
INSERT INTO sanitr_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","tadA svargAd yad bhakShyam avArohat tad bhakShyam ahameva yihUdIyalokAstasyaitad vAkye vivadamAnA vakttumArebhire ");
INSERT INTO sanitr_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","yUShaphaH putro yIshu ryasya mAtApitarau vayaM jAnIma eSha kiM saeva na? tarhi svargAd avAroham iti vAkyaM kathaM vaktti? ");
INSERT INTO sanitr_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","tadA yIshustAn pratyavadat parasparaM mA vivadadhvaM ");
INSERT INTO sanitr_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","matprerakeNa pitrA nAkR^iShTaH kopi jano mamAntikam AyAtuM na shaknoti kintvAgataM janaM charame.ahni protthApayiShyAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","te sarvva IshvareNa shikShitA bhaviShyanti bhaviShyadvAdinAM grantheShu lipiritthamAste ato yaH kashchit pituH sakAshAt shrutvA shikShate sa eva mama samIpam AgamiShyati| ");
INSERT INTO sanitr_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ya IshvarAd ajAyata taM vinA kopi manuShyo janakaM nAdarshat kevalaH saeva tAtam adrAkShIt| ");
INSERT INTO sanitr_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","ahaM yuShmAn yathArthataraM vadAmi yo jano mayi vishvAsaM karoti sonantAyuH prApnoti| ");
INSERT INTO sanitr_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ahameva tajjIvanabhakShyaM| ");
INSERT INTO sanitr_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","yuShmAkaM pUrvvapuruShA mahAprAntare mannAbhakShyaM bhUkttApi mR^itAH ");
INSERT INTO sanitr_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","kintu yadbhakShyaM svargAdAgachChat tad yadi kashchid bhu Nktte tarhi sa na mriyate| ");
INSERT INTO sanitr_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","yajjIvanabhakShyaM svargAdAgachChat sohameva idaM bhakShyaM yo jano bhu Nktte sa nityajIvI bhaviShyati| punashcha jagato jIvanArthamahaM yat svakIyapishitaM dAsyAmi tadeva mayA vitaritaM bhakShyam| ");
INSERT INTO sanitr_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","tasmAd yihUdIyAH parasparaM vivadamAnA vakttumArebhire eSha bhojanArthaM svIyaM palalaM katham asmabhyaM dAsyati? ");
INSERT INTO sanitr_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","tadA yIshustAn Avochad yuShmAnahaM yathArthataraM vadAmi manuShyaputrasyAmiShe yuShmAbhi rna bhuktte tasya rudhire cha na pIte jIvanena sArddhaM yuShmAkaM sambandho nAsti| ");
INSERT INTO sanitr_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","yo mamAmiShaM svAdati mama sudhira ncha pivati sonantAyuH prApnoti tataH sheShe.ahni tamaham utthApayiShyAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","yato madIyamAmiShaM paramaM bhakShyaM tathA madIyaM shoNitaM paramaM peyaM| ");
INSERT INTO sanitr_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","yo jano madIyaM palalaM svAdati madIyaM rudhira ncha pivati sa mayi vasati tasminnaha ncha vasAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","matprerayitrA jIvatA tAtena yathAhaM jIvAmi tadvad yaH kashchin mAmatti sopi mayA jIviShyati| ");
INSERT INTO sanitr_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","yadbhakShyaM svargAdAgachChat tadidaM yanmAnnAM svAditvA yuShmAkaM pitaro.amriyanta tAdR^isham idaM bhakShyaM na bhavati idaM bhakShyaM yo bhakShati sa nityaM jIviShyati| ");
INSERT INTO sanitr_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","yadA kapharnAhUm puryyAM bhajanagehe upAdishat tadA kathA etA akathayat| ");
INSERT INTO sanitr_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","tadetthaM shrutvA tasya shiShyANAm aneke parasparam akathayan idaM gADhaM vAkyaM vAkyamIdR^ishaM kaH shrotuM shakruyAt? ");
INSERT INTO sanitr_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","kintu yIshuH shiShyANAm itthaM vivAdaM svachitte vij nAya kathitavAn idaM vAkyaM kiM yuShmAkaM vighnaM janayati? ");
INSERT INTO sanitr_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","yadi manujasutaM pUrvvavAsasthAnam UrdvvaM gachChantaM pashyatha tarhi kiM bhaviShyati? ");
INSERT INTO sanitr_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Atmaiva jIvanadAyakaH vapu rniShphalaM yuShmabhyamahaM yAni vachAMsi kathayAmi tAnyAtmA jIvana ncha| ");
INSERT INTO sanitr_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","kintu yuShmAkaM madhye kechana avishvAsinaH santi ke ke na vishvasanti ko vA taM parakareShu samarpayiShyati tAn yIshurAprathamAd vetti| ");
INSERT INTO sanitr_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","aparamapi kathitavAn asmAt kAraNAd akathayaM pituH sakAshAt shakttimaprApya kopi mamAntikam AgantuM na shaknoti| ");
INSERT INTO sanitr_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","tatkAle.aneke shiShyA vyAghuTya tena sArddhaM puna rnAgachChan| ");
INSERT INTO sanitr_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","tadA yIshu rdvAdashashiShyAn ukttavAn yUyamapi kiM yAsyatha? ");
INSERT INTO sanitr_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","tataH shimon pitaraH pratyavochat he prabho kasyAbhyarNaM gamiShyAmaH? ");
INSERT INTO sanitr_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","anantajIvanadAyinyo yAH kathAstAstavaiva| bhavAn amareshvarasyAbhiShikttaputra iti vishvasya nishchitaM jAnImaH| ");
INSERT INTO sanitr_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","tadA yIshuravadat kimahaM yuShmAkaM dvAdashajanAn manonItAn na kR^itavAn? kintu yuShmAkaM madhyepi kashchideko vighnakArI vidyate| ");
INSERT INTO sanitr_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","imAM kathaM sa shimonaH putram IShkarIyotIyaM yihUdAm uddishya kathitavAn yato dvAdashAnAM madhye gaNitaH sa taM parakareShu samarpayiShyati| ");
INSERT INTO sanitr_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","tataH paraM yihUdIyalokAstaM hantuM samaihanta tasmAd yIshu ryihUdApradeshe paryyaTituM nechChan gAlIl pradeshe paryyaTituM prArabhata| ");
INSERT INTO sanitr_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","kintu tasmin samaye yihUdIyAnAM dUShyavAsanAmotsava upasthite ");
INSERT INTO sanitr_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","tasya bhrAtarastam avadan yAni karmmANi tvayA kriyante tAni yathA tava shiShyAH pashyanti tadarthaM tvamitaH sthAnAd yihUdIyadeshaM vraja| ");
INSERT INTO sanitr_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","yaH kashchit svayaM prachikAshiShati sa kadApi guptaM karmma na karoti yadIdR^ishaM karmma karoShi tarhi jagati nijaM parichAyaya| ");
INSERT INTO sanitr_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","yatastasya bhrAtaropi taM na vishvasanti| ");
INSERT INTO sanitr_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","tadA yIshustAn avochat mama samaya idAnIM nopatiShThati kintu yuShmAkaM samayaH satatam upatiShThati| ");
INSERT INTO sanitr_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","jagato lokA yuShmAn R^itIyituM na shakruvanti kintu mAmeva R^itIyante yatasteShAM karmANi duShTAni tatra sAkShyamidam ahaM dadAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","ataeva yUyam utsave.asmin yAta nAham idAnIm asminnutsave yAmi yato mama samaya idAnIM na sampUrNaH| ");
INSERT INTO sanitr_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","iti vAkyam ukttvA sa gAlIli sthitavAn ");
INSERT INTO sanitr_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","kintu tasya bhrAtR^iShu tatra prasthiteShu satsu so.aprakaTa utsavam agachChat| ");
INSERT INTO sanitr_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","anantaram utsavam upasthitA yihUdIyAstaM mR^igayitvApR^ichChan sa kutra? ");
INSERT INTO sanitr_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","tato lokAnAM madhye tasmin nAnAvidhA vivAdA bhavitum ArabdhavantaH| kechid avochan sa uttamaH puruShaH kechid avochan na tathA varaM lokAnAM bhramaM janayati| ");
INSERT INTO sanitr_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","kintu yihUdIyAnAM bhayAt kopi tasya pakShe spaShTaM nAkathayat| ");
INSERT INTO sanitr_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","tataH param utsavasya madhyasamaye yIshu rmandiraM gatvA samupadishati sma| ");
INSERT INTO sanitr_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","tato yihUdIyA lokA AshcharyyaM j nAtvAkathayan eShA mAnuSho nAdhItyA katham etAdR^isho vidvAnabhUt? ");
INSERT INTO sanitr_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","tadA yIshuH pratyavochad upadeshoyaM na mama kintu yo mAM preShitavAn tasya| ");
INSERT INTO sanitr_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","yo jano nideshaM tasya grahIShyati mamopadesho matto bhavati kim IshvarAd bhavati sa ganastajj nAtuM shakShyati| ");
INSERT INTO sanitr_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","yo janaH svataH kathayati sa svIyaM gauravam Ihate kintu yaH prerayitu rgauravam Ihate sa satyavAdI tasmin kopyadharmmo nAsti| ");
INSERT INTO sanitr_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","mUsA yuShmabhyaM vyavasthAgranthaM kiM nAdadAt? kintu yuShmAkaM kopi tAM vyavasthAM na samAcharati| mAM hantuM kuto yatadhve? ");
INSERT INTO sanitr_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","tadA lokA avadan tvaM bhUtagrastastvAM hantuM ko yatate? ");
INSERT INTO sanitr_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","tato yIshuravochad ekaM karmma mayAkAri tasmAd yUyaM sarvva mahAshcharyyaM manyadhve| ");
INSERT INTO sanitr_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","mUsA yuShmabhyaM tvakChedavidhiM pradadau sa mUsAto na jAtaH kintu pitR^ipuruShebhyo jAtaH tena vishrAmavAre.api mAnuShANAM tvakChedaM kurutha| ");
INSERT INTO sanitr_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ataeva vishrAmavAre manuShyANAM tvakChede kR^ite yadi mUsAvyavasthAma NganaM na bhavati tarhi mayA vishrAmavAre mAnuShaH sampUrNarUpeNa svastho.akAri tatkAraNAd yUyaM kiM mahyaM kupyatha? ");
INSERT INTO sanitr_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","sapakShapAtaM vichAramakR^itvA nyAyyaM vichAraM kuruta| ");
INSERT INTO sanitr_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","tadA yirUshAlam nivAsinaH katipayajanA akathayan ime yaM hantuM cheShTante sa evAyaM kiM na? ");
INSERT INTO sanitr_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","kintu pashyata nirbhayaH san kathAM kathayati tathApi kimapi a vadantyete ayamevAbhiShiktto bhavatIti nishchitaM kimadhipatayo jAnanti? ");
INSERT INTO sanitr_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","manujoyaM kasmAdAgamad iti vayaM jAnomaH kintvabhiShiktta Agate sa kasmAdAgatavAn iti kopi j nAtuM na shakShyati| ");
INSERT INTO sanitr_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","tadA yIshu rmadhyemandiram upadishan uchchaiHkAram ukttavAn yUyaM kiM mAM jAnItha? kasmAchchAgatosmi tadapi kiM jAnItha? nAhaM svata Agatosmi kintu yaH satyavAdI saeva mAM preShitavAn yUyaM taM na jAnItha| ");
INSERT INTO sanitr_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","tamahaM jAne tenAhaM prerita agatosmi| ");
INSERT INTO sanitr_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","tasmAd yihUdIyAstaM dharttum udyatAstathApi kopi tasya gAtre hastaM nArpayad yato hetostadA tasya samayo nopatiShThati| ");
INSERT INTO sanitr_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","kintu bahavo lokAstasmin vishvasya kathitavAnto.abhiShikttapuruSha Agatya mAnuShasyAsya kriyAbhyaH kim adhikA AshcharyyAH kriyAH kariShyati? ");
INSERT INTO sanitr_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","tataH paraM lokAstasmin itthaM vivadante phirUshinaH pradhAnayAjakA ncheti shrutavantastaM dhR^itvA netuM padAtigaNaM preShayAmAsuH| ");
INSERT INTO sanitr_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","tato yIshuravadad aham alpadinAni yuShmAbhiH sArddhaM sthitvA matprerayituH samIpaM yAsyAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","mAM mR^igayiShyadhve kintUddeshaM na lapsyadhve ratra sthAsyAmi tatra yUyaM gantuM na shakShyatha| ");
INSERT INTO sanitr_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","tadA yihUdIyAH parasparaM vakttumArebhire asyoddeshaM na prApsyAma etAdR^ishaM kiM sthAnaM yAsyati? bhinnadeshe vikIrNAnAM yihUdIyAnAM sannidhim eSha gatvA tAn upadekShyati kiM? ");
INSERT INTO sanitr_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","no chet mAM gaveShayiShyatha kintUddeshaM na prApsyatha eSha kodR^ishaM vAkyamidaM vadati? ");
INSERT INTO sanitr_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","anantaram utsavasya charame.ahani arthAt pradhAnadine yIshuruttiShThan uchchaiHkAram Ahvayan uditavAn yadi kashchit tR^iShArtto bhavati tarhi mamAntikam Agatya pivatu| ");
INSERT INTO sanitr_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","yaH kashchinmayi vishvasiti dharmmagranthasya vachanAnusAreNa tasyAbhyantarato.amR^itatoyasya srotAMsi nirgamiShyanti| ");
INSERT INTO sanitr_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ye tasmin vishvasanti ta AtmAnaM prApsyantItyarthe sa idaM vAkyaM vyAhR^itavAn etatkAlaM yAvad yIshu rvibhavaM na prAptastasmAt pavitra AtmA nAdIyata| ");
INSERT INTO sanitr_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","etAM vANIM shrutvA bahavo lokA avadan ayameva nishchitaM sa bhaviShyadvAdI| ");
INSERT INTO sanitr_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","kechid akathayan eShaeva sobhiShikttaH kintu kechid avadan sobhiShikttaH kiM gAlIl pradeshe janiShyate? ");
INSERT INTO sanitr_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","sobhiShiktto dAyUdo vaMshe dAyUdo janmasthAne baitlehami pattane janiShyate dharmmagranthe kimitthaM likhitaM nAsti? ");
INSERT INTO sanitr_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","itthaM tasmin lokAnAM bhinnavAkyatA jAtA| ");
INSERT INTO sanitr_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","katipayalokAstaM dharttum aichChan tathApi tadvapuShi kopi hastaM nArpayat| ");
INSERT INTO sanitr_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","anantaraM pAdAtigaNe pradhAnayAjakAnAM phirUshinA ncha samIpamAgatavati te tAn apR^ichChan kuto hetostaM nAnayata? ");
INSERT INTO sanitr_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","tadA padAtayaH pratyavadan sa mAnava iva kopi kadApi nopAdishat| ");
INSERT INTO sanitr_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","tataH phirUshinaH prAvochan yUyamapi kimabhrAmiShTa? ");
INSERT INTO sanitr_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","adhipatInAM phirUshinA ncha kopi kiM tasmin vyashvasIt? ");
INSERT INTO sanitr_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ye shAstraM na jAnanti ta ime.adhamalokAeva shApagrastAH| ");
INSERT INTO sanitr_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","tadA nikadImanAmA teShAmeko yaH kShaNadAyAM yIshoH sannidhim agAt sa ukttavAn ");
INSERT INTO sanitr_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","tasya vAkye na shrute karmmaNi cha na vidite .asmAkaM vyavasthA kiM ka nchana manujaM doShIkaroti? ");
INSERT INTO sanitr_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","tataste vyAharan tvamapi kiM gAlIlIyalokaH? vivichya pashya galIli kopi bhaviShyadvAdI notpadyate| ");
INSERT INTO sanitr_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","tataH paraM sarvve svaM svaM gR^ihaM gatAH kintu yIshu rjaitunanAmAnaM shilochchayaM gatavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","pratyUShe yIshuH panarmandiram AgachChat ");
INSERT INTO sanitr_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","tataH sarvveShu lokeShu tasya samIpa AgateShu sa upavishya tAn upadeShTum Arabhata| ");
INSERT INTO sanitr_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","tadA adhyApakAH phirUshina ncha vyabhichArakarmmaNi dhR^itaM striyamekAm Aniya sarvveShAM madhye sthApayitvA vyAharan ");
INSERT INTO sanitr_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","he guro yoShitam imAM vyabhichArakarmma kurvvANAM lokA dhR^itavantaH| ");
INSERT INTO sanitr_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","etAdR^ishalokAH pAShANAghAtena hantavyA iti vidhirmUsAvyavasthAgranthe likhitosti kintu bhavAn kimAdishati? ");
INSERT INTO sanitr_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","te tamapavadituM parIkShAbhiprAyeNa vAkyamidam apR^ichChan kintu sa prahvIbhUya bhUmAva NgalyA lekhitum Arabhata| ");
INSERT INTO sanitr_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","tatastaiH punaH punaH pR^iShTa utthAya kathitavAn yuShmAkaM madhye yo jano niraparAdhI saeva prathamam enAM pAShANenAhantu| ");
INSERT INTO sanitr_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","pashchAt sa punashcha prahvIbhUya bhUmau lekhitum Arabhata| ");
INSERT INTO sanitr_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","tAM kathaM shrutvA te svasvamanasi prabodhaM prApya jyeShThAnukramaM ekaikashaH sarvve bahiragachChan tato yIshurekAkI tayakttobhavat madhyasthAne daNDAyamAnA sA yoShA cha sthitA| ");
INSERT INTO sanitr_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","tatpashchAd yIshurutthAya tAM vanitAM vinA kamapyaparaM na vilokya pR^iShTavAn he vAme tavApavAdakAH kutra? kopi tvAM kiM na daNDayati? ");
INSERT INTO sanitr_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","sAvadat he mahechCha kopi na tadA yIshuravochat nAhamapi daNDayAmi yAhi punaH pApaM mAkArShIH| ");
INSERT INTO sanitr_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","tato yIshuH punarapi lokebhya itthaM kathayitum Arabhata jagatohaM jyotiHsvarUpo yaH kashchin matpashchAda gachChati sa timire na bhramitvA jIvanarUpAM dIptiM prApsyati| ");
INSERT INTO sanitr_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","tataH phirUshino.avAdiShustvaM svArthe svayaM sAkShyaM dadAsi tasmAt tava sAkShyaM grAhyaM na bhavati| ");
INSERT INTO sanitr_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","tadA yIshuH pratyuditavAn yadyapi svArthe.ahaM svayaM sAkShyaM dadAmi tathApi mat sAkShyaM grAhyaM yasmAd ahaM kuta Agatosmi kva yAmi cha tadahaM jAnAmi kintu kuta Agatosmi kutra gachChAmi cha tad yUyaM na jAnItha| ");
INSERT INTO sanitr_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","yUyaM laukikaM vichArayatha nAhaM kimapi vichArayAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","kintu yadi vichArayAmi tarhi mama vichAro grahItavyo yatoham ekAkI nAsmi prerayitA pitA mayA saha vidyate| ");
INSERT INTO sanitr_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","dvayo rjanayoH sAkShyaM grahaNIyaM bhavatIti yuShmAkaM vyavasthAgranthe likhitamasti| ");
INSERT INTO sanitr_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ahaM svArthe svayaM sAkShitvaM dadAmi yashcha mama tAto mAM preritavAn sopi madarthe sAkShyaM dadAti| ");
INSERT INTO sanitr_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","tadA te.apR^ichChan tava tAtaH kutra? tato yIshuH pratyavAdId yUyaM mAM na jAnItha matpitara ncha na jAnItha yadi mAm akShAsyata tarhi mama tAtamapyakShAsyata| ");
INSERT INTO sanitr_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","yIshu rmandira upadishya bhaNDAgAre kathA etA akathayat tathApi taM prati kopi karaM nodatolayat| ");
INSERT INTO sanitr_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","tataH paraM yIshuH punaruditavAn adhunAhaM gachChAmi yUyaM mAM gaveShayiShyatha kintu nijaiH pApai rmariShyatha yat sthAnam ahaM yAsyAmi tat sthAnam yUyaM yAtuM na shakShyatha| ");
INSERT INTO sanitr_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","tadA yihUdIyAH prAvochan kimayam AtmaghAtaM kariShyati? yato yat sthAnam ahaM yAsyAmi tat sthAnam yUyaM yAtuM na shakShyatha iti vAkyaM bravIti| ");
INSERT INTO sanitr_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","tato yIshustebhyaH kathitavAn yUyam adhaHsthAnIyA lokA aham UrdvvasthAnIyaH yUyam etajjagatsambandhIyA aham etajjagatsambandhIyo na| ");
INSERT INTO sanitr_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","tasmAt kathitavAn yUyaM nijaiH pApai rmariShyatha yatohaM sa pumAn iti yadi na vishvasitha tarhi nijaiH pApai rmariShyatha| ");
INSERT INTO sanitr_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","tadA te .apR^ichChan kastvaM? tato yIshuH kathitavAn yuShmAkaM sannidhau yasya prastAvam A prathamAt karomi saeva puruShohaM| ");
INSERT INTO sanitr_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","yuShmAsu mayA bahuvAkyaM vakttavyaM vichArayitavya ncha kintu matprerayitA satyavAdI tasya samIpe yadahaM shrutavAn tadeva jagate kathayAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","kintu sa janake vAkyamidaM prokttavAn iti te nAbudhyanta| ");
INSERT INTO sanitr_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","tato yIshurakathayad yadA manuShyaputram Urdvva utthApayiShyatha tadAhaM sa pumAn kevalaH svayaM kimapi karmma na karomi kintu tAto yathA shikShayati tadanusAreNa vAkyamidaM vadAmIti cha yUyaM j nAtuM shakShyatha| ");
INSERT INTO sanitr_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","matprerayitA pitA mAm ekAkinaM na tyajati sa mayA sArddhaM tiShThati yatohaM tadabhimataM karmma sadA karomi| ");
INSERT INTO sanitr_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","tadA tasyaitAni vAkyAni shrutvA bahuvastAsmin vyashvasan| ");
INSERT INTO sanitr_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","ye yihUdIyA vyashvasan yIshustebhyo.akathayat ");
INSERT INTO sanitr_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","mama vAkye yadi yUyam AsthAM kurutha tarhi mama shiShyA bhUtvA satyatvaM j nAsyatha tataH satyatayA yuShmAkaM mokSho bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","tadA te pratyavAdiShuH vayam ibrAhImo vaMshaH kadApi kasyApi dAsA na jAtAstarhi yuShmAkaM muktti rbhaviShyatIti vAkyaM kathaM bravIShi? ");
INSERT INTO sanitr_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","tadA yIshuH pratyavadad yuShmAnahaM yathArthataraM vadAmi yaH pApaM karoti sa pApasya dAsaH| ");
INSERT INTO sanitr_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","dAsashcha nirantaraM niveshane na tiShThati kintu putro nirantaraM tiShThati| ");
INSERT INTO sanitr_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","ataH putro yadi yuShmAn mochayati tarhi nitAntameva mukttA bhaviShyatha| ");
INSERT INTO sanitr_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","yuyam ibrAhImo vaMsha ityahaM jAnAmi kintu mama kathA yuShmAkam antaHkaraNeShu sthAnaM na prApnuvanti tasmAddheto rmAM hantum Ihadhve| ");
INSERT INTO sanitr_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ahaM svapituH samIpe yadapashyaM tadeva kathayAmi tathA yUyamapi svapituH samIpe yadapashyata tadeva kurudhve| ");
INSERT INTO sanitr_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","tadA te pratyavochan ibrAhIm asmAkaM pitA tato yIshurakathayad yadi yUyam ibrAhImaH santAnA abhaviShyata tarhi ibrAhIma AchAraNavad AchariShyata| ");
INSERT INTO sanitr_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ishvarasya mukhAt satyaM vAkyaM shrutvA yuShmAn j nApayAmi yohaM taM mAM hantuM cheShTadhve ibrAhIm etAdR^ishaM karmma na chakAra| ");
INSERT INTO sanitr_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","yUyaM svasvapituH karmmANi kurutha tadA tairukttaM na vayaM jArajAtA asmAkam ekaeva pitAsti sa eveshvaraH ");
INSERT INTO sanitr_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","tato yIshunA kathitam Ishvaro yadi yuShmAkaM tAtobhaviShyat tarhi yUyaM mayi premAkariShyata yatoham IshvarAnnirgatyAgatosmi svato nAgatohaM sa mAM prAhiNot| ");
INSERT INTO sanitr_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","yUyaM mama vAkyamidaM na budhyadhve kutaH? yato yUyaM mamopadeshaM soDhuM na shaknutha| ");
INSERT INTO sanitr_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","yUyaM shaitAn pituH santAnA etasmAd yuShmAkaM piturabhilAShaM pUrayatha sa A prathamAt naraghAtI tadantaH satyatvasya leshopi nAsti kAraNAdataH sa satyatAyAM nAtiShThat sa yadA mR^iShA kathayati tadA nijasvabhAvAnusAreNaiva kathayati yato sa mR^iShAbhAShI mR^iShotpAdakashcha| ");
INSERT INTO sanitr_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","ahaM tathyavAkyaM vadAmi kAraNAdasmAd yUyaM mAM na pratItha| ");
INSERT INTO sanitr_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","mayi pApamastIti pramANaM yuShmAkaM ko dAtuM shaknoti? yadyahaM tathyavAkyaM vadAmi tarhi kuto mAM na pratitha? ");
INSERT INTO sanitr_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","yaH kashchana IshvarIyo lokaH sa IshvarIyakathAyAM mano nidhatte yUyam IshvarIyalokA na bhavatha tannidAnAt tatra na manAMsi nidhadve| ");
INSERT INTO sanitr_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","tadA yihUdIyAH pratyavAdiShuH tvamekaH shomiroNIyo bhUtagrastashcha vayaM kimidaM bhadraM nAvAdiShma? ");
INSERT INTO sanitr_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","tato yIshuH pratyavAdIt nAhaM bhUtagrastaH kintu nijatAtaM sammanye tasmAd yUyaM mAm apamanyadhve| ");
INSERT INTO sanitr_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","ahaM svasukhyAtiM na cheShTe kintu cheShTitA vichArayitA chApara eka Aste| ");
INSERT INTO sanitr_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ahaM yuShmabhyam atIva yathArthaM kathayAmi yo naro madIyaM vAchaM manyate sa kadAchana nidhanaM na drakShyati| ");
INSERT INTO sanitr_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","yihUdIyAstamavadan tvaM bhUtagrasta itIdAnIm avaiShma| ibrAhIm bhaviShyadvAdina ncha sarvve mR^itAH kintu tvaM bhAShase yo naro mama bhAratIM gR^ihlAti sa jAtu nidhAnAsvAdaM na lapsyate| ");
INSERT INTO sanitr_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","tarhi tvaM kim asmAkaM pUrvvapuruShAd ibrAhImopi mahAn? yasmAt sopi mR^itaH bhaviShyadvAdinopi mR^itAH tvaM svaM kaM pumAMsaM manuShe? ");
INSERT INTO sanitr_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","yIshuH pratyavochad yadyahaM svaM svayaM sammanye tarhi mama tat sammananaM kimapi na kintu mama tAto yaM yUyaM svIyam IshvaraM bhAShadhve saeva mAM sammanute| ");
INSERT INTO sanitr_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","yUyaM taM nAvagachChatha kintvahaM tamavagachChAmi taM nAvagachChAmIti vAkyaM yadi vadAmi tarhi yUyamiva mR^iShAbhAShI bhavAmi kintvahaM tamavagachChAmi tadAkShAmapi gR^ihlAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","yuShmAkaM pUrvvapuruSha ibrAhIm mama samayaM draShTum atIvAvA nChat tannirIkShyAnandachcha| ");
INSERT INTO sanitr_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","tadA yihUdIyA apR^ichChan tava vayaH pa nchAshadvatsarA na tvaM kim ibrAhImam adrAkShIH? ");
INSERT INTO sanitr_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","yIshuH pratyavAdId yuShmAnahaM yathArthataraM vadAmi ibrAhImo janmanaH pUrvvakAlamArabhyAhaM vidye| ");
INSERT INTO sanitr_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","tadA te pAShANAn uttolya tamAhantum udayachChan kintu yIshu rgupto mantirAd bahirgatya teShAM madhyena prasthitavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","tataH paraM yIshurgachChan mArgamadhye janmAndhaM naram apashyat| ");
INSERT INTO sanitr_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","tataH shiShyAstam apR^ichChan he guro naroyaM svapApena vA svapitrAH pApenAndho.ajAyata? ");
INSERT INTO sanitr_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","tataH sa pratyuditavAn etasya vAsya pitroH pApAd etAdR^ishobhUda iti nahi kintvanena yatheshvarasya karmma prakAshyate taddhetoreva| ");
INSERT INTO sanitr_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","dine tiShThati matprerayituH karmma mayA karttavyaM yadA kimapi karmma na kriyate tAdR^ishI nishAgachChati| ");
INSERT INTO sanitr_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ahaM yAvatkAlaM jagati tiShThAmi tAvatkAlaM jagato jyotiHsvarUposmi| ");
INSERT INTO sanitr_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ityukttA bhUmau niShThIvaM nikShipya tena pa NkaM kR^itavAn ");
INSERT INTO sanitr_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","pashchAt tatpa Nkena tasyAndhasya netre pralipya tamityAdishat gatvA shilohe .arthAt preritanAmni sarasi snAhi| tatondho gatvA tatrAsnAt tataH prannachakShu rbhUtvA vyAghuTyAgAt| ");
INSERT INTO sanitr_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","apara ncha samIpavAsino lokA ye cha taM pUrvvamandham apashyan te bakttum Arabhanta yondhaloko vartmanyupavishyAbhikShata sa evAyaM janaH kiM na bhavati? ");
INSERT INTO sanitr_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","kechidavadan sa eva kechidavochan tAdR^isho bhavati kintu sa svayamabravIt sa evAhaM bhavAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ataeva te .apR^ichChan tvaM kathaM dR^iShTiM pAptavAn? ");
INSERT INTO sanitr_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","tataH sovadad yIshanAmaka eko jano mama nayane pa Nkena pralipya ityAj nApayat shilohakAsAraM gatvA tatra snAhi| tatastatra gatvA mayi snAte dR^iShTimahaM labdhavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","tadA te .avadan sa pumAn kutra? tenokttaM nAhaM jAnAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","aparaM tasmin pUrvvAndhe jane phirUshinAM nikaTam AnIte sati phirUshinopi tamapR^ichChan kathaM dR^iShTiM prAptosi? ");
INSERT INTO sanitr_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","tataH sa kathitavAn sa pa Nkena mama netre .alimpat pashchAd snAtvA dR^iShTimalabhe| ");
INSERT INTO sanitr_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","kintu yIshu rvishrAmavAre karddamaM kR^itvA tasya nayane prasanne.akarod itikAraNAt katipayaphirUshino.avadan ");
INSERT INTO sanitr_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","sa pumAn IshvarAnna yataH sa vishrAmavAraM na manyate| tatonye kechit pratyavadan pApI pumAn kim etAdR^isham AshcharyyaM karmma karttuM shaknoti? ");
INSERT INTO sanitr_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","itthaM teShAM parasparaM bhinnavAkyatvam abhavat| pashchAt te punarapi taM pUrvvAndhaM mAnuSham aprAkShuH yo janastava chakShuShI prasanne kR^itavAn tasmin tvaM kiM vadasi? sa ukttavAn sa bhavishadvAdI| ");
INSERT INTO sanitr_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","sa dR^iShTim AptavAn iti yihUdIyAstasya dR^iShTiM prAptasya janasya pitro rmukhAd ashrutvA na pratyayan| ");
INSERT INTO sanitr_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ataeva te tAvapR^ichChan yuvayo ryaM putraM janmAndhaM vadathaH sa kimayaM? tarhIdAnIM kathaM draShTuM shaknoti? ");
INSERT INTO sanitr_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","tatastasya pitarau pratyavochatAm ayam AvayoH putra A janerandhashcha tadapyAvAM jAnIvaH ");
INSERT INTO sanitr_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","kintvadhunA kathaM dR^iShTiM prAptavAn tadAvAM n jAnIvaH kosya chakShuShI prasanne kR^itavAn tadapi na jAnIva eSha vayaHprApta enaM pR^ichChata svakathAM svayaM vakShyati| ");
INSERT INTO sanitr_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","yihUdIyAnAM bhayAt tasya pitarau vAkyamidam avadatAM yataH kopi manuShyo yadi yIshum abhiShiktaM vadati tarhi sa bhajanagR^ihAd dUrIkAriShyate yihUdIyA iti mantraNAm akurvvan ");
INSERT INTO sanitr_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","atastasya pitarau vyAharatAm eSha vayaHprApta enaM pR^ichChata| ");
INSERT INTO sanitr_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","tadA te punashcha taM pUrvvAndham AhUya vyAharan Ishvarasya guNAn vada eSha manuShyaH pApIti vayaM jAnImaH| ");
INSERT INTO sanitr_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","tadA sa ukttavAn sa pApI na veti nAhaM jAne pUrvAmandha Asamaham adhunA pashyAmIti mAtraM jAnAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","te punarapR^ichChan sa tvAM prati kimakarot? kathaM netre prasanne .akarot? ");
INSERT INTO sanitr_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","tataH sovAdId ekakR^itvokathayaM yUyaM na shR^iNutha tarhi kutaH punaH shrotum ichChatha? yUyamapi kiM tasya shiShyA bhavitum ichChatha? ");
INSERT INTO sanitr_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","tadA te taM tiraskR^itya vyAharan tvaM tasya shiShyo vayaM mUsAH shiShyAH| ");
INSERT INTO sanitr_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","mUsAvaktreNeshvaro jagAda tajjAnImaH kintveSha kutratyaloka iti na jAnImaH| ");
INSERT INTO sanitr_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","sovadad eSha mama lochane prasanne .akarot tathApi kutratyaloka iti yUyaM na jAnItha etad AshcharyyaM bhavati| ");
INSERT INTO sanitr_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","IshvaraH pApinAM kathAM na shR^iNoti kintu yo janastasmin bhaktiM kR^itvA tadiShTakriyAM karoti tasyaiva kathAM shR^iNoti etad vayaM jAnImaH| ");
INSERT INTO sanitr_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","kopi manuShyo janmAndhAya chakShuShI adadAt jagadArambhAd etAdR^ishIM kathAM kopi kadApi nAshR^iNot| ");
INSERT INTO sanitr_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","asmAd eSha manuShyo yadIshvarAnnAjAyata tarhi ki nchidapIdR^ishaM karmma karttuM nAshaknot| ");
INSERT INTO sanitr_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","te vyAharan tvaM pApAd ajAyathAH kimasmAn tvaM shikShayasi? pashchAtte taM bahirakurvvan| ");
INSERT INTO sanitr_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","tadanantaraM yihUdIyaiH sa bahirakriyata yIshuriti vArttAM shrutvA taM sAkShAt prApya pR^iShTavAn Ishvarasya putre tvaM vishvasiShi? ");
INSERT INTO sanitr_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","tadA sa pratyavochat he prabho sa ko yat tasminnahaM vishvasimi? ");
INSERT INTO sanitr_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","tato yIshuH kathitavAn tvaM taM dR^iShTavAn tvayA sAkaM yaH kathaM kathayati saeva saH| ");
INSERT INTO sanitr_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","tadA he prabho vishvasimItyuktvA sa taM praNAmat| ");
INSERT INTO sanitr_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","pashchAd yIshuH kathitavAn nayanahInA nayanAni prApnuvanti nayanavantashchAndhA bhavantItyabhiprAyeNa jagadAham AgachCham| ");
INSERT INTO sanitr_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","etat shrutvA nikaTasthAH katipayAH phirUshino vyAharan vayamapi kimandhAH? ");
INSERT INTO sanitr_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","tadA yIshuravAdId yadyandhA abhavata tarhi pApAni nAtiShThan kintu pashyAmIti vAkyavadanAd yuShmAkaM pApAni tiShThanti| ");
INSERT INTO sanitr_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ahaM yuShmAnatiyathArthaM vadAmi, yo jano dvAreNa na pravishya kenApyanyena meShagR^ihaM pravishati sa eva steno dasyushcha| ");
INSERT INTO sanitr_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","yo dvAreNa pravishati sa eva meShapAlakaH| ");
INSERT INTO sanitr_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","dauvArikastasmai dvAraM mochayati meShagaNashcha tasya vAkyaM shR^iNoti sa nijAn meShAn svasvanAmnAhUya bahiH kR^itvA nayati| ");
INSERT INTO sanitr_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","tathA nijAn meShAn bahiH kR^itvA svayaM teShAm agre gachChati, tato meShAstasya shabdaM budhyante, tasmAt tasya pashchAd vrajanti| ");
INSERT INTO sanitr_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","kintu parasya shabdaM na budhyante tasmAt tasya pashchAd vrajiShyanti varaM tasya samIpAt palAyiShyante| ");
INSERT INTO sanitr_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","yIshustebhya imAM dR^iShTAntakathAm akathayat kintu tena kathitakathAyAstAtparyyaM te nAbudhyanta| ");
INSERT INTO sanitr_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","ato yIshuH punarakathayat, yuShmAnAhaM yathArthataraM vyAharAmi, meShagR^ihasya dvAram ahameva| ");
INSERT INTO sanitr_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","mayA na pravishya ya AgachChan te stenA dasyavashcha kintu meShAsteShAM kathA nAshR^iNvan| ");
INSERT INTO sanitr_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","ahameva dvArasvarUpaH, mayA yaH kashchita pravishati sa rakShAM prApsyati tathA bahirantashcha gamanAgamane kR^itvA charaNasthAnaM prApsyati| ");
INSERT INTO sanitr_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","yo janastenaH sa kevalaM stainyabadhavinAshAn karttumeva samAyAti kintvaham Ayu rdAtum arthAt bAhUlyena tadeva dAtum AgachCham| ");
INSERT INTO sanitr_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","ahameva satyameShapAlako yastu satyo meShapAlakaH sa meShArthaM prANatyAgaM karoti; ");
INSERT INTO sanitr_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","kintu yo jano meShapAlako na, arthAd yasya meShA nijA na bhavanti, ya etAdR^isho vaitanikaH sa vR^ikam AgachChantaM dR^iShTvA mejavrajaM vihAya palAyate, tasmAd vR^ikastaM vrajaM dhR^itvA vikirati| ");
INSERT INTO sanitr_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","vaitanikaH palAyate yataH sa vetanArthI meShArthaM na chintayati| ");
INSERT INTO sanitr_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","ahameva satyo meShapAlakaH, pitA mAM yathA jAnAti, aha ncha yathA pitaraM jAnAmi, ");
INSERT INTO sanitr_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","tathA nijAn meShAnapi jAnAmi, meShAshcha mAM jAnAnti, aha ncha meShArthaM prANatyAgaM karomi| ");
INSERT INTO sanitr_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","apara ncha etad gR^ihIya meShebhyo bhinnA api meShA mama santi te sakalA AnayitavyAH; te mama shabdaM shroShyanti tata eko vraja eko rakShako bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","prANAnahaM tyaktvA punaH prANAn grahIShyAmi, tasmAt pitA mayi snehaM karoti| ");
INSERT INTO sanitr_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","kashchijjano mama prANAn hantuM na shaknoti kintu svayaM tAn samarpayAmi tAn samarpayituM punargrahItu ncha mama shaktirAste bhAramimaM svapituH sakAshAt prAptoham| ");
INSERT INTO sanitr_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","asmAdupadeshAt punashcha yihUdIyAnAM madhye bhinnavAkyatA jAtA| ");
INSERT INTO sanitr_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","tato bahavo vyAharan eSha bhUtagrasta unmattashcha, kuta etasya kathAM shR^iNutha? ");
INSERT INTO sanitr_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","kechid avadan etasya kathA bhUtagrastasya kathAvanna bhavanti, bhUtaH kim andhAya chakShuShI dAtuM shaknoti? ");
INSERT INTO sanitr_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","shItakAle yirUshAlami mandirotsargaparvvaNyupasthite ");
INSERT INTO sanitr_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","yIshuH sulemAno niHsAreNa gamanAgamane karoti, ");
INSERT INTO sanitr_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","etasmin samaye yihUdIyAstaM veShTayitvA vyAharan kati kAlAn asmAkaM vichikitsAM sthApayiShyAmi? yadyabhiShikto bhavati tarhi tat spaShTaM vada| ");
INSERT INTO sanitr_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","tadA yIshuH pratyavadad aham achakathaM kintu yUyaM na pratItha, nijapitu rnAmnA yAM yAM kriyAM karomi sA kriyaiva mama sAkShisvarUpA| ");
INSERT INTO sanitr_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","kintvahaM pUrvvamakathayaM yUyaM mama meShA na bhavatha, kAraNAdasmAn na vishvasitha| ");
INSERT INTO sanitr_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","mama meShA mama shabdaM shR^iNvanti tAnahaM jAnAmi te cha mama pashchAd gachChanti| ");
INSERT INTO sanitr_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ahaM tebhyo.anantAyu rdadAmi, te kadApi na naMkShyanti kopi mama karAt tAn harttuM na shakShyati| ");
INSERT INTO sanitr_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","yo mama pitA tAn mahyaM dattavAn sa sarvvasmAt mahAn, kopi mama pituH karAt tAn harttuM na shakShyati| ");
INSERT INTO sanitr_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ahaM pitA cha dvayorekatvam| ");
INSERT INTO sanitr_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","tato yihUdIyAH punarapi taM hantuM pAShANAn udatolayan| ");
INSERT INTO sanitr_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","yIshuH kathitavAn pituH sakAshAd bahUnyuttamakarmmANi yuShmAkaM prAkAshayaM teShAM kasya karmmaNaH kAraNAn mAM pAShANairAhantum udyatAH stha? ");
INSERT INTO sanitr_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","yihUdIyAH pratyavadan prashastakarmmaheto rna kintu tvaM mAnuShaH svamIshvaram uktveshvaraM nindasi kAraNAdasmAt tvAM pAShANairhanmaH| ");
INSERT INTO sanitr_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","tadA yIshuH pratyuktavAn mayA kathitaM yUyam IshvarA etadvachanaM yuShmAkaM shAstre likhitaM nAsti kiM? ");
INSERT INTO sanitr_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","tasmAd yeShAm uddeshe Ishvarasya kathA kathitA te yadIshvaragaNA uchyante dharmmagranthasyApyanyathA bhavituM na shakyaM, ");
INSERT INTO sanitr_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","tarhyAham Ishvarasya putra iti vAkyasya kathanAt yUyaM pitrAbhiShiktaM jagati prerita ncha pumAMsaM katham IshvaranindakaM vAdaya? ");
INSERT INTO sanitr_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","yadyahaM pituH karmma na karomi tarhi mAM na pratIta; ");
INSERT INTO sanitr_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","kintu yadi karomi tarhi mayi yuShmAbhiH pratyaye na kR^ite.api kAryye pratyayaH kriyatAM, tato mayi pitAstIti pitaryyaham asmIti cha kShAtvA vishvasiShyatha| ");
INSERT INTO sanitr_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","tadA te punarapi taM dharttum acheShTanta kintu sa teShAM karebhyo nistIryya ");
INSERT INTO sanitr_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","puna ryarddan adyAstaTe yatra purvvaM yohan amajjayat tatrAgatya nyavasat| ");
INSERT INTO sanitr_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","tato bahavo lokAstatsamIpam Agatya vyAharan yohan kimapyAshcharyyaM karmma nAkarot kintvasmin manuShye yA yaH kathA akathayat tAH sarvvAH satyAH; ");
INSERT INTO sanitr_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","tatra cha bahavo lokAstasmin vyashvasan| ");
INSERT INTO sanitr_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","anantaraM mariyam tasyA bhaginI marthA cha yasmin vaithanIyAgrAme vasatastasmin grAme iliyAsar nAmA pIDita eka AsIt| ");
INSERT INTO sanitr_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","yA mariyam prabhuM sugandhitelaina marddayitvA svakeshaistasya charaNau samamArjat tasyA bhrAtA sa iliyAsar rogI| ");
INSERT INTO sanitr_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","apara ncha he prabho bhavAn yasmin prIyate sa eva pIDitostIti kathAM kathayitvA tasya bhaginyau preShitavatyau| ");
INSERT INTO sanitr_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","tadA yIshurimAM vArttAM shrutvAkathayata pIDeyaM maraNArthaM na kintvIshvarasya mahimArtham Ishvaraputrasya mahimaprakAshArtha ncha jAtA| ");
INSERT INTO sanitr_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","yIshu ryadyapimarthAyAM tadbhaginyAm iliyAsari chAprIyata, ");
INSERT INTO sanitr_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","tathApi iliyAsaraH pIDAyAH kathaM shrutvA yatra AsIt tatraiva dinadvayamatiShThat| ");
INSERT INTO sanitr_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","tataH param sa shiShyAnakathayad vayaM puna ryihUdIyapradeshaM yAmaH| ");
INSERT INTO sanitr_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","tataste pratyavadan, he guro svalpadinAni gatAni yihUdIyAstvAM pAShANai rhantum udyatAstathApi kiM punastatra yAsyasi? ");
INSERT INTO sanitr_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","yIshuH pratyavadat, ekasmin dine kiM dvAdashaghaTikA na bhavanti? kopi divA gachChan na skhalati yataH sa etajjagato dIptiM prApnoti| ");
INSERT INTO sanitr_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","kintu rAtrau gachChan skhalati yato hetostatra dIpti rnAsti| ");
INSERT INTO sanitr_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","imAM kathAM kathayitvA sa tAnavadad, asmAkaM bandhuH iliyAsar nidritobhUd idAnIM taM nidrAto jAgarayituM gachChAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","yIshu rmR^itau kathAmimAM kathitavAn kintu vishrAmArthaM nidrAyAM kathitavAn iti j nAtvA shiShyA akathayan, ");
INSERT INTO sanitr_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","he guro sa yadi nidrAti tarhi bhadrameva| ");
INSERT INTO sanitr_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","tadA yIshuH spaShTaM tAn vyAharat, iliyAsar amriyata; ");
INSERT INTO sanitr_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","kintu yUyaM yathA pratItha tadarthamahaM tatra na sthitavAn ityasmAd yuShmannimittam AhlAditohaM, tathApi tasya samIpe yAma| ");
INSERT INTO sanitr_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","tadA thomA yaM didumaM vadanti sa sa NginaH shiShyAn avadad vayamapi gatvA tena sArddhaM mriyAmahai| ");
INSERT INTO sanitr_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","yIshustatropasthAya iliyAsaraH shmashAne sthApanAt chatvAri dinAni gatAnIti vArttAM shrutavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","vaithanIyA yirUshAlamaH samIpasthA kroshaikamAtrAntaritA; ");
INSERT INTO sanitr_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","tasmAd bahavo yihUdIyA marthAM mariyama ncha bhyAtR^ishokApannAM sAntvayituM tayoH samIpam AgachChan| ");
INSERT INTO sanitr_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","marthA yIshorAgamanavArtAM shrutvaiva taM sAkShAd akarot kintu mariyam geha upavishya sthitA| ");
INSERT INTO sanitr_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","tadA marthA yIshumavAdat, he prabho yadi bhavAn atrAsthAsyat tarhi mama bhrAtA nAmariShyat| ");
INSERT INTO sanitr_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","kintvidAnImapi yad Ishvare prArthayiShyate Ishvarastad dAsyatIti jAne.ahaM| ");
INSERT INTO sanitr_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","yIshuravAdIt tava bhrAtA samutthAsyati| ");
INSERT INTO sanitr_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","marthA vyAharat sheShadivase sa utthAnasamaye protthAsyatIti jAne.ahaM| ");
INSERT INTO sanitr_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","tadA yIshuH kathitavAn ahameva utthApayitA jIvayitA cha yaH kashchana mayi vishvasiti sa mR^itvApi jIviShyati; ");
INSERT INTO sanitr_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","yaH kashchana cha jIvan mayi vishvasiti sa kadApi na mariShyati, asyAM kathAyAM kiM vishvasiShi? ");
INSERT INTO sanitr_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","sAvadat prabho yasyAvataraNApekShAsti bhavAn saevAbhiShiktta Ishvaraputra iti vishvasimi| ");
INSERT INTO sanitr_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","iti kathAM kathayitvA sA gatvA svAM bhaginIM mariyamaM guptamAhUya vyAharat gururupatiShThati tvAmAhUyati cha| ");
INSERT INTO sanitr_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","kathAmimAM shrutvA sA tUrNam utthAya tasya samIpam agachChat| ");
INSERT INTO sanitr_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","yIshu rgrAmamadhyaM na pravishya yatra marthA taM sAkShAd akarot tatra sthitavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","ye yihUdIyA mariyamA sAkaM gR^ihe tiShThantastAm asAntvayana te tAM kShipram utthAya gachChantiM vilokya vyAharan, sa shmashAne rodituM yAti, ityuktvA te tasyAH pashchAd agachChan| ");
INSERT INTO sanitr_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","yatra yIshuratiShThat tatra mariyam upasthAya taM dR^iShTvA tasya charaNayoH patitvA vyAharat he prabho yadi bhavAn atrAsthAsyat tarhi mama bhrAtA nAmariShyat| ");
INSERT INTO sanitr_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","yIshustAM tasyAH sa Ngino yihUdIyAMshcha rudato vilokya shokArttaH san dIrghaM nishvasya kathitavAn taM kutrAsthApayata? ");
INSERT INTO sanitr_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","te vyAharan, he prabho bhavAn Agatya pashyatu| ");
INSERT INTO sanitr_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","yIshunA kranditaM| ");
INSERT INTO sanitr_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ataeva yihUdIyA avadan, pashyatAyaM tasmin kidR^ig apriyata| ");
INSERT INTO sanitr_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","teShAM kechid avadan yondhAya chakShuShI dattavAn sa kim asya mR^ityuM nivArayituM nAshaknot? ");
INSERT INTO sanitr_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","tato yIshuH punarantardIrghaM nishvasya shmashAnAntikam agachChat| tat shmashAnam ekaM gahvaraM tanmukhe pAShANa eka AsIt| ");
INSERT INTO sanitr_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","tadA yIshuravadad enaM pAShANam apasArayata, tataH pramItasya bhaginI marthAvadat prabho, adhunA tatra durgandho jAtaH, yatodya chatvAri dinAni shmashAne sa tiShThati| ");
INSERT INTO sanitr_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","tadA yIshuravAdIt, yadi vishvasiShi tarhIshvarasya mahimaprakAshaM drakShyasi kathAmimAM kiM tubhyaM nAkathayaM? ");
INSERT INTO sanitr_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","tadA mR^itasya shmashAnAt pAShANo.apasArite yIshurUrdvvaM pashyan akathayat, he pita rmama nevesanam ashR^iNoH kAraNAdasmAt tvAM dhanyaM vadAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","tvaM satataM shR^iNoShi tadapyahaM jAnAmi, kintu tvaM mAM yat prairayastad yathAsmin sthAne sthitA lokA vishvasanti tadartham idaM vAkyaM vadAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","imAM kathAM kathayitvA sa prochchairAhvayat, he iliyAsar bahirAgachCha| ");
INSERT INTO sanitr_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","tataH sa pramItaH shmashAnavastrai rbaddhahastapAdo gAtramArjanavAsasA baddhamukhashcha bahirAgachChat| yIshuruditavAn bandhanAni mochayitvA tyajatainaM| ");
INSERT INTO sanitr_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","mariyamaH samIpam AgatA ye yihUdIyalokAstadA yIshoretat karmmApashyan teShAM bahavo vyashvasan, ");
INSERT INTO sanitr_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","kintu kechidanye phirUshinAM samIpaM gatvA yIshoretasya karmmaNo vArttAm avadan| ");
INSERT INTO sanitr_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","tataH paraM pradhAnayAjakAH phirUshinAshcha sabhAM kR^itvA vyAharan vayaM kiM kurmmaH? eSha mAnavo bahUnyAshcharyyakarmmANi karoti| ");
INSERT INTO sanitr_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","yadIdR^ishaM karmma karttuM na vArayAmastarhi sarvve lokAstasmin vishvasiShyanti romilokAshchAgatyAsmAkam anayA rAjadhAnyA sArddhaM rAjyam AChetsyanti| ");
INSERT INTO sanitr_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","tadA teShAM kiyaphAnAmA yastasmin vatsare mahAyAjakapade nyayujyata sa pratyavadad yUyaM kimapi na jAnItha; ");
INSERT INTO sanitr_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","samagradeshasya vinAshatopi sarvvalokArtham ekasya janasya maraNam asmAkaM ma Ngalahetukam etasya vivechanAmapi na kurutha| ");
INSERT INTO sanitr_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","etAM kathAM sa nijabuddhyA vyAharad iti na, ");
INSERT INTO sanitr_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","kintu yIshUstaddeshIyAnAM kAraNAt prANAn tyakShyati, dishi dishi vikIrNAn Ishvarasya santAnAn saMgR^ihyaikajAtiM kariShyati cha, tasmin vatsare kiyaphA mahAyAjakatvapade niyuktaH san idaM bhaviShyadvAkyaM kathitavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","taddinamArabhya te kathaM taM hantuM shaknuvantIti mantraNAM karttuM prArebhire| ");
INSERT INTO sanitr_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ataeva yihUdIyAnAM madhye yIshuH saprakAshaM gamanAgamane akR^itvA tasmAd gatvA prAntarasya samIpasthAyipradeshasyephrAyim nAmni nagare shiShyaiH sAkaM kAlaM yApayituM prArebhe| ");
INSERT INTO sanitr_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","anantaraM yihUdIyAnAM nistArotsave nikaTavarttini sati tadutsavAt pUrvvaM svAn shuchIn karttuM bahavo janA grAmebhyo yirUshAlam nagaram AgachChan, ");
INSERT INTO sanitr_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","yIshoranveShaNaM kR^itvA mandire daNDAyamAnAH santaH parasparaM vyAharan, yuShmAkaM kIdR^isho bodho jAyate? sa kim utsave.asmin atrAgamiShyati? ");
INSERT INTO sanitr_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","sa cha kutrAsti yadyetat kashchid vetti tarhi darshayatu pradhAnayAjakAH phirUshinashcha taM dharttuM pUrvvam imAm Aj nAM prAchArayan| ");
INSERT INTO sanitr_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","nistArotsavAt pUrvvaM dinaShaTke sthite yIshu ryaM pramItam iliyAsaraM shmashAnAd udasthAparat tasya nivAsasthAnaM baithaniyAgrAmam AgachChat| ");
INSERT INTO sanitr_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","tatra tadarthaM rajanyAM bhojye kR^ite marthA paryyaveShayad iliyAsar cha tasya sa NgibhiH sArddhaM bhojanAsana upAvishat| ");
INSERT INTO sanitr_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","tadA mariyam arddhaseTakaM bahumUlyaM jaTAmAMsIyaM tailam AnIya yIshoshcharaNayo rmarddayitvA nijakesha rmArShTum Arabhata; tadA tailasya parimalena gR^iham Amoditam abhavat| ");
INSERT INTO sanitr_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","yaH shimonaH putra riShkariyotIyo yihUdAnAmA yIshuM parakareShu samarpayiShyati sa shiShyastadA kathitavAn, ");
INSERT INTO sanitr_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","etattailaM tribhiH shatai rmudrApadai rvikrItaM sad daridrebhyaH kuto nAdIyata? ");
INSERT INTO sanitr_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","sa daridralokArtham achintayad iti na, kintu sa chaura evaM tannikaTe mudrAsampuTakasthityA tanmadhye yadatiShThat tadapAharat tasmAt kAraNAd imAM kathAmakathayat| ");
INSERT INTO sanitr_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","tadA yIshurakathayad enAM mA vAraya sA mama shmashAnasthApanadinArthaM tadarakShayat| ");
INSERT INTO sanitr_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","daridrA yuShmAkaM sannidhau sarvvadA tiShThanti kintvahaM sarvvadA yuShmAkaM sannidhau na tiShThAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","tataH paraM yIshustatrAstIti vArttAM shrutvA bahavo yihUdIyAstaM shmashAnAdutthApitam iliyAsara ncha draShTuM tat sthAnam AgachChana| ");
INSERT INTO sanitr_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","tadA pradhAnayAjakAstam iliyAsaramapi saMharttum amantrayan ; ");
INSERT INTO sanitr_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","yatastena bahavo yihUdIyA gatvA yIshau vyashvasan| ");
INSERT INTO sanitr_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","anantaraM yIshu ryirUshAlam nagaram AgachChatIti vArttAM shrutvA pare.ahani utsavAgatA bahavo lokAH ");
INSERT INTO sanitr_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","kharjjUrapatrAdyAnIya taM sAkShAt karttuM bahirAgatya jaya jayeti vAchaM prochchai rvaktum Arabhanta, isrAyelo yo rAjA parameshvarasya nAmnAgachChati sa dhanyaH| ");
INSERT INTO sanitr_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","tadA \"he siyonaH kanye mA bhaiShIH pashyAyaM tava rAjA garddabhashAvakam AruhyAgachChati\" ");
INSERT INTO sanitr_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","iti shAstrIyavachanAnusAreNa yIshurekaM yuvagarddabhaM prApya taduparyyArohat| ");
INSERT INTO sanitr_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","asyAH ghaTanAyAstAtparyyaM shiShyAH prathamaM nAbudhyanta, kintu yIshau mahimAnaM prApte sati vAkyamidaM tasmina akathyata lokAshcha tampratIttham akurvvan iti te smR^itavantaH| ");
INSERT INTO sanitr_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","sa iliyAsaraM shmashAnAd Agantum AhvatavAn shmashAnA ncha udasthApayad ye ye lokAstatkarmya sAkShAd apashyan te pramANaM dAtum Arabhanta| ");
INSERT INTO sanitr_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","sa etAdR^isham adbhutaM karmmakarot tasya janashrute rlokAstaM sAkShAt karttum AgachChan| ");
INSERT INTO sanitr_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","tataH phirUshinaH parasparaM vaktum Arabhanta yuShmAkaM sarvvAshcheShTA vR^ithA jAtAH, iti kiM yUyaM na budhyadhve? pashyata sarvve lokAstasya pashchAdvarttinobhavan| ");
INSERT INTO sanitr_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","bhajanaM karttum utsavAgatAnAM lokAnAM katipayA janA anyadeshIyA Asan , ");
INSERT INTO sanitr_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","te gAlIlIyabaitsaidAnivAsinaH philipasya samIpam Agatya vyAharan he mahechCha vayaM yIshuM draShTum ichChAmaH| ");
INSERT INTO sanitr_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","tataH philipo gatvA Andriyam avadat pashchAd Andriyaphilipau yIshave vArttAm akathayatAM| ");
INSERT INTO sanitr_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","tadA yIshuH pratyuditavAn mAnavasutasya mahimaprAptisamaya upasthitaH| ");
INSERT INTO sanitr_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ahaM yuShmAnatiyathArthaM vadAmi, dhAnyabIjaM mR^ittikAyAM patitvA yadi na mR^iyate tarhyekAkI tiShThati kintu yadi mR^iyate tarhi bahuguNaM phalaM phalati| ");
INSERT INTO sanitr_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","yo janeा nijaprANAn priyAn jAnAti sa tAn hArayiShyati kintu yeा jana ihaloke nijaprANAn apriyAn jAnAti seाnantAyuH prAptuM tAn rakShiShyati| ");
INSERT INTO sanitr_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","kashchid yadi mama sevako bhavituM vA nChati tarhi sa mama pashchAdgAmI bhavatu, tasmAd ahaM yatra tiShThAmi mama sevakeाpi tatra sthAsyati; yo jano mAM sevate mama pitApi taM sammaMsyate| ");
INSERT INTO sanitr_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","sAmprataM mama prANA vyAkulA bhavanti, tasmAd he pitara etasmAt samayAn mAM rakSha, ityahaM kiM prArthayiShye? kintvaham etatsamayArtham avatIrNavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","he pita: svanAmno mahimAnaM prakAshaya; tanaiva svanAmno mahimAnam ahaM prAkAshayaM punarapi prakAshayiShyAmi, eShA gagaNIyA vANI tasmin samaye.ajAyata| ");
INSERT INTO sanitr_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","tachshrutvA samIpasthalokAnAM kechid avadan megho.agarjIt, kechid avadan svargIyadUto.anena saha kathAmachakathat| ");
INSERT INTO sanitr_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","tadA yIshuH pratyavAdIt, madarthaM shabdoyaM nAbhUt yuShmadarthamevAbhUt| ");
INSERT INTO sanitr_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","adhunA jagatosya vichAra: sampatsyate, adhunAsya jagata: patI rAjyAt chyoShyati| ");
INSERT INTO sanitr_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","yadyaI pR^ithivyA Urdvve protthApitosmi tarhi sarvvAn mAnavAn svasamIpam AkarShiShyAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","kathaM tasya mR^iti rbhaviShyati, etad bodhayituM sa imAM kathAm akathayat| ");
INSERT INTO sanitr_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","tadA lokA akathayan sobhiShiktaH sarvvadA tiShThatIti vyavasthAgranthe shrutam asmAbhiH, tarhi manuShyaputraH protthApito bhaviShyatIti vAkyaM kathaM vadasi? manuShyaputroyaM kaH? ");
INSERT INTO sanitr_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","tadA yIshurakathAyad yuShmAbhiH sArddham alpadinAni jyotirAste, yathA yuShmAn andhakAro nAchChAdayati tadarthaM yAvatkAlaM yuShmAbhiH sArddhaM jyotistiShThati tAvatkAlaM gachChata; yo jano.andhakAre gachChati sa kutra yAtIti na jAnAti| ");
INSERT INTO sanitr_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ataeva yAvatkAlaM yuShmAkaM nikaTe jyotirAste tAvatkAlaM jyotIrUpasantAnA bhavituM jyotiShi vishvasita; imAM kathAM kathayitvA yIshuH prasthAya tebhyaH svaM guptavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","yadyapi yIshusteShAM samakSham etAvadAshcharyyakarmmANi kR^itavAn tathApi te tasmin na vyashvasan| ");
INSERT INTO sanitr_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ataeva kaH pratyeti susaMvAdaM pareshAsmat prachAritaM? prakAshate pareshasya hastaH kasya cha sannidhau? yishayiyabhaviShyadvAdinA yadetad vAkyamuktaM tat saphalam abhavat| ");
INSERT INTO sanitr_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","te pratyetuM nAshankuvan tasmin yishayiyabhaviShyadvAdi punaravAdId, ");
INSERT INTO sanitr_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","yadA, \"te nayanai rna pashyanti buddhibhishcha na budhyante tai rmanaHsu parivarttiteShu cha tAnahaM yathA svasthAn na karomi tathA sa teShAM lochanAnyandhAni kR^itvA teShAmantaHkaraNAni gADhAni kariShyati|\" ");
INSERT INTO sanitr_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","yishayiyo yadA yIsho rmahimAnaM vilokya tasmin kathAmakathayat tadA bhaviShyadvAkyam IdR^ishaM prakAshayat| ");
INSERT INTO sanitr_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","tathApyadhipatinAM bahavastasmin pratyAyan| kintu phirUshinastAn bhajanagR^ihAd dUrIkurvvantIti bhayAt te taM na svIkR^itavantaH| ");
INSERT INTO sanitr_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","yata Ishvarasya prashaMsAto mAnavAnAM prashaMsAyAM te.apriyanta| ");
INSERT INTO sanitr_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","tadA yIshuruchchaiHkAram akathayad yo jano mayi vishvasiti sa kevale mayi vishvasitIti na, sa matprerake.api vishvasiti| ");
INSERT INTO sanitr_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","yo jano mAM pashyati sa matprerakamapi pashyati| ");
INSERT INTO sanitr_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","yo jano mAM pratyeti sa yathAndhakAre na tiShThati tadartham ahaM jyotiHsvarUpo bhUtvA jagatyasmin avatIrNavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","mama kathAM shrutvA yadi kashchin na vishvasiti tarhi tamahaM doShiNaM na karomi, yato heto rjagato janAnAM doShAn nishchitAn karttuM nAgatya tAn parichAtum Agatosmi| ");
INSERT INTO sanitr_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","yaH kashchin mAM na shraddhAya mama kathaM na gR^ihlAti, anyastaM doShiNaM kariShyati vastutastu yAM kathAmaham achakathaM sA kathA charame.anhi taM doShiNaM kariShyati| ");
INSERT INTO sanitr_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","yato hetorahaM svataH kimapi na kathayAmi, kiM kiM mayA kathayitavyaM kiM samupadeShTavya ncha iti matprerayitA pitA mAmAj nApayat| ");
INSERT INTO sanitr_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","tasya sAj nA anantAyurityahaM jAnAmi, ataevAhaM yat kathayAmi tat pitA yathAj nApayat tathaiva kathayAmyaham| ");
INSERT INTO sanitr_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","nistArotsavasya ki nchitkAlAt pUrvvaM pR^ithivyAH pituH samIpagamanasya samayaH sannikarShobhUd iti j nAtvA yIshurAprathamAd yeShu jagatpravAsiShvAtmIyalokeSha prema karoti sma teShu sheShaM yAvat prema kR^itavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","pitA tasya haste sarvvaM samarpitavAn svayam Ishvarasya samIpAd AgachChad Ishvarasya samIpaM yAsyati cha, sarvvANyetAni j nAtvA rajanyAM bhojane sampUrNe sati, ");
INSERT INTO sanitr_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","yadA shaitAn taM parahasteShu samarpayituM shimonaH putrasya IShkAriyotiyasya yihUdA antaHkaraNe kupravR^ittiM samArpayat, ");
INSERT INTO sanitr_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","tadA yIshu rbhojanAsanAd utthAya gAtravastraM mochayitvA gAtramArjanavastraM gR^ihItvA tena svakaTim abadhnAt, ");
INSERT INTO sanitr_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","pashchAd ekapAtre jalam abhiShichya shiShyANAM pAdAn prakShAlya tena kaTibaddhagAtramArjanavAsasA mArShTuM prArabhata| ");
INSERT INTO sanitr_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","tataH shimonpitarasya samIpamAgate sa uktavAn he prabho bhavAn kiM mama pAdau prakShAlayiShyati? ");
INSERT INTO sanitr_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","yIshuruditavAn ahaM yat karomi tat samprati na jAnAsi kintu pashchAj j nAsyasi| ");
INSERT INTO sanitr_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","tataH pitaraH kathitavAn bhavAn kadApi mama pAdau na prakShAlayiShyati| yIshurakathayad yadi tvAM na prakShAlaye tarhi mayi tava kopyaMsho nAsti| ");
INSERT INTO sanitr_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","tadA shimonpitaraH kathitavAn he prabho tarhi kevalapAdau na, mama hastau shirashcha prakShAlayatu| ");
INSERT INTO sanitr_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","tato yIshuravadad yo jano dhautastasya sarvvA NgapariShkR^itatvAt pAdau vinAnyA Ngasya prakShAlanApekShA nAsti| yUyaM pariShkR^itA iti satyaM kintu na sarvve, ");
INSERT INTO sanitr_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","yato yo janastaM parakareShu samarpayiShyati taM sa j nAtavAna; ataeva yUyaM sarvve na pariShkR^itA imAM kathAM kathitavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","itthaM yIshusteShAM pAdAn prakShAlya vastraM paridhAyAsane samupavishya kathitavAn ahaM yuShmAn prati kiM karmmAkArShaM jAnItha? ");
INSERT INTO sanitr_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","yUyaM mAM guruM prabhu ncha vadatha tat satyameva vadatha yatohaM saeva bhavAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","yadyahaM prabhu rgurushcha san yuShmAkaM pAdAn prakShAlitavAn tarhi yuShmAkamapi parasparaM pAdaprakShAlanam uchitam| ");
INSERT INTO sanitr_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","ahaM yuShmAn prati yathA vyavAharaM yuShmAn tathA vyavaharttum ekaM panthAnaM darshitavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","ahaM yuShmAnatiyathArthaM vadAmi, prabho rdAso na mahAn prerakAchcha prerito na mahAn| ");
INSERT INTO sanitr_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","imAM kathAM viditvA yadi tadanusArataH karmmANi kurutha tarhi yUyaM dhanyA bhaviShyatha| ");
INSERT INTO sanitr_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","sarvveShu yuShmAsu kathAmimAM kathayAmi iti na, ye mama manonItAstAnahaM jAnAmi, kintu mama bhakShyANi yo bhu Nkte matprANaprAtikUlyataH| utthApayati pAdasya mUlaM sa eSha mAnavaH|yadetad dharmmapustakasya vachanaM tadanusAreNAvashyaM ghaTiShyate| ");
INSERT INTO sanitr_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","ahaM sa jana ityatra yathA yuShmAkaM vishvAso jAyate tadarthaM etAdR^ishaghaTanAt pUrvvam ahamidAnIM yuShmabhyamakathayam| ");
INSERT INTO sanitr_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","ahaM yuShmAnatIva yathArthaM vadAmi, mayA preritaM janaM yo gR^ihlAti sa mAmeva gR^ihlAti yashcha mAM gR^ihlAti sa matprerakaM gR^ihlAti| ");
INSERT INTO sanitr_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","etAM kathAM kathayitvA yIshu rduHkhI san pramANaM dattvA kathitavAn ahaM yuShmAnatiyathArthaM vadAmi yuShmAkam eko jano mAM parakareShu samarpayiShyati| ");
INSERT INTO sanitr_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","tataH sa kamuddishya kathAmetAM kathitavAn ityatra sandigdhAH shiShyAH parasparaM mukhamAlokayituM prArabhanta| ");
INSERT INTO sanitr_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","tasmin samaye yIshu ryasmin aprIyata sa shiShyastasya vakShaHsthalam avAlambata| ");
INSERT INTO sanitr_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","shimonpitarastaM sa NketenAvadat, ayaM kamuddishya kathAmetAm kathayatIti pR^ichCha| ");
INSERT INTO sanitr_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","tadA sa yIsho rvakShaHsthalam avalambya pR^iShThavAn, he prabho sa janaH kaH? ");
INSERT INTO sanitr_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","tato yIshuH pratyavadad ekakhaNDaM pUpaM majjayitvA yasmai dAsyAmi saeva saH; pashchAt pUpakhaNDamekaM majjayitvA shimonaH putrAya IShkariyotIyAya yihUdai dattavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","tasmin datte sati shaitAn tamAshrayat; tadA yIshustam avadat tvaM yat kariShyasi tat kShipraM kuru| ");
INSERT INTO sanitr_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","kintu sa yenAshayena tAM kathAmakathAyat tam upaviShTalokAnAM kopi nAbudhyata; ");
INSERT INTO sanitr_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","kintu yihUdAH samIpe mudrAsampuTakasthiteH kechid ittham abudhyanta pArvvaNAsAdanArthaM kimapi dravyaM kretuM vA daridrebhyaH ki nchid vitarituM kathitavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","tadA pUpakhaNDagrahaNAt paraM sa tUrNaM bahiragachChat; rAtrishcha samupasyitA| ");
INSERT INTO sanitr_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","yihUde bahirgate yIshurakathayad idAnIM mAnavasutasya mahimA prakAshate teneshvarasyApi mahimA prakAshate| ");
INSERT INTO sanitr_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","yadi teneshvarasya mahimA prakAshate tarhIshvaropi svena tasya mahimAnaM prakAshayiShyati tUrNameva prakAshayiShyati| ");
INSERT INTO sanitr_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","he vatsA ahaM yuShmAbhiH sArddhaM ki nchitkAlamAtram Ase, tataH paraM mAM mR^igayiShyadhve kintvahaM yatsthAnaM yAmi tatsthAnaM yUyaM gantuM na shakShyatha, yAmimAM kathAM yihUdIyebhyaH kathitavAn tathAdhunA yuShmabhyamapi kathayAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","yUyaM parasparaM prIyadhvam ahaM yuShmAsu yathA prIye yUyamapi parasparam tathaiva prIyadhvaM, yuShmAn imAM navInAm Aj nAm AdishAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","tenaiva yadi parasparaM prIyadhve tarhi lakShaNenAnena yUyaM mama shiShyA iti sarvve j nAtuM shakShyanti| ");
INSERT INTO sanitr_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","shimonapitaraH pR^iShThavAn he prabho bhavAn kutra yAsyati? tato yIshuH pratyavadat, ahaM yatsthAnaM yAmi tatsthAnaM sAmprataM mama pashchAd gantuM na shaknoShi kintu pashchAd gamiShyasi| ");
INSERT INTO sanitr_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","tadA pitaraH pratyuditavAn, he prabho sAmprataM kuto hetostava pashchAd gantuM na shaknomi? tvadarthaM prANAn dAtuM shaknomi| ");
INSERT INTO sanitr_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","tato yIshuH pratyuktavAn mannimittaM kiM prANAn dAtuM shaknoShi? tvAmahaM yathArthaM vadAmi, kukkuTaravaNAt pUrvvaM tvaM tri rmAm apahnoShyase| ");
INSERT INTO sanitr_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","manoduHkhino mA bhUta; Ishvare vishvasita mayi cha vishvasita| ");
INSERT INTO sanitr_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","mama pitu gR^ihe bahUni vAsasthAni santi no chet pUrvvaM yuShmAn aj nApayiShyaM yuShmadarthaM sthAnaM sajjayituM gachChAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","yadi gatvAhaM yuShmannimittaM sthAnaM sajjayAmi tarhi panarAgatya yuShmAn svasamIpaM neShyAmi, tato yatrAhaM tiShThAmi tatra yUyamapi sthAsyatha| ");
INSERT INTO sanitr_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ahaM yatsthAnaM brajAmi tatsthAnaM yUyaM jAnItha tasya panthAnamapi jAnItha| ");
INSERT INTO sanitr_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","tadA thomA avadat, he prabho bhavAn kutra yAti tadvayaM na jAnImaH, tarhi kathaM panthAnaM j nAtuM shaknumaH? ");
INSERT INTO sanitr_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","yIshurakathayad ahameva satyajIvanarUpapatho mayA na gantA kopi pituH samIpaM gantuM na shaknoti| ");
INSERT INTO sanitr_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","yadi mAm aj nAsyata tarhi mama pitaramapyaj nAsyata kintvadhunAtastaM jAnItha pashyatha cha| ");
INSERT INTO sanitr_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","tadA philipaH kathitavAn, he prabho pitaraM darshaya tasmAdasmAkaM yatheShTaM bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","tato yIshuH pratyAvAdIt, he philipa yuShmAbhiH sArddham etAvaddinAni sthitamapi mAM kiM na pratyabhijAnAsi? yo jano mAm apashyat sa pitaramapyapashyat tarhi pitaram asmAn darshayeti kathAM kathaM kathayasi? ");
INSERT INTO sanitr_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ahaM pitari tiShThAmi pitA mayi tiShThatIti kiM tvaM na pratyaShi? ahaM yadvAkyaM vadAmi tat svato na vadAmi kintu yaH pitA mayi virAjate sa eva sarvvakarmmANi karAti| ");
INSERT INTO sanitr_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ataeva pitaryyahaM tiShThAmi pitA cha mayi tiShThati mamAsyAM kathAyAM pratyayaM kuruta, no chet karmmahetoH pratyayaM kuruta| ");
INSERT INTO sanitr_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","ahaM yuShmAnatiyathArthaM vadAmi, yo jano mayi vishvasiti sohamiva karmmANi kariShyati varaM tatopi mahAkarmmANi kariShyati yato hetorahaM pituH samIpaM gachChAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","yathA putreNa pitu rmahimA prakAshate tadarthaM mama nAma prochya yat prArthayiShyadhve tat saphalaM kariShyAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","yadi mama nAmnA yat ki nchid yAchadhve tarhi tadahaM sAdhayiShyAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","yadi mayi prIyadhve tarhi mamAj nAH samAcharata| ");
INSERT INTO sanitr_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","tato mayA pituH samIpe prArthite pitA nirantaraM yuShmAbhiH sArddhaM sthAtum itaramekaM sahAyam arthAt satyamayam AtmAnaM yuShmAkaM nikaTaM preShayiShyati| ");
INSERT INTO sanitr_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","etajjagato lokAstaM grahItuM na shaknuvanti yataste taM nApashyan nAjanaMshcha kintu yUyaM jAnItha yato hetoH sa yuShmAkamanta rnivasati yuShmAkaM madhye sthAsyati cha| ");
INSERT INTO sanitr_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","ahaM yuShmAn anAthAn kR^itvA na yAsyAmi punarapi yuShmAkaM samIpam AgamiShyAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","kiyatkAlarat param asya jagato lokA mAM puna rna drakShyanti kintu yUyaM drakShyatha;ahaM jIviShyAmi tasmAt kAraNAd yUyamapi jIviShyatha| ");
INSERT INTO sanitr_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","pitaryyahamasmi mayi cha yUyaM stha, tathAhaM yuShmAsvasmi tadapi tadA j nAsyatha| ");
INSERT INTO sanitr_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","yo jano mamAj nA gR^ihItvA tA Acharati saeva mayi prIyate; yo janashcha mayi prIyate saeva mama pituH priyapAtraM bhaviShyati, tathAhamapi tasmin prItvA tasmai svaM prakAshayiShyAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","tadA IShkariyotIyAd anyo yihUdAstamavadat, he prabho bhavAn jagato lokAnAM sannidhau prakAshito na bhUtvAsmAkaM sannidhau kutaH prakAshito bhaviShyati? ");
INSERT INTO sanitr_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","tato yIshuH pratyuditavAn, yo jano mayi prIyate sa mamAj nA api gR^ihlAti, tena mama pitApi tasmin preShyate, AvA ncha tannikaTamAgatya tena saha nivatsyAvaH| ");
INSERT INTO sanitr_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","yo jano mayi na prIyate sa mama kathA api na gR^ihlAti punashcha yAmimAM kathAM yUyaM shR^iNutha sA kathA kevalasya mama na kintu mama prerako yaH pitA tasyApi kathA| ");
INSERT INTO sanitr_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","idAnIM yuShmAkaM nikaTe vidyamAnoham etAH sakalAH kathAH kathayAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","kintvitaH paraM pitrA yaH sahAyo.arthAt pavitra AtmA mama nAmni prerayiShyati sa sarvvaM shikShayitvA mayoktAH samastAH kathA yuShmAn smArayiShyati| ");
INSERT INTO sanitr_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","ahaM yuShmAkaM nikaTe shAntiM sthApayitvA yAmi, nijAM shAntiM yuShmabhyaM dadAmi, jagato lokA yathA dadAti tathAhaM na dadAmi; yuShmAkam antaHkaraNAni duHkhitAni bhItAni cha na bhavantu| ");
INSERT INTO sanitr_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","ahaM gatvA punarapi yuShmAkaM samIpam AgamiShyAmi mayoktaM vAkyamidaM yUyam ashrauShTa; yadi mayyapreShyadhvaM tarhyahaM pituH samIpaM gachChAmi mamAsyAM kathAyAM yUyam ahlAdiShyadhvaM yato mama pitA mattopi mahAn| ");
INSERT INTO sanitr_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","tasyA ghaTanAyAH samaye yathA yuShmAkaM shraddhA jAyate tadartham ahaM tasyA ghaTanAyAH pUrvvam idAnIM yuShmAn etAM vArttAM vadAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","itaH paraM yuShmAbhiH saha mama bahava AlApA na bhaviShyanti yataH kAraNAd etasya jagataH patirAgachChati kintu mayA saha tasya kopi sambandho nAsti| ");
INSERT INTO sanitr_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ahaM pitari prema karomi tathA pitu rvidhivat karmmANi karomIti yena jagato lokA jAnanti tadartham uttiShThata vayaM sthAnAdasmAd gachChAma| ");
INSERT INTO sanitr_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","ahaM satyadrAkShAlatAsvarUpo mama pitA tUdyAnaparichArakasvarUpa ncha| ");
INSERT INTO sanitr_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","mama yAsu shAkhAsu phalAni na bhavanti tAH sa Chinatti tathA phalavatyaH shAkhA yathAdhikaphalAni phalanti tadarthaM tAH pariShkaroti| ");
INSERT INTO sanitr_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","idAnIM mayoktopadeshena yUyaM pariShkR^itAH| ");
INSERT INTO sanitr_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ataH kAraNAt mayi tiShThata tenAhamapi yuShmAsu tiShThAmi, yato heto rdrAkShAlatAyAm asaMlagnA shAkhA yathA phalavatI bhavituM na shaknoti tathA yUyamapi mayyatiShThantaH phalavanto bhavituM na shaknutha| ");
INSERT INTO sanitr_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","ahaM drAkShAlatAsvarUpo yUya ncha shAkhAsvarUpoH; yo jano mayi tiShThati yatra chAhaM tiShThAmi, sa prachUraphalaiH phalavAn bhavati, kintu mAM vinA yUyaM kimapi karttuM na shaknutha| ");
INSERT INTO sanitr_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","yaH kashchin mayi na tiShThati sa shuShkashAkheva bahi rnikShipyate lokAshcha tA AhR^itya vahnau nikShipya dAhayanti| ");
INSERT INTO sanitr_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","yadi yUyaM mayi tiShThatha mama kathA cha yuShmAsu tiShThati tarhi yad vA nChitvA yAchiShyadhve yuShmAkaM tadeva saphalaM bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","yadi yUyaM prachUraphalavanto bhavatha tarhi tadvArA mama pitu rmahimA prakAshiShyate tathA yUyaM mama shiShyA iti parikShAyiShyadhve| ");
INSERT INTO sanitr_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","pitA yathA mayi prItavAn ahamapi yuShmAsu tathA prItavAn ato heto ryUyaM nirantaraM mama premapAtrANi bhUtvA tiShThata| ");
INSERT INTO sanitr_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ahaM yathA piturAj nA gR^ihItvA tasya premabhAjanaM tiShThAmi tathaiva yUyamapi yadi mamAj nA guhlItha tarhi mama premabhAjanAni sthAsyatha| ");
INSERT INTO sanitr_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","yuShmannimittaM mama ya AhlAdaH sa yathA chiraM tiShThati yuShmAkam Anandashcha yathA pUryyate tadarthaM yuShmabhyam etAH kathA atrakatham| ");
INSERT INTO sanitr_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","ahaM yuShmAsu yathA prIye yUyamapi parasparaM tathA prIyadhvam eShA mamAj nA| ");
INSERT INTO sanitr_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","mitrANAM kAraNAt svaprANadAnaparyyantaM yat prema tasmAn mahAprema kasyApi nAsti| ");
INSERT INTO sanitr_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","ahaM yadyad AdishAmi tattadeva yadi yUyam Acharata tarhi yUyameva mama mitrANi| ");
INSERT INTO sanitr_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","adyArabhya yuShmAn dAsAn na vadiShyAmi yat prabhu ryat karoti dAsastad na jAnAti; kintu pituH samIpe yadyad ashR^iNavaM tat sarvvaM yUShmAn aj nApayam tatkAraNAd yuShmAn mitrANi proktavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","yUyaM mAM rochitavanta iti na, kintvahameva yuShmAn rochitavAn yUyaM gatvA yathA phalAnyutpAdayatha tAni phalAni chAkShayANi bhavanti, tadarthaM yuShmAn nyajunajaM tasmAn mama nAma prochya pitaraM yat ki nchid yAchiShyadhve tadeva sa yuShmabhyaM dAsyati| ");
INSERT INTO sanitr_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","yUyaM parasparaM prIyadhvam aham ityAj nApayAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","jagato lokai ryuShmAsu R^itIyiteShu te pUrvvaM mAmevArttIyanta iti yUyaM jAnItha| ");
INSERT INTO sanitr_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","yadi yUyaM jagato lokA abhaviShyata tarhi jagato lokA yuShmAn AtmIyAn buddhvApreShyanta; kintu yUyaM jagato lokA na bhavatha, ahaM yuShmAn asmAjjagato.arochayam etasmAt kAraNAjjagato lokA yuShmAn R^itIyante| ");
INSERT INTO sanitr_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","dAsaH prabho rmahAn na bhavati mamaitat pUrvvIyaM vAkyaM smarata; te yadi mAmevAtADayan tarhi yuShmAnapi tADayiShyanti, yadi mama vAkyaM gR^ihlanti tarhi yuShmAkamapi vAkyaM grahIShyanti| ");
INSERT INTO sanitr_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","kintu te mama nAmakAraNAd yuShmAn prati tAdR^ishaM vyavahariShyanti yato yo mAM preritavAn taM te na jAnanti| ");
INSERT INTO sanitr_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","teShAM sannidhim Agatya yadyahaM nAkathayiShyaM tarhi teShAM pApaM nAbhaviShyat kintvadhunA teShAM pApamAchChAdayitum upAyo nAsti| ");
INSERT INTO sanitr_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","yo jano mAm R^itIyate sa mama pitaramapi R^itIyate| ");
INSERT INTO sanitr_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","yAdR^ishAni karmmANi kenApi kadApi nAkriyanta tAdR^ishAni karmmANi yadi teShAM sAkShAd ahaM nAkariShyaM tarhi teShAM pApaM nAbhaviShyat kintvadhunA te dR^iShTvApi mAM mama pitara nchArttIyanta| ");
INSERT INTO sanitr_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","tasmAt te.akAraNaM mAm R^itIyante yadetad vachanaM teShAM shAstre likhitamAste tat saphalam abhavat| ");
INSERT INTO sanitr_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","kintu pitu rnirgataM yaM sahAyamarthAt satyamayam AtmAnaM pituH samIpAd yuShmAkaM samIpe preShayiShyAmi sa Agatya mayi pramANaM dAsyati| ");
INSERT INTO sanitr_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","yUyaM prathamamArabhya mayA sArddhaM tiShThatha tasmAddheto ryUyamapi pramANaM dAsyatha| ");
INSERT INTO sanitr_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","yuShmAkaM yathA vAdhA na jAyate tadarthaM yuShmAn etAni sarvvavAkyAni vyAharaM| ");
INSERT INTO sanitr_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","lokA yuShmAn bhajanagR^ihebhyo dUrIkariShyanti tathA yasmin samaye yuShmAn hatvA Ishvarasya tuShTi janakaM karmmAkurmma iti maMsyante sa samaya AgachChanti| ");
INSERT INTO sanitr_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","te pitaraM mA ncha na jAnanti, tasmAd yuShmAn pratIdR^isham AchariShyanti| ");
INSERT INTO sanitr_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","ato hetAH samaye samupasthite yathA mama kathA yuShmAkaM manaHsuH samupatiShThati tadarthaM yuShmAbhyam etAM kathAM kathayAmi yuShmAbhiH sArddham ahaM tiShThan prathamaM tAM yuShmabhyaM nAkathayaM| ");
INSERT INTO sanitr_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","sAmprataM svasya prerayituH samIpaM gachChAmi tathApi tvaM kka gachChasi kathAmetAM yuShmAkaM kopi mAM na pR^ichChati| ");
INSERT INTO sanitr_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","kintu mayoktAbhirAbhiH kathAbhi ryUShmAkam antaHkaraNAni duHkhena pUrNAnyabhavan| ");
INSERT INTO sanitr_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","tathApyahaM yathArthaM kathayAmi mama gamanaM yuShmAkaM hitArthameva, yato heto rgamane na kR^ite sahAyo yuShmAkaM samIpaM nAgamiShyati kintu yadi gachChAmi tarhi yuShmAkaM samIpe taM preShayiShyAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","tataH sa Agatya pApapuNyadaNDeShu jagato lokAnAM prabodhaM janayiShyati| ");
INSERT INTO sanitr_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","te mayi na vishvasanti tasmAddhetoH pApaprabodhaM janayiShyati| ");
INSERT INTO sanitr_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","yuShmAkam adR^ishyaH sannahaM pituH samIpaM gachChAmi tasmAd puNye prabodhaM janayiShyati| ");
INSERT INTO sanitr_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","etajjagato.adhipati rdaNDAj nAM prApnoti tasmAd daNDe prabodhaM janayiShyati| ");
INSERT INTO sanitr_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","yuShmabhyaM kathayituM mamAnekAH kathA Asate, tAH kathA idAnIM yUyaM soDhuM na shaknutha; ");
INSERT INTO sanitr_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","kintu satyamaya AtmA yadA samAgamiShyati tadA sarvvaM satyaM yuShmAn neShyati, sa svataH kimapi na vadiShyati kintu yachChroShyati tadeva kathayitvA bhAvikAryyaM yuShmAn j nApayiShyati| ");
INSERT INTO sanitr_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","mama mahimAnaM prakAshayiShyati yato madIyAM kathAM gR^ihItvA yuShmAn bodhayiShyati| ");
INSERT INTO sanitr_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","pitu ryadyad Aste tat sarvvaM mama tasmAd kAraNAd avAdiShaM sa madIyAM kathAM gR^ihItvA yuShmAn bodhayiShyati| ");
INSERT INTO sanitr_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","kiyatkAlAt paraM yUyaM mAM draShTuM na lapsyadhve kintu kiyatkAlAt paraM puna rdraShTuM lapsyadhve yatohaM pituH samIpaM gachChAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","tataH shiShyANAM kiyanto janAH parasparaM vaditum Arabhanta, kiyatkAlAt paraM mAM draShTuM na lapsyadhve kintu kiyatkAlAt paraM puna rdraShTuM lapsyadhve yatohaM pituH samIpaM gachChAmi, iti yad vAkyam ayaM vadati tat kiM? ");
INSERT INTO sanitr_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","tataH kiyatkAlAt param iti tasya vAkyaM kiM? tasya vAkyasyAbhiprAyaM vayaM boddhuM na shaknumastairiti ");
INSERT INTO sanitr_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","nigadite yIshusteShAM prashnechChAM j nAtvA tebhyo.akathayat kiyatkAlAt paraM mAM draShTuM na lapsyadhve, kintu kiyatkAlAt paraM pUna rdraShTuM lapsyadhve, yAmimAM kathAmakathayaM tasyA abhiprAyaM kiM yUyaM parasparaM mR^igayadhve? ");
INSERT INTO sanitr_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","yuShmAnaham atiyathArthaM vadAmi yUyaM krandiShyatha vilapiShyatha cha, kintu jagato lokA AnandiShyanti; yUyaM shokAkulA bhaviShyatha kintu shokAt paraM AnandayuktA bhaviShyatha| ");
INSERT INTO sanitr_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","prasavakAla upasthite nArI yathA prasavavedanayA vyAkulA bhavati kintu putre bhUmiShThe sati manuShyaiko janmanA naraloke praviShTa ityAnandAt tasyAstatsarvvaM duHkhaM manasi na tiShThati, ");
INSERT INTO sanitr_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","tathA yUyamapi sAmprataM shokAkulA bhavatha kintu punarapi yuShmabhyaM darshanaM dAsyAmi tena yuShmAkam antaHkaraNAni sAnandAni bhaviShyanti, yuShmAkaM tam Ananda ncha kopi harttuM na shakShyati| ");
INSERT INTO sanitr_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","tasmin divase kAmapi kathAM mAM na prakShyatha| yuShmAnaham atiyathArthaM vadAmi, mama nAmnA yat ki nchid pitaraM yAchiShyadhve tadeva sa dAsyati| ");
INSERT INTO sanitr_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","pUrvve mama nAmnA kimapi nAyAchadhvaM, yAchadhvaM tataH prApsyatha tasmAd yuShmAkaM sampUrNAnando janiShyate| ");
INSERT INTO sanitr_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","upamAkathAbhiH sarvvANyetAni yuShmAn j nApitavAn kintu yasmin samaye upamayA noktvA pituH kathAM spaShTaM j nApayiShyAmi samaya etAdR^isha AgachChati| ");
INSERT INTO sanitr_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","tadA mama nAmnA prArthayiShyadhve .ahaM yuShmannimittaM pitaraM vineShye kathAmimAM na vadAmi; ");
INSERT INTO sanitr_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","yato yUyaM mayi prema kurutha, tathAham Ishvarasya samIpAd AgatavAn ityapi pratItha, tasmAd kAraNAt kAraNAt pitA svayaM yuShmAsu prIyate| ");
INSERT INTO sanitr_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","pituH samIpAjjajad Agatosmi jagat parityajya cha punarapi pituH samIpaM gachChAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","tadA shiShyA avadan, he prabho bhavAn upamayA noktvAdhunA spaShTaM vadati| ");
INSERT INTO sanitr_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","bhavAn sarvvaj naH kenachit pR^iShTo bhavitumapi bhavataH prayojanaM nAstItyadhunAsmAkaM sthiraj nAnaM jAtaM tasmAd bhavAn Ishvarasya samIpAd AgatavAn ityatra vayaM vishvasimaH| ");
INSERT INTO sanitr_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","tato yIshuH pratyavAdId idAnIM kiM yUyaM vishvasitha? ");
INSERT INTO sanitr_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","pashyata sarvve yUyaM vikIrNAH santo mAm ekAkinaM pIratyajya svaM svaM sthAnaM gamiShyatha, etAdR^ishaH samaya AgachChati varaM prAyeNopasthitavAn; tathApyahaM naikAkI bhavAmi yataH pitA mayA sArddham Aste| ");
INSERT INTO sanitr_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","yathA mayA yuShmAkaM shAnti rjAyate tadartham etAH kathA yuShmabhyam achakathaM; asmin jagati yuShmAkaM klesho ghaTiShyate kintvakShobhA bhavata yato mayA jagajjitaM| ");
INSERT INTO sanitr_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","tataH paraM yIshuretAH kathAH kathayitvA svargaM vilokyaitat prArthayat, he pitaH samaya upasthitavAn; yathA tava putrastava mahimAnaM prakAshayati tadarthaM tvaM nijaputrasya mahimAnaM prakAshaya| ");
INSERT INTO sanitr_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","tvaM yollokAn tasya haste samarpitavAn sa yathA tebhyo.anantAyu rdadAti tadarthaM tvaM prANimAtrANAm adhipatitvabhAraM tasmai dattavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","yastvam advitIyaH satya IshvarastvayA preritashcha yIshuH khrIShTa etayorubhayoH parichaye prApte.anantAyu rbhavati| ");
INSERT INTO sanitr_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","tvaM yasya karmmaNo bhAraM mahyaM dattavAn, tat sampannaM kR^itvA jagatyasmin tava mahimAnaM prAkAshayaM| ");
INSERT INTO sanitr_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ataeva he pita rjagatyavidyamAne tvayA saha tiShThato mama yo mahimAsIt samprati tava samIpe mAM taM mahimAnaM prApaya| ");
INSERT INTO sanitr_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","anyachcha tvam etajjagato yAllokAn mahyam adadA ahaM tebhyastava nAmnastattvaj nAnam adadAM, te tavaivAsan, tvaM tAn mahyamadadAH, tasmAtte tavopadesham agR^ihlan| ");
INSERT INTO sanitr_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","tvaM mahyaM yat ki nchid adadAstatsarvvaM tvatto jAyate ityadhunAjAnan| ");
INSERT INTO sanitr_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","mahyaM yamupadesham adadA ahamapi tebhyastamupadesham adadAM tepi tamagR^ihlan tvattohaM nirgatya tvayA preritobhavam atra cha vyashvasan| ");
INSERT INTO sanitr_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","teShAmeva nimittaM prArthaye.ahaM jagato lokanimittaM na prArthaye kintu yAllokAn mahyam adadAsteShAmeva nimittaM prArthaye.ahaM yataste tavaivAsate| ");
INSERT INTO sanitr_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ye mama te tava ye cha tava te mama tathA tai rmama mahimA prakAshyate| ");
INSERT INTO sanitr_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","sAmpratam asmin jagati mamAvasthiteH sheSham abhavat ahaM tava samIpaM gachChAmi kintu te jagati sthAsyanti; he pavitra pitarAvayo ryathaikatvamAste tathA teShAmapyekatvaM bhavati tadarthaM yAllokAn mahyam adadAstAn svanAmnA rakSha| ");
INSERT INTO sanitr_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","yAvanti dinAni jagatyasmin taiH sahAhamAsaM tAvanti dinAni tAn tava nAmnAhaM rakShitavAn; yAllokAn mahyam adadAstAn sarvvAn ahamarakShaM, teShAM madhye kevalaM vinAshapAtraM hAritaM tena dharmmapustakasya vachanaM pratyakShaM bhavati| ");
INSERT INTO sanitr_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","kintvadhunA tava sannidhiM gachChAmi mayA yathA teShAM sampUrNAnando bhavati tadarthamahaM jagati tiShThan etAH kathA akathayam| ");
INSERT INTO sanitr_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","tavopadeshaM tebhyo.adadAM jagatA saha yathA mama sambandho nAsti tathA jajatA saha teShAmapi sambandhAbhAvAj jagato lokAstAn R^itIyante| ");
INSERT INTO sanitr_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","tvaM jagatastAn gR^ihANeti na prArthaye kintvashubhAd rakSheti prArthayeham| ");
INSERT INTO sanitr_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ahaM yathA jagatsambandhIyo na bhavAmi tathA tepi jagatsambandhIyA na bhavanti| ");
INSERT INTO sanitr_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","tava satyakathayA tAn pavitrIkuru tava vAkyameva satyaM| ");
INSERT INTO sanitr_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","tvaM yathA mAM jagati prairayastathAhamapi tAn jagati prairayaM| ");
INSERT INTO sanitr_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","teShAM hitArthaM yathAhaM svaM pavitrIkaromi tathA satyakathayA tepi pavitrIbhavantu| ");
INSERT INTO sanitr_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","kevalaM eteShAmarthe prArthaye.aham iti na kintveteShAmupadeshena ye janA mayi vishvasiShyanti teShAmapyarthe prArtheye.aham| ");
INSERT INTO sanitr_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","he pitasteShAM sarvveShAm ekatvaM bhavatu tava yathA mayi mama cha yathA tvayyekatvaM tathA teShAmapyAvayorekatvaM bhavatu tena tvaM mAM preritavAn iti jagato lokAH pratiyantu| ");
INSERT INTO sanitr_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","yathAvayorekatvaM tathA teShAmapyekatvaM bhavatu teShvahaM mayi cha tvam itthaM teShAM sampUrNamekatvaM bhavatu, tvaM preritavAn tvaM mayi yathA prIyase cha tathA teShvapi prItavAn etadyathA jagato lokA jAnanti ");
INSERT INTO sanitr_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","tadarthaM tvaM yaM mahimAnaM mahyam adadAstaM mahimAnam ahamapi tebhyo dattavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","he pita rjagato nirmmANAt pUrvvaM mayi snehaM kR^itvA yaM mahimAnaM dattavAn mama taM mahimAnaM yathA te pashyanti tadarthaM yAllokAn mahyaM dattavAn ahaM yatra tiShThAmi tepi yathA tatra tiShThanti mamaiShA vA nChA| ");
INSERT INTO sanitr_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","he yathArthika pita rjagato lokaistvayyaj nAtepi tvAmahaM jAne tvaM mAM preritavAn itIme shiShyA jAnanti| ");
INSERT INTO sanitr_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","yathAhaM teShu tiShThAmi tathA mayi yena premnA premAkarostat teShu tiShThati tadarthaM tava nAmAhaM tAn j nApitavAn punarapi j nApayiShyAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","tAH kathAH kathayitvA yIshuH shiShyAnAdAya kidronnAmakaM srota uttIryya shiShyaiH saha tatratyodyAnaM prAvishat| ");
INSERT INTO sanitr_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","kintu vishvAsaghAtiyihUdAstat sthAnaM parichIyate yato yIshuH shiShyaiH sArddhaM kadAchit tat sthAnam agachChat| ");
INSERT INTO sanitr_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","tadA sa yihUdAH sainyagaNaM pradhAnayAjakAnAM phirUshinA ncha padAtigaNa ncha gR^ihItvA pradIpAn ulkAn astrANi chAdAya tasmin sthAna upasthitavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","svaM prati yad ghaTiShyate taj j nAtvA yIshuragresaraH san tAnapR^ichChat kaM gaveShayatha? ");
INSERT INTO sanitr_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","te pratyavadan, nAsaratIyaM yIshuM; tato yIshuravAdId ahameva saH; taiH saha vishvAsaghAtI yihUdAshchAtiShThat| ");
INSERT INTO sanitr_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","tadAhameva sa tasyaitAM kathAM shrutvaiva te pashchAdetya bhUmau patitAH| ");
INSERT INTO sanitr_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","tato yIshuH punarapi pR^iShThavAn kaM gaveShayatha? tataste pratyavadan nAsaratIyaM yIshuM| ");
INSERT INTO sanitr_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","tadA yIshuH pratyuditavAn ahameva sa imAM kathAmachakatham; yadi mAmanvichChatha tarhImAn gantuM mA vArayata| ");
INSERT INTO sanitr_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","itthaM bhUte mahyaM yAllokAn adadAsteShAm ekamapi nAhArayam imAM yAM kathAM sa svayamakathayat sA kathA saphalA jAtA| ");
INSERT INTO sanitr_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","tadA shimonpitarasya nikaTe kha NgalsthiteH sa taM niShkoShaM kR^itvA mahAyAjakasya mAlkhanAmAnaM dAsam Ahatya tasya dakShiNakarNaM ChinnavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","tato yIshuH pitaram avadat, kha NgaM koShe sthApaya mama pitA mahyaM pAtuM yaM kaMsam adadAt tenAhaM kiM na pAsyAmi? ");
INSERT INTO sanitr_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","tadA sainyagaNaH senApati ryihUdIyAnAM padAtayashcha yIshuM ghR^itvA baddhvA hAnannAmnaH kiyaphAH shvashurasya samIpaM prathamam anayan| ");
INSERT INTO sanitr_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","sa kiyaphAstasmin vatsare mahAyAjatvapade niyuktaH ");
INSERT INTO sanitr_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","san sAdhAraNalokAnAM ma NgalArtham ekajanasya maraNamuchitam iti yihUdIyaiH sArddham amantrayat| ");
INSERT INTO sanitr_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","tadA shimonpitaro.anyaikashiShyashcha yIshoH pashchAd agachChatAM tasyAnyashiShyasya mahAyAjakena parichitatvAt sa yIshunA saha mahAyAjakasyATTAlikAM prAvishat| ");
INSERT INTO sanitr_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","kintu pitaro bahirdvArasya samIpe.atiShThad ataeva mahAyAjakena parichitaH sa shiShyaH punarbahirgatvA dauvAyikAyai kathayitvA pitaram abhyantaram Anayat| ");
INSERT INTO sanitr_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","tadA sa dvArarakShikA pitaram avadat tvaM kiM na tasya mAnavasya shiShyaH? tataH sovadad ahaM na bhavAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","tataH paraM yatsthAne dAsAH padAtayashcha shItahetora NgArai rvahniM prajvAlya tApaM sevitavantastatsthAne pitarastiShThan taiH saha vahnitApaM sevitum Arabhata| ");
INSERT INTO sanitr_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","tadA shiShyeShUpadeshe cha mahAyAjakena yIshuH pR^iShTaH ");
INSERT INTO sanitr_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","san pratyuktavAn sarvvalokAnAM samakShaM kathAmakathayaM guptaM kAmapi kathAM na kathayitvA yat sthAnaM yihUdIyAH satataM gachChanti tatra bhajanagehe mandire chAshikShayaM| ");
INSERT INTO sanitr_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","mattaH kutaH pR^ichChasi? ye janA madupadesham ashR^iNvan tAneva pR^ichCha yadyad avadaM te tat jAninta| ");
INSERT INTO sanitr_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","tadetthaM pratyuditatvAt nikaTasthapadAti ryIshuM chapeTenAhatya vyAharat mahAyAjakam evaM prativadasi? ");
INSERT INTO sanitr_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","tato yIshuH pratigaditavAn yadyayathArtham achakathaM tarhi tasyAyathArthasya pramANaM dehi, kintu yadi yathArthaM tarhi kuto heto rmAm atADayaH? ");
INSERT INTO sanitr_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","pUrvvaM hAnan sabandhanaM taM kiyaphAmahAyAjakasya samIpaM praiShayat| ");
INSERT INTO sanitr_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","shimonpitarastiShThan vahnitApaM sevate, etasmin samaye kiyantastam apR^ichChan tvaM kim etasya janasya shiShyo na? tataH sopahnutyAbravId ahaM na bhavAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","tadA mahAyAjakasya yasya dAsasya pitaraH karNamachChinat tasya kuTumbaH pratyuditavAn udyAne tena saha tiShThantaM tvAM kiM nApashyaM? ");
INSERT INTO sanitr_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","kintu pitaraH punarapahnutya kathitavAn; tadAnIM kukkuTo.araut| ");
INSERT INTO sanitr_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","tadanantaraM pratyUShe te kiyaphAgR^ihAd adhipate rgR^ihaM yIshum anayan kintu yasmin ashuchitve jAte tai rnistArotsave na bhoktavyaM, tasya bhayAd yihUdIyAstadgR^ihaM nAvishan| ");
INSERT INTO sanitr_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","aparaM pIlAto bahirAgatya tAn pR^iShThavAn etasya manuShyasya kaM doShaM vadatha? ");
INSERT INTO sanitr_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","tadA te petyavadan duShkarmmakAriNi na sati bhavataH samIpe nainaM samArpayiShyAmaH| ");
INSERT INTO sanitr_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","tataH pIlAto.avadad yUyamenaM gR^ihItvA sveShAM vyavasthayA vichArayata| tadA yihUdIyAH pratyavadan kasyApi manuShyasya prANadaNDaM karttuM nAsmAkam adhikAro.asti| ");
INSERT INTO sanitr_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","evaM sati yIshuH svasya mR^ityau yAM kathAM kathitavAn sA saphalAbhavat| ");
INSERT INTO sanitr_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","tadanantaraM pIlAtaH punarapi tad rAjagR^ihaM gatvA yIshumAhUya pR^iShTavAn tvaM kiM yihUdIyAnAM rAjA? ");
INSERT INTO sanitr_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","yIshuH pratyavadat tvam etAM kathAM svataH kathayasi kimanyaH kashchin mayi kathitavAn? ");
INSERT INTO sanitr_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","pIlAto.avadad ahaM kiM yihUdIyaH? tava svadeshIyA visheShataH pradhAnayAjakA mama nikaTe tvAM samArpayana, tvaM kiM kR^itavAn? ");
INSERT INTO sanitr_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","yIshuH pratyavadat mama rAjyam etajjagatsambandhIyaM na bhavati yadi mama rAjyaM jagatsambandhIyam abhaviShyat tarhi yihUdIyAnAM hasteShu yathA samarpito nAbhavaM tadarthaM mama sevakA ayotsyan kintu mama rAjyam aihikaM na| ");
INSERT INTO sanitr_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","tadA pIlAtaH kathitavAn, tarhi tvaM rAjA bhavasi? yIshuH pratyuktavAn tvaM satyaM kathayasi, rAjAhaM bhavAmi; satyatAyAM sAkShyaM dAtuM janiM gR^ihItvA jagatyasmin avatIrNavAn, tasmAt satyadharmmapakShapAtino mama kathAM shR^iNvanti| ");
INSERT INTO sanitr_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","tadA satyaM kiM? etAM kathAM paShTvA pIlAtaH punarapi bahirgatvA yihUdIyAn abhAShata, ahaM tasya kamapyaparAdhaM na prApnomi| ");
INSERT INTO sanitr_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","nistArotsavasamaye yuShmAbhirabhiruchita eko jano mayA mochayitavya eShA yuShmAkaM rItirasti, ataeva yuShmAkaM nikaTe yihUdIyAnAM rAjAnaM kiM mochayAmi, yuShmAkam ichChA kA? ");
INSERT INTO sanitr_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","tadA te sarvve ruvanto vyAharan enaM mAnuShaM nahi barabbAM mochaya| kintu sa barabbA dasyurAsIt| ");
INSERT INTO sanitr_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","pIlAto yIshum AnIya kashayA prAhArayat| ");
INSERT INTO sanitr_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","pashchAt senAgaNaH kaNTakanirmmitaM mukuTaM tasya mastake samarpya vArttAkIvarNaM rAjaparichChadaM paridhApya, ");
INSERT INTO sanitr_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","he yihUdIyAnAM rAjan namaskAra ityuktvA taM chapeTenAhantum Arabhata| ");
INSERT INTO sanitr_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","tadA pIlAtaH punarapi bahirgatvA lokAn avadat, asya kamapyaparAdhaM na labhe.ahaM, pashyata tad yuShmAn j nApayituM yuShmAkaM sannidhau bahirenam AnayAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","tataH paraM yIshuH kaNTakamukuTavAn vArttAkIvarNavasanavAMshcha bahirAgachChat| tataH pIlAta uktavAn enaM manuShyaM pashyata| ");
INSERT INTO sanitr_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","tadA pradhAnayAjakAH padAtayashcha taM dR^iShTvA, enaM krushe vidha, enaM krushe vidha, ityuktvA ravituM Arabhanta| tataH pIlAtaH kathitavAn yUyaM svayam enaM nItvA krushe vidhata, aham etasya kamapyaparAdhaM na prAptavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","yihUdIyAH pratyavadan asmAkaM yA vyavasthAste tadanusAreNAsya prANahananam uchitaM yatoyaM svam Ishvarasya putramavadat| ");
INSERT INTO sanitr_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","pIlAta imAM kathAM shrutvA mahAtrAsayuktaH ");
INSERT INTO sanitr_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","san punarapi rAjagR^iha Agatya yIshuM pR^iShTavAn tvaM kutratyo lokaH? kintu yIshastasya kimapi pratyuttaraM nAvadat| ");
INSERT INTO sanitr_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","1# tataH pIlAt kathitavAna tvaM kiM mayA sArddhaM na saMlapiShyasi ? tvAM krushe vedhituM vA mochayituM shakti rmamAste iti kiM tvaM na jAnAsi ? tadA yIshuH pratyavadad IshvareNAdaŸाM mamopari tava kimapyadhipatitvaM na vidyate, tathApi yo jano mAM tava haste samArpayat tasya mahApAtakaM jAtam| ");
INSERT INTO sanitr_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","tadA yIshuH pratyavadad IshvareNAdattaM mamopari tava kimapyadhipatitvaM na vidyate, tathApi yo jano mAM tava haste samArpayat tasya mahApAtakaM jAtam| ");
INSERT INTO sanitr_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","tadArabhya pIlAtastaM mochayituM cheShTitavAn kintu yihUdIyA ruvanto vyAharan yadImaM mAnavaM tyajasi tarhi tvaM kaisarasya mitraM na bhavasi, yo janaH svaM rAjAnaM vakti saeva kaimarasya viruddhAM kathAM kathayati| ");
INSERT INTO sanitr_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","etAM kathAM shrutvA pIlAto yIshuM bahirAnIya nistArotsavasya AsAdanadinasya dvitIyapraharAt pUrvvaM prastarabandhananAmni sthAne .arthAt ibrIyabhAShayA yad gabbithA kathyate tasmin sthAne vichArAsana upAvishat| ");
INSERT INTO sanitr_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","anantaraM pIlAto yihUdIyAn avadat, yuShmAkaM rAjAnaM pashyata| ");
INSERT INTO sanitr_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","kintu enaM dUrIkuru, enaM dUrIkuru, enaM krushe vidha, iti kathAM kathayitvA te ravitum Arabhanta; tadA pIlAtaH kathitavAn yuShmAkaM rAjAnaM kiM krushe vedhiShyAmi? pradhAnayAjakA uttaram avadan kaisaraM vinA kopi rAjAsmAkaM nAsti| ");
INSERT INTO sanitr_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","tataH pIlAto yIshuM krushe vedhituM teShAM hasteShu samArpayat, tataste taM dhR^itvA nItavantaH| ");
INSERT INTO sanitr_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","tataH paraM yIshuH krushaM vahan shiraHkapAlam arthAd yad ibrIyabhAShayA gulgaltAM vadanti tasmin sthAna upasthitaH| ");
INSERT INTO sanitr_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","tataste madhyasthAne taM tasyobhayapArshve dvAvaparau krushe.avidhan| ");
INSERT INTO sanitr_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","aparam eSha yihUdIyAnAM rAjA nAsaratIyayIshuH, iti vij nApanaM likhitvA pIlAtastasya krushopari samayojayat| ");
INSERT INTO sanitr_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","sA lipiH ibrIyayUnAnIyaromIyabhAShAbhi rlikhitA; yIshoH krushavedhanasthAnaM nagarasya samIpaM, tasmAd bahavo yihUdIyAstAM paThitum Arabhanta| ");
INSERT INTO sanitr_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","yihUdIyAnAM pradhAnayAjakAH pIlAtamiti nyavedayan yihUdIyAnAM rAjeti vAkyaM na kintu eSha svaM yihUdIyAnAM rAjAnam avadad itthaM likhatu| ");
INSERT INTO sanitr_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","tataH pIlAta uttaraM dattavAn yallekhanIyaM tallikhitavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","itthaM senAgaNo yIshuM krushe vidhitvA tasya paridheyavastraM chaturo bhAgAn kR^itvA ekaikasenA ekaikabhAgam agR^ihlat tasyottarIyavastra nchAgR^ihlat| kintUttarIyavastraM sUchisevanaM vinA sarvvam UtaM| ");
INSERT INTO sanitr_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","tasmAtte vyAharan etat kaH prApsyati? tanna khaNDayitvA tatra guTikApAtaM karavAma| vibhajante.adharIyaM me vasanaM te parasparaM| mamottarIyavastrArthaM guTikAM pAtayanti cha| iti yadvAkyaM dharmmapustake likhitamAste tat senAgaNenetthaM vyavaharaNAt siddhamabhavat| ");
INSERT INTO sanitr_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","tadAnIM yIsho rmAtA mAtu rbhaginI cha yA kliyapA bhAryyA mariyam magdalInI mariyam cha etAstasya krushasya sannidhau samatiShThan| ");
INSERT INTO sanitr_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","tato yIshuH svamAtaraM priyatamashiShya ncha samIpe daNDAyamAnau vilokya mAtaram avadat, he yoShid enaM tava putraM pashya, ");
INSERT INTO sanitr_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","shiShyantvavadat, enAM tava mAtaraM pashya| tataH sa shiShyastadghaTikAyAM tAM nijagR^ihaM nItavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","anantaraM sarvvaM karmmAdhunA sampannamabhUt yIshuriti j nAtvA dharmmapustakasya vachanaM yathA siddhaM bhavati tadartham akathayat mama pipAsA jAtA| ");
INSERT INTO sanitr_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","tatastasmin sthAne amlarasena pUrNapAtrasthityA te spa njamekaM tadamlarasenArdrIkR^itya esobnale tad yojayitvA tasya mukhasya sannidhAvasthApayan| ");
INSERT INTO sanitr_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","tadA yIshuramlarasaM gR^ihItvA sarvvaM siddham iti kathAM kathayitvA mastakaM namayan prANAn paryyatyajat| ");
INSERT INTO sanitr_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","tadvinam AsAdanadinaM tasmAt pare.ahani vishrAmavAre dehA yathA krushopari na tiShThanti, yataH sa vishrAmavAro mahAdinamAsIt, tasmAd yihUdIyAH pIlAtanikaTaM gatvA teShAM pAdabha njanasya sthAnAntaranayanasya chAnumatiM prArthayanta| ");
INSERT INTO sanitr_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ataH senA Agatya yIshunA saha krushe hatayoH prathamadvitIyachorayoH pAdAn abha njan; ");
INSERT INTO sanitr_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","kintu yIshoH sannidhiM gatvA sa mR^ita iti dR^iShTvA tasya pAdau nAbha njan| ");
INSERT INTO sanitr_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","pashchAd eko yoddhA shUlAghAtena tasya kukShim avidhat tatkShaNAt tasmAd raktaM jala ncha niragachChat| ");
INSERT INTO sanitr_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","yo jano.asya sAkShyaM dadAti sa svayaM dR^iShTavAn tasyedaM sAkShyaM satyaM tasya kathA yuShmAkaM vishvAsaM janayituM yogyA tat sa jAnAti| ");
INSERT INTO sanitr_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","tasyaikam asdhyapi na bhaMkShyate, ");
INSERT INTO sanitr_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","tadvad anyashAstrepi likhyate, yathA, \"dR^iShTipAtaM kariShyanti te.avidhan yantu tamprati|\" ");
INSERT INTO sanitr_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","arimathIyanagarasya yUShaphnAmA shiShya eka AsIt kintu yihUdIyebhyo bhayAt prakAshito na bhavati; sa yIsho rdehaM netuM pIlAtasyAnumatiM prArthayata, tataH pIlAtenAnumate sati sa gatvA yIsho rdeham anayat| ");
INSERT INTO sanitr_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","aparaM yo nikadImo rAtrau yIshoH samIpam agachChat sopi gandharasena mishritaM prAyeNa pa nchAshatseTakamaguruM gR^ihItvAgachChat| ");
INSERT INTO sanitr_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","tataste yihUdIyAnAM shmashAne sthApanarItyanusAreNa tatsugandhidravyeNa sahitaM tasya dehaM vastreNAveShTayan| ");
INSERT INTO sanitr_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","apara ncha yatra sthAne taM krushe.avidhan tasya nikaTasthodyAne yatra kimapi mR^itadehaM kadApi nAsthApyata tAdR^isham ekaM nUtanaM shmashAnam AsIt| ");
INSERT INTO sanitr_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","yihUdIyAnAm AsAdanadinAgamanAt te tasmin samIpasthashmashAne yIshum ashAyayan| ");
INSERT INTO sanitr_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","anantaraM saptAhasya prathamadine .atipratyUShe .andhakAre tiShThati magdalInI mariyam tasya shmashAnasya nikaTaM gatvA shmashAnasya mukhAt prastaramapasAritam apashyat| ");
INSERT INTO sanitr_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","pashchAd dhAvitvA shimonpitarAya yIshoH priyatamashiShyAya chedam akathayat, lokAH shmashAnAt prabhuM nItvA kutrAsthApayan tad vaktuM na shaknomi| ");
INSERT INTO sanitr_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","ataH pitaraH sonyashiShyashcha barhi rbhutvA shmashAnasthAnaM gantum ArabhetAM| ");
INSERT INTO sanitr_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ubhayordhAvatoH sonyashiShyaH pitaraM pashchAt tyaktvA pUrvvaM shmashAnasthAna upasthitavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","tadA prahvIbhUya sthApitavastrANi dR^iShTavAn kintu na prAvishat| ");
INSERT INTO sanitr_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","aparaM shimonpitara Agatya shmashAnasthAnaM pravishya ");
INSERT INTO sanitr_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","sthApitavastrANi mastakasya vastra ncha pR^ithak sthAnAntare sthApitaM dR^iShTavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","tataH shmashAnasthAnaM pUrvvam Agato yonyashiShyaH sopi pravishya tAdR^ishaM dR^iShTA vyashvasIt| ");
INSERT INTO sanitr_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","yataH shmashAnAt sa utthApayitavya etasya dharmmapustakavachanasya bhAvaM te tadA voddhuM nAshankuvan| ");
INSERT INTO sanitr_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","anantaraM tau dvau shiShyau svaM svaM gR^ihaM parAvR^ityAgachChatAm| ");
INSERT INTO sanitr_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","tataH paraM mariyam shmashAnadvArasya bahiH sthitvA roditum Arabhata tato rudatI prahvIbhUya shmashAnaM vilokya ");
INSERT INTO sanitr_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","yIshoH shayanasthAnasya shiraHsthAne padatale cha dvayo rdisho dvau svargIyadUtAvupaviShTau samapashyat| ");
INSERT INTO sanitr_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","tau pR^iShTavantau he nAri kuto rodiShi? sAvadat lokA mama prabhuM nItvA kutrAsthApayan iti na jAnAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ityuktvA mukhaM parAvR^itya yIshuM daNDAyamAnam apashyat kintu sa yIshuriti sA j nAtuM nAshaknot| ");
INSERT INTO sanitr_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","tadA yIshustAm apR^ichChat he nAri kuto rodiShi? kaM vA mR^igayase? tataH sA tam udyAnasevakaM j nAtvA vyAharat, he mahechCha tvaM yadItaH sthAnAt taM nItavAn tarhi kutrAsthApayastad vada tatsthAnAt tam AnayAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","tadA yIshustAm avadat he mariyam| tataH sA parAvR^itya pratyavadat he rabbUnI arthAt he guro| ");
INSERT INTO sanitr_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","tadA yIshuravadat mAM mA dhara, idAnIM pituH samIpe UrddhvagamanaM na karomi kintu yo mama yuShmAka ncha pitA mama yuShmAka ncheshvarastasya nikaTa UrddhvagamanaM karttum udyatosmi, imAM kathAM tvaM gatvA mama bhrAtR^igaNaM j nApaya| ");
INSERT INTO sanitr_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","tato magdalInImariyam tatkShaNAd gatvA prabhustasyai darshanaM dattvA kathA etA akathayad iti vArttAM shiShyebhyo.akathayat| ");
INSERT INTO sanitr_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","tataH paraM saptAhasya prathamadinasya sandhyAsamaye shiShyA ekatra militvA yihUdIyebhyo bhiyA dvAraruddham akurvvan, etasmin kAle yIshusteShAM madhyasthAne tiShThan akathayad yuShmAkaM kalyANaM bhUyAt| ");
INSERT INTO sanitr_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ityuktvA nijahastaM kukShi ncha darshitavAn, tataH shiShyAH prabhuM dR^iShTvA hR^iShTA abhavan| ");
INSERT INTO sanitr_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","yIshuH punaravadad yuShmAkaM kalyANaM bhUyAt pitA yathA mAM praiShayat tathAhamapi yuShmAn preShayAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ityuktvA sa teShAmupari dIrghaprashvAsaM dattvA kathitavAn pavitram AtmAnaM gR^ihlIta| ");
INSERT INTO sanitr_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","yUyaM yeShAM pApAni mochayiShyatha te mochayiShyante yeShA ncha pApAti na mochayiShyatha te na mochayiShyante| ");
INSERT INTO sanitr_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","dvAdashamadhye gaNito yamajo thomAnAmA shiShyo yIshorAgamanakAlai taiH sArddhaM nAsIt| ");
INSERT INTO sanitr_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","ato vayaM prabhUm apashyAmeti vAkye.anyashiShyairukte sovadat, tasya hastayo rlauhakIlakAnAM chihnaM na vilokya tachchihnam a NgulyA na spR^iShTvA tasya kukShau hastaM nAropya chAhaM na vishvasiShyAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","aparam aShTame.ahni gate sati thomAsahitaH shiShyagaNa ekatra militvA dvAraM ruddhvAbhyantara AsIt, etarhi yIshusteShAM madhyasthAne tiShThan akathayat, yuShmAkaM kushalaM bhUyAt| ");
INSERT INTO sanitr_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","pashchAt thAmai kathitavAn tvam a NgulIm atrArpayitvA mama karau pashya karaM prasAryya mama kukShAvarpaya nAvishvasya| ");
INSERT INTO sanitr_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","tadA thomA avadat, he mama prabho he madIshvara| ");
INSERT INTO sanitr_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","yIshurakathayat, he thomA mAM nirIkShya vishvasiShi ye na dR^iShTvA vishvasanti taeva dhanyAH| ");
INSERT INTO sanitr_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","etadanyAni pustake.asmin alikhitAni bahUnyAshcharyyakarmmANi yIshuH shiShyANAM purastAd akarot| ");
INSERT INTO sanitr_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","kintu yIshurIshvarasyAbhiShiktaH suta eveti yathA yUyaM vishvasitha vishvasya cha tasya nAmnA paramAyuH prApnutha tadartham etAni sarvvANyalikhyanta| ");
INSERT INTO sanitr_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","tataH paraM tibiriyAjaladhestaTe yIshuH punarapi shiShyebhyo darshanaM dattavAn darshanasyAkhyAnamidam| ");
INSERT INTO sanitr_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","shimonpitaraH yamajathomA gAlIlIyakAnnAnagaranivAsI nithanel sivadeH putrAvanyau dvau shiShyau chaiteShvekatra militeShu shimonpitaro.akathayat matsyAn dhartuM yAmi| ");
INSERT INTO sanitr_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","tataste vyAharan tarhi vayamapi tvayA sArddhaM yAmaH tadA te bahirgatAH santaH kShipraM nAvam Arohan kintu tasyAM rajanyAm ekamapi na prApnuvan| ");
INSERT INTO sanitr_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","prabhAte sati yIshustaTe sthitavAn kintu sa yIshuriti shiShyA j nAtuM nAshaknuvan| ");
INSERT INTO sanitr_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","tadA yIshurapR^ichChat, he vatsA sannidhau ki nchit khAdyadravyam Aste? te.avadan kimapi nAsti| ");
INSERT INTO sanitr_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","tadA so.avadat naukAyA dakShiNapArshve jAlaM nikShipata tato lapsyadhve, tasmAt tai rnikShipte jAle matsyA etAvanto.apatan yena te jAlamAkR^iShya nottolayituM shaktAH| ");
INSERT INTO sanitr_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","tasmAd yIshoH priyatamashiShyaH pitarAyAkathayat eSha prabhu rbhavet, eSha prabhuriti vAchaM shrutvaiva shimon nagnatAheto rmatsyadhAriNa uttarIyavastraM paridhAya hradaM pratyudalamphayat| ");
INSERT INTO sanitr_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","apare shiShyA matsyaiH sArddhaM jAlam AkarShantaH kShudranaukAM vAhayitvA kUlamAnayan te kUlAd atidUre nAsan dvishatahastebhyo dUra Asan ityanumIyate| ");
INSERT INTO sanitr_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","tIraM prAptaistaistatra prajvalitAgnistadupari matsyAH pUpAshcha dR^iShTAH| ");
INSERT INTO sanitr_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","tato yIshurakathayad yAn matsyAn adharata teShAM katipayAn Anayata| ");
INSERT INTO sanitr_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ataH shimonpitaraH parAvR^itya gatvA bR^ihadbhistripa nchAshadadhikashatamatsyaiH paripUrNaM tajjAlam AkR^iShyodatolayat kintvetAvadbhi rmatsyairapi jAlaM nAChidyata| ");
INSERT INTO sanitr_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","anantaraM yIshustAn avAdIt yUyamAgatya bhuMgdhvaM; tadA saeva prabhuriti j nAtatvAt tvaM kaH? iti praShTuM shiShyANAM kasyApi pragalbhatA nAbhavat| ");
INSERT INTO sanitr_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","tato yIshurAgatya pUpAn matsyAMshcha gR^ihItvA tebhyaH paryyaveShayat| ");
INSERT INTO sanitr_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","itthaM shmashAnAdutthAnAt paraM yIshuH shiShyebhyastR^itIyavAraM darshanaM dattavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","bhojane samApte sati yIshuH shimonpitaraM pR^iShTavAn, he yUnasaH putra shimon tvaM kim etebhyodhikaM mayi prIyase? tataH sa uditavAn satyaM prabho tvayi prIye.ahaM tad bhavAn jAnAti; tadA yIshurakathayat tarhi mama meShashAvakagaNaM pAlaya| ");
INSERT INTO sanitr_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","tataH sa dvitIyavAraM pR^iShTavAn he yUnasaH putra shimon tvaM kiM mayi prIyase? tataH sa uktavAn satyaM prabho tvayi prIye.ahaM tad bhavAn jAnAti; tadA yIshurakathayata tarhi mama meShagaNaM pAlaya| ");
INSERT INTO sanitr_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","pashchAt sa tR^itIyavAraM pR^iShTavAn, he yUnasaH putra shimon tvaM kiM mayi prIyase? etadvAkyaM tR^itIyavAraM pR^iShTavAn tasmAt pitaro duHkhito bhUtvA.akathayat he prabho bhavataH kimapyagocharaM nAsti tvayyahaM prIye tad bhavAn jAnAti; tato yIshuravadat tarhi mama meShagaNaM pAlaya| ");
INSERT INTO sanitr_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","ahaM tubhyaM yathArthaM kathayAmi yauvanakAle svayaM baddhakaTi ryatrechChA tatra yAtavAn kintvitaH paraM vR^iddhe vayasi hastaM vistArayiShyasi, anyajanastvAM baddhvA yatra gantuM tavechChA na bhavati tvAM dhR^itvA tatra neShyati| ");
INSERT INTO sanitr_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","phalataH kIdR^ishena maraNena sa Ishvarasya mahimAnaM prakAshayiShyati tad bodhayituM sa iti vAkyaM proktavAn| ityukte sati sa tamavochat mama pashchAd AgachCha| ");
INSERT INTO sanitr_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","yo jano rAtrikAle yIsho rvakSho.avalambya, he prabho ko bhavantaM parakareShu samarpayiShyatIti vAkyaM pR^iShTavAn, taM yIshoH priyatamashiShyaM pashchAd AgachChantaM ");
INSERT INTO sanitr_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","pitaro mukhaM parAvarttya vilokya yIshuM pR^iShTavAn, he prabho etasya mAnavasya kIdR^ishI gati rbhaviShyati? ");
INSERT INTO sanitr_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","sa pratyavadat, mama punarAgamanaparyyantaM yadi taM sthApayitum ichChAmi tatra tava kiM? tvaM mama pashchAd AgachCha| ");
INSERT INTO sanitr_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","tasmAt sa shiShyo na mariShyatIti bhrAtR^igaNamadhye kiMvadantI jAtA kintu sa na mariShyatIti vAkyaM yIshu rnAvadat kevalaM mama punarAgamanaparyyantaM yadi taM sthApayitum ichChAmi tatra tava kiM? iti vAkyam uktavAn| ");
INSERT INTO sanitr_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","yo jana etAni sarvvANi likhitavAn atra sAkShya ncha dattavAn saeva sa shiShyaH, tasya sAkShyaM pramANamiti vayaM jAnImaH| ");
INSERT INTO sanitr_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","yIshuretebhyo.aparANyapi bahUni karmmANi kR^itavAn tAni sarvvANi yadyekaikaM kR^itvA likhyante tarhi granthA etAvanto bhavanti teShAM dhAraNe pR^ithivyAM sthAnaM na bhavati| iti||");
INSERT INTO sanitr_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","he thiyaphila, yIshuH svamanonItAn preritAn pavitreNAtmanA samAdishya yasmin dine svargamArohat yAM yAM kriyAmakarot yadyad upAdishachcha tAni sarvvANi pUrvvaM mayA likhitAni| ");
INSERT INTO sanitr_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","sa svanidhanaduHkhabhogAt param anekapratyayakShapramANauH svaM sajIvaM darshayitvA ");
INSERT INTO sanitr_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","chatvAriMshaddinAni yAvat tebhyaH preritebhyo darshanaM dattveshvarIyarAjyasya varNanama akarot| ");
INSERT INTO sanitr_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","anantaraM teShAM sabhAM kR^itvA ityAj nApayat, yUyaM yirUshAlamo.anyatra gamanamakR^itvA yastin pitrA NgIkR^ite mama vadanAt kathA ashR^iNuta tatprAptim apekShya tiShThata| ");
INSERT INTO sanitr_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","yohan jale majjitAvAn kintvalpadinamadhye yUyaM pavitra Atmani majjitA bhaviShyatha| ");
INSERT INTO sanitr_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","pashchAt te sarvve militvA tam apR^ichChan he prabho bhavAn kimidAnIM punarapi rAjyam isrAyelIyalokAnAM kareShu samarpayiShyati? ");
INSERT INTO sanitr_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","tataH sovadat yAn sarvvAn kAlAn samayAMshcha pitA svavashe.asthApayat tAn j nAtR^iM yuShmAkam adhikAro na jAyate| ");
INSERT INTO sanitr_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","kintu yuShmAsu pavitrasyAtmana AvirbhAve sati yUyaM shaktiM prApya yirUshAlami samastayihUdAshomiroNadeshayoH pR^ithivyAH sImAM yAvad yAvanto deshAsteShu yarvveShu cha mayi sAkShyaM dAsyatha| ");
INSERT INTO sanitr_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","iti vAkyamuktvA sa teShAM samakShaM svargaM nIto.abhavat, tato meghamAruhya teShAM dR^iShTeragocharo.abhavat| ");
INSERT INTO sanitr_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","yasmin samaye te vihAyasaM pratyananyadR^iShTyA tasya tAdR^isham Urdvvagamanam apashyan tasminneva samaye shuklavastrau dvau janau teShAM sannidhau daNDAyamAnau kathitavantau, ");
INSERT INTO sanitr_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","he gAlIlIyalokA yUyaM kimarthaM gagaNaM prati nirIkShya daNDAyamAnAstiShThatha? yuShmAkaM samIpAt svargaM nIto yo yIshustaM yUyaM yathA svargam Arohantam adarsham tathA sa punashchAgamiShyati| ");
INSERT INTO sanitr_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","tataH paraM te jaitunanAmnaH parvvatAd vishrAmavArasya pathaH parimANam arthAt prAyeNArddhakroshaM durasthaM yirUshAlamnagaraM parAvR^ityAgachChan| ");
INSERT INTO sanitr_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","nagaraM pravishya pitaro yAkUb yohan AndriyaH philipaH thomA barthajamayo mathirAlphIyaputro yAkUb udyogAी shimon yAkUbo bhrAtA yihUdA ete sarvve yatra sthAne pravasanti tasmin uparitanaprakoShThe prAvishan| ");
INSERT INTO sanitr_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","pashchAd ime kiyatyaH striyashcha yIsho rmAtA mariyam tasya bhrAtarashchaite sarvva ekachittIbhUta satataM vinayena vinayena prArthayanta| ");
INSERT INTO sanitr_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","tasmin samaye tatra sthAne sAkalyena viMshatyadhikashataM shiShyA Asan| tataH pitarasteShAM madhye tiShThan uktavAn ");
INSERT INTO sanitr_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","he bhrAtR^igaNa yIshudhAriNAM lokAnAM pathadarshako yo yihUdAstasmin dAyUdA pavitra AtmA yAM kathAM kathayAmAsa tasyAH pratyakShIbhavanasyAvashyakatvam AsIt| ");
INSERT INTO sanitr_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","sa jano.asmAkaM madhyavarttI san asyAH sevAyA aMsham alabhata| ");
INSERT INTO sanitr_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","tadanantaraM kukarmmaNA labdhaM yanmUlyaM tena kShetramekaM krItam aparaM tasmin adhomukhe bhR^imau patite sati tasyodarasya vidIrNatvAt sarvvA nADyo niragachChan| ");
INSERT INTO sanitr_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","etAM kathAM yirUshAlamnivAsinaH sarvve lokA vidAnti; teShAM nijabhAShayA tatkShetra ncha hakaldAmA, arthAt raktakShetramiti vikhyAtamAste| ");
INSERT INTO sanitr_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","anyachcha, niketanaM tadIyantu shunyameva bhaviShyati| tasya dUShye nivAsArthaM kopi sthAsyati naiva hi| anya eva janastasya padaM saMprApsyati dhruvaM| itthaM gItapustake likhitamAste| ");
INSERT INTO sanitr_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","ato yohano majjanam ArabhyAsmAkaM samIpAt prabho ryIshoH svargArohaNadinaM yAvat sosmAkaM madhye yAvanti dinAni yApitavAn ");
INSERT INTO sanitr_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","tAvanti dinAni ye mAnavA asmAbhiH sArddhaM tiShThanti teShAm ekena janenAsmAbhiH sArddhaM yIshorutthAne sAkShiNA bhavitavyaM| ");
INSERT INTO sanitr_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","ato yasya rUDhi ryuShTo yaM barshabbetyuktvAhUyanti sa yUShaph matathishcha dvAvetau pR^ithak kR^itvA ta Ishvarasya sannidhau prAryya kathitavantaH, ");
INSERT INTO sanitr_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","he sarvvAntaryyAmin parameshvara, yihUdAH sevanapreritatvapadachyutaH ");
INSERT INTO sanitr_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","san nijasthAnam agachChat, tatpadaM labdhum enayo rjanayo rmadhye bhavatA ko.abhiruchitastadasmAn darshyatAM| ");
INSERT INTO sanitr_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","tato guTikApATe kR^ite matathirnirachIyata tasmAt sonyeShAm ekAdashAnAM praritAnAM madhye gaNitobhavat| ");
INSERT INTO sanitr_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","apara ncha nistArotsavAt paraM pa nchAshattame dine samupasthite sati te sarvve ekAchittIbhUya sthAna ekasmin militA Asan| ");
INSERT INTO sanitr_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","etasminneva samaye.akasmAd AkAshAt prachaNDAtyugravAyoH shabdavad ekaH shabda Agatya yasmin gR^ihe ta upAvishan tad gR^ihaM samastaM vyApnot| ");
INSERT INTO sanitr_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","tataH paraM vahnishikhAsvarUpA jihvAH pratyakShIbhUya vibhaktAH satyaH pratijanorddhve sthagitA abhUvan| ");
INSERT INTO sanitr_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","tasmAt sarvve pavitreNAtmanA paripUrNAH santa AtmA yathA vAchitavAn tadanusAreNAnyadeshIyAnAM bhAShA uktavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","tasmin samaye pR^ithivIsthasarvvadeshebhyo yihUdIyamatAvalambino bhaktalokA yirUshAlami prAvasan; ");
INSERT INTO sanitr_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","tasyAH kathAyAH kiMvadantyA jAtatvAt sarvve lokA militvA nijanijabhAShayA shiShyANAM kathAkathanaM shrutvA samudvignA abhavan| ");
INSERT INTO sanitr_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","sarvvaeva vismayApannA AshcharyyAnvitAshcha santaH parasparaM uktavantaH pashyata ye kathAM kathayanti te sarvve gAlIlIyalokAH kiM na bhavanti? ");
INSERT INTO sanitr_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","tarhi vayaM pratyekashaH svasvajanmadeshIyabhAShAbhiH kathA eteShAM shR^iNumaH kimidaM? ");
INSERT INTO sanitr_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","pArthI-mAdI-arAmnaharayimdeshanivAsimano yihUdA-kappadakiyA-panta-AshiyA- ");
INSERT INTO sanitr_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","phrugiyA-pamphuliyA-misaranivAsinaH kurINInikaTavarttilUbIyapradeshanivAsino romanagarAd AgatA yihUdIyalokA yihUdIyamatagrAhiNaH krItIyA arAbIyAdayo lokAshcha ye vayam ");
INSERT INTO sanitr_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","asmAkaM nijanijabhAShAbhireteShAm IshvarIyamahAkarmmavyAkhyAnaM shR^iNumaH| ");
INSERT INTO sanitr_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","itthaM te sarvvaeva vismayApannAH sandigdhachittAH santaH parasparamUchuH, asya ko bhAvaH? ");
INSERT INTO sanitr_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","apare kechit parihasya kathitavanta ete navInadrAkShArasena mattA abhavan| ");
INSERT INTO sanitr_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","tadA pitara ekAdashabhi rjanaiH sAkaM tiShThan tAllokAn uchchaiHkAram avadat, he yihUdIyA he yirUshAlamnivAsinaH sarvve, avadhAnaM kR^itvA madIyavAkyaM budhyadhvaM| ");
INSERT INTO sanitr_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","idAnIm ekayAmAd adhikA velA nAsti tasmAd yUyaM yad anumAtha mAnavA ime madyapAnena mattAstanna| ");
INSERT INTO sanitr_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","kintu yoyelbhaviShyadvaktraitadvAkyamuktaM yathA, ");
INSERT INTO sanitr_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","IshvaraH kathayAmAsa yugAntasamaye tvaham| varShiShyAmi svamAtmAnaM sarvvaprANyupari dhruvam| bhAvivAkyaM vadiShyanti kanyAH putrAshcha vastutaH|pratyAdesha ncha prApsyanti yuShmAkaM yuvamAnavAH| tathA prAchInalokAstu svapnAn drakShyanti nishchitaM| ");
INSERT INTO sanitr_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","varShiShyAmi tadAtmAnaM dAsadAsIjanopiri| tenaiva bhAvivAkyaM te vadiShyanti hi sarvvashaH| ");
INSERT INTO sanitr_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Urddhvasthe gagaNe chaiva nIchasthe pR^ithivItale| shoNitAni bR^ihadbhAnUn ghanadhUmAdikAni cha| chihnAni darshayiShyAmi mahAshcharyyakriyAstathA| ");
INSERT INTO sanitr_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","mahAbhayAnakasyaiva taddinasya pareshituH| purAgamAd raviH kR^iShNo raktashchandro bhaviShyataH| ");
INSERT INTO sanitr_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","kintu yaH parameshasya nAmni samprArthayiShyate| saeva manujo nUnaM paritrAto bhaviShyati|| ");
INSERT INTO sanitr_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","ato he isrAyelvaMshIyalokAH sarvve kathAyAmetasyAm mano nidhaddhvaM nAsaratIyo yIshurIshvarasya manonItaH pumAn etad IshvarastatkR^itairAshcharyyAdbhutakarmmabhi rlakShaNaishcha yuShmAkaM sAkShAdeva pratipAditavAn iti yUyaM jAnItha| ");
INSERT INTO sanitr_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","tasmin yIshau Ishvarasya pUrvvanishchitamantraNAnirUpaNAnusAreNa mR^ityau samarpite sati yUyaM taM dhR^itvA duShTalokAnAM hastaiH krushe vidhitvAhata| ");
INSERT INTO sanitr_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","kintvIshvarastaM nidhanasya bandhanAnmochayitvA udasthApayat yataH sa mR^ityunA baddhastiShThatIti na sambhavati| ");
INSERT INTO sanitr_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","etastin dAyUdapi kathitavAn yathA, sarvvadA mama sAkShAttaM sthApaya parameshvaraM| sthite maddakShiNe tasmin skhaliShyAmi tvahaM nahi| ");
INSERT INTO sanitr_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","AnandiShyati taddheto rmAmakInaM manastu vai| AhlAdiShyati jihvApi madIyA tu tathaiva cha| pratyAshayA sharIrantu madIyaM vaishayiShyate| ");
INSERT INTO sanitr_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","paraloke yato hetostvaM mAM naiva hi tyakShyasi| svakIyaM puNyavantaM tvaM kShayituM naiva dAsyasi| evaM jIvanamArgaM tvaM mAmeva darshayiShyasi| ");
INSERT INTO sanitr_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","svasammukhe ya Anando dakShiNe svasya yat sukhaM| anantaM tena mAM pUrNaM kariShyasi na saMshayaH|| ");
INSERT INTO sanitr_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","he bhrAtaro.asmAkaM tasya pUrvvapuruShasya dAyUdaH kathAM spaShTaM kathayituM mAm anumanyadhvaM, sa prANAn tyaktvA shmashAne sthApitobhavad adyApi tat shmashAnam asmAkaM sannidhau vidyate| ");
INSERT INTO sanitr_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","phalato laukikabhAvena dAyUdo vaMshe khrIShTaM janma grAhayitvA tasyaiva siMhAsane samuveShTuM tamutthApayiShyati parameshvaraH shapathaM kutvA dAyUdaH samIpa imam a NgIkAraM kR^itavAn, ");
INSERT INTO sanitr_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","iti j nAtvA dAyUd bhaviShyadvAdI san bhaviShyatkAlIyaj nAnena khrIShTotthAne kathAmimAM kathayAmAsa yathA tasyAtmA paraloke na tyakShyate tasya sharIra ncha na kSheShyati; ");
INSERT INTO sanitr_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","ataH parameshvara enaM yIshuM shmashAnAd udasthApayat tatra vayaM sarvve sAkShiNa Asmahe| ");
INSERT INTO sanitr_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","sa Ishvarasya dakShiNakareNonnatiM prApya pavitra Atmina pitA yama NgIkAraM kR^itavAn tasya phalaM prApya yat pashyatha shR^iNutha cha tadavarShat| ");
INSERT INTO sanitr_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","yato dAyUd svargaM nAruroha kintu svayam imAM kathAm akathayad yathA, mama prabhumidaM vAkyamavadat parameshvaraH| ");
INSERT INTO sanitr_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","tava shatrUnahaM yAvat pAdapIThaM karomi na| tAvat kAlaM madIye tvaM dakShavArshva upAvisha| ");
INSERT INTO sanitr_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","ato yaM yIshuM yUyaM krushe.ahata parameshvarastaM prabhutvAbhiShiktatvapade nyayuMkteti isrAyelIyA lokA nishchitaM jAnantu| ");
INSERT INTO sanitr_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","etAdR^ishIM kathAM shrutvA teShAM hR^idayAnAM vidIrNatvAt te pitarAya tadanyapreritebhyashcha kathitavantaH, he bhrAtR^igaNa vayaM kiM kariShyAmaH? ");
INSERT INTO sanitr_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","tataH pitaraH pratyavadad yUyaM sarvve svaM svaM manaH parivarttayadhvaM tathA pApamochanArthaM yIshukhrIShTasya nAmnA majjitAshcha bhavata, tasmAd dAnarUpaM paritram AtmAnaM lapsyatha| ");
INSERT INTO sanitr_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","yato yuShmAkaM yuShmatsantAnAnA ncha dUrasthasarvvalokAnA ncha nimittam arthAd asmAkaM prabhuH parameshvaro yAvato lAkAn AhvAsyati teShAM sarvveShAM nimittam ayama NgIkAra Aste| ");
INSERT INTO sanitr_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","etadanyAbhi rbahukathAbhiH pramANaM datvAkathayat etebhyo vipathagAmibhyo varttamAnalokebhyaH svAn rakShata| ");
INSERT INTO sanitr_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","tataH paraM ye sAnandAstAM kathAm agR^ihlan te majjitA abhavan| tasmin divase prAyeNa trINi sahasrANi lokAsteShAM sapakShAH santaH ");
INSERT INTO sanitr_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","preritAnAm upadeshe sa Ngatau pUpabha njane prArthanAsu cha manaHsaMyogaM kR^itvAtiShThan| ");
INSERT INTO sanitr_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","preritai rnAnAprakAralakShaNeShu mahAshcharyyakarmamasu cha darshiteShu sarvvalokAnAM bhayamupasthitaM| ");
INSERT INTO sanitr_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","vishvAsakAriNaH sarvva cha saha tiShThanataH| sveShAM sarvvAH sampattIH sAdhAraNyena sthApayitvAbhu njata| ");
INSERT INTO sanitr_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","phalato gR^ihANi dravyANi cha sarvvANi vikrIya sarvveShAM svasvaprayojanAnusAreNa vibhajya sarvvebhyo.adadan| ");
INSERT INTO sanitr_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","sarvva ekachittIbhUya dine dine mandire santiShThamAnA gR^ihe gR^ihe cha pUpAnabha njanta Ishvarasya dhanyavAdaM kurvvanto lokaiH samAdR^itAH paramAnandena saralAntaHkaraNena bhojanaM pAna nchakurvvan| ");
INSERT INTO sanitr_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","parameshvaro dine dine paritrANabhAjanai rmaNDalIm avarddhayat| ");
INSERT INTO sanitr_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","tR^itIyayAmavelAyAM satyAM prArthanAyAH samaye pitarayohanau sambhUya mandiraM gachChataH| ");
INSERT INTO sanitr_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","tasminneva samaye mandirapraveshakAnAM samIpe bhikShAraNArthaM yaM janmakha njamAnuShaM lokA mandirasya sundaranAmni dvAre pratidinam asthApayan taM vahantastadvAraM Anayan| ");
INSERT INTO sanitr_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","tadA pitarayohanau mantiraM praveShTum udyatau vilokya sa kha njastau ki nchid bhikShitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","tasmAd yohanA sahitaH pitarastam ananyadR^iShTyA nirIkShya proktavAn AvAM prati dR^iShTiM kuru| ");
INSERT INTO sanitr_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","tataH sa ki nchit prAptyAshayA tau prati dR^iShTiM kR^itavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","tadA pitaro gaditavAn mama nikaTe svarNarUpyAdi kimapi nAsti kintu yadAste tad dadAmi nAsaratIyasya yIshukhrIShTasya nAmnA tvamutthAya gamanAgamane kuru| ");
INSERT INTO sanitr_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","tataH paraM sa tasya dakShiNakaraM dhR^itvA tam udatolayat; tena tatkShaNAt tasya janasya pAdagulphayoH sabalatvAt sa ullamphya protthAya gamanAgamane .akarot| ");
INSERT INTO sanitr_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","tato gamanAgamane kurvvan ullamphan IshvaraM dhanyaM vadan tAbhyAM sArddhaM mandiraM prAvishat| ");
INSERT INTO sanitr_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","tataH sarvve lokAstaM gamanAgamane kurvvantam IshvaraM dhanyaM vadanta ncha vilokya ");
INSERT INTO sanitr_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","mandirasya sundare dvAre ya upavishya bhikShitavAn saevAyam iti j nAtvA taM prati tayA ghaTanayA chamatkR^itA vismayApannAshchAbhavan| ");
INSERT INTO sanitr_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","yaH kha njaH svasthobhavat tena pitarayohanoH karayordhTatayoH satoH sarvve lokA sannidhim AgachChan| ");
INSERT INTO sanitr_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","tad dR^iShTvA pitarastebhyo.akathayat, he isrAyelIyalokA yUyaM kuto .anenAshcharyyaM manyadhve? AvAM nijashaktyA yadvA nijapuNyena kha njamanuShyamenaM gamitavantAviti chintayitvA AvAM prati kuto.ananyadR^iShTiM kurutha? ");
INSERT INTO sanitr_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","yaM yIshuM yUyaM parakareShu samArpayata tato yaM pIlAto mochayitum eैchChat tathApi yUyaM tasya sAkShAn nA NgIkR^itavanta ibrAhIma ishAko yAkUbashcheshvaro.arthAd asmAkaM pUrvvapuruShANAm IshvaraH svaputrasya tasya yIsho rmahimAnaM prAkAshayat| ");
INSERT INTO sanitr_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","kintu yUyaM taM pavitraM dhArmmikaM pumAMsaM nA NgIkR^itya hatyAkAriNamekaM svebhyo dAtum ayAchadhvaM| ");
INSERT INTO sanitr_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","pashchAt taM jIvanasyAdhipatim ahata kintvIshvaraH shmashAnAt tam udasthApayata tatra vayaM sAkShiNa Asmahe| ");
INSERT INTO sanitr_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","imaM yaM mAnuShaM yUyaM pashyatha parichinutha cha sa tasya nAmni vishvAsakaraNAt chalanashaktiM labdhavAn tasmin tasya yo vishvAsaH sa taM yuShmAkaM sarvveShAM sAkShAt sampUrNarUpeNa svastham akArShIt| ");
INSERT INTO sanitr_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","he bhrAtaro yUyaM yuShmAkam adhipatayashcha aj nAtvA karmmANyetAni kR^itavanta idAnIM mamaiSha bodho jAyate| ");
INSERT INTO sanitr_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","kintvIshvaraH khrIShTasya duHkhabhoge bhaviShyadvAdinAM mukhebhyo yAM yAM kathAM pUrvvamakathayat tAH kathA itthaM siddhA akarot| ");
INSERT INTO sanitr_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","ataH sveShAM pApamochanArthaM khedaM kR^itvA manAMsi parivarttayadhvaM, tasmAd IshvarAt sAntvanAprApteH samaya upasthAsyati; ");
INSERT INTO sanitr_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","punashcha pUrvvakAlam Arabhya prachArito yo yIshukhrIShTastam Ishvaro yuShmAn prati preShayiShyati| ");
INSERT INTO sanitr_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","kintu jagataH sR^iShTimArabhya Ishvaro nijapavitrabhaviShyadvAdigaNona yathA kathitavAn tadanusAreNa sarvveShAM kAryyANAM siddhiparyyantaM tena svarge vAsaH karttavyaH| ");
INSERT INTO sanitr_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","yuShmAkaM prabhuH parameshvaro yuShmAkaM bhrAtR^igaNamadhyAt matsadR^ishaM bhaviShyadvaktAram utpAdayiShyati, tataH sa yat ki nchit kathayiShyati tatra yUyaM manAMsi nidhaddhvaM| ");
INSERT INTO sanitr_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","kintu yaH kashchit prANI tasya bhaviShyadvAdinaH kathAM na grahIShyati sa nijalokAnAM madhyAd uchChetsyate,\" imAM kathAm asmAkaM pUrvvapuruShebhyaH kevalo mUsAH kathayAmAsa iti nahi, ");
INSERT INTO sanitr_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","shimUyelbhaviShyadvAdinam Arabhya yAvanto bhaviShyadvAkyam akathayan te sarvvaeva samayasyaitasya kathAm akathayan| ");
INSERT INTO sanitr_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","yUyamapi teShAM bhaviShyadvAdinAM santAnAH, \"tava vaMshodbhavapuMsA sarvvadeshIyA lokA AshiShaM prAptA bhaviShyanti\", ibrAhIme kathAmetAM kathayitvA IshvarosmAkaM pUrvvapuruShaiH sArddhaM yaM niyamaM sthirIkR^itavAn tasya niyamasyAdhikAriNopi yUyaM bhavatha| ");
INSERT INTO sanitr_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ata Ishvaro nijaputraM yIshum utthApya yuShmAkaM sarvveShAM svasvapApAt parAvarttya yuShmabhyam AshiShaM dAtuM prathamatastaM yuShmAkaM nikaTaM preShitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","yasmin samaye pitarayohanau lokAn upadishatastasmin samaye yAjakA mandirasya senApatayaH sidUkIgaNashcha ");
INSERT INTO sanitr_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","tayor upadeshakaraNe khrIShTasyotthAnam upalakShya sarvveShAM mR^itAnAm utthAnaprastAve cha vyagrAH santastAvupAgaman| ");
INSERT INTO sanitr_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","tau dhR^itvA dinAvasAnakAraNAt paradinaparyyanantaM ruddhvA sthApitavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","tathApi ye lokAstayorupadesham ashR^iNvan teShAM prAyeNa pa nchasahasrANi janA vyashvasan| ");
INSERT INTO sanitr_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","pare.ahani adhipatayaH prAchInA adhyApakAshcha hAnananAmA mahAyAjakaH ");
INSERT INTO sanitr_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","kiyaphA yohan sikandara ityAdayo mahAyAjakasya j nAtayaH sarvve yirUshAlamnagare militAH| ");
INSERT INTO sanitr_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","anantaraM preritau madhye sthApayitvApR^ichChan yuvAM kayA shaktayA vA kena nAmnA karmmANyetAni kuruthaH? ");
INSERT INTO sanitr_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","tadA pitaraH pavitreNAtmanA paripUrNaH san pratyavAdIt, he lokAnAm adhipatigaNa he isrAyelIyaprAchInAH, ");
INSERT INTO sanitr_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","etasya durbbalamAnuShasya hitaM yat karmmAkriyata, arthAt, sa yena prakAreNa svasthobhavat tachched adyAvAM pR^ichChatha, ");
INSERT INTO sanitr_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","tarhi sarvva isrAyeेlIyalokA yUyaM jAnIta nAsaratIyo yo yIshukhrIShTaH krushe yuShmAbhiravidhyata yashcheshvareNa shmashAnAd utthApitaH, tasya nAmnA janoyaM svasthaH san yuShmAkaM sammukhe prottiShThati| ");
INSERT INTO sanitr_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","nichetR^ibhi ryuShmAbhirayaM yaH prastaro.avaj nAto.abhavat sa pradhAnakoNasya prastaro.abhavat| ");
INSERT INTO sanitr_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","tadbhinnAdaparAt kasmAdapi paritrANaM bhavituM na shaknoti, yena trANaM prApyeta bhUmaNDalasyalokAnAM madhye tAdR^ishaM kimapi nAma nAsti| ");
INSERT INTO sanitr_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","tadA pitarayohanoretAdR^ishIm akShebhatAM dR^iShTvA tAvavidvAMsau nIchalokAviti buddhvA Ashcharyyam amanyanta tau cha yIshoH sa Nginau jAtAviti j nAtum ashaknuvan| ");
INSERT INTO sanitr_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","kintu tAbhyAM sArddhaM taM svasthamAnuShaM tiShThantaM dR^iShTvA te kAmapyaparAm ApattiM karttaM nAshaknun| ");
INSERT INTO sanitr_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","tadA te sabhAtaH sthAnAntaraM gantuM tAn Aj nApya svayaM parasparam iti mantraNAmakurvvan ");
INSERT INTO sanitr_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","tau mAnavau prati kiM karttavyaM? tAvekaM prasiddham AshcharyyaM karmma kR^itavantau tad yirUshAlamnivAsinAM sarvveShAM lokAnAM samIpe prAkAshata tachcha vayamapahnotuM na shaknumaH| ");
INSERT INTO sanitr_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","kintu lokAnAM madhyam etad yathA na vyApnoti tadarthaM tau bhayaM pradarshya tena nAmnA kamapi manuShyaM nopadishatam iti dR^iDhaM niShedhAmaH| ");
INSERT INTO sanitr_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","tataste preritAvAhUya etadAj nApayan itaH paraM yIsho rnAmnA kadApi kAmapi kathAM mA kathayataM kimapi nopadisha ncha| ");
INSERT INTO sanitr_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","tataH pitarayohanau pratyavadatAm IshvarasyAj nAgrahaNaM vA yuShmAkam Aj nAgrahaNam etayo rmadhye Ishvarasya gochare kiM vihitaM? yUyaM tasya vivechanAM kuruta| ");
INSERT INTO sanitr_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","vayaM yad apashyAma yadashR^iNuma cha tanna prachArayiShyAma etat kadApi bhavituM na shaknoti| ");
INSERT INTO sanitr_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","yadaghaTata tad dR^iShTA sarvve lokA Ishvarasya guNAn anvavadan tasmAt lokabhayAt tau daNDayituM kamapyupAyaM na prApya te punarapi tarjayitvA tAvatyajan| ");
INSERT INTO sanitr_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","yasya mAnuShasyaitat svAsthyakaraNam AshcharyyaM karmmAkriyata tasya vayashchatvAriMshadvatsarA vyatItAH| ");
INSERT INTO sanitr_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","tataH paraM tau visR^iShTau santau svasa NginAM sannidhiM gatvA pradhAnayAjakaiH prAchInalokaishcha proktAH sarvvAH kathA j nApitavantau| ");
INSERT INTO sanitr_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","tachChrutvA sarvva ekachittIbhUya Ishvaramuddishya prochchairetat prArthayanta, he prabho gagaNapR^ithivIpayodhInAM teShu cha yadyad Aste teShAM sraShTeshvarastvaM| ");
INSERT INTO sanitr_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","tvaM nijasevakena dAyUdA vAkyamidam uvachitha, manuShyA anyadeshIyAH kurvvanti kalahaM kutaH| lokAH sarvve kimarthaM vA chintAM kurvvanti niShphalAM| ");
INSERT INTO sanitr_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","parameshasya tenaivAbhiShiktasya janasya cha| viruddhamabhitiShThanti pR^ithivyAH patayaH kutaH|| ");
INSERT INTO sanitr_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","phalatastava hastena mantraNayA cha pUrvva yadyat sthirIkR^itaM tad yathA siddhaM bhavati tadarthaM tvaM yam athiShiktavAn sa eva pavitro yIshustasya prAtikUlyena herod pantIyapIlAto ");
INSERT INTO sanitr_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28",".anyadeshIyalokA isrAyellokAshcha sarvva ete sabhAyAm atiShThan| ");
INSERT INTO sanitr_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","he parameshvara adhunA teShAM tarjanaM garjana ncha shR^iNu; ");
INSERT INTO sanitr_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","tathA svAsthyakaraNakarmmaNA tava bAhubalaprakAshapUrvvakaM tava sevakAn nirbhayena tava vAkyaM prachArayituM tava pavitraputrasya yIsho rnAmnA AshcharyyANyasambhavAni cha karmmANi karttu nchAj nApaya| ");
INSERT INTO sanitr_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","itthaM prArthanayA yatra sthAne te sabhAyAm Asan tat sthAnaM prAkampata; tataH sarvve pavitreNAtmanA paripUrNAH santa Ishvarasya kathAm akShobheNa prAchArayan| ");
INSERT INTO sanitr_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","apara ncha pratyayakArilokasamUhA ekamanasa ekachittIbhUya sthitAH| teShAM kepi nijasampattiM svIyAM nAjAnan kintu teShAM sarvvAH sampattyaH sAdhAraNyena sthitAH| ");
INSERT INTO sanitr_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","anyachcha preritA mahAshaktiprakAshapUrvvakaM prabho ryIshorutthAne sAkShyam adaduH, teShu sarvveShu mahAnugraho.abhavachcha| ");
INSERT INTO sanitr_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","teShAM madhye kasyApi dravyanyUnatA nAbhavad yatasteShAM gR^ihabhUmyAdyA yAH sampattaya Asan tA vikrIya ");
INSERT INTO sanitr_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","tanmUlyamAnIya preritAnAM charaNeShu taiH sthApitaM; tataH pratyekashaH prayojanAnusAreNa dattamabhavat| ");
INSERT INTO sanitr_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","visheShataH kupropadvIpIyo yosinAmako levivaMshajAta eko jano bhUmyadhikArI, yaM preritA barNabbA arthAt sAntvanAdAyaka ityuktvA samAhUyan, ");
INSERT INTO sanitr_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","sa jano nijabhUmiM vikrIya tanmUlyamAnIya preritAnAM charaNeShu sthApitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","tadA anAniyanAmaka eko jano yasya bhAryyAyA nAma saphIrA sa svAdhikAraM vikrIya ");
INSERT INTO sanitr_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","svabhAryyAM j nApayitvA tanmUlyasyaikAMshaM sa Ngopya sthApayitvA tadanyAMshamAtramAnIya preritAnAM charaNeShu samarpitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","tasmAt pitarokathayat he anAniya bhUme rmUlyaM ki nchit sa Ngopya sthApayituM pavitrasyAtmanaH sannidhau mR^iShAvAkyaM kathayitu ncha shaitAn kutastavAntaHkaraNe pravR^ittimajanayat? ");
INSERT INTO sanitr_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","sA bhUmi ryadA tava hastagatA tadA kiM tava svIyA nAsIt? tarhi svAntaHkaraNe kuta etAdR^ishI kukalpanA tvayA kR^itA? tvaM kevalamanuShyasya nikaTe mR^iShAvAkyaM nAvAdIH kintvIshvarasya nikaTe.api| ");
INSERT INTO sanitr_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","etAM kathAM shrutvaiva so.anAniyo bhUmau patan prANAn atyajat, tadvR^ittAntaM yAvanto lokA ashR^iNvan teShAM sarvveShAM mahAbhayam ajAyat| ");
INSERT INTO sanitr_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","tadA yuvalokAstaM vastreNAchChAdya bahi rnItvA shmashAne.asthApayan| ");
INSERT INTO sanitr_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","tataH praharaikAnantaraM kiM vR^ittaM tannAvagatya tasya bhAryyApi tatra samupasthitA| ");
INSERT INTO sanitr_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","tataH pitarastAm apR^ichChat, yuvAbhyAm etAvanmudrAbhyo bhUmi rvikrItA na vA? etatvaM vada; tadA sA pratyavAdIt satyam etAvadbhyo mudrAbhya eva| ");
INSERT INTO sanitr_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","tataH pitarokathayat yuvAM kathaM parameshvarasyAtmAnaM parIkShitum ekamantraNAvabhavatAM? pashya ye tava patiM shmashAne sthApitavantaste dvArasya samIpe samupatiShThanti tvAmapi bahirneShyanti| ");
INSERT INTO sanitr_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","tataH sApi tasya charaNasannidhau patitvA prANAn atyAkShIt| pashchAt te yuvAno.abhyantaram Agatya tAmapi mR^itAM dR^iShTvA bahi rnItvA tasyAH patyuH pArshve shmashAne sthApitavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","tasmAt maNDalyAH sarvve lokA anyalokAshcha tAM vArttAM shrutvA sAdhvasaM gatAH| ");
INSERT INTO sanitr_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","tataH paraM preritAnAM hastai rlokAnAM madhye bahvAshcharyyANyadbhutAni karmmANyakriyanta; tadA shiShyAH sarvva ekachittIbhUya sulemAno .alinde sambhUyAsan| ");
INSERT INTO sanitr_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","teShAM sa NghAntargo bhavituM kopi pragalbhatAM nAgamat kintu lokAstAn samAdriyanta| ");
INSERT INTO sanitr_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","striyaH puruShAshcha bahavo lokA vishvAsya prabhuM sharaNamApannAH| ");
INSERT INTO sanitr_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","pitarasya gamanAgamanAbhyAM kenApi prakAreNa tasya ChAyA kasmiMshchijjane lagiShyatItyAshayA lokA rogiNaH shivikayA khaTvayA chAnIya pathi pathi sthApitavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","chaturdiksthanagarebhyo bahavo lokAH sambhUya rogiNo.apavitrabhutagrastAMshcha yirUshAlamam Anayan tataH sarvve svasthA akriyanta| ");
INSERT INTO sanitr_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","anantaraM mahAyAjakaH sidUkinAM matagrAhiNasteShAM sahacharAshcha ");
INSERT INTO sanitr_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","mahAkrodhAntvitAH santaH preritAn dhR^itvA nIchalokAnAM kArAyAM baddhvA sthApitavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","kintu rAtrau parameshvarasya dUtaH kArAyA dvAraM mochayitvA tAn bahirAnIyAkathayat, ");
INSERT INTO sanitr_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","yUyaM gatvA mandire daNDAyamAnAH santo lokAn pratImAM jIvanadAyikAM sarvvAM kathAM prachArayata| ");
INSERT INTO sanitr_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","iti shrutvA te pratyUShe mandira upasthAya upadiShTavantaH| tadA sahacharagaNena sahito mahAyAjaka Agatya mantrigaNam isrAyelvaMshasya sarvvAn rAjasabhAsadaH sabhAsthAn kR^itvA kArAyAstAn ApayituM padAtigaNaM preritavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","tataste gatvA kArAyAM tAn aprApya pratyAgatya iti vArttAm avAdiShuH, ");
INSERT INTO sanitr_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","vayaM tatra gatvA nirvvighnaM kArAyA dvAraM ruddhaM rakShakAMshcha dvArasya bahirdaNDAyamAnAn adarshAma eva kintu dvAraM mochayitvA tanmadhye kamapi draShTuM na prAptAH| ");
INSERT INTO sanitr_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","etAM kathAM shrutvA mahAyAjako mandirasya senApatiH pradhAnayAjakAshcha, ita paraM kimaparaM bhaviShyatIti chintayitvA sandigdhachittA abhavan| ");
INSERT INTO sanitr_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","etasminneva samaye kashchit jana Agatya vArttAmetAm avadat pashyata yUyaM yAn mAnavAn kArAyAm asthApayata te mandire tiShThanto lokAn upadishanti| ");
INSERT INTO sanitr_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","tadA mandirasya senApatiH padAtayashcha tatra gatvA chellokAH pAShANAn nikShipyAsmAn mArayantIti bhiyA vinatyAchAraM tAn Anayan| ");
INSERT INTO sanitr_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","te mahAsabhAyA madhye tAn asthApayan tataH paraM mahAyAjakastAn apR^ichChat, ");
INSERT INTO sanitr_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","anena nAmnA samupadeShTuM vayaM kiM dR^iDhaM na nyaShedhAma? tathApi pashyata yUyaM sveShAM tenopadeshene yirUshAlamaM paripUrNaM kR^itvA tasya janasya raktapAtajanitAparAdham asmAn pratyAnetuM cheShTadhve| ");
INSERT INTO sanitr_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","tataH pitaronyapreritAshcha pratyavadan mAnuShasyAj nAgrahaNAd IshvarasyAj nAgrahaNam asmAkamuchitam| ");
INSERT INTO sanitr_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","yaM yIshuM yUyaM krushe vedhitvAhata tam asmAkaM paitR^ika Ishvara utthApya ");
INSERT INTO sanitr_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","isrAyelvaMshAnAM manaHparivarttanaM pApakShamA ncha karttuM rAjAnaM paritrAtAra ncha kR^itvA svadakShiNapArshve tasyAnnatim akarot| ");
INSERT INTO sanitr_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","etasmin vayamapi sAkShiNa Asmahe, tat kevalaM nahi, Ishvara Aj nAgrAhibhyo yaM pavitram AtmanaM dattavAn sopi sAkShyasti| ");
INSERT INTO sanitr_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","etadvAkye shrute teShAM hR^idayAni viddhAnyabhavan tataste tAn hantuM mantritavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","etasminneva samaye tatsabhAsthAnAM sarvvalokAnAM madhye sukhyAto gamilIyelnAmaka eko jano vyavasthApakaH phirUshiloka utthAya preritAn kShaNArthaM sthAnAntaraM gantum Adishya kathitavAn, ");
INSERT INTO sanitr_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","he isrAyelvaMshIyAH sarvve yUyam etAn mAnuShAn prati yat karttum udyatAstasmin sAvadhAnA bhavata| ");
INSERT INTO sanitr_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","itaH pUrvvaM thUdAnAmaiko jana upasthAya svaM kamapi mahApuruSham avadat, tataH prAyeNa chatuHshatalokAstasya matagrAhiNobhavan pashchAt sa hatobhavat tasyAj nAgrAhiNo yAvanto lokAste sarvve virkIrNAH santo .akR^itakAryyA abhavan| ");
INSERT INTO sanitr_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","tasmAjjanAt paraM nAmalekhanasamaye gAlIlIyayihUdAnAmaiko jana upasthAya bahUllokAn svamataM grAhItavAn tataH sopi vyanashyat tasyAj nAgrAhiNo yAvanto lokA Asan te sarvve vikIrNA abhavan| ");
INSERT INTO sanitr_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","adhunA vadAmi, yUyam etAn manuShyAn prati kimapi na kR^itvA kShAntA bhavata, yata eSha sa Nkalpa etat karmma cha yadi manuShyAdabhavat tarhi viphalaM bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","yadIshvarAdabhavat tarhi yUyaM tasyAnyathA karttuM na shakShyatha, varam IshvararodhakA bhaviShyatha| ");
INSERT INTO sanitr_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","tadA tasya mantraNAM svIkR^itya te preritAn AhUya prahR^itya yIsho rnAmnA kAmapi kathAM kathayituM niShidhya vyasarjan| ");
INSERT INTO sanitr_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","kintu tasya nAmArthaM vayaM lajjAbhogasya yogyatvena gaNitA ityatra te sAnandAH santaH sabhAsthAnAM sAkShAd agachChan| ");
INSERT INTO sanitr_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","tataH paraM pratidinaM mandire gR^ihe gR^ihe chAvishrAmam upadishya yIshukhrIShTasya susaMvAdaM prachAritavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","tasmin samaye shiShyANAM bAhulyAt prAtyahikadAnasya vishrANanai rbhinnadeshIyAnAM vidhavAstrIgaNa upekShite sati ibrIyalokaiH sahAnyadeshIyAnAM vivAda upAtiShThat| ");
INSERT INTO sanitr_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","tadA dvAdashapreritAH sarvvAn shiShyAn saMgR^ihyAkathayan Ishvarasya kathAprachAraM parityajya bhojanagaveShaNam asmAkam uchitaM nahi| ");
INSERT INTO sanitr_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ato he bhrAtR^igaNa vayam etatkarmmaNo bhAraM yebhyo dAtuM shaknuma etAdR^ishAn sukhyAtyApannAn pavitreNAtmanA j nAnena cha pUrNAn sapprajanAn yUyaM sveShAM madhye manonItAn kuruta, ");
INSERT INTO sanitr_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","kintu vayaM prArthanAyAM kathAprachArakarmmaNi cha nityapravR^ittAH sthAsyAmaH| ");
INSERT INTO sanitr_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","etasyAM kathAyAM sarvve lokAH santuShTAH santaH sveShAM madhyAt stiphAnaH philipaH prakharo nikAnor tIman parmmiNA yihUdimatagrAhI-AntiyakhiyAnagarIyo nikalA etAn paramabhaktAn pavitreNAtmanA paripUrNAn sapta janAn ");
INSERT INTO sanitr_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","preritAnAM samakSham Anayan, tataste prArthanAM kR^itvA teShAM shiraHsu hastAn Arpayan| ");
INSERT INTO sanitr_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","apara ncha Ishvarasya kathA deshaM vyApnot visheShato yirUshAlami nagare shiShyANAM saMkhyA prabhUtarUpeNAvarddhata yAjakAnAM madhyepi bahavaH khrIShTamatagrAhiNo.abhavan| ");
INSERT INTO sanitr_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","stiphAnoे vishvAsena parAkrameNa cha paripUrNaH san lokAnAM madhye bahuvidham adbhutam AshcharyyaM karmmAkarot| ");
INSERT INTO sanitr_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","tena libarttinIyanAmnA vikhyAtasa Nghasya katipayajanAH kurINIyasikandarIya-kilikIyAshIyAdeshIyAH kiyanto janAshchotthAya stiphAnena sArddhaM vyavadanta| ");
INSERT INTO sanitr_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","kintu stiphAno j nAnena pavitreNAtmanA cha IdR^ishIM kathAM kathitavAn yasyAste ApattiM karttuM nAshaknuvan| ");
INSERT INTO sanitr_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","pashchAt tai rlobhitAH katipayajanAH kathAmenAm akathayan, vayaM tasya mukhato mUsA Ishvarasya cha nindAvAkyam ashrauShma| ");
INSERT INTO sanitr_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","te lokAnAM lokaprAchInAnAm adhyApakAnA ncha pravR^ittiM janayitvA stiphAnasya sannidhim Agatya taM dhR^itvA mahAsabhAmadhyam Anayan| ");
INSERT INTO sanitr_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","tadanantaraM katipayajaneShu mithyAsAkShiShu samAnIteShu te.akathayan eSha jana etatpuNyasthAnavyavasthayo rnindAtaH kadApi na nivarttate| ");
INSERT INTO sanitr_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","phalato nAsaratIyayIshuH sthAnametad uchChinnaM kariShyati mUsAsamarpitam asmAkaM vyavaharaNam anyarUpaM kariShyati tasyaitAdR^ishIM kathAM vayam ashR^iNuma| ");
INSERT INTO sanitr_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","tadA mahAsabhAsthAH sarvve taM prati sthirAM dR^iShTiM kR^itvA svargadUtamukhasadR^ishaM tasya mukham apashyan| ");
INSERT INTO sanitr_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","tataH paraM mahAyAjakaH pR^iShTavAn, eShA kathAM kiM satyA? ");
INSERT INTO sanitr_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","tataH sa pratyavadat, he pitaro he bhrAtaraH sarvve lAkA manAMsi nidhaddhvaM|asmAkaM pUrvvapuruSha ibrAhIm hAraNnagare vAsakaraNAt pUrvvaM yadA arAm-naharayimadeshe AsIt tadA tejomaya Ishvaro darshanaM datvA ");
INSERT INTO sanitr_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","tamavadat tvaM svadeshaj nAtimitrANi parityajya yaM deshamahaM darshayiShyAmi taM deshaM vraja| ");
INSERT INTO sanitr_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","ataH sa kasdIyadeshaM vihAya hAraNnagare nyavasat, tadanantaraM tasya pitari mR^ite yatra deshe yUyaM nivasatha sa enaM deshamAgachChat| ");
INSERT INTO sanitr_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","kintvIshvarastasmai kamapyadhikAram arthAd ekapadaparimitAM bhUmimapi nAdadAt; tadA tasya kopi santAno nAsIt tathApi santAnaiH sArddham etasya deshasyAdhikArI tvaM bhaviShyasIti tampratya NgIkR^itavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ishvara ittham aparamapi kathitavAn tava santAnAH paradeshe nivatsyanti tatastaddeshIyalokAshchatuHshatavatsarAn yAvat tAn dAsatve sthApayitvA tAn prati kuvyavahAraM kariShyanti| ");
INSERT INTO sanitr_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","aparam Ishvara enAM kathAmapi kathitavAn, ye lokAstAn dAsatve sthApayiShyanti tAllokAn ahaM daNDayiShyAmi, tataH paraM te bahirgatAH santo mAm atra sthAne seviShyante| ");
INSERT INTO sanitr_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","pashchAt sa tasmai tvakChedasya niyamaM dattavAn, ata ishAkanAmni ibrAhIma ekaputre jAte, aShTamadine tasya tvakChedam akarot| tasya ishAkaH putro yAkUb, tatastasya yAkUbo.asmAkaM dvAdasha pUrvvapuruShA ajAyanta| ");
INSERT INTO sanitr_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","te pUrvvapuruShA IrShyayA paripUrNA misaradeshaM preShayituM yUShaphaM vyakrINan| ");
INSERT INTO sanitr_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","kintvIshvarastasya sahAyo bhUtvA sarvvasyA durgate rakShitvA tasmai buddhiM dattvA misaradeshasya rAj naH phirauNaH priyapAtraM kR^itavAn tato rAjA misaradeshasya svIyasarvvaparivArasya cha shAsanapadaM tasmai dattavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","tasmin samaye misara-kinAnadeshayo rdurbhikShahetoratikliShTatvAt naH pUrvvapuruShA bhakShyadravyaM nAlabhanta| ");
INSERT INTO sanitr_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","kintu misaradeshe shasyAni santi, yAkUb imAM vArttAM shrutvA prathamam asmAkaM pUrvvapuruShAn misaraM preShitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","tato dvitIyavAragamane yUShaph svabhrAtR^ibhiH parichito.abhavat; yUShapho bhrAtaraH phirauN rAjena parichitA abhavan| ");
INSERT INTO sanitr_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","anantaraM yUShaph bhrAtR^igaNaM preShya nijapitaraM yAkUbaM nijAn pa nchAdhikasaptatisaMkhyakAn j nAtijanAMshcha samAhUtavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","tasmAd yAkUb misaradeshaM gatvA svayam asmAkaM pUrvvapuruShAshcha tasmin sthAne.amriyanta| ");
INSERT INTO sanitr_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","tataste shikhimaM nItA yat shmashAnam ibrAhIm mudrAdatvA shikhimaH pitu rhamoraH putrebhyaH krItavAn tatshmashAne sthApayA nchakrire| ");
INSERT INTO sanitr_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","tataH param Ishvara ibrAhImaH sannidhau shapathaM kR^itvA yAM pratij nAM kR^itavAn tasyAH pratij nAyAH phalanasamaye nikaTe sati isrAyellokA simaradeshe varddhamAnA bahusaMkhyA abhavan| ");
INSERT INTO sanitr_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","sheShe yUShaphaM yo na parichinoti tAdR^isha eko narapatirupasthAya ");
INSERT INTO sanitr_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","asmAkaM j nAtibhiH sArddhaM dhUrttatAM vidhAya pUrvvapuruShAn prati kuvyavaharaNapUrvvakaM teShAM vaMshanAshanAya teShAM navajAtAn shishUn bahi rnirakShepayat| ");
INSERT INTO sanitr_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","etasmin samaye mUsA jaj ne, sa tu paramasundaro.abhavat tathA pitR^igR^ihe mAsatrayaparyyantaM pAlito.abhavat| ");
INSERT INTO sanitr_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","kintu tasmin bahirnikShipte sati phirauNarAjasya kanyA tam uttolya nItvA dattakaputraM kR^itvA pAlitavatI| ");
INSERT INTO sanitr_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","tasmAt sa mUsA misaradeshIyAyAH sarvvavidyAyAH pAradR^iShvA san vAkye kriyAyA ncha shaktimAn abhavat| ");
INSERT INTO sanitr_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","sa sampUrNachatvAriMshadvatsaravayasko bhUtvA isrAyelIyavaMshanijabhrAtR^in sAkShAt kartuM matiM chakre| ");
INSERT INTO sanitr_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","teShAM janamekaM hiMsitaM dR^iShTvA tasya sapakShaH san hiMsitajanam upakR^itya misarIyajanaM jaghAna| ");
INSERT INTO sanitr_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","tasya hasteneshvarastAn uddhariShyati tasya bhrAtR^igaNa iti j nAsyati sa ityanumAnaM chakAra, kintu te na bubudhire| ");
INSERT INTO sanitr_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","tatpare .ahani teShAm ubhayo rjanayo rvAkkalaha upasthite sati mUsAH samIpaM gatvA tayo rmelanaM karttuM matiM kR^itvA kathayAmAsa, he mahAshayau yuvAM bhrAtarau parasparam anyAyaM kutaH kuruthaH? ");
INSERT INTO sanitr_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","tataH samIpavAsinaM prati yo jano.anyAyaM chakAra sa taM dUrIkR^itya kathayAmAsa, asmAkamupari shAstR^itvavichArayitR^itvapadayoH kastvAM niyuktavAn? ");
INSERT INTO sanitr_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","hyo yathA misarIyaM hatavAn tathA kiM mAmapi haniShyasi? ");
INSERT INTO sanitr_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","tadA mUsA etAdR^ishIM kathAM shrutvA palAyanaM chakre, tato midiyanadeshaM gatvA pravAsI san tasthau, tatastatra dvau putrau jaj nAte| ");
INSERT INTO sanitr_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","anantaraM chatvAriMshadvatsareShu gateShu sInayaparvvatasya prAntare prajvalitastambasya vahnishikhAyAM parameshvaradUtastasmai darshanaM dadau| ");
INSERT INTO sanitr_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","mUsAstasmin darshane vismayaM matvA visheShaM j nAtuM nikaTaM gachChati, ");
INSERT INTO sanitr_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","etasmin samaye, ahaM tava pUrvvapuruShANAm Ishvaro.arthAd ibrAhIma Ishvara ishAka Ishvaro yAkUba Ishvarashcha, mUsAmuddishya parameshvarasyaitAdR^ishI vihAyasIyA vANI babhUva, tataH sa kampAnvitaH san puna rnirIkShituM pragalbho na babhUva| ");
INSERT INTO sanitr_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","parameshvarastaM jagAda, tava pAdayoH pAduke mochaya yatra tiShThasi sA pavitrabhUmiH| ");
INSERT INTO sanitr_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ahaM misaradeshasthAnAM nijalokAnAM durddashAM nitAntam apashyaM, teShAM kAtaryyokti ncha shrutavAn tasmAt tAn uddharttum avaruhyAgamam; idAnIm AgachCha misaradeshaM tvAM preShayAmi| ");
INSERT INTO sanitr_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","kastvAM shAstR^itvavichArayitR^itvapadayo rniyuktavAn, iti vAkyamuktvA tai ryo mUsA avaj nAtastameva IshvaraH stambamadhye darshanadAtrA tena dUtena shAstAraM muktidAtAra ncha kR^itvA preShayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","sa cha misaradeshe sUphnAmni samudre cha pashchAt chatvAriMshadvatsarAn yAvat mahAprAntare nAnAprakArANyadbhutAni karmmANi lakShaNAni cha darshayitvA tAn bahiH kR^itvA samAninAya| ");
INSERT INTO sanitr_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","prabhuH parameshvaro yuShmAkaM bhrAtR^igaNasya madhye mAdR^isham ekaM bhaviShyadvaktAram utpAdayiShyati tasya kathAyAM yUyaM mano nidhAsyatha, yo jana isrAyelaH santAnebhya enAM kathAM kathayAmAsa sa eSha mUsAH| ");
INSERT INTO sanitr_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","mahAprAntarasthamaNDalImadhye.api sa eva sInayaparvvatopari tena sArddhaM saMlApino dUtasya chAsmatpitR^igaNasya madhyasthaH san asmabhyaM dAtavyani jIvanadAyakAni vAkyAni lebhe| ");
INSERT INTO sanitr_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","asmAkaM pUrvvapuruShAstam amAnyaM katvA svebhyo dUrIkR^itya misaradeshaM parAvR^itya gantuM manobhirabhilaShya hAroNaM jagaduH, ");
INSERT INTO sanitr_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","asmAkam agre.agre gantuुm asmadarthaM devagaNaM nirmmAhi yato yo mUsA asmAn misaradeshAd bahiH kR^itvAnItavAn tasya kiM jAtaM tadasmAbhi rna j nAyate| ");
INSERT INTO sanitr_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","tasmin samaye te govatsAkR^itiM pratimAM nirmmAya tAmuddishya naivedyamutmR^ijya svahastakR^itavastunA AnanditavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","tasmAd IshvarasteShAM prati vimukhaH san AkAshasthaM jyotirgaNaM pUjayituM tebhyo.anumatiM dadau, yAdR^ishaM bhaviShyadvAdinAM grantheShu likhitamAste, yathA, isrAyelIyavaMshA re chatvAriMshatsamAn purA| mahati prAntare saMsthA yUyantu yAni cha| balihomAdikarmmANi kR^itavantastu tAni kiM| mAM samuddishya yuShmAbhiH prakR^itAnIti naiva cha| ");
INSERT INTO sanitr_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","kintu vo molakAkhyasya devasya dUShyameva cha| yuShmAkaM rimphanAkhyAyA devatAyAshcha tArakA| etayorubhayo rmUrtI yuShmAbhiH paripUjite| ato yuShmAMstu bAbelaH pAraM neShyAmi nishchitaM| ");
INSERT INTO sanitr_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","apara ncha yannidarshanam apashyastadanusAreNa dUShyaM nirmmAhi yasmin Ishvaro mUsAm etadvAkyaM babhAShe tat tasya nirUpitaM sAkShyasvarUpaM dUShyam asmAkaM pUrvvapuruShaiH saha prAntare tasthau| ");
INSERT INTO sanitr_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","pashchAt yihoshUyena sahitaisteShAM vaMshajAtairasmatpUrvvapuruShaiH sveShAM sammukhAd IshvareNa dUrIkR^itAnAm anyadeshIyAnAM deshAdhikR^itikAle samAnItaM tad dUShyaM dAyUdodhikAraM yAvat tatra sthAna AsIt| ");
INSERT INTO sanitr_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","sa dAyUd parameshvarasyAnugrahaM prApya yAkUb IshvarArtham ekaM dUShyaM nirmmAtuM vavA nCha; ");
INSERT INTO sanitr_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","kintu sulemAn tadarthaM mandiram ekaM nirmmitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","tathApi yaH sarvvoparisthaH sa kasmiMshchid hastakR^ite mandire nivasatIti nahi, bhaviShyadvAdI kathAmetAM kathayati, yathA, ");
INSERT INTO sanitr_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","paresho vadati svargo rAjasiMhAsanaM mama| madIyaM pAdapITha ncha pR^ithivI bhavati dhruvaM| tarhi yUyaM kR^ite me kiM pranirmmAsyatha mandiraM| vishrAmAya madIyaM vA sthAnaM kiM vidyate tviha| ");
INSERT INTO sanitr_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","sarvvANyetAni vastUni kiM me hastakR^itAni na|| ");
INSERT INTO sanitr_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","he anAj nAgrAhakA antaHkaraNe shravaNe chApavitralokAH yUyam anavarataM pavitrasyAtmanaH prAtikUlyam Acharatha, yuShmAkaM pUrvvapuruShA yAdR^ishA yUyamapi tAdR^ishAH| ");
INSERT INTO sanitr_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","yuShmAkaM pUrvvapuruShAH kaM bhaviShyadvAdinaM nAtADayan? ye tasya dhArmmikasya janasyAgamanakathAM kathitavantastAn aghnan yUyam adhUnA vishvAsaghAtino bhUtvA taM dhArmmikaM janam ahata| ");
INSERT INTO sanitr_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","yUyaM svargIyadUtagaNena vyavasthAM prApyApi tAM nAcharatha| ");
INSERT INTO sanitr_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","imAM kathAM shrutvA te manaHsu biddhAH santastaM prati dantagharShaNam akurvvan| ");
INSERT INTO sanitr_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","kintu stiphAnaH pavitreNAtmanA pUrNo bhUtvA gagaNaM prati sthiradR^iShTiM kR^itvA Ishvarasya dakShiNe daNDAyamAnaM yIshu ncha vilokya kathitavAn; ");
INSERT INTO sanitr_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","pashya,meghadvAraM muktam Ishvarasya dakShiNe sthitaM mAnavasuta ncha pashyAmi| ");
INSERT INTO sanitr_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","tadA te prochchaiH shabdaM kR^itvA karNeShva NgulI rnidhAya ekachittIbhUya tam Akraman| ");
INSERT INTO sanitr_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","pashchAt taM nagarAd bahiH kR^itvA prastarairAghnan sAkShiNo lAkAH shaulanAmno yUnashcharaNasannidhau nijavastrANi sthApitavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","anantaraM he prabho yIshe madIyamAtmAnaM gR^ihANa stiphAnasyeti prArthanavAkyavadanasamaye te taM prastarairAghnan| ");
INSERT INTO sanitr_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","tasmAt sa jAnunI pAtayitvA prochchaiH shabdaM kR^itvA, he prabhe pApametad eteShu mA sthApaya, ityuktvA mahAnidrAM prApnot| ");
INSERT INTO sanitr_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","tasya hatyAkaraNaM shaulopi samamanyata| tasmin samaye yirUshAlamnagarasthAM maNDalIM prati mahAtADanAyAM jAtAyAM preritalokAn hitvA sarvve.apare yihUdAshomiroNadeshayo rnAnAsthAne vikIrNAH santo gatAH| ");
INSERT INTO sanitr_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","anyachcha bhaktalokAstaM stiphAnaM shmashAne sthApayitvA bahu vyalapan| ");
INSERT INTO sanitr_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","kintu shaulo gR^ihe gR^ihe bhramitvA striyaH puruShAMshcha dhR^itvA kArAyAM baddhvA maNDalyA mahotpAtaM kR^itavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","anyachcha ye vikIrNA abhavan te sarvvatra bhramitvA susaMvAdaM prAchArayan| ");
INSERT INTO sanitr_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","tadA philipaH shomiroNnagaraM gatvA khrIShTAkhyAnaM prAchArayat; ");
INSERT INTO sanitr_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","tato.ashuchi-bhR^itagrastalokebhyo bhUtAshchItkR^ityAgachChan tathA bahavaH pakShAghAtinaH kha njA lokAshcha svasthA abhavan| ");
INSERT INTO sanitr_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","tasmAt lAkA IdR^ishaM tasyAshcharyyaM karmma vilokya nishamya cha sarvva ekachittIbhUya tenoktAkhyAne manAMsi nyadadhuH| ");
INSERT INTO sanitr_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","tasminnagare mahAnandashchAbhavat| ");
INSERT INTO sanitr_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","tataH pUrvvaM tasminnagare shimonnAmA kashchijjano bahvI rmAyAkriyAH kR^itvA svaM ka nchana mahApuruShaM prochya shomiroNIyAnAM mohaM janayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","tasmAt sa mAnuSha Ishvarasya mahAshaktisvarUpa ityuktvA bAlavR^iddhavanitAH sarvve lAkAstasmin manAMsi nyadadhuH| ");
INSERT INTO sanitr_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","sa bahukAlAn mAyAvikriyayA sarvvAn atIva mohayA nchakAra, tasmAt te taM menire| ");
INSERT INTO sanitr_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","kintvIshvarasya rAjyasya yIshukhrIShTasya nAmnashchAkhyAnaprachAriNaH philipasya kathAyAM vishvasya teShAM strIpuruShobhayalokA majjitA abhavan| ");
INSERT INTO sanitr_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","sheShe sa shimonapi svayaM pratyait tato majjitaH san philipena kR^itAm AshcharyyakriyAM lakShaNa ncha vilokyAsambhavaM manyamAnastena saha sthitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","itthaM shomiroNdeshIyalokA Ishvarasya kathAm agR^ihlan iti vArttAM yirUshAlamnagarasthapreritAH prApya pitaraM yohana ncha teShAM nikaTe preShitavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","tatastau tat sthAnam upasthAya lokA yathA pavitram AtmAnaM prApnuvanti tadarthaM prArthayetAM| ");
INSERT INTO sanitr_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","yataste purA kevalaprabhuyIsho rnAmnA majjitamAtrA abhavan, na tu teShAM madhye kamapi prati pavitrasyAtmana AvirbhAvo jAtaH| ");
INSERT INTO sanitr_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","kintu preritAbhyAM teShAM gAtreShu kareShvarpiteShu satsu te pavitram AtmAnam prApnuvan| ");
INSERT INTO sanitr_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","itthaM lokAnAM gAtreShu preritayoH karArpaNena tAn pavitram AtmAnaM prAptAn dR^iShTvA sa shimon tayoH samIpe mudrA AnIya kathitavAn; ");
INSERT INTO sanitr_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ahaM yasya gAtre hastam arpayiShyAmi tasyApi yathetthaM pavitrAtmaprApti rbhavati tAdR^ishIM shaktiM mahyaM dattaM| ");
INSERT INTO sanitr_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","kintu pitarastaM pratyavadat tava mudrAstvayA vinashyantu yata Ishvarasya dAnaM mudrAbhiH krIyate tvamitthaM buddhavAn; ");
INSERT INTO sanitr_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","IshvarAya tAvantaHkaraNaM saralaM nahi, tasmAd atra tavAMsho.adhikArashcha kopi nAsti| ");
INSERT INTO sanitr_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ata etatpApahetoH khedAnvitaH san kenApi prakAreNa tava manasa etasyAH kukalpanAyAH kShamA bhavati, etadartham Ishvare prArthanAM kuru; ");
INSERT INTO sanitr_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","yatastvaM tiktapitte pApasya bandhane cha yadasi tanmayA buddham| ");
INSERT INTO sanitr_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","tadA shimon akathayat tarhi yuvAbhyAmuditA kathA mayi yathA na phalati tadarthaM yuvAM mannimittaM prabhau prArthanAM kurutaM| ");
INSERT INTO sanitr_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","anena prakAreNa tau sAkShyaM dattvA prabhoH kathAM prachArayantau shomiroNIyAnAm anekagrAmeShu susaMvAda ncha prachArayantau yirUshAlamnagaraM parAvR^itya gatau| ");
INSERT INTO sanitr_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","tataH param Ishvarasya dUtaH philipam ityAdishat, tvamutthAya dakShiNasyAM dishi yo mArgo prAntarasya madhyena yirUshAlamo .asAnagaraM yAti taM mArgaM gachCha| ");
INSERT INTO sanitr_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","tataH sa utthAya gatavAn; tadA kandAkInAmnaH kUshlokAnAM rAj nyAH sarvvasampatteradhIshaH kUshadeshIya ekaH ShaNDo bhajanArthaM yirUshAlamnagaram Agatya ");
INSERT INTO sanitr_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","punarapi rathamAruhya yishayiyanAmno bhaviShyadvAdino granthaM paThan pratyAgachChati| ");
INSERT INTO sanitr_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","etasmin samaye AtmA philipam avadat, tvam rathasya samIpaM gatvA tena sArddhaM mila| ");
INSERT INTO sanitr_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","tasmAt sa dhAvan tasya sannidhAvupasthAya tena paThyamAnaM yishayiyathaviShyadvAdino vAkyaM shrutvA pR^iShTavAn yat paThasi tat kiM budhyase? ");
INSERT INTO sanitr_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","tataH sa kathitavAn kenachinna bodhitohaM kathaM budhyeya? tataH sa philipaM rathamAroDhuM svena sArddham upaveShTu ncha nyavedayat| ");
INSERT INTO sanitr_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","sa shAstrasyetadvAkyaM paThitavAn yathA, samAnIyata ghAtAya sa yathA meShashAvakaH| lomachChedakasAkShAchcha meShashcha nIravo yathA| Abadhya vadanaM svIyaM tathA sa samatiShThata| ");
INSERT INTO sanitr_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","anyAyena vichAreNa sa uchChinno .abhavat tadA| tatkAlInamanuShyAn ko jano varNayituM kShamaH| yato jIvannR^iNAM deshAt sa uchChinno .abhavat dhruvaM| ");
INSERT INTO sanitr_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","anantaraM sa philipam avadat nivedayAmi, bhaviShyadvAdI yAmimAM kathAM kathayAmAsa sa kiM svasmin vA kasmiMshchid anyasmin? ");
INSERT INTO sanitr_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","tataH philipastatprakaraNam Arabhya yIshorupAkhyAnaM tasyAgre prAstaut| ");
INSERT INTO sanitr_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","itthaM mArgeNa gachChantau jalAshayasya samIpa upasthitau; tadA klIbo.avAdIt pashyAtra sthAne jalamAste mama majjane kA bAdhA? ");
INSERT INTO sanitr_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","tataH philipa uttaraM vyAharat svAntaHkaraNena sAkaM yadi pratyeShi tarhi bAdhA nAsti| tataH sa kathitavAn yIshukhrIShTa Ishvarasya putra ityahaM pratyemi| ");
INSERT INTO sanitr_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","tadA rathaM sthagitaM karttum AdiShTe philipaklIbau dvau jalam avAruhatAM; tadA philipastam majjayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","tatpashchAt jalamadhyAd utthitayoH satoH parameshvarasyAtmA philipaM hR^itvA nItavAn, tasmAt klIbaH punastaM na dR^iShTavAn tathApi hR^iShTachittaH san svamArgeNa gatavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","philipashchAsdodnagaram upasthAya tasmAt kaisariyAnagara upasthitikAlaparyyanataM sarvvasminnagare susaMvAdaM prachArayan gatavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","tatkAlaparyyanataM shaulaH prabhoH shiShyANAM prAtikUlyena tADanAbadhayoH kathAM niHsArayan mahAyAjakasya sannidhiM gatvA ");
INSERT INTO sanitr_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","striyaM puruSha ncha tanmatagrAhiNaM yaM ka nchit pashyati tAn dhR^itvA baddhvA yirUshAlamam AnayatItyAshayena dammeShaknagarIyaM dharmmasamAjAn prati patraM yAchitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","gachChan tu dammeShaknagaranikaTa upasthitavAn; tato.akasmAd AkAshAt tasya chaturdikShu tejasaH prakAshanAt sa bhUmAvapatat| ");
INSERT INTO sanitr_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","pashchAt he shaula he shaula kuto mAM tADayasi? svaM prati proktam etaM shabdaM shrutvA ");
INSERT INTO sanitr_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","sa pR^iShTavAn, he prabho bhavAn kaH? tadA prabhurakathayat yaM yIshuM tvaM tADayasi sa evAhaM; kaNTakasya mukhe padAghAtakaraNaM tava kaShTam| ");
INSERT INTO sanitr_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","tadA kampamAno vismayApannashcha sovadat he prabho mayA kiM karttavyaM? bhavata ichChA kA? tataH prabhurAj nApayad utthAya nagaraM gachCha tatra tvayA yat karttavyaM tad vadiShyate| ");
INSERT INTO sanitr_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","tasya sa Ngino lokA api taM shabdaM shrutavantaH kintu kamapi na dR^iShTvA stabdhAH santaH sthitavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","anantaraM shaulo bhUmita utthAya chakShuShI unmIlya kamapi na dR^iShTavAn| tadA lokAstasya hastau dhR^itvA dammeShaknagaram Anayan| ");
INSERT INTO sanitr_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","tataH sa dinatrayaM yAvad andho bhUtvA na bhuktavAn pItavAMshcha| ");
INSERT INTO sanitr_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","tadanantaraM prabhustaddammeShaknagaravAsina ekasmai shiShyAya darshanaM datvA AhUtavAn he ananiya| tataH sa pratyavAdIt, he prabho pashya shR^iNomi| ");
INSERT INTO sanitr_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","tadA prabhustamAj nApayat tvamutthAya saralanAmAnaM mArgaM gatvA yihUdAniveshane tArShanagarIyaM shaulanAmAnaM janaM gaveShayan pR^ichCha; ");
INSERT INTO sanitr_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","pashya sa prArthayate, tathA ananiyanAmaka eko janastasya samIpam Agatya tasya gAtre hastArpaNaM kR^itvA dR^iShTiM dadAtItthaM svapne dR^iShTavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","tasmAd ananiyaH pratyavadat he prabho yirUshAlami pavitralokAn prati so.anekahiMsAM kR^itavAn; ");
INSERT INTO sanitr_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","atra sthAne cha ye lokAstava nAmni prArthayanti tAnapi baddhuM sa pradhAnayAjakebhyaH shaktiM prAptavAn, imAM kathAm aham anekeShAM mukhebhyaH shrutavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","kintu prabhurakathayat, yAhi bhinnadeshIyalokAnAM bhUpatInAm isrAyellokAnA ncha nikaTe mama nAma prachArayituM sa jano mama manonItapAtramAste| ");
INSERT INTO sanitr_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","mama nAmanimitta ncha tena kiyAn mahAn klesho bhoktavya etat taM darshayiShyAmi| ");
INSERT INTO sanitr_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","tato .ananiyo gatvA gR^ihaM pravishya tasya gAtre hastArpraNaM kR^itvA kathitavAn, he bhrAtaH shaula tvaM yathA dR^iShTiM prApnoShi pavitreNAtmanA paripUrNo bhavasi cha, tadarthaM tavAgamanakAle yaH prabhuyIshustubhyaM darshanam adadAt sa mAM preShitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ityuktamAtre tasya chakShurbhyAm mInashalkavad vastuni nirgate tatkShaNAt sa prasannachakShu rbhUtvA protthAya majjito.abhavat bhuktvA pItvA sabalobhavachcha| ");
INSERT INTO sanitr_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","tataH paraM shaulaH shiShyaiH saha katipayadivasAn tasmin dammeShakanagare sthitvA.avilambaM ");
INSERT INTO sanitr_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","sarvvabhajanabhavanAni gatvA yIshurIshvarasya putra imAM kathAM prAchArayat| ");
INSERT INTO sanitr_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","tasmAt sarvve shrotArashchamatkR^itya kathitavanto yo yirUshAlamnagara etannAmnA prArthayitR^ilokAn vinAshitavAn evam etAdR^ishalokAn baddhvA pradhAnayAjakanikaTaM nayatItyAshayA etatsthAnamapyAgachChat saeva kimayaM na bhavati? ");
INSERT INTO sanitr_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","kintu shaulaH kramasha utsAhavAn bhUtvA yIshurIshvareNAbhiShikto jana etasmin pramANaM datvA dammeShak-nivAsiyihUdIyalokAn niruttarAn akarot| ");
INSERT INTO sanitr_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","itthaM bahutithe kAle gate yihUdIyalokAstaM hantuM mantrayAmAsuH ");
INSERT INTO sanitr_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","kintu shaulasteShAmetasyA mantraNAyA vArttAM prAptavAn| te taM hantuM tu divAnishaM guptAH santo nagarasya dvAre.atiShThan; ");
INSERT INTO sanitr_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","tasmAt shiShyAstaM nItvA rAtrau piTake nidhAya prAchIreNAvArohayan| ");
INSERT INTO sanitr_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","tataH paraM shaulo yirUshAlamaM gatvA shiShyagaNena sArddhaM sthAtum aihat, kintu sarvve tasmAdabibhayuH sa shiShya iti cha na pratyayan| ");
INSERT INTO sanitr_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","etasmAd barNabbAstaM gR^ihItvA preritAnAM samIpamAnIya mArgamadhye prabhuH kathaM tasmai darshanaM dattavAn yAH kathAshcha kathitavAn sa cha yathAkShobhaH san dammeShaknagare yIsho rnAma prAchArayat etAn sarvvavR^ittAntAn tAn j nApitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","tataH shaulastaiH saha yirUshAlami kAlaM yApayan nirbhayaM prabho ryIsho rnAma prAchArayat| ");
INSERT INTO sanitr_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","tasmAd anyadeshIyalokaiH sArddhaM vivAdasyopasthitatvAt te taM hantum acheShTanta| ");
INSERT INTO sanitr_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","kintu bhrAtR^igaNastajj nAtvA taM kaisariyAnagaraM nItvA tArShanagaraM preShitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","itthaM sati yihUdiyAgAlIlshomiroNadeshIyAH sarvvA maNDalyo vishrAmaM prAptAstatastAsAM niShThAbhavat prabho rbhiyA pavitrasyAtmanaH sAntvanayA cha kAlaM kShepayitvA bahusaMkhyA abhavan| ");
INSERT INTO sanitr_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","tataH paraM pitaraH sthAne sthAne bhramitvA sheShe lodnagaranivAsipavitralokAnAM samIpe sthitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","tadA tatra pakShAghAtavyAdhinAShTau vatsarAn shayyAgatam aineyanAmAnaM manuShyaM sAkShat prApya tamavadat, ");
INSERT INTO sanitr_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","he aineya yIshukhrIShTastvAM svastham akArShIt, tvamutthAya svashayyAM nikShipa, ityuktamAtre sa udatiShThat| ");
INSERT INTO sanitr_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","etAdR^ishaM dR^iShTvA lodshAroNanivAsino lokAH prabhuM prati parAvarttanta| ");
INSERT INTO sanitr_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","apara ncha bhikShAdAnAdiShu nAnakriyAsu nityaM pravR^ittA yA yAphonagaranivAsinI TAbithAnAmA shiShyA yAM darkkAM arthAd hariNImayuktvA Ahvayan sA nArI ");
INSERT INTO sanitr_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","tasmin samaye rugnA satI prANAn atyajat, tato lokAstAM prakShAlyoparisthaprakoShThe shAyayitvAsthApayan| ");
INSERT INTO sanitr_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","lodnagaraM yAphonagarasya samIpasthaM tasmAttatra pitara Aste, iti vArttAM shrutvA tUrNaM tasyAgamanArthaM tasmin vinayamuktvA shiShyagaNo dvau manujau preShitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","tasmAt pitara utthAya tAbhyAM sArddham AgachChat, tatra tasmin upasthita uparisthaprakoShThaM samAnIte cha vidhavAH svAbhiH saha sthitikAle darkkayA kR^itAni yAnyuttarIyANi paridheyAni cha tAni sarvvANi taM darshayitvA rudatyashchatasR^iShu dikShvatiShThan| ");
INSERT INTO sanitr_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","kintu pitarastAH sarvvA bahiH kR^itvA jAnunI pAtayitvA prArthitavAn; pashchAt shavaM prati dR^iShTiM kR^itvA kathitavAn, he TAbIthe tvamuttiShTha, iti vAkya ukte sA strI chakShuShI pronmIlya pitaram avalokyotthAyopAvishat| ");
INSERT INTO sanitr_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","tataH pitarastasyAH karau dhR^itvA uttolya pavitralokAn vidhavAshchAhUya teShAM nikaTe sajIvAM tAM samArpayat| ");
INSERT INTO sanitr_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","eShA kathA samastayAphonagaraM vyAptA tasmAd aneke lokAH prabhau vyashvasan| ");
INSERT INTO sanitr_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","apara ncha pitarastadyAphonagarIyasya kasyachit shimonnAmnashcharmmakArasya gR^ihe bahudinAni nyavasat| ");
INSERT INTO sanitr_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","kaisariyAnagara itAliyAkhyasainyAntargataH karNIliyanAmA senApatirAsIt ");
INSERT INTO sanitr_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","sa saparivAro bhakta IshvaraparAyaNashchAsIt; lokebhyo bahUni dAnAdIni datvA nirantaram Ishvare prArthayA nchakre| ");
INSERT INTO sanitr_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ekadA tR^itIyapraharavelAyAM sa dR^iShTavAn Ishvarasyaiko dUtaH saprakAshaM tatsamIpam Agatya kathitavAn, he karNIliya| ");
INSERT INTO sanitr_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","kintu sa taM dR^iShTvA bhIto.akathayat, he prabho kiM? tadA tamavadat tava prArthanA dAnAdi cha sAkShisvarUpaM bhUtveshvarasya gocharamabhavat| ");
INSERT INTO sanitr_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","idAnIM yAphonagaraM prati lokAn preShya samudratIre shimonnAmnashcharmmakArasya gR^ihe pravAsakArI pitaranAmnA vikhyAto yaH shimon tam AhvAyaya; ");
INSERT INTO sanitr_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","tasmAt tvayA yadyat karttavyaM tattat sa vadiShyati| ");
INSERT INTO sanitr_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ityupadishya dUte prasthite sati karNIliyaH svagR^ihasthAnAM dAsAnAM dvau janau nityaM svasa NginAM sainyAnAm ekAM bhaktasenA nchAhUya ");
INSERT INTO sanitr_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","sakalametaM vR^ittAntaM vij nApya yAphonagaraM tAn prAhiNot| ");
INSERT INTO sanitr_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","parasmin dine te yAtrAM kR^itvA yadA nagarasya samIpa upAtiShThan, tadA pitaro dvitIyapraharavelAyAM prArthayituM gR^ihapR^iShTham Arohat| ");
INSERT INTO sanitr_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","etasmin samaye kShudhArttaH san ki nchid bhoktum aichChat kintu teShAm annAsAdanasamaye sa mUrchChitaH sannapatat| ");
INSERT INTO sanitr_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","tato meghadvAraM muktaM chaturbhiH koNai rlambitaM bR^ihadvastramiva ki nchana bhAjanam AkAshAt pR^ithivIm avArohatIti dR^iShTavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","tanmadhye nAnaprakArA grAmyavanyapashavaH khecharorogAmiprabhR^itayo jantavashchAsan| ");
INSERT INTO sanitr_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","anantaraM he pitara utthAya hatvA bhuMkShva tampratIyaM gagaNIyA vANI jAtA| ");
INSERT INTO sanitr_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","tadA pitaraH pratyavadat, he prabho IdR^ishaM mA bhavatu, aham etat kAlaM yAvat niShiddham ashuchi vA dravyaM ki nchidapi na bhuktavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","tataH punarapi tAdR^ishI vihayasIyA vANI jAtA yad IshvaraH shuchi kR^itavAn tat tvaM niShiddhaM na jAnIhi| ");
INSERT INTO sanitr_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","itthaM triH sati tat pAtraM punarAkR^iShTaM AkAsham agachChat| ");
INSERT INTO sanitr_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","tataH paraM yad darshanaM prAptavAn tasya ko bhAva ityatra pitaro manasA sandegdhi, etasmin samaye karNIliyasya te preShitA manuShyA dvArasya sannidhAvupasthAya, ");
INSERT INTO sanitr_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","shimono gR^ihamanvichChantaH sampR^iChyAhUya kathitavantaH pitaranAmnA vikhyAto yaH shimon sa kimatra pravasati? ");
INSERT INTO sanitr_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","yadA pitarastaddarshanasya bhAvaM manasAndolayati tadAtmA tamavadat, pashya trayo janAstvAM mR^igayante| ");
INSERT INTO sanitr_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","tvam utthAyAvaruhya niHsandehaM taiH saha gachCha mayaiva te preShitAH| ");
INSERT INTO sanitr_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","tasmAt pitaro.avaruhya karNIliyapreritalokAnAM nikaTamAgatya kathitavAn pashyata yUyaM yaM mR^igayadhve sa janohaM, yUyaM kinnimittam AgatAH? ");
INSERT INTO sanitr_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","tataste pratyavadan karNIliyanAmA shuddhasattva IshvaraparAyaNo yihUdIyadeshasthAnAM sarvveShAM sannidhau sukhyAtyApanna ekaH senApati rnijagR^ihaM tvAmAhUya netuM tvattaH kathA shrotu ncha pavitradUtena samAdiShTaH| ");
INSERT INTO sanitr_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","tadA pitarastAnabhyantaraM nItvA teShAmAtithyaM kR^itavAn, pare.ahani taiH sArddhaM yAtrAmakarot, yAphonivAsinAM bhrAtR^iNAM kiyanto janAshcha tena saha gatAH| ");
INSERT INTO sanitr_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","parasmin divase kaisariyAnagaramadhyapraveshasamaye karNIliyo j nAtibandhUn AhUyAnIya tAn apekShya sthitaH| ");
INSERT INTO sanitr_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","pitare gR^iha upasthite karNIliyastaM sAkShAtkR^itya charaNayoH patitvA prANamat| ");
INSERT INTO sanitr_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","pitarastamutthApya kathitavAn, uttiShThAhamapi mAnuShaH| ");
INSERT INTO sanitr_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","tadA karNIliyena sAkam Alapan gR^ihaM prAvishat tanmadhye cha bahulokAnAM samAgamaM dR^iShTvA tAn avadat, ");
INSERT INTO sanitr_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","anyajAtIyalokaiH mahAlapanaM vA teShAM gR^ihamadhye praveshanaM yihUdIyAnAM niShiddham astIti yUyam avagachChatha; kintu kamapi mAnuSham avyavahAryyam ashuchiM vA j nAtuM mama nochitam iti parameshvaro mAM j nApitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","iti hetorAhvAnashravaNamAtrAt kA nchanApattim akR^itvA yuShmAkaM samIpam Agatosmi; pR^ichChAmi yUyaM kinnimittaM mAm AhUyata? ");
INSERT INTO sanitr_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","tadA karNIliyaH kathitavAn, adya chatvAri dinAni jAtAni etAvadvelAM yAvad aham anAhAra Asan tatastR^itIyaprahare sati gR^ihe prArthanasamaye tejomayavastrabhR^id eko jano mama samakShaM tiShThan etAM kathAm akathayat, ");
INSERT INTO sanitr_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","he karNIliya tvadIyA prArthanA Ishvarasya karNagocharIbhUtA tava dAnAdi cha sAkShisvarUpaM bhUtvA tasya dR^iShTigocharamabhavat| ");
INSERT INTO sanitr_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ato yAphonagaraM prati lokAn prahitya tatra samudratIre shimonnAmnaH kasyachichcharmmakArasya gR^ihe pravAsakArI pitaranAmnA vikhyAto yaH shimon tamAhUाyaya; tataH sa Agatya tvAm upadekShyati| ");
INSERT INTO sanitr_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","iti kAraNAt tatkShaNAt tava nikaTe lokAn preShitavAn, tvamAgatavAn iti bhadraM kR^itavAn| Ishvaro yAnyAkhyAnAni kathayitum Adishat tAni shrotuM vayaM sarvve sAmpratam Ishvarasya sAkShAd upasthitAH smaH| ");
INSERT INTO sanitr_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","tadA pitara imAM kathAM kathayitum ArabdhavAn, Ishvaro manuShyANAm apakShapAtI san ");
INSERT INTO sanitr_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","yasya kasyachid deshasya yo lokAstasmAdbhItvA satkarmma karoti sa tasya grAhyo bhavati, etasya nishchayam upalabdhavAnaham| ");
INSERT INTO sanitr_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","sarvveShAM prabhu ryo yIshukhrIShTastena Ishvara isrAyelvaMshAnAM nikaTe susaMvAdaM preShya sammelanasya yaM saMvAdaM prAchArayat taM saMvAdaM yUyaM shrutavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","yato yohanA majjane prachArite sati sa gAlIladeshamArabhya samastayihUdIyadeshaM vyApnot; ");
INSERT INTO sanitr_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","phalata IshvareNa pavitreNAtmanA shaktyA chAbhiShikto nAsaratIyayIshuH sthAne sthAne bhraman sukriyAM kurvvan shaitAnA kliShTAn sarvvalokAn svasthAn akarot, yata Ishvarastasya sahAya AsIt; ");
INSERT INTO sanitr_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","vaya ncha yihUdIyadeshe yirUshAlamnagare cha tena kR^itAnAM sarvveShAM karmmaNAM sAkShiNo bhavAmaH| lokAstaM krushe viddhvA hatavantaH, ");
INSERT INTO sanitr_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","kintu tR^itIyadivase IshvarastamutthApya saprakAsham adarshayat| ");
INSERT INTO sanitr_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","sarvvalokAnAM nikaTa iti na hi, kintu tasmin shmashAnAdutthite sati tena sArddhaM bhojanaM pAna ncha kR^itavanta etAdR^ishA Ishvarasya manonItAH sAkShiNo ye vayam asmAkaM nikaTe tamadarshayat| ");
INSERT INTO sanitr_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","jIvitamR^itobhayalokAnAM vichAraM karttum Ishvaro yaM niyuktavAn sa eva sa janaH, imAM kathAM prachArayituM tasmin pramANaM dAtu ncha so.asmAn Aj nApayat| ");
INSERT INTO sanitr_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","yastasmin vishvasiti sa tasya nAmnA pApAnmukto bhaviShyati tasmin sarvve bhaviShyadvAdinopi etAdR^ishaM sAkShyaM dadati| ");
INSERT INTO sanitr_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","pitarasyaitatkathAkathanakAle sarvveShAM shrotR^iNAmupari pavitra AtmAvArohat| ");
INSERT INTO sanitr_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","tataH pitareNa sArddham AgatAstvakChedino vishvAsino lokA anyadeshIyebhyaH pavitra Atmani datte sati ");
INSERT INTO sanitr_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","te nAnAjAtIyabhAShAbhiH kathAM kathayanta IshvaraM prashaMsanti, iti dR^iShTvA shrutvA cha vismayam Apadyanta| ");
INSERT INTO sanitr_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","tadA pitaraH kathitavAn, vayamiva ye pavitram AtmAnaM prAptAsteShAM jalamajjanaM kiM kopi niSheddhuM shaknoti? ");
INSERT INTO sanitr_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","tataH prabho rnAmnA majjitA bhavateti tAnAj nApayat| anantaraM te svaiH sArddhaM katipayadinAni sthAtuM prArthayanta| ");
INSERT INTO sanitr_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","itthaM bhinnadeshIyalokA apIshvarasya vAkyam agR^ihlan imAM vArttAM yihUdIyadeshasthapreritA bhrAtR^igaNashcha shrutavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","tataH pitare yirUshAlamnagaraM gatavati tvakChedino lokAstena saha vivadamAnA avadan, ");
INSERT INTO sanitr_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","tvam atvakChedilokAnAM gR^ihaM gatvA taiH sArddhaM bhuktavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","tataH pitara AditaH kramashastatkAryyasya sarvvavR^ittAntamAkhyAtum ArabdhavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","yAphonagara ekadAhaM prArthayamAno mUrchChitaH san darshanena chaturShu koNeShu lambanamAnaM vR^ihadvastramiva pAtramekam AkAshadavaruhya mannikaTam AgachChad apashyam| ");
INSERT INTO sanitr_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","pashchAt tad ananyadR^iShTyA dR^iShTvA vivichya tasya madhye nAnAprakArAn grAmyavanyapashUn urogAmikhecharAMshcha dR^iShTavAn; ");
INSERT INTO sanitr_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","he pitara tvamutthAya gatvA bhuMkShva mAM sambodhya kathayantaM shabdamekaM shrutavAMshcha| ");
INSERT INTO sanitr_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","tatohaM pratyavadaM, he prabho netthaM bhavatu, yataH ki nchana niShiddham ashuchi dravyaM vA mama mukhamadhyaM kadApi na prAvishat| ");
INSERT INTO sanitr_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","aparam Ishvaro yat shuchi kR^itavAn tanniShiddhaM na jAnIhi dvi rmAmpratIdR^ishI vihAyasIyA vANI jAtA| ");
INSERT INTO sanitr_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","triritthaM sati tat sarvvaM punarAkAsham AkR^iShTaM| ");
INSERT INTO sanitr_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","pashchAt kaisariyAnagarAt trayo janA mannikaTaM preShitA yatra niveshane sthitohaM tasmin samaye tatropAtiShThan| ");
INSERT INTO sanitr_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","tadA niHsandehaM taiH sArddhaM yAtum AtmA mAmAdiShTavAn; tataH paraM mayA sahaiteShu ShaDbhrAtR^iShu gateShu vayaM tasya manujasya gR^ihaM prAvishAma| ");
INSERT INTO sanitr_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","sosmAkaM nikaTe kathAmetAm akathayat ekadA dUta ekaH pratyakShIbhUya mama gR^ihamadhye tiShTan mAmityAj nApitavAn, yAphonagaraM prati lokAn prahitya pitaranAmnA vikhyAtaM shimonam AhUyaya; ");
INSERT INTO sanitr_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","tatastava tvadIyaparivArANA ncha yena paritrANaM bhaviShyati tat sa upadekShyati| ");
INSERT INTO sanitr_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","ahaM tAM kathAmutthApya kathitavAn tena prathamam asmAkam upari yathA pavitra AtmAvarUDhavAn tathA teShAmapyupari samavarUDhavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","tena yohan jale majjitavAn iti satyaM kintu yUyaM pavitra Atmani majjitA bhaviShyatha, iti yadvAkyaM prabhuruditavAn tat tadA mayA smR^itam| ");
INSERT INTO sanitr_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","ataH prabhA yIshukhrIShTe pratyayakAriNo ye vayam asmabhyam Ishvaro yad dattavAn tat tebhyo lokebhyopi dattavAn tataH kohaM? kimaham IshvaraM vArayituM shaknomi? ");
INSERT INTO sanitr_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","kathAmetAM shruvA te kShAntA Ishvarasya guNAn anukIrttya kathitavantaH, tarhi paramAyuHprAptinimittam IshvaronyadeshIyalokebhyopi manaHparivarttanarUpaM dAnam adAt| ");
INSERT INTO sanitr_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","stiphAnaM prati upadrave ghaTite ye vikIrNA abhavan tai phainIkIkuprAntiyakhiyAsu bhramitvA kevalayihUdIyalokAn vinA kasyApyanyasya samIpa Ishvarasya kathAM na prAchArayan| ");
INSERT INTO sanitr_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","aparaM teShAM kuprIyAH kurInIyAshcha kiyanto janA AntiyakhiyAnagaraM gatvA yUnAnIyalokAnAM samIpepi prabhoryIshoH kathAM prAchArayan| ");
INSERT INTO sanitr_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","prabhoH karasteShAM sahAya AsIt tasmAd aneke lokA vishvasya prabhuM prati parAvarttanta| ");
INSERT INTO sanitr_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","iti vArttAyAM yirUshAlamasthamaNDalIyalokAnAM karNagocharIbhUtAyAm AntiyakhiyAnagaraM gantu te barNabbAM prairayan| ");
INSERT INTO sanitr_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","tato barNabbAstatra upasthitaH san IshvarasyAnugrahasya phalaM dR^iShTvA sAnando jAtaH, ");
INSERT INTO sanitr_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","sa svayaM sAdhu rvishvAsena pavitreNAtmanA cha paripUrNaH san ganoniShTayA prabhAvAsthAM karttuM sarvvAn upadiShTavAn tena prabhoH shiShyA aneke babhUvuH| ");
INSERT INTO sanitr_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","sheShe shaulaM mR^igayituM barNabbAstArShanagaraM prasthitavAn| tatra tasyoddeshaM prApya tam AntiyakhiyAnagaram Anayat; ");
INSERT INTO sanitr_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","tatastau maNDalIsthalokaiH sabhAM kR^itvA saMvatsaramekaM yAvad bahulokAn upAdishatAM; tasmin AntiyakhiyAnagare shiShyAH prathamaM khrIShTIyanAmnA vikhyAtA abhavan| ");
INSERT INTO sanitr_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","tataH paraM bhaviShyadvAdigaNe yirUshAlama AntiyakhiyAnagaram Agate sati ");
INSERT INTO sanitr_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","AgAbanAmA teShAmeka utthAya AtmanaH shikShayA sarvvadeshe durbhikShaM bhaviShyatIti j nApitavAn; tataH klaudiyakaisarasyAdhikAre sati tat pratyakSham abhavat| ");
INSERT INTO sanitr_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","tasmAt shiShyA ekaikashaH svasvashaktyanusArato yihUdIyadeshanivAsinAM bhratR^iNAM dinayApanArthaM dhanaM preShayituM nishchitya ");
INSERT INTO sanitr_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","barNabbAshaulayo rdvArA prAchInalokAnAM samIpaM tat preShitavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","tasmin samaye herod‌rAjo maNDalyAH kiyajjanebhyo duHkhaM dAtuM prArabhat| ");
INSERT INTO sanitr_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","visheShato yohanaH sodaraM yAkUbaM karavAlAghAten hatavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","tasmAd yihUdIyAH santuShTA abhavan iti vij nAya sa pitaramapi dharttuM gatavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","tadA kiNvashUnyapUpotsavasamaya upAtiShTat; ata utsave gate sati lokAnAM samakShaM taM bahirAneyyAmIti manasi sthirIkR^itya sa taM dhArayitvA rakShNArtham yeShAm ekaikasaMghe chatvAro janAH santi teShAM chaturNAM rakShakasaMghAnAM samIpe taM samarpya kArAyAM sthApitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","kintuM pitarasya kArAsthitikAraNAt maNDalyA lokA avishrAmam Ishvarasya samIpe prArthayanta| ");
INSERT INTO sanitr_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","anantaraM herodi taM bahirAnAyituM udyate sati tasyAM rAtrau pitaro rakShakadvayamadhyasthAne shR^i Nkhaladvayena baddhvaH san nidrita AsIt, dauvArikAshcha kArAyAH sammukhe tiShThanato dvAram arakShiShuH| ");
INSERT INTO sanitr_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","etasmin samaye parameshvarasya dUte samupasthite kArA dIptimatI jAtA; tataH sa dUtaH pitarasya kukShAvAvAtaM kR^itvA taM jAgarayitvA bhAShitavAn tUrNamuttiShTha; tatastasya hastasthashR^i NkhaladvayaM galat patitaM| ");
INSERT INTO sanitr_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","sa dUtastamavadat, baddhakaTiH san pAdayoH pAduke arpaya; tena tathA kR^ite sati dUtastam uktavAn gAtrIyavastraM gAtre nidhAya mama pashchAd ehi| ");
INSERT INTO sanitr_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","tataH pitarastasya pashchAd vrajana bahiragachChat, kintu dUtena karmmaitat kR^itamiti satyamaj nAtvA svapnadarshanaM j nAtavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","itthaM tau prathamAM dvitIyA ncha kArAM la NghitvA yena lauhanirmmitadvAreNa nagaraM gamyate tatsamIpaM prApnutAM; tatastasya kavATaM svayaM muktamabhavat tatastau tatsthAnAd bahi rbhUtvA mArgaikasya sImAM yAvad gatau; tato.akasmAt sa dUtaH pitaraM tyaktavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","tadA sa chetanAM prApya kathitavAn nijadUtaM prahitya parameshvaro herodo hastAd yihUdIyalokAnAM sarvvAshAyAshcha mAM samuddhR^itavAn ityahaM nishchayaM j nAtavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","sa vivichya mArkanAmrA vikhyAtasya yohano mAtu rmariyamo yasmin gR^ihe bahavaH sambhUya prArthayanta tanniveshanaM gataH| ");
INSERT INTO sanitr_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","pitareNa bahirdvAra Ahate sati rodAnAmA bAlikA draShTuM gatA| ");
INSERT INTO sanitr_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","tataH pitarasya svaraM shruvA sA harShayuktA satI dvAraM na mochayitvA pitaro dvAre tiShThatIti vArttAM vaktum abhyantaraM dhAvitvA gatavatI| ");
INSERT INTO sanitr_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","te prAvochan tvamunmattA jAtAsi kintu sA muhurmuhuruktavatI satyamevaitat| ");
INSERT INTO sanitr_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","tadA te kathitavantastarhi tasya dUto bhavet| ");
INSERT INTO sanitr_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","pitaro dvAramAhatavAn etasminnantare dvAraM mochayitvA pitaraM dR^iShTvA vismayaM prAptAH| ");
INSERT INTO sanitr_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","tataH pitaro niHshabdaM sthAtuM tAn prati hastena sa NketaM kR^itvA parameshvaro yena prakAreNa taM kArAyA uddhR^ityAnItavAn tasya vR^ittAntaM tAnaj nApayat, yUyaM gatvA yAkubaM bhrAtR^igaNa ncha vArttAmetAM vadatetyuktA sthAnAntaraM prasthitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","prabhAte sati pitaraH kva gata ityatra rakShakANAM madhye mahAn kalaho jAtaH| ");
INSERT INTO sanitr_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","herod bahu mR^igayitvA tasyoddeshe na prApte sati rakShakAn saMpR^ichChya teShAM prANAn hantum AdiShTavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","pashchAt sa yihUdIyapradeshAt kaisariyAnagaraM gatvA tatrAvAtiShThat| ");
INSERT INTO sanitr_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","sorasIdonadeshayo rlokebhyo herodi yuyutsau sati te sarvva ekamantraNAH santastasya samIpa upasthAya lvAstanAmAnaM tasya vastragR^ihAdhIshaM sahAyaM kR^itvA herodA sArddhaM sandhiM prArthayanta yatastasya rAj no deshena teShAM deshIyAnAM bharaNam abhavatM ");
INSERT INTO sanitr_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","ataH kutrachin nirupitadine herod rAjakIyaM parichChadaM paridhAya siMhAsane samupavishya tAn prati kathAm uktavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","tato lokA uchchaiHkAraM pratyavadan, eSha manujaravo na hi, IshvarIyaravaH| ");
INSERT INTO sanitr_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","tadA herod Ishvarasya sammAnaM nAkarot; tasmAddhetoH parameshvarasya dUto haThAt taM prAharat tenaiva sa kITaiH kShINaH san prANAn ajahAt| kintvIshvarasya kathA deshaM vyApya prabalAbhavat| tataH paraM barNabbAshaulau yasya karmmaNo bhAraM prApnutAM tAbhyAM tasmin sampAdite sati mArkanAmnA vikhyAto yo yohan taM sa NginaM kR^itvA yirUshAlamnagarAt pratyAgatau| ");
INSERT INTO sanitr_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","apara ncha barNabbAH, shimon yaM nigraM vadanti, kurInIyalUkiyo herodA rAj nA saha kR^itavidyAाbhyAso minahem, shaulashchaite ye kiyanto janA bhaviShyadvAdina upadeShTArashchAntiyakhiyAnagarasthamaNDalyAm Asan, ");
INSERT INTO sanitr_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","te yadopavAsaM kR^itveshvaram asevanta tasmin samaye pavitra AtmA kathitavAn ahaM yasmin karmmaNi barNabbAshailau niyuktavAn tatkarmma karttuM tau pR^ithak kuruta| ");
INSERT INTO sanitr_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","tatastairupavAsaprArthanayoH kR^itayoH satoste tayo rgAtrayo rhastArpaNaM kR^itvA tau vyasR^ijan| ");
INSERT INTO sanitr_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","tataH paraM tau pavitreNAtmanA preritau santau silUkiyAnagaram upasthAya samudrapathena kupropadvIpam agachChatAM| ");
INSERT INTO sanitr_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","tataH sAlAmInagaram upasthAya tatra yihUdIyAnAM bhajanabhavanAni gatveshvarasya kathAM prAchArayatAM; yohanapi tatsahacharo.abhavat| ");
INSERT INTO sanitr_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","itthaM te tasyopadvIpasya sarvvatra bhramantaH pAphanagaram upasthitAH; tatra suvivechakena sarjiyapaulanAmnA taddeshAdhipatinA saha bhaviShyadvAdino veshadhArI baryIshunAmA yo mAyAvI yihUdI AsIt taM sAkShAt prAptavataH| ");
INSERT INTO sanitr_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","taddeshAdhipa Ishvarasya kathAM shrotuM vA nChan paulabarNabbau nyamantrayat| ");
INSERT INTO sanitr_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","kintvilumA yaM mAyAvinaM vadanti sa deshAdhipatiM dharmmamArgAd bahirbhUtaM karttum ayatata| ");
INSERT INTO sanitr_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","tasmAt sholo.arthAt paulaH pavitreNAtmanA paripUrNaH san taM mAyAvinaM pratyananyadR^iShTiM kR^itvAkathayat, ");
INSERT INTO sanitr_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","he narakin dharmmadveShin kauTilyaduShkarmmaparipUrNa, tvaM kiM prabhoH satyapathasya viparyyayakaraNAt kadApi na nivarttiShyase? ");
INSERT INTO sanitr_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","adhunA parameshvarastava samuchitaM kariShyati tena katipayadinAni tvam andhaH san sUryyamapi na drakShyasi| tatkShaNAd rAtrivad andhakArastasya dR^iShTim AchChAditavAn; tasmAt tasya hastaM dharttuM sa lokamanvichChan itastato bhramaNaM kR^itavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","enAM ghaTanAM dR^iShTvA sa deshAdhipatiH prabhUpadeshAd vismitya vishvAsaM kR^itavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","tadanantaraM paulastatsa Nginau cha pAphanagarAt protaM chAlayitvA pamphuliyAdeshasya pargInagaram agachChan kintu yohan tayoH samIpAd etya yirUshAlamaM pratyAgachChat| ");
INSERT INTO sanitr_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","pashchAt tau pargIto yAtrAM kR^itvA pisidiyAdeshasya AntiyakhiyAnagaram upasthAya vishrAmavAre bhajanabhavanaM pravishya samupAvishatAM| ");
INSERT INTO sanitr_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","vyavasthAbhaviShyadvAkyayoH paThitayoH sato rhe bhrAtarau lokAn prati yuvayoH kAchid upadeshakathA yadyasti tarhi tAM vadataM tau prati tasya bhajanabhavanasyAdhipatayaH kathAm etAM kathayitvA praiShayan| ");
INSERT INTO sanitr_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ataH paula uttiShThan hastena sa NketaM kurvvan kathitavAn he isrAyelIyamanuShyA IshvaraparAyaNAH sarvve lokA yUyam avadhaddhaM| ");
INSERT INTO sanitr_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","eteShAmisrAyellokAnAm Ishvaro.asmAkaM pUrvvaparuShAn manonItAn katvA gR^ihItavAn tato misari deshe pravasanakAle teShAmunnatiM kR^itvA tasmAt svIyabAhubalena tAn bahiH kR^itvA samAnayat| ");
INSERT INTO sanitr_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","chatvAriMshadvatsarAn yAvachcha mahAprAntare teShAM bharaNaM kR^itvA ");
INSERT INTO sanitr_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","kinAndeshAntarvvarttINi saptarAjyAni nAshayitvA guTikApAtena teShu sarvvadesheShu tebhyo.adhikAraM dattavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","pa nchAshadadhikachatuHshateShu vatsareShu gateShu cha shimUyelbhaviShyadvAdiparyyantaM teShAmupari vichArayitR^in niyuktavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","taishcha rAj ni prArthite, Ishvaro binyAmIno vaMshajAtasya kIshaH putraM shaulaM chatvAriMshadvarShaparyyantaM teShAmupari rAjAnaM kR^itavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","pashchAt taM padachyutaM kR^itvA yo madiShTakriyAH sarvvAH kariShyati tAdR^ishaM mama manobhimatam ekaM janaM yishayaH putraM dAyUdaM prAptavAn idaM pramANaM yasmin dAyUdi sa dattavAn taM dAyUdaM teShAmupari rAjatvaM karttum utpAditavAna| ");
INSERT INTO sanitr_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","tasya svapratishrutasya vAkyasyAnusAreNa isrAyellokAnAM nimittaM teShAM manuShyANAM vaMshAd Ishvara ekaM yIshuM (trAtAram) udapAdayat| ");
INSERT INTO sanitr_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","tasya prakAshanAt pUrvvaM yohan isrAyellokAnAM sannidhau manaHparAvarttanarUpaM majjanaM prAchArayat| ");
INSERT INTO sanitr_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","yasya cha karmmaNoे bhAraM praptavAn yohan tan niShpAdayan etAM kathAM kathitavAn, yUyaM mAM kaM janaM jAnItha? aham abhiShiktatrAtA nahi, kintu pashyata yasya pAdayoH pAdukayo rbandhane mochayitumapi yogyo na bhavAmi tAdR^isha eko jano mama pashchAd upatiShThati| ");
INSERT INTO sanitr_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","he ibrAhImo vaMshajAtA bhrAtaro he IshvarabhItAH sarvvalokA yuShmAn prati paritrANasya kathaiShA preritA| ");
INSERT INTO sanitr_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","yirUshAlamnivAsinasteShAm adhipatayashcha tasya yIshoH parichayaM na prApya prativishrAmavAraM paThyamAnAnAM bhaviShyadvAdikathAnAm abhiprAyam abuddhvA cha tasya vadhena tAH kathAH saphalA akurvvan| ");
INSERT INTO sanitr_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","prANahananasya kamapi hetum aprApyApi pIlAtasya nikaTe tasya vadhaM prArthayanta| ");
INSERT INTO sanitr_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","tasmin yAH kathA likhitAH santi tadanusAreNa karmma sampAdya taM krushAd avatAryya shmashAne shAyitavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","kintvIshvaraH shmashAnAt tamudasthApayat, ");
INSERT INTO sanitr_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","punashcha gAlIlapradeshAd yirUshAlamanagaraM tena sArddhaM ye lokA AgachChan sa bahudinAni tebhyo darshanaM dattavAn, atasta idAnIM lokAn prati tasya sAkShiNaH santi| ");
INSERT INTO sanitr_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","asmAkaM pUrvvapuruShANAM samakSham Ishvaro yasmin pratij nAtavAn yathA, tvaM me putrosi chAdya tvAM samutthApitavAnaham| ");
INSERT INTO sanitr_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","idaM yadvachanaM dvitIyagIte likhitamAste tad yIshorutthAnena teShAM santAnA ye vayam asmAkaM sannidhau tena pratyakShI kR^itaM, yuShmAn imaM susaMvAdaM j nApayAmi| ");
INSERT INTO sanitr_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","parameshvareNa shmashAnAd utthApitaM tadIyaM sharIraM kadApi na kSheShyate, etasmin sa svayaM kathitavAn yathA dAyUdaM prati pratij nAto yo varastamahaM tubhyaM dAsyAmi| ");
INSERT INTO sanitr_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","etadanyasmin gIte.api kathitavAn| svakIyaM puNyavantaM tvaM kShayituM na cha dAsyasi| ");
INSERT INTO sanitr_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","dAyUdA IshvarAbhimatasevAyai nijAyuShi vyayite sati sa mahAnidrAM prApya nijaiH pUrvvapuruShaiH saha militaH san akShIyata; ");
INSERT INTO sanitr_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","kintu yamIshvaraH shmashAnAd udasthApayat sa nAkShIyata| ");
INSERT INTO sanitr_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","ato he bhrAtaraH, anena janena pApamochanaM bhavatIti yuShmAn prati prachAritam Aste| ");
INSERT INTO sanitr_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","phalato mUsAvyavasthayA yUyaM yebhyo doShebhyo muktA bhavituM na shakShyatha tebhyaH sarvvadoShebhya etasmin jane vishvAsinaH sarvve muktA bhaviShyantIti yuShmAbhi rj nAyatAM| ");
INSERT INTO sanitr_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","apara ncha| avaj nAkAriNo lokAshchakShurunmIlya pashyata| tathaivAsambhavaM j nAtvA syAta yUyaM vilajjitAH| yato yuShmAsu tiShThatsu kariShye karmma tAdR^ishaM| yenaiva tasya vR^ittAnte yuShmabhyaM kathite.api hi| yUyaM na tantu vR^ittAntaM pratyeShyatha kadAchana|| ");
INSERT INTO sanitr_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","yeyaM kathA bhaviShyadvAdinAM grantheShu likhitAste sAvadhAnA bhavata sa kathA yathA yuShmAn prati na ghaTate| ");
INSERT INTO sanitr_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","yihUdIyabhajanabhavanAn nirgatayostayo rbhinnadeshIyai rvakShyamANA prArthanA kR^itA, AgAmini vishrAmavAre.api katheyam asmAn prati prachAritA bhavatviti| ");
INSERT INTO sanitr_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","sabhAyA bha Nge sati bahavo yihUdIyalokA yihUdIyamatagrAhiNo bhaktalokAshcha barNabbApaulayoH pashchAd AgachChan, tena tau taiH saha nAnAkathAH kathayitveshvarAnugrahAshraye sthAtuM tAn prAvarttayatAM| ");
INSERT INTO sanitr_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","paravishrAmavAre nagarasya prAyeNa sarvve lAkA IshvarIyAM kathAM shrotuM militAH, ");
INSERT INTO sanitr_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","kintu yihUdIyalokA jananivahaM vilokya IrShyayA paripUrNAH santo viparItakathAkathaneneshvaranindayA cha paulenoktAM kathAM khaNDayituM cheShTitavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","tataH pauैlabarNabbAvakShobhau kathitavantau prathamaM yuShmAkaM sannidhAvIshvarIyakathAyAH prachAraNam uchitamAsIt kintuM tadagrAhyatvakaraNena yUyaM svAn anantAyuSho.ayogyAn darshayatha, etatkAraNAd vayam anyadeshIyalokAnAM samIpaM gachChAmaH| ");
INSERT INTO sanitr_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","prabhurasmAn ittham AdiShTavAn yathA, yAvachcha jagataH sImAM lokAnAM trANakAraNAt| mayAnyadeshamadhye tvaM sthApito bhUH pradIpavat|| ");
INSERT INTO sanitr_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","tadA kathAmIdR^ishIM shrutvA bhinnadeshIyA AhlAditAH santaH prabhoH kathAM dhanyAM dhanyAm avadan, yAvanto lokAshcha paramAyuH prAptinimittaM nirUpitA Asan teे vyashvasan| ");
INSERT INTO sanitr_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","itthaM prabhoH kathA sarvvedeshaM vyApnot| ");
INSERT INTO sanitr_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","kintu yihUdIyA nagarasya pradhAnapuruShAn sammAnyAH kathipayA bhaktA yoShitashcha kupravR^ittiM grAhayitvA paulabarNabbau tADayitvA tasmAt pradeshAd dUrIkR^itavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","ataH kAraNAt tau nijapadadhUlIsteShAM prAtikUlyena pAtayitveेkaniyaM nagaraM gatau| ");
INSERT INTO sanitr_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","tataH shiShyagaNa Anandena pavitreNAtmanA cha paripUrNobhavat| ");
INSERT INTO sanitr_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","tau dvau janau yugapad ikaniyanagarasthayihUdIyAnAM bhajanabhavanaM gatvA yathA bahavo yihUdIyA anyadeेshIyalokAshcha vyashvasan tAdR^ishIM kathAM kathitavantau| ");
INSERT INTO sanitr_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","kintu vishvAsahInA yihUdIyA anyadeshIyalokAn kupravR^ittiM grAhayitvA bhrAtR^igaNaM prati teShAM vairaM janitavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ataH svAnugrahakathAyAH pramANaM datvA tayo rhastai rbahulakShaNam adbhutakarmma cha prAkAshayad yaH prabhustasya kathA akShobhena prachAryya tau tatra bahudinAni samavAtiShThetAM| ");
INSERT INTO sanitr_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","kintu kiyanto lokA yihUdIyAnAM sapakShAH kiyanto lokAH preritAnAM sapakShA jAtAH, ato nAgarikajananivahamadhye bhinnavAkyatvam abhavat| ");
INSERT INTO sanitr_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","anyadeshIyA yihUdIyAsteShAm adhipatayashcha daurAtmyaM kutvA tau prastarairAhantum udyatAH| ");
INSERT INTO sanitr_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","tau tadvArttAM prApya palAyitvA lukAyaniyAdeshasyAntarvvarttilustrAdarbbo ");
INSERT INTO sanitr_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","tatsamIpasthadesha ncha gatvA tatra susaMvAdaM prachArayatAM| ");
INSERT INTO sanitr_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","tatrobhayapAdayoshchalanashaktihIno janmArabhya kha njaH kadApi gamanaM nAkarot etAdR^isha eko mAnuSho lustrAnagara upavishya paulasya kathAM shrutavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","etasmin samaye paulastamprati dR^iShTiM kR^itvA tasya svAsthye vishvAsaM viditvA prochchaiH kathitavAn ");
INSERT INTO sanitr_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","padbhyAmuttiShThan R^iju rbhava|tataH sa ullamphaM kR^itvA gamanAgamane kutavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","tadA lokAH paulasya tat kAryyaM vilokya lukAyanIyabhAShayA prochchaiH kathAmetAM kathitavantaH, devA manuShyarUpaM dhR^itvAsmAkaM samIpam avArohan| ");
INSERT INTO sanitr_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","te barNabbAM yUpitaram avadan paulashcha mukhyo vaktA tasmAt taM markuriyam avadan| ");
INSERT INTO sanitr_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","tasya nagarasya sammukhe sthApitasya yUpitaravigrahasya yAjako vR^iShAn puShpamAlAshcha dvArasamIpam AnIya lokaiH sarddhaM tAvuddishya samutsR^ijya dAtum udyataH| ");
INSERT INTO sanitr_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","tadvArttAM shrutvA barNabbApaulau svIyavastrANi ChitvA lokAnAM madhyaM vegena pravishya prochchaiH kathitavantau, ");
INSERT INTO sanitr_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","he mahechChAH kuta etAdR^ishaM karmma kurutha? AvAmapi yuShmAdR^ishau sukhaduHkhabhoginau manuShyau, yuyam etAH sarvvA vR^ithAkalpanAH parityajya yathA gagaNavasundharAjalanidhInAM tanmadhyasthAnAM sarvveShA ncha sraShTAramamaram IshvaraM prati parAvarttadhve tadartham AvAM yuShmAkaM sannidhau susaMvAdaM prachArayAvaH| ");
INSERT INTO sanitr_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","sa IshvaraH pUrvvakAle sarvvadeshIyalokAn svasvamArge chalitumanumatiM dattavAn, ");
INSERT INTO sanitr_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","tathApi AkAshAt toyavarShaNena nAnAprakArashasyotpatyA cha yuShmAkaM hitaiShI san bhakShyairAnanadena cha yuShmAkam antaHkaraNAni tarpayan tAni dAnAni nijasAkShisvarUpANi sthapitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","kintu tAdR^ishAyAM kathAyAM kathitAyAmapi tayoH samIpa utsarjanAt lokanivahaM prAyeNa nivarttayituM nAshaknutAm| ");
INSERT INTO sanitr_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","AntiyakhiyA-ikaniyanagarAbhyAM katipayayihUdIyalokA Agatya lokAn prAvarttayanta tasmAt tai paulaM prastarairAghnan tena sa mR^ita iti vij nAya nagarasya bahistam AkR^iShya nItavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","kintu shiShyagaNe tasya chaturdishi tiShThati sati sa svayam utthAya punarapi nagaramadhyaM prAvishat tatpare.ahani barNabbAsahito darbbInagaraM gatavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","tatra susaMvAdaM prachAryya bahulokAn shiShyAn kR^itvA tau lustrAm ikaniyam AntiyakhiyA ncha parAvR^itya gatau| ");
INSERT INTO sanitr_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","bahuduHkhAni bhuktvApIshvararAjyaM praveShTavyam iti kAraNAd dharmmamArge sthAtuM vinayaM kR^itvA shiShyagaNasya manaHsthairyyam akurutAM| ");
INSERT INTO sanitr_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","maNDalInAM prAchInavargAn niyujya prArthanopavAsau kR^itvA yatprabhau te vyashvasan tasya haste tAn samarpya ");
INSERT INTO sanitr_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","pisidiyAmadhyena pAmphuliyAdeshaM gatavantau| ");
INSERT INTO sanitr_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","pashchAt pargAnagaraM gatvA susaMvAdaM prachAryya attAliyAnagaraM prasthitavantau| ");
INSERT INTO sanitr_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","tasmAt samudrapathena gatvA tAbhyAM yat karmma sampannaM tatkarmma sAdhayituM yannagare dayAlorIshvarasya haste samarpitau jAtau tad AntiyakhiyAnagaraM gatavantA| ");
INSERT INTO sanitr_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","tatropasthAya tannagarasthamaNDalIM saMgR^ihya svAbhyAma Ishvaro yadyat karmmakarot tathA yena prakAreNa bhinnadeshIyalokAn prati vishvAsarUpadvAram amochayad etAn sarvvavR^ittAntAn tAn j nApitavantau| ");
INSERT INTO sanitr_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","tatastau shiryyaiH sArddhaM tatra bahudinAni nyavasatAm| ");
INSERT INTO sanitr_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","yihUdAdeshAt kiyanto janA Agatya bhrAtR^igaNamitthaM shikShitavanto mUsAvyavasthayA yadi yuShmAkaM tvakChedo na bhavati tarhi yUyaM paritrANaM prAptuM na shakShyatha| ");
INSERT INTO sanitr_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","paulabarNabbau taiH saha bahUn vichArAn vivAdAMshcha kR^itavantau, tato maNDalIyanokA etasyAH kathAyAstattvaM j nAtuM yirUshAlamnagarasthAn preritAn prAchInAMshcha prati paulabarNabbAprabhR^itIn katipayajanAn preShayituM nishchayaM kR^itavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","te maNDalyA preritAH santaH phaiNIkIshomirondeshAbhyAM gatvA bhinnadeshIyAnAM manaHparivarttanasya vArttayA bhrAtR^iNAM paramAhlAdam ajanayan| ");
INSERT INTO sanitr_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","yirUshAlamyupasthAya preritagaNena lokaprAchInagaNena samAjena cha samupagR^ihItAH santaH svairIshvaro yAni karmmANi kR^itavAn teShAM sarvvavR^ittAntAn teShAM samakSham akathayan| ");
INSERT INTO sanitr_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","kintu vishvAsinaH kiyantaH phirUshimatagrAhiNo lokA utthAya kathAmetAM kathitavanto bhinnadeshIyAnAM tvakChedaM karttuM mUsAvyavasthAM pAlayitu ncha samAdeShTavyam| ");
INSERT INTO sanitr_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","tataH preritA lokaprAchInAshcha tasya vivechanAM karttuM sabhAyAM sthitavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","bahuvichAreShu jAtaShu pitara utthAya kathitavAn, he bhrAtaro yathA bhinnadeshIyalokA mama mukhAt susaMvAdaM shrutvA vishvasanti tadarthaM bahudinAt pUrvvam IshvarosmAkaM madhye mAM vR^itvA niyuktavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","antaryyAmIshvaro yathAsmabhyaM tathA bhinnadeshIyebhyaH pavitramAtmAnaM pradAya vishvAsena teShAm antaHkaraNAni pavitrANi kR^itvA ");
INSERT INTO sanitr_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","teShAm asmAka ncha madhye kimapi visheShaM na sthApayitvA tAnadhi svayaM pramANaM dattavAn iti yUyaM jAnItha| ");
INSERT INTO sanitr_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","ataevAsmAkaM pUrvvapuruShA vaya ncha svayaM yadyugasya bhAraM soDhuM na shaktAH samprati taM shiShyagaNasya skandheShu nyasituM kuta Ishvarasya parIkShAM kariShyatha? ");
INSERT INTO sanitr_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","prabho ryIshukhrIShTasyAnugraheNa te yathA vayamapi tathA paritrANaM prAptum AshAM kurmmaH| ");
INSERT INTO sanitr_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","anantaraM barNabbApaulAbhyAm Ishvaro bhinnadeshIyAnAM madhye yadyad Ashcharyyam adbhuta ncha karmma kR^itavAn tadvR^ittAntaM tau svamukhAbhyAm avarNayatAM sabhAsthAH sarvve nIravAH santaH shrutavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","tayoH kathAyAM samAptAyAM satyAM yAkUb kathayitum ArabdhavAn ");
INSERT INTO sanitr_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","he bhrAtaro mama kathAyAm mano nidhatta| IshvaraH svanAmArthaM bhinnadeshIyalokAnAm madhyAd ekaM lokasaMghaM grahItuM matiM kR^itvA yena prakAreNa prathamaM tAn prati kR^ipAvalekanaM kR^itavAn taM shimon varNitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","bhaviShyadvAdibhiruktAni yAni vAkyAni taiH sArddham etasyaikyaM bhavati yathA likhitamAste| ");
INSERT INTO sanitr_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","sarvveShAM karmmaNAM yastu sAdhakaH parameshvaraH| sa evedaM vadedvAkyaM sheShAH sakalamAnavAH| bhinnadeshIyalokAshcha yAvanto mama nAmataH| bhavanti hi suvikhyAtAste yathA parameshituH| ");
INSERT INTO sanitr_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","tatvaM samyak samIhante tannimittamahaM kila| parAvR^itya samAgatya dAyUdaH patitaM punaH| dUShyamutthApayiShyAmi tadIyaM sarvvavastu cha| patitaM punaruthApya sajjayiShyAmi sarvvathA|| ");
INSERT INTO sanitr_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","A prathamAd IshvaraH svIyAni sarvvakarmmANi jAnAti| ");
INSERT INTO sanitr_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","ataeva mama nivedanamidaM bhinnadeshIyalokAnAM madhye ye janA IshvaraM prati parAvarttanta teShAmupari anyaM kamapi bhAraM na nyasya ");
INSERT INTO sanitr_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","devatAprasAdAshuchibhakShyaM vyabhichArakarmma kaNThasampIDanamAritaprANibhakShyaM raktabhakShya ncha etAni parityaktuM likhAmaH| ");
INSERT INTO sanitr_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","yataH pUrvvakAlato mUsAvyavasthAprachAriNo lokA nagare nagare santi prativishrAmavAra ncha bhajanabhavane tasyAH pATho bhavati| ");
INSERT INTO sanitr_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","tataH paraM preritagaNo lokaprAchInagaNaH sarvvA maNDalI cha sveShAM madhye barshabbA nAmnA vikhyAto manonItau kR^itvA paulabarNabbAbhyAM sArddham AntiyakhiyAnagaraM prati preShaNam uchitaM buddhvA tAbhyAM patraM praiShayan| ");
INSERT INTO sanitr_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","tasmin patre likhitamiMda, AntiyakhiyA-suriyA-kilikiyAdeshasthabhinnadeshIyabhrAtR^igaNAya preritagaNasya lokaprAchInagaNasya bhrAtR^igaNasya cha namaskAraH| ");
INSERT INTO sanitr_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","visheShato.asmAkam Aj nAm aprApyApi kiyanto janA asmAkaM madhyAd gatvA tvakChedo mUsAvyavasthA cha pAlayitavyAviti yuShmAn shikShayitvA yuShmAkaM manasAmasthairyyaM kR^itvA yuShmAn sasandehAn akurvvan etAM kathAM vayam ashR^inma| ");
INSERT INTO sanitr_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","tatkAraNAd vayam ekamantraNAH santaH sabhAyAM sthitvA prabho ryIshukhrIShTasya nAmanimittaM mR^ityumukhagatAbhyAmasmAkaM ");
INSERT INTO sanitr_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","priyabarNabbApaulAbhyAM sArddhaM manonItalokAnAM keShA nchid yuShmAkaM sannidhau preShaNam uchitaM buddhavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","ato yihUdAsIlau yuShmAn prati preShitavantaH, etayo rmukhAbhyAM sarvvAM kathAM j nAsyatha| ");
INSERT INTO sanitr_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","devatAprasAdabhakShyaM raktabhakShyaM galapIDanamAritaprANibhakShyaM vyabhichArakarmma chemAni sarvvANi yuShmAbhistyAjyAni; etatprayojanIyAj nAvyatirekena yuShmAkam upari bhAramanyaM na nyasituM pavitrasyAtmano.asmAka ncha uchitaj nAnam abhavat| ");
INSERT INTO sanitr_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ataeva tebhyaH sarvvebhyaH sveShu rakShiteShu yUyaM bhadraM karmma kariShyatha| yuShmAkaM ma NgalaM bhUyAt| ");
INSERT INTO sanitr_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","teे visR^iShTAH santa AntiyakhiyAnagara upasthAya lokanivahaM saMgR^ihya patram adadan| ");
INSERT INTO sanitr_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","tataste tatpatraM paThitvA sAntvanAM prApya sAnandA abhavan| ");
INSERT INTO sanitr_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","yihUdAsIlau cha svayaM prachArakau bhUtvA bhrAtR^igaNaM nAnopadishya tAn susthirAn akurutAm| ");
INSERT INTO sanitr_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","itthaM tau tatra taiH sAkaM katipayadinAni yApayitvA pashchAt preritAnAM samIpe pratyAgamanArthaM teShAM sannidheH kalyANena visR^iShTAvabhavatAM| ");
INSERT INTO sanitr_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","kintu sIlastatra sthAtuM vA nChitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","aparaM paulabarNabbau bahavaH shiShyAshcha lokAn upadishya prabhoH susaMvAdaM prachArayanta AntiyakhiyAyAM kAlaM yApitavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","katipayadineShu gateShu paulo barNabbAm avadat AgachChAvAM yeShu nagareShvIshvarasya susaMvAdaM prachAritavantau tAni sarvvanagarANi punargatvA bhrAtaraH kIdR^ishAH santIti draShTuM tAn sAkShAt kurvvaH| ");
INSERT INTO sanitr_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","tena mArkanAmnA vikhyAtaM yohanaM sa NginaM karttuM barNabbA matimakarot, ");
INSERT INTO sanitr_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","kintu sa pUrvvaM tAbhyAM saha kAryyArthaM na gatvA pAmphUliyAdeshe tau tyaktavAn tatkAraNAt paulastaM sa NginaM karttum anuchitaM j nAtavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","itthaM tayoratishayavirodhasyopasthitatvAt tau parasparaM pR^ithagabhavatAM tato barNabbA mArkaM gR^ihItvA potena kupropadvIpaM gatavAn; ");
INSERT INTO sanitr_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","kintu paulaH sIlaM manonItaM kR^itvA bhrAtR^ibhirIshvarAnugrahe samarpitaH san prasthAya ");
INSERT INTO sanitr_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","suriyAkilikiyAdeshAbhyAM maNDalIH sthirIkurvvan agachChat| ");
INSERT INTO sanitr_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","paulo darbbIlustrAnagarayorupasthitobhavat tatra tImathiyanAmA shiShya eka AsIt; sa vishvAsinyA yihUdIyAyA yoShito garbbhajAtaH kintu tasya pitAnyadeshIyalokaH| ");
INSERT INTO sanitr_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","sa jano lustrA-ikaniyanagarasthAnAM bhrAtR^iNAM samIpepi sukhyAtimAn AsIt| ");
INSERT INTO sanitr_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","paulastaM svasa NginaM karttuM matiM kR^itvA taM gR^ihItvA taddeshanivAsinAM yihUdIyAnAm anurodhAt tasya tvakChedaM kR^itavAn yatastasya pitA bhinnadeshIyaloka iti sarvvairaj nAyata| ");
INSERT INTO sanitr_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","tataH paraM te nagare nagare bhramitvA yirUshAlamasthaiH preritai rlokaprAchInaishcha nirUpitaM yad vyavasthApatraM tadanusAreNAcharituM lokebhyastad dattavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","tenaiva sarvve dharmmasamAjAH khrIShTadharmme susthirAH santaH pratidinaM varddhitA abhavan| ");
INSERT INTO sanitr_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","teShu phrugiyAgAlAtiyAdeshamadhyena gateShu satsu pavitra AtmA tAn AshiyAdeshe kathAM prakAshayituM pratiShiddhavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","tathA musiyAdesha upasthAya bithuniyAM gantuM tairudyoge kR^ite AtmA tAn nAnvamanyata| ");
INSERT INTO sanitr_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","tasmAt te musiyAdeshaM parityajya troyAnagaraM gatvA samupasthitAH| ");
INSERT INTO sanitr_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","rAtrau paulaH svapne dR^iShTavAn eko mAkidaniyalokastiShThan vinayaM kR^itvA tasmai kathayati, mAkidaniyAdesham AgatyAsmAn upakurvviti| ");
INSERT INTO sanitr_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","tasyetthaM svapnadarshanAt prabhustaddeshIyalokAn prati susaMvAdaM prachArayitum asmAn AhUyatIti nishchitaM buddhvA vayaM tUrNaM mAkidaniyAdeshaM gantum udyogam akurmma| ");
INSERT INTO sanitr_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","tataH paraM vayaM troyAnagarAd prasthAya R^ijumArgeNa sAmathrAkiyopadvIpena gatvA pare.ahani niyApalinagara upasthitAH| ");
INSERT INTO sanitr_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","tasmAd gatvA mAkidaniyAntarvvartti romIyavasatisthAnaM yat philipInAmapradhAnanagaraM tatropasthAya katipayadinAni tatra sthitavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","vishrAmavAre nagarAd bahi rgatvA nadItaTe yatra prArthanAchAra AsIt tatropavishya samAgatA nArIH prati kathAM prAchArayAma| ");
INSERT INTO sanitr_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","tataH thuyAtIrAnagarIyA dhUSharAmbaravikrAyiNI ludiyAnAmikA yA IshvarasevikA yoShit shrotrINAM madhya AsIt tayA pauloktavAkyAni yad gR^ihyante tadarthaM prabhustasyA manodvAraM muktavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ataH sA yoShit saparivArA majjitA satI vinayaM kR^itvA kathitavatI, yuShmAkaM vichArAd yadi prabhau vishvAsinI jAtAhaM tarhi mama gR^iham Agatya tiShThata| itthaM sA yatnenAsmAn asthApayat| ");
INSERT INTO sanitr_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","yasyA gaNanayA tadadhipatInAM bahudhanopArjanaM jAtaM tAdR^ishI gaNakabhUtagrastA kAchana dAsI prArthanAsthAnagamanakAla AgatyAsmAn sAkShAt kR^itavatI| ");
INSERT INTO sanitr_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","sAsmAkaM paulasya cha pashchAd etya prochchaiH kathAmimAM kathitavatI, manuShyA ete sarvvoparisthasyeshvarasya sevakAH santo.asmAn prati paritrANasya mArgaM prakAshayanti| ");
INSERT INTO sanitr_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","sA kanyA bahudinAni tAdR^isham akarot tasmAt paulo duHkhitaH san mukhaM parAvartya taM bhUtamavadad, ahaM yIshukhrIShTasya nAmnA tvAmAj nApayAmi tvamasyA bahirgachCha; tenaiva tatkShaNAt sa bhUtastasyA bahirgataH| ");
INSERT INTO sanitr_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","tataH sveShAM lAbhasya pratyAshA viphalA jAteti vilokya tasyAH prabhavaH paulaM sIla ncha dhR^itvAkR^iShya vichArasthAne.adhipatInAM samIpam Anayan| ");
INSERT INTO sanitr_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","tataH shAsakAnAM nikaTaM nItvA romilokA vayam asmAkaM yad vyavaharaNaM grahItum Acharitu ncha niShiddhaM, ");
INSERT INTO sanitr_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ime yihUdIyalokAH santopi tadeva shikShayitvA nagare.asmAkam atIva kalahaM kurvvanti, ");
INSERT INTO sanitr_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","iti kathite sati lokanivahastayoH prAtikUlyenodatiShThat tathA shAsakAstayo rvastrANi ChitvA vetrAghAtaM karttum Aj nApayan| ");
INSERT INTO sanitr_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","aparaM te tau bahu prahAryya tvametau kArAM nItvA sAvadhAnaM rakShayeti kArArakShakam Adishan| ");
INSERT INTO sanitr_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ittham Aj nAM prApya sa tAvabhyantarasthakArAM nItvA pAdeShu pAdapAshIbhi rbaddhvA sthApitAvAn| ");
INSERT INTO sanitr_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","atha nishIthasamaye paulasIlAvIshvaramuddishya prAthanAM gAna ncha kR^itavantau, kArAsthitA lokAshcha tadashR^iNvan ");
INSERT INTO sanitr_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","tadAkasmAt mahAn bhUmikampo.abhavat tena bhittimUlena saha kArA kampitAbhUt tatkShaNAt sarvvANi dvArANi muktAni jAtAni sarvveShAM bandhanAni cha muktAni| ");
INSERT INTO sanitr_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","ataeva kArArakShako nidrAto jAgaritvA kArAyA dvArANi muktAni dR^iShTvA bandilokAH palAyitA ityanumAya koShAt kha NgaM bahiH kR^itvAtmaghAtaM karttum udyataH| ");
INSERT INTO sanitr_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","kintu paulaH prochchaistamAhUya kathitavAn pashya vayaM sarvve.atrAsmahe, tvaM nijaprANahiMsAM mAkArShIH| ");
INSERT INTO sanitr_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","tadA pradIpam Anetum uktvA sa kampamAnaH san ullampyAbhyantaram Agatya paulasIlayoH pAdeShu patitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","pashchAt sa tau bahirAnIya pR^iShTavAn he mahechChau paritrANaM prAptuM mayA kiM karttavyaM? ");
INSERT INTO sanitr_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","pashchAt tau svagR^ihamAnIya tayoH sammukhe khAdyadravyANi sthApitavAn tathA sa svayaM tadIyAH sarvve parivArAshcheshvare vishvasantaH sAnanditA abhavan| ");
INSERT INTO sanitr_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","tasmai tasya gR^ihasthitasarvvalokebhyashcha prabhoH kathAM kathitavantau| ");
INSERT INTO sanitr_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","tathA rAtrestasminneva daNDe sa tau gR^ihItvA tayoH prahArANAM kShatAni prakShAlitavAn tataH sa svayaM tasya sarvve parijanAshcha majjitA abhavan| ");
INSERT INTO sanitr_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","pashchAt tau svagR^ihamAnIya tayoH sammukhe khAdyadravyANi sthApitavAn tathA sa svayaM tadIyAH sarvve parivArAshcheshvare vishvasantaH sAnanditA abhavan| ");
INSERT INTO sanitr_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","dina upasthite tau lokau mochayeti kathAM kathayituM shAsakAH padAtigaNaM preShitavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","tataH kArArakShakaH paulAya tAM vArttAM kathitavAn yuvAM tyAjayituM shAsakA lokAna preShitavanta idAnIM yuvAM bahi rbhUtvA kushalena pratiShThetAM| ");
INSERT INTO sanitr_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","kintu paulastAn avadat romilokayorAvayoH kamapi doSham na nishchitya sarvveShAM samakSham AvAM kashayA tADayitvA kArAyAM baddhavanta idAnIM kimAvAM guptaM vistrakShyanti? tanna bhaviShyati, svayamAgatyAvAM bahiH kR^itvA nayantu| ");
INSERT INTO sanitr_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","tadA padAtibhiH shAsakebhya etadvArttAyAM kathitAyAM tau romilokAviti kathAM shrutvA te bhItAH ");
INSERT INTO sanitr_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","santastayoH sannidhimAgatya vinayam akurvvan aparaM bahiH kR^itvA nagarAt prasthAtuM prArthitavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","tatastau kArAyA nirgatya ludiyAyA gR^ihaM gatavantau tatra bhrAtR^igaNaM sAkShAtkR^itya tAn sAntvayitvA tasmAt sthAnAt prasthitau| ");
INSERT INTO sanitr_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","paulasIlau AmphipalyApalloniyAnagarAbhyAM gatvA yatra yihUdIyAnAM bhajanabhavanamekam Aste tatra thiShalanIkInagara upasthitau| ");
INSERT INTO sanitr_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","tadA paulaH svAchArAnusAreNa teShAM samIpaM gatvA vishrAmavAratraye taiH sArddhaM dharmmapustakIyakathAyA vichAraM kR^itavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","phalataH khrIShTena duHkhabhogaH karttavyaH shmashAnadutthAna ncha karttavyaM yuShmAkaM sannidhau yasya yIshoH prastAvaM karomi sa IshvareNAbhiShiktaH sa etAH kathAH prakAshya pramANaM datvA sthirIkR^itavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","tasmAt teShAM katipayajanA anyadeshIyA bahavo bhaktalokA bahyaH pradhAnanAryyashcha vishvasya paulasIlayoH pashchAdgAmino jAtAH| ");
INSERT INTO sanitr_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","kintu vishvAsahInA yihUdIyalokA IrShyayA paripUrNAH santo haTaTsya katinayalampaTalokAn sa NginaH kR^itvA janatayA nagaramadhye mahAkalahaM kR^itvA yAsono gR^iham Akramya preritAn dhR^itvA lokanivahasya samIpam AnetuM cheShTitavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","teShAmuddesham aprApya cha yAsonaM katipayAn bhrAtR^iMshcha dhR^itvA nagarAdhipatInAM nikaTamAnIya prochchaiH kathitavanto ye manuShyA jagadudvATitavantaste .atrApyupasthitAH santi, ");
INSERT INTO sanitr_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","eSha yAson AtithyaM kR^itvA tAn gR^ihItavAn| yIshunAmaka eko rAjastIti kathayantaste kaisarasyAj nAviruddhaM karmma kurvvati| ");
INSERT INTO sanitr_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","teShAM kathAmimAM shrutvA lokanivaho nagarAdhipatayashcha samudvignA abhavan| ");
INSERT INTO sanitr_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","tadA yAsonastadanyeShA ncha dhanadaNDaM gR^ihItvA tAn parityaktavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","tataH paraM bhrAtR^igaNo rajanyAM paulasIlau shIghraM birayAnagaraM preShitavAn tau tatropasthAya yihUdIyAnAM bhajanabhavanaM gatavantau| ");
INSERT INTO sanitr_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","tatrasthA lokAH thiShalanIkIsthalokebhyo mahAtmAna Asan yata itthaM bhavati na veti j nAtuM dine dine dharmmagranthasyAlochanAM kR^itvA svairaM kathAm agR^ihlan| ");
INSERT INTO sanitr_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","tasmAd aneke yihUdIyA anyadeshIyAnAM mAnyA striyaH puruShAshchAneke vyashvasan| ");
INSERT INTO sanitr_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","kintu birayAnagare pauleneshvarIyA kathA prachAryyata iti thiShalanIkIsthA yihUdIyA j nAtvA tatsthAnamapyAgatya lokAnAM kupravR^ittim ajanayan| ");
INSERT INTO sanitr_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","ataeva tasmAt sthAnAt samudreNa yAntIti darshayitvA bhrAtaraH kShipraM paulaM prAhiNvan kintu sIlatImathiyau tatra sthitavantau| ");
INSERT INTO sanitr_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","tataH paraM paulasya mArgadarshakAstam AthInInagara upasthApayan pashchAd yuvAM tUrNam etat sthAnaM AgamiShyathaH sIlatImathiyau pratImAm Aj nAM prApya te pratyAgatAH| ");
INSERT INTO sanitr_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","paula AthInInagare tAvapekShya tiShThan tannagaraM pratimAbhiH paripUrNaM dR^iShTvA santaptahR^idayo .abhavat| ");
INSERT INTO sanitr_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","tataH sa bhajanabhavane yAn yihUdIyAn bhaktalokAMshcha haTTe cha yAn apashyat taiH saha pratidinaM vichAritavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","kintvipikUrIyamatagrahiNaH stoyikIyamatagrAhiNashcha kiyanto janAstena sArddhaM vyavadanta| tatra kechid akathayan eSha vAchAlaH kiM vaktum ichChati? apare kechid eSha janaH keShA nchid videshIyadevAnAM prachAraka ityanumIyate yataH sa yIshum utthiti ncha prachArayat| ");
INSERT INTO sanitr_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","te tam areyapAganAma vichArasthAnam AnIya prAvochan idaM yannavInaM mataM tvaM prAchIkasha idaM kIdR^ishaM etad asmAn shrAvaya; ");
INSERT INTO sanitr_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","yAmimAm asambhavakathAm asmAkaM karNagocharIkR^itavAn asyA bhAvArthaH ka iti vayaM j nAtum ichChAmaH| ");
INSERT INTO sanitr_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","tadAthInInivAsinastannagarapravAsinashcha kevalaM kasyAshchana navInakathAyAH shravaNena prachAraNena cha kAlam ayApayan| ");
INSERT INTO sanitr_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","paulo.areyapAgasya madhye tiShThan etAM kathAM prachAritavAn, he AthInIyalokA yUyaM sarvvathA devapUjAyAm AsaktA ityaha pratyakShaM pashyAmi| ");
INSERT INTO sanitr_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","yataH paryyaTanakAle yuShmAkaM pUjanIyAni pashyan ‘avij nAteshvarAya` etallipiyuktAM yaj navedImekAM dR^iShTavAn; ato na viditvA yaM pUjayadhve tasyaiva tatvaM yuShmAn prati prachArayAmi| ");
INSERT INTO sanitr_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","jagato jagatsthAnAM sarvvavastUnA ncha sraShTA ya IshvaraH sa svargapR^ithivyorekAdhipatiH san karanirmmitamandireShu na nivasati; ");
INSERT INTO sanitr_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","sa eva sarvvebhyo jIvanaM prANAn sarvvasAmagrIshcha pradadAti; ataeva sa kasyAshchit sAmagyrA abhAvaheto rmanuShyANAM hastaiH sevito bhavatIti na| ");
INSERT INTO sanitr_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","sa bhUmaNDale nivAsArtham ekasmAt shoNitAt sarvvAn manuShyAn sR^iShTvA teShAM pUrvvanirUpitasamayaM vasatisImA ncha nirachinot; ");
INSERT INTO sanitr_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","tasmAt lokaiH kenApi prakAreNa mR^igayitvA parameshvarasya tatvaM prAptuM tasya gaveShaNaM karaNIyam| ");
INSERT INTO sanitr_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","kintu so.asmAkaM kasmAchchidapi dUre tiShThatIti nahi, vayaM tena nishvasanaprashvasanagamanAgamanaprANadhAraNAni kurmmaH, puुnashcha yuShmAkameva katipayAH kavayaH kathayanti ‘tasya vaMshA vayaM smo hi` iti| ");
INSERT INTO sanitr_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","ataeva yadi vayam Ishvarasya vaMshA bhavAmastarhi manuShyai rvidyayA kaushalena cha takShitaM svarNaM rUpyaM dR^iShad vaiteShAmIshvaratvam asmAbhi rna j nAtavyaM| ");
INSERT INTO sanitr_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","teShAM pUrvvIyalokAnAm aj nAnatAM pratIshvaro yadyapi nAvAdhatta tathApIdAnIM sarvvatra sarvvAn manaH parivarttayitum Aj nApayati, ");
INSERT INTO sanitr_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","yataH svaniyuktena puruSheNa yadA sa pR^ithivIsthAnAM sarvvalokAnAM vichAraM kariShyati taddinaM nyarUpayat; tasya shmashAnotthApanena tasmin sarvvebhyaH pramANaM prAdAt| ");
INSERT INTO sanitr_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","tadA shmashAnAd utthAnasya kathAM shrutvA kechid upAhaman, kechidavadan enAM kathAM punarapi tvattaH shroShyAmaH| ");
INSERT INTO sanitr_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","tataH paulasteShAM samIpAt prasthiाtavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","tathApi kechillokAstena sArddhaM militvA vyashvasan teShAM madhye .areyapAgIyadiyanusiyo dAmArInAmA kAchinnArI kiyanto narAshchAsan| ");
INSERT INTO sanitr_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","tadghaTanAtaH paraM paula AthInInagarAd yAtrAM kR^itvA karinthanagaram AgachChat| ");
INSERT INTO sanitr_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","tasmin samaye klaudiyaH sarvvAn yihUdIyAn romAnagaraM vihAya gantum Aj nApayat, tasmAt priskillAnAmnA jAyayA sArddham itAliyAdeshAt ki nchitpUrvvam Agamat yaH pantadeshe jAta AkkilanAmA yihUdIyalokaH paulastaM sAkShAt prApya tayoH samIpamitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","tau dUShyanirmmANajIvinau, tasmAt parasparam ekavR^ittikatvAt sa tAbhyAM saha uShitvA tat karmmAkarot| ");
INSERT INTO sanitr_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","paulaH prativishrAmavAraM bhajanabhavanaM gatvA vichAraM kR^itvA yihUdIyAn anyadeshIyAMshcha pravR^ittiM grAhitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","sIlatImathiyayo rmAkidaniyAdeshAt sametayoH satoH paula uttaptamanA bhUtvA yIshurIshvareNAbhiShikto bhavatIti pramANaM yihUdIyAnAM samIpe prAdAt| ");
INSERT INTO sanitr_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","kintu te .atIva virodhaM vidhAya pAShaNDIyakathAM kathitavantastataH paulo vastraM dhunvan etAM kathAM kathitavAn, yuShmAkaM shoNitapAtAparAdho yuShmAn pratyeva bhavatu, tenAhaM niraparAdho .adyArabhya bhinnadeshIyAnAM samIpaM yAmi| ");
INSERT INTO sanitr_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","sa tasmAt prasthAya bhajanabhavanasamIpasthasya yustanAmna Ishvarabhaktasya bhinnadeshIyasya niveshanaM prAvishat| ");
INSERT INTO sanitr_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","tataH krIShpanAmA bhajanabhavanAdhipatiH saparivAraH prabhau vyashvasIt, karinthanagarIyA bahavo lokAshcha samAkarNya vishvasya majjitA abhavan| ");
INSERT INTO sanitr_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","kShaNadAyAM prabhuH paulaM darshanaM datvA bhAShitavAn, mA bhaiShIH, mA nirasIH kathAM prachAraya| ");
INSERT INTO sanitr_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ahaM tvayA sArddham Asa hiMsArthaM kopi tvAM spraShTuM na shakShyati nagare.asmin madIyA lokA bahava Asate| ");
INSERT INTO sanitr_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","tasmAt paulastannagare prAyeNa sArddhavatsaraparyyantaM saMsthAyeshvarasya kathAm upAdishat| ");
INSERT INTO sanitr_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","gAlliyanAmA kashchid AkhAyAdeshasya prADvivAkaH samabhavat, tato yihUdIyA ekavAkyAH santaH paulam Akramya vichArasthAnaM nItvA ");
INSERT INTO sanitr_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","mAnuSha eSha vyavasthAya viruddham IshvarabhajanaM karttuM lokAn kupravR^ittiM grAhayatIti niveditavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","tataH paule pratyuttaraM dAtum udyate sati gAlliyA yihUdIyAn vyAharat, yadi kasyachid anyAyasya vAtishayaduShTatAcharaNasya vichAro.abhaviShyat tarhi yuShmAkaM kathA mayA sahanIyAbhaviShyat| ");
INSERT INTO sanitr_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","kintu yadi kevalaM kathAyA vA nAmno vA yuShmAkaM vyavasthAyA vivAdo bhavati tarhi tasya vichAramahaM na kariShyAmi, yUyaM tasya mImAMsAM kuruta| ");
INSERT INTO sanitr_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","tataH sa tAn vichArasthAnAd dUrIkR^itavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","tadA bhinnadeshIyAH sosthininAmAnaM bhajanabhavanasya pradhAnAdhipatiM dhR^itvA vichArasthAnasya sammukhe prAharan tathApi gAlliyA teShu sarvvakarmmasu na mano nyadadhAt| ");
INSERT INTO sanitr_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","paulastatra punarbahudinAni nyavasat, tato bhrAtR^igaNAd visarjanaM prApya ki nchanavratanimittaM kiMkriyAnagare shiro muNDayitvA priskillAkkilAbhyAM sahito jalapathena suriyAdeshaM gatavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","tata iphiShanagara upasthAya tatra tau visR^ijya svayaM bhajanabhvanaM pravishya yihUdIyaiH saha vichAritavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","te svaiH sArddhaM punaH katipayadinAni sthAtuM taM vyanayan, sa tadanurarIkR^itya kathAmetAM kathitavAn, ");
INSERT INTO sanitr_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","yirUshAlami AgAmyutsavapAlanArthaM mayA gamanIyaM; pashchAd IshvarechChAyAM jAtAyAM yuShmAkaM samIpaM pratyAgamiShyAmi| tataH paraM sa tai rvisR^iShTaH san jalapathena iphiShanagarAt prasthitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","tataH kaisariyAm upasthitaH san nagaraM gatvA samAjaM namaskR^itya tasmAd AntiyakhiyAnagaraM prasthitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","tatra kiyatkAlaM yApayitvA tasmAt prasthAya sarvveShAM shiShyANAM manAMsi susthirANi kR^itvA kramasho galAtiyAphrugiyAdeshayo rbhramitvA gatavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","tasminneva samaye sikandariyAnagare jAta ApallonAmA shAstravit suvaktA yihUdIya eko jana iphiShanagaram AgatavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","sa shikShitaprabhumArgo manasodyogI cha san yohano majjanamAtraM j nAtvA yathArthatayA prabhoH kathAM kathayan samupAdishat| ");
INSERT INTO sanitr_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","eSha jano nirbhayatvena bhajanabhavane kathayitum ArabdhavAn, tataH priskillAkkilau tasyopadeshakathAM nishamya taM svayoH samIpam AnIya shuddharUpeNeshvarasya kathAm abodhayatAm| ");
INSERT INTO sanitr_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","pashchAt sa AkhAyAdeshaM gantuM matiM kR^itavAn, tadA tatratyaH shiShyagaNo yathA taM gR^ihlAti tadarthaM bhrAtR^igaNena samAshvasya patre likhite sati, ApallAstatropasthitaH san anugraheNa pratyayinAM bahUpakArAn akarot, ");
INSERT INTO sanitr_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","phalato yIshurabhiShiktastrAteti shAstrapramANaM datvA prakAsharUpeNa pratipannaM kR^itvA yihUdIyAn niruttarAn kR^itavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","karinthanagara ApallasaH sthitikAle paula uttarapradeshairAgachChan iphiShanagaram upasthitavAn| tatra katipayashiShyAn sAkShat prApya tAn apR^ichChat, ");
INSERT INTO sanitr_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","yUyaM vishvasya pavitramAtmAnaM prAptA na vA? tataste pratyavadan pavitra AtmA dIyate ityasmAbhiH shrutamapi nahi| ");
INSERT INTO sanitr_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","tadA sA.avadat tarhi yUyaM kena majjitA abhavata? te.akathayan yohano majjanena| ");
INSERT INTO sanitr_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","tadA paula uktavAn itaH paraM ya upasthAsyati tasmin arthata yIshukhrIShTe vishvasitavyamityuktvA yohan manaHparivarttanasUchakena majjanena jale lokAn amajjayat| ");
INSERT INTO sanitr_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","tAdR^ishIM kathAM shrutvA te prabho ryIshukhrIShTasya nAmnA majjitA abhavan| ");
INSERT INTO sanitr_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","tataH paulena teShAM gAtreShu kare.arpite teShAmupari pavitra AtmAvarUDhavAn, tasmAt te nAnAdeshIyA bhAShA bhaviShyatkathAshcha kathitavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","te prAyeNa dvAdashajanA Asan| ");
INSERT INTO sanitr_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","paulo bhajanabhavanaM gatvA prAyeNa mAsatrayam Ishvarasya rAjyasya vichAraM kR^itvA lokAn pravartya sAhasena kathAmakathayat| ");
INSERT INTO sanitr_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","kintu kaThinAntaHkaraNatvAt kiyanto janA na vishvasya sarvveShAM samakSham etatpathasya nindAM karttuM pravR^ittAH, ataH paulasteShAM samIpAt prasthAya shiShyagaNaM pR^ithakkR^itvA pratyahaM turAnnanAmnaH kasyachit janasya pAThashAlAyAM vichAraM kR^itavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","itthaM vatsaradvayaM gataM tasmAd AshiyAdeshanivAsinaH sarvve yihUdIyA anyadeshIyalokAshcha prabho ryIshoH kathAm ashrauShan| ");
INSERT INTO sanitr_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","paulena cha Ishvara etAdR^ishAnyadbhutAni karmmANi kR^itavAn ");
INSERT INTO sanitr_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","yat paridheye gAtramArjanavastre vA tasya dehAt pIDitalokAnAm samIpam AnIte te nirAmayA jAtA apavitrA bhUtAshcha tebhyo bahirgatavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","tadA deshATanakAriNaH kiyanto yihUdIyA bhUtApasAriNo bhUtagrastanokAnAM sannidhau prabhe ryIsho rnAma japtvA vAkyamidam avadan, yasya kathAM paulaH prachArayati tasya yIsho rnAmnA yuShmAn Aj nApayAmaH| ");
INSERT INTO sanitr_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","skivanAmno yihUdIyAnAM pradhAnayAjakasya saptabhiH puttaistathA kR^ite sati ");
INSERT INTO sanitr_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","kashchid apavitro bhUtaH pratyuditavAn, yIshuM jAnAmi paula ncha parichinomi kintu ke yUyaM? ");
INSERT INTO sanitr_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ityuktvA sopavitrabhUtagrasto manuShyo lamphaM kR^itvA teShAmupari patitvA balena tAn jitavAn, tasmAtte nagnAH kShatA NgAshcha santastasmAd gehAt palAyanta| ");
INSERT INTO sanitr_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","sA vAg iphiShanagaranivAsinasaM sarvveShAM yihUdIyAnAM bhinnadeshIyAnAM lokAnA ncha shravogocharIbhUtA; tataH sarvve bhayaM gatAH prabho ryIsho rnAmno yasho .avarddhata| ");
INSERT INTO sanitr_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","yeShAmanekeShAM lokAnAM pratItirajAyata ta Agatya svaiH kR^itAH kriyAH prakAsharUpeNA NgIkR^itavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","bahavo mAyAkarmmakAriNaH svasvagranthAn AnIya rAshIkR^itya sarvveShAM samakSham adAhayan, tato gaNanAM kR^itvAbudhyanta pa nchAyutarUpyamudrAmUlyapustakAni dagdhAni| ");
INSERT INTO sanitr_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","itthaM prabhoH kathA sarvvadeshaM vyApya prabalA jAtA| ");
INSERT INTO sanitr_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","sarvveShveteShu karmmasu sampanneShu satsu paulo mAkidaniyAkhAyAdeshAbhyAM yirUshAlamaM gantuM matiM kR^itvA kathitavAn tatsthAnaM yAtrAyAM kR^itAyAM satyAM mayA romAnagaraM draShTavyaM| ");
INSERT INTO sanitr_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","svAnugatalokAnAM tImathiyerAstau dvau janau mAkidaniyAdeshaM prati prahitya svayam AshiyAdeshe katipayadinAni sthitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","kintu tasmin samaye mate.asmin kalaho jAtaH| ");
INSERT INTO sanitr_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","tatkAraNamidaM, arttimIdevyA rUpyamandiranirmmANena sarvveShAM shilpinAM yatheShTalAbham ajanayat yo dImItriyanAmA nADIndhamaH ");
INSERT INTO sanitr_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","sa tAn tatkarmmajIvinaH sarvvalokAMshcha samAhUya bhAShitavAn he mahechChA etena mandiranirmmANenAsmAkaM jIvikA bhavati, etad yUyaM vittha; ");
INSERT INTO sanitr_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","kintu hastanirmmiteshvarA IshvarA nahi paulanAmnA kenachijjanena kathAmimAM vyAhR^itya kevalephiShanagare nahi prAyeNa sarvvasmin AshiyAdeshe pravR^ittiM grAhayitvA bahulokAnAM shemuShI parAvarttitA, etad yuShmAbhi rdR^ishyate shrUyate cha| ");
INSERT INTO sanitr_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","tenAsmAkaM vANijyasya sarvvathA hAneH sambhavanaM kevalamiti nahi, AshiyAdeshasthai rvA sarvvajagatsthai rlokaiH pUjyA yArtimI mahAdevI tasyA mandirasyAvaj nAnasya tasyA aishvaryyasya nAshasya cha sambhAvanA vidyateे| ");
INSERT INTO sanitr_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","etAdR^ishIM kathAM shrutvA te mahAkrodhAnvitAH santa uchchaiHkAraM kathitavanta iphiShIyAnAm arttimI devI mahatI bhavati| ");
INSERT INTO sanitr_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","tataH sarvvanagaraM kalahena paripUrNamabhavat, tataH paraM te mAkidanIyagAyAristArkhanAmAnau paulasya dvau sahacharau dhR^itvaikachittA ra NgabhUmiM javena dhAvitavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","tataH paulo lokAnAM sannidhiM yAtum udyatavAn kintu shiShyagaNastaM vAritavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","paulasyatmIyA AshiyAdeshasthAH katipayAH pradhAnalokAstasya samIpaM naramekaM preShya tvaM ra NgabhUmiM mAgA iti nyavedayan| ");
INSERT INTO sanitr_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","tato nAnAlokAnAM nAnAkathAkathanAt sabhA vyAkulA jAtA kiM kAraNAd etAvatI janatAbhavat etad adhikai rlokai rnAj nAyi| ");
INSERT INTO sanitr_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","tataH paraM janatAmadhyAd yihUdIyairbahiShkR^itaH sikandaro hastena sa NketaM kR^itvA lokebhya uttaraM dAtumudyatavAn, ");
INSERT INTO sanitr_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","kintu sa yihUdIyaloka iti nishchite sati iphiShIyAnAm arttimI devI mahatIti vAkyaM prAyeNa pa ncha daNDAn yAvad ekasvareNa lokanivahaiH proktaM| ");
INSERT INTO sanitr_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","tato nagarAdhipatistAn sthirAn kR^itvA kathitavAn he iphiShAyAH sarvve lokA AkarNayata, artimImahAdevyA mahAdevAt patitAyAstatpratimAyAshcha pUjanama iphiShanagarasthAH sarvve lokAH kurvvanti, etat ke na jAnanti? ");
INSERT INTO sanitr_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","tasmAd etatpratikUlaM kepi kathayituM na shaknuvanti, iti j nAtvA yuShmAbhiH susthiratvena sthAtavyam avivichya kimapi karmma na karttavya ncha| ");
INSERT INTO sanitr_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","yAn etAn manuShyAn yUyamatra samAnayata te mandiradravyApahArakA yuShmAkaM devyA nindakAshcha na bhavanti| ");
INSERT INTO sanitr_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","yadi ka nchana prati dImItriyasya tasya sahAyAnA ncha kAchid Apatti rvidyate tarhi pratinidhilokA vichArasthAna ncha santi, te tat sthAnaM gatvA uttarapratyuttare kurvvantu| ");
INSERT INTO sanitr_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","kintu yuShmAkaM kAchidaparA kathA yadi tiShThati tarhi niyamitAyAM sabhAyAM tasyA niShpatti rbhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","kintvetasya virodhasyottaraM yena dAtuM shaknum etAdR^ishasya kasyachit kAraNasyAbhAvAd adyatanaghaTanAheto rAjadrohiNAmivAsmAkam abhiyogo bhaviShyatIti sha NkA vidyate| ");
INSERT INTO sanitr_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","iti kathayitvA sa sabhAsthalokAn visR^iShTavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","itthaM kalahe nivR^itte sati paulaH shiShyagaNam AhUya visarjanaM prApya mAkidaniyAdeshaM prasthitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","tena sthAnena gachChan taddeshIyAn shiShyAn bahUpadishya yUnAnIyadesham upasthitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","tatra mAsatrayaM sthitvA tasmAt suriyAdeshaM yAtum udyataH, kintu yihUdIyAstaM hantuM guptA atiShThan tasmAt sa punarapi mAkidaniyAmArgeNa pratyAgantuM matiM kR^itavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","birayAnagarIyasopAtraH thiShalanIkIyAristArkhasikundau darbbonagarIyagAyatImathiyau AshiyAdeshIyatukhikatraphimau cha tena sArddhaM AshiyAdeshaM yAvad gatavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ete sarvve .agrasarAH santo .asmAn apekShya troyAnagare sthitavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","kiNvashUnyapUpotsavadine cha gate sati vayaM philipInagarAt toyapathena gatvA pa nchabhi rdinaistroyAnagaram upasthAya tatra saptadinAnyavAtiShThAma| ");
INSERT INTO sanitr_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","saptAhasya prathamadine pUpAn bhaMktu shiShyeShu militeShu paulaH paradine tasmAt prasthAtum udyataH san tadahni prAyeNa kShapAyA yAmadvayaM yAvat shiShyebhyo dharmmakathAm akathayat| ");
INSERT INTO sanitr_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","uparisthe yasmin prakoShThe sabhAM kR^itvAsan tatra bahavaH pradIpAH prAjvalan| ");
INSERT INTO sanitr_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","utukhanAmA kashchana yuvA cha vAtAyana upavishan ghorataranidrAgrasto .abhUt tadA paulena bahukShaNaM kathAyAM prachAritAyAM nidrAmagnaH sa tasmAd uparisthatR^itIyaprakoShThAd apatat, tato lokAstaM mR^itakalpaM dhR^itvodatolayan| ");
INSERT INTO sanitr_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","tataH paulo.avaruhya tasya gAtre patitvA taM kroDe nidhAya kathitavAn, yUyaM vyAkulA mA bhUta nAyaM prANai rviyuktaH| ");
INSERT INTO sanitr_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","pashchAt sa punashchopari gatvA pUpAn bhaMktvA prabhAtaM yAvat kathopakathane kR^itvA prasthitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","te cha taM jIvantaM yuvAnaM gR^ihItvA gatvA paramApyAyitA jAtAH| ");
INSERT INTO sanitr_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","anantaraM vayaM potenAgrasarA bhUtvAsmanagaram uttIryya paulaM grahItuM matim akurmma yataH sa tatra padbhyAM vrajituM matiM kR^itveti nirUpitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","tasmAt tatrAsmAbhiH sArddhaM tasmin milite sati vayaM taM nItvA mitulInyupadvIpaM prAptavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","tasmAt potaM mochayitvA pare.ahani khIyopadvIpasya sammukhaM labdhavantastasmAd ekenAhnA sAmopadvIpaM gatvA potaM lAgayitvA trogulliye sthitvA parasmin divaseे milItanagaram upAtiShThAma| ");
INSERT INTO sanitr_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","yataH paula AshiyAdeshe kAlaM yApayitum nAbhilaShan iphiShanagaraM tyaktvA yAtuM mantraNAM sthirIkR^itavAn; yasmAd yadi sAdhyaM bhavati tarhi nistArotsavasya pa nchAshattamadine sa yirUshAlamyupasthAtuM matiM kR^itavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","paulo milItAd iphiShaM prati lokaM prahitya samAjasya prAchInAn AhUyAnItavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","teShu tasya samIpam upasthiteShu sa tebhya imAM kathAM kathitavAn, aham AshiyAdeshe prathamAgamanam ArabhyAdya yAvad yuShmAkaM sannidhau sthitvA sarvvasamaye yathAcharitavAn tad yUyaM jAnItha; ");
INSERT INTO sanitr_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","phalataH sarvvathA namramanAH san bahushrupAtena yihudIyAnAm kumantraNAjAtanAnAparIkShAbhiH prabhoH sevAmakaravaM| ");
INSERT INTO sanitr_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","kAmapi hitakathAाM na gopAyitavAn tAM prachAryya saprakAshaM gR^ihe gR^ihe samupadishyeshvaraM prati manaH parAvarttanIyaM prabhau yIshukhrIShTe vishvasanIyaM ");
INSERT INTO sanitr_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","yihUdIyAnAm anyadeshIyalokAnA ncha samIpa etAdR^ishaM sAkShyaM dadAmi| ");
INSERT INTO sanitr_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","pashyata sAmpratam AtmanAkR^iShTaH san yirUshAlamnagare yAtrAM karomi, tatra mAmprati yadyad ghaTiShyate tAnyahaM na jAnAmi; ");
INSERT INTO sanitr_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","kintu mayA bandhanaM kleshashcha bhoktavya iti pavitra AtmA nagare nagare pramANaM dadAti| ");
INSERT INTO sanitr_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","tathApi taM kleshamahaM tR^iNAya na manye; IshvarasyAnugrahaviShayakasya susaMvAdasya pramANaM dAtuM, prabho ryIshoH sakAshAda yasyAH sevAyAH bhAraM prApnavaM tAM sevAM sAdhayituM sAnandaM svamArgaM samApayituु ncha nijaprANAnapi priyAn na manye| ");
INSERT INTO sanitr_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","adhunA pashyata yeShAM samIpe.aham IshvarIyarAjyasya susaMvAdaM prachAryya bhramaNaM kR^itavAn etAdR^ishA yUyaM mama vadanaM puna rdraShTuM na prApsyatha etadapyahaM jAnAmi| ");
INSERT INTO sanitr_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","yuShmabhyam aham Ishvarasya sarvvAn AdeshAn prakAshayituM na nyavartte| ");
INSERT INTO sanitr_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","ahaM sarvveShAM lokAnAM raktapAtadoShAd yannirdoSha Ase tasyAdya yuShmAn sAkShiNaH karomi| ");
INSERT INTO sanitr_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","yUyaM sveShu tathA yasya vrajasyAdhyakShan AtmA yuShmAn vidhAya nyayu Nkta tatsarvvasmin sAvadhAnA bhavata, ya samAja ncha prabhu rnijaraktamUlyena krItavAna tam avata, ");
INSERT INTO sanitr_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","yato mayA gamane kR^itaeva durjayA vR^ikA yuShmAkaM madhyaM pravishya vrajaM prati nirdayatAm AchariShyanti, ");
INSERT INTO sanitr_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","yuShmAkameva madhyAdapi lokA utthAya shiShyagaNam apahantuM viparItam upadekShyantItyahaM jAnAmi| ");
INSERT INTO sanitr_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","iti heto ryUyaM sachaitanyAH santastiShTata, aha ncha sAshrupAtaH san vatsaratrayaM yAvad divAnishaM pratijanaM bodhayituM na nyavartte tadapi smarata| ");
INSERT INTO sanitr_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","idAnIM he bhrAtaro yuShmAkaM niShThAM janayituM pavitrIkR^italokAnAM madhye.adhikAra ncha dAtuM samartho ya IshvarastasyAnugrahasya yo vAdashcha tayorubhayo ryuShmAn samArpayam| ");
INSERT INTO sanitr_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","kasyApi svarNaM rUpyaM vastraM vA prati mayA lobho na kR^itaH| ");
INSERT INTO sanitr_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","kintu mama matsahacharalokAnA nchAvashyakavyayAya madIyamidaM karadvayam ashrAmyad etad yUyaM jAnItha| ");
INSERT INTO sanitr_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","anena prakAreNa grahaNad dAnaM bhadramiti yadvAkyaM prabhu ryIshuH kathitavAn tat smarttuM daridralokAnAmupakArArthaM shramaM karttu ncha yuShmAkam uchitam etatsarvvaM yuShmAnaham upadiShTavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","etAM kathAM kathayitvA sa jAnunI pAtayitvA sarvaiH saha prArthayata| ");
INSERT INTO sanitr_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","tena te krandrantaH ");
INSERT INTO sanitr_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","puna rmama mukhaM na drakShyatha visheShata eShA yA kathA tenAkathi tatkAraNAt shokaM vilApa ncha kR^itvA kaNThaM dhR^itvA chumbitavantaH| pashchAt te taM potaM nItavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","tai rvisR^iShTAH santo vayaM potaM bAhayitvA R^ijumArgeNa koSham upadvIpam Agatya pare.ahani rodiyopadvIpam AgachChAma tatastasmAt pAtArAyAm upAtiShThAma| ");
INSERT INTO sanitr_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","tatra phainIkiyAdeshagAminam potamekaM prApya tamAruhya gatavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","kupropadvIpaM dR^iShTvA taM savyadishi sthApayitvA suriyAdeshaM gatvA potasthadravyANyavarohayituM soranagare lAgitavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","tatra shiShyagaNasya sAkShAtkaraNAya vayaM tatra saptadinAni sthitavantaH pashchAtte pavitreNAtmanA paulaM vyAharan tvaM yirUshAlamnagaraM mA gamaH| ");
INSERT INTO sanitr_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","tatasteShu saptasu dineShu yApiteShu satsu vayaM tasmAt sthAnAt nijavartmanA gatavantaH, tasmAt te sabAlavR^iddhavanitA asmAbhiH saha nagarasya parisaraparyyantam AgatAH pashchAdvayaM jaladhitaTe jAnupAtaM prArthayAmahi| ");
INSERT INTO sanitr_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","tataH parasparaM visR^iShTAH santo vayaM potaM gatAste tu svasvagR^ihaM pratyAgatavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","vayaM soranagarAt nAvA prasthAya talimAyinagaram upAtiShThAma tatrAsmAkaM samudrIyamArgasyAnto.abhavat tatra bhrAtR^igaNaM namaskR^itya dinamekaM taiH sArddham uShatavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","pare .ahani paulastasya sa Ngino vaya ncha pratiShThamAnAH kaisariyAnagaram Agatya susaMvAdaprachArakAnAM saptajanAnAM philipanAmna ekasya gR^ihaM pravishyAvatiShThAma| ");
INSERT INTO sanitr_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","tasya chatasro duhitaro.anUDhA bhaviShyadvAdinya Asan| ");
INSERT INTO sanitr_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","tatrAsmAsu bahudinAni proShiteShu yihUdIyadeshAd AgatyAgAbanAmA bhaviShyadvAdI samupasthitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","sosmAkaM samIpametya paulasya kaTibandhanaM gR^ihItvA nijahastApAdAn baddhvA bhAShitavAn yasyedaM kaTibandhanaM taM yihUdIyalokA yirUshAlamanagara itthaM baddhvA bhinnadeshIyAnAM kareShu samarpayiShyantIti vAkyaM pavitra AtmA kathayati| ");
INSERT INTO sanitr_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","etAdR^ishIM kathAM shrutvA vayaM tannagaravAsino bhrAtarashcha yirUshAlamaM na yAtuM paulaM vyanayAmahi; ");
INSERT INTO sanitr_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","kintu sa pratyAvAdIt, yUyaM kiM kurutha? kiM krandanena mamAntaHkaraNaM vidIrNaM kariShyatha? prabho ryIsho rnAmno nimittaM yirUshAlami baddho bhavituM kevala tanna prANAn dAtumapi sasajjosmi| ");
INSERT INTO sanitr_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","tenAsmAkaM kathAyAm agR^ihItAyAm Ishvarasya yathechChA tathaiva bhavatvityuktvA vayaM nirasyAma| ");
INSERT INTO sanitr_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","pare.ahani pAtheyadravyANi gR^ihItvA yirUshAlamaM prati yAtrAm akurmma| ");
INSERT INTO sanitr_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","tataH kaisariyAnagaranivAsinaH katipayAH shiShyA asmAbhiH sArddham itvA kR^iprIyena mnAsannAmnA yena prAchInashiShyena sArddham asmAbhi rvastavyaM tasya samIpam asmAn nItavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","asmAsu yirUshAlamyupasthiteShu tatrasthabhrAtR^igaNo.asmAn AhlAdena gR^ihItavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","parasmin divase paule.asmAbhiH saha yAkUbo gR^ihaM praviShTe lokaprAchInAH sarvve tatra pariShadi saMsthitAH| ");
INSERT INTO sanitr_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","anantaraM sa tAn natvA svIyaprachAraNena bhinnadeshIyAn pratIshvaro yAni karmmANi sAdhitavAn tadIyAM kathAm anukramAt kathitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","iti shrutvA te prabhuM dhanyaM prochya vAkyamidam abhAShanta, he bhrAta ryihUdIyAnAM madhye bahusahasrANi lokA vishvAsina Asate kintu te sarvve vyavasthAmatAchAriNa etat pratyakShaM pashyasi| ");
INSERT INTO sanitr_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","shishUnAM tvakChedanAdyAcharaNaM pratiShidhya tvaM bhinnadeshanivAsino yihUdIyalokAn mUsAvAkyam ashraddhAtum upadishasIti taiH shrutamasti| ");
INSERT INTO sanitr_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","tvamatrAgatosIti vArttAM samAkarNya jananivaho militvAvashyamevAgamiShyati; ataeva kiM karaNIyam? atra vayaM mantrayitvA samupAyaM tvAM vadAmastaM tvamAchara| ");
INSERT INTO sanitr_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","vrataM karttuM kR^itasa NkalpA ye.asmAMka chatvAro mAnavAH santi ");
INSERT INTO sanitr_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","tAn gR^ihItvA taiH sahitaH svaM shuchiM kuru tathA teShAM shiromuNDane yo vyayo bhavati taM tvaM dehi| tathA kR^ite tvadIyAchAre yA janashruti rjAyate sAlIkA kintu tvaM vidhiM pAlayan vyavasthAnusAreNevAcharasIti te bhotsante| ");
INSERT INTO sanitr_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","bhinnadeshIyAnAM vishvAsilokAnAM nikaTe vayaM patraM likhitvetthaM sthirIkR^itavantaH, devaprasAdabhojanaM raktaM galapIDanamAritaprANibhojanaM vyabhichArashchaitebhyaH svarakShaNavyatirekeNa teShAmanyavidhipAlanaM karaNIyaM na| ");
INSERT INTO sanitr_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","tataH paulastAn mAnuShAnAdAya parasmin divase taiH saha shuchi rbhUtvA mandiraM gatvA shauchakarmmaNo dineShu sampUrNeShu teShAm ekaikArthaM naivedyAdyutsargo bhaviShyatIti j nApitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","teShu saptasu dineShu samAptakalpeShu AshiyAdeshanivAsino yihUdIyAstaM madhyemandiraM vilokya jananivahasya manaHsu kupravR^ittiM janayitvA taM dhR^itvA ");
INSERT INTO sanitr_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","prochchaiH prAvochan, he isrAyellokAH sarvve sAhAyyaM kuruta| yo manuja eteShAM lokAnAM mUsAvyavasthAyA etasya sthAnasyApi viparItaM sarvvatra sarvvAn shikShayati sa eShaH; visheShataH sa bhinnadeshIyalokAn mandiram AnIya pavitrasthAnametad apavitramakarot| ");
INSERT INTO sanitr_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","pUrvvaM te madhyenagaram iphiShanagarIyaM traphimaM paulena sahitaM dR^iShTavanta etasmAt paulastaM mandiramadhyam Anayad ityanvamimata| ");
INSERT INTO sanitr_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","ataeva sarvvasmin nagare kalahotpannatvAt dhAvanto lokA Agatya paulaM dhR^itvA mandirasya bahirAkR^iShyAnayan tatkShaNAd dvArANi sarvvANi cha ruddhAni| ");
INSERT INTO sanitr_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","teShu taM hantumudyateेShu yirUshAlamnagare mahAnupadravo jAta iti vArttAyAM sahasrasenApateH karNagocharIbhUtAyAM satyAM sa tatkShaNAt sainyAni senApatigaNa ncha gR^ihItvA javenAgatavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","tato lokAH senAgaNena saha sahasrasenApatim AgachChantaM dR^iShTvA paulatADanAto nyavarttanta| ");
INSERT INTO sanitr_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","sa sahasrasenApatiH sannidhAvAgamya paulaM dhR^itvA shR^i Nkhaladvayena baddham Adishya tAn pR^iShTavAn eSha kaH? kiM karmma chAyaM kR^itavAn? ");
INSERT INTO sanitr_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","tato janasamUhasya kashchid ekaprakAraM kashchid anyaprakAraM vAkyam araut sa tatra satyaM j nAtum kalahakAraNAd ashaktaH san taM durgaM netum Aj nApayat| ");
INSERT INTO sanitr_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","teShu sopAnasyopari prApteShu lokAnAM sAhasakAraNAt senAgaNaH paulamuttolya nItavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","tataH sarvve lokAH pashchAdgAminaH santa enaM durIkuruteti vAkyam uchchairavadan| ");
INSERT INTO sanitr_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","paulasya durgAnayanasamaye sa tasmai sahasrasenApataye kathitavAn, bhavataH purastAt kathAM kathayituM kim anumanyate? sa tamapR^ichChat tvaM kiM yUnAnIyAM bhAShAM jAnAsi? ");
INSERT INTO sanitr_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","yo misarIyo janaH pUrvvaM virodhaM kR^itvA chatvAri sahasrANi ghAtakAn sa NginaH kR^itvA vipinaM gatavAn tvaM kiM saeva na bhavasi? ");
INSERT INTO sanitr_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","tadA paulo.akathayat ahaM kilikiyAdeshasya tArShanagarIyo yihUdIyo, nAhaM sAmAnyanagarIyo mAnavaH; ataeva vinaye.ahaM lAkAnAM samakShaM kathAM kathayituM mAmanujAnIShva| ");
INSERT INTO sanitr_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","tenAnuj nAtaH paulaH sopAnopari tiShThan hastene NgitaM kR^itavAn, tasmAt sarvve susthirA abhavan| tadA paula ibrIyabhAShayA kathayitum Arabhata, ");
INSERT INTO sanitr_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","he pitR^igaNA he bhrAtR^igaNAH, idAnIM mama nivedane samavadhatta| ");
INSERT INTO sanitr_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","tadA sa ibrIyabhAShayA kathAM kathayatIti shrutvA sarvve lokA atIva niHshabdA santo.atiShThan| ");
INSERT INTO sanitr_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","pashchAt so.akathayad ahaM yihUdIya iti nishchayaH kilikiyAdeshasya tArShanagaraM mama janmabhUmiH,etannagarIyasya gamilIyelanAmno.adhyApakasya shiShyo bhUtvA pUrvvapuruShANAM vidhivyavasthAnusAreNa sampUrNarUpeNa shikShito.abhavam idAnIntanA yUyaM yAdR^ishA bhavatha tAdR^isho.ahamapIshvarasevAyAm udyogI jAtaH| ");
INSERT INTO sanitr_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","matametad dviShTvA tadgrAhinArIpuruShAn kArAyAM baddhvA teShAM prANanAshaparyyantAM vipakShatAm akaravam| ");
INSERT INTO sanitr_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","mahAyAjakaH sabhAsadaH prAchInalokAshcha mamaitasyAH kathAyAH pramANaM dAtuM shaknuvanti, yasmAt teShAM samIpAd dammeShakanagaranivAsibhrAtR^igaNArtham Aj nApatrANi gR^ihItvA ye tatra sthitAstAn daNDayituM yirUshAlamam AnayanArthaM dammeShakanagaraM gatosmi| ");
INSERT INTO sanitr_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","kintu gachChan tannagarasya samIpaM prAptavAn tadA dvitIyapraharavelAyAM satyAm akasmAd gagaNAnnirgatya mahatI dIpti rmama chaturdishi prakAshitavatI| ");
INSERT INTO sanitr_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","tato mayi bhUmauै patite sati, he shaula he shaula kuto mAM tADayasi? mAmprati bhAShita etAdR^isha eko ravopi mayA shrutaH| ");
INSERT INTO sanitr_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","tadAhaM pratyavadaM, he prabhe ko bhavAn? tataH so.avAdIt yaM tvaM tADayasi sa nAsaratIyo yIshurahaM| ");
INSERT INTO sanitr_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","mama sa Ngino lokAstAM dIptiM dR^iShTvA bhiyaM prAptAH, kintu mAmpratyuditaM tadvAkyaM teे nAbudhyanta| ");
INSERT INTO sanitr_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","tataH paraM pR^iShTavAnahaM, he prabho mayA kiM karttavyaM? tataH prabhurakathayat, utthAya dammeShakanagaraM yAhi tvayA yadyat karttavyaM nirUpitamAste tat tatra tvaM j nApayiShyase| ");
INSERT INTO sanitr_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","anantaraM tasyAH kharataradIpteH kAraNAt kimapi na dR^iShTvA sa NgigaNena dhR^itahastaH san dammeShakanagaraM vrajitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","tannagaranivAsinAM sarvveShAM yihUdIyAnAM mAnyo vyavasthAnusAreNa bhaktashcha hanAnIyanAmA mAnava eko ");
INSERT INTO sanitr_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","mama sannidhim etya tiShThan akathayat, he bhrAtaH shaula sudR^iShTi rbhava tasmin daNDe.ahaM samyak taM dR^iShTavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","tataH sa mahyaM kathitavAn yathA tvam IshvarasyAbhiprAyaM vetsi tasya shuddhasattvajanasya darshanaM prApya tasya shrImukhasya vAkyaM shR^iNoShi tannimittam asmAkaM pUrvvapuruShANAm IshvarastvAM manonItaM kR^itavAnaM| ");
INSERT INTO sanitr_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","yato yadyad adrAkShIrashrauShIshcha sarvveShAM mAnavAnAM samIpe tvaM teShAM sAkShI bhaviShyasi| ");
INSERT INTO sanitr_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","ataeva kuto vilambase? prabho rnAmnA prArthya nijapApaprakShAlanArthaM majjanAya samuttiShTha| ");
INSERT INTO sanitr_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","tataH paraM yirUshAlamnagaraM pratyAgatya mandire.aham ekadA prArthaye, tasmin samaye.aham abhibhUtaH san prabhUM sAkShAt pashyan, ");
INSERT INTO sanitr_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","tvaM tvarayA yirUshAlamaH pratiShThasva yato lokAmayi tava sAkShyaM na grahIShyanti, mAmpratyuditaM tasyedaM vAkyam ashrauSham| ");
INSERT INTO sanitr_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","tatohaM pratyavAdiSham he prabho pratibhajanabhavanaM tvayi vishvAsino lokAn baddhvA prahR^itavAn, ");
INSERT INTO sanitr_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","tathA tava sAkShiNaH stiphAnasya raktapAtanasamaye tasya vinAshaM sammanya sannidhau tiShThan hantR^ilokAnAM vAsAMsi rakShitavAn, etat te viduH| ");
INSERT INTO sanitr_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","tataH so.akathayat pratiShThasva tvAM dUrasthabhinnadeshIyAnAM samIpaM preShayiShye| ");
INSERT INTO sanitr_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","tadA lokA etAvatparyyantAM tadIyAM kathAM shrutvA prochchairakathayan, enaM bhUmaNDalAd dUrIkuruta, etAdR^ishajanasya jIvanaM nochitam| ");
INSERT INTO sanitr_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ityuchchaiH kathayitvA vasanAni parityajya gagaNaM prati dhUlIrakShipan ");
INSERT INTO sanitr_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","tataH sahasrasenApatiH paulaM durgAbhyantara netuM samAdishat| etasya pratikUlAH santo lokAH kinnimittam etAvaduchchaiHsvaram akurvvan, etad vettuM taM kashayA prahR^itya tasya parIkShAM karttumAdishat| ");
INSERT INTO sanitr_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","padAtayashcharmmanirmmitarajjubhistasya bandhanaM karttumudyatAstAstadAnIM paulaH sammukhasthitaM shatasenApatim uktavAn daNDAj nAyAm aprAptAyAM kiM romilokaM praharttuM yuShmAkam adhikArosti? ");
INSERT INTO sanitr_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","enAM kathAM shrutvA sa sahasrasenApateH sannidhiM gatvA tAM vArttAmavadat sa romiloka etasmAt sAvadhAnaH san karmma kuru| ");
INSERT INTO sanitr_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","tasmAt sahasrasenApati rgatvA tamaprAkShIt tvaM kiM romilokaH? iti mAM brUhi| so.akathayat satyam| ");
INSERT INTO sanitr_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","tataH sahasrasenApatiH kathitavAn bahudraviNaM dattvAhaM tat paurasakhyaM prAptavAn; kintu paulaH kathitavAn ahaM janunA tat prApto.asmi| ");
INSERT INTO sanitr_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","itthaM sati ye prahAreNa taM parIkShituM samudyatA Asan te tasya samIpAt prAtiShThanta; sahasrasenApatistaM romilokaM vij nAya svayaM yat tasya bandhanam akArShIt tatkAraNAd abibhet| ");
INSERT INTO sanitr_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","yihUdIyalokAH paulaM kuto.apavadante tasya vR^ittAntaM j nAtuM vA nChan sahasrasenApatiH pare.ahani paulaM bandhanAt mochayitvA pradhAnayAjakAn mahAsabhAyAH sarvvalokAshcha samupasthAtum Adishya teShAM sannidhau paulam avarohya sthApitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","sabhAsadlokAn prati paulo.ananyadR^iShTyA pashyan akathayat, he bhrAtR^igaNA adya yAvat saralena sarvvAntaHkaraNeneshvarasya sAkShAd AcharAmi| ");
INSERT INTO sanitr_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","anena hanAnIyanAmA mahAyAjakastaM kapole chapeTenAhantuM samIpasthalokAn AdiShTavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","tadA paulastamavadat, he bahiShpariShkR^ita, IshvarastvAM praharttum udyatosti, yato vyavasthAnusAreNa vichArayitum upavishya vyavasthAM la NghitvA mAM praharttum Aj nApayasi| ");
INSERT INTO sanitr_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","tato nikaTasthA lokA akathayan, tvaM kim Ishvarasya mahAyAjakaM nindasi? ");
INSERT INTO sanitr_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","tataH paulaH pratibhAShitavAn he bhrAtR^igaNa mahAyAjaka eSha iti na buddhaM mayA tadanyachcha svalokAnAm adhipatiM prati durvvAkyaM mA kathaya, etAdR^ishI lipirasti| ");
INSERT INTO sanitr_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","anantaraM paulasteShAm arddhaM sidUkilokA arddhaM phirUshilokA iti dR^iShTvA prochchaiH sabhAsthalokAn avadat he bhrAtR^igaNa ahaM phirUshimatAvalambI phirUshinaH satnAnashcha, mR^italokAnAm utthAne pratyAshAkaraNAd ahamapavAditosmi| ");
INSERT INTO sanitr_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","iti kathAyAM kathitAyAM phirUshisidUkinoH parasparaM bhinnavAkyatvAt sabhAyA madhye dvau saMghau jAtau| ");
INSERT INTO sanitr_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","yataH sidUkilokA utthAnaM svargIyadUtA AtmAnashcha sarvveShAm eteShAM kamapi na manyante, kintu phirUshinaH sarvvam a NgIkurvvanti| ");
INSERT INTO sanitr_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","tataH parasparam atishayakolAhale samupasthite phirUshinAM pakShIyAH sabhAsthA adhyApakAH pratipakShA uttiShThanto .akathayan, etasya mAnavasya kamapi doShaM na pashyAmaH; yadi kashchid AtmA vA kashchid dUta enaM pratyAdishat tarhi vayam Ishvarasya prAtikUlyena na yotsyAmaH| ");
INSERT INTO sanitr_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","tasmAd atIva bhinnavAkyatve sati te paulaM khaNDaM khaNDaM kariShyantItyAsha NkayA sahasrasenApatiH senAgaNaM tatsthAnaM yAtuM sabhAto balAt paulaM dhR^itvA durgaM neta nchAj nApayat| ");
INSERT INTO sanitr_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","rAtro prabhustasya samIpe tiShThan kathitavAn he paula nirbhayo bhava yathA yirUshAlamnagare mayi sAkShyaM dattavAn tathA romAnagarepi tvayA dAtavyam| ");
INSERT INTO sanitr_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","dine samupasthite sati kiyanto yihUdIyalokA ekamantraNAH santaH paulaM na hatvA bhojanapAne kariShyAma iti shapathena svAn abadhnan| ");
INSERT INTO sanitr_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","chatvAriMshajjanebhyo.adhikA lokA iti paNam akurvvan| ");
INSERT INTO sanitr_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","te mahAyAjakAnAM prAchInalokAnA ncha samIpaM gatvA kathayan, vayaM paulaM na hatvA kimapi na bhokShyAmahe dR^iDhenAnena shapathena baddhvA abhavAma| ");
INSERT INTO sanitr_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","ataeva sAmprataM sabhAsadlokaiH saha vayaM tasmin ka nchid visheShavichAraM kariShyAmastadarthaM bhavAn shvo .asmAkaM samIpaM tam Anayatviti sahasrasenApataye nivedanaM kuruta tena yuShmAkaM samIpaM upasthiteH pUrvvaM vayaM taM hantu sajjiShyAma| ");
INSERT INTO sanitr_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","tadA paulasya bhAgineyasteShAmiti mantraNAM vij nAya durgaM gatvA tAM vArttAM paulam uktavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","tasmAt paula ekaM shatasenApatim AhUya vAkyamidam bhAShitavAn sahasrasenApateH samIpe.asya yuvamanuShyasya ki nchinnivedanam Aste, tasmAt tatsavidham enaM naya| ");
INSERT INTO sanitr_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","tataH sa tamAdAya sahasrasenApateH samIpam upasthAya kathitavAn, bhavataH samIpe.asya kimapi nivedanamAste tasmAt bandiH paulo mAmAhUya bhavataH samIpam enam AnetuM prArthitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","tadA sahasrasenApatistasya hastaM dhR^itvA nirjanasthAnaM nItvA pR^iShThavAn tava kiM nivedanaM? tat kathaya| ");
INSERT INTO sanitr_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","tataH sokathayat, yihUdIyalAkAH paule kamapi visheShavichAraM ChalaM kR^itvA taM sabhAM netuM bhavataH samIpe nivedayituM amantrayan| ");
INSERT INTO sanitr_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","kintu mavatA tanna svIkarttavyaM yatasteShAM madhyevarttinashchatvAriMshajjanebhyo .adhikalokA ekamantraNA bhUtvA paulaM na hatvA bhojanaM pAna ncha na kariShyAma iti shapathena baddhAH santo ghAtakA iva sajjitA idAnIM kevalaM bhavato .anumatim apekShante| ");
INSERT INTO sanitr_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","yAmimAM kathAM tvaM niveditavAn tAM kasmaichidapi mA kathayetyuktvA sahasrasenApatistaM yuvAnaM visR^iShTavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","anantaraM sahasrasenApati rdvau shatasenApatI AhUyedam Adishat, yuvAM rAtrau praharaikAvashiShTAyAM satyAM kaisariyAnagaraM yAtuM padAtisainyAnAM dve shate ghoTakArohisainyAnAM saptatiM shaktidhArisainyAnAM dve shate cha janAn sajjitAn kurutaM| ");
INSERT INTO sanitr_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","paulam ArohayituM phIlikShAdhipateH samIpaM nirvvighnaM netu ncha vAhanAni samupasthApayataM| ");
INSERT INTO sanitr_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","aparaM sa patraM likhitvA dattavAn tallikhitametat, ");
INSERT INTO sanitr_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","mahAmahimashrIyuktaphIlikShAdhipataye klaudiyaluShiyasya namaskAraH| ");
INSERT INTO sanitr_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","yihUdIyalokAH pUrvvam enaM mAnavaM dhR^itvA svahastai rhantum udyatA etasminnantare sasainyohaM tatropasthAya eSha jano romIya iti vij nAya taM rakShitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","kinnimittaM te tamapavadante tajj nAtuM teShA sabhAM tamAnAyitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","tatasteShAM vyavasthAyA viruddhayA kayAchana kathayA so.apavAdito.abhavat, kintu sa shR^i NkhalabandhanArho vA prANanAshArho bhavatIdR^ishaH kopyaparAdho mayAsya na dR^iShTaH| ");
INSERT INTO sanitr_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","tathApi manuShyasyAsya vadhArthaM yihUdIyA ghAtakAiva sajjitA etAM vArttAM shrutvA tatkShaNAt tava samIpamenaM preShitavAn asyApavAdakAMshcha tava samIpaM gatvApavaditum Aj nApayam| bhavataH kushalaM bhUyAt| ");
INSERT INTO sanitr_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","sainyagaNa Aj nAnusAreNa paulaM gR^ihItvA tasyAM rajanyAm AntipAtrinagaram Anayat| ");
INSERT INTO sanitr_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","pare.ahani tena saha yAtuM ghoTakArUDhasainyagaNaM sthApayitvA parAvR^itya durgaM gatavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","tataH pare ghoTakArohisainyagaNaH kaisariyAnagaram upasthAya tatpatram adhipateH kare samarpya tasya samIpe paulam upasthApitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","tadAdhipatistatpatraM paThitvA pR^iShThavAn eSha kimpradeshIyo janaH? sa kilikiyApradeshIya eko jana iti j nAtvA kathitavAn, ");
INSERT INTO sanitr_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","tavApavAdakagaNa Agate tava kathAM shroShyAmi| herodrAjagR^ihe taM sthApayitum AdiShTavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","pa nchabhyo dinebhyaH paraM hanAnIyanAmA mahAyAjako.adhipateH samakShaM paulasya prAtikUlyena nivedayituM tartullanAmAnaM ka nchana vaktAraM prAchInajanAMshcha sa NginaH kR^itvA kaisariyAnagaram AgachChat| ");
INSERT INTO sanitr_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","tataH paule samAnIte sati tartullastasyApavAdakathAM kathayitum Arabhata he mahAmahimaphIlikSha bhavato vayam atinirvvighnaM kAlaM yApayAmo bhavataH pariNAmadarshitayA etaddeshIyAnAM bahUni ma NgalAni ghaTitAni, ");
INSERT INTO sanitr_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","iti heto rvayamatikR^itaj nAH santaH sarvvatra sarvvadA bhavato guNAn gAyamaH| ");
INSERT INTO sanitr_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","kintu bahubhiH kathAbhi rbhavantaM yena na vira njayAmi tasmAd vinaye bhavAn banukampya madalpakathAM shR^iNotu| ");
INSERT INTO sanitr_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","eSha mahAmArIsvarUpo nAsaratIyamatagrAhisaMghAtasya mukhyo bhUtvA sarvvadesheShu sarvveShAM yihUdIyAnAM rAjadrohAcharaNapravR^ittiM janayatItyasmAbhi rnishchitaM| ");
INSERT INTO sanitr_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","sa mandiramapi ashuchi karttuM cheShTitavAn; iti kAraNAd vayam enaM dhR^itvA svavyavasthAnusAreNa vichArayituM prAvarttAmahi; ");
INSERT INTO sanitr_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","kintu luShiyaH sahasrasenApatirAgatya balAd asmAkaM karebhya enaM gR^ihItvA ");
INSERT INTO sanitr_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","etasyApavAdakAn bhavataH samIpam Agantum Aj nApayat| vayaM yasmin tamapavAdAmo bhavatA padapavAdakathAyAM vichAritAyAM satyAM sarvvaM vR^ittAntaM vedituM shakShyate| ");
INSERT INTO sanitr_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","tato yihUdIyA api svIkR^itya kathitavanta eShA kathA pramANam| ");
INSERT INTO sanitr_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","adhipatau kathAM kathayituM paulaM pratI NgitaM kR^itavati sa kathitavAn bhavAn bahUn vatsarAn yAvad etaddeshasya shAsanaM karotIti vij nAya pratyuttaraM dAtum akShobho.abhavam| ");
INSERT INTO sanitr_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","adya kevalaM dvAdasha dinAni yAtAni, aham ArAdhanAM karttuM yirUshAlamanagaraM gatavAn eShA kathA bhavatA j nAtuM shakyate; ");
INSERT INTO sanitr_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","kintvibhe mAM madhyemandiraM kenApi saha vitaNDAM kurvvantaM kutrApi bhajanabhavane nagare vA lokAn kupravR^ittiM janayantuM na dR^iShTavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","idAnIM yasmin yasmin mAm apavadante tasya kimapi pramANaM dAtuM na shaknuvanti| ");
INSERT INTO sanitr_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","kintu bhaviShyadvAkyagranthe vyavasthAgranthe cha yA yA kathA likhitAste tAsu sarvvAsu vishvasya yanmatam ime vidharmmaM jAnanti tanmatAnusAreNAhaM nijapitR^ipuruShANAm Ishvaram ArAdhayAmItyahaM bhavataH samakSham a NgIkaromi| ");
INSERT INTO sanitr_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","dhArmmikANAm adhArmmikANA ncha pramItalokAnAmevotthAnaM bhaviShyatIti kathAmime svIkurvvanti tathAhamapi tasmin Ishvare pratyAshAM karomi; ");
INSERT INTO sanitr_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ishvarasya mAnavAnA ncha samIpe yathA nirdoSho bhavAmi tadarthaM satataM yatnavAn asmi| ");
INSERT INTO sanitr_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","bahuShu vatsareShu gateShu svadeshIyalokAnAM nimittaM dAnIyadravyANi naivedyAni cha samAdAya punarAgamanaM kR^itavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","tatohaM shuchi rbhUtvA lokAnAM samAgamaM kalahaM vA na kAritavAn tathApyAshiyAdeshIyAH kiyanto yihudIyalokA madhyemandiraM mAM dhR^itavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","mamopari yadi kAchidapavAdakathAsti tarhi bhavataH samIpam upasthAya teShAmeva sAkShyadAnam uchitam| ");
INSERT INTO sanitr_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","nochet pUrvve mahAsabhAsthAnAM lokAnAM sannidhau mama daNDAyamAnatvasamaye, ahamadya mR^itAnAmutthAne yuShmAbhi rvichAritosmi, ");
INSERT INTO sanitr_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","teShAM madhye tiShThannahaM yAmimAM kathAmuchchaiH svareNa kathitavAn tadanyo mama kopi doSho.alabhyata na veti varam ete samupasthitalokA vadantu| ");
INSERT INTO sanitr_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","tadA phIlikSha etAM kathAM shrutvA tanmatasya visheShavR^ittAntaM vij nAtuM vichAraM sthagitaM kR^itvA kathitavAn luShiye sahasrasenApatau samAyAte sati yuShmAkaM vichAram ahaM niShpAdayiShyAmi| ");
INSERT INTO sanitr_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","anantaraM bandhanaM vinA paulaM rakShituM tasya sevanAya sAkShAtkaraNAya vA tadIyAtmIyabandhujanAn na vArayitu ncha shamasenApatim AdiShTavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","alpadinAt paraM phIlikSho.adhipati rdruShillAnAmnA yihUdIyayA svabhAryyayA sahAgatya paulamAhUya tasya mukhAt khrIShTadharmmasya vR^ittAntam ashrauShIt| ");
INSERT INTO sanitr_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","paulena nyAyasya parimitabhogasya charamavichArasya cha kathAyAM kathitAyAM satyAM phIlikShaH kampamAnaH san vyAharad idAnIM yAhi, aham avakAshaM prApya tvAm AhUsyAmi| ");
INSERT INTO sanitr_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","muktipraptyarthaM paulena mahyaM mudrAdAsyante iti patyAshAM kR^itvA sa punaH punastamAhUya tena sAkaM kathopakathanaM kR^itavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","kintu vatsaradvayAt paraM parkiyaphIShTa phAlikShasya padaM prApte sati phIlikSho yihUdIyAn santuShTAn chikIrShan paulaM baddhaM saMsthApya gatavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","anantaraM phIShTo nijarAjyam Agatya dinatrayAt paraM kaisariyAto yirUshAlamnagaram Agamat| ");
INSERT INTO sanitr_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","tadA mahAyAjako yihUdIyAnAM pradhAnalokAshcha tasya samakShaM paulam apAvadanta| ");
INSERT INTO sanitr_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","bhavAn taM yirUshAlamam Anetum Aj nApayatviti vinIya te tasmAd anugrahaM vA nChitavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","yataH pathimadhye gopanena paulaM hantuM tai rghAtakA niyuktAH| phIShTa uttaraM dattavAn paulaH kaisariyAyAM sthAsyati punaralpadinAt param ahaM tatra yAsyAmi| ");
INSERT INTO sanitr_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","tatastasya mAnuShasya yadi kashchid aparAdhastiShThati tarhi yuShmAkaM ye shaknuvanti te mayA saha tatra gatvA tamapavadantu sa etAM kathAM kathitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","dashadivasebhyo.adhikaM vilambya phIShTastasmAt kaisariyAnagaraM gatvA parasmin divase vichArAsana upadishya paulam Anetum Aj nApayat| ");
INSERT INTO sanitr_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","paule samupasthite sati yirUshAlamnagarAd AgatA yihUdIyalokAstaM chaturdishi saMveShTya tasya viruddhaM bahUn mahAdoShAn utthApitavantaH kintu teShAM kimapi pramANaM dAtuM na shaknuvantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","tataH paulaH svasmin uttaramidam uditavAn, yihUdIyAnAM vyavasthAyA mandirasya kaisarasya vA pratikUlaM kimapi karmma nAhaM kR^itavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","kintu phIShTo yihUdIyAn santuShTAn karttum abhilaShan paulam abhAShata tvaM kiM yirUshAlamaM gatvAsmin abhiyoge mama sAkShAd vichArito bhaviShyasi? ");
INSERT INTO sanitr_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","tataH paula uttaraM proktavAn, yatra mama vichAro bhavituM yogyaH kaisarasya tatra vichArAsana eva samupasthitosmi; ahaM yihUdIyAnAM kAmapi hAniM nAkArSham iti bhavAn yathArthato vijAnAti| ");
INSERT INTO sanitr_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","ka nchidaparAdhaM ki nchana vadhArhaM karmma vA yadyaham akariShyaM tarhi prANahananadaNDamapi bhoktum udyato.abhaviShyaM, kintu te mama samapavAdaM kurvvanti sa yadi kalpitamAtro bhavati tarhi teShAM kareShu mAM samarpayituM kasyApyadhikAro nAsti, kaisarasya nikaTe mama vichAro bhavatu| ");
INSERT INTO sanitr_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","tadA phIShTo mantribhiH sArddhaM saMmantrya paulAya kathitavAn, kaisarasya nikaTe kiM tava vichAro bhaviShyati? kaisarasya samIpaM gamiShyasi| ");
INSERT INTO sanitr_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","kiyaddinebhyaH param AgripparAjA barNIkI cha phIShTaM sAkShAt karttuM kaisariyAnagaram Agatavantau| ");
INSERT INTO sanitr_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","tadA tau bahudinAni tatra sthitau tataH phIShTastaM rAjAnaM paulasya kathAM vij nApya kathayitum Arabhata paulanAmAnam ekaM bandi phIlikSho baddhaM saMsthApya gatavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","yirUshAlami mama sthitikAle mahAyAjako yihUdIyAnAM prAchInalokAshcha tam apodya tamprati daNDAj nAM prArthayanta| ");
INSERT INTO sanitr_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","tatoham ityuttaram avadaM yAvad apodito janaH svApavAdakAn sAkShAt kR^itvA svasmin yo.aparAdha Aropitastasya pratyuttaraM dAtuM suyogaM na prApnoti, tAvatkAlaM kasyApi mAnuShasya prANanAshAj nApanaM romilokAnAM rIti rnahi| ");
INSERT INTO sanitr_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","tatasteShvatrAgateShu parasmin divase.aham avilambaM vichArAsana upavishya taM mAnuSham Anetum Aj nApayam| ");
INSERT INTO sanitr_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","tadanantaraM tasyApavAdakA upasthAya yAdR^isham ahaM chintitavAn tAdR^ishaM ka nchana mahApavAdaM notthApya ");
INSERT INTO sanitr_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","sveShAM mate tathA paulo yaM sajIvaM vadati tasmin yIshunAmani mR^itajane cha tasya viruddhaM kathitavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","tatohaM tAdR^igvichAre saMshayAnaH san kathitavAn tvaM yirUshAlamaM gatvA kiM tatra vichArito bhavitum ichChasi? ");
INSERT INTO sanitr_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","tadA paulo mahArAjasya nikaTe vichArito bhavituM prArthayata, tasmAd yAvatkAlaM taM kaisarasya samIpaM preShayituM na shaknomi tAvatkAlaM tamatra sthApayitum AdiShTavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","tata AgrippaH phIShTam uktavAn, ahamapi tasya mAnuShasya kathAM shrotum abhilaShAmi| tadA phIShTo vyAharat shvastadIyAM kathAM tvaM shroShyasi| ");
INSERT INTO sanitr_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","parasmin divase Agrippo barNIkI cha mahAsamAgamaM kR^itvA pradhAnavAhinIpatibhi rnagarasthapradhAnalokaishcha saha militvA rAjagR^ihamAgatya samupasthitau tadA phIShTasyAj nayA paula AnIto.abhavat| ");
INSERT INTO sanitr_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","tadA phIShTaH kathitavAn he rAjan Agrippa he upasthitAH sarvve lokA yirUshAlamnagare yihUdIyalokasamUho yasmin mAnuShe mama samIpe nivedanaM kR^itvA prochchaiH kathAmimAM kathitavAn punaralpakAlamapi tasya jIvanaM nochitaM tametaM mAnuShaM pashyata| ");
INSERT INTO sanitr_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","kintveSha janaH prANanAsharhaM kimapi karmma na kR^itavAn ityajAnAM tathApi sa mahArAjasya sannidhau vichArito bhavituM prArthayata tasmAt tasya samIpaM taM preShayituM matimakaravam| ");
INSERT INTO sanitr_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","kintu shrIyuktasya samIpam etasmin kiM lekhanIyam ityasya kasyachin nirNayasya na jAtatvAd etasya vichAre sati yathAhaM lekhituM ki nchana nishchitaM prApnomi tadarthaM yuShmAkaM samakShaM visheShato he AgripparAja bhavataH samakSham etam Anaye| ");
INSERT INTO sanitr_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","yato bandipreShaNasamaye tasyAbhiyogasya ki nchidalekhanam aham ayuktaM jAnAmi| ");
INSERT INTO sanitr_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","tata AgrippaH paulam avAdIt, nijAM kathAM kathayituM tubhyam anumati rdIyate| tasmAt paulaH karaM prasAryya svasmin uttaram avAdIt| ");
INSERT INTO sanitr_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","he AgripparAja yatkAraNAdahaM yihUdIyairapavAdito .abhavaM tasya vR^ittAntam adya bhavataH sAkShAn nivedayitumanumatoham idaM svIyaM paramaM bhAgyaM manye; ");
INSERT INTO sanitr_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","yato yihUdIyalokAnAM madhye yA yA rItiH sUkShmavichArAshcha santi teShu bhavAn vij natamaH; ataeva prArthaye dhairyyamavalambya mama nivedanaM shR^iNotu| ");
INSERT INTO sanitr_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","ahaM yirUshAlamnagare svadeshIyalokAnAM madhye tiShThan A yauvanakAlAd yadrUpam AcharitavAn tad yihUdIyalokAH sarvve vidanti| ");
INSERT INTO sanitr_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","asmAkaM sarvvebhyaH shuddhatamaM yat phirUshIyamataM tadavalambI bhUtvAhaM kAlaM yApitavAn ye janA A bAlyakAlAn mAM jAnAnti te etAdR^ishaM sAkShyaM yadi dadAti tarhi dAtuM shaknuvanti| ");
INSERT INTO sanitr_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","kintu he AgripparAja Ishvaro.asmAkaM pUrvvapuruShANAM nikaTe yad a NgIkR^itavAn tasya pratyAshAhetoraham idAnIM vichArasthAne daNDAyamAnosmi| ");
INSERT INTO sanitr_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","tasyA NgIkArasya phalaM prAptum asmAkaM dvAdashavaMshA divAnishaM mahAyatnAd IshvarasevanaM kR^itvA yAM pratyAshAM kurvvanti tasyAH pratyAshAyA hetorahaM yihUdIyairapavAdito.abhavam| ");
INSERT INTO sanitr_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ishvaro mR^itAn utthApayiShyatIti vAkyaM yuShmAkaM nikaTe.asambhavaM kuto bhavet? ");
INSERT INTO sanitr_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","nAsaratIyayIsho rnAmno viruddhaM nAnAprakArapratikUlAcharaNam uchitam ityahaM manasi yathArthaM vij nAya ");
INSERT INTO sanitr_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","yirUshAlamanagare tadakaravaM phalataH pradhAnayAjakasya nikaTAt kShamatAM prApya bahUn pavitralokAn kArAyAM baddhavAn visheShatasteShAM hananasamaye teShAM viruddhAM nijAM sammatiM prakAshitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","vAraM vAraM bhajanabhavaneShu tebhyo daNDaM pradattavAn balAt taM dharmmaM nindayitavAMshcha punashcha tAn prati mahAkrodhAd unmattaH san videshIyanagarANi yAvat tAn tADitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","itthaM pradhAnayAjakasya samIpAt shaktim Aj nApatra ncha labdhvA dammeShaknagaraM gatavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","tadAhaM he rAjan mArgamadhye madhyAhnakAle mama madIyasa NginAM lokAnA ncha chatasR^iShu dikShu gagaNAt prakAshamAnAM bhAskaratopi tejasvatIM dIptiM dR^iShTavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","tasmAd asmAsu sarvveShu bhUmau patiteShu satsu he shaula hai shaula kuto mAM tADayasi? kaNTakAnAM mukhe pAdAhananaM tava duHsAdhyam ibrIyabhAShayA gadita etAdR^isha ekaH shabdo mayA shrutaH| ");
INSERT INTO sanitr_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","tadAhaM pR^iShTavAn he prabho ko bhavAn? tataH sa kathitavAn yaM yIshuM tvaM tADayasi sohaM, ");
INSERT INTO sanitr_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","kintu samuttiShTha tvaM yad dR^iShTavAn itaH puna ncha yadyat tvAM darshayiShyAmi teShAM sarvveShAM kAryyANAM tvAM sAkShiNaM mama sevaka ncha karttum darshanam adAm| ");
INSERT INTO sanitr_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","visheShato yihUdIyalokebhyo bhinnajAtIyebhyashcha tvAM manonItaM kR^itvA teShAM yathA pApamochanaM bhavati ");
INSERT INTO sanitr_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","yathA te mayi vishvasya pavitrIkR^itAnAM madhye bhAgaM prApnuvanti tadabhiprAyeNa teShAM j nAnachakShUMShi prasannAni karttuM tathAndhakArAd dIptiM prati shaitAnAdhikArAchcha IshvaraM prati matIH parAvarttayituM teShAM samIpaM tvAM preShyAmi| ");
INSERT INTO sanitr_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","he AgripparAja etAdR^ishaM svargIyapratyAdeshaM agrAhyam akR^itvAhaM ");
INSERT INTO sanitr_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","prathamato dammeShaknagare tato yirUshAlami sarvvasmin yihUdIyadeshe anyeShu desheShu cha yeेna lokA matiM parAvarttya IshvaraM prati parAvarttayante, manaHparAvarttanayogyAni karmmANi cha kurvvanti tAdR^isham upadeshaM prachAritavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","etatkAraNAd yihUdIyA madhyemandiraM mAM dhR^itvA hantum udyatAH| ");
INSERT INTO sanitr_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","tathApi khrIShTo duHkhaM bhuktvA sarvveShAM pUrvvaM shmashAnAd utthAya nijadeshIyAnAM bhinnadeshIyAnA ncha samIpe dIptiM prakAshayiShyati ");
INSERT INTO sanitr_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","bhaviShyadvAdigaNo mUsAshcha bhAvikAryyasya yadidaM pramANam adaduretad vinAnyAM kathAM na kathayitvA IshvarAd anugrahaM labdhvA mahatAM kShudrANA ncha sarvveShAM samIpe pramANaM dattvAdya yAvat tiShThAmi| ");
INSERT INTO sanitr_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","tasyamAM kathAM nishamya phIShTa uchchaiH svareNa kathitavAn he paula tvam unmattosi bahuvidyAbhyAsena tvaM hataj nAno jAtaH| ");
INSERT INTO sanitr_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","sa uktavAn he mahAmahima phIShTa nAham unmattaH kintu satyaM vivechanIya ncha vAkyaM prastaumi| ");
INSERT INTO sanitr_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","yasya sAkShAd akShobhaH san kathAM kathayAmi sa rAjA tadvR^ittAntaM jAnAti tasya samIpe kimapi guptaM neti mayA nishchitaM budhyate yatastad vijane na kR^itaM| ");
INSERT INTO sanitr_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","he AgripparAja bhavAn kiM bhaviShyadvAdigaNoktAni vAkyAni pratyeti? bhavAn pratyeti tadahaM jAnAmi| ");
INSERT INTO sanitr_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","tata AgrippaH paulam abhihitavAn tvaM pravR^ittiM janayitvA prAyeNa mAmapi khrIShTIyaM karoShi| ");
INSERT INTO sanitr_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","tataH so.avAdIt bhavAn ye ye lokAshcha mama kathAm adya shR^iNvanti prAyeNa iti nahi kintvetat shR^i NkhalabandhanaM vinA sarvvathA te sarvve mAdR^ishA bhavantvitIshvasya samIpe prArthaye.aham| ");
INSERT INTO sanitr_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","etasyAM kathAyAM kathitAyAM sa rAjA so.adhipati rbarNIkI sabhAsthA lokAshcha tasmAd utthAya ");
INSERT INTO sanitr_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","gopane parasparaM vivichya kathitavanta eSha jano bandhanArhaM prANahananArhaM vA kimapi karmma nAkarot| ");
INSERT INTO sanitr_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","tata AgrippaH phIShTam avadat, yadyeSha mAnuShaH kaisarasya nikaTe vichArito bhavituM na prArthayiShyat tarhi mukto bhavitum ashakShyat| ");
INSERT INTO sanitr_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","jalapathenAsmAkam itoliyAdeshaM prati yAtrAyAM nishchitAyAM satyAM te yUliyanAmno mahArAjasya saMghAtAntargatasya senApateH samIpe paulaM tadanyAn katinayajanAMshcha samArpayan| ");
INSERT INTO sanitr_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","vayam AdrAmuttIyaM potamekam Aruhya AshiyAdeshasya taTasamIpena yAtuM matiM kR^itvA la Ngaram utthApya potam amochayAma; mAkidaniyAdeshasthathiShalanIkInivAsyAristArkhanAmA kashchid jano.asmAbhiH sArddham AsIt| ");
INSERT INTO sanitr_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","parasmin divase .asmAbhiH sIdonnagare pote lAgite tatra yUliyaH senApatiH paulaM prati saujanyaM pradarthya sAntvanArthaM bandhubAndhavAn upayAtum anujaj nau| ");
INSERT INTO sanitr_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","tasmAt pote mochite sati sammukhavAyoH sambhavAd vayaM kupropadvIpasya tIrasamIpena gatavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","kilikiyAyAH pAmphUliyAyAshcha samudrasya pAraM gatvA lUkiyAdeshAntargataM murAnagaram upAtiShThAma| ");
INSERT INTO sanitr_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","tatsthAnAd itAliyAdeshaM gachChati yaH sikandariyAnagarasya potastaM tatra prApya shatasenApatistaM potam asmAn Arohayat| ");
INSERT INTO sanitr_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","tataH paraM bahUni dinAni shanaiH shanaiH rgatvA knIdapArshvopasthtiेH pUrvvaM pratikUlena pavanena vayaM salmonyAH sammukham upasthAya krItyupadvIpasya tIrasamIpena gatavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","kaShTena tamuttIryya lAseyAnagarasyAdhaH sundaranAmakaM khAtam upAtiShThAma| ");
INSERT INTO sanitr_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","itthaM bahutithaH kAlo yApita upavAsadina nchAtItaM, tatkAraNAt nauvartmani bhaya Nkare sati paulo vinayena kathitavAn, ");
INSERT INTO sanitr_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","he mahechChA ahaM nishchayaM jAnAmi yAtrAyAmasyAm asmAkaM kleshA bahUnAmapachayAshcha bhaviShyanti, te kevalaM potasAmagryoriti nahi, kintvasmAkaM prANAnAmapi| ");
INSERT INTO sanitr_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","tadA shatasenApatiH pauैेloktavAkyatopi karNadhArasya potavaNijashcha vAkyaM bahumaMsta| ");
INSERT INTO sanitr_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","tat khAtaM shItakAle vAsArhasthAnaM na tasmAd avAchIpratIchordishoH krItyAH phainIkiyakhAtaM yAtuM yadi shaknuvantastarhi tatra shItakAlaM yApayituM prAyeNa sarvve mantrayAmAsuH| ");
INSERT INTO sanitr_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","tataH paraM dakShiNavAyu rmandaM vahatIti vilokya nijAbhiprAyasya siddheH suyogo bhavatIti buddhvA potaM mochayitvA krItyupadvIpasya tIrasamIpena chalitavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","kintvalpakShaNAt parameva urakludonnAmA pratikUlaH prachaNDo vAyu rvahan pote.alagIt ");
INSERT INTO sanitr_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","tasyAbhimukhaM gantum potasyAshaktatvAd vayaM vAyunA svayaM nItAH| ");
INSERT INTO sanitr_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","anantaraM klaudInAmna upadvIpasya kUlasamIpena potaM gamayitvA bahunA kaShTena kShudranAvam arakShAma| ");
INSERT INTO sanitr_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","te tAmAruhya rajjchA potasyAdhobhAgam abadhnan tadanantaraM chet poto saikate lagatIti bhayAd vAtavasanAnyamochayan tataH poto vAyunA chAlitaH| ");
INSERT INTO sanitr_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","kintu kramasho vAyoH prabalatvAt poto dolAyamAno.abhavat parasmin divase potasthAni katipayAni dravyANi toye nikShiptAni| ");
INSERT INTO sanitr_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","tR^itIyadivase vayaM svahastaiH potasajjanadravyANi nikShiptavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","tato bahudinAni yAvat sUryyanakShatrAdIni samAchChannAni tato .atIva vAtyAgamAd asmAkaM prANarakShAyAH kApi pratyAshA nAtiShThat| ");
INSERT INTO sanitr_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","bahudineShu lokairanAhAreNa yApiteShu sarvveShAM sAkShat paulastiShThan akathayat, he mahechChAH krItyupadvIpAt potaM na mochayitum ahaM pUrvvaM yad avadaM tadgrahaNaM yuShmAkam uchitam AsIt tathA kR^ite yuShmAkam eShA vipad eSho.apachayashcha nAghaTiShyetAm| ");
INSERT INTO sanitr_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","kintu sAmprataM yuShmAn vinIya bravImyahaM, yUyaM na kShubhyata yuShmAkam ekasyApi prANino hAni rna bhaviShyati, kevalasya potasya hAni rbhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","yato yasyeshvarasya loko.ahaM ya nchAhaM paricharAmi tadIya eko dUto hyo rAtrau mamAntike tiShThan kathitavAn, ");
INSERT INTO sanitr_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","he paula mA bhaiShIH kaisarasya sammukhe tvayopasthAtavyaM; tavaitAn sa Ngino lokAn IshvarastubhyaM dattavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","ataeva he mahechChA yUyaM sthiramanaso bhavata mahyaM yA kathAkathi sAvashyaM ghaTiShyate mamaitAdR^ishI vishvAsa Ishvare vidyate, ");
INSERT INTO sanitr_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","kintu kasyachid upadvIpasyopari patitavyam asmAbhiH| ");
INSERT INTO sanitr_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","tataH param AdriyAsamudre potastathaiva dolAyamAnaH san itastato gachChan chaturdashadivasasya rAtre rdvitIyapraharasamaye kasyachit sthalasya samIpamupatiShThatIti potIyalokA anvamanyanta| ");
INSERT INTO sanitr_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","tataste jalaM parimAya tatra viMshati rvyAmA jalAnIti j nAtavantaH| ki nchiddUraM gatvA punarapi jalaM parimitavantaH| tatra pa nchadasha vyAmA jalAni dR^iShTvA ");
INSERT INTO sanitr_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","chet pAShANe lagatIti bhayAt potasya pashchAdbhAgatashchaturo la NgarAn nikShipya divAkaram apekShya sarvve sthitavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","kintu potIyalokAH potAgrabhAge la NgaranikShepaM ChalaM kR^itvA jaladhau kShudranAvam avarohya palAyitum acheShTanta| ");
INSERT INTO sanitr_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","tataH paulaH senApataye sainyagaNAya cha kathitavAn, ete yadi potamadhye na tiShThanti tarhi yuShmAkaM rakShaNaM na shakyaM| ");
INSERT INTO sanitr_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","tadA senAgaNo rajjUn ChitvA nAvaM jale patitum adadAt| ");
INSERT INTO sanitr_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","prabhAtasamaye paulaH sarvvAn janAn bhojanArthaM prArthya vyAharat, adya chaturdashadinAni yAvad yUyam apekShamAnA anAhArAH kAlam ayApayata kimapi nAbhuMgdhaM| ");
INSERT INTO sanitr_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","ato vinayeे.ahaM bhakShyaM bhujyatAM tato yuShmAkaM ma NgalaM bhaviShyati, yuShmAkaM kasyachijjanasya shirasaH keshaikopi na naMkShyati| ");
INSERT INTO sanitr_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","iti vyAhR^itya paulaM pUpaM gR^ihItveshvaraM dhanyaM bhAShamANastaM bhaMktvA bhoktum ArabdhavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","anantaraM sarvve cha susthirAH santaH khAdyAni parpyagR^ihlan| ");
INSERT INTO sanitr_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","asmAkaM pote ShaTsaptatyadhikashatadvayalokA Asan| ");
INSERT INTO sanitr_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","sarvveShu lokeShu yatheShTaM bhuktavatsu potasthan godhUmAn jaladhau nikShipya taiH potasya bhAro laghUkR^itaH| ");
INSERT INTO sanitr_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","dine jAte.api sa ko desha iti tadA na paryyachIyata; kintu tatra samataTam ekaM khAtaM dR^iShTvA yadi shaknumastarhi vayaM tasyAbhyantaraM potaM gamayAma iti matiM kR^itvA te la NgarAn ChittvA jaladhau tyaktavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","tathA karNabandhanaM mochayitvA pradhAnaM vAtavasanam uttolya tIrasamIpaM gatavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","kintu dvayoH samudrayoH sa NgamasthAne saikatopari pote nikShipte .agrabhAge bAdhite pashchAdbhAge prabalatara Ngo.alagat tena poto bhagnaH| ");
INSERT INTO sanitr_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","tasmAd bandayashched bAhubhistarantaH palAyante ityAsha NkayA senAgaNastAn hantum amantrayat; ");
INSERT INTO sanitr_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","kintu shatasenApatiH paulaM rakShituM prayatnaM kR^itvA tAn tachcheShTAyA nivartya ityAdiShTavAn, ye bAhutaraNaM jAnanti te.agre prollampya samudre patitvA bAhubhistIrttvA kUlaM yAntu| ");
INSERT INTO sanitr_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","aparam avashiShTA janAH kAShThaM potIyaM dravyaM vA yena yat prApyate tadavalambya yAntu; itthaM sarvve bhUmiM prApya prANai rjIvitAH| ");
INSERT INTO sanitr_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","itthaM sarvveShu rakShAM prApteShu tatratyopadvIpasya nAma milIteti te j nAtavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","asabhyalokA yatheShTam anukampAM kR^itvA varttamAnavR^iShTeH shItAchcha vahniM prajjvAlyAsmAkam Atithyam akurvvan| ");
INSERT INTO sanitr_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","kintu paula indhanAni saMgR^ihya yadA tasmin agrau nirakShipat, tadA vahneH pratApAt ekaH kR^iShNasarpo nirgatya tasya haste draShTavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","te.asabhyalokAstasya haste sarpam avalambamAnaM dR^iShTvA parasparam uktavanta eSha jano.avashyaM narahA bhaviShyati, yato yadyapi jaladhe rakShAM prAptavAn tathApi pratiphaladAyaka enaM jIvituM na dadAti| ");
INSERT INTO sanitr_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","kintu sa hastaM vidhunvan taM sarpam agnimadhye nikShipya kAmapi pIDAM nAptavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","tato viShajvAlayA etasya sharIraM sphItaM bhaviShyati yadvA haThAdayaM prANAn tyakShyatIti nishchitya lokA bahukShaNAni yAvat tad draShTuM sthitavantaH kintu tasya kasyAshchid vipado.aghaTanAt te tadviparItaM vij nAya bhAShitavanta eSha kashchid devo bhavet| ");
INSERT INTO sanitr_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","publiyanAmA jana ekastasyopadvIpasyAdhipatirAsIt tatra tasya bhUmyAdi cha sthitaM| sa jano.asmAn nijagR^ihaM nItvA saujanyaM prakAshya dinatrayaM yAvad asmAkaM Atithyam akarot| ");
INSERT INTO sanitr_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","tadA tasya publiyasya pitA jvarAtisAreNa pIDyamAnaH san shayyAyAm AsIt; tataH paulastasya samIpaM gatvA prArthanAM kR^itvA tasya gAtre hastaM samarpya taM svasthaM kR^itavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","itthaM bhUte tadvIpanivAsina itarepi rogilokA Agatya nirAmayA abhavan| ");
INSERT INTO sanitr_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","tasmAtte.asmAkam atIva satkAraM kR^itavantaH, visheShataH prasthAnasamaye prayojanIyAni nAnadravyANi dattavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","itthaM tatra triShu mAseShu gateShu yasya chihnaM diyaskUrI tAdR^isha ekaH sikandarIyanagarasya potaH shItakAlaM yApayan tasmin upadvIpe .atiShThat tameva potaM vayam Aruhya yAtrAm akurmma| ");
INSERT INTO sanitr_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","tataH prathamataH surAkUsanagaram upasthAya tatra trINi dinAni sthitavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","tasmAd AvR^itya rIgiyanagaram upasthitAH dinaikasmAt paraM dakShiNavayau sAnukUlye sati parasmin divase patiyalInagaram upAtiShThAma| ");
INSERT INTO sanitr_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","tato.asmAsu tatratyaM bhrAtR^igaNaM prApteShu te svaiH sArddham asmAn sapta dinAni sthApayitum ayatanta, itthaM vayaM romAnagaram pratyagachChAma| ");
INSERT INTO sanitr_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","tasmAt tatratyAH bhrAtaro.asmAkam AgamanavArttAM shrutvA AppiyapharaM triShTAvarNI ncha yAvad agresarAH santosmAn sAkShAt karttum Agaman; teShAM darshanAt paula IshvaraM dhanyaM vadan AshvAsam AptavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","asmAsu romAnagaraM gateShu shatasenApatiH sarvvAn bandIn pradhAnasenApateH samIpe samArpayat kintu paulAya svarakShakapadAtinA saha pR^ithag vastum anumatiM dattavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","dinatrayAt paraM paulastaddeshasthAn pradhAnayihUdina AhUtavAn tatasteShu samupasthiteShu sa kathitavAn, he bhrAtR^igaNa nijalokAnAM pUrvvapuruShANAM vA rIte rviparItaM ki nchana karmmAhaM nAkaravaM tathApi yirUshAlamanivAsino lokA mAM bandiM kR^itvA romilokAnAM hasteShu samarpitavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","romilokA vichAryya mama prANahananArhaM kimapi kAraNaM na prApya mAM mochayitum aichChan; ");
INSERT INTO sanitr_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","kintu yihUdilokAnAm ApattyA mayA kaisararAjasya samIpe vichArasya prArthanA karttavyA jAtA nochet nijadeshIyalokAn prati mama kopyabhiyogo nAsti| ");
INSERT INTO sanitr_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","etatkAraNAd ahaM yuShmAn draShTuM saMlapitu nchAhUyam isrAyelvashIyAnAM pratyAshAhetoham etena shu Nkhalena baddho.abhavam| ");
INSERT INTO sanitr_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","tadA te tam avAdiShuH, yihUdIyadeshAd vayaM tvAmadhi kimapi patraM na prAptA ye bhrAtaraH samAyAtAsteShAM kopi tava kAmapi vArttAM nAvadat abhadramapi nAkathayachcha| ");
INSERT INTO sanitr_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","tava mataM kimiti vayaM tvattaH shrotumichChAmaH| yad idaM navInaM matamutthitaM tat sarvvatra sarvveShAM nikaTe ninditaM jAtama iti vayaM jAnImaH| ");
INSERT INTO sanitr_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","taistadartham ekasmin dine nirUpite tasmin dine bahava ekatra militvA paulasya vAsagR^iham AgachChan tasmAt paula A prAtaHkAlAt sandhyAkAlaM yAvan mUsAvyavasthAgranthAd bhaviShyadvAdinAM granthebhyashcha yIshoH kathAm utthApya Ishvarasya rAjye pramANaM datvA teShAM pravR^ittiM janayituM cheShTitavAn| ");
INSERT INTO sanitr_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","kechittu tasya kathAM pratyAyan kechittu na pratyAyan; ");
INSERT INTO sanitr_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","etatkAraNAt teShAM parasparam anaikyAt sarvve chalitavantaH; tathApi paula etAM kathAmekAM kathitavAn pavitra AtmA yishayiyasya bhaviShyadvaktu rvadanAd asmAkaM pitR^ipuruShebhya etAM kathAM bhadraM kathayAmAsa, yathA, ");
INSERT INTO sanitr_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","\"upagatya janAnetAn tvaM bhAShasva vachastvidaM| karNaiH shroShyatha yUyaM hi kintu yUyaM na bhotsyatha| netrai rdrakShyatha yUya ncha j nAtuM yUyaM na shakShyatha| ");
INSERT INTO sanitr_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","te mAnuShA yathA netraiH paripashyanti naiva hi| karNaiH ryathA na shR^iNvanti budhyante na cha mAnasaiH| vyAvarttayatsu chittAni kAle kutrApi teShu vai| mattaste manujAH svasthA yathA naiva bhavanti cha| tathA teShAM manuShyANAM santi sthUlA hi buddhayaH| badhirIbhUtakarNAshcha jAtAshcha mudritA dR^ishaH|| ");
INSERT INTO sanitr_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","ata IshvarAd yat paritrANaM tasya vArttA bhinnadeshIyAnAM samIpaM preShitA taeva tAM grahIShyantIti yUyaM jAnIta| ");
INSERT INTO sanitr_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","etAdR^ishyAM kathAyAM kathitAyAM satyAM yihUdinaH parasparaM bahuvichAraM kurvvanto gatavantaH| ");
INSERT INTO sanitr_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","itthaM paulaH sampUrNaM vatsaradvayaM yAvad bhATakIye vAsagR^ihe vasan ye lokAstasya sannidhim AgachChanti tAn sarvvAneva parigR^ihlan, ");
INSERT INTO sanitr_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","nirvighnam atishayaniHkShobham IshvarIyarAjatvasya kathAM prachArayan prabhau yIshau khrIShTe kathAH samupAdishat| iti||");
INSERT INTO sanitr_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Ishvaro nijaputramadhi yaM susaMvAdaM bhaviShyadvAdibhi rdharmmagranthe pratishrutavAn taM susaMvAdaM prachArayituM pR^ithakkR^ita AhUtaH preritashcha prabho ryIshukhrIShTasya sevako yaH paulaH ");
INSERT INTO sanitr_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","sa romAnagarasthAn IshvarapriyAn AhUtAMshcha pavitralokAn prati patraM likhati| ");
INSERT INTO sanitr_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","asmAkaM sa prabhu ryIshuH khrIShTaH shArIrikasambandhena dAyUdo vaMshodbhavaH ");
INSERT INTO sanitr_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","pavitrasyAtmanaH sambandhena cheshvarasya prabhAvavAn putra iti shmashAnAt tasyotthAnena pratipannaM| ");
INSERT INTO sanitr_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","aparaM yeShAM madhye yIshunA khrIShTena yUyamapyAhUtAste .anyadeshIyalokAstasya nAmni vishvasya nideshagrAhiNo yathA bhavanti ");
INSERT INTO sanitr_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","tadabhiprAyeNa vayaM tasmAd anugrahaM preritatvapada ncha prAptAH| ");
INSERT INTO sanitr_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","tAtenAsmAkam IshvareNa prabhuNA yIshukhrIShTena cha yuShmabhyam anugrahaH shAntishcha pradIyetAM| ");
INSERT INTO sanitr_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","prathamataH sarvvasmin jagati yuShmAkaM vishvAsasya prakAshitatvAd ahaM yuShmAkaM sarvveShAM nimittaM yIshukhrIShTasya nAma gR^ihlan Ishvarasya dhanyavAdaM karomi| ");
INSERT INTO sanitr_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","aparam Ishvarasya prasAdAd bahukAlAt paraM sAmprataM yuShmAkaM samIpaM yAtuM kathamapi yat suyogaM prApnomi, etadarthaM nirantaraM nAmAnyuchchArayan nijAsu sarvvaprArthanAsu sarvvadA nivedayAmi, ");
INSERT INTO sanitr_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","etasmin yamahaM tatputrIyasusaMvAdaprachAraNena manasA paricharAmi sa Ishvaro mama sAkShI vidyate| ");
INSERT INTO sanitr_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","yato yuShmAkaM mama cha vishvAsena vayam ubhaye yathA shAntiyuktA bhavAma iti kAraNAd ");
INSERT INTO sanitr_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","yuShmAkaM sthairyyakaraNArthaM yuShmabhyaM ki nchitparamArthadAnadAnAya yuShmAn sAkShAt karttuM madIyA vA nChA| ");
INSERT INTO sanitr_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","he bhrAtR^igaNa bhinnadeshIyalokAnAM madhye yadvat tadvad yuShmAkaM madhyepi yathA phalaM bhu nje tadabhiprAyeNa muhurmuhu ryuShmAkaM samIpaM gantum udyato.ahaM kintu yAvad adya tasmin gamane mama vighno jAta iti yUyaM yad aj nAtAstiShThatha tadaham uchitaM na budhye| ");
INSERT INTO sanitr_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","ahaM sabhyAsabhyAnAM vidvadavidvatA ncha sarvveShAm R^iNI vidye| ");
INSERT INTO sanitr_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","ataeva romAnivAsinAM yuShmAkaM samIpe.api yathAshakti susaMvAdaM prachArayitum aham udyatosmi| ");
INSERT INTO sanitr_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","yataH khrIShTasya susaMvAdo mama lajjAspadaM nahi sa Ishvarasya shaktisvarUpaH san A yihUdIyebhyo .anyajAtIyAn yAvat sarvvajAtIyAnAM madhye yaH kashchid tatra vishvasiti tasyaiva trANaM janayati| ");
INSERT INTO sanitr_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","yataH pratyayasya samaparimANam IshvaradattaM puNyaM tatsusaMvAde prakAshate| tadadhi dharmmapustakepi likhitamidaM \"puNyavAn jano vishvAsena jIviShyati\"| ");
INSERT INTO sanitr_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","ataeva ye mAnavAH pApakarmmaNA satyatAM rundhanti teShAM sarvvasya durAcharaNasyAdharmmasya cha viruddhaM svargAd Ishvarasya kopaH prakAshate| ");
INSERT INTO sanitr_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","yata Ishvaramadhi yadyad j neyaM tad IshvaraH svayaM tAn prati prakAshitavAn tasmAt teShAm agocharaM nahi| ");
INSERT INTO sanitr_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","phalatastasyAnantashaktIshvaratvAdInyadR^ishyAnyapi sR^iShTikAlam Arabhya karmmasu prakAshamAnAni dR^ishyante tasmAt teShAM doShaprakShAlanasya panthA nAsti| ");
INSERT INTO sanitr_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","aparam IshvaraM j nAtvApi te tam Ishvaraj nAnena nAdriyanta kR^itaj nA vA na jAtAH; tasmAt teShAM sarvve tarkA viphalIbhUtAH, apara ncha teShAM vivekashUnyAni manAMsi timire magnAni| ");
INSERT INTO sanitr_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","te svAn j nAnino j nAtvA j nAnahInA abhavan ");
INSERT INTO sanitr_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","anashvarasyeshvarasya gauravaM vihAya nashvaramanuShyapashupakShyurogAmiprabhR^iterAkR^itivishiShTapratimAstairAshritAH| ");
INSERT INTO sanitr_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","itthaM ta Ishvarasya satyatAM vihAya mR^iShAmatam AshritavantaH sachchidAnandaM sR^iShTikarttAraM tyaktvA sR^iShTavastunaH pUjAM sevA ncha kR^itavantaH; ");
INSERT INTO sanitr_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","iti hetorIshvarastAn kukriyAyAM samarpya nijanijakuchintAbhilAShAbhyAM svaM svaM sharIraM parasparam apamAnitaM karttum adadAt| ");
INSERT INTO sanitr_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","IshvareNa teShu kvabhilAShe samarpiteShu teShAM yoShitaH svAbhAvikAcharaNam apahAya viparItakR^itye prAvarttanta; ");
INSERT INTO sanitr_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","tathA puruShA api svAbhAvikayoShitsa NgamaM vihAya parasparaM kAmakR^ishAnunA dagdhAH santaH pumAMsaH puMbhiH sAkaM kukR^itye samAsajya nijanijabhrAnteH samuchitaM phalam alabhanta| ");
INSERT INTO sanitr_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","te sveShAM manaHsvIshvarAya sthAnaM dAtum anichChukAstato hetorIshvarastAn prati duShTamanaskatvam avihitakriyatva ncha dattavAn| ");
INSERT INTO sanitr_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","ataeva te sarvve .anyAyo vyabhichAro duShTatvaM lobho jighAMsA IrShyA vadho vivAdashchAturI kumatirityAdibhi rduShkarmmabhiH paripUrNAH santaH ");
INSERT INTO sanitr_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","karNejapA apavAdina IshvaradveShakA hiMsakA aha NkAriNa AtmashlAghinaH kukarmmotpAdakAH pitrorAj nAla NghakA ");
INSERT INTO sanitr_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","avichArakA niyamala NghinaH sneharahitA atidveShiNo nirdayAshcha jAtAH| ");
INSERT INTO sanitr_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","ye janA etAdR^ishaM karmma kurvvanti taeva mR^itiyogyA Ishvarasya vichAramIdR^ishaM j nAtvApi ta etAdR^ishaM karmma svayaM kurvvanti kevalamiti nahi kintu tAdR^ishakarmmakAriShu lokeShvapi prIyante| ");
INSERT INTO sanitr_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","he paradUShaka manuShya yaH kashchana tvaM bhavasi tavottaradAnAya panthA nAsti yato yasmAt karmmaNaH parastvayA dUShyate tasmAt tvamapi dUShyase, yatastaM dUShayannapi tvaM tadvad Acharasi| ");
INSERT INTO sanitr_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","kintvetAdR^igAchAribhyo yaM daNDam Ishvaro nishchinoti sa yathArtha iti vayaM jAnImaH| ");
INSERT INTO sanitr_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","ataeva he mAnuSha tvaM yAdR^igAchAriNo dUShayasi svayaM yadi tAdR^igAcharasi tarhi tvam IshvaradaNDAt palAyituM shakShyasIti kiM budhyase? ");
INSERT INTO sanitr_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","aparaM tava manasaH parivarttanaM karttum ishvarasyAnugraho bhavati tanna buddhvA tvaM kiM tadIyAnugrahakShamAchirasahiShNutvanidhiM tuchChIkaroShi? ");
INSERT INTO sanitr_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","tathA svAntaHkaraNasya kaThoratvAt khedarAhityAchcheshvarasya nyAyyavichAraprakAshanasya krodhasya cha dinaM yAvat kiM svArthaM kopaM sa nchinoShi? ");
INSERT INTO sanitr_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","kintu sa ekaikamanujAya tatkarmmAnusAreNa pratiphalaM dAsyati; ");
INSERT INTO sanitr_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","vastutastu ye janA dhairyyaM dhR^itvA satkarmma kurvvanto mahimA satkAro.amaratva nchaitAni mR^igayante tebhyo.anantAyu rdAsyati| ");
INSERT INTO sanitr_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","aparaM ye janAH satyadharmmam agR^ihItvA viparItadharmmam gR^ihlanti tAdR^ishA virodhijanAH kopaM krodha ncha bhokShyante| ");
INSERT INTO sanitr_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","A yihUdino.anyadeshinaH paryyantaM yAvantaH kukarmmakAriNaH prANinaH santi te sarvve duHkhaM yAtanA ncha gamiShyanti; ");
INSERT INTO sanitr_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","kintu A yihUdino bhinnadeshiparyyantA yAvantaH satkarmmakAriNo lokAH santi tAn prati mahimA satkAraH shAntishcha bhaviShyanti| ");
INSERT INTO sanitr_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Ishvarasya vichAre pakShapAto nAsti| ");
INSERT INTO sanitr_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","alabdhavyavasthAshAstrai ryaiH pApAni kR^itAni vyavasthAshAstrAlabdhatvAnurUpasteShAM vinAsho bhaviShyati; kintu labdhavyavasthAshAstrA ye pApAnyakurvvan vyavasthAnusArAdeva teShAM vichAro bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","vyavasthAshrotAra Ishvarasya samIpe niShpApA bhaviShyantIti nahi kintu vyavasthAchAriNa eva sapuNyA bhaviShyanti| ");
INSERT INTO sanitr_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","yato .alabdhavyavasthAshAstrA bhinnadeshIyalokA yadi svabhAvato vyavasthAnurUpAn AchArAn kurvvanti tarhyalabdhashAstrAH santo.api te sveShAM vyavasthAshAstramiva svayameva bhavanti| ");
INSERT INTO sanitr_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","teShAM manasi sAkShisvarUpe sati teShAM vitarkeShu cha kadA tAn doShiNaH kadA vA nirdoShAn kR^itavatsu te svAntarlikhitasya vyavasthAshAstrasya pramANaM svayameva dadati| ");
INSERT INTO sanitr_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","yasmin dine mayA prakAshitasya susaMvAdasyAnusArAd Ishvaro yIshukhrIShTena mAnuShANAm antaHkaraNAnAM gUDhAbhiprAyAn dhR^itvA vichArayiShyati tasmin vichAradine tat prakAshiShyate| ");
INSERT INTO sanitr_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","pashya tvaM svayaM yihUdIti vikhyAto vyavasthopari vishvAsaM karoShi, ");
INSERT INTO sanitr_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Ishvaramuddishya svaM shlAghase, tathA vyavasthayA shikShito bhUtvA tasyAbhimataM jAnAsi, sarvvAsAM kathAnAM sAraM viviMkShe, ");
INSERT INTO sanitr_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","aparaM j nAnasya satyatAyAshchAkarasvarUpaM shAstraM mama samIpe vidyata ato .andhalokAnAM mArgadarshayitA ");
INSERT INTO sanitr_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","timirasthitalokAnAM madhye dIptisvarUpo.aj nAnalokebhyo j nAnadAtA shishUnAM shikShayitAhameveti manyase| ");
INSERT INTO sanitr_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","parAn shikShayan svayaM svaM kiM na shikShayasi? vastutashchauryyaniShedhavyavasthAM prachArayan tvaM kiM svayameva chorayasi? ");
INSERT INTO sanitr_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","tathA paradAragamanaM pratiShedhan svayaM kiM paradArAn gachChasi? tathA tvaM svayaM pratimAdveShI san kiM mandirasya dravyANi harasi? ");
INSERT INTO sanitr_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","yastvaM vyavasthAM shlAghase sa tvaM kiM vyavasthAm avamatya neshvaraM sammanyase? ");
INSERT INTO sanitr_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","shAstre yathA likhati \"bhinnadeshinAM samIpe yuShmAkaM doShAd Ishvarasya nAmno nindA bhavati|\" ");
INSERT INTO sanitr_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","yadi vyavasthAM pAlayasi tarhi tava tvakChedakriyA saphalA bhavati; yati vyavasthAM la Nghase tarhi tava tvakChedo.atvakChedo bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","yato vyavasthAshAstrAdiShTadharmmakarmmAchArI pumAn atvakChedI sannapi kiM tvakChedinAM madhye na gaNayiShyate? ");
INSERT INTO sanitr_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","kintu labdhashAstrashChinnatvak cha tvaM yadi vyavasthAla NghanaM karoShi tarhi vyavasthApAlakAH svAbhAvikAchChinnatvacho lokAstvAM kiM na dUShayiShyanti? ");
INSERT INTO sanitr_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","tasmAd yo bAhye yihUdI sa yihUdI nahi tathA Ngasya yastvakChedaH sa tvakChedo nahi; ");
INSERT INTO sanitr_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","kintu yo jana Antariko yihUdI sa eva yihUdI apara ncha kevalalikhitayA vyavasthayA na kintu mAnasiko yastvakChedo yasya cha prashaMsA manuShyebhyo na bhUtvA IshvarAd bhavati sa eva tvakChedaH| ");
INSERT INTO sanitr_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","apara ncha yihUdinaH kiM shreShThatvaM? tathA tvakChedasya vA kiM phalaM? ");
INSERT INTO sanitr_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","sarvvathA bahUni phalAni santi, visheShata Ishvarasya shAstraM tebhyo.adIyata| ");
INSERT INTO sanitr_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","kaishchid avishvasane kR^ite teShAm avishvasanAt kim Ishvarasya vishvAsyatAyA hAnirutpatsyate? ");
INSERT INTO sanitr_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","kenApi prakAreNa nahi| yadyapi sarvve manuShyA mithyAvAdinastathApIshvaraH satyavAdI| shAstre yathA likhitamAste, atastvantu svavAkyena nirddoSho hi bhaviShyasi| vichAre chaiva niShpApo bhaviShyasi na saMshayaH| ");
INSERT INTO sanitr_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","asmAkam anyAyena yadIshvarasya nyAyaH prakAshate tarhi kiM vadiShyAmaH? ahaM mAnuShANAM kathAmiva kathAM kathayAmi, IshvaraH samuchitaM daNDaM dattvA kim anyAyI bhaviShyati? ");
INSERT INTO sanitr_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","itthaM na bhavatu, tathA satIshvaraH kathaM jagato vichArayitA bhaviShyati? ");
INSERT INTO sanitr_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","mama mithyAvAkyavadanAd yadIshvarasya satyatvena tasya mahimA varddhate tarhi kasmAdahaM vichAre.aparAdhitvena gaNyo bhavAmi? ");
INSERT INTO sanitr_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","ma NgalArthaM pApamapi karaNIyamiti vAkyaM tvayA kuto nochyate? kintu yairuchyate te nitAntaM daNDasya pAtrANi bhavanti; tathApi tadvAkyam asmAbhirapyuchyata ityasmAkaM glAniM kurvvantaH kiyanto lokA vadanti| ");
INSERT INTO sanitr_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","anyalokebhyo vayaM kiM shreShThAH? kadAchana nahi yato yihUdino .anyadeshinashcha sarvvaeva pApasyAyattA ityasya pramANaM vayaM pUrvvam adadAma| ");
INSERT INTO sanitr_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","lipi ryathAste, naikopi dhArmmiko janaH| ");
INSERT INTO sanitr_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","tathA j nAnIshvaraj nAnI mAnavaH kopi nAsti hi| ");
INSERT INTO sanitr_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","vimArgagAminaH sarvve sarvve duShkarmmakAriNaH| eko janopi no teShAM sAdhukarmma karoti cha| ");
INSERT INTO sanitr_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","tathA teShAntu vai kaNThA anAvR^itashmashAnavat| stutivAdaM prakurvvanti jihvAbhiste tu kevalaM| teShAmoShThasya nimne tu viShaM tiShThati sarppavat| ");
INSERT INTO sanitr_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","mukhaM teShAM hi shApena kapaTena cha pUryyate| ");
INSERT INTO sanitr_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","raktapAtAya teShAM tu padAni kShipragAni cha| ");
INSERT INTO sanitr_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","pathi teShAM manuShyANAM nAshaH kleshashcha kevalaH| ");
INSERT INTO sanitr_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","te janA nahi jAnanti panthAnaM sukhadAyinaM| ");
INSERT INTO sanitr_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","parameshAd bhayaM yattat tachchakShuShoragocharaM| ");
INSERT INTO sanitr_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","vyavasthAyAM yadyallikhati tad vyavasthAdhInAn lokAn uddishya likhatIti vayaM jAnImaH| tato manuShyamAtro niruttaraH san Ishvarasya sAkShAd aparAdhI bhavati| ");
INSERT INTO sanitr_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","ataeva vyavasthAnurUpaiH karmmabhiH kashchidapi prANIshvarasya sAkShAt sapuNyIkR^ito bhavituM na shakShyati yato vyavasthayA pApaj nAnamAtraM jAyate| ");
INSERT INTO sanitr_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","kintu vyavasthAyAH pR^ithag IshvareNa deyaM yat puNyaM tad vyavasthAyA bhaviShyadvAdigaNasya cha vachanaiH pramANIkR^itaM sad idAnIM prakAshate| ");
INSERT INTO sanitr_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","yIshukhrIShTe vishvAsakaraNAd IshvareNa dattaM tat puNyaM sakaleShu prakAshitaM sat sarvvAn vishvAsinaH prati varttate| ");
INSERT INTO sanitr_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","teShAM kopi prabhedo nAsti, yataH sarvvaeva pApina IshvarIyatejohInAshcha jAtAH| ");
INSERT INTO sanitr_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","ta IshvarasyAnugrahAd mUlyaM vinA khrIShTakR^itena paritrANena sapuNyIkR^itA bhavanti| ");
INSERT INTO sanitr_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","yasmAt svashoNitena vishvAsAt pApanAshako balI bhavituM sa eva pUrvvam IshvareNa nishchitaH, ittham IshvarIyasahiShNutvAt purAkR^itapApAnAM mArjjanakaraNe svIyayAthArthyaM tena prakAshyate, ");
INSERT INTO sanitr_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","varttamAnakAlIyamapi svayAthArthyaM tena prakAshyate, aparaM yIshau vishvAsinaM sapuNyIkurvvannapi sa yAthArthikastiShThati| ");
INSERT INTO sanitr_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","tarhi kutrAtmashlAghA? sA dUrIkR^itA; kayA vyavasthayA? kiM kriyArUpavyavasthayA? itthaM nahi kintu tat kevalavishvAsarUpayA vyavasthayaiva bhavati| ");
INSERT INTO sanitr_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","ataeva vyavasthAnurUpAH kriyA vinA kevalena vishvAsena mAnavaH sapuNyIkR^ito bhavituM shaknotItyasya rAddhAntaM darshayAmaH| ");
INSERT INTO sanitr_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","sa kiM kevalayihUdinAm Ishvaro bhavati? bhinnadeshinAm Ishvaro na bhavati? bhinnadeshinAmapi bhavati; ");
INSERT INTO sanitr_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","yasmAd eka Ishvaro vishvAsAt tvakChedino vishvAsenAtvakChedinashcha sapuNyIkariShyati| ");
INSERT INTO sanitr_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","tarhi vishvAsena vayaM kiM vyavasthAM lumpAma? itthaM na bhavatu vayaM vyavasthAM saMsthApayAma eva| ");
INSERT INTO sanitr_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","asmAkaM pUrvvapuruSha ibrAhIm kAyikakriyayA kiM labdhavAn etadadhi kiM vadiShyAmaH? ");
INSERT INTO sanitr_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","sa yadi nijakriyAbhyaH sapuNyo bhavet tarhi tasyAtmashlAghAM karttuM panthA bhavediti satyaM, kintvIshvarasya samIpe nahi| ");
INSERT INTO sanitr_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","shAstre kiM likhati? ibrAhIm Ishvare vishvasanAt sa vishvAsastasmai puNyArthaM gaNito babhUva| ");
INSERT INTO sanitr_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","karmmakAriNo yad vetanaM tad anugrahasya phalaM nahi kintu tenopArjitaM mantavyam| ");
INSERT INTO sanitr_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","kintu yaH pApinaM sapuNyIkaroti tasmin vishvAsinaH karmmahInasya janasya yo vishvAsaH sa puNyArthaM gaNyo bhavati| ");
INSERT INTO sanitr_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","aparaM yaM kriyAhInam IshvaraH sapuNyIkaroti tasya dhanyavAdaM dAyUd varNayAmAsa, yathA, ");
INSERT INTO sanitr_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","sa dhanyo.aghAni mR^iShTAni yasyAgAMsyAvR^itAni cha| ");
INSERT INTO sanitr_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","sa cha dhanyaH pareshena pApaM yasya na gaNyate| ");
INSERT INTO sanitr_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","eSha dhanyavAdastvakChedinam atvakChedinaM vA kaM prati bhavati? ibrAhImo vishvAsaH puNyArthaM gaNita iti vayaM vadAmaH| ");
INSERT INTO sanitr_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","sa vishvAsastasya tvakCheditvAvasthAyAM kim atvakCheditvAvasthAyAM kasmin samaye puNyamiva gaNitaH? tvakCheditvAvasthAyAM nahi kintvatvakCheditvAvasthAyAM| ");
INSERT INTO sanitr_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","apara ncha sa yat sarvveShAm atvakChedinAM vishvAsinAm AdipuruSho bhavet, te cha puNyavattvena gaNyeran; ");
INSERT INTO sanitr_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","ye cha lokAH kevalaM Chinnatvacho na santo .asmatpUrvvapuruSha ibrAhIm aChinnatvak san yena vishvAsamArgeNa gatavAn tenaiva tasya pAdachihnena gachChanti teShAM tvakChedinAmapyAdipuruSho bhavet tadartham atvakChedino mAnavasya vishvAsAt puNyam utpadyata iti pramANasvarUpaM tvakChedachihnaM sa prApnot| ");
INSERT INTO sanitr_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","ibrAhIm jagato.adhikArI bhaviShyati yaiShA pratij nA taM tasya vaMsha ncha prati pUrvvam akriyata sA vyavasthAmUlikA nahi kintu vishvAsajanyapuNyamUlikA| ");
INSERT INTO sanitr_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","yato vyavasthAvalambino yadyadhikAriNo bhavanti tarhi vishvAso viphalo jAyate sA pratij nApi luptaiva| ");
INSERT INTO sanitr_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","adhikantu vyavasthA kopaM janayati yato .avidyamAnAyAM vyavasthAyAm Aj nAla NghanaM na sambhavati| ");
INSERT INTO sanitr_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","ataeva sA pratij nA yad anugrahasya phalaM bhavet tadarthaM vishvAsamUlikA yatastathAtve tadvaMshasamudAyaM prati arthato ye vyavasthayA tadvaMshasambhavAH kevalaM tAn prati nahi kintu ya ibrAhImIyavishvAsena tatsambhavAstAnapi prati sA pratij nA sthAsnurbhavati| ");
INSERT INTO sanitr_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","yo nirjIvAn sajIvAn avidyamAnAni vastUni cha vidyamAnAni karoti ibrAhImo vishvAsabhUmestasyeshvarasya sAkShAt so.asmAkaM sarvveShAm AdipuruSha Aste, yathA likhitaM vidyate, ahaM tvAM bahujAtInAm AdipuruShaM kR^itvA niyuktavAn| ");
INSERT INTO sanitr_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","tvadIyastAdR^isho vaMsho janiShyate yadidaM vAkyaM pratishrutaM tadanusArAd ibrAhIm bahudeshIyalokAnAm AdipuruSho yad bhavati tadarthaM so.anapekShitavyamapyapekShamANo vishvAsaM kR^itavAn| ");
INSERT INTO sanitr_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","apara ncha kShINavishvAso na bhUtvA shatavatsaravayaskatvAt svasharIrasya jarAM sArAnAmnaH svabhAryyAyA rajonivR^itti ncha tR^iNAya na mene| ");
INSERT INTO sanitr_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","aparam avishvAsAd Ishvarasya pratij nAvachane kamapi saMshayaM na chakAra; ");
INSERT INTO sanitr_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","kintvIshvareNa yat pratishrutaM tat sAdhayituM shakyata iti nishchitaM vij nAya dR^iDhavishvAsaH san Ishvarasya mahimAnaM prakAshayA nchakAra| ");
INSERT INTO sanitr_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","iti hetostasya sa vishvAsastadIyapuNyamiva gaNayA nchakre| ");
INSERT INTO sanitr_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","puNyamivAgaNyata tat kevalasya tasya nimittaM likhitaM nahi, asmAkaM nimittamapi, ");
INSERT INTO sanitr_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","yato.asmAkaM pApanAshArthaM samarpito.asmAkaM puNyaprAptyartha nchotthApito.abhavat yo.asmAkaM prabhu ryIshustasyotthApayitarIshvare ");
INSERT INTO sanitr_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","yadi vayaM vishvasAmastarhyasmAkamapi saeva vishvAsaH puNyamiva gaNayiShyate| ");
INSERT INTO sanitr_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","vishvAsena sapuNyIkR^itA vayam IshvareNa sArddhaM prabhuNAsmAkaM yIshukhrIShTena melanaM prAptAH| ");
INSERT INTO sanitr_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","aparaM vayaM yasmin anugrahAshraye tiShThAmastanmadhyaM vishvAsamArgeNa tenaivAnItA vayam IshvarIyavibhavaprAptipratyAshayA samAnandAmaH| ");
INSERT INTO sanitr_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","tat kevalaM nahi kintu kleshabhoge.apyAnandAmo yataH kleshAाd dhairyyaM jAyata iti vayaM jAnImaH, ");
INSERT INTO sanitr_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","dhairyyAchcha parIkShitatvaM jAyate, parIkShitatvAt pratyAshA jAyate, ");
INSERT INTO sanitr_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","pratyAshAto vrIDitatvaM na jAyate, yasmAd asmabhyaM dattena pavitreNAtmanAsmAkam antaHkaraNAnIshvarasya premavAriNA siktAni| ");
INSERT INTO sanitr_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","asmAsu nirupAyeShu satsu khrIShTa upayukte samaye pApinAM nimittaM svIyAn praNAn atyajat| ");
INSERT INTO sanitr_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","hitakAriNo janasya kR^ite kopi praNAn tyaktuM sAhasaM karttuM shaknoti, kintu dhArmmikasya kR^ite prAyeNa kopi prANAn na tyajati| ");
INSERT INTO sanitr_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","kintvasmAsu pApiShu satsvapi nimittamasmAkaM khrIShTaH svaprANAn tyaktavAn, tata IshvarosmAn prati nijaM paramapremANaM darshitavAn| ");
INSERT INTO sanitr_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","ataeva tasya raktapAtena sapuNyIkR^itA vayaM nitAntaM tena kopAd uddhAriShyAmahe| ");
INSERT INTO sanitr_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","phalato vayaM yadA ripava Asma tadeshvarasya putrasya maraNena tena sArddhaM yadyasmAkaM melanaM jAtaM tarhi melanaprAptAH santo.avashyaM tasya jIvanena rakShAM lapsyAmahe| ");
INSERT INTO sanitr_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","tat kevalaM nahi kintu yena melanam alabhAmahi tenAsmAkaM prabhuNA yIshukhrIShTena sAmpratam Ishvare samAnandAmashcha| ");
INSERT INTO sanitr_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","tathA sati, ekena mAnuSheNa pApaM pApena cha maraNaM jagatIM prAvishat aparaM sarvveShAM pApitvAt sarvve mAnuShA mR^ite rnighnA abhavat| ");
INSERT INTO sanitr_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","yato vyavasthAdAnasamayaM yAvat jagati pApam AsIt kintu yatra vyavasthA na vidyate tatra pApasyApi gaNanA na vidyate| ");
INSERT INTO sanitr_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","tathApyAdamA yAdR^ishaM pApaM kR^itaM tAdR^ishaM pApaM yai rnAkAri Adamam Arabhya mUsAM yAvat teShAmapyupari mR^ityU rAjatvam akarot sa Adam bhAvyAdamo nidarshanamevAste| ");
INSERT INTO sanitr_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","kintu pApakarmmaNo yAdR^isho bhAvastAdR^ig dAnakarmmaNo bhAvo na bhavati yata ekasya janasyAparAdhena yadi bahUnAM maraNam aghaTata tathApIshvarAnugrahastadanugrahamUlakaM dAna nchaikena janenArthAd yIshunA khrIShTena bahuShu bAhulyAtibAhulyena phalati| ");
INSERT INTO sanitr_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","aparam ekasya janasya pApakarmma yAdR^ik phalayuktaM dAnakarmma tAdR^ik na bhavati yato vichArakarmmaikaM pApam Arabhya daNDajanakaM babhUva, kintu dAnakarmma bahupApAnyArabhya puNyajanakaM babhUva| ");
INSERT INTO sanitr_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","yata ekasya janasya pApakarmmatastenaikena yadi maraNasya rAjatvaM jAtaM tarhi ye janA anugrahasya bAhulyaM puNyadAna ncha prApnuvanti ta ekena janena, arthAt yIshukhrIShTena, jIvane rAjatvam avashyaM kariShyanti| ");
INSERT INTO sanitr_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","eko.aparAdho yadvat sarvvamAnavAnAM daNDagAmI mArgo .abhavat tadvad ekaM puNyadAnaM sarvvamAnavAnAM jIvanayuktapuNyagAmI mArga eva| ");
INSERT INTO sanitr_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","aparam ekasya janasyAj nAla NghanAd yathA bahavo .aparAdhino jAtAstadvad ekasyAj nAcharaNAd bahavaH sapuNyIkR^itA bhavanti| ");
INSERT INTO sanitr_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","adhikantu vyavasthAgamanAd aparAdhasya bAhulyaM jAtaM kintu yatra pApasya bAhulyaM tatraiva tasmAd anugrahasya bAhulyam abhavat| ");
INSERT INTO sanitr_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","tena mR^ityunA yadvat pApasya rAjatvam abhavat tadvad asmAkaM prabhuyIshukhrIShTadvArAnantajIvanadAyipuNyenAnugrahasya rAjatvaM bhavati| ");
INSERT INTO sanitr_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","prabhUtarUpeNa yad anugrahaH prakAshate tadarthaM pApe tiShThAma iti vAkyaM kiM vayaM vadiShyAmaH? tanna bhavatu| ");
INSERT INTO sanitr_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","pApaM prati mR^itA vayaM punastasmin katham jIviShyAmaH? ");
INSERT INTO sanitr_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","vayaM yAvanto lokA yIshukhrIShTe majjitA abhavAma tAvanta eva tasya maraNe majjitA iti kiM yUyaM na jAnItha? ");
INSERT INTO sanitr_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","tato yathA pituH parAkrameNa shmashAnAt khrIShTa utthApitastathA vayamapi yat nUtanajIvina ivAcharAmastadarthaM majjanena tena sArddhaM mR^ityurUpe shmashAne saMsthApitAH| ");
INSERT INTO sanitr_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","aparaM vayaM yadi tena saMyuktAH santaH sa iva maraNabhAgino jAtAstarhi sa ivotthAnabhAgino.api bhaviShyAmaH| ");
INSERT INTO sanitr_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","vayaM yat pApasya dAsAH puna rna bhavAmastadartham asmAkaM pAparUpasharIrasya vinAshArtham asmAkaM purAtanapuruShastena sAkaM krushe.ahanyateti vayaM jAnImaH| ");
INSERT INTO sanitr_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","yo hataH sa pApAt mukta eva| ");
INSERT INTO sanitr_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","ataeva yadi vayaM khrIShTena sArddham ahanyAmahi tarhi punarapi tena sahitA jIviShyAma ityatrAsmAkaM vishvAso vidyate| ");
INSERT INTO sanitr_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","yataH shmashAnAd utthApitaH khrIShTo puna rna mriyata iti vayaM jAnImaH| tasmin kopyadhikAro mR^ityo rnAsti| ");
INSERT INTO sanitr_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","apara ncha sa yad amriyata tenaikadA pApam uddishyAmriyata, yachcha jIvati teneshvaram uddishya jIvati; ");
INSERT INTO sanitr_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","tadvad yUyamapi svAn pApam uddishya mR^itAn asmAkaM prabhuNA yIshukhrIShTeneshvaram uddishya jIvanto jAnIta| ");
INSERT INTO sanitr_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","apara ncha kutsitAbhilAShAाn pUrayituM yuShmAkaM martyadeheShu pApam AdhipatyaM na karotu| ");
INSERT INTO sanitr_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","aparaM svaM svam a Ngam adharmmasyAstraM kR^itvA pApasevAyAM na samarpayata, kintu shmashAnAd utthitAniva svAn Ishvare samarpayata svAnya NgAni cha dharmmAstrasvarUpANIshvaram uddishya samarpayata| ");
INSERT INTO sanitr_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","yuShmAkam upari pApasyAdhipatyaM puna rna bhaviShyati, yasmAd yUyaM vyavasthAyA anAyattA anugrahasya chAyattA abhavata| ");
INSERT INTO sanitr_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","kintu vayaM vyavasthAyA anAyattA anugrahasya chAyattA abhavAma, iti kAraNAt kiM pApaM kariShyAmaH? tanna bhavatu| ");
INSERT INTO sanitr_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","yato mR^itijanakaM pApaM puNyajanakaM nideshAcharaNa nchaitayordvayo ryasmin Aj nApAlanArthaM bhR^ityAniva svAn samarpayatha, tasyaiva bhR^ityA bhavatha, etat kiM yUyaM na jAnItha? ");
INSERT INTO sanitr_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","apara ncha pUrvvaM yUyaM pApasya bhR^ityA Asteti satyaM kintu yasyAM shikShArUpAyAM mUShAyAM nikShiptA abhavata tasyA AkR^itiM manobhi rlabdhavanta iti kAraNAd Ishvarasya dhanyavAdo bhavatu| ");
INSERT INTO sanitr_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","itthaM yUyaM pApasevAto muktAH santo dharmmasya bhR^ityA jAtAH| ");
INSERT INTO sanitr_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","yuShmAkaM shArIrikyA durbbalatAyA heto rmAnavavad aham etad bravImi; punaH punaradharmmakaraNArthaM yadvat pUrvvaM pApAmedhyayo rbhR^ityatve nijA NgAni samArpayata tadvad idAnIM sAdhukarmmakaraNArthaM dharmmasya bhR^ityatve nijA NgAni samarpayata| ");
INSERT INTO sanitr_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","yadA yUyaM pApasya bhR^ityA Asta tadA dharmmasya nAyattA Asta| ");
INSERT INTO sanitr_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","tarhi yAni karmmANi yUyam idAnIM lajjAjanakAni budhyadhve pUrvvaM tai ryuShmAkaM ko lAbha AsIt? teShAM karmmaNAM phalaM maraNameva| ");
INSERT INTO sanitr_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","kintu sAmprataM yUyaM pApasevAto muktAH santa Ishvarasya bhR^ityA.abhavata tasmAd yuShmAkaM pavitratvarUpaM labhyam anantajIvanarUpa ncha phalam Aste| ");
INSERT INTO sanitr_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","yataH pApasya vetanaM maraNaM kintvasmAkaM prabhuNA yIshukhrIShTenAnantajIvanam IshvaradattaM pAritoShikam Aste| ");
INSERT INTO sanitr_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","he bhrAtR^igaNa vyavasthAvidaH prati mamedaM nivedanaM| vidhiH kevalaM yAvajjIvaM mAnavoparyyadhipatitvaM karotIti yUyaM kiM na jAnItha? ");
INSERT INTO sanitr_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","yAvatkAlaM pati rjIvati tAvatkAlam UDhA bhAryyA vyavasthayA tasmin baddhA tiShThati kintu yadi pati rmriyate tarhi sA nArI patyu rvyavasthAto muchyate| ");
INSERT INTO sanitr_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","etatkAraNAt patyurjIvanakAle nArI yadyanyaM puruShaM vivahati tarhi sA vyabhichAriNI bhavati kintu yadi sa pati rmriyate tarhi sA tasyA vyavasthAyA muktA satI puruShAntareNa vyUDhApi vyabhichAriNI na bhavati| ");
INSERT INTO sanitr_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","he mama bhrAtR^igaNa, IshvaranimittaM yadasmAkaM phalaM jAyate tadarthaM shmashAnAd utthApitena puruSheNa saha yuShmAkaM vivAho yad bhavet tadarthaM khrIShTasya sharIreNa yUyaM vyavasthAM prati mR^itavantaH| ");
INSERT INTO sanitr_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","yato.asmAkaM shArIrikAcharaNasamaye maraNanimittaM phalam utpAdayituM vyavasthayA dUShitaH pApAbhilASho.asmAkam a NgeShu jIvan AsIt| ");
INSERT INTO sanitr_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","kintu tadA yasyA vyavasthAyA vashe Asmahi sAmprataM tAM prati mR^itatvAd vayaM tasyA adhInatvAt muktA iti hetorIshvaro.asmAbhiH purAtanalikhitAnusArAt na sevitavyaH kintu navInasvabhAvenaiva sevitavyaH ");
INSERT INTO sanitr_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","tarhi vayaM kiM brUmaH? vyavasthA kiM pApajanikA bhavati? netthaM bhavatu| vyavasthAm avidyamAnAyAM pApaM kim ityahaM nAvedaM; ki ncha lobhaM mA kArShIriti ched vyavasthAgranthe likhitaM nAbhaviShyat tarhi lobhaH kimbhUtastadahaM nAj nAsyaM| ");
INSERT INTO sanitr_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","kintu vyavasthayA pApaM ChidraM prApyAsmAkam antaH sarvvavidhaM kutsitAbhilASham ajanayat; yato vyavasthAyAm avidyamAnAyAM pApaM mR^itaM| ");
INSERT INTO sanitr_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","aparaM pUrvvaM vyavasthAyAm avidyamAnAyAm aham ajIvaM tataH param Aj nAyAm upasthitAyAm pApam ajIvat tadAham amriye| ");
INSERT INTO sanitr_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","itthaM sati jIvananimittA yAj nA sA mama mR^ityujanikAbhavat| ");
INSERT INTO sanitr_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","yataH pApaM ChidraM prApya vyavasthitAdeshena mAM va nchayitvA tena mAm ahan| ");
INSERT INTO sanitr_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","ataeva vyavasthA pavitrA, Adeshashcha pavitro nyAyyo hitakArI cha bhavati| ");
INSERT INTO sanitr_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","tarhi yat svayaM hitakR^it tat kiM mama mR^ityujanakam abhavat? netthaM bhavatu; kintu pApaM yat pAtakamiva prakAshate tathA nideshena pApaM yadatIva pAtakamiva prakAshate tadarthaM hitopAyena mama maraNam ajanayat| ");
INSERT INTO sanitr_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","vyavasthAtmabodhiketi vayaM jAnImaH kintvahaM shArIratAchArI pApasya krItaki Nkaro vidye| ");
INSERT INTO sanitr_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","yato yat karmma karomi tat mama mano.abhimataM nahi; aparaM yan mama mano.abhimataM tanna karomi kintu yad R^itIye tat karomi| ");
INSERT INTO sanitr_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","tathAtve yan mamAnabhimataM tad yadi karomi tarhi vyavasthA sUttameti svIkaromi| ");
INSERT INTO sanitr_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","ataeva samprati tat karmma mayA kriyata iti nahi kintu mama sharIrasthena pApenaiva kriyate| ");
INSERT INTO sanitr_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","yato mayi, arthato mama sharIre, kimapyuttamaM na vasati, etad ahaM jAnAmi; mamechChukatAyAM tiShThantyAmapyaham uttamakarmmasAdhane samartho na bhavAmi| ");
INSERT INTO sanitr_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","yato yAmuttamAM kriyAM karttumahaM vA nChAmi tAM na karomi kintu yat kutsitaM karmma karttum anichChuko.asmi tadeva karomi| ");
INSERT INTO sanitr_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","ataeva yadyat karmma karttuM mamechChA na bhavati tad yadi karomi tarhi tat mayA na kriyate, mamAntarvarttinA pApenaiva kriyate| ");
INSERT INTO sanitr_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","bhadraM karttum ichChukaM mAM yo .abhadraM karttuM pravarttayati tAdR^ishaM svabhAvamekaM mayi pashyAmi| ");
INSERT INTO sanitr_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","aham AntarikapuruSheNeshvaravyavasthAyAM santuShTa Ase; ");
INSERT INTO sanitr_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","kintu tadviparItaM yudhyantaM tadanyamekaM svabhAvaM madIyA NgasthitaM prapashyAmi, sa madIyA NgasthitapApasvabhAvasyAyattaM mAM karttuM cheShTate| ");
INSERT INTO sanitr_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","hA hA yo.ahaM durbhAgyo manujastaM mAm etasmAn mR^itAchCharIrAt ko nistArayiShyati? ");
INSERT INTO sanitr_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","asmAkaM prabhuNA yIshukhrIShTena nistArayitAram IshvaraM dhanyaM vadAmi| ataeva sharIreNa pApavyavasthAyA manasA tu IshvaravyavasthAyAH sevanaM karomi| ");
INSERT INTO sanitr_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","ye janAH khrIShTaM yIshum Ashritya shArIrikaM nAcharanta AtmikamAcharanti te.adhunA daNDArhA na bhavanti| ");
INSERT INTO sanitr_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","jIvanadAyakasyAtmano vyavasthA khrIShTayIshunA pApamaraNayo rvyavasthAto mAmamochayat| ");
INSERT INTO sanitr_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","yasmAchChArIrasya durbbalatvAd vyavasthayA yat karmmAsAdhyam Ishvaro nijaputraM pApisharIrarUpaM pApanAshakabalirUpa ncha preShya tasya sharIre pApasya daNDaM kurvvan tatkarmma sAdhitavAn| ");
INSERT INTO sanitr_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","tataH shArIrikaM nAcharitvAsmAbhirAtmikam AcharadbhirvyavasthAgranthe nirddiShTAni puNyakarmmANi sarvvANi sAdhyante| ");
INSERT INTO sanitr_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","ye shArIrikAchAriNaste shArIrikAn viShayAn bhAvayanti ye chAtmikAchAriNaste Atmano viShayAn bhAvayanti| ");
INSERT INTO sanitr_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","shArIrikabhAvasya phalaM mR^ityuH ki nchAtmikabhAvasya phale jIvanaM shAntishcha| ");
INSERT INTO sanitr_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","yataH shArIrikabhAva Ishvarasya viruddhaH shatrutAbhAva eva sa Ishvarasya vyavasthAyA adhIno na bhavati bhavitu ncha na shaknoti| ");
INSERT INTO sanitr_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","etasmAt shArIrikAchAriShu toShTum IshvareNa na shakyaM| ");
INSERT INTO sanitr_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","kintvIshvarasyAtmA yadi yuShmAkaM madhye vasati tarhi yUyaM shArIrikAchAriNo na santa AtmikAchAriNo bhavathaH| yasmin tu khrIShTasyAtmA na vidyate sa tatsambhavo nahi| ");
INSERT INTO sanitr_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","yadi khrIShTo yuShmAn adhitiShThati tarhi pApam uddishya sharIraM mR^itaM kintu puNyamuddishyAtmA jIvati| ");
INSERT INTO sanitr_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","mR^itagaNAd yIshu ryenotthApitastasyAtmA yadi yuShmanmadhye vasati tarhi mR^itagaNAt khrIShTasya sa utthApayitA yuShmanmadhyavAsinA svakIyAtmanA yuShmAkaM mR^itadehAnapi puna rjIvayiShyati| ");
INSERT INTO sanitr_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","he bhrAtR^igaNa sharIrasya vayamadhamarNA na bhavAmo.ataH shArIrikAchAro.asmAbhi rna karttavyaH| ");
INSERT INTO sanitr_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","yadi yUyaM sharIrikAchAriNo bhaveta tarhi yuShmAbhi rmarttavyameva kintvAtmanA yadi sharIrakarmmANi ghAtayeta tarhi jIviShyatha| ");
INSERT INTO sanitr_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","yato yAvanto lokA IshvarasyAtmanAkR^iShyante te sarvva Ishvarasya santAnA bhavanti| ");
INSERT INTO sanitr_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","yUyaM punarapi bhayajanakaM dAsyabhAvaM na prAptAH kintu yena bhAveneshvaraM pitaH pitariti prochya sambodhayatha tAdR^ishaM dattakaputratvabhAvam prApnuta| ");
INSERT INTO sanitr_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","apara ncha vayam Ishvarasya santAnA etasmin pavitra AtmA svayam asmAkam AtmAbhiH sArddhaM pramANaM dadAti| ");
INSERT INTO sanitr_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","ataeva vayaM yadi santAnAstarhyadhikAriNaH, arthAd Ishvarasya svattvAdhikAriNaH khrIShTena sahAdhikAriNashcha bhavAmaH; aparaM tena sArddhaM yadi duHkhabhAgino bhavAmastarhi tasya vibhavasyApi bhAgino bhaviShyAmaH| ");
INSERT INTO sanitr_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","kintvasmAsu yo bhAvIvibhavaH prakAshiShyate tasya samIpe varttamAnakAlInaM duHkhamahaM tR^iNAya manye| ");
INSERT INTO sanitr_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","yataH prANigaNa Ishvarasya santAnAnAM vibhavaprAptim AkA NkShan nitAntam apekShate| ");
INSERT INTO sanitr_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","apara ncha prANigaNaH svairam alIkatAyA vashIkR^ito nAbhavat ");
INSERT INTO sanitr_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","kintu prANigaNo.api nashvaratAdhInatvAt muktaH san Ishvarasya santAnAnAM paramamuktiM prApsyatItyabhiprAyeNa vashIkartrA vashIchakre| ");
INSERT INTO sanitr_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","apara ncha prasUyamAnAvad vyathitaH san idAnIM yAvat kR^itsnaH prANigaNa ArttasvaraM karotIti vayaM jAnImaH| ");
INSERT INTO sanitr_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","kevalaH sa iti nahi kintu prathamajAtaphalasvarUpam AtmAnaM prAptA vayamapi dattakaputratvapadaprAptim arthAt sharIrasya muktiM pratIkShamANAstadvad antarArttarAvaM kurmmaH| ");
INSERT INTO sanitr_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","vayaM pratyAshayA trANam alabhAmahi kintu pratyakShavastuno yA pratyAshA sA pratyAshA nahi, yato manuShyo yat samIkShate tasya pratyAshAM kutaH kariShyati? ");
INSERT INTO sanitr_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","yad apratyakShaM tasya pratyAshAM yadi vayaM kurvvImahi tarhi dhairyyam avalambya pratIkShAmahe| ");
INSERT INTO sanitr_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","tata AtmApi svayam asmAkaM durbbalatAyAH sahAyatvaM karoti; yataH kiM prArthitavyaM tad boddhuM vayaM na shaknumaH, kintvaspaShTairArttarAvairAtmA svayam asmannimittaM nivedayati| ");
INSERT INTO sanitr_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","aparam IshvarAbhimatarUpeNa pavitralokAnAM kR^ite nivedayati ya AtmA tasyAbhiprAyo.antaryyAminA j nAyate| ");
INSERT INTO sanitr_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","aparam IshvarIyanirUpaNAnusAreNAhUtAH santo ye tasmin prIyante sarvvANi militvA teShAM ma NgalaM sAdhayanti, etad vayaM jAnImaH| ");
INSERT INTO sanitr_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","yata Ishvaro bahubhrAtR^iNAM madhye svaputraM jyeShThaM karttum ichChan yAn pUrvvaM lakShyIkR^itavAn tAn tasya pratimUrtyAH sAdR^ishyaprAptyarthaM nyayuMkta| ");
INSERT INTO sanitr_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","apara ncha tena ye niyuktAsta AhUtA api ye cha tenAhUtAste sapuNyIkR^itAH, ye cha tena sapuNyIkR^itAste vibhavayuktAH| ");
INSERT INTO sanitr_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","ityatra vayaM kiM brUmaH? Ishvaro yadyasmAkaM sapakSho bhavati tarhi ko vipakSho.asmAkaM? ");
INSERT INTO sanitr_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","AtmaputraM na rakShitvA yo.asmAkaM sarvveShAM kR^ite taM pradattavAn sa kiM tena sahAsmabhyam anyAni sarvvANi na dAsyati? ");
INSERT INTO sanitr_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","IshvarasyAbhiruchiteShu kena doSha AropayiShyate? ya IshvarastAn puNyavata iva gaNayati kiM tena? ");
INSERT INTO sanitr_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","aparaM tebhyo daNDadAnAj nA vA kena kariShyate? yo.asmannimittaM prANAn tyaktavAn kevalaM tanna kintu mR^itagaNamadhyAd utthitavAn, api cheshvarasya dakShiNe pArshve tiShThan adyApyasmAkaM nimittaM prArthata evambhUto yaH khrIShTaH kiM tena? ");
INSERT INTO sanitr_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","asmAbhiH saha khrIShTasya premavichChedaM janayituM kaH shaknoti? klesho vyasanaM vA tADanA vA durbhikShaM vA vastrahInatvaM vA prANasaMshayo vA kha Ngo vA kimetAni shaknuvanti? ");
INSERT INTO sanitr_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","kintu likhitam Aste, yathA, vayaM tava nimittaM smo mR^ityuvaktre.akhilaM dinaM| balirdeyo yathA meSho vayaM gaNyAmahe tathA| ");
INSERT INTO sanitr_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","aparaM yo.asmAsu prIyate tenaitAsu vipatsu vayaM samyag vijayAmahe| ");
INSERT INTO sanitr_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","yato.asmAkaM prabhunA yIshukhrIShTeneshvarasya yat prema tasmAd asmAkaM vichChedaM janayituM mR^ityu rjIvanaM vA divyadUtA vA balavanto mukhyadUtA vA varttamAno vA bhaviShyan kAlo vA uchchapadaM vA nIchapadaM vAparaM kimapi sR^iShTavastu ");
INSERT INTO sanitr_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","vaiteShAM kenApi na shakyamityasmin dR^iDhavishvAso mamAste| ");
INSERT INTO sanitr_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","ahaM kA nchid kalpitAM kathAM na kathayAmi, khrIShTasya sAkShAt satyameva bravImi pavitrasyAtmanaH sAkShAn madIyaM mana etat sAkShyaM dadAti| ");
INSERT INTO sanitr_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","mamAntaratishayaduHkhaM nirantaraM khedashcha ");
INSERT INTO sanitr_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","tasmAd ahaM svajAtIyabhrAtR^iNAM nimittAt svayaM khrIShTAchChApAkrAnto bhavitum aichCham| ");
INSERT INTO sanitr_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","yatasta isrAyelasya vaMshA api cha dattakaputratvaM tejo niyamo vyavasthAdAnaM mandire bhajanaM pratij nAH pitR^ipuruShagaNashchaiteShu sarvveShu teShAm adhikAro.asti| ");
INSERT INTO sanitr_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","tat kevalaM nahi kintu sarvvAdhyakShaH sarvvadA sachchidAnanda Ishvaro yaH khrIShTaH so.api shArIrikasambandhena teShAM vaMshasambhavaH| ");
INSERT INTO sanitr_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Ishvarasya vAkyaM viphalaM jAtam iti nahi yatkAraNAd isrAyelo vaMshe ye jAtAste sarvve vastuta isrAyelIyA na bhavanti| ");
INSERT INTO sanitr_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","aparam ibrAhImo vaMshe jAtA api sarvve tasyaiva santAnA na bhavanti kintu ishAko nAmnA tava vaMsho vikhyAto bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","arthAt shArIrikasaMsargAt jAtAH santAnA yAvantastAvanta eveshvarasya santAnA na bhavanti kintu pratishravaNAd ye jAyante taeveshvaravaMsho gaNyate| ");
INSERT INTO sanitr_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","yatastatpratishrute rvAkyametat, etAdR^ishe samaye .ahaM punarAgamiShyAmi tatpUrvvaM sArAyAH putra eko janiShyate| ");
INSERT INTO sanitr_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","aparamapi vadAmi svamano.abhilAShata IshvareNa yannirUpitaM tat karmmato nahi kintvAhvayitu rjAtametad yathA siddhyati ");
INSERT INTO sanitr_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","tadarthaM ribkAnAmikayA yoShitA janaikasmAd arthAd asmAkam ishAkaH pUrvvapuruShAd garbhe dhR^ite tasyAH santAnayoH prasavAt pUrvvaM ki ncha tayoH shubhAshubhakarmmaNaH karaNAt pUrvvaM ");
INSERT INTO sanitr_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","tAM pratIdaM vAkyam uktaM, jyeShThaH kaniShThaM seviShyate, ");
INSERT INTO sanitr_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","yathA likhitam Aste, tathApyeShAvi na prItvA yAkUbi prItavAn ahaM| ");
INSERT INTO sanitr_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","tarhi vayaM kiM brUmaH? IshvaraH kim anyAyakArI? tathA na bhavatu| ");
INSERT INTO sanitr_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","yataH sa svayaM mUsAm avadat; ahaM yasmin anugrahaM chikIrShAmi tamevAnugR^ihlAmi, ya ncha dayitum ichChAmi tameva daye| ");
INSERT INTO sanitr_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","ataevechChatA yatamAnena vA mAnavena tanna sAdhyate dayAkAriNeshvareNaiva sAdhyate| ");
INSERT INTO sanitr_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","phirauNi shAstre likhati, ahaM tvaddvArA matparAkramaM darshayituM sarvvapR^ithivyAM nijanAma prakAshayitu ncha tvAM sthApitavAn| ");
INSERT INTO sanitr_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","ataH sa yam anugrahItum ichChati tamevAnugR^ihlAti, ya ncha nigrahItum ichChati taM nigR^ihlAti| ");
INSERT INTO sanitr_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","yadi vadasi tarhi sa doShaM kuto gR^ihlAti? tadIyechChAyAH pratibandhakatvaM karttaM kasya sAmarthyaM vidyate? ");
INSERT INTO sanitr_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","he Ishvarasya pratipakSha martya tvaM kaH? etAdR^ishaM mAM kutaH sR^iShTavAn? iti kathAM sR^iShTavastu sraShTre kiM kathayiShyati? ");
INSERT INTO sanitr_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","ekasmAn mR^itpiNDAd utkR^iShTApakR^iShTau dvividhau kalashau karttuM kiM kulAlasya sAmarthyaM nAsti? ");
INSERT INTO sanitr_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","IshvaraH kopaM prakAshayituM nijashaktiM j nApayitu nchechChan yadi vinAshasya yogyAni krodhabhAjanAni prati bahukAlaM dIrghasahiShNutAm Ashrayati; ");
INSERT INTO sanitr_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","apara ncha vibhavaprAptyarthaM pUrvvaM niyuktAnyanugrahapAtrANi prati nijavibhavasya bAhulyaM prakAshayituM kevalayihUdinAM nahi bhinnadeshinAmapi madhyAd ");
INSERT INTO sanitr_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","asmAniva tAnyAhvayati tatra tava kiM? ");
INSERT INTO sanitr_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","hosheyagranthe yathA likhitam Aste, yo loko mama nAsIt taM vadiShyAmi madIyakaM| yA jAti rme.apriyA chAsIt tAM vadiShyAmyahaM priyAM| ");
INSERT INTO sanitr_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","yUyaM madIyalokA na yatreti vAkyamauchyata| amareshasya santAnA iti khyAsyanti tatra te| ");
INSERT INTO sanitr_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","isrAyelIyalokeShu yishAyiyo.api vAchametAM prAchArayat, isrAyelIyavaMshAnAM yA saMkhyA sA tu nishchitaM| samudrasikatAsaMkhyAsamAnA yadi jAyate| tathApi kevalaM lokairalpaistrANaM vrajiShyate| ");
INSERT INTO sanitr_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","yato nyAyena svaM karmma pareshaH sAdhayiShyati| deshe saeva saMkShepAnnijaM karmma kariShyati| ");
INSERT INTO sanitr_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","yishAyiyo.aparamapi kathayAmAsa, sainyAdhyakShapareshena chet ki nchinnodashiShyata| tadA vayaM sidomevAbhaviShyAma vinishchitaM| yadvA vayam amorAyA agamiShyAma tulyatAM| ");
INSERT INTO sanitr_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","tarhi vayaM kiM vakShyAmaH? itaradeshIyA lokA api puNyArtham ayatamAnA vishvAsena puNyam alabhanta; ");
INSERT INTO sanitr_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","kintvisrAyellokA vyavasthApAlanena puNyArthaM yatamAnAstan nAlabhanta| ");
INSERT INTO sanitr_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","tasya kiM kAraNaM? te vishvAsena nahi kintu vyavasthAyAH kriyayA cheShTitvA tasmin skhalanajanake pAShANe pAdaskhalanaM prAptAH| ");
INSERT INTO sanitr_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","likhitaM yAdR^isham Aste, pashya pAdaskhalArthaM hi sIyoni prastarantathA| bAdhAkAra ncha pAShANaM paristhApitavAnaham| vishvasiShyati yastatra sa jano na trapiShyate| ");
INSERT INTO sanitr_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","he bhrAtara isrAyelIyalokA yat paritrANaM prApnuvanti tadahaM manasAbhilaShan Ishvarasya samIpe prArthaye| ");
INSERT INTO sanitr_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","yata Ishvare teShAM cheShTA vidyata ityatrAhaM sAkShyasmi; kintu teShAM sA cheShTA saj nAnA nahi, ");
INSERT INTO sanitr_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","yatasta IshvaradattaM puNyam avij nAya svakR^itapuNyaM sthApayitum cheShTamAnA Ishvaradattasya puNyasya nighnatvaM na svIkurvvanti| ");
INSERT INTO sanitr_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","khrIShTa ekaikavishvAsijanAya puNyaM dAtuM vyavasthAyAH phalasvarUpo bhavati| ");
INSERT INTO sanitr_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","vyavasthApAlanena yat puNyaM tat mUsA varNayAmAsa, yathA, yo janastAM pAlayiShyati sa taddvArA jIviShyati| ");
INSERT INTO sanitr_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","kintu pratyayena yat puNyaM tad etAdR^ishaM vAkyaM vadati, kaH svargam Aruhya khrIShTam avarohayiShyati? ");
INSERT INTO sanitr_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","ko vA pretalokam avaruhya khrIShTaM mR^itagaNamadhyAd AneShyatIti vAk manasi tvayA na gaditavyA| ");
INSERT INTO sanitr_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","tarhi kiM bravIti? tad vAkyaM tava samIpastham arthAt tava vadane manasi chAste, tachcha vAkyam asmAbhiH prachAryyamANaM vishvAsasya vAkyameva| ");
INSERT INTO sanitr_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","vastutaH prabhuM yIshuM yadi vadanena svIkaroShi, tatheshvarastaM shmashAnAd udasthApayad iti yadyantaHkaraNena vishvasiShi tarhi paritrANaM lapsyase| ");
INSERT INTO sanitr_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","yasmAt puNyaprAptyartham antaHkaraNena vishvasitavyaM paritrANArtha ncha vadanena svIkarttavyaM| ");
INSERT INTO sanitr_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","shAstre yAdR^ishaM likhati vishvasiShyati yastatra sa jano na trapiShyate| ");
INSERT INTO sanitr_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","ityatra yihUdini tadanyaloke cha kopi visheSho nAsti yasmAd yaH sarvveShAm advitIyaH prabhuH sa nijayAchakAna sarvvAn prati vadAnyo bhavati| ");
INSERT INTO sanitr_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","yataH, yaH kashchit parameshasya nAmnA hi prArthayiShyate| sa eva manujo nUnaM paritrAto bhaviShyati| ");
INSERT INTO sanitr_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","yaM ye janA na pratyAyan te tamuddishya kathaM prArthayiShyante? ye vA yasyAkhyAnaM kadApi na shrutavantaste taM kathaM pratyeShyanti? aparaM yadi prachArayitAro na tiShThanti tadA kathaM te shroShyanti? ");
INSERT INTO sanitr_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","yadi vA preritA na bhavanti tadA kathaM prachArayiShyanti? yAdR^ishaM likhitam Aste, yathA, mA NgalikaM susaMvAdaM dadatyAnIya ye narAH| prachArayanti shAnteshcha susaMvAdaM janAstu ye| teShAM charaNapadmAni kIdR^ik shobhAnvitAni hi| ");
INSERT INTO sanitr_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","kintu te sarvve taM susaMvAdaM na gR^ihItavantaH| yishAyiyo yathA likhitavAn| asmatprachArite vAkye vishvAsamakaroddhi kaH| ");
INSERT INTO sanitr_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","ataeva shravaNAd vishvAsa aishvaravAkyaprachArAt shravaNa ncha bhavati| ");
INSERT INTO sanitr_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","tarhyahaM bravImi taiH kiM nAshrAvi? avashyam ashrAvi, yasmAt teShAM shabdo mahIM vyApnod vAkya ncha nikhilaM jagat| ");
INSERT INTO sanitr_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","aparamapi vadAmi, isrAyelIyalokAH kim etAM kathAM na budhyante? prathamato mUsA idaM vAkyaM provAcha, ahamuttApayiShye tAn agaNyamAnavairapi| klekShyAmi jAtim etA ncha pronmattabhinnajAtibhiH| ");
INSERT INTO sanitr_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","apara ncha yishAyiyo.atishayAkShobheNa kathayAmAsa, yathA, adhi mAM yaistu nAcheShTi samprAptastai rjanairahaM| adhi mAM yai rna sampR^iShTaM vij nAtastai rjanairahaM|| ");
INSERT INTO sanitr_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","kintvisrAyelIyalokAn adhi kathayA nchakAra, yairAj nAla Nghibhi rlokai rviruddhaM vAkyamuchyate| tAn pratyeva dinaM kR^itsnaM hastau vistArayAmyahaM|| ");
INSERT INTO sanitr_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","IshvareNa svIkIyalokA apasAritA ahaM kim IdR^ishaM vAkyaM bravImi? tanna bhavatu yato.ahamapi binyAmInagotrIya ibrAhImavaMshIya isrAyelIyaloko.asmi| ");
INSERT INTO sanitr_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","IshvareNa pUrvvaM ye pradR^iShTAste svakIyalokA apasAritA iti nahi| aparam eliyopAkhyAne shAstre yallikhitam Aste tad yUyaM kiM na jAnItha? ");
INSERT INTO sanitr_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","he parameshvara lokAstvadIyAH sarvvA yaj navedIrabha njan tathA tava bhaviShyadvAdinaH sarvvAn aghnan kevala eko.aham avashiShTa Ase te mamApi prANAn nAshayituM cheShTanate, etAM kathAm isrAyelIyalokAnAM viruddham eliya IshvarAya nivedayAmAsa| ");
INSERT INTO sanitr_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","tatastaM pratIshvarasyottaraM kiM jAtaM? bAlnAmno devasya sAkShAt yai rjAnUni na pAtitAni tAdR^ishAH sapta sahasrANi lokA avasheShitA mayA| ");
INSERT INTO sanitr_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","tadvad etasmin varttamAnakAle.api anugraheNAbhiruchitAsteShAm avashiShTAH katipayA lokAH santi| ");
INSERT INTO sanitr_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","ataeva tad yadyanugraheNa bhavati tarhi kriyayA na bhavati no ched anugraho.ananugraha eva, yadi vA kriyayA bhavati tarhyanugraheNa na bhavati no chet kriyA kriyaiva na bhavati| ");
INSERT INTO sanitr_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","tarhi kiM? isrAyelIyalokA yad amR^igayanta tanna prApuH| kintvabhiruchitalokAstat prApustadanye sarvva andhIbhUtAH| ");
INSERT INTO sanitr_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","yathA likhitam Aste, ghoranidrAlutAbhAvaM dR^iShTihIne cha lochane| karNau shrutivihInau cha pradadau tebhya Ishvar