﻿USE sofia;
DROP TABLE IF EXISTS sofia.saniso_vpl;
CREATE TABLE saniso_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES saniso_vpl WRITE;
INSERT INTO saniso_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ibrāhīmaḥ santānō dāyūd tasya santānō yīśukhrīṣṭastasya pūrvvapuruṣavaṁśaśrēṇī| ");
INSERT INTO saniso_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ibrāhīmaḥ putra ishāk tasya putrō yākūb tasya putrō yihūdāstasya bhrātaraśca| ");
INSERT INTO saniso_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","tasmād yihūdātastāmarō garbhē pērassērahau jajñātē, tasya pērasaḥ putrō hiṣrōṇ tasya putrō 'rām| ");
INSERT INTO saniso_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","tasya putrō 'mmīnādab tasya putrō nahaśōn tasya putraḥ salmōn| ");
INSERT INTO saniso_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","tasmād rāhabō garbhē bōyam jajñē, tasmād rūtō garbhē ōbēd jajñē, tasya putrō yiśayaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","tasya putrō dāyūd rājaḥ tasmād mr̥tōriyasya jāyāyāṁ sulēmān jajñē| ");
INSERT INTO saniso_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","tasya putrō rihabiyām, tasya putrō'biyaḥ, tasya putra āsā:| ");
INSERT INTO saniso_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","tasya sutō yihōśāphaṭ tasya sutō yihōrāma tasya suta uṣiyaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","tasya sutō yōtham tasya suta āham tasya sutō hiṣkiyaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","tasya sutō minaśiḥ, tasya suta āmōn tasya sutō yōśiyaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","bābilnagarē pravasanāt pūrvvaṁ sa yōśiyō yikhaniyaṁ tasya bhrātr̥ṁśca janayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","tatō bābili pravasanakālē yikhaniyaḥ śaltīyēlaṁ janayāmāsa, tasya sutaḥ sirubbāvil| ");
INSERT INTO saniso_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","tasya sutō 'bōhud tasya suta ilīyākīm tasya sutō'sōr| ");
INSERT INTO saniso_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","asōraḥ sutaḥ sādōk tasya suta ākhīm tasya suta ilīhūd| ");
INSERT INTO saniso_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","tasya suta iliyāsar tasya sutō mattan| ");
INSERT INTO saniso_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","tasya sutō yākūb tasya sutō yūṣaph tasya jāyā mariyam; tasya garbhē yīśurajani, tamēva khrīṣṭam (arthād abhiṣiktaṁ) vadanti| ");
INSERT INTO saniso_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ittham ibrāhīmō dāyūdaṁ yāvat sākalyēna caturdaśapuruṣāḥ; ā dāyūdaḥ kālād bābili pravasanakālaṁ yāvat caturdaśapuruṣā bhavanti| bābili pravāsanakālāt khrīṣṭasya kālaṁ yāvat caturdaśapuruṣā bhavanti| ");
INSERT INTO saniso_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","yīśukhrīṣṭasya janma kaththatē| mariyam nāmikā kanyā yūṣaphē vāgdattāsīt, tadā tayōḥ saṅgamāt prāk sā kanyā  pavitrēṇātmanā garbhavatī babhūva| ");
INSERT INTO saniso_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","tatra tasyāḥ pati ryūṣaph saujanyāt tasyāḥ kalaṅgaṁ prakāśayitum anicchan gōpanēnē tāṁ pārityaktuṁ manaścakrē| ");
INSERT INTO saniso_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","sa tathaiva bhāvayati, tadānīṁ paramēśvarasya dūtaḥ svapnē taṁ darśanaṁ dattvā vyājahāra, hē dāyūdaḥ santāna yūṣaph tvaṁ nijāṁ jāyāṁ mariyamam ādātuṁ mā bhaiṣīḥ| ");
INSERT INTO saniso_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","yatastasyā garbhaḥ pavitrādātmanō'bhavat, sā ca putraṁ prasaviṣyatē, tadā tvaṁ tasya nāma yīśum (arthāt trātāraṁ) karīṣyasē, yasmāt sa nijamanujān tēṣāṁ kaluṣēbhya uddhariṣyati| ");
INSERT INTO saniso_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","itthaṁ sati, paśya garbhavatī kanyā tanayaṁ prasaviṣyatē| immānūyēl tadīyañca nāmadhēyaṁ bhaviṣyati|| immānūyēl asmākaṁ saṅgīśvara̮ityarthaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","iti yad vacanaṁ purvvaṁ bhaviṣyadvaktrā īśvaraḥ kathāyāmāsa, tat tadānīṁ siddhamabhavat| ");
INSERT INTO saniso_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","anantaraṁ yūṣaph nidrātō jāgarita utthāya paramēśvarīyadūtasya nidēśānusārēṇa nijāṁ jāyāṁ jagrāha, ");
INSERT INTO saniso_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","kintu yāvat sā nijaṁ prathamasutaṁ a suṣuvē, tāvat tāṁ nōpāgacchat, tataḥ sutasya nāma yīśuṁ cakrē| ");
INSERT INTO saniso_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","anantaraṁ hērōd saṁjñakē rājñi rājyaṁ śāsati yihūdīyadēśasya baitlēhami nagarē yīśau jātavati ca, katipayā jyōtirvvudaḥ pūrvvasyā diśō yirūśālamnagaraṁ samētya kathayamāsuḥ, ");
INSERT INTO saniso_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","yō yihūdīyānāṁ rājā jātavān, sa kutrāstē? vayaṁ pūrvvasyāṁ diśi tiṣṭhantastadīyāṁ tārakām apaśyāma tasmāt taṁ praṇantum aाgamāma| ");
INSERT INTO saniso_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","tadā hērōd rājā kathāmētāṁ niśamya yirūśālamnagarasthitaiḥ sarvvamānavaiḥ sārddham udvijya ");
INSERT INTO saniso_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","sarvvān pradhānayājakān adhyāpakāṁśca samāhūyānīya papraccha, khrīṣṭaḥ kutra janiṣyatē? ");
INSERT INTO saniso_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","tadā tē kathayāmāsuḥ, yihūdīyadēśasya baitlēhami nagarē, yatō bhaviṣyadvādinā itthaṁ likhitamāstē, ");
INSERT INTO saniso_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","sarvvābhyō rājadhānībhyō yihūdīyasya nīvr̥taḥ| hē yīhūdīyadēśasyē baitlēham tvaṁ na cāvarā|isrāyēlīyalōkān mē yatō yaḥ pālayiṣyati| tādr̥gēkō mahārājastvanmadhya udbhaviṣyatī|| ");
INSERT INTO saniso_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","tadānīṁ hērōd rājā tān jyōtirvvidō gōpanam āhūya sā tārakā kadā dr̥ṣṭābhavat , tad viniścayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","aparaṁ tān baitlēhamaṁ prahītya gaditavān, yūyaṁ yāta, yatnāt taṁ śiśum anviṣya taduddēśē prāptē mahyaṁ vārttāṁ dāsyatha, tatō mayāpi gatvā sa praṇaṁsyatē| ");
INSERT INTO saniso_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","tadānīṁ rājña ētādr̥śīm ājñāṁ prāpya tē pratasthirē, tataḥ pūrvvarsyāṁ diśi sthitaistai ryā tārakā dr̥ṣṭā sā tārakā tēṣāmagrē gatvā yatra sthānē śiśūrāstē, tasya sthānasyōpari sthagitā tasyau| ");
INSERT INTO saniso_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","tad dr̥ṣṭvā tē mahānanditā babhūvuḥ, ");
INSERT INTO saniso_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","tatō gēhamadhya praviśya tasya mātrā mariyamā sāddhaṁ taṁ śiśuṁ nirīkṣaya daṇḍavad bhūtvā praṇēmuḥ, aparaṁ svēṣāṁ ghanasampattiṁ mōcayitvā suvarṇaṁ kunduruṁ gandharamañca tasmai darśanīyaṁ dattavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","paścād hērōd rājasya samīpaṁ punarapi gantuṁ svapna īśvarēṇa niṣiddhāḥ santō 'nyēna pathā tē nijadēśaṁ prati pratasthirē| ");
INSERT INTO saniso_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","anantaraṁ tēṣu gatavatmu paramēśvarasya dūtō yūṣaphē svapnē darśanaṁ datvā jagāda, tvam utthāya śiśuṁ tanmātarañca gr̥hītvā misardēśaṁ palāyasva, aparaṁ yāvadahaṁ tubhyaṁ vārttāṁ na kathayiṣyāmi, tāvat tatraiva nivasa, yatō rājā hērōd śiśuṁ nāśayituṁ mr̥gayiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","tadānīṁ yūṣaph utthāya rajanyāṁ śiśuṁ tanmātarañca gr̥hītvā misardēśaṁ prati pratasthē, ");
INSERT INTO saniso_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","gatvā ca hērōdō nr̥patē rmaraṇaparyyantaṁ tatra dēśē nyuvāsa, tēna misardēśādahaṁ putraṁ svakīyaṁ samupāhūyam| yadētadvacanam īśvarēṇa bhaviṣyadvādinā kathitaṁ tat saphalamabhūt| ");
INSERT INTO saniso_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","anantaraṁ hērōd jyōtirvidbhirātmānaṁ pravañcitaṁ vijñāya bhr̥śaṁ cukōpa; aparaṁ jyōtirvvidbhyastēna viniścitaṁ yad dinaṁ taddinād gaṇayitvā dvitīyavatsaraṁ praviṣṭā yāvantō bālakā asmin baitlēhamnagarē tatsīmamadhyē cāsan, lōkān prahitya tān sarvvān ghātayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ataḥ anēkasya vilāpasya nināda: krandanasya ca| śōkēna kr̥taśabdaśca rāmāyāṁ saṁniśamyatē| svabālagaṇahētōrvai rāhēl nārī tu rōdinī| na manyatē prabōdhantu yatastē naiva manti hi|| ");
INSERT INTO saniso_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","yadētad vacanaṁ yirīmiyanāmakabhaviṣyadvādinā kathitaṁ tat tadānīṁ saphalam abhūt| ");
INSERT INTO saniso_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","tadanantaraṁ hērēdi rājani mr̥tē paramēśvarasya dūtō misardēśē svapnē darśanaṁ dattvā yūṣaphē kathitavān ");
INSERT INTO saniso_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","tvam utthāya śiśuṁ tanmātarañca gr̥hītvā punarapīsrāyēlō dēśaṁ yāhī, yē janāḥ śiśuṁ nāśayitum amr̥gayanta, tē mr̥tavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","tadānīṁ sa utthāya śiśuṁ tanmātarañca gr̥hlan isrāyēldēśam ājagāma| ");
INSERT INTO saniso_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","kintu yihūdīyadēśē arkhilāyanāma rājakumārō nijapitu rhērōdaḥ padaṁ prāpya rājatvaṁ karōtīti niśamya tat sthānaṁ yātuṁ śaṅkitavān, paścāt svapna īśvarāt prabōdhaṁ prāpya gālīldēśasya pradēśaikaṁ prasthāya nāsarannāma nagaraṁ gatvā tatra nyuṣitavān, ");
INSERT INTO saniso_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","tēna taṁ nāsaratīyaṁ kathayiṣyanti, yadētadvākyaṁ bhaviṣyadvādibhirukttaṁ tat saphalamabhavat| ");
INSERT INTO saniso_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","tadānōṁ yōhnnāmā majjayitā yihūdīyadēśasya prāntaram upasthāya pracārayan kathayāmāsa, ");
INSERT INTO saniso_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","manāṁsi parāvarttayata, svargīyarājatvaṁ samīpamāgatam| ");
INSERT INTO saniso_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","paramēśasya panthānaṁ pariṣkuruta sarvvataḥ| tasya rājapathāṁścaiva samīkuruta sarvvathā| ityētat prāntarē vākyaṁ vadataḥ kasyacid ravaḥ|| ");
INSERT INTO saniso_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ētadvacanaṁ yiśayiyabhaviṣyadvādinā yōhanamuddiśya bhāṣitam| yōhanō vasanaṁ mahāṅgarōmajaṁ tasya kaṭau carmmakaṭibandhanaṁ; sa ca śūkakīṭān madhu ca bhuktavān| ");
INSERT INTO saniso_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","tadānīṁ yirūśālamnagaranivāsinaḥ sarvvē yihūdidēśīyā yarddantaṭinyā ubhayataṭasthāśca mānavā bahirāgatya tasya samīpē ");
INSERT INTO saniso_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","svīyaṁ svīyaṁ duritam aṅgīkr̥tya tasyāṁ yarddani tēna majjitā babhūvuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","aparaṁ bahūn phirūśinaḥ sidūkinaśca manujān maṁktuṁ svasamīpam āgacchtō vilōkya sa tān abhidadhau, rē rē bhujagavaṁśā āgāmīnaḥ kōpāt palāyituṁ yuṣmān kaścētitavān? ");
INSERT INTO saniso_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","manaḥparāvarttanasya samucitaṁ phalaṁ phalata| ");
INSERT INTO saniso_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","kintvasmākaṁ tāta ibrāhīm astīti svēṣu manaḥsu cīntayantō mā vyāharata| yatō yuṣmān ahaṁ vadāmi, īśvara ētēbhyaḥ pāṣāṇēbhya ibrāhīmaḥ santānān utpādayituṁ śaknōti| ");
INSERT INTO saniso_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","aparaṁ pādapānāṁ mūlē kuṭhāra idānīmapi lagan āstē, tasmād yasmin pādapē uttamaṁ phalaṁ na bhavati, sa kr̥ttō madhyē'gniṁ nikṣēpsyatē| ");
INSERT INTO saniso_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","aparam ahaṁ manaḥparāvarttanasūcakēna majjanēna yuṣmān majjayāmīti satyaṁ, kintu mama paścād ya āgacchati, sa mattōpi mahān, ahaṁ tadīyōpānahau vōḍhumapi nahi yōgyōsmi, sa yuṣmān vahnirūpē pavitra ātmani saṁmajjayiṣyati| ");
INSERT INTO saniso_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","tasya kārē sūrpa āstē, sa svīyaśasyāni samyak prasphōṭya nijān sakalagōdhūmān saṁgr̥hya bhāṇḍāgārē sthāpayiṣyati, kiṁntu sarvvāṇi vuṣāṇyanirvvāṇavahninā dāhayiṣyati| ");
INSERT INTO saniso_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","anantaraṁ yīśu ryōhanā majjitō bhavituṁ gālīlpradēśād yarddani tasya samīpam ājagāma| ");
INSERT INTO saniso_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","kintu yōhan taṁ niṣidhya babhāṣē, tvaṁ kiṁ mama samīpam āgacchasi? varaṁ tvayā majjanaṁ mama prayōjanam āstē| ");
INSERT INTO saniso_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","tadānīṁ yīśuḥ pratyavōcat; īdānīm anumanyasva, yata itthaṁ sarvvadharmmasādhanam asmākaṁ karttavyaṁ, tataḥ sō'nvamanyata| ");
INSERT INTO saniso_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","anantaraṁ yīśurammasi majjituḥ san tatkṣaṇāt tōyamadhyād utthāya jagāma, tadā jīmūtadvārē muktē jātē, sa īśvarasyātmānaṁ kapōtavad avaruhya svōparyyāgacchantaṁ vīkṣāñcakrē| ");
INSERT INTO saniso_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","aparam ēṣa mama priyaḥ putra ētasminnēva mama mahāsantōṣa ētādr̥śī vyōmajā vāg babhūva| ");
INSERT INTO saniso_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","tataḥ paraṁ yīśuḥ pratārakēṇa parīkṣitō bhavitum ātmanā prāntaram ākr̥ṣṭaḥ ");
INSERT INTO saniso_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","san catvāriṁśadahōrātrān anāhārastiṣṭhan kṣudhitō babhūva| ");
INSERT INTO saniso_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","tadānīṁ parīkṣitā tatsamīpam āgatya vyāhr̥tavān, yadi tvamīśvarātmajō bhavēstarhyājñayā pāṣāṇānētān pūpān vidhēhi| ");
INSERT INTO saniso_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","tataḥ sa pratyabravīt, itthaṁ likhitamāstē, \"manujaḥ kēvalapūpēna na jīviṣyati, kintvīśvarasya vadanād yāni yāni vacāṁsi niḥsaranti tairēva jīviṣyati|\" ");
INSERT INTO saniso_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","tadā pratārakastaṁ puṇyanagaraṁ nītvā mandirasya cūḍōpari nidhāya gaditavān, ");
INSERT INTO saniso_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","tvaṁ yadiśvarasya tanayō bhavēstarhītō'dhaḥ pata, yata itthaṁ likhitamāstē, ādēkṣyati nijān dūtān rakṣituṁ tvāṁ paramēśvaraḥ| yathā sarvvēṣu mārgēṣu tvadīyacaraṇadvayē| na lagēt prastarāghātastvāṁ ghariṣyanti tē karaiḥ|| ");
INSERT INTO saniso_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","tadānīṁ yīśustasmai kathitavān ētadapi likhitamāstē, \"tvaṁ nijaprabhuṁ paramēśvaraṁ mā parīkṣasva|\" ");
INSERT INTO saniso_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","anantaraṁ pratārakaḥ punarapi tam atyuñcadharādharōpari nītvā jagataḥ sakalarājyāni tadaiśvaryyāṇi ca darśayāścakāra kathayāñcakāra ca, ");
INSERT INTO saniso_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","yadi tvaṁ daṇḍavad bhavan māṁ praṇamēstarhyaham ētāni tubhyaṁ pradāsyāmi| ");
INSERT INTO saniso_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","tadānīṁ yīśustamavōcat, dūrībhava pratāraka, likhitamidam āstē, \"tvayā nijaḥ prabhuḥ paramēśvaraḥ praṇamyaḥ kēvalaḥ sa sēvyaśca|\" ");
INSERT INTO saniso_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","tataḥ pratārakēṇa sa paryyatyāji, tadā svargīyadūtairāgatya sa siṣēvē| ");
INSERT INTO saniso_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","tadanantaraṁ yōhan kārāyāṁ babandhē, tadvārttāṁ niśamya yīśunā gālīl prāsthīyata| ");
INSERT INTO saniso_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","tataḥ paraṁ sa nāsarannagaraṁ vihāya jalaghēstaṭē sibūlūnnaptālī ētayōruvabhayōḥ pradēśayōḥ sīmnōrmadhyavarttī ya: kapharnāhūm tannagaram itvā nyavasat| ");
INSERT INTO saniso_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","tasmāt, anyādēśīyagālīli yarddanpārē'bdhirōdhasi| naptālisibūlūndēśau yatra sthānē sthitau purā| ");
INSERT INTO saniso_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","tatratyā manujā yē yē paryyabhrāmyan tamisrakē| tairjanairbr̥hadālōkaḥ paridarśiṣyatē tadā| avasan yē janā dēśē mr̥tyucchāyāsvarūpakē| tēṣāmupari lōkānāmālōkaḥ saṁprakāśitaḥ|| ");
INSERT INTO saniso_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","yadētadvacanaṁ yiśayiyabhaviṣyadvādinā prōktaṁ, tat tadā saphalam abhūt| ");
INSERT INTO saniso_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","anantaraṁ yīśuḥ susaṁvādaṁ pracārayan ētāṁ kathāṁ kathayitum ārēbhē, manāṁsi parāvarttayata, svargīyarājatvaṁ savidhamabhavat| ");
INSERT INTO saniso_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","tataḥ paraṁ yīśu rgālīlō jaladhēstaṭēna gacchan gacchan āndriyastasya bhrātā śimōn arthatō yaṁ pitaraṁ vadanti ētāvubhau jalaghau jālaṁ kṣipantau dadarśa, yatastau mīnadhāriṇāvāstām| ");
INSERT INTO saniso_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","tadā sa tāvāhūya vyājahāra, yuvāṁ mama paścād āgacchataṁ, yuvāmahaṁ manujadhāriṇau kariṣyāmi| ");
INSERT INTO saniso_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","tēnaiva tau jālaṁ vihāya tasya paścāt āgacchatām| ");
INSERT INTO saniso_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","anantaraṁ tasmāt sthānāt vrajan vrajan sivadiyasya sutau yākūb yōhannāmānau dvau sahajau tātēna sārddhaṁ naukōpari jālasya jīrṇōddhāraṁ kurvvantau vīkṣya tāvāhūtavān| ");
INSERT INTO saniso_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","tatkṣaṇāt tau nāvaṁ svatātañca vihāya tasya paścādgāminau babhūvatuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","anantaraṁ bhajanabhavanē samupadiśan rājyasya susaṁvādaṁ pracārayan manujānāṁ sarvvaprakārān rōgān sarvvaprakārapīḍāśca śamayan yīśuḥ kr̥tsnaṁ gālīldēśaṁ bhramitum ārabhata| ");
INSERT INTO saniso_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","tēna kr̥tsnasuriyādēśasya madhyaṁ tasya yaśō vyāpnōt, aparaṁ bhūtagrastā apasmārargīṇaḥ pakṣādhātiprabhr̥tayaśca yāvantō manujā nānāvidhavyādhibhiḥ kliṣṭā āsan, tēṣu sarvvēṣu tasya samīpam ānītēṣu sa tān svasthān cakāra| ");
INSERT INTO saniso_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ētēna gālīl-dikāpani-yirūśālam-yihūdīyadēśēbhyō yarddanaḥ pārāñca bahavō manujāstasya paścād āgacchan| ");
INSERT INTO saniso_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","anantaraṁ sa jananivahaṁ nirīkṣya bhūdharōpari vrajitvā samupavivēśa| ");
INSERT INTO saniso_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","tadānīṁ śiṣyēṣu tasya samīpamāgatēṣu tēna tēbhya ēṣā kathā kathyāñcakrē| ");
INSERT INTO saniso_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","abhimānahīnā janā dhanyāḥ, yatastē svargīyarājyam adhikariṣyanti| ");
INSERT INTO saniso_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","khidyamānā manujā dhanyāḥ, yasmāt tē sāntvanāṁ prāpsanti| ");
INSERT INTO saniso_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","namrā mānavāśca dhanyāḥ, yasmāt tē mēdinīm adhikariṣyanti| ");
INSERT INTO saniso_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","dharmmāya bubhukṣitāḥ tr̥ṣārttāśca manujā dhanyāḥ, yasmāt tē paritarpsyanti| ");
INSERT INTO saniso_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","kr̥pālavō mānavā dhanyāḥ, yasmāt tē kr̥pāṁ prāpsyanti| ");
INSERT INTO saniso_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","nirmmalahr̥dayā manujāśca dhanyāḥ, yasmāt ta īścaraṁ drakṣyanti| ");
INSERT INTO saniso_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","mēlayitārō mānavā dhanyāḥ, yasmāt ta īścarasya santānatvēna vikhyāsyanti| ");
INSERT INTO saniso_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","dharmmakāraṇāt tāḍitā manujā dhanyā, yasmāt svargīyarājyē tēṣāmadhikarō vidyatē| ");
INSERT INTO saniso_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","yadā manujā mama nāmakr̥tē yuṣmān nindanti tāḍayanti mr̥ṣā nānādurvvākyāni vadanti ca, tadā yuyaṁ dhanyāḥ| ");
INSERT INTO saniso_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","tadā ānandata, tathā bhr̥śaṁ hlādadhvañca, yataḥ svargē bhūyāṁsi phalāni lapsyadhvē; tē yuṣmākaṁ purātanān bhaviṣyadvādinō'pi tādr̥g atāḍayan| ");
INSERT INTO saniso_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","yuyaṁ mēdinyāṁ lavaṇarūpāḥ, kintu yadi lavaṇasya lavaṇatvam apayāti, tarhi tat kēna prakārēṇa svāduyuktaṁ bhaviṣyati? tat kasyāpi kāryyasyāyōgyatvāt kēvalaṁ bahiḥ prakṣēptuṁ narāṇāṁ padatalēna dalayituñca yōgyaṁ bhavati| ");
INSERT INTO saniso_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","yūyaṁ jagati dīptirūpāḥ, bhūdharōpari sthitaṁ nagaraṁ guptaṁ bhavituṁ nahi śakṣyati| ");
INSERT INTO saniso_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","aparaṁ manujāḥ pradīpān prajvālya drōṇādhō na sthāpayanti, kintu dīpādhārōparyyēva sthāpayanti, tēna tē dīpā gēhasthitān sakalān prakāśayanti| ");
INSERT INTO saniso_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","yēna mānavā yuṣmākaṁ satkarmmāṇi vilōkya yuṣmākaṁ svargasthaṁ pitaraṁ dhanyaṁ vadanti, tēṣāṁ samakṣaṁ yuṣmākaṁ dīptistādr̥k prakāśatām| ");
INSERT INTO saniso_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","ahaṁ vyavasthāṁ bhaviṣyadvākyañca lōptum āgatavān, itthaṁ mānubhavata, tē dvē lōptuṁ nāgatavān, kintu saphalē karttum āgatōsmi| ");
INSERT INTO saniso_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","aparaṁ yuṣmān ahaṁ tathyaṁ vadāmi yāvat vyōmamēdinyō rdhvaṁsō na bhaviṣyati, tāvat sarvvasmin saphalē na jātē vyavasthāyā ēkā mātrā bindurēkōpi vā na lōpsyatē| ");
INSERT INTO saniso_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","tasmāt yō jana ētāsām ājñānām atikṣudrām ēkājñāmapī laṁghatē manujāṁñca tathaiva śikṣayati, sa svargīyarājyē sarvvēbhyaḥ kṣudratvēna vikhyāsyatē, kintu yō janastāṁ pālayati, tathaiva śikṣayati ca, sa svargīyarājyē pradhānatvēna vikhyāsyatē| ");
INSERT INTO saniso_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","aparaṁ yuṣmān ahaṁ vadāmi, adhyāpakaphirūśimānavānāṁ dharmmānuṣṭhānāt yuṣmākaṁ dharmmānuṣṭhānē nōttamē jātē yūyam īśvarīyarājyaṁ pravēṣṭuṁ na śakṣyatha| ");
INSERT INTO saniso_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","aparañca tvaṁ naraṁ mā vadhīḥ, yasmāt yō naraṁ hanti, sa vicārasabhāyāṁ daṇḍārhō bhaviṣyati, pūrvvakālīnajanēbhya iti kathitamāsīt, yuṣmābhiraśrāvi| ");
INSERT INTO saniso_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","kintvahaṁ yuṣmān vadāmi, yaḥ kaścit kāraṇaṁ vinā nijabhrātrē kupyati, sa vicārasabhāyāṁ daṇḍārhō bhaviṣyati; yaḥ kaścicca svīyasahajaṁ nirbbōdhaṁ vadati, sa mahāsabhāyāṁ daṇḍārhō bhaviṣyati; punaśca tvaṁ mūḍha iti vākyaṁ yadi kaścit svīyabhrātaraṁ vakti, tarhi narakāgnau sa daṇḍārhō bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","atō vēdyāḥ samīpaṁ nijanaivēdyē samānītē'pi nijabhrātaraṁ prati kasmāccit kāraṇāt tvaṁ yadi dōṣī vidyasē, tadānīṁ tava tasya smr̥ti rjāyatē ca, ");
INSERT INTO saniso_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tarhi tasyā vēdyāḥ samīpē nijanaivaidyaṁ nidhāya tadaiva gatvā pūrvvaṁ tēna sārddhaṁ mila, paścāt āgatya nijanaivēdyaṁ nivēdaya| ");
INSERT INTO saniso_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","anyañca yāvat vivādinā sārddhaṁ vartmani tiṣṭhasi, tāvat tēna sārddhaṁ mēlanaṁ kuru; nō cēt vivādī vicārayituḥ samīpē tvāṁ samarpayati vicārayitā ca rakṣiṇaḥ sannidhau samarpayati tadā tvaṁ kārāyāṁ badhyēthāḥ| ");
INSERT INTO saniso_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","tarhi tvāmahaṁ taththaṁ bravīmi, śēṣakapardakē'pi na pariśōdhitē tasmāt sthānāt kadāpi bahirāgantuṁ na śakṣyasi| ");
INSERT INTO saniso_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","aparaṁ tvaṁ mā vyabhicara, yadētad vacanaṁ pūrvvakālīnalōkēbhyaḥ kathitamāsīt, tad yūyaṁ śrutavantaḥ; ");
INSERT INTO saniso_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","kintvahaṁ yuṣmān vadāmi, yadi kaścit kāmataḥ kāñcana yōṣitaṁ paśyati, tarhi sa manasā tadaiva vyabhicaritavān| ");
INSERT INTO saniso_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","tasmāt tava dakṣiṇaṁ nētraṁ yadi tvāṁ bādhatē, tarhi tannētram utpāṭya dūrē nikṣipa, yasmāt tava sarvvavapuṣō narakē nikṣēpāt tavaikāṅgasya nāśō varaṁ| ");
INSERT INTO saniso_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","yadvā tava dakṣiṇaḥ karō yadi tvāṁ bādhatē, tarhi taṁ karaṁ chittvā dūrē nikṣipa, yataḥ sarvvavapuṣō narakē nikṣēpāt ēkāṅgasya nāśō varaṁ| ");
INSERT INTO saniso_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","uktamāstē, yadi kaścin nijajāyāṁ parityakttum icchati, tarhi sa tasyai tyāgapatraṁ dadātu| ");
INSERT INTO saniso_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","kintvahaṁ yuṣmān vyāharāmi, vyabhicāradōṣē na jātē yadi kaścin nijajāyāṁ parityajati, tarhi sa tāṁ vyabhicārayati; yaśca tāṁ tyaktāṁ striyaṁ vivahati, sōpi vyabhicarati| ");
INSERT INTO saniso_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","punaśca tvaṁ mr̥ṣā śapatham na kurvvan īścarāya nijaśapathaṁ pālaya, pūrvvakālīnalōkēbhyō yaiṣā kathā kathitā, tāmapi yūyaṁ śrutavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","kintvahaṁ yuṣmān vadāmi, kamapi śapathaṁ mā kārṣṭa, arthataḥ svarganāmnā na, yataḥ sa īśvarasya siṁhāsanaṁ; ");
INSERT INTO saniso_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","pr̥thivyā nāmnāpi na, yataḥ sā tasya pādapīṭhaṁ; yirūśālamō nāmnāpi na, yataḥ sā mahārājasya purī; ");
INSERT INTO saniso_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","nijaśirōnāmnāpi na, yasmāt tasyaikaṁ kacamapi sitam asitaṁ vā karttuṁ tvayā na śakyatē| ");
INSERT INTO saniso_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","aparaṁ yūyaṁ saṁlāpasamayē kēvalaṁ bhavatīti na bhavatīti ca vadata yata itō'dhikaṁ yat tat pāpātmanō jāyatē| ");
INSERT INTO saniso_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","aparaṁ lōcanasya vinimayēna lōcanaṁ dantasya vinimayēna dantaḥ pūrvvaktamidaṁ vacanañca yuṣmābhiraśrūyata| ");
INSERT INTO saniso_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","kintvahaṁ yuṣmān vadāmi yūyaṁ hiṁsakaṁ naraṁ mā vyāghātayata| kintu kēnacit tava dakṣiṇakapōlē capēṭāghātē kr̥tē taṁ prati vāmaṁ kapōlañca vyāghōṭaya| ");
INSERT INTO saniso_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","aparaṁ kēnacit tvayā sārdhdaṁ vivādaṁ kr̥tvā tava paridhēyavasanē jighr̥titē tasmāyuttarīyavasanamapi dēhi| ");
INSERT INTO saniso_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","yadi kaścit tvāṁ krōśamēkaṁ nayanārthaṁ anyāyatō dharati, tadā tēna sārdhdaṁ krōśadvayaṁ yāhi| ");
INSERT INTO saniso_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","yaśca mānavastvāṁ yācatē, tasmai dēhi, yadi kaścit tubhyaṁ dhārayitum icchati, tarhi taṁ prati parāṁmukhō mā bhūḥ| ");
INSERT INTO saniso_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","nijasamīpavasini prēma kuru, kintu śatruṁ prati dvēṣaṁ kuru, yadētat purōktaṁ vacanaṁ ētadapi yūyaṁ śrutavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","kintvahaṁ yuṣmān vadāmi, yūyaṁ ripuvvapi prēma kuruta, yē ca yuṣmān śapantē, tāna, āśiṣaṁ vadata, yē ca yuṣmān r̥ृtīyantē, tēṣāṁ maṅgalaṁ kuruta, yē ca yuṣmān nindanti, tāḍayanti ca, tēṣāṁ kr̥tē prārthayadhvaṁ| ");
INSERT INTO saniso_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","tatra yaḥ satāmasatāñcōpari prabhākaram udāyayati, tathā dhārmmikānāmadhārmmikānāñcōpari nīraṁ varṣayati tādr̥śō yō yuṣmākaṁ svargasthaḥ pitā, yūyaṁ tasyaiva santānā bhaviṣyatha| ");
INSERT INTO saniso_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","yē yuṣmāsu prēma kurvvanti, yūyaṁ yadi kēvalaṁ tēvvēva prēma kurutha, tarhi yuṣmākaṁ kiṁ phalaṁ bhaviṣyati? caṇḍālā api tādr̥śaṁ kiṁ na kurvvanti? ");
INSERT INTO saniso_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","aparaṁ yūyaṁ yadi kēvalaṁ svīyabhrātr̥tvēna namata, tarhi kiṁ mahat karmma kurutha? caṇḍālā api tādr̥śaṁ kiṁ na kurvvanti? ");
INSERT INTO saniso_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","tasmāt yuṣmākaṁ svargasthaḥ pitā yathā pūrṇō bhavati, yūyamapi tādr̥śā bhavata| ");
INSERT INTO saniso_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","sāvadhānā bhavata, manujān darśayituṁ tēṣāṁ gōcarē dharmmakarmma mā kuruta, tathā kr̥tē yuṣmākaṁ svargasthapituḥ sakāśāt kiñcana phalaṁ na prāpsyatha| ");
INSERT INTO saniso_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","tvaṁ yadā dadāsi tadā kapaṭinō janā yathā manujēbhyaḥ praśaṁsāṁ prāptuṁ bhajanabhavanē rājamārgē ca tūrīṁ vādayanti, tathā mā kuriु, ahaṁ tubhyaṁ yathārthaṁ kathayāmi, tē svakāyaṁ phalam alabhanta| ");
INSERT INTO saniso_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","kintu tvaṁ yadā dadāsi, tadā nijadakṣiṇakarō yat karōti, tad vāmakaraṁ mā jñāpaya| ");
INSERT INTO saniso_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","tēna tava dānaṁ guptaṁ bhaviṣyati yastu tava pitā guptadarśī, sa prakāśya tubhyaṁ phalaṁ dāsyati| ");
INSERT INTO saniso_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","aparaṁ yadā prārthayasē, tadā kapaṭina̮iva mā kuru, yasmāt tē bhajanabhavanē rājamārgasya kōṇē tiṣṭhantō lōkān darśayantaḥ prārthayituṁ prīyantē; ahaṁ yuṣmān tathyaṁ vadāmi, tē svakīyaphalaṁ prāpnuvan| ");
INSERT INTO saniso_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","tasmāt prārthanākālē antarāgāraṁ praviśya dvāraṁ rudvvā guptaṁ paśyatastava pituḥ samīpē prārthayasva; tēna tava yaḥ pitā guptadarśī, sa prakāśya tubhyaṁ phalaṁ dāsyatil ");
INSERT INTO saniso_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","aparaṁ prārthanākālē dēvapūjakāiva mudhā punaruktiṁ mā kuru, yasmāt tē bōdhantē, bahuvāraṁ kathāyāṁ kathitāyāṁ tēṣāṁ prārthanā grāhiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","yūyaṁ tēṣāmiva mā kuruta, yasmāt yuṣmākaṁ yad yat prayōjanaṁ yācanātaḥ prāgēva yuṣmākaṁ pitā tat jānāti| ");
INSERT INTO saniso_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","ataēva yūyama īdr̥k prārthayadhvaṁ, hē asmākaṁ svargasthapitaḥ, tava nāma pūjyaṁ bhavatu| ");
INSERT INTO saniso_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","tava rājatvaṁ bhavatu; tavēcchā svargē yathā tathaiva mēdinyāmapi saphalā bhavatu| ");
INSERT INTO saniso_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","asmākaṁ prayōjanīyam āhāram adya dēhi| ");
INSERT INTO saniso_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","vayaṁ yathā nijāparādhinaḥ kṣamāmahē, tathaivāsmākam aparādhān kṣamasva| ");
INSERT INTO saniso_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","asmān parīkṣāṁ mānaya, kintu pāpātmanō rakṣa; rājatvaṁ gauravaṁ parākramaḥ ētē sarvvē sarvvadā tava; tathāstu| ");
INSERT INTO saniso_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","yadi yūyam anyēṣām aparādhān kṣamadhvē tarhi yuṣmākaṁ svargasthapitāpi yuṣmān kṣamiṣyatē; ");
INSERT INTO saniso_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","kintu yadi yūyam anyēṣām aparādhān na kṣamadhvē, tarhi yuṣmākaṁ janakōpi yuṣmākam aparādhān na kṣamiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","aparam upavāsakālē kapaṭinō janā mānuṣān upavāsaṁ jñāpayituṁ svēṣāṁ vadanāni mlānāni kurvvanti, yūyaṁ ta̮iva viṣaṇavadanā mā bhavata; ahaṁ yuṣmān tathyaṁ vadāmi tē svakīyaphalam alabhanta| ");
INSERT INTO saniso_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","yadā tvam upavasasi, tadā yathā lōkaistvaṁ upavāsīva na dr̥śyasē, kintu tava yō'gōcaraḥ pitā tēnaiva dr̥śyasē, tatkr̥tē nijaśirasi tailaṁ marddaya vadanañca prakṣālaya; ");
INSERT INTO saniso_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","tēna tava yaḥ pitā guptadarśī sa prakāśya tubhyaṁ phalaṁ dāsyati| ");
INSERT INTO saniso_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","aparaṁ yatra sthānē kīṭāḥ kalaṅkāśca kṣayaṁ nayanti, caurāśca sandhiṁ karttayitvā cōrayituṁ śaknuvanti, tādr̥śyāṁ mēdinyāṁ svārthaṁ dhanaṁ mā saṁcinuta| ");
INSERT INTO saniso_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","kintu yatra sthānē kīṭāḥ kalaṅkāśca kṣayaṁ na nayanti, caurāśca sandhiṁ karttayitvā cōrayituṁ na śaknuvanti, tādr̥śē svargē dhanaṁ sañcinuta| ");
INSERT INTO saniso_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","yasmāt yatra sthānē yuṣmāṁka dhanaṁ tatraiva khānē yuṣmākaṁ manāṁsi| ");
INSERT INTO saniso_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","lōcanaṁ dēhasya pradīpakaṁ, tasmāt yadi tava lōcanaṁ prasannaṁ bhavati, tarhi tava kr̥tsnaṁ vapu rdīptiyuktaṁ bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","kintu lōcanē'prasannē tava kr̥tsnaṁ vapuḥ tamisrayuktaṁ bhaviṣyati| ataēva yā dīptistvayi vidyatē, sā yadi tamisrayuktā bhavati, tarhi tat tamisraṁ kiyan mahat| ");
INSERT INTO saniso_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","kōpi manujō dvau prabhū sēvituṁ na śaknōti, yasmād ēkaṁ saṁmanya tadanyaṁ na sammanyatē, yadvā ēkatra manō nidhāya tadanyam avamanyatē; tathā yūyamapīśvaraṁ lakṣmīñcētyubhē sēvituṁ na śaknutha| ");
INSERT INTO saniso_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","aparam ahaṁ yuṣmabhyaṁ tathyaṁ kathayāmi, kiṁ bhakṣiṣyāmaḥ? kiṁ pāsyāmaḥ? iti prāṇadhāraṇāya mā cintayata; kiṁ paridhāsyāmaḥ? iti kāyarakṣaṇāya na cintayata; bhakṣyāt prāṇā vasanāñca vapūṁṣi kiṁ śrēṣṭhāṇi na hi? ");
INSERT INTO saniso_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","vihāyasō vihaṅgamān vilōkayata; tai rnōpyatē na kr̥tyatē bhāṇḍāgārē na sañcīyatē'pi; tathāpi yuṣmākaṁ svargasthaḥ pitā tēbhya āhāraṁ vitarati| ");
INSERT INTO saniso_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","yūyaṁ tēbhyaḥ kiṁ śrēṣṭhā na bhavatha? yuṣmākaṁ kaścit manujaḥ cintayan nijāyuṣaḥ kṣaṇamapi varddhayituṁ śaknōti? ");
INSERT INTO saniso_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","aparaṁ vasanāya kutaścintayata? kṣētrōtpannāni puṣpāṇi kathaṁ varddhantē tadālōcayata| tāni tantūn nōtpādayanti kimapi kāryyaṁ na kurvvanti; ");
INSERT INTO saniso_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","tathāpyahaṁ yuṣmān vadāmi, sulēmān tādr̥g aiśvaryyavānapi tatpuṣpamiva vibhūṣitō nāsīt| ");
INSERT INTO saniso_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","tasmāt kṣadya vidyamānaṁ ścaḥ cullyāṁ nikṣēpsyatē tādr̥śaṁ yat kṣētrasthitaṁ kusumaṁ tat yadīścara itthaṁ bibhūṣayati, tarhi hē stōkapratyayinō yuṣmān kiṁ na paridhāpayiṣyati? ");
INSERT INTO saniso_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","tasmāt asmābhiḥ kimatsyatē? kiñca pāyiṣyatē? kiṁ vā paridhāyiṣyatē, iti na cintayata| ");
INSERT INTO saniso_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","yasmāt dēvārccakā apīti cēṣṭantē; ētēṣu dravyēṣu prayōjanamastīti yuṣmākaṁ svargasthaḥ pitā jānāti| ");
INSERT INTO saniso_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ataēva prathamata īśvarīyarājyaṁ dharmmañca cēṣṭadhvaṁ, tata ētāni vastūni yuṣmabhyaṁ pradāyiṣyantē| ");
INSERT INTO saniso_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","śvaḥ kr̥tē mā cintayata, śvaēva svayaṁ svamuddiśya cintayiṣyati; adyatanī yā cintā sādyakr̥tē pracuratarā| ");
INSERT INTO saniso_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","yathā yūyaṁ dōṣīkr̥tā na bhavatha, tatkr̥tē'nyaṁ dōṣiṇaṁ mā kuruta| ");
INSERT INTO saniso_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","yatō yādr̥śēna dōṣēṇa yūyaṁ parān dōṣiṇaḥ kurutha, tādr̥śēna dōṣēṇa yūyamapi dōṣīkr̥tā bhaviṣyatha, anyañca yēna parimāṇēna yuṣmābhiḥ parimīyatē, tēnaiva parimāṇēna yuṣmatkr̥tē parimāyiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","aparañca nijanayanē yā nāsā vidyatē, tām anālōcya tava sahajasya lōcanē yat tr̥ṇam āstē, tadēva kutō vīkṣasē? ");
INSERT INTO saniso_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","tava nijalōcanē nāsāyāṁ vidyamānāyāṁ, hē bhrātaḥ, tava nayanāt tr̥ṇaṁ bahiṣyartuṁ anujānīhi, kathāmētāṁ nijasahajāya kathaṁ kathayituṁ śaknōṣi? ");
INSERT INTO saniso_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","hē kapaṭin, ādau nijanayanāt nāsāṁ bahiṣkuru tatō nijadr̥ṣṭau suprasannāyāṁ tava bhrātr̥ rlōcanāt tr̥ṇaṁ bahiṣkartuṁ śakṣyasi| ");
INSERT INTO saniso_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","anyañca sāramēyēbhyaḥ pavitravastūni mā vitarata, varāhāṇāṁ samakṣañca muktā mā nikṣipata; nikṣēpaṇāt tē tāḥ sarvvāḥ padai rdalayiṣyanti, parāvr̥tya yuṣmānapi vidārayiṣyanti| ");
INSERT INTO saniso_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","yācadhvaṁ tatō yuṣmabhyaṁ dāyiṣyatē; mr̥gayadhvaṁ tata uddēśaṁ lapsyadhvē; dvāram āhata, tatō yuṣmatkr̥tē muktaṁ bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","yasmād yēna yācyatē, tēna labhyatē; yēna mr̥gyatē tēnōddēśaḥ prāpyatē; yēna ca dvāram āhanyatē, tatkr̥tē dvāraṁ mōcyatē| ");
INSERT INTO saniso_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","ātmajēna pūpē prārthitē tasmai pāṣāṇaṁ viśrāṇayati, ");
INSERT INTO saniso_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","mīnē yācitē ca tasmai bhujagaṁ vitarati, ētādr̥śaḥ pitā yuṣmākaṁ madhyē ka āstē? ");
INSERT INTO saniso_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","tasmād yūyam abhadrāḥ santō'pi yadi nijabālakēbhya uttamaṁ dravyaṁ dātuṁ jānītha, tarhi yuṣmākaṁ svargasthaḥ pitā svīyayācakēbhyaḥ kimuttamāni vastūni na dāsyati? ");
INSERT INTO saniso_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","yūṣmān pratītarēṣāṁ yādr̥śō vyavahārō yuṣmākaṁ priyaḥ, yūyaṁ tān prati tādr̥śānēva vyavahārān vidhatta; yasmād vyavasthābhaviṣyadvādināṁ vacanānām iti sāram| ");
INSERT INTO saniso_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","saṅkīrṇadvārēṇa praviśata; yatō narakagamanāya yad dvāraṁ tad vistīrṇaṁ yacca vartma tad br̥hat tēna bahavaḥ praviśanti| ");
INSERT INTO saniso_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","aparaṁ svargagamanāya yad dvāraṁ tat kīdr̥k saṁkīrṇaṁ| yacca vartma tat kīdr̥g durgamam| taduddēṣṭāraḥ kiyantō'lpāḥ| ");
INSERT INTO saniso_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","aparañca yē janā mēṣavēśēna yuṣmākaṁ samīpam āgacchanti, kintvantardurantā vr̥kā ētādr̥śēbhyō bhaviṣyadvādibhyaḥ sāvadhānā bhavata, yūyaṁ phalēna tān paricētuṁ śaknutha| ");
INSERT INTO saniso_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","manujāḥ kiṁ kaṇṭakinō vr̥kṣād drākṣāphalāni śr̥gālakōlitaśca uḍumbaraphalāni śātayanti? ");
INSERT INTO saniso_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","tadvad uttama ēva pādapa uttamaphalāni janayati, adhamapādapaēvādhamaphalāni janayati| ");
INSERT INTO saniso_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","kintūttamapādapaḥ kadāpyadhamaphalāni janayituṁ na śaknōti, tathādhamōpi pādapa uttamaphalāni janayituṁ na śaknōti| ");
INSERT INTO saniso_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","aparaṁ yē yē pādapā adhamaphalāni janayanti, tē kr̥ttā vahnau kṣipyantē| ");
INSERT INTO saniso_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ataēva yūyaṁ phalēna tān paricēṣyatha| ");
INSERT INTO saniso_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","yē janā māṁ prabhuṁ vadanti, tē sarvvē svargarājyaṁ pravēkṣyanti tanna, kintu yō mānavō mama svargasthasya pituriṣṭaṁ karmma karōti sa ēva pravēkṣyati| ");
INSERT INTO saniso_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","tad dinē bahavō māṁ vadiṣyanti, hē prabhō hē prabhō, tava nāmnā kimasmāmi rbhaviṣyadvākyaṁ na vyāhr̥taṁ? tava nāmnā bhūtāḥ kiṁ na tyājitāḥ? tava nāmnā kiṁ nānādbhutāni karmmāṇi na kr̥tāni? ");
INSERT INTO saniso_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","tadāhaṁ vadiṣyāmi, hē kukarmmakāriṇō yuṣmān ahaṁ na vēdmi, yūyaṁ matsamīpād dūrībhavata| ");
INSERT INTO saniso_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","yaḥ kaścit mamaitāḥ kathāḥ śrutvā pālayati, sa pāṣāṇōpari gr̥hanirmmātrā jñāninā saha mayōpamīyatē| ");
INSERT INTO saniso_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","yatō vr̥ṣṭau satyām āplāva āgatē vāyau vātē ca tēṣu tadgēhaṁ lagnēṣu pāṣāṇōpari tasya bhittēstanna patatil ");
INSERT INTO saniso_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","kintu yaḥ kaścit mamaitāḥ kathāḥ śrutvā na pālayati sa saikatē gēhanirmmātrā 'jñāninā upamīyatē| ");
INSERT INTO saniso_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","yatō jalavr̥ṣṭau satyām āplāva āgatē pavanē vātē ca tai rgr̥hē samāghātē tat patati tatpatanaṁ mahad bhavati| ");
INSERT INTO saniso_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","yīśunaitēṣu vākyēṣu samāpitēṣu mānavāstadīyōpadēśam āścaryyaṁ mēnirē| ");
INSERT INTO saniso_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","yasmāt sa upādhyāyā iva tān nōpadidēśa kintu samarthapuruṣa̮iva samupadidēśa| ");
INSERT INTO saniso_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","yadā sa parvvatād avārōhat tadā bahavō mānavāstatpaścād vavrajuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ēkaḥ kuṣṭhavān āgatya taṁ praṇamya babhāṣē, hē prabhō, yadi bhavān saṁmanyatē, tarhi māṁ nirāmayaṁ karttuṁ śaknōti| ");
INSERT INTO saniso_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","tatō yīśuḥ karaṁ prasāryya tasyāṅgaṁ spr̥śan vyājahāra, sammanyē'haṁ tvaṁ nirāmayō bhava; tēna sa tatkṣaṇāt kuṣṭhēnāmōci| ");
INSERT INTO saniso_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","tatō yīśustaṁ jagāda, avadhēhi kathāmētāṁ kaścidapi mā brūhi, kintu yājakasya sannidhiṁ gatvā svātmānaṁ darśaya manujēbhyō nijanirāmayatvaṁ pramāṇayituṁ mūsānirūpitaṁ dravyam utsr̥ja ca| ");
INSERT INTO saniso_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","tadanantaraṁ yīśunā kapharnāhūmnāmani nagarē praviṣṭē kaścit śatasēnāpatistatsamīpam āgatya vinīya babhāṣē, ");
INSERT INTO saniso_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","hē prabhō, madīya ēkō dāsaḥ pakṣāghātavyādhinā bhr̥śaṁ vyathitaḥ, satu śayanīya āstē| ");
INSERT INTO saniso_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","tadānīṁ yīśustasmai kathitavān, ahaṁ gatvā taṁ nirāmayaṁ kariṣyāmi| ");
INSERT INTO saniso_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","tataḥ sa śatasēnāpatiḥ pratyavadat, hē prabhō, bhavān yat mama gēhamadhyaṁ yāti tadyōgyabhājanaṁ nāhamasmi; vāṅmātram ādiśatu, tēnaiva mama dāsō nirāmayō bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","yatō mayi paranidhnē'pi mama nidēśavaśyāḥ kati kati sēnāḥ santi, tata ēkasmin yāhītyuktē sa yāti, tadanyasmin ēhītyuktē sa āyāti, tathā mama nijadāsē karmmaitat kurvvityuktē sa tat karōti| ");
INSERT INTO saniso_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","tadānīṁ yīśustasyaitat vacō niśamya vismayāpannō'bhūt; nijapaścādgāminō mānavān avōcca, yuṣmān tathyaṁ vacmi, isrāyēlīyalōkānāṁ madhyē'pi naitādr̥śō viśvāsō mayā prāptaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","anyaccāhaṁ yuṣmān vadāmi, bahavaḥ pūrvvasyāḥ paścimāyāśca diśa āgatya ibrāhīmā ishākā yākūbā ca sākam militvā samupavēkṣyanti; ");
INSERT INTO saniso_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","kintu yatra sthānē rōdanadantagharṣaṇē bhavatastasmin bahirbhūtatamisrē rājyasya santānā nikṣēsyantē| ");
INSERT INTO saniso_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","tataḥ paraṁ yīśustaṁ śatasēnāpatiṁ jagāda, yāhi, tava pratītyanusāratō maṅgalaṁ bhūyāt; tadā tasminnēva daṇḍē tadīyadāsō nirāmayō babhūva| ");
INSERT INTO saniso_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","anantaraṁ yīśuḥ pitarasya gēhamupasthāya jvarēṇa pīḍitāṁ śayanīyasthitāṁ tasya śvaśrūṁ vīkṣāñcakrē| ");
INSERT INTO saniso_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","tatastēna tasyāḥ karasya spr̥ṣṭatavāt jvarastāṁ tatyāja, tadā sā samutthāya tān siṣēvē| ");
INSERT INTO saniso_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","anantaraṁ sandhyāyāṁ satyāṁ bahuśō bhūtagrastamanujān tasya samīpam āninyuḥ sa ca vākyēna bhūtān tyājayāmāsa, sarvvaprakārapīḍitajanāṁśca nirāmayān cakāra; ");
INSERT INTO saniso_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","tasmāt, sarvvā durbbalatāsmākaṁ tēnaiva paridhāritā| asmākaṁ sakalaṁ vyādhiṁ saēva saṁgr̥hītavān| yadētadvacanaṁ yiśayiyabhaviṣyadvādinōktamāsīt, tattadā saphalamabhavat| ");
INSERT INTO saniso_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","anantaraṁ yīśuścaturdikṣu jananivahaṁ vilōkya taṭinyāḥ pāraṁ yātuṁ śiṣyān ādidēśa| ");
INSERT INTO saniso_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","tadānīm ēka upādhyāya āgatya kathitavān, hē gurō, bhavān yatra yāsyati tatrāhamapi bhavataḥ paścād yāsyāmi| ");
INSERT INTO saniso_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","tatō yīśu rjagāda, krōṣṭuḥ sthātuṁ sthānaṁ vidyatē, vihāyasō vihaṅgamānāṁ nīḍāni ca santi; kintu manuṣyaputrasya śiraḥ sthāpayituṁ sthānaṁ na vidyatē| ");
INSERT INTO saniso_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","anantaram apara ēkaḥ śiṣyastaṁ babhāṣē, hē prabhō, prathamatō mama pitaraṁ śmaśānē nidhātuṁ gamanārthaṁ mām anumanyasva| ");
INSERT INTO saniso_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","tatō yīśuruktavān mr̥tā mr̥tān śmaśānē nidadhatu, tvaṁ mama paścād āgaccha| ");
INSERT INTO saniso_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","anantaraṁ tasmin nāvamārūḍhē tasya śiṣyāstatpaścāt jagmuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","paścāt sāgarasya madhyaṁ tēṣu gatēṣu tādr̥śaḥ prabalō jhañbhśanila udatiṣṭhat, yēna mahātaraṅga utthāya taraṇiṁ chāditavān, kintu sa nidrita āsīt| ");
INSERT INTO saniso_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","tadā śiṣyā āgatya tasya nidrābhaṅgaṁ kr̥tvā kathayāmāsuḥ, hē prabhō, vayaṁ mriyāmahē, bhavān asmākaṁ prāṇān rakṣatu| ");
INSERT INTO saniso_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","tadā sa tān uktavān, hē alpaviśvāsinō yūyaṁ kutō vibhītha? tataḥ sa utthāya vātaṁ sāgarañca tarjayāmāsa, tatō nirvvātamabhavat| ");
INSERT INTO saniso_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","aparaṁ manujā vismayaṁ vilōkya kathayāmāsuḥ, ahō vātasaritpatī asya kimājñāgrāhiṇau? kīdr̥śō'yaṁ mānavaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","anantaraṁ sa pāraṁ gatvā gidērīyadēśam upasthitavān; tadā dvau bhūtagrastamanujau śmaśānasthānād bahi rbhūtvā taṁ sākṣāt kr̥tavantau, tāvētādr̥śau pracaṇḍāvāstāṁ yat tēna sthānēna kōpi yātuṁ nāśaknōt| ");
INSERT INTO saniso_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","tāvucaiḥ kathayāmāsatuḥ, hē īśvarasya sūnō yīśō, tvayā sākam āvayōḥ kaḥ sambandhaḥ? nirūpitakālāt prāgēva kimāvābhyāṁ yātanāṁ dātum atrāgatōsi? ");
INSERT INTO saniso_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","tadānīṁ tābhyāṁ kiñcid dūrē varāhāṇām ēkō mahāvrajō'carat| ");
INSERT INTO saniso_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","tatō bhūtau tau tasyāntikē vinīya kathayāmāsatuḥ, yadyāvāṁ tyājayasi, tarhi varāhāṇāṁ madhyēvrajam āvāṁ prēraya| ");
INSERT INTO saniso_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","tadā yīśuravadat yātaṁ, anantaraṁ tau yadā manujau vihāya varāhān āśritavantau, tadā tē sarvvē varāhā uccasthānāt mahājavēna dhāvantaḥ sāgarīyatōyē majjantō mamruḥ| ");
INSERT INTO saniso_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","tatō varāharakṣakāḥ palāyamānā madhyēnagaraṁ tau bhūtagrastau prati yadyad aghaṭata, tāḥ sarvvavārttā avadan| ");
INSERT INTO saniso_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","tatō nāgarikāḥ sarvvē manujā yīśuṁ sākṣāt karttuṁ bahirāyātāḥ tañca vilōkya prārthayāñcakrirē bhavān asmākaṁ sīmātō yātu| ");
INSERT INTO saniso_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","anantaraṁ yīśu rnaukāmāruhya punaḥ pāramāgatya nijagrāmam āyayau| ");
INSERT INTO saniso_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","tataḥ katipayā janā ēkaṁ pakṣāghātinaṁ svaṭṭōpari śāyayitvā tatsamīpam ānayan; tatō yīśustēṣāṁ pratītiṁ vijñāya taṁ pakṣāghātinaṁ jagāda, hē putra, susthirō bhava, tava kaluṣasya marṣaṇaṁ jātam| ");
INSERT INTO saniso_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","tāṁ kathāṁ niśamya kiyanta upādhyāyā manaḥsu cintitavanta ēṣa manuja īśvaraṁ nindati| ");
INSERT INTO saniso_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","tataḥ sa tēṣām ētādr̥śīṁ cintāṁ vijñāya kathitavān, yūyaṁ manaḥsu kr̥ta ētādr̥śīṁ kucintāṁ kurutha? ");
INSERT INTO saniso_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","tava pāpamarṣaṇaṁ jātaṁ, yadvā tvamutthāya gaccha, dvayōranayō rvākyayōḥ kiṁ vākyaṁ vaktuṁ sugamaṁ? ");
INSERT INTO saniso_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","kintu mēdinyāṁ kaluṣaṁ kṣamituṁ manujasutasya sāmarthyamastīti yūyaṁ yathā jānītha, tadarthaṁ sa taṁ pakṣāghātinaṁ gaditavān, uttiṣṭha, nijaśayanīyaṁ ādāya gēhaṁ gaccha| ");
INSERT INTO saniso_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","tataḥ sa tatkṣaṇād utthāya nijagēhaṁ prasthitavān| ");
INSERT INTO saniso_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","mānavā itthaṁ vilōkya vismayaṁ mēnirē, īśvarēṇa mānavāya sāmarthyam īdr̥śaṁ dattaṁ iti kāraṇāt taṁ dhanyaṁ babhāṣirē ca| ");
INSERT INTO saniso_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","anantaraṁ yīśustatsthānād gacchan gacchan karasaṁgrahasthānē samupaviṣṭaṁ mathināmānam ēkaṁ manujaṁ vilōkya taṁ babhāṣē, mama paścād āgaccha, tataḥ sa utthāya tasya paścād vavrāja| ");
INSERT INTO saniso_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","tataḥ paraṁ yīśau gr̥hē bhōktum upaviṣṭē bahavaḥ karasaṁgrāhiṇaḥ kaluṣiṇaśca mānavā āgatya tēna sākaṁ tasya śiṣyaiśca sākam upaviviśuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","phirūśinastad dr̥ṣṭvā tasya śiṣyān babhāṣirē, yuṣmākaṁ guruḥ kiṁ nimittaṁ karasaṁgrāhibhiḥ kaluṣibhiśca sākaṁ bhuṁktē? ");
INSERT INTO saniso_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","yīśustat śrutvā tān pratyavadat, nirāmayalōkānāṁ cikitsakēna prayōjanaṁ nāsti, kintu sāmayalōkānāṁ prayōjanamāstē| ");
INSERT INTO saniso_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","atō yūyaṁ yātvā vacanasyāsyārthaṁ śikṣadhvam, dayāyāṁ mē yathā prīti rna tathā yajñakarmmaṇi|yatō'haṁ dhārmmikān āhvātuṁ nāgatō'smi kintu manaḥ parivarttayituṁ pāpina āhvātum āgatō'smi| ");
INSERT INTO saniso_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","anantaraṁ yōhanaḥ śiṣyāstasya samīpam āgatya kathayāmāsuḥ, phirūśinō vayañca punaḥ punarupavasāmaḥ, kintu tava śiṣyā nōpavasanti, kutaḥ? ");
INSERT INTO saniso_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","tadā yīśustān avōcat yāvat sakhīnāṁ saṁṅgē kanyāyā varastiṣṭhati, tāvat kiṁ tē vilāpaṁ karttuṁ śakluvanti? kintu yadā tēṣāṁ saṁṅgād varaṁ nayanti, tādr̥śaḥ samaya āgamiṣyati, tadā tē upavatsyanti| ");
INSERT INTO saniso_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","purātanavasanē kōpi navīnavastraṁ na yōjayati, yasmāt tēna yōjitēna purātanavasanaṁ chinatti tacchidrañca bahukutsitaṁ dr̥śyatē| ");
INSERT INTO saniso_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","anyañca purātanakutvāṁ kōpi navānagōstanīrasaṁ na nidadhāti, yasmāt tathā kr̥tē kutū rvidīryyatē tēna gōstanīrasaḥ patati kutūśca naśyati; tasmāt navīnāyāṁ kutvāṁ navīnō gōstanīrasaḥ sthāpyatē, tēna dvayōravanaṁ bhavati| ");
INSERT INTO saniso_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","aparaṁ tēnaitatkathākathanakālē ēkō'dhipatistaṁ praṇamya babhāṣē, mama duhitā prāyēṇaitāvatkālē mr̥tā, tasmād bhavānāgatya tasyā gātrē hastamarpayatu, tēna sā jīviṣyati| ");
INSERT INTO saniso_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","tadānīṁ yīśuḥ śiṣyaiḥ sākam utthāya tasya paścād vavrāja| ");
INSERT INTO saniso_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ityanantarē dvādaśavatsarān yāvat pradarāmayēna śīrṇaikā nārī tasya paścād āgatya tasya vasanasya granthiṁ pasparśa; ");
INSERT INTO saniso_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","yasmāt mayā kēvalaṁ tasya vasanaṁ spr̥ṣṭvā svāsthyaṁ prāpsyatē, sā nārīti manasi niścitavatī| ");
INSERT INTO saniso_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","tatō yīśurvadanaṁ parāvarttya tāṁ jagāda, hē kanyē, tvaṁ susthirā bhava, tava viśvāsastvāṁ svasthāmakārṣīt| ētadvākyē gaditaēva sā yōṣit svasthābhūt| ");
INSERT INTO saniso_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","aparaṁ yīśustasyādhyakṣasya gēhaṁ gatvā vādakaprabhr̥tīn bahūn lōkān śabdāyamānān vilōkya tān avadat, ");
INSERT INTO saniso_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","panthānaṁ tyaja, kanyēyaṁ nāmriyata nidritāstē; kathāmētāṁ śrutvā tē tamupajahasuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","kintu sarvvēṣu bahiṣkr̥tēṣu sō'bhyantaraṁ gatvā kanyāyāḥ karaṁ dhr̥tavān, tēna sōdatiṣṭhat; ");
INSERT INTO saniso_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","tatastatkarmmaṇō yaśaḥ kr̥tsnaṁ taṁ dēśaṁ vyāptavat| ");
INSERT INTO saniso_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","tataḥ paraṁ yīśustasmāt sthānād yātrāṁ cakāra; tadā hē dāyūdaḥ santāna, asmān dayasva, iti vadantau dvau janāvandhau prōcairāhūyantau tatpaścād vavrajatuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","tatō yīśau gēhamadhyaṁ praviṣṭaṁ tāvapi tasya samīpam upasthitavantau, tadānīṁ sa tau pr̥ṣṭavān karmmaitat karttuṁ mama sāmarthyam āstē, yuvāṁ kimiti pratīthaḥ? tadā tau pratyūcatuḥ, satyaṁ prabhō| ");
INSERT INTO saniso_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","tadānīṁ sa tayō rlōcanāni spr̥śan babhāṣē, yuvayōḥ pratītyanusārād yuvayō rmaṅgalaṁ bhūyāt| tēna tatkṣaṇāt tayō rnētrāṇi prasannānyabhavan, ");
INSERT INTO saniso_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","paścād yīśustau dr̥ḍhamājñāpya jagāda, avadhattam ētāṁ kathāṁ kōpi manujō ma jānīyāt| ");
INSERT INTO saniso_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","kintu tau prasthāya tasmin kr̥tsnē dēśē tasya kīrttiṁ prakāśayāmāsatuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","aparaṁ tau bahiryāta ētasminnantarē manujā ēkaṁ bhūtagrastamūkaṁ tasya samīpam ānītavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","tēna bhūtē tyājitē sa mūkaḥ kathāṁ kathayituṁ prārabhata, tēna janā vismayaṁ vijñāya kathayāmāsuḥ, isrāyēlō vaṁśē kadāpi nēdr̥gadr̥śyata; ");
INSERT INTO saniso_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","kintu phirūśinaḥ kathayāñcakruḥ bhūtādhipatinā sa bhūtān tyājayati| ");
INSERT INTO saniso_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","tataḥ paraṁ yīśustēṣāṁ bhajanabhavana upadiśan rājyasya susaṁvādaṁ pracārayan lōkānāṁ yasya ya āmayō yā ca pīḍāsīt, tān śamayan śamayaṁśca sarvvāṇi nagarāṇi grāmāṁśca babhrāma| ");
INSERT INTO saniso_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","anyañca manujān vyākulān arakṣakamēṣāniva ca tyaktān nirīkṣya tēṣu kāruṇikaḥ san śiṣyān avadat, ");
INSERT INTO saniso_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","śasyāni pracurāṇi santi, kintu chēttāraḥ stōkāḥ| ");
INSERT INTO saniso_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","kṣētraṁ pratyaparān chēdakān prahētuṁ śasyasvāminaṁ prārthayadhvam| ");
INSERT INTO saniso_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","anantaraṁ yīśu rdvādaśaśiṣyān āhūyāmēdhyabhūtān tyājayituṁ sarvvaprakārarōgān pīḍāśca śamayituṁ tēbhyaḥ sāmarthyamadāt| ");
INSERT INTO saniso_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","tēṣāṁ dvādaśaprēṣyāṇāṁ nāmānyētāni| prathamaṁ śimōn yaṁ pitaraṁ vadanti, tataḥ paraṁ tasya sahaja āndriyaḥ, sivadiyasya putrō yākūb ");
INSERT INTO saniso_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","tasya sahajō yōhan; philip barthalamay thōmāḥ karasaṁgrāhī mathiḥ, ālphēyaputrō yākūb, ");
INSERT INTO saniso_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","kinānīyaḥ śimōn, ya īṣkariyōtīyayihūdāḥ khrīṣṭaṁ parakarē'rpayat| ");
INSERT INTO saniso_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ētān dvādaśaśiṣyān yīśuḥ prēṣayan ityājñāpayat, yūyam anyadēśīyānāṁ padavīṁ śēmirōṇīyānāṁ kimapi nagarañca na praviśyē ");
INSERT INTO saniso_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","isrāyēlgōtrasya hāritā yē yē mēṣāstēṣāmēva samīpaṁ yāta| ");
INSERT INTO saniso_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","gatvā gatvā svargasya rājatvaṁ savidhamabhavat, ētāṁ kathāṁ pracārayata| ");
INSERT INTO saniso_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","āmayagrastān svasthān kuruta, kuṣṭhinaḥ pariṣkuruta, mr̥talōkān jīvayata, bhūtān tyājayata, vinā mūlyaṁ yūyam alabhadhvaṁ vinaiva mūlyaṁ viśrāṇayata| ");
INSERT INTO saniso_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","kintu svēṣāṁ kaṭibandhēṣu svarṇarūpyatāmrāṇāṁ kimapi na gr̥hlīta| ");
INSERT INTO saniso_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","anyacca yātrāyai cēlasampuṭaṁ vā dvitīyavasanaṁ vā pādukē vā yaṣṭiḥ, ētān mā gr̥hlīta, yataḥ kāryyakr̥t bharttuṁ yōgyō bhavati| ");
INSERT INTO saniso_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","aparaṁ yūyaṁ yat puraṁ yañca grāmaṁ praviśatha, tatra yō janō yōgyapātraṁ tamavagatya yānakālaṁ yāvat tatra tiṣṭhata| ");
INSERT INTO saniso_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","yadā yūyaṁ tadgēhaṁ praviśatha, tadā tamāśiṣaṁ vadata| ");
INSERT INTO saniso_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","yadi sa yōgyapātraṁ bhavati, tarhi tatkalyāṇaṁ tasmai bhaviṣyati, nōcēt sāśīryuṣmabhyamēva bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","kintu yē janā yuṣmākamātithyaṁ na vidadhati yuṣmākaṁ kathāñca na śr̥ṇvanti tēṣāṁ gēhāt purādvā prasthānakālē svapadūlīḥ pātayata| ");
INSERT INTO saniso_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","yuṣmānahaṁ tathyaṁ vacmi vicāradinē tatpurasya daśātaḥ sidōmamōrāpurayōrdaśā sahyatarā bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","paśyata, vr̥kayūthamadhyē mēṣaḥ yathāvistathā yuṣmāna prahiṇōmi, tasmād yūyam ahiriva satarkāḥ kapōtāivāhiṁsakā bhavata| ");
INSERT INTO saniso_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","nr̥bhyaḥ sāvadhānā bhavata; yatastai ryūyaṁ rājasaṁsadi samarpiṣyadhvē tēṣāṁ bhajanagēhē prahāriṣyadhvē| ");
INSERT INTO saniso_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","yūyaṁ mannāmahētōḥ śāstr̥ṇāṁ rājñāñca samakṣaṁ tānanyadēśinaścādhi sākṣitvārthamānēṣyadhvē| ");
INSERT INTO saniso_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","kintvitthaṁ samarpitā yūyaṁ kathaṁ kimuttaraṁ vakṣyatha tatra mā cintayata, yatastadā yuṣmābhi ryad vaktavyaṁ tat taddaṇḍē yuṣmanmanaḥ su samupasthāsyati| ");
INSERT INTO saniso_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","yasmāt tadā yō vakṣyati sa na yūyaṁ kintu yuṣmākamantarasthaḥ pitrātmā| ");
INSERT INTO saniso_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","sahajaḥ sahajaṁ tātaḥ sutañca mr̥tau samarpayiṣyati, apatyāgi svasvapitrōे rvipakṣībhūya tau ghātayiṣyanti| ");
INSERT INTO saniso_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","mannamahētōḥ sarvvē janā yuṣmān r̥ृtīyiṣyantē, kintu yaḥ śēṣaṁ yāvad dhairyyaṁ ghr̥tvā sthāsyati, sa trāyiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","tai ryadā yūyamēkapurē tāḍiṣyadhvē, tadā yūyamanyapuraṁ palāyadhvaṁ yuṣmānahaṁ tathyaṁ vacmi yāvanmanujasutō naiti tāvad isrāyēldēśīyasarvvanagarabhramaṇaṁ samāpayituṁ na śakṣyatha| ");
INSERT INTO saniso_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","gurōḥ śiṣyō na mahān, prabhōrdāsō na mahān| ");
INSERT INTO saniso_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","yadi śiṣyō nijagurō rdāsaśca svaprabhōḥ samānō bhavati tarhi tad yathēṣṭaṁ| cēttairgr̥hapatirbhūtarāja ucyatē, tarhi parivārāḥ kiṁ tathā na vakṣyantē? ");
INSERT INTO saniso_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","kintu tēbhyō yūyaṁ mā bibhīta, yatō yanna prakāśiṣyatē, tādr̥k chāditaṁ kimapi nāsti, yacca na vyañciṣyatē, tādr̥g guptaṁ kimapi nāsti| ");
INSERT INTO saniso_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","yadahaṁ yuṣmān tamasi vacmi tad yuṣmābhirdīptau kathyatāṁ; karṇābhyāṁ yat śrūyatē tad gēhōpari pracāryyatāṁ| ");
INSERT INTO saniso_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","yē kāyaṁ hantuṁ śaknuvanti nātmānaṁ, tēbhyō mā bhaiṣṭa; yaḥ kāyātmānau nirayē nāśayituṁ, śaknōti, tatō bibhīta| ");
INSERT INTO saniso_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","dvau caṭakau kimēkatāmramudrayā na vikrīyētē? tathāpi yuṣmattātānumatiṁ vinā tēṣāmēkōpi bhuvi na patati| ");
INSERT INTO saniso_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","yuṣmacchirasāṁ sarvvakacā gaṇitāṁḥ santi| ");
INSERT INTO saniso_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","atō mā bibhīta, yūyaṁ bahucaṭakēbhyō bahumūlyāḥ| ");
INSERT INTO saniso_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","yō manujasākṣānmāmaṅgīkurutē tamahaṁ svargasthatātasākṣādaṅgīkariṣyē| ");
INSERT INTO saniso_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","pr̥thvyāmahaṁ śāntiṁ dātumāgata̮iti mānubhavata, śāntiṁ dātuṁ na kintvasiṁ| ");
INSERT INTO saniso_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","pitr̥mātr̥ścaśrūbhiḥ sākaṁ sutasutābadhū rvirōdhayituñcāgatēाsmi| ");
INSERT INTO saniso_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","tataḥ svasvaparivāraēva nr̥śatru rbhavitā| ");
INSERT INTO saniso_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","yaḥ pitari mātari vā mattōdhikaṁ prīyatē, sa na madarhaḥ; ");
INSERT INTO saniso_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","yaśca sutē sutāyāṁ vā mattōdhikaṁ prīyatē, sēाpi na madarhaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","yaḥ svakruśaṁ gr̥hlan matpaścānnaiti, sēाpi na madarhaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","yaḥ svaprāṇānavati, sa tān hārayiṣyatē, yastu matkr̥tē svaprāṇān hārayati, sa tānavati| ");
INSERT INTO saniso_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","yō yuṣmākamātithyaṁ vidadhāti, sa mamātithyaṁ vidadhāti, yaśca mamātithyaṁ vidadhāti, sa matprērakasyātithyaṁ vidadhāti| ");
INSERT INTO saniso_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","yō bhaviṣyadvādīti jñātvā tasyātithyaṁ vidhattē, sa bhaviṣyadvādinaḥ phalaṁ lapsyatē, yaśca dhārmmika iti viditvā tasyātithyaṁ vidhattē sa dhārmmikamānavasya phalaṁ prāpsyati| ");
INSERT INTO saniso_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","yaśca kaścit ētēṣāṁ kṣudranarāṇām yaṁ kañcanaikaṁ śiṣya iti viditvā kaṁsaikaṁ śītalasalilaṁ tasmai dattē, yuṣmānahaṁ tathyaṁ vadāmi, sa kēnāpi prakārēṇa phalēna na vañciṣyatē| ");
INSERT INTO saniso_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","itthaṁ yīśuḥ svadvādaśaśiṣyāṇāmājñāpanaṁ samāpya purē pura upadēṣṭuṁ susaṁvādaṁ pracārayituṁ tatsthānāt pratasthē| ");
INSERT INTO saniso_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","anantaraṁ yōhan kārāyāṁ tiṣṭhan khriṣṭasya karmmaṇāṁ vārttaṁ prāpya yasyāgamanavārttāsīt saēva kiṁ tvaṁ? vā vayamanyam apēkṣiṣyāmahē? ");
INSERT INTO saniso_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ētat praṣṭuṁ nijau dvau śiṣyau prāhiṇōt| ");
INSERT INTO saniso_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","yīśuḥ pratyavōcat, andhā nētrāṇi labhantē, khañcā gacchanti, kuṣṭhinaḥ svasthā bhavanti, badhirāḥ śr̥ṇvanti, mr̥tā jīvanta uttiṣṭhanti, daridrāṇāṁ samīpē susaṁvādaḥ pracāryyata, ");
INSERT INTO saniso_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ētāni yadyad yuvāṁ śr̥ṇuthaḥ paśyathaśca gatvā tadvārttāṁ yōhanaṁ gadataṁ| ");
INSERT INTO saniso_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","yasyāhaṁ na vighnībhavāmi, saēva dhanyaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","anantaraṁ tayōḥ prasthitayō ryīśu ryōhanam uddiśya janān jagāda, yūyaṁ kiṁ draṣṭuṁ vahirmadhyēprāntaram agacchata? kiṁ vātēna kampitaṁ nalaṁ? ");
INSERT INTO saniso_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","vā kiṁ vīkṣituṁ vahirgatavantaḥ? kiṁ parihitasūkṣmavasanaṁ manujamēkaṁ? paśyata, yē sūkṣmavasanāni paridadhati, tē rājadhānyāṁ tiṣṭhanti| ");
INSERT INTO saniso_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","tarhi yūyaṁ kiṁ draṣṭuṁ bahiragamata, kimēkaṁ bhaviṣyadvādinaṁ? tadēva satyaṁ| yuṣmānahaṁ vadāmi, sa bhaviṣyadvādinōpi mahān; ");
INSERT INTO saniso_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","yataḥ, paśya svakīyadūtōyaṁ tvadagrē prēṣyatē mayā| sa gatvā tava panthānaṁ smayak pariṣkariṣyati|| ētadvacanaṁ yamadhi likhitamāstē sō'yaṁ yōhan| ");
INSERT INTO saniso_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","aparaṁ yuṣmānahaṁ tathyaṁ bravīmi, majjayitu ryōhanaḥ śrēṣṭhaḥ kōpi nārītō nājāyata; tathāpi svargarājyamadhyē sarvvēbhyō yaḥ kṣudraḥ sa yōhanaḥ śrēṣṭhaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","aparañca ā yōhanō'dya yāvat svargarājyaṁ balādākrāntaṁ bhavati ākraminaśca janā balēna tadadhikurvvanti| ");
INSERT INTO saniso_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","yatō yōhanaṁ yāvat sarvvabhaviṣyadvādibhi rvyavasthayā ca upadēśaḥ prākāśyata| ");
INSERT INTO saniso_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","yadi yūyamidaṁ vākyaṁ grahītuṁ śaknutha, tarhi śrēyaḥ, yasyāgamanasya vacanamāstē sō'yam ēliyaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","yasya śrōtuṁ karṇau staḥ sa śr̥ṇōtu| ");
INSERT INTO saniso_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","ētē vidyamānajanāḥ kai rmayōpamīyantē? yē bālakā haṭṭa upaviśya svaṁ svaṁ bandhumāhūya vadanti, ");
INSERT INTO saniso_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","vayaṁ yuṣmākaṁ samīpē vaṁśīravādayāma, kintu yūyaṁ nānr̥tyata; yuṣmākaṁ samīpē ca vayamarōdima, kintu yūyaṁ na vyalapata, tādr̥śai rbālakaista upamāyiṣyantē| ");
INSERT INTO saniso_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","yatō yōhan āgatya na bhuktavān na pītavāṁśca, tēna lōkā vadanti, sa bhūtagrasta iti| ");
INSERT INTO saniso_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","manujasuta āgatya bhuktavān pītavāṁśca, tēna lōkā vadanti, paśyata ēṣa bhōktā madyapātā caṇḍālapāpināṁ bandhaśca, kintu jñāninō jñānavyavahāraṁ nirdōṣaṁ jānanti| ");
INSERT INTO saniso_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","sa yatra yatra purē bahvāścaryyaṁ karmma kr̥tavān, tannivāsināṁ manaḥparāvr̥ttyabhāvāt tāni nagarāṇi prati hantētyuktā kathitavān, ");
INSERT INTO saniso_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","hā kōrāsīn, hā baitsaidē, yuṣmanmadhyē yadyadāścaryyaṁ karmma kr̥taṁ yadi tat sōrasīdōnnagara akāriṣyata, tarhi pūrvvamēva tannivāsinaḥ śāṇavasanē bhasmani cōpaviśantō manāṁsi parāvarttiṣyanta| ");
INSERT INTO saniso_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","tasmādahaṁ yuṣmān vadāmi, vicāradinē yuṣmākaṁ daśātaḥ sōrasīdōnō rdaśā sahyatarā bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","aparañca bata kapharnāhūm, tvaṁ svargaṁ yāvadunnatōsi, kintu narakē nikṣēpsyasē, yasmāt tvayi yānyāścaryyāṇi karmmaṇyakāriṣata, yadi tāni sidōmnagara akāriṣyanta, tarhi tadadya yāvadasthāsyat| ");
INSERT INTO saniso_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","kintvahaṁ yuṣmān vadāmi, vicāradinē tava daṇḍataḥ sidōmō daṇḍō sahyatarō bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ētasminnēva samayē yīśuḥ punaruvāca, hē svargapr̥thivyōrēkādhipatē pitastvaṁ jñānavatō viduṣaśca lōkān pratyētāni na prakāśya bālakān prati prakāśitavān, iti hētōstvāṁ dhanyaṁ vadāmi| ");
INSERT INTO saniso_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","hē pitaḥ, itthaṁ bhavēt yata idaṁ tvadr̥ṣṭāvuttamaṁ| ");
INSERT INTO saniso_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","pitrā mayi sarvvāṇi samarpitāni, pitaraṁ vinā kōpi putraṁ na jānāti, yān prati putrēṇa pitā prakāśyatē tān vinā putrād anyaḥ kōpi pitaraṁ na jānāti| ");
INSERT INTO saniso_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","hē pariśrāntā bhārākrāntāśca lōkā yūyaṁ matsannidhim āgacchata, ahaṁ yuṣmān viśramayiṣyāmi| ");
INSERT INTO saniso_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ahaṁ kṣamaṇaśīlō namramanāśca, tasmāt mama yugaṁ svēṣāmupari dhārayata mattaḥ śikṣadhvañca, tēna yūyaṁ svē svē manasi viśrāmaṁ lapsyadhbē| ");
INSERT INTO saniso_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","yatō mama yugam anāyāsaṁ mama bhāraśca laghuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","anantaraṁ yīśu rviśrāmavārē śsyamadhyēna gacchati, tadā tacchiṣyā bubhukṣitāḥ santaḥ śsyamañjarīśchatvā chitvā khāditumārabhanta| ");
INSERT INTO saniso_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","tad vilōkya phirūśinō yīśuṁ jagaduḥ, paśya viśrāmavārē yat karmmākarttavyaṁ tadēva tava śiṣyāḥ kurvvanti| ");
INSERT INTO saniso_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","sa tān pratyāvadata, dāyūd tatsaṅginaśca bubhukṣitāḥ santō yat karmmākurvvan tat kiṁ yuṣmābhi rnāpāṭhi? ");
INSERT INTO saniso_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","yē darśanīyāḥ pūpāḥ yājakān vinā tasya tatsaṅgimanujānāñcābhōjanīyāsta īśvarāvāsaṁ praviṣṭēna tēna bhuktāḥ| ");
INSERT INTO saniso_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","anyacca viśrāmavārē madhyēmandiraṁ viśrāmavārīyaṁ niyamaṁ laṅvantōpi yājakā nirdōṣā bhavanti, śāstramadhyē kimidamapi yuṣmābhi rna paṭhitaṁ? ");
INSERT INTO saniso_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","yuṣmānahaṁ vadāmi, atra sthānē mandirādapi garīyān ēka āstē| ");
INSERT INTO saniso_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","kintu dayāyāṁ mē yathā prīti rna tathā yajñakarmmaṇi| ētadvacanasyārthaṁ yadi yuyam ajñāsiṣṭa tarhi nirdōṣān dōṣiṇō nākārṣṭa| ");
INSERT INTO saniso_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","anyacca manujasutō viśrāmavārasyāpi patirāstē| ");
INSERT INTO saniso_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","anantaraṁ sa tatsthānāt prasthāya tēṣāṁ bhajanabhavanaṁ praviṣṭavān, tadānīm ēkaḥ śuṣkakarāmayavān upasthitavān| ");
INSERT INTO saniso_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","tatō yīśum apavadituṁ mānuṣāḥ papracchuḥ, viśrāmavārē nirāmayatvaṁ karaṇīyaṁ na vā? ");
INSERT INTO saniso_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","tēna sa pratyuvāca, viśrāmavārē yadi kasyacid avi rgarttē patati, tarhi yastaṁ ghr̥tvā na tōlayati, ētādr̥śō manujō yuṣmākaṁ madhyē ka āstē? ");
INSERT INTO saniso_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","avē rmānavaḥ kiṁ nahi śrēyān? atō viśrāmavārē hitakarmma karttavyaṁ| ");
INSERT INTO saniso_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","anantaraṁ sa taṁ mānavaṁ gaditavān, karaṁ prasāraya; tēna karē prasāritē sōnyakaravat svasthō'bhavat| ");
INSERT INTO saniso_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","tadā phirūśinō bahirbhūya kathaṁ taṁ haniṣyāma iti kumantraṇāṁ tatprātikūlyēna cakruḥ| ");
INSERT INTO saniso_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","tatō yīśustad viditvā sthanāntaraṁ gatavān; anyēṣu bahunarēṣu tatpaścād gatēṣu tān sa nirāmayān kr̥tvā ityājñāpayat, ");
INSERT INTO saniso_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","yūyaṁ māṁ na paricāyayata| ");
INSERT INTO saniso_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","tasmāt mama prīyō manōnītō manasastuṣṭikārakaḥ| madīyaḥ sēvakō yastu vidyatē taṁ samīkṣatāṁ| tasyōpari svakīyātmā mayā saṁsthāpayiṣyatē| tēnānyadēśajātēṣu vyavasthā saṁprakāśyatē| ");
INSERT INTO saniso_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","kēnāpi na virōdhaṁ sa vivādañca kariṣyati| na ca rājapathē tēna vacanaṁ śrāvayiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","vyavasthā calitā yāvat nahi tēna kariṣyatē| tāvat nalō vidīrṇō'pi bhaṁkṣyatē nahi tēna ca| tathā sadhūmavarttiñca na sa nirvvāpayiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","pratyāśāñca kariṣyanti tannāmni bhinnadēśajāḥ| ");
INSERT INTO saniso_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","yānyētāni vacanāni yiśayiyabhaviṣyadvādinā prōktānyāsan, tāni saphalānyabhavan| ");
INSERT INTO saniso_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","anantaraṁ lōkai statsamīpam ānītō bhūtagrastāndhamūkaikamanujastēna svasthīkr̥taḥ, tataḥ sō'ndhō mūkō draṣṭuṁ vaktuñcārabdhavān| ");
INSERT INTO saniso_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","anēna sarvvē vismitāḥ kathayāñcakruḥ, ēṣaḥ kiṁ dāyūdaḥ santānō nahi? ");
INSERT INTO saniso_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","kintu phirūśinastat śrutvā gaditavantaḥ, bālsibūbnāmnō bhūtarājasya sāhāyyaṁ vinā nāyaṁ bhūtān tyājayati| ");
INSERT INTO saniso_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","tadānīṁ yīśustēṣām iti mānasaṁ vijñāya tān avadat kiñcana rājyaṁ yadi svavipakṣād bhidyatē, tarhi tat ucchidyatē; yacca kiñcana nagaraṁ vā gr̥haṁ svavipakṣād vibhidyatē, tat sthātuṁ na śaknōti| ");
INSERT INTO saniso_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","tadvat śayatānō yadi śayatānaṁ bahiḥ kr̥tvā svavipakṣāt pr̥thak pr̥thak bhavati, tarhi tasya rājyaṁ kēna prakārēṇa sthāsyati? ");
INSERT INTO saniso_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ahañca yadi bālsibūbā bhūtān tyājayāmi, tarhi yuṣmākaṁ santānāḥ kēna bhūtān tyājayanti? tasmād yuṣmākam ētadvicārayitārasta ēva bhaviṣyanti| ");
INSERT INTO saniso_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","kintavahaṁ yadīśvarātmanā bhūtān tyājayāmi, tarhīśvarasya rājyaṁ yuṣmākaṁ sannidhimāgatavat| ");
INSERT INTO saniso_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","anyañca kōpi balavanta janaṁ prathamatō na badvvā kēna prakārēṇa tasya gr̥haṁ praviśya taddravyādi lōṭhayituṁ śaknōti? kintu tat kr̥tvā tadīyagr̥sya dravyādi lōṭhayituṁ śaknōti| ");
INSERT INTO saniso_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","yaḥ kaścit mama svapakṣīyō nahi sa vipakṣīya āstē, yaśca mayā sākaṁ na saṁgr̥hlāti, sa vikirati| ");
INSERT INTO saniso_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ataēva yuṣmānahaṁ vadāmi, manujānāṁ sarvvaprakārapāpānāṁ nindāyāśca marṣaṇaṁ bhavituṁ śaknōti, kintu pavitrasyātmanō viruddhanindāyā marṣaṇaṁ bhavituṁ na śaknōti| ");
INSERT INTO saniso_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","yō manujasutasya viruddhāṁ kathāṁ kathayati, tasyāparādhasya kṣamā bhavituṁ śaknōti, kintu yaḥ kaścit pavitrasyātmanō viruddhāṁ kathāṁ kathayati nēhalōkē na prētya tasyāparādhasya kṣamā bhavituṁ śaknōti| ");
INSERT INTO saniso_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","pādapaṁ yadi bhadraṁ vadatha, tarhi tasya phalamapi sādhu vaktavyaṁ, yadi ca pādapaṁ asādhuṁ vadatha, tarhi tasya phalamapyasādhu vaktavyaṁ; yataḥ svīyasvīyaphalēna pādapaḥ paricīyatē| ");
INSERT INTO saniso_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","rē bhujagavaṁśā yūyamasādhavaḥ santaḥ kathaṁ sādhu vākyaṁ vaktuṁ śakṣyatha? yasmād antaḥkaraṇasya pūrṇabhāvānusārād vadanād vacō nirgacchati| ");
INSERT INTO saniso_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","tēna sādhurmānavō'ntaḥkaraṇarūpāt sādhubhāṇḍāgārāt sādhu dravyaṁ nirgamayati, asādhurmānuṣastvasādhubhāṇḍāgārād asādhuvastūni nirgamayati| ");
INSERT INTO saniso_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","kintvahaṁ yuṣmān vadāmi, manujā yāvantyālasyavacāṁsi vadanti, vicāradinē taduttaramavaśyaṁ dātavyaṁ, ");
INSERT INTO saniso_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","yatastvaṁ svīyavacōbhi rniraparādhaḥ svīyavacōbhiśca sāparādhō gaṇiṣyasē| ");
INSERT INTO saniso_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","tadānīṁ katipayā upādhyāyāḥ phirūśinaśca jagaduḥ, hē gurō vayaṁ bhavattaḥ kiñcana lakṣma didr̥kṣāmaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","tadā sa pratyuktavān, duṣṭō vyabhicārī ca vaṁśō lakṣma mr̥gayatē, kintu bhaviṣyadvādinō yūnasō lakṣma vihāyānyat kimapi lakṣma tē na pradarśayiṣyantē| ");
INSERT INTO saniso_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","yatō yūnam yathā tryahōrātraṁ br̥hanmīnasya kukṣāvāsīt, tathā manujaputrōpi tryahōrātraṁ mēdinyā madhyē sthāsyati| ");
INSERT INTO saniso_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","aparaṁ nīnivīyā mānavā vicāradina ētadvaṁśīyānāṁ pratikūlam utthāya tān dōṣiṇaḥ kariṣyanti, yasmāttē yūnasa upadēśāt manāṁsi parāvarttayāñcakrirē, kintvatra yūnasōpi gurutara ēka āstē| ");
INSERT INTO saniso_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","punaśca dakṣiṇadēśīyā rājñī vicāradina ētadvaṁśīyānāṁ pratikūlamutthāya tān dōṣiṇaḥ kariṣyati yataḥ sā rājñī sulēmanō vidyāyāḥ kathāṁ śrōtuṁ mēdinyāḥ sīmna āgacchat, kintu sulēmanōpi gurutara ēkō janō'tra āstē| ");
INSERT INTO saniso_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","aparaṁ manujād bahirgatō 'pavitrabhūtaḥ śuṣkasthānēna gatvā viśrāmaṁ gavēṣayati, kintu tadalabhamānaḥ sa vakti, yasmā; nikētanād āgamaṁ, tadēva vēśma pakāvr̥tya yāmi| ");
INSERT INTO saniso_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","paścāt sa tat sthānam upasthāya tat śūnyaṁ mārjjitaṁ śōbhitañca vilōkya vrajan svatōpi duṣṭatarān anyasaptabhūtān saṅginaḥ karōti| ");
INSERT INTO saniso_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","tatastē tat sthānaṁ praviśya nivasanti, tēna tasya manujasya śēṣadaśā pūrvvadaśātōtīvāśubhā bhavati, ētēṣāṁ duṣṭavaṁśyānāmapi tathaiva ghaṭiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","mānavēbhya ētāsāṁ kathanāṁ kathanakālē tasya mātā sahajāśca tēna sākaṁ kāñcit kathāṁ kathayituṁ vāñchantō bahirēva sthitavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","tataḥ kaścit tasmai kathitavān, paśya tava jananī sahajāśca tvayā sākaṁ kāñcana kathāṁ kathayituṁ kāmayamānā bahistiṣṭhanti| ");
INSERT INTO saniso_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","kintu sa taṁ pratyavadat, mama kā jananī? kē vā mama sahajāḥ? ");
INSERT INTO saniso_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","paścāt śiṣyān prati karaṁ prasāryya kathitavān, paśya mama jananī mama sahajāścaitē; ");
INSERT INTO saniso_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","yaḥ kaścit mama svargasthasya pituriṣṭaṁ karmma kurutē, saēva mama bhrātā bhaginī jananī ca| ");
INSERT INTO saniso_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","aparañca tasmin dinē yīśuḥ sadmanō gatvā saritpatē rōdhasi samupavivēśa| ");
INSERT INTO saniso_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","tatra tatsannidhau bahujanānāṁ nivahōpasthitēḥ sa taraṇimāruhya samupāviśat, tēna mānavā rōdhasi sthitavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","tadānīṁ sa dr̥ṣṭāntaistān itthaṁ bahuśa upadiṣṭavān| paśyata, kaścit kr̥ṣīvalō bījāni vaptuṁ bahirjagāma, ");
INSERT INTO saniso_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","tasya vapanakālē katipayabījēṣu mārgapārśvē patitēṣu vihagāstāni bhakṣitavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","aparaṁ katipayabījēṣu stōkamr̥dyuktapāṣāṇē patitēṣu mr̥dalpatvāt tatkṣaṇāt tānyaṅkuritāni, ");
INSERT INTO saniso_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","kintu ravāvuditē dagdhāni tēṣāṁ mūlāpraviṣṭatvāt śuṣkatāṁ gatāni ca| ");
INSERT INTO saniso_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","aparaṁ katipayabījēṣu kaṇṭakānāṁ madhyē patitēṣu kaṇṭakānyēdhitvā tāni jagrasuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","aparañca katipayabījāni urvvarāyāṁ patitāni; tēṣāṁ madhyē kānicit śataguṇāni kānicit ṣaṣṭiguṇāni kānicit triṁśaguṁṇāni phalāni phalitavanti| ");
INSERT INTO saniso_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","śrōtuṁ yasya śrutī āsātē sa śr̥ṇuyāt| ");
INSERT INTO saniso_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","anantaraṁ śiṣyairāgatya sō'pr̥cchyata, bhavatā tēbhyaḥ kutō dr̥ṣṭāntakathā kathyatē? ");
INSERT INTO saniso_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","tataḥ sa pratyavadat, svargarājyasya nigūḍhāṁ kathāṁ vēdituṁ yuṣmabhyaṁ sāmarthyamadāyi, kintu tēbhyō nādāyi| ");
INSERT INTO saniso_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","yasmād yasyāntikē varddhatē, tasmāyēva dāyiṣyatē, tasmāt tasya bāhulyaṁ bhaviṣyati, kintu yasyāntikē na varddhatē, tasya yat kiñcanāstē, tadapi tasmād ādāyiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","tē paśyantōpi na paśyanti, śr̥ṇvantōpi na śr̥ṇvanti, budhyamānā api na budhyantē ca, tasmāt tēbhyō dr̥ṣṭāntakathā kathyatē| ");
INSERT INTO saniso_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","yathā karṇaiḥ śrōṣyatha yūyaṁ vai kintu yūyaṁ na bhōtsyatha| nētrairdrakṣyatha yūyañca parijñātuṁ na śakṣyatha| tē mānuṣā yathā naiva paripaśyanti lōcanaiḥ| karṇai ryathā na śr̥ṇvanti na budhyantē ca mānasaiḥ| vyāvarttitēṣu cittēṣu kālē kutrāpi tairjanaiḥ| mattastē manujāḥ svasthā yathā naiva bhavanti ca| tathā tēṣāṁ manuṣyāṇāṁ kriyantē sthūlabuddhayaḥ| badhirībhūtakarṇāśca jātāśca mudritā dr̥śaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","yadētāni vacanāni yiśayiyabhaviṣyadvādinā prōktāni tēṣu tāni phalanti| ");
INSERT INTO saniso_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","kintu yuṣmākaṁ nayanāni dhanyāni, yasmāt tāni vīkṣantē; dhanyāśca yuṣmākaṁ śabdagrahāḥ, yasmāt tairākarṇyatē| ");
INSERT INTO saniso_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","mayā yūyaṁ tathyaṁ vacāmi yuṣmābhi ryadyad vīkṣyatē, tad bahavō bhaviṣyadvādinō dhārmmikāśca mānavā didr̥kṣantōpi draṣṭuṁ nālabhanta, punaśca yūyaṁ yadyat śr̥ṇutha, tat tē śuśrūṣamāṇā api śrōtuṁ nālabhanta| ");
INSERT INTO saniso_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","kr̥ṣīvalīyadr̥ṣṭāntasyārthaṁ śr̥ṇuta| ");
INSERT INTO saniso_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","mārgapārśvē bījānyuptāni tasyārtha ēṣaḥ, yadā kaścit rājyasya kathāṁ niśamya na budhyatē, tadā pāpātmāgatya tadīyamanasa uptāṁ kathāṁ haran nayati| ");
INSERT INTO saniso_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","aparaṁ pāṣāṇasthalē bījānyuptāni tasyārtha ēṣaḥ; kaścit kathāṁ śrutvaiva harṣacittēna gr̥hlāti, ");
INSERT INTO saniso_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","kintu tasya manasi mūlāpraviṣṭatvāt sa kiñcitkālamātraṁ sthirastiṣṭhati; paścāta tatkathākāraṇāt kōpi klēstāḍanā vā cēt jāyatē, tarhi sa tatkṣaṇād vighnamēti| ");
INSERT INTO saniso_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","aparaṁ kaṇṭakānāṁ madhyē bījānyuptāni tadartha ēṣaḥ; kēnacit kathāyāṁ śrutāyāṁ sāṁsārikacintābhi rbhrāntibhiśca sā grasyatē, tēna sā mā viphalā bhavati| ");
INSERT INTO saniso_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","aparam urvvarāyāṁ bījānyuptāni tadartha ēṣaḥ; yē tāṁ kathāṁ śrutvā vudhyantē, tē phalitāḥ santaḥ kēcit śataguṇāni kēcita ṣaṣṭiguṇāni kēcicca triṁśadguṇāni phalāni janayanti| ");
INSERT INTO saniso_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","anantaraṁ sōparāmēkāṁ dr̥ṣṭāntakathāmupasthāpya tēbhyaḥ kathayāmāsa; svargīyarājyaṁ tādr̥śēna kēnacid gr̥hasthēnōpamīyatē, yēna svīyakṣētrē praśastabījānyaupyanta| ");
INSERT INTO saniso_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","kintu kṣaṇadāyāṁ sakalalōkēṣu suptēṣu tasya ripurāgatya tēṣāṁ gōdhūmabījānāṁ madhyē vanyayavamabījānyuptvā vavrāja| ");
INSERT INTO saniso_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","tatō yadā bījēbhyō'ṅkarā jāyamānāḥ kaṇiśāni ghr̥tavantaḥ; tadā vanyayavasānyapi dr̥śyamānānyabhavan| ");
INSERT INTO saniso_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","tatō gr̥hasthasya dāsēyā āgamya tasmai kathayāñcakruḥ, hē mahēccha, bhavatā kiṁ kṣētrē bhadrabījāni naupyanta? tathātvē vanyayavasāni kr̥ta āyan? ");
INSERT INTO saniso_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","tadānīṁ tēna tē pratigaditāḥ, kēnacit ripuṇā karmmadamakāri| dāsēyāḥ kathayāmāsuḥ, vayaṁ gatvā tānyutpāyya kṣipāmō bhavataḥ kīdr̥śīcchā jāyatē? ");
INSERT INTO saniso_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","tēnāvādi, nahi, śaṅkē'haṁ vanyayavasōtpāṭanakālē yuṣmābhistaiḥ sākaṁ gōdhūmā apyutpāṭiṣyantē| ");
INSERT INTO saniso_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ataḥ śsyakarttanakālaṁ yāvad ubhayānyapi saha varddhantāṁ, paścāt karttanakālē karttakān vakṣyāmi, yūyamādau vanyayavasāni saṁgr̥hya dāhayituṁ vīṭikā badvvā sthāpayata; kintu sarvvē gōdhūmā yuṣmābhi rbhāṇḍāgāraṁ nītvā sthāpyantām| ");
INSERT INTO saniso_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","anantaraṁ sōparāmēkāṁ dr̥ṣṭāntakathāmutthāpya tēbhyaḥ kathitavān kaścinmanujaḥ sarṣapabījamēkaṁ nītvā svakṣētra uvāpa| ");
INSERT INTO saniso_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","sarṣapabījaṁ sarvvasmād bījāt kṣudramapi sadaṅkuritaṁ sarvvasmāt śākāt br̥had bhavati; sa tādr̥śastaru rbhavati, yasya śākhāsu nabhasaḥ khagā āgatya nivasanti; svargīyarājyaṁ tādr̥śasya sarṣapaikasya samam| ");
INSERT INTO saniso_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","punarapi sa upamākathāmēkāṁ tēbhyaḥ kathayāñcakāra; kācana yōṣit yat kiṇvamādāya drōṇatrayamitagōdhūmacūrṇānāṁ madhyē sarvvēṣāṁ miśrībhavanaparyyantaṁ samācchādya nidhattavatī, tatkiṇvamiva svargarājyaṁ| ");
INSERT INTO saniso_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","itthaṁ yīśu rmanujanivahānāṁ sannidhāvupamākathābhirētānyākhyānāni kathitavān upamāṁ vinā tēbhyaḥ kimapi kathāṁ nākathayat| ");
INSERT INTO saniso_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ētēna dr̥ṣṭāntīyēna vākyēna vyādāya vadanaṁ nijaṁ| ahaṁ prakāśayiṣyāmi guptavākyaṁ purābhavaṁ| yadētadvacanaṁ bhaviṣyadvādinā prōktamāsīt, tat siddhamabhavat| ");
INSERT INTO saniso_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","sarvvān manujān visr̥jya yīśau gr̥haṁ praviṣṭē tacchiṣyā āgatya yīśavē kathitavantaḥ, kṣētrasya vanyayavasīyadr̥ṣṭāntakathām bhavāna asmān spaṣṭīkr̥tya vadatu| ");
INSERT INTO saniso_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","tataḥ sa pratyuvāca, yēna bhadrabījānyupyantē sa manujaputraḥ, ");
INSERT INTO saniso_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","kṣētraṁ jagat, bhadrabījānī rājyasya santānāḥ, ");
INSERT INTO saniso_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","vanyayavasāni pāpātmanaḥ santānāḥ| yēna ripuṇā tānyuptāni sa śayatānaḥ, karttanasamayaśca jagataḥ śēṣaḥ, karttakāḥ svargīyadūtāḥ| ");
INSERT INTO saniso_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","yathā vanyayavasāni saṁgr̥hya dāhyantē, tathā jagataḥ śēṣē bhaviṣyati; ");
INSERT INTO saniso_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","arthāt manujasutaḥ svāṁyadūtān prēṣayiṣyati, tēna tē ca tasya rājyāt sarvvān vighnakāriṇō'dhārmmikalōkāṁśca saṁgr̥hya ");
INSERT INTO saniso_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","yatra rōdanaṁ dantagharṣaṇañca bhavati, tatrāgnikuṇḍē nikṣēpsyanti| ");
INSERT INTO saniso_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","tadānīṁ dhārmmikalōkāḥ svēṣāṁ pitū rājyē bhāskara̮iva tējasvinō bhaviṣyanti| śrōtuṁ yasya śrutī āsātē, ma śr̥ṇuyāt| ");
INSERT INTO saniso_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","aparañca kṣētramadhyē nidhiṁ paśyan yō gōpayati, tataḥ paraṁ sānandō gatvā svīyasarvvasvaṁ vikrīya ttakṣētraṁ krīṇāti, sa iva svargarājyaṁ| ");
INSERT INTO saniso_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","anyañca yō vaṇik uttamāṁ muktāṁ gavēṣayan ");
INSERT INTO saniso_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","mahārghāṁ muktāṁ vilōkya nijasarvvasvaṁ vikrīya tāṁ krīṇāti, sa iva svargarājyaṁ| ");
INSERT INTO saniso_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","punaśca samudrō nikṣiptaḥ sarvvaprakāramīnasaṁgrāhyānāya̮iva svargarājyaṁ| ");
INSERT INTO saniso_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","tasmin ānāyē pūrṇē janā yathā rōdhasyuttōlya samupaviśya praśastamīnān saṁgrahya bhājanēṣu nidadhatē, kutsitān nikṣipanti; ");
INSERT INTO saniso_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","tathaiva jagataḥ śēṣē bhaviṣyati, phalataḥ svargīyadūtā āgatya puṇyavajjanānāṁ madhyāt pāpinaḥ pr̥thak kr̥tvā vahnikuṇḍē nikṣēpsyanti, ");
INSERT INTO saniso_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","tatra rōdanaṁ dantai rdantagharṣaṇañca bhaviṣyataḥ| ");
INSERT INTO saniso_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","yīśunā tē pr̥ṣṭā yuṣmābhiḥ kimētānyākhyānānyabudhyanta? tadā tē pratyavadan, satyaṁ prabhō| ");
INSERT INTO saniso_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","tadānīṁ sa kathitavān, nijabhāṇḍāgārāt navīnapurātanāni vastūni nirgamayati yō gr̥hasthaḥ sa iva svargarājyamadhi śikṣitāḥ svarva upadēṣṭāraḥ| ");
INSERT INTO saniso_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","anantaraṁ yīśurētāḥ sarvvā dr̥ṣṭāntakathāḥ samāpya tasmāt sthānāt pratasthē| aparaṁ svadēśamāgatya janān bhajanabhavana upadiṣṭavān; ");
INSERT INTO saniso_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","tē vismayaṁ gatvā kathitavanta ētasyaitādr̥śaṁ jñānam āścaryyaṁ karmma ca kasmād ajāyata? ");
INSERT INTO saniso_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","kimayaṁ sūtradhārasya putrō nahi? ētasya mātu rnāma ca kiṁ mariyam nahi? yākub-yūṣaph-śimōn-yihūdāśca kimētasya bhrātarō nahi? ");
INSERT INTO saniso_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ētasya bhaginyaśca kimasmākaṁ madhyē na santi? tarhi kasmādayamētāni labdhavān? itthaṁ sa tēṣāṁ vighnarūpō babhūva; ");
INSERT INTO saniso_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","tatō yīśunā nigaditaṁ svadēśīyajanānāṁ madhyaṁ vinā bhaviṣyadvādī kutrāpyanyatra nāsammānyō bhavatī| ");
INSERT INTO saniso_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","tēṣāmaviśvāsahētōḥ sa tatra sthānē bahvāścaryyakarmmāṇi na kr̥tavān| ");
INSERT INTO saniso_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","tadānīṁ rājā hērōd yīśō ryaśaḥ śrutvā nijadāsēyān jagād, ");
INSERT INTO saniso_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ēṣa majjayitā yōhan, pramitēbhayastasyōtthānāt tēnētthamadbhutaṁ karmma prakāśyatē| ");
INSERT INTO saniso_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","purā hērōd nijabhrātu: philipō jāyāyā hērōdīyāyā anurōdhād yōhanaṁ dhārayitvā baddhā kārāyāṁ sthāpitavān| ");
INSERT INTO saniso_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","yatō yōhan uktavān, ētsayāḥ saṁgrahō bhavatō nōcitaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","tasmāt nr̥patistaṁ hantumicchannapi lōkēbhyō vibhayāñcakāra; yataḥ sarvvē yōhanaṁ bhaviṣyadvādinaṁ mēnirē| ");
INSERT INTO saniso_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","kintu hērōdō janmāhīyamaha upasthitē hērōdīyāyā duhitā tēṣāṁ samakṣaṁ nr̥titvā hērōdamaprīṇyat| ");
INSERT INTO saniso_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","tasmāt bhūpatiḥ śapathaṁ kurvvan iti pratyajñāsīt, tvayā yad yācyatē, tadēvāhaṁ dāsyāmi| ");
INSERT INTO saniso_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","sā kumārī svīyamātuḥ śikṣāṁ labdhā babhāṣē, majjayituryōhana uttamāṅgaṁ bhājanē samānīya mahyaṁ viśrāṇaya| ");
INSERT INTO saniso_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","tatō rājā śuśōca, kintu bhōjanāyōpaviśatāṁ saṅgināṁ svakr̥taśapathasya cānurōdhāt tat pradātuma ādidēśa| ");
INSERT INTO saniso_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","paścāt kārāṁ prati naraṁ prahitya yōhana uttamāṅgaṁ chittvā ");
INSERT INTO saniso_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","tat bhājana ānāyya tasyai kumāryyai vyaśrāṇayat, tataḥ sā svajananyāḥ samīpaṁ tannināya| ");
INSERT INTO saniso_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","paścāt yōhanaḥ śiṣyā āgatya kāyaṁ nītvā śmaśānē sthāpayāmāsustatō yīśōḥ sannidhiṁ vrajitvā tadvārttāṁ babhāṣirē| ");
INSERT INTO saniso_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","anantaraṁ yīśuriti niśabhya nāvā nirjanasthānam ēkākī gatavān, paścāt mānavāstat śrutvā nānānagarēbhya āgatya padaistatpaścād īyuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","tadānīṁ yīśu rbahirāgatya mahāntaṁ jananivahaṁ nirīkṣya tēṣu kāruṇikaḥ man tēṣāṁ pīḍitajanān nirāmayān cakāra| ");
INSERT INTO saniso_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","tataḥ paraṁ sandhyāyāṁ śiṣyāstadantikamāgatya kathayāñcakruḥ, idaṁ nirjanasthānaṁ vēlāpyavasannā; tasmāt manujān svasvagrāmaṁ gantuṁ svārthaṁ bhakṣyāṇi krētuñca bhavān tān visr̥jatu| ");
INSERT INTO saniso_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","kintu yīśustānavādīt, tēṣāṁ gamanē prayōjanaṁ nāsti, yūyamēva tān bhōjayata| ");
INSERT INTO saniso_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","tadā tē pratyavadan, asmākamatra pūpapañcakaṁ mīnadvayañcāstē| ");
INSERT INTO saniso_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","tadānīṁ tēnōktaṁ tāni madantikamānayata| ");
INSERT INTO saniso_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","anantaraṁ sa manujān yavasōparyyupavēṣṭum ājñāpayāmāsa; apara tat pūpapañcakaṁ mīnadvayañca gr̥hlan svargaṁ prati nirīkṣyēśvarīyaguṇān anūdya bhaṁktvā śiṣyēbhyō dattavān, śiṣyāśca lōkēbhyō daduḥ| ");
INSERT INTO saniso_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","tataḥ sarvvē bhuktvā paritr̥ptavantaḥ, tatastadavaśiṣṭabhakṣyaiḥ pūrṇān dvādaśaḍalakān gr̥hītavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","tē bhōktāraḥ strīrbālakāṁśca vihāya prāyēṇa pañca sahasrāṇi pumāṁsa āsan| ");
INSERT INTO saniso_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","tadanantaraṁ yīśu rlōkānāṁ visarjanakālē śiṣyān taraṇimārōḍhuṁ svāgrē pāraṁ yātuñca gāḍhamādiṣṭavān| ");
INSERT INTO saniso_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","tatō lōkēṣu visr̥ṣṭēṣu sa viviktē prārthayituṁ girimēkaṁ gatvā sandhyāṁ yāvat tatraikākī sthitavān| ");
INSERT INTO saniso_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","kintu tadānīṁ sammukhavātatvāt saritpatē rmadhyē taraṅgaistaraṇirdōlāyamānābhavat| ");
INSERT INTO saniso_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","tadā sa yāminyāścaturthapraharē padbhyāṁ vrajan tēṣāmantikaṁ gatavān| ");
INSERT INTO saniso_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","kintu śiṣyāstaṁ sāgarōpari vrajantaṁ vilōkya samudvignā jagaduḥ, ēṣa bhūta iti śaṅkamānā uccaiḥ śabdāyāñcakrirē ca| ");
INSERT INTO saniso_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","tadaiva yīśustānavadat, susthirā bhavata, mā bhaiṣṭa, ēṣō'ham| ");
INSERT INTO saniso_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","tataḥ pitara ityuktavān, hē prabhō, yadi bhavānēva, tarhi māṁ bhavatsamīpaṁ yātumājñāpayatu| ");
INSERT INTO saniso_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","tataḥ tēnādiṣṭaḥ pitarastaraṇitō'varuhya yīśēाrantikaṁ prāptuṁ tōyōpari vavrāja| ");
INSERT INTO saniso_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","kintu pracaṇḍaṁ pavanaṁ vilōkya bhayāt tōyē maṁktum ārēbhē, tasmād uccaiḥ śabdāyamānaḥ kathitavān, hē prabhō, māmavatu| ");
INSERT INTO saniso_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","yīśustatkṣaṇāt karaṁ prasāryya taṁ dharan uktavān, ha stōkapratyayin tvaṁ kutaḥ samaśēthāḥ? ");
INSERT INTO saniso_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","anantaraṁ tayōstaraṇimārūḍhayōḥ pavanō nivavr̥tē| ");
INSERT INTO saniso_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","tadānīṁ yē taraṇyāmāsan, ta āgatya taṁ praṇabhya kathitavantaḥ, yathārthastvamēvēśvarasutaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","anantaraṁ pāraṁ prāpya tē ginēṣarannāmakaṁ nagaramupatasthuḥ, ");
INSERT INTO saniso_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","tadā tatratyā janā yīśuṁ paricīya taddēśsya caturdiśō vārttāṁ prahitya yatra yāvantaḥ pīḍitā āsan, tāvataēva tadantikamānayāmāsuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","aparaṁ tadīyavasanasya granthimātraṁ spraṣṭuṁ vinīya yāvantō janāstat sparśaṁ cakrirē, tē sarvvaēva nirāmayā babhūvuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","aparaṁ yirūśālamnagarīyāḥ katipayā adhyāpakāḥ phirūśinaśca yīśōḥ samīpamāgatya kathayāmāsuḥ, ");
INSERT INTO saniso_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","tava śiṣyāḥ kimartham aprakṣālitakarai rbhakṣitvā paramparāgataṁ prācīnānāṁ vyavahāraṁ laṅvantē? ");
INSERT INTO saniso_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","tatō yīśuḥ pratyuvāca, yūyaṁ paramparāgatācārēṇa kuta īśvarājñāṁ laṅvadhvē| ");
INSERT INTO saniso_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","īśvara ityājñāpayat, tvaṁ nijapitarau saṁmanyēthāḥ, yēna ca nijapitarau nindyētē, sa niścitaṁ mriyēta; ");
INSERT INTO saniso_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","kintu yūyaṁ vadatha, yaḥ svajanakaṁ svajananīṁ vā vākyamidaṁ vadati, yuvāṁ mattō yallabhēthē, tat nyavidyata, ");
INSERT INTO saniso_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","sa nijapitarau puna rna saṁmaṁsyatē| itthaṁ yūyaṁ paramparāgatēna svēṣāmācārēṇēśvarīyājñāṁ lumpatha| ");
INSERT INTO saniso_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","rē kapaṭinaḥ sarvvē yiśayiyō yuṣmānadhi bhaviṣyadvacanānyētāni samyag uktavān| ");
INSERT INTO saniso_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","vadanai rmanujā ētē samāyānti madantikaṁ| tathādharai rmadīyañca mānaṁ kurvvanti tē narāḥ| ");
INSERT INTO saniso_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","kintu tēṣāṁ manō mattō vidūraēva tiṣṭhati| śikṣayantō vidhīn nrājñā bhajantē māṁ mudhaiva tē| ");
INSERT INTO saniso_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","tatō yīśu rlōkān āhūya prōktavān, yūyaṁ śrutvā budhyadhbaṁ| ");
INSERT INTO saniso_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","yanmukhaṁ praviśati, tat manujam amēdhyaṁ na karōti, kintu yadāsyāt nirgacchati, tadēva mānuṣamamēdhyī karōtī| ");
INSERT INTO saniso_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","tadānīṁ śiṣyā āgatya tasmai kathayāñcakruḥ, ētāṁ kathāṁ śrutvā phirūśinō vyarajyanta, tat kiṁ bhavatā jñāyatē? ");
INSERT INTO saniso_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","sa pratyavadat, mama svargasthaḥ pitā yaṁ kañcidaṅkuraṁ nārōpayat, sa utpāvdyatē| ");
INSERT INTO saniso_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","tē tiṣṭhantu, tē andhamanujānām andhamārgadarśakā ēva; yadyandhō'ndhaṁ panthānaṁ darśayati, tarhyubhau garttē patataḥ| ");
INSERT INTO saniso_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","tadā pitarastaṁ pratyavadat, dr̥ṣṭāntamimamasmān bōdhayatu| ");
INSERT INTO saniso_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","yīśunā prōktaṁ, yūyamadya yāvat kimabōdhāḥ stha? ");
INSERT INTO saniso_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","kathāmimāṁ kiṁ na budhyadhbē ? yadāsyaṁ prēviśati, tad udarē patan bahirniryāti, ");
INSERT INTO saniso_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","kintvāsyād yanniryāti, tad antaḥkaraṇāt niryātatvāt manujamamēdhyaṁ karōti| ");
INSERT INTO saniso_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","yatō'ntaḥkaraṇāt kucintā badhaḥ pāradārikatā vēśyāgamanaṁ cairyyaṁ mithyāsākṣyam īśvaranindā caitāni sarvvāṇi niryyānti| ");
INSERT INTO saniso_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ētāni manuṣyamapavitrī kurvvanti kintvaprakṣālitakarēṇa bhōjanaṁ manujamamēdhyaṁ na karōti| ");
INSERT INTO saniso_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","anantaraṁ yīśustasmāt sthānāt prasthāya sōrasīdōnnagarayōḥ sīmāmupatasyau| ");
INSERT INTO saniso_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","tadā tatsīmātaḥ kācit kinānīyā yōṣid āgatya tamuccairuvāca, hē prabhō dāyūdaḥ santāna, mamaikā duhitāstē sā bhūtagrastā satī mahāklēśaṁ prāpnōti mama dayasva| ");
INSERT INTO saniso_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","kintu yīśustāṁ kimapi nōktavān, tataḥ śiṣyā āgatya taṁ nivēdayāmāsuḥ, ēṣā yōṣid asmākaṁ paścād uccairāhūyāgacchati, ēnāṁ visr̥jatu| ");
INSERT INTO saniso_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","tadā sa pratyavadat, isrāyēlgōtrasya hāritamēṣān vinā kasyāpyanyasya samīpaṁ nāhaṁ prēṣitōsmi| ");
INSERT INTO saniso_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","tataḥ sā nārīsamāgatya taṁ praṇamya jagāda, hē prabhō māmupakuru| ");
INSERT INTO saniso_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","sa uktavān, bālakānāṁ bhakṣyamādāya sāramēyēbhyō dānaṁ nōcitaṁ| ");
INSERT INTO saniso_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","tadā sā babhāṣē, hē prabhō, tat satyaṁ, tathāpi prabhō rbhañcād yaducchiṣṭaṁ patati, tat sāramēyāḥ khādanti| ");
INSERT INTO saniso_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","tatō yīśuḥ pratyavadat, hē yōṣit, tava viśvāsō mahān tasmāt tava manōbhilaṣitaṁ sidyyatu, tēna tasyāḥ kanyā tasminnēva daṇḍē nirāmayābhavat| ");
INSERT INTO saniso_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","anantaraṁ yīśastasmāt sthānāt prasthāya gālīlsāgarasya sannidhimāgatya dharādharamāruhya tatrōpavivēśa| ");
INSERT INTO saniso_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","paścāt jananivahō bahūn khañcāndhamūkaśuṣkakaramānuṣān ādāya yīśōḥ samīpamāgatya taccaraṇāntikē sthāpayāmāsuḥ, tataḥ sā tān nirāmayān akarōt| ");
INSERT INTO saniso_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","itthaṁ mūkā vākyaṁ vadanti, śuṣkakarāḥ svāsthyamāyānti, paṅgavō gacchanti, andhā vīkṣantē, iti vilōkya lōkā vismayaṁ manyamānā isrāyēla īśvaraṁ dhanyaṁ babhāṣirē| ");
INSERT INTO saniso_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","tadānīṁ yīśuḥ svaśiṣyān āhūya gaditavān, ētajjananivahēṣu mama dayā jāyatē, ētē dinatrayaṁ mayā sākaṁ santi, ēṣāṁ bhakṣyavastu ca kañcidapi nāsti, tasmādahamētānakr̥tāhārān na visrakṣyāmi, tathātvē vartmamadhyē klāmyēṣuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","tadā śiṣyā ūcuḥ, ētasmin prāntaramadhya ētāvatō martyān tarpayituṁ vayaṁ kutra pūpān prāpsyāmaḥ? ");
INSERT INTO saniso_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","yīśurapr̥cchat, yuṣmākaṁ nikaṭē kati pūpā āsatē? ta ūcuḥ, saptapūpā alpāḥ kṣudramīnāśca santi| ");
INSERT INTO saniso_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","tadānīṁ sa lōkanivahaṁ bhūmāvupavēṣṭum ādiśya ");
INSERT INTO saniso_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","tān saptapūpān mīnāṁśca gr̥hlan īśvarīyaguṇān anūdya bhaṁktvā śiṣyēbhyō dadau, śiṣyā lōkēbhyō daduḥ| ");
INSERT INTO saniso_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","tataḥ sarvvē bhuktvā tr̥ptavantaḥ; tadavaśiṣṭabhakṣyēṇa saptaḍalakān paripūryya saṁjagr̥huḥ| ");
INSERT INTO saniso_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","tē bhōktārō yōṣitō bālakāṁśca vihāya prāyēṇa catuḥsahasrāṇi puruṣā āsan| ");
INSERT INTO saniso_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","tataḥ paraṁ sa jananivahaṁ visr̥jya tarimāruhya magdalāpradēśaṁ gatavān| ");
INSERT INTO saniso_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","tadānīṁ phirūśinaḥ sidūkinaścāgatya taṁ parīkṣituṁ nabhamīyaṁ kiñcana lakṣma darśayituṁ tasmai nivēdayāmāsuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","tataḥ sa uktavān, sandhyāyāṁ nabhasō raktatvād yūyaṁ vadatha, śvō nirmmalaṁ dinaṁ bhaviṣyati; ");
INSERT INTO saniso_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","prātaḥkālē ca nabhasō raktatvāt malinatvāñca vadatha, jhañbhśadya bhaviṣyati| hē kapaṭinō yadi yūyam antarīkṣasya lakṣma bōddhuṁ śaknutha, tarhi kālasyaitasya lakṣma kathaṁ bōddhuṁ na śaknutha? ");
INSERT INTO saniso_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ētatkālasya duṣṭō vyabhicārī ca vaṁśō lakṣma gavēṣayati, kintu yūnasō bhaviṣyadvādinō lakṣma vinānyat kimapi lakṣma tān na darśayiyyatē| tadānīṁ sa tān vihāya pratasthē| ");
INSERT INTO saniso_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","anantaramanyapāragamanakālē tasya śiṣyāḥ pūpamānētuṁ vismr̥tavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","yīśustānavādīt, yūyaṁ phirūśināṁ sidūkināñca kiṇvaṁ prati sāvadhānāḥ satarkāśca bhavata| ");
INSERT INTO saniso_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","tēna tē parasparaṁ vivicya kathayitumārēbhirē, vayaṁ pūpānānētuṁ vismr̥tavanta ētatkāraṇād iti kathayati| ");
INSERT INTO saniso_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","kintu yīśustadvijñāya tānavōcat, hē stōkaviśvāsinō yūyaṁ pūpānānayanamadhi kutaḥ parasparamētad viviṁkya? ");
INSERT INTO saniso_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","yuṣmābhiḥ kimadyāpi na jñāyatē? pañcabhiḥ pūpaiḥ pañcasahasrapuruṣēṣu bhōjitēṣu bhakṣyōcchiṣṭapūrṇān kati ḍalakān samagr̥hlītaṁ; ");
INSERT INTO saniso_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","tathā saptabhiḥ pūpaiścatuḥsahasrapuruṣēṣu bhējitēṣu kati ḍalakān samagr̥hlīta, tat kiṁ yuṣmābhirna smaryyatē? ");
INSERT INTO saniso_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","tasmāt phirūśināṁ sidūkināñca kiṇvaṁ prati sāvadhānāstiṣṭhata, kathāmimām ahaṁ pūpānadhi nākathayaṁ, ētad yūyaṁ kutō na budhyadhvē? ");
INSERT INTO saniso_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","tadānīṁ pūpakiṇvaṁ prati sāvadhānāstiṣṭhatēti nōktvā phirūśināṁ sidūkināñca upadēśaṁ prati sāvadhānāstiṣṭhatēti kathitavān, iti tairabōdhi| ");
INSERT INTO saniso_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","aparañca yīśuḥ kaisariyā-philipipradēśamāgatya śiṣyān apr̥cchat, yō'haṁ manujasutaḥ sō'haṁ kaḥ? lōkairahaṁ kimucyē? ");
INSERT INTO saniso_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","tadānīṁ tē kathitavantaḥ, kēcid vadanti tvaṁ majjayitā yōhan, kēcidvadanti, tvam ēliyaḥ, kēcicca vadanti, tvaṁ yirimiyō vā kaścid bhaviṣyadvādīti| ");
INSERT INTO saniso_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","paścāt sa tān papraccha, yūyaṁ māṁ kaṁ vadatha? tataḥ śimōn pitara uvāca, ");
INSERT INTO saniso_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","tvamamarēśvarasyābhiṣiktaputraḥ| ");
INSERT INTO saniso_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","tatō yīśuḥ kathitavān, hē yūnasaḥ putra śimōn tvaṁ dhanyaḥ; yataḥ kōpi anujastvayyētajjñānaṁ nōdapādayat, kintu mama svargasyaḥ pitōdapādayat| ");
INSERT INTO saniso_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","atō'haṁ tvāṁ vadāmi, tvaṁ pitaraḥ (prastaraḥ) ahañca tasya prastarasyōpari svamaṇḍalīṁ nirmmāsyāmi, tēna nirayō balāt tāṁ parājētuṁ na śakṣyati| ");
INSERT INTO saniso_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","ahaṁ tubhyaṁ svargīyarājyasya kuñjikāṁ dāsyāmi, tēna yat kiñcana tvaṁ pr̥thivyāṁ bhaṁtsyasi tatsvargē bhaṁtsyatē, yacca kiñcana mahyāṁ mōkṣyasi tat svargē mōkṣyatē| ");
INSERT INTO saniso_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","paścāt sa śiṣyānādiśat, ahamabhiṣiktō yīśuriti kathāṁ kasmaicidapi yūyaṁ mā kathayata| ");
INSERT INTO saniso_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","anyañca yirūśālamnagaraṁ gatvā prācīnalōkēbhyaḥ pradhānayājakēbhya upādhyāyēbhyaśca bahuduḥkhabhōgastai rhatatvaṁ tr̥tīyadinē punarutthānañca mamāvaśyakam ētāḥ kathā yīśustatkālamārabhya śiṣyān jñāpayitum ārabdhavān| ");
INSERT INTO saniso_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","tadānīṁ pitarastasya karaṁ ghr̥tvā tarjayitvā kathayitumārabdhavān, hē prabhō, tat tvattō dūraṁ yātu, tvāṁ prati kadāpi na ghaṭiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","kintu sa vadanaṁ parāvartya pitaraṁ jagāda, hē vighnakārin, matsammukhād dūrībhava, tvaṁ māṁ bādhasē, īśvarīyakāryyāt mānuṣīyakāryyaṁ tubhyaṁ rōcatē| ");
INSERT INTO saniso_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","anantaraṁ yīśuḥ svīyaśiṣyān uktavān yaḥ kaścit mama paścādgāmī bhavitum icchati, sa svaṁ dāmyatu, tathā svakruśaṁ gr̥hlan matpaścādāyātu| ");
INSERT INTO saniso_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","yatō yaḥ prāṇān rakṣitumicchati, sa tān hārayiṣyati, kintu yō madarthaṁ nijaprāṇān hārayati, sa tān prāpsyati| ");
INSERT INTO saniso_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","mānuṣō yadi sarvvaṁ jagat labhatē nijapraṇān hārayati, tarhi tasya kō lābhaḥ? manujō nijaprāṇānāṁ vinimayēna vā kiṁ dātuṁ śaknōti? ");
INSERT INTO saniso_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","manujasutaḥ svadūtaiḥ sākaṁ pituḥ prabhāvēṇāgamiṣyati; tadā pratimanujaṁ svasvakarmmānusārāt phalaṁ dāsyati| ");
INSERT INTO saniso_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","ahaṁ yuṣmān tathyaṁ vacmi, sarājyaṁ manujasutam āgataṁ na paśyantō mr̥tyuṁ na svādiṣyanti, ētādr̥śāḥ katipayajanā atrāpi daṇḍāyamānāḥ santi| ");
INSERT INTO saniso_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","anantaraṁ ṣaḍdinēbhyaḥ paraṁ yīśuḥ pitaraṁ yākūbaṁ tatsahajaṁ yōhanañca gr̥hlan uccādrē rviviktasthānam āgatya tēṣāṁ samakṣaṁ rūpamanyat dadhāra| ");
INSERT INTO saniso_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","tēna tadāsyaṁ tējasvi, tadābharaṇam ālōkavat pāṇḍaramabhavat| ");
INSERT INTO saniso_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","anyacca tēna sākaṁ saṁlapantau mūsā ēliyaśca tēbhyō darśanaṁ dadatuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","tadānīṁ pitarō yīśuṁ jagāda, hē prabhō sthitiratrāsmākaṁ śubhā, yadi bhavatānumanyatē, tarhi bhavadarthamēkaṁ mūsārthamēkam ēliyārthañcaikam iti trīṇi dūṣyāṇi nirmmama| ");
INSERT INTO saniso_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ētatkathanakāla ēka ujjavalaḥ payōdastēṣāmupari chāyāṁ kr̥tavān, vāridād ēṣā nabhasīyā vāg babhūva, mamāyaṁ priyaḥ putraḥ, asmin mama mahāsantōṣa ētasya vākyaṁ yūyaṁ niśāmayata| ");
INSERT INTO saniso_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","kintu vācamētāṁ śr̥ṇvantaēva śiṣyā mr̥śaṁ śaṅkamānā nyubjā nyapatan| ");
INSERT INTO saniso_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","tadā yīśurāgatya tēṣāṁ gātrāṇi spr̥śan uvāca, uttiṣṭhata, mā bhaiṣṭa| ");
INSERT INTO saniso_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","tadānīṁ nētrāṇyunmīlya yīśuṁ vinā kamapi na dadr̥śuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","tataḥ param adrēravarōhaṇakālē yīśustān ityādidēśa, manujasutasya mr̥tānāṁ madhyādutthānaṁ yāvanna jāyatē, tāvat yuṣmābhirētaddarśanaṁ kasmaicidapi na kathayitavyaṁ| ");
INSERT INTO saniso_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","tadā śiṣyāstaṁ papracchuḥ, prathamam ēliya āyāsyatīti kuta upādhyāyairucyatē? ");
INSERT INTO saniso_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","tatō yīśuḥ pratyavādīt, ēliyaḥ prāgētya sarvvāṇi sādhayiṣyatīti satyaṁ, ");
INSERT INTO saniso_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","kintvahaṁ yuṣmān vacmi, ēliya ētya gataḥ, tē tamaparicitya tasmin yathēcchaṁ vyavajahuḥ; manujasutēnāpi tēṣāmantikē tādr̥g duḥkhaṁ bhōktavyaṁ| ");
INSERT INTO saniso_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","tadānīṁ sa majjayitāraṁ yōhanamadhi kathāmētāṁ vyāhr̥tavān, itthaṁ tacchiṣyā bubudhirē| ");
INSERT INTO saniso_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","paścāt tēṣu jananivahasyāntikamāgatēṣu kaścit manujastadantikamētya jānūnī pātayitvā kathitavān, ");
INSERT INTO saniso_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","hē prabhō, matputraṁ prati kr̥pāṁ vidadhātu, sōpasmārāmayēna bhr̥śaṁ vyathitaḥ san punaḥ puna rvahnau muhu rjalamadhyē patati| ");
INSERT INTO saniso_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","tasmād bhavataḥ śiṣyāṇāṁ samīpē tamānayaṁ kintu tē taṁ svāsthaṁ karttuṁ na śaktāḥ| ");
INSERT INTO saniso_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","tadā yīśuḥ kathitavān rē aviśvāsinaḥ, rē vipathagāminaḥ, punaḥ katikālān ahaṁ yuṣmākaṁ sannidhau sthāsyāmi? katikālān vā yuṣmān sahiṣyē? tamatra mamāntikamānayata| ");
INSERT INTO saniso_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","paścād yīśunā tarjataēva sa bhūtastaṁ vihāya gatavān, taddaṇḍaēva sa bālakō nirāmayō'bhūt| ");
INSERT INTO saniso_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","tataḥ śiṣyā guptaṁ yīśumupāgatya babhāṣirē, kutō vayaṁ taṁ bhūtaṁ tyājayituṁ na śaktāḥ? ");
INSERT INTO saniso_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","yīśunā tē prōktāḥ, yuṣmākamapratyayāt; ");
INSERT INTO saniso_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","yuṣmānahaṁ tathyaṁ vacmi yadi yuṣmākaṁ sarṣapaikamātrōpi viśvāsō jāyatē, tarhi yuṣmābhirasmin śailē tvamitaḥ sthānāt tat sthānaṁ yāhīti brūtē sa tadaiva caliṣyati, yuṣmākaṁ kimapyasādhyañca karmma na sthāsyāti| kintu prārthanōpavāsau vinaitādr̥śō bhūtō na tyājyēta| ");
INSERT INTO saniso_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","aparaṁ tēṣāṁ gālīlpradēśē bhramaṇakālē yīśunā tē gaditāḥ, manujasutō janānāṁ karēṣu samarpayiṣyatē tai rhaniṣyatē ca, ");
INSERT INTO saniso_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","kintu tr̥tīyē'hi्na ma utthāpiṣyatē, tēna tē bhr̥śaṁ duḥkhitā babhūvaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","tadanantaraṁ tēṣu kapharnāhūmnagaramāgatēṣu karasaṁgrāhiṇaḥ pitarāntikamāgatya papracchuḥ, yuṣmākaṁ guruḥ kiṁ mandirārthaṁ karaṁ na dadāti? tataḥ pitaraḥ kathitavān dadāti| ");
INSERT INTO saniso_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","tatastasmin gr̥hamadhyamāgatē tasya kathākathanāt pūrvvamēva yīśuruvāca, hē śimōn, mēdinyā rājānaḥ svasvāpatyēbhyaḥ kiṁ vidēśibhyaḥ kēbhyaḥ karaṁ gr̥hlanti? atra tvaṁ kiṁ budhyasē? tataḥ pitara uktavān, vidēśibhyaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","tadā yīśuruktavān, tarhi santānā muktāḥ santi| ");
INSERT INTO saniso_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","tathāpi yathāsmābhistēṣāmantarāyō na janyatē, tatkr̥tē jaladhēstīraṁ gatvā vaḍiśaṁ kṣipa, tēnādau yō mīna utthāsyati, taṁ ghr̥tvā tanmukhē mōcitē tōlakaikaṁ rūpyaṁ prāpsyasi, tad gr̥hītvā tava mama ca kr̥tē tēbhyō dēhi| ");
INSERT INTO saniso_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","tadānīṁ śiṣyā yīśōḥ samīpamāgatya pr̥ṣṭavantaḥ svargarājyē kaḥ śrēṣṭhaḥ? ");
INSERT INTO saniso_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","tatō yīśuḥ kṣudramēkaṁ bālakaṁ svasamīpamānīya tēṣāṁ madhyē nidhāya jagāda, ");
INSERT INTO saniso_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","yuṣmānahaṁ satyaṁ bravīmi, yūyaṁ manōvinimayēna kṣudrabālavat na santaḥ svargarājyaṁ pravēṣṭuṁ na śaknutha| ");
INSERT INTO saniso_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","yaḥ kaścid ētasya kṣudrabālakasya samamātmānaṁ namrīkarōti, saēva svargarājayē śrēṣṭhaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","yaḥ kaścid ētādr̥śaṁ kṣudrabālakamēkaṁ mama nāmni gr̥hlāti, sa māmēva gr̥hlāti| ");
INSERT INTO saniso_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","kintu yō janō mayi kr̥taviśvāsānāmētēṣāṁ kṣudraprāṇinām ēkasyāpi vidhniṁ janayati, kaṇṭhabaddhapēṣaṇīkasya tasya sāgarāgādhajalē majjanaṁ śrēyaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","vighnāt jagataḥ santāpō bhaviṣyati, vighnō'vaśyaṁ janayiṣyatē, kintu yēna manujēna vighnō janiṣyatē tasyaiva santāpō bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","tasmāt tava karaścaraṇō vā yadi tvāṁ bādhatē, tarhi taṁ chittvā nikṣipa, dvikarasya dvipadasya vā tavānaptavahnau nikṣēpāt, khañjasya vā chinnahastasya tava jīvanē pravēśō varaṁ| ");
INSERT INTO saniso_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","aparaṁ tava nētraṁ yadi tvāṁ bādhatē, tarhi tadapyutpāvya nikṣipa, dvinētrasya narakāgnau nikṣēpāt kāṇasya tava jīvanē pravēśō varaṁ| ");
INSERT INTO saniso_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","tasmādavadhaddhaṁ, ētēṣāṁ kṣudraprāṇinām ēkamapi mā tucchīkuruta, ");
INSERT INTO saniso_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","yatō yuṣmānahaṁ tathyaṁ bravīmi, svargē tēṣāṁ dūtā mama svargasthasya piturāsyaṁ nityaṁ paśyanti| ēvaṁ yē yē hāritāstān rakṣituṁ manujaputra āgacchat| ");
INSERT INTO saniso_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","yūyamatra kiṁ viviṁgghvē? kasyacid yadi śataṁ mēṣāḥ santi, tēṣāmēkō hāryyatē ca, tarhi sa ēkōnaśataṁ mēṣān vihāya parvvataṁ gatvā taṁ hāritamēkaṁ kiṁ na mr̥gayatē? ");
INSERT INTO saniso_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","yadi ca kadācit tanmēṣōddēśaṁ lamatē, tarhi yuṣmānahaṁ satyaṁ kathayāmi, sō'vipathagāmibhya ēkōnaśatamēṣēbhyōpi tadēkahētōradhikam āhlādatē| ");
INSERT INTO saniso_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","tadvad ētēṣāṁ kṣudraprāēिnām ēkōpi naśyatīti yuṣmākaṁ svargasthapitu rnābhimatam| ");
INSERT INTO saniso_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","yadyapi tava bhrātā tvayi kimapyaparādhyati, tarhi gatvā yuvayōrdvayōḥ sthitayōstasyāparādhaṁ taṁ jñāpaya| tatra sa yadi tava vākyaṁ śr̥ṇōti, tarhi tvaṁ svabhrātaraṁ prāptavān, ");
INSERT INTO saniso_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","kintu yadi na śr̥ṇōti, tarhi dvābhyāṁ tribhi rvā sākṣībhiḥ sarvvaṁ vākyaṁ yathā niścitaṁ jāyatē, tadartham ēkaṁ dvau vā sākṣiṇau gr̥hītvā yāhi| ");
INSERT INTO saniso_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","tēna sa yadi tayō rvākyaṁ na mānyatē, tarhi samājaṁ tajjñāpaya, kintu yadi samājasyāpi vākyaṁ na mānyatē,tarhi sa tava samīpē dēvapūjaka̮iva caṇḍāla̮iva ca bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","ahaṁ yuṣmān satyaṁ vadāmi, yuṣmābhiḥ pr̥thivyāṁ yad badhyatē tat svargē bhaṁtsyatē; mēdinyāṁ yat bhōcyatē, svargē'pi tat mōkṣyatē| ");
INSERT INTO saniso_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","punarahaṁ yuṣmān vadāmi, mēdinyāṁ yuṣmākaṁ yadi dvāvēkavākyībhūya kiñcit prārthayētē, tarhi mama svargasthapitrā tat tayōḥ kr̥tē sampannaṁ bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","yatō yatra dvau trayō vā mama nānni milanti, tatraivāhaṁ tēṣāṁ madhyē'smi| ");
INSERT INTO saniso_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","tadānīṁ pitarastatsamīpamāgatya kathitavān hē prabhō, mama bhrātā mama yadyaparādhyati, tarhi taṁ katikr̥tvaḥ kṣamiṣyē? ");
INSERT INTO saniso_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","kiṁ saptakr̥tvaḥ? yīśustaṁ jagāda, tvāṁ kēvalaṁ saptakr̥tvō yāvat na vadāmi, kintu saptatyā guṇitaṁ saptakr̥tvō yāvat| ");
INSERT INTO saniso_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","aparaṁ nijadāsaiḥ saha jigaṇayiṣuḥ kaścid rājēva svargarājayaṁ| ");
INSERT INTO saniso_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ārabdhē tasmin gaṇanē sārddhasahasramudrāpūritānāṁ daśasahasrapuṭakānām ēkō'ghamarṇastatsamakṣamānāyi| ");
INSERT INTO saniso_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","tasya pariśōdhanāya dravyābhāvāt pariśōdhanārthaṁ sa tadīyabhāryyāputrādisarvvasvañca vikrīyatāmiti tatprabhurādidēśa| ");
INSERT INTO saniso_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","tēna sa dāsastasya pādayōḥ patan praṇamya kathitavān , hē prabhō bhavatā ghairyyē kr̥tē mayā sarvvaṁ pariśōdhiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","tadānīṁ dāsasya prabhuḥ sakaruṇaḥ san sakalarṇaṁ kṣamitvā taṁ tatyāja| ");
INSERT INTO saniso_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","kintu tasmin dāsē bahi ryātē, tasya śataṁ mudrācaturthāṁśān yō dhārayati, taṁ sahadāsaṁ dr̥ṣdvā tasya kaṇṭhaṁ niṣpīḍya gaditavān, mama yat prāpyaṁ tat pariśōdhaya| ");
INSERT INTO saniso_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","tadā tasya sahadāsastatpādayōḥ patitvā vinīya babhāṣē, tvayā dhairyyē kr̥tē mayā sarvvaṁ pariśōdhiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","tathāpi sa tat nāṅagīkr̥tya yāvat sarvvamr̥ṇaṁ na pariśōdhitavān tāvat taṁ kārāyāṁ sthāpayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","tadā tasya sahadāsāstasyaitādr̥g ācaraṇaṁ vilōkya prabhōḥ samīpaṁ gatvā sarvvaṁ vr̥ttāntaṁ nivēdayāmāsuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","tadā tasya prabhustamāhūya jagāda, rē duṣṭa dāsa, tvayā matsannidhau prārthitē mayā tava sarvvamr̥ṇaṁ tyaktaṁ; ");
INSERT INTO saniso_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","yathā cāhaṁ tvayi karuṇāṁ kr̥tavān, tathaiva tvatsahadāsē karuṇākaraṇaṁ kiṁ tava nōcitaṁ? ");
INSERT INTO saniso_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","iti kathayitvā tasya prabhuḥ kruddhyan nijaprāpyaṁ yāvat sa na pariśōdhitavān, tāvat prahārakānāṁ karēṣu taṁ samarpitavān| ");
INSERT INTO saniso_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","yadi yūyaṁ svāntaḥkaraṇaiḥ svasvasahajānām aparādhān na kṣamadhvē, tarhi mama svargasyaḥ pitāpi yuṣmān pratītthaṁ kariṣyati| ");
INSERT INTO saniso_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","anantaram ētāsu kathāsu samāptāsu yīśu rgālīlapradēśāt prasthāya yardantīrasthaṁ yihūdāpradēśaṁ prāptaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","tadā tatpaścāt jananivahē gatē sa tatra tān nirāmayān akarōt| ");
INSERT INTO saniso_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","tadanantaraṁ phirūśinastatsamīpamāgatya pārīkṣituṁ taṁ papracchuḥ, kasmādapi kāraṇāt narēṇa svajāyā parityājyā na vā? ");
INSERT INTO saniso_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","sa pratyuvāca, prathamam īśvarō naratvēna nārītvēna ca manujān sasarja, tasmāt kathitavān, ");
INSERT INTO saniso_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","mānuṣaḥ svapitarau parityajya svapatnyām āsakṣyatē, tau dvau janāvēkāṅgau bhaviṣyataḥ, kimētad yuṣmābhi rna paṭhitam? ");
INSERT INTO saniso_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","atastau puna rna dvau tayōrēkāṅgatvaṁ jātaṁ, īśvarēṇa yacca samayujyata, manujō na tad bhindyāt| ");
INSERT INTO saniso_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","tadānīṁ tē taṁ pratyavadan, tathātvē tyājyapatraṁ dattvā svāṁ svāṁ jāyāṁ tyaktuṁ vyavasthāṁ mūsāḥ kathaṁ lilēkha? ");
INSERT INTO saniso_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","tataḥ sa kathitavān, yuṣmākaṁ manasāṁ kāṭhinyād yuṣmān svāṁ svāṁ jāyāṁ tyaktum anvamanyata kintu prathamād ēṣō vidhirnāsīt| ");
INSERT INTO saniso_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","atō yuṣmānahaṁ vadāmi, vyabhicāraṁ vinā yō nijajāyāṁ tyajēt anyāñca vivahēt, sa paradārān gacchati; yaśca tyaktāṁ nārīṁ vivahati sōpi paradārēṣu ramatē| ");
INSERT INTO saniso_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","tadā tasya śiṣyāstaṁ babhāṣirē, yadi svajāyayā sākaṁ puṁsa ētādr̥k sambandhō jāyatē, tarhi vivahanamēva na bhadraṁ| ");
INSERT INTO saniso_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","tataḥ sa uktavān, yēbhyastatsāmarthyaṁ ādāyi, tān vinānyaḥ kōpi manuja ētanmataṁ grahītuṁ na śaknōti| ");
INSERT INTO saniso_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","katipayā jananaklībaḥ katipayā narakr̥taklībaḥ svargarājyāya katipayāḥ svakr̥taklībāśca santi, yē grahītuṁ śaknuvanti tē gr̥hlantu| ");
INSERT INTO saniso_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","aparam yathā sa śiśūnāṁ gātrēṣu hastaṁ datvā prārthayatē, tadarthaṁ tatsamīṁpaṁ śiśava ānīyanta, tata ānayitr̥n śiṣyāstiraskr̥tavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","kintu yīśuruvāca, śiśavō madantikam āgacchantu, tān mā vārayata, ētādr̥śāṁ śiśūnāmēva svargarājyaṁ| ");
INSERT INTO saniso_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","tataḥ sa tēṣāṁ gātrēṣu hastaṁ datvā tasmāt sthānāt pratasthē| ");
INSERT INTO saniso_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","aparam ēka āgatya taṁ papraccha, hē paramagurō, anantāyuḥ prāptuṁ mayā kiṁ kiṁ satkarmma karttavyaṁ? ");
INSERT INTO saniso_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","tataḥ sa uvāca, māṁ paramaṁ kutō vadasi? vinēścaraṁ na kōpi paramaḥ, kintu yadyanantāyuḥ prāptuṁ vāñchasi, tarhyājñāḥ pālaya| ");
INSERT INTO saniso_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","tadā sa pr̥ṣṭavān, kāḥ kā ājñāḥ? tatō yīśuḥ kathitavān, naraṁ mā hanyāḥ, paradārān mā gacchēḥ, mā cōrayēḥ, mr̥ṣāsākṣyaṁ mā dadyāḥ, ");
INSERT INTO saniso_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","nijapitarau saṁmanyasva, svasamīpavāsini svavat prēma kuru| ");
INSERT INTO saniso_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","sa yuvā kathitavān, ā bālyād ētāḥ pālayāmi, idānīṁ kiṁ nyūnamāstē? ");
INSERT INTO saniso_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","tatō yīśuravadat, yadi siddhō bhavituṁ vāñchasi, tarhi gatvā nijasarvvasvaṁ vikrīya daridrēbhyō vitara, tataḥ svargē vittaṁ lapsyasē; āgaccha, matpaścādvarttī ca bhava| ");
INSERT INTO saniso_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ētāṁ vācaṁ śrutvā sa yuvā svīyabahusampattē rviṣaṇaḥ san calitavān| ");
INSERT INTO saniso_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","tadā yīśuḥ svaśiṣyān avadat, dhanināṁ svargarājyapravēśō mahāduṣkara iti yuṣmānahaṁ tathyaṁ vadāmi| ");
INSERT INTO saniso_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","punarapi yuṣmānahaṁ vadāmi, dhanināṁ svargarājyapravēśāt sūcīchidrēṇa mahāṅgagamanaṁ sukaraṁ| ");
INSERT INTO saniso_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","iti vākyaṁ niśamya śiṣyā aticamatkr̥tya kathayāmāsuḥ; tarhi kasya paritrāṇaṁ bhavituṁ śaknōti? ");
INSERT INTO saniso_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","tadā sa tān dr̥ṣdvā kathayāmāsa, tat mānuṣāṇāmaśakyaṁ bhavati, kintvīśvarasya sarvvaṁ śakyam| ");
INSERT INTO saniso_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","tadā pitarastaṁ gaditavān, paśya, vayaṁ sarvvaṁ parityajya bhavataḥ paścādvarttinō 'bhavāma; vayaṁ kiṁ prāpsyāmaḥ? ");
INSERT INTO saniso_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","tatō yīśuḥ kathitavān, yuṣmānahaṁ tathyaṁ vadāmi, yūyaṁ mama paścādvarttinō jātā iti kāraṇāt navīnasr̥ṣṭikālē yadā manujasutaḥ svīyaiścaryyasiṁhāsana upavēkṣyati, tadā yūyamapi dvādaśasiṁhāsanēṣūpaviśya isrāyēlīyadvādaśavaṁśānāṁ vicāraṁ kariṣyatha| ");
INSERT INTO saniso_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","anyacca yaḥ kaścit mama nāmakāraṇāt gr̥haṁ vā bhrātaraṁ vā bhaginīṁ vā pitaraṁ vā mātaraṁ vā jāyāṁ vā bālakaṁ vā bhūmiṁ parityajati, sa tēṣāṁ śataguṇaṁ lapsyatē, anantāyumō'dhikāritvañca prāpsyati| ");
INSERT INTO saniso_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","kintu agrīyā anēkē janāḥ paścāt, paścātīyāścānēkē lōkā agrē bhaviṣyanti| ");
INSERT INTO saniso_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","svargarājyam ētādr̥śā kēnacid gr̥hasyēna samaṁ, yō'tiprabhātē nijadrākṣākṣētrē kr̥ṣakān niyōktuṁ gatavān| ");
INSERT INTO saniso_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","paścāt taiḥ sākaṁ dinaikabhr̥tiṁ mudrācaturthāṁśaṁ nirūpya tān drākṣākṣētraṁ prērayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","anantaraṁ praharaikavēlāyāṁ gatvā haṭṭē katipayān niṣkarmmakān vilōkya tānavadat, ");
INSERT INTO saniso_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","yūyamapi mama drākṣākṣētraṁ yāta, yuṣmabhyamahaṁ yōgyabhr̥tiṁ dāsyāmi, tatastē vavrajuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","punaśca sa dvitīyatr̥tīyayōḥ praharayō rbahi rgatvā tathaiva kr̥tavān| ");
INSERT INTO saniso_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","tatō daṇḍadvayāvaśiṣṭāyāṁ vēlāyāṁ bahi rgatvāparān katipayajanān niṣkarmmakān vilōkya pr̥ṣṭavān, yūyaṁ kimartham atra sarvvaṁ dinaṁ niṣkarmmāṇastiṣṭhatha? ");
INSERT INTO saniso_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","tē pratyavadan, asmān na kōpi karmamaṇi niyuṁktē| tadānīṁ sa kathitavān, yūyamapi mama drākṣākṣētraṁ yāta, tēna yōgyāṁ bhr̥tiṁ lapsyatha| ");
INSERT INTO saniso_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","tadanantaraṁ sandhyāyāṁ satyāṁ saēva drākṣākṣētrapatiradhyakṣaṁ gadivān, kr̥ṣakān āhūya śēṣajanamārabhya prathamaṁ yāvat tēbhyō bhr̥tiṁ dēhi| ");
INSERT INTO saniso_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","tēna yē daṇḍadvayāvasthitē samāyātāstēṣām ēkaikō janō mudrācaturthāṁśaṁ prāpnōt| ");
INSERT INTO saniso_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","tadānīṁ prathamaniyuktā janā āgatyānumitavantō vayamadhikaṁ prapsyāmaḥ, kintu tairapi mudrācaturthāṁśō'lābhi| ");
INSERT INTO saniso_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","tatastē taṁ gr̥hītvā tēna kṣētrapatinā sākaṁ vāgyuddhaṁ kurvvantaḥ kathayāmāsuḥ, ");
INSERT INTO saniso_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","vayaṁ kr̥tsnaṁ dinaṁ tāpaklēśau sōḍhavantaḥ, kintu paścātāyā sē janā daṇḍadvayamātraṁ pariśrāntavantastē'smābhiḥ samānāṁśāḥ kr̥tāḥ| ");
INSERT INTO saniso_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","tataḥ sa tēṣāmēkaṁ pratyuvāca, hē vatsa, mayā tvāṁ prati kōpyanyāyō na kr̥taḥ kiṁ tvayā matsamakṣaṁ mudrācaturthāṁśō nāṅgīkr̥taḥ? ");
INSERT INTO saniso_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","tasmāt tava yat prāpyaṁ tadādāya yāhi, tubhyaṁ yati, paścātīyaniyuktalōkāyāpi tati dātumicchāmi| ");
INSERT INTO saniso_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","svēcchayā nijadravyavyavaharaṇaṁ kiṁ mayā na karttavyaṁ? mama dātr̥tvāt tvayā kim īrṣyādr̥ṣṭiḥ kriyatē? ");
INSERT INTO saniso_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","ittham agrīyalōkāḥ paścatīyā bhaviṣyanti, paścātīyajanāścagrīyā bhaviṣyanti, ahūtā bahavaḥ kintvalpē manōbhilaṣitāḥ| ");
INSERT INTO saniso_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","tadanantaraṁ yīśu ryirūśālamnagaraṁ gacchan mārgamadhyē śiṣyān ēkāntē vabhāṣē, ");
INSERT INTO saniso_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","paśya vayaṁ yirūśālamnagaraṁ yāmaḥ, tatra pradhānayājakādhyāpakānāṁ karēṣu manuṣyaputraḥ samarpiṣyatē; ");
INSERT INTO saniso_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","tē ca taṁ hantumājñāpya tiraskr̥tya vētrēṇa praharttuṁ kruśē dhātayituñcānyadēśīyānāṁ karēṣu samarpayiṣyanti, kintu sa tr̥tīyadivasē śmaśānād utthāpiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","tadānīṁ sivadīyasya nārī svaputrāvādāya yīśōḥ samīpam ētya praṇamya kañcanānugrahaṁ taṁ yayācē| ");
INSERT INTO saniso_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","tadā yīśustāṁ prōktavān, tvaṁ kiṁ yācasē? tataḥ sā babhāṣē, bhavatō rājatvē mamānayōḥ sutayōrēkaṁ bhavaddakṣiṇapārśvē dvitīyaṁ vāmapārśva upavēṣṭum ājñāpayatu| ");
INSERT INTO saniso_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","yīśuḥ pratyuvāca, yuvābhyāṁ yad yācyatē, tanna budhyatē, ahaṁ yēna kaṁsēna pāsyāmi yuvābhyāṁ kiṁ tēna pātuṁ śakyatē? ahañca yēna majjēnēna majjiṣyē, yuvābhyāṁ kiṁ tēna majjayituṁ śakyatē? tē jagaduḥ śakyatē| ");
INSERT INTO saniso_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","tadā sa uktavān, yuvāṁ mama kaṁsēnāvaśyaṁ pāsyathaḥ, mama majjanēna ca yuvāmapi majjiṣyēthē, kintu yēṣāṁ kr̥tē mattātēna nirūpitam idaṁ tān vihāyānyaṁ kamapi maddakṣiṇapārśvē vāmapārśvē ca samupavēśayituṁ mamādhikārō nāsti| ");
INSERT INTO saniso_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ētāṁ kathāṁ śrutvānyē daśaśiṣyāstau bhrātarau prati cukupuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","kintu yīśuḥ svasamīpaṁ tānāhūya jagāda, anyadēśīyalōkānāṁ narapatayastān adhikurvvanti, yē tu mahāntastē tān śāsati, iti yūyaṁ jānītha| ");
INSERT INTO saniso_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","kintu yuṣmākaṁ madhyē na tathā bhavēt, yuṣmākaṁ yaḥ kaścit mahān bubhūṣati, sa yuṣmān sēvēta; ");
INSERT INTO saniso_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","yaśca yuṣmākaṁ madhyē mukhyō bubhūṣati, sa yuṣmākaṁ dāsō bhavēt| ");
INSERT INTO saniso_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","itthaṁ manujaputraḥ sēvyō bhavituṁ nahi, kintu sēvituṁ bahūnāṁ paritrāṇamūlyārthaṁ svaprāṇān dātuñcāgataḥ| ");
INSERT INTO saniso_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","anantaraṁ yirīhōnagarāt tēṣāṁ bahirgamanasamayē tasya paścād bahavō lōkā vavrajuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","aparaṁ vartmapārśva upaviśantau dvāvandhau tēna mārgēṇa yīśō rgamanaṁ niśamya prōccaiḥ kathayāmāsatuḥ, hē prabhō dāyūdaḥ santāna, āvayō rdayāṁ vidhēhi| ");
INSERT INTO saniso_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","tatō lōkāḥ sarvvē tuṣṇīmbhavatamityuktvā tau tarjayāmāsuḥ; tathāpi tau punaruccaiḥ kathayāmāsatuḥ hē prabhō dāyūdaḥ santāna, āvāṁ dayasva| ");
INSERT INTO saniso_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","tadānīṁ yīśuḥ sthagitaḥ san tāvāhūya bhāṣitavān, yuvayōḥ kr̥tē mayā kiṁ karttarvyaṁ? yuvāṁ kiṁ kāmayēthē? ");
INSERT INTO saniso_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","tadā tāvuktavantau, prabhō nētrāṇi nau prasannāni bhavēyuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","tadānīṁ yīśustau prati pramannaḥ san tayō rnētrāṇi pasparśa, tēnaiva tau suvīkṣāñcakrātē tatpaścāt jagmutuśca| ");
INSERT INTO saniso_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","anantaraṁ tēṣu yirūśālamnagarasya samīpavērttinō jaitunanāmakadharādharasya samīpasthtiṁ baitphagigrāmam āgatēṣu, yīśuḥ śiṣyadvayaṁ prēṣayan jagāda, ");
INSERT INTO saniso_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","yuvāṁ sammukhasthagrāmaṁ gatvā baddhāṁ yāṁ savatsāṁ garddabhīṁ haṭhāt prāpsyathaḥ, tāṁ mōcayitvā madantikam ānayataṁ| ");
INSERT INTO saniso_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","tatra yadi kaścit kiñcid vakṣyati, tarhi vadiṣyathaḥ, ētasyāṁ prabhōḥ prayōjanamāstē, tēna sa tatkṣaṇāt prahēṣyati| ");
INSERT INTO saniso_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","sīyōnaḥ kanyakāṁ yūyaṁ bhāṣadhvamiti bhāratīṁ| paśya tē namraśīlaḥ san nr̥pa āruhya gardabhīṁ| arthādāruhya tadvatsamāyāsyati tvadantikaṁ| ");
INSERT INTO saniso_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","bhaviṣyadvādinōktaṁ vacanamidaṁ tadā saphalamabhūt| ");
INSERT INTO saniso_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","anantaraṁ tau śṣyiौ yīśō ryathānidēśaṁ taṁ grāmaṁ gatvā ");
INSERT INTO saniso_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","gardabhīṁ tadvatsañca samānītavantau, paścāt tadupari svīyavasanānī pātayitvā tamārōhayāmāsatuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","tatō bahavō lōkā nijavasanāni pathi prasārayitumārēbhirē, katipayā janāśca pādapaparṇādikaṁ chitvā pathi vistārayāmāsuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","agragāminaḥ paścādgāminaśca manujā uccairjaya jaya dāyūdaḥ santānēti jagaduḥ paramēśvarasya nāmnā ya āyāti sa dhanyaḥ, sarvvōparisthasvargēpi jayati| ");
INSERT INTO saniso_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","itthaṁ tasmin yirūśālamaṁ praviṣṭē kō'yamiti kathanāt kr̥tsnaṁ nagaraṁ cañcalamabhavat| ");
INSERT INTO saniso_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","tatra lōkōḥ kathayāmāsuḥ, ēṣa gālīlpradēśīya-nāsaratīya-bhaviṣyadvādī yīśuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","anantaraṁ yīśurīśvarasya mandiraṁ praviśya tanmadhyāt krayavikrayiṇō vahiścakāra; vaṇijāṁ mudrāsanānī kapōtavikrayiṇāñcasanānī ca nyuvjayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","aparaṁ tānuvāca, ēṣā lipirāstē, \"mama gr̥haṁ prārthanāgr̥hamiti vikhyāsyati\", kintu yūyaṁ tad dasyūnāṁ gahvaraṁ kr̥tavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","tadanantaram andhakhañcalōkāstasya samīpamāgatāḥ, sa tān nirāmayān kr̥tavān| ");
INSERT INTO saniso_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","yadā pradhānayājakā adhyāpakāśca tēna kr̥tānyētāni citrakarmmāṇi dadr̥śuḥ, jaya jaya dāyūdaḥ santāna, mandirē bālakānām ētādr̥śam uccadhvaniṁ śuśruvuśca, tadā mahākruddhā babhūvaḥ, ");
INSERT INTO saniso_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","taṁ papracchuśca, imē yad vadanti, tat kiṁ tvaṁ śr̥ṇōṣi? tatō yīśustān avōcat, satyam; stanyapāyiśiśūnāñca bālakānāñca vaktrataḥ| svakīyaṁ mahimānaṁ tvaṁ saṁprakāśayasi svayaṁ| ētadvākyaṁ yūyaṁ kiṁ nāpaṭhata? ");
INSERT INTO saniso_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","tatastān vihāya sa nagarād baithaniyāgrāmaṁ gatvā tatra rajanīṁ yāpayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","anantaraṁ prabhātē sati yīśuḥ punarapi nagaramāgacchan kṣudhārttō babhūva| ");
INSERT INTO saniso_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","tatō mārgapārśva uḍumbaravr̥kṣamēkaṁ vilōkya tatsamīpaṁ gatvā patrāṇi vinā kimapi na prāpya taṁ pādapaṁ prōvāca, adyārabhya kadāpi tvayi phalaṁ na bhavatu; tēna tatkṣaṇāt sa uḍumbaramāhīruhaḥ śuṣkatāṁ gataḥ| ");
INSERT INTO saniso_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","tad dr̥ṣṭvā śiṣyā āścaryyaṁ vijñāya kathayāmāsuḥ, āḥ, uḍumvarapādapō'titūrṇaṁ śuṣkō'bhavat| ");
INSERT INTO saniso_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","tatō yīśustānuvāca, yuṣmānahaṁ satyaṁ vadāmi, yadi yūyamasandigdhāḥ pratītha, tarhi yūyamapi kēvalōḍumvarapādapaṁ pratītthaṁ karttuṁ śakṣyatha, tanna, tvaṁ calitvā sāgarē patēti vākyaṁ yuṣmābhirasmina śailē prōktēpi tadaiva tad ghaṭiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","tathā viśvasya prārthya yuṣmābhi ryad yāciṣyatē, tadēva prāpsyatē| ");
INSERT INTO saniso_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","anantaraṁ mandiraṁ praviśyōpadēśanasamayē tatsamīpaṁ pradhānayājakāḥ prācīnalōkāścāgatya papracchuḥ, tvayā kēna sāmarthyanaitāni karmmāṇi kriyantē? kēna vā tubhyamētāni sāmarthyāni dattāni? ");
INSERT INTO saniso_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","tatō yīśuḥ pratyavadat, ahamapi yuṣmān vācamēkāṁ pr̥cchāmi, yadi yūyaṁ taduttaraṁ dātuṁ śakṣyatha, tadā kēna sāmarthyēna karmmāṇyētāni karōmi, tadahaṁ yuṣmān vakṣyāmi| ");
INSERT INTO saniso_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","yōhanō majjanaṁ kasyājñayābhavat? kimīśvarasya manuṣyasya vā? tatastē parasparaṁ vivicya kathayāmāsuḥ, yadīśvarasyēti vadāmastarhi yūyaṁ taṁ kutō na pratyaita? vācamētāṁ vakṣyati| ");
INSERT INTO saniso_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","manuṣyasyēti vaktumapi lōkēbhyō bibhīmaḥ, yataḥ sarvvairapi yōhan bhaviṣyadvādīti jñāyatē| ");
INSERT INTO saniso_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","tasmāt tē yīśuṁ pratyavadan, tad vayaṁ na vidmaḥ| tadā sa tānuktavān, tarhi kēna sāmarathyēna karmmāṇyētānyahaṁ karōmi, tadapyahaṁ yuṣmān na vakṣyāmi| ");
INSERT INTO saniso_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","kasyacijjanasya dvau sutāvāstāṁ sa ēkasya sutasya samīpaṁ gatvā jagāda, hē suta, tvamadya mama drākṣākṣētrē karmma kartuṁ vraja| ");
INSERT INTO saniso_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","tataḥ sa uktavān, na yāsyāmi, kintu śēṣē'nutapya jagāma| ");
INSERT INTO saniso_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","anantaraṁ sōnyasutasya samīpaṁ gatvā tathaiva kathtivān; tataḥ sa pratyuvāca, mahēccha yāmi, kintu na gataḥ| ");
INSERT INTO saniso_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","ētayōḥ putrayō rmadhyē piturabhimataṁ kēna pālitaṁ? yuṣmābhiḥ kiṁ budhyatē? tatastē pratyūcuḥ, prathamēna puुtrēṇa| tadānīṁ yīśustānuvāca, ahaṁ yuṣmān tathyaṁ vadāmi, caṇḍālā gaṇikāśca yuṣmākamagrata īśvarasya rājyaṁ praviśanti| ");
INSERT INTO saniso_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","yatō yuṣmākaṁ samīpaṁ yōhani dharmmapathēnāgatē yūyaṁ taṁ na pratītha, kintu caṇḍālā gaṇikāśca taṁ pratyāyan, tad vilōkyāpi yūyaṁ pratyētuṁ nākhidyadhvaṁ| ");
INSERT INTO saniso_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","aparamēkaṁ dr̥ṣṭāntaṁ śr̥ṇuta, kaścid gr̥hasthaḥ kṣētrē drākṣālatā rōpayitvā taccaturdikṣu vāraṇīṁ vidhāya tanmadhyē drākṣāyantraṁ sthāpitavān, māñcañca nirmmitavān, tataḥ kr̥ṣakēṣu tat kṣētraṁ samarpya svayaṁ dūradēśaṁ jagāma| ");
INSERT INTO saniso_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","tadanantaraṁ phalasamaya upasthitē sa phalāni prāptuṁ kr̥ṣīvalānāṁ samīpaṁ nijadāsān prēṣayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","kintu kr̥ṣīvalāstasya tān dāsēyān dhr̥tvā kañcana prahr̥tavantaḥ, kañcana pāṣāṇairāhatavantaḥ, kañcana ca hatavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","punarapi sa prabhuḥ prathamatō'dhikadāsēyān prēṣayāmāsa, kintu tē tān pratyapi tathaiva cakruḥ| ");
INSERT INTO saniso_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","anantaraṁ mama sutē gatē taṁ samādariṣyantē, ityuktvā śēṣē sa nijasutaṁ tēṣāṁ sannidhiṁ prēṣayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","kintu tē kr̥ṣīvalāḥ sutaṁ vīkṣya parasparam iti mantrayitum ārēbhirē, ayamuttarādhikārī vayamēnaṁ nihatyāsyādhikāraṁ svavaśīkariṣyāmaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","paścāt tē taṁ dhr̥tvā drākṣākṣētrād bahiḥ pātayitvābadhiṣuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","yadā sa drākṣākṣētrapatirāgamiṣyati, tadā tān kr̥ṣīvalān kiṁ kariṣyati? ");
INSERT INTO saniso_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","tatastē pratyavadan, tān kaluṣiṇō dāruṇayātanābhirāhaniṣyati, yē ca samayānukramāt phalāni dāsyanti, tādr̥śēṣu kr̥ṣīvalēṣu kṣētraṁ samarpayiṣyati| ");
INSERT INTO saniso_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","tadā yīśunā tē gaditāḥ, grahaṇaṁ na kr̥taṁ yasya pāṣāṇasya nicāyakaiḥ| pradhānaprastaraḥ kōṇē saēva saṁbhaviṣyati| ētat parēśituḥ karmmāsmadr̥ṣṭāvadbhutaṁ bhavēt| dharmmagranthē likhitamētadvacanaṁ yuṣmābhiḥ kiṁ nāpāṭhi? ");
INSERT INTO saniso_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","tasmādahaṁ yuṣmān vadāmi, yuṣmatta īśvarīyarājyamapanīya phalōtpādayitranyajātayē dāyiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","yō jana ētatpāṣāṇōpari patiṣyati, taṁ sa bhaṁkṣyatē, kintvayaṁ pāṣāṇō yasyōpari patiṣyati, taṁ sa dhūlivat cūrṇīkariṣyati| ");
INSERT INTO saniso_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","tadānīṁ prādhanayājakāḥ phirūśinaśca tasyēmāṁ dr̥ṣṭāntakathāṁ śrutvā sō'smānuddiśya kathitavān, iti vijñāya taṁ dharttuṁ cēṣṭitavantaḥ; ");
INSERT INTO saniso_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","kintu lōkēbhyō bibhyuḥ, yatō lōkaiḥ sa bhaviṣyadvādītyajñāyi| ");
INSERT INTO saniso_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","anantaraṁ yīśuḥ punarapi dr̥ṣṭāntēna tān avādīt, ");
INSERT INTO saniso_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","svargīyarājyam ētādr̥śasya nr̥patēḥ samaṁ, yō nija putraṁ vivāhayan sarvvān nimantritān ānētuṁ dāsēyān prahitavān, ");
INSERT INTO saniso_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","kintu tē samāgantuṁ nēṣṭavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","tatō rājā punarapi dāsānanyān ityuktvā prēṣayāmāsa, nimantritān vadata, paśyata, mama bhējyamāsāditamāstē, nijavṭaṣādipuṣṭajantūn mārayitvā sarvvaṁ khādyadravyamāsāditavān, yūyaṁ vivāhamāgacchata| ");
INSERT INTO saniso_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","tathapi tē tucchīkr̥tya kēcit nijakṣētraṁ kēcid vāṇijyaṁ prati svasvamārgēṇa calitavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","anyē lōkāstasya dāsēyān dhr̥tvā daurātmyaṁ vyavahr̥tya tānavadhiṣuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","anantaraṁ sa nr̥patistāṁ vārttāṁ śrutvā krudhyan sainyāni prahitya tān ghātakān hatvā tēṣāṁ nagaraṁ dāhayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","tataḥ sa nijadāsēyān babhāṣē, vivāhīyaṁ bhōjyamāsāditamāstē, kintu nimantritā janā ayōgyāḥ| ");
INSERT INTO saniso_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","tasmād yūyaṁ rājamārgaṁ gatvā yāvatō manujān paśyata, tāvataēva vivāhīyabhōjyāya nimantrayata| ");
INSERT INTO saniso_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","tadā tē dāsēyā rājamārgaṁ gatvā bhadrān abhadrān vā yāvatō janān dadr̥śuḥ, tāvataēva saṁgr̥hyānayan; tatō'bhyāgatamanujai rvivāhagr̥ham apūryyata| ");
INSERT INTO saniso_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","tadānīṁ sa rājā sarvvānabhyāgatān draṣṭum abhyantaramāgatavān; tadā tatra vivāhīyavasanahīnamēkaṁ janaṁ vīkṣya taṁ jagād, ");
INSERT INTO saniso_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","hē mitra,tvaṁ vivāhīyavasanaṁ vinā kathamatra praviṣṭavān? tēna sa niruttarō babhūva| ");
INSERT INTO saniso_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","tadā rājā nijānucarān avadat, ētasya karacaraṇān baddhā yatra rōdanaṁ dantairdantagharṣaṇañca bhavati, tatra vahirbhūtatamisrē taṁ nikṣipata| ");
INSERT INTO saniso_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","itthaṁ bahava āhūtā alpē manōbhimatāḥ| ");
INSERT INTO saniso_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","anantaraṁ phirūśinaḥ pragatya yathā saṁlāpēna tam unmāthē pātayēyustathā mantrayitvā ");
INSERT INTO saniso_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","hērōdīyamanujaiḥ sākaṁ nijaśiṣyagaṇēna taṁ prati kathayāmāsuḥ, hē gurō, bhavān satyaḥ satyamīśvarīyamārgamupadiśati, kamapi mānuṣaṁ nānurudhyatē, kamapi nāpēkṣatē ca, tad vayaṁ jānīmaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","ataḥ kaisarabhūpāya karō'smākaṁ dātavyō na vā? atra bhavatā kiṁ budhyatē? tad asmān vadatu| ");
INSERT INTO saniso_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","tatō yīśustēṣāṁ khalatāṁ vijñāya kathitavān, rē kapaṭinaḥ yuyaṁ kutō māṁ parikṣadhvē? ");
INSERT INTO saniso_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","tatkaradānasya mudrāṁ māṁ darśayata| tadānīṁ taistasya samīpaṁ mudrācaturthabhāga ānītē ");
INSERT INTO saniso_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","sa tān papraccha, atra kasyēyaṁ mūrtti rnāma cāstē? tē jagaduḥ, kaisarabhūpasya| ");
INSERT INTO saniso_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","tataḥ sa uktavāna, kaisarasya yat tat kaisarāya datta, īśvarasya yat tad īśvarāya datta| ");
INSERT INTO saniso_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","iti vākyaṁ niśamya tē vismayaṁ vijñāya taṁ vihāya calitavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","tasminnahani sidūkinō'rthāt śmaśānāt nōtthāsyantīti vākyaṁ yē vadanti, tē yīśēाrantikam āgatya papracchuḥ, ");
INSERT INTO saniso_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","hē gurō, kaścinmanujaścēt niḥsantānaḥ san prāṇān tyajati, tarhi tasya bhrātā tasya jāyāṁ vyuhya bhrātuḥ santānam utpādayiṣyatīti mūsā ādiṣṭavān| ");
INSERT INTO saniso_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","kintvasmākamatra kē'pi janāḥ saptasahōdarā āsan, tēṣāṁ jyēṣṭha ēkāṁ kanyāṁ vyavahāt, aparaṁ prāṇatyāgakālē svayaṁ niḥsantānaḥ san tāṁ striyaṁ svabhrātari samarpitavān, ");
INSERT INTO saniso_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","tatō dvitīyādisaptamāntāśca tathaiva cakruḥ| ");
INSERT INTO saniso_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","śēṣē sāpī nārī mamāra| ");
INSERT INTO saniso_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","mr̥tānām utthānasamayē tēṣāṁ saptānāṁ madhyē sā nārī kasya bhāryyā bhaviṣyati? yasmāt sarvvaēva tāṁ vyavahan| ");
INSERT INTO saniso_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","tatō yīśuḥ pratyavādīt, yūyaṁ dharmmapustakam īśvarīyāṁ śaktiñca na vijñāya bhrāntimantaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","utthānaprāptā lōkā na vivahanti, na ca vācā dīyantē, kintvīśvarasya svargasthadūtānāṁ sadr̥śā bhavanti| ");
INSERT INTO saniso_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","aparaṁ mr̥tānāmutthānamadhi yuṣmān pratīyamīśvarōktiḥ, ");
INSERT INTO saniso_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","\"ahamibrāhīma īśvara ishāka īśvarō yākūba īśvara\" iti kiṁ yuṣmābhi rnāpāṭhi? kintvīśvarō jīvatām īśvara:, sa mr̥tānāmīśvarō nahi| ");
INSERT INTO saniso_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","iti śrutvā sarvvē lōkāstasyōpadēśād vismayaṁ gatāḥ| ");
INSERT INTO saniso_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","anantaraṁ sidūkinām niruttaratvavārtāṁ niśamya phirūśina ēkatra militavantaḥ, ");
INSERT INTO saniso_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","tēṣāmēkō vyavasthāpakō yīśuṁ parīkṣituṁ papaccha, ");
INSERT INTO saniso_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","hē gurō vyavasthāśāstramadhyē kājñā śrēṣṭhā? ");
INSERT INTO saniso_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","tatō yīśuruvāca, tvaṁ sarvvāntaḥkaraṇaiḥ sarvvaprāṇaiḥ sarvvacittaiśca sākaṁ prabhau paramēśvarē prīyasva, ");
INSERT INTO saniso_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ēṣā prathamamahājñā| tasyāḥ sadr̥śī dvitīyājñaiṣā, ");
INSERT INTO saniso_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","tava samīpavāsini svātmanīva prēma kuru| ");
INSERT INTO saniso_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","anayō rdvayōrājñayōḥ kr̥tsnavyavasthāyā bhaviṣyadvaktr̥granthasya ca bhārastiṣṭhati| ");
INSERT INTO saniso_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","anantaraṁ phirūśinām ēkatra sthitikālē yīśustān papraccha, ");
INSERT INTO saniso_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","khrīṣṭamadhi yuṣmākaṁ kīdr̥gbōdhō jāyatē? sa kasya santānaḥ? tatastē pratyavadan, dāyūdaḥ santānaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","tadā sa uktavān, tarhi dāyūd katham ātmādhiṣṭhānēna taṁ prabhuṁ vadati ? ");
INSERT INTO saniso_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","yathā mama prabhumidaṁ vākyamavadat paramēśvaraḥ| tavārīn pādapīṭhaṁ tē yāvannahi karōmyahaṁ| tāvat kālaṁ madīyē tvaṁ dakṣapārśva upāviśa| atō yadi dāyūd taṁ prabhuṁ vadati, rtiha sa kathaṁ tasya santānō bhavati? ");
INSERT INTO saniso_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","tadānīṁ tēṣāṁ kōpi tadvākyasya kimapyuttaraṁ dātuṁ nāśaknōt; ");
INSERT INTO saniso_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","taddinamārabhya taṁ kimapi vākyaṁ praṣṭuṁ kasyāpi sāhasō nābhavat| ");
INSERT INTO saniso_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","anantaraṁ yīśu rjananivahaṁ śiṣyāṁścāvadat, ");
INSERT INTO saniso_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","adhyāpakāḥ phirūśinaśca mūsāsanē upaviśanti, ");
INSERT INTO saniso_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","atastē yuṣmān yadyat mantum ājñāpayanti, tat manyadhvaṁ pālayadhvañca, kintu tēṣāṁ karmmānurūpaṁ karmma na kurudhvaṁ; yatastēṣāṁ vākyamātraṁ sāraṁ kāryyē kimapi nāsti| ");
INSERT INTO saniso_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","tē durvvahān gurutarān bhārān badvvā manuṣyāṇāṁ skandhēpari samarpayanti, kintu svayamaṅgulyaikayāpi na cālayanti| ");
INSERT INTO saniso_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","kēvalaṁ lōkadarśanāya sarvvakarmmāṇi kurvvanti; phalataḥ paṭṭabandhān prasāryya dhārayanti, svavastrēṣu ca dīrghagranthīn dhārayanti; ");
INSERT INTO saniso_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","bhōjanabhavana uccasthānaṁ, bhajanabhavanē pradhānamāsanaṁ, ");
INSERT INTO saniso_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","haṭṭhē namaskāraṁ gururiti sambōdhanañcaitāni sarvvāṇi vāñchanti| ");
INSERT INTO saniso_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","kintu yūyaṁ gurava iti sambōdhanīyā mā bhavata, yatō yuṣmākam ēkaḥ khrīṣṭaēva guru ");
INSERT INTO saniso_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ryūyaṁ sarvvē mithō bhrātaraśca| punaḥ pr̥thivyāṁ kamapi pitēti mā sambudhyadhvaṁ, yatō yuṣmākamēkaḥ svargasthaēva pitā| ");
INSERT INTO saniso_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","yūyaṁ nāyakēti sambhāṣitā mā bhavata, yatō yuṣmākamēkaḥ khrīṣṭaēva nāyakaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","aparaṁ yuṣmākaṁ madhyē yaḥ pumān śrēṣṭhaḥ sa yuṣmān sēviṣyatē| ");
INSERT INTO saniso_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","yatō yaḥ svamunnamati, sa nataḥ kariṣyatē; kintu yaḥ kaścit svamavanataṁ karōti, sa unnataḥ kariṣyatē| ");
INSERT INTO saniso_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","hanta kapaṭina upādhyāyāḥ phirūśinaśca, yūyaṁ manujānāṁ samakṣaṁ svargadvāraṁ rundha, yūyaṁ svayaṁ tēna na praviśatha, pravivikṣūnapi vārayatha| vata kapaṭina upādhyāyāḥ phirūśinaśca yūyaṁ chalād dīrghaṁ prārthya vidhavānāṁ sarvvasvaṁ grasatha, yuṣmākaṁ ghōrataradaṇḍō bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","hanta kapaṭina upādhyāyāḥ phirūśinaśca, yūyamēkaṁ svadharmmāvalambinaṁ karttuṁ sāgaraṁ bhūmaṇḍalañca pradakṣiṇīkurutha, ");
INSERT INTO saniso_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","kañcana prāpya svatō dviguṇanarakabhājanaṁ taṁ kurutha| ");
INSERT INTO saniso_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","vata andhapathadarśakāḥ sarvvē, yūyaṁ vadatha, mandirasya śapathakaraṇāt kimapi na dēyaṁ; kintu mandirasthasuvarṇasya śapathakaraṇād dēyaṁ| ");
INSERT INTO saniso_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","hē mūḍhā hē andhāḥ suvarṇaṁ tatsuvarṇapāvakamandiram ētayōrubhayō rmadhyē kiṁ śrēyaḥ? ");
INSERT INTO saniso_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","anyacca vadatha, yajñavēdyāḥ śapathakaraṇāt kimapi na dēyaṁ, kintu taduparisthitasya naivēdyasya śapathakaraṇād dēyaṁ| ");
INSERT INTO saniso_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","hē mūḍhā hē andhāḥ, naivēdyaṁ tannaivēdyapāvakavēdirētayōrubhayō rmadhyē kiṁ śrēyaḥ? ");
INSERT INTO saniso_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ataḥ kēnacid yajñavēdyāḥ śapathē kr̥tē taduparisthasya sarvvasya śapathaḥ kriyatē| ");
INSERT INTO saniso_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","kēnacit mandirasya śapathē kr̥tē mandiratannivāsinōḥ śapathaḥ kriyatē| ");
INSERT INTO saniso_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","kēnacit svargasya śapathē kr̥tē īśvarīyasiṁhāsanataduparyyupaviṣṭayōḥ śapathaḥ kriyatē| ");
INSERT INTO saniso_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","hanta kapaṭina upādhyāyāḥ phirūśinaśca, yūyaṁ pōdināyāḥ sitacchatrāyā jīrakasya ca daśamāṁśān dattha, kintu vyavasthāyā gurutarān nyāyadayāviśvāsān parityajatha; imē yuṣmābhirācaraṇīyā amī ca na laṁghanīyāḥ| ");
INSERT INTO saniso_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","hē andhapathadarśakā yūyaṁ maśakān apasārayatha, kintu mahāṅgān grasatha| ");
INSERT INTO saniso_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","hanta kapaṭina upādhyāyāḥ phirūśinaśca, yūyaṁ pānapātrāṇāṁ bhōjanapātrāṇāñca bahiḥ pariṣkurutha; kintu tadabhyantaraṁ durātmatayā kaluṣēṇa ca paripūrṇamāstē| ");
INSERT INTO saniso_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","hē andhāḥ phirūśilōkā ādau pānapātrāṇāṁ bhōjanapātrāṇāñcābhyantaraṁ pariṣkuruta, tēna tēṣāṁ bahirapi pariṣkāriṣyatē| ");
INSERT INTO saniso_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","hanta kapaṭina upādhyāyāḥ phirūśinaśca, yūyaṁ śuklīkr̥taśmaśānasvarūpā bhavatha, yathā śmaśānabhavanasya bahiścāru, kintvabhyantaraṁ mr̥talōkānāṁ kīkaśaiḥ sarvvaprakāramalēna ca paripūrṇam; ");
INSERT INTO saniso_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","tathaiva yūyamapi lōkānāṁ samakṣaṁ bahirdhārmmikāḥ kintvantaḥkaraṇēṣu kēvalakāpaṭyādharmmābhyāṁ paripūrṇāḥ| ");
INSERT INTO saniso_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","hā hā kapaṭina upādhyāyāḥ phirūśinaśca, yūyaṁ bhaviṣyadvādināṁ śmaśānagēhaṁ nirmmātha, sādhūnāṁ śmaśānanikētanaṁ śōbhayatha ");
INSERT INTO saniso_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","vadatha ca yadi vayaṁ svēṣāṁ pūrvvapuruṣāṇāṁ kāla asthāsyāma, tarhi bhaviṣyadvādināṁ śōṇitapātanē tēṣāṁ sahabhāginō nābhaviṣyāma| ");
INSERT INTO saniso_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","atō yūyaṁ bhaviṣyadvādighātakānāṁ santānā iti svayamēva svēṣāṁ sākṣyaṁ dattha| ");
INSERT INTO saniso_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","atō yūyaṁ nijapūrvvapuruṣāṇāṁ parimāṇapātraṁ paripūrayata| ");
INSERT INTO saniso_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","rē bhujagāḥ kr̥ṣṇabhujagavaṁśāḥ, yūyaṁ kathaṁ narakadaṇḍād rakṣiṣyadhvē| ");
INSERT INTO saniso_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","paśyata, yuṣmākamantikam ahaṁ bhaviṣyadvādinō buddhimata upādhyāyāṁśca prēṣayiṣyāmi, kintu tēṣāṁ katipayā yuṣmābhi rghāniṣyantē, kruśē ca ghāniṣyantē, kēcid bhajanabhavanē kaṣābhirāghāniṣyantē, nagarē nagarē tāḍiṣyantē ca; ");
INSERT INTO saniso_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","tēna satpuruṣasya hābilō raktapātamārabhya bērikhiyaḥ putraṁ yaṁ sikhariyaṁ yūyaṁ mandirayajñavēdyō rmadhyē hatavantaḥ, tadīyaśōṇitapātaṁ yāvad asmin dēśē yāvatāṁ sādhupuruṣāṇāṁ śōṇitapātō 'bhavat tat sarvvēṣāmāgasāṁ daṇḍā yuṣmāsu varttiṣyantē| ");
INSERT INTO saniso_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ahaṁ yuṣmānta tathyaṁ vadāmi, vidyamānē'smin puruṣē sarvvē varttiṣyantē| ");
INSERT INTO saniso_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","hē yirūśālam hē yirūśālam nagari tvaṁ bhaviṣyadvādinō hatavatī, tava samīpaṁ prēritāṁśca pāṣāṇairāhatavatī, yathā kukkuṭī śāvakān pakṣādhaḥ saṁgr̥hlāti, tathā tava santānān saṁgrahītuṁ ahaṁ bahuvāram aicchaṁ; kintu tvaṁ na samamanyathāḥ| ");
INSERT INTO saniso_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","paśyata yaṣmākaṁ vāsasthānam ucchinnaṁ tyakṣyatē| ");
INSERT INTO saniso_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ahaṁ yuṣmān tathyaṁ vadāmi, yaḥ paramēśvarasya nāmnāgacchati, sa dhanya iti vāṇīṁ yāvanna vadiṣyatha, tāvat māṁ puna rna drakṣyatha| ");
INSERT INTO saniso_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","anantaraṁ yīśu ryadā mandirād bahi rgacchati, tadānīṁ śiṣyāstaṁ mandiranirmmāṇaṁ darśayitumāgatāḥ| ");
INSERT INTO saniso_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","tatō yīśustānuvāca, yūyaṁ kimētāni na paśyatha? yuṣmānahaṁ satyaṁ vadāmi, ētannicayanasya pāṣāṇaikamapyanyapāṣāṇēाpari na sthāsyati sarvvāṇi bhūmisāt kāriṣyantē| ");
INSERT INTO saniso_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","anantaraṁ tasmin jaitunaparvvatōpari samupaviṣṭē śiṣyāstasya samīpamāgatya guptaṁ papracchuḥ, ētā ghaṭanāḥ kadā bhaviṣyanti? bhavata āgamanasya yugāntasya ca kiṁ lakṣma? tadasmān vadatu| ");
INSERT INTO saniso_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","tadānīṁ yīśustānavōcat, avadhadvvaṁ, kōpi yuṣmān na bhramayēt| ");
INSERT INTO saniso_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","bahavō mama nāma gr̥hlanta āgamiṣyanti, khrīṣṭō'hamēvēti vācaṁ vadantō bahūn bhramayiṣyanti| ");
INSERT INTO saniso_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","yūyañca saṁgrāmasya raṇasya cāḍambaraṁ śrōṣyatha, avadhadvvaṁ tēna cañcalā mā bhavata, ētānyavaśyaṁ ghaṭiṣyantē, kintu tadā yugāntō nahi| ");
INSERT INTO saniso_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","aparaṁ dēśasya vipakṣō dēśō rājyasya vipakṣō rājyaṁ bhaviṣyati, sthānē sthānē ca durbhikṣaṁ mahāmārī bhūkampaśca bhaviṣyanti, ");
INSERT INTO saniso_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ētāni duḥkhōpakramāḥ| ");
INSERT INTO saniso_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","tadānīṁ lōkā duḥkhaṁ bhōjayituṁ yuṣmān parakarēṣu samarpayiṣyanti haniṣyanti ca, tathā mama nāmakāraṇād yūyaṁ sarvvadēśīyamanujānāṁ samīpē ghr̥ṇārhā bhaviṣyatha| ");
INSERT INTO saniso_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","bahuṣu vighnaṁ prāptavatsu parasparam r̥ृtīyāṁ kr̥tavatsu ca ēkō'paraṁ parakarēṣu samarpayiṣyati| ");
INSERT INTO saniso_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","tathā bahavō mr̥ṣābhaviṣyadvādina upasthāya bahūn bhramayiṣyanti| ");
INSERT INTO saniso_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","duṣkarmmaṇāṁ bāhulyāñca bahūnāṁ prēma śītalaṁ bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","kintu yaḥ kaścit śēṣaṁ yāvad dhairyyamāśrayatē, saēva paritrāyiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","aparaṁ sarvvadēśīyalōkān pratimākṣī bhavituṁ rājasya śubhasamācāraḥ sarvvajagati pracāriṣyatē, ētādr̥śi sati yugānta upasthāsyati| ");
INSERT INTO saniso_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","atō yat sarvvanāśakr̥dghr̥ṇārhaṁ vastu dāniyēlbhaviṣyadvadinā prōktaṁ tad yadā puṇyasthānē sthāpitaṁ drakṣyatha, (yaḥ paṭhati, sa budhyatāṁ) ");
INSERT INTO saniso_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","tadānīṁ yē yihūdīyadēśē tiṣṭhanti, tē parvvatēṣu palāyantāṁ| ");
INSERT INTO saniso_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","yaḥ kaścid gr̥hapr̥ṣṭhē tiṣṭhati, sa gr̥hāt kimapi vastvānētum adhēा nāvarōhēt| ");
INSERT INTO saniso_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","yaśca kṣētrē tiṣṭhati, sōpi vastramānētuṁ parāvr̥tya na yāyāt| ");
INSERT INTO saniso_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","tadānīṁ garbhiṇīstanyapāyayitrīṇāṁ durgati rbhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","atō yaṣmākaṁ palāyanaṁ śītakālē viśrāmavārē vā yanna bhavēt, tadarthaṁ prārthayadhvam| ");
INSERT INTO saniso_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ā jagadārambhād ētatkālaparyyanantaṁ yādr̥śaḥ kadāpi nābhavat na ca bhaviṣyati tādr̥śō mahāklēśastadānīm upasthāsyati| ");
INSERT INTO saniso_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","tasya klēśasya samayō yadi hsvō na kriyēta, tarhi kasyāpi prāṇinō rakṣaṇaṁ bhavituṁ na śaknuyāt, kintu manōnītamanujānāṁ kr̥tē sa kālō hsvīkariṣyatē| ");
INSERT INTO saniso_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","aparañca paśyata, khrīṣṭō'tra vidyatē, vā tatra vidyatē, tadānīṁ yadī kaścid yuṣmāna iti vākyaṁ vadati, tathāpi tat na pratīt| ");
INSERT INTO saniso_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","yatō bhāktakhrīṣṭā bhāktabhaviṣyadvādinaśca upasthāya yāni mahanti lakṣmāṇi citrakarmmāṇi ca prakāśayiṣyanti, tai ryadi sambhavēt tarhi manōnītamānavā api bhrāmiṣyantē| ");
INSERT INTO saniso_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","paśyata, ghaṭanātaḥ pūrvvaṁ yuṣmān vārttām avādiṣam| ");
INSERT INTO saniso_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","ataḥ paśyata, sa prāntarē vidyata iti vākyē kēnacit kathitēpi bahi rmā gacchata, vā paśyata, sōntaḥpurē vidyatē, ētadvākya uktēpi mā pratīta| ");
INSERT INTO saniso_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","yatō yathā vidyut pūrvvadiśō nirgatya paścimadiśaṁ yāvat prakāśatē, tathā mānuṣaputrasyāpyāgamanaṁ bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","yatra śavastiṣṭhati, tatrēva gr̥dhrā milanti| ");
INSERT INTO saniso_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","aparaṁ tasya klēśasamayasyāvyavahitaparatra sūryyasya tējō lōpsyatē, candramā jyōsnāṁ na kariṣyati, nabhasō nakṣatrāṇi patiṣyanti, gagaṇīyā grahāśca vicaliṣyanti| ");
INSERT INTO saniso_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","tadānīm ākāśamadhyē manujasutasya lakṣma darśiṣyatē, tatō nijaparākramēṇa mahātējasā ca mēghārūḍhaṁ manujasutaṁ nabhasāgacchantaṁ vilōkya pr̥thivyāḥ sarvvavaṁśīyā vilapiṣyanti| ");
INSERT INTO saniso_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","tadānīṁ sa mahāśabdāyamānatūryyā vādakān nijadūtān prahēṣyati, tē vyōmna ēkasīmātō'parasīmāṁ yāvat caturdiśastasya manōnītajanān ānīya mēlayiṣyanti| ");
INSERT INTO saniso_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","uḍumbarapādapasya dr̥ṣṭāntaṁ śikṣadhvaṁ; yadā tasya navīnāḥ śākhā jāyantē, pallavādiśca nirgacchati, tadā nidāghakālaḥ savidhō bhavatīti yūyaṁ jānītha; ");
INSERT INTO saniso_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","tadvad ētā ghaṭanā dr̥ṣṭvā sa samayō dvāra upāsthād iti jānīta| ");
INSERT INTO saniso_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","yuṣmānahaṁ tathyaṁ vadāmi, idānīntanajanānāṁ gamanāt pūrvvamēva tāni sarvvāṇi ghaṭiṣyantē| ");
INSERT INTO saniso_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","nabhōmēdinyō rluptayōrapi mama vāk kadāpi na lōpsyatē| ");
INSERT INTO saniso_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","aparaṁ mama tātaṁ vinā mānuṣaḥ svargasthō dūtō vā kōpi taddinaṁ taddaṇḍañca na jñāpayati| ");
INSERT INTO saniso_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","aparaṁ nōhē vidyamānē yādr̥śamabhavat tādr̥śaṁ manujasutasyāgamanakālēpi bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","phalatō jalāplāvanāt pūrvvaṁ yaddinaṁ yāvat nōhaḥ pōtaṁ nārōhat, tāvatkālaṁ yathā manuṣyā bhōjanē pānē vivahanē vivāhanē ca pravr̥ttā āsan; ");
INSERT INTO saniso_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","aparam āplāvitōyamāgatya yāvat sakalamanujān plāvayitvā nānayat, tāvat tē yathā na vidāmāsuḥ, tathā manujasutāgamanēpi bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","tadā kṣētrasthitayōrdvayōrēkō dhāriṣyatē, aparastyājiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","tathā pēṣaṇyā piṁṣatyōrubhayō ryōṣitōrēkā dhāriṣyatē'parā tyājiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","yuṣmākaṁ prabhuḥ kasmin daṇḍa āgamiṣyati, tad yuṣmābhi rnāvagamyatē, tasmāt jāgrataḥ santastiṣṭhata| ");
INSERT INTO saniso_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","kutra yāmē stēna āgamiṣyatīti cēd gr̥hasthō jñātum aśakṣyat, tarhi jāgaritvā taṁ sandhiṁ karttitum avārayiṣyat tad jānīta| ");
INSERT INTO saniso_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","yuṣmābhiravadhīyatāṁ, yatō yuṣmābhi ryatra na budhyatē, tatraiva daṇḍē manujasuta āyāsyati| ");
INSERT INTO saniso_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","prabhu rnijaparivārān yathākālaṁ bhōjayituṁ yaṁ dāsam adhyakṣīkr̥tya sthāpayati, tādr̥śō viśvāsyō dhīmān dāsaḥ kaḥ? ");
INSERT INTO saniso_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","prabhurāgatya yaṁ dāsaṁ tathācarantaṁ vīkṣatē, saēva dhanyaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","yuṣmānahaṁ satyaṁ vadāmi, sa taṁ nijasarvvasvasyādhipaṁ kariṣyati| ");
INSERT INTO saniso_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","kintu prabhurāgantuṁ vilambata iti manasi cintayitvā yō duṣṭō dāsō ");
INSERT INTO saniso_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","'paradāsān praharttuṁ mattānāṁ saṅgē bhōktuṁ pātuñca pravarttatē, ");
INSERT INTO saniso_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","sa dāsō yadā nāpēkṣatē, yañca daṇḍaṁ na jānāti, tatkālaēva tatprabhurupasthāsyati| ");
INSERT INTO saniso_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","tadā taṁ daṇḍayitvā yatra sthānē rōdanaṁ dantagharṣaṇañcāsātē, tatra kapaṭibhiḥ sākaṁ taddaśāṁ nirūpayiṣyati| ");
INSERT INTO saniso_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","yā daśa kanyāḥ pradīpān gr̥hlatyō varaṁ sākṣāt karttuṁ bahiritāḥ, tābhistadā svargīyarājyasya sādr̥śyaṁ bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","tāsāṁ kanyānāṁ madhyē pañca sudhiyaḥ pañca durdhiya āsan| ");
INSERT INTO saniso_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","yā durdhiyastāḥ pradīpān saṅgē gr̥hītvā tailaṁ na jagr̥huḥ, ");
INSERT INTO saniso_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","kintu sudhiyaḥ pradīpān pātrēṇa tailañca jagr̥huḥ| ");
INSERT INTO saniso_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","anantaraṁ varē vilambitē tāḥ sarvvā nidrāviṣṭā nidrāṁ jagmuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","anantaram arddharātrē paśyata vara āgacchati, taṁ sākṣāt karttuṁ bahiryātēti janaravāt ");
INSERT INTO saniso_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","tāḥ sarvvāḥ kanyā utthāya pradīpān āsādayituṁ ārabhanta| ");
INSERT INTO saniso_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","tatō durdhiyaḥ sudhiya ūcuḥ, kiñcit tailaṁ datta, pradīpā asmākaṁ nirvvāṇāḥ| ");
INSERT INTO saniso_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","kintu sudhiyaḥ pratyavadan, dattē yuṣmānasmāṁśca prati tailaṁ nyūnībhavēt, tasmād vikrētr̥ṇāṁ samīpaṁ gatvā svārthaṁ tailaṁ krīṇīta| ");
INSERT INTO saniso_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","tadā tāsu krētuṁ gatāsu vara ājagāma, tatō yāḥ sajjitā āsan, tāstēna sākaṁ vivāhīyaṁ vēśma praviviśuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","anantaraṁ dvārē ruddhē aparāḥ kanyā āgatya jagaduḥ, hē prabhō, hē prabhō, asmān prati dvāraṁ mōcaya| ");
INSERT INTO saniso_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","kintu sa uktavān, tathyaṁ vadāmi, yuṣmānahaṁ na vēdmi| ");
INSERT INTO saniso_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","atō jāgrataḥ santastiṣṭhata, manujasutaḥ kasmin dinē kasmin daṇḍē vāgamiṣyati, tad yuṣmābhi rna jñāyatē| ");
INSERT INTO saniso_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","aparaṁ sa ētādr̥śaḥ kasyacit puṁsastulyaḥ, yō dūradēśaṁ prati yātrākālē nijadāsān āhūya tēṣāṁ svasvasāmarthyānurūpam ");
INSERT INTO saniso_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ēkasmin mudrāṇāṁ pañca pōṭalikāḥ anyasmiṁśca dvē pōṭalikē aparasmiṁśca pōṭalikaikām itthaṁ pratijanaṁ samarpya svayaṁ pravāsaṁ gatavān| ");
INSERT INTO saniso_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","anantaraṁ yō dāsaḥ pañca pōṭalikāḥ labdhavān, sa gatvā vāṇijyaṁ vidhāya tā dviguṇīcakāra| ");
INSERT INTO saniso_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","yaśca dāsō dvē pōṭalikē alabhata, sōpi tā mudrā dviguṇīcakāra| ");
INSERT INTO saniso_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","kintu yō dāsa ēkāṁ pōṭalikāṁ labdhavān, sa gatvā bhūmiṁ khanitvā tanmadhyē nijaprabhōstā mudrā gōpayāñcakāra| ");
INSERT INTO saniso_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","tadanantaraṁ bahutithē kālē gatē tēṣāṁ dāsānāṁ prabhurāgatya tairdāsaiḥ samaṁ gaṇayāñcakāra| ");
INSERT INTO saniso_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","tadānīṁ yaḥ pañca pōṭalikāḥ prāptavān sa tā dviguṇīkr̥tamudrā ānīya jagāda; hē prabhō, bhavatā mayi pañca pōṭalikāḥ samarpitāḥ, paśyatu, tā mayā dviguṇīkr̥tāḥ| ");
INSERT INTO saniso_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","tadānīṁ tasya prabhustamuvāca, hē uttama viśvāsya dāsa, tvaṁ dhanyōsi, stōkēna viśvāsyō jātaḥ, tasmāt tvāṁ bahuvittādhipaṁ karōmi, tvaṁ svaprabhōḥ sukhasya bhāgī bhava| ");
INSERT INTO saniso_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","tatō yēna dvē pōṭalikē labdhē sōpyāgatya jagāda, hē prabhō, bhavatā mayi dvē pōṭalikē samarpitē, paśyatu tē mayā dviguṇīkr̥tē| ");
INSERT INTO saniso_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","tēna tasya prabhustamavōcat, hē uttama viśvāsya dāsa, tvaṁ dhanyōsi, stōkēna viśvāsyō jātaḥ, tasmāt tvāṁ bahudraviṇādhipaṁ karōmi, tvaṁ nijaprabhōḥ sukhasya bhāgī bhava| ");
INSERT INTO saniso_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","anantaraṁ ya ēkāṁ pōṭalikāṁ labdhavān, sa ētya kathitavān, hē prabhō, tvāṁ kaṭhinanaraṁ jñātavān, tvayā yatra nōptaṁ, tatraiva kr̥tyatē, yatra ca na kīrṇaṁ, tatraiva saṁgr̥hyatē| ");
INSERT INTO saniso_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","atōhaṁ saśaṅkaḥ san gatvā tava mudrā bhūmadhyē saṁgōpya sthāpitavān, paśya, tava yat tadēva gr̥hāṇa| ");
INSERT INTO saniso_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","tadā tasya prabhuḥ pratyavadat rē duṣṭālasa dāsa, yatrāhaṁ na vapāmi, tatra chinadmi, yatra ca na kirāmi, tatrēva saṁgr̥hlāmīti cēdajānāstarhi ");
INSERT INTO saniso_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","vaṇikṣu mama vittārpaṇaṁ tavōcitamāsīt, yēnāhamāgatya vr̥dvyā sākaṁ mūlamudrāḥ prāpsyam| ");
INSERT INTO saniso_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","atōsmāt tāṁ pōṭalikām ādāya yasya daśa pōṭalikāḥ santi tasminnarpayata| ");
INSERT INTO saniso_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","yēna vardvyatē tasminnaivārpiṣyatē, tasyaiva ca bāhulyaṁ bhaviṣyati, kintu yēna na vardvyatē, tasyāntikē yat kiñcana tiṣṭhati, tadapi punarnēṣyatē| ");
INSERT INTO saniso_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","aparaṁ yūyaṁ tamakarmmaṇyaṁ dāsaṁ nītvā yatra sthānē krandanaṁ dantagharṣaṇañca vidyētē, tasmin bahirbhūtatamasi nikṣipata| ");
INSERT INTO saniso_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","yadā manujasutaḥ pavitradūtān saṅginaḥ kr̥tvā nijaprabhāvēnāgatya nijatējōmayē siṁhāsanē nivēkṣyati, ");
INSERT INTO saniso_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","tadā tatsammukhē sarvvajātīyā janā saṁmēliṣyanti| tatō mēṣapālakō yathā chāgēbhyō'vīn pr̥thak karōti tathā sōpyēkasmādanyam itthaṁ tān pr̥thaka kr̥tvāvīn ");
INSERT INTO saniso_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","dakṣiṇē chāgāṁśca vāmē sthāpayiṣyati| ");
INSERT INTO saniso_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","tataḥ paraṁ rājā dakṣiṇasthitān mānavān vadiṣyati, āgacchata mattātasyānugrahabhājanāni, yuṣmatkr̥ta ā jagadārambhat yad rājyam āsāditaṁ tadadhikuruta| ");
INSERT INTO saniso_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","yatō bubhukṣitāya mahyaṁ bhōjyam adatta, pipāsitāya pēyamadatta, vidēśinaṁ māṁ svasthānamanayata, ");
INSERT INTO saniso_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","vastrahīnaṁ māṁ vasanaṁ paryyadhāpayata, pīḍītaṁ māṁ draṣṭumāgacchata, kārāsthañca māṁ vīkṣituma āgacchata| ");
INSERT INTO saniso_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","tadā dhārmmikāḥ prativadiṣyanti, hē prabhō, kadā tvāṁ kṣudhitaṁ vīkṣya vayamabhōjayāma? vā pipāsitaṁ vīkṣya apāyayāma? ");
INSERT INTO saniso_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","kadā vā tvāṁ vidēśinaṁ vilōkya svasthānamanayāma? kadā vā tvāṁ nagnaṁ vīkṣya vasanaṁ paryyadhāpayāma? ");
INSERT INTO saniso_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","kadā vā tvāṁ pīḍitaṁ kārāsthañca vīkṣya tvadantikamagacchāma? ");
INSERT INTO saniso_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","tadānīṁ rājā tān prativadiṣyati, yuṣmānahaṁ satyaṁ vadāmi, mamaitēṣāṁ bhrātr̥ṇāṁ madhyē kañcanaikaṁ kṣudratamaṁ prati yad akuruta, tanmāṁ pratyakuruta| ");
INSERT INTO saniso_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","paścāt sa vāmasthitān janān vadiṣyati, rē śāpagrastāḥ sarvvē, śaitānē tasya dūtēbhyaśca yō'nantavahnirāsādita āstē, yūyaṁ madantikāt tamagniṁ gacchata| ");
INSERT INTO saniso_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","yatō kṣudhitāya mahyamāhāraṁ nādatta, pipāsitāya mahyaṁ pēyaṁ nādatta, ");
INSERT INTO saniso_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","vidēśinaṁ māṁ svasthānaṁ nānayata, vasanahīnaṁ māṁ vasanaṁ na paryyadhāpayata, pīḍitaṁ kārāsthañca māṁ vīkṣituṁ nāgacchata| ");
INSERT INTO saniso_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","tadā tē prativadiṣyanti, hē prabhō, kadā tvāṁ kṣudhitaṁ vā pipāsitaṁ vā vidēśinaṁ vā nagnaṁ vā pīḍitaṁ vā kārāsthaṁ vīkṣya tvāṁ nāsēvāmahi? ");
INSERT INTO saniso_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","tadā sa tān vadiṣyati, tathyamahaṁ yuṣmān bravīmi, yuṣmābhirēṣāṁ kañcana kṣōdiṣṭhaṁ prati yannākāri, tanmāṁ pratyēva nākāri| ");
INSERT INTO saniso_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","paścādamyanantaśāstiṁ kintu dhārmmikā anantāyuṣaṁ bhōktuṁ yāsyanti| ");
INSERT INTO saniso_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","yīśurētān prastāvān samāpya śiṣyānūcē, ");
INSERT INTO saniso_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","yuṣmābhi rjñātaṁ dinadvayāt paraṁ nistāramaha upasthāsyati, tatra manujasutaḥ kruśēna hantuṁ parakarēṣu samarpiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","tataḥ paraṁ pradhānayājakādhyāpakaprāñcaḥ kiyaphānāmnō mahāyājakasyāṭṭālikāyāṁ militvā ");
INSERT INTO saniso_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","kēnōpāyēna yīśuṁ dhr̥tvā hantuṁ śaknuyuriti mantrayāñcakruḥ| ");
INSERT INTO saniso_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","kintu tairuktaṁ mahakālē na dharttavyaḥ, dhr̥tē prajānāṁ kalahēna bhavituṁ śakyatē| ");
INSERT INTO saniso_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","tatō baithaniyāpurē śimōnākhyasya kuṣṭhinō vēśmani yīśau tiṣṭhati ");
INSERT INTO saniso_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","kācana yōṣā śvētōpalabhājanēna mahārghyaṁ sugandhi tailamānīya bhōjanāyōpaviśatastasya śirōbhyaṣēcat| ");
INSERT INTO saniso_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","kintu tadālōkya tacchiṣyaiḥ kupitairuktaṁ, kuta itthamapavyayatē? ");
INSERT INTO saniso_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","cēdidaṁ vyakrēṣyata, tarhi bhūrimūlyaṁ prāpya daridrēbhyō vyatāriṣyata| ");
INSERT INTO saniso_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","yīśunā tadavagatya tē samuditāḥ, yōṣāmēnāṁ kutō duḥkhinīṁ kurutha, sā māṁ prati sādhu karmmākārṣīt| ");
INSERT INTO saniso_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","yuṣmākamaṁ samīpē daridrāḥ satatamēvāsatē, kintu yuṣmākamantikēhaṁ nāsē satataṁ| ");
INSERT INTO saniso_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","sā mama kāyōpari sugandhitailaṁ siktvā mama śmaśānadānakarmmākārṣīt| ");
INSERT INTO saniso_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","atōhaṁ yuṣmān tathyaṁ vadāmi sarvvasmin jagati yatra yatraiṣa susamācāraḥ pracāriṣyatē, tatra tatraitasyā nāryyāḥ smaraṇārtham karmmēdaṁ pracāriṣyatē| ");
INSERT INTO saniso_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","tatō dvādaśaśiṣyāṇām īṣkariyōtīyayihūdānāmaka ēkaḥ śiṣyaḥ pradhānayājakānāmantikaṁ gatvā kathitavān, ");
INSERT INTO saniso_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","yadi yuṣmākaṁ karēṣu yīśuṁ samarpayāmi, tarhi kiṁ dāsyatha? tadānīṁ tē tasmai triṁśanmudrā dātuṁ sthirīkr̥tavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","sa tadārabhya taṁ parakarēṣu samarpayituṁ suyōgaṁ cēṣṭitavān| ");
INSERT INTO saniso_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","anantaraṁ kiṇvaśūnyapūpaparvvaṇaḥ prathamēhni śiṣyā yīśum upagatya papracchuḥ bhavatkr̥tē kutra vayaṁ nistāramahabhōjyam āyōjayiṣyāmaḥ? bhavataḥ kēcchā? ");
INSERT INTO saniso_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","tadā sa gaditavān, madhyēnagaramamukapuṁsaḥ samīpaṁ vrajitvā vadata, guru rgaditavān, matkālaḥ savidhaḥ, saha śiṣyaistvadālayē nistāramahabhōjyaṁ bhōkṣyē| ");
INSERT INTO saniso_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","tadā śiṣyā yīśōstādr̥śanidēśānurūpakarmma vidhāya tatra nistāramahabhōjyamāsādayāmāsuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","tataḥ sandhyāyāṁ satyāṁ dvādaśabhiḥ śiṣyaiḥ sākaṁ sa nyaviśat| ");
INSERT INTO saniso_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","aparaṁ bhuñjāna uktavān yuṣmān tathyaṁ vadāmi, yuṣmākamēkō māṁ parakarēṣu samarpayiṣyati| ");
INSERT INTO saniso_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","tadā tē'tīva duḥkhitā ēkaikaśō vaktumārēbhirē, hē prabhō, sa kimahaṁ? ");
INSERT INTO saniso_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","tataḥ sa jagāda, mayā sākaṁ yō janō bhōjanapātrē karaṁ saṁkṣipati, sa ēva māṁ parakarēṣu samarpayiṣyati| ");
INSERT INTO saniso_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","manujasutamadhi yādr̥śaṁ likhitamāstē, tadanurūpā tadgati rbhaviṣyati; kintu yēna puṁsā sa parakarēṣu samarpayiṣyatē, hā hā cēt sa nājaniṣyata, tadā tasya kṣēmamabhaviṣyat| ");
INSERT INTO saniso_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","tadā yihūdānāmā yō janastaṁ parakarēṣu samarpayiṣyati, sa uktavān, hē gurō, sa kimahaṁ? tataḥ sa pratyuktavān, tvayā satyaṁ gaditam| ");
INSERT INTO saniso_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","anantaraṁ tēṣāmaśanakālē yīśuḥ pūpamādāyēśvarīyaguṇānanūdya bhaṁktvā śiṣyēbhyaḥ pradāya jagāda, madvapuḥsvarūpamimaṁ gr̥hītvā khādata| ");
INSERT INTO saniso_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","paścāt sa kaṁsaṁ gr̥hlan īśvarīyaguṇānanūdya tēbhyaḥ pradāya kathitavān, sarvvai ryuṣmābhiranēna pātavyaṁ, ");
INSERT INTO saniso_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","yasmādanēkēṣāṁ pāpamarṣaṇāya pātitaṁ yanmannūtnaniyamarūpaśōṇitaṁ tadētat| ");
INSERT INTO saniso_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","aparamahaṁ nūtnagōstanīrasaṁ na pāsyāmi, tāvat gōstanīphalarasaṁ punaḥ kadāpi na pāsyāmi| ");
INSERT INTO saniso_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","paścāt tē gītamēkaṁ saṁgīya jaitunākhyagiriṁ gatavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","tadānīṁ yīśustānavōcat, asyāṁ rajanyāmahaṁ yuṣmākaṁ sarvvēṣāṁ vighnarūpō bhaviṣyāmi, yatō likhitamāstē, \"mēṣāṇāṁ rakṣakō yastaṁ prahariṣyāmyahaṁ tataḥ| mēṣāṇāṁ nivahō nūnaṁ pravikīrṇō bhaviṣyati\"|| ");
INSERT INTO saniso_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","kintu śmaśānāt samutthāya yuṣmākamagrē'haṁ gālīlaṁ gamiṣyāmi| ");
INSERT INTO saniso_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","pitarastaṁ prōvāca, bhavāṁścēt sarvvēṣāṁ vighnarūpō bhavati, tathāpi mama na bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","tatō yīśunā sa uktaḥ, tubhyamahaṁ tathyaṁ kathayāmi, yāminyāmasyāṁ caraṇāyudhasya ravāt pūrvvaṁ tvaṁ māṁ tri rnāṅgīkariṣyasi| ");
INSERT INTO saniso_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","tataḥ pitara uditavān, yadyapi tvayā samaṁ marttavyaṁ, tathāpi kadāpi tvāṁ na nāṅgīkariṣyāmi; tathaiva sarvvē śiṣyāścōcuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","anantaraṁ yīśuḥ śiṣyaiḥ sākaṁ gētśimānīnāmakaṁ sthānaṁ prasthāya tēbhyaḥ kathitavān, adaḥ sthānaṁ gatvā yāvadahaṁ prārthayiṣyē tāvad yūyamatrōpaviśata| ");
INSERT INTO saniso_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","paścāt sa pitaraṁ sivadiyasutau ca saṅginaḥ kr̥tvā gatavān, śōkākulō'tīva vyathitaśca babhūva| ");
INSERT INTO saniso_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","tānavādīcca mr̥tiyātanēva matprāṇānāṁ yātanā jāyatē, yūyamatra mayā sārddhaṁ jāgr̥ta| ");
INSERT INTO saniso_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","tataḥ sa kiñciddūraṁ gatvādhōmukhaḥ patan prārthayāñcakrē, hē matpitaryadi bhavituṁ śaknōti, tarhi kaṁsō'yaṁ mattō dūraṁ yātu; kintu madicchāvat na bhavatu, tvadicchāvad bhavatu| ");
INSERT INTO saniso_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","tataḥ sa śiṣyānupētya tān nidratō nirīkṣya pitarāya kathayāmāsa, yūyaṁ mayā sākaṁ daṇḍamēkamapi jāgarituṁ nāśankuta? ");
INSERT INTO saniso_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","parīkṣāyāṁ na patituṁ jāgr̥ta prārthayadhvañca; ātmā samudyatōsti, kintu vapu rdurbbalaṁ| ");
INSERT INTO saniso_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","sa dvitīyavāraṁ prārthayāñcakrē, hē mattāta, na pītē yadi kaṁsamidaṁ mattō dūraṁ yātuṁ na śaknōti, tarhi tvadicchāvad bhavatu| ");
INSERT INTO saniso_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","sa punarētya tān nidratō dadarśa, yatastēṣāṁ nētrāṇi nidrayā pūrṇānyāsan| ");
INSERT INTO saniso_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","paścāt sa tān vihāya vrajitvā tr̥tīyavāraṁ pūrvvavat kathayan prārthitavān| ");
INSERT INTO saniso_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","tataḥ śiṣyānupāgatya gaditavān, sāmprataṁ śayānāḥ kiṁ viśrāmyatha? paśyata, samaya upāsthāt, manujasutaḥ pāpināṁ karēṣu samarpyatē| ");
INSERT INTO saniso_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","uttiṣṭhata, vayaṁ yāmaḥ, yō māṁ parakarēṣu masarpayiṣyati, paśyata, sa samīpamāyāti| ");
INSERT INTO saniso_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ētatkathākathanakālē dvādaśaśiṣyāṇāmēkō yihūdānāmakō mukhyayājakalōkaprācīnaiḥ prahitān asidhāriyaṣṭidhāriṇō manujān gr̥hītvā tatsamīpamupatasthau| ");
INSERT INTO saniso_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","asau parakarēṣvarpayitā pūrvvaṁ tān itthaṁ saṅkētayāmāsa, yamahaṁ cumbiṣyē, sō'sau manujaḥ,saēva yuṣmābhi rdhāryyatāṁ| ");
INSERT INTO saniso_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","tadā sa sapadi yīśumupāgatya hē gurō, praṇamāmītyuktvā taṁ cucumbē| ");
INSERT INTO saniso_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","tadā yīśustamuvāca, hē mitraṁ kimarthamāgatōsi? tadā tairāgatya yīśurākramya daghrē| ");
INSERT INTO saniso_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","tatō yīśōḥ saṅgināmēkaḥ karaṁ prasāryya kōṣādasiṁ bahiṣkr̥tya mahāyājakasya dāsamēkamāhatya tasya karṇaṁ cicchēda| ");
INSERT INTO saniso_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","tatō yīśustaṁ jagāda, khaḍgaṁ svasthānēे nidhēhi yatō yē yē janā asiṁ dhārayanti, taēvāsinā vinaśyanti| ");
INSERT INTO saniso_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","aparaṁ pitā yathā madantikaṁ svargīyadūtānāṁ dvādaśavāhinītō'dhikaṁ prahiṇuyāt mayā tamuddiśyēdānīmēva tathā prārthayituṁ na śakyatē, tvayā kimitthaṁ jñāyatē? ");
INSERT INTO saniso_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","tathā satītthaṁ ghaṭiṣyatē dharmmapustakasya yadidaṁ vākyaṁ tat kathaṁ sidhyēt? ");
INSERT INTO saniso_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","tadānīṁ yīśu rjananivahaṁ jagāda, yūyaṁ khaḍgayaṣṭīn ādāya māṁ kiṁ cauraṁ dharttumāyātāḥ? ahaṁ pratyahaṁ yuṣmābhiḥ sākamupaviśya samupādiśaṁ, tadā māṁ nādharata; ");
INSERT INTO saniso_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","kintu bhaviṣyadvādināṁ vākyānāṁ saṁsiddhayē sarvvamētadabhūt|tadā sarvvē śiṣyāstaṁ vihāya palāyanta| ");
INSERT INTO saniso_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","anantaraṁ tē manujā yīśuṁ dhr̥tvā yatrādhyāpakaprāñcaḥ pariṣadaṁ kurvvanta upāviśan tatra kiyaphānāाmakamahāyājakasyāntikaṁ ninyuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","kintu śēṣē kiṁ bhaviṣyatīti vēttuṁ pitarō dūrē tatpaścād vrajitvā mahāyājakasyāṭṭālikāṁ praviśya dāsaiḥ sahita upāviśat| ");
INSERT INTO saniso_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","tadānīṁ pradhānayājakaprācīnamantriṇaḥ sarvvē yīśuṁ hantuṁ mr̥ṣāsākṣyam alipsanta, ");
INSERT INTO saniso_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","kintu na lēbhirē| anēkēṣu mr̥ṣāsākṣiṣvāgatēṣvapi tanna prāpuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","śēṣē dvau mr̥ṣāsākṣiṇāvāgatya jagadatuḥ, pumānayamakathayat, ahamīśvaramandiraṁ bhaṁktvā dinatrayamadhyē tannirmmātuṁ śaknōmi| ");
INSERT INTO saniso_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","tadā mahāyājaka utthāya yīśum avādīt| tvaṁ kimapi na prativadasi? tvāmadhi kimētē sākṣyaṁ vadanti? ");
INSERT INTO saniso_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","kintu yīśu rmaunībhūya tasyau| tatō mahāyājaka uktavān, tvām amarēśvaranāmnā śapayāmi, tvamīśvarasya putrō'bhiṣiktō bhavasi navēti vada| ");
INSERT INTO saniso_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","yīśuḥ pratyavadat, tvaṁ satyamuktavān; ahaṁ yuṣmān tathyaṁ vadāmi, itaḥparaṁ manujasutaṁ sarvvaśaktimatō dakṣiṇapārśvē sthātuṁ gagaṇasthaṁ jaladharānāruhyāyāntaṁ vīkṣadhvē| ");
INSERT INTO saniso_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","tadā mahāyājakō nijavasanaṁ chittvā jagāda, ēṣa īśvaraṁ ninditavān, asmākamaparasākṣyēṇa kiṁ prayōjanaṁ? paśyata, yūyamēvāsyāsyād īśvaranindāṁ śrutavantaḥ, ");
INSERT INTO saniso_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","yuṣmābhiḥ kiṁ vivicyatē? tē pratyūcuḥ, vadhārhō'yaṁ| ");
INSERT INTO saniso_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","tatō lōkaistadāsyē niṣṭhīvitaṁ kēcit pratalamāhatya kēcicca capēṭamāhatya babhāṣirē, ");
INSERT INTO saniso_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","hē khrīṣṭa tvāṁ kaścapēṭamāhatavān? iti gaṇayitvā vadāsmān| ");
INSERT INTO saniso_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","pitarō bahiraṅgana upaviśati, tadānīmēkā dāsī tamupāgatya babhāṣē, tvaṁ gālīlīyayīśōḥ sahacaraēkaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","kintu sa sarvvēṣāṁ samakṣam anaṅgīkr̥tyāvādīt, tvayā yaducyatē, tadarthamahaṁ na vēdmi| ");
INSERT INTO saniso_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","tadā tasmin bahirdvāraṁ gatē 'nyā dāsī taṁ nirīkṣya tatratyajanānavadat, ayamapi nāsaratīyayīśunā sārddham āsīt| ");
INSERT INTO saniso_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","tataḥ sa śapathēna punaranaṅgīkr̥tya kathitavān, taṁ naraṁ na paricinōmi| ");
INSERT INTO saniso_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","kṣaṇāt paraṁ tiṣṭhantō janā ētya pitaram avadan, tvamavaśyaṁ tēṣāmēka iti tvaduccāraṇamēva dyōtayati| ");
INSERT INTO saniso_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","kintu sō'bhiśapya kathitavān, taṁ janaṁ nāhaṁ paricinōmi, tadā sapadi kukkuṭō rurāva| ");
INSERT INTO saniso_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","kukkuṭaravāt prāk tvaṁ māṁ trirapāhnōṣyasē, yaiṣā vāg yīśunāvādi tāṁ pitaraḥ saṁsmr̥tya bahiritvā khēdād bhr̥śaṁ cakranda| ");
INSERT INTO saniso_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","prabhātē jātē pradhānayājakalōkaprācīnā yīśuṁ hantuṁ tatpratikūlaṁ mantrayitvā ");
INSERT INTO saniso_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","taṁ badvvā nītvā pantīyapīlātākhyādhipē samarpayāmāsuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","tatō yīśōḥ parakarēvvarpayitā yihūdāstatprāṇādaṇḍājñāṁ viditvā santaptamanāḥ pradhānayājakalōkaprācīnānāṁ samakṣaṁ tāstrīṁśanmudrāḥ pratidāyāvādīt, ");
INSERT INTO saniso_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ētannirāgōnaraprāṇaparakarārpaṇāt kaluṣaṁ kr̥tavānahaṁ| tadā ta uditavantaḥ, tēnāsmākaṁ kiṁ? tvayā tad budhyatām| ");
INSERT INTO saniso_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","tatō yihūdā mandiramadhyē tā mudrā nikṣipya prasthitavān itvā ca svayamātmānamudbabandha| ");
INSERT INTO saniso_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","paścāt pradhānayājakāstā mudrā ādāya kathitavantaḥ, ētā mudrāḥ śōṇitamūlyaṁ tasmād bhāṇḍāgārē na nidhātavyāḥ| ");
INSERT INTO saniso_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","anantaraṁ tē mantrayitvā vidēśināṁ śmaśānasthānāya tābhiḥ kulālasya kṣētramakrīṇan| ");
INSERT INTO saniso_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","atō'dyāpi tatsthānaṁ raktakṣētraṁ vadanti| ");
INSERT INTO saniso_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","itthaṁ sati isrāyēlīyasantānai ryasya mūlyaṁ nirupitaṁ, tasya triṁśanmudrāmānaṁ mūlyaṁ ");
INSERT INTO saniso_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","māṁ prati paramēśvarasyādēśāt tēbhya ādīyata, tēna ca kulālasya kṣētraṁ krītamiti yadvacanaṁ yirimiyabhaviṣyadvādinā prōktaṁ tat tadāsidhyat| ");
INSERT INTO saniso_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","anantaraṁ yīśau tadadhipatēḥ sammukha upatiṣṭhati sa taṁ papraccha, tvaṁ kiṁ yihūdīyānāṁ rājā? tadā yīśustamavadat, tvaṁ satyamuktavān| ");
INSERT INTO saniso_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","kintu pradhānayājakaprācīnairabhiyuktēna tēna kimapi na pratyavādi| ");
INSERT INTO saniso_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","tataḥ pīlātēna sa uditaḥ, imē tvatpratikūlataḥ kati kati sākṣyaṁ dadati, tat tvaṁ na śr̥ṇōṣi? ");
INSERT INTO saniso_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","tathāpi sa tēṣāmēkasyāpi vacasa uttaraṁ nōditavān; tēna sō'dhipati rmahācitraṁ vidāmāsa| ");
INSERT INTO saniso_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","anyacca tanmahakālē'dhipatērētādr̥śī rātirāsīt, prajā yaṁ kañcana bandhinaṁ yācantē, tamēva sa mōcayatīti| ");
INSERT INTO saniso_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","tadānīṁ barabbānāmā kaścit khyātabandhyāsīt| ");
INSERT INTO saniso_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","tataḥ pīlātastatra militān lōkān apr̥cchat, ēṣa barabbā bandhī khrīṣṭavikhyātō yīśuścaitayōḥ kaṁ mōcayiṣyāmi? yuṣmākaṁ kimīpsitaṁ? ");
INSERT INTO saniso_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","tairīrṣyayā sa samarpita iti sa jñātavān| ");
INSERT INTO saniso_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","aparaṁ vicārāsanōpavēśanakālē pīlātasya patnī bhr̥tyaṁ prahitya tasmai kathayāmāsa, taṁ dhārmmikamanujaṁ prati tvayā kimapi na karttavyaṁ; yasmāt tatkr̥tē'dyāhaṁ svapnē prabhūtakaṣṭamalabhē| ");
INSERT INTO saniso_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","anantaraṁ pradhānayājakaprācīnā barabbāṁ yācitvādātuṁ yīśuñca hantuṁ sakalalōkān prāvarttayan| ");
INSERT INTO saniso_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","tatō'dhipatistān pr̥ṣṭavān, ētayōḥ kamahaṁ mōcayiṣyāmi? yuṣmākaṁ kēcchā? tē prōcu rbarabbāṁ| ");
INSERT INTO saniso_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","tadā pīlātaḥ papraccha, tarhi yaṁ khrīṣṭaṁ vadanti, taṁ yīśuṁ kiṁ kariṣyāmi? sarvvē kathayāmāsuḥ, sa kruśēna vidhyatāṁ| ");
INSERT INTO saniso_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","tatō'dhipatiravādīt, kutaḥ? kiṁ tēnāparāddhaṁ? kintu tē punarucai rjagaduḥ, sa kruśēna vidhyatāṁ| ");
INSERT INTO saniso_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","tadā nijavākyamagrāhyamabhūt, kalahaścāpyabhūt, pīlāta iti vilōkya lōkānāṁ samakṣaṁ tōyamādāya karau prakṣālyāvōcat, ētasya dhārmmikamanuṣyasya śōṇitapātē nirdōṣō'haṁ, yuṣmābhirēva tad budhyatāṁ| ");
INSERT INTO saniso_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","tadā sarvvāḥ prajāḥ pratyavōcan, tasya śōṇitapātāparādhō'smākam asmatsantānānāñcōpari bhavatu| ");
INSERT INTO saniso_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","tataḥ sa tēṣāṁ samīpē barabbāṁ mōcayāmāsa yīśuntu kaṣābhirāhatya kruśēna vēdhituṁ samarpayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","anantaram adhipatēḥ sēnā adhipatē rgr̥haṁ yīśumānīya tasya samīpē sēnāsamūhaṁ saṁjagr̥huḥ| ");
INSERT INTO saniso_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","tatastē tasya vasanaṁ mōcayitvā kr̥ṣṇalōhitavarṇavasanaṁ paridhāpayāmāsuḥ ");
INSERT INTO saniso_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","kaṇṭakānāṁ mukuṭaṁ nirmmāya tacchirasi daduḥ, tasya dakṣiṇakarē vētramēkaṁ dattvā tasya sammukhē jānūni pātayitvā, hē yihūdīyānāṁ rājan, tubhyaṁ nama ityuktvā taṁ tiraścakruḥ, ");
INSERT INTO saniso_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","tatastasya gātrē niṣṭhīvaṁ datvā tēna vētrēṇa śira ājaghnuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","itthaṁ taṁ tiraskr̥tya tad vasanaṁ mōcayitvā punarnijavasanaṁ paridhāpayāñcakruḥ, taṁ kruśēna vēdhituṁ nītavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","paścāttē bahirbhūya kurīṇīyaṁ śimōnnāmakamēkaṁ vilōkya kruśaṁ vōḍhuṁ tamādadirē| ");
INSERT INTO saniso_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","anantaraṁ gulgaltām arthāt śiraskapālanāmakasthānamu pasthāya tē yīśavē pittamiśritāmlarasaṁ pātuṁ daduḥ, ");
INSERT INTO saniso_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","kintu sa tamāsvādya na papau| ");
INSERT INTO saniso_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","tadānīṁ tē taṁ kruśēna saṁvidhya tasya vasanāni guṭikāpātēna vibhajya jagr̥huḥ, tasmāt, vibhajantē'dharīyaṁ mē tē manuṣyāḥ parasparaṁ| maduttarīyavastrārthaṁ guṭikāṁ pātayanti ca||yadētadvacanaṁ bhaviṣyadvādibhiruktamāsīt, tadā tad asidhyat, ");
INSERT INTO saniso_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","paścāt tē tatrōpaviśya tadrakṣaṇakarvvaṇi niyuktāstasthuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","aparam ēṣa yihūdīyānāṁ rājā yīśurityapavādalipipatraṁ tacchirasa ūrdvvē yōjayāmāsuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","tatastasya vāmē dakṣiṇē ca dvau cairau tēna sākaṁ kruśēna vividhuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","tadā pānthā nijaśirō lāḍayitvā taṁ nindantō jagaduḥ, ");
INSERT INTO saniso_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","hē īśvaramandirabhañjaka dinatrayē tannirmmātaḥ svaṁ rakṣa, cēttvamīśvarasutastarhi kruśādavarōha| ");
INSERT INTO saniso_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","pradhānayājakādhyāpakaprācīnāśca tathā tiraskr̥tya jagaduḥ, ");
INSERT INTO saniso_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","sō'nyajanānāvat, kintu svamavituṁ na śaknōti| yadīsrāyēlō rājā bhavēt, tarhīdānīmēva kruśādavarōhatu, tēna taṁ vayaṁ pratyēṣyāmaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","sa īśvarē pratyāśāmakarōt, yadīśvarastasmin santuṣṭastarhīdānīmēva tamavēt, yataḥ sa uktavān ahamīśvarasutaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","yau stēnau sākaṁ tēna kruśēna viddhau tau tadvadēva taṁ ninindatuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","tadā dvitīyayāmāt tr̥tīyayāmaṁ yāvat sarvvadēśē tamiraṁ babhūva, ");
INSERT INTO saniso_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","tr̥tīyayāmē \"ēlī ēlī lāmā śivaktanī\", arthāt madīśvara madīśvara kutō māmatyākṣīḥ? yīśuruccairiti jagāda| ");
INSERT INTO saniso_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","tadā tatra sthitāḥ kēcit tat śrutvā babhāṣirē, ayam ēliyamāhūyati| ");
INSERT INTO saniso_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","tēṣāṁ madhyād ēkaḥ śīghraṁ gatvā spañjaṁ gr̥hītvā tatrāmlarasaṁ dattvā nalēna pātuṁ tasmai dadau| ");
INSERT INTO saniso_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","itarē'kathayan tiṣṭhata, taṁ rakṣitum ēliya āyāti navēti paśyāmaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","yīśuḥ punarucairāhūya prāṇān jahau| ");
INSERT INTO saniso_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","tatō mandirasya vicchēdavasanam ūrdvvādadhō yāvat chidyamānaṁ dvidhābhavat, ");
INSERT INTO saniso_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","bhūmiścakampē bhūdharōvyadīryyata ca| śmaśānē muktē bhūripuṇyavatāṁ suptadēhā udatiṣṭhan, ");
INSERT INTO saniso_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","śmaśānād vahirbhūya tadutthānāt paraṁ puṇyapuraṁ gatvā bahujanān darśayāmāsuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","yīśurakṣaṇāya niyuktaḥ śatasēnāpatistatsaṅginaśca tādr̥śīṁ bhūkampādighaṭanāṁ dr̥ṣṭvā bhītā avadan, ēṣa īśvaraputrō bhavati| ");
INSERT INTO saniso_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","yā bahuyōṣitō yīśuṁ sēvamānā gālīlastatpaścādāgatāstāsāṁ madhyē ");
INSERT INTO saniso_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","magdalīnī mariyam yākūbyōśyō rmātā yā mariyam sibadiyaputrayō rmātā ca yōṣita ētā dūrē tiṣṭhantyō dadr̥śuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","sandhyāyāṁ satyam arimathiyānagarasya yūṣaphnāmā dhanī manujō yīśōḥ śiṣyatvāt ");
INSERT INTO saniso_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","pīlātasya samīpaṁ gatvā yīśōḥ kāyaṁ yayācē, tēna pīlātaḥ kāyaṁ dātum ādidēśa| ");
INSERT INTO saniso_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","yūṣaph tatkāyaṁ nītvā śucivastrēṇācchādya ");
INSERT INTO saniso_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","svārthaṁ śailē yat śmaśānaṁ cakhāna, tanmadhyē tatkāyaṁ nidhāya tasya dvāri vr̥hatpāṣāṇaṁ dadau| ");
INSERT INTO saniso_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","kintu magdalīnī mariyam anyamariyam ētē striyau tatra śmaśānasammukha upaviviśatuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","tadanantaraṁ nistārōtsavasyāyōjanadināt parē'hani pradhānayājakāḥ phirūśinaśca militvā pīlātamupāgatyākathayan, ");
INSERT INTO saniso_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","hē mahēccha sa pratārakō jīvana akathayat, dinatrayāt paraṁ śmaśānādutthāsyāmi tadvākyaṁ smarāmō vayaṁ; ");
INSERT INTO saniso_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","tasmāt tr̥tīyadinaṁ yāvat tat śmaśānaṁ rakṣitumādiśatu, nōcēt tacchiṣyā yāminyāmāgatya taṁ hr̥tvā lōkān vadiṣyanti, sa śmaśānādudatiṣṭhat, tathā sati prathamabhrāntēḥ śēṣīyabhrānti rmahatī bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","tadā pīlāta avādīt, yuṣmākaṁ samīpē rakṣigaṇa āstē, yūyaṁ gatvā yathā sādhyaṁ rakṣayata| ");
INSERT INTO saniso_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","tatastē gatvā taddūाrapāṣāṇaṁ mudrāṅkitaṁ kr̥tvā rakṣigaṇaṁ niyōjya śmaśānaṁ rakṣayāmāsuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","tataḥ paraṁ viśrāmavārasya śēṣē saptāhaprathamadinasya prabhōtē jātē magdalīnī mariyam anyamariyam ca śmaśānaṁ draṣṭumāgatā| ");
INSERT INTO saniso_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","tadā mahān bhūkampō'bhavat; paramēśvarīyadūtaḥ svargādavaruhya śmaśānadvārāt pāṣāṇamapasāryya taduparyyupavivēśa| ");
INSERT INTO saniso_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","tadvadanaṁ vidyudvat tējōmayaṁ vasanaṁ himaśubhrañca| ");
INSERT INTO saniso_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","tadānīṁ rakṣiṇastadbhayāt kampitā mr̥tavad babhūvaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","sa dūtō yōṣitō jagāda, yūyaṁ mā bhaiṣṭa, kruśahatayīśuṁ mr̥gayadhvē tadahaṁ vēdmi| ");
INSERT INTO saniso_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","sō'tra nāsti, yathāvadat tathōtthitavān; ētat prabhōḥ śayanasthānaṁ paśyata| ");
INSERT INTO saniso_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","tūrṇaṁ gatvā tacchiṣyān iti vadata, sa śmaśānād udatiṣṭhat, yuṣmākamagrē gālīlaṁ yāsyati yūyaṁ tatra taṁ vīkṣiṣyadhvē, paśyatāhaṁ vārttāmimāṁ yuṣmānavādiṣaṁ| ");
INSERT INTO saniso_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","tatastā bhayāt mahānandāñca śmaśānāt tūrṇaṁ bahirbhūya tacchiṣyān vārttāṁ vaktuṁ dhāvitavatyaḥ| kintu śiṣyān vārttāṁ vaktuṁ yānti, tadā yīśu rdarśanaṁ dattvā tā jagāda, ");
INSERT INTO saniso_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","yuṣmākaṁ kalyāṇaṁ bhūyāt, tatastā āgatya tatpādayōḥ patitvā praṇēmuḥ| ");
INSERT INTO saniso_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","yīśustā avādīt, mā bibhīta, yūyaṁ gatvā mama bhrātr̥n gālīlaṁ yātuṁ vadata, tatra tē māṁ drakṣyanti| ");
INSERT INTO saniso_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","striyō gacchanti, tadā rakṣiṇāṁ kēcit puraṁ gatvā yadyad ghaṭitaṁ tatsarvvaṁ pradhānayājakān jñāpitavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","tē prācīnaiḥ samaṁ saṁsadaṁ kr̥tvā mantrayantō bahumudrāḥ sēnābhyō dattvāvadan, ");
INSERT INTO saniso_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","asmāsu nidritēṣu tacchiṣyā yāminyāmāgatya taṁ hr̥tvānayan, iti yūyaṁ pracārayata| ");
INSERT INTO saniso_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","yadyētadadhipatēḥ śrōtragōcarībhavēt, tarhi taṁ bōdhayitvā yuṣmānaviṣyāmaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","tatastē mudrā gr̥hītvā śikṣānurūpaṁ karmma cakruḥ, yihūdīyānāṁ madhyē tasyādyāpi kiṁvadantī vidyatē| ");
INSERT INTO saniso_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ēkādaśa śiṣyā yīśunirūpitāgālīlasyādriṁ gatvā ");
INSERT INTO saniso_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","tatra taṁ saṁvīkṣya praṇēmuḥ, kintu kēcit sandigdhavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","yīśustēṣāṁ samīpamāgatya vyāhr̥tavān, svargamēdinyōḥ sarvvādhipatitvabhārō mayyarpita āstē| ");
INSERT INTO saniso_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","atō yūyaṁ prayāya sarvvadēśīyān śiṣyān kr̥tvā pituḥ putrasya pavitrasyātmanaśca nāmnā tānavagāhayata; ahaṁ yuṣmān yadyadādiśaṁ tadapi pālayituṁ tānupādiśata| ");
INSERT INTO saniso_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","paśyata, jagadantaṁ yāvat sadāhaṁ yuṣmābhiḥ sākaṁ tiṣṭhāmi| iti|");
INSERT INTO saniso_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","īśvaraputrasya yīśukhrīṣṭasya susaṁvādārambhaḥ| ");
INSERT INTO saniso_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","bhaviṣyadvādināṁ granthēṣu lipiritthamāstē, paśya svakīyadūtantu tavāgrē prēṣayāmyaham| gatvā tvadīyapanthānaṁ sa hi pariṣkariṣyati| ");
INSERT INTO saniso_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","\"paramēśasya panthānaṁ pariṣkuruta sarvvataḥ| tasya rājapathañcaiva samānaṁ kurutādhunā|\" ityētat prāntarē vākyaṁ vadataḥ kasyacidravaḥ|| ");
INSERT INTO saniso_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","saēva yōhan prāntarē majjitavān tathā pāpamārjananimittaṁ manōvyāvarttakamajjanasya kathāñca pracāritavān| ");
INSERT INTO saniso_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","tatō yihūdādēśayirūśālamnagaranivāsinaḥ sarvvē lōkā bahi rbhūtvā tasya samīpamāgatya svāni svāni pāpānyaṅgīkr̥tya yarddananadyāṁ tēna majjitā babhūvuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","asya yōhanaḥ paridhēyāni kramēlakalōmajāni, tasya kaṭibandhanaṁ carmmajātam, tasya bhakṣyāṇi ca śūkakīṭā vanyamadhūni cāsan| ");
INSERT INTO saniso_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","sa pracārayan kathayāñcakrē, ahaṁ namrībhūya yasya pādukābandhanaṁ mōcayitumapi na yōgyōsmi, tādr̥śō mattō gurutara ēkaḥ puruṣō matpaścādāgacchati| ");
INSERT INTO saniso_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ahaṁ yuṣmān jalē majjitavān kintu sa pavitra ātmāni saṁmajjayiṣyati| ");
INSERT INTO saniso_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","aparañca tasminnēva kālē gālīlpradēśasya nāsaradgrāmād yīśurāgatya yōhanā yarddananadyāṁ majjitō'bhūt| ");
INSERT INTO saniso_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","sa jalādutthitamātrō mēghadvāraṁ muktaṁ kapōtavat svasyōpari avarōhantamātmānañca dr̥ṣṭavān| ");
INSERT INTO saniso_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","tvaṁ mama priyaḥ putrastvayyēva mamamahāsantōṣa iyamākāśīyā vāṇī babhūva| ");
INSERT INTO saniso_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","tasmin kālē ātmā taṁ prāntaramadhyaṁ nināya| ");
INSERT INTO saniso_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","atha sa catvāriṁśaddināni tasmin sthānē vanyapaśubhiḥ saha tiṣṭhan śaitānā parīkṣitaḥ; paścāt svargīyadūtāstaṁ siṣēvirē| ");
INSERT INTO saniso_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","anantaraṁ yōhani bandhanālayē baddhē sati yīśu rgālīlpradēśamāgatya īśvararājyasya susaṁvādaṁ pracārayan kathayāmāsa, ");
INSERT INTO saniso_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","kālaḥ sampūrṇa īśvararājyañca samīpamāgataṁ; atōhētō ryūyaṁ manāṁsi vyāvarttayadhvaṁ susaṁvādē ca viśvāsita| ");
INSERT INTO saniso_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","tadanantaraṁ sa gālīlīyasamudrasya tīrē gacchan śimōn tasya bhrātā andriyanāmā ca imau dvau janau matsyadhāriṇau sāgaramadhyē jālaṁ prakṣipantau dr̥ṣṭvā tāvavadat, ");
INSERT INTO saniso_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","yuvāṁ mama paścādāgacchataṁ, yuvāmahaṁ manuṣyadhāriṇau kariṣyāmi| ");
INSERT INTO saniso_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","tatastau tatkṣaṇamēva jālāni parityajya tasya paścāt jagmatuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","tataḥ paraṁ tatsthānāt kiñcid dūraṁ gatvā sa sivadīputrayākūb tadbhrātr̥yōhan ca imau naukāyāṁ jālānāṁ jīrṇamuddhārayantau dr̥ṣṭvā tāvāhūyat| ");
INSERT INTO saniso_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","tatastau naukāyāṁ vētanabhugbhiḥ sahitaṁ svapitaraṁ vihāya tatpaścādīyatuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","tataḥ paraṁ kapharnāhūmnāmakaṁ nagaramupasthāya sa viśrāmadivasē bhajanagrahaṁ praviśya samupadidēśa| ");
INSERT INTO saniso_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","tasyōpadēśāllōkā āścaryyaṁ mēnirē yataḥ sōdhyāpakāiva nōpadiśan prabhāvavāniva prōpadidēśa| ");
INSERT INTO saniso_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","aparañca tasmin bhajanagr̥hē apavitrabhūtēna grasta ēkō mānuṣa āsīt| sa cītśabdaṁ kr̥tvā kathayāñcakē ");
INSERT INTO saniso_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","bhō nāsaratīya yīśō tvamasmān tyaja, tvayā sahāsmākaṁ kaḥ sambandhaḥ? tvaṁ kimasmān nāśayituṁ samāgataḥ? tvamīśvarasya pavitralōka ityahaṁ jānāmi| ");
INSERT INTO saniso_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","tadā yīśustaṁ tarjayitvā jagāda tūṣṇīṁ bhava itō bahirbhava ca| ");
INSERT INTO saniso_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","tataḥ sō'pavitrabhūtastaṁ sampīḍya atyucaiścītkr̥tya nirjagāma| ");
INSERT INTO saniso_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","tēnaiva sarvvē camatkr̥tya parasparaṁ kathayāñcakrirē, ahō kimidaṁ? kīdr̥śō'yaṁ navya upadēśaḥ? anēna prabhāvēnāpavitrabhūtēṣvājñāpitēṣu tē tadājñānuvarttinō bhavanti| ");
INSERT INTO saniso_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","tadā tasya yaśō gālīlaścaturdiksthasarvvadēśān vyāpnōt| ");
INSERT INTO saniso_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","aparañca tē bhajanagr̥hād bahi rbhūtvā yākūbyōhanbhyāṁ saha śimōna āndriyasya ca nivēśanaṁ praviviśuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","tadā pitarasya śvaśrūrjvarapīḍitā śayyāyāmāsta iti tē taṁ jhaṭiti vijñāpayāñcakruḥ| ");
INSERT INTO saniso_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","tataḥ sa āgatya tasyā hastaṁ dhr̥tvā tāmudasthāpayat; tadaiva tāṁ jvarō'tyākṣīt tataḥ paraṁ sā tān siṣēvē| ");
INSERT INTO saniso_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","athāstaṁ gatē ravau sandhyākālē sati lōkāstatsamīpaṁ sarvvān rōgiṇō bhūtadhr̥tāṁśca samāninyuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","sarvvē nāgarikā lōkā dvāri saṁmilitāśca| ");
INSERT INTO saniso_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","tataḥ sa nānāvidharōgiṇō bahūn manujānarōgiṇaścakāra tathā bahūn bhūtān tyājayāñcakāra tān bhūtān kimapi vākyaṁ vaktuṁ niṣiṣēdha ca yatōhētōstē tamajānan| ");
INSERT INTO saniso_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","aparañca sō'tipratyūṣē vastutastu rātriśēṣē samutthāya bahirbhūya nirjanaṁ sthānaṁ gatvā tatra prārthayāñcakrē| ");
INSERT INTO saniso_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","anantaraṁ śimōn tatsaṅginaśca tasya paścād gatavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","taduddēśaṁ prāpya tamavadan sarvvē lōkāstvāṁ mr̥gayantē| ");
INSERT INTO saniso_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","tadā sō'kathayat āgacchata vayaṁ samīpasthāni nagarāṇi yāmaḥ, yatō'haṁ tatra kathāṁ pracārayituṁ bahirāgamam| ");
INSERT INTO saniso_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","atha sa tēṣāṁ gālīlpradēśasya sarvvēṣu bhajanagr̥hēṣu kathāḥ pracārayāñcakrē bhūtānatyājayañca| ");
INSERT INTO saniso_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","anantaramēkaḥ kuṣṭhī samāgatya tatsammukhē jānupātaṁ vinayañca kr̥tvā kathitavān yadi bhavān icchati tarhi māṁ pariṣkarttuṁ śaknōti| ");
INSERT INTO saniso_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","tataḥ kr̥pālu ryīśuḥ karau prasāryya taṁ spaṣṭvā kathayāmāsa ");
INSERT INTO saniso_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","mamēcchā vidyatē tvaṁ pariṣkr̥tō bhava| ētatkathāyāḥ kathanamātrāt sa kuṣṭhī rōgānmuktaḥ pariṣkr̥tō'bhavat| ");
INSERT INTO saniso_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","tadā sa taṁ visr̥jan gāḍhamādiśya jagāda ");
INSERT INTO saniso_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","sāvadhānō bhava kathāmimāṁ kamapi mā vada; svātmānaṁ yājakaṁ darśaya, lōkēbhyaḥ svapariṣkr̥tēḥ pramāṇadānāya mūsānirṇītaṁ yaddānaṁ tadutsr̥jasva ca| ");
INSERT INTO saniso_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","kintu sa gatvā tat karmma itthaṁ vistāryya pracārayituṁ prārēbhē tēnaiva yīśuḥ punaḥ saprakāśaṁ nagaraṁ pravēṣṭuṁ nāśaknōt tatōhētōrbahiḥ kānanasthānē tasyau; tathāpi caturddigbhyō lōkāstasya samīpamāyayuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","tadanantaraṁ yīśai katipayadināni vilambya punaḥ kapharnāhūmnagaraṁ praviṣṭē sa gr̥ha āsta iti kiṁvadantyā tatkṣaṇaṁ tatsamīpaṁ bahavō lōkā āgatya samupatasthuḥ, ");
INSERT INTO saniso_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","tasmād gr̥hamadhyē sarvvēṣāṁ kr̥tē sthānaṁ nābhavad dvārasya caturdikṣvapi nābhavat, tatkālē sa tān prati kathāṁ pracārayāñcakrē| ");
INSERT INTO saniso_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","tataḥ paraṁ lōkāścaturbhi rmānavairēkaṁ pakṣāghātinaṁ vāhayitvā tatsamīpam āninyuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","kintu janānāṁ bahutvāt taṁ yīśōḥ sammukhamānētuṁ na śaknuvantō yasmin sthānē sa āstē taduparigr̥hapr̥ṣṭhaṁ khanitvā chidraṁ kr̥tvā tēna mārgēṇa saśayyaṁ pakṣāghātinam avarōhayāmāsuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","tatō yīśustēṣāṁ viśvāsaṁ dr̥ṣṭvā taṁ pakṣāghātinaṁ babhāṣē hē vatsa tava pāpānāṁ mārjanaṁ bhavatu| ");
INSERT INTO saniso_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","tadā kiyantō'dhyāpakāstatrōpaviśantō manōbhi rvitarkayāñcakruḥ, ēṣa manuṣya ētādr̥śīmīśvaranindāṁ kathāṁ kutaḥ kathayati? ");
INSERT INTO saniso_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","īśvaraṁ vinā pāpāni mārṣṭuṁ kasya sāmarthyam āstē? ");
INSERT INTO saniso_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","itthaṁ tē vitarkayanti yīśustatkṣaṇaṁ manasā tad budvvā tānavadad yūyamantaḥkaraṇaiḥ kuta ētāni vitarkayatha? ");
INSERT INTO saniso_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","tadanantaraṁ yīśustatsthānāt punaḥ samudrataṭaṁ yayau; lōkanivahē tatsamīpamāgatē sa tān samupadidēśa| ");
INSERT INTO saniso_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","kintu pr̥thivyāṁ pāpāni mārṣṭuṁ manuṣyaputrasya sāmarthyamasti, ētad yuṣmān jñāpayituṁ (sa tasmai pakṣāghātinē kathayāmāsa) ");
INSERT INTO saniso_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","uttiṣṭha tava śayyāṁ gr̥hītvā svagr̥haṁ yāhi, ahaṁ tvāmidam ājñāpayāmi| ");
INSERT INTO saniso_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","tataḥ sa tatkṣaṇam utthāya śayyāṁ gr̥hītvā sarvvēṣāṁ sākṣāt jagāma; sarvvē vismitā ētādr̥śaṁ karmma vayam kadāpi nāpaśyāma, imāṁ kathāṁ kathayitvēśvaraṁ dhanyamabruvan| ");
INSERT INTO saniso_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","tadanantaraṁ yīśustatsthānāt punaḥ samudrataṭaṁ yayau; lōkanivahē tatsamīpamāgatē sa tān samupadidēśa| ");
INSERT INTO saniso_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","atha gacchan karasañcayagr̥ha upaviṣṭam ālphīyaputraṁ lēviṁ dr̥ṣṭvā tamāhūya kathitavān matpaścāt tvāmāmaccha tataḥ sa utthāya tatpaścād yayau| ");
INSERT INTO saniso_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","anantaraṁ yīśau tasya gr̥hē bhōktum upaviṣṭē bahavaḥ karamañcāyinaḥ pāpinaśca tēna tacchiṣyaiśca sahōpaviviśuḥ, yatō bahavastatpaścādājagmuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","tadā sa karamañcāyibhiḥ pāpibhiśca saha khādati, tad dr̥ṣṭvādhyāpakāḥ phirūśinaśca tasya śiṣyānūcuḥ karamañcāyibhiḥ pāpibhiśca sahāyaṁ kutō bhuṁktē pivati ca? ");
INSERT INTO saniso_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","tadvākyaṁ śrutvā yīśuḥ pratyuvāca,arōgilōkānāṁ cikitsakēna prayōjanaṁ nāsti, kintu rōgiṇāmēva; ahaṁ dhārmmikānāhvātuṁ nāgataḥ kintu manō vyāvarttayituṁ pāpina ēva| ");
INSERT INTO saniso_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","tataḥ paraṁ yōhanaḥ phirūśināñcōpavāsācāriśiṣyā yīśōḥ samīpam āgatya kathayāmāsuḥ, yōhanaḥ phirūśināñca śiṣyā upavasanti kintu bhavataḥ śiṣyā nōpavasanti kiṁ kāraṇamasya? ");
INSERT INTO saniso_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","tadā yīśustān babhāṣē yāvat kālaṁ sakhibhiḥ saha kanyāyā varastiṣṭhati tāvatkālaṁ tē kimupavastuṁ śaknuvanti? yāvatkālaṁ varastaiḥ saha tiṣṭhati tāvatkālaṁ ta upavastuṁ na śaknuvanti| ");
INSERT INTO saniso_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","yasmin kālē tēbhyaḥ sakāśād varō nēṣyatē sa kāla āgacchati, tasmin kālē tē janā upavatsyanti| ");
INSERT INTO saniso_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","kōpi janaḥ purātanavastrē nūtanavastraṁ na sīvyati, yatō nūtanavastrēṇa saha sēvanē kr̥tē jīrṇaṁ vastraṁ chidyatē tasmāt puna rmahat chidraṁ jāyatē| ");
INSERT INTO saniso_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","kōpi janaḥ purātanakutūṣu nūtanaṁ drākṣārasaṁ na sthāpayati, yatō nūtanadrākṣārasasya tējasā tāḥ kutvō vidīryyantē tatō drākṣārasaśca patati kutvaśca naśyanti, ataēva nūtanadrākṣārasō nūtanakutūṣu sthāpanīyaḥ| ");
INSERT INTO saniso_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","tadanantaraṁ yīśu ryadā viśrāmavārē śasyakṣētrēṇa gacchati tadā tasya śiṣyā gacchantaḥ śasyamañjarīśchēttuṁ pravr̥ttāḥ| ");
INSERT INTO saniso_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ataḥ phirūśinō yīśavē kathayāmāsuḥ paśyatu viśrāmavāsarē yat karmma na karttavyaṁ tad imē kutaḥ kurvvanti? ");
INSERT INTO saniso_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","tadā sa tēbhyō'kathayat dāyūd tatsaṁṅginaśca bhakṣyābhāvāt kṣudhitāḥ santō yat karmma kr̥tavantastat kiṁ yuṣmābhi rna paṭhitam? ");
INSERT INTO saniso_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","abiyātharnāmakē mahāyājakatāṁ kurvvati sa kathamīśvarasyāvāsaṁ praviśya yē darśanīyapūpā yājakān vinānyasya kasyāpi na bhakṣyāstānēva bubhujē saṅgilōkēbhyō'pi dadau| ");
INSERT INTO saniso_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","sō'paramapi jagāda, viśrāmavārō manuṣyārthamēva nirūpitō'sti kintu manuṣyō viśrāmavārārthaṁ naiva| ");
INSERT INTO saniso_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","manuṣyaputrō viśrāmavārasyāpi prabhurāstē| ");
INSERT INTO saniso_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","anantaraṁ yīśuḥ puna rbhajanagr̥haṁ praviṣṭastasmin sthānē śuṣkahasta ēkō mānava āsīt| ");
INSERT INTO saniso_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","sa viśrāmavārē tamarōgiṇaṁ kariṣyati navētyatra bahavastam apavadituṁ chidramapēkṣitavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","tadā sa taṁ śuṣkahastaṁ manuṣyaṁ jagāda madhyasthānē tvamuttiṣṭha| ");
INSERT INTO saniso_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","tataḥ paraṁ sa tān papraccha viśrāmavārē hitamahitaṁ tathā hi prāṇarakṣā vā prāṇanāśa ēṣāṁ madhyē kiṁ karaṇīyaṁ ? kintu tē niḥśabdāstasthuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","tadā sa tēṣāmantaḥkaraṇānāṁ kāṭhinyāddhētō rduḥkhitaḥ krōdhāt cartuिdaśō dr̥ṣṭavān taṁ mānuṣaṁ gaditavān taṁ hastaṁ vistāraya, tatastēna hastē vistr̥tē taddhastō'nyahastavad arōgō jātaḥ| ");
INSERT INTO saniso_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","atha phirūśinaḥ prasthāya taṁ nāśayituṁ hērōdīyaiḥ saha mantrayitumārēbhirē| ");
INSERT INTO saniso_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ataēva yīśustatsthānaṁ parityajya śiṣyaiḥ saha punaḥ sāgarasamīpaṁ gataḥ; ");
INSERT INTO saniso_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","tatō gālīlyihūdā-yirūśālam-idōm-yardannadīpārasthānēbhyō lōkasamūhastasya paścād gataḥ; tadanyaḥ sōrasīdanōḥ samīpavāsilōkasamūhaśca tasya mahākarmmaṇāṁ vārttaṁ śrutvā tasya sannidhimāgataḥ| ");
INSERT INTO saniso_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","tadā lōkasamūhaścēt tasyōpari patati ityāśaṅkya sa nāvamēkāṁ nikaṭē sthāpayituṁ śiṣyānādiṣṭavān| ");
INSERT INTO saniso_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","yatō'nēkamanuṣyāṇāmārōgyakaraṇād vyādhigrastāḥ sarvvē taṁ spraṣṭuṁ parasparaṁ balēna yatnavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","aparañca apavitrabhūtāstaṁ dr̥ṣṭvā taccaraṇayōḥ patitvā prōcaiḥ prōcuḥ, tvamīśvarasya putraḥ| ");
INSERT INTO saniso_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","kintu sa tān dr̥ḍham ājñāpya svaṁ paricāyituṁ niṣiddhavān| ");
INSERT INTO saniso_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","anantaraṁ sa parvvatamāruhya yaṁ yaṁ praticchā taṁ tamāhūtavān tatastē tatsamīpamāgatāḥ| ");
INSERT INTO saniso_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","tadā sa dvādaśajanān svēna saha sthātuṁ susaṁvādapracārāya prēritā bhavituṁ ");
INSERT INTO saniso_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","sarvvaprakāravyādhīnāṁ śamanakaraṇāya prabhāvaṁ prāptuṁ bhūtān tyājayituñca niyuktavān| ");
INSERT INTO saniso_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","tēṣāṁ nāmānīmāni, śimōn sivadiputrō ");
INSERT INTO saniso_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","yākūb tasya bhrātā yōhan ca āndriyaḥ philipō barthalamayaḥ, ");
INSERT INTO saniso_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","mathī thōmā ca ālphīyaputrō yākūb thaddīyaḥ kinānīyaḥ śimōn yastaṁ parahastēṣvarpayiṣyati sa īṣkariyōtīyayihūdāśca| ");
INSERT INTO saniso_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","sa śimōnē pitara ityupanāma dadau yākūbyōhanbhyāṁ ca binērigiś arthatō mēghanādaputrāvityupanāma dadau| ");
INSERT INTO saniso_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","anantaraṁ tē nivēśanaṁ gatāḥ, kintu tatrāpi punarmahān janasamāgamō 'bhavat tasmāttē bhōktumapyavakāśaṁ na prāptāḥ| ");
INSERT INTO saniso_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","tatastasya suhr̥llōkā imāṁ vārttāṁ prāpya sa hatajñānōbhūd iti kathāṁ kathayitvā taṁ dhr̥tvānētuṁ gatāḥ| ");
INSERT INTO saniso_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","aparañca yirūśālama āgatā yē yē'dhyāpakāstē jagadurayaṁ puruṣō bhūtapatyābiṣṭastēna bhūtapatinā bhūtān tyājayati| ");
INSERT INTO saniso_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","tatastānāhūya yīśu rdr̥ṣṭāntaiḥ kathāṁ kathitavān śaitān kathaṁ śaitānaṁ tyājayituṁ śaknōti? ");
INSERT INTO saniso_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","kiñcana rājyaṁ yadi svavirōdhēna pr̥thag bhavati tarhi tad rājyaṁ sthiraṁ sthātuṁ na śaknōti| ");
INSERT INTO saniso_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","tathā kasyāpi parivārō yadi parasparaṁ virōdhī bhavati tarhi sōpi parivāraḥ sthiraṁ sthātuṁ na śaknōti| ");
INSERT INTO saniso_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","tadvat śaitān yadi svavipakṣatayā uttiṣṭhan bhinnō bhavati tarhi sōpi sthiraṁ sthātuṁ na śaknōti kintūcchinnō bhavati| ");
INSERT INTO saniso_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","aparañca prabalaṁ janaṁ prathamaṁ na baddhā kōpi tasya gr̥haṁ praviśya dravyāṇi luṇṭhayituṁ na śaknōti, taṁ badvvaiva tasya gr̥hasya dravyāṇi luṇṭhayituṁ śaknōti| ");
INSERT INTO saniso_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","atōhētō ryuṣmabhyamahaṁ satyaṁ kathayāmi manuṣyāṇāṁ santānā yāni yāni pāpānīśvaranindāñca kurvvanti tēṣāṁ tatsarvvēṣāmaparādhānāṁ kṣamā bhavituṁ śaknōti, ");
INSERT INTO saniso_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","kintu yaḥ kaścit pavitramātmānaṁ nindati tasyāparādhasya kṣamā kadāpi na bhaviṣyati sōnantadaṇḍasyārhō bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","tasyāpavitrabhūtō'sti tēṣāmētatkathāhētōḥ sa itthaṁ kathitavān| ");
INSERT INTO saniso_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","atha tasya mātā bhrātr̥gaṇaścāgatya bahistiṣṭhanatō lōkān prēṣya tamāhūtavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","tatastatsannidhau samupaviṣṭā lōkāstaṁ babhāṣirē paśya bahistava mātā bhrātaraśca tvām anvicchanti| ");
INSERT INTO saniso_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","tadā sa tān pratyuvāca mama mātā kā bhrātarō vā kē? tataḥ paraṁ sa svamīpōpaviṣṭān śiṣyān prati avalōkanaṁ kr̥tvā kathayāmāsa ");
INSERT INTO saniso_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","paśyataitē mama mātā bhrātaraśca| ");
INSERT INTO saniso_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","yaḥ kaścid īśvarasyēṣṭāṁ kriyāṁ karōti sa ēva mama bhrātā bhaginī mātā ca| ");
INSERT INTO saniso_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","anantaraṁ sa samudrataṭē punarupadēṣṭuṁ prārēbhē, tatastatra bahujanānāṁ samāgamāt sa sāgarōpari naukāmāruhya samupaviṣṭaḥ; sarvvē lōkāḥ samudrakūlē tasthuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","tadā sa dr̥ṣṭāntakathābhi rbahūpadiṣṭavān upadiśaṁśca kathitavān, ");
INSERT INTO saniso_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","avadhānaṁ kuruta, ēkō bījavaptā bījāni vaptuṁ gataḥ; ");
INSERT INTO saniso_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","vapanakālē kiyanti bījāni mārgapāśvē patitāni, tata ākāśīyapakṣiṇa ētya tāni cakhāduḥ| ");
INSERT INTO saniso_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","kiyanti bījāni svalpamr̥ttikāvatpāṣāṇabhūmau patitāni tāni mr̥dōlpatvāt śīghramaṅkuritāni; ");
INSERT INTO saniso_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","kintūditē sūryyē dagdhāni tathā mūlānō nādhōgatatvāt śuṣkāṇi ca| ");
INSERT INTO saniso_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","kiyanti bījāni kaṇṭakivanamadhyē patitāni tataḥ kaṇṭakāni saṁvr̥dvya tāni jagrasustāni na ca phalitāni| ");
INSERT INTO saniso_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","tathā kiyanti bījānyuttamabhūmau patitāni tāni saṁvr̥dvya phalānyutpāditāni kiyanti bījāni triṁśadguṇāni kiyanti ṣaṣṭiguṇāni kiyanti śataguṇāni phalāni phalitavanti| ");
INSERT INTO saniso_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","atha sa tānavadat yasya śrōtuṁ karṇau staḥ sa śr̥ṇōtu| ");
INSERT INTO saniso_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","tadanantaraṁ nirjanasamayē tatsaṅginō dvādaśaśiṣyāśca taṁ taddr̥ṣṭāntavākyasyārthaṁ papracchuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","tadā sa tānuditavān īśvararājyasya nigūḍhavākyaṁ bōddhuṁ yuṣmākamadhikārō'sti; ");
INSERT INTO saniso_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","kintu yē vahirbhūtāḥ \"tē paśyantaḥ paśyanti kintu na jānanti, śr̥ṇvantaḥ śr̥ṇvanti kintu na budhyantē, cēttai rmanaḥsu kadāpi parivarttitēṣu tēṣāṁ pāpānyamōcayiṣyanta,\" atōhētōstān prati dr̥ṣṭāntairēva tāni mayā kathitāni| ");
INSERT INTO saniso_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","atha sa kathitavān yūyaṁ kimētad dr̥ṣṭāntavākyaṁ na budhyadhvē? tarhi kathaṁ sarvvān dr̥ṣṭāntāna bhōtsyadhvē? ");
INSERT INTO saniso_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","bījavaptā vākyarūpāṇi bījāni vapati; ");
INSERT INTO saniso_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","tatra yē yē lōkā vākyaṁ śr̥ṇvanti, kintu śrutamātrāt śaitān śīghramāgatya tēṣāṁ manaḥsūptāni tāni vākyarūpāṇi bījānyapanayati taēva uptabījamārgapārśvēsvarūpāḥ| ");
INSERT INTO saniso_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","yē janā vākyaṁ śrutvā sahasā paramānandēna gr̥hlanti, kintu hr̥di sthairyyābhāvāt kiñcit kālamātraṁ tiṣṭhanti tatpaścāt tadvākyahētōḥ ");
INSERT INTO saniso_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","kutracit klēśē upadravē vā samupasthitē tadaiva vighnaṁ prāpnuvanti taēva uptabījapāṣāṇabhūmisvarūpāḥ| ");
INSERT INTO saniso_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","yē janāḥ kathāṁ śr̥ṇvanti kintu sāṁsārikī cintā dhanabhrānti rviṣayalōbhaśca ētē sarvvē upasthāya tāṁ kathāṁ grasanti tataḥ mā viphalā bhavati ");
INSERT INTO saniso_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","taēva uptabījasakaṇṭakabhūmisvarūpāḥ| ");
INSERT INTO saniso_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","yē janā vākyaṁ śrutvā gr̥hlanti tēṣāṁ kasya vā triṁśadguṇāni kasya vā ṣaṣṭiguṇāni kasya vā śataguṇāni phalāni bhavanti taēva uptabījōrvvarabhūmisvarūpāḥ| ");
INSERT INTO saniso_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","tadā sō'paramapi kathitavān kōpi janō dīpādhāraṁ parityajya drōṇasyādhaḥ khaṭvāyā adhē vā sthāpayituṁ dīpamānayati kiṁ? ");
INSERT INTO saniso_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","atōhētō ryanna prakāśayiṣyatē tādr̥g lukkāyitaṁ kimapi vastu nāsti; yad vyaktaṁ na bhaviṣyati tādr̥śaṁ guptaṁ kimapi vastu nāsti| ");
INSERT INTO saniso_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","yasya śrōtuṁ karṇau staḥ sa śr̥ṇōtu| ");
INSERT INTO saniso_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","aparamapi kathitavān yūyaṁ yad yad vākyaṁ śr̥ṇutha tatra sāvadhānā bhavata, yatō yūyaṁ yēna parimāṇēna parimātha tēnaiva parimāṇēna yuṣmadarthamapi parimāsyatē; śrōtārō yūyaṁ yuṣmabhyamadhikaṁ dāsyatē| ");
INSERT INTO saniso_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","yasyāśrayē varddhatē tasmai aparamapi dāsyatē, kintu yasyāśrayē na varddhatē tasya yat kiñcidasti tadapi tasmān nēṣyatē| ");
INSERT INTO saniso_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","anantaraṁ sa kathitavān ēkō lōkaḥ kṣētrē bījānyuptvā ");
INSERT INTO saniso_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","jāgaraṇanidrābhyāṁ divāniśaṁ gamayati, parantu tadvījaṁ tasyājñātarūpēṇāṅkurayati varddhatē ca; ");
INSERT INTO saniso_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","yatōhētōḥ prathamataḥ patrāṇi tataḥ paraṁ kaṇiśāni tatpaścāt kaṇiśapūrṇāni śasyāni bhūmiḥ svayamutpādayati; ");
INSERT INTO saniso_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","kintu phalēṣu pakkēṣu śasyacchēdanakālaṁ jñātvā sa tatkṣaṇaṁ śasyāni chinatti, anēna tulyamīśvararājyaṁ| ");
INSERT INTO saniso_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","punaḥ sō'kathayad īśvararājyaṁ kēna samaṁ? kēna vastunā saha vā tadupamāsyāmi? ");
INSERT INTO saniso_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","tat sarṣapaikēna tulyaṁ yatō mr̥di vapanakālē sarṣapabījaṁ sarvvapr̥thivīsthabījāt kṣudraṁ ");
INSERT INTO saniso_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","kintu vapanāt param aṅkurayitvā sarvvaśākād br̥had bhavati, tasya br̥hatyaḥ śākhāśca jāyantē tatastacchāyāṁ pakṣiṇa āśrayantē| ");
INSERT INTO saniso_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","itthaṁ tēṣāṁ bōdhānurūpaṁ sō'nēkadr̥ṣṭāntaistānupadiṣṭavān, ");
INSERT INTO saniso_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","dr̥ṣṭāntaṁ vinā kāmapi kathāṁ tēbhyō na kathitavān paścān nirjanē sa śiṣyān sarvvadr̥ṣṭāntārthaṁ bōdhitavān| ");
INSERT INTO saniso_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","taddinasya sandhyāyāṁ sa tēbhyō'kathayad āgacchata vayaṁ pāraṁ yāma| ");
INSERT INTO saniso_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","tadā tē lōkān visr̥jya tamavilambaṁ gr̥hītvā naukayā pratasthirē; aparā api nāvastayā saha sthitāḥ| ");
INSERT INTO saniso_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","tataḥ paraṁ mahājhañbhśagamāt nau rdōlāyamānā taraṅgēṇa jalaiḥ pūrṇābhavacca| ");
INSERT INTO saniso_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","tadā sa naukācaścādbhāgē upadhānē śirō nidhāya nidrita āsīt tatastē taṁ jāgarayitvā jagaduḥ, hē prabhō, asmākaṁ prāṇā yānti kimatra bhavataścintā nāsti? ");
INSERT INTO saniso_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","tadā sa utthāya vāyuṁ tarjitavān samudrañcōktavān śāntaḥ susthiraśca bhava; tatō vāyau nivr̥ttē'bdhirnistaraṅgōbhūt| ");
INSERT INTO saniso_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","tadā sa tānuvāca yūyaṁ kuta ētādr̥kśaṅkākulā bhavata? kiṁ vō viśvāsō nāsti? ");
INSERT INTO saniso_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","tasmāttē'tīvabhītāḥ parasparaṁ vaktumārēbhirē, ahō vāyuḥ sindhuścāsya nidēśagrāhiṇau kīdr̥gayaṁ manujaḥ| ");
INSERT INTO saniso_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","atha tū sindhupāraṁ gatvā gidērīyapradēśa upatasthuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","naukātō nirgatamātrād apavitrabhūtagrasta ēkaḥ śmaśānādētya taṁ sākṣāc cakāra| ");
INSERT INTO saniso_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","sa śmaśānē'vātsīt kōpi taṁ śr̥ṅkhalēna badvvā sthāpayituṁ nāśaknōt| ");
INSERT INTO saniso_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","janairvāraṁ nigaḍaiḥ śr̥ṅkhalaiśca sa baddhōpi śr̥ṅkhalānyākr̥ṣya mōcitavān nigaḍāni ca bhaṁktvā khaṇḍaṁ khaṇḍaṁ kr̥tavān kōpi taṁ vaśīkarttuṁ na śaśaka| ");
INSERT INTO saniso_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","divāniśaṁ sadā parvvataṁ śmaśānañca bhramitvā cītśabdaṁ kr̥tavān grāvabhiśca svayaṁ svaṁ kr̥tavān| ");
INSERT INTO saniso_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","sa yīśuṁ dūrāt paśyannēva dhāvan taṁ praṇanāma ucairuvaṁścōvāca, ");
INSERT INTO saniso_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","hē sarvvōparisthēśvaraputra yīśō bhavatā saha mē kaḥ sambandhaḥ? ahaṁ tvāmīśvarēṇa śāpayē māṁ mā yātaya| ");
INSERT INTO saniso_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","yatō yīśustaṁ kathitavān rē apavitrabhūta, asmānnarād bahirnirgaccha| ");
INSERT INTO saniso_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","atha sa taṁ pr̥ṣṭavān kintē nāma? tēna pratyuktaṁ vayamanēkē 'smastatō'smannāma bāhinī| ");
INSERT INTO saniso_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","tatōsmān dēśānna prēṣayēti tē taṁ prārthayanta| ");
INSERT INTO saniso_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","tadānīṁ parvvataṁ nikaṣā br̥han varāhavrajaścarannāsīt| ");
INSERT INTO saniso_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","tasmād bhūtā vinayēna jagaduḥ, amuṁ varāhavrajam āśrayitum asmān prahiṇu| ");
INSERT INTO saniso_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","yīśunānujñātāstē'pavitrabhūtā bahirniryāya varāhavrajaṁ prāviśan tataḥ sarvvē varāhā vastutastu prāyōdvisahasrasaṁṅkhyakāḥ kaṭakēna mahājavād dhāvantaḥ sindhau prāṇān jahuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","tasmād varāhapālakāḥ palāyamānāḥ purē grāmē ca tadvārttaṁ kathayāñcakruḥ| tadā lōkā ghaṭitaṁ tatkāryyaṁ draṣṭuṁ bahirjagmuḥ ");
INSERT INTO saniso_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","yīśōḥ sannidhiṁ gatvā taṁ bhūtagrastam arthād bāhinībhūtagrastaṁ naraṁ savastraṁ sacētanaṁ samupaviṣṭañca dr̥ृṣṭvā bibhyuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","tatō dr̥ṣṭatatkāryyalōkāstasya bhūtagrastanarasya varāhavrajasyāpi tāṁ dhaṭanāṁ varṇayāmāsuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","tatastē svasīmātō bahirgantuṁ yīśuṁ vinētumārēbhirē| ");
INSERT INTO saniso_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","atha tasya naukārōhaṇakālē sa bhūtamuktō nā yīśunā saha sthātuṁ prārthayatē; ");
INSERT INTO saniso_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","kintu sa tamananumatya kathitavān tvaṁ nijātmīyānāṁ samīpaṁ gr̥hañca gaccha prabhustvayi kr̥pāṁ kr̥tvā yāni karmmāṇi kr̥tavān tāni tān jñāpaya| ");
INSERT INTO saniso_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ataḥ sa prasthāya yīśunā kr̥taṁ tatsarvvāścaryyaṁ karmma dikāpalidēśē pracārayituṁ prārabdhavān tataḥ sarvvē lōkā āścaryyaṁ mēnirē| ");
INSERT INTO saniso_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","anantaraṁ yīśau nāvā punaranyapāra uttīrṇē sindhutaṭē ca tiṣṭhati sati tatsamīpē bahulōkānāṁ samāgamō'bhūt| ");
INSERT INTO saniso_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","aparaṁ yāyīr nāmnā kaścid bhajanagr̥hasyādhipa āgatya taṁ dr̥ṣṭvaiva caraṇayōḥ patitvā bahu nivēdya kathitavān; ");
INSERT INTO saniso_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","mama kanyā mr̥taprāyābhūd atō bhavānētya tadārōgyāya tasyā gātrē hastam arpayatu tēnaiva sā jīviṣyati| ");
INSERT INTO saniso_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","tadā yīśustēna saha calitaḥ kintu tatpaścād bahulōkāścalitvā tādgātrē patitāḥ| ");
INSERT INTO saniso_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","atha dvādaśavarṣāṇi pradararōgēṇa ");
INSERT INTO saniso_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","śīrṇā cikitsakānāṁ nānācikitsābhiśca duḥkhaṁ bhuktavatī ca sarvvasvaṁ vyayitvāpi nārōgyaṁ prāptā ca punarapi pīḍitāsīcca ");
INSERT INTO saniso_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","yā strī sā yīśō rvārttāṁ prāpya manasākathayat yadyahaṁ tasya vastramātra spraṣṭuṁ labhēyaṁ tadā rōgahīnā bhaviṣyāmi| ");
INSERT INTO saniso_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","atōhētōḥ sā lōkāraṇyamadhyē tatpaścādāgatya tasya vastraṁ pasparśa| ");
INSERT INTO saniso_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","tēnaiva tatkṣaṇaṁ tasyā raktasrōtaḥ śuṣkaṁ svayaṁ tasmād rōgānmuktā ityapi dēhē'nubhūtā| ");
INSERT INTO saniso_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","atha svasmāt śakti rnirgatā yīśurētanmanasā jñātvā lōkanivahaṁ prati mukhaṁ vyāvr̥tya pr̥ṣṭavān kēna madvastraṁ spr̥ṣṭaṁ? ");
INSERT INTO saniso_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","tatastasya śiṣyā ūcuḥ bhavatō vapuṣi lōkāḥ saṁgharṣanti tad dr̥ṣṭvā kēna madvastraṁ spr̥ṣṭamiti kutaḥ kathayati? ");
INSERT INTO saniso_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","kintu kēna tat karmma kr̥taṁ tad draṣṭuṁ yīśuścaturdiśō dr̥ṣṭavān| ");
INSERT INTO saniso_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","tataḥ sā strī bhītā kampitā ca satī svasyā rukpratikriyā jātēti jñātvāgatya tatsammukhē patitvā sarvvavr̥ttāntaṁ satyaṁ tasmai kathayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","tadānīṁ yīśustāṁ gaditavān, hē kanyē tava pratītistvām arōgāmakarōt tvaṁ kṣēmēṇa vraja svarōgānmuktā ca tiṣṭha| ");
INSERT INTO saniso_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","itivākyavadanakālē bhajanagr̥hādhipasya nivēśanāl lōkā ētyādhipaṁ babhāṣirē tava kanyā mr̥tā tasmād guruṁ punaḥ kutaḥ kliśnāsi? ");
INSERT INTO saniso_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","kintu yīśustad vākyaṁ śrutvaiva bhajanagr̥hādhipaṁ gaditavān mā bhaiṣīḥ kēvalaṁ viśvāsihi| ");
INSERT INTO saniso_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","atha pitarō yākūb tadbhrātā yōhan ca ētān vinā kamapi svapaścād yātuṁ nānvamanyata| ");
INSERT INTO saniso_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","tasya bhajanagr̥hādhipasya nivēśanasamīpam āgatya kalahaṁ bahurōdanaṁ vilāpañca kurvvatō lōkān dadarśa| ");
INSERT INTO saniso_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","tasmān nivēśanaṁ praviśya prōktavān yūyaṁ kuta itthaṁ kalahaṁ rōdanañca kurutha? kanyā na mr̥tā nidrāti| ");
INSERT INTO saniso_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","tasmāttē tamupajahasuḥ kintu yīśuḥ sarvvāna bahiṣkr̥tya kanyāyāḥ pitarau svasaṅginaśca gr̥hītvā yatra kanyāsīt tat sthānaṁ praviṣṭavān| ");
INSERT INTO saniso_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","atha sa tasyāḥ kanyāyā hastau dhr̥tvā tāṁ babhāṣē ṭālīthā kūmī, arthatō hē kanyē tvamuttiṣṭha ityājñāpayāmi| ");
INSERT INTO saniso_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","tunaiva tatkṣaṇaṁ sā dvādaśavarṣavayaskā kanyā pōtthāya calitumārēbhē, itaḥ sarvvē mahāvismayaṁ gatāḥ| ");
INSERT INTO saniso_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","tata ētasyai kiñcit khādyaṁ dattēti kathayitvā ētatkarmma kamapi na jñāpayatēti dr̥ḍhamādiṣṭavān| ");
INSERT INTO saniso_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","anantaraṁ sa tatsthānāt prasthāya svapradēśamāgataḥ śiṣyāśca tatpaścād gatāḥ| ");
INSERT INTO saniso_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","atha viśrāmavārē sati sa bhajanagr̥hē upadēṣṭumārabdhavān tatō'nēkē lōkāstatkathāṁ śrutvā vismitya jagaduḥ, asya manujasya īdr̥śī āścaryyakriyā kasmāj jātā? tathā svakarābhyām itthamadbhutaṁ karmma karttāुm ētasmai kathaṁ jñānaṁ dattam? ");
INSERT INTO saniso_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","kimayaṁ mariyamaḥ putrastajñā nō? kimayaṁ yākūb-yōsi-yihudā-śimōnāṁ bhrātā nō? asya bhaginyaḥ kimihāsmābhiḥ saha nō? itthaṁ tē tadarthē pratyūhaṁ gatāḥ| ");
INSERT INTO saniso_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","tadā yīśustēbhyō'kathayat svadēśaṁ svakuṭumbān svaparijanāṁśca vinā kutrāpi bhaviṣyadvādī asatkr̥tō na bhavati| ");
INSERT INTO saniso_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","aparañca tēṣāmapratyayāt sa vismitaḥ kiyatāṁ rōgiṇāṁ vapuḥṣu hastam arpayitvā kēvalaṁ tēṣāmārōgyakaraṇād anyat kimapi citrakāryyaṁ karttāṁ na śaktaḥ| ");
INSERT INTO saniso_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","atha sa caturdikstha grāmān bhramitvā upadiṣṭavān ");
INSERT INTO saniso_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","dvādaśaśiṣyān āhūya amēdhyabhūtān vaśīkarttāṁ śaktiṁ dattvā tēṣāṁ dvau dvau janō prēṣitavān| ");
INSERT INTO saniso_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","punarityādiśad yūyam ēkaikāṁ yaṣṭiṁ vinā vastrasaṁpuṭaḥ pūpaḥ kaṭibandhē tāmrakhaṇḍañca ēṣāṁ kimapi mā grahlīta, ");
INSERT INTO saniso_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","mārgayātrāyai pādēṣūpānahau dattvā dvē uttarīyē mā paridhadvvaṁ| ");
INSERT INTO saniso_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","aparamapyuktaṁ tēna yūyaṁ yasyāṁ puryyāṁ yasya nivēśanaṁ pravēkṣyatha tāṁ purīṁ yāvanna tyakṣyatha tāvat tannivēśanē sthāsyatha| ");
INSERT INTO saniso_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","tatra yadi kēpi yuṣmākamātithyaṁ na vidadhati yuṣmākaṁ kathāśca na śr̥ṇvanti tarhi tatsthānāt prasthānasamayē tēṣāṁ viruddhaṁ sākṣyaṁ dātuṁ svapādānāsphālya rajaḥ sampātayata; ahaṁ yuṣmān yathārthaṁ vacmi vicāradinē tannagarasyāvasthātaḥ sidōmāmōrayō rnagarayōravasthā sahyatarā bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","atha tē gatvā lōkānāṁ manaḥparāvarttanīḥ kathā pracāritavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ēvamanēkān bhūtāṁśca tyājitavantastathā tailēna marddayitvā bahūn janānarōgānakārṣuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","itthaṁ tasya sukhyātiścaturdiśō vyāptā tadā hērōd rājā tanniśamya kathitavān, yōhan majjakaḥ śmaśānād utthita atōhētōstēna sarvvā ētā adbhutakriyāḥ prakāśantē| ");
INSERT INTO saniso_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","anyē'kathayan ayam ēliyaḥ, kēpi kathitavanta ēṣa bhaviṣyadvādī yadvā bhaviṣyadvādināṁ sadr̥śa ēkōyam| ");
INSERT INTO saniso_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","kintu hērōd ityākarṇya bhāṣitavān yasyāhaṁ śiraśchinnavān sa ēva yōhanayaṁ sa śmaśānādudatiṣṭhat| ");
INSERT INTO saniso_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","pūrvvaṁ svabhrātuḥ philipasya patnyā udvāhaṁ kr̥tavantaṁ hērōdaṁ yōhanavādīt svabhātr̥vadhū rna vivāhyā| ");
INSERT INTO saniso_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ataḥ kāraṇāt hērōd lōkaṁ prahitya yōhanaṁ dhr̥tvā bandhanālayē baddhavān| ");
INSERT INTO saniso_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","hērōdiyā tasmai yōhanē prakupya taṁ hantum aicchat kintu na śaktā, ");
INSERT INTO saniso_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","yasmād hērōd taṁ dhārmmikaṁ satpuruṣañca jñātvā sammanya rakṣitavān; tatkathāṁ śrutvā tadanusārēṇa bahūni karmmāṇi kr̥tavān hr̥ṣṭamanāstadupadēśaṁ śrutavāṁśca| ");
INSERT INTO saniso_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","kintu hērōd yadā svajanmadinē pradhānalōkēbhyaḥ sēnānībhyaśca gālīlpradēśīyaśrēṣṭhalōkēbhyaśca rātrau bhōjyamēkaṁ kr̥tavān ");
INSERT INTO saniso_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","tasmin śubhadinē hērōdiyāyāḥ kanyā samētya tēṣāṁ samakṣaṁ saṁnr̥tya hērōdastēna sahōpaviṣṭānāñca tōṣamajījanat tatā nr̥paḥ kanyāmāha sma mattō yad yācasē tadēva tubhyaṁ dāsyē| ");
INSERT INTO saniso_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","śapathaṁ kr̥tvākathayat cēd rājyārddhamapi yācasē tadapi tubhyaṁ dāsyē| ");
INSERT INTO saniso_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","tataḥ sā bahi rgatvā svamātaraṁ papraccha kimahaṁ yāciṣyē? tadā sākathayat yōhanō majjakasya śiraḥ| ");
INSERT INTO saniso_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","atha tūrṇaṁ bhūpasamīpam ētya yācamānāvadat kṣaṇēsmin yōhanō majjakasya śiraḥ pātrē nidhāya dēhi, ētad yācē'haṁ| ");
INSERT INTO saniso_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","tasmāt bhūpō'tiduḥkhitaḥ, tathāpi svaśapathasya sahabhōjināñcānurōdhāt tadanaṅgīkarttuṁ na śaktaḥ| ");
INSERT INTO saniso_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","tatkṣaṇaṁ rājā ghātakaṁ prēṣya tasya śira ānētumādiṣṭavān| ");
INSERT INTO saniso_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","tataḥ sa kārāgāraṁ gatvā tacchiraśchitvā pātrē nidhāyānīya tasyai kanyāyai dattavān kanyā ca svamātrē dadau| ");
INSERT INTO saniso_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ananataraṁ yōhanaḥ śiṣyāstadvārttāṁ prāpyāgatya tasya kuṇapaṁ śmaśānē'sthāpayan| ");
INSERT INTO saniso_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","atha prēṣitā yīśōḥ sannidhau militā yad yac cakruḥ śikṣayāmāsuśca tatsarvvavārttāstasmai kathitavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","sa tānuvāca yūyaṁ vijanasthānaṁ gatvā viśrāmyata yatastatsannidhau bahulōkānāṁ samāgamāt tē bhōktuṁ nāvakāśaṁ prāptāḥ| ");
INSERT INTO saniso_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","tatastē nāvā vijanasthānaṁ guptaṁ gagmuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","tatō lōkanivahastēṣāṁ sthānāntarayānaṁ dadarśa, anēkē taṁ paricitya nānāpurēbhyaḥ padairvrajitvā javēna taiṣāmagrē yīśōḥ samīpa upatasthuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","tadā yīśu rnāvō bahirgatya lōkāraṇyānīṁ dr̥ṣṭvā tēṣu karuṇāṁ kr̥tavān yatastē'rakṣakamēṣā ivāsan tadā sa tāna nānāprasaṅgān upadiṣṭavān| ");
INSERT INTO saniso_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","atha divāntē sati śiṣyā ētya yīśumūcirē, idaṁ vijanasthānaṁ dinañcāvasannaṁ| ");
INSERT INTO saniso_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","lōkānāṁ kimapi khādyaṁ nāsti, ataścaturdikṣu grāmān gantuṁ bhōjyadravyāṇi krētuñca bhavān tān visr̥jatu| ");
INSERT INTO saniso_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","tadā sa tānuvāca yūyamēva tān bhōjayata; tatastē jagadu rvayaṁ gatvā dviśatasaṁkhyakai rmudrāpādaiḥ pūpān krītvā kiṁ tān bhōjayiṣyāmaḥ? ");
INSERT INTO saniso_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","tadā sa tān pr̥ṣṭhavān yuṣmākaṁ sannidhau kati pūpā āsatē? gatvā paśyata; tatastē dr̥ṣṭvā tamavadan pañca pūpā dvau matsyau ca santi| ");
INSERT INTO saniso_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","tadā sa lōkān śaspōpari paṁktibhirupavēśayitum ādiṣṭavān, ");
INSERT INTO saniso_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","tatastē śataṁ śataṁ janāḥ pañcāśat pañcāśajjanāśca paṁktibhi rbhuvi samupaviviśuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","atha sa tān pañcapūpān matsyadvayañca dhr̥tvā svargaṁ paśyan īśvaraguṇān anvakīrttayat tān pūpān bhaṁktvā lōkēbhyaḥ parivēṣayituṁ śiṣyēbhyō dattavān dvā matsyau ca vibhajya sarvvēbhyō dattavān| ");
INSERT INTO saniso_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","tataḥ sarvvē bhuktvātr̥pyan| ");
INSERT INTO saniso_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","anantaraṁ śiṣyā avaśiṣṭaiḥ pūpai rmatsyaiśca pūrṇān dvadaśa ḍallakān jagr̥huḥ| ");
INSERT INTO saniso_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","tē bhōktāraḥ prāyaḥ pañca sahasrāṇi puruṣā āsan| ");
INSERT INTO saniso_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","atha sa lōkān visr̥jannēva nāvamārōḍhuṁ svasmādagrē pārē baitsaidāpuraṁ yātuñca śṣyiाn vāḍhamādiṣṭavān| ");
INSERT INTO saniso_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","tadā sa sarvvān visr̥jya prārthayituṁ parvvataṁ gataḥ| ");
INSERT INTO saniso_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","tataḥ sandhyāyāṁ satyāṁ nauḥ sindhumadhya upasthitā kintu sa ēkākī sthalē sthitaḥ| ");
INSERT INTO saniso_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","atha sammukhavātavahanāt śiṣyā nāvaṁ vāhayitvā pariśrāntā iti jñātvā sa niśācaturthayāmē sindhūpari padbhyāṁ vrajan tēṣāṁ samīpamētya tēṣāmagrē yātum udyataḥ| ");
INSERT INTO saniso_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","kintu śiṣyāḥ sindhūpari taṁ vrajantaṁ dr̥ṣṭvā bhūtamanumāya ruruvuḥ, ");
INSERT INTO saniso_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","yataḥ sarvvē taṁ dr̥ṣṭvā vyākulitāḥ| ataēva yīśustatkṣaṇaṁ taiḥ sahālapya kathitavān, susthirā bhūta, ayamahaṁ mā bhaiṣṭa| ");
INSERT INTO saniso_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","atha naukāmāruhya tasmin tēṣāṁ sannidhiṁ gatē vātō nivr̥ttaḥ; tasmāttē manaḥsu vismitā āścaryyaṁ mēnirē| ");
INSERT INTO saniso_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","yatastē manasāṁ kāṭhinyāt tat pūpīyam āścaryyaṁ karmma na viviktavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","atha tē pāraṁ gatvā ginēṣaratpradēśamētya taṭa upasthitāḥ| ");
INSERT INTO saniso_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","tēṣu naukātō bahirgatēṣu tatpradēśīyā lōkāstaṁ paricitya ");
INSERT INTO saniso_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","caturdikṣu dhāvantō yatra yatra rōgiṇō narā āsan tān sarvvāna khaṭvōpari nidhāya yatra kutracit tadvārttāṁ prāpuḥ tat sthānam ānētum ārēbhirē| ");
INSERT INTO saniso_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","tathā yatra yatra grāmē yatra yatra purē yatra yatra pallyāñca tēna pravēśaḥ kr̥tastadvartmamadhyē lōkāḥ pīḍitān sthāpayitvā tasya cēlagranthimātraṁ spraṣṭum tēṣāmarthē tadanujñāṁ prārthayantaḥ yāvantō lōkāḥ paspr̥śustāvanta ēva gadānmuktāḥ| ");
INSERT INTO saniso_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","anantaraṁ yirūśālama āgatāḥ phirūśinō'dhyāpakāśca yīśōḥ samīpam āgatāḥ| ");
INSERT INTO saniso_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","tē tasya kiyataḥ śiṣyān aśucikarairarthāda aprakṣālitahastai rbhuñjatō dr̥ṣṭvā tānadūṣayan| ");
INSERT INTO saniso_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","yataḥ phirūśinaḥ sarvvayihūdīyāśca prācāṁ paramparāgatavākyaṁ sammanya pratalēna hastān aprakṣālya na bhuñjatē| ");
INSERT INTO saniso_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","āpanādāgatya majjanaṁ vinā na khādanti; tathā pānapātrāṇāṁ jalapātrāṇāṁ pittalapātrāṇām āsanānāñca jalē majjanam ityādayōnyēpi bahavastēṣāmācārāḥ santi| ");
INSERT INTO saniso_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","tē phirūśinō'dhyāpakāśca yīśuṁ papracchuḥ, tava śiṣyāḥ prācāṁ paramparāgatavākyānusārēṇa nācarantō'prakṣālitakaraiḥ kutō bhujaṁtē? ");
INSERT INTO saniso_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","tataḥ sa pratyuvāca kapaṭinō yuṣmān uddiśya yiśayiyabhaviṣyadvādī yuktamavādīt| yathā svakīyairadharairētē sammanyanatē sadaiva māṁ| kintu mattō viprakarṣē santi tēṣāṁ manāṁsi ca| ");
INSERT INTO saniso_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","śikṣayantō bidhīn nnājñā bhajantē māṁ mudhaiva tē| ");
INSERT INTO saniso_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","yūyaṁ jalapātrapānapātrādīni majjayantō manujaparamparāgatavākyaṁ rakṣatha kintu īśvarājñāṁ laṁghadhvē; aparā īdr̥śyōnēkāḥ kriyā api kurudhvē| ");
INSERT INTO saniso_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","anyañcākathayat yūyaṁ svaparamparāgatavākyasya rakṣārthaṁ spaṣṭarūpēṇa īśvarājñāṁ lōpayatha| ");
INSERT INTO saniso_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","yatō mūsādvārā prōktamasti svapitarau sammanyadhvaṁ yastu mātaraṁ pitaraṁ vā durvvākyaṁ vakti sa nitāntaṁ hanyatāṁ| ");
INSERT INTO saniso_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","kintu madīyēna yēna dravyēṇa tavōpakārōbhavat tat karbbāṇamarthād īśvarāya nivēditam idaṁ vākyaṁ yadi kōpi pitaraṁ mātaraṁ vā vakti ");
INSERT INTO saniso_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","tarhi yūyaṁ mātuḥ pitu rvōpakāraṁ karttāṁ taṁ vārayatha| ");
INSERT INTO saniso_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","itthaṁ svapracāritaparamparāgatavākyēna yūyam īśvarājñāṁ mudhā vidhadvvē, īdr̥śānyanyānyanēkāni karmmāṇi kurudhvē| ");
INSERT INTO saniso_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","atha sa lōkānāhūya babhāṣē yūyaṁ sarvvē madvākyaṁ śr̥ṇuta budhyadhvañca| ");
INSERT INTO saniso_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","bāhyādantaraṁ praviśya naramamēdhyaṁ karttāṁ śaknōti īdr̥śaṁ kimapi vastu nāsti, varam antarād bahirgataṁ yadvastu tanmanujam amēdhyaṁ karōti| ");
INSERT INTO saniso_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","yasya śrōtuṁ śrōtrē staḥ sa śr̥ṇōtu| ");
INSERT INTO saniso_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","tataḥ sa lōkān hitvā gr̥hamadhyaṁ praviṣṭastadā śiṣyāstadr̥ṣṭāntavākyārthaṁ papracchuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","tasmāt sa tān jagāda yūyamapi kimētādr̥gabōdhāḥ? kimapi dravyaṁ bāhyādantaraṁ praviśya naramamēdhyaṁ karttāṁ na śaknōti kathāmimāṁ kiṁ na budhyadhvē? ");
INSERT INTO saniso_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","tat tadantarna praviśati kintu kukṣimadhyaṁ praviśati śēṣē sarvvabhuktavastugrāhiṇi bahirdēśē niryāti| ");
INSERT INTO saniso_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","aparamapyavādīd yannarānnirēti tadēva naramamēdhyaṁ karōti| ");
INSERT INTO saniso_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","yatō'ntarād arthān mānavānāṁ manōbhyaḥ kucintā parastrīvēśyāgamanaṁ ");
INSERT INTO saniso_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","naravadhaścauryyaṁ lōbhō duṣṭatā pravañcanā kāmukatā kudr̥ṣṭirīśvaranindā garvvastama ityādīni nirgacchanti| ");
INSERT INTO saniso_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ētāni sarvvāṇi duritānyantarādētya naramamēdhyaṁ kurvvanti| ");
INSERT INTO saniso_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","atha sa utthāya tatsthānāt sōrasīdōnpurapradēśaṁ jagāma tatra kimapi nivēśanaṁ praviśya sarvvairajñātaḥ sthātuṁ matiñcakrē kintu guptaḥ sthātuṁ na śaśāka| ");
INSERT INTO saniso_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","yataḥ suraphainikīdēśīyayūnānīvaṁśōdbhavastriyāḥ kanyā bhūtagrastāsīt| sā strī tadvārttāṁ prāpya tatsamīpamāgatya taccaraṇayōḥ patitvā ");
INSERT INTO saniso_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","svakanyātō bhūtaṁ nirākarttāṁ tasmin vinayaṁ kr̥tavatī| ");
INSERT INTO saniso_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","kintu yīśustāmavadat prathamaṁ bālakāstr̥pyantu yatō bālakānāṁ khādyaṁ gr̥hītvā kukkurēbhyō nikṣēpō'nucitaḥ| ");
INSERT INTO saniso_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","tadā sā strī tamavādīt bhōḥ prabhō tat satyaṁ tathāpi mañcādhaḥsthāḥ kukkurā bālānāṁ karapatitāni khādyakhaṇḍāni khādanti| ");
INSERT INTO saniso_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","tataḥ sō'kathayad ētatkathāhētōḥ sakuśalā yāhi tava kanyāṁ tyaktvā bhūtō gataḥ| ");
INSERT INTO saniso_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","atha sā strī gr̥haṁ gatvā kanyāṁ bhūtatyaktāṁ śayyāsthitāṁ dadarśa| ");
INSERT INTO saniso_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","punaśca sa sōrasīdōnpurapradēśāt prasthāya dikāpalidēśasya prāntarabhāgēna gālīljaladhēḥ samīpaṁ gatavān| ");
INSERT INTO saniso_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","tadā lōkairēkaṁ badhiraṁ kadvadañca naraṁ tannikaṭamānīya tasya gātrē hastamarpayituṁ vinayaḥ kr̥taḥ| ");
INSERT INTO saniso_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","tatō yīśu rlōkāraṇyāt taṁ nirjanamānīya tasya karṇayōṅgulī rdadau niṣṭhīvaṁ dattvā ca tajjihvāṁ pasparśa| ");
INSERT INTO saniso_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","anantaraṁ svargaṁ nirīkṣya dīrghaṁ niśvasya tamavadat itaphataḥ arthān muktō bhūyāt| ");
INSERT INTO saniso_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","tatastatkṣaṇaṁ tasya karṇau muktau jihvāyāśca jāḍyāpagamāt sa suspaṣṭavākyamakathayat| ");
INSERT INTO saniso_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","atha sa tān vāḍhamityādidēśa yūyamimāṁ kathāṁ kasmaicidapi mā kathayata, kintu sa yati nyaṣēdhat tē tati bāhulyēna prācārayan; ");
INSERT INTO saniso_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","tē'ticamatkr̥tya parasparaṁ kathayāmāsuḥ sa badhirāya śravaṇaśaktiṁ mūkāya ca kathanaśaktiṁ dattvā sarvvaṁ karmmōttamarūpēṇa cakāra| ");
INSERT INTO saniso_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","tadā tatsamīpaṁ bahavō lōkā āyātā atastēṣāṁ bhōjyadravyābhāvād yīśuḥ śiṣyānāhūya jagāda,| ");
INSERT INTO saniso_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","lōkanivahē mama kr̥pā jāyatē tē dinatrayaṁ mayā sārddhaṁ santi tēṣāṁ bhōjyaṁ kimapi nāsti| ");
INSERT INTO saniso_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","tēṣāṁ madhyē'nēkē dūrād āgatāḥ, abhuktēṣu tēṣu mayā svagr̥hamabhiprahitēṣu tē pathi klamiṣyanti| ");
INSERT INTO saniso_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","śiṣyā avādiṣuḥ, ētāvatō lōkān tarpayitum atra prantarē pūpān prāptuṁ kēna śakyatē? ");
INSERT INTO saniso_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","tataḥ sa tān papraccha yuṣmākaṁ kati pūpāḥ santi? tē'kathayan sapta| ");
INSERT INTO saniso_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","tataḥ sa tāllōkān bhuvi samupavēṣṭum ādiśya tān sapta pūpān dhr̥tvā īśvaraguṇān anukīrttayāmāsa, bhaṁktvā parivēṣayituṁ śiṣyān prati dadau, tatastē lōkēbhyaḥ parivēṣayāmāsuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","tathā tēṣāṁ samīpē yē kṣudramatsyā āsan tānapyādāya īśvaraguṇān saṁkīrtya parivēṣayitum ādiṣṭavān| ");
INSERT INTO saniso_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","tatō lōkā bhuktvā tr̥ptiṁ gatā avaśiṣṭakhādyaiḥ pūrṇāḥ saptaḍallakā gr̥hītāśca| ");
INSERT INTO saniso_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ētē bhōktāraḥ prāyaścatuḥ sahasrapuruṣā āsan tataḥ sa tān visasarja| ");
INSERT INTO saniso_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","atha sa śiṣyaḥ saha nāvamāruhya dalmānūthāsīmāmāgataḥ| ");
INSERT INTO saniso_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","tataḥ paraṁ phirūśina āgatya tēna saha vivadamānāstasya parīkṣārtham ākāśīyacihnaṁ draṣṭuṁ yācitavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","tadā sō'ntardīrghaṁ niśvasyākathayat, ētē vidyamānanarāḥ kutaścinhaṁ mr̥gayantē? yuṣmānahaṁ yathārthaṁ bravīmi lōkānētān kimapi cihnaṁ na darśayiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","atha tān hitvā puna rnāvam āruhya pāramagāt| ");
INSERT INTO saniso_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ētarhi śiṣyaiḥ pūpēṣu vismr̥tēṣu nāvi tēṣāṁ sannidhau pūpa ēkaēva sthitaḥ| ");
INSERT INTO saniso_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","tadānīṁ yīśustān ādiṣṭavān phirūśināṁ hērōdaśca kiṇvaṁ prati satarkāḥ sāvadhānāśca bhavata| ");
INSERT INTO saniso_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","tatastē'nyōnyaṁ vivēcanaṁ kartum ārēbhirē, asmākaṁ sannidhau pūpō nāstīti hētōridaṁ kathayati| ");
INSERT INTO saniso_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","tad budvvā yīśustēbhyō'kathayat yuṣmākaṁ sthānē pūpābhāvāt kuta itthaṁ vitarkayatha? yūyaṁ kimadyāpi kimapi na jānītha? bōddhuñca na śaknutha? yāvadadya kiṁ yuṣmākaṁ manāṁsi kaṭhināni santi? ");
INSERT INTO saniso_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","satsu nētrēṣu kiṁ na paśyatha? satsu karṇēṣu kiṁ na śr̥ṇutha? na smaratha ca? ");
INSERT INTO saniso_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","yadāhaṁ pañcapūpān pañcasahasrāṇāṁ puruṣāṇāṁ madhyē bhaṁktvā dattavān tadānīṁ yūyam avaśiṣṭapūpaiḥ pūrṇān kati ḍallakān gr̥hītavantaḥ? tē'kathayan dvādaśaḍallakān| ");
INSERT INTO saniso_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","aparañca yadā catuḥsahasrāṇāṁ puruṣāṇāṁ madhyē pūpān bhaṁktvādadāṁ tadā yūyam atiriktapūpānāṁ kati ḍallakān gr̥hītavantaḥ? tē kathayāmāsuḥ saptaḍallakān| ");
INSERT INTO saniso_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","tadā sa kathitavān tarhi yūyam adhunāpi kutō bōdvvuṁ na śaknutha? ");
INSERT INTO saniso_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","anantaraṁ tasmin baitsaidānagarē prāptē lōkā andhamēkaṁ naraṁ tatsamīpamānīya taṁ spraṣṭuṁ taṁ prārthayāñcakrirē| ");
INSERT INTO saniso_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","tadā tasyāndhasya karau gr̥hītvā nagarād bahirdēśaṁ taṁ nītavān; tannētrē niṣṭhīvaṁ dattvā tadgātrē hastāvarpayitvā taṁ papraccha, kimapi paśyasi? ");
INSERT INTO saniso_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","sa nētrē unmīlya jagāda, vr̥kṣavat manujān gacchatō nirīkṣē| ");
INSERT INTO saniso_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","tatō yīśuḥ punastasya nayanayō rhastāvarpayitvā tasya nētrē unmīlayāmāsa; tasmāt sa svasthō bhūtvā spaṣṭarūpaṁ sarvvalōkān dadarśa| ");
INSERT INTO saniso_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","tataḥ paraṁ tvaṁ grāmaṁ mā gaccha grāmasthaṁ kamapi ca kimapyanuktvā nijagr̥haṁ yāhītyādiśya yīśustaṁ nijagr̥haṁ prahitavān| ");
INSERT INTO saniso_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","anantaraṁ śiṣyaiḥ sahitō yīśuḥ kaisarīyāphilipipuraṁ jagāma, pathi gacchan tānapr̥cchat kō'ham atra lōkāḥ kiṁ vadanti? ");
INSERT INTO saniso_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","tē pratyūcuḥ tvāṁ yōhanaṁ majjakaṁ vadanti kintu kēpi kēpi ēliyaṁ vadanti; aparē kēpi kēpi bhaviṣyadvādinām ēkō jana iti vadanti| ");
INSERT INTO saniso_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","atha sa tānapr̥cchat kintu kōham? ityatra yūyaṁ kiṁ vadatha? tadā pitaraḥ pratyavadat bhavān abhiṣiktastrātā| ");
INSERT INTO saniso_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","tataḥ sa tān gāḍhamādiśad yūyaṁ mama kathā kasmaicidapi mā kathayata| ");
INSERT INTO saniso_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","manuṣyaputrēṇāvaśyaṁ bahavō yātanā bhōktavyāḥ prācīnalōkaiḥ pradhānayājakairadhyāpakaiśca sa ninditaḥ san ghātayiṣyatē tr̥tīyadinē utthāsyati ca, yīśuḥ śiṣyānupadēṣṭumārabhya kathāmimāṁ spaṣṭamācaṣṭa| ");
INSERT INTO saniso_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","tasmāt pitarastasya hastau dhr̥tvā taṁ tarjjitavān| ");
INSERT INTO saniso_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","kintu sa mukhaṁ parāvartya śiṣyagaṇaṁ nirīkṣya pitaraṁ tarjayitvāvādīd dūrībhava vighnakārin īśvarīyakāryyādapi manuṣyakāryyaṁ tubhyaṁ rōcatatarāṁ| ");
INSERT INTO saniso_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","atha sa lōkān śiṣyāṁścāhūya jagāda yaḥ kaścin māmanugantum icchati sa ātmānaṁ dāmyatu, svakruśaṁ gr̥hītvā matpaścād āyātu| ");
INSERT INTO saniso_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","yatō yaḥ kaścit svaprāṇaṁ rakṣitumicchati sa taṁ hārayiṣyati, kintu yaḥ kaścin madarthaṁ susaṁvādārthañca prāṇaṁ hārayati sa taṁ rakṣiṣyati| ");
INSERT INTO saniso_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","aparañca manujaḥ sarvvaṁ jagat prāpya yadi svaprāṇaṁ hārayati tarhi tasya kō lābhaḥ? ");
INSERT INTO saniso_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","naraḥ svaprāṇavinimayēna kiṁ dātuṁ śaknōti? ");
INSERT INTO saniso_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ētēṣāṁ vyabhicāriṇāṁ pāpināñca lōkānāṁ sākṣād yadi kōpi māṁ matkathāñca lajjāspadaṁ jānāti tarhi manujaputrō yadā dharmmadūtaiḥ saha pituḥ prabhāvēṇāgamiṣyati tadā sōpi taṁ lajjāspadaṁ jñāsyati| ");
INSERT INTO saniso_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","atha sa tānavādīt yuṣmabhyamahaṁ yathārthaṁ kathayāmi, īśvararājyaṁ parākramēṇōpasthitaṁ na dr̥ṣṭvā mr̥tyuṁ nāsvādiṣyantē, atra daṇḍāyamānānāṁ madhyēpi tādr̥śā lōkāḥ santi| ");
INSERT INTO saniso_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","atha ṣaḍdinēbhyaḥ paraṁ yīśuḥ pitaraṁ yākūbaṁ yōhanañca gr̥hītvā girēruccasya nirjanasthānaṁ gatvā tēṣāṁ pratyakṣē mūrtyantaraṁ dadhāra| ");
INSERT INTO saniso_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","tatastasya paridhēyam īdr̥śam ujjvalahimapāṇaḍaraṁ jātaṁ yad jagati kōpi rajakō na tādr̥k pāṇaḍaraṁ karttāṁ śaknōti| ");
INSERT INTO saniso_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","aparañca ēliyō mūsāśca tēbhyō darśanaṁ dattvā yīśunā saha kathanaṁ karttumārēbhātē| ");
INSERT INTO saniso_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","tadā pitarō yīśumavādīt hē gurō'smākamatra sthitiruttamā, tataēva vayaṁ tvatkr̥tē ēkāṁ mūsākr̥tē ēkām ēliyakr̥tē caikāṁ, ētāstisraḥ kuṭī rnirmmāma| ");
INSERT INTO saniso_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","kintu sa yaduktavān tat svayaṁ na bubudhē tataḥ sarvvē bibhayāñcakruḥ| ");
INSERT INTO saniso_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ētarhi payōdastān chādayāmāsa, mamayāṁ priyaḥ putraḥ kathāsu tasya manāṁsi nivēśayatēti nabhōvāṇī tanmēdyānniryayau| ");
INSERT INTO saniso_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","atha haṭhāttē caturdiśō dr̥ṣṭvā yīśuṁ vinā svaiḥ sahitaṁ kamapi na dadr̥śuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","tataḥ paraṁ girēravarōhaṇakālē sa tān gāḍham dūtyādidēśa yāvannarasūnōḥ śmaśānādutthānaṁ na bhavati, tāvat darśanasyāsya vārttā yuṣmābhiḥ kasmaicidapi na vaktavyā| ");
INSERT INTO saniso_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","tadā śmaśānādutthānasya kōbhiprāya iti vicāryya tē tadvākyaṁ svēṣu gōpāyāñcakrirē| ");
INSERT INTO saniso_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","atha tē yīśuṁ papracchuḥ prathamata ēliyēnāgantavyam iti vākyaṁ kuta upādhyāyā āhuḥ? ");
INSERT INTO saniso_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","tadā sa pratyuvāca , ēliyaḥ prathamamētya sarvvakāryyāṇi sādhayiṣyati; naraputrē ca lipi ryathāstē tathaiva sōpi bahuduḥkhaṁ prāpyāvajñāsyatē| ");
INSERT INTO saniso_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","kintvahaṁ yuṣmān vadāmi , ēliyārthē lipi ryathāstē tathaiva sa ētya yayau, lōkā: svēcchānurūpaṁ tamabhivyavaharanti sma| ");
INSERT INTO saniso_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","anantaraṁ sa śiṣyasamīpamētya tēṣāṁ catuḥpārśvē taiḥ saha bahujanān vivadamānān adhyāpakāṁśca dr̥ṣṭavān; ");
INSERT INTO saniso_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","kintu sarvvalōkāstaṁ dr̥ṣṭvaiva camatkr̥tya tadāsannaṁ dhāvantastaṁ praṇēmuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","tadā yīśuradhyāpakānaprākṣīd ētaiḥ saha yūyaṁ kiṁ vivadadhvē? ");
INSERT INTO saniso_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","tatō lōkānāṁ kaścidēkaḥ pratyavādīt hē gurō mama sūnuṁ mūkaṁ bhūtadhr̥tañca bhavadāsannam ānayaṁ| ");
INSERT INTO saniso_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","yadāsau bhūtastamākramatē tadaiva pātasati tathā sa phēṇāyatē, dantairdantān gharṣati kṣīṇō bhavati ca; tatō hētōstaṁ bhūtaṁ tyājayituṁ bhavacchiṣyān nivēditavān kintu tē na śēkuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","tadā sa tamavādīt, rē aviśvāsinaḥ santānā yuṣmābhiḥ saha kati kālānahaṁ sthāsyāmi? aparān kati kālān vā va ācārān sahiṣyē? taṁ madāsannamānayata| ");
INSERT INTO saniso_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","tatastatsannidhiṁ sa ānīyata kintu taṁ dr̥ṣṭvaiva bhūtō bālakaṁ dhr̥tavān; sa ca bhūmau patitvā phēṇāyamānō lulōṭha| ");
INSERT INTO saniso_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","tadā sa tatpitaraṁ papraccha, asyēdr̥śī daśā kati dināni bhūtā? tataḥ sōvādīt bālyakālāt| ");
INSERT INTO saniso_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","bhūtōyaṁ taṁ nāśayituṁ bahuvārān vahnau jalē ca nyakṣipat kintu yadi bhavāna kimapi karttāṁ śaknōti tarhi dayāṁ kr̥tvāsmān upakarōtu| ");
INSERT INTO saniso_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","tadā yīśustamavadat yadi pratyētuṁ śaknōṣi tarhi pratyayinē janāya sarvvaṁ sādhyam| ");
INSERT INTO saniso_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","tatastatkṣaṇaṁ tadbālakasya pitā prōccai rūvan sāśrunētraḥ prōvāca, prabhō pratyēmi mamāpratyayaṁ pratikuru| ");
INSERT INTO saniso_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","atha yīśu rlōkasaṅghaṁ dhāvitvāyāntaṁ dr̥ṣṭvā tamapūtabhūtaṁ tarjayitvā jagāda, rē badhira mūka bhūta tvamētasmād bahirbhava punaḥ kadāpi māśrayainaṁ tvāmaham ityādiśāmi| ");
INSERT INTO saniso_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","tadā sa bhūtaścītśabdaṁ kr̥tvā tamāpīḍya bahirjajāma, tatō bālakō mr̥takalpō babhūva tasmādayaṁ mr̥ta̮ityanēkē kathayāmāsuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","kintu karaṁ dhr̥tvā yīśunōtthāpitaḥ sa uttasthau| ");
INSERT INTO saniso_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","atha yīśau gr̥haṁ praviṣṭē śiṣyā guptaṁ taṁ papracchuḥ, vayamēnaṁ bhūtaṁ tyājayituṁ kutō na śaktāḥ? ");
INSERT INTO saniso_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","sa uvāca, prārthanōpavāsau vinā kēnāpyanyēna karmmaṇā bhūtamīdr̥śaṁ tyājayituṁ na śakyaṁ| ");
INSERT INTO saniso_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","anantaraṁ sa tatsthānāditvā gālīlmadhyēna yayau, kintu tat kōpi jānīyāditi sa naicchat| ");
INSERT INTO saniso_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","aparañca sa śiṣyānupadiśan babhāṣē, naraputrō narahastēṣu samarpayiṣyatē tē ca taṁ haniṣyanti taistasmin hatē tr̥tīyadinē sa utthāsyatīti| ");
INSERT INTO saniso_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","kintu tatkathāṁ tē nābudhyanta praṣṭuñca bibhyaḥ| ");
INSERT INTO saniso_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","atha yīśuḥ kapharnāhūmpuramāgatya madhyēgr̥hañcētya tānapr̥cchad vartmamadhyē yūyamanyōnyaṁ kiṁ vivadadhvē sma? ");
INSERT INTO saniso_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","kintu tē niruttarāstasthu ryasmāttēṣāṁ kō mukhya iti vartmāni tē'nyōnyaṁ vyavadanta| ");
INSERT INTO saniso_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","tataḥ sa upaviśya dvādaśaśiṣyān āhūya babhāṣē yaḥ kaścit mukhyō bhavitumicchati sa sarvvēbhyō gauṇaḥ sarvvēṣāṁ sēvakaśca bhavatu| ");
INSERT INTO saniso_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","tadā sa bālakamēkaṁ gr̥hītvā madhyē samupāvēśayat tatastaṁ krōḍē kr̥tvā tānavādāt ");
INSERT INTO saniso_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","yaḥ kaścidīdr̥śasya kasyāpi bālasyātithyaṁ karōti sa mamātithyaṁ karōti; yaḥ kaścinmamātithyaṁ karōti sa kēvalam mamātithyaṁ karōti tanna matprērakasyāpyātithyaṁ karōti| ");
INSERT INTO saniso_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","atha yōhan tamabravīt hē gurō, asmākamananugāminam ēkaṁ tvānnāmnā bhūtān tyājayantaṁ vayaṁ dr̥ṣṭavantaḥ, asmākamapaścādgāmitvācca taṁ nyaṣēdhāma| ");
INSERT INTO saniso_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","kintu yīśuravadat taṁ mā niṣēdhat, yatō yaḥ kaścin mannāmnā citraṁ karmma karōti sa sahasā māṁ nindituṁ na śaknōti| ");
INSERT INTO saniso_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","tathā yaḥ kaścid yuṣmākaṁ vipakṣatāṁ na karōti sa yuṣmākamēva sapakṣaḥ| ");
INSERT INTO saniso_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","yaḥ kaścid yuṣmān khrīṣṭaśiṣyān jñātvā mannāmnā kaṁsaikēna pānīyaṁ pātuṁ dadāti, yuṣmānahaṁ yathārthaṁ vacmi, sa phalēna vañcitō na bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","kintu yadi kaścin mayi viśvāsināmēṣāṁ kṣudraprāṇinām ēkasyāpi vighnaṁ janayati, tarhi tasyaitatkarmma karaṇāt kaṇṭhabaddhapēṣaṇīkasya tasya sāgarāgādhajala majjanaṁ bhadraṁ| ");
INSERT INTO saniso_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","ataḥ svakarō yadi tvāṁ bādhatē tarhi taṁ chindhi; ");
INSERT INTO saniso_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","yasmāt yatra kīṭā na mriyantē vahniśca na nirvvāti, tasmin anirvvāṇānalanarakē karadvayavastava gamanāt karahīnasya svargapravēśastava kṣēmaṁ| ");
INSERT INTO saniso_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","yadi tava pādō vighnaṁ janayati tarhi taṁ chindhi, ");
INSERT INTO saniso_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","yatō yatra kīṭā na mriyantē vahniśca na nirvvāti, tasmin 'nirvvāṇavahnau narakē dvipādavatastava nikṣēpāt pādahīnasya svargapravēśastava kṣēmaṁ| ");
INSERT INTO saniso_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","svanētraṁ yadi tvāṁ bādhatē tarhi tadapyutpāṭaya, yatō yatra kīṭā na mriyantē vahniśca na nirvvāti, ");
INSERT INTO saniso_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","tasmina 'nirvvāṇavahnau narakē dvinētrasya tava nikṣēpād ēkanētravata īśvararājyē pravēśastava kṣēmaṁ| ");
INSERT INTO saniso_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","yathā sarvvō bali rlavaṇāktaḥ kriyatē tathā sarvvō janō vahnirūpēṇa lavaṇāktaḥ kāriṣyatē| ");
INSERT INTO saniso_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","lavaṇaṁ bhadraṁ kintu yadi lavaṇē svādutā na tiṣṭhati, tarhi katham āsvādyuktaṁ kariṣyatha? yūyaṁ lavaṇayuktā bhavata parasparaṁ prēma kuruta| ");
INSERT INTO saniso_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","anantaraṁ sa tatsthānāt prasthāya yarddananadyāḥ pārē yihūdāpradēśa upasthitavān, tatra tadantikē lōkānāṁ samāgamē jātē sa nijarītyanusārēṇa punastān upadidēśa| ");
INSERT INTO saniso_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","tadā phirūśinastatsamīpam ētya taṁ parīkṣituṁ papracchaḥ svajāyā manujānāṁ tyajyā na vēti? ");
INSERT INTO saniso_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","tataḥ sa pratyavādīt, atra kāryyē mūsā yuṣmān prati kimājñāpayat? ");
INSERT INTO saniso_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ta ūcuḥ tyāgapatraṁ lēkhituṁ svapatnīṁ tyaktuñca mūsā'numanyatē| ");
INSERT INTO saniso_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","tadā yīśuḥ pratyuvāca, yuṣmākaṁ manasāṁ kāṭhinyāddhētō rmūsā nidēśamimam alikhat| ");
INSERT INTO saniso_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","kintu sr̥ṣṭērādau īśvarō narān puṁrūpēṇa strīrūpēṇa ca sasarja| ");
INSERT INTO saniso_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","\"tataḥ kāraṇāt pumān pitaraṁ mātarañca tyaktvā svajāyāyām āsaktō bhaviṣyati, ");
INSERT INTO saniso_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","tau dvāv ēkāṅgau bhaviṣyataḥ|\" tasmāt tatkālamārabhya tau na dvāv ēkāṅgau| ");
INSERT INTO saniso_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ataḥ kāraṇād īśvarō yadayōjayat kōpi narastanna viyējayēt| ");
INSERT INTO saniso_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","atha yīśu rgr̥haṁ praviṣṭastadā śiṣyāḥ punastatkathāṁ taṁ papracchuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","tataḥ sōvadat kaścid yadi svabhāryyāṁ tyaktavānyām udvahati tarhi sa svabhāryyāyāḥ prātikūlyēna vyabhicārī bhavati| ");
INSERT INTO saniso_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","kācinnārī yadi svapatiṁ hitvānyapuṁsā vivāhitā bhavati tarhi sāpi vyabhicāriṇī bhavati| ");
INSERT INTO saniso_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","atha sa yathā śiśūn spr̥śēt, tadarthaṁ lōkaistadantikaṁ śiśava ānīyanta, kintu śiṣyāstānānītavatastarjayāmāsuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","yīśustad dr̥ṣṭvā krudhyan jagāda, mannikaṭam āgantuṁ śiśūn mā vārayata, yata ētādr̥śā īśvararājyādhikāriṇaḥ| ");
INSERT INTO saniso_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","yuṣmānahaṁ yathārthaṁ vacmi, yaḥ kaścit śiśuvad bhūtvā rājyamīśvarasya na gr̥hlīyāt sa kadāpi tadrājyaṁ pravēṣṭuṁ na śaknōti| ");
INSERT INTO saniso_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ananataraṁ sa śiśūnaṅkē nidhāya tēṣāṁ gātrēṣu hastau dattvāśiṣaṁ babhāṣē| ");
INSERT INTO saniso_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","atha sa vartmanā yāti, ētarhi jana ēkō dhāvan āgatya tatsammukhē jānunī pātayitvā pr̥ṣṭavān, bhōḥ paramagurō, anantāyuḥ prāptayē mayā kiṁ karttavyaṁ? ");
INSERT INTO saniso_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","tadā yīśuruvāca, māṁ paramaṁ kutō vadasi? vinēśvaraṁ kōpi paramō na bhavati| ");
INSERT INTO saniso_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","parastrīṁ nābhigaccha; naraṁ mā ghātaya; stēyaṁ mā kuru; mr̥ṣāsākṣyaṁ mā dēhi; hiṁsāñca mā kuru; pitarau sammanyasva; nidēśā ētē tvayā jñātāḥ| ");
INSERT INTO saniso_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","tatastana pratyuktaṁ, hē gurō bālyakālādahaṁ sarvvānētān ācarāmi| ");
INSERT INTO saniso_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","tadā yīśustaṁ vilōkya snēhēna babhāṣē, tavaikasyābhāva āstē; tvaṁ gatvā sarvvasvaṁ vikrīya daridrēbhyō viśrāṇaya, tataḥ svargē dhanaṁ prāpsyasi; tataḥ param ētya kruśaṁ vahan madanuvarttī bhava| ");
INSERT INTO saniso_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","kintu tasya bahusampadvidyamānatvāt sa imāṁ kathāmākarṇya viṣaṇō duḥkhitaśca san jagāma| ");
INSERT INTO saniso_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","atha yīśuścaturdiśō nirīkṣya śiṣyān avādīt, dhanilōkānām īśvararājyapravēśaḥ kīdr̥g duṣkaraḥ| ");
INSERT INTO saniso_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","tasya kathātaḥ śiṣyāścamaccakruḥ, kintu sa punaravadat, hē bālakā yē dhanē viśvasanti tēṣām īśvararājyapravēśaḥ kīdr̥g duṣkaraḥ| ");
INSERT INTO saniso_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","īśvararājyē dhanināṁ pravēśāt sūcirandhrēṇa mahāṅgasya gamanāgamanaṁ sukaraṁ| ");
INSERT INTO saniso_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","tadā śiṣyā atīva vismitāḥ parasparaṁ prōcuḥ, tarhi kaḥ paritrāṇaṁ prāptuṁ śaknōti? ");
INSERT INTO saniso_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","tatō yīśustān vilōkya babhāṣē, tan narasyāsādhyaṁ kintu nēśvarasya, yatō hētōrīśvarasya sarvvaṁ sādhyam| ");
INSERT INTO saniso_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","tadā pitara uvāca, paśya vayaṁ sarvvaṁ parityajya bhavatōnugāminō jātāḥ| ");
INSERT INTO saniso_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","tatō yīśuḥ pratyavadat, yuṣmānahaṁ yathārthaṁ vadāmi, madarthaṁ susaṁvādārthaṁ vā yō janaḥ sadanaṁ bhrātaraṁ bhaginīṁ pitaraṁ mātaraṁ jāyāṁ santānān bhūmi vā tyaktvā ");
INSERT INTO saniso_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","gr̥habhrātr̥bhaginīpitr̥mātr̥patnīsantānabhūmīnāmiha śataguṇān prētyānantāyuśca na prāpnōti tādr̥śaḥ kōpi nāsti| ");
INSERT INTO saniso_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","kintvagrīyā anēkē lōkāḥ śēṣāḥ, śēṣīyā anēkē lōkāścāgrā bhaviṣyanti| ");
INSERT INTO saniso_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","atha yirūśālamyānakālē yīśustēṣām agragāmī babhūva, tasmāttē citraṁ jñātvā paścādgāminō bhūtvā bibhyuḥ| tadā sa puna rdvādaśaśiṣyān gr̥hītvā svīyaṁ yadyad ghaṭiṣyatē tattat tēbhyaḥ kathayituṁ prārēbhē; ");
INSERT INTO saniso_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","paśyata vayaṁ yirūśālampuraṁ yāmaḥ, tatra manuṣyaputraḥ pradhānayājakānām upādhyāyānāñca karēṣu samarpayiṣyatē; tē ca vadhadaṇḍājñāṁ dāpayitvā paradēśīyānāṁ karēṣu taṁ samarpayiṣyanti| ");
INSERT INTO saniso_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","tē tamupahasya kaśayā prahr̥tya tadvapuṣi niṣṭhīvaṁ nikṣipya taṁ haniṣyanti, tataḥ sa tr̥tīyadinē prōtthāsyati| ");
INSERT INTO saniso_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","tataḥ sivadēḥ putrau yākūbyōhanau tadantikam ētya prōcatuḥ, hē gurō yad āvābhyāṁ yāciṣyatē tadasmadarthaṁ bhavān karōtu nivēdanamidamāvayōḥ| ");
INSERT INTO saniso_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","tataḥ sa kathitavān, yuvāṁ kimicchathaḥ? kiṁ mayā yuṣmadarthaṁ karaṇīyaṁ? ");
INSERT INTO saniso_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","tadā tau prōcatuḥ, āvayōrēkaṁ dakṣiṇapārśvē vāmapārśvē caikaṁ tavaiśvaryyapadē samupavēṣṭum ājñāpaya| ");
INSERT INTO saniso_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","kintu yīśuḥ pratyuvāca yuvāmajñātvēdaṁ prārthayēthē, yēna kaṁsēnāhaṁ pāsyāmi tēna yuvābhyāṁ kiṁ pātuṁ śakṣyatē? yasmin majjanēnāhaṁ majjiṣyē tanmajjanē majjayituṁ kiṁ yuvābhyāṁ śakṣyatē? tau pratyūcatuḥ śakṣyatē| ");
INSERT INTO saniso_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","tadā yīśuravadat yēna kaṁsēnāhaṁ pāsyāmi tēnāvaśyaṁ yuvāmapi pāsyathaḥ, yēna majjanēna cāhaṁ majjiyyē tatra yuvāmapi majjiṣyēthē| ");
INSERT INTO saniso_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","kintu yēṣāmartham idaṁ nirūpitaṁ, tān vihāyānyaṁ kamapi mama dakṣiṇapārśvē vāmapārśvē vā samupavēśayituṁ mamādhikārō nāsti| ");
INSERT INTO saniso_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","athānyadaśaśiṣyā imāṁ kathāṁ śrutvā yākūbyōhanbhyāṁ cukupuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","kintu yīśustān samāhūya babhāṣē, anyadēśīyānāṁ rājatvaṁ yē kurvvanti tē tēṣāmēva prabhutvaṁ kurvvanti, tathā yē mahālōkāstē tēṣām adhipatitvaṁ kurvvantīti yūyaṁ jānītha| ");
INSERT INTO saniso_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","kintu yuṣmākaṁ madhyē na tathā bhaviṣyati, yuṣmākaṁ madhyē yaḥ prādhānyaṁ vāñchati sa yuṣmākaṁ sēvakō bhaviṣyati, ");
INSERT INTO saniso_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","yuṣmākaṁ yō mahān bhavitumicchati sa sarvvēṣāṁ kiṅkarō bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","yatō manuṣyaputraḥ sēvyō bhavituṁ nāgataḥ sēvāṁ karttāṁ tathānēkēṣāṁ paritrāṇasya mūlyarūpasvaprāṇaṁ dātuñcāgataḥ| ");
INSERT INTO saniso_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","atha tē yirīhōnagaraṁ prāptāstasmāt śiṣyai rlōkaiśca saha yīśō rgamanakālē ṭīmayasya putrō barṭīmayanāmā andhastanmārgapārśvē bhikṣārtham upaviṣṭaḥ| ");
INSERT INTO saniso_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","sa nāsaratīyasya yīśōrāgamanavārttāṁ prāpya prōcai rvaktumārēbhē, hē yīśō dāyūdaḥ santāna māṁ dayasva| ");
INSERT INTO saniso_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","tatōnēkē lōkā maunībhavēti taṁ tarjayāmāsuḥ, kintu sa punaradhikamuccai rjagāda, hē yīśō dāyūdaḥ santāna māṁ dayasva| ");
INSERT INTO saniso_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","tadā yīśuḥ sthitvā tamāhvātuṁ samādidēśa, tatō lōkāstamandhamāhūya babhāṣirē, hē nara, sthirō bhava, uttiṣṭha, sa tvāmāhvayati| ");
INSERT INTO saniso_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","tadā sa uttarīyavastraṁ nikṣipya prōtthāya yīśōḥ samīpaṁ gataḥ| ");
INSERT INTO saniso_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","tatō yīśustamavadat tvayā kiṁ prārthyatē? tubhyamahaṁ kiṁ kariṣyāmī? tadā sōndhastamuvāca, hē gurō madīyā dr̥ṣṭirbhavēt| ");
INSERT INTO saniso_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","tatō yīśustamuvāca yāhi tava viśvāsastvāṁ svasthamakārṣīt, tasmāt tatkṣaṇaṁ sa dr̥ṣṭiṁ prāpya pathā yīśōḥ paścād yayau| ");
INSERT INTO saniso_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","anantaraṁ tēṣu yirūśālamaḥ samīpasthayō rbaitphagībaithanīyapurayōrantikasthaṁ jaitunanāmādrimāgatēṣu yīśuḥ prēṣaṇakālē dvau śiṣyāvidaṁ vākyaṁ jagāda, ");
INSERT INTO saniso_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","yuvāmamuṁ sammukhasthaṁ grāmaṁ yātaṁ, tatra praviśya yō naraṁ nāvahat taṁ garddabhaśāvakaṁ drakṣyathastaṁ mōcayitvānayataṁ| ");
INSERT INTO saniso_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","kintu yuvāṁ karmmēdaṁ kutaḥ kuruthaḥ? kathāmimāṁ yadi kōpi pr̥cchati tarhi prabhōratra prayōjanamastīti kathitē sa śīghraṁ tamatra prēṣayiṣyati| ");
INSERT INTO saniso_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","tatastau gatvā dvimārgamēlanē kasyacid dvārasya pārśvē taṁ garddabhaśāvakaṁ prāpya mōcayataḥ, ");
INSERT INTO saniso_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ētarhi tatrōpasthitalōkānāṁ kaścid apr̥cchat, garddabhaśiśuṁ kutō mōcayathaḥ? ");
INSERT INTO saniso_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","tadā yīśōrājñānusārēṇa tēbhyaḥ pratyuditē tatkṣaṇaṁ tamādātuṁ tē'nujajñuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","atha tau yīśōḥ sannidhiṁ garddabhaśiśum ānīya tadupari svavastrāṇi pātayāmāsatuḥ; tataḥ sa tadupari samupaviṣṭaḥ| ");
INSERT INTO saniso_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","tadānēkē pathi svavāsāṁsi pātayāmāsuḥ, paraiśca taruśākhāśchitavā mārgē vikīrṇāḥ| ");
INSERT INTO saniso_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","aparañca paścādgāminō'gragāminaśca sarvvē janā ucaiḥsvarēṇa vaktumārēbhirē, jaya jaya yaḥ paramēśvarasya nāmnāgacchati sa dhanya iti| ");
INSERT INTO saniso_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","tathāsmākamaṁ pūrvvapuruṣasya dāyūdō yadrājyaṁ paramēśvaranāmnāyāti tadapi dhanyaṁ, sarvvasmāducchrāyē svargē īśvarasya jayō bhavēt| ");
INSERT INTO saniso_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","itthaṁ yīśu ryirūśālami mandiraṁ praviśya caturdiksthāni sarvvāṇi vastūni dr̥ṣṭavān; atha sāyaṁkāla upasthitē dvādaśaśiṣyasahitō baithaniyaṁ jagāma| ");
INSERT INTO saniso_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","aparēhani baithaniyād āgamanasamayē kṣudhārttō babhūva| ");
INSERT INTO saniso_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","tatō dūrē sapatramuḍumbarapādapaṁ vilōkya tatra kiñcit phalaṁ prāptuṁ tasya sannikr̥ṣṭaṁ yayau, tadānīṁ phalapātanasya samayō nāgacchati| tatastatrōpasthitaḥ patrāṇi vinā kimapyaparaṁ na prāpya sa kathitavān, ");
INSERT INTO saniso_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","adyārabhya kōpi mānavastvattaḥ phalaṁ na bhuñjīta; imāṁ kathāṁ tasya śiṣyāḥ śuśruvuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","tadanantaraṁ tēṣu yirūśālamamāyātēṣu yīśu rmandiraṁ gatvā tatrasthānāṁ baṇijāṁ mudrāsanāni pārāvatavikrētr̥ṇām āsanāni ca nyubjayāñcakāra sarvvān krētr̥n vikrētr̥ṁśca bahiścakāra| ");
INSERT INTO saniso_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","aparaṁ mandiramadhyēna kimapi pātraṁ vōḍhuṁ sarvvajanaṁ nivārayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","lōkānupadiśan jagāda, mama gr̥haṁ sarvvajātīyānāṁ prārthanāgr̥ham iti nāmnā prathitaṁ bhaviṣyati ētat kiṁ śāstrē likhitaṁ nāsti? kintu yūyaṁ tadēva cōrāṇāṁ gahvaraṁ kurutha| ");
INSERT INTO saniso_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","imāṁ vāṇīṁ śrutvādhyāpakāḥ pradhānayājakāśca taṁ yathā nāśayituṁ śaknuvanti tathōेpāyaṁ mr̥gayāmāsuḥ, kintu tasyōpadēśāt sarvvē lōkā vismayaṁ gatā atastē tasmād bibhyuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","atha sāyaṁsamaya upasthitē yīśurnagarād bahirvavrāja| ");
INSERT INTO saniso_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","anantaraṁ prātaḥkālē tē tēna mārgēṇa gacchantastamuḍumbaramahīruhaṁ samūlaṁ śuṣkaṁ dadr̥śuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","tataḥ pitaraḥ pūrvvavākyaṁ smaran yīśuṁ babhāṣaṁ, hē gurō paśyatu ya uḍumbaraviṭapī bhavatā śaptaḥ sa śuṣkō babhūva| ");
INSERT INTO saniso_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","tatō yīśuḥ pratyavādīt, yūyamīśvarē viśvasita| ");
INSERT INTO saniso_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","yuṣmānahaṁ yathārthaṁ vadāmi kōpi yadyētadgiriṁ vadati, tvamutthāya gatvā jaladhau pata, prōktamidaṁ vākyamavaśyaṁ ghaṭiṣyatē, manasā kimapi na sandihya cēdidaṁ viśvasēt tarhi tasya vākyānusārēṇa tad ghaṭiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","atō hētōrahaṁ yuṣmān vacmi, prārthanākālē yadyadākāṁkṣiṣyadhvē tattadavaśyaṁ prāpsyatha, itthaṁ viśvasita, tataḥ prāpsyatha| ");
INSERT INTO saniso_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","aparañca yuṣmāsu prārthayituṁ samutthitēṣu yadi kōpi yuṣmākam aparādhī tiṣṭhati, tarhi taṁ kṣamadhvaṁ, tathā kr̥tē yuṣmākaṁ svargasthaḥ pitāpi yuṣmākamāgāṁmi kṣamiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","kintu yadi na kṣamadhvē tarhi vaḥ svargasthaḥ pitāpi yuṣmākamāgāṁsi na kṣamiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","anantaraṁ tē puna ryirūśālamaṁ praviviśuḥ, yīśu ryadā madhyēmandiram itastatō gacchati, tadānīṁ pradhānayājakā upādhyāyāḥ prāñcaśca tadantikamētya kathāmimāṁ papracchuḥ, ");
INSERT INTO saniso_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","tvaṁ kēnādēśēna karmmāṇyētāni karōṣi? tathaitāni karmmāṇi karttāṁ kēnādiṣṭōsi? ");
INSERT INTO saniso_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","tatō yīśuḥ pratigaditavān ahamapi yuṣmān ēkakathāṁ pr̥cchāmi, yadi yūyaṁ tasyā uttaraṁ kurutha, tarhi kayājñayāhaṁ karmmāṇyētāni karōmi tad yuṣmabhyaṁ kathayiṣyāmi| ");
INSERT INTO saniso_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","yōhanō majjanam īśvarāt jātaṁ kiṁ mānavāt? tanmahyaṁ kathayata| ");
INSERT INTO saniso_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","tē parasparaṁ vivēktuṁ prārēbhirē, tad īśvarād babhūvēti cēd vadāmastarhi kutastaṁ na pratyaita? kathamētāṁ kathayiṣyati| ");
INSERT INTO saniso_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","mānavād abhavaditi cēd vadāmastarhi lōkēbhyō bhayamasti yatō hētōḥ sarvvē yōhanaṁ satyaṁ bhaviṣyadvādinaṁ manyantē| ");
INSERT INTO saniso_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ataēva tē yīśuṁ pratyavādiṣu rvayaṁ tad vaktuṁ na śaknumaḥ| yīśuruvāca, tarhi yēnādēśēna karmmāṇyētāni karōmi, ahamapi yuṣmabhyaṁ tanna kathayiṣyāmi| ");
INSERT INTO saniso_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","anantaraṁ yīśu rdr̥ṣṭāntēna tēbhyaḥ kathayitumārēbhē, kaścidēkō drākṣākṣētraṁ vidhāya taccaturdikṣu vāraṇīṁ kr̥tvā tanmadhyē drākṣāpēṣaṇakuṇḍam akhanat, tathā tasya gaḍamapi nirmmitavān tatastatkṣētraṁ kr̥ṣīvalēṣu samarpya dūradēśaṁ jagāma| ");
INSERT INTO saniso_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","tadanantaraṁ phalakālē kr̥ṣīvalēbhyō drākṣākṣētraphalāni prāptuṁ tēṣāṁ savidhē bhr̥tyam ēkaṁ prāhiṇōt| ");
INSERT INTO saniso_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","kintu kr̥ṣīvalāstaṁ dhr̥tvā prahr̥tya riktahastaṁ visasr̥juḥ| ");
INSERT INTO saniso_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","tataḥ sa punaranyamēkaṁ bhr̥tyaṁ praṣayāmāsa, kintu tē kr̥ṣīvalāḥ pāṣāṇāghātaistasya śirō bhaṅktvā sāpamānaṁ taṁ vyasarjan| ");
INSERT INTO saniso_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","tataḥ paraṁ sōparaṁ dāsaṁ prāhiṇōt tadā tē taṁ jaghnuḥ, ēvam anēkēṣāṁ kasyacit prahāraḥ kasyacid vadhaśca taiḥ kr̥taḥ| ");
INSERT INTO saniso_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","tataḥ paraṁ mayā svaputrē prahitē tē tamavaśyaṁ sammaṁsyantē, ityuktvāvaśēṣē tēṣāṁ sannidhau nijapriyam advitīyaṁ putraṁ prēṣayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","kintu kr̥ṣīvalāḥ parasparaṁ jagaduḥ, ēṣa uttarādhikārī, āgacchata vayamēnaṁ hanmastathā kr̥tē 'dhikārōyam asmākaṁ bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","tatastaṁ dhr̥tvā hatvā drākṣākṣētrād bahiḥ prākṣipan| ");
INSERT INTO saniso_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","anēnāsau drākṣākṣētrapatiḥ kiṁ kariṣyati? sa ētya tān kr̥ṣīvalān saṁhatya tatkṣētram anyēṣu kr̥ṣīvalēṣu samarpayiṣyati| ");
INSERT INTO saniso_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","aparañca, \"sthapatayaḥ kariṣyanti grāvāṇaṁ yantu tucchakaṁ| prādhānaprastaraḥ kōṇē sa ēva saṁbhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ētat karmma parēśasyāṁdbhutaṁ nō dr̥ṣṭitō bhavēt||\" imāṁ śāstrīyāṁ lipiṁ yūyaṁ kiṁ nāpāṭhiṣṭa? ");
INSERT INTO saniso_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","tadānīṁ sa tānuddiśya tāṁ dr̥ṣṭāntakathāṁ kathitavān, ta itthaṁ budvvā taṁ dharttāmudyatāḥ, kintu lōkēbhyō bibhyuḥ, tadanantaraṁ tē taṁ vihāya vavrajuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","aparañca tē tasya vākyadōṣaṁ dharttāṁ katipayān phirūśinō hērōdīyāṁśca lōkān tadantikaṁ prēṣayāmāsuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ta āgatya tamavadan, hē gurō bhavān tathyabhāṣī kasyāpyanurōdhaṁ na manyatē, pakṣapātañca na karōti, yathārthata īśvarīyaṁ mārgaṁ darśayati vayamētat prajānīmaḥ, kaisarāya karō dēyō na vāṁ? vayaṁ dāsyāmō na vā? ");
INSERT INTO saniso_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","kintu sa tēṣāṁ kapaṭaṁ jñātvā jagāda, kutō māṁ parīkṣadhvē? ēkaṁ mudrāpādaṁ samānīya māṁ darśayata| ");
INSERT INTO saniso_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","tadā tairēkasmin mudrāpādē samānītē sa tān papraccha, atra likhitaṁ nāma mūrtti rvā kasya? tē pratyūcuḥ, kaisarasya| ");
INSERT INTO saniso_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","tadā yīśuravadat tarhi kaisarasya dravyāṇi kaisarāya datta, īśvarasya dravyāṇi tu īśvarāya datta; tatastē vismayaṁ mēnirē| ");
INSERT INTO saniso_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","atha mr̥tānāmutthānaṁ yē na manyantē tē sidūkinō yīśōḥ samīpamāgatya taṁ papracchuḥ; ");
INSERT INTO saniso_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","hē gurō kaścijjanō yadi niḥsantatiḥ san bhāryyāyāṁ satyāṁ mriyatē tarhi tasya bhrātā tasya bhāryyāṁ gr̥hītvā bhrātu rvaṁśōtpattiṁ kariṣyati, vyavasthāmimāṁ mūsā asmān prati vyalikhat| ");
INSERT INTO saniso_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","kintu kēcit sapta bhrātara āsan, tatastēṣāṁ jyēṣṭhabhrātā vivahya niḥsantatiḥ san amriyata| ");
INSERT INTO saniso_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","tatō dvitīyō bhrātā tāṁ striyamagr̥haṇat kintu sōpi niḥsantatiḥ san amriyata; atha tr̥tīyōpi bhrātā tādr̥śōbhavat| ");
INSERT INTO saniso_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","itthaṁ saptaiva bhrātarastāṁ striyaṁ gr̥hītvā niḥsantānāḥ santō'mriyanta, sarvvaśēṣē sāpi strī mriyatē sma| ");
INSERT INTO saniso_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","atha mr̥tānāmutthānakālē yadā ta utthāsyanti tadā tēṣāṁ kasya bhāryyā sā bhaviṣyati? yatastē saptaiva tāṁ vyavahan| ");
INSERT INTO saniso_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","tatō yīśuḥ pratyuvāca śāstram īśvaraśaktiñca yūyamajñātvā kimabhrāmyata na? ");
INSERT INTO saniso_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","mr̥talōkānāmutthānaṁ sati tē na vivahanti vāgdattā api na bhavanti, kintu svargīyadūtānāṁ sadr̥śā bhavanti| ");
INSERT INTO saniso_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","punaśca \"aham ibrāhīma īśvara ishāka īśvarō yākūbaścēśvaraḥ\" yāmimāṁ kathāṁ stambamadhyē tiṣṭhan īśvarō mūsāmavādīt mr̥tānāmutthānārthē sā kathā mūsālikhitē pustakē kiṁ yuṣmābhi rnāpāṭhi? ");
INSERT INTO saniso_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","īśvarō jīvatāṁ prabhuḥ kintu mr̥tānāṁ prabhu rna bhavati, tasmāddhētō ryūyaṁ mahābhramēṇa tiṣṭhatha| ");
INSERT INTO saniso_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ētarhi ēkōdhyāpaka ētya tēṣāmitthaṁ vicāraṁ śuśrāva; yīśustēṣāṁ vākyasya saduttaraṁ dattavān iti budvvā taṁ pr̥ṣṭavān sarvvāsām ājñānāṁ kā śrēṣṭhā? tatō yīśuḥ pratyuvāca, ");
INSERT INTO saniso_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","\"hē isrāyēllōkā avadhatta, asmākaṁ prabhuḥ paramēśvara ēka ēva, ");
INSERT INTO saniso_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","yūyaṁ sarvvantaḥkaraṇaiḥ sarvvaprāṇaiḥ sarvvacittaiḥ sarvvaśaktibhiśca tasmin prabhau paramēśvarē prīyadhvaṁ,\" ityājñā śrēṣṭhā| ");
INSERT INTO saniso_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","tathā \"svaprativāsini svavat prēma kurudhvaṁ,\" ēṣā yā dvitīyājñā sā tādr̥śī; ētābhyāṁ dvābhyām ājñābhyām anyā kāpyājñā śrēṣṭhā nāsti| ");
INSERT INTO saniso_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","tadā sōdhyāpakastamavadat, hē gurō satyaṁ bhavān yathārthaṁ prōktavān yata ēkasmād īśvarād anyō dvitīya īśvarō nāsti; ");
INSERT INTO saniso_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","aparaṁ sarvvāntaḥkaraṇaiḥ sarvvaprāṇaiḥ sarvvacittaiḥ sarvvaśaktibhiśca īśvarē prēmakaraṇaṁ tathā svamīpavāsini svavat prēmakaraṇañca sarvvēbhyō hōmabalidānādibhyaḥ śraṣṭhaṁ bhavati| ");
INSERT INTO saniso_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","tatō yīśuḥ subuddhēriva tasyēdam uttaraṁ śrutvā taṁ bhāṣitavān tvamīśvarasya rājyānna dūrōsi|itaḥ paraṁ tēna saha kasyāpi vākyasya vicāraṁ karttāṁ kasyāpi pragalbhatā na jātā| ");
INSERT INTO saniso_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","anantaraṁ madhyēmandiram upadiśan yīśurimaṁ praśnaṁ cakāra, adhyāpakā abhiṣiktaṁ (tārakaṁ) kutō dāyūdaḥ santānaṁ vadanti? ");
INSERT INTO saniso_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","svayaṁ dāyūd pavitrasyātmana āvēśēnēdaṁ kathayāmāsa| yathā| \"mama prabhumidaṁ vākyavadat paramēśvaraḥ| tava śatrūnahaṁ yāvat pādapīṭhaṁ karōmi na| tāvat kālaṁ madīyē tvaṁ dakṣapārśv upāviśa|\" ");
INSERT INTO saniso_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","yadi dāyūd taṁ prabhūṁ vadati tarhi kathaṁ sa tasya santānō bhavitumarhati? itarē lōkāstatkathāṁ śrutvānananduḥ| ");
INSERT INTO saniso_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","tadānīṁ sa tānupadiśya kathitavān yē narā dīrghaparidhēyāni haṭṭē vipanau ca ");
INSERT INTO saniso_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","lōkakr̥tanamaskārān bhajanagr̥hē pradhānāsanāni bhōjanakālē pradhānasthānāni ca kāṅkṣantē; ");
INSERT INTO saniso_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","vidhavānāṁ sarvvasvaṁ grasitvā chalād dīrghakālaṁ prārthayantē tēbhya upādhyāyēbhyaḥ sāvadhānā bhavata; tē'dhikatarān daṇḍān prāpsyanti| ");
INSERT INTO saniso_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","tadanantaraṁ lōkā bhāṇḍāgārē mudrā yathā nikṣipanti bhāṇḍāgārasya sammukhē samupaviśya yīśustadavalulōka; tadānīṁ bahavō dhaninastasya madhyē bahūni dhanāni nirakṣipan| ");
INSERT INTO saniso_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","paścād ēkā daridrā vidhavā samāgatya dvipaṇamūlyāṁ mudraikāṁ tatra nirakṣipat| ");
INSERT INTO saniso_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","tadā yīśuḥ śiṣyān āhūya kathitavān yuṣmānahaṁ yathārthaṁ vadāmi yē yē bhāṇḍāgārē'smina dhanāni niḥkṣipanti sma tēbhyaḥ sarvvēbhya iyaṁ vidhavā daridrādhikam niḥkṣipati sma| ");
INSERT INTO saniso_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","yatastē prabhūtadhanasya kiñcit nirakṣipan kintu dīnēyaṁ svadinayāpanayōgyaṁ kiñcidapi na sthāpayitvā sarvvasvaṁ nirakṣipat| ");
INSERT INTO saniso_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","anantaraṁ mandirād bahirgamanakālē tasya śiṣyāṇāmēkastaṁ vyāhr̥tavān hē gurō paśyatu kīdr̥śāḥ pāṣāṇāḥ kīdr̥k ca nicayanaṁ| ");
INSERT INTO saniso_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","tadā yīśustam avadat tvaṁ kimētad br̥hannicayanaṁ paśyasi? asyaikapāṣāṇōpi dvitīyapāṣāṇōpari na sthāsyati sarvvē 'dhaḥkṣēpsyantē| ");
INSERT INTO saniso_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","atha yasmin kālē jaitungirau mandirasya sammukhē sa samupaviṣṭastasmin kālē pitarō yākūb yōhan āndriyaścaitē taṁ rahasi papracchuḥ, ");
INSERT INTO saniso_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","ētā ghaṭanāḥ kadā bhaviṣyanti? tathaitatsarvvāsāṁ siddhyupakramasya vā kiṁ cihnaṁ? tadasmabhyaṁ kathayatu bhavān| ");
INSERT INTO saniso_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","tatō yāśustān vaktumārēbhē, kōpi yathā yuṣmān na bhrāmayati tathātra yūyaṁ sāvadhānā bhavata| ");
INSERT INTO saniso_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","yataḥ khrīṣṭōhamiti kathayitvā mama nāmnānēkē samāgatya lōkānāṁ bhramaṁ janayiṣyanti; ");
INSERT INTO saniso_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","kintu yūyaṁ raṇasya vārttāṁ raṇāḍambarañca śrutvā mā vyākulā bhavata, ghaṭanā ētā avaśyammāvinyaḥ; kintvāpātatō na yugāntō bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","dēśasya vipakṣatayā dēśō rājyasya vipakṣatayā ca rājyamutthāsyati, tathā sthānē sthānē bhūmikampō durbhikṣaṁ mahāklēśāśca samupasthāsyanti, sarvva ētē duḥkhasyārambhāḥ| ");
INSERT INTO saniso_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","kintu yūyam ātmārthē sāvadhānāstiṣṭhata, yatō lōkā rājasabhāyāṁ yuṣmān samarpayiṣyanti, tathā bhajanagr̥hē prahariṣyanti; yūyaṁ madarthē dēśādhipān bhūpāṁśca prati sākṣyadānāya tēṣāṁ sammukhē upasthāpayiṣyadhvē| ");
INSERT INTO saniso_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","śēṣībhavanāt pūrvvaṁ sarvvān dēśīyān prati susaṁvādaḥ pracārayiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","kintu yadā tē yuṣmān dhr̥tvā samarpayiṣyanti tadā yūyaṁ yadyad uttaraṁ dāsyatha, tadagra tasya vivēcanaṁ mā kuruta tadarthaṁ kiñcidapi mā cintayata ca, tadānīṁ yuṣmākaṁ manaḥsu yadyad vākyam upasthāpayiṣyatē tadēva vadiṣyatha, yatō yūyaṁ na tadvaktāraḥ kintu pavitra ātmā tasya vaktā| ");
INSERT INTO saniso_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","tadā bhrātā bhrātaraṁ pitā putraṁ ghātanārthaṁ parahastēṣu samarpayiṣyatē, tathā patyāni mātāpitrō rvipakṣatayā tau ghātayiṣyanti| ");
INSERT INTO saniso_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","mama nāmahētōḥ sarvvēṣāṁ savidhē yūyaṁ jugupsitā bhaviṣyatha, kintu yaḥ kaścit śēṣaparyyantaṁ dhairyyam ālambiṣyatē saēva paritrāsyatē| ");
INSERT INTO saniso_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","dāniyēlbhaviṣyadvādinā prōktaṁ sarvvanāśi jugupsitañca vastu yadā tvayōgyasthānē vidyamānaṁ drakṣatha (yō janaḥ paṭhati sa budhyatāṁ) tadā yē yihūdīyadēśē tiṣṭhanti tē mahīdhraṁ prati palāyantāṁ; ");
INSERT INTO saniso_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","tathā yō narō gr̥hōpari tiṣṭhati sa gr̥hamadhyaṁ nāvarōhatu, tathā kimapi vastu grahītuṁ madhyēgr̥haṁ na praviśatu; ");
INSERT INTO saniso_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","tathā ca yō naraḥ kṣētrē tiṣṭhati sōpi svavastraṁ grahītuṁ parāvr̥tya na vrajatu| ");
INSERT INTO saniso_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","tadānīṁ garbbhavatīnāṁ stanyadātrīṇāñca yōṣitāṁ durgati rbhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","yuṣmākaṁ palāyanaṁ śītakālē yathā na bhavati tadarthaṁ prārthayadhvaṁ| ");
INSERT INTO saniso_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","yatastadā yādr̥śī durghaṭanā ghaṭiṣyatē tādr̥śī durghaṭanā īśvarasr̥ṣṭēḥ prathamamārabhyādya yāvat kadāpi na jātā na janiṣyatē ca| ");
INSERT INTO saniso_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","aparañca paramēśvarō yadi tasya samayasya saṁkṣēpaṁ na karōti tarhi kasyāpi prāṇabhr̥tō rakṣā bhavituṁ na śakṣyati, kintu yān janān manōnītān akarōt tēṣāṁ svamanōnītānāṁ hētōḥ sa tadanēhasaṁ saṁkṣēpsyati| ");
INSERT INTO saniso_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","anyacca paśyata khrīṣṭōtra sthānē vā tatra sthānē vidyatē, tasminkālē yadi kaścid yuṣmān ētādr̥śaṁ vākyaṁ vyāharati, tarhi tasmin vākyē bhaiva viśvasita| ");
INSERT INTO saniso_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","yatōnēkē mithyākhrīṣṭā mithyābhaviṣyadvādinaśca samupasthāya bahūni cihnānyadbhutāni karmmāṇi ca darśayiṣyanti; tathā yadi sambhavati tarhi manōnītalōkānāmapi mithyāmatiṁ janayiṣyanti| ");
INSERT INTO saniso_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","paśyata ghaṭanātaḥ pūrvvaṁ sarvvakāryyasya vārttāṁ yuṣmabhyamadām, yūyaṁ sāvadhānāstiṣṭhata| ");
INSERT INTO saniso_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","aparañca tasya klēśakālasyāvyavahitē parakālē bhāskaraḥ sāndhakārō bhaviṣyati tathaiva candraścandrikāṁ na dāsyati| ");
INSERT INTO saniso_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","nabhaḥsthāni nakṣatrāṇi patiṣyanti, vyōmamaṇḍalasthā grahāśca vicaliṣyanti| ");
INSERT INTO saniso_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","tadānīṁ mahāparākramēṇa mahaiśvaryyēṇa ca mēghamāruhya samāyāntaṁ mānavasutaṁ mānavāḥ samīkṣiṣyantē| ");
INSERT INTO saniso_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","anyacca sa nijadūtān prahitya nabhōbhūmyōḥ sīmāṁ yāvad jagataścaturdigbhyaḥ svamanōnītalōkān saṁgrahīṣyati| ");
INSERT INTO saniso_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","uḍumbaratarō rdr̥ṣṭāntaṁ śikṣadhvaṁ yadōḍumbarasya tarō rnavīnāḥ śākhā jāyantē pallavādīni ca rnigacchanti, tadā nidāghakālaḥ savidhō bhavatīti yūyaṁ jñātuṁ śaknutha| ");
INSERT INTO saniso_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","tadvad ētā ghaṭanā dr̥ṣṭvā sa kālō dvāryyupasthita iti jānīta| ");
INSERT INTO saniso_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","yuṣmānahaṁ yathārthaṁ vadāmi, ādhunikalōkānāṁ gamanāt pūrvvaṁ tāni sarvvāṇi ghaṭiṣyantē| ");
INSERT INTO saniso_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","dyāvāpr̥thivyō rvicalitayōḥ satyō rmadīyā vāṇī na vicaliṣyati| ");
INSERT INTO saniso_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","aparañca svargasthadūtagaṇō vā putrō vā tātādanyaḥ kōpi taṁ divasaṁ taṁ daṇḍaṁ vā na jñāpayati| ");
INSERT INTO saniso_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ataḥ sa samayaḥ kadā bhaviṣyati, ētajjñānābhāvād yūyaṁ sāvadhānāstiṣṭhata, satarkāśca bhūtvā prārthayadhvaṁ; ");
INSERT INTO saniso_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","yadvat kaścit pumān svanivēśanād dūradēśaṁ prati yātrākaraṇakālē dāsēṣu svakāryyasya bhāramarpayitvā sarvvān svē svē karmmaṇi niyōjayati; aparaṁ dauvārikaṁ jāgarituṁ samādiśya yāti, tadvan naraputraḥ| ");
INSERT INTO saniso_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","gr̥hapatiḥ sāyaṁkālē niśīthē vā tr̥tīyayāmē vā prātaḥkālē vā kadāgamiṣyati tad yūyaṁ na jānītha; ");
INSERT INTO saniso_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","sa haṭhādāgatya yathā yuṣmān nidritān na paśyati, tadarthaṁ jāgaritāstiṣṭhata| ");
INSERT INTO saniso_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","yuṣmānahaṁ yad vadāmi tadēva sarvvān vadāmi, jāgaritāstiṣṭhatēti| ");
INSERT INTO saniso_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","tadā nistārōtsavakiṇvahīnapūpōtsavayōrārambhasya dinadvayē 'vaśiṣṭē pradhānayājakā adhyāpakāśca kēnāpi chalēna yīśuṁ dharttāṁ hantuñca mr̥gayāñcakrirē; ");
INSERT INTO saniso_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","kintu lōkānāṁ kalahabhayādūcirē, nacōtsavakāla ucitamētaditi| ");
INSERT INTO saniso_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","anantaraṁ baithaniyāpuुrē śimōnakuṣṭhinō gr̥hē yōśau bhōtkumupaviṣṭē sati kācid yōṣit pāṇḍarapāṣāṇasya sampuṭakēna mahārghyōttamatailam ānīya sampuṭakaṁ bhaṁktvā tasyōttamāṅgē tailadhārāṁ pātayāñcakrē| ");
INSERT INTO saniso_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","tasmāt kēcit svāntē kupyantaḥ kathitavaṁntaḥ kutōyaṁ tailāpavyayaḥ? ");
INSERT INTO saniso_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","yadyētat taila vyakrēṣyata tarhi mudrāpādaśatatrayādapyadhikaṁ tasya prāptamūlyaṁ daridralōkēbhyō dātumaśakṣyata, kathāmētāṁ kathayitvā tayā yōṣitā sākaṁ vācāyuhyan| ");
INSERT INTO saniso_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","kintu yīśuruvāca, kuta ētasyai kr̥cchraṁ dadāsi? mahyamiyaṁ karmmōttamaṁ kr̥tavatī| ");
INSERT INTO saniso_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","daridrāḥ sarvvadā yuṣmābhiḥ saha tiṣṭhanti, tasmād yūyaṁ yadēcchatha tadaiva tānupakarttāṁ śaknutha, kintvahaṁ yubhābhiḥ saha nirantaraṁ na tiṣṭhāmi| ");
INSERT INTO saniso_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","asyā yathāsādhyaṁ tathaivākarōdiyaṁ, śmaśānayāpanāt pūrvvaṁ samētya madvapuṣi tailam amarddayat| ");
INSERT INTO saniso_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","ahaṁ yuṣmabhyaṁ yathārthaṁ kathayāmi, jagatāṁ madhyē yatra yatra susaṁvādōyaṁ pracārayiṣyatē tatra tatra yōṣita ētasyāḥ smaraṇārthaṁ tatkr̥takarmmaitat pracārayiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","tataḥ paraṁ dvādaśānāṁ śiṣyāṇāmēka īṣkariyōtīyayihūdākhyō yīśuṁ parakarēṣu samarpayituṁ pradhānayājakānāṁ samīpamiyāya| ");
INSERT INTO saniso_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","tē tasya vākyaṁ samākarṇya santuṣṭāḥ santastasmai mudrā dātuṁ pratyajānata; tasmāt sa taṁ tēṣāṁ karēṣu samarpaṇāyōpāyaṁ mr̥gayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","anantaraṁ kiṇvaśūnyapūpōtsavasya prathamē'hani nistārōtmavārthaṁ mēṣamāraṇāsamayē śiṣyāstaṁ papracchaḥ kutra gatvā vayaṁ nistārōtsavasya bhōjyamāsādayiṣyāmaḥ? kimicchati bhavān? ");
INSERT INTO saniso_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","tadānīṁ sa tēṣāṁ dvayaṁ prērayan babhāṣē yuvayōḥ puramadhyaṁ gatayōḥ satō ryō janaḥ sajalakumbhaṁ vahan yuvāṁ sākṣāt kariṣyati tasyaiva paścād yātaṁ; ");
INSERT INTO saniso_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","sa yat sadanaṁ pravēkṣyati tadbhavanapatiṁ vadataṁ, gururāha yatra saśiṣyōhaṁ nistārōtsavīyaṁ bhōjanaṁ kariṣyāmi, sā bhōjanaśālā kutrāsti? ");
INSERT INTO saniso_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","tataḥ sa pariṣkr̥tāṁ susajjitāṁ br̥hatīcañca yāṁ śālāṁ darśayiṣyati tasyāmasmadarthaṁ bhōjyadravyāṇyāsādayataṁ| ");
INSERT INTO saniso_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","tataḥ śiṣyau prasthāya puraṁ praviśya sa yathōktavān tathaiva prāpya nistārōtsavasya bhōjyadravyāṇi samāsādayētām| ");
INSERT INTO saniso_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","anantaraṁ yīśuḥ sāyaṁkālē dvādaśabhiḥ śiṣyaiḥ sārddhaṁ jagāma; ");
INSERT INTO saniso_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","sarvvēṣu bhōjanāya prōpaviṣṭēṣu sa tānuditavān yuṣmānahaṁ yathārthaṁ vyāharāmi, atra yuṣmākamēkō janō yō mayā saha bhuṁktē māṁ parakērēṣu samarpayiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","tadānīṁ tē duḥkhitāḥ santa ēkaikaśastaṁ praṣṭumārabdhavantaḥ sa kimahaṁ? paścād anya ēkōbhidadhē sa kimahaṁ? ");
INSERT INTO saniso_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","tataḥ sa pratyavadad ētēṣāṁ dvādaśānāṁ yō janō mayā samaṁ bhōjanāpātrē pāṇiṁ majjayiṣyati sa ēva| ");
INSERT INTO saniso_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","manujatanayamadhi yādr̥śaṁ likhitamāstē tadanurūpā gatistasya bhaviṣyati, kintu yō janō mānavasutaṁ samarpayiṣyatē hanta tasya janmābhāvē sati bhadramabhaviṣyat| ");
INSERT INTO saniso_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","aparañca tēṣāṁ bhōjanasamayē yīśuḥ pūpaṁ gr̥hītvēśvaraguṇān anukīrtya bhaṅktvā tēbhyō dattvā babhāṣē, ētad gr̥hītvā bhuñjīdhvam ētanmama vigraharūpaṁ| ");
INSERT INTO saniso_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","anantaraṁ sa kaṁsaṁ gr̥hītvēśvarasya guṇān kīrttayitvā tēbhyō dadau, tatastē sarvvē papuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","aparaṁ sa tānavādīd bahūnāṁ nimittaṁ pātitaṁ mama navīnaniyamarūpaṁ śōṇitamētat| ");
INSERT INTO saniso_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","yuṣmānahaṁ yathārthaṁ vadāmi, īśvarasya rājyē yāvat sadyōjātaṁ drākṣārasaṁ na pāsyāmi,tāvadahaṁ drākṣāphalarasaṁ puna rna pāsyāmi| ");
INSERT INTO saniso_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","tadanantaraṁ tē gītamēkaṁ saṁgīya bahi rjaitunaṁ śikhariṇaṁ yayuḥ ");
INSERT INTO saniso_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","atha yīśustānuvāca niśāyāmasyāṁ mayi yuṣmākaṁ sarvvēṣāṁ pratyūhō bhaviṣyati yatō likhitamāstē yathā, mēṣāṇāṁ rakṣakañcāhaṁ prahariṣyāmi vai tataḥ| mēṣāṇāṁ nivahō nūnaṁ pravikīrṇō bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","kantu madutthānē jātē yuṣmākamagrē'haṁ gālīlaṁ vrajiṣyāmi| ");
INSERT INTO saniso_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","tadā pitaraḥ pratibabhāṣē, yadyapi sarvvēṣāṁ pratyūhō bhavati tathāpi mama naiva bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","tatō yīśuruktāvān ahaṁ tubhyaṁ tathyaṁ kathayāmi, kṣaṇādāyāmadya kukkuṭasya dvitīyavāraravaṇāt pūrvvaṁ tvaṁ vāratrayaṁ māmapahnōṣyasē| ");
INSERT INTO saniso_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","kintu sa gāḍhaṁ vyāharad yadyapi tvayā sārddhaṁ mama prāṇō yāti tathāpi kathamapi tvāṁ nāpahnōṣyē; sarvvē'pītarē tathaiva babhāṣirē| ");
INSERT INTO saniso_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","aparañca tēṣu gētśimānīnāmakaṁ sthāna gatēṣu sa śiṣyān jagāda, yāvadahaṁ prārthayē tāvadatra sthānē yūyaṁ samupaviśata| ");
INSERT INTO saniso_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","atha sa pitaraṁ yākūbaṁ yōhanañca gr̥hītvā vavrāja; atyantaṁ trāsitō vyākulitaśca tēbhyaḥ kathayāmāsa, ");
INSERT INTO saniso_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","nidhanakālavat prāṇō mē'tīva daḥkhamēti, yūyaṁ jāgratōtra sthānē tiṣṭhata| ");
INSERT INTO saniso_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","tataḥ sa kiñciddūraṁ gatvā bhūmāvadhōmukhaḥ patitvā prārthitavānētat, yadi bhavituṁ śakyaṁ tarhi duḥkhasamayōyaṁ mattō dūrībhavatu| ");
INSERT INTO saniso_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","aparamuditavān hē pita rhē pitaḥ sarvvēṁ tvayā sādhyaṁ, tatō hētōrimaṁ kaṁsaṁ mattō dūrīkuru, kintu tan mamēcchātō na tavēcchātō bhavatu| ");
INSERT INTO saniso_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","tataḥ paraṁ sa ētya tān nidritān nirīkṣya pitaraṁ prōvāca, śimōn tvaṁ kiṁ nidrāsi? ghaṭikāmēkām api jāgarituṁ na śaknōṣi? ");
INSERT INTO saniso_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","parīkṣāyāṁ yathā na patatha tadarthaṁ sacētanāḥ santaḥ prārthayadhvaṁ; mana udyuktamiti satyaṁ kintu vapuraśaktikaṁ| ");
INSERT INTO saniso_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","atha sa punarvrajitvā pūrvvavat prārthayāñcakrē| ");
INSERT INTO saniso_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","parāvr̥tyāgatya punarapi tān nidritān dadarśa tadā tēṣāṁ lōcanāni nidrayā pūrṇāni, tasmāttasmai kā kathā kathayitavyā ta ētad bōddhuṁ na śēkuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","tataḥparaṁ tr̥tīyavāraṁ āgatya tēbhyō 'kathayad idānīmapi śayitvā viśrāmyatha? yathēṣṭaṁ jātaṁ, samayaścōpasthitaḥ paśyata mānavatanayaḥ pāpilōkānāṁ pāṇiṣu samarpyatē| ");
INSERT INTO saniso_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","uttiṣṭhata, vayaṁ vrajāmō yō janō māṁ parapāṇiṣu samarpayiṣyatē paśyata sa samīpamāyātaḥ| ");
INSERT INTO saniso_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","imāṁ kathāṁ kathayati sa, ētarhidvādaśānāmēkō yihūdā nāmā śiṣyaḥ pradhānayājakānām upādhyāyānāṁ prācīnalōkānāñca sannidhēḥ khaṅgalaguḍadhāriṇō bahulōkān gr̥hītvā tasya samīpa upasthitavān| ");
INSERT INTO saniso_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","aparañcāsau parapāṇiṣu samarpayitā pūrvvamiti saṅkētaṁ kr̥tavān yamahaṁ cumbiṣyāmi sa ēvāsau tamēva dhr̥tvā sāvadhānaṁ nayata| ");
INSERT INTO saniso_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","atō hētōḥ sa āgatyaiva yōśōḥ savidhaṁ gatvā hē gurō hē gurō, ityuktvā taṁ cucumba| ");
INSERT INTO saniso_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","tadā tē tadupari pāṇīnarpayitvā taṁ dadhnuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","tatastasya pārśvasthānāṁ lōkānāmēkaḥ khaṅgaṁ niṣkōṣayan mahāyājakasya dāsamēkaṁ prahr̥tya tasya karṇaṁ cicchēda| ");
INSERT INTO saniso_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","paścād yīśustān vyājahāra khaṅgān laguḍāṁśca gr̥hītvā māṁ kiṁ cauraṁ dharttāṁ samāyātāḥ? ");
INSERT INTO saniso_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","madhyēmandiraṁ samupadiśan pratyahaṁ yuṣmābhiḥ saha sthitavānatahaṁ, tasmin kālē yūyaṁ māṁ nādīdharata, kintvanēna śāstrīyaṁ vacanaṁ sēdhanīyaṁ| ");
INSERT INTO saniso_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","tadā sarvvē śiṣyāstaṁ parityajya palāyāñcakrirē| ");
INSERT INTO saniso_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","athaikō yuvā mānavō nagnakāyē vastramēkaṁ nidhāya tasya paścād vrajan yuvalōkai rdhr̥tō ");
INSERT INTO saniso_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","vastraṁ vihāya nagnaḥ palāyāñcakrē| ");
INSERT INTO saniso_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","aparañca yasmin sthānē pradhānayājakā upādhyāyāḥ prācīnalōkāśca mahāyājakēna saha sadasi sthitāstasmin sthānē mahāyājakasya samīpaṁ yīśuṁ ninyuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","pitarō dūrē tatpaścād itvā mahāyājakasyāṭṭālikāṁ praviśya kiṅkaraiḥ sahōpaviśya vahnitāpaṁ jagrāha| ");
INSERT INTO saniso_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","tadānīṁ pradhānayājakā mantriṇaśca yīśuṁ ghātayituṁ tatprātikūlyēna sākṣiṇō mr̥gayāñcakrirē, kintu na prāptāḥ| ");
INSERT INTO saniso_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","anēkaistadviruddhaṁ mr̥ṣāsākṣyē dattēpi tēṣāṁ vākyāni na samagacchanta| ");
INSERT INTO saniso_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","sarvvaśēṣē kiyanta utthāya tasya prātikūlyēna mr̥ṣāsākṣyaṁ dattvā kathayāmāsuḥ, ");
INSERT INTO saniso_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","idaṁ karakr̥tamandiraṁ vināśya dinatrayamadhyē punaraparam akarakr̥taṁ mandiraṁ nirmmāsyāmi, iti vākyam asya mukhāt śrutamasmābhiriti| ");
INSERT INTO saniso_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","kintu tatrāpi tēṣāṁ sākṣyakathā na saṅgātāḥ| ");
INSERT INTO saniso_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","atha mahāyājakō madhyēsabham utthāya yīśuṁ vyājahāra, ētē janāstvayi yat sākṣyamaduḥ tvamētasya kimapyuttaraṁ kiṁ na dāsyasi? ");
INSERT INTO saniso_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","kintu sa kimapyuttaraṁ na datvā maunībhūya tasyau; tatō mahāyājakaḥ punarapi taṁ pr̥ṣṭāvān tvaṁ saccidānandasya tanayō 'bhiṣiktastratā? ");
INSERT INTO saniso_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","tadā yīśustaṁ prōvāca bhavāmyaham yūyañca sarvvaśaktimatō dakṣīṇapārśvē samupaviśantaṁ mēgha māruhya samāyāntañca manuṣyaputraṁ sandrakṣyatha| ");
INSERT INTO saniso_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","tadā mahāyājakaḥ svaṁ vamanaṁ chitvā vyāvaharat ");
INSERT INTO saniso_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","kimasmākaṁ sākṣibhiḥ prayōjanam? īśvaranindāvākyaṁ yuṣmābhiraśrāvi kiṁ vicārayatha? tadānīṁ sarvvē jagadurayaṁ nidhanadaṇḍamarhati| ");
INSERT INTO saniso_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","tataḥ kaścit kaścit tadvapuṣi niṣṭhīvaṁ nicikṣēpa tathā tanmukhamācchādya capēṭēna hatvā gaditavān gaṇayitvā vada, anucarāśca capēṭaistamājaghnuḥ ");
INSERT INTO saniso_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","tataḥ paraṁ pitarē'ṭṭālikādhaḥkōṣṭhē tiṣṭhati mahāyājakasyaikā dāsī samētya ");
INSERT INTO saniso_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","taṁ vihnitāpaṁ gr̥hlantaṁ vilōkya taṁ sunirīkṣya babhāṣē tvamapi nāsaratīyayīśōḥ saṅginām ēkō jana āsīḥ| ");
INSERT INTO saniso_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","kintu sōpahnutya jagāda tamahaṁ na vadmi tvaṁ yat kathayami tadapyahaṁ na buddhyē| tadānīṁ pitarē catvaraṁ gatavati kuेkkuṭō rurāva| ");
INSERT INTO saniso_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","athānyā dāsī pitaraṁ dr̥ṣṭvā samīpasthān janān jagāda ayaṁ tēṣāmēkō janaḥ| ");
INSERT INTO saniso_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","tataḥ sa dvitīyavāram apahnutavān paścāt tatrasthā lōkāḥ pitaraṁ prōcustvamavaśyaṁ tēṣāmēkō janaḥ yatastvaṁ gālīlīyō nara iti tavōccāraṇaṁ prakāśayati| ");
INSERT INTO saniso_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","tadā sa śapathābhiśāpau kr̥tvā prōvāca yūyaṁ kathāṁ kathayatha taṁ naraṁ na jānē'haṁ| ");
INSERT INTO saniso_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","tadānīṁ dvitīyavāraṁ kukkuṭō 'rāvīt| kukkuṭasya dvitīyaravāt pūrvvaṁ tvaṁ māṁ vāratrayam apahnōṣyasi, iti yadvākyaṁ yīśunā samuditaṁ tat tadā saṁsmr̥tya pitarō rōditum ārabhata| ");
INSERT INTO saniso_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","atha prabhātē sati pradhānayājakāḥ prāñca upādhyāyāḥ sarvvē mantriṇaśca sabhāṁ kr̥tvā yīśuृṁ bandhayitva pīlātākhyasya dēśādhipatēḥ savidhaṁ nītvā samarpayāmāsuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","tadā pīlātastaṁ pr̥ṣṭavān tvaṁ kiṁ yihūdīyalōkānāṁ rājā? tataḥ sa pratyuktavān satyaṁ vadasi| ");
INSERT INTO saniso_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","aparaṁ pradhānayājakāstasya bahuṣu vākyēṣu dōṣamārōpayāñcakruḥ kintu sa kimapi na pratyuvāca| ");
INSERT INTO saniso_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","tadānīṁ pīlātastaṁ punaḥ papraccha tvaṁ kiṁ nōttarayasi? paśyaitē tvadviruddhaṁ katiṣu sādhyēṣu sākṣaṁ dadati| ");
INSERT INTO saniso_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","kantu yīśustadāpi nōttaraṁ dadau tataḥ pīlāta āścaryyaṁ jagāma| ");
INSERT INTO saniso_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","aparañca kārābaddhē kastiṁścit janē tanmahōtsavakālē lōkai ryācitē dēśādhipatistaṁ mōcayati| ");
INSERT INTO saniso_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","yē ca pūrvvamupaplavamakārṣurupaplavē vadhamapi kr̥tavantastēṣāṁ madhyē tadānōṁ barabbānāmaka ēkō baddha āsīt| ");
INSERT INTO saniso_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","atō hētōḥ pūrvvāparīyāṁ rītikathāṁ kathayitvā lōkā uccairuvantaḥ pīlātasya samakṣaṁ nivēdayāmāsuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","tadā pīlātastānācakhyau tarhi kiṁ yihūdīyānāṁ rājānaṁ mōcayiṣyāmi? yuṣmābhiḥ kimiṣyatē? ");
INSERT INTO saniso_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","yataḥ pradhānayājakā īrṣyāta ēva yīśuṁ samārpayanniti sa vivēda| ");
INSERT INTO saniso_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","kintu yathā barabbāṁ mōcayati tathā prārthayituṁ pradhānayājakā lōkān pravarttayāmāsuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","atha pīlātaḥ punaḥ pr̥ṣṭavān tarhi yaṁ yihūdīyānāṁ rājēti vadatha tasya kiṁ kariṣyāmi yuṣmābhiḥ kimiṣyatē? ");
INSERT INTO saniso_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","tadā tē punarapi prōccaiḥ prōcustaṁ kruśē vēdhaya| ");
INSERT INTO saniso_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","tasmāt pīlātaḥ kathitavān kutaḥ? sa kiṁ kukarmma kr̥tavān? kintu tē punaśca ruvantō vyājahrustaṁ kruśē vēdhaya| ");
INSERT INTO saniso_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","tadā pīlātaḥ sarvvāllōkān tōṣayitumicchan barabbāṁ mōcayitvā yīśuṁ kaśābhiḥ prahr̥tya kruśē vēddhuṁ taṁ samarpayāmbabhūva| ");
INSERT INTO saniso_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","anantaraṁ sainyagaṇō'ṭṭālikām arthād adhipatē rgr̥haṁ yīśuṁ nītvā sēnānivahaṁ samāhuyat| ");
INSERT INTO saniso_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","paścāt tē taṁ dhūmalavarṇavastraṁ paridhāpya kaṇṭakamukuṭaṁ racayitvā śirasi samārōpya ");
INSERT INTO saniso_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","hē yihūdīyānāṁ rājan namaskāra ityuktvā taṁ namaskarttāmārēbhirē| ");
INSERT INTO saniso_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","tasyōttamāṅgē vētrāghātaṁ cakrustadgātrē niṣṭhīvañca nicikṣipuḥ, tathā tasya sammukhē jānupātaṁ praṇōmuḥ ");
INSERT INTO saniso_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","itthamupahasya dhūmravarṇavastram uttāryya tasya vastraṁ taṁ paryyadhāpayan kruśē vēddhuṁ bahirninyuśca| ");
INSERT INTO saniso_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","tataḥ paraṁ sēkandarasya ruphasya ca pitā śimōnnāmā kurīṇīyalōka ēkaḥ kutaścid grāmādētya pathi yāti taṁ tē yīśōḥ kruśaṁ vōḍhuṁ balād dadhnuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","atha gulgaltā arthāt śiraḥkapālanāmakaṁ sthānaṁ yīśumānīya ");
INSERT INTO saniso_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","tē gandharasamiśritaṁ drākṣārasaṁ pātuṁ tasmai daduḥ kintu sa na jagrāha| ");
INSERT INTO saniso_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","tasmin kruśē viddhē sati tēṣāmēkaikaśaḥ kiṁ prāpsyatīti nirṇayāya ");
INSERT INTO saniso_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","tasya paridhēyānāṁ vibhāgārthaṁ guṭikāpātaṁ cakruḥ| ");
INSERT INTO saniso_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","aparam ēṣa yihūdīyānāṁ rājēti likhitaṁ dōṣapatraṁ tasya śiraūrdvvam ārōpayāñcakruḥ| ");
INSERT INTO saniso_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","tasya vāmadakṣiṇayō rdvau caurau kruśayō rvividhātē| ");
INSERT INTO saniso_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","tēnaiva \"aparādhijanaiḥ sārddhaṁ sa gaṇitō bhaviṣyati,\" iti śāstrōktaṁ vacanaṁ siddhamabhūta| ");
INSERT INTO saniso_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","anantaraṁ mārgē yē yē lōkā gamanāgamanē cakrustē sarvva ēva śirāṁsyāndōlya nindantō jagaduḥ, rē mandiranāśaka rē dinatrayamadhyē tannirmmāyaka, ");
INSERT INTO saniso_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","adhunātmānam avitvā kruśādavarōha| ");
INSERT INTO saniso_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","kiñca pradhānayājakā adhyāpakāśca tadvat tiraskr̥tya parasparaṁ cacakṣirē ēṣa parānāvat kintu svamavituṁ na śaknōti| ");
INSERT INTO saniso_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","yadīsrāyēlō rājābhiṣiktastrātā bhavati tarhyadhunaina kruśādavarōhatu vayaṁ tad dr̥ṣṭvā viśvasiṣyāmaḥ; kiñca yau lōkau tēna sārddhaṁ kruśē 'vidhyētāṁ tāvapi taṁ nirbhartsayāmāsatuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","atha dvitīyayāmāt tr̥tīyayāmaṁ yāvat sarvvō dēśaḥ sāndhakārōbhūt| ");
INSERT INTO saniso_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","tatastr̥tīyapraharē yīśuruccairavadat ēlī ēlī lāmā śivaktanī arthād \"hē madīśa madīśa tvaṁ paryyatyākṣīḥ kutō hi māṁ?\" ");
INSERT INTO saniso_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","tadā samīpasthalōkānāṁ kēcit tadvākyaṁ niśamyācakhyuḥ paśyaiṣa ēliyam āhūyati| ");
INSERT INTO saniso_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","tata ēkō janō dhāvitvāgatya spañjē 'mlarasaṁ pūrayitvā taṁ naḍāgrē nidhāya pātuṁ tasmai dattvāvadat tiṣṭha ēliya ēnamavarōhayitum ēti na vēti paśyāmi| ");
INSERT INTO saniso_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","atha yīśuruccaiḥ samāhūya prāṇān jahau| ");
INSERT INTO saniso_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","tadā mandirasya javanikōrdvvādadhaḥryyantā vidīrṇā dvikhaṇḍābhūt| ");
INSERT INTO saniso_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","kiñca itthamuccairāhūya prāṇān tyajantaṁ taṁ dr̥ṣdvā tadrakṣaṇāya niyuktō yaḥ sēnāpatirāsīt sōvadat narōyam īśvaraputra iti satyam| ");
INSERT INTO saniso_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","tadānīṁ magdalīnī marisam kaniṣṭhayākūbō yōsēśca mātānyamariyam śālōmī ca yāḥ striyō ");
INSERT INTO saniso_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","gālīlpradēśē yīśuṁ sēvitvā tadanugāminyō jātā imāstadanyāśca yā anēkā nāryō yīśunā sārddhaṁ yirūśālamamāyātāstāśca dūrāt tāni dadr̥śuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","athāsādanadinasyārthād viśrāmavārāt pūrvvadinasya sāyaṁkāla āgata ");
INSERT INTO saniso_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","īśvararājyāpēkṣyarimathīyayūṣaphanāmā mānyamantrī samētya pīlātasavidhaṁ nirbhayō gatvā yīśōrdēhaṁ yayācē| ");
INSERT INTO saniso_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","kintu sa idānīṁ mr̥taḥ pīlāta ityasambhavaṁ matvā śatasēnāpatimāhūya sa kadā mr̥ta iti papraccha| ");
INSERT INTO saniso_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","śatasēmanāpatimukhāt tajjñātvā yūṣaphē yīśōrdēhaṁ dadau| ");
INSERT INTO saniso_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","paścāt sa sūkṣmaṁ vāsaḥ krītvā yīśōḥ kāyamavarōhya tēna vāsasā vēṣṭāyitvā girau khātaśmaśānē sthāpitavān pāṣāṇaṁ lōṭhayitvā dvāri nidadhē| ");
INSERT INTO saniso_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","kintu yatra sōsthāpyata tata magdalīnī mariyam yōsimātr̥mariyam ca dadr̥śatr̥ḥ| ");
INSERT INTO saniso_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","atha viśrāmavārē gatē magdalīnī mariyam yākūbamātā mariyam śālōmī cēmāstaṁ marddayituṁ sugandhidravyāṇi krītvā ");
INSERT INTO saniso_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","saptāhaprathamadinē'tipratyūṣē sūryyōdayakālē śmaśānamupagatāḥ| ");
INSERT INTO saniso_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","kintu śmaśānadvārapāṣāṇō'tibr̥han taṁ kō'pasārayiṣyatīti tāḥ parasparaṁ gadanti! ");
INSERT INTO saniso_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ētarhi nirīkṣya pāṣāṇō dvārō 'pasārita iti dadr̥śuḥ| ");
INSERT INTO saniso_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","paścāttāḥ śmaśānaṁ praviśya śuklavarṇadīrghaparicchadāvr̥tamēkaṁ yuvānaṁ śmaśānadakṣiṇapārśva upaviṣṭaṁ dr̥ṣṭvā camaccakruḥ| ");
INSERT INTO saniso_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","sō'vadat, mābhaiṣṭa yūyaṁ kruśē hataṁ nāsaratīyayīśuṁ gavēṣayatha sōtra nāsti śmaśānādudasthāt; tai ryatra sa sthāpitaḥ sthānaṁ tadidaṁ paśyata| ");
INSERT INTO saniso_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","kintu tēna yathōktaṁ tathā yuṣmākamagrē gālīlaṁ yāsyatē tatra sa yuṣmān sākṣāt kariṣyatē yūyaṁ gatvā tasya śiṣyēbhyaḥ pitarāya ca vārttāmimāṁ kathayata| ");
INSERT INTO saniso_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","tāḥ kampitā vistitāśca tūrṇaṁ śmaśānād bahirgatvā palāyanta bhayāt kamapi kimapi nāvadaṁśca| ");
INSERT INTO saniso_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","aparaṁ yīśuḥ saptāhaprathamadinē pratyūṣē śmaśānādutthāya yasyāḥ saptabhūtāstyājitāstasyai magdalīnīmariyamē prathamaṁ darśanaṁ dadau| ");
INSERT INTO saniso_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","tataḥ sā gatvā śōkarōdanakr̥dbhyō'nugatalōkēbhyastāṁ vārttāṁ kathayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","kintu yīśuḥ punarjīvan tasyai darśanaṁ dattavāniti śrutvā tē na pratyayan| ");
INSERT INTO saniso_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","paścāt tēṣāṁ dvāyō rgrāmayānakālē yīśuranyavēśaṁ dhr̥tvā tābhyāṁ darśana dadau! ");
INSERT INTO saniso_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","tāvapi gatvānyaśiṣyēbhyastāṁ kathāṁ kathayāñcakratuḥ kintu tayōḥ kathāmapi tē na pratyayan| ");
INSERT INTO saniso_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","śēṣata ēkādaśaśiṣyēṣu bhōjanōpaviṣṭēṣu yīśustēbhyō darśanaṁ dadau tathōtthānāt paraṁ taddarśanaprāptalōkānāṁ kathāyāmaviśvāsakaraṇāt tēṣāmaviśvāsamanaḥkāṭhinyābhyāṁ hētubhyāṁ sa tāṁstarjitavān| ");
INSERT INTO saniso_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","atha tānācakhyau yūyaṁ sarvvajagad gatvā sarvvajanān prati susaṁvādaṁ pracārayata| ");
INSERT INTO saniso_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","tatra yaḥ kaścid viśvasya majjitō bhavēt sa paritrāsyatē kintu yō na viśvasiṣyati sa daṇḍayiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","kiñca yē pratyēṣyanti tairīdr̥g āścaryyaṁ karmma prakāśayiṣyatē tē mannāmnā bhūtān tyājayiṣyanti bhāṣā anyāśca vadiṣyanti| ");
INSERT INTO saniso_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","aparaṁ taiḥ sarpēṣu dhr̥tēṣu prāṇanāśakavastuni pītē ca tēṣāṁ kāpi kṣati rna bhaviṣyati; rōgiṇāṁ gātrēṣu karārpitē tē'rōgā bhaviṣyanti ca| ");
INSERT INTO saniso_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","atha prabhustānityādiśya svargaṁ nītaḥ san paramēśvarasya dakṣiṇa upavivēśa| ");
INSERT INTO saniso_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","tatastē prasthāya sarvvatra susaṁvādīyakathāṁ pracārayitumārēbhirē prabhustu tēṣāṁ sahāyaḥ san prakāśitāścaryyakriyābhistāṁ kathāṁ pramāṇavatīṁ cakāra| iti|");
INSERT INTO saniso_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","prathamatō yē sākṣiṇō vākyapracārakāścāsan tē'smākaṁ madhyē yadyat sapramāṇaṁ vākyamarpayanti sma ");
INSERT INTO saniso_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","tadanusāratō'nyēpi bahavastadvr̥ttāntaṁ racayituṁ pravr̥ttāḥ| ");
INSERT INTO saniso_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ataēva hē mahāmahimathiyaphil tvaṁ yā yāḥ kathā aśikṣyathāstāsāṁ dr̥ḍhapramāṇāni yathā prāpnōṣi ");
INSERT INTO saniso_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","tadarthaṁ prathamamārabhya tāni sarvvāṇi jñātvāhamapi anukramāt sarvvavr̥ttāntān tubhyaṁ lēkhituṁ matimakārṣam| ");
INSERT INTO saniso_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","yihūdādēśīyahērōdnāmakē rājatvaṁ kurvvati abīyayājakasya paryyāyādhikārī sikhariyanāmaka ēkō yājakō hārōṇavaṁśōdbhavā ilīśēvākhyā ");
INSERT INTO saniso_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","tasya jāyā dvāvimau nirdōṣau prabhōḥ sarvvājñā vyavasthāśca saṁmanya īśvaradr̥ṣṭau dhārmmikāvāstām| ");
INSERT INTO saniso_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","tayōḥ santāna ēkōpi nāsīt, yata ilīśēvā bandhyā tau dvāvēva vr̥ddhāvabhavatām| ");
INSERT INTO saniso_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","yadā svaparyyānukramēṇa sikhariya īśvāsya samakṣaṁ yājakīyaṁ karmma karōti ");
INSERT INTO saniso_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","tadā yajñasya dinaparipāyyā paramēśvarasya mandirē pravēśakālē dhūpajvālanaṁ karmma tasya karaṇīyamāsīt| ");
INSERT INTO saniso_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","taddhūpajvālanakālē lōkanivahē prārthanāṁ kartuṁ bahistiṣṭhati ");
INSERT INTO saniso_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","sati sikhariyō yasyāṁ vēdyāṁ dhūpaṁ jvālayati taddakṣiṇapārśvē paramēśvarasya dūta ēka upasthitō darśanaṁ dadau| ");
INSERT INTO saniso_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","taṁ dr̥ṣṭvā sikhariya udvivijē śaśaṅkē ca| ");
INSERT INTO saniso_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","tadā sa dūtastaṁ babhāṣē hē sikhariya mā bhaistava prārthanā grāhyā jātā tava bhāryyā ilīśēvā putraṁ prasōṣyatē tasya nāma yōेhan iti kariṣyasi| ");
INSERT INTO saniso_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","kiñca tvaṁ sānandaḥ saharṣaśca bhaviṣyasi tasya janmani bahava ānandiṣyanti ca| ");
INSERT INTO saniso_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","yatō hētōḥ sa paramēśvarasya gōcarē mahān bhaviṣyati tathā drākṣārasaṁ surāṁ vā kimapi na pāsyati, aparaṁ janmārabhya pavitrēṇātmanā paripūrṇaḥ ");
INSERT INTO saniso_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","san isrāyēlvaṁśīyān anēkān prabhōḥ paramēśvarasya mārgamānēṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","santānān prati pitr̥ṇāṁ manāṁsi dharmmajñānaṁ pratyanājñāgrāhiṇaśca parāvarttayituṁ, prabhōḥ paramēśvarasya sēvārtham ēkāṁ sajjitajātiṁ vidhātuñca sa ēliyarūpātmaśaktiprāptastasyāgrē gamiṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","tadā sikhariyō dūtamavādīt kathamētad vētsyāmi? yatōhaṁ vr̥ddhō mama bhāryyā ca vr̥ddhā| ");
INSERT INTO saniso_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","tatō dūtaḥ pratyuvāca paśyēśvarasya sākṣādvarttī jibrāyēlnāmā dūtōhaṁ tvayā saha kathāṁ gadituṁ tubhyamimāṁ śubhavārttāṁ dātuñca prēṣitaḥ| ");
INSERT INTO saniso_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","kintu madīyaṁ vākyaṁ kālē phaliṣyati tat tvayā na pratītam ataḥ kāraṇād yāvadēva tāni na sētsyanti tāvat tvaṁ vaktuṁmaśaktō mūkō bhava| ");
INSERT INTO saniso_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","tadānīṁ yē yē lōkāḥ sikhariyamapaikṣanta tē madhyēmandiraṁ tasya bahuvilambād āścaryyaṁ mēnirē| ");
INSERT INTO saniso_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","sa bahirāgatō yadā kimapi vākyaṁ vaktumaśaktaḥ saṅkētaṁ kr̥tvā niḥśabdastasyau tadā madhyēmandiraṁ kasyacid darśanaṁ tēna prāptam iti sarvvē bubudhirē| ");
INSERT INTO saniso_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","anantaraṁ tasya sēvanaparyyāyē sampūrṇē sati sa nijagēhaṁ jagāma| ");
INSERT INTO saniso_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","katipayadinēṣu gatēṣu tasya bhāryyā ilīśēvā garbbhavatī babhūva ");
INSERT INTO saniso_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","paścāt sā pañcamāsān saṁgōpyākathayat lōkānāṁ samakṣaṁ mamāpamānaṁ khaṇḍayituṁ paramēśvarō mayi dr̥ṣṭiṁ pātayitvā karmmēdr̥śaṁ kr̥tavān| ");
INSERT INTO saniso_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","aparañca tasyā garbbhasya ṣaṣṭhē māsē jātē gālīlpradēśīyanāsaratpurē ");
INSERT INTO saniso_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","dāyūdō vaṁśīyāya yūṣaphnāmnē puruṣāya yā mariyamnāmakumārī vāgdattāsīt tasyāḥ samīpaṁ jibrāyēl dūta īśvarēṇa prahitaḥ| ");
INSERT INTO saniso_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","sa gatvā jagāda hē īśvarānugr̥hītakanyē tava śubhaṁ bhūyāt prabhuḥ paramēśvarastava sahāyōsti nārīṇāṁ madhyē tvamēva dhanyā| ");
INSERT INTO saniso_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","tadānīṁ sā taṁ dr̥ṣṭvā tasya vākyata udvijya kīdr̥śaṁ bhāṣaṇamidam iti manasā cintayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","tatō dūtō'vadat hē mariyam bhayaṁ mākārṣīḥ, tvayi paramēśvarasyānugrahōsti| ");
INSERT INTO saniso_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","paśya tvaṁ garbbhaṁ dhr̥tvā putraṁ prasōṣyasē tasya nāma yīśuriti kariṣyasi| ");
INSERT INTO saniso_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","sa mahān bhaviṣyati tathā sarvvēbhyaḥ śrēṣṭhasya putra iti khyāsyati; aparaṁ prabhuḥ paramēśvarastasya piturdāyūdaḥ siṁhāsanaṁ tasmai dāsyati; ");
INSERT INTO saniso_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","tathā sa yākūbō vaṁśōpari sarvvadā rājatvaṁ kariṣyati, tasya rājatvasyāntō na bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","tadā mariyam taṁ dūtaṁ babhāṣē nāhaṁ puruṣasaṅgaṁ karōmi tarhi kathamētat sambhaviṣyati? ");
INSERT INTO saniso_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","tatō dūtō'kathayat pavitra ātmā tvāmāśrāyiṣyati tathā sarvvaśrēṣṭhasya śaktistavōpari chāyāṁ kariṣyati tatō hētōstava garbbhād yaḥ pavitrabālakō janiṣyatē sa īśvaraputra iti khyātiṁ prāpsyati| ");
INSERT INTO saniso_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","aparañca paśya tava jñātirilīśēvā yāṁ sarvvē bandhyāmavadan idānīṁ sā vārddhakyē santānamēkaṁ garbbhē'dhārayat tasya ṣaṣṭhamāsōbhūt| ");
INSERT INTO saniso_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","kimapi karmma nāsādhyam īśvarasya| ");
INSERT INTO saniso_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","tadā mariyam jagāda, paśya prabhērahaṁ dāsī mahyaṁ tava vākyānusārēṇa sarvvamētad ghaṭatām; ananataraṁ dūtastasyāḥ samīpāt pratasthē| ");
INSERT INTO saniso_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","atha katipayadināt paraṁ mariyam tasmāt parvvatamayapradēśīyayihūdāyā nagaramēkaṁ śīghraṁ gatvā ");
INSERT INTO saniso_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","sikhariyayājakasya gr̥haṁ praviśya tasya jāyām ilīśēvāṁ sambōdhyāvadat| ");
INSERT INTO saniso_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","tatō mariyamaḥ sambōdhanavākyē ilīśēvāyāḥ karṇayōḥ praviṣṭamātrē sati tasyā garbbhasthabālakō nanartta| tata ilīśēvā pavitrēṇātmanā paripūrṇā satī ");
INSERT INTO saniso_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","prōccairgaditumārēbhē, yōṣitāṁ madhyē tvamēva dhanyā, tava garbbhasthaḥ śiśuśca dhanyaḥ| ");
INSERT INTO saniso_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","tvaṁ prabhōrmātā, mama nivēśanē tvayā caraṇāvarpitau, mamādya saubhāgyamētat| ");
INSERT INTO saniso_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","paśya tava vākyē mama karṇayōḥ praviṣṭamātrē sati mamōdarasthaḥ śiśurānandān nanartta| ");
INSERT INTO saniso_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","yā strī vyaśvasīt sā dhanyā, yatō hētōstāṁ prati paramēśvarōktaṁ vākyaṁ sarvvaṁ siddhaṁ bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","tadānīṁ mariyam jagāda| dhanyavādaṁ parēśasya karōti māmakaṁ manaḥ| ");
INSERT INTO saniso_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","mamātmā tārakēśē ca samullāsaṁ pragacchati| ");
INSERT INTO saniso_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","akarōt sa prabhu rduṣṭiṁ svadāsyā durgatiṁ prati| paśyādyārabhya māṁ dhanyāṁ vakṣyanti puruṣāḥ sadā| ");
INSERT INTO saniso_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","yaḥ sarvvaśaktimān yasya nāmāpi ca pavitrakaṁ| sa ēva sumahatkarmma kr̥tavān mannimittakaṁ| ");
INSERT INTO saniso_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","yē bibhyati janāstasmāt tēṣāṁ santānapaṁktiṣu| anukampā tadīyā ca sarvvadaiva sutiṣṭhati| ");
INSERT INTO saniso_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","svabāhubalatastēna prākāśyata parākramaḥ| manaḥkumantraṇāsārddhaṁ vikīryyantē'bhimāninaḥ| ");
INSERT INTO saniso_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","siṁhāsanagatāllōkān balinaścāvarōhya saḥ| padēṣūccēṣu lōkāṁstu kṣudrān saṁsthāpayatyapi| ");
INSERT INTO saniso_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","kṣudhitān mānavān dravyairuttamaiḥ paritarpya saḥ| sakalān dhaninō lōkān visr̥jēd riktahastakān| ");
INSERT INTO saniso_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ibrāhīmi ca tadvaṁśē yā dayāsti sadaiva tāṁ| smr̥tvā purā pitr̥ṇāṁ nō yathā sākṣāt pratiśrutaṁ| ");
INSERT INTO saniso_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","isrāyēlsēvakastēna tathōpakriyatē svayaṁ|| ");
INSERT INTO saniso_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","anantaraṁ mariyam prāyēṇa māsatrayam ilīśēvayā sahōṣitvā vyāghuyya nijanivēśanaṁ yayau| ");
INSERT INTO saniso_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","tadanantaram ilīśēvāyāḥ prasavakāla upasthitē sati sā putraṁ prāsōṣṭa| ");
INSERT INTO saniso_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","tataḥ paramēśvarastasyāṁ mahānugrahaṁ kr̥tavān ētat śrutvā samīpavāsinaḥ kuṭumbāścāgatya tayā saha mumudirē| ");
INSERT INTO saniso_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","tathāṣṭamē dinē tē bālakasya tvacaṁ chēttum ētya tasya pitr̥nāmānurūpaṁ tannāma sikhariya iti karttumīṣuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","kintu tasya mātākathayat tanna, nāmāsya yōhan iti karttavyam| ");
INSERT INTO saniso_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","tadā tē vyāharan tava vaṁśamadhyē nāmēdr̥śaṁ kasyāpi nāsti| ");
INSERT INTO saniso_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","tataḥ paraṁ tasya pitaraṁ sikhariyaṁ prati saṅkētya papracchuḥ śiśōḥ kiṁ nāma kāriṣyatē? ");
INSERT INTO saniso_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","tataḥ sa phalakamēkaṁ yācitvā lilēkha tasya nāma yōhan bhaviṣyati| tasmāt sarvvē āścaryyaṁ mēnirē| ");
INSERT INTO saniso_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","tatkṣaṇaṁ sikhariyasya jihvājāḍyē'pagatē sa mukhaṁ vyādāya spaṣṭavarṇamuccāryya īśvarasya guṇānuvādaṁ cakāra| ");
INSERT INTO saniso_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","tasmāccaturdiksthāḥ samīpavāsilōkā bhītā ēvamētāḥ sarvvāḥ kathā yihūdāyāḥ parvvatamayapradēśasya sarvvatra pracāritāḥ| ");
INSERT INTO saniso_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","tasmāt śrōtārō manaḥsu sthāpayitvā kathayāmbabhūvuḥ kīdr̥śōyaṁ bālō bhaviṣyati? atha paramēśvarastasya sahāyōbhūt| ");
INSERT INTO saniso_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","tadā yōhanaḥ pitā sikhariyaḥ pavitrēṇātmanā paripūrṇaḥ san ētādr̥śaṁ bhaviṣyadvākyaṁ kathayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","isrāyēlaḥ prabhu ryastu sa dhanyaḥ paramēśvaraḥ| anugr̥hya nijāllōkān sa ēva parimōcayēt| ");
INSERT INTO saniso_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","vipakṣajanahastēbhyō yathā mōcyāmahē vayaṁ| yāvajjīvañca dharmmēṇa sāralyēna ca nirbhayāḥ| ");
INSERT INTO saniso_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","sēvāmahai tamēvaikam ētatkāraṇamēva ca| svakīyaṁ supavitrañca saṁsmr̥tya niyamaṁ sadā| ");
INSERT INTO saniso_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","kr̥payā puruṣān pūrvvān nikaṣārthāttu naḥ pituḥ| ibrāhīmaḥ samīpē yaṁ śapathaṁ kr̥tavān purā| ");
INSERT INTO saniso_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","tamēva saphalaṁ karttaṁ tathā śatrugaṇasya ca| r̥ृtīyākāriṇaścaiva karēbhyō rakṣaṇāya naḥ| ");
INSERT INTO saniso_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","sr̥ṣṭēḥ prathamataḥ svīyaiḥ pavitrai rbhāvivādibhiḥ| ");
INSERT INTO saniso_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","yathōktavān tathā svasya dāyūdaḥ sēvakasya tu| ");
INSERT INTO saniso_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","vaṁśē trātāramēkaṁ sa samutpāditavān svayam| ");
INSERT INTO saniso_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","atō hē bālaka tvantu sarvvēbhyaḥ śrēṣṭha ēva yaḥ| tasyaiva bhāvivādīti pravikhyātō bhaviṣyasi| asmākaṁ caraṇān kṣēmē mārgē cālayituṁ sadā| ēvaṁ dhvāntē'rthatō mr̥tyōśchāyāyāṁ yē tu mānavāḥ| ");
INSERT INTO saniso_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","upaviṣṭāstu tānēva prakāśayitumēva hi| kr̥tvā mahānukampāṁ hi yāmēva paramēśvaraḥ| ");
INSERT INTO saniso_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ūrdvvāt sūryyamudāyyaivāsmabhyaṁ prādāttu darśanaṁ| tayānukampayā svasya lōkānāṁ pāpamōcanē| ");
INSERT INTO saniso_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","paritrāṇasya tēbhyō hi jñānaviśrāṇanāya ca| prabhō rmārgaṁ pariṣkarttuṁ tasyāgrāyī bhaviṣyasi|| ");
INSERT INTO saniso_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","atha bālakaḥ śarīrēṇa buddhyā ca varddhitumārēbhē; aparañca sa isrāyēlō vaṁśīyalōkānāṁ samīpē yāvanna prakaṭībhūtastāstāvat prāntarē nyavasat| ");
INSERT INTO saniso_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","aparañca tasmin kālē rājyasya sarvvēṣāṁ lōkānāṁ nāmāni lēkhayitum agastakaisara ājñāpayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","tadanusārēṇa kurīṇiyanāmani suriyādēśasya śāsakē sati nāmalēkhanaṁ prārēbhē| ");
INSERT INTO saniso_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","atō hētō rnāma lēkhituṁ sarvvē janāḥ svīyaṁ svīyaṁ nagaraṁ jagmuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","tadānīṁ yūṣaph nāma lēkhituṁ vāgdattayā svabhāryyayā garbbhavatyā mariyamā saha svayaṁ dāyūdaḥ sajātivaṁśa iti kāraṇād gālīlpradēśasya nāsaratnagarād ");
INSERT INTO saniso_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","yihūdāpradēśasya baitlēhamākhyaṁ dāyūdnagaraṁ jagāma| ");
INSERT INTO saniso_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","anyacca tatra sthānē tayōstiṣṭhatōḥ satō rmariyamaḥ prasūtikāla upasthitē ");
INSERT INTO saniso_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","sā taṁ prathamasutaṁ prāsōṣṭa kintu tasmin vāsagr̥hē sthānābhāvād bālakaṁ vastrēṇa vēṣṭayitvā gōśālāyāṁ sthāpayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","anantaraṁ yē kiyantō mēṣapālakāḥ svamēṣavrajarakṣāyai tatpradēśē sthitvā rajanyāṁ prāntarē prahariṇaḥ karmma kurvvanti, ");
INSERT INTO saniso_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","tēṣāṁ samīpaṁ paramēśvarasya dūta āgatyōpatasthau; tadā catuṣpārśvē paramēśvarasya tējasaḥ prakāśitatvāt tē'tiśaśaṅkirē| ");
INSERT INTO saniso_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","tadā sa dūta uvāca mā bhaiṣṭa paśyatādya dāyūdaḥ purē yuṣmannimittaṁ trātā prabhuḥ khrīṣṭō'janiṣṭa, ");
INSERT INTO saniso_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","sarvvēṣāṁ lōkānāṁ mahānandajanakam imaṁ maṅgalavr̥ttāntaṁ yuṣmān jñāpayāmi| ");
INSERT INTO saniso_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","yūyaṁ (tatsthānaṁ gatvā) vastravēṣṭitaṁ taṁ bālakaṁ gōśālāyāṁ śayanaṁ drakṣyatha yuṣmān pratīdaṁ cihnaṁ bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","dūta imāṁ kathāṁ kathitavati tatrākasmāt svargīyāḥ pr̥tanā āgatya kathām imāṁ kathayitvēśvarasya guṇānanvavādiṣuḥ, yathā, ");
INSERT INTO saniso_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","sarvvōrdvvasthairīśvarasya mahimā samprakāśyatāṁ| śāntirbhūyāt pr̥thivyāstu santōṣaśca narān prati|| ");
INSERT INTO saniso_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","tataḥ paraṁ tēṣāṁ sannidhē rdūtagaṇē svargaṁ gatē mēṣapālakāḥ parasparam avēcan āgacchata prabhuḥ paramēśvarō yāṁ ghaṭanāṁ jñāpitavān tasyā yātharyaṁ jñātuṁ vayamadhunā baitlēhampuraṁ yāmaḥ| ");
INSERT INTO saniso_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","paścāt tē tūrṇaṁ vrajitvā mariyamaṁ yūṣaphaṁ gōśālāyāṁ śayanaṁ bālakañca dadr̥śuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","itthaṁ dr̥ṣṭvā bālakasyārthē prōktāṁ sarvvakathāṁ tē prācārayāñcakruḥ| ");
INSERT INTO saniso_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","tatō yē lōkā mēṣarakṣakāṇāṁ vadanēbhyastāṁ vārttāṁ śuśruvustē mahāścaryyaṁ mēnirē| ");
INSERT INTO saniso_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","kintu mariyam ētatsarvvaghaṭanānāṁ tātparyyaṁ vivicya manasi sthāpayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","tatpaścād dūtavijñaptānurūpaṁ śrutvā dr̥ṣṭvā ca mēṣapālakā īśvarasya guṇānuvādaṁ dhanyavādañca kurvvāṇāḥ parāvr̥tya yayuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","atha bālakasya tvakchēdanakālē'ṣṭamadivasē samupasthitē tasya garbbhasthitēḥ purvvaṁ svargīyadūtō yathājñāpayat tadanurūpaṁ tē tannāmadhēyaṁ yīśuriti cakrirē| ");
INSERT INTO saniso_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","tataḥ paraṁ mūsālikhitavyavasthāyā anusārēṇa mariyamaḥ śucitvakāla upasthitē, ");
INSERT INTO saniso_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","\"prathamajaḥ sarvvaḥ puruṣasantānaḥ paramēśvarē samarpyatāṁ,\" iti paramēśvarasya vyavasthayā ");
INSERT INTO saniso_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","yīśuṁ paramēśvarē samarpayitum śāstrīyavidhyuktaṁ kapōtadvayaṁ pārāvataśāvakadvayaṁ vā baliṁ dātuṁ tē taṁ gr̥hītvā yirūśālamam āyayuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","yirūśālampuranivāsī śimiyōnnāmā dhārmmika ēka āsīt sa isrāyēlaḥ sāntvanāmapēkṣya tasthau kiñca pavitra ātmā tasminnāvirbhūtaḥ| ");
INSERT INTO saniso_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","aparaṁ prabhuṇā paramēśvarēṇābhiṣiktē trātari tvayā na dr̥ṣṭē tvaṁ na mariṣyasīti vākyaṁ pavitrēṇa ātmanā tasma prākathyata| ");
INSERT INTO saniso_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","aparañca yadā yīśōḥ pitā mātā ca tadarthaṁ vyavasthānurūpaṁ karmma karttuṁ taṁ mandiram āninyatustadā ");
INSERT INTO saniso_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","śimiyōn ātmana ākarṣaṇēna mandiramāgatya taṁ krōḍē nidhāya īśvarasya dhanyavādaṁ kr̥tvā kathayāmāsa, yathā, ");
INSERT INTO saniso_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","hē prabhō tava dāsōyaṁ nijavākyānusārataḥ| idānīntu sakalyāṇō bhavatā saṁvisr̥jyatām| ");
INSERT INTO saniso_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","yataḥ sakaladēśasya dīptayē dīptirūpakaṁ| ");
INSERT INTO saniso_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","isrāyēlīyalōkasya mahāgauravarūpakaṁ| ");
INSERT INTO saniso_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","yaṁ trāyakaṁ janānāntu sammukhē tvamajījanaḥ| saēva vidyatē'smākaṁ dhravaṁ nayananagōcarē|| ");
INSERT INTO saniso_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","tadānīṁ tēnōktā ētāḥ sakalāḥ kathāḥ śrutvā tasya mātā yūṣaph ca vismayaṁ mēnātē| ");
INSERT INTO saniso_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","tataḥ paraṁ śimiyōn tēbhya āśiṣaṁ dattvā tanmātaraṁ mariyamam uvāca, paśya isrāyēlō vaṁśamadhyē bahūnāṁ pātanāyōtthāpanāya ca tathā virōdhapātraṁ bhavituṁ, bahūnāṁ guptamanōgatānāṁ prakaṭīkaraṇāya bālakōyaṁ niyuktōsti| ");
INSERT INTO saniso_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","tasmāt tavāpi prāṇāḥ śūlēna vyatsyantē| ");
INSERT INTO saniso_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","aparañca āśērasya vaṁśīyaphinūyēlō duhitā hannākhyā atijaratī bhaviṣyadvādinyēkā yā vivāhāt paraṁ sapta vatsarān patyā saha nyavasat tatō vidhavā bhūtvā caturaśītivarṣavayaḥparyyanataṁ ");
INSERT INTO saniso_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","mandirē sthitvā prārthanōpavāsairdivāniśam īśvaram asēvata sāpi strī tasmin samayē mandiramāgatya ");
INSERT INTO saniso_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","paramēśvarasya dhanyavādaṁ cakāra, yirūśālampuravāsinō yāvantō lōkā muktimapēkṣya sthitāstān yīśōrvr̥ttāntaṁ jñāpayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","itthaṁ paramēśvarasya vyavasthānusārēṇa sarvvēṣu karmmasu kr̥tēṣu tau punaśca gālīlō nāsaratnāmakaṁ nijanagaraṁ pratasthātē| ");
INSERT INTO saniso_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","tatpaścād bālakaḥ śarīrēṇa vr̥ddhimētya jñānēna paripūrṇa ātmanā śaktimāṁśca bhavitumārēbhē tathā tasmin īśvarānugrahō babhūva| ");
INSERT INTO saniso_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","tasya pitā mātā ca prativarṣaṁ nistārōtsavasamayē yirūśālamam agacchatām| ");
INSERT INTO saniso_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","aparañca yīśau dvādaśavarṣavayaskē sati tau parvvasamayasya rītyanusārēṇa yirūśālamaṁ gatvā ");
INSERT INTO saniso_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","pārvvaṇaṁ sampādya punarapi vyāghuyya yātaḥ kintu yīśurbālakō yirūśālami tiṣṭhati| yūṣaph tanmātā ca tad aviditvā ");
INSERT INTO saniso_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","sa saṅgibhiḥ saha vidyata ētacca budvvā dinaikagamyamārgaṁ jagmatuḥ| kintu śēṣē jñātibandhūnāṁ samīpē mr̥gayitvā taduddēेśamaprāpya ");
INSERT INTO saniso_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","tau punarapi yirūśālamam parāvr̥tyāgatya taṁ mr̥gayāñcakratuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","atha dinatrayāt paraṁ paṇḍitānāṁ madhyē tēṣāṁ kathāḥ śr̥ṇvan tattvaṁ pr̥cchaṁśca mandirē samupaviṣṭaḥ sa tābhyāṁ dr̥ṣṭaḥ| ");
INSERT INTO saniso_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","tadā tasya buddhyā pratyuttaraiśca sarvvē śrōtārō vismayamāpadyantē| ");
INSERT INTO saniso_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","tādr̥śaṁ dr̥ṣṭvā tasya janakō jananī ca camaccakratuḥ kiñca tasya mātā tamavadat, hē putra, kathamāvāṁ pratītthaṁ samācarastvam? paśya tava pitāhañca śōkākulau santau tvāmanvicchāvaḥ sma| ");
INSERT INTO saniso_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","tataḥ sōvadat kutō mām anvaicchataṁ? piturgr̥hē mayā sthātavyam ētat kiṁ yuvābhyāṁ na jñāyatē? ");
INSERT INTO saniso_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","kintu tau tasyaitadvākyasya tātparyyaṁ bōddhuṁ nāśaknutāṁ| ");
INSERT INTO saniso_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","tataḥ paraṁ sa tābhyāṁ saha nāsarataṁ gatvā tayōrvaśībhūtastasthau kintu sarvvā ētāḥ kathāstasya mātā manasi sthāpayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","atha yīśō rbuddhiḥ śarīrañca tathā tasmin īśvarasya mānavānāñcānugrahō varddhitum ārēbhē| ");
INSERT INTO saniso_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","anantaraṁ tibiriyakaisarasya rājatvasya pañcadaśē vatsarē sati yadā pantīyapīlātō yihūdādēśādhipati rhērōd tu gālīlpradēśasya rājā philipanāmā tasya bhrātā tu yitūriyāyāstrākhōnītiyāpradēśasya ca rājāsīt luṣānīyanāmā avilīnīdēśasya rājāsīt ");
INSERT INTO saniso_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","hānan kiyaphāścēmau pradhānayājākāvāstāṁ tadānīṁ sikhariyasya putrāya yōhanē madhyēprāntaram īśvarasya vākyē prakāśitē sati ");
INSERT INTO saniso_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","sa yarddana ubhayataṭapradēśān samētya pāpamōcanārthaṁ manaḥparāvarttanasya cihnarūpaṁ yanmajjanaṁ tadīyāḥ kathāḥ sarvvatra pracārayitumārēbhē| ");
INSERT INTO saniso_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","yiśayiyabhaviṣyadvaktr̥granthē yādr̥śī lipirāstē yathā, paramēśasya panthānaṁ pariṣkuruta sarvvataḥ| tasya rājapathañcaiva samānaṁ kurutādhunā| ");
INSERT INTO saniso_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","kāriṣyantē samucchrāyāḥ sakalā nimnabhūmayaḥ| kāriṣyantē natāḥ sarvvē parvvatāścōpaparvvatāḥ| kāriṣyantē ca yā vakrāstāḥ sarvvāḥ saralā bhuvaḥ| kāriṣyantē samānāstā yā uccanīcabhūmayaḥ| ");
INSERT INTO saniso_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","īśvarēṇa kr̥taṁ trāṇaṁ drakṣyanti sarvvamānavāḥ| ityētat prāntarē vākyaṁ vadataḥ kasyacid ravaḥ|| ");
INSERT INTO saniso_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","yē yē lōkā majjanārthaṁ bahirāyayustān sōvadat rē rē sarpavaṁśā āgāminaḥ kōpāt palāyituṁ yuṣmān kaścētayāmāsa? ");
INSERT INTO saniso_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","tasmād ibrāhīm asmākaṁ pitā kathāmīdr̥śīṁ manōbhi rna kathayitvā yūyaṁ manaḥparivarttanayōgyaṁ phalaṁ phalata; yuṣmānahaṁ yathārthaṁ vadāmi pāṣāṇēbhya ētēbhya īśvara ibrāhīmaḥ santānōtpādanē samarthaḥ| ");
INSERT INTO saniso_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","aparañca tarumūlē'dhunāpi paraśuḥ saṁlagnōsti yastaruruttamaṁ phalaṁ na phalati sa chidyatē'gnau nikṣipyatē ca| ");
INSERT INTO saniso_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","tadānīṁ lōkāstaṁ papracchustarhi kiṁ karttavyamasmābhiḥ? ");
INSERT INTO saniso_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","tataḥ sōvādīt yasya dvē vasanē vidyētē sa vastrahīnāyaikaṁ vitaratu kiṁñca yasya khādyadravyaṁ vidyatē sōpi tathaiva karōtu| ");
INSERT INTO saniso_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","tataḥ paraṁ karasañcāyinō majjanārtham āgatya papracchuḥ hē gurō kiṁ karttavyamasmābhiḥ? ");
INSERT INTO saniso_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","tataḥ sōkathayat nirūpitādadhikaṁ na gr̥hlita| ");
INSERT INTO saniso_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","anantaraṁ sēnāgaṇa ētya papraccha kimasmābhi rvā karttavyam? tataḥ sōbhidadhē kasya kāmapi hāniṁ mā kārṣṭa tathā mr̥ṣāpavādaṁ mā kuruta nijavētanēna ca santuṣya tiṣṭhata| ");
INSERT INTO saniso_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","aparañca lōkā apēkṣayā sthitvā sarvvēpīti manōbhi rvitarkayāñcakruḥ, yōhanayam abhiṣiktastrātā na vēti? ");
INSERT INTO saniso_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","tadā yōhan sarvvān vyājahāra, jalē'haṁ yuṣmān majjayāmi satyaṁ kintu yasya pādukābandhanaṁ mōcayitumapi na yōgyōsmi tādr̥śa ēkō mattō gurutaraḥ pumān ēti, sa yuṣmān vahnirūpē pavitra ātmani majjayiṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","aparañca tasya hastē śūrpa āstē sa svaśasyāni śuddharūpaṁ prasphōṭya gōdhūmān sarvvān bhāṇḍāgārē saṁgrahīṣyati kintu būṣāṇi sarvvāṇyanirvvāṇavahninā dāhayiṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","yōhan upadēśēnētthaṁ nānākathā lōkānāṁ samakṣaṁ pracārayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","aparañca hērōd rājā philipnāmnaḥ sahōdarasya bhāryyāṁ hērōdiyāmadhi tathānyāni yāni yāni kukarmmāṇi kr̥tavān tadadhi ca ");
INSERT INTO saniso_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","yōhanā tiraskr̥tō bhūtvā kārāgārē tasya bandhanād aparamapi kukarmma cakāra| ");
INSERT INTO saniso_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","itaḥ pūrvvaṁ yasmin samayē sarvvē yōhanā majjitāstadānīṁ yīśurapyāgatya majjitaḥ| ");
INSERT INTO saniso_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","tadanantaraṁ tēna prārthitē mēghadvāraṁ muktaṁ tasmācca pavitra ātmā mūrttimān bhūtvā kapōtavat taduparyyavarurōha; tadā tvaṁ mama priyaḥ putrastvayi mama paramaḥ santōṣa ityākāśavāṇī babhūva| ");
INSERT INTO saniso_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","tadānīṁ yīśuḥ prāyēṇa triṁśadvarṣavayaska āsīt| laukikajñānē tu sa yūṣaphaḥ putraḥ, ");
INSERT INTO saniso_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","yūṣaph ēlēḥ putraḥ, ēlirmattataḥ putraḥ, mattat lēvēḥ putraḥ, lēvi rmalkēḥ putraḥ, malkiryānnasya putraḥ; yānnō yūṣaphaḥ putraḥ| ");
INSERT INTO saniso_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","yūṣaph mattathiyasya putraḥ, mattathiya āmōsaḥ putraḥ, āmōs nahūmaḥ putraḥ, nahūm iṣlēḥ putraḥ iṣlirnagēḥ putraḥ| ");
INSERT INTO saniso_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","nagirmāṭaḥ putraḥ, māṭ mattathiyasya putraḥ, mattathiyaḥ śimiyēḥ putraḥ, śimiyiryūṣaphaḥ putraḥ, yūṣaph yihūdāḥ putraḥ| ");
INSERT INTO saniso_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","yihūdā yōhānāḥ putraḥ, yōhānā rīṣāḥ putraḥ, rīṣāḥ sirubbābilaḥ putraḥ, sirubbābil śaltīyēlaḥ putraḥ, śaltīyēl nērēḥ putraḥ| ");
INSERT INTO saniso_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","nērirmalkēḥ putraḥ, malkiḥ adyaḥ putraḥ, addī kōṣamaḥ putraḥ, kōṣam ilmōdadaḥ putraḥ, ilmōdad ēraḥ putraḥ| ");
INSERT INTO saniso_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ēr yōśēḥ putraḥ, yōśiḥ ilīyēṣaraḥ putraḥ, ilīyēṣar yōrīmaḥ putraḥ, yōrīm mattataḥ putraḥ, mattata lēvēḥ putraḥ| ");
INSERT INTO saniso_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","lēviḥ śimiyōnaḥ putraḥ, śimiyōn yihūdāḥ putraḥ, yihūdā yūṣuphaḥ putraḥ, yūṣuph yōnanaḥ putraḥ, yānan ilīyākīmaḥ putraḥ| ");
INSERT INTO saniso_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","iliyākīmḥ milēyāḥ putraḥ, milēyā mainanaḥ putraḥ, mainan mattattasya putraḥ, mattattō nāthanaḥ putraḥ, nāthan dāyūdaḥ putraḥ| ");
INSERT INTO saniso_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","dāyūd yiśayaḥ putraḥ, yiśaya ōbēdaḥ putra, ōbēd bōyasaḥ putraḥ, bōyas salmōnaḥ putraḥ, salmōn nahaśōnaḥ putraḥ| ");
INSERT INTO saniso_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","nahaśōn ammīnādabaḥ putraḥ, ammīnādab arāmaḥ putraḥ, arām hiṣrōṇaḥ putraḥ, hiṣrōṇ pērasaḥ putraḥ, pēras yihūdāḥ putraḥ| ");
INSERT INTO saniso_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","yihūdā yākūbaḥ putraḥ, yākūb ishākaḥ putraḥ, ishāk ibrāhīmaḥ putraḥ, ibrāhīm tērahaḥ putraḥ, tērah nāhōraḥ putraḥ| ");
INSERT INTO saniso_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","nāhōr sirugaḥ putraḥ, sirug riyvaḥ putraḥ, riyūḥ pēlagaḥ putraḥ, pēlag ēvaraḥ putraḥ, ēvar śēlahaḥ putraḥ| ");
INSERT INTO saniso_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","śēlah kainanaḥ putraḥ, kainan arphakṣadaḥ putraḥ, arphakṣad śāmaḥ putraḥ, śām nōhaḥ putraḥ, nōhō lēmakaḥ putraḥ| ");
INSERT INTO saniso_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","lēmak mithūśēlahaḥ putraḥ, mithūśēlah hanōkaḥ putraḥ, hanōk yēradaḥ putraḥ, yērad mahalalēlaḥ putraḥ, mahalalēl kainanaḥ putraḥ| ");
INSERT INTO saniso_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","kainan inōśaḥ putraḥ, inōś śētaḥ putraḥ, śēt ādamaḥ putra, ādam īśvarasya putraḥ| ");
INSERT INTO saniso_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","tataḥ paraṁ yīśuḥ pavitrēṇātmanā pūrṇaḥ san yarddananadyāḥ parāvr̥tyātmanā prāntaraṁ nītaḥ san catvāriṁśaddināni yāvat śaitānā parīkṣitō'bhūt, ");
INSERT INTO saniso_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","kiñca tāni sarvvadināni bhōjanaṁ vinā sthitatvāt kālē pūrṇē sa kṣudhitavān| ");
INSERT INTO saniso_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","tataḥ śaitānāgatya tamavadat tvaṁ cēdīśvarasya putrastarhi prastarānētān ājñayā pūpān kuru| ");
INSERT INTO saniso_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","tadā yīśuruvāca, lipirīdr̥śī vidyatē manujaḥ kēvalēna pūpēna na jīvati kintvīśvarasya sarvvābhirājñābhi rjīvati| ");
INSERT INTO saniso_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","tadā śaitān tamuccaṁ parvvataṁ nītvā nimiṣaikamadhyē jagataḥ sarvvarājyāni darśitavān| ");
INSERT INTO saniso_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","paścāt tamavādīt sarvvam ētad vibhavaṁ pratāpañca tubhyaṁ dāsyāmi tan mayi samarpitamāstē yaṁ prati mamēcchā jāyatē tasmai dātuṁ śaknōmi, ");
INSERT INTO saniso_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","tvaṁ cēnmāṁ bhajasē tarhi sarvvamētat tavaiva bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","tadā yīśustaṁ pratyuktavān dūrī bhava śaitān lipirāstē, nijaṁ prabhuṁ paramēśvaraṁ bhajasva kēvalaṁ tamēva sēvasva ca| ");
INSERT INTO saniso_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","atha śaitān taṁ yirūśālamaṁ nītvā mandirasya cūḍāyā upari samupavēśya jagāda tvaṁ cēdīśvarasya putrastarhi sthānāditō lamphitvādhaḥ ");
INSERT INTO saniso_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","pata yatō lipirāstē, ājñāpayiṣyati svīyān dūtān sa paramēśvaraḥ| ");
INSERT INTO saniso_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","rakṣituṁ sarvvamārgē tvāṁ tēna tvaccaraṇē yathā| na lagēt prastarāghātastvāṁ dhariṣyanti tē tathā| ");
INSERT INTO saniso_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","tadā yīśunā pratyuktam idamapyuktamasti tvaṁ svaprabhuṁ parēśaṁ mā parīkṣasva| ");
INSERT INTO saniso_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","paścāt śaitān sarvvaparīkṣāṁ samāpya kṣaṇāttaṁ tyaktvā yayau| ");
INSERT INTO saniso_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","tadā yīśurātmaprabhāvāt punargālīlpradēśaṁ gatastadā tatsukhyātiścaturdiśaṁ vyānaśē| ");
INSERT INTO saniso_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","sa tēṣāṁ bhajanagr̥hēṣu upadiśya sarvvaiḥ praśaṁsitō babhūva| ");
INSERT INTO saniso_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","atha sa svapālanasthānaṁ nāsaratpuramētya viśrāmavārē svācārād bhajanagēhaṁ praviśya paṭhitumuttasthau| ");
INSERT INTO saniso_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","tatō yiśayiyabhaviṣyadvādinaḥ pustakē tasya karadattē sati sa tat pustakaṁ vistāryya yatra vakṣyamāṇāni vacanāni santi tat sthānaṁ prāpya papāṭha| ");
INSERT INTO saniso_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","ātmā tu paramēśasya madīyōpari vidyatē| daridrēṣu susaṁvādaṁ vaktuṁ māṁ sōbhiṣiktavān| bhagnāntaḥ karaṇāllōkān susvasthān karttumēva ca| bandīkr̥tēṣu lōkēṣu muktē rghōṣayituṁ vacaḥ| nētrāṇi dātumandhēbhyastrātuṁ baddhajanānapi| ");
INSERT INTO saniso_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","parēśānugrahē kālaṁ pracārayitumēva ca| sarvvaitatkaraṇārthāya māmēva prahiṇōti saḥ|| ");
INSERT INTO saniso_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","tataḥ pustakaṁ badvvā paricārakasya hastē samarpya cāsanē samupaviṣṭaḥ, tatō bhajanagr̥hē yāvantō lōkā āsan tē sarvvē'nanyadr̥ṣṭyā taṁ vilulōkirē| ");
INSERT INTO saniso_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","anantaram adyaitāni sarvvāṇi likhitavacanāni yuṣmākaṁ madhyē siddhāni sa imāṁ kathāṁ tēbhyaḥ kathayitumārēbhē| ");
INSERT INTO saniso_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","tataḥ sarvvē tasmin anvarajyanta, kiñca tasya mukhānnirgatābhiranugrahasya kathābhiścamatkr̥tya kathayāmāsuḥ kimayaṁ yūṣaphaḥ putrō na? ");
INSERT INTO saniso_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","tadā sō'vādīd hē cikitsaka svamēva svasthaṁ kuru kapharnāhūmi yadyat kr̥tavān tadaśrauṣma tāḥ sarvāḥ kriyā atra svadēśē kuru kathāmētāṁ yūyamēvāvaśyaṁ māṁ vadiṣyatha| ");
INSERT INTO saniso_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","punaḥ sōvādīd yuṣmānahaṁ yathārthaṁ vadāmi, kōpi bhaviṣyadvādī svadēśē satkāraṁ na prāpnōti| ");
INSERT INTO saniso_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","aparañca yathārthaṁ vacmi, ēliyasya jīvanakālē yadā sārddhatritayavarṣāṇi yāvat jaladapratibandhāt sarvvasmin dēśē mahādurbhikṣam ajaniṣṭa tadānīm isrāyēlō dēśasya madhyē bahvyō vidhavā āsan, ");
INSERT INTO saniso_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","kintu sīdōnpradēśīyasāriphatpuranivāsinīm ēkāṁ vidhavāṁ vinā kasyāścidapi samīpē ēliyaḥ prēritō nābhūt| ");
INSERT INTO saniso_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","aparañca ilīśāyabhaviṣyadvādividyamānatākālē isrāyēldēśē bahavaḥ kuṣṭhina āsan kintu surīyadēśīyaṁ nāmānkuṣṭhinaṁ vinā kōpyanyaḥ pariṣkr̥tō nābhūt| ");
INSERT INTO saniso_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","imāṁ kathāṁ śrutvā bhajanagēhasthitā lōkāḥ sakrōdham utthāya ");
INSERT INTO saniso_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","nagarāttaṁ bahiṣkr̥tya yasya śikhariṇa upari tēṣāṁ nagaraṁ sthāpitamāstē tasmānnikṣēptuṁ tasya śikharaṁ taṁ ninyuḥ ");
INSERT INTO saniso_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","kintu sa tēṣāṁ madhyādapasr̥tya sthānāntaraṁ jagāma| ");
INSERT INTO saniso_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","tataḥ paraṁ yīśurgālīlpradēśīyakapharnāhūmnagara upasthāya viśrāmavārē lōkānupadēṣṭum ārabdhavān| ");
INSERT INTO saniso_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","tadupadēśāt sarvvē camaccakru ryatastasya kathā gurutarā āsan| ");
INSERT INTO saniso_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","tadānīṁ tadbhajanagēhasthitō'mēdhyabhūtagrasta ēkō jana uccaiḥ kathayāmāsa, ");
INSERT INTO saniso_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","hē nāsaratīyayīśō'smān tyaja, tvayā sahāsmākaṁ kaḥ sambandhaḥ? kimasmān vināśayitumāyāsi? tvamīśvarasya pavitrō jana ētadahaṁ jānāmi| ");
INSERT INTO saniso_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","tadā yīśustaṁ tarjayitvāvadat maunī bhava itō bahirbhava; tataḥ sōmēdhyabhūtastaṁ madhyasthānē pātayitvā kiñcidapyahiṁsitvā tasmād bahirgatavān| ");
INSERT INTO saniso_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","tataḥ sarvvē lōkāścamatkr̥tya parasparaṁ vaktumārēbhirē kōyaṁ camatkāraḥ| ēṣa prabhāvēṇa parākramēṇa cāmēdhyabhūtān ājñāpayati tēnaiva tē bahirgacchanti| ");
INSERT INTO saniso_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","anantaraṁ caturdiksthadēśān tasya sukhyātirvyāpnōt| ");
INSERT INTO saniso_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","tadanantaraṁ sa bhajanagēhād bahirāgatya śimōnō nivēśanaṁ pravivēśa tadā tasya śvaśrūrjvarēṇātyantaṁ pīḍitāsīt śiṣyāstadarthaṁ tasmin vinayaṁ cakruḥ| ");
INSERT INTO saniso_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","tataḥ sa tasyāḥ samīpē sthitvā jvaraṁ tarjayāmāsa tēnaiva tāṁ jvarō'tyākṣīt tataḥ sā tatkṣaṇam utthāya tān siṣēvē| ");
INSERT INTO saniso_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","atha sūryyāstakālē svēṣāṁ yē yē janā nānārōgaiḥ pīḍitā āsan lōkāstān yīśōḥ samīpam āninyuḥ, tadā sa ēkaikasya gātrē karamarpayitvā tānarōgān cakāra| ");
INSERT INTO saniso_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","tatō bhūtā bahubhyō nirgatya cītśabdaṁ kr̥tvā ca babhāṣirē tvamīśvarasya putrō'bhiṣiktatrātā; kintu sōbhiṣiktatrātēti tē vividurētasmāt kāraṇāt tān tarjayitvā tadvaktuṁ niṣiṣēdha| ");
INSERT INTO saniso_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","aparañca prabhātē sati sa vijanasthānaṁ pratasthē paścāt janāstamanvicchantastannikaṭaṁ gatvā sthānāntaragamanārthaṁ tamanvarundhan| ");
INSERT INTO saniso_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","kintu sa tān jagāda, īśvarīyarājyasya susaṁvādaṁ pracārayitum anyāni purāṇyapi mayā yātavyāni yatastadarthamēva prēritōhaṁ| ");
INSERT INTO saniso_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","atha gālīlō bhajanagēhēṣu sa upadidēśa| ");
INSERT INTO saniso_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","anantaraṁ yīśurēkadā ginēṣarathdasya tīra uttiṣṭhati, tadā lōkā īśvarīyakathāṁ śrōtuṁ tadupari prapatitāḥ| ");
INSERT INTO saniso_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","tadānīṁ sa hdasya tīrasamīpē naudvayaṁ dadarśa kiñca matsyōpajīvinō nāvaṁ vihāya jālaṁ prakṣālayanti| ");
INSERT INTO saniso_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","tatastayōrdvayō rmadhyē śimōnō nāvamāruhya tīrāt kiñciddūraṁ yātuṁ tasmin vinayaṁ kr̥tvā naukāyāmupaviśya lōkān prōpadiṣṭavān| ");
INSERT INTO saniso_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","paścāt taṁ prastāvaṁ samāpya sa śimōnaṁ vyājahāra, gabhīraṁ jalaṁ gatvā matsyān dharttuṁ jālaṁ nikṣipa| ");
INSERT INTO saniso_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","tataḥ śimōna babhāṣē, hē gurō yadyapi vayaṁ kr̥tsnāṁ yāminīṁ pariśramya matsyaikamapi na prāptāstathāpi bhavatō nidēśatō jālaṁ kṣipāmaḥ| ");
INSERT INTO saniso_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","atha jālē kṣiptē bahumatsyapatanād ānāyaḥ pracchinnaḥ| ");
INSERT INTO saniso_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","tasmād upakarttum anyanausthān saṅgina āyātum iṅgitēna samāhvayan tatasta āgatya matsyai rnaudvayaṁ prapūrayāmāsu ryai rnaudvayaṁ pramagnam| ");
INSERT INTO saniso_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","tadā śimōnpitarastad vilōkya yīśōścaraṇayōḥ patitvā, hē prabhōhaṁ pāpī narō mama nikaṭād bhavān yātu, iti kathitavān| ");
INSERT INTO saniso_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","yatō jālē patitānāṁ matsyānāṁ yūthāt śimōn tatsaṅginaśca camatkr̥tavantaḥ; śimōnaḥ sahakāriṇau sivadēḥ putrau yākūb yōhan cēmau tādr̥śau babhūvatuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","tadā yīśuḥ śimōnaṁ jagāda mā bhaiṣīradyārabhya tvaṁ manuṣyadharō bhaviṣyasi| ");
INSERT INTO saniso_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","anantaraṁ sarvvāsu nausu tīram ānītāsu tē sarvvān parityajya tasya paścādgāminō babhūvuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","tataḥ paraṁ yīśau kasmiṁścit purē tiṣṭhati jana ēkaḥ sarvvāṅgakuṣṭhastaṁ vilōkya tasya samīpē nyubjaḥ patitvā savinayaṁ vaktumārēbhē, hē prabhō yadi bhavānicchati tarhi māṁ pariṣkarttuṁ śaknōti| ");
INSERT INTO saniso_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","tadānīṁ sa pāṇiṁ prasāryya tadaṅgaṁ spr̥śan babhāṣē tvaṁ pariṣkriyasvēti mamēcchāsti tatastatkṣaṇaṁ sa kuṣṭhāt muktaḥ| ");
INSERT INTO saniso_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","paścāt sa tamājñāpayāmāsa kathāmimāṁ kasmaicid akathayitvā yājakasya samīpañca gatvā svaṁ darśaya, lōkēbhyō nijapariṣkr̥tatvasya pramāṇadānāya mūsājñānusārēṇa dravyamutmr̥jasva ca| ");
INSERT INTO saniso_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","tathāpi yīśōḥ sukhyāti rbahu vyāptumārēbhē kiñca tasya kathāṁ śrōtuṁ svīyarōgēbhyō mōktuñca lōkā ājagmuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","atha sa prāntaraṁ gatvā prārthayāñcakrē| ");
INSERT INTO saniso_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","aparañca ēkadā yīśurupadiśati, ētarhi gālīlyihūdāpradēśayōḥ sarvvanagarēbhyō yirūśālamaśca kiyantaḥ phirūśilōkā vyavasthāpakāśca samāgatya tadantikē samupaviviśuḥ, tasmin kālē lōkānāmārōgyakāraṇāt prabhōḥ prabhāvaḥ pracakāśē| ");
INSERT INTO saniso_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","paścāt kiyantō lōkā ēkaṁ pakṣāghātinaṁ khaṭvāyāṁ nidhāya yīśōḥ samīpamānētuṁ sammukhē sthāpayituñca vyāpriyanta| ");
INSERT INTO saniso_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","kintu bahujananivahasamvādhāt na śaknuvantō gr̥hōpari gatvā gr̥hapr̥ṣṭhaṁ khanitvā taṁ pakṣāghātinaṁ sakhaṭvaṁ gr̥hamadhyē yīśōḥ sammukhē 'varōhayāmāsuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","tadā yīśustēṣām īdr̥śaṁ viśvāsaṁ vilōkya taṁ pakṣāghātinaṁ vyājahāra, hē mānava tava pāpamakṣamyata| ");
INSERT INTO saniso_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","tasmād adhyāpakāḥ phirūśinaśca cittairitthaṁ pracintitavantaḥ, ēṣa jana īśvaraṁ nindati kōyaṁ? kēvalamīśvaraṁ vinā pāpaṁ kṣantuṁ kaḥ śaknōti? ");
INSERT INTO saniso_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","tadā yīśustēṣām itthaṁ cintanaṁ viditvā tēbhyōkathayad yūyaṁ manōbhiḥ kutō vitarkayatha? ");
INSERT INTO saniso_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","tava pāpakṣamā jātā yadvā tvamutthāya vraja ētayō rmadhyē kā kathā sukathyā? ");
INSERT INTO saniso_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","kintu pr̥thivyāṁ pāpaṁ kṣantuṁ mānavasutasya sāmarthyamastīti yathā yūyaṁ jñātuṁ śaknutha tadarthaṁ (sa taṁ pakṣāghātinaṁ jagāda) uttiṣṭha svaśayyāṁ gr̥hītvā gr̥haṁ yāhīti tvāmādiśāmi| ");
INSERT INTO saniso_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","tasmāt sa tatkṣaṇam utthāya sarvvēṣāṁ sākṣāt nijaśayanīyaṁ gr̥hītvā īśvaraṁ dhanyaṁ vadan nijanivēśanaṁ yayau| ");
INSERT INTO saniso_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","tasmāt sarvvē vismaya prāptā manaḥsu bhītāśca vayamadyāsambhavakāryyāṇyadarśāma ityuktvā paramēśvaraṁ dhanyaṁ prōditāḥ| ");
INSERT INTO saniso_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","tataḥ paraṁ bahirgacchan karasañcayasthānē lēvināmānaṁ karasañcāyakaṁ dr̥ṣṭvā yīśustamabhidadhē mama paścādēhi| ");
INSERT INTO saniso_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","tasmāt sa tatkṣaṇāt sarvvaṁ parityajya tasya paścādiyāya| ");
INSERT INTO saniso_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","anantaraṁ lēvi rnijagr̥hē tadarthaṁ mahābhōjyaṁ cakāra, tadā taiḥ sahānēkē karasañcāyinastadanyalōkāśca bhōktumupaviviśuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","tasmāt kāraṇāt caṇḍālānāṁ pāpilōkānāñca saṅgē yūyaṁ kutō bhaṁgdhvē pivatha cēti kathāṁ kathayitvā phirūśinō'dhyāpakāśca tasya śiṣyaiḥ saha vāgyuddhaṁ karttumārēbhirē| ");
INSERT INTO saniso_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","tasmād yīśustān pratyavōcad arōgalōkānāṁ cikitsakēna prayōjanaṁ nāsti kintu sarōgāṇāmēva| ");
INSERT INTO saniso_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ahaṁ dhārmmikān āhvātuṁ nāgatōsmi kintu manaḥ parāvarttayituṁ pāpina ēva| ");
INSERT INTO saniso_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","tatastē prōcuḥ, yōhanaḥ phirūśināñca śiṣyā vāraṁvāram upavasanti prārthayantē ca kintu tava śiṣyāḥ kutō bhuñjatē pivanti ca? ");
INSERT INTO saniso_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","tadā sa tānācakhyau varē saṅgē tiṣṭhati varasya sakhigaṇaṁ kimupavāsayituṁ śaknutha? ");
INSERT INTO saniso_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","kintu yadā tēṣāṁ nikaṭād varō nēṣyatē tadā tē samupavatsyanti| ");
INSERT INTO saniso_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","sōparamapi dr̥ṣṭāntaṁ kathayāmbabhūva purātanavastrē kōpi nutanavastraṁ na sīvyati yatastēna sēvanēna jīrṇavastraṁ chidyatē, nūtanapurātanavastrayō rmēlañca na bhavati| ");
INSERT INTO saniso_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","purātanyāṁ kutvāṁ kōpi nutanaṁ drākṣārasaṁ na nidadhāti, yatō navīnadrākṣārasasya tējasā purātanī kutū rvidīryyatē tatō drākṣārasaḥ patati kutūśca naśyati| ");
INSERT INTO saniso_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","tatō hētō rnūtanyāṁ kutvāṁ navīnadrākṣārasaḥ nidhātavyastēnōbhayasya rakṣā bhavati| ");
INSERT INTO saniso_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","aparañca purātanaṁ drākṣārasaṁ pītvā kōpi nūtanaṁ na vāñchati, yataḥ sa vakti nūtanāt purātanam praśastam| ");
INSERT INTO saniso_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","acarañca parvvaṇō dvitīyadināt paraṁ prathamaviśrāmavārē śasyakṣētrēṇa yīśōrgamanakālē tasya śiṣyāḥ kaṇiśaṁ chittvā karēṣu marddayitvā khāditumārēbhirē| ");
INSERT INTO saniso_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","tasmāt kiyantaḥ phirūśinastānavadan viśrāmavārē yat karmma na karttavyaṁ tat kutaḥ kurutha? ");
INSERT INTO saniso_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","yīśuḥ pratyuvāca dāyūd tasya saṅginaśca kṣudhārttāḥ kiṁ cakruḥ sa katham īśvarasya mandiraṁ praviśya ");
INSERT INTO saniso_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","yē darśanīyāḥ pūpā yājakān vinānyasya kasyāpyabhōjanīyāstānānīya svayaṁ bubhajē saṅgibhyōpi dadau tat kiṁ yuṣmābhiḥ kadāpi nāpāṭhi? ");
INSERT INTO saniso_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","paścāt sa tānavadat manujasutō viśrāmavārasyāpi prabhu rbhavati| ");
INSERT INTO saniso_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","anantaram anyaviśrāmavārē sa bhajanagēhaṁ praviśya samupadiśati| tadā tatsthānē śuṣkadakṣiṇakara ēkaḥ pumān upatasthivān| ");
INSERT INTO saniso_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","tasmād adhyāpakāḥ phirūśinaśca tasmin dōṣamārōpayituṁ sa viśrāmavārē tasya svāsthyaṁ karōti navēti pratīkṣitumārēbhirē| ");
INSERT INTO saniso_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","tadā yīśustēṣāṁ cintāṁ viditvā taṁ śuṣkakaraṁ pumāṁsaṁ prōvāca, tvamutthāya madhyasthānē tiṣṭha| ");
INSERT INTO saniso_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","tasmāt tasmin utthitavati yīśustān vyājahāra, yuṣmān imāṁ kathāṁ pr̥cchāmi, viśrāmavārē hitam ahitaṁ vā, prāṇarakṣaṇaṁ prāṇanāśanaṁ vā, ētēṣāṁ kiṁ karmmakaraṇīyam? ");
INSERT INTO saniso_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","paścāt caturdikṣu sarvvān vilōkya taṁ mānavaṁ babhāṣē, nijakaraṁ prasāraya; tatastēna tathā kr̥ta itarakaravat tasya hastaḥ svasthōbhavat| ");
INSERT INTO saniso_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","tasmāt tē pracaṇḍakōpānvitā yīśuṁ kiṁ kariṣyantīti parasparaṁ pramantritāḥ| ");
INSERT INTO saniso_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","tataḥ paraṁ sa parvvatamāruhyēśvaramuddiśya prārthayamānaḥ kr̥tsnāṁ rātriṁ yāpitavān| ");
INSERT INTO saniso_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","atha dinē sati sa sarvvān śiṣyān āhūtavān tēṣāṁ madhyē ");
INSERT INTO saniso_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","pitaranāmnā khyātaḥ śimōn tasya bhrātā āndriyaśca yākūb yōhan ca philip barthalamayaśca ");
INSERT INTO saniso_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","mathiḥ thōmā ālphīyasya putrō yākūb jvalantanāmnā khyātaḥ śimōn ");
INSERT INTO saniso_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ca yākūbō bhrātā yihūdāśca taṁ yaḥ parakarēṣu samarpayiṣyati sa īṣkarīyōtīyayihūdāścaitān dvādaśa janān manōnītān kr̥tvā sa jagrāha tathā prērita iti tēṣāṁ nāma cakāra| ");
INSERT INTO saniso_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","tataḥ paraṁ sa taiḥ saha parvvatādavaruhya upatyakāyāṁ tasthau tatastasya śiṣyasaṅghō yihūdādēśād yirūśālamaśca sōraḥ sīdōnaśca jaladhē rōdhasō jananihāśca ētya tasya kathāśravaṇārthaṁ rōgamuktyarthañca tasya samīpē tasthuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","amēdhyabhūtagrastāśca tannikaṭamāgatya svāsthyaṁ prāpuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","sarvvēṣāṁ svāsthyakaraṇaprabhāvasya prakāśitatvāt sarvvē lōkā ētya taṁ spraṣṭuṁ yētirē| ");
INSERT INTO saniso_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","paścāt sa śiṣyān prati dr̥ṣṭiṁ kutvā jagāda, hē daridrā yūyaṁ dhanyā yata īśvarīyē rājyē vō'dhikārōsti| ");
INSERT INTO saniso_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","hē adhunā kṣudhitalōkā yūyaṁ dhanyā yatō yūyaṁ tarpsyatha; hē iha rōdinō janā yūyaṁ dhanyā yatō yūyaṁ hasiṣyatha| ");
INSERT INTO saniso_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","yadā lōkā manuṣyasūnō rnāmahētō ryuṣmān r̥ृtīyiṣyantē pr̥thak kr̥tvā nindiṣyanti, adhamāniva yuṣmān svasamīpād dūrīkariṣyanti ca tadā yūyaṁ dhanyāḥ| ");
INSERT INTO saniso_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","svargē yuṣmākaṁ yathēṣṭaṁ phalaṁ bhaviṣyati, ētadarthaṁ tasmin dinē prōllasata ānandēna nr̥tyata ca, tēṣāṁ pūrvvapuruṣāśca bhaviṣyadvādinaḥ prati tathaiva vyavāharan| ");
INSERT INTO saniso_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","kintu hā hā dhanavantō yūyaṁ sukhaṁ prāpnuta| hanta paritr̥ptā yūyaṁ kṣudhitā bhaviṣyatha; ");
INSERT INTO saniso_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","iha hasantō yūyaṁ vata yuṣmābhiḥ śōcitavyaṁ rōditavyañca| ");
INSERT INTO saniso_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","sarvvailākai ryuṣmākaṁ sukhyātau kr̥tāyāṁ yuṣmākaṁ durgati rbhaviṣyati yuṣmākaṁ pūrvvapuruṣā mr̥ṣābhaviṣyadvādinaḥ prati tadvat kr̥tavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","hē śrōtārō yuṣmabhyamahaṁ kathayāmi, yūyaṁ śatruṣu prīyadhvaṁ yē ca yuṣmān dviṣanti tēṣāmapi hitaṁ kuruta| ");
INSERT INTO saniso_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","yē ca yuṣmān śapanti tēbhya āśiṣaṁ datta yē ca yuṣmān avamanyantē tēṣāṁ maṅgalaṁ prārthayadhvaṁ| ");
INSERT INTO saniso_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","yadi kaścit tava kapōlē capēṭāghātaṁ karōti tarhi taṁ prati kapōlam anyaṁ parāvarttya sammukhīkuru punaśca yadi kaścit tava gātrīyavastraṁ harati tarhi taṁ paridhēyavastram api grahītuṁ mā vāraya| ");
INSERT INTO saniso_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","yastvāṁ yācatē tasmai dēhi, yaśca tava sampattiṁ harati taṁ mā yācasva| ");
INSERT INTO saniso_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","parēbhyaḥ svān prati yathācaraṇam apēkṣadhvē parān prati yūyamapi tathācarata| ");
INSERT INTO saniso_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","yē janā yuṣmāsu prīyantē kēvalaṁ tēṣu prīyamāṇēṣu yuṣmākaṁ kiṁ phalaṁ? pāpilōkā api svēṣu prīyamāṇēṣu prīyantē| ");
INSERT INTO saniso_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","yadi hitakāriṇa ēva hitaṁ kurutha tarhi yuṣmākaṁ kiṁ phalaṁ? pāpilōkā api tathā kurvvanti| ");
INSERT INTO saniso_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","yēbhya r̥ṇapariśōdhasya prāptipratyāśāstē kēvalaṁ tēṣu r̥ṇē samarpitē yuṣmākaṁ kiṁ phalaṁ? punaḥ prāptyāśayā pāpīlōkā api pāpijanēṣu r̥ṇam arpayanti| ");
INSERT INTO saniso_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","atō yūyaṁ ripuṣvapi prīyadhvaṁ, parahitaṁ kuruta ca; punaḥ prāptyāśāṁ tyaktvā r̥ṇamarpayata, tathā kr̥tē yuṣmākaṁ mahāphalaṁ bhaviṣyati, yūyañca sarvvapradhānasya santānā iti khyātiṁ prāpsyatha, yatō yuṣmākaṁ pitā kr̥taghnānāṁ durvṭattānāñca hitamācarati| ");
INSERT INTO saniso_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ata ēva sa yathā dayālu ryūyamapi tādr̥śā dayālavō bhavata| ");
INSERT INTO saniso_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","aparañca parān dōṣiṇō mā kuruta tasmād yūyaṁ dōṣīkr̥tā na bhaviṣyatha; adaṇḍyān mā daṇḍayata tasmād yūyamapi daṇḍaṁ na prāpsyatha; parēṣāṁ dōṣān kṣamadhvaṁ tasmād yuṣmākamapi dōṣāḥ kṣamiṣyantē| ");
INSERT INTO saniso_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","dānānidatta tasmād yūyaṁ dānāni prāpsyatha, varañca lōkāḥ parimāṇapātraṁ pradalayya sañcālya prōñcālya paripūryya yuṣmākaṁ krōḍēṣu samarpayiṣyanti; yūyaṁ yēna parimāṇēna parimātha tēnaiva parimāṇēna yuṣmatkr̥tē parimāsyatē| ");
INSERT INTO saniso_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","atha sa tēbhyō dr̥ṣṭāntakathāmakathayat, andhō janaḥ kimandhaṁ panthānaṁ darśayituṁ śaknōti? tasmād ubhāvapi kiṁ garttē na patiṣyataḥ? ");
INSERT INTO saniso_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","gurōḥ śiṣyō na śrēṣṭhaḥ kintu śiṣyē siddhē sati sa gurutulyō bhavituṁ śaknōti| ");
INSERT INTO saniso_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","aparañca tvaṁ svacakṣuुṣi nāsām adr̥ṣṭvā tava bhrātuścakṣuṣi yattr̥ṇamasti tadēva kutaḥ paśyami? ");
INSERT INTO saniso_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","svacakṣuṣi yā nāsā vidyatē tām ajñātvā, bhrātastava nētrāt tr̥ṇaṁ bahiḥ karōmīti vākyaṁ bhrātaraṁ kathaṁ vaktuṁ śaknōṣi? hē kapaṭin pūrvvaṁ svanayanāt nāsāṁ bahiḥ kuru tatō bhrātuścakṣuṣastr̥ṇaṁ bahiḥ karttuṁ sudr̥ṣṭiṁ prāpsyasi| ");
INSERT INTO saniso_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","anyañca uttamastaruḥ kadāpi phalamanuttamaṁ na phalati, anuttamataruśca phalamuttamaṁ na phalati kāraṇādataḥ phalaistaravō jñāyantē| ");
INSERT INTO saniso_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","kaṇṭakipādapāt kōpi uḍumbaraphalāni na pātayati tathā śr̥gālakōlivr̥kṣādapi kōpi drākṣāphalaṁ na pātayati| ");
INSERT INTO saniso_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","tadvat sādhulōkō'ntaḥkaraṇarūpāt subhāṇḍāgārād uttamāni dravyāṇi bahiḥ karōti, duṣṭō lōkaścāntaḥkaraṇarūpāt kubhāṇḍāgārāt kutsitāni dravyāṇi nirgamayati yatō'ntaḥkaraṇānāṁ pūrṇabhāvānurūpāṇi vacāṁsi mukhānnirgacchanti| ");
INSERT INTO saniso_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","aparañca mamājñānurūpaṁ nācaritvā kutō māṁ prabhō prabhō iti vadatha? ");
INSERT INTO saniso_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","yaḥ kaścin mama nikaṭam āgatya mama kathā niśamya tadanurūpaṁ karmma karōti sa kasya sadr̥śō bhavati tadahaṁ yuṣmān jñāाpayāmi| ");
INSERT INTO saniso_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","yō janō gabhīraṁ khanitvā pāṣāṇasthalē bhittiṁ nirmmāya svagr̥haṁ racayati tēna saha tasyōpamā bhavati; yata āplāvijalamētya tasya mūlē vēgēna vahadapi tadgēhaṁ lāḍayituṁ na śaknōti yatastasya bhittiḥ pāṣāṇōpari tiṣṭhati| ");
INSERT INTO saniso_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","kintu yaḥ kaścin mama kathāḥ śrutvā tadanurūpaṁ nācarati sa bhittiṁ vinā mr̥ृdupari gr̥hanirmmātrā samānō bhavati; yata āplāvijalamāgatya vēgēna yadā vahati tadā tadgr̥haṁ patati tasya mahat patanaṁ jāyatē| ");
INSERT INTO saniso_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","tataḥ paraṁ sa lōkānāṁ karṇagōcarē tān sarvvān upadēśān samāpya yadā kapharnāhūmpuraṁ praviśati ");
INSERT INTO saniso_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","tadā śatasēnāpatēḥ priyadāsa ēkō mr̥takalpaḥ pīḍita āsīt| ");
INSERT INTO saniso_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ataḥ sēnāpati ryīśō rvārttāṁ niśamya dāsasyārōgyakaraṇāya tasyāgamanārthaṁ vinayakaraṇāya yihūdīyān kiyataḥ prācaḥ prēṣayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","tē yīśōrantikaṁ gatvā vinayātiśayaṁ vaktumārēbhirē, sa sēnāpati rbhavatōnugrahaṁ prāptum arhati| ");
INSERT INTO saniso_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","yataḥ sōsmajjātīyēṣu lōkēṣu prīyatē tathāsmatkr̥tē bhajanagēhaṁ nirmmitavān| ");
INSERT INTO saniso_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","tasmād yīśustaiḥ saha gatvā nivēśanasya samīpaṁ prāpa, tadā sa śatasēnāpati rvakṣyamāṇavākyaṁ taṁ vaktuṁ bandhūn prāhiṇōt| hē prabhō svayaṁ śramō na karttavyō yad bhavatā madgēhamadhyē pādārpaṇaṁ kriyēta tadapyahaṁ nārhāmi, ");
INSERT INTO saniso_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","kiñcāhaṁ bhavatsamīpaṁ yātumapi nātmānaṁ yōgyaṁ buddhavān, tatō bhavān vākyamātraṁ vadatu tēnaiva mama dāsaḥ svasthō bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","yasmād ahaṁ parādhīnōpi mamādhīnā yāḥ sēnāḥ santi tāsām ēkajanaṁ prati yāhīti mayā prōktē sa yāti; tadanyaṁ prati āyāhīti prōktē sa āyāti; tathā nijadāsaṁ prati ētat kurvviti prōktē sa tadēva karōti| ");
INSERT INTO saniso_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","yīśuridaṁ vākyaṁ śrutvā vismayaṁ yayau, mukhaṁ parāvartya paścādvarttinō lōkān babhāṣē ca, yuṣmānahaṁ vadāmi isrāyēlō vaṁśamadhyēpi viśvāsamīdr̥śaṁ na prāpnavaṁ| ");
INSERT INTO saniso_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","tatastē prēṣitā gr̥haṁ gatvā taṁ pīḍitaṁ dāsaṁ svasthaṁ dadr̥śuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","parē'hani sa nāyīnākhyaṁ nagaraṁ jagāma tasyānēkē śiṣyā anyē ca lōkāstēna sārddhaṁ yayuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","tēṣu tannagarasya dvārasannidhiṁ prāptēṣu kiyantō lōkā ēkaṁ mr̥tamanujaṁ vahantō nagarasya bahiryānti, sa tanmāturēkaputrastanmātā ca vidhavā; tayā sārddhaṁ tannagarīyā bahavō lōkā āsan| ");
INSERT INTO saniso_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","prabhustāṁ vilōkya sānukampaḥ kathayāmāsa, mā rōdīḥ| sa samīpamitvā khaṭvāṁ pasparśa tasmād vāhakāḥ sthagitāstamyuḥ; ");
INSERT INTO saniso_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","tadā sa uvāca hē yuvamanuṣya tvamuttiṣṭha, tvāmaham ājñāpayāmi| ");
INSERT INTO saniso_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","tasmāt sa mr̥tō janastatkṣaṇamutthāya kathāṁ prakathitaḥ; tatō yīśustasya mātari taṁ samarpayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","tasmāt sarvvē lōkāḥ śaśaṅkirē; ēkō mahābhaviṣyadvādī madhyē'smākam samudait, īśvaraśca svalōkānanvagr̥hlāt kathāmimāṁ kathayitvā īśvaraṁ dhanyaṁ jagaduḥ| ");
INSERT INTO saniso_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","tataḥ paraṁ samastaṁ yihūdādēśaṁ tasya caturdiksthadēśañca tasyaitatkīrtti rvyānaśē| ");
INSERT INTO saniso_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","tataḥ paraṁ yōhanaḥ śiṣyēṣu taṁ tadvr̥ttāntaṁ jñāpitavatsu ");
INSERT INTO saniso_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","sa svaśiṣyāṇāṁ dvau janāvāhūya yīśuṁ prati vakṣyamāṇaṁ vākyaṁ vaktuṁ prēṣayāmāsa, yasyāgamanam apēkṣya tiṣṭhāmō vayaṁ kiṁ sa ēva janastvaṁ? kiṁ vayamanyamapēkṣya sthāsyāmaḥ? ");
INSERT INTO saniso_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","paścāttau mānavau gatvā kathayāmāsatuḥ, yasyāgamanam apēkṣya tiṣṭhāmō vayaṁ, kiṁ saēva janastvaṁ? kiṁ vayamanyamapēkṣya sthāsyāmaḥ? kathāmimāṁ tubhyaṁ kathayituṁ yōhan majjaka āvāṁ prēṣitavān| ");
INSERT INTO saniso_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","tasmin daṇḍē yīśūrōgiṇō mahāvyādhimatō duṣṭabhūtagrastāṁśca bahūn svasthān kr̥tvā, anēkāndhēbhyaścakṣuṁṣi dattvā pratyuvāca, ");
INSERT INTO saniso_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","yuvāṁ vrajatam andhā nētrāṇi khañjāścaraṇāni ca prāpnuvanti, kuṣṭhinaḥ pariṣkriyantē, badhirāḥ śravaṇāni mr̥tāśca jīvanāni prāpnuvanti, daridrāṇāṁ samīpēṣu susaṁvādaḥ pracāryyatē, yaṁ prati vighnasvarūpōhaṁ na bhavāmi sa dhanyaḥ, ");
INSERT INTO saniso_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ētāni yāni paśyathaḥ śr̥ṇuthaśca tāni yōhanaṁ jñāpayatam| ");
INSERT INTO saniso_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","tayō rdūtayō rgatayōḥ satō ryōhani sa lōkān vaktumupacakramē, yūyaṁ madhyēprāntaraṁ kiṁ draṣṭuṁ niragamata? kiṁ vāyunā kampitaṁ naḍaṁ? ");
INSERT INTO saniso_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","yūyaṁ kiṁ draṣṭuṁ niragamata? kiṁ sūkṣmavastraparidhāyinaṁ kamapi naraṁ? kintu yē sūkṣmamr̥duvastrāṇi paridadhati sūttamāni dravyāṇi bhuñjatē ca tē rājadhānīṣu tiṣṭhanti| ");
INSERT INTO saniso_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","tarhi yūyaṁ kiṁ draṣṭuṁ niragamata? kimēkaṁ bhaviṣyadvādinaṁ? tadēva satyaṁ kintu sa pumān bhaviṣyadvādinōpi śrēṣṭha ityahaṁ yuṣmān vadāmi; ");
INSERT INTO saniso_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","paśya svakīyadūtantu tavāgra prēṣayāmyahaṁ| gatvā tvadīyamārgantu sa hi pariṣkariṣyati| yadarthē lipiriyam āstē sa ēva yōhan| ");
INSERT INTO saniso_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","atō yuṣmānahaṁ vadāmi striyā garbbhajātānāṁ bhaviṣyadvādināṁ madhyē yōhanō majjakāt śrēṣṭhaḥ kōpi nāsti, tatrāpi īśvarasya rājyē yaḥ sarvvasmāt kṣudraḥ sa yōhanōpi śrēṣṭhaḥ| ");
INSERT INTO saniso_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","aparañca sarvvē lōkāḥ karamañcāyinaśca tasya vākyāni śrutvā yōhanā majjanēna majjitāḥ paramēśvaraṁ nirdōṣaṁ mēnirē| ");
INSERT INTO saniso_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","kintu phirūśinō vyavasthāpakāśca tēna na majjitāḥ svān pratīśvarasyōpadēśaṁ niṣphalam akurvvan| ");
INSERT INTO saniso_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","atha prabhuḥ kathayāmāsa, idānīntanajanān kēnōpamāmi? tē kasya sadr̥śāḥ? ");
INSERT INTO saniso_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","yē bālakā vipaṇyām upaviśya parasparam āhūya vākyamidaṁ vadanti, vayaṁ yuṣmākaṁ nikaṭē vaṁśīravādiṣma, kintu yūyaṁ nānarttiṣṭa, vayaṁ yuṣmākaṁ nikaṭa arōdiṣma, kintu yuyaṁ na vyalapiṣṭa, bālakairētādr̥śaistēṣām upamā bhavati| ");
INSERT INTO saniso_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","yatō yōhan majjaka āgatya pūpaṁ nākhādat drākṣārasañca nāpivat tasmād yūyaṁ vadatha, bhūtagrastōyam| ");
INSERT INTO saniso_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","tataḥ paraṁ mānavasuta āgatyākhādadapivañca tasmād yūyaṁ vadatha, khādakaḥ surāpaścāṇḍālapāpināṁ bandhurēkō janō dr̥śyatām| ");
INSERT INTO saniso_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","kintu jñāninō jñānaṁ nirdōṣaṁ viduḥ| ");
INSERT INTO saniso_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","paścādēkaḥ phirūśī yīśuṁ bhōjanāya nyamantrayat tataḥ sa tasya gr̥haṁ gatvā bhōktumupaviṣṭaḥ| ");
INSERT INTO saniso_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ētarhi tatphirūśinō gr̥hē yīśu rbhēktum upāvēkṣīt tacchrutvā tannagaravāsinī kāpi duṣṭā nārī pāṇḍaraprastarasya sampuṭakē sugandhitailam ānīya ");
INSERT INTO saniso_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","tasya paścāt pādayōḥ sannidhau tasyau rudatī ca nētrāmbubhistasya caraṇau prakṣālya nijakacairamārkṣīt, tatastasya caraṇau cumbitvā tēna sugandhitailēna mamarda| ");
INSERT INTO saniso_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","tasmāt sa nimantrayitā phirūśī manasā cintayāmāsa, yadyayaṁ bhaviṣyadvādī bhavēt tarhi ēnaṁ spr̥śati yā strī sā kā kīdr̥śī cēti jñātuṁ śaknuyāt yataḥ sā duṣṭā| ");
INSERT INTO saniso_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","tadā yāśustaṁ jagāda, hē śimōn tvāṁ prati mama kiñcid vaktavyamasti; tasmāt sa babhāṣē, hē gurō tad vadatu| ");
INSERT INTO saniso_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ēkōttamarṇasya dvāvadhamarṇāvāstāṁ, tayōrēkaḥ pañcaśatāni mudrāpādān aparaśca pañcāśat mudrāpādān dhārayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","tadanantaraṁ tayōḥ śōdhyābhāvāt sa uttamarṇastayō rr̥ṇē cakṣamē; tasmāt tayōrdvayōḥ kastasmin prēṣyatē bahu? tad brūhi| ");
INSERT INTO saniso_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","śimōn pratyuvāca, mayā budhyatē yasyādhikam r̥ṇaṁ cakṣamē sa iti; tatō yīśustaṁ vyājahāra, tvaṁ yathārthaṁ vyacārayaḥ| ");
INSERT INTO saniso_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","atha tāṁ nārīṁ prati vyāghuṭhya śimōnamavōcat, strīmimāṁ paśyasi? tava gr̥hē mayyāgatē tvaṁ pādaprakṣālanārthaṁ jalaṁ nādāḥ kintu yōṣidēṣā nayanajalai rmama pādau prakṣālya kēśairamārkṣīt| ");
INSERT INTO saniso_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","tvaṁ māṁ nācumbīḥ kintu yōṣidēṣā svīyāgamanādārabhya madīyapādau cumbituṁ na vyaraṁsta| ");
INSERT INTO saniso_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","tvañca madīyōttamāṅgē kiñcidapi tailaṁ nāmardīḥ kintu yōṣidēṣā mama caraṇau sugandhitailēnāmarddīt| ");
INSERT INTO saniso_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","atastvāṁ vyāharāmi, ētasyā bahu pāpamakṣamyata tatō bahu prīyatē kintu yasyālpapāpaṁ kṣamyatē sōlpaṁ prīyatē| ");
INSERT INTO saniso_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","tataḥ paraṁ sa tāṁ babhāṣē, tvadīyaṁ pāpamakṣamyata| ");
INSERT INTO saniso_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","tadā tēna sārddhaṁ yē bhōktum upaviviśustē parasparaṁ vaktumārēbhirē, ayaṁ pāpaṁ kṣamatē ka ēṣaḥ? ");
INSERT INTO saniso_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","kintu sa tāṁ nārīṁ jagāda, tava viśvāsastvāṁ paryyatrāsta tvaṁ kṣēmēṇa vraja| ");
INSERT INTO saniso_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","aparañca yīśu rdvādaśabhiḥ śiṣyaiḥ sārddhaṁ nānānagarēṣu nānāgrāmēṣu ca gacchan iśvarīyarājatvasya susaṁvādaṁ pracārayituṁ prārēbhē| ");
INSERT INTO saniso_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","tadā yasyāḥ sapta bhūtā niragacchan sā magdalīnīti vikhyātā mariyam hērōdrājasya gr̥hādhipatēḥ hōṣē rbhāryyā yōhanā śūśānā ");
INSERT INTO saniso_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","prabhr̥tayō yā bahvyaḥ striyaḥ duṣṭabhūtēbhyō rōgēbhyaśca muktāḥ satyō nijavibhūtī rvyayitvā tamasēvanta, tāḥ sarvvāstēna sārddham āsan| ");
INSERT INTO saniso_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","anantaraṁ nānānagarēbhyō bahavō lōkā āgatya tasya samīpē'milan, tadā sa tēbhya ēkāṁ dr̥ṣṭāntakathāṁ kathayāmāsa| ēkaḥ kr̥ṣībalō bījāni vaptuṁ bahirjagāma, ");
INSERT INTO saniso_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","tatō vapanakālē katipayāni bījāni mārgapārśvē pētuḥ, tatastāni padatalai rdalitāni pakṣibhi rbhakṣitāni ca| ");
INSERT INTO saniso_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","katipayāni bījāni pāṣāṇasthalē patitāni yadyapi tānyaṅkuritāni tathāpi rasābhāvāt śuśuṣuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","katipayāni bījāni kaṇṭakivanamadhyē patitāni tataḥ kaṇṭakivanāni saṁvr̥ddhya tāni jagrasuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","tadanyāni katipayabījāni ca bhūmyāmuttamāyāṁ pētustatastānyaṅkurayitvā śataguṇāni phalāni phēluḥ| sa imā kathāṁ kathayitvā prōccaiḥ prōvāca, yasya śrōtuṁ śrōtrē staḥ sa śr̥ṇōtu| ");
INSERT INTO saniso_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","tataḥ paraṁ śiṣyāstaṁ papracchurasya dr̥ṣṭāntasya kiṁ tātparyyaṁ? ");
INSERT INTO saniso_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","tataḥ sa vyājahāra, īśvarīyarājyasya guhyāni jñātuṁ yuṣmabhyamadhikārō dīyatē kintvanyē yathā dr̥ṣṭvāpi na paśyanti śrutvāpi ma budhyantē ca tadarthaṁ tēṣāṁ purastāt tāḥ sarvvāḥ kathā dr̥ṣṭāntēna kathyantē| ");
INSERT INTO saniso_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","dr̥ṣṭāntasyāsyābhiprāyaḥ, īśvarīyakathā bījasvarūpā| ");
INSERT INTO saniso_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","yē kathāmātraṁ śr̥ṇvanti kintu paścād viśvasya yathā paritrāṇaṁ na prāpnuvanti tadāśayēna śaitānētya hr̥dayātr̥ tāṁ kathām apaharati ta ēva mārgapārśvasthabhūmisvarūpāḥ| ");
INSERT INTO saniso_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","yē kathaṁ śrutvā sānandaṁ gr̥hlanti kintvabaddhamūlatvāt svalpakālamātraṁ pratītya parīkṣākālē bhraśyanti taēva pāṣāṇabhūmisvarūpāḥ| ");
INSERT INTO saniso_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","yē kathāṁ śrutvā yānti viṣayacintāyāṁ dhanalōbhēna ēेhikasukhē ca majjanta upayuktaphalāni na phalanti ta ēvōptabījakaṇṭakibhūsvarūpāḥ| ");
INSERT INTO saniso_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","kintu yē śrutvā saralaiḥ śuddhaiścāntaḥkaraṇaiḥ kathāṁ gr̥hlanti dhairyyam avalambya phalānyutpādayanti ca ta ēvōttamamr̥tsvarūpāḥ| ");
INSERT INTO saniso_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","aparañca pradīpaṁ prajvālya kōpi pātrēṇa nācchādayati tathā khaṭvādhōpi na sthāpayati, kintu dīpādhārōparyyēva sthāpayati, tasmāt pravēśakā dīptiṁ paśyanti| ");
INSERT INTO saniso_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","yanna prakāśayiṣyatē tādr̥g aprakāśitaṁ vastu kimapi nāsti yacca na suvyaktaṁ pracārayiṣyatē tādr̥g gr̥ptaṁ vastu kimapi nāsti| ");
INSERT INTO saniso_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","atō yūyaṁ kēna prakārēṇa śr̥ṇutha tatra sāvadhānā bhavata, yasya samīpē barddhatē tasmai punardāsyatē kintu yasyāśrayē na barddhatē tasya yadyadasti tadapi tasmāt nēṣyatē| ");
INSERT INTO saniso_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","aparañca yīśō rmātā bhrātaraśca tasya samīpaṁ jigamiṣavaḥ ");
INSERT INTO saniso_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","kintu janatāsambādhāt tatsannidhiṁ prāptuṁ na śēkuḥ| tatpaścāt tava mātā bhrātaraśca tvāṁ sākṣāt cikīrṣantō bahistiṣṭhanatīti vārttāyāṁ tasmai kathitāyāṁ ");
INSERT INTO saniso_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","sa pratyuvāca; yē janā īśvarasya kathāṁ śrutvā tadanurūpamācaranti taēva mama mātā bhrātaraśca| ");
INSERT INTO saniso_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","anantaraṁ ēkadā yīśuḥ śiṣyaiḥ sārddhaṁ nāvamāruhya jagāda, āyāta vayaṁ hradasya pāraṁ yāmaḥ, tatastē jagmuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","tēṣu naukāṁ vāhayatsu sa nidadrau; ");
INSERT INTO saniso_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","athākasmāt prabalajhañbhśagamād hradē naukāyāṁ taraṅgairācchannāyāṁ vipat tān jagrāsa|tasmād yīśōrantikaṁ gatvā hē gurō hē gurō prāṇā nō yāntīti gaditvā taṁ jāgarayāmbabhūvuḥ|tadā sa utthāya vāyuṁ taraṅgāṁśca tarjayāmāsa tasmādubhau nivr̥tya sthirau babhūvatuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","sa tān babhāṣē yuṣmākaṁ viśvāsaḥ ka? tasmāttē bhītā vismitāśca parasparaṁ jagaduḥ, ahō kīdr̥gayaṁ manujaḥ pavanaṁ pānīyañcādiśati tadubhayaṁ tadādēśaṁ vahati| ");
INSERT INTO saniso_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","tataḥ paraṁ gālīlpradēśasya sammukhasthagidērīyapradēśē naukāyāṁ lagantyāṁ taṭē'varōhamāvād ");
INSERT INTO saniso_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","bahutithakālaṁ bhūtagrasta ēkō mānuṣaḥ purādāgatya taṁ sākṣāccakāra| sa manuṣō vāsō na paridadhat gr̥hē ca na vasan kēvalaṁ śmaśānam adhyuvāsa| ");
INSERT INTO saniso_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","sa yīśuṁ dr̥ṣṭvaiva cīcchabdaṁ cakāra tasya sammukhē patitvā prōccairjagāda ca, hē sarvvapradhānēśvarasya putra, mayā saha tava kaḥ sambandhaḥ? tvayi vinayaṁ karōmi māṁ mā yātaya| ");
INSERT INTO saniso_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","yataḥ sa taṁ mānuṣaṁ tyaktvā yātum amēdhyabhūtam ādidēśa; sa bhūtastaṁ mānuṣam asakr̥d dadhāra tasmāllōkāḥ śr̥ṅkhalēna nigaḍēna ca babandhuḥ; sa tad bhaṁktvā bhūtavaśatvāt madhyēprāntaraṁ yayau| ");
INSERT INTO saniso_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","anantaraṁ yīśustaṁ papraccha tava kinnāma? sa uvāca, mama nāma bāhinō yatō bahavō bhūtāstamāśiśriyuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","atha bhūtā vinayēna jagaduḥ, gabhīraṁ garttaṁ gantuṁ mājñāpayāsmān| ");
INSERT INTO saniso_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","tadā parvvatōpari varāhavrajaścarati tasmād bhūtā vinayēna prōcuḥ, amuṁ varāhavrajam āśrayitum asmān anujānīhi; tataḥ sōnujajñau| ");
INSERT INTO saniso_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","tataḥ paraṁ bhūtāstaṁ mānuṣaṁ vihāya varāhavrajam āśiśriyuḥ varāhavrajāśca tatkṣaṇāt kaṭakēna dhāvantō hradē prāṇān vijr̥huḥ| ");
INSERT INTO saniso_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","tad dr̥ṣṭvā śūkararakṣakāḥ palāyamānā nagaraṁ grāmañca gatvā tatsarvvavr̥ttāntaṁ kathayāmāsuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","tataḥ kiṁ vr̥ttam ētaddarśanārthaṁ lōkā nirgatya yīśōḥ samīpaṁ yayuḥ, taṁ mānuṣaṁ tyaktabhūtaṁ parihitavastraṁ svasthamānuṣavad yīśōścaraṇasannidhau sūpaviśantaṁ vilōkya bibhyuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","yē lōkāstasya bhūtagrastasya svāsthyakaraṇaṁ dadr̥śustē tēbhyaḥ sarvvavr̥ttāntaṁ kathayāmāsuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","tadanantaraṁ tasya gidērīyapradēśasya caturdiksthā bahavō janā atitrastā vinayēna taṁ jagaduḥ, bhavān asmākaṁ nikaṭād vrajatu tasmāt sa nāvamāruhya tatō vyāghuṭya jagāma| ");
INSERT INTO saniso_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","tadānīṁ tyaktabhūtamanujastēna saha sthātuṁ prārthayāñcakrē ");
INSERT INTO saniso_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","kintu tadartham īśvaraḥ kīdr̥ṅmahākarmma kr̥tavān iti nivēśanaṁ gatvā vijñāpaya, yīśuḥ kathāmētāṁ kathayitvā taṁ visasarja| tataḥ sa vrajitvā yīśustadarthaṁ yanmahākarmma cakāra tat purasya sarvvatra prakāśayituṁ prārēbhē| ");
INSERT INTO saniso_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","atha yīśau parāvr̥tyāgatē lōkāstaṁ ādarēṇa jagr̥hu ryasmāttē sarvvē tamapēkṣāñcakrirē| ");
INSERT INTO saniso_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","tadanantaraṁ yāyīrnāmnō bhajanagēhasyaikōdhipa āgatya yīśōścaraṇayōḥ patitvā svanivēśanāgamanārthaṁ tasmin vinayaṁ cakāra, ");
INSERT INTO saniso_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","yatastasya dvādaśavarṣavayaskā kanyaikāsīt sā mr̥takalpābhavat| tatastasya gamanakālē mārgē lōkānāṁ mahān samāgamō babhūva| ");
INSERT INTO saniso_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","dvādaśavarṣāṇi pradararōgagrastā nānā vaidyaiścikitsitā sarvvasvaṁ vyayitvāpi svāsthyaṁ na prāptā yā yōṣit sā yīśōḥ paścādāgatya tasya vastragranthiṁ pasparśa| ");
INSERT INTO saniso_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","tasmāt tatkṣaṇāt tasyā raktasrāvō ruddhaḥ| ");
INSERT INTO saniso_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","tadānīṁ yīśuravadat kēnāhaṁ spr̥ṣṭaḥ? tatō'nēkairanaṅgīkr̥tē pitarastasya saṅginaścāvadan, hē gurō lōkā nikaṭasthāḥ santastava dēhē gharṣayanti, tathāpi kēnāhaṁ spr̥ṣṭa̮iti bhavān kutaḥ pr̥cchati? ");
INSERT INTO saniso_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","yīśuḥ kathayāmāsa, kēnāpyahaṁ spr̥ṣṭō, yatō mattaḥ śakti rnirgatēti mayā niścitamajñāyi| ");
INSERT INTO saniso_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","tadā sā nārī svayaṁ na guptēti viditvā kampamānā satī tasya sammukhē papāta; yēna nimittēna taṁ pasparśa sparśamātrācca yēna prakārēṇa svasthābhavat tat sarvvaṁ tasya sākṣādācakhyau| ");
INSERT INTO saniso_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","tataḥ sa tāṁ jagāda hē kanyē susthirā bhava, tava viśvāsastvāṁ svasthām akārṣīt tvaṁ kṣēmēṇa yāhi| ");
INSERT INTO saniso_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","yīśōrētadvākyavadanakālē tasyādhipatē rnivēśanāt kaścillōka āgatya taṁ babhāṣē, tava kanyā mr̥tā guruṁ mā kliśāna| ");
INSERT INTO saniso_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","kintu yīśustadākarṇyādhipatiṁ vyājahāra, mā bhaiṣīḥ kēvalaṁ viśvasihi tasmāt sā jīviṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","atha tasya nivēśanē prāptē sa pitaraṁ yōhanaṁ yākūbañca kanyāyā mātaraṁ pitarañca vinā, anyaṁ kañcana pravēṣṭuṁ vārayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","aparañca yē rudanti vilapanti ca tān sarvvān janān uvāca, yūyaṁ mā rōdiṣṭa kanyā na mr̥tā nidrāti| ");
INSERT INTO saniso_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","kintu sā niścitaṁ mr̥tēti jñātvā tē tamupajahasuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","paścāt sa sarvvān bahiḥ kr̥tvā kanyāyāḥ karau dhr̥tvājuhuvē, hē kanyē tvamuttiṣṭha, ");
INSERT INTO saniso_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","tasmāt tasyāḥ prāṇēṣu punarāgatēṣu sā tatkṣaṇād uttasyau| tadānīṁ tasyai kiñcid bhakṣyaṁ dātum ādidēśa| ");
INSERT INTO saniso_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","tatastasyāḥ pitarau vismayaṁ gatau kintu sa tāvādidēśa ghaṭanāyā ētasyāḥ kathāṁ kasmaicidapi mā kathayataṁ| ");
INSERT INTO saniso_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","tataḥ paraṁ sa dvādaśaśiṣyānāhūya bhūtān tyājayituṁ rōgān pratikarttuñca tēbhyaḥ śaktimādhipatyañca dadau| ");
INSERT INTO saniso_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","aparañca īśvarīyarājyasya susaṁvādaṁ prakāśayitum rōgiṇāmārōgyaṁ karttuñca prēraṇakālē tān jagāda| ");
INSERT INTO saniso_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","yātrārthaṁ yaṣṭi rvastrapuṭakaṁ bhakṣyaṁ mudrā dvitīyavastram, ēṣāṁ kimapi mā gr̥hlīta| ");
INSERT INTO saniso_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","yūyañca yannivēśanaṁ praviśatha nagaratyāgaparyyanataṁ tannivēśanē tiṣṭhata| ");
INSERT INTO saniso_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","tatra yadi kasyacit purasya lōkā yuṣmākamātithyaṁ na kurvvanti tarhi tasmānnagarād gamanakālē tēṣāṁ viruddhaṁ sākṣyārthaṁ yuṣmākaṁ padadhūlīḥ sampātayata| ");
INSERT INTO saniso_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","atha tē prasthāya sarvvatra susaṁvādaṁ pracārayituṁ pīḍitān svasthān karttuñca grāmēṣu bhramituṁ prārēbhirē| ");
INSERT INTO saniso_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ētarhi hērōd rājā yīśōḥ sarvvakarmmaṇāṁ vārttāṁ śrutvā bhr̥śamudvivijē ");
INSERT INTO saniso_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","yataḥ kēcidūcuryōhan śmaśānādudatiṣṭhat| kēcidūcuḥ, ēliyō darśanaṁ dattavān; ēvamanyalōkā ūcuḥ pūrvvīyaḥ kaścid bhaviṣyadvādī samutthitaḥ| ");
INSERT INTO saniso_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","kintu hērōduvāca yōhanaḥ śirō'hamachinadam idānīṁ yasyēdr̥kkarmmaṇāṁ vārttāṁ prāpnōmi sa kaḥ? atha sa taṁ draṣṭum aicchat| ");
INSERT INTO saniso_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","anantaraṁ prēritāḥ pratyāgatya yāni yāni karmmāṇi cakrustāni yīśavē kathayāmāsuḥ tataḥ sa tān baitsaidānāmakanagarasya vijanaṁ sthānaṁ nītvā guptaṁ jagāma| ");
INSERT INTO saniso_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","paścāl lōkāstad viditvā tasya paścād yayuḥ; tataḥ sa tān nayan īśvarīyarājyasya prasaṅgamuktavān, yēṣāṁ cikitsayā prayōjanam āsīt tān svasthān cakāra ca| ");
INSERT INTO saniso_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","aparañca divāvasannē sati dvādaśaśiṣyā yīśōrantikam ētya kathayāmāsuḥ, vayamatra prāntarasthānē tiṣṭhāmaḥ, tatō nagarāṇi grāmāṇi gatvā vāsasthānāni prāpya bhakṣyadravyāṇi krētuṁ jananivahaṁ bhavān visr̥jatu| ");
INSERT INTO saniso_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","tadā sa uvāca, yūyamēva tān bhējayadhvaṁ; tatastē prōcurasmākaṁ nikaṭē kēvalaṁ pañca pūpā dvau matsyau ca vidyantē, ataēva sthānāntaram itvā nimittamētēṣāṁ bhakṣyadravyēṣu na krītēṣu na bhavati| ");
INSERT INTO saniso_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","tatra prāyēṇa pañcasahasrāṇi puruṣā āsan| ");
INSERT INTO saniso_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","tadā sa śiṣyān jagāda pañcāśat pañcāśajjanaiḥ paṁktīkr̥tya tānupavēśayata, tasmāt tē tadanusārēṇa sarvvalōkānupavēśayāpāsuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","tataḥ sa tān pañca pūpān mīnadvayañca gr̥hītvā svargaṁ vilōkyēśvaraguṇān kīrttayāñcakrē bhaṅktā ca lōkēbhyaḥ parivēṣaṇārthaṁ śiṣyēṣu samarpayāmbabhūva| ");
INSERT INTO saniso_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","tataḥ sarvvē bhuktvā tr̥ptiṁ gatā avaśiṣṭānāñca dvādaśa ḍallakān saṁjagr̥huḥ| ");
INSERT INTO saniso_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","athaikadā nirjanē śiṣyaiḥ saha prārthanākālē tān papraccha, lōkā māṁ kaṁ vadanti? ");
INSERT INTO saniso_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","tatastē prācuḥ, tvāṁ yōhanmajjakaṁ vadanti; kēcit tvām ēliyaṁ vadanti, pūrvvakālikaḥ kaścid bhaviṣyadvādī śmaśānād udatiṣṭhad ityapi kēcid vadanti| ");
INSERT INTO saniso_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","tadā sa uvāca, yūyaṁ māṁ kaṁ vadatha? tataḥ pitara uktavān tvam īśvarābhiṣiktaḥ puruṣaḥ| ");
INSERT INTO saniso_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","tadā sa tān dr̥ḍhamādidēśa, kathāmētāṁ kasmaicidapi mā kathayata| ");
INSERT INTO saniso_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","sa punaruvāca, manuṣyaputrēṇa vahuyātanā bhōktavyāḥ prācīnalōkaiḥ pradhānayājakairadhyāpakaiśca sōvajñāya hantavyaḥ kintu tr̥tīyadivasē śmaśānāt tēnōtthātavyam| ");
INSERT INTO saniso_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","aparaṁ sa sarvvānuvāca, kaścid yadi mama paścād gantuṁ vāñchati tarhi sa svaṁ dāmyatu, dinē dinē kruśaṁ gr̥hītvā ca mama paścādāgacchatu| ");
INSERT INTO saniso_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","yatō yaḥ kaścit svaprāṇān rirakṣiṣati sa tān hārayiṣyati, yaḥ kaścin madarthaṁ prāṇān hārayiṣyati sa tān rakṣiṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","kaścid yadi sarvvaṁ jagat prāpnōti kintu svaprāṇān hārayati svayaṁ vinaśyati ca tarhi tasya kō lābhaḥ? ");
INSERT INTO saniso_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","puna ryaḥ kaścin māṁ mama vākyaṁ vā lajjāspadaṁ jānāti manuṣyaputrō yadā svasya pituśca pavitrāṇāṁ dūtānāñca tējōbhiḥ parivēṣṭita āgamiṣyati tadā sōpi taṁ lajjāspadaṁ jñāsyati| ");
INSERT INTO saniso_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","kintu yuṣmānahaṁ yathārthaṁ vadāmi, īśvarīyarājatvaṁ na dr̥ṣṭavā mr̥tyuṁ nāsvādiṣyantē, ētādr̥śāḥ kiyantō lōkā atra sthanē'pi daṇḍāyamānāḥ santi| ");
INSERT INTO saniso_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ētadākhyānakathanāt paraṁ prāyēṇāṣṭasu dinēṣu gatēṣu sa pitaraṁ yōhanaṁ yākūbañca gr̥hītvā prārthayituṁ parvvatamēkaṁ samārurōha| ");
INSERT INTO saniso_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","atha tasya prārthanakālē tasya mukhākr̥tiranyarūpā jātā, tadīyaṁ vastramujjvalaśuklaṁ jātaṁ| ");
INSERT INTO saniso_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","aparañca mūsā ēliyaścōbhau tējasvinau dr̥ṣṭau ");
INSERT INTO saniso_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","tau tēna yirūśālampurē yō mr̥tyuḥ sādhiṣyatē tadīyāṁ kathāṁ tēna sārddhaṁ kathayitum ārēbhātē| ");
INSERT INTO saniso_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","tadā pitarādayaḥ svasya saṅginō nidrayākr̥ṣṭā āsan kintu jāgaritvā tasya tējastēna sārddham uttiṣṭhantau janau ca dadr̥śuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","atha tayōrubhayō rgamanakālē pitarō yīśuṁ babhāṣē, hē gurō'smākaṁ sthānē'smin sthitiḥ śubhā, tata ēkā tvadarthā, ēkā mūsārthā, ēkā ēliyārthā, iti tisraḥ kuṭyōsmābhi rnirmmīyantāṁ, imāṁ kathāṁ sa na vivicya kathayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","aparañca tadvākyavadanakālē payōda ēka āgatya tēṣāmupari chāyāṁ cakāra, tatastanmadhyē tayōḥ pravēśāt tē śaśaṅkirē| ");
INSERT INTO saniso_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","tadā tasmāt payōdād iyamākāśīyā vāṇī nirjagāma, mamāyaṁ priyaḥ putra ētasya kathāyāṁ manō nidhatta| ");
INSERT INTO saniso_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","iti śabdē jātē tē yīśumēkākinaṁ dadr̥śuḥ kintu tē tadānīṁ tasya darśanasya vācamēkāmapi nōktvā manaḥsu sthāpayāmāsuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","parē'hani tēṣu tasmācchailād avarūḍhēṣu taṁ sākṣāt karttuṁ bahavō lōkā ājagmuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","tēṣāṁ madhyād ēkō jana uccairuvāca, hē gurō ahaṁ vinayaṁ karōmi mama putraṁ prati kr̥pādr̥ṣṭiṁ karōtu, mama sa ēvaikaḥ putraḥ| ");
INSERT INTO saniso_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","bhūtēna dhr̥taḥ san saṁ prasabhaṁ cīcchabdaṁ karōti tanmukhāt phēṇā nirgacchanti ca, bhūta itthaṁ vidāryya kliṣṭvā prāyaśastaṁ na tyajati| ");
INSERT INTO saniso_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","tasmāt taṁ bhūtaṁ tyājayituṁ tava śiṣyasamīpē nyavēdayaṁ kintu tē na śēkuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","tadā yīśuravādīt, rē āviśvāsin vipathagāmin vaṁśa katikālān yuṣmābhiḥ saha sthāsyāmyahaṁ yuṣmākam ācaraṇāni ca sahiṣyē? tava putramihānaya| ");
INSERT INTO saniso_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","tatastasminnāgatamātrē bhūtastaṁ bhūmau pātayitvā vidadāra; tadā yīśustamamēdhyaṁ bhūtaṁ tarjayitvā bālakaṁ svasthaṁ kr̥tvā tasya pitari samarpayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","īśvarasya mahāśaktim imāṁ vilōkya sarvvē camaccakruḥ; itthaṁ yīśōḥ sarvvābhiḥ kriyābhiḥ sarvvairlōkairāścaryyē manyamānē sati sa śiṣyān babhāṣē, ");
INSERT INTO saniso_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","kathēyaṁ yuṣmākaṁ karṇēṣu praviśatu, manuṣyaputrō manuṣyāṇāṁ karēṣu samarpayiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","kintu tē tāṁ kathāṁ na bubudhirē, spaṣṭatvābhāvāt tasyā abhiprāyastēṣāṁ bōdhagamyō na babhūva; tasyā āśayaḥ ka ityapi tē bhayāt praṣṭuṁ na śēkuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","tadanantaraṁ tēṣāṁ madhyē kaḥ śrēṣṭhaḥ kathāmētāṁ gr̥hītvā tē mithō vivādaṁ cakruḥ| ");
INSERT INTO saniso_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","tatō yīśustēṣāṁ manōbhiprāyaṁ viditvā bālakamēkaṁ gr̥hītvā svasya nikaṭē sthāpayitvā tān jagāda, ");
INSERT INTO saniso_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","yō janō mama nāmnāsya bālāsyātithyaṁ vidadhāti sa mamātithyaṁ vidadhāti, yaśca mamātithyaṁ vidadhāti sa mama prērakasyātithyaṁ vidadhāti, yuṣmākaṁ madhyēyaḥ svaṁ sarvvasmāt kṣudraṁ jānītē sa ēva śrēṣṭhō bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","aparañca yōhan vyājahāra hē prabhēा tava nāmnā bhūtān tyājayantaṁ mānuṣam ēkaṁ dr̥ṣṭavantō vayaṁ, kintvasmākam apaścād gāmitvāt taṁ nyaṣēdhām| tadānīṁ yīśuruvāca, ");
INSERT INTO saniso_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","taṁ mā niṣēdhata, yatō yō janōsmākaṁ na vipakṣaḥ sa ēvāsmākaṁ sapakṣō bhavati| ");
INSERT INTO saniso_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","anantaraṁ tasyārōhaṇasamaya upasthitē sa sthiracētā yirūśālamaṁ prati yātrāṁ karttuṁ niścityāgrē dūtān prēṣayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","tasmāt tē gatvā tasya prayōjanīyadravyāṇi saṁgrahītuṁ śōmirōṇīyānāṁ grāmaṁ praviviśuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","kintu sa yirūśālamaṁ nagaraṁ yāti tatō hētō rlōkāstasyātithyaṁ na cakruḥ| ");
INSERT INTO saniso_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ataēva yākūbyōhanau tasya śiṣyau tad dr̥ṣṭvā jagadatuḥ, hē prabhō ēliyō yathā cakāra tathā vayamapi kiṁ gagaṇād āgantum ētān bhasmīkarttuñca vahnimājñāpayāmaḥ? bhavān kimicchati? ");
INSERT INTO saniso_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","kintu sa mukhaṁ parāvartya tān tarjayitvā gaditavān yuṣmākaṁ manōbhāvaḥ kaḥ, iti yūyaṁ na jānītha| ");
INSERT INTO saniso_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","manujasutō manujānāṁ prāṇān nāśayituṁ nāgacchat, kintu rakṣitum āgacchat| paścād itaragrāmaṁ tē yayuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","tadanantaraṁ pathi gamanakālē jana ēkastaṁ babhāṣē, hē prabhō bhavān yatra yāti bhavatā sahāhamapi tatra yāsyāmi| ");
INSERT INTO saniso_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","tadānīṁ yīśustamuvāca, gōmāyūnāṁ garttā āsatē, vihāyasīyavihagāाnāṁ nīḍāni ca santi, kintu mānavatanayasya śiraḥ sthāpayituṁ sthānaṁ nāsti| ");
INSERT INTO saniso_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","tataḥ paraṁ sa itarajanaṁ jagāda, tvaṁ mama paścād ēhi; tataḥ sa uvāca, hē prabhō pūrvvaṁ pitaraṁ śmaśānē sthāpayituṁ māmādiśatu| ");
INSERT INTO saniso_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","tadā yīśuruvāca, mr̥tā mr̥tān śmaśānē sthāpayantu kintu tvaṁ gatvēśvarīyarājyasya kathāṁ pracāraya| ");
INSERT INTO saniso_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","tatōnyaḥ kathayāmāsa, hē prabhō mayāpi bhavataḥ paścād gaṁsyatē, kintu pūrvvaṁ mama nivēśanasya parijanānām anumatiṁ grahītum ahamādiśyai bhavatā| ");
INSERT INTO saniso_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","tadānīṁ yīśustaṁ prōktavān, yō janō lāṅgalē karamarpayitvā paścāt paśyati sa īśvarīyarājyaṁ nārhati| ");
INSERT INTO saniso_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","tataḥ paraṁ prabhuraparān saptatiśiṣyān niyujya svayaṁ yāni nagarāṇi yāni sthānāni ca gamiṣyati tāni nagarāṇi tāni sthānāni ca prati dvau dvau janau prahitavān| ");
INSERT INTO saniso_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","tēbhyaḥ kathayāmāsa ca śasyāni bahūnīti satyaṁ kintu chēdakā alpē; tasmāddhētōḥ śasyakṣētrē chēdakān aparānapi prēṣayituṁ kṣētrasvāminaṁ prārthayadhvaṁ| ");
INSERT INTO saniso_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","yūyaṁ yāta, paśyata, vr̥kāṇāṁ madhyē mēṣaśāvakāniva yuṣmān prahiṇōmi| ");
INSERT INTO saniso_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","yūyaṁ kṣudraṁ mahad vā vasanasampuṭakaṁ pādukāśca mā gr̥hlīta, mārgamadhyē kamapi mā namata ca| ");
INSERT INTO saniso_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","aparañca yūyaṁ yad yat nivēśanaṁ praviśatha tatra nivēśanasyāsya maṅgalaṁ bhūyāditi vākyaṁ prathamaṁ vadata| ");
INSERT INTO saniso_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","tasmāt tasmin nivēśanē yadi maṅgalapātraṁ sthāsyati tarhi tanmaṅgalaṁ tasya bhaviṣyati, nōcēt yuṣmān prati parāvarttiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","aparañca tē yatkiñcid dāsyanti tadēva bhuktvā pītvā tasminnivēśanē sthāsyatha; yataḥ karmmakārī janō bhr̥tim arhati; gr̥hād gr̥haṁ mā yāsyatha| ");
INSERT INTO saniso_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","anyacca yuṣmāsu kimapi nagaraṁ praviṣṭēṣu lōkā yadi yuṣmākam ātithyaṁ kariṣyanti, tarhi yat khādyam upasthāsyanti tadēva khādiṣyatha| ");
INSERT INTO saniso_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","tannagarasthān rōgiṇaḥ svasthān kariṣyatha, īśvarīyaṁ rājyaṁ yuṣmākam antikam āgamat kathāmētāñca pracārayiṣyatha| ");
INSERT INTO saniso_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","kintu kimapi puraṁ yuṣmāsu praviṣṭēṣu lōkā yadi yuṣmākam ātithyaṁ na kariṣyanti, tarhi tasya nagarasya panthānaṁ gatvā kathāmētāṁ vadiṣyatha, ");
INSERT INTO saniso_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","yuṣmākaṁ nagarīyā yā dhūlyō'smāsu samalagan tā api yuṣmākaṁ prātikūlyēna sākṣyārthaṁ sampātayāmaḥ; tathāpīśvararājyaṁ yuṣmākaṁ samīpam āgatam iti niścitaṁ jānīta| ");
INSERT INTO saniso_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","ahaṁ yuṣmabhyaṁ yathārthaṁ kathayāmi, vicāradinē tasya nagarasya daśātaḥ sidōmō daśā sahyā bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","hā hā kōrāsīn nagara, hā hā baitsaidānagara yuvayōrmadhyē yādr̥śāni āścaryyāṇi karmmāṇyakriyanta, tāni karmmāṇi yadi sōrasīdōnō rnagarayōrakāriṣyanta, tadā itō bahudinapūrvvaṁ tannivāsinaḥ śaṇavastrāṇi paridhāya gātrēṣu bhasma vilipya samupaviśya samakhētsyanta| ");
INSERT INTO saniso_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","atō vicāradivasē yuṣmākaṁ daśātaḥ sōrasīdōnnivāsināṁ daśā sahyā bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","hē kapharnāhūm, tvaṁ svargaṁ yāvad unnatā kintu narakaṁ yāvat nyagbhaviṣyasi| ");
INSERT INTO saniso_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","yō janō yuṣmākaṁ vākyaṁ gr̥hlāti sa mamaiva vākyaṁ gr̥hlāti; kiñca yō janō yuṣmākam avajñāṁ karōti sa mamaivāvajñāṁ karōti; yō janō mamāvajñāṁ karōti ca sa matprērakasyaivāvajñāṁ karōti| ");
INSERT INTO saniso_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","atha tē saptatiśiṣyā ānandēna pratyāgatya kathayāmāsuḥ, hē prabhō bhavatō nāmnā bhūtā apyasmākaṁ vaśībhavanti| ");
INSERT INTO saniso_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","tadānīṁ sa tān jagāda, vidyutamiva svargāt patantaṁ śaitānam adarśam| ");
INSERT INTO saniso_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","paśyata sarpān vr̥ścikān ripōḥ sarvvaparākramāṁśca padatalai rdalayituṁ yuṣmabhyaṁ śaktiṁ dadāmi tasmād yuṣmākaṁ kāpi hāni rna bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","bhūtā yuṣmākaṁ vaśībhavanti, ētannimittat mā samullasata, svargē yuṣmākaṁ nāmāni likhitāni santīti nimittaṁ samullasata| ");
INSERT INTO saniso_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","tadghaṭikāyāṁ yīśu rmanasi jātāhlādaḥ kathayāmāsa hē svargapr̥thivyōrēkādhipatē pitastvaṁ jñānavatāṁ viduṣāñca lōkānāṁ purastāt sarvvamētad aprakāśya bālakānāṁ purastāt prākāśaya ētasmāddhētōstvāṁ dhanyaṁ vadāmi, hē pitaritthaṁ bhavatu yad ētadēva tava gōcara uttamam| ");
INSERT INTO saniso_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","pitrā sarvvāṇi mayi samarpitāni pitaraṁ vinā kōpi putraṁ na jānāti kiñca putraṁ vinā yasmai janāya putrastaṁ prakāśitavān tañca vinā kōpi pitaraṁ na jānāti| ");
INSERT INTO saniso_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","tapaḥ paraṁ sa śiṣyān prati parāvr̥tya guptaṁ jagāda, yūyamētāni sarvvāṇi paśyatha tatō yuṣmākaṁ cakṣūṁṣi dhanyāni| ");
INSERT INTO saniso_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","yuṣmānahaṁ vadāmi, yūyaṁ yāni sarvvāṇi paśyatha tāni bahavō bhaviṣyadvādinō bhūpatayaśca draṣṭumicchantōpi draṣṭuṁ na prāpnuvan, yuṣmābhi ryā yāḥ kathāśca śrūyantē tāḥ śrōtumicchantōpi śrōtuṁ nālabhanta| ");
INSERT INTO saniso_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","anantaram ēkō vyavasthāpaka utthāya taṁ parīkṣituṁ papraccha, hē upadēśaka anantāyuṣaḥ prāptayē mayā kiṁ karaṇīyaṁ? ");
INSERT INTO saniso_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","yīśuḥ pratyuvāca, atrārthē vyavasthāyāṁ kiṁ likhitamasti? tvaṁ kīdr̥k paṭhasi? ");
INSERT INTO saniso_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","tataḥ sōvadat, tvaṁ sarvvāntaḥkaraṇaiḥ sarvvaprāṇaiḥ sarvvaśaktibhiḥ sarvvacittaiśca prabhau paramēśvarē prēma kuru, samīpavāsini svavat prēma kuru ca| ");
INSERT INTO saniso_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","tadā sa kathayāmāsa, tvaṁ yathārthaṁ pratyavōcaḥ, ittham ācara tēnaiva jīviṣyasi| ");
INSERT INTO saniso_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","kintu sa janaḥ svaṁ nirddōṣaṁ jñāpayituṁ yīśuṁ papraccha, mama samīpavāsī kaḥ? tatō yīśuḥ pratyuvāca, ");
INSERT INTO saniso_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ēkō janō yirūśālampurād yirīhōpuraṁ yāti, ētarhi dasyūnāṁ karēṣu patitē tē tasya vastrādikaṁ hr̥tavantaḥ tamāhatya mr̥taprāyaṁ kr̥tvā tyaktvā yayuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","akasmād ēkō yājakastēna mārgēṇa gacchan taṁ dr̥ṣṭvā mārgānyapārśvēna jagāma| ");
INSERT INTO saniso_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ittham ēkō lēvīyastatsthānaṁ prāpya tasyāntikaṁ gatvā taṁ vilōkyānyēna pārśvēna jagāma| ");
INSERT INTO saniso_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","kintvēkaḥ śōmirōṇīyō gacchan tatsthānaṁ prāpya taṁ dr̥ṣṭvādayata| ");
INSERT INTO saniso_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","tasyāntikaṁ gatvā tasya kṣatēṣu tailaṁ drākṣārasañca prakṣipya kṣatāni baddhvā nijavāhanōpari tamupavēśya pravāsīyagr̥ham ānīya taṁ siṣēvē| ");
INSERT INTO saniso_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","parasmin divasē nijagamanakālē dvau mudrāpādau tadgr̥hasvāminē dattvāvadat janamēnaṁ sēvasva tatra yō'dhikō vyayō bhaviṣyati tamahaṁ punarāgamanakālē pariśōtsyāmi| ");
INSERT INTO saniso_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","ēṣāṁ trayāṇāṁ madhyē tasya dasyuhastapatitasya janasya samīpavāsī kaḥ? tvayā kiṁ budhyatē? ");
INSERT INTO saniso_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","tataḥ sa vyavasthāpakaḥ kathayāmāsa yastasmin dayāṁ cakāra| tadā yīśuḥ kathayāmāsa tvamapi gatvā tathācara| ");
INSERT INTO saniso_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","tataḥ paraṁ tē gacchanta ēkaṁ grāmaṁ praviviśuḥ; tadā marthānāmā strī svagr̥hē tasyātithyaṁ cakāra| ");
INSERT INTO saniso_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","tasmāt mariyam nāmadhēyā tasyā bhaginī yīśōḥ padasamīpa uvaviśya tasyōpadēśakathāṁ śrōtumārēbhē| ");
INSERT INTO saniso_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","kintu marthā nānāparicaryyāyāṁ vyagrā babhūva tasmāddhētōstasya samīpamāgatya babhāṣē; hē prabhō mama bhaginī kēvalaṁ mamōpari sarvvakarmmaṇāṁ bhāram arpitavatī tatra bhavatā kiñcidapi na manō nidhīyatē kim? mama sāhāyyaṁ karttuṁ bhavān tāmādiśatu| ");
INSERT INTO saniso_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","tatō yīśuḥ pratyuvāca hē marthē hē marthē, tvaṁ nānākāryyēṣu cintitavatī vyagrā cāsi, ");
INSERT INTO saniso_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","kintu prayōjanīyam ēkamātram āstē| aparañca yamuttamaṁ bhāgaṁ kōpi harttuṁ na śaknōti saēva mariyamā vr̥taḥ| ");
INSERT INTO saniso_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","anantaraṁ sa kasmiṁścit sthānē prārthayata tatsamāptau satyāṁ tasyaikaḥ śiṣyastaṁ jagāda hē prabhō yōhan yathā svaśiṣyān prārthayitum upadiṣṭavān tathā bhavānapyasmān upadiśatu| ");
INSERT INTO saniso_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","tasmāt sa kathayāmāsa, prārthanakālē yūyam itthaṁ kathayadhvaṁ, hē asmākaṁ svargasthapitastava nāma pūjyaṁ bhavatu; tava rājatvaṁ bhavatu; svargē yathā tathā pr̥thivyāmapi tavēcchayā sarvvaṁ bhavatu| ");
INSERT INTO saniso_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","pratyaham asmākaṁ prayōjanīyaṁ bhōjyaṁ dēhi| ");
INSERT INTO saniso_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","yathā vayaṁ sarvvān aparādhinaḥ kṣamāmahē tathā tvamapi pāpānyasmākaṁ kṣamasva| asmān parīkṣāṁ mānaya kintu pāpātmanō rakṣa| ");
INSERT INTO saniso_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","paścāt sōparamapi kathitavān yadi yuṣmākaṁ kasyacid bandhustiṣṭhati niśīthē ca tasya samīpaṁ sa gatvā vadati, ");
INSERT INTO saniso_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","hē bandhō pathika ēkō bandhu rmama nivēśanam āyātaḥ kintu tasyātithyaṁ karttuṁ mamāntikē kimapi nāsti, ataēva pūpatrayaṁ mahyam r̥ṇaṁ dēhi; ");
INSERT INTO saniso_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","tadā sa yadi gr̥hamadhyāt prativadati māṁ mā kliśāna, idānīṁ dvāraṁ ruddhaṁ śayanē mayā saha bālakāśca tiṣṭhanti tubhyaṁ dātum utthātuṁ na śaknōmi, ");
INSERT INTO saniso_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","tarhi yuṣmānahaṁ vadāmi, sa yadi mitratayā tasmai kimapi dātuṁ nōttiṣṭhati tathāpi vāraṁ vāraṁ prārthanāta utthāpitaḥ san yasmin tasya prayōjanaṁ tadēva dāsyati| ");
INSERT INTO saniso_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","ataḥ kāraṇāt kathayāmi, yācadhvaṁ tatō yuṣmabhyaṁ dāsyatē, mr̥gayadhvaṁ tata uddēśaṁ prāpsyatha, dvāram āhata tatō yuṣmabhyaṁ dvāraṁ mōkṣyatē| ");
INSERT INTO saniso_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","yō yācatē sa prāpnōti, yō mr̥gayatē sa ēvōddēśaṁ prāpnōti, yō dvāram āhanti tadarthaṁ dvāraṁ mōcyatē| ");
INSERT INTO saniso_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","putrēṇa pūpē yācitē tasmai pāṣāṇaṁ dadāti vā matsyē yācitē tasmai sarpaṁ dadāti ");
INSERT INTO saniso_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","vā aṇḍē yācitē tasmai vr̥ścikaṁ dadāti yuṣmākaṁ madhyē ka ētādr̥śaḥ pitāstē? ");
INSERT INTO saniso_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","tasmādēva yūyamabhadrā api yadi svasvabālakēbhya uttamāni dravyāṇi dātuṁ jānītha tarhyasmākaṁ svargasthaḥ pitā nijayācakēbhyaḥ kiṁ pavitram ātmānaṁ na dāsyati? ");
INSERT INTO saniso_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","anantaraṁ yīśunā kasmāccid ēkasmin mūkabhūtē tyājitē sati sa bhūtatyaktō mānuṣō vākyaṁ vaktum ārēbhē; tatō lōkāḥ sakalā āścaryyaṁ mēnirē| ");
INSERT INTO saniso_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","kintu tēṣāṁ kēcidūcu rjanōyaṁ bālasibūbā arthād bhūtarājēna bhūtān tyājayati| ");
INSERT INTO saniso_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","taṁ parīkṣituṁ kēcid ākāśīyam ēkaṁ cihnaṁ darśayituṁ taṁ prārthayāñcakrirē| ");
INSERT INTO saniso_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","tadā sa tēṣāṁ manaḥkalpanāṁ jñātvā kathayāmāsa, kasyacid rājyasya lōkā yadi parasparaṁ virundhanti tarhi tad rājyam naśyati; kēcid gr̥hasthā yadi parasparaṁ virundhanti tarhi tēpi naśyanti| ");
INSERT INTO saniso_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","tathaiva śaitānapi svalōkān yadi viruṇaddhi tadā tasya rājyaṁ kathaṁ sthāsyati? bālasibūbāhaṁ bhūtān tyājayāmi yūyamiti vadatha| ");
INSERT INTO saniso_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","yadyahaṁ bālasibūbā bhūtān tyājayāmi tarhi yuṣmākaṁ santānāḥ kēna tyājayanti? tasmāt taēva kathāyā ētasyā vicārayitārō bhaviṣyanti| ");
INSERT INTO saniso_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","kintu yadyaham īśvarasya parākramēṇa bhūtān tyājayāmi tarhi yuṣmākaṁ nikaṭam īśvarasya rājyamavaśyam upatiṣṭhati| ");
INSERT INTO saniso_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","balavān pumān susajjamānō yatikālaṁ nijāṭṭālikāṁ rakṣati tatikālaṁ tasya dravyaṁ nirupadravaṁ tiṣṭhati| ");
INSERT INTO saniso_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","kintu tasmād adhikabalaḥ kaścidāgatya yadi taṁ jayati tarhi yēṣu śastrāstrēṣu tasya viśvāsa āsīt tāni sarvvāṇi hr̥tvā tasya dravyāṇi gr̥hlāti| ");
INSERT INTO saniso_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","ataḥ kāraṇād yō mama sapakṣō na sa vipakṣaḥ, yō mayā saha na saṁgr̥hlāti sa vikirati| ");
INSERT INTO saniso_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","aparañca amēdhyabhūtō mānuṣasyāntarnirgatya śuṣkasthānē bhrāntvā viśrāmaṁ mr̥gayatē kintu na prāpya vadati mama yasmād gr̥hād āgatōhaṁ punastad gr̥haṁ parāvr̥tya yāmi| ");
INSERT INTO saniso_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","tatō gatvā tad gr̥haṁ mārjitaṁ śōbhitañca dr̥ṣṭvā ");
INSERT INTO saniso_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","tatkṣaṇam apagatya svasmādapi durmmatīn aparān saptabhūtān sahānayati tē ca tadgr̥haṁ paviśya nivasanti| tasmāt tasya manuṣyasya prathamadaśātaḥ śēṣadaśā duḥkhatarā bhavati| ");
INSERT INTO saniso_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","asyāḥ kathāyāḥ kathanakālē janatāmadhyasthā kācinnārī tamuccaiḥsvaraṁ prōvāca, yā yōṣit tvāṁ garbbhē'dhārayat stanyamapāyayacca saiva dhanyā| ");
INSERT INTO saniso_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","kintu sōkathayat yē paramēśvarasya kathāṁ śrutvā tadanurūpam ācaranti taēva dhanyāḥ| ");
INSERT INTO saniso_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","tataḥ paraṁ tasyāntikē bahulōkānāṁ samāgamē jātē sa vaktumārēbhē, ādhunikā duṣṭalōkāścihnaṁ draṣṭumicchanti kintu yūnasbhaviṣyadvādinaścihnaṁ vinānyat kiñciccihnaṁ tān na darśayiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","yūnas tu yathā nīnivīyalōkānāṁ samīpē cihnarūpōbhavat tathā vidyamānalōkānām ēṣāṁ samīpē manuṣyaputrōpi cihnarūpō bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","vicārasamayē idānīntanalōkānāṁ prātikūlyēna dakṣiṇadēśīyā rājñī prōtthāya tān dōṣiṇaḥ kariṣyati, yataḥ sā rājñī sulēmāna upadēśakathāṁ śrōtuṁ pr̥thivyāḥ sīmāta āgacchat kintu paśyata sulēmānōpi gurutara ēkō janō'smin sthānē vidyatē| ");
INSERT INTO saniso_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","aparañca vicārasamayē nīnivīyalōkā api varttamānakālikānāṁ lōkānāṁ vaiparītyēna prōtthāya tān dōṣiṇaḥ kariṣyanti, yatō hētōstē yūnasō vākyāt cittāni parivarttayāmāsuḥ kintu paśyata yūnasōtigurutara ēkō janō'smin sthānē vidyatē| ");
INSERT INTO saniso_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","pradīpaṁ prajvālya drōṇasyādhaḥ kutrāpi guptasthānē vā kōpi na sthāpayati kintu gr̥hapravēśibhyō dīptiṁ dātaṁ dīpādhārōparyyēva sthāpayati| ");
INSERT INTO saniso_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","dēhasya pradīpaścakṣustasmādēva cakṣu ryadi prasannaṁ bhavati tarhi tava sarvvaśarīraṁ dīptimad bhaviṣyati kintu cakṣu ryadi malīmasaṁ tiṣṭhati tarhi sarvvaśarīraṁ sāndhakāraṁ sthāsyati| ");
INSERT INTO saniso_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","asmāt kāraṇāt tavāntaḥsthaṁ jyōti ryathāndhakāramayaṁ na bhavati tadarthē sāvadhānō bhava| ");
INSERT INTO saniso_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","yataḥ śarīrasya kutrāpyaṁśē sāndhakārē na jātē sarvvaṁ yadi dīptimat tiṣṭhati tarhi tubhyaṁ dīptidāyiprōjjvalan pradīpa iva tava savarvaśarīraṁ dīptimad bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ētatkathāyāḥ kathanakālē phiruśyēkō bhējanāya taṁ nimantrayāmāsa, tataḥ sa gatvā bhōktum upavivēśa| ");
INSERT INTO saniso_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","kintu bhōjanāt pūrvvaṁ nāmāṅkṣīt ētad dr̥ṣṭvā sa phiruśyāścaryyaṁ mēnē| ");
INSERT INTO saniso_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","tadā prabhustaṁ prōvāca yūyaṁ phirūśilōkāḥ pānapātrāṇāṁ bhōjanapātrāṇāñca bahiḥ pariṣkurutha kintu yuṣmākamanta rdaurātmyai rduṣkriyābhiśca paripūrṇaṁ tiṣṭhati| ");
INSERT INTO saniso_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","hē sarvvē nirbōdhā yō bahiḥ sasarja sa ēva kimanta rna sasarja? ");
INSERT INTO saniso_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","tata ēva yuṣmābhirantaḥkaraṇaṁ (īśvarāya) nivēdyatāṁ tasmin kr̥tē yuṣmākaṁ sarvvāṇi śucitāṁ yāsyanti| ");
INSERT INTO saniso_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","kintu hanta phirūśigaṇā yūyaṁ nyāyam īśvarē prēma ca parityajya pōdināyā arudādīnāṁ sarvvēṣāṁ śākānāñca daśamāṁśān dattha kintu prathamaṁ pālayitvā śēṣasyālaṅghanaṁ yuṣmākam ucitamāsīt| ");
INSERT INTO saniso_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","hā hā phirūśinō yūyaṁ bhajanagēhē prōccāsanē āpaṇēṣu ca namaskārēṣu prīyadhvē| ");
INSERT INTO saniso_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","vata kapaṭinō'dhyāpakāḥ phirūśinaśca lōkāyat śmaśānam anupalabhya tadupari gacchanti yūyam tādr̥gaprakāśitaśmaśānavād bhavatha| ");
INSERT INTO saniso_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","tadānīṁ vyavasthāpakānām ēkā yīśumavadat, hē upadēśaka vākyēnēdr̥śēnāsmāsvapi dōṣam ārōpayasi| ");
INSERT INTO saniso_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","tataḥ sa uvāca, hā hā vyavasthāpakā yūyam mānuṣāṇām upari duḥsahyān bhārān nyasyatha kintu svayam ēkāṅguुlyāpi tān bhārān na spr̥śatha| ");
INSERT INTO saniso_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","hanta yuṣmākaṁ pūrvvapuruṣā yān bhaviṣyadvādinō'vadhiṣustēṣāṁ śmaśānāni yūyaṁ nirmmātha| ");
INSERT INTO saniso_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","tēnaiva yūyaṁ svapūrvvapuruṣāṇāṁ karmmāṇi saṁmanyadhvē tadēva sapramāṇaṁ kurutha ca, yatastē tānavadhiṣuḥ yūyaṁ tēṣāṁ śmaśānāni nirmmātha| ");
INSERT INTO saniso_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ataēva īśvarasya śāstrē prōktamasti tēṣāmantikē bhaviṣyadvādinaḥ prēritāṁśca prēṣayiṣyāmi tatastē tēṣāṁ kāṁścana haniṣyanti kāṁścana tāḍaśṣyinti| ");
INSERT INTO saniso_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ētasmāt kāraṇāt hābilaḥ śōṇitapātamārabhya mandirayajñavēdyō rmadhyē hatasya sikhariyasya raktapātaparyyantaṁ ");
INSERT INTO saniso_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","jagataḥ sr̥ṣṭimārabhya pr̥thivyāṁ bhaviṣyadvādināṁ yatiraktapātā jātāstatīnām aparādhadaṇḍā ēṣāṁ varttamānalōkānāṁ bhaviṣyanti, yuṣmānahaṁ niścitaṁ vadāmi sarvvē daṇḍā vaṁśasyāsya bhaviṣyanti| ");
INSERT INTO saniso_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","hā hā vyavasthapakā yūyaṁ jñānasya kuñcikāṁ hr̥tvā svayaṁ na praviṣṭā yē pravēṣṭuñca prayāsinastānapi pravēṣṭuṁ vāritavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","itthaṁ kathākathanād adhyāpakāḥ phirūśinaśca satarkāḥ ");
INSERT INTO saniso_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","santastamapavadituṁ tasya kathāyā dōṣaṁ dharttamicchantō nānākhyānakathanāya taṁ pravarttayituṁ kōpayituñca prārēbhirē| ");
INSERT INTO saniso_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","tadānīṁ lōkāḥ sahasraṁ sahasram āgatya samupasthitāstata ēkaikō 'nyēṣāmupari patitum upacakramē; tadā yīśuḥ śiṣyān babhāṣē, yūyaṁ phirūśināṁ kiṇvarūpakāpaṭyē viśēṣēṇa sāvadhānāstiṣṭhata| ");
INSERT INTO saniso_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","yatō yanna prakāśayiṣyatē tadācchannaṁ vastu kimapi nāsti; tathā yanna jñāsyatē tad guptaṁ vastu kimapi nāsti| ");
INSERT INTO saniso_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","andhakārē tiṣṭhanatō yāḥ kathā akathayata tāḥ sarvvāḥ kathā dīptau śrōṣyantē nirjanē karṇē ca yadakathayata gr̥hapr̥ṣṭhāt tat pracārayiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","hē bandhavō yuṣmānahaṁ vadāmi, yē śarīrasya nāśaṁ vinā kimapyaparaṁ karttuṁ na śakruvanti tēbhyō mā bhaiṣṭa| ");
INSERT INTO saniso_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","tarhi kasmād bhētavyam ityahaṁ vadāmi, yaḥ śarīraṁ nāśayitvā narakaṁ nikṣēptuṁ śaknōti tasmādēva bhayaṁ kuruta, punarapi vadāmi tasmādēva bhayaṁ kuruta| ");
INSERT INTO saniso_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","pañca caṭakapakṣiṇaḥ kiṁ dvābhyāṁ tāmrakhaṇḍābhyāṁ na vikrīyantē? tathāpīśvarastēṣām ēkamapi na vismarati| ");
INSERT INTO saniso_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","yuṣmākaṁ śiraḥkēśā api gaṇitāḥ santi tasmāt mā vibhīta bahucaṭakapakṣibhyōpi yūyaṁ bahumūlyāḥ| ");
INSERT INTO saniso_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","aparaṁ yuṣmabhyaṁ kathayāmi yaḥ kaścin mānuṣāṇāṁ sākṣān māṁ svīkarōti manuṣyaputra īśvaradūtānāṁ sākṣāt taṁ svīkariṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","kintu yaḥ kaścinmānuṣāṇāṁ sākṣānmām asvīkarōti tam īśvarasya dūtānāṁ sākṣād aham asvīkariṣyāmi| ");
INSERT INTO saniso_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","anyacca yaḥ kaścin manujasutasya nindābhāvēna kāñcit kathāṁ kathayati tasya tatpāpasya mōcanaṁ bhaviṣyati kintu yadi kaścit pavitram ātmānaṁ nindati tarhi tasya tatpāpasya mōcanaṁ na bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","yadā lōkā yuṣmān bhajanagēhaṁ vicārakartr̥rājyakartr̥ṇāṁ sammukhañca nēṣyanti tadā kēna prakārēṇa kimuttaraṁ vadiṣyatha kiṁ kathayiṣyatha cētyatra mā cintayata; ");
INSERT INTO saniso_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","yatō yuṣmābhiryad yad vaktavyaṁ tat tasmin samayaēva pavitra ātmā yuṣmān śikṣayiṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","tataḥ paraṁ janatāmadhyasthaḥ kaścijjanastaṁ jagāda hē gurō mayā saha paitr̥kaṁ dhanaṁ vibhaktuṁ mama bhrātaramājñāpayatu bhavān| ");
INSERT INTO saniso_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","kintu sa tamavadat hē manuṣya yuvayō rvicāraṁ vibhāgañca karttuṁ māṁ kō niyuktavān? ");
INSERT INTO saniso_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","anantaraṁ sa lōkānavadat lōbhē sāvadhānāḥ satarkāśca tiṣṭhata, yatō bahusampattiprāptyā manuṣyasyāyu rna bhavati| ");
INSERT INTO saniso_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","paścād dr̥ṣṭāntakathāmutthāpya kathayāmāsa, ēkasya dhaninō bhūmau bahūni śasyāni jātāni| ");
INSERT INTO saniso_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","tataḥ sa manasā cintayitvā kathayāmbabhūva mamaitāni samutpannāni dravyāṇi sthāpayituṁ sthānaṁ nāsti kiṁ kariṣyāmi? ");
INSERT INTO saniso_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","tatōvadad itthaṁ kariṣyāmi, mama sarvvabhāṇḍāgārāṇi bhaṅktvā br̥hadbhāṇḍāgārāṇi nirmmāya tanmadhyē sarvvaphalāni dravyāṇi ca sthāpayiṣyāmi| ");
INSERT INTO saniso_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","aparaṁ nijamanō vadiṣyāmi, hē manō bahuvatsarārthaṁ nānādravyāṇi sañcitāni santi viśrāmaṁ kuru bhuktvā pītvā kautukañca kuru| kintvīśvarastam avadat, ");
INSERT INTO saniso_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","rē nirbōdha adya rātrau tava prāṇāstvattō nēṣyantē tata ētāni yāni dravyāṇi tvayāsāditāni tāni kasya bhaviṣyanti? ");
INSERT INTO saniso_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","ataēva yaḥ kaścid īśvarasya samīpē dhanasañcayamakr̥tvā kēvalaṁ svanikaṭē sañcayaṁ karōti sōpi tādr̥śaḥ| ");
INSERT INTO saniso_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","atha sa śiṣyēbhyaḥ kathayāmāsa, yuṣmānahaṁ vadāmi, kiṁ khādiṣyāmaḥ? kiṁ paridhāsyāmaḥ? ityuktvā jīvanasya śarīrasya cārthaṁ cintāṁ mā kārṣṭa| ");
INSERT INTO saniso_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","bhakṣyājjīvanaṁ bhūṣaṇāccharīrañca śrēṣṭhaṁ bhavati| ");
INSERT INTO saniso_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","kākapakṣiṇāṁ kāryyaṁ vicārayata, tē na vapanti śasyāni ca na chindanti, tēṣāṁ bhāṇḍāgārāṇi na santi kōṣāśca na santi, tathāpīśvarastēbhyō bhakṣyāṇi dadāti, yūyaṁ pakṣibhyaḥ śrēṣṭhatarā na kiṁ? ");
INSERT INTO saniso_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","aparañca bhāvayitvā nijāyuṣaḥ kṣaṇamātraṁ varddhayituṁ śaknōti, ētādr̥śō lākō yuṣmākaṁ madhyē kōsti? ");
INSERT INTO saniso_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","ataēva kṣudraṁ kāryyaṁ sādhayitum asamarthā yūyam anyasmin kāryyē kutō bhāvayatha? ");
INSERT INTO saniso_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","anyacca kāmpilapuṣpaṁ kathaṁ varddhatē tadāpi vicārayata, tat kañcana śramaṁ na karōti tantūṁśca na janayati kintu yuṣmabhyaṁ yathārthaṁ kathayāmi sulēmān bahvaiśvaryyānvitōpi puṣpasyāsya sadr̥śō vibhūṣitō nāsīt| ");
INSERT INTO saniso_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","adya kṣētrē varttamānaṁ śvaścūllyāṁ kṣēpsyamānaṁ yat tr̥ṇaṁ, tasmai yadīśvara itthaṁ bhūṣayati tarhi hē alpapratyayinō yuṣmāna kiṁ na paridhāpayiṣyati? ");
INSERT INTO saniso_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","ataēva kiṁ khādiṣyāmaḥ? kiṁ paridhāsyāmaḥ? ētadarthaṁ mā cēṣṭadhvaṁ mā saṁdigdhvañca| ");
INSERT INTO saniso_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","jagatō dēvārccakā ētāni sarvvāṇi cēṣṭanatē; ēṣu vastuṣu yuṣmākaṁ prayōjanamāstē iti yuṣmākaṁ pitā jānāti| ");
INSERT INTO saniso_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","ataēvēśvarasya rājyārthaṁ sacēṣṭā bhavata tathā kr̥tē sarvvāṇyētāni dravyāṇi yuṣmabhyaṁ pradāyiṣyantē| ");
INSERT INTO saniso_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","hē kṣudramēṣavraja yūyaṁ mā bhaiṣṭa yuṣmabhyaṁ rājyaṁ dātuṁ yuṣmākaṁ pituḥ sammatirasti| ");
INSERT INTO saniso_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ataēva yuṣmākaṁ yā yā sampattirasti tāṁ tāṁ vikrīya vitarata, yat sthānaṁ caurā nāgacchanti, kīṭāśca na kṣāyayanti tādr̥śē svargē nijārtham ajarē sampuṭakē 'kṣayaṁ dhanaṁ sañcinuta ca; ");
INSERT INTO saniso_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","yatō yatra yuṣmākaṁ dhanaṁ varttatē tatrēva yuṣmākaṁ manaḥ| ");
INSERT INTO saniso_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","aparañca yūyaṁ pradīpaṁ jvālayitvā baddhakaṭayastiṣṭhata; ");
INSERT INTO saniso_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","prabhu rvivāhādāgatya yadaiva dvāramāhanti tadaiva dvāraṁ mōcayituṁ yathā bhr̥tyā apēkṣya tiṣṭhanti tathā yūyamapi tiṣṭhata| ");
INSERT INTO saniso_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","yataḥ prabhurāgatya yān dāsān sacētanān tiṣṭhatō drakṣyati taēva dhanyāḥ; ahaṁ yuṣmān yathārthaṁ vadāmi prabhustān bhōjanārtham upavēśya svayaṁ baddhakaṭiḥ samīpamētya parivēṣayiṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","yadi dvitīyē tr̥tīyē vā praharē samāgatya tathaiva paśyati, tarhi taēva dāsā dhanyāḥ| ");
INSERT INTO saniso_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","aparañca kasmin kṣaṇē caurā āgamiṣyanti iti yadi gr̥hapati rjñātuṁ śaknōti tadāvaśyaṁ jāgran nijagr̥hē sandhiṁ karttayituṁ vārayati yūyamētad vitta| ");
INSERT INTO saniso_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","ataēva yūyamapi sajjamānāstiṣṭhata yatō yasmin kṣaṇē taṁ nāprēkṣadhvē tasminnēva kṣaṇē manuṣyaputra āgamiṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","tadā pitaraḥ papraccha, hē prabhō bhavān kimasmān uddiśya kiṁ sarvvān uddiśya dr̥ṣṭāntakathāmimāṁ vadati? ");
INSERT INTO saniso_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","tataḥ prabhuḥ prōvāca, prabhuḥ samucitakālē nijaparivārārthaṁ bhōjyaparivēṣaṇāya yaṁ tatpadē niyōkṣyati tādr̥śō viśvāsyō bōddhā karmmādhīśaḥ kōsti? ");
INSERT INTO saniso_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","prabhurāgatya yam ētādr̥śē karmmaṇi pravr̥ttaṁ drakṣyati saēva dāsō dhanyaḥ| ");
INSERT INTO saniso_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ahaṁ yuṣmān yathārthaṁ vadāmi sa taṁ nijasarvvasvasyādhipatiṁ kariṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","kintu prabhurvilambēnāgamiṣyati, iti vicintya sa dāsō yadi tadanyadāsīdāsān praharttum bhōktuṁ pātuṁ madituñca prārabhatē, ");
INSERT INTO saniso_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","tarhi yadā prabhuṁ nāpēkṣiṣyatē yasmin kṣaṇē sō'cētanaśca sthāsyati tasminnēva kṣaṇē tasya prabhurāgatya taṁ padabhraṣṭaṁ kr̥tvā viśvāsahīnaiḥ saha tasya aṁśaṁ nirūpayiṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","yō dāsaḥ prabhēाrājñāṁ jñātvāpi sajjitō na tiṣṭhati tadājñānusārēṇa ca kāryyaṁ na karōti sōnēkān prahārān prāpsyati; ");
INSERT INTO saniso_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","kintu yō janō'jñātvā prahārārhaṁ karmma karōti sōlpaprahārān prāpsyati| yatō yasmai bāhulyēna dattaṁ tasmādēva bāhulyēna grahīṣyatē, mānuṣā yasya nikaṭē bahu samarpayanti tasmād bahu yācantē| ");
INSERT INTO saniso_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","ahaṁ pr̥thivyām anaikyarūpaṁ vahni nikṣēptum āgatōsmi, sa cēd idānīmēva prajvalati tatra mama kā cintā? ");
INSERT INTO saniso_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","kintu yēna majjanēnāhaṁ magnō bhaviṣyāmi yāvatkālaṁ tasya siddhi rna bhaviṣyati tāvadahaṁ katikaṣṭaṁ prāpsyāmi| ");
INSERT INTO saniso_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","mēlanaṁ karttuṁ jagad āgatōsmi yūyaṁ kimitthaṁ bōdhadhvē? yuṣmān vadāmi na tathā, kintvahaṁ mēlanābhāvaṁ karttuṁm āgatōsmi| ");
INSERT INTO saniso_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","yasmādētatkālamārabhya ēkatrasthaparijanānāṁ madhyē pañcajanāḥ pr̥thag bhūtvā trayō janā dvayōrjanayōḥ pratikūlā dvau janau ca trayāṇāṁ janānāṁ pratikūlau bhaviṣyanti| ");
INSERT INTO saniso_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","pitā putrasya vipakṣaḥ putraśca pitu rvipakṣō bhaviṣyati mātā kanyāyā vipakṣā kanyā ca mātu rvipakṣā bhaviṣyati, tathā śvaśrūrbadhvā vipakṣā badhūśca śvaśrvā vipakṣā bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","sa lōkēbhyōparamapi kathayāmāsa, paścimadiśi mēghōdgamaṁ dr̥ṣṭvā yūyaṁ haṭhād vadatha vr̥ṣṭi rbhaviṣyati tatastathaiva jāyatē| ");
INSERT INTO saniso_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","aparaṁ dakṣiṇatō vāyau vāti sati vadatha nidāghō bhaviṣyati tataḥ sōpi jāyatē| ");
INSERT INTO saniso_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","rē rē kapaṭina ākāśasya bhūmyāśca lakṣaṇaṁ bōddhuṁ śaknutha, ");
INSERT INTO saniso_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","kintu kālasyāsya lakṣaṇaṁ kutō bōddhuṁ na śaknutha? yūyañca svayaṁ kutō na nyāṣyaṁ vicārayatha? ");
INSERT INTO saniso_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","aparañca vivādinā sārddhaṁ vicārayituḥ samīpaṁ gacchan pathi tasmāduddhāraṁ prāptuṁ yatasva nōcēt sa tvāṁ dhr̥tvā vicārayituḥ samīpaṁ nayati| vicārayitā yadi tvāṁ praharttuḥ samīpaṁ samarpayati praharttā tvāṁ kārāyāṁ badhnāti ");
INSERT INTO saniso_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","tarhi tvāmahaṁ vadāmi tvayā niḥśēṣaṁ kapardakēṣu na pariśōdhitēṣu tvaṁ tatō muktiṁ prāptuṁ na śakṣyasi| ");
INSERT INTO saniso_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","aparañca pīlātō yēṣāṁ gālīlīyānāṁ raktāni balīnāṁ raktaiḥ sahāmiśrayat tēṣāṁ gālīlīyānāṁ vr̥ttāntaṁ katipayajanā upasthāpya yīśavē kathayāmāsuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","tataḥ sa pratyuvāca tēṣāṁ lōkānām ētādr̥śī durgati rghaṭitā tatkāraṇād yūyaṁ kimanyēbhyō gālīlīyēbhyōpyadhikapāpinastān bōdhadhvē? ");
INSERT INTO saniso_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","yuṣmānahaṁ vadāmi tathā na kintu manaḥsu na parāvarttitēṣu yūyamapi tathā naṁkṣyatha| ");
INSERT INTO saniso_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","aparañca śīlōhanāmna uccagr̥hasya patanād yē'ṣṭādaśajanā mr̥tāstē yirūśālami nivāsisarvvalōkēbhyō'dhikāparādhinaḥ kiṁ yūyamityaṁ bōdhadhvē? ");
INSERT INTO saniso_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","yuṣmānahaṁ vadāmi tathā na kintu manaḥsu na parivarttitēṣu yūyamapi tathā naṁkṣyatha| ");
INSERT INTO saniso_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","anantaraṁ sa imāṁ dr̥ṣṭāntakathāmakathayad ēkō janō drākṣākṣētramadhya ēkamuḍumbaravr̥kṣaṁ rōpitavān| paścāt sa āgatya tasmin phalāni gavēṣayāmāsa, ");
INSERT INTO saniso_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","kintu phalāprāptēḥ kāraṇād udyānakāraṁ bhr̥tyaṁ jagāda, paśya vatsaratrayaṁ yāvadāgatya ētasminnuḍumbaratarau kṣalānyanvicchāmi, kintu naikamapi prapnōmi tarurayaṁ kutō vr̥thā sthānaṁ vyāpya tiṣṭhati? ēnaṁ chindhi| ");
INSERT INTO saniso_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","tatō bhr̥tyaḥ pratyuvāca, hē prabhō punarvarṣamēkaṁ sthātum ādiśa; ētasya mūlasya caturdikṣu khanitvāham ālavālaṁ sthāpayāmi| ");
INSERT INTO saniso_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","tataḥ phalituṁ śaknōti yadi na phalati tarhi paścāt chētsyasi| ");
INSERT INTO saniso_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","atha viśrāmavārē bhajanagēhē yīśurupadiśati ");
INSERT INTO saniso_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","tasmit samayē bhūtagrastatvāt kubjībhūyāṣṭādaśavarṣāṇi yāvat kēnāpyupāyēna r̥ju rbhavituṁ na śaknōti yā durbbalā strī, ");
INSERT INTO saniso_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","tāṁ tatrōpasthitāṁ vilōkya yīśustāmāhūya kathitavān hē nāri tava daurbbalyāt tvaṁ muktā bhava| ");
INSERT INTO saniso_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","tataḥ paraṁ tasyā gātrē hastārpaṇamātrāt sā r̥jurbhūtvēśvarasya dhanyavādaṁ karttumārēbhē| ");
INSERT INTO saniso_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","kintu viśrāmavārē yīśunā tasyāḥ svāsthyakaraṇād bhajanagēhasyādhipatiḥ prakupya lōkān uvāca, ṣaṭsu dinēṣu lōkaiḥ karmma karttavyaṁ tasmāddhētōḥ svāsthyārthaṁ tēṣu dinēṣu āgacchata, viśrāmavārē māgacchata| ");
INSERT INTO saniso_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","tadā pabhuḥ pratyuvāca rē kapaṭinō yuṣmākam ēkaikō janō viśrāmavārē svīyaṁ svīyaṁ vr̥ṣabhaṁ gardabhaṁ vā bandhanānmōcayitvā jalaṁ pāyayituṁ kiṁ na nayati? ");
INSERT INTO saniso_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","tarhyāṣṭādaśavatsarān yāvat śaitānā baddhā ibrāhīmaḥ santatiriyaṁ nārī kiṁ viśrāmavārē na mōcayitavyā? ");
INSERT INTO saniso_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ēṣu vākyēṣu kathitēṣu tasya vipakṣāḥ salajjā jātāḥ kintu tēna kr̥tasarvvamahākarmmakāraṇāt lōkanivahaḥ sānandō'bhavat| ");
INSERT INTO saniso_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","anantaraṁ sōvadad īśvarasya rājyaṁ kasya sadr̥śaṁ? kēna tadupamāsyāmi? ");
INSERT INTO saniso_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","yat sarṣapabījaṁ gr̥hītvā kaścijjana udyāna uptavān tad bījamaṅkuritaṁ sat mahāvr̥kṣō'jāyata, tatastasya śākhāsu vihāyasīyavihagā āgatya nyūṣuḥ, tadrājyaṁ tādr̥śēna sarṣapabījēna tulyaṁ| ");
INSERT INTO saniso_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","punaḥ kathayāmāsa, īśvarasya rājyaṁ kasya sadr̥śaṁ vadiṣyāmi? yat kiṇvaṁ kācit strī gr̥hītvā drōṇatrayaparimitagōdhūmacūrṇēṣu sthāpayāmāsa, ");
INSERT INTO saniso_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","tataḥ kramēṇa tat sarvvagōdhūmacūrṇaṁ vyāpnōti, tasya kiṇvasya tulyam īśvarasya rājyaṁ| ");
INSERT INTO saniso_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","tataḥ sa yirūśālamnagaraṁ prati yātrāṁ kr̥tvā nagarē nagarē grāmē grāmē samupadiśan jagāma| ");
INSERT INTO saniso_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","tadā kaścijjanastaṁ papraccha, hē prabhō kiṁ kēvalam alpē lōkāḥ paritrāsyantē? ");
INSERT INTO saniso_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","tataḥ sa lōkān uvāca, saṁkīrṇadvārēṇa pravēṣṭuṁ yataghvaṁ, yatōhaṁ yuṣmān vadāmi, bahavaḥ pravēṣṭuṁ cēṣṭiṣyantē kintu na śakṣyanti| ");
INSERT INTO saniso_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","gr̥hapatinōtthāya dvārē ruddhē sati yadi yūyaṁ bahiḥ sthitvā dvāramāhatya vadatha, hē prabhō hē prabhō asmatkāraṇād dvāraṁ mōcayatu, tataḥ sa iti prativakṣyati, yūyaṁ kutratyā lōkā ityahaṁ na jānāmi| ");
INSERT INTO saniso_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","tadā yūyaṁ vadiṣyatha, tava sākṣād vayaṁ bhēाjanaṁ pānañca kr̥tavantaḥ, tvañcāsmākaṁ nagarasya pathi samupadiṣṭavān| ");
INSERT INTO saniso_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","kintu sa vakṣyati, yuṣmānahaṁ vadāmi, yūyaṁ kutratyā lōkā ityahaṁ na jānāmi; hē durācāriṇō yūyaṁ mattō dūrībhavata| ");
INSERT INTO saniso_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","tadā ibrāhīmaṁ ishākaṁ yākūbañca sarvvabhaviṣyadvādinaśca īśvarasya rājyaṁ prāptān svāṁśca bahiṣkr̥tān dr̥ṣṭvā yūyaṁ rōdanaṁ dantairdantagharṣaṇañca kariṣyatha| ");
INSERT INTO saniso_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","aparañca pūrvvapaścimadakṣiṇōttaradigbhyō lōkā āgatya īśvarasya rājyē nivatsyanti| ");
INSERT INTO saniso_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","paśyatētthaṁ śēṣīyā lōkā agrā bhaviṣyanti, agrīyā lōkāśca śēṣā bhaviṣyanti| ");
INSERT INTO saniso_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","aparañca tasmin dinē kiyantaḥ phirūśina āgatya yīśuṁ prōcuḥ, bahirgaccha, sthānādasmāt prasthānaṁ kuru, hērōd tvāṁ jighāṁsati| ");
INSERT INTO saniso_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","tataḥ sa pratyavōcat paśyatādya śvaśca bhūtān vihāpya rōgiṇō'rōgiṇaḥ kr̥tvā tr̥tīyēhni sētsyāmi, kathāmētāṁ yūyamitvā taṁ bhūrimāyaṁ vadata| ");
INSERT INTO saniso_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","tatrāpyadya śvaḥ paraśvaśca mayā gamanāgamanē karttavyē, yatō hētō ryirūśālamō bahiḥ kutrāpi kōpi bhaviṣyadvādī na ghāniṣyatē| ");
INSERT INTO saniso_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","hē yirūśālam hē yirūśālam tvaṁ bhaviṣyadvādinō haṁsi tavāntikē prēritān prastarairmārayasi ca, yathā kukkuṭī nijapakṣādhaḥ svaśāvakān saṁgr̥hlāti, tathāhamapi tava śiśūn saṁgrahītuṁ kativārān aicchaṁ kintu tvaṁ naicchaḥ| ");
INSERT INTO saniso_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","paśyata yuṣmākaṁ vāsasthānāni prōcchidyamānāni parityaktāni ca bhaviṣyanti; yuṣmānahaṁ yathārthaṁ vadāmi, yaḥ prabhō rnāmnāgacchati sa dhanya iti vācaṁ yāvatkālaṁ na vadiṣyatha, tāvatkālaṁ yūyaṁ māṁ na drakṣyatha| ");
INSERT INTO saniso_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","anantaraṁ viśrāmavārē yīśau pradhānasya phirūśinō gr̥hē bhōktuṁ gatavati tē taṁ vīkṣitum ārēbhirē| ");
INSERT INTO saniso_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","tadā jalōdarī tasya sammukhē sthitaḥ| ");
INSERT INTO saniso_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","tataḥ sa vyavasthāpakān phirūśinaśca papraccha, viśrāmavārē svāsthyaṁ karttavyaṁ na vā? tatastē kimapi na pratyūcuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","tadā sa taṁ rōgiṇaṁ svasthaṁ kr̥tvā visasarja; ");
INSERT INTO saniso_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","tānuvāca ca yuṣmākaṁ kasyacid garddabhō vr̥ṣabhō vā cēd garttē patati tarhi viśrāmavārē tatkṣaṇaṁ sa kiṁ taṁ nōtthāpayiṣyati? ");
INSERT INTO saniso_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","tatastē kathāyā ētasyāḥ kimapi prativaktuṁ na śēkuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","aparañca pradhānasthānamanōnītatvakaraṇaṁ vilōkya sa nimantritān ētadupadēśakathāṁ jagāda, ");
INSERT INTO saniso_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","tvaṁ vivāhādibhōjyēṣu nimantritaḥ san pradhānasthānē mōpāvēkṣīḥ| tvattō gauravānvitanimantritajana āyātē ");
INSERT INTO saniso_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","nimantrayitāgatya manuṣyāyaitasmai sthānaṁ dēhīti vākyaṁ cēd vakṣyati tarhi tvaṁ saṅkucitō bhūtvā sthāna itarasmin upavēṣṭum udyaṁsyasi| ");
INSERT INTO saniso_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","asmāt kāraṇādēva tvaṁ nimantritō gatvā'pradhānasthāna upaviśa, tatō nimantrayitāgatya vadiṣyati, hē bandhō prōccasthānaṁ gatvōpaviśa, tathā sati bhōjanōpaviṣṭānāṁ sakalānāṁ sākṣāt tvaṁ mānyō bhaviṣyasi| ");
INSERT INTO saniso_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","yaḥ kaścit svamunnamayati sa namayiṣyatē, kintu yaḥ kaścit svaṁ namayati sa unnamayiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","tadā sa nimantrayitāraṁ janamapi jagāda, madhyāhnē rātrau vā bhōjyē kr̥tē nijabandhugaṇō vā bhrātr̥ृgaṇō vā jñātigaṇō vā dhanigaṇō vā samīpavāsigaṇō vā ētān na nimantraya, tathā kr̥tē cēt tē tvāṁ nimantrayiṣyanti, tarhi pariśōdhō bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","kintu yadā bhējyaṁ karōṣi tadā daridraśuṣkakarakhañjāndhān nimantraya, ");
INSERT INTO saniso_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","tata āśiṣaṁ lapsyasē, tēṣu pariśōdhaṁ karttumaśaknuvatsu śmaśānāddhārmmikānāmutthānakālē tvaṁ phalāṁ lapsyasē| ");
INSERT INTO saniso_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","anantaraṁ tāṁ kathāṁ niśamya bhōjanōpaviṣṭaḥ kaścit kathayāmāsa, yō jana īśvarasya rājyē bhōktuṁ lapsyatē saēva dhanyaḥ| ");
INSERT INTO saniso_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","tataḥ sa uvāca, kaścit janō rātrau bhēाjyaṁ kr̥tvā bahūn nimantrayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","tatō bhōjanasamayē nimantritalōkān āhvātuṁ dāsadvārā kathayāmāsa, khadyadravyāṇi sarvvāṇi samāsāditāni santi, yūyamāgacchata| ");
INSERT INTO saniso_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","kintu tē sarvva ēkaikaṁ chalaṁ kr̥tvā kṣamāṁ prārthayāñcakrirē| prathamō janaḥ kathayāmāsa, kṣētramēkaṁ krītavānahaṁ tadēva draṣṭuṁ mayā gantavyam, ataēva māṁ kṣantuṁ taṁ nivēdaya| ");
INSERT INTO saniso_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","anyō janaḥ kathayāmāsa, daśavr̥ṣānahaṁ krītavān tān parīkṣituṁ yāmi tasmādēva māṁ kṣantuṁ taṁ nivēdaya| ");
INSERT INTO saniso_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","aparaḥ kathayāmāsa, vyūḍhavānahaṁ tasmāt kāraṇād yātuṁ na śaknōmi| ");
INSERT INTO saniso_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","paścāt sa dāsō gatvā nijaprabhōḥ sākṣāt sarvvavr̥ttāntaṁ nivēdayāmāsa, tatōsau gr̥hapatiḥ kupitvā svadāsaṁ vyājahāra, tvaṁ satvaraṁ nagarasya sannivēśān mārgāṁśca gatvā daridraśuṣkakarakhañjāndhān atrānaya| ");
INSERT INTO saniso_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","tatō dāsō'vadat, hē prabhō bhavata ājñānusārēṇākriyata tathāpi sthānamasti| ");
INSERT INTO saniso_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","tadā prabhuḥ puna rdāsāyākathayat, rājapathān vr̥kṣamūlāni ca yātvā madīyagr̥hapūraṇārthaṁ lōkānāgantuṁ pravarttaya| ");
INSERT INTO saniso_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ahaṁ yuṣmabhyaṁ kathayāmi, pūrvvanimantritānamēkōpi mamāsya rātribhōjyasyāsvādaṁ na prāpsyati| ");
INSERT INTO saniso_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","anantaraṁ bahuṣu lōkēṣu yīśōḥ paścād vrajitēṣu satsu sa vyāghuṭya tēbhyaḥ kathayāmāsa, ");
INSERT INTO saniso_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","yaḥ kaścin mama samīpam āgatya svasya mātā pitā patnī santānā bhrātarō bhagimyō nijaprāṇāśca, ētēbhyaḥ sarvvēbhyō mayyadhikaṁ prēma na karōti, sa mama śiṣyō bhavituṁ na śakṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","yaḥ kaścit svīyaṁ kruśaṁ vahan mama paścānna gacchati, sōpi mama śiṣyō bhavituṁ na śakṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","durganirmmāṇē kativyayō bhaviṣyati, tathā tasya samāptikaraṇārthaṁ sampattirasti na vā, prathamamupaviśya ētanna gaṇayati, yuṣmākaṁ madhya ētādr̥śaḥ kōsti? ");
INSERT INTO saniso_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","nōcēd bhittiṁ kr̥tvā śēṣē yadi samāpayituṁ na śakṣyati, ");
INSERT INTO saniso_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","tarhi mānuṣōyaṁ nicētum ārabhata samāpayituṁ nāśaknōt, iti vyāhr̥tya sarvvē tamupahasiṣyanti| ");
INSERT INTO saniso_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","aparañca bhinnabhūpatinā saha yuddhaṁ karttum udyamya daśasahasrāṇi sainyāni gr̥hītvā viṁśatisahasrēḥ sainyaiḥ sahitasya samīpavāsinaḥ sammukhaṁ yātuṁ śakṣyāmi na vēti prathamaṁ upaviśya na vicārayati ētādr̥śō bhūmipatiḥ kaḥ? ");
INSERT INTO saniso_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","yadi na śaknōti tarhi ripāvatidūrē tiṣṭhati sati nijadūtaṁ prēṣya sandhiṁ karttuṁ prārthayēta| ");
INSERT INTO saniso_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","tadvad yuṣmākaṁ madhyē yaḥ kaścin madarthaṁ sarvvasvaṁ hātuṁ na śaknōti sa mama śiṣyō bhavituṁ na śakṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","lavaṇam uttamam iti satyaṁ, kintu yadi lavaṇasya lavaṇatvam apagacchati tarhi tat kathaṁ svāduyuktaṁ bhaviṣyati? ");
INSERT INTO saniso_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","tada bhūmyartham ālavālarāśyarthamapi bhadraṁ na bhavati; lōkāstad bahiḥ kṣipanti|yasya śrōtuṁ śrōtrē staḥ sa śr̥ṇōtu| ");
INSERT INTO saniso_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","tadā karasañcāyinaḥ pāpinaśca lōkā upadēśkathāṁ śrōtuṁ yīśōḥ samīpam āgacchan| ");
INSERT INTO saniso_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","tataḥ phirūśina upādhyāyāśca vivadamānāḥ kathayāmāsuḥ ēṣa mānuṣaḥ pāpibhiḥ saha praṇayaṁ kr̥tvā taiḥ sārddhaṁ bhuṁktē| ");
INSERT INTO saniso_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","tadā sa tēbhya imāṁ dr̥ṣṭāntakathāṁ kathitavān, ");
INSERT INTO saniso_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","kasyacit śatamēṣēṣu tiṣṭhatmu tēṣāmēkaṁ sa yadi hārayati tarhi madhyēprāntaram ēkōnaśatamēṣān vihāya hāritamēṣasya uddēśaprāptiparyyanataṁ na gavēṣayati, ētādr̥śō lōkō yuṣmākaṁ madhyē ka āstē? ");
INSERT INTO saniso_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","tasyōddēśaṁ prāpya hr̥ṣṭamanāstaṁ skandhē nidhāya svasthānam ānīya bandhubāndhavasamīpavāsina āhūya vakti, ");
INSERT INTO saniso_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","hāritaṁ mēṣaṁ prāptōham atō hētō rmayā sārddham ānandata| ");
INSERT INTO saniso_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","tadvadahaṁ yuṣmān vadāmi, yēṣāṁ manaḥparāvarttanasya prayōjanaṁ nāsti, tādr̥śaikōnaśatadhārmmikakāraṇād ya ānandastasmād ēkasya manaḥparivarttinaḥ pāpinaḥ kāraṇāt svargē 'dhikānandō jāyatē| ");
INSERT INTO saniso_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","aparañca daśānāṁ rūpyakhaṇḍānām ēkakhaṇḍē hāritē pradīpaṁ prajvālya gr̥haṁ sammārjya tasya prāptiṁ yāvad yatnēna na gavēṣayati, ētādr̥śī yōṣit kāstē? ");
INSERT INTO saniso_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","prāptē sati bandhubāndhavasamīpavāsinīrāhūya kathayati, hāritaṁ rūpyakhaṇḍaṁ prāptāhaṁ tasmādēva mayā sārddham ānandata| ");
INSERT INTO saniso_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","tadvadahaṁ yuṣmān vyāharāmi, ēkēna pāpinā manasi parivarttitē, īśvarasya dūtānāṁ madhyēpyānandō jāyatē| ");
INSERT INTO saniso_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","aparañca sa kathayāmāsa, kasyacid dvau putrāvāstāṁ, ");
INSERT INTO saniso_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","tayōḥ kaniṣṭhaḥ putraḥ pitrē kathayāmāsa, hē pitastava sampattyā yamaṁśaṁ prāpsyāmyahaṁ vibhajya taṁ dēhi, tataḥ pitā nijāṁ sampattiṁ vibhajya tābhyāṁ dadau| ");
INSERT INTO saniso_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","katipayāt kālāt paraṁ sa kaniṣṭhaputraḥ samastaṁ dhanaṁ saṁgr̥hya dūradēśaṁ gatvā duṣṭācaraṇēna sarvvāṁ sampattiṁ nāśayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","tasya sarvvadhanē vyayaṁ gatē taddēśē mahādurbhikṣaṁ babhūva, tatastasya dainyadaśā bhavitum ārēbhē| ");
INSERT INTO saniso_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","tataḥ paraṁ sa gatvā taddēśīyaṁ gr̥hasthamēkam āśrayata; tataḥ sataṁ śūkaravrajaṁ cārayituṁ prāntaraṁ prēṣayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","kēnāpi tasmai bhakṣyādānāt sa śūkaraphalavalkalēna piciṇḍapūraṇāṁ vavāñcha| ");
INSERT INTO saniso_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","śēṣē sa manasi cētanāṁ prāpya kathayāmāsa, hā mama pituḥ samīpē kati kati vētanabhujō dāsā yathēṣṭaṁ tatōdhikañca bhakṣyaṁ prāpnuvanti kintvahaṁ kṣudhā mumūrṣuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ahamutthāya pituḥ samīpaṁ gatvā kathāmētāṁ vadiṣyāmi, hē pitar īśvarasya tava ca viruddhaṁ pāpamakaravam ");
INSERT INTO saniso_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","tava putra̮iti vikhyātō bhavituṁ na yōgyōsmi ca, māṁ tava vaitanikaṁ dāsaṁ kr̥tvā sthāpaya| ");
INSERT INTO saniso_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","paścāt sa utthāya pituḥ samīpaṁ jagāma; tatastasya pitātidūrē taṁ nirīkṣya dayāñcakrē, dhāvitvā tasya kaṇṭhaṁ gr̥hītvā taṁ cucumba ca| ");
INSERT INTO saniso_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","tadā putra uvāca, hē pitar īśvarasya tava ca viruddhaṁ pāpamakaravaṁ, tava putra̮iti vikhyātō bhavituṁ na yōgyōsmi ca| ");
INSERT INTO saniso_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","kintu tasya pitā nijadāsān ādidēśa, sarvvōttamavastrāṇyānīya paridhāpayatainaṁ hastē cāṅgurīyakam arpayata pādayōścōpānahau samarpayata; ");
INSERT INTO saniso_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","puṣṭaṁ gōvatsam ānīya mārayata ca taṁ bhuktvā vayam ānandāma| ");
INSERT INTO saniso_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","yatō mama putrōyam amriyata punarajīvīd hāritaśca labdhōbhūt tatasta ānanditum ārēbhirē| ");
INSERT INTO saniso_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","tatkālē tasya jyēṣṭhaḥ putraḥ kṣētra āsīt| atha sa nivēśanasya nikaṭaṁ āgacchan nr̥tyānāṁ vādyānāñca śabdaṁ śrutvā ");
INSERT INTO saniso_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","dāsānām ēkam āhūya papraccha, kiṁ kāraṇamasya? ");
INSERT INTO saniso_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","tataḥ sōvādīt, tava bhrātāgamat, tava tātaśca taṁ suśarīraṁ prāpya puṣṭaṁ gōvatsaṁ māritavān| ");
INSERT INTO saniso_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","tataḥ sa prakupya nivēśanāntaḥ pravēṣṭuṁ na sammēnē; tatastasya pitā bahirāgatya taṁ sādhayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","tataḥ sa pitaraṁ pratyuvāca, paśya tava kāñcidapyājñāṁ na vilaṁghya bahūn vatsarān ahaṁ tvāṁ sēvē tathāpi mitraiḥ sārddham utsavaṁ karttuṁ kadāpi chāgamēkamapi mahyaṁ nādadāḥ; ");
INSERT INTO saniso_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","kintu tava yaḥ putrō vēśyāgamanādibhistava sampattim apavyayitavān tasminnāgatamātrē tasyaiva nimittaṁ puṣṭaṁ gōvatsaṁ māritavān| ");
INSERT INTO saniso_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","tadā tasya pitāvōcat, hē putra tvaṁ sarvvadā mayā sahāsi tasmān mama yadyadāstē tatsarvvaṁ tava| ");
INSERT INTO saniso_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","kintu tavāyaṁ bhrātā mr̥taḥ punarajīvīd hāritaśca bhūtvā prāptōbhūt, ētasmāt kāraṇād utsavānandau karttum ucitamasmākam| ");
INSERT INTO saniso_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","aparañca yīśuḥ śiṣyēbhyōnyāmēkāṁ kathāṁ kathayāmāsa kasyacid dhanavatō manuṣyasya gr̥hakāryyādhīśē sampattērapavyayē'pavāditē sati ");
INSERT INTO saniso_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","tasya prabhustam āhūya jagāda, tvayi yāmimāṁ kathāṁ śr̥ṇōmi sā kīdr̥śī? tvaṁ gr̥hakāryyādhīśakarmmaṇō gaṇanāṁ darśaya gr̥hakāryyādhīśapadē tvaṁ na sthāsyasi| ");
INSERT INTO saniso_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","tadā sa gr̥hakāryyādhīśō manasā cintayāmāsa, prabhu ryadi māṁ gr̥hakāryyādhīśapadād bhraṁśayati tarhi kiṁ kariṣyē'haṁ? mr̥daṁ khanituṁ mama śakti rnāsti bhikṣituñca lajjiṣyē'haṁ| ");
INSERT INTO saniso_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ataēva mayi gr̥hakāryyādhīśapadāt cyutē sati yathā lōkā mahyam āśrayaṁ dāsyanti tadarthaṁ yatkarmma mayā karaṇīyaṁ tan nirṇīyatē| ");
INSERT INTO saniso_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","paścāt sa svaprabhōrēkaikam adhamarṇam āhūya prathamaṁ papraccha, tvattō mē prabhuṇā kati prāpyam? ");
INSERT INTO saniso_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","tataḥ sa uvāca, ēkaśatāḍhakatailāni; tadā gr̥hakāryyādhīśaḥ prōvāca, tava patramānīya śīghramupaviśya tatra pañcāśataṁ likha| ");
INSERT INTO saniso_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","paścādanyamēkaṁ papraccha, tvattō mē prabhuṇā kati prāpyam? tataḥ sōvādīd ēkaśatāḍhakagōdhūmāḥ; tadā sa kathayāmāsa, tava patramānīya aśītiṁ likha| ");
INSERT INTO saniso_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","tēnaiva prabhustamayathārthakr̥tam adhīśaṁ tadbuddhinaipuṇyāt praśaśaṁsa; itthaṁ dīptirūpasantānēbhya ētatsaṁsārasya santānā varttamānakālē'dhikabuddhimantō bhavanti| ");
INSERT INTO saniso_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","atō vadāmi yūyamapyayathārthēna dhanēna mitrāṇi labhadhvaṁ tatō yuṣmāsu padabhraṣṭēṣvapi tāni cirakālam āśrayaṁ dāsyanti| ");
INSERT INTO saniso_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","yaḥ kaścit kṣudrē kāryyē viśvāsyō bhavati sa mahati kāryyēpi viśvāsyō bhavati, kintu yaḥ kaścit kṣudrē kāryyē'viśvāsyō bhavati sa mahati kāryyēpyaviśvāsyō bhavati| ");
INSERT INTO saniso_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ataēva ayathārthēna dhanēna yadi yūyamaviśvāsyā jātāstarhi satyaṁ dhanaṁ yuṣmākaṁ karēṣu kaḥ samarpayiṣyati? ");
INSERT INTO saniso_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","yadi ca paradhanēna yūyam aviśvāsyā bhavatha tarhi yuṣmākaṁ svakīyadhanaṁ yuṣmabhyaṁ kō dāsyati? ");
INSERT INTO saniso_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","kōpi dāsa ubhau prabhū sēvituṁ na śaknōti, yata ēkasmin prīyamāṇō'nyasminnaprīyatē yadvā ēkaṁ janaṁ samādr̥tya tadanyaṁ tucchīkarōti tadvad yūyamapi dhanēśvarau sēvituṁ na śaknutha| ");
INSERT INTO saniso_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","tadaitāḥ sarvvāḥ kathāḥ śrutvā lōbhiphirūśinastamupajahasuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","tataḥ sa uvāca, yūyaṁ manuṣyāṇāṁ nikaṭē svān nirdōṣān darśayatha kintu yuṣmākam antaḥkaraṇānīśvarō jānāti, yat manuṣyāṇām ati praśaṁsyaṁ tad īśvarasya ghr̥ṇyaṁ| ");
INSERT INTO saniso_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","yōhana āgamanaparyyanataṁ yuṣmākaṁ samīpē vyavasthābhaviṣyadvādināṁ lēkhanāni cāsan tataḥ prabhr̥ti īśvararājyasya susaṁvādaḥ pracarati, ēkaikō lōkastanmadhyaṁ yatnēna praviśati ca| ");
INSERT INTO saniso_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","varaṁ nabhasaḥ pr̥thivyāśca lōpō bhaviṣyati tathāpi vyavasthāyā ēkabindōrapi lōpō na bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","yaḥ kaścit svīyāṁ bhāryyāṁ vihāya striyamanyāṁ vivahati sa paradārān gacchati, yaśca tā tyaktāṁ nārīṁ vivahati sōpi paradārāna gacchati| ");
INSERT INTO saniso_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ēkō dhanī manuṣyaḥ śuklāni sūkṣmāṇi vastrāṇi paryyadadhāt pratidinaṁ paritōṣarūpēṇābhuṁktāpivacca| ");
INSERT INTO saniso_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","sarvvāṅgē kṣatayukta iliyāsaranāmā kaścid daridrastasya dhanavatō bhōjanapātrāt patitam ucchiṣṭaṁ bhōktuṁ vāñchan tasya dvārē patitvātiṣṭhat; ");
INSERT INTO saniso_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","atha śvāna āgatya tasya kṣatānyalihan| ");
INSERT INTO saniso_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","kiyatkālātparaṁ sa daridraḥ prāṇān jahau; tataḥ svargīyadūtāstaṁ nītvā ibrāhīmaḥ krōḍa upavēśayāmāsuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","paścāt sa dhanavānapi mamāra, taṁ śmaśānē sthāpayāmāsuśca; kintu paralōkē sa vēdanākulaḥ san ūrddhvāṁ nirīkṣya bahudūrād ibrāhīmaṁ tatkrōḍa iliyāsarañca vilōkya ruvannuvāca; ");
INSERT INTO saniso_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","hē pitar ibrāhīm anugr̥hya aṅgulyagrabhāgaṁ jalē majjayitvā mama jihvāṁ śītalāṁ karttum iliyāsaraṁ prēraya, yatō vahniśikhātōhaṁ vyathitōsmi| ");
INSERT INTO saniso_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","tadā ibrāhīm babhāṣē, hē putra tvaṁ jīvan sampadaṁ prāptavān iliyāsarastu vipadaṁ prāptavān ētat smara, kintu samprati tasya sukhaṁ tava ca duḥkhaṁ bhavati| ");
INSERT INTO saniso_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","aparamapi yuṣmākam asmākañca sthānayō rmadhyē mahadvicchēdō'sti tata ētatsthānasya lōkāstat sthānaṁ yātuṁ yadvā tatsthānasya lōkā ētat sthānamāyātuṁ na śaknuvanti| ");
INSERT INTO saniso_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","tadā sa uktavān, hē pitastarhi tvāṁ nivēdayāmi mama pitu rgēhē yē mama pañca bhrātaraḥ santi ");
INSERT INTO saniso_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","tē yathaitad yātanāsthānaṁ nāyāsyanti tathā mantraṇāṁ dātuṁ tēṣāṁ samīpam iliyāsaraṁ prēraya| ");
INSERT INTO saniso_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","tata ibrāhīm uvāca, mūsābhaviṣyadvādināñca pustakāni tēṣāṁ nikaṭē santi tē tadvacanāni manyantāṁ| ");
INSERT INTO saniso_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","tadā sa nivēdayāmāsa, hē pitar ibrāhīm na tathā, kintu yadi mr̥talōkānāṁ kaścit tēṣāṁ samīpaṁ yāti tarhi tē manāṁsi vyāghōṭayiṣyanti| ");
INSERT INTO saniso_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","tata ibrāhīm jagāda, tē yadi mūsābhaviṣyadvādināñca vacanāni na manyantē tarhi mr̥talōkānāṁ kasmiṁścid utthitēpi tē tasya mantraṇāṁ na maṁsyantē| ");
INSERT INTO saniso_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","itaḥ paraṁ yīśuḥ śiṣyān uvāca, vighnairavaśyam āgantavyaṁ kintu vighnā yēna ghaṭiṣyantē tasya durgati rbhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ētēṣāṁ kṣudraprāṇinām ēkasyāpi vighnajananāt kaṇṭhabaddhapēṣaṇīkasya tasya sāgarāgādhajalē majjanaṁ bhadraṁ| ");
INSERT INTO saniso_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","yūyaṁ svēṣu sāvadhānāstiṣṭhata; tava bhrātā yadi tava kiñcid aparādhyati tarhi taṁ tarjaya, tēna yadi manaḥ parivarttayati tarhi taṁ kṣamasva| ");
INSERT INTO saniso_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","punarēkadinamadhyē yadi sa tava saptakr̥tvō'parādhyati kintu saptakr̥tva āgatya manaḥ parivartya mayāparāddham iti vadati tarhi taṁ kṣamasva| ");
INSERT INTO saniso_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","tadā prēritāḥ prabhum avadan asmākaṁ viśvāsaṁ varddhaya| ");
INSERT INTO saniso_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","prabhuruvāca, yadi yuṣmākaṁ sarṣapaikapramāṇō viśvāsōsti tarhi tvaṁ samūlamutpāṭitō bhūtvā samudrē rōpitō bhava kathāyām ētasyām ētaduḍumbarāya kathitāyāṁ sa yuṣmākamājñāvahō bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","aparaṁ svadāsē halaṁ vāhayitvā vā paśūn cārayitvā kṣētrād āgatē sati taṁ vadati, ēhi bhōktumupaviśa, yuṣmākam ētādr̥śaḥ kōsti? ");
INSERT INTO saniso_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","varañca pūrvvaṁ mama khādyamāsādya yāvad bhuñjē pivāmi ca tāvad baddhakaṭiḥ paricara paścāt tvamapi bhōkṣyasē pāsyasi ca kathāmīdr̥śīṁ kiṁ na vakṣyati? ");
INSERT INTO saniso_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","tēna dāsēna prabhōrājñānurūpē karmmaṇi kr̥tē prabhuḥ kiṁ tasmin bādhitō jātaḥ? nētthaṁ budhyatē mayā| ");
INSERT INTO saniso_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","itthaṁ nirūpitēṣu sarvvakarmmasu kr̥tēṣu satmu yūyamapīdaṁ vākyaṁ vadatha, vayam anupakāriṇō dāsā asmābhiryadyatkarttavyaṁ tanmātramēva kr̥taṁ| ");
INSERT INTO saniso_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","sa yirūśālami yātrāṁ kurvvan śōmirōṇgālīlpradēśamadhyēna gacchati, ");
INSERT INTO saniso_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ētarhi kutracid grāmē pravēśamātrē daśakuṣṭhinastaṁ sākṣāt kr̥tvā ");
INSERT INTO saniso_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","dūrē tiṣṭhanata uccai rvaktumārēbhirē, hē prabhō yīśō dayasvāsmān| ");
INSERT INTO saniso_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","tataḥ sa tān dr̥ṣṭvā jagāda, yūyaṁ yājakānāṁ samīpē svān darśayata, tatastē gacchantō rōgāt pariṣkr̥tāḥ| ");
INSERT INTO saniso_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","tadā tēṣāmēkaḥ svaṁ svasthaṁ dr̥ṣṭvā prōccairīśvaraṁ dhanyaṁ vadan vyāghuṭyāyātō yīśō rguṇānanuvadan taccaraṇādhōbhūmau papāta; ");
INSERT INTO saniso_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","sa cāsīt śōmirōṇī| ");
INSERT INTO saniso_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","tadā yīśuravadat, daśajanāḥ kiṁ na pariṣkr̥tāḥ? tahyanyē navajanāḥ kutra? ");
INSERT INTO saniso_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","īśvaraṁ dhanyaṁ vadantam ēnaṁ vidēśinaṁ vinā kōpyanyō na prāpyata| ");
INSERT INTO saniso_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","tadā sa tamuvāca, tvamutthāya yāhi viśvāsastē tvāṁ svasthaṁ kr̥tavān| ");
INSERT INTO saniso_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","atha kadēśvarasya rājatvaṁ bhaviṣyatīti phirūśibhiḥ pr̥ṣṭē sa pratyuvāca, īśvarasya rājatvam aiśvaryyadarśanēna na bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ata ētasmin paśya tasmin vā paśya, iti vākyaṁ lōkā vaktuṁ na śakṣyanti, īśvarasya rājatvaṁ yuṣmākam antarēvāstē| ");
INSERT INTO saniso_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","tataḥ sa śiṣyān jagāda, yadā yuṣmābhi rmanujasutasya dinamēkaṁ draṣṭum vāñchiṣyatē kintu na darśiṣyatē, īdr̥kkāla āyāti| ");
INSERT INTO saniso_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","tadātra paśya vā tatra paśyēti vākyaṁ lōkā vakṣyanti, kintu tēṣāṁ paścāt mā yāta, mānugacchata ca| ");
INSERT INTO saniso_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","yatastaḍid yathākāśaikadiśyudiya tadanyāmapi diśaṁ vyāpya prakāśatē tadvat nijadinē manujasūnuḥ prakāśiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","kintu tatpūrvvaṁ tēnānēkāni duḥkhāni bhōktavyānyētadvarttamānalōkaiśca sō'vajñātavyaḥ| ");
INSERT INTO saniso_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","nōhasya vidyamānakālē yathābhavat manuṣyasūnōḥ kālēpi tathā bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","yāvatkālaṁ nōhō mahāpōtaṁ nārōhad āplāvivāryyētya sarvvaṁ nānāśayacca tāvatkālaṁ yathā lōkā abhuñjatāpivan vyavahan vyavāhayaṁśca; ");
INSERT INTO saniso_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","itthaṁ lōṭō varttamānakālēpi yathā lōkā bhōjanapānakrayavikrayarōpaṇagr̥hanirmmāṇakarmmasu prāvarttanta, ");
INSERT INTO saniso_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","kintu yadā lōṭ sidōmō nirjagāma tadā nabhasaḥ sagandhakāgnivr̥ṣṭi rbhūtvā sarvvaṁ vyanāśayat ");
INSERT INTO saniso_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","tadvan mānavaputraprakāśadinēpi bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","tadā yadi kaścid gr̥hōpari tiṣṭhati tarhi sa gr̥hamadhyāt kimapi dravyamānētum avaruhya naitu; yaśca kṣētrē tiṣṭhati sōpi vyāghuṭya nāyātu| ");
INSERT INTO saniso_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","lōṭaḥ patnīṁ smarata| ");
INSERT INTO saniso_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","yaḥ prāṇān rakṣituṁ cēṣṭiṣyatē sa prāṇān hārayiṣyati yastu prāṇān hārayiṣyati saēva prāṇān rakṣiṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","yuṣmānahaṁ vacmi tasyāṁ rātrau śayyaikagatayō rlōkayōrēkō dhāriṣyatē parastyakṣyatē| ");
INSERT INTO saniso_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","striyau yugapat pēṣaṇīṁ vyāvarttayiṣyatastayōrēkā dhāriṣyatē parātyakṣyatē| ");
INSERT INTO saniso_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","puruṣau kṣētrē sthāsyatastayōrēkō dhāriṣyatē parastyakṣyatē| ");
INSERT INTO saniso_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","tadā tē papracchuḥ, hē prabhō kutrētthaṁ bhaviṣyati? tataḥ sa uvāca, yatra śavastiṣṭhati tatra gr̥dhrā milanti| ");
INSERT INTO saniso_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","aparañca lōkairaklāntai rnirantaraṁ prārthayitavyam ityāśayēna yīśunā dr̥ṣṭānta ēkaḥ kathitaḥ| ");
INSERT INTO saniso_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","kutracinnagarē kaścit prāḍvivāka āsīt sa īśvarānnābibhēt mānuṣāṁśca nāmanyata| ");
INSERT INTO saniso_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","atha tatpuravāsinī kācidvidhavā tatsamīpamētya vivādinā saha mama vivādaṁ pariṣkurvviti nivēdayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","tataḥ sa prāḍvivākaḥ kiyaddināni na tadaṅgīkr̥tavān paścāccittē cintayāmāsa, yadyapīśvarānna bibhēmi manuṣyānapi na manyē ");
INSERT INTO saniso_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","tathāpyēṣā vidhavā māṁ kliśnāti tasmādasyā vivādaṁ pariṣkariṣyāmi nōcēt sā sadāgatya māṁ vyagraṁ kariṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","paścāt prabhuravadad asāvanyāyaprāḍvivākō yadāha tatra manō nidhadhvaṁ| ");
INSERT INTO saniso_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","īśvarasya yē 'bhirucitalōkā divāniśaṁ prārthayantē sa bahudināni vilambyāpi tēṣāṁ vivādān kiṁ na pariṣkariṣyati? ");
INSERT INTO saniso_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","yuṣmānahaṁ vadāmi tvarayā pariṣkariṣyati, kintu yadā manuṣyaputra āgamiṣyati tadā pr̥thivyāṁ kimīdr̥śaṁ viśvāsaṁ prāpsyati? ");
INSERT INTO saniso_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","yē svān dhārmmikān jñātvā parān tucchīkurvvanti ētādr̥gbhyaḥ, kiyadbhya imaṁ dr̥ṣṭāntaṁ kathayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","ēkaḥ phirūśyaparaḥ karasañcāyī dvāvimau prārthayituṁ mandiraṁ gatau| ");
INSERT INTO saniso_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","tatō'sau phirūśyēkapārśvē tiṣṭhan hē īśvara ahamanyalōkavat lōṭhayitānyāyī pāradārikaśca na bhavāmi asya karasañcāyinastulyaśca na, tasmāttvāṁ dhanyaṁ vadāmi| ");
INSERT INTO saniso_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","saptasu dinēṣu dinadvayamupavasāmi sarvvasampattē rdaśamāṁśaṁ dadāmi ca, ētatkathāṁ kathayan prārthayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","kintu sa karasañcāyi dūrē tiṣṭhan svargaṁ draṣṭuṁ nēcchan vakṣasi karāghātaṁ kurvvan hē īśvara pāpiṣṭhaṁ māṁ dayasva, itthaṁ prārthayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","yuṣmānahaṁ vadāmi, tayōrdvayō rmadhyē kēvalaḥ karasañcāyī puṇyavattvēna gaṇitō nijagr̥haṁ jagāma, yatō yaḥ kaścit svamunnamayati sa nāmayiṣyatē kintu yaḥ kaścit svaṁ namayati sa unnamayiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","atha śiśūnāṁ gātrasparśārthaṁ lōkāstān tasya samīpamāninyuḥ śiṣyāstad dr̥ṣṭvānētr̥n tarjayāmāsuḥ, ");
INSERT INTO saniso_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","kintu yīśustānāhūya jagāda, mannikaṭam āgantuṁ śiśūn anujānīdhvaṁ tāṁśca mā vārayata; yata īśvararājyādhikāriṇa ēṣāṁ sadr̥śāḥ| ");
INSERT INTO saniso_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ahaṁ yuṣmān yathārthaṁ vadāmi, yō janaḥ śiśōḥ sadr̥śō bhūtvā īśvararājyaṁ na gr̥hlāti sa kēnāpi prakārēṇa tat pravēṣṭuṁ na śaknōti| ");
INSERT INTO saniso_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","aparam ēkōdhipatistaṁ papraccha, hē paramagurō, anantāyuṣaḥ prāptayē mayā kiṁ karttavyaṁ? ");
INSERT INTO saniso_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","yīśuruvāca, māṁ kutaḥ paramaṁ vadasi? īśvaraṁ vinā kōpi paramō na bhavati| ");
INSERT INTO saniso_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","paradārān mā gaccha, naraṁ mā jahi, mā cōraya, mithyāsākṣyaṁ mā dēhi, mātaraṁ pitarañca saṁmanyasva, ētā yā ājñāḥ santi tāstvaṁ jānāsi| ");
INSERT INTO saniso_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","tadā sa uvāca, bālyakālāt sarvvā ētā ācarāmi| ");
INSERT INTO saniso_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","iti kathāṁ śrutvā yīśustamavadat, tathāpi tavaikaṁ karmma nyūnamāstē, nijaṁ sarvvasvaṁ vikrīya daridrēbhyō vitara, tasmāt svargē dhanaṁ prāpsyasi; tata āgatya mamānugāmī bhava| ");
INSERT INTO saniso_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","kintvētāṁ kathāṁ śrutvā sōdhipatiḥ śuśōca, yatastasya bahudhanamāsīt| ");
INSERT INTO saniso_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","tadā yīśustamatiśōkānvitaṁ dr̥ṣṭvā jagāda, dhanavatām īśvararājyapravēśaḥ kīdr̥g duṣkaraḥ| ");
INSERT INTO saniso_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","īśvararājyē dhaninaḥ pravēśāt sūcēśchidrēṇa mahāṅgasya gamanāgamanē sukarē| ");
INSERT INTO saniso_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","śrōtāraḥ papracchustarhi kēna paritrāṇaṁ prāpsyatē? ");
INSERT INTO saniso_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","sa uktavān, yan mānuṣēṇāśakyaṁ tad īśvarēṇa śakyaṁ| ");
INSERT INTO saniso_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","tadā pitara uvāca, paśya vayaṁ sarvvasvaṁ parityajya tava paścādgāminō'bhavāma| ");
INSERT INTO saniso_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","tataḥ sa uvāca, yuṣmānahaṁ yathārthaṁ vadāmi, īśvararājyārthaṁ gr̥haṁ pitarau bhrātr̥gaṇaṁ jāyāṁ santānāṁśca tyaktavā ");
INSERT INTO saniso_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","iha kālē tatō'dhikaṁ parakālē 'nantāyuśca na prāpsyati lōka īdr̥śaḥ kōpi nāsti| ");
INSERT INTO saniso_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","anantaraṁ sa dvādaśaśiṣyānāhūya babhāṣē, paśyata vayaṁ yirūśālamnagaraṁ yāmaḥ, tasmāt manuṣyaputrē bhaviṣyadvādibhiruktaṁ yadasti tadanurūpaṁ taṁ prati ghaṭiṣyatē; ");
INSERT INTO saniso_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","vastutastu sō'nyadēśīyānāṁ hastēṣu samarpayiṣyatē, tē tamupahasiṣyanti, anyāyamācariṣyanti tadvapuṣi niṣṭhīvaṁ nikṣēpsyanti, kaśābhiḥ prahr̥tya taṁ haniṣyanti ca, ");
INSERT INTO saniso_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","kintu tr̥tīyadinē sa śmaśānād utthāsyati| ");
INSERT INTO saniso_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ētasyāḥ kathāyā abhiprāyaṁ kiñcidapi tē bōddhuṁ na śēkuḥ tēṣāṁ nikaṭē'spaṣṭatavāt tasyaitāsāṁ kathānām āśayaṁ tē jñātuṁ na śēkuśca| ");
INSERT INTO saniso_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","atha tasmin yirīhōḥ purasyāntikaṁ prāptē kaścidandhaḥ pathaḥ pārśva upaviśya bhikṣām akarōt ");
INSERT INTO saniso_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","sa lōkasamūhasya gamanaśabdaṁ śrutvā tatkāraṇaṁ pr̥ṣṭavān| ");
INSERT INTO saniso_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","nāsaratīyayīśuryātīti lōkairuktē sa uccairvaktumārēbhē, ");
INSERT INTO saniso_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","hē dāyūdaḥ santāna yīśō māṁ dayasva| ");
INSERT INTO saniso_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","tatōgragāminastaṁ maunī tiṣṭhēti tarjayāmāsuḥ kintu sa punāruvan uvāca, hē dāyūdaḥ santāna māṁ dayasva| ");
INSERT INTO saniso_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","tadā yīśuḥ sthagitō bhūtvā svāntikē tamānētum ādidēśa| ");
INSERT INTO saniso_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","tataḥ sa tasyāntikam āgamat, tadā sa taṁ papraccha, tvaṁ kimicchasi? tvadarthamahaṁ kiṁ kariṣyāmi? sa uktavān, hē prabhō'haṁ draṣṭuṁ labhai| ");
INSERT INTO saniso_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","tadā yīśuruvāca, dr̥ṣṭiśaktiṁ gr̥hāṇa tava pratyayastvāṁ svasthaṁ kr̥tavān| ");
INSERT INTO saniso_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","tatastatkṣaṇāt tasya cakṣuṣī prasannē; tasmāt sa īśvaraṁ dhanyaṁ vadan tatpaścād yayau, tadālōkya sarvvē lōkā īśvaraṁ praśaṁsitum ārēbhirē| ");
INSERT INTO saniso_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","yadā yīśu ryirīhōpuraṁ praviśya tanmadhyēna gacchaṁstadā ");
INSERT INTO saniso_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","sakkēyanāmā karasañcāyināṁ pradhānō dhanavānēkō ");
INSERT INTO saniso_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","yīśuḥ kīdr̥giti draṣṭuṁ cēṣṭitavān kintu kharvvatvāllōkasaṁghamadhyē taddarśanamaprāpya ");
INSERT INTO saniso_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","yēna pathā sa yāsyati tatpathē'grē dhāvitvā taṁ draṣṭum uḍumbaratarumārurōha| ");
INSERT INTO saniso_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","paścād yīśustatsthānam itvā ūrddhvaṁ vilōkya taṁ dr̥ṣṭvāvādīt, hē sakkēya tvaṁ śīghramavarōha mayādya tvadgēhē vastavyaṁ| ");
INSERT INTO saniso_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","tataḥ sa śīghramavaruhya sāhlādaṁ taṁ jagrāha| ");
INSERT INTO saniso_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","tad dr̥ṣṭvā sarvvē vivadamānā vaktumārēbhirē, sōtithitvēna duṣṭalōkagr̥haṁ gacchati| ");
INSERT INTO saniso_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","kintu sakkēyō daṇḍāyamānō vaktumārēbhē, hē prabhō paśya mama yā sampattirasti tadarddhaṁ daridrēbhyō dadē, aparam anyāyaṁ kr̥tvā kasmādapi yadi kadāpi kiñcit mayā gr̥hītaṁ tarhi taccaturguṇaṁ dadāmi| ");
INSERT INTO saniso_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","tadā yīśustamuktavān ayamapi ibrāhīmaḥ santānō'taḥ kāraṇād adyāsya gr̥hē trāṇamupasthitaṁ| ");
INSERT INTO saniso_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","yad hāritaṁ tat mr̥gayituṁ rakṣituñca manuṣyaputra āgatavān| ");
INSERT INTO saniso_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","atha sa yirūśālamaḥ samīpa upātiṣṭhad īśvararājatvasyānuṣṭhānaṁ tadaiva bhaviṣyatīti lōkairanvabhūyata, tasmāt sa śrōtr̥bhyaḥ punardr̥ṣṭāntakathām utthāpya kathayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","kōpi mahāllōkō nijārthaṁ rājatvapadaṁ gr̥hītvā punarāgantuṁ dūradēśaṁ jagāma| ");
INSERT INTO saniso_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","yātrākālē nijān daśadāsān āhūya daśasvarṇamudrā dattvā mamāgamanaparyyantaṁ vāṇijyaṁ kurutētyādidēśa| ");
INSERT INTO saniso_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","kintu tasya prajāstamavajñāya manuṣyamēnam asmākamupari rājatvaṁ na kārayivyāma imāṁ vārttāṁ tannikaṭē prērayāmāsuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","atha sa rājatvapadaṁ prāpyāgatavān ēkaikō janō bāṇijyēna kiṁ labdhavān iti jñātuṁ yēṣu dāsēṣu mudrā arpayat tān āhūyānētum ādidēśa| ");
INSERT INTO saniso_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","tadā prathama āgatya kathitavān, hē prabhō tava tayaikayā mudrayā daśamudrā labdhāḥ| ");
INSERT INTO saniso_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","tataḥ sa uvāca tvamuttamō dāsaḥ svalpēna viśvāsyō jāta itaḥ kāraṇāt tvaṁ daśanagarāṇām adhipō bhava| ");
INSERT INTO saniso_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","dvitīya āgatya kathitavān, hē prabhō tavaikayā mudrayā pañcamudrā labdhāḥ| ");
INSERT INTO saniso_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","tataḥ sa uvāca, tvaṁ pañcānāṁ nagarāṇāmadhipati rbhava| ");
INSERT INTO saniso_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","tatōnya āgatya kathayāmāsa, hē prabhō paśya tava yā mudrā ahaṁ vastrē baddhvāsthāpayaṁ sēyaṁ| ");
INSERT INTO saniso_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","tvaṁ kr̥paṇō yannāsthāpayastadapi gr̥hlāsi, yannāvapastadēva ca chinatsi tatōhaṁ tvattō bhītaḥ| ");
INSERT INTO saniso_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","tadā sa jagāda, rē duṣṭadāsa tava vākyēna tvāṁ dōṣiṇaṁ kariṣyāmi, yadahaṁ nāsthāpayaṁ tadēva gr̥hlāmi, yadahaṁ nāvapañca tadēva chinadmi, ētādr̥śaḥ kr̥paṇōhamiti yadi tvaṁ jānāsi, ");
INSERT INTO saniso_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","tarhi mama mudrā baṇijāṁ nikaṭē kutō nāsthāpayaḥ? tayā kr̥tē'ham āgatya kusīdēna sārddhaṁ nijamudrā aprāpsyam| ");
INSERT INTO saniso_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","paścāt sa samīpasthān janān ājñāpayat asmāt mudrā ānīya yasya daśamudrāḥ santi tasmai datta| ");
INSERT INTO saniso_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","tē prōcuḥ prabhō'sya daśamudrāḥ santi| ");
INSERT INTO saniso_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","yuṣmānahaṁ vadāmi yasyāśrayē vaddhatē 'dhikaṁ tasmai dāyiṣyatē, kintu yasyāśrayē na varddhatē tasya yadyadasti tadapi tasmān nāyiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","kintu mamādhipatitvasya vaśatvē sthātum asammanyamānā yē mama ripavastānānīya mama samakṣaṁ saṁharata| ");
INSERT INTO saniso_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ityupadēśakathāṁ kathayitvā sōgragaḥ san yirūśālamapuraṁ yayau| ");
INSERT INTO saniso_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","tatō baitphagībaithanīyāgrāmayōḥ samīpē jaitunādrērantikam itvā śiṣyadvayam ityuktvā prēṣayāmāsa, ");
INSERT INTO saniso_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","yuvāmamuṁ sammukhasthagrāmaṁ praviśyaiva yaṁ kōpi mānuṣaḥ kadāpi nārōhat taṁ garddabhaśāvakaṁ baddhaṁ drakṣyathastaṁ mōcayitvānayataṁ| ");
INSERT INTO saniso_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","tatra kutō mōcayathaḥ? iti cēt kōpi vakṣyati tarhi vakṣyathaḥ prabhēाratra prayōjanam āstē| ");
INSERT INTO saniso_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","tadā tau praritau gatvā tatkathāाnusārēṇa sarvvaṁ prāptau| ");
INSERT INTO saniso_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","gardabhaśāvakamōcanakālē tatvāmina ūcuḥ, gardabhaśāvakaṁ kutō mōcayathaḥ? ");
INSERT INTO saniso_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","tāvūcatuḥ prabhōratra prayōjanam āstē| ");
INSERT INTO saniso_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","paścāt tau taṁ gardabhaśāvakaṁ yīśōrantikamānīya tatpr̥ṣṭhē nijavasanāni pātayitvā tadupari yīśumārōhayāmāsatuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","atha yātrākālē lōkāḥ pathi svavastrāṇi pātayitum ārēbhirē| ");
INSERT INTO saniso_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","aparaṁ jaitunādrērupatyakām itvā śiṣyasaṁghaḥ pūrvvadr̥ṣṭāni mahākarmmāṇi smr̥tvā, ");
INSERT INTO saniso_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","yō rājā prabhō rnāmnāyāti sa dhanyaḥ svargē kuśalaṁ sarvvōccē jayadhvani rbhavatu, kathāmētāṁ kathayitvā sānandam ucairīśvaraṁ dhanyaṁ vaktumārēbhē| ");
INSERT INTO saniso_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","tadā lōkāraṇyamadhyasthāḥ kiyantaḥ phirūśinastat śrutvā yīśuṁ prōcuḥ, hē upadēśaka svaśiṣyān tarjaya| ");
INSERT INTO saniso_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","sa uvāca, yuṣmānahaṁ vadāmi yadyamī nīravāstiṣṭhanti tarhi pāṣāṇā ucaiḥ kathāḥ kathayiṣyanti| ");
INSERT INTO saniso_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","paścāt tatpurāntikamētya tadavalōkya sāśrupātaṁ jagāda, ");
INSERT INTO saniso_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","hā hā cēt tvamagrē'jñāsyathāḥ, tavāsminnēva dinē vā yadi svamaṅgalam upālapsyathāḥ, tarhyuttamam abhaviṣyat, kintu kṣaṇēsmin tattava dr̥ṣṭēragōcaram bhavati| ");
INSERT INTO saniso_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","tvaṁ svatrāṇakālē na manō nyadhatthā iti hētō ryatkālē tava ripavastvāṁ caturdikṣu prācīrēṇa vēṣṭayitvā rōtsyanti ");
INSERT INTO saniso_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","bālakaiḥ sārddhaṁ bhūmisāt kariṣyanti ca tvanmadhyē pāṣāṇaikōpi pāṣāṇōpari na sthāsyati ca, kāla īdr̥śa upasthāsyati| ");
INSERT INTO saniso_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","atha madhyēmandiraṁ praviśya tatratyān krayivikrayiṇō bahiṣkurvvan ");
INSERT INTO saniso_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","avadat madgr̥haṁ prārthanāgr̥hamiti lipirāstē kintu yūyaṁ tadēva cairāṇāṁ gahvaraṁ kurutha| ");
INSERT INTO saniso_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","paścāt sa pratyahaṁ madhyēmandiram upadidēśa; tataḥ pradhānayājakā adhyāpakāḥ prācīnāśca taṁ nāśayituṁ cicēṣṭirē; ");
INSERT INTO saniso_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","kintu tadupadēśē sarvvē lōkā niviṣṭacittāḥ sthitāstasmāt tē tatkarttuṁ nāvakāśaṁ prāpuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","athaikadā yīśu rmanidarē susaṁvādaṁ pracārayan lōkānupadiśati, ētarhi pradhānayājakā adhyāpakāḥ prāñcaśca tannikaṭamāgatya papracchuḥ ");
INSERT INTO saniso_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","kayājñayā tvaṁ karmmāṇyētāni karōṣi? kō vā tvāmājñāpayat? tadasmān vada| ");
INSERT INTO saniso_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","sa pratyuvāca, tarhi yuṣmānapi kathāmēkāṁ pr̥cchāmi tasyōttaraṁ vadata| ");
INSERT INTO saniso_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","yōhanō majjanam īśvarasya mānuṣāṇāṁ vājñātō jātaṁ? ");
INSERT INTO saniso_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","tatastē mithō vivicya jagaduḥ, yadīśvarasya vadāmastarhi taṁ kutō na pratyaita sa iti vakṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","yadi manuṣyasyēti vadāmastarhi sarvvē lōkā asmān pāṣāṇai rhaniṣyanti yatō yōhan bhaviṣyadvādīti sarvvē dr̥ḍhaṁ jānanti| ");
INSERT INTO saniso_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ataēva tē pratyūcuḥ kasyājñayā jātam iti vaktuṁ na śaknumaḥ| ");
INSERT INTO saniso_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","tadā yīśuravadat tarhi kayājñayā karmmāṇyētāti karōmīti ca yuṣmān na vakṣyāmi| ");
INSERT INTO saniso_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","atha lōkānāṁ sākṣāt sa imāṁ dr̥ṣṭāntakathāṁ vaktumārēbhē, kaścid drākṣākṣētraṁ kr̥tvā tat kṣētraṁ kr̥ṣīvalānāṁ hastēṣu samarpya bahukālārthaṁ dūradēśaṁ jagāma| ");
INSERT INTO saniso_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","atha phalakālē phalāni grahītu kr̥ṣīvalānāṁ samīpē dāsaṁ prāhiṇōt kintu kr̥ṣīvalāstaṁ prahr̥tya riktahastaṁ visasarjuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","tataḥ sōdhipatiḥ punaranyaṁ dāsaṁ prēṣayāmāsa, tē tamapi prahr̥tya kuvyavahr̥tya riktahastaṁ visasr̥juḥ| ");
INSERT INTO saniso_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","tataḥ sa tr̥tīyavāram anyaṁ prāhiṇōt tē tamapi kṣatāṅgaṁ kr̥tvā bahi rnicikṣipuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","tadā kṣētrapati rvicārayāmāsa, mamēdānīṁ kiṁ karttavyaṁ? mama priyē putrē prahitē tē tamavaśyaṁ dr̥ṣṭvā samādariṣyantē| ");
INSERT INTO saniso_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","kintu kr̥ṣīvalāstaṁ nirīkṣya parasparaṁ vivicya prōcuḥ, ayamuttarādhikārī āgacchatainaṁ hanmastatōdhikārōsmākaṁ bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","tatastē taṁ kṣētrād bahi rnipātya jaghnustasmāt sa kṣētrapatistān prati kiṁ kariṣyati? ");
INSERT INTO saniso_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","sa āgatya tān kr̥ṣīvalān hatvā parēṣāṁ hastēṣu tatkṣētraṁ samarpayiṣyati; iti kathāṁ śrutvā tē 'vadan ētādr̥śī ghaṭanā na bhavatu| ");
INSERT INTO saniso_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","kintu yīśustānavalōkya jagāda, tarhi, sthapatayaḥ kariṣyanti grāvāṇaṁ yantu tucchakaṁ| pradhānaprastaraḥ kōṇē sa ēva hi bhaviṣyati| ētasya śāstrīyavacanasya kiṁ tātparyyaṁ? ");
INSERT INTO saniso_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","aparaṁ tatpāṣāṇōpari yaḥ patiṣyati sa bhaṁkṣyatē kintu yasyōpari sa pāṣāṇaḥ patiṣyati sa tēna dhūlivac cūrṇībhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","sōsmākaṁ viruddhaṁ dr̥ṣṭāntamimaṁ kathitavān iti jñātvā pradhānayājakā adhyāpakāśca tadaiva taṁ dhartuṁ vavāñchuḥ kintu lōkēbhyō bibhyuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ataēva taṁ prati satarkāḥ santaḥ kathaṁ tadvākyadōṣaṁ dhr̥tvā taṁ dēśādhipasya sādhuvēśadhāriṇaścarān tasya samīpē prēṣayāmāsuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","tadā tē taṁ papracchuḥ, hē upadēśaka bhavān yathārthaṁ kathayan upadiśati, kamapyanapēkṣya satyatvēnaiśvaraṁ mārgamupadiśati, vayamētajjānīmaḥ| ");
INSERT INTO saniso_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","kaisararājāya karōsmābhi rdēyō na vā? ");
INSERT INTO saniso_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","sa tēṣāṁ vañcanaṁ jñātvāvadat kutō māṁ parīkṣadhvē? māṁ mudrāmēkaṁ darśayata| ");
INSERT INTO saniso_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","iha likhitā mūrtiriyaṁ nāma ca kasya? tē'vadan kaisarasya| ");
INSERT INTO saniso_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","tadā sa uvāca, tarhi kaisarasya dravyaṁ kaisarāya datta; īśvarasya tu dravyamīśvarāya datta| ");
INSERT INTO saniso_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","tasmāllōkānāṁ sākṣāt tatkathāyāḥ kamapi dōṣaṁ dhartumaprāpya tē tasyōttarād āścaryyaṁ manyamānā mauninastasthuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","aparañca śmaśānādutthānānaṅgīkāriṇāṁ sidūkināṁ kiyantō janā āgatya taṁ papracchuḥ, ");
INSERT INTO saniso_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","hē upadēśaka śāstrē mūsā asmān pratīti lilēkha yasya bhrātā bhāryyāyāṁ satyāṁ niḥsantānō mriyatē sa tajjāyāṁ vivahya tadvaṁśam utpādayiṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","tathāca kēcit sapta bhrātara āsan tēṣāṁ jyēṣṭhō bhrātā vivahya nirapatyaḥ prāṇān jahau| ");
INSERT INTO saniso_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","atha dvitīyastasya jāyāṁ vivahya nirapatyaḥ san mamāra| tr̥tīyaśca tāmēva vyuvāha; ");
INSERT INTO saniso_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","itthaṁ sapta bhrātarastāmēva vivahya nirapatyāḥ santō mamruḥ| ");
INSERT INTO saniso_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","śēṣē sā strī ca mamāra| ");
INSERT INTO saniso_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ataēva śmaśānādutthānakālē tēṣāṁ saptajanānāṁ kasya sā bhāryyā bhaviṣyati? yataḥ sā tēṣāṁ saptānāmēva bhāryyāsīt| ");
INSERT INTO saniso_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","tadā yīśuḥ pratyuvāca, ētasya jagatō lōkā vivahanti vāgdattāśca bhavanti ");
INSERT INTO saniso_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","kintu yē tajjagatprāptiyōgyatvēna gaṇitāṁ bhaviṣyanti śmaśānāccōtthāsyanti tē na vivahanti vāgdattāśca na bhavanti, ");
INSERT INTO saniso_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","tē puna rna mriyantē kintu śmaśānādutthāpitāḥ santa īśvarasya santānāḥ svargīyadūtānāṁ sadr̥śāśca bhavanti| ");
INSERT INTO saniso_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","adhikantu mūsāḥ stambōpākhyānē paramēśvara ībrāhīma īśvara ishāka īśvarō yākūbaścēśvara ityuktvā mr̥tānāṁ śmaśānād utthānasya pramāṇaṁ lilēkha| ");
INSERT INTO saniso_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ataēva ya īśvaraḥ sa mr̥tānāṁ prabhu rna kintu jīvatāmēva prabhuḥ, tannikaṭē sarvvē jīvantaḥ santi| ");
INSERT INTO saniso_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","iti śrutvā kiyantōdhyāpakā ūcuḥ, hē upadēśaka bhavān bhadraṁ pratyuktavān| ");
INSERT INTO saniso_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","itaḥ paraṁ taṁ kimapi praṣṭaṁ tēṣāṁ pragalbhatā nābhūt| ");
INSERT INTO saniso_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","paścāt sa tān uvāca, yaḥ khrīṣṭaḥ sa dāyūdaḥ santāna ētāṁ kathāṁ lōkāḥ kathaṁ kathayanti? ");
INSERT INTO saniso_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","yataḥ mama prabhumidaṁ vākyamavadat paramēśvaraḥ| tava śatrūnahaṁ yāvat pādapīṭhaṁ karōmi na| tāvat kālaṁ madīyē tvaṁ dakṣapārśva upāviśa| ");
INSERT INTO saniso_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","iti kathāṁ dāyūd svayaṁ gītagranthē'vadat| ");
INSERT INTO saniso_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","ataēva yadi dāyūd taṁ prabhuṁ vadati, tarhi sa kathaṁ tasya santānō bhavati? ");
INSERT INTO saniso_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","paścād yīśuḥ sarvvajanānāṁ karṇagōcarē śiṣyānuvāca, ");
INSERT INTO saniso_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","yē'dhyāpakā dīrghaparicchadaṁ paridhāya bhramanti, haṭṭāpaṇayō rnamaskārē bhajanagēhasya prōccāsanē bhōjanagr̥hasya pradhānasthānē ca prīyantē ");
INSERT INTO saniso_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","vidhavānāṁ sarvvasvaṁ grasitvā chalēna dīrghakālaṁ prārthayantē ca tēṣu sāvadhānā bhavata, tēṣāmugradaṇḍō bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","atha dhanilōkā bhāṇḍāgārē dhanaṁ nikṣipanti sa tadēva paśyati, ");
INSERT INTO saniso_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ētarhi kāciddīnā vidhavā paṇadvayaṁ nikṣipati tad dadarśa| ");
INSERT INTO saniso_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","tatō yīśuruvāca yuṣmānahaṁ yathārthaṁ vadāmi, daridrēyaṁ vidhavā sarvvēbhyōdhikaṁ nyakṣēpsīt, ");
INSERT INTO saniso_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","yatōnyē svaprājyadhanēbhya īśvarāya kiñcit nyakṣēpsuḥ, kintu daridrēyaṁ vidhavā dinayāpanārthaṁ svasya yat kiñcit sthitaṁ tat sarvvaṁ nyakṣēpsīt| ");
INSERT INTO saniso_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","aparañca uttamaprastarairutsr̥ṣṭavyaiśca mandiraṁ suśōbhatētarāṁ kaiścidityuktē sa pratyuvāca ");
INSERT INTO saniso_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","yūyaṁ yadidaṁ nicayanaṁ paśyatha, asya pāṣāṇaikōpyanyapāṣāṇōpari na sthāsyati, sarvvē bhūsādbhaviṣyanti kālōyamāyāti| ");
INSERT INTO saniso_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","tadā tē papracchuḥ, hē gurō ghaṭanēdr̥śī kadā bhaviṣyati? ghaṭanāyā ētasyasaścihnaṁ vā kiṁ bhaviṣyati? ");
INSERT INTO saniso_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","tadā sa jagāda, sāvadhānā bhavata yathā yuṣmākaṁ bhramaṁ kōpi na janayati, khīṣṭōhamityuktvā mama nāmrā bahava upasthāsyanti sa kālaḥ prāyēṇōpasthitaḥ, tēṣāṁ paścānmā gacchata| ");
INSERT INTO saniso_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","yuddhasyōpaplavasya ca vārttāṁ śrutvā mā śaṅkadhvaṁ, yataḥ prathamam ētā ghaṭanā avaśyaṁ bhaviṣyanti kintu nāpātē yugāntō bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","aparañca kathayāmāsa, tadā dēśasya vipakṣatvēna dēśō rājyasya vipakṣatvēna rājyam utthāsyati, ");
INSERT INTO saniso_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","nānāsthānēṣu mahābhūkampō durbhikṣaṁ mārī ca bhaviṣyanti, tathā vyōmamaṇḍalasya bhayaṅkaradarśanānyaścaryyalakṣaṇāni ca prakāśayiṣyantē| ");
INSERT INTO saniso_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","kintu sarvvāsāmētāsāṁ ghaṭanānāṁ pūrvvaṁ lōkā yuṣmān dhr̥tvā tāḍayiṣyanti, bhajanālayē kārāyāñca samarpayiṣyanti mama nāmakāraṇād yuṣmān bhūpānāṁ śāsakānāñca sammukhaṁ nēṣyanti ca| ");
INSERT INTO saniso_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","sākṣyārtham ētāni yuṣmān prati ghaṭiṣyantē| ");
INSERT INTO saniso_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","tadā kimuttaraṁ vaktavyam ētat na cintayiṣyāma iti manaḥsu niścitanuta| ");
INSERT INTO saniso_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","vipakṣā yasmāt kimapyuttaram āpattiñca karttuṁ na śakṣyanti tādr̥śaṁ vākpaṭutvaṁ jñānañca yuṣmabhyaṁ dāsyāmi| ");
INSERT INTO saniso_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","kiñca yūyaṁ pitrā mātrā bhrātrā bandhunā jñātyā kuṭumbēna ca parakarēṣu samarpayiṣyadhvē; tatastē yuṣmākaṁ kañcana kañcana ghātayiṣyanti| ");
INSERT INTO saniso_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","mama nāmnaḥ kāraṇāt sarvvai rmanuṣyai ryūyam r̥tīyiṣyadhvē| ");
INSERT INTO saniso_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","kintu yuṣmākaṁ śiraḥkēśaikōpi na vinaṁkṣyati, ");
INSERT INTO saniso_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","tasmādēva dhairyyamavalambya svasvaprāṇān rakṣata| ");
INSERT INTO saniso_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","aparañca yirūśālampuraṁ sainyavēṣṭitaṁ vilōkya tasyōcchinnatāyāḥ samayaḥ samīpa ityavagamiṣyatha| ");
INSERT INTO saniso_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","tadā yihūdādēśasthā lōkāḥ parvvataṁ palāyantāṁ, yē ca nagarē tiṣṭhanti tē dēśāntaraṁ palāyantā, yē ca grāmē tiṣṭhanti tē nagaraṁ na praviśantu, ");
INSERT INTO saniso_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","yatastadā samucitadaṇḍanāya dharmmapustakē yāni sarvvāṇi likhitāni tāni saphalāni bhaviṣyanti| ");
INSERT INTO saniso_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","kintu yā yāstadā garbhavatyaḥ stanyadāvyaśca tāmāṁ durgati rbhaviṣyati, yata ētāllōkān prati kōpō dēśē ca viṣamadurgati rghaṭiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","vastutastu tē khaṅgadhāraparivvaṅgaṁ lapsyantē baddhāḥ santaḥ sarvvadēśēṣu nāyiṣyantē ca kiñcānyadēśīyānāṁ samayōpasthitiparyyantaṁ yirūśālampuraṁ taiḥ padatalai rdalayiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","sūryyacandranakṣatrēṣu lakṣaṇādi bhaviṣyanti, bhuvi sarvvadēśīyānāṁ duḥkhaṁ cintā ca sindhau vīcīnāṁ tarjanaṁ garjanañca bhaviṣyanti| ");
INSERT INTO saniso_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","bhūbhau bhāvighaṭanāṁ cintayitvā manujā bhiyāmr̥takalpā bhaviṣyanti, yatō vyōmamaṇḍalē tējasvinō dōlāyamānā bhaviṣyanti| ");
INSERT INTO saniso_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","tadā parākramēṇā mahātējasā ca mēghārūḍhaṁ manuṣyaputram āyāntaṁ drakṣyanti| ");
INSERT INTO saniso_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","kintvētāsāṁ ghaṭanānāmārambhē sati yūyaṁ mastakānyuttōlya ūrdadhvaṁ drakṣyatha, yatō yuṣmākaṁ muktēḥ kālaḥ savidhō bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","tatastēnaitadr̥ṣṭāntakathā kathitā, paśyata uḍumbarādivr̥kṣāṇāṁ ");
INSERT INTO saniso_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","navīnapatrāṇi jātānīti dr̥ṣṭvā nidāvakāla upasthita iti yathā yūyaṁ jñātuṁ śaknutha, ");
INSERT INTO saniso_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","tathā sarvvāsāmāsāṁ ghaṭanānām ārambhē dr̥ṣṭē satīśvarasya rājatvaṁ nikaṭam ityapi jñāsyatha| ");
INSERT INTO saniso_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","yuṣmānahaṁ yathārthaṁ vadāmi, vidyamānalōkānāmēṣāṁ gamanāt pūrvvam ētāni ghaṭiṣyantē| ");
INSERT INTO saniso_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","nabhōbhuvōrlōpō bhaviṣyati mama vāk tu kadāpi luptā na bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","ataēva viṣamāśanēna pānēna ca sāṁmārikacintābhiśca yuṣmākaṁ cittēṣu mattēṣu taddinam akasmād yuṣmān prati yathā nōpatiṣṭhati tadarthaṁ svēṣu sāvadhānāstiṣṭhata| ");
INSERT INTO saniso_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","pr̥thivīsthasarvvalōkān prati taddinam unmātha iva upasthāsyati| ");
INSERT INTO saniso_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","yathā yūyam ētadbhāvighaṭanā uttarttuṁ manujasutasya sammukhē saṁsthātuñca yōgyā bhavatha kāraṇādasmāt sāvadhānāḥ santō nirantaraṁ prārthayadhvaṁ| ");
INSERT INTO saniso_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","aparañca sa divā mandira upadiśya rācai jaitunādriṁ gatvātiṣṭhat| ");
INSERT INTO saniso_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","tataḥ pratyūṣē lākāstatkathāṁ śrōtuṁ mandirē tadantikam āgacchan| ");
INSERT INTO saniso_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","aparañca kiṇvaśūnyapūpōtsavasya kāla upasthitē ");
INSERT INTO saniso_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","pradhānayājakā adhyāyakāśca yathā taṁ hantuṁ śaknuvanti tathōpāyām acēṣṭanta kintu lōkēbhyō bibhyuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ētastin samayē dvādaśaśiṣyēṣu gaṇita īṣkariyōtīyarūḍhimān yō yihūdāstasyāntaḥkaraṇaṁ śaitānāśritatvāt ");
INSERT INTO saniso_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","sa gatvā yathā yīśuṁ tēṣāṁ karēṣu samarpayituṁ śaknōti tathā mantraṇāṁ pradhānayājakaiḥ sēnāpatibhiśca saha cakāra| ");
INSERT INTO saniso_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","tēna tē tuṣṭāstasmai mudrāṁ dātuṁ paṇaṁ cakruḥ| ");
INSERT INTO saniso_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","tataḥ sōṅgīkr̥tya yathā lōkānāmagōcarē taṁ parakarēṣu samarpayituṁ śaknōti tathāvakāśaṁ cēṣṭitumārēbhē| ");
INSERT INTO saniso_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","atha kiṇvaśūnyapūpōtmavadinē, arthāt yasmin dinē nistārōtsavasya mēṣō hantavyastasmin dinē ");
INSERT INTO saniso_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","yīśuḥ pitaraṁ yōhanañcāhūya jagāda, yuvāṁ gatvāsmākaṁ bhōjanārthaṁ nistārōtsavasya dravyāṇyāsādayataṁ| ");
INSERT INTO saniso_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","tadā tau papracchatuḥ kucāsādayāvō bhavataḥ kēcchā? ");
INSERT INTO saniso_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","tadā sōvādīt, nagarē praviṣṭē kaścijjalakumbhamādāya yuvāṁ sākṣāt kariṣyati sa yannivēśanaṁ praviśati yuvāmapi tannivēśanaṁ tatpaścāditvā nivēśanapatim iti vākyaṁ vadataṁ, ");
INSERT INTO saniso_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","yatrāhaṁ nistārōtsavasya bhōjyaṁ śiṣyaiḥ sārddhaṁ bhōktuṁ śaknōmi sātithiśālāा kutra? kathāmimāṁ prabhustvāṁ pr̥cchati| ");
INSERT INTO saniso_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","tataḥ sa janō dvitīyaprakōṣṭhīyam ēkaṁ śastaṁ kōṣṭhaṁ darśayiṣyati tatra bhōjyamāsādayataṁ| ");
INSERT INTO saniso_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","tatastau gatvā tadvākyānusārēṇa sarvvaṁ dr̥ṣdvā tatra nistārōtsavīyaṁ bhōjyamāsādayāmāsatuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","atha kāla upasthitē yīśu rdvādaśabhiḥ prēritaiḥ saha bhōktumupaviśya kathitavān ");
INSERT INTO saniso_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","mama duḥkhabhōgāt pūrvvaṁ yubhābhiḥ saha nistārōtsavasyaitasya bhōjyaṁ bhōktuṁ mayātivāñchā kr̥tā| ");
INSERT INTO saniso_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","yuṣmān vadāmi, yāvatkālam īśvararājyē bhōjanaṁ na kariṣyē tāvatkālam idaṁ na bhōkṣyē| ");
INSERT INTO saniso_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","tadā sa pānapātramādāya īśvarasya guṇān kīrttayitvā tēbhyō datvāvadat, idaṁ gr̥hlīta yūyaṁ vibhajya pivata| ");
INSERT INTO saniso_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","yuṣmān vadāmi yāvatkālam īśvararājatvasya saṁsthāpanaṁ na bhavati tāvad drākṣāphalarasaṁ na pāsyāmi| ");
INSERT INTO saniso_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","tataḥ pūpaṁ gr̥hītvā īśvaraguṇān kīrttayitvā bhaṅktā tēbhyō datvāvadat, yuṣmadarthaṁ samarpitaṁ yanmama vapustadidaṁ, ētat karmma mama smaraṇārthaṁ kurudhvaṁ| ");
INSERT INTO saniso_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","atha bhōjanāntē tādr̥śaṁ pātraṁ gr̥hītvāvadat, yuṣmatkr̥tē pātitaṁ yanmama raktaṁ tēna nirṇītanavaniyamarūpaṁ pānapātramidaṁ| ");
INSERT INTO saniso_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","paśyata yō māṁ parakarēṣu samarpayiṣyati sa mayā saha bhōjanāsana upaviśati| ");
INSERT INTO saniso_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","yathā nirūpitamāstē tadanusārēṇā manuṣyapuुtrasya gati rbhaviṣyati kintu yastaṁ parakarēṣu samarpayiṣyati tasya santāpō bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","tadā tēṣāṁ kō jana ētat karmma kariṣyati tat tē parasparaṁ praṣṭumārēbhirē| ");
INSERT INTO saniso_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","aparaṁ tēṣāṁ kō janaḥ śrēṣṭhatvēna gaṇayiṣyatē, atrārthē tēṣāṁ vivādōbhavat| ");
INSERT INTO saniso_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","asmāt kāraṇāt sōvadat, anyadēśīyānāṁ rājānaḥ prajānāmupari prabhutvaṁ kurvvanti dāruṇaśāsanaṁ kr̥tvāpi tē bhūpatitvēna vikhyātā bhavanti ca| ");
INSERT INTO saniso_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","kintu yuṣmākaṁ tathā na bhaviṣyati, yō yuṣmākaṁ śrēṣṭhō bhaviṣyati sa kaniṣṭhavad bhavatu, yaśca mukhyō bhaviṣyati sa sēvakavadbhavatu| ");
INSERT INTO saniso_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","bhōjanōpaviṣṭaparicārakayōḥ kaḥ śrēṣṭhaḥ? yō bhōjanāyōpaviśati sa kiṁ śrēṣṭhō na bhavati? kintu yuṣmākaṁ madhyē'haṁ paricāraka̮ivāsmi| ");
INSERT INTO saniso_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","aparañca yuyaṁ mama parīkṣākālē prathamamārabhya mayā saha sthitā ");
INSERT INTO saniso_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ētatkāraṇāt pitrā yathā madarthaṁ rājyamēkaṁ nirūpitaṁ tathāhamapi yuṣmadarthaṁ rājyaṁ nirūpayāmi| ");
INSERT INTO saniso_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","tasmān mama rājyē bhōjanāsanē ca bhōjanapānē kariṣyadhvē siṁhāsanēṣūpaviśya cēsrāyēlīyānāṁ dvādaśavaṁśānāṁ vicāraṁ kariṣyadhvē| ");
INSERT INTO saniso_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","aparaṁ prabhuruvāca, hē śimōn paśya tita̮unā dhānyānīva yuṣmān śaitān cālayitum aicchat, ");
INSERT INTO saniso_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","kintu tava viśvāsasya lōpō yathā na bhavati ētat tvadarthaṁ prārthitaṁ mayā, tvanmanasi parivarttitē ca bhrātr̥ṇāṁ manāṁsi sthirīkuru| ");
INSERT INTO saniso_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","tadā sōvadat, hē prabhōhaṁ tvayā sārddhaṁ kārāṁ mr̥tiñca yātuṁ majjitōsmi| ");
INSERT INTO saniso_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","tataḥ sa uvāca, hē pitara tvāṁ vadāmi, adya kukkuṭaravāt pūrvvaṁ tvaṁ matparicayaṁ vāratrayam apahvōṣyasē| ");
INSERT INTO saniso_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","aparaṁ sa papraccha, yadā mudrāsampuṭaṁ khādyapātraṁ pādukāñca vinā yuṣmān prāhiṇavaṁ tadā yuṣmākaṁ kasyāpi nyūnatāsīt? tē prōcuḥ kasyāpi na| ");
INSERT INTO saniso_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","tadā sōvadat kintvidānīṁ mudrāsampuṭaṁ khādyapātraṁ vā yasyāsti tēna tadgrahītavyaṁ, yasya ca kr̥pāṇōे nāsti tēna svavastraṁ vikrīya sa krētavyaḥ| ");
INSERT INTO saniso_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","yatō yuṣmānahaṁ vadāmi, aparādhijanaiḥ sārddhaṁ gaṇitaḥ sa bhaviṣyati| idaṁ yacchāstrīyaṁ vacanaṁ likhitamasti tanmayi phaliṣyati yatō mama sambandhīyaṁ sarvvaṁ sētsyati| ");
INSERT INTO saniso_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","tadā tē prōcuḥ prabhō paśya imau kr̥pāṇau| tataḥ sōvadad ētau yathēṣṭau| ");
INSERT INTO saniso_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","atha sa tasmādvahi rgatvā svācārānusārēṇa jaitunanāmādriṁ jagāma śiṣyāśca tatpaścād yayuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","tatrōpasthāya sa tānuvāca, yathā parīkṣāyāṁ na patatha tadarthaṁ prārthayadhvaṁ| ");
INSERT INTO saniso_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","paścāt sa tasmād ēkaśarakṣēpād bahi rgatvā jānunī pātayitvā ētat prārthayāñcakrē, ");
INSERT INTO saniso_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","hē pita ryadi bhavān sammanyatē tarhi kaṁsamēnaṁ mamāntikād dūraya kintu madicchānurūpaṁ na tvadicchānurūpaṁ bhavatu| ");
INSERT INTO saniso_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","tadā tasmai śaktiṁ dātuṁ svargīyadūtō darśanaṁ dadau| ");
INSERT INTO saniso_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","paścāt sōtyantaṁ yātanayā vyākulō bhūtvā punardr̥ḍhaṁ prārthayāñcakrē, tasmād br̥hacchōṇitabindava iva tasya svēdabindavaḥ pr̥thivyāṁ patitumārēbhirē| ");
INSERT INTO saniso_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","atha prārthanāta utthāya śiṣyāṇāṁ samīpamētya tān manōduḥkhinō nidritān dr̥ṣṭvāvadat ");
INSERT INTO saniso_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","kutō nidrātha? parīkṣāyām apatanārthaṁ prarthayadhvaṁ| ");
INSERT INTO saniso_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ētatkathāyāḥ kathanakālē dvādaśaśiṣyāṇāṁ madhyē gaṇitō yihūdānāmā janatāsahitastēṣām agrē calitvā yīśōścumbanārthaṁ tadantikam āyayau| ");
INSERT INTO saniso_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","tadā yīśuruvāca, hē yihūdā kiṁ cumbanēna manuṣyaputraṁ parakarēṣu samarpayasi? ");
INSERT INTO saniso_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","tadā yadyad ghaṭiṣyatē tadanumāya saṅgibhiruktaṁ, hē prabhō vayaṁ ki khaṅgēna ghātayiṣyāmaḥ? ");
INSERT INTO saniso_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","tata ēkaḥ karavālēnāhatya pradhānayājakasya dāsasya dakṣiṇaṁ karṇaṁ cicchēda| ");
INSERT INTO saniso_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","adhūnā nivarttasva ityuktvā yīśustasya śrutiṁ spr̥ṣṭvā svasyaṁ cakāra| ");
INSERT INTO saniso_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","paścād yīśuḥ samīpasthān pradhānayājakān mandirasya sēnāpatīn prācīnāṁśca jagāda, yūyaṁ kr̥pāṇān yaṣṭīṁśca gr̥hītvā māṁ kiṁ cōraṁ dharttumāyātāḥ? ");
INSERT INTO saniso_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","yadāhaṁ yuṣmābhiḥ saha pratidinaṁ mandirē'tiṣṭhaṁ tadā māṁ dharttaṁ na pravr̥ttāḥ, kintvidānīṁ yuṣmākaṁ samayōndhakārasya cādhipatyamasti| ");
INSERT INTO saniso_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","atha tē taṁ dhr̥tvā mahāyājakasya nivēśanaṁ ninyuḥ| tataḥ pitarō dūrē dūrē paścāditvā ");
INSERT INTO saniso_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","br̥hatkōṣṭhasya madhyē yatrāgniṁ jvālayitvā lōkāḥ samētyōpaviṣṭāstatra taiḥ sārddham upavivēśa| ");
INSERT INTO saniso_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","atha vahnisannidhau samupavēśakālē kāciddāsī manō niviśya taṁ nirīkṣyāvadat pumānayaṁ tasya saṅgē'sthāt| ");
INSERT INTO saniso_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","kintu sa tad apahnutyāvādīt hē nāri tamahaṁ na paricinōmi| ");
INSERT INTO saniso_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","kṣaṇāntarē'nyajanastaṁ dr̥ṣṭvābravīt tvamapi tēṣāṁ nikarasyaikajanōsi| pitaraḥ pratyuvāca hē nara nāhamasmi| ");
INSERT INTO saniso_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","tataḥ sārddhadaṇḍadvayāt paraṁ punaranyō janō niścitya babhāṣē, ēṣa tasya saṅgīti satyaṁ yatōyaṁ gālīlīyō lōkaḥ| ");
INSERT INTO saniso_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","tadā pitara uvāca hē nara tvaṁ yad vadami tadahaṁ bōddhuṁ na śaknōmi, iti vākyē kathitamātrē kukkuṭō rurāva| ");
INSERT INTO saniso_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","tadā prabhuṇā vyādhuṭya pitarē nirīkṣitē kr̥kavākuravāt pūrvvaṁ māṁ trirapahnōṣyasē iti pūrvvōktaṁ tasya vākyaṁ pitaraḥ smr̥tvā ");
INSERT INTO saniso_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","bahirgatvā mahākhēdēna cakranda| ");
INSERT INTO saniso_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","tadā yai ryīśurdhr̥tastē tamupahasya praharttumārēbhirē| ");
INSERT INTO saniso_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","vastrēṇa tasya dr̥śau baddhvā kapōlē capēṭāghātaṁ kr̥tvā papracchuḥ, kastē kapōlē capēṭāghātaṁ kr̥tavāna? gaṇayitvā tad vada| ");
INSERT INTO saniso_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","tadanyat tadviruddhaṁ bahunindāvākyaṁ vaktumārēbhirē| ");
INSERT INTO saniso_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","atha prabhātē sati lōkaprāñcaḥ pradhānayājakā adhyāpakāśca sabhāṁ kr̥tvā madhyēsabhaṁ yīśumānīya papracchuḥ, tvam abhiṣikatōsi na vāsmān vada| ");
INSERT INTO saniso_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","sa pratyuvāca, mayā tasminnuktē'pi yūyaṁ na viśvasiṣyatha| ");
INSERT INTO saniso_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","kasmiṁścidvākyē yuṣmān pr̥ṣṭē'pi māṁ na taduttaraṁ vakṣyatha na māṁ tyakṣyatha ca| ");
INSERT INTO saniso_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","kintvitaḥ paraṁ manujasutaḥ sarvvaśaktimata īśvarasya dakṣiṇē pārśvē samupavēkṣyati| ");
INSERT INTO saniso_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","tatastē papracchuḥ, rtiha tvamīśvarasya putraḥ? sa kathayāmāsa, yūyaṁ yathārthaṁ vadatha sa ēvāhaṁ| ");
INSERT INTO saniso_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","tadā tē sarvvē kathayāmāsuḥ, rtiha sākṣyē'nsasmin asmākaṁ kiṁ prayōjanaṁ? asya svamukhādēva sākṣyaṁ prāptam| ");
INSERT INTO saniso_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","tataḥ sabhāsthāḥ sarvvalōkā utthāya taṁ pīlātasammukhaṁ nītvāprōdya vaktumārēbhirē, ");
INSERT INTO saniso_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","svamabhiṣiktaṁ rājānaṁ vadantaṁ kaimararājāya karadānaṁ niṣēdhantaṁ rājyaviparyyayaṁ kurttuṁ pravarttamānam ēna prāptā vayaṁ| ");
INSERT INTO saniso_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","tadā pīlātastaṁ pr̥ṣṭavān tvaṁ kiṁ yihūdīyānāṁ rājā? sa pratyuvāca tvaṁ satyamuktavān| ");
INSERT INTO saniso_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","tadā pīlātaḥ pradhānayājakādilōkān jagād, ahamētasya kamapyaparādhaṁ nāptavān| ");
INSERT INTO saniso_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","tatastē punaḥ sāhaminō bhūtvāvadan, ēṣa gālīla ētatsthānaparyyantē sarvvasmin yihūdādēśē sarvvāllōkānupadiśya kupravr̥ttiṁ grāhītavān| ");
INSERT INTO saniso_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","tadā pīlātō gālīlapradēśasya nāma śrutvā papraccha, kimayaṁ gālīlīyō lōkaḥ? ");
INSERT INTO saniso_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","tataḥ sa gālīlpradēśīyahērōdrājasya tadā sthitēstasya samīpē yīśuṁ prēṣayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","tadā hērōd yīśuṁ vilōkya santutōṣa, yataḥ sa tasya bahuvr̥ttāntaśravaṇāt tasya kiñi्cadāścaryyakarmma paśyati ityāśāṁ kr̥tvā bahukālamārabhya taṁ draṣṭuṁ prayāsaṁ kr̥tavān| ");
INSERT INTO saniso_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","tasmāt taṁ bahukathāḥ papraccha kintu sa tasya kasyāpi vākyasya pratyuttaraṁ nōvāca| ");
INSERT INTO saniso_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","atha pradhānayājakā adhyāpakāśca prōttiṣṭhantaḥ sāhasēna tamapavadituṁ prārēbhirē| ");
INSERT INTO saniso_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","hērōd tasya sēnāgaṇaśca tamavajñāya upahāsatvēna rājavastraṁ paridhāpya punaḥ pīlātaṁ prati taṁ prāhiṇōt| ");
INSERT INTO saniso_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","pūrvvaṁ hērōdpīlātayōḥ parasparaṁ vairabhāva āsīt kintu taddinē dvayō rmēlanaṁ jātam| ");
INSERT INTO saniso_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","paścāt pīlātaḥ pradhānayājakān śāsakān lōkāṁśca yugapadāhūya babhāṣē, ");
INSERT INTO saniso_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","rājyaviparyyayakārakōyam ityuktvā manuṣyamēnaṁ mama nikaṭamānaiṣṭa kintu paśyata yuṣmākaṁ samakṣam asya vicāraṁ kr̥tvāpi prōktāpavādānurūpēṇāsya kōpyaparādhaḥ sapramāṇō na jātaḥ, ");
INSERT INTO saniso_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","yūyañca hērōdaḥ sannidhau prēṣitā mayā tatrāsya kōpyaparādhastēnāpi na prāptaḥ|paśyatānēna vadhahēेtukaṁ kimapi nāparāddhaṁ| ");
INSERT INTO saniso_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","tasmādēnaṁ tāḍayitvā vihāsyāmi| ");
INSERT INTO saniso_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","tatrōtsavē tēṣāmēkō mōcayitavyaḥ| ");
INSERT INTO saniso_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","iti hētōstē prōccairēkadā prōcuḥ, ēnaṁ dūrīkr̥tya barabbānāmānaṁ mōcaya| ");
INSERT INTO saniso_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","sa barabbā nagara upaplavavadhāparādhābhyāṁ kārāyāṁ baddha āsīt| ");
INSERT INTO saniso_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","kintu pīlātō yīśuṁ mōcayituṁ vāñchan punastānuvāca| ");
INSERT INTO saniso_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","tathāpyēnaṁ kruśē vyadha kruśē vyadhēti vadantastē ruruvuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","tataḥ sa tr̥tīyavāraṁ jagāda kutaḥ? sa kiṁ karmma kr̥tavān? nāhamasya kamapi vadhāparādhaṁ prāptaḥ kēvalaṁ tāḍayitvāmuṁ tyajāmi| ");
INSERT INTO saniso_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","tathāpi tē punarēnaṁ kruśē vyadha ityuktvā prōccairdr̥ḍhaṁ prārthayāñcakrirē; ");
INSERT INTO saniso_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","tataḥ pradhānayājakādīnāṁ kalaravē prabalē sati tēṣāṁ prārthanārūpaṁ karttuṁ pīlāta ādidēśa| ");
INSERT INTO saniso_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","rājadrōhavadhayōraparādhēna kārāsthaṁ yaṁ janaṁ tē yayācirē taṁ mōcayitvā yīśuṁ tēṣāmicchāyāṁ samārpayat| ");
INSERT INTO saniso_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","atha tē yīśuṁ gr̥hītvā yānti, ētarhi grāmādāgataṁ śimōnanāmānaṁ kurīṇīyaṁ janaṁ dhr̥tvā yīśōḥ paścānnētuṁ tasya skandhē kruśamarpayāmāsuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","tatō lōाkāraṇyamadhyē bahustriyō rudatyō vilapantyaśca yīśōḥ paścād yayuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","kintu sa vyāghuṭya tā uvāca, hē yirūśālamō nāryyō yuyaṁ madarthaṁ na ruditvā svārthaṁ svāpatyārthañca ruditi; ");
INSERT INTO saniso_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","paśyata yaḥ kadāpi garbhavatyō nābhavan stanyañca nāpāyayan tādr̥śī rvandhyā yadā dhanyā vakṣyanti sa kāla āyāti| ");
INSERT INTO saniso_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","tadā hē śailā asmākamupari patata, hē upaśailā asmānācchādayata kathāmīdr̥śīṁ lōkā vakṣyanti| ");
INSERT INTO saniso_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","yataḥ satējasi śākhini cēdētad ghaṭatē tarhi śuṣkaśākhini kiṁ na ghaṭiṣyatē? ");
INSERT INTO saniso_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","tadā tē hantuṁ dvāvaparādhinau tēna sārddhaṁ ninyuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","aparaṁ śiraḥkapālanāmakasthānaṁ prāpya taṁ kruśē vividhuḥ; taddvayōraparādhinōrēkaṁ tasya dakṣiṇō tadanyaṁ vāmē kruśē vividhuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","tadā yīśurakathayat, hē pitarētān kṣamasva yata ētē yat karmma kurvvanti tan na viduḥ; paścāttē guṭikāpātaṁ kr̥tvā tasya vastrāṇi vibhajya jagr̥huḥ| ");
INSERT INTO saniso_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","tatra lōkasaṁghastiṣṭhan dadarśa; tē tēṣāṁ śāsakāśca tamupahasya jagaduḥ, ēṣa itarān rakṣitavān yadīśvarēṇābhirucitō 'bhiṣiktastrātā bhavati tarhi svamadhunā rakṣatu| ");
INSERT INTO saniso_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","tadanyaḥ sēnāgaṇā ētya tasmai amlarasaṁ datvā parihasya prōvāca, ");
INSERT INTO saniso_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","cēttvaṁ yihūdīyānāṁ rājāsi tarhi svaṁ rakṣa| ");
INSERT INTO saniso_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","yihūdīyānāṁ rājēti vākyaṁ yūnānīyarōmīyēbrīyākṣarai rlikhitaṁ tacchirasa ūrddhvē'sthāpyata| ");
INSERT INTO saniso_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","tadōbhayapārśvayō rviddhau yāvaparādhinau tayōrēkastaṁ vinindya babhāṣē, cēttvam abhiṣiktōsi tarhi svamāvāñca rakṣa| ");
INSERT INTO saniso_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","kintvanyastaṁ tarjayitvāvadat, īśvarāttava kiñcidapi bhayaṁ nāsti kiṁ? tvamapi samānadaṇḍōsi, ");
INSERT INTO saniso_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","yōgyapātrē āvāṁ svasvakarmmaṇāṁ samucitaphalaṁ prāpnuvaḥ kintvanēna kimapi nāparāddhaṁ| ");
INSERT INTO saniso_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","atha sa yīśuṁ jagāda hē prabhē bhavān svarājyapravēśakālē māṁ smaratu| ");
INSERT INTO saniso_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","tadā yīśuḥ kathitavān tvāṁ yathārthaṁ vadāmi tvamadyaiva mayā sārddhaṁ paralōkasya sukhasthānaṁ prāpsyasi| ");
INSERT INTO saniso_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","aparañca dvitīyayāmāt tr̥tīyayāmaparyyantaṁ ravēstējasōntarhitatvāt sarvvadēśō'ndhakārēṇāvr̥tō ");
INSERT INTO saniso_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","mandirasya yavanikā ca chidyamānā dvidhā babhūva| ");
INSERT INTO saniso_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","tatō yīśuruccairuvāca, hē pita rmamātmānaṁ tava karē samarpayē, ityuktvā sa prāṇān jahau| ");
INSERT INTO saniso_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","tadaitā ghaṭanā dr̥ṣṭvā śatasēnāpatirīśvaraṁ dhanyamuktvā kathitavān ayaṁ nitāntaṁ sādhumanuṣya āsīt| ");
INSERT INTO saniso_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","atha yāvantō lōkā draṣṭum āgatāstē tā ghaṭanā dr̥ṣṭvā vakṣaḥsu karāghātaṁ kr̥tvā vyācuṭya gatāḥ| ");
INSERT INTO saniso_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","yīśō rjñātayō yā yā yōṣitaśca gālīlastēna sārddhamāyātāstā api dūrē sthitvā tat sarvvaṁ dadr̥śuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","tadā yihūdīyānāṁ mantraṇāṁ kriyāñcāsammanyamāna īśvarasya rājatvam apēkṣamāṇō ");
INSERT INTO saniso_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","yihūdidēśīyō 'rimathīyanagarīyō yūṣaphnāmā mantrī bhadrō dhārmmikaśca pumān ");
INSERT INTO saniso_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","pīlātāntikaṁ gatvā yīśō rdēhaṁ yayācē| ");
INSERT INTO saniso_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","paścād vapuravarōhya vāsasā saṁvēṣṭya yatra kōpi mānuṣō nāsthāpyata tasmin śailē svātē śmaśānē tadasthāpayat| ");
INSERT INTO saniso_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","taddinamāyōjanīyaṁ dinaṁ viśrāmavāraśca samīpaḥ| ");
INSERT INTO saniso_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","aparaṁ yīśunā sārddhaṁ gālīla āgatā yōṣitaḥ paścāditvā śmaśānē tatra yathā vapuḥ sthāpitaṁ tacca dr̥ṣṭvā ");
INSERT INTO saniso_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","vyāghuṭya sugandhidravyatailāni kr̥tvā vidhivad viśrāmavārē viśrāmaṁ cakruḥ| ");
INSERT INTO saniso_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","atha saptāhaprathamadinē'tipratyūṣē tā yōṣitaḥ sampāditaṁ sugandhidravyaṁ gr̥hītvā tadanyābhiḥ kiyatībhiḥ strībhiḥ saha śmaśānaṁ yayuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","kintu śmaśānadvārāt pāṣāṇamapasāritaṁ dr̥ṣṭvā ");
INSERT INTO saniso_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","tāḥ praviśya prabhō rdēhamaprāpya ");
INSERT INTO saniso_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","vyākulā bhavanti ētarhi tējōmayavastrānvitau dvau puruṣau tāsāṁ samīpē samupasthitau ");
INSERT INTO saniso_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","tasmāttāḥ śaṅkāyuktā bhūmāvadhōmukhyasyasthuḥ| tadā tau tā ūcatu rmr̥tānāṁ madhyē jīvantaṁ kutō mr̥gayatha? ");
INSERT INTO saniso_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","sōtra nāsti sa udasthāt| ");
INSERT INTO saniso_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","pāpināṁ karēṣu samarpitēna kruśē hatēna ca manuṣyaputrēṇa tr̥tīyadivasē śmaśānādutthātavyam iti kathāṁ sa galīli tiṣṭhan yuṣmabhyaṁ kathitavān tāṁ smarata| ");
INSERT INTO saniso_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","tadā tasya sā kathā tāsāṁ manaḥsu jātā| ");
INSERT INTO saniso_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","anantaraṁ śmaśānād gatvā tā ēkādaśaśiṣyādibhyaḥ sarvvēbhyastāṁ vārttāṁ kathayāmāsuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","magdalīnīmariyam, yōhanā, yākūbō mātā mariyam tadanyāḥ saṅginyō yōṣitaśca prēritēbhya ētāḥ sarvvā vārttāḥ kathayāmāsuḥ ");
INSERT INTO saniso_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","kintu tāsāṁ kathām anarthakākhyānamātraṁ buddhvā kōpi na pratyait| ");
INSERT INTO saniso_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","tadā pitara utthāya śmaśānāntikaṁ dadhāva, tatra ca prahvō bhūtvā pārśvaikasthāpitaṁ kēvalaṁ vastraṁ dadarśa; tasmādāścaryyaṁ manyamānō yadaghaṭata tanmanasi vicārayan pratasthē| ");
INSERT INTO saniso_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","tasminnēva dinē dvau śiyyau yirūśālamaścatuṣkrōśāntaritam immāyugrāmaṁ gacchantau ");
INSERT INTO saniso_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","tāsāṁ ghaṭanānāṁ kathāmakathayatāṁ ");
INSERT INTO saniso_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","tayōrālāpavicārayōḥ kālē yīśurāgatya tābhyāṁ saha jagāma ");
INSERT INTO saniso_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","kintu yathā tau taṁ na paricinutastadarthaṁ tayō rdr̥ṣṭiḥ saṁruddhā| ");
INSERT INTO saniso_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","sa tau pr̥ṣṭavān yuvāṁ viṣaṇṇau kiṁ vicārayantau gacchathaḥ? ");
INSERT INTO saniso_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","tatastayōḥ kliyapānāmā pratyuvāca yirūśālamapurē'dhunā yānyaghaṭanta tvaṁ kēvalavidēśī kiṁ tadvr̥ttāntaṁ na jānāsi? ");
INSERT INTO saniso_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","sa papraccha kā ghaṭanāḥ? tadā tau vaktumārēbhātē yīśunāmā yō nāsaratīyō bhaviṣyadvādī īśvarasya mānuṣāṇāñca sākṣāt vākyē karmmaṇi ca śaktimānāsīt ");
INSERT INTO saniso_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","tam asmākaṁ pradhānayājakā vicārakāśca kēnāpi prakārēṇa kruśē viddhvā tasya prāṇānanāśayan tadīyā ghaṭanāḥ; ");
INSERT INTO saniso_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","kintu ya isrāyēlīyalōkān uddhārayiṣyati sa ēvāyam ityāśāsmābhiḥ kr̥tā|tadyathā tathāstu tasyā ghaṭanāyā adya dinatrayaṁ gataṁ| ");
INSERT INTO saniso_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","adhikantvasmākaṁ saṅginīnāṁ kiyatstrīṇāṁ mukhēbhyō'sambhavavākyamidaṁ śrutaṁ; ");
INSERT INTO saniso_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","tāḥ pratyūṣē śmaśānaṁ gatvā tatra tasya dēham aprāpya vyāghuṭyētvā prōktavatyaḥ svargīsadūtau dr̥ṣṭāvasmābhistau cāvādiṣṭāṁ sa jīvitavān| ");
INSERT INTO saniso_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","tatōsmākaṁ kaiścit śmaśānamagamyata tē'pi strīṇāṁ vākyānurūpaṁ dr̥ṣṭavantaḥ kintu taṁ nāpaśyan| ");
INSERT INTO saniso_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","tadā sa tāvuvāca, hē abōdhau hē bhaviṣyadvādibhiruktavākyaṁ pratyētuṁ vilambamānau; ");
INSERT INTO saniso_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ētatsarvvaduḥkhaṁ bhuktvā svabhūtiprāptiḥ kiṁ khrīṣṭasya na nyāyyā? ");
INSERT INTO saniso_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","tataḥ sa mūsāgranthamārabhya sarvvabhaviṣyadvādināṁ sarvvaśāstrē svasmin likhitākhyānābhiprāyaṁ bōdhayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","atha gamyagrāmābhyarṇaṁ prāpya tēnāgrē gamanalakṣaṇē darśitē ");
INSERT INTO saniso_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","tau sādhayitvāvadatāṁ sahāvābhyāṁ tiṣṭha dinē gatē sati rātrirabhūt; tataḥ sa tābhyāṁ sārddhaṁ sthātuṁ gr̥haṁ yayau| ");
INSERT INTO saniso_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","paścādbhōjanōpavēśakālē sa pūpaṁ gr̥hītvā īśvaraguṇān jagāda tañca bhaṁktvā tābhyāṁ dadau| ");
INSERT INTO saniso_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","tadā tayō rdr̥ṣṭau prasannāyāṁ taṁ pratyabhijñatuḥ kintu sa tayōḥ sākṣādantardadhē| ");
INSERT INTO saniso_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","tatastau mithōbhidhātum ārabdhavantau gamanakālē yadā kathāmakathayat śāstrārthañcabōdhayat tadāvayō rbuddhiḥ kiṁ na prājvalat? ");
INSERT INTO saniso_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","tau tatkṣaṇādutthāya yirūśālamapuraṁ pratyāyayatuḥ, tatsthānē śiṣyāṇām ēkādaśānāṁ saṅgināñca darśanaṁ jātaṁ| ");
INSERT INTO saniso_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","tē prōcuḥ prabhurudatiṣṭhad iti satyaṁ śimōnē darśanamadācca| ");
INSERT INTO saniso_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","tataḥ pathaḥ sarvvaghaṭanāyāḥ pūpabhañjanēna tatparicayasya ca sarvvavr̥ttāntaṁ tau vaktumārēbhātē| ");
INSERT INTO saniso_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","itthaṁ tē parasparaṁ vadanti tatkālē yīśuḥ svayaṁ tēṣāṁ madhya prōtthaya yuṣmākaṁ kalyāṇaṁ bhūyād ityuvāca, ");
INSERT INTO saniso_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","kintu bhūtaṁ paśyāma ityanumāya tē samudvivijirē trēṣuśca| ");
INSERT INTO saniso_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","sa uvāca, kutō duḥkhitā bhavatha? yuṣmākaṁ manaḥsu sandēha udēti ca kutaḥ? ");
INSERT INTO saniso_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ēṣōhaṁ, mama karau paśyata varaṁ spr̥ṣṭvā paśyata, mama yādr̥śāni paśyatha tādr̥śāni bhūtasya māṁsāsthīni na santi| ");
INSERT INTO saniso_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ityuktvā sa hastapādān darśayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","tē'sambhavaṁ jñātvā sānandā na pratyayan| tataḥ sa tān papraccha, atra yuṣmākaṁ samīpē khādyaṁ kiñcidasti? ");
INSERT INTO saniso_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","tatastē kiyaddagdhamatsyaṁ madhu ca daduḥ ");
INSERT INTO saniso_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","sa tadādāya tēṣāṁ sākṣād bubhujē ");
INSERT INTO saniso_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","kathayāmāsa ca mūsāvyavasthāyāṁ bhaviṣyadvādināṁ granthēṣu gītapustakē ca mayi yāni sarvvāṇi vacanāni likhitāni tadanurūpāṇi ghaṭiṣyantē yuṣmābhiḥ sārddhaṁ sthitvāhaṁ yadētadvākyam avadaṁ tadidānīṁ pratyakṣamabhūt| ");
INSERT INTO saniso_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","atha tēbhyaḥ śāstrabōdhādhikāraṁ datvāvadat, ");
INSERT INTO saniso_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","khrīṣṭēnētthaṁ mr̥tiyātanā bhōktavyā tr̥tīyadinē ca śmaśānādutthātavyañcēti lipirasti; ");
INSERT INTO saniso_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","tannāmnā yirūśālamamārabhya sarvvadēśē manaḥparāvarttanasya pāpamōcanasya ca susaṁvādaḥ pracārayitavyaḥ, ");
INSERT INTO saniso_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ēṣu sarvvēṣu yūyaṁ sākṣiṇaḥ| ");
INSERT INTO saniso_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","aparañca paśyata pitrā yat pratijñātaṁ tat prēṣayiṣyāmi, ataēva yāvatkālaṁ yūyaṁ svargīyāṁ śaktiṁ na prāpsyatha tāvatkālaṁ yirūśālamnagarē tiṣṭhata| ");
INSERT INTO saniso_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","atha sa tān baithanīyāparyyantaṁ nītvā hastāvuttōlya āśiṣa vaktumārēbhē ");
INSERT INTO saniso_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","āśiṣaṁ vadannēva ca tēbhyaḥ pr̥thag bhūtvā svargāya nītō'bhavat| ");
INSERT INTO saniso_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","tadā tē taṁ bhajamānā mahānandēna yirūśālamaṁ pratyājagmuḥ| ");
INSERT INTO saniso_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","tatō nirantaraṁ mandirē tiṣṭhanta īśvarasya praśaṁsāṁ dhanyavādañca karttam ārēbhirē| iti||");
INSERT INTO saniso_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ādau vāda āsīt sa ca vāda īśvarēṇa sārdhamāsīt sa vādaḥ svayamīśvara ēva| ");
INSERT INTO saniso_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","sa ādāvīśvarēṇa sahāsīt| ");
INSERT INTO saniso_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","tēna sarvvaṁ vastu sasr̥jē sarvvēṣu sr̥ṣṭavastuṣu kimapi vastu tēnāsr̥ṣṭaṁ nāsti| ");
INSERT INTO saniso_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","sa jīvanasyākāraḥ, tacca jīvanaṁ manuṣyāṇāṁ jyōtiḥ ");
INSERT INTO saniso_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","tajjyōtirandhakārē pracakāśē kintvandhakārastanna jagrāha| ");
INSERT INTO saniso_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","yōhan nāmaka ēkō manuja īśvarēṇa prēṣayāñcakrē| ");
INSERT INTO saniso_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","tadvārā yathā sarvvē viśvasanti tadarthaṁ sa tajjyōtiṣi pramāṇaṁ dātuṁ sākṣisvarūpō bhūtvāgamat, ");
INSERT INTO saniso_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","sa svayaṁ tajjyōti rna kintu tajjyōtiṣi pramāṇaṁ dātumāgamat| ");
INSERT INTO saniso_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","jagatyāgatya yaḥ sarvvamanujēbhyō dīptiṁ dadāti tadēva satyajyōtiḥ| ");
INSERT INTO saniso_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","sa yajjagadasr̥jat tanmadya ēva sa āsīt kintu jagatō lōkāstaṁ nājānan| ");
INSERT INTO saniso_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","nijādhikāraṁ sa āgacchat kintu prajāstaṁ nāgr̥hlan| ");
INSERT INTO saniso_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","tathāpi yē yē tamagr̥hlan arthāt tasya nāmni vyaśvasan tēbhya īśvarasya putrā bhavitum adhikāram adadāt| ");
INSERT INTO saniso_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","tēṣāṁ janiḥ śōṇitānna śārīrikābhilāṣānna mānavānāmicchātō na kintvīśvarādabhavat| ");
INSERT INTO saniso_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","sa vādō manuṣyarūpēṇāvatīryya satyatānugrahābhyāṁ paripūrṇaḥ san sārdham asmābhi rnyavasat tataḥ pituradvitīyaputrasya yōgyō yō mahimā taṁ mahimānaṁ tasyāpaśyāma| ");
INSERT INTO saniso_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","tatō yōhanapi pracāryya sākṣyamidaṁ dattavān yō mama paścād āgamiṣyati sa mattō gurutaraḥ; yatō matpūrvvaṁ sa vidyamāna āsīt; yadartham ahaṁ sākṣyamidam adāṁ sa ēṣaḥ| ");
INSERT INTO saniso_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","aparañca tasya pūrṇatāyā vayaṁ sarvvē kramaśaḥ kramaśōnugrahaṁ prāptāḥ| ");
INSERT INTO saniso_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","mūsādvārā vyavasthā dattā kintvanugrahaḥ satyatvañca yīśukhrīṣṭadvārā samupātiṣṭhatāṁ| ");
INSERT INTO saniso_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","kōpi manuja īśvaraṁ kadāpi nāpaśyat kintu pituḥ krōḍasthō'dvitīyaḥ putrastaṁ prakāśayat| ");
INSERT INTO saniso_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","tvaṁ kaḥ? iti vākyaṁ prēṣṭuṁ yadā yihūdīyalōkā yājakān lēvilōkāṁśca yirūśālamō yōhanaḥ samīpē prēṣayāmāsuḥ, ");
INSERT INTO saniso_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","tadā sa svīkr̥tavān nāpahnūtavān nāham abhiṣikta ityaṅgīkr̥tavān| ");
INSERT INTO saniso_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","tadā tē'pr̥cchan tarhi kō bhavān? kiṁ ēliyaḥ? sōvadat na; tatastē'pr̥cchan tarhi bhavān sa bhaviṣyadvādī? sōvadat nāhaṁ saḥ| ");
INSERT INTO saniso_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","tadā tē'pr̥cchan tarhi bhavān kaḥ? vayaṁ gatvā prērakān tvayi kiṁ vakṣyāmaḥ? svasmin kiṁ vadasi? ");
INSERT INTO saniso_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","tadā sōvadat| paramēśasya panthānaṁ pariṣkuruta sarvvataḥ| itīdaṁ prāntarē vākyaṁ vadataḥ kasyacidravaḥ| kathāmimāṁ yasmin yiśayiyō bhaviṣyadvādī likhitavān sōham| ");
INSERT INTO saniso_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","yē prēṣitāstē phirūśilōkāḥ| ");
INSERT INTO saniso_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","tadā tē'pr̥cchan yadi nābhiṣiktōsi ēliyōsi na sa bhaviṣyadvādyapi nāsi ca, tarhi lōkān majjayasi kutaḥ? ");
INSERT INTO saniso_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","tatō yōhan pratyavōcat, tōyē'haṁ majjayāmīti satyaṁ kintu yaṁ yūyaṁ na jānītha tādr̥śa ēkō janō yuṣmākaṁ madhya upatiṣṭhati| ");
INSERT INTO saniso_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","sa matpaścād āgatōpi matpūrvvaṁ varttamāna āsīt tasya pādukābandhanaṁ mōcayitumapi nāhaṁ yōgyōsmi| ");
INSERT INTO saniso_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","yarddananadyāḥ pārasthabaithabārāyāṁ yasminsthānē yōhanamajjayat tasmina sthānē sarvvamētad aghaṭata| ");
INSERT INTO saniso_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","parē'hani yōhan svanikaṭamāgacchantaṁ yiśuṁ vilōkya prāvōcat jagataḥ pāpamōcakam īśvarasya mēṣaśāvakaṁ paśyata| ");
INSERT INTO saniso_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","yō mama paścādāgamiṣyati sa mattō gurutaraḥ, yatō hētōrmatpūrvvaṁ sō'varttata yasminnahaṁ kathāmimāṁ kathitavān sa ēvāyaṁ| ");
INSERT INTO saniso_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","aparaṁ nāhamēnaṁ pratyabhijñātavān kintu isrāyēllōkā ēnaṁ yathā paricinvanti tadabhiprāyēṇāhaṁ jalē majjayitumāgaccham| ");
INSERT INTO saniso_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","punaśca yōhanaparamēkaṁ pramāṇaṁ datvā kathitavān vihāyasaḥ kapōtavad avatarantamātmānam asyōparyyavatiṣṭhantaṁ ca dr̥ṣṭavānaham| ");
INSERT INTO saniso_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","nāhamēnaṁ pratyabhijñātavān iti satyaṁ kintu yō jalē majjayituṁ māṁ prairayat sa ēvēmāṁ kathāmakathayat yasyōparyyātmānam avatarantam avatiṣṭhantañca drakṣayasi saēva pavitrē ātmani majjayiṣyati| ");
INSERT INTO saniso_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","avastannirīkṣyāyam īśvarasya tanaya iti pramāṇaṁ dadāmi| ");
INSERT INTO saniso_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","parē'hani yōhan dvābhyāṁ śiṣyābhyāṁ sārddhēṁ tiṣṭhan ");
INSERT INTO saniso_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","yiśuṁ gacchantaṁ vilōkya gaditavān, īśvarasya mēṣaśāvakaṁ paśyataṁ| ");
INSERT INTO saniso_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","imāṁ kathāṁ śrutvā dvau śiṣyau yīśōḥ paścād īyatuḥ| ");
INSERT INTO saniso_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","tatō yīśuḥ parāvr̥tya tau paścād āgacchantau dr̥ṣṭvā pr̥ṣṭavān yuvāṁ kiṁ gavēśayathaḥ? tāvapr̥cchatāṁ hē rabbi arthāt hē gurō bhavān kutra tiṣṭhati? ");
INSERT INTO saniso_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","tataḥ sōvādit ētya paśyataṁ| tatō divasasya tr̥tīyapraharasya gatatvāt tau taddinaṁ tasya saṅgē'sthātāṁ| ");
INSERT INTO saniso_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","yau dvau yōhanō vākyaṁ śrutvā yiśōḥ paścād āgamatāṁ tayōḥ śimōnpitarasya bhrātā āndriyaḥ ");
INSERT INTO saniso_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","sa itvā prathamaṁ nijasōdaraṁ śimōnaṁ sākṣātprāpya kathitavān vayaṁ khrīṣṭam arthāt abhiṣiktapuruṣaṁ sākṣātkr̥tavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","paścāt sa taṁ yiśōḥ samīpam ānayat| tadā yīśustaṁ dr̥ṣṭvāvadat tvaṁ yūnasaḥ putraḥ śimōn kintu tvannāmadhēyaṁ kaiphāḥ vā pitaraḥ arthāt prastarō bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","parē'hani yīśau gālīlaṁ gantuṁ niścitacētasi sati philipanāmānaṁ janaṁ sākṣātprāpyāvōcat mama paścād āgaccha| ");
INSERT INTO saniso_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","baitsaidānāmni yasmin grāmē pitarāndriyayōrvāsa āsīt tasmin grāmē tasya philipasya vasatirāsīt| ");
INSERT INTO saniso_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","paścāt philipō nithanēlaṁ sākṣātprāpyāvadat mūsā vyavasthā granthē bhaviṣyadvādināṁ granthēṣu ca yasyākhyānaṁ likhitamāstē taṁ yūṣaphaḥ putraṁ nāsaratīyaṁ yīśuṁ sākṣād akārṣma vayaṁ| ");
INSERT INTO saniso_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","tadā nithanēl kathitavān nāsarannagarāta kiṁ kaściduttama utpantuṁ śaknōti? tataḥ philipō 'vōcat ētya paśya| ");
INSERT INTO saniso_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","aparañca yīśuḥ svasya samīpaṁ tam āgacchantaṁ dr̥ṣṭvā vyāhr̥tavān, paśyāyaṁ niṣkapaṭaḥ satya isrāyēllōkaḥ| ");
INSERT INTO saniso_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","tataḥ sōvadad, bhavān māṁ kathaṁ pratyabhijānāti? yīśuravādīt philipasya āhvānāt pūrvvaṁ yadā tvamuḍumbarasya tarōrmūlē'sthāstadā tvāmadarśam| ");
INSERT INTO saniso_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","nithanēl acakathat, hē gurō bhavān nitāntam īśvarasya putrōsi, bhavān isrāyēlvaṁśasya rājā| ");
INSERT INTO saniso_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","tatō yīśu rvyāharat, tvāmuḍumbarasya pādapasya mūlē dr̥ṣṭavānāhaṁ mamaitasmādvākyāt kiṁ tvaṁ vyaśvasīḥ? ētasmādapyāścaryyāṇi kāryyāṇi drakṣyasi| ");
INSERT INTO saniso_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","anyaccāvādīd yuṣmānahaṁ yathārthaṁ vadāmi, itaḥ paraṁ mōcitē mēghadvārē tasmānmanujasūnunā īśvarasya dūtagaṇam avarōhantamārōhantañca drakṣyatha| ");
INSERT INTO saniso_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","anantaraṁ trutīyadivasē gālīl pradēśiyē kānnānāmni nagarē vivāha āsīt tatra ca yīśōrmātā tiṣṭhat| ");
INSERT INTO saniso_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","tasmai vivāhāya yīśustasya śiṣyāśca nimantritā āsan| ");
INSERT INTO saniso_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","tadanantaraṁ drākṣārasasya nyūnatvād yīśōrmātā tamavadat ētēṣāṁ drākṣārasō nāsti| ");
INSERT INTO saniso_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","tadā sa tāmavōcat hē nāri mayā saha tava kiṁ kāryyaṁ? mama samaya idānīṁ nōpatiṣṭhati| ");
INSERT INTO saniso_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","tatastasya mātā dāsānavōcad ayaṁ yad vadati tadēva kuruta| ");
INSERT INTO saniso_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","tasmin sthānē yihūdīyānāṁ śucitvakaraṇavyavahārānusārēṇāḍhakaikajaladharāṇi pāṣāṇamayāni ṣaḍvr̥hatpātrāṇiāsan| ");
INSERT INTO saniso_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","tadā yīśustān sarvvakalaśān jalaiḥ pūrayituṁ tānājñāpayat, tatastē sarvvān kumbhānākarṇaṁ jalaiḥ paryyapūrayan| ");
INSERT INTO saniso_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","atha tēbhyaḥ kiñciduttāryya bhōjyādhipātēḥsamīpaṁ nētuṁ sa tānādiśat, tē tadanayan| ");
INSERT INTO saniso_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","aparañca tajjalaṁ kathaṁ drākṣārasō'bhavat tajjalavāhakādāsā jñātuṁ śaktāḥ kintu tadbhōjyādhipō jñātuṁ nāśaknōt tadavalihya varaṁ saṁmbōdyāvadata, ");
INSERT INTO saniso_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","lōkāḥ prathamaṁ uttamadrākṣārasaṁ dadati taṣu yathēṣṭaṁ pitavatsu tasmā kiñcidanuttamañca dadati kintu tvamidānīṁ yāvat uttamadrākṣārasaṁ sthāpayasi| ");
INSERT INTO saniso_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","itthaṁ yīśurgālīlapradēśē āścaryyakārmma prārambha nijamahimānaṁ prākāśayat tataḥ śiṣyāstasmin vyaśvasan| ");
INSERT INTO saniso_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","tataḥ param sa nijamātrubhrātrusśiṣyaiḥ sārddhṁ kapharnāhūmam āgamat kintu tatra bahūdināni ātiṣṭhat| ");
INSERT INTO saniso_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","tadanantaraṁ yihūdiyānāṁ nistārōtsavē nikaṭamāgatē yīśu ryirūśālam nagaram āgacchat| ");
INSERT INTO saniso_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","tatō mandirasya madhyē gōmēṣapārāvatavikrayiṇō vāṇijakṣcōpaviṣṭān vilōkya ");
INSERT INTO saniso_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","rajjubhiḥ kaśāṁ nirmmāya sarvvagōmēṣādibhiḥ sārddhaṁ tān mandirād dūrīkr̥tavān| ");
INSERT INTO saniso_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","vaṇijāṁ mudrādi vikīryya āsanāni nyūbjīkr̥tya pārāvatavikrayibhyō'kathayad asmāt sthānāt sarvāṇyētāni nayata, mama pitugr̥haṁ vāṇijyagr̥haṁ mā kārṣṭa| ");
INSERT INTO saniso_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","tasmāt tanmandirārtha udyōgō yastu sa grasatīva mām| imāṁ śāstrīyalipiṁ śiṣyāḥsamasmaran| ");
INSERT INTO saniso_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","tataḥ param yihūdīyalōkā yīṣimavadan tavamidr̥śakarmmakaraṇāt kiṁ cihnamasmān darśayasi? ");
INSERT INTO saniso_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","tatō yīśustānavōcad yuṣmābhirē tasmin mandirē nāśitē dinatrayamadhyē'haṁ tad utthāpayiṣyāmi| ");
INSERT INTO saniso_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","tadā yihūdiyā vyāhārṣuḥ, ētasya mandirasa nirmmāṇēna ṣaṭcatvāriṁśad vatsarā gatāḥ, tvaṁ kiṁ dinatrayamadhyē tad utthāpayiṣyasi? ");
INSERT INTO saniso_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","kintu sa nijadēharūpamandirē kathāmimāṁ kathitavān| ");
INSERT INTO saniso_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","sa yadētādr̥śaṁ gaditavān tacchiṣyāḥ śmaśānāt tadīyōtthānē sati smr̥tvā dharmmagranthē yīśunōktakathāyāṁ ca vyaśvasiṣuḥ| ");
INSERT INTO saniso_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","anantaraṁ nistārōtsavasya bhōjyasamayē yirūśālam nagarē tatkrutāścaryyakarmmāṇi vilōkya bahubhistasya nāmani viśvasitaṁ| ");
INSERT INTO saniso_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","kintu sa tēṣāṁ karēṣu svaṁ na samarpayat, yataḥ sa sarvvānavait| ");
INSERT INTO saniso_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","sa mānavēṣu kasyacit pramāṇaṁ nāpēkṣata yatō manujānāṁ madhyē yadyadasti tattat sōjānāt| ");
INSERT INTO saniso_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","nikadimanāmā yihūdīyānām adhipatiḥ phirūśī kṣaṇadāyāṁ ");
INSERT INTO saniso_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","yīśaurabhyarṇam āvrajya vyāhārṣīt, hē gurō bhavān īśvarād āgat ēka upadēṣṭā, ētad asmābhirjñāyatē; yatō bhavatā yānyāścaryyakarmmāṇi kriyantē paramēśvarasya sāhāyyaṁ vinā kēnāpi tattatkarmmāṇi karttuṁ na śakyantē| ");
INSERT INTO saniso_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","tadā yīśuruttaraṁ dattavān tavāhaṁ yathārthataraṁ vyāharāmi punarjanmani na sati kōpi mānava īśvarasya rājyaṁ draṣṭuṁ na śaknōti| ");
INSERT INTO saniso_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","tatō nikadīmaḥ pratyavōcat manujō vr̥ddhō bhūtvā kathaṁ janiṣyatē? sa kiṁ puna rmātr̥rjaṭharaṁ praviśya janituṁ śaknōti? ");
INSERT INTO saniso_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","yīśuravādīd yathārthataram ahaṁ kathayāmi manujē tōyātmabhyāṁ puna rna jātē sa īśvarasya rājyaṁ pravēṣṭuṁ na śaknōti| ");
INSERT INTO saniso_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","māṁsād yat jāyatē tan māṁsamēva tathātmanō yō jāyatē sa ātmaiva| ");
INSERT INTO saniso_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","yuṣmābhiḥ puna rjanitavyaṁ mamaitasyāṁ kathāyām āścaryaṁ mā maṁsthāḥ| ");
INSERT INTO saniso_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","sadāgatiryāṁ diśamicchati tasyāmēva diśi vāti, tvaṁ tasya svanaṁ śuṇōṣi kintu sa kuta āyāti kutra yāti vā kimapi na jānāsi tadvād ātmanaḥ sakāśāt sarvvēṣāṁ manujānāṁ janma bhavati| ");
INSERT INTO saniso_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","tadā nikadīmaḥ pr̥ṣṭavān ētat kathaṁ bhavituṁ śaknōti? ");
INSERT INTO saniso_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","yīśuḥ pratyaktavān tvamisrāyēlō gururbhūtvāpi kimētāṁ kathāṁ na vētsi? ");
INSERT INTO saniso_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","tubhyaṁ yathārthaṁ kathayāmi, vayaṁ yad vidmastad vacmaḥ yaṁcca paśyāmastasyaiva sākṣyaṁ dadmaḥ kintu yuṣmābhirasmākaṁ sākṣitvaṁ na gr̥hyatē| ");
INSERT INTO saniso_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ētasya saṁsārasya kathāyāṁ kathitāyāṁ yadi yūyaṁ na viśvasitha tarhi svargīyāyāṁ kathāyāṁ kathaṁ viśvasiṣyatha? ");
INSERT INTO saniso_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","yaḥ svargē'sti yaṁ ca svargād avārōhat taṁ mānavatanayaṁ vinā kōpi svargaṁ nārōhat| ");
INSERT INTO saniso_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","aparañca mūsā yathā prāntarē sarpaṁ prōtthāpitavān manuṣyaputrō'pi tathaivōtthāpitavyaḥ; ");
INSERT INTO saniso_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","tasmād yaḥ kaścit tasmin viśvasiṣyati sō'vināśyaḥ san anantāyuḥ prāpsyati| ");
INSERT INTO saniso_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","īśvara itthaṁ jagadadayata yat svamadvitīyaṁ tanayaṁ prādadāt tatō yaḥ kaścit tasmin viśvasiṣyati sō'vināśyaḥ san anantāyuḥ prāpsyati| ");
INSERT INTO saniso_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","īśvarō jagatō lōkān daṇḍayituṁ svaputraṁ na prēṣya tān paritrātuṁ prēṣitavān| ");
INSERT INTO saniso_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ataēva yaḥ kaścit tasmin viśvasiti sa daṇḍārhō na bhavati kintu yaḥ kaścit tasmin na viśvasiti sa idānīmēva daṇḍārhō bhavati,yataḥ sa īśvarasyādvitīyaputrasya nāmani pratyayaṁ na karōti| ");
INSERT INTO saniso_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","jagatō madhyē jyōtiḥ prākāśata kintu manuṣyāṇāṁ karmmaṇāṁ dr̥ṣṭatvāt tē jyōtiṣōpi timirē prīyantē ētadēva daṇḍasya kāraṇāṁ bhavati| ");
INSERT INTO saniso_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","yaḥ kukarmma karōti tasyācārasya dr̥ṣṭatvāt sa jyōtirr̥̄tīyitvā tannikaṭaṁ nāyāti; ");
INSERT INTO saniso_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","kintu yaḥ satkarmma karōti tasya sarvvāṇi karmmāṇīśvarēṇa kr̥tānīti sathā prakāśatē tadabhiprāyēṇa sa jyōtiṣaḥ sannidhim āyāti| ");
INSERT INTO saniso_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","tataḥ param yīśuḥ śiṣyaiḥ sārddhaṁ yihūdīyadēśaṁ gatvā tatra sthitvā majjayitum ārabhata| ");
INSERT INTO saniso_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","tadā śālam nagarasya samīpasthāyini ainan grāmē bahutaratōyasthitēstatra yōhan amajjayat tathā ca lōkā āgatya tēna majjitā abhavan| ");
INSERT INTO saniso_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","tadā yōhan kārāyāṁ na baddhaḥ| ");
INSERT INTO saniso_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","aparañca śācakarmmaṇi yōhānaḥ śiṣyaiḥ saha yihūdīyalōkānāṁ vivādē jātē, tē yōhanaḥ saṁnnidhiṁ gatvākathayan, ");
INSERT INTO saniso_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","hē gurō yarddananadyāḥ pārē bhavatā sārddhaṁ ya āsīt yasmiṁśca bhavān sākṣyaṁ pradadāt paśyatu sōpi majjayati sarvvē tasya samīpaṁ yānti ca| ");
INSERT INTO saniso_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","tadā yōhan pratyavōcad īśvarēṇa na dattē kōpi manujaḥ kimapi prāptuṁ na śaknōti| ");
INSERT INTO saniso_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","ahaṁ abhiṣiktō na bhavāmi kintu tadagrē prēṣitōsmi yāmimāṁ kathāṁ kathitavānāhaṁ tatra yūyaṁ sarvvē sākṣiṇaḥ stha| ");
INSERT INTO saniso_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","yō janaḥ kanyāṁ labhatē sa ēva varaḥ kintu varasya sannidhau daṇḍāyamānaṁ tasya yanmitraṁ tēna varasya śabdē śrutē'tīvāhlādyatē mamāpi tadvad ānandasiddhirjātā| ");
INSERT INTO saniso_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","tēna kramaśō varddhitavyaṁ kintu mayā hsitavyaṁ| ");
INSERT INTO saniso_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ya ūrdhvādāgacchat sa sarvvēṣāṁ mukhyō yaśca saṁsārād udapadyata sa sāṁsārikaḥ saṁsārīyāṁ kathāñca kathayati yastu svargādāgacchat sa sarvvēṣāṁ mukhyaḥ| ");
INSERT INTO saniso_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","sa yadapaśyadaśr̥ṇōcca tasminnēva sākṣyaṁ dadāti tathāpi prāyaśaḥ kaścit tasya sākṣyaṁ na gr̥hlāti; ");
INSERT INTO saniso_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","kintu yō gr̥hlāti sa īśvarasya satyavāditvaṁ mudrāṅgitaṁ karōti| ");
INSERT INTO saniso_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","īśvarēṇa yaḥ prēritaḥ saēva īśvarīyakathāṁ kathayati yata īśvara ātmānaṁ tasmai aparimitam adadāt| ");
INSERT INTO saniso_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","pitā putrē snēhaṁ kr̥tvā tasya hastē sarvvāṇi samarpitavān| ");
INSERT INTO saniso_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","yaḥ kaścit putrē viśvasiti sa ēvānantam paramāyuḥ prāpnōti kintu yaḥ kaścit putrē na viśvasiti sa paramāyuṣō darśanaṁ na prāpnōti kintvīśvarasya kōpabhājanaṁ bhūtvā tiṣṭhati| ");
INSERT INTO saniso_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","yīśuḥ svayaṁ nāmajjayat kēvalaṁ tasya śiṣyā amajjayat kintu yōhanō'dhikaśiṣyān sa karōti majjayati ca, ");
INSERT INTO saniso_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","phirūśina imāṁ vārttāmaśr̥ṇvan iti prabhuravagatya ");
INSERT INTO saniso_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","yihūdīyadēśaṁ vihāya puna rgālīlam āgat| ");
INSERT INTO saniso_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","tataḥ śōmirōṇapradēśasya madyēna tēna gantavyē sati ");
INSERT INTO saniso_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","yākūb nijaputrāya yūṣaphē yāṁ bhūmim adadāt tatsamīpasthāyi śōmirōṇapradēśasya sukhār nāmnā vikhyātasya nagarasya sannidhāvupāsthāt| ");
INSERT INTO saniso_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","tatra yākūbaḥ prahirāsīt; tadā dvitīyayāmavēlāyāṁ jātāyāṁ sa mārgē śramāpannastasya prahēḥ pārśvē upāviśat| ");
INSERT INTO saniso_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ētarhi kācit śōmirōṇīyā yōṣit tōyōttōlanārtham tatrāgamat ");
INSERT INTO saniso_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","tadā śiṣyāḥ khādyadravyāṇi krētuṁ nagaram agacchan| ");
INSERT INTO saniso_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","yīśuḥ śōmirōṇīyāṁ tāṁ yōṣitam vyāhārṣīt mahyaṁ kiñcit pānīyaṁ pātuṁ dēhi| kintu śōmirōṇīyaiḥ sākaṁ yihūdīyalōkā na vyavāharan tasmāddhētōḥ sākathayat śōmirōṇīyā yōṣitadahaṁ tvaṁ yihūdīyōsi kathaṁ mattaḥ pānīyaṁ pātum icchasi? ");
INSERT INTO saniso_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","tatō yīśuravadad īśvarasya yaddānaṁ tatkīdr̥k pānīyaṁ pātuṁ mahyaṁ dēhi ya itthaṁ tvāṁ yācatē sa vā ka iti cēdajñāsyathāstarhi tamayāciṣyathāḥ sa ca tubhyamamr̥taṁ tōyamadāsyat| ");
INSERT INTO saniso_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","tadā sā sīmantinī bhāṣitavati, hē mahēccha prahirgambhīrō bhavatō nīrōttōlanapātraṁ nāstī ca tasmāt tadamr̥taṁ kīlālaṁ kutaḥ prāpsyasi? ");
INSERT INTO saniso_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","yōsmabhyam imamandhūṁ dadau, yasya ca parijanā gōmēṣādayaśca sarvvē'sya prahēḥ pānīyaṁ papurētādr̥śō yōsmākaṁ pūrvvapuruṣō yākūb tasmādapi bhavān mahān kiṁ? ");
INSERT INTO saniso_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","tatō yīśurakathayad idaṁ pānīyaṁ saḥ pivati sa punastr̥ṣārttō bhaviṣyati, ");
INSERT INTO saniso_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","kintu mayā dattaṁ pānīyaṁ yaḥ pivati sa punaḥ kadāpi tr̥ṣārttō na bhaviṣyati| mayā dattam idaṁ tōyaṁ tasyāntaḥ prasravaṇarūpaṁ bhūtvā anantāyuryāvat srōṣyati| ");
INSERT INTO saniso_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","tadā sā vanitākathayat hē mahēccha tarhi mama punaḥ pīpāsā yathā na jāyatē tōyōttōlanāya yathātrāgamanaṁ na bhavati ca tadarthaṁ mahyaṁ tattōyaṁ dēhī| ");
INSERT INTO saniso_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","tatō yīśūravadadyāhi tava patimāhūya sthānē'trāgaccha| ");
INSERT INTO saniso_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","sā vāmāvadat mama patirnāsti| yīśuravadat mama patirnāstīti vākyaṁ bhadramavōcaḥ| ");
INSERT INTO saniso_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","yatastava pañca patayōbhavan adhunā tu tvayā sārddhaṁ yastiṣṭhati sa tava bharttā na vākyamidaṁ satyamavādiḥ| ");
INSERT INTO saniso_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","tadā sā mahilā gaditavati hē mahēccha bhavān ēkō bhaviṣyadvādīti buddhaṁ mayā| ");
INSERT INTO saniso_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","asmākaṁ pitr̥lōkā ētasmin śilōccayē'bhajanta, kintu bhavadbhirucyatē yirūśālam nagarē bhajanayōgyaṁ sthānamāstē| ");
INSERT INTO saniso_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","yīśuravōcat hē yōṣit mama vākyē viśvasihi yadā yūyaṁ kēvalaśailē'smin vā yirūśālam nagarē piturbhajanaṁ na kariṣyadhvē kāla ētādr̥śa āyāti| ");
INSERT INTO saniso_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","yūyaṁ yaṁ bhajadhvē taṁ na jānītha, kintu vayaṁ yaṁ bhajāmahē taṁ jānīmahē, yatō yihūdīyalōkānāṁ madhyāt paritrāṇaṁ jāyatē| ");
INSERT INTO saniso_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","kintu yadā satyabhaktā ātmanā satyarūpēṇa ca piturbhajanaṁ kariṣyantē samaya ētādr̥śa āyāti, varam idānīmapi vidyatē ; yata ētādr̥śō bhatkān pitā cēṣṭatē| ");
INSERT INTO saniso_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","īśvara ātmā; tatastasya yē bhaktāstaiḥ sa ātmanā satyarūpēṇa ca bhajanīyaḥ| ");
INSERT INTO saniso_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","tadā sā mahilāvādīt khrīṣṭanāmnā vikhyātō'bhiṣiktaḥ puruṣa āgamiṣyatīti jānāmi sa ca sarvvāḥ kathā asmān jñāpayiṣyati| ");
INSERT INTO saniso_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","tatō yīśuravadat tvayā sārddhaṁ kathanaṁ karōmi yō'ham ahamēva sa puruṣaḥ| ");
INSERT INTO saniso_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ētasmin samayē śiṣyā āgatya tathā striyā sārddhaṁ tasya kathōpakathanē mahāścaryyam amanyanta tathāpi bhavān kimicchati? yadvā kimartham ētayā sārddhaṁ kathāṁ kathayati? iti kōpi nāpr̥cchat| ");
INSERT INTO saniso_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","tataḥ paraṁ sā nārī kalaśaṁ sthāpayitvā nagaramadhyaṁ gatvā lōkēbhyōkathāyad ");
INSERT INTO saniso_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","ahaṁ yadyat karmmākaravaṁ tatsarvvaṁ mahyamakathayad ētādr̥śaṁ mānavamēkam āgatya paśyata ru kim abhiṣiktō na bhavati ? ");
INSERT INTO saniso_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","tatastē nagarād bahirāgatya tātasya samīpam āyan| ");
INSERT INTO saniso_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ētarhi śiṣyāḥ sādhayitvā taṁ vyāhārṣuḥ hē gurō bhavān kiñcid bhūktāṁ| ");
INSERT INTO saniso_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","tataḥ sōvadad yuṣmābhiryanna jñāyatē tādr̥śaṁ bhakṣyaṁ mamāstē| ");
INSERT INTO saniso_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","tadā śiṣyāḥ parasparaṁ praṣṭum ārambhanta, kimasmai kōpi kimapi bhakṣyamānīya dattavān? ");
INSERT INTO saniso_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","yīśuravōcat matprērakasyābhimatānurūpakaraṇaṁ tasyaiva karmmasiddhikāraṇañca mama bhakṣyaṁ| ");
INSERT INTO saniso_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","māsacatuṣṭayē jātē śasyakarttanasamayō bhaviṣyatīti vākyaṁ yuṣmābhiḥ kiṁ nōdyatē? kintvahaṁ vadāmi, śira uttōlya kṣētrāṇi prati nirīkṣya paśyata, idānīṁ karttanayōgyāni śuklavarṇānyabhavan| ");
INSERT INTO saniso_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","yaśchinatti sa vētanaṁ labhatē anantāyuḥsvarūpaṁ śasyaṁ sa gr̥hlāti ca, tēnaiva vaptā chēttā ca yugapad ānandataḥ| ");
INSERT INTO saniso_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","itthaṁ sati vapatyēkaśchinatyanya iti vacanaṁ siddhyati| ");
INSERT INTO saniso_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","yatra yūyaṁ na paryyaśrāmyata tādr̥śaṁ śasyaṁ chēttuṁ yuṣmān prairayam anyē janāḥparyyaśrāmyan yūyaṁ tēṣāṁ śragasya phalam alabhadhvam| ");
INSERT INTO saniso_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","yasmin kālē yadyat karmmākārṣaṁ tatsarvvaṁ sa mahyam akathayat tasyā vanitāyā idaṁ sākṣyavākyaṁ śrutvā tannagaranivāsinō bahavaḥ śōmirōṇīyalōkā vyaśvasan| ");
INSERT INTO saniso_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","tathā ca tasyāntikē samupasthāya svēṣāṁ sannidhau katicid dināni sthātuṁ tasmin vinayam akurvvāna tasmāt sa dinadvayaṁ tatsthānē nyavaṣṭat ");
INSERT INTO saniso_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","tatastasyōpadēśēna bahavō'parē viśvasya ");
INSERT INTO saniso_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","tāṁ yōṣāmavadan kēvalaṁ tava vākyēna pratīma iti na, kintu sa jagatō'bhiṣiktastrātēti tasya kathāṁ śrutvā vayaṁ svayamēvājñāsamahi| ");
INSERT INTO saniso_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","svadēśē bhaviṣyadvaktuḥ satkārō nāstīti yadyapi yīśuḥ pramāṇaṁ datvākathayat ");
INSERT INTO saniso_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","tathāpi divasadvayāt paraṁ sa tasmāt sthānād gālīlaṁ gatavān| ");
INSERT INTO saniso_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","anantaraṁ yē gālīlī liyalōkā utsavē gatā utsavasamayē yirūśalam nagarē tasya sarvvāḥ kriyā apaśyan tē gālīlam āgataṁ tam āgr̥hlan| ");
INSERT INTO saniso_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","tataḥ param yīśu ryasmin kānnānagarē jalaṁ drākṣārasam ākarōt tat sthānaṁ punaragāt| tasminnēva samayē kasyacid rājasabhāstārasya putraḥ kapharnāhūmapurī rōgagrasta āsīt| ");
INSERT INTO saniso_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","sa yēhūdīyadēśād yīśō rgālīlāgamanavārttāṁ niśamya tasya samīpaṁ gatvā prārthya vyāhr̥tavān mama putrasya prāyēṇa kāla āsannaḥ bhavān āgatya taṁ svasthaṁ karōtu| ");
INSERT INTO saniso_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","tadā yīśurakathayad āścaryyaṁ karmma citraṁ cihnaṁ ca na dr̥ṣṭā yūyaṁ na pratyēṣyatha| ");
INSERT INTO saniso_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","tataḥ sa sabhāsadavadat hē mahēccha mama putrē na mr̥tē bhavānāgacchatu| ");
INSERT INTO saniso_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","yīśustamavadad gaccha tava putrō'jīvīt tadā yīśunōktavākyē sa viśvasya gatavān| ");
INSERT INTO saniso_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","gamanakālē mārgamadhyē dāsāstaṁ sākṣātprāpyāvadan bhavataḥ putrō'jīvīt| ");
INSERT INTO saniso_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","tataḥ kaṁ kālamārabhya rōgapratīkārārambhō jātā iti pr̥ṣṭē tairuktaṁ hyaḥ sārddhadaṇḍadvayādhikadvitīyayāmē tasya jvaratyāgō'bhavat| ");
INSERT INTO saniso_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","tadā yīśustasmin kṣaṇē prōktavān tava putrō'jīvīt pitā tadbuddhvā saparivārō vyaśvasīt| ");
INSERT INTO saniso_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","yihūdīyadēśād āgatya gālīli yīśurētad dvitīyam āścaryyakarmmākarōt| ");
INSERT INTO saniso_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","tataḥ paraṁ yihūdīyānām utsava upasthitē yīśu ryirūśālamaṁ gatavān| ");
INSERT INTO saniso_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","tasminnagarē mēṣanāmnō dvārasya samīpē ibrīyabhāṣayā baithēsdā nāmnā piṣkariṇī pañcaghaṭṭayuktāsīt| ");
INSERT INTO saniso_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","tasyāstēṣu ghaṭṭēṣu kilālakampanam apēkṣya andhakhañcaśuṣkāṅgādayō bahavō rōgiṇaḥ patantastiṣṭhanti sma| ");
INSERT INTO saniso_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","yatō viśēṣakālē tasya sarasō vāri svargīyadūta ētyākampayat tatkīlālakampanāt paraṁ yaḥ kaścid rōgī prathamaṁ pānīyamavārōhat sa ēva tatkṣaṇād rōgamuktō'bhavat| ");
INSERT INTO saniso_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","tadāṣṭātriṁśadvarṣāṇi yāvad rōgagrasta ēkajanastasmin sthānē sthitavān| ");
INSERT INTO saniso_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","yīśustaṁ śayitaṁ dr̥ṣṭvā bahukālikarōgīti jñātvā vyāhr̥tavān tvaṁ kiṁ svasthō bubhūṣasi? ");
INSERT INTO saniso_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","tatō rōgī kathitavān hē mahēccha yadā kīlālaṁ kampatē tadā māṁ puṣkariṇīm avarōhayituṁ mama kōpi nāsti, tasmān mama gamanakālē kaścidanyō'grō gatvā avarōhati| ");
INSERT INTO saniso_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","tadā yīśurakathayad uttiṣṭha, tava śayyāmuttōlya gr̥hītvā yāhi| ");
INSERT INTO saniso_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","sa tatkṣaṇāt svasthō bhūtvā śayyāmuttōlyādāya gatavān kintu taddinaṁ viśrāmavāraḥ| ");
INSERT INTO saniso_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","tasmād yihūdīyāḥ svasthaṁ naraṁ vyāharan adya viśrāmavārē śayanīyamādāya na yātavyam| ");
INSERT INTO saniso_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","tataḥ sa pratyavōcad yō māṁ svastham akārṣīt śayanīyam uttōlyādāya yātuṁ māṁ sa ēvādiśat| ");
INSERT INTO saniso_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","tadā tē'pr̥cchan śayanīyam uttōlyādāya yātuṁ ya ājñāpayat sa kaḥ? ");
INSERT INTO saniso_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","kintu sa ka iti svasthībhūtō nājānād yatastasmin sthānē janatāsattvād yīśuḥ sthānāntaram āgamat| ");
INSERT INTO saniso_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","tataḥ paraṁ yēśu rmandirē taṁ naraṁ sākṣātprāpyākathayat paśyēdānīm anāmayō jātōsi yathādhikā durdaśā na ghaṭatē taddhētōḥ pāpaṁ karmma punarmākārṣīḥ| ");
INSERT INTO saniso_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","tataḥ sa gatvā yihūdīyān avadad yīśu rmām arōgiṇam akārṣīt| ");
INSERT INTO saniso_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","tatō yīśu rviśrāmavārē karmmēdr̥śaṁ kr̥tavān iti hētō ryihūdīyāstaṁ tāḍayitvā hantum acēṣṭanta| ");
INSERT INTO saniso_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","yīśustānākhyat mama pitā yat kāryyaṁ karōti tadanurūpam ahamapi karōti| ");
INSERT INTO saniso_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","tatō yihūdīyāstaṁ hantuṁ punarayatanta yatō viśrāmavāraṁ nāmanyata tadēva kēvalaṁ na adhikantu īśvaraṁ svapitaraṁ prōcya svamapīśvaratulyaṁ kr̥tavān| ");
INSERT INTO saniso_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","paścād yīśuravadad yuṣmānahaṁ yathārthataraṁ vadāmi putraḥ pitaraṁ yadyat karmma kurvvantaṁ paśyati tadatiriktaṁ svēcchātaḥ kimapi karmma karttuṁ na śaknōti| pitā yat karōti putrōpi tadēva karōti| ");
INSERT INTO saniso_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","pitā putrē snēhaṁ karōti tasmāt svayaṁ yadyat karmma karōti tatsarvvaṁ putraṁ darśayati ; yathā ca yuṣmākaṁ āścaryyajñānaṁ janiṣyatē tadartham itōpi mahākarmma taṁ darśayiṣyati| ");
INSERT INTO saniso_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","vastutastu pitā yathā pramitān utthāpya sajivān karōti tadvat putrōpi yaṁ yaṁ icchati taṁ taṁ sajīvaṁ karōti| ");
INSERT INTO saniso_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","sarvvē pitaraṁ yathā satkurvvanti tathā putramapi satkārayituṁ pitā svayaṁ kasyāpi vicāramakr̥tvā sarvvavicārāṇāṁ bhāraṁ putrē samarpitavān| ");
INSERT INTO saniso_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","yaḥ putraṁ sat karōti sa tasya prērakamapi sat karōti| ");
INSERT INTO saniso_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","yuṣmānāhaṁ yathārthataraṁ vadāmi yō janō mama vākyaṁ śrutvā matprērakē viśvasiti sōnantāyuḥ prāpnōti kadāpi daṇḍabājanaṁ na bhavati nidhanādutthāya paramāyuḥ prāpnōti| ");
INSERT INTO saniso_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","ahaṁ yuṣmānatiyathārthaṁ vadāmi yadā mr̥tā īśvaraputrasya ninādaṁ śrōṣyanti yē ca śrōṣyanti tē sajīvā bhaviṣyanti samaya ētādr̥śa āyāti varam idānīmapyupatiṣṭhati| ");
INSERT INTO saniso_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","pitā yathā svayañjīvī tathā putrāya svayañjīvitvādhikāraṁ dattavān| ");
INSERT INTO saniso_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","sa manuṣyaputraḥ ētasmāt kāraṇāt pitā daṇḍakaraṇādhikāramapi tasmin samarpitavān| ");
INSERT INTO saniso_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","ētadarthē yūyam āścaryyaṁ na manyadhvaṁ yatō yasmin samayē tasya ninādaṁ śrutvā śmaśānasthāḥ sarvvē bahirāgamiṣyanti samaya ētādr̥śa upasthāsyati| ");
INSERT INTO saniso_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","tasmād yē satkarmmāṇi kr̥tavantasta utthāya āyuḥ prāpsyanti yē ca kukarmāṇi kr̥tavantasta utthāya daṇḍaṁ prāpsyanti| ");
INSERT INTO saniso_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","ahaṁ svayaṁ kimapi karttuṁ na śaknōmi yathā śuṇōmi tathā vicārayāmi mama vicārañca nyāyyaḥ yatōhaṁ svīyābhīṣṭaṁ nēhitvā matprērayituḥ pituriṣṭam īhē| ");
INSERT INTO saniso_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","yadi svasmin svayaṁ sākṣyaṁ dadāmi tarhi tatsākṣyam āgrāhyaṁ bhavati ; ");
INSERT INTO saniso_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","kintu madarthē'parō janaḥ sākṣyaṁ dadāti madarthē tasya yat sākṣyaṁ tat satyam ētadapyahaṁ jānāmi| ");
INSERT INTO saniso_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","yuṣmābhi ryōhanaṁ prati lōkēṣu prēritēṣu sa satyakathāyāṁ sākṣyamadadāt| ");
INSERT INTO saniso_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","mānuṣādahaṁ sākṣyaṁ nōpēkṣē tathāpi yūyaṁ yathā paritrayadhvē tadartham idaṁ vākyaṁ vadāmi| ");
INSERT INTO saniso_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","yōhan dēdīpyamānō dīpa iva tējasvī sthitavān yūyam alpakālaṁ tasya dīptyānandituṁ samamanyadhvaṁ| ");
INSERT INTO saniso_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","kintu tatpramāṇādapi mama gurutaraṁ pramāṇaṁ vidyatē pitā māṁ prēṣya yadyat karmma samāpayituṁ śakttimadadāt mayā kr̥taṁ tattat karmma madarthē pramāṇaṁ dadāti| ");
INSERT INTO saniso_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","yaḥ pitā māṁ prēritavān mōpi madarthē pramāṇaṁ dadāti| tasya vākyaṁ yuṣmābhiḥ kadāpi na śrutaṁ tasya rūpañca na dr̥ṣṭaṁ ");
INSERT INTO saniso_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","tasya vākyañca yuṣmākam antaḥ kadāpi sthānaṁ nāpnōti yataḥ sa yaṁ prēṣitavān yūyaṁ tasmin na viśvasitha| ");
INSERT INTO saniso_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","dharmmapustakāni yūyam ālōcayadhvaṁ tai rvākyairanantāyuḥ prāpsyāma iti yūyaṁ budhyadhvē taddharmmapustakāni madarthē pramāṇaṁ dadati| ");
INSERT INTO saniso_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","tathāpi yūyaṁ paramāyuḥprāptayē mama saṁnidhim na jigamiṣatha| ");
INSERT INTO saniso_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","ahaṁ mānuṣēbhyaḥ satkāraṁ na gr̥hlāmi| ");
INSERT INTO saniso_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ahaṁ yuṣmān jānāmi; yuṣmākamantara īśvaraprēma nāsti| ");
INSERT INTO saniso_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ahaṁ nijapitu rnāmnāgatōsmi tathāpi māṁ na gr̥hlītha kintu kaścid yadi svanāmnā samāgamiṣyati tarhi taṁ grahīṣyatha| ");
INSERT INTO saniso_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","yūyam īśvarāt satkāraṁ na ciṣṭatvā kēvalaṁ parasparaṁ satkāram cēd ādadhvvē tarhi kathaṁ viśvasituṁ śaknutha? ");
INSERT INTO saniso_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","putuḥ samīpē'haṁ yuṣmān apavadiṣyāmīti mā cintayata yasmin , yasmin yuṣmākaṁ viśvasaḥ saēva mūsā yuṣmān apavadati| ");
INSERT INTO saniso_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","yadi yūyaṁ tasmin vyaśvasiṣyata tarhi mayyapi vyaśvasiṣyata, yat sa mayi likhitavān| ");
INSERT INTO saniso_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","tatō yadi tēna likhitavāni na pratitha tarhi mama vākyāni kathaṁ pratyēṣyatha? ");
INSERT INTO saniso_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","tataḥ paraṁ yīśu rgālīl pradēśīyasya tiviriyānāmnaḥ sindhōḥ pāraṁ gatavān| ");
INSERT INTO saniso_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","tatō vyādhimallōkasvāsthyakaraṇarūpāṇi tasyāścaryyāṇi karmmāṇi dr̥ṣṭvā bahavō janāstatpaścād agacchan| ");
INSERT INTO saniso_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","tatō yīśuḥ parvvatamāruhya tatra śiṣyaiḥ sākam| ");
INSERT INTO saniso_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","tasmin samaya nistārōtsavanāmni yihūdīyānāma utsava upasthitē ");
INSERT INTO saniso_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","yīśu rnētrē uttōlya bahulōkān svasamīpāgatān vilōkya philipaṁ pr̥ṣṭavān ētēṣāṁ bhōjanāya bhōjadravyāṇi vayaṁ kutra krētuṁ śakrumaḥ? ");
INSERT INTO saniso_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","vākyamidaṁ tasya parīkṣārtham avādīt kintu yat kariṣyati tat svayam ajānāt| ");
INSERT INTO saniso_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","philipaḥ pratyavōcat ētēṣām ēkaikō yadyalpam alpaṁ prāpnōti tarhi mudrāpādadviśatēna krītapūpā api nyūnā bhaviṣyanti| ");
INSERT INTO saniso_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","śimōn pitarasya bhrātā āndriyākhyaḥ śiṣyāṇāmēkō vyāhr̥tavān ");
INSERT INTO saniso_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","atra kasyacid bālakasya samīpē pañca yāvapūpāḥ kṣudramatsyadvayañca santi kintu lōkānāṁ ētāvātāṁ madhyē taiḥ kiṁ bhaviṣyati? ");
INSERT INTO saniso_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","paścād yīśuravadat lōkānupavēśayata tatra bahuyavasasattvāt pañcasahastrēbhyō nyūnā adhikā vā puruṣā bhūmyām upāviśan| ");
INSERT INTO saniso_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","tatō yīśustān pūpānādāya īśvarasya guṇān kīrttayitvā śiṣyēṣu samārpayat tatastē tēbhya upaviṣṭalōkēbhyaḥ pūpān yathēṣṭamatsyañca prāduḥ| ");
INSERT INTO saniso_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","tēṣu tr̥ptēṣu sa tānavōcad ētēṣāṁ kiñcidapi yathā nāpacīyatē tathā sarvvāṇyavaśiṣṭāni saṁgr̥hlīta| ");
INSERT INTO saniso_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","tataḥ sarvvēṣāṁ bhōjanāt paraṁ tē tēṣāṁ pañcānāṁ yāvapūpānāṁ avaśiṣṭānyakhilāni saṁgr̥hya dvādaśaḍallakān apūrayan| ");
INSERT INTO saniso_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","aparaṁ yīśōrētādr̥śīm āścaryyakriyāṁ dr̥ṣṭvā lōkā mithō vaktumārēbhirē jagati yasyāgamanaṁ bhaviṣyati sa ēvāyam avaśyaṁ bhaviṣyadvakttā| ");
INSERT INTO saniso_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ataēva lōkā āgatya tamākramya rājānaṁ kariṣyanti yīśustēṣām īdr̥śaṁ mānasaṁ vijñāya punaśca parvvatam ēkākī gatavān| ");
INSERT INTO saniso_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","sāyaṁkāla upasthitē śiṣyā jaladhitaṭaṁ vrajitvā nāvamāruhya nagaradiśi sindhau vāhayitvāgaman| ");
INSERT INTO saniso_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","tasmin samayē timira upātiṣṭhat kintu yīṣustēṣāṁ samīpaṁ nāgacchat| ");
INSERT INTO saniso_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","tadā prabalapavanavahanāt sāgarē mahātaraṅgō bhavitum ārēbhē| ");
INSERT INTO saniso_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","tatastē vāhayitvā dvitrān krōśān gatāḥ paścād yīśuṁ jaladhērupari padbhyāṁ vrajantaṁ naukāntikam āgacchantaṁ vilōkya trāsayuktā abhavan ");
INSERT INTO saniso_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","kintu sa tānukttavān ayamahaṁ mā bhaiṣṭa| ");
INSERT INTO saniso_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","tadā tē taṁ svairaṁ nāvi gr̥hītavantaḥ tadā tatkṣaṇād uddiṣṭasthānē naurupāsthāt| ");
INSERT INTO saniso_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","yayā nāvā śiṣyā agacchan tadanyā kāpi naukā tasmin sthānē nāsīt tatō yīśuḥ śiṣyaiḥ sākaṁ nāgamat kēvalāḥ śiṣyā agaman ētat pārasthā lōkā jñātavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","kintu tataḥ paraṁ prabhu ryatra īśvarasya guṇān anukīrttya lōkān pūpān abhōjayat tatsthānasya samīpasthativiriyāyā aparāstaraṇaya āgaman| ");
INSERT INTO saniso_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","yīśustatra nāsti śiṣyā api tatra nā santi lōkā iti vijñāya yīśuṁ gavēṣayituṁ taraṇibhiḥ kapharnāhūm puraṁ gatāḥ| ");
INSERT INTO saniso_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","tatastē saritpatēḥ pārē taṁ sākṣāt prāpya prāvōcan hē gurō bhavān atra sthānē kadāgamat? ");
INSERT INTO saniso_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","tadā yīśustān pratyavādīd yuṣmānahaṁ yathārthataraṁ vadāmi āścaryyakarmmadarśanāddhētō rna kintu pūpabhōjanāt tēna tr̥ptatvāñca māṁ gavēṣayatha| ");
INSERT INTO saniso_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","kṣayaṇīyabhakṣyārthaṁ mā śrāmiṣṭa kintvantāyurbhakṣyārthaṁ śrāmyata, tasmāt tādr̥śaṁ bhakṣyaṁ manujaputrō yuṣmābhyaṁ dāsyati; tasmin tāta īśvaraḥ pramāṇaṁ prādāt| ");
INSERT INTO saniso_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","tadā tē'pr̥cchan īśvarābhimataṁ karmma karttum asmābhiḥ kiṁ karttavyaṁ? ");
INSERT INTO saniso_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","tatō yīśuravadad īśvarō yaṁ prairayat tasmin viśvasanam īśvarābhimataṁ karmma| ");
INSERT INTO saniso_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","tadā tē vyāharan bhavatā kiṁ lakṣaṇaṁ darśitaṁ yaddr̥ṣṭvā bhavati viśvasiṣyāmaḥ? tvayā kiṁ karmma kr̥taṁ? ");
INSERT INTO saniso_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","asmākaṁ pūrvvapuruṣā mahāprāntarē mānnāṁ bhōkttuṁ prāpuḥ yathā lipirāstē| svargīyāṇi tu bhakṣyāṇi pradadau paramēśvaraḥ| ");
INSERT INTO saniso_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","tadā yīśuravadad ahaṁ yuṣmānatiyathārthaṁ vadāmi mūsā yuṣmābhyaṁ svargīyaṁ bhakṣyaṁ nādāt kintu mama pitā yuṣmābhyaṁ svargīyaṁ paramaṁ bhakṣyaṁ dadāti| ");
INSERT INTO saniso_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","yaḥ svargādavaruhya jagatē jīvanaṁ dadāti sa īśvaradattabhakṣyarūpaḥ| ");
INSERT INTO saniso_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","tadā tē prāvōcan hē prabhō bhakṣyamidaṁ nityamasmabhyaṁ dadātu| ");
INSERT INTO saniso_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","yīśuravadad ahamēva jīvanarūpaṁ bhakṣyaṁ yō janō mama sannidhim āgacchati sa jātu kṣudhārttō na bhaviṣyati, tathā yō janō māṁ pratyēti sa jātu tr̥ṣārttō na bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","māṁ dr̥ṣṭvāpi yūyaṁ na viśvasitha yuṣmānaham ityavōcaṁ| ");
INSERT INTO saniso_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","pitā mahyaṁ yāvatō lōkānadadāt tē sarvva ēva mamāntikam āgamiṣyanti yaḥ kaścicca mama sannidhim āyāsyati taṁ kēnāpi prakārēṇa na dūrīkariṣyāmi| ");
INSERT INTO saniso_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","nijābhimataṁ sādhayituṁ na hi kintu prērayiturabhimataṁ sādhayituṁ svargād āgatōsmi| ");
INSERT INTO saniso_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","sa yān yān lōkān mahyamadadāt tēṣāmēkamapi na hārayitvā śēṣadinē sarvvānaham utthāpayāmi idaṁ matprērayituḥ piturabhimataṁ| ");
INSERT INTO saniso_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","yaḥ kaścin mānavasutaṁ vilōkya viśvasiti sa śēṣadinē mayōtthāpitaḥ san anantāyuḥ prāpsyati iti matprērakasyābhimataṁ| ");
INSERT INTO saniso_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","tadā svargād yad bhakṣyam avārōhat tad bhakṣyam ahamēva yihūdīyalōkāstasyaitad vākyē vivadamānā vakttumārēbhirē ");
INSERT INTO saniso_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","yūṣaphaḥ putrō yīśu ryasya mātāpitarau vayaṁ jānīma ēṣa kiṁ saēva na? tarhi svargād avārōham iti vākyaṁ kathaṁ vaktti? ");
INSERT INTO saniso_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","tadā yīśustān pratyavadat parasparaṁ mā vivadadhvaṁ ");
INSERT INTO saniso_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","matprērakēṇa pitrā nākr̥ṣṭaḥ kōpi janō mamāntikam āyātuṁ na śaknōti kintvāgataṁ janaṁ caramē'hni prōtthāpayiṣyāmi| ");
INSERT INTO saniso_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","tē sarvva īśvarēṇa śikṣitā bhaviṣyanti bhaviṣyadvādināṁ granthēṣu lipiritthamāstē atō yaḥ kaścit pituḥ sakāśāt śrutvā śikṣatē sa ēva mama samīpam āgamiṣyati| ");
INSERT INTO saniso_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ya īśvarād ajāyata taṁ vinā kōpi manuṣyō janakaṁ nādarśat kēvalaḥ saēva tātam adrākṣīt| ");
INSERT INTO saniso_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","ahaṁ yuṣmān yathārthataraṁ vadāmi yō janō mayi viśvāsaṁ karōti sōnantāyuḥ prāpnōti| ");
INSERT INTO saniso_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ahamēva tajjīvanabhakṣyaṁ| ");
INSERT INTO saniso_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","yuṣmākaṁ pūrvvapuruṣā mahāprāntarē mannābhakṣyaṁ bhūkttāpi mr̥tāḥ ");
INSERT INTO saniso_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","kintu yadbhakṣyaṁ svargādāgacchat tad yadi kaścid bhuṅkttē tarhi sa na mriyatē| ");
INSERT INTO saniso_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","yajjīvanabhakṣyaṁ svargādāgacchat sōhamēva idaṁ bhakṣyaṁ yō janō bhuṅkttē sa nityajīvī bhaviṣyati| punaśca jagatō jīvanārthamahaṁ yat svakīyapiśitaṁ dāsyāmi tadēva mayā vitaritaṁ bhakṣyam| ");
INSERT INTO saniso_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","tasmād yihūdīyāḥ parasparaṁ vivadamānā vakttumārēbhirē ēṣa bhōjanārthaṁ svīyaṁ palalaṁ katham asmabhyaṁ dāsyati? ");
INSERT INTO saniso_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","tadā yīśustān āvōcad yuṣmānahaṁ yathārthataraṁ vadāmi manuṣyaputrasyāmiṣē yuṣmābhi rna bhukttē tasya rudhirē ca na pītē jīvanēna sārddhaṁ yuṣmākaṁ sambandhō nāsti| ");
INSERT INTO saniso_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","yō mamāmiṣaṁ svādati mama sudhirañca pivati sōnantāyuḥ prāpnōti tataḥ śēṣē'hni tamaham utthāpayiṣyāmi| ");
INSERT INTO saniso_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","yatō madīyamāmiṣaṁ paramaṁ bhakṣyaṁ tathā madīyaṁ śōṇitaṁ paramaṁ pēyaṁ| ");
INSERT INTO saniso_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","yō janō madīyaṁ palalaṁ svādati madīyaṁ rudhirañca pivati sa mayi vasati tasminnahañca vasāmi| ");
INSERT INTO saniso_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","matprērayitrā jīvatā tātēna yathāhaṁ jīvāmi tadvad yaḥ kaścin māmatti sōpi mayā jīviṣyati| ");
INSERT INTO saniso_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","yadbhakṣyaṁ svargādāgacchat tadidaṁ yanmānnāṁ svāditvā yuṣmākaṁ pitarō'mriyanta tādr̥śam idaṁ bhakṣyaṁ na bhavati idaṁ bhakṣyaṁ yō bhakṣati sa nityaṁ jīviṣyati| ");
INSERT INTO saniso_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","yadā kapharnāhūm puryyāṁ bhajanagēhē upādiśat tadā kathā ētā akathayat| ");
INSERT INTO saniso_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","tadētthaṁ śrutvā tasya śiṣyāṇām anēkē parasparam akathayan idaṁ gāḍhaṁ vākyaṁ vākyamīdr̥śaṁ kaḥ śrōtuṁ śakruyāt? ");
INSERT INTO saniso_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","kintu yīśuḥ śiṣyāṇām itthaṁ vivādaṁ svacittē vijñāya kathitavān idaṁ vākyaṁ kiṁ yuṣmākaṁ vighnaṁ janayati? ");
INSERT INTO saniso_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","yadi manujasutaṁ pūrvvavāsasthānam ūrdvvaṁ gacchantaṁ paśyatha tarhi kiṁ bhaviṣyati? ");
INSERT INTO saniso_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","ātmaiva jīvanadāyakaḥ vapu rniṣphalaṁ yuṣmabhyamahaṁ yāni vacāṁsi kathayāmi tānyātmā jīvanañca| ");
INSERT INTO saniso_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","kintu yuṣmākaṁ madhyē kēcana aviśvāsinaḥ santi kē kē na viśvasanti kō vā taṁ parakarēṣu samarpayiṣyati tān yīśurāprathamād vētti| ");
INSERT INTO saniso_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","aparamapi kathitavān asmāt kāraṇād akathayaṁ pituḥ sakāśāt śakttimaprāpya kōpi mamāntikam āgantuṁ na śaknōti| ");
INSERT INTO saniso_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","tatkālē'nēkē śiṣyā vyāghuṭya tēna sārddhaṁ puna rnāgacchan| ");
INSERT INTO saniso_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","tadā yīśu rdvādaśaśiṣyān ukttavān yūyamapi kiṁ yāsyatha? ");
INSERT INTO saniso_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","tataḥ śimōn pitaraḥ pratyavōcat hē prabhō kasyābhyarṇaṁ gamiṣyāmaḥ? ");
INSERT INTO saniso_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","anantajīvanadāyinyō yāḥ kathāstāstavaiva| bhavān amarēśvarasyābhiṣikttaputra iti viśvasya niścitaṁ jānīmaḥ| ");
INSERT INTO saniso_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","tadā yīśuravadat kimahaṁ yuṣmākaṁ dvādaśajanān manōnītān na kr̥tavān? kintu yuṣmākaṁ madhyēpi kaścidēkō vighnakārī vidyatē| ");
INSERT INTO saniso_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","imāṁ kathaṁ sa śimōnaḥ putram īṣkarīyōtīyaṁ yihūdām uddiśya kathitavān yatō dvādaśānāṁ madhyē gaṇitaḥ sa taṁ parakarēṣu samarpayiṣyati| ");
INSERT INTO saniso_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","tataḥ paraṁ yihūdīyalōkāstaṁ hantuṁ samaihanta tasmād yīśu ryihūdāpradēśē paryyaṭituṁ nēcchan gālīl pradēśē paryyaṭituṁ prārabhata| ");
INSERT INTO saniso_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","kintu tasmin samayē yihūdīyānāṁ dūṣyavāsanāmōtsava upasthitē ");
INSERT INTO saniso_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","tasya bhrātarastam avadan yāni karmmāṇi tvayā kriyantē tāni yathā tava śiṣyāḥ paśyanti tadarthaṁ tvamitaḥ sthānād yihūdīyadēśaṁ vraja| ");
INSERT INTO saniso_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","yaḥ kaścit svayaṁ pracikāśiṣati sa kadāpi guptaṁ karmma na karōti yadīdr̥śaṁ karmma karōṣi tarhi jagati nijaṁ paricāyaya| ");
INSERT INTO saniso_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","yatastasya bhrātarōpi taṁ na viśvasanti| ");
INSERT INTO saniso_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","tadā yīśustān avōcat mama samaya idānīṁ nōpatiṣṭhati kintu yuṣmākaṁ samayaḥ satatam upatiṣṭhati| ");
INSERT INTO saniso_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","jagatō lōkā yuṣmān r̥tīyituṁ na śakruvanti kintu māmēva r̥tīyantē yatastēṣāṁ karmāṇi duṣṭāni tatra sākṣyamidam ahaṁ dadāmi| ");
INSERT INTO saniso_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","ataēva yūyam utsavē'smin yāta nāham idānīm asminnutsavē yāmi yatō mama samaya idānīṁ na sampūrṇaḥ| ");
INSERT INTO saniso_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","iti vākyam ukttvā sa gālīli sthitavān ");
INSERT INTO saniso_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","kintu tasya bhrātr̥ṣu tatra prasthitēṣu satsu sō'prakaṭa utsavam agacchat| ");
INSERT INTO saniso_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","anantaram utsavam upasthitā yihūdīyāstaṁ mr̥gayitvāpr̥cchan sa kutra? ");
INSERT INTO saniso_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","tatō lōkānāṁ madhyē tasmin nānāvidhā vivādā bhavitum ārabdhavantaḥ| kēcid avōcan sa uttamaḥ puruṣaḥ kēcid avōcan na tathā varaṁ lōkānāṁ bhramaṁ janayati| ");
INSERT INTO saniso_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","kintu yihūdīyānāṁ bhayāt kōpi tasya pakṣē spaṣṭaṁ nākathayat| ");
INSERT INTO saniso_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","tataḥ param utsavasya madhyasamayē yīśu rmandiraṁ gatvā samupadiśati sma| ");
INSERT INTO saniso_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","tatō yihūdīyā lōkā āścaryyaṁ jñātvākathayan ēṣā mānuṣō nādhītyā katham ētādr̥śō vidvānabhūt? ");
INSERT INTO saniso_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","tadā yīśuḥ pratyavōcad upadēśōyaṁ na mama kintu yō māṁ prēṣitavān tasya| ");
INSERT INTO saniso_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","yō janō nidēśaṁ tasya grahīṣyati mamōpadēśō mattō bhavati kim īśvarād bhavati sa ganastajjñātuṁ śakṣyati| ");
INSERT INTO saniso_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","yō janaḥ svataḥ kathayati sa svīyaṁ gauravam īhatē kintu yaḥ prērayitu rgauravam īhatē sa satyavādī tasmin kōpyadharmmō nāsti| ");
INSERT INTO saniso_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","mūsā yuṣmabhyaṁ vyavasthāgranthaṁ kiṁ nādadāt? kintu yuṣmākaṁ kōpi tāṁ vyavasthāṁ na samācarati| māṁ hantuṁ kutō yatadhvē? ");
INSERT INTO saniso_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","tadā lōkā avadan tvaṁ bhūtagrastastvāṁ hantuṁ kō yatatē? ");
INSERT INTO saniso_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","tatō yīśuravōcad ēkaṁ karmma mayākāri tasmād yūyaṁ sarvva mahāścaryyaṁ manyadhvē| ");
INSERT INTO saniso_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","mūsā yuṣmabhyaṁ tvakchēdavidhiṁ pradadau sa mūsātō na jātaḥ kintu pitr̥puruṣēbhyō jātaḥ tēna viśrāmavārē'pi mānuṣāṇāṁ tvakchēdaṁ kurutha| ");
INSERT INTO saniso_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ataēva viśrāmavārē manuṣyāṇāṁ tvakchēdē kr̥tē yadi mūsāvyavasthāmaṅganaṁ na bhavati tarhi mayā viśrāmavārē mānuṣaḥ sampūrṇarūpēṇa svasthō'kāri tatkāraṇād yūyaṁ kiṁ mahyaṁ kupyatha? ");
INSERT INTO saniso_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","sapakṣapātaṁ vicāramakr̥tvā nyāyyaṁ vicāraṁ kuruta| ");
INSERT INTO saniso_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","tadā yirūśālam nivāsinaḥ katipayajanā akathayan imē yaṁ hantuṁ cēṣṭantē sa ēvāyaṁ kiṁ na? ");
INSERT INTO saniso_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","kintu paśyata nirbhayaḥ san kathāṁ kathayati tathāpi kimapi a vadantyētē ayamēvābhiṣikttō bhavatīti niścitaṁ kimadhipatayō jānanti? ");
INSERT INTO saniso_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","manujōyaṁ kasmādāgamad iti vayaṁ jānōmaḥ kintvabhiṣiktta āgatē sa kasmādāgatavān iti kōpi jñātuṁ na śakṣyati| ");
INSERT INTO saniso_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","tadā yīśu rmadhyēmandiram upadiśan uccaiḥkāram ukttavān yūyaṁ kiṁ māṁ jānītha? kasmāccāgatōsmi tadapi kiṁ jānītha? nāhaṁ svata āgatōsmi kintu yaḥ satyavādī saēva māṁ prēṣitavān yūyaṁ taṁ na jānītha| ");
INSERT INTO saniso_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","tamahaṁ jānē tēnāhaṁ prērita agatōsmi| ");
INSERT INTO saniso_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","tasmād yihūdīyāstaṁ dharttum udyatāstathāpi kōpi tasya gātrē hastaṁ nārpayad yatō hētōstadā tasya samayō nōpatiṣṭhati| ");
INSERT INTO saniso_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","kintu bahavō lōkāstasmin viśvasya kathitavāntō'bhiṣikttapuruṣa āgatya mānuṣasyāsya kriyābhyaḥ kim adhikā āścaryyāḥ kriyāḥ kariṣyati? ");
INSERT INTO saniso_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","tataḥ paraṁ lōkāstasmin itthaṁ vivadantē phirūśinaḥ pradhānayājakāñcēti śrutavantastaṁ dhr̥tvā nētuṁ padātigaṇaṁ prēṣayāmāsuḥ| ");
INSERT INTO saniso_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","tatō yīśuravadad aham alpadināni yuṣmābhiḥ sārddhaṁ sthitvā matprērayituḥ samīpaṁ yāsyāmi| ");
INSERT INTO saniso_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","māṁ mr̥gayiṣyadhvē kintūddēśaṁ na lapsyadhvē ratra sthāsyāmi tatra yūyaṁ gantuṁ na śakṣyatha| ");
INSERT INTO saniso_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","tadā yihūdīyāḥ parasparaṁ vakttumārēbhirē asyōddēśaṁ na prāpsyāma ētādr̥śaṁ kiṁ sthānaṁ yāsyati? bhinnadēśē vikīrṇānāṁ yihūdīyānāṁ sannidhim ēṣa gatvā tān upadēkṣyati kiṁ? ");
INSERT INTO saniso_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","nō cēt māṁ gavēṣayiṣyatha kintūddēśaṁ na prāpsyatha ēṣa kōdr̥śaṁ vākyamidaṁ vadati? ");
INSERT INTO saniso_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","anantaram utsavasya caramē'hani arthāt pradhānadinē yīśuruttiṣṭhan uccaiḥkāram āhvayan uditavān yadi kaścit tr̥ṣārttō bhavati tarhi mamāntikam āgatya pivatu| ");
INSERT INTO saniso_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","yaḥ kaścinmayi viśvasiti dharmmagranthasya vacanānusārēṇa tasyābhyantaratō'mr̥tatōyasya srōtāṁsi nirgamiṣyanti| ");
INSERT INTO saniso_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","yē tasmin viśvasanti ta ātmānaṁ prāpsyantītyarthē sa idaṁ vākyaṁ vyāhr̥tavān ētatkālaṁ yāvad yīśu rvibhavaṁ na prāptastasmāt pavitra ātmā nādīyata| ");
INSERT INTO saniso_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ētāṁ vāṇīṁ śrutvā bahavō lōkā avadan ayamēva niścitaṁ sa bhaviṣyadvādī| ");
INSERT INTO saniso_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","kēcid akathayan ēṣaēva sōbhiṣikttaḥ kintu kēcid avadan sōbhiṣikttaḥ kiṁ gālīl pradēśē janiṣyatē? ");
INSERT INTO saniso_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","sōbhiṣikttō dāyūdō vaṁśē dāyūdō janmasthānē baitlēhami pattanē janiṣyatē dharmmagranthē kimitthaṁ likhitaṁ nāsti? ");
INSERT INTO saniso_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","itthaṁ tasmin lōkānāṁ bhinnavākyatā jātā| ");
INSERT INTO saniso_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","katipayalōkāstaṁ dharttum aicchan tathāpi tadvapuṣi kōpi hastaṁ nārpayat| ");
INSERT INTO saniso_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","anantaraṁ pādātigaṇē pradhānayājakānāṁ phirūśināñca samīpamāgatavati tē tān apr̥cchan kutō hētōstaṁ nānayata? ");
INSERT INTO saniso_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","tadā padātayaḥ pratyavadan sa mānava iva kōpi kadāpi nōpādiśat| ");
INSERT INTO saniso_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","tataḥ phirūśinaḥ prāvōcan yūyamapi kimabhrāmiṣṭa? ");
INSERT INTO saniso_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","adhipatīnāṁ phirūśināñca kōpi kiṁ tasmin vyaśvasīt? ");
INSERT INTO saniso_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","yē śāstraṁ na jānanti ta imē'dhamalōkāēva śāpagrastāḥ| ");
INSERT INTO saniso_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","tadā nikadīmanāmā tēṣāmēkō yaḥ kṣaṇadāyāṁ yīśōḥ sannidhim agāt sa ukttavān ");
INSERT INTO saniso_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","tasya vākyē na śrutē karmmaṇi ca na viditē 'smākaṁ vyavasthā kiṁ kañcana manujaṁ dōṣīkarōti? ");
INSERT INTO saniso_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","tatastē vyāharan tvamapi kiṁ gālīlīyalōkaḥ? vivicya paśya galīli kōpi bhaviṣyadvādī nōtpadyatē| ");
INSERT INTO saniso_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","tataḥ paraṁ sarvvē svaṁ svaṁ gr̥haṁ gatāḥ kintu yīśu rjaitunanāmānaṁ śilōccayaṁ gatavān| ");
INSERT INTO saniso_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","pratyūṣē yīśuḥ panarmandiram āgacchat ");
INSERT INTO saniso_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","tataḥ sarvvēṣu lōkēṣu tasya samīpa āgatēṣu sa upaviśya tān upadēṣṭum ārabhata| ");
INSERT INTO saniso_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","tadā adhyāpakāḥ phirūśinañca vyabhicārakarmmaṇi dhr̥taṁ striyamēkām āniya sarvvēṣāṁ madhyē sthāpayitvā vyāharan ");
INSERT INTO saniso_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","hē gurō yōṣitam imāṁ vyabhicārakarmma kurvvāṇāṁ lōkā dhr̥tavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ētādr̥śalōkāḥ pāṣāṇāghātēna hantavyā iti vidhirmūsāvyavasthāgranthē likhitōsti kintu bhavān kimādiśati? ");
INSERT INTO saniso_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","tē tamapavadituṁ parīkṣābhiprāyēṇa vākyamidam apr̥cchan kintu sa prahvībhūya bhūmāvaṅgalyā lēkhitum ārabhata| ");
INSERT INTO saniso_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","tatastaiḥ punaḥ punaḥ pr̥ṣṭa utthāya kathitavān yuṣmākaṁ madhyē yō janō niraparādhī saēva prathamam ēnāṁ pāṣāṇēnāhantu| ");
INSERT INTO saniso_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","paścāt sa punaśca prahvībhūya bhūmau lēkhitum ārabhata| ");
INSERT INTO saniso_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","tāṁ kathaṁ śrutvā tē svasvamanasi prabōdhaṁ prāpya jyēṣṭhānukramaṁ ēkaikaśaḥ sarvvē bahiragacchan tatō yīśurēkākī tayakttōbhavat madhyasthānē daṇḍāyamānā sā yōṣā ca sthitā| ");
INSERT INTO saniso_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","tatpaścād yīśurutthāya tāṁ vanitāṁ vinā kamapyaparaṁ na vilōkya pr̥ṣṭavān hē vāmē tavāpavādakāḥ kutra? kōpi tvāṁ kiṁ na daṇḍayati? ");
INSERT INTO saniso_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","sāvadat hē mahēccha kōpi na tadā yīśuravōcat nāhamapi daṇḍayāmi yāhi punaḥ pāpaṁ mākārṣīḥ| ");
INSERT INTO saniso_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","tatō yīśuḥ punarapi lōkēbhya itthaṁ kathayitum ārabhata jagatōhaṁ jyōtiḥsvarūpō yaḥ kaścin matpaścāda gacchati sa timirē na bhramitvā jīvanarūpāṁ dīptiṁ prāpsyati| ");
INSERT INTO saniso_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","tataḥ phirūśinō'vādiṣustvaṁ svārthē svayaṁ sākṣyaṁ dadāsi tasmāt tava sākṣyaṁ grāhyaṁ na bhavati| ");
INSERT INTO saniso_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","tadā yīśuḥ pratyuditavān yadyapi svārthē'haṁ svayaṁ sākṣyaṁ dadāmi tathāpi mat sākṣyaṁ grāhyaṁ yasmād ahaṁ kuta āgatōsmi kva yāmi ca tadahaṁ jānāmi kintu kuta āgatōsmi kutra gacchāmi ca tad yūyaṁ na jānītha| ");
INSERT INTO saniso_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","yūyaṁ laukikaṁ vicārayatha nāhaṁ kimapi vicārayāmi| ");
INSERT INTO saniso_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","kintu yadi vicārayāmi tarhi mama vicārō grahītavyō yatōham ēkākī nāsmi prērayitā pitā mayā saha vidyatē| ");
INSERT INTO saniso_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","dvayō rjanayōḥ sākṣyaṁ grahaṇīyaṁ bhavatīti yuṣmākaṁ vyavasthāgranthē likhitamasti| ");
INSERT INTO saniso_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ahaṁ svārthē svayaṁ sākṣitvaṁ dadāmi yaśca mama tātō māṁ prēritavān sōpi madarthē sākṣyaṁ dadāti| ");
INSERT INTO saniso_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","tadā tē'pr̥cchan tava tātaḥ kutra? tatō yīśuḥ pratyavādīd yūyaṁ māṁ na jānītha matpitarañca na jānītha yadi mām akṣāsyata tarhi mama tātamapyakṣāsyata| ");
INSERT INTO saniso_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","yīśu rmandira upadiśya bhaṇḍāgārē kathā ētā akathayat tathāpi taṁ prati kōpi karaṁ nōdatōlayat| ");
INSERT INTO saniso_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","tataḥ paraṁ yīśuḥ punaruditavān adhunāhaṁ gacchāmi yūyaṁ māṁ gavēṣayiṣyatha kintu nijaiḥ pāpai rmariṣyatha yat sthānam ahaṁ yāsyāmi tat sthānam yūyaṁ yātuṁ na śakṣyatha| ");
INSERT INTO saniso_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","tadā yihūdīyāḥ prāvōcan kimayam ātmaghātaṁ kariṣyati? yatō yat sthānam ahaṁ yāsyāmi tat sthānam yūyaṁ yātuṁ na śakṣyatha iti vākyaṁ bravīti| ");
INSERT INTO saniso_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","tatō yīśustēbhyaḥ kathitavān yūyam adhaḥsthānīyā lōkā aham ūrdvvasthānīyaḥ yūyam ētajjagatsambandhīyā aham ētajjagatsambandhīyō na| ");
INSERT INTO saniso_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","tasmāt kathitavān yūyaṁ nijaiḥ pāpai rmariṣyatha yatōhaṁ sa pumān iti yadi na viśvasitha tarhi nijaiḥ pāpai rmariṣyatha| ");
INSERT INTO saniso_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","tadā tē 'pr̥cchan kastvaṁ? tatō yīśuḥ kathitavān yuṣmākaṁ sannidhau yasya prastāvam ā prathamāt karōmi saēva puruṣōhaṁ| ");
INSERT INTO saniso_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","yuṣmāsu mayā bahuvākyaṁ vakttavyaṁ vicārayitavyañca kintu matprērayitā satyavādī tasya samīpē yadahaṁ śrutavān tadēva jagatē kathayāmi| ");
INSERT INTO saniso_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","kintu sa janakē vākyamidaṁ prōkttavān iti tē nābudhyanta| ");
INSERT INTO saniso_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","tatō yīśurakathayad yadā manuṣyaputram ūrdvva utthāpayiṣyatha tadāhaṁ sa pumān kēvalaḥ svayaṁ kimapi karmma na karōmi kintu tātō yathā śikṣayati tadanusārēṇa vākyamidaṁ vadāmīti ca yūyaṁ jñātuṁ śakṣyatha| ");
INSERT INTO saniso_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","matprērayitā pitā mām ēkākinaṁ na tyajati sa mayā sārddhaṁ tiṣṭhati yatōhaṁ tadabhimataṁ karmma sadā karōmi| ");
INSERT INTO saniso_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","tadā tasyaitāni vākyāni śrutvā bahuvastāsmin vyaśvasan| ");
INSERT INTO saniso_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","yē yihūdīyā vyaśvasan yīśustēbhyō'kathayat ");
INSERT INTO saniso_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","mama vākyē yadi yūyam āsthāṁ kurutha tarhi mama śiṣyā bhūtvā satyatvaṁ jñāsyatha tataḥ satyatayā yuṣmākaṁ mōkṣō bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","tadā tē pratyavādiṣuḥ vayam ibrāhīmō vaṁśaḥ kadāpi kasyāpi dāsā na jātāstarhi yuṣmākaṁ muktti rbhaviṣyatīti vākyaṁ kathaṁ bravīṣi? ");
INSERT INTO saniso_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","tadā yīśuḥ pratyavadad yuṣmānahaṁ yathārthataraṁ vadāmi yaḥ pāpaṁ karōti sa pāpasya dāsaḥ| ");
INSERT INTO saniso_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","dāsaśca nirantaraṁ nivēśanē na tiṣṭhati kintu putrō nirantaraṁ tiṣṭhati| ");
INSERT INTO saniso_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","ataḥ putrō yadi yuṣmān mōcayati tarhi nitāntamēva mukttā bhaviṣyatha| ");
INSERT INTO saniso_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","yuyam ibrāhīmō vaṁśa ityahaṁ jānāmi kintu mama kathā yuṣmākam antaḥkaraṇēṣu sthānaṁ na prāpnuvanti tasmāddhētō rmāṁ hantum īhadhvē| ");
INSERT INTO saniso_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ahaṁ svapituḥ samīpē yadapaśyaṁ tadēva kathayāmi tathā yūyamapi svapituḥ samīpē yadapaśyata tadēva kurudhvē| ");
INSERT INTO saniso_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","tadā tē pratyavōcan ibrāhīm asmākaṁ pitā tatō yīśurakathayad yadi yūyam ibrāhīmaḥ santānā abhaviṣyata tarhi ibrāhīma ācāraṇavad ācariṣyata| ");
INSERT INTO saniso_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","īśvarasya mukhāt satyaṁ vākyaṁ śrutvā yuṣmān jñāpayāmi yōhaṁ taṁ māṁ hantuṁ cēṣṭadhvē ibrāhīm ētādr̥śaṁ karmma na cakāra| ");
INSERT INTO saniso_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","yūyaṁ svasvapituḥ karmmāṇi kurutha tadā tairukttaṁ na vayaṁ jārajātā asmākam ēkaēva pitāsti sa ēvēśvaraḥ ");
INSERT INTO saniso_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","tatō yīśunā kathitam īśvarō yadi yuṣmākaṁ tātōbhaviṣyat tarhi yūyaṁ mayi prēmākariṣyata yatōham īśvarānnirgatyāgatōsmi svatō nāgatōhaṁ sa māṁ prāhiṇōt| ");
INSERT INTO saniso_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","yūyaṁ mama vākyamidaṁ na budhyadhvē kutaḥ? yatō yūyaṁ mamōpadēśaṁ sōḍhuṁ na śaknutha| ");
INSERT INTO saniso_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","yūyaṁ śaitān pituḥ santānā ētasmād yuṣmākaṁ piturabhilāṣaṁ pūrayatha sa ā prathamāt naraghātī tadantaḥ satyatvasya lēśōpi nāsti kāraṇādataḥ sa satyatāyāṁ nātiṣṭhat sa yadā mr̥ṣā kathayati tadā nijasvabhāvānusārēṇaiva kathayati yatō sa mr̥ṣābhāṣī mr̥ṣōtpādakaśca| ");
INSERT INTO saniso_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","ahaṁ tathyavākyaṁ vadāmi kāraṇādasmād yūyaṁ māṁ na pratītha| ");
INSERT INTO saniso_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","mayi pāpamastīti pramāṇaṁ yuṣmākaṁ kō dātuṁ śaknōti? yadyahaṁ tathyavākyaṁ vadāmi tarhi kutō māṁ na pratitha? ");
INSERT INTO saniso_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","yaḥ kaścana īśvarīyō lōkaḥ sa īśvarīyakathāyāṁ manō nidhattē yūyam īśvarīyalōkā na bhavatha tannidānāt tatra na manāṁsi nidhadvē| ");
INSERT INTO saniso_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","tadā yihūdīyāḥ pratyavādiṣuḥ tvamēkaḥ śōmirōṇīyō bhūtagrastaśca vayaṁ kimidaṁ bhadraṁ nāvādiṣma? ");
INSERT INTO saniso_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","tatō yīśuḥ pratyavādīt nāhaṁ bhūtagrastaḥ kintu nijatātaṁ sammanyē tasmād yūyaṁ mām apamanyadhvē| ");
INSERT INTO saniso_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","ahaṁ svasukhyātiṁ na cēṣṭē kintu cēṣṭitā vicārayitā cāpara ēka āstē| ");
INSERT INTO saniso_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ahaṁ yuṣmabhyam atīva yathārthaṁ kathayāmi yō narō madīyaṁ vācaṁ manyatē sa kadācana nidhanaṁ na drakṣyati| ");
INSERT INTO saniso_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","yihūdīyāstamavadan tvaṁ bhūtagrasta itīdānīm avaiṣma| ibrāhīm bhaviṣyadvādinañca sarvvē mr̥tāḥ kintu tvaṁ bhāṣasē yō narō mama bhāratīṁ gr̥hlāti sa jātu nidhānāsvādaṁ na lapsyatē| ");
INSERT INTO saniso_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","tarhi tvaṁ kim asmākaṁ pūrvvapuruṣād ibrāhīmōpi mahān? yasmāt sōpi mr̥taḥ bhaviṣyadvādinōpi mr̥tāḥ tvaṁ svaṁ kaṁ pumāṁsaṁ manuṣē? ");
INSERT INTO saniso_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","yīśuḥ pratyavōcad yadyahaṁ svaṁ svayaṁ sammanyē tarhi mama tat sammananaṁ kimapi na kintu mama tātō yaṁ yūyaṁ svīyam īśvaraṁ bhāṣadhvē saēva māṁ sammanutē| ");
INSERT INTO saniso_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","yūyaṁ taṁ nāvagacchatha kintvahaṁ tamavagacchāmi taṁ nāvagacchāmīti vākyaṁ yadi vadāmi tarhi yūyamiva mr̥ṣābhāṣī bhavāmi kintvahaṁ tamavagacchāmi tadākṣāmapi gr̥hlāmi| ");
INSERT INTO saniso_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","yuṣmākaṁ pūrvvapuruṣa ibrāhīm mama samayaṁ draṣṭum atīvāvāñchat tannirīkṣyānandacca| ");
INSERT INTO saniso_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","tadā yihūdīyā apr̥cchan tava vayaḥ pañcāśadvatsarā na tvaṁ kim ibrāhīmam adrākṣīḥ? ");
INSERT INTO saniso_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","yīśuḥ pratyavādīd yuṣmānahaṁ yathārthataraṁ vadāmi ibrāhīmō janmanaḥ pūrvvakālamārabhyāhaṁ vidyē| ");
INSERT INTO saniso_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","tadā tē pāṣāṇān uttōlya tamāhantum udayacchan kintu yīśu rguptō mantirād bahirgatya tēṣāṁ madhyēna prasthitavān| ");
INSERT INTO saniso_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","tataḥ paraṁ yīśurgacchan mārgamadhyē janmāndhaṁ naram apaśyat| ");
INSERT INTO saniso_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","tataḥ śiṣyāstam apr̥cchan hē gurō narōyaṁ svapāpēna vā svapitrāḥ pāpēnāndhō'jāyata? ");
INSERT INTO saniso_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","tataḥ sa pratyuditavān ētasya vāsya pitrōḥ pāpād ētādr̥śōbhūda iti nahi kintvanēna yathēśvarasya karmma prakāśyatē taddhētōrēva| ");
INSERT INTO saniso_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","dinē tiṣṭhati matprērayituḥ karmma mayā karttavyaṁ yadā kimapi karmma na kriyatē tādr̥śī niśāgacchati| ");
INSERT INTO saniso_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ahaṁ yāvatkālaṁ jagati tiṣṭhāmi tāvatkālaṁ jagatō jyōtiḥsvarūpōsmi| ");
INSERT INTO saniso_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ityukttā bhūmau niṣṭhīvaṁ nikṣipya tēna paṅkaṁ kr̥tavān ");
INSERT INTO saniso_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","paścāt tatpaṅkēna tasyāndhasya nētrē pralipya tamityādiśat gatvā śilōhē 'rthāt prēritanāmni sarasi snāhi| tatōndhō gatvā tatrāsnāt tataḥ prannacakṣu rbhūtvā vyāghuṭyāgāt| ");
INSERT INTO saniso_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","aparañca samīpavāsinō lōkā yē ca taṁ pūrvvamandham apaśyan tē bakttum ārabhanta yōndhalōkō vartmanyupaviśyābhikṣata sa ēvāyaṁ janaḥ kiṁ na bhavati? ");
INSERT INTO saniso_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","kēcidavadan sa ēva kēcidavōcan tādr̥śō bhavati kintu sa svayamabravīt sa ēvāhaṁ bhavāmi| ");
INSERT INTO saniso_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ataēva tē 'pr̥cchan tvaṁ kathaṁ dr̥ṣṭiṁ pāptavān? ");
INSERT INTO saniso_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","tataḥ sōvadad yīśanāmaka ēkō janō mama nayanē paṅkēna pralipya ityājñāpayat śilōhakāsāraṁ gatvā tatra snāhi| tatastatra gatvā mayi snātē dr̥ṣṭimahaṁ labdhavān| ");
INSERT INTO saniso_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","tadā tē 'vadan sa pumān kutra? tēnōkttaṁ nāhaṁ jānāmi| ");
INSERT INTO saniso_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","aparaṁ tasmin pūrvvāndhē janē phirūśināṁ nikaṭam ānītē sati phirūśinōpi tamapr̥cchan kathaṁ dr̥ṣṭiṁ prāptōsi? ");
INSERT INTO saniso_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","tataḥ sa kathitavān sa paṅkēna mama nētrē 'limpat paścād snātvā dr̥ṣṭimalabhē| ");
INSERT INTO saniso_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","kintu yīśu rviśrāmavārē karddamaṁ kr̥tvā tasya nayanē prasannē'karōd itikāraṇāt katipayaphirūśinō'vadan ");
INSERT INTO saniso_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","sa pumān īśvarānna yataḥ sa viśrāmavāraṁ na manyatē| tatōnyē kēcit pratyavadan pāpī pumān kim ētādr̥śam āścaryyaṁ karmma karttuṁ śaknōti? ");
INSERT INTO saniso_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","itthaṁ tēṣāṁ parasparaṁ bhinnavākyatvam abhavat| paścāt tē punarapi taṁ pūrvvāndhaṁ mānuṣam aprākṣuḥ yō janastava cakṣuṣī prasannē kr̥tavān tasmin tvaṁ kiṁ vadasi? sa ukttavān sa bhaviśadvādī| ");
INSERT INTO saniso_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","sa dr̥ṣṭim āptavān iti yihūdīyāstasya dr̥ṣṭiṁ prāptasya janasya pitrō rmukhād aśrutvā na pratyayan| ");
INSERT INTO saniso_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ataēva tē tāvapr̥cchan yuvayō ryaṁ putraṁ janmāndhaṁ vadathaḥ sa kimayaṁ? tarhīdānīṁ kathaṁ draṣṭuṁ śaknōti? ");
INSERT INTO saniso_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","tatastasya pitarau pratyavōcatām ayam āvayōḥ putra ā janērandhaśca tadapyāvāṁ jānīvaḥ ");
INSERT INTO saniso_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","kintvadhunā kathaṁ dr̥ṣṭiṁ prāptavān tadāvāṁ n jānīvaḥ kōsya cakṣuṣī prasannē kr̥tavān tadapi na jānīva ēṣa vayaḥprāpta ēnaṁ pr̥cchata svakathāṁ svayaṁ vakṣyati| ");
INSERT INTO saniso_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","yihūdīyānāṁ bhayāt tasya pitarau vākyamidam avadatāṁ yataḥ kōpi manuṣyō yadi yīśum abhiṣiktaṁ vadati tarhi sa bhajanagr̥hād dūrīkāriṣyatē yihūdīyā iti mantraṇām akurvvan ");
INSERT INTO saniso_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","atastasya pitarau vyāharatām ēṣa vayaḥprāpta ēnaṁ pr̥cchata| ");
INSERT INTO saniso_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","tadā tē punaśca taṁ pūrvvāndham āhūya vyāharan īśvarasya guṇān vada ēṣa manuṣyaḥ pāpīti vayaṁ jānīmaḥ| ");
INSERT INTO saniso_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","tadā sa ukttavān sa pāpī na vēti nāhaṁ jānē pūrvāmandha āsamaham adhunā paśyāmīti mātraṁ jānāmi| ");
INSERT INTO saniso_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","tē punarapr̥cchan sa tvāṁ prati kimakarōt? kathaṁ nētrē prasannē 'karōt? ");
INSERT INTO saniso_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","tataḥ sōvādīd ēkakr̥tvōkathayaṁ yūyaṁ na śr̥ṇutha tarhi kutaḥ punaḥ śrōtum icchatha? yūyamapi kiṁ tasya śiṣyā bhavitum icchatha? ");
INSERT INTO saniso_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","tadā tē taṁ tiraskr̥tya vyāharan tvaṁ tasya śiṣyō vayaṁ mūsāḥ śiṣyāḥ| ");
INSERT INTO saniso_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","mūsāvaktrēṇēśvarō jagāda tajjānīmaḥ kintvēṣa kutratyalōka iti na jānīmaḥ| ");
INSERT INTO saniso_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","sōvadad ēṣa mama lōcanē prasannē 'karōt tathāpi kutratyalōka iti yūyaṁ na jānītha ētad āścaryyaṁ bhavati| ");
INSERT INTO saniso_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","īśvaraḥ pāpināṁ kathāṁ na śr̥ṇōti kintu yō janastasmin bhaktiṁ kr̥tvā tadiṣṭakriyāṁ karōti tasyaiva kathāṁ śr̥ṇōti ētad vayaṁ jānīmaḥ| ");
INSERT INTO saniso_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","kōpi manuṣyō janmāndhāya cakṣuṣī adadāt jagadārambhād ētādr̥śīṁ kathāṁ kōpi kadāpi nāśr̥ṇōt| ");
INSERT INTO saniso_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","asmād ēṣa manuṣyō yadīśvarānnājāyata tarhi kiñcidapīdr̥śaṁ karmma karttuṁ nāśaknōt| ");
INSERT INTO saniso_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","tē vyāharan tvaṁ pāpād ajāyathāḥ kimasmān tvaṁ śikṣayasi? paścāttē taṁ bahirakurvvan| ");
INSERT INTO saniso_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","tadanantaraṁ yihūdīyaiḥ sa bahirakriyata yīśuriti vārttāṁ śrutvā taṁ sākṣāt prāpya pr̥ṣṭavān īśvarasya putrē tvaṁ viśvasiṣi? ");
INSERT INTO saniso_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","tadā sa pratyavōcat hē prabhō sa kō yat tasminnahaṁ viśvasimi? ");
INSERT INTO saniso_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","tatō yīśuḥ kathitavān tvaṁ taṁ dr̥ṣṭavān tvayā sākaṁ yaḥ kathaṁ kathayati saēva saḥ| ");
INSERT INTO saniso_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","tadā hē prabhō viśvasimītyuktvā sa taṁ praṇāmat| ");
INSERT INTO saniso_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","paścād yīśuḥ kathitavān nayanahīnā nayanāni prāpnuvanti nayanavantaścāndhā bhavantītyabhiprāyēṇa jagadāham āgaccham| ");
INSERT INTO saniso_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ētat śrutvā nikaṭasthāḥ katipayāḥ phirūśinō vyāharan vayamapi kimandhāḥ? ");
INSERT INTO saniso_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","tadā yīśuravādīd yadyandhā abhavata tarhi pāpāni nātiṣṭhan kintu paśyāmīti vākyavadanād yuṣmākaṁ pāpāni tiṣṭhanti| ");
INSERT INTO saniso_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ahaṁ yuṣmānatiyathārthaṁ vadāmi, yō janō dvārēṇa na praviśya kēnāpyanyēna mēṣagr̥haṁ praviśati sa ēva stēnō dasyuśca| ");
INSERT INTO saniso_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","yō dvārēṇa praviśati sa ēva mēṣapālakaḥ| ");
INSERT INTO saniso_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","dauvārikastasmai dvāraṁ mōcayati mēṣagaṇaśca tasya vākyaṁ śr̥ṇōti sa nijān mēṣān svasvanāmnāhūya bahiḥ kr̥tvā nayati| ");
INSERT INTO saniso_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","tathā nijān mēṣān bahiḥ kr̥tvā svayaṁ tēṣām agrē gacchati, tatō mēṣāstasya śabdaṁ budhyantē, tasmāt tasya paścād vrajanti| ");
INSERT INTO saniso_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","kintu parasya śabdaṁ na budhyantē tasmāt tasya paścād vrajiṣyanti varaṁ tasya samīpāt palāyiṣyantē| ");
INSERT INTO saniso_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","yīśustēbhya imāṁ dr̥ṣṭāntakathām akathayat kintu tēna kathitakathāyāstātparyyaṁ tē nābudhyanta| ");
INSERT INTO saniso_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","atō yīśuḥ punarakathayat, yuṣmānāhaṁ yathārthataraṁ vyāharāmi, mēṣagr̥hasya dvāram ahamēva| ");
INSERT INTO saniso_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","mayā na praviśya ya āgacchan tē stēnā dasyavaśca kintu mēṣāstēṣāṁ kathā nāśr̥ṇvan| ");
INSERT INTO saniso_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","ahamēva dvārasvarūpaḥ, mayā yaḥ kaścita praviśati sa rakṣāṁ prāpsyati tathā bahirantaśca gamanāgamanē kr̥tvā caraṇasthānaṁ prāpsyati| ");
INSERT INTO saniso_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","yō janastēnaḥ sa kēvalaṁ stainyabadhavināśān karttumēva samāyāti kintvaham āyu rdātum arthāt bāhūlyēna tadēva dātum āgaccham| ");
INSERT INTO saniso_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","ahamēva satyamēṣapālakō yastu satyō mēṣapālakaḥ sa mēṣārthaṁ prāṇatyāgaṁ karōti; ");
INSERT INTO saniso_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","kintu yō janō mēṣapālakō na, arthād yasya mēṣā nijā na bhavanti, ya ētādr̥śō vaitanikaḥ sa vr̥kam āgacchantaṁ dr̥ṣṭvā mējavrajaṁ vihāya palāyatē, tasmād vr̥kastaṁ vrajaṁ dhr̥tvā vikirati| ");
INSERT INTO saniso_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","vaitanikaḥ palāyatē yataḥ sa vētanārthī mēṣārthaṁ na cintayati| ");
INSERT INTO saniso_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","ahamēva satyō mēṣapālakaḥ, pitā māṁ yathā jānāti, ahañca yathā pitaraṁ jānāmi, ");
INSERT INTO saniso_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","tathā nijān mēṣānapi jānāmi, mēṣāśca māṁ jānānti, ahañca mēṣārthaṁ prāṇatyāgaṁ karōmi| ");
INSERT INTO saniso_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","aparañca ētad gr̥hīya mēṣēbhyō bhinnā api mēṣā mama santi tē sakalā ānayitavyāḥ; tē mama śabdaṁ śrōṣyanti tata ēkō vraja ēkō rakṣakō bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","prāṇānahaṁ tyaktvā punaḥ prāṇān grahīṣyāmi, tasmāt pitā mayi snēhaṁ karōti| ");
INSERT INTO saniso_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","kaścijjanō mama prāṇān hantuṁ na śaknōti kintu svayaṁ tān samarpayāmi tān samarpayituṁ punargrahītuñca mama śaktirāstē bhāramimaṁ svapituḥ sakāśāt prāptōham| ");
INSERT INTO saniso_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","asmādupadēśāt punaśca yihūdīyānāṁ madhyē bhinnavākyatā jātā| ");
INSERT INTO saniso_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","tatō bahavō vyāharan ēṣa bhūtagrasta unmattaśca, kuta ētasya kathāṁ śr̥ṇutha? ");
INSERT INTO saniso_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","kēcid avadan ētasya kathā bhūtagrastasya kathāvanna bhavanti, bhūtaḥ kim andhāya cakṣuṣī dātuṁ śaknōti? ");
INSERT INTO saniso_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","śītakālē yirūśālami mandirōtsargaparvvaṇyupasthitē ");
INSERT INTO saniso_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","yīśuḥ sulēmānō niḥsārēṇa gamanāgamanē karōti, ");
INSERT INTO saniso_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ētasmin samayē yihūdīyāstaṁ vēṣṭayitvā vyāharan kati kālān asmākaṁ vicikitsāṁ sthāpayiṣyāmi? yadyabhiṣiktō bhavati tarhi tat spaṣṭaṁ vada| ");
INSERT INTO saniso_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","tadā yīśuḥ pratyavadad aham acakathaṁ kintu yūyaṁ na pratītha, nijapitu rnāmnā yāṁ yāṁ kriyāṁ karōmi sā kriyaiva mama sākṣisvarūpā| ");
INSERT INTO saniso_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","kintvahaṁ pūrvvamakathayaṁ yūyaṁ mama mēṣā na bhavatha, kāraṇādasmān na viśvasitha| ");
INSERT INTO saniso_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","mama mēṣā mama śabdaṁ śr̥ṇvanti tānahaṁ jānāmi tē ca mama paścād gacchanti| ");
INSERT INTO saniso_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ahaṁ tēbhyō'nantāyu rdadāmi, tē kadāpi na naṁkṣyanti kōpi mama karāt tān harttuṁ na śakṣyati| ");
INSERT INTO saniso_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","yō mama pitā tān mahyaṁ dattavān sa sarvvasmāt mahān, kōpi mama pituḥ karāt tān harttuṁ na śakṣyati| ");
INSERT INTO saniso_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ahaṁ pitā ca dvayōrēkatvam| ");
INSERT INTO saniso_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","tatō yihūdīyāḥ punarapi taṁ hantuṁ pāṣāṇān udatōlayan| ");
INSERT INTO saniso_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","yīśuḥ kathitavān pituḥ sakāśād bahūnyuttamakarmmāṇi yuṣmākaṁ prākāśayaṁ tēṣāṁ kasya karmmaṇaḥ kāraṇān māṁ pāṣāṇairāhantum udyatāḥ stha? ");
INSERT INTO saniso_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","yihūdīyāḥ pratyavadan praśastakarmmahētō rna kintu tvaṁ mānuṣaḥ svamīśvaram uktvēśvaraṁ nindasi kāraṇādasmāt tvāṁ pāṣāṇairhanmaḥ| ");
INSERT INTO saniso_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","tadā yīśuḥ pratyuktavān mayā kathitaṁ yūyam īśvarā ētadvacanaṁ yuṣmākaṁ śāstrē likhitaṁ nāsti kiṁ? ");
INSERT INTO saniso_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","tasmād yēṣām uddēśē īśvarasya kathā kathitā tē yadīśvaragaṇā ucyantē dharmmagranthasyāpyanyathā bhavituṁ na śakyaṁ, ");
INSERT INTO saniso_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","tarhyāham īśvarasya putra iti vākyasya kathanāt yūyaṁ pitrābhiṣiktaṁ jagati prēritañca pumāṁsaṁ katham īśvaranindakaṁ vādaya? ");
INSERT INTO saniso_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","yadyahaṁ pituḥ karmma na karōmi tarhi māṁ na pratīta; ");
INSERT INTO saniso_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","kintu yadi karōmi tarhi mayi yuṣmābhiḥ pratyayē na kr̥tē'pi kāryyē pratyayaḥ kriyatāṁ, tatō mayi pitāstīti pitaryyaham asmīti ca kṣātvā viśvasiṣyatha| ");
INSERT INTO saniso_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","tadā tē punarapi taṁ dharttum acēṣṭanta kintu sa tēṣāṁ karēbhyō nistīryya ");
INSERT INTO saniso_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","puna ryarddan adyāstaṭē yatra purvvaṁ yōhan amajjayat tatrāgatya nyavasat| ");
INSERT INTO saniso_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","tatō bahavō lōkāstatsamīpam āgatya vyāharan yōhan kimapyāścaryyaṁ karmma nākarōt kintvasmin manuṣyē yā yaḥ kathā akathayat tāḥ sarvvāḥ satyāḥ; ");
INSERT INTO saniso_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","tatra ca bahavō lōkāstasmin vyaśvasan| ");
INSERT INTO saniso_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","anantaraṁ mariyam tasyā bhaginī marthā ca yasmin vaithanīyāgrāmē vasatastasmin grāmē iliyāsar nāmā pīḍita ēka āsīt| ");
INSERT INTO saniso_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","yā mariyam prabhuṁ sugandhitēlaina marddayitvā svakēśaistasya caraṇau samamārjat tasyā bhrātā sa iliyāsar rōgī| ");
INSERT INTO saniso_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","aparañca hē prabhō bhavān yasmin prīyatē sa ēva pīḍitōstīti kathāṁ kathayitvā tasya bhaginyau prēṣitavatyau| ");
INSERT INTO saniso_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","tadā yīśurimāṁ vārttāṁ śrutvākathayata pīḍēyaṁ maraṇārthaṁ na kintvīśvarasya mahimārtham īśvaraputrasya mahimaprakāśārthañca jātā| ");
INSERT INTO saniso_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","yīśu ryadyapimarthāyāṁ tadbhaginyām iliyāsari cāprīyata, ");
INSERT INTO saniso_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","tathāpi iliyāsaraḥ pīḍāyāḥ kathaṁ śrutvā yatra āsīt tatraiva dinadvayamatiṣṭhat| ");
INSERT INTO saniso_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","tataḥ param sa śiṣyānakathayad vayaṁ puna ryihūdīyapradēśaṁ yāmaḥ| ");
INSERT INTO saniso_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","tatastē pratyavadan, hē gurō svalpadināni gatāni yihūdīyāstvāṁ pāṣāṇai rhantum udyatāstathāpi kiṁ punastatra yāsyasi? ");
INSERT INTO saniso_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","yīśuḥ pratyavadat, ēkasmin dinē kiṁ dvādaśaghaṭikā na bhavanti? kōpi divā gacchan na skhalati yataḥ sa ētajjagatō dīptiṁ prāpnōti| ");
INSERT INTO saniso_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","kintu rātrau gacchan skhalati yatō hētōstatra dīpti rnāsti| ");
INSERT INTO saniso_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","imāṁ kathāṁ kathayitvā sa tānavadad, asmākaṁ bandhuḥ iliyāsar nidritōbhūd idānīṁ taṁ nidrātō jāgarayituṁ gacchāmi| ");
INSERT INTO saniso_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","yīśu rmr̥tau kathāmimāṁ kathitavān kintu viśrāmārthaṁ nidrāyāṁ kathitavān iti jñātvā śiṣyā akathayan, ");
INSERT INTO saniso_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","hē gurō sa yadi nidrāti tarhi bhadramēva| ");
INSERT INTO saniso_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","tadā yīśuḥ spaṣṭaṁ tān vyāharat, iliyāsar amriyata; ");
INSERT INTO saniso_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","kintu yūyaṁ yathā pratītha tadarthamahaṁ tatra na sthitavān ityasmād yuṣmannimittam āhlāditōhaṁ, tathāpi tasya samīpē yāma| ");
INSERT INTO saniso_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","tadā thōmā yaṁ didumaṁ vadanti sa saṅginaḥ śiṣyān avadad vayamapi gatvā tēna sārddhaṁ mriyāmahai| ");
INSERT INTO saniso_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","yīśustatrōpasthāya iliyāsaraḥ śmaśānē sthāpanāt catvāri dināni gatānīti vārttāṁ śrutavān| ");
INSERT INTO saniso_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","vaithanīyā yirūśālamaḥ samīpasthā krōśaikamātrāntaritā; ");
INSERT INTO saniso_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","tasmād bahavō yihūdīyā marthāṁ mariyamañca bhyātr̥śōkāpannāṁ sāntvayituṁ tayōḥ samīpam āgacchan| ");
INSERT INTO saniso_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","marthā yīśōrāgamanavārtāṁ śrutvaiva taṁ sākṣād akarōt kintu mariyam gēha upaviśya sthitā| ");
INSERT INTO saniso_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","tadā marthā yīśumavādat, hē prabhō yadi bhavān atrāsthāsyat tarhi mama bhrātā nāmariṣyat| ");
INSERT INTO saniso_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","kintvidānīmapi yad īśvarē prārthayiṣyatē īśvarastad dāsyatīti jānē'haṁ| ");
INSERT INTO saniso_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","yīśuravādīt tava bhrātā samutthāsyati| ");
INSERT INTO saniso_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","marthā vyāharat śēṣadivasē sa utthānasamayē prōtthāsyatīti jānē'haṁ| ");
INSERT INTO saniso_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","tadā yīśuḥ kathitavān ahamēva utthāpayitā jīvayitā ca yaḥ kaścana mayi viśvasiti sa mr̥tvāpi jīviṣyati; ");
INSERT INTO saniso_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","yaḥ kaścana ca jīvan mayi viśvasiti sa kadāpi na mariṣyati, asyāṁ kathāyāṁ kiṁ viśvasiṣi? ");
INSERT INTO saniso_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","sāvadat prabhō yasyāvataraṇāpēkṣāsti bhavān saēvābhiṣiktta īśvaraputra iti viśvasimi| ");
INSERT INTO saniso_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","iti kathāṁ kathayitvā sā gatvā svāṁ bhaginīṁ mariyamaṁ guptamāhūya vyāharat gururupatiṣṭhati tvāmāhūyati ca| ");
INSERT INTO saniso_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","kathāmimāṁ śrutvā sā tūrṇam utthāya tasya samīpam agacchat| ");
INSERT INTO saniso_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","yīśu rgrāmamadhyaṁ na praviśya yatra marthā taṁ sākṣād akarōt tatra sthitavān| ");
INSERT INTO saniso_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","yē yihūdīyā mariyamā sākaṁ gr̥hē tiṣṭhantastām asāntvayana tē tāṁ kṣipram utthāya gacchantiṁ vilōkya vyāharan, sa śmaśānē rōdituṁ yāti, ityuktvā tē tasyāḥ paścād agacchan| ");
INSERT INTO saniso_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","yatra yīśuratiṣṭhat tatra mariyam upasthāya taṁ dr̥ṣṭvā tasya caraṇayōḥ patitvā vyāharat hē prabhō yadi bhavān atrāsthāsyat tarhi mama bhrātā nāmariṣyat| ");
INSERT INTO saniso_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","yīśustāṁ tasyāḥ saṅginō yihūdīyāṁśca rudatō vilōkya śōkārttaḥ san dīrghaṁ niśvasya kathitavān taṁ kutrāsthāpayata? ");
INSERT INTO saniso_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","tē vyāharan, hē prabhō bhavān āgatya paśyatu| ");
INSERT INTO saniso_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","yīśunā kranditaṁ| ");
INSERT INTO saniso_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ataēva yihūdīyā avadan, paśyatāyaṁ tasmin kidr̥g apriyata| ");
INSERT INTO saniso_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","tēṣāṁ kēcid avadan yōndhāya cakṣuṣī dattavān sa kim asya mr̥tyuṁ nivārayituṁ nāśaknōt? ");
INSERT INTO saniso_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","tatō yīśuḥ punarantardīrghaṁ niśvasya śmaśānāntikam agacchat| tat śmaśānam ēkaṁ gahvaraṁ tanmukhē pāṣāṇa ēka āsīt| ");
INSERT INTO saniso_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","tadā yīśuravadad ēnaṁ pāṣāṇam apasārayata, tataḥ pramītasya bhaginī marthāvadat prabhō, adhunā tatra durgandhō jātaḥ, yatōdya catvāri dināni śmaśānē sa tiṣṭhati| ");
INSERT INTO saniso_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","tadā yīśuravādīt, yadi viśvasiṣi tarhīśvarasya mahimaprakāśaṁ drakṣyasi kathāmimāṁ kiṁ tubhyaṁ nākathayaṁ? ");
INSERT INTO saniso_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","tadā mr̥tasya śmaśānāt pāṣāṇō'pasāritē yīśurūrdvvaṁ paśyan akathayat, hē pita rmama nēvēsanam aśr̥ṇōḥ kāraṇādasmāt tvāṁ dhanyaṁ vadāmi| ");
INSERT INTO saniso_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","tvaṁ satataṁ śr̥ṇōṣi tadapyahaṁ jānāmi, kintu tvaṁ māṁ yat prairayastad yathāsmin sthānē sthitā lōkā viśvasanti tadartham idaṁ vākyaṁ vadāmi| ");
INSERT INTO saniso_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","imāṁ kathāṁ kathayitvā sa prōccairāhvayat, hē iliyāsar bahirāgaccha| ");
INSERT INTO saniso_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","tataḥ sa pramītaḥ śmaśānavastrai rbaddhahastapādō gātramārjanavāsasā baddhamukhaśca bahirāgacchat| yīśuruditavān bandhanāni mōcayitvā tyajatainaṁ| ");
INSERT INTO saniso_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","mariyamaḥ samīpam āgatā yē yihūdīyalōkāstadā yīśōrētat karmmāpaśyan tēṣāṁ bahavō vyaśvasan, ");
INSERT INTO saniso_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","kintu kēcidanyē phirūśināṁ samīpaṁ gatvā yīśōrētasya karmmaṇō vārttām avadan| ");
INSERT INTO saniso_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","tataḥ paraṁ pradhānayājakāḥ phirūśināśca sabhāṁ kr̥tvā vyāharan vayaṁ kiṁ kurmmaḥ? ēṣa mānavō bahūnyāścaryyakarmmāṇi karōti| ");
INSERT INTO saniso_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","yadīdr̥śaṁ karmma karttuṁ na vārayāmastarhi sarvvē lōkāstasmin viśvasiṣyanti rōmilōkāścāgatyāsmākam anayā rājadhānyā sārddhaṁ rājyam āchētsyanti| ");
INSERT INTO saniso_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","tadā tēṣāṁ kiyaphānāmā yastasmin vatsarē mahāyājakapadē nyayujyata sa pratyavadad yūyaṁ kimapi na jānītha; ");
INSERT INTO saniso_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","samagradēśasya vināśatōpi sarvvalōkārtham ēkasya janasya maraṇam asmākaṁ maṅgalahētukam ētasya vivēcanāmapi na kurutha| ");
INSERT INTO saniso_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","ētāṁ kathāṁ sa nijabuddhyā vyāharad iti na, ");
INSERT INTO saniso_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","kintu yīśūstaddēśīyānāṁ kāraṇāt prāṇān tyakṣyati, diśi diśi vikīrṇān īśvarasya santānān saṁgr̥hyaikajātiṁ kariṣyati ca, tasmin vatsarē kiyaphā mahāyājakatvapadē niyuktaḥ san idaṁ bhaviṣyadvākyaṁ kathitavān| ");
INSERT INTO saniso_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","taddinamārabhya tē kathaṁ taṁ hantuṁ śaknuvantīti mantraṇāṁ karttuṁ prārēbhirē| ");
INSERT INTO saniso_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ataēva yihūdīyānāṁ madhyē yīśuḥ saprakāśaṁ gamanāgamanē akr̥tvā tasmād gatvā prāntarasya samīpasthāyipradēśasyēphrāyim nāmni nagarē śiṣyaiḥ sākaṁ kālaṁ yāpayituṁ prārēbhē| ");
INSERT INTO saniso_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","anantaraṁ yihūdīyānāṁ nistārōtsavē nikaṭavarttini sati tadutsavāt pūrvvaṁ svān śucīn karttuṁ bahavō janā grāmēbhyō yirūśālam nagaram āgacchan, ");
INSERT INTO saniso_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","yīśōranvēṣaṇaṁ kr̥tvā mandirē daṇḍāyamānāḥ santaḥ parasparaṁ vyāharan, yuṣmākaṁ kīdr̥śō bōdhō jāyatē? sa kim utsavē'smin atrāgamiṣyati? ");
INSERT INTO saniso_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","sa ca kutrāsti yadyētat kaścid vētti tarhi darśayatu pradhānayājakāḥ phirūśinaśca taṁ dharttuṁ pūrvvam imām ājñāṁ prācārayan| ");
INSERT INTO saniso_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","nistārōtsavāt pūrvvaṁ dinaṣaṭkē sthitē yīśu ryaṁ pramītam iliyāsaraṁ śmaśānād udasthāparat tasya nivāsasthānaṁ baithaniyāgrāmam āgacchat| ");
INSERT INTO saniso_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","tatra tadarthaṁ rajanyāṁ bhōjyē kr̥tē marthā paryyavēṣayad iliyāsar ca tasya saṅgibhiḥ sārddhaṁ bhōjanāsana upāviśat| ");
INSERT INTO saniso_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","tadā mariyam arddhasēṭakaṁ bahumūlyaṁ jaṭāmāṁsīyaṁ tailam ānīya yīśōścaraṇayō rmarddayitvā nijakēśa rmārṣṭum ārabhata; tadā tailasya parimalēna gr̥ham āmōditam abhavat| ");
INSERT INTO saniso_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","yaḥ śimōnaḥ putra riṣkariyōtīyō yihūdānāmā yīśuṁ parakarēṣu samarpayiṣyati sa śiṣyastadā kathitavān, ");
INSERT INTO saniso_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","ētattailaṁ tribhiḥ śatai rmudrāpadai rvikrītaṁ sad daridrēbhyaḥ kutō nādīyata? ");
INSERT INTO saniso_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","sa daridralōkārtham acintayad iti na, kintu sa caura ēvaṁ tannikaṭē mudrāsampuṭakasthityā tanmadhyē yadatiṣṭhat tadapāharat tasmāt kāraṇād imāṁ kathāmakathayat| ");
INSERT INTO saniso_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","tadā yīśurakathayad ēnāṁ mā vāraya sā mama śmaśānasthāpanadinārthaṁ tadarakṣayat| ");
INSERT INTO saniso_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","daridrā yuṣmākaṁ sannidhau sarvvadā tiṣṭhanti kintvahaṁ sarvvadā yuṣmākaṁ sannidhau na tiṣṭhāmi| ");
INSERT INTO saniso_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","tataḥ paraṁ yīśustatrāstīti vārttāṁ śrutvā bahavō yihūdīyāstaṁ śmaśānādutthāpitam iliyāsarañca draṣṭuṁ tat sthānam āgacchana| ");
INSERT INTO saniso_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","tadā pradhānayājakāstam iliyāsaramapi saṁharttum amantrayan ; ");
INSERT INTO saniso_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","yatastēna bahavō yihūdīyā gatvā yīśau vyaśvasan| ");
INSERT INTO saniso_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","anantaraṁ yīśu ryirūśālam nagaram āgacchatīti vārttāṁ śrutvā parē'hani utsavāgatā bahavō lōkāḥ ");
INSERT INTO saniso_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","kharjjūrapatrādyānīya taṁ sākṣāt karttuṁ bahirāgatya jaya jayēti vācaṁ prōccai rvaktum ārabhanta, isrāyēlō yō rājā paramēśvarasya nāmnāgacchati sa dhanyaḥ| ");
INSERT INTO saniso_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","tadā \"hē siyōnaḥ kanyē mā bhaiṣīḥ paśyāyaṁ tava rājā garddabhaśāvakam āruhyāgacchati\" ");
INSERT INTO saniso_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","iti śāstrīyavacanānusārēṇa yīśurēkaṁ yuvagarddabhaṁ prāpya taduparyyārōhat| ");
INSERT INTO saniso_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","asyāḥ ghaṭanāyāstātparyyaṁ śiṣyāḥ prathamaṁ nābudhyanta, kintu yīśau mahimānaṁ prāptē sati vākyamidaṁ tasmina akathyata lōkāśca tampratīttham akurvvan iti tē smr̥tavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","sa iliyāsaraṁ śmaśānād āgantum āhvatavān śmaśānāñca udasthāpayad yē yē lōkāstatkarmya sākṣād apaśyan tē pramāṇaṁ dātum ārabhanta| ");
INSERT INTO saniso_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","sa ētādr̥śam adbhutaṁ karmmakarōt tasya janaśrutē rlōkāstaṁ sākṣāt karttum āgacchan| ");
INSERT INTO saniso_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","tataḥ phirūśinaḥ parasparaṁ vaktum ārabhanta yuṣmākaṁ sarvvāścēṣṭā vr̥thā jātāḥ, iti kiṁ yūyaṁ na budhyadhvē? paśyata sarvvē lōkāstasya paścādvarttinōbhavan| ");
INSERT INTO saniso_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","bhajanaṁ karttum utsavāgatānāṁ lōkānāṁ katipayā janā anyadēśīyā āsan , ");
INSERT INTO saniso_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","tē gālīlīyabaitsaidānivāsinaḥ philipasya samīpam āgatya vyāharan hē mahēccha vayaṁ yīśuṁ draṣṭum icchāmaḥ| ");
INSERT INTO saniso_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","tataḥ philipō gatvā āndriyam avadat paścād āndriyaphilipau yīśavē vārttām akathayatāṁ| ");
INSERT INTO saniso_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","tadā yīśuḥ pratyuditavān mānavasutasya mahimaprāptisamaya upasthitaḥ| ");
INSERT INTO saniso_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ahaṁ yuṣmānatiyathārthaṁ vadāmi, dhānyabījaṁ mr̥ttikāyāṁ patitvā yadi na mr̥yatē tarhyēkākī tiṣṭhati kintu yadi mr̥yatē tarhi bahuguṇaṁ phalaṁ phalati| ");
INSERT INTO saniso_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","yō janēा nijaprāṇān priyān jānāti sa tān hārayiṣyati kintu yēा jana ihalōkē nijaprāṇān apriyān jānāti sēाnantāyuḥ prāptuṁ tān rakṣiṣyati| ");
INSERT INTO saniso_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","kaścid yadi mama sēvakō bhavituṁ vāñchati tarhi sa mama paścādgāmī bhavatu, tasmād ahaṁ yatra tiṣṭhāmi mama sēvakēाpi tatra sthāsyati; yō janō māṁ sēvatē mama pitāpi taṁ sammaṁsyatē| ");
INSERT INTO saniso_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","sāmprataṁ mama prāṇā vyākulā bhavanti, tasmād hē pitara ētasmāt samayān māṁ rakṣa, ityahaṁ kiṁ prārthayiṣyē? kintvaham ētatsamayārtham avatīrṇavān| ");
INSERT INTO saniso_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","hē pita: svanāmnō mahimānaṁ prakāśaya; tanaiva svanāmnō mahimānam ahaṁ prākāśayaṁ punarapi prakāśayiṣyāmi, ēṣā gagaṇīyā vāṇī tasmin samayē'jāyata| ");
INSERT INTO saniso_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","tacśrutvā samīpasthalōkānāṁ kēcid avadan mēghō'garjīt, kēcid avadan svargīyadūtō'nēna saha kathāmacakathat| ");
INSERT INTO saniso_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","tadā yīśuḥ pratyavādīt, madarthaṁ śabdōyaṁ nābhūt yuṣmadarthamēvābhūt| ");
INSERT INTO saniso_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","adhunā jagatōsya vicāra: sampatsyatē, adhunāsya jagata: patī rājyāt cyōṣyati| ");
INSERT INTO saniso_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","yadyaī pr̥thivyā ūrdvvē prōtthāpitōsmi tarhi sarvvān mānavān svasamīpam ākarṣiṣyāmi| ");
INSERT INTO saniso_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","kathaṁ tasya mr̥ti rbhaviṣyati, ētad bōdhayituṁ sa imāṁ kathām akathayat| ");
INSERT INTO saniso_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","tadā lōkā akathayan sōbhiṣiktaḥ sarvvadā tiṣṭhatīti vyavasthāgranthē śrutam asmābhiḥ, tarhi manuṣyaputraḥ prōtthāpitō bhaviṣyatīti vākyaṁ kathaṁ vadasi? manuṣyaputrōyaṁ kaḥ? ");
INSERT INTO saniso_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","tadā yīśurakathāyad yuṣmābhiḥ sārddham alpadināni jyōtirāstē, yathā yuṣmān andhakārō nācchādayati tadarthaṁ yāvatkālaṁ yuṣmābhiḥ sārddhaṁ jyōtistiṣṭhati tāvatkālaṁ gacchata; yō janō'ndhakārē gacchati sa kutra yātīti na jānāti| ");
INSERT INTO saniso_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ataēva yāvatkālaṁ yuṣmākaṁ nikaṭē jyōtirāstē tāvatkālaṁ jyōtīrūpasantānā bhavituṁ jyōtiṣi viśvasita; imāṁ kathāṁ kathayitvā yīśuḥ prasthāya tēbhyaḥ svaṁ guptavān| ");
INSERT INTO saniso_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","yadyapi yīśustēṣāṁ samakṣam ētāvadāścaryyakarmmāṇi kr̥tavān tathāpi tē tasmin na vyaśvasan| ");
INSERT INTO saniso_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ataēva kaḥ pratyēti susaṁvādaṁ parēśāsmat pracāritaṁ? prakāśatē parēśasya hastaḥ kasya ca sannidhau? yiśayiyabhaviṣyadvādinā yadētad vākyamuktaṁ tat saphalam abhavat| ");
INSERT INTO saniso_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","tē pratyētuṁ nāśankuvan tasmin yiśayiyabhaviṣyadvādi punaravādīd, ");
INSERT INTO saniso_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","yadā, \"tē nayanai rna paśyanti buddhibhiśca na budhyantē tai rmanaḥsu parivarttitēṣu ca tānahaṁ yathā svasthān na karōmi tathā sa tēṣāṁ lōcanānyandhāni kr̥tvā tēṣāmantaḥkaraṇāni gāḍhāni kariṣyati|\" ");
INSERT INTO saniso_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","yiśayiyō yadā yīśō rmahimānaṁ vilōkya tasmin kathāmakathayat tadā bhaviṣyadvākyam īdr̥śaṁ prakāśayat| ");
INSERT INTO saniso_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","tathāpyadhipatināṁ bahavastasmin pratyāyan| kintu phirūśinastān bhajanagr̥hād dūrīkurvvantīti bhayāt tē taṁ na svīkr̥tavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","yata īśvarasya praśaṁsātō mānavānāṁ praśaṁsāyāṁ tē'priyanta| ");
INSERT INTO saniso_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","tadā yīśuruccaiḥkāram akathayad yō janō mayi viśvasiti sa kēvalē mayi viśvasitīti na, sa matprērakē'pi viśvasiti| ");
INSERT INTO saniso_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","yō janō māṁ paśyati sa matprērakamapi paśyati| ");
INSERT INTO saniso_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","yō janō māṁ pratyēti sa yathāndhakārē na tiṣṭhati tadartham ahaṁ jyōtiḥsvarūpō bhūtvā jagatyasmin avatīrṇavān| ");
INSERT INTO saniso_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","mama kathāṁ śrutvā yadi kaścin na viśvasiti tarhi tamahaṁ dōṣiṇaṁ na karōmi, yatō hētō rjagatō janānāṁ dōṣān niścitān karttuṁ nāgatya tān paricātum āgatōsmi| ");
INSERT INTO saniso_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","yaḥ kaścin māṁ na śraddhāya mama kathaṁ na gr̥hlāti, anyastaṁ dōṣiṇaṁ kariṣyati vastutastu yāṁ kathāmaham acakathaṁ sā kathā caramē'nhi taṁ dōṣiṇaṁ kariṣyati| ");
INSERT INTO saniso_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","yatō hētōrahaṁ svataḥ kimapi na kathayāmi, kiṁ kiṁ mayā kathayitavyaṁ kiṁ samupadēṣṭavyañca iti matprērayitā pitā māmājñāpayat| ");
INSERT INTO saniso_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","tasya sājñā anantāyurityahaṁ jānāmi, ataēvāhaṁ yat kathayāmi tat pitā yathājñāpayat tathaiva kathayāmyaham| ");
INSERT INTO saniso_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","nistārōtsavasya kiñcitkālāt pūrvvaṁ pr̥thivyāḥ pituḥ samīpagamanasya samayaḥ sannikarṣōbhūd iti jñātvā yīśurāprathamād yēṣu jagatpravāsiṣvātmīyalōkēṣa prēma karōti sma tēṣu śēṣaṁ yāvat prēma kr̥tavān| ");
INSERT INTO saniso_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","pitā tasya hastē sarvvaṁ samarpitavān svayam īśvarasya samīpād āgacchad īśvarasya samīpaṁ yāsyati ca, sarvvāṇyētāni jñātvā rajanyāṁ bhōjanē sampūrṇē sati, ");
INSERT INTO saniso_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","yadā śaitān taṁ parahastēṣu samarpayituṁ śimōnaḥ putrasya īṣkāriyōtiyasya yihūdā antaḥkaraṇē kupravr̥ttiṁ samārpayat, ");
INSERT INTO saniso_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","tadā yīśu rbhōjanāsanād utthāya gātravastraṁ mōcayitvā gātramārjanavastraṁ gr̥hītvā tēna svakaṭim abadhnāt, ");
INSERT INTO saniso_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","paścād ēkapātrē jalam abhiṣicya śiṣyāṇāṁ pādān prakṣālya tēna kaṭibaddhagātramārjanavāsasā mārṣṭuṁ prārabhata| ");
INSERT INTO saniso_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","tataḥ śimōnpitarasya samīpamāgatē sa uktavān hē prabhō bhavān kiṁ mama pādau prakṣālayiṣyati? ");
INSERT INTO saniso_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","yīśuruditavān ahaṁ yat karōmi tat samprati na jānāsi kintu paścāj jñāsyasi| ");
INSERT INTO saniso_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","tataḥ pitaraḥ kathitavān bhavān kadāpi mama pādau na prakṣālayiṣyati| yīśurakathayad yadi tvāṁ na prakṣālayē tarhi mayi tava kōpyaṁśō nāsti| ");
INSERT INTO saniso_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","tadā śimōnpitaraḥ kathitavān hē prabhō tarhi kēvalapādau na, mama hastau śiraśca prakṣālayatu| ");
INSERT INTO saniso_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","tatō yīśuravadad yō janō dhautastasya sarvvāṅgapariṣkr̥tatvāt pādau vinānyāṅgasya prakṣālanāpēkṣā nāsti| yūyaṁ pariṣkr̥tā iti satyaṁ kintu na sarvvē, ");
INSERT INTO saniso_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","yatō yō janastaṁ parakarēṣu samarpayiṣyati taṁ sa jñātavāna; ataēva yūyaṁ sarvvē na pariṣkr̥tā imāṁ kathāṁ kathitavān| ");
INSERT INTO saniso_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","itthaṁ yīśustēṣāṁ pādān prakṣālya vastraṁ paridhāyāsanē samupaviśya kathitavān ahaṁ yuṣmān prati kiṁ karmmākārṣaṁ jānītha? ");
INSERT INTO saniso_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","yūyaṁ māṁ guruṁ prabhuñca vadatha tat satyamēva vadatha yatōhaṁ saēva bhavāmi| ");
INSERT INTO saniso_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","yadyahaṁ prabhu rguruśca san yuṣmākaṁ pādān prakṣālitavān tarhi yuṣmākamapi parasparaṁ pādaprakṣālanam ucitam| ");
INSERT INTO saniso_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","ahaṁ yuṣmān prati yathā vyavāharaṁ yuṣmān tathā vyavaharttum ēkaṁ panthānaṁ darśitavān| ");
INSERT INTO saniso_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","ahaṁ yuṣmānatiyathārthaṁ vadāmi, prabhō rdāsō na mahān prērakācca prēritō na mahān| ");
INSERT INTO saniso_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","imāṁ kathāṁ viditvā yadi tadanusārataḥ karmmāṇi kurutha tarhi yūyaṁ dhanyā bhaviṣyatha| ");
INSERT INTO saniso_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","sarvvēṣu yuṣmāsu kathāmimāṁ kathayāmi iti na, yē mama manōnītāstānahaṁ jānāmi, kintu mama bhakṣyāṇi yō bhuṅktē matprāṇaprātikūlyataḥ| utthāpayati pādasya mūlaṁ sa ēṣa mānavaḥ|yadētad dharmmapustakasya vacanaṁ tadanusārēṇāvaśyaṁ ghaṭiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","ahaṁ sa jana ityatra yathā yuṣmākaṁ viśvāsō jāyatē tadarthaṁ ētādr̥śaghaṭanāt pūrvvam ahamidānīṁ yuṣmabhyamakathayam| ");
INSERT INTO saniso_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","ahaṁ yuṣmānatīva yathārthaṁ vadāmi, mayā prēritaṁ janaṁ yō gr̥hlāti sa māmēva gr̥hlāti yaśca māṁ gr̥hlāti sa matprērakaṁ gr̥hlāti| ");
INSERT INTO saniso_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ētāṁ kathāṁ kathayitvā yīśu rduḥkhī san pramāṇaṁ dattvā kathitavān ahaṁ yuṣmānatiyathārthaṁ vadāmi yuṣmākam ēkō janō māṁ parakarēṣu samarpayiṣyati| ");
INSERT INTO saniso_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","tataḥ sa kamuddiśya kathāmētāṁ kathitavān ityatra sandigdhāḥ śiṣyāḥ parasparaṁ mukhamālōkayituṁ prārabhanta| ");
INSERT INTO saniso_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","tasmin samayē yīśu ryasmin aprīyata sa śiṣyastasya vakṣaḥsthalam avālambata| ");
INSERT INTO saniso_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","śimōnpitarastaṁ saṅkētēnāvadat, ayaṁ kamuddiśya kathāmētām kathayatīti pr̥ccha| ");
INSERT INTO saniso_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","tadā sa yīśō rvakṣaḥsthalam avalambya pr̥ṣṭhavān, hē prabhō sa janaḥ kaḥ? ");
INSERT INTO saniso_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","tatō yīśuḥ pratyavadad ēkakhaṇḍaṁ pūpaṁ majjayitvā yasmai dāsyāmi saēva saḥ; paścāt pūpakhaṇḍamēkaṁ majjayitvā śimōnaḥ putrāya īṣkariyōtīyāya yihūdai dattavān| ");
INSERT INTO saniso_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","tasmin dattē sati śaitān tamāśrayat; tadā yīśustam avadat tvaṁ yat kariṣyasi tat kṣipraṁ kuru| ");
INSERT INTO saniso_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","kintu sa yēnāśayēna tāṁ kathāmakathāyat tam upaviṣṭalōkānāṁ kōpi nābudhyata; ");
INSERT INTO saniso_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","kintu yihūdāḥ samīpē mudrāsampuṭakasthitēḥ kēcid ittham abudhyanta pārvvaṇāsādanārthaṁ kimapi dravyaṁ krētuṁ vā daridrēbhyaḥ kiñcid vitarituṁ kathitavān| ");
INSERT INTO saniso_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","tadā pūpakhaṇḍagrahaṇāt paraṁ sa tūrṇaṁ bahiragacchat; rātriśca samupasyitā| ");
INSERT INTO saniso_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","yihūdē bahirgatē yīśurakathayad idānīṁ mānavasutasya mahimā prakāśatē tēnēśvarasyāpi mahimā prakāśatē| ");
INSERT INTO saniso_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","yadi tēnēśvarasya mahimā prakāśatē tarhīśvarōpi svēna tasya mahimānaṁ prakāśayiṣyati tūrṇamēva prakāśayiṣyati| ");
INSERT INTO saniso_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","hē vatsā ahaṁ yuṣmābhiḥ sārddhaṁ kiñcitkālamātram āsē, tataḥ paraṁ māṁ mr̥gayiṣyadhvē kintvahaṁ yatsthānaṁ yāmi tatsthānaṁ yūyaṁ gantuṁ na śakṣyatha, yāmimāṁ kathāṁ yihūdīyēbhyaḥ kathitavān tathādhunā yuṣmabhyamapi kathayāmi| ");
INSERT INTO saniso_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","yūyaṁ parasparaṁ prīyadhvam ahaṁ yuṣmāsu yathā prīyē yūyamapi parasparam tathaiva prīyadhvaṁ, yuṣmān imāṁ navīnām ājñām ādiśāmi| ");
INSERT INTO saniso_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","tēnaiva yadi parasparaṁ prīyadhvē tarhi lakṣaṇēnānēna yūyaṁ mama śiṣyā iti sarvvē jñātuṁ śakṣyanti| ");
INSERT INTO saniso_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","śimōnapitaraḥ pr̥ṣṭhavān hē prabhō bhavān kutra yāsyati? tatō yīśuḥ pratyavadat, ahaṁ yatsthānaṁ yāmi tatsthānaṁ sāmprataṁ mama paścād gantuṁ na śaknōṣi kintu paścād gamiṣyasi| ");
INSERT INTO saniso_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","tadā pitaraḥ pratyuditavān, hē prabhō sāmprataṁ kutō hētōstava paścād gantuṁ na śaknōmi? tvadarthaṁ prāṇān dātuṁ śaknōmi| ");
INSERT INTO saniso_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","tatō yīśuḥ pratyuktavān mannimittaṁ kiṁ prāṇān dātuṁ śaknōṣi? tvāmahaṁ yathārthaṁ vadāmi, kukkuṭaravaṇāt pūrvvaṁ tvaṁ tri rmām apahnōṣyasē| ");
INSERT INTO saniso_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","manōduḥkhinō mā bhūta; īśvarē viśvasita mayi ca viśvasita| ");
INSERT INTO saniso_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","mama pitu gr̥hē bahūni vāsasthāni santi nō cēt pūrvvaṁ yuṣmān ajñāpayiṣyaṁ yuṣmadarthaṁ sthānaṁ sajjayituṁ gacchāmi| ");
INSERT INTO saniso_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","yadi gatvāhaṁ yuṣmannimittaṁ sthānaṁ sajjayāmi tarhi panarāgatya yuṣmān svasamīpaṁ nēṣyāmi, tatō yatrāhaṁ tiṣṭhāmi tatra yūyamapi sthāsyatha| ");
INSERT INTO saniso_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ahaṁ yatsthānaṁ brajāmi tatsthānaṁ yūyaṁ jānītha tasya panthānamapi jānītha| ");
INSERT INTO saniso_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","tadā thōmā avadat, hē prabhō bhavān kutra yāti tadvayaṁ na jānīmaḥ, tarhi kathaṁ panthānaṁ jñātuṁ śaknumaḥ? ");
INSERT INTO saniso_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","yīśurakathayad ahamēva satyajīvanarūpapathō mayā na gantā kōpi pituḥ samīpaṁ gantuṁ na śaknōti| ");
INSERT INTO saniso_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","yadi mām ajñāsyata tarhi mama pitaramapyajñāsyata kintvadhunātastaṁ jānītha paśyatha ca| ");
INSERT INTO saniso_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","tadā philipaḥ kathitavān, hē prabhō pitaraṁ darśaya tasmādasmākaṁ yathēṣṭaṁ bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","tatō yīśuḥ pratyāvādīt, hē philipa yuṣmābhiḥ sārddham ētāvaddināni sthitamapi māṁ kiṁ na pratyabhijānāsi? yō janō mām apaśyat sa pitaramapyapaśyat tarhi pitaram asmān darśayēti kathāṁ kathaṁ kathayasi? ");
INSERT INTO saniso_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ahaṁ pitari tiṣṭhāmi pitā mayi tiṣṭhatīti kiṁ tvaṁ na pratyaṣi? ahaṁ yadvākyaṁ vadāmi tat svatō na vadāmi kintu yaḥ pitā mayi virājatē sa ēva sarvvakarmmāṇi karāti| ");
INSERT INTO saniso_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ataēva pitaryyahaṁ tiṣṭhāmi pitā ca mayi tiṣṭhati mamāsyāṁ kathāyāṁ pratyayaṁ kuruta, nō cēt karmmahētōḥ pratyayaṁ kuruta| ");
INSERT INTO saniso_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","ahaṁ yuṣmānatiyathārthaṁ vadāmi, yō janō mayi viśvasiti sōhamiva karmmāṇi kariṣyati varaṁ tatōpi mahākarmmāṇi kariṣyati yatō hētōrahaṁ pituḥ samīpaṁ gacchāmi| ");
INSERT INTO saniso_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","yathā putrēṇa pitu rmahimā prakāśatē tadarthaṁ mama nāma prōcya yat prārthayiṣyadhvē tat saphalaṁ kariṣyāmi| ");
INSERT INTO saniso_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","yadi mama nāmnā yat kiñcid yācadhvē tarhi tadahaṁ sādhayiṣyāmi| ");
INSERT INTO saniso_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","yadi mayi prīyadhvē tarhi mamājñāḥ samācarata| ");
INSERT INTO saniso_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","tatō mayā pituḥ samīpē prārthitē pitā nirantaraṁ yuṣmābhiḥ sārddhaṁ sthātum itaramēkaṁ sahāyam arthāt satyamayam ātmānaṁ yuṣmākaṁ nikaṭaṁ prēṣayiṣyati| ");
INSERT INTO saniso_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ētajjagatō lōkāstaṁ grahītuṁ na śaknuvanti yatastē taṁ nāpaśyan nājanaṁśca kintu yūyaṁ jānītha yatō hētōḥ sa yuṣmākamanta rnivasati yuṣmākaṁ madhyē sthāsyati ca| ");
INSERT INTO saniso_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","ahaṁ yuṣmān anāthān kr̥tvā na yāsyāmi punarapi yuṣmākaṁ samīpam āgamiṣyāmi| ");
INSERT INTO saniso_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","kiyatkālarat param asya jagatō lōkā māṁ puna rna drakṣyanti kintu yūyaṁ drakṣyatha;ahaṁ jīviṣyāmi tasmāt kāraṇād yūyamapi jīviṣyatha| ");
INSERT INTO saniso_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","pitaryyahamasmi mayi ca yūyaṁ stha, tathāhaṁ yuṣmāsvasmi tadapi tadā jñāsyatha| ");
INSERT INTO saniso_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","yō janō mamājñā gr̥hītvā tā ācarati saēva mayi prīyatē; yō janaśca mayi prīyatē saēva mama pituḥ priyapātraṁ bhaviṣyati, tathāhamapi tasmin prītvā tasmai svaṁ prakāśayiṣyāmi| ");
INSERT INTO saniso_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","tadā īṣkariyōtīyād anyō yihūdāstamavadat, hē prabhō bhavān jagatō lōkānāṁ sannidhau prakāśitō na bhūtvāsmākaṁ sannidhau kutaḥ prakāśitō bhaviṣyati? ");
INSERT INTO saniso_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","tatō yīśuḥ pratyuditavān, yō janō mayi prīyatē sa mamājñā api gr̥hlāti, tēna mama pitāpi tasmin prēṣyatē, āvāñca tannikaṭamāgatya tēna saha nivatsyāvaḥ| ");
INSERT INTO saniso_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","yō janō mayi na prīyatē sa mama kathā api na gr̥hlāti punaśca yāmimāṁ kathāṁ yūyaṁ śr̥ṇutha sā kathā kēvalasya mama na kintu mama prērakō yaḥ pitā tasyāpi kathā| ");
INSERT INTO saniso_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","idānīṁ yuṣmākaṁ nikaṭē vidyamānōham ētāḥ sakalāḥ kathāḥ kathayāmi| ");
INSERT INTO saniso_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","kintvitaḥ paraṁ pitrā yaḥ sahāyō'rthāt pavitra ātmā mama nāmni prērayiṣyati sa sarvvaṁ śikṣayitvā mayōktāḥ samastāḥ kathā yuṣmān smārayiṣyati| ");
INSERT INTO saniso_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","ahaṁ yuṣmākaṁ nikaṭē śāntiṁ sthāpayitvā yāmi, nijāṁ śāntiṁ yuṣmabhyaṁ dadāmi, jagatō lōkā yathā dadāti tathāhaṁ na dadāmi; yuṣmākam antaḥkaraṇāni duḥkhitāni bhītāni ca na bhavantu| ");
INSERT INTO saniso_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","ahaṁ gatvā punarapi yuṣmākaṁ samīpam āgamiṣyāmi mayōktaṁ vākyamidaṁ yūyam aśrauṣṭa; yadi mayyaprēṣyadhvaṁ tarhyahaṁ pituḥ samīpaṁ gacchāmi mamāsyāṁ kathāyāṁ yūyam ahlādiṣyadhvaṁ yatō mama pitā mattōpi mahān| ");
INSERT INTO saniso_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","tasyā ghaṭanāyāḥ samayē yathā yuṣmākaṁ śraddhā jāyatē tadartham ahaṁ tasyā ghaṭanāyāḥ pūrvvam idānīṁ yuṣmān ētāṁ vārttāṁ vadāmi| ");
INSERT INTO saniso_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","itaḥ paraṁ yuṣmābhiḥ saha mama bahava ālāpā na bhaviṣyanti yataḥ kāraṇād ētasya jagataḥ patirāgacchati kintu mayā saha tasya kōpi sambandhō nāsti| ");
INSERT INTO saniso_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ahaṁ pitari prēma karōmi tathā pitu rvidhivat karmmāṇi karōmīti yēna jagatō lōkā jānanti tadartham uttiṣṭhata vayaṁ sthānādasmād gacchāma| ");
INSERT INTO saniso_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","ahaṁ satyadrākṣālatāsvarūpō mama pitā tūdyānaparicārakasvarūpañca| ");
INSERT INTO saniso_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","mama yāsu śākhāsu phalāni na bhavanti tāḥ sa chinatti tathā phalavatyaḥ śākhā yathādhikaphalāni phalanti tadarthaṁ tāḥ pariṣkarōti| ");
INSERT INTO saniso_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","idānīṁ mayōktōpadēśēna yūyaṁ pariṣkr̥tāḥ| ");
INSERT INTO saniso_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ataḥ kāraṇāt mayi tiṣṭhata tēnāhamapi yuṣmāsu tiṣṭhāmi, yatō hētō rdrākṣālatāyām asaṁlagnā śākhā yathā phalavatī bhavituṁ na śaknōti tathā yūyamapi mayyatiṣṭhantaḥ phalavantō bhavituṁ na śaknutha| ");
INSERT INTO saniso_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","ahaṁ drākṣālatāsvarūpō yūyañca śākhāsvarūpōḥ; yō janō mayi tiṣṭhati yatra cāhaṁ tiṣṭhāmi, sa pracūraphalaiḥ phalavān bhavati, kintu māṁ vinā yūyaṁ kimapi karttuṁ na śaknutha| ");
INSERT INTO saniso_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","yaḥ kaścin mayi na tiṣṭhati sa śuṣkaśākhēva bahi rnikṣipyatē lōkāśca tā āhr̥tya vahnau nikṣipya dāhayanti| ");
INSERT INTO saniso_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","yadi yūyaṁ mayi tiṣṭhatha mama kathā ca yuṣmāsu tiṣṭhati tarhi yad vāñchitvā yāciṣyadhvē yuṣmākaṁ tadēva saphalaṁ bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","yadi yūyaṁ pracūraphalavantō bhavatha tarhi tadvārā mama pitu rmahimā prakāśiṣyatē tathā yūyaṁ mama śiṣyā iti parikṣāyiṣyadhvē| ");
INSERT INTO saniso_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","pitā yathā mayi prītavān ahamapi yuṣmāsu tathā prītavān atō hētō ryūyaṁ nirantaraṁ mama prēmapātrāṇi bhūtvā tiṣṭhata| ");
INSERT INTO saniso_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ahaṁ yathā piturājñā gr̥hītvā tasya prēmabhājanaṁ tiṣṭhāmi tathaiva yūyamapi yadi mamājñā guhlītha tarhi mama prēmabhājanāni sthāsyatha| ");
INSERT INTO saniso_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","yuṣmannimittaṁ mama ya āhlādaḥ sa yathā ciraṁ tiṣṭhati yuṣmākam ānandaśca yathā pūryyatē tadarthaṁ yuṣmabhyam ētāḥ kathā atrakatham| ");
INSERT INTO saniso_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","ahaṁ yuṣmāsu yathā prīyē yūyamapi parasparaṁ tathā prīyadhvam ēṣā mamājñā| ");
INSERT INTO saniso_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","mitrāṇāṁ kāraṇāt svaprāṇadānaparyyantaṁ yat prēma tasmān mahāprēma kasyāpi nāsti| ");
INSERT INTO saniso_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","ahaṁ yadyad ādiśāmi tattadēva yadi yūyam ācarata tarhi yūyamēva mama mitrāṇi| ");
INSERT INTO saniso_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","adyārabhya yuṣmān dāsān na vadiṣyāmi yat prabhu ryat karōti dāsastad na jānāti; kintu pituḥ samīpē yadyad aśr̥ṇavaṁ tat sarvvaṁ yūṣmān ajñāpayam tatkāraṇād yuṣmān mitrāṇi prōktavān| ");
INSERT INTO saniso_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","yūyaṁ māṁ rōcitavanta iti na, kintvahamēva yuṣmān rōcitavān yūyaṁ gatvā yathā phalānyutpādayatha tāni phalāni cākṣayāṇi bhavanti, tadarthaṁ yuṣmān nyajunajaṁ tasmān mama nāma prōcya pitaraṁ yat kiñcid yāciṣyadhvē tadēva sa yuṣmabhyaṁ dāsyati| ");
INSERT INTO saniso_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","yūyaṁ parasparaṁ prīyadhvam aham ityājñāpayāmi| ");
INSERT INTO saniso_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","jagatō lōkai ryuṣmāsu r̥tīyitēṣu tē pūrvvaṁ māmēvārttīyanta iti yūyaṁ jānītha| ");
INSERT INTO saniso_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","yadi yūyaṁ jagatō lōkā abhaviṣyata tarhi jagatō lōkā yuṣmān ātmīyān buddhvāprēṣyanta; kintu yūyaṁ jagatō lōkā na bhavatha, ahaṁ yuṣmān asmājjagatō'rōcayam ētasmāt kāraṇājjagatō lōkā yuṣmān r̥tīyantē| ");
INSERT INTO saniso_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","dāsaḥ prabhō rmahān na bhavati mamaitat pūrvvīyaṁ vākyaṁ smarata; tē yadi māmēvātāḍayan tarhi yuṣmānapi tāḍayiṣyanti, yadi mama vākyaṁ gr̥hlanti tarhi yuṣmākamapi vākyaṁ grahīṣyanti| ");
INSERT INTO saniso_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","kintu tē mama nāmakāraṇād yuṣmān prati tādr̥śaṁ vyavahariṣyanti yatō yō māṁ prēritavān taṁ tē na jānanti| ");
INSERT INTO saniso_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","tēṣāṁ sannidhim āgatya yadyahaṁ nākathayiṣyaṁ tarhi tēṣāṁ pāpaṁ nābhaviṣyat kintvadhunā tēṣāṁ pāpamācchādayitum upāyō nāsti| ");
INSERT INTO saniso_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","yō janō mām r̥tīyatē sa mama pitaramapi r̥tīyatē| ");
INSERT INTO saniso_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","yādr̥śāni karmmāṇi kēnāpi kadāpi nākriyanta tādr̥śāni karmmāṇi yadi tēṣāṁ sākṣād ahaṁ nākariṣyaṁ tarhi tēṣāṁ pāpaṁ nābhaviṣyat kintvadhunā tē dr̥ṣṭvāpi māṁ mama pitarañcārttīyanta| ");
INSERT INTO saniso_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","tasmāt tē'kāraṇaṁ mām r̥tīyantē yadētad vacanaṁ tēṣāṁ śāstrē likhitamāstē tat saphalam abhavat| ");
INSERT INTO saniso_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","kintu pitu rnirgataṁ yaṁ sahāyamarthāt satyamayam ātmānaṁ pituḥ samīpād yuṣmākaṁ samīpē prēṣayiṣyāmi sa āgatya mayi pramāṇaṁ dāsyati| ");
INSERT INTO saniso_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","yūyaṁ prathamamārabhya mayā sārddhaṁ tiṣṭhatha tasmāddhētō ryūyamapi pramāṇaṁ dāsyatha| ");
INSERT INTO saniso_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","yuṣmākaṁ yathā vādhā na jāyatē tadarthaṁ yuṣmān ētāni sarvvavākyāni vyāharaṁ| ");
INSERT INTO saniso_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","lōkā yuṣmān bhajanagr̥hēbhyō dūrīkariṣyanti tathā yasmin samayē yuṣmān hatvā īśvarasya tuṣṭi janakaṁ karmmākurmma iti maṁsyantē sa samaya āgacchanti| ");
INSERT INTO saniso_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","tē pitaraṁ māñca na jānanti, tasmād yuṣmān pratīdr̥śam ācariṣyanti| ");
INSERT INTO saniso_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","atō hētāḥ samayē samupasthitē yathā mama kathā yuṣmākaṁ manaḥsuḥ samupatiṣṭhati tadarthaṁ yuṣmābhyam ētāṁ kathāṁ kathayāmi yuṣmābhiḥ sārddham ahaṁ tiṣṭhan prathamaṁ tāṁ yuṣmabhyaṁ nākathayaṁ| ");
INSERT INTO saniso_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","sāmprataṁ svasya prērayituḥ samīpaṁ gacchāmi tathāpi tvaṁ kka gacchasi kathāmētāṁ yuṣmākaṁ kōpi māṁ na pr̥cchati| ");
INSERT INTO saniso_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","kintu mayōktābhirābhiḥ kathābhi ryūṣmākam antaḥkaraṇāni duḥkhēna pūrṇānyabhavan| ");
INSERT INTO saniso_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","tathāpyahaṁ yathārthaṁ kathayāmi mama gamanaṁ yuṣmākaṁ hitārthamēva, yatō hētō rgamanē na kr̥tē sahāyō yuṣmākaṁ samīpaṁ nāgamiṣyati kintu yadi gacchāmi tarhi yuṣmākaṁ samīpē taṁ prēṣayiṣyāmi| ");
INSERT INTO saniso_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","tataḥ sa āgatya pāpapuṇyadaṇḍēṣu jagatō lōkānāṁ prabōdhaṁ janayiṣyati| ");
INSERT INTO saniso_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","tē mayi na viśvasanti tasmāddhētōḥ pāpaprabōdhaṁ janayiṣyati| ");
INSERT INTO saniso_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","yuṣmākam adr̥śyaḥ sannahaṁ pituḥ samīpaṁ gacchāmi tasmād puṇyē prabōdhaṁ janayiṣyati| ");
INSERT INTO saniso_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ētajjagatō'dhipati rdaṇḍājñāṁ prāpnōti tasmād daṇḍē prabōdhaṁ janayiṣyati| ");
INSERT INTO saniso_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","yuṣmabhyaṁ kathayituṁ mamānēkāḥ kathā āsatē, tāḥ kathā idānīṁ yūyaṁ sōḍhuṁ na śaknutha; ");
INSERT INTO saniso_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","kintu satyamaya ātmā yadā samāgamiṣyati tadā sarvvaṁ satyaṁ yuṣmān nēṣyati, sa svataḥ kimapi na vadiṣyati kintu yacchrōṣyati tadēva kathayitvā bhāvikāryyaṁ yuṣmān jñāpayiṣyati| ");
INSERT INTO saniso_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","mama mahimānaṁ prakāśayiṣyati yatō madīyāṁ kathāṁ gr̥hītvā yuṣmān bōdhayiṣyati| ");
INSERT INTO saniso_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","pitu ryadyad āstē tat sarvvaṁ mama tasmād kāraṇād avādiṣaṁ sa madīyāṁ kathāṁ gr̥hītvā yuṣmān bōdhayiṣyati| ");
INSERT INTO saniso_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","kiyatkālāt paraṁ yūyaṁ māṁ draṣṭuṁ na lapsyadhvē kintu kiyatkālāt paraṁ puna rdraṣṭuṁ lapsyadhvē yatōhaṁ pituḥ samīpaṁ gacchāmi| ");
INSERT INTO saniso_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","tataḥ śiṣyāṇāṁ kiyantō janāḥ parasparaṁ vaditum ārabhanta, kiyatkālāt paraṁ māṁ draṣṭuṁ na lapsyadhvē kintu kiyatkālāt paraṁ puna rdraṣṭuṁ lapsyadhvē yatōhaṁ pituḥ samīpaṁ gacchāmi, iti yad vākyam ayaṁ vadati tat kiṁ? ");
INSERT INTO saniso_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","tataḥ kiyatkālāt param iti tasya vākyaṁ kiṁ? tasya vākyasyābhiprāyaṁ vayaṁ bōddhuṁ na śaknumastairiti ");
INSERT INTO saniso_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","nigaditē yīśustēṣāṁ praśnēcchāṁ jñātvā tēbhyō'kathayat kiyatkālāt paraṁ māṁ draṣṭuṁ na lapsyadhvē, kintu kiyatkālāt paraṁ pūna rdraṣṭuṁ lapsyadhvē, yāmimāṁ kathāmakathayaṁ tasyā abhiprāyaṁ kiṁ yūyaṁ parasparaṁ mr̥gayadhvē? ");
INSERT INTO saniso_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","yuṣmānaham atiyathārthaṁ vadāmi yūyaṁ krandiṣyatha vilapiṣyatha ca, kintu jagatō lōkā ānandiṣyanti; yūyaṁ śōkākulā bhaviṣyatha kintu śōkāt paraṁ ānandayuktā bhaviṣyatha| ");
INSERT INTO saniso_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","prasavakāla upasthitē nārī yathā prasavavēdanayā vyākulā bhavati kintu putrē bhūmiṣṭhē sati manuṣyaikō janmanā naralōkē praviṣṭa ityānandāt tasyāstatsarvvaṁ duḥkhaṁ manasi na tiṣṭhati, ");
INSERT INTO saniso_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","tathā yūyamapi sāmprataṁ śōkākulā bhavatha kintu punarapi yuṣmabhyaṁ darśanaṁ dāsyāmi tēna yuṣmākam antaḥkaraṇāni sānandāni bhaviṣyanti, yuṣmākaṁ tam ānandañca kōpi harttuṁ na śakṣyati| ");
INSERT INTO saniso_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","tasmin divasē kāmapi kathāṁ māṁ na prakṣyatha| yuṣmānaham atiyathārthaṁ vadāmi, mama nāmnā yat kiñcid pitaraṁ yāciṣyadhvē tadēva sa dāsyati| ");
INSERT INTO saniso_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","pūrvvē mama nāmnā kimapi nāyācadhvaṁ, yācadhvaṁ tataḥ prāpsyatha tasmād yuṣmākaṁ sampūrṇānandō janiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","upamākathābhiḥ sarvvāṇyētāni yuṣmān jñāpitavān kintu yasmin samayē upamayā nōktvā pituḥ kathāṁ spaṣṭaṁ jñāpayiṣyāmi samaya ētādr̥śa āgacchati| ");
INSERT INTO saniso_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","tadā mama nāmnā prārthayiṣyadhvē 'haṁ yuṣmannimittaṁ pitaraṁ vinēṣyē kathāmimāṁ na vadāmi; ");
INSERT INTO saniso_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","yatō yūyaṁ mayi prēma kurutha, tathāham īśvarasya samīpād āgatavān ityapi pratītha, tasmād kāraṇāt kāraṇāt pitā svayaṁ yuṣmāsu prīyatē| ");
INSERT INTO saniso_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","pituḥ samīpājjajad āgatōsmi jagat parityajya ca punarapi pituḥ samīpaṁ gacchāmi| ");
INSERT INTO saniso_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","tadā śiṣyā avadan, hē prabhō bhavān upamayā nōktvādhunā spaṣṭaṁ vadati| ");
INSERT INTO saniso_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","bhavān sarvvajñaḥ kēnacit pr̥ṣṭō bhavitumapi bhavataḥ prayōjanaṁ nāstītyadhunāsmākaṁ sthirajñānaṁ jātaṁ tasmād bhavān īśvarasya samīpād āgatavān ityatra vayaṁ viśvasimaḥ| ");
INSERT INTO saniso_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","tatō yīśuḥ pratyavādīd idānīṁ kiṁ yūyaṁ viśvasitha? ");
INSERT INTO saniso_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","paśyata sarvvē yūyaṁ vikīrṇāḥ santō mām ēkākinaṁ pīratyajya svaṁ svaṁ sthānaṁ gamiṣyatha, ētādr̥śaḥ samaya āgacchati varaṁ prāyēṇōpasthitavān; tathāpyahaṁ naikākī bhavāmi yataḥ pitā mayā sārddham āstē| ");
INSERT INTO saniso_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","yathā mayā yuṣmākaṁ śānti rjāyatē tadartham ētāḥ kathā yuṣmabhyam acakathaṁ; asmin jagati yuṣmākaṁ klēśō ghaṭiṣyatē kintvakṣōbhā bhavata yatō mayā jagajjitaṁ| ");
INSERT INTO saniso_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","tataḥ paraṁ yīśurētāḥ kathāḥ kathayitvā svargaṁ vilōkyaitat prārthayat, hē pitaḥ samaya upasthitavān; yathā tava putrastava mahimānaṁ prakāśayati tadarthaṁ tvaṁ nijaputrasya mahimānaṁ prakāśaya| ");
INSERT INTO saniso_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","tvaṁ yōllōkān tasya hastē samarpitavān sa yathā tēbhyō'nantāyu rdadāti tadarthaṁ tvaṁ prāṇimātrāṇām adhipatitvabhāraṁ tasmai dattavān| ");
INSERT INTO saniso_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","yastvam advitīyaḥ satya īśvarastvayā prēritaśca yīśuḥ khrīṣṭa ētayōrubhayōḥ paricayē prāptē'nantāyu rbhavati| ");
INSERT INTO saniso_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","tvaṁ yasya karmmaṇō bhāraṁ mahyaṁ dattavān, tat sampannaṁ kr̥tvā jagatyasmin tava mahimānaṁ prākāśayaṁ| ");
INSERT INTO saniso_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ataēva hē pita rjagatyavidyamānē tvayā saha tiṣṭhatō mama yō mahimāsīt samprati tava samīpē māṁ taṁ mahimānaṁ prāpaya| ");
INSERT INTO saniso_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","anyacca tvam ētajjagatō yāllōkān mahyam adadā ahaṁ tēbhyastava nāmnastattvajñānam adadāṁ, tē tavaivāsan, tvaṁ tān mahyamadadāḥ, tasmāttē tavōpadēśam agr̥hlan| ");
INSERT INTO saniso_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","tvaṁ mahyaṁ yat kiñcid adadāstatsarvvaṁ tvattō jāyatē ityadhunājānan| ");
INSERT INTO saniso_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","mahyaṁ yamupadēśam adadā ahamapi tēbhyastamupadēśam adadāṁ tēpi tamagr̥hlan tvattōhaṁ nirgatya tvayā prēritōbhavam atra ca vyaśvasan| ");
INSERT INTO saniso_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","tēṣāmēva nimittaṁ prārthayē'haṁ jagatō lōkanimittaṁ na prārthayē kintu yāllōkān mahyam adadāstēṣāmēva nimittaṁ prārthayē'haṁ yatastē tavaivāsatē| ");
INSERT INTO saniso_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","yē mama tē tava yē ca tava tē mama tathā tai rmama mahimā prakāśyatē| ");
INSERT INTO saniso_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","sāmpratam asmin jagati mamāvasthitēḥ śēṣam abhavat ahaṁ tava samīpaṁ gacchāmi kintu tē jagati sthāsyanti; hē pavitra pitarāvayō ryathaikatvamāstē tathā tēṣāmapyēkatvaṁ bhavati tadarthaṁ yāllōkān mahyam adadāstān svanāmnā rakṣa| ");
INSERT INTO saniso_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","yāvanti dināni jagatyasmin taiḥ sahāhamāsaṁ tāvanti dināni tān tava nāmnāhaṁ rakṣitavān; yāllōkān mahyam adadāstān sarvvān ahamarakṣaṁ, tēṣāṁ madhyē kēvalaṁ vināśapātraṁ hāritaṁ tēna dharmmapustakasya vacanaṁ pratyakṣaṁ bhavati| ");
INSERT INTO saniso_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","kintvadhunā tava sannidhiṁ gacchāmi mayā yathā tēṣāṁ sampūrṇānandō bhavati tadarthamahaṁ jagati tiṣṭhan ētāḥ kathā akathayam| ");
INSERT INTO saniso_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","tavōpadēśaṁ tēbhyō'dadāṁ jagatā saha yathā mama sambandhō nāsti tathā jajatā saha tēṣāmapi sambandhābhāvāj jagatō lōkāstān r̥tīyantē| ");
INSERT INTO saniso_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","tvaṁ jagatastān gr̥hāṇēti na prārthayē kintvaśubhād rakṣēti prārthayēham| ");
INSERT INTO saniso_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ahaṁ yathā jagatsambandhīyō na bhavāmi tathā tēpi jagatsambandhīyā na bhavanti| ");
INSERT INTO saniso_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","tava satyakathayā tān pavitrīkuru tava vākyamēva satyaṁ| ");
INSERT INTO saniso_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","tvaṁ yathā māṁ jagati prairayastathāhamapi tān jagati prairayaṁ| ");
INSERT INTO saniso_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","tēṣāṁ hitārthaṁ yathāhaṁ svaṁ pavitrīkarōmi tathā satyakathayā tēpi pavitrībhavantu| ");
INSERT INTO saniso_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","kēvalaṁ ētēṣāmarthē prārthayē'ham iti na kintvētēṣāmupadēśēna yē janā mayi viśvasiṣyanti tēṣāmapyarthē prārthēyē'ham| ");
INSERT INTO saniso_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","hē pitastēṣāṁ sarvvēṣām ēkatvaṁ bhavatu tava yathā mayi mama ca yathā tvayyēkatvaṁ tathā tēṣāmapyāvayōrēkatvaṁ bhavatu tēna tvaṁ māṁ prēritavān iti jagatō lōkāḥ pratiyantu| ");
INSERT INTO saniso_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","yathāvayōrēkatvaṁ tathā tēṣāmapyēkatvaṁ bhavatu tēṣvahaṁ mayi ca tvam itthaṁ tēṣāṁ sampūrṇamēkatvaṁ bhavatu, tvaṁ prēritavān tvaṁ mayi yathā prīyasē ca tathā tēṣvapi prītavān ētadyathā jagatō lōkā jānanti ");
INSERT INTO saniso_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","tadarthaṁ tvaṁ yaṁ mahimānaṁ mahyam adadāstaṁ mahimānam ahamapi tēbhyō dattavān| ");
INSERT INTO saniso_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","hē pita rjagatō nirmmāṇāt pūrvvaṁ mayi snēhaṁ kr̥tvā yaṁ mahimānaṁ dattavān mama taṁ mahimānaṁ yathā tē paśyanti tadarthaṁ yāllōkān mahyaṁ dattavān ahaṁ yatra tiṣṭhāmi tēpi yathā tatra tiṣṭhanti mamaiṣā vāñchā| ");
INSERT INTO saniso_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","hē yathārthika pita rjagatō lōkaistvayyajñātēpi tvāmahaṁ jānē tvaṁ māṁ prēritavān itīmē śiṣyā jānanti| ");
INSERT INTO saniso_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","yathāhaṁ tēṣu tiṣṭhāmi tathā mayi yēna prēmnā prēmākarōstat tēṣu tiṣṭhati tadarthaṁ tava nāmāhaṁ tān jñāpitavān punarapi jñāpayiṣyāmi| ");
INSERT INTO saniso_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","tāḥ kathāḥ kathayitvā yīśuḥ śiṣyānādāya kidrōnnāmakaṁ srōta uttīryya śiṣyaiḥ saha tatratyōdyānaṁ prāviśat| ");
INSERT INTO saniso_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","kintu viśvāsaghātiyihūdāstat sthānaṁ paricīyatē yatō yīśuḥ śiṣyaiḥ sārddhaṁ kadācit tat sthānam agacchat| ");
INSERT INTO saniso_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","tadā sa yihūdāḥ sainyagaṇaṁ pradhānayājakānāṁ phirūśināñca padātigaṇañca gr̥hītvā pradīpān ulkān astrāṇi cādāya tasmin sthāna upasthitavān| ");
INSERT INTO saniso_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","svaṁ prati yad ghaṭiṣyatē taj jñātvā yīśuragrēsaraḥ san tānapr̥cchat kaṁ gavēṣayatha? ");
INSERT INTO saniso_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","tē pratyavadan, nāsaratīyaṁ yīśuṁ; tatō yīśuravādīd ahamēva saḥ; taiḥ saha viśvāsaghātī yihūdāścātiṣṭhat| ");
INSERT INTO saniso_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","tadāhamēva sa tasyaitāṁ kathāṁ śrutvaiva tē paścādētya bhūmau patitāḥ| ");
INSERT INTO saniso_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","tatō yīśuḥ punarapi pr̥ṣṭhavān kaṁ gavēṣayatha? tatastē pratyavadan nāsaratīyaṁ yīśuṁ| ");
INSERT INTO saniso_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","tadā yīśuḥ pratyuditavān ahamēva sa imāṁ kathāmacakatham; yadi māmanvicchatha tarhīmān gantuṁ mā vārayata| ");
INSERT INTO saniso_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","itthaṁ bhūtē mahyaṁ yāllōkān adadāstēṣām ēkamapi nāhārayam imāṁ yāṁ kathāṁ sa svayamakathayat sā kathā saphalā jātā| ");
INSERT INTO saniso_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","tadā śimōnpitarasya nikaṭē khaṅgalsthitēḥ sa taṁ niṣkōṣaṁ kr̥tvā mahāyājakasya mālkhanāmānaṁ dāsam āhatya tasya dakṣiṇakarṇaṁ chinnavān| ");
INSERT INTO saniso_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","tatō yīśuḥ pitaram avadat, khaṅgaṁ kōṣē sthāpaya mama pitā mahyaṁ pātuṁ yaṁ kaṁsam adadāt tēnāhaṁ kiṁ na pāsyāmi? ");
INSERT INTO saniso_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","tadā sainyagaṇaḥ sēnāpati ryihūdīyānāṁ padātayaśca yīśuṁ ghr̥tvā baddhvā hānannāmnaḥ kiyaphāḥ śvaśurasya samīpaṁ prathamam anayan| ");
INSERT INTO saniso_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","sa kiyaphāstasmin vatsarē mahāyājatvapadē niyuktaḥ ");
INSERT INTO saniso_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","san sādhāraṇalōkānāṁ maṅgalārtham ēkajanasya maraṇamucitam iti yihūdīyaiḥ sārddham amantrayat| ");
INSERT INTO saniso_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","tadā śimōnpitarō'nyaikaśiṣyaśca yīśōḥ paścād agacchatāṁ tasyānyaśiṣyasya mahāyājakēna paricitatvāt sa yīśunā saha mahāyājakasyāṭṭālikāṁ prāviśat| ");
INSERT INTO saniso_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","kintu pitarō bahirdvārasya samīpē'tiṣṭhad ataēva mahāyājakēna paricitaḥ sa śiṣyaḥ punarbahirgatvā dauvāyikāyai kathayitvā pitaram abhyantaram ānayat| ");
INSERT INTO saniso_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","tadā sa dvārarakṣikā pitaram avadat tvaṁ kiṁ na tasya mānavasya śiṣyaḥ? tataḥ sōvadad ahaṁ na bhavāmi| ");
INSERT INTO saniso_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","tataḥ paraṁ yatsthānē dāsāḥ padātayaśca śītahētōraṅgārai rvahniṁ prajvālya tāpaṁ sēvitavantastatsthānē pitarastiṣṭhan taiḥ saha vahnitāpaṁ sēvitum ārabhata| ");
INSERT INTO saniso_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","tadā śiṣyēṣūpadēśē ca mahāyājakēna yīśuḥ pr̥ṣṭaḥ ");
INSERT INTO saniso_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","san pratyuktavān sarvvalōkānāṁ samakṣaṁ kathāmakathayaṁ guptaṁ kāmapi kathāṁ na kathayitvā yat sthānaṁ yihūdīyāḥ satataṁ gacchanti tatra bhajanagēhē mandirē cāśikṣayaṁ| ");
INSERT INTO saniso_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","mattaḥ kutaḥ pr̥cchasi? yē janā madupadēśam aśr̥ṇvan tānēva pr̥ccha yadyad avadaṁ tē tat jāninta| ");
INSERT INTO saniso_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","tadētthaṁ pratyuditatvāt nikaṭasthapadāti ryīśuṁ capēṭēnāhatya vyāharat mahāyājakam ēvaṁ prativadasi? ");
INSERT INTO saniso_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","tatō yīśuḥ pratigaditavān yadyayathārtham acakathaṁ tarhi tasyāyathārthasya pramāṇaṁ dēhi, kintu yadi yathārthaṁ tarhi kutō hētō rmām atāḍayaḥ? ");
INSERT INTO saniso_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","pūrvvaṁ hānan sabandhanaṁ taṁ kiyaphāmahāyājakasya samīpaṁ praiṣayat| ");
INSERT INTO saniso_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","śimōnpitarastiṣṭhan vahnitāpaṁ sēvatē, ētasmin samayē kiyantastam apr̥cchan tvaṁ kim ētasya janasya śiṣyō na? tataḥ sōpahnutyābravīd ahaṁ na bhavāmi| ");
INSERT INTO saniso_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","tadā mahāyājakasya yasya dāsasya pitaraḥ karṇamacchinat tasya kuṭumbaḥ pratyuditavān udyānē tēna saha tiṣṭhantaṁ tvāṁ kiṁ nāpaśyaṁ? ");
INSERT INTO saniso_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","kintu pitaraḥ punarapahnutya kathitavān; tadānīṁ kukkuṭō'raut| ");
INSERT INTO saniso_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","tadanantaraṁ pratyūṣē tē kiyaphāgr̥hād adhipatē rgr̥haṁ yīśum anayan kintu yasmin aśucitvē jātē tai rnistārōtsavē na bhōktavyaṁ, tasya bhayād yihūdīyāstadgr̥haṁ nāviśan| ");
INSERT INTO saniso_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","aparaṁ pīlātō bahirāgatya tān pr̥ṣṭhavān ētasya manuṣyasya kaṁ dōṣaṁ vadatha? ");
INSERT INTO saniso_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","tadā tē pētyavadan duṣkarmmakāriṇi na sati bhavataḥ samīpē nainaṁ samārpayiṣyāmaḥ| ");
INSERT INTO saniso_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","tataḥ pīlātō'vadad yūyamēnaṁ gr̥hītvā svēṣāṁ vyavasthayā vicārayata| tadā yihūdīyāḥ pratyavadan kasyāpi manuṣyasya prāṇadaṇḍaṁ karttuṁ nāsmākam adhikārō'sti| ");
INSERT INTO saniso_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ēvaṁ sati yīśuḥ svasya mr̥tyau yāṁ kathāṁ kathitavān sā saphalābhavat| ");
INSERT INTO saniso_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","tadanantaraṁ pīlātaḥ punarapi tad rājagr̥haṁ gatvā yīśumāhūya pr̥ṣṭavān tvaṁ kiṁ yihūdīyānāṁ rājā? ");
INSERT INTO saniso_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","yīśuḥ pratyavadat tvam ētāṁ kathāṁ svataḥ kathayasi kimanyaḥ kaścin mayi kathitavān? ");
INSERT INTO saniso_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","pīlātō'vadad ahaṁ kiṁ yihūdīyaḥ? tava svadēśīyā viśēṣataḥ pradhānayājakā mama nikaṭē tvāṁ samārpayana, tvaṁ kiṁ kr̥tavān? ");
INSERT INTO saniso_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","yīśuḥ pratyavadat mama rājyam ētajjagatsambandhīyaṁ na bhavati yadi mama rājyaṁ jagatsambandhīyam abhaviṣyat tarhi yihūdīyānāṁ hastēṣu yathā samarpitō nābhavaṁ tadarthaṁ mama sēvakā ayōtsyan kintu mama rājyam aihikaṁ na| ");
INSERT INTO saniso_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","tadā pīlātaḥ kathitavān, tarhi tvaṁ rājā bhavasi? yīśuḥ pratyuktavān tvaṁ satyaṁ kathayasi, rājāhaṁ bhavāmi; satyatāyāṁ sākṣyaṁ dātuṁ janiṁ gr̥hītvā jagatyasmin avatīrṇavān, tasmāt satyadharmmapakṣapātinō mama kathāṁ śr̥ṇvanti| ");
INSERT INTO saniso_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","tadā satyaṁ kiṁ? ētāṁ kathāṁ paṣṭvā pīlātaḥ punarapi bahirgatvā yihūdīyān abhāṣata, ahaṁ tasya kamapyaparādhaṁ na prāpnōmi| ");
INSERT INTO saniso_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","nistārōtsavasamayē yuṣmābhirabhirucita ēkō janō mayā mōcayitavya ēṣā yuṣmākaṁ rītirasti, ataēva yuṣmākaṁ nikaṭē yihūdīyānāṁ rājānaṁ kiṁ mōcayāmi, yuṣmākam icchā kā? ");
INSERT INTO saniso_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","tadā tē sarvvē ruvantō vyāharan ēnaṁ mānuṣaṁ nahi barabbāṁ mōcaya| kintu sa barabbā dasyurāsīt| ");
INSERT INTO saniso_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","pīlātō yīśum ānīya kaśayā prāhārayat| ");
INSERT INTO saniso_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","paścāt sēnāgaṇaḥ kaṇṭakanirmmitaṁ mukuṭaṁ tasya mastakē samarpya vārttākīvarṇaṁ rājaparicchadaṁ paridhāpya, ");
INSERT INTO saniso_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","hē yihūdīyānāṁ rājan namaskāra ityuktvā taṁ capēṭēnāhantum ārabhata| ");
INSERT INTO saniso_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","tadā pīlātaḥ punarapi bahirgatvā lōkān avadat, asya kamapyaparādhaṁ na labhē'haṁ, paśyata tad yuṣmān jñāpayituṁ yuṣmākaṁ sannidhau bahirēnam ānayāmi| ");
INSERT INTO saniso_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","tataḥ paraṁ yīśuḥ kaṇṭakamukuṭavān vārttākīvarṇavasanavāṁśca bahirāgacchat| tataḥ pīlāta uktavān ēnaṁ manuṣyaṁ paśyata| ");
INSERT INTO saniso_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","tadā pradhānayājakāḥ padātayaśca taṁ dr̥ṣṭvā, ēnaṁ kruśē vidha, ēnaṁ kruśē vidha, ityuktvā ravituṁ ārabhanta| tataḥ pīlātaḥ kathitavān yūyaṁ svayam ēnaṁ nītvā kruśē vidhata, aham ētasya kamapyaparādhaṁ na prāptavān| ");
INSERT INTO saniso_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","yihūdīyāḥ pratyavadan asmākaṁ yā vyavasthāstē tadanusārēṇāsya prāṇahananam ucitaṁ yatōyaṁ svam īśvarasya putramavadat| ");
INSERT INTO saniso_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","pīlāta imāṁ kathāṁ śrutvā mahātrāsayuktaḥ ");
INSERT INTO saniso_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","san punarapi rājagr̥ha āgatya yīśuṁ pr̥ṣṭavān tvaṁ kutratyō lōkaḥ? kintu yīśastasya kimapi pratyuttaraṁ nāvadat| ");
INSERT INTO saniso_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","1# tataḥ pīlāt kathitavāna tvaṁ kiṁ mayā sārddhaṁ na saṁlapiṣyasi ? tvāṁ kruśē vēdhituṁ vā mōcayituṁ śakti rmamāstē iti kiṁ tvaṁ na jānāsi ? tadā yīśuḥ pratyavadad īśvarēṇādaŸाṁ mamōpari tava kimapyadhipatitvaṁ na vidyatē, tathāpi yō janō māṁ tava hastē samārpayat tasya mahāpātakaṁ jātam| ");
INSERT INTO saniso_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","tadā yīśuḥ pratyavadad īśvarēṇādattaṁ mamōpari tava kimapyadhipatitvaṁ na vidyatē, tathāpi yō janō māṁ tava hastē samārpayat tasya mahāpātakaṁ jātam| ");
INSERT INTO saniso_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","tadārabhya pīlātastaṁ mōcayituṁ cēṣṭitavān kintu yihūdīyā ruvantō vyāharan yadīmaṁ mānavaṁ tyajasi tarhi tvaṁ kaisarasya mitraṁ na bhavasi, yō janaḥ svaṁ rājānaṁ vakti saēva kaimarasya viruddhāṁ kathāṁ kathayati| ");
INSERT INTO saniso_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ētāṁ kathāṁ śrutvā pīlātō yīśuṁ bahirānīya nistārōtsavasya āsādanadinasya dvitīyapraharāt pūrvvaṁ prastarabandhananāmni sthānē 'rthāt ibrīyabhāṣayā yad gabbithā kathyatē tasmin sthānē vicārāsana upāviśat| ");
INSERT INTO saniso_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","anantaraṁ pīlātō yihūdīyān avadat, yuṣmākaṁ rājānaṁ paśyata| ");
INSERT INTO saniso_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","kintu ēnaṁ dūrīkuru, ēnaṁ dūrīkuru, ēnaṁ kruśē vidha, iti kathāṁ kathayitvā tē ravitum ārabhanta; tadā pīlātaḥ kathitavān yuṣmākaṁ rājānaṁ kiṁ kruśē vēdhiṣyāmi? pradhānayājakā uttaram avadan kaisaraṁ vinā kōpi rājāsmākaṁ nāsti| ");
INSERT INTO saniso_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","tataḥ pīlātō yīśuṁ kruśē vēdhituṁ tēṣāṁ hastēṣu samārpayat, tatastē taṁ dhr̥tvā nītavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","tataḥ paraṁ yīśuḥ kruśaṁ vahan śiraḥkapālam arthād yad ibrīyabhāṣayā gulgaltāṁ vadanti tasmin sthāna upasthitaḥ| ");
INSERT INTO saniso_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","tatastē madhyasthānē taṁ tasyōbhayapārśvē dvāvaparau kruśē'vidhan| ");
INSERT INTO saniso_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","aparam ēṣa yihūdīyānāṁ rājā nāsaratīyayīśuḥ, iti vijñāpanaṁ likhitvā pīlātastasya kruśōpari samayōjayat| ");
INSERT INTO saniso_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","sā lipiḥ ibrīyayūnānīyarōmīyabhāṣābhi rlikhitā; yīśōḥ kruśavēdhanasthānaṁ nagarasya samīpaṁ, tasmād bahavō yihūdīyāstāṁ paṭhitum ārabhanta| ");
INSERT INTO saniso_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","yihūdīyānāṁ pradhānayājakāḥ pīlātamiti nyavēdayan yihūdīyānāṁ rājēti vākyaṁ na kintu ēṣa svaṁ yihūdīyānāṁ rājānam avadad itthaṁ likhatu| ");
INSERT INTO saniso_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","tataḥ pīlāta uttaraṁ dattavān yallēkhanīyaṁ tallikhitavān| ");
INSERT INTO saniso_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","itthaṁ sēnāgaṇō yīśuṁ kruśē vidhitvā tasya paridhēyavastraṁ caturō bhāgān kr̥tvā ēkaikasēnā ēkaikabhāgam agr̥hlat tasyōttarīyavastrañcāgr̥hlat| kintūttarīyavastraṁ sūcisēvanaṁ vinā sarvvam ūtaṁ| ");
INSERT INTO saniso_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","tasmāttē vyāharan ētat kaḥ prāpsyati? tanna khaṇḍayitvā tatra guṭikāpātaṁ karavāma| vibhajantē'dharīyaṁ mē vasanaṁ tē parasparaṁ| mamōttarīyavastrārthaṁ guṭikāṁ pātayanti ca| iti yadvākyaṁ dharmmapustakē likhitamāstē tat sēnāgaṇēnētthaṁ vyavaharaṇāt siddhamabhavat| ");
INSERT INTO saniso_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","tadānīṁ yīśō rmātā mātu rbhaginī ca yā kliyapā bhāryyā mariyam magdalīnī mariyam ca ētāstasya kruśasya sannidhau samatiṣṭhan| ");
INSERT INTO saniso_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","tatō yīśuḥ svamātaraṁ priyatamaśiṣyañca samīpē daṇḍāyamānau vilōkya mātaram avadat, hē yōṣid ēnaṁ tava putraṁ paśya, ");
INSERT INTO saniso_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","śiṣyantvavadat, ēnāṁ tava mātaraṁ paśya| tataḥ sa śiṣyastadghaṭikāyāṁ tāṁ nijagr̥haṁ nītavān| ");
INSERT INTO saniso_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","anantaraṁ sarvvaṁ karmmādhunā sampannamabhūt yīśuriti jñātvā dharmmapustakasya vacanaṁ yathā siddhaṁ bhavati tadartham akathayat mama pipāsā jātā| ");
INSERT INTO saniso_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","tatastasmin sthānē amlarasēna pūrṇapātrasthityā tē spañjamēkaṁ tadamlarasēnārdrīkr̥tya ēsōbnalē tad yōjayitvā tasya mukhasya sannidhāvasthāpayan| ");
INSERT INTO saniso_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","tadā yīśuramlarasaṁ gr̥hītvā sarvvaṁ siddham iti kathāṁ kathayitvā mastakaṁ namayan prāṇān paryyatyajat| ");
INSERT INTO saniso_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","tadvinam āsādanadinaṁ tasmāt parē'hani viśrāmavārē dēhā yathā kruśōpari na tiṣṭhanti, yataḥ sa viśrāmavārō mahādinamāsīt, tasmād yihūdīyāḥ pīlātanikaṭaṁ gatvā tēṣāṁ pādabhañjanasya sthānāntaranayanasya cānumatiṁ prārthayanta| ");
INSERT INTO saniso_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ataḥ sēnā āgatya yīśunā saha kruśē hatayōḥ prathamadvitīyacōrayōḥ pādān abhañjan; ");
INSERT INTO saniso_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","kintu yīśōḥ sannidhiṁ gatvā sa mr̥ta iti dr̥ṣṭvā tasya pādau nābhañjan| ");
INSERT INTO saniso_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","paścād ēkō yōddhā śūlāghātēna tasya kukṣim avidhat tatkṣaṇāt tasmād raktaṁ jalañca niragacchat| ");
INSERT INTO saniso_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","yō janō'sya sākṣyaṁ dadāti sa svayaṁ dr̥ṣṭavān tasyēdaṁ sākṣyaṁ satyaṁ tasya kathā yuṣmākaṁ viśvāsaṁ janayituṁ yōgyā tat sa jānāti| ");
INSERT INTO saniso_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","tasyaikam asdhyapi na bhaṁkṣyatē, ");
INSERT INTO saniso_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","tadvad anyaśāstrēpi likhyatē, yathā, \"dr̥ṣṭipātaṁ kariṣyanti tē'vidhan yantu tamprati|\" ");
INSERT INTO saniso_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","arimathīyanagarasya yūṣaphnāmā śiṣya ēka āsīt kintu yihūdīyēbhyō bhayāt prakāśitō na bhavati; sa yīśō rdēhaṁ nētuṁ pīlātasyānumatiṁ prārthayata, tataḥ pīlātēnānumatē sati sa gatvā yīśō rdēham anayat| ");
INSERT INTO saniso_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","aparaṁ yō nikadīmō rātrau yīśōḥ samīpam agacchat sōpi gandharasēna miśritaṁ prāyēṇa pañcāśatsēṭakamaguruṁ gr̥hītvāgacchat| ");
INSERT INTO saniso_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","tatastē yihūdīyānāṁ śmaśānē sthāpanarītyanusārēṇa tatsugandhidravyēṇa sahitaṁ tasya dēhaṁ vastrēṇāvēṣṭayan| ");
INSERT INTO saniso_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","aparañca yatra sthānē taṁ kruśē'vidhan tasya nikaṭasthōdyānē yatra kimapi mr̥tadēhaṁ kadāpi nāsthāpyata tādr̥śam ēkaṁ nūtanaṁ śmaśānam āsīt| ");
INSERT INTO saniso_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","yihūdīyānām āsādanadināgamanāt tē tasmin samīpasthaśmaśānē yīśum aśāyayan| ");
INSERT INTO saniso_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","anantaraṁ saptāhasya prathamadinē 'tipratyūṣē 'ndhakārē tiṣṭhati magdalīnī mariyam tasya śmaśānasya nikaṭaṁ gatvā śmaśānasya mukhāt prastaramapasāritam apaśyat| ");
INSERT INTO saniso_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","paścād dhāvitvā śimōnpitarāya yīśōḥ priyatamaśiṣyāya cēdam akathayat, lōkāḥ śmaśānāt prabhuṁ nītvā kutrāsthāpayan tad vaktuṁ na śaknōmi| ");
INSERT INTO saniso_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","ataḥ pitaraḥ sōnyaśiṣyaśca barhi rbhutvā śmaśānasthānaṁ gantum ārabhētāṁ| ");
INSERT INTO saniso_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ubhayōrdhāvatōḥ sōnyaśiṣyaḥ pitaraṁ paścāt tyaktvā pūrvvaṁ śmaśānasthāna upasthitavān| ");
INSERT INTO saniso_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","tadā prahvībhūya sthāpitavastrāṇi dr̥ṣṭavān kintu na prāviśat| ");
INSERT INTO saniso_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","aparaṁ śimōnpitara āgatya śmaśānasthānaṁ praviśya ");
INSERT INTO saniso_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","sthāpitavastrāṇi mastakasya vastrañca pr̥thak sthānāntarē sthāpitaṁ dr̥ṣṭavān| ");
INSERT INTO saniso_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","tataḥ śmaśānasthānaṁ pūrvvam āgatō yōnyaśiṣyaḥ sōpi praviśya tādr̥śaṁ dr̥ṣṭā vyaśvasīt| ");
INSERT INTO saniso_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","yataḥ śmaśānāt sa utthāpayitavya ētasya dharmmapustakavacanasya bhāvaṁ tē tadā vōddhuṁ nāśankuvan| ");
INSERT INTO saniso_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","anantaraṁ tau dvau śiṣyau svaṁ svaṁ gr̥haṁ parāvr̥tyāgacchatām| ");
INSERT INTO saniso_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","tataḥ paraṁ mariyam śmaśānadvārasya bahiḥ sthitvā rōditum ārabhata tatō rudatī prahvībhūya śmaśānaṁ vilōkya ");
INSERT INTO saniso_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","yīśōḥ śayanasthānasya śiraḥsthānē padatalē ca dvayō rdiśō dvau svargīyadūtāvupaviṣṭau samapaśyat| ");
INSERT INTO saniso_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","tau pr̥ṣṭavantau hē nāri kutō rōdiṣi? sāvadat lōkā mama prabhuṁ nītvā kutrāsthāpayan iti na jānāmi| ");
INSERT INTO saniso_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ityuktvā mukhaṁ parāvr̥tya yīśuṁ daṇḍāyamānam apaśyat kintu sa yīśuriti sā jñātuṁ nāśaknōt| ");
INSERT INTO saniso_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","tadā yīśustām apr̥cchat hē nāri kutō rōdiṣi? kaṁ vā mr̥gayasē? tataḥ sā tam udyānasēvakaṁ jñātvā vyāharat, hē mahēccha tvaṁ yadītaḥ sthānāt taṁ nītavān tarhi kutrāsthāpayastad vada tatsthānāt tam ānayāmi| ");
INSERT INTO saniso_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","tadā yīśustām avadat hē mariyam| tataḥ sā parāvr̥tya pratyavadat hē rabbūnī arthāt hē gurō| ");
INSERT INTO saniso_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","tadā yīśuravadat māṁ mā dhara, idānīṁ pituḥ samīpē ūrddhvagamanaṁ na karōmi kintu yō mama yuṣmākañca pitā mama yuṣmākañcēśvarastasya nikaṭa ūrddhvagamanaṁ karttum udyatōsmi, imāṁ kathāṁ tvaṁ gatvā mama bhrātr̥gaṇaṁ jñāpaya| ");
INSERT INTO saniso_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","tatō magdalīnīmariyam tatkṣaṇād gatvā prabhustasyai darśanaṁ dattvā kathā ētā akathayad iti vārttāṁ śiṣyēbhyō'kathayat| ");
INSERT INTO saniso_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","tataḥ paraṁ saptāhasya prathamadinasya sandhyāsamayē śiṣyā ēkatra militvā yihūdīyēbhyō bhiyā dvāraruddham akurvvan, ētasmin kālē yīśustēṣāṁ madhyasthānē tiṣṭhan akathayad yuṣmākaṁ kalyāṇaṁ bhūyāt| ");
INSERT INTO saniso_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ityuktvā nijahastaṁ kukṣiñca darśitavān, tataḥ śiṣyāḥ prabhuṁ dr̥ṣṭvā hr̥ṣṭā abhavan| ");
INSERT INTO saniso_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","yīśuḥ punaravadad yuṣmākaṁ kalyāṇaṁ bhūyāt pitā yathā māṁ praiṣayat tathāhamapi yuṣmān prēṣayāmi| ");
INSERT INTO saniso_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ityuktvā sa tēṣāmupari dīrghapraśvāsaṁ dattvā kathitavān pavitram ātmānaṁ gr̥hlīta| ");
INSERT INTO saniso_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","yūyaṁ yēṣāṁ pāpāni mōcayiṣyatha tē mōcayiṣyantē yēṣāñca pāpāti na mōcayiṣyatha tē na mōcayiṣyantē| ");
INSERT INTO saniso_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","dvādaśamadhyē gaṇitō yamajō thōmānāmā śiṣyō yīśōrāgamanakālai taiḥ sārddhaṁ nāsīt| ");
INSERT INTO saniso_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","atō vayaṁ prabhūm apaśyāmēti vākyē'nyaśiṣyairuktē sōvadat, tasya hastayō rlauhakīlakānāṁ cihnaṁ na vilōkya taccihnam aṅgulyā na spr̥ṣṭvā tasya kukṣau hastaṁ nārōpya cāhaṁ na viśvasiṣyāmi| ");
INSERT INTO saniso_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","aparam aṣṭamē'hni gatē sati thōmāsahitaḥ śiṣyagaṇa ēkatra militvā dvāraṁ ruddhvābhyantara āsīt, ētarhi yīśustēṣāṁ madhyasthānē tiṣṭhan akathayat, yuṣmākaṁ kuśalaṁ bhūyāt| ");
INSERT INTO saniso_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","paścāt thāmai kathitavān tvam aṅgulīm atrārpayitvā mama karau paśya karaṁ prasāryya mama kukṣāvarpaya nāviśvasya| ");
INSERT INTO saniso_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","tadā thōmā avadat, hē mama prabhō hē madīśvara| ");
INSERT INTO saniso_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","yīśurakathayat, hē thōmā māṁ nirīkṣya viśvasiṣi yē na dr̥ṣṭvā viśvasanti taēva dhanyāḥ| ");
INSERT INTO saniso_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ētadanyāni pustakē'smin alikhitāni bahūnyāścaryyakarmmāṇi yīśuḥ śiṣyāṇāṁ purastād akarōt| ");
INSERT INTO saniso_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","kintu yīśurīśvarasyābhiṣiktaḥ suta ēvēti yathā yūyaṁ viśvasitha viśvasya ca tasya nāmnā paramāyuḥ prāpnutha tadartham ētāni sarvvāṇyalikhyanta| ");
INSERT INTO saniso_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","tataḥ paraṁ tibiriyājaladhēstaṭē yīśuḥ punarapi śiṣyēbhyō darśanaṁ dattavān darśanasyākhyānamidam| ");
INSERT INTO saniso_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","śimōnpitaraḥ yamajathōmā gālīlīyakānnānagaranivāsī nithanēl sivadēḥ putrāvanyau dvau śiṣyau caitēṣvēkatra militēṣu śimōnpitarō'kathayat matsyān dhartuṁ yāmi| ");
INSERT INTO saniso_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","tatastē vyāharan tarhi vayamapi tvayā sārddhaṁ yāmaḥ tadā tē bahirgatāḥ santaḥ kṣipraṁ nāvam ārōhan kintu tasyāṁ rajanyām ēkamapi na prāpnuvan| ");
INSERT INTO saniso_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","prabhātē sati yīśustaṭē sthitavān kintu sa yīśuriti śiṣyā jñātuṁ nāśaknuvan| ");
INSERT INTO saniso_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","tadā yīśurapr̥cchat, hē vatsā sannidhau kiñcit khādyadravyam āstē? tē'vadan kimapi nāsti| ");
INSERT INTO saniso_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","tadā sō'vadat naukāyā dakṣiṇapārśvē jālaṁ nikṣipata tatō lapsyadhvē, tasmāt tai rnikṣiptē jālē matsyā ētāvantō'patan yēna tē jālamākr̥ṣya nōttōlayituṁ śaktāḥ| ");
INSERT INTO saniso_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","tasmād yīśōḥ priyatamaśiṣyaḥ pitarāyākathayat ēṣa prabhu rbhavēt, ēṣa prabhuriti vācaṁ śrutvaiva śimōn nagnatāhētō rmatsyadhāriṇa uttarīyavastraṁ paridhāya hradaṁ pratyudalamphayat| ");
INSERT INTO saniso_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","aparē śiṣyā matsyaiḥ sārddhaṁ jālam ākarṣantaḥ kṣudranaukāṁ vāhayitvā kūlamānayan tē kūlād atidūrē nāsan dviśatahastēbhyō dūra āsan ityanumīyatē| ");
INSERT INTO saniso_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","tīraṁ prāptaistaistatra prajvalitāgnistadupari matsyāḥ pūpāśca dr̥ṣṭāḥ| ");
INSERT INTO saniso_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","tatō yīśurakathayad yān matsyān adharata tēṣāṁ katipayān ānayata| ");
INSERT INTO saniso_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ataḥ śimōnpitaraḥ parāvr̥tya gatvā br̥hadbhistripañcāśadadhikaśatamatsyaiḥ paripūrṇaṁ tajjālam ākr̥ṣyōdatōlayat kintvētāvadbhi rmatsyairapi jālaṁ nāchidyata| ");
INSERT INTO saniso_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","anantaraṁ yīśustān avādīt yūyamāgatya bhuṁgdhvaṁ; tadā saēva prabhuriti jñātatvāt tvaṁ kaḥ? iti praṣṭuṁ śiṣyāṇāṁ kasyāpi pragalbhatā nābhavat| ");
INSERT INTO saniso_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","tatō yīśurāgatya pūpān matsyāṁśca gr̥hītvā tēbhyaḥ paryyavēṣayat| ");
INSERT INTO saniso_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","itthaṁ śmaśānādutthānāt paraṁ yīśuḥ śiṣyēbhyastr̥tīyavāraṁ darśanaṁ dattavān| ");
INSERT INTO saniso_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","bhōjanē samāptē sati yīśuḥ śimōnpitaraṁ pr̥ṣṭavān, hē yūnasaḥ putra śimōn tvaṁ kim ētēbhyōdhikaṁ mayi prīyasē? tataḥ sa uditavān satyaṁ prabhō tvayi prīyē'haṁ tad bhavān jānāti; tadā yīśurakathayat tarhi mama mēṣaśāvakagaṇaṁ pālaya| ");
INSERT INTO saniso_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","tataḥ sa dvitīyavāraṁ pr̥ṣṭavān hē yūnasaḥ putra śimōn tvaṁ kiṁ mayi prīyasē? tataḥ sa uktavān satyaṁ prabhō tvayi prīyē'haṁ tad bhavān jānāti; tadā yīśurakathayata tarhi mama mēṣagaṇaṁ pālaya| ");
INSERT INTO saniso_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","paścāt sa tr̥tīyavāraṁ pr̥ṣṭavān, hē yūnasaḥ putra śimōn tvaṁ kiṁ mayi prīyasē? ētadvākyaṁ tr̥tīyavāraṁ pr̥ṣṭavān tasmāt pitarō duḥkhitō bhūtvā'kathayat hē prabhō bhavataḥ kimapyagōcaraṁ nāsti tvayyahaṁ prīyē tad bhavān jānāti; tatō yīśuravadat tarhi mama mēṣagaṇaṁ pālaya| ");
INSERT INTO saniso_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","ahaṁ tubhyaṁ yathārthaṁ kathayāmi yauvanakālē svayaṁ baddhakaṭi ryatrēcchā tatra yātavān kintvitaḥ paraṁ vr̥ddhē vayasi hastaṁ vistārayiṣyasi, anyajanastvāṁ baddhvā yatra gantuṁ tavēcchā na bhavati tvāṁ dhr̥tvā tatra nēṣyati| ");
INSERT INTO saniso_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","phalataḥ kīdr̥śēna maraṇēna sa īśvarasya mahimānaṁ prakāśayiṣyati tad bōdhayituṁ sa iti vākyaṁ prōktavān| ityuktē sati sa tamavōcat mama paścād āgaccha| ");
INSERT INTO saniso_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","yō janō rātrikālē yīśō rvakṣō'valambya, hē prabhō kō bhavantaṁ parakarēṣu samarpayiṣyatīti vākyaṁ pr̥ṣṭavān, taṁ yīśōḥ priyatamaśiṣyaṁ paścād āgacchantaṁ ");
INSERT INTO saniso_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","pitarō mukhaṁ parāvarttya vilōkya yīśuṁ pr̥ṣṭavān, hē prabhō ētasya mānavasya kīdr̥śī gati rbhaviṣyati? ");
INSERT INTO saniso_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","sa pratyavadat, mama punarāgamanaparyyantaṁ yadi taṁ sthāpayitum icchāmi tatra tava kiṁ? tvaṁ mama paścād āgaccha| ");
INSERT INTO saniso_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","tasmāt sa śiṣyō na mariṣyatīti bhrātr̥gaṇamadhyē kiṁvadantī jātā kintu sa na mariṣyatīti vākyaṁ yīśu rnāvadat kēvalaṁ mama punarāgamanaparyyantaṁ yadi taṁ sthāpayitum icchāmi tatra tava kiṁ? iti vākyam uktavān| ");
INSERT INTO saniso_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","yō jana ētāni sarvvāṇi likhitavān atra sākṣyañca dattavān saēva sa śiṣyaḥ, tasya sākṣyaṁ pramāṇamiti vayaṁ jānīmaḥ| ");
INSERT INTO saniso_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","yīśurētēbhyō'parāṇyapi bahūni karmmāṇi kr̥tavān tāni sarvvāṇi yadyēkaikaṁ kr̥tvā likhyantē tarhi granthā ētāvantō bhavanti tēṣāṁ dhāraṇē pr̥thivyāṁ sthānaṁ na bhavati| iti||");
INSERT INTO saniso_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","hē thiyaphila, yīśuḥ svamanōnītān prēritān pavitrēṇātmanā samādiśya yasmin dinē svargamārōhat yāṁ yāṁ kriyāmakarōt yadyad upādiśacca tāni sarvvāṇi pūrvvaṁ mayā likhitāni| ");
INSERT INTO saniso_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","sa svanidhanaduḥkhabhōgāt param anēkapratyayakṣapramāṇauḥ svaṁ sajīvaṁ darśayitvā ");
INSERT INTO saniso_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","catvāriṁśaddināni yāvat tēbhyaḥ prēritēbhyō darśanaṁ dattvēśvarīyarājyasya varṇanama akarōt| ");
INSERT INTO saniso_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","anantaraṁ tēṣāṁ sabhāṁ kr̥tvā ityājñāpayat, yūyaṁ yirūśālamō'nyatra gamanamakr̥tvā yastin pitrāṅgīkr̥tē mama vadanāt kathā aśr̥ṇuta tatprāptim apēkṣya tiṣṭhata| ");
INSERT INTO saniso_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","yōhan jalē majjitāvān kintvalpadinamadhyē yūyaṁ pavitra ātmani majjitā bhaviṣyatha| ");
INSERT INTO saniso_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","paścāt tē sarvvē militvā tam apr̥cchan hē prabhō bhavān kimidānīṁ punarapi rājyam isrāyēlīyalōkānāṁ karēṣu samarpayiṣyati? ");
INSERT INTO saniso_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","tataḥ sōvadat yān sarvvān kālān samayāṁśca pitā svavaśē'sthāpayat tān jñātr̥ṁ yuṣmākam adhikārō na jāyatē| ");
INSERT INTO saniso_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","kintu yuṣmāsu pavitrasyātmana āvirbhāvē sati yūyaṁ śaktiṁ prāpya yirūśālami samastayihūdāśōmirōṇadēśayōḥ pr̥thivyāḥ sīmāṁ yāvad yāvantō dēśāstēṣu yarvvēṣu ca mayi sākṣyaṁ dāsyatha| ");
INSERT INTO saniso_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","iti vākyamuktvā sa tēṣāṁ samakṣaṁ svargaṁ nītō'bhavat, tatō mēghamāruhya tēṣāṁ dr̥ṣṭēragōcarō'bhavat| ");
INSERT INTO saniso_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","yasmin samayē tē vihāyasaṁ pratyananyadr̥ṣṭyā tasya tādr̥śam ūrdvvagamanam apaśyan tasminnēva samayē śuklavastrau dvau janau tēṣāṁ sannidhau daṇḍāyamānau kathitavantau, ");
INSERT INTO saniso_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","hē gālīlīyalōkā yūyaṁ kimarthaṁ gagaṇaṁ prati nirīkṣya daṇḍāyamānāstiṣṭhatha? yuṣmākaṁ samīpāt svargaṁ nītō yō yīśustaṁ yūyaṁ yathā svargam ārōhantam adarśam tathā sa punaścāgamiṣyati| ");
INSERT INTO saniso_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","tataḥ paraṁ tē jaitunanāmnaḥ parvvatād viśrāmavārasya pathaḥ parimāṇam arthāt prāyēṇārddhakrōśaṁ durasthaṁ yirūśālamnagaraṁ parāvr̥tyāgacchan| ");
INSERT INTO saniso_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","nagaraṁ praviśya pitarō yākūb yōhan āndriyaḥ philipaḥ thōmā barthajamayō mathirālphīyaputrō yākūb udyōgāी śimōn yākūbō bhrātā yihūdā ētē sarvvē yatra sthānē pravasanti tasmin uparitanaprakōṣṭhē prāviśan| ");
INSERT INTO saniso_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","paścād imē kiyatyaḥ striyaśca yīśō rmātā mariyam tasya bhrātaraścaitē sarvva ēkacittībhūta satataṁ vinayēna vinayēna prārthayanta| ");
INSERT INTO saniso_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","tasmin samayē tatra sthānē sākalyēna viṁśatyadhikaśataṁ śiṣyā āsan| tataḥ pitarastēṣāṁ madhyē tiṣṭhan uktavān ");
INSERT INTO saniso_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","hē bhrātr̥gaṇa yīśudhāriṇāṁ lōkānāṁ pathadarśakō yō yihūdāstasmin dāyūdā pavitra ātmā yāṁ kathāṁ kathayāmāsa tasyāḥ pratyakṣībhavanasyāvaśyakatvam āsīt| ");
INSERT INTO saniso_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","sa janō'smākaṁ madhyavarttī san asyāḥ sēvāyā aṁśam alabhata| ");
INSERT INTO saniso_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","tadanantaraṁ kukarmmaṇā labdhaṁ yanmūlyaṁ tēna kṣētramēkaṁ krītam aparaṁ tasmin adhōmukhē bhr̥mau patitē sati tasyōdarasya vidīrṇatvāt sarvvā nāḍyō niragacchan| ");
INSERT INTO saniso_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ētāṁ kathāṁ yirūśālamnivāsinaḥ sarvvē lōkā vidānti; tēṣāṁ nijabhāṣayā tatkṣētrañca hakaldāmā, arthāt raktakṣētramiti vikhyātamāstē| ");
INSERT INTO saniso_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","anyacca, nikētanaṁ tadīyantu śunyamēva bhaviṣyati| tasya dūṣyē nivāsārthaṁ kōpi sthāsyati naiva hi| anya ēva janastasya padaṁ saṁprāpsyati dhruvaṁ| itthaṁ gītapustakē likhitamāstē| ");
INSERT INTO saniso_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","atō yōhanō majjanam ārabhyāsmākaṁ samīpāt prabhō ryīśōḥ svargārōhaṇadinaṁ yāvat sōsmākaṁ madhyē yāvanti dināni yāpitavān ");
INSERT INTO saniso_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","tāvanti dināni yē mānavā asmābhiḥ sārddhaṁ tiṣṭhanti tēṣām ēkēna janēnāsmābhiḥ sārddhaṁ yīśōrutthānē sākṣiṇā bhavitavyaṁ| ");
INSERT INTO saniso_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","atō yasya rūḍhi ryuṣṭō yaṁ barśabbētyuktvāhūyanti sa yūṣaph matathiśca dvāvētau pr̥thak kr̥tvā ta īśvarasya sannidhau prāryya kathitavantaḥ, ");
INSERT INTO saniso_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","hē sarvvāntaryyāmin paramēśvara, yihūdāḥ sēvanaprēritatvapadacyutaḥ ");
INSERT INTO saniso_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","san nijasthānam agacchat, tatpadaṁ labdhum ēnayō rjanayō rmadhyē bhavatā kō'bhirucitastadasmān darśyatāṁ| ");
INSERT INTO saniso_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","tatō guṭikāpāṭē kr̥tē matathirniracīyata tasmāt sōnyēṣām ēkādaśānāṁ praritānāṁ madhyē gaṇitōbhavat| ");
INSERT INTO saniso_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","aparañca nistārōtsavāt paraṁ pañcāśattamē dinē samupasthitē sati tē sarvvē ēkācittībhūya sthāna ēkasmin militā āsan| ");
INSERT INTO saniso_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ētasminnēva samayē'kasmād ākāśāt pracaṇḍātyugravāyōḥ śabdavad ēkaḥ śabda āgatya yasmin gr̥hē ta upāviśan tad gr̥haṁ samastaṁ vyāpnōt| ");
INSERT INTO saniso_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","tataḥ paraṁ vahniśikhāsvarūpā jihvāḥ pratyakṣībhūya vibhaktāḥ satyaḥ pratijanōrddhvē sthagitā abhūvan| ");
INSERT INTO saniso_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","tasmāt sarvvē pavitrēṇātmanā paripūrṇāḥ santa ātmā yathā vācitavān tadanusārēṇānyadēśīyānāṁ bhāṣā uktavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","tasmin samayē pr̥thivīsthasarvvadēśēbhyō yihūdīyamatāvalambinō bhaktalōkā yirūśālami prāvasan; ");
INSERT INTO saniso_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","tasyāḥ kathāyāḥ kiṁvadantyā jātatvāt sarvvē lōkā militvā nijanijabhāṣayā śiṣyāṇāṁ kathākathanaṁ śrutvā samudvignā abhavan| ");
INSERT INTO saniso_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","sarvvaēva vismayāpannā āścaryyānvitāśca santaḥ parasparaṁ uktavantaḥ paśyata yē kathāṁ kathayanti tē sarvvē gālīlīyalōkāḥ kiṁ na bhavanti? ");
INSERT INTO saniso_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","tarhi vayaṁ pratyēkaśaḥ svasvajanmadēśīyabhāṣābhiḥ kathā ētēṣāṁ śr̥ṇumaḥ kimidaṁ? ");
INSERT INTO saniso_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","pārthī-mādī-arāmnaharayimdēśanivāsimanō yihūdā-kappadakiyā-panta-āśiyā- ");
INSERT INTO saniso_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","phrugiyā-pamphuliyā-misaranivāsinaḥ kurīṇīnikaṭavarttilūbīyapradēśanivāsinō rōmanagarād āgatā yihūdīyalōkā yihūdīyamatagrāhiṇaḥ krītīyā arābīyādayō lōkāśca yē vayam ");
INSERT INTO saniso_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","asmākaṁ nijanijabhāṣābhirētēṣām īśvarīyamahākarmmavyākhyānaṁ śr̥ṇumaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","itthaṁ tē sarvvaēva vismayāpannāḥ sandigdhacittāḥ santaḥ parasparamūcuḥ, asya kō bhāvaḥ? ");
INSERT INTO saniso_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","aparē kēcit parihasya kathitavanta ētē navīnadrākṣārasēna mattā abhavan| ");
INSERT INTO saniso_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","tadā pitara ēkādaśabhi rjanaiḥ sākaṁ tiṣṭhan tāllōkān uccaiḥkāram avadat, hē yihūdīyā hē yirūśālamnivāsinaḥ sarvvē, avadhānaṁ kr̥tvā madīyavākyaṁ budhyadhvaṁ| ");
INSERT INTO saniso_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","idānīm ēkayāmād adhikā vēlā nāsti tasmād yūyaṁ yad anumātha mānavā imē madyapānēna mattāstanna| ");
INSERT INTO saniso_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","kintu yōyēlbhaviṣyadvaktraitadvākyamuktaṁ yathā, ");
INSERT INTO saniso_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","īśvaraḥ kathayāmāsa yugāntasamayē tvaham| varṣiṣyāmi svamātmānaṁ sarvvaprāṇyupari dhruvam| bhāvivākyaṁ vadiṣyanti kanyāḥ putrāśca vastutaḥ|pratyādēśañca prāpsyanti yuṣmākaṁ yuvamānavāḥ| tathā prācīnalōkāstu svapnān drakṣyanti niścitaṁ| ");
INSERT INTO saniso_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","varṣiṣyāmi tadātmānaṁ dāsadāsījanōpiri| tēnaiva bhāvivākyaṁ tē vadiṣyanti hi sarvvaśaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ūrddhvasthē gagaṇē caiva nīcasthē pr̥thivītalē| śōṇitāni br̥hadbhānūn ghanadhūmādikāni ca| cihnāni darśayiṣyāmi mahāścaryyakriyāstathā| ");
INSERT INTO saniso_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","mahābhayānakasyaiva taddinasya parēśituḥ| purāgamād raviḥ kr̥ṣṇō raktaścandrō bhaviṣyataḥ| ");
INSERT INTO saniso_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","kintu yaḥ paramēśasya nāmni samprārthayiṣyatē| saēva manujō nūnaṁ paritrātō bhaviṣyati|| ");
INSERT INTO saniso_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","atō hē isrāyēlvaṁśīyalōkāḥ sarvvē kathāyāmētasyām manō nidhaddhvaṁ nāsaratīyō yīśurīśvarasya manōnītaḥ pumān ētad īśvarastatkr̥tairāścaryyādbhutakarmmabhi rlakṣaṇaiśca yuṣmākaṁ sākṣādēva pratipāditavān iti yūyaṁ jānītha| ");
INSERT INTO saniso_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","tasmin yīśau īśvarasya pūrvvaniścitamantraṇānirūpaṇānusārēṇa mr̥tyau samarpitē sati yūyaṁ taṁ dhr̥tvā duṣṭalōkānāṁ hastaiḥ kruśē vidhitvāhata| ");
INSERT INTO saniso_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","kintvīśvarastaṁ nidhanasya bandhanānmōcayitvā udasthāpayat yataḥ sa mr̥tyunā baddhastiṣṭhatīti na sambhavati| ");
INSERT INTO saniso_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ētastin dāyūdapi kathitavān yathā, sarvvadā mama sākṣāttaṁ sthāpaya paramēśvaraṁ| sthitē maddakṣiṇē tasmin skhaliṣyāmi tvahaṁ nahi| ");
INSERT INTO saniso_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ānandiṣyati taddhētō rmāmakīnaṁ manastu vai| āhlādiṣyati jihvāpi madīyā tu tathaiva ca| pratyāśayā śarīrantu madīyaṁ vaiśayiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","paralōkē yatō hētōstvaṁ māṁ naiva hi tyakṣyasi| svakīyaṁ puṇyavantaṁ tvaṁ kṣayituṁ naiva dāsyasi| ēvaṁ jīvanamārgaṁ tvaṁ māmēva darśayiṣyasi| ");
INSERT INTO saniso_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","svasammukhē ya ānandō dakṣiṇē svasya yat sukhaṁ| anantaṁ tēna māṁ pūrṇaṁ kariṣyasi na saṁśayaḥ|| ");
INSERT INTO saniso_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","hē bhrātarō'smākaṁ tasya pūrvvapuruṣasya dāyūdaḥ kathāṁ spaṣṭaṁ kathayituṁ mām anumanyadhvaṁ, sa prāṇān tyaktvā śmaśānē sthāpitōbhavad adyāpi tat śmaśānam asmākaṁ sannidhau vidyatē| ");
INSERT INTO saniso_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","phalatō laukikabhāvēna dāyūdō vaṁśē khrīṣṭaṁ janma grāhayitvā tasyaiva siṁhāsanē samuvēṣṭuṁ tamutthāpayiṣyati paramēśvaraḥ śapathaṁ kutvā dāyūdaḥ samīpa imam aṅgīkāraṁ kr̥tavān, ");
INSERT INTO saniso_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","iti jñātvā dāyūd bhaviṣyadvādī san bhaviṣyatkālīyajñānēna khrīṣṭōtthānē kathāmimāṁ kathayāmāsa yathā tasyātmā paralōkē na tyakṣyatē tasya śarīrañca na kṣēṣyati; ");
INSERT INTO saniso_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","ataḥ paramēśvara ēnaṁ yīśuṁ śmaśānād udasthāpayat tatra vayaṁ sarvvē sākṣiṇa āsmahē| ");
INSERT INTO saniso_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","sa īśvarasya dakṣiṇakarēṇōnnatiṁ prāpya pavitra ātmina pitā yamaṅgīkāraṁ kr̥tavān tasya phalaṁ prāpya yat paśyatha śr̥ṇutha ca tadavarṣat| ");
INSERT INTO saniso_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","yatō dāyūd svargaṁ nārurōha kintu svayam imāṁ kathām akathayad yathā, mama prabhumidaṁ vākyamavadat paramēśvaraḥ| ");
INSERT INTO saniso_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","tava śatrūnahaṁ yāvat pādapīṭhaṁ karōmi na| tāvat kālaṁ madīyē tvaṁ dakṣavārśva upāviśa| ");
INSERT INTO saniso_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","atō yaṁ yīśuṁ yūyaṁ kruśē'hata paramēśvarastaṁ prabhutvābhiṣiktatvapadē nyayuṁktēti isrāyēlīyā lōkā niścitaṁ jānantu| ");
INSERT INTO saniso_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ētādr̥śīṁ kathāṁ śrutvā tēṣāṁ hr̥dayānāṁ vidīrṇatvāt tē pitarāya tadanyaprēritēbhyaśca kathitavantaḥ, hē bhrātr̥gaṇa vayaṁ kiṁ kariṣyāmaḥ? ");
INSERT INTO saniso_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","tataḥ pitaraḥ pratyavadad yūyaṁ sarvvē svaṁ svaṁ manaḥ parivarttayadhvaṁ tathā pāpamōcanārthaṁ yīśukhrīṣṭasya nāmnā majjitāśca bhavata, tasmād dānarūpaṁ paritram ātmānaṁ lapsyatha| ");
INSERT INTO saniso_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","yatō yuṣmākaṁ yuṣmatsantānānāñca dūrasthasarvvalōkānāñca nimittam arthād asmākaṁ prabhuḥ paramēśvarō yāvatō lākān āhvāsyati tēṣāṁ sarvvēṣāṁ nimittam ayamaṅgīkāra āstē| ");
INSERT INTO saniso_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ētadanyābhi rbahukathābhiḥ pramāṇaṁ datvākathayat ētēbhyō vipathagāmibhyō varttamānalōkēbhyaḥ svān rakṣata| ");
INSERT INTO saniso_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","tataḥ paraṁ yē sānandāstāṁ kathām agr̥hlan tē majjitā abhavan| tasmin divasē prāyēṇa trīṇi sahasrāṇi lōkāstēṣāṁ sapakṣāḥ santaḥ ");
INSERT INTO saniso_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","prēritānām upadēśē saṅgatau pūpabhañjanē prārthanāsu ca manaḥsaṁyōgaṁ kr̥tvātiṣṭhan| ");
INSERT INTO saniso_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","prēritai rnānāprakāralakṣaṇēṣu mahāścaryyakarmamasu ca darśitēṣu sarvvalōkānāṁ bhayamupasthitaṁ| ");
INSERT INTO saniso_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","viśvāsakāriṇaḥ sarvva ca saha tiṣṭhanataḥ| svēṣāṁ sarvvāḥ sampattīḥ sādhāraṇyēna sthāpayitvābhuñjata| ");
INSERT INTO saniso_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","phalatō gr̥hāṇi dravyāṇi ca sarvvāṇi vikrīya sarvvēṣāṁ svasvaprayōjanānusārēṇa vibhajya sarvvēbhyō'dadan| ");
INSERT INTO saniso_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","sarvva ēkacittībhūya dinē dinē mandirē santiṣṭhamānā gr̥hē gr̥hē ca pūpānabhañjanta īśvarasya dhanyavādaṁ kurvvantō lōkaiḥ samādr̥tāḥ paramānandēna saralāntaḥkaraṇēna bhōjanaṁ pānañcakurvvan| ");
INSERT INTO saniso_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","paramēśvarō dinē dinē paritrāṇabhājanai rmaṇḍalīm avarddhayat| ");
INSERT INTO saniso_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","tr̥tīyayāmavēlāyāṁ satyāṁ prārthanāyāḥ samayē pitarayōhanau sambhūya mandiraṁ gacchataḥ| ");
INSERT INTO saniso_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","tasminnēva samayē mandirapravēśakānāṁ samīpē bhikṣāraṇārthaṁ yaṁ janmakhañjamānuṣaṁ lōkā mandirasya sundaranāmni dvārē pratidinam asthāpayan taṁ vahantastadvāraṁ ānayan| ");
INSERT INTO saniso_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","tadā pitarayōhanau mantiraṁ pravēṣṭum udyatau vilōkya sa khañjastau kiñcid bhikṣitavān| ");
INSERT INTO saniso_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","tasmād yōhanā sahitaḥ pitarastam ananyadr̥ṣṭyā nirīkṣya prōktavān āvāṁ prati dr̥ṣṭiṁ kuru| ");
INSERT INTO saniso_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","tataḥ sa kiñcit prāptyāśayā tau prati dr̥ṣṭiṁ kr̥tavān| ");
INSERT INTO saniso_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","tadā pitarō gaditavān mama nikaṭē svarṇarūpyādi kimapi nāsti kintu yadāstē tad dadāmi nāsaratīyasya yīśukhrīṣṭasya nāmnā tvamutthāya gamanāgamanē kuru| ");
INSERT INTO saniso_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","tataḥ paraṁ sa tasya dakṣiṇakaraṁ dhr̥tvā tam udatōlayat; tēna tatkṣaṇāt tasya janasya pādagulphayōḥ sabalatvāt sa ullamphya prōtthāya gamanāgamanē 'karōt| ");
INSERT INTO saniso_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","tatō gamanāgamanē kurvvan ullamphan īśvaraṁ dhanyaṁ vadan tābhyāṁ sārddhaṁ mandiraṁ prāviśat| ");
INSERT INTO saniso_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","tataḥ sarvvē lōkāstaṁ gamanāgamanē kurvvantam īśvaraṁ dhanyaṁ vadantañca vilōkya ");
INSERT INTO saniso_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","mandirasya sundarē dvārē ya upaviśya bhikṣitavān saēvāyam iti jñātvā taṁ prati tayā ghaṭanayā camatkr̥tā vismayāpannāścābhavan| ");
INSERT INTO saniso_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","yaḥ khañjaḥ svasthōbhavat tēna pitarayōhanōḥ karayōrdhṭatayōḥ satōḥ sarvvē lōkā sannidhim āgacchan| ");
INSERT INTO saniso_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","tad dr̥ṣṭvā pitarastēbhyō'kathayat, hē isrāyēlīyalōkā yūyaṁ kutō 'nēnāścaryyaṁ manyadhvē? āvāṁ nijaśaktyā yadvā nijapuṇyēna khañjamanuṣyamēnaṁ gamitavantāviti cintayitvā āvāṁ prati kutō'nanyadr̥ṣṭiṁ kurutha? ");
INSERT INTO saniso_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","yaṁ yīśuṁ yūyaṁ parakarēṣu samārpayata tatō yaṁ pīlātō mōcayitum ēैcchat tathāpi yūyaṁ tasya sākṣān nāṅgīkr̥tavanta ibrāhīma ishākō yākūbaścēśvarō'rthād asmākaṁ pūrvvapuruṣāṇām īśvaraḥ svaputrasya tasya yīśō rmahimānaṁ prākāśayat| ");
INSERT INTO saniso_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","kintu yūyaṁ taṁ pavitraṁ dhārmmikaṁ pumāṁsaṁ nāṅgīkr̥tya hatyākāriṇamēkaṁ svēbhyō dātum ayācadhvaṁ| ");
INSERT INTO saniso_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","paścāt taṁ jīvanasyādhipatim ahata kintvīśvaraḥ śmaśānāt tam udasthāpayata tatra vayaṁ sākṣiṇa āsmahē| ");
INSERT INTO saniso_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","imaṁ yaṁ mānuṣaṁ yūyaṁ paśyatha paricinutha ca sa tasya nāmni viśvāsakaraṇāt calanaśaktiṁ labdhavān tasmin tasya yō viśvāsaḥ sa taṁ yuṣmākaṁ sarvvēṣāṁ sākṣāt sampūrṇarūpēṇa svastham akārṣīt| ");
INSERT INTO saniso_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","hē bhrātarō yūyaṁ yuṣmākam adhipatayaśca ajñātvā karmmāṇyētāni kr̥tavanta idānīṁ mamaiṣa bōdhō jāyatē| ");
INSERT INTO saniso_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","kintvīśvaraḥ khrīṣṭasya duḥkhabhōgē bhaviṣyadvādināṁ mukhēbhyō yāṁ yāṁ kathāṁ pūrvvamakathayat tāḥ kathā itthaṁ siddhā akarōt| ");
INSERT INTO saniso_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","ataḥ svēṣāṁ pāpamōcanārthaṁ khēdaṁ kr̥tvā manāṁsi parivarttayadhvaṁ, tasmād īśvarāt sāntvanāprāptēḥ samaya upasthāsyati; ");
INSERT INTO saniso_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","punaśca pūrvvakālam ārabhya pracāritō yō yīśukhrīṣṭastam īśvarō yuṣmān prati prēṣayiṣyati| ");
INSERT INTO saniso_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","kintu jagataḥ sr̥ṣṭimārabhya īśvarō nijapavitrabhaviṣyadvādigaṇōna yathā kathitavān tadanusārēṇa sarvvēṣāṁ kāryyāṇāṁ siddhiparyyantaṁ tēna svargē vāsaḥ karttavyaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","yuṣmākaṁ prabhuḥ paramēśvarō yuṣmākaṁ bhrātr̥gaṇamadhyāt matsadr̥śaṁ bhaviṣyadvaktāram utpādayiṣyati, tataḥ sa yat kiñcit kathayiṣyati tatra yūyaṁ manāṁsi nidhaddhvaṁ| ");
INSERT INTO saniso_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","kintu yaḥ kaścit prāṇī tasya bhaviṣyadvādinaḥ kathāṁ na grahīṣyati sa nijalōkānāṁ madhyād ucchētsyatē,\" imāṁ kathām asmākaṁ pūrvvapuruṣēbhyaḥ kēvalō mūsāḥ kathayāmāsa iti nahi, ");
INSERT INTO saniso_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","śimūyēlbhaviṣyadvādinam ārabhya yāvantō bhaviṣyadvākyam akathayan tē sarvvaēva samayasyaitasya kathām akathayan| ");
INSERT INTO saniso_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","yūyamapi tēṣāṁ bhaviṣyadvādināṁ santānāḥ, \"tava vaṁśōdbhavapuṁsā sarvvadēśīyā lōkā āśiṣaṁ prāptā bhaviṣyanti\", ibrāhīmē kathāmētāṁ kathayitvā īśvarōsmākaṁ pūrvvapuruṣaiḥ sārddhaṁ yaṁ niyamaṁ sthirīkr̥tavān tasya niyamasyādhikāriṇōpi yūyaṁ bhavatha| ");
INSERT INTO saniso_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ata īśvarō nijaputraṁ yīśum utthāpya yuṣmākaṁ sarvvēṣāṁ svasvapāpāt parāvarttya yuṣmabhyam āśiṣaṁ dātuṁ prathamatastaṁ yuṣmākaṁ nikaṭaṁ prēṣitavān| ");
INSERT INTO saniso_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","yasmin samayē pitarayōhanau lōkān upadiśatastasmin samayē yājakā mandirasya sēnāpatayaḥ sidūkīgaṇaśca ");
INSERT INTO saniso_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","tayōr upadēśakaraṇē khrīṣṭasyōtthānam upalakṣya sarvvēṣāṁ mr̥tānām utthānaprastāvē ca vyagrāḥ santastāvupāgaman| ");
INSERT INTO saniso_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","tau dhr̥tvā dināvasānakāraṇāt paradinaparyyanantaṁ ruddhvā sthāpitavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","tathāpi yē lōkāstayōrupadēśam aśr̥ṇvan tēṣāṁ prāyēṇa pañcasahasrāṇi janā vyaśvasan| ");
INSERT INTO saniso_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","parē'hani adhipatayaḥ prācīnā adhyāpakāśca hānananāmā mahāyājakaḥ ");
INSERT INTO saniso_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","kiyaphā yōhan sikandara ityādayō mahāyājakasya jñātayaḥ sarvvē yirūśālamnagarē militāḥ| ");
INSERT INTO saniso_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","anantaraṁ prēritau madhyē sthāpayitvāpr̥cchan yuvāṁ kayā śaktayā vā kēna nāmnā karmmāṇyētāni kuruthaḥ? ");
INSERT INTO saniso_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","tadā pitaraḥ pavitrēṇātmanā paripūrṇaḥ san pratyavādīt, hē lōkānām adhipatigaṇa hē isrāyēlīyaprācīnāḥ, ");
INSERT INTO saniso_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ētasya durbbalamānuṣasya hitaṁ yat karmmākriyata, arthāt, sa yēna prakārēṇa svasthōbhavat taccēd adyāvāṁ pr̥cchatha, ");
INSERT INTO saniso_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","tarhi sarvva isrāyēेlīyalōkā yūyaṁ jānīta nāsaratīyō yō yīśukhrīṣṭaḥ kruśē yuṣmābhiravidhyata yaścēśvarēṇa śmaśānād utthāpitaḥ, tasya nāmnā janōyaṁ svasthaḥ san yuṣmākaṁ sammukhē prōttiṣṭhati| ");
INSERT INTO saniso_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","nicētr̥bhi ryuṣmābhirayaṁ yaḥ prastarō'vajñātō'bhavat sa pradhānakōṇasya prastarō'bhavat| ");
INSERT INTO saniso_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","tadbhinnādaparāt kasmādapi paritrāṇaṁ bhavituṁ na śaknōti, yēna trāṇaṁ prāpyēta bhūmaṇḍalasyalōkānāṁ madhyē tādr̥śaṁ kimapi nāma nāsti| ");
INSERT INTO saniso_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","tadā pitarayōhanōrētādr̥śīm akṣēbhatāṁ dr̥ṣṭvā tāvavidvāṁsau nīcalōkāviti buddhvā āścaryyam amanyanta tau ca yīśōḥ saṅginau jātāviti jñātum aśaknuvan| ");
INSERT INTO saniso_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","kintu tābhyāṁ sārddhaṁ taṁ svasthamānuṣaṁ tiṣṭhantaṁ dr̥ṣṭvā tē kāmapyaparām āpattiṁ karttaṁ nāśaknun| ");
INSERT INTO saniso_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","tadā tē sabhātaḥ sthānāntaraṁ gantuṁ tān ājñāpya svayaṁ parasparam iti mantraṇāmakurvvan ");
INSERT INTO saniso_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","tau mānavau prati kiṁ karttavyaṁ? tāvēkaṁ prasiddham āścaryyaṁ karmma kr̥tavantau tad yirūśālamnivāsināṁ sarvvēṣāṁ lōkānāṁ samīpē prākāśata tacca vayamapahnōtuṁ na śaknumaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","kintu lōkānāṁ madhyam ētad yathā na vyāpnōti tadarthaṁ tau bhayaṁ pradarśya tēna nāmnā kamapi manuṣyaṁ nōpadiśatam iti dr̥ḍhaṁ niṣēdhāmaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","tatastē prēritāvāhūya ētadājñāpayan itaḥ paraṁ yīśō rnāmnā kadāpi kāmapi kathāṁ mā kathayataṁ kimapi nōpadiśañca| ");
INSERT INTO saniso_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","tataḥ pitarayōhanau pratyavadatām īśvarasyājñāgrahaṇaṁ vā yuṣmākam ājñāgrahaṇam ētayō rmadhyē īśvarasya gōcarē kiṁ vihitaṁ? yūyaṁ tasya vivēcanāṁ kuruta| ");
INSERT INTO saniso_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","vayaṁ yad apaśyāma yadaśr̥ṇuma ca tanna pracārayiṣyāma ētat kadāpi bhavituṁ na śaknōti| ");
INSERT INTO saniso_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","yadaghaṭata tad dr̥ṣṭā sarvvē lōkā īśvarasya guṇān anvavadan tasmāt lōkabhayāt tau daṇḍayituṁ kamapyupāyaṁ na prāpya tē punarapi tarjayitvā tāvatyajan| ");
INSERT INTO saniso_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","yasya mānuṣasyaitat svāsthyakaraṇam āścaryyaṁ karmmākriyata tasya vayaścatvāriṁśadvatsarā vyatītāḥ| ");
INSERT INTO saniso_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","tataḥ paraṁ tau visr̥ṣṭau santau svasaṅgināṁ sannidhiṁ gatvā pradhānayājakaiḥ prācīnalōkaiśca prōktāḥ sarvvāḥ kathā jñāpitavantau| ");
INSERT INTO saniso_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","tacchrutvā sarvva ēkacittībhūya īśvaramuddiśya prōccairētat prārthayanta, hē prabhō gagaṇapr̥thivīpayōdhīnāṁ tēṣu ca yadyad āstē tēṣāṁ sraṣṭēśvarastvaṁ| ");
INSERT INTO saniso_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","tvaṁ nijasēvakēna dāyūdā vākyamidam uvacitha, manuṣyā anyadēśīyāḥ kurvvanti kalahaṁ kutaḥ| lōkāḥ sarvvē kimarthaṁ vā cintāṁ kurvvanti niṣphalāṁ| ");
INSERT INTO saniso_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","paramēśasya tēnaivābhiṣiktasya janasya ca| viruddhamabhitiṣṭhanti pr̥thivyāḥ patayaḥ kutaḥ|| ");
INSERT INTO saniso_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","phalatastava hastēna mantraṇayā ca pūrvva yadyat sthirīkr̥taṁ tad yathā siddhaṁ bhavati tadarthaṁ tvaṁ yam athiṣiktavān sa ēva pavitrō yīśustasya prātikūlyēna hērōd pantīyapīlātō ");
INSERT INTO saniso_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","'nyadēśīyalōkā isrāyēllōkāśca sarvva ētē sabhāyām atiṣṭhan| ");
INSERT INTO saniso_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","hē paramēśvara adhunā tēṣāṁ tarjanaṁ garjanañca śr̥ṇu; ");
INSERT INTO saniso_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","tathā svāsthyakaraṇakarmmaṇā tava bāhubalaprakāśapūrvvakaṁ tava sēvakān nirbhayēna tava vākyaṁ pracārayituṁ tava pavitraputrasya yīśō rnāmnā āścaryyāṇyasambhavāni ca karmmāṇi karttuñcājñāpaya| ");
INSERT INTO saniso_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","itthaṁ prārthanayā yatra sthānē tē sabhāyām āsan tat sthānaṁ prākampata; tataḥ sarvvē pavitrēṇātmanā paripūrṇāḥ santa īśvarasya kathām akṣōbhēṇa prācārayan| ");
INSERT INTO saniso_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","aparañca pratyayakārilōkasamūhā ēkamanasa ēkacittībhūya sthitāḥ| tēṣāṁ kēpi nijasampattiṁ svīyāṁ nājānan kintu tēṣāṁ sarvvāḥ sampattyaḥ sādhāraṇyēna sthitāḥ| ");
INSERT INTO saniso_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","anyacca prēritā mahāśaktiprakāśapūrvvakaṁ prabhō ryīśōrutthānē sākṣyam adaduḥ, tēṣu sarvvēṣu mahānugrahō'bhavacca| ");
INSERT INTO saniso_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","tēṣāṁ madhyē kasyāpi dravyanyūnatā nābhavad yatastēṣāṁ gr̥habhūmyādyā yāḥ sampattaya āsan tā vikrīya ");
INSERT INTO saniso_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","tanmūlyamānīya prēritānāṁ caraṇēṣu taiḥ sthāpitaṁ; tataḥ pratyēkaśaḥ prayōjanānusārēṇa dattamabhavat| ");
INSERT INTO saniso_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","viśēṣataḥ kuprōpadvīpīyō yōsināmakō lēvivaṁśajāta ēkō janō bhūmyadhikārī, yaṁ prēritā barṇabbā arthāt sāntvanādāyaka ityuktvā samāhūyan, ");
INSERT INTO saniso_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","sa janō nijabhūmiṁ vikrīya tanmūlyamānīya prēritānāṁ caraṇēṣu sthāpitavān| ");
INSERT INTO saniso_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","tadā anāniyanāmaka ēkō janō yasya bhāryyāyā nāma saphīrā sa svādhikāraṁ vikrīya ");
INSERT INTO saniso_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","svabhāryyāṁ jñāpayitvā tanmūlyasyaikāṁśaṁ saṅgōpya sthāpayitvā tadanyāṁśamātramānīya prēritānāṁ caraṇēṣu samarpitavān| ");
INSERT INTO saniso_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","tasmāt pitarōkathayat hē anāniya bhūmē rmūlyaṁ kiñcit saṅgōpya sthāpayituṁ pavitrasyātmanaḥ sannidhau mr̥ṣāvākyaṁ kathayituñca śaitān kutastavāntaḥkaraṇē pravr̥ttimajanayat? ");
INSERT INTO saniso_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","sā bhūmi ryadā tava hastagatā tadā kiṁ tava svīyā nāsīt? tarhi svāntaḥkaraṇē kuta ētādr̥śī kukalpanā tvayā kr̥tā? tvaṁ kēvalamanuṣyasya nikaṭē mr̥ṣāvākyaṁ nāvādīḥ kintvīśvarasya nikaṭē'pi| ");
INSERT INTO saniso_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ētāṁ kathāṁ śrutvaiva sō'nāniyō bhūmau patan prāṇān atyajat, tadvr̥ttāntaṁ yāvantō lōkā aśr̥ṇvan tēṣāṁ sarvvēṣāṁ mahābhayam ajāyat| ");
INSERT INTO saniso_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","tadā yuvalōkāstaṁ vastrēṇācchādya bahi rnītvā śmaśānē'sthāpayan| ");
INSERT INTO saniso_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","tataḥ praharaikānantaraṁ kiṁ vr̥ttaṁ tannāvagatya tasya bhāryyāpi tatra samupasthitā| ");
INSERT INTO saniso_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","tataḥ pitarastām apr̥cchat, yuvābhyām ētāvanmudrābhyō bhūmi rvikrītā na vā? ētatvaṁ vada; tadā sā pratyavādīt satyam ētāvadbhyō mudrābhya ēva| ");
INSERT INTO saniso_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","tataḥ pitarōkathayat yuvāṁ kathaṁ paramēśvarasyātmānaṁ parīkṣitum ēkamantraṇāvabhavatāṁ? paśya yē tava patiṁ śmaśānē sthāpitavantastē dvārasya samīpē samupatiṣṭhanti tvāmapi bahirnēṣyanti| ");
INSERT INTO saniso_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","tataḥ sāpi tasya caraṇasannidhau patitvā prāṇān atyākṣīt| paścāt tē yuvānō'bhyantaram āgatya tāmapi mr̥tāṁ dr̥ṣṭvā bahi rnītvā tasyāḥ patyuḥ pārśvē śmaśānē sthāpitavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","tasmāt maṇḍalyāḥ sarvvē lōkā anyalōkāśca tāṁ vārttāṁ śrutvā sādhvasaṁ gatāḥ| ");
INSERT INTO saniso_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","tataḥ paraṁ prēritānāṁ hastai rlōkānāṁ madhyē bahvāścaryyāṇyadbhutāni karmmāṇyakriyanta; tadā śiṣyāḥ sarvva ēkacittībhūya sulēmānō 'lindē sambhūyāsan| ");
INSERT INTO saniso_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","tēṣāṁ saṅghāntargō bhavituṁ kōpi pragalbhatāṁ nāgamat kintu lōkāstān samādriyanta| ");
INSERT INTO saniso_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","striyaḥ puruṣāśca bahavō lōkā viśvāsya prabhuṁ śaraṇamāpannāḥ| ");
INSERT INTO saniso_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","pitarasya gamanāgamanābhyāṁ kēnāpi prakārēṇa tasya chāyā kasmiṁścijjanē lagiṣyatītyāśayā lōkā rōgiṇaḥ śivikayā khaṭvayā cānīya pathi pathi sthāpitavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","caturdiksthanagarēbhyō bahavō lōkāḥ sambhūya rōgiṇō'pavitrabhutagrastāṁśca yirūśālamam ānayan tataḥ sarvvē svasthā akriyanta| ");
INSERT INTO saniso_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","anantaraṁ mahāyājakaḥ sidūkināṁ matagrāhiṇastēṣāṁ sahacarāśca ");
INSERT INTO saniso_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","mahākrōdhāntvitāḥ santaḥ prēritān dhr̥tvā nīcalōkānāṁ kārāyāṁ baddhvā sthāpitavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","kintu rātrau paramēśvarasya dūtaḥ kārāyā dvāraṁ mōcayitvā tān bahirānīyākathayat, ");
INSERT INTO saniso_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","yūyaṁ gatvā mandirē daṇḍāyamānāḥ santō lōkān pratīmāṁ jīvanadāyikāṁ sarvvāṁ kathāṁ pracārayata| ");
INSERT INTO saniso_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","iti śrutvā tē pratyūṣē mandira upasthāya upadiṣṭavantaḥ| tadā sahacaragaṇēna sahitō mahāyājaka āgatya mantrigaṇam isrāyēlvaṁśasya sarvvān rājasabhāsadaḥ sabhāsthān kr̥tvā kārāyāstān āpayituṁ padātigaṇaṁ prēritavān| ");
INSERT INTO saniso_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","tatastē gatvā kārāyāṁ tān aprāpya pratyāgatya iti vārttām avādiṣuḥ, ");
INSERT INTO saniso_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","vayaṁ tatra gatvā nirvvighnaṁ kārāyā dvāraṁ ruddhaṁ rakṣakāṁśca dvārasya bahirdaṇḍāyamānān adarśāma ēva kintu dvāraṁ mōcayitvā tanmadhyē kamapi draṣṭuṁ na prāptāḥ| ");
INSERT INTO saniso_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ētāṁ kathāṁ śrutvā mahāyājakō mandirasya sēnāpatiḥ pradhānayājakāśca, ita paraṁ kimaparaṁ bhaviṣyatīti cintayitvā sandigdhacittā abhavan| ");
INSERT INTO saniso_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ētasminnēva samayē kaścit jana āgatya vārttāmētām avadat paśyata yūyaṁ yān mānavān kārāyām asthāpayata tē mandirē tiṣṭhantō lōkān upadiśanti| ");
INSERT INTO saniso_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","tadā mandirasya sēnāpatiḥ padātayaśca tatra gatvā cēllōkāḥ pāṣāṇān nikṣipyāsmān mārayantīti bhiyā vinatyācāraṁ tān ānayan| ");
INSERT INTO saniso_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","tē mahāsabhāyā madhyē tān asthāpayan tataḥ paraṁ mahāyājakastān apr̥cchat, ");
INSERT INTO saniso_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","anēna nāmnā samupadēṣṭuṁ vayaṁ kiṁ dr̥ḍhaṁ na nyaṣēdhāma? tathāpi paśyata yūyaṁ svēṣāṁ tēnōpadēśēnē yirūśālamaṁ paripūrṇaṁ kr̥tvā tasya janasya raktapātajanitāparādham asmān pratyānētuṁ cēṣṭadhvē| ");
INSERT INTO saniso_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","tataḥ pitarōnyaprēritāśca pratyavadan mānuṣasyājñāgrahaṇād īśvarasyājñāgrahaṇam asmākamucitam| ");
INSERT INTO saniso_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","yaṁ yīśuṁ yūyaṁ kruśē vēdhitvāhata tam asmākaṁ paitr̥ka īśvara utthāpya ");
INSERT INTO saniso_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","isrāyēlvaṁśānāṁ manaḥparivarttanaṁ pāpakṣamāñca karttuṁ rājānaṁ paritrātārañca kr̥tvā svadakṣiṇapārśvē tasyānnatim akarōt| ");
INSERT INTO saniso_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ētasmin vayamapi sākṣiṇa āsmahē, tat kēvalaṁ nahi, īśvara ājñāgrāhibhyō yaṁ pavitram ātmanaṁ dattavān sōpi sākṣyasti| ");
INSERT INTO saniso_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","ētadvākyē śrutē tēṣāṁ hr̥dayāni viddhānyabhavan tatastē tān hantuṁ mantritavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ētasminnēva samayē tatsabhāsthānāṁ sarvvalōkānāṁ madhyē sukhyātō gamilīyēlnāmaka ēkō janō vyavasthāpakaḥ phirūśilōka utthāya prēritān kṣaṇārthaṁ sthānāntaraṁ gantum ādiśya kathitavān, ");
INSERT INTO saniso_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","hē isrāyēlvaṁśīyāḥ sarvvē yūyam ētān mānuṣān prati yat karttum udyatāstasmin sāvadhānā bhavata| ");
INSERT INTO saniso_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","itaḥ pūrvvaṁ thūdānāmaikō jana upasthāya svaṁ kamapi mahāpuruṣam avadat, tataḥ prāyēṇa catuḥśatalōkāstasya matagrāhiṇōbhavan paścāt sa hatōbhavat tasyājñāgrāhiṇō yāvantō lōkāstē sarvvē virkīrṇāḥ santō 'kr̥takāryyā abhavan| ");
INSERT INTO saniso_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","tasmājjanāt paraṁ nāmalēkhanasamayē gālīlīyayihūdānāmaikō jana upasthāya bahūllōkān svamataṁ grāhītavān tataḥ sōpi vyanaśyat tasyājñāgrāhiṇō yāvantō lōkā āsan tē sarvvē vikīrṇā abhavan| ");
INSERT INTO saniso_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","adhunā vadāmi, yūyam ētān manuṣyān prati kimapi na kr̥tvā kṣāntā bhavata, yata ēṣa saṅkalpa ētat karmma ca yadi manuṣyādabhavat tarhi viphalaṁ bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","yadīśvarādabhavat tarhi yūyaṁ tasyānyathā karttuṁ na śakṣyatha, varam īśvararōdhakā bhaviṣyatha| ");
INSERT INTO saniso_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","tadā tasya mantraṇāṁ svīkr̥tya tē prēritān āhūya prahr̥tya yīśō rnāmnā kāmapi kathāṁ kathayituṁ niṣidhya vyasarjan| ");
INSERT INTO saniso_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","kintu tasya nāmārthaṁ vayaṁ lajjābhōgasya yōgyatvēna gaṇitā ityatra tē sānandāḥ santaḥ sabhāsthānāṁ sākṣād agacchan| ");
INSERT INTO saniso_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","tataḥ paraṁ pratidinaṁ mandirē gr̥hē gr̥hē cāviśrāmam upadiśya yīśukhrīṣṭasya susaṁvādaṁ pracāritavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","tasmin samayē śiṣyāṇāṁ bāhulyāt prātyahikadānasya viśrāṇanai rbhinnadēśīyānāṁ vidhavāstrīgaṇa upēkṣitē sati ibrīyalōkaiḥ sahānyadēśīyānāṁ vivāda upātiṣṭhat| ");
INSERT INTO saniso_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","tadā dvādaśaprēritāḥ sarvvān śiṣyān saṁgr̥hyākathayan īśvarasya kathāpracāraṁ parityajya bhōjanagavēṣaṇam asmākam ucitaṁ nahi| ");
INSERT INTO saniso_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","atō hē bhrātr̥gaṇa vayam ētatkarmmaṇō bhāraṁ yēbhyō dātuṁ śaknuma ētādr̥śān sukhyātyāpannān pavitrēṇātmanā jñānēna ca pūrṇān sapprajanān yūyaṁ svēṣāṁ madhyē manōnītān kuruta, ");
INSERT INTO saniso_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","kintu vayaṁ prārthanāyāṁ kathāpracārakarmmaṇi ca nityapravr̥ttāḥ sthāsyāmaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ētasyāṁ kathāyāṁ sarvvē lōkāḥ santuṣṭāḥ santaḥ svēṣāṁ madhyāt stiphānaḥ philipaḥ prakharō nikānōr tīman parmmiṇā yihūdimatagrāhī-āntiyakhiyānagarīyō nikalā ētān paramabhaktān pavitrēṇātmanā paripūrṇān sapta janān ");
INSERT INTO saniso_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","prēritānāṁ samakṣam ānayan, tatastē prārthanāṁ kr̥tvā tēṣāṁ śiraḥsu hastān ārpayan| ");
INSERT INTO saniso_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","aparañca īśvarasya kathā dēśaṁ vyāpnōt viśēṣatō yirūśālami nagarē śiṣyāṇāṁ saṁkhyā prabhūtarūpēṇāvarddhata yājakānāṁ madhyēpi bahavaḥ khrīṣṭamatagrāhiṇō'bhavan| ");
INSERT INTO saniso_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","stiphānōे viśvāsēna parākramēṇa ca paripūrṇaḥ san lōkānāṁ madhyē bahuvidham adbhutam āścaryyaṁ karmmākarōt| ");
INSERT INTO saniso_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","tēna libarttinīyanāmnā vikhyātasaṅghasya katipayajanāḥ kurīṇīyasikandarīya-kilikīyāśīyādēśīyāḥ kiyantō janāścōtthāya stiphānēna sārddhaṁ vyavadanta| ");
INSERT INTO saniso_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","kintu stiphānō jñānēna pavitrēṇātmanā ca īdr̥śīṁ kathāṁ kathitavān yasyāstē āpattiṁ karttuṁ nāśaknuvan| ");
INSERT INTO saniso_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","paścāt tai rlōbhitāḥ katipayajanāḥ kathāmēnām akathayan, vayaṁ tasya mukhatō mūsā īśvarasya ca nindāvākyam aśrauṣma| ");
INSERT INTO saniso_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","tē lōkānāṁ lōkaprācīnānām adhyāpakānāñca pravr̥ttiṁ janayitvā stiphānasya sannidhim āgatya taṁ dhr̥tvā mahāsabhāmadhyam ānayan| ");
INSERT INTO saniso_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","tadanantaraṁ katipayajanēṣu mithyāsākṣiṣu samānītēṣu tē'kathayan ēṣa jana ētatpuṇyasthānavyavasthayō rnindātaḥ kadāpi na nivarttatē| ");
INSERT INTO saniso_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","phalatō nāsaratīyayīśuḥ sthānamētad ucchinnaṁ kariṣyati mūsāsamarpitam asmākaṁ vyavaharaṇam anyarūpaṁ kariṣyati tasyaitādr̥śīṁ kathāṁ vayam aśr̥ṇuma| ");
INSERT INTO saniso_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","tadā mahāsabhāsthāḥ sarvvē taṁ prati sthirāṁ dr̥ṣṭiṁ kr̥tvā svargadūtamukhasadr̥śaṁ tasya mukham apaśyan| ");
INSERT INTO saniso_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","tataḥ paraṁ mahāyājakaḥ pr̥ṣṭavān, ēṣā kathāṁ kiṁ satyā? ");
INSERT INTO saniso_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","tataḥ sa pratyavadat, hē pitarō hē bhrātaraḥ sarvvē lākā manāṁsi nidhaddhvaṁ|asmākaṁ pūrvvapuruṣa ibrāhīm hāraṇnagarē vāsakaraṇāt pūrvvaṁ yadā arām-naharayimadēśē āsīt tadā tējōmaya īśvarō darśanaṁ datvā ");
INSERT INTO saniso_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","tamavadat tvaṁ svadēśajñātimitrāṇi parityajya yaṁ dēśamahaṁ darśayiṣyāmi taṁ dēśaṁ vraja| ");
INSERT INTO saniso_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","ataḥ sa kasdīyadēśaṁ vihāya hāraṇnagarē nyavasat, tadanantaraṁ tasya pitari mr̥tē yatra dēśē yūyaṁ nivasatha sa ēnaṁ dēśamāgacchat| ");
INSERT INTO saniso_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","kintvīśvarastasmai kamapyadhikāram arthād ēkapadaparimitāṁ bhūmimapi nādadāt; tadā tasya kōpi santānō nāsīt tathāpi santānaiḥ sārddham ētasya dēśasyādhikārī tvaṁ bhaviṣyasīti tampratyaṅgīkr̥tavān| ");
INSERT INTO saniso_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","īśvara ittham aparamapi kathitavān tava santānāḥ paradēśē nivatsyanti tatastaddēśīyalōkāścatuḥśatavatsarān yāvat tān dāsatvē sthāpayitvā tān prati kuvyavahāraṁ kariṣyanti| ");
INSERT INTO saniso_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","aparam īśvara ēnāṁ kathāmapi kathitavān, yē lōkāstān dāsatvē sthāpayiṣyanti tāllōkān ahaṁ daṇḍayiṣyāmi, tataḥ paraṁ tē bahirgatāḥ santō mām atra sthānē sēviṣyantē| ");
INSERT INTO saniso_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","paścāt sa tasmai tvakchēdasya niyamaṁ dattavān, ata ishākanāmni ibrāhīma ēkaputrē jātē, aṣṭamadinē tasya tvakchēdam akarōt| tasya ishākaḥ putrō yākūb, tatastasya yākūbō'smākaṁ dvādaśa pūrvvapuruṣā ajāyanta| ");
INSERT INTO saniso_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","tē pūrvvapuruṣā īrṣyayā paripūrṇā misaradēśaṁ prēṣayituṁ yūṣaphaṁ vyakrīṇan| ");
INSERT INTO saniso_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","kintvīśvarastasya sahāyō bhūtvā sarvvasyā durgatē rakṣitvā tasmai buddhiṁ dattvā misaradēśasya rājñaḥ phirauṇaḥ priyapātraṁ kr̥tavān tatō rājā misaradēśasya svīyasarvvaparivārasya ca śāsanapadaṁ tasmai dattavān| ");
INSERT INTO saniso_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","tasmin samayē misara-kinānadēśayō rdurbhikṣahētōratikliṣṭatvāt naḥ pūrvvapuruṣā bhakṣyadravyaṁ nālabhanta| ");
INSERT INTO saniso_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","kintu misaradēśē śasyāni santi, yākūb imāṁ vārttāṁ śrutvā prathamam asmākaṁ pūrvvapuruṣān misaraṁ prēṣitavān| ");
INSERT INTO saniso_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","tatō dvitīyavāragamanē yūṣaph svabhrātr̥bhiḥ paricitō'bhavat; yūṣaphō bhrātaraḥ phirauṇ rājēna paricitā abhavan| ");
INSERT INTO saniso_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","anantaraṁ yūṣaph bhrātr̥gaṇaṁ prēṣya nijapitaraṁ yākūbaṁ nijān pañcādhikasaptatisaṁkhyakān jñātijanāṁśca samāhūtavān| ");
INSERT INTO saniso_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","tasmād yākūb misaradēśaṁ gatvā svayam asmākaṁ pūrvvapuruṣāśca tasmin sthānē'mriyanta| ");
INSERT INTO saniso_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","tatastē śikhimaṁ nītā yat śmaśānam ibrāhīm mudrādatvā śikhimaḥ pitu rhamōraḥ putrēbhyaḥ krītavān tatśmaśānē sthāpayāñcakrirē| ");
INSERT INTO saniso_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","tataḥ param īśvara ibrāhīmaḥ sannidhau śapathaṁ kr̥tvā yāṁ pratijñāṁ kr̥tavān tasyāḥ pratijñāyāḥ phalanasamayē nikaṭē sati isrāyēllōkā simaradēśē varddhamānā bahusaṁkhyā abhavan| ");
INSERT INTO saniso_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","śēṣē yūṣaphaṁ yō na paricinōti tādr̥śa ēkō narapatirupasthāya ");
INSERT INTO saniso_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","asmākaṁ jñātibhiḥ sārddhaṁ dhūrttatāṁ vidhāya pūrvvapuruṣān prati kuvyavaharaṇapūrvvakaṁ tēṣāṁ vaṁśanāśanāya tēṣāṁ navajātān śiśūn bahi rnirakṣēpayat| ");
INSERT INTO saniso_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","ētasmin samayē mūsā jajñē, sa tu paramasundarō'bhavat tathā pitr̥gr̥hē māsatrayaparyyantaṁ pālitō'bhavat| ");
INSERT INTO saniso_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","kintu tasmin bahirnikṣiptē sati phirauṇarājasya kanyā tam uttōlya nītvā dattakaputraṁ kr̥tvā pālitavatī| ");
INSERT INTO saniso_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","tasmāt sa mūsā misaradēśīyāyāḥ sarvvavidyāyāḥ pāradr̥ṣvā san vākyē kriyāyāñca śaktimān abhavat| ");
INSERT INTO saniso_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","sa sampūrṇacatvāriṁśadvatsaravayaskō bhūtvā isrāyēlīyavaṁśanijabhrātr̥n sākṣāt kartuṁ matiṁ cakrē| ");
INSERT INTO saniso_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","tēṣāṁ janamēkaṁ hiṁsitaṁ dr̥ṣṭvā tasya sapakṣaḥ san hiṁsitajanam upakr̥tya misarīyajanaṁ jaghāna| ");
INSERT INTO saniso_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","tasya hastēnēśvarastān uddhariṣyati tasya bhrātr̥gaṇa iti jñāsyati sa ityanumānaṁ cakāra, kintu tē na bubudhirē| ");
INSERT INTO saniso_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","tatparē 'hani tēṣām ubhayō rjanayō rvākkalaha upasthitē sati mūsāḥ samīpaṁ gatvā tayō rmēlanaṁ karttuṁ matiṁ kr̥tvā kathayāmāsa, hē mahāśayau yuvāṁ bhrātarau parasparam anyāyaṁ kutaḥ kuruthaḥ? ");
INSERT INTO saniso_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","tataḥ samīpavāsinaṁ prati yō janō'nyāyaṁ cakāra sa taṁ dūrīkr̥tya kathayāmāsa, asmākamupari śāstr̥tvavicārayitr̥tvapadayōḥ kastvāṁ niyuktavān? ");
INSERT INTO saniso_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","hyō yathā misarīyaṁ hatavān tathā kiṁ māmapi haniṣyasi? ");
INSERT INTO saniso_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","tadā mūsā ētādr̥śīṁ kathāṁ śrutvā palāyanaṁ cakrē, tatō midiyanadēśaṁ gatvā pravāsī san tasthau, tatastatra dvau putrau jajñātē| ");
INSERT INTO saniso_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","anantaraṁ catvāriṁśadvatsarēṣu gatēṣu sīnayaparvvatasya prāntarē prajvalitastambasya vahniśikhāyāṁ paramēśvaradūtastasmai darśanaṁ dadau| ");
INSERT INTO saniso_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","mūsāstasmin darśanē vismayaṁ matvā viśēṣaṁ jñātuṁ nikaṭaṁ gacchati, ");
INSERT INTO saniso_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","ētasmin samayē, ahaṁ tava pūrvvapuruṣāṇām īśvarō'rthād ibrāhīma īśvara ishāka īśvarō yākūba īśvaraśca, mūsāmuddiśya paramēśvarasyaitādr̥śī vihāyasīyā vāṇī babhūva, tataḥ sa kampānvitaḥ san puna rnirīkṣituṁ pragalbhō na babhūva| ");
INSERT INTO saniso_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","paramēśvarastaṁ jagāda, tava pādayōḥ pādukē mōcaya yatra tiṣṭhasi sā pavitrabhūmiḥ| ");
INSERT INTO saniso_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ahaṁ misaradēśasthānāṁ nijalōkānāṁ durddaśāṁ nitāntam apaśyaṁ, tēṣāṁ kātaryyōktiñca śrutavān tasmāt tān uddharttum avaruhyāgamam; idānīm āgaccha misaradēśaṁ tvāṁ prēṣayāmi| ");
INSERT INTO saniso_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","kastvāṁ śāstr̥tvavicārayitr̥tvapadayō rniyuktavān, iti vākyamuktvā tai ryō mūsā avajñātastamēva īśvaraḥ stambamadhyē darśanadātrā tēna dūtēna śāstāraṁ muktidātārañca kr̥tvā prēṣayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","sa ca misaradēśē sūphnāmni samudrē ca paścāt catvāriṁśadvatsarān yāvat mahāprāntarē nānāprakārāṇyadbhutāni karmmāṇi lakṣaṇāni ca darśayitvā tān bahiḥ kr̥tvā samānināya| ");
INSERT INTO saniso_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","prabhuḥ paramēśvarō yuṣmākaṁ bhrātr̥gaṇasya madhyē mādr̥śam ēkaṁ bhaviṣyadvaktāram utpādayiṣyati tasya kathāyāṁ yūyaṁ manō nidhāsyatha, yō jana isrāyēlaḥ santānēbhya ēnāṁ kathāṁ kathayāmāsa sa ēṣa mūsāḥ| ");
INSERT INTO saniso_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","mahāprāntarasthamaṇḍalīmadhyē'pi sa ēva sīnayaparvvatōpari tēna sārddhaṁ saṁlāpinō dūtasya cāsmatpitr̥gaṇasya madhyasthaḥ san asmabhyaṁ dātavyani jīvanadāyakāni vākyāni lēbhē| ");
INSERT INTO saniso_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","asmākaṁ pūrvvapuruṣāstam amānyaṁ katvā svēbhyō dūrīkr̥tya misaradēśaṁ parāvr̥tya gantuṁ manōbhirabhilaṣya hārōṇaṁ jagaduḥ, ");
INSERT INTO saniso_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","asmākam agrē'grē gantuुm asmadarthaṁ dēvagaṇaṁ nirmmāhi yatō yō mūsā asmān misaradēśād bahiḥ kr̥tvānītavān tasya kiṁ jātaṁ tadasmābhi rna jñāyatē| ");
INSERT INTO saniso_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","tasmin samayē tē gōvatsākr̥tiṁ pratimāṁ nirmmāya tāmuddiśya naivēdyamutmr̥jya svahastakr̥tavastunā ānanditavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","tasmād īśvarastēṣāṁ prati vimukhaḥ san ākāśasthaṁ jyōtirgaṇaṁ pūjayituṁ tēbhyō'numatiṁ dadau, yādr̥śaṁ bhaviṣyadvādināṁ granthēṣu likhitamāstē, yathā, isrāyēlīyavaṁśā rē catvāriṁśatsamān purā| mahati prāntarē saṁsthā yūyantu yāni ca| balihōmādikarmmāṇi kr̥tavantastu tāni kiṁ| māṁ samuddiśya yuṣmābhiḥ prakr̥tānīti naiva ca| ");
INSERT INTO saniso_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","kintu vō mōlakākhyasya dēvasya dūṣyamēva ca| yuṣmākaṁ rimphanākhyāyā dēvatāyāśca tārakā| ētayōrubhayō rmūrtī yuṣmābhiḥ paripūjitē| atō yuṣmāṁstu bābēlaḥ pāraṁ nēṣyāmi niścitaṁ| ");
INSERT INTO saniso_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","aparañca yannidarśanam apaśyastadanusārēṇa dūṣyaṁ nirmmāhi yasmin īśvarō mūsām ētadvākyaṁ babhāṣē tat tasya nirūpitaṁ sākṣyasvarūpaṁ dūṣyam asmākaṁ pūrvvapuruṣaiḥ saha prāntarē tasthau| ");
INSERT INTO saniso_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","paścāt yihōśūyēna sahitaistēṣāṁ vaṁśajātairasmatpūrvvapuruṣaiḥ svēṣāṁ sammukhād īśvarēṇa dūrīkr̥tānām anyadēśīyānāṁ dēśādhikr̥tikālē samānītaṁ tad dūṣyaṁ dāyūdōdhikāraṁ yāvat tatra sthāna āsīt| ");
INSERT INTO saniso_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","sa dāyūd paramēśvarasyānugrahaṁ prāpya yākūb īśvarārtham ēkaṁ dūṣyaṁ nirmmātuṁ vavāñcha; ");
INSERT INTO saniso_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","kintu sulēmān tadarthaṁ mandiram ēkaṁ nirmmitavān| ");
INSERT INTO saniso_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","tathāpi yaḥ sarvvōparisthaḥ sa kasmiṁścid hastakr̥tē mandirē nivasatīti nahi, bhaviṣyadvādī kathāmētāṁ kathayati, yathā, ");
INSERT INTO saniso_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","parēśō vadati svargō rājasiṁhāsanaṁ mama| madīyaṁ pādapīṭhañca pr̥thivī bhavati dhruvaṁ| tarhi yūyaṁ kr̥tē mē kiṁ pranirmmāsyatha mandiraṁ| viśrāmāya madīyaṁ vā sthānaṁ kiṁ vidyatē tviha| ");
INSERT INTO saniso_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","sarvvāṇyētāni vastūni kiṁ mē hastakr̥tāni na|| ");
INSERT INTO saniso_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","hē anājñāgrāhakā antaḥkaraṇē śravaṇē cāpavitralōkāḥ yūyam anavarataṁ pavitrasyātmanaḥ prātikūlyam ācaratha, yuṣmākaṁ pūrvvapuruṣā yādr̥śā yūyamapi tādr̥śāḥ| ");
INSERT INTO saniso_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","yuṣmākaṁ pūrvvapuruṣāḥ kaṁ bhaviṣyadvādinaṁ nātāḍayan? yē tasya dhārmmikasya janasyāgamanakathāṁ kathitavantastān aghnan yūyam adhūnā viśvāsaghātinō bhūtvā taṁ dhārmmikaṁ janam ahata| ");
INSERT INTO saniso_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","yūyaṁ svargīyadūtagaṇēna vyavasthāṁ prāpyāpi tāṁ nācaratha| ");
INSERT INTO saniso_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","imāṁ kathāṁ śrutvā tē manaḥsu biddhāḥ santastaṁ prati dantagharṣaṇam akurvvan| ");
INSERT INTO saniso_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","kintu stiphānaḥ pavitrēṇātmanā pūrṇō bhūtvā gagaṇaṁ prati sthiradr̥ṣṭiṁ kr̥tvā īśvarasya dakṣiṇē daṇḍāyamānaṁ yīśuñca vilōkya kathitavān; ");
INSERT INTO saniso_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","paśya,mēghadvāraṁ muktam īśvarasya dakṣiṇē sthitaṁ mānavasutañca paśyāmi| ");
INSERT INTO saniso_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","tadā tē prōccaiḥ śabdaṁ kr̥tvā karṇēṣvaṅgulī rnidhāya ēkacittībhūya tam ākraman| ");
INSERT INTO saniso_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","paścāt taṁ nagarād bahiḥ kr̥tvā prastarairāghnan sākṣiṇō lākāḥ śaulanāmnō yūnaścaraṇasannidhau nijavastrāṇi sthāpitavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","anantaraṁ hē prabhō yīśē madīyamātmānaṁ gr̥hāṇa stiphānasyēti prārthanavākyavadanasamayē tē taṁ prastarairāghnan| ");
INSERT INTO saniso_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","tasmāt sa jānunī pātayitvā prōccaiḥ śabdaṁ kr̥tvā, hē prabhē pāpamētad ētēṣu mā sthāpaya, ityuktvā mahānidrāṁ prāpnōt| ");
INSERT INTO saniso_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","tasya hatyākaraṇaṁ śaulōpi samamanyata| tasmin samayē yirūśālamnagarasthāṁ maṇḍalīṁ prati mahātāḍanāyāṁ jātāyāṁ prēritalōkān hitvā sarvvē'parē yihūdāśōmirōṇadēśayō rnānāsthānē vikīrṇāḥ santō gatāḥ| ");
INSERT INTO saniso_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","anyacca bhaktalōkāstaṁ stiphānaṁ śmaśānē sthāpayitvā bahu vyalapan| ");
INSERT INTO saniso_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","kintu śaulō gr̥hē gr̥hē bhramitvā striyaḥ puruṣāṁśca dhr̥tvā kārāyāṁ baddhvā maṇḍalyā mahōtpātaṁ kr̥tavān| ");
INSERT INTO saniso_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","anyacca yē vikīrṇā abhavan tē sarvvatra bhramitvā susaṁvādaṁ prācārayan| ");
INSERT INTO saniso_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","tadā philipaḥ śōmirōṇnagaraṁ gatvā khrīṣṭākhyānaṁ prācārayat; ");
INSERT INTO saniso_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","tatō'śuci-bhr̥tagrastalōkēbhyō bhūtāścītkr̥tyāgacchan tathā bahavaḥ pakṣāghātinaḥ khañjā lōkāśca svasthā abhavan| ");
INSERT INTO saniso_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","tasmāt lākā īdr̥śaṁ tasyāścaryyaṁ karmma vilōkya niśamya ca sarvva ēkacittībhūya tēnōktākhyānē manāṁsi nyadadhuḥ| ");
INSERT INTO saniso_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","tasminnagarē mahānandaścābhavat| ");
INSERT INTO saniso_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","tataḥ pūrvvaṁ tasminnagarē śimōnnāmā kaścijjanō bahvī rmāyākriyāḥ kr̥tvā svaṁ kañcana mahāpuruṣaṁ prōcya śōmirōṇīyānāṁ mōhaṁ janayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","tasmāt sa mānuṣa īśvarasya mahāśaktisvarūpa ityuktvā bālavr̥ddhavanitāḥ sarvvē lākāstasmin manāṁsi nyadadhuḥ| ");
INSERT INTO saniso_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","sa bahukālān māyāvikriyayā sarvvān atīva mōhayāñcakāra, tasmāt tē taṁ mēnirē| ");
INSERT INTO saniso_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","kintvīśvarasya rājyasya yīśukhrīṣṭasya nāmnaścākhyānapracāriṇaḥ philipasya kathāyāṁ viśvasya tēṣāṁ strīpuruṣōbhayalōkā majjitā abhavan| ");
INSERT INTO saniso_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","śēṣē sa śimōnapi svayaṁ pratyait tatō majjitaḥ san philipēna kr̥tām āścaryyakriyāṁ lakṣaṇañca vilōkyāsambhavaṁ manyamānastēna saha sthitavān| ");
INSERT INTO saniso_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","itthaṁ śōmirōṇdēśīyalōkā īśvarasya kathām agr̥hlan iti vārttāṁ yirūśālamnagarasthaprēritāḥ prāpya pitaraṁ yōhanañca tēṣāṁ nikaṭē prēṣitavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","tatastau tat sthānam upasthāya lōkā yathā pavitram ātmānaṁ prāpnuvanti tadarthaṁ prārthayētāṁ| ");
INSERT INTO saniso_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","yatastē purā kēvalaprabhuyīśō rnāmnā majjitamātrā abhavan, na tu tēṣāṁ madhyē kamapi prati pavitrasyātmana āvirbhāvō jātaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","kintu prēritābhyāṁ tēṣāṁ gātrēṣu karēṣvarpitēṣu satsu tē pavitram ātmānam prāpnuvan| ");
INSERT INTO saniso_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","itthaṁ lōkānāṁ gātrēṣu prēritayōḥ karārpaṇēna tān pavitram ātmānaṁ prāptān dr̥ṣṭvā sa śimōn tayōḥ samīpē mudrā ānīya kathitavān; ");
INSERT INTO saniso_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ahaṁ yasya gātrē hastam arpayiṣyāmi tasyāpi yathētthaṁ pavitrātmaprāpti rbhavati tādr̥śīṁ śaktiṁ mahyaṁ dattaṁ| ");
INSERT INTO saniso_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","kintu pitarastaṁ pratyavadat tava mudrāstvayā vinaśyantu yata īśvarasya dānaṁ mudrābhiḥ krīyatē tvamitthaṁ buddhavān; ");
INSERT INTO saniso_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","īśvarāya tāvantaḥkaraṇaṁ saralaṁ nahi, tasmād atra tavāṁśō'dhikāraśca kōpi nāsti| ");
INSERT INTO saniso_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ata ētatpāpahētōḥ khēdānvitaḥ san kēnāpi prakārēṇa tava manasa ētasyāḥ kukalpanāyāḥ kṣamā bhavati, ētadartham īśvarē prārthanāṁ kuru; ");
INSERT INTO saniso_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","yatastvaṁ tiktapittē pāpasya bandhanē ca yadasi tanmayā buddham| ");
INSERT INTO saniso_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","tadā śimōn akathayat tarhi yuvābhyāmuditā kathā mayi yathā na phalati tadarthaṁ yuvāṁ mannimittaṁ prabhau prārthanāṁ kurutaṁ| ");
INSERT INTO saniso_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","anēna prakārēṇa tau sākṣyaṁ dattvā prabhōḥ kathāṁ pracārayantau śōmirōṇīyānām anēkagrāmēṣu susaṁvādañca pracārayantau yirūśālamnagaraṁ parāvr̥tya gatau| ");
INSERT INTO saniso_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","tataḥ param īśvarasya dūtaḥ philipam ityādiśat, tvamutthāya dakṣiṇasyāṁ diśi yō mārgō prāntarasya madhyēna yirūśālamō 'sānagaraṁ yāti taṁ mārgaṁ gaccha| ");
INSERT INTO saniso_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","tataḥ sa utthāya gatavān; tadā kandākīnāmnaḥ kūślōkānāṁ rājñyāḥ sarvvasampattēradhīśaḥ kūśadēśīya ēkaḥ ṣaṇḍō bhajanārthaṁ yirūśālamnagaram āgatya ");
INSERT INTO saniso_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","punarapi rathamāruhya yiśayiyanāmnō bhaviṣyadvādinō granthaṁ paṭhan pratyāgacchati| ");
INSERT INTO saniso_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ētasmin samayē ātmā philipam avadat, tvam rathasya samīpaṁ gatvā tēna sārddhaṁ mila| ");
INSERT INTO saniso_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","tasmāt sa dhāvan tasya sannidhāvupasthāya tēna paṭhyamānaṁ yiśayiyathaviṣyadvādinō vākyaṁ śrutvā pr̥ṣṭavān yat paṭhasi tat kiṁ budhyasē? ");
INSERT INTO saniso_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","tataḥ sa kathitavān kēnacinna bōdhitōhaṁ kathaṁ budhyēya? tataḥ sa philipaṁ rathamārōḍhuṁ svēna sārddham upavēṣṭuñca nyavēdayat| ");
INSERT INTO saniso_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","sa śāstrasyētadvākyaṁ paṭhitavān yathā, samānīyata ghātāya sa yathā mēṣaśāvakaḥ| lōmacchēdakasākṣācca mēṣaśca nīravō yathā| ābadhya vadanaṁ svīyaṁ tathā sa samatiṣṭhata| ");
INSERT INTO saniso_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","anyāyēna vicārēṇa sa ucchinnō 'bhavat tadā| tatkālīnamanuṣyān kō janō varṇayituṁ kṣamaḥ| yatō jīvannr̥ṇāṁ dēśāt sa ucchinnō 'bhavat dhruvaṁ| ");
INSERT INTO saniso_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","anantaraṁ sa philipam avadat nivēdayāmi, bhaviṣyadvādī yāmimāṁ kathāṁ kathayāmāsa sa kiṁ svasmin vā kasmiṁścid anyasmin? ");
INSERT INTO saniso_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","tataḥ philipastatprakaraṇam ārabhya yīśōrupākhyānaṁ tasyāgrē prāstaut| ");
INSERT INTO saniso_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","itthaṁ mārgēṇa gacchantau jalāśayasya samīpa upasthitau; tadā klībō'vādīt paśyātra sthānē jalamāstē mama majjanē kā bādhā? ");
INSERT INTO saniso_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","tataḥ philipa uttaraṁ vyāharat svāntaḥkaraṇēna sākaṁ yadi pratyēṣi tarhi bādhā nāsti| tataḥ sa kathitavān yīśukhrīṣṭa īśvarasya putra ityahaṁ pratyēmi| ");
INSERT INTO saniso_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","tadā rathaṁ sthagitaṁ karttum ādiṣṭē philipaklībau dvau jalam avāruhatāṁ; tadā philipastam majjayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","tatpaścāt jalamadhyād utthitayōḥ satōḥ paramēśvarasyātmā philipaṁ hr̥tvā nītavān, tasmāt klībaḥ punastaṁ na dr̥ṣṭavān tathāpi hr̥ṣṭacittaḥ san svamārgēṇa gatavān| ");
INSERT INTO saniso_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","philipaścāsdōdnagaram upasthāya tasmāt kaisariyānagara upasthitikālaparyyanataṁ sarvvasminnagarē susaṁvādaṁ pracārayan gatavān| ");
INSERT INTO saniso_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","tatkālaparyyanataṁ śaulaḥ prabhōḥ śiṣyāṇāṁ prātikūlyēna tāḍanābadhayōḥ kathāṁ niḥsārayan mahāyājakasya sannidhiṁ gatvā ");
INSERT INTO saniso_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","striyaṁ puruṣañca tanmatagrāhiṇaṁ yaṁ kañcit paśyati tān dhr̥tvā baddhvā yirūśālamam ānayatītyāśayēna dammēṣaknagarīyaṁ dharmmasamājān prati patraṁ yācitavān| ");
INSERT INTO saniso_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","gacchan tu dammēṣaknagaranikaṭa upasthitavān; tatō'kasmād ākāśāt tasya caturdikṣu tējasaḥ prakāśanāt sa bhūmāvapatat| ");
INSERT INTO saniso_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","paścāt hē śaula hē śaula kutō māṁ tāḍayasi? svaṁ prati prōktam ētaṁ śabdaṁ śrutvā ");
INSERT INTO saniso_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","sa pr̥ṣṭavān, hē prabhō bhavān kaḥ? tadā prabhurakathayat yaṁ yīśuṁ tvaṁ tāḍayasi sa ēvāhaṁ; kaṇṭakasya mukhē padāghātakaraṇaṁ tava kaṣṭam| ");
INSERT INTO saniso_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","tadā kampamānō vismayāpannaśca sōvadat hē prabhō mayā kiṁ karttavyaṁ? bhavata icchā kā? tataḥ prabhurājñāpayad utthāya nagaraṁ gaccha tatra tvayā yat karttavyaṁ tad vadiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","tasya saṅginō lōkā api taṁ śabdaṁ śrutavantaḥ kintu kamapi na dr̥ṣṭvā stabdhāḥ santaḥ sthitavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","anantaraṁ śaulō bhūmita utthāya cakṣuṣī unmīlya kamapi na dr̥ṣṭavān| tadā lōkāstasya hastau dhr̥tvā dammēṣaknagaram ānayan| ");
INSERT INTO saniso_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","tataḥ sa dinatrayaṁ yāvad andhō bhūtvā na bhuktavān pītavāṁśca| ");
INSERT INTO saniso_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","tadanantaraṁ prabhustaddammēṣaknagaravāsina ēkasmai śiṣyāya darśanaṁ datvā āhūtavān hē ananiya| tataḥ sa pratyavādīt, hē prabhō paśya śr̥ṇōmi| ");
INSERT INTO saniso_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","tadā prabhustamājñāpayat tvamutthāya saralanāmānaṁ mārgaṁ gatvā yihūdānivēśanē tārṣanagarīyaṁ śaulanāmānaṁ janaṁ gavēṣayan pr̥ccha; ");
INSERT INTO saniso_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","paśya sa prārthayatē, tathā ananiyanāmaka ēkō janastasya samīpam āgatya tasya gātrē hastārpaṇaṁ kr̥tvā dr̥ṣṭiṁ dadātītthaṁ svapnē dr̥ṣṭavān| ");
INSERT INTO saniso_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","tasmād ananiyaḥ pratyavadat hē prabhō yirūśālami pavitralōkān prati sō'nēkahiṁsāṁ kr̥tavān; ");
INSERT INTO saniso_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","atra sthānē ca yē lōkāstava nāmni prārthayanti tānapi baddhuṁ sa pradhānayājakēbhyaḥ śaktiṁ prāptavān, imāṁ kathām aham anēkēṣāṁ mukhēbhyaḥ śrutavān| ");
INSERT INTO saniso_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","kintu prabhurakathayat, yāhi bhinnadēśīyalōkānāṁ bhūpatīnām isrāyēllōkānāñca nikaṭē mama nāma pracārayituṁ sa janō mama manōnītapātramāstē| ");
INSERT INTO saniso_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","mama nāmanimittañca tēna kiyān mahān klēśō bhōktavya ētat taṁ darśayiṣyāmi| ");
INSERT INTO saniso_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","tatō 'naniyō gatvā gr̥haṁ praviśya tasya gātrē hastārpraṇaṁ kr̥tvā kathitavān, hē bhrātaḥ śaula tvaṁ yathā dr̥ṣṭiṁ prāpnōṣi pavitrēṇātmanā paripūrṇō bhavasi ca, tadarthaṁ tavāgamanakālē yaḥ prabhuyīśustubhyaṁ darśanam adadāt sa māṁ prēṣitavān| ");
INSERT INTO saniso_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ityuktamātrē tasya cakṣurbhyām mīnaśalkavad vastuni nirgatē tatkṣaṇāt sa prasannacakṣu rbhūtvā prōtthāya majjitō'bhavat bhuktvā pītvā sabalōbhavacca| ");
INSERT INTO saniso_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","tataḥ paraṁ śaulaḥ śiṣyaiḥ saha katipayadivasān tasmin dammēṣakanagarē sthitvā'vilambaṁ ");
INSERT INTO saniso_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","sarvvabhajanabhavanāni gatvā yīśurīśvarasya putra imāṁ kathāṁ prācārayat| ");
INSERT INTO saniso_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","tasmāt sarvvē śrōtāraścamatkr̥tya kathitavantō yō yirūśālamnagara ētannāmnā prārthayitr̥lōkān vināśitavān ēvam ētādr̥śalōkān baddhvā pradhānayājakanikaṭaṁ nayatītyāśayā ētatsthānamapyāgacchat saēva kimayaṁ na bhavati? ");
INSERT INTO saniso_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","kintu śaulaḥ kramaśa utsāhavān bhūtvā yīśurīśvarēṇābhiṣiktō jana ētasmin pramāṇaṁ datvā dammēṣak-nivāsiyihūdīyalōkān niruttarān akarōt| ");
INSERT INTO saniso_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","itthaṁ bahutithē kālē gatē yihūdīyalōkāstaṁ hantuṁ mantrayāmāsuḥ ");
INSERT INTO saniso_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","kintu śaulastēṣāmētasyā mantraṇāyā vārttāṁ prāptavān| tē taṁ hantuṁ tu divāniśaṁ guptāḥ santō nagarasya dvārē'tiṣṭhan; ");
INSERT INTO saniso_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","tasmāt śiṣyāstaṁ nītvā rātrau piṭakē nidhāya prācīrēṇāvārōhayan| ");
INSERT INTO saniso_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","tataḥ paraṁ śaulō yirūśālamaṁ gatvā śiṣyagaṇēna sārddhaṁ sthātum aihat, kintu sarvvē tasmādabibhayuḥ sa śiṣya iti ca na pratyayan| ");
INSERT INTO saniso_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","ētasmād barṇabbāstaṁ gr̥hītvā prēritānāṁ samīpamānīya mārgamadhyē prabhuḥ kathaṁ tasmai darśanaṁ dattavān yāḥ kathāśca kathitavān sa ca yathākṣōbhaḥ san dammēṣaknagarē yīśō rnāma prācārayat ētān sarvvavr̥ttāntān tān jñāpitavān| ");
INSERT INTO saniso_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","tataḥ śaulastaiḥ saha yirūśālami kālaṁ yāpayan nirbhayaṁ prabhō ryīśō rnāma prācārayat| ");
INSERT INTO saniso_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","tasmād anyadēśīyalōkaiḥ sārddhaṁ vivādasyōpasthitatvāt tē taṁ hantum acēṣṭanta| ");
INSERT INTO saniso_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","kintu bhrātr̥gaṇastajjñātvā taṁ kaisariyānagaraṁ nītvā tārṣanagaraṁ prēṣitavān| ");
INSERT INTO saniso_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","itthaṁ sati yihūdiyāgālīlśōmirōṇadēśīyāḥ sarvvā maṇḍalyō viśrāmaṁ prāptāstatastāsāṁ niṣṭhābhavat prabhō rbhiyā pavitrasyātmanaḥ sāntvanayā ca kālaṁ kṣēpayitvā bahusaṁkhyā abhavan| ");
INSERT INTO saniso_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","tataḥ paraṁ pitaraḥ sthānē sthānē bhramitvā śēṣē lōdnagaranivāsipavitralōkānāṁ samīpē sthitavān| ");
INSERT INTO saniso_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","tadā tatra pakṣāghātavyādhināṣṭau vatsarān śayyāgatam ainēyanāmānaṁ manuṣyaṁ sākṣat prāpya tamavadat, ");
INSERT INTO saniso_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","hē ainēya yīśukhrīṣṭastvāṁ svastham akārṣīt, tvamutthāya svaśayyāṁ nikṣipa, ityuktamātrē sa udatiṣṭhat| ");
INSERT INTO saniso_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ētādr̥śaṁ dr̥ṣṭvā lōdśārōṇanivāsinō lōkāḥ prabhuṁ prati parāvarttanta| ");
INSERT INTO saniso_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","aparañca bhikṣādānādiṣu nānakriyāsu nityaṁ pravr̥ttā yā yāphōnagaranivāsinī ṭābithānāmā śiṣyā yāṁ darkkāṁ arthād hariṇīmayuktvā āhvayan sā nārī ");
INSERT INTO saniso_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","tasmin samayē rugnā satī prāṇān atyajat, tatō lōkāstāṁ prakṣālyōparisthaprakōṣṭhē śāyayitvāsthāpayan| ");
INSERT INTO saniso_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","lōdnagaraṁ yāphōnagarasya samīpasthaṁ tasmāttatra pitara āstē, iti vārttāṁ śrutvā tūrṇaṁ tasyāgamanārthaṁ tasmin vinayamuktvā śiṣyagaṇō dvau manujau prēṣitavān| ");
INSERT INTO saniso_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","tasmāt pitara utthāya tābhyāṁ sārddham āgacchat, tatra tasmin upasthita uparisthaprakōṣṭhaṁ samānītē ca vidhavāḥ svābhiḥ saha sthitikālē darkkayā kr̥tāni yānyuttarīyāṇi paridhēyāni ca tāni sarvvāṇi taṁ darśayitvā rudatyaścatasr̥ṣu dikṣvatiṣṭhan| ");
INSERT INTO saniso_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","kintu pitarastāḥ sarvvā bahiḥ kr̥tvā jānunī pātayitvā prārthitavān; paścāt śavaṁ prati dr̥ṣṭiṁ kr̥tvā kathitavān, hē ṭābīthē tvamuttiṣṭha, iti vākya uktē sā strī cakṣuṣī prōnmīlya pitaram avalōkyōtthāyōpāviśat| ");
INSERT INTO saniso_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","tataḥ pitarastasyāḥ karau dhr̥tvā uttōlya pavitralōkān vidhavāścāhūya tēṣāṁ nikaṭē sajīvāṁ tāṁ samārpayat| ");
INSERT INTO saniso_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ēṣā kathā samastayāphōnagaraṁ vyāptā tasmād anēkē lōkāḥ prabhau vyaśvasan| ");
INSERT INTO saniso_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","aparañca pitarastadyāphōnagarīyasya kasyacit śimōnnāmnaścarmmakārasya gr̥hē bahudināni nyavasat| ");
INSERT INTO saniso_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","kaisariyānagara itāliyākhyasainyāntargataḥ karṇīliyanāmā sēnāpatirāsīt ");
INSERT INTO saniso_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","sa saparivārō bhakta īśvaraparāyaṇaścāsīt; lōkēbhyō bahūni dānādīni datvā nirantaram īśvarē prārthayāñcakrē| ");
INSERT INTO saniso_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ēkadā tr̥tīyapraharavēlāyāṁ sa dr̥ṣṭavān īśvarasyaikō dūtaḥ saprakāśaṁ tatsamīpam āgatya kathitavān, hē karṇīliya| ");
INSERT INTO saniso_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","kintu sa taṁ dr̥ṣṭvā bhītō'kathayat, hē prabhō kiṁ? tadā tamavadat tava prārthanā dānādi ca sākṣisvarūpaṁ bhūtvēśvarasya gōcaramabhavat| ");
INSERT INTO saniso_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","idānīṁ yāphōnagaraṁ prati lōkān prēṣya samudratīrē śimōnnāmnaścarmmakārasya gr̥hē pravāsakārī pitaranāmnā vikhyātō yaḥ śimōn tam āhvāyaya; ");
INSERT INTO saniso_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","tasmāt tvayā yadyat karttavyaṁ tattat sa vadiṣyati| ");
INSERT INTO saniso_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ityupadiśya dūtē prasthitē sati karṇīliyaḥ svagr̥hasthānāṁ dāsānāṁ dvau janau nityaṁ svasaṅgināṁ sainyānām ēkāṁ bhaktasēnāñcāhūya ");
INSERT INTO saniso_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","sakalamētaṁ vr̥ttāntaṁ vijñāpya yāphōnagaraṁ tān prāhiṇōt| ");
INSERT INTO saniso_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","parasmin dinē tē yātrāṁ kr̥tvā yadā nagarasya samīpa upātiṣṭhan, tadā pitarō dvitīyapraharavēlāyāṁ prārthayituṁ gr̥hapr̥ṣṭham ārōhat| ");
INSERT INTO saniso_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ētasmin samayē kṣudhārttaḥ san kiñcid bhōktum aicchat kintu tēṣām annāsādanasamayē sa mūrcchitaḥ sannapatat| ");
INSERT INTO saniso_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","tatō mēghadvāraṁ muktaṁ caturbhiḥ kōṇai rlambitaṁ br̥hadvastramiva kiñcana bhājanam ākāśāt pr̥thivīm avārōhatīti dr̥ṣṭavān| ");
INSERT INTO saniso_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","tanmadhyē nānaprakārā grāmyavanyapaśavaḥ khēcarōrōgāmiprabhr̥tayō jantavaścāsan| ");
INSERT INTO saniso_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","anantaraṁ hē pitara utthāya hatvā bhuṁkṣva tampratīyaṁ gagaṇīyā vāṇī jātā| ");
INSERT INTO saniso_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","tadā pitaraḥ pratyavadat, hē prabhō īdr̥śaṁ mā bhavatu, aham ētat kālaṁ yāvat niṣiddham aśuci vā dravyaṁ kiñcidapi na bhuktavān| ");
INSERT INTO saniso_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","tataḥ punarapi tādr̥śī vihayasīyā vāṇī jātā yad īśvaraḥ śuci kr̥tavān tat tvaṁ niṣiddhaṁ na jānīhi| ");
INSERT INTO saniso_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","itthaṁ triḥ sati tat pātraṁ punarākr̥ṣṭaṁ ākāśam agacchat| ");
INSERT INTO saniso_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","tataḥ paraṁ yad darśanaṁ prāptavān tasya kō bhāva ityatra pitarō manasā sandēgdhi, ētasmin samayē karṇīliyasya tē prēṣitā manuṣyā dvārasya sannidhāvupasthāya, ");
INSERT INTO saniso_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","śimōnō gr̥hamanvicchantaḥ sampr̥chyāhūya kathitavantaḥ pitaranāmnā vikhyātō yaḥ śimōn sa kimatra pravasati? ");
INSERT INTO saniso_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","yadā pitarastaddarśanasya bhāvaṁ manasāndōlayati tadātmā tamavadat, paśya trayō janāstvāṁ mr̥gayantē| ");
INSERT INTO saniso_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","tvam utthāyāvaruhya niḥsandēhaṁ taiḥ saha gaccha mayaiva tē prēṣitāḥ| ");
INSERT INTO saniso_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","tasmāt pitarō'varuhya karṇīliyaprēritalōkānāṁ nikaṭamāgatya kathitavān paśyata yūyaṁ yaṁ mr̥gayadhvē sa janōhaṁ, yūyaṁ kinnimittam āgatāḥ? ");
INSERT INTO saniso_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","tatastē pratyavadan karṇīliyanāmā śuddhasattva īśvaraparāyaṇō yihūdīyadēśasthānāṁ sarvvēṣāṁ sannidhau sukhyātyāpanna ēkaḥ sēnāpati rnijagr̥haṁ tvāmāhūya nētuṁ tvattaḥ kathā śrōtuñca pavitradūtēna samādiṣṭaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","tadā pitarastānabhyantaraṁ nītvā tēṣāmātithyaṁ kr̥tavān, parē'hani taiḥ sārddhaṁ yātrāmakarōt, yāphōnivāsināṁ bhrātr̥ṇāṁ kiyantō janāśca tēna saha gatāḥ| ");
INSERT INTO saniso_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","parasmin divasē kaisariyānagaramadhyapravēśasamayē karṇīliyō jñātibandhūn āhūyānīya tān apēkṣya sthitaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","pitarē gr̥ha upasthitē karṇīliyastaṁ sākṣātkr̥tya caraṇayōḥ patitvā prāṇamat| ");
INSERT INTO saniso_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","pitarastamutthāpya kathitavān, uttiṣṭhāhamapi mānuṣaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","tadā karṇīliyēna sākam ālapan gr̥haṁ prāviśat tanmadhyē ca bahulōkānāṁ samāgamaṁ dr̥ṣṭvā tān avadat, ");
INSERT INTO saniso_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","anyajātīyalōkaiḥ mahālapanaṁ vā tēṣāṁ gr̥hamadhyē pravēśanaṁ yihūdīyānāṁ niṣiddham astīti yūyam avagacchatha; kintu kamapi mānuṣam avyavahāryyam aśuciṁ vā jñātuṁ mama nōcitam iti paramēśvarō māṁ jñāpitavān| ");
INSERT INTO saniso_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","iti hētōrāhvānaśravaṇamātrāt kāñcanāpattim akr̥tvā yuṣmākaṁ samīpam āgatōsmi; pr̥cchāmi yūyaṁ kinnimittaṁ mām āhūyata? ");
INSERT INTO saniso_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","tadā karṇīliyaḥ kathitavān, adya catvāri dināni jātāni ētāvadvēlāṁ yāvad aham anāhāra āsan tatastr̥tīyapraharē sati gr̥hē prārthanasamayē tējōmayavastrabhr̥d ēkō janō mama samakṣaṁ tiṣṭhan ētāṁ kathām akathayat, ");
INSERT INTO saniso_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","hē karṇīliya tvadīyā prārthanā īśvarasya karṇagōcarībhūtā tava dānādi ca sākṣisvarūpaṁ bhūtvā tasya dr̥ṣṭigōcaramabhavat| ");
INSERT INTO saniso_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","atō yāphōnagaraṁ prati lōkān prahitya tatra samudratīrē śimōnnāmnaḥ kasyaciccarmmakārasya gr̥hē pravāsakārī pitaranāmnā vikhyātō yaḥ śimōn tamāhūाyaya; tataḥ sa āgatya tvām upadēkṣyati| ");
INSERT INTO saniso_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","iti kāraṇāt tatkṣaṇāt tava nikaṭē lōkān prēṣitavān, tvamāgatavān iti bhadraṁ kr̥tavān| īśvarō yānyākhyānāni kathayitum ādiśat tāni śrōtuṁ vayaṁ sarvvē sāmpratam īśvarasya sākṣād upasthitāḥ smaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","tadā pitara imāṁ kathāṁ kathayitum ārabdhavān, īśvarō manuṣyāṇām apakṣapātī san ");
INSERT INTO saniso_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","yasya kasyacid dēśasya yō lōkāstasmādbhītvā satkarmma karōti sa tasya grāhyō bhavati, ētasya niścayam upalabdhavānaham| ");
INSERT INTO saniso_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","sarvvēṣāṁ prabhu ryō yīśukhrīṣṭastēna īśvara isrāyēlvaṁśānāṁ nikaṭē susaṁvādaṁ prēṣya sammēlanasya yaṁ saṁvādaṁ prācārayat taṁ saṁvādaṁ yūyaṁ śrutavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","yatō yōhanā majjanē pracāritē sati sa gālīladēśamārabhya samastayihūdīyadēśaṁ vyāpnōt; ");
INSERT INTO saniso_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","phalata īśvarēṇa pavitrēṇātmanā śaktyā cābhiṣiktō nāsaratīyayīśuḥ sthānē sthānē bhraman sukriyāṁ kurvvan śaitānā kliṣṭān sarvvalōkān svasthān akarōt, yata īśvarastasya sahāya āsīt; ");
INSERT INTO saniso_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","vayañca yihūdīyadēśē yirūśālamnagarē ca tēna kr̥tānāṁ sarvvēṣāṁ karmmaṇāṁ sākṣiṇō bhavāmaḥ| lōkāstaṁ kruśē viddhvā hatavantaḥ, ");
INSERT INTO saniso_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","kintu tr̥tīyadivasē īśvarastamutthāpya saprakāśam adarśayat| ");
INSERT INTO saniso_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","sarvvalōkānāṁ nikaṭa iti na hi, kintu tasmin śmaśānādutthitē sati tēna sārddhaṁ bhōjanaṁ pānañca kr̥tavanta ētādr̥śā īśvarasya manōnītāḥ sākṣiṇō yē vayam asmākaṁ nikaṭē tamadarśayat| ");
INSERT INTO saniso_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","jīvitamr̥tōbhayalōkānāṁ vicāraṁ karttum īśvarō yaṁ niyuktavān sa ēva sa janaḥ, imāṁ kathāṁ pracārayituṁ tasmin pramāṇaṁ dātuñca sō'smān ājñāpayat| ");
INSERT INTO saniso_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","yastasmin viśvasiti sa tasya nāmnā pāpānmuktō bhaviṣyati tasmin sarvvē bhaviṣyadvādinōpi ētādr̥śaṁ sākṣyaṁ dadati| ");
INSERT INTO saniso_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","pitarasyaitatkathākathanakālē sarvvēṣāṁ śrōtr̥ṇāmupari pavitra ātmāvārōhat| ");
INSERT INTO saniso_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","tataḥ pitarēṇa sārddham āgatāstvakchēdinō viśvāsinō lōkā anyadēśīyēbhyaḥ pavitra ātmani dattē sati ");
INSERT INTO saniso_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","tē nānājātīyabhāṣābhiḥ kathāṁ kathayanta īśvaraṁ praśaṁsanti, iti dr̥ṣṭvā śrutvā ca vismayam āpadyanta| ");
INSERT INTO saniso_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","tadā pitaraḥ kathitavān, vayamiva yē pavitram ātmānaṁ prāptāstēṣāṁ jalamajjanaṁ kiṁ kōpi niṣēddhuṁ śaknōti? ");
INSERT INTO saniso_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","tataḥ prabhō rnāmnā majjitā bhavatēti tānājñāpayat| anantaraṁ tē svaiḥ sārddhaṁ katipayadināni sthātuṁ prārthayanta| ");
INSERT INTO saniso_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","itthaṁ bhinnadēśīyalōkā apīśvarasya vākyam agr̥hlan imāṁ vārttāṁ yihūdīyadēśasthaprēritā bhrātr̥gaṇaśca śrutavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","tataḥ pitarē yirūśālamnagaraṁ gatavati tvakchēdinō lōkāstēna saha vivadamānā avadan, ");
INSERT INTO saniso_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","tvam atvakchēdilōkānāṁ gr̥haṁ gatvā taiḥ sārddhaṁ bhuktavān| ");
INSERT INTO saniso_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","tataḥ pitara āditaḥ kramaśastatkāryyasya sarvvavr̥ttāntamākhyātum ārabdhavān| ");
INSERT INTO saniso_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","yāphōnagara ēkadāhaṁ prārthayamānō mūrcchitaḥ san darśanēna caturṣu kōṇēṣu lambanamānaṁ vr̥hadvastramiva pātramēkam ākāśadavaruhya mannikaṭam āgacchad apaśyam| ");
INSERT INTO saniso_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","paścāt tad ananyadr̥ṣṭyā dr̥ṣṭvā vivicya tasya madhyē nānāprakārān grāmyavanyapaśūn urōgāmikhēcarāṁśca dr̥ṣṭavān; ");
INSERT INTO saniso_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","hē pitara tvamutthāya gatvā bhuṁkṣva māṁ sambōdhya kathayantaṁ śabdamēkaṁ śrutavāṁśca| ");
INSERT INTO saniso_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","tatōhaṁ pratyavadaṁ, hē prabhō nētthaṁ bhavatu, yataḥ kiñcana niṣiddham aśuci dravyaṁ vā mama mukhamadhyaṁ kadāpi na prāviśat| ");
INSERT INTO saniso_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","aparam īśvarō yat śuci kr̥tavān tanniṣiddhaṁ na jānīhi dvi rmāmpratīdr̥śī vihāyasīyā vāṇī jātā| ");
INSERT INTO saniso_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","triritthaṁ sati tat sarvvaṁ punarākāśam ākr̥ṣṭaṁ| ");
INSERT INTO saniso_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","paścāt kaisariyānagarāt trayō janā mannikaṭaṁ prēṣitā yatra nivēśanē sthitōhaṁ tasmin samayē tatrōpātiṣṭhan| ");
INSERT INTO saniso_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","tadā niḥsandēhaṁ taiḥ sārddhaṁ yātum ātmā māmādiṣṭavān; tataḥ paraṁ mayā sahaitēṣu ṣaḍbhrātr̥ṣu gatēṣu vayaṁ tasya manujasya gr̥haṁ prāviśāma| ");
INSERT INTO saniso_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","sōsmākaṁ nikaṭē kathāmētām akathayat ēkadā dūta ēkaḥ pratyakṣībhūya mama gr̥hamadhyē tiṣṭan māmityājñāpitavān, yāphōnagaraṁ prati lōkān prahitya pitaranāmnā vikhyātaṁ śimōnam āhūyaya; ");
INSERT INTO saniso_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","tatastava tvadīyaparivārāṇāñca yēna paritrāṇaṁ bhaviṣyati tat sa upadēkṣyati| ");
INSERT INTO saniso_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","ahaṁ tāṁ kathāmutthāpya kathitavān tēna prathamam asmākam upari yathā pavitra ātmāvarūḍhavān tathā tēṣāmapyupari samavarūḍhavān| ");
INSERT INTO saniso_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","tēna yōhan jalē majjitavān iti satyaṁ kintu yūyaṁ pavitra ātmani majjitā bhaviṣyatha, iti yadvākyaṁ prabhuruditavān tat tadā mayā smr̥tam| ");
INSERT INTO saniso_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","ataḥ prabhā yīśukhrīṣṭē pratyayakāriṇō yē vayam asmabhyam īśvarō yad dattavān tat tēbhyō lōkēbhyōpi dattavān tataḥ kōhaṁ? kimaham īśvaraṁ vārayituṁ śaknōmi? ");
INSERT INTO saniso_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","kathāmētāṁ śruvā tē kṣāntā īśvarasya guṇān anukīrttya kathitavantaḥ, tarhi paramāyuḥprāptinimittam īśvarōnyadēśīyalōkēbhyōpi manaḥparivarttanarūpaṁ dānam adāt| ");
INSERT INTO saniso_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","stiphānaṁ prati upadravē ghaṭitē yē vikīrṇā abhavan tai phainīkīkuprāntiyakhiyāsu bhramitvā kēvalayihūdīyalōkān vinā kasyāpyanyasya samīpa īśvarasya kathāṁ na prācārayan| ");
INSERT INTO saniso_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","aparaṁ tēṣāṁ kuprīyāḥ kurīnīyāśca kiyantō janā āntiyakhiyānagaraṁ gatvā yūnānīyalōkānāṁ samīpēpi prabhōryīśōḥ kathāṁ prācārayan| ");
INSERT INTO saniso_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","prabhōḥ karastēṣāṁ sahāya āsīt tasmād anēkē lōkā viśvasya prabhuṁ prati parāvarttanta| ");
INSERT INTO saniso_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","iti vārttāyāṁ yirūśālamasthamaṇḍalīyalōkānāṁ karṇagōcarībhūtāyām āntiyakhiyānagaraṁ gantu tē barṇabbāṁ prairayan| ");
INSERT INTO saniso_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","tatō barṇabbāstatra upasthitaḥ san īśvarasyānugrahasya phalaṁ dr̥ṣṭvā sānandō jātaḥ, ");
INSERT INTO saniso_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","sa svayaṁ sādhu rviśvāsēna pavitrēṇātmanā ca paripūrṇaḥ san ganōniṣṭayā prabhāvāsthāṁ karttuṁ sarvvān upadiṣṭavān tēna prabhōḥ śiṣyā anēkē babhūvuḥ| ");
INSERT INTO saniso_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","śēṣē śaulaṁ mr̥gayituṁ barṇabbāstārṣanagaraṁ prasthitavān| tatra tasyōddēśaṁ prāpya tam āntiyakhiyānagaram ānayat; ");
INSERT INTO saniso_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","tatastau maṇḍalīsthalōkaiḥ sabhāṁ kr̥tvā saṁvatsaramēkaṁ yāvad bahulōkān upādiśatāṁ; tasmin āntiyakhiyānagarē śiṣyāḥ prathamaṁ khrīṣṭīyanāmnā vikhyātā abhavan| ");
INSERT INTO saniso_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","tataḥ paraṁ bhaviṣyadvādigaṇē yirūśālama āntiyakhiyānagaram āgatē sati ");
INSERT INTO saniso_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","āgābanāmā tēṣāmēka utthāya ātmanaḥ śikṣayā sarvvadēśē durbhikṣaṁ bhaviṣyatīti jñāpitavān; tataḥ klaudiyakaisarasyādhikārē sati tat pratyakṣam abhavat| ");
INSERT INTO saniso_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","tasmāt śiṣyā ēkaikaśaḥ svasvaśaktyanusāratō yihūdīyadēśanivāsināṁ bhratr̥ṇāṁ dinayāpanārthaṁ dhanaṁ prēṣayituṁ niścitya ");
INSERT INTO saniso_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","barṇabbāśaulayō rdvārā prācīnalōkānāṁ samīpaṁ tat prēṣitavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","tasmin samayē hērōd‌rājō maṇḍalyāḥ kiyajjanēbhyō duḥkhaṁ dātuṁ prārabhat| ");
INSERT INTO saniso_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","viśēṣatō yōhanaḥ sōdaraṁ yākūbaṁ karavālāghātēn hatavān| ");
INSERT INTO saniso_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","tasmād yihūdīyāḥ santuṣṭā abhavan iti vijñāya sa pitaramapi dharttuṁ gatavān| ");
INSERT INTO saniso_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","tadā kiṇvaśūnyapūpōtsavasamaya upātiṣṭat; ata utsavē gatē sati lōkānāṁ samakṣaṁ taṁ bahirānēyyāmīti manasi sthirīkr̥tya sa taṁ dhārayitvā rakṣṇārtham yēṣām ēkaikasaṁghē catvārō janāḥ santi tēṣāṁ caturṇāṁ rakṣakasaṁghānāṁ samīpē taṁ samarpya kārāyāṁ sthāpitavān| ");
INSERT INTO saniso_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","kintuṁ pitarasya kārāsthitikāraṇāt maṇḍalyā lōkā aviśrāmam īśvarasya samīpē prārthayanta| ");
INSERT INTO saniso_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","anantaraṁ hērōdi taṁ bahirānāyituṁ udyatē sati tasyāṁ rātrau pitarō rakṣakadvayamadhyasthānē śr̥ṅkhaladvayēna baddhvaḥ san nidrita āsīt, dauvārikāśca kārāyāḥ sammukhē tiṣṭhanatō dvāram arakṣiṣuḥ| ");
INSERT INTO saniso_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ētasmin samayē paramēśvarasya dūtē samupasthitē kārā dīptimatī jātā; tataḥ sa dūtaḥ pitarasya kukṣāvāvātaṁ kr̥tvā taṁ jāgarayitvā bhāṣitavān tūrṇamuttiṣṭha; tatastasya hastasthaśr̥ṅkhaladvayaṁ galat patitaṁ| ");
INSERT INTO saniso_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","sa dūtastamavadat, baddhakaṭiḥ san pādayōḥ pādukē arpaya; tēna tathā kr̥tē sati dūtastam uktavān gātrīyavastraṁ gātrē nidhāya mama paścād ēhi| ");
INSERT INTO saniso_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","tataḥ pitarastasya paścād vrajana bahiragacchat, kintu dūtēna karmmaitat kr̥tamiti satyamajñātvā svapnadarśanaṁ jñātavān| ");
INSERT INTO saniso_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","itthaṁ tau prathamāṁ dvitīyāñca kārāṁ laṅghitvā yēna lauhanirmmitadvārēṇa nagaraṁ gamyatē tatsamīpaṁ prāpnutāṁ; tatastasya kavāṭaṁ svayaṁ muktamabhavat tatastau tatsthānād bahi rbhūtvā mārgaikasya sīmāṁ yāvad gatau; tatō'kasmāt sa dūtaḥ pitaraṁ tyaktavān| ");
INSERT INTO saniso_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","tadā sa cētanāṁ prāpya kathitavān nijadūtaṁ prahitya paramēśvarō hērōdō hastād yihūdīyalōkānāṁ sarvvāśāyāśca māṁ samuddhr̥tavān ityahaṁ niścayaṁ jñātavān| ");
INSERT INTO saniso_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","sa vivicya mārkanāmrā vikhyātasya yōhanō mātu rmariyamō yasmin gr̥hē bahavaḥ sambhūya prārthayanta tannivēśanaṁ gataḥ| ");
INSERT INTO saniso_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","pitarēṇa bahirdvāra āhatē sati rōdānāmā bālikā draṣṭuṁ gatā| ");
INSERT INTO saniso_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","tataḥ pitarasya svaraṁ śruvā sā harṣayuktā satī dvāraṁ na mōcayitvā pitarō dvārē tiṣṭhatīti vārttāṁ vaktum abhyantaraṁ dhāvitvā gatavatī| ");
INSERT INTO saniso_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","tē prāvōcan tvamunmattā jātāsi kintu sā muhurmuhuruktavatī satyamēvaitat| ");
INSERT INTO saniso_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","tadā tē kathitavantastarhi tasya dūtō bhavēt| ");
INSERT INTO saniso_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","pitarō dvāramāhatavān ētasminnantarē dvāraṁ mōcayitvā pitaraṁ dr̥ṣṭvā vismayaṁ prāptāḥ| ");
INSERT INTO saniso_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","tataḥ pitarō niḥśabdaṁ sthātuṁ tān prati hastēna saṅkētaṁ kr̥tvā paramēśvarō yēna prakārēṇa taṁ kārāyā uddhr̥tyānītavān tasya vr̥ttāntaṁ tānajñāpayat, yūyaṁ gatvā yākubaṁ bhrātr̥gaṇañca vārttāmētāṁ vadatētyuktā sthānāntaraṁ prasthitavān| ");
INSERT INTO saniso_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","prabhātē sati pitaraḥ kva gata ityatra rakṣakāṇāṁ madhyē mahān kalahō jātaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","hērōd bahu mr̥gayitvā tasyōddēśē na prāptē sati rakṣakān saṁpr̥cchya tēṣāṁ prāṇān hantum ādiṣṭavān| ");
INSERT INTO saniso_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","paścāt sa yihūdīyapradēśāt kaisariyānagaraṁ gatvā tatrāvātiṣṭhat| ");
INSERT INTO saniso_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","sōrasīdōnadēśayō rlōkēbhyō hērōdi yuyutsau sati tē sarvva ēkamantraṇāḥ santastasya samīpa upasthāya lvāstanāmānaṁ tasya vastragr̥hādhīśaṁ sahāyaṁ kr̥tvā hērōdā sārddhaṁ sandhiṁ prārthayanta yatastasya rājñō dēśēna tēṣāṁ dēśīyānāṁ bharaṇam abhavatṁ ");
INSERT INTO saniso_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","ataḥ kutracin nirupitadinē hērōd rājakīyaṁ paricchadaṁ paridhāya siṁhāsanē samupaviśya tān prati kathām uktavān| ");
INSERT INTO saniso_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","tatō lōkā uccaiḥkāraṁ pratyavadan, ēṣa manujaravō na hi, īśvarīyaravaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","tadā hērōd īśvarasya sammānaṁ nākarōt; tasmāddhētōḥ paramēśvarasya dūtō haṭhāt taṁ prāharat tēnaiva sa kīṭaiḥ kṣīṇaḥ san prāṇān ajahāt| kintvīśvarasya kathā dēśaṁ vyāpya prabalābhavat| tataḥ paraṁ barṇabbāśaulau yasya karmmaṇō bhāraṁ prāpnutāṁ tābhyāṁ tasmin sampāditē sati mārkanāmnā vikhyātō yō yōhan taṁ saṅginaṁ kr̥tvā yirūśālamnagarāt pratyāgatau| ");
INSERT INTO saniso_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","aparañca barṇabbāḥ, śimōn yaṁ nigraṁ vadanti, kurīnīyalūkiyō hērōdā rājñā saha kr̥tavidyāाbhyāsō minahēm, śaulaścaitē yē kiyantō janā bhaviṣyadvādina upadēṣṭāraścāntiyakhiyānagarasthamaṇḍalyām āsan, ");
INSERT INTO saniso_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","tē yadōpavāsaṁ kr̥tvēśvaram asēvanta tasmin samayē pavitra ātmā kathitavān ahaṁ yasmin karmmaṇi barṇabbāśailau niyuktavān tatkarmma karttuṁ tau pr̥thak kuruta| ");
INSERT INTO saniso_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","tatastairupavāsaprārthanayōḥ kr̥tayōḥ satōstē tayō rgātrayō rhastārpaṇaṁ kr̥tvā tau vyasr̥jan| ");
INSERT INTO saniso_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","tataḥ paraṁ tau pavitrēṇātmanā prēritau santau silūkiyānagaram upasthāya samudrapathēna kuprōpadvīpam agacchatāṁ| ");
INSERT INTO saniso_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","tataḥ sālāmīnagaram upasthāya tatra yihūdīyānāṁ bhajanabhavanāni gatvēśvarasya kathāṁ prācārayatāṁ; yōhanapi tatsahacarō'bhavat| ");
INSERT INTO saniso_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","itthaṁ tē tasyōpadvīpasya sarvvatra bhramantaḥ pāphanagaram upasthitāḥ; tatra suvivēcakēna sarjiyapaulanāmnā taddēśādhipatinā saha bhaviṣyadvādinō vēśadhārī baryīśunāmā yō māyāvī yihūdī āsīt taṁ sākṣāt prāptavataḥ| ");
INSERT INTO saniso_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","taddēśādhipa īśvarasya kathāṁ śrōtuṁ vāñchan paulabarṇabbau nyamantrayat| ");
INSERT INTO saniso_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","kintvilumā yaṁ māyāvinaṁ vadanti sa dēśādhipatiṁ dharmmamārgād bahirbhūtaṁ karttum ayatata| ");
INSERT INTO saniso_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","tasmāt śōlō'rthāt paulaḥ pavitrēṇātmanā paripūrṇaḥ san taṁ māyāvinaṁ pratyananyadr̥ṣṭiṁ kr̥tvākathayat, ");
INSERT INTO saniso_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","hē narakin dharmmadvēṣin kauṭilyaduṣkarmmaparipūrṇa, tvaṁ kiṁ prabhōḥ satyapathasya viparyyayakaraṇāt kadāpi na nivarttiṣyasē? ");
INSERT INTO saniso_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","adhunā paramēśvarastava samucitaṁ kariṣyati tēna katipayadināni tvam andhaḥ san sūryyamapi na drakṣyasi| tatkṣaṇād rātrivad andhakārastasya dr̥ṣṭim ācchāditavān; tasmāt tasya hastaṁ dharttuṁ sa lōkamanvicchan itastatō bhramaṇaṁ kr̥tavān| ");
INSERT INTO saniso_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ēnāṁ ghaṭanāṁ dr̥ṣṭvā sa dēśādhipatiḥ prabhūpadēśād vismitya viśvāsaṁ kr̥tavān| ");
INSERT INTO saniso_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","tadanantaraṁ paulastatsaṅginau ca pāphanagarāt prōtaṁ cālayitvā pamphuliyādēśasya pargīnagaram agacchan kintu yōhan tayōḥ samīpād ētya yirūśālamaṁ pratyāgacchat| ");
INSERT INTO saniso_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","paścāt tau pargītō yātrāṁ kr̥tvā pisidiyādēśasya āntiyakhiyānagaram upasthāya viśrāmavārē bhajanabhavanaṁ praviśya samupāviśatāṁ| ");
INSERT INTO saniso_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","vyavasthābhaviṣyadvākyayōḥ paṭhitayōḥ satō rhē bhrātarau lōkān prati yuvayōḥ kācid upadēśakathā yadyasti tarhi tāṁ vadataṁ tau prati tasya bhajanabhavanasyādhipatayaḥ kathām ētāṁ kathayitvā praiṣayan| ");
INSERT INTO saniso_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ataḥ paula uttiṣṭhan hastēna saṅkētaṁ kurvvan kathitavān hē isrāyēlīyamanuṣyā īśvaraparāyaṇāḥ sarvvē lōkā yūyam avadhaddhaṁ| ");
INSERT INTO saniso_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ētēṣāmisrāyēllōkānām īśvarō'smākaṁ pūrvvaparuṣān manōnītān katvā gr̥hītavān tatō misari dēśē pravasanakālē tēṣāmunnatiṁ kr̥tvā tasmāt svīyabāhubalēna tān bahiḥ kr̥tvā samānayat| ");
INSERT INTO saniso_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","catvāriṁśadvatsarān yāvacca mahāprāntarē tēṣāṁ bharaṇaṁ kr̥tvā ");
INSERT INTO saniso_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","kināndēśāntarvvarttīṇi saptarājyāni nāśayitvā guṭikāpātēna tēṣu sarvvadēśēṣu tēbhyō'dhikāraṁ dattavān| ");
INSERT INTO saniso_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","pañcāśadadhikacatuḥśatēṣu vatsarēṣu gatēṣu ca śimūyēlbhaviṣyadvādiparyyantaṁ tēṣāmupari vicārayitr̥n niyuktavān| ");
INSERT INTO saniso_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","taiśca rājñi prārthitē, īśvarō binyāmīnō vaṁśajātasya kīśaḥ putraṁ śaulaṁ catvāriṁśadvarṣaparyyantaṁ tēṣāmupari rājānaṁ kr̥tavān| ");
INSERT INTO saniso_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","paścāt taṁ padacyutaṁ kr̥tvā yō madiṣṭakriyāḥ sarvvāḥ kariṣyati tādr̥śaṁ mama manōbhimatam ēkaṁ janaṁ yiśayaḥ putraṁ dāyūdaṁ prāptavān idaṁ pramāṇaṁ yasmin dāyūdi sa dattavān taṁ dāyūdaṁ tēṣāmupari rājatvaṁ karttum utpāditavāna| ");
INSERT INTO saniso_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","tasya svapratiśrutasya vākyasyānusārēṇa isrāyēllōkānāṁ nimittaṁ tēṣāṁ manuṣyāṇāṁ vaṁśād īśvara ēkaṁ yīśuṁ (trātāram) udapādayat| ");
INSERT INTO saniso_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","tasya prakāśanāt pūrvvaṁ yōhan isrāyēllōkānāṁ sannidhau manaḥparāvarttanarūpaṁ majjanaṁ prācārayat| ");
INSERT INTO saniso_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","yasya ca karmmaṇōे bhāraṁ praptavān yōhan tan niṣpādayan ētāṁ kathāṁ kathitavān, yūyaṁ māṁ kaṁ janaṁ jānītha? aham abhiṣiktatrātā nahi, kintu paśyata yasya pādayōḥ pādukayō rbandhanē mōcayitumapi yōgyō na bhavāmi tādr̥śa ēkō janō mama paścād upatiṣṭhati| ");
INSERT INTO saniso_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","hē ibrāhīmō vaṁśajātā bhrātarō hē īśvarabhītāḥ sarvvalōkā yuṣmān prati paritrāṇasya kathaiṣā prēritā| ");
INSERT INTO saniso_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","yirūśālamnivāsinastēṣām adhipatayaśca tasya yīśōḥ paricayaṁ na prāpya prativiśrāmavāraṁ paṭhyamānānāṁ bhaviṣyadvādikathānām abhiprāyam abuddhvā ca tasya vadhēna tāḥ kathāḥ saphalā akurvvan| ");
INSERT INTO saniso_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","prāṇahananasya kamapi hētum aprāpyāpi pīlātasya nikaṭē tasya vadhaṁ prārthayanta| ");
INSERT INTO saniso_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","tasmin yāḥ kathā likhitāḥ santi tadanusārēṇa karmma sampādya taṁ kruśād avatāryya śmaśānē śāyitavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","kintvīśvaraḥ śmaśānāt tamudasthāpayat, ");
INSERT INTO saniso_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","punaśca gālīlapradēśād yirūśālamanagaraṁ tēna sārddhaṁ yē lōkā āgacchan sa bahudināni tēbhyō darśanaṁ dattavān, atasta idānīṁ lōkān prati tasya sākṣiṇaḥ santi| ");
INSERT INTO saniso_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","asmākaṁ pūrvvapuruṣāṇāṁ samakṣam īśvarō yasmin pratijñātavān yathā, tvaṁ mē putrōsi cādya tvāṁ samutthāpitavānaham| ");
INSERT INTO saniso_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","idaṁ yadvacanaṁ dvitīyagītē likhitamāstē tad yīśōrutthānēna tēṣāṁ santānā yē vayam asmākaṁ sannidhau tēna pratyakṣī kr̥taṁ, yuṣmān imaṁ susaṁvādaṁ jñāpayāmi| ");
INSERT INTO saniso_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","paramēśvarēṇa śmaśānād utthāpitaṁ tadīyaṁ śarīraṁ kadāpi na kṣēṣyatē, ētasmin sa svayaṁ kathitavān yathā dāyūdaṁ prati pratijñātō yō varastamahaṁ tubhyaṁ dāsyāmi| ");
INSERT INTO saniso_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","ētadanyasmin gītē'pi kathitavān| svakīyaṁ puṇyavantaṁ tvaṁ kṣayituṁ na ca dāsyasi| ");
INSERT INTO saniso_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","dāyūdā īśvarābhimatasēvāyai nijāyuṣi vyayitē sati sa mahānidrāṁ prāpya nijaiḥ pūrvvapuruṣaiḥ saha militaḥ san akṣīyata; ");
INSERT INTO saniso_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","kintu yamīśvaraḥ śmaśānād udasthāpayat sa nākṣīyata| ");
INSERT INTO saniso_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","atō hē bhrātaraḥ, anēna janēna pāpamōcanaṁ bhavatīti yuṣmān prati pracāritam āstē| ");
INSERT INTO saniso_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","phalatō mūsāvyavasthayā yūyaṁ yēbhyō dōṣēbhyō muktā bhavituṁ na śakṣyatha tēbhyaḥ sarvvadōṣēbhya ētasmin janē viśvāsinaḥ sarvvē muktā bhaviṣyantīti yuṣmābhi rjñāyatāṁ| ");
INSERT INTO saniso_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","aparañca| avajñākāriṇō lōkāścakṣurunmīlya paśyata| tathaivāsambhavaṁ jñātvā syāta yūyaṁ vilajjitāḥ| yatō yuṣmāsu tiṣṭhatsu kariṣyē karmma tādr̥śaṁ| yēnaiva tasya vr̥ttāntē yuṣmabhyaṁ kathitē'pi hi| yūyaṁ na tantu vr̥ttāntaṁ pratyēṣyatha kadācana|| ");
INSERT INTO saniso_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","yēyaṁ kathā bhaviṣyadvādināṁ granthēṣu likhitāstē sāvadhānā bhavata sa kathā yathā yuṣmān prati na ghaṭatē| ");
INSERT INTO saniso_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","yihūdīyabhajanabhavanān nirgatayōstayō rbhinnadēśīyai rvakṣyamāṇā prārthanā kr̥tā, āgāmini viśrāmavārē'pi kathēyam asmān prati pracāritā bhavatviti| ");
INSERT INTO saniso_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","sabhāyā bhaṅgē sati bahavō yihūdīyalōkā yihūdīyamatagrāhiṇō bhaktalōkāśca barṇabbāpaulayōḥ paścād āgacchan, tēna tau taiḥ saha nānākathāḥ kathayitvēśvarānugrahāśrayē sthātuṁ tān prāvarttayatāṁ| ");
INSERT INTO saniso_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","paraviśrāmavārē nagarasya prāyēṇa sarvvē lākā īśvarīyāṁ kathāṁ śrōtuṁ militāḥ, ");
INSERT INTO saniso_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","kintu yihūdīyalōkā jananivahaṁ vilōkya īrṣyayā paripūrṇāḥ santō viparītakathākathanēnēśvaranindayā ca paulēnōktāṁ kathāṁ khaṇḍayituṁ cēṣṭitavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","tataḥ pauैlabarṇabbāvakṣōbhau kathitavantau prathamaṁ yuṣmākaṁ sannidhāvīśvarīyakathāyāḥ pracāraṇam ucitamāsīt kintuṁ tadagrāhyatvakaraṇēna yūyaṁ svān anantāyuṣō'yōgyān darśayatha, ētatkāraṇād vayam anyadēśīyalōkānāṁ samīpaṁ gacchāmaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","prabhurasmān ittham ādiṣṭavān yathā, yāvacca jagataḥ sīmāṁ lōkānāṁ trāṇakāraṇāt| mayānyadēśamadhyē tvaṁ sthāpitō bhūḥ pradīpavat|| ");
INSERT INTO saniso_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","tadā kathāmīdr̥śīṁ śrutvā bhinnadēśīyā āhlāditāḥ santaḥ prabhōḥ kathāṁ dhanyāṁ dhanyām avadan, yāvantō lōkāśca paramāyuḥ prāptinimittaṁ nirūpitā āsan tēे vyaśvasan| ");
INSERT INTO saniso_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","itthaṁ prabhōḥ kathā sarvvēdēśaṁ vyāpnōt| ");
INSERT INTO saniso_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","kintu yihūdīyā nagarasya pradhānapuruṣān sammānyāḥ kathipayā bhaktā yōṣitaśca kupravr̥ttiṁ grāhayitvā paulabarṇabbau tāḍayitvā tasmāt pradēśād dūrīkr̥tavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","ataḥ kāraṇāt tau nijapadadhūlīstēṣāṁ prātikūlyēna pātayitvēेkaniyaṁ nagaraṁ gatau| ");
INSERT INTO saniso_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","tataḥ śiṣyagaṇa ānandēna pavitrēṇātmanā ca paripūrṇōbhavat| ");
INSERT INTO saniso_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","tau dvau janau yugapad ikaniyanagarasthayihūdīyānāṁ bhajanabhavanaṁ gatvā yathā bahavō yihūdīyā anyadēेśīyalōkāśca vyaśvasan tādr̥śīṁ kathāṁ kathitavantau| ");
INSERT INTO saniso_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","kintu viśvāsahīnā yihūdīyā anyadēśīyalōkān kupravr̥ttiṁ grāhayitvā bhrātr̥gaṇaṁ prati tēṣāṁ vairaṁ janitavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ataḥ svānugrahakathāyāḥ pramāṇaṁ datvā tayō rhastai rbahulakṣaṇam adbhutakarmma ca prākāśayad yaḥ prabhustasya kathā akṣōbhēna pracāryya tau tatra bahudināni samavātiṣṭhētāṁ| ");
INSERT INTO saniso_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","kintu kiyantō lōkā yihūdīyānāṁ sapakṣāḥ kiyantō lōkāḥ prēritānāṁ sapakṣā jātāḥ, atō nāgarikajananivahamadhyē bhinnavākyatvam abhavat| ");
INSERT INTO saniso_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","anyadēśīyā yihūdīyāstēṣām adhipatayaśca daurātmyaṁ kutvā tau prastarairāhantum udyatāḥ| ");
INSERT INTO saniso_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","tau tadvārttāṁ prāpya palāyitvā lukāyaniyādēśasyāntarvvarttilustrādarbbō ");
INSERT INTO saniso_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","tatsamīpasthadēśañca gatvā tatra susaṁvādaṁ pracārayatāṁ| ");
INSERT INTO saniso_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","tatrōbhayapādayōścalanaśaktihīnō janmārabhya khañjaḥ kadāpi gamanaṁ nākarōt ētādr̥śa ēkō mānuṣō lustrānagara upaviśya paulasya kathāṁ śrutavān| ");
INSERT INTO saniso_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ētasmin samayē paulastamprati dr̥ṣṭiṁ kr̥tvā tasya svāsthyē viśvāsaṁ viditvā prōccaiḥ kathitavān ");
INSERT INTO saniso_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","padbhyāmuttiṣṭhan r̥ju rbhava|tataḥ sa ullamphaṁ kr̥tvā gamanāgamanē kutavān| ");
INSERT INTO saniso_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","tadā lōkāḥ paulasya tat kāryyaṁ vilōkya lukāyanīyabhāṣayā prōccaiḥ kathāmētāṁ kathitavantaḥ, dēvā manuṣyarūpaṁ dhr̥tvāsmākaṁ samīpam avārōhan| ");
INSERT INTO saniso_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","tē barṇabbāṁ yūpitaram avadan paulaśca mukhyō vaktā tasmāt taṁ markuriyam avadan| ");
INSERT INTO saniso_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","tasya nagarasya sammukhē sthāpitasya yūpitaravigrahasya yājakō vr̥ṣān puṣpamālāśca dvārasamīpam ānīya lōkaiḥ sarddhaṁ tāvuddiśya samutsr̥jya dātum udyataḥ| ");
INSERT INTO saniso_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","tadvārttāṁ śrutvā barṇabbāpaulau svīyavastrāṇi chitvā lōkānāṁ madhyaṁ vēgēna praviśya prōccaiḥ kathitavantau, ");
INSERT INTO saniso_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","hē mahēcchāḥ kuta ētādr̥śaṁ karmma kurutha? āvāmapi yuṣmādr̥śau sukhaduḥkhabhōginau manuṣyau, yuyam ētāḥ sarvvā vr̥thākalpanāḥ parityajya yathā gagaṇavasundharājalanidhīnāṁ tanmadhyasthānāṁ sarvvēṣāñca sraṣṭāramamaram īśvaraṁ prati parāvarttadhvē tadartham āvāṁ yuṣmākaṁ sannidhau susaṁvādaṁ pracārayāvaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","sa īśvaraḥ pūrvvakālē sarvvadēśīyalōkān svasvamārgē calitumanumatiṁ dattavān, ");
INSERT INTO saniso_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","tathāpi ākāśāt tōyavarṣaṇēna nānāprakāraśasyōtpatyā ca yuṣmākaṁ hitaiṣī san bhakṣyairānanadēna ca yuṣmākam antaḥkaraṇāni tarpayan tāni dānāni nijasākṣisvarūpāṇi sthapitavān| ");
INSERT INTO saniso_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","kintu tādr̥śāyāṁ kathāyāṁ kathitāyāmapi tayōḥ samīpa utsarjanāt lōkanivahaṁ prāyēṇa nivarttayituṁ nāśaknutām| ");
INSERT INTO saniso_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","āntiyakhiyā-ikaniyanagarābhyāṁ katipayayihūdīyalōkā āgatya lōkān prāvarttayanta tasmāt tai paulaṁ prastarairāghnan tēna sa mr̥ta iti vijñāya nagarasya bahistam ākr̥ṣya nītavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","kintu śiṣyagaṇē tasya caturdiśi tiṣṭhati sati sa svayam utthāya punarapi nagaramadhyaṁ prāviśat tatparē'hani barṇabbāsahitō darbbīnagaraṁ gatavān| ");
INSERT INTO saniso_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","tatra susaṁvādaṁ pracāryya bahulōkān śiṣyān kr̥tvā tau lustrām ikaniyam āntiyakhiyāñca parāvr̥tya gatau| ");
INSERT INTO saniso_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","bahuduḥkhāni bhuktvāpīśvararājyaṁ pravēṣṭavyam iti kāraṇād dharmmamārgē sthātuṁ vinayaṁ kr̥tvā śiṣyagaṇasya manaḥsthairyyam akurutāṁ| ");
INSERT INTO saniso_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","maṇḍalīnāṁ prācīnavargān niyujya prārthanōpavāsau kr̥tvā yatprabhau tē vyaśvasan tasya hastē tān samarpya ");
INSERT INTO saniso_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","pisidiyāmadhyēna pāmphuliyādēśaṁ gatavantau| ");
INSERT INTO saniso_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","paścāt pargānagaraṁ gatvā susaṁvādaṁ pracāryya attāliyānagaraṁ prasthitavantau| ");
INSERT INTO saniso_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","tasmāt samudrapathēna gatvā tābhyāṁ yat karmma sampannaṁ tatkarmma sādhayituṁ yannagarē dayālōrīśvarasya hastē samarpitau jātau tad āntiyakhiyānagaraṁ gatavantā| ");
INSERT INTO saniso_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","tatrōpasthāya tannagarasthamaṇḍalīṁ saṁgr̥hya svābhyāma īśvarō yadyat karmmakarōt tathā yēna prakārēṇa bhinnadēśīyalōkān prati viśvāsarūpadvāram amōcayad ētān sarvvavr̥ttāntān tān jñāpitavantau| ");
INSERT INTO saniso_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","tatastau śiryyaiḥ sārddhaṁ tatra bahudināni nyavasatām| ");
INSERT INTO saniso_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","yihūdādēśāt kiyantō janā āgatya bhrātr̥gaṇamitthaṁ śikṣitavantō mūsāvyavasthayā yadi yuṣmākaṁ tvakchēdō na bhavati tarhi yūyaṁ paritrāṇaṁ prāptuṁ na śakṣyatha| ");
INSERT INTO saniso_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","paulabarṇabbau taiḥ saha bahūn vicārān vivādāṁśca kr̥tavantau, tatō maṇḍalīyanōkā ētasyāḥ kathāyāstattvaṁ jñātuṁ yirūśālamnagarasthān prēritān prācīnāṁśca prati paulabarṇabbāprabhr̥tīn katipayajanān prēṣayituṁ niścayaṁ kr̥tavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","tē maṇḍalyā prēritāḥ santaḥ phaiṇīkīśōmirōndēśābhyāṁ gatvā bhinnadēśīyānāṁ manaḥparivarttanasya vārttayā bhrātr̥ṇāṁ paramāhlādam ajanayan| ");
INSERT INTO saniso_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","yirūśālamyupasthāya prēritagaṇēna lōkaprācīnagaṇēna samājēna ca samupagr̥hītāḥ santaḥ svairīśvarō yāni karmmāṇi kr̥tavān tēṣāṁ sarvvavr̥ttāntān tēṣāṁ samakṣam akathayan| ");
INSERT INTO saniso_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","kintu viśvāsinaḥ kiyantaḥ phirūśimatagrāhiṇō lōkā utthāya kathāmētāṁ kathitavantō bhinnadēśīyānāṁ tvakchēdaṁ karttuṁ mūsāvyavasthāṁ pālayituñca samādēṣṭavyam| ");
INSERT INTO saniso_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","tataḥ prēritā lōkaprācīnāśca tasya vivēcanāṁ karttuṁ sabhāyāṁ sthitavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","bahuvicārēṣu jātaṣu pitara utthāya kathitavān, hē bhrātarō yathā bhinnadēśīyalōkā mama mukhāt susaṁvādaṁ śrutvā viśvasanti tadarthaṁ bahudināt pūrvvam īśvarōsmākaṁ madhyē māṁ vr̥tvā niyuktavān| ");
INSERT INTO saniso_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","antaryyāmīśvarō yathāsmabhyaṁ tathā bhinnadēśīyēbhyaḥ pavitramātmānaṁ pradāya viśvāsēna tēṣām antaḥkaraṇāni pavitrāṇi kr̥tvā ");
INSERT INTO saniso_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","tēṣām asmākañca madhyē kimapi viśēṣaṁ na sthāpayitvā tānadhi svayaṁ pramāṇaṁ dattavān iti yūyaṁ jānītha| ");
INSERT INTO saniso_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","ataēvāsmākaṁ pūrvvapuruṣā vayañca svayaṁ yadyugasya bhāraṁ sōḍhuṁ na śaktāḥ samprati taṁ śiṣyagaṇasya skandhēṣu nyasituṁ kuta īśvarasya parīkṣāṁ kariṣyatha? ");
INSERT INTO saniso_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","prabhō ryīśukhrīṣṭasyānugrahēṇa tē yathā vayamapi tathā paritrāṇaṁ prāptum āśāṁ kurmmaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","anantaraṁ barṇabbāpaulābhyām īśvarō bhinnadēśīyānāṁ madhyē yadyad āścaryyam adbhutañca karmma kr̥tavān tadvr̥ttāntaṁ tau svamukhābhyām avarṇayatāṁ sabhāsthāḥ sarvvē nīravāḥ santaḥ śrutavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","tayōḥ kathāyāṁ samāptāyāṁ satyāṁ yākūb kathayitum ārabdhavān ");
INSERT INTO saniso_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","hē bhrātarō mama kathāyām manō nidhatta| īśvaraḥ svanāmārthaṁ bhinnadēśīyalōkānām madhyād ēkaṁ lōkasaṁghaṁ grahītuṁ matiṁ kr̥tvā yēna prakārēṇa prathamaṁ tān prati kr̥pāvalēkanaṁ kr̥tavān taṁ śimōn varṇitavān| ");
INSERT INTO saniso_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","bhaviṣyadvādibhiruktāni yāni vākyāni taiḥ sārddham ētasyaikyaṁ bhavati yathā likhitamāstē| ");
INSERT INTO saniso_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","sarvvēṣāṁ karmmaṇāṁ yastu sādhakaḥ paramēśvaraḥ| sa ēvēdaṁ vadēdvākyaṁ śēṣāḥ sakalamānavāḥ| bhinnadēśīyalōkāśca yāvantō mama nāmataḥ| bhavanti hi suvikhyātāstē yathā paramēśituḥ| ");
INSERT INTO saniso_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","tatvaṁ samyak samīhantē tannimittamahaṁ kila| parāvr̥tya samāgatya dāyūdaḥ patitaṁ punaḥ| dūṣyamutthāpayiṣyāmi tadīyaṁ sarvvavastu ca| patitaṁ punaruthāpya sajjayiṣyāmi sarvvathā|| ");
INSERT INTO saniso_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ā prathamād īśvaraḥ svīyāni sarvvakarmmāṇi jānāti| ");
INSERT INTO saniso_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","ataēva mama nivēdanamidaṁ bhinnadēśīyalōkānāṁ madhyē yē janā īśvaraṁ prati parāvarttanta tēṣāmupari anyaṁ kamapi bhāraṁ na nyasya ");
INSERT INTO saniso_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","dēvatāprasādāśucibhakṣyaṁ vyabhicārakarmma kaṇṭhasampīḍanamāritaprāṇibhakṣyaṁ raktabhakṣyañca ētāni parityaktuṁ likhāmaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","yataḥ pūrvvakālatō mūsāvyavasthāpracāriṇō lōkā nagarē nagarē santi prativiśrāmavārañca bhajanabhavanē tasyāḥ pāṭhō bhavati| ");
INSERT INTO saniso_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","tataḥ paraṁ prēritagaṇō lōkaprācīnagaṇaḥ sarvvā maṇḍalī ca svēṣāṁ madhyē barśabbā nāmnā vikhyātō manōnītau kr̥tvā paulabarṇabbābhyāṁ sārddham āntiyakhiyānagaraṁ prati prēṣaṇam ucitaṁ buddhvā tābhyāṁ patraṁ praiṣayan| ");
INSERT INTO saniso_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","tasmin patrē likhitamiṁda, āntiyakhiyā-suriyā-kilikiyādēśasthabhinnadēśīyabhrātr̥gaṇāya prēritagaṇasya lōkaprācīnagaṇasya bhrātr̥gaṇasya ca namaskāraḥ| ");
INSERT INTO saniso_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","viśēṣatō'smākam ājñām aprāpyāpi kiyantō janā asmākaṁ madhyād gatvā tvakchēdō mūsāvyavasthā ca pālayitavyāviti yuṣmān śikṣayitvā yuṣmākaṁ manasāmasthairyyaṁ kr̥tvā yuṣmān sasandēhān akurvvan ētāṁ kathāṁ vayam aśr̥nma| ");
INSERT INTO saniso_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","tatkāraṇād vayam ēkamantraṇāḥ santaḥ sabhāyāṁ sthitvā prabhō ryīśukhrīṣṭasya nāmanimittaṁ mr̥tyumukhagatābhyāmasmākaṁ ");
INSERT INTO saniso_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","priyabarṇabbāpaulābhyāṁ sārddhaṁ manōnītalōkānāṁ kēṣāñcid yuṣmākaṁ sannidhau prēṣaṇam ucitaṁ buddhavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","atō yihūdāsīlau yuṣmān prati prēṣitavantaḥ, ētayō rmukhābhyāṁ sarvvāṁ kathāṁ jñāsyatha| ");
INSERT INTO saniso_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","dēvatāprasādabhakṣyaṁ raktabhakṣyaṁ galapīḍanamāritaprāṇibhakṣyaṁ vyabhicārakarmma cēmāni sarvvāṇi yuṣmābhistyājyāni; ētatprayōjanīyājñāvyatirēkēna yuṣmākam upari bhāramanyaṁ na nyasituṁ pavitrasyātmanō'smākañca ucitajñānam abhavat| ");
INSERT INTO saniso_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ataēva tēbhyaḥ sarvvēbhyaḥ svēṣu rakṣitēṣu yūyaṁ bhadraṁ karmma kariṣyatha| yuṣmākaṁ maṅgalaṁ bhūyāt| ");
INSERT INTO saniso_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","tēे visr̥ṣṭāḥ santa āntiyakhiyānagara upasthāya lōkanivahaṁ saṁgr̥hya patram adadan| ");
INSERT INTO saniso_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","tatastē tatpatraṁ paṭhitvā sāntvanāṁ prāpya sānandā abhavan| ");
INSERT INTO saniso_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","yihūdāsīlau ca svayaṁ pracārakau bhūtvā bhrātr̥gaṇaṁ nānōpadiśya tān susthirān akurutām| ");
INSERT INTO saniso_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","itthaṁ tau tatra taiḥ sākaṁ katipayadināni yāpayitvā paścāt prēritānāṁ samīpē pratyāgamanārthaṁ tēṣāṁ sannidhēḥ kalyāṇēna visr̥ṣṭāvabhavatāṁ| ");
INSERT INTO saniso_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","kintu sīlastatra sthātuṁ vāñchitavān| ");
INSERT INTO saniso_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","aparaṁ paulabarṇabbau bahavaḥ śiṣyāśca lōkān upadiśya prabhōḥ susaṁvādaṁ pracārayanta āntiyakhiyāyāṁ kālaṁ yāpitavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","katipayadinēṣu gatēṣu paulō barṇabbām avadat āgacchāvāṁ yēṣu nagarēṣvīśvarasya susaṁvādaṁ pracāritavantau tāni sarvvanagarāṇi punargatvā bhrātaraḥ kīdr̥śāḥ santīti draṣṭuṁ tān sākṣāt kurvvaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","tēna mārkanāmnā vikhyātaṁ yōhanaṁ saṅginaṁ karttuṁ barṇabbā matimakarōt, ");
INSERT INTO saniso_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","kintu sa pūrvvaṁ tābhyāṁ saha kāryyārthaṁ na gatvā pāmphūliyādēśē tau tyaktavān tatkāraṇāt paulastaṁ saṅginaṁ karttum anucitaṁ jñātavān| ");
INSERT INTO saniso_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","itthaṁ tayōratiśayavirōdhasyōpasthitatvāt tau parasparaṁ pr̥thagabhavatāṁ tatō barṇabbā mārkaṁ gr̥hītvā pōtēna kuprōpadvīpaṁ gatavān; ");
INSERT INTO saniso_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","kintu paulaḥ sīlaṁ manōnītaṁ kr̥tvā bhrātr̥bhirīśvarānugrahē samarpitaḥ san prasthāya ");
INSERT INTO saniso_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","suriyākilikiyādēśābhyāṁ maṇḍalīḥ sthirīkurvvan agacchat| ");
INSERT INTO saniso_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","paulō darbbīlustrānagarayōrupasthitōbhavat tatra tīmathiyanāmā śiṣya ēka āsīt; sa viśvāsinyā yihūdīyāyā yōṣitō garbbhajātaḥ kintu tasya pitānyadēśīyalōkaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","sa janō lustrā-ikaniyanagarasthānāṁ bhrātr̥ṇāṁ samīpēpi sukhyātimān āsīt| ");
INSERT INTO saniso_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","paulastaṁ svasaṅginaṁ karttuṁ matiṁ kr̥tvā taṁ gr̥hītvā taddēśanivāsināṁ yihūdīyānām anurōdhāt tasya tvakchēdaṁ kr̥tavān yatastasya pitā bhinnadēśīyalōka iti sarvvairajñāyata| ");
INSERT INTO saniso_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","tataḥ paraṁ tē nagarē nagarē bhramitvā yirūśālamasthaiḥ prēritai rlōkaprācīnaiśca nirūpitaṁ yad vyavasthāpatraṁ tadanusārēṇācarituṁ lōkēbhyastad dattavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","tēnaiva sarvvē dharmmasamājāḥ khrīṣṭadharmmē susthirāḥ santaḥ pratidinaṁ varddhitā abhavan| ");
INSERT INTO saniso_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","tēṣu phrugiyāgālātiyādēśamadhyēna gatēṣu satsu pavitra ātmā tān āśiyādēśē kathāṁ prakāśayituṁ pratiṣiddhavān| ");
INSERT INTO saniso_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","tathā musiyādēśa upasthāya bithuniyāṁ gantuṁ tairudyōgē kr̥tē ātmā tān nānvamanyata| ");
INSERT INTO saniso_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","tasmāt tē musiyādēśaṁ parityajya trōyānagaraṁ gatvā samupasthitāḥ| ");
INSERT INTO saniso_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","rātrau paulaḥ svapnē dr̥ṣṭavān ēkō mākidaniyalōkastiṣṭhan vinayaṁ kr̥tvā tasmai kathayati, mākidaniyādēśam āgatyāsmān upakurvviti| ");
INSERT INTO saniso_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","tasyētthaṁ svapnadarśanāt prabhustaddēśīyalōkān prati susaṁvādaṁ pracārayitum asmān āhūyatīti niścitaṁ buddhvā vayaṁ tūrṇaṁ mākidaniyādēśaṁ gantum udyōgam akurmma| ");
INSERT INTO saniso_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","tataḥ paraṁ vayaṁ trōyānagarād prasthāya r̥jumārgēṇa sāmathrākiyōpadvīpēna gatvā parē'hani niyāpalinagara upasthitāḥ| ");
INSERT INTO saniso_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","tasmād gatvā mākidaniyāntarvvartti rōmīyavasatisthānaṁ yat philipīnāmapradhānanagaraṁ tatrōpasthāya katipayadināni tatra sthitavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","viśrāmavārē nagarād bahi rgatvā nadītaṭē yatra prārthanācāra āsīt tatrōpaviśya samāgatā nārīḥ prati kathāṁ prācārayāma| ");
INSERT INTO saniso_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","tataḥ thuyātīrānagarīyā dhūṣarāmbaravikrāyiṇī ludiyānāmikā yā īśvarasēvikā yōṣit śrōtrīṇāṁ madhya āsīt tayā paulōktavākyāni yad gr̥hyantē tadarthaṁ prabhustasyā manōdvāraṁ muktavān| ");
INSERT INTO saniso_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ataḥ sā yōṣit saparivārā majjitā satī vinayaṁ kr̥tvā kathitavatī, yuṣmākaṁ vicārād yadi prabhau viśvāsinī jātāhaṁ tarhi mama gr̥ham āgatya tiṣṭhata| itthaṁ sā yatnēnāsmān asthāpayat| ");
INSERT INTO saniso_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","yasyā gaṇanayā tadadhipatīnāṁ bahudhanōpārjanaṁ jātaṁ tādr̥śī gaṇakabhūtagrastā kācana dāsī prārthanāsthānagamanakāla āgatyāsmān sākṣāt kr̥tavatī| ");
INSERT INTO saniso_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","sāsmākaṁ paulasya ca paścād ētya prōccaiḥ kathāmimāṁ kathitavatī, manuṣyā ētē sarvvōparisthasyēśvarasya sēvakāḥ santō'smān prati paritrāṇasya mārgaṁ prakāśayanti| ");
INSERT INTO saniso_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","sā kanyā bahudināni tādr̥śam akarōt tasmāt paulō duḥkhitaḥ san mukhaṁ parāvartya taṁ bhūtamavadad, ahaṁ yīśukhrīṣṭasya nāmnā tvāmājñāpayāmi tvamasyā bahirgaccha; tēnaiva tatkṣaṇāt sa bhūtastasyā bahirgataḥ| ");
INSERT INTO saniso_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","tataḥ svēṣāṁ lābhasya pratyāśā viphalā jātēti vilōkya tasyāḥ prabhavaḥ paulaṁ sīlañca dhr̥tvākr̥ṣya vicārasthānē'dhipatīnāṁ samīpam ānayan| ");
INSERT INTO saniso_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","tataḥ śāsakānāṁ nikaṭaṁ nītvā rōmilōkā vayam asmākaṁ yad vyavaharaṇaṁ grahītum ācarituñca niṣiddhaṁ, ");
INSERT INTO saniso_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","imē yihūdīyalōkāḥ santōpi tadēva śikṣayitvā nagarē'smākam atīva kalahaṁ kurvvanti, ");
INSERT INTO saniso_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","iti kathitē sati lōkanivahastayōḥ prātikūlyēnōdatiṣṭhat tathā śāsakāstayō rvastrāṇi chitvā vētrāghātaṁ karttum ājñāpayan| ");
INSERT INTO saniso_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","aparaṁ tē tau bahu prahāryya tvamētau kārāṁ nītvā sāvadhānaṁ rakṣayēti kārārakṣakam ādiśan| ");
INSERT INTO saniso_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ittham ājñāṁ prāpya sa tāvabhyantarasthakārāṁ nītvā pādēṣu pādapāśībhi rbaddhvā sthāpitāvān| ");
INSERT INTO saniso_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","atha niśīthasamayē paulasīlāvīśvaramuddiśya prāthanāṁ gānañca kr̥tavantau, kārāsthitā lōkāśca tadaśr̥ṇvan ");
INSERT INTO saniso_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","tadākasmāt mahān bhūmikampō'bhavat tēna bhittimūlēna saha kārā kampitābhūt tatkṣaṇāt sarvvāṇi dvārāṇi muktāni jātāni sarvvēṣāṁ bandhanāni ca muktāni| ");
INSERT INTO saniso_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","ataēva kārārakṣakō nidrātō jāgaritvā kārāyā dvārāṇi muktāni dr̥ṣṭvā bandilōkāḥ palāyitā ityanumāya kōṣāt khaṅgaṁ bahiḥ kr̥tvātmaghātaṁ karttum udyataḥ| ");
INSERT INTO saniso_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","kintu paulaḥ prōccaistamāhūya kathitavān paśya vayaṁ sarvvē'trāsmahē, tvaṁ nijaprāṇahiṁsāṁ mākārṣīḥ| ");
INSERT INTO saniso_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","tadā pradīpam ānētum uktvā sa kampamānaḥ san ullampyābhyantaram āgatya paulasīlayōḥ pādēṣu patitavān| ");
INSERT INTO saniso_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","paścāt sa tau bahirānīya pr̥ṣṭavān hē mahēcchau paritrāṇaṁ prāptuṁ mayā kiṁ karttavyaṁ? ");
INSERT INTO saniso_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","paścāt tau svagr̥hamānīya tayōḥ sammukhē khādyadravyāṇi sthāpitavān tathā sa svayaṁ tadīyāḥ sarvvē parivārāścēśvarē viśvasantaḥ sānanditā abhavan| ");
INSERT INTO saniso_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","tasmai tasya gr̥hasthitasarvvalōkēbhyaśca prabhōḥ kathāṁ kathitavantau| ");
INSERT INTO saniso_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","tathā rātrēstasminnēva daṇḍē sa tau gr̥hītvā tayōḥ prahārāṇāṁ kṣatāni prakṣālitavān tataḥ sa svayaṁ tasya sarvvē parijanāśca majjitā abhavan| ");
INSERT INTO saniso_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","paścāt tau svagr̥hamānīya tayōḥ sammukhē khādyadravyāṇi sthāpitavān tathā sa svayaṁ tadīyāḥ sarvvē parivārāścēśvarē viśvasantaḥ sānanditā abhavan| ");
INSERT INTO saniso_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","dina upasthitē tau lōkau mōcayēti kathāṁ kathayituṁ śāsakāḥ padātigaṇaṁ prēṣitavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","tataḥ kārārakṣakaḥ paulāya tāṁ vārttāṁ kathitavān yuvāṁ tyājayituṁ śāsakā lōkāna prēṣitavanta idānīṁ yuvāṁ bahi rbhūtvā kuśalēna pratiṣṭhētāṁ| ");
INSERT INTO saniso_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","kintu paulastān avadat rōmilōkayōrāvayōḥ kamapi dōṣam na niścitya sarvvēṣāṁ samakṣam āvāṁ kaśayā tāḍayitvā kārāyāṁ baddhavanta idānīṁ kimāvāṁ guptaṁ vistrakṣyanti? tanna bhaviṣyati, svayamāgatyāvāṁ bahiḥ kr̥tvā nayantu| ");
INSERT INTO saniso_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","tadā padātibhiḥ śāsakēbhya ētadvārttāyāṁ kathitāyāṁ tau rōmilōkāviti kathāṁ śrutvā tē bhītāḥ ");
INSERT INTO saniso_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","santastayōḥ sannidhimāgatya vinayam akurvvan aparaṁ bahiḥ kr̥tvā nagarāt prasthātuṁ prārthitavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","tatastau kārāyā nirgatya ludiyāyā gr̥haṁ gatavantau tatra bhrātr̥gaṇaṁ sākṣātkr̥tya tān sāntvayitvā tasmāt sthānāt prasthitau| ");
INSERT INTO saniso_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","paulasīlau āmphipalyāpallōniyānagarābhyāṁ gatvā yatra yihūdīyānāṁ bhajanabhavanamēkam āstē tatra thiṣalanīkīnagara upasthitau| ");
INSERT INTO saniso_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","tadā paulaḥ svācārānusārēṇa tēṣāṁ samīpaṁ gatvā viśrāmavāratrayē taiḥ sārddhaṁ dharmmapustakīyakathāyā vicāraṁ kr̥tavān| ");
INSERT INTO saniso_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","phalataḥ khrīṣṭēna duḥkhabhōgaḥ karttavyaḥ śmaśānadutthānañca karttavyaṁ yuṣmākaṁ sannidhau yasya yīśōḥ prastāvaṁ karōmi sa īśvarēṇābhiṣiktaḥ sa ētāḥ kathāḥ prakāśya pramāṇaṁ datvā sthirīkr̥tavān| ");
INSERT INTO saniso_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","tasmāt tēṣāṁ katipayajanā anyadēśīyā bahavō bhaktalōkā bahyaḥ pradhānanāryyaśca viśvasya paulasīlayōḥ paścādgāminō jātāḥ| ");
INSERT INTO saniso_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","kintu viśvāsahīnā yihūdīyalōkā īrṣyayā paripūrṇāḥ santō haṭaṭsya katinayalampaṭalōkān saṅginaḥ kr̥tvā janatayā nagaramadhyē mahākalahaṁ kr̥tvā yāsōnō gr̥ham ākramya prēritān dhr̥tvā lōkanivahasya samīpam ānētuṁ cēṣṭitavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","tēṣāmuddēśam aprāpya ca yāsōnaṁ katipayān bhrātr̥ṁśca dhr̥tvā nagarādhipatīnāṁ nikaṭamānīya prōccaiḥ kathitavantō yē manuṣyā jagadudvāṭitavantastē 'trāpyupasthitāḥ santi, ");
INSERT INTO saniso_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ēṣa yāsōn ātithyaṁ kr̥tvā tān gr̥hītavān| yīśunāmaka ēkō rājastīti kathayantastē kaisarasyājñāviruddhaṁ karmma kurvvati| ");
INSERT INTO saniso_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","tēṣāṁ kathāmimāṁ śrutvā lōkanivahō nagarādhipatayaśca samudvignā abhavan| ");
INSERT INTO saniso_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","tadā yāsōnastadanyēṣāñca dhanadaṇḍaṁ gr̥hītvā tān parityaktavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","tataḥ paraṁ bhrātr̥gaṇō rajanyāṁ paulasīlau śīghraṁ birayānagaraṁ prēṣitavān tau tatrōpasthāya yihūdīyānāṁ bhajanabhavanaṁ gatavantau| ");
INSERT INTO saniso_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","tatrasthā lōkāḥ thiṣalanīkīsthalōkēbhyō mahātmāna āsan yata itthaṁ bhavati na vēti jñātuṁ dinē dinē dharmmagranthasyālōcanāṁ kr̥tvā svairaṁ kathām agr̥hlan| ");
INSERT INTO saniso_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","tasmād anēkē yihūdīyā anyadēśīyānāṁ mānyā striyaḥ puruṣāścānēkē vyaśvasan| ");
INSERT INTO saniso_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","kintu birayānagarē paulēnēśvarīyā kathā pracāryyata iti thiṣalanīkīsthā yihūdīyā jñātvā tatsthānamapyāgatya lōkānāṁ kupravr̥ttim ajanayan| ");
INSERT INTO saniso_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","ataēva tasmāt sthānāt samudrēṇa yāntīti darśayitvā bhrātaraḥ kṣipraṁ paulaṁ prāhiṇvan kintu sīlatīmathiyau tatra sthitavantau| ");
INSERT INTO saniso_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","tataḥ paraṁ paulasya mārgadarśakāstam āthīnīnagara upasthāpayan paścād yuvāṁ tūrṇam ētat sthānaṁ āgamiṣyathaḥ sīlatīmathiyau pratīmām ājñāṁ prāpya tē pratyāgatāḥ| ");
INSERT INTO saniso_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","paula āthīnīnagarē tāvapēkṣya tiṣṭhan tannagaraṁ pratimābhiḥ paripūrṇaṁ dr̥ṣṭvā santaptahr̥dayō 'bhavat| ");
INSERT INTO saniso_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","tataḥ sa bhajanabhavanē yān yihūdīyān bhaktalōkāṁśca haṭṭē ca yān apaśyat taiḥ saha pratidinaṁ vicāritavān| ");
INSERT INTO saniso_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","kintvipikūrīyamatagrahiṇaḥ stōyikīyamatagrāhiṇaśca kiyantō janāstēna sārddhaṁ vyavadanta| tatra kēcid akathayan ēṣa vācālaḥ kiṁ vaktum icchati? aparē kēcid ēṣa janaḥ kēṣāñcid vidēśīyadēvānāṁ pracāraka ityanumīyatē yataḥ sa yīśum utthitiñca pracārayat| ");
INSERT INTO saniso_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","tē tam arēyapāganāma vicārasthānam ānīya prāvōcan idaṁ yannavīnaṁ mataṁ tvaṁ prācīkaśa idaṁ kīdr̥śaṁ ētad asmān śrāvaya; ");
INSERT INTO saniso_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","yāmimām asambhavakathām asmākaṁ karṇagōcarīkr̥tavān asyā bhāvārthaḥ ka iti vayaṁ jñātum icchāmaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","tadāthīnīnivāsinastannagarapravāsinaśca kēvalaṁ kasyāścana navīnakathāyāḥ śravaṇēna pracāraṇēna ca kālam ayāpayan| ");
INSERT INTO saniso_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","paulō'rēyapāgasya madhyē tiṣṭhan ētāṁ kathāṁ pracāritavān, hē āthīnīyalōkā yūyaṁ sarvvathā dēvapūjāyām āsaktā ityaha pratyakṣaṁ paśyāmi| ");
INSERT INTO saniso_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","yataḥ paryyaṭanakālē yuṣmākaṁ pūjanīyāni paśyan ‘avijñātēśvarāya’ ētallipiyuktāṁ yajñavēdīmēkāṁ dr̥ṣṭavān; atō na viditvā yaṁ pūjayadhvē tasyaiva tatvaṁ yuṣmān prati pracārayāmi| ");
INSERT INTO saniso_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","jagatō jagatsthānāṁ sarvvavastūnāñca sraṣṭā ya īśvaraḥ sa svargapr̥thivyōrēkādhipatiḥ san karanirmmitamandirēṣu na nivasati; ");
INSERT INTO saniso_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","sa ēva sarvvēbhyō jīvanaṁ prāṇān sarvvasāmagrīśca pradadāti; ataēva sa kasyāścit sāmagyrā abhāvahētō rmanuṣyāṇāṁ hastaiḥ sēvitō bhavatīti na| ");
INSERT INTO saniso_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","sa bhūmaṇḍalē nivāsārtham ēkasmāt śōṇitāt sarvvān manuṣyān sr̥ṣṭvā tēṣāṁ pūrvvanirūpitasamayaṁ vasatisīmāñca niracinōt; ");
INSERT INTO saniso_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","tasmāt lōkaiḥ kēnāpi prakārēṇa mr̥gayitvā paramēśvarasya tatvaṁ prāptuṁ tasya gavēṣaṇaṁ karaṇīyam| ");
INSERT INTO saniso_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","kintu sō'smākaṁ kasmāccidapi dūrē tiṣṭhatīti nahi, vayaṁ tēna niśvasanapraśvasanagamanāgamanaprāṇadhāraṇāni kurmmaḥ, puुnaśca yuṣmākamēva katipayāḥ kavayaḥ kathayanti ‘tasya vaṁśā vayaṁ smō hi’ iti| ");
INSERT INTO saniso_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","ataēva yadi vayam īśvarasya vaṁśā bhavāmastarhi manuṣyai rvidyayā kauśalēna ca takṣitaṁ svarṇaṁ rūpyaṁ dr̥ṣad vaitēṣāmīśvaratvam asmābhi rna jñātavyaṁ| ");
INSERT INTO saniso_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","tēṣāṁ pūrvvīyalōkānām ajñānatāṁ pratīśvarō yadyapi nāvādhatta tathāpīdānīṁ sarvvatra sarvvān manaḥ parivarttayitum ājñāpayati, ");
INSERT INTO saniso_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","yataḥ svaniyuktēna puruṣēṇa yadā sa pr̥thivīsthānāṁ sarvvalōkānāṁ vicāraṁ kariṣyati taddinaṁ nyarūpayat; tasya śmaśānōtthāpanēna tasmin sarvvēbhyaḥ pramāṇaṁ prādāt| ");
INSERT INTO saniso_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","tadā śmaśānād utthānasya kathāṁ śrutvā kēcid upāhaman, kēcidavadan ēnāṁ kathāṁ punarapi tvattaḥ śrōṣyāmaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","tataḥ paulastēṣāṁ samīpāt prasthiाtavān| ");
INSERT INTO saniso_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","tathāpi kēcillōkāstēna sārddhaṁ militvā vyaśvasan tēṣāṁ madhyē 'rēyapāgīyadiyanusiyō dāmārīnāmā kācinnārī kiyantō narāścāsan| ");
INSERT INTO saniso_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","tadghaṭanātaḥ paraṁ paula āthīnīnagarād yātrāṁ kr̥tvā karinthanagaram āgacchat| ");
INSERT INTO saniso_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","tasmin samayē klaudiyaḥ sarvvān yihūdīyān rōmānagaraṁ vihāya gantum ājñāpayat, tasmāt priskillānāmnā jāyayā sārddham itāliyādēśāt kiñcitpūrvvam āgamat yaḥ pantadēśē jāta ākkilanāmā yihūdīyalōkaḥ paulastaṁ sākṣāt prāpya tayōḥ samīpamitavān| ");
INSERT INTO saniso_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","tau dūṣyanirmmāṇajīvinau, tasmāt parasparam ēkavr̥ttikatvāt sa tābhyāṁ saha uṣitvā tat karmmākarōt| ");
INSERT INTO saniso_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","paulaḥ prativiśrāmavāraṁ bhajanabhavanaṁ gatvā vicāraṁ kr̥tvā yihūdīyān anyadēśīyāṁśca pravr̥ttiṁ grāhitavān| ");
INSERT INTO saniso_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","sīlatīmathiyayō rmākidaniyādēśāt samētayōḥ satōḥ paula uttaptamanā bhūtvā yīśurīśvarēṇābhiṣiktō bhavatīti pramāṇaṁ yihūdīyānāṁ samīpē prādāt| ");
INSERT INTO saniso_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","kintu tē 'tīva virōdhaṁ vidhāya pāṣaṇḍīyakathāṁ kathitavantastataḥ paulō vastraṁ dhunvan ētāṁ kathāṁ kathitavān, yuṣmākaṁ śōṇitapātāparādhō yuṣmān pratyēva bhavatu, tēnāhaṁ niraparādhō 'dyārabhya bhinnadēśīyānāṁ samīpaṁ yāmi| ");
INSERT INTO saniso_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","sa tasmāt prasthāya bhajanabhavanasamīpasthasya yustanāmna īśvarabhaktasya bhinnadēśīyasya nivēśanaṁ prāviśat| ");
INSERT INTO saniso_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","tataḥ krīṣpanāmā bhajanabhavanādhipatiḥ saparivāraḥ prabhau vyaśvasīt, karinthanagarīyā bahavō lōkāśca samākarṇya viśvasya majjitā abhavan| ");
INSERT INTO saniso_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","kṣaṇadāyāṁ prabhuḥ paulaṁ darśanaṁ datvā bhāṣitavān, mā bhaiṣīḥ, mā nirasīḥ kathāṁ pracāraya| ");
INSERT INTO saniso_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ahaṁ tvayā sārddham āsa hiṁsārthaṁ kōpi tvāṁ spraṣṭuṁ na śakṣyati nagarē'smin madīyā lōkā bahava āsatē| ");
INSERT INTO saniso_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","tasmāt paulastannagarē prāyēṇa sārddhavatsaraparyyantaṁ saṁsthāyēśvarasya kathām upādiśat| ");
INSERT INTO saniso_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","gālliyanāmā kaścid ākhāyādēśasya prāḍvivākaḥ samabhavat, tatō yihūdīyā ēkavākyāḥ santaḥ paulam ākramya vicārasthānaṁ nītvā ");
INSERT INTO saniso_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","mānuṣa ēṣa vyavasthāya viruddham īśvarabhajanaṁ karttuṁ lōkān kupravr̥ttiṁ grāhayatīti nivēditavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","tataḥ paulē pratyuttaraṁ dātum udyatē sati gālliyā yihūdīyān vyāharat, yadi kasyacid anyāyasya vātiśayaduṣṭatācaraṇasya vicārō'bhaviṣyat tarhi yuṣmākaṁ kathā mayā sahanīyābhaviṣyat| ");
INSERT INTO saniso_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","kintu yadi kēvalaṁ kathāyā vā nāmnō vā yuṣmākaṁ vyavasthāyā vivādō bhavati tarhi tasya vicāramahaṁ na kariṣyāmi, yūyaṁ tasya mīmāṁsāṁ kuruta| ");
INSERT INTO saniso_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","tataḥ sa tān vicārasthānād dūrīkr̥tavān| ");
INSERT INTO saniso_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","tadā bhinnadēśīyāḥ sōsthinināmānaṁ bhajanabhavanasya pradhānādhipatiṁ dhr̥tvā vicārasthānasya sammukhē prāharan tathāpi gālliyā tēṣu sarvvakarmmasu na manō nyadadhāt| ");
INSERT INTO saniso_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","paulastatra punarbahudināni nyavasat, tatō bhrātr̥gaṇād visarjanaṁ prāpya kiñcanavratanimittaṁ kiṁkriyānagarē śirō muṇḍayitvā priskillākkilābhyāṁ sahitō jalapathēna suriyādēśaṁ gatavān| ");
INSERT INTO saniso_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","tata iphiṣanagara upasthāya tatra tau visr̥jya svayaṁ bhajanabhvanaṁ praviśya yihūdīyaiḥ saha vicāritavān| ");
INSERT INTO saniso_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","tē svaiḥ sārddhaṁ punaḥ katipayadināni sthātuṁ taṁ vyanayan, sa tadanurarīkr̥tya kathāmētāṁ kathitavān, ");
INSERT INTO saniso_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","yirūśālami āgāmyutsavapālanārthaṁ mayā gamanīyaṁ; paścād īśvarēcchāyāṁ jātāyāṁ yuṣmākaṁ samīpaṁ pratyāgamiṣyāmi| tataḥ paraṁ sa tai rvisr̥ṣṭaḥ san jalapathēna iphiṣanagarāt prasthitavān| ");
INSERT INTO saniso_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","tataḥ kaisariyām upasthitaḥ san nagaraṁ gatvā samājaṁ namaskr̥tya tasmād āntiyakhiyānagaraṁ prasthitavān| ");
INSERT INTO saniso_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","tatra kiyatkālaṁ yāpayitvā tasmāt prasthāya sarvvēṣāṁ śiṣyāṇāṁ manāṁsi susthirāṇi kr̥tvā kramaśō galātiyāphrugiyādēśayō rbhramitvā gatavān| ");
INSERT INTO saniso_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","tasminnēva samayē sikandariyānagarē jāta āpallōnāmā śāstravit suvaktā yihūdīya ēkō jana iphiṣanagaram āgatavān| ");
INSERT INTO saniso_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","sa śikṣitaprabhumārgō manasōdyōgī ca san yōhanō majjanamātraṁ jñātvā yathārthatayā prabhōḥ kathāṁ kathayan samupādiśat| ");
INSERT INTO saniso_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ēṣa janō nirbhayatvēna bhajanabhavanē kathayitum ārabdhavān, tataḥ priskillākkilau tasyōpadēśakathāṁ niśamya taṁ svayōḥ samīpam ānīya śuddharūpēṇēśvarasya kathām abōdhayatām| ");
INSERT INTO saniso_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","paścāt sa ākhāyādēśaṁ gantuṁ matiṁ kr̥tavān, tadā tatratyaḥ śiṣyagaṇō yathā taṁ gr̥hlāti tadarthaṁ bhrātr̥gaṇēna samāśvasya patrē likhitē sati, āpallāstatrōpasthitaḥ san anugrahēṇa pratyayināṁ bahūpakārān akarōt, ");
INSERT INTO saniso_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","phalatō yīśurabhiṣiktastrātēti śāstrapramāṇaṁ datvā prakāśarūpēṇa pratipannaṁ kr̥tvā yihūdīyān niruttarān kr̥tavān| ");
INSERT INTO saniso_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","karinthanagara āpallasaḥ sthitikālē paula uttarapradēśairāgacchan iphiṣanagaram upasthitavān| tatra katipayaśiṣyān sākṣat prāpya tān apr̥cchat, ");
INSERT INTO saniso_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","yūyaṁ viśvasya pavitramātmānaṁ prāptā na vā? tatastē pratyavadan pavitra ātmā dīyatē ityasmābhiḥ śrutamapi nahi| ");
INSERT INTO saniso_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","tadā sā'vadat tarhi yūyaṁ kēna majjitā abhavata? tē'kathayan yōhanō majjanēna| ");
INSERT INTO saniso_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","tadā paula uktavān itaḥ paraṁ ya upasthāsyati tasmin arthata yīśukhrīṣṭē viśvasitavyamityuktvā yōhan manaḥparivarttanasūcakēna majjanēna jalē lōkān amajjayat| ");
INSERT INTO saniso_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","tādr̥śīṁ kathāṁ śrutvā tē prabhō ryīśukhrīṣṭasya nāmnā majjitā abhavan| ");
INSERT INTO saniso_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","tataḥ paulēna tēṣāṁ gātrēṣu karē'rpitē tēṣāmupari pavitra ātmāvarūḍhavān, tasmāt tē nānādēśīyā bhāṣā bhaviṣyatkathāśca kathitavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","tē prāyēṇa dvādaśajanā āsan| ");
INSERT INTO saniso_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","paulō bhajanabhavanaṁ gatvā prāyēṇa māsatrayam īśvarasya rājyasya vicāraṁ kr̥tvā lōkān pravartya sāhasēna kathāmakathayat| ");
INSERT INTO saniso_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","kintu kaṭhināntaḥkaraṇatvāt kiyantō janā na viśvasya sarvvēṣāṁ samakṣam ētatpathasya nindāṁ karttuṁ pravr̥ttāḥ, ataḥ paulastēṣāṁ samīpāt prasthāya śiṣyagaṇaṁ pr̥thakkr̥tvā pratyahaṁ turānnanāmnaḥ kasyacit janasya pāṭhaśālāyāṁ vicāraṁ kr̥tavān| ");
INSERT INTO saniso_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","itthaṁ vatsaradvayaṁ gataṁ tasmād āśiyādēśanivāsinaḥ sarvvē yihūdīyā anyadēśīyalōkāśca prabhō ryīśōḥ kathām aśrauṣan| ");
INSERT INTO saniso_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","paulēna ca īśvara ētādr̥śānyadbhutāni karmmāṇi kr̥tavān ");
INSERT INTO saniso_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","yat paridhēyē gātramārjanavastrē vā tasya dēhāt pīḍitalōkānām samīpam ānītē tē nirāmayā jātā apavitrā bhūtāśca tēbhyō bahirgatavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","tadā dēśāṭanakāriṇaḥ kiyantō yihūdīyā bhūtāpasāriṇō bhūtagrastanōkānāṁ sannidhau prabhē ryīśō rnāma japtvā vākyamidam avadan, yasya kathāṁ paulaḥ pracārayati tasya yīśō rnāmnā yuṣmān ājñāpayāmaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","skivanāmnō yihūdīyānāṁ pradhānayājakasya saptabhiḥ puttaistathā kr̥tē sati ");
INSERT INTO saniso_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","kaścid apavitrō bhūtaḥ pratyuditavān, yīśuṁ jānāmi paulañca paricinōmi kintu kē yūyaṁ? ");
INSERT INTO saniso_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ityuktvā sōpavitrabhūtagrastō manuṣyō lamphaṁ kr̥tvā tēṣāmupari patitvā balēna tān jitavān, tasmāttē nagnāḥ kṣatāṅgāśca santastasmād gēhāt palāyanta| ");
INSERT INTO saniso_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","sā vāg iphiṣanagaranivāsinasaṁ sarvvēṣāṁ yihūdīyānāṁ bhinnadēśīyānāṁ lōkānāñca śravōgōcarībhūtā; tataḥ sarvvē bhayaṁ gatāḥ prabhō ryīśō rnāmnō yaśō 'varddhata| ");
INSERT INTO saniso_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","yēṣāmanēkēṣāṁ lōkānāṁ pratītirajāyata ta āgatya svaiḥ kr̥tāḥ kriyāḥ prakāśarūpēṇāṅgīkr̥tavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","bahavō māyākarmmakāriṇaḥ svasvagranthān ānīya rāśīkr̥tya sarvvēṣāṁ samakṣam adāhayan, tatō gaṇanāṁ kr̥tvābudhyanta pañcāyutarūpyamudrāmūlyapustakāni dagdhāni| ");
INSERT INTO saniso_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","itthaṁ prabhōḥ kathā sarvvadēśaṁ vyāpya prabalā jātā| ");
INSERT INTO saniso_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","sarvvēṣvētēṣu karmmasu sampannēṣu satsu paulō mākidaniyākhāyādēśābhyāṁ yirūśālamaṁ gantuṁ matiṁ kr̥tvā kathitavān tatsthānaṁ yātrāyāṁ kr̥tāyāṁ satyāṁ mayā rōmānagaraṁ draṣṭavyaṁ| ");
INSERT INTO saniso_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","svānugatalōkānāṁ tīmathiyērāstau dvau janau mākidaniyādēśaṁ prati prahitya svayam āśiyādēśē katipayadināni sthitavān| ");
INSERT INTO saniso_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","kintu tasmin samayē matē'smin kalahō jātaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","tatkāraṇamidaṁ, arttimīdēvyā rūpyamandiranirmmāṇēna sarvvēṣāṁ śilpināṁ yathēṣṭalābham ajanayat yō dīmītriyanāmā nāḍīndhamaḥ ");
INSERT INTO saniso_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","sa tān tatkarmmajīvinaḥ sarvvalōkāṁśca samāhūya bhāṣitavān hē mahēcchā ētēna mandiranirmmāṇēnāsmākaṁ jīvikā bhavati, ētad yūyaṁ vittha; ");
INSERT INTO saniso_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","kintu hastanirmmitēśvarā īśvarā nahi paulanāmnā kēnacijjanēna kathāmimāṁ vyāhr̥tya kēvalēphiṣanagarē nahi prāyēṇa sarvvasmin āśiyādēśē pravr̥ttiṁ grāhayitvā bahulōkānāṁ śēmuṣī parāvarttitā, ētad yuṣmābhi rdr̥śyatē śrūyatē ca| ");
INSERT INTO saniso_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","tēnāsmākaṁ vāṇijyasya sarvvathā hānēḥ sambhavanaṁ kēvalamiti nahi, āśiyādēśasthai rvā sarvvajagatsthai rlōkaiḥ pūjyā yārtimī mahādēvī tasyā mandirasyāvajñānasya tasyā aiśvaryyasya nāśasya ca sambhāvanā vidyatēे| ");
INSERT INTO saniso_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","ētādr̥śīṁ kathāṁ śrutvā tē mahākrōdhānvitāḥ santa uccaiḥkāraṁ kathitavanta iphiṣīyānām arttimī dēvī mahatī bhavati| ");
INSERT INTO saniso_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","tataḥ sarvvanagaraṁ kalahēna paripūrṇamabhavat, tataḥ paraṁ tē mākidanīyagāyāristārkhanāmānau paulasya dvau sahacarau dhr̥tvaikacittā raṅgabhūmiṁ javēna dhāvitavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","tataḥ paulō lōkānāṁ sannidhiṁ yātum udyatavān kintu śiṣyagaṇastaṁ vāritavān| ");
INSERT INTO saniso_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","paulasyatmīyā āśiyādēśasthāḥ katipayāḥ pradhānalōkāstasya samīpaṁ naramēkaṁ prēṣya tvaṁ raṅgabhūmiṁ māgā iti nyavēdayan| ");
INSERT INTO saniso_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","tatō nānālōkānāṁ nānākathākathanāt sabhā vyākulā jātā kiṁ kāraṇād ētāvatī janatābhavat ētad adhikai rlōkai rnājñāyi| ");
INSERT INTO saniso_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","tataḥ paraṁ janatāmadhyād yihūdīyairbahiṣkr̥taḥ sikandarō hastēna saṅkētaṁ kr̥tvā lōkēbhya uttaraṁ dātumudyatavān, ");
INSERT INTO saniso_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","kintu sa yihūdīyalōka iti niścitē sati iphiṣīyānām arttimī dēvī mahatīti vākyaṁ prāyēṇa pañca daṇḍān yāvad ēkasvarēṇa lōkanivahaiḥ prōktaṁ| ");
INSERT INTO saniso_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","tatō nagarādhipatistān sthirān kr̥tvā kathitavān hē iphiṣāyāḥ sarvvē lōkā ākarṇayata, artimīmahādēvyā mahādēvāt patitāyāstatpratimāyāśca pūjanama iphiṣanagarasthāḥ sarvvē lōkāḥ kurvvanti, ētat kē na jānanti? ");
INSERT INTO saniso_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","tasmād ētatpratikūlaṁ kēpi kathayituṁ na śaknuvanti, iti jñātvā yuṣmābhiḥ susthiratvēna sthātavyam avivicya kimapi karmma na karttavyañca| ");
INSERT INTO saniso_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","yān ētān manuṣyān yūyamatra samānayata tē mandiradravyāpahārakā yuṣmākaṁ dēvyā nindakāśca na bhavanti| ");
INSERT INTO saniso_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","yadi kañcana prati dīmītriyasya tasya sahāyānāñca kācid āpatti rvidyatē tarhi pratinidhilōkā vicārasthānañca santi, tē tat sthānaṁ gatvā uttarapratyuttarē kurvvantu| ");
INSERT INTO saniso_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","kintu yuṣmākaṁ kācidaparā kathā yadi tiṣṭhati tarhi niyamitāyāṁ sabhāyāṁ tasyā niṣpatti rbhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","kintvētasya virōdhasyōttaraṁ yēna dātuṁ śaknum ētādr̥śasya kasyacit kāraṇasyābhāvād adyatanaghaṭanāhētō rājadrōhiṇāmivāsmākam abhiyōgō bhaviṣyatīti śaṅkā vidyatē| ");
INSERT INTO saniso_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","iti kathayitvā sa sabhāsthalōkān visr̥ṣṭavān| ");
INSERT INTO saniso_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","itthaṁ kalahē nivr̥ttē sati paulaḥ śiṣyagaṇam āhūya visarjanaṁ prāpya mākidaniyādēśaṁ prasthitavān| ");
INSERT INTO saniso_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","tēna sthānēna gacchan taddēśīyān śiṣyān bahūpadiśya yūnānīyadēśam upasthitavān| ");
INSERT INTO saniso_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","tatra māsatrayaṁ sthitvā tasmāt suriyādēśaṁ yātum udyataḥ, kintu yihūdīyāstaṁ hantuṁ guptā atiṣṭhan tasmāt sa punarapi mākidaniyāmārgēṇa pratyāgantuṁ matiṁ kr̥tavān| ");
INSERT INTO saniso_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","birayānagarīyasōpātraḥ thiṣalanīkīyāristārkhasikundau darbbōnagarīyagāyatīmathiyau āśiyādēśīyatukhikatraphimau ca tēna sārddhaṁ āśiyādēśaṁ yāvad gatavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ētē sarvvē 'grasarāḥ santō 'smān apēkṣya trōyānagarē sthitavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","kiṇvaśūnyapūpōtsavadinē ca gatē sati vayaṁ philipīnagarāt tōyapathēna gatvā pañcabhi rdinaistrōyānagaram upasthāya tatra saptadinānyavātiṣṭhāma| ");
INSERT INTO saniso_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","saptāhasya prathamadinē pūpān bhaṁktu śiṣyēṣu militēṣu paulaḥ paradinē tasmāt prasthātum udyataḥ san tadahni prāyēṇa kṣapāyā yāmadvayaṁ yāvat śiṣyēbhyō dharmmakathām akathayat| ");
INSERT INTO saniso_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","uparisthē yasmin prakōṣṭhē sabhāṁ kr̥tvāsan tatra bahavaḥ pradīpāḥ prājvalan| ");
INSERT INTO saniso_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","utukhanāmā kaścana yuvā ca vātāyana upaviśan ghōrataranidrāgrastō 'bhūt tadā paulēna bahukṣaṇaṁ kathāyāṁ pracāritāyāṁ nidrāmagnaḥ sa tasmād uparisthatr̥tīyaprakōṣṭhād apatat, tatō lōkāstaṁ mr̥takalpaṁ dhr̥tvōdatōlayan| ");
INSERT INTO saniso_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","tataḥ paulō'varuhya tasya gātrē patitvā taṁ krōḍē nidhāya kathitavān, yūyaṁ vyākulā mā bhūta nāyaṁ prāṇai rviyuktaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","paścāt sa punaścōpari gatvā pūpān bhaṁktvā prabhātaṁ yāvat kathōpakathanē kr̥tvā prasthitavān| ");
INSERT INTO saniso_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","tē ca taṁ jīvantaṁ yuvānaṁ gr̥hītvā gatvā paramāpyāyitā jātāḥ| ");
INSERT INTO saniso_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","anantaraṁ vayaṁ pōtēnāgrasarā bhūtvāsmanagaram uttīryya paulaṁ grahītuṁ matim akurmma yataḥ sa tatra padbhyāṁ vrajituṁ matiṁ kr̥tvēti nirūpitavān| ");
INSERT INTO saniso_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","tasmāt tatrāsmābhiḥ sārddhaṁ tasmin militē sati vayaṁ taṁ nītvā mitulīnyupadvīpaṁ prāptavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","tasmāt pōtaṁ mōcayitvā parē'hani khīyōpadvīpasya sammukhaṁ labdhavantastasmād ēkēnāhnā sāmōpadvīpaṁ gatvā pōtaṁ lāgayitvā trōgulliyē sthitvā parasmin divasēे milītanagaram upātiṣṭhāma| ");
INSERT INTO saniso_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","yataḥ paula āśiyādēśē kālaṁ yāpayitum nābhilaṣan iphiṣanagaraṁ tyaktvā yātuṁ mantraṇāṁ sthirīkr̥tavān; yasmād yadi sādhyaṁ bhavati tarhi nistārōtsavasya pañcāśattamadinē sa yirūśālamyupasthātuṁ matiṁ kr̥tavān| ");
INSERT INTO saniso_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","paulō milītād iphiṣaṁ prati lōkaṁ prahitya samājasya prācīnān āhūyānītavān| ");
INSERT INTO saniso_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","tēṣu tasya samīpam upasthitēṣu sa tēbhya imāṁ kathāṁ kathitavān, aham āśiyādēśē prathamāgamanam ārabhyādya yāvad yuṣmākaṁ sannidhau sthitvā sarvvasamayē yathācaritavān tad yūyaṁ jānītha; ");
INSERT INTO saniso_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","phalataḥ sarvvathā namramanāḥ san bahuśrupātēna yihudīyānām kumantraṇājātanānāparīkṣābhiḥ prabhōḥ sēvāmakaravaṁ| ");
INSERT INTO saniso_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","kāmapi hitakathāाṁ na gōpāyitavān tāṁ pracāryya saprakāśaṁ gr̥hē gr̥hē samupadiśyēśvaraṁ prati manaḥ parāvarttanīyaṁ prabhau yīśukhrīṣṭē viśvasanīyaṁ ");
INSERT INTO saniso_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","yihūdīyānām anyadēśīyalōkānāñca samīpa ētādr̥śaṁ sākṣyaṁ dadāmi| ");
INSERT INTO saniso_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","paśyata sāmpratam ātmanākr̥ṣṭaḥ san yirūśālamnagarē yātrāṁ karōmi, tatra māmprati yadyad ghaṭiṣyatē tānyahaṁ na jānāmi; ");
INSERT INTO saniso_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","kintu mayā bandhanaṁ klēśaśca bhōktavya iti pavitra ātmā nagarē nagarē pramāṇaṁ dadāti| ");
INSERT INTO saniso_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","tathāpi taṁ klēśamahaṁ tr̥ṇāya na manyē; īśvarasyānugrahaviṣayakasya susaṁvādasya pramāṇaṁ dātuṁ, prabhō ryīśōḥ sakāśāda yasyāḥ sēvāyāḥ bhāraṁ prāpnavaṁ tāṁ sēvāṁ sādhayituṁ sānandaṁ svamārgaṁ samāpayituुñca nijaprāṇānapi priyān na manyē| ");
INSERT INTO saniso_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","adhunā paśyata yēṣāṁ samīpē'ham īśvarīyarājyasya susaṁvādaṁ pracāryya bhramaṇaṁ kr̥tavān ētādr̥śā yūyaṁ mama vadanaṁ puna rdraṣṭuṁ na prāpsyatha ētadapyahaṁ jānāmi| ");
INSERT INTO saniso_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","yuṣmabhyam aham īśvarasya sarvvān ādēśān prakāśayituṁ na nyavarttē| ");
INSERT INTO saniso_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","ahaṁ sarvvēṣāṁ lōkānāṁ raktapātadōṣād yannirdōṣa āsē tasyādya yuṣmān sākṣiṇaḥ karōmi| ");
INSERT INTO saniso_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","yūyaṁ svēṣu tathā yasya vrajasyādhyakṣan ātmā yuṣmān vidhāya nyayuṅkta tatsarvvasmin sāvadhānā bhavata, ya samājañca prabhu rnijaraktamūlyēna krītavāna tam avata, ");
INSERT INTO saniso_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","yatō mayā gamanē kr̥taēva durjayā vr̥kā yuṣmākaṁ madhyaṁ praviśya vrajaṁ prati nirdayatām ācariṣyanti, ");
INSERT INTO saniso_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","yuṣmākamēva madhyādapi lōkā utthāya śiṣyagaṇam apahantuṁ viparītam upadēkṣyantītyahaṁ jānāmi| ");
INSERT INTO saniso_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","iti hētō ryūyaṁ sacaitanyāḥ santastiṣṭata, ahañca sāśrupātaḥ san vatsaratrayaṁ yāvad divāniśaṁ pratijanaṁ bōdhayituṁ na nyavarttē tadapi smarata| ");
INSERT INTO saniso_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","idānīṁ hē bhrātarō yuṣmākaṁ niṣṭhāṁ janayituṁ pavitrīkr̥talōkānāṁ madhyē'dhikārañca dātuṁ samarthō ya īśvarastasyānugrahasya yō vādaśca tayōrubhayō ryuṣmān samārpayam| ");
INSERT INTO saniso_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","kasyāpi svarṇaṁ rūpyaṁ vastraṁ vā prati mayā lōbhō na kr̥taḥ| ");
INSERT INTO saniso_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","kintu mama matsahacaralōkānāñcāvaśyakavyayāya madīyamidaṁ karadvayam aśrāmyad ētad yūyaṁ jānītha| ");
INSERT INTO saniso_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","anēna prakārēṇa grahaṇad dānaṁ bhadramiti yadvākyaṁ prabhu ryīśuḥ kathitavān tat smarttuṁ daridralōkānāmupakārārthaṁ śramaṁ karttuñca yuṣmākam ucitam ētatsarvvaṁ yuṣmānaham upadiṣṭavān| ");
INSERT INTO saniso_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ētāṁ kathāṁ kathayitvā sa jānunī pātayitvā sarvaiḥ saha prārthayata| ");
INSERT INTO saniso_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","tēna tē krandrantaḥ ");
INSERT INTO saniso_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","puna rmama mukhaṁ na drakṣyatha viśēṣata ēṣā yā kathā tēnākathi tatkāraṇāt śōkaṁ vilāpañca kr̥tvā kaṇṭhaṁ dhr̥tvā cumbitavantaḥ| paścāt tē taṁ pōtaṁ nītavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","tai rvisr̥ṣṭāḥ santō vayaṁ pōtaṁ bāhayitvā r̥jumārgēṇa kōṣam upadvīpam āgatya parē'hani rōdiyōpadvīpam āgacchāma tatastasmāt pātārāyām upātiṣṭhāma| ");
INSERT INTO saniso_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","tatra phainīkiyādēśagāminam pōtamēkaṁ prāpya tamāruhya gatavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","kuprōpadvīpaṁ dr̥ṣṭvā taṁ savyadiśi sthāpayitvā suriyādēśaṁ gatvā pōtasthadravyāṇyavarōhayituṁ sōranagarē lāgitavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","tatra śiṣyagaṇasya sākṣātkaraṇāya vayaṁ tatra saptadināni sthitavantaḥ paścāttē pavitrēṇātmanā paulaṁ vyāharan tvaṁ yirūśālamnagaraṁ mā gamaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","tatastēṣu saptasu dinēṣu yāpitēṣu satsu vayaṁ tasmāt sthānāt nijavartmanā gatavantaḥ, tasmāt tē sabālavr̥ddhavanitā asmābhiḥ saha nagarasya parisaraparyyantam āgatāḥ paścādvayaṁ jaladhitaṭē jānupātaṁ prārthayāmahi| ");
INSERT INTO saniso_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","tataḥ parasparaṁ visr̥ṣṭāḥ santō vayaṁ pōtaṁ gatāstē tu svasvagr̥haṁ pratyāgatavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","vayaṁ sōranagarāt nāvā prasthāya talimāyinagaram upātiṣṭhāma tatrāsmākaṁ samudrīyamārgasyāntō'bhavat tatra bhrātr̥gaṇaṁ namaskr̥tya dinamēkaṁ taiḥ sārddham uṣatavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","parē 'hani paulastasya saṅginō vayañca pratiṣṭhamānāḥ kaisariyānagaram āgatya susaṁvādapracārakānāṁ saptajanānāṁ philipanāmna ēkasya gr̥haṁ praviśyāvatiṣṭhāma| ");
INSERT INTO saniso_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","tasya catasrō duhitarō'nūḍhā bhaviṣyadvādinya āsan| ");
INSERT INTO saniso_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","tatrāsmāsu bahudināni prōṣitēṣu yihūdīyadēśād āgatyāgābanāmā bhaviṣyadvādī samupasthitavān| ");
INSERT INTO saniso_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","sōsmākaṁ samīpamētya paulasya kaṭibandhanaṁ gr̥hītvā nijahastāpādān baddhvā bhāṣitavān yasyēdaṁ kaṭibandhanaṁ taṁ yihūdīyalōkā yirūśālamanagara itthaṁ baddhvā bhinnadēśīyānāṁ karēṣu samarpayiṣyantīti vākyaṁ pavitra ātmā kathayati| ");
INSERT INTO saniso_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ētādr̥śīṁ kathāṁ śrutvā vayaṁ tannagaravāsinō bhrātaraśca yirūśālamaṁ na yātuṁ paulaṁ vyanayāmahi; ");
INSERT INTO saniso_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","kintu sa pratyāvādīt, yūyaṁ kiṁ kurutha? kiṁ krandanēna mamāntaḥkaraṇaṁ vidīrṇaṁ kariṣyatha? prabhō ryīśō rnāmnō nimittaṁ yirūśālami baddhō bhavituṁ kēvala tanna prāṇān dātumapi sasajjōsmi| ");
INSERT INTO saniso_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","tēnāsmākaṁ kathāyām agr̥hītāyām īśvarasya yathēcchā tathaiva bhavatvityuktvā vayaṁ nirasyāma| ");
INSERT INTO saniso_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","parē'hani pāthēyadravyāṇi gr̥hītvā yirūśālamaṁ prati yātrām akurmma| ");
INSERT INTO saniso_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","tataḥ kaisariyānagaranivāsinaḥ katipayāḥ śiṣyā asmābhiḥ sārddham itvā kr̥prīyēna mnāsannāmnā yēna prācīnaśiṣyēna sārddham asmābhi rvastavyaṁ tasya samīpam asmān nītavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","asmāsu yirūśālamyupasthitēṣu tatrasthabhrātr̥gaṇō'smān āhlādēna gr̥hītavān| ");
INSERT INTO saniso_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","parasmin divasē paulē'smābhiḥ saha yākūbō gr̥haṁ praviṣṭē lōkaprācīnāḥ sarvvē tatra pariṣadi saṁsthitāḥ| ");
INSERT INTO saniso_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","anantaraṁ sa tān natvā svīyapracāraṇēna bhinnadēśīyān pratīśvarō yāni karmmāṇi sādhitavān tadīyāṁ kathām anukramāt kathitavān| ");
INSERT INTO saniso_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","iti śrutvā tē prabhuṁ dhanyaṁ prōcya vākyamidam abhāṣanta, hē bhrāta ryihūdīyānāṁ madhyē bahusahasrāṇi lōkā viśvāsina āsatē kintu tē sarvvē vyavasthāmatācāriṇa ētat pratyakṣaṁ paśyasi| ");
INSERT INTO saniso_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","śiśūnāṁ tvakchēdanādyācaraṇaṁ pratiṣidhya tvaṁ bhinnadēśanivāsinō yihūdīyalōkān mūsāvākyam aśraddhātum upadiśasīti taiḥ śrutamasti| ");
INSERT INTO saniso_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","tvamatrāgatōsīti vārttāṁ samākarṇya jananivahō militvāvaśyamēvāgamiṣyati; ataēva kiṁ karaṇīyam? atra vayaṁ mantrayitvā samupāyaṁ tvāṁ vadāmastaṁ tvamācara| ");
INSERT INTO saniso_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","vrataṁ karttuṁ kr̥tasaṅkalpā yē'smāṁka catvārō mānavāḥ santi ");
INSERT INTO saniso_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","tān gr̥hītvā taiḥ sahitaḥ svaṁ śuciṁ kuru tathā tēṣāṁ śirōmuṇḍanē yō vyayō bhavati taṁ tvaṁ dēhi| tathā kr̥tē tvadīyācārē yā janaśruti rjāyatē sālīkā kintu tvaṁ vidhiṁ pālayan vyavasthānusārēṇēvācarasīti tē bhōtsantē| ");
INSERT INTO saniso_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","bhinnadēśīyānāṁ viśvāsilōkānāṁ nikaṭē vayaṁ patraṁ likhitvētthaṁ sthirīkr̥tavantaḥ, dēvaprasādabhōjanaṁ raktaṁ galapīḍanamāritaprāṇibhōjanaṁ vyabhicāraścaitēbhyaḥ svarakṣaṇavyatirēkēṇa tēṣāmanyavidhipālanaṁ karaṇīyaṁ na| ");
INSERT INTO saniso_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","tataḥ paulastān mānuṣānādāya parasmin divasē taiḥ saha śuci rbhūtvā mandiraṁ gatvā śaucakarmmaṇō dinēṣu sampūrṇēṣu tēṣām ēkaikārthaṁ naivēdyādyutsargō bhaviṣyatīti jñāpitavān| ");
INSERT INTO saniso_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","tēṣu saptasu dinēṣu samāptakalpēṣu āśiyādēśanivāsinō yihūdīyāstaṁ madhyēmandiraṁ vilōkya jananivahasya manaḥsu kupravr̥ttiṁ janayitvā taṁ dhr̥tvā ");
INSERT INTO saniso_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","prōccaiḥ prāvōcan, hē isrāyēllōkāḥ sarvvē sāhāyyaṁ kuruta| yō manuja ētēṣāṁ lōkānāṁ mūsāvyavasthāyā ētasya sthānasyāpi viparītaṁ sarvvatra sarvvān śikṣayati sa ēṣaḥ; viśēṣataḥ sa bhinnadēśīyalōkān mandiram ānīya pavitrasthānamētad apavitramakarōt| ");
INSERT INTO saniso_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","pūrvvaṁ tē madhyēnagaram iphiṣanagarīyaṁ traphimaṁ paulēna sahitaṁ dr̥ṣṭavanta ētasmāt paulastaṁ mandiramadhyam ānayad ityanvamimata| ");
INSERT INTO saniso_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","ataēva sarvvasmin nagarē kalahōtpannatvāt dhāvantō lōkā āgatya paulaṁ dhr̥tvā mandirasya bahirākr̥ṣyānayan tatkṣaṇād dvārāṇi sarvvāṇi ca ruddhāni| ");
INSERT INTO saniso_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","tēṣu taṁ hantumudyatēेṣu yirūśālamnagarē mahānupadravō jāta iti vārttāyāṁ sahasrasēnāpatēḥ karṇagōcarībhūtāyāṁ satyāṁ sa tatkṣaṇāt sainyāni sēnāpatigaṇañca gr̥hītvā javēnāgatavān| ");
INSERT INTO saniso_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","tatō lōkāḥ sēnāgaṇēna saha sahasrasēnāpatim āgacchantaṁ dr̥ṣṭvā paulatāḍanātō nyavarttanta| ");
INSERT INTO saniso_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","sa sahasrasēnāpatiḥ sannidhāvāgamya paulaṁ dhr̥tvā śr̥ṅkhaladvayēna baddham ādiśya tān pr̥ṣṭavān ēṣa kaḥ? kiṁ karmma cāyaṁ kr̥tavān? ");
INSERT INTO saniso_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","tatō janasamūhasya kaścid ēkaprakāraṁ kaścid anyaprakāraṁ vākyam araut sa tatra satyaṁ jñātum kalahakāraṇād aśaktaḥ san taṁ durgaṁ nētum ājñāpayat| ");
INSERT INTO saniso_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","tēṣu sōpānasyōpari prāptēṣu lōkānāṁ sāhasakāraṇāt sēnāgaṇaḥ paulamuttōlya nītavān| ");
INSERT INTO saniso_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","tataḥ sarvvē lōkāḥ paścādgāminaḥ santa ēnaṁ durīkurutēti vākyam uccairavadan| ");
INSERT INTO saniso_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","paulasya durgānayanasamayē sa tasmai sahasrasēnāpatayē kathitavān, bhavataḥ purastāt kathāṁ kathayituṁ kim anumanyatē? sa tamapr̥cchat tvaṁ kiṁ yūnānīyāṁ bhāṣāṁ jānāsi? ");
INSERT INTO saniso_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","yō misarīyō janaḥ pūrvvaṁ virōdhaṁ kr̥tvā catvāri sahasrāṇi ghātakān saṅginaḥ kr̥tvā vipinaṁ gatavān tvaṁ kiṁ saēva na bhavasi? ");
INSERT INTO saniso_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","tadā paulō'kathayat ahaṁ kilikiyādēśasya tārṣanagarīyō yihūdīyō, nāhaṁ sāmānyanagarīyō mānavaḥ; ataēva vinayē'haṁ lākānāṁ samakṣaṁ kathāṁ kathayituṁ māmanujānīṣva| ");
INSERT INTO saniso_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","tēnānujñātaḥ paulaḥ sōpānōpari tiṣṭhan hastēnēṅgitaṁ kr̥tavān, tasmāt sarvvē susthirā abhavan| tadā paula ibrīyabhāṣayā kathayitum ārabhata, ");
INSERT INTO saniso_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","hē pitr̥gaṇā hē bhrātr̥gaṇāḥ, idānīṁ mama nivēdanē samavadhatta| ");
INSERT INTO saniso_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","tadā sa ibrīyabhāṣayā kathāṁ kathayatīti śrutvā sarvvē lōkā atīva niḥśabdā santō'tiṣṭhan| ");
INSERT INTO saniso_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","paścāt sō'kathayad ahaṁ yihūdīya iti niścayaḥ kilikiyādēśasya tārṣanagaraṁ mama janmabhūmiḥ,ētannagarīyasya gamilīyēlanāmnō'dhyāpakasya śiṣyō bhūtvā pūrvvapuruṣāṇāṁ vidhivyavasthānusārēṇa sampūrṇarūpēṇa śikṣitō'bhavam idānīntanā yūyaṁ yādr̥śā bhavatha tādr̥śō'hamapīśvarasēvāyām udyōgī jātaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","matamētad dviṣṭvā tadgrāhinārīpuruṣān kārāyāṁ baddhvā tēṣāṁ prāṇanāśaparyyantāṁ vipakṣatām akaravam| ");
INSERT INTO saniso_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","mahāyājakaḥ sabhāsadaḥ prācīnalōkāśca mamaitasyāḥ kathāyāḥ pramāṇaṁ dātuṁ śaknuvanti, yasmāt tēṣāṁ samīpād dammēṣakanagaranivāsibhrātr̥gaṇārtham ājñāpatrāṇi gr̥hītvā yē tatra sthitāstān daṇḍayituṁ yirūśālamam ānayanārthaṁ dammēṣakanagaraṁ gatōsmi| ");
INSERT INTO saniso_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","kintu gacchan tannagarasya samīpaṁ prāptavān tadā dvitīyapraharavēlāyāṁ satyām akasmād gagaṇānnirgatya mahatī dīpti rmama caturdiśi prakāśitavatī| ");
INSERT INTO saniso_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","tatō mayi bhūmauै patitē sati, hē śaula hē śaula kutō māṁ tāḍayasi? māmprati bhāṣita ētādr̥śa ēkō ravōpi mayā śrutaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","tadāhaṁ pratyavadaṁ, hē prabhē kō bhavān? tataḥ sō'vādīt yaṁ tvaṁ tāḍayasi sa nāsaratīyō yīśurahaṁ| ");
INSERT INTO saniso_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","mama saṅginō lōkāstāṁ dīptiṁ dr̥ṣṭvā bhiyaṁ prāptāḥ, kintu māmpratyuditaṁ tadvākyaṁ tēे nābudhyanta| ");
INSERT INTO saniso_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","tataḥ paraṁ pr̥ṣṭavānahaṁ, hē prabhō mayā kiṁ karttavyaṁ? tataḥ prabhurakathayat, utthāya dammēṣakanagaraṁ yāhi tvayā yadyat karttavyaṁ nirūpitamāstē tat tatra tvaṁ jñāpayiṣyasē| ");
INSERT INTO saniso_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","anantaraṁ tasyāḥ kharataradīptēḥ kāraṇāt kimapi na dr̥ṣṭvā saṅgigaṇēna dhr̥tahastaḥ san dammēṣakanagaraṁ vrajitavān| ");
INSERT INTO saniso_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","tannagaranivāsināṁ sarvvēṣāṁ yihūdīyānāṁ mānyō vyavasthānusārēṇa bhaktaśca hanānīyanāmā mānava ēkō ");
INSERT INTO saniso_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","mama sannidhim ētya tiṣṭhan akathayat, hē bhrātaḥ śaula sudr̥ṣṭi rbhava tasmin daṇḍē'haṁ samyak taṁ dr̥ṣṭavān| ");
INSERT INTO saniso_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","tataḥ sa mahyaṁ kathitavān yathā tvam īśvarasyābhiprāyaṁ vētsi tasya śuddhasattvajanasya darśanaṁ prāpya tasya śrīmukhasya vākyaṁ śr̥ṇōṣi tannimittam asmākaṁ pūrvvapuruṣāṇām īśvarastvāṁ manōnītaṁ kr̥tavānaṁ| ");
INSERT INTO saniso_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","yatō yadyad adrākṣīraśrauṣīśca sarvvēṣāṁ mānavānāṁ samīpē tvaṁ tēṣāṁ sākṣī bhaviṣyasi| ");
INSERT INTO saniso_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","ataēva kutō vilambasē? prabhō rnāmnā prārthya nijapāpaprakṣālanārthaṁ majjanāya samuttiṣṭha| ");
INSERT INTO saniso_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","tataḥ paraṁ yirūśālamnagaraṁ pratyāgatya mandirē'ham ēkadā prārthayē, tasmin samayē'ham abhibhūtaḥ san prabhūṁ sākṣāt paśyan, ");
INSERT INTO saniso_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","tvaṁ tvarayā yirūśālamaḥ pratiṣṭhasva yatō lōkāmayi tava sākṣyaṁ na grahīṣyanti, māmpratyuditaṁ tasyēdaṁ vākyam aśrauṣam| ");
INSERT INTO saniso_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","tatōhaṁ pratyavādiṣam hē prabhō pratibhajanabhavanaṁ tvayi viśvāsinō lōkān baddhvā prahr̥tavān, ");
INSERT INTO saniso_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","tathā tava sākṣiṇaḥ stiphānasya raktapātanasamayē tasya vināśaṁ sammanya sannidhau tiṣṭhan hantr̥lōkānāṁ vāsāṁsi rakṣitavān, ētat tē viduḥ| ");
INSERT INTO saniso_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","tataḥ sō'kathayat pratiṣṭhasva tvāṁ dūrasthabhinnadēśīyānāṁ samīpaṁ prēṣayiṣyē| ");
INSERT INTO saniso_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","tadā lōkā ētāvatparyyantāṁ tadīyāṁ kathāṁ śrutvā prōccairakathayan, ēnaṁ bhūmaṇḍalād dūrīkuruta, ētādr̥śajanasya jīvanaṁ nōcitam| ");
INSERT INTO saniso_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ityuccaiḥ kathayitvā vasanāni parityajya gagaṇaṁ prati dhūlīrakṣipan ");
INSERT INTO saniso_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","tataḥ sahasrasēnāpatiḥ paulaṁ durgābhyantara nētuṁ samādiśat| ētasya pratikūlāḥ santō lōkāḥ kinnimittam ētāvaduccaiḥsvaram akurvvan, ētad vēttuṁ taṁ kaśayā prahr̥tya tasya parīkṣāṁ karttumādiśat| ");
INSERT INTO saniso_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","padātayaścarmmanirmmitarajjubhistasya bandhanaṁ karttumudyatāstāstadānīṁ paulaḥ sammukhasthitaṁ śatasēnāpatim uktavān daṇḍājñāyām aprāptāyāṁ kiṁ rōmilōkaṁ praharttuṁ yuṣmākam adhikārōsti? ");
INSERT INTO saniso_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","ēnāṁ kathāṁ śrutvā sa sahasrasēnāpatēḥ sannidhiṁ gatvā tāṁ vārttāmavadat sa rōmilōka ētasmāt sāvadhānaḥ san karmma kuru| ");
INSERT INTO saniso_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","tasmāt sahasrasēnāpati rgatvā tamaprākṣīt tvaṁ kiṁ rōmilōkaḥ? iti māṁ brūhi| sō'kathayat satyam| ");
INSERT INTO saniso_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","tataḥ sahasrasēnāpatiḥ kathitavān bahudraviṇaṁ dattvāhaṁ tat paurasakhyaṁ prāptavān; kintu paulaḥ kathitavān ahaṁ janunā tat prāptō'smi| ");
INSERT INTO saniso_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","itthaṁ sati yē prahārēṇa taṁ parīkṣituṁ samudyatā āsan tē tasya samīpāt prātiṣṭhanta; sahasrasēnāpatistaṁ rōmilōkaṁ vijñāya svayaṁ yat tasya bandhanam akārṣīt tatkāraṇād abibhēt| ");
INSERT INTO saniso_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","yihūdīyalōkāḥ paulaṁ kutō'pavadantē tasya vr̥ttāntaṁ jñātuṁ vāñchan sahasrasēnāpatiḥ parē'hani paulaṁ bandhanāt mōcayitvā pradhānayājakān mahāsabhāyāḥ sarvvalōkāśca samupasthātum ādiśya tēṣāṁ sannidhau paulam avarōhya sthāpitavān| ");
INSERT INTO saniso_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","sabhāsadlōkān prati paulō'nanyadr̥ṣṭyā paśyan akathayat, hē bhrātr̥gaṇā adya yāvat saralēna sarvvāntaḥkaraṇēnēśvarasya sākṣād ācarāmi| ");
INSERT INTO saniso_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","anēna hanānīyanāmā mahāyājakastaṁ kapōlē capēṭēnāhantuṁ samīpasthalōkān ādiṣṭavān| ");
INSERT INTO saniso_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","tadā paulastamavadat, hē bahiṣpariṣkr̥ta, īśvarastvāṁ praharttum udyatōsti, yatō vyavasthānusārēṇa vicārayitum upaviśya vyavasthāṁ laṅghitvā māṁ praharttum ājñāpayasi| ");
INSERT INTO saniso_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","tatō nikaṭasthā lōkā akathayan, tvaṁ kim īśvarasya mahāyājakaṁ nindasi? ");
INSERT INTO saniso_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","tataḥ paulaḥ pratibhāṣitavān hē bhrātr̥gaṇa mahāyājaka ēṣa iti na buddhaṁ mayā tadanyacca svalōkānām adhipatiṁ prati durvvākyaṁ mā kathaya, ētādr̥śī lipirasti| ");
INSERT INTO saniso_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","anantaraṁ paulastēṣām arddhaṁ sidūkilōkā arddhaṁ phirūśilōkā iti dr̥ṣṭvā prōccaiḥ sabhāsthalōkān avadat hē bhrātr̥gaṇa ahaṁ phirūśimatāvalambī phirūśinaḥ satnānaśca, mr̥talōkānām utthānē pratyāśākaraṇād ahamapavāditōsmi| ");
INSERT INTO saniso_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","iti kathāyāṁ kathitāyāṁ phirūśisidūkinōḥ parasparaṁ bhinnavākyatvāt sabhāyā madhyē dvau saṁghau jātau| ");
INSERT INTO saniso_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","yataḥ sidūkilōkā utthānaṁ svargīyadūtā ātmānaśca sarvvēṣām ētēṣāṁ kamapi na manyantē, kintu phirūśinaḥ sarvvam aṅgīkurvvanti| ");
INSERT INTO saniso_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","tataḥ parasparam atiśayakōlāhalē samupasthitē phirūśināṁ pakṣīyāḥ sabhāsthā adhyāpakāḥ pratipakṣā uttiṣṭhantō 'kathayan, ētasya mānavasya kamapi dōṣaṁ na paśyāmaḥ; yadi kaścid ātmā vā kaścid dūta ēnaṁ pratyādiśat tarhi vayam īśvarasya prātikūlyēna na yōtsyāmaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","tasmād atīva bhinnavākyatvē sati tē paulaṁ khaṇḍaṁ khaṇḍaṁ kariṣyantītyāśaṅkayā sahasrasēnāpatiḥ sēnāgaṇaṁ tatsthānaṁ yātuṁ sabhātō balāt paulaṁ dhr̥tvā durgaṁ nētañcājñāpayat| ");
INSERT INTO saniso_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","rātrō prabhustasya samīpē tiṣṭhan kathitavān hē paula nirbhayō bhava yathā yirūśālamnagarē mayi sākṣyaṁ dattavān tathā rōmānagarēpi tvayā dātavyam| ");
INSERT INTO saniso_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","dinē samupasthitē sati kiyantō yihūdīyalōkā ēkamantraṇāḥ santaḥ paulaṁ na hatvā bhōjanapānē kariṣyāma iti śapathēna svān abadhnan| ");
INSERT INTO saniso_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","catvāriṁśajjanēbhyō'dhikā lōkā iti paṇam akurvvan| ");
INSERT INTO saniso_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","tē mahāyājakānāṁ prācīnalōkānāñca samīpaṁ gatvā kathayan, vayaṁ paulaṁ na hatvā kimapi na bhōkṣyāmahē dr̥ḍhēnānēna śapathēna baddhvā abhavāma| ");
INSERT INTO saniso_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","ataēva sāmprataṁ sabhāsadlōkaiḥ saha vayaṁ tasmin kañcid viśēṣavicāraṁ kariṣyāmastadarthaṁ bhavān śvō 'smākaṁ samīpaṁ tam ānayatviti sahasrasēnāpatayē nivēdanaṁ kuruta tēna yuṣmākaṁ samīpaṁ upasthitēḥ pūrvvaṁ vayaṁ taṁ hantu sajjiṣyāma| ");
INSERT INTO saniso_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","tadā paulasya bhāginēyastēṣāmiti mantraṇāṁ vijñāya durgaṁ gatvā tāṁ vārttāṁ paulam uktavān| ");
INSERT INTO saniso_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","tasmāt paula ēkaṁ śatasēnāpatim āhūya vākyamidam bhāṣitavān sahasrasēnāpatēḥ samīpē'sya yuvamanuṣyasya kiñcinnivēdanam āstē, tasmāt tatsavidham ēnaṁ naya| ");
INSERT INTO saniso_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","tataḥ sa tamādāya sahasrasēnāpatēḥ samīpam upasthāya kathitavān, bhavataḥ samīpē'sya kimapi nivēdanamāstē tasmāt bandiḥ paulō māmāhūya bhavataḥ samīpam ēnam ānētuṁ prārthitavān| ");
INSERT INTO saniso_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","tadā sahasrasēnāpatistasya hastaṁ dhr̥tvā nirjanasthānaṁ nītvā pr̥ṣṭhavān tava kiṁ nivēdanaṁ? tat kathaya| ");
INSERT INTO saniso_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","tataḥ sōkathayat, yihūdīyalākāḥ paulē kamapi viśēṣavicāraṁ chalaṁ kr̥tvā taṁ sabhāṁ nētuṁ bhavataḥ samīpē nivēdayituṁ amantrayan| ");
INSERT INTO saniso_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","kintu mavatā tanna svīkarttavyaṁ yatastēṣāṁ madhyēvarttinaścatvāriṁśajjanēbhyō 'dhikalōkā ēkamantraṇā bhūtvā paulaṁ na hatvā bhōjanaṁ pānañca na kariṣyāma iti śapathēna baddhāḥ santō ghātakā iva sajjitā idānīṁ kēvalaṁ bhavatō 'numatim apēkṣantē| ");
INSERT INTO saniso_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","yāmimāṁ kathāṁ tvaṁ nivēditavān tāṁ kasmaicidapi mā kathayētyuktvā sahasrasēnāpatistaṁ yuvānaṁ visr̥ṣṭavān| ");
INSERT INTO saniso_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","anantaraṁ sahasrasēnāpati rdvau śatasēnāpatī āhūyēdam ādiśat, yuvāṁ rātrau praharaikāvaśiṣṭāyāṁ satyāṁ kaisariyānagaraṁ yātuṁ padātisainyānāṁ dvē śatē ghōṭakārōhisainyānāṁ saptatiṁ śaktidhārisainyānāṁ dvē śatē ca janān sajjitān kurutaṁ| ");
INSERT INTO saniso_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","paulam ārōhayituṁ phīlikṣādhipatēḥ samīpaṁ nirvvighnaṁ nētuñca vāhanāni samupasthāpayataṁ| ");
INSERT INTO saniso_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","aparaṁ sa patraṁ likhitvā dattavān tallikhitamētat, ");
INSERT INTO saniso_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","mahāmahimaśrīyuktaphīlikṣādhipatayē klaudiyaluṣiyasya namaskāraḥ| ");
INSERT INTO saniso_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","yihūdīyalōkāḥ pūrvvam ēnaṁ mānavaṁ dhr̥tvā svahastai rhantum udyatā ētasminnantarē sasainyōhaṁ tatrōpasthāya ēṣa janō rōmīya iti vijñāya taṁ rakṣitavān| ");
INSERT INTO saniso_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","kinnimittaṁ tē tamapavadantē tajjñātuṁ tēṣā sabhāṁ tamānāyitavān| ");
INSERT INTO saniso_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","tatastēṣāṁ vyavasthāyā viruddhayā kayācana kathayā sō'pavāditō'bhavat, kintu sa śr̥ṅkhalabandhanārhō vā prāṇanāśārhō bhavatīdr̥śaḥ kōpyaparādhō mayāsya na dr̥ṣṭaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","tathāpi manuṣyasyāsya vadhārthaṁ yihūdīyā ghātakāiva sajjitā ētāṁ vārttāṁ śrutvā tatkṣaṇāt tava samīpamēnaṁ prēṣitavān asyāpavādakāṁśca tava samīpaṁ gatvāpavaditum ājñāpayam| bhavataḥ kuśalaṁ bhūyāt| ");
INSERT INTO saniso_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","sainyagaṇa ājñānusārēṇa paulaṁ gr̥hītvā tasyāṁ rajanyām āntipātrinagaram ānayat| ");
INSERT INTO saniso_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","parē'hani tēna saha yātuṁ ghōṭakārūḍhasainyagaṇaṁ sthāpayitvā parāvr̥tya durgaṁ gatavān| ");
INSERT INTO saniso_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","tataḥ parē ghōṭakārōhisainyagaṇaḥ kaisariyānagaram upasthāya tatpatram adhipatēḥ karē samarpya tasya samīpē paulam upasthāpitavān| ");
INSERT INTO saniso_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","tadādhipatistatpatraṁ paṭhitvā pr̥ṣṭhavān ēṣa kimpradēśīyō janaḥ? sa kilikiyāpradēśīya ēkō jana iti jñātvā kathitavān, ");
INSERT INTO saniso_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","tavāpavādakagaṇa āgatē tava kathāṁ śrōṣyāmi| hērōdrājagr̥hē taṁ sthāpayitum ādiṣṭavān| ");
INSERT INTO saniso_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","pañcabhyō dinēbhyaḥ paraṁ hanānīyanāmā mahāyājakō'dhipatēḥ samakṣaṁ paulasya prātikūlyēna nivēdayituṁ tartullanāmānaṁ kañcana vaktāraṁ prācīnajanāṁśca saṅginaḥ kr̥tvā kaisariyānagaram āgacchat| ");
INSERT INTO saniso_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","tataḥ paulē samānītē sati tartullastasyāpavādakathāṁ kathayitum ārabhata hē mahāmahimaphīlikṣa bhavatō vayam atinirvvighnaṁ kālaṁ yāpayāmō bhavataḥ pariṇāmadarśitayā ētaddēśīyānāṁ bahūni maṅgalāni ghaṭitāni, ");
INSERT INTO saniso_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","iti hētō rvayamatikr̥tajñāḥ santaḥ sarvvatra sarvvadā bhavatō guṇān gāyamaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","kintu bahubhiḥ kathābhi rbhavantaṁ yēna na virañjayāmi tasmād vinayē bhavān banukampya madalpakathāṁ śr̥ṇōtu| ");
INSERT INTO saniso_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","ēṣa mahāmārīsvarūpō nāsaratīyamatagrāhisaṁghātasya mukhyō bhūtvā sarvvadēśēṣu sarvvēṣāṁ yihūdīyānāṁ rājadrōhācaraṇapravr̥ttiṁ janayatītyasmābhi rniścitaṁ| ");
INSERT INTO saniso_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","sa mandiramapi aśuci karttuṁ cēṣṭitavān; iti kāraṇād vayam ēnaṁ dhr̥tvā svavyavasthānusārēṇa vicārayituṁ prāvarttāmahi; ");
INSERT INTO saniso_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","kintu luṣiyaḥ sahasrasēnāpatirāgatya balād asmākaṁ karēbhya ēnaṁ gr̥hītvā ");
INSERT INTO saniso_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ētasyāpavādakān bhavataḥ samīpam āgantum ājñāpayat| vayaṁ yasmin tamapavādāmō bhavatā padapavādakathāyāṁ vicāritāyāṁ satyāṁ sarvvaṁ vr̥ttāntaṁ vēdituṁ śakṣyatē| ");
INSERT INTO saniso_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","tatō yihūdīyā api svīkr̥tya kathitavanta ēṣā kathā pramāṇam| ");
INSERT INTO saniso_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","adhipatau kathāṁ kathayituṁ paulaṁ pratīṅgitaṁ kr̥tavati sa kathitavān bhavān bahūn vatsarān yāvad ētaddēśasya śāsanaṁ karōtīti vijñāya pratyuttaraṁ dātum akṣōbhō'bhavam| ");
INSERT INTO saniso_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","adya kēvalaṁ dvādaśa dināni yātāni, aham ārādhanāṁ karttuṁ yirūśālamanagaraṁ gatavān ēṣā kathā bhavatā jñātuṁ śakyatē; ");
INSERT INTO saniso_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","kintvibhē māṁ madhyēmandiraṁ kēnāpi saha vitaṇḍāṁ kurvvantaṁ kutrāpi bhajanabhavanē nagarē vā lōkān kupravr̥ttiṁ janayantuṁ na dr̥ṣṭavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","idānīṁ yasmin yasmin mām apavadantē tasya kimapi pramāṇaṁ dātuṁ na śaknuvanti| ");
INSERT INTO saniso_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","kintu bhaviṣyadvākyagranthē vyavasthāgranthē ca yā yā kathā likhitāstē tāsu sarvvāsu viśvasya yanmatam imē vidharmmaṁ jānanti tanmatānusārēṇāhaṁ nijapitr̥puruṣāṇām īśvaram ārādhayāmītyahaṁ bhavataḥ samakṣam aṅgīkarōmi| ");
INSERT INTO saniso_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","dhārmmikāṇām adhārmmikāṇāñca pramītalōkānāmēvōtthānaṁ bhaviṣyatīti kathāmimē svīkurvvanti tathāhamapi tasmin īśvarē pratyāśāṁ karōmi; ");
INSERT INTO saniso_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","īśvarasya mānavānāñca samīpē yathā nirdōṣō bhavāmi tadarthaṁ satataṁ yatnavān asmi| ");
INSERT INTO saniso_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","bahuṣu vatsarēṣu gatēṣu svadēśīyalōkānāṁ nimittaṁ dānīyadravyāṇi naivēdyāni ca samādāya punarāgamanaṁ kr̥tavān| ");
INSERT INTO saniso_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","tatōhaṁ śuci rbhūtvā lōkānāṁ samāgamaṁ kalahaṁ vā na kāritavān tathāpyāśiyādēśīyāḥ kiyantō yihudīyalōkā madhyēmandiraṁ māṁ dhr̥tavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","mamōpari yadi kācidapavādakathāsti tarhi bhavataḥ samīpam upasthāya tēṣāmēva sākṣyadānam ucitam| ");
INSERT INTO saniso_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","nōcēt pūrvvē mahāsabhāsthānāṁ lōkānāṁ sannidhau mama daṇḍāyamānatvasamayē, ahamadya mr̥tānāmutthānē yuṣmābhi rvicāritōsmi, ");
INSERT INTO saniso_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","tēṣāṁ madhyē tiṣṭhannahaṁ yāmimāṁ kathāmuccaiḥ svarēṇa kathitavān tadanyō mama kōpi dōṣō'labhyata na vēti varam ētē samupasthitalōkā vadantu| ");
INSERT INTO saniso_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","tadā phīlikṣa ētāṁ kathāṁ śrutvā tanmatasya viśēṣavr̥ttāntaṁ vijñātuṁ vicāraṁ sthagitaṁ kr̥tvā kathitavān luṣiyē sahasrasēnāpatau samāyātē sati yuṣmākaṁ vicāram ahaṁ niṣpādayiṣyāmi| ");
INSERT INTO saniso_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","anantaraṁ bandhanaṁ vinā paulaṁ rakṣituṁ tasya sēvanāya sākṣātkaraṇāya vā tadīyātmīyabandhujanān na vārayituñca śamasēnāpatim ādiṣṭavān| ");
INSERT INTO saniso_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","alpadināt paraṁ phīlikṣō'dhipati rdruṣillānāmnā yihūdīyayā svabhāryyayā sahāgatya paulamāhūya tasya mukhāt khrīṣṭadharmmasya vr̥ttāntam aśrauṣīt| ");
INSERT INTO saniso_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","paulēna nyāyasya parimitabhōgasya caramavicārasya ca kathāyāṁ kathitāyāṁ satyāṁ phīlikṣaḥ kampamānaḥ san vyāharad idānīṁ yāhi, aham avakāśaṁ prāpya tvām āhūsyāmi| ");
INSERT INTO saniso_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","muktipraptyarthaṁ paulēna mahyaṁ mudrādāsyantē iti patyāśāṁ kr̥tvā sa punaḥ punastamāhūya tēna sākaṁ kathōpakathanaṁ kr̥tavān| ");
INSERT INTO saniso_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","kintu vatsaradvayāt paraṁ parkiyaphīṣṭa phālikṣasya padaṁ prāptē sati phīlikṣō yihūdīyān santuṣṭān cikīrṣan paulaṁ baddhaṁ saṁsthāpya gatavān| ");
INSERT INTO saniso_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","anantaraṁ phīṣṭō nijarājyam āgatya dinatrayāt paraṁ kaisariyātō yirūśālamnagaram āgamat| ");
INSERT INTO saniso_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","tadā mahāyājakō yihūdīyānāṁ pradhānalōkāśca tasya samakṣaṁ paulam apāvadanta| ");
INSERT INTO saniso_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","bhavān taṁ yirūśālamam ānētum ājñāpayatviti vinīya tē tasmād anugrahaṁ vāñchitavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","yataḥ pathimadhyē gōpanēna paulaṁ hantuṁ tai rghātakā niyuktāḥ| phīṣṭa uttaraṁ dattavān paulaḥ kaisariyāyāṁ sthāsyati punaralpadināt param ahaṁ tatra yāsyāmi| ");
INSERT INTO saniso_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","tatastasya mānuṣasya yadi kaścid aparādhastiṣṭhati tarhi yuṣmākaṁ yē śaknuvanti tē mayā saha tatra gatvā tamapavadantu sa ētāṁ kathāṁ kathitavān| ");
INSERT INTO saniso_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","daśadivasēbhyō'dhikaṁ vilambya phīṣṭastasmāt kaisariyānagaraṁ gatvā parasmin divasē vicārāsana upadiśya paulam ānētum ājñāpayat| ");
INSERT INTO saniso_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","paulē samupasthitē sati yirūśālamnagarād āgatā yihūdīyalōkāstaṁ caturdiśi saṁvēṣṭya tasya viruddhaṁ bahūn mahādōṣān utthāpitavantaḥ kintu tēṣāṁ kimapi pramāṇaṁ dātuṁ na śaknuvantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","tataḥ paulaḥ svasmin uttaramidam uditavān, yihūdīyānāṁ vyavasthāyā mandirasya kaisarasya vā pratikūlaṁ kimapi karmma nāhaṁ kr̥tavān| ");
INSERT INTO saniso_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","kintu phīṣṭō yihūdīyān santuṣṭān karttum abhilaṣan paulam abhāṣata tvaṁ kiṁ yirūśālamaṁ gatvāsmin abhiyōgē mama sākṣād vicāritō bhaviṣyasi? ");
INSERT INTO saniso_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","tataḥ paula uttaraṁ prōktavān, yatra mama vicārō bhavituṁ yōgyaḥ kaisarasya tatra vicārāsana ēva samupasthitōsmi; ahaṁ yihūdīyānāṁ kāmapi hāniṁ nākārṣam iti bhavān yathārthatō vijānāti| ");
INSERT INTO saniso_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","kañcidaparādhaṁ kiñcana vadhārhaṁ karmma vā yadyaham akariṣyaṁ tarhi prāṇahananadaṇḍamapi bhōktum udyatō'bhaviṣyaṁ, kintu tē mama samapavādaṁ kurvvanti sa yadi kalpitamātrō bhavati tarhi tēṣāṁ karēṣu māṁ samarpayituṁ kasyāpyadhikārō nāsti, kaisarasya nikaṭē mama vicārō bhavatu| ");
INSERT INTO saniso_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","tadā phīṣṭō mantribhiḥ sārddhaṁ saṁmantrya paulāya kathitavān, kaisarasya nikaṭē kiṁ tava vicārō bhaviṣyati? kaisarasya samīpaṁ gamiṣyasi| ");
INSERT INTO saniso_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","kiyaddinēbhyaḥ param āgripparājā barṇīkī ca phīṣṭaṁ sākṣāt karttuṁ kaisariyānagaram āgatavantau| ");
INSERT INTO saniso_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","tadā tau bahudināni tatra sthitau tataḥ phīṣṭastaṁ rājānaṁ paulasya kathāṁ vijñāpya kathayitum ārabhata paulanāmānam ēkaṁ bandi phīlikṣō baddhaṁ saṁsthāpya gatavān| ");
INSERT INTO saniso_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","yirūśālami mama sthitikālē mahāyājakō yihūdīyānāṁ prācīnalōkāśca tam apōdya tamprati daṇḍājñāṁ prārthayanta| ");
INSERT INTO saniso_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","tatōham ityuttaram avadaṁ yāvad apōditō janaḥ svāpavādakān sākṣāt kr̥tvā svasmin yō'parādha ārōpitastasya pratyuttaraṁ dātuṁ suyōgaṁ na prāpnōti, tāvatkālaṁ kasyāpi mānuṣasya prāṇanāśājñāpanaṁ rōmilōkānāṁ rīti rnahi| ");
INSERT INTO saniso_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","tatastēṣvatrāgatēṣu parasmin divasē'ham avilambaṁ vicārāsana upaviśya taṁ mānuṣam ānētum ājñāpayam| ");
INSERT INTO saniso_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","tadanantaraṁ tasyāpavādakā upasthāya yādr̥śam ahaṁ cintitavān tādr̥śaṁ kañcana mahāpavādaṁ nōtthāpya ");
INSERT INTO saniso_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","svēṣāṁ matē tathā paulō yaṁ sajīvaṁ vadati tasmin yīśunāmani mr̥tajanē ca tasya viruddhaṁ kathitavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","tatōhaṁ tādr̥gvicārē saṁśayānaḥ san kathitavān tvaṁ yirūśālamaṁ gatvā kiṁ tatra vicāritō bhavitum icchasi? ");
INSERT INTO saniso_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","tadā paulō mahārājasya nikaṭē vicāritō bhavituṁ prārthayata, tasmād yāvatkālaṁ taṁ kaisarasya samīpaṁ prēṣayituṁ na śaknōmi tāvatkālaṁ tamatra sthāpayitum ādiṣṭavān| ");
INSERT INTO saniso_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","tata āgrippaḥ phīṣṭam uktavān, ahamapi tasya mānuṣasya kathāṁ śrōtum abhilaṣāmi| tadā phīṣṭō vyāharat śvastadīyāṁ kathāṁ tvaṁ śrōṣyasi| ");
INSERT INTO saniso_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","parasmin divasē āgrippō barṇīkī ca mahāsamāgamaṁ kr̥tvā pradhānavāhinīpatibhi rnagarasthapradhānalōkaiśca saha militvā rājagr̥hamāgatya samupasthitau tadā phīṣṭasyājñayā paula ānītō'bhavat| ");
INSERT INTO saniso_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","tadā phīṣṭaḥ kathitavān hē rājan āgrippa hē upasthitāḥ sarvvē lōkā yirūśālamnagarē yihūdīyalōkasamūhō yasmin mānuṣē mama samīpē nivēdanaṁ kr̥tvā prōccaiḥ kathāmimāṁ kathitavān punaralpakālamapi tasya jīvanaṁ nōcitaṁ tamētaṁ mānuṣaṁ paśyata| ");
INSERT INTO saniso_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","kintvēṣa janaḥ prāṇanāśarhaṁ kimapi karmma na kr̥tavān ityajānāṁ tathāpi sa mahārājasya sannidhau vicāritō bhavituṁ prārthayata tasmāt tasya samīpaṁ taṁ prēṣayituṁ matimakaravam| ");
INSERT INTO saniso_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","kintu śrīyuktasya samīpam ētasmin kiṁ lēkhanīyam ityasya kasyacin nirṇayasya na jātatvād ētasya vicārē sati yathāhaṁ lēkhituṁ kiñcana niścitaṁ prāpnōmi tadarthaṁ yuṣmākaṁ samakṣaṁ viśēṣatō hē āgripparāja bhavataḥ samakṣam ētam ānayē| ");
INSERT INTO saniso_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","yatō bandiprēṣaṇasamayē tasyābhiyōgasya kiñcidalēkhanam aham ayuktaṁ jānāmi| ");
INSERT INTO saniso_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","tata āgrippaḥ paulam avādīt, nijāṁ kathāṁ kathayituṁ tubhyam anumati rdīyatē| tasmāt paulaḥ karaṁ prasāryya svasmin uttaram avādīt| ");
INSERT INTO saniso_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","hē āgripparāja yatkāraṇādahaṁ yihūdīyairapavāditō 'bhavaṁ tasya vr̥ttāntam adya bhavataḥ sākṣān nivēdayitumanumatōham idaṁ svīyaṁ paramaṁ bhāgyaṁ manyē; ");
INSERT INTO saniso_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","yatō yihūdīyalōkānāṁ madhyē yā yā rītiḥ sūkṣmavicārāśca santi tēṣu bhavān vijñatamaḥ; ataēva prārthayē dhairyyamavalambya mama nivēdanaṁ śr̥ṇōtu| ");
INSERT INTO saniso_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","ahaṁ yirūśālamnagarē svadēśīyalōkānāṁ madhyē tiṣṭhan ā yauvanakālād yadrūpam ācaritavān tad yihūdīyalōkāḥ sarvvē vidanti| ");
INSERT INTO saniso_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","asmākaṁ sarvvēbhyaḥ śuddhatamaṁ yat phirūśīyamataṁ tadavalambī bhūtvāhaṁ kālaṁ yāpitavān yē janā ā bālyakālān māṁ jānānti tē ētādr̥śaṁ sākṣyaṁ yadi dadāti tarhi dātuṁ śaknuvanti| ");
INSERT INTO saniso_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","kintu hē āgripparāja īśvarō'smākaṁ pūrvvapuruṣāṇāṁ nikaṭē yad aṅgīkr̥tavān tasya pratyāśāhētōraham idānīṁ vicārasthānē daṇḍāyamānōsmi| ");
INSERT INTO saniso_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","tasyāṅgīkārasya phalaṁ prāptum asmākaṁ dvādaśavaṁśā divāniśaṁ mahāyatnād īśvarasēvanaṁ kr̥tvā yāṁ pratyāśāṁ kurvvanti tasyāḥ pratyāśāyā hētōrahaṁ yihūdīyairapavāditō'bhavam| ");
INSERT INTO saniso_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","īśvarō mr̥tān utthāpayiṣyatīti vākyaṁ yuṣmākaṁ nikaṭē'sambhavaṁ kutō bhavēt? ");
INSERT INTO saniso_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","nāsaratīyayīśō rnāmnō viruddhaṁ nānāprakārapratikūlācaraṇam ucitam ityahaṁ manasi yathārthaṁ vijñāya ");
INSERT INTO saniso_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","yirūśālamanagarē tadakaravaṁ phalataḥ pradhānayājakasya nikaṭāt kṣamatāṁ prāpya bahūn pavitralōkān kārāyāṁ baddhavān viśēṣatastēṣāṁ hananasamayē tēṣāṁ viruddhāṁ nijāṁ sammatiṁ prakāśitavān| ");
INSERT INTO saniso_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","vāraṁ vāraṁ bhajanabhavanēṣu tēbhyō daṇḍaṁ pradattavān balāt taṁ dharmmaṁ nindayitavāṁśca punaśca tān prati mahākrōdhād unmattaḥ san vidēśīyanagarāṇi yāvat tān tāḍitavān| ");
INSERT INTO saniso_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","itthaṁ pradhānayājakasya samīpāt śaktim ājñāpatrañca labdhvā dammēṣaknagaraṁ gatavān| ");
INSERT INTO saniso_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","tadāhaṁ hē rājan mārgamadhyē madhyāhnakālē mama madīyasaṅgināṁ lōkānāñca catasr̥ṣu dikṣu gagaṇāt prakāśamānāṁ bhāskaratōpi tējasvatīṁ dīptiṁ dr̥ṣṭavān| ");
INSERT INTO saniso_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","tasmād asmāsu sarvvēṣu bhūmau patitēṣu satsu hē śaula hai śaula kutō māṁ tāḍayasi? kaṇṭakānāṁ mukhē pādāhananaṁ tava duḥsādhyam ibrīyabhāṣayā gadita ētādr̥śa ēkaḥ śabdō mayā śrutaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","tadāhaṁ pr̥ṣṭavān hē prabhō kō bhavān? tataḥ sa kathitavān yaṁ yīśuṁ tvaṁ tāḍayasi sōhaṁ, ");
INSERT INTO saniso_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","kintu samuttiṣṭha tvaṁ yad dr̥ṣṭavān itaḥ punañca yadyat tvāṁ darśayiṣyāmi tēṣāṁ sarvvēṣāṁ kāryyāṇāṁ tvāṁ sākṣiṇaṁ mama sēvakañca karttum darśanam adām| ");
INSERT INTO saniso_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","viśēṣatō yihūdīyalōkēbhyō bhinnajātīyēbhyaśca tvāṁ manōnītaṁ kr̥tvā tēṣāṁ yathā pāpamōcanaṁ bhavati ");
INSERT INTO saniso_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","yathā tē mayi viśvasya pavitrīkr̥tānāṁ madhyē bhāgaṁ prāpnuvanti tadabhiprāyēṇa tēṣāṁ jñānacakṣūṁṣi prasannāni karttuṁ tathāndhakārād dīptiṁ prati śaitānādhikārācca īśvaraṁ prati matīḥ parāvarttayituṁ tēṣāṁ samīpaṁ tvāṁ prēṣyāmi| ");
INSERT INTO saniso_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","hē āgripparāja ētādr̥śaṁ svargīyapratyādēśaṁ agrāhyam akr̥tvāhaṁ ");
INSERT INTO saniso_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","prathamatō dammēṣaknagarē tatō yirūśālami sarvvasmin yihūdīyadēśē anyēṣu dēśēṣu ca yēेna lōkā matiṁ parāvarttya īśvaraṁ prati parāvarttayantē, manaḥparāvarttanayōgyāni karmmāṇi ca kurvvanti tādr̥śam upadēśaṁ pracāritavān| ");
INSERT INTO saniso_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","ētatkāraṇād yihūdīyā madhyēmandiraṁ māṁ dhr̥tvā hantum udyatāḥ| ");
INSERT INTO saniso_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","tathāpi khrīṣṭō duḥkhaṁ bhuktvā sarvvēṣāṁ pūrvvaṁ śmaśānād utthāya nijadēśīyānāṁ bhinnadēśīyānāñca samīpē dīptiṁ prakāśayiṣyati ");
INSERT INTO saniso_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","bhaviṣyadvādigaṇō mūsāśca bhāvikāryyasya yadidaṁ pramāṇam adadurētad vinānyāṁ kathāṁ na kathayitvā īśvarād anugrahaṁ labdhvā mahatāṁ kṣudrāṇāñca sarvvēṣāṁ samīpē pramāṇaṁ dattvādya yāvat tiṣṭhāmi| ");
INSERT INTO saniso_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","tasyamāṁ kathāṁ niśamya phīṣṭa uccaiḥ svarēṇa kathitavān hē paula tvam unmattōsi bahuvidyābhyāsēna tvaṁ hatajñānō jātaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","sa uktavān hē mahāmahima phīṣṭa nāham unmattaḥ kintu satyaṁ vivēcanīyañca vākyaṁ prastaumi| ");
INSERT INTO saniso_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","yasya sākṣād akṣōbhaḥ san kathāṁ kathayāmi sa rājā tadvr̥ttāntaṁ jānāti tasya samīpē kimapi guptaṁ nēti mayā niścitaṁ budhyatē yatastad vijanē na kr̥taṁ| ");
INSERT INTO saniso_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","hē āgripparāja bhavān kiṁ bhaviṣyadvādigaṇōktāni vākyāni pratyēti? bhavān pratyēti tadahaṁ jānāmi| ");
INSERT INTO saniso_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","tata āgrippaḥ paulam abhihitavān tvaṁ pravr̥ttiṁ janayitvā prāyēṇa māmapi khrīṣṭīyaṁ karōṣi| ");
INSERT INTO saniso_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","tataḥ sō'vādīt bhavān yē yē lōkāśca mama kathām adya śr̥ṇvanti prāyēṇa iti nahi kintvētat śr̥ṅkhalabandhanaṁ vinā sarvvathā tē sarvvē mādr̥śā bhavantvitīśvasya samīpē prārthayē'ham| ");
INSERT INTO saniso_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","ētasyāṁ kathāyāṁ kathitāyāṁ sa rājā sō'dhipati rbarṇīkī sabhāsthā lōkāśca tasmād utthāya ");
INSERT INTO saniso_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","gōpanē parasparaṁ vivicya kathitavanta ēṣa janō bandhanārhaṁ prāṇahananārhaṁ vā kimapi karmma nākarōt| ");
INSERT INTO saniso_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","tata āgrippaḥ phīṣṭam avadat, yadyēṣa mānuṣaḥ kaisarasya nikaṭē vicāritō bhavituṁ na prārthayiṣyat tarhi muktō bhavitum aśakṣyat| ");
INSERT INTO saniso_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","jalapathēnāsmākam itōliyādēśaṁ prati yātrāyāṁ niścitāyāṁ satyāṁ tē yūliyanāmnō mahārājasya saṁghātāntargatasya sēnāpatēḥ samīpē paulaṁ tadanyān katinayajanāṁśca samārpayan| ");
INSERT INTO saniso_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","vayam ādrāmuttīyaṁ pōtamēkam āruhya āśiyādēśasya taṭasamīpēna yātuṁ matiṁ kr̥tvā laṅgaram utthāpya pōtam amōcayāma; mākidaniyādēśasthathiṣalanīkīnivāsyāristārkhanāmā kaścid janō'smābhiḥ sārddham āsīt| ");
INSERT INTO saniso_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","parasmin divasē 'smābhiḥ sīdōnnagarē pōtē lāgitē tatra yūliyaḥ sēnāpatiḥ paulaṁ prati saujanyaṁ pradarthya sāntvanārthaṁ bandhubāndhavān upayātum anujajñau| ");
INSERT INTO saniso_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","tasmāt pōtē mōcitē sati sammukhavāyōḥ sambhavād vayaṁ kuprōpadvīpasya tīrasamīpēna gatavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","kilikiyāyāḥ pāmphūliyāyāśca samudrasya pāraṁ gatvā lūkiyādēśāntargataṁ murānagaram upātiṣṭhāma| ");
INSERT INTO saniso_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","tatsthānād itāliyādēśaṁ gacchati yaḥ sikandariyānagarasya pōtastaṁ tatra prāpya śatasēnāpatistaṁ pōtam asmān ārōhayat| ");
INSERT INTO saniso_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","tataḥ paraṁ bahūni dināni śanaiḥ śanaiḥ rgatvā knīdapārśvōpasthtiेḥ pūrvvaṁ pratikūlēna pavanēna vayaṁ salmōnyāḥ sammukham upasthāya krītyupadvīpasya tīrasamīpēna gatavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","kaṣṭēna tamuttīryya lāsēyānagarasyādhaḥ sundaranāmakaṁ khātam upātiṣṭhāma| ");
INSERT INTO saniso_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","itthaṁ bahutithaḥ kālō yāpita upavāsadinañcātītaṁ, tatkāraṇāt nauvartmani bhayaṅkarē sati paulō vinayēna kathitavān, ");
INSERT INTO saniso_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","hē mahēcchā ahaṁ niścayaṁ jānāmi yātrāyāmasyām asmākaṁ klēśā bahūnāmapacayāśca bhaviṣyanti, tē kēvalaṁ pōtasāmagryōriti nahi, kintvasmākaṁ prāṇānāmapi| ");
INSERT INTO saniso_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","tadā śatasēnāpatiḥ pauैेlōktavākyatōpi karṇadhārasya pōtavaṇijaśca vākyaṁ bahumaṁsta| ");
INSERT INTO saniso_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","tat khātaṁ śītakālē vāsārhasthānaṁ na tasmād avācīpratīcōrdiśōḥ krītyāḥ phainīkiyakhātaṁ yātuṁ yadi śaknuvantastarhi tatra śītakālaṁ yāpayituṁ prāyēṇa sarvvē mantrayāmāsuḥ| ");
INSERT INTO saniso_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","tataḥ paraṁ dakṣiṇavāyu rmandaṁ vahatīti vilōkya nijābhiprāyasya siddhēḥ suyōgō bhavatīti buddhvā pōtaṁ mōcayitvā krītyupadvīpasya tīrasamīpēna calitavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","kintvalpakṣaṇāt paramēva urakludōnnāmā pratikūlaḥ pracaṇḍō vāyu rvahan pōtē'lagīt ");
INSERT INTO saniso_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","tasyābhimukhaṁ gantum pōtasyāśaktatvād vayaṁ vāyunā svayaṁ nītāḥ| ");
INSERT INTO saniso_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","anantaraṁ klaudīnāmna upadvīpasya kūlasamīpēna pōtaṁ gamayitvā bahunā kaṣṭēna kṣudranāvam arakṣāma| ");
INSERT INTO saniso_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","tē tāmāruhya rajjcā pōtasyādhōbhāgam abadhnan tadanantaraṁ cēt pōtō saikatē lagatīti bhayād vātavasanānyamōcayan tataḥ pōtō vāyunā cālitaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","kintu kramaśō vāyōḥ prabalatvāt pōtō dōlāyamānō'bhavat parasmin divasē pōtasthāni katipayāni dravyāṇi tōyē nikṣiptāni| ");
INSERT INTO saniso_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","tr̥tīyadivasē vayaṁ svahastaiḥ pōtasajjanadravyāṇi nikṣiptavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","tatō bahudināni yāvat sūryyanakṣatrādīni samācchannāni tatō 'tīva vātyāgamād asmākaṁ prāṇarakṣāyāḥ kāpi pratyāśā nātiṣṭhat| ");
INSERT INTO saniso_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","bahudinēṣu lōkairanāhārēṇa yāpitēṣu sarvvēṣāṁ sākṣat paulastiṣṭhan akathayat, hē mahēcchāḥ krītyupadvīpāt pōtaṁ na mōcayitum ahaṁ pūrvvaṁ yad avadaṁ tadgrahaṇaṁ yuṣmākam ucitam āsīt tathā kr̥tē yuṣmākam ēṣā vipad ēṣō'pacayaśca nāghaṭiṣyētām| ");
INSERT INTO saniso_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","kintu sāmprataṁ yuṣmān vinīya bravīmyahaṁ, yūyaṁ na kṣubhyata yuṣmākam ēkasyāpi prāṇinō hāni rna bhaviṣyati, kēvalasya pōtasya hāni rbhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","yatō yasyēśvarasya lōkō'haṁ yañcāhaṁ paricarāmi tadīya ēkō dūtō hyō rātrau mamāntikē tiṣṭhan kathitavān, ");
INSERT INTO saniso_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","hē paula mā bhaiṣīḥ kaisarasya sammukhē tvayōpasthātavyaṁ; tavaitān saṅginō lōkān īśvarastubhyaṁ dattavān| ");
INSERT INTO saniso_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","ataēva hē mahēcchā yūyaṁ sthiramanasō bhavata mahyaṁ yā kathākathi sāvaśyaṁ ghaṭiṣyatē mamaitādr̥śī viśvāsa īśvarē vidyatē, ");
INSERT INTO saniso_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","kintu kasyacid upadvīpasyōpari patitavyam asmābhiḥ| ");
INSERT INTO saniso_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","tataḥ param ādriyāsamudrē pōtastathaiva dōlāyamānaḥ san itastatō gacchan caturdaśadivasasya rātrē rdvitīyapraharasamayē kasyacit sthalasya samīpamupatiṣṭhatīti pōtīyalōkā anvamanyanta| ");
INSERT INTO saniso_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","tatastē jalaṁ parimāya tatra viṁśati rvyāmā jalānīti jñātavantaḥ| kiñciddūraṁ gatvā punarapi jalaṁ parimitavantaḥ| tatra pañcadaśa vyāmā jalāni dr̥ṣṭvā ");
INSERT INTO saniso_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","cēt pāṣāṇē lagatīti bhayāt pōtasya paścādbhāgataścaturō laṅgarān nikṣipya divākaram apēkṣya sarvvē sthitavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","kintu pōtīyalōkāḥ pōtāgrabhāgē laṅgaranikṣēpaṁ chalaṁ kr̥tvā jaladhau kṣudranāvam avarōhya palāyitum acēṣṭanta| ");
INSERT INTO saniso_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","tataḥ paulaḥ sēnāpatayē sainyagaṇāya ca kathitavān, ētē yadi pōtamadhyē na tiṣṭhanti tarhi yuṣmākaṁ rakṣaṇaṁ na śakyaṁ| ");
INSERT INTO saniso_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","tadā sēnāgaṇō rajjūn chitvā nāvaṁ jalē patitum adadāt| ");
INSERT INTO saniso_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","prabhātasamayē paulaḥ sarvvān janān bhōjanārthaṁ prārthya vyāharat, adya caturdaśadināni yāvad yūyam apēkṣamānā anāhārāḥ kālam ayāpayata kimapi nābhuṁgdhaṁ| ");
INSERT INTO saniso_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","atō vinayēे'haṁ bhakṣyaṁ bhujyatāṁ tatō yuṣmākaṁ maṅgalaṁ bhaviṣyati, yuṣmākaṁ kasyacijjanasya śirasaḥ kēśaikōpi na naṁkṣyati| ");
INSERT INTO saniso_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","iti vyāhr̥tya paulaṁ pūpaṁ gr̥hītvēśvaraṁ dhanyaṁ bhāṣamāṇastaṁ bhaṁktvā bhōktum ārabdhavān| ");
INSERT INTO saniso_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","anantaraṁ sarvvē ca susthirāḥ santaḥ khādyāni parpyagr̥hlan| ");
INSERT INTO saniso_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","asmākaṁ pōtē ṣaṭsaptatyadhikaśatadvayalōkā āsan| ");
INSERT INTO saniso_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","sarvvēṣu lōkēṣu yathēṣṭaṁ bhuktavatsu pōtasthan gōdhūmān jaladhau nikṣipya taiḥ pōtasya bhārō laghūkr̥taḥ| ");
INSERT INTO saniso_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","dinē jātē'pi sa kō dēśa iti tadā na paryyacīyata; kintu tatra samataṭam ēkaṁ khātaṁ dr̥ṣṭvā yadi śaknumastarhi vayaṁ tasyābhyantaraṁ pōtaṁ gamayāma iti matiṁ kr̥tvā tē laṅgarān chittvā jaladhau tyaktavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","tathā karṇabandhanaṁ mōcayitvā pradhānaṁ vātavasanam uttōlya tīrasamīpaṁ gatavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","kintu dvayōḥ samudrayōḥ saṅgamasthānē saikatōpari pōtē nikṣiptē 'grabhāgē bādhitē paścādbhāgē prabalataraṅgō'lagat tēna pōtō bhagnaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","tasmād bandayaścēd bāhubhistarantaḥ palāyantē ityāśaṅkayā sēnāgaṇastān hantum amantrayat; ");
INSERT INTO saniso_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","kintu śatasēnāpatiḥ paulaṁ rakṣituṁ prayatnaṁ kr̥tvā tān taccēṣṭāyā nivartya ityādiṣṭavān, yē bāhutaraṇaṁ jānanti tē'grē prōllampya samudrē patitvā bāhubhistīrttvā kūlaṁ yāntu| ");
INSERT INTO saniso_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","aparam avaśiṣṭā janāḥ kāṣṭhaṁ pōtīyaṁ dravyaṁ vā yēna yat prāpyatē tadavalambya yāntu; itthaṁ sarvvē bhūmiṁ prāpya prāṇai rjīvitāḥ| ");
INSERT INTO saniso_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","itthaṁ sarvvēṣu rakṣāṁ prāptēṣu tatratyōpadvīpasya nāma milītēti tē jñātavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","asabhyalōkā yathēṣṭam anukampāṁ kr̥tvā varttamānavr̥ṣṭēḥ śītācca vahniṁ prajjvālyāsmākam ātithyam akurvvan| ");
INSERT INTO saniso_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","kintu paula indhanāni saṁgr̥hya yadā tasmin agrau nirakṣipat, tadā vahnēḥ pratāpāt ēkaḥ kr̥ṣṇasarpō nirgatya tasya hastē draṣṭavān| ");
INSERT INTO saniso_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","tē'sabhyalōkāstasya hastē sarpam avalambamānaṁ dr̥ṣṭvā parasparam uktavanta ēṣa janō'vaśyaṁ narahā bhaviṣyati, yatō yadyapi jaladhē rakṣāṁ prāptavān tathāpi pratiphaladāyaka ēnaṁ jīvituṁ na dadāti| ");
INSERT INTO saniso_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","kintu sa hastaṁ vidhunvan taṁ sarpam agnimadhyē nikṣipya kāmapi pīḍāṁ nāptavān| ");
INSERT INTO saniso_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","tatō viṣajvālayā ētasya śarīraṁ sphītaṁ bhaviṣyati yadvā haṭhādayaṁ prāṇān tyakṣyatīti niścitya lōkā bahukṣaṇāni yāvat tad draṣṭuṁ sthitavantaḥ kintu tasya kasyāścid vipadō'ghaṭanāt tē tadviparītaṁ vijñāya bhāṣitavanta ēṣa kaścid dēvō bhavēt| ");
INSERT INTO saniso_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","publiyanāmā jana ēkastasyōpadvīpasyādhipatirāsīt tatra tasya bhūmyādi ca sthitaṁ| sa janō'smān nijagr̥haṁ nītvā saujanyaṁ prakāśya dinatrayaṁ yāvad asmākaṁ ātithyam akarōt| ");
INSERT INTO saniso_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","tadā tasya publiyasya pitā jvarātisārēṇa pīḍyamānaḥ san śayyāyām āsīt; tataḥ paulastasya samīpaṁ gatvā prārthanāṁ kr̥tvā tasya gātrē hastaṁ samarpya taṁ svasthaṁ kr̥tavān| ");
INSERT INTO saniso_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","itthaṁ bhūtē tadvīpanivāsina itarēpi rōgilōkā āgatya nirāmayā abhavan| ");
INSERT INTO saniso_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","tasmāttē'smākam atīva satkāraṁ kr̥tavantaḥ, viśēṣataḥ prasthānasamayē prayōjanīyāni nānadravyāṇi dattavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","itthaṁ tatra triṣu māsēṣu gatēṣu yasya cihnaṁ diyaskūrī tādr̥śa ēkaḥ sikandarīyanagarasya pōtaḥ śītakālaṁ yāpayan tasmin upadvīpē 'tiṣṭhat tamēva pōtaṁ vayam āruhya yātrām akurmma| ");
INSERT INTO saniso_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","tataḥ prathamataḥ surākūsanagaram upasthāya tatra trīṇi dināni sthitavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","tasmād āvr̥tya rīgiyanagaram upasthitāḥ dinaikasmāt paraṁ dakṣiṇavayau sānukūlyē sati parasmin divasē patiyalīnagaram upātiṣṭhāma| ");
INSERT INTO saniso_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","tatō'smāsu tatratyaṁ bhrātr̥gaṇaṁ prāptēṣu tē svaiḥ sārddham asmān sapta dināni sthāpayitum ayatanta, itthaṁ vayaṁ rōmānagaram pratyagacchāma| ");
INSERT INTO saniso_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","tasmāt tatratyāḥ bhrātarō'smākam āgamanavārttāṁ śrutvā āppiyapharaṁ triṣṭāvarṇīñca yāvad agrēsarāḥ santōsmān sākṣāt karttum āgaman; tēṣāṁ darśanāt paula īśvaraṁ dhanyaṁ vadan āśvāsam āptavān| ");
INSERT INTO saniso_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","asmāsu rōmānagaraṁ gatēṣu śatasēnāpatiḥ sarvvān bandīn pradhānasēnāpatēḥ samīpē samārpayat kintu paulāya svarakṣakapadātinā saha pr̥thag vastum anumatiṁ dattavān| ");
INSERT INTO saniso_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","dinatrayāt paraṁ paulastaddēśasthān pradhānayihūdina āhūtavān tatastēṣu samupasthitēṣu sa kathitavān, hē bhrātr̥gaṇa nijalōkānāṁ pūrvvapuruṣāṇāṁ vā rītē rviparītaṁ kiñcana karmmāhaṁ nākaravaṁ tathāpi yirūśālamanivāsinō lōkā māṁ bandiṁ kr̥tvā rōmilōkānāṁ hastēṣu samarpitavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","rōmilōkā vicāryya mama prāṇahananārhaṁ kimapi kāraṇaṁ na prāpya māṁ mōcayitum aicchan; ");
INSERT INTO saniso_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","kintu yihūdilōkānām āpattyā mayā kaisararājasya samīpē vicārasya prārthanā karttavyā jātā nōcēt nijadēśīyalōkān prati mama kōpyabhiyōgō nāsti| ");
INSERT INTO saniso_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","ētatkāraṇād ahaṁ yuṣmān draṣṭuṁ saṁlapituñcāhūyam isrāyēlvaśīyānāṁ pratyāśāhētōham ētēna śuṅkhalēna baddhō'bhavam| ");
INSERT INTO saniso_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","tadā tē tam avādiṣuḥ, yihūdīyadēśād vayaṁ tvāmadhi kimapi patraṁ na prāptā yē bhrātaraḥ samāyātāstēṣāṁ kōpi tava kāmapi vārttāṁ nāvadat abhadramapi nākathayacca| ");
INSERT INTO saniso_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","tava mataṁ kimiti vayaṁ tvattaḥ śrōtumicchāmaḥ| yad idaṁ navīnaṁ matamutthitaṁ tat sarvvatra sarvvēṣāṁ nikaṭē ninditaṁ jātama iti vayaṁ jānīmaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","taistadartham ēkasmin dinē nirūpitē tasmin dinē bahava ēkatra militvā paulasya vāsagr̥ham āgacchan tasmāt paula ā prātaḥkālāt sandhyākālaṁ yāvan mūsāvyavasthāgranthād bhaviṣyadvādināṁ granthēbhyaśca yīśōḥ kathām utthāpya īśvarasya rājyē pramāṇaṁ datvā tēṣāṁ pravr̥ttiṁ janayituṁ cēṣṭitavān| ");
INSERT INTO saniso_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","kēcittu tasya kathāṁ pratyāyan kēcittu na pratyāyan; ");
INSERT INTO saniso_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","ētatkāraṇāt tēṣāṁ parasparam anaikyāt sarvvē calitavantaḥ; tathāpi paula ētāṁ kathāmēkāṁ kathitavān pavitra ātmā yiśayiyasya bhaviṣyadvaktu rvadanād asmākaṁ pitr̥puruṣēbhya ētāṁ kathāṁ bhadraṁ kathayāmāsa, yathā, ");
INSERT INTO saniso_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","\"upagatya janānētān tvaṁ bhāṣasva vacastvidaṁ| karṇaiḥ śrōṣyatha yūyaṁ hi kintu yūyaṁ na bhōtsyatha| nētrai rdrakṣyatha yūyañca jñātuṁ yūyaṁ na śakṣyatha| ");
INSERT INTO saniso_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","tē mānuṣā yathā nētraiḥ paripaśyanti naiva hi| karṇaiḥ ryathā na śr̥ṇvanti budhyantē na ca mānasaiḥ| vyāvarttayatsu cittāni kālē kutrāpi tēṣu vai| mattastē manujāḥ svasthā yathā naiva bhavanti ca| tathā tēṣāṁ manuṣyāṇāṁ santi sthūlā hi buddhayaḥ| badhirībhūtakarṇāśca jātāśca mudritā dr̥śaḥ|| ");
INSERT INTO saniso_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","ata īśvarād yat paritrāṇaṁ tasya vārttā bhinnadēśīyānāṁ samīpaṁ prēṣitā taēva tāṁ grahīṣyantīti yūyaṁ jānīta| ");
INSERT INTO saniso_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","ētādr̥śyāṁ kathāyāṁ kathitāyāṁ satyāṁ yihūdinaḥ parasparaṁ bahuvicāraṁ kurvvantō gatavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","itthaṁ paulaḥ sampūrṇaṁ vatsaradvayaṁ yāvad bhāṭakīyē vāsagr̥hē vasan yē lōkāstasya sannidhim āgacchanti tān sarvvānēva parigr̥hlan, ");
INSERT INTO saniso_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","nirvighnam atiśayaniḥkṣōbham īśvarīyarājatvasya kathāṁ pracārayan prabhau yīśau khrīṣṭē kathāḥ samupādiśat| iti||");
INSERT INTO saniso_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","īśvarō nijaputramadhi yaṁ susaṁvādaṁ bhaviṣyadvādibhi rdharmmagranthē pratiśrutavān taṁ susaṁvādaṁ pracārayituṁ pr̥thakkr̥ta āhūtaḥ prēritaśca prabhō ryīśukhrīṣṭasya sēvakō yaḥ paulaḥ ");
INSERT INTO saniso_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","sa rōmānagarasthān īśvarapriyān āhūtāṁśca pavitralōkān prati patraṁ likhati| ");
INSERT INTO saniso_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","asmākaṁ sa prabhu ryīśuḥ khrīṣṭaḥ śārīrikasambandhēna dāyūdō vaṁśōdbhavaḥ ");
INSERT INTO saniso_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","pavitrasyātmanaḥ sambandhēna cēśvarasya prabhāvavān putra iti śmaśānāt tasyōtthānēna pratipannaṁ| ");
INSERT INTO saniso_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","aparaṁ yēṣāṁ madhyē yīśunā khrīṣṭēna yūyamapyāhūtāstē 'nyadēśīyalōkāstasya nāmni viśvasya nidēśagrāhiṇō yathā bhavanti ");
INSERT INTO saniso_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","tadabhiprāyēṇa vayaṁ tasmād anugrahaṁ prēritatvapadañca prāptāḥ| ");
INSERT INTO saniso_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","tātēnāsmākam īśvarēṇa prabhuṇā yīśukhrīṣṭēna ca yuṣmabhyam anugrahaḥ śāntiśca pradīyētāṁ| ");
INSERT INTO saniso_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","prathamataḥ sarvvasmin jagati yuṣmākaṁ viśvāsasya prakāśitatvād ahaṁ yuṣmākaṁ sarvvēṣāṁ nimittaṁ yīśukhrīṣṭasya nāma gr̥hlan īśvarasya dhanyavādaṁ karōmi| ");
INSERT INTO saniso_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","aparam īśvarasya prasādād bahukālāt paraṁ sāmprataṁ yuṣmākaṁ samīpaṁ yātuṁ kathamapi yat suyōgaṁ prāpnōmi, ētadarthaṁ nirantaraṁ nāmānyuccārayan nijāsu sarvvaprārthanāsu sarvvadā nivēdayāmi, ");
INSERT INTO saniso_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ētasmin yamahaṁ tatputrīyasusaṁvādapracāraṇēna manasā paricarāmi sa īśvarō mama sākṣī vidyatē| ");
INSERT INTO saniso_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","yatō yuṣmākaṁ mama ca viśvāsēna vayam ubhayē yathā śāntiyuktā bhavāma iti kāraṇād ");
INSERT INTO saniso_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","yuṣmākaṁ sthairyyakaraṇārthaṁ yuṣmabhyaṁ kiñcitparamārthadānadānāya yuṣmān sākṣāt karttuṁ madīyā vāñchā| ");
INSERT INTO saniso_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","hē bhrātr̥gaṇa bhinnadēśīyalōkānāṁ madhyē yadvat tadvad yuṣmākaṁ madhyēpi yathā phalaṁ bhuñjē tadabhiprāyēṇa muhurmuhu ryuṣmākaṁ samīpaṁ gantum udyatō'haṁ kintu yāvad adya tasmin gamanē mama vighnō jāta iti yūyaṁ yad ajñātāstiṣṭhatha tadaham ucitaṁ na budhyē| ");
INSERT INTO saniso_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","ahaṁ sabhyāsabhyānāṁ vidvadavidvatāñca sarvvēṣām r̥ṇī vidyē| ");
INSERT INTO saniso_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","ataēva rōmānivāsināṁ yuṣmākaṁ samīpē'pi yathāśakti susaṁvādaṁ pracārayitum aham udyatōsmi| ");
INSERT INTO saniso_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","yataḥ khrīṣṭasya susaṁvādō mama lajjāspadaṁ nahi sa īśvarasya śaktisvarūpaḥ san ā yihūdīyēbhyō 'nyajātīyān yāvat sarvvajātīyānāṁ madhyē yaḥ kaścid tatra viśvasiti tasyaiva trāṇaṁ janayati| ");
INSERT INTO saniso_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","yataḥ pratyayasya samaparimāṇam īśvaradattaṁ puṇyaṁ tatsusaṁvādē prakāśatē| tadadhi dharmmapustakēpi likhitamidaṁ \"puṇyavān janō viśvāsēna jīviṣyati\"| ");
INSERT INTO saniso_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","ataēva yē mānavāḥ pāpakarmmaṇā satyatāṁ rundhanti tēṣāṁ sarvvasya durācaraṇasyādharmmasya ca viruddhaṁ svargād īśvarasya kōpaḥ prakāśatē| ");
INSERT INTO saniso_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","yata īśvaramadhi yadyad jñēyaṁ tad īśvaraḥ svayaṁ tān prati prakāśitavān tasmāt tēṣām agōcaraṁ nahi| ");
INSERT INTO saniso_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","phalatastasyānantaśaktīśvaratvādīnyadr̥śyānyapi sr̥ṣṭikālam ārabhya karmmasu prakāśamānāni dr̥śyantē tasmāt tēṣāṁ dōṣaprakṣālanasya panthā nāsti| ");
INSERT INTO saniso_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","aparam īśvaraṁ jñātvāpi tē tam īśvarajñānēna nādriyanta kr̥tajñā vā na jātāḥ; tasmāt tēṣāṁ sarvvē tarkā viphalībhūtāḥ, aparañca tēṣāṁ vivēkaśūnyāni manāṁsi timirē magnāni| ");
INSERT INTO saniso_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","tē svān jñāninō jñātvā jñānahīnā abhavan ");
INSERT INTO saniso_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","anaśvarasyēśvarasya gauravaṁ vihāya naśvaramanuṣyapaśupakṣyurōgāmiprabhr̥tērākr̥tiviśiṣṭapratimāstairāśritāḥ| ");
INSERT INTO saniso_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","itthaṁ ta īśvarasya satyatāṁ vihāya mr̥ṣāmatam āśritavantaḥ saccidānandaṁ sr̥ṣṭikarttāraṁ tyaktvā sr̥ṣṭavastunaḥ pūjāṁ sēvāñca kr̥tavantaḥ; ");
INSERT INTO saniso_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","iti hētōrīśvarastān kukriyāyāṁ samarpya nijanijakucintābhilāṣābhyāṁ svaṁ svaṁ śarīraṁ parasparam apamānitaṁ karttum adadāt| ");
INSERT INTO saniso_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","īśvarēṇa tēṣu kvabhilāṣē samarpitēṣu tēṣāṁ yōṣitaḥ svābhāvikācaraṇam apahāya viparītakr̥tyē prāvarttanta; ");
INSERT INTO saniso_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","tathā puruṣā api svābhāvikayōṣitsaṅgamaṁ vihāya parasparaṁ kāmakr̥śānunā dagdhāḥ santaḥ pumāṁsaḥ puṁbhiḥ sākaṁ kukr̥tyē samāsajya nijanijabhrāntēḥ samucitaṁ phalam alabhanta| ");
INSERT INTO saniso_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","tē svēṣāṁ manaḥsvīśvarāya sthānaṁ dātum anicchukāstatō hētōrīśvarastān prati duṣṭamanaskatvam avihitakriyatvañca dattavān| ");
INSERT INTO saniso_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","ataēva tē sarvvē 'nyāyō vyabhicārō duṣṭatvaṁ lōbhō jighāṁsā īrṣyā vadhō vivādaścāturī kumatirityādibhi rduṣkarmmabhiḥ paripūrṇāḥ santaḥ ");
INSERT INTO saniso_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","karṇējapā apavādina īśvaradvēṣakā hiṁsakā ahaṅkāriṇa ātmaślāghinaḥ kukarmmōtpādakāḥ pitrōrājñālaṅghakā ");
INSERT INTO saniso_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","avicārakā niyamalaṅghinaḥ snēharahitā atidvēṣiṇō nirdayāśca jātāḥ| ");
INSERT INTO saniso_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","yē janā ētādr̥śaṁ karmma kurvvanti taēva mr̥tiyōgyā īśvarasya vicāramīdr̥śaṁ jñātvāpi ta ētādr̥śaṁ karmma svayaṁ kurvvanti kēvalamiti nahi kintu tādr̥śakarmmakāriṣu lōkēṣvapi prīyantē| ");
INSERT INTO saniso_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","hē paradūṣaka manuṣya yaḥ kaścana tvaṁ bhavasi tavōttaradānāya panthā nāsti yatō yasmāt karmmaṇaḥ parastvayā dūṣyatē tasmāt tvamapi dūṣyasē, yatastaṁ dūṣayannapi tvaṁ tadvad ācarasi| ");
INSERT INTO saniso_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","kintvētādr̥gācāribhyō yaṁ daṇḍam īśvarō niścinōti sa yathārtha iti vayaṁ jānīmaḥ| ");
INSERT INTO saniso_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","ataēva hē mānuṣa tvaṁ yādr̥gācāriṇō dūṣayasi svayaṁ yadi tādr̥gācarasi tarhi tvam īśvaradaṇḍāt palāyituṁ śakṣyasīti kiṁ budhyasē? ");
INSERT INTO saniso_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","aparaṁ tava manasaḥ parivarttanaṁ karttum iśvarasyānugrahō bhavati tanna buddhvā tvaṁ kiṁ tadīyānugrahakṣamācirasahiṣṇutvanidhiṁ tucchīkarōṣi? ");
INSERT INTO saniso_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","tathā svāntaḥkaraṇasya kaṭhōratvāt khēdarāhityāccēśvarasya nyāyyavicāraprakāśanasya krōdhasya ca dinaṁ yāvat kiṁ svārthaṁ kōpaṁ sañcinōṣi? ");
INSERT INTO saniso_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","kintu sa ēkaikamanujāya tatkarmmānusārēṇa pratiphalaṁ dāsyati; ");
INSERT INTO saniso_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","vastutastu yē janā dhairyyaṁ dhr̥tvā satkarmma kurvvantō mahimā satkārō'maratvañcaitāni mr̥gayantē tēbhyō'nantāyu rdāsyati| ");
INSERT INTO saniso_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","aparaṁ yē janāḥ satyadharmmam agr̥hītvā viparītadharmmam gr̥hlanti tādr̥śā virōdhijanāḥ kōpaṁ krōdhañca bhōkṣyantē| ");
INSERT INTO saniso_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","ā yihūdinō'nyadēśinaḥ paryyantaṁ yāvantaḥ kukarmmakāriṇaḥ prāṇinaḥ santi tē sarvvē duḥkhaṁ yātanāñca gamiṣyanti; ");
INSERT INTO saniso_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","kintu ā yihūdinō bhinnadēśiparyyantā yāvantaḥ satkarmmakāriṇō lōkāḥ santi tān prati mahimā satkāraḥ śāntiśca bhaviṣyanti| ");
INSERT INTO saniso_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","īśvarasya vicārē pakṣapātō nāsti| ");
INSERT INTO saniso_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","alabdhavyavasthāśāstrai ryaiḥ pāpāni kr̥tāni vyavasthāśāstrālabdhatvānurūpastēṣāṁ vināśō bhaviṣyati; kintu labdhavyavasthāśāstrā yē pāpānyakurvvan vyavasthānusārādēva tēṣāṁ vicārō bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","vyavasthāśrōtāra īśvarasya samīpē niṣpāpā bhaviṣyantīti nahi kintu vyavasthācāriṇa ēva sapuṇyā bhaviṣyanti| ");
INSERT INTO saniso_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","yatō 'labdhavyavasthāśāstrā bhinnadēśīyalōkā yadi svabhāvatō vyavasthānurūpān ācārān kurvvanti tarhyalabdhaśāstrāḥ santō'pi tē svēṣāṁ vyavasthāśāstramiva svayamēva bhavanti| ");
INSERT INTO saniso_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","tēṣāṁ manasi sākṣisvarūpē sati tēṣāṁ vitarkēṣu ca kadā tān dōṣiṇaḥ kadā vā nirdōṣān kr̥tavatsu tē svāntarlikhitasya vyavasthāśāstrasya pramāṇaṁ svayamēva dadati| ");
INSERT INTO saniso_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","yasmin dinē mayā prakāśitasya susaṁvādasyānusārād īśvarō yīśukhrīṣṭēna mānuṣāṇām antaḥkaraṇānāṁ gūḍhābhiprāyān dhr̥tvā vicārayiṣyati tasmin vicāradinē tat prakāśiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","paśya tvaṁ svayaṁ yihūdīti vikhyātō vyavasthōpari viśvāsaṁ karōṣi, ");
INSERT INTO saniso_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","īśvaramuddiśya svaṁ ślāghasē, tathā vyavasthayā śikṣitō bhūtvā tasyābhimataṁ jānāsi, sarvvāsāṁ kathānāṁ sāraṁ viviṁkṣē, ");
INSERT INTO saniso_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","aparaṁ jñānasya satyatāyāścākarasvarūpaṁ śāstraṁ mama samīpē vidyata atō 'ndhalōkānāṁ mārgadarśayitā ");
INSERT INTO saniso_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","timirasthitalōkānāṁ madhyē dīptisvarūpō'jñānalōkēbhyō jñānadātā śiśūnāṁ śikṣayitāhamēvēti manyasē| ");
INSERT INTO saniso_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","parān śikṣayan svayaṁ svaṁ kiṁ na śikṣayasi? vastutaścauryyaniṣēdhavyavasthāṁ pracārayan tvaṁ kiṁ svayamēva cōrayasi? ");
INSERT INTO saniso_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","tathā paradāragamanaṁ pratiṣēdhan svayaṁ kiṁ paradārān gacchasi? tathā tvaṁ svayaṁ pratimādvēṣī san kiṁ mandirasya dravyāṇi harasi? ");
INSERT INTO saniso_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","yastvaṁ vyavasthāṁ ślāghasē sa tvaṁ kiṁ vyavasthām avamatya nēśvaraṁ sammanyasē? ");
INSERT INTO saniso_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","śāstrē yathā likhati \"bhinnadēśināṁ samīpē yuṣmākaṁ dōṣād īśvarasya nāmnō nindā bhavati|\" ");
INSERT INTO saniso_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","yadi vyavasthāṁ pālayasi tarhi tava tvakchēdakriyā saphalā bhavati; yati vyavasthāṁ laṅghasē tarhi tava tvakchēdō'tvakchēdō bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","yatō vyavasthāśāstrādiṣṭadharmmakarmmācārī pumān atvakchēdī sannapi kiṁ tvakchēdināṁ madhyē na gaṇayiṣyatē? ");
INSERT INTO saniso_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","kintu labdhaśāstraśchinnatvak ca tvaṁ yadi vyavasthālaṅghanaṁ karōṣi tarhi vyavasthāpālakāḥ svābhāvikācchinnatvacō lōkāstvāṁ kiṁ na dūṣayiṣyanti? ");
INSERT INTO saniso_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","tasmād yō bāhyē yihūdī sa yihūdī nahi tathāṅgasya yastvakchēdaḥ sa tvakchēdō nahi; ");
INSERT INTO saniso_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","kintu yō jana āntarikō yihūdī sa ēva yihūdī aparañca kēvalalikhitayā vyavasthayā na kintu mānasikō yastvakchēdō yasya ca praśaṁsā manuṣyēbhyō na bhūtvā īśvarād bhavati sa ēva tvakchēdaḥ| ");
INSERT INTO saniso_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","aparañca yihūdinaḥ kiṁ śrēṣṭhatvaṁ? tathā tvakchēdasya vā kiṁ phalaṁ? ");
INSERT INTO saniso_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","sarvvathā bahūni phalāni santi, viśēṣata īśvarasya śāstraṁ tēbhyō'dīyata| ");
INSERT INTO saniso_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","kaiścid aviśvasanē kr̥tē tēṣām aviśvasanāt kim īśvarasya viśvāsyatāyā hānirutpatsyatē? ");
INSERT INTO saniso_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","kēnāpi prakārēṇa nahi| yadyapi sarvvē manuṣyā mithyāvādinastathāpīśvaraḥ satyavādī| śāstrē yathā likhitamāstē, atastvantu svavākyēna nirddōṣō hi bhaviṣyasi| vicārē caiva niṣpāpō bhaviṣyasi na saṁśayaḥ| ");
INSERT INTO saniso_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","asmākam anyāyēna yadīśvarasya nyāyaḥ prakāśatē tarhi kiṁ vadiṣyāmaḥ? ahaṁ mānuṣāṇāṁ kathāmiva kathāṁ kathayāmi, īśvaraḥ samucitaṁ daṇḍaṁ dattvā kim anyāyī bhaviṣyati? ");
INSERT INTO saniso_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","itthaṁ na bhavatu, tathā satīśvaraḥ kathaṁ jagatō vicārayitā bhaviṣyati? ");
INSERT INTO saniso_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","mama mithyāvākyavadanād yadīśvarasya satyatvēna tasya mahimā varddhatē tarhi kasmādahaṁ vicārē'parādhitvēna gaṇyō bhavāmi? ");
INSERT INTO saniso_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","maṅgalārthaṁ pāpamapi karaṇīyamiti vākyaṁ tvayā kutō nōcyatē? kintu yairucyatē tē nitāntaṁ daṇḍasya pātrāṇi bhavanti; tathāpi tadvākyam asmābhirapyucyata ityasmākaṁ glāniṁ kurvvantaḥ kiyantō lōkā vadanti| ");
INSERT INTO saniso_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","anyalōkēbhyō vayaṁ kiṁ śrēṣṭhāḥ? kadācana nahi yatō yihūdinō 'nyadēśinaśca sarvvaēva pāpasyāyattā ityasya pramāṇaṁ vayaṁ pūrvvam adadāma| ");
INSERT INTO saniso_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","lipi ryathāstē, naikōpi dhārmmikō janaḥ| ");
INSERT INTO saniso_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","tathā jñānīśvarajñānī mānavaḥ kōpi nāsti hi| ");
INSERT INTO saniso_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","vimārgagāminaḥ sarvvē sarvvē duṣkarmmakāriṇaḥ| ēkō janōpi nō tēṣāṁ sādhukarmma karōti ca| ");
INSERT INTO saniso_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","tathā tēṣāntu vai kaṇṭhā anāvr̥taśmaśānavat| stutivādaṁ prakurvvanti jihvābhistē tu kēvalaṁ| tēṣāmōṣṭhasya nimnē tu viṣaṁ tiṣṭhati sarppavat| ");
INSERT INTO saniso_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","mukhaṁ tēṣāṁ hi śāpēna kapaṭēna ca pūryyatē| ");
INSERT INTO saniso_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","raktapātāya tēṣāṁ tu padāni kṣipragāni ca| ");
INSERT INTO saniso_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","pathi tēṣāṁ manuṣyāṇāṁ nāśaḥ klēśaśca kēvalaḥ| ");
INSERT INTO saniso_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","tē janā nahi jānanti panthānaṁ sukhadāyinaṁ| ");
INSERT INTO saniso_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","paramēśād bhayaṁ yattat taccakṣuṣōragōcaraṁ| ");
INSERT INTO saniso_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","vyavasthāyāṁ yadyallikhati tad vyavasthādhīnān lōkān uddiśya likhatīti vayaṁ jānīmaḥ| tatō manuṣyamātrō niruttaraḥ san īśvarasya sākṣād aparādhī bhavati| ");
INSERT INTO saniso_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","ataēva vyavasthānurūpaiḥ karmmabhiḥ kaścidapi prāṇīśvarasya sākṣāt sapuṇyīkr̥tō bhavituṁ na śakṣyati yatō vyavasthayā pāpajñānamātraṁ jāyatē| ");
INSERT INTO saniso_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","kintu vyavasthāyāḥ pr̥thag īśvarēṇa dēyaṁ yat puṇyaṁ tad vyavasthāyā bhaviṣyadvādigaṇasya ca vacanaiḥ pramāṇīkr̥taṁ sad idānīṁ prakāśatē| ");
INSERT INTO saniso_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","yīśukhrīṣṭē viśvāsakaraṇād īśvarēṇa dattaṁ tat puṇyaṁ sakalēṣu prakāśitaṁ sat sarvvān viśvāsinaḥ prati varttatē| ");
INSERT INTO saniso_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","tēṣāṁ kōpi prabhēdō nāsti, yataḥ sarvvaēva pāpina īśvarīyatējōhīnāśca jātāḥ| ");
INSERT INTO saniso_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","ta īśvarasyānugrahād mūlyaṁ vinā khrīṣṭakr̥tēna paritrāṇēna sapuṇyīkr̥tā bhavanti| ");
INSERT INTO saniso_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","yasmāt svaśōṇitēna viśvāsāt pāpanāśakō balī bhavituṁ sa ēva pūrvvam īśvarēṇa niścitaḥ, ittham īśvarīyasahiṣṇutvāt purākr̥tapāpānāṁ mārjjanakaraṇē svīyayāthārthyaṁ tēna prakāśyatē, ");
INSERT INTO saniso_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","varttamānakālīyamapi svayāthārthyaṁ tēna prakāśyatē, aparaṁ yīśau viśvāsinaṁ sapuṇyīkurvvannapi sa yāthārthikastiṣṭhati| ");
INSERT INTO saniso_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","tarhi kutrātmaślāghā? sā dūrīkr̥tā; kayā vyavasthayā? kiṁ kriyārūpavyavasthayā? itthaṁ nahi kintu tat kēvalaviśvāsarūpayā vyavasthayaiva bhavati| ");
INSERT INTO saniso_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","ataēva vyavasthānurūpāḥ kriyā vinā kēvalēna viśvāsēna mānavaḥ sapuṇyīkr̥tō bhavituṁ śaknōtītyasya rāddhāntaṁ darśayāmaḥ| ");
INSERT INTO saniso_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","sa kiṁ kēvalayihūdinām īśvarō bhavati? bhinnadēśinām īśvarō na bhavati? bhinnadēśināmapi bhavati; ");
INSERT INTO saniso_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","yasmād ēka īśvarō viśvāsāt tvakchēdinō viśvāsēnātvakchēdinaśca sapuṇyīkariṣyati| ");
INSERT INTO saniso_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","tarhi viśvāsēna vayaṁ kiṁ vyavasthāṁ lumpāma? itthaṁ na bhavatu vayaṁ vyavasthāṁ saṁsthāpayāma ēva| ");
INSERT INTO saniso_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","asmākaṁ pūrvvapuruṣa ibrāhīm kāyikakriyayā kiṁ labdhavān ētadadhi kiṁ vadiṣyāmaḥ? ");
INSERT INTO saniso_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","sa yadi nijakriyābhyaḥ sapuṇyō bhavēt tarhi tasyātmaślāghāṁ karttuṁ panthā bhavēditi satyaṁ, kintvīśvarasya samīpē nahi| ");
INSERT INTO saniso_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","śāstrē kiṁ likhati? ibrāhīm īśvarē viśvasanāt sa viśvāsastasmai puṇyārthaṁ gaṇitō babhūva| ");
INSERT INTO saniso_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","karmmakāriṇō yad vētanaṁ tad anugrahasya phalaṁ nahi kintu tēnōpārjitaṁ mantavyam| ");
INSERT INTO saniso_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","kintu yaḥ pāpinaṁ sapuṇyīkarōti tasmin viśvāsinaḥ karmmahīnasya janasya yō viśvāsaḥ sa puṇyārthaṁ gaṇyō bhavati| ");
INSERT INTO saniso_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","aparaṁ yaṁ kriyāhīnam īśvaraḥ sapuṇyīkarōti tasya dhanyavādaṁ dāyūd varṇayāmāsa, yathā, ");
INSERT INTO saniso_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","sa dhanyō'ghāni mr̥ṣṭāni yasyāgāṁsyāvr̥tāni ca| ");
INSERT INTO saniso_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","sa ca dhanyaḥ parēśēna pāpaṁ yasya na gaṇyatē| ");
INSERT INTO saniso_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","ēṣa dhanyavādastvakchēdinam atvakchēdinaṁ vā kaṁ prati bhavati? ibrāhīmō viśvāsaḥ puṇyārthaṁ gaṇita iti vayaṁ vadāmaḥ| ");
INSERT INTO saniso_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","sa viśvāsastasya tvakchēditvāvasthāyāṁ kim atvakchēditvāvasthāyāṁ kasmin samayē puṇyamiva gaṇitaḥ? tvakchēditvāvasthāyāṁ nahi kintvatvakchēditvāvasthāyāṁ| ");
INSERT INTO saniso_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","aparañca sa yat sarvvēṣām atvakchēdināṁ viśvāsinām ādipuruṣō bhavēt, tē ca puṇyavattvēna gaṇyēran; ");
INSERT INTO saniso_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","yē ca lōkāḥ kēvalaṁ chinnatvacō na santō 'smatpūrvvapuruṣa ibrāhīm achinnatvak san yēna viśvāsamārgēṇa gatavān tēnaiva tasya pādacihnēna gacchanti tēṣāṁ tvakchēdināmapyādipuruṣō bhavēt tadartham atvakchēdinō mānavasya viśvāsāt puṇyam utpadyata iti pramāṇasvarūpaṁ tvakchēdacihnaṁ sa prāpnōt| ");
INSERT INTO saniso_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","ibrāhīm jagatō'dhikārī bhaviṣyati yaiṣā pratijñā taṁ tasya vaṁśañca prati pūrvvam akriyata sā vyavasthāmūlikā nahi kintu viśvāsajanyapuṇyamūlikā| ");
INSERT INTO saniso_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","yatō vyavasthāvalambinō yadyadhikāriṇō bhavanti tarhi viśvāsō viphalō jāyatē sā pratijñāpi luptaiva| ");
INSERT INTO saniso_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","adhikantu vyavasthā kōpaṁ janayati yatō 'vidyamānāyāṁ vyavasthāyām ājñālaṅghanaṁ na sambhavati| ");
INSERT INTO saniso_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","ataēva sā pratijñā yad anugrahasya phalaṁ bhavēt tadarthaṁ viśvāsamūlikā yatastathātvē tadvaṁśasamudāyaṁ prati arthatō yē vyavasthayā tadvaṁśasambhavāḥ kēvalaṁ tān prati nahi kintu ya ibrāhīmīyaviśvāsēna tatsambhavāstānapi prati sā pratijñā sthāsnurbhavati| ");
INSERT INTO saniso_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","yō nirjīvān sajīvān avidyamānāni vastūni ca vidyamānāni karōti ibrāhīmō viśvāsabhūmēstasyēśvarasya sākṣāt sō'smākaṁ sarvvēṣām ādipuruṣa āstē, yathā likhitaṁ vidyatē, ahaṁ tvāṁ bahujātīnām ādipuruṣaṁ kr̥tvā niyuktavān| ");
INSERT INTO saniso_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","tvadīyastādr̥śō vaṁśō janiṣyatē yadidaṁ vākyaṁ pratiśrutaṁ tadanusārād ibrāhīm bahudēśīyalōkānām ādipuruṣō yad bhavati tadarthaṁ sō'napēkṣitavyamapyapēkṣamāṇō viśvāsaṁ kr̥tavān| ");
INSERT INTO saniso_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","aparañca kṣīṇaviśvāsō na bhūtvā śatavatsaravayaskatvāt svaśarīrasya jarāṁ sārānāmnaḥ svabhāryyāyā rajōnivr̥ttiñca tr̥ṇāya na mēnē| ");
INSERT INTO saniso_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","aparam aviśvāsād īśvarasya pratijñāvacanē kamapi saṁśayaṁ na cakāra; ");
INSERT INTO saniso_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","kintvīśvarēṇa yat pratiśrutaṁ tat sādhayituṁ śakyata iti niścitaṁ vijñāya dr̥ḍhaviśvāsaḥ san īśvarasya mahimānaṁ prakāśayāñcakāra| ");
INSERT INTO saniso_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","iti hētōstasya sa viśvāsastadīyapuṇyamiva gaṇayāñcakrē| ");
INSERT INTO saniso_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","puṇyamivāgaṇyata tat kēvalasya tasya nimittaṁ likhitaṁ nahi, asmākaṁ nimittamapi, ");
INSERT INTO saniso_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","yatō'smākaṁ pāpanāśārthaṁ samarpitō'smākaṁ puṇyaprāptyarthañcōtthāpitō'bhavat yō'smākaṁ prabhu ryīśustasyōtthāpayitarīśvarē ");
INSERT INTO saniso_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","yadi vayaṁ viśvasāmastarhyasmākamapi saēva viśvāsaḥ puṇyamiva gaṇayiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","viśvāsēna sapuṇyīkr̥tā vayam īśvarēṇa sārddhaṁ prabhuṇāsmākaṁ yīśukhrīṣṭēna mēlanaṁ prāptāḥ| ");
INSERT INTO saniso_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","aparaṁ vayaṁ yasmin anugrahāśrayē tiṣṭhāmastanmadhyaṁ viśvāsamārgēṇa tēnaivānītā vayam īśvarīyavibhavaprāptipratyāśayā samānandāmaḥ| ");
INSERT INTO saniso_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","tat kēvalaṁ nahi kintu klēśabhōgē'pyānandāmō yataḥ klēśāाd dhairyyaṁ jāyata iti vayaṁ jānīmaḥ, ");
INSERT INTO saniso_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","dhairyyācca parīkṣitatvaṁ jāyatē, parīkṣitatvāt pratyāśā jāyatē, ");
INSERT INTO saniso_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","pratyāśātō vrīḍitatvaṁ na jāyatē, yasmād asmabhyaṁ dattēna pavitrēṇātmanāsmākam antaḥkaraṇānīśvarasya prēmavāriṇā siktāni| ");
INSERT INTO saniso_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","asmāsu nirupāyēṣu satsu khrīṣṭa upayuktē samayē pāpināṁ nimittaṁ svīyān praṇān atyajat| ");
INSERT INTO saniso_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","hitakāriṇō janasya kr̥tē kōpi praṇān tyaktuṁ sāhasaṁ karttuṁ śaknōti, kintu dhārmmikasya kr̥tē prāyēṇa kōpi prāṇān na tyajati| ");
INSERT INTO saniso_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","kintvasmāsu pāpiṣu satsvapi nimittamasmākaṁ khrīṣṭaḥ svaprāṇān tyaktavān, tata īśvarōsmān prati nijaṁ paramaprēmāṇaṁ darśitavān| ");
INSERT INTO saniso_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","ataēva tasya raktapātēna sapuṇyīkr̥tā vayaṁ nitāntaṁ tēna kōpād uddhāriṣyāmahē| ");
INSERT INTO saniso_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","phalatō vayaṁ yadā ripava āsma tadēśvarasya putrasya maraṇēna tēna sārddhaṁ yadyasmākaṁ mēlanaṁ jātaṁ tarhi mēlanaprāptāḥ santō'vaśyaṁ tasya jīvanēna rakṣāṁ lapsyāmahē| ");
INSERT INTO saniso_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","tat kēvalaṁ nahi kintu yēna mēlanam alabhāmahi tēnāsmākaṁ prabhuṇā yīśukhrīṣṭēna sāmpratam īśvarē samānandāmaśca| ");
INSERT INTO saniso_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","tathā sati, ēkēna mānuṣēṇa pāpaṁ pāpēna ca maraṇaṁ jagatīṁ prāviśat aparaṁ sarvvēṣāṁ pāpitvāt sarvvē mānuṣā mr̥tē rnighnā abhavat| ");
INSERT INTO saniso_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","yatō vyavasthādānasamayaṁ yāvat jagati pāpam āsīt kintu yatra vyavasthā na vidyatē tatra pāpasyāpi gaṇanā na vidyatē| ");
INSERT INTO saniso_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","tathāpyādamā yādr̥śaṁ pāpaṁ kr̥taṁ tādr̥śaṁ pāpaṁ yai rnākāri ādamam ārabhya mūsāṁ yāvat tēṣāmapyupari mr̥tyū rājatvam akarōt sa ādam bhāvyādamō nidarśanamēvāstē| ");
INSERT INTO saniso_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","kintu pāpakarmmaṇō yādr̥śō bhāvastādr̥g dānakarmmaṇō bhāvō na bhavati yata ēkasya janasyāparādhēna yadi bahūnāṁ maraṇam aghaṭata tathāpīśvarānugrahastadanugrahamūlakaṁ dānañcaikēna janēnārthād yīśunā khrīṣṭēna bahuṣu bāhulyātibāhulyēna phalati| ");
INSERT INTO saniso_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","aparam ēkasya janasya pāpakarmma yādr̥k phalayuktaṁ dānakarmma tādr̥k na bhavati yatō vicārakarmmaikaṁ pāpam ārabhya daṇḍajanakaṁ babhūva, kintu dānakarmma bahupāpānyārabhya puṇyajanakaṁ babhūva| ");
INSERT INTO saniso_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","yata ēkasya janasya pāpakarmmatastēnaikēna yadi maraṇasya rājatvaṁ jātaṁ tarhi yē janā anugrahasya bāhulyaṁ puṇyadānañca prāpnuvanti ta ēkēna janēna, arthāt yīśukhrīṣṭēna, jīvanē rājatvam avaśyaṁ kariṣyanti| ");
INSERT INTO saniso_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","ēkō'parādhō yadvat sarvvamānavānāṁ daṇḍagāmī mārgō 'bhavat tadvad ēkaṁ puṇyadānaṁ sarvvamānavānāṁ jīvanayuktapuṇyagāmī mārga ēva| ");
INSERT INTO saniso_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","aparam ēkasya janasyājñālaṅghanād yathā bahavō 'parādhinō jātāstadvad ēkasyājñācaraṇād bahavaḥ sapuṇyīkr̥tā bhavanti| ");
INSERT INTO saniso_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","adhikantu vyavasthāgamanād aparādhasya bāhulyaṁ jātaṁ kintu yatra pāpasya bāhulyaṁ tatraiva tasmād anugrahasya bāhulyam abhavat| ");
INSERT INTO saniso_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","tēna mr̥tyunā yadvat pāpasya rājatvam abhavat tadvad asmākaṁ prabhuyīśukhrīṣṭadvārānantajīvanadāyipuṇyēnānugrahasya rājatvaṁ bhavati| ");
INSERT INTO saniso_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","prabhūtarūpēṇa yad anugrahaḥ prakāśatē tadarthaṁ pāpē tiṣṭhāma iti vākyaṁ kiṁ vayaṁ vadiṣyāmaḥ? tanna bhavatu| ");
INSERT INTO saniso_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","pāpaṁ prati mr̥tā vayaṁ punastasmin katham jīviṣyāmaḥ? ");
INSERT INTO saniso_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","vayaṁ yāvantō lōkā yīśukhrīṣṭē majjitā abhavāma tāvanta ēva tasya maraṇē majjitā iti kiṁ yūyaṁ na jānītha? ");
INSERT INTO saniso_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","tatō yathā pituḥ parākramēṇa śmaśānāt khrīṣṭa utthāpitastathā vayamapi yat nūtanajīvina ivācarāmastadarthaṁ majjanēna tēna sārddhaṁ mr̥tyurūpē śmaśānē saṁsthāpitāḥ| ");
INSERT INTO saniso_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","aparaṁ vayaṁ yadi tēna saṁyuktāḥ santaḥ sa iva maraṇabhāginō jātāstarhi sa ivōtthānabhāginō'pi bhaviṣyāmaḥ| ");
INSERT INTO saniso_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","vayaṁ yat pāpasya dāsāḥ puna rna bhavāmastadartham asmākaṁ pāparūpaśarīrasya vināśārtham asmākaṁ purātanapuruṣastēna sākaṁ kruśē'hanyatēti vayaṁ jānīmaḥ| ");
INSERT INTO saniso_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","yō hataḥ sa pāpāt mukta ēva| ");
INSERT INTO saniso_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","ataēva yadi vayaṁ khrīṣṭēna sārddham ahanyāmahi tarhi punarapi tēna sahitā jīviṣyāma ityatrāsmākaṁ viśvāsō vidyatē| ");
INSERT INTO saniso_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","yataḥ śmaśānād utthāpitaḥ khrīṣṭō puna rna mriyata iti vayaṁ jānīmaḥ| tasmin kōpyadhikārō mr̥tyō rnāsti| ");
INSERT INTO saniso_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","aparañca sa yad amriyata tēnaikadā pāpam uddiśyāmriyata, yacca jīvati tēnēśvaram uddiśya jīvati; ");
INSERT INTO saniso_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","tadvad yūyamapi svān pāpam uddiśya mr̥tān asmākaṁ prabhuṇā yīśukhrīṣṭēnēśvaram uddiśya jīvantō jānīta| ");
INSERT INTO saniso_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","aparañca kutsitābhilāṣāाn pūrayituṁ yuṣmākaṁ martyadēhēṣu pāpam ādhipatyaṁ na karōtu| ");
INSERT INTO saniso_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","aparaṁ svaṁ svam aṅgam adharmmasyāstraṁ kr̥tvā pāpasēvāyāṁ na samarpayata, kintu śmaśānād utthitāniva svān īśvarē samarpayata svānyaṅgāni ca dharmmāstrasvarūpāṇīśvaram uddiśya samarpayata| ");
INSERT INTO saniso_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","yuṣmākam upari pāpasyādhipatyaṁ puna rna bhaviṣyati, yasmād yūyaṁ vyavasthāyā anāyattā anugrahasya cāyattā abhavata| ");
INSERT INTO saniso_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","kintu vayaṁ vyavasthāyā anāyattā anugrahasya cāyattā abhavāma, iti kāraṇāt kiṁ pāpaṁ kariṣyāmaḥ? tanna bhavatu| ");
INSERT INTO saniso_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","yatō mr̥tijanakaṁ pāpaṁ puṇyajanakaṁ nidēśācaraṇañcaitayōrdvayō ryasmin ājñāpālanārthaṁ bhr̥tyāniva svān samarpayatha, tasyaiva bhr̥tyā bhavatha, ētat kiṁ yūyaṁ na jānītha? ");
INSERT INTO saniso_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","aparañca pūrvvaṁ yūyaṁ pāpasya bhr̥tyā āstēti satyaṁ kintu yasyāṁ śikṣārūpāyāṁ mūṣāyāṁ nikṣiptā abhavata tasyā ākr̥tiṁ manōbhi rlabdhavanta iti kāraṇād īśvarasya dhanyavādō bhavatu| ");
INSERT INTO saniso_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","itthaṁ yūyaṁ pāpasēvātō muktāḥ santō dharmmasya bhr̥tyā jātāḥ| ");
INSERT INTO saniso_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","yuṣmākaṁ śārīrikyā durbbalatāyā hētō rmānavavad aham ētad bravīmi; punaḥ punaradharmmakaraṇārthaṁ yadvat pūrvvaṁ pāpāmēdhyayō rbhr̥tyatvē nijāṅgāni samārpayata tadvad idānīṁ sādhukarmmakaraṇārthaṁ dharmmasya bhr̥tyatvē nijāṅgāni samarpayata| ");
INSERT INTO saniso_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","yadā yūyaṁ pāpasya bhr̥tyā āsta tadā dharmmasya nāyattā āsta| ");
INSERT INTO saniso_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","tarhi yāni karmmāṇi yūyam idānīṁ lajjājanakāni budhyadhvē pūrvvaṁ tai ryuṣmākaṁ kō lābha āsīt? tēṣāṁ karmmaṇāṁ phalaṁ maraṇamēva| ");
INSERT INTO saniso_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","kintu sāmprataṁ yūyaṁ pāpasēvātō muktāḥ santa īśvarasya bhr̥tyā'bhavata tasmād yuṣmākaṁ pavitratvarūpaṁ labhyam anantajīvanarūpañca phalam āstē| ");
INSERT INTO saniso_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","yataḥ pāpasya vētanaṁ maraṇaṁ kintvasmākaṁ prabhuṇā yīśukhrīṣṭēnānantajīvanam īśvaradattaṁ pāritōṣikam āstē| ");
INSERT INTO saniso_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","hē bhrātr̥gaṇa vyavasthāvidaḥ prati mamēdaṁ nivēdanaṁ| vidhiḥ kēvalaṁ yāvajjīvaṁ mānavōparyyadhipatitvaṁ karōtīti yūyaṁ kiṁ na jānītha? ");
INSERT INTO saniso_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","yāvatkālaṁ pati rjīvati tāvatkālam ūḍhā bhāryyā vyavasthayā tasmin baddhā tiṣṭhati kintu yadi pati rmriyatē tarhi sā nārī patyu rvyavasthātō mucyatē| ");
INSERT INTO saniso_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","ētatkāraṇāt patyurjīvanakālē nārī yadyanyaṁ puruṣaṁ vivahati tarhi sā vyabhicāriṇī bhavati kintu yadi sa pati rmriyatē tarhi sā tasyā vyavasthāyā muktā satī puruṣāntarēṇa vyūḍhāpi vyabhicāriṇī na bhavati| ");
INSERT INTO saniso_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","hē mama bhrātr̥gaṇa, īśvaranimittaṁ yadasmākaṁ phalaṁ jāyatē tadarthaṁ śmaśānād utthāpitēna puruṣēṇa saha yuṣmākaṁ vivāhō yad bhavēt tadarthaṁ khrīṣṭasya śarīrēṇa yūyaṁ vyavasthāṁ prati mr̥tavantaḥ| ");
INSERT INTO saniso_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","yatō'smākaṁ śārīrikācaraṇasamayē maraṇanimittaṁ phalam utpādayituṁ vyavasthayā dūṣitaḥ pāpābhilāṣō'smākam aṅgēṣu jīvan āsīt| ");
INSERT INTO saniso_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","kintu tadā yasyā vyavasthāyā vaśē āsmahi sāmprataṁ tāṁ prati mr̥tatvād vayaṁ tasyā adhīnatvāt muktā iti hētōrīśvarō'smābhiḥ purātanalikhitānusārāt na sēvitavyaḥ kintu navīnasvabhāvēnaiva sēvitavyaḥ ");
INSERT INTO saniso_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","tarhi vayaṁ kiṁ brūmaḥ? vyavasthā kiṁ pāpajanikā bhavati? nētthaṁ bhavatu| vyavasthām avidyamānāyāṁ pāpaṁ kim ityahaṁ nāvēdaṁ; kiñca lōbhaṁ mā kārṣīriti cēd vyavasthāgranthē likhitaṁ nābhaviṣyat tarhi lōbhaḥ kimbhūtastadahaṁ nājñāsyaṁ| ");
INSERT INTO saniso_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","kintu vyavasthayā pāpaṁ chidraṁ prāpyāsmākam antaḥ sarvvavidhaṁ kutsitābhilāṣam ajanayat; yatō vyavasthāyām avidyamānāyāṁ pāpaṁ mr̥taṁ| ");
INSERT INTO saniso_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","aparaṁ pūrvvaṁ vyavasthāyām avidyamānāyām aham ajīvaṁ tataḥ param ājñāyām upasthitāyām pāpam ajīvat tadāham amriyē| ");
INSERT INTO saniso_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","itthaṁ sati jīvananimittā yājñā sā mama mr̥tyujanikābhavat| ");
INSERT INTO saniso_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","yataḥ pāpaṁ chidraṁ prāpya vyavasthitādēśēna māṁ vañcayitvā tēna mām ahan| ");
INSERT INTO saniso_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","ataēva vyavasthā pavitrā, ādēśaśca pavitrō nyāyyō hitakārī ca bhavati| ");
INSERT INTO saniso_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","tarhi yat svayaṁ hitakr̥t tat kiṁ mama mr̥tyujanakam abhavat? nētthaṁ bhavatu; kintu pāpaṁ yat pātakamiva prakāśatē tathā nidēśēna pāpaṁ yadatīva pātakamiva prakāśatē tadarthaṁ hitōpāyēna mama maraṇam ajanayat| ");
INSERT INTO saniso_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","vyavasthātmabōdhikēti vayaṁ jānīmaḥ kintvahaṁ śārīratācārī pāpasya krītakiṅkarō vidyē| ");
INSERT INTO saniso_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","yatō yat karmma karōmi tat mama manō'bhimataṁ nahi; aparaṁ yan mama manō'bhimataṁ tanna karōmi kintu yad r̥tīyē tat karōmi| ");
INSERT INTO saniso_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","tathātvē yan mamānabhimataṁ tad yadi karōmi tarhi vyavasthā sūttamēti svīkarōmi| ");
INSERT INTO saniso_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","ataēva samprati tat karmma mayā kriyata iti nahi kintu mama śarīrasthēna pāpēnaiva kriyatē| ");
INSERT INTO saniso_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","yatō mayi, arthatō mama śarīrē, kimapyuttamaṁ na vasati, ētad ahaṁ jānāmi; mamēcchukatāyāṁ tiṣṭhantyāmapyaham uttamakarmmasādhanē samarthō na bhavāmi| ");
INSERT INTO saniso_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","yatō yāmuttamāṁ kriyāṁ karttumahaṁ vāñchāmi tāṁ na karōmi kintu yat kutsitaṁ karmma karttum anicchukō'smi tadēva karōmi| ");
INSERT INTO saniso_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","ataēva yadyat karmma karttuṁ mamēcchā na bhavati tad yadi karōmi tarhi tat mayā na kriyatē, mamāntarvarttinā pāpēnaiva kriyatē| ");
INSERT INTO saniso_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","bhadraṁ karttum icchukaṁ māṁ yō 'bhadraṁ karttuṁ pravarttayati tādr̥śaṁ svabhāvamēkaṁ mayi paśyāmi| ");
INSERT INTO saniso_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","aham āntarikapuruṣēṇēśvaravyavasthāyāṁ santuṣṭa āsē; ");
INSERT INTO saniso_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","kintu tadviparītaṁ yudhyantaṁ tadanyamēkaṁ svabhāvaṁ madīyāṅgasthitaṁ prapaśyāmi, sa madīyāṅgasthitapāpasvabhāvasyāyattaṁ māṁ karttuṁ cēṣṭatē| ");
INSERT INTO saniso_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","hā hā yō'haṁ durbhāgyō manujastaṁ mām ētasmān mr̥tāccharīrāt kō nistārayiṣyati? ");
INSERT INTO saniso_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","asmākaṁ prabhuṇā yīśukhrīṣṭēna nistārayitāram īśvaraṁ dhanyaṁ vadāmi| ataēva śarīrēṇa pāpavyavasthāyā manasā tu īśvaravyavasthāyāḥ sēvanaṁ karōmi| ");
INSERT INTO saniso_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","yē janāḥ khrīṣṭaṁ yīśum āśritya śārīrikaṁ nācaranta ātmikamācaranti tē'dhunā daṇḍārhā na bhavanti| ");
INSERT INTO saniso_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","jīvanadāyakasyātmanō vyavasthā khrīṣṭayīśunā pāpamaraṇayō rvyavasthātō māmamōcayat| ");
INSERT INTO saniso_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","yasmācchārīrasya durbbalatvād vyavasthayā yat karmmāsādhyam īśvarō nijaputraṁ pāpiśarīrarūpaṁ pāpanāśakabalirūpañca prēṣya tasya śarīrē pāpasya daṇḍaṁ kurvvan tatkarmma sādhitavān| ");
INSERT INTO saniso_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","tataḥ śārīrikaṁ nācaritvāsmābhirātmikam ācaradbhirvyavasthāgranthē nirddiṣṭāni puṇyakarmmāṇi sarvvāṇi sādhyantē| ");
INSERT INTO saniso_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","yē śārīrikācāriṇastē śārīrikān viṣayān bhāvayanti yē cātmikācāriṇastē ātmanō viṣayān bhāvayanti| ");
INSERT INTO saniso_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","śārīrikabhāvasya phalaṁ mr̥tyuḥ kiñcātmikabhāvasya phalē jīvanaṁ śāntiśca| ");
INSERT INTO saniso_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","yataḥ śārīrikabhāva īśvarasya viruddhaḥ śatrutābhāva ēva sa īśvarasya vyavasthāyā adhīnō na bhavati bhavituñca na śaknōti| ");
INSERT INTO saniso_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","ētasmāt śārīrikācāriṣu tōṣṭum īśvarēṇa na śakyaṁ| ");
INSERT INTO saniso_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","kintvīśvarasyātmā yadi yuṣmākaṁ madhyē vasati tarhi yūyaṁ śārīrikācāriṇō na santa ātmikācāriṇō bhavathaḥ| yasmin tu khrīṣṭasyātmā na vidyatē sa tatsambhavō nahi| ");
INSERT INTO saniso_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","yadi khrīṣṭō yuṣmān adhitiṣṭhati tarhi pāpam uddiśya śarīraṁ mr̥taṁ kintu puṇyamuddiśyātmā jīvati| ");
INSERT INTO saniso_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","mr̥tagaṇād yīśu ryēnōtthāpitastasyātmā yadi yuṣmanmadhyē vasati tarhi mr̥tagaṇāt khrīṣṭasya sa utthāpayitā yuṣmanmadhyavāsinā svakīyātmanā yuṣmākaṁ mr̥tadēhānapi puna rjīvayiṣyati| ");
INSERT INTO saniso_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","hē bhrātr̥gaṇa śarīrasya vayamadhamarṇā na bhavāmō'taḥ śārīrikācārō'smābhi rna karttavyaḥ| ");
INSERT INTO saniso_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","yadi yūyaṁ śarīrikācāriṇō bhavēta tarhi yuṣmābhi rmarttavyamēva kintvātmanā yadi śarīrakarmmāṇi ghātayēta tarhi jīviṣyatha| ");
INSERT INTO saniso_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","yatō yāvantō lōkā īśvarasyātmanākr̥ṣyantē tē sarvva īśvarasya santānā bhavanti| ");
INSERT INTO saniso_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","yūyaṁ punarapi bhayajanakaṁ dāsyabhāvaṁ na prāptāḥ kintu yēna bhāvēnēśvaraṁ pitaḥ pitariti prōcya sambōdhayatha tādr̥śaṁ dattakaputratvabhāvam prāpnuta| ");
INSERT INTO saniso_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","aparañca vayam īśvarasya santānā ētasmin pavitra ātmā svayam asmākam ātmābhiḥ sārddhaṁ pramāṇaṁ dadāti| ");
INSERT INTO saniso_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","ataēva vayaṁ yadi santānāstarhyadhikāriṇaḥ, arthād īśvarasya svattvādhikāriṇaḥ khrīṣṭēna sahādhikāriṇaśca bhavāmaḥ; aparaṁ tēna sārddhaṁ yadi duḥkhabhāginō bhavāmastarhi tasya vibhavasyāpi bhāginō bhaviṣyāmaḥ| ");
INSERT INTO saniso_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","kintvasmāsu yō bhāvīvibhavaḥ prakāśiṣyatē tasya samīpē varttamānakālīnaṁ duḥkhamahaṁ tr̥ṇāya manyē| ");
INSERT INTO saniso_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","yataḥ prāṇigaṇa īśvarasya santānānāṁ vibhavaprāptim ākāṅkṣan nitāntam apēkṣatē| ");
INSERT INTO saniso_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","aparañca prāṇigaṇaḥ svairam alīkatāyā vaśīkr̥tō nābhavat ");
INSERT INTO saniso_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","kintu prāṇigaṇō'pi naśvaratādhīnatvāt muktaḥ san īśvarasya santānānāṁ paramamuktiṁ prāpsyatītyabhiprāyēṇa vaśīkartrā vaśīcakrē| ");
INSERT INTO saniso_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","aparañca prasūyamānāvad vyathitaḥ san idānīṁ yāvat kr̥tsnaḥ prāṇigaṇa ārttasvaraṁ karōtīti vayaṁ jānīmaḥ| ");
INSERT INTO saniso_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","kēvalaḥ sa iti nahi kintu prathamajātaphalasvarūpam ātmānaṁ prāptā vayamapi dattakaputratvapadaprāptim arthāt śarīrasya muktiṁ pratīkṣamāṇāstadvad antarārttarāvaṁ kurmmaḥ| ");
INSERT INTO saniso_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","vayaṁ pratyāśayā trāṇam alabhāmahi kintu pratyakṣavastunō yā pratyāśā sā pratyāśā nahi, yatō manuṣyō yat samīkṣatē tasya pratyāśāṁ kutaḥ kariṣyati? ");
INSERT INTO saniso_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","yad apratyakṣaṁ tasya pratyāśāṁ yadi vayaṁ kurvvīmahi tarhi dhairyyam avalambya pratīkṣāmahē| ");
INSERT INTO saniso_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","tata ātmāpi svayam asmākaṁ durbbalatāyāḥ sahāyatvaṁ karōti; yataḥ kiṁ prārthitavyaṁ tad bōddhuṁ vayaṁ na śaknumaḥ, kintvaspaṣṭairārttarāvairātmā svayam asmannimittaṁ nivēdayati| ");
INSERT INTO saniso_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","aparam īśvarābhimatarūpēṇa pavitralōkānāṁ kr̥tē nivēdayati ya ātmā tasyābhiprāyō'ntaryyāminā jñāyatē| ");
INSERT INTO saniso_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","aparam īśvarīyanirūpaṇānusārēṇāhūtāḥ santō yē tasmin prīyantē sarvvāṇi militvā tēṣāṁ maṅgalaṁ sādhayanti, ētad vayaṁ jānīmaḥ| ");
INSERT INTO saniso_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","yata īśvarō bahubhrātr̥ṇāṁ madhyē svaputraṁ jyēṣṭhaṁ karttum icchan yān pūrvvaṁ lakṣyīkr̥tavān tān tasya pratimūrtyāḥ sādr̥śyaprāptyarthaṁ nyayuṁkta| ");
INSERT INTO saniso_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","aparañca tēna yē niyuktāsta āhūtā api yē ca tēnāhūtāstē sapuṇyīkr̥tāḥ, yē ca tēna sapuṇyīkr̥tāstē vibhavayuktāḥ| ");
INSERT INTO saniso_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","ityatra vayaṁ kiṁ brūmaḥ? īśvarō yadyasmākaṁ sapakṣō bhavati tarhi kō vipakṣō'smākaṁ? ");
INSERT INTO saniso_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","ātmaputraṁ na rakṣitvā yō'smākaṁ sarvvēṣāṁ kr̥tē taṁ pradattavān sa kiṁ tēna sahāsmabhyam anyāni sarvvāṇi na dāsyati? ");
INSERT INTO saniso_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","īśvarasyābhirucitēṣu kēna dōṣa ārōpayiṣyatē? ya īśvarastān puṇyavata iva gaṇayati kiṁ tēna? ");
INSERT INTO saniso_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","aparaṁ tēbhyō daṇḍadānājñā vā kēna kariṣyatē? yō'smannimittaṁ prāṇān tyaktavān kēvalaṁ tanna kintu mr̥tagaṇamadhyād utthitavān, api cēśvarasya dakṣiṇē pārśvē tiṣṭhan adyāpyasmākaṁ nimittaṁ prārthata ēvambhūtō yaḥ khrīṣṭaḥ kiṁ tēna? ");
INSERT INTO saniso_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","asmābhiḥ saha khrīṣṭasya prēmavicchēdaṁ janayituṁ kaḥ śaknōti? klēśō vyasanaṁ vā tāḍanā vā durbhikṣaṁ vā vastrahīnatvaṁ vā prāṇasaṁśayō vā khaṅgō vā kimētāni śaknuvanti? ");
INSERT INTO saniso_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","kintu likhitam āstē, yathā, vayaṁ tava nimittaṁ smō mr̥tyuvaktrē'khilaṁ dinaṁ| balirdēyō yathā mēṣō vayaṁ gaṇyāmahē tathā| ");
INSERT INTO saniso_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","aparaṁ yō'smāsu prīyatē tēnaitāsu vipatsu vayaṁ samyag vijayāmahē| ");
INSERT INTO saniso_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","yatō'smākaṁ prabhunā yīśukhrīṣṭēnēśvarasya yat prēma tasmād asmākaṁ vicchēdaṁ janayituṁ mr̥tyu rjīvanaṁ vā divyadūtā vā balavantō mukhyadūtā vā varttamānō vā bhaviṣyan kālō vā uccapadaṁ vā nīcapadaṁ vāparaṁ kimapi sr̥ṣṭavastu ");
INSERT INTO saniso_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","vaitēṣāṁ kēnāpi na śakyamityasmin dr̥ḍhaviśvāsō mamāstē| ");
INSERT INTO saniso_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","ahaṁ kāñcid kalpitāṁ kathāṁ na kathayāmi, khrīṣṭasya sākṣāt satyamēva bravīmi pavitrasyātmanaḥ sākṣān madīyaṁ mana ētat sākṣyaṁ dadāti| ");
INSERT INTO saniso_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","mamāntaratiśayaduḥkhaṁ nirantaraṁ khēdaśca ");
INSERT INTO saniso_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","tasmād ahaṁ svajātīyabhrātr̥ṇāṁ nimittāt svayaṁ khrīṣṭācchāpākrāntō bhavitum aiccham| ");
INSERT INTO saniso_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","yatasta isrāyēlasya vaṁśā api ca dattakaputratvaṁ tējō niyamō vyavasthādānaṁ mandirē bhajanaṁ pratijñāḥ pitr̥puruṣagaṇaścaitēṣu sarvvēṣu tēṣām adhikārō'sti| ");
INSERT INTO saniso_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","tat kēvalaṁ nahi kintu sarvvādhyakṣaḥ sarvvadā saccidānanda īśvarō yaḥ khrīṣṭaḥ sō'pi śārīrikasambandhēna tēṣāṁ vaṁśasambhavaḥ| ");
INSERT INTO saniso_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","īśvarasya vākyaṁ viphalaṁ jātam iti nahi yatkāraṇād isrāyēlō vaṁśē yē jātāstē sarvvē vastuta isrāyēlīyā na bhavanti| ");
INSERT INTO saniso_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","aparam ibrāhīmō vaṁśē jātā api sarvvē tasyaiva santānā na bhavanti kintu ishākō nāmnā tava vaṁśō vikhyātō bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","arthāt śārīrikasaṁsargāt jātāḥ santānā yāvantastāvanta ēvēśvarasya santānā na bhavanti kintu pratiśravaṇād yē jāyantē taēvēśvaravaṁśō gaṇyatē| ");
INSERT INTO saniso_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","yatastatpratiśrutē rvākyamētat, ētādr̥śē samayē 'haṁ punarāgamiṣyāmi tatpūrvvaṁ sārāyāḥ putra ēkō janiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","aparamapi vadāmi svamanō'bhilāṣata īśvarēṇa yannirūpitaṁ tat karmmatō nahi kintvāhvayitu rjātamētad yathā siddhyati ");
INSERT INTO saniso_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","tadarthaṁ ribkānāmikayā yōṣitā janaikasmād arthād asmākam ishākaḥ pūrvvapuruṣād garbhē dhr̥tē tasyāḥ santānayōḥ prasavāt pūrvvaṁ kiñca tayōḥ śubhāśubhakarmmaṇaḥ karaṇāt pūrvvaṁ ");
INSERT INTO saniso_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","tāṁ pratīdaṁ vākyam uktaṁ, jyēṣṭhaḥ kaniṣṭhaṁ sēviṣyatē, ");
INSERT INTO saniso_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","yathā likhitam āstē, tathāpyēṣāvi na prītvā yākūbi prītavān ahaṁ| ");
INSERT INTO saniso_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","tarhi vayaṁ kiṁ brūmaḥ? īśvaraḥ kim anyāyakārī? tathā na bhavatu| ");
INSERT INTO saniso_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","yataḥ sa svayaṁ mūsām avadat; ahaṁ yasmin anugrahaṁ cikīrṣāmi tamēvānugr̥hlāmi, yañca dayitum icchāmi tamēva dayē| ");
INSERT INTO saniso_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","ataēvēcchatā yatamānēna vā mānavēna tanna sādhyatē dayākāriṇēśvarēṇaiva sādhyatē| ");
INSERT INTO saniso_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","phirauṇi śāstrē likhati, ahaṁ tvaddvārā matparākramaṁ darśayituṁ sarvvapr̥thivyāṁ nijanāma prakāśayituñca tvāṁ sthāpitavān| ");
INSERT INTO saniso_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","ataḥ sa yam anugrahītum icchati tamēvānugr̥hlāti, yañca nigrahītum icchati taṁ nigr̥hlāti| ");
INSERT INTO saniso_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","yadi vadasi tarhi sa dōṣaṁ kutō gr̥hlāti? tadīyēcchāyāḥ pratibandhakatvaṁ karttaṁ kasya sāmarthyaṁ vidyatē? ");
INSERT INTO saniso_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","hē īśvarasya pratipakṣa martya tvaṁ kaḥ? ētādr̥śaṁ māṁ kutaḥ sr̥ṣṭavān? iti kathāṁ sr̥ṣṭavastu sraṣṭrē kiṁ kathayiṣyati? ");
INSERT INTO saniso_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","ēkasmān mr̥tpiṇḍād utkr̥ṣṭāpakr̥ṣṭau dvividhau kalaśau karttuṁ kiṁ kulālasya sāmarthyaṁ nāsti? ");
INSERT INTO saniso_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","īśvaraḥ kōpaṁ prakāśayituṁ nijaśaktiṁ jñāpayituñcēcchan yadi vināśasya yōgyāni krōdhabhājanāni prati bahukālaṁ dīrghasahiṣṇutām āśrayati; ");
INSERT INTO saniso_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","aparañca vibhavaprāptyarthaṁ pūrvvaṁ niyuktānyanugrahapātrāṇi prati nijavibhavasya bāhulyaṁ prakāśayituṁ kēvalayihūdināṁ nahi bhinnadēśināmapi madhyād ");
INSERT INTO saniso_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","asmāniva tānyāhvayati tatra tava kiṁ? ");
INSERT INTO saniso_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","hōśēyagranthē yathā likhitam āstē, yō lōkō mama nāsīt taṁ vadiṣyāmi madīyakaṁ| yā jāti rmē'priyā cāsīt tāṁ vadiṣyāmyahaṁ priyāṁ| ");
INSERT INTO saniso_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","yūyaṁ madīyalōkā na yatrēti vākyamaucyata| amarēśasya santānā iti khyāsyanti tatra tē| ");
INSERT INTO saniso_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","isrāyēlīyalōkēṣu yiśāyiyō'pi vācamētāṁ prācārayat, isrāyēlīyavaṁśānāṁ yā saṁkhyā sā tu niścitaṁ| samudrasikatāsaṁkhyāsamānā yadi jāyatē| tathāpi kēvalaṁ lōkairalpaistrāṇaṁ vrajiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","yatō nyāyēna svaṁ karmma parēśaḥ sādhayiṣyati| dēśē saēva saṁkṣēpānnijaṁ karmma kariṣyati| ");
INSERT INTO saniso_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","yiśāyiyō'paramapi kathayāmāsa, sainyādhyakṣaparēśēna cēt kiñcinnōdaśiṣyata| tadā vayaṁ sidōmēvābhaviṣyāma viniścitaṁ| yadvā vayam amōrāyā agamiṣyāma tulyatāṁ| ");
INSERT INTO saniso_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","tarhi vayaṁ kiṁ vakṣyāmaḥ? itaradēśīyā lōkā api puṇyārtham ayatamānā viśvāsēna puṇyam alabhanta; ");
INSERT INTO saniso_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","kintvisrāyēllōkā vyavasthāpālanēna puṇyārthaṁ yatamānāstan nālabhanta| ");
INSERT INTO saniso_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","tasya kiṁ kāraṇaṁ? tē viśvāsēna nahi kintu vyavasthāyāḥ kriyayā cēṣṭitvā tasmin skhalanajanakē pāṣāṇē pādaskhalanaṁ prāptāḥ| ");
INSERT INTO saniso_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","likhitaṁ yādr̥śam āstē, paśya pādaskhalārthaṁ hi sīyōni prastarantathā| bādhākārañca pāṣāṇaṁ paristhāpitavānaham| viśvasiṣyati yastatra sa janō na trapiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","hē bhrātara isrāyēlīyalōkā yat paritrāṇaṁ prāpnuvanti tadahaṁ manasābhilaṣan īśvarasya samīpē prārthayē| ");
INSERT INTO saniso_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","yata īśvarē tēṣāṁ cēṣṭā vidyata ityatrāhaṁ sākṣyasmi; kintu tēṣāṁ sā cēṣṭā sajñānā nahi, ");
INSERT INTO saniso_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","yatasta īśvaradattaṁ puṇyam avijñāya svakr̥tapuṇyaṁ sthāpayitum cēṣṭamānā īśvaradattasya puṇyasya nighnatvaṁ na svīkurvvanti| ");
INSERT INTO saniso_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","khrīṣṭa ēkaikaviśvāsijanāya puṇyaṁ dātuṁ vyavasthāyāḥ phalasvarūpō bhavati| ");
INSERT INTO saniso_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","vyavasthāpālanēna yat puṇyaṁ tat mūsā varṇayāmāsa, yathā, yō janastāṁ pālayiṣyati sa taddvārā jīviṣyati| ");
INSERT INTO saniso_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","kintu pratyayēna yat puṇyaṁ tad ētādr̥śaṁ vākyaṁ vadati, kaḥ svargam āruhya khrīṣṭam avarōhayiṣyati? ");
INSERT INTO saniso_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","kō vā prētalōkam avaruhya khrīṣṭaṁ mr̥tagaṇamadhyād ānēṣyatīti vāk manasi tvayā na gaditavyā| ");
INSERT INTO saniso_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","tarhi kiṁ bravīti? tad vākyaṁ tava samīpastham arthāt tava vadanē manasi cāstē, tacca vākyam asmābhiḥ pracāryyamāṇaṁ viśvāsasya vākyamēva| ");
INSERT INTO saniso_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","vastutaḥ prabhuṁ yīśuṁ yadi vadanēna svīkarōṣi, tathēśvarastaṁ śmaśānād udasthāpayad iti yadyantaḥkaraṇēna viśvasiṣi tarhi paritrāṇaṁ lapsyasē| ");
INSERT INTO saniso_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","yasmāt puṇyaprāptyartham antaḥkaraṇēna viśvasitavyaṁ paritrāṇārthañca vadanēna svīkarttavyaṁ| ");
INSERT INTO saniso_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","śāstrē yādr̥śaṁ likhati viśvasiṣyati yastatra sa janō na trapiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","ityatra yihūdini tadanyalōkē ca kōpi viśēṣō nāsti yasmād yaḥ sarvvēṣām advitīyaḥ prabhuḥ sa nijayācakāna sarvvān prati vadānyō bhavati| ");
INSERT INTO saniso_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","yataḥ, yaḥ kaścit paramēśasya nāmnā hi prārthayiṣyatē| sa ēva manujō nūnaṁ paritrātō bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","yaṁ yē janā na pratyāyan tē tamuddiśya kathaṁ prārthayiṣyantē? yē vā yasyākhyānaṁ kadāpi na śrutavantastē taṁ kathaṁ pratyēṣyanti? aparaṁ yadi pracārayitārō na tiṣṭhanti tadā kathaṁ tē śrōṣyanti? ");
INSERT INTO saniso_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","yadi vā prēritā na bhavanti tadā kathaṁ pracārayiṣyanti? yādr̥śaṁ likhitam āstē, yathā, māṅgalikaṁ susaṁvādaṁ dadatyānīya yē narāḥ| pracārayanti śāntēśca susaṁvādaṁ janāstu yē| tēṣāṁ caraṇapadmāni kīdr̥k śōbhānvitāni hi| ");
INSERT INTO saniso_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","kintu tē sarvvē taṁ susaṁvādaṁ na gr̥hītavantaḥ| yiśāyiyō yathā likhitavān| asmatpracāritē vākyē viśvāsamakarōddhi kaḥ| ");
INSERT INTO saniso_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","ataēva śravaṇād viśvāsa aiśvaravākyapracārāt śravaṇañca bhavati| ");
INSERT INTO saniso_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","tarhyahaṁ bravīmi taiḥ kiṁ nāśrāvi? avaśyam aśrāvi, yasmāt tēṣāṁ śabdō mahīṁ vyāpnōd vākyañca nikhilaṁ jagat| ");
INSERT INTO saniso_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","aparamapi vadāmi, isrāyēlīyalōkāḥ kim ētāṁ kathāṁ na budhyantē? prathamatō mūsā idaṁ vākyaṁ prōvāca, ahamuttāpayiṣyē tān agaṇyamānavairapi| klēkṣyāmi jātim ētāñca prōnmattabhinnajātibhiḥ| ");
INSERT INTO saniso_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","aparañca yiśāyiyō'tiśayākṣōbhēṇa kathayāmāsa, yathā, adhi māṁ yaistu nācēṣṭi samprāptastai rjanairahaṁ| adhi māṁ yai rna sampr̥ṣṭaṁ vijñātastai rjanairahaṁ|| ");
INSERT INTO saniso_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","kintvisrāyēlīyalōkān adhi kathayāñcakāra, yairājñālaṅghibhi rlōkai rviruddhaṁ vākyamucyatē| tān pratyēva dinaṁ kr̥tsnaṁ hastau vistārayāmyahaṁ|| ");
INSERT INTO saniso_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","īśvarēṇa svīkīyalōkā apasāritā ahaṁ kim īdr̥śaṁ vākyaṁ bravīmi? tanna bhavatu yatō'hamapi binyāmīnagōtrīya ibrāhīmavaṁśīya isrāyēlīyalōkō'smi| ");
INSERT INTO saniso_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","īśvarēṇa pūrvvaṁ yē pradr̥ṣṭāstē svakīyalōkā apasāritā iti nahi| aparam ēliyōpākhyānē śāstrē yallikhitam āstē tad yūyaṁ kiṁ na jānītha? ");
INSERT INTO saniso_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","hē paramēśvara lōkāstvadīyāḥ sarvvā yajñavēdīrabhañjan tathā tava bhaviṣyadvādinaḥ sarvvān aghnan kēvala ēkō'ham avaśiṣṭa āsē tē mamāpi prāṇān nāśayituṁ cēṣṭanatē, ētāṁ kathām isrāyēlīyalōkānāṁ viruddham ēliya īśvarāya nivēdayāmāsa| ");
INSERT INTO saniso_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","tatastaṁ pratīśvarasyōttaraṁ kiṁ jātaṁ? bālnāmnō dēvasya sākṣāt yai rjānūni na pātitāni tādr̥śāḥ sapta sahasrāṇi lōkā avaśēṣitā mayā| ");
INSERT INTO saniso_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","tadvad ētasmin varttamānakālē'pi anugrahēṇābhirucitāstēṣām avaśiṣṭāḥ katipayā lōkāḥ santi| ");
INSERT INTO saniso_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","ataēva tad yadyanugrahēṇa bhavati tarhi kriyayā na bhavati nō cēd anugrahō'nanugraha ēva, yadi vā kriyayā bhavati tarhyanugrahēṇa na bhavati nō cēt kriyā kriyaiva na bhavati| ");
INSERT INTO saniso_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","tarhi kiṁ? isrāyēlīyalōkā yad amr̥gayanta tanna prāpuḥ| kintvabhirucitalōkāstat prāpustadanyē sarvva andhībhūtāḥ| ");
INSERT INTO saniso_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","yathā likhitam āstē, ghōranidrālutābhāvaṁ dr̥ṣṭihīnē ca lōcanē| karṇau śrutivihīnau ca pradadau tēbhya īśvaraḥ|| ");
INSERT INTO saniso_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","ētēsmin dāyūdapi likhitavān yathā, atō bhuktyāsanaṁ tēṣām unmāthavad bhaviṣyati| vā vaṁśayantravad bādhā daṇḍavad vā bhaviṣyati|| ");
INSERT INTO saniso_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","bhaviṣyanti tathāndhāstē nētraiḥ paśyanti nō yathā| vēpathuḥ kaṭidēśasya tēṣāṁ nityaṁ bhaviṣyati|| ");
INSERT INTO saniso_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","patanārthaṁ tē skhalitavanta iti vācaṁ kimahaṁ vadāmi? tanna bhavatu kintu tān udyōginaḥ karttuṁ tēṣāṁ patanād itaradēśīyalōkaiḥ paritrāṇaṁ prāptaṁ| ");
INSERT INTO saniso_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","tēṣāṁ patanaṁ yadi jagatō lōkānāṁ lābhajanakam abhavat tēṣāṁ hrāsō'pi yadi bhinnadēśināṁ lābhajanakō'bhavat tarhi tēṣāṁ vr̥ddhiḥ kati lābhajanikā bhaviṣyati? ");
INSERT INTO saniso_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","atō hē anyadēśinō yuṣmān sambōdhya kathayāmi nijānāṁ jñātibandhūnāṁ manaḥsūdyōgaṁ janayan tēṣāṁ madhyē kiyatāṁ lōkānāṁ yathā paritrāṇaṁ sādhayāmi ");
INSERT INTO saniso_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","tannimittam anyadēśināṁ nikaṭē prēritaḥ san ahaṁ svapadasya mahimānaṁ prakāśayāmi| ");
INSERT INTO saniso_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","tēṣāṁ nigrahēṇa yadīśvarēṇa saha jagatō janānāṁ mēlanaṁ jātaṁ tarhi tēṣām anugr̥hītatvaṁ mr̥tadēhē yathā jīvanalābhastadvat kiṁ na bhaviṣyati? ");
INSERT INTO saniso_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","aparaṁ prathamajātaṁ phalaṁ yadi pavitraṁ bhavati tarhi sarvvamēva phalaṁ pavitraṁ bhaviṣyati; tathā mūlaṁ yadi pavitraṁ bhavati tarhi śākhā api tathaiva bhaviṣyanti| ");
INSERT INTO saniso_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","kiyatīnāṁ śākhānāṁ chēdanē kr̥tē tvaṁ vanyajitavr̥kṣasya śākhā bhūtvā yadi tacchākhānāṁ sthānē rōpitā sati jitavr̥kṣīyamūlasya rasaṁ bhuṁkṣē, ");
INSERT INTO saniso_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","tarhi tāsāṁ bhinnaśākhānāṁ viruddhaṁ māṁ garvvīḥ; yadi garvvasi tarhi tvaṁ mūlaṁ yanna dhārayasi kintu mūlaṁ tvāṁ dhārayatīti saṁsmara| ");
INSERT INTO saniso_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","aparañca yadi vadasi māṁ rōpayituṁ tāḥ śākhā vibhannā abhavan; ");
INSERT INTO saniso_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","bhadram, apratyayakāraṇāt tē vibhinnā jātāstathā viśvāsakāraṇāt tvaṁ rōpitō jātastasmād ahaṅkāram akr̥tvā sasādhvasō bhava| ");
INSERT INTO saniso_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","yata īśvarō yadi svābhāvikīḥ śākhā na rakṣati tarhi sāvadhānō bhava cēt tvāmapi na sthāpayati| ");
INSERT INTO saniso_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","ityatrēśvarasya yādr̥śī kr̥pā tādr̥śaṁ bhayānakatvamapi tvayā dr̥śyatāṁ; yē patitāstān prati tasya bhayānakatvaṁ dr̥śyatāṁ, tvañca yadi tatkr̥pāśritastiṣṭhasi tarhi tvāṁ prati kr̥pā drakṣyatē; nō cēt tvamapi tadvat chinnō bhaviṣyasi| ");
INSERT INTO saniso_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","aparañca tē yadyapratyayē na tiṣṭhanti tarhi punarapi rōpayiṣyantē yasmāt tān punarapi rōpayitum iśvarasya śaktirāstē| ");
INSERT INTO saniso_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","vanyajitavr̥kṣasya śākhā san tvaṁ yadi tataśchinnō rītivyatyayēnōttamajitavr̥kṣē rōेेpitō'bhavastarhi tasya vr̥kṣasya svīyā yāḥ śākhāstāḥ kiṁ punaḥ svavr̥kṣē saṁlagituṁ na śaknuvanti? ");
INSERT INTO saniso_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","hē bhrātarō yuṣmākam ātmābhimānō yanna jāyatē tadarthaṁ mamēdr̥śī vāñchā bhavati yūyaṁ ētannigūḍhatattvam ajānantō yanna tiṣṭhatha; vastutō yāvatkālaṁ sampūrṇarūpēṇa bhinnadēśināṁ saṁgrahō na bhaviṣyati tāvatkālam aṁśatvēna isrāyēlīyalōkānām andhatā sthāsyati; ");
INSERT INTO saniso_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","paścāt tē sarvvē paritrāsyantē; ētādr̥śaṁ likhitamapyāstē, āgamiṣyati sīyōnād ēkō yastrāṇadāyakaḥ| adharmmaṁ yākubō vaṁśāt sa tu dūrīkariṣyati| ");
INSERT INTO saniso_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","tathā dūrīkariṣyāmi tēṣāṁ pāpānyahaṁ yadā| tadā tairēva sārddhaṁ mē niyamō'yaṁ bhaviṣyati| ");
INSERT INTO saniso_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","susaṁvādāt tē yuṣmākaṁ vipakṣā abhavan kintvabhirucitatvāt tē pitr̥lōkānāṁ kr̥tē priyapātrāṇi bhavanti| ");
INSERT INTO saniso_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","yata īśvarasya dānād āhvānāñca paścāttāpō na bhavati| ");
INSERT INTO saniso_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","ataēva pūrvvam īśvarē'viśvāsinaḥ santō'pi yūyaṁ yadvat samprati tēṣām aviśvāsakāraṇād īśvarasya kr̥pāpātrāṇi jātāstadvad ");
INSERT INTO saniso_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","idānīṁ tē'viśvāsinaḥ santi kintu yuṣmābhi rlabdhakr̥pākāraṇāt tairapi kr̥pā lapsyatē| ");
INSERT INTO saniso_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","īśvaraḥ sarvvān prati kr̥pāṁ prakāśayituṁ sarvvān aviśvāsitvēna gaṇayati| ");
INSERT INTO saniso_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","ahō īśvarasya jñānabuddhirūpayō rdhanayōḥ kīdr̥k prācuryyaṁ| tasya rājaśāsanasya tattvaṁ kīdr̥g aprāpyaṁ| tasya mārgāśca kīdr̥g anupalakṣyāḥ| ");
INSERT INTO saniso_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","paramēśvarasya saṅkalpaṁ kō jñātavān? tasya mantrī vā kō'bhavat? ");
INSERT INTO saniso_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","kō vā tasyōpakārī bhr̥tvā tatkr̥tē tēna pratyupakarttavyaḥ? ");
INSERT INTO saniso_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","yatō vastumātramēva tasmāt tēna tasmai cābhavat tadīyō mahimā sarvvadā prakāśitō bhavatu| iti| ");
INSERT INTO saniso_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","hē bhrātara īśvarasya kr̥payāhaṁ yuṣmān vinayē yūyaṁ svaṁ svaṁ śarīraṁ sajīvaṁ pavitraṁ grāhyaṁ balim īśvaramuddiśya samutsr̥jata, ēṣā sēvā yuṣmākaṁ yōgyā| ");
INSERT INTO saniso_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","aparaṁ yūyaṁ sāṁsārikā iva mācarata, kintu svaṁ svaṁ svabhāvaṁ parāvartya nūtanācāriṇō bhavata, tata īśvarasya nidēśaḥ kīdr̥g uttamō grahaṇīyaḥ sampūrṇaścēti yuṣmābhiranubhāviṣyatē| ");
INSERT INTO saniso_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","kaścidapi janō yōgyatvādadhikaṁ svaṁ na manyatāṁ kintu īśvarō yasmai pratyayasya yatparimāṇam adadāt sa tadanusāratō yōgyarūpaṁ svaṁ manutām, īśvarād anugrahaṁ prāptaḥ san yuṣmākam ēkaikaṁ janam ityājñāpayāmi| ");
INSERT INTO saniso_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","yatō yadvadasmākam ēkasmin śarīrē bahūnyaṅgāni santi kintu sarvvēṣāmaṅgānāṁ kāryyaṁ samānaṁ nahi; ");
INSERT INTO saniso_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","tadvadasmākaṁ bahutvē'pi sarvvē vayaṁ khrīṣṭē ēkaśarīrāḥ parasparam aṅgapratyaṅgatvēna bhavāmaḥ| ");
INSERT INTO saniso_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","asmād īśvarānugrahēṇa viśēṣaṁ viśēṣaṁ dānam asmāsu prāptēṣu satsu kōpi yadi bhaviṣyadvākyaṁ vadati tarhi pratyayasya parimāṇānusārataḥ sa tad vadatu; ");
INSERT INTO saniso_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","yadvā yadi kaścit sēvanakārī bhavati tarhi sa tatsēvanaṁ karōtu; athavā yadi kaścid adhyāpayitā bhavati tarhi sō'dhyāpayatu; ");
INSERT INTO saniso_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","tathā ya upadēṣṭā bhavati sa upadiśatu yaśca dātā sa saralatayā dadātu yastvadhipatiḥ sa yatnēnādhipatitvaṁ karōtu yaśca dayāluḥ sa hr̥ṣṭamanasā dayatām| ");
INSERT INTO saniso_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","aparañca yuṣmākaṁ prēma kāpaṭyavarjitaṁ bhavatu yad abhadraṁ tad r̥tīyadhvaṁ yacca bhadraṁ tasmin anurajyadhvam| ");
INSERT INTO saniso_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","aparaṁ bhrātr̥tvaprēmnā parasparaṁ prīyadhvaṁ samādarād ēkō'parajanaṁ śrēṣṭhaṁ jānīdhvam| ");
INSERT INTO saniso_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","tathā kāryyē nirālasyā manasi ca sōdyōgāḥ santaḥ prabhuṁ sēvadhvam| ");
INSERT INTO saniso_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","aparaṁ pratyāśāyām ānanditā duḥkhasamayē ca dhairyyayuktā bhavata; prārthanāyāṁ satataṁ pravarttadhvaṁ| ");
INSERT INTO saniso_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","pavitrāṇāṁ dīnatāṁ dūrīkurudhvam atithisēvāyām anurajyadhvam| ");
INSERT INTO saniso_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","yē janā yuṣmān tāḍayanti tān āśiṣaṁ vadata śāpam adattvā daddhvamāśiṣam| ");
INSERT INTO saniso_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","yē janā ānandanti taiḥ sārddham ānandata yē ca rudanti taiḥ saha rudita| ");
INSERT INTO saniso_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","aparañca yuṣmākaṁ manasāṁ parasparam ēkōbhāvō bhavatu; aparam uccapadam anākāṅkṣya nīcalōkaiḥ sahāpi mārdavam ācarata; svān jñāninō na manyadhvaṁ| ");
INSERT INTO saniso_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","parasmād apakāraṁ prāpyāpi paraṁ nāpakuruta| sarvvēṣāṁ dr̥ṣṭitō yat karmmōttamaṁ tadēva kuruta| ");
INSERT INTO saniso_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","yadi bhavituṁ śakyatē tarhi yathāśakti sarvvalōkaiḥ saha nirvvirōdhēna kālaṁ yāpayata| ");
INSERT INTO saniso_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","hē priyabandhavaḥ, kasmaicid apakārasya samucitaṁ daṇḍaṁ svayaṁ na daddhvaṁ, kintvīśvarīyakrōdhāya sthānaṁ datta yatō likhitamāstē paramēśvaraḥ kathayati, dānaṁ phalasya matkarmma sūcitaṁ pradadāmyahaṁ| ");
INSERT INTO saniso_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","itikāraṇād ripu ryadi kṣudhārttastē tarhi taṁ tvaṁ prabhōjaya| tathā yadi tr̥ṣārttaḥ syāt tarhi taṁ paripāyaya| tēna tvaṁ mastakē tasya jvaladagniṁ nidhāsyasi| ");
INSERT INTO saniso_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","kukriyayā parājitā na santa uttamakriyayā kukriyāṁ parājayata| ");
INSERT INTO saniso_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","yuṣmākam ēkaikajanaḥ śāsanapadasya nighnō bhavatu yatō yāni śāsanapadāni santi tāni sarvvāṇīśvarēṇa sthāpitāni; īśvaraṁ vinā padasthāpanaṁ na bhavati| ");
INSERT INTO saniso_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","iti hētōḥ śāsanapadasya yat prātikūlyaṁ tad īśvarīyanirūpaṇasya prātikūlyamēva; aparaṁ yē prātikūlyam ācaranti tē svēṣāṁ samucitaṁ daṇḍaṁ svayamēva ghaṭayantē| ");
INSERT INTO saniso_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","śāstā sadācāriṇāṁ bhayapradō nahi durācāriṇāmēva bhayapradō bhavati; tvaṁ kiṁ tasmān nirbhayō bhavitum icchasi? tarhi satkarmmācara, tasmād yaśō lapsyasē, ");
INSERT INTO saniso_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","yatastava sadācaraṇāya sa īśvarasya bhr̥tyō'sti| kintu yadi kukarmmācarasi tarhi tvaṁ śaṅkasva yataḥ sa nirarthakaṁ khaṅgaṁ na dhārayati; kukarmmācāriṇaṁ samucitaṁ daṇḍayitum sa īśvarasya daṇḍadabhr̥tya ēva| ");
INSERT INTO saniso_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","ataēva kēvaladaṇḍabhayānnahi kintu sadasadbōdhādapi tasya vaśyēna bhavitavyaṁ| ");
INSERT INTO saniso_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","ētasmād yuṣmākaṁ rājakaradānamapyucitaṁ yasmād yē karaṁ gr̥hlanti ta īśvarasya kiṅkarā bhūtvā satatam ētasmin karmmaṇi niviṣṭāstiṣṭhanti| ");
INSERT INTO saniso_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","asmāt karagrāhiṇē karaṁ datta, tathā śulkagrāhiṇē śulkaṁ datta, aparaṁ yasmād bhētavyaṁ tasmād bibhīta, yaśca samādaraṇīyastaṁ samādriyadhvam; itthaṁ yasya yat prāpyaṁ tat tasmai datta| ");
INSERT INTO saniso_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","yuṣmākaṁ parasparaṁ prēma vinā 'nyat kimapi dēyam r̥ṇaṁ na bhavatu, yatō yaḥ parasmin prēma karōti tēna vyavasthā sidhyati| ");
INSERT INTO saniso_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","vastutaḥ paradārān mā gaccha, narahatyāṁ mā kārṣīḥ, cairyyaṁ mā kārṣīḥ, mithyāsākṣyaṁ mā dēhi, lōbhaṁ mā kārṣīḥ, ētāḥ sarvvā ājñā ētābhyō bhinnā yā kācid ājñāsti sāpi svasamīpavāsini svavat prēma kurvvityanēna vacanēna vēditā| ");
INSERT INTO saniso_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","yataḥ prēma samīpavāsinō'śubhaṁ na janayati tasmāt prēmnā sarvvā vyavasthā pālyatē| ");
INSERT INTO saniso_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","pratyayībhavanakālē'smākaṁ paritrāṇasya sāmīpyād idānīṁ tasya sāmīpyam avyavahitaṁ; ataḥ samayaṁ vivicyāsmābhiḥ sāmpratam avaśyamēva nidrātō jāgarttavyaṁ| ");
INSERT INTO saniso_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","bahutarā yāminī gatā prabhātaṁ sannidhiṁ prāptaṁ tasmāt tāmasīyāḥ kriyāḥ parityajyāsmābhi rvāsarīyā sajjā paridhātavyā| ");
INSERT INTO saniso_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","atō hētō rvayaṁ divā vihitaṁ sadācaraṇam ācariṣyāmaḥ| raṅgarasō mattatvaṁ lampaṭatvaṁ kāmukatvaṁ vivāda īrṣyā caitāni parityakṣyāmaḥ| ");
INSERT INTO saniso_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","yūyaṁ prabhuyīśukhrīṣṭarūpaṁ paricchadaṁ paridhaddhvaṁ sukhābhilāṣapūraṇāya śārīrikācaraṇaṁ mācarata| ");
INSERT INTO saniso_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","yō janō'dr̥ḍhaviśvāsastaṁ yuṣmākaṁ saṅginaṁ kuruta kintu sandēhavicārārthaṁ nahi| ");
INSERT INTO saniso_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","yatō niṣiddhaṁ kimapi khādyadravyaṁ nāsti, kasyacijjanasya pratyaya ētādr̥śō vidyatē kintvadr̥ḍhaviśvāsaḥ kaścidaparō janaḥ kēvalaṁ śākaṁ bhuṅktaṁ| ");
INSERT INTO saniso_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","tarhi yō janaḥ sādhāraṇaṁ dravyaṁ bhuṅktē sa viśēṣadravyabhōktāraṁ nāvajānīyāt tathā viśēṣadravyabhōktāpi sādhāraṇadravyabhōktāraṁ dōṣiṇaṁ na kuryyāt, yasmād īśvarastam agr̥hlāt| ");
INSERT INTO saniso_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","hē paradāsasya dūṣayitastvaṁ kaḥ? nijaprabhōḥ samīpē tēna padasthēna padacyutēna vā bhavitavyaṁ sa ca padastha ēva bhaviṣyati yata īśvarastaṁ padasthaṁ karttuṁ śaknōti| ");
INSERT INTO saniso_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","aparañca kaścijjanō dinād dinaṁ viśēṣaṁ manyatē kaścittuु sarvvāṇi dināni samānāni manyatē, ēkaikō janaḥ svīyamanasi vivicya niścinōtu| ");
INSERT INTO saniso_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","yō janaḥ kiñcana dinaṁ viśēṣaṁ manyatē sa prabhubhaktyā tan manyatē, yaśca janaḥ kimapi dinaṁ viśēṣaṁ na manyatē sō'pi prabhubhaktyā tanna manyatē; aparañca yaḥ sarvvāṇi bhakṣyadravyāṇi bhuṅktē sa prabhubhaktayā tāni bhuṅktē yataḥ sa īśvaraṁ dhanyaṁ vakti, yaśca na bhuṅktē sō'pi prabhubhaktyaiva na bhuñjāna īśvaraṁ dhanyaṁ brūtē| ");
INSERT INTO saniso_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","aparam asmākaṁ kaścit nijanimittaṁ prāṇān dhārayati nijanimittaṁ mriyatē vā tanna; ");
INSERT INTO saniso_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","kintu yadi vayaṁ prāṇān dhārayāmastarhi prabhunimittaṁ dhārayāmaḥ, yadi ca prāṇān tyajāmastarhyapi prabhunimittaṁ tyajāmaḥ, ataēva jīvanē maraṇē vā vayaṁ prabhōrēvāsmahē| ");
INSERT INTO saniso_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","yatō jīvantō mr̥tāścētyubhayēṣāṁ lōkānāṁ prabhutvaprāptyarthaṁ khrīṣṭō mr̥ta utthitaḥ punarjīvitaśca| ");
INSERT INTO saniso_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","kintu tvaṁ nijaṁ bhrātaraṁ kutō dūṣayasi? tathā tvaṁ nijaṁ bhrātaraṁ kutastucchaṁ jānāsi? khrīṣṭasya vicārasiṁhāsanasya sammukhē sarvvairasmābhirupasthātavyaṁ; ");
INSERT INTO saniso_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","yādr̥śaṁ likhitam āstē, parēśaḥ śapathaṁ kurvvan vākyamētat purāvadat| sarvvō janaḥ samīpē mē jānupātaṁ kariṣyati| jihvaikaikā tathēśasya nighnatvaṁ svīkariṣyati| ");
INSERT INTO saniso_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","ataēva īśvarasamīpē'smākam ēkaikajanēna nijā kathā kathayitavyā| ");
INSERT INTO saniso_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","itthaṁ sati vayam adyārabhya parasparaṁ na dūṣayantaḥ svabhrātu rvighnō vyāghātō vā yanna jāyēta tādr̥śīmīhāṁ kurmmahē| ");
INSERT INTO saniso_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","kimapi vastu svabhāvatō nāśuci bhavatītyahaṁ jānē tathā prabhunā yīśukhrīṣṭēnāpi niścitaṁ jānē, kintu yō janō yad dravyam apavitraṁ jānītē tasya kr̥tē tad apavitram āstē| ");
INSERT INTO saniso_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","ataēva tava bhakṣyadravyēṇa tava bhrātā śōkānvitō bhavati tarhi tvaṁ bhrātaraṁ prati prēmnā nācarasi| khrīṣṭō yasya kr̥tē svaprāṇān vyayitavān tvaṁ nijēna bhakṣyadravyēṇa taṁ na nāśaya| ");
INSERT INTO saniso_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","aparaṁ yuṣmākam uttamaṁ karmma ninditaṁ na bhavatu| ");
INSERT INTO saniso_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","bhakṣyaṁ pēyañcēśvararājyasya sārō nahi, kintu puṇyaṁ śāntiśca pavitrēṇātmanā jāta ānandaśca| ");
INSERT INTO saniso_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","ētai ryō janaḥ khrīṣṭaṁ sēvatē, sa ēvēśvarasya tuṣṭikarō manuṣyaiśca sukhyātaḥ| ");
INSERT INTO saniso_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","ataēva yēnāsmākaṁ sarvvēṣāṁ parasparam aikyaṁ niṣṭhā ca jāyatē tadēvāsmābhi ryatitavyaṁ| ");
INSERT INTO saniso_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","bhakṣyārtham īśvarasya karmmaṇō hāniṁ mā janayata; sarvvaṁ vastu pavitramiti satyaṁ tathāpi yō janō yad bhuktvā vighnaṁ labhatē tadarthaṁ tad bhadraṁ nahi| ");
INSERT INTO saniso_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","tava māṁsabhakṣaṇasurāpānādibhiḥ kriyābhi ryadi tava bhrātuḥ pādaskhalanaṁ vighnō vā cāñcalyaṁ vā jāyatē tarhi tadbhōjanapānayōstyāgō bhadraḥ| ");
INSERT INTO saniso_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","yadi tava pratyayastiṣṭhati tarhīśvarasya gōcarē svāntarē taṁ gōpaya; yō janaḥ svamatēna svaṁ dōṣiṇaṁ na karōti sa ēva dhanyaḥ| ");
INSERT INTO saniso_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","kintu yaḥ kaścit saṁśayya bhuṅktē'rthāt na pratītya bhuṅktē, sa ēvāvaśyaṁ daṇḍārhō bhaviṣyati, yatō yat pratyayajaṁ nahi tadēva pāpamayaṁ bhavati| ");
INSERT INTO saniso_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","balavadbhirasmābhi rdurbbalānāṁ daurbbalyaṁ sōḍhavyaṁ na ca svēṣām iṣṭācāra ācaritavyaḥ| ");
INSERT INTO saniso_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","asmākam ēkaikō janaḥ svasamīpavāsinō hitārthaṁ niṣṭhārthañca tasyaivēṣṭācāram ācaratu| ");
INSERT INTO saniso_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","yataḥ khrīṣṭō'pi nijēṣṭācāraṁ nācaritavān, yathā likhitam āstē, tvannindakagaṇasyaiva nindābhi rninditō'smyahaṁ| ");
INSERT INTO saniso_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","aparañca vayaṁ yat sahiṣṇutāsāntvanayō rjanakēna śāstrēṇa pratyāśāṁ labhēmahi tannimittaṁ pūrvvakālē likhitāni sarvvavacanānyasmākam upadēśārthamēva lilikhirē| ");
INSERT INTO saniso_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","sahiṣṇutāsāntvanayōrākarō ya īśvaraḥ sa ēvaṁ karōtu yat prabhu ryīśukhrīṣṭa iva yuṣmākam ēkajanō'nyajanēna sārddhaṁ manasa aikyam ācarēt; ");
INSERT INTO saniso_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","yūyañca sarvva ēkacittā bhūtvā mukhaikēnēvāsmatprabhuyīśukhrīṣṭasya piturīśvarasya guṇān kīrttayēta| ");
INSERT INTO saniso_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","aparam īśvarasya mahimnaḥ prakāśārthaṁ khrīṣṭō yathā yuṣmān pratyagr̥hlāt tathā yuṣmākamapyēkō janō'nyajanaṁ pratigr̥hlātu| ");
INSERT INTO saniso_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","yathā likhitam āstē, atō'haṁ sammukhē tiṣṭhan bhinnadēśanivāsināṁ| stuvaṁstvāṁ parigāsyāmi tava nāmni parēśvara|| ");
INSERT INTO saniso_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","tasya dayālutvācca bhinnajātīyā yad īśvarasya guṇān kīrttayēyustadarthaṁ yīśuḥ khrīṣṭastvakchēdaniyamasya nighnō'bhavad ityahaṁ vadāmi| yathā likhitam āstē, atō'haṁ sammukhē tiṣṭhan bhinnadēśanivāsināṁ| stuvaṁstvāṁ parigāsyāmi tava nāmni parēśvara|| ");
INSERT INTO saniso_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","aparamapi likhitam āstē, hē anyajātayō yūyaṁ samaṁ nandata tajjanaiḥ| ");
INSERT INTO saniso_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","punaśca likhitam āstē, hē sarvvadēśinō yūyaṁ dhanyaṁ brūta parēśvaraṁ| hē tadīyanarā yūyaṁ kurudhvaṁ tatpraśaṁsanaṁ|| ");
INSERT INTO saniso_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","apara yīśāyiyō'pi lilēkha, yīśayasya tu yat mūlaṁ tat prakāśiṣyatē tadā| sarvvajātīyanr̥ṇāñca śāsakaḥ samudēṣyati| tatrānyadēśilōkaiśca pratyāśā prakariṣyatē|| ");
INSERT INTO saniso_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","ataēva yūyaṁ pavitrasyātmanaḥ prabhāvād yat sampūrṇāṁ pratyāśāṁ lapsyadhvē tadarthaṁ tatpratyāśājanaka īśvaraḥ pratyayēna yuṣmān śāntyānandābhyāṁ sampūrṇān karōtu| ");
INSERT INTO saniso_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","hē bhrātarō yūyaṁ sadbhāvayuktāḥ sarvvaprakārēṇa jñānēna ca sampūrṇāḥ parasparōpadēśē ca tatparā ityahaṁ niścitaṁ jānāmi, ");
INSERT INTO saniso_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","tathāpyahaṁ yat pragalbhatarō bhavan yuṣmān prabōdhayāmi tasyaikaṁ kāraṇamidaṁ| ");
INSERT INTO saniso_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","bhinnajātīyāḥ pavitrēṇātmanā pāvitanaivēdyarūpā bhūtvā yad grāhyā bhavēyustannimittamaham īśvarasya susaṁvādaṁ pracārayituṁ bhinnajātīyānāṁ madhyē yīśukhrīṣṭasya sēvakatvaṁ dānaṁ īśvarāt labdhavānasmi| ");
INSERT INTO saniso_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","īśvaraṁ prati yīśukhrīṣṭēna mama ślāghākaraṇasya kāraṇam āstē| ");
INSERT INTO saniso_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","bhinnadēśina ājñāgrāhiṇaḥ karttuṁ khrīṣṭō vākyēna kriyayā ca, āścaryyalakṣaṇaiścitrakriyābhiḥ pavitrasyātmanaḥ prabhāvēna ca yāni karmmāṇi mayā sādhitavān, ");
INSERT INTO saniso_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","kēvalaṁ tānyēva vinānyasya kasyacit karmmaṇō varṇanāṁ karttuṁ pragalbhō na bhavāmi| tasmāt ā yirūśālama illūrikaṁ yāvat sarvvatra khrīṣṭasya susaṁvādaṁ prācārayaṁ| ");
INSERT INTO saniso_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","anyēna nicitāyāṁ bhittāvahaṁ yanna nicinōmi tannimittaṁ yatra yatra sthānē khrīṣṭasya nāma kadāpi kēnāpi na jñāpitaṁ tatra tatra susaṁvādaṁ pracārayitum ahaṁ yatē| ");
INSERT INTO saniso_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","yādr̥śaṁ likhitam āstē, yai rvārttā tasya na prāptā darśanaṁ taistu lapsyatē| yaiśca naiva śrutaṁ kiñcit bōddhuṁ śakṣyanti tē janāḥ|| ");
INSERT INTO saniso_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","tasmād yuṣmatsamīpagamanād ahaṁ muhurmuhu rnivāritō'bhavaṁ| ");
INSERT INTO saniso_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","kintvidānīm atra pradēśēṣu mayā na gataṁ sthānaṁ kimapi nāvaśiṣyatē yuṣmatsamīpaṁ gantuṁ bahuvatsarānārabhya māmakīnākāṅkṣā ca vidyata iti hētōḥ ");
INSERT INTO saniso_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","spāniyādēśagamanakālē'haṁ yuṣmanmadhyēna gacchan yuṣmān ālōkiṣyē, tataḥ paraṁ yuṣmatsambhāṣaṇēna tr̥ptiṁ parilabhya taddēśagamanārthaṁ yuṣmābhi rvisarjayiṣyē, īdr̥śī madīyā pratyāśā vidyatē| ");
INSERT INTO saniso_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","kintu sāmprataṁ pavitralōkānāṁ sēvanāya yirūśālamnagaraṁ vrajāmi| ");
INSERT INTO saniso_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","yatō yirūśālamasthapavitralōkānāṁ madhyē yē daridrā arthaviśrāṇanēna tānupakarttuṁ mākidaniyādēśīyā ākhāyādēśīyāśca lōkā aicchan| ");
INSERT INTO saniso_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","ēṣā tēṣāṁ sadicchā yatastē tēṣām r̥ṇinaḥ santi yatō hētō rbhinnajātīyā yēṣāṁ paramārthasyāṁśinō jātā aihikaviṣayē tēṣāmupakārastaiḥ karttavyaḥ| ");
INSERT INTO saniso_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","atō mayā tat karmma sādhayitvā tasmin phalē tēbhyaḥ samarpitē yuṣmanmadhyēna spāniyādēśō gamiṣyatē| ");
INSERT INTO saniso_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","yuṣmatsamīpē mamāgamanasamayē khrīṣṭasya susaṁvādasya pūrṇavarēṇa sambalitaḥ san aham āgamiṣyāmi iti mayā jñāyatē| ");
INSERT INTO saniso_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","hē bhrātr̥gaṇa prabhō ryīśukhrīṣṭasya nāmnā pavitrasyātmānaḥ prēmnā ca vinayē'haṁ ");
INSERT INTO saniso_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","yihūdādēśasthānām aviśvāsilōkānāṁ karēbhyō yadahaṁ rakṣāṁ labhēya madīyaitēna sēvanakarmmaṇā ca yad yirūśālamasthāḥ pavitralōkāstuṣyēyuḥ, ");
INSERT INTO saniso_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","tadarthaṁ yūyaṁ matkr̥ta īśvarāya prārthayamāṇā yatadhvaṁ tēnāham īśvarēcchayā sānandaṁ yuṣmatsamīpaṁ gatvā yuṣmābhiḥ sahitaḥ prāṇān āpyāyituṁ pārayiṣyāmi| ");
INSERT INTO saniso_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","śāntidāyaka īśvarō yuṣmākaṁ sarvvēṣāṁ saṅgī bhūyāt| iti| ");
INSERT INTO saniso_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","kiṁkrīyānagarīyadharmmasamājasya paricārikā yā phaibīnāmikāsmākaṁ dharmmabhaginī tasyāḥ kr̥tē'haṁ yuṣmān nivēdayāmi, ");
INSERT INTO saniso_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","yūyaṁ tāṁ prabhumāśritāṁ vijñāya tasyā ātithyaṁ pavitralōkārhaṁ kurudhvaṁ, yuṣmattastasyā ya upakārō bhavituṁ śaknōti taṁ kurudhvaṁ, yasmāt tayā bahūnāṁ mama cōpakāraḥ kr̥taḥ| ");
INSERT INTO saniso_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","aparañca khrīṣṭasya yīśōḥ karmmaṇi mama sahakāriṇau mama prāṇarakṣārthañca svaprāṇān paṇīkr̥tavantau yau priṣkillākkilau tau mama namaskāraṁ jñāpayadhvaṁ| ");
INSERT INTO saniso_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","tābhyām upakārāptiḥ kēvalaṁ mayā svīkarttavyēti nahi bhinnadēśīyaiḥ sarvvadh