﻿USE sofia;
DROP TABLE IF EXISTS sofia.sanias_vpl;
CREATE TABLE sanias_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sanias_vpl WRITE;
INSERT INTO sanias_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ibrāhīmaḥ santāno dāyūd tasya santāno yīśukhrīṣṭastasya pūrvvapuruṣavaṁśaśreṇī| ");
INSERT INTO sanias_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ibrāhīmaḥ putra ishāk tasya putro yākūb tasya putro yihūdāstasya bhrātaraśca| ");
INSERT INTO sanias_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","tasmād yihūdātastāmaro garbhe perasserahau jajñāte, tasya perasaḥ putro hiṣroṇ tasya putro 'rām| ");
INSERT INTO sanias_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","tasya putro 'mmīnādab tasya putro nahaśon tasya putraḥ salmon| ");
INSERT INTO sanias_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","tasmād rāhabo garbhe boyam jajñe, tasmād rūto garbhe obed jajñe, tasya putro yiśayaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","tasya putro dāyūd rājaḥ tasmād mṛtoriyasya jāyāyāṁ sulemān jajñe| ");
INSERT INTO sanias_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","tasya putro rihabiyām, tasya putro'biyaḥ, tasya putra āsā:| ");
INSERT INTO sanias_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","tasya suto yihośāphaṭ tasya suto yihorāma tasya suta uṣiyaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","tasya suto yotham tasya suta āham tasya suto hiṣkiyaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","tasya suto minaśiḥ, tasya suta āmon tasya suto yośiyaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","bābilnagare pravasanāt pūrvvaṁ sa yośiyo yikhaniyaṁ tasya bhrātṛṁśca janayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","tato bābili pravasanakāle yikhaniyaḥ śaltīyelaṁ janayāmāsa, tasya sutaḥ sirubbāvil| ");
INSERT INTO sanias_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","tasya suto 'bohud tasya suta ilīyākīm tasya suto'sor| ");
INSERT INTO sanias_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","asoraḥ sutaḥ sādok tasya suta ākhīm tasya suta ilīhūd| ");
INSERT INTO sanias_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","tasya suta iliyāsar tasya suto mattan| ");
INSERT INTO sanias_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","tasya suto yākūb tasya suto yūṣaph tasya jāyā mariyam; tasya garbhe yīśurajani, tameva khrīṣṭam (arthād abhiṣiktaṁ) vadanti| ");
INSERT INTO sanias_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ittham ibrāhīmo dāyūdaṁ yāvat sākalyena caturdaśapuruṣāḥ; ā dāyūdaḥ kālād bābili pravasanakālaṁ yāvat caturdaśapuruṣā bhavanti| bābili pravāsanakālāt khrīṣṭasya kālaṁ yāvat caturdaśapuruṣā bhavanti| ");
INSERT INTO sanias_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","yīśukhrīṣṭasya janma kaththate| mariyam nāmikā kanyā yūṣaphe vāgdattāsīt, tadā tayoḥ saṅgamāt prāk sā kanyā  pavitreṇātmanā garbhavatī babhūva| ");
INSERT INTO sanias_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","tatra tasyāḥ pati ryūṣaph saujanyāt tasyāḥ kalaṅgaṁ prakāśayitum anicchan gopanene tāṁ pārityaktuṁ manaścakre| ");
INSERT INTO sanias_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","sa tathaiva bhāvayati, tadānīṁ parameśvarasya dūtaḥ svapne taṁ darśanaṁ dattvā vyājahāra, he dāyūdaḥ santāna yūṣaph tvaṁ nijāṁ jāyāṁ mariyamam ādātuṁ mā bhaiṣīḥ| ");
INSERT INTO sanias_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","yatastasyā garbhaḥ pavitrādātmano'bhavat, sā ca putraṁ prasaviṣyate, tadā tvaṁ tasya nāma yīśum (arthāt trātāraṁ) karīṣyase, yasmāt sa nijamanujān teṣāṁ kaluṣebhya uddhariṣyati| ");
INSERT INTO sanias_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","itthaṁ sati, paśya garbhavatī kanyā tanayaṁ prasaviṣyate| immānūyel tadīyañca nāmadheyaṁ bhaviṣyati|| immānūyel asmākaṁ saṅgīśvara̮ityarthaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","iti yad vacanaṁ purvvaṁ bhaviṣyadvaktrā īśvaraḥ kathāyāmāsa, tat tadānīṁ siddhamabhavat| ");
INSERT INTO sanias_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","anantaraṁ yūṣaph nidrāto jāgarita utthāya parameśvarīyadūtasya nideśānusāreṇa nijāṁ jāyāṁ jagrāha, ");
INSERT INTO sanias_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","kintu yāvat sā nijaṁ prathamasutaṁ a suṣuve, tāvat tāṁ nopāgacchat, tataḥ sutasya nāma yīśuṁ cakre| ");
INSERT INTO sanias_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","anantaraṁ herod saṁjñake rājñi rājyaṁ śāsati yihūdīyadeśasya baitlehami nagare yīśau jātavati ca, katipayā jyotirvvudaḥ pūrvvasyā diśo yirūśālamnagaraṁ sametya kathayamāsuḥ, ");
INSERT INTO sanias_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","yo yihūdīyānāṁ rājā jātavān, sa kutrāste? vayaṁ pūrvvasyāṁ diśi tiṣṭhantastadīyāṁ tārakām apaśyāma tasmāt taṁ praṇantum aाgamāma| ");
INSERT INTO sanias_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","tadā herod rājā kathāmetāṁ niśamya yirūśālamnagarasthitaiḥ sarvvamānavaiḥ sārddham udvijya ");
INSERT INTO sanias_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","sarvvān pradhānayājakān adhyāpakāṁśca samāhūyānīya papraccha, khrīṣṭaḥ kutra janiṣyate? ");
INSERT INTO sanias_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","tadā te kathayāmāsuḥ, yihūdīyadeśasya baitlehami nagare, yato bhaviṣyadvādinā itthaṁ likhitamāste, ");
INSERT INTO sanias_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","sarvvābhyo rājadhānībhyo yihūdīyasya nīvṛtaḥ| he yīhūdīyadeśasye baitleham tvaṁ na cāvarā|isrāyelīyalokān me yato yaḥ pālayiṣyati| tādṛgeko mahārājastvanmadhya udbhaviṣyatī|| ");
INSERT INTO sanias_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","tadānīṁ herod rājā tān jyotirvvido gopanam āhūya sā tārakā kadā dṛṣṭābhavat , tad viniścayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","aparaṁ tān baitlehamaṁ prahītya gaditavān, yūyaṁ yāta, yatnāt taṁ śiśum anviṣya taduddeśe prāpte mahyaṁ vārttāṁ dāsyatha, tato mayāpi gatvā sa praṇaṁsyate| ");
INSERT INTO sanias_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","tadānīṁ rājña etādṛśīm ājñāṁ prāpya te pratasthire, tataḥ pūrvvarsyāṁ diśi sthitaistai ryā tārakā dṛṣṭā sā tārakā teṣāmagre gatvā yatra sthāne śiśūrāste, tasya sthānasyopari sthagitā tasyau| ");
INSERT INTO sanias_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","tad dṛṣṭvā te mahānanditā babhūvuḥ, ");
INSERT INTO sanias_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","tato gehamadhya praviśya tasya mātrā mariyamā sāddhaṁ taṁ śiśuṁ nirīkṣaya daṇḍavad bhūtvā praṇemuḥ, aparaṁ sveṣāṁ ghanasampattiṁ mocayitvā suvarṇaṁ kunduruṁ gandharamañca tasmai darśanīyaṁ dattavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","paścād herod rājasya samīpaṁ punarapi gantuṁ svapna īśvareṇa niṣiddhāḥ santo 'nyena pathā te nijadeśaṁ prati pratasthire| ");
INSERT INTO sanias_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","anantaraṁ teṣu gatavatmu parameśvarasya dūto yūṣaphe svapne darśanaṁ datvā jagāda, tvam utthāya śiśuṁ tanmātarañca gṛhītvā misardeśaṁ palāyasva, aparaṁ yāvadahaṁ tubhyaṁ vārttāṁ na kathayiṣyāmi, tāvat tatraiva nivasa, yato rājā herod śiśuṁ nāśayituṁ mṛgayiṣyate| ");
INSERT INTO sanias_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","tadānīṁ yūṣaph utthāya rajanyāṁ śiśuṁ tanmātarañca gṛhītvā misardeśaṁ prati pratasthe, ");
INSERT INTO sanias_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","gatvā ca herodo nṛpate rmaraṇaparyyantaṁ tatra deśe nyuvāsa, tena misardeśādahaṁ putraṁ svakīyaṁ samupāhūyam| yadetadvacanam īśvareṇa bhaviṣyadvādinā kathitaṁ tat saphalamabhūt| ");
INSERT INTO sanias_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","anantaraṁ herod jyotirvidbhirātmānaṁ pravañcitaṁ vijñāya bhṛśaṁ cukopa; aparaṁ jyotirvvidbhyastena viniścitaṁ yad dinaṁ taddinād gaṇayitvā dvitīyavatsaraṁ praviṣṭā yāvanto bālakā asmin baitlehamnagare tatsīmamadhye cāsan, lokān prahitya tān sarvvān ghātayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ataḥ anekasya vilāpasya nināda: krandanasya ca| śokena kṛtaśabdaśca rāmāyāṁ saṁniśamyate| svabālagaṇahetorvai rāhel nārī tu rodinī| na manyate prabodhantu yataste naiva manti hi|| ");
INSERT INTO sanias_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","yadetad vacanaṁ yirīmiyanāmakabhaviṣyadvādinā kathitaṁ tat tadānīṁ saphalam abhūt| ");
INSERT INTO sanias_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","tadanantaraṁ heredi rājani mṛte parameśvarasya dūto misardeśe svapne darśanaṁ dattvā yūṣaphe kathitavān ");
INSERT INTO sanias_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","tvam utthāya śiśuṁ tanmātarañca gṛhītvā punarapīsrāyelo deśaṁ yāhī, ye janāḥ śiśuṁ nāśayitum amṛgayanta, te mṛtavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","tadānīṁ sa utthāya śiśuṁ tanmātarañca gṛhlan isrāyeldeśam ājagāma| ");
INSERT INTO sanias_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","kintu yihūdīyadeśe arkhilāyanāma rājakumāro nijapitu rherodaḥ padaṁ prāpya rājatvaṁ karotīti niśamya tat sthānaṁ yātuṁ śaṅkitavān, paścāt svapna īśvarāt prabodhaṁ prāpya gālīldeśasya pradeśaikaṁ prasthāya nāsarannāma nagaraṁ gatvā tatra nyuṣitavān, ");
INSERT INTO sanias_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","tena taṁ nāsaratīyaṁ kathayiṣyanti, yadetadvākyaṁ bhaviṣyadvādibhirukttaṁ tat saphalamabhavat| ");
INSERT INTO sanias_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","tadānoṁ yohnnāmā majjayitā yihūdīyadeśasya prāntaram upasthāya pracārayan kathayāmāsa, ");
INSERT INTO sanias_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","manāṁsi parāvarttayata, svargīyarājatvaṁ samīpamāgatam| ");
INSERT INTO sanias_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","parameśasya panthānaṁ pariṣkuruta sarvvataḥ| tasya rājapathāṁścaiva samīkuruta sarvvathā| ityetat prāntare vākyaṁ vadataḥ kasyacid ravaḥ|| ");
INSERT INTO sanias_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","etadvacanaṁ yiśayiyabhaviṣyadvādinā yohanamuddiśya bhāṣitam| yohano vasanaṁ mahāṅgaromajaṁ tasya kaṭau carmmakaṭibandhanaṁ; sa ca śūkakīṭān madhu ca bhuktavān| ");
INSERT INTO sanias_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","tadānīṁ yirūśālamnagaranivāsinaḥ sarvve yihūdideśīyā yarddantaṭinyā ubhayataṭasthāśca mānavā bahirāgatya tasya samīpe ");
INSERT INTO sanias_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","svīyaṁ svīyaṁ duritam aṅgīkṛtya tasyāṁ yarddani tena majjitā babhūvuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","aparaṁ bahūn phirūśinaḥ sidūkinaśca manujān maṁktuṁ svasamīpam āgacchto vilokya sa tān abhidadhau, re re bhujagavaṁśā āgāmīnaḥ kopāt palāyituṁ yuṣmān kaścetitavān? ");
INSERT INTO sanias_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","manaḥparāvarttanasya samucitaṁ phalaṁ phalata| ");
INSERT INTO sanias_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","kintvasmākaṁ tāta ibrāhīm astīti sveṣu manaḥsu cīntayanto mā vyāharata| yato yuṣmān ahaṁ vadāmi, īśvara etebhyaḥ pāṣāṇebhya ibrāhīmaḥ santānān utpādayituṁ śaknoti| ");
INSERT INTO sanias_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","aparaṁ pādapānāṁ mūle kuṭhāra idānīmapi lagan āste, tasmād yasmin pādape uttamaṁ phalaṁ na bhavati, sa kṛtto madhye'gniṁ nikṣepsyate| ");
INSERT INTO sanias_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","aparam ahaṁ manaḥparāvarttanasūcakena majjanena yuṣmān majjayāmīti satyaṁ, kintu mama paścād ya āgacchati, sa mattopi mahān, ahaṁ tadīyopānahau voḍhumapi nahi yogyosmi, sa yuṣmān vahnirūpe pavitra ātmani saṁmajjayiṣyati| ");
INSERT INTO sanias_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","tasya kāre sūrpa āste, sa svīyaśasyāni samyak prasphoṭya nijān sakalagodhūmān saṁgṛhya bhāṇḍāgāre sthāpayiṣyati, kiṁntu sarvvāṇi vuṣāṇyanirvvāṇavahninā dāhayiṣyati| ");
INSERT INTO sanias_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","anantaraṁ yīśu ryohanā majjito bhavituṁ gālīlpradeśād yarddani tasya samīpam ājagāma| ");
INSERT INTO sanias_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","kintu yohan taṁ niṣidhya babhāṣe, tvaṁ kiṁ mama samīpam āgacchasi? varaṁ tvayā majjanaṁ mama prayojanam āste| ");
INSERT INTO sanias_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","tadānīṁ yīśuḥ pratyavocat; īdānīm anumanyasva, yata itthaṁ sarvvadharmmasādhanam asmākaṁ karttavyaṁ, tataḥ so'nvamanyata| ");
INSERT INTO sanias_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","anantaraṁ yīśurammasi majjituḥ san tatkṣaṇāt toyamadhyād utthāya jagāma, tadā jīmūtadvāre mukte jāte, sa īśvarasyātmānaṁ kapotavad avaruhya svoparyyāgacchantaṁ vīkṣāñcakre| ");
INSERT INTO sanias_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","aparam eṣa mama priyaḥ putra etasminneva mama mahāsantoṣa etādṛśī vyomajā vāg babhūva| ");
INSERT INTO sanias_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","tataḥ paraṁ yīśuḥ pratārakeṇa parīkṣito bhavitum ātmanā prāntaram ākṛṣṭaḥ ");
INSERT INTO sanias_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","san catvāriṁśadahorātrān anāhārastiṣṭhan kṣudhito babhūva| ");
INSERT INTO sanias_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","tadānīṁ parīkṣitā tatsamīpam āgatya vyāhṛtavān, yadi tvamīśvarātmajo bhavestarhyājñayā pāṣāṇānetān pūpān vidhehi| ");
INSERT INTO sanias_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","tataḥ sa pratyabravīt, itthaṁ likhitamāste, \"manujaḥ kevalapūpena na jīviṣyati, kintvīśvarasya vadanād yāni yāni vacāṁsi niḥsaranti taireva jīviṣyati|\" ");
INSERT INTO sanias_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","tadā pratārakastaṁ puṇyanagaraṁ nītvā mandirasya cūḍopari nidhāya gaditavān, ");
INSERT INTO sanias_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","tvaṁ yadiśvarasya tanayo bhavestarhīto'dhaḥ pata, yata itthaṁ likhitamāste, ādekṣyati nijān dūtān rakṣituṁ tvāṁ parameśvaraḥ| yathā sarvveṣu mārgeṣu tvadīyacaraṇadvaye| na laget prastarāghātastvāṁ ghariṣyanti te karaiḥ|| ");
INSERT INTO sanias_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","tadānīṁ yīśustasmai kathitavān etadapi likhitamāste, \"tvaṁ nijaprabhuṁ parameśvaraṁ mā parīkṣasva|\" ");
INSERT INTO sanias_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","anantaraṁ pratārakaḥ punarapi tam atyuñcadharādharopari nītvā jagataḥ sakalarājyāni tadaiśvaryyāṇi ca darśayāścakāra kathayāñcakāra ca, ");
INSERT INTO sanias_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","yadi tvaṁ daṇḍavad bhavan māṁ praṇamestarhyaham etāni tubhyaṁ pradāsyāmi| ");
INSERT INTO sanias_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","tadānīṁ yīśustamavocat, dūrībhava pratāraka, likhitamidam āste, \"tvayā nijaḥ prabhuḥ parameśvaraḥ praṇamyaḥ kevalaḥ sa sevyaśca|\" ");
INSERT INTO sanias_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","tataḥ pratārakeṇa sa paryyatyāji, tadā svargīyadūtairāgatya sa siṣeve| ");
INSERT INTO sanias_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","tadanantaraṁ yohan kārāyāṁ babandhe, tadvārttāṁ niśamya yīśunā gālīl prāsthīyata| ");
INSERT INTO sanias_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","tataḥ paraṁ sa nāsarannagaraṁ vihāya jalaghestaṭe sibūlūnnaptālī etayoruvabhayoḥ pradeśayoḥ sīmnormadhyavarttī ya: kapharnāhūm tannagaram itvā nyavasat| ");
INSERT INTO sanias_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","tasmāt, anyādeśīyagālīli yarddanpāre'bdhirodhasi| naptālisibūlūndeśau yatra sthāne sthitau purā| ");
INSERT INTO sanias_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","tatratyā manujā ye ye paryyabhrāmyan tamisrake| tairjanairbṛhadālokaḥ paridarśiṣyate tadā| avasan ye janā deśe mṛtyucchāyāsvarūpake| teṣāmupari lokānāmālokaḥ saṁprakāśitaḥ|| ");
INSERT INTO sanias_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","yadetadvacanaṁ yiśayiyabhaviṣyadvādinā proktaṁ, tat tadā saphalam abhūt| ");
INSERT INTO sanias_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","anantaraṁ yīśuḥ susaṁvādaṁ pracārayan etāṁ kathāṁ kathayitum ārebhe, manāṁsi parāvarttayata, svargīyarājatvaṁ savidhamabhavat| ");
INSERT INTO sanias_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","tataḥ paraṁ yīśu rgālīlo jaladhestaṭena gacchan gacchan āndriyastasya bhrātā śimon arthato yaṁ pitaraṁ vadanti etāvubhau jalaghau jālaṁ kṣipantau dadarśa, yatastau mīnadhāriṇāvāstām| ");
INSERT INTO sanias_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","tadā sa tāvāhūya vyājahāra, yuvāṁ mama paścād āgacchataṁ, yuvāmahaṁ manujadhāriṇau kariṣyāmi| ");
INSERT INTO sanias_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","tenaiva tau jālaṁ vihāya tasya paścāt āgacchatām| ");
INSERT INTO sanias_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","anantaraṁ tasmāt sthānāt vrajan vrajan sivadiyasya sutau yākūb yohannāmānau dvau sahajau tātena sārddhaṁ naukopari jālasya jīrṇoddhāraṁ kurvvantau vīkṣya tāvāhūtavān| ");
INSERT INTO sanias_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","tatkṣaṇāt tau nāvaṁ svatātañca vihāya tasya paścādgāminau babhūvatuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","anantaraṁ bhajanabhavane samupadiśan rājyasya susaṁvādaṁ pracārayan manujānāṁ sarvvaprakārān rogān sarvvaprakārapīḍāśca śamayan yīśuḥ kṛtsnaṁ gālīldeśaṁ bhramitum ārabhata| ");
INSERT INTO sanias_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","tena kṛtsnasuriyādeśasya madhyaṁ tasya yaśo vyāpnot, aparaṁ bhūtagrastā apasmārargīṇaḥ pakṣādhātiprabhṛtayaśca yāvanto manujā nānāvidhavyādhibhiḥ kliṣṭā āsan, teṣu sarvveṣu tasya samīpam ānīteṣu sa tān svasthān cakāra| ");
INSERT INTO sanias_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","etena gālīl-dikāpani-yirūśālam-yihūdīyadeśebhyo yarddanaḥ pārāñca bahavo manujāstasya paścād āgacchan| ");
INSERT INTO sanias_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","anantaraṁ sa jananivahaṁ nirīkṣya bhūdharopari vrajitvā samupaviveśa| ");
INSERT INTO sanias_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","tadānīṁ śiṣyeṣu tasya samīpamāgateṣu tena tebhya eṣā kathā kathyāñcakre| ");
INSERT INTO sanias_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","abhimānahīnā janā dhanyāḥ, yataste svargīyarājyam adhikariṣyanti| ");
INSERT INTO sanias_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","khidyamānā manujā dhanyāḥ, yasmāt te sāntvanāṁ prāpsanti| ");
INSERT INTO sanias_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","namrā mānavāśca dhanyāḥ, yasmāt te medinīm adhikariṣyanti| ");
INSERT INTO sanias_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","dharmmāya bubhukṣitāḥ tṛṣārttāśca manujā dhanyāḥ, yasmāt te paritarpsyanti| ");
INSERT INTO sanias_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","kṛpālavo mānavā dhanyāḥ, yasmāt te kṛpāṁ prāpsyanti| ");
INSERT INTO sanias_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","nirmmalahṛdayā manujāśca dhanyāḥ, yasmāt ta īścaraṁ drakṣyanti| ");
INSERT INTO sanias_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","melayitāro mānavā dhanyāḥ, yasmāt ta īścarasya santānatvena vikhyāsyanti| ");
INSERT INTO sanias_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","dharmmakāraṇāt tāḍitā manujā dhanyā, yasmāt svargīyarājye teṣāmadhikaro vidyate| ");
INSERT INTO sanias_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","yadā manujā mama nāmakṛte yuṣmān nindanti tāḍayanti mṛṣā nānādurvvākyāni vadanti ca, tadā yuyaṁ dhanyāḥ| ");
INSERT INTO sanias_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","tadā ānandata, tathā bhṛśaṁ hlādadhvañca, yataḥ svarge bhūyāṁsi phalāni lapsyadhve; te yuṣmākaṁ purātanān bhaviṣyadvādino'pi tādṛg atāḍayan| ");
INSERT INTO sanias_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","yuyaṁ medinyāṁ lavaṇarūpāḥ, kintu yadi lavaṇasya lavaṇatvam apayāti, tarhi tat kena prakāreṇa svāduyuktaṁ bhaviṣyati? tat kasyāpi kāryyasyāyogyatvāt kevalaṁ bahiḥ prakṣeptuṁ narāṇāṁ padatalena dalayituñca yogyaṁ bhavati| ");
INSERT INTO sanias_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","yūyaṁ jagati dīptirūpāḥ, bhūdharopari sthitaṁ nagaraṁ guptaṁ bhavituṁ nahi śakṣyati| ");
INSERT INTO sanias_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","aparaṁ manujāḥ pradīpān prajvālya droṇādho na sthāpayanti, kintu dīpādhāroparyyeva sthāpayanti, tena te dīpā gehasthitān sakalān prakāśayanti| ");
INSERT INTO sanias_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","yena mānavā yuṣmākaṁ satkarmmāṇi vilokya yuṣmākaṁ svargasthaṁ pitaraṁ dhanyaṁ vadanti, teṣāṁ samakṣaṁ yuṣmākaṁ dīptistādṛk prakāśatām| ");
INSERT INTO sanias_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","ahaṁ vyavasthāṁ bhaviṣyadvākyañca loptum āgatavān, itthaṁ mānubhavata, te dve loptuṁ nāgatavān, kintu saphale karttum āgatosmi| ");
INSERT INTO sanias_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","aparaṁ yuṣmān ahaṁ tathyaṁ vadāmi yāvat vyomamedinyo rdhvaṁso na bhaviṣyati, tāvat sarvvasmin saphale na jāte vyavasthāyā ekā mātrā bindurekopi vā na lopsyate| ");
INSERT INTO sanias_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","tasmāt yo jana etāsām ājñānām atikṣudrām ekājñāmapī laṁghate manujāṁñca tathaiva śikṣayati, sa svargīyarājye sarvvebhyaḥ kṣudratvena vikhyāsyate, kintu yo janastāṁ pālayati, tathaiva śikṣayati ca, sa svargīyarājye pradhānatvena vikhyāsyate| ");
INSERT INTO sanias_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","aparaṁ yuṣmān ahaṁ vadāmi, adhyāpakaphirūśimānavānāṁ dharmmānuṣṭhānāt yuṣmākaṁ dharmmānuṣṭhāne nottame jāte yūyam īśvarīyarājyaṁ praveṣṭuṁ na śakṣyatha| ");
INSERT INTO sanias_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","aparañca tvaṁ naraṁ mā vadhīḥ, yasmāt yo naraṁ hanti, sa vicārasabhāyāṁ daṇḍārho bhaviṣyati, pūrvvakālīnajanebhya iti kathitamāsīt, yuṣmābhiraśrāvi| ");
INSERT INTO sanias_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","kintvahaṁ yuṣmān vadāmi, yaḥ kaścit kāraṇaṁ vinā nijabhrātre kupyati, sa vicārasabhāyāṁ daṇḍārho bhaviṣyati; yaḥ kaścicca svīyasahajaṁ nirbbodhaṁ vadati, sa mahāsabhāyāṁ daṇḍārho bhaviṣyati; punaśca tvaṁ mūḍha iti vākyaṁ yadi kaścit svīyabhrātaraṁ vakti, tarhi narakāgnau sa daṇḍārho bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","ato vedyāḥ samīpaṁ nijanaivedye samānīte'pi nijabhrātaraṁ prati kasmāccit kāraṇāt tvaṁ yadi doṣī vidyase, tadānīṁ tava tasya smṛti rjāyate ca, ");
INSERT INTO sanias_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tarhi tasyā vedyāḥ samīpe nijanaivaidyaṁ nidhāya tadaiva gatvā pūrvvaṁ tena sārddhaṁ mila, paścāt āgatya nijanaivedyaṁ nivedaya| ");
INSERT INTO sanias_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","anyañca yāvat vivādinā sārddhaṁ vartmani tiṣṭhasi, tāvat tena sārddhaṁ melanaṁ kuru; no cet vivādī vicārayituḥ samīpe tvāṁ samarpayati vicārayitā ca rakṣiṇaḥ sannidhau samarpayati tadā tvaṁ kārāyāṁ badhyethāḥ| ");
INSERT INTO sanias_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","tarhi tvāmahaṁ taththaṁ bravīmi, śeṣakapardake'pi na pariśodhite tasmāt sthānāt kadāpi bahirāgantuṁ na śakṣyasi| ");
INSERT INTO sanias_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","aparaṁ tvaṁ mā vyabhicara, yadetad vacanaṁ pūrvvakālīnalokebhyaḥ kathitamāsīt, tad yūyaṁ śrutavantaḥ; ");
INSERT INTO sanias_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","kintvahaṁ yuṣmān vadāmi, yadi kaścit kāmataḥ kāñcana yoṣitaṁ paśyati, tarhi sa manasā tadaiva vyabhicaritavān| ");
INSERT INTO sanias_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","tasmāt tava dakṣiṇaṁ netraṁ yadi tvāṁ bādhate, tarhi tannetram utpāṭya dūre nikṣipa, yasmāt tava sarvvavapuṣo narake nikṣepāt tavaikāṅgasya nāśo varaṁ| ");
INSERT INTO sanias_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","yadvā tava dakṣiṇaḥ karo yadi tvāṁ bādhate, tarhi taṁ karaṁ chittvā dūre nikṣipa, yataḥ sarvvavapuṣo narake nikṣepāt ekāṅgasya nāśo varaṁ| ");
INSERT INTO sanias_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","uktamāste, yadi kaścin nijajāyāṁ parityakttum icchati, tarhi sa tasyai tyāgapatraṁ dadātu| ");
INSERT INTO sanias_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","kintvahaṁ yuṣmān vyāharāmi, vyabhicāradoṣe na jāte yadi kaścin nijajāyāṁ parityajati, tarhi sa tāṁ vyabhicārayati; yaśca tāṁ tyaktāṁ striyaṁ vivahati, sopi vyabhicarati| ");
INSERT INTO sanias_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","punaśca tvaṁ mṛṣā śapatham na kurvvan īścarāya nijaśapathaṁ pālaya, pūrvvakālīnalokebhyo yaiṣā kathā kathitā, tāmapi yūyaṁ śrutavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","kintvahaṁ yuṣmān vadāmi, kamapi śapathaṁ mā kārṣṭa, arthataḥ svarganāmnā na, yataḥ sa īśvarasya siṁhāsanaṁ; ");
INSERT INTO sanias_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","pṛthivyā nāmnāpi na, yataḥ sā tasya pādapīṭhaṁ; yirūśālamo nāmnāpi na, yataḥ sā mahārājasya purī; ");
INSERT INTO sanias_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","nijaśironāmnāpi na, yasmāt tasyaikaṁ kacamapi sitam asitaṁ vā karttuṁ tvayā na śakyate| ");
INSERT INTO sanias_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","aparaṁ yūyaṁ saṁlāpasamaye kevalaṁ bhavatīti na bhavatīti ca vadata yata ito'dhikaṁ yat tat pāpātmano jāyate| ");
INSERT INTO sanias_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","aparaṁ locanasya vinimayena locanaṁ dantasya vinimayena dantaḥ pūrvvaktamidaṁ vacanañca yuṣmābhiraśrūyata| ");
INSERT INTO sanias_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","kintvahaṁ yuṣmān vadāmi yūyaṁ hiṁsakaṁ naraṁ mā vyāghātayata| kintu kenacit tava dakṣiṇakapole capeṭāghāte kṛte taṁ prati vāmaṁ kapolañca vyāghoṭaya| ");
INSERT INTO sanias_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","aparaṁ kenacit tvayā sārdhdaṁ vivādaṁ kṛtvā tava paridheyavasane jighṛtite tasmāyuttarīyavasanamapi dehi| ");
INSERT INTO sanias_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","yadi kaścit tvāṁ krośamekaṁ nayanārthaṁ anyāyato dharati, tadā tena sārdhdaṁ krośadvayaṁ yāhi| ");
INSERT INTO sanias_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","yaśca mānavastvāṁ yācate, tasmai dehi, yadi kaścit tubhyaṁ dhārayitum icchati, tarhi taṁ prati parāṁmukho mā bhūḥ| ");
INSERT INTO sanias_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","nijasamīpavasini prema kuru, kintu śatruṁ prati dveṣaṁ kuru, yadetat puroktaṁ vacanaṁ etadapi yūyaṁ śrutavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","kintvahaṁ yuṣmān vadāmi, yūyaṁ ripuvvapi prema kuruta, ye ca yuṣmān śapante, tāna, āśiṣaṁ vadata, ye ca yuṣmān ṛृtīyante, teṣāṁ maṅgalaṁ kuruta, ye ca yuṣmān nindanti, tāḍayanti ca, teṣāṁ kṛte prārthayadhvaṁ| ");
INSERT INTO sanias_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","tatra yaḥ satāmasatāñcopari prabhākaram udāyayati, tathā dhārmmikānāmadhārmmikānāñcopari nīraṁ varṣayati tādṛśo yo yuṣmākaṁ svargasthaḥ pitā, yūyaṁ tasyaiva santānā bhaviṣyatha| ");
INSERT INTO sanias_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ye yuṣmāsu prema kurvvanti, yūyaṁ yadi kevalaṁ tevveva prema kurutha, tarhi yuṣmākaṁ kiṁ phalaṁ bhaviṣyati? caṇḍālā api tādṛśaṁ kiṁ na kurvvanti? ");
INSERT INTO sanias_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","aparaṁ yūyaṁ yadi kevalaṁ svīyabhrātṛtvena namata, tarhi kiṁ mahat karmma kurutha? caṇḍālā api tādṛśaṁ kiṁ na kurvvanti? ");
INSERT INTO sanias_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","tasmāt yuṣmākaṁ svargasthaḥ pitā yathā pūrṇo bhavati, yūyamapi tādṛśā bhavata| ");
INSERT INTO sanias_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","sāvadhānā bhavata, manujān darśayituṁ teṣāṁ gocare dharmmakarmma mā kuruta, tathā kṛte yuṣmākaṁ svargasthapituḥ sakāśāt kiñcana phalaṁ na prāpsyatha| ");
INSERT INTO sanias_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","tvaṁ yadā dadāsi tadā kapaṭino janā yathā manujebhyaḥ praśaṁsāṁ prāptuṁ bhajanabhavane rājamārge ca tūrīṁ vādayanti, tathā mā kuriु, ahaṁ tubhyaṁ yathārthaṁ kathayāmi, te svakāyaṁ phalam alabhanta| ");
INSERT INTO sanias_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","kintu tvaṁ yadā dadāsi, tadā nijadakṣiṇakaro yat karoti, tad vāmakaraṁ mā jñāpaya| ");
INSERT INTO sanias_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","tena tava dānaṁ guptaṁ bhaviṣyati yastu tava pitā guptadarśī, sa prakāśya tubhyaṁ phalaṁ dāsyati| ");
INSERT INTO sanias_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","aparaṁ yadā prārthayase, tadā kapaṭina̮iva mā kuru, yasmāt te bhajanabhavane rājamārgasya koṇe tiṣṭhanto lokān darśayantaḥ prārthayituṁ prīyante; ahaṁ yuṣmān tathyaṁ vadāmi, te svakīyaphalaṁ prāpnuvan| ");
INSERT INTO sanias_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","tasmāt prārthanākāle antarāgāraṁ praviśya dvāraṁ rudvvā guptaṁ paśyatastava pituḥ samīpe prārthayasva; tena tava yaḥ pitā guptadarśī, sa prakāśya tubhyaṁ phalaṁ dāsyatil ");
INSERT INTO sanias_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","aparaṁ prārthanākāle devapūjakāiva mudhā punaruktiṁ mā kuru, yasmāt te bodhante, bahuvāraṁ kathāyāṁ kathitāyāṁ teṣāṁ prārthanā grāhiṣyate| ");
INSERT INTO sanias_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","yūyaṁ teṣāmiva mā kuruta, yasmāt yuṣmākaṁ yad yat prayojanaṁ yācanātaḥ prāgeva yuṣmākaṁ pitā tat jānāti| ");
INSERT INTO sanias_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","ataeva yūyama īdṛk prārthayadhvaṁ, he asmākaṁ svargasthapitaḥ, tava nāma pūjyaṁ bhavatu| ");
INSERT INTO sanias_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","tava rājatvaṁ bhavatu; tavecchā svarge yathā tathaiva medinyāmapi saphalā bhavatu| ");
INSERT INTO sanias_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","asmākaṁ prayojanīyam āhāram adya dehi| ");
INSERT INTO sanias_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","vayaṁ yathā nijāparādhinaḥ kṣamāmahe, tathaivāsmākam aparādhān kṣamasva| ");
INSERT INTO sanias_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","asmān parīkṣāṁ mānaya, kintu pāpātmano rakṣa; rājatvaṁ gauravaṁ parākramaḥ ete sarvve sarvvadā tava; tathāstu| ");
INSERT INTO sanias_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","yadi yūyam anyeṣām aparādhān kṣamadhve tarhi yuṣmākaṁ svargasthapitāpi yuṣmān kṣamiṣyate; ");
INSERT INTO sanias_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","kintu yadi yūyam anyeṣām aparādhān na kṣamadhve, tarhi yuṣmākaṁ janakopi yuṣmākam aparādhān na kṣamiṣyate| ");
INSERT INTO sanias_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","aparam upavāsakāle kapaṭino janā mānuṣān upavāsaṁ jñāpayituṁ sveṣāṁ vadanāni mlānāni kurvvanti, yūyaṁ ta̮iva viṣaṇavadanā mā bhavata; ahaṁ yuṣmān tathyaṁ vadāmi te svakīyaphalam alabhanta| ");
INSERT INTO sanias_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","yadā tvam upavasasi, tadā yathā lokaistvaṁ upavāsīva na dṛśyase, kintu tava yo'gocaraḥ pitā tenaiva dṛśyase, tatkṛte nijaśirasi tailaṁ marddaya vadanañca prakṣālaya; ");
INSERT INTO sanias_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","tena tava yaḥ pitā guptadarśī sa prakāśya tubhyaṁ phalaṁ dāsyati| ");
INSERT INTO sanias_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","aparaṁ yatra sthāne kīṭāḥ kalaṅkāśca kṣayaṁ nayanti, caurāśca sandhiṁ karttayitvā corayituṁ śaknuvanti, tādṛśyāṁ medinyāṁ svārthaṁ dhanaṁ mā saṁcinuta| ");
INSERT INTO sanias_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","kintu yatra sthāne kīṭāḥ kalaṅkāśca kṣayaṁ na nayanti, caurāśca sandhiṁ karttayitvā corayituṁ na śaknuvanti, tādṛśe svarge dhanaṁ sañcinuta| ");
INSERT INTO sanias_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","yasmāt yatra sthāne yuṣmāṁka dhanaṁ tatraiva khāne yuṣmākaṁ manāṁsi| ");
INSERT INTO sanias_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","locanaṁ dehasya pradīpakaṁ, tasmāt yadi tava locanaṁ prasannaṁ bhavati, tarhi tava kṛtsnaṁ vapu rdīptiyuktaṁ bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","kintu locane'prasanne tava kṛtsnaṁ vapuḥ tamisrayuktaṁ bhaviṣyati| ataeva yā dīptistvayi vidyate, sā yadi tamisrayuktā bhavati, tarhi tat tamisraṁ kiyan mahat| ");
INSERT INTO sanias_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","kopi manujo dvau prabhū sevituṁ na śaknoti, yasmād ekaṁ saṁmanya tadanyaṁ na sammanyate, yadvā ekatra mano nidhāya tadanyam avamanyate; tathā yūyamapīśvaraṁ lakṣmīñcetyubhe sevituṁ na śaknutha| ");
INSERT INTO sanias_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","aparam ahaṁ yuṣmabhyaṁ tathyaṁ kathayāmi, kiṁ bhakṣiṣyāmaḥ? kiṁ pāsyāmaḥ? iti prāṇadhāraṇāya mā cintayata; kiṁ paridhāsyāmaḥ? iti kāyarakṣaṇāya na cintayata; bhakṣyāt prāṇā vasanāñca vapūṁṣi kiṁ śreṣṭhāṇi na hi? ");
INSERT INTO sanias_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","vihāyaso vihaṅgamān vilokayata; tai rnopyate na kṛtyate bhāṇḍāgāre na sañcīyate'pi; tathāpi yuṣmākaṁ svargasthaḥ pitā tebhya āhāraṁ vitarati| ");
INSERT INTO sanias_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","yūyaṁ tebhyaḥ kiṁ śreṣṭhā na bhavatha? yuṣmākaṁ kaścit manujaḥ cintayan nijāyuṣaḥ kṣaṇamapi varddhayituṁ śaknoti? ");
INSERT INTO sanias_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","aparaṁ vasanāya kutaścintayata? kṣetrotpannāni puṣpāṇi kathaṁ varddhante tadālocayata| tāni tantūn notpādayanti kimapi kāryyaṁ na kurvvanti; ");
INSERT INTO sanias_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","tathāpyahaṁ yuṣmān vadāmi, sulemān tādṛg aiśvaryyavānapi tatpuṣpamiva vibhūṣito nāsīt| ");
INSERT INTO sanias_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","tasmāt kṣadya vidyamānaṁ ścaḥ cullyāṁ nikṣepsyate tādṛśaṁ yat kṣetrasthitaṁ kusumaṁ tat yadīścara itthaṁ bibhūṣayati, tarhi he stokapratyayino yuṣmān kiṁ na paridhāpayiṣyati? ");
INSERT INTO sanias_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","tasmāt asmābhiḥ kimatsyate? kiñca pāyiṣyate? kiṁ vā paridhāyiṣyate, iti na cintayata| ");
INSERT INTO sanias_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","yasmāt devārccakā apīti ceṣṭante; eteṣu dravyeṣu prayojanamastīti yuṣmākaṁ svargasthaḥ pitā jānāti| ");
INSERT INTO sanias_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ataeva prathamata īśvarīyarājyaṁ dharmmañca ceṣṭadhvaṁ, tata etāni vastūni yuṣmabhyaṁ pradāyiṣyante| ");
INSERT INTO sanias_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","śvaḥ kṛte mā cintayata, śvaeva svayaṁ svamuddiśya cintayiṣyati; adyatanī yā cintā sādyakṛte pracuratarā| ");
INSERT INTO sanias_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","yathā yūyaṁ doṣīkṛtā na bhavatha, tatkṛte'nyaṁ doṣiṇaṁ mā kuruta| ");
INSERT INTO sanias_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","yato yādṛśena doṣeṇa yūyaṁ parān doṣiṇaḥ kurutha, tādṛśena doṣeṇa yūyamapi doṣīkṛtā bhaviṣyatha, anyañca yena parimāṇena yuṣmābhiḥ parimīyate, tenaiva parimāṇena yuṣmatkṛte parimāyiṣyate| ");
INSERT INTO sanias_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","aparañca nijanayane yā nāsā vidyate, tām anālocya tava sahajasya locane yat tṛṇam āste, tadeva kuto vīkṣase? ");
INSERT INTO sanias_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","tava nijalocane nāsāyāṁ vidyamānāyāṁ, he bhrātaḥ, tava nayanāt tṛṇaṁ bahiṣyartuṁ anujānīhi, kathāmetāṁ nijasahajāya kathaṁ kathayituṁ śaknoṣi? ");
INSERT INTO sanias_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","he kapaṭin, ādau nijanayanāt nāsāṁ bahiṣkuru tato nijadṛṣṭau suprasannāyāṁ tava bhrātṛ rlocanāt tṛṇaṁ bahiṣkartuṁ śakṣyasi| ");
INSERT INTO sanias_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","anyañca sārameyebhyaḥ pavitravastūni mā vitarata, varāhāṇāṁ samakṣañca muktā mā nikṣipata; nikṣepaṇāt te tāḥ sarvvāḥ padai rdalayiṣyanti, parāvṛtya yuṣmānapi vidārayiṣyanti| ");
INSERT INTO sanias_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","yācadhvaṁ tato yuṣmabhyaṁ dāyiṣyate; mṛgayadhvaṁ tata uddeśaṁ lapsyadhve; dvāram āhata, tato yuṣmatkṛte muktaṁ bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","yasmād yena yācyate, tena labhyate; yena mṛgyate tenoddeśaḥ prāpyate; yena ca dvāram āhanyate, tatkṛte dvāraṁ mocyate| ");
INSERT INTO sanias_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","ātmajena pūpe prārthite tasmai pāṣāṇaṁ viśrāṇayati, ");
INSERT INTO sanias_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","mīne yācite ca tasmai bhujagaṁ vitarati, etādṛśaḥ pitā yuṣmākaṁ madhye ka āste? ");
INSERT INTO sanias_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","tasmād yūyam abhadrāḥ santo'pi yadi nijabālakebhya uttamaṁ dravyaṁ dātuṁ jānītha, tarhi yuṣmākaṁ svargasthaḥ pitā svīyayācakebhyaḥ kimuttamāni vastūni na dāsyati? ");
INSERT INTO sanias_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","yūṣmān pratītareṣāṁ yādṛśo vyavahāro yuṣmākaṁ priyaḥ, yūyaṁ tān prati tādṛśāneva vyavahārān vidhatta; yasmād vyavasthābhaviṣyadvādināṁ vacanānām iti sāram| ");
INSERT INTO sanias_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","saṅkīrṇadvāreṇa praviśata; yato narakagamanāya yad dvāraṁ tad vistīrṇaṁ yacca vartma tad bṛhat tena bahavaḥ praviśanti| ");
INSERT INTO sanias_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","aparaṁ svargagamanāya yad dvāraṁ tat kīdṛk saṁkīrṇaṁ| yacca vartma tat kīdṛg durgamam| taduddeṣṭāraḥ kiyanto'lpāḥ| ");
INSERT INTO sanias_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","aparañca ye janā meṣaveśena yuṣmākaṁ samīpam āgacchanti, kintvantardurantā vṛkā etādṛśebhyo bhaviṣyadvādibhyaḥ sāvadhānā bhavata, yūyaṁ phalena tān paricetuṁ śaknutha| ");
INSERT INTO sanias_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","manujāḥ kiṁ kaṇṭakino vṛkṣād drākṣāphalāni śṛgālakolitaśca uḍumbaraphalāni śātayanti? ");
INSERT INTO sanias_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","tadvad uttama eva pādapa uttamaphalāni janayati, adhamapādapaevādhamaphalāni janayati| ");
INSERT INTO sanias_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","kintūttamapādapaḥ kadāpyadhamaphalāni janayituṁ na śaknoti, tathādhamopi pādapa uttamaphalāni janayituṁ na śaknoti| ");
INSERT INTO sanias_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","aparaṁ ye ye pādapā adhamaphalāni janayanti, te kṛttā vahnau kṣipyante| ");
INSERT INTO sanias_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ataeva yūyaṁ phalena tān pariceṣyatha| ");
INSERT INTO sanias_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","ye janā māṁ prabhuṁ vadanti, te sarvve svargarājyaṁ pravekṣyanti tanna, kintu yo mānavo mama svargasthasya pituriṣṭaṁ karmma karoti sa eva pravekṣyati| ");
INSERT INTO sanias_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","tad dine bahavo māṁ vadiṣyanti, he prabho he prabho, tava nāmnā kimasmāmi rbhaviṣyadvākyaṁ na vyāhṛtaṁ? tava nāmnā bhūtāḥ kiṁ na tyājitāḥ? tava nāmnā kiṁ nānādbhutāni karmmāṇi na kṛtāni? ");
INSERT INTO sanias_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","tadāhaṁ vadiṣyāmi, he kukarmmakāriṇo yuṣmān ahaṁ na vedmi, yūyaṁ matsamīpād dūrībhavata| ");
INSERT INTO sanias_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","yaḥ kaścit mamaitāḥ kathāḥ śrutvā pālayati, sa pāṣāṇopari gṛhanirmmātrā jñāninā saha mayopamīyate| ");
INSERT INTO sanias_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","yato vṛṣṭau satyām āplāva āgate vāyau vāte ca teṣu tadgehaṁ lagneṣu pāṣāṇopari tasya bhittestanna patatil ");
INSERT INTO sanias_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","kintu yaḥ kaścit mamaitāḥ kathāḥ śrutvā na pālayati sa saikate gehanirmmātrā 'jñāninā upamīyate| ");
INSERT INTO sanias_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","yato jalavṛṣṭau satyām āplāva āgate pavane vāte ca tai rgṛhe samāghāte tat patati tatpatanaṁ mahad bhavati| ");
INSERT INTO sanias_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","yīśunaiteṣu vākyeṣu samāpiteṣu mānavāstadīyopadeśam āścaryyaṁ menire| ");
INSERT INTO sanias_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","yasmāt sa upādhyāyā iva tān nopadideśa kintu samarthapuruṣa̮iva samupadideśa| ");
INSERT INTO sanias_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","yadā sa parvvatād avārohat tadā bahavo mānavāstatpaścād vavrajuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ekaḥ kuṣṭhavān āgatya taṁ praṇamya babhāṣe, he prabho, yadi bhavān saṁmanyate, tarhi māṁ nirāmayaṁ karttuṁ śaknoti| ");
INSERT INTO sanias_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","tato yīśuḥ karaṁ prasāryya tasyāṅgaṁ spṛśan vyājahāra, sammanye'haṁ tvaṁ nirāmayo bhava; tena sa tatkṣaṇāt kuṣṭhenāmoci| ");
INSERT INTO sanias_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","tato yīśustaṁ jagāda, avadhehi kathāmetāṁ kaścidapi mā brūhi, kintu yājakasya sannidhiṁ gatvā svātmānaṁ darśaya manujebhyo nijanirāmayatvaṁ pramāṇayituṁ mūsānirūpitaṁ dravyam utsṛja ca| ");
INSERT INTO sanias_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","tadanantaraṁ yīśunā kapharnāhūmnāmani nagare praviṣṭe kaścit śatasenāpatistatsamīpam āgatya vinīya babhāṣe, ");
INSERT INTO sanias_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","he prabho, madīya eko dāsaḥ pakṣāghātavyādhinā bhṛśaṁ vyathitaḥ, satu śayanīya āste| ");
INSERT INTO sanias_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","tadānīṁ yīśustasmai kathitavān, ahaṁ gatvā taṁ nirāmayaṁ kariṣyāmi| ");
INSERT INTO sanias_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","tataḥ sa śatasenāpatiḥ pratyavadat, he prabho, bhavān yat mama gehamadhyaṁ yāti tadyogyabhājanaṁ nāhamasmi; vāṅmātram ādiśatu, tenaiva mama dāso nirāmayo bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","yato mayi paranidhne'pi mama nideśavaśyāḥ kati kati senāḥ santi, tata ekasmin yāhītyukte sa yāti, tadanyasmin ehītyukte sa āyāti, tathā mama nijadāse karmmaitat kurvvityukte sa tat karoti| ");
INSERT INTO sanias_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","tadānīṁ yīśustasyaitat vaco niśamya vismayāpanno'bhūt; nijapaścādgāmino mānavān avocca, yuṣmān tathyaṁ vacmi, isrāyelīyalokānāṁ madhye'pi naitādṛśo viśvāso mayā prāptaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","anyaccāhaṁ yuṣmān vadāmi, bahavaḥ pūrvvasyāḥ paścimāyāśca diśa āgatya ibrāhīmā ishākā yākūbā ca sākam militvā samupavekṣyanti; ");
INSERT INTO sanias_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","kintu yatra sthāne rodanadantagharṣaṇe bhavatastasmin bahirbhūtatamisre rājyasya santānā nikṣesyante| ");
INSERT INTO sanias_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","tataḥ paraṁ yīśustaṁ śatasenāpatiṁ jagāda, yāhi, tava pratītyanusārato maṅgalaṁ bhūyāt; tadā tasminneva daṇḍe tadīyadāso nirāmayo babhūva| ");
INSERT INTO sanias_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","anantaraṁ yīśuḥ pitarasya gehamupasthāya jvareṇa pīḍitāṁ śayanīyasthitāṁ tasya śvaśrūṁ vīkṣāñcakre| ");
INSERT INTO sanias_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","tatastena tasyāḥ karasya spṛṣṭatavāt jvarastāṁ tatyāja, tadā sā samutthāya tān siṣeve| ");
INSERT INTO sanias_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","anantaraṁ sandhyāyāṁ satyāṁ bahuśo bhūtagrastamanujān tasya samīpam āninyuḥ sa ca vākyena bhūtān tyājayāmāsa, sarvvaprakārapīḍitajanāṁśca nirāmayān cakāra; ");
INSERT INTO sanias_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","tasmāt, sarvvā durbbalatāsmākaṁ tenaiva paridhāritā| asmākaṁ sakalaṁ vyādhiṁ saeva saṁgṛhītavān| yadetadvacanaṁ yiśayiyabhaviṣyadvādinoktamāsīt, tattadā saphalamabhavat| ");
INSERT INTO sanias_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","anantaraṁ yīśuścaturdikṣu jananivahaṁ vilokya taṭinyāḥ pāraṁ yātuṁ śiṣyān ādideśa| ");
INSERT INTO sanias_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","tadānīm eka upādhyāya āgatya kathitavān, he guro, bhavān yatra yāsyati tatrāhamapi bhavataḥ paścād yāsyāmi| ");
INSERT INTO sanias_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","tato yīśu rjagāda, kroṣṭuḥ sthātuṁ sthānaṁ vidyate, vihāyaso vihaṅgamānāṁ nīḍāni ca santi; kintu manuṣyaputrasya śiraḥ sthāpayituṁ sthānaṁ na vidyate| ");
INSERT INTO sanias_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","anantaram apara ekaḥ śiṣyastaṁ babhāṣe, he prabho, prathamato mama pitaraṁ śmaśāne nidhātuṁ gamanārthaṁ mām anumanyasva| ");
INSERT INTO sanias_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","tato yīśuruktavān mṛtā mṛtān śmaśāne nidadhatu, tvaṁ mama paścād āgaccha| ");
INSERT INTO sanias_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","anantaraṁ tasmin nāvamārūḍhe tasya śiṣyāstatpaścāt jagmuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","paścāt sāgarasya madhyaṁ teṣu gateṣu tādṛśaḥ prabalo jhañbhśanila udatiṣṭhat, yena mahātaraṅga utthāya taraṇiṁ chāditavān, kintu sa nidrita āsīt| ");
INSERT INTO sanias_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","tadā śiṣyā āgatya tasya nidrābhaṅgaṁ kṛtvā kathayāmāsuḥ, he prabho, vayaṁ mriyāmahe, bhavān asmākaṁ prāṇān rakṣatu| ");
INSERT INTO sanias_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","tadā sa tān uktavān, he alpaviśvāsino yūyaṁ kuto vibhītha? tataḥ sa utthāya vātaṁ sāgarañca tarjayāmāsa, tato nirvvātamabhavat| ");
INSERT INTO sanias_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","aparaṁ manujā vismayaṁ vilokya kathayāmāsuḥ, aho vātasaritpatī asya kimājñāgrāhiṇau? kīdṛśo'yaṁ mānavaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","anantaraṁ sa pāraṁ gatvā giderīyadeśam upasthitavān; tadā dvau bhūtagrastamanujau śmaśānasthānād bahi rbhūtvā taṁ sākṣāt kṛtavantau, tāvetādṛśau pracaṇḍāvāstāṁ yat tena sthānena kopi yātuṁ nāśaknot| ");
INSERT INTO sanias_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","tāvucaiḥ kathayāmāsatuḥ, he īśvarasya sūno yīśo, tvayā sākam āvayoḥ kaḥ sambandhaḥ? nirūpitakālāt prāgeva kimāvābhyāṁ yātanāṁ dātum atrāgatosi? ");
INSERT INTO sanias_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","tadānīṁ tābhyāṁ kiñcid dūre varāhāṇām eko mahāvrajo'carat| ");
INSERT INTO sanias_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","tato bhūtau tau tasyāntike vinīya kathayāmāsatuḥ, yadyāvāṁ tyājayasi, tarhi varāhāṇāṁ madhyevrajam āvāṁ preraya| ");
INSERT INTO sanias_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","tadā yīśuravadat yātaṁ, anantaraṁ tau yadā manujau vihāya varāhān āśritavantau, tadā te sarvve varāhā uccasthānāt mahājavena dhāvantaḥ sāgarīyatoye majjanto mamruḥ| ");
INSERT INTO sanias_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","tato varāharakṣakāḥ palāyamānā madhyenagaraṁ tau bhūtagrastau prati yadyad aghaṭata, tāḥ sarvvavārttā avadan| ");
INSERT INTO sanias_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","tato nāgarikāḥ sarvve manujā yīśuṁ sākṣāt karttuṁ bahirāyātāḥ tañca vilokya prārthayāñcakrire bhavān asmākaṁ sīmāto yātu| ");
INSERT INTO sanias_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","anantaraṁ yīśu rnaukāmāruhya punaḥ pāramāgatya nijagrāmam āyayau| ");
INSERT INTO sanias_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","tataḥ katipayā janā ekaṁ pakṣāghātinaṁ svaṭṭopari śāyayitvā tatsamīpam ānayan; tato yīśusteṣāṁ pratītiṁ vijñāya taṁ pakṣāghātinaṁ jagāda, he putra, susthiro bhava, tava kaluṣasya marṣaṇaṁ jātam| ");
INSERT INTO sanias_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","tāṁ kathāṁ niśamya kiyanta upādhyāyā manaḥsu cintitavanta eṣa manuja īśvaraṁ nindati| ");
INSERT INTO sanias_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","tataḥ sa teṣām etādṛśīṁ cintāṁ vijñāya kathitavān, yūyaṁ manaḥsu kṛta etādṛśīṁ kucintāṁ kurutha? ");
INSERT INTO sanias_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","tava pāpamarṣaṇaṁ jātaṁ, yadvā tvamutthāya gaccha, dvayoranayo rvākyayoḥ kiṁ vākyaṁ vaktuṁ sugamaṁ? ");
INSERT INTO sanias_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","kintu medinyāṁ kaluṣaṁ kṣamituṁ manujasutasya sāmarthyamastīti yūyaṁ yathā jānītha, tadarthaṁ sa taṁ pakṣāghātinaṁ gaditavān, uttiṣṭha, nijaśayanīyaṁ ādāya gehaṁ gaccha| ");
INSERT INTO sanias_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","tataḥ sa tatkṣaṇād utthāya nijagehaṁ prasthitavān| ");
INSERT INTO sanias_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","mānavā itthaṁ vilokya vismayaṁ menire, īśvareṇa mānavāya sāmarthyam īdṛśaṁ dattaṁ iti kāraṇāt taṁ dhanyaṁ babhāṣire ca| ");
INSERT INTO sanias_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","anantaraṁ yīśustatsthānād gacchan gacchan karasaṁgrahasthāne samupaviṣṭaṁ mathināmānam ekaṁ manujaṁ vilokya taṁ babhāṣe, mama paścād āgaccha, tataḥ sa utthāya tasya paścād vavrāja| ");
INSERT INTO sanias_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","tataḥ paraṁ yīśau gṛhe bhoktum upaviṣṭe bahavaḥ karasaṁgrāhiṇaḥ kaluṣiṇaśca mānavā āgatya tena sākaṁ tasya śiṣyaiśca sākam upaviviśuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","phirūśinastad dṛṣṭvā tasya śiṣyān babhāṣire, yuṣmākaṁ guruḥ kiṁ nimittaṁ karasaṁgrāhibhiḥ kaluṣibhiśca sākaṁ bhuṁkte? ");
INSERT INTO sanias_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","yīśustat śrutvā tān pratyavadat, nirāmayalokānāṁ cikitsakena prayojanaṁ nāsti, kintu sāmayalokānāṁ prayojanamāste| ");
INSERT INTO sanias_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","ato yūyaṁ yātvā vacanasyāsyārthaṁ śikṣadhvam, dayāyāṁ me yathā prīti rna tathā yajñakarmmaṇi|yato'haṁ dhārmmikān āhvātuṁ nāgato'smi kintu manaḥ parivarttayituṁ pāpina āhvātum āgato'smi| ");
INSERT INTO sanias_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","anantaraṁ yohanaḥ śiṣyāstasya samīpam āgatya kathayāmāsuḥ, phirūśino vayañca punaḥ punarupavasāmaḥ, kintu tava śiṣyā nopavasanti, kutaḥ? ");
INSERT INTO sanias_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","tadā yīśustān avocat yāvat sakhīnāṁ saṁṅge kanyāyā varastiṣṭhati, tāvat kiṁ te vilāpaṁ karttuṁ śakluvanti? kintu yadā teṣāṁ saṁṅgād varaṁ nayanti, tādṛśaḥ samaya āgamiṣyati, tadā te upavatsyanti| ");
INSERT INTO sanias_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","purātanavasane kopi navīnavastraṁ na yojayati, yasmāt tena yojitena purātanavasanaṁ chinatti tacchidrañca bahukutsitaṁ dṛśyate| ");
INSERT INTO sanias_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","anyañca purātanakutvāṁ kopi navānagostanīrasaṁ na nidadhāti, yasmāt tathā kṛte kutū rvidīryyate tena gostanīrasaḥ patati kutūśca naśyati; tasmāt navīnāyāṁ kutvāṁ navīno gostanīrasaḥ sthāpyate, tena dvayoravanaṁ bhavati| ");
INSERT INTO sanias_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","aparaṁ tenaitatkathākathanakāle eko'dhipatistaṁ praṇamya babhāṣe, mama duhitā prāyeṇaitāvatkāle mṛtā, tasmād bhavānāgatya tasyā gātre hastamarpayatu, tena sā jīviṣyati| ");
INSERT INTO sanias_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","tadānīṁ yīśuḥ śiṣyaiḥ sākam utthāya tasya paścād vavrāja| ");
INSERT INTO sanias_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ityanantare dvādaśavatsarān yāvat pradarāmayena śīrṇaikā nārī tasya paścād āgatya tasya vasanasya granthiṁ pasparśa; ");
INSERT INTO sanias_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","yasmāt mayā kevalaṁ tasya vasanaṁ spṛṣṭvā svāsthyaṁ prāpsyate, sā nārīti manasi niścitavatī| ");
INSERT INTO sanias_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","tato yīśurvadanaṁ parāvarttya tāṁ jagāda, he kanye, tvaṁ susthirā bhava, tava viśvāsastvāṁ svasthāmakārṣīt| etadvākye gaditaeva sā yoṣit svasthābhūt| ");
INSERT INTO sanias_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","aparaṁ yīśustasyādhyakṣasya gehaṁ gatvā vādakaprabhṛtīn bahūn lokān śabdāyamānān vilokya tān avadat, ");
INSERT INTO sanias_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","panthānaṁ tyaja, kanyeyaṁ nāmriyata nidritāste; kathāmetāṁ śrutvā te tamupajahasuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","kintu sarvveṣu bahiṣkṛteṣu so'bhyantaraṁ gatvā kanyāyāḥ karaṁ dhṛtavān, tena sodatiṣṭhat; ");
INSERT INTO sanias_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","tatastatkarmmaṇo yaśaḥ kṛtsnaṁ taṁ deśaṁ vyāptavat| ");
INSERT INTO sanias_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","tataḥ paraṁ yīśustasmāt sthānād yātrāṁ cakāra; tadā he dāyūdaḥ santāna, asmān dayasva, iti vadantau dvau janāvandhau procairāhūyantau tatpaścād vavrajatuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","tato yīśau gehamadhyaṁ praviṣṭaṁ tāvapi tasya samīpam upasthitavantau, tadānīṁ sa tau pṛṣṭavān karmmaitat karttuṁ mama sāmarthyam āste, yuvāṁ kimiti pratīthaḥ? tadā tau pratyūcatuḥ, satyaṁ prabho| ");
INSERT INTO sanias_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","tadānīṁ sa tayo rlocanāni spṛśan babhāṣe, yuvayoḥ pratītyanusārād yuvayo rmaṅgalaṁ bhūyāt| tena tatkṣaṇāt tayo rnetrāṇi prasannānyabhavan, ");
INSERT INTO sanias_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","paścād yīśustau dṛḍhamājñāpya jagāda, avadhattam etāṁ kathāṁ kopi manujo ma jānīyāt| ");
INSERT INTO sanias_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","kintu tau prasthāya tasmin kṛtsne deśe tasya kīrttiṁ prakāśayāmāsatuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","aparaṁ tau bahiryāta etasminnantare manujā ekaṁ bhūtagrastamūkaṁ tasya samīpam ānītavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","tena bhūte tyājite sa mūkaḥ kathāṁ kathayituṁ prārabhata, tena janā vismayaṁ vijñāya kathayāmāsuḥ, isrāyelo vaṁśe kadāpi nedṛgadṛśyata; ");
INSERT INTO sanias_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","kintu phirūśinaḥ kathayāñcakruḥ bhūtādhipatinā sa bhūtān tyājayati| ");
INSERT INTO sanias_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","tataḥ paraṁ yīśusteṣāṁ bhajanabhavana upadiśan rājyasya susaṁvādaṁ pracārayan lokānāṁ yasya ya āmayo yā ca pīḍāsīt, tān śamayan śamayaṁśca sarvvāṇi nagarāṇi grāmāṁśca babhrāma| ");
INSERT INTO sanias_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","anyañca manujān vyākulān arakṣakameṣāniva ca tyaktān nirīkṣya teṣu kāruṇikaḥ san śiṣyān avadat, ");
INSERT INTO sanias_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","śasyāni pracurāṇi santi, kintu chettāraḥ stokāḥ| ");
INSERT INTO sanias_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","kṣetraṁ pratyaparān chedakān prahetuṁ śasyasvāminaṁ prārthayadhvam| ");
INSERT INTO sanias_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","anantaraṁ yīśu rdvādaśaśiṣyān āhūyāmedhyabhūtān tyājayituṁ sarvvaprakārarogān pīḍāśca śamayituṁ tebhyaḥ sāmarthyamadāt| ");
INSERT INTO sanias_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","teṣāṁ dvādaśapreṣyāṇāṁ nāmānyetāni| prathamaṁ śimon yaṁ pitaraṁ vadanti, tataḥ paraṁ tasya sahaja āndriyaḥ, sivadiyasya putro yākūb ");
INSERT INTO sanias_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","tasya sahajo yohan; philip barthalamay thomāḥ karasaṁgrāhī mathiḥ, ālpheyaputro yākūb, ");
INSERT INTO sanias_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","kinānīyaḥ śimon, ya īṣkariyotīyayihūdāḥ khrīṣṭaṁ parakare'rpayat| ");
INSERT INTO sanias_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","etān dvādaśaśiṣyān yīśuḥ preṣayan ityājñāpayat, yūyam anyadeśīyānāṁ padavīṁ śemiroṇīyānāṁ kimapi nagarañca na praviśye ");
INSERT INTO sanias_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","isrāyelgotrasya hāritā ye ye meṣāsteṣāmeva samīpaṁ yāta| ");
INSERT INTO sanias_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","gatvā gatvā svargasya rājatvaṁ savidhamabhavat, etāṁ kathāṁ pracārayata| ");
INSERT INTO sanias_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","āmayagrastān svasthān kuruta, kuṣṭhinaḥ pariṣkuruta, mṛtalokān jīvayata, bhūtān tyājayata, vinā mūlyaṁ yūyam alabhadhvaṁ vinaiva mūlyaṁ viśrāṇayata| ");
INSERT INTO sanias_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","kintu sveṣāṁ kaṭibandheṣu svarṇarūpyatāmrāṇāṁ kimapi na gṛhlīta| ");
INSERT INTO sanias_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","anyacca yātrāyai celasampuṭaṁ vā dvitīyavasanaṁ vā pāduke vā yaṣṭiḥ, etān mā gṛhlīta, yataḥ kāryyakṛt bharttuṁ yogyo bhavati| ");
INSERT INTO sanias_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","aparaṁ yūyaṁ yat puraṁ yañca grāmaṁ praviśatha, tatra yo jano yogyapātraṁ tamavagatya yānakālaṁ yāvat tatra tiṣṭhata| ");
INSERT INTO sanias_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","yadā yūyaṁ tadgehaṁ praviśatha, tadā tamāśiṣaṁ vadata| ");
INSERT INTO sanias_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","yadi sa yogyapātraṁ bhavati, tarhi tatkalyāṇaṁ tasmai bhaviṣyati, nocet sāśīryuṣmabhyameva bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","kintu ye janā yuṣmākamātithyaṁ na vidadhati yuṣmākaṁ kathāñca na śṛṇvanti teṣāṁ gehāt purādvā prasthānakāle svapadūlīḥ pātayata| ");
INSERT INTO sanias_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","yuṣmānahaṁ tathyaṁ vacmi vicāradine tatpurasya daśātaḥ sidomamorāpurayordaśā sahyatarā bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","paśyata, vṛkayūthamadhye meṣaḥ yathāvistathā yuṣmāna prahiṇomi, tasmād yūyam ahiriva satarkāḥ kapotāivāhiṁsakā bhavata| ");
INSERT INTO sanias_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","nṛbhyaḥ sāvadhānā bhavata; yatastai ryūyaṁ rājasaṁsadi samarpiṣyadhve teṣāṁ bhajanagehe prahāriṣyadhve| ");
INSERT INTO sanias_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","yūyaṁ mannāmahetoḥ śāstṛṇāṁ rājñāñca samakṣaṁ tānanyadeśinaścādhi sākṣitvārthamāneṣyadhve| ");
INSERT INTO sanias_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","kintvitthaṁ samarpitā yūyaṁ kathaṁ kimuttaraṁ vakṣyatha tatra mā cintayata, yatastadā yuṣmābhi ryad vaktavyaṁ tat taddaṇḍe yuṣmanmanaḥ su samupasthāsyati| ");
INSERT INTO sanias_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","yasmāt tadā yo vakṣyati sa na yūyaṁ kintu yuṣmākamantarasthaḥ pitrātmā| ");
INSERT INTO sanias_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","sahajaḥ sahajaṁ tātaḥ sutañca mṛtau samarpayiṣyati, apatyāgi svasvapitroे rvipakṣībhūya tau ghātayiṣyanti| ");
INSERT INTO sanias_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","mannamahetoḥ sarvve janā yuṣmān ṛृtīyiṣyante, kintu yaḥ śeṣaṁ yāvad dhairyyaṁ ghṛtvā sthāsyati, sa trāyiṣyate| ");
INSERT INTO sanias_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","tai ryadā yūyamekapure tāḍiṣyadhve, tadā yūyamanyapuraṁ palāyadhvaṁ yuṣmānahaṁ tathyaṁ vacmi yāvanmanujasuto naiti tāvad isrāyeldeśīyasarvvanagarabhramaṇaṁ samāpayituṁ na śakṣyatha| ");
INSERT INTO sanias_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","guroḥ śiṣyo na mahān, prabhordāso na mahān| ");
INSERT INTO sanias_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","yadi śiṣyo nijaguro rdāsaśca svaprabhoḥ samāno bhavati tarhi tad yatheṣṭaṁ| cettairgṛhapatirbhūtarāja ucyate, tarhi parivārāḥ kiṁ tathā na vakṣyante? ");
INSERT INTO sanias_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","kintu tebhyo yūyaṁ mā bibhīta, yato yanna prakāśiṣyate, tādṛk chāditaṁ kimapi nāsti, yacca na vyañciṣyate, tādṛg guptaṁ kimapi nāsti| ");
INSERT INTO sanias_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","yadahaṁ yuṣmān tamasi vacmi tad yuṣmābhirdīptau kathyatāṁ; karṇābhyāṁ yat śrūyate tad gehopari pracāryyatāṁ| ");
INSERT INTO sanias_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ye kāyaṁ hantuṁ śaknuvanti nātmānaṁ, tebhyo mā bhaiṣṭa; yaḥ kāyātmānau niraye nāśayituṁ, śaknoti, tato bibhīta| ");
INSERT INTO sanias_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","dvau caṭakau kimekatāmramudrayā na vikrīyete? tathāpi yuṣmattātānumatiṁ vinā teṣāmekopi bhuvi na patati| ");
INSERT INTO sanias_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","yuṣmacchirasāṁ sarvvakacā gaṇitāṁḥ santi| ");
INSERT INTO sanias_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ato mā bibhīta, yūyaṁ bahucaṭakebhyo bahumūlyāḥ| ");
INSERT INTO sanias_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","yo manujasākṣānmāmaṅgīkurute tamahaṁ svargasthatātasākṣādaṅgīkariṣye| ");
INSERT INTO sanias_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","pṛthvyāmahaṁ śāntiṁ dātumāgata̮iti mānubhavata, śāntiṁ dātuṁ na kintvasiṁ| ");
INSERT INTO sanias_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","pitṛmātṛścaśrūbhiḥ sākaṁ sutasutābadhū rvirodhayituñcāgateाsmi| ");
INSERT INTO sanias_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","tataḥ svasvaparivāraeva nṛśatru rbhavitā| ");
INSERT INTO sanias_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","yaḥ pitari mātari vā mattodhikaṁ prīyate, sa na madarhaḥ; ");
INSERT INTO sanias_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","yaśca sute sutāyāṁ vā mattodhikaṁ prīyate, seाpi na madarhaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","yaḥ svakruśaṁ gṛhlan matpaścānnaiti, seाpi na madarhaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","yaḥ svaprāṇānavati, sa tān hārayiṣyate, yastu matkṛte svaprāṇān hārayati, sa tānavati| ");
INSERT INTO sanias_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","yo yuṣmākamātithyaṁ vidadhāti, sa mamātithyaṁ vidadhāti, yaśca mamātithyaṁ vidadhāti, sa matprerakasyātithyaṁ vidadhāti| ");
INSERT INTO sanias_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","yo bhaviṣyadvādīti jñātvā tasyātithyaṁ vidhatte, sa bhaviṣyadvādinaḥ phalaṁ lapsyate, yaśca dhārmmika iti viditvā tasyātithyaṁ vidhatte sa dhārmmikamānavasya phalaṁ prāpsyati| ");
INSERT INTO sanias_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","yaśca kaścit eteṣāṁ kṣudranarāṇām yaṁ kañcanaikaṁ śiṣya iti viditvā kaṁsaikaṁ śītalasalilaṁ tasmai datte, yuṣmānahaṁ tathyaṁ vadāmi, sa kenāpi prakāreṇa phalena na vañciṣyate| ");
INSERT INTO sanias_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","itthaṁ yīśuḥ svadvādaśaśiṣyāṇāmājñāpanaṁ samāpya pure pura upadeṣṭuṁ susaṁvādaṁ pracārayituṁ tatsthānāt pratasthe| ");
INSERT INTO sanias_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","anantaraṁ yohan kārāyāṁ tiṣṭhan khriṣṭasya karmmaṇāṁ vārttaṁ prāpya yasyāgamanavārttāsīt saeva kiṁ tvaṁ? vā vayamanyam apekṣiṣyāmahe? ");
INSERT INTO sanias_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","etat praṣṭuṁ nijau dvau śiṣyau prāhiṇot| ");
INSERT INTO sanias_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","yīśuḥ pratyavocat, andhā netrāṇi labhante, khañcā gacchanti, kuṣṭhinaḥ svasthā bhavanti, badhirāḥ śṛṇvanti, mṛtā jīvanta uttiṣṭhanti, daridrāṇāṁ samīpe susaṁvādaḥ pracāryyata, ");
INSERT INTO sanias_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","etāni yadyad yuvāṁ śṛṇuthaḥ paśyathaśca gatvā tadvārttāṁ yohanaṁ gadataṁ| ");
INSERT INTO sanias_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","yasyāhaṁ na vighnībhavāmi, saeva dhanyaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","anantaraṁ tayoḥ prasthitayo ryīśu ryohanam uddiśya janān jagāda, yūyaṁ kiṁ draṣṭuṁ vahirmadhyeprāntaram agacchata? kiṁ vātena kampitaṁ nalaṁ? ");
INSERT INTO sanias_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","vā kiṁ vīkṣituṁ vahirgatavantaḥ? kiṁ parihitasūkṣmavasanaṁ manujamekaṁ? paśyata, ye sūkṣmavasanāni paridadhati, te rājadhānyāṁ tiṣṭhanti| ");
INSERT INTO sanias_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","tarhi yūyaṁ kiṁ draṣṭuṁ bahiragamata, kimekaṁ bhaviṣyadvādinaṁ? tadeva satyaṁ| yuṣmānahaṁ vadāmi, sa bhaviṣyadvādinopi mahān; ");
INSERT INTO sanias_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","yataḥ, paśya svakīyadūtoyaṁ tvadagre preṣyate mayā| sa gatvā tava panthānaṁ smayak pariṣkariṣyati|| etadvacanaṁ yamadhi likhitamāste so'yaṁ yohan| ");
INSERT INTO sanias_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","aparaṁ yuṣmānahaṁ tathyaṁ bravīmi, majjayitu ryohanaḥ śreṣṭhaḥ kopi nārīto nājāyata; tathāpi svargarājyamadhye sarvvebhyo yaḥ kṣudraḥ sa yohanaḥ śreṣṭhaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","aparañca ā yohano'dya yāvat svargarājyaṁ balādākrāntaṁ bhavati ākraminaśca janā balena tadadhikurvvanti| ");
INSERT INTO sanias_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","yato yohanaṁ yāvat sarvvabhaviṣyadvādibhi rvyavasthayā ca upadeśaḥ prākāśyata| ");
INSERT INTO sanias_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","yadi yūyamidaṁ vākyaṁ grahītuṁ śaknutha, tarhi śreyaḥ, yasyāgamanasya vacanamāste so'yam eliyaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","yasya śrotuṁ karṇau staḥ sa śṛṇotu| ");
INSERT INTO sanias_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","ete vidyamānajanāḥ kai rmayopamīyante? ye bālakā haṭṭa upaviśya svaṁ svaṁ bandhumāhūya vadanti, ");
INSERT INTO sanias_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","vayaṁ yuṣmākaṁ samīpe vaṁśīravādayāma, kintu yūyaṁ nānṛtyata; yuṣmākaṁ samīpe ca vayamarodima, kintu yūyaṁ na vyalapata, tādṛśai rbālakaista upamāyiṣyante| ");
INSERT INTO sanias_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","yato yohan āgatya na bhuktavān na pītavāṁśca, tena lokā vadanti, sa bhūtagrasta iti| ");
INSERT INTO sanias_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","manujasuta āgatya bhuktavān pītavāṁśca, tena lokā vadanti, paśyata eṣa bhoktā madyapātā caṇḍālapāpināṁ bandhaśca, kintu jñānino jñānavyavahāraṁ nirdoṣaṁ jānanti| ");
INSERT INTO sanias_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","sa yatra yatra pure bahvāścaryyaṁ karmma kṛtavān, tannivāsināṁ manaḥparāvṛttyabhāvāt tāni nagarāṇi prati hantetyuktā kathitavān, ");
INSERT INTO sanias_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","hā korāsīn, hā baitsaide, yuṣmanmadhye yadyadāścaryyaṁ karmma kṛtaṁ yadi tat sorasīdonnagara akāriṣyata, tarhi pūrvvameva tannivāsinaḥ śāṇavasane bhasmani copaviśanto manāṁsi parāvarttiṣyanta| ");
INSERT INTO sanias_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","tasmādahaṁ yuṣmān vadāmi, vicāradine yuṣmākaṁ daśātaḥ sorasīdono rdaśā sahyatarā bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","aparañca bata kapharnāhūm, tvaṁ svargaṁ yāvadunnatosi, kintu narake nikṣepsyase, yasmāt tvayi yānyāścaryyāṇi karmmaṇyakāriṣata, yadi tāni sidomnagara akāriṣyanta, tarhi tadadya yāvadasthāsyat| ");
INSERT INTO sanias_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","kintvahaṁ yuṣmān vadāmi, vicāradine tava daṇḍataḥ sidomo daṇḍo sahyataro bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","etasminneva samaye yīśuḥ punaruvāca, he svargapṛthivyorekādhipate pitastvaṁ jñānavato viduṣaśca lokān pratyetāni na prakāśya bālakān prati prakāśitavān, iti hetostvāṁ dhanyaṁ vadāmi| ");
INSERT INTO sanias_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","he pitaḥ, itthaṁ bhavet yata idaṁ tvadṛṣṭāvuttamaṁ| ");
INSERT INTO sanias_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","pitrā mayi sarvvāṇi samarpitāni, pitaraṁ vinā kopi putraṁ na jānāti, yān prati putreṇa pitā prakāśyate tān vinā putrād anyaḥ kopi pitaraṁ na jānāti| ");
INSERT INTO sanias_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","he pariśrāntā bhārākrāntāśca lokā yūyaṁ matsannidhim āgacchata, ahaṁ yuṣmān viśramayiṣyāmi| ");
INSERT INTO sanias_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ahaṁ kṣamaṇaśīlo namramanāśca, tasmāt mama yugaṁ sveṣāmupari dhārayata mattaḥ śikṣadhvañca, tena yūyaṁ sve sve manasi viśrāmaṁ lapsyadhbe| ");
INSERT INTO sanias_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","yato mama yugam anāyāsaṁ mama bhāraśca laghuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","anantaraṁ yīśu rviśrāmavāre śsyamadhyena gacchati, tadā tacchiṣyā bubhukṣitāḥ santaḥ śsyamañjarīśchatvā chitvā khāditumārabhanta| ");
INSERT INTO sanias_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","tad vilokya phirūśino yīśuṁ jagaduḥ, paśya viśrāmavāre yat karmmākarttavyaṁ tadeva tava śiṣyāḥ kurvvanti| ");
INSERT INTO sanias_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","sa tān pratyāvadata, dāyūd tatsaṅginaśca bubhukṣitāḥ santo yat karmmākurvvan tat kiṁ yuṣmābhi rnāpāṭhi? ");
INSERT INTO sanias_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ye darśanīyāḥ pūpāḥ yājakān vinā tasya tatsaṅgimanujānāñcābhojanīyāsta īśvarāvāsaṁ praviṣṭena tena bhuktāḥ| ");
INSERT INTO sanias_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","anyacca viśrāmavāre madhyemandiraṁ viśrāmavārīyaṁ niyamaṁ laṅvantopi yājakā nirdoṣā bhavanti, śāstramadhye kimidamapi yuṣmābhi rna paṭhitaṁ? ");
INSERT INTO sanias_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","yuṣmānahaṁ vadāmi, atra sthāne mandirādapi garīyān eka āste| ");
INSERT INTO sanias_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","kintu dayāyāṁ me yathā prīti rna tathā yajñakarmmaṇi| etadvacanasyārthaṁ yadi yuyam ajñāsiṣṭa tarhi nirdoṣān doṣiṇo nākārṣṭa| ");
INSERT INTO sanias_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","anyacca manujasuto viśrāmavārasyāpi patirāste| ");
INSERT INTO sanias_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","anantaraṁ sa tatsthānāt prasthāya teṣāṁ bhajanabhavanaṁ praviṣṭavān, tadānīm ekaḥ śuṣkakarāmayavān upasthitavān| ");
INSERT INTO sanias_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","tato yīśum apavadituṁ mānuṣāḥ papracchuḥ, viśrāmavāre nirāmayatvaṁ karaṇīyaṁ na vā? ");
INSERT INTO sanias_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","tena sa pratyuvāca, viśrāmavāre yadi kasyacid avi rgartte patati, tarhi yastaṁ ghṛtvā na tolayati, etādṛśo manujo yuṣmākaṁ madhye ka āste? ");
INSERT INTO sanias_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ave rmānavaḥ kiṁ nahi śreyān? ato viśrāmavāre hitakarmma karttavyaṁ| ");
INSERT INTO sanias_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","anantaraṁ sa taṁ mānavaṁ gaditavān, karaṁ prasāraya; tena kare prasārite sonyakaravat svastho'bhavat| ");
INSERT INTO sanias_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","tadā phirūśino bahirbhūya kathaṁ taṁ haniṣyāma iti kumantraṇāṁ tatprātikūlyena cakruḥ| ");
INSERT INTO sanias_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","tato yīśustad viditvā sthanāntaraṁ gatavān; anyeṣu bahunareṣu tatpaścād gateṣu tān sa nirāmayān kṛtvā ityājñāpayat, ");
INSERT INTO sanias_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","yūyaṁ māṁ na paricāyayata| ");
INSERT INTO sanias_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","tasmāt mama prīyo manonīto manasastuṣṭikārakaḥ| madīyaḥ sevako yastu vidyate taṁ samīkṣatāṁ| tasyopari svakīyātmā mayā saṁsthāpayiṣyate| tenānyadeśajāteṣu vyavasthā saṁprakāśyate| ");
INSERT INTO sanias_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","kenāpi na virodhaṁ sa vivādañca kariṣyati| na ca rājapathe tena vacanaṁ śrāvayiṣyate| ");
INSERT INTO sanias_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","vyavasthā calitā yāvat nahi tena kariṣyate| tāvat nalo vidīrṇo'pi bhaṁkṣyate nahi tena ca| tathā sadhūmavarttiñca na sa nirvvāpayiṣyate| ");
INSERT INTO sanias_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","pratyāśāñca kariṣyanti tannāmni bhinnadeśajāḥ| ");
INSERT INTO sanias_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","yānyetāni vacanāni yiśayiyabhaviṣyadvādinā proktānyāsan, tāni saphalānyabhavan| ");
INSERT INTO sanias_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","anantaraṁ lokai statsamīpam ānīto bhūtagrastāndhamūkaikamanujastena svasthīkṛtaḥ, tataḥ so'ndho mūko draṣṭuṁ vaktuñcārabdhavān| ");
INSERT INTO sanias_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","anena sarvve vismitāḥ kathayāñcakruḥ, eṣaḥ kiṁ dāyūdaḥ santāno nahi? ");
INSERT INTO sanias_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","kintu phirūśinastat śrutvā gaditavantaḥ, bālsibūbnāmno bhūtarājasya sāhāyyaṁ vinā nāyaṁ bhūtān tyājayati| ");
INSERT INTO sanias_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","tadānīṁ yīśusteṣām iti mānasaṁ vijñāya tān avadat kiñcana rājyaṁ yadi svavipakṣād bhidyate, tarhi tat ucchidyate; yacca kiñcana nagaraṁ vā gṛhaṁ svavipakṣād vibhidyate, tat sthātuṁ na śaknoti| ");
INSERT INTO sanias_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","tadvat śayatāno yadi śayatānaṁ bahiḥ kṛtvā svavipakṣāt pṛthak pṛthak bhavati, tarhi tasya rājyaṁ kena prakāreṇa sthāsyati? ");
INSERT INTO sanias_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ahañca yadi bālsibūbā bhūtān tyājayāmi, tarhi yuṣmākaṁ santānāḥ kena bhūtān tyājayanti? tasmād yuṣmākam etadvicārayitārasta eva bhaviṣyanti| ");
INSERT INTO sanias_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","kintavahaṁ yadīśvarātmanā bhūtān tyājayāmi, tarhīśvarasya rājyaṁ yuṣmākaṁ sannidhimāgatavat| ");
INSERT INTO sanias_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","anyañca kopi balavanta janaṁ prathamato na badvvā kena prakāreṇa tasya gṛhaṁ praviśya taddravyādi loṭhayituṁ śaknoti? kintu tat kṛtvā tadīyagṛsya dravyādi loṭhayituṁ śaknoti| ");
INSERT INTO sanias_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","yaḥ kaścit mama svapakṣīyo nahi sa vipakṣīya āste, yaśca mayā sākaṁ na saṁgṛhlāti, sa vikirati| ");
INSERT INTO sanias_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ataeva yuṣmānahaṁ vadāmi, manujānāṁ sarvvaprakārapāpānāṁ nindāyāśca marṣaṇaṁ bhavituṁ śaknoti, kintu pavitrasyātmano viruddhanindāyā marṣaṇaṁ bhavituṁ na śaknoti| ");
INSERT INTO sanias_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","yo manujasutasya viruddhāṁ kathāṁ kathayati, tasyāparādhasya kṣamā bhavituṁ śaknoti, kintu yaḥ kaścit pavitrasyātmano viruddhāṁ kathāṁ kathayati nehaloke na pretya tasyāparādhasya kṣamā bhavituṁ śaknoti| ");
INSERT INTO sanias_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","pādapaṁ yadi bhadraṁ vadatha, tarhi tasya phalamapi sādhu vaktavyaṁ, yadi ca pādapaṁ asādhuṁ vadatha, tarhi tasya phalamapyasādhu vaktavyaṁ; yataḥ svīyasvīyaphalena pādapaḥ paricīyate| ");
INSERT INTO sanias_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","re bhujagavaṁśā yūyamasādhavaḥ santaḥ kathaṁ sādhu vākyaṁ vaktuṁ śakṣyatha? yasmād antaḥkaraṇasya pūrṇabhāvānusārād vadanād vaco nirgacchati| ");
INSERT INTO sanias_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","tena sādhurmānavo'ntaḥkaraṇarūpāt sādhubhāṇḍāgārāt sādhu dravyaṁ nirgamayati, asādhurmānuṣastvasādhubhāṇḍāgārād asādhuvastūni nirgamayati| ");
INSERT INTO sanias_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","kintvahaṁ yuṣmān vadāmi, manujā yāvantyālasyavacāṁsi vadanti, vicāradine taduttaramavaśyaṁ dātavyaṁ, ");
INSERT INTO sanias_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","yatastvaṁ svīyavacobhi rniraparādhaḥ svīyavacobhiśca sāparādho gaṇiṣyase| ");
INSERT INTO sanias_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","tadānīṁ katipayā upādhyāyāḥ phirūśinaśca jagaduḥ, he guro vayaṁ bhavattaḥ kiñcana lakṣma didṛkṣāmaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","tadā sa pratyuktavān, duṣṭo vyabhicārī ca vaṁśo lakṣma mṛgayate, kintu bhaviṣyadvādino yūnaso lakṣma vihāyānyat kimapi lakṣma te na pradarśayiṣyante| ");
INSERT INTO sanias_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","yato yūnam yathā tryahorātraṁ bṛhanmīnasya kukṣāvāsīt, tathā manujaputropi tryahorātraṁ medinyā madhye sthāsyati| ");
INSERT INTO sanias_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","aparaṁ nīnivīyā mānavā vicāradina etadvaṁśīyānāṁ pratikūlam utthāya tān doṣiṇaḥ kariṣyanti, yasmātte yūnasa upadeśāt manāṁsi parāvarttayāñcakrire, kintvatra yūnasopi gurutara eka āste| ");
INSERT INTO sanias_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","punaśca dakṣiṇadeśīyā rājñī vicāradina etadvaṁśīyānāṁ pratikūlamutthāya tān doṣiṇaḥ kariṣyati yataḥ sā rājñī sulemano vidyāyāḥ kathāṁ śrotuṁ medinyāḥ sīmna āgacchat, kintu sulemanopi gurutara eko jano'tra āste| ");
INSERT INTO sanias_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","aparaṁ manujād bahirgato 'pavitrabhūtaḥ śuṣkasthānena gatvā viśrāmaṁ gaveṣayati, kintu tadalabhamānaḥ sa vakti, yasmā; niketanād āgamaṁ, tadeva veśma pakāvṛtya yāmi| ");
INSERT INTO sanias_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","paścāt sa tat sthānam upasthāya tat śūnyaṁ mārjjitaṁ śobhitañca vilokya vrajan svatopi duṣṭatarān anyasaptabhūtān saṅginaḥ karoti| ");
INSERT INTO sanias_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","tataste tat sthānaṁ praviśya nivasanti, tena tasya manujasya śeṣadaśā pūrvvadaśātotīvāśubhā bhavati, eteṣāṁ duṣṭavaṁśyānāmapi tathaiva ghaṭiṣyate| ");
INSERT INTO sanias_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","mānavebhya etāsāṁ kathanāṁ kathanakāle tasya mātā sahajāśca tena sākaṁ kāñcit kathāṁ kathayituṁ vāñchanto bahireva sthitavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","tataḥ kaścit tasmai kathitavān, paśya tava jananī sahajāśca tvayā sākaṁ kāñcana kathāṁ kathayituṁ kāmayamānā bahistiṣṭhanti| ");
INSERT INTO sanias_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","kintu sa taṁ pratyavadat, mama kā jananī? ke vā mama sahajāḥ? ");
INSERT INTO sanias_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","paścāt śiṣyān prati karaṁ prasāryya kathitavān, paśya mama jananī mama sahajāścaite; ");
INSERT INTO sanias_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","yaḥ kaścit mama svargasthasya pituriṣṭaṁ karmma kurute, saeva mama bhrātā bhaginī jananī ca| ");
INSERT INTO sanias_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","aparañca tasmin dine yīśuḥ sadmano gatvā saritpate rodhasi samupaviveśa| ");
INSERT INTO sanias_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","tatra tatsannidhau bahujanānāṁ nivahopasthiteḥ sa taraṇimāruhya samupāviśat, tena mānavā rodhasi sthitavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","tadānīṁ sa dṛṣṭāntaistān itthaṁ bahuśa upadiṣṭavān| paśyata, kaścit kṛṣīvalo bījāni vaptuṁ bahirjagāma, ");
INSERT INTO sanias_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","tasya vapanakāle katipayabījeṣu mārgapārśve patiteṣu vihagāstāni bhakṣitavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","aparaṁ katipayabījeṣu stokamṛdyuktapāṣāṇe patiteṣu mṛdalpatvāt tatkṣaṇāt tānyaṅkuritāni, ");
INSERT INTO sanias_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","kintu ravāvudite dagdhāni teṣāṁ mūlāpraviṣṭatvāt śuṣkatāṁ gatāni ca| ");
INSERT INTO sanias_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","aparaṁ katipayabījeṣu kaṇṭakānāṁ madhye patiteṣu kaṇṭakānyedhitvā tāni jagrasuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","aparañca katipayabījāni urvvarāyāṁ patitāni; teṣāṁ madhye kānicit śataguṇāni kānicit ṣaṣṭiguṇāni kānicit triṁśaguṁṇāni phalāni phalitavanti| ");
INSERT INTO sanias_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","śrotuṁ yasya śrutī āsāte sa śṛṇuyāt| ");
INSERT INTO sanias_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","anantaraṁ śiṣyairāgatya so'pṛcchyata, bhavatā tebhyaḥ kuto dṛṣṭāntakathā kathyate? ");
INSERT INTO sanias_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","tataḥ sa pratyavadat, svargarājyasya nigūḍhāṁ kathāṁ vedituṁ yuṣmabhyaṁ sāmarthyamadāyi, kintu tebhyo nādāyi| ");
INSERT INTO sanias_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","yasmād yasyāntike varddhate, tasmāyeva dāyiṣyate, tasmāt tasya bāhulyaṁ bhaviṣyati, kintu yasyāntike na varddhate, tasya yat kiñcanāste, tadapi tasmād ādāyiṣyate| ");
INSERT INTO sanias_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","te paśyantopi na paśyanti, śṛṇvantopi na śṛṇvanti, budhyamānā api na budhyante ca, tasmāt tebhyo dṛṣṭāntakathā kathyate| ");
INSERT INTO sanias_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","yathā karṇaiḥ śroṣyatha yūyaṁ vai kintu yūyaṁ na bhotsyatha| netrairdrakṣyatha yūyañca parijñātuṁ na śakṣyatha| te mānuṣā yathā naiva paripaśyanti locanaiḥ| karṇai ryathā na śṛṇvanti na budhyante ca mānasaiḥ| vyāvarttiteṣu citteṣu kāle kutrāpi tairjanaiḥ| mattaste manujāḥ svasthā yathā naiva bhavanti ca| tathā teṣāṁ manuṣyāṇāṁ kriyante sthūlabuddhayaḥ| badhirībhūtakarṇāśca jātāśca mudritā dṛśaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","yadetāni vacanāni yiśayiyabhaviṣyadvādinā proktāni teṣu tāni phalanti| ");
INSERT INTO sanias_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","kintu yuṣmākaṁ nayanāni dhanyāni, yasmāt tāni vīkṣante; dhanyāśca yuṣmākaṁ śabdagrahāḥ, yasmāt tairākarṇyate| ");
INSERT INTO sanias_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","mayā yūyaṁ tathyaṁ vacāmi yuṣmābhi ryadyad vīkṣyate, tad bahavo bhaviṣyadvādino dhārmmikāśca mānavā didṛkṣantopi draṣṭuṁ nālabhanta, punaśca yūyaṁ yadyat śṛṇutha, tat te śuśrūṣamāṇā api śrotuṁ nālabhanta| ");
INSERT INTO sanias_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","kṛṣīvalīyadṛṣṭāntasyārthaṁ śṛṇuta| ");
INSERT INTO sanias_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","mārgapārśve bījānyuptāni tasyārtha eṣaḥ, yadā kaścit rājyasya kathāṁ niśamya na budhyate, tadā pāpātmāgatya tadīyamanasa uptāṁ kathāṁ haran nayati| ");
INSERT INTO sanias_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","aparaṁ pāṣāṇasthale bījānyuptāni tasyārtha eṣaḥ; kaścit kathāṁ śrutvaiva harṣacittena gṛhlāti, ");
INSERT INTO sanias_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","kintu tasya manasi mūlāpraviṣṭatvāt sa kiñcitkālamātraṁ sthirastiṣṭhati; paścāta tatkathākāraṇāt kopi klestāḍanā vā cet jāyate, tarhi sa tatkṣaṇād vighnameti| ");
INSERT INTO sanias_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","aparaṁ kaṇṭakānāṁ madhye bījānyuptāni tadartha eṣaḥ; kenacit kathāyāṁ śrutāyāṁ sāṁsārikacintābhi rbhrāntibhiśca sā grasyate, tena sā mā viphalā bhavati| ");
INSERT INTO sanias_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","aparam urvvarāyāṁ bījānyuptāni tadartha eṣaḥ; ye tāṁ kathāṁ śrutvā vudhyante, te phalitāḥ santaḥ kecit śataguṇāni kecita ṣaṣṭiguṇāni kecicca triṁśadguṇāni phalāni janayanti| ");
INSERT INTO sanias_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","anantaraṁ soparāmekāṁ dṛṣṭāntakathāmupasthāpya tebhyaḥ kathayāmāsa; svargīyarājyaṁ tādṛśena kenacid gṛhasthenopamīyate, yena svīyakṣetre praśastabījānyaupyanta| ");
INSERT INTO sanias_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","kintu kṣaṇadāyāṁ sakalalokeṣu supteṣu tasya ripurāgatya teṣāṁ godhūmabījānāṁ madhye vanyayavamabījānyuptvā vavrāja| ");
INSERT INTO sanias_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","tato yadā bījebhyo'ṅkarā jāyamānāḥ kaṇiśāni ghṛtavantaḥ; tadā vanyayavasānyapi dṛśyamānānyabhavan| ");
INSERT INTO sanias_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","tato gṛhasthasya dāseyā āgamya tasmai kathayāñcakruḥ, he maheccha, bhavatā kiṁ kṣetre bhadrabījāni naupyanta? tathātve vanyayavasāni kṛta āyan? ");
INSERT INTO sanias_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","tadānīṁ tena te pratigaditāḥ, kenacit ripuṇā karmmadamakāri| dāseyāḥ kathayāmāsuḥ, vayaṁ gatvā tānyutpāyya kṣipāmo bhavataḥ kīdṛśīcchā jāyate? ");
INSERT INTO sanias_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","tenāvādi, nahi, śaṅke'haṁ vanyayavasotpāṭanakāle yuṣmābhistaiḥ sākaṁ godhūmā apyutpāṭiṣyante| ");
INSERT INTO sanias_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ataḥ śsyakarttanakālaṁ yāvad ubhayānyapi saha varddhantāṁ, paścāt karttanakāle karttakān vakṣyāmi, yūyamādau vanyayavasāni saṁgṛhya dāhayituṁ vīṭikā badvvā sthāpayata; kintu sarvve godhūmā yuṣmābhi rbhāṇḍāgāraṁ nītvā sthāpyantām| ");
INSERT INTO sanias_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","anantaraṁ soparāmekāṁ dṛṣṭāntakathāmutthāpya tebhyaḥ kathitavān kaścinmanujaḥ sarṣapabījamekaṁ nītvā svakṣetra uvāpa| ");
INSERT INTO sanias_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","sarṣapabījaṁ sarvvasmād bījāt kṣudramapi sadaṅkuritaṁ sarvvasmāt śākāt bṛhad bhavati; sa tādṛśastaru rbhavati, yasya śākhāsu nabhasaḥ khagā āgatya nivasanti; svargīyarājyaṁ tādṛśasya sarṣapaikasya samam| ");
INSERT INTO sanias_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","punarapi sa upamākathāmekāṁ tebhyaḥ kathayāñcakāra; kācana yoṣit yat kiṇvamādāya droṇatrayamitagodhūmacūrṇānāṁ madhye sarvveṣāṁ miśrībhavanaparyyantaṁ samācchādya nidhattavatī, tatkiṇvamiva svargarājyaṁ| ");
INSERT INTO sanias_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","itthaṁ yīśu rmanujanivahānāṁ sannidhāvupamākathābhiretānyākhyānāni kathitavān upamāṁ vinā tebhyaḥ kimapi kathāṁ nākathayat| ");
INSERT INTO sanias_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","etena dṛṣṭāntīyena vākyena vyādāya vadanaṁ nijaṁ| ahaṁ prakāśayiṣyāmi guptavākyaṁ purābhavaṁ| yadetadvacanaṁ bhaviṣyadvādinā proktamāsīt, tat siddhamabhavat| ");
INSERT INTO sanias_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","sarvvān manujān visṛjya yīśau gṛhaṁ praviṣṭe tacchiṣyā āgatya yīśave kathitavantaḥ, kṣetrasya vanyayavasīyadṛṣṭāntakathām bhavāna asmān spaṣṭīkṛtya vadatu| ");
INSERT INTO sanias_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","tataḥ sa pratyuvāca, yena bhadrabījānyupyante sa manujaputraḥ, ");
INSERT INTO sanias_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","kṣetraṁ jagat, bhadrabījānī rājyasya santānāḥ, ");
INSERT INTO sanias_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","vanyayavasāni pāpātmanaḥ santānāḥ| yena ripuṇā tānyuptāni sa śayatānaḥ, karttanasamayaśca jagataḥ śeṣaḥ, karttakāḥ svargīyadūtāḥ| ");
INSERT INTO sanias_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","yathā vanyayavasāni saṁgṛhya dāhyante, tathā jagataḥ śeṣe bhaviṣyati; ");
INSERT INTO sanias_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","arthāt manujasutaḥ svāṁyadūtān preṣayiṣyati, tena te ca tasya rājyāt sarvvān vighnakāriṇo'dhārmmikalokāṁśca saṁgṛhya ");
INSERT INTO sanias_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","yatra rodanaṁ dantagharṣaṇañca bhavati, tatrāgnikuṇḍe nikṣepsyanti| ");
INSERT INTO sanias_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","tadānīṁ dhārmmikalokāḥ sveṣāṁ pitū rājye bhāskara̮iva tejasvino bhaviṣyanti| śrotuṁ yasya śrutī āsāte, ma śṛṇuyāt| ");
INSERT INTO sanias_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","aparañca kṣetramadhye nidhiṁ paśyan yo gopayati, tataḥ paraṁ sānando gatvā svīyasarvvasvaṁ vikrīya ttakṣetraṁ krīṇāti, sa iva svargarājyaṁ| ");
INSERT INTO sanias_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","anyañca yo vaṇik uttamāṁ muktāṁ gaveṣayan ");
INSERT INTO sanias_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","mahārghāṁ muktāṁ vilokya nijasarvvasvaṁ vikrīya tāṁ krīṇāti, sa iva svargarājyaṁ| ");
INSERT INTO sanias_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","punaśca samudro nikṣiptaḥ sarvvaprakāramīnasaṁgrāhyānāya̮iva svargarājyaṁ| ");
INSERT INTO sanias_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","tasmin ānāye pūrṇe janā yathā rodhasyuttolya samupaviśya praśastamīnān saṁgrahya bhājaneṣu nidadhate, kutsitān nikṣipanti; ");
INSERT INTO sanias_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","tathaiva jagataḥ śeṣe bhaviṣyati, phalataḥ svargīyadūtā āgatya puṇyavajjanānāṁ madhyāt pāpinaḥ pṛthak kṛtvā vahnikuṇḍe nikṣepsyanti, ");
INSERT INTO sanias_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","tatra rodanaṁ dantai rdantagharṣaṇañca bhaviṣyataḥ| ");
INSERT INTO sanias_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","yīśunā te pṛṣṭā yuṣmābhiḥ kimetānyākhyānānyabudhyanta? tadā te pratyavadan, satyaṁ prabho| ");
INSERT INTO sanias_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","tadānīṁ sa kathitavān, nijabhāṇḍāgārāt navīnapurātanāni vastūni nirgamayati yo gṛhasthaḥ sa iva svargarājyamadhi śikṣitāḥ svarva upadeṣṭāraḥ| ");
INSERT INTO sanias_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","anantaraṁ yīśuretāḥ sarvvā dṛṣṭāntakathāḥ samāpya tasmāt sthānāt pratasthe| aparaṁ svadeśamāgatya janān bhajanabhavana upadiṣṭavān; ");
INSERT INTO sanias_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","te vismayaṁ gatvā kathitavanta etasyaitādṛśaṁ jñānam āścaryyaṁ karmma ca kasmād ajāyata? ");
INSERT INTO sanias_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","kimayaṁ sūtradhārasya putro nahi? etasya mātu rnāma ca kiṁ mariyam nahi? yākub-yūṣaph-śimon-yihūdāśca kimetasya bhrātaro nahi? ");
INSERT INTO sanias_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","etasya bhaginyaśca kimasmākaṁ madhye na santi? tarhi kasmādayametāni labdhavān? itthaṁ sa teṣāṁ vighnarūpo babhūva; ");
INSERT INTO sanias_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","tato yīśunā nigaditaṁ svadeśīyajanānāṁ madhyaṁ vinā bhaviṣyadvādī kutrāpyanyatra nāsammānyo bhavatī| ");
INSERT INTO sanias_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","teṣāmaviśvāsahetoḥ sa tatra sthāne bahvāścaryyakarmmāṇi na kṛtavān| ");
INSERT INTO sanias_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","tadānīṁ rājā herod yīśo ryaśaḥ śrutvā nijadāseyān jagād, ");
INSERT INTO sanias_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","eṣa majjayitā yohan, pramitebhayastasyotthānāt tenetthamadbhutaṁ karmma prakāśyate| ");
INSERT INTO sanias_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","purā herod nijabhrātu: philipo jāyāyā herodīyāyā anurodhād yohanaṁ dhārayitvā baddhā kārāyāṁ sthāpitavān| ");
INSERT INTO sanias_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","yato yohan uktavān, etsayāḥ saṁgraho bhavato nocitaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","tasmāt nṛpatistaṁ hantumicchannapi lokebhyo vibhayāñcakāra; yataḥ sarvve yohanaṁ bhaviṣyadvādinaṁ menire| ");
INSERT INTO sanias_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","kintu herodo janmāhīyamaha upasthite herodīyāyā duhitā teṣāṁ samakṣaṁ nṛtitvā herodamaprīṇyat| ");
INSERT INTO sanias_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","tasmāt bhūpatiḥ śapathaṁ kurvvan iti pratyajñāsīt, tvayā yad yācyate, tadevāhaṁ dāsyāmi| ");
INSERT INTO sanias_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","sā kumārī svīyamātuḥ śikṣāṁ labdhā babhāṣe, majjayituryohana uttamāṅgaṁ bhājane samānīya mahyaṁ viśrāṇaya| ");
INSERT INTO sanias_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","tato rājā śuśoca, kintu bhojanāyopaviśatāṁ saṅgināṁ svakṛtaśapathasya cānurodhāt tat pradātuma ādideśa| ");
INSERT INTO sanias_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","paścāt kārāṁ prati naraṁ prahitya yohana uttamāṅgaṁ chittvā ");
INSERT INTO sanias_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","tat bhājana ānāyya tasyai kumāryyai vyaśrāṇayat, tataḥ sā svajananyāḥ samīpaṁ tannināya| ");
INSERT INTO sanias_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","paścāt yohanaḥ śiṣyā āgatya kāyaṁ nītvā śmaśāne sthāpayāmāsustato yīśoḥ sannidhiṁ vrajitvā tadvārttāṁ babhāṣire| ");
INSERT INTO sanias_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","anantaraṁ yīśuriti niśabhya nāvā nirjanasthānam ekākī gatavān, paścāt mānavāstat śrutvā nānānagarebhya āgatya padaistatpaścād īyuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","tadānīṁ yīśu rbahirāgatya mahāntaṁ jananivahaṁ nirīkṣya teṣu kāruṇikaḥ man teṣāṁ pīḍitajanān nirāmayān cakāra| ");
INSERT INTO sanias_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","tataḥ paraṁ sandhyāyāṁ śiṣyāstadantikamāgatya kathayāñcakruḥ, idaṁ nirjanasthānaṁ velāpyavasannā; tasmāt manujān svasvagrāmaṁ gantuṁ svārthaṁ bhakṣyāṇi kretuñca bhavān tān visṛjatu| ");
INSERT INTO sanias_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","kintu yīśustānavādīt, teṣāṁ gamane prayojanaṁ nāsti, yūyameva tān bhojayata| ");
INSERT INTO sanias_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","tadā te pratyavadan, asmākamatra pūpapañcakaṁ mīnadvayañcāste| ");
INSERT INTO sanias_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","tadānīṁ tenoktaṁ tāni madantikamānayata| ");
INSERT INTO sanias_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","anantaraṁ sa manujān yavasoparyyupaveṣṭum ājñāpayāmāsa; apara tat pūpapañcakaṁ mīnadvayañca gṛhlan svargaṁ prati nirīkṣyeśvarīyaguṇān anūdya bhaṁktvā śiṣyebhyo dattavān, śiṣyāśca lokebhyo daduḥ| ");
INSERT INTO sanias_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","tataḥ sarvve bhuktvā paritṛptavantaḥ, tatastadavaśiṣṭabhakṣyaiḥ pūrṇān dvādaśaḍalakān gṛhītavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","te bhoktāraḥ strīrbālakāṁśca vihāya prāyeṇa pañca sahasrāṇi pumāṁsa āsan| ");
INSERT INTO sanias_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","tadanantaraṁ yīśu rlokānāṁ visarjanakāle śiṣyān taraṇimāroḍhuṁ svāgre pāraṁ yātuñca gāḍhamādiṣṭavān| ");
INSERT INTO sanias_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","tato lokeṣu visṛṣṭeṣu sa vivikte prārthayituṁ girimekaṁ gatvā sandhyāṁ yāvat tatraikākī sthitavān| ");
INSERT INTO sanias_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","kintu tadānīṁ sammukhavātatvāt saritpate rmadhye taraṅgaistaraṇirdolāyamānābhavat| ");
INSERT INTO sanias_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","tadā sa yāminyāścaturthaprahare padbhyāṁ vrajan teṣāmantikaṁ gatavān| ");
INSERT INTO sanias_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","kintu śiṣyāstaṁ sāgaropari vrajantaṁ vilokya samudvignā jagaduḥ, eṣa bhūta iti śaṅkamānā uccaiḥ śabdāyāñcakrire ca| ");
INSERT INTO sanias_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","tadaiva yīśustānavadat, susthirā bhavata, mā bhaiṣṭa, eṣo'ham| ");
INSERT INTO sanias_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","tataḥ pitara ityuktavān, he prabho, yadi bhavāneva, tarhi māṁ bhavatsamīpaṁ yātumājñāpayatu| ");
INSERT INTO sanias_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","tataḥ tenādiṣṭaḥ pitarastaraṇito'varuhya yīśeाrantikaṁ prāptuṁ toyopari vavrāja| ");
INSERT INTO sanias_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","kintu pracaṇḍaṁ pavanaṁ vilokya bhayāt toye maṁktum ārebhe, tasmād uccaiḥ śabdāyamānaḥ kathitavān, he prabho, māmavatu| ");
INSERT INTO sanias_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","yīśustatkṣaṇāt karaṁ prasāryya taṁ dharan uktavān, ha stokapratyayin tvaṁ kutaḥ samaśethāḥ? ");
INSERT INTO sanias_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","anantaraṁ tayostaraṇimārūḍhayoḥ pavano nivavṛte| ");
INSERT INTO sanias_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","tadānīṁ ye taraṇyāmāsan, ta āgatya taṁ praṇabhya kathitavantaḥ, yathārthastvameveśvarasutaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","anantaraṁ pāraṁ prāpya te gineṣarannāmakaṁ nagaramupatasthuḥ, ");
INSERT INTO sanias_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","tadā tatratyā janā yīśuṁ paricīya taddeśsya caturdiśo vārttāṁ prahitya yatra yāvantaḥ pīḍitā āsan, tāvataeva tadantikamānayāmāsuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","aparaṁ tadīyavasanasya granthimātraṁ spraṣṭuṁ vinīya yāvanto janāstat sparśaṁ cakrire, te sarvvaeva nirāmayā babhūvuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","aparaṁ yirūśālamnagarīyāḥ katipayā adhyāpakāḥ phirūśinaśca yīśoḥ samīpamāgatya kathayāmāsuḥ, ");
INSERT INTO sanias_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","tava śiṣyāḥ kimartham aprakṣālitakarai rbhakṣitvā paramparāgataṁ prācīnānāṁ vyavahāraṁ laṅvante? ");
INSERT INTO sanias_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","tato yīśuḥ pratyuvāca, yūyaṁ paramparāgatācāreṇa kuta īśvarājñāṁ laṅvadhve| ");
INSERT INTO sanias_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","īśvara ityājñāpayat, tvaṁ nijapitarau saṁmanyethāḥ, yena ca nijapitarau nindyete, sa niścitaṁ mriyeta; ");
INSERT INTO sanias_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","kintu yūyaṁ vadatha, yaḥ svajanakaṁ svajananīṁ vā vākyamidaṁ vadati, yuvāṁ matto yallabhethe, tat nyavidyata, ");
INSERT INTO sanias_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","sa nijapitarau puna rna saṁmaṁsyate| itthaṁ yūyaṁ paramparāgatena sveṣāmācāreṇeśvarīyājñāṁ lumpatha| ");
INSERT INTO sanias_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","re kapaṭinaḥ sarvve yiśayiyo yuṣmānadhi bhaviṣyadvacanānyetāni samyag uktavān| ");
INSERT INTO sanias_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","vadanai rmanujā ete samāyānti madantikaṁ| tathādharai rmadīyañca mānaṁ kurvvanti te narāḥ| ");
INSERT INTO sanias_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","kintu teṣāṁ mano matto vidūraeva tiṣṭhati| śikṣayanto vidhīn nrājñā bhajante māṁ mudhaiva te| ");
INSERT INTO sanias_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","tato yīśu rlokān āhūya proktavān, yūyaṁ śrutvā budhyadhbaṁ| ");
INSERT INTO sanias_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","yanmukhaṁ praviśati, tat manujam amedhyaṁ na karoti, kintu yadāsyāt nirgacchati, tadeva mānuṣamamedhyī karotī| ");
INSERT INTO sanias_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","tadānīṁ śiṣyā āgatya tasmai kathayāñcakruḥ, etāṁ kathāṁ śrutvā phirūśino vyarajyanta, tat kiṁ bhavatā jñāyate? ");
INSERT INTO sanias_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","sa pratyavadat, mama svargasthaḥ pitā yaṁ kañcidaṅkuraṁ nāropayat, sa utpāvdyate| ");
INSERT INTO sanias_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","te tiṣṭhantu, te andhamanujānām andhamārgadarśakā eva; yadyandho'ndhaṁ panthānaṁ darśayati, tarhyubhau gartte patataḥ| ");
INSERT INTO sanias_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","tadā pitarastaṁ pratyavadat, dṛṣṭāntamimamasmān bodhayatu| ");
INSERT INTO sanias_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","yīśunā proktaṁ, yūyamadya yāvat kimabodhāḥ stha? ");
INSERT INTO sanias_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","kathāmimāṁ kiṁ na budhyadhbe ? yadāsyaṁ previśati, tad udare patan bahirniryāti, ");
INSERT INTO sanias_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","kintvāsyād yanniryāti, tad antaḥkaraṇāt niryātatvāt manujamamedhyaṁ karoti| ");
INSERT INTO sanias_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","yato'ntaḥkaraṇāt kucintā badhaḥ pāradārikatā veśyāgamanaṁ cairyyaṁ mithyāsākṣyam īśvaranindā caitāni sarvvāṇi niryyānti| ");
INSERT INTO sanias_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","etāni manuṣyamapavitrī kurvvanti kintvaprakṣālitakareṇa bhojanaṁ manujamamedhyaṁ na karoti| ");
INSERT INTO sanias_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","anantaraṁ yīśustasmāt sthānāt prasthāya sorasīdonnagarayoḥ sīmāmupatasyau| ");
INSERT INTO sanias_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","tadā tatsīmātaḥ kācit kinānīyā yoṣid āgatya tamuccairuvāca, he prabho dāyūdaḥ santāna, mamaikā duhitāste sā bhūtagrastā satī mahākleśaṁ prāpnoti mama dayasva| ");
INSERT INTO sanias_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","kintu yīśustāṁ kimapi noktavān, tataḥ śiṣyā āgatya taṁ nivedayāmāsuḥ, eṣā yoṣid asmākaṁ paścād uccairāhūyāgacchati, enāṁ visṛjatu| ");
INSERT INTO sanias_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","tadā sa pratyavadat, isrāyelgotrasya hāritameṣān vinā kasyāpyanyasya samīpaṁ nāhaṁ preṣitosmi| ");
INSERT INTO sanias_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","tataḥ sā nārīsamāgatya taṁ praṇamya jagāda, he prabho māmupakuru| ");
INSERT INTO sanias_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","sa uktavān, bālakānāṁ bhakṣyamādāya sārameyebhyo dānaṁ nocitaṁ| ");
INSERT INTO sanias_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","tadā sā babhāṣe, he prabho, tat satyaṁ, tathāpi prabho rbhañcād yaducchiṣṭaṁ patati, tat sārameyāḥ khādanti| ");
INSERT INTO sanias_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","tato yīśuḥ pratyavadat, he yoṣit, tava viśvāso mahān tasmāt tava manobhilaṣitaṁ sidyyatu, tena tasyāḥ kanyā tasminneva daṇḍe nirāmayābhavat| ");
INSERT INTO sanias_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","anantaraṁ yīśastasmāt sthānāt prasthāya gālīlsāgarasya sannidhimāgatya dharādharamāruhya tatropaviveśa| ");
INSERT INTO sanias_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","paścāt jananivaho bahūn khañcāndhamūkaśuṣkakaramānuṣān ādāya yīśoḥ samīpamāgatya taccaraṇāntike sthāpayāmāsuḥ, tataḥ sā tān nirāmayān akarot| ");
INSERT INTO sanias_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","itthaṁ mūkā vākyaṁ vadanti, śuṣkakarāḥ svāsthyamāyānti, paṅgavo gacchanti, andhā vīkṣante, iti vilokya lokā vismayaṁ manyamānā isrāyela īśvaraṁ dhanyaṁ babhāṣire| ");
INSERT INTO sanias_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","tadānīṁ yīśuḥ svaśiṣyān āhūya gaditavān, etajjananivaheṣu mama dayā jāyate, ete dinatrayaṁ mayā sākaṁ santi, eṣāṁ bhakṣyavastu ca kañcidapi nāsti, tasmādahametānakṛtāhārān na visrakṣyāmi, tathātve vartmamadhye klāmyeṣuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","tadā śiṣyā ūcuḥ, etasmin prāntaramadhya etāvato martyān tarpayituṁ vayaṁ kutra pūpān prāpsyāmaḥ? ");
INSERT INTO sanias_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","yīśurapṛcchat, yuṣmākaṁ nikaṭe kati pūpā āsate? ta ūcuḥ, saptapūpā alpāḥ kṣudramīnāśca santi| ");
INSERT INTO sanias_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","tadānīṁ sa lokanivahaṁ bhūmāvupaveṣṭum ādiśya ");
INSERT INTO sanias_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","tān saptapūpān mīnāṁśca gṛhlan īśvarīyaguṇān anūdya bhaṁktvā śiṣyebhyo dadau, śiṣyā lokebhyo daduḥ| ");
INSERT INTO sanias_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","tataḥ sarvve bhuktvā tṛptavantaḥ; tadavaśiṣṭabhakṣyeṇa saptaḍalakān paripūryya saṁjagṛhuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","te bhoktāro yoṣito bālakāṁśca vihāya prāyeṇa catuḥsahasrāṇi puruṣā āsan| ");
INSERT INTO sanias_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","tataḥ paraṁ sa jananivahaṁ visṛjya tarimāruhya magdalāpradeśaṁ gatavān| ");
INSERT INTO sanias_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","tadānīṁ phirūśinaḥ sidūkinaścāgatya taṁ parīkṣituṁ nabhamīyaṁ kiñcana lakṣma darśayituṁ tasmai nivedayāmāsuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","tataḥ sa uktavān, sandhyāyāṁ nabhaso raktatvād yūyaṁ vadatha, śvo nirmmalaṁ dinaṁ bhaviṣyati; ");
INSERT INTO sanias_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","prātaḥkāle ca nabhaso raktatvāt malinatvāñca vadatha, jhañbhśadya bhaviṣyati| he kapaṭino yadi yūyam antarīkṣasya lakṣma boddhuṁ śaknutha, tarhi kālasyaitasya lakṣma kathaṁ boddhuṁ na śaknutha? ");
INSERT INTO sanias_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","etatkālasya duṣṭo vyabhicārī ca vaṁśo lakṣma gaveṣayati, kintu yūnaso bhaviṣyadvādino lakṣma vinānyat kimapi lakṣma tān na darśayiyyate| tadānīṁ sa tān vihāya pratasthe| ");
INSERT INTO sanias_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","anantaramanyapāragamanakāle tasya śiṣyāḥ pūpamānetuṁ vismṛtavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","yīśustānavādīt, yūyaṁ phirūśināṁ sidūkināñca kiṇvaṁ prati sāvadhānāḥ satarkāśca bhavata| ");
INSERT INTO sanias_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","tena te parasparaṁ vivicya kathayitumārebhire, vayaṁ pūpānānetuṁ vismṛtavanta etatkāraṇād iti kathayati| ");
INSERT INTO sanias_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","kintu yīśustadvijñāya tānavocat, he stokaviśvāsino yūyaṁ pūpānānayanamadhi kutaḥ parasparametad viviṁkya? ");
INSERT INTO sanias_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","yuṣmābhiḥ kimadyāpi na jñāyate? pañcabhiḥ pūpaiḥ pañcasahasrapuruṣeṣu bhojiteṣu bhakṣyocchiṣṭapūrṇān kati ḍalakān samagṛhlītaṁ; ");
INSERT INTO sanias_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","tathā saptabhiḥ pūpaiścatuḥsahasrapuruṣeṣu bhejiteṣu kati ḍalakān samagṛhlīta, tat kiṁ yuṣmābhirna smaryyate? ");
INSERT INTO sanias_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","tasmāt phirūśināṁ sidūkināñca kiṇvaṁ prati sāvadhānāstiṣṭhata, kathāmimām ahaṁ pūpānadhi nākathayaṁ, etad yūyaṁ kuto na budhyadhve? ");
INSERT INTO sanias_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","tadānīṁ pūpakiṇvaṁ prati sāvadhānāstiṣṭhateti noktvā phirūśināṁ sidūkināñca upadeśaṁ prati sāvadhānāstiṣṭhateti kathitavān, iti tairabodhi| ");
INSERT INTO sanias_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","aparañca yīśuḥ kaisariyā-philipipradeśamāgatya śiṣyān apṛcchat, yo'haṁ manujasutaḥ so'haṁ kaḥ? lokairahaṁ kimucye? ");
INSERT INTO sanias_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","tadānīṁ te kathitavantaḥ, kecid vadanti tvaṁ majjayitā yohan, kecidvadanti, tvam eliyaḥ, kecicca vadanti, tvaṁ yirimiyo vā kaścid bhaviṣyadvādīti| ");
INSERT INTO sanias_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","paścāt sa tān papraccha, yūyaṁ māṁ kaṁ vadatha? tataḥ śimon pitara uvāca, ");
INSERT INTO sanias_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","tvamamareśvarasyābhiṣiktaputraḥ| ");
INSERT INTO sanias_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","tato yīśuḥ kathitavān, he yūnasaḥ putra śimon tvaṁ dhanyaḥ; yataḥ kopi anujastvayyetajjñānaṁ nodapādayat, kintu mama svargasyaḥ pitodapādayat| ");
INSERT INTO sanias_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","ato'haṁ tvāṁ vadāmi, tvaṁ pitaraḥ (prastaraḥ) ahañca tasya prastarasyopari svamaṇḍalīṁ nirmmāsyāmi, tena nirayo balāt tāṁ parājetuṁ na śakṣyati| ");
INSERT INTO sanias_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","ahaṁ tubhyaṁ svargīyarājyasya kuñjikāṁ dāsyāmi, tena yat kiñcana tvaṁ pṛthivyāṁ bhaṁtsyasi tatsvarge bhaṁtsyate, yacca kiñcana mahyāṁ mokṣyasi tat svarge mokṣyate| ");
INSERT INTO sanias_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","paścāt sa śiṣyānādiśat, ahamabhiṣikto yīśuriti kathāṁ kasmaicidapi yūyaṁ mā kathayata| ");
INSERT INTO sanias_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","anyañca yirūśālamnagaraṁ gatvā prācīnalokebhyaḥ pradhānayājakebhya upādhyāyebhyaśca bahuduḥkhabhogastai rhatatvaṁ tṛtīyadine punarutthānañca mamāvaśyakam etāḥ kathā yīśustatkālamārabhya śiṣyān jñāpayitum ārabdhavān| ");
INSERT INTO sanias_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","tadānīṁ pitarastasya karaṁ ghṛtvā tarjayitvā kathayitumārabdhavān, he prabho, tat tvatto dūraṁ yātu, tvāṁ prati kadāpi na ghaṭiṣyate| ");
INSERT INTO sanias_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","kintu sa vadanaṁ parāvartya pitaraṁ jagāda, he vighnakārin, matsammukhād dūrībhava, tvaṁ māṁ bādhase, īśvarīyakāryyāt mānuṣīyakāryyaṁ tubhyaṁ rocate| ");
INSERT INTO sanias_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","anantaraṁ yīśuḥ svīyaśiṣyān uktavān yaḥ kaścit mama paścādgāmī bhavitum icchati, sa svaṁ dāmyatu, tathā svakruśaṁ gṛhlan matpaścādāyātu| ");
INSERT INTO sanias_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","yato yaḥ prāṇān rakṣitumicchati, sa tān hārayiṣyati, kintu yo madarthaṁ nijaprāṇān hārayati, sa tān prāpsyati| ");
INSERT INTO sanias_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","mānuṣo yadi sarvvaṁ jagat labhate nijapraṇān hārayati, tarhi tasya ko lābhaḥ? manujo nijaprāṇānāṁ vinimayena vā kiṁ dātuṁ śaknoti? ");
INSERT INTO sanias_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","manujasutaḥ svadūtaiḥ sākaṁ pituḥ prabhāveṇāgamiṣyati; tadā pratimanujaṁ svasvakarmmānusārāt phalaṁ dāsyati| ");
INSERT INTO sanias_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","ahaṁ yuṣmān tathyaṁ vacmi, sarājyaṁ manujasutam āgataṁ na paśyanto mṛtyuṁ na svādiṣyanti, etādṛśāḥ katipayajanā atrāpi daṇḍāyamānāḥ santi| ");
INSERT INTO sanias_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","anantaraṁ ṣaḍdinebhyaḥ paraṁ yīśuḥ pitaraṁ yākūbaṁ tatsahajaṁ yohanañca gṛhlan uccādre rviviktasthānam āgatya teṣāṁ samakṣaṁ rūpamanyat dadhāra| ");
INSERT INTO sanias_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","tena tadāsyaṁ tejasvi, tadābharaṇam ālokavat pāṇḍaramabhavat| ");
INSERT INTO sanias_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","anyacca tena sākaṁ saṁlapantau mūsā eliyaśca tebhyo darśanaṁ dadatuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","tadānīṁ pitaro yīśuṁ jagāda, he prabho sthitiratrāsmākaṁ śubhā, yadi bhavatānumanyate, tarhi bhavadarthamekaṁ mūsārthamekam eliyārthañcaikam iti trīṇi dūṣyāṇi nirmmama| ");
INSERT INTO sanias_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","etatkathanakāla eka ujjavalaḥ payodasteṣāmupari chāyāṁ kṛtavān, vāridād eṣā nabhasīyā vāg babhūva, mamāyaṁ priyaḥ putraḥ, asmin mama mahāsantoṣa etasya vākyaṁ yūyaṁ niśāmayata| ");
INSERT INTO sanias_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","kintu vācametāṁ śṛṇvantaeva śiṣyā mṛśaṁ śaṅkamānā nyubjā nyapatan| ");
INSERT INTO sanias_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","tadā yīśurāgatya teṣāṁ gātrāṇi spṛśan uvāca, uttiṣṭhata, mā bhaiṣṭa| ");
INSERT INTO sanias_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","tadānīṁ netrāṇyunmīlya yīśuṁ vinā kamapi na dadṛśuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","tataḥ param adreravarohaṇakāle yīśustān ityādideśa, manujasutasya mṛtānāṁ madhyādutthānaṁ yāvanna jāyate, tāvat yuṣmābhiretaddarśanaṁ kasmaicidapi na kathayitavyaṁ| ");
INSERT INTO sanias_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","tadā śiṣyāstaṁ papracchuḥ, prathamam eliya āyāsyatīti kuta upādhyāyairucyate? ");
INSERT INTO sanias_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","tato yīśuḥ pratyavādīt, eliyaḥ prāgetya sarvvāṇi sādhayiṣyatīti satyaṁ, ");
INSERT INTO sanias_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","kintvahaṁ yuṣmān vacmi, eliya etya gataḥ, te tamaparicitya tasmin yathecchaṁ vyavajahuḥ; manujasutenāpi teṣāmantike tādṛg duḥkhaṁ bhoktavyaṁ| ");
INSERT INTO sanias_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","tadānīṁ sa majjayitāraṁ yohanamadhi kathāmetāṁ vyāhṛtavān, itthaṁ tacchiṣyā bubudhire| ");
INSERT INTO sanias_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","paścāt teṣu jananivahasyāntikamāgateṣu kaścit manujastadantikametya jānūnī pātayitvā kathitavān, ");
INSERT INTO sanias_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","he prabho, matputraṁ prati kṛpāṁ vidadhātu, sopasmārāmayena bhṛśaṁ vyathitaḥ san punaḥ puna rvahnau muhu rjalamadhye patati| ");
INSERT INTO sanias_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","tasmād bhavataḥ śiṣyāṇāṁ samīpe tamānayaṁ kintu te taṁ svāsthaṁ karttuṁ na śaktāḥ| ");
INSERT INTO sanias_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","tadā yīśuḥ kathitavān re aviśvāsinaḥ, re vipathagāminaḥ, punaḥ katikālān ahaṁ yuṣmākaṁ sannidhau sthāsyāmi? katikālān vā yuṣmān sahiṣye? tamatra mamāntikamānayata| ");
INSERT INTO sanias_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","paścād yīśunā tarjataeva sa bhūtastaṁ vihāya gatavān, taddaṇḍaeva sa bālako nirāmayo'bhūt| ");
INSERT INTO sanias_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","tataḥ śiṣyā guptaṁ yīśumupāgatya babhāṣire, kuto vayaṁ taṁ bhūtaṁ tyājayituṁ na śaktāḥ? ");
INSERT INTO sanias_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","yīśunā te proktāḥ, yuṣmākamapratyayāt; ");
INSERT INTO sanias_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","yuṣmānahaṁ tathyaṁ vacmi yadi yuṣmākaṁ sarṣapaikamātropi viśvāso jāyate, tarhi yuṣmābhirasmin śaile tvamitaḥ sthānāt tat sthānaṁ yāhīti brūte sa tadaiva caliṣyati, yuṣmākaṁ kimapyasādhyañca karmma na sthāsyāti| kintu prārthanopavāsau vinaitādṛśo bhūto na tyājyeta| ");
INSERT INTO sanias_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","aparaṁ teṣāṁ gālīlpradeśe bhramaṇakāle yīśunā te gaditāḥ, manujasuto janānāṁ kareṣu samarpayiṣyate tai rhaniṣyate ca, ");
INSERT INTO sanias_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","kintu tṛtīye'hi्na ma utthāpiṣyate, tena te bhṛśaṁ duḥkhitā babhūvaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","tadanantaraṁ teṣu kapharnāhūmnagaramāgateṣu karasaṁgrāhiṇaḥ pitarāntikamāgatya papracchuḥ, yuṣmākaṁ guruḥ kiṁ mandirārthaṁ karaṁ na dadāti? tataḥ pitaraḥ kathitavān dadāti| ");
INSERT INTO sanias_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","tatastasmin gṛhamadhyamāgate tasya kathākathanāt pūrvvameva yīśuruvāca, he śimon, medinyā rājānaḥ svasvāpatyebhyaḥ kiṁ videśibhyaḥ kebhyaḥ karaṁ gṛhlanti? atra tvaṁ kiṁ budhyase? tataḥ pitara uktavān, videśibhyaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","tadā yīśuruktavān, tarhi santānā muktāḥ santi| ");
INSERT INTO sanias_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","tathāpi yathāsmābhisteṣāmantarāyo na janyate, tatkṛte jaladhestīraṁ gatvā vaḍiśaṁ kṣipa, tenādau yo mīna utthāsyati, taṁ ghṛtvā tanmukhe mocite tolakaikaṁ rūpyaṁ prāpsyasi, tad gṛhītvā tava mama ca kṛte tebhyo dehi| ");
INSERT INTO sanias_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","tadānīṁ śiṣyā yīśoḥ samīpamāgatya pṛṣṭavantaḥ svargarājye kaḥ śreṣṭhaḥ? ");
INSERT INTO sanias_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","tato yīśuḥ kṣudramekaṁ bālakaṁ svasamīpamānīya teṣāṁ madhye nidhāya jagāda, ");
INSERT INTO sanias_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","yuṣmānahaṁ satyaṁ bravīmi, yūyaṁ manovinimayena kṣudrabālavat na santaḥ svargarājyaṁ praveṣṭuṁ na śaknutha| ");
INSERT INTO sanias_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","yaḥ kaścid etasya kṣudrabālakasya samamātmānaṁ namrīkaroti, saeva svargarājaye śreṣṭhaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","yaḥ kaścid etādṛśaṁ kṣudrabālakamekaṁ mama nāmni gṛhlāti, sa māmeva gṛhlāti| ");
INSERT INTO sanias_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","kintu yo jano mayi kṛtaviśvāsānāmeteṣāṁ kṣudraprāṇinām ekasyāpi vidhniṁ janayati, kaṇṭhabaddhapeṣaṇīkasya tasya sāgarāgādhajale majjanaṁ śreyaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","vighnāt jagataḥ santāpo bhaviṣyati, vighno'vaśyaṁ janayiṣyate, kintu yena manujena vighno janiṣyate tasyaiva santāpo bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","tasmāt tava karaścaraṇo vā yadi tvāṁ bādhate, tarhi taṁ chittvā nikṣipa, dvikarasya dvipadasya vā tavānaptavahnau nikṣepāt, khañjasya vā chinnahastasya tava jīvane praveśo varaṁ| ");
INSERT INTO sanias_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","aparaṁ tava netraṁ yadi tvāṁ bādhate, tarhi tadapyutpāvya nikṣipa, dvinetrasya narakāgnau nikṣepāt kāṇasya tava jīvane praveśo varaṁ| ");
INSERT INTO sanias_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","tasmādavadhaddhaṁ, eteṣāṁ kṣudraprāṇinām ekamapi mā tucchīkuruta, ");
INSERT INTO sanias_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","yato yuṣmānahaṁ tathyaṁ bravīmi, svarge teṣāṁ dūtā mama svargasthasya piturāsyaṁ nityaṁ paśyanti| evaṁ ye ye hāritāstān rakṣituṁ manujaputra āgacchat| ");
INSERT INTO sanias_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","yūyamatra kiṁ viviṁgghve? kasyacid yadi śataṁ meṣāḥ santi, teṣāmeko hāryyate ca, tarhi sa ekonaśataṁ meṣān vihāya parvvataṁ gatvā taṁ hāritamekaṁ kiṁ na mṛgayate? ");
INSERT INTO sanias_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","yadi ca kadācit tanmeṣoddeśaṁ lamate, tarhi yuṣmānahaṁ satyaṁ kathayāmi, so'vipathagāmibhya ekonaśatameṣebhyopi tadekahetoradhikam āhlādate| ");
INSERT INTO sanias_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","tadvad eteṣāṁ kṣudraprāeिnām ekopi naśyatīti yuṣmākaṁ svargasthapitu rnābhimatam| ");
INSERT INTO sanias_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","yadyapi tava bhrātā tvayi kimapyaparādhyati, tarhi gatvā yuvayordvayoḥ sthitayostasyāparādhaṁ taṁ jñāpaya| tatra sa yadi tava vākyaṁ śṛṇoti, tarhi tvaṁ svabhrātaraṁ prāptavān, ");
INSERT INTO sanias_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","kintu yadi na śṛṇoti, tarhi dvābhyāṁ tribhi rvā sākṣībhiḥ sarvvaṁ vākyaṁ yathā niścitaṁ jāyate, tadartham ekaṁ dvau vā sākṣiṇau gṛhītvā yāhi| ");
INSERT INTO sanias_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","tena sa yadi tayo rvākyaṁ na mānyate, tarhi samājaṁ tajjñāpaya, kintu yadi samājasyāpi vākyaṁ na mānyate,tarhi sa tava samīpe devapūjaka̮iva caṇḍāla̮iva ca bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","ahaṁ yuṣmān satyaṁ vadāmi, yuṣmābhiḥ pṛthivyāṁ yad badhyate tat svarge bhaṁtsyate; medinyāṁ yat bhocyate, svarge'pi tat mokṣyate| ");
INSERT INTO sanias_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","punarahaṁ yuṣmān vadāmi, medinyāṁ yuṣmākaṁ yadi dvāvekavākyībhūya kiñcit prārthayete, tarhi mama svargasthapitrā tat tayoḥ kṛte sampannaṁ bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","yato yatra dvau trayo vā mama nānni milanti, tatraivāhaṁ teṣāṁ madhye'smi| ");
INSERT INTO sanias_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","tadānīṁ pitarastatsamīpamāgatya kathitavān he prabho, mama bhrātā mama yadyaparādhyati, tarhi taṁ katikṛtvaḥ kṣamiṣye? ");
INSERT INTO sanias_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","kiṁ saptakṛtvaḥ? yīśustaṁ jagāda, tvāṁ kevalaṁ saptakṛtvo yāvat na vadāmi, kintu saptatyā guṇitaṁ saptakṛtvo yāvat| ");
INSERT INTO sanias_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","aparaṁ nijadāsaiḥ saha jigaṇayiṣuḥ kaścid rājeva svargarājayaṁ| ");
INSERT INTO sanias_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ārabdhe tasmin gaṇane sārddhasahasramudrāpūritānāṁ daśasahasrapuṭakānām eko'ghamarṇastatsamakṣamānāyi| ");
INSERT INTO sanias_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","tasya pariśodhanāya dravyābhāvāt pariśodhanārthaṁ sa tadīyabhāryyāputrādisarvvasvañca vikrīyatāmiti tatprabhurādideśa| ");
INSERT INTO sanias_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","tena sa dāsastasya pādayoḥ patan praṇamya kathitavān , he prabho bhavatā ghairyye kṛte mayā sarvvaṁ pariśodhiṣyate| ");
INSERT INTO sanias_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","tadānīṁ dāsasya prabhuḥ sakaruṇaḥ san sakalarṇaṁ kṣamitvā taṁ tatyāja| ");
INSERT INTO sanias_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","kintu tasmin dāse bahi ryāte, tasya śataṁ mudrācaturthāṁśān yo dhārayati, taṁ sahadāsaṁ dṛṣdvā tasya kaṇṭhaṁ niṣpīḍya gaditavān, mama yat prāpyaṁ tat pariśodhaya| ");
INSERT INTO sanias_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","tadā tasya sahadāsastatpādayoḥ patitvā vinīya babhāṣe, tvayā dhairyye kṛte mayā sarvvaṁ pariśodhiṣyate| ");
INSERT INTO sanias_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","tathāpi sa tat nāṅagīkṛtya yāvat sarvvamṛṇaṁ na pariśodhitavān tāvat taṁ kārāyāṁ sthāpayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","tadā tasya sahadāsāstasyaitādṛg ācaraṇaṁ vilokya prabhoḥ samīpaṁ gatvā sarvvaṁ vṛttāntaṁ nivedayāmāsuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","tadā tasya prabhustamāhūya jagāda, re duṣṭa dāsa, tvayā matsannidhau prārthite mayā tava sarvvamṛṇaṁ tyaktaṁ; ");
INSERT INTO sanias_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","yathā cāhaṁ tvayi karuṇāṁ kṛtavān, tathaiva tvatsahadāse karuṇākaraṇaṁ kiṁ tava nocitaṁ? ");
INSERT INTO sanias_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","iti kathayitvā tasya prabhuḥ kruddhyan nijaprāpyaṁ yāvat sa na pariśodhitavān, tāvat prahārakānāṁ kareṣu taṁ samarpitavān| ");
INSERT INTO sanias_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","yadi yūyaṁ svāntaḥkaraṇaiḥ svasvasahajānām aparādhān na kṣamadhve, tarhi mama svargasyaḥ pitāpi yuṣmān pratītthaṁ kariṣyati| ");
INSERT INTO sanias_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","anantaram etāsu kathāsu samāptāsu yīśu rgālīlapradeśāt prasthāya yardantīrasthaṁ yihūdāpradeśaṁ prāptaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","tadā tatpaścāt jananivahe gate sa tatra tān nirāmayān akarot| ");
INSERT INTO sanias_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","tadanantaraṁ phirūśinastatsamīpamāgatya pārīkṣituṁ taṁ papracchuḥ, kasmādapi kāraṇāt nareṇa svajāyā parityājyā na vā? ");
INSERT INTO sanias_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","sa pratyuvāca, prathamam īśvaro naratvena nārītvena ca manujān sasarja, tasmāt kathitavān, ");
INSERT INTO sanias_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","mānuṣaḥ svapitarau parityajya svapatnyām āsakṣyate, tau dvau janāvekāṅgau bhaviṣyataḥ, kimetad yuṣmābhi rna paṭhitam? ");
INSERT INTO sanias_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","atastau puna rna dvau tayorekāṅgatvaṁ jātaṁ, īśvareṇa yacca samayujyata, manujo na tad bhindyāt| ");
INSERT INTO sanias_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","tadānīṁ te taṁ pratyavadan, tathātve tyājyapatraṁ dattvā svāṁ svāṁ jāyāṁ tyaktuṁ vyavasthāṁ mūsāḥ kathaṁ lilekha? ");
INSERT INTO sanias_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","tataḥ sa kathitavān, yuṣmākaṁ manasāṁ kāṭhinyād yuṣmān svāṁ svāṁ jāyāṁ tyaktum anvamanyata kintu prathamād eṣo vidhirnāsīt| ");
INSERT INTO sanias_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","ato yuṣmānahaṁ vadāmi, vyabhicāraṁ vinā yo nijajāyāṁ tyajet anyāñca vivahet, sa paradārān gacchati; yaśca tyaktāṁ nārīṁ vivahati sopi paradāreṣu ramate| ");
INSERT INTO sanias_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","tadā tasya śiṣyāstaṁ babhāṣire, yadi svajāyayā sākaṁ puṁsa etādṛk sambandho jāyate, tarhi vivahanameva na bhadraṁ| ");
INSERT INTO sanias_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","tataḥ sa uktavān, yebhyastatsāmarthyaṁ ādāyi, tān vinānyaḥ kopi manuja etanmataṁ grahītuṁ na śaknoti| ");
INSERT INTO sanias_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","katipayā jananaklībaḥ katipayā narakṛtaklībaḥ svargarājyāya katipayāḥ svakṛtaklībāśca santi, ye grahītuṁ śaknuvanti te gṛhlantu| ");
INSERT INTO sanias_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","aparam yathā sa śiśūnāṁ gātreṣu hastaṁ datvā prārthayate, tadarthaṁ tatsamīṁpaṁ śiśava ānīyanta, tata ānayitṛn śiṣyāstiraskṛtavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","kintu yīśuruvāca, śiśavo madantikam āgacchantu, tān mā vārayata, etādṛśāṁ śiśūnāmeva svargarājyaṁ| ");
INSERT INTO sanias_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","tataḥ sa teṣāṁ gātreṣu hastaṁ datvā tasmāt sthānāt pratasthe| ");
INSERT INTO sanias_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","aparam eka āgatya taṁ papraccha, he paramaguro, anantāyuḥ prāptuṁ mayā kiṁ kiṁ satkarmma karttavyaṁ? ");
INSERT INTO sanias_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","tataḥ sa uvāca, māṁ paramaṁ kuto vadasi? vineścaraṁ na kopi paramaḥ, kintu yadyanantāyuḥ prāptuṁ vāñchasi, tarhyājñāḥ pālaya| ");
INSERT INTO sanias_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","tadā sa pṛṣṭavān, kāḥ kā ājñāḥ? tato yīśuḥ kathitavān, naraṁ mā hanyāḥ, paradārān mā gaccheḥ, mā corayeḥ, mṛṣāsākṣyaṁ mā dadyāḥ, ");
INSERT INTO sanias_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","nijapitarau saṁmanyasva, svasamīpavāsini svavat prema kuru| ");
INSERT INTO sanias_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","sa yuvā kathitavān, ā bālyād etāḥ pālayāmi, idānīṁ kiṁ nyūnamāste? ");
INSERT INTO sanias_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","tato yīśuravadat, yadi siddho bhavituṁ vāñchasi, tarhi gatvā nijasarvvasvaṁ vikrīya daridrebhyo vitara, tataḥ svarge vittaṁ lapsyase; āgaccha, matpaścādvarttī ca bhava| ");
INSERT INTO sanias_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","etāṁ vācaṁ śrutvā sa yuvā svīyabahusampatte rviṣaṇaḥ san calitavān| ");
INSERT INTO sanias_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","tadā yīśuḥ svaśiṣyān avadat, dhanināṁ svargarājyapraveśo mahāduṣkara iti yuṣmānahaṁ tathyaṁ vadāmi| ");
INSERT INTO sanias_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","punarapi yuṣmānahaṁ vadāmi, dhanināṁ svargarājyapraveśāt sūcīchidreṇa mahāṅgagamanaṁ sukaraṁ| ");
INSERT INTO sanias_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","iti vākyaṁ niśamya śiṣyā aticamatkṛtya kathayāmāsuḥ; tarhi kasya paritrāṇaṁ bhavituṁ śaknoti? ");
INSERT INTO sanias_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","tadā sa tān dṛṣdvā kathayāmāsa, tat mānuṣāṇāmaśakyaṁ bhavati, kintvīśvarasya sarvvaṁ śakyam| ");
INSERT INTO sanias_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","tadā pitarastaṁ gaditavān, paśya, vayaṁ sarvvaṁ parityajya bhavataḥ paścādvarttino 'bhavāma; vayaṁ kiṁ prāpsyāmaḥ? ");
INSERT INTO sanias_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","tato yīśuḥ kathitavān, yuṣmānahaṁ tathyaṁ vadāmi, yūyaṁ mama paścādvarttino jātā iti kāraṇāt navīnasṛṣṭikāle yadā manujasutaḥ svīyaiścaryyasiṁhāsana upavekṣyati, tadā yūyamapi dvādaśasiṁhāsaneṣūpaviśya isrāyelīyadvādaśavaṁśānāṁ vicāraṁ kariṣyatha| ");
INSERT INTO sanias_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","anyacca yaḥ kaścit mama nāmakāraṇāt gṛhaṁ vā bhrātaraṁ vā bhaginīṁ vā pitaraṁ vā mātaraṁ vā jāyāṁ vā bālakaṁ vā bhūmiṁ parityajati, sa teṣāṁ śataguṇaṁ lapsyate, anantāyumo'dhikāritvañca prāpsyati| ");
INSERT INTO sanias_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","kintu agrīyā aneke janāḥ paścāt, paścātīyāścāneke lokā agre bhaviṣyanti| ");
INSERT INTO sanias_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","svargarājyam etādṛśā kenacid gṛhasyena samaṁ, yo'tiprabhāte nijadrākṣākṣetre kṛṣakān niyoktuṁ gatavān| ");
INSERT INTO sanias_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","paścāt taiḥ sākaṁ dinaikabhṛtiṁ mudrācaturthāṁśaṁ nirūpya tān drākṣākṣetraṁ prerayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","anantaraṁ praharaikavelāyāṁ gatvā haṭṭe katipayān niṣkarmmakān vilokya tānavadat, ");
INSERT INTO sanias_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","yūyamapi mama drākṣākṣetraṁ yāta, yuṣmabhyamahaṁ yogyabhṛtiṁ dāsyāmi, tataste vavrajuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","punaśca sa dvitīyatṛtīyayoḥ praharayo rbahi rgatvā tathaiva kṛtavān| ");
INSERT INTO sanias_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","tato daṇḍadvayāvaśiṣṭāyāṁ velāyāṁ bahi rgatvāparān katipayajanān niṣkarmmakān vilokya pṛṣṭavān, yūyaṁ kimartham atra sarvvaṁ dinaṁ niṣkarmmāṇastiṣṭhatha? ");
INSERT INTO sanias_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","te pratyavadan, asmān na kopi karmamaṇi niyuṁkte| tadānīṁ sa kathitavān, yūyamapi mama drākṣākṣetraṁ yāta, tena yogyāṁ bhṛtiṁ lapsyatha| ");
INSERT INTO sanias_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","tadanantaraṁ sandhyāyāṁ satyāṁ saeva drākṣākṣetrapatiradhyakṣaṁ gadivān, kṛṣakān āhūya śeṣajanamārabhya prathamaṁ yāvat tebhyo bhṛtiṁ dehi| ");
INSERT INTO sanias_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","tena ye daṇḍadvayāvasthite samāyātāsteṣām ekaiko jano mudrācaturthāṁśaṁ prāpnot| ");
INSERT INTO sanias_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","tadānīṁ prathamaniyuktā janā āgatyānumitavanto vayamadhikaṁ prapsyāmaḥ, kintu tairapi mudrācaturthāṁśo'lābhi| ");
INSERT INTO sanias_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","tataste taṁ gṛhītvā tena kṣetrapatinā sākaṁ vāgyuddhaṁ kurvvantaḥ kathayāmāsuḥ, ");
INSERT INTO sanias_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","vayaṁ kṛtsnaṁ dinaṁ tāpakleśau soḍhavantaḥ, kintu paścātāyā se janā daṇḍadvayamātraṁ pariśrāntavantaste'smābhiḥ samānāṁśāḥ kṛtāḥ| ");
INSERT INTO sanias_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","tataḥ sa teṣāmekaṁ pratyuvāca, he vatsa, mayā tvāṁ prati kopyanyāyo na kṛtaḥ kiṁ tvayā matsamakṣaṁ mudrācaturthāṁśo nāṅgīkṛtaḥ? ");
INSERT INTO sanias_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","tasmāt tava yat prāpyaṁ tadādāya yāhi, tubhyaṁ yati, paścātīyaniyuktalokāyāpi tati dātumicchāmi| ");
INSERT INTO sanias_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","svecchayā nijadravyavyavaharaṇaṁ kiṁ mayā na karttavyaṁ? mama dātṛtvāt tvayā kim īrṣyādṛṣṭiḥ kriyate? ");
INSERT INTO sanias_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","ittham agrīyalokāḥ paścatīyā bhaviṣyanti, paścātīyajanāścagrīyā bhaviṣyanti, ahūtā bahavaḥ kintvalpe manobhilaṣitāḥ| ");
INSERT INTO sanias_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","tadanantaraṁ yīśu ryirūśālamnagaraṁ gacchan mārgamadhye śiṣyān ekānte vabhāṣe, ");
INSERT INTO sanias_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","paśya vayaṁ yirūśālamnagaraṁ yāmaḥ, tatra pradhānayājakādhyāpakānāṁ kareṣu manuṣyaputraḥ samarpiṣyate; ");
INSERT INTO sanias_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","te ca taṁ hantumājñāpya tiraskṛtya vetreṇa praharttuṁ kruśe dhātayituñcānyadeśīyānāṁ kareṣu samarpayiṣyanti, kintu sa tṛtīyadivase śmaśānād utthāpiṣyate| ");
INSERT INTO sanias_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","tadānīṁ sivadīyasya nārī svaputrāvādāya yīśoḥ samīpam etya praṇamya kañcanānugrahaṁ taṁ yayāce| ");
INSERT INTO sanias_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","tadā yīśustāṁ proktavān, tvaṁ kiṁ yācase? tataḥ sā babhāṣe, bhavato rājatve mamānayoḥ sutayorekaṁ bhavaddakṣiṇapārśve dvitīyaṁ vāmapārśva upaveṣṭum ājñāpayatu| ");
INSERT INTO sanias_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","yīśuḥ pratyuvāca, yuvābhyāṁ yad yācyate, tanna budhyate, ahaṁ yena kaṁsena pāsyāmi yuvābhyāṁ kiṁ tena pātuṁ śakyate? ahañca yena majjenena majjiṣye, yuvābhyāṁ kiṁ tena majjayituṁ śakyate? te jagaduḥ śakyate| ");
INSERT INTO sanias_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","tadā sa uktavān, yuvāṁ mama kaṁsenāvaśyaṁ pāsyathaḥ, mama majjanena ca yuvāmapi majjiṣyethe, kintu yeṣāṁ kṛte mattātena nirūpitam idaṁ tān vihāyānyaṁ kamapi maddakṣiṇapārśve vāmapārśve ca samupaveśayituṁ mamādhikāro nāsti| ");
INSERT INTO sanias_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","etāṁ kathāṁ śrutvānye daśaśiṣyāstau bhrātarau prati cukupuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","kintu yīśuḥ svasamīpaṁ tānāhūya jagāda, anyadeśīyalokānāṁ narapatayastān adhikurvvanti, ye tu mahāntaste tān śāsati, iti yūyaṁ jānītha| ");
INSERT INTO sanias_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","kintu yuṣmākaṁ madhye na tathā bhavet, yuṣmākaṁ yaḥ kaścit mahān bubhūṣati, sa yuṣmān seveta; ");
INSERT INTO sanias_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","yaśca yuṣmākaṁ madhye mukhyo bubhūṣati, sa yuṣmākaṁ dāso bhavet| ");
INSERT INTO sanias_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","itthaṁ manujaputraḥ sevyo bhavituṁ nahi, kintu sevituṁ bahūnāṁ paritrāṇamūlyārthaṁ svaprāṇān dātuñcāgataḥ| ");
INSERT INTO sanias_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","anantaraṁ yirīhonagarāt teṣāṁ bahirgamanasamaye tasya paścād bahavo lokā vavrajuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","aparaṁ vartmapārśva upaviśantau dvāvandhau tena mārgeṇa yīśo rgamanaṁ niśamya proccaiḥ kathayāmāsatuḥ, he prabho dāyūdaḥ santāna, āvayo rdayāṁ vidhehi| ");
INSERT INTO sanias_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","tato lokāḥ sarvve tuṣṇīmbhavatamityuktvā tau tarjayāmāsuḥ; tathāpi tau punaruccaiḥ kathayāmāsatuḥ he prabho dāyūdaḥ santāna, āvāṁ dayasva| ");
INSERT INTO sanias_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","tadānīṁ yīśuḥ sthagitaḥ san tāvāhūya bhāṣitavān, yuvayoḥ kṛte mayā kiṁ karttarvyaṁ? yuvāṁ kiṁ kāmayethe? ");
INSERT INTO sanias_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","tadā tāvuktavantau, prabho netrāṇi nau prasannāni bhaveyuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","tadānīṁ yīśustau prati pramannaḥ san tayo rnetrāṇi pasparśa, tenaiva tau suvīkṣāñcakrāte tatpaścāt jagmutuśca| ");
INSERT INTO sanias_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","anantaraṁ teṣu yirūśālamnagarasya samīpaverttino jaitunanāmakadharādharasya samīpasthtiṁ baitphagigrāmam āgateṣu, yīśuḥ śiṣyadvayaṁ preṣayan jagāda, ");
INSERT INTO sanias_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","yuvāṁ sammukhasthagrāmaṁ gatvā baddhāṁ yāṁ savatsāṁ garddabhīṁ haṭhāt prāpsyathaḥ, tāṁ mocayitvā madantikam ānayataṁ| ");
INSERT INTO sanias_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","tatra yadi kaścit kiñcid vakṣyati, tarhi vadiṣyathaḥ, etasyāṁ prabhoḥ prayojanamāste, tena sa tatkṣaṇāt praheṣyati| ");
INSERT INTO sanias_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","sīyonaḥ kanyakāṁ yūyaṁ bhāṣadhvamiti bhāratīṁ| paśya te namraśīlaḥ san nṛpa āruhya gardabhīṁ| arthādāruhya tadvatsamāyāsyati tvadantikaṁ| ");
INSERT INTO sanias_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","bhaviṣyadvādinoktaṁ vacanamidaṁ tadā saphalamabhūt| ");
INSERT INTO sanias_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","anantaraṁ tau śṣyiौ yīśo ryathānideśaṁ taṁ grāmaṁ gatvā ");
INSERT INTO sanias_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","gardabhīṁ tadvatsañca samānītavantau, paścāt tadupari svīyavasanānī pātayitvā tamārohayāmāsatuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","tato bahavo lokā nijavasanāni pathi prasārayitumārebhire, katipayā janāśca pādapaparṇādikaṁ chitvā pathi vistārayāmāsuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","agragāminaḥ paścādgāminaśca manujā uccairjaya jaya dāyūdaḥ santāneti jagaduḥ parameśvarasya nāmnā ya āyāti sa dhanyaḥ, sarvvoparisthasvargepi jayati| ");
INSERT INTO sanias_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","itthaṁ tasmin yirūśālamaṁ praviṣṭe ko'yamiti kathanāt kṛtsnaṁ nagaraṁ cañcalamabhavat| ");
INSERT INTO sanias_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","tatra lokoḥ kathayāmāsuḥ, eṣa gālīlpradeśīya-nāsaratīya-bhaviṣyadvādī yīśuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","anantaraṁ yīśurīśvarasya mandiraṁ praviśya tanmadhyāt krayavikrayiṇo vahiścakāra; vaṇijāṁ mudrāsanānī kapotavikrayiṇāñcasanānī ca nyuvjayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","aparaṁ tānuvāca, eṣā lipirāste, \"mama gṛhaṁ prārthanāgṛhamiti vikhyāsyati\", kintu yūyaṁ tad dasyūnāṁ gahvaraṁ kṛtavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","tadanantaram andhakhañcalokāstasya samīpamāgatāḥ, sa tān nirāmayān kṛtavān| ");
INSERT INTO sanias_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","yadā pradhānayājakā adhyāpakāśca tena kṛtānyetāni citrakarmmāṇi dadṛśuḥ, jaya jaya dāyūdaḥ santāna, mandire bālakānām etādṛśam uccadhvaniṁ śuśruvuśca, tadā mahākruddhā babhūvaḥ, ");
INSERT INTO sanias_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","taṁ papracchuśca, ime yad vadanti, tat kiṁ tvaṁ śṛṇoṣi? tato yīśustān avocat, satyam; stanyapāyiśiśūnāñca bālakānāñca vaktrataḥ| svakīyaṁ mahimānaṁ tvaṁ saṁprakāśayasi svayaṁ| etadvākyaṁ yūyaṁ kiṁ nāpaṭhata? ");
INSERT INTO sanias_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","tatastān vihāya sa nagarād baithaniyāgrāmaṁ gatvā tatra rajanīṁ yāpayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","anantaraṁ prabhāte sati yīśuḥ punarapi nagaramāgacchan kṣudhārtto babhūva| ");
INSERT INTO sanias_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","tato mārgapārśva uḍumbaravṛkṣamekaṁ vilokya tatsamīpaṁ gatvā patrāṇi vinā kimapi na prāpya taṁ pādapaṁ provāca, adyārabhya kadāpi tvayi phalaṁ na bhavatu; tena tatkṣaṇāt sa uḍumbaramāhīruhaḥ śuṣkatāṁ gataḥ| ");
INSERT INTO sanias_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","tad dṛṣṭvā śiṣyā āścaryyaṁ vijñāya kathayāmāsuḥ, āḥ, uḍumvarapādapo'titūrṇaṁ śuṣko'bhavat| ");
INSERT INTO sanias_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","tato yīśustānuvāca, yuṣmānahaṁ satyaṁ vadāmi, yadi yūyamasandigdhāḥ pratītha, tarhi yūyamapi kevaloḍumvarapādapaṁ pratītthaṁ karttuṁ śakṣyatha, tanna, tvaṁ calitvā sāgare pateti vākyaṁ yuṣmābhirasmina śaile proktepi tadaiva tad ghaṭiṣyate| ");
INSERT INTO sanias_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","tathā viśvasya prārthya yuṣmābhi ryad yāciṣyate, tadeva prāpsyate| ");
INSERT INTO sanias_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","anantaraṁ mandiraṁ praviśyopadeśanasamaye tatsamīpaṁ pradhānayājakāḥ prācīnalokāścāgatya papracchuḥ, tvayā kena sāmarthyanaitāni karmmāṇi kriyante? kena vā tubhyametāni sāmarthyāni dattāni? ");
INSERT INTO sanias_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","tato yīśuḥ pratyavadat, ahamapi yuṣmān vācamekāṁ pṛcchāmi, yadi yūyaṁ taduttaraṁ dātuṁ śakṣyatha, tadā kena sāmarthyena karmmāṇyetāni karomi, tadahaṁ yuṣmān vakṣyāmi| ");
INSERT INTO sanias_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","yohano majjanaṁ kasyājñayābhavat? kimīśvarasya manuṣyasya vā? tataste parasparaṁ vivicya kathayāmāsuḥ, yadīśvarasyeti vadāmastarhi yūyaṁ taṁ kuto na pratyaita? vācametāṁ vakṣyati| ");
INSERT INTO sanias_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","manuṣyasyeti vaktumapi lokebhyo bibhīmaḥ, yataḥ sarvvairapi yohan bhaviṣyadvādīti jñāyate| ");
INSERT INTO sanias_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","tasmāt te yīśuṁ pratyavadan, tad vayaṁ na vidmaḥ| tadā sa tānuktavān, tarhi kena sāmarathyena karmmāṇyetānyahaṁ karomi, tadapyahaṁ yuṣmān na vakṣyāmi| ");
INSERT INTO sanias_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","kasyacijjanasya dvau sutāvāstāṁ sa ekasya sutasya samīpaṁ gatvā jagāda, he suta, tvamadya mama drākṣākṣetre karmma kartuṁ vraja| ");
INSERT INTO sanias_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","tataḥ sa uktavān, na yāsyāmi, kintu śeṣe'nutapya jagāma| ");
INSERT INTO sanias_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","anantaraṁ sonyasutasya samīpaṁ gatvā tathaiva kathtivān; tataḥ sa pratyuvāca, maheccha yāmi, kintu na gataḥ| ");
INSERT INTO sanias_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","etayoḥ putrayo rmadhye piturabhimataṁ kena pālitaṁ? yuṣmābhiḥ kiṁ budhyate? tataste pratyūcuḥ, prathamena puुtreṇa| tadānīṁ yīśustānuvāca, ahaṁ yuṣmān tathyaṁ vadāmi, caṇḍālā gaṇikāśca yuṣmākamagrata īśvarasya rājyaṁ praviśanti| ");
INSERT INTO sanias_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","yato yuṣmākaṁ samīpaṁ yohani dharmmapathenāgate yūyaṁ taṁ na pratītha, kintu caṇḍālā gaṇikāśca taṁ pratyāyan, tad vilokyāpi yūyaṁ pratyetuṁ nākhidyadhvaṁ| ");
INSERT INTO sanias_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","aparamekaṁ dṛṣṭāntaṁ śṛṇuta, kaścid gṛhasthaḥ kṣetre drākṣālatā ropayitvā taccaturdikṣu vāraṇīṁ vidhāya tanmadhye drākṣāyantraṁ sthāpitavān, māñcañca nirmmitavān, tataḥ kṛṣakeṣu tat kṣetraṁ samarpya svayaṁ dūradeśaṁ jagāma| ");
INSERT INTO sanias_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","tadanantaraṁ phalasamaya upasthite sa phalāni prāptuṁ kṛṣīvalānāṁ samīpaṁ nijadāsān preṣayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","kintu kṛṣīvalāstasya tān dāseyān dhṛtvā kañcana prahṛtavantaḥ, kañcana pāṣāṇairāhatavantaḥ, kañcana ca hatavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","punarapi sa prabhuḥ prathamato'dhikadāseyān preṣayāmāsa, kintu te tān pratyapi tathaiva cakruḥ| ");
INSERT INTO sanias_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","anantaraṁ mama sute gate taṁ samādariṣyante, ityuktvā śeṣe sa nijasutaṁ teṣāṁ sannidhiṁ preṣayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","kintu te kṛṣīvalāḥ sutaṁ vīkṣya parasparam iti mantrayitum ārebhire, ayamuttarādhikārī vayamenaṁ nihatyāsyādhikāraṁ svavaśīkariṣyāmaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","paścāt te taṁ dhṛtvā drākṣākṣetrād bahiḥ pātayitvābadhiṣuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","yadā sa drākṣākṣetrapatirāgamiṣyati, tadā tān kṛṣīvalān kiṁ kariṣyati? ");
INSERT INTO sanias_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","tataste pratyavadan, tān kaluṣiṇo dāruṇayātanābhirāhaniṣyati, ye ca samayānukramāt phalāni dāsyanti, tādṛśeṣu kṛṣīvaleṣu kṣetraṁ samarpayiṣyati| ");
INSERT INTO sanias_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","tadā yīśunā te gaditāḥ, grahaṇaṁ na kṛtaṁ yasya pāṣāṇasya nicāyakaiḥ| pradhānaprastaraḥ koṇe saeva saṁbhaviṣyati| etat pareśituḥ karmmāsmadṛṣṭāvadbhutaṁ bhavet| dharmmagranthe likhitametadvacanaṁ yuṣmābhiḥ kiṁ nāpāṭhi? ");
INSERT INTO sanias_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","tasmādahaṁ yuṣmān vadāmi, yuṣmatta īśvarīyarājyamapanīya phalotpādayitranyajātaye dāyiṣyate| ");
INSERT INTO sanias_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","yo jana etatpāṣāṇopari patiṣyati, taṁ sa bhaṁkṣyate, kintvayaṁ pāṣāṇo yasyopari patiṣyati, taṁ sa dhūlivat cūrṇīkariṣyati| ");
INSERT INTO sanias_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","tadānīṁ prādhanayājakāḥ phirūśinaśca tasyemāṁ dṛṣṭāntakathāṁ śrutvā so'smānuddiśya kathitavān, iti vijñāya taṁ dharttuṁ ceṣṭitavantaḥ; ");
INSERT INTO sanias_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","kintu lokebhyo bibhyuḥ, yato lokaiḥ sa bhaviṣyadvādītyajñāyi| ");
INSERT INTO sanias_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","anantaraṁ yīśuḥ punarapi dṛṣṭāntena tān avādīt, ");
INSERT INTO sanias_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","svargīyarājyam etādṛśasya nṛpateḥ samaṁ, yo nija putraṁ vivāhayan sarvvān nimantritān ānetuṁ dāseyān prahitavān, ");
INSERT INTO sanias_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","kintu te samāgantuṁ neṣṭavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","tato rājā punarapi dāsānanyān ityuktvā preṣayāmāsa, nimantritān vadata, paśyata, mama bhejyamāsāditamāste, nijavṭaṣādipuṣṭajantūn mārayitvā sarvvaṁ khādyadravyamāsāditavān, yūyaṁ vivāhamāgacchata| ");
INSERT INTO sanias_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","tathapi te tucchīkṛtya kecit nijakṣetraṁ kecid vāṇijyaṁ prati svasvamārgeṇa calitavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","anye lokāstasya dāseyān dhṛtvā daurātmyaṁ vyavahṛtya tānavadhiṣuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","anantaraṁ sa nṛpatistāṁ vārttāṁ śrutvā krudhyan sainyāni prahitya tān ghātakān hatvā teṣāṁ nagaraṁ dāhayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","tataḥ sa nijadāseyān babhāṣe, vivāhīyaṁ bhojyamāsāditamāste, kintu nimantritā janā ayogyāḥ| ");
INSERT INTO sanias_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","tasmād yūyaṁ rājamārgaṁ gatvā yāvato manujān paśyata, tāvataeva vivāhīyabhojyāya nimantrayata| ");
INSERT INTO sanias_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","tadā te dāseyā rājamārgaṁ gatvā bhadrān abhadrān vā yāvato janān dadṛśuḥ, tāvataeva saṁgṛhyānayan; tato'bhyāgatamanujai rvivāhagṛham apūryyata| ");
INSERT INTO sanias_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","tadānīṁ sa rājā sarvvānabhyāgatān draṣṭum abhyantaramāgatavān; tadā tatra vivāhīyavasanahīnamekaṁ janaṁ vīkṣya taṁ jagād, ");
INSERT INTO sanias_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","he mitra,tvaṁ vivāhīyavasanaṁ vinā kathamatra praviṣṭavān? tena sa niruttaro babhūva| ");
INSERT INTO sanias_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","tadā rājā nijānucarān avadat, etasya karacaraṇān baddhā yatra rodanaṁ dantairdantagharṣaṇañca bhavati, tatra vahirbhūtatamisre taṁ nikṣipata| ");
INSERT INTO sanias_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","itthaṁ bahava āhūtā alpe manobhimatāḥ| ");
INSERT INTO sanias_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","anantaraṁ phirūśinaḥ pragatya yathā saṁlāpena tam unmāthe pātayeyustathā mantrayitvā ");
INSERT INTO sanias_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","herodīyamanujaiḥ sākaṁ nijaśiṣyagaṇena taṁ prati kathayāmāsuḥ, he guro, bhavān satyaḥ satyamīśvarīyamārgamupadiśati, kamapi mānuṣaṁ nānurudhyate, kamapi nāpekṣate ca, tad vayaṁ jānīmaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","ataḥ kaisarabhūpāya karo'smākaṁ dātavyo na vā? atra bhavatā kiṁ budhyate? tad asmān vadatu| ");
INSERT INTO sanias_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","tato yīśusteṣāṁ khalatāṁ vijñāya kathitavān, re kapaṭinaḥ yuyaṁ kuto māṁ parikṣadhve? ");
INSERT INTO sanias_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","tatkaradānasya mudrāṁ māṁ darśayata| tadānīṁ taistasya samīpaṁ mudrācaturthabhāga ānīte ");
INSERT INTO sanias_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","sa tān papraccha, atra kasyeyaṁ mūrtti rnāma cāste? te jagaduḥ, kaisarabhūpasya| ");
INSERT INTO sanias_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","tataḥ sa uktavāna, kaisarasya yat tat kaisarāya datta, īśvarasya yat tad īśvarāya datta| ");
INSERT INTO sanias_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","iti vākyaṁ niśamya te vismayaṁ vijñāya taṁ vihāya calitavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","tasminnahani sidūkino'rthāt śmaśānāt notthāsyantīti vākyaṁ ye vadanti, te yīśeाrantikam āgatya papracchuḥ, ");
INSERT INTO sanias_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","he guro, kaścinmanujaścet niḥsantānaḥ san prāṇān tyajati, tarhi tasya bhrātā tasya jāyāṁ vyuhya bhrātuḥ santānam utpādayiṣyatīti mūsā ādiṣṭavān| ");
INSERT INTO sanias_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","kintvasmākamatra ke'pi janāḥ saptasahodarā āsan, teṣāṁ jyeṣṭha ekāṁ kanyāṁ vyavahāt, aparaṁ prāṇatyāgakāle svayaṁ niḥsantānaḥ san tāṁ striyaṁ svabhrātari samarpitavān, ");
INSERT INTO sanias_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","tato dvitīyādisaptamāntāśca tathaiva cakruḥ| ");
INSERT INTO sanias_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","śeṣe sāpī nārī mamāra| ");
INSERT INTO sanias_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","mṛtānām utthānasamaye teṣāṁ saptānāṁ madhye sā nārī kasya bhāryyā bhaviṣyati? yasmāt sarvvaeva tāṁ vyavahan| ");
INSERT INTO sanias_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","tato yīśuḥ pratyavādīt, yūyaṁ dharmmapustakam īśvarīyāṁ śaktiñca na vijñāya bhrāntimantaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","utthānaprāptā lokā na vivahanti, na ca vācā dīyante, kintvīśvarasya svargasthadūtānāṁ sadṛśā bhavanti| ");
INSERT INTO sanias_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","aparaṁ mṛtānāmutthānamadhi yuṣmān pratīyamīśvaroktiḥ, ");
INSERT INTO sanias_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","\"ahamibrāhīma īśvara ishāka īśvaro yākūba īśvara\" iti kiṁ yuṣmābhi rnāpāṭhi? kintvīśvaro jīvatām īśvara:, sa mṛtānāmīśvaro nahi| ");
INSERT INTO sanias_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","iti śrutvā sarvve lokāstasyopadeśād vismayaṁ gatāḥ| ");
INSERT INTO sanias_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","anantaraṁ sidūkinām niruttaratvavārtāṁ niśamya phirūśina ekatra militavantaḥ, ");
INSERT INTO sanias_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","teṣāmeko vyavasthāpako yīśuṁ parīkṣituṁ papaccha, ");
INSERT INTO sanias_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","he guro vyavasthāśāstramadhye kājñā śreṣṭhā? ");
INSERT INTO sanias_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","tato yīśuruvāca, tvaṁ sarvvāntaḥkaraṇaiḥ sarvvaprāṇaiḥ sarvvacittaiśca sākaṁ prabhau parameśvare prīyasva, ");
INSERT INTO sanias_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","eṣā prathamamahājñā| tasyāḥ sadṛśī dvitīyājñaiṣā, ");
INSERT INTO sanias_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","tava samīpavāsini svātmanīva prema kuru| ");
INSERT INTO sanias_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","anayo rdvayorājñayoḥ kṛtsnavyavasthāyā bhaviṣyadvaktṛgranthasya ca bhārastiṣṭhati| ");
INSERT INTO sanias_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","anantaraṁ phirūśinām ekatra sthitikāle yīśustān papraccha, ");
INSERT INTO sanias_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","khrīṣṭamadhi yuṣmākaṁ kīdṛgbodho jāyate? sa kasya santānaḥ? tataste pratyavadan, dāyūdaḥ santānaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","tadā sa uktavān, tarhi dāyūd katham ātmādhiṣṭhānena taṁ prabhuṁ vadati ? ");
INSERT INTO sanias_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","yathā mama prabhumidaṁ vākyamavadat parameśvaraḥ| tavārīn pādapīṭhaṁ te yāvannahi karomyahaṁ| tāvat kālaṁ madīye tvaṁ dakṣapārśva upāviśa| ato yadi dāyūd taṁ prabhuṁ vadati, rtiha sa kathaṁ tasya santāno bhavati? ");
INSERT INTO sanias_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","tadānīṁ teṣāṁ kopi tadvākyasya kimapyuttaraṁ dātuṁ nāśaknot; ");
INSERT INTO sanias_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","taddinamārabhya taṁ kimapi vākyaṁ praṣṭuṁ kasyāpi sāhaso nābhavat| ");
INSERT INTO sanias_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","anantaraṁ yīśu rjananivahaṁ śiṣyāṁścāvadat, ");
INSERT INTO sanias_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","adhyāpakāḥ phirūśinaśca mūsāsane upaviśanti, ");
INSERT INTO sanias_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ataste yuṣmān yadyat mantum ājñāpayanti, tat manyadhvaṁ pālayadhvañca, kintu teṣāṁ karmmānurūpaṁ karmma na kurudhvaṁ; yatasteṣāṁ vākyamātraṁ sāraṁ kāryye kimapi nāsti| ");
INSERT INTO sanias_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","te durvvahān gurutarān bhārān badvvā manuṣyāṇāṁ skandhepari samarpayanti, kintu svayamaṅgulyaikayāpi na cālayanti| ");
INSERT INTO sanias_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","kevalaṁ lokadarśanāya sarvvakarmmāṇi kurvvanti; phalataḥ paṭṭabandhān prasāryya dhārayanti, svavastreṣu ca dīrghagranthīn dhārayanti; ");
INSERT INTO sanias_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","bhojanabhavana uccasthānaṁ, bhajanabhavane pradhānamāsanaṁ, ");
INSERT INTO sanias_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","haṭṭhe namaskāraṁ gururiti sambodhanañcaitāni sarvvāṇi vāñchanti| ");
INSERT INTO sanias_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","kintu yūyaṁ gurava iti sambodhanīyā mā bhavata, yato yuṣmākam ekaḥ khrīṣṭaeva guru ");
INSERT INTO sanias_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ryūyaṁ sarvve mitho bhrātaraśca| punaḥ pṛthivyāṁ kamapi piteti mā sambudhyadhvaṁ, yato yuṣmākamekaḥ svargasthaeva pitā| ");
INSERT INTO sanias_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","yūyaṁ nāyaketi sambhāṣitā mā bhavata, yato yuṣmākamekaḥ khrīṣṭaeva nāyakaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","aparaṁ yuṣmākaṁ madhye yaḥ pumān śreṣṭhaḥ sa yuṣmān seviṣyate| ");
INSERT INTO sanias_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","yato yaḥ svamunnamati, sa nataḥ kariṣyate; kintu yaḥ kaścit svamavanataṁ karoti, sa unnataḥ kariṣyate| ");
INSERT INTO sanias_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","hanta kapaṭina upādhyāyāḥ phirūśinaśca, yūyaṁ manujānāṁ samakṣaṁ svargadvāraṁ rundha, yūyaṁ svayaṁ tena na praviśatha, pravivikṣūnapi vārayatha| vata kapaṭina upādhyāyāḥ phirūśinaśca yūyaṁ chalād dīrghaṁ prārthya vidhavānāṁ sarvvasvaṁ grasatha, yuṣmākaṁ ghorataradaṇḍo bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","hanta kapaṭina upādhyāyāḥ phirūśinaśca, yūyamekaṁ svadharmmāvalambinaṁ karttuṁ sāgaraṁ bhūmaṇḍalañca pradakṣiṇīkurutha, ");
INSERT INTO sanias_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","kañcana prāpya svato dviguṇanarakabhājanaṁ taṁ kurutha| ");
INSERT INTO sanias_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","vata andhapathadarśakāḥ sarvve, yūyaṁ vadatha, mandirasya śapathakaraṇāt kimapi na deyaṁ; kintu mandirasthasuvarṇasya śapathakaraṇād deyaṁ| ");
INSERT INTO sanias_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","he mūḍhā he andhāḥ suvarṇaṁ tatsuvarṇapāvakamandiram etayorubhayo rmadhye kiṁ śreyaḥ? ");
INSERT INTO sanias_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","anyacca vadatha, yajñavedyāḥ śapathakaraṇāt kimapi na deyaṁ, kintu taduparisthitasya naivedyasya śapathakaraṇād deyaṁ| ");
INSERT INTO sanias_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","he mūḍhā he andhāḥ, naivedyaṁ tannaivedyapāvakavediretayorubhayo rmadhye kiṁ śreyaḥ? ");
INSERT INTO sanias_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ataḥ kenacid yajñavedyāḥ śapathe kṛte taduparisthasya sarvvasya śapathaḥ kriyate| ");
INSERT INTO sanias_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","kenacit mandirasya śapathe kṛte mandiratannivāsinoḥ śapathaḥ kriyate| ");
INSERT INTO sanias_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","kenacit svargasya śapathe kṛte īśvarīyasiṁhāsanataduparyyupaviṣṭayoḥ śapathaḥ kriyate| ");
INSERT INTO sanias_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","hanta kapaṭina upādhyāyāḥ phirūśinaśca, yūyaṁ podināyāḥ sitacchatrāyā jīrakasya ca daśamāṁśān dattha, kintu vyavasthāyā gurutarān nyāyadayāviśvāsān parityajatha; ime yuṣmābhirācaraṇīyā amī ca na laṁghanīyāḥ| ");
INSERT INTO sanias_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","he andhapathadarśakā yūyaṁ maśakān apasārayatha, kintu mahāṅgān grasatha| ");
INSERT INTO sanias_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","hanta kapaṭina upādhyāyāḥ phirūśinaśca, yūyaṁ pānapātrāṇāṁ bhojanapātrāṇāñca bahiḥ pariṣkurutha; kintu tadabhyantaraṁ durātmatayā kaluṣeṇa ca paripūrṇamāste| ");
INSERT INTO sanias_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","he andhāḥ phirūśilokā ādau pānapātrāṇāṁ bhojanapātrāṇāñcābhyantaraṁ pariṣkuruta, tena teṣāṁ bahirapi pariṣkāriṣyate| ");
INSERT INTO sanias_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","hanta kapaṭina upādhyāyāḥ phirūśinaśca, yūyaṁ śuklīkṛtaśmaśānasvarūpā bhavatha, yathā śmaśānabhavanasya bahiścāru, kintvabhyantaraṁ mṛtalokānāṁ kīkaśaiḥ sarvvaprakāramalena ca paripūrṇam; ");
INSERT INTO sanias_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","tathaiva yūyamapi lokānāṁ samakṣaṁ bahirdhārmmikāḥ kintvantaḥkaraṇeṣu kevalakāpaṭyādharmmābhyāṁ paripūrṇāḥ| ");
INSERT INTO sanias_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","hā hā kapaṭina upādhyāyāḥ phirūśinaśca, yūyaṁ bhaviṣyadvādināṁ śmaśānagehaṁ nirmmātha, sādhūnāṁ śmaśānaniketanaṁ śobhayatha ");
INSERT INTO sanias_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","vadatha ca yadi vayaṁ sveṣāṁ pūrvvapuruṣāṇāṁ kāla asthāsyāma, tarhi bhaviṣyadvādināṁ śoṇitapātane teṣāṁ sahabhāgino nābhaviṣyāma| ");
INSERT INTO sanias_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ato yūyaṁ bhaviṣyadvādighātakānāṁ santānā iti svayameva sveṣāṁ sākṣyaṁ dattha| ");
INSERT INTO sanias_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","ato yūyaṁ nijapūrvvapuruṣāṇāṁ parimāṇapātraṁ paripūrayata| ");
INSERT INTO sanias_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","re bhujagāḥ kṛṣṇabhujagavaṁśāḥ, yūyaṁ kathaṁ narakadaṇḍād rakṣiṣyadhve| ");
INSERT INTO sanias_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","paśyata, yuṣmākamantikam ahaṁ bhaviṣyadvādino buddhimata upādhyāyāṁśca preṣayiṣyāmi, kintu teṣāṁ katipayā yuṣmābhi rghāniṣyante, kruśe ca ghāniṣyante, kecid bhajanabhavane kaṣābhirāghāniṣyante, nagare nagare tāḍiṣyante ca; ");
INSERT INTO sanias_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","tena satpuruṣasya hābilo raktapātamārabhya berikhiyaḥ putraṁ yaṁ sikhariyaṁ yūyaṁ mandirayajñavedyo rmadhye hatavantaḥ, tadīyaśoṇitapātaṁ yāvad asmin deśe yāvatāṁ sādhupuruṣāṇāṁ śoṇitapāto 'bhavat tat sarvveṣāmāgasāṁ daṇḍā yuṣmāsu varttiṣyante| ");
INSERT INTO sanias_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ahaṁ yuṣmānta tathyaṁ vadāmi, vidyamāne'smin puruṣe sarvve varttiṣyante| ");
INSERT INTO sanias_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","he yirūśālam he yirūśālam nagari tvaṁ bhaviṣyadvādino hatavatī, tava samīpaṁ preritāṁśca pāṣāṇairāhatavatī, yathā kukkuṭī śāvakān pakṣādhaḥ saṁgṛhlāti, tathā tava santānān saṁgrahītuṁ ahaṁ bahuvāram aicchaṁ; kintu tvaṁ na samamanyathāḥ| ");
INSERT INTO sanias_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","paśyata yaṣmākaṁ vāsasthānam ucchinnaṁ tyakṣyate| ");
INSERT INTO sanias_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ahaṁ yuṣmān tathyaṁ vadāmi, yaḥ parameśvarasya nāmnāgacchati, sa dhanya iti vāṇīṁ yāvanna vadiṣyatha, tāvat māṁ puna rna drakṣyatha| ");
INSERT INTO sanias_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","anantaraṁ yīśu ryadā mandirād bahi rgacchati, tadānīṁ śiṣyāstaṁ mandiranirmmāṇaṁ darśayitumāgatāḥ| ");
INSERT INTO sanias_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","tato yīśustānuvāca, yūyaṁ kimetāni na paśyatha? yuṣmānahaṁ satyaṁ vadāmi, etannicayanasya pāṣāṇaikamapyanyapāṣāṇeाpari na sthāsyati sarvvāṇi bhūmisāt kāriṣyante| ");
INSERT INTO sanias_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","anantaraṁ tasmin jaitunaparvvatopari samupaviṣṭe śiṣyāstasya samīpamāgatya guptaṁ papracchuḥ, etā ghaṭanāḥ kadā bhaviṣyanti? bhavata āgamanasya yugāntasya ca kiṁ lakṣma? tadasmān vadatu| ");
INSERT INTO sanias_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","tadānīṁ yīśustānavocat, avadhadvvaṁ, kopi yuṣmān na bhramayet| ");
INSERT INTO sanias_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","bahavo mama nāma gṛhlanta āgamiṣyanti, khrīṣṭo'hameveti vācaṁ vadanto bahūn bhramayiṣyanti| ");
INSERT INTO sanias_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","yūyañca saṁgrāmasya raṇasya cāḍambaraṁ śroṣyatha, avadhadvvaṁ tena cañcalā mā bhavata, etānyavaśyaṁ ghaṭiṣyante, kintu tadā yugānto nahi| ");
INSERT INTO sanias_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","aparaṁ deśasya vipakṣo deśo rājyasya vipakṣo rājyaṁ bhaviṣyati, sthāne sthāne ca durbhikṣaṁ mahāmārī bhūkampaśca bhaviṣyanti, ");
INSERT INTO sanias_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","etāni duḥkhopakramāḥ| ");
INSERT INTO sanias_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","tadānīṁ lokā duḥkhaṁ bhojayituṁ yuṣmān parakareṣu samarpayiṣyanti haniṣyanti ca, tathā mama nāmakāraṇād yūyaṁ sarvvadeśīyamanujānāṁ samīpe ghṛṇārhā bhaviṣyatha| ");
INSERT INTO sanias_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","bahuṣu vighnaṁ prāptavatsu parasparam ṛृtīyāṁ kṛtavatsu ca eko'paraṁ parakareṣu samarpayiṣyati| ");
INSERT INTO sanias_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","tathā bahavo mṛṣābhaviṣyadvādina upasthāya bahūn bhramayiṣyanti| ");
INSERT INTO sanias_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","duṣkarmmaṇāṁ bāhulyāñca bahūnāṁ prema śītalaṁ bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","kintu yaḥ kaścit śeṣaṁ yāvad dhairyyamāśrayate, saeva paritrāyiṣyate| ");
INSERT INTO sanias_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","aparaṁ sarvvadeśīyalokān pratimākṣī bhavituṁ rājasya śubhasamācāraḥ sarvvajagati pracāriṣyate, etādṛśi sati yugānta upasthāsyati| ");
INSERT INTO sanias_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","ato yat sarvvanāśakṛdghṛṇārhaṁ vastu dāniyelbhaviṣyadvadinā proktaṁ tad yadā puṇyasthāne sthāpitaṁ drakṣyatha, (yaḥ paṭhati, sa budhyatāṁ) ");
INSERT INTO sanias_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","tadānīṁ ye yihūdīyadeśe tiṣṭhanti, te parvvateṣu palāyantāṁ| ");
INSERT INTO sanias_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","yaḥ kaścid gṛhapṛṣṭhe tiṣṭhati, sa gṛhāt kimapi vastvānetum adheा nāvarohet| ");
INSERT INTO sanias_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","yaśca kṣetre tiṣṭhati, sopi vastramānetuṁ parāvṛtya na yāyāt| ");
INSERT INTO sanias_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","tadānīṁ garbhiṇīstanyapāyayitrīṇāṁ durgati rbhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ato yaṣmākaṁ palāyanaṁ śītakāle viśrāmavāre vā yanna bhavet, tadarthaṁ prārthayadhvam| ");
INSERT INTO sanias_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ā jagadārambhād etatkālaparyyanantaṁ yādṛśaḥ kadāpi nābhavat na ca bhaviṣyati tādṛśo mahākleśastadānīm upasthāsyati| ");
INSERT INTO sanias_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","tasya kleśasya samayo yadi hsvo na kriyeta, tarhi kasyāpi prāṇino rakṣaṇaṁ bhavituṁ na śaknuyāt, kintu manonītamanujānāṁ kṛte sa kālo hsvīkariṣyate| ");
INSERT INTO sanias_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","aparañca paśyata, khrīṣṭo'tra vidyate, vā tatra vidyate, tadānīṁ yadī kaścid yuṣmāna iti vākyaṁ vadati, tathāpi tat na pratīt| ");
INSERT INTO sanias_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","yato bhāktakhrīṣṭā bhāktabhaviṣyadvādinaśca upasthāya yāni mahanti lakṣmāṇi citrakarmmāṇi ca prakāśayiṣyanti, tai ryadi sambhavet tarhi manonītamānavā api bhrāmiṣyante| ");
INSERT INTO sanias_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","paśyata, ghaṭanātaḥ pūrvvaṁ yuṣmān vārttām avādiṣam| ");
INSERT INTO sanias_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","ataḥ paśyata, sa prāntare vidyata iti vākye kenacit kathitepi bahi rmā gacchata, vā paśyata, sontaḥpure vidyate, etadvākya uktepi mā pratīta| ");
INSERT INTO sanias_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","yato yathā vidyut pūrvvadiśo nirgatya paścimadiśaṁ yāvat prakāśate, tathā mānuṣaputrasyāpyāgamanaṁ bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","yatra śavastiṣṭhati, tatreva gṛdhrā milanti| ");
INSERT INTO sanias_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","aparaṁ tasya kleśasamayasyāvyavahitaparatra sūryyasya tejo lopsyate, candramā jyosnāṁ na kariṣyati, nabhaso nakṣatrāṇi patiṣyanti, gagaṇīyā grahāśca vicaliṣyanti| ");
INSERT INTO sanias_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","tadānīm ākāśamadhye manujasutasya lakṣma darśiṣyate, tato nijaparākrameṇa mahātejasā ca meghārūḍhaṁ manujasutaṁ nabhasāgacchantaṁ vilokya pṛthivyāḥ sarvvavaṁśīyā vilapiṣyanti| ");
INSERT INTO sanias_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","tadānīṁ sa mahāśabdāyamānatūryyā vādakān nijadūtān praheṣyati, te vyomna ekasīmāto'parasīmāṁ yāvat caturdiśastasya manonītajanān ānīya melayiṣyanti| ");
INSERT INTO sanias_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","uḍumbarapādapasya dṛṣṭāntaṁ śikṣadhvaṁ; yadā tasya navīnāḥ śākhā jāyante, pallavādiśca nirgacchati, tadā nidāghakālaḥ savidho bhavatīti yūyaṁ jānītha; ");
INSERT INTO sanias_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","tadvad etā ghaṭanā dṛṣṭvā sa samayo dvāra upāsthād iti jānīta| ");
INSERT INTO sanias_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","yuṣmānahaṁ tathyaṁ vadāmi, idānīntanajanānāṁ gamanāt pūrvvameva tāni sarvvāṇi ghaṭiṣyante| ");
INSERT INTO sanias_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","nabhomedinyo rluptayorapi mama vāk kadāpi na lopsyate| ");
INSERT INTO sanias_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","aparaṁ mama tātaṁ vinā mānuṣaḥ svargastho dūto vā kopi taddinaṁ taddaṇḍañca na jñāpayati| ");
INSERT INTO sanias_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","aparaṁ nohe vidyamāne yādṛśamabhavat tādṛśaṁ manujasutasyāgamanakālepi bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","phalato jalāplāvanāt pūrvvaṁ yaddinaṁ yāvat nohaḥ potaṁ nārohat, tāvatkālaṁ yathā manuṣyā bhojane pāne vivahane vivāhane ca pravṛttā āsan; ");
INSERT INTO sanias_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","aparam āplāvitoyamāgatya yāvat sakalamanujān plāvayitvā nānayat, tāvat te yathā na vidāmāsuḥ, tathā manujasutāgamanepi bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","tadā kṣetrasthitayordvayoreko dhāriṣyate, aparastyājiṣyate| ");
INSERT INTO sanias_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","tathā peṣaṇyā piṁṣatyorubhayo ryoṣitorekā dhāriṣyate'parā tyājiṣyate| ");
INSERT INTO sanias_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","yuṣmākaṁ prabhuḥ kasmin daṇḍa āgamiṣyati, tad yuṣmābhi rnāvagamyate, tasmāt jāgrataḥ santastiṣṭhata| ");
INSERT INTO sanias_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","kutra yāme stena āgamiṣyatīti ced gṛhastho jñātum aśakṣyat, tarhi jāgaritvā taṁ sandhiṁ karttitum avārayiṣyat tad jānīta| ");
INSERT INTO sanias_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","yuṣmābhiravadhīyatāṁ, yato yuṣmābhi ryatra na budhyate, tatraiva daṇḍe manujasuta āyāsyati| ");
INSERT INTO sanias_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","prabhu rnijaparivārān yathākālaṁ bhojayituṁ yaṁ dāsam adhyakṣīkṛtya sthāpayati, tādṛśo viśvāsyo dhīmān dāsaḥ kaḥ? ");
INSERT INTO sanias_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","prabhurāgatya yaṁ dāsaṁ tathācarantaṁ vīkṣate, saeva dhanyaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","yuṣmānahaṁ satyaṁ vadāmi, sa taṁ nijasarvvasvasyādhipaṁ kariṣyati| ");
INSERT INTO sanias_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","kintu prabhurāgantuṁ vilambata iti manasi cintayitvā yo duṣṭo dāso ");
INSERT INTO sanias_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","'paradāsān praharttuṁ mattānāṁ saṅge bhoktuṁ pātuñca pravarttate, ");
INSERT INTO sanias_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","sa dāso yadā nāpekṣate, yañca daṇḍaṁ na jānāti, tatkālaeva tatprabhurupasthāsyati| ");
INSERT INTO sanias_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","tadā taṁ daṇḍayitvā yatra sthāne rodanaṁ dantagharṣaṇañcāsāte, tatra kapaṭibhiḥ sākaṁ taddaśāṁ nirūpayiṣyati| ");
INSERT INTO sanias_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","yā daśa kanyāḥ pradīpān gṛhlatyo varaṁ sākṣāt karttuṁ bahiritāḥ, tābhistadā svargīyarājyasya sādṛśyaṁ bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","tāsāṁ kanyānāṁ madhye pañca sudhiyaḥ pañca durdhiya āsan| ");
INSERT INTO sanias_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","yā durdhiyastāḥ pradīpān saṅge gṛhītvā tailaṁ na jagṛhuḥ, ");
INSERT INTO sanias_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","kintu sudhiyaḥ pradīpān pātreṇa tailañca jagṛhuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","anantaraṁ vare vilambite tāḥ sarvvā nidrāviṣṭā nidrāṁ jagmuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","anantaram arddharātre paśyata vara āgacchati, taṁ sākṣāt karttuṁ bahiryāteti janaravāt ");
INSERT INTO sanias_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","tāḥ sarvvāḥ kanyā utthāya pradīpān āsādayituṁ ārabhanta| ");
INSERT INTO sanias_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","tato durdhiyaḥ sudhiya ūcuḥ, kiñcit tailaṁ datta, pradīpā asmākaṁ nirvvāṇāḥ| ");
INSERT INTO sanias_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","kintu sudhiyaḥ pratyavadan, datte yuṣmānasmāṁśca prati tailaṁ nyūnībhavet, tasmād vikretṛṇāṁ samīpaṁ gatvā svārthaṁ tailaṁ krīṇīta| ");
INSERT INTO sanias_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","tadā tāsu kretuṁ gatāsu vara ājagāma, tato yāḥ sajjitā āsan, tāstena sākaṁ vivāhīyaṁ veśma praviviśuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","anantaraṁ dvāre ruddhe aparāḥ kanyā āgatya jagaduḥ, he prabho, he prabho, asmān prati dvāraṁ mocaya| ");
INSERT INTO sanias_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","kintu sa uktavān, tathyaṁ vadāmi, yuṣmānahaṁ na vedmi| ");
INSERT INTO sanias_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","ato jāgrataḥ santastiṣṭhata, manujasutaḥ kasmin dine kasmin daṇḍe vāgamiṣyati, tad yuṣmābhi rna jñāyate| ");
INSERT INTO sanias_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","aparaṁ sa etādṛśaḥ kasyacit puṁsastulyaḥ, yo dūradeśaṁ prati yātrākāle nijadāsān āhūya teṣāṁ svasvasāmarthyānurūpam ");
INSERT INTO sanias_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ekasmin mudrāṇāṁ pañca poṭalikāḥ anyasmiṁśca dve poṭalike aparasmiṁśca poṭalikaikām itthaṁ pratijanaṁ samarpya svayaṁ pravāsaṁ gatavān| ");
INSERT INTO sanias_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","anantaraṁ yo dāsaḥ pañca poṭalikāḥ labdhavān, sa gatvā vāṇijyaṁ vidhāya tā dviguṇīcakāra| ");
INSERT INTO sanias_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","yaśca dāso dve poṭalike alabhata, sopi tā mudrā dviguṇīcakāra| ");
INSERT INTO sanias_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","kintu yo dāsa ekāṁ poṭalikāṁ labdhavān, sa gatvā bhūmiṁ khanitvā tanmadhye nijaprabhostā mudrā gopayāñcakāra| ");
INSERT INTO sanias_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","tadanantaraṁ bahutithe kāle gate teṣāṁ dāsānāṁ prabhurāgatya tairdāsaiḥ samaṁ gaṇayāñcakāra| ");
INSERT INTO sanias_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","tadānīṁ yaḥ pañca poṭalikāḥ prāptavān sa tā dviguṇīkṛtamudrā ānīya jagāda; he prabho, bhavatā mayi pañca poṭalikāḥ samarpitāḥ, paśyatu, tā mayā dviguṇīkṛtāḥ| ");
INSERT INTO sanias_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","tadānīṁ tasya prabhustamuvāca, he uttama viśvāsya dāsa, tvaṁ dhanyosi, stokena viśvāsyo jātaḥ, tasmāt tvāṁ bahuvittādhipaṁ karomi, tvaṁ svaprabhoḥ sukhasya bhāgī bhava| ");
INSERT INTO sanias_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","tato yena dve poṭalike labdhe sopyāgatya jagāda, he prabho, bhavatā mayi dve poṭalike samarpite, paśyatu te mayā dviguṇīkṛte| ");
INSERT INTO sanias_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","tena tasya prabhustamavocat, he uttama viśvāsya dāsa, tvaṁ dhanyosi, stokena viśvāsyo jātaḥ, tasmāt tvāṁ bahudraviṇādhipaṁ karomi, tvaṁ nijaprabhoḥ sukhasya bhāgī bhava| ");
INSERT INTO sanias_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","anantaraṁ ya ekāṁ poṭalikāṁ labdhavān, sa etya kathitavān, he prabho, tvāṁ kaṭhinanaraṁ jñātavān, tvayā yatra noptaṁ, tatraiva kṛtyate, yatra ca na kīrṇaṁ, tatraiva saṁgṛhyate| ");
INSERT INTO sanias_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","atohaṁ saśaṅkaḥ san gatvā tava mudrā bhūmadhye saṁgopya sthāpitavān, paśya, tava yat tadeva gṛhāṇa| ");
INSERT INTO sanias_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","tadā tasya prabhuḥ pratyavadat re duṣṭālasa dāsa, yatrāhaṁ na vapāmi, tatra chinadmi, yatra ca na kirāmi, tatreva saṁgṛhlāmīti cedajānāstarhi ");
INSERT INTO sanias_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","vaṇikṣu mama vittārpaṇaṁ tavocitamāsīt, yenāhamāgatya vṛdvyā sākaṁ mūlamudrāḥ prāpsyam| ");
INSERT INTO sanias_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","atosmāt tāṁ poṭalikām ādāya yasya daśa poṭalikāḥ santi tasminnarpayata| ");
INSERT INTO sanias_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","yena vardvyate tasminnaivārpiṣyate, tasyaiva ca bāhulyaṁ bhaviṣyati, kintu yena na vardvyate, tasyāntike yat kiñcana tiṣṭhati, tadapi punarneṣyate| ");
INSERT INTO sanias_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","aparaṁ yūyaṁ tamakarmmaṇyaṁ dāsaṁ nītvā yatra sthāne krandanaṁ dantagharṣaṇañca vidyete, tasmin bahirbhūtatamasi nikṣipata| ");
INSERT INTO sanias_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","yadā manujasutaḥ pavitradūtān saṅginaḥ kṛtvā nijaprabhāvenāgatya nijatejomaye siṁhāsane nivekṣyati, ");
INSERT INTO sanias_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","tadā tatsammukhe sarvvajātīyā janā saṁmeliṣyanti| tato meṣapālako yathā chāgebhyo'vīn pṛthak karoti tathā sopyekasmādanyam itthaṁ tān pṛthaka kṛtvāvīn ");
INSERT INTO sanias_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","dakṣiṇe chāgāṁśca vāme sthāpayiṣyati| ");
INSERT INTO sanias_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","tataḥ paraṁ rājā dakṣiṇasthitān mānavān vadiṣyati, āgacchata mattātasyānugrahabhājanāni, yuṣmatkṛta ā jagadārambhat yad rājyam āsāditaṁ tadadhikuruta| ");
INSERT INTO sanias_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","yato bubhukṣitāya mahyaṁ bhojyam adatta, pipāsitāya peyamadatta, videśinaṁ māṁ svasthānamanayata, ");
INSERT INTO sanias_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","vastrahīnaṁ māṁ vasanaṁ paryyadhāpayata, pīḍītaṁ māṁ draṣṭumāgacchata, kārāsthañca māṁ vīkṣituma āgacchata| ");
INSERT INTO sanias_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","tadā dhārmmikāḥ prativadiṣyanti, he prabho, kadā tvāṁ kṣudhitaṁ vīkṣya vayamabhojayāma? vā pipāsitaṁ vīkṣya apāyayāma? ");
INSERT INTO sanias_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","kadā vā tvāṁ videśinaṁ vilokya svasthānamanayāma? kadā vā tvāṁ nagnaṁ vīkṣya vasanaṁ paryyadhāpayāma? ");
INSERT INTO sanias_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","kadā vā tvāṁ pīḍitaṁ kārāsthañca vīkṣya tvadantikamagacchāma? ");
INSERT INTO sanias_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","tadānīṁ rājā tān prativadiṣyati, yuṣmānahaṁ satyaṁ vadāmi, mamaiteṣāṁ bhrātṛṇāṁ madhye kañcanaikaṁ kṣudratamaṁ prati yad akuruta, tanmāṁ pratyakuruta| ");
INSERT INTO sanias_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","paścāt sa vāmasthitān janān vadiṣyati, re śāpagrastāḥ sarvve, śaitāne tasya dūtebhyaśca yo'nantavahnirāsādita āste, yūyaṁ madantikāt tamagniṁ gacchata| ");
INSERT INTO sanias_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","yato kṣudhitāya mahyamāhāraṁ nādatta, pipāsitāya mahyaṁ peyaṁ nādatta, ");
INSERT INTO sanias_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","videśinaṁ māṁ svasthānaṁ nānayata, vasanahīnaṁ māṁ vasanaṁ na paryyadhāpayata, pīḍitaṁ kārāsthañca māṁ vīkṣituṁ nāgacchata| ");
INSERT INTO sanias_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","tadā te prativadiṣyanti, he prabho, kadā tvāṁ kṣudhitaṁ vā pipāsitaṁ vā videśinaṁ vā nagnaṁ vā pīḍitaṁ vā kārāsthaṁ vīkṣya tvāṁ nāsevāmahi? ");
INSERT INTO sanias_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","tadā sa tān vadiṣyati, tathyamahaṁ yuṣmān bravīmi, yuṣmābhireṣāṁ kañcana kṣodiṣṭhaṁ prati yannākāri, tanmāṁ pratyeva nākāri| ");
INSERT INTO sanias_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","paścādamyanantaśāstiṁ kintu dhārmmikā anantāyuṣaṁ bhoktuṁ yāsyanti| ");
INSERT INTO sanias_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","yīśuretān prastāvān samāpya śiṣyānūce, ");
INSERT INTO sanias_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","yuṣmābhi rjñātaṁ dinadvayāt paraṁ nistāramaha upasthāsyati, tatra manujasutaḥ kruśena hantuṁ parakareṣu samarpiṣyate| ");
INSERT INTO sanias_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","tataḥ paraṁ pradhānayājakādhyāpakaprāñcaḥ kiyaphānāmno mahāyājakasyāṭṭālikāyāṁ militvā ");
INSERT INTO sanias_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","kenopāyena yīśuṁ dhṛtvā hantuṁ śaknuyuriti mantrayāñcakruḥ| ");
INSERT INTO sanias_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","kintu tairuktaṁ mahakāle na dharttavyaḥ, dhṛte prajānāṁ kalahena bhavituṁ śakyate| ");
INSERT INTO sanias_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","tato baithaniyāpure śimonākhyasya kuṣṭhino veśmani yīśau tiṣṭhati ");
INSERT INTO sanias_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","kācana yoṣā śvetopalabhājanena mahārghyaṁ sugandhi tailamānīya bhojanāyopaviśatastasya śirobhyaṣecat| ");
INSERT INTO sanias_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","kintu tadālokya tacchiṣyaiḥ kupitairuktaṁ, kuta itthamapavyayate? ");
INSERT INTO sanias_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","cedidaṁ vyakreṣyata, tarhi bhūrimūlyaṁ prāpya daridrebhyo vyatāriṣyata| ");
INSERT INTO sanias_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","yīśunā tadavagatya te samuditāḥ, yoṣāmenāṁ kuto duḥkhinīṁ kurutha, sā māṁ prati sādhu karmmākārṣīt| ");
INSERT INTO sanias_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","yuṣmākamaṁ samīpe daridrāḥ satatamevāsate, kintu yuṣmākamantikehaṁ nāse satataṁ| ");
INSERT INTO sanias_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","sā mama kāyopari sugandhitailaṁ siktvā mama śmaśānadānakarmmākārṣīt| ");
INSERT INTO sanias_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","atohaṁ yuṣmān tathyaṁ vadāmi sarvvasmin jagati yatra yatraiṣa susamācāraḥ pracāriṣyate, tatra tatraitasyā nāryyāḥ smaraṇārtham karmmedaṁ pracāriṣyate| ");
INSERT INTO sanias_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","tato dvādaśaśiṣyāṇām īṣkariyotīyayihūdānāmaka ekaḥ śiṣyaḥ pradhānayājakānāmantikaṁ gatvā kathitavān, ");
INSERT INTO sanias_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","yadi yuṣmākaṁ kareṣu yīśuṁ samarpayāmi, tarhi kiṁ dāsyatha? tadānīṁ te tasmai triṁśanmudrā dātuṁ sthirīkṛtavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","sa tadārabhya taṁ parakareṣu samarpayituṁ suyogaṁ ceṣṭitavān| ");
INSERT INTO sanias_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","anantaraṁ kiṇvaśūnyapūpaparvvaṇaḥ prathamehni śiṣyā yīśum upagatya papracchuḥ bhavatkṛte kutra vayaṁ nistāramahabhojyam āyojayiṣyāmaḥ? bhavataḥ kecchā? ");
INSERT INTO sanias_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","tadā sa gaditavān, madhyenagaramamukapuṁsaḥ samīpaṁ vrajitvā vadata, guru rgaditavān, matkālaḥ savidhaḥ, saha śiṣyaistvadālaye nistāramahabhojyaṁ bhokṣye| ");
INSERT INTO sanias_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","tadā śiṣyā yīśostādṛśanideśānurūpakarmma vidhāya tatra nistāramahabhojyamāsādayāmāsuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","tataḥ sandhyāyāṁ satyāṁ dvādaśabhiḥ śiṣyaiḥ sākaṁ sa nyaviśat| ");
INSERT INTO sanias_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","aparaṁ bhuñjāna uktavān yuṣmān tathyaṁ vadāmi, yuṣmākameko māṁ parakareṣu samarpayiṣyati| ");
INSERT INTO sanias_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","tadā te'tīva duḥkhitā ekaikaśo vaktumārebhire, he prabho, sa kimahaṁ? ");
INSERT INTO sanias_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","tataḥ sa jagāda, mayā sākaṁ yo jano bhojanapātre karaṁ saṁkṣipati, sa eva māṁ parakareṣu samarpayiṣyati| ");
INSERT INTO sanias_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","manujasutamadhi yādṛśaṁ likhitamāste, tadanurūpā tadgati rbhaviṣyati; kintu yena puṁsā sa parakareṣu samarpayiṣyate, hā hā cet sa nājaniṣyata, tadā tasya kṣemamabhaviṣyat| ");
INSERT INTO sanias_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","tadā yihūdānāmā yo janastaṁ parakareṣu samarpayiṣyati, sa uktavān, he guro, sa kimahaṁ? tataḥ sa pratyuktavān, tvayā satyaṁ gaditam| ");
INSERT INTO sanias_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","anantaraṁ teṣāmaśanakāle yīśuḥ pūpamādāyeśvarīyaguṇānanūdya bhaṁktvā śiṣyebhyaḥ pradāya jagāda, madvapuḥsvarūpamimaṁ gṛhītvā khādata| ");
INSERT INTO sanias_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","paścāt sa kaṁsaṁ gṛhlan īśvarīyaguṇānanūdya tebhyaḥ pradāya kathitavān, sarvvai ryuṣmābhiranena pātavyaṁ, ");
INSERT INTO sanias_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","yasmādanekeṣāṁ pāpamarṣaṇāya pātitaṁ yanmannūtnaniyamarūpaśoṇitaṁ tadetat| ");
INSERT INTO sanias_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","aparamahaṁ nūtnagostanīrasaṁ na pāsyāmi, tāvat gostanīphalarasaṁ punaḥ kadāpi na pāsyāmi| ");
INSERT INTO sanias_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","paścāt te gītamekaṁ saṁgīya jaitunākhyagiriṁ gatavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","tadānīṁ yīśustānavocat, asyāṁ rajanyāmahaṁ yuṣmākaṁ sarvveṣāṁ vighnarūpo bhaviṣyāmi, yato likhitamāste, \"meṣāṇāṁ rakṣako yastaṁ prahariṣyāmyahaṁ tataḥ| meṣāṇāṁ nivaho nūnaṁ pravikīrṇo bhaviṣyati\"|| ");
INSERT INTO sanias_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","kintu śmaśānāt samutthāya yuṣmākamagre'haṁ gālīlaṁ gamiṣyāmi| ");
INSERT INTO sanias_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","pitarastaṁ provāca, bhavāṁścet sarvveṣāṁ vighnarūpo bhavati, tathāpi mama na bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","tato yīśunā sa uktaḥ, tubhyamahaṁ tathyaṁ kathayāmi, yāminyāmasyāṁ caraṇāyudhasya ravāt pūrvvaṁ tvaṁ māṁ tri rnāṅgīkariṣyasi| ");
INSERT INTO sanias_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","tataḥ pitara uditavān, yadyapi tvayā samaṁ marttavyaṁ, tathāpi kadāpi tvāṁ na nāṅgīkariṣyāmi; tathaiva sarvve śiṣyāścocuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","anantaraṁ yīśuḥ śiṣyaiḥ sākaṁ getśimānīnāmakaṁ sthānaṁ prasthāya tebhyaḥ kathitavān, adaḥ sthānaṁ gatvā yāvadahaṁ prārthayiṣye tāvad yūyamatropaviśata| ");
INSERT INTO sanias_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","paścāt sa pitaraṁ sivadiyasutau ca saṅginaḥ kṛtvā gatavān, śokākulo'tīva vyathitaśca babhūva| ");
INSERT INTO sanias_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","tānavādīcca mṛtiyātaneva matprāṇānāṁ yātanā jāyate, yūyamatra mayā sārddhaṁ jāgṛta| ");
INSERT INTO sanias_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","tataḥ sa kiñciddūraṁ gatvādhomukhaḥ patan prārthayāñcakre, he matpitaryadi bhavituṁ śaknoti, tarhi kaṁso'yaṁ matto dūraṁ yātu; kintu madicchāvat na bhavatu, tvadicchāvad bhavatu| ");
INSERT INTO sanias_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","tataḥ sa śiṣyānupetya tān nidrato nirīkṣya pitarāya kathayāmāsa, yūyaṁ mayā sākaṁ daṇḍamekamapi jāgarituṁ nāśankuta? ");
INSERT INTO sanias_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","parīkṣāyāṁ na patituṁ jāgṛta prārthayadhvañca; ātmā samudyatosti, kintu vapu rdurbbalaṁ| ");
INSERT INTO sanias_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","sa dvitīyavāraṁ prārthayāñcakre, he mattāta, na pīte yadi kaṁsamidaṁ matto dūraṁ yātuṁ na śaknoti, tarhi tvadicchāvad bhavatu| ");
INSERT INTO sanias_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","sa punaretya tān nidrato dadarśa, yatasteṣāṁ netrāṇi nidrayā pūrṇānyāsan| ");
INSERT INTO sanias_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","paścāt sa tān vihāya vrajitvā tṛtīyavāraṁ pūrvvavat kathayan prārthitavān| ");
INSERT INTO sanias_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","tataḥ śiṣyānupāgatya gaditavān, sāmprataṁ śayānāḥ kiṁ viśrāmyatha? paśyata, samaya upāsthāt, manujasutaḥ pāpināṁ kareṣu samarpyate| ");
INSERT INTO sanias_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","uttiṣṭhata, vayaṁ yāmaḥ, yo māṁ parakareṣu masarpayiṣyati, paśyata, sa samīpamāyāti| ");
INSERT INTO sanias_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","etatkathākathanakāle dvādaśaśiṣyāṇāmeko yihūdānāmako mukhyayājakalokaprācīnaiḥ prahitān asidhāriyaṣṭidhāriṇo manujān gṛhītvā tatsamīpamupatasthau| ");
INSERT INTO sanias_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","asau parakareṣvarpayitā pūrvvaṁ tān itthaṁ saṅketayāmāsa, yamahaṁ cumbiṣye, so'sau manujaḥ,saeva yuṣmābhi rdhāryyatāṁ| ");
INSERT INTO sanias_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","tadā sa sapadi yīśumupāgatya he guro, praṇamāmītyuktvā taṁ cucumbe| ");
INSERT INTO sanias_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","tadā yīśustamuvāca, he mitraṁ kimarthamāgatosi? tadā tairāgatya yīśurākramya daghre| ");
INSERT INTO sanias_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","tato yīśoḥ saṅgināmekaḥ karaṁ prasāryya koṣādasiṁ bahiṣkṛtya mahāyājakasya dāsamekamāhatya tasya karṇaṁ ciccheda| ");
INSERT INTO sanias_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","tato yīśustaṁ jagāda, khaḍgaṁ svasthāneे nidhehi yato ye ye janā asiṁ dhārayanti, taevāsinā vinaśyanti| ");
INSERT INTO sanias_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","aparaṁ pitā yathā madantikaṁ svargīyadūtānāṁ dvādaśavāhinīto'dhikaṁ prahiṇuyāt mayā tamuddiśyedānīmeva tathā prārthayituṁ na śakyate, tvayā kimitthaṁ jñāyate? ");
INSERT INTO sanias_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","tathā satītthaṁ ghaṭiṣyate dharmmapustakasya yadidaṁ vākyaṁ tat kathaṁ sidhyet? ");
INSERT INTO sanias_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","tadānīṁ yīśu rjananivahaṁ jagāda, yūyaṁ khaḍgayaṣṭīn ādāya māṁ kiṁ cauraṁ dharttumāyātāḥ? ahaṁ pratyahaṁ yuṣmābhiḥ sākamupaviśya samupādiśaṁ, tadā māṁ nādharata; ");
INSERT INTO sanias_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","kintu bhaviṣyadvādināṁ vākyānāṁ saṁsiddhaye sarvvametadabhūt|tadā sarvve śiṣyāstaṁ vihāya palāyanta| ");
INSERT INTO sanias_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","anantaraṁ te manujā yīśuṁ dhṛtvā yatrādhyāpakaprāñcaḥ pariṣadaṁ kurvvanta upāviśan tatra kiyaphānāाmakamahāyājakasyāntikaṁ ninyuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","kintu śeṣe kiṁ bhaviṣyatīti vettuṁ pitaro dūre tatpaścād vrajitvā mahāyājakasyāṭṭālikāṁ praviśya dāsaiḥ sahita upāviśat| ");
INSERT INTO sanias_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","tadānīṁ pradhānayājakaprācīnamantriṇaḥ sarvve yīśuṁ hantuṁ mṛṣāsākṣyam alipsanta, ");
INSERT INTO sanias_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","kintu na lebhire| anekeṣu mṛṣāsākṣiṣvāgateṣvapi tanna prāpuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","śeṣe dvau mṛṣāsākṣiṇāvāgatya jagadatuḥ, pumānayamakathayat, ahamīśvaramandiraṁ bhaṁktvā dinatrayamadhye tannirmmātuṁ śaknomi| ");
INSERT INTO sanias_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","tadā mahāyājaka utthāya yīśum avādīt| tvaṁ kimapi na prativadasi? tvāmadhi kimete sākṣyaṁ vadanti? ");
INSERT INTO sanias_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","kintu yīśu rmaunībhūya tasyau| tato mahāyājaka uktavān, tvām amareśvaranāmnā śapayāmi, tvamīśvarasya putro'bhiṣikto bhavasi naveti vada| ");
INSERT INTO sanias_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","yīśuḥ pratyavadat, tvaṁ satyamuktavān; ahaṁ yuṣmān tathyaṁ vadāmi, itaḥparaṁ manujasutaṁ sarvvaśaktimato dakṣiṇapārśve sthātuṁ gagaṇasthaṁ jaladharānāruhyāyāntaṁ vīkṣadhve| ");
INSERT INTO sanias_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","tadā mahāyājako nijavasanaṁ chittvā jagāda, eṣa īśvaraṁ ninditavān, asmākamaparasākṣyeṇa kiṁ prayojanaṁ? paśyata, yūyamevāsyāsyād īśvaranindāṁ śrutavantaḥ, ");
INSERT INTO sanias_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","yuṣmābhiḥ kiṁ vivicyate? te pratyūcuḥ, vadhārho'yaṁ| ");
INSERT INTO sanias_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","tato lokaistadāsye niṣṭhīvitaṁ kecit pratalamāhatya kecicca capeṭamāhatya babhāṣire, ");
INSERT INTO sanias_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","he khrīṣṭa tvāṁ kaścapeṭamāhatavān? iti gaṇayitvā vadāsmān| ");
INSERT INTO sanias_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","pitaro bahiraṅgana upaviśati, tadānīmekā dāsī tamupāgatya babhāṣe, tvaṁ gālīlīyayīśoḥ sahacaraekaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","kintu sa sarvveṣāṁ samakṣam anaṅgīkṛtyāvādīt, tvayā yaducyate, tadarthamahaṁ na vedmi| ");
INSERT INTO sanias_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","tadā tasmin bahirdvāraṁ gate 'nyā dāsī taṁ nirīkṣya tatratyajanānavadat, ayamapi nāsaratīyayīśunā sārddham āsīt| ");
INSERT INTO sanias_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","tataḥ sa śapathena punaranaṅgīkṛtya kathitavān, taṁ naraṁ na paricinomi| ");
INSERT INTO sanias_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","kṣaṇāt paraṁ tiṣṭhanto janā etya pitaram avadan, tvamavaśyaṁ teṣāmeka iti tvaduccāraṇameva dyotayati| ");
INSERT INTO sanias_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","kintu so'bhiśapya kathitavān, taṁ janaṁ nāhaṁ paricinomi, tadā sapadi kukkuṭo rurāva| ");
INSERT INTO sanias_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","kukkuṭaravāt prāk tvaṁ māṁ trirapāhnoṣyase, yaiṣā vāg yīśunāvādi tāṁ pitaraḥ saṁsmṛtya bahiritvā khedād bhṛśaṁ cakranda| ");
INSERT INTO sanias_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","prabhāte jāte pradhānayājakalokaprācīnā yīśuṁ hantuṁ tatpratikūlaṁ mantrayitvā ");
INSERT INTO sanias_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","taṁ badvvā nītvā pantīyapīlātākhyādhipe samarpayāmāsuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","tato yīśoḥ parakarevvarpayitā yihūdāstatprāṇādaṇḍājñāṁ viditvā santaptamanāḥ pradhānayājakalokaprācīnānāṁ samakṣaṁ tāstrīṁśanmudrāḥ pratidāyāvādīt, ");
INSERT INTO sanias_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","etannirāgonaraprāṇaparakarārpaṇāt kaluṣaṁ kṛtavānahaṁ| tadā ta uditavantaḥ, tenāsmākaṁ kiṁ? tvayā tad budhyatām| ");
INSERT INTO sanias_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","tato yihūdā mandiramadhye tā mudrā nikṣipya prasthitavān itvā ca svayamātmānamudbabandha| ");
INSERT INTO sanias_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","paścāt pradhānayājakāstā mudrā ādāya kathitavantaḥ, etā mudrāḥ śoṇitamūlyaṁ tasmād bhāṇḍāgāre na nidhātavyāḥ| ");
INSERT INTO sanias_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","anantaraṁ te mantrayitvā videśināṁ śmaśānasthānāya tābhiḥ kulālasya kṣetramakrīṇan| ");
INSERT INTO sanias_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ato'dyāpi tatsthānaṁ raktakṣetraṁ vadanti| ");
INSERT INTO sanias_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","itthaṁ sati isrāyelīyasantānai ryasya mūlyaṁ nirupitaṁ, tasya triṁśanmudrāmānaṁ mūlyaṁ ");
INSERT INTO sanias_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","māṁ prati parameśvarasyādeśāt tebhya ādīyata, tena ca kulālasya kṣetraṁ krītamiti yadvacanaṁ yirimiyabhaviṣyadvādinā proktaṁ tat tadāsidhyat| ");
INSERT INTO sanias_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","anantaraṁ yīśau tadadhipateḥ sammukha upatiṣṭhati sa taṁ papraccha, tvaṁ kiṁ yihūdīyānāṁ rājā? tadā yīśustamavadat, tvaṁ satyamuktavān| ");
INSERT INTO sanias_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","kintu pradhānayājakaprācīnairabhiyuktena tena kimapi na pratyavādi| ");
INSERT INTO sanias_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","tataḥ pīlātena sa uditaḥ, ime tvatpratikūlataḥ kati kati sākṣyaṁ dadati, tat tvaṁ na śṛṇoṣi? ");
INSERT INTO sanias_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","tathāpi sa teṣāmekasyāpi vacasa uttaraṁ noditavān; tena so'dhipati rmahācitraṁ vidāmāsa| ");
INSERT INTO sanias_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","anyacca tanmahakāle'dhipateretādṛśī rātirāsīt, prajā yaṁ kañcana bandhinaṁ yācante, tameva sa mocayatīti| ");
INSERT INTO sanias_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","tadānīṁ barabbānāmā kaścit khyātabandhyāsīt| ");
INSERT INTO sanias_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","tataḥ pīlātastatra militān lokān apṛcchat, eṣa barabbā bandhī khrīṣṭavikhyāto yīśuścaitayoḥ kaṁ mocayiṣyāmi? yuṣmākaṁ kimīpsitaṁ? ");
INSERT INTO sanias_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","tairīrṣyayā sa samarpita iti sa jñātavān| ");
INSERT INTO sanias_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","aparaṁ vicārāsanopaveśanakāle pīlātasya patnī bhṛtyaṁ prahitya tasmai kathayāmāsa, taṁ dhārmmikamanujaṁ prati tvayā kimapi na karttavyaṁ; yasmāt tatkṛte'dyāhaṁ svapne prabhūtakaṣṭamalabhe| ");
INSERT INTO sanias_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","anantaraṁ pradhānayājakaprācīnā barabbāṁ yācitvādātuṁ yīśuñca hantuṁ sakalalokān prāvarttayan| ");
INSERT INTO sanias_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","tato'dhipatistān pṛṣṭavān, etayoḥ kamahaṁ mocayiṣyāmi? yuṣmākaṁ kecchā? te procu rbarabbāṁ| ");
INSERT INTO sanias_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","tadā pīlātaḥ papraccha, tarhi yaṁ khrīṣṭaṁ vadanti, taṁ yīśuṁ kiṁ kariṣyāmi? sarvve kathayāmāsuḥ, sa kruśena vidhyatāṁ| ");
INSERT INTO sanias_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","tato'dhipatiravādīt, kutaḥ? kiṁ tenāparāddhaṁ? kintu te punarucai rjagaduḥ, sa kruśena vidhyatāṁ| ");
INSERT INTO sanias_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","tadā nijavākyamagrāhyamabhūt, kalahaścāpyabhūt, pīlāta iti vilokya lokānāṁ samakṣaṁ toyamādāya karau prakṣālyāvocat, etasya dhārmmikamanuṣyasya śoṇitapāte nirdoṣo'haṁ, yuṣmābhireva tad budhyatāṁ| ");
INSERT INTO sanias_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","tadā sarvvāḥ prajāḥ pratyavocan, tasya śoṇitapātāparādho'smākam asmatsantānānāñcopari bhavatu| ");
INSERT INTO sanias_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","tataḥ sa teṣāṁ samīpe barabbāṁ mocayāmāsa yīśuntu kaṣābhirāhatya kruśena vedhituṁ samarpayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","anantaram adhipateḥ senā adhipate rgṛhaṁ yīśumānīya tasya samīpe senāsamūhaṁ saṁjagṛhuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","tataste tasya vasanaṁ mocayitvā kṛṣṇalohitavarṇavasanaṁ paridhāpayāmāsuḥ ");
INSERT INTO sanias_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","kaṇṭakānāṁ mukuṭaṁ nirmmāya tacchirasi daduḥ, tasya dakṣiṇakare vetramekaṁ dattvā tasya sammukhe jānūni pātayitvā, he yihūdīyānāṁ rājan, tubhyaṁ nama ityuktvā taṁ tiraścakruḥ, ");
INSERT INTO sanias_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","tatastasya gātre niṣṭhīvaṁ datvā tena vetreṇa śira ājaghnuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","itthaṁ taṁ tiraskṛtya tad vasanaṁ mocayitvā punarnijavasanaṁ paridhāpayāñcakruḥ, taṁ kruśena vedhituṁ nītavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","paścātte bahirbhūya kurīṇīyaṁ śimonnāmakamekaṁ vilokya kruśaṁ voḍhuṁ tamādadire| ");
INSERT INTO sanias_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","anantaraṁ gulgaltām arthāt śiraskapālanāmakasthānamu pasthāya te yīśave pittamiśritāmlarasaṁ pātuṁ daduḥ, ");
INSERT INTO sanias_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","kintu sa tamāsvādya na papau| ");
INSERT INTO sanias_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","tadānīṁ te taṁ kruśena saṁvidhya tasya vasanāni guṭikāpātena vibhajya jagṛhuḥ, tasmāt, vibhajante'dharīyaṁ me te manuṣyāḥ parasparaṁ| maduttarīyavastrārthaṁ guṭikāṁ pātayanti ca||yadetadvacanaṁ bhaviṣyadvādibhiruktamāsīt, tadā tad asidhyat, ");
INSERT INTO sanias_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","paścāt te tatropaviśya tadrakṣaṇakarvvaṇi niyuktāstasthuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","aparam eṣa yihūdīyānāṁ rājā yīśurityapavādalipipatraṁ tacchirasa ūrdvve yojayāmāsuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","tatastasya vāme dakṣiṇe ca dvau cairau tena sākaṁ kruśena vividhuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","tadā pānthā nijaśiro lāḍayitvā taṁ nindanto jagaduḥ, ");
INSERT INTO sanias_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","he īśvaramandirabhañjaka dinatraye tannirmmātaḥ svaṁ rakṣa, cettvamīśvarasutastarhi kruśādavaroha| ");
INSERT INTO sanias_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","pradhānayājakādhyāpakaprācīnāśca tathā tiraskṛtya jagaduḥ, ");
INSERT INTO sanias_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","so'nyajanānāvat, kintu svamavituṁ na śaknoti| yadīsrāyelo rājā bhavet, tarhīdānīmeva kruśādavarohatu, tena taṁ vayaṁ pratyeṣyāmaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","sa īśvare pratyāśāmakarot, yadīśvarastasmin santuṣṭastarhīdānīmeva tamavet, yataḥ sa uktavān ahamīśvarasutaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","yau stenau sākaṁ tena kruśena viddhau tau tadvadeva taṁ ninindatuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","tadā dvitīyayāmāt tṛtīyayāmaṁ yāvat sarvvadeśe tamiraṁ babhūva, ");
INSERT INTO sanias_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","tṛtīyayāme \"elī elī lāmā śivaktanī\", arthāt madīśvara madīśvara kuto māmatyākṣīḥ? yīśuruccairiti jagāda| ");
INSERT INTO sanias_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","tadā tatra sthitāḥ kecit tat śrutvā babhāṣire, ayam eliyamāhūyati| ");
INSERT INTO sanias_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","teṣāṁ madhyād ekaḥ śīghraṁ gatvā spañjaṁ gṛhītvā tatrāmlarasaṁ dattvā nalena pātuṁ tasmai dadau| ");
INSERT INTO sanias_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","itare'kathayan tiṣṭhata, taṁ rakṣitum eliya āyāti naveti paśyāmaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","yīśuḥ punarucairāhūya prāṇān jahau| ");
INSERT INTO sanias_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","tato mandirasya vicchedavasanam ūrdvvādadho yāvat chidyamānaṁ dvidhābhavat, ");
INSERT INTO sanias_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","bhūmiścakampe bhūdharovyadīryyata ca| śmaśāne mukte bhūripuṇyavatāṁ suptadehā udatiṣṭhan, ");
INSERT INTO sanias_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","śmaśānād vahirbhūya tadutthānāt paraṁ puṇyapuraṁ gatvā bahujanān darśayāmāsuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","yīśurakṣaṇāya niyuktaḥ śatasenāpatistatsaṅginaśca tādṛśīṁ bhūkampādighaṭanāṁ dṛṣṭvā bhītā avadan, eṣa īśvaraputro bhavati| ");
INSERT INTO sanias_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","yā bahuyoṣito yīśuṁ sevamānā gālīlastatpaścādāgatāstāsāṁ madhye ");
INSERT INTO sanias_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","magdalīnī mariyam yākūbyośyo rmātā yā mariyam sibadiyaputrayo rmātā ca yoṣita etā dūre tiṣṭhantyo dadṛśuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","sandhyāyāṁ satyam arimathiyānagarasya yūṣaphnāmā dhanī manujo yīśoḥ śiṣyatvāt ");
INSERT INTO sanias_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","pīlātasya samīpaṁ gatvā yīśoḥ kāyaṁ yayāce, tena pīlātaḥ kāyaṁ dātum ādideśa| ");
INSERT INTO sanias_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","yūṣaph tatkāyaṁ nītvā śucivastreṇācchādya ");
INSERT INTO sanias_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","svārthaṁ śaile yat śmaśānaṁ cakhāna, tanmadhye tatkāyaṁ nidhāya tasya dvāri vṛhatpāṣāṇaṁ dadau| ");
INSERT INTO sanias_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","kintu magdalīnī mariyam anyamariyam ete striyau tatra śmaśānasammukha upaviviśatuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","tadanantaraṁ nistārotsavasyāyojanadināt pare'hani pradhānayājakāḥ phirūśinaśca militvā pīlātamupāgatyākathayan, ");
INSERT INTO sanias_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","he maheccha sa pratārako jīvana akathayat, dinatrayāt paraṁ śmaśānādutthāsyāmi tadvākyaṁ smarāmo vayaṁ; ");
INSERT INTO sanias_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","tasmāt tṛtīyadinaṁ yāvat tat śmaśānaṁ rakṣitumādiśatu, nocet tacchiṣyā yāminyāmāgatya taṁ hṛtvā lokān vadiṣyanti, sa śmaśānādudatiṣṭhat, tathā sati prathamabhrānteḥ śeṣīyabhrānti rmahatī bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","tadā pīlāta avādīt, yuṣmākaṁ samīpe rakṣigaṇa āste, yūyaṁ gatvā yathā sādhyaṁ rakṣayata| ");
INSERT INTO sanias_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","tataste gatvā taddūाrapāṣāṇaṁ mudrāṅkitaṁ kṛtvā rakṣigaṇaṁ niyojya śmaśānaṁ rakṣayāmāsuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","tataḥ paraṁ viśrāmavārasya śeṣe saptāhaprathamadinasya prabhote jāte magdalīnī mariyam anyamariyam ca śmaśānaṁ draṣṭumāgatā| ");
INSERT INTO sanias_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","tadā mahān bhūkampo'bhavat; parameśvarīyadūtaḥ svargādavaruhya śmaśānadvārāt pāṣāṇamapasāryya taduparyyupaviveśa| ");
INSERT INTO sanias_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","tadvadanaṁ vidyudvat tejomayaṁ vasanaṁ himaśubhrañca| ");
INSERT INTO sanias_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","tadānīṁ rakṣiṇastadbhayāt kampitā mṛtavad babhūvaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","sa dūto yoṣito jagāda, yūyaṁ mā bhaiṣṭa, kruśahatayīśuṁ mṛgayadhve tadahaṁ vedmi| ");
INSERT INTO sanias_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","so'tra nāsti, yathāvadat tathotthitavān; etat prabhoḥ śayanasthānaṁ paśyata| ");
INSERT INTO sanias_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","tūrṇaṁ gatvā tacchiṣyān iti vadata, sa śmaśānād udatiṣṭhat, yuṣmākamagre gālīlaṁ yāsyati yūyaṁ tatra taṁ vīkṣiṣyadhve, paśyatāhaṁ vārttāmimāṁ yuṣmānavādiṣaṁ| ");
INSERT INTO sanias_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","tatastā bhayāt mahānandāñca śmaśānāt tūrṇaṁ bahirbhūya tacchiṣyān vārttāṁ vaktuṁ dhāvitavatyaḥ| kintu śiṣyān vārttāṁ vaktuṁ yānti, tadā yīśu rdarśanaṁ dattvā tā jagāda, ");
INSERT INTO sanias_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","yuṣmākaṁ kalyāṇaṁ bhūyāt, tatastā āgatya tatpādayoḥ patitvā praṇemuḥ| ");
INSERT INTO sanias_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","yīśustā avādīt, mā bibhīta, yūyaṁ gatvā mama bhrātṛn gālīlaṁ yātuṁ vadata, tatra te māṁ drakṣyanti| ");
INSERT INTO sanias_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","striyo gacchanti, tadā rakṣiṇāṁ kecit puraṁ gatvā yadyad ghaṭitaṁ tatsarvvaṁ pradhānayājakān jñāpitavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","te prācīnaiḥ samaṁ saṁsadaṁ kṛtvā mantrayanto bahumudrāḥ senābhyo dattvāvadan, ");
INSERT INTO sanias_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","asmāsu nidriteṣu tacchiṣyā yāminyāmāgatya taṁ hṛtvānayan, iti yūyaṁ pracārayata| ");
INSERT INTO sanias_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","yadyetadadhipateḥ śrotragocarībhavet, tarhi taṁ bodhayitvā yuṣmānaviṣyāmaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","tataste mudrā gṛhītvā śikṣānurūpaṁ karmma cakruḥ, yihūdīyānāṁ madhye tasyādyāpi kiṁvadantī vidyate| ");
INSERT INTO sanias_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ekādaśa śiṣyā yīśunirūpitāgālīlasyādriṁ gatvā ");
INSERT INTO sanias_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","tatra taṁ saṁvīkṣya praṇemuḥ, kintu kecit sandigdhavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","yīśusteṣāṁ samīpamāgatya vyāhṛtavān, svargamedinyoḥ sarvvādhipatitvabhāro mayyarpita āste| ");
INSERT INTO sanias_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ato yūyaṁ prayāya sarvvadeśīyān śiṣyān kṛtvā pituḥ putrasya pavitrasyātmanaśca nāmnā tānavagāhayata; ahaṁ yuṣmān yadyadādiśaṁ tadapi pālayituṁ tānupādiśata| ");
INSERT INTO sanias_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","paśyata, jagadantaṁ yāvat sadāhaṁ yuṣmābhiḥ sākaṁ tiṣṭhāmi| iti|");
INSERT INTO sanias_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","īśvaraputrasya yīśukhrīṣṭasya susaṁvādārambhaḥ| ");
INSERT INTO sanias_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","bhaviṣyadvādināṁ grantheṣu lipiritthamāste, paśya svakīyadūtantu tavāgre preṣayāmyaham| gatvā tvadīyapanthānaṁ sa hi pariṣkariṣyati| ");
INSERT INTO sanias_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","\"parameśasya panthānaṁ pariṣkuruta sarvvataḥ| tasya rājapathañcaiva samānaṁ kurutādhunā|\" ityetat prāntare vākyaṁ vadataḥ kasyacidravaḥ|| ");
INSERT INTO sanias_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","saeva yohan prāntare majjitavān tathā pāpamārjananimittaṁ manovyāvarttakamajjanasya kathāñca pracāritavān| ");
INSERT INTO sanias_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","tato yihūdādeśayirūśālamnagaranivāsinaḥ sarvve lokā bahi rbhūtvā tasya samīpamāgatya svāni svāni pāpānyaṅgīkṛtya yarddananadyāṁ tena majjitā babhūvuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","asya yohanaḥ paridheyāni kramelakalomajāni, tasya kaṭibandhanaṁ carmmajātam, tasya bhakṣyāṇi ca śūkakīṭā vanyamadhūni cāsan| ");
INSERT INTO sanias_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","sa pracārayan kathayāñcakre, ahaṁ namrībhūya yasya pādukābandhanaṁ mocayitumapi na yogyosmi, tādṛśo matto gurutara ekaḥ puruṣo matpaścādāgacchati| ");
INSERT INTO sanias_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ahaṁ yuṣmān jale majjitavān kintu sa pavitra ātmāni saṁmajjayiṣyati| ");
INSERT INTO sanias_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","aparañca tasminneva kāle gālīlpradeśasya nāsaradgrāmād yīśurāgatya yohanā yarddananadyāṁ majjito'bhūt| ");
INSERT INTO sanias_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","sa jalādutthitamātro meghadvāraṁ muktaṁ kapotavat svasyopari avarohantamātmānañca dṛṣṭavān| ");
INSERT INTO sanias_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","tvaṁ mama priyaḥ putrastvayyeva mamamahāsantoṣa iyamākāśīyā vāṇī babhūva| ");
INSERT INTO sanias_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","tasmin kāle ātmā taṁ prāntaramadhyaṁ nināya| ");
INSERT INTO sanias_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","atha sa catvāriṁśaddināni tasmin sthāne vanyapaśubhiḥ saha tiṣṭhan śaitānā parīkṣitaḥ; paścāt svargīyadūtāstaṁ siṣevire| ");
INSERT INTO sanias_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","anantaraṁ yohani bandhanālaye baddhe sati yīśu rgālīlpradeśamāgatya īśvararājyasya susaṁvādaṁ pracārayan kathayāmāsa, ");
INSERT INTO sanias_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","kālaḥ sampūrṇa īśvararājyañca samīpamāgataṁ; atoheto ryūyaṁ manāṁsi vyāvarttayadhvaṁ susaṁvāde ca viśvāsita| ");
INSERT INTO sanias_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","tadanantaraṁ sa gālīlīyasamudrasya tīre gacchan śimon tasya bhrātā andriyanāmā ca imau dvau janau matsyadhāriṇau sāgaramadhye jālaṁ prakṣipantau dṛṣṭvā tāvavadat, ");
INSERT INTO sanias_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","yuvāṁ mama paścādāgacchataṁ, yuvāmahaṁ manuṣyadhāriṇau kariṣyāmi| ");
INSERT INTO sanias_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","tatastau tatkṣaṇameva jālāni parityajya tasya paścāt jagmatuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","tataḥ paraṁ tatsthānāt kiñcid dūraṁ gatvā sa sivadīputrayākūb tadbhrātṛyohan ca imau naukāyāṁ jālānāṁ jīrṇamuddhārayantau dṛṣṭvā tāvāhūyat| ");
INSERT INTO sanias_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","tatastau naukāyāṁ vetanabhugbhiḥ sahitaṁ svapitaraṁ vihāya tatpaścādīyatuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","tataḥ paraṁ kapharnāhūmnāmakaṁ nagaramupasthāya sa viśrāmadivase bhajanagrahaṁ praviśya samupadideśa| ");
INSERT INTO sanias_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","tasyopadeśāllokā āścaryyaṁ menire yataḥ sodhyāpakāiva nopadiśan prabhāvavāniva propadideśa| ");
INSERT INTO sanias_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","aparañca tasmin bhajanagṛhe apavitrabhūtena grasta eko mānuṣa āsīt| sa cītśabdaṁ kṛtvā kathayāñcake ");
INSERT INTO sanias_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","bho nāsaratīya yīśo tvamasmān tyaja, tvayā sahāsmākaṁ kaḥ sambandhaḥ? tvaṁ kimasmān nāśayituṁ samāgataḥ? tvamīśvarasya pavitraloka ityahaṁ jānāmi| ");
INSERT INTO sanias_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","tadā yīśustaṁ tarjayitvā jagāda tūṣṇīṁ bhava ito bahirbhava ca| ");
INSERT INTO sanias_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","tataḥ so'pavitrabhūtastaṁ sampīḍya atyucaiścītkṛtya nirjagāma| ");
INSERT INTO sanias_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","tenaiva sarvve camatkṛtya parasparaṁ kathayāñcakrire, aho kimidaṁ? kīdṛśo'yaṁ navya upadeśaḥ? anena prabhāvenāpavitrabhūteṣvājñāpiteṣu te tadājñānuvarttino bhavanti| ");
INSERT INTO sanias_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","tadā tasya yaśo gālīlaścaturdiksthasarvvadeśān vyāpnot| ");
INSERT INTO sanias_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","aparañca te bhajanagṛhād bahi rbhūtvā yākūbyohanbhyāṁ saha śimona āndriyasya ca niveśanaṁ praviviśuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","tadā pitarasya śvaśrūrjvarapīḍitā śayyāyāmāsta iti te taṁ jhaṭiti vijñāpayāñcakruḥ| ");
INSERT INTO sanias_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","tataḥ sa āgatya tasyā hastaṁ dhṛtvā tāmudasthāpayat; tadaiva tāṁ jvaro'tyākṣīt tataḥ paraṁ sā tān siṣeve| ");
INSERT INTO sanias_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","athāstaṁ gate ravau sandhyākāle sati lokāstatsamīpaṁ sarvvān rogiṇo bhūtadhṛtāṁśca samāninyuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","sarvve nāgarikā lokā dvāri saṁmilitāśca| ");
INSERT INTO sanias_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","tataḥ sa nānāvidharogiṇo bahūn manujānarogiṇaścakāra tathā bahūn bhūtān tyājayāñcakāra tān bhūtān kimapi vākyaṁ vaktuṁ niṣiṣedha ca yatohetoste tamajānan| ");
INSERT INTO sanias_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","aparañca so'tipratyūṣe vastutastu rātriśeṣe samutthāya bahirbhūya nirjanaṁ sthānaṁ gatvā tatra prārthayāñcakre| ");
INSERT INTO sanias_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","anantaraṁ śimon tatsaṅginaśca tasya paścād gatavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","taduddeśaṁ prāpya tamavadan sarvve lokāstvāṁ mṛgayante| ");
INSERT INTO sanias_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","tadā so'kathayat āgacchata vayaṁ samīpasthāni nagarāṇi yāmaḥ, yato'haṁ tatra kathāṁ pracārayituṁ bahirāgamam| ");
INSERT INTO sanias_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","atha sa teṣāṁ gālīlpradeśasya sarvveṣu bhajanagṛheṣu kathāḥ pracārayāñcakre bhūtānatyājayañca| ");
INSERT INTO sanias_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","anantaramekaḥ kuṣṭhī samāgatya tatsammukhe jānupātaṁ vinayañca kṛtvā kathitavān yadi bhavān icchati tarhi māṁ pariṣkarttuṁ śaknoti| ");
INSERT INTO sanias_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","tataḥ kṛpālu ryīśuḥ karau prasāryya taṁ spaṣṭvā kathayāmāsa ");
INSERT INTO sanias_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","mamecchā vidyate tvaṁ pariṣkṛto bhava| etatkathāyāḥ kathanamātrāt sa kuṣṭhī rogānmuktaḥ pariṣkṛto'bhavat| ");
INSERT INTO sanias_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","tadā sa taṁ visṛjan gāḍhamādiśya jagāda ");
INSERT INTO sanias_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","sāvadhāno bhava kathāmimāṁ kamapi mā vada; svātmānaṁ yājakaṁ darśaya, lokebhyaḥ svapariṣkṛteḥ pramāṇadānāya mūsānirṇītaṁ yaddānaṁ tadutsṛjasva ca| ");
INSERT INTO sanias_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","kintu sa gatvā tat karmma itthaṁ vistāryya pracārayituṁ prārebhe tenaiva yīśuḥ punaḥ saprakāśaṁ nagaraṁ praveṣṭuṁ nāśaknot tatohetorbahiḥ kānanasthāne tasyau; tathāpi caturddigbhyo lokāstasya samīpamāyayuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","tadanantaraṁ yīśai katipayadināni vilambya punaḥ kapharnāhūmnagaraṁ praviṣṭe sa gṛha āsta iti kiṁvadantyā tatkṣaṇaṁ tatsamīpaṁ bahavo lokā āgatya samupatasthuḥ, ");
INSERT INTO sanias_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","tasmād gṛhamadhye sarvveṣāṁ kṛte sthānaṁ nābhavad dvārasya caturdikṣvapi nābhavat, tatkāle sa tān prati kathāṁ pracārayāñcakre| ");
INSERT INTO sanias_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","tataḥ paraṁ lokāścaturbhi rmānavairekaṁ pakṣāghātinaṁ vāhayitvā tatsamīpam āninyuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","kintu janānāṁ bahutvāt taṁ yīśoḥ sammukhamānetuṁ na śaknuvanto yasmin sthāne sa āste taduparigṛhapṛṣṭhaṁ khanitvā chidraṁ kṛtvā tena mārgeṇa saśayyaṁ pakṣāghātinam avarohayāmāsuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","tato yīśusteṣāṁ viśvāsaṁ dṛṣṭvā taṁ pakṣāghātinaṁ babhāṣe he vatsa tava pāpānāṁ mārjanaṁ bhavatu| ");
INSERT INTO sanias_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","tadā kiyanto'dhyāpakāstatropaviśanto manobhi rvitarkayāñcakruḥ, eṣa manuṣya etādṛśīmīśvaranindāṁ kathāṁ kutaḥ kathayati? ");
INSERT INTO sanias_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","īśvaraṁ vinā pāpāni mārṣṭuṁ kasya sāmarthyam āste? ");
INSERT INTO sanias_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","itthaṁ te vitarkayanti yīśustatkṣaṇaṁ manasā tad budvvā tānavadad yūyamantaḥkaraṇaiḥ kuta etāni vitarkayatha? ");
INSERT INTO sanias_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","tadanantaraṁ yīśustatsthānāt punaḥ samudrataṭaṁ yayau; lokanivahe tatsamīpamāgate sa tān samupadideśa| ");
INSERT INTO sanias_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","kintu pṛthivyāṁ pāpāni mārṣṭuṁ manuṣyaputrasya sāmarthyamasti, etad yuṣmān jñāpayituṁ (sa tasmai pakṣāghātine kathayāmāsa) ");
INSERT INTO sanias_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","uttiṣṭha tava śayyāṁ gṛhītvā svagṛhaṁ yāhi, ahaṁ tvāmidam ājñāpayāmi| ");
INSERT INTO sanias_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","tataḥ sa tatkṣaṇam utthāya śayyāṁ gṛhītvā sarvveṣāṁ sākṣāt jagāma; sarvve vismitā etādṛśaṁ karmma vayam kadāpi nāpaśyāma, imāṁ kathāṁ kathayitveśvaraṁ dhanyamabruvan| ");
INSERT INTO sanias_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","tadanantaraṁ yīśustatsthānāt punaḥ samudrataṭaṁ yayau; lokanivahe tatsamīpamāgate sa tān samupadideśa| ");
INSERT INTO sanias_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","atha gacchan karasañcayagṛha upaviṣṭam ālphīyaputraṁ leviṁ dṛṣṭvā tamāhūya kathitavān matpaścāt tvāmāmaccha tataḥ sa utthāya tatpaścād yayau| ");
INSERT INTO sanias_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","anantaraṁ yīśau tasya gṛhe bhoktum upaviṣṭe bahavaḥ karamañcāyinaḥ pāpinaśca tena tacchiṣyaiśca sahopaviviśuḥ, yato bahavastatpaścādājagmuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","tadā sa karamañcāyibhiḥ pāpibhiśca saha khādati, tad dṛṣṭvādhyāpakāḥ phirūśinaśca tasya śiṣyānūcuḥ karamañcāyibhiḥ pāpibhiśca sahāyaṁ kuto bhuṁkte pivati ca? ");
INSERT INTO sanias_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","tadvākyaṁ śrutvā yīśuḥ pratyuvāca,arogilokānāṁ cikitsakena prayojanaṁ nāsti, kintu rogiṇāmeva; ahaṁ dhārmmikānāhvātuṁ nāgataḥ kintu mano vyāvarttayituṁ pāpina eva| ");
INSERT INTO sanias_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","tataḥ paraṁ yohanaḥ phirūśināñcopavāsācāriśiṣyā yīśoḥ samīpam āgatya kathayāmāsuḥ, yohanaḥ phirūśināñca śiṣyā upavasanti kintu bhavataḥ śiṣyā nopavasanti kiṁ kāraṇamasya? ");
INSERT INTO sanias_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","tadā yīśustān babhāṣe yāvat kālaṁ sakhibhiḥ saha kanyāyā varastiṣṭhati tāvatkālaṁ te kimupavastuṁ śaknuvanti? yāvatkālaṁ varastaiḥ saha tiṣṭhati tāvatkālaṁ ta upavastuṁ na śaknuvanti| ");
INSERT INTO sanias_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","yasmin kāle tebhyaḥ sakāśād varo neṣyate sa kāla āgacchati, tasmin kāle te janā upavatsyanti| ");
INSERT INTO sanias_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","kopi janaḥ purātanavastre nūtanavastraṁ na sīvyati, yato nūtanavastreṇa saha sevane kṛte jīrṇaṁ vastraṁ chidyate tasmāt puna rmahat chidraṁ jāyate| ");
INSERT INTO sanias_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","kopi janaḥ purātanakutūṣu nūtanaṁ drākṣārasaṁ na sthāpayati, yato nūtanadrākṣārasasya tejasā tāḥ kutvo vidīryyante tato drākṣārasaśca patati kutvaśca naśyanti, ataeva nūtanadrākṣāraso nūtanakutūṣu sthāpanīyaḥ| ");
INSERT INTO sanias_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","tadanantaraṁ yīśu ryadā viśrāmavāre śasyakṣetreṇa gacchati tadā tasya śiṣyā gacchantaḥ śasyamañjarīśchettuṁ pravṛttāḥ| ");
INSERT INTO sanias_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ataḥ phirūśino yīśave kathayāmāsuḥ paśyatu viśrāmavāsare yat karmma na karttavyaṁ tad ime kutaḥ kurvvanti? ");
INSERT INTO sanias_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","tadā sa tebhyo'kathayat dāyūd tatsaṁṅginaśca bhakṣyābhāvāt kṣudhitāḥ santo yat karmma kṛtavantastat kiṁ yuṣmābhi rna paṭhitam? ");
INSERT INTO sanias_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","abiyātharnāmake mahāyājakatāṁ kurvvati sa kathamīśvarasyāvāsaṁ praviśya ye darśanīyapūpā yājakān vinānyasya kasyāpi na bhakṣyāstāneva bubhuje saṅgilokebhyo'pi dadau| ");
INSERT INTO sanias_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","so'paramapi jagāda, viśrāmavāro manuṣyārthameva nirūpito'sti kintu manuṣyo viśrāmavārārthaṁ naiva| ");
INSERT INTO sanias_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","manuṣyaputro viśrāmavārasyāpi prabhurāste| ");
INSERT INTO sanias_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","anantaraṁ yīśuḥ puna rbhajanagṛhaṁ praviṣṭastasmin sthāne śuṣkahasta eko mānava āsīt| ");
INSERT INTO sanias_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","sa viśrāmavāre tamarogiṇaṁ kariṣyati navetyatra bahavastam apavadituṁ chidramapekṣitavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","tadā sa taṁ śuṣkahastaṁ manuṣyaṁ jagāda madhyasthāne tvamuttiṣṭha| ");
INSERT INTO sanias_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","tataḥ paraṁ sa tān papraccha viśrāmavāre hitamahitaṁ tathā hi prāṇarakṣā vā prāṇanāśa eṣāṁ madhye kiṁ karaṇīyaṁ ? kintu te niḥśabdāstasthuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","tadā sa teṣāmantaḥkaraṇānāṁ kāṭhinyāddheto rduḥkhitaḥ krodhāt cartuिdaśo dṛṣṭavān taṁ mānuṣaṁ gaditavān taṁ hastaṁ vistāraya, tatastena haste vistṛte taddhasto'nyahastavad arogo jātaḥ| ");
INSERT INTO sanias_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","atha phirūśinaḥ prasthāya taṁ nāśayituṁ herodīyaiḥ saha mantrayitumārebhire| ");
INSERT INTO sanias_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ataeva yīśustatsthānaṁ parityajya śiṣyaiḥ saha punaḥ sāgarasamīpaṁ gataḥ; ");
INSERT INTO sanias_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","tato gālīlyihūdā-yirūśālam-idom-yardannadīpārasthānebhyo lokasamūhastasya paścād gataḥ; tadanyaḥ sorasīdanoḥ samīpavāsilokasamūhaśca tasya mahākarmmaṇāṁ vārttaṁ śrutvā tasya sannidhimāgataḥ| ");
INSERT INTO sanias_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","tadā lokasamūhaścet tasyopari patati ityāśaṅkya sa nāvamekāṁ nikaṭe sthāpayituṁ śiṣyānādiṣṭavān| ");
INSERT INTO sanias_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","yato'nekamanuṣyāṇāmārogyakaraṇād vyādhigrastāḥ sarvve taṁ spraṣṭuṁ parasparaṁ balena yatnavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","aparañca apavitrabhūtāstaṁ dṛṣṭvā taccaraṇayoḥ patitvā procaiḥ procuḥ, tvamīśvarasya putraḥ| ");
INSERT INTO sanias_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","kintu sa tān dṛḍham ājñāpya svaṁ paricāyituṁ niṣiddhavān| ");
INSERT INTO sanias_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","anantaraṁ sa parvvatamāruhya yaṁ yaṁ praticchā taṁ tamāhūtavān tataste tatsamīpamāgatāḥ| ");
INSERT INTO sanias_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","tadā sa dvādaśajanān svena saha sthātuṁ susaṁvādapracārāya preritā bhavituṁ ");
INSERT INTO sanias_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","sarvvaprakāravyādhīnāṁ śamanakaraṇāya prabhāvaṁ prāptuṁ bhūtān tyājayituñca niyuktavān| ");
INSERT INTO sanias_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","teṣāṁ nāmānīmāni, śimon sivadiputro ");
INSERT INTO sanias_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","yākūb tasya bhrātā yohan ca āndriyaḥ philipo barthalamayaḥ, ");
INSERT INTO sanias_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","mathī thomā ca ālphīyaputro yākūb thaddīyaḥ kinānīyaḥ śimon yastaṁ parahasteṣvarpayiṣyati sa īṣkariyotīyayihūdāśca| ");
INSERT INTO sanias_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","sa śimone pitara ityupanāma dadau yākūbyohanbhyāṁ ca binerigiś arthato meghanādaputrāvityupanāma dadau| ");
INSERT INTO sanias_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","anantaraṁ te niveśanaṁ gatāḥ, kintu tatrāpi punarmahān janasamāgamo 'bhavat tasmātte bhoktumapyavakāśaṁ na prāptāḥ| ");
INSERT INTO sanias_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","tatastasya suhṛllokā imāṁ vārttāṁ prāpya sa hatajñānobhūd iti kathāṁ kathayitvā taṁ dhṛtvānetuṁ gatāḥ| ");
INSERT INTO sanias_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","aparañca yirūśālama āgatā ye ye'dhyāpakāste jagadurayaṁ puruṣo bhūtapatyābiṣṭastena bhūtapatinā bhūtān tyājayati| ");
INSERT INTO sanias_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","tatastānāhūya yīśu rdṛṣṭāntaiḥ kathāṁ kathitavān śaitān kathaṁ śaitānaṁ tyājayituṁ śaknoti? ");
INSERT INTO sanias_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","kiñcana rājyaṁ yadi svavirodhena pṛthag bhavati tarhi tad rājyaṁ sthiraṁ sthātuṁ na śaknoti| ");
INSERT INTO sanias_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","tathā kasyāpi parivāro yadi parasparaṁ virodhī bhavati tarhi sopi parivāraḥ sthiraṁ sthātuṁ na śaknoti| ");
INSERT INTO sanias_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","tadvat śaitān yadi svavipakṣatayā uttiṣṭhan bhinno bhavati tarhi sopi sthiraṁ sthātuṁ na śaknoti kintūcchinno bhavati| ");
INSERT INTO sanias_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","aparañca prabalaṁ janaṁ prathamaṁ na baddhā kopi tasya gṛhaṁ praviśya dravyāṇi luṇṭhayituṁ na śaknoti, taṁ badvvaiva tasya gṛhasya dravyāṇi luṇṭhayituṁ śaknoti| ");
INSERT INTO sanias_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","atoheto ryuṣmabhyamahaṁ satyaṁ kathayāmi manuṣyāṇāṁ santānā yāni yāni pāpānīśvaranindāñca kurvvanti teṣāṁ tatsarvveṣāmaparādhānāṁ kṣamā bhavituṁ śaknoti, ");
INSERT INTO sanias_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","kintu yaḥ kaścit pavitramātmānaṁ nindati tasyāparādhasya kṣamā kadāpi na bhaviṣyati sonantadaṇḍasyārho bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","tasyāpavitrabhūto'sti teṣāmetatkathāhetoḥ sa itthaṁ kathitavān| ");
INSERT INTO sanias_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","atha tasya mātā bhrātṛgaṇaścāgatya bahistiṣṭhanato lokān preṣya tamāhūtavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","tatastatsannidhau samupaviṣṭā lokāstaṁ babhāṣire paśya bahistava mātā bhrātaraśca tvām anvicchanti| ");
INSERT INTO sanias_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","tadā sa tān pratyuvāca mama mātā kā bhrātaro vā ke? tataḥ paraṁ sa svamīpopaviṣṭān śiṣyān prati avalokanaṁ kṛtvā kathayāmāsa ");
INSERT INTO sanias_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","paśyataite mama mātā bhrātaraśca| ");
INSERT INTO sanias_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","yaḥ kaścid īśvarasyeṣṭāṁ kriyāṁ karoti sa eva mama bhrātā bhaginī mātā ca| ");
INSERT INTO sanias_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","anantaraṁ sa samudrataṭe punarupadeṣṭuṁ prārebhe, tatastatra bahujanānāṁ samāgamāt sa sāgaropari naukāmāruhya samupaviṣṭaḥ; sarvve lokāḥ samudrakūle tasthuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","tadā sa dṛṣṭāntakathābhi rbahūpadiṣṭavān upadiśaṁśca kathitavān, ");
INSERT INTO sanias_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","avadhānaṁ kuruta, eko bījavaptā bījāni vaptuṁ gataḥ; ");
INSERT INTO sanias_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","vapanakāle kiyanti bījāni mārgapāśve patitāni, tata ākāśīyapakṣiṇa etya tāni cakhāduḥ| ");
INSERT INTO sanias_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","kiyanti bījāni svalpamṛttikāvatpāṣāṇabhūmau patitāni tāni mṛdolpatvāt śīghramaṅkuritāni; ");
INSERT INTO sanias_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","kintūdite sūryye dagdhāni tathā mūlāno nādhogatatvāt śuṣkāṇi ca| ");
INSERT INTO sanias_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","kiyanti bījāni kaṇṭakivanamadhye patitāni tataḥ kaṇṭakāni saṁvṛdvya tāni jagrasustāni na ca phalitāni| ");
INSERT INTO sanias_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","tathā kiyanti bījānyuttamabhūmau patitāni tāni saṁvṛdvya phalānyutpāditāni kiyanti bījāni triṁśadguṇāni kiyanti ṣaṣṭiguṇāni kiyanti śataguṇāni phalāni phalitavanti| ");
INSERT INTO sanias_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","atha sa tānavadat yasya śrotuṁ karṇau staḥ sa śṛṇotu| ");
INSERT INTO sanias_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","tadanantaraṁ nirjanasamaye tatsaṅgino dvādaśaśiṣyāśca taṁ taddṛṣṭāntavākyasyārthaṁ papracchuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","tadā sa tānuditavān īśvararājyasya nigūḍhavākyaṁ boddhuṁ yuṣmākamadhikāro'sti; ");
INSERT INTO sanias_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","kintu ye vahirbhūtāḥ \"te paśyantaḥ paśyanti kintu na jānanti, śṛṇvantaḥ śṛṇvanti kintu na budhyante, cettai rmanaḥsu kadāpi parivarttiteṣu teṣāṁ pāpānyamocayiṣyanta,\" atohetostān prati dṛṣṭāntaireva tāni mayā kathitāni| ");
INSERT INTO sanias_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","atha sa kathitavān yūyaṁ kimetad dṛṣṭāntavākyaṁ na budhyadhve? tarhi kathaṁ sarvvān dṛṣṭāntāna bhotsyadhve? ");
INSERT INTO sanias_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","bījavaptā vākyarūpāṇi bījāni vapati; ");
INSERT INTO sanias_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","tatra ye ye lokā vākyaṁ śṛṇvanti, kintu śrutamātrāt śaitān śīghramāgatya teṣāṁ manaḥsūptāni tāni vākyarūpāṇi bījānyapanayati taeva uptabījamārgapārśvesvarūpāḥ| ");
INSERT INTO sanias_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ye janā vākyaṁ śrutvā sahasā paramānandena gṛhlanti, kintu hṛdi sthairyyābhāvāt kiñcit kālamātraṁ tiṣṭhanti tatpaścāt tadvākyahetoḥ ");
INSERT INTO sanias_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","kutracit kleśe upadrave vā samupasthite tadaiva vighnaṁ prāpnuvanti taeva uptabījapāṣāṇabhūmisvarūpāḥ| ");
INSERT INTO sanias_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","ye janāḥ kathāṁ śṛṇvanti kintu sāṁsārikī cintā dhanabhrānti rviṣayalobhaśca ete sarvve upasthāya tāṁ kathāṁ grasanti tataḥ mā viphalā bhavati ");
INSERT INTO sanias_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","taeva uptabījasakaṇṭakabhūmisvarūpāḥ| ");
INSERT INTO sanias_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ye janā vākyaṁ śrutvā gṛhlanti teṣāṁ kasya vā triṁśadguṇāni kasya vā ṣaṣṭiguṇāni kasya vā śataguṇāni phalāni bhavanti taeva uptabījorvvarabhūmisvarūpāḥ| ");
INSERT INTO sanias_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","tadā so'paramapi kathitavān kopi jano dīpādhāraṁ parityajya droṇasyādhaḥ khaṭvāyā adhe vā sthāpayituṁ dīpamānayati kiṁ? ");
INSERT INTO sanias_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","atoheto ryanna prakāśayiṣyate tādṛg lukkāyitaṁ kimapi vastu nāsti; yad vyaktaṁ na bhaviṣyati tādṛśaṁ guptaṁ kimapi vastu nāsti| ");
INSERT INTO sanias_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","yasya śrotuṁ karṇau staḥ sa śṛṇotu| ");
INSERT INTO sanias_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","aparamapi kathitavān yūyaṁ yad yad vākyaṁ śṛṇutha tatra sāvadhānā bhavata, yato yūyaṁ yena parimāṇena parimātha tenaiva parimāṇena yuṣmadarthamapi parimāsyate; śrotāro yūyaṁ yuṣmabhyamadhikaṁ dāsyate| ");
INSERT INTO sanias_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","yasyāśraye varddhate tasmai aparamapi dāsyate, kintu yasyāśraye na varddhate tasya yat kiñcidasti tadapi tasmān neṣyate| ");
INSERT INTO sanias_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","anantaraṁ sa kathitavān eko lokaḥ kṣetre bījānyuptvā ");
INSERT INTO sanias_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","jāgaraṇanidrābhyāṁ divāniśaṁ gamayati, parantu tadvījaṁ tasyājñātarūpeṇāṅkurayati varddhate ca; ");
INSERT INTO sanias_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","yatohetoḥ prathamataḥ patrāṇi tataḥ paraṁ kaṇiśāni tatpaścāt kaṇiśapūrṇāni śasyāni bhūmiḥ svayamutpādayati; ");
INSERT INTO sanias_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","kintu phaleṣu pakkeṣu śasyacchedanakālaṁ jñātvā sa tatkṣaṇaṁ śasyāni chinatti, anena tulyamīśvararājyaṁ| ");
INSERT INTO sanias_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","punaḥ so'kathayad īśvararājyaṁ kena samaṁ? kena vastunā saha vā tadupamāsyāmi? ");
INSERT INTO sanias_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","tat sarṣapaikena tulyaṁ yato mṛdi vapanakāle sarṣapabījaṁ sarvvapṛthivīsthabījāt kṣudraṁ ");
INSERT INTO sanias_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","kintu vapanāt param aṅkurayitvā sarvvaśākād bṛhad bhavati, tasya bṛhatyaḥ śākhāśca jāyante tatastacchāyāṁ pakṣiṇa āśrayante| ");
INSERT INTO sanias_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","itthaṁ teṣāṁ bodhānurūpaṁ so'nekadṛṣṭāntaistānupadiṣṭavān, ");
INSERT INTO sanias_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","dṛṣṭāntaṁ vinā kāmapi kathāṁ tebhyo na kathitavān paścān nirjane sa śiṣyān sarvvadṛṣṭāntārthaṁ bodhitavān| ");
INSERT INTO sanias_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","taddinasya sandhyāyāṁ sa tebhyo'kathayad āgacchata vayaṁ pāraṁ yāma| ");
INSERT INTO sanias_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","tadā te lokān visṛjya tamavilambaṁ gṛhītvā naukayā pratasthire; aparā api nāvastayā saha sthitāḥ| ");
INSERT INTO sanias_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","tataḥ paraṁ mahājhañbhśagamāt nau rdolāyamānā taraṅgeṇa jalaiḥ pūrṇābhavacca| ");
INSERT INTO sanias_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","tadā sa naukācaścādbhāge upadhāne śiro nidhāya nidrita āsīt tataste taṁ jāgarayitvā jagaduḥ, he prabho, asmākaṁ prāṇā yānti kimatra bhavataścintā nāsti? ");
INSERT INTO sanias_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","tadā sa utthāya vāyuṁ tarjitavān samudrañcoktavān śāntaḥ susthiraśca bhava; tato vāyau nivṛtte'bdhirnistaraṅgobhūt| ");
INSERT INTO sanias_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","tadā sa tānuvāca yūyaṁ kuta etādṛkśaṅkākulā bhavata? kiṁ vo viśvāso nāsti? ");
INSERT INTO sanias_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","tasmātte'tīvabhītāḥ parasparaṁ vaktumārebhire, aho vāyuḥ sindhuścāsya nideśagrāhiṇau kīdṛgayaṁ manujaḥ| ");
INSERT INTO sanias_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","atha tū sindhupāraṁ gatvā giderīyapradeśa upatasthuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","naukāto nirgatamātrād apavitrabhūtagrasta ekaḥ śmaśānādetya taṁ sākṣāc cakāra| ");
INSERT INTO sanias_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","sa śmaśāne'vātsīt kopi taṁ śṛṅkhalena badvvā sthāpayituṁ nāśaknot| ");
INSERT INTO sanias_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","janairvāraṁ nigaḍaiḥ śṛṅkhalaiśca sa baddhopi śṛṅkhalānyākṛṣya mocitavān nigaḍāni ca bhaṁktvā khaṇḍaṁ khaṇḍaṁ kṛtavān kopi taṁ vaśīkarttuṁ na śaśaka| ");
INSERT INTO sanias_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","divāniśaṁ sadā parvvataṁ śmaśānañca bhramitvā cītśabdaṁ kṛtavān grāvabhiśca svayaṁ svaṁ kṛtavān| ");
INSERT INTO sanias_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","sa yīśuṁ dūrāt paśyanneva dhāvan taṁ praṇanāma ucairuvaṁścovāca, ");
INSERT INTO sanias_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","he sarvvoparistheśvaraputra yīśo bhavatā saha me kaḥ sambandhaḥ? ahaṁ tvāmīśvareṇa śāpaye māṁ mā yātaya| ");
INSERT INTO sanias_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","yato yīśustaṁ kathitavān re apavitrabhūta, asmānnarād bahirnirgaccha| ");
INSERT INTO sanias_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","atha sa taṁ pṛṣṭavān kinte nāma? tena pratyuktaṁ vayamaneke 'smastato'smannāma bāhinī| ");
INSERT INTO sanias_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","tatosmān deśānna preṣayeti te taṁ prārthayanta| ");
INSERT INTO sanias_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","tadānīṁ parvvataṁ nikaṣā bṛhan varāhavrajaścarannāsīt| ");
INSERT INTO sanias_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","tasmād bhūtā vinayena jagaduḥ, amuṁ varāhavrajam āśrayitum asmān prahiṇu| ");
INSERT INTO sanias_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","yīśunānujñātāste'pavitrabhūtā bahirniryāya varāhavrajaṁ prāviśan tataḥ sarvve varāhā vastutastu prāyodvisahasrasaṁṅkhyakāḥ kaṭakena mahājavād dhāvantaḥ sindhau prāṇān jahuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","tasmād varāhapālakāḥ palāyamānāḥ pure grāme ca tadvārttaṁ kathayāñcakruḥ| tadā lokā ghaṭitaṁ tatkāryyaṁ draṣṭuṁ bahirjagmuḥ ");
INSERT INTO sanias_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","yīśoḥ sannidhiṁ gatvā taṁ bhūtagrastam arthād bāhinībhūtagrastaṁ naraṁ savastraṁ sacetanaṁ samupaviṣṭañca dṛृṣṭvā bibhyuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","tato dṛṣṭatatkāryyalokāstasya bhūtagrastanarasya varāhavrajasyāpi tāṁ dhaṭanāṁ varṇayāmāsuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","tataste svasīmāto bahirgantuṁ yīśuṁ vinetumārebhire| ");
INSERT INTO sanias_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","atha tasya naukārohaṇakāle sa bhūtamukto nā yīśunā saha sthātuṁ prārthayate; ");
INSERT INTO sanias_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","kintu sa tamananumatya kathitavān tvaṁ nijātmīyānāṁ samīpaṁ gṛhañca gaccha prabhustvayi kṛpāṁ kṛtvā yāni karmmāṇi kṛtavān tāni tān jñāpaya| ");
INSERT INTO sanias_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ataḥ sa prasthāya yīśunā kṛtaṁ tatsarvvāścaryyaṁ karmma dikāpalideśe pracārayituṁ prārabdhavān tataḥ sarvve lokā āścaryyaṁ menire| ");
INSERT INTO sanias_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","anantaraṁ yīśau nāvā punaranyapāra uttīrṇe sindhutaṭe ca tiṣṭhati sati tatsamīpe bahulokānāṁ samāgamo'bhūt| ");
INSERT INTO sanias_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","aparaṁ yāyīr nāmnā kaścid bhajanagṛhasyādhipa āgatya taṁ dṛṣṭvaiva caraṇayoḥ patitvā bahu nivedya kathitavān; ");
INSERT INTO sanias_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","mama kanyā mṛtaprāyābhūd ato bhavānetya tadārogyāya tasyā gātre hastam arpayatu tenaiva sā jīviṣyati| ");
INSERT INTO sanias_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","tadā yīśustena saha calitaḥ kintu tatpaścād bahulokāścalitvā tādgātre patitāḥ| ");
INSERT INTO sanias_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","atha dvādaśavarṣāṇi pradararogeṇa ");
INSERT INTO sanias_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","śīrṇā cikitsakānāṁ nānācikitsābhiśca duḥkhaṁ bhuktavatī ca sarvvasvaṁ vyayitvāpi nārogyaṁ prāptā ca punarapi pīḍitāsīcca ");
INSERT INTO sanias_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","yā strī sā yīśo rvārttāṁ prāpya manasākathayat yadyahaṁ tasya vastramātra spraṣṭuṁ labheyaṁ tadā rogahīnā bhaviṣyāmi| ");
INSERT INTO sanias_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","atohetoḥ sā lokāraṇyamadhye tatpaścādāgatya tasya vastraṁ pasparśa| ");
INSERT INTO sanias_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","tenaiva tatkṣaṇaṁ tasyā raktasrotaḥ śuṣkaṁ svayaṁ tasmād rogānmuktā ityapi dehe'nubhūtā| ");
INSERT INTO sanias_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","atha svasmāt śakti rnirgatā yīśuretanmanasā jñātvā lokanivahaṁ prati mukhaṁ vyāvṛtya pṛṣṭavān kena madvastraṁ spṛṣṭaṁ? ");
INSERT INTO sanias_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","tatastasya śiṣyā ūcuḥ bhavato vapuṣi lokāḥ saṁgharṣanti tad dṛṣṭvā kena madvastraṁ spṛṣṭamiti kutaḥ kathayati? ");
INSERT INTO sanias_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","kintu kena tat karmma kṛtaṁ tad draṣṭuṁ yīśuścaturdiśo dṛṣṭavān| ");
INSERT INTO sanias_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","tataḥ sā strī bhītā kampitā ca satī svasyā rukpratikriyā jāteti jñātvāgatya tatsammukhe patitvā sarvvavṛttāntaṁ satyaṁ tasmai kathayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","tadānīṁ yīśustāṁ gaditavān, he kanye tava pratītistvām arogāmakarot tvaṁ kṣemeṇa vraja svarogānmuktā ca tiṣṭha| ");
INSERT INTO sanias_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","itivākyavadanakāle bhajanagṛhādhipasya niveśanāl lokā etyādhipaṁ babhāṣire tava kanyā mṛtā tasmād guruṁ punaḥ kutaḥ kliśnāsi? ");
INSERT INTO sanias_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","kintu yīśustad vākyaṁ śrutvaiva bhajanagṛhādhipaṁ gaditavān mā bhaiṣīḥ kevalaṁ viśvāsihi| ");
INSERT INTO sanias_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","atha pitaro yākūb tadbhrātā yohan ca etān vinā kamapi svapaścād yātuṁ nānvamanyata| ");
INSERT INTO sanias_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","tasya bhajanagṛhādhipasya niveśanasamīpam āgatya kalahaṁ bahurodanaṁ vilāpañca kurvvato lokān dadarśa| ");
INSERT INTO sanias_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","tasmān niveśanaṁ praviśya proktavān yūyaṁ kuta itthaṁ kalahaṁ rodanañca kurutha? kanyā na mṛtā nidrāti| ");
INSERT INTO sanias_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","tasmātte tamupajahasuḥ kintu yīśuḥ sarvvāna bahiṣkṛtya kanyāyāḥ pitarau svasaṅginaśca gṛhītvā yatra kanyāsīt tat sthānaṁ praviṣṭavān| ");
INSERT INTO sanias_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","atha sa tasyāḥ kanyāyā hastau dhṛtvā tāṁ babhāṣe ṭālīthā kūmī, arthato he kanye tvamuttiṣṭha ityājñāpayāmi| ");
INSERT INTO sanias_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","tunaiva tatkṣaṇaṁ sā dvādaśavarṣavayaskā kanyā potthāya calitumārebhe, itaḥ sarvve mahāvismayaṁ gatāḥ| ");
INSERT INTO sanias_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","tata etasyai kiñcit khādyaṁ datteti kathayitvā etatkarmma kamapi na jñāpayateti dṛḍhamādiṣṭavān| ");
INSERT INTO sanias_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","anantaraṁ sa tatsthānāt prasthāya svapradeśamāgataḥ śiṣyāśca tatpaścād gatāḥ| ");
INSERT INTO sanias_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","atha viśrāmavāre sati sa bhajanagṛhe upadeṣṭumārabdhavān tato'neke lokāstatkathāṁ śrutvā vismitya jagaduḥ, asya manujasya īdṛśī āścaryyakriyā kasmāj jātā? tathā svakarābhyām itthamadbhutaṁ karmma karttāुm etasmai kathaṁ jñānaṁ dattam? ");
INSERT INTO sanias_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","kimayaṁ mariyamaḥ putrastajñā no? kimayaṁ yākūb-yosi-yihudā-śimonāṁ bhrātā no? asya bhaginyaḥ kimihāsmābhiḥ saha no? itthaṁ te tadarthe pratyūhaṁ gatāḥ| ");
INSERT INTO sanias_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","tadā yīśustebhyo'kathayat svadeśaṁ svakuṭumbān svaparijanāṁśca vinā kutrāpi bhaviṣyadvādī asatkṛto na bhavati| ");
INSERT INTO sanias_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","aparañca teṣāmapratyayāt sa vismitaḥ kiyatāṁ rogiṇāṁ vapuḥṣu hastam arpayitvā kevalaṁ teṣāmārogyakaraṇād anyat kimapi citrakāryyaṁ karttāṁ na śaktaḥ| ");
INSERT INTO sanias_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","atha sa caturdikstha grāmān bhramitvā upadiṣṭavān ");
INSERT INTO sanias_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","dvādaśaśiṣyān āhūya amedhyabhūtān vaśīkarttāṁ śaktiṁ dattvā teṣāṁ dvau dvau jano preṣitavān| ");
INSERT INTO sanias_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","punarityādiśad yūyam ekaikāṁ yaṣṭiṁ vinā vastrasaṁpuṭaḥ pūpaḥ kaṭibandhe tāmrakhaṇḍañca eṣāṁ kimapi mā grahlīta, ");
INSERT INTO sanias_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","mārgayātrāyai pādeṣūpānahau dattvā dve uttarīye mā paridhadvvaṁ| ");
INSERT INTO sanias_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","aparamapyuktaṁ tena yūyaṁ yasyāṁ puryyāṁ yasya niveśanaṁ pravekṣyatha tāṁ purīṁ yāvanna tyakṣyatha tāvat tanniveśane sthāsyatha| ");
INSERT INTO sanias_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","tatra yadi kepi yuṣmākamātithyaṁ na vidadhati yuṣmākaṁ kathāśca na śṛṇvanti tarhi tatsthānāt prasthānasamaye teṣāṁ viruddhaṁ sākṣyaṁ dātuṁ svapādānāsphālya rajaḥ sampātayata; ahaṁ yuṣmān yathārthaṁ vacmi vicāradine tannagarasyāvasthātaḥ sidomāmorayo rnagarayoravasthā sahyatarā bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","atha te gatvā lokānāṁ manaḥparāvarttanīḥ kathā pracāritavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","evamanekān bhūtāṁśca tyājitavantastathā tailena marddayitvā bahūn janānarogānakārṣuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","itthaṁ tasya sukhyātiścaturdiśo vyāptā tadā herod rājā tanniśamya kathitavān, yohan majjakaḥ śmaśānād utthita atohetostena sarvvā etā adbhutakriyāḥ prakāśante| ");
INSERT INTO sanias_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","anye'kathayan ayam eliyaḥ, kepi kathitavanta eṣa bhaviṣyadvādī yadvā bhaviṣyadvādināṁ sadṛśa ekoyam| ");
INSERT INTO sanias_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","kintu herod ityākarṇya bhāṣitavān yasyāhaṁ śiraśchinnavān sa eva yohanayaṁ sa śmaśānādudatiṣṭhat| ");
INSERT INTO sanias_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","pūrvvaṁ svabhrātuḥ philipasya patnyā udvāhaṁ kṛtavantaṁ herodaṁ yohanavādīt svabhātṛvadhū rna vivāhyā| ");
INSERT INTO sanias_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ataḥ kāraṇāt herod lokaṁ prahitya yohanaṁ dhṛtvā bandhanālaye baddhavān| ");
INSERT INTO sanias_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","herodiyā tasmai yohane prakupya taṁ hantum aicchat kintu na śaktā, ");
INSERT INTO sanias_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","yasmād herod taṁ dhārmmikaṁ satpuruṣañca jñātvā sammanya rakṣitavān; tatkathāṁ śrutvā tadanusāreṇa bahūni karmmāṇi kṛtavān hṛṣṭamanāstadupadeśaṁ śrutavāṁśca| ");
INSERT INTO sanias_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","kintu herod yadā svajanmadine pradhānalokebhyaḥ senānībhyaśca gālīlpradeśīyaśreṣṭhalokebhyaśca rātrau bhojyamekaṁ kṛtavān ");
INSERT INTO sanias_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","tasmin śubhadine herodiyāyāḥ kanyā sametya teṣāṁ samakṣaṁ saṁnṛtya herodastena sahopaviṣṭānāñca toṣamajījanat tatā nṛpaḥ kanyāmāha sma matto yad yācase tadeva tubhyaṁ dāsye| ");
INSERT INTO sanias_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","śapathaṁ kṛtvākathayat ced rājyārddhamapi yācase tadapi tubhyaṁ dāsye| ");
INSERT INTO sanias_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","tataḥ sā bahi rgatvā svamātaraṁ papraccha kimahaṁ yāciṣye? tadā sākathayat yohano majjakasya śiraḥ| ");
INSERT INTO sanias_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","atha tūrṇaṁ bhūpasamīpam etya yācamānāvadat kṣaṇesmin yohano majjakasya śiraḥ pātre nidhāya dehi, etad yāce'haṁ| ");
INSERT INTO sanias_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","tasmāt bhūpo'tiduḥkhitaḥ, tathāpi svaśapathasya sahabhojināñcānurodhāt tadanaṅgīkarttuṁ na śaktaḥ| ");
INSERT INTO sanias_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","tatkṣaṇaṁ rājā ghātakaṁ preṣya tasya śira ānetumādiṣṭavān| ");
INSERT INTO sanias_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","tataḥ sa kārāgāraṁ gatvā tacchiraśchitvā pātre nidhāyānīya tasyai kanyāyai dattavān kanyā ca svamātre dadau| ");
INSERT INTO sanias_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ananataraṁ yohanaḥ śiṣyāstadvārttāṁ prāpyāgatya tasya kuṇapaṁ śmaśāne'sthāpayan| ");
INSERT INTO sanias_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","atha preṣitā yīśoḥ sannidhau militā yad yac cakruḥ śikṣayāmāsuśca tatsarvvavārttāstasmai kathitavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","sa tānuvāca yūyaṁ vijanasthānaṁ gatvā viśrāmyata yatastatsannidhau bahulokānāṁ samāgamāt te bhoktuṁ nāvakāśaṁ prāptāḥ| ");
INSERT INTO sanias_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","tataste nāvā vijanasthānaṁ guptaṁ gagmuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","tato lokanivahasteṣāṁ sthānāntarayānaṁ dadarśa, aneke taṁ paricitya nānāpurebhyaḥ padairvrajitvā javena taiṣāmagre yīśoḥ samīpa upatasthuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","tadā yīśu rnāvo bahirgatya lokāraṇyānīṁ dṛṣṭvā teṣu karuṇāṁ kṛtavān yataste'rakṣakameṣā ivāsan tadā sa tāna nānāprasaṅgān upadiṣṭavān| ");
INSERT INTO sanias_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","atha divānte sati śiṣyā etya yīśumūcire, idaṁ vijanasthānaṁ dinañcāvasannaṁ| ");
INSERT INTO sanias_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","lokānāṁ kimapi khādyaṁ nāsti, ataścaturdikṣu grāmān gantuṁ bhojyadravyāṇi kretuñca bhavān tān visṛjatu| ");
INSERT INTO sanias_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","tadā sa tānuvāca yūyameva tān bhojayata; tataste jagadu rvayaṁ gatvā dviśatasaṁkhyakai rmudrāpādaiḥ pūpān krītvā kiṁ tān bhojayiṣyāmaḥ? ");
INSERT INTO sanias_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","tadā sa tān pṛṣṭhavān yuṣmākaṁ sannidhau kati pūpā āsate? gatvā paśyata; tataste dṛṣṭvā tamavadan pañca pūpā dvau matsyau ca santi| ");
INSERT INTO sanias_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","tadā sa lokān śaspopari paṁktibhirupaveśayitum ādiṣṭavān, ");
INSERT INTO sanias_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","tataste śataṁ śataṁ janāḥ pañcāśat pañcāśajjanāśca paṁktibhi rbhuvi samupaviviśuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","atha sa tān pañcapūpān matsyadvayañca dhṛtvā svargaṁ paśyan īśvaraguṇān anvakīrttayat tān pūpān bhaṁktvā lokebhyaḥ pariveṣayituṁ śiṣyebhyo dattavān dvā matsyau ca vibhajya sarvvebhyo dattavān| ");
INSERT INTO sanias_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","tataḥ sarvve bhuktvātṛpyan| ");
INSERT INTO sanias_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","anantaraṁ śiṣyā avaśiṣṭaiḥ pūpai rmatsyaiśca pūrṇān dvadaśa ḍallakān jagṛhuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","te bhoktāraḥ prāyaḥ pañca sahasrāṇi puruṣā āsan| ");
INSERT INTO sanias_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","atha sa lokān visṛjanneva nāvamāroḍhuṁ svasmādagre pāre baitsaidāpuraṁ yātuñca śṣyiाn vāḍhamādiṣṭavān| ");
INSERT INTO sanias_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","tadā sa sarvvān visṛjya prārthayituṁ parvvataṁ gataḥ| ");
INSERT INTO sanias_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","tataḥ sandhyāyāṁ satyāṁ nauḥ sindhumadhya upasthitā kintu sa ekākī sthale sthitaḥ| ");
INSERT INTO sanias_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","atha sammukhavātavahanāt śiṣyā nāvaṁ vāhayitvā pariśrāntā iti jñātvā sa niśācaturthayāme sindhūpari padbhyāṁ vrajan teṣāṁ samīpametya teṣāmagre yātum udyataḥ| ");
INSERT INTO sanias_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","kintu śiṣyāḥ sindhūpari taṁ vrajantaṁ dṛṣṭvā bhūtamanumāya ruruvuḥ, ");
INSERT INTO sanias_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","yataḥ sarvve taṁ dṛṣṭvā vyākulitāḥ| ataeva yīśustatkṣaṇaṁ taiḥ sahālapya kathitavān, susthirā bhūta, ayamahaṁ mā bhaiṣṭa| ");
INSERT INTO sanias_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","atha naukāmāruhya tasmin teṣāṁ sannidhiṁ gate vāto nivṛttaḥ; tasmātte manaḥsu vismitā āścaryyaṁ menire| ");
INSERT INTO sanias_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","yataste manasāṁ kāṭhinyāt tat pūpīyam āścaryyaṁ karmma na viviktavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","atha te pāraṁ gatvā gineṣaratpradeśametya taṭa upasthitāḥ| ");
INSERT INTO sanias_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","teṣu naukāto bahirgateṣu tatpradeśīyā lokāstaṁ paricitya ");
INSERT INTO sanias_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","caturdikṣu dhāvanto yatra yatra rogiṇo narā āsan tān sarvvāna khaṭvopari nidhāya yatra kutracit tadvārttāṁ prāpuḥ tat sthānam ānetum ārebhire| ");
INSERT INTO sanias_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","tathā yatra yatra grāme yatra yatra pure yatra yatra pallyāñca tena praveśaḥ kṛtastadvartmamadhye lokāḥ pīḍitān sthāpayitvā tasya celagranthimātraṁ spraṣṭum teṣāmarthe tadanujñāṁ prārthayantaḥ yāvanto lokāḥ paspṛśustāvanta eva gadānmuktāḥ| ");
INSERT INTO sanias_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","anantaraṁ yirūśālama āgatāḥ phirūśino'dhyāpakāśca yīśoḥ samīpam āgatāḥ| ");
INSERT INTO sanias_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","te tasya kiyataḥ śiṣyān aśucikarairarthāda aprakṣālitahastai rbhuñjato dṛṣṭvā tānadūṣayan| ");
INSERT INTO sanias_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","yataḥ phirūśinaḥ sarvvayihūdīyāśca prācāṁ paramparāgatavākyaṁ sammanya pratalena hastān aprakṣālya na bhuñjate| ");
INSERT INTO sanias_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","āpanādāgatya majjanaṁ vinā na khādanti; tathā pānapātrāṇāṁ jalapātrāṇāṁ pittalapātrāṇām āsanānāñca jale majjanam ityādayonyepi bahavasteṣāmācārāḥ santi| ");
INSERT INTO sanias_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","te phirūśino'dhyāpakāśca yīśuṁ papracchuḥ, tava śiṣyāḥ prācāṁ paramparāgatavākyānusāreṇa nācaranto'prakṣālitakaraiḥ kuto bhujaṁte? ");
INSERT INTO sanias_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","tataḥ sa pratyuvāca kapaṭino yuṣmān uddiśya yiśayiyabhaviṣyadvādī yuktamavādīt| yathā svakīyairadharairete sammanyanate sadaiva māṁ| kintu matto viprakarṣe santi teṣāṁ manāṁsi ca| ");
INSERT INTO sanias_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","śikṣayanto bidhīn nnājñā bhajante māṁ mudhaiva te| ");
INSERT INTO sanias_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","yūyaṁ jalapātrapānapātrādīni majjayanto manujaparamparāgatavākyaṁ rakṣatha kintu īśvarājñāṁ laṁghadhve; aparā īdṛśyonekāḥ kriyā api kurudhve| ");
INSERT INTO sanias_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","anyañcākathayat yūyaṁ svaparamparāgatavākyasya rakṣārthaṁ spaṣṭarūpeṇa īśvarājñāṁ lopayatha| ");
INSERT INTO sanias_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","yato mūsādvārā proktamasti svapitarau sammanyadhvaṁ yastu mātaraṁ pitaraṁ vā durvvākyaṁ vakti sa nitāntaṁ hanyatāṁ| ");
INSERT INTO sanias_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","kintu madīyena yena dravyeṇa tavopakārobhavat tat karbbāṇamarthād īśvarāya niveditam idaṁ vākyaṁ yadi kopi pitaraṁ mātaraṁ vā vakti ");
INSERT INTO sanias_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","tarhi yūyaṁ mātuḥ pitu rvopakāraṁ karttāṁ taṁ vārayatha| ");
INSERT INTO sanias_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","itthaṁ svapracāritaparamparāgatavākyena yūyam īśvarājñāṁ mudhā vidhadvve, īdṛśānyanyānyanekāni karmmāṇi kurudhve| ");
INSERT INTO sanias_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","atha sa lokānāhūya babhāṣe yūyaṁ sarvve madvākyaṁ śṛṇuta budhyadhvañca| ");
INSERT INTO sanias_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","bāhyādantaraṁ praviśya naramamedhyaṁ karttāṁ śaknoti īdṛśaṁ kimapi vastu nāsti, varam antarād bahirgataṁ yadvastu tanmanujam amedhyaṁ karoti| ");
INSERT INTO sanias_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","yasya śrotuṁ śrotre staḥ sa śṛṇotu| ");
INSERT INTO sanias_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","tataḥ sa lokān hitvā gṛhamadhyaṁ praviṣṭastadā śiṣyāstadṛṣṭāntavākyārthaṁ papracchuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","tasmāt sa tān jagāda yūyamapi kimetādṛgabodhāḥ? kimapi dravyaṁ bāhyādantaraṁ praviśya naramamedhyaṁ karttāṁ na śaknoti kathāmimāṁ kiṁ na budhyadhve? ");
INSERT INTO sanias_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","tat tadantarna praviśati kintu kukṣimadhyaṁ praviśati śeṣe sarvvabhuktavastugrāhiṇi bahirdeśe niryāti| ");
INSERT INTO sanias_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","aparamapyavādīd yannarānnireti tadeva naramamedhyaṁ karoti| ");
INSERT INTO sanias_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","yato'ntarād arthān mānavānāṁ manobhyaḥ kucintā parastrīveśyāgamanaṁ ");
INSERT INTO sanias_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","naravadhaścauryyaṁ lobho duṣṭatā pravañcanā kāmukatā kudṛṣṭirīśvaranindā garvvastama ityādīni nirgacchanti| ");
INSERT INTO sanias_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","etāni sarvvāṇi duritānyantarādetya naramamedhyaṁ kurvvanti| ");
INSERT INTO sanias_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","atha sa utthāya tatsthānāt sorasīdonpurapradeśaṁ jagāma tatra kimapi niveśanaṁ praviśya sarvvairajñātaḥ sthātuṁ matiñcakre kintu guptaḥ sthātuṁ na śaśāka| ");
INSERT INTO sanias_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","yataḥ suraphainikīdeśīyayūnānīvaṁśodbhavastriyāḥ kanyā bhūtagrastāsīt| sā strī tadvārttāṁ prāpya tatsamīpamāgatya taccaraṇayoḥ patitvā ");
INSERT INTO sanias_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","svakanyāto bhūtaṁ nirākarttāṁ tasmin vinayaṁ kṛtavatī| ");
INSERT INTO sanias_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","kintu yīśustāmavadat prathamaṁ bālakāstṛpyantu yato bālakānāṁ khādyaṁ gṛhītvā kukkurebhyo nikṣepo'nucitaḥ| ");
INSERT INTO sanias_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","tadā sā strī tamavādīt bhoḥ prabho tat satyaṁ tathāpi mañcādhaḥsthāḥ kukkurā bālānāṁ karapatitāni khādyakhaṇḍāni khādanti| ");
INSERT INTO sanias_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","tataḥ so'kathayad etatkathāhetoḥ sakuśalā yāhi tava kanyāṁ tyaktvā bhūto gataḥ| ");
INSERT INTO sanias_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","atha sā strī gṛhaṁ gatvā kanyāṁ bhūtatyaktāṁ śayyāsthitāṁ dadarśa| ");
INSERT INTO sanias_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","punaśca sa sorasīdonpurapradeśāt prasthāya dikāpalideśasya prāntarabhāgena gālīljaladheḥ samīpaṁ gatavān| ");
INSERT INTO sanias_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","tadā lokairekaṁ badhiraṁ kadvadañca naraṁ tannikaṭamānīya tasya gātre hastamarpayituṁ vinayaḥ kṛtaḥ| ");
INSERT INTO sanias_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","tato yīśu rlokāraṇyāt taṁ nirjanamānīya tasya karṇayoṅgulī rdadau niṣṭhīvaṁ dattvā ca tajjihvāṁ pasparśa| ");
INSERT INTO sanias_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","anantaraṁ svargaṁ nirīkṣya dīrghaṁ niśvasya tamavadat itaphataḥ arthān mukto bhūyāt| ");
INSERT INTO sanias_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","tatastatkṣaṇaṁ tasya karṇau muktau jihvāyāśca jāḍyāpagamāt sa suspaṣṭavākyamakathayat| ");
INSERT INTO sanias_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","atha sa tān vāḍhamityādideśa yūyamimāṁ kathāṁ kasmaicidapi mā kathayata, kintu sa yati nyaṣedhat te tati bāhulyena prācārayan; ");
INSERT INTO sanias_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","te'ticamatkṛtya parasparaṁ kathayāmāsuḥ sa badhirāya śravaṇaśaktiṁ mūkāya ca kathanaśaktiṁ dattvā sarvvaṁ karmmottamarūpeṇa cakāra| ");
INSERT INTO sanias_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","tadā tatsamīpaṁ bahavo lokā āyātā atasteṣāṁ bhojyadravyābhāvād yīśuḥ śiṣyānāhūya jagāda,| ");
INSERT INTO sanias_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","lokanivahe mama kṛpā jāyate te dinatrayaṁ mayā sārddhaṁ santi teṣāṁ bhojyaṁ kimapi nāsti| ");
INSERT INTO sanias_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","teṣāṁ madhye'neke dūrād āgatāḥ, abhukteṣu teṣu mayā svagṛhamabhiprahiteṣu te pathi klamiṣyanti| ");
INSERT INTO sanias_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","śiṣyā avādiṣuḥ, etāvato lokān tarpayitum atra prantare pūpān prāptuṁ kena śakyate? ");
INSERT INTO sanias_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","tataḥ sa tān papraccha yuṣmākaṁ kati pūpāḥ santi? te'kathayan sapta| ");
INSERT INTO sanias_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","tataḥ sa tāllokān bhuvi samupaveṣṭum ādiśya tān sapta pūpān dhṛtvā īśvaraguṇān anukīrttayāmāsa, bhaṁktvā pariveṣayituṁ śiṣyān prati dadau, tataste lokebhyaḥ pariveṣayāmāsuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","tathā teṣāṁ samīpe ye kṣudramatsyā āsan tānapyādāya īśvaraguṇān saṁkīrtya pariveṣayitum ādiṣṭavān| ");
INSERT INTO sanias_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","tato lokā bhuktvā tṛptiṁ gatā avaśiṣṭakhādyaiḥ pūrṇāḥ saptaḍallakā gṛhītāśca| ");
INSERT INTO sanias_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ete bhoktāraḥ prāyaścatuḥ sahasrapuruṣā āsan tataḥ sa tān visasarja| ");
INSERT INTO sanias_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","atha sa śiṣyaḥ saha nāvamāruhya dalmānūthāsīmāmāgataḥ| ");
INSERT INTO sanias_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","tataḥ paraṁ phirūśina āgatya tena saha vivadamānāstasya parīkṣārtham ākāśīyacihnaṁ draṣṭuṁ yācitavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","tadā so'ntardīrghaṁ niśvasyākathayat, ete vidyamānanarāḥ kutaścinhaṁ mṛgayante? yuṣmānahaṁ yathārthaṁ bravīmi lokānetān kimapi cihnaṁ na darśayiṣyate| ");
INSERT INTO sanias_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","atha tān hitvā puna rnāvam āruhya pāramagāt| ");
INSERT INTO sanias_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","etarhi śiṣyaiḥ pūpeṣu vismṛteṣu nāvi teṣāṁ sannidhau pūpa ekaeva sthitaḥ| ");
INSERT INTO sanias_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","tadānīṁ yīśustān ādiṣṭavān phirūśināṁ herodaśca kiṇvaṁ prati satarkāḥ sāvadhānāśca bhavata| ");
INSERT INTO sanias_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","tataste'nyonyaṁ vivecanaṁ kartum ārebhire, asmākaṁ sannidhau pūpo nāstīti hetoridaṁ kathayati| ");
INSERT INTO sanias_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","tad budvvā yīśustebhyo'kathayat yuṣmākaṁ sthāne pūpābhāvāt kuta itthaṁ vitarkayatha? yūyaṁ kimadyāpi kimapi na jānītha? boddhuñca na śaknutha? yāvadadya kiṁ yuṣmākaṁ manāṁsi kaṭhināni santi? ");
INSERT INTO sanias_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","satsu netreṣu kiṁ na paśyatha? satsu karṇeṣu kiṁ na śṛṇutha? na smaratha ca? ");
INSERT INTO sanias_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","yadāhaṁ pañcapūpān pañcasahasrāṇāṁ puruṣāṇāṁ madhye bhaṁktvā dattavān tadānīṁ yūyam avaśiṣṭapūpaiḥ pūrṇān kati ḍallakān gṛhītavantaḥ? te'kathayan dvādaśaḍallakān| ");
INSERT INTO sanias_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","aparañca yadā catuḥsahasrāṇāṁ puruṣāṇāṁ madhye pūpān bhaṁktvādadāṁ tadā yūyam atiriktapūpānāṁ kati ḍallakān gṛhītavantaḥ? te kathayāmāsuḥ saptaḍallakān| ");
INSERT INTO sanias_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","tadā sa kathitavān tarhi yūyam adhunāpi kuto bodvvuṁ na śaknutha? ");
INSERT INTO sanias_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","anantaraṁ tasmin baitsaidānagare prāpte lokā andhamekaṁ naraṁ tatsamīpamānīya taṁ spraṣṭuṁ taṁ prārthayāñcakrire| ");
INSERT INTO sanias_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","tadā tasyāndhasya karau gṛhītvā nagarād bahirdeśaṁ taṁ nītavān; tannetre niṣṭhīvaṁ dattvā tadgātre hastāvarpayitvā taṁ papraccha, kimapi paśyasi? ");
INSERT INTO sanias_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","sa netre unmīlya jagāda, vṛkṣavat manujān gacchato nirīkṣe| ");
INSERT INTO sanias_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","tato yīśuḥ punastasya nayanayo rhastāvarpayitvā tasya netre unmīlayāmāsa; tasmāt sa svastho bhūtvā spaṣṭarūpaṁ sarvvalokān dadarśa| ");
INSERT INTO sanias_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","tataḥ paraṁ tvaṁ grāmaṁ mā gaccha grāmasthaṁ kamapi ca kimapyanuktvā nijagṛhaṁ yāhītyādiśya yīśustaṁ nijagṛhaṁ prahitavān| ");
INSERT INTO sanias_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","anantaraṁ śiṣyaiḥ sahito yīśuḥ kaisarīyāphilipipuraṁ jagāma, pathi gacchan tānapṛcchat ko'ham atra lokāḥ kiṁ vadanti? ");
INSERT INTO sanias_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","te pratyūcuḥ tvāṁ yohanaṁ majjakaṁ vadanti kintu kepi kepi eliyaṁ vadanti; apare kepi kepi bhaviṣyadvādinām eko jana iti vadanti| ");
INSERT INTO sanias_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","atha sa tānapṛcchat kintu koham? ityatra yūyaṁ kiṁ vadatha? tadā pitaraḥ pratyavadat bhavān abhiṣiktastrātā| ");
INSERT INTO sanias_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","tataḥ sa tān gāḍhamādiśad yūyaṁ mama kathā kasmaicidapi mā kathayata| ");
INSERT INTO sanias_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","manuṣyaputreṇāvaśyaṁ bahavo yātanā bhoktavyāḥ prācīnalokaiḥ pradhānayājakairadhyāpakaiśca sa ninditaḥ san ghātayiṣyate tṛtīyadine utthāsyati ca, yīśuḥ śiṣyānupadeṣṭumārabhya kathāmimāṁ spaṣṭamācaṣṭa| ");
INSERT INTO sanias_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","tasmāt pitarastasya hastau dhṛtvā taṁ tarjjitavān| ");
INSERT INTO sanias_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","kintu sa mukhaṁ parāvartya śiṣyagaṇaṁ nirīkṣya pitaraṁ tarjayitvāvādīd dūrībhava vighnakārin īśvarīyakāryyādapi manuṣyakāryyaṁ tubhyaṁ rocatatarāṁ| ");
INSERT INTO sanias_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","atha sa lokān śiṣyāṁścāhūya jagāda yaḥ kaścin māmanugantum icchati sa ātmānaṁ dāmyatu, svakruśaṁ gṛhītvā matpaścād āyātu| ");
INSERT INTO sanias_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","yato yaḥ kaścit svaprāṇaṁ rakṣitumicchati sa taṁ hārayiṣyati, kintu yaḥ kaścin madarthaṁ susaṁvādārthañca prāṇaṁ hārayati sa taṁ rakṣiṣyati| ");
INSERT INTO sanias_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","aparañca manujaḥ sarvvaṁ jagat prāpya yadi svaprāṇaṁ hārayati tarhi tasya ko lābhaḥ? ");
INSERT INTO sanias_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","naraḥ svaprāṇavinimayena kiṁ dātuṁ śaknoti? ");
INSERT INTO sanias_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","eteṣāṁ vyabhicāriṇāṁ pāpināñca lokānāṁ sākṣād yadi kopi māṁ matkathāñca lajjāspadaṁ jānāti tarhi manujaputro yadā dharmmadūtaiḥ saha pituḥ prabhāveṇāgamiṣyati tadā sopi taṁ lajjāspadaṁ jñāsyati| ");
INSERT INTO sanias_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","atha sa tānavādīt yuṣmabhyamahaṁ yathārthaṁ kathayāmi, īśvararājyaṁ parākrameṇopasthitaṁ na dṛṣṭvā mṛtyuṁ nāsvādiṣyante, atra daṇḍāyamānānāṁ madhyepi tādṛśā lokāḥ santi| ");
INSERT INTO sanias_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","atha ṣaḍdinebhyaḥ paraṁ yīśuḥ pitaraṁ yākūbaṁ yohanañca gṛhītvā gireruccasya nirjanasthānaṁ gatvā teṣāṁ pratyakṣe mūrtyantaraṁ dadhāra| ");
INSERT INTO sanias_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","tatastasya paridheyam īdṛśam ujjvalahimapāṇaḍaraṁ jātaṁ yad jagati kopi rajako na tādṛk pāṇaḍaraṁ karttāṁ śaknoti| ");
INSERT INTO sanias_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","aparañca eliyo mūsāśca tebhyo darśanaṁ dattvā yīśunā saha kathanaṁ karttumārebhāte| ");
INSERT INTO sanias_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","tadā pitaro yīśumavādīt he guro'smākamatra sthitiruttamā, tataeva vayaṁ tvatkṛte ekāṁ mūsākṛte ekām eliyakṛte caikāṁ, etāstisraḥ kuṭī rnirmmāma| ");
INSERT INTO sanias_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","kintu sa yaduktavān tat svayaṁ na bubudhe tataḥ sarvve bibhayāñcakruḥ| ");
INSERT INTO sanias_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","etarhi payodastān chādayāmāsa, mamayāṁ priyaḥ putraḥ kathāsu tasya manāṁsi niveśayateti nabhovāṇī tanmedyānniryayau| ");
INSERT INTO sanias_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","atha haṭhātte caturdiśo dṛṣṭvā yīśuṁ vinā svaiḥ sahitaṁ kamapi na dadṛśuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","tataḥ paraṁ gireravarohaṇakāle sa tān gāḍham dūtyādideśa yāvannarasūnoḥ śmaśānādutthānaṁ na bhavati, tāvat darśanasyāsya vārttā yuṣmābhiḥ kasmaicidapi na vaktavyā| ");
INSERT INTO sanias_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","tadā śmaśānādutthānasya kobhiprāya iti vicāryya te tadvākyaṁ sveṣu gopāyāñcakrire| ");
INSERT INTO sanias_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","atha te yīśuṁ papracchuḥ prathamata eliyenāgantavyam iti vākyaṁ kuta upādhyāyā āhuḥ? ");
INSERT INTO sanias_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","tadā sa pratyuvāca , eliyaḥ prathamametya sarvvakāryyāṇi sādhayiṣyati; naraputre ca lipi ryathāste tathaiva sopi bahuduḥkhaṁ prāpyāvajñāsyate| ");
INSERT INTO sanias_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","kintvahaṁ yuṣmān vadāmi , eliyārthe lipi ryathāste tathaiva sa etya yayau, lokā: svecchānurūpaṁ tamabhivyavaharanti sma| ");
INSERT INTO sanias_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","anantaraṁ sa śiṣyasamīpametya teṣāṁ catuḥpārśve taiḥ saha bahujanān vivadamānān adhyāpakāṁśca dṛṣṭavān; ");
INSERT INTO sanias_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","kintu sarvvalokāstaṁ dṛṣṭvaiva camatkṛtya tadāsannaṁ dhāvantastaṁ praṇemuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","tadā yīśuradhyāpakānaprākṣīd etaiḥ saha yūyaṁ kiṁ vivadadhve? ");
INSERT INTO sanias_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","tato lokānāṁ kaścidekaḥ pratyavādīt he guro mama sūnuṁ mūkaṁ bhūtadhṛtañca bhavadāsannam ānayaṁ| ");
INSERT INTO sanias_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","yadāsau bhūtastamākramate tadaiva pātasati tathā sa pheṇāyate, dantairdantān gharṣati kṣīṇo bhavati ca; tato hetostaṁ bhūtaṁ tyājayituṁ bhavacchiṣyān niveditavān kintu te na śekuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","tadā sa tamavādīt, re aviśvāsinaḥ santānā yuṣmābhiḥ saha kati kālānahaṁ sthāsyāmi? aparān kati kālān vā va ācārān sahiṣye? taṁ madāsannamānayata| ");
INSERT INTO sanias_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","tatastatsannidhiṁ sa ānīyata kintu taṁ dṛṣṭvaiva bhūto bālakaṁ dhṛtavān; sa ca bhūmau patitvā pheṇāyamāno luloṭha| ");
INSERT INTO sanias_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","tadā sa tatpitaraṁ papraccha, asyedṛśī daśā kati dināni bhūtā? tataḥ sovādīt bālyakālāt| ");
INSERT INTO sanias_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","bhūtoyaṁ taṁ nāśayituṁ bahuvārān vahnau jale ca nyakṣipat kintu yadi bhavāna kimapi karttāṁ śaknoti tarhi dayāṁ kṛtvāsmān upakarotu| ");
INSERT INTO sanias_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","tadā yīśustamavadat yadi pratyetuṁ śaknoṣi tarhi pratyayine janāya sarvvaṁ sādhyam| ");
INSERT INTO sanias_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","tatastatkṣaṇaṁ tadbālakasya pitā proccai rūvan sāśrunetraḥ provāca, prabho pratyemi mamāpratyayaṁ pratikuru| ");
INSERT INTO sanias_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","atha yīśu rlokasaṅghaṁ dhāvitvāyāntaṁ dṛṣṭvā tamapūtabhūtaṁ tarjayitvā jagāda, re badhira mūka bhūta tvametasmād bahirbhava punaḥ kadāpi māśrayainaṁ tvāmaham ityādiśāmi| ");
INSERT INTO sanias_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","tadā sa bhūtaścītśabdaṁ kṛtvā tamāpīḍya bahirjajāma, tato bālako mṛtakalpo babhūva tasmādayaṁ mṛta̮ityaneke kathayāmāsuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","kintu karaṁ dhṛtvā yīśunotthāpitaḥ sa uttasthau| ");
INSERT INTO sanias_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","atha yīśau gṛhaṁ praviṣṭe śiṣyā guptaṁ taṁ papracchuḥ, vayamenaṁ bhūtaṁ tyājayituṁ kuto na śaktāḥ? ");
INSERT INTO sanias_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","sa uvāca, prārthanopavāsau vinā kenāpyanyena karmmaṇā bhūtamīdṛśaṁ tyājayituṁ na śakyaṁ| ");
INSERT INTO sanias_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","anantaraṁ sa tatsthānāditvā gālīlmadhyena yayau, kintu tat kopi jānīyāditi sa naicchat| ");
INSERT INTO sanias_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","aparañca sa śiṣyānupadiśan babhāṣe, naraputro narahasteṣu samarpayiṣyate te ca taṁ haniṣyanti taistasmin hate tṛtīyadine sa utthāsyatīti| ");
INSERT INTO sanias_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","kintu tatkathāṁ te nābudhyanta praṣṭuñca bibhyaḥ| ");
INSERT INTO sanias_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","atha yīśuḥ kapharnāhūmpuramāgatya madhyegṛhañcetya tānapṛcchad vartmamadhye yūyamanyonyaṁ kiṁ vivadadhve sma? ");
INSERT INTO sanias_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","kintu te niruttarāstasthu ryasmātteṣāṁ ko mukhya iti vartmāni te'nyonyaṁ vyavadanta| ");
INSERT INTO sanias_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","tataḥ sa upaviśya dvādaśaśiṣyān āhūya babhāṣe yaḥ kaścit mukhyo bhavitumicchati sa sarvvebhyo gauṇaḥ sarvveṣāṁ sevakaśca bhavatu| ");
INSERT INTO sanias_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","tadā sa bālakamekaṁ gṛhītvā madhye samupāveśayat tatastaṁ kroḍe kṛtvā tānavādāt ");
INSERT INTO sanias_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","yaḥ kaścidīdṛśasya kasyāpi bālasyātithyaṁ karoti sa mamātithyaṁ karoti; yaḥ kaścinmamātithyaṁ karoti sa kevalam mamātithyaṁ karoti tanna matprerakasyāpyātithyaṁ karoti| ");
INSERT INTO sanias_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","atha yohan tamabravīt he guro, asmākamananugāminam ekaṁ tvānnāmnā bhūtān tyājayantaṁ vayaṁ dṛṣṭavantaḥ, asmākamapaścādgāmitvācca taṁ nyaṣedhāma| ");
INSERT INTO sanias_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","kintu yīśuravadat taṁ mā niṣedhat, yato yaḥ kaścin mannāmnā citraṁ karmma karoti sa sahasā māṁ nindituṁ na śaknoti| ");
INSERT INTO sanias_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","tathā yaḥ kaścid yuṣmākaṁ vipakṣatāṁ na karoti sa yuṣmākameva sapakṣaḥ| ");
INSERT INTO sanias_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","yaḥ kaścid yuṣmān khrīṣṭaśiṣyān jñātvā mannāmnā kaṁsaikena pānīyaṁ pātuṁ dadāti, yuṣmānahaṁ yathārthaṁ vacmi, sa phalena vañcito na bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","kintu yadi kaścin mayi viśvāsināmeṣāṁ kṣudraprāṇinām ekasyāpi vighnaṁ janayati, tarhi tasyaitatkarmma karaṇāt kaṇṭhabaddhapeṣaṇīkasya tasya sāgarāgādhajala majjanaṁ bhadraṁ| ");
INSERT INTO sanias_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","ataḥ svakaro yadi tvāṁ bādhate tarhi taṁ chindhi; ");
INSERT INTO sanias_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","yasmāt yatra kīṭā na mriyante vahniśca na nirvvāti, tasmin anirvvāṇānalanarake karadvayavastava gamanāt karahīnasya svargapraveśastava kṣemaṁ| ");
INSERT INTO sanias_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","yadi tava pādo vighnaṁ janayati tarhi taṁ chindhi, ");
INSERT INTO sanias_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","yato yatra kīṭā na mriyante vahniśca na nirvvāti, tasmin 'nirvvāṇavahnau narake dvipādavatastava nikṣepāt pādahīnasya svargapraveśastava kṣemaṁ| ");
INSERT INTO sanias_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","svanetraṁ yadi tvāṁ bādhate tarhi tadapyutpāṭaya, yato yatra kīṭā na mriyante vahniśca na nirvvāti, ");
INSERT INTO sanias_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","tasmina 'nirvvāṇavahnau narake dvinetrasya tava nikṣepād ekanetravata īśvararājye praveśastava kṣemaṁ| ");
INSERT INTO sanias_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","yathā sarvvo bali rlavaṇāktaḥ kriyate tathā sarvvo jano vahnirūpeṇa lavaṇāktaḥ kāriṣyate| ");
INSERT INTO sanias_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","lavaṇaṁ bhadraṁ kintu yadi lavaṇe svādutā na tiṣṭhati, tarhi katham āsvādyuktaṁ kariṣyatha? yūyaṁ lavaṇayuktā bhavata parasparaṁ prema kuruta| ");
INSERT INTO sanias_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","anantaraṁ sa tatsthānāt prasthāya yarddananadyāḥ pāre yihūdāpradeśa upasthitavān, tatra tadantike lokānāṁ samāgame jāte sa nijarītyanusāreṇa punastān upadideśa| ");
INSERT INTO sanias_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","tadā phirūśinastatsamīpam etya taṁ parīkṣituṁ papracchaḥ svajāyā manujānāṁ tyajyā na veti? ");
INSERT INTO sanias_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","tataḥ sa pratyavādīt, atra kāryye mūsā yuṣmān prati kimājñāpayat? ");
INSERT INTO sanias_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ta ūcuḥ tyāgapatraṁ lekhituṁ svapatnīṁ tyaktuñca mūsā'numanyate| ");
INSERT INTO sanias_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","tadā yīśuḥ pratyuvāca, yuṣmākaṁ manasāṁ kāṭhinyāddheto rmūsā nideśamimam alikhat| ");
INSERT INTO sanias_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","kintu sṛṣṭerādau īśvaro narān puṁrūpeṇa strīrūpeṇa ca sasarja| ");
INSERT INTO sanias_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","\"tataḥ kāraṇāt pumān pitaraṁ mātarañca tyaktvā svajāyāyām āsakto bhaviṣyati, ");
INSERT INTO sanias_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","tau dvāv ekāṅgau bhaviṣyataḥ|\" tasmāt tatkālamārabhya tau na dvāv ekāṅgau| ");
INSERT INTO sanias_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ataḥ kāraṇād īśvaro yadayojayat kopi narastanna viyejayet| ");
INSERT INTO sanias_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","atha yīśu rgṛhaṁ praviṣṭastadā śiṣyāḥ punastatkathāṁ taṁ papracchuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","tataḥ sovadat kaścid yadi svabhāryyāṁ tyaktavānyām udvahati tarhi sa svabhāryyāyāḥ prātikūlyena vyabhicārī bhavati| ");
INSERT INTO sanias_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","kācinnārī yadi svapatiṁ hitvānyapuṁsā vivāhitā bhavati tarhi sāpi vyabhicāriṇī bhavati| ");
INSERT INTO sanias_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","atha sa yathā śiśūn spṛśet, tadarthaṁ lokaistadantikaṁ śiśava ānīyanta, kintu śiṣyāstānānītavatastarjayāmāsuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","yīśustad dṛṣṭvā krudhyan jagāda, mannikaṭam āgantuṁ śiśūn mā vārayata, yata etādṛśā īśvararājyādhikāriṇaḥ| ");
INSERT INTO sanias_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","yuṣmānahaṁ yathārthaṁ vacmi, yaḥ kaścit śiśuvad bhūtvā rājyamīśvarasya na gṛhlīyāt sa kadāpi tadrājyaṁ praveṣṭuṁ na śaknoti| ");
INSERT INTO sanias_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ananataraṁ sa śiśūnaṅke nidhāya teṣāṁ gātreṣu hastau dattvāśiṣaṁ babhāṣe| ");
INSERT INTO sanias_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","atha sa vartmanā yāti, etarhi jana eko dhāvan āgatya tatsammukhe jānunī pātayitvā pṛṣṭavān, bhoḥ paramaguro, anantāyuḥ prāptaye mayā kiṁ karttavyaṁ? ");
INSERT INTO sanias_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","tadā yīśuruvāca, māṁ paramaṁ kuto vadasi? vineśvaraṁ kopi paramo na bhavati| ");
INSERT INTO sanias_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","parastrīṁ nābhigaccha; naraṁ mā ghātaya; steyaṁ mā kuru; mṛṣāsākṣyaṁ mā dehi; hiṁsāñca mā kuru; pitarau sammanyasva; nideśā ete tvayā jñātāḥ| ");
INSERT INTO sanias_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","tatastana pratyuktaṁ, he guro bālyakālādahaṁ sarvvānetān ācarāmi| ");
INSERT INTO sanias_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","tadā yīśustaṁ vilokya snehena babhāṣe, tavaikasyābhāva āste; tvaṁ gatvā sarvvasvaṁ vikrīya daridrebhyo viśrāṇaya, tataḥ svarge dhanaṁ prāpsyasi; tataḥ param etya kruśaṁ vahan madanuvarttī bhava| ");
INSERT INTO sanias_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","kintu tasya bahusampadvidyamānatvāt sa imāṁ kathāmākarṇya viṣaṇo duḥkhitaśca san jagāma| ");
INSERT INTO sanias_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","atha yīśuścaturdiśo nirīkṣya śiṣyān avādīt, dhanilokānām īśvararājyapraveśaḥ kīdṛg duṣkaraḥ| ");
INSERT INTO sanias_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","tasya kathātaḥ śiṣyāścamaccakruḥ, kintu sa punaravadat, he bālakā ye dhane viśvasanti teṣām īśvararājyapraveśaḥ kīdṛg duṣkaraḥ| ");
INSERT INTO sanias_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","īśvararājye dhanināṁ praveśāt sūcirandhreṇa mahāṅgasya gamanāgamanaṁ sukaraṁ| ");
INSERT INTO sanias_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","tadā śiṣyā atīva vismitāḥ parasparaṁ procuḥ, tarhi kaḥ paritrāṇaṁ prāptuṁ śaknoti? ");
INSERT INTO sanias_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","tato yīśustān vilokya babhāṣe, tan narasyāsādhyaṁ kintu neśvarasya, yato hetorīśvarasya sarvvaṁ sādhyam| ");
INSERT INTO sanias_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","tadā pitara uvāca, paśya vayaṁ sarvvaṁ parityajya bhavatonugāmino jātāḥ| ");
INSERT INTO sanias_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","tato yīśuḥ pratyavadat, yuṣmānahaṁ yathārthaṁ vadāmi, madarthaṁ susaṁvādārthaṁ vā yo janaḥ sadanaṁ bhrātaraṁ bhaginīṁ pitaraṁ mātaraṁ jāyāṁ santānān bhūmi vā tyaktvā ");
INSERT INTO sanias_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","gṛhabhrātṛbhaginīpitṛmātṛpatnīsantānabhūmīnāmiha śataguṇān pretyānantāyuśca na prāpnoti tādṛśaḥ kopi nāsti| ");
INSERT INTO sanias_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","kintvagrīyā aneke lokāḥ śeṣāḥ, śeṣīyā aneke lokāścāgrā bhaviṣyanti| ");
INSERT INTO sanias_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","atha yirūśālamyānakāle yīśusteṣām agragāmī babhūva, tasmātte citraṁ jñātvā paścādgāmino bhūtvā bibhyuḥ| tadā sa puna rdvādaśaśiṣyān gṛhītvā svīyaṁ yadyad ghaṭiṣyate tattat tebhyaḥ kathayituṁ prārebhe; ");
INSERT INTO sanias_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","paśyata vayaṁ yirūśālampuraṁ yāmaḥ, tatra manuṣyaputraḥ pradhānayājakānām upādhyāyānāñca kareṣu samarpayiṣyate; te ca vadhadaṇḍājñāṁ dāpayitvā paradeśīyānāṁ kareṣu taṁ samarpayiṣyanti| ");
INSERT INTO sanias_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","te tamupahasya kaśayā prahṛtya tadvapuṣi niṣṭhīvaṁ nikṣipya taṁ haniṣyanti, tataḥ sa tṛtīyadine protthāsyati| ");
INSERT INTO sanias_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","tataḥ sivadeḥ putrau yākūbyohanau tadantikam etya procatuḥ, he guro yad āvābhyāṁ yāciṣyate tadasmadarthaṁ bhavān karotu nivedanamidamāvayoḥ| ");
INSERT INTO sanias_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","tataḥ sa kathitavān, yuvāṁ kimicchathaḥ? kiṁ mayā yuṣmadarthaṁ karaṇīyaṁ? ");
INSERT INTO sanias_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","tadā tau procatuḥ, āvayorekaṁ dakṣiṇapārśve vāmapārśve caikaṁ tavaiśvaryyapade samupaveṣṭum ājñāpaya| ");
INSERT INTO sanias_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","kintu yīśuḥ pratyuvāca yuvāmajñātvedaṁ prārthayethe, yena kaṁsenāhaṁ pāsyāmi tena yuvābhyāṁ kiṁ pātuṁ śakṣyate? yasmin majjanenāhaṁ majjiṣye tanmajjane majjayituṁ kiṁ yuvābhyāṁ śakṣyate? tau pratyūcatuḥ śakṣyate| ");
INSERT INTO sanias_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","tadā yīśuravadat yena kaṁsenāhaṁ pāsyāmi tenāvaśyaṁ yuvāmapi pāsyathaḥ, yena majjanena cāhaṁ majjiyye tatra yuvāmapi majjiṣyethe| ");
INSERT INTO sanias_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","kintu yeṣāmartham idaṁ nirūpitaṁ, tān vihāyānyaṁ kamapi mama dakṣiṇapārśve vāmapārśve vā samupaveśayituṁ mamādhikāro nāsti| ");
INSERT INTO sanias_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","athānyadaśaśiṣyā imāṁ kathāṁ śrutvā yākūbyohanbhyāṁ cukupuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","kintu yīśustān samāhūya babhāṣe, anyadeśīyānāṁ rājatvaṁ ye kurvvanti te teṣāmeva prabhutvaṁ kurvvanti, tathā ye mahālokāste teṣām adhipatitvaṁ kurvvantīti yūyaṁ jānītha| ");
INSERT INTO sanias_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","kintu yuṣmākaṁ madhye na tathā bhaviṣyati, yuṣmākaṁ madhye yaḥ prādhānyaṁ vāñchati sa yuṣmākaṁ sevako bhaviṣyati, ");
INSERT INTO sanias_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","yuṣmākaṁ yo mahān bhavitumicchati sa sarvveṣāṁ kiṅkaro bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","yato manuṣyaputraḥ sevyo bhavituṁ nāgataḥ sevāṁ karttāṁ tathānekeṣāṁ paritrāṇasya mūlyarūpasvaprāṇaṁ dātuñcāgataḥ| ");
INSERT INTO sanias_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","atha te yirīhonagaraṁ prāptāstasmāt śiṣyai rlokaiśca saha yīśo rgamanakāle ṭīmayasya putro barṭīmayanāmā andhastanmārgapārśve bhikṣārtham upaviṣṭaḥ| ");
INSERT INTO sanias_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","sa nāsaratīyasya yīśorāgamanavārttāṁ prāpya procai rvaktumārebhe, he yīśo dāyūdaḥ santāna māṁ dayasva| ");
INSERT INTO sanias_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","tatoneke lokā maunībhaveti taṁ tarjayāmāsuḥ, kintu sa punaradhikamuccai rjagāda, he yīśo dāyūdaḥ santāna māṁ dayasva| ");
INSERT INTO sanias_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","tadā yīśuḥ sthitvā tamāhvātuṁ samādideśa, tato lokāstamandhamāhūya babhāṣire, he nara, sthiro bhava, uttiṣṭha, sa tvāmāhvayati| ");
INSERT INTO sanias_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","tadā sa uttarīyavastraṁ nikṣipya protthāya yīśoḥ samīpaṁ gataḥ| ");
INSERT INTO sanias_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","tato yīśustamavadat tvayā kiṁ prārthyate? tubhyamahaṁ kiṁ kariṣyāmī? tadā sondhastamuvāca, he guro madīyā dṛṣṭirbhavet| ");
INSERT INTO sanias_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","tato yīśustamuvāca yāhi tava viśvāsastvāṁ svasthamakārṣīt, tasmāt tatkṣaṇaṁ sa dṛṣṭiṁ prāpya pathā yīśoḥ paścād yayau| ");
INSERT INTO sanias_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","anantaraṁ teṣu yirūśālamaḥ samīpasthayo rbaitphagībaithanīyapurayorantikasthaṁ jaitunanāmādrimāgateṣu yīśuḥ preṣaṇakāle dvau śiṣyāvidaṁ vākyaṁ jagāda, ");
INSERT INTO sanias_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","yuvāmamuṁ sammukhasthaṁ grāmaṁ yātaṁ, tatra praviśya yo naraṁ nāvahat taṁ garddabhaśāvakaṁ drakṣyathastaṁ mocayitvānayataṁ| ");
INSERT INTO sanias_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","kintu yuvāṁ karmmedaṁ kutaḥ kuruthaḥ? kathāmimāṁ yadi kopi pṛcchati tarhi prabhoratra prayojanamastīti kathite sa śīghraṁ tamatra preṣayiṣyati| ");
INSERT INTO sanias_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","tatastau gatvā dvimārgamelane kasyacid dvārasya pārśve taṁ garddabhaśāvakaṁ prāpya mocayataḥ, ");
INSERT INTO sanias_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","etarhi tatropasthitalokānāṁ kaścid apṛcchat, garddabhaśiśuṁ kuto mocayathaḥ? ");
INSERT INTO sanias_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","tadā yīśorājñānusāreṇa tebhyaḥ pratyudite tatkṣaṇaṁ tamādātuṁ te'nujajñuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","atha tau yīśoḥ sannidhiṁ garddabhaśiśum ānīya tadupari svavastrāṇi pātayāmāsatuḥ; tataḥ sa tadupari samupaviṣṭaḥ| ");
INSERT INTO sanias_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","tadāneke pathi svavāsāṁsi pātayāmāsuḥ, paraiśca taruśākhāśchitavā mārge vikīrṇāḥ| ");
INSERT INTO sanias_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","aparañca paścādgāmino'gragāminaśca sarvve janā ucaiḥsvareṇa vaktumārebhire, jaya jaya yaḥ parameśvarasya nāmnāgacchati sa dhanya iti| ");
INSERT INTO sanias_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","tathāsmākamaṁ pūrvvapuruṣasya dāyūdo yadrājyaṁ parameśvaranāmnāyāti tadapi dhanyaṁ, sarvvasmāducchrāye svarge īśvarasya jayo bhavet| ");
INSERT INTO sanias_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","itthaṁ yīśu ryirūśālami mandiraṁ praviśya caturdiksthāni sarvvāṇi vastūni dṛṣṭavān; atha sāyaṁkāla upasthite dvādaśaśiṣyasahito baithaniyaṁ jagāma| ");
INSERT INTO sanias_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","aparehani baithaniyād āgamanasamaye kṣudhārtto babhūva| ");
INSERT INTO sanias_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","tato dūre sapatramuḍumbarapādapaṁ vilokya tatra kiñcit phalaṁ prāptuṁ tasya sannikṛṣṭaṁ yayau, tadānīṁ phalapātanasya samayo nāgacchati| tatastatropasthitaḥ patrāṇi vinā kimapyaparaṁ na prāpya sa kathitavān, ");
INSERT INTO sanias_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","adyārabhya kopi mānavastvattaḥ phalaṁ na bhuñjīta; imāṁ kathāṁ tasya śiṣyāḥ śuśruvuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","tadanantaraṁ teṣu yirūśālamamāyāteṣu yīśu rmandiraṁ gatvā tatrasthānāṁ baṇijāṁ mudrāsanāni pārāvatavikretṛṇām āsanāni ca nyubjayāñcakāra sarvvān kretṛn vikretṛṁśca bahiścakāra| ");
INSERT INTO sanias_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","aparaṁ mandiramadhyena kimapi pātraṁ voḍhuṁ sarvvajanaṁ nivārayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","lokānupadiśan jagāda, mama gṛhaṁ sarvvajātīyānāṁ prārthanāgṛham iti nāmnā prathitaṁ bhaviṣyati etat kiṁ śāstre likhitaṁ nāsti? kintu yūyaṁ tadeva corāṇāṁ gahvaraṁ kurutha| ");
INSERT INTO sanias_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","imāṁ vāṇīṁ śrutvādhyāpakāḥ pradhānayājakāśca taṁ yathā nāśayituṁ śaknuvanti tathoेpāyaṁ mṛgayāmāsuḥ, kintu tasyopadeśāt sarvve lokā vismayaṁ gatā ataste tasmād bibhyuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","atha sāyaṁsamaya upasthite yīśurnagarād bahirvavrāja| ");
INSERT INTO sanias_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","anantaraṁ prātaḥkāle te tena mārgeṇa gacchantastamuḍumbaramahīruhaṁ samūlaṁ śuṣkaṁ dadṛśuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","tataḥ pitaraḥ pūrvvavākyaṁ smaran yīśuṁ babhāṣaṁ, he guro paśyatu ya uḍumbaraviṭapī bhavatā śaptaḥ sa śuṣko babhūva| ");
INSERT INTO sanias_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","tato yīśuḥ pratyavādīt, yūyamīśvare viśvasita| ");
INSERT INTO sanias_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","yuṣmānahaṁ yathārthaṁ vadāmi kopi yadyetadgiriṁ vadati, tvamutthāya gatvā jaladhau pata, proktamidaṁ vākyamavaśyaṁ ghaṭiṣyate, manasā kimapi na sandihya cedidaṁ viśvaset tarhi tasya vākyānusāreṇa tad ghaṭiṣyate| ");
INSERT INTO sanias_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ato hetorahaṁ yuṣmān vacmi, prārthanākāle yadyadākāṁkṣiṣyadhve tattadavaśyaṁ prāpsyatha, itthaṁ viśvasita, tataḥ prāpsyatha| ");
INSERT INTO sanias_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","aparañca yuṣmāsu prārthayituṁ samutthiteṣu yadi kopi yuṣmākam aparādhī tiṣṭhati, tarhi taṁ kṣamadhvaṁ, tathā kṛte yuṣmākaṁ svargasthaḥ pitāpi yuṣmākamāgāṁmi kṣamiṣyate| ");
INSERT INTO sanias_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","kintu yadi na kṣamadhve tarhi vaḥ svargasthaḥ pitāpi yuṣmākamāgāṁsi na kṣamiṣyate| ");
INSERT INTO sanias_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","anantaraṁ te puna ryirūśālamaṁ praviviśuḥ, yīśu ryadā madhyemandiram itastato gacchati, tadānīṁ pradhānayājakā upādhyāyāḥ prāñcaśca tadantikametya kathāmimāṁ papracchuḥ, ");
INSERT INTO sanias_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","tvaṁ kenādeśena karmmāṇyetāni karoṣi? tathaitāni karmmāṇi karttāṁ kenādiṣṭosi? ");
INSERT INTO sanias_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","tato yīśuḥ pratigaditavān ahamapi yuṣmān ekakathāṁ pṛcchāmi, yadi yūyaṁ tasyā uttaraṁ kurutha, tarhi kayājñayāhaṁ karmmāṇyetāni karomi tad yuṣmabhyaṁ kathayiṣyāmi| ");
INSERT INTO sanias_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","yohano majjanam īśvarāt jātaṁ kiṁ mānavāt? tanmahyaṁ kathayata| ");
INSERT INTO sanias_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","te parasparaṁ vivektuṁ prārebhire, tad īśvarād babhūveti ced vadāmastarhi kutastaṁ na pratyaita? kathametāṁ kathayiṣyati| ");
INSERT INTO sanias_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","mānavād abhavaditi ced vadāmastarhi lokebhyo bhayamasti yato hetoḥ sarvve yohanaṁ satyaṁ bhaviṣyadvādinaṁ manyante| ");
INSERT INTO sanias_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ataeva te yīśuṁ pratyavādiṣu rvayaṁ tad vaktuṁ na śaknumaḥ| yīśuruvāca, tarhi yenādeśena karmmāṇyetāni karomi, ahamapi yuṣmabhyaṁ tanna kathayiṣyāmi| ");
INSERT INTO sanias_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","anantaraṁ yīśu rdṛṣṭāntena tebhyaḥ kathayitumārebhe, kaścideko drākṣākṣetraṁ vidhāya taccaturdikṣu vāraṇīṁ kṛtvā tanmadhye drākṣāpeṣaṇakuṇḍam akhanat, tathā tasya gaḍamapi nirmmitavān tatastatkṣetraṁ kṛṣīvaleṣu samarpya dūradeśaṁ jagāma| ");
INSERT INTO sanias_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","tadanantaraṁ phalakāle kṛṣīvalebhyo drākṣākṣetraphalāni prāptuṁ teṣāṁ savidhe bhṛtyam ekaṁ prāhiṇot| ");
INSERT INTO sanias_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","kintu kṛṣīvalāstaṁ dhṛtvā prahṛtya riktahastaṁ visasṛjuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","tataḥ sa punaranyamekaṁ bhṛtyaṁ praṣayāmāsa, kintu te kṛṣīvalāḥ pāṣāṇāghātaistasya śiro bhaṅktvā sāpamānaṁ taṁ vyasarjan| ");
INSERT INTO sanias_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","tataḥ paraṁ soparaṁ dāsaṁ prāhiṇot tadā te taṁ jaghnuḥ, evam anekeṣāṁ kasyacit prahāraḥ kasyacid vadhaśca taiḥ kṛtaḥ| ");
INSERT INTO sanias_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","tataḥ paraṁ mayā svaputre prahite te tamavaśyaṁ sammaṁsyante, ityuktvāvaśeṣe teṣāṁ sannidhau nijapriyam advitīyaṁ putraṁ preṣayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","kintu kṛṣīvalāḥ parasparaṁ jagaduḥ, eṣa uttarādhikārī, āgacchata vayamenaṁ hanmastathā kṛte 'dhikāroyam asmākaṁ bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","tatastaṁ dhṛtvā hatvā drākṣākṣetrād bahiḥ prākṣipan| ");
INSERT INTO sanias_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","anenāsau drākṣākṣetrapatiḥ kiṁ kariṣyati? sa etya tān kṛṣīvalān saṁhatya tatkṣetram anyeṣu kṛṣīvaleṣu samarpayiṣyati| ");
INSERT INTO sanias_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","aparañca, \"sthapatayaḥ kariṣyanti grāvāṇaṁ yantu tucchakaṁ| prādhānaprastaraḥ koṇe sa eva saṁbhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","etat karmma pareśasyāṁdbhutaṁ no dṛṣṭito bhavet||\" imāṁ śāstrīyāṁ lipiṁ yūyaṁ kiṁ nāpāṭhiṣṭa? ");
INSERT INTO sanias_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","tadānīṁ sa tānuddiśya tāṁ dṛṣṭāntakathāṁ kathitavān, ta itthaṁ budvvā taṁ dharttāmudyatāḥ, kintu lokebhyo bibhyuḥ, tadanantaraṁ te taṁ vihāya vavrajuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","aparañca te tasya vākyadoṣaṁ dharttāṁ katipayān phirūśino herodīyāṁśca lokān tadantikaṁ preṣayāmāsuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ta āgatya tamavadan, he guro bhavān tathyabhāṣī kasyāpyanurodhaṁ na manyate, pakṣapātañca na karoti, yathārthata īśvarīyaṁ mārgaṁ darśayati vayametat prajānīmaḥ, kaisarāya karo deyo na vāṁ? vayaṁ dāsyāmo na vā? ");
INSERT INTO sanias_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","kintu sa teṣāṁ kapaṭaṁ jñātvā jagāda, kuto māṁ parīkṣadhve? ekaṁ mudrāpādaṁ samānīya māṁ darśayata| ");
INSERT INTO sanias_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","tadā tairekasmin mudrāpāde samānīte sa tān papraccha, atra likhitaṁ nāma mūrtti rvā kasya? te pratyūcuḥ, kaisarasya| ");
INSERT INTO sanias_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","tadā yīśuravadat tarhi kaisarasya dravyāṇi kaisarāya datta, īśvarasya dravyāṇi tu īśvarāya datta; tataste vismayaṁ menire| ");
INSERT INTO sanias_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","atha mṛtānāmutthānaṁ ye na manyante te sidūkino yīśoḥ samīpamāgatya taṁ papracchuḥ; ");
INSERT INTO sanias_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","he guro kaścijjano yadi niḥsantatiḥ san bhāryyāyāṁ satyāṁ mriyate tarhi tasya bhrātā tasya bhāryyāṁ gṛhītvā bhrātu rvaṁśotpattiṁ kariṣyati, vyavasthāmimāṁ mūsā asmān prati vyalikhat| ");
INSERT INTO sanias_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","kintu kecit sapta bhrātara āsan, tatasteṣāṁ jyeṣṭhabhrātā vivahya niḥsantatiḥ san amriyata| ");
INSERT INTO sanias_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","tato dvitīyo bhrātā tāṁ striyamagṛhaṇat kintu sopi niḥsantatiḥ san amriyata; atha tṛtīyopi bhrātā tādṛśobhavat| ");
INSERT INTO sanias_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","itthaṁ saptaiva bhrātarastāṁ striyaṁ gṛhītvā niḥsantānāḥ santo'mriyanta, sarvvaśeṣe sāpi strī mriyate sma| ");
INSERT INTO sanias_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","atha mṛtānāmutthānakāle yadā ta utthāsyanti tadā teṣāṁ kasya bhāryyā sā bhaviṣyati? yataste saptaiva tāṁ vyavahan| ");
INSERT INTO sanias_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","tato yīśuḥ pratyuvāca śāstram īśvaraśaktiñca yūyamajñātvā kimabhrāmyata na? ");
INSERT INTO sanias_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","mṛtalokānāmutthānaṁ sati te na vivahanti vāgdattā api na bhavanti, kintu svargīyadūtānāṁ sadṛśā bhavanti| ");
INSERT INTO sanias_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","punaśca \"aham ibrāhīma īśvara ishāka īśvaro yākūbaśceśvaraḥ\" yāmimāṁ kathāṁ stambamadhye tiṣṭhan īśvaro mūsāmavādīt mṛtānāmutthānārthe sā kathā mūsālikhite pustake kiṁ yuṣmābhi rnāpāṭhi? ");
INSERT INTO sanias_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","īśvaro jīvatāṁ prabhuḥ kintu mṛtānāṁ prabhu rna bhavati, tasmāddheto ryūyaṁ mahābhrameṇa tiṣṭhatha| ");
INSERT INTO sanias_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","etarhi ekodhyāpaka etya teṣāmitthaṁ vicāraṁ śuśrāva; yīśusteṣāṁ vākyasya saduttaraṁ dattavān iti budvvā taṁ pṛṣṭavān sarvvāsām ājñānāṁ kā śreṣṭhā? tato yīśuḥ pratyuvāca, ");
INSERT INTO sanias_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","\"he isrāyellokā avadhatta, asmākaṁ prabhuḥ parameśvara eka eva, ");
INSERT INTO sanias_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","yūyaṁ sarvvantaḥkaraṇaiḥ sarvvaprāṇaiḥ sarvvacittaiḥ sarvvaśaktibhiśca tasmin prabhau parameśvare prīyadhvaṁ,\" ityājñā śreṣṭhā| ");
INSERT INTO sanias_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","tathā \"svaprativāsini svavat prema kurudhvaṁ,\" eṣā yā dvitīyājñā sā tādṛśī; etābhyāṁ dvābhyām ājñābhyām anyā kāpyājñā śreṣṭhā nāsti| ");
INSERT INTO sanias_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","tadā sodhyāpakastamavadat, he guro satyaṁ bhavān yathārthaṁ proktavān yata ekasmād īśvarād anyo dvitīya īśvaro nāsti; ");
INSERT INTO sanias_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","aparaṁ sarvvāntaḥkaraṇaiḥ sarvvaprāṇaiḥ sarvvacittaiḥ sarvvaśaktibhiśca īśvare premakaraṇaṁ tathā svamīpavāsini svavat premakaraṇañca sarvvebhyo homabalidānādibhyaḥ śraṣṭhaṁ bhavati| ");
INSERT INTO sanias_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","tato yīśuḥ subuddheriva tasyedam uttaraṁ śrutvā taṁ bhāṣitavān tvamīśvarasya rājyānna dūrosi|itaḥ paraṁ tena saha kasyāpi vākyasya vicāraṁ karttāṁ kasyāpi pragalbhatā na jātā| ");
INSERT INTO sanias_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","anantaraṁ madhyemandiram upadiśan yīśurimaṁ praśnaṁ cakāra, adhyāpakā abhiṣiktaṁ (tārakaṁ) kuto dāyūdaḥ santānaṁ vadanti? ");
INSERT INTO sanias_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","svayaṁ dāyūd pavitrasyātmana āveśenedaṁ kathayāmāsa| yathā| \"mama prabhumidaṁ vākyavadat parameśvaraḥ| tava śatrūnahaṁ yāvat pādapīṭhaṁ karomi na| tāvat kālaṁ madīye tvaṁ dakṣapārśv upāviśa|\" ");
INSERT INTO sanias_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","yadi dāyūd taṁ prabhūṁ vadati tarhi kathaṁ sa tasya santāno bhavitumarhati? itare lokāstatkathāṁ śrutvānananduḥ| ");
INSERT INTO sanias_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","tadānīṁ sa tānupadiśya kathitavān ye narā dīrghaparidheyāni haṭṭe vipanau ca ");
INSERT INTO sanias_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","lokakṛtanamaskārān bhajanagṛhe pradhānāsanāni bhojanakāle pradhānasthānāni ca kāṅkṣante; ");
INSERT INTO sanias_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","vidhavānāṁ sarvvasvaṁ grasitvā chalād dīrghakālaṁ prārthayante tebhya upādhyāyebhyaḥ sāvadhānā bhavata; te'dhikatarān daṇḍān prāpsyanti| ");
INSERT INTO sanias_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","tadanantaraṁ lokā bhāṇḍāgāre mudrā yathā nikṣipanti bhāṇḍāgārasya sammukhe samupaviśya yīśustadavaluloka; tadānīṁ bahavo dhaninastasya madhye bahūni dhanāni nirakṣipan| ");
INSERT INTO sanias_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","paścād ekā daridrā vidhavā samāgatya dvipaṇamūlyāṁ mudraikāṁ tatra nirakṣipat| ");
INSERT INTO sanias_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","tadā yīśuḥ śiṣyān āhūya kathitavān yuṣmānahaṁ yathārthaṁ vadāmi ye ye bhāṇḍāgāre'smina dhanāni niḥkṣipanti sma tebhyaḥ sarvvebhya iyaṁ vidhavā daridrādhikam niḥkṣipati sma| ");
INSERT INTO sanias_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","yataste prabhūtadhanasya kiñcit nirakṣipan kintu dīneyaṁ svadinayāpanayogyaṁ kiñcidapi na sthāpayitvā sarvvasvaṁ nirakṣipat| ");
INSERT INTO sanias_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","anantaraṁ mandirād bahirgamanakāle tasya śiṣyāṇāmekastaṁ vyāhṛtavān he guro paśyatu kīdṛśāḥ pāṣāṇāḥ kīdṛk ca nicayanaṁ| ");
INSERT INTO sanias_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","tadā yīśustam avadat tvaṁ kimetad bṛhannicayanaṁ paśyasi? asyaikapāṣāṇopi dvitīyapāṣāṇopari na sthāsyati sarvve 'dhaḥkṣepsyante| ");
INSERT INTO sanias_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","atha yasmin kāle jaitungirau mandirasya sammukhe sa samupaviṣṭastasmin kāle pitaro yākūb yohan āndriyaścaite taṁ rahasi papracchuḥ, ");
INSERT INTO sanias_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","etā ghaṭanāḥ kadā bhaviṣyanti? tathaitatsarvvāsāṁ siddhyupakramasya vā kiṁ cihnaṁ? tadasmabhyaṁ kathayatu bhavān| ");
INSERT INTO sanias_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","tato yāśustān vaktumārebhe, kopi yathā yuṣmān na bhrāmayati tathātra yūyaṁ sāvadhānā bhavata| ");
INSERT INTO sanias_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","yataḥ khrīṣṭohamiti kathayitvā mama nāmnāneke samāgatya lokānāṁ bhramaṁ janayiṣyanti; ");
INSERT INTO sanias_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","kintu yūyaṁ raṇasya vārttāṁ raṇāḍambarañca śrutvā mā vyākulā bhavata, ghaṭanā etā avaśyammāvinyaḥ; kintvāpātato na yugānto bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","deśasya vipakṣatayā deśo rājyasya vipakṣatayā ca rājyamutthāsyati, tathā sthāne sthāne bhūmikampo durbhikṣaṁ mahākleśāśca samupasthāsyanti, sarvva ete duḥkhasyārambhāḥ| ");
INSERT INTO sanias_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","kintu yūyam ātmārthe sāvadhānāstiṣṭhata, yato lokā rājasabhāyāṁ yuṣmān samarpayiṣyanti, tathā bhajanagṛhe prahariṣyanti; yūyaṁ madarthe deśādhipān bhūpāṁśca prati sākṣyadānāya teṣāṁ sammukhe upasthāpayiṣyadhve| ");
INSERT INTO sanias_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","śeṣībhavanāt pūrvvaṁ sarvvān deśīyān prati susaṁvādaḥ pracārayiṣyate| ");
INSERT INTO sanias_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","kintu yadā te yuṣmān dhṛtvā samarpayiṣyanti tadā yūyaṁ yadyad uttaraṁ dāsyatha, tadagra tasya vivecanaṁ mā kuruta tadarthaṁ kiñcidapi mā cintayata ca, tadānīṁ yuṣmākaṁ manaḥsu yadyad vākyam upasthāpayiṣyate tadeva vadiṣyatha, yato yūyaṁ na tadvaktāraḥ kintu pavitra ātmā tasya vaktā| ");
INSERT INTO sanias_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","tadā bhrātā bhrātaraṁ pitā putraṁ ghātanārthaṁ parahasteṣu samarpayiṣyate, tathā patyāni mātāpitro rvipakṣatayā tau ghātayiṣyanti| ");
INSERT INTO sanias_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","mama nāmahetoḥ sarvveṣāṁ savidhe yūyaṁ jugupsitā bhaviṣyatha, kintu yaḥ kaścit śeṣaparyyantaṁ dhairyyam ālambiṣyate saeva paritrāsyate| ");
INSERT INTO sanias_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","dāniyelbhaviṣyadvādinā proktaṁ sarvvanāśi jugupsitañca vastu yadā tvayogyasthāne vidyamānaṁ drakṣatha (yo janaḥ paṭhati sa budhyatāṁ) tadā ye yihūdīyadeśe tiṣṭhanti te mahīdhraṁ prati palāyantāṁ; ");
INSERT INTO sanias_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","tathā yo naro gṛhopari tiṣṭhati sa gṛhamadhyaṁ nāvarohatu, tathā kimapi vastu grahītuṁ madhyegṛhaṁ na praviśatu; ");
INSERT INTO sanias_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","tathā ca yo naraḥ kṣetre tiṣṭhati sopi svavastraṁ grahītuṁ parāvṛtya na vrajatu| ");
INSERT INTO sanias_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","tadānīṁ garbbhavatīnāṁ stanyadātrīṇāñca yoṣitāṁ durgati rbhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","yuṣmākaṁ palāyanaṁ śītakāle yathā na bhavati tadarthaṁ prārthayadhvaṁ| ");
INSERT INTO sanias_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","yatastadā yādṛśī durghaṭanā ghaṭiṣyate tādṛśī durghaṭanā īśvarasṛṣṭeḥ prathamamārabhyādya yāvat kadāpi na jātā na janiṣyate ca| ");
INSERT INTO sanias_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","aparañca parameśvaro yadi tasya samayasya saṁkṣepaṁ na karoti tarhi kasyāpi prāṇabhṛto rakṣā bhavituṁ na śakṣyati, kintu yān janān manonītān akarot teṣāṁ svamanonītānāṁ hetoḥ sa tadanehasaṁ saṁkṣepsyati| ");
INSERT INTO sanias_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","anyacca paśyata khrīṣṭotra sthāne vā tatra sthāne vidyate, tasminkāle yadi kaścid yuṣmān etādṛśaṁ vākyaṁ vyāharati, tarhi tasmin vākye bhaiva viśvasita| ");
INSERT INTO sanias_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","yatoneke mithyākhrīṣṭā mithyābhaviṣyadvādinaśca samupasthāya bahūni cihnānyadbhutāni karmmāṇi ca darśayiṣyanti; tathā yadi sambhavati tarhi manonītalokānāmapi mithyāmatiṁ janayiṣyanti| ");
INSERT INTO sanias_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","paśyata ghaṭanātaḥ pūrvvaṁ sarvvakāryyasya vārttāṁ yuṣmabhyamadām, yūyaṁ sāvadhānāstiṣṭhata| ");
INSERT INTO sanias_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","aparañca tasya kleśakālasyāvyavahite parakāle bhāskaraḥ sāndhakāro bhaviṣyati tathaiva candraścandrikāṁ na dāsyati| ");
INSERT INTO sanias_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","nabhaḥsthāni nakṣatrāṇi patiṣyanti, vyomamaṇḍalasthā grahāśca vicaliṣyanti| ");
INSERT INTO sanias_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","tadānīṁ mahāparākrameṇa mahaiśvaryyeṇa ca meghamāruhya samāyāntaṁ mānavasutaṁ mānavāḥ samīkṣiṣyante| ");
INSERT INTO sanias_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","anyacca sa nijadūtān prahitya nabhobhūmyoḥ sīmāṁ yāvad jagataścaturdigbhyaḥ svamanonītalokān saṁgrahīṣyati| ");
INSERT INTO sanias_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","uḍumbarataro rdṛṣṭāntaṁ śikṣadhvaṁ yadoḍumbarasya taro rnavīnāḥ śākhā jāyante pallavādīni ca rnigacchanti, tadā nidāghakālaḥ savidho bhavatīti yūyaṁ jñātuṁ śaknutha| ");
INSERT INTO sanias_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","tadvad etā ghaṭanā dṛṣṭvā sa kālo dvāryyupasthita iti jānīta| ");
INSERT INTO sanias_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","yuṣmānahaṁ yathārthaṁ vadāmi, ādhunikalokānāṁ gamanāt pūrvvaṁ tāni sarvvāṇi ghaṭiṣyante| ");
INSERT INTO sanias_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","dyāvāpṛthivyo rvicalitayoḥ satyo rmadīyā vāṇī na vicaliṣyati| ");
INSERT INTO sanias_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","aparañca svargasthadūtagaṇo vā putro vā tātādanyaḥ kopi taṁ divasaṁ taṁ daṇḍaṁ vā na jñāpayati| ");
INSERT INTO sanias_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ataḥ sa samayaḥ kadā bhaviṣyati, etajjñānābhāvād yūyaṁ sāvadhānāstiṣṭhata, satarkāśca bhūtvā prārthayadhvaṁ; ");
INSERT INTO sanias_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","yadvat kaścit pumān svaniveśanād dūradeśaṁ prati yātrākaraṇakāle dāseṣu svakāryyasya bhāramarpayitvā sarvvān sve sve karmmaṇi niyojayati; aparaṁ dauvārikaṁ jāgarituṁ samādiśya yāti, tadvan naraputraḥ| ");
INSERT INTO sanias_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","gṛhapatiḥ sāyaṁkāle niśīthe vā tṛtīyayāme vā prātaḥkāle vā kadāgamiṣyati tad yūyaṁ na jānītha; ");
INSERT INTO sanias_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","sa haṭhādāgatya yathā yuṣmān nidritān na paśyati, tadarthaṁ jāgaritāstiṣṭhata| ");
INSERT INTO sanias_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","yuṣmānahaṁ yad vadāmi tadeva sarvvān vadāmi, jāgaritāstiṣṭhateti| ");
INSERT INTO sanias_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","tadā nistārotsavakiṇvahīnapūpotsavayorārambhasya dinadvaye 'vaśiṣṭe pradhānayājakā adhyāpakāśca kenāpi chalena yīśuṁ dharttāṁ hantuñca mṛgayāñcakrire; ");
INSERT INTO sanias_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","kintu lokānāṁ kalahabhayādūcire, nacotsavakāla ucitametaditi| ");
INSERT INTO sanias_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","anantaraṁ baithaniyāpuुre śimonakuṣṭhino gṛhe yośau bhotkumupaviṣṭe sati kācid yoṣit pāṇḍarapāṣāṇasya sampuṭakena mahārghyottamatailam ānīya sampuṭakaṁ bhaṁktvā tasyottamāṅge tailadhārāṁ pātayāñcakre| ");
INSERT INTO sanias_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","tasmāt kecit svānte kupyantaḥ kathitavaṁntaḥ kutoyaṁ tailāpavyayaḥ? ");
INSERT INTO sanias_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","yadyetat taila vyakreṣyata tarhi mudrāpādaśatatrayādapyadhikaṁ tasya prāptamūlyaṁ daridralokebhyo dātumaśakṣyata, kathāmetāṁ kathayitvā tayā yoṣitā sākaṁ vācāyuhyan| ");
INSERT INTO sanias_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","kintu yīśuruvāca, kuta etasyai kṛcchraṁ dadāsi? mahyamiyaṁ karmmottamaṁ kṛtavatī| ");
INSERT INTO sanias_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","daridrāḥ sarvvadā yuṣmābhiḥ saha tiṣṭhanti, tasmād yūyaṁ yadecchatha tadaiva tānupakarttāṁ śaknutha, kintvahaṁ yubhābhiḥ saha nirantaraṁ na tiṣṭhāmi| ");
INSERT INTO sanias_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","asyā yathāsādhyaṁ tathaivākarodiyaṁ, śmaśānayāpanāt pūrvvaṁ sametya madvapuṣi tailam amarddayat| ");
INSERT INTO sanias_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","ahaṁ yuṣmabhyaṁ yathārthaṁ kathayāmi, jagatāṁ madhye yatra yatra susaṁvādoyaṁ pracārayiṣyate tatra tatra yoṣita etasyāḥ smaraṇārthaṁ tatkṛtakarmmaitat pracārayiṣyate| ");
INSERT INTO sanias_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","tataḥ paraṁ dvādaśānāṁ śiṣyāṇāmeka īṣkariyotīyayihūdākhyo yīśuṁ parakareṣu samarpayituṁ pradhānayājakānāṁ samīpamiyāya| ");
INSERT INTO sanias_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","te tasya vākyaṁ samākarṇya santuṣṭāḥ santastasmai mudrā dātuṁ pratyajānata; tasmāt sa taṁ teṣāṁ kareṣu samarpaṇāyopāyaṁ mṛgayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","anantaraṁ kiṇvaśūnyapūpotsavasya prathame'hani nistārotmavārthaṁ meṣamāraṇāsamaye śiṣyāstaṁ papracchaḥ kutra gatvā vayaṁ nistārotsavasya bhojyamāsādayiṣyāmaḥ? kimicchati bhavān? ");
INSERT INTO sanias_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","tadānīṁ sa teṣāṁ dvayaṁ prerayan babhāṣe yuvayoḥ puramadhyaṁ gatayoḥ sato ryo janaḥ sajalakumbhaṁ vahan yuvāṁ sākṣāt kariṣyati tasyaiva paścād yātaṁ; ");
INSERT INTO sanias_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","sa yat sadanaṁ pravekṣyati tadbhavanapatiṁ vadataṁ, gururāha yatra saśiṣyohaṁ nistārotsavīyaṁ bhojanaṁ kariṣyāmi, sā bhojanaśālā kutrāsti? ");
INSERT INTO sanias_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","tataḥ sa pariṣkṛtāṁ susajjitāṁ bṛhatīcañca yāṁ śālāṁ darśayiṣyati tasyāmasmadarthaṁ bhojyadravyāṇyāsādayataṁ| ");
INSERT INTO sanias_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","tataḥ śiṣyau prasthāya puraṁ praviśya sa yathoktavān tathaiva prāpya nistārotsavasya bhojyadravyāṇi samāsādayetām| ");
INSERT INTO sanias_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","anantaraṁ yīśuḥ sāyaṁkāle dvādaśabhiḥ śiṣyaiḥ sārddhaṁ jagāma; ");
INSERT INTO sanias_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","sarvveṣu bhojanāya propaviṣṭeṣu sa tānuditavān yuṣmānahaṁ yathārthaṁ vyāharāmi, atra yuṣmākameko jano yo mayā saha bhuṁkte māṁ parakereṣu samarpayiṣyate| ");
INSERT INTO sanias_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","tadānīṁ te duḥkhitāḥ santa ekaikaśastaṁ praṣṭumārabdhavantaḥ sa kimahaṁ? paścād anya ekobhidadhe sa kimahaṁ? ");
INSERT INTO sanias_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","tataḥ sa pratyavadad eteṣāṁ dvādaśānāṁ yo jano mayā samaṁ bhojanāpātre pāṇiṁ majjayiṣyati sa eva| ");
INSERT INTO sanias_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","manujatanayamadhi yādṛśaṁ likhitamāste tadanurūpā gatistasya bhaviṣyati, kintu yo jano mānavasutaṁ samarpayiṣyate hanta tasya janmābhāve sati bhadramabhaviṣyat| ");
INSERT INTO sanias_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","aparañca teṣāṁ bhojanasamaye yīśuḥ pūpaṁ gṛhītveśvaraguṇān anukīrtya bhaṅktvā tebhyo dattvā babhāṣe, etad gṛhītvā bhuñjīdhvam etanmama vigraharūpaṁ| ");
INSERT INTO sanias_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","anantaraṁ sa kaṁsaṁ gṛhītveśvarasya guṇān kīrttayitvā tebhyo dadau, tataste sarvve papuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","aparaṁ sa tānavādīd bahūnāṁ nimittaṁ pātitaṁ mama navīnaniyamarūpaṁ śoṇitametat| ");
INSERT INTO sanias_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","yuṣmānahaṁ yathārthaṁ vadāmi, īśvarasya rājye yāvat sadyojātaṁ drākṣārasaṁ na pāsyāmi,tāvadahaṁ drākṣāphalarasaṁ puna rna pāsyāmi| ");
INSERT INTO sanias_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","tadanantaraṁ te gītamekaṁ saṁgīya bahi rjaitunaṁ śikhariṇaṁ yayuḥ ");
INSERT INTO sanias_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","atha yīśustānuvāca niśāyāmasyāṁ mayi yuṣmākaṁ sarvveṣāṁ pratyūho bhaviṣyati yato likhitamāste yathā, meṣāṇāṁ rakṣakañcāhaṁ prahariṣyāmi vai tataḥ| meṣāṇāṁ nivaho nūnaṁ pravikīrṇo bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","kantu madutthāne jāte yuṣmākamagre'haṁ gālīlaṁ vrajiṣyāmi| ");
INSERT INTO sanias_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","tadā pitaraḥ pratibabhāṣe, yadyapi sarvveṣāṁ pratyūho bhavati tathāpi mama naiva bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","tato yīśuruktāvān ahaṁ tubhyaṁ tathyaṁ kathayāmi, kṣaṇādāyāmadya kukkuṭasya dvitīyavāraravaṇāt pūrvvaṁ tvaṁ vāratrayaṁ māmapahnoṣyase| ");
INSERT INTO sanias_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","kintu sa gāḍhaṁ vyāharad yadyapi tvayā sārddhaṁ mama prāṇo yāti tathāpi kathamapi tvāṁ nāpahnoṣye; sarvve'pītare tathaiva babhāṣire| ");
INSERT INTO sanias_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","aparañca teṣu getśimānīnāmakaṁ sthāna gateṣu sa śiṣyān jagāda, yāvadahaṁ prārthaye tāvadatra sthāne yūyaṁ samupaviśata| ");
INSERT INTO sanias_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","atha sa pitaraṁ yākūbaṁ yohanañca gṛhītvā vavrāja; atyantaṁ trāsito vyākulitaśca tebhyaḥ kathayāmāsa, ");
INSERT INTO sanias_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","nidhanakālavat prāṇo me'tīva daḥkhameti, yūyaṁ jāgratotra sthāne tiṣṭhata| ");
INSERT INTO sanias_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","tataḥ sa kiñciddūraṁ gatvā bhūmāvadhomukhaḥ patitvā prārthitavānetat, yadi bhavituṁ śakyaṁ tarhi duḥkhasamayoyaṁ matto dūrībhavatu| ");
INSERT INTO sanias_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","aparamuditavān he pita rhe pitaḥ sarvveṁ tvayā sādhyaṁ, tato hetorimaṁ kaṁsaṁ matto dūrīkuru, kintu tan mamecchāto na tavecchāto bhavatu| ");
INSERT INTO sanias_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","tataḥ paraṁ sa etya tān nidritān nirīkṣya pitaraṁ provāca, śimon tvaṁ kiṁ nidrāsi? ghaṭikāmekām api jāgarituṁ na śaknoṣi? ");
INSERT INTO sanias_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","parīkṣāyāṁ yathā na patatha tadarthaṁ sacetanāḥ santaḥ prārthayadhvaṁ; mana udyuktamiti satyaṁ kintu vapuraśaktikaṁ| ");
INSERT INTO sanias_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","atha sa punarvrajitvā pūrvvavat prārthayāñcakre| ");
INSERT INTO sanias_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","parāvṛtyāgatya punarapi tān nidritān dadarśa tadā teṣāṁ locanāni nidrayā pūrṇāni, tasmāttasmai kā kathā kathayitavyā ta etad boddhuṁ na śekuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","tataḥparaṁ tṛtīyavāraṁ āgatya tebhyo 'kathayad idānīmapi śayitvā viśrāmyatha? yatheṣṭaṁ jātaṁ, samayaścopasthitaḥ paśyata mānavatanayaḥ pāpilokānāṁ pāṇiṣu samarpyate| ");
INSERT INTO sanias_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","uttiṣṭhata, vayaṁ vrajāmo yo jano māṁ parapāṇiṣu samarpayiṣyate paśyata sa samīpamāyātaḥ| ");
INSERT INTO sanias_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","imāṁ kathāṁ kathayati sa, etarhidvādaśānāmeko yihūdā nāmā śiṣyaḥ pradhānayājakānām upādhyāyānāṁ prācīnalokānāñca sannidheḥ khaṅgalaguḍadhāriṇo bahulokān gṛhītvā tasya samīpa upasthitavān| ");
INSERT INTO sanias_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","aparañcāsau parapāṇiṣu samarpayitā pūrvvamiti saṅketaṁ kṛtavān yamahaṁ cumbiṣyāmi sa evāsau tameva dhṛtvā sāvadhānaṁ nayata| ");
INSERT INTO sanias_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ato hetoḥ sa āgatyaiva yośoḥ savidhaṁ gatvā he guro he guro, ityuktvā taṁ cucumba| ");
INSERT INTO sanias_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","tadā te tadupari pāṇīnarpayitvā taṁ dadhnuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","tatastasya pārśvasthānāṁ lokānāmekaḥ khaṅgaṁ niṣkoṣayan mahāyājakasya dāsamekaṁ prahṛtya tasya karṇaṁ ciccheda| ");
INSERT INTO sanias_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","paścād yīśustān vyājahāra khaṅgān laguḍāṁśca gṛhītvā māṁ kiṁ cauraṁ dharttāṁ samāyātāḥ? ");
INSERT INTO sanias_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","madhyemandiraṁ samupadiśan pratyahaṁ yuṣmābhiḥ saha sthitavānatahaṁ, tasmin kāle yūyaṁ māṁ nādīdharata, kintvanena śāstrīyaṁ vacanaṁ sedhanīyaṁ| ");
INSERT INTO sanias_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","tadā sarvve śiṣyāstaṁ parityajya palāyāñcakrire| ");
INSERT INTO sanias_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","athaiko yuvā mānavo nagnakāye vastramekaṁ nidhāya tasya paścād vrajan yuvalokai rdhṛto ");
INSERT INTO sanias_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","vastraṁ vihāya nagnaḥ palāyāñcakre| ");
INSERT INTO sanias_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","aparañca yasmin sthāne pradhānayājakā upādhyāyāḥ prācīnalokāśca mahāyājakena saha sadasi sthitāstasmin sthāne mahāyājakasya samīpaṁ yīśuṁ ninyuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","pitaro dūre tatpaścād itvā mahāyājakasyāṭṭālikāṁ praviśya kiṅkaraiḥ sahopaviśya vahnitāpaṁ jagrāha| ");
INSERT INTO sanias_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","tadānīṁ pradhānayājakā mantriṇaśca yīśuṁ ghātayituṁ tatprātikūlyena sākṣiṇo mṛgayāñcakrire, kintu na prāptāḥ| ");
INSERT INTO sanias_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","anekaistadviruddhaṁ mṛṣāsākṣye dattepi teṣāṁ vākyāni na samagacchanta| ");
INSERT INTO sanias_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","sarvvaśeṣe kiyanta utthāya tasya prātikūlyena mṛṣāsākṣyaṁ dattvā kathayāmāsuḥ, ");
INSERT INTO sanias_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","idaṁ karakṛtamandiraṁ vināśya dinatrayamadhye punaraparam akarakṛtaṁ mandiraṁ nirmmāsyāmi, iti vākyam asya mukhāt śrutamasmābhiriti| ");
INSERT INTO sanias_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","kintu tatrāpi teṣāṁ sākṣyakathā na saṅgātāḥ| ");
INSERT INTO sanias_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","atha mahāyājako madhyesabham utthāya yīśuṁ vyājahāra, ete janāstvayi yat sākṣyamaduḥ tvametasya kimapyuttaraṁ kiṁ na dāsyasi? ");
INSERT INTO sanias_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","kintu sa kimapyuttaraṁ na datvā maunībhūya tasyau; tato mahāyājakaḥ punarapi taṁ pṛṣṭāvān tvaṁ saccidānandasya tanayo 'bhiṣiktastratā? ");
INSERT INTO sanias_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","tadā yīśustaṁ provāca bhavāmyaham yūyañca sarvvaśaktimato dakṣīṇapārśve samupaviśantaṁ megha māruhya samāyāntañca manuṣyaputraṁ sandrakṣyatha| ");
INSERT INTO sanias_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","tadā mahāyājakaḥ svaṁ vamanaṁ chitvā vyāvaharat ");
INSERT INTO sanias_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","kimasmākaṁ sākṣibhiḥ prayojanam? īśvaranindāvākyaṁ yuṣmābhiraśrāvi kiṁ vicārayatha? tadānīṁ sarvve jagadurayaṁ nidhanadaṇḍamarhati| ");
INSERT INTO sanias_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","tataḥ kaścit kaścit tadvapuṣi niṣṭhīvaṁ nicikṣepa tathā tanmukhamācchādya capeṭena hatvā gaditavān gaṇayitvā vada, anucarāśca capeṭaistamājaghnuḥ ");
INSERT INTO sanias_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","tataḥ paraṁ pitare'ṭṭālikādhaḥkoṣṭhe tiṣṭhati mahāyājakasyaikā dāsī sametya ");
INSERT INTO sanias_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","taṁ vihnitāpaṁ gṛhlantaṁ vilokya taṁ sunirīkṣya babhāṣe tvamapi nāsaratīyayīśoḥ saṅginām eko jana āsīḥ| ");
INSERT INTO sanias_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","kintu sopahnutya jagāda tamahaṁ na vadmi tvaṁ yat kathayami tadapyahaṁ na buddhye| tadānīṁ pitare catvaraṁ gatavati kuेkkuṭo rurāva| ");
INSERT INTO sanias_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","athānyā dāsī pitaraṁ dṛṣṭvā samīpasthān janān jagāda ayaṁ teṣāmeko janaḥ| ");
INSERT INTO sanias_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","tataḥ sa dvitīyavāram apahnutavān paścāt tatrasthā lokāḥ pitaraṁ procustvamavaśyaṁ teṣāmeko janaḥ yatastvaṁ gālīlīyo nara iti tavoccāraṇaṁ prakāśayati| ");
INSERT INTO sanias_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","tadā sa śapathābhiśāpau kṛtvā provāca yūyaṁ kathāṁ kathayatha taṁ naraṁ na jāne'haṁ| ");
INSERT INTO sanias_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","tadānīṁ dvitīyavāraṁ kukkuṭo 'rāvīt| kukkuṭasya dvitīyaravāt pūrvvaṁ tvaṁ māṁ vāratrayam apahnoṣyasi, iti yadvākyaṁ yīśunā samuditaṁ tat tadā saṁsmṛtya pitaro roditum ārabhata| ");
INSERT INTO sanias_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","atha prabhāte sati pradhānayājakāḥ prāñca upādhyāyāḥ sarvve mantriṇaśca sabhāṁ kṛtvā yīśuृṁ bandhayitva pīlātākhyasya deśādhipateḥ savidhaṁ nītvā samarpayāmāsuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","tadā pīlātastaṁ pṛṣṭavān tvaṁ kiṁ yihūdīyalokānāṁ rājā? tataḥ sa pratyuktavān satyaṁ vadasi| ");
INSERT INTO sanias_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","aparaṁ pradhānayājakāstasya bahuṣu vākyeṣu doṣamāropayāñcakruḥ kintu sa kimapi na pratyuvāca| ");
INSERT INTO sanias_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","tadānīṁ pīlātastaṁ punaḥ papraccha tvaṁ kiṁ nottarayasi? paśyaite tvadviruddhaṁ katiṣu sādhyeṣu sākṣaṁ dadati| ");
INSERT INTO sanias_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","kantu yīśustadāpi nottaraṁ dadau tataḥ pīlāta āścaryyaṁ jagāma| ");
INSERT INTO sanias_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","aparañca kārābaddhe kastiṁścit jane tanmahotsavakāle lokai ryācite deśādhipatistaṁ mocayati| ");
INSERT INTO sanias_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ye ca pūrvvamupaplavamakārṣurupaplave vadhamapi kṛtavantasteṣāṁ madhye tadānoṁ barabbānāmaka eko baddha āsīt| ");
INSERT INTO sanias_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ato hetoḥ pūrvvāparīyāṁ rītikathāṁ kathayitvā lokā uccairuvantaḥ pīlātasya samakṣaṁ nivedayāmāsuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","tadā pīlātastānācakhyau tarhi kiṁ yihūdīyānāṁ rājānaṁ mocayiṣyāmi? yuṣmābhiḥ kimiṣyate? ");
INSERT INTO sanias_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","yataḥ pradhānayājakā īrṣyāta eva yīśuṁ samārpayanniti sa viveda| ");
INSERT INTO sanias_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","kintu yathā barabbāṁ mocayati tathā prārthayituṁ pradhānayājakā lokān pravarttayāmāsuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","atha pīlātaḥ punaḥ pṛṣṭavān tarhi yaṁ yihūdīyānāṁ rājeti vadatha tasya kiṁ kariṣyāmi yuṣmābhiḥ kimiṣyate? ");
INSERT INTO sanias_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","tadā te punarapi proccaiḥ procustaṁ kruśe vedhaya| ");
INSERT INTO sanias_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","tasmāt pīlātaḥ kathitavān kutaḥ? sa kiṁ kukarmma kṛtavān? kintu te punaśca ruvanto vyājahrustaṁ kruśe vedhaya| ");
INSERT INTO sanias_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","tadā pīlātaḥ sarvvāllokān toṣayitumicchan barabbāṁ mocayitvā yīśuṁ kaśābhiḥ prahṛtya kruśe veddhuṁ taṁ samarpayāmbabhūva| ");
INSERT INTO sanias_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","anantaraṁ sainyagaṇo'ṭṭālikām arthād adhipate rgṛhaṁ yīśuṁ nītvā senānivahaṁ samāhuyat| ");
INSERT INTO sanias_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","paścāt te taṁ dhūmalavarṇavastraṁ paridhāpya kaṇṭakamukuṭaṁ racayitvā śirasi samāropya ");
INSERT INTO sanias_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","he yihūdīyānāṁ rājan namaskāra ityuktvā taṁ namaskarttāmārebhire| ");
INSERT INTO sanias_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","tasyottamāṅge vetrāghātaṁ cakrustadgātre niṣṭhīvañca nicikṣipuḥ, tathā tasya sammukhe jānupātaṁ praṇomuḥ ");
INSERT INTO sanias_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","itthamupahasya dhūmravarṇavastram uttāryya tasya vastraṁ taṁ paryyadhāpayan kruśe veddhuṁ bahirninyuśca| ");
INSERT INTO sanias_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","tataḥ paraṁ sekandarasya ruphasya ca pitā śimonnāmā kurīṇīyaloka ekaḥ kutaścid grāmādetya pathi yāti taṁ te yīśoḥ kruśaṁ voḍhuṁ balād dadhnuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","atha gulgaltā arthāt śiraḥkapālanāmakaṁ sthānaṁ yīśumānīya ");
INSERT INTO sanias_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","te gandharasamiśritaṁ drākṣārasaṁ pātuṁ tasmai daduḥ kintu sa na jagrāha| ");
INSERT INTO sanias_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","tasmin kruśe viddhe sati teṣāmekaikaśaḥ kiṁ prāpsyatīti nirṇayāya ");
INSERT INTO sanias_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","tasya paridheyānāṁ vibhāgārthaṁ guṭikāpātaṁ cakruḥ| ");
INSERT INTO sanias_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","aparam eṣa yihūdīyānāṁ rājeti likhitaṁ doṣapatraṁ tasya śiraūrdvvam āropayāñcakruḥ| ");
INSERT INTO sanias_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","tasya vāmadakṣiṇayo rdvau caurau kruśayo rvividhāte| ");
INSERT INTO sanias_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","tenaiva \"aparādhijanaiḥ sārddhaṁ sa gaṇito bhaviṣyati,\" iti śāstroktaṁ vacanaṁ siddhamabhūta| ");
INSERT INTO sanias_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","anantaraṁ mārge ye ye lokā gamanāgamane cakruste sarvva eva śirāṁsyāndolya nindanto jagaduḥ, re mandiranāśaka re dinatrayamadhye tannirmmāyaka, ");
INSERT INTO sanias_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","adhunātmānam avitvā kruśādavaroha| ");
INSERT INTO sanias_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","kiñca pradhānayājakā adhyāpakāśca tadvat tiraskṛtya parasparaṁ cacakṣire eṣa parānāvat kintu svamavituṁ na śaknoti| ");
INSERT INTO sanias_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","yadīsrāyelo rājābhiṣiktastrātā bhavati tarhyadhunaina kruśādavarohatu vayaṁ tad dṛṣṭvā viśvasiṣyāmaḥ; kiñca yau lokau tena sārddhaṁ kruśe 'vidhyetāṁ tāvapi taṁ nirbhartsayāmāsatuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","atha dvitīyayāmāt tṛtīyayāmaṁ yāvat sarvvo deśaḥ sāndhakārobhūt| ");
INSERT INTO sanias_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","tatastṛtīyaprahare yīśuruccairavadat elī elī lāmā śivaktanī arthād \"he madīśa madīśa tvaṁ paryyatyākṣīḥ kuto hi māṁ?\" ");
INSERT INTO sanias_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","tadā samīpasthalokānāṁ kecit tadvākyaṁ niśamyācakhyuḥ paśyaiṣa eliyam āhūyati| ");
INSERT INTO sanias_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","tata eko jano dhāvitvāgatya spañje 'mlarasaṁ pūrayitvā taṁ naḍāgre nidhāya pātuṁ tasmai dattvāvadat tiṣṭha eliya enamavarohayitum eti na veti paśyāmi| ");
INSERT INTO sanias_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","atha yīśuruccaiḥ samāhūya prāṇān jahau| ");
INSERT INTO sanias_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","tadā mandirasya javanikordvvādadhaḥryyantā vidīrṇā dvikhaṇḍābhūt| ");
INSERT INTO sanias_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","kiñca itthamuccairāhūya prāṇān tyajantaṁ taṁ dṛṣdvā tadrakṣaṇāya niyukto yaḥ senāpatirāsīt sovadat naroyam īśvaraputra iti satyam| ");
INSERT INTO sanias_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","tadānīṁ magdalīnī marisam kaniṣṭhayākūbo yoseśca mātānyamariyam śālomī ca yāḥ striyo ");
INSERT INTO sanias_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","gālīlpradeśe yīśuṁ sevitvā tadanugāminyo jātā imāstadanyāśca yā anekā nāryo yīśunā sārddhaṁ yirūśālamamāyātāstāśca dūrāt tāni dadṛśuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","athāsādanadinasyārthād viśrāmavārāt pūrvvadinasya sāyaṁkāla āgata ");
INSERT INTO sanias_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","īśvararājyāpekṣyarimathīyayūṣaphanāmā mānyamantrī sametya pīlātasavidhaṁ nirbhayo gatvā yīśordehaṁ yayāce| ");
INSERT INTO sanias_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","kintu sa idānīṁ mṛtaḥ pīlāta ityasambhavaṁ matvā śatasenāpatimāhūya sa kadā mṛta iti papraccha| ");
INSERT INTO sanias_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","śatasemanāpatimukhāt tajjñātvā yūṣaphe yīśordehaṁ dadau| ");
INSERT INTO sanias_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","paścāt sa sūkṣmaṁ vāsaḥ krītvā yīśoḥ kāyamavarohya tena vāsasā veṣṭāyitvā girau khātaśmaśāne sthāpitavān pāṣāṇaṁ loṭhayitvā dvāri nidadhe| ");
INSERT INTO sanias_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","kintu yatra sosthāpyata tata magdalīnī mariyam yosimātṛmariyam ca dadṛśatṛḥ| ");
INSERT INTO sanias_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","atha viśrāmavāre gate magdalīnī mariyam yākūbamātā mariyam śālomī cemāstaṁ marddayituṁ sugandhidravyāṇi krītvā ");
INSERT INTO sanias_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","saptāhaprathamadine'tipratyūṣe sūryyodayakāle śmaśānamupagatāḥ| ");
INSERT INTO sanias_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","kintu śmaśānadvārapāṣāṇo'tibṛhan taṁ ko'pasārayiṣyatīti tāḥ parasparaṁ gadanti! ");
INSERT INTO sanias_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","etarhi nirīkṣya pāṣāṇo dvāro 'pasārita iti dadṛśuḥ| ");
INSERT INTO sanias_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","paścāttāḥ śmaśānaṁ praviśya śuklavarṇadīrghaparicchadāvṛtamekaṁ yuvānaṁ śmaśānadakṣiṇapārśva upaviṣṭaṁ dṛṣṭvā camaccakruḥ| ");
INSERT INTO sanias_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","so'vadat, mābhaiṣṭa yūyaṁ kruśe hataṁ nāsaratīyayīśuṁ gaveṣayatha sotra nāsti śmaśānādudasthāt; tai ryatra sa sthāpitaḥ sthānaṁ tadidaṁ paśyata| ");
INSERT INTO sanias_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","kintu tena yathoktaṁ tathā yuṣmākamagre gālīlaṁ yāsyate tatra sa yuṣmān sākṣāt kariṣyate yūyaṁ gatvā tasya śiṣyebhyaḥ pitarāya ca vārttāmimāṁ kathayata| ");
INSERT INTO sanias_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","tāḥ kampitā vistitāśca tūrṇaṁ śmaśānād bahirgatvā palāyanta bhayāt kamapi kimapi nāvadaṁśca| ");
INSERT INTO sanias_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","aparaṁ yīśuḥ saptāhaprathamadine pratyūṣe śmaśānādutthāya yasyāḥ saptabhūtāstyājitāstasyai magdalīnīmariyame prathamaṁ darśanaṁ dadau| ");
INSERT INTO sanias_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","tataḥ sā gatvā śokarodanakṛdbhyo'nugatalokebhyastāṁ vārttāṁ kathayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","kintu yīśuḥ punarjīvan tasyai darśanaṁ dattavāniti śrutvā te na pratyayan| ");
INSERT INTO sanias_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","paścāt teṣāṁ dvāyo rgrāmayānakāle yīśuranyaveśaṁ dhṛtvā tābhyāṁ darśana dadau! ");
INSERT INTO sanias_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","tāvapi gatvānyaśiṣyebhyastāṁ kathāṁ kathayāñcakratuḥ kintu tayoḥ kathāmapi te na pratyayan| ");
INSERT INTO sanias_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","śeṣata ekādaśaśiṣyeṣu bhojanopaviṣṭeṣu yīśustebhyo darśanaṁ dadau tathotthānāt paraṁ taddarśanaprāptalokānāṁ kathāyāmaviśvāsakaraṇāt teṣāmaviśvāsamanaḥkāṭhinyābhyāṁ hetubhyāṁ sa tāṁstarjitavān| ");
INSERT INTO sanias_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","atha tānācakhyau yūyaṁ sarvvajagad gatvā sarvvajanān prati susaṁvādaṁ pracārayata| ");
INSERT INTO sanias_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","tatra yaḥ kaścid viśvasya majjito bhavet sa paritrāsyate kintu yo na viśvasiṣyati sa daṇḍayiṣyate| ");
INSERT INTO sanias_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","kiñca ye pratyeṣyanti tairīdṛg āścaryyaṁ karmma prakāśayiṣyate te mannāmnā bhūtān tyājayiṣyanti bhāṣā anyāśca vadiṣyanti| ");
INSERT INTO sanias_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","aparaṁ taiḥ sarpeṣu dhṛteṣu prāṇanāśakavastuni pīte ca teṣāṁ kāpi kṣati rna bhaviṣyati; rogiṇāṁ gātreṣu karārpite te'rogā bhaviṣyanti ca| ");
INSERT INTO sanias_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","atha prabhustānityādiśya svargaṁ nītaḥ san parameśvarasya dakṣiṇa upaviveśa| ");
INSERT INTO sanias_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","tataste prasthāya sarvvatra susaṁvādīyakathāṁ pracārayitumārebhire prabhustu teṣāṁ sahāyaḥ san prakāśitāścaryyakriyābhistāṁ kathāṁ pramāṇavatīṁ cakāra| iti|");
INSERT INTO sanias_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","prathamato ye sākṣiṇo vākyapracārakāścāsan te'smākaṁ madhye yadyat sapramāṇaṁ vākyamarpayanti sma ");
INSERT INTO sanias_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","tadanusārato'nyepi bahavastadvṛttāntaṁ racayituṁ pravṛttāḥ| ");
INSERT INTO sanias_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ataeva he mahāmahimathiyaphil tvaṁ yā yāḥ kathā aśikṣyathāstāsāṁ dṛḍhapramāṇāni yathā prāpnoṣi ");
INSERT INTO sanias_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","tadarthaṁ prathamamārabhya tāni sarvvāṇi jñātvāhamapi anukramāt sarvvavṛttāntān tubhyaṁ lekhituṁ matimakārṣam| ");
INSERT INTO sanias_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","yihūdādeśīyaherodnāmake rājatvaṁ kurvvati abīyayājakasya paryyāyādhikārī sikhariyanāmaka eko yājako hāroṇavaṁśodbhavā ilīśevākhyā ");
INSERT INTO sanias_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","tasya jāyā dvāvimau nirdoṣau prabhoḥ sarvvājñā vyavasthāśca saṁmanya īśvaradṛṣṭau dhārmmikāvāstām| ");
INSERT INTO sanias_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","tayoḥ santāna ekopi nāsīt, yata ilīśevā bandhyā tau dvāveva vṛddhāvabhavatām| ");
INSERT INTO sanias_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","yadā svaparyyānukrameṇa sikhariya īśvāsya samakṣaṁ yājakīyaṁ karmma karoti ");
INSERT INTO sanias_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","tadā yajñasya dinaparipāyyā parameśvarasya mandire praveśakāle dhūpajvālanaṁ karmma tasya karaṇīyamāsīt| ");
INSERT INTO sanias_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","taddhūpajvālanakāle lokanivahe prārthanāṁ kartuṁ bahistiṣṭhati ");
INSERT INTO sanias_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","sati sikhariyo yasyāṁ vedyāṁ dhūpaṁ jvālayati taddakṣiṇapārśve parameśvarasya dūta eka upasthito darśanaṁ dadau| ");
INSERT INTO sanias_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","taṁ dṛṣṭvā sikhariya udvivije śaśaṅke ca| ");
INSERT INTO sanias_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","tadā sa dūtastaṁ babhāṣe he sikhariya mā bhaistava prārthanā grāhyā jātā tava bhāryyā ilīśevā putraṁ prasoṣyate tasya nāma yoेhan iti kariṣyasi| ");
INSERT INTO sanias_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","kiñca tvaṁ sānandaḥ saharṣaśca bhaviṣyasi tasya janmani bahava ānandiṣyanti ca| ");
INSERT INTO sanias_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","yato hetoḥ sa parameśvarasya gocare mahān bhaviṣyati tathā drākṣārasaṁ surāṁ vā kimapi na pāsyati, aparaṁ janmārabhya pavitreṇātmanā paripūrṇaḥ ");
INSERT INTO sanias_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","san isrāyelvaṁśīyān anekān prabhoḥ parameśvarasya mārgamāneṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","santānān prati pitṛṇāṁ manāṁsi dharmmajñānaṁ pratyanājñāgrāhiṇaśca parāvarttayituṁ, prabhoḥ parameśvarasya sevārtham ekāṁ sajjitajātiṁ vidhātuñca sa eliyarūpātmaśaktiprāptastasyāgre gamiṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","tadā sikhariyo dūtamavādīt kathametad vetsyāmi? yatohaṁ vṛddho mama bhāryyā ca vṛddhā| ");
INSERT INTO sanias_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","tato dūtaḥ pratyuvāca paśyeśvarasya sākṣādvarttī jibrāyelnāmā dūtohaṁ tvayā saha kathāṁ gadituṁ tubhyamimāṁ śubhavārttāṁ dātuñca preṣitaḥ| ");
INSERT INTO sanias_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","kintu madīyaṁ vākyaṁ kāle phaliṣyati tat tvayā na pratītam ataḥ kāraṇād yāvadeva tāni na setsyanti tāvat tvaṁ vaktuṁmaśakto mūko bhava| ");
INSERT INTO sanias_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","tadānīṁ ye ye lokāḥ sikhariyamapaikṣanta te madhyemandiraṁ tasya bahuvilambād āścaryyaṁ menire| ");
INSERT INTO sanias_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","sa bahirāgato yadā kimapi vākyaṁ vaktumaśaktaḥ saṅketaṁ kṛtvā niḥśabdastasyau tadā madhyemandiraṁ kasyacid darśanaṁ tena prāptam iti sarvve bubudhire| ");
INSERT INTO sanias_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","anantaraṁ tasya sevanaparyyāye sampūrṇe sati sa nijagehaṁ jagāma| ");
INSERT INTO sanias_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","katipayadineṣu gateṣu tasya bhāryyā ilīśevā garbbhavatī babhūva ");
INSERT INTO sanias_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","paścāt sā pañcamāsān saṁgopyākathayat lokānāṁ samakṣaṁ mamāpamānaṁ khaṇḍayituṁ parameśvaro mayi dṛṣṭiṁ pātayitvā karmmedṛśaṁ kṛtavān| ");
INSERT INTO sanias_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","aparañca tasyā garbbhasya ṣaṣṭhe māse jāte gālīlpradeśīyanāsaratpure ");
INSERT INTO sanias_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","dāyūdo vaṁśīyāya yūṣaphnāmne puruṣāya yā mariyamnāmakumārī vāgdattāsīt tasyāḥ samīpaṁ jibrāyel dūta īśvareṇa prahitaḥ| ");
INSERT INTO sanias_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","sa gatvā jagāda he īśvarānugṛhītakanye tava śubhaṁ bhūyāt prabhuḥ parameśvarastava sahāyosti nārīṇāṁ madhye tvameva dhanyā| ");
INSERT INTO sanias_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","tadānīṁ sā taṁ dṛṣṭvā tasya vākyata udvijya kīdṛśaṁ bhāṣaṇamidam iti manasā cintayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","tato dūto'vadat he mariyam bhayaṁ mākārṣīḥ, tvayi parameśvarasyānugrahosti| ");
INSERT INTO sanias_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","paśya tvaṁ garbbhaṁ dhṛtvā putraṁ prasoṣyase tasya nāma yīśuriti kariṣyasi| ");
INSERT INTO sanias_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","sa mahān bhaviṣyati tathā sarvvebhyaḥ śreṣṭhasya putra iti khyāsyati; aparaṁ prabhuḥ parameśvarastasya piturdāyūdaḥ siṁhāsanaṁ tasmai dāsyati; ");
INSERT INTO sanias_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","tathā sa yākūbo vaṁśopari sarvvadā rājatvaṁ kariṣyati, tasya rājatvasyānto na bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","tadā mariyam taṁ dūtaṁ babhāṣe nāhaṁ puruṣasaṅgaṁ karomi tarhi kathametat sambhaviṣyati? ");
INSERT INTO sanias_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","tato dūto'kathayat pavitra ātmā tvāmāśrāyiṣyati tathā sarvvaśreṣṭhasya śaktistavopari chāyāṁ kariṣyati tato hetostava garbbhād yaḥ pavitrabālako janiṣyate sa īśvaraputra iti khyātiṁ prāpsyati| ");
INSERT INTO sanias_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","aparañca paśya tava jñātirilīśevā yāṁ sarvve bandhyāmavadan idānīṁ sā vārddhakye santānamekaṁ garbbhe'dhārayat tasya ṣaṣṭhamāsobhūt| ");
INSERT INTO sanias_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","kimapi karmma nāsādhyam īśvarasya| ");
INSERT INTO sanias_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","tadā mariyam jagāda, paśya prabherahaṁ dāsī mahyaṁ tava vākyānusāreṇa sarvvametad ghaṭatām; ananataraṁ dūtastasyāḥ samīpāt pratasthe| ");
INSERT INTO sanias_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","atha katipayadināt paraṁ mariyam tasmāt parvvatamayapradeśīyayihūdāyā nagaramekaṁ śīghraṁ gatvā ");
INSERT INTO sanias_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","sikhariyayājakasya gṛhaṁ praviśya tasya jāyām ilīśevāṁ sambodhyāvadat| ");
INSERT INTO sanias_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","tato mariyamaḥ sambodhanavākye ilīśevāyāḥ karṇayoḥ praviṣṭamātre sati tasyā garbbhasthabālako nanartta| tata ilīśevā pavitreṇātmanā paripūrṇā satī ");
INSERT INTO sanias_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","proccairgaditumārebhe, yoṣitāṁ madhye tvameva dhanyā, tava garbbhasthaḥ śiśuśca dhanyaḥ| ");
INSERT INTO sanias_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","tvaṁ prabhormātā, mama niveśane tvayā caraṇāvarpitau, mamādya saubhāgyametat| ");
INSERT INTO sanias_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","paśya tava vākye mama karṇayoḥ praviṣṭamātre sati mamodarasthaḥ śiśurānandān nanartta| ");
INSERT INTO sanias_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","yā strī vyaśvasīt sā dhanyā, yato hetostāṁ prati parameśvaroktaṁ vākyaṁ sarvvaṁ siddhaṁ bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","tadānīṁ mariyam jagāda| dhanyavādaṁ pareśasya karoti māmakaṁ manaḥ| ");
INSERT INTO sanias_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","mamātmā tārakeśe ca samullāsaṁ pragacchati| ");
INSERT INTO sanias_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","akarot sa prabhu rduṣṭiṁ svadāsyā durgatiṁ prati| paśyādyārabhya māṁ dhanyāṁ vakṣyanti puruṣāḥ sadā| ");
INSERT INTO sanias_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","yaḥ sarvvaśaktimān yasya nāmāpi ca pavitrakaṁ| sa eva sumahatkarmma kṛtavān mannimittakaṁ| ");
INSERT INTO sanias_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ye bibhyati janāstasmāt teṣāṁ santānapaṁktiṣu| anukampā tadīyā ca sarvvadaiva sutiṣṭhati| ");
INSERT INTO sanias_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","svabāhubalatastena prākāśyata parākramaḥ| manaḥkumantraṇāsārddhaṁ vikīryyante'bhimāninaḥ| ");
INSERT INTO sanias_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","siṁhāsanagatāllokān balinaścāvarohya saḥ| padeṣūcceṣu lokāṁstu kṣudrān saṁsthāpayatyapi| ");
INSERT INTO sanias_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","kṣudhitān mānavān dravyairuttamaiḥ paritarpya saḥ| sakalān dhanino lokān visṛjed riktahastakān| ");
INSERT INTO sanias_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ibrāhīmi ca tadvaṁśe yā dayāsti sadaiva tāṁ| smṛtvā purā pitṛṇāṁ no yathā sākṣāt pratiśrutaṁ| ");
INSERT INTO sanias_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","isrāyelsevakastena tathopakriyate svayaṁ|| ");
INSERT INTO sanias_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","anantaraṁ mariyam prāyeṇa māsatrayam ilīśevayā sahoṣitvā vyāghuyya nijaniveśanaṁ yayau| ");
INSERT INTO sanias_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","tadanantaram ilīśevāyāḥ prasavakāla upasthite sati sā putraṁ prāsoṣṭa| ");
INSERT INTO sanias_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","tataḥ parameśvarastasyāṁ mahānugrahaṁ kṛtavān etat śrutvā samīpavāsinaḥ kuṭumbāścāgatya tayā saha mumudire| ");
INSERT INTO sanias_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","tathāṣṭame dine te bālakasya tvacaṁ chettum etya tasya pitṛnāmānurūpaṁ tannāma sikhariya iti karttumīṣuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","kintu tasya mātākathayat tanna, nāmāsya yohan iti karttavyam| ");
INSERT INTO sanias_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","tadā te vyāharan tava vaṁśamadhye nāmedṛśaṁ kasyāpi nāsti| ");
INSERT INTO sanias_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","tataḥ paraṁ tasya pitaraṁ sikhariyaṁ prati saṅketya papracchuḥ śiśoḥ kiṁ nāma kāriṣyate? ");
INSERT INTO sanias_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","tataḥ sa phalakamekaṁ yācitvā lilekha tasya nāma yohan bhaviṣyati| tasmāt sarvve āścaryyaṁ menire| ");
INSERT INTO sanias_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","tatkṣaṇaṁ sikhariyasya jihvājāḍye'pagate sa mukhaṁ vyādāya spaṣṭavarṇamuccāryya īśvarasya guṇānuvādaṁ cakāra| ");
INSERT INTO sanias_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","tasmāccaturdiksthāḥ samīpavāsilokā bhītā evametāḥ sarvvāḥ kathā yihūdāyāḥ parvvatamayapradeśasya sarvvatra pracāritāḥ| ");
INSERT INTO sanias_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","tasmāt śrotāro manaḥsu sthāpayitvā kathayāmbabhūvuḥ kīdṛśoyaṁ bālo bhaviṣyati? atha parameśvarastasya sahāyobhūt| ");
INSERT INTO sanias_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","tadā yohanaḥ pitā sikhariyaḥ pavitreṇātmanā paripūrṇaḥ san etādṛśaṁ bhaviṣyadvākyaṁ kathayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","isrāyelaḥ prabhu ryastu sa dhanyaḥ parameśvaraḥ| anugṛhya nijāllokān sa eva parimocayet| ");
INSERT INTO sanias_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","vipakṣajanahastebhyo yathā mocyāmahe vayaṁ| yāvajjīvañca dharmmeṇa sāralyena ca nirbhayāḥ| ");
INSERT INTO sanias_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","sevāmahai tamevaikam etatkāraṇameva ca| svakīyaṁ supavitrañca saṁsmṛtya niyamaṁ sadā| ");
INSERT INTO sanias_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","kṛpayā puruṣān pūrvvān nikaṣārthāttu naḥ pituḥ| ibrāhīmaḥ samīpe yaṁ śapathaṁ kṛtavān purā| ");
INSERT INTO sanias_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","tameva saphalaṁ karttaṁ tathā śatrugaṇasya ca| ṛृtīyākāriṇaścaiva karebhyo rakṣaṇāya naḥ| ");
INSERT INTO sanias_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","sṛṣṭeḥ prathamataḥ svīyaiḥ pavitrai rbhāvivādibhiḥ| ");
INSERT INTO sanias_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","yathoktavān tathā svasya dāyūdaḥ sevakasya tu| ");
INSERT INTO sanias_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","vaṁśe trātāramekaṁ sa samutpāditavān svayam| ");
INSERT INTO sanias_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ato he bālaka tvantu sarvvebhyaḥ śreṣṭha eva yaḥ| tasyaiva bhāvivādīti pravikhyāto bhaviṣyasi| asmākaṁ caraṇān kṣeme mārge cālayituṁ sadā| evaṁ dhvānte'rthato mṛtyośchāyāyāṁ ye tu mānavāḥ| ");
INSERT INTO sanias_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","upaviṣṭāstu tāneva prakāśayitumeva hi| kṛtvā mahānukampāṁ hi yāmeva parameśvaraḥ| ");
INSERT INTO sanias_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ūrdvvāt sūryyamudāyyaivāsmabhyaṁ prādāttu darśanaṁ| tayānukampayā svasya lokānāṁ pāpamocane| ");
INSERT INTO sanias_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","paritrāṇasya tebhyo hi jñānaviśrāṇanāya ca| prabho rmārgaṁ pariṣkarttuṁ tasyāgrāyī bhaviṣyasi|| ");
INSERT INTO sanias_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","atha bālakaḥ śarīreṇa buddhyā ca varddhitumārebhe; aparañca sa isrāyelo vaṁśīyalokānāṁ samīpe yāvanna prakaṭībhūtastāstāvat prāntare nyavasat| ");
INSERT INTO sanias_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","aparañca tasmin kāle rājyasya sarvveṣāṁ lokānāṁ nāmāni lekhayitum agastakaisara ājñāpayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","tadanusāreṇa kurīṇiyanāmani suriyādeśasya śāsake sati nāmalekhanaṁ prārebhe| ");
INSERT INTO sanias_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","ato heto rnāma lekhituṁ sarvve janāḥ svīyaṁ svīyaṁ nagaraṁ jagmuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","tadānīṁ yūṣaph nāma lekhituṁ vāgdattayā svabhāryyayā garbbhavatyā mariyamā saha svayaṁ dāyūdaḥ sajātivaṁśa iti kāraṇād gālīlpradeśasya nāsaratnagarād ");
INSERT INTO sanias_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","yihūdāpradeśasya baitlehamākhyaṁ dāyūdnagaraṁ jagāma| ");
INSERT INTO sanias_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","anyacca tatra sthāne tayostiṣṭhatoḥ sato rmariyamaḥ prasūtikāla upasthite ");
INSERT INTO sanias_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","sā taṁ prathamasutaṁ prāsoṣṭa kintu tasmin vāsagṛhe sthānābhāvād bālakaṁ vastreṇa veṣṭayitvā gośālāyāṁ sthāpayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","anantaraṁ ye kiyanto meṣapālakāḥ svameṣavrajarakṣāyai tatpradeśe sthitvā rajanyāṁ prāntare prahariṇaḥ karmma kurvvanti, ");
INSERT INTO sanias_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","teṣāṁ samīpaṁ parameśvarasya dūta āgatyopatasthau; tadā catuṣpārśve parameśvarasya tejasaḥ prakāśitatvāt te'tiśaśaṅkire| ");
INSERT INTO sanias_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","tadā sa dūta uvāca mā bhaiṣṭa paśyatādya dāyūdaḥ pure yuṣmannimittaṁ trātā prabhuḥ khrīṣṭo'janiṣṭa, ");
INSERT INTO sanias_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","sarvveṣāṁ lokānāṁ mahānandajanakam imaṁ maṅgalavṛttāntaṁ yuṣmān jñāpayāmi| ");
INSERT INTO sanias_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","yūyaṁ (tatsthānaṁ gatvā) vastraveṣṭitaṁ taṁ bālakaṁ gośālāyāṁ śayanaṁ drakṣyatha yuṣmān pratīdaṁ cihnaṁ bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","dūta imāṁ kathāṁ kathitavati tatrākasmāt svargīyāḥ pṛtanā āgatya kathām imāṁ kathayitveśvarasya guṇānanvavādiṣuḥ, yathā, ");
INSERT INTO sanias_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","sarvvordvvasthairīśvarasya mahimā samprakāśyatāṁ| śāntirbhūyāt pṛthivyāstu santoṣaśca narān prati|| ");
INSERT INTO sanias_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","tataḥ paraṁ teṣāṁ sannidhe rdūtagaṇe svargaṁ gate meṣapālakāḥ parasparam avecan āgacchata prabhuḥ parameśvaro yāṁ ghaṭanāṁ jñāpitavān tasyā yātharyaṁ jñātuṁ vayamadhunā baitlehampuraṁ yāmaḥ| ");
INSERT INTO sanias_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","paścāt te tūrṇaṁ vrajitvā mariyamaṁ yūṣaphaṁ gośālāyāṁ śayanaṁ bālakañca dadṛśuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","itthaṁ dṛṣṭvā bālakasyārthe proktāṁ sarvvakathāṁ te prācārayāñcakruḥ| ");
INSERT INTO sanias_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","tato ye lokā meṣarakṣakāṇāṁ vadanebhyastāṁ vārttāṁ śuśruvuste mahāścaryyaṁ menire| ");
INSERT INTO sanias_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","kintu mariyam etatsarvvaghaṭanānāṁ tātparyyaṁ vivicya manasi sthāpayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","tatpaścād dūtavijñaptānurūpaṁ śrutvā dṛṣṭvā ca meṣapālakā īśvarasya guṇānuvādaṁ dhanyavādañca kurvvāṇāḥ parāvṛtya yayuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","atha bālakasya tvakchedanakāle'ṣṭamadivase samupasthite tasya garbbhasthiteḥ purvvaṁ svargīyadūto yathājñāpayat tadanurūpaṁ te tannāmadheyaṁ yīśuriti cakrire| ");
INSERT INTO sanias_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","tataḥ paraṁ mūsālikhitavyavasthāyā anusāreṇa mariyamaḥ śucitvakāla upasthite, ");
INSERT INTO sanias_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","\"prathamajaḥ sarvvaḥ puruṣasantānaḥ parameśvare samarpyatāṁ,\" iti parameśvarasya vyavasthayā ");
INSERT INTO sanias_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","yīśuṁ parameśvare samarpayitum śāstrīyavidhyuktaṁ kapotadvayaṁ pārāvataśāvakadvayaṁ vā baliṁ dātuṁ te taṁ gṛhītvā yirūśālamam āyayuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","yirūśālampuranivāsī śimiyonnāmā dhārmmika eka āsīt sa isrāyelaḥ sāntvanāmapekṣya tasthau kiñca pavitra ātmā tasminnāvirbhūtaḥ| ");
INSERT INTO sanias_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","aparaṁ prabhuṇā parameśvareṇābhiṣikte trātari tvayā na dṛṣṭe tvaṁ na mariṣyasīti vākyaṁ pavitreṇa ātmanā tasma prākathyata| ");
INSERT INTO sanias_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","aparañca yadā yīśoḥ pitā mātā ca tadarthaṁ vyavasthānurūpaṁ karmma karttuṁ taṁ mandiram āninyatustadā ");
INSERT INTO sanias_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","śimiyon ātmana ākarṣaṇena mandiramāgatya taṁ kroḍe nidhāya īśvarasya dhanyavādaṁ kṛtvā kathayāmāsa, yathā, ");
INSERT INTO sanias_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","he prabho tava dāsoyaṁ nijavākyānusārataḥ| idānīntu sakalyāṇo bhavatā saṁvisṛjyatām| ");
INSERT INTO sanias_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","yataḥ sakaladeśasya dīptaye dīptirūpakaṁ| ");
INSERT INTO sanias_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","isrāyelīyalokasya mahāgauravarūpakaṁ| ");
INSERT INTO sanias_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","yaṁ trāyakaṁ janānāntu sammukhe tvamajījanaḥ| saeva vidyate'smākaṁ dhravaṁ nayananagocare|| ");
INSERT INTO sanias_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","tadānīṁ tenoktā etāḥ sakalāḥ kathāḥ śrutvā tasya mātā yūṣaph ca vismayaṁ menāte| ");
INSERT INTO sanias_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","tataḥ paraṁ śimiyon tebhya āśiṣaṁ dattvā tanmātaraṁ mariyamam uvāca, paśya isrāyelo vaṁśamadhye bahūnāṁ pātanāyotthāpanāya ca tathā virodhapātraṁ bhavituṁ, bahūnāṁ guptamanogatānāṁ prakaṭīkaraṇāya bālakoyaṁ niyuktosti| ");
INSERT INTO sanias_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","tasmāt tavāpi prāṇāḥ śūlena vyatsyante| ");
INSERT INTO sanias_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","aparañca āśerasya vaṁśīyaphinūyelo duhitā hannākhyā atijaratī bhaviṣyadvādinyekā yā vivāhāt paraṁ sapta vatsarān patyā saha nyavasat tato vidhavā bhūtvā caturaśītivarṣavayaḥparyyanataṁ ");
INSERT INTO sanias_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","mandire sthitvā prārthanopavāsairdivāniśam īśvaram asevata sāpi strī tasmin samaye mandiramāgatya ");
INSERT INTO sanias_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","parameśvarasya dhanyavādaṁ cakāra, yirūśālampuravāsino yāvanto lokā muktimapekṣya sthitāstān yīśorvṛttāntaṁ jñāpayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","itthaṁ parameśvarasya vyavasthānusāreṇa sarvveṣu karmmasu kṛteṣu tau punaśca gālīlo nāsaratnāmakaṁ nijanagaraṁ pratasthāte| ");
INSERT INTO sanias_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","tatpaścād bālakaḥ śarīreṇa vṛddhimetya jñānena paripūrṇa ātmanā śaktimāṁśca bhavitumārebhe tathā tasmin īśvarānugraho babhūva| ");
INSERT INTO sanias_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","tasya pitā mātā ca prativarṣaṁ nistārotsavasamaye yirūśālamam agacchatām| ");
INSERT INTO sanias_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","aparañca yīśau dvādaśavarṣavayaske sati tau parvvasamayasya rītyanusāreṇa yirūśālamaṁ gatvā ");
INSERT INTO sanias_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","pārvvaṇaṁ sampādya punarapi vyāghuyya yātaḥ kintu yīśurbālako yirūśālami tiṣṭhati| yūṣaph tanmātā ca tad aviditvā ");
INSERT INTO sanias_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","sa saṅgibhiḥ saha vidyata etacca budvvā dinaikagamyamārgaṁ jagmatuḥ| kintu śeṣe jñātibandhūnāṁ samīpe mṛgayitvā taduddeेśamaprāpya ");
INSERT INTO sanias_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","tau punarapi yirūśālamam parāvṛtyāgatya taṁ mṛgayāñcakratuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","atha dinatrayāt paraṁ paṇḍitānāṁ madhye teṣāṁ kathāḥ śṛṇvan tattvaṁ pṛcchaṁśca mandire samupaviṣṭaḥ sa tābhyāṁ dṛṣṭaḥ| ");
INSERT INTO sanias_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","tadā tasya buddhyā pratyuttaraiśca sarvve śrotāro vismayamāpadyante| ");
INSERT INTO sanias_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","tādṛśaṁ dṛṣṭvā tasya janako jananī ca camaccakratuḥ kiñca tasya mātā tamavadat, he putra, kathamāvāṁ pratītthaṁ samācarastvam? paśya tava pitāhañca śokākulau santau tvāmanvicchāvaḥ sma| ");
INSERT INTO sanias_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","tataḥ sovadat kuto mām anvaicchataṁ? piturgṛhe mayā sthātavyam etat kiṁ yuvābhyāṁ na jñāyate? ");
INSERT INTO sanias_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","kintu tau tasyaitadvākyasya tātparyyaṁ boddhuṁ nāśaknutāṁ| ");
INSERT INTO sanias_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","tataḥ paraṁ sa tābhyāṁ saha nāsarataṁ gatvā tayorvaśībhūtastasthau kintu sarvvā etāḥ kathāstasya mātā manasi sthāpayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","atha yīśo rbuddhiḥ śarīrañca tathā tasmin īśvarasya mānavānāñcānugraho varddhitum ārebhe| ");
INSERT INTO sanias_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","anantaraṁ tibiriyakaisarasya rājatvasya pañcadaśe vatsare sati yadā pantīyapīlāto yihūdādeśādhipati rherod tu gālīlpradeśasya rājā philipanāmā tasya bhrātā tu yitūriyāyāstrākhonītiyāpradeśasya ca rājāsīt luṣānīyanāmā avilīnīdeśasya rājāsīt ");
INSERT INTO sanias_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","hānan kiyaphāścemau pradhānayājākāvāstāṁ tadānīṁ sikhariyasya putrāya yohane madhyeprāntaram īśvarasya vākye prakāśite sati ");
INSERT INTO sanias_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","sa yarddana ubhayataṭapradeśān sametya pāpamocanārthaṁ manaḥparāvarttanasya cihnarūpaṁ yanmajjanaṁ tadīyāḥ kathāḥ sarvvatra pracārayitumārebhe| ");
INSERT INTO sanias_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","yiśayiyabhaviṣyadvaktṛgranthe yādṛśī lipirāste yathā, parameśasya panthānaṁ pariṣkuruta sarvvataḥ| tasya rājapathañcaiva samānaṁ kurutādhunā| ");
INSERT INTO sanias_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","kāriṣyante samucchrāyāḥ sakalā nimnabhūmayaḥ| kāriṣyante natāḥ sarvve parvvatāścopaparvvatāḥ| kāriṣyante ca yā vakrāstāḥ sarvvāḥ saralā bhuvaḥ| kāriṣyante samānāstā yā uccanīcabhūmayaḥ| ");
INSERT INTO sanias_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","īśvareṇa kṛtaṁ trāṇaṁ drakṣyanti sarvvamānavāḥ| ityetat prāntare vākyaṁ vadataḥ kasyacid ravaḥ|| ");
INSERT INTO sanias_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ye ye lokā majjanārthaṁ bahirāyayustān sovadat re re sarpavaṁśā āgāminaḥ kopāt palāyituṁ yuṣmān kaścetayāmāsa? ");
INSERT INTO sanias_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","tasmād ibrāhīm asmākaṁ pitā kathāmīdṛśīṁ manobhi rna kathayitvā yūyaṁ manaḥparivarttanayogyaṁ phalaṁ phalata; yuṣmānahaṁ yathārthaṁ vadāmi pāṣāṇebhya etebhya īśvara ibrāhīmaḥ santānotpādane samarthaḥ| ");
INSERT INTO sanias_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","aparañca tarumūle'dhunāpi paraśuḥ saṁlagnosti yastaruruttamaṁ phalaṁ na phalati sa chidyate'gnau nikṣipyate ca| ");
INSERT INTO sanias_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","tadānīṁ lokāstaṁ papracchustarhi kiṁ karttavyamasmābhiḥ? ");
INSERT INTO sanias_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","tataḥ sovādīt yasya dve vasane vidyete sa vastrahīnāyaikaṁ vitaratu kiṁñca yasya khādyadravyaṁ vidyate sopi tathaiva karotu| ");
INSERT INTO sanias_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","tataḥ paraṁ karasañcāyino majjanārtham āgatya papracchuḥ he guro kiṁ karttavyamasmābhiḥ? ");
INSERT INTO sanias_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","tataḥ sokathayat nirūpitādadhikaṁ na gṛhlita| ");
INSERT INTO sanias_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","anantaraṁ senāgaṇa etya papraccha kimasmābhi rvā karttavyam? tataḥ sobhidadhe kasya kāmapi hāniṁ mā kārṣṭa tathā mṛṣāpavādaṁ mā kuruta nijavetanena ca santuṣya tiṣṭhata| ");
INSERT INTO sanias_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","aparañca lokā apekṣayā sthitvā sarvvepīti manobhi rvitarkayāñcakruḥ, yohanayam abhiṣiktastrātā na veti? ");
INSERT INTO sanias_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","tadā yohan sarvvān vyājahāra, jale'haṁ yuṣmān majjayāmi satyaṁ kintu yasya pādukābandhanaṁ mocayitumapi na yogyosmi tādṛśa eko matto gurutaraḥ pumān eti, sa yuṣmān vahnirūpe pavitra ātmani majjayiṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","aparañca tasya haste śūrpa āste sa svaśasyāni śuddharūpaṁ prasphoṭya godhūmān sarvvān bhāṇḍāgāre saṁgrahīṣyati kintu būṣāṇi sarvvāṇyanirvvāṇavahninā dāhayiṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","yohan upadeśenetthaṁ nānākathā lokānāṁ samakṣaṁ pracārayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","aparañca herod rājā philipnāmnaḥ sahodarasya bhāryyāṁ herodiyāmadhi tathānyāni yāni yāni kukarmmāṇi kṛtavān tadadhi ca ");
INSERT INTO sanias_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","yohanā tiraskṛto bhūtvā kārāgāre tasya bandhanād aparamapi kukarmma cakāra| ");
INSERT INTO sanias_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","itaḥ pūrvvaṁ yasmin samaye sarvve yohanā majjitāstadānīṁ yīśurapyāgatya majjitaḥ| ");
INSERT INTO sanias_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","tadanantaraṁ tena prārthite meghadvāraṁ muktaṁ tasmācca pavitra ātmā mūrttimān bhūtvā kapotavat taduparyyavaruroha; tadā tvaṁ mama priyaḥ putrastvayi mama paramaḥ santoṣa ityākāśavāṇī babhūva| ");
INSERT INTO sanias_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","tadānīṁ yīśuḥ prāyeṇa triṁśadvarṣavayaska āsīt| laukikajñāne tu sa yūṣaphaḥ putraḥ, ");
INSERT INTO sanias_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","yūṣaph eleḥ putraḥ, elirmattataḥ putraḥ, mattat leveḥ putraḥ, levi rmalkeḥ putraḥ, malkiryānnasya putraḥ; yānno yūṣaphaḥ putraḥ| ");
INSERT INTO sanias_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","yūṣaph mattathiyasya putraḥ, mattathiya āmosaḥ putraḥ, āmos nahūmaḥ putraḥ, nahūm iṣleḥ putraḥ iṣlirnageḥ putraḥ| ");
INSERT INTO sanias_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","nagirmāṭaḥ putraḥ, māṭ mattathiyasya putraḥ, mattathiyaḥ śimiyeḥ putraḥ, śimiyiryūṣaphaḥ putraḥ, yūṣaph yihūdāḥ putraḥ| ");
INSERT INTO sanias_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","yihūdā yohānāḥ putraḥ, yohānā rīṣāḥ putraḥ, rīṣāḥ sirubbābilaḥ putraḥ, sirubbābil śaltīyelaḥ putraḥ, śaltīyel nereḥ putraḥ| ");
INSERT INTO sanias_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","nerirmalkeḥ putraḥ, malkiḥ adyaḥ putraḥ, addī koṣamaḥ putraḥ, koṣam ilmodadaḥ putraḥ, ilmodad eraḥ putraḥ| ");
INSERT INTO sanias_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","er yośeḥ putraḥ, yośiḥ ilīyeṣaraḥ putraḥ, ilīyeṣar yorīmaḥ putraḥ, yorīm mattataḥ putraḥ, mattata leveḥ putraḥ| ");
INSERT INTO sanias_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","leviḥ śimiyonaḥ putraḥ, śimiyon yihūdāḥ putraḥ, yihūdā yūṣuphaḥ putraḥ, yūṣuph yonanaḥ putraḥ, yānan ilīyākīmaḥ putraḥ| ");
INSERT INTO sanias_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","iliyākīmḥ mileyāḥ putraḥ, mileyā mainanaḥ putraḥ, mainan mattattasya putraḥ, mattatto nāthanaḥ putraḥ, nāthan dāyūdaḥ putraḥ| ");
INSERT INTO sanias_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","dāyūd yiśayaḥ putraḥ, yiśaya obedaḥ putra, obed boyasaḥ putraḥ, boyas salmonaḥ putraḥ, salmon nahaśonaḥ putraḥ| ");
INSERT INTO sanias_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","nahaśon ammīnādabaḥ putraḥ, ammīnādab arāmaḥ putraḥ, arām hiṣroṇaḥ putraḥ, hiṣroṇ perasaḥ putraḥ, peras yihūdāḥ putraḥ| ");
INSERT INTO sanias_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","yihūdā yākūbaḥ putraḥ, yākūb ishākaḥ putraḥ, ishāk ibrāhīmaḥ putraḥ, ibrāhīm terahaḥ putraḥ, terah nāhoraḥ putraḥ| ");
INSERT INTO sanias_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","nāhor sirugaḥ putraḥ, sirug riyvaḥ putraḥ, riyūḥ pelagaḥ putraḥ, pelag evaraḥ putraḥ, evar śelahaḥ putraḥ| ");
INSERT INTO sanias_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","śelah kainanaḥ putraḥ, kainan arphakṣadaḥ putraḥ, arphakṣad śāmaḥ putraḥ, śām nohaḥ putraḥ, noho lemakaḥ putraḥ| ");
INSERT INTO sanias_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","lemak mithūśelahaḥ putraḥ, mithūśelah hanokaḥ putraḥ, hanok yeradaḥ putraḥ, yerad mahalalelaḥ putraḥ, mahalalel kainanaḥ putraḥ| ");
INSERT INTO sanias_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","kainan inośaḥ putraḥ, inoś śetaḥ putraḥ, śet ādamaḥ putra, ādam īśvarasya putraḥ| ");
INSERT INTO sanias_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","tataḥ paraṁ yīśuḥ pavitreṇātmanā pūrṇaḥ san yarddananadyāḥ parāvṛtyātmanā prāntaraṁ nītaḥ san catvāriṁśaddināni yāvat śaitānā parīkṣito'bhūt, ");
INSERT INTO sanias_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","kiñca tāni sarvvadināni bhojanaṁ vinā sthitatvāt kāle pūrṇe sa kṣudhitavān| ");
INSERT INTO sanias_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","tataḥ śaitānāgatya tamavadat tvaṁ cedīśvarasya putrastarhi prastarānetān ājñayā pūpān kuru| ");
INSERT INTO sanias_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","tadā yīśuruvāca, lipirīdṛśī vidyate manujaḥ kevalena pūpena na jīvati kintvīśvarasya sarvvābhirājñābhi rjīvati| ");
INSERT INTO sanias_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","tadā śaitān tamuccaṁ parvvataṁ nītvā nimiṣaikamadhye jagataḥ sarvvarājyāni darśitavān| ");
INSERT INTO sanias_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","paścāt tamavādīt sarvvam etad vibhavaṁ pratāpañca tubhyaṁ dāsyāmi tan mayi samarpitamāste yaṁ prati mamecchā jāyate tasmai dātuṁ śaknomi, ");
INSERT INTO sanias_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","tvaṁ cenmāṁ bhajase tarhi sarvvametat tavaiva bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","tadā yīśustaṁ pratyuktavān dūrī bhava śaitān lipirāste, nijaṁ prabhuṁ parameśvaraṁ bhajasva kevalaṁ tameva sevasva ca| ");
INSERT INTO sanias_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","atha śaitān taṁ yirūśālamaṁ nītvā mandirasya cūḍāyā upari samupaveśya jagāda tvaṁ cedīśvarasya putrastarhi sthānādito lamphitvādhaḥ ");
INSERT INTO sanias_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","pata yato lipirāste, ājñāpayiṣyati svīyān dūtān sa parameśvaraḥ| ");
INSERT INTO sanias_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","rakṣituṁ sarvvamārge tvāṁ tena tvaccaraṇe yathā| na laget prastarāghātastvāṁ dhariṣyanti te tathā| ");
INSERT INTO sanias_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","tadā yīśunā pratyuktam idamapyuktamasti tvaṁ svaprabhuṁ pareśaṁ mā parīkṣasva| ");
INSERT INTO sanias_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","paścāt śaitān sarvvaparīkṣāṁ samāpya kṣaṇāttaṁ tyaktvā yayau| ");
INSERT INTO sanias_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","tadā yīśurātmaprabhāvāt punargālīlpradeśaṁ gatastadā tatsukhyātiścaturdiśaṁ vyānaśe| ");
INSERT INTO sanias_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","sa teṣāṁ bhajanagṛheṣu upadiśya sarvvaiḥ praśaṁsito babhūva| ");
INSERT INTO sanias_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","atha sa svapālanasthānaṁ nāsaratpurametya viśrāmavāre svācārād bhajanagehaṁ praviśya paṭhitumuttasthau| ");
INSERT INTO sanias_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","tato yiśayiyabhaviṣyadvādinaḥ pustake tasya karadatte sati sa tat pustakaṁ vistāryya yatra vakṣyamāṇāni vacanāni santi tat sthānaṁ prāpya papāṭha| ");
INSERT INTO sanias_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","ātmā tu parameśasya madīyopari vidyate| daridreṣu susaṁvādaṁ vaktuṁ māṁ sobhiṣiktavān| bhagnāntaḥ karaṇāllokān susvasthān karttumeva ca| bandīkṛteṣu lokeṣu mukte rghoṣayituṁ vacaḥ| netrāṇi dātumandhebhyastrātuṁ baddhajanānapi| ");
INSERT INTO sanias_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","pareśānugrahe kālaṁ pracārayitumeva ca| sarvvaitatkaraṇārthāya māmeva prahiṇoti saḥ|| ");
INSERT INTO sanias_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","tataḥ pustakaṁ badvvā paricārakasya haste samarpya cāsane samupaviṣṭaḥ, tato bhajanagṛhe yāvanto lokā āsan te sarvve'nanyadṛṣṭyā taṁ vilulokire| ");
INSERT INTO sanias_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","anantaram adyaitāni sarvvāṇi likhitavacanāni yuṣmākaṁ madhye siddhāni sa imāṁ kathāṁ tebhyaḥ kathayitumārebhe| ");
INSERT INTO sanias_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","tataḥ sarvve tasmin anvarajyanta, kiñca tasya mukhānnirgatābhiranugrahasya kathābhiścamatkṛtya kathayāmāsuḥ kimayaṁ yūṣaphaḥ putro na? ");
INSERT INTO sanias_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","tadā so'vādīd he cikitsaka svameva svasthaṁ kuru kapharnāhūmi yadyat kṛtavān tadaśrauṣma tāḥ sarvāḥ kriyā atra svadeśe kuru kathāmetāṁ yūyamevāvaśyaṁ māṁ vadiṣyatha| ");
INSERT INTO sanias_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","punaḥ sovādīd yuṣmānahaṁ yathārthaṁ vadāmi, kopi bhaviṣyadvādī svadeśe satkāraṁ na prāpnoti| ");
INSERT INTO sanias_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","aparañca yathārthaṁ vacmi, eliyasya jīvanakāle yadā sārddhatritayavarṣāṇi yāvat jaladapratibandhāt sarvvasmin deśe mahādurbhikṣam ajaniṣṭa tadānīm isrāyelo deśasya madhye bahvyo vidhavā āsan, ");
INSERT INTO sanias_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","kintu sīdonpradeśīyasāriphatpuranivāsinīm ekāṁ vidhavāṁ vinā kasyāścidapi samīpe eliyaḥ prerito nābhūt| ");
INSERT INTO sanias_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","aparañca ilīśāyabhaviṣyadvādividyamānatākāle isrāyeldeśe bahavaḥ kuṣṭhina āsan kintu surīyadeśīyaṁ nāmānkuṣṭhinaṁ vinā kopyanyaḥ pariṣkṛto nābhūt| ");
INSERT INTO sanias_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","imāṁ kathāṁ śrutvā bhajanagehasthitā lokāḥ sakrodham utthāya ");
INSERT INTO sanias_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","nagarāttaṁ bahiṣkṛtya yasya śikhariṇa upari teṣāṁ nagaraṁ sthāpitamāste tasmānnikṣeptuṁ tasya śikharaṁ taṁ ninyuḥ ");
INSERT INTO sanias_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","kintu sa teṣāṁ madhyādapasṛtya sthānāntaraṁ jagāma| ");
INSERT INTO sanias_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","tataḥ paraṁ yīśurgālīlpradeśīyakapharnāhūmnagara upasthāya viśrāmavāre lokānupadeṣṭum ārabdhavān| ");
INSERT INTO sanias_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","tadupadeśāt sarvve camaccakru ryatastasya kathā gurutarā āsan| ");
INSERT INTO sanias_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","tadānīṁ tadbhajanagehasthito'medhyabhūtagrasta eko jana uccaiḥ kathayāmāsa, ");
INSERT INTO sanias_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","he nāsaratīyayīśo'smān tyaja, tvayā sahāsmākaṁ kaḥ sambandhaḥ? kimasmān vināśayitumāyāsi? tvamīśvarasya pavitro jana etadahaṁ jānāmi| ");
INSERT INTO sanias_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","tadā yīśustaṁ tarjayitvāvadat maunī bhava ito bahirbhava; tataḥ somedhyabhūtastaṁ madhyasthāne pātayitvā kiñcidapyahiṁsitvā tasmād bahirgatavān| ");
INSERT INTO sanias_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","tataḥ sarvve lokāścamatkṛtya parasparaṁ vaktumārebhire koyaṁ camatkāraḥ| eṣa prabhāveṇa parākrameṇa cāmedhyabhūtān ājñāpayati tenaiva te bahirgacchanti| ");
INSERT INTO sanias_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","anantaraṁ caturdiksthadeśān tasya sukhyātirvyāpnot| ");
INSERT INTO sanias_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","tadanantaraṁ sa bhajanagehād bahirāgatya śimono niveśanaṁ praviveśa tadā tasya śvaśrūrjvareṇātyantaṁ pīḍitāsīt śiṣyāstadarthaṁ tasmin vinayaṁ cakruḥ| ");
INSERT INTO sanias_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","tataḥ sa tasyāḥ samīpe sthitvā jvaraṁ tarjayāmāsa tenaiva tāṁ jvaro'tyākṣīt tataḥ sā tatkṣaṇam utthāya tān siṣeve| ");
INSERT INTO sanias_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","atha sūryyāstakāle sveṣāṁ ye ye janā nānārogaiḥ pīḍitā āsan lokāstān yīśoḥ samīpam āninyuḥ, tadā sa ekaikasya gātre karamarpayitvā tānarogān cakāra| ");
INSERT INTO sanias_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","tato bhūtā bahubhyo nirgatya cītśabdaṁ kṛtvā ca babhāṣire tvamīśvarasya putro'bhiṣiktatrātā; kintu sobhiṣiktatrāteti te vividuretasmāt kāraṇāt tān tarjayitvā tadvaktuṁ niṣiṣedha| ");
INSERT INTO sanias_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","aparañca prabhāte sati sa vijanasthānaṁ pratasthe paścāt janāstamanvicchantastannikaṭaṁ gatvā sthānāntaragamanārthaṁ tamanvarundhan| ");
INSERT INTO sanias_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","kintu sa tān jagāda, īśvarīyarājyasya susaṁvādaṁ pracārayitum anyāni purāṇyapi mayā yātavyāni yatastadarthameva preritohaṁ| ");
INSERT INTO sanias_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","atha gālīlo bhajanageheṣu sa upadideśa| ");
INSERT INTO sanias_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","anantaraṁ yīśurekadā gineṣarathdasya tīra uttiṣṭhati, tadā lokā īśvarīyakathāṁ śrotuṁ tadupari prapatitāḥ| ");
INSERT INTO sanias_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","tadānīṁ sa hdasya tīrasamīpe naudvayaṁ dadarśa kiñca matsyopajīvino nāvaṁ vihāya jālaṁ prakṣālayanti| ");
INSERT INTO sanias_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","tatastayordvayo rmadhye śimono nāvamāruhya tīrāt kiñciddūraṁ yātuṁ tasmin vinayaṁ kṛtvā naukāyāmupaviśya lokān propadiṣṭavān| ");
INSERT INTO sanias_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","paścāt taṁ prastāvaṁ samāpya sa śimonaṁ vyājahāra, gabhīraṁ jalaṁ gatvā matsyān dharttuṁ jālaṁ nikṣipa| ");
INSERT INTO sanias_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","tataḥ śimona babhāṣe, he guro yadyapi vayaṁ kṛtsnāṁ yāminīṁ pariśramya matsyaikamapi na prāptāstathāpi bhavato nideśato jālaṁ kṣipāmaḥ| ");
INSERT INTO sanias_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","atha jāle kṣipte bahumatsyapatanād ānāyaḥ pracchinnaḥ| ");
INSERT INTO sanias_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","tasmād upakarttum anyanausthān saṅgina āyātum iṅgitena samāhvayan tatasta āgatya matsyai rnaudvayaṁ prapūrayāmāsu ryai rnaudvayaṁ pramagnam| ");
INSERT INTO sanias_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","tadā śimonpitarastad vilokya yīśoścaraṇayoḥ patitvā, he prabhohaṁ pāpī naro mama nikaṭād bhavān yātu, iti kathitavān| ");
INSERT INTO sanias_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","yato jāle patitānāṁ matsyānāṁ yūthāt śimon tatsaṅginaśca camatkṛtavantaḥ; śimonaḥ sahakāriṇau sivadeḥ putrau yākūb yohan cemau tādṛśau babhūvatuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","tadā yīśuḥ śimonaṁ jagāda mā bhaiṣīradyārabhya tvaṁ manuṣyadharo bhaviṣyasi| ");
INSERT INTO sanias_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","anantaraṁ sarvvāsu nausu tīram ānītāsu te sarvvān parityajya tasya paścādgāmino babhūvuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","tataḥ paraṁ yīśau kasmiṁścit pure tiṣṭhati jana ekaḥ sarvvāṅgakuṣṭhastaṁ vilokya tasya samīpe nyubjaḥ patitvā savinayaṁ vaktumārebhe, he prabho yadi bhavānicchati tarhi māṁ pariṣkarttuṁ śaknoti| ");
INSERT INTO sanias_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","tadānīṁ sa pāṇiṁ prasāryya tadaṅgaṁ spṛśan babhāṣe tvaṁ pariṣkriyasveti mamecchāsti tatastatkṣaṇaṁ sa kuṣṭhāt muktaḥ| ");
INSERT INTO sanias_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","paścāt sa tamājñāpayāmāsa kathāmimāṁ kasmaicid akathayitvā yājakasya samīpañca gatvā svaṁ darśaya, lokebhyo nijapariṣkṛtatvasya pramāṇadānāya mūsājñānusāreṇa dravyamutmṛjasva ca| ");
INSERT INTO sanias_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","tathāpi yīśoḥ sukhyāti rbahu vyāptumārebhe kiñca tasya kathāṁ śrotuṁ svīyarogebhyo moktuñca lokā ājagmuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","atha sa prāntaraṁ gatvā prārthayāñcakre| ");
INSERT INTO sanias_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","aparañca ekadā yīśurupadiśati, etarhi gālīlyihūdāpradeśayoḥ sarvvanagarebhyo yirūśālamaśca kiyantaḥ phirūśilokā vyavasthāpakāśca samāgatya tadantike samupaviviśuḥ, tasmin kāle lokānāmārogyakāraṇāt prabhoḥ prabhāvaḥ pracakāśe| ");
INSERT INTO sanias_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","paścāt kiyanto lokā ekaṁ pakṣāghātinaṁ khaṭvāyāṁ nidhāya yīśoḥ samīpamānetuṁ sammukhe sthāpayituñca vyāpriyanta| ");
INSERT INTO sanias_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","kintu bahujananivahasamvādhāt na śaknuvanto gṛhopari gatvā gṛhapṛṣṭhaṁ khanitvā taṁ pakṣāghātinaṁ sakhaṭvaṁ gṛhamadhye yīśoḥ sammukhe 'varohayāmāsuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","tadā yīśusteṣām īdṛśaṁ viśvāsaṁ vilokya taṁ pakṣāghātinaṁ vyājahāra, he mānava tava pāpamakṣamyata| ");
INSERT INTO sanias_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","tasmād adhyāpakāḥ phirūśinaśca cittairitthaṁ pracintitavantaḥ, eṣa jana īśvaraṁ nindati koyaṁ? kevalamīśvaraṁ vinā pāpaṁ kṣantuṁ kaḥ śaknoti? ");
INSERT INTO sanias_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","tadā yīśusteṣām itthaṁ cintanaṁ viditvā tebhyokathayad yūyaṁ manobhiḥ kuto vitarkayatha? ");
INSERT INTO sanias_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","tava pāpakṣamā jātā yadvā tvamutthāya vraja etayo rmadhye kā kathā sukathyā? ");
INSERT INTO sanias_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","kintu pṛthivyāṁ pāpaṁ kṣantuṁ mānavasutasya sāmarthyamastīti yathā yūyaṁ jñātuṁ śaknutha tadarthaṁ (sa taṁ pakṣāghātinaṁ jagāda) uttiṣṭha svaśayyāṁ gṛhītvā gṛhaṁ yāhīti tvāmādiśāmi| ");
INSERT INTO sanias_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","tasmāt sa tatkṣaṇam utthāya sarvveṣāṁ sākṣāt nijaśayanīyaṁ gṛhītvā īśvaraṁ dhanyaṁ vadan nijaniveśanaṁ yayau| ");
INSERT INTO sanias_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","tasmāt sarvve vismaya prāptā manaḥsu bhītāśca vayamadyāsambhavakāryyāṇyadarśāma ityuktvā parameśvaraṁ dhanyaṁ proditāḥ| ");
INSERT INTO sanias_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","tataḥ paraṁ bahirgacchan karasañcayasthāne levināmānaṁ karasañcāyakaṁ dṛṣṭvā yīśustamabhidadhe mama paścādehi| ");
INSERT INTO sanias_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","tasmāt sa tatkṣaṇāt sarvvaṁ parityajya tasya paścādiyāya| ");
INSERT INTO sanias_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","anantaraṁ levi rnijagṛhe tadarthaṁ mahābhojyaṁ cakāra, tadā taiḥ sahāneke karasañcāyinastadanyalokāśca bhoktumupaviviśuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","tasmāt kāraṇāt caṇḍālānāṁ pāpilokānāñca saṅge yūyaṁ kuto bhaṁgdhve pivatha ceti kathāṁ kathayitvā phirūśino'dhyāpakāśca tasya śiṣyaiḥ saha vāgyuddhaṁ karttumārebhire| ");
INSERT INTO sanias_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","tasmād yīśustān pratyavocad arogalokānāṁ cikitsakena prayojanaṁ nāsti kintu sarogāṇāmeva| ");
INSERT INTO sanias_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ahaṁ dhārmmikān āhvātuṁ nāgatosmi kintu manaḥ parāvarttayituṁ pāpina eva| ");
INSERT INTO sanias_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","tataste procuḥ, yohanaḥ phirūśināñca śiṣyā vāraṁvāram upavasanti prārthayante ca kintu tava śiṣyāḥ kuto bhuñjate pivanti ca? ");
INSERT INTO sanias_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","tadā sa tānācakhyau vare saṅge tiṣṭhati varasya sakhigaṇaṁ kimupavāsayituṁ śaknutha? ");
INSERT INTO sanias_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","kintu yadā teṣāṁ nikaṭād varo neṣyate tadā te samupavatsyanti| ");
INSERT INTO sanias_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","soparamapi dṛṣṭāntaṁ kathayāmbabhūva purātanavastre kopi nutanavastraṁ na sīvyati yatastena sevanena jīrṇavastraṁ chidyate, nūtanapurātanavastrayo rmelañca na bhavati| ");
INSERT INTO sanias_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","purātanyāṁ kutvāṁ kopi nutanaṁ drākṣārasaṁ na nidadhāti, yato navīnadrākṣārasasya tejasā purātanī kutū rvidīryyate tato drākṣārasaḥ patati kutūśca naśyati| ");
INSERT INTO sanias_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","tato heto rnūtanyāṁ kutvāṁ navīnadrākṣārasaḥ nidhātavyastenobhayasya rakṣā bhavati| ");
INSERT INTO sanias_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","aparañca purātanaṁ drākṣārasaṁ pītvā kopi nūtanaṁ na vāñchati, yataḥ sa vakti nūtanāt purātanam praśastam| ");
INSERT INTO sanias_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","acarañca parvvaṇo dvitīyadināt paraṁ prathamaviśrāmavāre śasyakṣetreṇa yīśorgamanakāle tasya śiṣyāḥ kaṇiśaṁ chittvā kareṣu marddayitvā khāditumārebhire| ");
INSERT INTO sanias_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","tasmāt kiyantaḥ phirūśinastānavadan viśrāmavāre yat karmma na karttavyaṁ tat kutaḥ kurutha? ");
INSERT INTO sanias_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","yīśuḥ pratyuvāca dāyūd tasya saṅginaśca kṣudhārttāḥ kiṁ cakruḥ sa katham īśvarasya mandiraṁ praviśya ");
INSERT INTO sanias_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ye darśanīyāḥ pūpā yājakān vinānyasya kasyāpyabhojanīyāstānānīya svayaṁ bubhaje saṅgibhyopi dadau tat kiṁ yuṣmābhiḥ kadāpi nāpāṭhi? ");
INSERT INTO sanias_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","paścāt sa tānavadat manujasuto viśrāmavārasyāpi prabhu rbhavati| ");
INSERT INTO sanias_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","anantaram anyaviśrāmavāre sa bhajanagehaṁ praviśya samupadiśati| tadā tatsthāne śuṣkadakṣiṇakara ekaḥ pumān upatasthivān| ");
INSERT INTO sanias_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","tasmād adhyāpakāḥ phirūśinaśca tasmin doṣamāropayituṁ sa viśrāmavāre tasya svāsthyaṁ karoti naveti pratīkṣitumārebhire| ");
INSERT INTO sanias_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","tadā yīśusteṣāṁ cintāṁ viditvā taṁ śuṣkakaraṁ pumāṁsaṁ provāca, tvamutthāya madhyasthāne tiṣṭha| ");
INSERT INTO sanias_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","tasmāt tasmin utthitavati yīśustān vyājahāra, yuṣmān imāṁ kathāṁ pṛcchāmi, viśrāmavāre hitam ahitaṁ vā, prāṇarakṣaṇaṁ prāṇanāśanaṁ vā, eteṣāṁ kiṁ karmmakaraṇīyam? ");
INSERT INTO sanias_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","paścāt caturdikṣu sarvvān vilokya taṁ mānavaṁ babhāṣe, nijakaraṁ prasāraya; tatastena tathā kṛta itarakaravat tasya hastaḥ svasthobhavat| ");
INSERT INTO sanias_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","tasmāt te pracaṇḍakopānvitā yīśuṁ kiṁ kariṣyantīti parasparaṁ pramantritāḥ| ");
INSERT INTO sanias_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","tataḥ paraṁ sa parvvatamāruhyeśvaramuddiśya prārthayamānaḥ kṛtsnāṁ rātriṁ yāpitavān| ");
INSERT INTO sanias_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","atha dine sati sa sarvvān śiṣyān āhūtavān teṣāṁ madhye ");
INSERT INTO sanias_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","pitaranāmnā khyātaḥ śimon tasya bhrātā āndriyaśca yākūb yohan ca philip barthalamayaśca ");
INSERT INTO sanias_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","mathiḥ thomā ālphīyasya putro yākūb jvalantanāmnā khyātaḥ śimon ");
INSERT INTO sanias_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ca yākūbo bhrātā yihūdāśca taṁ yaḥ parakareṣu samarpayiṣyati sa īṣkarīyotīyayihūdāścaitān dvādaśa janān manonītān kṛtvā sa jagrāha tathā prerita iti teṣāṁ nāma cakāra| ");
INSERT INTO sanias_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","tataḥ paraṁ sa taiḥ saha parvvatādavaruhya upatyakāyāṁ tasthau tatastasya śiṣyasaṅgho yihūdādeśād yirūśālamaśca soraḥ sīdonaśca jaladhe rodhaso jananihāśca etya tasya kathāśravaṇārthaṁ rogamuktyarthañca tasya samīpe tasthuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","amedhyabhūtagrastāśca tannikaṭamāgatya svāsthyaṁ prāpuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","sarvveṣāṁ svāsthyakaraṇaprabhāvasya prakāśitatvāt sarvve lokā etya taṁ spraṣṭuṁ yetire| ");
INSERT INTO sanias_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","paścāt sa śiṣyān prati dṛṣṭiṁ kutvā jagāda, he daridrā yūyaṁ dhanyā yata īśvarīye rājye vo'dhikārosti| ");
INSERT INTO sanias_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","he adhunā kṣudhitalokā yūyaṁ dhanyā yato yūyaṁ tarpsyatha; he iha rodino janā yūyaṁ dhanyā yato yūyaṁ hasiṣyatha| ");
INSERT INTO sanias_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","yadā lokā manuṣyasūno rnāmaheto ryuṣmān ṛृtīyiṣyante pṛthak kṛtvā nindiṣyanti, adhamāniva yuṣmān svasamīpād dūrīkariṣyanti ca tadā yūyaṁ dhanyāḥ| ");
INSERT INTO sanias_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","svarge yuṣmākaṁ yatheṣṭaṁ phalaṁ bhaviṣyati, etadarthaṁ tasmin dine prollasata ānandena nṛtyata ca, teṣāṁ pūrvvapuruṣāśca bhaviṣyadvādinaḥ prati tathaiva vyavāharan| ");
INSERT INTO sanias_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","kintu hā hā dhanavanto yūyaṁ sukhaṁ prāpnuta| hanta paritṛptā yūyaṁ kṣudhitā bhaviṣyatha; ");
INSERT INTO sanias_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","iha hasanto yūyaṁ vata yuṣmābhiḥ śocitavyaṁ roditavyañca| ");
INSERT INTO sanias_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","sarvvailākai ryuṣmākaṁ sukhyātau kṛtāyāṁ yuṣmākaṁ durgati rbhaviṣyati yuṣmākaṁ pūrvvapuruṣā mṛṣābhaviṣyadvādinaḥ prati tadvat kṛtavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","he śrotāro yuṣmabhyamahaṁ kathayāmi, yūyaṁ śatruṣu prīyadhvaṁ ye ca yuṣmān dviṣanti teṣāmapi hitaṁ kuruta| ");
INSERT INTO sanias_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ye ca yuṣmān śapanti tebhya āśiṣaṁ datta ye ca yuṣmān avamanyante teṣāṁ maṅgalaṁ prārthayadhvaṁ| ");
INSERT INTO sanias_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","yadi kaścit tava kapole capeṭāghātaṁ karoti tarhi taṁ prati kapolam anyaṁ parāvarttya sammukhīkuru punaśca yadi kaścit tava gātrīyavastraṁ harati tarhi taṁ paridheyavastram api grahītuṁ mā vāraya| ");
INSERT INTO sanias_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","yastvāṁ yācate tasmai dehi, yaśca tava sampattiṁ harati taṁ mā yācasva| ");
INSERT INTO sanias_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","parebhyaḥ svān prati yathācaraṇam apekṣadhve parān prati yūyamapi tathācarata| ");
INSERT INTO sanias_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","ye janā yuṣmāsu prīyante kevalaṁ teṣu prīyamāṇeṣu yuṣmākaṁ kiṁ phalaṁ? pāpilokā api sveṣu prīyamāṇeṣu prīyante| ");
INSERT INTO sanias_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","yadi hitakāriṇa eva hitaṁ kurutha tarhi yuṣmākaṁ kiṁ phalaṁ? pāpilokā api tathā kurvvanti| ");
INSERT INTO sanias_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","yebhya ṛṇapariśodhasya prāptipratyāśāste kevalaṁ teṣu ṛṇe samarpite yuṣmākaṁ kiṁ phalaṁ? punaḥ prāptyāśayā pāpīlokā api pāpijaneṣu ṛṇam arpayanti| ");
INSERT INTO sanias_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","ato yūyaṁ ripuṣvapi prīyadhvaṁ, parahitaṁ kuruta ca; punaḥ prāptyāśāṁ tyaktvā ṛṇamarpayata, tathā kṛte yuṣmākaṁ mahāphalaṁ bhaviṣyati, yūyañca sarvvapradhānasya santānā iti khyātiṁ prāpsyatha, yato yuṣmākaṁ pitā kṛtaghnānāṁ durvṭattānāñca hitamācarati| ");
INSERT INTO sanias_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ata eva sa yathā dayālu ryūyamapi tādṛśā dayālavo bhavata| ");
INSERT INTO sanias_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","aparañca parān doṣiṇo mā kuruta tasmād yūyaṁ doṣīkṛtā na bhaviṣyatha; adaṇḍyān mā daṇḍayata tasmād yūyamapi daṇḍaṁ na prāpsyatha; pareṣāṁ doṣān kṣamadhvaṁ tasmād yuṣmākamapi doṣāḥ kṣamiṣyante| ");
INSERT INTO sanias_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","dānānidatta tasmād yūyaṁ dānāni prāpsyatha, varañca lokāḥ parimāṇapātraṁ pradalayya sañcālya proñcālya paripūryya yuṣmākaṁ kroḍeṣu samarpayiṣyanti; yūyaṁ yena parimāṇena parimātha tenaiva parimāṇena yuṣmatkṛte parimāsyate| ");
INSERT INTO sanias_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","atha sa tebhyo dṛṣṭāntakathāmakathayat, andho janaḥ kimandhaṁ panthānaṁ darśayituṁ śaknoti? tasmād ubhāvapi kiṁ gartte na patiṣyataḥ? ");
INSERT INTO sanias_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","guroḥ śiṣyo na śreṣṭhaḥ kintu śiṣye siddhe sati sa gurutulyo bhavituṁ śaknoti| ");
INSERT INTO sanias_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","aparañca tvaṁ svacakṣuुṣi nāsām adṛṣṭvā tava bhrātuścakṣuṣi yattṛṇamasti tadeva kutaḥ paśyami? ");
INSERT INTO sanias_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","svacakṣuṣi yā nāsā vidyate tām ajñātvā, bhrātastava netrāt tṛṇaṁ bahiḥ karomīti vākyaṁ bhrātaraṁ kathaṁ vaktuṁ śaknoṣi? he kapaṭin pūrvvaṁ svanayanāt nāsāṁ bahiḥ kuru tato bhrātuścakṣuṣastṛṇaṁ bahiḥ karttuṁ sudṛṣṭiṁ prāpsyasi| ");
INSERT INTO sanias_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","anyañca uttamastaruḥ kadāpi phalamanuttamaṁ na phalati, anuttamataruśca phalamuttamaṁ na phalati kāraṇādataḥ phalaistaravo jñāyante| ");
INSERT INTO sanias_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","kaṇṭakipādapāt kopi uḍumbaraphalāni na pātayati tathā śṛgālakolivṛkṣādapi kopi drākṣāphalaṁ na pātayati| ");
INSERT INTO sanias_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","tadvat sādhuloko'ntaḥkaraṇarūpāt subhāṇḍāgārād uttamāni dravyāṇi bahiḥ karoti, duṣṭo lokaścāntaḥkaraṇarūpāt kubhāṇḍāgārāt kutsitāni dravyāṇi nirgamayati yato'ntaḥkaraṇānāṁ pūrṇabhāvānurūpāṇi vacāṁsi mukhānnirgacchanti| ");
INSERT INTO sanias_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","aparañca mamājñānurūpaṁ nācaritvā kuto māṁ prabho prabho iti vadatha? ");
INSERT INTO sanias_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","yaḥ kaścin mama nikaṭam āgatya mama kathā niśamya tadanurūpaṁ karmma karoti sa kasya sadṛśo bhavati tadahaṁ yuṣmān jñāाpayāmi| ");
INSERT INTO sanias_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","yo jano gabhīraṁ khanitvā pāṣāṇasthale bhittiṁ nirmmāya svagṛhaṁ racayati tena saha tasyopamā bhavati; yata āplāvijalametya tasya mūle vegena vahadapi tadgehaṁ lāḍayituṁ na śaknoti yatastasya bhittiḥ pāṣāṇopari tiṣṭhati| ");
INSERT INTO sanias_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","kintu yaḥ kaścin mama kathāḥ śrutvā tadanurūpaṁ nācarati sa bhittiṁ vinā mṛृdupari gṛhanirmmātrā samāno bhavati; yata āplāvijalamāgatya vegena yadā vahati tadā tadgṛhaṁ patati tasya mahat patanaṁ jāyate| ");
INSERT INTO sanias_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","tataḥ paraṁ sa lokānāṁ karṇagocare tān sarvvān upadeśān samāpya yadā kapharnāhūmpuraṁ praviśati ");
INSERT INTO sanias_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","tadā śatasenāpateḥ priyadāsa eko mṛtakalpaḥ pīḍita āsīt| ");
INSERT INTO sanias_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ataḥ senāpati ryīśo rvārttāṁ niśamya dāsasyārogyakaraṇāya tasyāgamanārthaṁ vinayakaraṇāya yihūdīyān kiyataḥ prācaḥ preṣayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","te yīśorantikaṁ gatvā vinayātiśayaṁ vaktumārebhire, sa senāpati rbhavatonugrahaṁ prāptum arhati| ");
INSERT INTO sanias_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","yataḥ sosmajjātīyeṣu lokeṣu prīyate tathāsmatkṛte bhajanagehaṁ nirmmitavān| ");
INSERT INTO sanias_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","tasmād yīśustaiḥ saha gatvā niveśanasya samīpaṁ prāpa, tadā sa śatasenāpati rvakṣyamāṇavākyaṁ taṁ vaktuṁ bandhūn prāhiṇot| he prabho svayaṁ śramo na karttavyo yad bhavatā madgehamadhye pādārpaṇaṁ kriyeta tadapyahaṁ nārhāmi, ");
INSERT INTO sanias_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","kiñcāhaṁ bhavatsamīpaṁ yātumapi nātmānaṁ yogyaṁ buddhavān, tato bhavān vākyamātraṁ vadatu tenaiva mama dāsaḥ svastho bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","yasmād ahaṁ parādhīnopi mamādhīnā yāḥ senāḥ santi tāsām ekajanaṁ prati yāhīti mayā prokte sa yāti; tadanyaṁ prati āyāhīti prokte sa āyāti; tathā nijadāsaṁ prati etat kurvviti prokte sa tadeva karoti| ");
INSERT INTO sanias_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","yīśuridaṁ vākyaṁ śrutvā vismayaṁ yayau, mukhaṁ parāvartya paścādvarttino lokān babhāṣe ca, yuṣmānahaṁ vadāmi isrāyelo vaṁśamadhyepi viśvāsamīdṛśaṁ na prāpnavaṁ| ");
INSERT INTO sanias_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","tataste preṣitā gṛhaṁ gatvā taṁ pīḍitaṁ dāsaṁ svasthaṁ dadṛśuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","pare'hani sa nāyīnākhyaṁ nagaraṁ jagāma tasyāneke śiṣyā anye ca lokāstena sārddhaṁ yayuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","teṣu tannagarasya dvārasannidhiṁ prāpteṣu kiyanto lokā ekaṁ mṛtamanujaṁ vahanto nagarasya bahiryānti, sa tanmāturekaputrastanmātā ca vidhavā; tayā sārddhaṁ tannagarīyā bahavo lokā āsan| ");
INSERT INTO sanias_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","prabhustāṁ vilokya sānukampaḥ kathayāmāsa, mā rodīḥ| sa samīpamitvā khaṭvāṁ pasparśa tasmād vāhakāḥ sthagitāstamyuḥ; ");
INSERT INTO sanias_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","tadā sa uvāca he yuvamanuṣya tvamuttiṣṭha, tvāmaham ājñāpayāmi| ");
INSERT INTO sanias_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","tasmāt sa mṛto janastatkṣaṇamutthāya kathāṁ prakathitaḥ; tato yīśustasya mātari taṁ samarpayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","tasmāt sarvve lokāḥ śaśaṅkire; eko mahābhaviṣyadvādī madhye'smākam samudait, īśvaraśca svalokānanvagṛhlāt kathāmimāṁ kathayitvā īśvaraṁ dhanyaṁ jagaduḥ| ");
INSERT INTO sanias_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","tataḥ paraṁ samastaṁ yihūdādeśaṁ tasya caturdiksthadeśañca tasyaitatkīrtti rvyānaśe| ");
INSERT INTO sanias_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","tataḥ paraṁ yohanaḥ śiṣyeṣu taṁ tadvṛttāntaṁ jñāpitavatsu ");
INSERT INTO sanias_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","sa svaśiṣyāṇāṁ dvau janāvāhūya yīśuṁ prati vakṣyamāṇaṁ vākyaṁ vaktuṁ preṣayāmāsa, yasyāgamanam apekṣya tiṣṭhāmo vayaṁ kiṁ sa eva janastvaṁ? kiṁ vayamanyamapekṣya sthāsyāmaḥ? ");
INSERT INTO sanias_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","paścāttau mānavau gatvā kathayāmāsatuḥ, yasyāgamanam apekṣya tiṣṭhāmo vayaṁ, kiṁ saeva janastvaṁ? kiṁ vayamanyamapekṣya sthāsyāmaḥ? kathāmimāṁ tubhyaṁ kathayituṁ yohan majjaka āvāṁ preṣitavān| ");
INSERT INTO sanias_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","tasmin daṇḍe yīśūrogiṇo mahāvyādhimato duṣṭabhūtagrastāṁśca bahūn svasthān kṛtvā, anekāndhebhyaścakṣuṁṣi dattvā pratyuvāca, ");
INSERT INTO sanias_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","yuvāṁ vrajatam andhā netrāṇi khañjāścaraṇāni ca prāpnuvanti, kuṣṭhinaḥ pariṣkriyante, badhirāḥ śravaṇāni mṛtāśca jīvanāni prāpnuvanti, daridrāṇāṁ samīpeṣu susaṁvādaḥ pracāryyate, yaṁ prati vighnasvarūpohaṁ na bhavāmi sa dhanyaḥ, ");
INSERT INTO sanias_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","etāni yāni paśyathaḥ śṛṇuthaśca tāni yohanaṁ jñāpayatam| ");
INSERT INTO sanias_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","tayo rdūtayo rgatayoḥ sato ryohani sa lokān vaktumupacakrame, yūyaṁ madhyeprāntaraṁ kiṁ draṣṭuṁ niragamata? kiṁ vāyunā kampitaṁ naḍaṁ? ");
INSERT INTO sanias_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","yūyaṁ kiṁ draṣṭuṁ niragamata? kiṁ sūkṣmavastraparidhāyinaṁ kamapi naraṁ? kintu ye sūkṣmamṛduvastrāṇi paridadhati sūttamāni dravyāṇi bhuñjate ca te rājadhānīṣu tiṣṭhanti| ");
INSERT INTO sanias_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","tarhi yūyaṁ kiṁ draṣṭuṁ niragamata? kimekaṁ bhaviṣyadvādinaṁ? tadeva satyaṁ kintu sa pumān bhaviṣyadvādinopi śreṣṭha ityahaṁ yuṣmān vadāmi; ");
INSERT INTO sanias_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","paśya svakīyadūtantu tavāgra preṣayāmyahaṁ| gatvā tvadīyamārgantu sa hi pariṣkariṣyati| yadarthe lipiriyam āste sa eva yohan| ");
INSERT INTO sanias_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","ato yuṣmānahaṁ vadāmi striyā garbbhajātānāṁ bhaviṣyadvādināṁ madhye yohano majjakāt śreṣṭhaḥ kopi nāsti, tatrāpi īśvarasya rājye yaḥ sarvvasmāt kṣudraḥ sa yohanopi śreṣṭhaḥ| ");
INSERT INTO sanias_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","aparañca sarvve lokāḥ karamañcāyinaśca tasya vākyāni śrutvā yohanā majjanena majjitāḥ parameśvaraṁ nirdoṣaṁ menire| ");
INSERT INTO sanias_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","kintu phirūśino vyavasthāpakāśca tena na majjitāḥ svān pratīśvarasyopadeśaṁ niṣphalam akurvvan| ");
INSERT INTO sanias_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","atha prabhuḥ kathayāmāsa, idānīntanajanān kenopamāmi? te kasya sadṛśāḥ? ");
INSERT INTO sanias_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ye bālakā vipaṇyām upaviśya parasparam āhūya vākyamidaṁ vadanti, vayaṁ yuṣmākaṁ nikaṭe vaṁśīravādiṣma, kintu yūyaṁ nānarttiṣṭa, vayaṁ yuṣmākaṁ nikaṭa arodiṣma, kintu yuyaṁ na vyalapiṣṭa, bālakairetādṛśaisteṣām upamā bhavati| ");
INSERT INTO sanias_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","yato yohan majjaka āgatya pūpaṁ nākhādat drākṣārasañca nāpivat tasmād yūyaṁ vadatha, bhūtagrastoyam| ");
INSERT INTO sanias_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","tataḥ paraṁ mānavasuta āgatyākhādadapivañca tasmād yūyaṁ vadatha, khādakaḥ surāpaścāṇḍālapāpināṁ bandhureko jano dṛśyatām| ");
INSERT INTO sanias_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","kintu jñānino jñānaṁ nirdoṣaṁ viduḥ| ");
INSERT INTO sanias_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","paścādekaḥ phirūśī yīśuṁ bhojanāya nyamantrayat tataḥ sa tasya gṛhaṁ gatvā bhoktumupaviṣṭaḥ| ");
INSERT INTO sanias_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","etarhi tatphirūśino gṛhe yīśu rbhektum upāvekṣīt tacchrutvā tannagaravāsinī kāpi duṣṭā nārī pāṇḍaraprastarasya sampuṭake sugandhitailam ānīya ");
INSERT INTO sanias_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","tasya paścāt pādayoḥ sannidhau tasyau rudatī ca netrāmbubhistasya caraṇau prakṣālya nijakacairamārkṣīt, tatastasya caraṇau cumbitvā tena sugandhitailena mamarda| ");
INSERT INTO sanias_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","tasmāt sa nimantrayitā phirūśī manasā cintayāmāsa, yadyayaṁ bhaviṣyadvādī bhavet tarhi enaṁ spṛśati yā strī sā kā kīdṛśī ceti jñātuṁ śaknuyāt yataḥ sā duṣṭā| ");
INSERT INTO sanias_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","tadā yāśustaṁ jagāda, he śimon tvāṁ prati mama kiñcid vaktavyamasti; tasmāt sa babhāṣe, he guro tad vadatu| ");
INSERT INTO sanias_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ekottamarṇasya dvāvadhamarṇāvāstāṁ, tayorekaḥ pañcaśatāni mudrāpādān aparaśca pañcāśat mudrāpādān dhārayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","tadanantaraṁ tayoḥ śodhyābhāvāt sa uttamarṇastayo rṛṇe cakṣame; tasmāt tayordvayoḥ kastasmin preṣyate bahu? tad brūhi| ");
INSERT INTO sanias_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","śimon pratyuvāca, mayā budhyate yasyādhikam ṛṇaṁ cakṣame sa iti; tato yīśustaṁ vyājahāra, tvaṁ yathārthaṁ vyacārayaḥ| ");
INSERT INTO sanias_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","atha tāṁ nārīṁ prati vyāghuṭhya śimonamavocat, strīmimāṁ paśyasi? tava gṛhe mayyāgate tvaṁ pādaprakṣālanārthaṁ jalaṁ nādāḥ kintu yoṣideṣā nayanajalai rmama pādau prakṣālya keśairamārkṣīt| ");
INSERT INTO sanias_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","tvaṁ māṁ nācumbīḥ kintu yoṣideṣā svīyāgamanādārabhya madīyapādau cumbituṁ na vyaraṁsta| ");
INSERT INTO sanias_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","tvañca madīyottamāṅge kiñcidapi tailaṁ nāmardīḥ kintu yoṣideṣā mama caraṇau sugandhitailenāmarddīt| ");
INSERT INTO sanias_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","atastvāṁ vyāharāmi, etasyā bahu pāpamakṣamyata tato bahu prīyate kintu yasyālpapāpaṁ kṣamyate solpaṁ prīyate| ");
INSERT INTO sanias_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","tataḥ paraṁ sa tāṁ babhāṣe, tvadīyaṁ pāpamakṣamyata| ");
INSERT INTO sanias_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","tadā tena sārddhaṁ ye bhoktum upaviviśuste parasparaṁ vaktumārebhire, ayaṁ pāpaṁ kṣamate ka eṣaḥ? ");
INSERT INTO sanias_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","kintu sa tāṁ nārīṁ jagāda, tava viśvāsastvāṁ paryyatrāsta tvaṁ kṣemeṇa vraja| ");
INSERT INTO sanias_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","aparañca yīśu rdvādaśabhiḥ śiṣyaiḥ sārddhaṁ nānānagareṣu nānāgrāmeṣu ca gacchan iśvarīyarājatvasya susaṁvādaṁ pracārayituṁ prārebhe| ");
INSERT INTO sanias_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","tadā yasyāḥ sapta bhūtā niragacchan sā magdalīnīti vikhyātā mariyam herodrājasya gṛhādhipateḥ hoṣe rbhāryyā yohanā śūśānā ");
INSERT INTO sanias_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","prabhṛtayo yā bahvyaḥ striyaḥ duṣṭabhūtebhyo rogebhyaśca muktāḥ satyo nijavibhūtī rvyayitvā tamasevanta, tāḥ sarvvāstena sārddham āsan| ");
INSERT INTO sanias_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","anantaraṁ nānānagarebhyo bahavo lokā āgatya tasya samīpe'milan, tadā sa tebhya ekāṁ dṛṣṭāntakathāṁ kathayāmāsa| ekaḥ kṛṣībalo bījāni vaptuṁ bahirjagāma, ");
INSERT INTO sanias_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","tato vapanakāle katipayāni bījāni mārgapārśve petuḥ, tatastāni padatalai rdalitāni pakṣibhi rbhakṣitāni ca| ");
INSERT INTO sanias_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","katipayāni bījāni pāṣāṇasthale patitāni yadyapi tānyaṅkuritāni tathāpi rasābhāvāt śuśuṣuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","katipayāni bījāni kaṇṭakivanamadhye patitāni tataḥ kaṇṭakivanāni saṁvṛddhya tāni jagrasuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","tadanyāni katipayabījāni ca bhūmyāmuttamāyāṁ petustatastānyaṅkurayitvā śataguṇāni phalāni pheluḥ| sa imā kathāṁ kathayitvā proccaiḥ provāca, yasya śrotuṁ śrotre staḥ sa śṛṇotu| ");
INSERT INTO sanias_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","tataḥ paraṁ śiṣyāstaṁ papracchurasya dṛṣṭāntasya kiṁ tātparyyaṁ? ");
INSERT INTO sanias_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","tataḥ sa vyājahāra, īśvarīyarājyasya guhyāni jñātuṁ yuṣmabhyamadhikāro dīyate kintvanye yathā dṛṣṭvāpi na paśyanti śrutvāpi ma budhyante ca tadarthaṁ teṣāṁ purastāt tāḥ sarvvāḥ kathā dṛṣṭāntena kathyante| ");
INSERT INTO sanias_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","dṛṣṭāntasyāsyābhiprāyaḥ, īśvarīyakathā bījasvarūpā| ");
INSERT INTO sanias_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ye kathāmātraṁ śṛṇvanti kintu paścād viśvasya yathā paritrāṇaṁ na prāpnuvanti tadāśayena śaitānetya hṛdayātṛ tāṁ kathām apaharati ta eva mārgapārśvasthabhūmisvarūpāḥ| ");
INSERT INTO sanias_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ye kathaṁ śrutvā sānandaṁ gṛhlanti kintvabaddhamūlatvāt svalpakālamātraṁ pratītya parīkṣākāle bhraśyanti taeva pāṣāṇabhūmisvarūpāḥ| ");
INSERT INTO sanias_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ye kathāṁ śrutvā yānti viṣayacintāyāṁ dhanalobhena eेhikasukhe ca majjanta upayuktaphalāni na phalanti ta evoptabījakaṇṭakibhūsvarūpāḥ| ");
INSERT INTO sanias_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","kintu ye śrutvā saralaiḥ śuddhaiścāntaḥkaraṇaiḥ kathāṁ gṛhlanti dhairyyam avalambya phalānyutpādayanti ca ta evottamamṛtsvarūpāḥ| ");
INSERT INTO sanias_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","aparañca pradīpaṁ prajvālya kopi pātreṇa nācchādayati tathā khaṭvādhopi na sthāpayati, kintu dīpādhāroparyyeva sthāpayati, tasmāt praveśakā dīptiṁ paśyanti| ");
INSERT INTO sanias_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","yanna prakāśayiṣyate tādṛg aprakāśitaṁ vastu kimapi nāsti yacca na suvyaktaṁ pracārayiṣyate tādṛg gṛptaṁ vastu kimapi nāsti| ");
INSERT INTO sanias_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","ato yūyaṁ kena prakāreṇa śṛṇutha tatra sāvadhānā bhavata, yasya samīpe barddhate tasmai punardāsyate kintu yasyāśraye na barddhate tasya yadyadasti tadapi tasmāt neṣyate| ");
INSERT INTO sanias_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","aparañca yīśo rmātā bhrātaraśca tasya samīpaṁ jigamiṣavaḥ ");
INSERT INTO sanias_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","kintu janatāsambādhāt tatsannidhiṁ prāptuṁ na śekuḥ| tatpaścāt tava mātā bhrātaraśca tvāṁ sākṣāt cikīrṣanto bahistiṣṭhanatīti vārttāyāṁ tasmai kathitāyāṁ ");
INSERT INTO sanias_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","sa pratyuvāca; ye janā īśvarasya kathāṁ śrutvā tadanurūpamācaranti taeva mama mātā bhrātaraśca| ");
INSERT INTO sanias_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","anantaraṁ ekadā yīśuḥ śiṣyaiḥ sārddhaṁ nāvamāruhya jagāda, āyāta vayaṁ hradasya pāraṁ yāmaḥ, tataste jagmuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","teṣu naukāṁ vāhayatsu sa nidadrau; ");
INSERT INTO sanias_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","athākasmāt prabalajhañbhśagamād hrade naukāyāṁ taraṅgairācchannāyāṁ vipat tān jagrāsa|tasmād yīśorantikaṁ gatvā he guro he guro prāṇā no yāntīti gaditvā taṁ jāgarayāmbabhūvuḥ|tadā sa utthāya vāyuṁ taraṅgāṁśca tarjayāmāsa tasmādubhau nivṛtya sthirau babhūvatuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","sa tān babhāṣe yuṣmākaṁ viśvāsaḥ ka? tasmātte bhītā vismitāśca parasparaṁ jagaduḥ, aho kīdṛgayaṁ manujaḥ pavanaṁ pānīyañcādiśati tadubhayaṁ tadādeśaṁ vahati| ");
INSERT INTO sanias_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","tataḥ paraṁ gālīlpradeśasya sammukhasthagiderīyapradeśe naukāyāṁ lagantyāṁ taṭe'varohamāvād ");
INSERT INTO sanias_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","bahutithakālaṁ bhūtagrasta eko mānuṣaḥ purādāgatya taṁ sākṣāccakāra| sa manuṣo vāso na paridadhat gṛhe ca na vasan kevalaṁ śmaśānam adhyuvāsa| ");
INSERT INTO sanias_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","sa yīśuṁ dṛṣṭvaiva cīcchabdaṁ cakāra tasya sammukhe patitvā proccairjagāda ca, he sarvvapradhāneśvarasya putra, mayā saha tava kaḥ sambandhaḥ? tvayi vinayaṁ karomi māṁ mā yātaya| ");
INSERT INTO sanias_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","yataḥ sa taṁ mānuṣaṁ tyaktvā yātum amedhyabhūtam ādideśa; sa bhūtastaṁ mānuṣam asakṛd dadhāra tasmāllokāḥ śṛṅkhalena nigaḍena ca babandhuḥ; sa tad bhaṁktvā bhūtavaśatvāt madhyeprāntaraṁ yayau| ");
INSERT INTO sanias_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","anantaraṁ yīśustaṁ papraccha tava kinnāma? sa uvāca, mama nāma bāhino yato bahavo bhūtāstamāśiśriyuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","atha bhūtā vinayena jagaduḥ, gabhīraṁ garttaṁ gantuṁ mājñāpayāsmān| ");
INSERT INTO sanias_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","tadā parvvatopari varāhavrajaścarati tasmād bhūtā vinayena procuḥ, amuṁ varāhavrajam āśrayitum asmān anujānīhi; tataḥ sonujajñau| ");
INSERT INTO sanias_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","tataḥ paraṁ bhūtāstaṁ mānuṣaṁ vihāya varāhavrajam āśiśriyuḥ varāhavrajāśca tatkṣaṇāt kaṭakena dhāvanto hrade prāṇān vijṛhuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","tad dṛṣṭvā śūkararakṣakāḥ palāyamānā nagaraṁ grāmañca gatvā tatsarvvavṛttāntaṁ kathayāmāsuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","tataḥ kiṁ vṛttam etaddarśanārthaṁ lokā nirgatya yīśoḥ samīpaṁ yayuḥ, taṁ mānuṣaṁ tyaktabhūtaṁ parihitavastraṁ svasthamānuṣavad yīśoścaraṇasannidhau sūpaviśantaṁ vilokya bibhyuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ye lokāstasya bhūtagrastasya svāsthyakaraṇaṁ dadṛśuste tebhyaḥ sarvvavṛttāntaṁ kathayāmāsuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","tadanantaraṁ tasya giderīyapradeśasya caturdiksthā bahavo janā atitrastā vinayena taṁ jagaduḥ, bhavān asmākaṁ nikaṭād vrajatu tasmāt sa nāvamāruhya tato vyāghuṭya jagāma| ");
INSERT INTO sanias_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","tadānīṁ tyaktabhūtamanujastena saha sthātuṁ prārthayāñcakre ");
INSERT INTO sanias_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","kintu tadartham īśvaraḥ kīdṛṅmahākarmma kṛtavān iti niveśanaṁ gatvā vijñāpaya, yīśuḥ kathāmetāṁ kathayitvā taṁ visasarja| tataḥ sa vrajitvā yīśustadarthaṁ yanmahākarmma cakāra tat purasya sarvvatra prakāśayituṁ prārebhe| ");
INSERT INTO sanias_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","atha yīśau parāvṛtyāgate lokāstaṁ ādareṇa jagṛhu ryasmātte sarvve tamapekṣāñcakrire| ");
INSERT INTO sanias_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","tadanantaraṁ yāyīrnāmno bhajanagehasyaikodhipa āgatya yīśoścaraṇayoḥ patitvā svaniveśanāgamanārthaṁ tasmin vinayaṁ cakāra, ");
INSERT INTO sanias_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","yatastasya dvādaśavarṣavayaskā kanyaikāsīt sā mṛtakalpābhavat| tatastasya gamanakāle mārge lokānāṁ mahān samāgamo babhūva| ");
INSERT INTO sanias_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","dvādaśavarṣāṇi pradararogagrastā nānā vaidyaiścikitsitā sarvvasvaṁ vyayitvāpi svāsthyaṁ na prāptā yā yoṣit sā yīśoḥ paścādāgatya tasya vastragranthiṁ pasparśa| ");
INSERT INTO sanias_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","tasmāt tatkṣaṇāt tasyā raktasrāvo ruddhaḥ| ");
INSERT INTO sanias_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","tadānīṁ yīśuravadat kenāhaṁ spṛṣṭaḥ? tato'nekairanaṅgīkṛte pitarastasya saṅginaścāvadan, he guro lokā nikaṭasthāḥ santastava dehe gharṣayanti, tathāpi kenāhaṁ spṛṣṭa̮iti bhavān kutaḥ pṛcchati? ");
INSERT INTO sanias_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","yīśuḥ kathayāmāsa, kenāpyahaṁ spṛṣṭo, yato mattaḥ śakti rnirgateti mayā niścitamajñāyi| ");
INSERT INTO sanias_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","tadā sā nārī svayaṁ na gupteti viditvā kampamānā satī tasya sammukhe papāta; yena nimittena taṁ pasparśa sparśamātrācca yena prakāreṇa svasthābhavat tat sarvvaṁ tasya sākṣādācakhyau| ");
INSERT INTO sanias_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","tataḥ sa tāṁ jagāda he kanye susthirā bhava, tava viśvāsastvāṁ svasthām akārṣīt tvaṁ kṣemeṇa yāhi| ");
INSERT INTO sanias_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","yīśoretadvākyavadanakāle tasyādhipate rniveśanāt kaścilloka āgatya taṁ babhāṣe, tava kanyā mṛtā guruṁ mā kliśāna| ");
INSERT INTO sanias_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","kintu yīśustadākarṇyādhipatiṁ vyājahāra, mā bhaiṣīḥ kevalaṁ viśvasihi tasmāt sā jīviṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","atha tasya niveśane prāpte sa pitaraṁ yohanaṁ yākūbañca kanyāyā mātaraṁ pitarañca vinā, anyaṁ kañcana praveṣṭuṁ vārayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","aparañca ye rudanti vilapanti ca tān sarvvān janān uvāca, yūyaṁ mā rodiṣṭa kanyā na mṛtā nidrāti| ");
INSERT INTO sanias_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","kintu sā niścitaṁ mṛteti jñātvā te tamupajahasuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","paścāt sa sarvvān bahiḥ kṛtvā kanyāyāḥ karau dhṛtvājuhuve, he kanye tvamuttiṣṭha, ");
INSERT INTO sanias_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","tasmāt tasyāḥ prāṇeṣu punarāgateṣu sā tatkṣaṇād uttasyau| tadānīṁ tasyai kiñcid bhakṣyaṁ dātum ādideśa| ");
INSERT INTO sanias_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","tatastasyāḥ pitarau vismayaṁ gatau kintu sa tāvādideśa ghaṭanāyā etasyāḥ kathāṁ kasmaicidapi mā kathayataṁ| ");
INSERT INTO sanias_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","tataḥ paraṁ sa dvādaśaśiṣyānāhūya bhūtān tyājayituṁ rogān pratikarttuñca tebhyaḥ śaktimādhipatyañca dadau| ");
INSERT INTO sanias_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","aparañca īśvarīyarājyasya susaṁvādaṁ prakāśayitum rogiṇāmārogyaṁ karttuñca preraṇakāle tān jagāda| ");
INSERT INTO sanias_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","yātrārthaṁ yaṣṭi rvastrapuṭakaṁ bhakṣyaṁ mudrā dvitīyavastram, eṣāṁ kimapi mā gṛhlīta| ");
INSERT INTO sanias_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","yūyañca yanniveśanaṁ praviśatha nagaratyāgaparyyanataṁ tanniveśane tiṣṭhata| ");
INSERT INTO sanias_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","tatra yadi kasyacit purasya lokā yuṣmākamātithyaṁ na kurvvanti tarhi tasmānnagarād gamanakāle teṣāṁ viruddhaṁ sākṣyārthaṁ yuṣmākaṁ padadhūlīḥ sampātayata| ");
INSERT INTO sanias_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","atha te prasthāya sarvvatra susaṁvādaṁ pracārayituṁ pīḍitān svasthān karttuñca grāmeṣu bhramituṁ prārebhire| ");
INSERT INTO sanias_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","etarhi herod rājā yīśoḥ sarvvakarmmaṇāṁ vārttāṁ śrutvā bhṛśamudvivije ");
INSERT INTO sanias_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","yataḥ kecidūcuryohan śmaśānādudatiṣṭhat| kecidūcuḥ, eliyo darśanaṁ dattavān; evamanyalokā ūcuḥ pūrvvīyaḥ kaścid bhaviṣyadvādī samutthitaḥ| ");
INSERT INTO sanias_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","kintu heroduvāca yohanaḥ śiro'hamachinadam idānīṁ yasyedṛkkarmmaṇāṁ vārttāṁ prāpnomi sa kaḥ? atha sa taṁ draṣṭum aicchat| ");
INSERT INTO sanias_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","anantaraṁ preritāḥ pratyāgatya yāni yāni karmmāṇi cakrustāni yīśave kathayāmāsuḥ tataḥ sa tān baitsaidānāmakanagarasya vijanaṁ sthānaṁ nītvā guptaṁ jagāma| ");
INSERT INTO sanias_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","paścāl lokāstad viditvā tasya paścād yayuḥ; tataḥ sa tān nayan īśvarīyarājyasya prasaṅgamuktavān, yeṣāṁ cikitsayā prayojanam āsīt tān svasthān cakāra ca| ");
INSERT INTO sanias_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","aparañca divāvasanne sati dvādaśaśiṣyā yīśorantikam etya kathayāmāsuḥ, vayamatra prāntarasthāne tiṣṭhāmaḥ, tato nagarāṇi grāmāṇi gatvā vāsasthānāni prāpya bhakṣyadravyāṇi kretuṁ jananivahaṁ bhavān visṛjatu| ");
INSERT INTO sanias_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","tadā sa uvāca, yūyameva tān bhejayadhvaṁ; tataste procurasmākaṁ nikaṭe kevalaṁ pañca pūpā dvau matsyau ca vidyante, ataeva sthānāntaram itvā nimittameteṣāṁ bhakṣyadravyeṣu na krīteṣu na bhavati| ");
INSERT INTO sanias_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","tatra prāyeṇa pañcasahasrāṇi puruṣā āsan| ");
INSERT INTO sanias_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","tadā sa śiṣyān jagāda pañcāśat pañcāśajjanaiḥ paṁktīkṛtya tānupaveśayata, tasmāt te tadanusāreṇa sarvvalokānupaveśayāpāsuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","tataḥ sa tān pañca pūpān mīnadvayañca gṛhītvā svargaṁ vilokyeśvaraguṇān kīrttayāñcakre bhaṅktā ca lokebhyaḥ pariveṣaṇārthaṁ śiṣyeṣu samarpayāmbabhūva| ");
INSERT INTO sanias_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","tataḥ sarvve bhuktvā tṛptiṁ gatā avaśiṣṭānāñca dvādaśa ḍallakān saṁjagṛhuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","athaikadā nirjane śiṣyaiḥ saha prārthanākāle tān papraccha, lokā māṁ kaṁ vadanti? ");
INSERT INTO sanias_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","tataste prācuḥ, tvāṁ yohanmajjakaṁ vadanti; kecit tvām eliyaṁ vadanti, pūrvvakālikaḥ kaścid bhaviṣyadvādī śmaśānād udatiṣṭhad ityapi kecid vadanti| ");
INSERT INTO sanias_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","tadā sa uvāca, yūyaṁ māṁ kaṁ vadatha? tataḥ pitara uktavān tvam īśvarābhiṣiktaḥ puruṣaḥ| ");
INSERT INTO sanias_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","tadā sa tān dṛḍhamādideśa, kathāmetāṁ kasmaicidapi mā kathayata| ");
INSERT INTO sanias_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","sa punaruvāca, manuṣyaputreṇa vahuyātanā bhoktavyāḥ prācīnalokaiḥ pradhānayājakairadhyāpakaiśca sovajñāya hantavyaḥ kintu tṛtīyadivase śmaśānāt tenotthātavyam| ");
INSERT INTO sanias_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","aparaṁ sa sarvvānuvāca, kaścid yadi mama paścād gantuṁ vāñchati tarhi sa svaṁ dāmyatu, dine dine kruśaṁ gṛhītvā ca mama paścādāgacchatu| ");
INSERT INTO sanias_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","yato yaḥ kaścit svaprāṇān rirakṣiṣati sa tān hārayiṣyati, yaḥ kaścin madarthaṁ prāṇān hārayiṣyati sa tān rakṣiṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","kaścid yadi sarvvaṁ jagat prāpnoti kintu svaprāṇān hārayati svayaṁ vinaśyati ca tarhi tasya ko lābhaḥ? ");
INSERT INTO sanias_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","puna ryaḥ kaścin māṁ mama vākyaṁ vā lajjāspadaṁ jānāti manuṣyaputro yadā svasya pituśca pavitrāṇāṁ dūtānāñca tejobhiḥ pariveṣṭita āgamiṣyati tadā sopi taṁ lajjāspadaṁ jñāsyati| ");
INSERT INTO sanias_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","kintu yuṣmānahaṁ yathārthaṁ vadāmi, īśvarīyarājatvaṁ na dṛṣṭavā mṛtyuṁ nāsvādiṣyante, etādṛśāḥ kiyanto lokā atra sthane'pi daṇḍāyamānāḥ santi| ");
INSERT INTO sanias_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","etadākhyānakathanāt paraṁ prāyeṇāṣṭasu dineṣu gateṣu sa pitaraṁ yohanaṁ yākūbañca gṛhītvā prārthayituṁ parvvatamekaṁ samāruroha| ");
INSERT INTO sanias_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","atha tasya prārthanakāle tasya mukhākṛtiranyarūpā jātā, tadīyaṁ vastramujjvalaśuklaṁ jātaṁ| ");
INSERT INTO sanias_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","aparañca mūsā eliyaścobhau tejasvinau dṛṣṭau ");
INSERT INTO sanias_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","tau tena yirūśālampure yo mṛtyuḥ sādhiṣyate tadīyāṁ kathāṁ tena sārddhaṁ kathayitum ārebhāte| ");
INSERT INTO sanias_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","tadā pitarādayaḥ svasya saṅgino nidrayākṛṣṭā āsan kintu jāgaritvā tasya tejastena sārddham uttiṣṭhantau janau ca dadṛśuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","atha tayorubhayo rgamanakāle pitaro yīśuṁ babhāṣe, he guro'smākaṁ sthāne'smin sthitiḥ śubhā, tata ekā tvadarthā, ekā mūsārthā, ekā eliyārthā, iti tisraḥ kuṭyosmābhi rnirmmīyantāṁ, imāṁ kathāṁ sa na vivicya kathayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","aparañca tadvākyavadanakāle payoda eka āgatya teṣāmupari chāyāṁ cakāra, tatastanmadhye tayoḥ praveśāt te śaśaṅkire| ");
INSERT INTO sanias_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","tadā tasmāt payodād iyamākāśīyā vāṇī nirjagāma, mamāyaṁ priyaḥ putra etasya kathāyāṁ mano nidhatta| ");
INSERT INTO sanias_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","iti śabde jāte te yīśumekākinaṁ dadṛśuḥ kintu te tadānīṁ tasya darśanasya vācamekāmapi noktvā manaḥsu sthāpayāmāsuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","pare'hani teṣu tasmācchailād avarūḍheṣu taṁ sākṣāt karttuṁ bahavo lokā ājagmuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","teṣāṁ madhyād eko jana uccairuvāca, he guro ahaṁ vinayaṁ karomi mama putraṁ prati kṛpādṛṣṭiṁ karotu, mama sa evaikaḥ putraḥ| ");
INSERT INTO sanias_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","bhūtena dhṛtaḥ san saṁ prasabhaṁ cīcchabdaṁ karoti tanmukhāt pheṇā nirgacchanti ca, bhūta itthaṁ vidāryya kliṣṭvā prāyaśastaṁ na tyajati| ");
INSERT INTO sanias_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","tasmāt taṁ bhūtaṁ tyājayituṁ tava śiṣyasamīpe nyavedayaṁ kintu te na śekuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","tadā yīśuravādīt, re āviśvāsin vipathagāmin vaṁśa katikālān yuṣmābhiḥ saha sthāsyāmyahaṁ yuṣmākam ācaraṇāni ca sahiṣye? tava putramihānaya| ");
INSERT INTO sanias_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","tatastasminnāgatamātre bhūtastaṁ bhūmau pātayitvā vidadāra; tadā yīśustamamedhyaṁ bhūtaṁ tarjayitvā bālakaṁ svasthaṁ kṛtvā tasya pitari samarpayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","īśvarasya mahāśaktim imāṁ vilokya sarvve camaccakruḥ; itthaṁ yīśoḥ sarvvābhiḥ kriyābhiḥ sarvvairlokairāścaryye manyamāne sati sa śiṣyān babhāṣe, ");
INSERT INTO sanias_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","katheyaṁ yuṣmākaṁ karṇeṣu praviśatu, manuṣyaputro manuṣyāṇāṁ kareṣu samarpayiṣyate| ");
INSERT INTO sanias_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","kintu te tāṁ kathāṁ na bubudhire, spaṣṭatvābhāvāt tasyā abhiprāyasteṣāṁ bodhagamyo na babhūva; tasyā āśayaḥ ka ityapi te bhayāt praṣṭuṁ na śekuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","tadanantaraṁ teṣāṁ madhye kaḥ śreṣṭhaḥ kathāmetāṁ gṛhītvā te mitho vivādaṁ cakruḥ| ");
INSERT INTO sanias_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","tato yīśusteṣāṁ manobhiprāyaṁ viditvā bālakamekaṁ gṛhītvā svasya nikaṭe sthāpayitvā tān jagāda, ");
INSERT INTO sanias_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","yo jano mama nāmnāsya bālāsyātithyaṁ vidadhāti sa mamātithyaṁ vidadhāti, yaśca mamātithyaṁ vidadhāti sa mama prerakasyātithyaṁ vidadhāti, yuṣmākaṁ madhyeyaḥ svaṁ sarvvasmāt kṣudraṁ jānīte sa eva śreṣṭho bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","aparañca yohan vyājahāra he prabheा tava nāmnā bhūtān tyājayantaṁ mānuṣam ekaṁ dṛṣṭavanto vayaṁ, kintvasmākam apaścād gāmitvāt taṁ nyaṣedhām| tadānīṁ yīśuruvāca, ");
INSERT INTO sanias_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","taṁ mā niṣedhata, yato yo janosmākaṁ na vipakṣaḥ sa evāsmākaṁ sapakṣo bhavati| ");
INSERT INTO sanias_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","anantaraṁ tasyārohaṇasamaya upasthite sa sthiracetā yirūśālamaṁ prati yātrāṁ karttuṁ niścityāgre dūtān preṣayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","tasmāt te gatvā tasya prayojanīyadravyāṇi saṁgrahītuṁ śomiroṇīyānāṁ grāmaṁ praviviśuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","kintu sa yirūśālamaṁ nagaraṁ yāti tato heto rlokāstasyātithyaṁ na cakruḥ| ");
INSERT INTO sanias_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ataeva yākūbyohanau tasya śiṣyau tad dṛṣṭvā jagadatuḥ, he prabho eliyo yathā cakāra tathā vayamapi kiṁ gagaṇād āgantum etān bhasmīkarttuñca vahnimājñāpayāmaḥ? bhavān kimicchati? ");
INSERT INTO sanias_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","kintu sa mukhaṁ parāvartya tān tarjayitvā gaditavān yuṣmākaṁ manobhāvaḥ kaḥ, iti yūyaṁ na jānītha| ");
INSERT INTO sanias_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","manujasuto manujānāṁ prāṇān nāśayituṁ nāgacchat, kintu rakṣitum āgacchat| paścād itaragrāmaṁ te yayuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","tadanantaraṁ pathi gamanakāle jana ekastaṁ babhāṣe, he prabho bhavān yatra yāti bhavatā sahāhamapi tatra yāsyāmi| ");
INSERT INTO sanias_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","tadānīṁ yīśustamuvāca, gomāyūnāṁ garttā āsate, vihāyasīyavihagāाnāṁ nīḍāni ca santi, kintu mānavatanayasya śiraḥ sthāpayituṁ sthānaṁ nāsti| ");
INSERT INTO sanias_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","tataḥ paraṁ sa itarajanaṁ jagāda, tvaṁ mama paścād ehi; tataḥ sa uvāca, he prabho pūrvvaṁ pitaraṁ śmaśāne sthāpayituṁ māmādiśatu| ");
INSERT INTO sanias_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","tadā yīśuruvāca, mṛtā mṛtān śmaśāne sthāpayantu kintu tvaṁ gatveśvarīyarājyasya kathāṁ pracāraya| ");
INSERT INTO sanias_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","tatonyaḥ kathayāmāsa, he prabho mayāpi bhavataḥ paścād gaṁsyate, kintu pūrvvaṁ mama niveśanasya parijanānām anumatiṁ grahītum ahamādiśyai bhavatā| ");
INSERT INTO sanias_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","tadānīṁ yīśustaṁ proktavān, yo jano lāṅgale karamarpayitvā paścāt paśyati sa īśvarīyarājyaṁ nārhati| ");
INSERT INTO sanias_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","tataḥ paraṁ prabhuraparān saptatiśiṣyān niyujya svayaṁ yāni nagarāṇi yāni sthānāni ca gamiṣyati tāni nagarāṇi tāni sthānāni ca prati dvau dvau janau prahitavān| ");
INSERT INTO sanias_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","tebhyaḥ kathayāmāsa ca śasyāni bahūnīti satyaṁ kintu chedakā alpe; tasmāddhetoḥ śasyakṣetre chedakān aparānapi preṣayituṁ kṣetrasvāminaṁ prārthayadhvaṁ| ");
INSERT INTO sanias_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","yūyaṁ yāta, paśyata, vṛkāṇāṁ madhye meṣaśāvakāniva yuṣmān prahiṇomi| ");
INSERT INTO sanias_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","yūyaṁ kṣudraṁ mahad vā vasanasampuṭakaṁ pādukāśca mā gṛhlīta, mārgamadhye kamapi mā namata ca| ");
INSERT INTO sanias_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","aparañca yūyaṁ yad yat niveśanaṁ praviśatha tatra niveśanasyāsya maṅgalaṁ bhūyāditi vākyaṁ prathamaṁ vadata| ");
INSERT INTO sanias_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","tasmāt tasmin niveśane yadi maṅgalapātraṁ sthāsyati tarhi tanmaṅgalaṁ tasya bhaviṣyati, nocet yuṣmān prati parāvarttiṣyate| ");
INSERT INTO sanias_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","aparañca te yatkiñcid dāsyanti tadeva bhuktvā pītvā tasminniveśane sthāsyatha; yataḥ karmmakārī jano bhṛtim arhati; gṛhād gṛhaṁ mā yāsyatha| ");
INSERT INTO sanias_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","anyacca yuṣmāsu kimapi nagaraṁ praviṣṭeṣu lokā yadi yuṣmākam ātithyaṁ kariṣyanti, tarhi yat khādyam upasthāsyanti tadeva khādiṣyatha| ");
INSERT INTO sanias_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","tannagarasthān rogiṇaḥ svasthān kariṣyatha, īśvarīyaṁ rājyaṁ yuṣmākam antikam āgamat kathāmetāñca pracārayiṣyatha| ");
INSERT INTO sanias_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","kintu kimapi puraṁ yuṣmāsu praviṣṭeṣu lokā yadi yuṣmākam ātithyaṁ na kariṣyanti, tarhi tasya nagarasya panthānaṁ gatvā kathāmetāṁ vadiṣyatha, ");
INSERT INTO sanias_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","yuṣmākaṁ nagarīyā yā dhūlyo'smāsu samalagan tā api yuṣmākaṁ prātikūlyena sākṣyārthaṁ sampātayāmaḥ; tathāpīśvararājyaṁ yuṣmākaṁ samīpam āgatam iti niścitaṁ jānīta| ");
INSERT INTO sanias_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","ahaṁ yuṣmabhyaṁ yathārthaṁ kathayāmi, vicāradine tasya nagarasya daśātaḥ sidomo daśā sahyā bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","hā hā korāsīn nagara, hā hā baitsaidānagara yuvayormadhye yādṛśāni āścaryyāṇi karmmāṇyakriyanta, tāni karmmāṇi yadi sorasīdono rnagarayorakāriṣyanta, tadā ito bahudinapūrvvaṁ tannivāsinaḥ śaṇavastrāṇi paridhāya gātreṣu bhasma vilipya samupaviśya samakhetsyanta| ");
INSERT INTO sanias_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","ato vicāradivase yuṣmākaṁ daśātaḥ sorasīdonnivāsināṁ daśā sahyā bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","he kapharnāhūm, tvaṁ svargaṁ yāvad unnatā kintu narakaṁ yāvat nyagbhaviṣyasi| ");
INSERT INTO sanias_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","yo jano yuṣmākaṁ vākyaṁ gṛhlāti sa mamaiva vākyaṁ gṛhlāti; kiñca yo jano yuṣmākam avajñāṁ karoti sa mamaivāvajñāṁ karoti; yo jano mamāvajñāṁ karoti ca sa matprerakasyaivāvajñāṁ karoti| ");
INSERT INTO sanias_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","atha te saptatiśiṣyā ānandena pratyāgatya kathayāmāsuḥ, he prabho bhavato nāmnā bhūtā apyasmākaṁ vaśībhavanti| ");
INSERT INTO sanias_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","tadānīṁ sa tān jagāda, vidyutamiva svargāt patantaṁ śaitānam adarśam| ");
INSERT INTO sanias_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","paśyata sarpān vṛścikān ripoḥ sarvvaparākramāṁśca padatalai rdalayituṁ yuṣmabhyaṁ śaktiṁ dadāmi tasmād yuṣmākaṁ kāpi hāni rna bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","bhūtā yuṣmākaṁ vaśībhavanti, etannimittat mā samullasata, svarge yuṣmākaṁ nāmāni likhitāni santīti nimittaṁ samullasata| ");
INSERT INTO sanias_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","tadghaṭikāyāṁ yīśu rmanasi jātāhlādaḥ kathayāmāsa he svargapṛthivyorekādhipate pitastvaṁ jñānavatāṁ viduṣāñca lokānāṁ purastāt sarvvametad aprakāśya bālakānāṁ purastāt prākāśaya etasmāddhetostvāṁ dhanyaṁ vadāmi, he pitaritthaṁ bhavatu yad etadeva tava gocara uttamam| ");
INSERT INTO sanias_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","pitrā sarvvāṇi mayi samarpitāni pitaraṁ vinā kopi putraṁ na jānāti kiñca putraṁ vinā yasmai janāya putrastaṁ prakāśitavān tañca vinā kopi pitaraṁ na jānāti| ");
INSERT INTO sanias_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","tapaḥ paraṁ sa śiṣyān prati parāvṛtya guptaṁ jagāda, yūyametāni sarvvāṇi paśyatha tato yuṣmākaṁ cakṣūṁṣi dhanyāni| ");
INSERT INTO sanias_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","yuṣmānahaṁ vadāmi, yūyaṁ yāni sarvvāṇi paśyatha tāni bahavo bhaviṣyadvādino bhūpatayaśca draṣṭumicchantopi draṣṭuṁ na prāpnuvan, yuṣmābhi ryā yāḥ kathāśca śrūyante tāḥ śrotumicchantopi śrotuṁ nālabhanta| ");
INSERT INTO sanias_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","anantaram eko vyavasthāpaka utthāya taṁ parīkṣituṁ papraccha, he upadeśaka anantāyuṣaḥ prāptaye mayā kiṁ karaṇīyaṁ? ");
INSERT INTO sanias_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","yīśuḥ pratyuvāca, atrārthe vyavasthāyāṁ kiṁ likhitamasti? tvaṁ kīdṛk paṭhasi? ");
INSERT INTO sanias_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","tataḥ sovadat, tvaṁ sarvvāntaḥkaraṇaiḥ sarvvaprāṇaiḥ sarvvaśaktibhiḥ sarvvacittaiśca prabhau parameśvare prema kuru, samīpavāsini svavat prema kuru ca| ");
INSERT INTO sanias_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","tadā sa kathayāmāsa, tvaṁ yathārthaṁ pratyavocaḥ, ittham ācara tenaiva jīviṣyasi| ");
INSERT INTO sanias_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","kintu sa janaḥ svaṁ nirddoṣaṁ jñāpayituṁ yīśuṁ papraccha, mama samīpavāsī kaḥ? tato yīśuḥ pratyuvāca, ");
INSERT INTO sanias_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","eko jano yirūśālampurād yirīhopuraṁ yāti, etarhi dasyūnāṁ kareṣu patite te tasya vastrādikaṁ hṛtavantaḥ tamāhatya mṛtaprāyaṁ kṛtvā tyaktvā yayuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","akasmād eko yājakastena mārgeṇa gacchan taṁ dṛṣṭvā mārgānyapārśvena jagāma| ");
INSERT INTO sanias_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ittham eko levīyastatsthānaṁ prāpya tasyāntikaṁ gatvā taṁ vilokyānyena pārśvena jagāma| ");
INSERT INTO sanias_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","kintvekaḥ śomiroṇīyo gacchan tatsthānaṁ prāpya taṁ dṛṣṭvādayata| ");
INSERT INTO sanias_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","tasyāntikaṁ gatvā tasya kṣateṣu tailaṁ drākṣārasañca prakṣipya kṣatāni baddhvā nijavāhanopari tamupaveśya pravāsīyagṛham ānīya taṁ siṣeve| ");
INSERT INTO sanias_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","parasmin divase nijagamanakāle dvau mudrāpādau tadgṛhasvāmine dattvāvadat janamenaṁ sevasva tatra yo'dhiko vyayo bhaviṣyati tamahaṁ punarāgamanakāle pariśotsyāmi| ");
INSERT INTO sanias_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","eṣāṁ trayāṇāṁ madhye tasya dasyuhastapatitasya janasya samīpavāsī kaḥ? tvayā kiṁ budhyate? ");
INSERT INTO sanias_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","tataḥ sa vyavasthāpakaḥ kathayāmāsa yastasmin dayāṁ cakāra| tadā yīśuḥ kathayāmāsa tvamapi gatvā tathācara| ");
INSERT INTO sanias_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","tataḥ paraṁ te gacchanta ekaṁ grāmaṁ praviviśuḥ; tadā marthānāmā strī svagṛhe tasyātithyaṁ cakāra| ");
INSERT INTO sanias_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","tasmāt mariyam nāmadheyā tasyā bhaginī yīśoḥ padasamīpa uvaviśya tasyopadeśakathāṁ śrotumārebhe| ");
INSERT INTO sanias_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","kintu marthā nānāparicaryyāyāṁ vyagrā babhūva tasmāddhetostasya samīpamāgatya babhāṣe; he prabho mama bhaginī kevalaṁ mamopari sarvvakarmmaṇāṁ bhāram arpitavatī tatra bhavatā kiñcidapi na mano nidhīyate kim? mama sāhāyyaṁ karttuṁ bhavān tāmādiśatu| ");
INSERT INTO sanias_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","tato yīśuḥ pratyuvāca he marthe he marthe, tvaṁ nānākāryyeṣu cintitavatī vyagrā cāsi, ");
INSERT INTO sanias_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","kintu prayojanīyam ekamātram āste| aparañca yamuttamaṁ bhāgaṁ kopi harttuṁ na śaknoti saeva mariyamā vṛtaḥ| ");
INSERT INTO sanias_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","anantaraṁ sa kasmiṁścit sthāne prārthayata tatsamāptau satyāṁ tasyaikaḥ śiṣyastaṁ jagāda he prabho yohan yathā svaśiṣyān prārthayitum upadiṣṭavān tathā bhavānapyasmān upadiśatu| ");
INSERT INTO sanias_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","tasmāt sa kathayāmāsa, prārthanakāle yūyam itthaṁ kathayadhvaṁ, he asmākaṁ svargasthapitastava nāma pūjyaṁ bhavatu; tava rājatvaṁ bhavatu; svarge yathā tathā pṛthivyāmapi tavecchayā sarvvaṁ bhavatu| ");
INSERT INTO sanias_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","pratyaham asmākaṁ prayojanīyaṁ bhojyaṁ dehi| ");
INSERT INTO sanias_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","yathā vayaṁ sarvvān aparādhinaḥ kṣamāmahe tathā tvamapi pāpānyasmākaṁ kṣamasva| asmān parīkṣāṁ mānaya kintu pāpātmano rakṣa| ");
INSERT INTO sanias_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","paścāt soparamapi kathitavān yadi yuṣmākaṁ kasyacid bandhustiṣṭhati niśīthe ca tasya samīpaṁ sa gatvā vadati, ");
INSERT INTO sanias_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","he bandho pathika eko bandhu rmama niveśanam āyātaḥ kintu tasyātithyaṁ karttuṁ mamāntike kimapi nāsti, ataeva pūpatrayaṁ mahyam ṛṇaṁ dehi; ");
INSERT INTO sanias_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","tadā sa yadi gṛhamadhyāt prativadati māṁ mā kliśāna, idānīṁ dvāraṁ ruddhaṁ śayane mayā saha bālakāśca tiṣṭhanti tubhyaṁ dātum utthātuṁ na śaknomi, ");
INSERT INTO sanias_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","tarhi yuṣmānahaṁ vadāmi, sa yadi mitratayā tasmai kimapi dātuṁ nottiṣṭhati tathāpi vāraṁ vāraṁ prārthanāta utthāpitaḥ san yasmin tasya prayojanaṁ tadeva dāsyati| ");
INSERT INTO sanias_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","ataḥ kāraṇāt kathayāmi, yācadhvaṁ tato yuṣmabhyaṁ dāsyate, mṛgayadhvaṁ tata uddeśaṁ prāpsyatha, dvāram āhata tato yuṣmabhyaṁ dvāraṁ mokṣyate| ");
INSERT INTO sanias_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","yo yācate sa prāpnoti, yo mṛgayate sa evoddeśaṁ prāpnoti, yo dvāram āhanti tadarthaṁ dvāraṁ mocyate| ");
INSERT INTO sanias_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","putreṇa pūpe yācite tasmai pāṣāṇaṁ dadāti vā matsye yācite tasmai sarpaṁ dadāti ");
INSERT INTO sanias_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","vā aṇḍe yācite tasmai vṛścikaṁ dadāti yuṣmākaṁ madhye ka etādṛśaḥ pitāste? ");
INSERT INTO sanias_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","tasmādeva yūyamabhadrā api yadi svasvabālakebhya uttamāni dravyāṇi dātuṁ jānītha tarhyasmākaṁ svargasthaḥ pitā nijayācakebhyaḥ kiṁ pavitram ātmānaṁ na dāsyati? ");
INSERT INTO sanias_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","anantaraṁ yīśunā kasmāccid ekasmin mūkabhūte tyājite sati sa bhūtatyakto mānuṣo vākyaṁ vaktum ārebhe; tato lokāḥ sakalā āścaryyaṁ menire| ");
INSERT INTO sanias_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","kintu teṣāṁ kecidūcu rjanoyaṁ bālasibūbā arthād bhūtarājena bhūtān tyājayati| ");
INSERT INTO sanias_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","taṁ parīkṣituṁ kecid ākāśīyam ekaṁ cihnaṁ darśayituṁ taṁ prārthayāñcakrire| ");
INSERT INTO sanias_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","tadā sa teṣāṁ manaḥkalpanāṁ jñātvā kathayāmāsa, kasyacid rājyasya lokā yadi parasparaṁ virundhanti tarhi tad rājyam naśyati; kecid gṛhasthā yadi parasparaṁ virundhanti tarhi tepi naśyanti| ");
INSERT INTO sanias_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","tathaiva śaitānapi svalokān yadi viruṇaddhi tadā tasya rājyaṁ kathaṁ sthāsyati? bālasibūbāhaṁ bhūtān tyājayāmi yūyamiti vadatha| ");
INSERT INTO sanias_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","yadyahaṁ bālasibūbā bhūtān tyājayāmi tarhi yuṣmākaṁ santānāḥ kena tyājayanti? tasmāt taeva kathāyā etasyā vicārayitāro bhaviṣyanti| ");
INSERT INTO sanias_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","kintu yadyaham īśvarasya parākrameṇa bhūtān tyājayāmi tarhi yuṣmākaṁ nikaṭam īśvarasya rājyamavaśyam upatiṣṭhati| ");
INSERT INTO sanias_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","balavān pumān susajjamāno yatikālaṁ nijāṭṭālikāṁ rakṣati tatikālaṁ tasya dravyaṁ nirupadravaṁ tiṣṭhati| ");
INSERT INTO sanias_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","kintu tasmād adhikabalaḥ kaścidāgatya yadi taṁ jayati tarhi yeṣu śastrāstreṣu tasya viśvāsa āsīt tāni sarvvāṇi hṛtvā tasya dravyāṇi gṛhlāti| ");
INSERT INTO sanias_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","ataḥ kāraṇād yo mama sapakṣo na sa vipakṣaḥ, yo mayā saha na saṁgṛhlāti sa vikirati| ");
INSERT INTO sanias_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","aparañca amedhyabhūto mānuṣasyāntarnirgatya śuṣkasthāne bhrāntvā viśrāmaṁ mṛgayate kintu na prāpya vadati mama yasmād gṛhād āgatohaṁ punastad gṛhaṁ parāvṛtya yāmi| ");
INSERT INTO sanias_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","tato gatvā tad gṛhaṁ mārjitaṁ śobhitañca dṛṣṭvā ");
INSERT INTO sanias_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","tatkṣaṇam apagatya svasmādapi durmmatīn aparān saptabhūtān sahānayati te ca tadgṛhaṁ paviśya nivasanti| tasmāt tasya manuṣyasya prathamadaśātaḥ śeṣadaśā duḥkhatarā bhavati| ");
INSERT INTO sanias_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","asyāḥ kathāyāḥ kathanakāle janatāmadhyasthā kācinnārī tamuccaiḥsvaraṁ provāca, yā yoṣit tvāṁ garbbhe'dhārayat stanyamapāyayacca saiva dhanyā| ");
INSERT INTO sanias_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","kintu sokathayat ye parameśvarasya kathāṁ śrutvā tadanurūpam ācaranti taeva dhanyāḥ| ");
INSERT INTO sanias_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","tataḥ paraṁ tasyāntike bahulokānāṁ samāgame jāte sa vaktumārebhe, ādhunikā duṣṭalokāścihnaṁ draṣṭumicchanti kintu yūnasbhaviṣyadvādinaścihnaṁ vinānyat kiñciccihnaṁ tān na darśayiṣyate| ");
INSERT INTO sanias_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","yūnas tu yathā nīnivīyalokānāṁ samīpe cihnarūpobhavat tathā vidyamānalokānām eṣāṁ samīpe manuṣyaputropi cihnarūpo bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","vicārasamaye idānīntanalokānāṁ prātikūlyena dakṣiṇadeśīyā rājñī protthāya tān doṣiṇaḥ kariṣyati, yataḥ sā rājñī sulemāna upadeśakathāṁ śrotuṁ pṛthivyāḥ sīmāta āgacchat kintu paśyata sulemānopi gurutara eko jano'smin sthāne vidyate| ");
INSERT INTO sanias_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","aparañca vicārasamaye nīnivīyalokā api varttamānakālikānāṁ lokānāṁ vaiparītyena protthāya tān doṣiṇaḥ kariṣyanti, yato hetoste yūnaso vākyāt cittāni parivarttayāmāsuḥ kintu paśyata yūnasotigurutara eko jano'smin sthāne vidyate| ");
INSERT INTO sanias_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","pradīpaṁ prajvālya droṇasyādhaḥ kutrāpi guptasthāne vā kopi na sthāpayati kintu gṛhapraveśibhyo dīptiṁ dātaṁ dīpādhāroparyyeva sthāpayati| ");
INSERT INTO sanias_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","dehasya pradīpaścakṣustasmādeva cakṣu ryadi prasannaṁ bhavati tarhi tava sarvvaśarīraṁ dīptimad bhaviṣyati kintu cakṣu ryadi malīmasaṁ tiṣṭhati tarhi sarvvaśarīraṁ sāndhakāraṁ sthāsyati| ");
INSERT INTO sanias_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","asmāt kāraṇāt tavāntaḥsthaṁ jyoti ryathāndhakāramayaṁ na bhavati tadarthe sāvadhāno bhava| ");
INSERT INTO sanias_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","yataḥ śarīrasya kutrāpyaṁśe sāndhakāre na jāte sarvvaṁ yadi dīptimat tiṣṭhati tarhi tubhyaṁ dīptidāyiprojjvalan pradīpa iva tava savarvaśarīraṁ dīptimad bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","etatkathāyāḥ kathanakāle phiruśyeko bhejanāya taṁ nimantrayāmāsa, tataḥ sa gatvā bhoktum upaviveśa| ");
INSERT INTO sanias_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","kintu bhojanāt pūrvvaṁ nāmāṅkṣīt etad dṛṣṭvā sa phiruśyāścaryyaṁ mene| ");
INSERT INTO sanias_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","tadā prabhustaṁ provāca yūyaṁ phirūśilokāḥ pānapātrāṇāṁ bhojanapātrāṇāñca bahiḥ pariṣkurutha kintu yuṣmākamanta rdaurātmyai rduṣkriyābhiśca paripūrṇaṁ tiṣṭhati| ");
INSERT INTO sanias_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","he sarvve nirbodhā yo bahiḥ sasarja sa eva kimanta rna sasarja? ");
INSERT INTO sanias_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","tata eva yuṣmābhirantaḥkaraṇaṁ (īśvarāya) nivedyatāṁ tasmin kṛte yuṣmākaṁ sarvvāṇi śucitāṁ yāsyanti| ");
INSERT INTO sanias_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","kintu hanta phirūśigaṇā yūyaṁ nyāyam īśvare prema ca parityajya podināyā arudādīnāṁ sarvveṣāṁ śākānāñca daśamāṁśān dattha kintu prathamaṁ pālayitvā śeṣasyālaṅghanaṁ yuṣmākam ucitamāsīt| ");
INSERT INTO sanias_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","hā hā phirūśino yūyaṁ bhajanagehe proccāsane āpaṇeṣu ca namaskāreṣu prīyadhve| ");
INSERT INTO sanias_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","vata kapaṭino'dhyāpakāḥ phirūśinaśca lokāyat śmaśānam anupalabhya tadupari gacchanti yūyam tādṛgaprakāśitaśmaśānavād bhavatha| ");
INSERT INTO sanias_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","tadānīṁ vyavasthāpakānām ekā yīśumavadat, he upadeśaka vākyenedṛśenāsmāsvapi doṣam āropayasi| ");
INSERT INTO sanias_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","tataḥ sa uvāca, hā hā vyavasthāpakā yūyam mānuṣāṇām upari duḥsahyān bhārān nyasyatha kintu svayam ekāṅguुlyāpi tān bhārān na spṛśatha| ");
INSERT INTO sanias_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","hanta yuṣmākaṁ pūrvvapuruṣā yān bhaviṣyadvādino'vadhiṣusteṣāṁ śmaśānāni yūyaṁ nirmmātha| ");
INSERT INTO sanias_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","tenaiva yūyaṁ svapūrvvapuruṣāṇāṁ karmmāṇi saṁmanyadhve tadeva sapramāṇaṁ kurutha ca, yataste tānavadhiṣuḥ yūyaṁ teṣāṁ śmaśānāni nirmmātha| ");
INSERT INTO sanias_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ataeva īśvarasya śāstre proktamasti teṣāmantike bhaviṣyadvādinaḥ preritāṁśca preṣayiṣyāmi tataste teṣāṁ kāṁścana haniṣyanti kāṁścana tāḍaśṣyinti| ");
INSERT INTO sanias_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","etasmāt kāraṇāt hābilaḥ śoṇitapātamārabhya mandirayajñavedyo rmadhye hatasya sikhariyasya raktapātaparyyantaṁ ");
INSERT INTO sanias_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","jagataḥ sṛṣṭimārabhya pṛthivyāṁ bhaviṣyadvādināṁ yatiraktapātā jātāstatīnām aparādhadaṇḍā eṣāṁ varttamānalokānāṁ bhaviṣyanti, yuṣmānahaṁ niścitaṁ vadāmi sarvve daṇḍā vaṁśasyāsya bhaviṣyanti| ");
INSERT INTO sanias_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","hā hā vyavasthapakā yūyaṁ jñānasya kuñcikāṁ hṛtvā svayaṁ na praviṣṭā ye praveṣṭuñca prayāsinastānapi praveṣṭuṁ vāritavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","itthaṁ kathākathanād adhyāpakāḥ phirūśinaśca satarkāḥ ");
INSERT INTO sanias_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","santastamapavadituṁ tasya kathāyā doṣaṁ dharttamicchanto nānākhyānakathanāya taṁ pravarttayituṁ kopayituñca prārebhire| ");
INSERT INTO sanias_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","tadānīṁ lokāḥ sahasraṁ sahasram āgatya samupasthitāstata ekaiko 'nyeṣāmupari patitum upacakrame; tadā yīśuḥ śiṣyān babhāṣe, yūyaṁ phirūśināṁ kiṇvarūpakāpaṭye viśeṣeṇa sāvadhānāstiṣṭhata| ");
INSERT INTO sanias_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","yato yanna prakāśayiṣyate tadācchannaṁ vastu kimapi nāsti; tathā yanna jñāsyate tad guptaṁ vastu kimapi nāsti| ");
INSERT INTO sanias_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","andhakāre tiṣṭhanato yāḥ kathā akathayata tāḥ sarvvāḥ kathā dīptau śroṣyante nirjane karṇe ca yadakathayata gṛhapṛṣṭhāt tat pracārayiṣyate| ");
INSERT INTO sanias_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","he bandhavo yuṣmānahaṁ vadāmi, ye śarīrasya nāśaṁ vinā kimapyaparaṁ karttuṁ na śakruvanti tebhyo mā bhaiṣṭa| ");
INSERT INTO sanias_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","tarhi kasmād bhetavyam ityahaṁ vadāmi, yaḥ śarīraṁ nāśayitvā narakaṁ nikṣeptuṁ śaknoti tasmādeva bhayaṁ kuruta, punarapi vadāmi tasmādeva bhayaṁ kuruta| ");
INSERT INTO sanias_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","pañca caṭakapakṣiṇaḥ kiṁ dvābhyāṁ tāmrakhaṇḍābhyāṁ na vikrīyante? tathāpīśvarasteṣām ekamapi na vismarati| ");
INSERT INTO sanias_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","yuṣmākaṁ śiraḥkeśā api gaṇitāḥ santi tasmāt mā vibhīta bahucaṭakapakṣibhyopi yūyaṁ bahumūlyāḥ| ");
INSERT INTO sanias_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","aparaṁ yuṣmabhyaṁ kathayāmi yaḥ kaścin mānuṣāṇāṁ sākṣān māṁ svīkaroti manuṣyaputra īśvaradūtānāṁ sākṣāt taṁ svīkariṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","kintu yaḥ kaścinmānuṣāṇāṁ sākṣānmām asvīkaroti tam īśvarasya dūtānāṁ sākṣād aham asvīkariṣyāmi| ");
INSERT INTO sanias_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","anyacca yaḥ kaścin manujasutasya nindābhāvena kāñcit kathāṁ kathayati tasya tatpāpasya mocanaṁ bhaviṣyati kintu yadi kaścit pavitram ātmānaṁ nindati tarhi tasya tatpāpasya mocanaṁ na bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","yadā lokā yuṣmān bhajanagehaṁ vicārakartṛrājyakartṛṇāṁ sammukhañca neṣyanti tadā kena prakāreṇa kimuttaraṁ vadiṣyatha kiṁ kathayiṣyatha cetyatra mā cintayata; ");
INSERT INTO sanias_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","yato yuṣmābhiryad yad vaktavyaṁ tat tasmin samayaeva pavitra ātmā yuṣmān śikṣayiṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","tataḥ paraṁ janatāmadhyasthaḥ kaścijjanastaṁ jagāda he guro mayā saha paitṛkaṁ dhanaṁ vibhaktuṁ mama bhrātaramājñāpayatu bhavān| ");
INSERT INTO sanias_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","kintu sa tamavadat he manuṣya yuvayo rvicāraṁ vibhāgañca karttuṁ māṁ ko niyuktavān? ");
INSERT INTO sanias_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","anantaraṁ sa lokānavadat lobhe sāvadhānāḥ satarkāśca tiṣṭhata, yato bahusampattiprāptyā manuṣyasyāyu rna bhavati| ");
INSERT INTO sanias_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","paścād dṛṣṭāntakathāmutthāpya kathayāmāsa, ekasya dhanino bhūmau bahūni śasyāni jātāni| ");
INSERT INTO sanias_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","tataḥ sa manasā cintayitvā kathayāmbabhūva mamaitāni samutpannāni dravyāṇi sthāpayituṁ sthānaṁ nāsti kiṁ kariṣyāmi? ");
INSERT INTO sanias_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","tatovadad itthaṁ kariṣyāmi, mama sarvvabhāṇḍāgārāṇi bhaṅktvā bṛhadbhāṇḍāgārāṇi nirmmāya tanmadhye sarvvaphalāni dravyāṇi ca sthāpayiṣyāmi| ");
INSERT INTO sanias_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","aparaṁ nijamano vadiṣyāmi, he mano bahuvatsarārthaṁ nānādravyāṇi sañcitāni santi viśrāmaṁ kuru bhuktvā pītvā kautukañca kuru| kintvīśvarastam avadat, ");
INSERT INTO sanias_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","re nirbodha adya rātrau tava prāṇāstvatto neṣyante tata etāni yāni dravyāṇi tvayāsāditāni tāni kasya bhaviṣyanti? ");
INSERT INTO sanias_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","ataeva yaḥ kaścid īśvarasya samīpe dhanasañcayamakṛtvā kevalaṁ svanikaṭe sañcayaṁ karoti sopi tādṛśaḥ| ");
INSERT INTO sanias_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","atha sa śiṣyebhyaḥ kathayāmāsa, yuṣmānahaṁ vadāmi, kiṁ khādiṣyāmaḥ? kiṁ paridhāsyāmaḥ? ityuktvā jīvanasya śarīrasya cārthaṁ cintāṁ mā kārṣṭa| ");
INSERT INTO sanias_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","bhakṣyājjīvanaṁ bhūṣaṇāccharīrañca śreṣṭhaṁ bhavati| ");
INSERT INTO sanias_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","kākapakṣiṇāṁ kāryyaṁ vicārayata, te na vapanti śasyāni ca na chindanti, teṣāṁ bhāṇḍāgārāṇi na santi koṣāśca na santi, tathāpīśvarastebhyo bhakṣyāṇi dadāti, yūyaṁ pakṣibhyaḥ śreṣṭhatarā na kiṁ? ");
INSERT INTO sanias_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","aparañca bhāvayitvā nijāyuṣaḥ kṣaṇamātraṁ varddhayituṁ śaknoti, etādṛśo lāko yuṣmākaṁ madhye kosti? ");
INSERT INTO sanias_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","ataeva kṣudraṁ kāryyaṁ sādhayitum asamarthā yūyam anyasmin kāryye kuto bhāvayatha? ");
INSERT INTO sanias_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","anyacca kāmpilapuṣpaṁ kathaṁ varddhate tadāpi vicārayata, tat kañcana śramaṁ na karoti tantūṁśca na janayati kintu yuṣmabhyaṁ yathārthaṁ kathayāmi sulemān bahvaiśvaryyānvitopi puṣpasyāsya sadṛśo vibhūṣito nāsīt| ");
INSERT INTO sanias_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","adya kṣetre varttamānaṁ śvaścūllyāṁ kṣepsyamānaṁ yat tṛṇaṁ, tasmai yadīśvara itthaṁ bhūṣayati tarhi he alpapratyayino yuṣmāna kiṁ na paridhāpayiṣyati? ");
INSERT INTO sanias_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","ataeva kiṁ khādiṣyāmaḥ? kiṁ paridhāsyāmaḥ? etadarthaṁ mā ceṣṭadhvaṁ mā saṁdigdhvañca| ");
INSERT INTO sanias_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","jagato devārccakā etāni sarvvāṇi ceṣṭanate; eṣu vastuṣu yuṣmākaṁ prayojanamāste iti yuṣmākaṁ pitā jānāti| ");
INSERT INTO sanias_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","ataeveśvarasya rājyārthaṁ saceṣṭā bhavata tathā kṛte sarvvāṇyetāni dravyāṇi yuṣmabhyaṁ pradāyiṣyante| ");
INSERT INTO sanias_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","he kṣudrameṣavraja yūyaṁ mā bhaiṣṭa yuṣmabhyaṁ rājyaṁ dātuṁ yuṣmākaṁ pituḥ sammatirasti| ");
INSERT INTO sanias_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ataeva yuṣmākaṁ yā yā sampattirasti tāṁ tāṁ vikrīya vitarata, yat sthānaṁ caurā nāgacchanti, kīṭāśca na kṣāyayanti tādṛśe svarge nijārtham ajare sampuṭake 'kṣayaṁ dhanaṁ sañcinuta ca; ");
INSERT INTO sanias_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","yato yatra yuṣmākaṁ dhanaṁ varttate tatreva yuṣmākaṁ manaḥ| ");
INSERT INTO sanias_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","aparañca yūyaṁ pradīpaṁ jvālayitvā baddhakaṭayastiṣṭhata; ");
INSERT INTO sanias_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","prabhu rvivāhādāgatya yadaiva dvāramāhanti tadaiva dvāraṁ mocayituṁ yathā bhṛtyā apekṣya tiṣṭhanti tathā yūyamapi tiṣṭhata| ");
INSERT INTO sanias_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","yataḥ prabhurāgatya yān dāsān sacetanān tiṣṭhato drakṣyati taeva dhanyāḥ; ahaṁ yuṣmān yathārthaṁ vadāmi prabhustān bhojanārtham upaveśya svayaṁ baddhakaṭiḥ samīpametya pariveṣayiṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","yadi dvitīye tṛtīye vā prahare samāgatya tathaiva paśyati, tarhi taeva dāsā dhanyāḥ| ");
INSERT INTO sanias_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","aparañca kasmin kṣaṇe caurā āgamiṣyanti iti yadi gṛhapati rjñātuṁ śaknoti tadāvaśyaṁ jāgran nijagṛhe sandhiṁ karttayituṁ vārayati yūyametad vitta| ");
INSERT INTO sanias_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","ataeva yūyamapi sajjamānāstiṣṭhata yato yasmin kṣaṇe taṁ nāprekṣadhve tasminneva kṣaṇe manuṣyaputra āgamiṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","tadā pitaraḥ papraccha, he prabho bhavān kimasmān uddiśya kiṁ sarvvān uddiśya dṛṣṭāntakathāmimāṁ vadati? ");
INSERT INTO sanias_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","tataḥ prabhuḥ provāca, prabhuḥ samucitakāle nijaparivārārthaṁ bhojyapariveṣaṇāya yaṁ tatpade niyokṣyati tādṛśo viśvāsyo boddhā karmmādhīśaḥ kosti? ");
INSERT INTO sanias_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","prabhurāgatya yam etādṛśe karmmaṇi pravṛttaṁ drakṣyati saeva dāso dhanyaḥ| ");
INSERT INTO sanias_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ahaṁ yuṣmān yathārthaṁ vadāmi sa taṁ nijasarvvasvasyādhipatiṁ kariṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","kintu prabhurvilambenāgamiṣyati, iti vicintya sa dāso yadi tadanyadāsīdāsān praharttum bhoktuṁ pātuṁ madituñca prārabhate, ");
INSERT INTO sanias_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","tarhi yadā prabhuṁ nāpekṣiṣyate yasmin kṣaṇe so'cetanaśca sthāsyati tasminneva kṣaṇe tasya prabhurāgatya taṁ padabhraṣṭaṁ kṛtvā viśvāsahīnaiḥ saha tasya aṁśaṁ nirūpayiṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","yo dāsaḥ prabheाrājñāṁ jñātvāpi sajjito na tiṣṭhati tadājñānusāreṇa ca kāryyaṁ na karoti sonekān prahārān prāpsyati; ");
INSERT INTO sanias_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","kintu yo jano'jñātvā prahārārhaṁ karmma karoti solpaprahārān prāpsyati| yato yasmai bāhulyena dattaṁ tasmādeva bāhulyena grahīṣyate, mānuṣā yasya nikaṭe bahu samarpayanti tasmād bahu yācante| ");
INSERT INTO sanias_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","ahaṁ pṛthivyām anaikyarūpaṁ vahni nikṣeptum āgatosmi, sa ced idānīmeva prajvalati tatra mama kā cintā? ");
INSERT INTO sanias_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","kintu yena majjanenāhaṁ magno bhaviṣyāmi yāvatkālaṁ tasya siddhi rna bhaviṣyati tāvadahaṁ katikaṣṭaṁ prāpsyāmi| ");
INSERT INTO sanias_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","melanaṁ karttuṁ jagad āgatosmi yūyaṁ kimitthaṁ bodhadhve? yuṣmān vadāmi na tathā, kintvahaṁ melanābhāvaṁ karttuṁm āgatosmi| ");
INSERT INTO sanias_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","yasmādetatkālamārabhya ekatrasthaparijanānāṁ madhye pañcajanāḥ pṛthag bhūtvā trayo janā dvayorjanayoḥ pratikūlā dvau janau ca trayāṇāṁ janānāṁ pratikūlau bhaviṣyanti| ");
INSERT INTO sanias_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","pitā putrasya vipakṣaḥ putraśca pitu rvipakṣo bhaviṣyati mātā kanyāyā vipakṣā kanyā ca mātu rvipakṣā bhaviṣyati, tathā śvaśrūrbadhvā vipakṣā badhūśca śvaśrvā vipakṣā bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","sa lokebhyoparamapi kathayāmāsa, paścimadiśi meghodgamaṁ dṛṣṭvā yūyaṁ haṭhād vadatha vṛṣṭi rbhaviṣyati tatastathaiva jāyate| ");
INSERT INTO sanias_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","aparaṁ dakṣiṇato vāyau vāti sati vadatha nidāgho bhaviṣyati tataḥ sopi jāyate| ");
INSERT INTO sanias_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","re re kapaṭina ākāśasya bhūmyāśca lakṣaṇaṁ boddhuṁ śaknutha, ");
INSERT INTO sanias_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","kintu kālasyāsya lakṣaṇaṁ kuto boddhuṁ na śaknutha? yūyañca svayaṁ kuto na nyāṣyaṁ vicārayatha? ");
INSERT INTO sanias_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","aparañca vivādinā sārddhaṁ vicārayituḥ samīpaṁ gacchan pathi tasmāduddhāraṁ prāptuṁ yatasva nocet sa tvāṁ dhṛtvā vicārayituḥ samīpaṁ nayati| vicārayitā yadi tvāṁ praharttuḥ samīpaṁ samarpayati praharttā tvāṁ kārāyāṁ badhnāti ");
INSERT INTO sanias_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","tarhi tvāmahaṁ vadāmi tvayā niḥśeṣaṁ kapardakeṣu na pariśodhiteṣu tvaṁ tato muktiṁ prāptuṁ na śakṣyasi| ");
INSERT INTO sanias_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","aparañca pīlāto yeṣāṁ gālīlīyānāṁ raktāni balīnāṁ raktaiḥ sahāmiśrayat teṣāṁ gālīlīyānāṁ vṛttāntaṁ katipayajanā upasthāpya yīśave kathayāmāsuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","tataḥ sa pratyuvāca teṣāṁ lokānām etādṛśī durgati rghaṭitā tatkāraṇād yūyaṁ kimanyebhyo gālīlīyebhyopyadhikapāpinastān bodhadhve? ");
INSERT INTO sanias_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","yuṣmānahaṁ vadāmi tathā na kintu manaḥsu na parāvarttiteṣu yūyamapi tathā naṁkṣyatha| ");
INSERT INTO sanias_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","aparañca śīlohanāmna uccagṛhasya patanād ye'ṣṭādaśajanā mṛtāste yirūśālami nivāsisarvvalokebhyo'dhikāparādhinaḥ kiṁ yūyamityaṁ bodhadhve? ");
INSERT INTO sanias_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","yuṣmānahaṁ vadāmi tathā na kintu manaḥsu na parivarttiteṣu yūyamapi tathā naṁkṣyatha| ");
INSERT INTO sanias_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","anantaraṁ sa imāṁ dṛṣṭāntakathāmakathayad eko jano drākṣākṣetramadhya ekamuḍumbaravṛkṣaṁ ropitavān| paścāt sa āgatya tasmin phalāni gaveṣayāmāsa, ");
INSERT INTO sanias_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","kintu phalāprāpteḥ kāraṇād udyānakāraṁ bhṛtyaṁ jagāda, paśya vatsaratrayaṁ yāvadāgatya etasminnuḍumbaratarau kṣalānyanvicchāmi, kintu naikamapi prapnomi tarurayaṁ kuto vṛthā sthānaṁ vyāpya tiṣṭhati? enaṁ chindhi| ");
INSERT INTO sanias_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","tato bhṛtyaḥ pratyuvāca, he prabho punarvarṣamekaṁ sthātum ādiśa; etasya mūlasya caturdikṣu khanitvāham ālavālaṁ sthāpayāmi| ");
INSERT INTO sanias_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","tataḥ phalituṁ śaknoti yadi na phalati tarhi paścāt chetsyasi| ");
INSERT INTO sanias_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","atha viśrāmavāre bhajanagehe yīśurupadiśati ");
INSERT INTO sanias_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","tasmit samaye bhūtagrastatvāt kubjībhūyāṣṭādaśavarṣāṇi yāvat kenāpyupāyena ṛju rbhavituṁ na śaknoti yā durbbalā strī, ");
INSERT INTO sanias_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","tāṁ tatropasthitāṁ vilokya yīśustāmāhūya kathitavān he nāri tava daurbbalyāt tvaṁ muktā bhava| ");
INSERT INTO sanias_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","tataḥ paraṁ tasyā gātre hastārpaṇamātrāt sā ṛjurbhūtveśvarasya dhanyavādaṁ karttumārebhe| ");
INSERT INTO sanias_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","kintu viśrāmavāre yīśunā tasyāḥ svāsthyakaraṇād bhajanagehasyādhipatiḥ prakupya lokān uvāca, ṣaṭsu dineṣu lokaiḥ karmma karttavyaṁ tasmāddhetoḥ svāsthyārthaṁ teṣu dineṣu āgacchata, viśrāmavāre māgacchata| ");
INSERT INTO sanias_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","tadā pabhuḥ pratyuvāca re kapaṭino yuṣmākam ekaiko jano viśrāmavāre svīyaṁ svīyaṁ vṛṣabhaṁ gardabhaṁ vā bandhanānmocayitvā jalaṁ pāyayituṁ kiṁ na nayati? ");
INSERT INTO sanias_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","tarhyāṣṭādaśavatsarān yāvat śaitānā baddhā ibrāhīmaḥ santatiriyaṁ nārī kiṁ viśrāmavāre na mocayitavyā? ");
INSERT INTO sanias_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","eṣu vākyeṣu kathiteṣu tasya vipakṣāḥ salajjā jātāḥ kintu tena kṛtasarvvamahākarmmakāraṇāt lokanivahaḥ sānando'bhavat| ");
INSERT INTO sanias_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","anantaraṁ sovadad īśvarasya rājyaṁ kasya sadṛśaṁ? kena tadupamāsyāmi? ");
INSERT INTO sanias_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","yat sarṣapabījaṁ gṛhītvā kaścijjana udyāna uptavān tad bījamaṅkuritaṁ sat mahāvṛkṣo'jāyata, tatastasya śākhāsu vihāyasīyavihagā āgatya nyūṣuḥ, tadrājyaṁ tādṛśena sarṣapabījena tulyaṁ| ");
INSERT INTO sanias_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","punaḥ kathayāmāsa, īśvarasya rājyaṁ kasya sadṛśaṁ vadiṣyāmi? yat kiṇvaṁ kācit strī gṛhītvā droṇatrayaparimitagodhūmacūrṇeṣu sthāpayāmāsa, ");
INSERT INTO sanias_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","tataḥ krameṇa tat sarvvagodhūmacūrṇaṁ vyāpnoti, tasya kiṇvasya tulyam īśvarasya rājyaṁ| ");
INSERT INTO sanias_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","tataḥ sa yirūśālamnagaraṁ prati yātrāṁ kṛtvā nagare nagare grāme grāme samupadiśan jagāma| ");
INSERT INTO sanias_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","tadā kaścijjanastaṁ papraccha, he prabho kiṁ kevalam alpe lokāḥ paritrāsyante? ");
INSERT INTO sanias_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","tataḥ sa lokān uvāca, saṁkīrṇadvāreṇa praveṣṭuṁ yataghvaṁ, yatohaṁ yuṣmān vadāmi, bahavaḥ praveṣṭuṁ ceṣṭiṣyante kintu na śakṣyanti| ");
INSERT INTO sanias_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","gṛhapatinotthāya dvāre ruddhe sati yadi yūyaṁ bahiḥ sthitvā dvāramāhatya vadatha, he prabho he prabho asmatkāraṇād dvāraṁ mocayatu, tataḥ sa iti prativakṣyati, yūyaṁ kutratyā lokā ityahaṁ na jānāmi| ");
INSERT INTO sanias_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","tadā yūyaṁ vadiṣyatha, tava sākṣād vayaṁ bheाjanaṁ pānañca kṛtavantaḥ, tvañcāsmākaṁ nagarasya pathi samupadiṣṭavān| ");
INSERT INTO sanias_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","kintu sa vakṣyati, yuṣmānahaṁ vadāmi, yūyaṁ kutratyā lokā ityahaṁ na jānāmi; he durācāriṇo yūyaṁ matto dūrībhavata| ");
INSERT INTO sanias_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","tadā ibrāhīmaṁ ishākaṁ yākūbañca sarvvabhaviṣyadvādinaśca īśvarasya rājyaṁ prāptān svāṁśca bahiṣkṛtān dṛṣṭvā yūyaṁ rodanaṁ dantairdantagharṣaṇañca kariṣyatha| ");
INSERT INTO sanias_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","aparañca pūrvvapaścimadakṣiṇottaradigbhyo lokā āgatya īśvarasya rājye nivatsyanti| ");
INSERT INTO sanias_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","paśyatetthaṁ śeṣīyā lokā agrā bhaviṣyanti, agrīyā lokāśca śeṣā bhaviṣyanti| ");
INSERT INTO sanias_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","aparañca tasmin dine kiyantaḥ phirūśina āgatya yīśuṁ procuḥ, bahirgaccha, sthānādasmāt prasthānaṁ kuru, herod tvāṁ jighāṁsati| ");
INSERT INTO sanias_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","tataḥ sa pratyavocat paśyatādya śvaśca bhūtān vihāpya rogiṇo'rogiṇaḥ kṛtvā tṛtīyehni setsyāmi, kathāmetāṁ yūyamitvā taṁ bhūrimāyaṁ vadata| ");
INSERT INTO sanias_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","tatrāpyadya śvaḥ paraśvaśca mayā gamanāgamane karttavye, yato heto ryirūśālamo bahiḥ kutrāpi kopi bhaviṣyadvādī na ghāniṣyate| ");
INSERT INTO sanias_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","he yirūśālam he yirūśālam tvaṁ bhaviṣyadvādino haṁsi tavāntike preritān prastarairmārayasi ca, yathā kukkuṭī nijapakṣādhaḥ svaśāvakān saṁgṛhlāti, tathāhamapi tava śiśūn saṁgrahītuṁ kativārān aicchaṁ kintu tvaṁ naicchaḥ| ");
INSERT INTO sanias_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","paśyata yuṣmākaṁ vāsasthānāni procchidyamānāni parityaktāni ca bhaviṣyanti; yuṣmānahaṁ yathārthaṁ vadāmi, yaḥ prabho rnāmnāgacchati sa dhanya iti vācaṁ yāvatkālaṁ na vadiṣyatha, tāvatkālaṁ yūyaṁ māṁ na drakṣyatha| ");
INSERT INTO sanias_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","anantaraṁ viśrāmavāre yīśau pradhānasya phirūśino gṛhe bhoktuṁ gatavati te taṁ vīkṣitum ārebhire| ");
INSERT INTO sanias_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","tadā jalodarī tasya sammukhe sthitaḥ| ");
INSERT INTO sanias_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","tataḥ sa vyavasthāpakān phirūśinaśca papraccha, viśrāmavāre svāsthyaṁ karttavyaṁ na vā? tataste kimapi na pratyūcuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","tadā sa taṁ rogiṇaṁ svasthaṁ kṛtvā visasarja; ");
INSERT INTO sanias_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","tānuvāca ca yuṣmākaṁ kasyacid garddabho vṛṣabho vā ced gartte patati tarhi viśrāmavāre tatkṣaṇaṁ sa kiṁ taṁ notthāpayiṣyati? ");
INSERT INTO sanias_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","tataste kathāyā etasyāḥ kimapi prativaktuṁ na śekuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","aparañca pradhānasthānamanonītatvakaraṇaṁ vilokya sa nimantritān etadupadeśakathāṁ jagāda, ");
INSERT INTO sanias_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","tvaṁ vivāhādibhojyeṣu nimantritaḥ san pradhānasthāne mopāvekṣīḥ| tvatto gauravānvitanimantritajana āyāte ");
INSERT INTO sanias_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","nimantrayitāgatya manuṣyāyaitasmai sthānaṁ dehīti vākyaṁ ced vakṣyati tarhi tvaṁ saṅkucito bhūtvā sthāna itarasmin upaveṣṭum udyaṁsyasi| ");
INSERT INTO sanias_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","asmāt kāraṇādeva tvaṁ nimantrito gatvā'pradhānasthāna upaviśa, tato nimantrayitāgatya vadiṣyati, he bandho proccasthānaṁ gatvopaviśa, tathā sati bhojanopaviṣṭānāṁ sakalānāṁ sākṣāt tvaṁ mānyo bhaviṣyasi| ");
INSERT INTO sanias_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","yaḥ kaścit svamunnamayati sa namayiṣyate, kintu yaḥ kaścit svaṁ namayati sa unnamayiṣyate| ");
INSERT INTO sanias_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","tadā sa nimantrayitāraṁ janamapi jagāda, madhyāhne rātrau vā bhojye kṛte nijabandhugaṇo vā bhrātṛृgaṇo vā jñātigaṇo vā dhanigaṇo vā samīpavāsigaṇo vā etān na nimantraya, tathā kṛte cet te tvāṁ nimantrayiṣyanti, tarhi pariśodho bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","kintu yadā bhejyaṁ karoṣi tadā daridraśuṣkakarakhañjāndhān nimantraya, ");
INSERT INTO sanias_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","tata āśiṣaṁ lapsyase, teṣu pariśodhaṁ karttumaśaknuvatsu śmaśānāddhārmmikānāmutthānakāle tvaṁ phalāṁ lapsyase| ");
INSERT INTO sanias_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","anantaraṁ tāṁ kathāṁ niśamya bhojanopaviṣṭaḥ kaścit kathayāmāsa, yo jana īśvarasya rājye bhoktuṁ lapsyate saeva dhanyaḥ| ");
INSERT INTO sanias_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","tataḥ sa uvāca, kaścit jano rātrau bheाjyaṁ kṛtvā bahūn nimantrayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","tato bhojanasamaye nimantritalokān āhvātuṁ dāsadvārā kathayāmāsa, khadyadravyāṇi sarvvāṇi samāsāditāni santi, yūyamāgacchata| ");
INSERT INTO sanias_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","kintu te sarvva ekaikaṁ chalaṁ kṛtvā kṣamāṁ prārthayāñcakrire| prathamo janaḥ kathayāmāsa, kṣetramekaṁ krītavānahaṁ tadeva draṣṭuṁ mayā gantavyam, ataeva māṁ kṣantuṁ taṁ nivedaya| ");
INSERT INTO sanias_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","anyo janaḥ kathayāmāsa, daśavṛṣānahaṁ krītavān tān parīkṣituṁ yāmi tasmādeva māṁ kṣantuṁ taṁ nivedaya| ");
INSERT INTO sanias_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","aparaḥ kathayāmāsa, vyūḍhavānahaṁ tasmāt kāraṇād yātuṁ na śaknomi| ");
INSERT INTO sanias_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","paścāt sa dāso gatvā nijaprabhoḥ sākṣāt sarvvavṛttāntaṁ nivedayāmāsa, tatosau gṛhapatiḥ kupitvā svadāsaṁ vyājahāra, tvaṁ satvaraṁ nagarasya sanniveśān mārgāṁśca gatvā daridraśuṣkakarakhañjāndhān atrānaya| ");
INSERT INTO sanias_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","tato dāso'vadat, he prabho bhavata ājñānusāreṇākriyata tathāpi sthānamasti| ");
INSERT INTO sanias_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","tadā prabhuḥ puna rdāsāyākathayat, rājapathān vṛkṣamūlāni ca yātvā madīyagṛhapūraṇārthaṁ lokānāgantuṁ pravarttaya| ");
INSERT INTO sanias_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ahaṁ yuṣmabhyaṁ kathayāmi, pūrvvanimantritānamekopi mamāsya rātribhojyasyāsvādaṁ na prāpsyati| ");
INSERT INTO sanias_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","anantaraṁ bahuṣu lokeṣu yīśoḥ paścād vrajiteṣu satsu sa vyāghuṭya tebhyaḥ kathayāmāsa, ");
INSERT INTO sanias_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","yaḥ kaścin mama samīpam āgatya svasya mātā pitā patnī santānā bhrātaro bhagimyo nijaprāṇāśca, etebhyaḥ sarvvebhyo mayyadhikaṁ prema na karoti, sa mama śiṣyo bhavituṁ na śakṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","yaḥ kaścit svīyaṁ kruśaṁ vahan mama paścānna gacchati, sopi mama śiṣyo bhavituṁ na śakṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","durganirmmāṇe kativyayo bhaviṣyati, tathā tasya samāptikaraṇārthaṁ sampattirasti na vā, prathamamupaviśya etanna gaṇayati, yuṣmākaṁ madhya etādṛśaḥ kosti? ");
INSERT INTO sanias_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","noced bhittiṁ kṛtvā śeṣe yadi samāpayituṁ na śakṣyati, ");
INSERT INTO sanias_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","tarhi mānuṣoyaṁ nicetum ārabhata samāpayituṁ nāśaknot, iti vyāhṛtya sarvve tamupahasiṣyanti| ");
INSERT INTO sanias_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","aparañca bhinnabhūpatinā saha yuddhaṁ karttum udyamya daśasahasrāṇi sainyāni gṛhītvā viṁśatisahasreḥ sainyaiḥ sahitasya samīpavāsinaḥ sammukhaṁ yātuṁ śakṣyāmi na veti prathamaṁ upaviśya na vicārayati etādṛśo bhūmipatiḥ kaḥ? ");
INSERT INTO sanias_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","yadi na śaknoti tarhi ripāvatidūre tiṣṭhati sati nijadūtaṁ preṣya sandhiṁ karttuṁ prārthayeta| ");
INSERT INTO sanias_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","tadvad yuṣmākaṁ madhye yaḥ kaścin madarthaṁ sarvvasvaṁ hātuṁ na śaknoti sa mama śiṣyo bhavituṁ na śakṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","lavaṇam uttamam iti satyaṁ, kintu yadi lavaṇasya lavaṇatvam apagacchati tarhi tat kathaṁ svāduyuktaṁ bhaviṣyati? ");
INSERT INTO sanias_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","tada bhūmyartham ālavālarāśyarthamapi bhadraṁ na bhavati; lokāstad bahiḥ kṣipanti|yasya śrotuṁ śrotre staḥ sa śṛṇotu| ");
INSERT INTO sanias_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","tadā karasañcāyinaḥ pāpinaśca lokā upadeśkathāṁ śrotuṁ yīśoḥ samīpam āgacchan| ");
INSERT INTO sanias_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","tataḥ phirūśina upādhyāyāśca vivadamānāḥ kathayāmāsuḥ eṣa mānuṣaḥ pāpibhiḥ saha praṇayaṁ kṛtvā taiḥ sārddhaṁ bhuṁkte| ");
INSERT INTO sanias_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","tadā sa tebhya imāṁ dṛṣṭāntakathāṁ kathitavān, ");
INSERT INTO sanias_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","kasyacit śatameṣeṣu tiṣṭhatmu teṣāmekaṁ sa yadi hārayati tarhi madhyeprāntaram ekonaśatameṣān vihāya hāritameṣasya uddeśaprāptiparyyanataṁ na gaveṣayati, etādṛśo loko yuṣmākaṁ madhye ka āste? ");
INSERT INTO sanias_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","tasyoddeśaṁ prāpya hṛṣṭamanāstaṁ skandhe nidhāya svasthānam ānīya bandhubāndhavasamīpavāsina āhūya vakti, ");
INSERT INTO sanias_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","hāritaṁ meṣaṁ prāptoham ato heto rmayā sārddham ānandata| ");
INSERT INTO sanias_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","tadvadahaṁ yuṣmān vadāmi, yeṣāṁ manaḥparāvarttanasya prayojanaṁ nāsti, tādṛśaikonaśatadhārmmikakāraṇād ya ānandastasmād ekasya manaḥparivarttinaḥ pāpinaḥ kāraṇāt svarge 'dhikānando jāyate| ");
INSERT INTO sanias_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","aparañca daśānāṁ rūpyakhaṇḍānām ekakhaṇḍe hārite pradīpaṁ prajvālya gṛhaṁ sammārjya tasya prāptiṁ yāvad yatnena na gaveṣayati, etādṛśī yoṣit kāste? ");
INSERT INTO sanias_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","prāpte sati bandhubāndhavasamīpavāsinīrāhūya kathayati, hāritaṁ rūpyakhaṇḍaṁ prāptāhaṁ tasmādeva mayā sārddham ānandata| ");
INSERT INTO sanias_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","tadvadahaṁ yuṣmān vyāharāmi, ekena pāpinā manasi parivarttite, īśvarasya dūtānāṁ madhyepyānando jāyate| ");
INSERT INTO sanias_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","aparañca sa kathayāmāsa, kasyacid dvau putrāvāstāṁ, ");
INSERT INTO sanias_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","tayoḥ kaniṣṭhaḥ putraḥ pitre kathayāmāsa, he pitastava sampattyā yamaṁśaṁ prāpsyāmyahaṁ vibhajya taṁ dehi, tataḥ pitā nijāṁ sampattiṁ vibhajya tābhyāṁ dadau| ");
INSERT INTO sanias_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","katipayāt kālāt paraṁ sa kaniṣṭhaputraḥ samastaṁ dhanaṁ saṁgṛhya dūradeśaṁ gatvā duṣṭācaraṇena sarvvāṁ sampattiṁ nāśayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","tasya sarvvadhane vyayaṁ gate taddeśe mahādurbhikṣaṁ babhūva, tatastasya dainyadaśā bhavitum ārebhe| ");
INSERT INTO sanias_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","tataḥ paraṁ sa gatvā taddeśīyaṁ gṛhasthamekam āśrayata; tataḥ sataṁ śūkaravrajaṁ cārayituṁ prāntaraṁ preṣayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","kenāpi tasmai bhakṣyādānāt sa śūkaraphalavalkalena piciṇḍapūraṇāṁ vavāñcha| ");
INSERT INTO sanias_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","śeṣe sa manasi cetanāṁ prāpya kathayāmāsa, hā mama pituḥ samīpe kati kati vetanabhujo dāsā yatheṣṭaṁ tatodhikañca bhakṣyaṁ prāpnuvanti kintvahaṁ kṣudhā mumūrṣuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ahamutthāya pituḥ samīpaṁ gatvā kathāmetāṁ vadiṣyāmi, he pitar īśvarasya tava ca viruddhaṁ pāpamakaravam ");
INSERT INTO sanias_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","tava putra̮iti vikhyāto bhavituṁ na yogyosmi ca, māṁ tava vaitanikaṁ dāsaṁ kṛtvā sthāpaya| ");
INSERT INTO sanias_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","paścāt sa utthāya pituḥ samīpaṁ jagāma; tatastasya pitātidūre taṁ nirīkṣya dayāñcakre, dhāvitvā tasya kaṇṭhaṁ gṛhītvā taṁ cucumba ca| ");
INSERT INTO sanias_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","tadā putra uvāca, he pitar īśvarasya tava ca viruddhaṁ pāpamakaravaṁ, tava putra̮iti vikhyāto bhavituṁ na yogyosmi ca| ");
INSERT INTO sanias_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","kintu tasya pitā nijadāsān ādideśa, sarvvottamavastrāṇyānīya paridhāpayatainaṁ haste cāṅgurīyakam arpayata pādayoścopānahau samarpayata; ");
INSERT INTO sanias_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","puṣṭaṁ govatsam ānīya mārayata ca taṁ bhuktvā vayam ānandāma| ");
INSERT INTO sanias_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","yato mama putroyam amriyata punarajīvīd hāritaśca labdhobhūt tatasta ānanditum ārebhire| ");
INSERT INTO sanias_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","tatkāle tasya jyeṣṭhaḥ putraḥ kṣetra āsīt| atha sa niveśanasya nikaṭaṁ āgacchan nṛtyānāṁ vādyānāñca śabdaṁ śrutvā ");
INSERT INTO sanias_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","dāsānām ekam āhūya papraccha, kiṁ kāraṇamasya? ");
INSERT INTO sanias_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","tataḥ sovādīt, tava bhrātāgamat, tava tātaśca taṁ suśarīraṁ prāpya puṣṭaṁ govatsaṁ māritavān| ");
INSERT INTO sanias_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","tataḥ sa prakupya niveśanāntaḥ praveṣṭuṁ na sammene; tatastasya pitā bahirāgatya taṁ sādhayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","tataḥ sa pitaraṁ pratyuvāca, paśya tava kāñcidapyājñāṁ na vilaṁghya bahūn vatsarān ahaṁ tvāṁ seve tathāpi mitraiḥ sārddham utsavaṁ karttuṁ kadāpi chāgamekamapi mahyaṁ nādadāḥ; ");
INSERT INTO sanias_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","kintu tava yaḥ putro veśyāgamanādibhistava sampattim apavyayitavān tasminnāgatamātre tasyaiva nimittaṁ puṣṭaṁ govatsaṁ māritavān| ");
INSERT INTO sanias_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","tadā tasya pitāvocat, he putra tvaṁ sarvvadā mayā sahāsi tasmān mama yadyadāste tatsarvvaṁ tava| ");
INSERT INTO sanias_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","kintu tavāyaṁ bhrātā mṛtaḥ punarajīvīd hāritaśca bhūtvā prāptobhūt, etasmāt kāraṇād utsavānandau karttum ucitamasmākam| ");
INSERT INTO sanias_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","aparañca yīśuḥ śiṣyebhyonyāmekāṁ kathāṁ kathayāmāsa kasyacid dhanavato manuṣyasya gṛhakāryyādhīśe sampatterapavyaye'pavādite sati ");
INSERT INTO sanias_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","tasya prabhustam āhūya jagāda, tvayi yāmimāṁ kathāṁ śṛṇomi sā kīdṛśī? tvaṁ gṛhakāryyādhīśakarmmaṇo gaṇanāṁ darśaya gṛhakāryyādhīśapade tvaṁ na sthāsyasi| ");
INSERT INTO sanias_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","tadā sa gṛhakāryyādhīśo manasā cintayāmāsa, prabhu ryadi māṁ gṛhakāryyādhīśapadād bhraṁśayati tarhi kiṁ kariṣye'haṁ? mṛdaṁ khanituṁ mama śakti rnāsti bhikṣituñca lajjiṣye'haṁ| ");
INSERT INTO sanias_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ataeva mayi gṛhakāryyādhīśapadāt cyute sati yathā lokā mahyam āśrayaṁ dāsyanti tadarthaṁ yatkarmma mayā karaṇīyaṁ tan nirṇīyate| ");
INSERT INTO sanias_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","paścāt sa svaprabhorekaikam adhamarṇam āhūya prathamaṁ papraccha, tvatto me prabhuṇā kati prāpyam? ");
INSERT INTO sanias_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","tataḥ sa uvāca, ekaśatāḍhakatailāni; tadā gṛhakāryyādhīśaḥ provāca, tava patramānīya śīghramupaviśya tatra pañcāśataṁ likha| ");
INSERT INTO sanias_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","paścādanyamekaṁ papraccha, tvatto me prabhuṇā kati prāpyam? tataḥ sovādīd ekaśatāḍhakagodhūmāḥ; tadā sa kathayāmāsa, tava patramānīya aśītiṁ likha| ");
INSERT INTO sanias_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","tenaiva prabhustamayathārthakṛtam adhīśaṁ tadbuddhinaipuṇyāt praśaśaṁsa; itthaṁ dīptirūpasantānebhya etatsaṁsārasya santānā varttamānakāle'dhikabuddhimanto bhavanti| ");
INSERT INTO sanias_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","ato vadāmi yūyamapyayathārthena dhanena mitrāṇi labhadhvaṁ tato yuṣmāsu padabhraṣṭeṣvapi tāni cirakālam āśrayaṁ dāsyanti| ");
INSERT INTO sanias_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","yaḥ kaścit kṣudre kāryye viśvāsyo bhavati sa mahati kāryyepi viśvāsyo bhavati, kintu yaḥ kaścit kṣudre kāryye'viśvāsyo bhavati sa mahati kāryyepyaviśvāsyo bhavati| ");
INSERT INTO sanias_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ataeva ayathārthena dhanena yadi yūyamaviśvāsyā jātāstarhi satyaṁ dhanaṁ yuṣmākaṁ kareṣu kaḥ samarpayiṣyati? ");
INSERT INTO sanias_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","yadi ca paradhanena yūyam aviśvāsyā bhavatha tarhi yuṣmākaṁ svakīyadhanaṁ yuṣmabhyaṁ ko dāsyati? ");
INSERT INTO sanias_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","kopi dāsa ubhau prabhū sevituṁ na śaknoti, yata ekasmin prīyamāṇo'nyasminnaprīyate yadvā ekaṁ janaṁ samādṛtya tadanyaṁ tucchīkaroti tadvad yūyamapi dhaneśvarau sevituṁ na śaknutha| ");
INSERT INTO sanias_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","tadaitāḥ sarvvāḥ kathāḥ śrutvā lobhiphirūśinastamupajahasuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","tataḥ sa uvāca, yūyaṁ manuṣyāṇāṁ nikaṭe svān nirdoṣān darśayatha kintu yuṣmākam antaḥkaraṇānīśvaro jānāti, yat manuṣyāṇām ati praśaṁsyaṁ tad īśvarasya ghṛṇyaṁ| ");
INSERT INTO sanias_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","yohana āgamanaparyyanataṁ yuṣmākaṁ samīpe vyavasthābhaviṣyadvādināṁ lekhanāni cāsan tataḥ prabhṛti īśvararājyasya susaṁvādaḥ pracarati, ekaiko lokastanmadhyaṁ yatnena praviśati ca| ");
INSERT INTO sanias_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","varaṁ nabhasaḥ pṛthivyāśca lopo bhaviṣyati tathāpi vyavasthāyā ekabindorapi lopo na bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","yaḥ kaścit svīyāṁ bhāryyāṁ vihāya striyamanyāṁ vivahati sa paradārān gacchati, yaśca tā tyaktāṁ nārīṁ vivahati sopi paradārāna gacchati| ");
INSERT INTO sanias_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","eko dhanī manuṣyaḥ śuklāni sūkṣmāṇi vastrāṇi paryyadadhāt pratidinaṁ paritoṣarūpeṇābhuṁktāpivacca| ");
INSERT INTO sanias_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","sarvvāṅge kṣatayukta iliyāsaranāmā kaścid daridrastasya dhanavato bhojanapātrāt patitam ucchiṣṭaṁ bhoktuṁ vāñchan tasya dvāre patitvātiṣṭhat; ");
INSERT INTO sanias_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","atha śvāna āgatya tasya kṣatānyalihan| ");
INSERT INTO sanias_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","kiyatkālātparaṁ sa daridraḥ prāṇān jahau; tataḥ svargīyadūtāstaṁ nītvā ibrāhīmaḥ kroḍa upaveśayāmāsuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","paścāt sa dhanavānapi mamāra, taṁ śmaśāne sthāpayāmāsuśca; kintu paraloke sa vedanākulaḥ san ūrddhvāṁ nirīkṣya bahudūrād ibrāhīmaṁ tatkroḍa iliyāsarañca vilokya ruvannuvāca; ");
INSERT INTO sanias_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","he pitar ibrāhīm anugṛhya aṅgulyagrabhāgaṁ jale majjayitvā mama jihvāṁ śītalāṁ karttum iliyāsaraṁ preraya, yato vahniśikhātohaṁ vyathitosmi| ");
INSERT INTO sanias_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","tadā ibrāhīm babhāṣe, he putra tvaṁ jīvan sampadaṁ prāptavān iliyāsarastu vipadaṁ prāptavān etat smara, kintu samprati tasya sukhaṁ tava ca duḥkhaṁ bhavati| ");
INSERT INTO sanias_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","aparamapi yuṣmākam asmākañca sthānayo rmadhye mahadvicchedo'sti tata etatsthānasya lokāstat sthānaṁ yātuṁ yadvā tatsthānasya lokā etat sthānamāyātuṁ na śaknuvanti| ");
INSERT INTO sanias_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","tadā sa uktavān, he pitastarhi tvāṁ nivedayāmi mama pitu rgehe ye mama pañca bhrātaraḥ santi ");
INSERT INTO sanias_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","te yathaitad yātanāsthānaṁ nāyāsyanti tathā mantraṇāṁ dātuṁ teṣāṁ samīpam iliyāsaraṁ preraya| ");
INSERT INTO sanias_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","tata ibrāhīm uvāca, mūsābhaviṣyadvādināñca pustakāni teṣāṁ nikaṭe santi te tadvacanāni manyantāṁ| ");
INSERT INTO sanias_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","tadā sa nivedayāmāsa, he pitar ibrāhīm na tathā, kintu yadi mṛtalokānāṁ kaścit teṣāṁ samīpaṁ yāti tarhi te manāṁsi vyāghoṭayiṣyanti| ");
INSERT INTO sanias_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","tata ibrāhīm jagāda, te yadi mūsābhaviṣyadvādināñca vacanāni na manyante tarhi mṛtalokānāṁ kasmiṁścid utthitepi te tasya mantraṇāṁ na maṁsyante| ");
INSERT INTO sanias_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","itaḥ paraṁ yīśuḥ śiṣyān uvāca, vighnairavaśyam āgantavyaṁ kintu vighnā yena ghaṭiṣyante tasya durgati rbhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","eteṣāṁ kṣudraprāṇinām ekasyāpi vighnajananāt kaṇṭhabaddhapeṣaṇīkasya tasya sāgarāgādhajale majjanaṁ bhadraṁ| ");
INSERT INTO sanias_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","yūyaṁ sveṣu sāvadhānāstiṣṭhata; tava bhrātā yadi tava kiñcid aparādhyati tarhi taṁ tarjaya, tena yadi manaḥ parivarttayati tarhi taṁ kṣamasva| ");
INSERT INTO sanias_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","punarekadinamadhye yadi sa tava saptakṛtvo'parādhyati kintu saptakṛtva āgatya manaḥ parivartya mayāparāddham iti vadati tarhi taṁ kṣamasva| ");
INSERT INTO sanias_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","tadā preritāḥ prabhum avadan asmākaṁ viśvāsaṁ varddhaya| ");
INSERT INTO sanias_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","prabhuruvāca, yadi yuṣmākaṁ sarṣapaikapramāṇo viśvāsosti tarhi tvaṁ samūlamutpāṭito bhūtvā samudre ropito bhava kathāyām etasyām etaduḍumbarāya kathitāyāṁ sa yuṣmākamājñāvaho bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","aparaṁ svadāse halaṁ vāhayitvā vā paśūn cārayitvā kṣetrād āgate sati taṁ vadati, ehi bhoktumupaviśa, yuṣmākam etādṛśaḥ kosti? ");
INSERT INTO sanias_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","varañca pūrvvaṁ mama khādyamāsādya yāvad bhuñje pivāmi ca tāvad baddhakaṭiḥ paricara paścāt tvamapi bhokṣyase pāsyasi ca kathāmīdṛśīṁ kiṁ na vakṣyati? ");
INSERT INTO sanias_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","tena dāsena prabhorājñānurūpe karmmaṇi kṛte prabhuḥ kiṁ tasmin bādhito jātaḥ? netthaṁ budhyate mayā| ");
INSERT INTO sanias_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","itthaṁ nirūpiteṣu sarvvakarmmasu kṛteṣu satmu yūyamapīdaṁ vākyaṁ vadatha, vayam anupakāriṇo dāsā asmābhiryadyatkarttavyaṁ tanmātrameva kṛtaṁ| ");
INSERT INTO sanias_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","sa yirūśālami yātrāṁ kurvvan śomiroṇgālīlpradeśamadhyena gacchati, ");
INSERT INTO sanias_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","etarhi kutracid grāme praveśamātre daśakuṣṭhinastaṁ sākṣāt kṛtvā ");
INSERT INTO sanias_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","dūre tiṣṭhanata uccai rvaktumārebhire, he prabho yīśo dayasvāsmān| ");
INSERT INTO sanias_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","tataḥ sa tān dṛṣṭvā jagāda, yūyaṁ yājakānāṁ samīpe svān darśayata, tataste gacchanto rogāt pariṣkṛtāḥ| ");
INSERT INTO sanias_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","tadā teṣāmekaḥ svaṁ svasthaṁ dṛṣṭvā proccairīśvaraṁ dhanyaṁ vadan vyāghuṭyāyāto yīśo rguṇānanuvadan taccaraṇādhobhūmau papāta; ");
INSERT INTO sanias_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","sa cāsīt śomiroṇī| ");
INSERT INTO sanias_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","tadā yīśuravadat, daśajanāḥ kiṁ na pariṣkṛtāḥ? tahyanye navajanāḥ kutra? ");
INSERT INTO sanias_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","īśvaraṁ dhanyaṁ vadantam enaṁ videśinaṁ vinā kopyanyo na prāpyata| ");
INSERT INTO sanias_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","tadā sa tamuvāca, tvamutthāya yāhi viśvāsaste tvāṁ svasthaṁ kṛtavān| ");
INSERT INTO sanias_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","atha kadeśvarasya rājatvaṁ bhaviṣyatīti phirūśibhiḥ pṛṣṭe sa pratyuvāca, īśvarasya rājatvam aiśvaryyadarśanena na bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ata etasmin paśya tasmin vā paśya, iti vākyaṁ lokā vaktuṁ na śakṣyanti, īśvarasya rājatvaṁ yuṣmākam antarevāste| ");
INSERT INTO sanias_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","tataḥ sa śiṣyān jagāda, yadā yuṣmābhi rmanujasutasya dinamekaṁ draṣṭum vāñchiṣyate kintu na darśiṣyate, īdṛkkāla āyāti| ");
INSERT INTO sanias_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","tadātra paśya vā tatra paśyeti vākyaṁ lokā vakṣyanti, kintu teṣāṁ paścāt mā yāta, mānugacchata ca| ");
INSERT INTO sanias_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","yatastaḍid yathākāśaikadiśyudiya tadanyāmapi diśaṁ vyāpya prakāśate tadvat nijadine manujasūnuḥ prakāśiṣyate| ");
INSERT INTO sanias_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","kintu tatpūrvvaṁ tenānekāni duḥkhāni bhoktavyānyetadvarttamānalokaiśca so'vajñātavyaḥ| ");
INSERT INTO sanias_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","nohasya vidyamānakāle yathābhavat manuṣyasūnoḥ kālepi tathā bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","yāvatkālaṁ noho mahāpotaṁ nārohad āplāvivāryyetya sarvvaṁ nānāśayacca tāvatkālaṁ yathā lokā abhuñjatāpivan vyavahan vyavāhayaṁśca; ");
INSERT INTO sanias_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","itthaṁ loṭo varttamānakālepi yathā lokā bhojanapānakrayavikrayaropaṇagṛhanirmmāṇakarmmasu prāvarttanta, ");
INSERT INTO sanias_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","kintu yadā loṭ sidomo nirjagāma tadā nabhasaḥ sagandhakāgnivṛṣṭi rbhūtvā sarvvaṁ vyanāśayat ");
INSERT INTO sanias_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","tadvan mānavaputraprakāśadinepi bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","tadā yadi kaścid gṛhopari tiṣṭhati tarhi sa gṛhamadhyāt kimapi dravyamānetum avaruhya naitu; yaśca kṣetre tiṣṭhati sopi vyāghuṭya nāyātu| ");
INSERT INTO sanias_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","loṭaḥ patnīṁ smarata| ");
INSERT INTO sanias_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","yaḥ prāṇān rakṣituṁ ceṣṭiṣyate sa prāṇān hārayiṣyati yastu prāṇān hārayiṣyati saeva prāṇān rakṣiṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","yuṣmānahaṁ vacmi tasyāṁ rātrau śayyaikagatayo rlokayoreko dhāriṣyate parastyakṣyate| ");
INSERT INTO sanias_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","striyau yugapat peṣaṇīṁ vyāvarttayiṣyatastayorekā dhāriṣyate parātyakṣyate| ");
INSERT INTO sanias_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","puruṣau kṣetre sthāsyatastayoreko dhāriṣyate parastyakṣyate| ");
INSERT INTO sanias_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","tadā te papracchuḥ, he prabho kutretthaṁ bhaviṣyati? tataḥ sa uvāca, yatra śavastiṣṭhati tatra gṛdhrā milanti| ");
INSERT INTO sanias_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","aparañca lokairaklāntai rnirantaraṁ prārthayitavyam ityāśayena yīśunā dṛṣṭānta ekaḥ kathitaḥ| ");
INSERT INTO sanias_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","kutracinnagare kaścit prāḍvivāka āsīt sa īśvarānnābibhet mānuṣāṁśca nāmanyata| ");
INSERT INTO sanias_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","atha tatpuravāsinī kācidvidhavā tatsamīpametya vivādinā saha mama vivādaṁ pariṣkurvviti nivedayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","tataḥ sa prāḍvivākaḥ kiyaddināni na tadaṅgīkṛtavān paścāccitte cintayāmāsa, yadyapīśvarānna bibhemi manuṣyānapi na manye ");
INSERT INTO sanias_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","tathāpyeṣā vidhavā māṁ kliśnāti tasmādasyā vivādaṁ pariṣkariṣyāmi nocet sā sadāgatya māṁ vyagraṁ kariṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","paścāt prabhuravadad asāvanyāyaprāḍvivāko yadāha tatra mano nidhadhvaṁ| ");
INSERT INTO sanias_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","īśvarasya ye 'bhirucitalokā divāniśaṁ prārthayante sa bahudināni vilambyāpi teṣāṁ vivādān kiṁ na pariṣkariṣyati? ");
INSERT INTO sanias_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","yuṣmānahaṁ vadāmi tvarayā pariṣkariṣyati, kintu yadā manuṣyaputra āgamiṣyati tadā pṛthivyāṁ kimīdṛśaṁ viśvāsaṁ prāpsyati? ");
INSERT INTO sanias_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ye svān dhārmmikān jñātvā parān tucchīkurvvanti etādṛgbhyaḥ, kiyadbhya imaṁ dṛṣṭāntaṁ kathayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","ekaḥ phirūśyaparaḥ karasañcāyī dvāvimau prārthayituṁ mandiraṁ gatau| ");
INSERT INTO sanias_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","tato'sau phirūśyekapārśve tiṣṭhan he īśvara ahamanyalokavat loṭhayitānyāyī pāradārikaśca na bhavāmi asya karasañcāyinastulyaśca na, tasmāttvāṁ dhanyaṁ vadāmi| ");
INSERT INTO sanias_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","saptasu dineṣu dinadvayamupavasāmi sarvvasampatte rdaśamāṁśaṁ dadāmi ca, etatkathāṁ kathayan prārthayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","kintu sa karasañcāyi dūre tiṣṭhan svargaṁ draṣṭuṁ necchan vakṣasi karāghātaṁ kurvvan he īśvara pāpiṣṭhaṁ māṁ dayasva, itthaṁ prārthayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","yuṣmānahaṁ vadāmi, tayordvayo rmadhye kevalaḥ karasañcāyī puṇyavattvena gaṇito nijagṛhaṁ jagāma, yato yaḥ kaścit svamunnamayati sa nāmayiṣyate kintu yaḥ kaścit svaṁ namayati sa unnamayiṣyate| ");
INSERT INTO sanias_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","atha śiśūnāṁ gātrasparśārthaṁ lokāstān tasya samīpamāninyuḥ śiṣyāstad dṛṣṭvānetṛn tarjayāmāsuḥ, ");
INSERT INTO sanias_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","kintu yīśustānāhūya jagāda, mannikaṭam āgantuṁ śiśūn anujānīdhvaṁ tāṁśca mā vārayata; yata īśvararājyādhikāriṇa eṣāṁ sadṛśāḥ| ");
INSERT INTO sanias_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ahaṁ yuṣmān yathārthaṁ vadāmi, yo janaḥ śiśoḥ sadṛśo bhūtvā īśvararājyaṁ na gṛhlāti sa kenāpi prakāreṇa tat praveṣṭuṁ na śaknoti| ");
INSERT INTO sanias_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","aparam ekodhipatistaṁ papraccha, he paramaguro, anantāyuṣaḥ prāptaye mayā kiṁ karttavyaṁ? ");
INSERT INTO sanias_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","yīśuruvāca, māṁ kutaḥ paramaṁ vadasi? īśvaraṁ vinā kopi paramo na bhavati| ");
INSERT INTO sanias_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","paradārān mā gaccha, naraṁ mā jahi, mā coraya, mithyāsākṣyaṁ mā dehi, mātaraṁ pitarañca saṁmanyasva, etā yā ājñāḥ santi tāstvaṁ jānāsi| ");
INSERT INTO sanias_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","tadā sa uvāca, bālyakālāt sarvvā etā ācarāmi| ");
INSERT INTO sanias_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","iti kathāṁ śrutvā yīśustamavadat, tathāpi tavaikaṁ karmma nyūnamāste, nijaṁ sarvvasvaṁ vikrīya daridrebhyo vitara, tasmāt svarge dhanaṁ prāpsyasi; tata āgatya mamānugāmī bhava| ");
INSERT INTO sanias_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","kintvetāṁ kathāṁ śrutvā sodhipatiḥ śuśoca, yatastasya bahudhanamāsīt| ");
INSERT INTO sanias_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","tadā yīśustamatiśokānvitaṁ dṛṣṭvā jagāda, dhanavatām īśvararājyapraveśaḥ kīdṛg duṣkaraḥ| ");
INSERT INTO sanias_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","īśvararājye dhaninaḥ praveśāt sūceśchidreṇa mahāṅgasya gamanāgamane sukare| ");
INSERT INTO sanias_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","śrotāraḥ papracchustarhi kena paritrāṇaṁ prāpsyate? ");
INSERT INTO sanias_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","sa uktavān, yan mānuṣeṇāśakyaṁ tad īśvareṇa śakyaṁ| ");
INSERT INTO sanias_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","tadā pitara uvāca, paśya vayaṁ sarvvasvaṁ parityajya tava paścādgāmino'bhavāma| ");
INSERT INTO sanias_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","tataḥ sa uvāca, yuṣmānahaṁ yathārthaṁ vadāmi, īśvararājyārthaṁ gṛhaṁ pitarau bhrātṛgaṇaṁ jāyāṁ santānāṁśca tyaktavā ");
INSERT INTO sanias_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","iha kāle tato'dhikaṁ parakāle 'nantāyuśca na prāpsyati loka īdṛśaḥ kopi nāsti| ");
INSERT INTO sanias_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","anantaraṁ sa dvādaśaśiṣyānāhūya babhāṣe, paśyata vayaṁ yirūśālamnagaraṁ yāmaḥ, tasmāt manuṣyaputre bhaviṣyadvādibhiruktaṁ yadasti tadanurūpaṁ taṁ prati ghaṭiṣyate; ");
INSERT INTO sanias_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","vastutastu so'nyadeśīyānāṁ hasteṣu samarpayiṣyate, te tamupahasiṣyanti, anyāyamācariṣyanti tadvapuṣi niṣṭhīvaṁ nikṣepsyanti, kaśābhiḥ prahṛtya taṁ haniṣyanti ca, ");
INSERT INTO sanias_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","kintu tṛtīyadine sa śmaśānād utthāsyati| ");
INSERT INTO sanias_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","etasyāḥ kathāyā abhiprāyaṁ kiñcidapi te boddhuṁ na śekuḥ teṣāṁ nikaṭe'spaṣṭatavāt tasyaitāsāṁ kathānām āśayaṁ te jñātuṁ na śekuśca| ");
INSERT INTO sanias_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","atha tasmin yirīhoḥ purasyāntikaṁ prāpte kaścidandhaḥ pathaḥ pārśva upaviśya bhikṣām akarot ");
INSERT INTO sanias_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","sa lokasamūhasya gamanaśabdaṁ śrutvā tatkāraṇaṁ pṛṣṭavān| ");
INSERT INTO sanias_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","nāsaratīyayīśuryātīti lokairukte sa uccairvaktumārebhe, ");
INSERT INTO sanias_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","he dāyūdaḥ santāna yīśo māṁ dayasva| ");
INSERT INTO sanias_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","tatogragāminastaṁ maunī tiṣṭheti tarjayāmāsuḥ kintu sa punāruvan uvāca, he dāyūdaḥ santāna māṁ dayasva| ");
INSERT INTO sanias_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","tadā yīśuḥ sthagito bhūtvā svāntike tamānetum ādideśa| ");
INSERT INTO sanias_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","tataḥ sa tasyāntikam āgamat, tadā sa taṁ papraccha, tvaṁ kimicchasi? tvadarthamahaṁ kiṁ kariṣyāmi? sa uktavān, he prabho'haṁ draṣṭuṁ labhai| ");
INSERT INTO sanias_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","tadā yīśuruvāca, dṛṣṭiśaktiṁ gṛhāṇa tava pratyayastvāṁ svasthaṁ kṛtavān| ");
INSERT INTO sanias_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","tatastatkṣaṇāt tasya cakṣuṣī prasanne; tasmāt sa īśvaraṁ dhanyaṁ vadan tatpaścād yayau, tadālokya sarvve lokā īśvaraṁ praśaṁsitum ārebhire| ");
INSERT INTO sanias_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","yadā yīśu ryirīhopuraṁ praviśya tanmadhyena gacchaṁstadā ");
INSERT INTO sanias_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","sakkeyanāmā karasañcāyināṁ pradhāno dhanavāneko ");
INSERT INTO sanias_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","yīśuḥ kīdṛgiti draṣṭuṁ ceṣṭitavān kintu kharvvatvāllokasaṁghamadhye taddarśanamaprāpya ");
INSERT INTO sanias_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","yena pathā sa yāsyati tatpathe'gre dhāvitvā taṁ draṣṭum uḍumbaratarumāruroha| ");
INSERT INTO sanias_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","paścād yīśustatsthānam itvā ūrddhvaṁ vilokya taṁ dṛṣṭvāvādīt, he sakkeya tvaṁ śīghramavaroha mayādya tvadgehe vastavyaṁ| ");
INSERT INTO sanias_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","tataḥ sa śīghramavaruhya sāhlādaṁ taṁ jagrāha| ");
INSERT INTO sanias_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","tad dṛṣṭvā sarvve vivadamānā vaktumārebhire, sotithitvena duṣṭalokagṛhaṁ gacchati| ");
INSERT INTO sanias_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","kintu sakkeyo daṇḍāyamāno vaktumārebhe, he prabho paśya mama yā sampattirasti tadarddhaṁ daridrebhyo dade, aparam anyāyaṁ kṛtvā kasmādapi yadi kadāpi kiñcit mayā gṛhītaṁ tarhi taccaturguṇaṁ dadāmi| ");
INSERT INTO sanias_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","tadā yīśustamuktavān ayamapi ibrāhīmaḥ santāno'taḥ kāraṇād adyāsya gṛhe trāṇamupasthitaṁ| ");
INSERT INTO sanias_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","yad hāritaṁ tat mṛgayituṁ rakṣituñca manuṣyaputra āgatavān| ");
INSERT INTO sanias_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","atha sa yirūśālamaḥ samīpa upātiṣṭhad īśvararājatvasyānuṣṭhānaṁ tadaiva bhaviṣyatīti lokairanvabhūyata, tasmāt sa śrotṛbhyaḥ punardṛṣṭāntakathām utthāpya kathayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","kopi mahālloko nijārthaṁ rājatvapadaṁ gṛhītvā punarāgantuṁ dūradeśaṁ jagāma| ");
INSERT INTO sanias_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","yātrākāle nijān daśadāsān āhūya daśasvarṇamudrā dattvā mamāgamanaparyyantaṁ vāṇijyaṁ kurutetyādideśa| ");
INSERT INTO sanias_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","kintu tasya prajāstamavajñāya manuṣyamenam asmākamupari rājatvaṁ na kārayivyāma imāṁ vārttāṁ tannikaṭe prerayāmāsuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","atha sa rājatvapadaṁ prāpyāgatavān ekaiko jano bāṇijyena kiṁ labdhavān iti jñātuṁ yeṣu dāseṣu mudrā arpayat tān āhūyānetum ādideśa| ");
INSERT INTO sanias_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","tadā prathama āgatya kathitavān, he prabho tava tayaikayā mudrayā daśamudrā labdhāḥ| ");
INSERT INTO sanias_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","tataḥ sa uvāca tvamuttamo dāsaḥ svalpena viśvāsyo jāta itaḥ kāraṇāt tvaṁ daśanagarāṇām adhipo bhava| ");
INSERT INTO sanias_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","dvitīya āgatya kathitavān, he prabho tavaikayā mudrayā pañcamudrā labdhāḥ| ");
INSERT INTO sanias_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","tataḥ sa uvāca, tvaṁ pañcānāṁ nagarāṇāmadhipati rbhava| ");
INSERT INTO sanias_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","tatonya āgatya kathayāmāsa, he prabho paśya tava yā mudrā ahaṁ vastre baddhvāsthāpayaṁ seyaṁ| ");
INSERT INTO sanias_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","tvaṁ kṛpaṇo yannāsthāpayastadapi gṛhlāsi, yannāvapastadeva ca chinatsi tatohaṁ tvatto bhītaḥ| ");
INSERT INTO sanias_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","tadā sa jagāda, re duṣṭadāsa tava vākyena tvāṁ doṣiṇaṁ kariṣyāmi, yadahaṁ nāsthāpayaṁ tadeva gṛhlāmi, yadahaṁ nāvapañca tadeva chinadmi, etādṛśaḥ kṛpaṇohamiti yadi tvaṁ jānāsi, ");
INSERT INTO sanias_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","tarhi mama mudrā baṇijāṁ nikaṭe kuto nāsthāpayaḥ? tayā kṛte'ham āgatya kusīdena sārddhaṁ nijamudrā aprāpsyam| ");
INSERT INTO sanias_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","paścāt sa samīpasthān janān ājñāpayat asmāt mudrā ānīya yasya daśamudrāḥ santi tasmai datta| ");
INSERT INTO sanias_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","te procuḥ prabho'sya daśamudrāḥ santi| ");
INSERT INTO sanias_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","yuṣmānahaṁ vadāmi yasyāśraye vaddhate 'dhikaṁ tasmai dāyiṣyate, kintu yasyāśraye na varddhate tasya yadyadasti tadapi tasmān nāyiṣyate| ");
INSERT INTO sanias_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","kintu mamādhipatitvasya vaśatve sthātum asammanyamānā ye mama ripavastānānīya mama samakṣaṁ saṁharata| ");
INSERT INTO sanias_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ityupadeśakathāṁ kathayitvā sogragaḥ san yirūśālamapuraṁ yayau| ");
INSERT INTO sanias_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","tato baitphagībaithanīyāgrāmayoḥ samīpe jaitunādrerantikam itvā śiṣyadvayam ityuktvā preṣayāmāsa, ");
INSERT INTO sanias_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","yuvāmamuṁ sammukhasthagrāmaṁ praviśyaiva yaṁ kopi mānuṣaḥ kadāpi nārohat taṁ garddabhaśāvakaṁ baddhaṁ drakṣyathastaṁ mocayitvānayataṁ| ");
INSERT INTO sanias_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","tatra kuto mocayathaḥ? iti cet kopi vakṣyati tarhi vakṣyathaḥ prabheाratra prayojanam āste| ");
INSERT INTO sanias_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","tadā tau praritau gatvā tatkathāाnusāreṇa sarvvaṁ prāptau| ");
INSERT INTO sanias_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","gardabhaśāvakamocanakāle tatvāmina ūcuḥ, gardabhaśāvakaṁ kuto mocayathaḥ? ");
INSERT INTO sanias_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","tāvūcatuḥ prabhoratra prayojanam āste| ");
INSERT INTO sanias_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","paścāt tau taṁ gardabhaśāvakaṁ yīśorantikamānīya tatpṛṣṭhe nijavasanāni pātayitvā tadupari yīśumārohayāmāsatuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","atha yātrākāle lokāḥ pathi svavastrāṇi pātayitum ārebhire| ");
INSERT INTO sanias_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","aparaṁ jaitunādrerupatyakām itvā śiṣyasaṁghaḥ pūrvvadṛṣṭāni mahākarmmāṇi smṛtvā, ");
INSERT INTO sanias_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","yo rājā prabho rnāmnāyāti sa dhanyaḥ svarge kuśalaṁ sarvvocce jayadhvani rbhavatu, kathāmetāṁ kathayitvā sānandam ucairīśvaraṁ dhanyaṁ vaktumārebhe| ");
INSERT INTO sanias_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","tadā lokāraṇyamadhyasthāḥ kiyantaḥ phirūśinastat śrutvā yīśuṁ procuḥ, he upadeśaka svaśiṣyān tarjaya| ");
INSERT INTO sanias_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","sa uvāca, yuṣmānahaṁ vadāmi yadyamī nīravāstiṣṭhanti tarhi pāṣāṇā ucaiḥ kathāḥ kathayiṣyanti| ");
INSERT INTO sanias_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","paścāt tatpurāntikametya tadavalokya sāśrupātaṁ jagāda, ");
INSERT INTO sanias_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","hā hā cet tvamagre'jñāsyathāḥ, tavāsminneva dine vā yadi svamaṅgalam upālapsyathāḥ, tarhyuttamam abhaviṣyat, kintu kṣaṇesmin tattava dṛṣṭeragocaram bhavati| ");
INSERT INTO sanias_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","tvaṁ svatrāṇakāle na mano nyadhatthā iti heto ryatkāle tava ripavastvāṁ caturdikṣu prācīreṇa veṣṭayitvā rotsyanti ");
INSERT INTO sanias_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","bālakaiḥ sārddhaṁ bhūmisāt kariṣyanti ca tvanmadhye pāṣāṇaikopi pāṣāṇopari na sthāsyati ca, kāla īdṛśa upasthāsyati| ");
INSERT INTO sanias_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","atha madhyemandiraṁ praviśya tatratyān krayivikrayiṇo bahiṣkurvvan ");
INSERT INTO sanias_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","avadat madgṛhaṁ prārthanāgṛhamiti lipirāste kintu yūyaṁ tadeva cairāṇāṁ gahvaraṁ kurutha| ");
INSERT INTO sanias_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","paścāt sa pratyahaṁ madhyemandiram upadideśa; tataḥ pradhānayājakā adhyāpakāḥ prācīnāśca taṁ nāśayituṁ ciceṣṭire; ");
INSERT INTO sanias_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","kintu tadupadeśe sarvve lokā niviṣṭacittāḥ sthitāstasmāt te tatkarttuṁ nāvakāśaṁ prāpuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","athaikadā yīśu rmanidare susaṁvādaṁ pracārayan lokānupadiśati, etarhi pradhānayājakā adhyāpakāḥ prāñcaśca tannikaṭamāgatya papracchuḥ ");
INSERT INTO sanias_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","kayājñayā tvaṁ karmmāṇyetāni karoṣi? ko vā tvāmājñāpayat? tadasmān vada| ");
INSERT INTO sanias_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","sa pratyuvāca, tarhi yuṣmānapi kathāmekāṁ pṛcchāmi tasyottaraṁ vadata| ");
INSERT INTO sanias_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","yohano majjanam īśvarasya mānuṣāṇāṁ vājñāto jātaṁ? ");
INSERT INTO sanias_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","tataste mitho vivicya jagaduḥ, yadīśvarasya vadāmastarhi taṁ kuto na pratyaita sa iti vakṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","yadi manuṣyasyeti vadāmastarhi sarvve lokā asmān pāṣāṇai rhaniṣyanti yato yohan bhaviṣyadvādīti sarvve dṛḍhaṁ jānanti| ");
INSERT INTO sanias_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ataeva te pratyūcuḥ kasyājñayā jātam iti vaktuṁ na śaknumaḥ| ");
INSERT INTO sanias_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","tadā yīśuravadat tarhi kayājñayā karmmāṇyetāti karomīti ca yuṣmān na vakṣyāmi| ");
INSERT INTO sanias_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","atha lokānāṁ sākṣāt sa imāṁ dṛṣṭāntakathāṁ vaktumārebhe, kaścid drākṣākṣetraṁ kṛtvā tat kṣetraṁ kṛṣīvalānāṁ hasteṣu samarpya bahukālārthaṁ dūradeśaṁ jagāma| ");
INSERT INTO sanias_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","atha phalakāle phalāni grahītu kṛṣīvalānāṁ samīpe dāsaṁ prāhiṇot kintu kṛṣīvalāstaṁ prahṛtya riktahastaṁ visasarjuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","tataḥ sodhipatiḥ punaranyaṁ dāsaṁ preṣayāmāsa, te tamapi prahṛtya kuvyavahṛtya riktahastaṁ visasṛjuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","tataḥ sa tṛtīyavāram anyaṁ prāhiṇot te tamapi kṣatāṅgaṁ kṛtvā bahi rnicikṣipuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","tadā kṣetrapati rvicārayāmāsa, mamedānīṁ kiṁ karttavyaṁ? mama priye putre prahite te tamavaśyaṁ dṛṣṭvā samādariṣyante| ");
INSERT INTO sanias_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","kintu kṛṣīvalāstaṁ nirīkṣya parasparaṁ vivicya procuḥ, ayamuttarādhikārī āgacchatainaṁ hanmastatodhikārosmākaṁ bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","tataste taṁ kṣetrād bahi rnipātya jaghnustasmāt sa kṣetrapatistān prati kiṁ kariṣyati? ");
INSERT INTO sanias_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","sa āgatya tān kṛṣīvalān hatvā pareṣāṁ hasteṣu tatkṣetraṁ samarpayiṣyati; iti kathāṁ śrutvā te 'vadan etādṛśī ghaṭanā na bhavatu| ");
INSERT INTO sanias_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","kintu yīśustānavalokya jagāda, tarhi, sthapatayaḥ kariṣyanti grāvāṇaṁ yantu tucchakaṁ| pradhānaprastaraḥ koṇe sa eva hi bhaviṣyati| etasya śāstrīyavacanasya kiṁ tātparyyaṁ? ");
INSERT INTO sanias_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","aparaṁ tatpāṣāṇopari yaḥ patiṣyati sa bhaṁkṣyate kintu yasyopari sa pāṣāṇaḥ patiṣyati sa tena dhūlivac cūrṇībhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","sosmākaṁ viruddhaṁ dṛṣṭāntamimaṁ kathitavān iti jñātvā pradhānayājakā adhyāpakāśca tadaiva taṁ dhartuṁ vavāñchuḥ kintu lokebhyo bibhyuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ataeva taṁ prati satarkāḥ santaḥ kathaṁ tadvākyadoṣaṁ dhṛtvā taṁ deśādhipasya sādhuveśadhāriṇaścarān tasya samīpe preṣayāmāsuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","tadā te taṁ papracchuḥ, he upadeśaka bhavān yathārthaṁ kathayan upadiśati, kamapyanapekṣya satyatvenaiśvaraṁ mārgamupadiśati, vayametajjānīmaḥ| ");
INSERT INTO sanias_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","kaisararājāya karosmābhi rdeyo na vā? ");
INSERT INTO sanias_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","sa teṣāṁ vañcanaṁ jñātvāvadat kuto māṁ parīkṣadhve? māṁ mudrāmekaṁ darśayata| ");
INSERT INTO sanias_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","iha likhitā mūrtiriyaṁ nāma ca kasya? te'vadan kaisarasya| ");
INSERT INTO sanias_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","tadā sa uvāca, tarhi kaisarasya dravyaṁ kaisarāya datta; īśvarasya tu dravyamīśvarāya datta| ");
INSERT INTO sanias_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","tasmāllokānāṁ sākṣāt tatkathāyāḥ kamapi doṣaṁ dhartumaprāpya te tasyottarād āścaryyaṁ manyamānā mauninastasthuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","aparañca śmaśānādutthānānaṅgīkāriṇāṁ sidūkināṁ kiyanto janā āgatya taṁ papracchuḥ, ");
INSERT INTO sanias_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","he upadeśaka śāstre mūsā asmān pratīti lilekha yasya bhrātā bhāryyāyāṁ satyāṁ niḥsantāno mriyate sa tajjāyāṁ vivahya tadvaṁśam utpādayiṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","tathāca kecit sapta bhrātara āsan teṣāṁ jyeṣṭho bhrātā vivahya nirapatyaḥ prāṇān jahau| ");
INSERT INTO sanias_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","atha dvitīyastasya jāyāṁ vivahya nirapatyaḥ san mamāra| tṛtīyaśca tāmeva vyuvāha; ");
INSERT INTO sanias_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","itthaṁ sapta bhrātarastāmeva vivahya nirapatyāḥ santo mamruḥ| ");
INSERT INTO sanias_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","śeṣe sā strī ca mamāra| ");
INSERT INTO sanias_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ataeva śmaśānādutthānakāle teṣāṁ saptajanānāṁ kasya sā bhāryyā bhaviṣyati? yataḥ sā teṣāṁ saptānāmeva bhāryyāsīt| ");
INSERT INTO sanias_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","tadā yīśuḥ pratyuvāca, etasya jagato lokā vivahanti vāgdattāśca bhavanti ");
INSERT INTO sanias_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","kintu ye tajjagatprāptiyogyatvena gaṇitāṁ bhaviṣyanti śmaśānāccotthāsyanti te na vivahanti vāgdattāśca na bhavanti, ");
INSERT INTO sanias_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","te puna rna mriyante kintu śmaśānādutthāpitāḥ santa īśvarasya santānāḥ svargīyadūtānāṁ sadṛśāśca bhavanti| ");
INSERT INTO sanias_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","adhikantu mūsāḥ stambopākhyāne parameśvara ībrāhīma īśvara ishāka īśvaro yākūbaśceśvara ityuktvā mṛtānāṁ śmaśānād utthānasya pramāṇaṁ lilekha| ");
INSERT INTO sanias_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ataeva ya īśvaraḥ sa mṛtānāṁ prabhu rna kintu jīvatāmeva prabhuḥ, tannikaṭe sarvve jīvantaḥ santi| ");
INSERT INTO sanias_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","iti śrutvā kiyantodhyāpakā ūcuḥ, he upadeśaka bhavān bhadraṁ pratyuktavān| ");
INSERT INTO sanias_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","itaḥ paraṁ taṁ kimapi praṣṭaṁ teṣāṁ pragalbhatā nābhūt| ");
INSERT INTO sanias_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","paścāt sa tān uvāca, yaḥ khrīṣṭaḥ sa dāyūdaḥ santāna etāṁ kathāṁ lokāḥ kathaṁ kathayanti? ");
INSERT INTO sanias_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","yataḥ mama prabhumidaṁ vākyamavadat parameśvaraḥ| tava śatrūnahaṁ yāvat pādapīṭhaṁ karomi na| tāvat kālaṁ madīye tvaṁ dakṣapārśva upāviśa| ");
INSERT INTO sanias_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","iti kathāṁ dāyūd svayaṁ gītagranthe'vadat| ");
INSERT INTO sanias_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","ataeva yadi dāyūd taṁ prabhuṁ vadati, tarhi sa kathaṁ tasya santāno bhavati? ");
INSERT INTO sanias_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","paścād yīśuḥ sarvvajanānāṁ karṇagocare śiṣyānuvāca, ");
INSERT INTO sanias_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","ye'dhyāpakā dīrghaparicchadaṁ paridhāya bhramanti, haṭṭāpaṇayo rnamaskāre bhajanagehasya proccāsane bhojanagṛhasya pradhānasthāne ca prīyante ");
INSERT INTO sanias_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","vidhavānāṁ sarvvasvaṁ grasitvā chalena dīrghakālaṁ prārthayante ca teṣu sāvadhānā bhavata, teṣāmugradaṇḍo bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","atha dhanilokā bhāṇḍāgāre dhanaṁ nikṣipanti sa tadeva paśyati, ");
INSERT INTO sanias_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","etarhi kāciddīnā vidhavā paṇadvayaṁ nikṣipati tad dadarśa| ");
INSERT INTO sanias_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","tato yīśuruvāca yuṣmānahaṁ yathārthaṁ vadāmi, daridreyaṁ vidhavā sarvvebhyodhikaṁ nyakṣepsīt, ");
INSERT INTO sanias_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","yatonye svaprājyadhanebhya īśvarāya kiñcit nyakṣepsuḥ, kintu daridreyaṁ vidhavā dinayāpanārthaṁ svasya yat kiñcit sthitaṁ tat sarvvaṁ nyakṣepsīt| ");
INSERT INTO sanias_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","aparañca uttamaprastarairutsṛṣṭavyaiśca mandiraṁ suśobhatetarāṁ kaiścidityukte sa pratyuvāca ");
INSERT INTO sanias_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","yūyaṁ yadidaṁ nicayanaṁ paśyatha, asya pāṣāṇaikopyanyapāṣāṇopari na sthāsyati, sarvve bhūsādbhaviṣyanti kāloyamāyāti| ");
INSERT INTO sanias_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","tadā te papracchuḥ, he guro ghaṭanedṛśī kadā bhaviṣyati? ghaṭanāyā etasyasaścihnaṁ vā kiṁ bhaviṣyati? ");
INSERT INTO sanias_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","tadā sa jagāda, sāvadhānā bhavata yathā yuṣmākaṁ bhramaṁ kopi na janayati, khīṣṭohamityuktvā mama nāmrā bahava upasthāsyanti sa kālaḥ prāyeṇopasthitaḥ, teṣāṁ paścānmā gacchata| ");
INSERT INTO sanias_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","yuddhasyopaplavasya ca vārttāṁ śrutvā mā śaṅkadhvaṁ, yataḥ prathamam etā ghaṭanā avaśyaṁ bhaviṣyanti kintu nāpāte yugānto bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","aparañca kathayāmāsa, tadā deśasya vipakṣatvena deśo rājyasya vipakṣatvena rājyam utthāsyati, ");
INSERT INTO sanias_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","nānāsthāneṣu mahābhūkampo durbhikṣaṁ mārī ca bhaviṣyanti, tathā vyomamaṇḍalasya bhayaṅkaradarśanānyaścaryyalakṣaṇāni ca prakāśayiṣyante| ");
INSERT INTO sanias_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","kintu sarvvāsāmetāsāṁ ghaṭanānāṁ pūrvvaṁ lokā yuṣmān dhṛtvā tāḍayiṣyanti, bhajanālaye kārāyāñca samarpayiṣyanti mama nāmakāraṇād yuṣmān bhūpānāṁ śāsakānāñca sammukhaṁ neṣyanti ca| ");
INSERT INTO sanias_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","sākṣyārtham etāni yuṣmān prati ghaṭiṣyante| ");
INSERT INTO sanias_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","tadā kimuttaraṁ vaktavyam etat na cintayiṣyāma iti manaḥsu niścitanuta| ");
INSERT INTO sanias_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","vipakṣā yasmāt kimapyuttaram āpattiñca karttuṁ na śakṣyanti tādṛśaṁ vākpaṭutvaṁ jñānañca yuṣmabhyaṁ dāsyāmi| ");
INSERT INTO sanias_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","kiñca yūyaṁ pitrā mātrā bhrātrā bandhunā jñātyā kuṭumbena ca parakareṣu samarpayiṣyadhve; tataste yuṣmākaṁ kañcana kañcana ghātayiṣyanti| ");
INSERT INTO sanias_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","mama nāmnaḥ kāraṇāt sarvvai rmanuṣyai ryūyam ṛtīyiṣyadhve| ");
INSERT INTO sanias_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","kintu yuṣmākaṁ śiraḥkeśaikopi na vinaṁkṣyati, ");
INSERT INTO sanias_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","tasmādeva dhairyyamavalambya svasvaprāṇān rakṣata| ");
INSERT INTO sanias_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","aparañca yirūśālampuraṁ sainyaveṣṭitaṁ vilokya tasyocchinnatāyāḥ samayaḥ samīpa ityavagamiṣyatha| ");
INSERT INTO sanias_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","tadā yihūdādeśasthā lokāḥ parvvataṁ palāyantāṁ, ye ca nagare tiṣṭhanti te deśāntaraṁ palāyantā, ye ca grāme tiṣṭhanti te nagaraṁ na praviśantu, ");
INSERT INTO sanias_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","yatastadā samucitadaṇḍanāya dharmmapustake yāni sarvvāṇi likhitāni tāni saphalāni bhaviṣyanti| ");
INSERT INTO sanias_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","kintu yā yāstadā garbhavatyaḥ stanyadāvyaśca tāmāṁ durgati rbhaviṣyati, yata etāllokān prati kopo deśe ca viṣamadurgati rghaṭiṣyate| ");
INSERT INTO sanias_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","vastutastu te khaṅgadhāraparivvaṅgaṁ lapsyante baddhāḥ santaḥ sarvvadeśeṣu nāyiṣyante ca kiñcānyadeśīyānāṁ samayopasthitiparyyantaṁ yirūśālampuraṁ taiḥ padatalai rdalayiṣyate| ");
INSERT INTO sanias_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","sūryyacandranakṣatreṣu lakṣaṇādi bhaviṣyanti, bhuvi sarvvadeśīyānāṁ duḥkhaṁ cintā ca sindhau vīcīnāṁ tarjanaṁ garjanañca bhaviṣyanti| ");
INSERT INTO sanias_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","bhūbhau bhāvighaṭanāṁ cintayitvā manujā bhiyāmṛtakalpā bhaviṣyanti, yato vyomamaṇḍale tejasvino dolāyamānā bhaviṣyanti| ");
INSERT INTO sanias_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","tadā parākrameṇā mahātejasā ca meghārūḍhaṁ manuṣyaputram āyāntaṁ drakṣyanti| ");
INSERT INTO sanias_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","kintvetāsāṁ ghaṭanānāmārambhe sati yūyaṁ mastakānyuttolya ūrdadhvaṁ drakṣyatha, yato yuṣmākaṁ mukteḥ kālaḥ savidho bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","tatastenaitadṛṣṭāntakathā kathitā, paśyata uḍumbarādivṛkṣāṇāṁ ");
INSERT INTO sanias_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","navīnapatrāṇi jātānīti dṛṣṭvā nidāvakāla upasthita iti yathā yūyaṁ jñātuṁ śaknutha, ");
INSERT INTO sanias_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","tathā sarvvāsāmāsāṁ ghaṭanānām ārambhe dṛṣṭe satīśvarasya rājatvaṁ nikaṭam ityapi jñāsyatha| ");
INSERT INTO sanias_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","yuṣmānahaṁ yathārthaṁ vadāmi, vidyamānalokānāmeṣāṁ gamanāt pūrvvam etāni ghaṭiṣyante| ");
INSERT INTO sanias_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","nabhobhuvorlopo bhaviṣyati mama vāk tu kadāpi luptā na bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","ataeva viṣamāśanena pānena ca sāṁmārikacintābhiśca yuṣmākaṁ citteṣu matteṣu taddinam akasmād yuṣmān prati yathā nopatiṣṭhati tadarthaṁ sveṣu sāvadhānāstiṣṭhata| ");
INSERT INTO sanias_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","pṛthivīsthasarvvalokān prati taddinam unmātha iva upasthāsyati| ");
INSERT INTO sanias_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","yathā yūyam etadbhāvighaṭanā uttarttuṁ manujasutasya sammukhe saṁsthātuñca yogyā bhavatha kāraṇādasmāt sāvadhānāḥ santo nirantaraṁ prārthayadhvaṁ| ");
INSERT INTO sanias_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","aparañca sa divā mandira upadiśya rācai jaitunādriṁ gatvātiṣṭhat| ");
INSERT INTO sanias_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","tataḥ pratyūṣe lākāstatkathāṁ śrotuṁ mandire tadantikam āgacchan| ");
INSERT INTO sanias_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","aparañca kiṇvaśūnyapūpotsavasya kāla upasthite ");
INSERT INTO sanias_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","pradhānayājakā adhyāyakāśca yathā taṁ hantuṁ śaknuvanti tathopāyām aceṣṭanta kintu lokebhyo bibhyuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","etastin samaye dvādaśaśiṣyeṣu gaṇita īṣkariyotīyarūḍhimān yo yihūdāstasyāntaḥkaraṇaṁ śaitānāśritatvāt ");
INSERT INTO sanias_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","sa gatvā yathā yīśuṁ teṣāṁ kareṣu samarpayituṁ śaknoti tathā mantraṇāṁ pradhānayājakaiḥ senāpatibhiśca saha cakāra| ");
INSERT INTO sanias_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","tena te tuṣṭāstasmai mudrāṁ dātuṁ paṇaṁ cakruḥ| ");
INSERT INTO sanias_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","tataḥ soṅgīkṛtya yathā lokānāmagocare taṁ parakareṣu samarpayituṁ śaknoti tathāvakāśaṁ ceṣṭitumārebhe| ");
INSERT INTO sanias_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","atha kiṇvaśūnyapūpotmavadine, arthāt yasmin dine nistārotsavasya meṣo hantavyastasmin dine ");
INSERT INTO sanias_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","yīśuḥ pitaraṁ yohanañcāhūya jagāda, yuvāṁ gatvāsmākaṁ bhojanārthaṁ nistārotsavasya dravyāṇyāsādayataṁ| ");
INSERT INTO sanias_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","tadā tau papracchatuḥ kucāsādayāvo bhavataḥ kecchā? ");
INSERT INTO sanias_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","tadā sovādīt, nagare praviṣṭe kaścijjalakumbhamādāya yuvāṁ sākṣāt kariṣyati sa yanniveśanaṁ praviśati yuvāmapi tanniveśanaṁ tatpaścāditvā niveśanapatim iti vākyaṁ vadataṁ, ");
INSERT INTO sanias_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","yatrāhaṁ nistārotsavasya bhojyaṁ śiṣyaiḥ sārddhaṁ bhoktuṁ śaknomi sātithiśālāा kutra? kathāmimāṁ prabhustvāṁ pṛcchati| ");
INSERT INTO sanias_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","tataḥ sa jano dvitīyaprakoṣṭhīyam ekaṁ śastaṁ koṣṭhaṁ darśayiṣyati tatra bhojyamāsādayataṁ| ");
INSERT INTO sanias_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","tatastau gatvā tadvākyānusāreṇa sarvvaṁ dṛṣdvā tatra nistārotsavīyaṁ bhojyamāsādayāmāsatuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","atha kāla upasthite yīśu rdvādaśabhiḥ preritaiḥ saha bhoktumupaviśya kathitavān ");
INSERT INTO sanias_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","mama duḥkhabhogāt pūrvvaṁ yubhābhiḥ saha nistārotsavasyaitasya bhojyaṁ bhoktuṁ mayātivāñchā kṛtā| ");
INSERT INTO sanias_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","yuṣmān vadāmi, yāvatkālam īśvararājye bhojanaṁ na kariṣye tāvatkālam idaṁ na bhokṣye| ");
INSERT INTO sanias_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","tadā sa pānapātramādāya īśvarasya guṇān kīrttayitvā tebhyo datvāvadat, idaṁ gṛhlīta yūyaṁ vibhajya pivata| ");
INSERT INTO sanias_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","yuṣmān vadāmi yāvatkālam īśvararājatvasya saṁsthāpanaṁ na bhavati tāvad drākṣāphalarasaṁ na pāsyāmi| ");
INSERT INTO sanias_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","tataḥ pūpaṁ gṛhītvā īśvaraguṇān kīrttayitvā bhaṅktā tebhyo datvāvadat, yuṣmadarthaṁ samarpitaṁ yanmama vapustadidaṁ, etat karmma mama smaraṇārthaṁ kurudhvaṁ| ");
INSERT INTO sanias_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","atha bhojanānte tādṛśaṁ pātraṁ gṛhītvāvadat, yuṣmatkṛte pātitaṁ yanmama raktaṁ tena nirṇītanavaniyamarūpaṁ pānapātramidaṁ| ");
INSERT INTO sanias_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","paśyata yo māṁ parakareṣu samarpayiṣyati sa mayā saha bhojanāsana upaviśati| ");
INSERT INTO sanias_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","yathā nirūpitamāste tadanusāreṇā manuṣyapuुtrasya gati rbhaviṣyati kintu yastaṁ parakareṣu samarpayiṣyati tasya santāpo bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","tadā teṣāṁ ko jana etat karmma kariṣyati tat te parasparaṁ praṣṭumārebhire| ");
INSERT INTO sanias_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","aparaṁ teṣāṁ ko janaḥ śreṣṭhatvena gaṇayiṣyate, atrārthe teṣāṁ vivādobhavat| ");
INSERT INTO sanias_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","asmāt kāraṇāt sovadat, anyadeśīyānāṁ rājānaḥ prajānāmupari prabhutvaṁ kurvvanti dāruṇaśāsanaṁ kṛtvāpi te bhūpatitvena vikhyātā bhavanti ca| ");
INSERT INTO sanias_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","kintu yuṣmākaṁ tathā na bhaviṣyati, yo yuṣmākaṁ śreṣṭho bhaviṣyati sa kaniṣṭhavad bhavatu, yaśca mukhyo bhaviṣyati sa sevakavadbhavatu| ");
INSERT INTO sanias_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","bhojanopaviṣṭaparicārakayoḥ kaḥ śreṣṭhaḥ? yo bhojanāyopaviśati sa kiṁ śreṣṭho na bhavati? kintu yuṣmākaṁ madhye'haṁ paricāraka̮ivāsmi| ");
INSERT INTO sanias_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","aparañca yuyaṁ mama parīkṣākāle prathamamārabhya mayā saha sthitā ");
INSERT INTO sanias_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","etatkāraṇāt pitrā yathā madarthaṁ rājyamekaṁ nirūpitaṁ tathāhamapi yuṣmadarthaṁ rājyaṁ nirūpayāmi| ");
INSERT INTO sanias_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","tasmān mama rājye bhojanāsane ca bhojanapāne kariṣyadhve siṁhāsaneṣūpaviśya cesrāyelīyānāṁ dvādaśavaṁśānāṁ vicāraṁ kariṣyadhve| ");
INSERT INTO sanias_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","aparaṁ prabhuruvāca, he śimon paśya tita̮unā dhānyānīva yuṣmān śaitān cālayitum aicchat, ");
INSERT INTO sanias_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","kintu tava viśvāsasya lopo yathā na bhavati etat tvadarthaṁ prārthitaṁ mayā, tvanmanasi parivarttite ca bhrātṛṇāṁ manāṁsi sthirīkuru| ");
INSERT INTO sanias_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","tadā sovadat, he prabhohaṁ tvayā sārddhaṁ kārāṁ mṛtiñca yātuṁ majjitosmi| ");
INSERT INTO sanias_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","tataḥ sa uvāca, he pitara tvāṁ vadāmi, adya kukkuṭaravāt pūrvvaṁ tvaṁ matparicayaṁ vāratrayam apahvoṣyase| ");
INSERT INTO sanias_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","aparaṁ sa papraccha, yadā mudrāsampuṭaṁ khādyapātraṁ pādukāñca vinā yuṣmān prāhiṇavaṁ tadā yuṣmākaṁ kasyāpi nyūnatāsīt? te procuḥ kasyāpi na| ");
INSERT INTO sanias_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","tadā sovadat kintvidānīṁ mudrāsampuṭaṁ khādyapātraṁ vā yasyāsti tena tadgrahītavyaṁ, yasya ca kṛpāṇoे nāsti tena svavastraṁ vikrīya sa kretavyaḥ| ");
INSERT INTO sanias_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","yato yuṣmānahaṁ vadāmi, aparādhijanaiḥ sārddhaṁ gaṇitaḥ sa bhaviṣyati| idaṁ yacchāstrīyaṁ vacanaṁ likhitamasti tanmayi phaliṣyati yato mama sambandhīyaṁ sarvvaṁ setsyati| ");
INSERT INTO sanias_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","tadā te procuḥ prabho paśya imau kṛpāṇau| tataḥ sovadad etau yatheṣṭau| ");
INSERT INTO sanias_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","atha sa tasmādvahi rgatvā svācārānusāreṇa jaitunanāmādriṁ jagāma śiṣyāśca tatpaścād yayuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","tatropasthāya sa tānuvāca, yathā parīkṣāyāṁ na patatha tadarthaṁ prārthayadhvaṁ| ");
INSERT INTO sanias_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","paścāt sa tasmād ekaśarakṣepād bahi rgatvā jānunī pātayitvā etat prārthayāñcakre, ");
INSERT INTO sanias_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","he pita ryadi bhavān sammanyate tarhi kaṁsamenaṁ mamāntikād dūraya kintu madicchānurūpaṁ na tvadicchānurūpaṁ bhavatu| ");
INSERT INTO sanias_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","tadā tasmai śaktiṁ dātuṁ svargīyadūto darśanaṁ dadau| ");
INSERT INTO sanias_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","paścāt sotyantaṁ yātanayā vyākulo bhūtvā punardṛḍhaṁ prārthayāñcakre, tasmād bṛhacchoṇitabindava iva tasya svedabindavaḥ pṛthivyāṁ patitumārebhire| ");
INSERT INTO sanias_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","atha prārthanāta utthāya śiṣyāṇāṁ samīpametya tān manoduḥkhino nidritān dṛṣṭvāvadat ");
INSERT INTO sanias_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","kuto nidrātha? parīkṣāyām apatanārthaṁ prarthayadhvaṁ| ");
INSERT INTO sanias_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","etatkathāyāḥ kathanakāle dvādaśaśiṣyāṇāṁ madhye gaṇito yihūdānāmā janatāsahitasteṣām agre calitvā yīśoścumbanārthaṁ tadantikam āyayau| ");
INSERT INTO sanias_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","tadā yīśuruvāca, he yihūdā kiṁ cumbanena manuṣyaputraṁ parakareṣu samarpayasi? ");
INSERT INTO sanias_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","tadā yadyad ghaṭiṣyate tadanumāya saṅgibhiruktaṁ, he prabho vayaṁ ki khaṅgena ghātayiṣyāmaḥ? ");
INSERT INTO sanias_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","tata ekaḥ karavālenāhatya pradhānayājakasya dāsasya dakṣiṇaṁ karṇaṁ ciccheda| ");
INSERT INTO sanias_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","adhūnā nivarttasva ityuktvā yīśustasya śrutiṁ spṛṣṭvā svasyaṁ cakāra| ");
INSERT INTO sanias_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","paścād yīśuḥ samīpasthān pradhānayājakān mandirasya senāpatīn prācīnāṁśca jagāda, yūyaṁ kṛpāṇān yaṣṭīṁśca gṛhītvā māṁ kiṁ coraṁ dharttumāyātāḥ? ");
INSERT INTO sanias_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","yadāhaṁ yuṣmābhiḥ saha pratidinaṁ mandire'tiṣṭhaṁ tadā māṁ dharttaṁ na pravṛttāḥ, kintvidānīṁ yuṣmākaṁ samayondhakārasya cādhipatyamasti| ");
INSERT INTO sanias_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","atha te taṁ dhṛtvā mahāyājakasya niveśanaṁ ninyuḥ| tataḥ pitaro dūre dūre paścāditvā ");
INSERT INTO sanias_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","bṛhatkoṣṭhasya madhye yatrāgniṁ jvālayitvā lokāḥ sametyopaviṣṭāstatra taiḥ sārddham upaviveśa| ");
INSERT INTO sanias_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","atha vahnisannidhau samupaveśakāle kāciddāsī mano niviśya taṁ nirīkṣyāvadat pumānayaṁ tasya saṅge'sthāt| ");
INSERT INTO sanias_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","kintu sa tad apahnutyāvādīt he nāri tamahaṁ na paricinomi| ");
INSERT INTO sanias_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","kṣaṇāntare'nyajanastaṁ dṛṣṭvābravīt tvamapi teṣāṁ nikarasyaikajanosi| pitaraḥ pratyuvāca he nara nāhamasmi| ");
INSERT INTO sanias_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","tataḥ sārddhadaṇḍadvayāt paraṁ punaranyo jano niścitya babhāṣe, eṣa tasya saṅgīti satyaṁ yatoyaṁ gālīlīyo lokaḥ| ");
INSERT INTO sanias_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","tadā pitara uvāca he nara tvaṁ yad vadami tadahaṁ boddhuṁ na śaknomi, iti vākye kathitamātre kukkuṭo rurāva| ");
INSERT INTO sanias_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","tadā prabhuṇā vyādhuṭya pitare nirīkṣite kṛkavākuravāt pūrvvaṁ māṁ trirapahnoṣyase iti pūrvvoktaṁ tasya vākyaṁ pitaraḥ smṛtvā ");
INSERT INTO sanias_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","bahirgatvā mahākhedena cakranda| ");
INSERT INTO sanias_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","tadā yai ryīśurdhṛtaste tamupahasya praharttumārebhire| ");
INSERT INTO sanias_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","vastreṇa tasya dṛśau baddhvā kapole capeṭāghātaṁ kṛtvā papracchuḥ, kaste kapole capeṭāghātaṁ kṛtavāna? gaṇayitvā tad vada| ");
INSERT INTO sanias_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","tadanyat tadviruddhaṁ bahunindāvākyaṁ vaktumārebhire| ");
INSERT INTO sanias_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","atha prabhāte sati lokaprāñcaḥ pradhānayājakā adhyāpakāśca sabhāṁ kṛtvā madhyesabhaṁ yīśumānīya papracchuḥ, tvam abhiṣikatosi na vāsmān vada| ");
INSERT INTO sanias_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","sa pratyuvāca, mayā tasminnukte'pi yūyaṁ na viśvasiṣyatha| ");
INSERT INTO sanias_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","kasmiṁścidvākye yuṣmān pṛṣṭe'pi māṁ na taduttaraṁ vakṣyatha na māṁ tyakṣyatha ca| ");
INSERT INTO sanias_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","kintvitaḥ paraṁ manujasutaḥ sarvvaśaktimata īśvarasya dakṣiṇe pārśve samupavekṣyati| ");
INSERT INTO sanias_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","tataste papracchuḥ, rtiha tvamīśvarasya putraḥ? sa kathayāmāsa, yūyaṁ yathārthaṁ vadatha sa evāhaṁ| ");
INSERT INTO sanias_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","tadā te sarvve kathayāmāsuḥ, rtiha sākṣye'nsasmin asmākaṁ kiṁ prayojanaṁ? asya svamukhādeva sākṣyaṁ prāptam| ");
INSERT INTO sanias_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","tataḥ sabhāsthāḥ sarvvalokā utthāya taṁ pīlātasammukhaṁ nītvāprodya vaktumārebhire, ");
INSERT INTO sanias_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","svamabhiṣiktaṁ rājānaṁ vadantaṁ kaimararājāya karadānaṁ niṣedhantaṁ rājyaviparyyayaṁ kurttuṁ pravarttamānam ena prāptā vayaṁ| ");
INSERT INTO sanias_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","tadā pīlātastaṁ pṛṣṭavān tvaṁ kiṁ yihūdīyānāṁ rājā? sa pratyuvāca tvaṁ satyamuktavān| ");
INSERT INTO sanias_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","tadā pīlātaḥ pradhānayājakādilokān jagād, ahametasya kamapyaparādhaṁ nāptavān| ");
INSERT INTO sanias_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","tataste punaḥ sāhamino bhūtvāvadan, eṣa gālīla etatsthānaparyyante sarvvasmin yihūdādeśe sarvvāllokānupadiśya kupravṛttiṁ grāhītavān| ");
INSERT INTO sanias_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","tadā pīlāto gālīlapradeśasya nāma śrutvā papraccha, kimayaṁ gālīlīyo lokaḥ? ");
INSERT INTO sanias_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","tataḥ sa gālīlpradeśīyaherodrājasya tadā sthitestasya samīpe yīśuṁ preṣayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","tadā herod yīśuṁ vilokya santutoṣa, yataḥ sa tasya bahuvṛttāntaśravaṇāt tasya kiñi्cadāścaryyakarmma paśyati ityāśāṁ kṛtvā bahukālamārabhya taṁ draṣṭuṁ prayāsaṁ kṛtavān| ");
INSERT INTO sanias_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","tasmāt taṁ bahukathāḥ papraccha kintu sa tasya kasyāpi vākyasya pratyuttaraṁ novāca| ");
INSERT INTO sanias_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","atha pradhānayājakā adhyāpakāśca prottiṣṭhantaḥ sāhasena tamapavadituṁ prārebhire| ");
INSERT INTO sanias_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","herod tasya senāgaṇaśca tamavajñāya upahāsatvena rājavastraṁ paridhāpya punaḥ pīlātaṁ prati taṁ prāhiṇot| ");
INSERT INTO sanias_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","pūrvvaṁ herodpīlātayoḥ parasparaṁ vairabhāva āsīt kintu taddine dvayo rmelanaṁ jātam| ");
INSERT INTO sanias_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","paścāt pīlātaḥ pradhānayājakān śāsakān lokāṁśca yugapadāhūya babhāṣe, ");
INSERT INTO sanias_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","rājyaviparyyayakārakoyam ityuktvā manuṣyamenaṁ mama nikaṭamānaiṣṭa kintu paśyata yuṣmākaṁ samakṣam asya vicāraṁ kṛtvāpi proktāpavādānurūpeṇāsya kopyaparādhaḥ sapramāṇo na jātaḥ, ");
INSERT INTO sanias_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","yūyañca herodaḥ sannidhau preṣitā mayā tatrāsya kopyaparādhastenāpi na prāptaḥ|paśyatānena vadhaheेtukaṁ kimapi nāparāddhaṁ| ");
INSERT INTO sanias_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","tasmādenaṁ tāḍayitvā vihāsyāmi| ");
INSERT INTO sanias_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","tatrotsave teṣāmeko mocayitavyaḥ| ");
INSERT INTO sanias_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","iti hetoste proccairekadā procuḥ, enaṁ dūrīkṛtya barabbānāmānaṁ mocaya| ");
INSERT INTO sanias_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","sa barabbā nagara upaplavavadhāparādhābhyāṁ kārāyāṁ baddha āsīt| ");
INSERT INTO sanias_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","kintu pīlāto yīśuṁ mocayituṁ vāñchan punastānuvāca| ");
INSERT INTO sanias_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","tathāpyenaṁ kruśe vyadha kruśe vyadheti vadantaste ruruvuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","tataḥ sa tṛtīyavāraṁ jagāda kutaḥ? sa kiṁ karmma kṛtavān? nāhamasya kamapi vadhāparādhaṁ prāptaḥ kevalaṁ tāḍayitvāmuṁ tyajāmi| ");
INSERT INTO sanias_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","tathāpi te punarenaṁ kruśe vyadha ityuktvā proccairdṛḍhaṁ prārthayāñcakrire; ");
INSERT INTO sanias_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","tataḥ pradhānayājakādīnāṁ kalarave prabale sati teṣāṁ prārthanārūpaṁ karttuṁ pīlāta ādideśa| ");
INSERT INTO sanias_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","rājadrohavadhayoraparādhena kārāsthaṁ yaṁ janaṁ te yayācire taṁ mocayitvā yīśuṁ teṣāmicchāyāṁ samārpayat| ");
INSERT INTO sanias_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","atha te yīśuṁ gṛhītvā yānti, etarhi grāmādāgataṁ śimonanāmānaṁ kurīṇīyaṁ janaṁ dhṛtvā yīśoḥ paścānnetuṁ tasya skandhe kruśamarpayāmāsuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","tato loाkāraṇyamadhye bahustriyo rudatyo vilapantyaśca yīśoḥ paścād yayuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","kintu sa vyāghuṭya tā uvāca, he yirūśālamo nāryyo yuyaṁ madarthaṁ na ruditvā svārthaṁ svāpatyārthañca ruditi; ");
INSERT INTO sanias_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","paśyata yaḥ kadāpi garbhavatyo nābhavan stanyañca nāpāyayan tādṛśī rvandhyā yadā dhanyā vakṣyanti sa kāla āyāti| ");
INSERT INTO sanias_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","tadā he śailā asmākamupari patata, he upaśailā asmānācchādayata kathāmīdṛśīṁ lokā vakṣyanti| ");
INSERT INTO sanias_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","yataḥ satejasi śākhini cedetad ghaṭate tarhi śuṣkaśākhini kiṁ na ghaṭiṣyate? ");
INSERT INTO sanias_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","tadā te hantuṁ dvāvaparādhinau tena sārddhaṁ ninyuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","aparaṁ śiraḥkapālanāmakasthānaṁ prāpya taṁ kruśe vividhuḥ; taddvayoraparādhinorekaṁ tasya dakṣiṇo tadanyaṁ vāme kruśe vividhuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","tadā yīśurakathayat, he pitaretān kṣamasva yata ete yat karmma kurvvanti tan na viduḥ; paścātte guṭikāpātaṁ kṛtvā tasya vastrāṇi vibhajya jagṛhuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","tatra lokasaṁghastiṣṭhan dadarśa; te teṣāṁ śāsakāśca tamupahasya jagaduḥ, eṣa itarān rakṣitavān yadīśvareṇābhirucito 'bhiṣiktastrātā bhavati tarhi svamadhunā rakṣatu| ");
INSERT INTO sanias_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","tadanyaḥ senāgaṇā etya tasmai amlarasaṁ datvā parihasya provāca, ");
INSERT INTO sanias_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","cettvaṁ yihūdīyānāṁ rājāsi tarhi svaṁ rakṣa| ");
INSERT INTO sanias_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","yihūdīyānāṁ rājeti vākyaṁ yūnānīyaromīyebrīyākṣarai rlikhitaṁ tacchirasa ūrddhve'sthāpyata| ");
INSERT INTO sanias_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","tadobhayapārśvayo rviddhau yāvaparādhinau tayorekastaṁ vinindya babhāṣe, cettvam abhiṣiktosi tarhi svamāvāñca rakṣa| ");
INSERT INTO sanias_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","kintvanyastaṁ tarjayitvāvadat, īśvarāttava kiñcidapi bhayaṁ nāsti kiṁ? tvamapi samānadaṇḍosi, ");
INSERT INTO sanias_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","yogyapātre āvāṁ svasvakarmmaṇāṁ samucitaphalaṁ prāpnuvaḥ kintvanena kimapi nāparāddhaṁ| ");
INSERT INTO sanias_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","atha sa yīśuṁ jagāda he prabhe bhavān svarājyapraveśakāle māṁ smaratu| ");
INSERT INTO sanias_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","tadā yīśuḥ kathitavān tvāṁ yathārthaṁ vadāmi tvamadyaiva mayā sārddhaṁ paralokasya sukhasthānaṁ prāpsyasi| ");
INSERT INTO sanias_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","aparañca dvitīyayāmāt tṛtīyayāmaparyyantaṁ ravestejasontarhitatvāt sarvvadeśo'ndhakāreṇāvṛto ");
INSERT INTO sanias_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","mandirasya yavanikā ca chidyamānā dvidhā babhūva| ");
INSERT INTO sanias_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","tato yīśuruccairuvāca, he pita rmamātmānaṁ tava kare samarpaye, ityuktvā sa prāṇān jahau| ");
INSERT INTO sanias_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","tadaitā ghaṭanā dṛṣṭvā śatasenāpatirīśvaraṁ dhanyamuktvā kathitavān ayaṁ nitāntaṁ sādhumanuṣya āsīt| ");
INSERT INTO sanias_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","atha yāvanto lokā draṣṭum āgatāste tā ghaṭanā dṛṣṭvā vakṣaḥsu karāghātaṁ kṛtvā vyācuṭya gatāḥ| ");
INSERT INTO sanias_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","yīśo rjñātayo yā yā yoṣitaśca gālīlastena sārddhamāyātāstā api dūre sthitvā tat sarvvaṁ dadṛśuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","tadā yihūdīyānāṁ mantraṇāṁ kriyāñcāsammanyamāna īśvarasya rājatvam apekṣamāṇo ");
INSERT INTO sanias_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","yihūdideśīyo 'rimathīyanagarīyo yūṣaphnāmā mantrī bhadro dhārmmikaśca pumān ");
INSERT INTO sanias_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","pīlātāntikaṁ gatvā yīśo rdehaṁ yayāce| ");
INSERT INTO sanias_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","paścād vapuravarohya vāsasā saṁveṣṭya yatra kopi mānuṣo nāsthāpyata tasmin śaile svāte śmaśāne tadasthāpayat| ");
INSERT INTO sanias_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","taddinamāyojanīyaṁ dinaṁ viśrāmavāraśca samīpaḥ| ");
INSERT INTO sanias_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","aparaṁ yīśunā sārddhaṁ gālīla āgatā yoṣitaḥ paścāditvā śmaśāne tatra yathā vapuḥ sthāpitaṁ tacca dṛṣṭvā ");
INSERT INTO sanias_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","vyāghuṭya sugandhidravyatailāni kṛtvā vidhivad viśrāmavāre viśrāmaṁ cakruḥ| ");
INSERT INTO sanias_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","atha saptāhaprathamadine'tipratyūṣe tā yoṣitaḥ sampāditaṁ sugandhidravyaṁ gṛhītvā tadanyābhiḥ kiyatībhiḥ strībhiḥ saha śmaśānaṁ yayuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","kintu śmaśānadvārāt pāṣāṇamapasāritaṁ dṛṣṭvā ");
INSERT INTO sanias_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","tāḥ praviśya prabho rdehamaprāpya ");
INSERT INTO sanias_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","vyākulā bhavanti etarhi tejomayavastrānvitau dvau puruṣau tāsāṁ samīpe samupasthitau ");
INSERT INTO sanias_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","tasmāttāḥ śaṅkāyuktā bhūmāvadhomukhyasyasthuḥ| tadā tau tā ūcatu rmṛtānāṁ madhye jīvantaṁ kuto mṛgayatha? ");
INSERT INTO sanias_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","sotra nāsti sa udasthāt| ");
INSERT INTO sanias_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","pāpināṁ kareṣu samarpitena kruśe hatena ca manuṣyaputreṇa tṛtīyadivase śmaśānādutthātavyam iti kathāṁ sa galīli tiṣṭhan yuṣmabhyaṁ kathitavān tāṁ smarata| ");
INSERT INTO sanias_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","tadā tasya sā kathā tāsāṁ manaḥsu jātā| ");
INSERT INTO sanias_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","anantaraṁ śmaśānād gatvā tā ekādaśaśiṣyādibhyaḥ sarvvebhyastāṁ vārttāṁ kathayāmāsuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","magdalīnīmariyam, yohanā, yākūbo mātā mariyam tadanyāḥ saṅginyo yoṣitaśca preritebhya etāḥ sarvvā vārttāḥ kathayāmāsuḥ ");
INSERT INTO sanias_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","kintu tāsāṁ kathām anarthakākhyānamātraṁ buddhvā kopi na pratyait| ");
INSERT INTO sanias_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","tadā pitara utthāya śmaśānāntikaṁ dadhāva, tatra ca prahvo bhūtvā pārśvaikasthāpitaṁ kevalaṁ vastraṁ dadarśa; tasmādāścaryyaṁ manyamāno yadaghaṭata tanmanasi vicārayan pratasthe| ");
INSERT INTO sanias_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","tasminneva dine dvau śiyyau yirūśālamaścatuṣkrośāntaritam immāyugrāmaṁ gacchantau ");
INSERT INTO sanias_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","tāsāṁ ghaṭanānāṁ kathāmakathayatāṁ ");
INSERT INTO sanias_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","tayorālāpavicārayoḥ kāle yīśurāgatya tābhyāṁ saha jagāma ");
INSERT INTO sanias_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","kintu yathā tau taṁ na paricinutastadarthaṁ tayo rdṛṣṭiḥ saṁruddhā| ");
INSERT INTO sanias_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","sa tau pṛṣṭavān yuvāṁ viṣaṇṇau kiṁ vicārayantau gacchathaḥ? ");
INSERT INTO sanias_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","tatastayoḥ kliyapānāmā pratyuvāca yirūśālamapure'dhunā yānyaghaṭanta tvaṁ kevalavideśī kiṁ tadvṛttāntaṁ na jānāsi? ");
INSERT INTO sanias_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","sa papraccha kā ghaṭanāḥ? tadā tau vaktumārebhāte yīśunāmā yo nāsaratīyo bhaviṣyadvādī īśvarasya mānuṣāṇāñca sākṣāt vākye karmmaṇi ca śaktimānāsīt ");
INSERT INTO sanias_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","tam asmākaṁ pradhānayājakā vicārakāśca kenāpi prakāreṇa kruśe viddhvā tasya prāṇānanāśayan tadīyā ghaṭanāḥ; ");
INSERT INTO sanias_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","kintu ya isrāyelīyalokān uddhārayiṣyati sa evāyam ityāśāsmābhiḥ kṛtā|tadyathā tathāstu tasyā ghaṭanāyā adya dinatrayaṁ gataṁ| ");
INSERT INTO sanias_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","adhikantvasmākaṁ saṅginīnāṁ kiyatstrīṇāṁ mukhebhyo'sambhavavākyamidaṁ śrutaṁ; ");
INSERT INTO sanias_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","tāḥ pratyūṣe śmaśānaṁ gatvā tatra tasya deham aprāpya vyāghuṭyetvā proktavatyaḥ svargīsadūtau dṛṣṭāvasmābhistau cāvādiṣṭāṁ sa jīvitavān| ");
INSERT INTO sanias_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","tatosmākaṁ kaiścit śmaśānamagamyata te'pi strīṇāṁ vākyānurūpaṁ dṛṣṭavantaḥ kintu taṁ nāpaśyan| ");
INSERT INTO sanias_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","tadā sa tāvuvāca, he abodhau he bhaviṣyadvādibhiruktavākyaṁ pratyetuṁ vilambamānau; ");
INSERT INTO sanias_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","etatsarvvaduḥkhaṁ bhuktvā svabhūtiprāptiḥ kiṁ khrīṣṭasya na nyāyyā? ");
INSERT INTO sanias_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","tataḥ sa mūsāgranthamārabhya sarvvabhaviṣyadvādināṁ sarvvaśāstre svasmin likhitākhyānābhiprāyaṁ bodhayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","atha gamyagrāmābhyarṇaṁ prāpya tenāgre gamanalakṣaṇe darśite ");
INSERT INTO sanias_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","tau sādhayitvāvadatāṁ sahāvābhyāṁ tiṣṭha dine gate sati rātrirabhūt; tataḥ sa tābhyāṁ sārddhaṁ sthātuṁ gṛhaṁ yayau| ");
INSERT INTO sanias_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","paścādbhojanopaveśakāle sa pūpaṁ gṛhītvā īśvaraguṇān jagāda tañca bhaṁktvā tābhyāṁ dadau| ");
INSERT INTO sanias_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","tadā tayo rdṛṣṭau prasannāyāṁ taṁ pratyabhijñatuḥ kintu sa tayoḥ sākṣādantardadhe| ");
INSERT INTO sanias_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","tatastau mithobhidhātum ārabdhavantau gamanakāle yadā kathāmakathayat śāstrārthañcabodhayat tadāvayo rbuddhiḥ kiṁ na prājvalat? ");
INSERT INTO sanias_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","tau tatkṣaṇādutthāya yirūśālamapuraṁ pratyāyayatuḥ, tatsthāne śiṣyāṇām ekādaśānāṁ saṅgināñca darśanaṁ jātaṁ| ");
INSERT INTO sanias_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","te procuḥ prabhurudatiṣṭhad iti satyaṁ śimone darśanamadācca| ");
INSERT INTO sanias_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","tataḥ pathaḥ sarvvaghaṭanāyāḥ pūpabhañjanena tatparicayasya ca sarvvavṛttāntaṁ tau vaktumārebhāte| ");
INSERT INTO sanias_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","itthaṁ te parasparaṁ vadanti tatkāle yīśuḥ svayaṁ teṣāṁ madhya protthaya yuṣmākaṁ kalyāṇaṁ bhūyād ityuvāca, ");
INSERT INTO sanias_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","kintu bhūtaṁ paśyāma ityanumāya te samudvivijire treṣuśca| ");
INSERT INTO sanias_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","sa uvāca, kuto duḥkhitā bhavatha? yuṣmākaṁ manaḥsu sandeha udeti ca kutaḥ? ");
INSERT INTO sanias_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","eṣohaṁ, mama karau paśyata varaṁ spṛṣṭvā paśyata, mama yādṛśāni paśyatha tādṛśāni bhūtasya māṁsāsthīni na santi| ");
INSERT INTO sanias_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ityuktvā sa hastapādān darśayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","te'sambhavaṁ jñātvā sānandā na pratyayan| tataḥ sa tān papraccha, atra yuṣmākaṁ samīpe khādyaṁ kiñcidasti? ");
INSERT INTO sanias_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","tataste kiyaddagdhamatsyaṁ madhu ca daduḥ ");
INSERT INTO sanias_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","sa tadādāya teṣāṁ sākṣād bubhuje ");
INSERT INTO sanias_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","kathayāmāsa ca mūsāvyavasthāyāṁ bhaviṣyadvādināṁ grantheṣu gītapustake ca mayi yāni sarvvāṇi vacanāni likhitāni tadanurūpāṇi ghaṭiṣyante yuṣmābhiḥ sārddhaṁ sthitvāhaṁ yadetadvākyam avadaṁ tadidānīṁ pratyakṣamabhūt| ");
INSERT INTO sanias_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","atha tebhyaḥ śāstrabodhādhikāraṁ datvāvadat, ");
INSERT INTO sanias_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","khrīṣṭenetthaṁ mṛtiyātanā bhoktavyā tṛtīyadine ca śmaśānādutthātavyañceti lipirasti; ");
INSERT INTO sanias_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","tannāmnā yirūśālamamārabhya sarvvadeśe manaḥparāvarttanasya pāpamocanasya ca susaṁvādaḥ pracārayitavyaḥ, ");
INSERT INTO sanias_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","eṣu sarvveṣu yūyaṁ sākṣiṇaḥ| ");
INSERT INTO sanias_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","aparañca paśyata pitrā yat pratijñātaṁ tat preṣayiṣyāmi, ataeva yāvatkālaṁ yūyaṁ svargīyāṁ śaktiṁ na prāpsyatha tāvatkālaṁ yirūśālamnagare tiṣṭhata| ");
INSERT INTO sanias_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","atha sa tān baithanīyāparyyantaṁ nītvā hastāvuttolya āśiṣa vaktumārebhe ");
INSERT INTO sanias_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","āśiṣaṁ vadanneva ca tebhyaḥ pṛthag bhūtvā svargāya nīto'bhavat| ");
INSERT INTO sanias_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","tadā te taṁ bhajamānā mahānandena yirūśālamaṁ pratyājagmuḥ| ");
INSERT INTO sanias_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","tato nirantaraṁ mandire tiṣṭhanta īśvarasya praśaṁsāṁ dhanyavādañca karttam ārebhire| iti||");
INSERT INTO sanias_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ādau vāda āsīt sa ca vāda īśvareṇa sārdhamāsīt sa vādaḥ svayamīśvara eva| ");
INSERT INTO sanias_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","sa ādāvīśvareṇa sahāsīt| ");
INSERT INTO sanias_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","tena sarvvaṁ vastu sasṛje sarvveṣu sṛṣṭavastuṣu kimapi vastu tenāsṛṣṭaṁ nāsti| ");
INSERT INTO sanias_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","sa jīvanasyākāraḥ, tacca jīvanaṁ manuṣyāṇāṁ jyotiḥ ");
INSERT INTO sanias_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","tajjyotirandhakāre pracakāśe kintvandhakārastanna jagrāha| ");
INSERT INTO sanias_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","yohan nāmaka eko manuja īśvareṇa preṣayāñcakre| ");
INSERT INTO sanias_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","tadvārā yathā sarvve viśvasanti tadarthaṁ sa tajjyotiṣi pramāṇaṁ dātuṁ sākṣisvarūpo bhūtvāgamat, ");
INSERT INTO sanias_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","sa svayaṁ tajjyoti rna kintu tajjyotiṣi pramāṇaṁ dātumāgamat| ");
INSERT INTO sanias_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","jagatyāgatya yaḥ sarvvamanujebhyo dīptiṁ dadāti tadeva satyajyotiḥ| ");
INSERT INTO sanias_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","sa yajjagadasṛjat tanmadya eva sa āsīt kintu jagato lokāstaṁ nājānan| ");
INSERT INTO sanias_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","nijādhikāraṁ sa āgacchat kintu prajāstaṁ nāgṛhlan| ");
INSERT INTO sanias_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","tathāpi ye ye tamagṛhlan arthāt tasya nāmni vyaśvasan tebhya īśvarasya putrā bhavitum adhikāram adadāt| ");
INSERT INTO sanias_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","teṣāṁ janiḥ śoṇitānna śārīrikābhilāṣānna mānavānāmicchāto na kintvīśvarādabhavat| ");
INSERT INTO sanias_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","sa vādo manuṣyarūpeṇāvatīryya satyatānugrahābhyāṁ paripūrṇaḥ san sārdham asmābhi rnyavasat tataḥ pituradvitīyaputrasya yogyo yo mahimā taṁ mahimānaṁ tasyāpaśyāma| ");
INSERT INTO sanias_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","tato yohanapi pracāryya sākṣyamidaṁ dattavān yo mama paścād āgamiṣyati sa matto gurutaraḥ; yato matpūrvvaṁ sa vidyamāna āsīt; yadartham ahaṁ sākṣyamidam adāṁ sa eṣaḥ| ");
INSERT INTO sanias_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","aparañca tasya pūrṇatāyā vayaṁ sarvve kramaśaḥ kramaśonugrahaṁ prāptāḥ| ");
INSERT INTO sanias_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","mūsādvārā vyavasthā dattā kintvanugrahaḥ satyatvañca yīśukhrīṣṭadvārā samupātiṣṭhatāṁ| ");
INSERT INTO sanias_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","kopi manuja īśvaraṁ kadāpi nāpaśyat kintu pituḥ kroḍastho'dvitīyaḥ putrastaṁ prakāśayat| ");
INSERT INTO sanias_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","tvaṁ kaḥ? iti vākyaṁ preṣṭuṁ yadā yihūdīyalokā yājakān levilokāṁśca yirūśālamo yohanaḥ samīpe preṣayāmāsuḥ, ");
INSERT INTO sanias_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","tadā sa svīkṛtavān nāpahnūtavān nāham abhiṣikta ityaṅgīkṛtavān| ");
INSERT INTO sanias_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","tadā te'pṛcchan tarhi ko bhavān? kiṁ eliyaḥ? sovadat na; tataste'pṛcchan tarhi bhavān sa bhaviṣyadvādī? sovadat nāhaṁ saḥ| ");
INSERT INTO sanias_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","tadā te'pṛcchan tarhi bhavān kaḥ? vayaṁ gatvā prerakān tvayi kiṁ vakṣyāmaḥ? svasmin kiṁ vadasi? ");
INSERT INTO sanias_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","tadā sovadat| parameśasya panthānaṁ pariṣkuruta sarvvataḥ| itīdaṁ prāntare vākyaṁ vadataḥ kasyacidravaḥ| kathāmimāṁ yasmin yiśayiyo bhaviṣyadvādī likhitavān soham| ");
INSERT INTO sanias_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ye preṣitāste phirūśilokāḥ| ");
INSERT INTO sanias_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","tadā te'pṛcchan yadi nābhiṣiktosi eliyosi na sa bhaviṣyadvādyapi nāsi ca, tarhi lokān majjayasi kutaḥ? ");
INSERT INTO sanias_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","tato yohan pratyavocat, toye'haṁ majjayāmīti satyaṁ kintu yaṁ yūyaṁ na jānītha tādṛśa eko jano yuṣmākaṁ madhya upatiṣṭhati| ");
INSERT INTO sanias_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","sa matpaścād āgatopi matpūrvvaṁ varttamāna āsīt tasya pādukābandhanaṁ mocayitumapi nāhaṁ yogyosmi| ");
INSERT INTO sanias_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","yarddananadyāḥ pārasthabaithabārāyāṁ yasminsthāne yohanamajjayat tasmina sthāne sarvvametad aghaṭata| ");
INSERT INTO sanias_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","pare'hani yohan svanikaṭamāgacchantaṁ yiśuṁ vilokya prāvocat jagataḥ pāpamocakam īśvarasya meṣaśāvakaṁ paśyata| ");
INSERT INTO sanias_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","yo mama paścādāgamiṣyati sa matto gurutaraḥ, yato hetormatpūrvvaṁ so'varttata yasminnahaṁ kathāmimāṁ kathitavān sa evāyaṁ| ");
INSERT INTO sanias_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","aparaṁ nāhamenaṁ pratyabhijñātavān kintu isrāyellokā enaṁ yathā paricinvanti tadabhiprāyeṇāhaṁ jale majjayitumāgaccham| ");
INSERT INTO sanias_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","punaśca yohanaparamekaṁ pramāṇaṁ datvā kathitavān vihāyasaḥ kapotavad avatarantamātmānam asyoparyyavatiṣṭhantaṁ ca dṛṣṭavānaham| ");
INSERT INTO sanias_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","nāhamenaṁ pratyabhijñātavān iti satyaṁ kintu yo jale majjayituṁ māṁ prairayat sa evemāṁ kathāmakathayat yasyoparyyātmānam avatarantam avatiṣṭhantañca drakṣayasi saeva pavitre ātmani majjayiṣyati| ");
INSERT INTO sanias_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","avastannirīkṣyāyam īśvarasya tanaya iti pramāṇaṁ dadāmi| ");
INSERT INTO sanias_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","pare'hani yohan dvābhyāṁ śiṣyābhyāṁ sārddheṁ tiṣṭhan ");
INSERT INTO sanias_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","yiśuṁ gacchantaṁ vilokya gaditavān, īśvarasya meṣaśāvakaṁ paśyataṁ| ");
INSERT INTO sanias_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","imāṁ kathāṁ śrutvā dvau śiṣyau yīśoḥ paścād īyatuḥ| ");
INSERT INTO sanias_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","tato yīśuḥ parāvṛtya tau paścād āgacchantau dṛṣṭvā pṛṣṭavān yuvāṁ kiṁ gaveśayathaḥ? tāvapṛcchatāṁ he rabbi arthāt he guro bhavān kutra tiṣṭhati? ");
INSERT INTO sanias_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","tataḥ sovādit etya paśyataṁ| tato divasasya tṛtīyapraharasya gatatvāt tau taddinaṁ tasya saṅge'sthātāṁ| ");
INSERT INTO sanias_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","yau dvau yohano vākyaṁ śrutvā yiśoḥ paścād āgamatāṁ tayoḥ śimonpitarasya bhrātā āndriyaḥ ");
INSERT INTO sanias_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","sa itvā prathamaṁ nijasodaraṁ śimonaṁ sākṣātprāpya kathitavān vayaṁ khrīṣṭam arthāt abhiṣiktapuruṣaṁ sākṣātkṛtavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","paścāt sa taṁ yiśoḥ samīpam ānayat| tadā yīśustaṁ dṛṣṭvāvadat tvaṁ yūnasaḥ putraḥ śimon kintu tvannāmadheyaṁ kaiphāḥ vā pitaraḥ arthāt prastaro bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","pare'hani yīśau gālīlaṁ gantuṁ niścitacetasi sati philipanāmānaṁ janaṁ sākṣātprāpyāvocat mama paścād āgaccha| ");
INSERT INTO sanias_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","baitsaidānāmni yasmin grāme pitarāndriyayorvāsa āsīt tasmin grāme tasya philipasya vasatirāsīt| ");
INSERT INTO sanias_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","paścāt philipo nithanelaṁ sākṣātprāpyāvadat mūsā vyavasthā granthe bhaviṣyadvādināṁ grantheṣu ca yasyākhyānaṁ likhitamāste taṁ yūṣaphaḥ putraṁ nāsaratīyaṁ yīśuṁ sākṣād akārṣma vayaṁ| ");
INSERT INTO sanias_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","tadā nithanel kathitavān nāsarannagarāta kiṁ kaściduttama utpantuṁ śaknoti? tataḥ philipo 'vocat etya paśya| ");
INSERT INTO sanias_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","aparañca yīśuḥ svasya samīpaṁ tam āgacchantaṁ dṛṣṭvā vyāhṛtavān, paśyāyaṁ niṣkapaṭaḥ satya isrāyellokaḥ| ");
INSERT INTO sanias_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","tataḥ sovadad, bhavān māṁ kathaṁ pratyabhijānāti? yīśuravādīt philipasya āhvānāt pūrvvaṁ yadā tvamuḍumbarasya tarormūle'sthāstadā tvāmadarśam| ");
INSERT INTO sanias_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","nithanel acakathat, he guro bhavān nitāntam īśvarasya putrosi, bhavān isrāyelvaṁśasya rājā| ");
INSERT INTO sanias_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","tato yīśu rvyāharat, tvāmuḍumbarasya pādapasya mūle dṛṣṭavānāhaṁ mamaitasmādvākyāt kiṁ tvaṁ vyaśvasīḥ? etasmādapyāścaryyāṇi kāryyāṇi drakṣyasi| ");
INSERT INTO sanias_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","anyaccāvādīd yuṣmānahaṁ yathārthaṁ vadāmi, itaḥ paraṁ mocite meghadvāre tasmānmanujasūnunā īśvarasya dūtagaṇam avarohantamārohantañca drakṣyatha| ");
INSERT INTO sanias_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","anantaraṁ trutīyadivase gālīl pradeśiye kānnānāmni nagare vivāha āsīt tatra ca yīśormātā tiṣṭhat| ");
INSERT INTO sanias_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","tasmai vivāhāya yīśustasya śiṣyāśca nimantritā āsan| ");
INSERT INTO sanias_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","tadanantaraṁ drākṣārasasya nyūnatvād yīśormātā tamavadat eteṣāṁ drākṣāraso nāsti| ");
INSERT INTO sanias_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","tadā sa tāmavocat he nāri mayā saha tava kiṁ kāryyaṁ? mama samaya idānīṁ nopatiṣṭhati| ");
INSERT INTO sanias_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","tatastasya mātā dāsānavocad ayaṁ yad vadati tadeva kuruta| ");
INSERT INTO sanias_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","tasmin sthāne yihūdīyānāṁ śucitvakaraṇavyavahārānusāreṇāḍhakaikajaladharāṇi pāṣāṇamayāni ṣaḍvṛhatpātrāṇiāsan| ");
INSERT INTO sanias_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","tadā yīśustān sarvvakalaśān jalaiḥ pūrayituṁ tānājñāpayat, tataste sarvvān kumbhānākarṇaṁ jalaiḥ paryyapūrayan| ");
INSERT INTO sanias_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","atha tebhyaḥ kiñciduttāryya bhojyādhipāteḥsamīpaṁ netuṁ sa tānādiśat, te tadanayan| ");
INSERT INTO sanias_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","aparañca tajjalaṁ kathaṁ drākṣāraso'bhavat tajjalavāhakādāsā jñātuṁ śaktāḥ kintu tadbhojyādhipo jñātuṁ nāśaknot tadavalihya varaṁ saṁmbodyāvadata, ");
INSERT INTO sanias_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","lokāḥ prathamaṁ uttamadrākṣārasaṁ dadati taṣu yatheṣṭaṁ pitavatsu tasmā kiñcidanuttamañca dadati kintu tvamidānīṁ yāvat uttamadrākṣārasaṁ sthāpayasi| ");
INSERT INTO sanias_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","itthaṁ yīśurgālīlapradeśe āścaryyakārmma prārambha nijamahimānaṁ prākāśayat tataḥ śiṣyāstasmin vyaśvasan| ");
INSERT INTO sanias_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","tataḥ param sa nijamātrubhrātrusśiṣyaiḥ sārddhṁ kapharnāhūmam āgamat kintu tatra bahūdināni ātiṣṭhat| ");
INSERT INTO sanias_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","tadanantaraṁ yihūdiyānāṁ nistārotsave nikaṭamāgate yīśu ryirūśālam nagaram āgacchat| ");
INSERT INTO sanias_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","tato mandirasya madhye gomeṣapārāvatavikrayiṇo vāṇijakṣcopaviṣṭān vilokya ");
INSERT INTO sanias_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","rajjubhiḥ kaśāṁ nirmmāya sarvvagomeṣādibhiḥ sārddhaṁ tān mandirād dūrīkṛtavān| ");
INSERT INTO sanias_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","vaṇijāṁ mudrādi vikīryya āsanāni nyūbjīkṛtya pārāvatavikrayibhyo'kathayad asmāt sthānāt sarvāṇyetāni nayata, mama pitugṛhaṁ vāṇijyagṛhaṁ mā kārṣṭa| ");
INSERT INTO sanias_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","tasmāt tanmandirārtha udyogo yastu sa grasatīva mām| imāṁ śāstrīyalipiṁ śiṣyāḥsamasmaran| ");
INSERT INTO sanias_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","tataḥ param yihūdīyalokā yīṣimavadan tavamidṛśakarmmakaraṇāt kiṁ cihnamasmān darśayasi? ");
INSERT INTO sanias_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","tato yīśustānavocad yuṣmābhire tasmin mandire nāśite dinatrayamadhye'haṁ tad utthāpayiṣyāmi| ");
INSERT INTO sanias_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","tadā yihūdiyā vyāhārṣuḥ, etasya mandirasa nirmmāṇena ṣaṭcatvāriṁśad vatsarā gatāḥ, tvaṁ kiṁ dinatrayamadhye tad utthāpayiṣyasi? ");
INSERT INTO sanias_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","kintu sa nijadeharūpamandire kathāmimāṁ kathitavān| ");
INSERT INTO sanias_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","sa yadetādṛśaṁ gaditavān tacchiṣyāḥ śmaśānāt tadīyotthāne sati smṛtvā dharmmagranthe yīśunoktakathāyāṁ ca vyaśvasiṣuḥ| ");
INSERT INTO sanias_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","anantaraṁ nistārotsavasya bhojyasamaye yirūśālam nagare tatkrutāścaryyakarmmāṇi vilokya bahubhistasya nāmani viśvasitaṁ| ");
INSERT INTO sanias_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","kintu sa teṣāṁ kareṣu svaṁ na samarpayat, yataḥ sa sarvvānavait| ");
INSERT INTO sanias_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","sa mānaveṣu kasyacit pramāṇaṁ nāpekṣata yato manujānāṁ madhye yadyadasti tattat sojānāt| ");
INSERT INTO sanias_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","nikadimanāmā yihūdīyānām adhipatiḥ phirūśī kṣaṇadāyāṁ ");
INSERT INTO sanias_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","yīśaurabhyarṇam āvrajya vyāhārṣīt, he guro bhavān īśvarād āgat eka upadeṣṭā, etad asmābhirjñāyate; yato bhavatā yānyāścaryyakarmmāṇi kriyante parameśvarasya sāhāyyaṁ vinā kenāpi tattatkarmmāṇi karttuṁ na śakyante| ");
INSERT INTO sanias_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","tadā yīśuruttaraṁ dattavān tavāhaṁ yathārthataraṁ vyāharāmi punarjanmani na sati kopi mānava īśvarasya rājyaṁ draṣṭuṁ na śaknoti| ");
INSERT INTO sanias_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","tato nikadīmaḥ pratyavocat manujo vṛddho bhūtvā kathaṁ janiṣyate? sa kiṁ puna rmātṛrjaṭharaṁ praviśya janituṁ śaknoti? ");
INSERT INTO sanias_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","yīśuravādīd yathārthataram ahaṁ kathayāmi manuje toyātmabhyāṁ puna rna jāte sa īśvarasya rājyaṁ praveṣṭuṁ na śaknoti| ");
INSERT INTO sanias_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","māṁsād yat jāyate tan māṁsameva tathātmano yo jāyate sa ātmaiva| ");
INSERT INTO sanias_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","yuṣmābhiḥ puna rjanitavyaṁ mamaitasyāṁ kathāyām āścaryaṁ mā maṁsthāḥ| ");
INSERT INTO sanias_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","sadāgatiryāṁ diśamicchati tasyāmeva diśi vāti, tvaṁ tasya svanaṁ śuṇoṣi kintu sa kuta āyāti kutra yāti vā kimapi na jānāsi tadvād ātmanaḥ sakāśāt sarvveṣāṁ manujānāṁ janma bhavati| ");
INSERT INTO sanias_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","tadā nikadīmaḥ pṛṣṭavān etat kathaṁ bhavituṁ śaknoti? ");
INSERT INTO sanias_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","yīśuḥ pratyaktavān tvamisrāyelo gururbhūtvāpi kimetāṁ kathāṁ na vetsi? ");
INSERT INTO sanias_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","tubhyaṁ yathārthaṁ kathayāmi, vayaṁ yad vidmastad vacmaḥ yaṁcca paśyāmastasyaiva sākṣyaṁ dadmaḥ kintu yuṣmābhirasmākaṁ sākṣitvaṁ na gṛhyate| ");
INSERT INTO sanias_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","etasya saṁsārasya kathāyāṁ kathitāyāṁ yadi yūyaṁ na viśvasitha tarhi svargīyāyāṁ kathāyāṁ kathaṁ viśvasiṣyatha? ");
INSERT INTO sanias_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","yaḥ svarge'sti yaṁ ca svargād avārohat taṁ mānavatanayaṁ vinā kopi svargaṁ nārohat| ");
INSERT INTO sanias_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","aparañca mūsā yathā prāntare sarpaṁ protthāpitavān manuṣyaputro'pi tathaivotthāpitavyaḥ; ");
INSERT INTO sanias_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","tasmād yaḥ kaścit tasmin viśvasiṣyati so'vināśyaḥ san anantāyuḥ prāpsyati| ");
INSERT INTO sanias_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","īśvara itthaṁ jagadadayata yat svamadvitīyaṁ tanayaṁ prādadāt tato yaḥ kaścit tasmin viśvasiṣyati so'vināśyaḥ san anantāyuḥ prāpsyati| ");
INSERT INTO sanias_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","īśvaro jagato lokān daṇḍayituṁ svaputraṁ na preṣya tān paritrātuṁ preṣitavān| ");
INSERT INTO sanias_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ataeva yaḥ kaścit tasmin viśvasiti sa daṇḍārho na bhavati kintu yaḥ kaścit tasmin na viśvasiti sa idānīmeva daṇḍārho bhavati,yataḥ sa īśvarasyādvitīyaputrasya nāmani pratyayaṁ na karoti| ");
INSERT INTO sanias_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","jagato madhye jyotiḥ prākāśata kintu manuṣyāṇāṁ karmmaṇāṁ dṛṣṭatvāt te jyotiṣopi timire prīyante etadeva daṇḍasya kāraṇāṁ bhavati| ");
INSERT INTO sanias_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","yaḥ kukarmma karoti tasyācārasya dṛṣṭatvāt sa jyotirṝtīyitvā tannikaṭaṁ nāyāti; ");
INSERT INTO sanias_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","kintu yaḥ satkarmma karoti tasya sarvvāṇi karmmāṇīśvareṇa kṛtānīti sathā prakāśate tadabhiprāyeṇa sa jyotiṣaḥ sannidhim āyāti| ");
INSERT INTO sanias_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","tataḥ param yīśuḥ śiṣyaiḥ sārddhaṁ yihūdīyadeśaṁ gatvā tatra sthitvā majjayitum ārabhata| ");
INSERT INTO sanias_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","tadā śālam nagarasya samīpasthāyini ainan grāme bahutaratoyasthitestatra yohan amajjayat tathā ca lokā āgatya tena majjitā abhavan| ");
INSERT INTO sanias_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","tadā yohan kārāyāṁ na baddhaḥ| ");
INSERT INTO sanias_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","aparañca śācakarmmaṇi yohānaḥ śiṣyaiḥ saha yihūdīyalokānāṁ vivāde jāte, te yohanaḥ saṁnnidhiṁ gatvākathayan, ");
INSERT INTO sanias_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","he guro yarddananadyāḥ pāre bhavatā sārddhaṁ ya āsīt yasmiṁśca bhavān sākṣyaṁ pradadāt paśyatu sopi majjayati sarvve tasya samīpaṁ yānti ca| ");
INSERT INTO sanias_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","tadā yohan pratyavocad īśvareṇa na datte kopi manujaḥ kimapi prāptuṁ na śaknoti| ");
INSERT INTO sanias_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","ahaṁ abhiṣikto na bhavāmi kintu tadagre preṣitosmi yāmimāṁ kathāṁ kathitavānāhaṁ tatra yūyaṁ sarvve sākṣiṇaḥ stha| ");
INSERT INTO sanias_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","yo janaḥ kanyāṁ labhate sa eva varaḥ kintu varasya sannidhau daṇḍāyamānaṁ tasya yanmitraṁ tena varasya śabde śrute'tīvāhlādyate mamāpi tadvad ānandasiddhirjātā| ");
INSERT INTO sanias_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","tena kramaśo varddhitavyaṁ kintu mayā hsitavyaṁ| ");
INSERT INTO sanias_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ya ūrdhvādāgacchat sa sarvveṣāṁ mukhyo yaśca saṁsārād udapadyata sa sāṁsārikaḥ saṁsārīyāṁ kathāñca kathayati yastu svargādāgacchat sa sarvveṣāṁ mukhyaḥ| ");
INSERT INTO sanias_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","sa yadapaśyadaśṛṇocca tasminneva sākṣyaṁ dadāti tathāpi prāyaśaḥ kaścit tasya sākṣyaṁ na gṛhlāti; ");
INSERT INTO sanias_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","kintu yo gṛhlāti sa īśvarasya satyavāditvaṁ mudrāṅgitaṁ karoti| ");
INSERT INTO sanias_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","īśvareṇa yaḥ preritaḥ saeva īśvarīyakathāṁ kathayati yata īśvara ātmānaṁ tasmai aparimitam adadāt| ");
INSERT INTO sanias_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","pitā putre snehaṁ kṛtvā tasya haste sarvvāṇi samarpitavān| ");
INSERT INTO sanias_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","yaḥ kaścit putre viśvasiti sa evānantam paramāyuḥ prāpnoti kintu yaḥ kaścit putre na viśvasiti sa paramāyuṣo darśanaṁ na prāpnoti kintvīśvarasya kopabhājanaṁ bhūtvā tiṣṭhati| ");
INSERT INTO sanias_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","yīśuḥ svayaṁ nāmajjayat kevalaṁ tasya śiṣyā amajjayat kintu yohano'dhikaśiṣyān sa karoti majjayati ca, ");
INSERT INTO sanias_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","phirūśina imāṁ vārttāmaśṛṇvan iti prabhuravagatya ");
INSERT INTO sanias_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","yihūdīyadeśaṁ vihāya puna rgālīlam āgat| ");
INSERT INTO sanias_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","tataḥ śomiroṇapradeśasya madyena tena gantavye sati ");
INSERT INTO sanias_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","yākūb nijaputrāya yūṣaphe yāṁ bhūmim adadāt tatsamīpasthāyi śomiroṇapradeśasya sukhār nāmnā vikhyātasya nagarasya sannidhāvupāsthāt| ");
INSERT INTO sanias_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","tatra yākūbaḥ prahirāsīt; tadā dvitīyayāmavelāyāṁ jātāyāṁ sa mārge śramāpannastasya praheḥ pārśve upāviśat| ");
INSERT INTO sanias_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","etarhi kācit śomiroṇīyā yoṣit toyottolanārtham tatrāgamat ");
INSERT INTO sanias_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","tadā śiṣyāḥ khādyadravyāṇi kretuṁ nagaram agacchan| ");
INSERT INTO sanias_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","yīśuḥ śomiroṇīyāṁ tāṁ yoṣitam vyāhārṣīt mahyaṁ kiñcit pānīyaṁ pātuṁ dehi| kintu śomiroṇīyaiḥ sākaṁ yihūdīyalokā na vyavāharan tasmāddhetoḥ sākathayat śomiroṇīyā yoṣitadahaṁ tvaṁ yihūdīyosi kathaṁ mattaḥ pānīyaṁ pātum icchasi? ");
INSERT INTO sanias_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","tato yīśuravadad īśvarasya yaddānaṁ tatkīdṛk pānīyaṁ pātuṁ mahyaṁ dehi ya itthaṁ tvāṁ yācate sa vā ka iti cedajñāsyathāstarhi tamayāciṣyathāḥ sa ca tubhyamamṛtaṁ toyamadāsyat| ");
INSERT INTO sanias_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","tadā sā sīmantinī bhāṣitavati, he maheccha prahirgambhīro bhavato nīrottolanapātraṁ nāstī ca tasmāt tadamṛtaṁ kīlālaṁ kutaḥ prāpsyasi? ");
INSERT INTO sanias_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","yosmabhyam imamandhūṁ dadau, yasya ca parijanā gomeṣādayaśca sarvve'sya praheḥ pānīyaṁ papuretādṛśo yosmākaṁ pūrvvapuruṣo yākūb tasmādapi bhavān mahān kiṁ? ");
INSERT INTO sanias_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","tato yīśurakathayad idaṁ pānīyaṁ saḥ pivati sa punastṛṣārtto bhaviṣyati, ");
INSERT INTO sanias_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","kintu mayā dattaṁ pānīyaṁ yaḥ pivati sa punaḥ kadāpi tṛṣārtto na bhaviṣyati| mayā dattam idaṁ toyaṁ tasyāntaḥ prasravaṇarūpaṁ bhūtvā anantāyuryāvat sroṣyati| ");
INSERT INTO sanias_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","tadā sā vanitākathayat he maheccha tarhi mama punaḥ pīpāsā yathā na jāyate toyottolanāya yathātrāgamanaṁ na bhavati ca tadarthaṁ mahyaṁ tattoyaṁ dehī| ");
INSERT INTO sanias_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","tato yīśūravadadyāhi tava patimāhūya sthāne'trāgaccha| ");
INSERT INTO sanias_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","sā vāmāvadat mama patirnāsti| yīśuravadat mama patirnāstīti vākyaṁ bhadramavocaḥ| ");
INSERT INTO sanias_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","yatastava pañca patayobhavan adhunā tu tvayā sārddhaṁ yastiṣṭhati sa tava bharttā na vākyamidaṁ satyamavādiḥ| ");
INSERT INTO sanias_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","tadā sā mahilā gaditavati he maheccha bhavān eko bhaviṣyadvādīti buddhaṁ mayā| ");
INSERT INTO sanias_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","asmākaṁ pitṛlokā etasmin śiloccaye'bhajanta, kintu bhavadbhirucyate yirūśālam nagare bhajanayogyaṁ sthānamāste| ");
INSERT INTO sanias_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","yīśuravocat he yoṣit mama vākye viśvasihi yadā yūyaṁ kevalaśaile'smin vā yirūśālam nagare piturbhajanaṁ na kariṣyadhve kāla etādṛśa āyāti| ");
INSERT INTO sanias_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","yūyaṁ yaṁ bhajadhve taṁ na jānītha, kintu vayaṁ yaṁ bhajāmahe taṁ jānīmahe, yato yihūdīyalokānāṁ madhyāt paritrāṇaṁ jāyate| ");
INSERT INTO sanias_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","kintu yadā satyabhaktā ātmanā satyarūpeṇa ca piturbhajanaṁ kariṣyante samaya etādṛśa āyāti, varam idānīmapi vidyate ; yata etādṛśo bhatkān pitā ceṣṭate| ");
INSERT INTO sanias_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","īśvara ātmā; tatastasya ye bhaktāstaiḥ sa ātmanā satyarūpeṇa ca bhajanīyaḥ| ");
INSERT INTO sanias_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","tadā sā mahilāvādīt khrīṣṭanāmnā vikhyāto'bhiṣiktaḥ puruṣa āgamiṣyatīti jānāmi sa ca sarvvāḥ kathā asmān jñāpayiṣyati| ");
INSERT INTO sanias_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","tato yīśuravadat tvayā sārddhaṁ kathanaṁ karomi yo'ham ahameva sa puruṣaḥ| ");
INSERT INTO sanias_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","etasmin samaye śiṣyā āgatya tathā striyā sārddhaṁ tasya kathopakathane mahāścaryyam amanyanta tathāpi bhavān kimicchati? yadvā kimartham etayā sārddhaṁ kathāṁ kathayati? iti kopi nāpṛcchat| ");
INSERT INTO sanias_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","tataḥ paraṁ sā nārī kalaśaṁ sthāpayitvā nagaramadhyaṁ gatvā lokebhyokathāyad ");
INSERT INTO sanias_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","ahaṁ yadyat karmmākaravaṁ tatsarvvaṁ mahyamakathayad etādṛśaṁ mānavamekam āgatya paśyata ru kim abhiṣikto na bhavati ? ");
INSERT INTO sanias_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","tataste nagarād bahirāgatya tātasya samīpam āyan| ");
INSERT INTO sanias_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","etarhi śiṣyāḥ sādhayitvā taṁ vyāhārṣuḥ he guro bhavān kiñcid bhūktāṁ| ");
INSERT INTO sanias_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","tataḥ sovadad yuṣmābhiryanna jñāyate tādṛśaṁ bhakṣyaṁ mamāste| ");
INSERT INTO sanias_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","tadā śiṣyāḥ parasparaṁ praṣṭum ārambhanta, kimasmai kopi kimapi bhakṣyamānīya dattavān? ");
INSERT INTO sanias_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","yīśuravocat matprerakasyābhimatānurūpakaraṇaṁ tasyaiva karmmasiddhikāraṇañca mama bhakṣyaṁ| ");
INSERT INTO sanias_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","māsacatuṣṭaye jāte śasyakarttanasamayo bhaviṣyatīti vākyaṁ yuṣmābhiḥ kiṁ nodyate? kintvahaṁ vadāmi, śira uttolya kṣetrāṇi prati nirīkṣya paśyata, idānīṁ karttanayogyāni śuklavarṇānyabhavan| ");
INSERT INTO sanias_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","yaśchinatti sa vetanaṁ labhate anantāyuḥsvarūpaṁ śasyaṁ sa gṛhlāti ca, tenaiva vaptā chettā ca yugapad ānandataḥ| ");
INSERT INTO sanias_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","itthaṁ sati vapatyekaśchinatyanya iti vacanaṁ siddhyati| ");
INSERT INTO sanias_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","yatra yūyaṁ na paryyaśrāmyata tādṛśaṁ śasyaṁ chettuṁ yuṣmān prairayam anye janāḥparyyaśrāmyan yūyaṁ teṣāṁ śragasya phalam alabhadhvam| ");
INSERT INTO sanias_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","yasmin kāle yadyat karmmākārṣaṁ tatsarvvaṁ sa mahyam akathayat tasyā vanitāyā idaṁ sākṣyavākyaṁ śrutvā tannagaranivāsino bahavaḥ śomiroṇīyalokā vyaśvasan| ");
INSERT INTO sanias_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","tathā ca tasyāntike samupasthāya sveṣāṁ sannidhau katicid dināni sthātuṁ tasmin vinayam akurvvāna tasmāt sa dinadvayaṁ tatsthāne nyavaṣṭat ");
INSERT INTO sanias_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","tatastasyopadeśena bahavo'pare viśvasya ");
INSERT INTO sanias_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","tāṁ yoṣāmavadan kevalaṁ tava vākyena pratīma iti na, kintu sa jagato'bhiṣiktastrāteti tasya kathāṁ śrutvā vayaṁ svayamevājñāsamahi| ");
INSERT INTO sanias_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","svadeśe bhaviṣyadvaktuḥ satkāro nāstīti yadyapi yīśuḥ pramāṇaṁ datvākathayat ");
INSERT INTO sanias_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","tathāpi divasadvayāt paraṁ sa tasmāt sthānād gālīlaṁ gatavān| ");
INSERT INTO sanias_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","anantaraṁ ye gālīlī liyalokā utsave gatā utsavasamaye yirūśalam nagare tasya sarvvāḥ kriyā apaśyan te gālīlam āgataṁ tam āgṛhlan| ");
INSERT INTO sanias_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","tataḥ param yīśu ryasmin kānnānagare jalaṁ drākṣārasam ākarot tat sthānaṁ punaragāt| tasminneva samaye kasyacid rājasabhāstārasya putraḥ kapharnāhūmapurī rogagrasta āsīt| ");
INSERT INTO sanias_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","sa yehūdīyadeśād yīśo rgālīlāgamanavārttāṁ niśamya tasya samīpaṁ gatvā prārthya vyāhṛtavān mama putrasya prāyeṇa kāla āsannaḥ bhavān āgatya taṁ svasthaṁ karotu| ");
INSERT INTO sanias_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","tadā yīśurakathayad āścaryyaṁ karmma citraṁ cihnaṁ ca na dṛṣṭā yūyaṁ na pratyeṣyatha| ");
INSERT INTO sanias_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","tataḥ sa sabhāsadavadat he maheccha mama putre na mṛte bhavānāgacchatu| ");
INSERT INTO sanias_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","yīśustamavadad gaccha tava putro'jīvīt tadā yīśunoktavākye sa viśvasya gatavān| ");
INSERT INTO sanias_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","gamanakāle mārgamadhye dāsāstaṁ sākṣātprāpyāvadan bhavataḥ putro'jīvīt| ");
INSERT INTO sanias_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","tataḥ kaṁ kālamārabhya rogapratīkārārambho jātā iti pṛṣṭe tairuktaṁ hyaḥ sārddhadaṇḍadvayādhikadvitīyayāme tasya jvaratyāgo'bhavat| ");
INSERT INTO sanias_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","tadā yīśustasmin kṣaṇe proktavān tava putro'jīvīt pitā tadbuddhvā saparivāro vyaśvasīt| ");
INSERT INTO sanias_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","yihūdīyadeśād āgatya gālīli yīśuretad dvitīyam āścaryyakarmmākarot| ");
INSERT INTO sanias_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","tataḥ paraṁ yihūdīyānām utsava upasthite yīśu ryirūśālamaṁ gatavān| ");
INSERT INTO sanias_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","tasminnagare meṣanāmno dvārasya samīpe ibrīyabhāṣayā baithesdā nāmnā piṣkariṇī pañcaghaṭṭayuktāsīt| ");
INSERT INTO sanias_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","tasyāsteṣu ghaṭṭeṣu kilālakampanam apekṣya andhakhañcaśuṣkāṅgādayo bahavo rogiṇaḥ patantastiṣṭhanti sma| ");
INSERT INTO sanias_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","yato viśeṣakāle tasya saraso vāri svargīyadūta etyākampayat tatkīlālakampanāt paraṁ yaḥ kaścid rogī prathamaṁ pānīyamavārohat sa eva tatkṣaṇād rogamukto'bhavat| ");
INSERT INTO sanias_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","tadāṣṭātriṁśadvarṣāṇi yāvad rogagrasta ekajanastasmin sthāne sthitavān| ");
INSERT INTO sanias_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","yīśustaṁ śayitaṁ dṛṣṭvā bahukālikarogīti jñātvā vyāhṛtavān tvaṁ kiṁ svastho bubhūṣasi? ");
INSERT INTO sanias_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","tato rogī kathitavān he maheccha yadā kīlālaṁ kampate tadā māṁ puṣkariṇīm avarohayituṁ mama kopi nāsti, tasmān mama gamanakāle kaścidanyo'gro gatvā avarohati| ");
INSERT INTO sanias_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","tadā yīśurakathayad uttiṣṭha, tava śayyāmuttolya gṛhītvā yāhi| ");
INSERT INTO sanias_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","sa tatkṣaṇāt svastho bhūtvā śayyāmuttolyādāya gatavān kintu taddinaṁ viśrāmavāraḥ| ");
INSERT INTO sanias_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","tasmād yihūdīyāḥ svasthaṁ naraṁ vyāharan adya viśrāmavāre śayanīyamādāya na yātavyam| ");
INSERT INTO sanias_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","tataḥ sa pratyavocad yo māṁ svastham akārṣīt śayanīyam uttolyādāya yātuṁ māṁ sa evādiśat| ");
INSERT INTO sanias_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","tadā te'pṛcchan śayanīyam uttolyādāya yātuṁ ya ājñāpayat sa kaḥ? ");
INSERT INTO sanias_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","kintu sa ka iti svasthībhūto nājānād yatastasmin sthāne janatāsattvād yīśuḥ sthānāntaram āgamat| ");
INSERT INTO sanias_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","tataḥ paraṁ yeśu rmandire taṁ naraṁ sākṣātprāpyākathayat paśyedānīm anāmayo jātosi yathādhikā durdaśā na ghaṭate taddhetoḥ pāpaṁ karmma punarmākārṣīḥ| ");
INSERT INTO sanias_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","tataḥ sa gatvā yihūdīyān avadad yīśu rmām arogiṇam akārṣīt| ");
INSERT INTO sanias_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","tato yīśu rviśrāmavāre karmmedṛśaṁ kṛtavān iti heto ryihūdīyāstaṁ tāḍayitvā hantum aceṣṭanta| ");
INSERT INTO sanias_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","yīśustānākhyat mama pitā yat kāryyaṁ karoti tadanurūpam ahamapi karoti| ");
INSERT INTO sanias_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","tato yihūdīyāstaṁ hantuṁ punarayatanta yato viśrāmavāraṁ nāmanyata tadeva kevalaṁ na adhikantu īśvaraṁ svapitaraṁ procya svamapīśvaratulyaṁ kṛtavān| ");
INSERT INTO sanias_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","paścād yīśuravadad yuṣmānahaṁ yathārthataraṁ vadāmi putraḥ pitaraṁ yadyat karmma kurvvantaṁ paśyati tadatiriktaṁ svecchātaḥ kimapi karmma karttuṁ na śaknoti| pitā yat karoti putropi tadeva karoti| ");
INSERT INTO sanias_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","pitā putre snehaṁ karoti tasmāt svayaṁ yadyat karmma karoti tatsarvvaṁ putraṁ darśayati ; yathā ca yuṣmākaṁ āścaryyajñānaṁ janiṣyate tadartham itopi mahākarmma taṁ darśayiṣyati| ");
INSERT INTO sanias_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","vastutastu pitā yathā pramitān utthāpya sajivān karoti tadvat putropi yaṁ yaṁ icchati taṁ taṁ sajīvaṁ karoti| ");
INSERT INTO sanias_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","sarvve pitaraṁ yathā satkurvvanti tathā putramapi satkārayituṁ pitā svayaṁ kasyāpi vicāramakṛtvā sarvvavicārāṇāṁ bhāraṁ putre samarpitavān| ");
INSERT INTO sanias_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","yaḥ putraṁ sat karoti sa tasya prerakamapi sat karoti| ");
INSERT INTO sanias_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","yuṣmānāhaṁ yathārthataraṁ vadāmi yo jano mama vākyaṁ śrutvā matprerake viśvasiti sonantāyuḥ prāpnoti kadāpi daṇḍabājanaṁ na bhavati nidhanādutthāya paramāyuḥ prāpnoti| ");
INSERT INTO sanias_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","ahaṁ yuṣmānatiyathārthaṁ vadāmi yadā mṛtā īśvaraputrasya ninādaṁ śroṣyanti ye ca śroṣyanti te sajīvā bhaviṣyanti samaya etādṛśa āyāti varam idānīmapyupatiṣṭhati| ");
INSERT INTO sanias_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","pitā yathā svayañjīvī tathā putrāya svayañjīvitvādhikāraṁ dattavān| ");
INSERT INTO sanias_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","sa manuṣyaputraḥ etasmāt kāraṇāt pitā daṇḍakaraṇādhikāramapi tasmin samarpitavān| ");
INSERT INTO sanias_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","etadarthe yūyam āścaryyaṁ na manyadhvaṁ yato yasmin samaye tasya ninādaṁ śrutvā śmaśānasthāḥ sarvve bahirāgamiṣyanti samaya etādṛśa upasthāsyati| ");
INSERT INTO sanias_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","tasmād ye satkarmmāṇi kṛtavantasta utthāya āyuḥ prāpsyanti ye ca kukarmāṇi kṛtavantasta utthāya daṇḍaṁ prāpsyanti| ");
INSERT INTO sanias_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","ahaṁ svayaṁ kimapi karttuṁ na śaknomi yathā śuṇomi tathā vicārayāmi mama vicārañca nyāyyaḥ yatohaṁ svīyābhīṣṭaṁ nehitvā matprerayituḥ pituriṣṭam īhe| ");
INSERT INTO sanias_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","yadi svasmin svayaṁ sākṣyaṁ dadāmi tarhi tatsākṣyam āgrāhyaṁ bhavati ; ");
INSERT INTO sanias_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","kintu madarthe'paro janaḥ sākṣyaṁ dadāti madarthe tasya yat sākṣyaṁ tat satyam etadapyahaṁ jānāmi| ");
INSERT INTO sanias_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","yuṣmābhi ryohanaṁ prati lokeṣu preriteṣu sa satyakathāyāṁ sākṣyamadadāt| ");
INSERT INTO sanias_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","mānuṣādahaṁ sākṣyaṁ nopekṣe tathāpi yūyaṁ yathā paritrayadhve tadartham idaṁ vākyaṁ vadāmi| ");
INSERT INTO sanias_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","yohan dedīpyamāno dīpa iva tejasvī sthitavān yūyam alpakālaṁ tasya dīptyānandituṁ samamanyadhvaṁ| ");
INSERT INTO sanias_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","kintu tatpramāṇādapi mama gurutaraṁ pramāṇaṁ vidyate pitā māṁ preṣya yadyat karmma samāpayituṁ śakttimadadāt mayā kṛtaṁ tattat karmma madarthe pramāṇaṁ dadāti| ");
INSERT INTO sanias_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","yaḥ pitā māṁ preritavān mopi madarthe pramāṇaṁ dadāti| tasya vākyaṁ yuṣmābhiḥ kadāpi na śrutaṁ tasya rūpañca na dṛṣṭaṁ ");
INSERT INTO sanias_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","tasya vākyañca yuṣmākam antaḥ kadāpi sthānaṁ nāpnoti yataḥ sa yaṁ preṣitavān yūyaṁ tasmin na viśvasitha| ");
INSERT INTO sanias_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","dharmmapustakāni yūyam ālocayadhvaṁ tai rvākyairanantāyuḥ prāpsyāma iti yūyaṁ budhyadhve taddharmmapustakāni madarthe pramāṇaṁ dadati| ");
INSERT INTO sanias_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","tathāpi yūyaṁ paramāyuḥprāptaye mama saṁnidhim na jigamiṣatha| ");
INSERT INTO sanias_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","ahaṁ mānuṣebhyaḥ satkāraṁ na gṛhlāmi| ");
INSERT INTO sanias_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ahaṁ yuṣmān jānāmi; yuṣmākamantara īśvaraprema nāsti| ");
INSERT INTO sanias_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ahaṁ nijapitu rnāmnāgatosmi tathāpi māṁ na gṛhlītha kintu kaścid yadi svanāmnā samāgamiṣyati tarhi taṁ grahīṣyatha| ");
INSERT INTO sanias_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","yūyam īśvarāt satkāraṁ na ciṣṭatvā kevalaṁ parasparaṁ satkāram ced ādadhvve tarhi kathaṁ viśvasituṁ śaknutha? ");
INSERT INTO sanias_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","putuḥ samīpe'haṁ yuṣmān apavadiṣyāmīti mā cintayata yasmin , yasmin yuṣmākaṁ viśvasaḥ saeva mūsā yuṣmān apavadati| ");
INSERT INTO sanias_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","yadi yūyaṁ tasmin vyaśvasiṣyata tarhi mayyapi vyaśvasiṣyata, yat sa mayi likhitavān| ");
INSERT INTO sanias_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","tato yadi tena likhitavāni na pratitha tarhi mama vākyāni kathaṁ pratyeṣyatha? ");
INSERT INTO sanias_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","tataḥ paraṁ yīśu rgālīl pradeśīyasya tiviriyānāmnaḥ sindhoḥ pāraṁ gatavān| ");
INSERT INTO sanias_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","tato vyādhimallokasvāsthyakaraṇarūpāṇi tasyāścaryyāṇi karmmāṇi dṛṣṭvā bahavo janāstatpaścād agacchan| ");
INSERT INTO sanias_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","tato yīśuḥ parvvatamāruhya tatra śiṣyaiḥ sākam| ");
INSERT INTO sanias_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","tasmin samaya nistārotsavanāmni yihūdīyānāma utsava upasthite ");
INSERT INTO sanias_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","yīśu rnetre uttolya bahulokān svasamīpāgatān vilokya philipaṁ pṛṣṭavān eteṣāṁ bhojanāya bhojadravyāṇi vayaṁ kutra kretuṁ śakrumaḥ? ");
INSERT INTO sanias_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","vākyamidaṁ tasya parīkṣārtham avādīt kintu yat kariṣyati tat svayam ajānāt| ");
INSERT INTO sanias_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","philipaḥ pratyavocat eteṣām ekaiko yadyalpam alpaṁ prāpnoti tarhi mudrāpādadviśatena krītapūpā api nyūnā bhaviṣyanti| ");
INSERT INTO sanias_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","śimon pitarasya bhrātā āndriyākhyaḥ śiṣyāṇāmeko vyāhṛtavān ");
INSERT INTO sanias_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","atra kasyacid bālakasya samīpe pañca yāvapūpāḥ kṣudramatsyadvayañca santi kintu lokānāṁ etāvātāṁ madhye taiḥ kiṁ bhaviṣyati? ");
INSERT INTO sanias_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","paścād yīśuravadat lokānupaveśayata tatra bahuyavasasattvāt pañcasahastrebhyo nyūnā adhikā vā puruṣā bhūmyām upāviśan| ");
INSERT INTO sanias_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","tato yīśustān pūpānādāya īśvarasya guṇān kīrttayitvā śiṣyeṣu samārpayat tataste tebhya upaviṣṭalokebhyaḥ pūpān yatheṣṭamatsyañca prāduḥ| ");
INSERT INTO sanias_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","teṣu tṛpteṣu sa tānavocad eteṣāṁ kiñcidapi yathā nāpacīyate tathā sarvvāṇyavaśiṣṭāni saṁgṛhlīta| ");
INSERT INTO sanias_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","tataḥ sarvveṣāṁ bhojanāt paraṁ te teṣāṁ pañcānāṁ yāvapūpānāṁ avaśiṣṭānyakhilāni saṁgṛhya dvādaśaḍallakān apūrayan| ");
INSERT INTO sanias_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","aparaṁ yīśoretādṛśīm āścaryyakriyāṁ dṛṣṭvā lokā mitho vaktumārebhire jagati yasyāgamanaṁ bhaviṣyati sa evāyam avaśyaṁ bhaviṣyadvakttā| ");
INSERT INTO sanias_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ataeva lokā āgatya tamākramya rājānaṁ kariṣyanti yīśusteṣām īdṛśaṁ mānasaṁ vijñāya punaśca parvvatam ekākī gatavān| ");
INSERT INTO sanias_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","sāyaṁkāla upasthite śiṣyā jaladhitaṭaṁ vrajitvā nāvamāruhya nagaradiśi sindhau vāhayitvāgaman| ");
INSERT INTO sanias_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","tasmin samaye timira upātiṣṭhat kintu yīṣusteṣāṁ samīpaṁ nāgacchat| ");
INSERT INTO sanias_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","tadā prabalapavanavahanāt sāgare mahātaraṅgo bhavitum ārebhe| ");
INSERT INTO sanias_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","tataste vāhayitvā dvitrān krośān gatāḥ paścād yīśuṁ jaladherupari padbhyāṁ vrajantaṁ naukāntikam āgacchantaṁ vilokya trāsayuktā abhavan ");
INSERT INTO sanias_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","kintu sa tānukttavān ayamahaṁ mā bhaiṣṭa| ");
INSERT INTO sanias_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","tadā te taṁ svairaṁ nāvi gṛhītavantaḥ tadā tatkṣaṇād uddiṣṭasthāne naurupāsthāt| ");
INSERT INTO sanias_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","yayā nāvā śiṣyā agacchan tadanyā kāpi naukā tasmin sthāne nāsīt tato yīśuḥ śiṣyaiḥ sākaṁ nāgamat kevalāḥ śiṣyā agaman etat pārasthā lokā jñātavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","kintu tataḥ paraṁ prabhu ryatra īśvarasya guṇān anukīrttya lokān pūpān abhojayat tatsthānasya samīpasthativiriyāyā aparāstaraṇaya āgaman| ");
INSERT INTO sanias_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","yīśustatra nāsti śiṣyā api tatra nā santi lokā iti vijñāya yīśuṁ gaveṣayituṁ taraṇibhiḥ kapharnāhūm puraṁ gatāḥ| ");
INSERT INTO sanias_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","tataste saritpateḥ pāre taṁ sākṣāt prāpya prāvocan he guro bhavān atra sthāne kadāgamat? ");
INSERT INTO sanias_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","tadā yīśustān pratyavādīd yuṣmānahaṁ yathārthataraṁ vadāmi āścaryyakarmmadarśanāddheto rna kintu pūpabhojanāt tena tṛptatvāñca māṁ gaveṣayatha| ");
INSERT INTO sanias_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","kṣayaṇīyabhakṣyārthaṁ mā śrāmiṣṭa kintvantāyurbhakṣyārthaṁ śrāmyata, tasmāt tādṛśaṁ bhakṣyaṁ manujaputro yuṣmābhyaṁ dāsyati; tasmin tāta īśvaraḥ pramāṇaṁ prādāt| ");
INSERT INTO sanias_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","tadā te'pṛcchan īśvarābhimataṁ karmma karttum asmābhiḥ kiṁ karttavyaṁ? ");
INSERT INTO sanias_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","tato yīśuravadad īśvaro yaṁ prairayat tasmin viśvasanam īśvarābhimataṁ karmma| ");
INSERT INTO sanias_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","tadā te vyāharan bhavatā kiṁ lakṣaṇaṁ darśitaṁ yaddṛṣṭvā bhavati viśvasiṣyāmaḥ? tvayā kiṁ karmma kṛtaṁ? ");
INSERT INTO sanias_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","asmākaṁ pūrvvapuruṣā mahāprāntare mānnāṁ bhokttuṁ prāpuḥ yathā lipirāste| svargīyāṇi tu bhakṣyāṇi pradadau parameśvaraḥ| ");
INSERT INTO sanias_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","tadā yīśuravadad ahaṁ yuṣmānatiyathārthaṁ vadāmi mūsā yuṣmābhyaṁ svargīyaṁ bhakṣyaṁ nādāt kintu mama pitā yuṣmābhyaṁ svargīyaṁ paramaṁ bhakṣyaṁ dadāti| ");
INSERT INTO sanias_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","yaḥ svargādavaruhya jagate jīvanaṁ dadāti sa īśvaradattabhakṣyarūpaḥ| ");
INSERT INTO sanias_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","tadā te prāvocan he prabho bhakṣyamidaṁ nityamasmabhyaṁ dadātu| ");
INSERT INTO sanias_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","yīśuravadad ahameva jīvanarūpaṁ bhakṣyaṁ yo jano mama sannidhim āgacchati sa jātu kṣudhārtto na bhaviṣyati, tathā yo jano māṁ pratyeti sa jātu tṛṣārtto na bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","māṁ dṛṣṭvāpi yūyaṁ na viśvasitha yuṣmānaham ityavocaṁ| ");
INSERT INTO sanias_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","pitā mahyaṁ yāvato lokānadadāt te sarvva eva mamāntikam āgamiṣyanti yaḥ kaścicca mama sannidhim āyāsyati taṁ kenāpi prakāreṇa na dūrīkariṣyāmi| ");
INSERT INTO sanias_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","nijābhimataṁ sādhayituṁ na hi kintu prerayiturabhimataṁ sādhayituṁ svargād āgatosmi| ");
INSERT INTO sanias_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","sa yān yān lokān mahyamadadāt teṣāmekamapi na hārayitvā śeṣadine sarvvānaham utthāpayāmi idaṁ matprerayituḥ piturabhimataṁ| ");
INSERT INTO sanias_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","yaḥ kaścin mānavasutaṁ vilokya viśvasiti sa śeṣadine mayotthāpitaḥ san anantāyuḥ prāpsyati iti matprerakasyābhimataṁ| ");
INSERT INTO sanias_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","tadā svargād yad bhakṣyam avārohat tad bhakṣyam ahameva yihūdīyalokāstasyaitad vākye vivadamānā vakttumārebhire ");
INSERT INTO sanias_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","yūṣaphaḥ putro yīśu ryasya mātāpitarau vayaṁ jānīma eṣa kiṁ saeva na? tarhi svargād avāroham iti vākyaṁ kathaṁ vaktti? ");
INSERT INTO sanias_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","tadā yīśustān pratyavadat parasparaṁ mā vivadadhvaṁ ");
INSERT INTO sanias_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","matprerakeṇa pitrā nākṛṣṭaḥ kopi jano mamāntikam āyātuṁ na śaknoti kintvāgataṁ janaṁ carame'hni protthāpayiṣyāmi| ");
INSERT INTO sanias_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","te sarvva īśvareṇa śikṣitā bhaviṣyanti bhaviṣyadvādināṁ grantheṣu lipiritthamāste ato yaḥ kaścit pituḥ sakāśāt śrutvā śikṣate sa eva mama samīpam āgamiṣyati| ");
INSERT INTO sanias_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ya īśvarād ajāyata taṁ vinā kopi manuṣyo janakaṁ nādarśat kevalaḥ saeva tātam adrākṣīt| ");
INSERT INTO sanias_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","ahaṁ yuṣmān yathārthataraṁ vadāmi yo jano mayi viśvāsaṁ karoti sonantāyuḥ prāpnoti| ");
INSERT INTO sanias_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ahameva tajjīvanabhakṣyaṁ| ");
INSERT INTO sanias_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","yuṣmākaṁ pūrvvapuruṣā mahāprāntare mannābhakṣyaṁ bhūkttāpi mṛtāḥ ");
INSERT INTO sanias_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","kintu yadbhakṣyaṁ svargādāgacchat tad yadi kaścid bhuṅktte tarhi sa na mriyate| ");
INSERT INTO sanias_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","yajjīvanabhakṣyaṁ svargādāgacchat sohameva idaṁ bhakṣyaṁ yo jano bhuṅktte sa nityajīvī bhaviṣyati| punaśca jagato jīvanārthamahaṁ yat svakīyapiśitaṁ dāsyāmi tadeva mayā vitaritaṁ bhakṣyam| ");
INSERT INTO sanias_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","tasmād yihūdīyāḥ parasparaṁ vivadamānā vakttumārebhire eṣa bhojanārthaṁ svīyaṁ palalaṁ katham asmabhyaṁ dāsyati? ");
INSERT INTO sanias_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","tadā yīśustān āvocad yuṣmānahaṁ yathārthataraṁ vadāmi manuṣyaputrasyāmiṣe yuṣmābhi rna bhuktte tasya rudhire ca na pīte jīvanena sārddhaṁ yuṣmākaṁ sambandho nāsti| ");
INSERT INTO sanias_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","yo mamāmiṣaṁ svādati mama sudhirañca pivati sonantāyuḥ prāpnoti tataḥ śeṣe'hni tamaham utthāpayiṣyāmi| ");
INSERT INTO sanias_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","yato madīyamāmiṣaṁ paramaṁ bhakṣyaṁ tathā madīyaṁ śoṇitaṁ paramaṁ peyaṁ| ");
INSERT INTO sanias_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","yo jano madīyaṁ palalaṁ svādati madīyaṁ rudhirañca pivati sa mayi vasati tasminnahañca vasāmi| ");
INSERT INTO sanias_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","matprerayitrā jīvatā tātena yathāhaṁ jīvāmi tadvad yaḥ kaścin māmatti sopi mayā jīviṣyati| ");
INSERT INTO sanias_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","yadbhakṣyaṁ svargādāgacchat tadidaṁ yanmānnāṁ svāditvā yuṣmākaṁ pitaro'mriyanta tādṛśam idaṁ bhakṣyaṁ na bhavati idaṁ bhakṣyaṁ yo bhakṣati sa nityaṁ jīviṣyati| ");
INSERT INTO sanias_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","yadā kapharnāhūm puryyāṁ bhajanagehe upādiśat tadā kathā etā akathayat| ");
INSERT INTO sanias_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","tadetthaṁ śrutvā tasya śiṣyāṇām aneke parasparam akathayan idaṁ gāḍhaṁ vākyaṁ vākyamīdṛśaṁ kaḥ śrotuṁ śakruyāt? ");
INSERT INTO sanias_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","kintu yīśuḥ śiṣyāṇām itthaṁ vivādaṁ svacitte vijñāya kathitavān idaṁ vākyaṁ kiṁ yuṣmākaṁ vighnaṁ janayati? ");
INSERT INTO sanias_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","yadi manujasutaṁ pūrvvavāsasthānam ūrdvvaṁ gacchantaṁ paśyatha tarhi kiṁ bhaviṣyati? ");
INSERT INTO sanias_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","ātmaiva jīvanadāyakaḥ vapu rniṣphalaṁ yuṣmabhyamahaṁ yāni vacāṁsi kathayāmi tānyātmā jīvanañca| ");
INSERT INTO sanias_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","kintu yuṣmākaṁ madhye kecana aviśvāsinaḥ santi ke ke na viśvasanti ko vā taṁ parakareṣu samarpayiṣyati tān yīśurāprathamād vetti| ");
INSERT INTO sanias_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","aparamapi kathitavān asmāt kāraṇād akathayaṁ pituḥ sakāśāt śakttimaprāpya kopi mamāntikam āgantuṁ na śaknoti| ");
INSERT INTO sanias_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","tatkāle'neke śiṣyā vyāghuṭya tena sārddhaṁ puna rnāgacchan| ");
INSERT INTO sanias_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","tadā yīśu rdvādaśaśiṣyān ukttavān yūyamapi kiṁ yāsyatha? ");
INSERT INTO sanias_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","tataḥ śimon pitaraḥ pratyavocat he prabho kasyābhyarṇaṁ gamiṣyāmaḥ? ");
INSERT INTO sanias_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","anantajīvanadāyinyo yāḥ kathāstāstavaiva| bhavān amareśvarasyābhiṣikttaputra iti viśvasya niścitaṁ jānīmaḥ| ");
INSERT INTO sanias_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","tadā yīśuravadat kimahaṁ yuṣmākaṁ dvādaśajanān manonītān na kṛtavān? kintu yuṣmākaṁ madhyepi kaścideko vighnakārī vidyate| ");
INSERT INTO sanias_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","imāṁ kathaṁ sa śimonaḥ putram īṣkarīyotīyaṁ yihūdām uddiśya kathitavān yato dvādaśānāṁ madhye gaṇitaḥ sa taṁ parakareṣu samarpayiṣyati| ");
INSERT INTO sanias_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","tataḥ paraṁ yihūdīyalokāstaṁ hantuṁ samaihanta tasmād yīśu ryihūdāpradeśe paryyaṭituṁ necchan gālīl pradeśe paryyaṭituṁ prārabhata| ");
INSERT INTO sanias_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","kintu tasmin samaye yihūdīyānāṁ dūṣyavāsanāmotsava upasthite ");
INSERT INTO sanias_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","tasya bhrātarastam avadan yāni karmmāṇi tvayā kriyante tāni yathā tava śiṣyāḥ paśyanti tadarthaṁ tvamitaḥ sthānād yihūdīyadeśaṁ vraja| ");
INSERT INTO sanias_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","yaḥ kaścit svayaṁ pracikāśiṣati sa kadāpi guptaṁ karmma na karoti yadīdṛśaṁ karmma karoṣi tarhi jagati nijaṁ paricāyaya| ");
INSERT INTO sanias_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","yatastasya bhrātaropi taṁ na viśvasanti| ");
INSERT INTO sanias_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","tadā yīśustān avocat mama samaya idānīṁ nopatiṣṭhati kintu yuṣmākaṁ samayaḥ satatam upatiṣṭhati| ");
INSERT INTO sanias_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","jagato lokā yuṣmān ṛtīyituṁ na śakruvanti kintu māmeva ṛtīyante yatasteṣāṁ karmāṇi duṣṭāni tatra sākṣyamidam ahaṁ dadāmi| ");
INSERT INTO sanias_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","ataeva yūyam utsave'smin yāta nāham idānīm asminnutsave yāmi yato mama samaya idānīṁ na sampūrṇaḥ| ");
INSERT INTO sanias_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","iti vākyam ukttvā sa gālīli sthitavān ");
INSERT INTO sanias_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","kintu tasya bhrātṛṣu tatra prasthiteṣu satsu so'prakaṭa utsavam agacchat| ");
INSERT INTO sanias_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","anantaram utsavam upasthitā yihūdīyāstaṁ mṛgayitvāpṛcchan sa kutra? ");
INSERT INTO sanias_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","tato lokānāṁ madhye tasmin nānāvidhā vivādā bhavitum ārabdhavantaḥ| kecid avocan sa uttamaḥ puruṣaḥ kecid avocan na tathā varaṁ lokānāṁ bhramaṁ janayati| ");
INSERT INTO sanias_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","kintu yihūdīyānāṁ bhayāt kopi tasya pakṣe spaṣṭaṁ nākathayat| ");
INSERT INTO sanias_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","tataḥ param utsavasya madhyasamaye yīśu rmandiraṁ gatvā samupadiśati sma| ");
INSERT INTO sanias_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","tato yihūdīyā lokā āścaryyaṁ jñātvākathayan eṣā mānuṣo nādhītyā katham etādṛśo vidvānabhūt? ");
INSERT INTO sanias_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","tadā yīśuḥ pratyavocad upadeśoyaṁ na mama kintu yo māṁ preṣitavān tasya| ");
INSERT INTO sanias_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","yo jano nideśaṁ tasya grahīṣyati mamopadeśo matto bhavati kim īśvarād bhavati sa ganastajjñātuṁ śakṣyati| ");
INSERT INTO sanias_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","yo janaḥ svataḥ kathayati sa svīyaṁ gauravam īhate kintu yaḥ prerayitu rgauravam īhate sa satyavādī tasmin kopyadharmmo nāsti| ");
INSERT INTO sanias_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","mūsā yuṣmabhyaṁ vyavasthāgranthaṁ kiṁ nādadāt? kintu yuṣmākaṁ kopi tāṁ vyavasthāṁ na samācarati| māṁ hantuṁ kuto yatadhve? ");
INSERT INTO sanias_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","tadā lokā avadan tvaṁ bhūtagrastastvāṁ hantuṁ ko yatate? ");
INSERT INTO sanias_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","tato yīśuravocad ekaṁ karmma mayākāri tasmād yūyaṁ sarvva mahāścaryyaṁ manyadhve| ");
INSERT INTO sanias_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","mūsā yuṣmabhyaṁ tvakchedavidhiṁ pradadau sa mūsāto na jātaḥ kintu pitṛpuruṣebhyo jātaḥ tena viśrāmavāre'pi mānuṣāṇāṁ tvakchedaṁ kurutha| ");
INSERT INTO sanias_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ataeva viśrāmavāre manuṣyāṇāṁ tvakchede kṛte yadi mūsāvyavasthāmaṅganaṁ na bhavati tarhi mayā viśrāmavāre mānuṣaḥ sampūrṇarūpeṇa svastho'kāri tatkāraṇād yūyaṁ kiṁ mahyaṁ kupyatha? ");
INSERT INTO sanias_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","sapakṣapātaṁ vicāramakṛtvā nyāyyaṁ vicāraṁ kuruta| ");
INSERT INTO sanias_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","tadā yirūśālam nivāsinaḥ katipayajanā akathayan ime yaṁ hantuṁ ceṣṭante sa evāyaṁ kiṁ na? ");
INSERT INTO sanias_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","kintu paśyata nirbhayaḥ san kathāṁ kathayati tathāpi kimapi a vadantyete ayamevābhiṣiktto bhavatīti niścitaṁ kimadhipatayo jānanti? ");
INSERT INTO sanias_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","manujoyaṁ kasmādāgamad iti vayaṁ jānomaḥ kintvabhiṣiktta āgate sa kasmādāgatavān iti kopi jñātuṁ na śakṣyati| ");
INSERT INTO sanias_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","tadā yīśu rmadhyemandiram upadiśan uccaiḥkāram ukttavān yūyaṁ kiṁ māṁ jānītha? kasmāccāgatosmi tadapi kiṁ jānītha? nāhaṁ svata āgatosmi kintu yaḥ satyavādī saeva māṁ preṣitavān yūyaṁ taṁ na jānītha| ");
INSERT INTO sanias_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","tamahaṁ jāne tenāhaṁ prerita agatosmi| ");
INSERT INTO sanias_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","tasmād yihūdīyāstaṁ dharttum udyatāstathāpi kopi tasya gātre hastaṁ nārpayad yato hetostadā tasya samayo nopatiṣṭhati| ");
INSERT INTO sanias_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","kintu bahavo lokāstasmin viśvasya kathitavānto'bhiṣikttapuruṣa āgatya mānuṣasyāsya kriyābhyaḥ kim adhikā āścaryyāḥ kriyāḥ kariṣyati? ");
INSERT INTO sanias_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","tataḥ paraṁ lokāstasmin itthaṁ vivadante phirūśinaḥ pradhānayājakāñceti śrutavantastaṁ dhṛtvā netuṁ padātigaṇaṁ preṣayāmāsuḥ| ");
INSERT INTO sanias_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","tato yīśuravadad aham alpadināni yuṣmābhiḥ sārddhaṁ sthitvā matprerayituḥ samīpaṁ yāsyāmi| ");
INSERT INTO sanias_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","māṁ mṛgayiṣyadhve kintūddeśaṁ na lapsyadhve ratra sthāsyāmi tatra yūyaṁ gantuṁ na śakṣyatha| ");
INSERT INTO sanias_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","tadā yihūdīyāḥ parasparaṁ vakttumārebhire asyoddeśaṁ na prāpsyāma etādṛśaṁ kiṁ sthānaṁ yāsyati? bhinnadeśe vikīrṇānāṁ yihūdīyānāṁ sannidhim eṣa gatvā tān upadekṣyati kiṁ? ");
INSERT INTO sanias_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","no cet māṁ gaveṣayiṣyatha kintūddeśaṁ na prāpsyatha eṣa kodṛśaṁ vākyamidaṁ vadati? ");
INSERT INTO sanias_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","anantaram utsavasya carame'hani arthāt pradhānadine yīśuruttiṣṭhan uccaiḥkāram āhvayan uditavān yadi kaścit tṛṣārtto bhavati tarhi mamāntikam āgatya pivatu| ");
INSERT INTO sanias_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","yaḥ kaścinmayi viśvasiti dharmmagranthasya vacanānusāreṇa tasyābhyantarato'mṛtatoyasya srotāṁsi nirgamiṣyanti| ");
INSERT INTO sanias_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ye tasmin viśvasanti ta ātmānaṁ prāpsyantītyarthe sa idaṁ vākyaṁ vyāhṛtavān etatkālaṁ yāvad yīśu rvibhavaṁ na prāptastasmāt pavitra ātmā nādīyata| ");
INSERT INTO sanias_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","etāṁ vāṇīṁ śrutvā bahavo lokā avadan ayameva niścitaṁ sa bhaviṣyadvādī| ");
INSERT INTO sanias_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","kecid akathayan eṣaeva sobhiṣikttaḥ kintu kecid avadan sobhiṣikttaḥ kiṁ gālīl pradeśe janiṣyate? ");
INSERT INTO sanias_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","sobhiṣiktto dāyūdo vaṁśe dāyūdo janmasthāne baitlehami pattane janiṣyate dharmmagranthe kimitthaṁ likhitaṁ nāsti? ");
INSERT INTO sanias_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","itthaṁ tasmin lokānāṁ bhinnavākyatā jātā| ");
INSERT INTO sanias_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","katipayalokāstaṁ dharttum aicchan tathāpi tadvapuṣi kopi hastaṁ nārpayat| ");
INSERT INTO sanias_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","anantaraṁ pādātigaṇe pradhānayājakānāṁ phirūśināñca samīpamāgatavati te tān apṛcchan kuto hetostaṁ nānayata? ");
INSERT INTO sanias_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","tadā padātayaḥ pratyavadan sa mānava iva kopi kadāpi nopādiśat| ");
INSERT INTO sanias_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","tataḥ phirūśinaḥ prāvocan yūyamapi kimabhrāmiṣṭa? ");
INSERT INTO sanias_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","adhipatīnāṁ phirūśināñca kopi kiṁ tasmin vyaśvasīt? ");
INSERT INTO sanias_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ye śāstraṁ na jānanti ta ime'dhamalokāeva śāpagrastāḥ| ");
INSERT INTO sanias_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","tadā nikadīmanāmā teṣāmeko yaḥ kṣaṇadāyāṁ yīśoḥ sannidhim agāt sa ukttavān ");
INSERT INTO sanias_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","tasya vākye na śrute karmmaṇi ca na vidite 'smākaṁ vyavasthā kiṁ kañcana manujaṁ doṣīkaroti? ");
INSERT INTO sanias_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","tataste vyāharan tvamapi kiṁ gālīlīyalokaḥ? vivicya paśya galīli kopi bhaviṣyadvādī notpadyate| ");
INSERT INTO sanias_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","tataḥ paraṁ sarvve svaṁ svaṁ gṛhaṁ gatāḥ kintu yīśu rjaitunanāmānaṁ śiloccayaṁ gatavān| ");
INSERT INTO sanias_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","pratyūṣe yīśuḥ panarmandiram āgacchat ");
INSERT INTO sanias_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","tataḥ sarvveṣu lokeṣu tasya samīpa āgateṣu sa upaviśya tān upadeṣṭum ārabhata| ");
INSERT INTO sanias_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","tadā adhyāpakāḥ phirūśinañca vyabhicārakarmmaṇi dhṛtaṁ striyamekām āniya sarvveṣāṁ madhye sthāpayitvā vyāharan ");
INSERT INTO sanias_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","he guro yoṣitam imāṁ vyabhicārakarmma kurvvāṇāṁ lokā dhṛtavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","etādṛśalokāḥ pāṣāṇāghātena hantavyā iti vidhirmūsāvyavasthāgranthe likhitosti kintu bhavān kimādiśati? ");
INSERT INTO sanias_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","te tamapavadituṁ parīkṣābhiprāyeṇa vākyamidam apṛcchan kintu sa prahvībhūya bhūmāvaṅgalyā lekhitum ārabhata| ");
INSERT INTO sanias_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","tatastaiḥ punaḥ punaḥ pṛṣṭa utthāya kathitavān yuṣmākaṁ madhye yo jano niraparādhī saeva prathamam enāṁ pāṣāṇenāhantu| ");
INSERT INTO sanias_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","paścāt sa punaśca prahvībhūya bhūmau lekhitum ārabhata| ");
INSERT INTO sanias_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","tāṁ kathaṁ śrutvā te svasvamanasi prabodhaṁ prāpya jyeṣṭhānukramaṁ ekaikaśaḥ sarvve bahiragacchan tato yīśurekākī tayakttobhavat madhyasthāne daṇḍāyamānā sā yoṣā ca sthitā| ");
INSERT INTO sanias_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","tatpaścād yīśurutthāya tāṁ vanitāṁ vinā kamapyaparaṁ na vilokya pṛṣṭavān he vāme tavāpavādakāḥ kutra? kopi tvāṁ kiṁ na daṇḍayati? ");
INSERT INTO sanias_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","sāvadat he maheccha kopi na tadā yīśuravocat nāhamapi daṇḍayāmi yāhi punaḥ pāpaṁ mākārṣīḥ| ");
INSERT INTO sanias_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","tato yīśuḥ punarapi lokebhya itthaṁ kathayitum ārabhata jagatohaṁ jyotiḥsvarūpo yaḥ kaścin matpaścāda gacchati sa timire na bhramitvā jīvanarūpāṁ dīptiṁ prāpsyati| ");
INSERT INTO sanias_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","tataḥ phirūśino'vādiṣustvaṁ svārthe svayaṁ sākṣyaṁ dadāsi tasmāt tava sākṣyaṁ grāhyaṁ na bhavati| ");
INSERT INTO sanias_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","tadā yīśuḥ pratyuditavān yadyapi svārthe'haṁ svayaṁ sākṣyaṁ dadāmi tathāpi mat sākṣyaṁ grāhyaṁ yasmād ahaṁ kuta āgatosmi kva yāmi ca tadahaṁ jānāmi kintu kuta āgatosmi kutra gacchāmi ca tad yūyaṁ na jānītha| ");
INSERT INTO sanias_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","yūyaṁ laukikaṁ vicārayatha nāhaṁ kimapi vicārayāmi| ");
INSERT INTO sanias_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","kintu yadi vicārayāmi tarhi mama vicāro grahītavyo yatoham ekākī nāsmi prerayitā pitā mayā saha vidyate| ");
INSERT INTO sanias_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","dvayo rjanayoḥ sākṣyaṁ grahaṇīyaṁ bhavatīti yuṣmākaṁ vyavasthāgranthe likhitamasti| ");
INSERT INTO sanias_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ahaṁ svārthe svayaṁ sākṣitvaṁ dadāmi yaśca mama tāto māṁ preritavān sopi madarthe sākṣyaṁ dadāti| ");
INSERT INTO sanias_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","tadā te'pṛcchan tava tātaḥ kutra? tato yīśuḥ pratyavādīd yūyaṁ māṁ na jānītha matpitarañca na jānītha yadi mām akṣāsyata tarhi mama tātamapyakṣāsyata| ");
INSERT INTO sanias_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","yīśu rmandira upadiśya bhaṇḍāgāre kathā etā akathayat tathāpi taṁ prati kopi karaṁ nodatolayat| ");
INSERT INTO sanias_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","tataḥ paraṁ yīśuḥ punaruditavān adhunāhaṁ gacchāmi yūyaṁ māṁ gaveṣayiṣyatha kintu nijaiḥ pāpai rmariṣyatha yat sthānam ahaṁ yāsyāmi tat sthānam yūyaṁ yātuṁ na śakṣyatha| ");
INSERT INTO sanias_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","tadā yihūdīyāḥ prāvocan kimayam ātmaghātaṁ kariṣyati? yato yat sthānam ahaṁ yāsyāmi tat sthānam yūyaṁ yātuṁ na śakṣyatha iti vākyaṁ bravīti| ");
INSERT INTO sanias_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","tato yīśustebhyaḥ kathitavān yūyam adhaḥsthānīyā lokā aham ūrdvvasthānīyaḥ yūyam etajjagatsambandhīyā aham etajjagatsambandhīyo na| ");
INSERT INTO sanias_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","tasmāt kathitavān yūyaṁ nijaiḥ pāpai rmariṣyatha yatohaṁ sa pumān iti yadi na viśvasitha tarhi nijaiḥ pāpai rmariṣyatha| ");
INSERT INTO sanias_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","tadā te 'pṛcchan kastvaṁ? tato yīśuḥ kathitavān yuṣmākaṁ sannidhau yasya prastāvam ā prathamāt karomi saeva puruṣohaṁ| ");
INSERT INTO sanias_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","yuṣmāsu mayā bahuvākyaṁ vakttavyaṁ vicārayitavyañca kintu matprerayitā satyavādī tasya samīpe yadahaṁ śrutavān tadeva jagate kathayāmi| ");
INSERT INTO sanias_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","kintu sa janake vākyamidaṁ prokttavān iti te nābudhyanta| ");
INSERT INTO sanias_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","tato yīśurakathayad yadā manuṣyaputram ūrdvva utthāpayiṣyatha tadāhaṁ sa pumān kevalaḥ svayaṁ kimapi karmma na karomi kintu tāto yathā śikṣayati tadanusāreṇa vākyamidaṁ vadāmīti ca yūyaṁ jñātuṁ śakṣyatha| ");
INSERT INTO sanias_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","matprerayitā pitā mām ekākinaṁ na tyajati sa mayā sārddhaṁ tiṣṭhati yatohaṁ tadabhimataṁ karmma sadā karomi| ");
INSERT INTO sanias_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","tadā tasyaitāni vākyāni śrutvā bahuvastāsmin vyaśvasan| ");
INSERT INTO sanias_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","ye yihūdīyā vyaśvasan yīśustebhyo'kathayat ");
INSERT INTO sanias_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","mama vākye yadi yūyam āsthāṁ kurutha tarhi mama śiṣyā bhūtvā satyatvaṁ jñāsyatha tataḥ satyatayā yuṣmākaṁ mokṣo bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","tadā te pratyavādiṣuḥ vayam ibrāhīmo vaṁśaḥ kadāpi kasyāpi dāsā na jātāstarhi yuṣmākaṁ muktti rbhaviṣyatīti vākyaṁ kathaṁ bravīṣi? ");
INSERT INTO sanias_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","tadā yīśuḥ pratyavadad yuṣmānahaṁ yathārthataraṁ vadāmi yaḥ pāpaṁ karoti sa pāpasya dāsaḥ| ");
INSERT INTO sanias_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","dāsaśca nirantaraṁ niveśane na tiṣṭhati kintu putro nirantaraṁ tiṣṭhati| ");
INSERT INTO sanias_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","ataḥ putro yadi yuṣmān mocayati tarhi nitāntameva mukttā bhaviṣyatha| ");
INSERT INTO sanias_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","yuyam ibrāhīmo vaṁśa ityahaṁ jānāmi kintu mama kathā yuṣmākam antaḥkaraṇeṣu sthānaṁ na prāpnuvanti tasmāddheto rmāṁ hantum īhadhve| ");
INSERT INTO sanias_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ahaṁ svapituḥ samīpe yadapaśyaṁ tadeva kathayāmi tathā yūyamapi svapituḥ samīpe yadapaśyata tadeva kurudhve| ");
INSERT INTO sanias_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","tadā te pratyavocan ibrāhīm asmākaṁ pitā tato yīśurakathayad yadi yūyam ibrāhīmaḥ santānā abhaviṣyata tarhi ibrāhīma ācāraṇavad ācariṣyata| ");
INSERT INTO sanias_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","īśvarasya mukhāt satyaṁ vākyaṁ śrutvā yuṣmān jñāpayāmi yohaṁ taṁ māṁ hantuṁ ceṣṭadhve ibrāhīm etādṛśaṁ karmma na cakāra| ");
INSERT INTO sanias_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","yūyaṁ svasvapituḥ karmmāṇi kurutha tadā tairukttaṁ na vayaṁ jārajātā asmākam ekaeva pitāsti sa eveśvaraḥ ");
INSERT INTO sanias_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","tato yīśunā kathitam īśvaro yadi yuṣmākaṁ tātobhaviṣyat tarhi yūyaṁ mayi premākariṣyata yatoham īśvarānnirgatyāgatosmi svato nāgatohaṁ sa māṁ prāhiṇot| ");
INSERT INTO sanias_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","yūyaṁ mama vākyamidaṁ na budhyadhve kutaḥ? yato yūyaṁ mamopadeśaṁ soḍhuṁ na śaknutha| ");
INSERT INTO sanias_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","yūyaṁ śaitān pituḥ santānā etasmād yuṣmākaṁ piturabhilāṣaṁ pūrayatha sa ā prathamāt naraghātī tadantaḥ satyatvasya leśopi nāsti kāraṇādataḥ sa satyatāyāṁ nātiṣṭhat sa yadā mṛṣā kathayati tadā nijasvabhāvānusāreṇaiva kathayati yato sa mṛṣābhāṣī mṛṣotpādakaśca| ");
INSERT INTO sanias_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","ahaṁ tathyavākyaṁ vadāmi kāraṇādasmād yūyaṁ māṁ na pratītha| ");
INSERT INTO sanias_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","mayi pāpamastīti pramāṇaṁ yuṣmākaṁ ko dātuṁ śaknoti? yadyahaṁ tathyavākyaṁ vadāmi tarhi kuto māṁ na pratitha? ");
INSERT INTO sanias_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","yaḥ kaścana īśvarīyo lokaḥ sa īśvarīyakathāyāṁ mano nidhatte yūyam īśvarīyalokā na bhavatha tannidānāt tatra na manāṁsi nidhadve| ");
INSERT INTO sanias_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","tadā yihūdīyāḥ pratyavādiṣuḥ tvamekaḥ śomiroṇīyo bhūtagrastaśca vayaṁ kimidaṁ bhadraṁ nāvādiṣma? ");
INSERT INTO sanias_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","tato yīśuḥ pratyavādīt nāhaṁ bhūtagrastaḥ kintu nijatātaṁ sammanye tasmād yūyaṁ mām apamanyadhve| ");
INSERT INTO sanias_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","ahaṁ svasukhyātiṁ na ceṣṭe kintu ceṣṭitā vicārayitā cāpara eka āste| ");
INSERT INTO sanias_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ahaṁ yuṣmabhyam atīva yathārthaṁ kathayāmi yo naro madīyaṁ vācaṁ manyate sa kadācana nidhanaṁ na drakṣyati| ");
INSERT INTO sanias_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","yihūdīyāstamavadan tvaṁ bhūtagrasta itīdānīm avaiṣma| ibrāhīm bhaviṣyadvādinañca sarvve mṛtāḥ kintu tvaṁ bhāṣase yo naro mama bhāratīṁ gṛhlāti sa jātu nidhānāsvādaṁ na lapsyate| ");
INSERT INTO sanias_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","tarhi tvaṁ kim asmākaṁ pūrvvapuruṣād ibrāhīmopi mahān? yasmāt sopi mṛtaḥ bhaviṣyadvādinopi mṛtāḥ tvaṁ svaṁ kaṁ pumāṁsaṁ manuṣe? ");
INSERT INTO sanias_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","yīśuḥ pratyavocad yadyahaṁ svaṁ svayaṁ sammanye tarhi mama tat sammananaṁ kimapi na kintu mama tāto yaṁ yūyaṁ svīyam īśvaraṁ bhāṣadhve saeva māṁ sammanute| ");
INSERT INTO sanias_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","yūyaṁ taṁ nāvagacchatha kintvahaṁ tamavagacchāmi taṁ nāvagacchāmīti vākyaṁ yadi vadāmi tarhi yūyamiva mṛṣābhāṣī bhavāmi kintvahaṁ tamavagacchāmi tadākṣāmapi gṛhlāmi| ");
INSERT INTO sanias_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","yuṣmākaṁ pūrvvapuruṣa ibrāhīm mama samayaṁ draṣṭum atīvāvāñchat tannirīkṣyānandacca| ");
INSERT INTO sanias_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","tadā yihūdīyā apṛcchan tava vayaḥ pañcāśadvatsarā na tvaṁ kim ibrāhīmam adrākṣīḥ? ");
INSERT INTO sanias_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","yīśuḥ pratyavādīd yuṣmānahaṁ yathārthataraṁ vadāmi ibrāhīmo janmanaḥ pūrvvakālamārabhyāhaṁ vidye| ");
INSERT INTO sanias_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","tadā te pāṣāṇān uttolya tamāhantum udayacchan kintu yīśu rgupto mantirād bahirgatya teṣāṁ madhyena prasthitavān| ");
INSERT INTO sanias_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","tataḥ paraṁ yīśurgacchan mārgamadhye janmāndhaṁ naram apaśyat| ");
INSERT INTO sanias_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","tataḥ śiṣyāstam apṛcchan he guro naroyaṁ svapāpena vā svapitrāḥ pāpenāndho'jāyata? ");
INSERT INTO sanias_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","tataḥ sa pratyuditavān etasya vāsya pitroḥ pāpād etādṛśobhūda iti nahi kintvanena yatheśvarasya karmma prakāśyate taddhetoreva| ");
INSERT INTO sanias_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","dine tiṣṭhati matprerayituḥ karmma mayā karttavyaṁ yadā kimapi karmma na kriyate tādṛśī niśāgacchati| ");
INSERT INTO sanias_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ahaṁ yāvatkālaṁ jagati tiṣṭhāmi tāvatkālaṁ jagato jyotiḥsvarūposmi| ");
INSERT INTO sanias_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ityukttā bhūmau niṣṭhīvaṁ nikṣipya tena paṅkaṁ kṛtavān ");
INSERT INTO sanias_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","paścāt tatpaṅkena tasyāndhasya netre pralipya tamityādiśat gatvā śilohe 'rthāt preritanāmni sarasi snāhi| tatondho gatvā tatrāsnāt tataḥ prannacakṣu rbhūtvā vyāghuṭyāgāt| ");
INSERT INTO sanias_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","aparañca samīpavāsino lokā ye ca taṁ pūrvvamandham apaśyan te bakttum ārabhanta yondhaloko vartmanyupaviśyābhikṣata sa evāyaṁ janaḥ kiṁ na bhavati? ");
INSERT INTO sanias_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","kecidavadan sa eva kecidavocan tādṛśo bhavati kintu sa svayamabravīt sa evāhaṁ bhavāmi| ");
INSERT INTO sanias_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ataeva te 'pṛcchan tvaṁ kathaṁ dṛṣṭiṁ pāptavān? ");
INSERT INTO sanias_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","tataḥ sovadad yīśanāmaka eko jano mama nayane paṅkena pralipya ityājñāpayat śilohakāsāraṁ gatvā tatra snāhi| tatastatra gatvā mayi snāte dṛṣṭimahaṁ labdhavān| ");
INSERT INTO sanias_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","tadā te 'vadan sa pumān kutra? tenokttaṁ nāhaṁ jānāmi| ");
INSERT INTO sanias_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","aparaṁ tasmin pūrvvāndhe jane phirūśināṁ nikaṭam ānīte sati phirūśinopi tamapṛcchan kathaṁ dṛṣṭiṁ prāptosi? ");
INSERT INTO sanias_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","tataḥ sa kathitavān sa paṅkena mama netre 'limpat paścād snātvā dṛṣṭimalabhe| ");
INSERT INTO sanias_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","kintu yīśu rviśrāmavāre karddamaṁ kṛtvā tasya nayane prasanne'karod itikāraṇāt katipayaphirūśino'vadan ");
INSERT INTO sanias_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","sa pumān īśvarānna yataḥ sa viśrāmavāraṁ na manyate| tatonye kecit pratyavadan pāpī pumān kim etādṛśam āścaryyaṁ karmma karttuṁ śaknoti? ");
INSERT INTO sanias_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","itthaṁ teṣāṁ parasparaṁ bhinnavākyatvam abhavat| paścāt te punarapi taṁ pūrvvāndhaṁ mānuṣam aprākṣuḥ yo janastava cakṣuṣī prasanne kṛtavān tasmin tvaṁ kiṁ vadasi? sa ukttavān sa bhaviśadvādī| ");
INSERT INTO sanias_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","sa dṛṣṭim āptavān iti yihūdīyāstasya dṛṣṭiṁ prāptasya janasya pitro rmukhād aśrutvā na pratyayan| ");
INSERT INTO sanias_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ataeva te tāvapṛcchan yuvayo ryaṁ putraṁ janmāndhaṁ vadathaḥ sa kimayaṁ? tarhīdānīṁ kathaṁ draṣṭuṁ śaknoti? ");
INSERT INTO sanias_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","tatastasya pitarau pratyavocatām ayam āvayoḥ putra ā janerandhaśca tadapyāvāṁ jānīvaḥ ");
INSERT INTO sanias_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","kintvadhunā kathaṁ dṛṣṭiṁ prāptavān tadāvāṁ n jānīvaḥ kosya cakṣuṣī prasanne kṛtavān tadapi na jānīva eṣa vayaḥprāpta enaṁ pṛcchata svakathāṁ svayaṁ vakṣyati| ");
INSERT INTO sanias_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","yihūdīyānāṁ bhayāt tasya pitarau vākyamidam avadatāṁ yataḥ kopi manuṣyo yadi yīśum abhiṣiktaṁ vadati tarhi sa bhajanagṛhād dūrīkāriṣyate yihūdīyā iti mantraṇām akurvvan ");
INSERT INTO sanias_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","atastasya pitarau vyāharatām eṣa vayaḥprāpta enaṁ pṛcchata| ");
INSERT INTO sanias_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","tadā te punaśca taṁ pūrvvāndham āhūya vyāharan īśvarasya guṇān vada eṣa manuṣyaḥ pāpīti vayaṁ jānīmaḥ| ");
INSERT INTO sanias_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","tadā sa ukttavān sa pāpī na veti nāhaṁ jāne pūrvāmandha āsamaham adhunā paśyāmīti mātraṁ jānāmi| ");
INSERT INTO sanias_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","te punarapṛcchan sa tvāṁ prati kimakarot? kathaṁ netre prasanne 'karot? ");
INSERT INTO sanias_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","tataḥ sovādīd ekakṛtvokathayaṁ yūyaṁ na śṛṇutha tarhi kutaḥ punaḥ śrotum icchatha? yūyamapi kiṁ tasya śiṣyā bhavitum icchatha? ");
INSERT INTO sanias_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","tadā te taṁ tiraskṛtya vyāharan tvaṁ tasya śiṣyo vayaṁ mūsāḥ śiṣyāḥ| ");
INSERT INTO sanias_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","mūsāvaktreṇeśvaro jagāda tajjānīmaḥ kintveṣa kutratyaloka iti na jānīmaḥ| ");
INSERT INTO sanias_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","sovadad eṣa mama locane prasanne 'karot tathāpi kutratyaloka iti yūyaṁ na jānītha etad āścaryyaṁ bhavati| ");
INSERT INTO sanias_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","īśvaraḥ pāpināṁ kathāṁ na śṛṇoti kintu yo janastasmin bhaktiṁ kṛtvā tadiṣṭakriyāṁ karoti tasyaiva kathāṁ śṛṇoti etad vayaṁ jānīmaḥ| ");
INSERT INTO sanias_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","kopi manuṣyo janmāndhāya cakṣuṣī adadāt jagadārambhād etādṛśīṁ kathāṁ kopi kadāpi nāśṛṇot| ");
INSERT INTO sanias_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","asmād eṣa manuṣyo yadīśvarānnājāyata tarhi kiñcidapīdṛśaṁ karmma karttuṁ nāśaknot| ");
INSERT INTO sanias_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","te vyāharan tvaṁ pāpād ajāyathāḥ kimasmān tvaṁ śikṣayasi? paścātte taṁ bahirakurvvan| ");
INSERT INTO sanias_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","tadanantaraṁ yihūdīyaiḥ sa bahirakriyata yīśuriti vārttāṁ śrutvā taṁ sākṣāt prāpya pṛṣṭavān īśvarasya putre tvaṁ viśvasiṣi? ");
INSERT INTO sanias_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","tadā sa pratyavocat he prabho sa ko yat tasminnahaṁ viśvasimi? ");
INSERT INTO sanias_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","tato yīśuḥ kathitavān tvaṁ taṁ dṛṣṭavān tvayā sākaṁ yaḥ kathaṁ kathayati saeva saḥ| ");
INSERT INTO sanias_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","tadā he prabho viśvasimītyuktvā sa taṁ praṇāmat| ");
INSERT INTO sanias_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","paścād yīśuḥ kathitavān nayanahīnā nayanāni prāpnuvanti nayanavantaścāndhā bhavantītyabhiprāyeṇa jagadāham āgaccham| ");
INSERT INTO sanias_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","etat śrutvā nikaṭasthāḥ katipayāḥ phirūśino vyāharan vayamapi kimandhāḥ? ");
INSERT INTO sanias_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","tadā yīśuravādīd yadyandhā abhavata tarhi pāpāni nātiṣṭhan kintu paśyāmīti vākyavadanād yuṣmākaṁ pāpāni tiṣṭhanti| ");
INSERT INTO sanias_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ahaṁ yuṣmānatiyathārthaṁ vadāmi, yo jano dvāreṇa na praviśya kenāpyanyena meṣagṛhaṁ praviśati sa eva steno dasyuśca| ");
INSERT INTO sanias_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","yo dvāreṇa praviśati sa eva meṣapālakaḥ| ");
INSERT INTO sanias_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","dauvārikastasmai dvāraṁ mocayati meṣagaṇaśca tasya vākyaṁ śṛṇoti sa nijān meṣān svasvanāmnāhūya bahiḥ kṛtvā nayati| ");
INSERT INTO sanias_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","tathā nijān meṣān bahiḥ kṛtvā svayaṁ teṣām agre gacchati, tato meṣāstasya śabdaṁ budhyante, tasmāt tasya paścād vrajanti| ");
INSERT INTO sanias_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","kintu parasya śabdaṁ na budhyante tasmāt tasya paścād vrajiṣyanti varaṁ tasya samīpāt palāyiṣyante| ");
INSERT INTO sanias_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","yīśustebhya imāṁ dṛṣṭāntakathām akathayat kintu tena kathitakathāyāstātparyyaṁ te nābudhyanta| ");
INSERT INTO sanias_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","ato yīśuḥ punarakathayat, yuṣmānāhaṁ yathārthataraṁ vyāharāmi, meṣagṛhasya dvāram ahameva| ");
INSERT INTO sanias_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","mayā na praviśya ya āgacchan te stenā dasyavaśca kintu meṣāsteṣāṁ kathā nāśṛṇvan| ");
INSERT INTO sanias_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","ahameva dvārasvarūpaḥ, mayā yaḥ kaścita praviśati sa rakṣāṁ prāpsyati tathā bahirantaśca gamanāgamane kṛtvā caraṇasthānaṁ prāpsyati| ");
INSERT INTO sanias_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","yo janastenaḥ sa kevalaṁ stainyabadhavināśān karttumeva samāyāti kintvaham āyu rdātum arthāt bāhūlyena tadeva dātum āgaccham| ");
INSERT INTO sanias_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","ahameva satyameṣapālako yastu satyo meṣapālakaḥ sa meṣārthaṁ prāṇatyāgaṁ karoti; ");
INSERT INTO sanias_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","kintu yo jano meṣapālako na, arthād yasya meṣā nijā na bhavanti, ya etādṛśo vaitanikaḥ sa vṛkam āgacchantaṁ dṛṣṭvā mejavrajaṁ vihāya palāyate, tasmād vṛkastaṁ vrajaṁ dhṛtvā vikirati| ");
INSERT INTO sanias_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","vaitanikaḥ palāyate yataḥ sa vetanārthī meṣārthaṁ na cintayati| ");
INSERT INTO sanias_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","ahameva satyo meṣapālakaḥ, pitā māṁ yathā jānāti, ahañca yathā pitaraṁ jānāmi, ");
INSERT INTO sanias_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","tathā nijān meṣānapi jānāmi, meṣāśca māṁ jānānti, ahañca meṣārthaṁ prāṇatyāgaṁ karomi| ");
INSERT INTO sanias_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","aparañca etad gṛhīya meṣebhyo bhinnā api meṣā mama santi te sakalā ānayitavyāḥ; te mama śabdaṁ śroṣyanti tata eko vraja eko rakṣako bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","prāṇānahaṁ tyaktvā punaḥ prāṇān grahīṣyāmi, tasmāt pitā mayi snehaṁ karoti| ");
INSERT INTO sanias_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","kaścijjano mama prāṇān hantuṁ na śaknoti kintu svayaṁ tān samarpayāmi tān samarpayituṁ punargrahītuñca mama śaktirāste bhāramimaṁ svapituḥ sakāśāt prāptoham| ");
INSERT INTO sanias_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","asmādupadeśāt punaśca yihūdīyānāṁ madhye bhinnavākyatā jātā| ");
INSERT INTO sanias_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","tato bahavo vyāharan eṣa bhūtagrasta unmattaśca, kuta etasya kathāṁ śṛṇutha? ");
INSERT INTO sanias_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","kecid avadan etasya kathā bhūtagrastasya kathāvanna bhavanti, bhūtaḥ kim andhāya cakṣuṣī dātuṁ śaknoti? ");
INSERT INTO sanias_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","śītakāle yirūśālami mandirotsargaparvvaṇyupasthite ");
INSERT INTO sanias_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","yīśuḥ sulemāno niḥsāreṇa gamanāgamane karoti, ");
INSERT INTO sanias_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","etasmin samaye yihūdīyāstaṁ veṣṭayitvā vyāharan kati kālān asmākaṁ vicikitsāṁ sthāpayiṣyāmi? yadyabhiṣikto bhavati tarhi tat spaṣṭaṁ vada| ");
INSERT INTO sanias_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","tadā yīśuḥ pratyavadad aham acakathaṁ kintu yūyaṁ na pratītha, nijapitu rnāmnā yāṁ yāṁ kriyāṁ karomi sā kriyaiva mama sākṣisvarūpā| ");
INSERT INTO sanias_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","kintvahaṁ pūrvvamakathayaṁ yūyaṁ mama meṣā na bhavatha, kāraṇādasmān na viśvasitha| ");
INSERT INTO sanias_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","mama meṣā mama śabdaṁ śṛṇvanti tānahaṁ jānāmi te ca mama paścād gacchanti| ");
INSERT INTO sanias_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ahaṁ tebhyo'nantāyu rdadāmi, te kadāpi na naṁkṣyanti kopi mama karāt tān harttuṁ na śakṣyati| ");
INSERT INTO sanias_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","yo mama pitā tān mahyaṁ dattavān sa sarvvasmāt mahān, kopi mama pituḥ karāt tān harttuṁ na śakṣyati| ");
INSERT INTO sanias_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ahaṁ pitā ca dvayorekatvam| ");
INSERT INTO sanias_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","tato yihūdīyāḥ punarapi taṁ hantuṁ pāṣāṇān udatolayan| ");
INSERT INTO sanias_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","yīśuḥ kathitavān pituḥ sakāśād bahūnyuttamakarmmāṇi yuṣmākaṁ prākāśayaṁ teṣāṁ kasya karmmaṇaḥ kāraṇān māṁ pāṣāṇairāhantum udyatāḥ stha? ");
INSERT INTO sanias_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","yihūdīyāḥ pratyavadan praśastakarmmaheto rna kintu tvaṁ mānuṣaḥ svamīśvaram uktveśvaraṁ nindasi kāraṇādasmāt tvāṁ pāṣāṇairhanmaḥ| ");
INSERT INTO sanias_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","tadā yīśuḥ pratyuktavān mayā kathitaṁ yūyam īśvarā etadvacanaṁ yuṣmākaṁ śāstre likhitaṁ nāsti kiṁ? ");
INSERT INTO sanias_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","tasmād yeṣām uddeśe īśvarasya kathā kathitā te yadīśvaragaṇā ucyante dharmmagranthasyāpyanyathā bhavituṁ na śakyaṁ, ");
INSERT INTO sanias_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","tarhyāham īśvarasya putra iti vākyasya kathanāt yūyaṁ pitrābhiṣiktaṁ jagati preritañca pumāṁsaṁ katham īśvaranindakaṁ vādaya? ");
INSERT INTO sanias_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","yadyahaṁ pituḥ karmma na karomi tarhi māṁ na pratīta; ");
INSERT INTO sanias_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","kintu yadi karomi tarhi mayi yuṣmābhiḥ pratyaye na kṛte'pi kāryye pratyayaḥ kriyatāṁ, tato mayi pitāstīti pitaryyaham asmīti ca kṣātvā viśvasiṣyatha| ");
INSERT INTO sanias_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","tadā te punarapi taṁ dharttum aceṣṭanta kintu sa teṣāṁ karebhyo nistīryya ");
INSERT INTO sanias_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","puna ryarddan adyāstaṭe yatra purvvaṁ yohan amajjayat tatrāgatya nyavasat| ");
INSERT INTO sanias_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","tato bahavo lokāstatsamīpam āgatya vyāharan yohan kimapyāścaryyaṁ karmma nākarot kintvasmin manuṣye yā yaḥ kathā akathayat tāḥ sarvvāḥ satyāḥ; ");
INSERT INTO sanias_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","tatra ca bahavo lokāstasmin vyaśvasan| ");
INSERT INTO sanias_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","anantaraṁ mariyam tasyā bhaginī marthā ca yasmin vaithanīyāgrāme vasatastasmin grāme iliyāsar nāmā pīḍita eka āsīt| ");
INSERT INTO sanias_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","yā mariyam prabhuṁ sugandhitelaina marddayitvā svakeśaistasya caraṇau samamārjat tasyā bhrātā sa iliyāsar rogī| ");
INSERT INTO sanias_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","aparañca he prabho bhavān yasmin prīyate sa eva pīḍitostīti kathāṁ kathayitvā tasya bhaginyau preṣitavatyau| ");
INSERT INTO sanias_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","tadā yīśurimāṁ vārttāṁ śrutvākathayata pīḍeyaṁ maraṇārthaṁ na kintvīśvarasya mahimārtham īśvaraputrasya mahimaprakāśārthañca jātā| ");
INSERT INTO sanias_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","yīśu ryadyapimarthāyāṁ tadbhaginyām iliyāsari cāprīyata, ");
INSERT INTO sanias_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","tathāpi iliyāsaraḥ pīḍāyāḥ kathaṁ śrutvā yatra āsīt tatraiva dinadvayamatiṣṭhat| ");
INSERT INTO sanias_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","tataḥ param sa śiṣyānakathayad vayaṁ puna ryihūdīyapradeśaṁ yāmaḥ| ");
INSERT INTO sanias_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","tataste pratyavadan, he guro svalpadināni gatāni yihūdīyāstvāṁ pāṣāṇai rhantum udyatāstathāpi kiṁ punastatra yāsyasi? ");
INSERT INTO sanias_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","yīśuḥ pratyavadat, ekasmin dine kiṁ dvādaśaghaṭikā na bhavanti? kopi divā gacchan na skhalati yataḥ sa etajjagato dīptiṁ prāpnoti| ");
INSERT INTO sanias_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","kintu rātrau gacchan skhalati yato hetostatra dīpti rnāsti| ");
INSERT INTO sanias_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","imāṁ kathāṁ kathayitvā sa tānavadad, asmākaṁ bandhuḥ iliyāsar nidritobhūd idānīṁ taṁ nidrāto jāgarayituṁ gacchāmi| ");
INSERT INTO sanias_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","yīśu rmṛtau kathāmimāṁ kathitavān kintu viśrāmārthaṁ nidrāyāṁ kathitavān iti jñātvā śiṣyā akathayan, ");
INSERT INTO sanias_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","he guro sa yadi nidrāti tarhi bhadrameva| ");
INSERT INTO sanias_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","tadā yīśuḥ spaṣṭaṁ tān vyāharat, iliyāsar amriyata; ");
INSERT INTO sanias_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","kintu yūyaṁ yathā pratītha tadarthamahaṁ tatra na sthitavān ityasmād yuṣmannimittam āhlāditohaṁ, tathāpi tasya samīpe yāma| ");
INSERT INTO sanias_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","tadā thomā yaṁ didumaṁ vadanti sa saṅginaḥ śiṣyān avadad vayamapi gatvā tena sārddhaṁ mriyāmahai| ");
INSERT INTO sanias_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","yīśustatropasthāya iliyāsaraḥ śmaśāne sthāpanāt catvāri dināni gatānīti vārttāṁ śrutavān| ");
INSERT INTO sanias_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","vaithanīyā yirūśālamaḥ samīpasthā krośaikamātrāntaritā; ");
INSERT INTO sanias_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","tasmād bahavo yihūdīyā marthāṁ mariyamañca bhyātṛśokāpannāṁ sāntvayituṁ tayoḥ samīpam āgacchan| ");
INSERT INTO sanias_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","marthā yīśorāgamanavārtāṁ śrutvaiva taṁ sākṣād akarot kintu mariyam geha upaviśya sthitā| ");
INSERT INTO sanias_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","tadā marthā yīśumavādat, he prabho yadi bhavān atrāsthāsyat tarhi mama bhrātā nāmariṣyat| ");
INSERT INTO sanias_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","kintvidānīmapi yad īśvare prārthayiṣyate īśvarastad dāsyatīti jāne'haṁ| ");
INSERT INTO sanias_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","yīśuravādīt tava bhrātā samutthāsyati| ");
INSERT INTO sanias_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","marthā vyāharat śeṣadivase sa utthānasamaye protthāsyatīti jāne'haṁ| ");
INSERT INTO sanias_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","tadā yīśuḥ kathitavān ahameva utthāpayitā jīvayitā ca yaḥ kaścana mayi viśvasiti sa mṛtvāpi jīviṣyati; ");
INSERT INTO sanias_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","yaḥ kaścana ca jīvan mayi viśvasiti sa kadāpi na mariṣyati, asyāṁ kathāyāṁ kiṁ viśvasiṣi? ");
INSERT INTO sanias_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","sāvadat prabho yasyāvataraṇāpekṣāsti bhavān saevābhiṣiktta īśvaraputra iti viśvasimi| ");
INSERT INTO sanias_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","iti kathāṁ kathayitvā sā gatvā svāṁ bhaginīṁ mariyamaṁ guptamāhūya vyāharat gururupatiṣṭhati tvāmāhūyati ca| ");
INSERT INTO sanias_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","kathāmimāṁ śrutvā sā tūrṇam utthāya tasya samīpam agacchat| ");
INSERT INTO sanias_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","yīśu rgrāmamadhyaṁ na praviśya yatra marthā taṁ sākṣād akarot tatra sthitavān| ");
INSERT INTO sanias_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","ye yihūdīyā mariyamā sākaṁ gṛhe tiṣṭhantastām asāntvayana te tāṁ kṣipram utthāya gacchantiṁ vilokya vyāharan, sa śmaśāne rodituṁ yāti, ityuktvā te tasyāḥ paścād agacchan| ");
INSERT INTO sanias_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","yatra yīśuratiṣṭhat tatra mariyam upasthāya taṁ dṛṣṭvā tasya caraṇayoḥ patitvā vyāharat he prabho yadi bhavān atrāsthāsyat tarhi mama bhrātā nāmariṣyat| ");
INSERT INTO sanias_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","yīśustāṁ tasyāḥ saṅgino yihūdīyāṁśca rudato vilokya śokārttaḥ san dīrghaṁ niśvasya kathitavān taṁ kutrāsthāpayata? ");
INSERT INTO sanias_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","te vyāharan, he prabho bhavān āgatya paśyatu| ");
INSERT INTO sanias_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","yīśunā kranditaṁ| ");
INSERT INTO sanias_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ataeva yihūdīyā avadan, paśyatāyaṁ tasmin kidṛg apriyata| ");
INSERT INTO sanias_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","teṣāṁ kecid avadan yondhāya cakṣuṣī dattavān sa kim asya mṛtyuṁ nivārayituṁ nāśaknot? ");
INSERT INTO sanias_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","tato yīśuḥ punarantardīrghaṁ niśvasya śmaśānāntikam agacchat| tat śmaśānam ekaṁ gahvaraṁ tanmukhe pāṣāṇa eka āsīt| ");
INSERT INTO sanias_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","tadā yīśuravadad enaṁ pāṣāṇam apasārayata, tataḥ pramītasya bhaginī marthāvadat prabho, adhunā tatra durgandho jātaḥ, yatodya catvāri dināni śmaśāne sa tiṣṭhati| ");
INSERT INTO sanias_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","tadā yīśuravādīt, yadi viśvasiṣi tarhīśvarasya mahimaprakāśaṁ drakṣyasi kathāmimāṁ kiṁ tubhyaṁ nākathayaṁ? ");
INSERT INTO sanias_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","tadā mṛtasya śmaśānāt pāṣāṇo'pasārite yīśurūrdvvaṁ paśyan akathayat, he pita rmama nevesanam aśṛṇoḥ kāraṇādasmāt tvāṁ dhanyaṁ vadāmi| ");
INSERT INTO sanias_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","tvaṁ satataṁ śṛṇoṣi tadapyahaṁ jānāmi, kintu tvaṁ māṁ yat prairayastad yathāsmin sthāne sthitā lokā viśvasanti tadartham idaṁ vākyaṁ vadāmi| ");
INSERT INTO sanias_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","imāṁ kathāṁ kathayitvā sa proccairāhvayat, he iliyāsar bahirāgaccha| ");
INSERT INTO sanias_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","tataḥ sa pramītaḥ śmaśānavastrai rbaddhahastapādo gātramārjanavāsasā baddhamukhaśca bahirāgacchat| yīśuruditavān bandhanāni mocayitvā tyajatainaṁ| ");
INSERT INTO sanias_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","mariyamaḥ samīpam āgatā ye yihūdīyalokāstadā yīśoretat karmmāpaśyan teṣāṁ bahavo vyaśvasan, ");
INSERT INTO sanias_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","kintu kecidanye phirūśināṁ samīpaṁ gatvā yīśoretasya karmmaṇo vārttām avadan| ");
INSERT INTO sanias_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","tataḥ paraṁ pradhānayājakāḥ phirūśināśca sabhāṁ kṛtvā vyāharan vayaṁ kiṁ kurmmaḥ? eṣa mānavo bahūnyāścaryyakarmmāṇi karoti| ");
INSERT INTO sanias_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","yadīdṛśaṁ karmma karttuṁ na vārayāmastarhi sarvve lokāstasmin viśvasiṣyanti romilokāścāgatyāsmākam anayā rājadhānyā sārddhaṁ rājyam āchetsyanti| ");
INSERT INTO sanias_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","tadā teṣāṁ kiyaphānāmā yastasmin vatsare mahāyājakapade nyayujyata sa pratyavadad yūyaṁ kimapi na jānītha; ");
INSERT INTO sanias_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","samagradeśasya vināśatopi sarvvalokārtham ekasya janasya maraṇam asmākaṁ maṅgalahetukam etasya vivecanāmapi na kurutha| ");
INSERT INTO sanias_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","etāṁ kathāṁ sa nijabuddhyā vyāharad iti na, ");
INSERT INTO sanias_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","kintu yīśūstaddeśīyānāṁ kāraṇāt prāṇān tyakṣyati, diśi diśi vikīrṇān īśvarasya santānān saṁgṛhyaikajātiṁ kariṣyati ca, tasmin vatsare kiyaphā mahāyājakatvapade niyuktaḥ san idaṁ bhaviṣyadvākyaṁ kathitavān| ");
INSERT INTO sanias_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","taddinamārabhya te kathaṁ taṁ hantuṁ śaknuvantīti mantraṇāṁ karttuṁ prārebhire| ");
INSERT INTO sanias_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ataeva yihūdīyānāṁ madhye yīśuḥ saprakāśaṁ gamanāgamane akṛtvā tasmād gatvā prāntarasya samīpasthāyipradeśasyephrāyim nāmni nagare śiṣyaiḥ sākaṁ kālaṁ yāpayituṁ prārebhe| ");
INSERT INTO sanias_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","anantaraṁ yihūdīyānāṁ nistārotsave nikaṭavarttini sati tadutsavāt pūrvvaṁ svān śucīn karttuṁ bahavo janā grāmebhyo yirūśālam nagaram āgacchan, ");
INSERT INTO sanias_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","yīśoranveṣaṇaṁ kṛtvā mandire daṇḍāyamānāḥ santaḥ parasparaṁ vyāharan, yuṣmākaṁ kīdṛśo bodho jāyate? sa kim utsave'smin atrāgamiṣyati? ");
INSERT INTO sanias_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","sa ca kutrāsti yadyetat kaścid vetti tarhi darśayatu pradhānayājakāḥ phirūśinaśca taṁ dharttuṁ pūrvvam imām ājñāṁ prācārayan| ");
INSERT INTO sanias_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","nistārotsavāt pūrvvaṁ dinaṣaṭke sthite yīśu ryaṁ pramītam iliyāsaraṁ śmaśānād udasthāparat tasya nivāsasthānaṁ baithaniyāgrāmam āgacchat| ");
INSERT INTO sanias_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","tatra tadarthaṁ rajanyāṁ bhojye kṛte marthā paryyaveṣayad iliyāsar ca tasya saṅgibhiḥ sārddhaṁ bhojanāsana upāviśat| ");
INSERT INTO sanias_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","tadā mariyam arddhaseṭakaṁ bahumūlyaṁ jaṭāmāṁsīyaṁ tailam ānīya yīśoścaraṇayo rmarddayitvā nijakeśa rmārṣṭum ārabhata; tadā tailasya parimalena gṛham āmoditam abhavat| ");
INSERT INTO sanias_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","yaḥ śimonaḥ putra riṣkariyotīyo yihūdānāmā yīśuṁ parakareṣu samarpayiṣyati sa śiṣyastadā kathitavān, ");
INSERT INTO sanias_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","etattailaṁ tribhiḥ śatai rmudrāpadai rvikrītaṁ sad daridrebhyaḥ kuto nādīyata? ");
INSERT INTO sanias_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","sa daridralokārtham acintayad iti na, kintu sa caura evaṁ tannikaṭe mudrāsampuṭakasthityā tanmadhye yadatiṣṭhat tadapāharat tasmāt kāraṇād imāṁ kathāmakathayat| ");
INSERT INTO sanias_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","tadā yīśurakathayad enāṁ mā vāraya sā mama śmaśānasthāpanadinārthaṁ tadarakṣayat| ");
INSERT INTO sanias_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","daridrā yuṣmākaṁ sannidhau sarvvadā tiṣṭhanti kintvahaṁ sarvvadā yuṣmākaṁ sannidhau na tiṣṭhāmi| ");
INSERT INTO sanias_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","tataḥ paraṁ yīśustatrāstīti vārttāṁ śrutvā bahavo yihūdīyāstaṁ śmaśānādutthāpitam iliyāsarañca draṣṭuṁ tat sthānam āgacchana| ");
INSERT INTO sanias_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","tadā pradhānayājakāstam iliyāsaramapi saṁharttum amantrayan ; ");
INSERT INTO sanias_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","yatastena bahavo yihūdīyā gatvā yīśau vyaśvasan| ");
INSERT INTO sanias_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","anantaraṁ yīśu ryirūśālam nagaram āgacchatīti vārttāṁ śrutvā pare'hani utsavāgatā bahavo lokāḥ ");
INSERT INTO sanias_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","kharjjūrapatrādyānīya taṁ sākṣāt karttuṁ bahirāgatya jaya jayeti vācaṁ proccai rvaktum ārabhanta, isrāyelo yo rājā parameśvarasya nāmnāgacchati sa dhanyaḥ| ");
INSERT INTO sanias_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","tadā \"he siyonaḥ kanye mā bhaiṣīḥ paśyāyaṁ tava rājā garddabhaśāvakam āruhyāgacchati\" ");
INSERT INTO sanias_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","iti śāstrīyavacanānusāreṇa yīśurekaṁ yuvagarddabhaṁ prāpya taduparyyārohat| ");
INSERT INTO sanias_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","asyāḥ ghaṭanāyāstātparyyaṁ śiṣyāḥ prathamaṁ nābudhyanta, kintu yīśau mahimānaṁ prāpte sati vākyamidaṁ tasmina akathyata lokāśca tampratīttham akurvvan iti te smṛtavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","sa iliyāsaraṁ śmaśānād āgantum āhvatavān śmaśānāñca udasthāpayad ye ye lokāstatkarmya sākṣād apaśyan te pramāṇaṁ dātum ārabhanta| ");
INSERT INTO sanias_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","sa etādṛśam adbhutaṁ karmmakarot tasya janaśrute rlokāstaṁ sākṣāt karttum āgacchan| ");
INSERT INTO sanias_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","tataḥ phirūśinaḥ parasparaṁ vaktum ārabhanta yuṣmākaṁ sarvvāśceṣṭā vṛthā jātāḥ, iti kiṁ yūyaṁ na budhyadhve? paśyata sarvve lokāstasya paścādvarttinobhavan| ");
INSERT INTO sanias_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","bhajanaṁ karttum utsavāgatānāṁ lokānāṁ katipayā janā anyadeśīyā āsan , ");
INSERT INTO sanias_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","te gālīlīyabaitsaidānivāsinaḥ philipasya samīpam āgatya vyāharan he maheccha vayaṁ yīśuṁ draṣṭum icchāmaḥ| ");
INSERT INTO sanias_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","tataḥ philipo gatvā āndriyam avadat paścād āndriyaphilipau yīśave vārttām akathayatāṁ| ");
INSERT INTO sanias_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","tadā yīśuḥ pratyuditavān mānavasutasya mahimaprāptisamaya upasthitaḥ| ");
INSERT INTO sanias_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ahaṁ yuṣmānatiyathārthaṁ vadāmi, dhānyabījaṁ mṛttikāyāṁ patitvā yadi na mṛyate tarhyekākī tiṣṭhati kintu yadi mṛyate tarhi bahuguṇaṁ phalaṁ phalati| ");
INSERT INTO sanias_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","yo janeा nijaprāṇān priyān jānāti sa tān hārayiṣyati kintu yeा jana ihaloke nijaprāṇān apriyān jānāti seाnantāyuḥ prāptuṁ tān rakṣiṣyati| ");
INSERT INTO sanias_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","kaścid yadi mama sevako bhavituṁ vāñchati tarhi sa mama paścādgāmī bhavatu, tasmād ahaṁ yatra tiṣṭhāmi mama sevakeाpi tatra sthāsyati; yo jano māṁ sevate mama pitāpi taṁ sammaṁsyate| ");
INSERT INTO sanias_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","sāmprataṁ mama prāṇā vyākulā bhavanti, tasmād he pitara etasmāt samayān māṁ rakṣa, ityahaṁ kiṁ prārthayiṣye? kintvaham etatsamayārtham avatīrṇavān| ");
INSERT INTO sanias_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","he pita: svanāmno mahimānaṁ prakāśaya; tanaiva svanāmno mahimānam ahaṁ prākāśayaṁ punarapi prakāśayiṣyāmi, eṣā gagaṇīyā vāṇī tasmin samaye'jāyata| ");
INSERT INTO sanias_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","tacśrutvā samīpasthalokānāṁ kecid avadan megho'garjīt, kecid avadan svargīyadūto'nena saha kathāmacakathat| ");
INSERT INTO sanias_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","tadā yīśuḥ pratyavādīt, madarthaṁ śabdoyaṁ nābhūt yuṣmadarthamevābhūt| ");
INSERT INTO sanias_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","adhunā jagatosya vicāra: sampatsyate, adhunāsya jagata: patī rājyāt cyoṣyati| ");
INSERT INTO sanias_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","yadyaī pṛthivyā ūrdvve protthāpitosmi tarhi sarvvān mānavān svasamīpam ākarṣiṣyāmi| ");
INSERT INTO sanias_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","kathaṁ tasya mṛti rbhaviṣyati, etad bodhayituṁ sa imāṁ kathām akathayat| ");
INSERT INTO sanias_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","tadā lokā akathayan sobhiṣiktaḥ sarvvadā tiṣṭhatīti vyavasthāgranthe śrutam asmābhiḥ, tarhi manuṣyaputraḥ protthāpito bhaviṣyatīti vākyaṁ kathaṁ vadasi? manuṣyaputroyaṁ kaḥ? ");
INSERT INTO sanias_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","tadā yīśurakathāyad yuṣmābhiḥ sārddham alpadināni jyotirāste, yathā yuṣmān andhakāro nācchādayati tadarthaṁ yāvatkālaṁ yuṣmābhiḥ sārddhaṁ jyotistiṣṭhati tāvatkālaṁ gacchata; yo jano'ndhakāre gacchati sa kutra yātīti na jānāti| ");
INSERT INTO sanias_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ataeva yāvatkālaṁ yuṣmākaṁ nikaṭe jyotirāste tāvatkālaṁ jyotīrūpasantānā bhavituṁ jyotiṣi viśvasita; imāṁ kathāṁ kathayitvā yīśuḥ prasthāya tebhyaḥ svaṁ guptavān| ");
INSERT INTO sanias_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","yadyapi yīśusteṣāṁ samakṣam etāvadāścaryyakarmmāṇi kṛtavān tathāpi te tasmin na vyaśvasan| ");
INSERT INTO sanias_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ataeva kaḥ pratyeti susaṁvādaṁ pareśāsmat pracāritaṁ? prakāśate pareśasya hastaḥ kasya ca sannidhau? yiśayiyabhaviṣyadvādinā yadetad vākyamuktaṁ tat saphalam abhavat| ");
INSERT INTO sanias_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","te pratyetuṁ nāśankuvan tasmin yiśayiyabhaviṣyadvādi punaravādīd, ");
INSERT INTO sanias_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","yadā, \"te nayanai rna paśyanti buddhibhiśca na budhyante tai rmanaḥsu parivarttiteṣu ca tānahaṁ yathā svasthān na karomi tathā sa teṣāṁ locanānyandhāni kṛtvā teṣāmantaḥkaraṇāni gāḍhāni kariṣyati|\" ");
INSERT INTO sanias_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","yiśayiyo yadā yīśo rmahimānaṁ vilokya tasmin kathāmakathayat tadā bhaviṣyadvākyam īdṛśaṁ prakāśayat| ");
INSERT INTO sanias_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","tathāpyadhipatināṁ bahavastasmin pratyāyan| kintu phirūśinastān bhajanagṛhād dūrīkurvvantīti bhayāt te taṁ na svīkṛtavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","yata īśvarasya praśaṁsāto mānavānāṁ praśaṁsāyāṁ te'priyanta| ");
INSERT INTO sanias_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","tadā yīśuruccaiḥkāram akathayad yo jano mayi viśvasiti sa kevale mayi viśvasitīti na, sa matprerake'pi viśvasiti| ");
INSERT INTO sanias_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","yo jano māṁ paśyati sa matprerakamapi paśyati| ");
INSERT INTO sanias_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","yo jano māṁ pratyeti sa yathāndhakāre na tiṣṭhati tadartham ahaṁ jyotiḥsvarūpo bhūtvā jagatyasmin avatīrṇavān| ");
INSERT INTO sanias_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","mama kathāṁ śrutvā yadi kaścin na viśvasiti tarhi tamahaṁ doṣiṇaṁ na karomi, yato heto rjagato janānāṁ doṣān niścitān karttuṁ nāgatya tān paricātum āgatosmi| ");
INSERT INTO sanias_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","yaḥ kaścin māṁ na śraddhāya mama kathaṁ na gṛhlāti, anyastaṁ doṣiṇaṁ kariṣyati vastutastu yāṁ kathāmaham acakathaṁ sā kathā carame'nhi taṁ doṣiṇaṁ kariṣyati| ");
INSERT INTO sanias_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","yato hetorahaṁ svataḥ kimapi na kathayāmi, kiṁ kiṁ mayā kathayitavyaṁ kiṁ samupadeṣṭavyañca iti matprerayitā pitā māmājñāpayat| ");
INSERT INTO sanias_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","tasya sājñā anantāyurityahaṁ jānāmi, ataevāhaṁ yat kathayāmi tat pitā yathājñāpayat tathaiva kathayāmyaham| ");
INSERT INTO sanias_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","nistārotsavasya kiñcitkālāt pūrvvaṁ pṛthivyāḥ pituḥ samīpagamanasya samayaḥ sannikarṣobhūd iti jñātvā yīśurāprathamād yeṣu jagatpravāsiṣvātmīyalokeṣa prema karoti sma teṣu śeṣaṁ yāvat prema kṛtavān| ");
INSERT INTO sanias_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","pitā tasya haste sarvvaṁ samarpitavān svayam īśvarasya samīpād āgacchad īśvarasya samīpaṁ yāsyati ca, sarvvāṇyetāni jñātvā rajanyāṁ bhojane sampūrṇe sati, ");
INSERT INTO sanias_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","yadā śaitān taṁ parahasteṣu samarpayituṁ śimonaḥ putrasya īṣkāriyotiyasya yihūdā antaḥkaraṇe kupravṛttiṁ samārpayat, ");
INSERT INTO sanias_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","tadā yīśu rbhojanāsanād utthāya gātravastraṁ mocayitvā gātramārjanavastraṁ gṛhītvā tena svakaṭim abadhnāt, ");
INSERT INTO sanias_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","paścād ekapātre jalam abhiṣicya śiṣyāṇāṁ pādān prakṣālya tena kaṭibaddhagātramārjanavāsasā mārṣṭuṁ prārabhata| ");
INSERT INTO sanias_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","tataḥ śimonpitarasya samīpamāgate sa uktavān he prabho bhavān kiṁ mama pādau prakṣālayiṣyati? ");
INSERT INTO sanias_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","yīśuruditavān ahaṁ yat karomi tat samprati na jānāsi kintu paścāj jñāsyasi| ");
INSERT INTO sanias_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","tataḥ pitaraḥ kathitavān bhavān kadāpi mama pādau na prakṣālayiṣyati| yīśurakathayad yadi tvāṁ na prakṣālaye tarhi mayi tava kopyaṁśo nāsti| ");
INSERT INTO sanias_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","tadā śimonpitaraḥ kathitavān he prabho tarhi kevalapādau na, mama hastau śiraśca prakṣālayatu| ");
INSERT INTO sanias_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","tato yīśuravadad yo jano dhautastasya sarvvāṅgapariṣkṛtatvāt pādau vinānyāṅgasya prakṣālanāpekṣā nāsti| yūyaṁ pariṣkṛtā iti satyaṁ kintu na sarvve, ");
INSERT INTO sanias_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","yato yo janastaṁ parakareṣu samarpayiṣyati taṁ sa jñātavāna; ataeva yūyaṁ sarvve na pariṣkṛtā imāṁ kathāṁ kathitavān| ");
INSERT INTO sanias_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","itthaṁ yīśusteṣāṁ pādān prakṣālya vastraṁ paridhāyāsane samupaviśya kathitavān ahaṁ yuṣmān prati kiṁ karmmākārṣaṁ jānītha? ");
INSERT INTO sanias_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","yūyaṁ māṁ guruṁ prabhuñca vadatha tat satyameva vadatha yatohaṁ saeva bhavāmi| ");
INSERT INTO sanias_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","yadyahaṁ prabhu rguruśca san yuṣmākaṁ pādān prakṣālitavān tarhi yuṣmākamapi parasparaṁ pādaprakṣālanam ucitam| ");
INSERT INTO sanias_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","ahaṁ yuṣmān prati yathā vyavāharaṁ yuṣmān tathā vyavaharttum ekaṁ panthānaṁ darśitavān| ");
INSERT INTO sanias_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","ahaṁ yuṣmānatiyathārthaṁ vadāmi, prabho rdāso na mahān prerakācca prerito na mahān| ");
INSERT INTO sanias_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","imāṁ kathāṁ viditvā yadi tadanusārataḥ karmmāṇi kurutha tarhi yūyaṁ dhanyā bhaviṣyatha| ");
INSERT INTO sanias_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","sarvveṣu yuṣmāsu kathāmimāṁ kathayāmi iti na, ye mama manonītāstānahaṁ jānāmi, kintu mama bhakṣyāṇi yo bhuṅkte matprāṇaprātikūlyataḥ| utthāpayati pādasya mūlaṁ sa eṣa mānavaḥ|yadetad dharmmapustakasya vacanaṁ tadanusāreṇāvaśyaṁ ghaṭiṣyate| ");
INSERT INTO sanias_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","ahaṁ sa jana ityatra yathā yuṣmākaṁ viśvāso jāyate tadarthaṁ etādṛśaghaṭanāt pūrvvam ahamidānīṁ yuṣmabhyamakathayam| ");
INSERT INTO sanias_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","ahaṁ yuṣmānatīva yathārthaṁ vadāmi, mayā preritaṁ janaṁ yo gṛhlāti sa māmeva gṛhlāti yaśca māṁ gṛhlāti sa matprerakaṁ gṛhlāti| ");
INSERT INTO sanias_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","etāṁ kathāṁ kathayitvā yīśu rduḥkhī san pramāṇaṁ dattvā kathitavān ahaṁ yuṣmānatiyathārthaṁ vadāmi yuṣmākam eko jano māṁ parakareṣu samarpayiṣyati| ");
INSERT INTO sanias_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","tataḥ sa kamuddiśya kathāmetāṁ kathitavān ityatra sandigdhāḥ śiṣyāḥ parasparaṁ mukhamālokayituṁ prārabhanta| ");
INSERT INTO sanias_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","tasmin samaye yīśu ryasmin aprīyata sa śiṣyastasya vakṣaḥsthalam avālambata| ");
INSERT INTO sanias_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","śimonpitarastaṁ saṅketenāvadat, ayaṁ kamuddiśya kathāmetām kathayatīti pṛccha| ");
INSERT INTO sanias_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","tadā sa yīśo rvakṣaḥsthalam avalambya pṛṣṭhavān, he prabho sa janaḥ kaḥ? ");
INSERT INTO sanias_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","tato yīśuḥ pratyavadad ekakhaṇḍaṁ pūpaṁ majjayitvā yasmai dāsyāmi saeva saḥ; paścāt pūpakhaṇḍamekaṁ majjayitvā śimonaḥ putrāya īṣkariyotīyāya yihūdai dattavān| ");
INSERT INTO sanias_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","tasmin datte sati śaitān tamāśrayat; tadā yīśustam avadat tvaṁ yat kariṣyasi tat kṣipraṁ kuru| ");
INSERT INTO sanias_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","kintu sa yenāśayena tāṁ kathāmakathāyat tam upaviṣṭalokānāṁ kopi nābudhyata; ");
INSERT INTO sanias_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","kintu yihūdāḥ samīpe mudrāsampuṭakasthiteḥ kecid ittham abudhyanta pārvvaṇāsādanārthaṁ kimapi dravyaṁ kretuṁ vā daridrebhyaḥ kiñcid vitarituṁ kathitavān| ");
INSERT INTO sanias_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","tadā pūpakhaṇḍagrahaṇāt paraṁ sa tūrṇaṁ bahiragacchat; rātriśca samupasyitā| ");
INSERT INTO sanias_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","yihūde bahirgate yīśurakathayad idānīṁ mānavasutasya mahimā prakāśate teneśvarasyāpi mahimā prakāśate| ");
INSERT INTO sanias_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","yadi teneśvarasya mahimā prakāśate tarhīśvaropi svena tasya mahimānaṁ prakāśayiṣyati tūrṇameva prakāśayiṣyati| ");
INSERT INTO sanias_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","he vatsā ahaṁ yuṣmābhiḥ sārddhaṁ kiñcitkālamātram āse, tataḥ paraṁ māṁ mṛgayiṣyadhve kintvahaṁ yatsthānaṁ yāmi tatsthānaṁ yūyaṁ gantuṁ na śakṣyatha, yāmimāṁ kathāṁ yihūdīyebhyaḥ kathitavān tathādhunā yuṣmabhyamapi kathayāmi| ");
INSERT INTO sanias_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","yūyaṁ parasparaṁ prīyadhvam ahaṁ yuṣmāsu yathā prīye yūyamapi parasparam tathaiva prīyadhvaṁ, yuṣmān imāṁ navīnām ājñām ādiśāmi| ");
INSERT INTO sanias_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","tenaiva yadi parasparaṁ prīyadhve tarhi lakṣaṇenānena yūyaṁ mama śiṣyā iti sarvve jñātuṁ śakṣyanti| ");
INSERT INTO sanias_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","śimonapitaraḥ pṛṣṭhavān he prabho bhavān kutra yāsyati? tato yīśuḥ pratyavadat, ahaṁ yatsthānaṁ yāmi tatsthānaṁ sāmprataṁ mama paścād gantuṁ na śaknoṣi kintu paścād gamiṣyasi| ");
INSERT INTO sanias_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","tadā pitaraḥ pratyuditavān, he prabho sāmprataṁ kuto hetostava paścād gantuṁ na śaknomi? tvadarthaṁ prāṇān dātuṁ śaknomi| ");
INSERT INTO sanias_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","tato yīśuḥ pratyuktavān mannimittaṁ kiṁ prāṇān dātuṁ śaknoṣi? tvāmahaṁ yathārthaṁ vadāmi, kukkuṭaravaṇāt pūrvvaṁ tvaṁ tri rmām apahnoṣyase| ");
INSERT INTO sanias_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","manoduḥkhino mā bhūta; īśvare viśvasita mayi ca viśvasita| ");
INSERT INTO sanias_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","mama pitu gṛhe bahūni vāsasthāni santi no cet pūrvvaṁ yuṣmān ajñāpayiṣyaṁ yuṣmadarthaṁ sthānaṁ sajjayituṁ gacchāmi| ");
INSERT INTO sanias_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","yadi gatvāhaṁ yuṣmannimittaṁ sthānaṁ sajjayāmi tarhi panarāgatya yuṣmān svasamīpaṁ neṣyāmi, tato yatrāhaṁ tiṣṭhāmi tatra yūyamapi sthāsyatha| ");
INSERT INTO sanias_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ahaṁ yatsthānaṁ brajāmi tatsthānaṁ yūyaṁ jānītha tasya panthānamapi jānītha| ");
INSERT INTO sanias_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","tadā thomā avadat, he prabho bhavān kutra yāti tadvayaṁ na jānīmaḥ, tarhi kathaṁ panthānaṁ jñātuṁ śaknumaḥ? ");
INSERT INTO sanias_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","yīśurakathayad ahameva satyajīvanarūpapatho mayā na gantā kopi pituḥ samīpaṁ gantuṁ na śaknoti| ");
INSERT INTO sanias_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","yadi mām ajñāsyata tarhi mama pitaramapyajñāsyata kintvadhunātastaṁ jānītha paśyatha ca| ");
INSERT INTO sanias_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","tadā philipaḥ kathitavān, he prabho pitaraṁ darśaya tasmādasmākaṁ yatheṣṭaṁ bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","tato yīśuḥ pratyāvādīt, he philipa yuṣmābhiḥ sārddham etāvaddināni sthitamapi māṁ kiṁ na pratyabhijānāsi? yo jano mām apaśyat sa pitaramapyapaśyat tarhi pitaram asmān darśayeti kathāṁ kathaṁ kathayasi? ");
INSERT INTO sanias_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ahaṁ pitari tiṣṭhāmi pitā mayi tiṣṭhatīti kiṁ tvaṁ na pratyaṣi? ahaṁ yadvākyaṁ vadāmi tat svato na vadāmi kintu yaḥ pitā mayi virājate sa eva sarvvakarmmāṇi karāti| ");
INSERT INTO sanias_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ataeva pitaryyahaṁ tiṣṭhāmi pitā ca mayi tiṣṭhati mamāsyāṁ kathāyāṁ pratyayaṁ kuruta, no cet karmmahetoḥ pratyayaṁ kuruta| ");
INSERT INTO sanias_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","ahaṁ yuṣmānatiyathārthaṁ vadāmi, yo jano mayi viśvasiti sohamiva karmmāṇi kariṣyati varaṁ tatopi mahākarmmāṇi kariṣyati yato hetorahaṁ pituḥ samīpaṁ gacchāmi| ");
INSERT INTO sanias_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","yathā putreṇa pitu rmahimā prakāśate tadarthaṁ mama nāma procya yat prārthayiṣyadhve tat saphalaṁ kariṣyāmi| ");
INSERT INTO sanias_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","yadi mama nāmnā yat kiñcid yācadhve tarhi tadahaṁ sādhayiṣyāmi| ");
INSERT INTO sanias_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","yadi mayi prīyadhve tarhi mamājñāḥ samācarata| ");
INSERT INTO sanias_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","tato mayā pituḥ samīpe prārthite pitā nirantaraṁ yuṣmābhiḥ sārddhaṁ sthātum itaramekaṁ sahāyam arthāt satyamayam ātmānaṁ yuṣmākaṁ nikaṭaṁ preṣayiṣyati| ");
INSERT INTO sanias_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","etajjagato lokāstaṁ grahītuṁ na śaknuvanti yataste taṁ nāpaśyan nājanaṁśca kintu yūyaṁ jānītha yato hetoḥ sa yuṣmākamanta rnivasati yuṣmākaṁ madhye sthāsyati ca| ");
INSERT INTO sanias_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","ahaṁ yuṣmān anāthān kṛtvā na yāsyāmi punarapi yuṣmākaṁ samīpam āgamiṣyāmi| ");
INSERT INTO sanias_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","kiyatkālarat param asya jagato lokā māṁ puna rna drakṣyanti kintu yūyaṁ drakṣyatha;ahaṁ jīviṣyāmi tasmāt kāraṇād yūyamapi jīviṣyatha| ");
INSERT INTO sanias_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","pitaryyahamasmi mayi ca yūyaṁ stha, tathāhaṁ yuṣmāsvasmi tadapi tadā jñāsyatha| ");
INSERT INTO sanias_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","yo jano mamājñā gṛhītvā tā ācarati saeva mayi prīyate; yo janaśca mayi prīyate saeva mama pituḥ priyapātraṁ bhaviṣyati, tathāhamapi tasmin prītvā tasmai svaṁ prakāśayiṣyāmi| ");
INSERT INTO sanias_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","tadā īṣkariyotīyād anyo yihūdāstamavadat, he prabho bhavān jagato lokānāṁ sannidhau prakāśito na bhūtvāsmākaṁ sannidhau kutaḥ prakāśito bhaviṣyati? ");
INSERT INTO sanias_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","tato yīśuḥ pratyuditavān, yo jano mayi prīyate sa mamājñā api gṛhlāti, tena mama pitāpi tasmin preṣyate, āvāñca tannikaṭamāgatya tena saha nivatsyāvaḥ| ");
INSERT INTO sanias_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","yo jano mayi na prīyate sa mama kathā api na gṛhlāti punaśca yāmimāṁ kathāṁ yūyaṁ śṛṇutha sā kathā kevalasya mama na kintu mama prerako yaḥ pitā tasyāpi kathā| ");
INSERT INTO sanias_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","idānīṁ yuṣmākaṁ nikaṭe vidyamānoham etāḥ sakalāḥ kathāḥ kathayāmi| ");
INSERT INTO sanias_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","kintvitaḥ paraṁ pitrā yaḥ sahāyo'rthāt pavitra ātmā mama nāmni prerayiṣyati sa sarvvaṁ śikṣayitvā mayoktāḥ samastāḥ kathā yuṣmān smārayiṣyati| ");
INSERT INTO sanias_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","ahaṁ yuṣmākaṁ nikaṭe śāntiṁ sthāpayitvā yāmi, nijāṁ śāntiṁ yuṣmabhyaṁ dadāmi, jagato lokā yathā dadāti tathāhaṁ na dadāmi; yuṣmākam antaḥkaraṇāni duḥkhitāni bhītāni ca na bhavantu| ");
INSERT INTO sanias_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","ahaṁ gatvā punarapi yuṣmākaṁ samīpam āgamiṣyāmi mayoktaṁ vākyamidaṁ yūyam aśrauṣṭa; yadi mayyapreṣyadhvaṁ tarhyahaṁ pituḥ samīpaṁ gacchāmi mamāsyāṁ kathāyāṁ yūyam ahlādiṣyadhvaṁ yato mama pitā mattopi mahān| ");
INSERT INTO sanias_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","tasyā ghaṭanāyāḥ samaye yathā yuṣmākaṁ śraddhā jāyate tadartham ahaṁ tasyā ghaṭanāyāḥ pūrvvam idānīṁ yuṣmān etāṁ vārttāṁ vadāmi| ");
INSERT INTO sanias_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","itaḥ paraṁ yuṣmābhiḥ saha mama bahava ālāpā na bhaviṣyanti yataḥ kāraṇād etasya jagataḥ patirāgacchati kintu mayā saha tasya kopi sambandho nāsti| ");
INSERT INTO sanias_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ahaṁ pitari prema karomi tathā pitu rvidhivat karmmāṇi karomīti yena jagato lokā jānanti tadartham uttiṣṭhata vayaṁ sthānādasmād gacchāma| ");
INSERT INTO sanias_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","ahaṁ satyadrākṣālatāsvarūpo mama pitā tūdyānaparicārakasvarūpañca| ");
INSERT INTO sanias_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","mama yāsu śākhāsu phalāni na bhavanti tāḥ sa chinatti tathā phalavatyaḥ śākhā yathādhikaphalāni phalanti tadarthaṁ tāḥ pariṣkaroti| ");
INSERT INTO sanias_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","idānīṁ mayoktopadeśena yūyaṁ pariṣkṛtāḥ| ");
INSERT INTO sanias_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ataḥ kāraṇāt mayi tiṣṭhata tenāhamapi yuṣmāsu tiṣṭhāmi, yato heto rdrākṣālatāyām asaṁlagnā śākhā yathā phalavatī bhavituṁ na śaknoti tathā yūyamapi mayyatiṣṭhantaḥ phalavanto bhavituṁ na śaknutha| ");
INSERT INTO sanias_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","ahaṁ drākṣālatāsvarūpo yūyañca śākhāsvarūpoḥ; yo jano mayi tiṣṭhati yatra cāhaṁ tiṣṭhāmi, sa pracūraphalaiḥ phalavān bhavati, kintu māṁ vinā yūyaṁ kimapi karttuṁ na śaknutha| ");
INSERT INTO sanias_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","yaḥ kaścin mayi na tiṣṭhati sa śuṣkaśākheva bahi rnikṣipyate lokāśca tā āhṛtya vahnau nikṣipya dāhayanti| ");
INSERT INTO sanias_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","yadi yūyaṁ mayi tiṣṭhatha mama kathā ca yuṣmāsu tiṣṭhati tarhi yad vāñchitvā yāciṣyadhve yuṣmākaṁ tadeva saphalaṁ bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","yadi yūyaṁ pracūraphalavanto bhavatha tarhi tadvārā mama pitu rmahimā prakāśiṣyate tathā yūyaṁ mama śiṣyā iti parikṣāyiṣyadhve| ");
INSERT INTO sanias_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","pitā yathā mayi prītavān ahamapi yuṣmāsu tathā prītavān ato heto ryūyaṁ nirantaraṁ mama premapātrāṇi bhūtvā tiṣṭhata| ");
INSERT INTO sanias_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ahaṁ yathā piturājñā gṛhītvā tasya premabhājanaṁ tiṣṭhāmi tathaiva yūyamapi yadi mamājñā guhlītha tarhi mama premabhājanāni sthāsyatha| ");
INSERT INTO sanias_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","yuṣmannimittaṁ mama ya āhlādaḥ sa yathā ciraṁ tiṣṭhati yuṣmākam ānandaśca yathā pūryyate tadarthaṁ yuṣmabhyam etāḥ kathā atrakatham| ");
INSERT INTO sanias_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","ahaṁ yuṣmāsu yathā prīye yūyamapi parasparaṁ tathā prīyadhvam eṣā mamājñā| ");
INSERT INTO sanias_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","mitrāṇāṁ kāraṇāt svaprāṇadānaparyyantaṁ yat prema tasmān mahāprema kasyāpi nāsti| ");
INSERT INTO sanias_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","ahaṁ yadyad ādiśāmi tattadeva yadi yūyam ācarata tarhi yūyameva mama mitrāṇi| ");
INSERT INTO sanias_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","adyārabhya yuṣmān dāsān na vadiṣyāmi yat prabhu ryat karoti dāsastad na jānāti; kintu pituḥ samīpe yadyad aśṛṇavaṁ tat sarvvaṁ yūṣmān ajñāpayam tatkāraṇād yuṣmān mitrāṇi proktavān| ");
INSERT INTO sanias_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","yūyaṁ māṁ rocitavanta iti na, kintvahameva yuṣmān rocitavān yūyaṁ gatvā yathā phalānyutpādayatha tāni phalāni cākṣayāṇi bhavanti, tadarthaṁ yuṣmān nyajunajaṁ tasmān mama nāma procya pitaraṁ yat kiñcid yāciṣyadhve tadeva sa yuṣmabhyaṁ dāsyati| ");
INSERT INTO sanias_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","yūyaṁ parasparaṁ prīyadhvam aham ityājñāpayāmi| ");
INSERT INTO sanias_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","jagato lokai ryuṣmāsu ṛtīyiteṣu te pūrvvaṁ māmevārttīyanta iti yūyaṁ jānītha| ");
INSERT INTO sanias_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","yadi yūyaṁ jagato lokā abhaviṣyata tarhi jagato lokā yuṣmān ātmīyān buddhvāpreṣyanta; kintu yūyaṁ jagato lokā na bhavatha, ahaṁ yuṣmān asmājjagato'rocayam etasmāt kāraṇājjagato lokā yuṣmān ṛtīyante| ");
INSERT INTO sanias_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","dāsaḥ prabho rmahān na bhavati mamaitat pūrvvīyaṁ vākyaṁ smarata; te yadi māmevātāḍayan tarhi yuṣmānapi tāḍayiṣyanti, yadi mama vākyaṁ gṛhlanti tarhi yuṣmākamapi vākyaṁ grahīṣyanti| ");
INSERT INTO sanias_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","kintu te mama nāmakāraṇād yuṣmān prati tādṛśaṁ vyavahariṣyanti yato yo māṁ preritavān taṁ te na jānanti| ");
INSERT INTO sanias_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","teṣāṁ sannidhim āgatya yadyahaṁ nākathayiṣyaṁ tarhi teṣāṁ pāpaṁ nābhaviṣyat kintvadhunā teṣāṁ pāpamācchādayitum upāyo nāsti| ");
INSERT INTO sanias_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","yo jano mām ṛtīyate sa mama pitaramapi ṛtīyate| ");
INSERT INTO sanias_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","yādṛśāni karmmāṇi kenāpi kadāpi nākriyanta tādṛśāni karmmāṇi yadi teṣāṁ sākṣād ahaṁ nākariṣyaṁ tarhi teṣāṁ pāpaṁ nābhaviṣyat kintvadhunā te dṛṣṭvāpi māṁ mama pitarañcārttīyanta| ");
INSERT INTO sanias_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","tasmāt te'kāraṇaṁ mām ṛtīyante yadetad vacanaṁ teṣāṁ śāstre likhitamāste tat saphalam abhavat| ");
INSERT INTO sanias_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","kintu pitu rnirgataṁ yaṁ sahāyamarthāt satyamayam ātmānaṁ pituḥ samīpād yuṣmākaṁ samīpe preṣayiṣyāmi sa āgatya mayi pramāṇaṁ dāsyati| ");
INSERT INTO sanias_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","yūyaṁ prathamamārabhya mayā sārddhaṁ tiṣṭhatha tasmāddheto ryūyamapi pramāṇaṁ dāsyatha| ");
INSERT INTO sanias_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","yuṣmākaṁ yathā vādhā na jāyate tadarthaṁ yuṣmān etāni sarvvavākyāni vyāharaṁ| ");
INSERT INTO sanias_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","lokā yuṣmān bhajanagṛhebhyo dūrīkariṣyanti tathā yasmin samaye yuṣmān hatvā īśvarasya tuṣṭi janakaṁ karmmākurmma iti maṁsyante sa samaya āgacchanti| ");
INSERT INTO sanias_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","te pitaraṁ māñca na jānanti, tasmād yuṣmān pratīdṛśam ācariṣyanti| ");
INSERT INTO sanias_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","ato hetāḥ samaye samupasthite yathā mama kathā yuṣmākaṁ manaḥsuḥ samupatiṣṭhati tadarthaṁ yuṣmābhyam etāṁ kathāṁ kathayāmi yuṣmābhiḥ sārddham ahaṁ tiṣṭhan prathamaṁ tāṁ yuṣmabhyaṁ nākathayaṁ| ");
INSERT INTO sanias_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","sāmprataṁ svasya prerayituḥ samīpaṁ gacchāmi tathāpi tvaṁ kka gacchasi kathāmetāṁ yuṣmākaṁ kopi māṁ na pṛcchati| ");
INSERT INTO sanias_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","kintu mayoktābhirābhiḥ kathābhi ryūṣmākam antaḥkaraṇāni duḥkhena pūrṇānyabhavan| ");
INSERT INTO sanias_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","tathāpyahaṁ yathārthaṁ kathayāmi mama gamanaṁ yuṣmākaṁ hitārthameva, yato heto rgamane na kṛte sahāyo yuṣmākaṁ samīpaṁ nāgamiṣyati kintu yadi gacchāmi tarhi yuṣmākaṁ samīpe taṁ preṣayiṣyāmi| ");
INSERT INTO sanias_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","tataḥ sa āgatya pāpapuṇyadaṇḍeṣu jagato lokānāṁ prabodhaṁ janayiṣyati| ");
INSERT INTO sanias_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","te mayi na viśvasanti tasmāddhetoḥ pāpaprabodhaṁ janayiṣyati| ");
INSERT INTO sanias_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","yuṣmākam adṛśyaḥ sannahaṁ pituḥ samīpaṁ gacchāmi tasmād puṇye prabodhaṁ janayiṣyati| ");
INSERT INTO sanias_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","etajjagato'dhipati rdaṇḍājñāṁ prāpnoti tasmād daṇḍe prabodhaṁ janayiṣyati| ");
INSERT INTO sanias_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","yuṣmabhyaṁ kathayituṁ mamānekāḥ kathā āsate, tāḥ kathā idānīṁ yūyaṁ soḍhuṁ na śaknutha; ");
INSERT INTO sanias_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","kintu satyamaya ātmā yadā samāgamiṣyati tadā sarvvaṁ satyaṁ yuṣmān neṣyati, sa svataḥ kimapi na vadiṣyati kintu yacchroṣyati tadeva kathayitvā bhāvikāryyaṁ yuṣmān jñāpayiṣyati| ");
INSERT INTO sanias_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","mama mahimānaṁ prakāśayiṣyati yato madīyāṁ kathāṁ gṛhītvā yuṣmān bodhayiṣyati| ");
INSERT INTO sanias_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","pitu ryadyad āste tat sarvvaṁ mama tasmād kāraṇād avādiṣaṁ sa madīyāṁ kathāṁ gṛhītvā yuṣmān bodhayiṣyati| ");
INSERT INTO sanias_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","kiyatkālāt paraṁ yūyaṁ māṁ draṣṭuṁ na lapsyadhve kintu kiyatkālāt paraṁ puna rdraṣṭuṁ lapsyadhve yatohaṁ pituḥ samīpaṁ gacchāmi| ");
INSERT INTO sanias_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","tataḥ śiṣyāṇāṁ kiyanto janāḥ parasparaṁ vaditum ārabhanta, kiyatkālāt paraṁ māṁ draṣṭuṁ na lapsyadhve kintu kiyatkālāt paraṁ puna rdraṣṭuṁ lapsyadhve yatohaṁ pituḥ samīpaṁ gacchāmi, iti yad vākyam ayaṁ vadati tat kiṁ? ");
INSERT INTO sanias_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","tataḥ kiyatkālāt param iti tasya vākyaṁ kiṁ? tasya vākyasyābhiprāyaṁ vayaṁ boddhuṁ na śaknumastairiti ");
INSERT INTO sanias_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","nigadite yīśusteṣāṁ praśnecchāṁ jñātvā tebhyo'kathayat kiyatkālāt paraṁ māṁ draṣṭuṁ na lapsyadhve, kintu kiyatkālāt paraṁ pūna rdraṣṭuṁ lapsyadhve, yāmimāṁ kathāmakathayaṁ tasyā abhiprāyaṁ kiṁ yūyaṁ parasparaṁ mṛgayadhve? ");
INSERT INTO sanias_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","yuṣmānaham atiyathārthaṁ vadāmi yūyaṁ krandiṣyatha vilapiṣyatha ca, kintu jagato lokā ānandiṣyanti; yūyaṁ śokākulā bhaviṣyatha kintu śokāt paraṁ ānandayuktā bhaviṣyatha| ");
INSERT INTO sanias_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","prasavakāla upasthite nārī yathā prasavavedanayā vyākulā bhavati kintu putre bhūmiṣṭhe sati manuṣyaiko janmanā naraloke praviṣṭa ityānandāt tasyāstatsarvvaṁ duḥkhaṁ manasi na tiṣṭhati, ");
INSERT INTO sanias_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","tathā yūyamapi sāmprataṁ śokākulā bhavatha kintu punarapi yuṣmabhyaṁ darśanaṁ dāsyāmi tena yuṣmākam antaḥkaraṇāni sānandāni bhaviṣyanti, yuṣmākaṁ tam ānandañca kopi harttuṁ na śakṣyati| ");
INSERT INTO sanias_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","tasmin divase kāmapi kathāṁ māṁ na prakṣyatha| yuṣmānaham atiyathārthaṁ vadāmi, mama nāmnā yat kiñcid pitaraṁ yāciṣyadhve tadeva sa dāsyati| ");
INSERT INTO sanias_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","pūrvve mama nāmnā kimapi nāyācadhvaṁ, yācadhvaṁ tataḥ prāpsyatha tasmād yuṣmākaṁ sampūrṇānando janiṣyate| ");
INSERT INTO sanias_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","upamākathābhiḥ sarvvāṇyetāni yuṣmān jñāpitavān kintu yasmin samaye upamayā noktvā pituḥ kathāṁ spaṣṭaṁ jñāpayiṣyāmi samaya etādṛśa āgacchati| ");
INSERT INTO sanias_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","tadā mama nāmnā prārthayiṣyadhve 'haṁ yuṣmannimittaṁ pitaraṁ vineṣye kathāmimāṁ na vadāmi; ");
INSERT INTO sanias_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","yato yūyaṁ mayi prema kurutha, tathāham īśvarasya samīpād āgatavān ityapi pratītha, tasmād kāraṇāt kāraṇāt pitā svayaṁ yuṣmāsu prīyate| ");
INSERT INTO sanias_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","pituḥ samīpājjajad āgatosmi jagat parityajya ca punarapi pituḥ samīpaṁ gacchāmi| ");
INSERT INTO sanias_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","tadā śiṣyā avadan, he prabho bhavān upamayā noktvādhunā spaṣṭaṁ vadati| ");
INSERT INTO sanias_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","bhavān sarvvajñaḥ kenacit pṛṣṭo bhavitumapi bhavataḥ prayojanaṁ nāstītyadhunāsmākaṁ sthirajñānaṁ jātaṁ tasmād bhavān īśvarasya samīpād āgatavān ityatra vayaṁ viśvasimaḥ| ");
INSERT INTO sanias_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","tato yīśuḥ pratyavādīd idānīṁ kiṁ yūyaṁ viśvasitha? ");
INSERT INTO sanias_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","paśyata sarvve yūyaṁ vikīrṇāḥ santo mām ekākinaṁ pīratyajya svaṁ svaṁ sthānaṁ gamiṣyatha, etādṛśaḥ samaya āgacchati varaṁ prāyeṇopasthitavān; tathāpyahaṁ naikākī bhavāmi yataḥ pitā mayā sārddham āste| ");
INSERT INTO sanias_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","yathā mayā yuṣmākaṁ śānti rjāyate tadartham etāḥ kathā yuṣmabhyam acakathaṁ; asmin jagati yuṣmākaṁ kleśo ghaṭiṣyate kintvakṣobhā bhavata yato mayā jagajjitaṁ| ");
INSERT INTO sanias_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","tataḥ paraṁ yīśuretāḥ kathāḥ kathayitvā svargaṁ vilokyaitat prārthayat, he pitaḥ samaya upasthitavān; yathā tava putrastava mahimānaṁ prakāśayati tadarthaṁ tvaṁ nijaputrasya mahimānaṁ prakāśaya| ");
INSERT INTO sanias_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","tvaṁ yollokān tasya haste samarpitavān sa yathā tebhyo'nantāyu rdadāti tadarthaṁ tvaṁ prāṇimātrāṇām adhipatitvabhāraṁ tasmai dattavān| ");
INSERT INTO sanias_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","yastvam advitīyaḥ satya īśvarastvayā preritaśca yīśuḥ khrīṣṭa etayorubhayoḥ paricaye prāpte'nantāyu rbhavati| ");
INSERT INTO sanias_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","tvaṁ yasya karmmaṇo bhāraṁ mahyaṁ dattavān, tat sampannaṁ kṛtvā jagatyasmin tava mahimānaṁ prākāśayaṁ| ");
INSERT INTO sanias_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ataeva he pita rjagatyavidyamāne tvayā saha tiṣṭhato mama yo mahimāsīt samprati tava samīpe māṁ taṁ mahimānaṁ prāpaya| ");
INSERT INTO sanias_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","anyacca tvam etajjagato yāllokān mahyam adadā ahaṁ tebhyastava nāmnastattvajñānam adadāṁ, te tavaivāsan, tvaṁ tān mahyamadadāḥ, tasmātte tavopadeśam agṛhlan| ");
INSERT INTO sanias_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","tvaṁ mahyaṁ yat kiñcid adadāstatsarvvaṁ tvatto jāyate ityadhunājānan| ");
INSERT INTO sanias_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","mahyaṁ yamupadeśam adadā ahamapi tebhyastamupadeśam adadāṁ tepi tamagṛhlan tvattohaṁ nirgatya tvayā preritobhavam atra ca vyaśvasan| ");
INSERT INTO sanias_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","teṣāmeva nimittaṁ prārthaye'haṁ jagato lokanimittaṁ na prārthaye kintu yāllokān mahyam adadāsteṣāmeva nimittaṁ prārthaye'haṁ yataste tavaivāsate| ");
INSERT INTO sanias_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ye mama te tava ye ca tava te mama tathā tai rmama mahimā prakāśyate| ");
INSERT INTO sanias_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","sāmpratam asmin jagati mamāvasthiteḥ śeṣam abhavat ahaṁ tava samīpaṁ gacchāmi kintu te jagati sthāsyanti; he pavitra pitarāvayo ryathaikatvamāste tathā teṣāmapyekatvaṁ bhavati tadarthaṁ yāllokān mahyam adadāstān svanāmnā rakṣa| ");
INSERT INTO sanias_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","yāvanti dināni jagatyasmin taiḥ sahāhamāsaṁ tāvanti dināni tān tava nāmnāhaṁ rakṣitavān; yāllokān mahyam adadāstān sarvvān ahamarakṣaṁ, teṣāṁ madhye kevalaṁ vināśapātraṁ hāritaṁ tena dharmmapustakasya vacanaṁ pratyakṣaṁ bhavati| ");
INSERT INTO sanias_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","kintvadhunā tava sannidhiṁ gacchāmi mayā yathā teṣāṁ sampūrṇānando bhavati tadarthamahaṁ jagati tiṣṭhan etāḥ kathā akathayam| ");
INSERT INTO sanias_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","tavopadeśaṁ tebhyo'dadāṁ jagatā saha yathā mama sambandho nāsti tathā jajatā saha teṣāmapi sambandhābhāvāj jagato lokāstān ṛtīyante| ");
INSERT INTO sanias_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","tvaṁ jagatastān gṛhāṇeti na prārthaye kintvaśubhād rakṣeti prārthayeham| ");
INSERT INTO sanias_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ahaṁ yathā jagatsambandhīyo na bhavāmi tathā tepi jagatsambandhīyā na bhavanti| ");
INSERT INTO sanias_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","tava satyakathayā tān pavitrīkuru tava vākyameva satyaṁ| ");
INSERT INTO sanias_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","tvaṁ yathā māṁ jagati prairayastathāhamapi tān jagati prairayaṁ| ");
INSERT INTO sanias_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","teṣāṁ hitārthaṁ yathāhaṁ svaṁ pavitrīkaromi tathā satyakathayā tepi pavitrībhavantu| ");
INSERT INTO sanias_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","kevalaṁ eteṣāmarthe prārthaye'ham iti na kintveteṣāmupadeśena ye janā mayi viśvasiṣyanti teṣāmapyarthe prārtheye'ham| ");
INSERT INTO sanias_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","he pitasteṣāṁ sarvveṣām ekatvaṁ bhavatu tava yathā mayi mama ca yathā tvayyekatvaṁ tathā teṣāmapyāvayorekatvaṁ bhavatu tena tvaṁ māṁ preritavān iti jagato lokāḥ pratiyantu| ");
INSERT INTO sanias_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","yathāvayorekatvaṁ tathā teṣāmapyekatvaṁ bhavatu teṣvahaṁ mayi ca tvam itthaṁ teṣāṁ sampūrṇamekatvaṁ bhavatu, tvaṁ preritavān tvaṁ mayi yathā prīyase ca tathā teṣvapi prītavān etadyathā jagato lokā jānanti ");
INSERT INTO sanias_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","tadarthaṁ tvaṁ yaṁ mahimānaṁ mahyam adadāstaṁ mahimānam ahamapi tebhyo dattavān| ");
INSERT INTO sanias_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","he pita rjagato nirmmāṇāt pūrvvaṁ mayi snehaṁ kṛtvā yaṁ mahimānaṁ dattavān mama taṁ mahimānaṁ yathā te paśyanti tadarthaṁ yāllokān mahyaṁ dattavān ahaṁ yatra tiṣṭhāmi tepi yathā tatra tiṣṭhanti mamaiṣā vāñchā| ");
INSERT INTO sanias_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","he yathārthika pita rjagato lokaistvayyajñātepi tvāmahaṁ jāne tvaṁ māṁ preritavān itīme śiṣyā jānanti| ");
INSERT INTO sanias_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","yathāhaṁ teṣu tiṣṭhāmi tathā mayi yena premnā premākarostat teṣu tiṣṭhati tadarthaṁ tava nāmāhaṁ tān jñāpitavān punarapi jñāpayiṣyāmi| ");
INSERT INTO sanias_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","tāḥ kathāḥ kathayitvā yīśuḥ śiṣyānādāya kidronnāmakaṁ srota uttīryya śiṣyaiḥ saha tatratyodyānaṁ prāviśat| ");
INSERT INTO sanias_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","kintu viśvāsaghātiyihūdāstat sthānaṁ paricīyate yato yīśuḥ śiṣyaiḥ sārddhaṁ kadācit tat sthānam agacchat| ");
INSERT INTO sanias_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","tadā sa yihūdāḥ sainyagaṇaṁ pradhānayājakānāṁ phirūśināñca padātigaṇañca gṛhītvā pradīpān ulkān astrāṇi cādāya tasmin sthāna upasthitavān| ");
INSERT INTO sanias_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","svaṁ prati yad ghaṭiṣyate taj jñātvā yīśuragresaraḥ san tānapṛcchat kaṁ gaveṣayatha? ");
INSERT INTO sanias_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","te pratyavadan, nāsaratīyaṁ yīśuṁ; tato yīśuravādīd ahameva saḥ; taiḥ saha viśvāsaghātī yihūdāścātiṣṭhat| ");
INSERT INTO sanias_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","tadāhameva sa tasyaitāṁ kathāṁ śrutvaiva te paścādetya bhūmau patitāḥ| ");
INSERT INTO sanias_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","tato yīśuḥ punarapi pṛṣṭhavān kaṁ gaveṣayatha? tataste pratyavadan nāsaratīyaṁ yīśuṁ| ");
INSERT INTO sanias_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","tadā yīśuḥ pratyuditavān ahameva sa imāṁ kathāmacakatham; yadi māmanvicchatha tarhīmān gantuṁ mā vārayata| ");
INSERT INTO sanias_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","itthaṁ bhūte mahyaṁ yāllokān adadāsteṣām ekamapi nāhārayam imāṁ yāṁ kathāṁ sa svayamakathayat sā kathā saphalā jātā| ");
INSERT INTO sanias_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","tadā śimonpitarasya nikaṭe khaṅgalsthiteḥ sa taṁ niṣkoṣaṁ kṛtvā mahāyājakasya mālkhanāmānaṁ dāsam āhatya tasya dakṣiṇakarṇaṁ chinnavān| ");
INSERT INTO sanias_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","tato yīśuḥ pitaram avadat, khaṅgaṁ koṣe sthāpaya mama pitā mahyaṁ pātuṁ yaṁ kaṁsam adadāt tenāhaṁ kiṁ na pāsyāmi? ");
INSERT INTO sanias_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","tadā sainyagaṇaḥ senāpati ryihūdīyānāṁ padātayaśca yīśuṁ ghṛtvā baddhvā hānannāmnaḥ kiyaphāḥ śvaśurasya samīpaṁ prathamam anayan| ");
INSERT INTO sanias_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","sa kiyaphāstasmin vatsare mahāyājatvapade niyuktaḥ ");
INSERT INTO sanias_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","san sādhāraṇalokānāṁ maṅgalārtham ekajanasya maraṇamucitam iti yihūdīyaiḥ sārddham amantrayat| ");
INSERT INTO sanias_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","tadā śimonpitaro'nyaikaśiṣyaśca yīśoḥ paścād agacchatāṁ tasyānyaśiṣyasya mahāyājakena paricitatvāt sa yīśunā saha mahāyājakasyāṭṭālikāṁ prāviśat| ");
INSERT INTO sanias_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","kintu pitaro bahirdvārasya samīpe'tiṣṭhad ataeva mahāyājakena paricitaḥ sa śiṣyaḥ punarbahirgatvā dauvāyikāyai kathayitvā pitaram abhyantaram ānayat| ");
INSERT INTO sanias_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","tadā sa dvārarakṣikā pitaram avadat tvaṁ kiṁ na tasya mānavasya śiṣyaḥ? tataḥ sovadad ahaṁ na bhavāmi| ");
INSERT INTO sanias_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","tataḥ paraṁ yatsthāne dāsāḥ padātayaśca śītahetoraṅgārai rvahniṁ prajvālya tāpaṁ sevitavantastatsthāne pitarastiṣṭhan taiḥ saha vahnitāpaṁ sevitum ārabhata| ");
INSERT INTO sanias_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","tadā śiṣyeṣūpadeśe ca mahāyājakena yīśuḥ pṛṣṭaḥ ");
INSERT INTO sanias_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","san pratyuktavān sarvvalokānāṁ samakṣaṁ kathāmakathayaṁ guptaṁ kāmapi kathāṁ na kathayitvā yat sthānaṁ yihūdīyāḥ satataṁ gacchanti tatra bhajanagehe mandire cāśikṣayaṁ| ");
INSERT INTO sanias_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","mattaḥ kutaḥ pṛcchasi? ye janā madupadeśam aśṛṇvan tāneva pṛccha yadyad avadaṁ te tat jāninta| ");
INSERT INTO sanias_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","tadetthaṁ pratyuditatvāt nikaṭasthapadāti ryīśuṁ capeṭenāhatya vyāharat mahāyājakam evaṁ prativadasi? ");
INSERT INTO sanias_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","tato yīśuḥ pratigaditavān yadyayathārtham acakathaṁ tarhi tasyāyathārthasya pramāṇaṁ dehi, kintu yadi yathārthaṁ tarhi kuto heto rmām atāḍayaḥ? ");
INSERT INTO sanias_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","pūrvvaṁ hānan sabandhanaṁ taṁ kiyaphāmahāyājakasya samīpaṁ praiṣayat| ");
INSERT INTO sanias_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","śimonpitarastiṣṭhan vahnitāpaṁ sevate, etasmin samaye kiyantastam apṛcchan tvaṁ kim etasya janasya śiṣyo na? tataḥ sopahnutyābravīd ahaṁ na bhavāmi| ");
INSERT INTO sanias_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","tadā mahāyājakasya yasya dāsasya pitaraḥ karṇamacchinat tasya kuṭumbaḥ pratyuditavān udyāne tena saha tiṣṭhantaṁ tvāṁ kiṁ nāpaśyaṁ? ");
INSERT INTO sanias_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","kintu pitaraḥ punarapahnutya kathitavān; tadānīṁ kukkuṭo'raut| ");
INSERT INTO sanias_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","tadanantaraṁ pratyūṣe te kiyaphāgṛhād adhipate rgṛhaṁ yīśum anayan kintu yasmin aśucitve jāte tai rnistārotsave na bhoktavyaṁ, tasya bhayād yihūdīyāstadgṛhaṁ nāviśan| ");
INSERT INTO sanias_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","aparaṁ pīlāto bahirāgatya tān pṛṣṭhavān etasya manuṣyasya kaṁ doṣaṁ vadatha? ");
INSERT INTO sanias_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","tadā te petyavadan duṣkarmmakāriṇi na sati bhavataḥ samīpe nainaṁ samārpayiṣyāmaḥ| ");
INSERT INTO sanias_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","tataḥ pīlāto'vadad yūyamenaṁ gṛhītvā sveṣāṁ vyavasthayā vicārayata| tadā yihūdīyāḥ pratyavadan kasyāpi manuṣyasya prāṇadaṇḍaṁ karttuṁ nāsmākam adhikāro'sti| ");
INSERT INTO sanias_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","evaṁ sati yīśuḥ svasya mṛtyau yāṁ kathāṁ kathitavān sā saphalābhavat| ");
INSERT INTO sanias_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","tadanantaraṁ pīlātaḥ punarapi tad rājagṛhaṁ gatvā yīśumāhūya pṛṣṭavān tvaṁ kiṁ yihūdīyānāṁ rājā? ");
INSERT INTO sanias_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","yīśuḥ pratyavadat tvam etāṁ kathāṁ svataḥ kathayasi kimanyaḥ kaścin mayi kathitavān? ");
INSERT INTO sanias_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","pīlāto'vadad ahaṁ kiṁ yihūdīyaḥ? tava svadeśīyā viśeṣataḥ pradhānayājakā mama nikaṭe tvāṁ samārpayana, tvaṁ kiṁ kṛtavān? ");
INSERT INTO sanias_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","yīśuḥ pratyavadat mama rājyam etajjagatsambandhīyaṁ na bhavati yadi mama rājyaṁ jagatsambandhīyam abhaviṣyat tarhi yihūdīyānāṁ hasteṣu yathā samarpito nābhavaṁ tadarthaṁ mama sevakā ayotsyan kintu mama rājyam aihikaṁ na| ");
INSERT INTO sanias_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","tadā pīlātaḥ kathitavān, tarhi tvaṁ rājā bhavasi? yīśuḥ pratyuktavān tvaṁ satyaṁ kathayasi, rājāhaṁ bhavāmi; satyatāyāṁ sākṣyaṁ dātuṁ janiṁ gṛhītvā jagatyasmin avatīrṇavān, tasmāt satyadharmmapakṣapātino mama kathāṁ śṛṇvanti| ");
INSERT INTO sanias_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","tadā satyaṁ kiṁ? etāṁ kathāṁ paṣṭvā pīlātaḥ punarapi bahirgatvā yihūdīyān abhāṣata, ahaṁ tasya kamapyaparādhaṁ na prāpnomi| ");
INSERT INTO sanias_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","nistārotsavasamaye yuṣmābhirabhirucita eko jano mayā mocayitavya eṣā yuṣmākaṁ rītirasti, ataeva yuṣmākaṁ nikaṭe yihūdīyānāṁ rājānaṁ kiṁ mocayāmi, yuṣmākam icchā kā? ");
INSERT INTO sanias_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","tadā te sarvve ruvanto vyāharan enaṁ mānuṣaṁ nahi barabbāṁ mocaya| kintu sa barabbā dasyurāsīt| ");
INSERT INTO sanias_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","pīlāto yīśum ānīya kaśayā prāhārayat| ");
INSERT INTO sanias_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","paścāt senāgaṇaḥ kaṇṭakanirmmitaṁ mukuṭaṁ tasya mastake samarpya vārttākīvarṇaṁ rājaparicchadaṁ paridhāpya, ");
INSERT INTO sanias_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","he yihūdīyānāṁ rājan namaskāra ityuktvā taṁ capeṭenāhantum ārabhata| ");
INSERT INTO sanias_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","tadā pīlātaḥ punarapi bahirgatvā lokān avadat, asya kamapyaparādhaṁ na labhe'haṁ, paśyata tad yuṣmān jñāpayituṁ yuṣmākaṁ sannidhau bahirenam ānayāmi| ");
INSERT INTO sanias_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","tataḥ paraṁ yīśuḥ kaṇṭakamukuṭavān vārttākīvarṇavasanavāṁśca bahirāgacchat| tataḥ pīlāta uktavān enaṁ manuṣyaṁ paśyata| ");
INSERT INTO sanias_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","tadā pradhānayājakāḥ padātayaśca taṁ dṛṣṭvā, enaṁ kruśe vidha, enaṁ kruśe vidha, ityuktvā ravituṁ ārabhanta| tataḥ pīlātaḥ kathitavān yūyaṁ svayam enaṁ nītvā kruśe vidhata, aham etasya kamapyaparādhaṁ na prāptavān| ");
INSERT INTO sanias_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","yihūdīyāḥ pratyavadan asmākaṁ yā vyavasthāste tadanusāreṇāsya prāṇahananam ucitaṁ yatoyaṁ svam īśvarasya putramavadat| ");
INSERT INTO sanias_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","pīlāta imāṁ kathāṁ śrutvā mahātrāsayuktaḥ ");
INSERT INTO sanias_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","san punarapi rājagṛha āgatya yīśuṁ pṛṣṭavān tvaṁ kutratyo lokaḥ? kintu yīśastasya kimapi pratyuttaraṁ nāvadat| ");
INSERT INTO sanias_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","1# tataḥ pīlāt kathitavāna tvaṁ kiṁ mayā sārddhaṁ na saṁlapiṣyasi ? tvāṁ kruśe vedhituṁ vā mocayituṁ śakti rmamāste iti kiṁ tvaṁ na jānāsi ? tadā yīśuḥ pratyavadad īśvareṇādaŸाṁ mamopari tava kimapyadhipatitvaṁ na vidyate, tathāpi yo jano māṁ tava haste samārpayat tasya mahāpātakaṁ jātam| ");
INSERT INTO sanias_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","tadā yīśuḥ pratyavadad īśvareṇādattaṁ mamopari tava kimapyadhipatitvaṁ na vidyate, tathāpi yo jano māṁ tava haste samārpayat tasya mahāpātakaṁ jātam| ");
INSERT INTO sanias_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","tadārabhya pīlātastaṁ mocayituṁ ceṣṭitavān kintu yihūdīyā ruvanto vyāharan yadīmaṁ mānavaṁ tyajasi tarhi tvaṁ kaisarasya mitraṁ na bhavasi, yo janaḥ svaṁ rājānaṁ vakti saeva kaimarasya viruddhāṁ kathāṁ kathayati| ");
INSERT INTO sanias_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","etāṁ kathāṁ śrutvā pīlāto yīśuṁ bahirānīya nistārotsavasya āsādanadinasya dvitīyapraharāt pūrvvaṁ prastarabandhananāmni sthāne 'rthāt ibrīyabhāṣayā yad gabbithā kathyate tasmin sthāne vicārāsana upāviśat| ");
INSERT INTO sanias_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","anantaraṁ pīlāto yihūdīyān avadat, yuṣmākaṁ rājānaṁ paśyata| ");
INSERT INTO sanias_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","kintu enaṁ dūrīkuru, enaṁ dūrīkuru, enaṁ kruśe vidha, iti kathāṁ kathayitvā te ravitum ārabhanta; tadā pīlātaḥ kathitavān yuṣmākaṁ rājānaṁ kiṁ kruśe vedhiṣyāmi? pradhānayājakā uttaram avadan kaisaraṁ vinā kopi rājāsmākaṁ nāsti| ");
INSERT INTO sanias_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","tataḥ pīlāto yīśuṁ kruśe vedhituṁ teṣāṁ hasteṣu samārpayat, tataste taṁ dhṛtvā nītavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","tataḥ paraṁ yīśuḥ kruśaṁ vahan śiraḥkapālam arthād yad ibrīyabhāṣayā gulgaltāṁ vadanti tasmin sthāna upasthitaḥ| ");
INSERT INTO sanias_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","tataste madhyasthāne taṁ tasyobhayapārśve dvāvaparau kruśe'vidhan| ");
INSERT INTO sanias_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","aparam eṣa yihūdīyānāṁ rājā nāsaratīyayīśuḥ, iti vijñāpanaṁ likhitvā pīlātastasya kruśopari samayojayat| ");
INSERT INTO sanias_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","sā lipiḥ ibrīyayūnānīyaromīyabhāṣābhi rlikhitā; yīśoḥ kruśavedhanasthānaṁ nagarasya samīpaṁ, tasmād bahavo yihūdīyāstāṁ paṭhitum ārabhanta| ");
INSERT INTO sanias_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","yihūdīyānāṁ pradhānayājakāḥ pīlātamiti nyavedayan yihūdīyānāṁ rājeti vākyaṁ na kintu eṣa svaṁ yihūdīyānāṁ rājānam avadad itthaṁ likhatu| ");
INSERT INTO sanias_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","tataḥ pīlāta uttaraṁ dattavān yallekhanīyaṁ tallikhitavān| ");
INSERT INTO sanias_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","itthaṁ senāgaṇo yīśuṁ kruśe vidhitvā tasya paridheyavastraṁ caturo bhāgān kṛtvā ekaikasenā ekaikabhāgam agṛhlat tasyottarīyavastrañcāgṛhlat| kintūttarīyavastraṁ sūcisevanaṁ vinā sarvvam ūtaṁ| ");
INSERT INTO sanias_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","tasmātte vyāharan etat kaḥ prāpsyati? tanna khaṇḍayitvā tatra guṭikāpātaṁ karavāma| vibhajante'dharīyaṁ me vasanaṁ te parasparaṁ| mamottarīyavastrārthaṁ guṭikāṁ pātayanti ca| iti yadvākyaṁ dharmmapustake likhitamāste tat senāgaṇenetthaṁ vyavaharaṇāt siddhamabhavat| ");
INSERT INTO sanias_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","tadānīṁ yīśo rmātā mātu rbhaginī ca yā kliyapā bhāryyā mariyam magdalīnī mariyam ca etāstasya kruśasya sannidhau samatiṣṭhan| ");
INSERT INTO sanias_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","tato yīśuḥ svamātaraṁ priyatamaśiṣyañca samīpe daṇḍāyamānau vilokya mātaram avadat, he yoṣid enaṁ tava putraṁ paśya, ");
INSERT INTO sanias_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","śiṣyantvavadat, enāṁ tava mātaraṁ paśya| tataḥ sa śiṣyastadghaṭikāyāṁ tāṁ nijagṛhaṁ nītavān| ");
INSERT INTO sanias_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","anantaraṁ sarvvaṁ karmmādhunā sampannamabhūt yīśuriti jñātvā dharmmapustakasya vacanaṁ yathā siddhaṁ bhavati tadartham akathayat mama pipāsā jātā| ");
INSERT INTO sanias_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","tatastasmin sthāne amlarasena pūrṇapātrasthityā te spañjamekaṁ tadamlarasenārdrīkṛtya esobnale tad yojayitvā tasya mukhasya sannidhāvasthāpayan| ");
INSERT INTO sanias_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","tadā yīśuramlarasaṁ gṛhītvā sarvvaṁ siddham iti kathāṁ kathayitvā mastakaṁ namayan prāṇān paryyatyajat| ");
INSERT INTO sanias_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","tadvinam āsādanadinaṁ tasmāt pare'hani viśrāmavāre dehā yathā kruśopari na tiṣṭhanti, yataḥ sa viśrāmavāro mahādinamāsīt, tasmād yihūdīyāḥ pīlātanikaṭaṁ gatvā teṣāṁ pādabhañjanasya sthānāntaranayanasya cānumatiṁ prārthayanta| ");
INSERT INTO sanias_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ataḥ senā āgatya yīśunā saha kruśe hatayoḥ prathamadvitīyacorayoḥ pādān abhañjan; ");
INSERT INTO sanias_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","kintu yīśoḥ sannidhiṁ gatvā sa mṛta iti dṛṣṭvā tasya pādau nābhañjan| ");
INSERT INTO sanias_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","paścād eko yoddhā śūlāghātena tasya kukṣim avidhat tatkṣaṇāt tasmād raktaṁ jalañca niragacchat| ");
INSERT INTO sanias_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","yo jano'sya sākṣyaṁ dadāti sa svayaṁ dṛṣṭavān tasyedaṁ sākṣyaṁ satyaṁ tasya kathā yuṣmākaṁ viśvāsaṁ janayituṁ yogyā tat sa jānāti| ");
INSERT INTO sanias_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","tasyaikam asdhyapi na bhaṁkṣyate, ");
INSERT INTO sanias_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","tadvad anyaśāstrepi likhyate, yathā, \"dṛṣṭipātaṁ kariṣyanti te'vidhan yantu tamprati|\" ");
INSERT INTO sanias_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","arimathīyanagarasya yūṣaphnāmā śiṣya eka āsīt kintu yihūdīyebhyo bhayāt prakāśito na bhavati; sa yīśo rdehaṁ netuṁ pīlātasyānumatiṁ prārthayata, tataḥ pīlātenānumate sati sa gatvā yīśo rdeham anayat| ");
INSERT INTO sanias_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","aparaṁ yo nikadīmo rātrau yīśoḥ samīpam agacchat sopi gandharasena miśritaṁ prāyeṇa pañcāśatseṭakamaguruṁ gṛhītvāgacchat| ");
INSERT INTO sanias_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","tataste yihūdīyānāṁ śmaśāne sthāpanarītyanusāreṇa tatsugandhidravyeṇa sahitaṁ tasya dehaṁ vastreṇāveṣṭayan| ");
INSERT INTO sanias_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","aparañca yatra sthāne taṁ kruśe'vidhan tasya nikaṭasthodyāne yatra kimapi mṛtadehaṁ kadāpi nāsthāpyata tādṛśam ekaṁ nūtanaṁ śmaśānam āsīt| ");
INSERT INTO sanias_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","yihūdīyānām āsādanadināgamanāt te tasmin samīpasthaśmaśāne yīśum aśāyayan| ");
INSERT INTO sanias_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","anantaraṁ saptāhasya prathamadine 'tipratyūṣe 'ndhakāre tiṣṭhati magdalīnī mariyam tasya śmaśānasya nikaṭaṁ gatvā śmaśānasya mukhāt prastaramapasāritam apaśyat| ");
INSERT INTO sanias_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","paścād dhāvitvā śimonpitarāya yīśoḥ priyatamaśiṣyāya cedam akathayat, lokāḥ śmaśānāt prabhuṁ nītvā kutrāsthāpayan tad vaktuṁ na śaknomi| ");
INSERT INTO sanias_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","ataḥ pitaraḥ sonyaśiṣyaśca barhi rbhutvā śmaśānasthānaṁ gantum ārabhetāṁ| ");
INSERT INTO sanias_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ubhayordhāvatoḥ sonyaśiṣyaḥ pitaraṁ paścāt tyaktvā pūrvvaṁ śmaśānasthāna upasthitavān| ");
INSERT INTO sanias_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","tadā prahvībhūya sthāpitavastrāṇi dṛṣṭavān kintu na prāviśat| ");
INSERT INTO sanias_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","aparaṁ śimonpitara āgatya śmaśānasthānaṁ praviśya ");
INSERT INTO sanias_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","sthāpitavastrāṇi mastakasya vastrañca pṛthak sthānāntare sthāpitaṁ dṛṣṭavān| ");
INSERT INTO sanias_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","tataḥ śmaśānasthānaṁ pūrvvam āgato yonyaśiṣyaḥ sopi praviśya tādṛśaṁ dṛṣṭā vyaśvasīt| ");
INSERT INTO sanias_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","yataḥ śmaśānāt sa utthāpayitavya etasya dharmmapustakavacanasya bhāvaṁ te tadā voddhuṁ nāśankuvan| ");
INSERT INTO sanias_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","anantaraṁ tau dvau śiṣyau svaṁ svaṁ gṛhaṁ parāvṛtyāgacchatām| ");
INSERT INTO sanias_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","tataḥ paraṁ mariyam śmaśānadvārasya bahiḥ sthitvā roditum ārabhata tato rudatī prahvībhūya śmaśānaṁ vilokya ");
INSERT INTO sanias_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","yīśoḥ śayanasthānasya śiraḥsthāne padatale ca dvayo rdiśo dvau svargīyadūtāvupaviṣṭau samapaśyat| ");
INSERT INTO sanias_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","tau pṛṣṭavantau he nāri kuto rodiṣi? sāvadat lokā mama prabhuṁ nītvā kutrāsthāpayan iti na jānāmi| ");
INSERT INTO sanias_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ityuktvā mukhaṁ parāvṛtya yīśuṁ daṇḍāyamānam apaśyat kintu sa yīśuriti sā jñātuṁ nāśaknot| ");
INSERT INTO sanias_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","tadā yīśustām apṛcchat he nāri kuto rodiṣi? kaṁ vā mṛgayase? tataḥ sā tam udyānasevakaṁ jñātvā vyāharat, he maheccha tvaṁ yadītaḥ sthānāt taṁ nītavān tarhi kutrāsthāpayastad vada tatsthānāt tam ānayāmi| ");
INSERT INTO sanias_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","tadā yīśustām avadat he mariyam| tataḥ sā parāvṛtya pratyavadat he rabbūnī arthāt he guro| ");
INSERT INTO sanias_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","tadā yīśuravadat māṁ mā dhara, idānīṁ pituḥ samīpe ūrddhvagamanaṁ na karomi kintu yo mama yuṣmākañca pitā mama yuṣmākañceśvarastasya nikaṭa ūrddhvagamanaṁ karttum udyatosmi, imāṁ kathāṁ tvaṁ gatvā mama bhrātṛgaṇaṁ jñāpaya| ");
INSERT INTO sanias_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","tato magdalīnīmariyam tatkṣaṇād gatvā prabhustasyai darśanaṁ dattvā kathā etā akathayad iti vārttāṁ śiṣyebhyo'kathayat| ");
INSERT INTO sanias_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","tataḥ paraṁ saptāhasya prathamadinasya sandhyāsamaye śiṣyā ekatra militvā yihūdīyebhyo bhiyā dvāraruddham akurvvan, etasmin kāle yīśusteṣāṁ madhyasthāne tiṣṭhan akathayad yuṣmākaṁ kalyāṇaṁ bhūyāt| ");
INSERT INTO sanias_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ityuktvā nijahastaṁ kukṣiñca darśitavān, tataḥ śiṣyāḥ prabhuṁ dṛṣṭvā hṛṣṭā abhavan| ");
INSERT INTO sanias_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","yīśuḥ punaravadad yuṣmākaṁ kalyāṇaṁ bhūyāt pitā yathā māṁ praiṣayat tathāhamapi yuṣmān preṣayāmi| ");
INSERT INTO sanias_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ityuktvā sa teṣāmupari dīrghapraśvāsaṁ dattvā kathitavān pavitram ātmānaṁ gṛhlīta| ");
INSERT INTO sanias_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","yūyaṁ yeṣāṁ pāpāni mocayiṣyatha te mocayiṣyante yeṣāñca pāpāti na mocayiṣyatha te na mocayiṣyante| ");
INSERT INTO sanias_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","dvādaśamadhye gaṇito yamajo thomānāmā śiṣyo yīśorāgamanakālai taiḥ sārddhaṁ nāsīt| ");
INSERT INTO sanias_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","ato vayaṁ prabhūm apaśyāmeti vākye'nyaśiṣyairukte sovadat, tasya hastayo rlauhakīlakānāṁ cihnaṁ na vilokya taccihnam aṅgulyā na spṛṣṭvā tasya kukṣau hastaṁ nāropya cāhaṁ na viśvasiṣyāmi| ");
INSERT INTO sanias_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","aparam aṣṭame'hni gate sati thomāsahitaḥ śiṣyagaṇa ekatra militvā dvāraṁ ruddhvābhyantara āsīt, etarhi yīśusteṣāṁ madhyasthāne tiṣṭhan akathayat, yuṣmākaṁ kuśalaṁ bhūyāt| ");
INSERT INTO sanias_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","paścāt thāmai kathitavān tvam aṅgulīm atrārpayitvā mama karau paśya karaṁ prasāryya mama kukṣāvarpaya nāviśvasya| ");
INSERT INTO sanias_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","tadā thomā avadat, he mama prabho he madīśvara| ");
INSERT INTO sanias_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","yīśurakathayat, he thomā māṁ nirīkṣya viśvasiṣi ye na dṛṣṭvā viśvasanti taeva dhanyāḥ| ");
INSERT INTO sanias_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","etadanyāni pustake'smin alikhitāni bahūnyāścaryyakarmmāṇi yīśuḥ śiṣyāṇāṁ purastād akarot| ");
INSERT INTO sanias_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","kintu yīśurīśvarasyābhiṣiktaḥ suta eveti yathā yūyaṁ viśvasitha viśvasya ca tasya nāmnā paramāyuḥ prāpnutha tadartham etāni sarvvāṇyalikhyanta| ");
INSERT INTO sanias_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","tataḥ paraṁ tibiriyājaladhestaṭe yīśuḥ punarapi śiṣyebhyo darśanaṁ dattavān darśanasyākhyānamidam| ");
INSERT INTO sanias_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","śimonpitaraḥ yamajathomā gālīlīyakānnānagaranivāsī nithanel sivadeḥ putrāvanyau dvau śiṣyau caiteṣvekatra militeṣu śimonpitaro'kathayat matsyān dhartuṁ yāmi| ");
INSERT INTO sanias_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","tataste vyāharan tarhi vayamapi tvayā sārddhaṁ yāmaḥ tadā te bahirgatāḥ santaḥ kṣipraṁ nāvam ārohan kintu tasyāṁ rajanyām ekamapi na prāpnuvan| ");
INSERT INTO sanias_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","prabhāte sati yīśustaṭe sthitavān kintu sa yīśuriti śiṣyā jñātuṁ nāśaknuvan| ");
INSERT INTO sanias_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","tadā yīśurapṛcchat, he vatsā sannidhau kiñcit khādyadravyam āste? te'vadan kimapi nāsti| ");
INSERT INTO sanias_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","tadā so'vadat naukāyā dakṣiṇapārśve jālaṁ nikṣipata tato lapsyadhve, tasmāt tai rnikṣipte jāle matsyā etāvanto'patan yena te jālamākṛṣya nottolayituṁ śaktāḥ| ");
INSERT INTO sanias_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","tasmād yīśoḥ priyatamaśiṣyaḥ pitarāyākathayat eṣa prabhu rbhavet, eṣa prabhuriti vācaṁ śrutvaiva śimon nagnatāheto rmatsyadhāriṇa uttarīyavastraṁ paridhāya hradaṁ pratyudalamphayat| ");
INSERT INTO sanias_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","apare śiṣyā matsyaiḥ sārddhaṁ jālam ākarṣantaḥ kṣudranaukāṁ vāhayitvā kūlamānayan te kūlād atidūre nāsan dviśatahastebhyo dūra āsan ityanumīyate| ");
INSERT INTO sanias_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","tīraṁ prāptaistaistatra prajvalitāgnistadupari matsyāḥ pūpāśca dṛṣṭāḥ| ");
INSERT INTO sanias_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","tato yīśurakathayad yān matsyān adharata teṣāṁ katipayān ānayata| ");
INSERT INTO sanias_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ataḥ śimonpitaraḥ parāvṛtya gatvā bṛhadbhistripañcāśadadhikaśatamatsyaiḥ paripūrṇaṁ tajjālam ākṛṣyodatolayat kintvetāvadbhi rmatsyairapi jālaṁ nāchidyata| ");
INSERT INTO sanias_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","anantaraṁ yīśustān avādīt yūyamāgatya bhuṁgdhvaṁ; tadā saeva prabhuriti jñātatvāt tvaṁ kaḥ? iti praṣṭuṁ śiṣyāṇāṁ kasyāpi pragalbhatā nābhavat| ");
INSERT INTO sanias_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","tato yīśurāgatya pūpān matsyāṁśca gṛhītvā tebhyaḥ paryyaveṣayat| ");
INSERT INTO sanias_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","itthaṁ śmaśānādutthānāt paraṁ yīśuḥ śiṣyebhyastṛtīyavāraṁ darśanaṁ dattavān| ");
INSERT INTO sanias_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","bhojane samāpte sati yīśuḥ śimonpitaraṁ pṛṣṭavān, he yūnasaḥ putra śimon tvaṁ kim etebhyodhikaṁ mayi prīyase? tataḥ sa uditavān satyaṁ prabho tvayi prīye'haṁ tad bhavān jānāti; tadā yīśurakathayat tarhi mama meṣaśāvakagaṇaṁ pālaya| ");
INSERT INTO sanias_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","tataḥ sa dvitīyavāraṁ pṛṣṭavān he yūnasaḥ putra śimon tvaṁ kiṁ mayi prīyase? tataḥ sa uktavān satyaṁ prabho tvayi prīye'haṁ tad bhavān jānāti; tadā yīśurakathayata tarhi mama meṣagaṇaṁ pālaya| ");
INSERT INTO sanias_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","paścāt sa tṛtīyavāraṁ pṛṣṭavān, he yūnasaḥ putra śimon tvaṁ kiṁ mayi prīyase? etadvākyaṁ tṛtīyavāraṁ pṛṣṭavān tasmāt pitaro duḥkhito bhūtvā'kathayat he prabho bhavataḥ kimapyagocaraṁ nāsti tvayyahaṁ prīye tad bhavān jānāti; tato yīśuravadat tarhi mama meṣagaṇaṁ pālaya| ");
INSERT INTO sanias_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","ahaṁ tubhyaṁ yathārthaṁ kathayāmi yauvanakāle svayaṁ baddhakaṭi ryatrecchā tatra yātavān kintvitaḥ paraṁ vṛddhe vayasi hastaṁ vistārayiṣyasi, anyajanastvāṁ baddhvā yatra gantuṁ tavecchā na bhavati tvāṁ dhṛtvā tatra neṣyati| ");
INSERT INTO sanias_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","phalataḥ kīdṛśena maraṇena sa īśvarasya mahimānaṁ prakāśayiṣyati tad bodhayituṁ sa iti vākyaṁ proktavān| ityukte sati sa tamavocat mama paścād āgaccha| ");
INSERT INTO sanias_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","yo jano rātrikāle yīśo rvakṣo'valambya, he prabho ko bhavantaṁ parakareṣu samarpayiṣyatīti vākyaṁ pṛṣṭavān, taṁ yīśoḥ priyatamaśiṣyaṁ paścād āgacchantaṁ ");
INSERT INTO sanias_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","pitaro mukhaṁ parāvarttya vilokya yīśuṁ pṛṣṭavān, he prabho etasya mānavasya kīdṛśī gati rbhaviṣyati? ");
INSERT INTO sanias_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","sa pratyavadat, mama punarāgamanaparyyantaṁ yadi taṁ sthāpayitum icchāmi tatra tava kiṁ? tvaṁ mama paścād āgaccha| ");
INSERT INTO sanias_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","tasmāt sa śiṣyo na mariṣyatīti bhrātṛgaṇamadhye kiṁvadantī jātā kintu sa na mariṣyatīti vākyaṁ yīśu rnāvadat kevalaṁ mama punarāgamanaparyyantaṁ yadi taṁ sthāpayitum icchāmi tatra tava kiṁ? iti vākyam uktavān| ");
INSERT INTO sanias_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","yo jana etāni sarvvāṇi likhitavān atra sākṣyañca dattavān saeva sa śiṣyaḥ, tasya sākṣyaṁ pramāṇamiti vayaṁ jānīmaḥ| ");
INSERT INTO sanias_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","yīśuretebhyo'parāṇyapi bahūni karmmāṇi kṛtavān tāni sarvvāṇi yadyekaikaṁ kṛtvā likhyante tarhi granthā etāvanto bhavanti teṣāṁ dhāraṇe pṛthivyāṁ sthānaṁ na bhavati| iti||");
INSERT INTO sanias_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","he thiyaphila, yīśuḥ svamanonītān preritān pavitreṇātmanā samādiśya yasmin dine svargamārohat yāṁ yāṁ kriyāmakarot yadyad upādiśacca tāni sarvvāṇi pūrvvaṁ mayā likhitāni| ");
INSERT INTO sanias_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","sa svanidhanaduḥkhabhogāt param anekapratyayakṣapramāṇauḥ svaṁ sajīvaṁ darśayitvā ");
INSERT INTO sanias_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","catvāriṁśaddināni yāvat tebhyaḥ preritebhyo darśanaṁ dattveśvarīyarājyasya varṇanama akarot| ");
INSERT INTO sanias_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","anantaraṁ teṣāṁ sabhāṁ kṛtvā ityājñāpayat, yūyaṁ yirūśālamo'nyatra gamanamakṛtvā yastin pitrāṅgīkṛte mama vadanāt kathā aśṛṇuta tatprāptim apekṣya tiṣṭhata| ");
INSERT INTO sanias_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","yohan jale majjitāvān kintvalpadinamadhye yūyaṁ pavitra ātmani majjitā bhaviṣyatha| ");
INSERT INTO sanias_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","paścāt te sarvve militvā tam apṛcchan he prabho bhavān kimidānīṁ punarapi rājyam isrāyelīyalokānāṁ kareṣu samarpayiṣyati? ");
INSERT INTO sanias_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","tataḥ sovadat yān sarvvān kālān samayāṁśca pitā svavaśe'sthāpayat tān jñātṛṁ yuṣmākam adhikāro na jāyate| ");
INSERT INTO sanias_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","kintu yuṣmāsu pavitrasyātmana āvirbhāve sati yūyaṁ śaktiṁ prāpya yirūśālami samastayihūdāśomiroṇadeśayoḥ pṛthivyāḥ sīmāṁ yāvad yāvanto deśāsteṣu yarvveṣu ca mayi sākṣyaṁ dāsyatha| ");
INSERT INTO sanias_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","iti vākyamuktvā sa teṣāṁ samakṣaṁ svargaṁ nīto'bhavat, tato meghamāruhya teṣāṁ dṛṣṭeragocaro'bhavat| ");
INSERT INTO sanias_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","yasmin samaye te vihāyasaṁ pratyananyadṛṣṭyā tasya tādṛśam ūrdvvagamanam apaśyan tasminneva samaye śuklavastrau dvau janau teṣāṁ sannidhau daṇḍāyamānau kathitavantau, ");
INSERT INTO sanias_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","he gālīlīyalokā yūyaṁ kimarthaṁ gagaṇaṁ prati nirīkṣya daṇḍāyamānāstiṣṭhatha? yuṣmākaṁ samīpāt svargaṁ nīto yo yīśustaṁ yūyaṁ yathā svargam ārohantam adarśam tathā sa punaścāgamiṣyati| ");
INSERT INTO sanias_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","tataḥ paraṁ te jaitunanāmnaḥ parvvatād viśrāmavārasya pathaḥ parimāṇam arthāt prāyeṇārddhakrośaṁ durasthaṁ yirūśālamnagaraṁ parāvṛtyāgacchan| ");
INSERT INTO sanias_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","nagaraṁ praviśya pitaro yākūb yohan āndriyaḥ philipaḥ thomā barthajamayo mathirālphīyaputro yākūb udyogāी śimon yākūbo bhrātā yihūdā ete sarvve yatra sthāne pravasanti tasmin uparitanaprakoṣṭhe prāviśan| ");
INSERT INTO sanias_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","paścād ime kiyatyaḥ striyaśca yīśo rmātā mariyam tasya bhrātaraścaite sarvva ekacittībhūta satataṁ vinayena vinayena prārthayanta| ");
INSERT INTO sanias_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","tasmin samaye tatra sthāne sākalyena viṁśatyadhikaśataṁ śiṣyā āsan| tataḥ pitarasteṣāṁ madhye tiṣṭhan uktavān ");
INSERT INTO sanias_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","he bhrātṛgaṇa yīśudhāriṇāṁ lokānāṁ pathadarśako yo yihūdāstasmin dāyūdā pavitra ātmā yāṁ kathāṁ kathayāmāsa tasyāḥ pratyakṣībhavanasyāvaśyakatvam āsīt| ");
INSERT INTO sanias_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","sa jano'smākaṁ madhyavarttī san asyāḥ sevāyā aṁśam alabhata| ");
INSERT INTO sanias_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","tadanantaraṁ kukarmmaṇā labdhaṁ yanmūlyaṁ tena kṣetramekaṁ krītam aparaṁ tasmin adhomukhe bhṛmau patite sati tasyodarasya vidīrṇatvāt sarvvā nāḍyo niragacchan| ");
INSERT INTO sanias_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","etāṁ kathāṁ yirūśālamnivāsinaḥ sarvve lokā vidānti; teṣāṁ nijabhāṣayā tatkṣetrañca hakaldāmā, arthāt raktakṣetramiti vikhyātamāste| ");
INSERT INTO sanias_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","anyacca, niketanaṁ tadīyantu śunyameva bhaviṣyati| tasya dūṣye nivāsārthaṁ kopi sthāsyati naiva hi| anya eva janastasya padaṁ saṁprāpsyati dhruvaṁ| itthaṁ gītapustake likhitamāste| ");
INSERT INTO sanias_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","ato yohano majjanam ārabhyāsmākaṁ samīpāt prabho ryīśoḥ svargārohaṇadinaṁ yāvat sosmākaṁ madhye yāvanti dināni yāpitavān ");
INSERT INTO sanias_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","tāvanti dināni ye mānavā asmābhiḥ sārddhaṁ tiṣṭhanti teṣām ekena janenāsmābhiḥ sārddhaṁ yīśorutthāne sākṣiṇā bhavitavyaṁ| ");
INSERT INTO sanias_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","ato yasya rūḍhi ryuṣṭo yaṁ barśabbetyuktvāhūyanti sa yūṣaph matathiśca dvāvetau pṛthak kṛtvā ta īśvarasya sannidhau prāryya kathitavantaḥ, ");
INSERT INTO sanias_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","he sarvvāntaryyāmin parameśvara, yihūdāḥ sevanapreritatvapadacyutaḥ ");
INSERT INTO sanias_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","san nijasthānam agacchat, tatpadaṁ labdhum enayo rjanayo rmadhye bhavatā ko'bhirucitastadasmān darśyatāṁ| ");
INSERT INTO sanias_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","tato guṭikāpāṭe kṛte matathirniracīyata tasmāt sonyeṣām ekādaśānāṁ praritānāṁ madhye gaṇitobhavat| ");
INSERT INTO sanias_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","aparañca nistārotsavāt paraṁ pañcāśattame dine samupasthite sati te sarvve ekācittībhūya sthāna ekasmin militā āsan| ");
INSERT INTO sanias_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","etasminneva samaye'kasmād ākāśāt pracaṇḍātyugravāyoḥ śabdavad ekaḥ śabda āgatya yasmin gṛhe ta upāviśan tad gṛhaṁ samastaṁ vyāpnot| ");
INSERT INTO sanias_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","tataḥ paraṁ vahniśikhāsvarūpā jihvāḥ pratyakṣībhūya vibhaktāḥ satyaḥ pratijanorddhve sthagitā abhūvan| ");
INSERT INTO sanias_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","tasmāt sarvve pavitreṇātmanā paripūrṇāḥ santa ātmā yathā vācitavān tadanusāreṇānyadeśīyānāṁ bhāṣā uktavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","tasmin samaye pṛthivīsthasarvvadeśebhyo yihūdīyamatāvalambino bhaktalokā yirūśālami prāvasan; ");
INSERT INTO sanias_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","tasyāḥ kathāyāḥ kiṁvadantyā jātatvāt sarvve lokā militvā nijanijabhāṣayā śiṣyāṇāṁ kathākathanaṁ śrutvā samudvignā abhavan| ");
INSERT INTO sanias_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","sarvvaeva vismayāpannā āścaryyānvitāśca santaḥ parasparaṁ uktavantaḥ paśyata ye kathāṁ kathayanti te sarvve gālīlīyalokāḥ kiṁ na bhavanti? ");
INSERT INTO sanias_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","tarhi vayaṁ pratyekaśaḥ svasvajanmadeśīyabhāṣābhiḥ kathā eteṣāṁ śṛṇumaḥ kimidaṁ? ");
INSERT INTO sanias_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","pārthī-mādī-arāmnaharayimdeśanivāsimano yihūdā-kappadakiyā-panta-āśiyā- ");
INSERT INTO sanias_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","phrugiyā-pamphuliyā-misaranivāsinaḥ kurīṇīnikaṭavarttilūbīyapradeśanivāsino romanagarād āgatā yihūdīyalokā yihūdīyamatagrāhiṇaḥ krītīyā arābīyādayo lokāśca ye vayam ");
INSERT INTO sanias_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","asmākaṁ nijanijabhāṣābhireteṣām īśvarīyamahākarmmavyākhyānaṁ śṛṇumaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","itthaṁ te sarvvaeva vismayāpannāḥ sandigdhacittāḥ santaḥ parasparamūcuḥ, asya ko bhāvaḥ? ");
INSERT INTO sanias_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","apare kecit parihasya kathitavanta ete navīnadrākṣārasena mattā abhavan| ");
INSERT INTO sanias_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","tadā pitara ekādaśabhi rjanaiḥ sākaṁ tiṣṭhan tāllokān uccaiḥkāram avadat, he yihūdīyā he yirūśālamnivāsinaḥ sarvve, avadhānaṁ kṛtvā madīyavākyaṁ budhyadhvaṁ| ");
INSERT INTO sanias_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","idānīm ekayāmād adhikā velā nāsti tasmād yūyaṁ yad anumātha mānavā ime madyapānena mattāstanna| ");
INSERT INTO sanias_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","kintu yoyelbhaviṣyadvaktraitadvākyamuktaṁ yathā, ");
INSERT INTO sanias_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","īśvaraḥ kathayāmāsa yugāntasamaye tvaham| varṣiṣyāmi svamātmānaṁ sarvvaprāṇyupari dhruvam| bhāvivākyaṁ vadiṣyanti kanyāḥ putrāśca vastutaḥ|pratyādeśañca prāpsyanti yuṣmākaṁ yuvamānavāḥ| tathā prācīnalokāstu svapnān drakṣyanti niścitaṁ| ");
INSERT INTO sanias_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","varṣiṣyāmi tadātmānaṁ dāsadāsījanopiri| tenaiva bhāvivākyaṁ te vadiṣyanti hi sarvvaśaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ūrddhvasthe gagaṇe caiva nīcasthe pṛthivītale| śoṇitāni bṛhadbhānūn ghanadhūmādikāni ca| cihnāni darśayiṣyāmi mahāścaryyakriyāstathā| ");
INSERT INTO sanias_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","mahābhayānakasyaiva taddinasya pareśituḥ| purāgamād raviḥ kṛṣṇo raktaścandro bhaviṣyataḥ| ");
INSERT INTO sanias_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","kintu yaḥ parameśasya nāmni samprārthayiṣyate| saeva manujo nūnaṁ paritrāto bhaviṣyati|| ");
INSERT INTO sanias_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","ato he isrāyelvaṁśīyalokāḥ sarvve kathāyāmetasyām mano nidhaddhvaṁ nāsaratīyo yīśurīśvarasya manonītaḥ pumān etad īśvarastatkṛtairāścaryyādbhutakarmmabhi rlakṣaṇaiśca yuṣmākaṁ sākṣādeva pratipāditavān iti yūyaṁ jānītha| ");
INSERT INTO sanias_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","tasmin yīśau īśvarasya pūrvvaniścitamantraṇānirūpaṇānusāreṇa mṛtyau samarpite sati yūyaṁ taṁ dhṛtvā duṣṭalokānāṁ hastaiḥ kruśe vidhitvāhata| ");
INSERT INTO sanias_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","kintvīśvarastaṁ nidhanasya bandhanānmocayitvā udasthāpayat yataḥ sa mṛtyunā baddhastiṣṭhatīti na sambhavati| ");
INSERT INTO sanias_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","etastin dāyūdapi kathitavān yathā, sarvvadā mama sākṣāttaṁ sthāpaya parameśvaraṁ| sthite maddakṣiṇe tasmin skhaliṣyāmi tvahaṁ nahi| ");
INSERT INTO sanias_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ānandiṣyati taddheto rmāmakīnaṁ manastu vai| āhlādiṣyati jihvāpi madīyā tu tathaiva ca| pratyāśayā śarīrantu madīyaṁ vaiśayiṣyate| ");
INSERT INTO sanias_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","paraloke yato hetostvaṁ māṁ naiva hi tyakṣyasi| svakīyaṁ puṇyavantaṁ tvaṁ kṣayituṁ naiva dāsyasi| evaṁ jīvanamārgaṁ tvaṁ māmeva darśayiṣyasi| ");
INSERT INTO sanias_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","svasammukhe ya ānando dakṣiṇe svasya yat sukhaṁ| anantaṁ tena māṁ pūrṇaṁ kariṣyasi na saṁśayaḥ|| ");
INSERT INTO sanias_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","he bhrātaro'smākaṁ tasya pūrvvapuruṣasya dāyūdaḥ kathāṁ spaṣṭaṁ kathayituṁ mām anumanyadhvaṁ, sa prāṇān tyaktvā śmaśāne sthāpitobhavad adyāpi tat śmaśānam asmākaṁ sannidhau vidyate| ");
INSERT INTO sanias_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","phalato laukikabhāvena dāyūdo vaṁśe khrīṣṭaṁ janma grāhayitvā tasyaiva siṁhāsane samuveṣṭuṁ tamutthāpayiṣyati parameśvaraḥ śapathaṁ kutvā dāyūdaḥ samīpa imam aṅgīkāraṁ kṛtavān, ");
INSERT INTO sanias_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","iti jñātvā dāyūd bhaviṣyadvādī san bhaviṣyatkālīyajñānena khrīṣṭotthāne kathāmimāṁ kathayāmāsa yathā tasyātmā paraloke na tyakṣyate tasya śarīrañca na kṣeṣyati; ");
INSERT INTO sanias_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","ataḥ parameśvara enaṁ yīśuṁ śmaśānād udasthāpayat tatra vayaṁ sarvve sākṣiṇa āsmahe| ");
INSERT INTO sanias_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","sa īśvarasya dakṣiṇakareṇonnatiṁ prāpya pavitra ātmina pitā yamaṅgīkāraṁ kṛtavān tasya phalaṁ prāpya yat paśyatha śṛṇutha ca tadavarṣat| ");
INSERT INTO sanias_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","yato dāyūd svargaṁ nāruroha kintu svayam imāṁ kathām akathayad yathā, mama prabhumidaṁ vākyamavadat parameśvaraḥ| ");
INSERT INTO sanias_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","tava śatrūnahaṁ yāvat pādapīṭhaṁ karomi na| tāvat kālaṁ madīye tvaṁ dakṣavārśva upāviśa| ");
INSERT INTO sanias_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","ato yaṁ yīśuṁ yūyaṁ kruśe'hata parameśvarastaṁ prabhutvābhiṣiktatvapade nyayuṁkteti isrāyelīyā lokā niścitaṁ jānantu| ");
INSERT INTO sanias_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","etādṛśīṁ kathāṁ śrutvā teṣāṁ hṛdayānāṁ vidīrṇatvāt te pitarāya tadanyapreritebhyaśca kathitavantaḥ, he bhrātṛgaṇa vayaṁ kiṁ kariṣyāmaḥ? ");
INSERT INTO sanias_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","tataḥ pitaraḥ pratyavadad yūyaṁ sarvve svaṁ svaṁ manaḥ parivarttayadhvaṁ tathā pāpamocanārthaṁ yīśukhrīṣṭasya nāmnā majjitāśca bhavata, tasmād dānarūpaṁ paritram ātmānaṁ lapsyatha| ");
INSERT INTO sanias_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","yato yuṣmākaṁ yuṣmatsantānānāñca dūrasthasarvvalokānāñca nimittam arthād asmākaṁ prabhuḥ parameśvaro yāvato lākān āhvāsyati teṣāṁ sarvveṣāṁ nimittam ayamaṅgīkāra āste| ");
INSERT INTO sanias_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","etadanyābhi rbahukathābhiḥ pramāṇaṁ datvākathayat etebhyo vipathagāmibhyo varttamānalokebhyaḥ svān rakṣata| ");
INSERT INTO sanias_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","tataḥ paraṁ ye sānandāstāṁ kathām agṛhlan te majjitā abhavan| tasmin divase prāyeṇa trīṇi sahasrāṇi lokāsteṣāṁ sapakṣāḥ santaḥ ");
INSERT INTO sanias_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","preritānām upadeśe saṅgatau pūpabhañjane prārthanāsu ca manaḥsaṁyogaṁ kṛtvātiṣṭhan| ");
INSERT INTO sanias_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","preritai rnānāprakāralakṣaṇeṣu mahāścaryyakarmamasu ca darśiteṣu sarvvalokānāṁ bhayamupasthitaṁ| ");
INSERT INTO sanias_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","viśvāsakāriṇaḥ sarvva ca saha tiṣṭhanataḥ| sveṣāṁ sarvvāḥ sampattīḥ sādhāraṇyena sthāpayitvābhuñjata| ");
INSERT INTO sanias_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","phalato gṛhāṇi dravyāṇi ca sarvvāṇi vikrīya sarvveṣāṁ svasvaprayojanānusāreṇa vibhajya sarvvebhyo'dadan| ");
INSERT INTO sanias_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","sarvva ekacittībhūya dine dine mandire santiṣṭhamānā gṛhe gṛhe ca pūpānabhañjanta īśvarasya dhanyavādaṁ kurvvanto lokaiḥ samādṛtāḥ paramānandena saralāntaḥkaraṇena bhojanaṁ pānañcakurvvan| ");
INSERT INTO sanias_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","parameśvaro dine dine paritrāṇabhājanai rmaṇḍalīm avarddhayat| ");
INSERT INTO sanias_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","tṛtīyayāmavelāyāṁ satyāṁ prārthanāyāḥ samaye pitarayohanau sambhūya mandiraṁ gacchataḥ| ");
INSERT INTO sanias_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","tasminneva samaye mandirapraveśakānāṁ samīpe bhikṣāraṇārthaṁ yaṁ janmakhañjamānuṣaṁ lokā mandirasya sundaranāmni dvāre pratidinam asthāpayan taṁ vahantastadvāraṁ ānayan| ");
INSERT INTO sanias_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","tadā pitarayohanau mantiraṁ praveṣṭum udyatau vilokya sa khañjastau kiñcid bhikṣitavān| ");
INSERT INTO sanias_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","tasmād yohanā sahitaḥ pitarastam ananyadṛṣṭyā nirīkṣya proktavān āvāṁ prati dṛṣṭiṁ kuru| ");
INSERT INTO sanias_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","tataḥ sa kiñcit prāptyāśayā tau prati dṛṣṭiṁ kṛtavān| ");
INSERT INTO sanias_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","tadā pitaro gaditavān mama nikaṭe svarṇarūpyādi kimapi nāsti kintu yadāste tad dadāmi nāsaratīyasya yīśukhrīṣṭasya nāmnā tvamutthāya gamanāgamane kuru| ");
INSERT INTO sanias_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","tataḥ paraṁ sa tasya dakṣiṇakaraṁ dhṛtvā tam udatolayat; tena tatkṣaṇāt tasya janasya pādagulphayoḥ sabalatvāt sa ullamphya protthāya gamanāgamane 'karot| ");
INSERT INTO sanias_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","tato gamanāgamane kurvvan ullamphan īśvaraṁ dhanyaṁ vadan tābhyāṁ sārddhaṁ mandiraṁ prāviśat| ");
INSERT INTO sanias_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","tataḥ sarvve lokāstaṁ gamanāgamane kurvvantam īśvaraṁ dhanyaṁ vadantañca vilokya ");
INSERT INTO sanias_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","mandirasya sundare dvāre ya upaviśya bhikṣitavān saevāyam iti jñātvā taṁ prati tayā ghaṭanayā camatkṛtā vismayāpannāścābhavan| ");
INSERT INTO sanias_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","yaḥ khañjaḥ svasthobhavat tena pitarayohanoḥ karayordhṭatayoḥ satoḥ sarvve lokā sannidhim āgacchan| ");
INSERT INTO sanias_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","tad dṛṣṭvā pitarastebhyo'kathayat, he isrāyelīyalokā yūyaṁ kuto 'nenāścaryyaṁ manyadhve? āvāṁ nijaśaktyā yadvā nijapuṇyena khañjamanuṣyamenaṁ gamitavantāviti cintayitvā āvāṁ prati kuto'nanyadṛṣṭiṁ kurutha? ");
INSERT INTO sanias_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","yaṁ yīśuṁ yūyaṁ parakareṣu samārpayata tato yaṁ pīlāto mocayitum eैcchat tathāpi yūyaṁ tasya sākṣān nāṅgīkṛtavanta ibrāhīma ishāko yākūbaśceśvaro'rthād asmākaṁ pūrvvapuruṣāṇām īśvaraḥ svaputrasya tasya yīśo rmahimānaṁ prākāśayat| ");
INSERT INTO sanias_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","kintu yūyaṁ taṁ pavitraṁ dhārmmikaṁ pumāṁsaṁ nāṅgīkṛtya hatyākāriṇamekaṁ svebhyo dātum ayācadhvaṁ| ");
INSERT INTO sanias_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","paścāt taṁ jīvanasyādhipatim ahata kintvīśvaraḥ śmaśānāt tam udasthāpayata tatra vayaṁ sākṣiṇa āsmahe| ");
INSERT INTO sanias_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","imaṁ yaṁ mānuṣaṁ yūyaṁ paśyatha paricinutha ca sa tasya nāmni viśvāsakaraṇāt calanaśaktiṁ labdhavān tasmin tasya yo viśvāsaḥ sa taṁ yuṣmākaṁ sarvveṣāṁ sākṣāt sampūrṇarūpeṇa svastham akārṣīt| ");
INSERT INTO sanias_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","he bhrātaro yūyaṁ yuṣmākam adhipatayaśca ajñātvā karmmāṇyetāni kṛtavanta idānīṁ mamaiṣa bodho jāyate| ");
INSERT INTO sanias_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","kintvīśvaraḥ khrīṣṭasya duḥkhabhoge bhaviṣyadvādināṁ mukhebhyo yāṁ yāṁ kathāṁ pūrvvamakathayat tāḥ kathā itthaṁ siddhā akarot| ");
INSERT INTO sanias_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","ataḥ sveṣāṁ pāpamocanārthaṁ khedaṁ kṛtvā manāṁsi parivarttayadhvaṁ, tasmād īśvarāt sāntvanāprāpteḥ samaya upasthāsyati; ");
INSERT INTO sanias_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","punaśca pūrvvakālam ārabhya pracārito yo yīśukhrīṣṭastam īśvaro yuṣmān prati preṣayiṣyati| ");
INSERT INTO sanias_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","kintu jagataḥ sṛṣṭimārabhya īśvaro nijapavitrabhaviṣyadvādigaṇona yathā kathitavān tadanusāreṇa sarvveṣāṁ kāryyāṇāṁ siddhiparyyantaṁ tena svarge vāsaḥ karttavyaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","yuṣmākaṁ prabhuḥ parameśvaro yuṣmākaṁ bhrātṛgaṇamadhyāt matsadṛśaṁ bhaviṣyadvaktāram utpādayiṣyati, tataḥ sa yat kiñcit kathayiṣyati tatra yūyaṁ manāṁsi nidhaddhvaṁ| ");
INSERT INTO sanias_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","kintu yaḥ kaścit prāṇī tasya bhaviṣyadvādinaḥ kathāṁ na grahīṣyati sa nijalokānāṁ madhyād ucchetsyate,\" imāṁ kathām asmākaṁ pūrvvapuruṣebhyaḥ kevalo mūsāḥ kathayāmāsa iti nahi, ");
INSERT INTO sanias_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","śimūyelbhaviṣyadvādinam ārabhya yāvanto bhaviṣyadvākyam akathayan te sarvvaeva samayasyaitasya kathām akathayan| ");
INSERT INTO sanias_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","yūyamapi teṣāṁ bhaviṣyadvādināṁ santānāḥ, \"tava vaṁśodbhavapuṁsā sarvvadeśīyā lokā āśiṣaṁ prāptā bhaviṣyanti\", ibrāhīme kathāmetāṁ kathayitvā īśvarosmākaṁ pūrvvapuruṣaiḥ sārddhaṁ yaṁ niyamaṁ sthirīkṛtavān tasya niyamasyādhikāriṇopi yūyaṁ bhavatha| ");
INSERT INTO sanias_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ata īśvaro nijaputraṁ yīśum utthāpya yuṣmākaṁ sarvveṣāṁ svasvapāpāt parāvarttya yuṣmabhyam āśiṣaṁ dātuṁ prathamatastaṁ yuṣmākaṁ nikaṭaṁ preṣitavān| ");
INSERT INTO sanias_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","yasmin samaye pitarayohanau lokān upadiśatastasmin samaye yājakā mandirasya senāpatayaḥ sidūkīgaṇaśca ");
INSERT INTO sanias_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","tayor upadeśakaraṇe khrīṣṭasyotthānam upalakṣya sarvveṣāṁ mṛtānām utthānaprastāve ca vyagrāḥ santastāvupāgaman| ");
INSERT INTO sanias_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","tau dhṛtvā dināvasānakāraṇāt paradinaparyyanantaṁ ruddhvā sthāpitavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","tathāpi ye lokāstayorupadeśam aśṛṇvan teṣāṁ prāyeṇa pañcasahasrāṇi janā vyaśvasan| ");
INSERT INTO sanias_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","pare'hani adhipatayaḥ prācīnā adhyāpakāśca hānananāmā mahāyājakaḥ ");
INSERT INTO sanias_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","kiyaphā yohan sikandara ityādayo mahāyājakasya jñātayaḥ sarvve yirūśālamnagare militāḥ| ");
INSERT INTO sanias_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","anantaraṁ preritau madhye sthāpayitvāpṛcchan yuvāṁ kayā śaktayā vā kena nāmnā karmmāṇyetāni kuruthaḥ? ");
INSERT INTO sanias_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","tadā pitaraḥ pavitreṇātmanā paripūrṇaḥ san pratyavādīt, he lokānām adhipatigaṇa he isrāyelīyaprācīnāḥ, ");
INSERT INTO sanias_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","etasya durbbalamānuṣasya hitaṁ yat karmmākriyata, arthāt, sa yena prakāreṇa svasthobhavat tacced adyāvāṁ pṛcchatha, ");
INSERT INTO sanias_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","tarhi sarvva isrāyeेlīyalokā yūyaṁ jānīta nāsaratīyo yo yīśukhrīṣṭaḥ kruśe yuṣmābhiravidhyata yaśceśvareṇa śmaśānād utthāpitaḥ, tasya nāmnā janoyaṁ svasthaḥ san yuṣmākaṁ sammukhe prottiṣṭhati| ");
INSERT INTO sanias_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","nicetṛbhi ryuṣmābhirayaṁ yaḥ prastaro'vajñāto'bhavat sa pradhānakoṇasya prastaro'bhavat| ");
INSERT INTO sanias_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","tadbhinnādaparāt kasmādapi paritrāṇaṁ bhavituṁ na śaknoti, yena trāṇaṁ prāpyeta bhūmaṇḍalasyalokānāṁ madhye tādṛśaṁ kimapi nāma nāsti| ");
INSERT INTO sanias_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","tadā pitarayohanoretādṛśīm akṣebhatāṁ dṛṣṭvā tāvavidvāṁsau nīcalokāviti buddhvā āścaryyam amanyanta tau ca yīśoḥ saṅginau jātāviti jñātum aśaknuvan| ");
INSERT INTO sanias_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","kintu tābhyāṁ sārddhaṁ taṁ svasthamānuṣaṁ tiṣṭhantaṁ dṛṣṭvā te kāmapyaparām āpattiṁ karttaṁ nāśaknun| ");
INSERT INTO sanias_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","tadā te sabhātaḥ sthānāntaraṁ gantuṁ tān ājñāpya svayaṁ parasparam iti mantraṇāmakurvvan ");
INSERT INTO sanias_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","tau mānavau prati kiṁ karttavyaṁ? tāvekaṁ prasiddham āścaryyaṁ karmma kṛtavantau tad yirūśālamnivāsināṁ sarvveṣāṁ lokānāṁ samīpe prākāśata tacca vayamapahnotuṁ na śaknumaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","kintu lokānāṁ madhyam etad yathā na vyāpnoti tadarthaṁ tau bhayaṁ pradarśya tena nāmnā kamapi manuṣyaṁ nopadiśatam iti dṛḍhaṁ niṣedhāmaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","tataste preritāvāhūya etadājñāpayan itaḥ paraṁ yīśo rnāmnā kadāpi kāmapi kathāṁ mā kathayataṁ kimapi nopadiśañca| ");
INSERT INTO sanias_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","tataḥ pitarayohanau pratyavadatām īśvarasyājñāgrahaṇaṁ vā yuṣmākam ājñāgrahaṇam etayo rmadhye īśvarasya gocare kiṁ vihitaṁ? yūyaṁ tasya vivecanāṁ kuruta| ");
INSERT INTO sanias_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","vayaṁ yad apaśyāma yadaśṛṇuma ca tanna pracārayiṣyāma etat kadāpi bhavituṁ na śaknoti| ");
INSERT INTO sanias_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","yadaghaṭata tad dṛṣṭā sarvve lokā īśvarasya guṇān anvavadan tasmāt lokabhayāt tau daṇḍayituṁ kamapyupāyaṁ na prāpya te punarapi tarjayitvā tāvatyajan| ");
INSERT INTO sanias_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","yasya mānuṣasyaitat svāsthyakaraṇam āścaryyaṁ karmmākriyata tasya vayaścatvāriṁśadvatsarā vyatītāḥ| ");
INSERT INTO sanias_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","tataḥ paraṁ tau visṛṣṭau santau svasaṅgināṁ sannidhiṁ gatvā pradhānayājakaiḥ prācīnalokaiśca proktāḥ sarvvāḥ kathā jñāpitavantau| ");
INSERT INTO sanias_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","tacchrutvā sarvva ekacittībhūya īśvaramuddiśya proccairetat prārthayanta, he prabho gagaṇapṛthivīpayodhīnāṁ teṣu ca yadyad āste teṣāṁ sraṣṭeśvarastvaṁ| ");
INSERT INTO sanias_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","tvaṁ nijasevakena dāyūdā vākyamidam uvacitha, manuṣyā anyadeśīyāḥ kurvvanti kalahaṁ kutaḥ| lokāḥ sarvve kimarthaṁ vā cintāṁ kurvvanti niṣphalāṁ| ");
INSERT INTO sanias_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","parameśasya tenaivābhiṣiktasya janasya ca| viruddhamabhitiṣṭhanti pṛthivyāḥ patayaḥ kutaḥ|| ");
INSERT INTO sanias_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","phalatastava hastena mantraṇayā ca pūrvva yadyat sthirīkṛtaṁ tad yathā siddhaṁ bhavati tadarthaṁ tvaṁ yam athiṣiktavān sa eva pavitro yīśustasya prātikūlyena herod pantīyapīlāto ");
INSERT INTO sanias_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","'nyadeśīyalokā isrāyellokāśca sarvva ete sabhāyām atiṣṭhan| ");
INSERT INTO sanias_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","he parameśvara adhunā teṣāṁ tarjanaṁ garjanañca śṛṇu; ");
INSERT INTO sanias_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","tathā svāsthyakaraṇakarmmaṇā tava bāhubalaprakāśapūrvvakaṁ tava sevakān nirbhayena tava vākyaṁ pracārayituṁ tava pavitraputrasya yīśo rnāmnā āścaryyāṇyasambhavāni ca karmmāṇi karttuñcājñāpaya| ");
INSERT INTO sanias_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","itthaṁ prārthanayā yatra sthāne te sabhāyām āsan tat sthānaṁ prākampata; tataḥ sarvve pavitreṇātmanā paripūrṇāḥ santa īśvarasya kathām akṣobheṇa prācārayan| ");
INSERT INTO sanias_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","aparañca pratyayakārilokasamūhā ekamanasa ekacittībhūya sthitāḥ| teṣāṁ kepi nijasampattiṁ svīyāṁ nājānan kintu teṣāṁ sarvvāḥ sampattyaḥ sādhāraṇyena sthitāḥ| ");
INSERT INTO sanias_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","anyacca preritā mahāśaktiprakāśapūrvvakaṁ prabho ryīśorutthāne sākṣyam adaduḥ, teṣu sarvveṣu mahānugraho'bhavacca| ");
INSERT INTO sanias_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","teṣāṁ madhye kasyāpi dravyanyūnatā nābhavad yatasteṣāṁ gṛhabhūmyādyā yāḥ sampattaya āsan tā vikrīya ");
INSERT INTO sanias_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","tanmūlyamānīya preritānāṁ caraṇeṣu taiḥ sthāpitaṁ; tataḥ pratyekaśaḥ prayojanānusāreṇa dattamabhavat| ");
INSERT INTO sanias_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","viśeṣataḥ kupropadvīpīyo yosināmako levivaṁśajāta eko jano bhūmyadhikārī, yaṁ preritā barṇabbā arthāt sāntvanādāyaka ityuktvā samāhūyan, ");
INSERT INTO sanias_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","sa jano nijabhūmiṁ vikrīya tanmūlyamānīya preritānāṁ caraṇeṣu sthāpitavān| ");
INSERT INTO sanias_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","tadā anāniyanāmaka eko jano yasya bhāryyāyā nāma saphīrā sa svādhikāraṁ vikrīya ");
INSERT INTO sanias_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","svabhāryyāṁ jñāpayitvā tanmūlyasyaikāṁśaṁ saṅgopya sthāpayitvā tadanyāṁśamātramānīya preritānāṁ caraṇeṣu samarpitavān| ");
INSERT INTO sanias_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","tasmāt pitarokathayat he anāniya bhūme rmūlyaṁ kiñcit saṅgopya sthāpayituṁ pavitrasyātmanaḥ sannidhau mṛṣāvākyaṁ kathayituñca śaitān kutastavāntaḥkaraṇe pravṛttimajanayat? ");
INSERT INTO sanias_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","sā bhūmi ryadā tava hastagatā tadā kiṁ tava svīyā nāsīt? tarhi svāntaḥkaraṇe kuta etādṛśī kukalpanā tvayā kṛtā? tvaṁ kevalamanuṣyasya nikaṭe mṛṣāvākyaṁ nāvādīḥ kintvīśvarasya nikaṭe'pi| ");
INSERT INTO sanias_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","etāṁ kathāṁ śrutvaiva so'nāniyo bhūmau patan prāṇān atyajat, tadvṛttāntaṁ yāvanto lokā aśṛṇvan teṣāṁ sarvveṣāṁ mahābhayam ajāyat| ");
INSERT INTO sanias_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","tadā yuvalokāstaṁ vastreṇācchādya bahi rnītvā śmaśāne'sthāpayan| ");
INSERT INTO sanias_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","tataḥ praharaikānantaraṁ kiṁ vṛttaṁ tannāvagatya tasya bhāryyāpi tatra samupasthitā| ");
INSERT INTO sanias_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","tataḥ pitarastām apṛcchat, yuvābhyām etāvanmudrābhyo bhūmi rvikrītā na vā? etatvaṁ vada; tadā sā pratyavādīt satyam etāvadbhyo mudrābhya eva| ");
INSERT INTO sanias_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","tataḥ pitarokathayat yuvāṁ kathaṁ parameśvarasyātmānaṁ parīkṣitum ekamantraṇāvabhavatāṁ? paśya ye tava patiṁ śmaśāne sthāpitavantaste dvārasya samīpe samupatiṣṭhanti tvāmapi bahirneṣyanti| ");
INSERT INTO sanias_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","tataḥ sāpi tasya caraṇasannidhau patitvā prāṇān atyākṣīt| paścāt te yuvāno'bhyantaram āgatya tāmapi mṛtāṁ dṛṣṭvā bahi rnītvā tasyāḥ patyuḥ pārśve śmaśāne sthāpitavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","tasmāt maṇḍalyāḥ sarvve lokā anyalokāśca tāṁ vārttāṁ śrutvā sādhvasaṁ gatāḥ| ");
INSERT INTO sanias_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","tataḥ paraṁ preritānāṁ hastai rlokānāṁ madhye bahvāścaryyāṇyadbhutāni karmmāṇyakriyanta; tadā śiṣyāḥ sarvva ekacittībhūya sulemāno 'linde sambhūyāsan| ");
INSERT INTO sanias_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","teṣāṁ saṅghāntargo bhavituṁ kopi pragalbhatāṁ nāgamat kintu lokāstān samādriyanta| ");
INSERT INTO sanias_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","striyaḥ puruṣāśca bahavo lokā viśvāsya prabhuṁ śaraṇamāpannāḥ| ");
INSERT INTO sanias_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","pitarasya gamanāgamanābhyāṁ kenāpi prakāreṇa tasya chāyā kasmiṁścijjane lagiṣyatītyāśayā lokā rogiṇaḥ śivikayā khaṭvayā cānīya pathi pathi sthāpitavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","caturdiksthanagarebhyo bahavo lokāḥ sambhūya rogiṇo'pavitrabhutagrastāṁśca yirūśālamam ānayan tataḥ sarvve svasthā akriyanta| ");
INSERT INTO sanias_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","anantaraṁ mahāyājakaḥ sidūkināṁ matagrāhiṇasteṣāṁ sahacarāśca ");
INSERT INTO sanias_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","mahākrodhāntvitāḥ santaḥ preritān dhṛtvā nīcalokānāṁ kārāyāṁ baddhvā sthāpitavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","kintu rātrau parameśvarasya dūtaḥ kārāyā dvāraṁ mocayitvā tān bahirānīyākathayat, ");
INSERT INTO sanias_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","yūyaṁ gatvā mandire daṇḍāyamānāḥ santo lokān pratīmāṁ jīvanadāyikāṁ sarvvāṁ kathāṁ pracārayata| ");
INSERT INTO sanias_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","iti śrutvā te pratyūṣe mandira upasthāya upadiṣṭavantaḥ| tadā sahacaragaṇena sahito mahāyājaka āgatya mantrigaṇam isrāyelvaṁśasya sarvvān rājasabhāsadaḥ sabhāsthān kṛtvā kārāyāstān āpayituṁ padātigaṇaṁ preritavān| ");
INSERT INTO sanias_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","tataste gatvā kārāyāṁ tān aprāpya pratyāgatya iti vārttām avādiṣuḥ, ");
INSERT INTO sanias_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","vayaṁ tatra gatvā nirvvighnaṁ kārāyā dvāraṁ ruddhaṁ rakṣakāṁśca dvārasya bahirdaṇḍāyamānān adarśāma eva kintu dvāraṁ mocayitvā tanmadhye kamapi draṣṭuṁ na prāptāḥ| ");
INSERT INTO sanias_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","etāṁ kathāṁ śrutvā mahāyājako mandirasya senāpatiḥ pradhānayājakāśca, ita paraṁ kimaparaṁ bhaviṣyatīti cintayitvā sandigdhacittā abhavan| ");
INSERT INTO sanias_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","etasminneva samaye kaścit jana āgatya vārttāmetām avadat paśyata yūyaṁ yān mānavān kārāyām asthāpayata te mandire tiṣṭhanto lokān upadiśanti| ");
INSERT INTO sanias_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","tadā mandirasya senāpatiḥ padātayaśca tatra gatvā cellokāḥ pāṣāṇān nikṣipyāsmān mārayantīti bhiyā vinatyācāraṁ tān ānayan| ");
INSERT INTO sanias_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","te mahāsabhāyā madhye tān asthāpayan tataḥ paraṁ mahāyājakastān apṛcchat, ");
INSERT INTO sanias_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","anena nāmnā samupadeṣṭuṁ vayaṁ kiṁ dṛḍhaṁ na nyaṣedhāma? tathāpi paśyata yūyaṁ sveṣāṁ tenopadeśene yirūśālamaṁ paripūrṇaṁ kṛtvā tasya janasya raktapātajanitāparādham asmān pratyānetuṁ ceṣṭadhve| ");
INSERT INTO sanias_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","tataḥ pitaronyapreritāśca pratyavadan mānuṣasyājñāgrahaṇād īśvarasyājñāgrahaṇam asmākamucitam| ");
INSERT INTO sanias_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","yaṁ yīśuṁ yūyaṁ kruśe vedhitvāhata tam asmākaṁ paitṛka īśvara utthāpya ");
INSERT INTO sanias_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","isrāyelvaṁśānāṁ manaḥparivarttanaṁ pāpakṣamāñca karttuṁ rājānaṁ paritrātārañca kṛtvā svadakṣiṇapārśve tasyānnatim akarot| ");
INSERT INTO sanias_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","etasmin vayamapi sākṣiṇa āsmahe, tat kevalaṁ nahi, īśvara ājñāgrāhibhyo yaṁ pavitram ātmanaṁ dattavān sopi sākṣyasti| ");
INSERT INTO sanias_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","etadvākye śrute teṣāṁ hṛdayāni viddhānyabhavan tataste tān hantuṁ mantritavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","etasminneva samaye tatsabhāsthānāṁ sarvvalokānāṁ madhye sukhyāto gamilīyelnāmaka eko jano vyavasthāpakaḥ phirūśiloka utthāya preritān kṣaṇārthaṁ sthānāntaraṁ gantum ādiśya kathitavān, ");
INSERT INTO sanias_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","he isrāyelvaṁśīyāḥ sarvve yūyam etān mānuṣān prati yat karttum udyatāstasmin sāvadhānā bhavata| ");
INSERT INTO sanias_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","itaḥ pūrvvaṁ thūdānāmaiko jana upasthāya svaṁ kamapi mahāpuruṣam avadat, tataḥ prāyeṇa catuḥśatalokāstasya matagrāhiṇobhavan paścāt sa hatobhavat tasyājñāgrāhiṇo yāvanto lokāste sarvve virkīrṇāḥ santo 'kṛtakāryyā abhavan| ");
INSERT INTO sanias_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","tasmājjanāt paraṁ nāmalekhanasamaye gālīlīyayihūdānāmaiko jana upasthāya bahūllokān svamataṁ grāhītavān tataḥ sopi vyanaśyat tasyājñāgrāhiṇo yāvanto lokā āsan te sarvve vikīrṇā abhavan| ");
INSERT INTO sanias_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","adhunā vadāmi, yūyam etān manuṣyān prati kimapi na kṛtvā kṣāntā bhavata, yata eṣa saṅkalpa etat karmma ca yadi manuṣyādabhavat tarhi viphalaṁ bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","yadīśvarādabhavat tarhi yūyaṁ tasyānyathā karttuṁ na śakṣyatha, varam īśvararodhakā bhaviṣyatha| ");
INSERT INTO sanias_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","tadā tasya mantraṇāṁ svīkṛtya te preritān āhūya prahṛtya yīśo rnāmnā kāmapi kathāṁ kathayituṁ niṣidhya vyasarjan| ");
INSERT INTO sanias_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","kintu tasya nāmārthaṁ vayaṁ lajjābhogasya yogyatvena gaṇitā ityatra te sānandāḥ santaḥ sabhāsthānāṁ sākṣād agacchan| ");
INSERT INTO sanias_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","tataḥ paraṁ pratidinaṁ mandire gṛhe gṛhe cāviśrāmam upadiśya yīśukhrīṣṭasya susaṁvādaṁ pracāritavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","tasmin samaye śiṣyāṇāṁ bāhulyāt prātyahikadānasya viśrāṇanai rbhinnadeśīyānāṁ vidhavāstrīgaṇa upekṣite sati ibrīyalokaiḥ sahānyadeśīyānāṁ vivāda upātiṣṭhat| ");
INSERT INTO sanias_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","tadā dvādaśapreritāḥ sarvvān śiṣyān saṁgṛhyākathayan īśvarasya kathāpracāraṁ parityajya bhojanagaveṣaṇam asmākam ucitaṁ nahi| ");
INSERT INTO sanias_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ato he bhrātṛgaṇa vayam etatkarmmaṇo bhāraṁ yebhyo dātuṁ śaknuma etādṛśān sukhyātyāpannān pavitreṇātmanā jñānena ca pūrṇān sapprajanān yūyaṁ sveṣāṁ madhye manonītān kuruta, ");
INSERT INTO sanias_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","kintu vayaṁ prārthanāyāṁ kathāpracārakarmmaṇi ca nityapravṛttāḥ sthāsyāmaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","etasyāṁ kathāyāṁ sarvve lokāḥ santuṣṭāḥ santaḥ sveṣāṁ madhyāt stiphānaḥ philipaḥ prakharo nikānor tīman parmmiṇā yihūdimatagrāhī-āntiyakhiyānagarīyo nikalā etān paramabhaktān pavitreṇātmanā paripūrṇān sapta janān ");
INSERT INTO sanias_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","preritānāṁ samakṣam ānayan, tataste prārthanāṁ kṛtvā teṣāṁ śiraḥsu hastān ārpayan| ");
INSERT INTO sanias_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","aparañca īśvarasya kathā deśaṁ vyāpnot viśeṣato yirūśālami nagare śiṣyāṇāṁ saṁkhyā prabhūtarūpeṇāvarddhata yājakānāṁ madhyepi bahavaḥ khrīṣṭamatagrāhiṇo'bhavan| ");
INSERT INTO sanias_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","stiphānoे viśvāsena parākrameṇa ca paripūrṇaḥ san lokānāṁ madhye bahuvidham adbhutam āścaryyaṁ karmmākarot| ");
INSERT INTO sanias_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","tena libarttinīyanāmnā vikhyātasaṅghasya katipayajanāḥ kurīṇīyasikandarīya-kilikīyāśīyādeśīyāḥ kiyanto janāścotthāya stiphānena sārddhaṁ vyavadanta| ");
INSERT INTO sanias_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","kintu stiphāno jñānena pavitreṇātmanā ca īdṛśīṁ kathāṁ kathitavān yasyāste āpattiṁ karttuṁ nāśaknuvan| ");
INSERT INTO sanias_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","paścāt tai rlobhitāḥ katipayajanāḥ kathāmenām akathayan, vayaṁ tasya mukhato mūsā īśvarasya ca nindāvākyam aśrauṣma| ");
INSERT INTO sanias_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","te lokānāṁ lokaprācīnānām adhyāpakānāñca pravṛttiṁ janayitvā stiphānasya sannidhim āgatya taṁ dhṛtvā mahāsabhāmadhyam ānayan| ");
INSERT INTO sanias_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","tadanantaraṁ katipayajaneṣu mithyāsākṣiṣu samānīteṣu te'kathayan eṣa jana etatpuṇyasthānavyavasthayo rnindātaḥ kadāpi na nivarttate| ");
INSERT INTO sanias_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","phalato nāsaratīyayīśuḥ sthānametad ucchinnaṁ kariṣyati mūsāsamarpitam asmākaṁ vyavaharaṇam anyarūpaṁ kariṣyati tasyaitādṛśīṁ kathāṁ vayam aśṛṇuma| ");
INSERT INTO sanias_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","tadā mahāsabhāsthāḥ sarvve taṁ prati sthirāṁ dṛṣṭiṁ kṛtvā svargadūtamukhasadṛśaṁ tasya mukham apaśyan| ");
INSERT INTO sanias_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","tataḥ paraṁ mahāyājakaḥ pṛṣṭavān, eṣā kathāṁ kiṁ satyā? ");
INSERT INTO sanias_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","tataḥ sa pratyavadat, he pitaro he bhrātaraḥ sarvve lākā manāṁsi nidhaddhvaṁ|asmākaṁ pūrvvapuruṣa ibrāhīm hāraṇnagare vāsakaraṇāt pūrvvaṁ yadā arām-naharayimadeśe āsīt tadā tejomaya īśvaro darśanaṁ datvā ");
INSERT INTO sanias_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","tamavadat tvaṁ svadeśajñātimitrāṇi parityajya yaṁ deśamahaṁ darśayiṣyāmi taṁ deśaṁ vraja| ");
INSERT INTO sanias_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","ataḥ sa kasdīyadeśaṁ vihāya hāraṇnagare nyavasat, tadanantaraṁ tasya pitari mṛte yatra deśe yūyaṁ nivasatha sa enaṁ deśamāgacchat| ");
INSERT INTO sanias_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","kintvīśvarastasmai kamapyadhikāram arthād ekapadaparimitāṁ bhūmimapi nādadāt; tadā tasya kopi santāno nāsīt tathāpi santānaiḥ sārddham etasya deśasyādhikārī tvaṁ bhaviṣyasīti tampratyaṅgīkṛtavān| ");
INSERT INTO sanias_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","īśvara ittham aparamapi kathitavān tava santānāḥ paradeśe nivatsyanti tatastaddeśīyalokāścatuḥśatavatsarān yāvat tān dāsatve sthāpayitvā tān prati kuvyavahāraṁ kariṣyanti| ");
INSERT INTO sanias_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","aparam īśvara enāṁ kathāmapi kathitavān, ye lokāstān dāsatve sthāpayiṣyanti tāllokān ahaṁ daṇḍayiṣyāmi, tataḥ paraṁ te bahirgatāḥ santo mām atra sthāne seviṣyante| ");
INSERT INTO sanias_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","paścāt sa tasmai tvakchedasya niyamaṁ dattavān, ata ishākanāmni ibrāhīma ekaputre jāte, aṣṭamadine tasya tvakchedam akarot| tasya ishākaḥ putro yākūb, tatastasya yākūbo'smākaṁ dvādaśa pūrvvapuruṣā ajāyanta| ");
INSERT INTO sanias_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","te pūrvvapuruṣā īrṣyayā paripūrṇā misaradeśaṁ preṣayituṁ yūṣaphaṁ vyakrīṇan| ");
INSERT INTO sanias_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","kintvīśvarastasya sahāyo bhūtvā sarvvasyā durgate rakṣitvā tasmai buddhiṁ dattvā misaradeśasya rājñaḥ phirauṇaḥ priyapātraṁ kṛtavān tato rājā misaradeśasya svīyasarvvaparivārasya ca śāsanapadaṁ tasmai dattavān| ");
INSERT INTO sanias_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","tasmin samaye misara-kinānadeśayo rdurbhikṣahetoratikliṣṭatvāt naḥ pūrvvapuruṣā bhakṣyadravyaṁ nālabhanta| ");
INSERT INTO sanias_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","kintu misaradeśe śasyāni santi, yākūb imāṁ vārttāṁ śrutvā prathamam asmākaṁ pūrvvapuruṣān misaraṁ preṣitavān| ");
INSERT INTO sanias_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","tato dvitīyavāragamane yūṣaph svabhrātṛbhiḥ paricito'bhavat; yūṣapho bhrātaraḥ phirauṇ rājena paricitā abhavan| ");
INSERT INTO sanias_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","anantaraṁ yūṣaph bhrātṛgaṇaṁ preṣya nijapitaraṁ yākūbaṁ nijān pañcādhikasaptatisaṁkhyakān jñātijanāṁśca samāhūtavān| ");
INSERT INTO sanias_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","tasmād yākūb misaradeśaṁ gatvā svayam asmākaṁ pūrvvapuruṣāśca tasmin sthāne'mriyanta| ");
INSERT INTO sanias_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","tataste śikhimaṁ nītā yat śmaśānam ibrāhīm mudrādatvā śikhimaḥ pitu rhamoraḥ putrebhyaḥ krītavān tatśmaśāne sthāpayāñcakrire| ");
INSERT INTO sanias_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","tataḥ param īśvara ibrāhīmaḥ sannidhau śapathaṁ kṛtvā yāṁ pratijñāṁ kṛtavān tasyāḥ pratijñāyāḥ phalanasamaye nikaṭe sati isrāyellokā simaradeśe varddhamānā bahusaṁkhyā abhavan| ");
INSERT INTO sanias_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","śeṣe yūṣaphaṁ yo na paricinoti tādṛśa eko narapatirupasthāya ");
INSERT INTO sanias_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","asmākaṁ jñātibhiḥ sārddhaṁ dhūrttatāṁ vidhāya pūrvvapuruṣān prati kuvyavaharaṇapūrvvakaṁ teṣāṁ vaṁśanāśanāya teṣāṁ navajātān śiśūn bahi rnirakṣepayat| ");
INSERT INTO sanias_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","etasmin samaye mūsā jajñe, sa tu paramasundaro'bhavat tathā pitṛgṛhe māsatrayaparyyantaṁ pālito'bhavat| ");
INSERT INTO sanias_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","kintu tasmin bahirnikṣipte sati phirauṇarājasya kanyā tam uttolya nītvā dattakaputraṁ kṛtvā pālitavatī| ");
INSERT INTO sanias_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","tasmāt sa mūsā misaradeśīyāyāḥ sarvvavidyāyāḥ pāradṛṣvā san vākye kriyāyāñca śaktimān abhavat| ");
INSERT INTO sanias_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","sa sampūrṇacatvāriṁśadvatsaravayasko bhūtvā isrāyelīyavaṁśanijabhrātṛn sākṣāt kartuṁ matiṁ cakre| ");
INSERT INTO sanias_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","teṣāṁ janamekaṁ hiṁsitaṁ dṛṣṭvā tasya sapakṣaḥ san hiṁsitajanam upakṛtya misarīyajanaṁ jaghāna| ");
INSERT INTO sanias_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","tasya hasteneśvarastān uddhariṣyati tasya bhrātṛgaṇa iti jñāsyati sa ityanumānaṁ cakāra, kintu te na bubudhire| ");
INSERT INTO sanias_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","tatpare 'hani teṣām ubhayo rjanayo rvākkalaha upasthite sati mūsāḥ samīpaṁ gatvā tayo rmelanaṁ karttuṁ matiṁ kṛtvā kathayāmāsa, he mahāśayau yuvāṁ bhrātarau parasparam anyāyaṁ kutaḥ kuruthaḥ? ");
INSERT INTO sanias_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","tataḥ samīpavāsinaṁ prati yo jano'nyāyaṁ cakāra sa taṁ dūrīkṛtya kathayāmāsa, asmākamupari śāstṛtvavicārayitṛtvapadayoḥ kastvāṁ niyuktavān? ");
INSERT INTO sanias_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","hyo yathā misarīyaṁ hatavān tathā kiṁ māmapi haniṣyasi? ");
INSERT INTO sanias_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","tadā mūsā etādṛśīṁ kathāṁ śrutvā palāyanaṁ cakre, tato midiyanadeśaṁ gatvā pravāsī san tasthau, tatastatra dvau putrau jajñāte| ");
INSERT INTO sanias_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","anantaraṁ catvāriṁśadvatsareṣu gateṣu sīnayaparvvatasya prāntare prajvalitastambasya vahniśikhāyāṁ parameśvaradūtastasmai darśanaṁ dadau| ");
INSERT INTO sanias_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","mūsāstasmin darśane vismayaṁ matvā viśeṣaṁ jñātuṁ nikaṭaṁ gacchati, ");
INSERT INTO sanias_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","etasmin samaye, ahaṁ tava pūrvvapuruṣāṇām īśvaro'rthād ibrāhīma īśvara ishāka īśvaro yākūba īśvaraśca, mūsāmuddiśya parameśvarasyaitādṛśī vihāyasīyā vāṇī babhūva, tataḥ sa kampānvitaḥ san puna rnirīkṣituṁ pragalbho na babhūva| ");
INSERT INTO sanias_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","parameśvarastaṁ jagāda, tava pādayoḥ pāduke mocaya yatra tiṣṭhasi sā pavitrabhūmiḥ| ");
INSERT INTO sanias_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ahaṁ misaradeśasthānāṁ nijalokānāṁ durddaśāṁ nitāntam apaśyaṁ, teṣāṁ kātaryyoktiñca śrutavān tasmāt tān uddharttum avaruhyāgamam; idānīm āgaccha misaradeśaṁ tvāṁ preṣayāmi| ");
INSERT INTO sanias_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","kastvāṁ śāstṛtvavicārayitṛtvapadayo rniyuktavān, iti vākyamuktvā tai ryo mūsā avajñātastameva īśvaraḥ stambamadhye darśanadātrā tena dūtena śāstāraṁ muktidātārañca kṛtvā preṣayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","sa ca misaradeśe sūphnāmni samudre ca paścāt catvāriṁśadvatsarān yāvat mahāprāntare nānāprakārāṇyadbhutāni karmmāṇi lakṣaṇāni ca darśayitvā tān bahiḥ kṛtvā samānināya| ");
INSERT INTO sanias_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","prabhuḥ parameśvaro yuṣmākaṁ bhrātṛgaṇasya madhye mādṛśam ekaṁ bhaviṣyadvaktāram utpādayiṣyati tasya kathāyāṁ yūyaṁ mano nidhāsyatha, yo jana isrāyelaḥ santānebhya enāṁ kathāṁ kathayāmāsa sa eṣa mūsāḥ| ");
INSERT INTO sanias_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","mahāprāntarasthamaṇḍalīmadhye'pi sa eva sīnayaparvvatopari tena sārddhaṁ saṁlāpino dūtasya cāsmatpitṛgaṇasya madhyasthaḥ san asmabhyaṁ dātavyani jīvanadāyakāni vākyāni lebhe| ");
INSERT INTO sanias_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","asmākaṁ pūrvvapuruṣāstam amānyaṁ katvā svebhyo dūrīkṛtya misaradeśaṁ parāvṛtya gantuṁ manobhirabhilaṣya hāroṇaṁ jagaduḥ, ");
INSERT INTO sanias_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","asmākam agre'gre gantuुm asmadarthaṁ devagaṇaṁ nirmmāhi yato yo mūsā asmān misaradeśād bahiḥ kṛtvānītavān tasya kiṁ jātaṁ tadasmābhi rna jñāyate| ");
INSERT INTO sanias_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","tasmin samaye te govatsākṛtiṁ pratimāṁ nirmmāya tāmuddiśya naivedyamutmṛjya svahastakṛtavastunā ānanditavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","tasmād īśvarasteṣāṁ prati vimukhaḥ san ākāśasthaṁ jyotirgaṇaṁ pūjayituṁ tebhyo'numatiṁ dadau, yādṛśaṁ bhaviṣyadvādināṁ grantheṣu likhitamāste, yathā, isrāyelīyavaṁśā re catvāriṁśatsamān purā| mahati prāntare saṁsthā yūyantu yāni ca| balihomādikarmmāṇi kṛtavantastu tāni kiṁ| māṁ samuddiśya yuṣmābhiḥ prakṛtānīti naiva ca| ");
INSERT INTO sanias_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","kintu vo molakākhyasya devasya dūṣyameva ca| yuṣmākaṁ rimphanākhyāyā devatāyāśca tārakā| etayorubhayo rmūrtī yuṣmābhiḥ paripūjite| ato yuṣmāṁstu bābelaḥ pāraṁ neṣyāmi niścitaṁ| ");
INSERT INTO sanias_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","aparañca yannidarśanam apaśyastadanusāreṇa dūṣyaṁ nirmmāhi yasmin īśvaro mūsām etadvākyaṁ babhāṣe tat tasya nirūpitaṁ sākṣyasvarūpaṁ dūṣyam asmākaṁ pūrvvapuruṣaiḥ saha prāntare tasthau| ");
INSERT INTO sanias_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","paścāt yihośūyena sahitaisteṣāṁ vaṁśajātairasmatpūrvvapuruṣaiḥ sveṣāṁ sammukhād īśvareṇa dūrīkṛtānām anyadeśīyānāṁ deśādhikṛtikāle samānītaṁ tad dūṣyaṁ dāyūdodhikāraṁ yāvat tatra sthāna āsīt| ");
INSERT INTO sanias_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","sa dāyūd parameśvarasyānugrahaṁ prāpya yākūb īśvarārtham ekaṁ dūṣyaṁ nirmmātuṁ vavāñcha; ");
INSERT INTO sanias_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","kintu sulemān tadarthaṁ mandiram ekaṁ nirmmitavān| ");
INSERT INTO sanias_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","tathāpi yaḥ sarvvoparisthaḥ sa kasmiṁścid hastakṛte mandire nivasatīti nahi, bhaviṣyadvādī kathāmetāṁ kathayati, yathā, ");
INSERT INTO sanias_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","pareśo vadati svargo rājasiṁhāsanaṁ mama| madīyaṁ pādapīṭhañca pṛthivī bhavati dhruvaṁ| tarhi yūyaṁ kṛte me kiṁ pranirmmāsyatha mandiraṁ| viśrāmāya madīyaṁ vā sthānaṁ kiṁ vidyate tviha| ");
INSERT INTO sanias_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","sarvvāṇyetāni vastūni kiṁ me hastakṛtāni na|| ");
INSERT INTO sanias_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","he anājñāgrāhakā antaḥkaraṇe śravaṇe cāpavitralokāḥ yūyam anavarataṁ pavitrasyātmanaḥ prātikūlyam ācaratha, yuṣmākaṁ pūrvvapuruṣā yādṛśā yūyamapi tādṛśāḥ| ");
INSERT INTO sanias_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","yuṣmākaṁ pūrvvapuruṣāḥ kaṁ bhaviṣyadvādinaṁ nātāḍayan? ye tasya dhārmmikasya janasyāgamanakathāṁ kathitavantastān aghnan yūyam adhūnā viśvāsaghātino bhūtvā taṁ dhārmmikaṁ janam ahata| ");
INSERT INTO sanias_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","yūyaṁ svargīyadūtagaṇena vyavasthāṁ prāpyāpi tāṁ nācaratha| ");
INSERT INTO sanias_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","imāṁ kathāṁ śrutvā te manaḥsu biddhāḥ santastaṁ prati dantagharṣaṇam akurvvan| ");
INSERT INTO sanias_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","kintu stiphānaḥ pavitreṇātmanā pūrṇo bhūtvā gagaṇaṁ prati sthiradṛṣṭiṁ kṛtvā īśvarasya dakṣiṇe daṇḍāyamānaṁ yīśuñca vilokya kathitavān; ");
INSERT INTO sanias_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","paśya,meghadvāraṁ muktam īśvarasya dakṣiṇe sthitaṁ mānavasutañca paśyāmi| ");
INSERT INTO sanias_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","tadā te proccaiḥ śabdaṁ kṛtvā karṇeṣvaṅgulī rnidhāya ekacittībhūya tam ākraman| ");
INSERT INTO sanias_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","paścāt taṁ nagarād bahiḥ kṛtvā prastarairāghnan sākṣiṇo lākāḥ śaulanāmno yūnaścaraṇasannidhau nijavastrāṇi sthāpitavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","anantaraṁ he prabho yīśe madīyamātmānaṁ gṛhāṇa stiphānasyeti prārthanavākyavadanasamaye te taṁ prastarairāghnan| ");
INSERT INTO sanias_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","tasmāt sa jānunī pātayitvā proccaiḥ śabdaṁ kṛtvā, he prabhe pāpametad eteṣu mā sthāpaya, ityuktvā mahānidrāṁ prāpnot| ");
INSERT INTO sanias_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","tasya hatyākaraṇaṁ śaulopi samamanyata| tasmin samaye yirūśālamnagarasthāṁ maṇḍalīṁ prati mahātāḍanāyāṁ jātāyāṁ preritalokān hitvā sarvve'pare yihūdāśomiroṇadeśayo rnānāsthāne vikīrṇāḥ santo gatāḥ| ");
INSERT INTO sanias_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","anyacca bhaktalokāstaṁ stiphānaṁ śmaśāne sthāpayitvā bahu vyalapan| ");
INSERT INTO sanias_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","kintu śaulo gṛhe gṛhe bhramitvā striyaḥ puruṣāṁśca dhṛtvā kārāyāṁ baddhvā maṇḍalyā mahotpātaṁ kṛtavān| ");
INSERT INTO sanias_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","anyacca ye vikīrṇā abhavan te sarvvatra bhramitvā susaṁvādaṁ prācārayan| ");
INSERT INTO sanias_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","tadā philipaḥ śomiroṇnagaraṁ gatvā khrīṣṭākhyānaṁ prācārayat; ");
INSERT INTO sanias_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","tato'śuci-bhṛtagrastalokebhyo bhūtāścītkṛtyāgacchan tathā bahavaḥ pakṣāghātinaḥ khañjā lokāśca svasthā abhavan| ");
INSERT INTO sanias_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","tasmāt lākā īdṛśaṁ tasyāścaryyaṁ karmma vilokya niśamya ca sarvva ekacittībhūya tenoktākhyāne manāṁsi nyadadhuḥ| ");
INSERT INTO sanias_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","tasminnagare mahānandaścābhavat| ");
INSERT INTO sanias_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","tataḥ pūrvvaṁ tasminnagare śimonnāmā kaścijjano bahvī rmāyākriyāḥ kṛtvā svaṁ kañcana mahāpuruṣaṁ procya śomiroṇīyānāṁ mohaṁ janayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","tasmāt sa mānuṣa īśvarasya mahāśaktisvarūpa ityuktvā bālavṛddhavanitāḥ sarvve lākāstasmin manāṁsi nyadadhuḥ| ");
INSERT INTO sanias_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","sa bahukālān māyāvikriyayā sarvvān atīva mohayāñcakāra, tasmāt te taṁ menire| ");
INSERT INTO sanias_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","kintvīśvarasya rājyasya yīśukhrīṣṭasya nāmnaścākhyānapracāriṇaḥ philipasya kathāyāṁ viśvasya teṣāṁ strīpuruṣobhayalokā majjitā abhavan| ");
INSERT INTO sanias_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","śeṣe sa śimonapi svayaṁ pratyait tato majjitaḥ san philipena kṛtām āścaryyakriyāṁ lakṣaṇañca vilokyāsambhavaṁ manyamānastena saha sthitavān| ");
INSERT INTO sanias_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","itthaṁ śomiroṇdeśīyalokā īśvarasya kathām agṛhlan iti vārttāṁ yirūśālamnagarasthapreritāḥ prāpya pitaraṁ yohanañca teṣāṁ nikaṭe preṣitavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","tatastau tat sthānam upasthāya lokā yathā pavitram ātmānaṁ prāpnuvanti tadarthaṁ prārthayetāṁ| ");
INSERT INTO sanias_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","yataste purā kevalaprabhuyīśo rnāmnā majjitamātrā abhavan, na tu teṣāṁ madhye kamapi prati pavitrasyātmana āvirbhāvo jātaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","kintu preritābhyāṁ teṣāṁ gātreṣu kareṣvarpiteṣu satsu te pavitram ātmānam prāpnuvan| ");
INSERT INTO sanias_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","itthaṁ lokānāṁ gātreṣu preritayoḥ karārpaṇena tān pavitram ātmānaṁ prāptān dṛṣṭvā sa śimon tayoḥ samīpe mudrā ānīya kathitavān; ");
INSERT INTO sanias_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ahaṁ yasya gātre hastam arpayiṣyāmi tasyāpi yathetthaṁ pavitrātmaprāpti rbhavati tādṛśīṁ śaktiṁ mahyaṁ dattaṁ| ");
INSERT INTO sanias_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","kintu pitarastaṁ pratyavadat tava mudrāstvayā vinaśyantu yata īśvarasya dānaṁ mudrābhiḥ krīyate tvamitthaṁ buddhavān; ");
INSERT INTO sanias_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","īśvarāya tāvantaḥkaraṇaṁ saralaṁ nahi, tasmād atra tavāṁśo'dhikāraśca kopi nāsti| ");
INSERT INTO sanias_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ata etatpāpahetoḥ khedānvitaḥ san kenāpi prakāreṇa tava manasa etasyāḥ kukalpanāyāḥ kṣamā bhavati, etadartham īśvare prārthanāṁ kuru; ");
INSERT INTO sanias_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","yatastvaṁ tiktapitte pāpasya bandhane ca yadasi tanmayā buddham| ");
INSERT INTO sanias_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","tadā śimon akathayat tarhi yuvābhyāmuditā kathā mayi yathā na phalati tadarthaṁ yuvāṁ mannimittaṁ prabhau prārthanāṁ kurutaṁ| ");
INSERT INTO sanias_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","anena prakāreṇa tau sākṣyaṁ dattvā prabhoḥ kathāṁ pracārayantau śomiroṇīyānām anekagrāmeṣu susaṁvādañca pracārayantau yirūśālamnagaraṁ parāvṛtya gatau| ");
INSERT INTO sanias_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","tataḥ param īśvarasya dūtaḥ philipam ityādiśat, tvamutthāya dakṣiṇasyāṁ diśi yo mārgo prāntarasya madhyena yirūśālamo 'sānagaraṁ yāti taṁ mārgaṁ gaccha| ");
INSERT INTO sanias_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","tataḥ sa utthāya gatavān; tadā kandākīnāmnaḥ kūślokānāṁ rājñyāḥ sarvvasampatteradhīśaḥ kūśadeśīya ekaḥ ṣaṇḍo bhajanārthaṁ yirūśālamnagaram āgatya ");
INSERT INTO sanias_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","punarapi rathamāruhya yiśayiyanāmno bhaviṣyadvādino granthaṁ paṭhan pratyāgacchati| ");
INSERT INTO sanias_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","etasmin samaye ātmā philipam avadat, tvam rathasya samīpaṁ gatvā tena sārddhaṁ mila| ");
INSERT INTO sanias_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","tasmāt sa dhāvan tasya sannidhāvupasthāya tena paṭhyamānaṁ yiśayiyathaviṣyadvādino vākyaṁ śrutvā pṛṣṭavān yat paṭhasi tat kiṁ budhyase? ");
INSERT INTO sanias_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","tataḥ sa kathitavān kenacinna bodhitohaṁ kathaṁ budhyeya? tataḥ sa philipaṁ rathamāroḍhuṁ svena sārddham upaveṣṭuñca nyavedayat| ");
INSERT INTO sanias_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","sa śāstrasyetadvākyaṁ paṭhitavān yathā, samānīyata ghātāya sa yathā meṣaśāvakaḥ| lomacchedakasākṣācca meṣaśca nīravo yathā| ābadhya vadanaṁ svīyaṁ tathā sa samatiṣṭhata| ");
INSERT INTO sanias_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","anyāyena vicāreṇa sa ucchinno 'bhavat tadā| tatkālīnamanuṣyān ko jano varṇayituṁ kṣamaḥ| yato jīvannṛṇāṁ deśāt sa ucchinno 'bhavat dhruvaṁ| ");
INSERT INTO sanias_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","anantaraṁ sa philipam avadat nivedayāmi, bhaviṣyadvādī yāmimāṁ kathāṁ kathayāmāsa sa kiṁ svasmin vā kasmiṁścid anyasmin? ");
INSERT INTO sanias_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","tataḥ philipastatprakaraṇam ārabhya yīśorupākhyānaṁ tasyāgre prāstaut| ");
INSERT INTO sanias_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","itthaṁ mārgeṇa gacchantau jalāśayasya samīpa upasthitau; tadā klībo'vādīt paśyātra sthāne jalamāste mama majjane kā bādhā? ");
INSERT INTO sanias_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","tataḥ philipa uttaraṁ vyāharat svāntaḥkaraṇena sākaṁ yadi pratyeṣi tarhi bādhā nāsti| tataḥ sa kathitavān yīśukhrīṣṭa īśvarasya putra ityahaṁ pratyemi| ");
INSERT INTO sanias_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","tadā rathaṁ sthagitaṁ karttum ādiṣṭe philipaklībau dvau jalam avāruhatāṁ; tadā philipastam majjayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","tatpaścāt jalamadhyād utthitayoḥ satoḥ parameśvarasyātmā philipaṁ hṛtvā nītavān, tasmāt klībaḥ punastaṁ na dṛṣṭavān tathāpi hṛṣṭacittaḥ san svamārgeṇa gatavān| ");
INSERT INTO sanias_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","philipaścāsdodnagaram upasthāya tasmāt kaisariyānagara upasthitikālaparyyanataṁ sarvvasminnagare susaṁvādaṁ pracārayan gatavān| ");
INSERT INTO sanias_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","tatkālaparyyanataṁ śaulaḥ prabhoḥ śiṣyāṇāṁ prātikūlyena tāḍanābadhayoḥ kathāṁ niḥsārayan mahāyājakasya sannidhiṁ gatvā ");
INSERT INTO sanias_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","striyaṁ puruṣañca tanmatagrāhiṇaṁ yaṁ kañcit paśyati tān dhṛtvā baddhvā yirūśālamam ānayatītyāśayena dammeṣaknagarīyaṁ dharmmasamājān prati patraṁ yācitavān| ");
INSERT INTO sanias_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","gacchan tu dammeṣaknagaranikaṭa upasthitavān; tato'kasmād ākāśāt tasya caturdikṣu tejasaḥ prakāśanāt sa bhūmāvapatat| ");
INSERT INTO sanias_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","paścāt he śaula he śaula kuto māṁ tāḍayasi? svaṁ prati proktam etaṁ śabdaṁ śrutvā ");
INSERT INTO sanias_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","sa pṛṣṭavān, he prabho bhavān kaḥ? tadā prabhurakathayat yaṁ yīśuṁ tvaṁ tāḍayasi sa evāhaṁ; kaṇṭakasya mukhe padāghātakaraṇaṁ tava kaṣṭam| ");
INSERT INTO sanias_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","tadā kampamāno vismayāpannaśca sovadat he prabho mayā kiṁ karttavyaṁ? bhavata icchā kā? tataḥ prabhurājñāpayad utthāya nagaraṁ gaccha tatra tvayā yat karttavyaṁ tad vadiṣyate| ");
INSERT INTO sanias_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","tasya saṅgino lokā api taṁ śabdaṁ śrutavantaḥ kintu kamapi na dṛṣṭvā stabdhāḥ santaḥ sthitavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","anantaraṁ śaulo bhūmita utthāya cakṣuṣī unmīlya kamapi na dṛṣṭavān| tadā lokāstasya hastau dhṛtvā dammeṣaknagaram ānayan| ");
INSERT INTO sanias_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","tataḥ sa dinatrayaṁ yāvad andho bhūtvā na bhuktavān pītavāṁśca| ");
INSERT INTO sanias_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","tadanantaraṁ prabhustaddammeṣaknagaravāsina ekasmai śiṣyāya darśanaṁ datvā āhūtavān he ananiya| tataḥ sa pratyavādīt, he prabho paśya śṛṇomi| ");
INSERT INTO sanias_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","tadā prabhustamājñāpayat tvamutthāya saralanāmānaṁ mārgaṁ gatvā yihūdāniveśane tārṣanagarīyaṁ śaulanāmānaṁ janaṁ gaveṣayan pṛccha; ");
INSERT INTO sanias_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","paśya sa prārthayate, tathā ananiyanāmaka eko janastasya samīpam āgatya tasya gātre hastārpaṇaṁ kṛtvā dṛṣṭiṁ dadātītthaṁ svapne dṛṣṭavān| ");
INSERT INTO sanias_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","tasmād ananiyaḥ pratyavadat he prabho yirūśālami pavitralokān prati so'nekahiṁsāṁ kṛtavān; ");
INSERT INTO sanias_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","atra sthāne ca ye lokāstava nāmni prārthayanti tānapi baddhuṁ sa pradhānayājakebhyaḥ śaktiṁ prāptavān, imāṁ kathām aham anekeṣāṁ mukhebhyaḥ śrutavān| ");
INSERT INTO sanias_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","kintu prabhurakathayat, yāhi bhinnadeśīyalokānāṁ bhūpatīnām isrāyellokānāñca nikaṭe mama nāma pracārayituṁ sa jano mama manonītapātramāste| ");
INSERT INTO sanias_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","mama nāmanimittañca tena kiyān mahān kleśo bhoktavya etat taṁ darśayiṣyāmi| ");
INSERT INTO sanias_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","tato 'naniyo gatvā gṛhaṁ praviśya tasya gātre hastārpraṇaṁ kṛtvā kathitavān, he bhrātaḥ śaula tvaṁ yathā dṛṣṭiṁ prāpnoṣi pavitreṇātmanā paripūrṇo bhavasi ca, tadarthaṁ tavāgamanakāle yaḥ prabhuyīśustubhyaṁ darśanam adadāt sa māṁ preṣitavān| ");
INSERT INTO sanias_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ityuktamātre tasya cakṣurbhyām mīnaśalkavad vastuni nirgate tatkṣaṇāt sa prasannacakṣu rbhūtvā protthāya majjito'bhavat bhuktvā pītvā sabalobhavacca| ");
INSERT INTO sanias_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","tataḥ paraṁ śaulaḥ śiṣyaiḥ saha katipayadivasān tasmin dammeṣakanagare sthitvā'vilambaṁ ");
INSERT INTO sanias_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","sarvvabhajanabhavanāni gatvā yīśurīśvarasya putra imāṁ kathāṁ prācārayat| ");
INSERT INTO sanias_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","tasmāt sarvve śrotāraścamatkṛtya kathitavanto yo yirūśālamnagara etannāmnā prārthayitṛlokān vināśitavān evam etādṛśalokān baddhvā pradhānayājakanikaṭaṁ nayatītyāśayā etatsthānamapyāgacchat saeva kimayaṁ na bhavati? ");
INSERT INTO sanias_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","kintu śaulaḥ kramaśa utsāhavān bhūtvā yīśurīśvareṇābhiṣikto jana etasmin pramāṇaṁ datvā dammeṣak-nivāsiyihūdīyalokān niruttarān akarot| ");
INSERT INTO sanias_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","itthaṁ bahutithe kāle gate yihūdīyalokāstaṁ hantuṁ mantrayāmāsuḥ ");
INSERT INTO sanias_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","kintu śaulasteṣāmetasyā mantraṇāyā vārttāṁ prāptavān| te taṁ hantuṁ tu divāniśaṁ guptāḥ santo nagarasya dvāre'tiṣṭhan; ");
INSERT INTO sanias_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","tasmāt śiṣyāstaṁ nītvā rātrau piṭake nidhāya prācīreṇāvārohayan| ");
INSERT INTO sanias_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","tataḥ paraṁ śaulo yirūśālamaṁ gatvā śiṣyagaṇena sārddhaṁ sthātum aihat, kintu sarvve tasmādabibhayuḥ sa śiṣya iti ca na pratyayan| ");
INSERT INTO sanias_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","etasmād barṇabbāstaṁ gṛhītvā preritānāṁ samīpamānīya mārgamadhye prabhuḥ kathaṁ tasmai darśanaṁ dattavān yāḥ kathāśca kathitavān sa ca yathākṣobhaḥ san dammeṣaknagare yīśo rnāma prācārayat etān sarvvavṛttāntān tān jñāpitavān| ");
INSERT INTO sanias_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","tataḥ śaulastaiḥ saha yirūśālami kālaṁ yāpayan nirbhayaṁ prabho ryīśo rnāma prācārayat| ");
INSERT INTO sanias_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","tasmād anyadeśīyalokaiḥ sārddhaṁ vivādasyopasthitatvāt te taṁ hantum aceṣṭanta| ");
INSERT INTO sanias_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","kintu bhrātṛgaṇastajjñātvā taṁ kaisariyānagaraṁ nītvā tārṣanagaraṁ preṣitavān| ");
INSERT INTO sanias_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","itthaṁ sati yihūdiyāgālīlśomiroṇadeśīyāḥ sarvvā maṇḍalyo viśrāmaṁ prāptāstatastāsāṁ niṣṭhābhavat prabho rbhiyā pavitrasyātmanaḥ sāntvanayā ca kālaṁ kṣepayitvā bahusaṁkhyā abhavan| ");
INSERT INTO sanias_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","tataḥ paraṁ pitaraḥ sthāne sthāne bhramitvā śeṣe lodnagaranivāsipavitralokānāṁ samīpe sthitavān| ");
INSERT INTO sanias_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","tadā tatra pakṣāghātavyādhināṣṭau vatsarān śayyāgatam aineyanāmānaṁ manuṣyaṁ sākṣat prāpya tamavadat, ");
INSERT INTO sanias_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","he aineya yīśukhrīṣṭastvāṁ svastham akārṣīt, tvamutthāya svaśayyāṁ nikṣipa, ityuktamātre sa udatiṣṭhat| ");
INSERT INTO sanias_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","etādṛśaṁ dṛṣṭvā lodśāroṇanivāsino lokāḥ prabhuṁ prati parāvarttanta| ");
INSERT INTO sanias_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","aparañca bhikṣādānādiṣu nānakriyāsu nityaṁ pravṛttā yā yāphonagaranivāsinī ṭābithānāmā śiṣyā yāṁ darkkāṁ arthād hariṇīmayuktvā āhvayan sā nārī ");
INSERT INTO sanias_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","tasmin samaye rugnā satī prāṇān atyajat, tato lokāstāṁ prakṣālyoparisthaprakoṣṭhe śāyayitvāsthāpayan| ");
INSERT INTO sanias_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","lodnagaraṁ yāphonagarasya samīpasthaṁ tasmāttatra pitara āste, iti vārttāṁ śrutvā tūrṇaṁ tasyāgamanārthaṁ tasmin vinayamuktvā śiṣyagaṇo dvau manujau preṣitavān| ");
INSERT INTO sanias_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","tasmāt pitara utthāya tābhyāṁ sārddham āgacchat, tatra tasmin upasthita uparisthaprakoṣṭhaṁ samānīte ca vidhavāḥ svābhiḥ saha sthitikāle darkkayā kṛtāni yānyuttarīyāṇi paridheyāni ca tāni sarvvāṇi taṁ darśayitvā rudatyaścatasṛṣu dikṣvatiṣṭhan| ");
INSERT INTO sanias_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","kintu pitarastāḥ sarvvā bahiḥ kṛtvā jānunī pātayitvā prārthitavān; paścāt śavaṁ prati dṛṣṭiṁ kṛtvā kathitavān, he ṭābīthe tvamuttiṣṭha, iti vākya ukte sā strī cakṣuṣī pronmīlya pitaram avalokyotthāyopāviśat| ");
INSERT INTO sanias_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","tataḥ pitarastasyāḥ karau dhṛtvā uttolya pavitralokān vidhavāścāhūya teṣāṁ nikaṭe sajīvāṁ tāṁ samārpayat| ");
INSERT INTO sanias_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","eṣā kathā samastayāphonagaraṁ vyāptā tasmād aneke lokāḥ prabhau vyaśvasan| ");
INSERT INTO sanias_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","aparañca pitarastadyāphonagarīyasya kasyacit śimonnāmnaścarmmakārasya gṛhe bahudināni nyavasat| ");
INSERT INTO sanias_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","kaisariyānagara itāliyākhyasainyāntargataḥ karṇīliyanāmā senāpatirāsīt ");
INSERT INTO sanias_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","sa saparivāro bhakta īśvaraparāyaṇaścāsīt; lokebhyo bahūni dānādīni datvā nirantaram īśvare prārthayāñcakre| ");
INSERT INTO sanias_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ekadā tṛtīyapraharavelāyāṁ sa dṛṣṭavān īśvarasyaiko dūtaḥ saprakāśaṁ tatsamīpam āgatya kathitavān, he karṇīliya| ");
INSERT INTO sanias_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","kintu sa taṁ dṛṣṭvā bhīto'kathayat, he prabho kiṁ? tadā tamavadat tava prārthanā dānādi ca sākṣisvarūpaṁ bhūtveśvarasya gocaramabhavat| ");
INSERT INTO sanias_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","idānīṁ yāphonagaraṁ prati lokān preṣya samudratīre śimonnāmnaścarmmakārasya gṛhe pravāsakārī pitaranāmnā vikhyāto yaḥ śimon tam āhvāyaya; ");
INSERT INTO sanias_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","tasmāt tvayā yadyat karttavyaṁ tattat sa vadiṣyati| ");
INSERT INTO sanias_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ityupadiśya dūte prasthite sati karṇīliyaḥ svagṛhasthānāṁ dāsānāṁ dvau janau nityaṁ svasaṅgināṁ sainyānām ekāṁ bhaktasenāñcāhūya ");
INSERT INTO sanias_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","sakalametaṁ vṛttāntaṁ vijñāpya yāphonagaraṁ tān prāhiṇot| ");
INSERT INTO sanias_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","parasmin dine te yātrāṁ kṛtvā yadā nagarasya samīpa upātiṣṭhan, tadā pitaro dvitīyapraharavelāyāṁ prārthayituṁ gṛhapṛṣṭham ārohat| ");
INSERT INTO sanias_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","etasmin samaye kṣudhārttaḥ san kiñcid bhoktum aicchat kintu teṣām annāsādanasamaye sa mūrcchitaḥ sannapatat| ");
INSERT INTO sanias_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","tato meghadvāraṁ muktaṁ caturbhiḥ koṇai rlambitaṁ bṛhadvastramiva kiñcana bhājanam ākāśāt pṛthivīm avārohatīti dṛṣṭavān| ");
INSERT INTO sanias_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","tanmadhye nānaprakārā grāmyavanyapaśavaḥ khecarorogāmiprabhṛtayo jantavaścāsan| ");
INSERT INTO sanias_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","anantaraṁ he pitara utthāya hatvā bhuṁkṣva tampratīyaṁ gagaṇīyā vāṇī jātā| ");
INSERT INTO sanias_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","tadā pitaraḥ pratyavadat, he prabho īdṛśaṁ mā bhavatu, aham etat kālaṁ yāvat niṣiddham aśuci vā dravyaṁ kiñcidapi na bhuktavān| ");
INSERT INTO sanias_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","tataḥ punarapi tādṛśī vihayasīyā vāṇī jātā yad īśvaraḥ śuci kṛtavān tat tvaṁ niṣiddhaṁ na jānīhi| ");
INSERT INTO sanias_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","itthaṁ triḥ sati tat pātraṁ punarākṛṣṭaṁ ākāśam agacchat| ");
INSERT INTO sanias_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","tataḥ paraṁ yad darśanaṁ prāptavān tasya ko bhāva ityatra pitaro manasā sandegdhi, etasmin samaye karṇīliyasya te preṣitā manuṣyā dvārasya sannidhāvupasthāya, ");
INSERT INTO sanias_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","śimono gṛhamanvicchantaḥ sampṛchyāhūya kathitavantaḥ pitaranāmnā vikhyāto yaḥ śimon sa kimatra pravasati? ");
INSERT INTO sanias_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","yadā pitarastaddarśanasya bhāvaṁ manasāndolayati tadātmā tamavadat, paśya trayo janāstvāṁ mṛgayante| ");
INSERT INTO sanias_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","tvam utthāyāvaruhya niḥsandehaṁ taiḥ saha gaccha mayaiva te preṣitāḥ| ");
INSERT INTO sanias_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","tasmāt pitaro'varuhya karṇīliyapreritalokānāṁ nikaṭamāgatya kathitavān paśyata yūyaṁ yaṁ mṛgayadhve sa janohaṁ, yūyaṁ kinnimittam āgatāḥ? ");
INSERT INTO sanias_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","tataste pratyavadan karṇīliyanāmā śuddhasattva īśvaraparāyaṇo yihūdīyadeśasthānāṁ sarvveṣāṁ sannidhau sukhyātyāpanna ekaḥ senāpati rnijagṛhaṁ tvāmāhūya netuṁ tvattaḥ kathā śrotuñca pavitradūtena samādiṣṭaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","tadā pitarastānabhyantaraṁ nītvā teṣāmātithyaṁ kṛtavān, pare'hani taiḥ sārddhaṁ yātrāmakarot, yāphonivāsināṁ bhrātṛṇāṁ kiyanto janāśca tena saha gatāḥ| ");
INSERT INTO sanias_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","parasmin divase kaisariyānagaramadhyapraveśasamaye karṇīliyo jñātibandhūn āhūyānīya tān apekṣya sthitaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","pitare gṛha upasthite karṇīliyastaṁ sākṣātkṛtya caraṇayoḥ patitvā prāṇamat| ");
INSERT INTO sanias_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","pitarastamutthāpya kathitavān, uttiṣṭhāhamapi mānuṣaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","tadā karṇīliyena sākam ālapan gṛhaṁ prāviśat tanmadhye ca bahulokānāṁ samāgamaṁ dṛṣṭvā tān avadat, ");
INSERT INTO sanias_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","anyajātīyalokaiḥ mahālapanaṁ vā teṣāṁ gṛhamadhye praveśanaṁ yihūdīyānāṁ niṣiddham astīti yūyam avagacchatha; kintu kamapi mānuṣam avyavahāryyam aśuciṁ vā jñātuṁ mama nocitam iti parameśvaro māṁ jñāpitavān| ");
INSERT INTO sanias_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","iti hetorāhvānaśravaṇamātrāt kāñcanāpattim akṛtvā yuṣmākaṁ samīpam āgatosmi; pṛcchāmi yūyaṁ kinnimittaṁ mām āhūyata? ");
INSERT INTO sanias_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","tadā karṇīliyaḥ kathitavān, adya catvāri dināni jātāni etāvadvelāṁ yāvad aham anāhāra āsan tatastṛtīyaprahare sati gṛhe prārthanasamaye tejomayavastrabhṛd eko jano mama samakṣaṁ tiṣṭhan etāṁ kathām akathayat, ");
INSERT INTO sanias_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","he karṇīliya tvadīyā prārthanā īśvarasya karṇagocarībhūtā tava dānādi ca sākṣisvarūpaṁ bhūtvā tasya dṛṣṭigocaramabhavat| ");
INSERT INTO sanias_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ato yāphonagaraṁ prati lokān prahitya tatra samudratīre śimonnāmnaḥ kasyaciccarmmakārasya gṛhe pravāsakārī pitaranāmnā vikhyāto yaḥ śimon tamāhūाyaya; tataḥ sa āgatya tvām upadekṣyati| ");
INSERT INTO sanias_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","iti kāraṇāt tatkṣaṇāt tava nikaṭe lokān preṣitavān, tvamāgatavān iti bhadraṁ kṛtavān| īśvaro yānyākhyānāni kathayitum ādiśat tāni śrotuṁ vayaṁ sarvve sāmpratam īśvarasya sākṣād upasthitāḥ smaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","tadā pitara imāṁ kathāṁ kathayitum ārabdhavān, īśvaro manuṣyāṇām apakṣapātī san ");
INSERT INTO sanias_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","yasya kasyacid deśasya yo lokāstasmādbhītvā satkarmma karoti sa tasya grāhyo bhavati, etasya niścayam upalabdhavānaham| ");
INSERT INTO sanias_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","sarvveṣāṁ prabhu ryo yīśukhrīṣṭastena īśvara isrāyelvaṁśānāṁ nikaṭe susaṁvādaṁ preṣya sammelanasya yaṁ saṁvādaṁ prācārayat taṁ saṁvādaṁ yūyaṁ śrutavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","yato yohanā majjane pracārite sati sa gālīladeśamārabhya samastayihūdīyadeśaṁ vyāpnot; ");
INSERT INTO sanias_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","phalata īśvareṇa pavitreṇātmanā śaktyā cābhiṣikto nāsaratīyayīśuḥ sthāne sthāne bhraman sukriyāṁ kurvvan śaitānā kliṣṭān sarvvalokān svasthān akarot, yata īśvarastasya sahāya āsīt; ");
INSERT INTO sanias_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","vayañca yihūdīyadeśe yirūśālamnagare ca tena kṛtānāṁ sarvveṣāṁ karmmaṇāṁ sākṣiṇo bhavāmaḥ| lokāstaṁ kruśe viddhvā hatavantaḥ, ");
INSERT INTO sanias_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","kintu tṛtīyadivase īśvarastamutthāpya saprakāśam adarśayat| ");
INSERT INTO sanias_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","sarvvalokānāṁ nikaṭa iti na hi, kintu tasmin śmaśānādutthite sati tena sārddhaṁ bhojanaṁ pānañca kṛtavanta etādṛśā īśvarasya manonītāḥ sākṣiṇo ye vayam asmākaṁ nikaṭe tamadarśayat| ");
INSERT INTO sanias_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","jīvitamṛtobhayalokānāṁ vicāraṁ karttum īśvaro yaṁ niyuktavān sa eva sa janaḥ, imāṁ kathāṁ pracārayituṁ tasmin pramāṇaṁ dātuñca so'smān ājñāpayat| ");
INSERT INTO sanias_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","yastasmin viśvasiti sa tasya nāmnā pāpānmukto bhaviṣyati tasmin sarvve bhaviṣyadvādinopi etādṛśaṁ sākṣyaṁ dadati| ");
INSERT INTO sanias_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","pitarasyaitatkathākathanakāle sarvveṣāṁ śrotṛṇāmupari pavitra ātmāvārohat| ");
INSERT INTO sanias_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","tataḥ pitareṇa sārddham āgatāstvakchedino viśvāsino lokā anyadeśīyebhyaḥ pavitra ātmani datte sati ");
INSERT INTO sanias_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","te nānājātīyabhāṣābhiḥ kathāṁ kathayanta īśvaraṁ praśaṁsanti, iti dṛṣṭvā śrutvā ca vismayam āpadyanta| ");
INSERT INTO sanias_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","tadā pitaraḥ kathitavān, vayamiva ye pavitram ātmānaṁ prāptāsteṣāṁ jalamajjanaṁ kiṁ kopi niṣeddhuṁ śaknoti? ");
INSERT INTO sanias_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","tataḥ prabho rnāmnā majjitā bhavateti tānājñāpayat| anantaraṁ te svaiḥ sārddhaṁ katipayadināni sthātuṁ prārthayanta| ");
INSERT INTO sanias_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","itthaṁ bhinnadeśīyalokā apīśvarasya vākyam agṛhlan imāṁ vārttāṁ yihūdīyadeśasthapreritā bhrātṛgaṇaśca śrutavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","tataḥ pitare yirūśālamnagaraṁ gatavati tvakchedino lokāstena saha vivadamānā avadan, ");
INSERT INTO sanias_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","tvam atvakchedilokānāṁ gṛhaṁ gatvā taiḥ sārddhaṁ bhuktavān| ");
INSERT INTO sanias_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","tataḥ pitara āditaḥ kramaśastatkāryyasya sarvvavṛttāntamākhyātum ārabdhavān| ");
INSERT INTO sanias_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","yāphonagara ekadāhaṁ prārthayamāno mūrcchitaḥ san darśanena caturṣu koṇeṣu lambanamānaṁ vṛhadvastramiva pātramekam ākāśadavaruhya mannikaṭam āgacchad apaśyam| ");
INSERT INTO sanias_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","paścāt tad ananyadṛṣṭyā dṛṣṭvā vivicya tasya madhye nānāprakārān grāmyavanyapaśūn urogāmikhecarāṁśca dṛṣṭavān; ");
INSERT INTO sanias_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","he pitara tvamutthāya gatvā bhuṁkṣva māṁ sambodhya kathayantaṁ śabdamekaṁ śrutavāṁśca| ");
INSERT INTO sanias_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","tatohaṁ pratyavadaṁ, he prabho netthaṁ bhavatu, yataḥ kiñcana niṣiddham aśuci dravyaṁ vā mama mukhamadhyaṁ kadāpi na prāviśat| ");
INSERT INTO sanias_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","aparam īśvaro yat śuci kṛtavān tanniṣiddhaṁ na jānīhi dvi rmāmpratīdṛśī vihāyasīyā vāṇī jātā| ");
INSERT INTO sanias_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","triritthaṁ sati tat sarvvaṁ punarākāśam ākṛṣṭaṁ| ");
INSERT INTO sanias_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","paścāt kaisariyānagarāt trayo janā mannikaṭaṁ preṣitā yatra niveśane sthitohaṁ tasmin samaye tatropātiṣṭhan| ");
INSERT INTO sanias_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","tadā niḥsandehaṁ taiḥ sārddhaṁ yātum ātmā māmādiṣṭavān; tataḥ paraṁ mayā sahaiteṣu ṣaḍbhrātṛṣu gateṣu vayaṁ tasya manujasya gṛhaṁ prāviśāma| ");
INSERT INTO sanias_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","sosmākaṁ nikaṭe kathāmetām akathayat ekadā dūta ekaḥ pratyakṣībhūya mama gṛhamadhye tiṣṭan māmityājñāpitavān, yāphonagaraṁ prati lokān prahitya pitaranāmnā vikhyātaṁ śimonam āhūyaya; ");
INSERT INTO sanias_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","tatastava tvadīyaparivārāṇāñca yena paritrāṇaṁ bhaviṣyati tat sa upadekṣyati| ");
INSERT INTO sanias_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","ahaṁ tāṁ kathāmutthāpya kathitavān tena prathamam asmākam upari yathā pavitra ātmāvarūḍhavān tathā teṣāmapyupari samavarūḍhavān| ");
INSERT INTO sanias_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","tena yohan jale majjitavān iti satyaṁ kintu yūyaṁ pavitra ātmani majjitā bhaviṣyatha, iti yadvākyaṁ prabhuruditavān tat tadā mayā smṛtam| ");
INSERT INTO sanias_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","ataḥ prabhā yīśukhrīṣṭe pratyayakāriṇo ye vayam asmabhyam īśvaro yad dattavān tat tebhyo lokebhyopi dattavān tataḥ kohaṁ? kimaham īśvaraṁ vārayituṁ śaknomi? ");
INSERT INTO sanias_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","kathāmetāṁ śruvā te kṣāntā īśvarasya guṇān anukīrttya kathitavantaḥ, tarhi paramāyuḥprāptinimittam īśvaronyadeśīyalokebhyopi manaḥparivarttanarūpaṁ dānam adāt| ");
INSERT INTO sanias_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","stiphānaṁ prati upadrave ghaṭite ye vikīrṇā abhavan tai phainīkīkuprāntiyakhiyāsu bhramitvā kevalayihūdīyalokān vinā kasyāpyanyasya samīpa īśvarasya kathāṁ na prācārayan| ");
INSERT INTO sanias_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","aparaṁ teṣāṁ kuprīyāḥ kurīnīyāśca kiyanto janā āntiyakhiyānagaraṁ gatvā yūnānīyalokānāṁ samīpepi prabhoryīśoḥ kathāṁ prācārayan| ");
INSERT INTO sanias_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","prabhoḥ karasteṣāṁ sahāya āsīt tasmād aneke lokā viśvasya prabhuṁ prati parāvarttanta| ");
INSERT INTO sanias_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","iti vārttāyāṁ yirūśālamasthamaṇḍalīyalokānāṁ karṇagocarībhūtāyām āntiyakhiyānagaraṁ gantu te barṇabbāṁ prairayan| ");
INSERT INTO sanias_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","tato barṇabbāstatra upasthitaḥ san īśvarasyānugrahasya phalaṁ dṛṣṭvā sānando jātaḥ, ");
INSERT INTO sanias_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","sa svayaṁ sādhu rviśvāsena pavitreṇātmanā ca paripūrṇaḥ san ganoniṣṭayā prabhāvāsthāṁ karttuṁ sarvvān upadiṣṭavān tena prabhoḥ śiṣyā aneke babhūvuḥ| ");
INSERT INTO sanias_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","śeṣe śaulaṁ mṛgayituṁ barṇabbāstārṣanagaraṁ prasthitavān| tatra tasyoddeśaṁ prāpya tam āntiyakhiyānagaram ānayat; ");
INSERT INTO sanias_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","tatastau maṇḍalīsthalokaiḥ sabhāṁ kṛtvā saṁvatsaramekaṁ yāvad bahulokān upādiśatāṁ; tasmin āntiyakhiyānagare śiṣyāḥ prathamaṁ khrīṣṭīyanāmnā vikhyātā abhavan| ");
INSERT INTO sanias_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","tataḥ paraṁ bhaviṣyadvādigaṇe yirūśālama āntiyakhiyānagaram āgate sati ");
INSERT INTO sanias_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","āgābanāmā teṣāmeka utthāya ātmanaḥ śikṣayā sarvvadeśe durbhikṣaṁ bhaviṣyatīti jñāpitavān; tataḥ klaudiyakaisarasyādhikāre sati tat pratyakṣam abhavat| ");
INSERT INTO sanias_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","tasmāt śiṣyā ekaikaśaḥ svasvaśaktyanusārato yihūdīyadeśanivāsināṁ bhratṛṇāṁ dinayāpanārthaṁ dhanaṁ preṣayituṁ niścitya ");
INSERT INTO sanias_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","barṇabbāśaulayo rdvārā prācīnalokānāṁ samīpaṁ tat preṣitavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","tasmin samaye herod‌rājo maṇḍalyāḥ kiyajjanebhyo duḥkhaṁ dātuṁ prārabhat| ");
INSERT INTO sanias_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","viśeṣato yohanaḥ sodaraṁ yākūbaṁ karavālāghāten hatavān| ");
INSERT INTO sanias_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","tasmād yihūdīyāḥ santuṣṭā abhavan iti vijñāya sa pitaramapi dharttuṁ gatavān| ");
INSERT INTO sanias_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","tadā kiṇvaśūnyapūpotsavasamaya upātiṣṭat; ata utsave gate sati lokānāṁ samakṣaṁ taṁ bahirāneyyāmīti manasi sthirīkṛtya sa taṁ dhārayitvā rakṣṇārtham yeṣām ekaikasaṁghe catvāro janāḥ santi teṣāṁ caturṇāṁ rakṣakasaṁghānāṁ samīpe taṁ samarpya kārāyāṁ sthāpitavān| ");
INSERT INTO sanias_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","kintuṁ pitarasya kārāsthitikāraṇāt maṇḍalyā lokā aviśrāmam īśvarasya samīpe prārthayanta| ");
INSERT INTO sanias_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","anantaraṁ herodi taṁ bahirānāyituṁ udyate sati tasyāṁ rātrau pitaro rakṣakadvayamadhyasthāne śṛṅkhaladvayena baddhvaḥ san nidrita āsīt, dauvārikāśca kārāyāḥ sammukhe tiṣṭhanato dvāram arakṣiṣuḥ| ");
INSERT INTO sanias_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","etasmin samaye parameśvarasya dūte samupasthite kārā dīptimatī jātā; tataḥ sa dūtaḥ pitarasya kukṣāvāvātaṁ kṛtvā taṁ jāgarayitvā bhāṣitavān tūrṇamuttiṣṭha; tatastasya hastasthaśṛṅkhaladvayaṁ galat patitaṁ| ");
INSERT INTO sanias_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","sa dūtastamavadat, baddhakaṭiḥ san pādayoḥ pāduke arpaya; tena tathā kṛte sati dūtastam uktavān gātrīyavastraṁ gātre nidhāya mama paścād ehi| ");
INSERT INTO sanias_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","tataḥ pitarastasya paścād vrajana bahiragacchat, kintu dūtena karmmaitat kṛtamiti satyamajñātvā svapnadarśanaṁ jñātavān| ");
INSERT INTO sanias_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","itthaṁ tau prathamāṁ dvitīyāñca kārāṁ laṅghitvā yena lauhanirmmitadvāreṇa nagaraṁ gamyate tatsamīpaṁ prāpnutāṁ; tatastasya kavāṭaṁ svayaṁ muktamabhavat tatastau tatsthānād bahi rbhūtvā mārgaikasya sīmāṁ yāvad gatau; tato'kasmāt sa dūtaḥ pitaraṁ tyaktavān| ");
INSERT INTO sanias_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","tadā sa cetanāṁ prāpya kathitavān nijadūtaṁ prahitya parameśvaro herodo hastād yihūdīyalokānāṁ sarvvāśāyāśca māṁ samuddhṛtavān ityahaṁ niścayaṁ jñātavān| ");
INSERT INTO sanias_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","sa vivicya mārkanāmrā vikhyātasya yohano mātu rmariyamo yasmin gṛhe bahavaḥ sambhūya prārthayanta tanniveśanaṁ gataḥ| ");
INSERT INTO sanias_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","pitareṇa bahirdvāra āhate sati rodānāmā bālikā draṣṭuṁ gatā| ");
INSERT INTO sanias_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","tataḥ pitarasya svaraṁ śruvā sā harṣayuktā satī dvāraṁ na mocayitvā pitaro dvāre tiṣṭhatīti vārttāṁ vaktum abhyantaraṁ dhāvitvā gatavatī| ");
INSERT INTO sanias_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","te prāvocan tvamunmattā jātāsi kintu sā muhurmuhuruktavatī satyamevaitat| ");
INSERT INTO sanias_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","tadā te kathitavantastarhi tasya dūto bhavet| ");
INSERT INTO sanias_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","pitaro dvāramāhatavān etasminnantare dvāraṁ mocayitvā pitaraṁ dṛṣṭvā vismayaṁ prāptāḥ| ");
INSERT INTO sanias_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","tataḥ pitaro niḥśabdaṁ sthātuṁ tān prati hastena saṅketaṁ kṛtvā parameśvaro yena prakāreṇa taṁ kārāyā uddhṛtyānītavān tasya vṛttāntaṁ tānajñāpayat, yūyaṁ gatvā yākubaṁ bhrātṛgaṇañca vārttāmetāṁ vadatetyuktā sthānāntaraṁ prasthitavān| ");
INSERT INTO sanias_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","prabhāte sati pitaraḥ kva gata ityatra rakṣakāṇāṁ madhye mahān kalaho jātaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","herod bahu mṛgayitvā tasyoddeśe na prāpte sati rakṣakān saṁpṛcchya teṣāṁ prāṇān hantum ādiṣṭavān| ");
INSERT INTO sanias_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","paścāt sa yihūdīyapradeśāt kaisariyānagaraṁ gatvā tatrāvātiṣṭhat| ");
INSERT INTO sanias_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","sorasīdonadeśayo rlokebhyo herodi yuyutsau sati te sarvva ekamantraṇāḥ santastasya samīpa upasthāya lvāstanāmānaṁ tasya vastragṛhādhīśaṁ sahāyaṁ kṛtvā herodā sārddhaṁ sandhiṁ prārthayanta yatastasya rājño deśena teṣāṁ deśīyānāṁ bharaṇam abhavatṁ ");
INSERT INTO sanias_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","ataḥ kutracin nirupitadine herod rājakīyaṁ paricchadaṁ paridhāya siṁhāsane samupaviśya tān prati kathām uktavān| ");
INSERT INTO sanias_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","tato lokā uccaiḥkāraṁ pratyavadan, eṣa manujaravo na hi, īśvarīyaravaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","tadā herod īśvarasya sammānaṁ nākarot; tasmāddhetoḥ parameśvarasya dūto haṭhāt taṁ prāharat tenaiva sa kīṭaiḥ kṣīṇaḥ san prāṇān ajahāt| kintvīśvarasya kathā deśaṁ vyāpya prabalābhavat| tataḥ paraṁ barṇabbāśaulau yasya karmmaṇo bhāraṁ prāpnutāṁ tābhyāṁ tasmin sampādite sati mārkanāmnā vikhyāto yo yohan taṁ saṅginaṁ kṛtvā yirūśālamnagarāt pratyāgatau| ");
INSERT INTO sanias_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","aparañca barṇabbāḥ, śimon yaṁ nigraṁ vadanti, kurīnīyalūkiyo herodā rājñā saha kṛtavidyāाbhyāso minahem, śaulaścaite ye kiyanto janā bhaviṣyadvādina upadeṣṭāraścāntiyakhiyānagarasthamaṇḍalyām āsan, ");
INSERT INTO sanias_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","te yadopavāsaṁ kṛtveśvaram asevanta tasmin samaye pavitra ātmā kathitavān ahaṁ yasmin karmmaṇi barṇabbāśailau niyuktavān tatkarmma karttuṁ tau pṛthak kuruta| ");
INSERT INTO sanias_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","tatastairupavāsaprārthanayoḥ kṛtayoḥ satoste tayo rgātrayo rhastārpaṇaṁ kṛtvā tau vyasṛjan| ");
INSERT INTO sanias_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","tataḥ paraṁ tau pavitreṇātmanā preritau santau silūkiyānagaram upasthāya samudrapathena kupropadvīpam agacchatāṁ| ");
INSERT INTO sanias_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","tataḥ sālāmīnagaram upasthāya tatra yihūdīyānāṁ bhajanabhavanāni gatveśvarasya kathāṁ prācārayatāṁ; yohanapi tatsahacaro'bhavat| ");
INSERT INTO sanias_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","itthaṁ te tasyopadvīpasya sarvvatra bhramantaḥ pāphanagaram upasthitāḥ; tatra suvivecakena sarjiyapaulanāmnā taddeśādhipatinā saha bhaviṣyadvādino veśadhārī baryīśunāmā yo māyāvī yihūdī āsīt taṁ sākṣāt prāptavataḥ| ");
INSERT INTO sanias_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","taddeśādhipa īśvarasya kathāṁ śrotuṁ vāñchan paulabarṇabbau nyamantrayat| ");
INSERT INTO sanias_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","kintvilumā yaṁ māyāvinaṁ vadanti sa deśādhipatiṁ dharmmamārgād bahirbhūtaṁ karttum ayatata| ");
INSERT INTO sanias_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","tasmāt śolo'rthāt paulaḥ pavitreṇātmanā paripūrṇaḥ san taṁ māyāvinaṁ pratyananyadṛṣṭiṁ kṛtvākathayat, ");
INSERT INTO sanias_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","he narakin dharmmadveṣin kauṭilyaduṣkarmmaparipūrṇa, tvaṁ kiṁ prabhoḥ satyapathasya viparyyayakaraṇāt kadāpi na nivarttiṣyase? ");
INSERT INTO sanias_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","adhunā parameśvarastava samucitaṁ kariṣyati tena katipayadināni tvam andhaḥ san sūryyamapi na drakṣyasi| tatkṣaṇād rātrivad andhakārastasya dṛṣṭim ācchāditavān; tasmāt tasya hastaṁ dharttuṁ sa lokamanvicchan itastato bhramaṇaṁ kṛtavān| ");
INSERT INTO sanias_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","enāṁ ghaṭanāṁ dṛṣṭvā sa deśādhipatiḥ prabhūpadeśād vismitya viśvāsaṁ kṛtavān| ");
INSERT INTO sanias_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","tadanantaraṁ paulastatsaṅginau ca pāphanagarāt protaṁ cālayitvā pamphuliyādeśasya pargīnagaram agacchan kintu yohan tayoḥ samīpād etya yirūśālamaṁ pratyāgacchat| ");
INSERT INTO sanias_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","paścāt tau pargīto yātrāṁ kṛtvā pisidiyādeśasya āntiyakhiyānagaram upasthāya viśrāmavāre bhajanabhavanaṁ praviśya samupāviśatāṁ| ");
INSERT INTO sanias_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","vyavasthābhaviṣyadvākyayoḥ paṭhitayoḥ sato rhe bhrātarau lokān prati yuvayoḥ kācid upadeśakathā yadyasti tarhi tāṁ vadataṁ tau prati tasya bhajanabhavanasyādhipatayaḥ kathām etāṁ kathayitvā praiṣayan| ");
INSERT INTO sanias_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ataḥ paula uttiṣṭhan hastena saṅketaṁ kurvvan kathitavān he isrāyelīyamanuṣyā īśvaraparāyaṇāḥ sarvve lokā yūyam avadhaddhaṁ| ");
INSERT INTO sanias_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","eteṣāmisrāyellokānām īśvaro'smākaṁ pūrvvaparuṣān manonītān katvā gṛhītavān tato misari deśe pravasanakāle teṣāmunnatiṁ kṛtvā tasmāt svīyabāhubalena tān bahiḥ kṛtvā samānayat| ");
INSERT INTO sanias_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","catvāriṁśadvatsarān yāvacca mahāprāntare teṣāṁ bharaṇaṁ kṛtvā ");
INSERT INTO sanias_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","kināndeśāntarvvarttīṇi saptarājyāni nāśayitvā guṭikāpātena teṣu sarvvadeśeṣu tebhyo'dhikāraṁ dattavān| ");
INSERT INTO sanias_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","pañcāśadadhikacatuḥśateṣu vatsareṣu gateṣu ca śimūyelbhaviṣyadvādiparyyantaṁ teṣāmupari vicārayitṛn niyuktavān| ");
INSERT INTO sanias_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","taiśca rājñi prārthite, īśvaro binyāmīno vaṁśajātasya kīśaḥ putraṁ śaulaṁ catvāriṁśadvarṣaparyyantaṁ teṣāmupari rājānaṁ kṛtavān| ");
INSERT INTO sanias_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","paścāt taṁ padacyutaṁ kṛtvā yo madiṣṭakriyāḥ sarvvāḥ kariṣyati tādṛśaṁ mama manobhimatam ekaṁ janaṁ yiśayaḥ putraṁ dāyūdaṁ prāptavān idaṁ pramāṇaṁ yasmin dāyūdi sa dattavān taṁ dāyūdaṁ teṣāmupari rājatvaṁ karttum utpāditavāna| ");
INSERT INTO sanias_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","tasya svapratiśrutasya vākyasyānusāreṇa isrāyellokānāṁ nimittaṁ teṣāṁ manuṣyāṇāṁ vaṁśād īśvara ekaṁ yīśuṁ (trātāram) udapādayat| ");
INSERT INTO sanias_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","tasya prakāśanāt pūrvvaṁ yohan isrāyellokānāṁ sannidhau manaḥparāvarttanarūpaṁ majjanaṁ prācārayat| ");
INSERT INTO sanias_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","yasya ca karmmaṇoे bhāraṁ praptavān yohan tan niṣpādayan etāṁ kathāṁ kathitavān, yūyaṁ māṁ kaṁ janaṁ jānītha? aham abhiṣiktatrātā nahi, kintu paśyata yasya pādayoḥ pādukayo rbandhane mocayitumapi yogyo na bhavāmi tādṛśa eko jano mama paścād upatiṣṭhati| ");
INSERT INTO sanias_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","he ibrāhīmo vaṁśajātā bhrātaro he īśvarabhītāḥ sarvvalokā yuṣmān prati paritrāṇasya kathaiṣā preritā| ");
INSERT INTO sanias_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","yirūśālamnivāsinasteṣām adhipatayaśca tasya yīśoḥ paricayaṁ na prāpya prativiśrāmavāraṁ paṭhyamānānāṁ bhaviṣyadvādikathānām abhiprāyam abuddhvā ca tasya vadhena tāḥ kathāḥ saphalā akurvvan| ");
INSERT INTO sanias_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","prāṇahananasya kamapi hetum aprāpyāpi pīlātasya nikaṭe tasya vadhaṁ prārthayanta| ");
INSERT INTO sanias_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","tasmin yāḥ kathā likhitāḥ santi tadanusāreṇa karmma sampādya taṁ kruśād avatāryya śmaśāne śāyitavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","kintvīśvaraḥ śmaśānāt tamudasthāpayat, ");
INSERT INTO sanias_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","punaśca gālīlapradeśād yirūśālamanagaraṁ tena sārddhaṁ ye lokā āgacchan sa bahudināni tebhyo darśanaṁ dattavān, atasta idānīṁ lokān prati tasya sākṣiṇaḥ santi| ");
INSERT INTO sanias_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","asmākaṁ pūrvvapuruṣāṇāṁ samakṣam īśvaro yasmin pratijñātavān yathā, tvaṁ me putrosi cādya tvāṁ samutthāpitavānaham| ");
INSERT INTO sanias_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","idaṁ yadvacanaṁ dvitīyagīte likhitamāste tad yīśorutthānena teṣāṁ santānā ye vayam asmākaṁ sannidhau tena pratyakṣī kṛtaṁ, yuṣmān imaṁ susaṁvādaṁ jñāpayāmi| ");
INSERT INTO sanias_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","parameśvareṇa śmaśānād utthāpitaṁ tadīyaṁ śarīraṁ kadāpi na kṣeṣyate, etasmin sa svayaṁ kathitavān yathā dāyūdaṁ prati pratijñāto yo varastamahaṁ tubhyaṁ dāsyāmi| ");
INSERT INTO sanias_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","etadanyasmin gīte'pi kathitavān| svakīyaṁ puṇyavantaṁ tvaṁ kṣayituṁ na ca dāsyasi| ");
INSERT INTO sanias_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","dāyūdā īśvarābhimatasevāyai nijāyuṣi vyayite sati sa mahānidrāṁ prāpya nijaiḥ pūrvvapuruṣaiḥ saha militaḥ san akṣīyata; ");
INSERT INTO sanias_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","kintu yamīśvaraḥ śmaśānād udasthāpayat sa nākṣīyata| ");
INSERT INTO sanias_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","ato he bhrātaraḥ, anena janena pāpamocanaṁ bhavatīti yuṣmān prati pracāritam āste| ");
INSERT INTO sanias_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","phalato mūsāvyavasthayā yūyaṁ yebhyo doṣebhyo muktā bhavituṁ na śakṣyatha tebhyaḥ sarvvadoṣebhya etasmin jane viśvāsinaḥ sarvve muktā bhaviṣyantīti yuṣmābhi rjñāyatāṁ| ");
INSERT INTO sanias_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","aparañca| avajñākāriṇo lokāścakṣurunmīlya paśyata| tathaivāsambhavaṁ jñātvā syāta yūyaṁ vilajjitāḥ| yato yuṣmāsu tiṣṭhatsu kariṣye karmma tādṛśaṁ| yenaiva tasya vṛttānte yuṣmabhyaṁ kathite'pi hi| yūyaṁ na tantu vṛttāntaṁ pratyeṣyatha kadācana|| ");
INSERT INTO sanias_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","yeyaṁ kathā bhaviṣyadvādināṁ grantheṣu likhitāste sāvadhānā bhavata sa kathā yathā yuṣmān prati na ghaṭate| ");
INSERT INTO sanias_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","yihūdīyabhajanabhavanān nirgatayostayo rbhinnadeśīyai rvakṣyamāṇā prārthanā kṛtā, āgāmini viśrāmavāre'pi katheyam asmān prati pracāritā bhavatviti| ");
INSERT INTO sanias_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","sabhāyā bhaṅge sati bahavo yihūdīyalokā yihūdīyamatagrāhiṇo bhaktalokāśca barṇabbāpaulayoḥ paścād āgacchan, tena tau taiḥ saha nānākathāḥ kathayitveśvarānugrahāśraye sthātuṁ tān prāvarttayatāṁ| ");
INSERT INTO sanias_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","paraviśrāmavāre nagarasya prāyeṇa sarvve lākā īśvarīyāṁ kathāṁ śrotuṁ militāḥ, ");
INSERT INTO sanias_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","kintu yihūdīyalokā jananivahaṁ vilokya īrṣyayā paripūrṇāḥ santo viparītakathākathaneneśvaranindayā ca paulenoktāṁ kathāṁ khaṇḍayituṁ ceṣṭitavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","tataḥ pauैlabarṇabbāvakṣobhau kathitavantau prathamaṁ yuṣmākaṁ sannidhāvīśvarīyakathāyāḥ pracāraṇam ucitamāsīt kintuṁ tadagrāhyatvakaraṇena yūyaṁ svān anantāyuṣo'yogyān darśayatha, etatkāraṇād vayam anyadeśīyalokānāṁ samīpaṁ gacchāmaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","prabhurasmān ittham ādiṣṭavān yathā, yāvacca jagataḥ sīmāṁ lokānāṁ trāṇakāraṇāt| mayānyadeśamadhye tvaṁ sthāpito bhūḥ pradīpavat|| ");
INSERT INTO sanias_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","tadā kathāmīdṛśīṁ śrutvā bhinnadeśīyā āhlāditāḥ santaḥ prabhoḥ kathāṁ dhanyāṁ dhanyām avadan, yāvanto lokāśca paramāyuḥ prāptinimittaṁ nirūpitā āsan teे vyaśvasan| ");
INSERT INTO sanias_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","itthaṁ prabhoḥ kathā sarvvedeśaṁ vyāpnot| ");
INSERT INTO sanias_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","kintu yihūdīyā nagarasya pradhānapuruṣān sammānyāḥ kathipayā bhaktā yoṣitaśca kupravṛttiṁ grāhayitvā paulabarṇabbau tāḍayitvā tasmāt pradeśād dūrīkṛtavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","ataḥ kāraṇāt tau nijapadadhūlīsteṣāṁ prātikūlyena pātayitveेkaniyaṁ nagaraṁ gatau| ");
INSERT INTO sanias_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","tataḥ śiṣyagaṇa ānandena pavitreṇātmanā ca paripūrṇobhavat| ");
INSERT INTO sanias_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","tau dvau janau yugapad ikaniyanagarasthayihūdīyānāṁ bhajanabhavanaṁ gatvā yathā bahavo yihūdīyā anyadeेśīyalokāśca vyaśvasan tādṛśīṁ kathāṁ kathitavantau| ");
INSERT INTO sanias_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","kintu viśvāsahīnā yihūdīyā anyadeśīyalokān kupravṛttiṁ grāhayitvā bhrātṛgaṇaṁ prati teṣāṁ vairaṁ janitavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ataḥ svānugrahakathāyāḥ pramāṇaṁ datvā tayo rhastai rbahulakṣaṇam adbhutakarmma ca prākāśayad yaḥ prabhustasya kathā akṣobhena pracāryya tau tatra bahudināni samavātiṣṭhetāṁ| ");
INSERT INTO sanias_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","kintu kiyanto lokā yihūdīyānāṁ sapakṣāḥ kiyanto lokāḥ preritānāṁ sapakṣā jātāḥ, ato nāgarikajananivahamadhye bhinnavākyatvam abhavat| ");
INSERT INTO sanias_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","anyadeśīyā yihūdīyāsteṣām adhipatayaśca daurātmyaṁ kutvā tau prastarairāhantum udyatāḥ| ");
INSERT INTO sanias_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","tau tadvārttāṁ prāpya palāyitvā lukāyaniyādeśasyāntarvvarttilustrādarbbo ");
INSERT INTO sanias_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","tatsamīpasthadeśañca gatvā tatra susaṁvādaṁ pracārayatāṁ| ");
INSERT INTO sanias_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","tatrobhayapādayoścalanaśaktihīno janmārabhya khañjaḥ kadāpi gamanaṁ nākarot etādṛśa eko mānuṣo lustrānagara upaviśya paulasya kathāṁ śrutavān| ");
INSERT INTO sanias_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","etasmin samaye paulastamprati dṛṣṭiṁ kṛtvā tasya svāsthye viśvāsaṁ viditvā proccaiḥ kathitavān ");
INSERT INTO sanias_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","padbhyāmuttiṣṭhan ṛju rbhava|tataḥ sa ullamphaṁ kṛtvā gamanāgamane kutavān| ");
INSERT INTO sanias_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","tadā lokāḥ paulasya tat kāryyaṁ vilokya lukāyanīyabhāṣayā proccaiḥ kathāmetāṁ kathitavantaḥ, devā manuṣyarūpaṁ dhṛtvāsmākaṁ samīpam avārohan| ");
INSERT INTO sanias_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","te barṇabbāṁ yūpitaram avadan paulaśca mukhyo vaktā tasmāt taṁ markuriyam avadan| ");
INSERT INTO sanias_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","tasya nagarasya sammukhe sthāpitasya yūpitaravigrahasya yājako vṛṣān puṣpamālāśca dvārasamīpam ānīya lokaiḥ sarddhaṁ tāvuddiśya samutsṛjya dātum udyataḥ| ");
INSERT INTO sanias_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","tadvārttāṁ śrutvā barṇabbāpaulau svīyavastrāṇi chitvā lokānāṁ madhyaṁ vegena praviśya proccaiḥ kathitavantau, ");
INSERT INTO sanias_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","he mahecchāḥ kuta etādṛśaṁ karmma kurutha? āvāmapi yuṣmādṛśau sukhaduḥkhabhoginau manuṣyau, yuyam etāḥ sarvvā vṛthākalpanāḥ parityajya yathā gagaṇavasundharājalanidhīnāṁ tanmadhyasthānāṁ sarvveṣāñca sraṣṭāramamaram īśvaraṁ prati parāvarttadhve tadartham āvāṁ yuṣmākaṁ sannidhau susaṁvādaṁ pracārayāvaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","sa īśvaraḥ pūrvvakāle sarvvadeśīyalokān svasvamārge calitumanumatiṁ dattavān, ");
INSERT INTO sanias_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","tathāpi ākāśāt toyavarṣaṇena nānāprakāraśasyotpatyā ca yuṣmākaṁ hitaiṣī san bhakṣyairānanadena ca yuṣmākam antaḥkaraṇāni tarpayan tāni dānāni nijasākṣisvarūpāṇi sthapitavān| ");
INSERT INTO sanias_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","kintu tādṛśāyāṁ kathāyāṁ kathitāyāmapi tayoḥ samīpa utsarjanāt lokanivahaṁ prāyeṇa nivarttayituṁ nāśaknutām| ");
INSERT INTO sanias_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","āntiyakhiyā-ikaniyanagarābhyāṁ katipayayihūdīyalokā āgatya lokān prāvarttayanta tasmāt tai paulaṁ prastarairāghnan tena sa mṛta iti vijñāya nagarasya bahistam ākṛṣya nītavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","kintu śiṣyagaṇe tasya caturdiśi tiṣṭhati sati sa svayam utthāya punarapi nagaramadhyaṁ prāviśat tatpare'hani barṇabbāsahito darbbīnagaraṁ gatavān| ");
INSERT INTO sanias_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","tatra susaṁvādaṁ pracāryya bahulokān śiṣyān kṛtvā tau lustrām ikaniyam āntiyakhiyāñca parāvṛtya gatau| ");
INSERT INTO sanias_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","bahuduḥkhāni bhuktvāpīśvararājyaṁ praveṣṭavyam iti kāraṇād dharmmamārge sthātuṁ vinayaṁ kṛtvā śiṣyagaṇasya manaḥsthairyyam akurutāṁ| ");
INSERT INTO sanias_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","maṇḍalīnāṁ prācīnavargān niyujya prārthanopavāsau kṛtvā yatprabhau te vyaśvasan tasya haste tān samarpya ");
INSERT INTO sanias_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","pisidiyāmadhyena pāmphuliyādeśaṁ gatavantau| ");
INSERT INTO sanias_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","paścāt pargānagaraṁ gatvā susaṁvādaṁ pracāryya attāliyānagaraṁ prasthitavantau| ");
INSERT INTO sanias_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","tasmāt samudrapathena gatvā tābhyāṁ yat karmma sampannaṁ tatkarmma sādhayituṁ yannagare dayālorīśvarasya haste samarpitau jātau tad āntiyakhiyānagaraṁ gatavantā| ");
INSERT INTO sanias_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","tatropasthāya tannagarasthamaṇḍalīṁ saṁgṛhya svābhyāma īśvaro yadyat karmmakarot tathā yena prakāreṇa bhinnadeśīyalokān prati viśvāsarūpadvāram amocayad etān sarvvavṛttāntān tān jñāpitavantau| ");
INSERT INTO sanias_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","tatastau śiryyaiḥ sārddhaṁ tatra bahudināni nyavasatām| ");
INSERT INTO sanias_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","yihūdādeśāt kiyanto janā āgatya bhrātṛgaṇamitthaṁ śikṣitavanto mūsāvyavasthayā yadi yuṣmākaṁ tvakchedo na bhavati tarhi yūyaṁ paritrāṇaṁ prāptuṁ na śakṣyatha| ");
INSERT INTO sanias_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","paulabarṇabbau taiḥ saha bahūn vicārān vivādāṁśca kṛtavantau, tato maṇḍalīyanokā etasyāḥ kathāyāstattvaṁ jñātuṁ yirūśālamnagarasthān preritān prācīnāṁśca prati paulabarṇabbāprabhṛtīn katipayajanān preṣayituṁ niścayaṁ kṛtavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","te maṇḍalyā preritāḥ santaḥ phaiṇīkīśomirondeśābhyāṁ gatvā bhinnadeśīyānāṁ manaḥparivarttanasya vārttayā bhrātṛṇāṁ paramāhlādam ajanayan| ");
INSERT INTO sanias_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","yirūśālamyupasthāya preritagaṇena lokaprācīnagaṇena samājena ca samupagṛhītāḥ santaḥ svairīśvaro yāni karmmāṇi kṛtavān teṣāṁ sarvvavṛttāntān teṣāṁ samakṣam akathayan| ");
INSERT INTO sanias_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","kintu viśvāsinaḥ kiyantaḥ phirūśimatagrāhiṇo lokā utthāya kathāmetāṁ kathitavanto bhinnadeśīyānāṁ tvakchedaṁ karttuṁ mūsāvyavasthāṁ pālayituñca samādeṣṭavyam| ");
INSERT INTO sanias_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","tataḥ preritā lokaprācīnāśca tasya vivecanāṁ karttuṁ sabhāyāṁ sthitavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","bahuvicāreṣu jātaṣu pitara utthāya kathitavān, he bhrātaro yathā bhinnadeśīyalokā mama mukhāt susaṁvādaṁ śrutvā viśvasanti tadarthaṁ bahudināt pūrvvam īśvarosmākaṁ madhye māṁ vṛtvā niyuktavān| ");
INSERT INTO sanias_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","antaryyāmīśvaro yathāsmabhyaṁ tathā bhinnadeśīyebhyaḥ pavitramātmānaṁ pradāya viśvāsena teṣām antaḥkaraṇāni pavitrāṇi kṛtvā ");
INSERT INTO sanias_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","teṣām asmākañca madhye kimapi viśeṣaṁ na sthāpayitvā tānadhi svayaṁ pramāṇaṁ dattavān iti yūyaṁ jānītha| ");
INSERT INTO sanias_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","ataevāsmākaṁ pūrvvapuruṣā vayañca svayaṁ yadyugasya bhāraṁ soḍhuṁ na śaktāḥ samprati taṁ śiṣyagaṇasya skandheṣu nyasituṁ kuta īśvarasya parīkṣāṁ kariṣyatha? ");
INSERT INTO sanias_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","prabho ryīśukhrīṣṭasyānugraheṇa te yathā vayamapi tathā paritrāṇaṁ prāptum āśāṁ kurmmaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","anantaraṁ barṇabbāpaulābhyām īśvaro bhinnadeśīyānāṁ madhye yadyad āścaryyam adbhutañca karmma kṛtavān tadvṛttāntaṁ tau svamukhābhyām avarṇayatāṁ sabhāsthāḥ sarvve nīravāḥ santaḥ śrutavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","tayoḥ kathāyāṁ samāptāyāṁ satyāṁ yākūb kathayitum ārabdhavān ");
INSERT INTO sanias_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","he bhrātaro mama kathāyām mano nidhatta| īśvaraḥ svanāmārthaṁ bhinnadeśīyalokānām madhyād ekaṁ lokasaṁghaṁ grahītuṁ matiṁ kṛtvā yena prakāreṇa prathamaṁ tān prati kṛpāvalekanaṁ kṛtavān taṁ śimon varṇitavān| ");
INSERT INTO sanias_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","bhaviṣyadvādibhiruktāni yāni vākyāni taiḥ sārddham etasyaikyaṁ bhavati yathā likhitamāste| ");
INSERT INTO sanias_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","sarvveṣāṁ karmmaṇāṁ yastu sādhakaḥ parameśvaraḥ| sa evedaṁ vadedvākyaṁ śeṣāḥ sakalamānavāḥ| bhinnadeśīyalokāśca yāvanto mama nāmataḥ| bhavanti hi suvikhyātāste yathā parameśituḥ| ");
INSERT INTO sanias_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","tatvaṁ samyak samīhante tannimittamahaṁ kila| parāvṛtya samāgatya dāyūdaḥ patitaṁ punaḥ| dūṣyamutthāpayiṣyāmi tadīyaṁ sarvvavastu ca| patitaṁ punaruthāpya sajjayiṣyāmi sarvvathā|| ");
INSERT INTO sanias_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ā prathamād īśvaraḥ svīyāni sarvvakarmmāṇi jānāti| ");
INSERT INTO sanias_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","ataeva mama nivedanamidaṁ bhinnadeśīyalokānāṁ madhye ye janā īśvaraṁ prati parāvarttanta teṣāmupari anyaṁ kamapi bhāraṁ na nyasya ");
INSERT INTO sanias_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","devatāprasādāśucibhakṣyaṁ vyabhicārakarmma kaṇṭhasampīḍanamāritaprāṇibhakṣyaṁ raktabhakṣyañca etāni parityaktuṁ likhāmaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","yataḥ pūrvvakālato mūsāvyavasthāpracāriṇo lokā nagare nagare santi prativiśrāmavārañca bhajanabhavane tasyāḥ pāṭho bhavati| ");
INSERT INTO sanias_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","tataḥ paraṁ preritagaṇo lokaprācīnagaṇaḥ sarvvā maṇḍalī ca sveṣāṁ madhye barśabbā nāmnā vikhyāto manonītau kṛtvā paulabarṇabbābhyāṁ sārddham āntiyakhiyānagaraṁ prati preṣaṇam ucitaṁ buddhvā tābhyāṁ patraṁ praiṣayan| ");
INSERT INTO sanias_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","tasmin patre likhitamiṁda, āntiyakhiyā-suriyā-kilikiyādeśasthabhinnadeśīyabhrātṛgaṇāya preritagaṇasya lokaprācīnagaṇasya bhrātṛgaṇasya ca namaskāraḥ| ");
INSERT INTO sanias_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","viśeṣato'smākam ājñām aprāpyāpi kiyanto janā asmākaṁ madhyād gatvā tvakchedo mūsāvyavasthā ca pālayitavyāviti yuṣmān śikṣayitvā yuṣmākaṁ manasāmasthairyyaṁ kṛtvā yuṣmān sasandehān akurvvan etāṁ kathāṁ vayam aśṛnma| ");
INSERT INTO sanias_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","tatkāraṇād vayam ekamantraṇāḥ santaḥ sabhāyāṁ sthitvā prabho ryīśukhrīṣṭasya nāmanimittaṁ mṛtyumukhagatābhyāmasmākaṁ ");
INSERT INTO sanias_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","priyabarṇabbāpaulābhyāṁ sārddhaṁ manonītalokānāṁ keṣāñcid yuṣmākaṁ sannidhau preṣaṇam ucitaṁ buddhavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","ato yihūdāsīlau yuṣmān prati preṣitavantaḥ, etayo rmukhābhyāṁ sarvvāṁ kathāṁ jñāsyatha| ");
INSERT INTO sanias_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","devatāprasādabhakṣyaṁ raktabhakṣyaṁ galapīḍanamāritaprāṇibhakṣyaṁ vyabhicārakarmma cemāni sarvvāṇi yuṣmābhistyājyāni; etatprayojanīyājñāvyatirekena yuṣmākam upari bhāramanyaṁ na nyasituṁ pavitrasyātmano'smākañca ucitajñānam abhavat| ");
INSERT INTO sanias_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ataeva tebhyaḥ sarvvebhyaḥ sveṣu rakṣiteṣu yūyaṁ bhadraṁ karmma kariṣyatha| yuṣmākaṁ maṅgalaṁ bhūyāt| ");
INSERT INTO sanias_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","teे visṛṣṭāḥ santa āntiyakhiyānagara upasthāya lokanivahaṁ saṁgṛhya patram adadan| ");
INSERT INTO sanias_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","tataste tatpatraṁ paṭhitvā sāntvanāṁ prāpya sānandā abhavan| ");
INSERT INTO sanias_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","yihūdāsīlau ca svayaṁ pracārakau bhūtvā bhrātṛgaṇaṁ nānopadiśya tān susthirān akurutām| ");
INSERT INTO sanias_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","itthaṁ tau tatra taiḥ sākaṁ katipayadināni yāpayitvā paścāt preritānāṁ samīpe pratyāgamanārthaṁ teṣāṁ sannidheḥ kalyāṇena visṛṣṭāvabhavatāṁ| ");
INSERT INTO sanias_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","kintu sīlastatra sthātuṁ vāñchitavān| ");
INSERT INTO sanias_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","aparaṁ paulabarṇabbau bahavaḥ śiṣyāśca lokān upadiśya prabhoḥ susaṁvādaṁ pracārayanta āntiyakhiyāyāṁ kālaṁ yāpitavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","katipayadineṣu gateṣu paulo barṇabbām avadat āgacchāvāṁ yeṣu nagareṣvīśvarasya susaṁvādaṁ pracāritavantau tāni sarvvanagarāṇi punargatvā bhrātaraḥ kīdṛśāḥ santīti draṣṭuṁ tān sākṣāt kurvvaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","tena mārkanāmnā vikhyātaṁ yohanaṁ saṅginaṁ karttuṁ barṇabbā matimakarot, ");
INSERT INTO sanias_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","kintu sa pūrvvaṁ tābhyāṁ saha kāryyārthaṁ na gatvā pāmphūliyādeśe tau tyaktavān tatkāraṇāt paulastaṁ saṅginaṁ karttum anucitaṁ jñātavān| ");
INSERT INTO sanias_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","itthaṁ tayoratiśayavirodhasyopasthitatvāt tau parasparaṁ pṛthagabhavatāṁ tato barṇabbā mārkaṁ gṛhītvā potena kupropadvīpaṁ gatavān; ");
INSERT INTO sanias_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","kintu paulaḥ sīlaṁ manonītaṁ kṛtvā bhrātṛbhirīśvarānugrahe samarpitaḥ san prasthāya ");
INSERT INTO sanias_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","suriyākilikiyādeśābhyāṁ maṇḍalīḥ sthirīkurvvan agacchat| ");
INSERT INTO sanias_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","paulo darbbīlustrānagarayorupasthitobhavat tatra tīmathiyanāmā śiṣya eka āsīt; sa viśvāsinyā yihūdīyāyā yoṣito garbbhajātaḥ kintu tasya pitānyadeśīyalokaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","sa jano lustrā-ikaniyanagarasthānāṁ bhrātṛṇāṁ samīpepi sukhyātimān āsīt| ");
INSERT INTO sanias_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","paulastaṁ svasaṅginaṁ karttuṁ matiṁ kṛtvā taṁ gṛhītvā taddeśanivāsināṁ yihūdīyānām anurodhāt tasya tvakchedaṁ kṛtavān yatastasya pitā bhinnadeśīyaloka iti sarvvairajñāyata| ");
INSERT INTO sanias_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","tataḥ paraṁ te nagare nagare bhramitvā yirūśālamasthaiḥ preritai rlokaprācīnaiśca nirūpitaṁ yad vyavasthāpatraṁ tadanusāreṇācarituṁ lokebhyastad dattavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","tenaiva sarvve dharmmasamājāḥ khrīṣṭadharmme susthirāḥ santaḥ pratidinaṁ varddhitā abhavan| ");
INSERT INTO sanias_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","teṣu phrugiyāgālātiyādeśamadhyena gateṣu satsu pavitra ātmā tān āśiyādeśe kathāṁ prakāśayituṁ pratiṣiddhavān| ");
INSERT INTO sanias_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","tathā musiyādeśa upasthāya bithuniyāṁ gantuṁ tairudyoge kṛte ātmā tān nānvamanyata| ");
INSERT INTO sanias_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","tasmāt te musiyādeśaṁ parityajya troyānagaraṁ gatvā samupasthitāḥ| ");
INSERT INTO sanias_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","rātrau paulaḥ svapne dṛṣṭavān eko mākidaniyalokastiṣṭhan vinayaṁ kṛtvā tasmai kathayati, mākidaniyādeśam āgatyāsmān upakurvviti| ");
INSERT INTO sanias_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","tasyetthaṁ svapnadarśanāt prabhustaddeśīyalokān prati susaṁvādaṁ pracārayitum asmān āhūyatīti niścitaṁ buddhvā vayaṁ tūrṇaṁ mākidaniyādeśaṁ gantum udyogam akurmma| ");
INSERT INTO sanias_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","tataḥ paraṁ vayaṁ troyānagarād prasthāya ṛjumārgeṇa sāmathrākiyopadvīpena gatvā pare'hani niyāpalinagara upasthitāḥ| ");
INSERT INTO sanias_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","tasmād gatvā mākidaniyāntarvvartti romīyavasatisthānaṁ yat philipīnāmapradhānanagaraṁ tatropasthāya katipayadināni tatra sthitavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","viśrāmavāre nagarād bahi rgatvā nadītaṭe yatra prārthanācāra āsīt tatropaviśya samāgatā nārīḥ prati kathāṁ prācārayāma| ");
INSERT INTO sanias_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","tataḥ thuyātīrānagarīyā dhūṣarāmbaravikrāyiṇī ludiyānāmikā yā īśvarasevikā yoṣit śrotrīṇāṁ madhya āsīt tayā pauloktavākyāni yad gṛhyante tadarthaṁ prabhustasyā manodvāraṁ muktavān| ");
INSERT INTO sanias_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ataḥ sā yoṣit saparivārā majjitā satī vinayaṁ kṛtvā kathitavatī, yuṣmākaṁ vicārād yadi prabhau viśvāsinī jātāhaṁ tarhi mama gṛham āgatya tiṣṭhata| itthaṁ sā yatnenāsmān asthāpayat| ");
INSERT INTO sanias_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","yasyā gaṇanayā tadadhipatīnāṁ bahudhanopārjanaṁ jātaṁ tādṛśī gaṇakabhūtagrastā kācana dāsī prārthanāsthānagamanakāla āgatyāsmān sākṣāt kṛtavatī| ");
INSERT INTO sanias_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","sāsmākaṁ paulasya ca paścād etya proccaiḥ kathāmimāṁ kathitavatī, manuṣyā ete sarvvoparisthasyeśvarasya sevakāḥ santo'smān prati paritrāṇasya mārgaṁ prakāśayanti| ");
INSERT INTO sanias_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","sā kanyā bahudināni tādṛśam akarot tasmāt paulo duḥkhitaḥ san mukhaṁ parāvartya taṁ bhūtamavadad, ahaṁ yīśukhrīṣṭasya nāmnā tvāmājñāpayāmi tvamasyā bahirgaccha; tenaiva tatkṣaṇāt sa bhūtastasyā bahirgataḥ| ");
INSERT INTO sanias_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","tataḥ sveṣāṁ lābhasya pratyāśā viphalā jāteti vilokya tasyāḥ prabhavaḥ paulaṁ sīlañca dhṛtvākṛṣya vicārasthāne'dhipatīnāṁ samīpam ānayan| ");
INSERT INTO sanias_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","tataḥ śāsakānāṁ nikaṭaṁ nītvā romilokā vayam asmākaṁ yad vyavaharaṇaṁ grahītum ācarituñca niṣiddhaṁ, ");
INSERT INTO sanias_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ime yihūdīyalokāḥ santopi tadeva śikṣayitvā nagare'smākam atīva kalahaṁ kurvvanti, ");
INSERT INTO sanias_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","iti kathite sati lokanivahastayoḥ prātikūlyenodatiṣṭhat tathā śāsakāstayo rvastrāṇi chitvā vetrāghātaṁ karttum ājñāpayan| ");
INSERT INTO sanias_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","aparaṁ te tau bahu prahāryya tvametau kārāṁ nītvā sāvadhānaṁ rakṣayeti kārārakṣakam ādiśan| ");
INSERT INTO sanias_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ittham ājñāṁ prāpya sa tāvabhyantarasthakārāṁ nītvā pādeṣu pādapāśībhi rbaddhvā sthāpitāvān| ");
INSERT INTO sanias_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","atha niśīthasamaye paulasīlāvīśvaramuddiśya prāthanāṁ gānañca kṛtavantau, kārāsthitā lokāśca tadaśṛṇvan ");
INSERT INTO sanias_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","tadākasmāt mahān bhūmikampo'bhavat tena bhittimūlena saha kārā kampitābhūt tatkṣaṇāt sarvvāṇi dvārāṇi muktāni jātāni sarvveṣāṁ bandhanāni ca muktāni| ");
INSERT INTO sanias_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","ataeva kārārakṣako nidrāto jāgaritvā kārāyā dvārāṇi muktāni dṛṣṭvā bandilokāḥ palāyitā ityanumāya koṣāt khaṅgaṁ bahiḥ kṛtvātmaghātaṁ karttum udyataḥ| ");
INSERT INTO sanias_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","kintu paulaḥ proccaistamāhūya kathitavān paśya vayaṁ sarvve'trāsmahe, tvaṁ nijaprāṇahiṁsāṁ mākārṣīḥ| ");
INSERT INTO sanias_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","tadā pradīpam ānetum uktvā sa kampamānaḥ san ullampyābhyantaram āgatya paulasīlayoḥ pādeṣu patitavān| ");
INSERT INTO sanias_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","paścāt sa tau bahirānīya pṛṣṭavān he mahecchau paritrāṇaṁ prāptuṁ mayā kiṁ karttavyaṁ? ");
INSERT INTO sanias_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","paścāt tau svagṛhamānīya tayoḥ sammukhe khādyadravyāṇi sthāpitavān tathā sa svayaṁ tadīyāḥ sarvve parivārāśceśvare viśvasantaḥ sānanditā abhavan| ");
INSERT INTO sanias_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","tasmai tasya gṛhasthitasarvvalokebhyaśca prabhoḥ kathāṁ kathitavantau| ");
INSERT INTO sanias_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","tathā rātrestasminneva daṇḍe sa tau gṛhītvā tayoḥ prahārāṇāṁ kṣatāni prakṣālitavān tataḥ sa svayaṁ tasya sarvve parijanāśca majjitā abhavan| ");
INSERT INTO sanias_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","paścāt tau svagṛhamānīya tayoḥ sammukhe khādyadravyāṇi sthāpitavān tathā sa svayaṁ tadīyāḥ sarvve parivārāśceśvare viśvasantaḥ sānanditā abhavan| ");
INSERT INTO sanias_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","dina upasthite tau lokau mocayeti kathāṁ kathayituṁ śāsakāḥ padātigaṇaṁ preṣitavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","tataḥ kārārakṣakaḥ paulāya tāṁ vārttāṁ kathitavān yuvāṁ tyājayituṁ śāsakā lokāna preṣitavanta idānīṁ yuvāṁ bahi rbhūtvā kuśalena pratiṣṭhetāṁ| ");
INSERT INTO sanias_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","kintu paulastān avadat romilokayorāvayoḥ kamapi doṣam na niścitya sarvveṣāṁ samakṣam āvāṁ kaśayā tāḍayitvā kārāyāṁ baddhavanta idānīṁ kimāvāṁ guptaṁ vistrakṣyanti? tanna bhaviṣyati, svayamāgatyāvāṁ bahiḥ kṛtvā nayantu| ");
INSERT INTO sanias_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","tadā padātibhiḥ śāsakebhya etadvārttāyāṁ kathitāyāṁ tau romilokāviti kathāṁ śrutvā te bhītāḥ ");
INSERT INTO sanias_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","santastayoḥ sannidhimāgatya vinayam akurvvan aparaṁ bahiḥ kṛtvā nagarāt prasthātuṁ prārthitavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","tatastau kārāyā nirgatya ludiyāyā gṛhaṁ gatavantau tatra bhrātṛgaṇaṁ sākṣātkṛtya tān sāntvayitvā tasmāt sthānāt prasthitau| ");
INSERT INTO sanias_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","paulasīlau āmphipalyāpalloniyānagarābhyāṁ gatvā yatra yihūdīyānāṁ bhajanabhavanamekam āste tatra thiṣalanīkīnagara upasthitau| ");
INSERT INTO sanias_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","tadā paulaḥ svācārānusāreṇa teṣāṁ samīpaṁ gatvā viśrāmavāratraye taiḥ sārddhaṁ dharmmapustakīyakathāyā vicāraṁ kṛtavān| ");
INSERT INTO sanias_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","phalataḥ khrīṣṭena duḥkhabhogaḥ karttavyaḥ śmaśānadutthānañca karttavyaṁ yuṣmākaṁ sannidhau yasya yīśoḥ prastāvaṁ karomi sa īśvareṇābhiṣiktaḥ sa etāḥ kathāḥ prakāśya pramāṇaṁ datvā sthirīkṛtavān| ");
INSERT INTO sanias_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","tasmāt teṣāṁ katipayajanā anyadeśīyā bahavo bhaktalokā bahyaḥ pradhānanāryyaśca viśvasya paulasīlayoḥ paścādgāmino jātāḥ| ");
INSERT INTO sanias_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","kintu viśvāsahīnā yihūdīyalokā īrṣyayā paripūrṇāḥ santo haṭaṭsya katinayalampaṭalokān saṅginaḥ kṛtvā janatayā nagaramadhye mahākalahaṁ kṛtvā yāsono gṛham ākramya preritān dhṛtvā lokanivahasya samīpam ānetuṁ ceṣṭitavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","teṣāmuddeśam aprāpya ca yāsonaṁ katipayān bhrātṛṁśca dhṛtvā nagarādhipatīnāṁ nikaṭamānīya proccaiḥ kathitavanto ye manuṣyā jagadudvāṭitavantaste 'trāpyupasthitāḥ santi, ");
INSERT INTO sanias_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","eṣa yāson ātithyaṁ kṛtvā tān gṛhītavān| yīśunāmaka eko rājastīti kathayantaste kaisarasyājñāviruddhaṁ karmma kurvvati| ");
INSERT INTO sanias_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","teṣāṁ kathāmimāṁ śrutvā lokanivaho nagarādhipatayaśca samudvignā abhavan| ");
INSERT INTO sanias_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","tadā yāsonastadanyeṣāñca dhanadaṇḍaṁ gṛhītvā tān parityaktavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","tataḥ paraṁ bhrātṛgaṇo rajanyāṁ paulasīlau śīghraṁ birayānagaraṁ preṣitavān tau tatropasthāya yihūdīyānāṁ bhajanabhavanaṁ gatavantau| ");
INSERT INTO sanias_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","tatrasthā lokāḥ thiṣalanīkīsthalokebhyo mahātmāna āsan yata itthaṁ bhavati na veti jñātuṁ dine dine dharmmagranthasyālocanāṁ kṛtvā svairaṁ kathām agṛhlan| ");
INSERT INTO sanias_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","tasmād aneke yihūdīyā anyadeśīyānāṁ mānyā striyaḥ puruṣāścāneke vyaśvasan| ");
INSERT INTO sanias_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","kintu birayānagare pauleneśvarīyā kathā pracāryyata iti thiṣalanīkīsthā yihūdīyā jñātvā tatsthānamapyāgatya lokānāṁ kupravṛttim ajanayan| ");
INSERT INTO sanias_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","ataeva tasmāt sthānāt samudreṇa yāntīti darśayitvā bhrātaraḥ kṣipraṁ paulaṁ prāhiṇvan kintu sīlatīmathiyau tatra sthitavantau| ");
INSERT INTO sanias_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","tataḥ paraṁ paulasya mārgadarśakāstam āthīnīnagara upasthāpayan paścād yuvāṁ tūrṇam etat sthānaṁ āgamiṣyathaḥ sīlatīmathiyau pratīmām ājñāṁ prāpya te pratyāgatāḥ| ");
INSERT INTO sanias_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","paula āthīnīnagare tāvapekṣya tiṣṭhan tannagaraṁ pratimābhiḥ paripūrṇaṁ dṛṣṭvā santaptahṛdayo 'bhavat| ");
INSERT INTO sanias_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","tataḥ sa bhajanabhavane yān yihūdīyān bhaktalokāṁśca haṭṭe ca yān apaśyat taiḥ saha pratidinaṁ vicāritavān| ");
INSERT INTO sanias_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","kintvipikūrīyamatagrahiṇaḥ stoyikīyamatagrāhiṇaśca kiyanto janāstena sārddhaṁ vyavadanta| tatra kecid akathayan eṣa vācālaḥ kiṁ vaktum icchati? apare kecid eṣa janaḥ keṣāñcid videśīyadevānāṁ pracāraka ityanumīyate yataḥ sa yīśum utthitiñca pracārayat| ");
INSERT INTO sanias_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","te tam areyapāganāma vicārasthānam ānīya prāvocan idaṁ yannavīnaṁ mataṁ tvaṁ prācīkaśa idaṁ kīdṛśaṁ etad asmān śrāvaya; ");
INSERT INTO sanias_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","yāmimām asambhavakathām asmākaṁ karṇagocarīkṛtavān asyā bhāvārthaḥ ka iti vayaṁ jñātum icchāmaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","tadāthīnīnivāsinastannagarapravāsinaśca kevalaṁ kasyāścana navīnakathāyāḥ śravaṇena pracāraṇena ca kālam ayāpayan| ");
INSERT INTO sanias_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","paulo'reyapāgasya madhye tiṣṭhan etāṁ kathāṁ pracāritavān, he āthīnīyalokā yūyaṁ sarvvathā devapūjāyām āsaktā ityaha pratyakṣaṁ paśyāmi| ");
INSERT INTO sanias_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","yataḥ paryyaṭanakāle yuṣmākaṁ pūjanīyāni paśyan ‘avijñāteśvarāya’ etallipiyuktāṁ yajñavedīmekāṁ dṛṣṭavān; ato na viditvā yaṁ pūjayadhve tasyaiva tatvaṁ yuṣmān prati pracārayāmi| ");
INSERT INTO sanias_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","jagato jagatsthānāṁ sarvvavastūnāñca sraṣṭā ya īśvaraḥ sa svargapṛthivyorekādhipatiḥ san karanirmmitamandireṣu na nivasati; ");
INSERT INTO sanias_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","sa eva sarvvebhyo jīvanaṁ prāṇān sarvvasāmagrīśca pradadāti; ataeva sa kasyāścit sāmagyrā abhāvaheto rmanuṣyāṇāṁ hastaiḥ sevito bhavatīti na| ");
INSERT INTO sanias_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","sa bhūmaṇḍale nivāsārtham ekasmāt śoṇitāt sarvvān manuṣyān sṛṣṭvā teṣāṁ pūrvvanirūpitasamayaṁ vasatisīmāñca niracinot; ");
INSERT INTO sanias_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","tasmāt lokaiḥ kenāpi prakāreṇa mṛgayitvā parameśvarasya tatvaṁ prāptuṁ tasya gaveṣaṇaṁ karaṇīyam| ");
INSERT INTO sanias_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","kintu so'smākaṁ kasmāccidapi dūre tiṣṭhatīti nahi, vayaṁ tena niśvasanapraśvasanagamanāgamanaprāṇadhāraṇāni kurmmaḥ, puुnaśca yuṣmākameva katipayāḥ kavayaḥ kathayanti ‘tasya vaṁśā vayaṁ smo hi’ iti| ");
INSERT INTO sanias_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","ataeva yadi vayam īśvarasya vaṁśā bhavāmastarhi manuṣyai rvidyayā kauśalena ca takṣitaṁ svarṇaṁ rūpyaṁ dṛṣad vaiteṣāmīśvaratvam asmābhi rna jñātavyaṁ| ");
INSERT INTO sanias_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","teṣāṁ pūrvvīyalokānām ajñānatāṁ pratīśvaro yadyapi nāvādhatta tathāpīdānīṁ sarvvatra sarvvān manaḥ parivarttayitum ājñāpayati, ");
INSERT INTO sanias_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","yataḥ svaniyuktena puruṣeṇa yadā sa pṛthivīsthānāṁ sarvvalokānāṁ vicāraṁ kariṣyati taddinaṁ nyarūpayat; tasya śmaśānotthāpanena tasmin sarvvebhyaḥ pramāṇaṁ prādāt| ");
INSERT INTO sanias_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","tadā śmaśānād utthānasya kathāṁ śrutvā kecid upāhaman, kecidavadan enāṁ kathāṁ punarapi tvattaḥ śroṣyāmaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","tataḥ paulasteṣāṁ samīpāt prasthiाtavān| ");
INSERT INTO sanias_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","tathāpi kecillokāstena sārddhaṁ militvā vyaśvasan teṣāṁ madhye 'reyapāgīyadiyanusiyo dāmārīnāmā kācinnārī kiyanto narāścāsan| ");
INSERT INTO sanias_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","tadghaṭanātaḥ paraṁ paula āthīnīnagarād yātrāṁ kṛtvā karinthanagaram āgacchat| ");
INSERT INTO sanias_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","tasmin samaye klaudiyaḥ sarvvān yihūdīyān romānagaraṁ vihāya gantum ājñāpayat, tasmāt priskillānāmnā jāyayā sārddham itāliyādeśāt kiñcitpūrvvam āgamat yaḥ pantadeśe jāta ākkilanāmā yihūdīyalokaḥ paulastaṁ sākṣāt prāpya tayoḥ samīpamitavān| ");
INSERT INTO sanias_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","tau dūṣyanirmmāṇajīvinau, tasmāt parasparam ekavṛttikatvāt sa tābhyāṁ saha uṣitvā tat karmmākarot| ");
INSERT INTO sanias_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","paulaḥ prativiśrāmavāraṁ bhajanabhavanaṁ gatvā vicāraṁ kṛtvā yihūdīyān anyadeśīyāṁśca pravṛttiṁ grāhitavān| ");
INSERT INTO sanias_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","sīlatīmathiyayo rmākidaniyādeśāt sametayoḥ satoḥ paula uttaptamanā bhūtvā yīśurīśvareṇābhiṣikto bhavatīti pramāṇaṁ yihūdīyānāṁ samīpe prādāt| ");
INSERT INTO sanias_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","kintu te 'tīva virodhaṁ vidhāya pāṣaṇḍīyakathāṁ kathitavantastataḥ paulo vastraṁ dhunvan etāṁ kathāṁ kathitavān, yuṣmākaṁ śoṇitapātāparādho yuṣmān pratyeva bhavatu, tenāhaṁ niraparādho 'dyārabhya bhinnadeśīyānāṁ samīpaṁ yāmi| ");
INSERT INTO sanias_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","sa tasmāt prasthāya bhajanabhavanasamīpasthasya yustanāmna īśvarabhaktasya bhinnadeśīyasya niveśanaṁ prāviśat| ");
INSERT INTO sanias_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","tataḥ krīṣpanāmā bhajanabhavanādhipatiḥ saparivāraḥ prabhau vyaśvasīt, karinthanagarīyā bahavo lokāśca samākarṇya viśvasya majjitā abhavan| ");
INSERT INTO sanias_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","kṣaṇadāyāṁ prabhuḥ paulaṁ darśanaṁ datvā bhāṣitavān, mā bhaiṣīḥ, mā nirasīḥ kathāṁ pracāraya| ");
INSERT INTO sanias_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ahaṁ tvayā sārddham āsa hiṁsārthaṁ kopi tvāṁ spraṣṭuṁ na śakṣyati nagare'smin madīyā lokā bahava āsate| ");
INSERT INTO sanias_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","tasmāt paulastannagare prāyeṇa sārddhavatsaraparyyantaṁ saṁsthāyeśvarasya kathām upādiśat| ");
INSERT INTO sanias_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","gālliyanāmā kaścid ākhāyādeśasya prāḍvivākaḥ samabhavat, tato yihūdīyā ekavākyāḥ santaḥ paulam ākramya vicārasthānaṁ nītvā ");
INSERT INTO sanias_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","mānuṣa eṣa vyavasthāya viruddham īśvarabhajanaṁ karttuṁ lokān kupravṛttiṁ grāhayatīti niveditavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","tataḥ paule pratyuttaraṁ dātum udyate sati gālliyā yihūdīyān vyāharat, yadi kasyacid anyāyasya vātiśayaduṣṭatācaraṇasya vicāro'bhaviṣyat tarhi yuṣmākaṁ kathā mayā sahanīyābhaviṣyat| ");
INSERT INTO sanias_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","kintu yadi kevalaṁ kathāyā vā nāmno vā yuṣmākaṁ vyavasthāyā vivādo bhavati tarhi tasya vicāramahaṁ na kariṣyāmi, yūyaṁ tasya mīmāṁsāṁ kuruta| ");
INSERT INTO sanias_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","tataḥ sa tān vicārasthānād dūrīkṛtavān| ");
INSERT INTO sanias_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","tadā bhinnadeśīyāḥ sosthinināmānaṁ bhajanabhavanasya pradhānādhipatiṁ dhṛtvā vicārasthānasya sammukhe prāharan tathāpi gālliyā teṣu sarvvakarmmasu na mano nyadadhāt| ");
INSERT INTO sanias_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","paulastatra punarbahudināni nyavasat, tato bhrātṛgaṇād visarjanaṁ prāpya kiñcanavratanimittaṁ kiṁkriyānagare śiro muṇḍayitvā priskillākkilābhyāṁ sahito jalapathena suriyādeśaṁ gatavān| ");
INSERT INTO sanias_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","tata iphiṣanagara upasthāya tatra tau visṛjya svayaṁ bhajanabhvanaṁ praviśya yihūdīyaiḥ saha vicāritavān| ");
INSERT INTO sanias_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","te svaiḥ sārddhaṁ punaḥ katipayadināni sthātuṁ taṁ vyanayan, sa tadanurarīkṛtya kathāmetāṁ kathitavān, ");
INSERT INTO sanias_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","yirūśālami āgāmyutsavapālanārthaṁ mayā gamanīyaṁ; paścād īśvarecchāyāṁ jātāyāṁ yuṣmākaṁ samīpaṁ pratyāgamiṣyāmi| tataḥ paraṁ sa tai rvisṛṣṭaḥ san jalapathena iphiṣanagarāt prasthitavān| ");
INSERT INTO sanias_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","tataḥ kaisariyām upasthitaḥ san nagaraṁ gatvā samājaṁ namaskṛtya tasmād āntiyakhiyānagaraṁ prasthitavān| ");
INSERT INTO sanias_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","tatra kiyatkālaṁ yāpayitvā tasmāt prasthāya sarvveṣāṁ śiṣyāṇāṁ manāṁsi susthirāṇi kṛtvā kramaśo galātiyāphrugiyādeśayo rbhramitvā gatavān| ");
INSERT INTO sanias_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","tasminneva samaye sikandariyānagare jāta āpallonāmā śāstravit suvaktā yihūdīya eko jana iphiṣanagaram āgatavān| ");
INSERT INTO sanias_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","sa śikṣitaprabhumārgo manasodyogī ca san yohano majjanamātraṁ jñātvā yathārthatayā prabhoḥ kathāṁ kathayan samupādiśat| ");
INSERT INTO sanias_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","eṣa jano nirbhayatvena bhajanabhavane kathayitum ārabdhavān, tataḥ priskillākkilau tasyopadeśakathāṁ niśamya taṁ svayoḥ samīpam ānīya śuddharūpeṇeśvarasya kathām abodhayatām| ");
INSERT INTO sanias_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","paścāt sa ākhāyādeśaṁ gantuṁ matiṁ kṛtavān, tadā tatratyaḥ śiṣyagaṇo yathā taṁ gṛhlāti tadarthaṁ bhrātṛgaṇena samāśvasya patre likhite sati, āpallāstatropasthitaḥ san anugraheṇa pratyayināṁ bahūpakārān akarot, ");
INSERT INTO sanias_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","phalato yīśurabhiṣiktastrāteti śāstrapramāṇaṁ datvā prakāśarūpeṇa pratipannaṁ kṛtvā yihūdīyān niruttarān kṛtavān| ");
INSERT INTO sanias_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","karinthanagara āpallasaḥ sthitikāle paula uttarapradeśairāgacchan iphiṣanagaram upasthitavān| tatra katipayaśiṣyān sākṣat prāpya tān apṛcchat, ");
INSERT INTO sanias_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","yūyaṁ viśvasya pavitramātmānaṁ prāptā na vā? tataste pratyavadan pavitra ātmā dīyate ityasmābhiḥ śrutamapi nahi| ");
INSERT INTO sanias_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","tadā sā'vadat tarhi yūyaṁ kena majjitā abhavata? te'kathayan yohano majjanena| ");
INSERT INTO sanias_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","tadā paula uktavān itaḥ paraṁ ya upasthāsyati tasmin arthata yīśukhrīṣṭe viśvasitavyamityuktvā yohan manaḥparivarttanasūcakena majjanena jale lokān amajjayat| ");
INSERT INTO sanias_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","tādṛśīṁ kathāṁ śrutvā te prabho ryīśukhrīṣṭasya nāmnā majjitā abhavan| ");
INSERT INTO sanias_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","tataḥ paulena teṣāṁ gātreṣu kare'rpite teṣāmupari pavitra ātmāvarūḍhavān, tasmāt te nānādeśīyā bhāṣā bhaviṣyatkathāśca kathitavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","te prāyeṇa dvādaśajanā āsan| ");
INSERT INTO sanias_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","paulo bhajanabhavanaṁ gatvā prāyeṇa māsatrayam īśvarasya rājyasya vicāraṁ kṛtvā lokān pravartya sāhasena kathāmakathayat| ");
INSERT INTO sanias_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","kintu kaṭhināntaḥkaraṇatvāt kiyanto janā na viśvasya sarvveṣāṁ samakṣam etatpathasya nindāṁ karttuṁ pravṛttāḥ, ataḥ paulasteṣāṁ samīpāt prasthāya śiṣyagaṇaṁ pṛthakkṛtvā pratyahaṁ turānnanāmnaḥ kasyacit janasya pāṭhaśālāyāṁ vicāraṁ kṛtavān| ");
INSERT INTO sanias_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","itthaṁ vatsaradvayaṁ gataṁ tasmād āśiyādeśanivāsinaḥ sarvve yihūdīyā anyadeśīyalokāśca prabho ryīśoḥ kathām aśrauṣan| ");
INSERT INTO sanias_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","paulena ca īśvara etādṛśānyadbhutāni karmmāṇi kṛtavān ");
INSERT INTO sanias_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","yat paridheye gātramārjanavastre vā tasya dehāt pīḍitalokānām samīpam ānīte te nirāmayā jātā apavitrā bhūtāśca tebhyo bahirgatavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","tadā deśāṭanakāriṇaḥ kiyanto yihūdīyā bhūtāpasāriṇo bhūtagrastanokānāṁ sannidhau prabhe ryīśo rnāma japtvā vākyamidam avadan, yasya kathāṁ paulaḥ pracārayati tasya yīśo rnāmnā yuṣmān ājñāpayāmaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","skivanāmno yihūdīyānāṁ pradhānayājakasya saptabhiḥ puttaistathā kṛte sati ");
INSERT INTO sanias_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","kaścid apavitro bhūtaḥ pratyuditavān, yīśuṁ jānāmi paulañca paricinomi kintu ke yūyaṁ? ");
INSERT INTO sanias_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ityuktvā sopavitrabhūtagrasto manuṣyo lamphaṁ kṛtvā teṣāmupari patitvā balena tān jitavān, tasmātte nagnāḥ kṣatāṅgāśca santastasmād gehāt palāyanta| ");
INSERT INTO sanias_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","sā vāg iphiṣanagaranivāsinasaṁ sarvveṣāṁ yihūdīyānāṁ bhinnadeśīyānāṁ lokānāñca śravogocarībhūtā; tataḥ sarvve bhayaṁ gatāḥ prabho ryīśo rnāmno yaśo 'varddhata| ");
INSERT INTO sanias_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","yeṣāmanekeṣāṁ lokānāṁ pratītirajāyata ta āgatya svaiḥ kṛtāḥ kriyāḥ prakāśarūpeṇāṅgīkṛtavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","bahavo māyākarmmakāriṇaḥ svasvagranthān ānīya rāśīkṛtya sarvveṣāṁ samakṣam adāhayan, tato gaṇanāṁ kṛtvābudhyanta pañcāyutarūpyamudrāmūlyapustakāni dagdhāni| ");
INSERT INTO sanias_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","itthaṁ prabhoḥ kathā sarvvadeśaṁ vyāpya prabalā jātā| ");
INSERT INTO sanias_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","sarvveṣveteṣu karmmasu sampanneṣu satsu paulo mākidaniyākhāyādeśābhyāṁ yirūśālamaṁ gantuṁ matiṁ kṛtvā kathitavān tatsthānaṁ yātrāyāṁ kṛtāyāṁ satyāṁ mayā romānagaraṁ draṣṭavyaṁ| ");
INSERT INTO sanias_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","svānugatalokānāṁ tīmathiyerāstau dvau janau mākidaniyādeśaṁ prati prahitya svayam āśiyādeśe katipayadināni sthitavān| ");
INSERT INTO sanias_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","kintu tasmin samaye mate'smin kalaho jātaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","tatkāraṇamidaṁ, arttimīdevyā rūpyamandiranirmmāṇena sarvveṣāṁ śilpināṁ yatheṣṭalābham ajanayat yo dīmītriyanāmā nāḍīndhamaḥ ");
INSERT INTO sanias_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","sa tān tatkarmmajīvinaḥ sarvvalokāṁśca samāhūya bhāṣitavān he mahecchā etena mandiranirmmāṇenāsmākaṁ jīvikā bhavati, etad yūyaṁ vittha; ");
INSERT INTO sanias_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","kintu hastanirmmiteśvarā īśvarā nahi paulanāmnā kenacijjanena kathāmimāṁ vyāhṛtya kevalephiṣanagare nahi prāyeṇa sarvvasmin āśiyādeśe pravṛttiṁ grāhayitvā bahulokānāṁ śemuṣī parāvarttitā, etad yuṣmābhi rdṛśyate śrūyate ca| ");
INSERT INTO sanias_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","tenāsmākaṁ vāṇijyasya sarvvathā hāneḥ sambhavanaṁ kevalamiti nahi, āśiyādeśasthai rvā sarvvajagatsthai rlokaiḥ pūjyā yārtimī mahādevī tasyā mandirasyāvajñānasya tasyā aiśvaryyasya nāśasya ca sambhāvanā vidyateे| ");
INSERT INTO sanias_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","etādṛśīṁ kathāṁ śrutvā te mahākrodhānvitāḥ santa uccaiḥkāraṁ kathitavanta iphiṣīyānām arttimī devī mahatī bhavati| ");
INSERT INTO sanias_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","tataḥ sarvvanagaraṁ kalahena paripūrṇamabhavat, tataḥ paraṁ te mākidanīyagāyāristārkhanāmānau paulasya dvau sahacarau dhṛtvaikacittā raṅgabhūmiṁ javena dhāvitavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","tataḥ paulo lokānāṁ sannidhiṁ yātum udyatavān kintu śiṣyagaṇastaṁ vāritavān| ");
INSERT INTO sanias_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","paulasyatmīyā āśiyādeśasthāḥ katipayāḥ pradhānalokāstasya samīpaṁ naramekaṁ preṣya tvaṁ raṅgabhūmiṁ māgā iti nyavedayan| ");
INSERT INTO sanias_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","tato nānālokānāṁ nānākathākathanāt sabhā vyākulā jātā kiṁ kāraṇād etāvatī janatābhavat etad adhikai rlokai rnājñāyi| ");
INSERT INTO sanias_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","tataḥ paraṁ janatāmadhyād yihūdīyairbahiṣkṛtaḥ sikandaro hastena saṅketaṁ kṛtvā lokebhya uttaraṁ dātumudyatavān, ");
INSERT INTO sanias_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","kintu sa yihūdīyaloka iti niścite sati iphiṣīyānām arttimī devī mahatīti vākyaṁ prāyeṇa pañca daṇḍān yāvad ekasvareṇa lokanivahaiḥ proktaṁ| ");
INSERT INTO sanias_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","tato nagarādhipatistān sthirān kṛtvā kathitavān he iphiṣāyāḥ sarvve lokā ākarṇayata, artimīmahādevyā mahādevāt patitāyāstatpratimāyāśca pūjanama iphiṣanagarasthāḥ sarvve lokāḥ kurvvanti, etat ke na jānanti? ");
INSERT INTO sanias_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","tasmād etatpratikūlaṁ kepi kathayituṁ na śaknuvanti, iti jñātvā yuṣmābhiḥ susthiratvena sthātavyam avivicya kimapi karmma na karttavyañca| ");
INSERT INTO sanias_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","yān etān manuṣyān yūyamatra samānayata te mandiradravyāpahārakā yuṣmākaṁ devyā nindakāśca na bhavanti| ");
INSERT INTO sanias_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","yadi kañcana prati dīmītriyasya tasya sahāyānāñca kācid āpatti rvidyate tarhi pratinidhilokā vicārasthānañca santi, te tat sthānaṁ gatvā uttarapratyuttare kurvvantu| ");
INSERT INTO sanias_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","kintu yuṣmākaṁ kācidaparā kathā yadi tiṣṭhati tarhi niyamitāyāṁ sabhāyāṁ tasyā niṣpatti rbhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","kintvetasya virodhasyottaraṁ yena dātuṁ śaknum etādṛśasya kasyacit kāraṇasyābhāvād adyatanaghaṭanāheto rājadrohiṇāmivāsmākam abhiyogo bhaviṣyatīti śaṅkā vidyate| ");
INSERT INTO sanias_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","iti kathayitvā sa sabhāsthalokān visṛṣṭavān| ");
INSERT INTO sanias_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","itthaṁ kalahe nivṛtte sati paulaḥ śiṣyagaṇam āhūya visarjanaṁ prāpya mākidaniyādeśaṁ prasthitavān| ");
INSERT INTO sanias_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","tena sthānena gacchan taddeśīyān śiṣyān bahūpadiśya yūnānīyadeśam upasthitavān| ");
INSERT INTO sanias_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","tatra māsatrayaṁ sthitvā tasmāt suriyādeśaṁ yātum udyataḥ, kintu yihūdīyāstaṁ hantuṁ guptā atiṣṭhan tasmāt sa punarapi mākidaniyāmārgeṇa pratyāgantuṁ matiṁ kṛtavān| ");
INSERT INTO sanias_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","birayānagarīyasopātraḥ thiṣalanīkīyāristārkhasikundau darbbonagarīyagāyatīmathiyau āśiyādeśīyatukhikatraphimau ca tena sārddhaṁ āśiyādeśaṁ yāvad gatavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ete sarvve 'grasarāḥ santo 'smān apekṣya troyānagare sthitavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","kiṇvaśūnyapūpotsavadine ca gate sati vayaṁ philipīnagarāt toyapathena gatvā pañcabhi rdinaistroyānagaram upasthāya tatra saptadinānyavātiṣṭhāma| ");
INSERT INTO sanias_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","saptāhasya prathamadine pūpān bhaṁktu śiṣyeṣu militeṣu paulaḥ paradine tasmāt prasthātum udyataḥ san tadahni prāyeṇa kṣapāyā yāmadvayaṁ yāvat śiṣyebhyo dharmmakathām akathayat| ");
INSERT INTO sanias_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","uparisthe yasmin prakoṣṭhe sabhāṁ kṛtvāsan tatra bahavaḥ pradīpāḥ prājvalan| ");
INSERT INTO sanias_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","utukhanāmā kaścana yuvā ca vātāyana upaviśan ghorataranidrāgrasto 'bhūt tadā paulena bahukṣaṇaṁ kathāyāṁ pracāritāyāṁ nidrāmagnaḥ sa tasmād uparisthatṛtīyaprakoṣṭhād apatat, tato lokāstaṁ mṛtakalpaṁ dhṛtvodatolayan| ");
INSERT INTO sanias_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","tataḥ paulo'varuhya tasya gātre patitvā taṁ kroḍe nidhāya kathitavān, yūyaṁ vyākulā mā bhūta nāyaṁ prāṇai rviyuktaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","paścāt sa punaścopari gatvā pūpān bhaṁktvā prabhātaṁ yāvat kathopakathane kṛtvā prasthitavān| ");
INSERT INTO sanias_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","te ca taṁ jīvantaṁ yuvānaṁ gṛhītvā gatvā paramāpyāyitā jātāḥ| ");
INSERT INTO sanias_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","anantaraṁ vayaṁ potenāgrasarā bhūtvāsmanagaram uttīryya paulaṁ grahītuṁ matim akurmma yataḥ sa tatra padbhyāṁ vrajituṁ matiṁ kṛtveti nirūpitavān| ");
INSERT INTO sanias_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","tasmāt tatrāsmābhiḥ sārddhaṁ tasmin milite sati vayaṁ taṁ nītvā mitulīnyupadvīpaṁ prāptavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","tasmāt potaṁ mocayitvā pare'hani khīyopadvīpasya sammukhaṁ labdhavantastasmād ekenāhnā sāmopadvīpaṁ gatvā potaṁ lāgayitvā trogulliye sthitvā parasmin divaseे milītanagaram upātiṣṭhāma| ");
INSERT INTO sanias_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","yataḥ paula āśiyādeśe kālaṁ yāpayitum nābhilaṣan iphiṣanagaraṁ tyaktvā yātuṁ mantraṇāṁ sthirīkṛtavān; yasmād yadi sādhyaṁ bhavati tarhi nistārotsavasya pañcāśattamadine sa yirūśālamyupasthātuṁ matiṁ kṛtavān| ");
INSERT INTO sanias_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","paulo milītād iphiṣaṁ prati lokaṁ prahitya samājasya prācīnān āhūyānītavān| ");
INSERT INTO sanias_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","teṣu tasya samīpam upasthiteṣu sa tebhya imāṁ kathāṁ kathitavān, aham āśiyādeśe prathamāgamanam ārabhyādya yāvad yuṣmākaṁ sannidhau sthitvā sarvvasamaye yathācaritavān tad yūyaṁ jānītha; ");
INSERT INTO sanias_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","phalataḥ sarvvathā namramanāḥ san bahuśrupātena yihudīyānām kumantraṇājātanānāparīkṣābhiḥ prabhoḥ sevāmakaravaṁ| ");
INSERT INTO sanias_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","kāmapi hitakathāाṁ na gopāyitavān tāṁ pracāryya saprakāśaṁ gṛhe gṛhe samupadiśyeśvaraṁ prati manaḥ parāvarttanīyaṁ prabhau yīśukhrīṣṭe viśvasanīyaṁ ");
INSERT INTO sanias_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","yihūdīyānām anyadeśīyalokānāñca samīpa etādṛśaṁ sākṣyaṁ dadāmi| ");
INSERT INTO sanias_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","paśyata sāmpratam ātmanākṛṣṭaḥ san yirūśālamnagare yātrāṁ karomi, tatra māmprati yadyad ghaṭiṣyate tānyahaṁ na jānāmi; ");
INSERT INTO sanias_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","kintu mayā bandhanaṁ kleśaśca bhoktavya iti pavitra ātmā nagare nagare pramāṇaṁ dadāti| ");
INSERT INTO sanias_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","tathāpi taṁ kleśamahaṁ tṛṇāya na manye; īśvarasyānugrahaviṣayakasya susaṁvādasya pramāṇaṁ dātuṁ, prabho ryīśoḥ sakāśāda yasyāḥ sevāyāḥ bhāraṁ prāpnavaṁ tāṁ sevāṁ sādhayituṁ sānandaṁ svamārgaṁ samāpayituुñca nijaprāṇānapi priyān na manye| ");
INSERT INTO sanias_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","adhunā paśyata yeṣāṁ samīpe'ham īśvarīyarājyasya susaṁvādaṁ pracāryya bhramaṇaṁ kṛtavān etādṛśā yūyaṁ mama vadanaṁ puna rdraṣṭuṁ na prāpsyatha etadapyahaṁ jānāmi| ");
INSERT INTO sanias_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","yuṣmabhyam aham īśvarasya sarvvān ādeśān prakāśayituṁ na nyavartte| ");
INSERT INTO sanias_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","ahaṁ sarvveṣāṁ lokānāṁ raktapātadoṣād yannirdoṣa āse tasyādya yuṣmān sākṣiṇaḥ karomi| ");
INSERT INTO sanias_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","yūyaṁ sveṣu tathā yasya vrajasyādhyakṣan ātmā yuṣmān vidhāya nyayuṅkta tatsarvvasmin sāvadhānā bhavata, ya samājañca prabhu rnijaraktamūlyena krītavāna tam avata, ");
INSERT INTO sanias_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","yato mayā gamane kṛtaeva durjayā vṛkā yuṣmākaṁ madhyaṁ praviśya vrajaṁ prati nirdayatām ācariṣyanti, ");
INSERT INTO sanias_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","yuṣmākameva madhyādapi lokā utthāya śiṣyagaṇam apahantuṁ viparītam upadekṣyantītyahaṁ jānāmi| ");
INSERT INTO sanias_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","iti heto ryūyaṁ sacaitanyāḥ santastiṣṭata, ahañca sāśrupātaḥ san vatsaratrayaṁ yāvad divāniśaṁ pratijanaṁ bodhayituṁ na nyavartte tadapi smarata| ");
INSERT INTO sanias_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","idānīṁ he bhrātaro yuṣmākaṁ niṣṭhāṁ janayituṁ pavitrīkṛtalokānāṁ madhye'dhikārañca dātuṁ samartho ya īśvarastasyānugrahasya yo vādaśca tayorubhayo ryuṣmān samārpayam| ");
INSERT INTO sanias_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","kasyāpi svarṇaṁ rūpyaṁ vastraṁ vā prati mayā lobho na kṛtaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","kintu mama matsahacaralokānāñcāvaśyakavyayāya madīyamidaṁ karadvayam aśrāmyad etad yūyaṁ jānītha| ");
INSERT INTO sanias_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","anena prakāreṇa grahaṇad dānaṁ bhadramiti yadvākyaṁ prabhu ryīśuḥ kathitavān tat smarttuṁ daridralokānāmupakārārthaṁ śramaṁ karttuñca yuṣmākam ucitam etatsarvvaṁ yuṣmānaham upadiṣṭavān| ");
INSERT INTO sanias_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","etāṁ kathāṁ kathayitvā sa jānunī pātayitvā sarvaiḥ saha prārthayata| ");
INSERT INTO sanias_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","tena te krandrantaḥ ");
INSERT INTO sanias_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","puna rmama mukhaṁ na drakṣyatha viśeṣata eṣā yā kathā tenākathi tatkāraṇāt śokaṁ vilāpañca kṛtvā kaṇṭhaṁ dhṛtvā cumbitavantaḥ| paścāt te taṁ potaṁ nītavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","tai rvisṛṣṭāḥ santo vayaṁ potaṁ bāhayitvā ṛjumārgeṇa koṣam upadvīpam āgatya pare'hani rodiyopadvīpam āgacchāma tatastasmāt pātārāyām upātiṣṭhāma| ");
INSERT INTO sanias_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","tatra phainīkiyādeśagāminam potamekaṁ prāpya tamāruhya gatavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","kupropadvīpaṁ dṛṣṭvā taṁ savyadiśi sthāpayitvā suriyādeśaṁ gatvā potasthadravyāṇyavarohayituṁ soranagare lāgitavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","tatra śiṣyagaṇasya sākṣātkaraṇāya vayaṁ tatra saptadināni sthitavantaḥ paścātte pavitreṇātmanā paulaṁ vyāharan tvaṁ yirūśālamnagaraṁ mā gamaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","tatasteṣu saptasu dineṣu yāpiteṣu satsu vayaṁ tasmāt sthānāt nijavartmanā gatavantaḥ, tasmāt te sabālavṛddhavanitā asmābhiḥ saha nagarasya parisaraparyyantam āgatāḥ paścādvayaṁ jaladhitaṭe jānupātaṁ prārthayāmahi| ");
INSERT INTO sanias_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","tataḥ parasparaṁ visṛṣṭāḥ santo vayaṁ potaṁ gatāste tu svasvagṛhaṁ pratyāgatavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","vayaṁ soranagarāt nāvā prasthāya talimāyinagaram upātiṣṭhāma tatrāsmākaṁ samudrīyamārgasyānto'bhavat tatra bhrātṛgaṇaṁ namaskṛtya dinamekaṁ taiḥ sārddham uṣatavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","pare 'hani paulastasya saṅgino vayañca pratiṣṭhamānāḥ kaisariyānagaram āgatya susaṁvādapracārakānāṁ saptajanānāṁ philipanāmna ekasya gṛhaṁ praviśyāvatiṣṭhāma| ");
INSERT INTO sanias_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","tasya catasro duhitaro'nūḍhā bhaviṣyadvādinya āsan| ");
INSERT INTO sanias_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","tatrāsmāsu bahudināni proṣiteṣu yihūdīyadeśād āgatyāgābanāmā bhaviṣyadvādī samupasthitavān| ");
INSERT INTO sanias_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","sosmākaṁ samīpametya paulasya kaṭibandhanaṁ gṛhītvā nijahastāpādān baddhvā bhāṣitavān yasyedaṁ kaṭibandhanaṁ taṁ yihūdīyalokā yirūśālamanagara itthaṁ baddhvā bhinnadeśīyānāṁ kareṣu samarpayiṣyantīti vākyaṁ pavitra ātmā kathayati| ");
INSERT INTO sanias_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","etādṛśīṁ kathāṁ śrutvā vayaṁ tannagaravāsino bhrātaraśca yirūśālamaṁ na yātuṁ paulaṁ vyanayāmahi; ");
INSERT INTO sanias_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","kintu sa pratyāvādīt, yūyaṁ kiṁ kurutha? kiṁ krandanena mamāntaḥkaraṇaṁ vidīrṇaṁ kariṣyatha? prabho ryīśo rnāmno nimittaṁ yirūśālami baddho bhavituṁ kevala tanna prāṇān dātumapi sasajjosmi| ");
INSERT INTO sanias_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","tenāsmākaṁ kathāyām agṛhītāyām īśvarasya yathecchā tathaiva bhavatvityuktvā vayaṁ nirasyāma| ");
INSERT INTO sanias_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","pare'hani pātheyadravyāṇi gṛhītvā yirūśālamaṁ prati yātrām akurmma| ");
INSERT INTO sanias_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","tataḥ kaisariyānagaranivāsinaḥ katipayāḥ śiṣyā asmābhiḥ sārddham itvā kṛprīyena mnāsannāmnā yena prācīnaśiṣyena sārddham asmābhi rvastavyaṁ tasya samīpam asmān nītavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","asmāsu yirūśālamyupasthiteṣu tatrasthabhrātṛgaṇo'smān āhlādena gṛhītavān| ");
INSERT INTO sanias_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","parasmin divase paule'smābhiḥ saha yākūbo gṛhaṁ praviṣṭe lokaprācīnāḥ sarvve tatra pariṣadi saṁsthitāḥ| ");
INSERT INTO sanias_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","anantaraṁ sa tān natvā svīyapracāraṇena bhinnadeśīyān pratīśvaro yāni karmmāṇi sādhitavān tadīyāṁ kathām anukramāt kathitavān| ");
INSERT INTO sanias_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","iti śrutvā te prabhuṁ dhanyaṁ procya vākyamidam abhāṣanta, he bhrāta ryihūdīyānāṁ madhye bahusahasrāṇi lokā viśvāsina āsate kintu te sarvve vyavasthāmatācāriṇa etat pratyakṣaṁ paśyasi| ");
INSERT INTO sanias_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","śiśūnāṁ tvakchedanādyācaraṇaṁ pratiṣidhya tvaṁ bhinnadeśanivāsino yihūdīyalokān mūsāvākyam aśraddhātum upadiśasīti taiḥ śrutamasti| ");
INSERT INTO sanias_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","tvamatrāgatosīti vārttāṁ samākarṇya jananivaho militvāvaśyamevāgamiṣyati; ataeva kiṁ karaṇīyam? atra vayaṁ mantrayitvā samupāyaṁ tvāṁ vadāmastaṁ tvamācara| ");
INSERT INTO sanias_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","vrataṁ karttuṁ kṛtasaṅkalpā ye'smāṁka catvāro mānavāḥ santi ");
INSERT INTO sanias_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","tān gṛhītvā taiḥ sahitaḥ svaṁ śuciṁ kuru tathā teṣāṁ śiromuṇḍane yo vyayo bhavati taṁ tvaṁ dehi| tathā kṛte tvadīyācāre yā janaśruti rjāyate sālīkā kintu tvaṁ vidhiṁ pālayan vyavasthānusāreṇevācarasīti te bhotsante| ");
INSERT INTO sanias_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","bhinnadeśīyānāṁ viśvāsilokānāṁ nikaṭe vayaṁ patraṁ likhitvetthaṁ sthirīkṛtavantaḥ, devaprasādabhojanaṁ raktaṁ galapīḍanamāritaprāṇibhojanaṁ vyabhicāraścaitebhyaḥ svarakṣaṇavyatirekeṇa teṣāmanyavidhipālanaṁ karaṇīyaṁ na| ");
INSERT INTO sanias_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","tataḥ paulastān mānuṣānādāya parasmin divase taiḥ saha śuci rbhūtvā mandiraṁ gatvā śaucakarmmaṇo dineṣu sampūrṇeṣu teṣām ekaikārthaṁ naivedyādyutsargo bhaviṣyatīti jñāpitavān| ");
INSERT INTO sanias_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","teṣu saptasu dineṣu samāptakalpeṣu āśiyādeśanivāsino yihūdīyāstaṁ madhyemandiraṁ vilokya jananivahasya manaḥsu kupravṛttiṁ janayitvā taṁ dhṛtvā ");
INSERT INTO sanias_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","proccaiḥ prāvocan, he isrāyellokāḥ sarvve sāhāyyaṁ kuruta| yo manuja eteṣāṁ lokānāṁ mūsāvyavasthāyā etasya sthānasyāpi viparītaṁ sarvvatra sarvvān śikṣayati sa eṣaḥ; viśeṣataḥ sa bhinnadeśīyalokān mandiram ānīya pavitrasthānametad apavitramakarot| ");
INSERT INTO sanias_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","pūrvvaṁ te madhyenagaram iphiṣanagarīyaṁ traphimaṁ paulena sahitaṁ dṛṣṭavanta etasmāt paulastaṁ mandiramadhyam ānayad ityanvamimata| ");
INSERT INTO sanias_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","ataeva sarvvasmin nagare kalahotpannatvāt dhāvanto lokā āgatya paulaṁ dhṛtvā mandirasya bahirākṛṣyānayan tatkṣaṇād dvārāṇi sarvvāṇi ca ruddhāni| ");
INSERT INTO sanias_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","teṣu taṁ hantumudyateेṣu yirūśālamnagare mahānupadravo jāta iti vārttāyāṁ sahasrasenāpateḥ karṇagocarībhūtāyāṁ satyāṁ sa tatkṣaṇāt sainyāni senāpatigaṇañca gṛhītvā javenāgatavān| ");
INSERT INTO sanias_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","tato lokāḥ senāgaṇena saha sahasrasenāpatim āgacchantaṁ dṛṣṭvā paulatāḍanāto nyavarttanta| ");
INSERT INTO sanias_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","sa sahasrasenāpatiḥ sannidhāvāgamya paulaṁ dhṛtvā śṛṅkhaladvayena baddham ādiśya tān pṛṣṭavān eṣa kaḥ? kiṁ karmma cāyaṁ kṛtavān? ");
INSERT INTO sanias_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","tato janasamūhasya kaścid ekaprakāraṁ kaścid anyaprakāraṁ vākyam araut sa tatra satyaṁ jñātum kalahakāraṇād aśaktaḥ san taṁ durgaṁ netum ājñāpayat| ");
INSERT INTO sanias_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","teṣu sopānasyopari prāpteṣu lokānāṁ sāhasakāraṇāt senāgaṇaḥ paulamuttolya nītavān| ");
INSERT INTO sanias_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","tataḥ sarvve lokāḥ paścādgāminaḥ santa enaṁ durīkuruteti vākyam uccairavadan| ");
INSERT INTO sanias_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","paulasya durgānayanasamaye sa tasmai sahasrasenāpataye kathitavān, bhavataḥ purastāt kathāṁ kathayituṁ kim anumanyate? sa tamapṛcchat tvaṁ kiṁ yūnānīyāṁ bhāṣāṁ jānāsi? ");
INSERT INTO sanias_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","yo misarīyo janaḥ pūrvvaṁ virodhaṁ kṛtvā catvāri sahasrāṇi ghātakān saṅginaḥ kṛtvā vipinaṁ gatavān tvaṁ kiṁ saeva na bhavasi? ");
INSERT INTO sanias_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","tadā paulo'kathayat ahaṁ kilikiyādeśasya tārṣanagarīyo yihūdīyo, nāhaṁ sāmānyanagarīyo mānavaḥ; ataeva vinaye'haṁ lākānāṁ samakṣaṁ kathāṁ kathayituṁ māmanujānīṣva| ");
INSERT INTO sanias_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","tenānujñātaḥ paulaḥ sopānopari tiṣṭhan hasteneṅgitaṁ kṛtavān, tasmāt sarvve susthirā abhavan| tadā paula ibrīyabhāṣayā kathayitum ārabhata, ");
INSERT INTO sanias_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","he pitṛgaṇā he bhrātṛgaṇāḥ, idānīṁ mama nivedane samavadhatta| ");
INSERT INTO sanias_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","tadā sa ibrīyabhāṣayā kathāṁ kathayatīti śrutvā sarvve lokā atīva niḥśabdā santo'tiṣṭhan| ");
INSERT INTO sanias_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","paścāt so'kathayad ahaṁ yihūdīya iti niścayaḥ kilikiyādeśasya tārṣanagaraṁ mama janmabhūmiḥ,etannagarīyasya gamilīyelanāmno'dhyāpakasya śiṣyo bhūtvā pūrvvapuruṣāṇāṁ vidhivyavasthānusāreṇa sampūrṇarūpeṇa śikṣito'bhavam idānīntanā yūyaṁ yādṛśā bhavatha tādṛśo'hamapīśvarasevāyām udyogī jātaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","matametad dviṣṭvā tadgrāhinārīpuruṣān kārāyāṁ baddhvā teṣāṁ prāṇanāśaparyyantāṁ vipakṣatām akaravam| ");
INSERT INTO sanias_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","mahāyājakaḥ sabhāsadaḥ prācīnalokāśca mamaitasyāḥ kathāyāḥ pramāṇaṁ dātuṁ śaknuvanti, yasmāt teṣāṁ samīpād dammeṣakanagaranivāsibhrātṛgaṇārtham ājñāpatrāṇi gṛhītvā ye tatra sthitāstān daṇḍayituṁ yirūśālamam ānayanārthaṁ dammeṣakanagaraṁ gatosmi| ");
INSERT INTO sanias_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","kintu gacchan tannagarasya samīpaṁ prāptavān tadā dvitīyapraharavelāyāṁ satyām akasmād gagaṇānnirgatya mahatī dīpti rmama caturdiśi prakāśitavatī| ");
INSERT INTO sanias_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","tato mayi bhūmauै patite sati, he śaula he śaula kuto māṁ tāḍayasi? māmprati bhāṣita etādṛśa eko ravopi mayā śrutaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","tadāhaṁ pratyavadaṁ, he prabhe ko bhavān? tataḥ so'vādīt yaṁ tvaṁ tāḍayasi sa nāsaratīyo yīśurahaṁ| ");
INSERT INTO sanias_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","mama saṅgino lokāstāṁ dīptiṁ dṛṣṭvā bhiyaṁ prāptāḥ, kintu māmpratyuditaṁ tadvākyaṁ teे nābudhyanta| ");
INSERT INTO sanias_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","tataḥ paraṁ pṛṣṭavānahaṁ, he prabho mayā kiṁ karttavyaṁ? tataḥ prabhurakathayat, utthāya dammeṣakanagaraṁ yāhi tvayā yadyat karttavyaṁ nirūpitamāste tat tatra tvaṁ jñāpayiṣyase| ");
INSERT INTO sanias_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","anantaraṁ tasyāḥ kharataradīpteḥ kāraṇāt kimapi na dṛṣṭvā saṅgigaṇena dhṛtahastaḥ san dammeṣakanagaraṁ vrajitavān| ");
INSERT INTO sanias_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","tannagaranivāsināṁ sarvveṣāṁ yihūdīyānāṁ mānyo vyavasthānusāreṇa bhaktaśca hanānīyanāmā mānava eko ");
INSERT INTO sanias_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","mama sannidhim etya tiṣṭhan akathayat, he bhrātaḥ śaula sudṛṣṭi rbhava tasmin daṇḍe'haṁ samyak taṁ dṛṣṭavān| ");
INSERT INTO sanias_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","tataḥ sa mahyaṁ kathitavān yathā tvam īśvarasyābhiprāyaṁ vetsi tasya śuddhasattvajanasya darśanaṁ prāpya tasya śrīmukhasya vākyaṁ śṛṇoṣi tannimittam asmākaṁ pūrvvapuruṣāṇām īśvarastvāṁ manonītaṁ kṛtavānaṁ| ");
INSERT INTO sanias_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","yato yadyad adrākṣīraśrauṣīśca sarvveṣāṁ mānavānāṁ samīpe tvaṁ teṣāṁ sākṣī bhaviṣyasi| ");
INSERT INTO sanias_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","ataeva kuto vilambase? prabho rnāmnā prārthya nijapāpaprakṣālanārthaṁ majjanāya samuttiṣṭha| ");
INSERT INTO sanias_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","tataḥ paraṁ yirūśālamnagaraṁ pratyāgatya mandire'ham ekadā prārthaye, tasmin samaye'ham abhibhūtaḥ san prabhūṁ sākṣāt paśyan, ");
INSERT INTO sanias_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","tvaṁ tvarayā yirūśālamaḥ pratiṣṭhasva yato lokāmayi tava sākṣyaṁ na grahīṣyanti, māmpratyuditaṁ tasyedaṁ vākyam aśrauṣam| ");
INSERT INTO sanias_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","tatohaṁ pratyavādiṣam he prabho pratibhajanabhavanaṁ tvayi viśvāsino lokān baddhvā prahṛtavān, ");
INSERT INTO sanias_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","tathā tava sākṣiṇaḥ stiphānasya raktapātanasamaye tasya vināśaṁ sammanya sannidhau tiṣṭhan hantṛlokānāṁ vāsāṁsi rakṣitavān, etat te viduḥ| ");
INSERT INTO sanias_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","tataḥ so'kathayat pratiṣṭhasva tvāṁ dūrasthabhinnadeśīyānāṁ samīpaṁ preṣayiṣye| ");
INSERT INTO sanias_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","tadā lokā etāvatparyyantāṁ tadīyāṁ kathāṁ śrutvā proccairakathayan, enaṁ bhūmaṇḍalād dūrīkuruta, etādṛśajanasya jīvanaṁ nocitam| ");
INSERT INTO sanias_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ityuccaiḥ kathayitvā vasanāni parityajya gagaṇaṁ prati dhūlīrakṣipan ");
INSERT INTO sanias_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","tataḥ sahasrasenāpatiḥ paulaṁ durgābhyantara netuṁ samādiśat| etasya pratikūlāḥ santo lokāḥ kinnimittam etāvaduccaiḥsvaram akurvvan, etad vettuṁ taṁ kaśayā prahṛtya tasya parīkṣāṁ karttumādiśat| ");
INSERT INTO sanias_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","padātayaścarmmanirmmitarajjubhistasya bandhanaṁ karttumudyatāstāstadānīṁ paulaḥ sammukhasthitaṁ śatasenāpatim uktavān daṇḍājñāyām aprāptāyāṁ kiṁ romilokaṁ praharttuṁ yuṣmākam adhikārosti? ");
INSERT INTO sanias_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","enāṁ kathāṁ śrutvā sa sahasrasenāpateḥ sannidhiṁ gatvā tāṁ vārttāmavadat sa romiloka etasmāt sāvadhānaḥ san karmma kuru| ");
INSERT INTO sanias_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","tasmāt sahasrasenāpati rgatvā tamaprākṣīt tvaṁ kiṁ romilokaḥ? iti māṁ brūhi| so'kathayat satyam| ");
INSERT INTO sanias_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","tataḥ sahasrasenāpatiḥ kathitavān bahudraviṇaṁ dattvāhaṁ tat paurasakhyaṁ prāptavān; kintu paulaḥ kathitavān ahaṁ janunā tat prāpto'smi| ");
INSERT INTO sanias_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","itthaṁ sati ye prahāreṇa taṁ parīkṣituṁ samudyatā āsan te tasya samīpāt prātiṣṭhanta; sahasrasenāpatistaṁ romilokaṁ vijñāya svayaṁ yat tasya bandhanam akārṣīt tatkāraṇād abibhet| ");
INSERT INTO sanias_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","yihūdīyalokāḥ paulaṁ kuto'pavadante tasya vṛttāntaṁ jñātuṁ vāñchan sahasrasenāpatiḥ pare'hani paulaṁ bandhanāt mocayitvā pradhānayājakān mahāsabhāyāḥ sarvvalokāśca samupasthātum ādiśya teṣāṁ sannidhau paulam avarohya sthāpitavān| ");
INSERT INTO sanias_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","sabhāsadlokān prati paulo'nanyadṛṣṭyā paśyan akathayat, he bhrātṛgaṇā adya yāvat saralena sarvvāntaḥkaraṇeneśvarasya sākṣād ācarāmi| ");
INSERT INTO sanias_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","anena hanānīyanāmā mahāyājakastaṁ kapole capeṭenāhantuṁ samīpasthalokān ādiṣṭavān| ");
INSERT INTO sanias_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","tadā paulastamavadat, he bahiṣpariṣkṛta, īśvarastvāṁ praharttum udyatosti, yato vyavasthānusāreṇa vicārayitum upaviśya vyavasthāṁ laṅghitvā māṁ praharttum ājñāpayasi| ");
INSERT INTO sanias_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","tato nikaṭasthā lokā akathayan, tvaṁ kim īśvarasya mahāyājakaṁ nindasi? ");
INSERT INTO sanias_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","tataḥ paulaḥ pratibhāṣitavān he bhrātṛgaṇa mahāyājaka eṣa iti na buddhaṁ mayā tadanyacca svalokānām adhipatiṁ prati durvvākyaṁ mā kathaya, etādṛśī lipirasti| ");
INSERT INTO sanias_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","anantaraṁ paulasteṣām arddhaṁ sidūkilokā arddhaṁ phirūśilokā iti dṛṣṭvā proccaiḥ sabhāsthalokān avadat he bhrātṛgaṇa ahaṁ phirūśimatāvalambī phirūśinaḥ satnānaśca, mṛtalokānām utthāne pratyāśākaraṇād ahamapavāditosmi| ");
INSERT INTO sanias_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","iti kathāyāṁ kathitāyāṁ phirūśisidūkinoḥ parasparaṁ bhinnavākyatvāt sabhāyā madhye dvau saṁghau jātau| ");
INSERT INTO sanias_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","yataḥ sidūkilokā utthānaṁ svargīyadūtā ātmānaśca sarvveṣām eteṣāṁ kamapi na manyante, kintu phirūśinaḥ sarvvam aṅgīkurvvanti| ");
INSERT INTO sanias_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","tataḥ parasparam atiśayakolāhale samupasthite phirūśināṁ pakṣīyāḥ sabhāsthā adhyāpakāḥ pratipakṣā uttiṣṭhanto 'kathayan, etasya mānavasya kamapi doṣaṁ na paśyāmaḥ; yadi kaścid ātmā vā kaścid dūta enaṁ pratyādiśat tarhi vayam īśvarasya prātikūlyena na yotsyāmaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","tasmād atīva bhinnavākyatve sati te paulaṁ khaṇḍaṁ khaṇḍaṁ kariṣyantītyāśaṅkayā sahasrasenāpatiḥ senāgaṇaṁ tatsthānaṁ yātuṁ sabhāto balāt paulaṁ dhṛtvā durgaṁ netañcājñāpayat| ");
INSERT INTO sanias_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","rātro prabhustasya samīpe tiṣṭhan kathitavān he paula nirbhayo bhava yathā yirūśālamnagare mayi sākṣyaṁ dattavān tathā romānagarepi tvayā dātavyam| ");
INSERT INTO sanias_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","dine samupasthite sati kiyanto yihūdīyalokā ekamantraṇāḥ santaḥ paulaṁ na hatvā bhojanapāne kariṣyāma iti śapathena svān abadhnan| ");
INSERT INTO sanias_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","catvāriṁśajjanebhyo'dhikā lokā iti paṇam akurvvan| ");
INSERT INTO sanias_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","te mahāyājakānāṁ prācīnalokānāñca samīpaṁ gatvā kathayan, vayaṁ paulaṁ na hatvā kimapi na bhokṣyāmahe dṛḍhenānena śapathena baddhvā abhavāma| ");
INSERT INTO sanias_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","ataeva sāmprataṁ sabhāsadlokaiḥ saha vayaṁ tasmin kañcid viśeṣavicāraṁ kariṣyāmastadarthaṁ bhavān śvo 'smākaṁ samīpaṁ tam ānayatviti sahasrasenāpataye nivedanaṁ kuruta tena yuṣmākaṁ samīpaṁ upasthiteḥ pūrvvaṁ vayaṁ taṁ hantu sajjiṣyāma| ");
INSERT INTO sanias_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","tadā paulasya bhāgineyasteṣāmiti mantraṇāṁ vijñāya durgaṁ gatvā tāṁ vārttāṁ paulam uktavān| ");
INSERT INTO sanias_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","tasmāt paula ekaṁ śatasenāpatim āhūya vākyamidam bhāṣitavān sahasrasenāpateḥ samīpe'sya yuvamanuṣyasya kiñcinnivedanam āste, tasmāt tatsavidham enaṁ naya| ");
INSERT INTO sanias_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","tataḥ sa tamādāya sahasrasenāpateḥ samīpam upasthāya kathitavān, bhavataḥ samīpe'sya kimapi nivedanamāste tasmāt bandiḥ paulo māmāhūya bhavataḥ samīpam enam ānetuṁ prārthitavān| ");
INSERT INTO sanias_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","tadā sahasrasenāpatistasya hastaṁ dhṛtvā nirjanasthānaṁ nītvā pṛṣṭhavān tava kiṁ nivedanaṁ? tat kathaya| ");
INSERT INTO sanias_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","tataḥ sokathayat, yihūdīyalākāḥ paule kamapi viśeṣavicāraṁ chalaṁ kṛtvā taṁ sabhāṁ netuṁ bhavataḥ samīpe nivedayituṁ amantrayan| ");
INSERT INTO sanias_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","kintu mavatā tanna svīkarttavyaṁ yatasteṣāṁ madhyevarttinaścatvāriṁśajjanebhyo 'dhikalokā ekamantraṇā bhūtvā paulaṁ na hatvā bhojanaṁ pānañca na kariṣyāma iti śapathena baddhāḥ santo ghātakā iva sajjitā idānīṁ kevalaṁ bhavato 'numatim apekṣante| ");
INSERT INTO sanias_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","yāmimāṁ kathāṁ tvaṁ niveditavān tāṁ kasmaicidapi mā kathayetyuktvā sahasrasenāpatistaṁ yuvānaṁ visṛṣṭavān| ");
INSERT INTO sanias_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","anantaraṁ sahasrasenāpati rdvau śatasenāpatī āhūyedam ādiśat, yuvāṁ rātrau praharaikāvaśiṣṭāyāṁ satyāṁ kaisariyānagaraṁ yātuṁ padātisainyānāṁ dve śate ghoṭakārohisainyānāṁ saptatiṁ śaktidhārisainyānāṁ dve śate ca janān sajjitān kurutaṁ| ");
INSERT INTO sanias_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","paulam ārohayituṁ phīlikṣādhipateḥ samīpaṁ nirvvighnaṁ netuñca vāhanāni samupasthāpayataṁ| ");
INSERT INTO sanias_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","aparaṁ sa patraṁ likhitvā dattavān tallikhitametat, ");
INSERT INTO sanias_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","mahāmahimaśrīyuktaphīlikṣādhipataye klaudiyaluṣiyasya namaskāraḥ| ");
INSERT INTO sanias_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","yihūdīyalokāḥ pūrvvam enaṁ mānavaṁ dhṛtvā svahastai rhantum udyatā etasminnantare sasainyohaṁ tatropasthāya eṣa jano romīya iti vijñāya taṁ rakṣitavān| ");
INSERT INTO sanias_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","kinnimittaṁ te tamapavadante tajjñātuṁ teṣā sabhāṁ tamānāyitavān| ");
INSERT INTO sanias_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","tatasteṣāṁ vyavasthāyā viruddhayā kayācana kathayā so'pavādito'bhavat, kintu sa śṛṅkhalabandhanārho vā prāṇanāśārho bhavatīdṛśaḥ kopyaparādho mayāsya na dṛṣṭaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","tathāpi manuṣyasyāsya vadhārthaṁ yihūdīyā ghātakāiva sajjitā etāṁ vārttāṁ śrutvā tatkṣaṇāt tava samīpamenaṁ preṣitavān asyāpavādakāṁśca tava samīpaṁ gatvāpavaditum ājñāpayam| bhavataḥ kuśalaṁ bhūyāt| ");
INSERT INTO sanias_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","sainyagaṇa ājñānusāreṇa paulaṁ gṛhītvā tasyāṁ rajanyām āntipātrinagaram ānayat| ");
INSERT INTO sanias_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","pare'hani tena saha yātuṁ ghoṭakārūḍhasainyagaṇaṁ sthāpayitvā parāvṛtya durgaṁ gatavān| ");
INSERT INTO sanias_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","tataḥ pare ghoṭakārohisainyagaṇaḥ kaisariyānagaram upasthāya tatpatram adhipateḥ kare samarpya tasya samīpe paulam upasthāpitavān| ");
INSERT INTO sanias_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","tadādhipatistatpatraṁ paṭhitvā pṛṣṭhavān eṣa kimpradeśīyo janaḥ? sa kilikiyāpradeśīya eko jana iti jñātvā kathitavān, ");
INSERT INTO sanias_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","tavāpavādakagaṇa āgate tava kathāṁ śroṣyāmi| herodrājagṛhe taṁ sthāpayitum ādiṣṭavān| ");
INSERT INTO sanias_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","pañcabhyo dinebhyaḥ paraṁ hanānīyanāmā mahāyājako'dhipateḥ samakṣaṁ paulasya prātikūlyena nivedayituṁ tartullanāmānaṁ kañcana vaktāraṁ prācīnajanāṁśca saṅginaḥ kṛtvā kaisariyānagaram āgacchat| ");
INSERT INTO sanias_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","tataḥ paule samānīte sati tartullastasyāpavādakathāṁ kathayitum ārabhata he mahāmahimaphīlikṣa bhavato vayam atinirvvighnaṁ kālaṁ yāpayāmo bhavataḥ pariṇāmadarśitayā etaddeśīyānāṁ bahūni maṅgalāni ghaṭitāni, ");
INSERT INTO sanias_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","iti heto rvayamatikṛtajñāḥ santaḥ sarvvatra sarvvadā bhavato guṇān gāyamaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","kintu bahubhiḥ kathābhi rbhavantaṁ yena na virañjayāmi tasmād vinaye bhavān banukampya madalpakathāṁ śṛṇotu| ");
INSERT INTO sanias_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","eṣa mahāmārīsvarūpo nāsaratīyamatagrāhisaṁghātasya mukhyo bhūtvā sarvvadeśeṣu sarvveṣāṁ yihūdīyānāṁ rājadrohācaraṇapravṛttiṁ janayatītyasmābhi rniścitaṁ| ");
INSERT INTO sanias_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","sa mandiramapi aśuci karttuṁ ceṣṭitavān; iti kāraṇād vayam enaṁ dhṛtvā svavyavasthānusāreṇa vicārayituṁ prāvarttāmahi; ");
INSERT INTO sanias_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","kintu luṣiyaḥ sahasrasenāpatirāgatya balād asmākaṁ karebhya enaṁ gṛhītvā ");
INSERT INTO sanias_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","etasyāpavādakān bhavataḥ samīpam āgantum ājñāpayat| vayaṁ yasmin tamapavādāmo bhavatā padapavādakathāyāṁ vicāritāyāṁ satyāṁ sarvvaṁ vṛttāntaṁ vedituṁ śakṣyate| ");
INSERT INTO sanias_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","tato yihūdīyā api svīkṛtya kathitavanta eṣā kathā pramāṇam| ");
INSERT INTO sanias_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","adhipatau kathāṁ kathayituṁ paulaṁ pratīṅgitaṁ kṛtavati sa kathitavān bhavān bahūn vatsarān yāvad etaddeśasya śāsanaṁ karotīti vijñāya pratyuttaraṁ dātum akṣobho'bhavam| ");
INSERT INTO sanias_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","adya kevalaṁ dvādaśa dināni yātāni, aham ārādhanāṁ karttuṁ yirūśālamanagaraṁ gatavān eṣā kathā bhavatā jñātuṁ śakyate; ");
INSERT INTO sanias_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","kintvibhe māṁ madhyemandiraṁ kenāpi saha vitaṇḍāṁ kurvvantaṁ kutrāpi bhajanabhavane nagare vā lokān kupravṛttiṁ janayantuṁ na dṛṣṭavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","idānīṁ yasmin yasmin mām apavadante tasya kimapi pramāṇaṁ dātuṁ na śaknuvanti| ");
INSERT INTO sanias_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","kintu bhaviṣyadvākyagranthe vyavasthāgranthe ca yā yā kathā likhitāste tāsu sarvvāsu viśvasya yanmatam ime vidharmmaṁ jānanti tanmatānusāreṇāhaṁ nijapitṛpuruṣāṇām īśvaram ārādhayāmītyahaṁ bhavataḥ samakṣam aṅgīkaromi| ");
INSERT INTO sanias_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","dhārmmikāṇām adhārmmikāṇāñca pramītalokānāmevotthānaṁ bhaviṣyatīti kathāmime svīkurvvanti tathāhamapi tasmin īśvare pratyāśāṁ karomi; ");
INSERT INTO sanias_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","īśvarasya mānavānāñca samīpe yathā nirdoṣo bhavāmi tadarthaṁ satataṁ yatnavān asmi| ");
INSERT INTO sanias_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","bahuṣu vatsareṣu gateṣu svadeśīyalokānāṁ nimittaṁ dānīyadravyāṇi naivedyāni ca samādāya punarāgamanaṁ kṛtavān| ");
INSERT INTO sanias_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","tatohaṁ śuci rbhūtvā lokānāṁ samāgamaṁ kalahaṁ vā na kāritavān tathāpyāśiyādeśīyāḥ kiyanto yihudīyalokā madhyemandiraṁ māṁ dhṛtavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","mamopari yadi kācidapavādakathāsti tarhi bhavataḥ samīpam upasthāya teṣāmeva sākṣyadānam ucitam| ");
INSERT INTO sanias_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","nocet pūrvve mahāsabhāsthānāṁ lokānāṁ sannidhau mama daṇḍāyamānatvasamaye, ahamadya mṛtānāmutthāne yuṣmābhi rvicāritosmi, ");
INSERT INTO sanias_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","teṣāṁ madhye tiṣṭhannahaṁ yāmimāṁ kathāmuccaiḥ svareṇa kathitavān tadanyo mama kopi doṣo'labhyata na veti varam ete samupasthitalokā vadantu| ");
INSERT INTO sanias_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","tadā phīlikṣa etāṁ kathāṁ śrutvā tanmatasya viśeṣavṛttāntaṁ vijñātuṁ vicāraṁ sthagitaṁ kṛtvā kathitavān luṣiye sahasrasenāpatau samāyāte sati yuṣmākaṁ vicāram ahaṁ niṣpādayiṣyāmi| ");
INSERT INTO sanias_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","anantaraṁ bandhanaṁ vinā paulaṁ rakṣituṁ tasya sevanāya sākṣātkaraṇāya vā tadīyātmīyabandhujanān na vārayituñca śamasenāpatim ādiṣṭavān| ");
INSERT INTO sanias_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","alpadināt paraṁ phīlikṣo'dhipati rdruṣillānāmnā yihūdīyayā svabhāryyayā sahāgatya paulamāhūya tasya mukhāt khrīṣṭadharmmasya vṛttāntam aśrauṣīt| ");
INSERT INTO sanias_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","paulena nyāyasya parimitabhogasya caramavicārasya ca kathāyāṁ kathitāyāṁ satyāṁ phīlikṣaḥ kampamānaḥ san vyāharad idānīṁ yāhi, aham avakāśaṁ prāpya tvām āhūsyāmi| ");
INSERT INTO sanias_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","muktipraptyarthaṁ paulena mahyaṁ mudrādāsyante iti patyāśāṁ kṛtvā sa punaḥ punastamāhūya tena sākaṁ kathopakathanaṁ kṛtavān| ");
INSERT INTO sanias_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","kintu vatsaradvayāt paraṁ parkiyaphīṣṭa phālikṣasya padaṁ prāpte sati phīlikṣo yihūdīyān santuṣṭān cikīrṣan paulaṁ baddhaṁ saṁsthāpya gatavān| ");
INSERT INTO sanias_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","anantaraṁ phīṣṭo nijarājyam āgatya dinatrayāt paraṁ kaisariyāto yirūśālamnagaram āgamat| ");
INSERT INTO sanias_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","tadā mahāyājako yihūdīyānāṁ pradhānalokāśca tasya samakṣaṁ paulam apāvadanta| ");
INSERT INTO sanias_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","bhavān taṁ yirūśālamam ānetum ājñāpayatviti vinīya te tasmād anugrahaṁ vāñchitavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","yataḥ pathimadhye gopanena paulaṁ hantuṁ tai rghātakā niyuktāḥ| phīṣṭa uttaraṁ dattavān paulaḥ kaisariyāyāṁ sthāsyati punaralpadināt param ahaṁ tatra yāsyāmi| ");
INSERT INTO sanias_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","tatastasya mānuṣasya yadi kaścid aparādhastiṣṭhati tarhi yuṣmākaṁ ye śaknuvanti te mayā saha tatra gatvā tamapavadantu sa etāṁ kathāṁ kathitavān| ");
INSERT INTO sanias_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","daśadivasebhyo'dhikaṁ vilambya phīṣṭastasmāt kaisariyānagaraṁ gatvā parasmin divase vicārāsana upadiśya paulam ānetum ājñāpayat| ");
INSERT INTO sanias_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","paule samupasthite sati yirūśālamnagarād āgatā yihūdīyalokāstaṁ caturdiśi saṁveṣṭya tasya viruddhaṁ bahūn mahādoṣān utthāpitavantaḥ kintu teṣāṁ kimapi pramāṇaṁ dātuṁ na śaknuvantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","tataḥ paulaḥ svasmin uttaramidam uditavān, yihūdīyānāṁ vyavasthāyā mandirasya kaisarasya vā pratikūlaṁ kimapi karmma nāhaṁ kṛtavān| ");
INSERT INTO sanias_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","kintu phīṣṭo yihūdīyān santuṣṭān karttum abhilaṣan paulam abhāṣata tvaṁ kiṁ yirūśālamaṁ gatvāsmin abhiyoge mama sākṣād vicārito bhaviṣyasi? ");
INSERT INTO sanias_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","tataḥ paula uttaraṁ proktavān, yatra mama vicāro bhavituṁ yogyaḥ kaisarasya tatra vicārāsana eva samupasthitosmi; ahaṁ yihūdīyānāṁ kāmapi hāniṁ nākārṣam iti bhavān yathārthato vijānāti| ");
INSERT INTO sanias_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","kañcidaparādhaṁ kiñcana vadhārhaṁ karmma vā yadyaham akariṣyaṁ tarhi prāṇahananadaṇḍamapi bhoktum udyato'bhaviṣyaṁ, kintu te mama samapavādaṁ kurvvanti sa yadi kalpitamātro bhavati tarhi teṣāṁ kareṣu māṁ samarpayituṁ kasyāpyadhikāro nāsti, kaisarasya nikaṭe mama vicāro bhavatu| ");
INSERT INTO sanias_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","tadā phīṣṭo mantribhiḥ sārddhaṁ saṁmantrya paulāya kathitavān, kaisarasya nikaṭe kiṁ tava vicāro bhaviṣyati? kaisarasya samīpaṁ gamiṣyasi| ");
INSERT INTO sanias_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","kiyaddinebhyaḥ param āgripparājā barṇīkī ca phīṣṭaṁ sākṣāt karttuṁ kaisariyānagaram āgatavantau| ");
INSERT INTO sanias_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","tadā tau bahudināni tatra sthitau tataḥ phīṣṭastaṁ rājānaṁ paulasya kathāṁ vijñāpya kathayitum ārabhata paulanāmānam ekaṁ bandi phīlikṣo baddhaṁ saṁsthāpya gatavān| ");
INSERT INTO sanias_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","yirūśālami mama sthitikāle mahāyājako yihūdīyānāṁ prācīnalokāśca tam apodya tamprati daṇḍājñāṁ prārthayanta| ");
INSERT INTO sanias_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","tatoham ityuttaram avadaṁ yāvad apodito janaḥ svāpavādakān sākṣāt kṛtvā svasmin yo'parādha āropitastasya pratyuttaraṁ dātuṁ suyogaṁ na prāpnoti, tāvatkālaṁ kasyāpi mānuṣasya prāṇanāśājñāpanaṁ romilokānāṁ rīti rnahi| ");
INSERT INTO sanias_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","tatasteṣvatrāgateṣu parasmin divase'ham avilambaṁ vicārāsana upaviśya taṁ mānuṣam ānetum ājñāpayam| ");
INSERT INTO sanias_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","tadanantaraṁ tasyāpavādakā upasthāya yādṛśam ahaṁ cintitavān tādṛśaṁ kañcana mahāpavādaṁ notthāpya ");
INSERT INTO sanias_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","sveṣāṁ mate tathā paulo yaṁ sajīvaṁ vadati tasmin yīśunāmani mṛtajane ca tasya viruddhaṁ kathitavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","tatohaṁ tādṛgvicāre saṁśayānaḥ san kathitavān tvaṁ yirūśālamaṁ gatvā kiṁ tatra vicārito bhavitum icchasi? ");
INSERT INTO sanias_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","tadā paulo mahārājasya nikaṭe vicārito bhavituṁ prārthayata, tasmād yāvatkālaṁ taṁ kaisarasya samīpaṁ preṣayituṁ na śaknomi tāvatkālaṁ tamatra sthāpayitum ādiṣṭavān| ");
INSERT INTO sanias_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","tata āgrippaḥ phīṣṭam uktavān, ahamapi tasya mānuṣasya kathāṁ śrotum abhilaṣāmi| tadā phīṣṭo vyāharat śvastadīyāṁ kathāṁ tvaṁ śroṣyasi| ");
INSERT INTO sanias_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","parasmin divase āgrippo barṇīkī ca mahāsamāgamaṁ kṛtvā pradhānavāhinīpatibhi rnagarasthapradhānalokaiśca saha militvā rājagṛhamāgatya samupasthitau tadā phīṣṭasyājñayā paula ānīto'bhavat| ");
INSERT INTO sanias_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","tadā phīṣṭaḥ kathitavān he rājan āgrippa he upasthitāḥ sarvve lokā yirūśālamnagare yihūdīyalokasamūho yasmin mānuṣe mama samīpe nivedanaṁ kṛtvā proccaiḥ kathāmimāṁ kathitavān punaralpakālamapi tasya jīvanaṁ nocitaṁ tametaṁ mānuṣaṁ paśyata| ");
INSERT INTO sanias_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","kintveṣa janaḥ prāṇanāśarhaṁ kimapi karmma na kṛtavān ityajānāṁ tathāpi sa mahārājasya sannidhau vicārito bhavituṁ prārthayata tasmāt tasya samīpaṁ taṁ preṣayituṁ matimakaravam| ");
INSERT INTO sanias_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","kintu śrīyuktasya samīpam etasmin kiṁ lekhanīyam ityasya kasyacin nirṇayasya na jātatvād etasya vicāre sati yathāhaṁ lekhituṁ kiñcana niścitaṁ prāpnomi tadarthaṁ yuṣmākaṁ samakṣaṁ viśeṣato he āgripparāja bhavataḥ samakṣam etam ānaye| ");
INSERT INTO sanias_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","yato bandipreṣaṇasamaye tasyābhiyogasya kiñcidalekhanam aham ayuktaṁ jānāmi| ");
INSERT INTO sanias_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","tata āgrippaḥ paulam avādīt, nijāṁ kathāṁ kathayituṁ tubhyam anumati rdīyate| tasmāt paulaḥ karaṁ prasāryya svasmin uttaram avādīt| ");
INSERT INTO sanias_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","he āgripparāja yatkāraṇādahaṁ yihūdīyairapavādito 'bhavaṁ tasya vṛttāntam adya bhavataḥ sākṣān nivedayitumanumatoham idaṁ svīyaṁ paramaṁ bhāgyaṁ manye; ");
INSERT INTO sanias_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","yato yihūdīyalokānāṁ madhye yā yā rītiḥ sūkṣmavicārāśca santi teṣu bhavān vijñatamaḥ; ataeva prārthaye dhairyyamavalambya mama nivedanaṁ śṛṇotu| ");
INSERT INTO sanias_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","ahaṁ yirūśālamnagare svadeśīyalokānāṁ madhye tiṣṭhan ā yauvanakālād yadrūpam ācaritavān tad yihūdīyalokāḥ sarvve vidanti| ");
INSERT INTO sanias_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","asmākaṁ sarvvebhyaḥ śuddhatamaṁ yat phirūśīyamataṁ tadavalambī bhūtvāhaṁ kālaṁ yāpitavān ye janā ā bālyakālān māṁ jānānti te etādṛśaṁ sākṣyaṁ yadi dadāti tarhi dātuṁ śaknuvanti| ");
INSERT INTO sanias_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","kintu he āgripparāja īśvaro'smākaṁ pūrvvapuruṣāṇāṁ nikaṭe yad aṅgīkṛtavān tasya pratyāśāhetoraham idānīṁ vicārasthāne daṇḍāyamānosmi| ");
INSERT INTO sanias_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","tasyāṅgīkārasya phalaṁ prāptum asmākaṁ dvādaśavaṁśā divāniśaṁ mahāyatnād īśvarasevanaṁ kṛtvā yāṁ pratyāśāṁ kurvvanti tasyāḥ pratyāśāyā hetorahaṁ yihūdīyairapavādito'bhavam| ");
INSERT INTO sanias_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","īśvaro mṛtān utthāpayiṣyatīti vākyaṁ yuṣmākaṁ nikaṭe'sambhavaṁ kuto bhavet? ");
INSERT INTO sanias_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","nāsaratīyayīśo rnāmno viruddhaṁ nānāprakārapratikūlācaraṇam ucitam ityahaṁ manasi yathārthaṁ vijñāya ");
INSERT INTO sanias_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","yirūśālamanagare tadakaravaṁ phalataḥ pradhānayājakasya nikaṭāt kṣamatāṁ prāpya bahūn pavitralokān kārāyāṁ baddhavān viśeṣatasteṣāṁ hananasamaye teṣāṁ viruddhāṁ nijāṁ sammatiṁ prakāśitavān| ");
INSERT INTO sanias_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","vāraṁ vāraṁ bhajanabhavaneṣu tebhyo daṇḍaṁ pradattavān balāt taṁ dharmmaṁ nindayitavāṁśca punaśca tān prati mahākrodhād unmattaḥ san videśīyanagarāṇi yāvat tān tāḍitavān| ");
INSERT INTO sanias_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","itthaṁ pradhānayājakasya samīpāt śaktim ājñāpatrañca labdhvā dammeṣaknagaraṁ gatavān| ");
INSERT INTO sanias_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","tadāhaṁ he rājan mārgamadhye madhyāhnakāle mama madīyasaṅgināṁ lokānāñca catasṛṣu dikṣu gagaṇāt prakāśamānāṁ bhāskaratopi tejasvatīṁ dīptiṁ dṛṣṭavān| ");
INSERT INTO sanias_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","tasmād asmāsu sarvveṣu bhūmau patiteṣu satsu he śaula hai śaula kuto māṁ tāḍayasi? kaṇṭakānāṁ mukhe pādāhananaṁ tava duḥsādhyam ibrīyabhāṣayā gadita etādṛśa ekaḥ śabdo mayā śrutaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","tadāhaṁ pṛṣṭavān he prabho ko bhavān? tataḥ sa kathitavān yaṁ yīśuṁ tvaṁ tāḍayasi sohaṁ, ");
INSERT INTO sanias_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","kintu samuttiṣṭha tvaṁ yad dṛṣṭavān itaḥ punañca yadyat tvāṁ darśayiṣyāmi teṣāṁ sarvveṣāṁ kāryyāṇāṁ tvāṁ sākṣiṇaṁ mama sevakañca karttum darśanam adām| ");
INSERT INTO sanias_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","viśeṣato yihūdīyalokebhyo bhinnajātīyebhyaśca tvāṁ manonītaṁ kṛtvā teṣāṁ yathā pāpamocanaṁ bhavati ");
INSERT INTO sanias_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","yathā te mayi viśvasya pavitrīkṛtānāṁ madhye bhāgaṁ prāpnuvanti tadabhiprāyeṇa teṣāṁ jñānacakṣūṁṣi prasannāni karttuṁ tathāndhakārād dīptiṁ prati śaitānādhikārācca īśvaraṁ prati matīḥ parāvarttayituṁ teṣāṁ samīpaṁ tvāṁ preṣyāmi| ");
INSERT INTO sanias_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","he āgripparāja etādṛśaṁ svargīyapratyādeśaṁ agrāhyam akṛtvāhaṁ ");
INSERT INTO sanias_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","prathamato dammeṣaknagare tato yirūśālami sarvvasmin yihūdīyadeśe anyeṣu deśeṣu ca yeेna lokā matiṁ parāvarttya īśvaraṁ prati parāvarttayante, manaḥparāvarttanayogyāni karmmāṇi ca kurvvanti tādṛśam upadeśaṁ pracāritavān| ");
INSERT INTO sanias_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","etatkāraṇād yihūdīyā madhyemandiraṁ māṁ dhṛtvā hantum udyatāḥ| ");
INSERT INTO sanias_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","tathāpi khrīṣṭo duḥkhaṁ bhuktvā sarvveṣāṁ pūrvvaṁ śmaśānād utthāya nijadeśīyānāṁ bhinnadeśīyānāñca samīpe dīptiṁ prakāśayiṣyati ");
INSERT INTO sanias_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","bhaviṣyadvādigaṇo mūsāśca bhāvikāryyasya yadidaṁ pramāṇam adaduretad vinānyāṁ kathāṁ na kathayitvā īśvarād anugrahaṁ labdhvā mahatāṁ kṣudrāṇāñca sarvveṣāṁ samīpe pramāṇaṁ dattvādya yāvat tiṣṭhāmi| ");
INSERT INTO sanias_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","tasyamāṁ kathāṁ niśamya phīṣṭa uccaiḥ svareṇa kathitavān he paula tvam unmattosi bahuvidyābhyāsena tvaṁ hatajñāno jātaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","sa uktavān he mahāmahima phīṣṭa nāham unmattaḥ kintu satyaṁ vivecanīyañca vākyaṁ prastaumi| ");
INSERT INTO sanias_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","yasya sākṣād akṣobhaḥ san kathāṁ kathayāmi sa rājā tadvṛttāntaṁ jānāti tasya samīpe kimapi guptaṁ neti mayā niścitaṁ budhyate yatastad vijane na kṛtaṁ| ");
INSERT INTO sanias_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","he āgripparāja bhavān kiṁ bhaviṣyadvādigaṇoktāni vākyāni pratyeti? bhavān pratyeti tadahaṁ jānāmi| ");
INSERT INTO sanias_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","tata āgrippaḥ paulam abhihitavān tvaṁ pravṛttiṁ janayitvā prāyeṇa māmapi khrīṣṭīyaṁ karoṣi| ");
INSERT INTO sanias_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","tataḥ so'vādīt bhavān ye ye lokāśca mama kathām adya śṛṇvanti prāyeṇa iti nahi kintvetat śṛṅkhalabandhanaṁ vinā sarvvathā te sarvve mādṛśā bhavantvitīśvasya samīpe prārthaye'ham| ");
INSERT INTO sanias_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","etasyāṁ kathāyāṁ kathitāyāṁ sa rājā so'dhipati rbarṇīkī sabhāsthā lokāśca tasmād utthāya ");
INSERT INTO sanias_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","gopane parasparaṁ vivicya kathitavanta eṣa jano bandhanārhaṁ prāṇahananārhaṁ vā kimapi karmma nākarot| ");
INSERT INTO sanias_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","tata āgrippaḥ phīṣṭam avadat, yadyeṣa mānuṣaḥ kaisarasya nikaṭe vicārito bhavituṁ na prārthayiṣyat tarhi mukto bhavitum aśakṣyat| ");
INSERT INTO sanias_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","jalapathenāsmākam itoliyādeśaṁ prati yātrāyāṁ niścitāyāṁ satyāṁ te yūliyanāmno mahārājasya saṁghātāntargatasya senāpateḥ samīpe paulaṁ tadanyān katinayajanāṁśca samārpayan| ");
INSERT INTO sanias_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","vayam ādrāmuttīyaṁ potamekam āruhya āśiyādeśasya taṭasamīpena yātuṁ matiṁ kṛtvā laṅgaram utthāpya potam amocayāma; mākidaniyādeśasthathiṣalanīkīnivāsyāristārkhanāmā kaścid jano'smābhiḥ sārddham āsīt| ");
INSERT INTO sanias_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","parasmin divase 'smābhiḥ sīdonnagare pote lāgite tatra yūliyaḥ senāpatiḥ paulaṁ prati saujanyaṁ pradarthya sāntvanārthaṁ bandhubāndhavān upayātum anujajñau| ");
INSERT INTO sanias_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","tasmāt pote mocite sati sammukhavāyoḥ sambhavād vayaṁ kupropadvīpasya tīrasamīpena gatavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","kilikiyāyāḥ pāmphūliyāyāśca samudrasya pāraṁ gatvā lūkiyādeśāntargataṁ murānagaram upātiṣṭhāma| ");
INSERT INTO sanias_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","tatsthānād itāliyādeśaṁ gacchati yaḥ sikandariyānagarasya potastaṁ tatra prāpya śatasenāpatistaṁ potam asmān ārohayat| ");
INSERT INTO sanias_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","tataḥ paraṁ bahūni dināni śanaiḥ śanaiḥ rgatvā knīdapārśvopasthtiेḥ pūrvvaṁ pratikūlena pavanena vayaṁ salmonyāḥ sammukham upasthāya krītyupadvīpasya tīrasamīpena gatavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","kaṣṭena tamuttīryya lāseyānagarasyādhaḥ sundaranāmakaṁ khātam upātiṣṭhāma| ");
INSERT INTO sanias_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","itthaṁ bahutithaḥ kālo yāpita upavāsadinañcātītaṁ, tatkāraṇāt nauvartmani bhayaṅkare sati paulo vinayena kathitavān, ");
INSERT INTO sanias_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","he mahecchā ahaṁ niścayaṁ jānāmi yātrāyāmasyām asmākaṁ kleśā bahūnāmapacayāśca bhaviṣyanti, te kevalaṁ potasāmagryoriti nahi, kintvasmākaṁ prāṇānāmapi| ");
INSERT INTO sanias_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","tadā śatasenāpatiḥ pauैेloktavākyatopi karṇadhārasya potavaṇijaśca vākyaṁ bahumaṁsta| ");
INSERT INTO sanias_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","tat khātaṁ śītakāle vāsārhasthānaṁ na tasmād avācīpratīcordiśoḥ krītyāḥ phainīkiyakhātaṁ yātuṁ yadi śaknuvantastarhi tatra śītakālaṁ yāpayituṁ prāyeṇa sarvve mantrayāmāsuḥ| ");
INSERT INTO sanias_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","tataḥ paraṁ dakṣiṇavāyu rmandaṁ vahatīti vilokya nijābhiprāyasya siddheḥ suyogo bhavatīti buddhvā potaṁ mocayitvā krītyupadvīpasya tīrasamīpena calitavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","kintvalpakṣaṇāt parameva urakludonnāmā pratikūlaḥ pracaṇḍo vāyu rvahan pote'lagīt ");
INSERT INTO sanias_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","tasyābhimukhaṁ gantum potasyāśaktatvād vayaṁ vāyunā svayaṁ nītāḥ| ");
INSERT INTO sanias_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","anantaraṁ klaudīnāmna upadvīpasya kūlasamīpena potaṁ gamayitvā bahunā kaṣṭena kṣudranāvam arakṣāma| ");
INSERT INTO sanias_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","te tāmāruhya rajjcā potasyādhobhāgam abadhnan tadanantaraṁ cet poto saikate lagatīti bhayād vātavasanānyamocayan tataḥ poto vāyunā cālitaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","kintu kramaśo vāyoḥ prabalatvāt poto dolāyamāno'bhavat parasmin divase potasthāni katipayāni dravyāṇi toye nikṣiptāni| ");
INSERT INTO sanias_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","tṛtīyadivase vayaṁ svahastaiḥ potasajjanadravyāṇi nikṣiptavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","tato bahudināni yāvat sūryyanakṣatrādīni samācchannāni tato 'tīva vātyāgamād asmākaṁ prāṇarakṣāyāḥ kāpi pratyāśā nātiṣṭhat| ");
INSERT INTO sanias_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","bahudineṣu lokairanāhāreṇa yāpiteṣu sarvveṣāṁ sākṣat paulastiṣṭhan akathayat, he mahecchāḥ krītyupadvīpāt potaṁ na mocayitum ahaṁ pūrvvaṁ yad avadaṁ tadgrahaṇaṁ yuṣmākam ucitam āsīt tathā kṛte yuṣmākam eṣā vipad eṣo'pacayaśca nāghaṭiṣyetām| ");
INSERT INTO sanias_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","kintu sāmprataṁ yuṣmān vinīya bravīmyahaṁ, yūyaṁ na kṣubhyata yuṣmākam ekasyāpi prāṇino hāni rna bhaviṣyati, kevalasya potasya hāni rbhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","yato yasyeśvarasya loko'haṁ yañcāhaṁ paricarāmi tadīya eko dūto hyo rātrau mamāntike tiṣṭhan kathitavān, ");
INSERT INTO sanias_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","he paula mā bhaiṣīḥ kaisarasya sammukhe tvayopasthātavyaṁ; tavaitān saṅgino lokān īśvarastubhyaṁ dattavān| ");
INSERT INTO sanias_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","ataeva he mahecchā yūyaṁ sthiramanaso bhavata mahyaṁ yā kathākathi sāvaśyaṁ ghaṭiṣyate mamaitādṛśī viśvāsa īśvare vidyate, ");
INSERT INTO sanias_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","kintu kasyacid upadvīpasyopari patitavyam asmābhiḥ| ");
INSERT INTO sanias_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","tataḥ param ādriyāsamudre potastathaiva dolāyamānaḥ san itastato gacchan caturdaśadivasasya rātre rdvitīyapraharasamaye kasyacit sthalasya samīpamupatiṣṭhatīti potīyalokā anvamanyanta| ");
INSERT INTO sanias_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","tataste jalaṁ parimāya tatra viṁśati rvyāmā jalānīti jñātavantaḥ| kiñciddūraṁ gatvā punarapi jalaṁ parimitavantaḥ| tatra pañcadaśa vyāmā jalāni dṛṣṭvā ");
INSERT INTO sanias_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","cet pāṣāṇe lagatīti bhayāt potasya paścādbhāgataścaturo laṅgarān nikṣipya divākaram apekṣya sarvve sthitavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","kintu potīyalokāḥ potāgrabhāge laṅgaranikṣepaṁ chalaṁ kṛtvā jaladhau kṣudranāvam avarohya palāyitum aceṣṭanta| ");
INSERT INTO sanias_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","tataḥ paulaḥ senāpataye sainyagaṇāya ca kathitavān, ete yadi potamadhye na tiṣṭhanti tarhi yuṣmākaṁ rakṣaṇaṁ na śakyaṁ| ");
INSERT INTO sanias_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","tadā senāgaṇo rajjūn chitvā nāvaṁ jale patitum adadāt| ");
INSERT INTO sanias_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","prabhātasamaye paulaḥ sarvvān janān bhojanārthaṁ prārthya vyāharat, adya caturdaśadināni yāvad yūyam apekṣamānā anāhārāḥ kālam ayāpayata kimapi nābhuṁgdhaṁ| ");
INSERT INTO sanias_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","ato vinayeे'haṁ bhakṣyaṁ bhujyatāṁ tato yuṣmākaṁ maṅgalaṁ bhaviṣyati, yuṣmākaṁ kasyacijjanasya śirasaḥ keśaikopi na naṁkṣyati| ");
INSERT INTO sanias_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","iti vyāhṛtya paulaṁ pūpaṁ gṛhītveśvaraṁ dhanyaṁ bhāṣamāṇastaṁ bhaṁktvā bhoktum ārabdhavān| ");
INSERT INTO sanias_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","anantaraṁ sarvve ca susthirāḥ santaḥ khādyāni parpyagṛhlan| ");
INSERT INTO sanias_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","asmākaṁ pote ṣaṭsaptatyadhikaśatadvayalokā āsan| ");
INSERT INTO sanias_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","sarvveṣu lokeṣu yatheṣṭaṁ bhuktavatsu potasthan godhūmān jaladhau nikṣipya taiḥ potasya bhāro laghūkṛtaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","dine jāte'pi sa ko deśa iti tadā na paryyacīyata; kintu tatra samataṭam ekaṁ khātaṁ dṛṣṭvā yadi śaknumastarhi vayaṁ tasyābhyantaraṁ potaṁ gamayāma iti matiṁ kṛtvā te laṅgarān chittvā jaladhau tyaktavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","tathā karṇabandhanaṁ mocayitvā pradhānaṁ vātavasanam uttolya tīrasamīpaṁ gatavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","kintu dvayoḥ samudrayoḥ saṅgamasthāne saikatopari pote nikṣipte 'grabhāge bādhite paścādbhāge prabalataraṅgo'lagat tena poto bhagnaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","tasmād bandayaśced bāhubhistarantaḥ palāyante ityāśaṅkayā senāgaṇastān hantum amantrayat; ");
INSERT INTO sanias_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","kintu śatasenāpatiḥ paulaṁ rakṣituṁ prayatnaṁ kṛtvā tān tacceṣṭāyā nivartya ityādiṣṭavān, ye bāhutaraṇaṁ jānanti te'gre prollampya samudre patitvā bāhubhistīrttvā kūlaṁ yāntu| ");
INSERT INTO sanias_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","aparam avaśiṣṭā janāḥ kāṣṭhaṁ potīyaṁ dravyaṁ vā yena yat prāpyate tadavalambya yāntu; itthaṁ sarvve bhūmiṁ prāpya prāṇai rjīvitāḥ| ");
INSERT INTO sanias_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","itthaṁ sarvveṣu rakṣāṁ prāpteṣu tatratyopadvīpasya nāma milīteti te jñātavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","asabhyalokā yatheṣṭam anukampāṁ kṛtvā varttamānavṛṣṭeḥ śītācca vahniṁ prajjvālyāsmākam ātithyam akurvvan| ");
INSERT INTO sanias_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","kintu paula indhanāni saṁgṛhya yadā tasmin agrau nirakṣipat, tadā vahneḥ pratāpāt ekaḥ kṛṣṇasarpo nirgatya tasya haste draṣṭavān| ");
INSERT INTO sanias_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","te'sabhyalokāstasya haste sarpam avalambamānaṁ dṛṣṭvā parasparam uktavanta eṣa jano'vaśyaṁ narahā bhaviṣyati, yato yadyapi jaladhe rakṣāṁ prāptavān tathāpi pratiphaladāyaka enaṁ jīvituṁ na dadāti| ");
INSERT INTO sanias_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","kintu sa hastaṁ vidhunvan taṁ sarpam agnimadhye nikṣipya kāmapi pīḍāṁ nāptavān| ");
INSERT INTO sanias_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","tato viṣajvālayā etasya śarīraṁ sphītaṁ bhaviṣyati yadvā haṭhādayaṁ prāṇān tyakṣyatīti niścitya lokā bahukṣaṇāni yāvat tad draṣṭuṁ sthitavantaḥ kintu tasya kasyāścid vipado'ghaṭanāt te tadviparītaṁ vijñāya bhāṣitavanta eṣa kaścid devo bhavet| ");
INSERT INTO sanias_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","publiyanāmā jana ekastasyopadvīpasyādhipatirāsīt tatra tasya bhūmyādi ca sthitaṁ| sa jano'smān nijagṛhaṁ nītvā saujanyaṁ prakāśya dinatrayaṁ yāvad asmākaṁ ātithyam akarot| ");
INSERT INTO sanias_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","tadā tasya publiyasya pitā jvarātisāreṇa pīḍyamānaḥ san śayyāyām āsīt; tataḥ paulastasya samīpaṁ gatvā prārthanāṁ kṛtvā tasya gātre hastaṁ samarpya taṁ svasthaṁ kṛtavān| ");
INSERT INTO sanias_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","itthaṁ bhūte tadvīpanivāsina itarepi rogilokā āgatya nirāmayā abhavan| ");
INSERT INTO sanias_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","tasmātte'smākam atīva satkāraṁ kṛtavantaḥ, viśeṣataḥ prasthānasamaye prayojanīyāni nānadravyāṇi dattavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","itthaṁ tatra triṣu māseṣu gateṣu yasya cihnaṁ diyaskūrī tādṛśa ekaḥ sikandarīyanagarasya potaḥ śītakālaṁ yāpayan tasmin upadvīpe 'tiṣṭhat tameva potaṁ vayam āruhya yātrām akurmma| ");
INSERT INTO sanias_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","tataḥ prathamataḥ surākūsanagaram upasthāya tatra trīṇi dināni sthitavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","tasmād āvṛtya rīgiyanagaram upasthitāḥ dinaikasmāt paraṁ dakṣiṇavayau sānukūlye sati parasmin divase patiyalīnagaram upātiṣṭhāma| ");
INSERT INTO sanias_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","tato'smāsu tatratyaṁ bhrātṛgaṇaṁ prāpteṣu te svaiḥ sārddham asmān sapta dināni sthāpayitum ayatanta, itthaṁ vayaṁ romānagaram pratyagacchāma| ");
INSERT INTO sanias_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","tasmāt tatratyāḥ bhrātaro'smākam āgamanavārttāṁ śrutvā āppiyapharaṁ triṣṭāvarṇīñca yāvad agresarāḥ santosmān sākṣāt karttum āgaman; teṣāṁ darśanāt paula īśvaraṁ dhanyaṁ vadan āśvāsam āptavān| ");
INSERT INTO sanias_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","asmāsu romānagaraṁ gateṣu śatasenāpatiḥ sarvvān bandīn pradhānasenāpateḥ samīpe samārpayat kintu paulāya svarakṣakapadātinā saha pṛthag vastum anumatiṁ dattavān| ");
INSERT INTO sanias_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","dinatrayāt paraṁ paulastaddeśasthān pradhānayihūdina āhūtavān tatasteṣu samupasthiteṣu sa kathitavān, he bhrātṛgaṇa nijalokānāṁ pūrvvapuruṣāṇāṁ vā rīte rviparītaṁ kiñcana karmmāhaṁ nākaravaṁ tathāpi yirūśālamanivāsino lokā māṁ bandiṁ kṛtvā romilokānāṁ hasteṣu samarpitavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","romilokā vicāryya mama prāṇahananārhaṁ kimapi kāraṇaṁ na prāpya māṁ mocayitum aicchan; ");
INSERT INTO sanias_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","kintu yihūdilokānām āpattyā mayā kaisararājasya samīpe vicārasya prārthanā karttavyā jātā nocet nijadeśīyalokān prati mama kopyabhiyogo nāsti| ");
INSERT INTO sanias_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","etatkāraṇād ahaṁ yuṣmān draṣṭuṁ saṁlapituñcāhūyam isrāyelvaśīyānāṁ pratyāśāhetoham etena śuṅkhalena baddho'bhavam| ");
INSERT INTO sanias_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","tadā te tam avādiṣuḥ, yihūdīyadeśād vayaṁ tvāmadhi kimapi patraṁ na prāptā ye bhrātaraḥ samāyātāsteṣāṁ kopi tava kāmapi vārttāṁ nāvadat abhadramapi nākathayacca| ");
INSERT INTO sanias_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","tava mataṁ kimiti vayaṁ tvattaḥ śrotumicchāmaḥ| yad idaṁ navīnaṁ matamutthitaṁ tat sarvvatra sarvveṣāṁ nikaṭe ninditaṁ jātama iti vayaṁ jānīmaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","taistadartham ekasmin dine nirūpite tasmin dine bahava ekatra militvā paulasya vāsagṛham āgacchan tasmāt paula ā prātaḥkālāt sandhyākālaṁ yāvan mūsāvyavasthāgranthād bhaviṣyadvādināṁ granthebhyaśca yīśoḥ kathām utthāpya īśvarasya rājye pramāṇaṁ datvā teṣāṁ pravṛttiṁ janayituṁ ceṣṭitavān| ");
INSERT INTO sanias_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","kecittu tasya kathāṁ pratyāyan kecittu na pratyāyan; ");
INSERT INTO sanias_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","etatkāraṇāt teṣāṁ parasparam anaikyāt sarvve calitavantaḥ; tathāpi paula etāṁ kathāmekāṁ kathitavān pavitra ātmā yiśayiyasya bhaviṣyadvaktu rvadanād asmākaṁ pitṛpuruṣebhya etāṁ kathāṁ bhadraṁ kathayāmāsa, yathā, ");
INSERT INTO sanias_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","\"upagatya janānetān tvaṁ bhāṣasva vacastvidaṁ| karṇaiḥ śroṣyatha yūyaṁ hi kintu yūyaṁ na bhotsyatha| netrai rdrakṣyatha yūyañca jñātuṁ yūyaṁ na śakṣyatha| ");
INSERT INTO sanias_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","te mānuṣā yathā netraiḥ paripaśyanti naiva hi| karṇaiḥ ryathā na śṛṇvanti budhyante na ca mānasaiḥ| vyāvarttayatsu cittāni kāle kutrāpi teṣu vai| mattaste manujāḥ svasthā yathā naiva bhavanti ca| tathā teṣāṁ manuṣyāṇāṁ santi sthūlā hi buddhayaḥ| badhirībhūtakarṇāśca jātāśca mudritā dṛśaḥ|| ");
INSERT INTO sanias_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","ata īśvarād yat paritrāṇaṁ tasya vārttā bhinnadeśīyānāṁ samīpaṁ preṣitā taeva tāṁ grahīṣyantīti yūyaṁ jānīta| ");
INSERT INTO sanias_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","etādṛśyāṁ kathāyāṁ kathitāyāṁ satyāṁ yihūdinaḥ parasparaṁ bahuvicāraṁ kurvvanto gatavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","itthaṁ paulaḥ sampūrṇaṁ vatsaradvayaṁ yāvad bhāṭakīye vāsagṛhe vasan ye lokāstasya sannidhim āgacchanti tān sarvvāneva parigṛhlan, ");
INSERT INTO sanias_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","nirvighnam atiśayaniḥkṣobham īśvarīyarājatvasya kathāṁ pracārayan prabhau yīśau khrīṣṭe kathāḥ samupādiśat| iti||");
INSERT INTO sanias_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","īśvaro nijaputramadhi yaṁ susaṁvādaṁ bhaviṣyadvādibhi rdharmmagranthe pratiśrutavān taṁ susaṁvādaṁ pracārayituṁ pṛthakkṛta āhūtaḥ preritaśca prabho ryīśukhrīṣṭasya sevako yaḥ paulaḥ ");
INSERT INTO sanias_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","sa romānagarasthān īśvarapriyān āhūtāṁśca pavitralokān prati patraṁ likhati| ");
INSERT INTO sanias_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","asmākaṁ sa prabhu ryīśuḥ khrīṣṭaḥ śārīrikasambandhena dāyūdo vaṁśodbhavaḥ ");
INSERT INTO sanias_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","pavitrasyātmanaḥ sambandhena ceśvarasya prabhāvavān putra iti śmaśānāt tasyotthānena pratipannaṁ| ");
INSERT INTO sanias_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","aparaṁ yeṣāṁ madhye yīśunā khrīṣṭena yūyamapyāhūtāste 'nyadeśīyalokāstasya nāmni viśvasya nideśagrāhiṇo yathā bhavanti ");
INSERT INTO sanias_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","tadabhiprāyeṇa vayaṁ tasmād anugrahaṁ preritatvapadañca prāptāḥ| ");
INSERT INTO sanias_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","tātenāsmākam īśvareṇa prabhuṇā yīśukhrīṣṭena ca yuṣmabhyam anugrahaḥ śāntiśca pradīyetāṁ| ");
INSERT INTO sanias_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","prathamataḥ sarvvasmin jagati yuṣmākaṁ viśvāsasya prakāśitatvād ahaṁ yuṣmākaṁ sarvveṣāṁ nimittaṁ yīśukhrīṣṭasya nāma gṛhlan īśvarasya dhanyavādaṁ karomi| ");
INSERT INTO sanias_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","aparam īśvarasya prasādād bahukālāt paraṁ sāmprataṁ yuṣmākaṁ samīpaṁ yātuṁ kathamapi yat suyogaṁ prāpnomi, etadarthaṁ nirantaraṁ nāmānyuccārayan nijāsu sarvvaprārthanāsu sarvvadā nivedayāmi, ");
INSERT INTO sanias_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","etasmin yamahaṁ tatputrīyasusaṁvādapracāraṇena manasā paricarāmi sa īśvaro mama sākṣī vidyate| ");
INSERT INTO sanias_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","yato yuṣmākaṁ mama ca viśvāsena vayam ubhaye yathā śāntiyuktā bhavāma iti kāraṇād ");
INSERT INTO sanias_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","yuṣmākaṁ sthairyyakaraṇārthaṁ yuṣmabhyaṁ kiñcitparamārthadānadānāya yuṣmān sākṣāt karttuṁ madīyā vāñchā| ");
INSERT INTO sanias_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","he bhrātṛgaṇa bhinnadeśīyalokānāṁ madhye yadvat tadvad yuṣmākaṁ madhyepi yathā phalaṁ bhuñje tadabhiprāyeṇa muhurmuhu ryuṣmākaṁ samīpaṁ gantum udyato'haṁ kintu yāvad adya tasmin gamane mama vighno jāta iti yūyaṁ yad ajñātāstiṣṭhatha tadaham ucitaṁ na budhye| ");
INSERT INTO sanias_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","ahaṁ sabhyāsabhyānāṁ vidvadavidvatāñca sarvveṣām ṛṇī vidye| ");
INSERT INTO sanias_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","ataeva romānivāsināṁ yuṣmākaṁ samīpe'pi yathāśakti susaṁvādaṁ pracārayitum aham udyatosmi| ");
INSERT INTO sanias_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","yataḥ khrīṣṭasya susaṁvādo mama lajjāspadaṁ nahi sa īśvarasya śaktisvarūpaḥ san ā yihūdīyebhyo 'nyajātīyān yāvat sarvvajātīyānāṁ madhye yaḥ kaścid tatra viśvasiti tasyaiva trāṇaṁ janayati| ");
INSERT INTO sanias_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","yataḥ pratyayasya samaparimāṇam īśvaradattaṁ puṇyaṁ tatsusaṁvāde prakāśate| tadadhi dharmmapustakepi likhitamidaṁ \"puṇyavān jano viśvāsena jīviṣyati\"| ");
INSERT INTO sanias_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","ataeva ye mānavāḥ pāpakarmmaṇā satyatāṁ rundhanti teṣāṁ sarvvasya durācaraṇasyādharmmasya ca viruddhaṁ svargād īśvarasya kopaḥ prakāśate| ");
INSERT INTO sanias_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","yata īśvaramadhi yadyad jñeyaṁ tad īśvaraḥ svayaṁ tān prati prakāśitavān tasmāt teṣām agocaraṁ nahi| ");
INSERT INTO sanias_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","phalatastasyānantaśaktīśvaratvādīnyadṛśyānyapi sṛṣṭikālam ārabhya karmmasu prakāśamānāni dṛśyante tasmāt teṣāṁ doṣaprakṣālanasya panthā nāsti| ");
INSERT INTO sanias_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","aparam īśvaraṁ jñātvāpi te tam īśvarajñānena nādriyanta kṛtajñā vā na jātāḥ; tasmāt teṣāṁ sarvve tarkā viphalībhūtāḥ, aparañca teṣāṁ vivekaśūnyāni manāṁsi timire magnāni| ");
INSERT INTO sanias_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","te svān jñānino jñātvā jñānahīnā abhavan ");
INSERT INTO sanias_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","anaśvarasyeśvarasya gauravaṁ vihāya naśvaramanuṣyapaśupakṣyurogāmiprabhṛterākṛtiviśiṣṭapratimāstairāśritāḥ| ");
INSERT INTO sanias_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","itthaṁ ta īśvarasya satyatāṁ vihāya mṛṣāmatam āśritavantaḥ saccidānandaṁ sṛṣṭikarttāraṁ tyaktvā sṛṣṭavastunaḥ pūjāṁ sevāñca kṛtavantaḥ; ");
INSERT INTO sanias_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","iti hetorīśvarastān kukriyāyāṁ samarpya nijanijakucintābhilāṣābhyāṁ svaṁ svaṁ śarīraṁ parasparam apamānitaṁ karttum adadāt| ");
INSERT INTO sanias_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","īśvareṇa teṣu kvabhilāṣe samarpiteṣu teṣāṁ yoṣitaḥ svābhāvikācaraṇam apahāya viparītakṛtye prāvarttanta; ");
INSERT INTO sanias_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","tathā puruṣā api svābhāvikayoṣitsaṅgamaṁ vihāya parasparaṁ kāmakṛśānunā dagdhāḥ santaḥ pumāṁsaḥ puṁbhiḥ sākaṁ kukṛtye samāsajya nijanijabhrānteḥ samucitaṁ phalam alabhanta| ");
INSERT INTO sanias_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","te sveṣāṁ manaḥsvīśvarāya sthānaṁ dātum anicchukāstato hetorīśvarastān prati duṣṭamanaskatvam avihitakriyatvañca dattavān| ");
INSERT INTO sanias_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","ataeva te sarvve 'nyāyo vyabhicāro duṣṭatvaṁ lobho jighāṁsā īrṣyā vadho vivādaścāturī kumatirityādibhi rduṣkarmmabhiḥ paripūrṇāḥ santaḥ ");
INSERT INTO sanias_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","karṇejapā apavādina īśvaradveṣakā hiṁsakā ahaṅkāriṇa ātmaślāghinaḥ kukarmmotpādakāḥ pitrorājñālaṅghakā ");
INSERT INTO sanias_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","avicārakā niyamalaṅghinaḥ sneharahitā atidveṣiṇo nirdayāśca jātāḥ| ");
INSERT INTO sanias_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","ye janā etādṛśaṁ karmma kurvvanti taeva mṛtiyogyā īśvarasya vicāramīdṛśaṁ jñātvāpi ta etādṛśaṁ karmma svayaṁ kurvvanti kevalamiti nahi kintu tādṛśakarmmakāriṣu lokeṣvapi prīyante| ");
INSERT INTO sanias_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","he paradūṣaka manuṣya yaḥ kaścana tvaṁ bhavasi tavottaradānāya panthā nāsti yato yasmāt karmmaṇaḥ parastvayā dūṣyate tasmāt tvamapi dūṣyase, yatastaṁ dūṣayannapi tvaṁ tadvad ācarasi| ");
INSERT INTO sanias_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","kintvetādṛgācāribhyo yaṁ daṇḍam īśvaro niścinoti sa yathārtha iti vayaṁ jānīmaḥ| ");
INSERT INTO sanias_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","ataeva he mānuṣa tvaṁ yādṛgācāriṇo dūṣayasi svayaṁ yadi tādṛgācarasi tarhi tvam īśvaradaṇḍāt palāyituṁ śakṣyasīti kiṁ budhyase? ");
INSERT INTO sanias_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","aparaṁ tava manasaḥ parivarttanaṁ karttum iśvarasyānugraho bhavati tanna buddhvā tvaṁ kiṁ tadīyānugrahakṣamācirasahiṣṇutvanidhiṁ tucchīkaroṣi? ");
INSERT INTO sanias_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","tathā svāntaḥkaraṇasya kaṭhoratvāt khedarāhityācceśvarasya nyāyyavicāraprakāśanasya krodhasya ca dinaṁ yāvat kiṁ svārthaṁ kopaṁ sañcinoṣi? ");
INSERT INTO sanias_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","kintu sa ekaikamanujāya tatkarmmānusāreṇa pratiphalaṁ dāsyati; ");
INSERT INTO sanias_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","vastutastu ye janā dhairyyaṁ dhṛtvā satkarmma kurvvanto mahimā satkāro'maratvañcaitāni mṛgayante tebhyo'nantāyu rdāsyati| ");
INSERT INTO sanias_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","aparaṁ ye janāḥ satyadharmmam agṛhītvā viparītadharmmam gṛhlanti tādṛśā virodhijanāḥ kopaṁ krodhañca bhokṣyante| ");
INSERT INTO sanias_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","ā yihūdino'nyadeśinaḥ paryyantaṁ yāvantaḥ kukarmmakāriṇaḥ prāṇinaḥ santi te sarvve duḥkhaṁ yātanāñca gamiṣyanti; ");
INSERT INTO sanias_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","kintu ā yihūdino bhinnadeśiparyyantā yāvantaḥ satkarmmakāriṇo lokāḥ santi tān prati mahimā satkāraḥ śāntiśca bhaviṣyanti| ");
INSERT INTO sanias_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","īśvarasya vicāre pakṣapāto nāsti| ");
INSERT INTO sanias_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","alabdhavyavasthāśāstrai ryaiḥ pāpāni kṛtāni vyavasthāśāstrālabdhatvānurūpasteṣāṁ vināśo bhaviṣyati; kintu labdhavyavasthāśāstrā ye pāpānyakurvvan vyavasthānusārādeva teṣāṁ vicāro bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","vyavasthāśrotāra īśvarasya samīpe niṣpāpā bhaviṣyantīti nahi kintu vyavasthācāriṇa eva sapuṇyā bhaviṣyanti| ");
INSERT INTO sanias_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","yato 'labdhavyavasthāśāstrā bhinnadeśīyalokā yadi svabhāvato vyavasthānurūpān ācārān kurvvanti tarhyalabdhaśāstrāḥ santo'pi te sveṣāṁ vyavasthāśāstramiva svayameva bhavanti| ");
INSERT INTO sanias_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","teṣāṁ manasi sākṣisvarūpe sati teṣāṁ vitarkeṣu ca kadā tān doṣiṇaḥ kadā vā nirdoṣān kṛtavatsu te svāntarlikhitasya vyavasthāśāstrasya pramāṇaṁ svayameva dadati| ");
INSERT INTO sanias_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","yasmin dine mayā prakāśitasya susaṁvādasyānusārād īśvaro yīśukhrīṣṭena mānuṣāṇām antaḥkaraṇānāṁ gūḍhābhiprāyān dhṛtvā vicārayiṣyati tasmin vicāradine tat prakāśiṣyate| ");
INSERT INTO sanias_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","paśya tvaṁ svayaṁ yihūdīti vikhyāto vyavasthopari viśvāsaṁ karoṣi, ");
INSERT INTO sanias_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","īśvaramuddiśya svaṁ ślāghase, tathā vyavasthayā śikṣito bhūtvā tasyābhimataṁ jānāsi, sarvvāsāṁ kathānāṁ sāraṁ viviṁkṣe, ");
INSERT INTO sanias_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","aparaṁ jñānasya satyatāyāścākarasvarūpaṁ śāstraṁ mama samīpe vidyata ato 'ndhalokānāṁ mārgadarśayitā ");
INSERT INTO sanias_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","timirasthitalokānāṁ madhye dīptisvarūpo'jñānalokebhyo jñānadātā śiśūnāṁ śikṣayitāhameveti manyase| ");
INSERT INTO sanias_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","parān śikṣayan svayaṁ svaṁ kiṁ na śikṣayasi? vastutaścauryyaniṣedhavyavasthāṁ pracārayan tvaṁ kiṁ svayameva corayasi? ");
INSERT INTO sanias_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","tathā paradāragamanaṁ pratiṣedhan svayaṁ kiṁ paradārān gacchasi? tathā tvaṁ svayaṁ pratimādveṣī san kiṁ mandirasya dravyāṇi harasi? ");
INSERT INTO sanias_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","yastvaṁ vyavasthāṁ ślāghase sa tvaṁ kiṁ vyavasthām avamatya neśvaraṁ sammanyase? ");
INSERT INTO sanias_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","śāstre yathā likhati \"bhinnadeśināṁ samīpe yuṣmākaṁ doṣād īśvarasya nāmno nindā bhavati|\" ");
INSERT INTO sanias_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","yadi vyavasthāṁ pālayasi tarhi tava tvakchedakriyā saphalā bhavati; yati vyavasthāṁ laṅghase tarhi tava tvakchedo'tvakchedo bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","yato vyavasthāśāstrādiṣṭadharmmakarmmācārī pumān atvakchedī sannapi kiṁ tvakchedināṁ madhye na gaṇayiṣyate? ");
INSERT INTO sanias_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","kintu labdhaśāstraśchinnatvak ca tvaṁ yadi vyavasthālaṅghanaṁ karoṣi tarhi vyavasthāpālakāḥ svābhāvikācchinnatvaco lokāstvāṁ kiṁ na dūṣayiṣyanti? ");
INSERT INTO sanias_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","tasmād yo bāhye yihūdī sa yihūdī nahi tathāṅgasya yastvakchedaḥ sa tvakchedo nahi; ");
INSERT INTO sanias_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","kintu yo jana āntariko yihūdī sa eva yihūdī aparañca kevalalikhitayā vyavasthayā na kintu mānasiko yastvakchedo yasya ca praśaṁsā manuṣyebhyo na bhūtvā īśvarād bhavati sa eva tvakchedaḥ| ");
INSERT INTO sanias_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","aparañca yihūdinaḥ kiṁ śreṣṭhatvaṁ? tathā tvakchedasya vā kiṁ phalaṁ? ");
INSERT INTO sanias_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","sarvvathā bahūni phalāni santi, viśeṣata īśvarasya śāstraṁ tebhyo'dīyata| ");
INSERT INTO sanias_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","kaiścid aviśvasane kṛte teṣām aviśvasanāt kim īśvarasya viśvāsyatāyā hānirutpatsyate? ");
INSERT INTO sanias_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","kenāpi prakāreṇa nahi| yadyapi sarvve manuṣyā mithyāvādinastathāpīśvaraḥ satyavādī| śāstre yathā likhitamāste, atastvantu svavākyena nirddoṣo hi bhaviṣyasi| vicāre caiva niṣpāpo bhaviṣyasi na saṁśayaḥ| ");
INSERT INTO sanias_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","asmākam anyāyena yadīśvarasya nyāyaḥ prakāśate tarhi kiṁ vadiṣyāmaḥ? ahaṁ mānuṣāṇāṁ kathāmiva kathāṁ kathayāmi, īśvaraḥ samucitaṁ daṇḍaṁ dattvā kim anyāyī bhaviṣyati? ");
INSERT INTO sanias_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","itthaṁ na bhavatu, tathā satīśvaraḥ kathaṁ jagato vicārayitā bhaviṣyati? ");
INSERT INTO sanias_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","mama mithyāvākyavadanād yadīśvarasya satyatvena tasya mahimā varddhate tarhi kasmādahaṁ vicāre'parādhitvena gaṇyo bhavāmi? ");
INSERT INTO sanias_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","maṅgalārthaṁ pāpamapi karaṇīyamiti vākyaṁ tvayā kuto nocyate? kintu yairucyate te nitāntaṁ daṇḍasya pātrāṇi bhavanti; tathāpi tadvākyam asmābhirapyucyata ityasmākaṁ glāniṁ kurvvantaḥ kiyanto lokā vadanti| ");
INSERT INTO sanias_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","anyalokebhyo vayaṁ kiṁ śreṣṭhāḥ? kadācana nahi yato yihūdino 'nyadeśinaśca sarvvaeva pāpasyāyattā ityasya pramāṇaṁ vayaṁ pūrvvam adadāma| ");
INSERT INTO sanias_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","lipi ryathāste, naikopi dhārmmiko janaḥ| ");
INSERT INTO sanias_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","tathā jñānīśvarajñānī mānavaḥ kopi nāsti hi| ");
INSERT INTO sanias_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","vimārgagāminaḥ sarvve sarvve duṣkarmmakāriṇaḥ| eko janopi no teṣāṁ sādhukarmma karoti ca| ");
INSERT INTO sanias_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","tathā teṣāntu vai kaṇṭhā anāvṛtaśmaśānavat| stutivādaṁ prakurvvanti jihvābhiste tu kevalaṁ| teṣāmoṣṭhasya nimne tu viṣaṁ tiṣṭhati sarppavat| ");
INSERT INTO sanias_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","mukhaṁ teṣāṁ hi śāpena kapaṭena ca pūryyate| ");
INSERT INTO sanias_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","raktapātāya teṣāṁ tu padāni kṣipragāni ca| ");
INSERT INTO sanias_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","pathi teṣāṁ manuṣyāṇāṁ nāśaḥ kleśaśca kevalaḥ| ");
INSERT INTO sanias_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","te janā nahi jānanti panthānaṁ sukhadāyinaṁ| ");
INSERT INTO sanias_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","parameśād bhayaṁ yattat taccakṣuṣoragocaraṁ| ");
INSERT INTO sanias_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","vyavasthāyāṁ yadyallikhati tad vyavasthādhīnān lokān uddiśya likhatīti vayaṁ jānīmaḥ| tato manuṣyamātro niruttaraḥ san īśvarasya sākṣād aparādhī bhavati| ");
INSERT INTO sanias_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","ataeva vyavasthānurūpaiḥ karmmabhiḥ kaścidapi prāṇīśvarasya sākṣāt sapuṇyīkṛto bhavituṁ na śakṣyati yato vyavasthayā pāpajñānamātraṁ jāyate| ");
INSERT INTO sanias_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","kintu vyavasthāyāḥ pṛthag īśvareṇa deyaṁ yat puṇyaṁ tad vyavasthāyā bhaviṣyadvādigaṇasya ca vacanaiḥ pramāṇīkṛtaṁ sad idānīṁ prakāśate| ");
INSERT INTO sanias_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","yīśukhrīṣṭe viśvāsakaraṇād īśvareṇa dattaṁ tat puṇyaṁ sakaleṣu prakāśitaṁ sat sarvvān viśvāsinaḥ prati varttate| ");
INSERT INTO sanias_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","teṣāṁ kopi prabhedo nāsti, yataḥ sarvvaeva pāpina īśvarīyatejohīnāśca jātāḥ| ");
INSERT INTO sanias_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","ta īśvarasyānugrahād mūlyaṁ vinā khrīṣṭakṛtena paritrāṇena sapuṇyīkṛtā bhavanti| ");
INSERT INTO sanias_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","yasmāt svaśoṇitena viśvāsāt pāpanāśako balī bhavituṁ sa eva pūrvvam īśvareṇa niścitaḥ, ittham īśvarīyasahiṣṇutvāt purākṛtapāpānāṁ mārjjanakaraṇe svīyayāthārthyaṁ tena prakāśyate, ");
INSERT INTO sanias_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","varttamānakālīyamapi svayāthārthyaṁ tena prakāśyate, aparaṁ yīśau viśvāsinaṁ sapuṇyīkurvvannapi sa yāthārthikastiṣṭhati| ");
INSERT INTO sanias_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","tarhi kutrātmaślāghā? sā dūrīkṛtā; kayā vyavasthayā? kiṁ kriyārūpavyavasthayā? itthaṁ nahi kintu tat kevalaviśvāsarūpayā vyavasthayaiva bhavati| ");
INSERT INTO sanias_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","ataeva vyavasthānurūpāḥ kriyā vinā kevalena viśvāsena mānavaḥ sapuṇyīkṛto bhavituṁ śaknotītyasya rāddhāntaṁ darśayāmaḥ| ");
INSERT INTO sanias_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","sa kiṁ kevalayihūdinām īśvaro bhavati? bhinnadeśinām īśvaro na bhavati? bhinnadeśināmapi bhavati; ");
INSERT INTO sanias_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","yasmād eka īśvaro viśvāsāt tvakchedino viśvāsenātvakchedinaśca sapuṇyīkariṣyati| ");
INSERT INTO sanias_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","tarhi viśvāsena vayaṁ kiṁ vyavasthāṁ lumpāma? itthaṁ na bhavatu vayaṁ vyavasthāṁ saṁsthāpayāma eva| ");
INSERT INTO sanias_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","asmākaṁ pūrvvapuruṣa ibrāhīm kāyikakriyayā kiṁ labdhavān etadadhi kiṁ vadiṣyāmaḥ? ");
INSERT INTO sanias_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","sa yadi nijakriyābhyaḥ sapuṇyo bhavet tarhi tasyātmaślāghāṁ karttuṁ panthā bhavediti satyaṁ, kintvīśvarasya samīpe nahi| ");
INSERT INTO sanias_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","śāstre kiṁ likhati? ibrāhīm īśvare viśvasanāt sa viśvāsastasmai puṇyārthaṁ gaṇito babhūva| ");
INSERT INTO sanias_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","karmmakāriṇo yad vetanaṁ tad anugrahasya phalaṁ nahi kintu tenopārjitaṁ mantavyam| ");
INSERT INTO sanias_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","kintu yaḥ pāpinaṁ sapuṇyīkaroti tasmin viśvāsinaḥ karmmahīnasya janasya yo viśvāsaḥ sa puṇyārthaṁ gaṇyo bhavati| ");
INSERT INTO sanias_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","aparaṁ yaṁ kriyāhīnam īśvaraḥ sapuṇyīkaroti tasya dhanyavādaṁ dāyūd varṇayāmāsa, yathā, ");
INSERT INTO sanias_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","sa dhanyo'ghāni mṛṣṭāni yasyāgāṁsyāvṛtāni ca| ");
INSERT INTO sanias_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","sa ca dhanyaḥ pareśena pāpaṁ yasya na gaṇyate| ");
INSERT INTO sanias_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","eṣa dhanyavādastvakchedinam atvakchedinaṁ vā kaṁ prati bhavati? ibrāhīmo viśvāsaḥ puṇyārthaṁ gaṇita iti vayaṁ vadāmaḥ| ");
INSERT INTO sanias_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","sa viśvāsastasya tvakcheditvāvasthāyāṁ kim atvakcheditvāvasthāyāṁ kasmin samaye puṇyamiva gaṇitaḥ? tvakcheditvāvasthāyāṁ nahi kintvatvakcheditvāvasthāyāṁ| ");
INSERT INTO sanias_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","aparañca sa yat sarvveṣām atvakchedināṁ viśvāsinām ādipuruṣo bhavet, te ca puṇyavattvena gaṇyeran; ");
INSERT INTO sanias_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","ye ca lokāḥ kevalaṁ chinnatvaco na santo 'smatpūrvvapuruṣa ibrāhīm achinnatvak san yena viśvāsamārgeṇa gatavān tenaiva tasya pādacihnena gacchanti teṣāṁ tvakchedināmapyādipuruṣo bhavet tadartham atvakchedino mānavasya viśvāsāt puṇyam utpadyata iti pramāṇasvarūpaṁ tvakchedacihnaṁ sa prāpnot| ");
INSERT INTO sanias_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","ibrāhīm jagato'dhikārī bhaviṣyati yaiṣā pratijñā taṁ tasya vaṁśañca prati pūrvvam akriyata sā vyavasthāmūlikā nahi kintu viśvāsajanyapuṇyamūlikā| ");
INSERT INTO sanias_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","yato vyavasthāvalambino yadyadhikāriṇo bhavanti tarhi viśvāso viphalo jāyate sā pratijñāpi luptaiva| ");
INSERT INTO sanias_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","adhikantu vyavasthā kopaṁ janayati yato 'vidyamānāyāṁ vyavasthāyām ājñālaṅghanaṁ na sambhavati| ");
INSERT INTO sanias_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","ataeva sā pratijñā yad anugrahasya phalaṁ bhavet tadarthaṁ viśvāsamūlikā yatastathātve tadvaṁśasamudāyaṁ prati arthato ye vyavasthayā tadvaṁśasambhavāḥ kevalaṁ tān prati nahi kintu ya ibrāhīmīyaviśvāsena tatsambhavāstānapi prati sā pratijñā sthāsnurbhavati| ");
INSERT INTO sanias_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","yo nirjīvān sajīvān avidyamānāni vastūni ca vidyamānāni karoti ibrāhīmo viśvāsabhūmestasyeśvarasya sākṣāt so'smākaṁ sarvveṣām ādipuruṣa āste, yathā likhitaṁ vidyate, ahaṁ tvāṁ bahujātīnām ādipuruṣaṁ kṛtvā niyuktavān| ");
INSERT INTO sanias_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","tvadīyastādṛśo vaṁśo janiṣyate yadidaṁ vākyaṁ pratiśrutaṁ tadanusārād ibrāhīm bahudeśīyalokānām ādipuruṣo yad bhavati tadarthaṁ so'napekṣitavyamapyapekṣamāṇo viśvāsaṁ kṛtavān| ");
INSERT INTO sanias_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","aparañca kṣīṇaviśvāso na bhūtvā śatavatsaravayaskatvāt svaśarīrasya jarāṁ sārānāmnaḥ svabhāryyāyā rajonivṛttiñca tṛṇāya na mene| ");
INSERT INTO sanias_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","aparam aviśvāsād īśvarasya pratijñāvacane kamapi saṁśayaṁ na cakāra; ");
INSERT INTO sanias_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","kintvīśvareṇa yat pratiśrutaṁ tat sādhayituṁ śakyata iti niścitaṁ vijñāya dṛḍhaviśvāsaḥ san īśvarasya mahimānaṁ prakāśayāñcakāra| ");
INSERT INTO sanias_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","iti hetostasya sa viśvāsastadīyapuṇyamiva gaṇayāñcakre| ");
INSERT INTO sanias_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","puṇyamivāgaṇyata tat kevalasya tasya nimittaṁ likhitaṁ nahi, asmākaṁ nimittamapi, ");
INSERT INTO sanias_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","yato'smākaṁ pāpanāśārthaṁ samarpito'smākaṁ puṇyaprāptyarthañcotthāpito'bhavat yo'smākaṁ prabhu ryīśustasyotthāpayitarīśvare ");
INSERT INTO sanias_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","yadi vayaṁ viśvasāmastarhyasmākamapi saeva viśvāsaḥ puṇyamiva gaṇayiṣyate| ");
INSERT INTO sanias_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","viśvāsena sapuṇyīkṛtā vayam īśvareṇa sārddhaṁ prabhuṇāsmākaṁ yīśukhrīṣṭena melanaṁ prāptāḥ| ");
INSERT INTO sanias_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","aparaṁ vayaṁ yasmin anugrahāśraye tiṣṭhāmastanmadhyaṁ viśvāsamārgeṇa tenaivānītā vayam īśvarīyavibhavaprāptipratyāśayā samānandāmaḥ| ");
INSERT INTO sanias_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","tat kevalaṁ nahi kintu kleśabhoge'pyānandāmo yataḥ kleśāाd dhairyyaṁ jāyata iti vayaṁ jānīmaḥ, ");
INSERT INTO sanias_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","dhairyyācca parīkṣitatvaṁ jāyate, parīkṣitatvāt pratyāśā jāyate, ");
INSERT INTO sanias_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","pratyāśāto vrīḍitatvaṁ na jāyate, yasmād asmabhyaṁ dattena pavitreṇātmanāsmākam antaḥkaraṇānīśvarasya premavāriṇā siktāni| ");
INSERT INTO sanias_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","asmāsu nirupāyeṣu satsu khrīṣṭa upayukte samaye pāpināṁ nimittaṁ svīyān praṇān atyajat| ");
INSERT INTO sanias_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","hitakāriṇo janasya kṛte kopi praṇān tyaktuṁ sāhasaṁ karttuṁ śaknoti, kintu dhārmmikasya kṛte prāyeṇa kopi prāṇān na tyajati| ");
INSERT INTO sanias_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","kintvasmāsu pāpiṣu satsvapi nimittamasmākaṁ khrīṣṭaḥ svaprāṇān tyaktavān, tata īśvarosmān prati nijaṁ paramapremāṇaṁ darśitavān| ");
INSERT INTO sanias_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","ataeva tasya raktapātena sapuṇyīkṛtā vayaṁ nitāntaṁ tena kopād uddhāriṣyāmahe| ");
INSERT INTO sanias_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","phalato vayaṁ yadā ripava āsma tadeśvarasya putrasya maraṇena tena sārddhaṁ yadyasmākaṁ melanaṁ jātaṁ tarhi melanaprāptāḥ santo'vaśyaṁ tasya jīvanena rakṣāṁ lapsyāmahe| ");
INSERT INTO sanias_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","tat kevalaṁ nahi kintu yena melanam alabhāmahi tenāsmākaṁ prabhuṇā yīśukhrīṣṭena sāmpratam īśvare samānandāmaśca| ");
INSERT INTO sanias_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","tathā sati, ekena mānuṣeṇa pāpaṁ pāpena ca maraṇaṁ jagatīṁ prāviśat aparaṁ sarvveṣāṁ pāpitvāt sarvve mānuṣā mṛte rnighnā abhavat| ");
INSERT INTO sanias_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","yato vyavasthādānasamayaṁ yāvat jagati pāpam āsīt kintu yatra vyavasthā na vidyate tatra pāpasyāpi gaṇanā na vidyate| ");
INSERT INTO sanias_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","tathāpyādamā yādṛśaṁ pāpaṁ kṛtaṁ tādṛśaṁ pāpaṁ yai rnākāri ādamam ārabhya mūsāṁ yāvat teṣāmapyupari mṛtyū rājatvam akarot sa ādam bhāvyādamo nidarśanamevāste| ");
INSERT INTO sanias_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","kintu pāpakarmmaṇo yādṛśo bhāvastādṛg dānakarmmaṇo bhāvo na bhavati yata ekasya janasyāparādhena yadi bahūnāṁ maraṇam aghaṭata tathāpīśvarānugrahastadanugrahamūlakaṁ dānañcaikena janenārthād yīśunā khrīṣṭena bahuṣu bāhulyātibāhulyena phalati| ");
INSERT INTO sanias_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","aparam ekasya janasya pāpakarmma yādṛk phalayuktaṁ dānakarmma tādṛk na bhavati yato vicārakarmmaikaṁ pāpam ārabhya daṇḍajanakaṁ babhūva, kintu dānakarmma bahupāpānyārabhya puṇyajanakaṁ babhūva| ");
INSERT INTO sanias_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","yata ekasya janasya pāpakarmmatastenaikena yadi maraṇasya rājatvaṁ jātaṁ tarhi ye janā anugrahasya bāhulyaṁ puṇyadānañca prāpnuvanti ta ekena janena, arthāt yīśukhrīṣṭena, jīvane rājatvam avaśyaṁ kariṣyanti| ");
INSERT INTO sanias_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","eko'parādho yadvat sarvvamānavānāṁ daṇḍagāmī mārgo 'bhavat tadvad ekaṁ puṇyadānaṁ sarvvamānavānāṁ jīvanayuktapuṇyagāmī mārga eva| ");
INSERT INTO sanias_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","aparam ekasya janasyājñālaṅghanād yathā bahavo 'parādhino jātāstadvad ekasyājñācaraṇād bahavaḥ sapuṇyīkṛtā bhavanti| ");
INSERT INTO sanias_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","adhikantu vyavasthāgamanād aparādhasya bāhulyaṁ jātaṁ kintu yatra pāpasya bāhulyaṁ tatraiva tasmād anugrahasya bāhulyam abhavat| ");
INSERT INTO sanias_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","tena mṛtyunā yadvat pāpasya rājatvam abhavat tadvad asmākaṁ prabhuyīśukhrīṣṭadvārānantajīvanadāyipuṇyenānugrahasya rājatvaṁ bhavati| ");
INSERT INTO sanias_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","prabhūtarūpeṇa yad anugrahaḥ prakāśate tadarthaṁ pāpe tiṣṭhāma iti vākyaṁ kiṁ vayaṁ vadiṣyāmaḥ? tanna bhavatu| ");
INSERT INTO sanias_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","pāpaṁ prati mṛtā vayaṁ punastasmin katham jīviṣyāmaḥ? ");
INSERT INTO sanias_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","vayaṁ yāvanto lokā yīśukhrīṣṭe majjitā abhavāma tāvanta eva tasya maraṇe majjitā iti kiṁ yūyaṁ na jānītha? ");
INSERT INTO sanias_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","tato yathā pituḥ parākrameṇa śmaśānāt khrīṣṭa utthāpitastathā vayamapi yat nūtanajīvina ivācarāmastadarthaṁ majjanena tena sārddhaṁ mṛtyurūpe śmaśāne saṁsthāpitāḥ| ");
INSERT INTO sanias_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","aparaṁ vayaṁ yadi tena saṁyuktāḥ santaḥ sa iva maraṇabhāgino jātāstarhi sa ivotthānabhāgino'pi bhaviṣyāmaḥ| ");
INSERT INTO sanias_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","vayaṁ yat pāpasya dāsāḥ puna rna bhavāmastadartham asmākaṁ pāparūpaśarīrasya vināśārtham asmākaṁ purātanapuruṣastena sākaṁ kruśe'hanyateti vayaṁ jānīmaḥ| ");
INSERT INTO sanias_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","yo hataḥ sa pāpāt mukta eva| ");
INSERT INTO sanias_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","ataeva yadi vayaṁ khrīṣṭena sārddham ahanyāmahi tarhi punarapi tena sahitā jīviṣyāma ityatrāsmākaṁ viśvāso vidyate| ");
INSERT INTO sanias_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","yataḥ śmaśānād utthāpitaḥ khrīṣṭo puna rna mriyata iti vayaṁ jānīmaḥ| tasmin kopyadhikāro mṛtyo rnāsti| ");
INSERT INTO sanias_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","aparañca sa yad amriyata tenaikadā pāpam uddiśyāmriyata, yacca jīvati teneśvaram uddiśya jīvati; ");
INSERT INTO sanias_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","tadvad yūyamapi svān pāpam uddiśya mṛtān asmākaṁ prabhuṇā yīśukhrīṣṭeneśvaram uddiśya jīvanto jānīta| ");
INSERT INTO sanias_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","aparañca kutsitābhilāṣāाn pūrayituṁ yuṣmākaṁ martyadeheṣu pāpam ādhipatyaṁ na karotu| ");
INSERT INTO sanias_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","aparaṁ svaṁ svam aṅgam adharmmasyāstraṁ kṛtvā pāpasevāyāṁ na samarpayata, kintu śmaśānād utthitāniva svān īśvare samarpayata svānyaṅgāni ca dharmmāstrasvarūpāṇīśvaram uddiśya samarpayata| ");
INSERT INTO sanias_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","yuṣmākam upari pāpasyādhipatyaṁ puna rna bhaviṣyati, yasmād yūyaṁ vyavasthāyā anāyattā anugrahasya cāyattā abhavata| ");
INSERT INTO sanias_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","kintu vayaṁ vyavasthāyā anāyattā anugrahasya cāyattā abhavāma, iti kāraṇāt kiṁ pāpaṁ kariṣyāmaḥ? tanna bhavatu| ");
INSERT INTO sanias_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","yato mṛtijanakaṁ pāpaṁ puṇyajanakaṁ nideśācaraṇañcaitayordvayo ryasmin ājñāpālanārthaṁ bhṛtyāniva svān samarpayatha, tasyaiva bhṛtyā bhavatha, etat kiṁ yūyaṁ na jānītha? ");
INSERT INTO sanias_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","aparañca pūrvvaṁ yūyaṁ pāpasya bhṛtyā āsteti satyaṁ kintu yasyāṁ śikṣārūpāyāṁ mūṣāyāṁ nikṣiptā abhavata tasyā ākṛtiṁ manobhi rlabdhavanta iti kāraṇād īśvarasya dhanyavādo bhavatu| ");
INSERT INTO sanias_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","itthaṁ yūyaṁ pāpasevāto muktāḥ santo dharmmasya bhṛtyā jātāḥ| ");
INSERT INTO sanias_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","yuṣmākaṁ śārīrikyā durbbalatāyā heto rmānavavad aham etad bravīmi; punaḥ punaradharmmakaraṇārthaṁ yadvat pūrvvaṁ pāpāmedhyayo rbhṛtyatve nijāṅgāni samārpayata tadvad idānīṁ sādhukarmmakaraṇārthaṁ dharmmasya bhṛtyatve nijāṅgāni samarpayata| ");
INSERT INTO sanias_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","yadā yūyaṁ pāpasya bhṛtyā āsta tadā dharmmasya nāyattā āsta| ");
INSERT INTO sanias_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","tarhi yāni karmmāṇi yūyam idānīṁ lajjājanakāni budhyadhve pūrvvaṁ tai ryuṣmākaṁ ko lābha āsīt? teṣāṁ karmmaṇāṁ phalaṁ maraṇameva| ");
INSERT INTO sanias_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","kintu sāmprataṁ yūyaṁ pāpasevāto muktāḥ santa īśvarasya bhṛtyā'bhavata tasmād yuṣmākaṁ pavitratvarūpaṁ labhyam anantajīvanarūpañca phalam āste| ");
INSERT INTO sanias_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","yataḥ pāpasya vetanaṁ maraṇaṁ kintvasmākaṁ prabhuṇā yīśukhrīṣṭenānantajīvanam īśvaradattaṁ pāritoṣikam āste| ");
INSERT INTO sanias_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","he bhrātṛgaṇa vyavasthāvidaḥ prati mamedaṁ nivedanaṁ| vidhiḥ kevalaṁ yāvajjīvaṁ mānavoparyyadhipatitvaṁ karotīti yūyaṁ kiṁ na jānītha? ");
INSERT INTO sanias_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","yāvatkālaṁ pati rjīvati tāvatkālam ūḍhā bhāryyā vyavasthayā tasmin baddhā tiṣṭhati kintu yadi pati rmriyate tarhi sā nārī patyu rvyavasthāto mucyate| ");
INSERT INTO sanias_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","etatkāraṇāt patyurjīvanakāle nārī yadyanyaṁ puruṣaṁ vivahati tarhi sā vyabhicāriṇī bhavati kintu yadi sa pati rmriyate tarhi sā tasyā vyavasthāyā muktā satī puruṣāntareṇa vyūḍhāpi vyabhicāriṇī na bhavati| ");
INSERT INTO sanias_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","he mama bhrātṛgaṇa, īśvaranimittaṁ yadasmākaṁ phalaṁ jāyate tadarthaṁ śmaśānād utthāpitena puruṣeṇa saha yuṣmākaṁ vivāho yad bhavet tadarthaṁ khrīṣṭasya śarīreṇa yūyaṁ vyavasthāṁ prati mṛtavantaḥ| ");
INSERT INTO sanias_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","yato'smākaṁ śārīrikācaraṇasamaye maraṇanimittaṁ phalam utpādayituṁ vyavasthayā dūṣitaḥ pāpābhilāṣo'smākam aṅgeṣu jīvan āsīt| ");
INSERT INTO sanias_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","kintu tadā yasyā vyavasthāyā vaśe āsmahi sāmprataṁ tāṁ prati mṛtatvād vayaṁ tasyā adhīnatvāt muktā iti hetorīśvaro'smābhiḥ purātanalikhitānusārāt na sevitavyaḥ kintu navīnasvabhāvenaiva sevitavyaḥ ");
INSERT INTO sanias_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","tarhi vayaṁ kiṁ brūmaḥ? vyavasthā kiṁ pāpajanikā bhavati? netthaṁ bhavatu| vyavasthām avidyamānāyāṁ pāpaṁ kim ityahaṁ nāvedaṁ; kiñca lobhaṁ mā kārṣīriti ced vyavasthāgranthe likhitaṁ nābhaviṣyat tarhi lobhaḥ kimbhūtastadahaṁ nājñāsyaṁ| ");
INSERT INTO sanias_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","kintu vyavasthayā pāpaṁ chidraṁ prāpyāsmākam antaḥ sarvvavidhaṁ kutsitābhilāṣam ajanayat; yato vyavasthāyām avidyamānāyāṁ pāpaṁ mṛtaṁ| ");
INSERT INTO sanias_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","aparaṁ pūrvvaṁ vyavasthāyām avidyamānāyām aham ajīvaṁ tataḥ param ājñāyām upasthitāyām pāpam ajīvat tadāham amriye| ");
INSERT INTO sanias_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","itthaṁ sati jīvananimittā yājñā sā mama mṛtyujanikābhavat| ");
INSERT INTO sanias_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","yataḥ pāpaṁ chidraṁ prāpya vyavasthitādeśena māṁ vañcayitvā tena mām ahan| ");
INSERT INTO sanias_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","ataeva vyavasthā pavitrā, ādeśaśca pavitro nyāyyo hitakārī ca bhavati| ");
INSERT INTO sanias_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","tarhi yat svayaṁ hitakṛt tat kiṁ mama mṛtyujanakam abhavat? netthaṁ bhavatu; kintu pāpaṁ yat pātakamiva prakāśate tathā nideśena pāpaṁ yadatīva pātakamiva prakāśate tadarthaṁ hitopāyena mama maraṇam ajanayat| ");
INSERT INTO sanias_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","vyavasthātmabodhiketi vayaṁ jānīmaḥ kintvahaṁ śārīratācārī pāpasya krītakiṅkaro vidye| ");
INSERT INTO sanias_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","yato yat karmma karomi tat mama mano'bhimataṁ nahi; aparaṁ yan mama mano'bhimataṁ tanna karomi kintu yad ṛtīye tat karomi| ");
INSERT INTO sanias_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","tathātve yan mamānabhimataṁ tad yadi karomi tarhi vyavasthā sūttameti svīkaromi| ");
INSERT INTO sanias_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","ataeva samprati tat karmma mayā kriyata iti nahi kintu mama śarīrasthena pāpenaiva kriyate| ");
INSERT INTO sanias_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","yato mayi, arthato mama śarīre, kimapyuttamaṁ na vasati, etad ahaṁ jānāmi; mamecchukatāyāṁ tiṣṭhantyāmapyaham uttamakarmmasādhane samartho na bhavāmi| ");
INSERT INTO sanias_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","yato yāmuttamāṁ kriyāṁ karttumahaṁ vāñchāmi tāṁ na karomi kintu yat kutsitaṁ karmma karttum anicchuko'smi tadeva karomi| ");
INSERT INTO sanias_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","ataeva yadyat karmma karttuṁ mamecchā na bhavati tad yadi karomi tarhi tat mayā na kriyate, mamāntarvarttinā pāpenaiva kriyate| ");
INSERT INTO sanias_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","bhadraṁ karttum icchukaṁ māṁ yo 'bhadraṁ karttuṁ pravarttayati tādṛśaṁ svabhāvamekaṁ mayi paśyāmi| ");
INSERT INTO sanias_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","aham āntarikapuruṣeṇeśvaravyavasthāyāṁ santuṣṭa āse; ");
INSERT INTO sanias_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","kintu tadviparītaṁ yudhyantaṁ tadanyamekaṁ svabhāvaṁ madīyāṅgasthitaṁ prapaśyāmi, sa madīyāṅgasthitapāpasvabhāvasyāyattaṁ māṁ karttuṁ ceṣṭate| ");
INSERT INTO sanias_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","hā hā yo'haṁ durbhāgyo manujastaṁ mām etasmān mṛtāccharīrāt ko nistārayiṣyati? ");
INSERT INTO sanias_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","asmākaṁ prabhuṇā yīśukhrīṣṭena nistārayitāram īśvaraṁ dhanyaṁ vadāmi| ataeva śarīreṇa pāpavyavasthāyā manasā tu īśvaravyavasthāyāḥ sevanaṁ karomi| ");
INSERT INTO sanias_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","ye janāḥ khrīṣṭaṁ yīśum āśritya śārīrikaṁ nācaranta ātmikamācaranti te'dhunā daṇḍārhā na bhavanti| ");
INSERT INTO sanias_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","jīvanadāyakasyātmano vyavasthā khrīṣṭayīśunā pāpamaraṇayo rvyavasthāto māmamocayat| ");
INSERT INTO sanias_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","yasmācchārīrasya durbbalatvād vyavasthayā yat karmmāsādhyam īśvaro nijaputraṁ pāpiśarīrarūpaṁ pāpanāśakabalirūpañca preṣya tasya śarīre pāpasya daṇḍaṁ kurvvan tatkarmma sādhitavān| ");
INSERT INTO sanias_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","tataḥ śārīrikaṁ nācaritvāsmābhirātmikam ācaradbhirvyavasthāgranthe nirddiṣṭāni puṇyakarmmāṇi sarvvāṇi sādhyante| ");
INSERT INTO sanias_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","ye śārīrikācāriṇaste śārīrikān viṣayān bhāvayanti ye cātmikācāriṇaste ātmano viṣayān bhāvayanti| ");
INSERT INTO sanias_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","śārīrikabhāvasya phalaṁ mṛtyuḥ kiñcātmikabhāvasya phale jīvanaṁ śāntiśca| ");
INSERT INTO sanias_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","yataḥ śārīrikabhāva īśvarasya viruddhaḥ śatrutābhāva eva sa īśvarasya vyavasthāyā adhīno na bhavati bhavituñca na śaknoti| ");
INSERT INTO sanias_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","etasmāt śārīrikācāriṣu toṣṭum īśvareṇa na śakyaṁ| ");
INSERT INTO sanias_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","kintvīśvarasyātmā yadi yuṣmākaṁ madhye vasati tarhi yūyaṁ śārīrikācāriṇo na santa ātmikācāriṇo bhavathaḥ| yasmin tu khrīṣṭasyātmā na vidyate sa tatsambhavo nahi| ");
INSERT INTO sanias_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","yadi khrīṣṭo yuṣmān adhitiṣṭhati tarhi pāpam uddiśya śarīraṁ mṛtaṁ kintu puṇyamuddiśyātmā jīvati| ");
INSERT INTO sanias_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","mṛtagaṇād yīśu ryenotthāpitastasyātmā yadi yuṣmanmadhye vasati tarhi mṛtagaṇāt khrīṣṭasya sa utthāpayitā yuṣmanmadhyavāsinā svakīyātmanā yuṣmākaṁ mṛtadehānapi puna rjīvayiṣyati| ");
INSERT INTO sanias_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","he bhrātṛgaṇa śarīrasya vayamadhamarṇā na bhavāmo'taḥ śārīrikācāro'smābhi rna karttavyaḥ| ");
INSERT INTO sanias_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","yadi yūyaṁ śarīrikācāriṇo bhaveta tarhi yuṣmābhi rmarttavyameva kintvātmanā yadi śarīrakarmmāṇi ghātayeta tarhi jīviṣyatha| ");
INSERT INTO sanias_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","yato yāvanto lokā īśvarasyātmanākṛṣyante te sarvva īśvarasya santānā bhavanti| ");
INSERT INTO sanias_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","yūyaṁ punarapi bhayajanakaṁ dāsyabhāvaṁ na prāptāḥ kintu yena bhāveneśvaraṁ pitaḥ pitariti procya sambodhayatha tādṛśaṁ dattakaputratvabhāvam prāpnuta| ");
INSERT INTO sanias_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","aparañca vayam īśvarasya santānā etasmin pavitra ātmā svayam asmākam ātmābhiḥ sārddhaṁ pramāṇaṁ dadāti| ");
INSERT INTO sanias_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","ataeva vayaṁ yadi santānāstarhyadhikāriṇaḥ, arthād īśvarasya svattvādhikāriṇaḥ khrīṣṭena sahādhikāriṇaśca bhavāmaḥ; aparaṁ tena sārddhaṁ yadi duḥkhabhāgino bhavāmastarhi tasya vibhavasyāpi bhāgino bhaviṣyāmaḥ| ");
INSERT INTO sanias_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","kintvasmāsu yo bhāvīvibhavaḥ prakāśiṣyate tasya samīpe varttamānakālīnaṁ duḥkhamahaṁ tṛṇāya manye| ");
INSERT INTO sanias_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","yataḥ prāṇigaṇa īśvarasya santānānāṁ vibhavaprāptim ākāṅkṣan nitāntam apekṣate| ");
INSERT INTO sanias_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","aparañca prāṇigaṇaḥ svairam alīkatāyā vaśīkṛto nābhavat ");
INSERT INTO sanias_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","kintu prāṇigaṇo'pi naśvaratādhīnatvāt muktaḥ san īśvarasya santānānāṁ paramamuktiṁ prāpsyatītyabhiprāyeṇa vaśīkartrā vaśīcakre| ");
INSERT INTO sanias_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","aparañca prasūyamānāvad vyathitaḥ san idānīṁ yāvat kṛtsnaḥ prāṇigaṇa ārttasvaraṁ karotīti vayaṁ jānīmaḥ| ");
INSERT INTO sanias_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","kevalaḥ sa iti nahi kintu prathamajātaphalasvarūpam ātmānaṁ prāptā vayamapi dattakaputratvapadaprāptim arthāt śarīrasya muktiṁ pratīkṣamāṇāstadvad antarārttarāvaṁ kurmmaḥ| ");
INSERT INTO sanias_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","vayaṁ pratyāśayā trāṇam alabhāmahi kintu pratyakṣavastuno yā pratyāśā sā pratyāśā nahi, yato manuṣyo yat samīkṣate tasya pratyāśāṁ kutaḥ kariṣyati? ");
INSERT INTO sanias_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","yad apratyakṣaṁ tasya pratyāśāṁ yadi vayaṁ kurvvīmahi tarhi dhairyyam avalambya pratīkṣāmahe| ");
INSERT INTO sanias_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","tata ātmāpi svayam asmākaṁ durbbalatāyāḥ sahāyatvaṁ karoti; yataḥ kiṁ prārthitavyaṁ tad boddhuṁ vayaṁ na śaknumaḥ, kintvaspaṣṭairārttarāvairātmā svayam asmannimittaṁ nivedayati| ");
INSERT INTO sanias_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","aparam īśvarābhimatarūpeṇa pavitralokānāṁ kṛte nivedayati ya ātmā tasyābhiprāyo'ntaryyāminā jñāyate| ");
INSERT INTO sanias_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","aparam īśvarīyanirūpaṇānusāreṇāhūtāḥ santo ye tasmin prīyante sarvvāṇi militvā teṣāṁ maṅgalaṁ sādhayanti, etad vayaṁ jānīmaḥ| ");
INSERT INTO sanias_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","yata īśvaro bahubhrātṛṇāṁ madhye svaputraṁ jyeṣṭhaṁ karttum icchan yān pūrvvaṁ lakṣyīkṛtavān tān tasya pratimūrtyāḥ sādṛśyaprāptyarthaṁ nyayuṁkta| ");
INSERT INTO sanias_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","aparañca tena ye niyuktāsta āhūtā api ye ca tenāhūtāste sapuṇyīkṛtāḥ, ye ca tena sapuṇyīkṛtāste vibhavayuktāḥ| ");
INSERT INTO sanias_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","ityatra vayaṁ kiṁ brūmaḥ? īśvaro yadyasmākaṁ sapakṣo bhavati tarhi ko vipakṣo'smākaṁ? ");
INSERT INTO sanias_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","ātmaputraṁ na rakṣitvā yo'smākaṁ sarvveṣāṁ kṛte taṁ pradattavān sa kiṁ tena sahāsmabhyam anyāni sarvvāṇi na dāsyati? ");
INSERT INTO sanias_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","īśvarasyābhiruciteṣu kena doṣa āropayiṣyate? ya īśvarastān puṇyavata iva gaṇayati kiṁ tena? ");
INSERT INTO sanias_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","aparaṁ tebhyo daṇḍadānājñā vā kena kariṣyate? yo'smannimittaṁ prāṇān tyaktavān kevalaṁ tanna kintu mṛtagaṇamadhyād utthitavān, api ceśvarasya dakṣiṇe pārśve tiṣṭhan adyāpyasmākaṁ nimittaṁ prārthata evambhūto yaḥ khrīṣṭaḥ kiṁ tena? ");
INSERT INTO sanias_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","asmābhiḥ saha khrīṣṭasya premavicchedaṁ janayituṁ kaḥ śaknoti? kleśo vyasanaṁ vā tāḍanā vā durbhikṣaṁ vā vastrahīnatvaṁ vā prāṇasaṁśayo vā khaṅgo vā kimetāni śaknuvanti? ");
INSERT INTO sanias_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","kintu likhitam āste, yathā, vayaṁ tava nimittaṁ smo mṛtyuvaktre'khilaṁ dinaṁ| balirdeyo yathā meṣo vayaṁ gaṇyāmahe tathā| ");
INSERT INTO sanias_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","aparaṁ yo'smāsu prīyate tenaitāsu vipatsu vayaṁ samyag vijayāmahe| ");
INSERT INTO sanias_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","yato'smākaṁ prabhunā yīśukhrīṣṭeneśvarasya yat prema tasmād asmākaṁ vicchedaṁ janayituṁ mṛtyu rjīvanaṁ vā divyadūtā vā balavanto mukhyadūtā vā varttamāno vā bhaviṣyan kālo vā uccapadaṁ vā nīcapadaṁ vāparaṁ kimapi sṛṣṭavastu ");
INSERT INTO sanias_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","vaiteṣāṁ kenāpi na śakyamityasmin dṛḍhaviśvāso mamāste| ");
INSERT INTO sanias_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","ahaṁ kāñcid kalpitāṁ kathāṁ na kathayāmi, khrīṣṭasya sākṣāt satyameva bravīmi pavitrasyātmanaḥ sākṣān madīyaṁ mana etat sākṣyaṁ dadāti| ");
INSERT INTO sanias_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","mamāntaratiśayaduḥkhaṁ nirantaraṁ khedaśca ");
INSERT INTO sanias_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","tasmād ahaṁ svajātīyabhrātṛṇāṁ nimittāt svayaṁ khrīṣṭācchāpākrānto bhavitum aiccham| ");
INSERT INTO sanias_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","yatasta isrāyelasya vaṁśā api ca dattakaputratvaṁ tejo niyamo vyavasthādānaṁ mandire bhajanaṁ pratijñāḥ pitṛpuruṣagaṇaścaiteṣu sarvveṣu teṣām adhikāro'sti| ");
INSERT INTO sanias_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","tat kevalaṁ nahi kintu sarvvādhyakṣaḥ sarvvadā saccidānanda īśvaro yaḥ khrīṣṭaḥ so'pi śārīrikasambandhena teṣāṁ vaṁśasambhavaḥ| ");
INSERT INTO sanias_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","īśvarasya vākyaṁ viphalaṁ jātam iti nahi yatkāraṇād isrāyelo vaṁśe ye jātāste sarvve vastuta isrāyelīyā na bhavanti| ");
INSERT INTO sanias_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","aparam ibrāhīmo vaṁśe jātā api sarvve tasyaiva santānā na bhavanti kintu ishāko nāmnā tava vaṁśo vikhyāto bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","arthāt śārīrikasaṁsargāt jātāḥ santānā yāvantastāvanta eveśvarasya santānā na bhavanti kintu pratiśravaṇād ye jāyante taeveśvaravaṁśo gaṇyate| ");
INSERT INTO sanias_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","yatastatpratiśrute rvākyametat, etādṛśe samaye 'haṁ punarāgamiṣyāmi tatpūrvvaṁ sārāyāḥ putra eko janiṣyate| ");
INSERT INTO sanias_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","aparamapi vadāmi svamano'bhilāṣata īśvareṇa yannirūpitaṁ tat karmmato nahi kintvāhvayitu rjātametad yathā siddhyati ");
INSERT INTO sanias_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","tadarthaṁ ribkānāmikayā yoṣitā janaikasmād arthād asmākam ishākaḥ pūrvvapuruṣād garbhe dhṛte tasyāḥ santānayoḥ prasavāt pūrvvaṁ kiñca tayoḥ śubhāśubhakarmmaṇaḥ karaṇāt pūrvvaṁ ");
INSERT INTO sanias_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","tāṁ pratīdaṁ vākyam uktaṁ, jyeṣṭhaḥ kaniṣṭhaṁ seviṣyate, ");
INSERT INTO sanias_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","yathā likhitam āste, tathāpyeṣāvi na prītvā yākūbi prītavān ahaṁ| ");
INSERT INTO sanias_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","tarhi vayaṁ kiṁ brūmaḥ? īśvaraḥ kim anyāyakārī? tathā na bhavatu| ");
INSERT INTO sanias_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","yataḥ sa svayaṁ mūsām avadat; ahaṁ yasmin anugrahaṁ cikīrṣāmi tamevānugṛhlāmi, yañca dayitum icchāmi tameva daye| ");
INSERT INTO sanias_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","ataevecchatā yatamānena vā mānavena tanna sādhyate dayākāriṇeśvareṇaiva sādhyate| ");
INSERT INTO sanias_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","phirauṇi śāstre likhati, ahaṁ tvaddvārā matparākramaṁ darśayituṁ sarvvapṛthivyāṁ nijanāma prakāśayituñca tvāṁ sthāpitavān| ");
INSERT INTO sanias_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","ataḥ sa yam anugrahītum icchati tamevānugṛhlāti, yañca nigrahītum icchati taṁ nigṛhlāti| ");
INSERT INTO sanias_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","yadi vadasi tarhi sa doṣaṁ kuto gṛhlāti? tadīyecchāyāḥ pratibandhakatvaṁ karttaṁ kasya sāmarthyaṁ vidyate? ");
INSERT INTO sanias_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","he īśvarasya pratipakṣa martya tvaṁ kaḥ? etādṛśaṁ māṁ kutaḥ sṛṣṭavān? iti kathāṁ sṛṣṭavastu sraṣṭre kiṁ kathayiṣyati? ");
INSERT INTO sanias_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","ekasmān mṛtpiṇḍād utkṛṣṭāpakṛṣṭau dvividhau kalaśau karttuṁ kiṁ kulālasya sāmarthyaṁ nāsti? ");
INSERT INTO sanias_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","īśvaraḥ kopaṁ prakāśayituṁ nijaśaktiṁ jñāpayituñcecchan yadi vināśasya yogyāni krodhabhājanāni prati bahukālaṁ dīrghasahiṣṇutām āśrayati; ");
INSERT INTO sanias_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","aparañca vibhavaprāptyarthaṁ pūrvvaṁ niyuktānyanugrahapātrāṇi prati nijavibhavasya bāhulyaṁ prakāśayituṁ kevalayihūdināṁ nahi bhinnadeśināmapi madhyād ");
INSERT INTO sanias_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","asmāniva tānyāhvayati tatra tava kiṁ? ");
INSERT INTO sanias_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","hośeyagranthe yathā likhitam āste, yo loko mama nāsīt taṁ vadiṣyāmi madīyakaṁ| yā jāti rme'priyā cāsīt tāṁ vadiṣyāmyahaṁ priyāṁ| ");
INSERT INTO sanias_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","yūyaṁ madīyalokā na yatreti vākyamaucyata| amareśasya santānā iti khyāsyanti tatra te| ");
INSERT INTO sanias_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","isrāyelīyalokeṣu yiśāyiyo'pi vācametāṁ prācārayat, isrāyelīyavaṁśānāṁ yā saṁkhyā sā tu niścitaṁ| samudrasikatāsaṁkhyāsamānā yadi jāyate| tathāpi kevalaṁ lokairalpaistrāṇaṁ vrajiṣyate| ");
INSERT INTO sanias_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","yato nyāyena svaṁ karmma pareśaḥ sādhayiṣyati| deśe saeva saṁkṣepānnijaṁ karmma kariṣyati| ");
INSERT INTO sanias_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","yiśāyiyo'paramapi kathayāmāsa, sainyādhyakṣapareśena cet kiñcinnodaśiṣyata| tadā vayaṁ sidomevābhaviṣyāma viniścitaṁ| yadvā vayam amorāyā agamiṣyāma tulyatāṁ| ");
INSERT INTO sanias_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","tarhi vayaṁ kiṁ vakṣyāmaḥ? itaradeśīyā lokā api puṇyārtham ayatamānā viśvāsena puṇyam alabhanta; ");
INSERT INTO sanias_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","kintvisrāyellokā vyavasthāpālanena puṇyārthaṁ yatamānāstan nālabhanta| ");
INSERT INTO sanias_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","tasya kiṁ kāraṇaṁ? te viśvāsena nahi kintu vyavasthāyāḥ kriyayā ceṣṭitvā tasmin skhalanajanake pāṣāṇe pādaskhalanaṁ prāptāḥ| ");
INSERT INTO sanias_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","likhitaṁ yādṛśam āste, paśya pādaskhalārthaṁ hi sīyoni prastarantathā| bādhākārañca pāṣāṇaṁ paristhāpitavānaham| viśvasiṣyati yastatra sa jano na trapiṣyate| ");
INSERT INTO sanias_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","he bhrātara isrāyelīyalokā yat paritrāṇaṁ prāpnuvanti tadahaṁ manasābhilaṣan īśvarasya samīpe prārthaye| ");
INSERT INTO sanias_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","yata īśvare teṣāṁ ceṣṭā vidyata ityatrāhaṁ sākṣyasmi; kintu teṣāṁ sā ceṣṭā sajñānā nahi, ");
INSERT INTO sanias_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","yatasta īśvaradattaṁ puṇyam avijñāya svakṛtapuṇyaṁ sthāpayitum ceṣṭamānā īśvaradattasya puṇyasya nighnatvaṁ na svīkurvvanti| ");
INSERT INTO sanias_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","khrīṣṭa ekaikaviśvāsijanāya puṇyaṁ dātuṁ vyavasthāyāḥ phalasvarūpo bhavati| ");
INSERT INTO sanias_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","vyavasthāpālanena yat puṇyaṁ tat mūsā varṇayāmāsa, yathā, yo janastāṁ pālayiṣyati sa taddvārā jīviṣyati| ");
INSERT INTO sanias_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","kintu pratyayena yat puṇyaṁ tad etādṛśaṁ vākyaṁ vadati, kaḥ svargam āruhya khrīṣṭam avarohayiṣyati? ");
INSERT INTO sanias_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","ko vā pretalokam avaruhya khrīṣṭaṁ mṛtagaṇamadhyād āneṣyatīti vāk manasi tvayā na gaditavyā| ");
INSERT INTO sanias_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","tarhi kiṁ bravīti? tad vākyaṁ tava samīpastham arthāt tava vadane manasi cāste, tacca vākyam asmābhiḥ pracāryyamāṇaṁ viśvāsasya vākyameva| ");
INSERT INTO sanias_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","vastutaḥ prabhuṁ yīśuṁ yadi vadanena svīkaroṣi, tatheśvarastaṁ śmaśānād udasthāpayad iti yadyantaḥkaraṇena viśvasiṣi tarhi paritrāṇaṁ lapsyase| ");
INSERT INTO sanias_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","yasmāt puṇyaprāptyartham antaḥkaraṇena viśvasitavyaṁ paritrāṇārthañca vadanena svīkarttavyaṁ| ");
INSERT INTO sanias_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","śāstre yādṛśaṁ likhati viśvasiṣyati yastatra sa jano na trapiṣyate| ");
INSERT INTO sanias_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","ityatra yihūdini tadanyaloke ca kopi viśeṣo nāsti yasmād yaḥ sarvveṣām advitīyaḥ prabhuḥ sa nijayācakāna sarvvān prati vadānyo bhavati| ");
INSERT INTO sanias_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","yataḥ, yaḥ kaścit parameśasya nāmnā hi prārthayiṣyate| sa eva manujo nūnaṁ paritrāto bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","yaṁ ye janā na pratyāyan te tamuddiśya kathaṁ prārthayiṣyante? ye vā yasyākhyānaṁ kadāpi na śrutavantaste taṁ kathaṁ pratyeṣyanti? aparaṁ yadi pracārayitāro na tiṣṭhanti tadā kathaṁ te śroṣyanti? ");
INSERT INTO sanias_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","yadi vā preritā na bhavanti tadā kathaṁ pracārayiṣyanti? yādṛśaṁ likhitam āste, yathā, māṅgalikaṁ susaṁvādaṁ dadatyānīya ye narāḥ| pracārayanti śānteśca susaṁvādaṁ janāstu ye| teṣāṁ caraṇapadmāni kīdṛk śobhānvitāni hi| ");
INSERT INTO sanias_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","kintu te sarvve taṁ susaṁvādaṁ na gṛhītavantaḥ| yiśāyiyo yathā likhitavān| asmatpracārite vākye viśvāsamakaroddhi kaḥ| ");
INSERT INTO sanias_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","ataeva śravaṇād viśvāsa aiśvaravākyapracārāt śravaṇañca bhavati| ");
INSERT INTO sanias_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","tarhyahaṁ bravīmi taiḥ kiṁ nāśrāvi? avaśyam aśrāvi, yasmāt teṣāṁ śabdo mahīṁ vyāpnod vākyañca nikhilaṁ jagat| ");
INSERT INTO sanias_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","aparamapi vadāmi, isrāyelīyalokāḥ kim etāṁ kathāṁ na budhyante? prathamato mūsā idaṁ vākyaṁ provāca, ahamuttāpayiṣye tān agaṇyamānavairapi| klekṣyāmi jātim etāñca pronmattabhinnajātibhiḥ| ");
INSERT INTO sanias_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","aparañca yiśāyiyo'tiśayākṣobheṇa kathayāmāsa, yathā, adhi māṁ yaistu nāceṣṭi samprāptastai rjanairahaṁ| adhi māṁ yai rna sampṛṣṭaṁ vijñātastai rjanairahaṁ|| ");
INSERT INTO sanias_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","kintvisrāyelīyalokān adhi kathayāñcakāra, yairājñālaṅghibhi rlokai rviruddhaṁ vākyamucyate| tān pratyeva dinaṁ kṛtsnaṁ hastau vistārayāmyahaṁ|| ");
INSERT INTO sanias_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","īśvareṇa svīkīyalokā apasāritā ahaṁ kim īdṛśaṁ vākyaṁ bravīmi? tanna bhavatu yato'hamapi binyāmīnagotrīya ibrāhīmavaṁśīya isrāyelīyaloko'smi| ");
INSERT INTO sanias_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","īśvareṇa pūrvvaṁ ye pradṛṣṭāste svakīyalokā apasāritā iti nahi| aparam eliyopākhyāne śāstre yallikhitam āste tad yūyaṁ kiṁ na jānītha? ");
INSERT INTO sanias_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","he parameśvara lokāstvadīyāḥ sarvvā yajñavedīrabhañjan tathā tava bhaviṣyadvādinaḥ sarvvān aghnan kevala eko'ham avaśiṣṭa āse te mamāpi prāṇān nāśayituṁ ceṣṭanate, etāṁ kathām isrāyelīyalokānāṁ viruddham eliya īśvarāya nivedayāmāsa| ");
INSERT INTO sanias_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","tatastaṁ pratīśvarasyottaraṁ kiṁ jātaṁ? bālnāmno devasya sākṣāt yai rjānūni na pātitāni tādṛśāḥ sapta sahasrāṇi lokā avaśeṣitā mayā| ");
INSERT INTO sanias_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","tadvad etasmin varttamānakāle'pi anugraheṇābhirucitāsteṣām avaśiṣṭāḥ katipayā lokāḥ santi| ");
INSERT INTO sanias_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","ataeva tad yadyanugraheṇa bhavati tarhi kriyayā na bhavati no ced anugraho'nanugraha eva, yadi vā kriyayā bhavati tarhyanugraheṇa na bhavati no cet kriyā kriyaiva na bhavati| ");
INSERT INTO sanias_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","tarhi kiṁ? isrāyelīyalokā yad amṛgayanta tanna prāpuḥ| kintvabhirucitalokāstat prāpustadanye sarvva andhībhūtāḥ| ");
INSERT INTO sanias_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","yathā likhitam āste, ghoranidrālutābhāvaṁ dṛṣṭihīne ca locane| karṇau śrutivihīnau ca pradadau tebhya īśvaraḥ|| ");
INSERT INTO sanias_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","etesmin dāyūdapi likhitavān yathā, ato bhuktyāsanaṁ teṣām unmāthavad bhaviṣyati| vā vaṁśayantravad bādhā daṇḍavad vā bhaviṣyati|| ");
INSERT INTO sanias_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","bhaviṣyanti tathāndhāste netraiḥ paśyanti no yathā| vepathuḥ kaṭideśasya teṣāṁ nityaṁ bhaviṣyati|| ");
INSERT INTO sanias_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","patanārthaṁ te skhalitavanta iti vācaṁ kimahaṁ vadāmi? tanna bhavatu kintu tān udyoginaḥ karttuṁ teṣāṁ patanād itaradeśīyalokaiḥ paritrāṇaṁ prāptaṁ| ");
INSERT INTO sanias_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","teṣāṁ patanaṁ yadi jagato lokānāṁ lābhajanakam abhavat teṣāṁ hrāso'pi yadi bhinnadeśināṁ lābhajanako'bhavat tarhi teṣāṁ vṛddhiḥ kati lābhajanikā bhaviṣyati? ");
INSERT INTO sanias_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","ato he anyadeśino yuṣmān sambodhya kathayāmi nijānāṁ jñātibandhūnāṁ manaḥsūdyogaṁ janayan teṣāṁ madhye kiyatāṁ lokānāṁ yathā paritrāṇaṁ sādhayāmi ");
INSERT INTO sanias_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","tannimittam anyadeśināṁ nikaṭe preritaḥ san ahaṁ svapadasya mahimānaṁ prakāśayāmi| ");
INSERT INTO sanias_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","teṣāṁ nigraheṇa yadīśvareṇa saha jagato janānāṁ melanaṁ jātaṁ tarhi teṣām anugṛhītatvaṁ mṛtadehe yathā jīvanalābhastadvat kiṁ na bhaviṣyati? ");
INSERT INTO sanias_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","aparaṁ prathamajātaṁ phalaṁ yadi pavitraṁ bhavati tarhi sarvvameva phalaṁ pavitraṁ bhaviṣyati; tathā mūlaṁ yadi pavitraṁ bhavati tarhi śākhā api tathaiva bhaviṣyanti| ");
INSERT INTO sanias_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","kiyatīnāṁ śākhānāṁ chedane kṛte tvaṁ vanyajitavṛkṣasya śākhā bhūtvā yadi tacchākhānāṁ sthāne ropitā sati jitavṛkṣīyamūlasya rasaṁ bhuṁkṣe, ");
INSERT INTO sanias_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","tarhi tāsāṁ bhinnaśākhānāṁ viruddhaṁ māṁ garvvīḥ; yadi garvvasi tarhi tvaṁ mūlaṁ yanna dhārayasi kintu mūlaṁ tvāṁ dhārayatīti saṁsmara| ");
INSERT INTO sanias_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","aparañca yadi vadasi māṁ ropayituṁ tāḥ śākhā vibhannā abhavan; ");
INSERT INTO sanias_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","bhadram, apratyayakāraṇāt te vibhinnā jātāstathā viśvāsakāraṇāt tvaṁ ropito jātastasmād ahaṅkāram akṛtvā sasādhvaso bhava| ");
INSERT INTO sanias_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","yata īśvaro yadi svābhāvikīḥ śākhā na rakṣati tarhi sāvadhāno bhava cet tvāmapi na sthāpayati| ");
INSERT INTO sanias_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","ityatreśvarasya yādṛśī kṛpā tādṛśaṁ bhayānakatvamapi tvayā dṛśyatāṁ; ye patitāstān prati tasya bhayānakatvaṁ dṛśyatāṁ, tvañca yadi tatkṛpāśritastiṣṭhasi tarhi tvāṁ prati kṛpā drakṣyate; no cet tvamapi tadvat chinno bhaviṣyasi| ");
INSERT INTO sanias_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","aparañca te yadyapratyaye na tiṣṭhanti tarhi punarapi ropayiṣyante yasmāt tān punarapi ropayitum iśvarasya śaktirāste| ");
INSERT INTO sanias_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","vanyajitavṛkṣasya śākhā san tvaṁ yadi tataśchinno rītivyatyayenottamajitavṛkṣe roेेpito'bhavastarhi tasya vṛkṣasya svīyā yāḥ śākhāstāḥ kiṁ punaḥ svavṛkṣe saṁlagituṁ na śaknuvanti? ");
INSERT INTO sanias_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","he bhrātaro yuṣmākam ātmābhimāno yanna jāyate tadarthaṁ mamedṛśī vāñchā bhavati yūyaṁ etannigūḍhatattvam ajānanto yanna tiṣṭhatha; vastuto yāvatkālaṁ sampūrṇarūpeṇa bhinnadeśināṁ saṁgraho na bhaviṣyati tāvatkālam aṁśatvena isrāyelīyalokānām andhatā sthāsyati; ");
INSERT INTO sanias_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","paścāt te sarvve paritrāsyante; etādṛśaṁ likhitamapyāste, āgamiṣyati sīyonād eko yastrāṇadāyakaḥ| adharmmaṁ yākubo vaṁśāt sa tu dūrīkariṣyati| ");
INSERT INTO sanias_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","tathā dūrīkariṣyāmi teṣāṁ pāpānyahaṁ yadā| tadā taireva sārddhaṁ me niyamo'yaṁ bhaviṣyati| ");
INSERT INTO sanias_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","susaṁvādāt te yuṣmākaṁ vipakṣā abhavan kintvabhirucitatvāt te pitṛlokānāṁ kṛte priyapātrāṇi bhavanti| ");
INSERT INTO sanias_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","yata īśvarasya dānād āhvānāñca paścāttāpo na bhavati| ");
INSERT INTO sanias_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","ataeva pūrvvam īśvare'viśvāsinaḥ santo'pi yūyaṁ yadvat samprati teṣām aviśvāsakāraṇād īśvarasya kṛpāpātrāṇi jātāstadvad ");
INSERT INTO sanias_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","idānīṁ te'viśvāsinaḥ santi kintu yuṣmābhi rlabdhakṛpākāraṇāt tairapi kṛpā lapsyate| ");
INSERT INTO sanias_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","īśvaraḥ sarvvān prati kṛpāṁ prakāśayituṁ sarvvān aviśvāsitvena gaṇayati| ");
INSERT INTO sanias_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","aho īśvarasya jñānabuddhirūpayo rdhanayoḥ kīdṛk prācuryyaṁ| tasya rājaśāsanasya tattvaṁ kīdṛg aprāpyaṁ| tasya mārgāśca kīdṛg anupalakṣyāḥ| ");
INSERT INTO sanias_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","parameśvarasya saṅkalpaṁ ko jñātavān? tasya mantrī vā ko'bhavat? ");
INSERT INTO sanias_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","ko vā tasyopakārī bhṛtvā tatkṛte tena pratyupakarttavyaḥ? ");
INSERT INTO sanias_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","yato vastumātrameva tasmāt tena tasmai cābhavat tadīyo mahimā sarvvadā prakāśito bhavatu| iti| ");
INSERT INTO sanias_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","he bhrātara īśvarasya kṛpayāhaṁ yuṣmān vinaye yūyaṁ svaṁ svaṁ śarīraṁ sajīvaṁ pavitraṁ grāhyaṁ balim īśvaramuddiśya samutsṛjata, eṣā sevā yuṣmākaṁ yogyā| ");
INSERT INTO sanias_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","aparaṁ yūyaṁ sāṁsārikā iva mācarata, kintu svaṁ svaṁ svabhāvaṁ parāvartya nūtanācāriṇo bhavata, tata īśvarasya nideśaḥ kīdṛg uttamo grahaṇīyaḥ sampūrṇaśceti yuṣmābhiranubhāviṣyate| ");
INSERT INTO sanias_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","kaścidapi jano yogyatvādadhikaṁ svaṁ na manyatāṁ kintu īśvaro yasmai pratyayasya yatparimāṇam adadāt sa tadanusārato yogyarūpaṁ svaṁ manutām, īśvarād anugrahaṁ prāptaḥ san yuṣmākam ekaikaṁ janam ityājñāpayāmi| ");
INSERT INTO sanias_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","yato yadvadasmākam ekasmin śarīre bahūnyaṅgāni santi kintu sarvveṣāmaṅgānāṁ kāryyaṁ samānaṁ nahi; ");
INSERT INTO sanias_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","tadvadasmākaṁ bahutve'pi sarvve vayaṁ khrīṣṭe ekaśarīrāḥ parasparam aṅgapratyaṅgatvena bhavāmaḥ| ");
INSERT INTO sanias_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","asmād īśvarānugraheṇa viśeṣaṁ viśeṣaṁ dānam asmāsu prāpteṣu satsu kopi yadi bhaviṣyadvākyaṁ vadati tarhi pratyayasya parimāṇānusārataḥ sa tad vadatu; ");
INSERT INTO sanias_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","yadvā yadi kaścit sevanakārī bhavati tarhi sa tatsevanaṁ karotu; athavā yadi kaścid adhyāpayitā bhavati tarhi so'dhyāpayatu; ");
INSERT INTO sanias_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","tathā ya upadeṣṭā bhavati sa upadiśatu yaśca dātā sa saralatayā dadātu yastvadhipatiḥ sa yatnenādhipatitvaṁ karotu yaśca dayāluḥ sa hṛṣṭamanasā dayatām| ");
INSERT INTO sanias_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","aparañca yuṣmākaṁ prema kāpaṭyavarjitaṁ bhavatu yad abhadraṁ tad ṛtīyadhvaṁ yacca bhadraṁ tasmin anurajyadhvam| ");
INSERT INTO sanias_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","aparaṁ bhrātṛtvapremnā parasparaṁ prīyadhvaṁ samādarād eko'parajanaṁ śreṣṭhaṁ jānīdhvam| ");
INSERT INTO sanias_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","tathā kāryye nirālasyā manasi ca sodyogāḥ santaḥ prabhuṁ sevadhvam| ");
INSERT INTO sanias_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","aparaṁ pratyāśāyām ānanditā duḥkhasamaye ca dhairyyayuktā bhavata; prārthanāyāṁ satataṁ pravarttadhvaṁ| ");
INSERT INTO sanias_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","pavitrāṇāṁ dīnatāṁ dūrīkurudhvam atithisevāyām anurajyadhvam| ");
INSERT INTO sanias_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","ye janā yuṣmān tāḍayanti tān āśiṣaṁ vadata śāpam adattvā daddhvamāśiṣam| ");
INSERT INTO sanias_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","ye janā ānandanti taiḥ sārddham ānandata ye ca rudanti taiḥ saha rudita| ");
INSERT INTO sanias_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","aparañca yuṣmākaṁ manasāṁ parasparam ekobhāvo bhavatu; aparam uccapadam anākāṅkṣya nīcalokaiḥ sahāpi mārdavam ācarata; svān jñānino na manyadhvaṁ| ");
INSERT INTO sanias_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","parasmād apakāraṁ prāpyāpi paraṁ nāpakuruta| sarvveṣāṁ dṛṣṭito yat karmmottamaṁ tadeva kuruta| ");
INSERT INTO sanias_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","yadi bhavituṁ śakyate tarhi yathāśakti sarvvalokaiḥ saha nirvvirodhena kālaṁ yāpayata| ");
INSERT INTO sanias_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","he priyabandhavaḥ, kasmaicid apakārasya samucitaṁ daṇḍaṁ svayaṁ na daddhvaṁ, kintvīśvarīyakrodhāya sthānaṁ datta yato likhitamāste parameśvaraḥ kathayati, dānaṁ phalasya matkarmma sūcitaṁ pradadāmyahaṁ| ");
INSERT INTO sanias_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","itikāraṇād ripu ryadi kṣudhārttaste tarhi taṁ tvaṁ prabhojaya| tathā yadi tṛṣārttaḥ syāt tarhi taṁ paripāyaya| tena tvaṁ mastake tasya jvaladagniṁ nidhāsyasi| ");
INSERT INTO sanias_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","kukriyayā parājitā na santa uttamakriyayā kukriyāṁ parājayata| ");
INSERT INTO sanias_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","yuṣmākam ekaikajanaḥ śāsanapadasya nighno bhavatu yato yāni śāsanapadāni santi tāni sarvvāṇīśvareṇa sthāpitāni; īśvaraṁ vinā padasthāpanaṁ na bhavati| ");
INSERT INTO sanias_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","iti hetoḥ śāsanapadasya yat prātikūlyaṁ tad īśvarīyanirūpaṇasya prātikūlyameva; aparaṁ ye prātikūlyam ācaranti te sveṣāṁ samucitaṁ daṇḍaṁ svayameva ghaṭayante| ");
INSERT INTO sanias_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","śāstā sadācāriṇāṁ bhayaprado nahi durācāriṇāmeva bhayaprado bhavati; tvaṁ kiṁ tasmān nirbhayo bhavitum icchasi? tarhi satkarmmācara, tasmād yaśo lapsyase, ");
INSERT INTO sanias_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","yatastava sadācaraṇāya sa īśvarasya bhṛtyo'sti| kintu yadi kukarmmācarasi tarhi tvaṁ śaṅkasva yataḥ sa nirarthakaṁ khaṅgaṁ na dhārayati; kukarmmācāriṇaṁ samucitaṁ daṇḍayitum sa īśvarasya daṇḍadabhṛtya eva| ");
INSERT INTO sanias_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","ataeva kevaladaṇḍabhayānnahi kintu sadasadbodhādapi tasya vaśyena bhavitavyaṁ| ");
INSERT INTO sanias_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","etasmād yuṣmākaṁ rājakaradānamapyucitaṁ yasmād ye karaṁ gṛhlanti ta īśvarasya kiṅkarā bhūtvā satatam etasmin karmmaṇi niviṣṭāstiṣṭhanti| ");
INSERT INTO sanias_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","asmāt karagrāhiṇe karaṁ datta, tathā śulkagrāhiṇe śulkaṁ datta, aparaṁ yasmād bhetavyaṁ tasmād bibhīta, yaśca samādaraṇīyastaṁ samādriyadhvam; itthaṁ yasya yat prāpyaṁ tat tasmai datta| ");
INSERT INTO sanias_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","yuṣmākaṁ parasparaṁ prema vinā 'nyat kimapi deyam ṛṇaṁ na bhavatu, yato yaḥ parasmin prema karoti tena vyavasthā sidhyati| ");
INSERT INTO sanias_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","vastutaḥ paradārān mā gaccha, narahatyāṁ mā kārṣīḥ, cairyyaṁ mā kārṣīḥ, mithyāsākṣyaṁ mā dehi, lobhaṁ mā kārṣīḥ, etāḥ sarvvā ājñā etābhyo bhinnā yā kācid ājñāsti sāpi svasamīpavāsini svavat prema kurvvityanena vacanena veditā| ");
INSERT INTO sanias_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","yataḥ prema samīpavāsino'śubhaṁ na janayati tasmāt premnā sarvvā vyavasthā pālyate| ");
INSERT INTO sanias_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","pratyayībhavanakāle'smākaṁ paritrāṇasya sāmīpyād idānīṁ tasya sāmīpyam avyavahitaṁ; ataḥ samayaṁ vivicyāsmābhiḥ sāmpratam avaśyameva nidrāto jāgarttavyaṁ| ");
INSERT INTO sanias_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","bahutarā yāminī gatā prabhātaṁ sannidhiṁ prāptaṁ tasmāt tāmasīyāḥ kriyāḥ parityajyāsmābhi rvāsarīyā sajjā paridhātavyā| ");
INSERT INTO sanias_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","ato heto rvayaṁ divā vihitaṁ sadācaraṇam ācariṣyāmaḥ| raṅgaraso mattatvaṁ lampaṭatvaṁ kāmukatvaṁ vivāda īrṣyā caitāni parityakṣyāmaḥ| ");
INSERT INTO sanias_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","yūyaṁ prabhuyīśukhrīṣṭarūpaṁ paricchadaṁ paridhaddhvaṁ sukhābhilāṣapūraṇāya śārīrikācaraṇaṁ mācarata| ");
INSERT INTO sanias_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","yo jano'dṛḍhaviśvāsastaṁ yuṣmākaṁ saṅginaṁ kuruta kintu sandehavicārārthaṁ nahi| ");
INSERT INTO sanias_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","yato niṣiddhaṁ kimapi khādyadravyaṁ nāsti, kasyacijjanasya pratyaya etādṛśo vidyate kintvadṛḍhaviśvāsaḥ kaścidaparo janaḥ kevalaṁ śākaṁ bhuṅktaṁ| ");
INSERT INTO sanias_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","tarhi yo janaḥ sādhāraṇaṁ dravyaṁ bhuṅkte sa viśeṣadravyabhoktāraṁ nāvajānīyāt tathā viśeṣadravyabhoktāpi sādhāraṇadravyabhoktāraṁ doṣiṇaṁ na kuryyāt, yasmād īśvarastam agṛhlāt| ");
INSERT INTO sanias_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","he paradāsasya dūṣayitastvaṁ kaḥ? nijaprabhoḥ samīpe tena padasthena padacyutena vā bhavitavyaṁ sa ca padastha eva bhaviṣyati yata īśvarastaṁ padasthaṁ karttuṁ śaknoti| ");
INSERT INTO sanias_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","aparañca kaścijjano dinād dinaṁ viśeṣaṁ manyate kaścittuु sarvvāṇi dināni samānāni manyate, ekaiko janaḥ svīyamanasi vivicya niścinotu| ");
INSERT INTO sanias_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","yo janaḥ kiñcana dinaṁ viśeṣaṁ manyate sa prabhubhaktyā tan manyate, yaśca janaḥ kimapi dinaṁ viśeṣaṁ na manyate so'pi prabhubhaktyā tanna manyate; aparañca yaḥ sarvvāṇi bhakṣyadravyāṇi bhuṅkte sa prabhubhaktayā tāni bhuṅkte yataḥ sa īśvaraṁ dhanyaṁ vakti, yaśca na bhuṅkte so'pi prabhubhaktyaiva na bhuñjāna īśvaraṁ dhanyaṁ brūte| ");
INSERT INTO sanias_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","aparam asmākaṁ kaścit nijanimittaṁ prāṇān dhārayati nijanimittaṁ mriyate vā tanna; ");
INSERT INTO sanias_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","kintu yadi vayaṁ prāṇān dhārayāmastarhi prabhunimittaṁ dhārayāmaḥ, yadi ca prāṇān tyajāmastarhyapi prabhunimittaṁ tyajāmaḥ, ataeva jīvane maraṇe vā vayaṁ prabhorevāsmahe| ");
INSERT INTO sanias_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","yato jīvanto mṛtāścetyubhayeṣāṁ lokānāṁ prabhutvaprāptyarthaṁ khrīṣṭo mṛta utthitaḥ punarjīvitaśca| ");
INSERT INTO sanias_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","kintu tvaṁ nijaṁ bhrātaraṁ kuto dūṣayasi? tathā tvaṁ nijaṁ bhrātaraṁ kutastucchaṁ jānāsi? khrīṣṭasya vicārasiṁhāsanasya sammukhe sarvvairasmābhirupasthātavyaṁ; ");
INSERT INTO sanias_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","yādṛśaṁ likhitam āste, pareśaḥ śapathaṁ kurvvan vākyametat purāvadat| sarvvo janaḥ samīpe me jānupātaṁ kariṣyati| jihvaikaikā tatheśasya nighnatvaṁ svīkariṣyati| ");
INSERT INTO sanias_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","ataeva īśvarasamīpe'smākam ekaikajanena nijā kathā kathayitavyā| ");
INSERT INTO sanias_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","itthaṁ sati vayam adyārabhya parasparaṁ na dūṣayantaḥ svabhrātu rvighno vyāghāto vā yanna jāyeta tādṛśīmīhāṁ kurmmahe| ");
INSERT INTO sanias_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","kimapi vastu svabhāvato nāśuci bhavatītyahaṁ jāne tathā prabhunā yīśukhrīṣṭenāpi niścitaṁ jāne, kintu yo jano yad dravyam apavitraṁ jānīte tasya kṛte tad apavitram āste| ");
INSERT INTO sanias_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","ataeva tava bhakṣyadravyeṇa tava bhrātā śokānvito bhavati tarhi tvaṁ bhrātaraṁ prati premnā nācarasi| khrīṣṭo yasya kṛte svaprāṇān vyayitavān tvaṁ nijena bhakṣyadravyeṇa taṁ na nāśaya| ");
INSERT INTO sanias_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","aparaṁ yuṣmākam uttamaṁ karmma ninditaṁ na bhavatu| ");
INSERT INTO sanias_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","bhakṣyaṁ peyañceśvararājyasya sāro nahi, kintu puṇyaṁ śāntiśca pavitreṇātmanā jāta ānandaśca| ");
INSERT INTO sanias_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","etai ryo janaḥ khrīṣṭaṁ sevate, sa eveśvarasya tuṣṭikaro manuṣyaiśca sukhyātaḥ| ");
INSERT INTO sanias_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","ataeva yenāsmākaṁ sarvveṣāṁ parasparam aikyaṁ niṣṭhā ca jāyate tadevāsmābhi ryatitavyaṁ| ");
INSERT INTO sanias_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","bhakṣyārtham īśvarasya karmmaṇo hāniṁ mā janayata; sarvvaṁ vastu pavitramiti satyaṁ tathāpi yo jano yad bhuktvā vighnaṁ labhate tadarthaṁ tad bhadraṁ nahi| ");
INSERT INTO sanias_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","tava māṁsabhakṣaṇasurāpānādibhiḥ kriyābhi ryadi tava bhrātuḥ pādaskhalanaṁ vighno vā cāñcalyaṁ vā jāyate tarhi tadbhojanapānayostyāgo bhadraḥ| ");
INSERT INTO sanias_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","yadi tava pratyayastiṣṭhati tarhīśvarasya gocare svāntare taṁ gopaya; yo janaḥ svamatena svaṁ doṣiṇaṁ na karoti sa eva dhanyaḥ| ");
INSERT INTO sanias_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","kintu yaḥ kaścit saṁśayya bhuṅkte'rthāt na pratītya bhuṅkte, sa evāvaśyaṁ daṇḍārho bhaviṣyati, yato yat pratyayajaṁ nahi tadeva pāpamayaṁ bhavati| ");
INSERT INTO sanias_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","balavadbhirasmābhi rdurbbalānāṁ daurbbalyaṁ soḍhavyaṁ na ca sveṣām iṣṭācāra ācaritavyaḥ| ");
INSERT INTO sanias_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","asmākam ekaiko janaḥ svasamīpavāsino hitārthaṁ niṣṭhārthañca tasyaiveṣṭācāram ācaratu| ");
INSERT INTO sanias_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","yataḥ khrīṣṭo'pi nijeṣṭācāraṁ nācaritavān, yathā likhitam āste, tvannindakagaṇasyaiva nindābhi rnindito'smyahaṁ| ");
INSERT INTO sanias_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","aparañca vayaṁ yat sahiṣṇutāsāntvanayo rjanakena śāstreṇa pratyāśāṁ labhemahi tannimittaṁ pūrvvakāle likhitāni sarvvavacanānyasmākam upadeśārthameva lilikhire| ");
INSERT INTO sanias_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","sahiṣṇutāsāntvanayorākaro ya īśvaraḥ sa evaṁ karotu yat prabhu ryīśukhrīṣṭa iva yuṣmākam ekajano'nyajanena sārddhaṁ manasa aikyam ācaret; ");
INSERT INTO sanias_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","yūyañca sarvva ekacittā bhūtvā mukhaikenevāsmatprabhuyīśukhrīṣṭasya piturīśvarasya guṇān kīrttayeta| ");
INSERT INTO sanias_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","aparam īśvarasya mahimnaḥ prakāśārthaṁ khrīṣṭo yathā yuṣmān pratyagṛhlāt tathā yuṣmākamapyeko jano'nyajanaṁ pratigṛhlātu| ");
INSERT INTO sanias_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","yathā likhitam āste, ato'haṁ sammukhe tiṣṭhan bhinnadeśanivāsināṁ| stuvaṁstvāṁ parigāsyāmi tava nāmni pareśvara|| ");
INSERT INTO sanias_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","tasya dayālutvācca bhinnajātīyā yad īśvarasya guṇān kīrttayeyustadarthaṁ yīśuḥ khrīṣṭastvakchedaniyamasya nighno'bhavad ityahaṁ vadāmi| yathā likhitam āste, ato'haṁ sammukhe tiṣṭhan bhinnadeśanivāsināṁ| stuvaṁstvāṁ parigāsyāmi tava nāmni pareśvara|| ");
INSERT INTO sanias_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","aparamapi likhitam āste, he anyajātayo yūyaṁ samaṁ nandata tajjanaiḥ| ");
INSERT INTO sanias_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","punaśca likhitam āste, he sarvvadeśino yūyaṁ dhanyaṁ brūta pareśvaraṁ| he tadīyanarā yūyaṁ kurudhvaṁ tatpraśaṁsanaṁ|| ");
INSERT INTO sanias_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","apara yīśāyiyo'pi lilekha, yīśayasya tu yat mūlaṁ tat prakāśiṣyate tadā| sarvvajātīyanṛṇāñca śāsakaḥ samudeṣyati| tatrānyadeśilokaiśca pratyāśā prakariṣyate|| ");
INSERT INTO sanias_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","ataeva yūyaṁ pavitrasyātmanaḥ prabhāvād yat sampūrṇāṁ pratyāśāṁ lapsyadhve tadarthaṁ tatpratyāśājanaka īśvaraḥ pratyayena yuṣmān śāntyānandābhyāṁ sampūrṇān karotu| ");
INSERT INTO sanias_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","he bhrātaro yūyaṁ sadbhāvayuktāḥ sarvvaprakāreṇa jñānena ca sampūrṇāḥ parasparopadeśe ca tatparā ityahaṁ niścitaṁ jānāmi, ");
INSERT INTO sanias_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","tathāpyahaṁ yat pragalbhataro bhavan yuṣmān prabodhayāmi tasyaikaṁ kāraṇamidaṁ| ");
INSERT INTO sanias_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","bhinnajātīyāḥ pavitreṇātmanā pāvitanaivedyarūpā bhūtvā yad grāhyā bhaveyustannimittamaham īśvarasya susaṁvādaṁ pracārayituṁ bhinnajātīyānāṁ madhye yīśukhrīṣṭasya sevakatvaṁ dānaṁ īśvarāt labdhavānasmi| ");
INSERT INTO sanias_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","īśvaraṁ prati yīśukhrīṣṭena mama ślāghākaraṇasya kāraṇam āste| ");
INSERT INTO sanias_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","bhinnadeśina ājñāgrāhiṇaḥ karttuṁ khrīṣṭo vākyena kriyayā ca, āścaryyalakṣaṇaiścitrakriyābhiḥ pavitrasyātmanaḥ prabhāvena ca yāni karmmāṇi mayā sādhitavān, ");
INSERT INTO sanias_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","kevalaṁ tānyeva vinānyasya kasyacit karmmaṇo varṇanāṁ karttuṁ pragalbho na bhavāmi| tasmāt ā yirūśālama illūrikaṁ yāvat sarvvatra khrīṣṭasya susaṁvādaṁ prācārayaṁ| ");
INSERT INTO sanias_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","anyena nicitāyāṁ bhittāvahaṁ yanna nicinomi tannimittaṁ yatra yatra sthāne khrīṣṭasya nāma kadāpi kenāpi na jñāpitaṁ tatra tatra susaṁvādaṁ pracārayitum ahaṁ yate| ");
INSERT INTO sanias_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","yādṛśaṁ likhitam āste, yai rvārttā tasya na prāptā darśanaṁ taistu lapsyate| yaiśca naiva śrutaṁ kiñcit boddhuṁ śakṣyanti te janāḥ|| ");
INSERT INTO sanias_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","tasmād yuṣmatsamīpagamanād ahaṁ muhurmuhu rnivārito'bhavaṁ| ");
INSERT INTO sanias_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","kintvidānīm atra pradeśeṣu mayā na gataṁ sthānaṁ kimapi nāvaśiṣyate yuṣmatsamīpaṁ gantuṁ bahuvatsarānārabhya māmakīnākāṅkṣā ca vidyata iti hetoḥ ");
INSERT INTO sanias_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","spāniyādeśagamanakāle'haṁ yuṣmanmadhyena gacchan yuṣmān ālokiṣye, tataḥ paraṁ yuṣmatsambhāṣaṇena tṛptiṁ parilabhya taddeśagamanārthaṁ yuṣmābhi rvisarjayiṣye, īdṛśī madīyā pratyāśā vidyate| ");
INSERT INTO sanias_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","kintu sāmprataṁ pavitralokānāṁ sevanāya yirūśālamnagaraṁ vrajāmi| ");
INSERT INTO sanias_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","yato yirūśālamasthapavitralokānāṁ madhye ye daridrā arthaviśrāṇanena tānupakarttuṁ mākidaniyādeśīyā ākhāyādeśīyāśca lokā aicchan| ");
INSERT INTO sanias_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","eṣā teṣāṁ sadicchā yataste teṣām ṛṇinaḥ santi yato heto rbhinnajātīyā yeṣāṁ paramārthasyāṁśino jātā aihikaviṣaye teṣāmupakārastaiḥ karttavyaḥ| ");
INSERT INTO sanias_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","ato mayā tat karmma sādhayitvā tasmin phale tebhyaḥ samarpite yuṣmanmadhyena spāniyādeśo gamiṣyate| ");
INSERT INTO sanias_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","yuṣmatsamīpe mamāgamanasamaye khrīṣṭasya susaṁvādasya pūrṇavareṇa sambalitaḥ san aham āgamiṣyāmi iti mayā jñāyate| ");
INSERT INTO sanias_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","he bhrātṛgaṇa prabho ryīśukhrīṣṭasya nāmnā pavitrasyātmānaḥ premnā ca vinaye'haṁ ");
INSERT INTO sanias_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","yihūdādeśasthānām aviśvāsilokānāṁ karebhyo yadahaṁ rakṣāṁ labheya madīyaitena sevanakarmmaṇā ca yad yirūśālamasthāḥ pavitralokāstuṣyeyuḥ, ");
INSERT INTO sanias_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","tadarthaṁ yūyaṁ matkṛta īśvarāya prārthayamāṇā yatadhvaṁ tenāham īśvarecchayā sānandaṁ yuṣmatsamīpaṁ gatvā yuṣmābhiḥ sahitaḥ prāṇān āpyāyituṁ pārayiṣyāmi| ");
INSERT INTO sanias_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","śāntidāyaka īśvaro yuṣmākaṁ sarvveṣāṁ saṅgī bhūyāt| iti| ");
INSERT INTO sanias_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","kiṁkrīyānagarīyadharmmasamājasya paricārikā yā phaibīnāmikāsmākaṁ dharmmabhaginī tasyāḥ kṛte'haṁ yuṣmān nivedayāmi, ");
INSERT INTO sanias_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","yūyaṁ tāṁ prabhumāśritāṁ vijñāya tasyā ātithyaṁ pavitralokārhaṁ kurudhvaṁ, yuṣmattastasyā ya upakāro bhavituṁ śaknoti taṁ kurudhvaṁ, yasmāt tayā bahūnāṁ mama copakāraḥ kṛtaḥ| ");
INSERT INTO sanias_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","aparañca khrīṣṭasya yīśoḥ karmmaṇi mama sahakāriṇau mama prāṇarakṣārthañca svaprāṇān paṇīkṛtavantau yau priṣkillākkilau tau mama namaskāraṁ jñāpayadhvaṁ| ");
INSERT INTO sanias_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","tābhyām upakārāptiḥ kevalaṁ mayā svīkarttavyeti nahi bhinnadeśīyaiḥ sarvvadharmmasamājairapi| ");
INSERT INTO sanias_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","aparañca tayo rgṛhe sthitān dharmmasamājalokān mama namaskāraṁ jñāpayadhvaṁ| tadvat āśiyādeśe khrīṣṭasya pakṣe prathamajātaphalasvarūpo ya ipenitanāmā mama priyabandhustamapi mama namaskāraṁ jñāpayadhvaṁ| ");
INSERT INTO sanias_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","aparaṁ bahuśrameṇāsmān asevata yā mariyam tāmapi namaskāraṁ jñāpayadhvaṁ| ");
INSERT INTO sanias_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","aparañca preriteṣu khyātakīrttī madagre khrīṣṭāśritau mama svajātīyau sahabandinau ca yāvāndranīkayūniyau tau mama namaskāraṁ jñāpayadhvaṁ| ");
INSERT INTO sanias_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","tathā prabhau matpriyatamam āmpliyamapi mama namaskāraṁ jñāpayadhvaṁ| ");
INSERT INTO sanias_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","aparaṁ khrīṣṭasevāyāṁ mama sahakāriṇam ūrbbāṇaṁ mama priyatamaṁ stākhuñca mama namaskāraṁ jñāpayadhvaṁ| ");
INSERT INTO sanias_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","aparaṁ khrīṣṭena parīkṣitam āpilliṁ mama namaskāraṁ vadata, āriṣṭabūlasya parijanāṁśca mama namaskāraṁ jñāpayadhvaṁ| ");
INSERT INTO sanias_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","aparaṁ mama jñātiṁ herodiyonaṁ mama namaskāraṁ vadata, tathā nārkisasya parivārāṇāṁ madhye ye prabhumāśritāstān mama namaskāraṁ vadata| ");
INSERT INTO sanias_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","aparaṁ prabhoḥ sevāyāṁ pariśramakāriṇyau truphenātruphoṣe mama namaskāraṁ vadata, tathā prabhoḥ sevāyām atyantaṁ pariśramakāriṇī yā priyā parṣistāṁ namaskāraṁ jñāpayadhvaṁ| ");
INSERT INTO sanias_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","aparaṁ prabhorabhirucitaṁ rūphaṁ mama dharmmamātā yā tasya mātā tāmapi namaskāraṁ vadata| ");
INSERT INTO sanias_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","aparam asuṁkṛtaṁ phligonaṁ harmmaṁ pātrabaṁ harmmim eteṣāṁ saṅgibhrātṛgaṇañca namaskāraṁ jñāpayadhvaṁ| ");
INSERT INTO sanias_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","aparaṁ philalago yūliyā nīriyastasya bhaginyalumpā caitān etaiḥ sārddhaṁ yāvantaḥ pavitralokā āsate tānapi namaskāraṁ jñāpayadhvaṁ| ");
INSERT INTO sanias_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","yūyaṁ parasparaṁ pavitracumbanena namaskurudhvaṁ| khrīṣṭasya dharmmasamājagaṇo yuṣmān namaskurute| ");
INSERT INTO sanias_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","he bhrātaro yuṣmān vinaye'haṁ yuṣmābhi ryā śikṣā labdhā tām atikramya ye vicchedān vighnāṁśca kurvvanti tān niścinuta teṣāṁ saṅgaṁ varjayata ca| ");
INSERT INTO sanias_vpl VALUES ("RM16_18","075_16_18",