﻿USE sofia;
DROP TABLE IF EXISTS sofia.sanhk_vpl;
CREATE TABLE sanhk_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sanhk_vpl WRITE;
INSERT INTO sanhk_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ibrAhImaH santAno dAyUd tasya santAno yIzukhrISTastasya pUrvvapuruSavaMzazreNI| ");
INSERT INTO sanhk_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ibrAhImaH putra ishAk tasya putro yAkUb tasya putro yihUdAstasya bhrAtarazca| ");
INSERT INTO sanhk_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","tasmAd yihUdAtastAmaro garbhe perasserahau jajJAte, tasya perasaH putro hiSroN tasya putro 'rAm| ");
INSERT INTO sanhk_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","tasya putro 'mmInAdab tasya putro nahazon tasya putraH salmon| ");
INSERT INTO sanhk_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","tasmAd rAhabo garbhe boyam jajJe, tasmAd rUto garbhe obed jajJe, tasya putro yizayaH| ");
INSERT INTO sanhk_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","tasya putro dAyUd rAjaH tasmAd mRtoriyasya jAyAyAM sulemAn jajJe| ");
INSERT INTO sanhk_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","tasya putro rihabiyAm, tasya putro'biyaH, tasya putra AsA:| ");
INSERT INTO sanhk_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","tasya suto yihozAphaT tasya suto yihorAma tasya suta uSiyaH| ");
INSERT INTO sanhk_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","tasya suto yotham tasya suta Aham tasya suto hiSkiyaH| ");
INSERT INTO sanhk_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","tasya suto minaziH, tasya suta Amon tasya suto yoziyaH| ");
INSERT INTO sanhk_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","bAbilnagare pravasanAt pUrvvaM sa yoziyo yikhaniyaM tasya bhrAtRMzca janayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","tato bAbili pravasanakAle yikhaniyaH zaltIyelaM janayAmAsa, tasya sutaH sirubbAvil| ");
INSERT INTO sanhk_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","tasya suto 'bohud tasya suta ilIyAkIm tasya suto'sor| ");
INSERT INTO sanhk_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","asoraH sutaH sAdok tasya suta AkhIm tasya suta ilIhUd| ");
INSERT INTO sanhk_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","tasya suta iliyAsar tasya suto mattan| ");
INSERT INTO sanhk_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","tasya suto yAkUb tasya suto yUSaph tasya jAyA mariyam; tasya garbhe yIzurajani, tameva khrISTam (arthAd abhiSiktaM) vadanti| ");
INSERT INTO sanhk_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ittham ibrAhImo dAyUdaM yAvat sAkalyena caturdazapuruSAH; A dAyUdaH kAlAd bAbili pravasanakAlaM yAvat caturdazapuruSA bhavanti| bAbili pravAsanakAlAt khrISTasya kAlaM yAvat caturdazapuruSA bhavanti| ");
INSERT INTO sanhk_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","yIzukhrISTasya janma kaththate| mariyam nAmikA kanyA yUSaphe vAgdattAsIt, tadA tayoH saGgamAt prAk sA kanyA  pavitreNAtmanA garbhavatI babhUva| ");
INSERT INTO sanhk_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","tatra tasyAH pati ryUSaph saujanyAt tasyAH kalaGgaM prakAzayitum anicchan gopanene tAM pArityaktuM manazcakre| ");
INSERT INTO sanhk_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","sa tathaiva bhAvayati, tadAnIM paramezvarasya dUtaH svapne taM darzanaM dattvA vyAjahAra, he dAyUdaH santAna yUSaph tvaM nijAM jAyAM mariyamam AdAtuM mA bhaiSIH| ");
INSERT INTO sanhk_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","yatastasyA garbhaH pavitrAdAtmano'bhavat, sA ca putraM prasaviSyate, tadA tvaM tasya nAma yIzum (arthAt trAtAraM) karISyase, yasmAt sa nijamanujAn teSAM kaluSebhya uddhariSyati| ");
INSERT INTO sanhk_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","itthaM sati, pazya garbhavatI kanyA tanayaM prasaviSyate| immAnUyel tadIyaJca nAmadheyaM bhaviSyati|| immAnUyel asmAkaM saGgIzvara_ityarthaH| ");
INSERT INTO sanhk_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","iti yad vacanaM purvvaM bhaviSyadvaktrA IzvaraH kathAyAmAsa, tat tadAnIM siddhamabhavat| ");
INSERT INTO sanhk_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","anantaraM yUSaph nidrAto jAgarita utthAya paramezvarIyadUtasya nidezAnusAreNa nijAM jAyAM jagrAha, ");
INSERT INTO sanhk_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","kintu yAvat sA nijaM prathamasutaM a suSuve, tAvat tAM nopAgacchat, tataH sutasya nAma yIzuM cakre| ");
INSERT INTO sanhk_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","anantaraM herod saMjJake rAjJi rAjyaM zAsati yihUdIyadezasya baitlehami nagare yIzau jAtavati ca, katipayA jyotirvvudaH pUrvvasyA dizo yirUzAlamnagaraM sametya kathayamAsuH, ");
INSERT INTO sanhk_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","yo yihUdIyAnAM rAjA jAtavAn, sa kutrAste? vayaM pUrvvasyAM dizi tiSThantastadIyAM tArakAm apazyAma tasmAt taM praNantum aाgamAma| ");
INSERT INTO sanhk_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","tadA herod rAjA kathAmetAM nizamya yirUzAlamnagarasthitaiH sarvvamAnavaiH sArddham udvijya ");
INSERT INTO sanhk_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","sarvvAn pradhAnayAjakAn adhyApakAMzca samAhUyAnIya papraccha, khrISTaH kutra janiSyate? ");
INSERT INTO sanhk_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","tadA te kathayAmAsuH, yihUdIyadezasya baitlehami nagare, yato bhaviSyadvAdinA itthaM likhitamAste, ");
INSERT INTO sanhk_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","sarvvAbhyo rAjadhAnIbhyo yihUdIyasya nIvRtaH| he yIhUdIyadezasye baitleham tvaM na cAvarA|isrAyelIyalokAn me yato yaH pAlayiSyati| tAdRgeko mahArAjastvanmadhya udbhaviSyatI|| ");
INSERT INTO sanhk_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","tadAnIM herod rAjA tAn jyotirvvido gopanam AhUya sA tArakA kadA dRSTAbhavat , tad vinizcayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","aparaM tAn baitlehamaM prahItya gaditavAn, yUyaM yAta, yatnAt taM zizum anviSya taduddeze prApte mahyaM vArttAM dAsyatha, tato mayApi gatvA sa praNaMsyate| ");
INSERT INTO sanhk_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","tadAnIM rAjJa etAdRzIm AjJAM prApya te pratasthire, tataH pUrvvarsyAM dizi sthitaistai ryA tArakA dRSTA sA tArakA teSAmagre gatvA yatra sthAne zizUrAste, tasya sthAnasyopari sthagitA tasyau| ");
INSERT INTO sanhk_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","tad dRSTvA te mahAnanditA babhUvuH, ");
INSERT INTO sanhk_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","tato gehamadhya pravizya tasya mAtrA mariyamA sAddhaM taM zizuM nirIkSaya daNDavad bhUtvA praNemuH, aparaM sveSAM ghanasampattiM mocayitvA suvarNaM kunduruM gandharamaJca tasmai darzanIyaM dattavantaH| ");
INSERT INTO sanhk_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","pazcAd herod rAjasya samIpaM punarapi gantuM svapna IzvareNa niSiddhAH santo 'nyena pathA te nijadezaM prati pratasthire| ");
INSERT INTO sanhk_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","anantaraM teSu gatavatmu paramezvarasya dUto yUSaphe svapne darzanaM datvA jagAda, tvam utthAya zizuM tanmAtaraJca gRhItvA misardezaM palAyasva, aparaM yAvadahaM tubhyaM vArttAM na kathayiSyAmi, tAvat tatraiva nivasa, yato rAjA herod zizuM nAzayituM mRgayiSyate| ");
INSERT INTO sanhk_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","tadAnIM yUSaph utthAya rajanyAM zizuM tanmAtaraJca gRhItvA misardezaM prati pratasthe, ");
INSERT INTO sanhk_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","gatvA ca herodo nRpate rmaraNaparyyantaM tatra deze nyuvAsa, tena misardezAdahaM putraM svakIyaM samupAhUyam| yadetadvacanam IzvareNa bhaviSyadvAdinA kathitaM tat saphalamabhUt| ");
INSERT INTO sanhk_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","anantaraM herod jyotirvidbhirAtmAnaM pravaJcitaM vijJAya bhRzaM cukopa; aparaM jyotirvvidbhyastena vinizcitaM yad dinaM taddinAd gaNayitvA dvitIyavatsaraM praviSTA yAvanto bAlakA asmin baitlehamnagare tatsImamadhye cAsan, lokAn prahitya tAn sarvvAn ghAtayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ataH anekasya vilApasya ninAda: krandanasya ca| zokena kRtazabdazca rAmAyAM saMnizamyate| svabAlagaNahetorvai rAhel nArI tu rodinI| na manyate prabodhantu yataste naiva manti hi|| ");
INSERT INTO sanhk_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","yadetad vacanaM yirImiyanAmakabhaviSyadvAdinA kathitaM tat tadAnIM saphalam abhUt| ");
INSERT INTO sanhk_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","tadanantaraM heredi rAjani mRte paramezvarasya dUto misardeze svapne darzanaM dattvA yUSaphe kathitavAn ");
INSERT INTO sanhk_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","tvam utthAya zizuM tanmAtaraJca gRhItvA punarapIsrAyelo dezaM yAhI, ye janAH zizuM nAzayitum amRgayanta, te mRtavantaH| ");
INSERT INTO sanhk_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","tadAnIM sa utthAya zizuM tanmAtaraJca gRhlan isrAyeldezam AjagAma| ");
INSERT INTO sanhk_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","kintu yihUdIyadeze arkhilAyanAma rAjakumAro nijapitu rherodaH padaM prApya rAjatvaM karotIti nizamya tat sthAnaM yAtuM zaGkitavAn, pazcAt svapna IzvarAt prabodhaM prApya gAlIldezasya pradezaikaM prasthAya nAsarannAma nagaraM gatvA tatra nyuSitavAn, ");
INSERT INTO sanhk_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","tena taM nAsaratIyaM kathayiSyanti, yadetadvAkyaM bhaviSyadvAdibhirukttaM tat saphalamabhavat| ");
INSERT INTO sanhk_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","tadAnoM yohnnAmA majjayitA yihUdIyadezasya prAntaram upasthAya pracArayan kathayAmAsa, ");
INSERT INTO sanhk_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","manAMsi parAvarttayata, svargIyarAjatvaM samIpamAgatam| ");
INSERT INTO sanhk_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","paramezasya panthAnaM pariSkuruta sarvvataH| tasya rAjapathAMzcaiva samIkuruta sarvvathA| ityetat prAntare vAkyaM vadataH kasyacid ravaH|| ");
INSERT INTO sanhk_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","etadvacanaM yizayiyabhaviSyadvAdinA yohanamuddizya bhASitam| yohano vasanaM mahAGgaromajaM tasya kaTau carmmakaTibandhanaM; sa ca zUkakITAn madhu ca bhuktavAn| ");
INSERT INTO sanhk_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","tadAnIM yirUzAlamnagaranivAsinaH sarvve yihUdidezIyA yarddantaTinyA ubhayataTasthAzca mAnavA bahirAgatya tasya samIpe ");
INSERT INTO sanhk_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","svIyaM svIyaM duritam aGgIkRtya tasyAM yarddani tena majjitA babhUvuH| ");
INSERT INTO sanhk_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","aparaM bahUn phirUzinaH sidUkinazca manujAn maMktuM svasamIpam Agacchto vilokya sa tAn abhidadhau, re re bhujagavaMzA AgAmInaH kopAt palAyituM yuSmAn kazcetitavAn? ");
INSERT INTO sanhk_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","manaHparAvarttanasya samucitaM phalaM phalata| ");
INSERT INTO sanhk_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","kintvasmAkaM tAta ibrAhIm astIti sveSu manaHsu cIntayanto mA vyAharata| yato yuSmAn ahaM vadAmi, Izvara etebhyaH pASANebhya ibrAhImaH santAnAn utpAdayituM zaknoti| ");
INSERT INTO sanhk_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","aparaM pAdapAnAM mUle kuThAra idAnImapi lagan Aste, tasmAd yasmin pAdape uttamaM phalaM na bhavati, sa kRtto madhye'gniM nikSepsyate| ");
INSERT INTO sanhk_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","aparam ahaM manaHparAvarttanasUcakena majjanena yuSmAn majjayAmIti satyaM, kintu mama pazcAd ya Agacchati, sa mattopi mahAn, ahaM tadIyopAnahau voDhumapi nahi yogyosmi, sa yuSmAn vahnirUpe pavitra Atmani saMmajjayiSyati| ");
INSERT INTO sanhk_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","tasya kAre sUrpa Aste, sa svIyazasyAni samyak prasphoTya nijAn sakalagodhUmAn saMgRhya bhANDAgAre sthApayiSyati, kiMntu sarvvANi vuSANyanirvvANavahninA dAhayiSyati| ");
INSERT INTO sanhk_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","anantaraM yIzu ryohanA majjito bhavituM gAlIlpradezAd yarddani tasya samIpam AjagAma| ");
INSERT INTO sanhk_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","kintu yohan taM niSidhya babhASe, tvaM kiM mama samIpam Agacchasi? varaM tvayA majjanaM mama prayojanam Aste| ");
INSERT INTO sanhk_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","tadAnIM yIzuH pratyavocat; IdAnIm anumanyasva, yata itthaM sarvvadharmmasAdhanam asmAkaM karttavyaM, tataH so'nvamanyata| ");
INSERT INTO sanhk_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","anantaraM yIzurammasi majjituH san tatkSaNAt toyamadhyAd utthAya jagAma, tadA jImUtadvAre mukte jAte, sa IzvarasyAtmAnaM kapotavad avaruhya svoparyyAgacchantaM vIkSAJcakre| ");
INSERT INTO sanhk_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","aparam eSa mama priyaH putra etasminneva mama mahAsantoSa etAdRzI vyomajA vAg babhUva| ");
INSERT INTO sanhk_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","tataH paraM yIzuH pratArakeNa parIkSito bhavitum AtmanA prAntaram AkRSTaH ");
INSERT INTO sanhk_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","san catvAriMzadahorAtrAn anAhArastiSThan kSudhito babhUva| ");
INSERT INTO sanhk_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","tadAnIM parIkSitA tatsamIpam Agatya vyAhRtavAn, yadi tvamIzvarAtmajo bhavestarhyAjJayA pASANAnetAn pUpAn vidhehi| ");
INSERT INTO sanhk_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","tataH sa pratyabravIt, itthaM likhitamAste, \"manujaH kevalapUpena na jIviSyati, kintvIzvarasya vadanAd yAni yAni vacAMsi niHsaranti taireva jIviSyati|\" ");
INSERT INTO sanhk_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","tadA pratArakastaM puNyanagaraM nItvA mandirasya cUDopari nidhAya gaditavAn, ");
INSERT INTO sanhk_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","tvaM yadizvarasya tanayo bhavestarhIto'dhaH pata, yata itthaM likhitamAste, AdekSyati nijAn dUtAn rakSituM tvAM paramezvaraH| yathA sarvveSu mArgeSu tvadIyacaraNadvaye| na laget prastarAghAtastvAM ghariSyanti te karaiH|| ");
INSERT INTO sanhk_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","tadAnIM yIzustasmai kathitavAn etadapi likhitamAste, \"tvaM nijaprabhuM paramezvaraM mA parIkSasva|\" ");
INSERT INTO sanhk_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","anantaraM pratArakaH punarapi tam atyuJcadharAdharopari nItvA jagataH sakalarAjyAni tadaizvaryyANi ca darzayAzcakAra kathayAJcakAra ca, ");
INSERT INTO sanhk_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","yadi tvaM daNDavad bhavan mAM praNamestarhyaham etAni tubhyaM pradAsyAmi| ");
INSERT INTO sanhk_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","tadAnIM yIzustamavocat, dUrIbhava pratAraka, likhitamidam Aste, \"tvayA nijaH prabhuH paramezvaraH praNamyaH kevalaH sa sevyazca|\" ");
INSERT INTO sanhk_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","tataH pratArakeNa sa paryyatyAji, tadA svargIyadUtairAgatya sa siSeve| ");
INSERT INTO sanhk_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","tadanantaraM yohan kArAyAM babandhe, tadvArttAM nizamya yIzunA gAlIl prAsthIyata| ");
INSERT INTO sanhk_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","tataH paraM sa nAsarannagaraM vihAya jalaghestaTe sibUlUnnaptAlI etayoruvabhayoH pradezayoH sImnormadhyavarttI ya: kapharnAhUm tannagaram itvA nyavasat| ");
INSERT INTO sanhk_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","tasmAt, anyAdezIyagAlIli yarddanpAre'bdhirodhasi| naptAlisibUlUndezau yatra sthAne sthitau purA| ");
INSERT INTO sanhk_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","tatratyA manujA ye ye paryyabhrAmyan tamisrake| tairjanairbRhadAlokaH paridarziSyate tadA| avasan ye janA deze mRtyucchAyAsvarUpake| teSAmupari lokAnAmAlokaH saMprakAzitaH|| ");
INSERT INTO sanhk_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","yadetadvacanaM yizayiyabhaviSyadvAdinA proktaM, tat tadA saphalam abhUt| ");
INSERT INTO sanhk_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","anantaraM yIzuH susaMvAdaM pracArayan etAM kathAM kathayitum Arebhe, manAMsi parAvarttayata, svargIyarAjatvaM savidhamabhavat| ");
INSERT INTO sanhk_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","tataH paraM yIzu rgAlIlo jaladhestaTena gacchan gacchan Andriyastasya bhrAtA zimon arthato yaM pitaraM vadanti etAvubhau jalaghau jAlaM kSipantau dadarza, yatastau mInadhAriNAvAstAm| ");
INSERT INTO sanhk_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","tadA sa tAvAhUya vyAjahAra, yuvAM mama pazcAd AgacchataM, yuvAmahaM manujadhAriNau kariSyAmi| ");
INSERT INTO sanhk_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","tenaiva tau jAlaM vihAya tasya pazcAt AgacchatAm| ");
INSERT INTO sanhk_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","anantaraM tasmAt sthAnAt vrajan vrajan sivadiyasya sutau yAkUb yohannAmAnau dvau sahajau tAtena sArddhaM naukopari jAlasya jIrNoddhAraM kurvvantau vIkSya tAvAhUtavAn| ");
INSERT INTO sanhk_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","tatkSaNAt tau nAvaM svatAtaJca vihAya tasya pazcAdgAminau babhUvatuH| ");
INSERT INTO sanhk_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","anantaraM bhajanabhavane samupadizan rAjyasya susaMvAdaM pracArayan manujAnAM sarvvaprakArAn rogAn sarvvaprakArapIDAzca zamayan yIzuH kRtsnaM gAlIldezaM bhramitum Arabhata| ");
INSERT INTO sanhk_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","tena kRtsnasuriyAdezasya madhyaM tasya yazo vyApnot, aparaM bhUtagrastA apasmArargINaH pakSAdhAtiprabhRtayazca yAvanto manujA nAnAvidhavyAdhibhiH kliSTA Asan, teSu sarvveSu tasya samIpam AnIteSu sa tAn svasthAn cakAra| ");
INSERT INTO sanhk_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","etena gAlIl-dikApani-yirUzAlam-yihUdIyadezebhyo yarddanaH pArAJca bahavo manujAstasya pazcAd Agacchan| ");
INSERT INTO sanhk_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","anantaraM sa jananivahaM nirIkSya bhUdharopari vrajitvA samupaviveza| ");
INSERT INTO sanhk_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","tadAnIM ziSyeSu tasya samIpamAgateSu tena tebhya eSA kathA kathyAJcakre| ");
INSERT INTO sanhk_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","abhimAnahInA janA dhanyAH, yataste svargIyarAjyam adhikariSyanti| ");
INSERT INTO sanhk_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","khidyamAnA manujA dhanyAH, yasmAt te sAntvanAM prApsanti| ");
INSERT INTO sanhk_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","namrA mAnavAzca dhanyAH, yasmAt te medinIm adhikariSyanti| ");
INSERT INTO sanhk_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","dharmmAya bubhukSitAH tRSArttAzca manujA dhanyAH, yasmAt te paritarpsyanti| ");
INSERT INTO sanhk_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","kRpAlavo mAnavA dhanyAH, yasmAt te kRpAM prApsyanti| ");
INSERT INTO sanhk_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","nirmmalahRdayA manujAzca dhanyAH, yasmAt ta IzcaraM drakSyanti| ");
INSERT INTO sanhk_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","melayitAro mAnavA dhanyAH, yasmAt ta Izcarasya santAnatvena vikhyAsyanti| ");
INSERT INTO sanhk_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","dharmmakAraNAt tADitA manujA dhanyA, yasmAt svargIyarAjye teSAmadhikaro vidyate| ");
INSERT INTO sanhk_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","yadA manujA mama nAmakRte yuSmAn nindanti tADayanti mRSA nAnAdurvvAkyAni vadanti ca, tadA yuyaM dhanyAH| ");
INSERT INTO sanhk_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","tadA Anandata, tathA bhRzaM hlAdadhvaJca, yataH svarge bhUyAMsi phalAni lapsyadhve; te yuSmAkaM purAtanAn bhaviSyadvAdino'pi tAdRg atADayan| ");
INSERT INTO sanhk_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","yuyaM medinyAM lavaNarUpAH, kintu yadi lavaNasya lavaNatvam apayAti, tarhi tat kena prakAreNa svAduyuktaM bhaviSyati? tat kasyApi kAryyasyAyogyatvAt kevalaM bahiH prakSeptuM narANAM padatalena dalayituJca yogyaM bhavati| ");
INSERT INTO sanhk_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","yUyaM jagati dIptirUpAH, bhUdharopari sthitaM nagaraM guptaM bhavituM nahi zakSyati| ");
INSERT INTO sanhk_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","aparaM manujAH pradIpAn prajvAlya droNAdho na sthApayanti, kintu dIpAdhAroparyyeva sthApayanti, tena te dIpA gehasthitAn sakalAn prakAzayanti| ");
INSERT INTO sanhk_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","yena mAnavA yuSmAkaM satkarmmANi vilokya yuSmAkaM svargasthaM pitaraM dhanyaM vadanti, teSAM samakSaM yuSmAkaM dIptistAdRk prakAzatAm| ");
INSERT INTO sanhk_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","ahaM vyavasthAM bhaviSyadvAkyaJca loptum AgatavAn, itthaM mAnubhavata, te dve loptuM nAgatavAn, kintu saphale karttum Agatosmi| ");
INSERT INTO sanhk_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","aparaM yuSmAn ahaM tathyaM vadAmi yAvat vyomamedinyo rdhvaMso na bhaviSyati, tAvat sarvvasmin saphale na jAte vyavasthAyA ekA mAtrA bindurekopi vA na lopsyate| ");
INSERT INTO sanhk_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","tasmAt yo jana etAsAm AjJAnAm atikSudrAm ekAjJAmapI laMghate manujAMJca tathaiva zikSayati, sa svargIyarAjye sarvvebhyaH kSudratvena vikhyAsyate, kintu yo janastAM pAlayati, tathaiva zikSayati ca, sa svargIyarAjye pradhAnatvena vikhyAsyate| ");
INSERT INTO sanhk_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","aparaM yuSmAn ahaM vadAmi, adhyApakaphirUzimAnavAnAM dharmmAnuSThAnAt yuSmAkaM dharmmAnuSThAne nottame jAte yUyam IzvarIyarAjyaM praveSTuM na zakSyatha| ");
INSERT INTO sanhk_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","aparaJca tvaM naraM mA vadhIH, yasmAt yo naraM hanti, sa vicArasabhAyAM daNDArho bhaviSyati, pUrvvakAlInajanebhya iti kathitamAsIt, yuSmAbhirazrAvi| ");
INSERT INTO sanhk_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","kintvahaM yuSmAn vadAmi, yaH kazcit kAraNaM vinA nijabhrAtre kupyati, sa vicArasabhAyAM daNDArho bhaviSyati; yaH kazcicca svIyasahajaM nirbbodhaM vadati, sa mahAsabhAyAM daNDArho bhaviSyati; punazca tvaM mUDha iti vAkyaM yadi kazcit svIyabhrAtaraM vakti, tarhi narakAgnau sa daNDArho bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","ato vedyAH samIpaM nijanaivedye samAnIte'pi nijabhrAtaraM prati kasmAccit kAraNAt tvaM yadi doSI vidyase, tadAnIM tava tasya smRti rjAyate ca, ");
INSERT INTO sanhk_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tarhi tasyA vedyAH samIpe nijanaivaidyaM nidhAya tadaiva gatvA pUrvvaM tena sArddhaM mila, pazcAt Agatya nijanaivedyaM nivedaya| ");
INSERT INTO sanhk_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","anyaJca yAvat vivAdinA sArddhaM vartmani tiSThasi, tAvat tena sArddhaM melanaM kuru; no cet vivAdI vicArayituH samIpe tvAM samarpayati vicArayitA ca rakSiNaH sannidhau samarpayati tadA tvaM kArAyAM badhyethAH| ");
INSERT INTO sanhk_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","tarhi tvAmahaM taththaM bravImi, zeSakapardake'pi na parizodhite tasmAt sthAnAt kadApi bahirAgantuM na zakSyasi| ");
INSERT INTO sanhk_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","aparaM tvaM mA vyabhicara, yadetad vacanaM pUrvvakAlInalokebhyaH kathitamAsIt, tad yUyaM zrutavantaH; ");
INSERT INTO sanhk_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","kintvahaM yuSmAn vadAmi, yadi kazcit kAmataH kAJcana yoSitaM pazyati, tarhi sa manasA tadaiva vyabhicaritavAn| ");
INSERT INTO sanhk_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","tasmAt tava dakSiNaM netraM yadi tvAM bAdhate, tarhi tannetram utpATya dUre nikSipa, yasmAt tava sarvvavapuSo narake nikSepAt tavaikAGgasya nAzo varaM| ");
INSERT INTO sanhk_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","yadvA tava dakSiNaH karo yadi tvAM bAdhate, tarhi taM karaM chittvA dUre nikSipa, yataH sarvvavapuSo narake nikSepAt ekAGgasya nAzo varaM| ");
INSERT INTO sanhk_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","uktamAste, yadi kazcin nijajAyAM parityakttum icchati, tarhi sa tasyai tyAgapatraM dadAtu| ");
INSERT INTO sanhk_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","kintvahaM yuSmAn vyAharAmi, vyabhicAradoSe na jAte yadi kazcin nijajAyAM parityajati, tarhi sa tAM vyabhicArayati; yazca tAM tyaktAM striyaM vivahati, sopi vyabhicarati| ");
INSERT INTO sanhk_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","punazca tvaM mRSA zapatham na kurvvan IzcarAya nijazapathaM pAlaya, pUrvvakAlInalokebhyo yaiSA kathA kathitA, tAmapi yUyaM zrutavantaH| ");
INSERT INTO sanhk_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","kintvahaM yuSmAn vadAmi, kamapi zapathaM mA kArSTa, arthataH svarganAmnA na, yataH sa Izvarasya siMhAsanaM; ");
INSERT INTO sanhk_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","pRthivyA nAmnApi na, yataH sA tasya pAdapIThaM; yirUzAlamo nAmnApi na, yataH sA mahArAjasya purI; ");
INSERT INTO sanhk_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","nijazironAmnApi na, yasmAt tasyaikaM kacamapi sitam asitaM vA karttuM tvayA na zakyate| ");
INSERT INTO sanhk_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","aparaM yUyaM saMlApasamaye kevalaM bhavatIti na bhavatIti ca vadata yata ito'dhikaM yat tat pApAtmano jAyate| ");
INSERT INTO sanhk_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","aparaM locanasya vinimayena locanaM dantasya vinimayena dantaH pUrvvaktamidaM vacanaJca yuSmAbhirazrUyata| ");
INSERT INTO sanhk_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","kintvahaM yuSmAn vadAmi yUyaM hiMsakaM naraM mA vyAghAtayata| kintu kenacit tava dakSiNakapole capeTAghAte kRte taM prati vAmaM kapolaJca vyAghoTaya| ");
INSERT INTO sanhk_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","aparaM kenacit tvayA sArdhdaM vivAdaM kRtvA tava paridheyavasane jighRtite tasmAyuttarIyavasanamapi dehi| ");
INSERT INTO sanhk_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","yadi kazcit tvAM krozamekaM nayanArthaM anyAyato dharati, tadA tena sArdhdaM krozadvayaM yAhi| ");
INSERT INTO sanhk_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","yazca mAnavastvAM yAcate, tasmai dehi, yadi kazcit tubhyaM dhArayitum icchati, tarhi taM prati parAMmukho mA bhUH| ");
INSERT INTO sanhk_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","nijasamIpavasini prema kuru, kintu zatruM prati dveSaM kuru, yadetat puroktaM vacanaM etadapi yUyaM zrutavantaH| ");
INSERT INTO sanhk_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","kintvahaM yuSmAn vadAmi, yUyaM ripuvvapi prema kuruta, ye ca yuSmAn zapante, tAna, AziSaM vadata, ye ca yuSmAn RृtIyante, teSAM maGgalaM kuruta, ye ca yuSmAn nindanti, tADayanti ca, teSAM kRte prArthayadhvaM| ");
INSERT INTO sanhk_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","tatra yaH satAmasatAJcopari prabhAkaram udAyayati, tathA dhArmmikAnAmadhArmmikAnAJcopari nIraM varSayati tAdRzo yo yuSmAkaM svargasthaH pitA, yUyaM tasyaiva santAnA bhaviSyatha| ");
INSERT INTO sanhk_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ye yuSmAsu prema kurvvanti, yUyaM yadi kevalaM tevveva prema kurutha, tarhi yuSmAkaM kiM phalaM bhaviSyati? caNDAlA api tAdRzaM kiM na kurvvanti? ");
INSERT INTO sanhk_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","aparaM yUyaM yadi kevalaM svIyabhrAtRtvena namata, tarhi kiM mahat karmma kurutha? caNDAlA api tAdRzaM kiM na kurvvanti? ");
INSERT INTO sanhk_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","tasmAt yuSmAkaM svargasthaH pitA yathA pUrNo bhavati, yUyamapi tAdRzA bhavata| ");
INSERT INTO sanhk_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","sAvadhAnA bhavata, manujAn darzayituM teSAM gocare dharmmakarmma mA kuruta, tathA kRte yuSmAkaM svargasthapituH sakAzAt kiJcana phalaM na prApsyatha| ");
INSERT INTO sanhk_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","tvaM yadA dadAsi tadA kapaTino janA yathA manujebhyaH prazaMsAM prAptuM bhajanabhavane rAjamArge ca tUrIM vAdayanti, tathA mA kuriु, ahaM tubhyaM yathArthaM kathayAmi, te svakAyaM phalam alabhanta| ");
INSERT INTO sanhk_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","kintu tvaM yadA dadAsi, tadA nijadakSiNakaro yat karoti, tad vAmakaraM mA jJApaya| ");
INSERT INTO sanhk_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","tena tava dAnaM guptaM bhaviSyati yastu tava pitA guptadarzI, sa prakAzya tubhyaM phalaM dAsyati| ");
INSERT INTO sanhk_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","aparaM yadA prArthayase, tadA kapaTina_iva mA kuru, yasmAt te bhajanabhavane rAjamArgasya koNe tiSThanto lokAn darzayantaH prArthayituM prIyante; ahaM yuSmAn tathyaM vadAmi, te svakIyaphalaM prApnuvan| ");
INSERT INTO sanhk_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","tasmAt prArthanAkAle antarAgAraM pravizya dvAraM rudvvA guptaM pazyatastava pituH samIpe prArthayasva; tena tava yaH pitA guptadarzI, sa prakAzya tubhyaM phalaM dAsyatil ");
INSERT INTO sanhk_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","aparaM prArthanAkAle devapUjakAiva mudhA punaruktiM mA kuru, yasmAt te bodhante, bahuvAraM kathAyAM kathitAyAM teSAM prArthanA grAhiSyate| ");
INSERT INTO sanhk_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","yUyaM teSAmiva mA kuruta, yasmAt yuSmAkaM yad yat prayojanaM yAcanAtaH prAgeva yuSmAkaM pitA tat jAnAti| ");
INSERT INTO sanhk_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","ataeva yUyama IdRk prArthayadhvaM, he asmAkaM svargasthapitaH, tava nAma pUjyaM bhavatu| ");
INSERT INTO sanhk_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","tava rAjatvaM bhavatu; tavecchA svarge yathA tathaiva medinyAmapi saphalA bhavatu| ");
INSERT INTO sanhk_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","asmAkaM prayojanIyam AhAram adya dehi| ");
INSERT INTO sanhk_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","vayaM yathA nijAparAdhinaH kSamAmahe, tathaivAsmAkam aparAdhAn kSamasva| ");
INSERT INTO sanhk_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","asmAn parIkSAM mAnaya, kintu pApAtmano rakSa; rAjatvaM gauravaM parAkramaH ete sarvve sarvvadA tava; tathAstu| ");
INSERT INTO sanhk_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","yadi yUyam anyeSAm aparAdhAn kSamadhve tarhi yuSmAkaM svargasthapitApi yuSmAn kSamiSyate; ");
INSERT INTO sanhk_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","kintu yadi yUyam anyeSAm aparAdhAn na kSamadhve, tarhi yuSmAkaM janakopi yuSmAkam aparAdhAn na kSamiSyate| ");
INSERT INTO sanhk_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","aparam upavAsakAle kapaTino janA mAnuSAn upavAsaM jJApayituM sveSAM vadanAni mlAnAni kurvvanti, yUyaM ta_iva viSaNavadanA mA bhavata; ahaM yuSmAn tathyaM vadAmi te svakIyaphalam alabhanta| ");
INSERT INTO sanhk_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","yadA tvam upavasasi, tadA yathA lokaistvaM upavAsIva na dRzyase, kintu tava yo'gocaraH pitA tenaiva dRzyase, tatkRte nijazirasi tailaM marddaya vadanaJca prakSAlaya; ");
INSERT INTO sanhk_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","tena tava yaH pitA guptadarzI sa prakAzya tubhyaM phalaM dAsyati| ");
INSERT INTO sanhk_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","aparaM yatra sthAne kITAH kalaGkAzca kSayaM nayanti, caurAzca sandhiM karttayitvA corayituM zaknuvanti, tAdRzyAM medinyAM svArthaM dhanaM mA saMcinuta| ");
INSERT INTO sanhk_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","kintu yatra sthAne kITAH kalaGkAzca kSayaM na nayanti, caurAzca sandhiM karttayitvA corayituM na zaknuvanti, tAdRze svarge dhanaM saJcinuta| ");
INSERT INTO sanhk_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","yasmAt yatra sthAne yuSmAMka dhanaM tatraiva khAne yuSmAkaM manAMsi| ");
INSERT INTO sanhk_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","locanaM dehasya pradIpakaM, tasmAt yadi tava locanaM prasannaM bhavati, tarhi tava kRtsnaM vapu rdIptiyuktaM bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","kintu locane'prasanne tava kRtsnaM vapuH tamisrayuktaM bhaviSyati| ataeva yA dIptistvayi vidyate, sA yadi tamisrayuktA bhavati, tarhi tat tamisraM kiyan mahat| ");
INSERT INTO sanhk_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","kopi manujo dvau prabhU sevituM na zaknoti, yasmAd ekaM saMmanya tadanyaM na sammanyate, yadvA ekatra mano nidhAya tadanyam avamanyate; tathA yUyamapIzvaraM lakSmIJcetyubhe sevituM na zaknutha| ");
INSERT INTO sanhk_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","aparam ahaM yuSmabhyaM tathyaM kathayAmi, kiM bhakSiSyAmaH? kiM pAsyAmaH? iti prANadhAraNAya mA cintayata; kiM paridhAsyAmaH? iti kAyarakSaNAya na cintayata; bhakSyAt prANA vasanAJca vapUMSi kiM zreSThANi na hi? ");
INSERT INTO sanhk_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","vihAyaso vihaGgamAn vilokayata; tai rnopyate na kRtyate bhANDAgAre na saJcIyate'pi; tathApi yuSmAkaM svargasthaH pitA tebhya AhAraM vitarati| ");
INSERT INTO sanhk_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","yUyaM tebhyaH kiM zreSThA na bhavatha? yuSmAkaM kazcit manujaH cintayan nijAyuSaH kSaNamapi varddhayituM zaknoti? ");
INSERT INTO sanhk_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","aparaM vasanAya kutazcintayata? kSetrotpannAni puSpANi kathaM varddhante tadAlocayata| tAni tantUn notpAdayanti kimapi kAryyaM na kurvvanti; ");
INSERT INTO sanhk_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","tathApyahaM yuSmAn vadAmi, sulemAn tAdRg aizvaryyavAnapi tatpuSpamiva vibhUSito nAsIt| ");
INSERT INTO sanhk_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","tasmAt kSadya vidyamAnaM zcaH cullyAM nikSepsyate tAdRzaM yat kSetrasthitaM kusumaM tat yadIzcara itthaM bibhUSayati, tarhi he stokapratyayino yuSmAn kiM na paridhApayiSyati? ");
INSERT INTO sanhk_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","tasmAt asmAbhiH kimatsyate? kiJca pAyiSyate? kiM vA paridhAyiSyate, iti na cintayata| ");
INSERT INTO sanhk_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","yasmAt devArccakA apIti ceSTante; eteSu dravyeSu prayojanamastIti yuSmAkaM svargasthaH pitA jAnAti| ");
INSERT INTO sanhk_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ataeva prathamata IzvarIyarAjyaM dharmmaJca ceSTadhvaM, tata etAni vastUni yuSmabhyaM pradAyiSyante| ");
INSERT INTO sanhk_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","zvaH kRte mA cintayata, zvaeva svayaM svamuddizya cintayiSyati; adyatanI yA cintA sAdyakRte pracuratarA| ");
INSERT INTO sanhk_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","yathA yUyaM doSIkRtA na bhavatha, tatkRte'nyaM doSiNaM mA kuruta| ");
INSERT INTO sanhk_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","yato yAdRzena doSeNa yUyaM parAn doSiNaH kurutha, tAdRzena doSeNa yUyamapi doSIkRtA bhaviSyatha, anyaJca yena parimANena yuSmAbhiH parimIyate, tenaiva parimANena yuSmatkRte parimAyiSyate| ");
INSERT INTO sanhk_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","aparaJca nijanayane yA nAsA vidyate, tAm anAlocya tava sahajasya locane yat tRNam Aste, tadeva kuto vIkSase? ");
INSERT INTO sanhk_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","tava nijalocane nAsAyAM vidyamAnAyAM, he bhrAtaH, tava nayanAt tRNaM bahiSyartuM anujAnIhi, kathAmetAM nijasahajAya kathaM kathayituM zaknoSi? ");
INSERT INTO sanhk_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","he kapaTin, Adau nijanayanAt nAsAM bahiSkuru tato nijadRSTau suprasannAyAM tava bhrAtR rlocanAt tRNaM bahiSkartuM zakSyasi| ");
INSERT INTO sanhk_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","anyaJca sArameyebhyaH pavitravastUni mA vitarata, varAhANAM samakSaJca muktA mA nikSipata; nikSepaNAt te tAH sarvvAH padai rdalayiSyanti, parAvRtya yuSmAnapi vidArayiSyanti| ");
INSERT INTO sanhk_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","yAcadhvaM tato yuSmabhyaM dAyiSyate; mRgayadhvaM tata uddezaM lapsyadhve; dvAram Ahata, tato yuSmatkRte muktaM bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","yasmAd yena yAcyate, tena labhyate; yena mRgyate tenoddezaH prApyate; yena ca dvAram Ahanyate, tatkRte dvAraM mocyate| ");
INSERT INTO sanhk_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Atmajena pUpe prArthite tasmai pASANaM vizrANayati, ");
INSERT INTO sanhk_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","mIne yAcite ca tasmai bhujagaM vitarati, etAdRzaH pitA yuSmAkaM madhye ka Aste? ");
INSERT INTO sanhk_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","tasmAd yUyam abhadrAH santo'pi yadi nijabAlakebhya uttamaM dravyaM dAtuM jAnItha, tarhi yuSmAkaM svargasthaH pitA svIyayAcakebhyaH kimuttamAni vastUni na dAsyati? ");
INSERT INTO sanhk_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","yUSmAn pratItareSAM yAdRzo vyavahAro yuSmAkaM priyaH, yUyaM tAn prati tAdRzAneva vyavahArAn vidhatta; yasmAd vyavasthAbhaviSyadvAdinAM vacanAnAm iti sAram| ");
INSERT INTO sanhk_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","saGkIrNadvAreNa pravizata; yato narakagamanAya yad dvAraM tad vistIrNaM yacca vartma tad bRhat tena bahavaH pravizanti| ");
INSERT INTO sanhk_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","aparaM svargagamanAya yad dvAraM tat kIdRk saMkIrNaM| yacca vartma tat kIdRg durgamam| taduddeSTAraH kiyanto'lpAH| ");
INSERT INTO sanhk_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","aparaJca ye janA meSavezena yuSmAkaM samIpam Agacchanti, kintvantardurantA vRkA etAdRzebhyo bhaviSyadvAdibhyaH sAvadhAnA bhavata, yUyaM phalena tAn paricetuM zaknutha| ");
INSERT INTO sanhk_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","manujAH kiM kaNTakino vRkSAd drAkSAphalAni zRgAlakolitazca uDumbaraphalAni zAtayanti? ");
INSERT INTO sanhk_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","tadvad uttama eva pAdapa uttamaphalAni janayati, adhamapAdapaevAdhamaphalAni janayati| ");
INSERT INTO sanhk_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","kintUttamapAdapaH kadApyadhamaphalAni janayituM na zaknoti, tathAdhamopi pAdapa uttamaphalAni janayituM na zaknoti| ");
INSERT INTO sanhk_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","aparaM ye ye pAdapA adhamaphalAni janayanti, te kRttA vahnau kSipyante| ");
INSERT INTO sanhk_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ataeva yUyaM phalena tAn pariceSyatha| ");
INSERT INTO sanhk_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","ye janA mAM prabhuM vadanti, te sarvve svargarAjyaM pravekSyanti tanna, kintu yo mAnavo mama svargasthasya pituriSTaM karmma karoti sa eva pravekSyati| ");
INSERT INTO sanhk_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","tad dine bahavo mAM vadiSyanti, he prabho he prabho, tava nAmnA kimasmAmi rbhaviSyadvAkyaM na vyAhRtaM? tava nAmnA bhUtAH kiM na tyAjitAH? tava nAmnA kiM nAnAdbhutAni karmmANi na kRtAni? ");
INSERT INTO sanhk_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","tadAhaM vadiSyAmi, he kukarmmakAriNo yuSmAn ahaM na vedmi, yUyaM matsamIpAd dUrIbhavata| ");
INSERT INTO sanhk_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","yaH kazcit mamaitAH kathAH zrutvA pAlayati, sa pASANopari gRhanirmmAtrA jJAninA saha mayopamIyate| ");
INSERT INTO sanhk_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","yato vRSTau satyAm AplAva Agate vAyau vAte ca teSu tadgehaM lagneSu pASANopari tasya bhittestanna patatil ");
INSERT INTO sanhk_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","kintu yaH kazcit mamaitAH kathAH zrutvA na pAlayati sa saikate gehanirmmAtrA 'jJAninA upamIyate| ");
INSERT INTO sanhk_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","yato jalavRSTau satyAm AplAva Agate pavane vAte ca tai rgRhe samAghAte tat patati tatpatanaM mahad bhavati| ");
INSERT INTO sanhk_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","yIzunaiteSu vAkyeSu samApiteSu mAnavAstadIyopadezam AzcaryyaM menire| ");
INSERT INTO sanhk_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","yasmAt sa upAdhyAyA iva tAn nopadideza kintu samarthapuruSa_iva samupadideza| ");
INSERT INTO sanhk_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","yadA sa parvvatAd avArohat tadA bahavo mAnavAstatpazcAd vavrajuH| ");
INSERT INTO sanhk_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ekaH kuSThavAn Agatya taM praNamya babhASe, he prabho, yadi bhavAn saMmanyate, tarhi mAM nirAmayaM karttuM zaknoti| ");
INSERT INTO sanhk_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","tato yIzuH karaM prasAryya tasyAGgaM spRzan vyAjahAra, sammanye'haM tvaM nirAmayo bhava; tena sa tatkSaNAt kuSThenAmoci| ");
INSERT INTO sanhk_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","tato yIzustaM jagAda, avadhehi kathAmetAM kazcidapi mA brUhi, kintu yAjakasya sannidhiM gatvA svAtmAnaM darzaya manujebhyo nijanirAmayatvaM pramANayituM mUsAnirUpitaM dravyam utsRja ca| ");
INSERT INTO sanhk_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","tadanantaraM yIzunA kapharnAhUmnAmani nagare praviSTe kazcit zatasenApatistatsamIpam Agatya vinIya babhASe, ");
INSERT INTO sanhk_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","he prabho, madIya eko dAsaH pakSAghAtavyAdhinA bhRzaM vyathitaH, satu zayanIya Aste| ");
INSERT INTO sanhk_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","tadAnIM yIzustasmai kathitavAn, ahaM gatvA taM nirAmayaM kariSyAmi| ");
INSERT INTO sanhk_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","tataH sa zatasenApatiH pratyavadat, he prabho, bhavAn yat mama gehamadhyaM yAti tadyogyabhAjanaM nAhamasmi; vAGmAtram Adizatu, tenaiva mama dAso nirAmayo bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","yato mayi paranidhne'pi mama nidezavazyAH kati kati senAH santi, tata ekasmin yAhItyukte sa yAti, tadanyasmin ehItyukte sa AyAti, tathA mama nijadAse karmmaitat kurvvityukte sa tat karoti| ");
INSERT INTO sanhk_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","tadAnIM yIzustasyaitat vaco nizamya vismayApanno'bhUt; nijapazcAdgAmino mAnavAn avocca, yuSmAn tathyaM vacmi, isrAyelIyalokAnAM madhye'pi naitAdRzo vizvAso mayA prAptaH| ");
INSERT INTO sanhk_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","anyaccAhaM yuSmAn vadAmi, bahavaH pUrvvasyAH pazcimAyAzca diza Agatya ibrAhImA ishAkA yAkUbA ca sAkam militvA samupavekSyanti; ");
INSERT INTO sanhk_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","kintu yatra sthAne rodanadantagharSaNe bhavatastasmin bahirbhUtatamisre rAjyasya santAnA nikSesyante| ");
INSERT INTO sanhk_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","tataH paraM yIzustaM zatasenApatiM jagAda, yAhi, tava pratItyanusArato maGgalaM bhUyAt; tadA tasminneva daNDe tadIyadAso nirAmayo babhUva| ");
INSERT INTO sanhk_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","anantaraM yIzuH pitarasya gehamupasthAya jvareNa pIDitAM zayanIyasthitAM tasya zvazrUM vIkSAJcakre| ");
INSERT INTO sanhk_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","tatastena tasyAH karasya spRSTatavAt jvarastAM tatyAja, tadA sA samutthAya tAn siSeve| ");
INSERT INTO sanhk_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","anantaraM sandhyAyAM satyAM bahuzo bhUtagrastamanujAn tasya samIpam AninyuH sa ca vAkyena bhUtAn tyAjayAmAsa, sarvvaprakArapIDitajanAMzca nirAmayAn cakAra; ");
INSERT INTO sanhk_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","tasmAt, sarvvA durbbalatAsmAkaM tenaiva paridhAritA| asmAkaM sakalaM vyAdhiM saeva saMgRhItavAn| yadetadvacanaM yizayiyabhaviSyadvAdinoktamAsIt, tattadA saphalamabhavat| ");
INSERT INTO sanhk_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","anantaraM yIzuzcaturdikSu jananivahaM vilokya taTinyAH pAraM yAtuM ziSyAn Adideza| ");
INSERT INTO sanhk_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","tadAnIm eka upAdhyAya Agatya kathitavAn, he guro, bhavAn yatra yAsyati tatrAhamapi bhavataH pazcAd yAsyAmi| ");
INSERT INTO sanhk_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","tato yIzu rjagAda, kroSTuH sthAtuM sthAnaM vidyate, vihAyaso vihaGgamAnAM nIDAni ca santi; kintu manuSyaputrasya ziraH sthApayituM sthAnaM na vidyate| ");
INSERT INTO sanhk_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","anantaram apara ekaH ziSyastaM babhASe, he prabho, prathamato mama pitaraM zmazAne nidhAtuM gamanArthaM mAm anumanyasva| ");
INSERT INTO sanhk_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","tato yIzuruktavAn mRtA mRtAn zmazAne nidadhatu, tvaM mama pazcAd Agaccha| ");
INSERT INTO sanhk_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","anantaraM tasmin nAvamArUDhe tasya ziSyAstatpazcAt jagmuH| ");
INSERT INTO sanhk_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","pazcAt sAgarasya madhyaM teSu gateSu tAdRzaH prabalo jhaJbhzanila udatiSThat, yena mahAtaraGga utthAya taraNiM chAditavAn, kintu sa nidrita AsIt| ");
INSERT INTO sanhk_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","tadA ziSyA Agatya tasya nidrAbhaGgaM kRtvA kathayAmAsuH, he prabho, vayaM mriyAmahe, bhavAn asmAkaM prANAn rakSatu| ");
INSERT INTO sanhk_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","tadA sa tAn uktavAn, he alpavizvAsino yUyaM kuto vibhItha? tataH sa utthAya vAtaM sAgaraJca tarjayAmAsa, tato nirvvAtamabhavat| ");
INSERT INTO sanhk_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","aparaM manujA vismayaM vilokya kathayAmAsuH, aho vAtasaritpatI asya kimAjJAgrAhiNau? kIdRzo'yaM mAnavaH| ");
INSERT INTO sanhk_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","anantaraM sa pAraM gatvA giderIyadezam upasthitavAn; tadA dvau bhUtagrastamanujau zmazAnasthAnAd bahi rbhUtvA taM sAkSAt kRtavantau, tAvetAdRzau pracaNDAvAstAM yat tena sthAnena kopi yAtuM nAzaknot| ");
INSERT INTO sanhk_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","tAvucaiH kathayAmAsatuH, he Izvarasya sUno yIzo, tvayA sAkam AvayoH kaH sambandhaH? nirUpitakAlAt prAgeva kimAvAbhyAM yAtanAM dAtum atrAgatosi? ");
INSERT INTO sanhk_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","tadAnIM tAbhyAM kiJcid dUre varAhANAm eko mahAvrajo'carat| ");
INSERT INTO sanhk_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","tato bhUtau tau tasyAntike vinIya kathayAmAsatuH, yadyAvAM tyAjayasi, tarhi varAhANAM madhyevrajam AvAM preraya| ");
INSERT INTO sanhk_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","tadA yIzuravadat yAtaM, anantaraM tau yadA manujau vihAya varAhAn Azritavantau, tadA te sarvve varAhA uccasthAnAt mahAjavena dhAvantaH sAgarIyatoye majjanto mamruH| ");
INSERT INTO sanhk_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","tato varAharakSakAH palAyamAnA madhyenagaraM tau bhUtagrastau prati yadyad aghaTata, tAH sarvvavArttA avadan| ");
INSERT INTO sanhk_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","tato nAgarikAH sarvve manujA yIzuM sAkSAt karttuM bahirAyAtAH taJca vilokya prArthayAJcakrire bhavAn asmAkaM sImAto yAtu| ");
INSERT INTO sanhk_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","anantaraM yIzu rnaukAmAruhya punaH pAramAgatya nijagrAmam Ayayau| ");
INSERT INTO sanhk_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","tataH katipayA janA ekaM pakSAghAtinaM svaTTopari zAyayitvA tatsamIpam Anayan; tato yIzusteSAM pratItiM vijJAya taM pakSAghAtinaM jagAda, he putra, susthiro bhava, tava kaluSasya marSaNaM jAtam| ");
INSERT INTO sanhk_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","tAM kathAM nizamya kiyanta upAdhyAyA manaHsu cintitavanta eSa manuja IzvaraM nindati| ");
INSERT INTO sanhk_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","tataH sa teSAm etAdRzIM cintAM vijJAya kathitavAn, yUyaM manaHsu kRta etAdRzIM kucintAM kurutha? ");
INSERT INTO sanhk_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","tava pApamarSaNaM jAtaM, yadvA tvamutthAya gaccha, dvayoranayo rvAkyayoH kiM vAkyaM vaktuM sugamaM? ");
INSERT INTO sanhk_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","kintu medinyAM kaluSaM kSamituM manujasutasya sAmarthyamastIti yUyaM yathA jAnItha, tadarthaM sa taM pakSAghAtinaM gaditavAn, uttiSTha, nijazayanIyaM AdAya gehaM gaccha| ");
INSERT INTO sanhk_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","tataH sa tatkSaNAd utthAya nijagehaM prasthitavAn| ");
INSERT INTO sanhk_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","mAnavA itthaM vilokya vismayaM menire, IzvareNa mAnavAya sAmarthyam IdRzaM dattaM iti kAraNAt taM dhanyaM babhASire ca| ");
INSERT INTO sanhk_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","anantaraM yIzustatsthAnAd gacchan gacchan karasaMgrahasthAne samupaviSTaM mathinAmAnam ekaM manujaM vilokya taM babhASe, mama pazcAd Agaccha, tataH sa utthAya tasya pazcAd vavrAja| ");
INSERT INTO sanhk_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","tataH paraM yIzau gRhe bhoktum upaviSTe bahavaH karasaMgrAhiNaH kaluSiNazca mAnavA Agatya tena sAkaM tasya ziSyaizca sAkam upavivizuH| ");
INSERT INTO sanhk_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","phirUzinastad dRSTvA tasya ziSyAn babhASire, yuSmAkaM guruH kiM nimittaM karasaMgrAhibhiH kaluSibhizca sAkaM bhuMkte? ");
INSERT INTO sanhk_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","yIzustat zrutvA tAn pratyavadat, nirAmayalokAnAM cikitsakena prayojanaM nAsti, kintu sAmayalokAnAM prayojanamAste| ");
INSERT INTO sanhk_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","ato yUyaM yAtvA vacanasyAsyArthaM zikSadhvam, dayAyAM me yathA prIti rna tathA yajJakarmmaNi|yato'haM dhArmmikAn AhvAtuM nAgato'smi kintu manaH parivarttayituM pApina AhvAtum Agato'smi| ");
INSERT INTO sanhk_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","anantaraM yohanaH ziSyAstasya samIpam Agatya kathayAmAsuH, phirUzino vayaJca punaH punarupavasAmaH, kintu tava ziSyA nopavasanti, kutaH? ");
INSERT INTO sanhk_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","tadA yIzustAn avocat yAvat sakhInAM saMGge kanyAyA varastiSThati, tAvat kiM te vilApaM karttuM zakluvanti? kintu yadA teSAM saMGgAd varaM nayanti, tAdRzaH samaya AgamiSyati, tadA te upavatsyanti| ");
INSERT INTO sanhk_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","purAtanavasane kopi navInavastraM na yojayati, yasmAt tena yojitena purAtanavasanaM chinatti tacchidraJca bahukutsitaM dRzyate| ");
INSERT INTO sanhk_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","anyaJca purAtanakutvAM kopi navAnagostanIrasaM na nidadhAti, yasmAt tathA kRte kutU rvidIryyate tena gostanIrasaH patati kutUzca nazyati; tasmAt navInAyAM kutvAM navIno gostanIrasaH sthApyate, tena dvayoravanaM bhavati| ");
INSERT INTO sanhk_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","aparaM tenaitatkathAkathanakAle eko'dhipatistaM praNamya babhASe, mama duhitA prAyeNaitAvatkAle mRtA, tasmAd bhavAnAgatya tasyA gAtre hastamarpayatu, tena sA jIviSyati| ");
INSERT INTO sanhk_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","tadAnIM yIzuH ziSyaiH sAkam utthAya tasya pazcAd vavrAja| ");
INSERT INTO sanhk_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ityanantare dvAdazavatsarAn yAvat pradarAmayena zIrNaikA nArI tasya pazcAd Agatya tasya vasanasya granthiM pasparza; ");
INSERT INTO sanhk_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","yasmAt mayA kevalaM tasya vasanaM spRSTvA svAsthyaM prApsyate, sA nArIti manasi nizcitavatI| ");
INSERT INTO sanhk_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","tato yIzurvadanaM parAvarttya tAM jagAda, he kanye, tvaM susthirA bhava, tava vizvAsastvAM svasthAmakArSIt| etadvAkye gaditaeva sA yoSit svasthAbhUt| ");
INSERT INTO sanhk_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","aparaM yIzustasyAdhyakSasya gehaM gatvA vAdakaprabhRtIn bahUn lokAn zabdAyamAnAn vilokya tAn avadat, ");
INSERT INTO sanhk_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","panthAnaM tyaja, kanyeyaM nAmriyata nidritAste; kathAmetAM zrutvA te tamupajahasuH| ");
INSERT INTO sanhk_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","kintu sarvveSu bahiSkRteSu so'bhyantaraM gatvA kanyAyAH karaM dhRtavAn, tena sodatiSThat; ");
INSERT INTO sanhk_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","tatastatkarmmaNo yazaH kRtsnaM taM dezaM vyAptavat| ");
INSERT INTO sanhk_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","tataH paraM yIzustasmAt sthAnAd yAtrAM cakAra; tadA he dAyUdaH santAna, asmAn dayasva, iti vadantau dvau janAvandhau procairAhUyantau tatpazcAd vavrajatuH| ");
INSERT INTO sanhk_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","tato yIzau gehamadhyaM praviSTaM tAvapi tasya samIpam upasthitavantau, tadAnIM sa tau pRSTavAn karmmaitat karttuM mama sAmarthyam Aste, yuvAM kimiti pratIthaH? tadA tau pratyUcatuH, satyaM prabho| ");
INSERT INTO sanhk_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","tadAnIM sa tayo rlocanAni spRzan babhASe, yuvayoH pratItyanusArAd yuvayo rmaGgalaM bhUyAt| tena tatkSaNAt tayo rnetrANi prasannAnyabhavan, ");
INSERT INTO sanhk_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","pazcAd yIzustau dRDhamAjJApya jagAda, avadhattam etAM kathAM kopi manujo ma jAnIyAt| ");
INSERT INTO sanhk_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","kintu tau prasthAya tasmin kRtsne deze tasya kIrttiM prakAzayAmAsatuH| ");
INSERT INTO sanhk_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","aparaM tau bahiryAta etasminnantare manujA ekaM bhUtagrastamUkaM tasya samIpam AnItavantaH| ");
INSERT INTO sanhk_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","tena bhUte tyAjite sa mUkaH kathAM kathayituM prArabhata, tena janA vismayaM vijJAya kathayAmAsuH, isrAyelo vaMze kadApi nedRgadRzyata; ");
INSERT INTO sanhk_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","kintu phirUzinaH kathayAJcakruH bhUtAdhipatinA sa bhUtAn tyAjayati| ");
INSERT INTO sanhk_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","tataH paraM yIzusteSAM bhajanabhavana upadizan rAjyasya susaMvAdaM pracArayan lokAnAM yasya ya Amayo yA ca pIDAsIt, tAn zamayan zamayaMzca sarvvANi nagarANi grAmAMzca babhrAma| ");
INSERT INTO sanhk_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","anyaJca manujAn vyAkulAn arakSakameSAniva ca tyaktAn nirIkSya teSu kAruNikaH san ziSyAn avadat, ");
INSERT INTO sanhk_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","zasyAni pracurANi santi, kintu chettAraH stokAH| ");
INSERT INTO sanhk_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","kSetraM pratyaparAn chedakAn prahetuM zasyasvAminaM prArthayadhvam| ");
INSERT INTO sanhk_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","anantaraM yIzu rdvAdazaziSyAn AhUyAmedhyabhUtAn tyAjayituM sarvvaprakArarogAn pIDAzca zamayituM tebhyaH sAmarthyamadAt| ");
INSERT INTO sanhk_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","teSAM dvAdazapreSyANAM nAmAnyetAni| prathamaM zimon yaM pitaraM vadanti, tataH paraM tasya sahaja AndriyaH, sivadiyasya putro yAkUb ");
INSERT INTO sanhk_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","tasya sahajo yohan; philip barthalamay thomAH karasaMgrAhI mathiH, Alpheyaputro yAkUb, ");
INSERT INTO sanhk_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","kinAnIyaH zimon, ya ISkariyotIyayihUdAH khrISTaM parakare'rpayat| ");
INSERT INTO sanhk_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","etAn dvAdazaziSyAn yIzuH preSayan ityAjJApayat, yUyam anyadezIyAnAM padavIM zemiroNIyAnAM kimapi nagaraJca na pravizye ");
INSERT INTO sanhk_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","isrAyelgotrasya hAritA ye ye meSAsteSAmeva samIpaM yAta| ");
INSERT INTO sanhk_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","gatvA gatvA svargasya rAjatvaM savidhamabhavat, etAM kathAM pracArayata| ");
INSERT INTO sanhk_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","AmayagrastAn svasthAn kuruta, kuSThinaH pariSkuruta, mRtalokAn jIvayata, bhUtAn tyAjayata, vinA mUlyaM yUyam alabhadhvaM vinaiva mUlyaM vizrANayata| ");
INSERT INTO sanhk_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","kintu sveSAM kaTibandheSu svarNarUpyatAmrANAM kimapi na gRhlIta| ");
INSERT INTO sanhk_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","anyacca yAtrAyai celasampuTaM vA dvitIyavasanaM vA pAduke vA yaSTiH, etAn mA gRhlIta, yataH kAryyakRt bharttuM yogyo bhavati| ");
INSERT INTO sanhk_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","aparaM yUyaM yat puraM yaJca grAmaM pravizatha, tatra yo jano yogyapAtraM tamavagatya yAnakAlaM yAvat tatra tiSThata| ");
INSERT INTO sanhk_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","yadA yUyaM tadgehaM pravizatha, tadA tamAziSaM vadata| ");
INSERT INTO sanhk_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","yadi sa yogyapAtraM bhavati, tarhi tatkalyANaM tasmai bhaviSyati, nocet sAzIryuSmabhyameva bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","kintu ye janA yuSmAkamAtithyaM na vidadhati yuSmAkaM kathAJca na zRNvanti teSAM gehAt purAdvA prasthAnakAle svapadUlIH pAtayata| ");
INSERT INTO sanhk_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","yuSmAnahaM tathyaM vacmi vicAradine tatpurasya dazAtaH sidomamorApurayordazA sahyatarA bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","pazyata, vRkayUthamadhye meSaH yathAvistathA yuSmAna prahiNomi, tasmAd yUyam ahiriva satarkAH kapotAivAhiMsakA bhavata| ");
INSERT INTO sanhk_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","nRbhyaH sAvadhAnA bhavata; yatastai ryUyaM rAjasaMsadi samarpiSyadhve teSAM bhajanagehe prahAriSyadhve| ");
INSERT INTO sanhk_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","yUyaM mannAmahetoH zAstRNAM rAjJAJca samakSaM tAnanyadezinazcAdhi sAkSitvArthamAneSyadhve| ");
INSERT INTO sanhk_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","kintvitthaM samarpitA yUyaM kathaM kimuttaraM vakSyatha tatra mA cintayata, yatastadA yuSmAbhi ryad vaktavyaM tat taddaNDe yuSmanmanaH su samupasthAsyati| ");
INSERT INTO sanhk_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","yasmAt tadA yo vakSyati sa na yUyaM kintu yuSmAkamantarasthaH pitrAtmA| ");
INSERT INTO sanhk_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","sahajaH sahajaM tAtaH sutaJca mRtau samarpayiSyati, apatyAgi svasvapitroे rvipakSIbhUya tau ghAtayiSyanti| ");
INSERT INTO sanhk_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","mannamahetoH sarvve janA yuSmAn RृtIyiSyante, kintu yaH zeSaM yAvad dhairyyaM ghRtvA sthAsyati, sa trAyiSyate| ");
INSERT INTO sanhk_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","tai ryadA yUyamekapure tADiSyadhve, tadA yUyamanyapuraM palAyadhvaM yuSmAnahaM tathyaM vacmi yAvanmanujasuto naiti tAvad isrAyeldezIyasarvvanagarabhramaNaM samApayituM na zakSyatha| ");
INSERT INTO sanhk_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","guroH ziSyo na mahAn, prabhordAso na mahAn| ");
INSERT INTO sanhk_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","yadi ziSyo nijaguro rdAsazca svaprabhoH samAno bhavati tarhi tad yatheSTaM| cettairgRhapatirbhUtarAja ucyate, tarhi parivArAH kiM tathA na vakSyante? ");
INSERT INTO sanhk_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","kintu tebhyo yUyaM mA bibhIta, yato yanna prakAziSyate, tAdRk chAditaM kimapi nAsti, yacca na vyaJciSyate, tAdRg guptaM kimapi nAsti| ");
INSERT INTO sanhk_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","yadahaM yuSmAn tamasi vacmi tad yuSmAbhirdIptau kathyatAM; karNAbhyAM yat zrUyate tad gehopari pracAryyatAM| ");
INSERT INTO sanhk_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ye kAyaM hantuM zaknuvanti nAtmAnaM, tebhyo mA bhaiSTa; yaH kAyAtmAnau niraye nAzayituM, zaknoti, tato bibhIta| ");
INSERT INTO sanhk_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","dvau caTakau kimekatAmramudrayA na vikrIyete? tathApi yuSmattAtAnumatiM vinA teSAmekopi bhuvi na patati| ");
INSERT INTO sanhk_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","yuSmacchirasAM sarvvakacA gaNitAMH santi| ");
INSERT INTO sanhk_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ato mA bibhIta, yUyaM bahucaTakebhyo bahumUlyAH| ");
INSERT INTO sanhk_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","yo manujasAkSAnmAmaGgIkurute tamahaM svargasthatAtasAkSAdaGgIkariSye| ");
INSERT INTO sanhk_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","pRthvyAmahaM zAntiM dAtumAgata_iti mAnubhavata, zAntiM dAtuM na kintvasiM| ");
INSERT INTO sanhk_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","pitRmAtRzcazrUbhiH sAkaM sutasutAbadhU rvirodhayituJcAgateाsmi| ");
INSERT INTO sanhk_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","tataH svasvaparivAraeva nRzatru rbhavitA| ");
INSERT INTO sanhk_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","yaH pitari mAtari vA mattodhikaM prIyate, sa na madarhaH; ");
INSERT INTO sanhk_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","yazca sute sutAyAM vA mattodhikaM prIyate, seाpi na madarhaH| ");
INSERT INTO sanhk_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","yaH svakruzaM gRhlan matpazcAnnaiti, seाpi na madarhaH| ");
INSERT INTO sanhk_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","yaH svaprANAnavati, sa tAn hArayiSyate, yastu matkRte svaprANAn hArayati, sa tAnavati| ");
INSERT INTO sanhk_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","yo yuSmAkamAtithyaM vidadhAti, sa mamAtithyaM vidadhAti, yazca mamAtithyaM vidadhAti, sa matprerakasyAtithyaM vidadhAti| ");
INSERT INTO sanhk_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","yo bhaviSyadvAdIti jJAtvA tasyAtithyaM vidhatte, sa bhaviSyadvAdinaH phalaM lapsyate, yazca dhArmmika iti viditvA tasyAtithyaM vidhatte sa dhArmmikamAnavasya phalaM prApsyati| ");
INSERT INTO sanhk_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","yazca kazcit eteSAM kSudranarANAm yaM kaJcanaikaM ziSya iti viditvA kaMsaikaM zItalasalilaM tasmai datte, yuSmAnahaM tathyaM vadAmi, sa kenApi prakAreNa phalena na vaJciSyate| ");
INSERT INTO sanhk_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","itthaM yIzuH svadvAdazaziSyANAmAjJApanaM samApya pure pura upadeSTuM susaMvAdaM pracArayituM tatsthAnAt pratasthe| ");
INSERT INTO sanhk_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","anantaraM yohan kArAyAM tiSThan khriSTasya karmmaNAM vArttaM prApya yasyAgamanavArttAsIt saeva kiM tvaM? vA vayamanyam apekSiSyAmahe? ");
INSERT INTO sanhk_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","etat praSTuM nijau dvau ziSyau prAhiNot| ");
INSERT INTO sanhk_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","yIzuH pratyavocat, andhA netrANi labhante, khaJcA gacchanti, kuSThinaH svasthA bhavanti, badhirAH zRNvanti, mRtA jIvanta uttiSThanti, daridrANAM samIpe susaMvAdaH pracAryyata, ");
INSERT INTO sanhk_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","etAni yadyad yuvAM zRNuthaH pazyathazca gatvA tadvArttAM yohanaM gadataM| ");
INSERT INTO sanhk_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","yasyAhaM na vighnIbhavAmi, saeva dhanyaH| ");
INSERT INTO sanhk_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","anantaraM tayoH prasthitayo ryIzu ryohanam uddizya janAn jagAda, yUyaM kiM draSTuM vahirmadhyeprAntaram agacchata? kiM vAtena kampitaM nalaM? ");
INSERT INTO sanhk_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","vA kiM vIkSituM vahirgatavantaH? kiM parihitasUkSmavasanaM manujamekaM? pazyata, ye sUkSmavasanAni paridadhati, te rAjadhAnyAM tiSThanti| ");
INSERT INTO sanhk_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","tarhi yUyaM kiM draSTuM bahiragamata, kimekaM bhaviSyadvAdinaM? tadeva satyaM| yuSmAnahaM vadAmi, sa bhaviSyadvAdinopi mahAn; ");
INSERT INTO sanhk_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","yataH, pazya svakIyadUtoyaM tvadagre preSyate mayA| sa gatvA tava panthAnaM smayak pariSkariSyati|| etadvacanaM yamadhi likhitamAste so'yaM yohan| ");
INSERT INTO sanhk_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","aparaM yuSmAnahaM tathyaM bravImi, majjayitu ryohanaH zreSThaH kopi nArIto nAjAyata; tathApi svargarAjyamadhye sarvvebhyo yaH kSudraH sa yohanaH zreSThaH| ");
INSERT INTO sanhk_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","aparaJca A yohano'dya yAvat svargarAjyaM balAdAkrAntaM bhavati Akraminazca janA balena tadadhikurvvanti| ");
INSERT INTO sanhk_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","yato yohanaM yAvat sarvvabhaviSyadvAdibhi rvyavasthayA ca upadezaH prAkAzyata| ");
INSERT INTO sanhk_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","yadi yUyamidaM vAkyaM grahItuM zaknutha, tarhi zreyaH, yasyAgamanasya vacanamAste so'yam eliyaH| ");
INSERT INTO sanhk_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","yasya zrotuM karNau staH sa zRNotu| ");
INSERT INTO sanhk_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","ete vidyamAnajanAH kai rmayopamIyante? ye bAlakA haTTa upavizya svaM svaM bandhumAhUya vadanti, ");
INSERT INTO sanhk_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","vayaM yuSmAkaM samIpe vaMzIravAdayAma, kintu yUyaM nAnRtyata; yuSmAkaM samIpe ca vayamarodima, kintu yUyaM na vyalapata, tAdRzai rbAlakaista upamAyiSyante| ");
INSERT INTO sanhk_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","yato yohan Agatya na bhuktavAn na pItavAMzca, tena lokA vadanti, sa bhUtagrasta iti| ");
INSERT INTO sanhk_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","manujasuta Agatya bhuktavAn pItavAMzca, tena lokA vadanti, pazyata eSa bhoktA madyapAtA caNDAlapApinAM bandhazca, kintu jJAnino jJAnavyavahAraM nirdoSaM jAnanti| ");
INSERT INTO sanhk_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","sa yatra yatra pure bahvAzcaryyaM karmma kRtavAn, tannivAsinAM manaHparAvRttyabhAvAt tAni nagarANi prati hantetyuktA kathitavAn, ");
INSERT INTO sanhk_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","hA korAsIn, hA baitsaide, yuSmanmadhye yadyadAzcaryyaM karmma kRtaM yadi tat sorasIdonnagara akAriSyata, tarhi pUrvvameva tannivAsinaH zANavasane bhasmani copavizanto manAMsi parAvarttiSyanta| ");
INSERT INTO sanhk_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","tasmAdahaM yuSmAn vadAmi, vicAradine yuSmAkaM dazAtaH sorasIdono rdazA sahyatarA bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","aparaJca bata kapharnAhUm, tvaM svargaM yAvadunnatosi, kintu narake nikSepsyase, yasmAt tvayi yAnyAzcaryyANi karmmaNyakAriSata, yadi tAni sidomnagara akAriSyanta, tarhi tadadya yAvadasthAsyat| ");
INSERT INTO sanhk_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","kintvahaM yuSmAn vadAmi, vicAradine tava daNDataH sidomo daNDo sahyataro bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","etasminneva samaye yIzuH punaruvAca, he svargapRthivyorekAdhipate pitastvaM jJAnavato viduSazca lokAn pratyetAni na prakAzya bAlakAn prati prakAzitavAn, iti hetostvAM dhanyaM vadAmi| ");
INSERT INTO sanhk_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","he pitaH, itthaM bhavet yata idaM tvadRSTAvuttamaM| ");
INSERT INTO sanhk_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","pitrA mayi sarvvANi samarpitAni, pitaraM vinA kopi putraM na jAnAti, yAn prati putreNa pitA prakAzyate tAn vinA putrAd anyaH kopi pitaraM na jAnAti| ");
INSERT INTO sanhk_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","he parizrAntA bhArAkrAntAzca lokA yUyaM matsannidhim Agacchata, ahaM yuSmAn vizramayiSyAmi| ");
INSERT INTO sanhk_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ahaM kSamaNazIlo namramanAzca, tasmAt mama yugaM sveSAmupari dhArayata mattaH zikSadhvaJca, tena yUyaM sve sve manasi vizrAmaM lapsyadhbe| ");
INSERT INTO sanhk_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","yato mama yugam anAyAsaM mama bhArazca laghuH| ");
INSERT INTO sanhk_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","anantaraM yIzu rvizrAmavAre zsyamadhyena gacchati, tadA tacchiSyA bubhukSitAH santaH zsyamaJjarIzchatvA chitvA khAditumArabhanta| ");
INSERT INTO sanhk_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","tad vilokya phirUzino yIzuM jagaduH, pazya vizrAmavAre yat karmmAkarttavyaM tadeva tava ziSyAH kurvvanti| ");
INSERT INTO sanhk_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","sa tAn pratyAvadata, dAyUd tatsaGginazca bubhukSitAH santo yat karmmAkurvvan tat kiM yuSmAbhi rnApAThi? ");
INSERT INTO sanhk_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ye darzanIyAH pUpAH yAjakAn vinA tasya tatsaGgimanujAnAJcAbhojanIyAsta IzvarAvAsaM praviSTena tena bhuktAH| ");
INSERT INTO sanhk_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","anyacca vizrAmavAre madhyemandiraM vizrAmavArIyaM niyamaM laGvantopi yAjakA nirdoSA bhavanti, zAstramadhye kimidamapi yuSmAbhi rna paThitaM? ");
INSERT INTO sanhk_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","yuSmAnahaM vadAmi, atra sthAne mandirAdapi garIyAn eka Aste| ");
INSERT INTO sanhk_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","kintu dayAyAM me yathA prIti rna tathA yajJakarmmaNi| etadvacanasyArthaM yadi yuyam ajJAsiSTa tarhi nirdoSAn doSiNo nAkArSTa| ");
INSERT INTO sanhk_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","anyacca manujasuto vizrAmavArasyApi patirAste| ");
INSERT INTO sanhk_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","anantaraM sa tatsthAnAt prasthAya teSAM bhajanabhavanaM praviSTavAn, tadAnIm ekaH zuSkakarAmayavAn upasthitavAn| ");
INSERT INTO sanhk_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","tato yIzum apavadituM mAnuSAH papracchuH, vizrAmavAre nirAmayatvaM karaNIyaM na vA? ");
INSERT INTO sanhk_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","tena sa pratyuvAca, vizrAmavAre yadi kasyacid avi rgartte patati, tarhi yastaM ghRtvA na tolayati, etAdRzo manujo yuSmAkaM madhye ka Aste? ");
INSERT INTO sanhk_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ave rmAnavaH kiM nahi zreyAn? ato vizrAmavAre hitakarmma karttavyaM| ");
INSERT INTO sanhk_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","anantaraM sa taM mAnavaM gaditavAn, karaM prasAraya; tena kare prasArite sonyakaravat svastho'bhavat| ");
INSERT INTO sanhk_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","tadA phirUzino bahirbhUya kathaM taM haniSyAma iti kumantraNAM tatprAtikUlyena cakruH| ");
INSERT INTO sanhk_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","tato yIzustad viditvA sthanAntaraM gatavAn; anyeSu bahunareSu tatpazcAd gateSu tAn sa nirAmayAn kRtvA ityAjJApayat, ");
INSERT INTO sanhk_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","yUyaM mAM na paricAyayata| ");
INSERT INTO sanhk_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","tasmAt mama prIyo manonIto manasastuSTikArakaH| madIyaH sevako yastu vidyate taM samIkSatAM| tasyopari svakIyAtmA mayA saMsthApayiSyate| tenAnyadezajAteSu vyavasthA saMprakAzyate| ");
INSERT INTO sanhk_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","kenApi na virodhaM sa vivAdaJca kariSyati| na ca rAjapathe tena vacanaM zrAvayiSyate| ");
INSERT INTO sanhk_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","vyavasthA calitA yAvat nahi tena kariSyate| tAvat nalo vidIrNo'pi bhaMkSyate nahi tena ca| tathA sadhUmavarttiJca na sa nirvvApayiSyate| ");
INSERT INTO sanhk_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","pratyAzAJca kariSyanti tannAmni bhinnadezajAH| ");
INSERT INTO sanhk_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","yAnyetAni vacanAni yizayiyabhaviSyadvAdinA proktAnyAsan, tAni saphalAnyabhavan| ");
INSERT INTO sanhk_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","anantaraM lokai statsamIpam AnIto bhUtagrastAndhamUkaikamanujastena svasthIkRtaH, tataH so'ndho mUko draSTuM vaktuJcArabdhavAn| ");
INSERT INTO sanhk_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","anena sarvve vismitAH kathayAJcakruH, eSaH kiM dAyUdaH santAno nahi? ");
INSERT INTO sanhk_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","kintu phirUzinastat zrutvA gaditavantaH, bAlsibUbnAmno bhUtarAjasya sAhAyyaM vinA nAyaM bhUtAn tyAjayati| ");
INSERT INTO sanhk_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","tadAnIM yIzusteSAm iti mAnasaM vijJAya tAn avadat kiJcana rAjyaM yadi svavipakSAd bhidyate, tarhi tat ucchidyate; yacca kiJcana nagaraM vA gRhaM svavipakSAd vibhidyate, tat sthAtuM na zaknoti| ");
INSERT INTO sanhk_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","tadvat zayatAno yadi zayatAnaM bahiH kRtvA svavipakSAt pRthak pRthak bhavati, tarhi tasya rAjyaM kena prakAreNa sthAsyati? ");
INSERT INTO sanhk_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ahaJca yadi bAlsibUbA bhUtAn tyAjayAmi, tarhi yuSmAkaM santAnAH kena bhUtAn tyAjayanti? tasmAd yuSmAkam etadvicArayitArasta eva bhaviSyanti| ");
INSERT INTO sanhk_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","kintavahaM yadIzvarAtmanA bhUtAn tyAjayAmi, tarhIzvarasya rAjyaM yuSmAkaM sannidhimAgatavat| ");
INSERT INTO sanhk_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","anyaJca kopi balavanta janaM prathamato na badvvA kena prakAreNa tasya gRhaM pravizya taddravyAdi loThayituM zaknoti? kintu tat kRtvA tadIyagRsya dravyAdi loThayituM zaknoti| ");
INSERT INTO sanhk_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","yaH kazcit mama svapakSIyo nahi sa vipakSIya Aste, yazca mayA sAkaM na saMgRhlAti, sa vikirati| ");
INSERT INTO sanhk_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ataeva yuSmAnahaM vadAmi, manujAnAM sarvvaprakArapApAnAM nindAyAzca marSaNaM bhavituM zaknoti, kintu pavitrasyAtmano viruddhanindAyA marSaNaM bhavituM na zaknoti| ");
INSERT INTO sanhk_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","yo manujasutasya viruddhAM kathAM kathayati, tasyAparAdhasya kSamA bhavituM zaknoti, kintu yaH kazcit pavitrasyAtmano viruddhAM kathAM kathayati nehaloke na pretya tasyAparAdhasya kSamA bhavituM zaknoti| ");
INSERT INTO sanhk_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","pAdapaM yadi bhadraM vadatha, tarhi tasya phalamapi sAdhu vaktavyaM, yadi ca pAdapaM asAdhuM vadatha, tarhi tasya phalamapyasAdhu vaktavyaM; yataH svIyasvIyaphalena pAdapaH paricIyate| ");
INSERT INTO sanhk_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","re bhujagavaMzA yUyamasAdhavaH santaH kathaM sAdhu vAkyaM vaktuM zakSyatha? yasmAd antaHkaraNasya pUrNabhAvAnusArAd vadanAd vaco nirgacchati| ");
INSERT INTO sanhk_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","tena sAdhurmAnavo'ntaHkaraNarUpAt sAdhubhANDAgArAt sAdhu dravyaM nirgamayati, asAdhurmAnuSastvasAdhubhANDAgArAd asAdhuvastUni nirgamayati| ");
INSERT INTO sanhk_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","kintvahaM yuSmAn vadAmi, manujA yAvantyAlasyavacAMsi vadanti, vicAradine taduttaramavazyaM dAtavyaM, ");
INSERT INTO sanhk_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","yatastvaM svIyavacobhi rniraparAdhaH svIyavacobhizca sAparAdho gaNiSyase| ");
INSERT INTO sanhk_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","tadAnIM katipayA upAdhyAyAH phirUzinazca jagaduH, he guro vayaM bhavattaH kiJcana lakSma didRkSAmaH| ");
INSERT INTO sanhk_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","tadA sa pratyuktavAn, duSTo vyabhicArI ca vaMzo lakSma mRgayate, kintu bhaviSyadvAdino yUnaso lakSma vihAyAnyat kimapi lakSma te na pradarzayiSyante| ");
INSERT INTO sanhk_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","yato yUnam yathA tryahorAtraM bRhanmInasya kukSAvAsIt, tathA manujaputropi tryahorAtraM medinyA madhye sthAsyati| ");
INSERT INTO sanhk_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","aparaM nInivIyA mAnavA vicAradina etadvaMzIyAnAM pratikUlam utthAya tAn doSiNaH kariSyanti, yasmAtte yUnasa upadezAt manAMsi parAvarttayAJcakrire, kintvatra yUnasopi gurutara eka Aste| ");
INSERT INTO sanhk_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","punazca dakSiNadezIyA rAjJI vicAradina etadvaMzIyAnAM pratikUlamutthAya tAn doSiNaH kariSyati yataH sA rAjJI sulemano vidyAyAH kathAM zrotuM medinyAH sImna Agacchat, kintu sulemanopi gurutara eko jano'tra Aste| ");
INSERT INTO sanhk_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","aparaM manujAd bahirgato 'pavitrabhUtaH zuSkasthAnena gatvA vizrAmaM gaveSayati, kintu tadalabhamAnaH sa vakti, yasmA; niketanAd AgamaM, tadeva vezma pakAvRtya yAmi| ");
INSERT INTO sanhk_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","pazcAt sa tat sthAnam upasthAya tat zUnyaM mArjjitaM zobhitaJca vilokya vrajan svatopi duSTatarAn anyasaptabhUtAn saGginaH karoti| ");
INSERT INTO sanhk_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","tataste tat sthAnaM pravizya nivasanti, tena tasya manujasya zeSadazA pUrvvadazAtotIvAzubhA bhavati, eteSAM duSTavaMzyAnAmapi tathaiva ghaTiSyate| ");
INSERT INTO sanhk_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","mAnavebhya etAsAM kathanAM kathanakAle tasya mAtA sahajAzca tena sAkaM kAJcit kathAM kathayituM vAJchanto bahireva sthitavantaH| ");
INSERT INTO sanhk_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","tataH kazcit tasmai kathitavAn, pazya tava jananI sahajAzca tvayA sAkaM kAJcana kathAM kathayituM kAmayamAnA bahistiSThanti| ");
INSERT INTO sanhk_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","kintu sa taM pratyavadat, mama kA jananI? ke vA mama sahajAH? ");
INSERT INTO sanhk_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","pazcAt ziSyAn prati karaM prasAryya kathitavAn, pazya mama jananI mama sahajAzcaite; ");
INSERT INTO sanhk_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","yaH kazcit mama svargasthasya pituriSTaM karmma kurute, saeva mama bhrAtA bhaginI jananI ca| ");
INSERT INTO sanhk_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","aparaJca tasmin dine yIzuH sadmano gatvA saritpate rodhasi samupaviveza| ");
INSERT INTO sanhk_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","tatra tatsannidhau bahujanAnAM nivahopasthiteH sa taraNimAruhya samupAvizat, tena mAnavA rodhasi sthitavantaH| ");
INSERT INTO sanhk_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","tadAnIM sa dRSTAntaistAn itthaM bahuza upadiSTavAn| pazyata, kazcit kRSIvalo bIjAni vaptuM bahirjagAma, ");
INSERT INTO sanhk_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","tasya vapanakAle katipayabIjeSu mArgapArzve patiteSu vihagAstAni bhakSitavantaH| ");
INSERT INTO sanhk_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","aparaM katipayabIjeSu stokamRdyuktapASANe patiteSu mRdalpatvAt tatkSaNAt tAnyaGkuritAni, ");
INSERT INTO sanhk_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","kintu ravAvudite dagdhAni teSAM mUlApraviSTatvAt zuSkatAM gatAni ca| ");
INSERT INTO sanhk_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","aparaM katipayabIjeSu kaNTakAnAM madhye patiteSu kaNTakAnyedhitvA tAni jagrasuH| ");
INSERT INTO sanhk_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","aparaJca katipayabIjAni urvvarAyAM patitAni; teSAM madhye kAnicit zataguNAni kAnicit SaSTiguNAni kAnicit triMzaguMNAni phalAni phalitavanti| ");
INSERT INTO sanhk_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","zrotuM yasya zrutI AsAte sa zRNuyAt| ");
INSERT INTO sanhk_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","anantaraM ziSyairAgatya so'pRcchyata, bhavatA tebhyaH kuto dRSTAntakathA kathyate? ");
INSERT INTO sanhk_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","tataH sa pratyavadat, svargarAjyasya nigUDhAM kathAM vedituM yuSmabhyaM sAmarthyamadAyi, kintu tebhyo nAdAyi| ");
INSERT INTO sanhk_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","yasmAd yasyAntike varddhate, tasmAyeva dAyiSyate, tasmAt tasya bAhulyaM bhaviSyati, kintu yasyAntike na varddhate, tasya yat kiJcanAste, tadapi tasmAd AdAyiSyate| ");
INSERT INTO sanhk_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","te pazyantopi na pazyanti, zRNvantopi na zRNvanti, budhyamAnA api na budhyante ca, tasmAt tebhyo dRSTAntakathA kathyate| ");
INSERT INTO sanhk_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","yathA karNaiH zroSyatha yUyaM vai kintu yUyaM na bhotsyatha| netrairdrakSyatha yUyaJca parijJAtuM na zakSyatha| te mAnuSA yathA naiva paripazyanti locanaiH| karNai ryathA na zRNvanti na budhyante ca mAnasaiH| vyAvarttiteSu citteSu kAle kutrApi tairjanaiH| mattaste manujAH svasthA yathA naiva bhavanti ca| tathA teSAM manuSyANAM kriyante sthUlabuddhayaH| badhirIbhUtakarNAzca jAtAzca mudritA dRzaH| ");
INSERT INTO sanhk_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","yadetAni vacanAni yizayiyabhaviSyadvAdinA proktAni teSu tAni phalanti| ");
INSERT INTO sanhk_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","kintu yuSmAkaM nayanAni dhanyAni, yasmAt tAni vIkSante; dhanyAzca yuSmAkaM zabdagrahAH, yasmAt tairAkarNyate| ");
INSERT INTO sanhk_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","mayA yUyaM tathyaM vacAmi yuSmAbhi ryadyad vIkSyate, tad bahavo bhaviSyadvAdino dhArmmikAzca mAnavA didRkSantopi draSTuM nAlabhanta, punazca yUyaM yadyat zRNutha, tat te zuzrUSamANA api zrotuM nAlabhanta| ");
INSERT INTO sanhk_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","kRSIvalIyadRSTAntasyArthaM zRNuta| ");
INSERT INTO sanhk_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","mArgapArzve bIjAnyuptAni tasyArtha eSaH, yadA kazcit rAjyasya kathAM nizamya na budhyate, tadA pApAtmAgatya tadIyamanasa uptAM kathAM haran nayati| ");
INSERT INTO sanhk_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","aparaM pASANasthale bIjAnyuptAni tasyArtha eSaH; kazcit kathAM zrutvaiva harSacittena gRhlAti, ");
INSERT INTO sanhk_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","kintu tasya manasi mUlApraviSTatvAt sa kiJcitkAlamAtraM sthirastiSThati; pazcAta tatkathAkAraNAt kopi klestADanA vA cet jAyate, tarhi sa tatkSaNAd vighnameti| ");
INSERT INTO sanhk_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","aparaM kaNTakAnAM madhye bIjAnyuptAni tadartha eSaH; kenacit kathAyAM zrutAyAM sAMsArikacintAbhi rbhrAntibhizca sA grasyate, tena sA mA viphalA bhavati| ");
INSERT INTO sanhk_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","aparam urvvarAyAM bIjAnyuptAni tadartha eSaH; ye tAM kathAM zrutvA vudhyante, te phalitAH santaH kecit zataguNAni kecita SaSTiguNAni kecicca triMzadguNAni phalAni janayanti| ");
INSERT INTO sanhk_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","anantaraM soparAmekAM dRSTAntakathAmupasthApya tebhyaH kathayAmAsa; svargIyarAjyaM tAdRzena kenacid gRhasthenopamIyate, yena svIyakSetre prazastabIjAnyaupyanta| ");
INSERT INTO sanhk_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","kintu kSaNadAyAM sakalalokeSu supteSu tasya ripurAgatya teSAM godhUmabIjAnAM madhye vanyayavamabIjAnyuptvA vavrAja| ");
INSERT INTO sanhk_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","tato yadA bIjebhyo'GkarA jAyamAnAH kaNizAni ghRtavantaH; tadA vanyayavasAnyapi dRzyamAnAnyabhavan| ");
INSERT INTO sanhk_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","tato gRhasthasya dAseyA Agamya tasmai kathayAJcakruH, he maheccha, bhavatA kiM kSetre bhadrabIjAni naupyanta? tathAtve vanyayavasAni kRta Ayan? ");
INSERT INTO sanhk_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","tadAnIM tena te pratigaditAH, kenacit ripuNA karmmadamakAri| dAseyAH kathayAmAsuH, vayaM gatvA tAnyutpAyya kSipAmo bhavataH kIdRzIcchA jAyate? ");
INSERT INTO sanhk_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","tenAvAdi, nahi, zaGke'haM vanyayavasotpATanakAle yuSmAbhistaiH sAkaM godhUmA apyutpATiSyante| ");
INSERT INTO sanhk_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ataH zsyakarttanakAlaM yAvad ubhayAnyapi saha varddhantAM, pazcAt karttanakAle karttakAn vakSyAmi, yUyamAdau vanyayavasAni saMgRhya dAhayituM vITikA badvvA sthApayata; kintu sarvve godhUmA yuSmAbhi rbhANDAgAraM nItvA sthApyantAm| ");
INSERT INTO sanhk_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","anantaraM soparAmekAM dRSTAntakathAmutthApya tebhyaH kathitavAn kazcinmanujaH sarSapabIjamekaM nItvA svakSetra uvApa| ");
INSERT INTO sanhk_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","sarSapabIjaM sarvvasmAd bIjAt kSudramapi sadaGkuritaM sarvvasmAt zAkAt bRhad bhavati; sa tAdRzastaru rbhavati, yasya zAkhAsu nabhasaH khagA Agatya nivasanti; svargIyarAjyaM tAdRzasya sarSapaikasya samam| ");
INSERT INTO sanhk_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","punarapi sa upamAkathAmekAM tebhyaH kathayAJcakAra; kAcana yoSit yat kiNvamAdAya droNatrayamitagodhUmacUrNAnAM madhye sarvveSAM mizrIbhavanaparyyantaM samAcchAdya nidhattavatI, tatkiNvamiva svargarAjyaM| ");
INSERT INTO sanhk_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","itthaM yIzu rmanujanivahAnAM sannidhAvupamAkathAbhiretAnyAkhyAnAni kathitavAn upamAM vinA tebhyaH kimapi kathAM nAkathayat| ");
INSERT INTO sanhk_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","etena dRSTAntIyena vAkyena vyAdAya vadanaM nijaM| ahaM prakAzayiSyAmi guptavAkyaM purAbhavaM| yadetadvacanaM bhaviSyadvAdinA proktamAsIt, tat siddhamabhavat| ");
INSERT INTO sanhk_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","sarvvAn manujAn visRjya yIzau gRhaM praviSTe tacchiSyA Agatya yIzave kathitavantaH, kSetrasya vanyayavasIyadRSTAntakathAm bhavAna asmAn spaSTIkRtya vadatu| ");
INSERT INTO sanhk_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","tataH sa pratyuvAca, yena bhadrabIjAnyupyante sa manujaputraH, ");
INSERT INTO sanhk_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","kSetraM jagat, bhadrabIjAnI rAjyasya santAnAH, ");
INSERT INTO sanhk_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","vanyayavasAni pApAtmanaH santAnAH| yena ripuNA tAnyuptAni sa zayatAnaH, karttanasamayazca jagataH zeSaH, karttakAH svargIyadUtAH| ");
INSERT INTO sanhk_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","yathA vanyayavasAni saMgRhya dAhyante, tathA jagataH zeSe bhaviSyati; ");
INSERT INTO sanhk_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","arthAt manujasutaH svAMyadUtAn preSayiSyati, tena te ca tasya rAjyAt sarvvAn vighnakAriNo'dhArmmikalokAMzca saMgRhya ");
INSERT INTO sanhk_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","yatra rodanaM dantagharSaNaJca bhavati, tatrAgnikuNDe nikSepsyanti| ");
INSERT INTO sanhk_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","tadAnIM dhArmmikalokAH sveSAM pitU rAjye bhAskara_iva tejasvino bhaviSyanti| zrotuM yasya zrutI AsAte, ma zRNuyAt| ");
INSERT INTO sanhk_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","aparaJca kSetramadhye nidhiM pazyan yo gopayati, tataH paraM sAnando gatvA svIyasarvvasvaM vikrIya ttakSetraM krINAti, sa iva svargarAjyaM| ");
INSERT INTO sanhk_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","anyaJca yo vaNik uttamAM muktAM gaveSayan ");
INSERT INTO sanhk_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","mahArghAM muktAM vilokya nijasarvvasvaM vikrIya tAM krINAti, sa iva svargarAjyaM| ");
INSERT INTO sanhk_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","punazca samudro nikSiptaH sarvvaprakAramInasaMgrAhyAnAya_iva svargarAjyaM| ");
INSERT INTO sanhk_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","tasmin AnAye pUrNe janA yathA rodhasyuttolya samupavizya prazastamInAn saMgrahya bhAjaneSu nidadhate, kutsitAn nikSipanti; ");
INSERT INTO sanhk_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","tathaiva jagataH zeSe bhaviSyati, phalataH svargIyadUtA Agatya puNyavajjanAnAM madhyAt pApinaH pRthak kRtvA vahnikuNDe nikSepsyanti, ");
INSERT INTO sanhk_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","tatra rodanaM dantai rdantagharSaNaJca bhaviSyataH| ");
INSERT INTO sanhk_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","yIzunA te pRSTA yuSmAbhiH kimetAnyAkhyAnAnyabudhyanta? tadA te pratyavadan, satyaM prabho| ");
INSERT INTO sanhk_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","tadAnIM sa kathitavAn, nijabhANDAgArAt navInapurAtanAni vastUni nirgamayati yo gRhasthaH sa iva svargarAjyamadhi zikSitAH svarva upadeSTAraH| ");
INSERT INTO sanhk_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","anantaraM yIzuretAH sarvvA dRSTAntakathAH samApya tasmAt sthAnAt pratasthe| aparaM svadezamAgatya janAn bhajanabhavana upadiSTavAn; ");
INSERT INTO sanhk_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","te vismayaM gatvA kathitavanta etasyaitAdRzaM jJAnam AzcaryyaM karmma ca kasmAd ajAyata? ");
INSERT INTO sanhk_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","kimayaM sUtradhArasya putro nahi? etasya mAtu rnAma ca kiM mariyam nahi? yAkub-yUSaph-zimon-yihUdAzca kimetasya bhrAtaro nahi? ");
INSERT INTO sanhk_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","etasya bhaginyazca kimasmAkaM madhye na santi? tarhi kasmAdayametAni labdhavAn? itthaM sa teSAM vighnarUpo babhUva; ");
INSERT INTO sanhk_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","tato yIzunA nigaditaM svadezIyajanAnAM madhyaM vinA bhaviSyadvAdI kutrApyanyatra nAsammAnyo bhavatI| ");
INSERT INTO sanhk_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","teSAmavizvAsahetoH sa tatra sthAne bahvAzcaryyakarmmANi na kRtavAn| ");
INSERT INTO sanhk_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","tadAnIM rAjA herod yIzo ryazaH zrutvA nijadAseyAn jagAd, ");
INSERT INTO sanhk_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","eSa majjayitA yohan, pramitebhayastasyotthAnAt tenetthamadbhutaM karmma prakAzyate| ");
INSERT INTO sanhk_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","purA herod nijabhrAtu: philipo jAyAyA herodIyAyA anurodhAd yohanaM dhArayitvA baddhA kArAyAM sthApitavAn| ");
INSERT INTO sanhk_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","yato yohan uktavAn, etsayAH saMgraho bhavato nocitaH| ");
INSERT INTO sanhk_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","tasmAt nRpatistaM hantumicchannapi lokebhyo vibhayAJcakAra; yataH sarvve yohanaM bhaviSyadvAdinaM menire| ");
INSERT INTO sanhk_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","kintu herodo janmAhIyamaha upasthite herodIyAyA duhitA teSAM samakSaM nRtitvA herodamaprINyat| ");
INSERT INTO sanhk_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","tasmAt bhUpatiH zapathaM kurvvan iti pratyajJAsIt, tvayA yad yAcyate, tadevAhaM dAsyAmi| ");
INSERT INTO sanhk_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","sA kumArI svIyamAtuH zikSAM labdhA babhASe, majjayituryohana uttamAGgaM bhAjane samAnIya mahyaM vizrANaya| ");
INSERT INTO sanhk_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","tato rAjA zuzoca, kintu bhojanAyopavizatAM saGginAM svakRtazapathasya cAnurodhAt tat pradAtuma Adideza| ");
INSERT INTO sanhk_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","pazcAt kArAM prati naraM prahitya yohana uttamAGgaM chittvA ");
INSERT INTO sanhk_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","tat bhAjana AnAyya tasyai kumAryyai vyazrANayat, tataH sA svajananyAH samIpaM tanninAya| ");
INSERT INTO sanhk_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","pazcAt yohanaH ziSyA Agatya kAyaM nItvA zmazAne sthApayAmAsustato yIzoH sannidhiM vrajitvA tadvArttAM babhASire| ");
INSERT INTO sanhk_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","anantaraM yIzuriti nizabhya nAvA nirjanasthAnam ekAkI gatavAn, pazcAt mAnavAstat zrutvA nAnAnagarebhya Agatya padaistatpazcAd IyuH| ");
INSERT INTO sanhk_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","tadAnIM yIzu rbahirAgatya mahAntaM jananivahaM nirIkSya teSu kAruNikaH man teSAM pIDitajanAn nirAmayAn cakAra| ");
INSERT INTO sanhk_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","tataH paraM sandhyAyAM ziSyAstadantikamAgatya kathayAJcakruH, idaM nirjanasthAnaM velApyavasannA; tasmAt manujAn svasvagrAmaM gantuM svArthaM bhakSyANi kretuJca bhavAn tAn visRjatu| ");
INSERT INTO sanhk_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","kintu yIzustAnavAdIt, teSAM gamane prayojanaM nAsti, yUyameva tAn bhojayata| ");
INSERT INTO sanhk_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","tadA te pratyavadan, asmAkamatra pUpapaJcakaM mInadvayaJcAste| ");
INSERT INTO sanhk_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","tadAnIM tenoktaM tAni madantikamAnayata| ");
INSERT INTO sanhk_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","anantaraM sa manujAn yavasoparyyupaveSTum AjJApayAmAsa; apara tat pUpapaJcakaM mInadvayaJca gRhlan svargaM prati nirIkSyezvarIyaguNAn anUdya bhaMktvA ziSyebhyo dattavAn, ziSyAzca lokebhyo daduH| ");
INSERT INTO sanhk_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","tataH sarvve bhuktvA paritRptavantaH, tatastadavaziSTabhakSyaiH pUrNAn dvAdazaDalakAn gRhItavantaH| ");
INSERT INTO sanhk_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","te bhoktAraH strIrbAlakAMzca vihAya prAyeNa paJca sahasrANi pumAMsa Asan| ");
INSERT INTO sanhk_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","tadanantaraM yIzu rlokAnAM visarjanakAle ziSyAn taraNimAroDhuM svAgre pAraM yAtuJca gADhamAdiSTavAn| ");
INSERT INTO sanhk_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","tato lokeSu visRSTeSu sa vivikte prArthayituM girimekaM gatvA sandhyAM yAvat tatraikAkI sthitavAn| ");
INSERT INTO sanhk_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","kintu tadAnIM sammukhavAtatvAt saritpate rmadhye taraGgaistaraNirdolAyamAnAbhavat| ");
INSERT INTO sanhk_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","tadA sa yAminyAzcaturthaprahare padbhyAM vrajan teSAmantikaM gatavAn| ");
INSERT INTO sanhk_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","kintu ziSyAstaM sAgaropari vrajantaM vilokya samudvignA jagaduH, eSa bhUta iti zaGkamAnA uccaiH zabdAyAJcakrire ca| ");
INSERT INTO sanhk_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","tadaiva yIzustAnavadat, susthirA bhavata, mA bhaiSTa, eSo'ham| ");
INSERT INTO sanhk_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","tataH pitara ityuktavAn, he prabho, yadi bhavAneva, tarhi mAM bhavatsamIpaM yAtumAjJApayatu| ");
INSERT INTO sanhk_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","tataH tenAdiSTaH pitarastaraNito'varuhya yIzeाrantikaM prAptuM toyopari vavrAja| ");
INSERT INTO sanhk_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","kintu pracaNDaM pavanaM vilokya bhayAt toye maMktum Arebhe, tasmAd uccaiH zabdAyamAnaH kathitavAn, he prabho, mAmavatu| ");
INSERT INTO sanhk_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","yIzustatkSaNAt karaM prasAryya taM dharan uktavAn, ha stokapratyayin tvaM kutaH samazethAH? ");
INSERT INTO sanhk_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","anantaraM tayostaraNimArUDhayoH pavano nivavRte| ");
INSERT INTO sanhk_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","tadAnIM ye taraNyAmAsan, ta Agatya taM praNabhya kathitavantaH, yathArthastvamevezvarasutaH| ");
INSERT INTO sanhk_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","anantaraM pAraM prApya te gineSarannAmakaM nagaramupatasthuH, ");
INSERT INTO sanhk_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","tadA tatratyA janA yIzuM paricIya taddezsya caturdizo vArttAM prahitya yatra yAvantaH pIDitA Asan, tAvataeva tadantikamAnayAmAsuH| ");
INSERT INTO sanhk_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","aparaM tadIyavasanasya granthimAtraM spraSTuM vinIya yAvanto janAstat sparzaM cakrire, te sarvvaeva nirAmayA babhUvuH| ");
INSERT INTO sanhk_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","aparaM yirUzAlamnagarIyAH katipayA adhyApakAH phirUzinazca yIzoH samIpamAgatya kathayAmAsuH, ");
INSERT INTO sanhk_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","tava ziSyAH kimartham aprakSAlitakarai rbhakSitvA paramparAgataM prAcInAnAM vyavahAraM laGvante? ");
INSERT INTO sanhk_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","tato yIzuH pratyuvAca, yUyaM paramparAgatAcAreNa kuta IzvarAjJAM laGvadhve| ");
INSERT INTO sanhk_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Izvara ityAjJApayat, tvaM nijapitarau saMmanyethAH, yena ca nijapitarau nindyete, sa nizcitaM mriyeta; ");
INSERT INTO sanhk_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","kintu yUyaM vadatha, yaH svajanakaM svajananIM vA vAkyamidaM vadati, yuvAM matto yallabhethe, tat nyavidyata, ");
INSERT INTO sanhk_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","sa nijapitarau puna rna saMmaMsyate| itthaM yUyaM paramparAgatena sveSAmAcAreNezvarIyAjJAM lumpatha| ");
INSERT INTO sanhk_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","re kapaTinaH sarvve yizayiyo yuSmAnadhi bhaviSyadvacanAnyetAni samyag uktavAn| ");
INSERT INTO sanhk_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","vadanai rmanujA ete samAyAnti madantikaM| tathAdharai rmadIyaJca mAnaM kurvvanti te narAH| ");
INSERT INTO sanhk_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","kintu teSAM mano matto vidUraeva tiSThati| zikSayanto vidhIn nrAjJA bhajante mAM mudhaiva te| ");
INSERT INTO sanhk_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","tato yIzu rlokAn AhUya proktavAn, yUyaM zrutvA budhyadhbaM| ");
INSERT INTO sanhk_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","yanmukhaM pravizati, tat manujam amedhyaM na karoti, kintu yadAsyAt nirgacchati, tadeva mAnuSamamedhyI karotI| ");
INSERT INTO sanhk_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","tadAnIM ziSyA Agatya tasmai kathayAJcakruH, etAM kathAM zrutvA phirUzino vyarajyanta, tat kiM bhavatA jJAyate? ");
INSERT INTO sanhk_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","sa pratyavadat, mama svargasthaH pitA yaM kaJcidaGkuraM nAropayat, sa utpAvdyate| ");
INSERT INTO sanhk_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","te tiSThantu, te andhamanujAnAm andhamArgadarzakA eva; yadyandho'ndhaM panthAnaM darzayati, tarhyubhau gartte patataH| ");
INSERT INTO sanhk_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","tadA pitarastaM pratyavadat, dRSTAntamimamasmAn bodhayatu| ");
INSERT INTO sanhk_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","yIzunA proktaM, yUyamadya yAvat kimabodhAH stha? ");
INSERT INTO sanhk_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","kathAmimAM kiM na budhyadhbe ? yadAsyaM previzati, tad udare patan bahirniryAti, ");
INSERT INTO sanhk_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","kintvAsyAd yanniryAti, tad antaHkaraNAt niryAtatvAt manujamamedhyaM karoti| ");
INSERT INTO sanhk_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","yato'ntaHkaraNAt kucintA badhaH pAradArikatA vezyAgamanaM cairyyaM mithyAsAkSyam IzvaranindA caitAni sarvvANi niryyAnti| ");
INSERT INTO sanhk_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","etAni manuSyamapavitrI kurvvanti kintvaprakSAlitakareNa bhojanaM manujamamedhyaM na karoti| ");
INSERT INTO sanhk_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","anantaraM yIzustasmAt sthAnAt prasthAya sorasIdonnagarayoH sImAmupatasyau| ");
INSERT INTO sanhk_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","tadA tatsImAtaH kAcit kinAnIyA yoSid Agatya tamuccairuvAca, he prabho dAyUdaH santAna, mamaikA duhitAste sA bhUtagrastA satI mahAklezaM prApnoti mama dayasva| ");
INSERT INTO sanhk_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","kintu yIzustAM kimapi noktavAn, tataH ziSyA Agatya taM nivedayAmAsuH, eSA yoSid asmAkaM pazcAd uccairAhUyAgacchati, enAM visRjatu| ");
INSERT INTO sanhk_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","tadA sa pratyavadat, isrAyelgotrasya hAritameSAn vinA kasyApyanyasya samIpaM nAhaM preSitosmi| ");
INSERT INTO sanhk_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","tataH sA nArIsamAgatya taM praNamya jagAda, he prabho mAmupakuru| ");
INSERT INTO sanhk_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","sa uktavAn, bAlakAnAM bhakSyamAdAya sArameyebhyo dAnaM nocitaM| ");
INSERT INTO sanhk_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","tadA sA babhASe, he prabho, tat satyaM, tathApi prabho rbhaJcAd yaducchiSTaM patati, tat sArameyAH khAdanti| ");
INSERT INTO sanhk_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","tato yIzuH pratyavadat, he yoSit, tava vizvAso mahAn tasmAt tava manobhilaSitaM sidyyatu, tena tasyAH kanyA tasminneva daNDe nirAmayAbhavat| ");
INSERT INTO sanhk_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","anantaraM yIzastasmAt sthAnAt prasthAya gAlIlsAgarasya sannidhimAgatya dharAdharamAruhya tatropaviveza| ");
INSERT INTO sanhk_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","pazcAt jananivaho bahUn khaJcAndhamUkazuSkakaramAnuSAn AdAya yIzoH samIpamAgatya taccaraNAntike sthApayAmAsuH, tataH sA tAn nirAmayAn akarot| ");
INSERT INTO sanhk_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","itthaM mUkA vAkyaM vadanti, zuSkakarAH svAsthyamAyAnti, paGgavo gacchanti, andhA vIkSante, iti vilokya lokA vismayaM manyamAnA isrAyela IzvaraM dhanyaM babhASire| ");
INSERT INTO sanhk_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","tadAnIM yIzuH svaziSyAn AhUya gaditavAn, etajjananivaheSu mama dayA jAyate, ete dinatrayaM mayA sAkaM santi, eSAM bhakSyavastu ca kaJcidapi nAsti, tasmAdahametAnakRtAhArAn na visrakSyAmi, tathAtve vartmamadhye klAmyeSuH| ");
INSERT INTO sanhk_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","tadA ziSyA UcuH, etasmin prAntaramadhya etAvato martyAn tarpayituM vayaM kutra pUpAn prApsyAmaH? ");
INSERT INTO sanhk_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","yIzurapRcchat, yuSmAkaM nikaTe kati pUpA Asate? ta UcuH, saptapUpA alpAH kSudramInAzca santi| ");
INSERT INTO sanhk_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","tadAnIM sa lokanivahaM bhUmAvupaveSTum Adizya ");
INSERT INTO sanhk_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","tAn saptapUpAn mInAMzca gRhlan IzvarIyaguNAn anUdya bhaMktvA ziSyebhyo dadau, ziSyA lokebhyo daduH| ");
INSERT INTO sanhk_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","tataH sarvve bhuktvA tRptavantaH; tadavaziSTabhakSyeNa saptaDalakAn paripUryya saMjagRhuH| ");
INSERT INTO sanhk_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","te bhoktAro yoSito bAlakAMzca vihAya prAyeNa catuHsahasrANi puruSA Asan| ");
INSERT INTO sanhk_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","tataH paraM sa jananivahaM visRjya tarimAruhya magdalApradezaM gatavAn| ");
INSERT INTO sanhk_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","tadAnIM phirUzinaH sidUkinazcAgatya taM parIkSituM nabhamIyaM kiJcana lakSma darzayituM tasmai nivedayAmAsuH| ");
INSERT INTO sanhk_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","tataH sa uktavAn, sandhyAyAM nabhaso raktatvAd yUyaM vadatha, zvo nirmmalaM dinaM bhaviSyati; ");
INSERT INTO sanhk_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","prAtaHkAle ca nabhaso raktatvAt malinatvAJca vadatha, jhaJbhzadya bhaviSyati| he kapaTino yadi yUyam antarIkSasya lakSma boddhuM zaknutha, tarhi kAlasyaitasya lakSma kathaM boddhuM na zaknutha? ");
INSERT INTO sanhk_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","etatkAlasya duSTo vyabhicArI ca vaMzo lakSma gaveSayati, kintu yUnaso bhaviSyadvAdino lakSma vinAnyat kimapi lakSma tAn na darzayiyyate| tadAnIM sa tAn vihAya pratasthe| ");
INSERT INTO sanhk_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","anantaramanyapAragamanakAle tasya ziSyAH pUpamAnetuM vismRtavantaH| ");
INSERT INTO sanhk_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","yIzustAnavAdIt, yUyaM phirUzinAM sidUkinAJca kiNvaM prati sAvadhAnAH satarkAzca bhavata| ");
INSERT INTO sanhk_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","tena te parasparaM vivicya kathayitumArebhire, vayaM pUpAnAnetuM vismRtavanta etatkAraNAd iti kathayati| ");
INSERT INTO sanhk_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","kintu yIzustadvijJAya tAnavocat, he stokavizvAsino yUyaM pUpAnAnayanamadhi kutaH parasparametad viviMkya? ");
INSERT INTO sanhk_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","yuSmAbhiH kimadyApi na jJAyate? paJcabhiH pUpaiH paJcasahasrapuruSeSu bhojiteSu bhakSyocchiSTapUrNAn kati DalakAn samagRhlItaM; ");
INSERT INTO sanhk_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","tathA saptabhiH pUpaizcatuHsahasrapuruSeSu bhejiteSu kati DalakAn samagRhlIta, tat kiM yuSmAbhirna smaryyate? ");
INSERT INTO sanhk_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","tasmAt phirUzinAM sidUkinAJca kiNvaM prati sAvadhAnAstiSThata, kathAmimAm ahaM pUpAnadhi nAkathayaM, etad yUyaM kuto na budhyadhve? ");
INSERT INTO sanhk_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","tadAnIM pUpakiNvaM prati sAvadhAnAstiSThateti noktvA phirUzinAM sidUkinAJca upadezaM prati sAvadhAnAstiSThateti kathitavAn, iti tairabodhi| ");
INSERT INTO sanhk_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","aparaJca yIzuH kaisariyA-philipipradezamAgatya ziSyAn apRcchat, yo'haM manujasutaH so'haM kaH? lokairahaM kimucye? ");
INSERT INTO sanhk_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","tadAnIM te kathitavantaH, kecid vadanti tvaM majjayitA yohan, kecidvadanti, tvam eliyaH, kecicca vadanti, tvaM yirimiyo vA kazcid bhaviSyadvAdIti| ");
INSERT INTO sanhk_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","pazcAt sa tAn papraccha, yUyaM mAM kaM vadatha? tataH zimon pitara uvAca, ");
INSERT INTO sanhk_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","tvamamarezvarasyAbhiSiktaputraH| ");
INSERT INTO sanhk_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","tato yIzuH kathitavAn, he yUnasaH putra zimon tvaM dhanyaH; yataH kopi anujastvayyetajjJAnaM nodapAdayat, kintu mama svargasyaH pitodapAdayat| ");
INSERT INTO sanhk_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","ato'haM tvAM vadAmi, tvaM pitaraH (prastaraH) ahaJca tasya prastarasyopari svamaNDalIM nirmmAsyAmi, tena nirayo balAt tAM parAjetuM na zakSyati| ");
INSERT INTO sanhk_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","ahaM tubhyaM svargIyarAjyasya kuJjikAM dAsyAmi, tena yat kiJcana tvaM pRthivyAM bhaMtsyasi tatsvarge bhaMtsyate, yacca kiJcana mahyAM mokSyasi tat svarge mokSyate| ");
INSERT INTO sanhk_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","pazcAt sa ziSyAnAdizat, ahamabhiSikto yIzuriti kathAM kasmaicidapi yUyaM mA kathayata| ");
INSERT INTO sanhk_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","anyaJca yirUzAlamnagaraM gatvA prAcInalokebhyaH pradhAnayAjakebhya upAdhyAyebhyazca bahuduHkhabhogastai rhatatvaM tRtIyadine punarutthAnaJca mamAvazyakam etAH kathA yIzustatkAlamArabhya ziSyAn jJApayitum ArabdhavAn| ");
INSERT INTO sanhk_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","tadAnIM pitarastasya karaM ghRtvA tarjayitvA kathayitumArabdhavAn, he prabho, tat tvatto dUraM yAtu, tvAM prati kadApi na ghaTiSyate| ");
INSERT INTO sanhk_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","kintu sa vadanaM parAvartya pitaraM jagAda, he vighnakArin, matsammukhAd dUrIbhava, tvaM mAM bAdhase, IzvarIyakAryyAt mAnuSIyakAryyaM tubhyaM rocate| ");
INSERT INTO sanhk_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","anantaraM yIzuH svIyaziSyAn uktavAn yaH kazcit mama pazcAdgAmI bhavitum icchati, sa svaM dAmyatu, tathA svakruzaM gRhlan matpazcAdAyAtu| ");
INSERT INTO sanhk_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","yato yaH prANAn rakSitumicchati, sa tAn hArayiSyati, kintu yo madarthaM nijaprANAn hArayati, sa tAn prApsyati| ");
INSERT INTO sanhk_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","mAnuSo yadi sarvvaM jagat labhate nijapraNAn hArayati, tarhi tasya ko lAbhaH? manujo nijaprANAnAM vinimayena vA kiM dAtuM zaknoti? ");
INSERT INTO sanhk_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","manujasutaH svadUtaiH sAkaM pituH prabhAveNAgamiSyati; tadA pratimanujaM svasvakarmmAnusArAt phalaM dAsyati| ");
INSERT INTO sanhk_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","ahaM yuSmAn tathyaM vacmi, sarAjyaM manujasutam AgataM na pazyanto mRtyuM na svAdiSyanti, etAdRzAH katipayajanA atrApi daNDAyamAnAH santi| ");
INSERT INTO sanhk_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","anantaraM SaDdinebhyaH paraM yIzuH pitaraM yAkUbaM tatsahajaM yohanaJca gRhlan uccAdre rviviktasthAnam Agatya teSAM samakSaM rUpamanyat dadhAra| ");
INSERT INTO sanhk_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","tena tadAsyaM tejasvi, tadAbharaNam Alokavat pANDaramabhavat| ");
INSERT INTO sanhk_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","anyacca tena sAkaM saMlapantau mUsA eliyazca tebhyo darzanaM dadatuH| ");
INSERT INTO sanhk_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","tadAnIM pitaro yIzuM jagAda, he prabho sthitiratrAsmAkaM zubhA, yadi bhavatAnumanyate, tarhi bhavadarthamekaM mUsArthamekam eliyArthaJcaikam iti trINi dUSyANi nirmmama| ");
INSERT INTO sanhk_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","etatkathanakAla eka ujjavalaH payodasteSAmupari chAyAM kRtavAn, vAridAd eSA nabhasIyA vAg babhUva, mamAyaM priyaH putraH, asmin mama mahAsantoSa etasya vAkyaM yUyaM nizAmayata| ");
INSERT INTO sanhk_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","kintu vAcametAM zRNvantaeva ziSyA mRzaM zaGkamAnA nyubjA nyapatan| ");
INSERT INTO sanhk_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","tadA yIzurAgatya teSAM gAtrANi spRzan uvAca, uttiSThata, mA bhaiSTa| ");
INSERT INTO sanhk_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","tadAnIM netrANyunmIlya yIzuM vinA kamapi na dadRzuH| ");
INSERT INTO sanhk_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","tataH param adreravarohaNakAle yIzustAn ityAdideza, manujasutasya mRtAnAM madhyAdutthAnaM yAvanna jAyate, tAvat yuSmAbhiretaddarzanaM kasmaicidapi na kathayitavyaM| ");
INSERT INTO sanhk_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","tadA ziSyAstaM papracchuH, prathamam eliya AyAsyatIti kuta upAdhyAyairucyate? ");
INSERT INTO sanhk_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","tato yIzuH pratyavAdIt, eliyaH prAgetya sarvvANi sAdhayiSyatIti satyaM, ");
INSERT INTO sanhk_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","kintvahaM yuSmAn vacmi, eliya etya gataH, te tamaparicitya tasmin yathecchaM vyavajahuH; manujasutenApi teSAmantike tAdRg duHkhaM bhoktavyaM| ");
INSERT INTO sanhk_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","tadAnIM sa majjayitAraM yohanamadhi kathAmetAM vyAhRtavAn, itthaM tacchiSyA bubudhire| ");
INSERT INTO sanhk_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","pazcAt teSu jananivahasyAntikamAgateSu kazcit manujastadantikametya jAnUnI pAtayitvA kathitavAn, ");
INSERT INTO sanhk_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","he prabho, matputraM prati kRpAM vidadhAtu, sopasmArAmayena bhRzaM vyathitaH san punaH puna rvahnau muhu rjalamadhye patati| ");
INSERT INTO sanhk_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","tasmAd bhavataH ziSyANAM samIpe tamAnayaM kintu te taM svAsthaM karttuM na zaktAH| ");
INSERT INTO sanhk_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","tadA yIzuH kathitavAn re avizvAsinaH, re vipathagAminaH, punaH katikAlAn ahaM yuSmAkaM sannidhau sthAsyAmi? katikAlAn vA yuSmAn sahiSye? tamatra mamAntikamAnayata| ");
INSERT INTO sanhk_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","pazcAd yIzunA tarjataeva sa bhUtastaM vihAya gatavAn, taddaNDaeva sa bAlako nirAmayo'bhUt| ");
INSERT INTO sanhk_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","tataH ziSyA guptaM yIzumupAgatya babhASire, kuto vayaM taM bhUtaM tyAjayituM na zaktAH? ");
INSERT INTO sanhk_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","yIzunA te proktAH, yuSmAkamapratyayAt; ");
INSERT INTO sanhk_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","yuSmAnahaM tathyaM vacmi yadi yuSmAkaM sarSapaikamAtropi vizvAso jAyate, tarhi yuSmAbhirasmin zaile tvamitaH sthAnAt tat sthAnaM yAhIti brUte sa tadaiva caliSyati, yuSmAkaM kimapyasAdhyaJca karmma na sthAsyAti| kintu prArthanopavAsau vinaitAdRzo bhUto na tyAjyeta| ");
INSERT INTO sanhk_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","aparaM teSAM gAlIlpradeze bhramaNakAle yIzunA te gaditAH, manujasuto janAnAM kareSu samarpayiSyate tai rhaniSyate ca, ");
INSERT INTO sanhk_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","kintu tRtIye'hi्na ma utthApiSyate, tena te bhRzaM duHkhitA babhUvaH| ");
INSERT INTO sanhk_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","tadanantaraM teSu kapharnAhUmnagaramAgateSu karasaMgrAhiNaH pitarAntikamAgatya papracchuH, yuSmAkaM guruH kiM mandirArthaM karaM na dadAti? tataH pitaraH kathitavAn dadAti| ");
INSERT INTO sanhk_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","tatastasmin gRhamadhyamAgate tasya kathAkathanAt pUrvvameva yIzuruvAca, he zimon, medinyA rAjAnaH svasvApatyebhyaH kiM videzibhyaH kebhyaH karaM gRhlanti? atra tvaM kiM budhyase? tataH pitara uktavAn, videzibhyaH| ");
INSERT INTO sanhk_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","tadA yIzuruktavAn, tarhi santAnA muktAH santi| ");
INSERT INTO sanhk_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","tathApi yathAsmAbhisteSAmantarAyo na janyate, tatkRte jaladhestIraM gatvA vaDizaM kSipa, tenAdau yo mIna utthAsyati, taM ghRtvA tanmukhe mocite tolakaikaM rUpyaM prApsyasi, tad gRhItvA tava mama ca kRte tebhyo dehi| ");
INSERT INTO sanhk_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","tadAnIM ziSyA yIzoH samIpamAgatya pRSTavantaH svargarAjye kaH zreSThaH? ");
INSERT INTO sanhk_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","tato yIzuH kSudramekaM bAlakaM svasamIpamAnIya teSAM madhye nidhAya jagAda, ");
INSERT INTO sanhk_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","yuSmAnahaM satyaM bravImi, yUyaM manovinimayena kSudrabAlavat na santaH svargarAjyaM praveSTuM na zaknutha| ");
INSERT INTO sanhk_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","yaH kazcid etasya kSudrabAlakasya samamAtmAnaM namrIkaroti, saeva svargarAjaye zreSThaH| ");
INSERT INTO sanhk_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","yaH kazcid etAdRzaM kSudrabAlakamekaM mama nAmni gRhlAti, sa mAmeva gRhlAti| ");
INSERT INTO sanhk_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","kintu yo jano mayi kRtavizvAsAnAmeteSAM kSudraprANinAm ekasyApi vidhniM janayati, kaNThabaddhapeSaNIkasya tasya sAgarAgAdhajale majjanaM zreyaH| ");
INSERT INTO sanhk_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","vighnAt jagataH santApo bhaviSyati, vighno'vazyaM janayiSyate, kintu yena manujena vighno janiSyate tasyaiva santApo bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","tasmAt tava karazcaraNo vA yadi tvAM bAdhate, tarhi taM chittvA nikSipa, dvikarasya dvipadasya vA tavAnaptavahnau nikSepAt, khaJjasya vA chinnahastasya tava jIvane pravezo varaM| ");
INSERT INTO sanhk_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","aparaM tava netraM yadi tvAM bAdhate, tarhi tadapyutpAvya nikSipa, dvinetrasya narakAgnau nikSepAt kANasya tava jIvane pravezo varaM| ");
INSERT INTO sanhk_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","tasmAdavadhaddhaM, eteSAM kSudraprANinAm ekamapi mA tucchIkuruta, ");
INSERT INTO sanhk_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","yato yuSmAnahaM tathyaM bravImi, svarge teSAM dUtA mama svargasthasya piturAsyaM nityaM pazyanti| evaM ye ye hAritAstAn rakSituM manujaputra Agacchat| ");
INSERT INTO sanhk_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","yUyamatra kiM viviMgghve? kasyacid yadi zataM meSAH santi, teSAmeko hAryyate ca, tarhi sa ekonazataM meSAn vihAya parvvataM gatvA taM hAritamekaM kiM na mRgayate? ");
INSERT INTO sanhk_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","yadi ca kadAcit tanmeSoddezaM lamate, tarhi yuSmAnahaM satyaM kathayAmi, so'vipathagAmibhya ekonazatameSebhyopi tadekahetoradhikam AhlAdate| ");
INSERT INTO sanhk_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","tadvad eteSAM kSudraprAeिnAm ekopi nazyatIti yuSmAkaM svargasthapitu rnAbhimatam| ");
INSERT INTO sanhk_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","yadyapi tava bhrAtA tvayi kimapyaparAdhyati, tarhi gatvA yuvayordvayoH sthitayostasyAparAdhaM taM jJApaya| tatra sa yadi tava vAkyaM zRNoti, tarhi tvaM svabhrAtaraM prAptavAn, ");
INSERT INTO sanhk_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","kintu yadi na zRNoti, tarhi dvAbhyAM tribhi rvA sAkSIbhiH sarvvaM vAkyaM yathA nizcitaM jAyate, tadartham ekaM dvau vA sAkSiNau gRhItvA yAhi| ");
INSERT INTO sanhk_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","tena sa yadi tayo rvAkyaM na mAnyate, tarhi samAjaM tajjJApaya, kintu yadi samAjasyApi vAkyaM na mAnyate,tarhi sa tava samIpe devapUjaka_iva caNDAla_iva ca bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","ahaM yuSmAn satyaM vadAmi, yuSmAbhiH pRthivyAM yad badhyate tat svarge bhaMtsyate; medinyAM yat bhocyate, svarge'pi tat mokSyate| ");
INSERT INTO sanhk_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","punarahaM yuSmAn vadAmi, medinyAM yuSmAkaM yadi dvAvekavAkyIbhUya kiJcit prArthayete, tarhi mama svargasthapitrA tat tayoH kRte sampannaM bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","yato yatra dvau trayo vA mama nAnni milanti, tatraivAhaM teSAM madhye'smi| ");
INSERT INTO sanhk_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","tadAnIM pitarastatsamIpamAgatya kathitavAn he prabho, mama bhrAtA mama yadyaparAdhyati, tarhi taM katikRtvaH kSamiSye? ");
INSERT INTO sanhk_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","kiM saptakRtvaH? yIzustaM jagAda, tvAM kevalaM saptakRtvo yAvat na vadAmi, kintu saptatyA guNitaM saptakRtvo yAvat| ");
INSERT INTO sanhk_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","aparaM nijadAsaiH saha jigaNayiSuH kazcid rAjeva svargarAjayaM| ");
INSERT INTO sanhk_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Arabdhe tasmin gaNane sArddhasahasramudrApUritAnAM dazasahasrapuTakAnAm eko'ghamarNastatsamakSamAnAyi| ");
INSERT INTO sanhk_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","tasya parizodhanAya dravyAbhAvAt parizodhanArthaM sa tadIyabhAryyAputrAdisarvvasvaJca vikrIyatAmiti tatprabhurAdideza| ");
INSERT INTO sanhk_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","tena sa dAsastasya pAdayoH patan praNamya kathitavAn , he prabho bhavatA ghairyye kRte mayA sarvvaM parizodhiSyate| ");
INSERT INTO sanhk_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","tadAnIM dAsasya prabhuH sakaruNaH san sakalarNaM kSamitvA taM tatyAja| ");
INSERT INTO sanhk_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","kintu tasmin dAse bahi ryAte, tasya zataM mudrAcaturthAMzAn yo dhArayati, taM sahadAsaM dRSdvA tasya kaNThaM niSpIDya gaditavAn, mama yat prApyaM tat parizodhaya| ");
INSERT INTO sanhk_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","tadA tasya sahadAsastatpAdayoH patitvA vinIya babhASe, tvayA dhairyye kRte mayA sarvvaM parizodhiSyate| ");
INSERT INTO sanhk_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","tathApi sa tat nAGagIkRtya yAvat sarvvamRNaM na parizodhitavAn tAvat taM kArAyAM sthApayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","tadA tasya sahadAsAstasyaitAdRg AcaraNaM vilokya prabhoH samIpaM gatvA sarvvaM vRttAntaM nivedayAmAsuH| ");
INSERT INTO sanhk_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","tadA tasya prabhustamAhUya jagAda, re duSTa dAsa, tvayA matsannidhau prArthite mayA tava sarvvamRNaM tyaktaM; ");
INSERT INTO sanhk_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","yathA cAhaM tvayi karuNAM kRtavAn, tathaiva tvatsahadAse karuNAkaraNaM kiM tava nocitaM? ");
INSERT INTO sanhk_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","iti kathayitvA tasya prabhuH kruddhyan nijaprApyaM yAvat sa na parizodhitavAn, tAvat prahArakAnAM kareSu taM samarpitavAn| ");
INSERT INTO sanhk_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","yadi yUyaM svAntaHkaraNaiH svasvasahajAnAm aparAdhAn na kSamadhve, tarhi mama svargasyaH pitApi yuSmAn pratItthaM kariSyati| ");
INSERT INTO sanhk_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","anantaram etAsu kathAsu samAptAsu yIzu rgAlIlapradezAt prasthAya yardantIrasthaM yihUdApradezaM prAptaH| ");
INSERT INTO sanhk_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","tadA tatpazcAt jananivahe gate sa tatra tAn nirAmayAn akarot| ");
INSERT INTO sanhk_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","tadanantaraM phirUzinastatsamIpamAgatya pArIkSituM taM papracchuH, kasmAdapi kAraNAt nareNa svajAyA parityAjyA na vA? ");
INSERT INTO sanhk_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","sa pratyuvAca, prathamam Izvaro naratvena nArItvena ca manujAn sasarja, tasmAt kathitavAn, ");
INSERT INTO sanhk_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","mAnuSaH svapitarau parityajya svapatnyAm AsakSyate, tau dvau janAvekAGgau bhaviSyataH, kimetad yuSmAbhi rna paThitam? ");
INSERT INTO sanhk_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","atastau puna rna dvau tayorekAGgatvaM jAtaM, IzvareNa yacca samayujyata, manujo na tad bhindyAt| ");
INSERT INTO sanhk_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","tadAnIM te taM pratyavadan, tathAtve tyAjyapatraM dattvA svAM svAM jAyAM tyaktuM vyavasthAM mUsAH kathaM lilekha? ");
INSERT INTO sanhk_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","tataH sa kathitavAn, yuSmAkaM manasAM kAThinyAd yuSmAn svAM svAM jAyAM tyaktum anvamanyata kintu prathamAd eSo vidhirnAsIt| ");
INSERT INTO sanhk_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","ato yuSmAnahaM vadAmi, vyabhicAraM vinA yo nijajAyAM tyajet anyAJca vivahet, sa paradArAn gacchati; yazca tyaktAM nArIM vivahati sopi paradAreSu ramate| ");
INSERT INTO sanhk_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","tadA tasya ziSyAstaM babhASire, yadi svajAyayA sAkaM puMsa etAdRk sambandho jAyate, tarhi vivahanameva na bhadraM| ");
INSERT INTO sanhk_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","tataH sa uktavAn, yebhyastatsAmarthyaM AdAyi, tAn vinAnyaH kopi manuja etanmataM grahItuM na zaknoti| ");
INSERT INTO sanhk_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","katipayA jananaklIbaH katipayA narakRtaklIbaH svargarAjyAya katipayAH svakRtaklIbAzca santi, ye grahItuM zaknuvanti te gRhlantu| ");
INSERT INTO sanhk_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","aparam yathA sa zizUnAM gAtreSu hastaM datvA prArthayate, tadarthaM tatsamIMpaM zizava AnIyanta, tata AnayitRn ziSyAstiraskRtavantaH| ");
INSERT INTO sanhk_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","kintu yIzuruvAca, zizavo madantikam Agacchantu, tAn mA vArayata, etAdRzAM zizUnAmeva svargarAjyaM| ");
INSERT INTO sanhk_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","tataH sa teSAM gAtreSu hastaM datvA tasmAt sthAnAt pratasthe| ");
INSERT INTO sanhk_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","aparam eka Agatya taM papraccha, he paramaguro, anantAyuH prAptuM mayA kiM kiM satkarmma karttavyaM? ");
INSERT INTO sanhk_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","tataH sa uvAca, mAM paramaM kuto vadasi? vinezcaraM na kopi paramaH, kintu yadyanantAyuH prAptuM vAJchasi, tarhyAjJAH pAlaya| ");
INSERT INTO sanhk_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","tadA sa pRSTavAn, kAH kA AjJAH? tato yIzuH kathitavAn, naraM mA hanyAH, paradArAn mA gaccheH, mA corayeH, mRSAsAkSyaM mA dadyAH, ");
INSERT INTO sanhk_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","nijapitarau saMmanyasva, svasamIpavAsini svavat prema kuru| ");
INSERT INTO sanhk_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","sa yuvA kathitavAn, A bAlyAd etAH pAlayAmi, idAnIM kiM nyUnamAste? ");
INSERT INTO sanhk_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","tato yIzuravadat, yadi siddho bhavituM vAJchasi, tarhi gatvA nijasarvvasvaM vikrIya daridrebhyo vitara, tataH svarge vittaM lapsyase; Agaccha, matpazcAdvarttI ca bhava| ");
INSERT INTO sanhk_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","etAM vAcaM zrutvA sa yuvA svIyabahusampatte rviSaNaH san calitavAn| ");
INSERT INTO sanhk_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","tadA yIzuH svaziSyAn avadat, dhaninAM svargarAjyapravezo mahAduSkara iti yuSmAnahaM tathyaM vadAmi| ");
INSERT INTO sanhk_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","punarapi yuSmAnahaM vadAmi, dhaninAM svargarAjyapravezAt sUcIchidreNa mahAGgagamanaM sukaraM| ");
INSERT INTO sanhk_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","iti vAkyaM nizamya ziSyA aticamatkRtya kathayAmAsuH; tarhi kasya paritrANaM bhavituM zaknoti? ");
INSERT INTO sanhk_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","tadA sa tAn dRSdvA kathayAmAsa, tat mAnuSANAmazakyaM bhavati, kintvIzvarasya sarvvaM zakyam| ");
INSERT INTO sanhk_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","tadA pitarastaM gaditavAn, pazya, vayaM sarvvaM parityajya bhavataH pazcAdvarttino 'bhavAma; vayaM kiM prApsyAmaH? ");
INSERT INTO sanhk_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","tato yIzuH kathitavAn, yuSmAnahaM tathyaM vadAmi, yUyaM mama pazcAdvarttino jAtA iti kAraNAt navInasRSTikAle yadA manujasutaH svIyaizcaryyasiMhAsana upavekSyati, tadA yUyamapi dvAdazasiMhAsaneSUpavizya isrAyelIyadvAdazavaMzAnAM vicAraM kariSyatha| ");
INSERT INTO sanhk_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","anyacca yaH kazcit mama nAmakAraNAt gRhaM vA bhrAtaraM vA bhaginIM vA pitaraM vA mAtaraM vA jAyAM vA bAlakaM vA bhUmiM parityajati, sa teSAM zataguNaM lapsyate, anantAyumo'dhikAritvaJca prApsyati| ");
INSERT INTO sanhk_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","kintu agrIyA aneke janAH pazcAt, pazcAtIyAzcAneke lokA agre bhaviSyanti| ");
INSERT INTO sanhk_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","svargarAjyam etAdRzA kenacid gRhasyena samaM, yo'tiprabhAte nijadrAkSAkSetre kRSakAn niyoktuM gatavAn| ");
INSERT INTO sanhk_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","pazcAt taiH sAkaM dinaikabhRtiM mudrAcaturthAMzaM nirUpya tAn drAkSAkSetraM prerayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","anantaraM praharaikavelAyAM gatvA haTTe katipayAn niSkarmmakAn vilokya tAnavadat, ");
INSERT INTO sanhk_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","yUyamapi mama drAkSAkSetraM yAta, yuSmabhyamahaM yogyabhRtiM dAsyAmi, tataste vavrajuH| ");
INSERT INTO sanhk_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","punazca sa dvitIyatRtIyayoH praharayo rbahi rgatvA tathaiva kRtavAn| ");
INSERT INTO sanhk_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","tato daNDadvayAvaziSTAyAM velAyAM bahi rgatvAparAn katipayajanAn niSkarmmakAn vilokya pRSTavAn, yUyaM kimartham atra sarvvaM dinaM niSkarmmANastiSThatha? ");
INSERT INTO sanhk_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","te pratyavadan, asmAn na kopi karmamaNi niyuMkte| tadAnIM sa kathitavAn, yUyamapi mama drAkSAkSetraM yAta, tena yogyAM bhRtiM lapsyatha| ");
INSERT INTO sanhk_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","tadanantaraM sandhyAyAM satyAM saeva drAkSAkSetrapatiradhyakSaM gadivAn, kRSakAn AhUya zeSajanamArabhya prathamaM yAvat tebhyo bhRtiM dehi| ");
INSERT INTO sanhk_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","tena ye daNDadvayAvasthite samAyAtAsteSAm ekaiko jano mudrAcaturthAMzaM prApnot| ");
INSERT INTO sanhk_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","tadAnIM prathamaniyuktA janA AgatyAnumitavanto vayamadhikaM prapsyAmaH, kintu tairapi mudrAcaturthAMzo'lAbhi| ");
INSERT INTO sanhk_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","tataste taM gRhItvA tena kSetrapatinA sAkaM vAgyuddhaM kurvvantaH kathayAmAsuH, ");
INSERT INTO sanhk_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","vayaM kRtsnaM dinaM tApaklezau soDhavantaH, kintu pazcAtAyA se janA daNDadvayamAtraM parizrAntavantaste'smAbhiH samAnAMzAH kRtAH| ");
INSERT INTO sanhk_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","tataH sa teSAmekaM pratyuvAca, he vatsa, mayA tvAM prati kopyanyAyo na kRtaH kiM tvayA matsamakSaM mudrAcaturthAMzo nAGgIkRtaH? ");
INSERT INTO sanhk_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","tasmAt tava yat prApyaM tadAdAya yAhi, tubhyaM yati, pazcAtIyaniyuktalokAyApi tati dAtumicchAmi| ");
INSERT INTO sanhk_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","svecchayA nijadravyavyavaharaNaM kiM mayA na karttavyaM? mama dAtRtvAt tvayA kim IrSyAdRSTiH kriyate? ");
INSERT INTO sanhk_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","ittham agrIyalokAH pazcatIyA bhaviSyanti, pazcAtIyajanAzcagrIyA bhaviSyanti, ahUtA bahavaH kintvalpe manobhilaSitAH| ");
INSERT INTO sanhk_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","tadanantaraM yIzu ryirUzAlamnagaraM gacchan mArgamadhye ziSyAn ekAnte vabhASe, ");
INSERT INTO sanhk_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","pazya vayaM yirUzAlamnagaraM yAmaH, tatra pradhAnayAjakAdhyApakAnAM kareSu manuSyaputraH samarpiSyate; ");
INSERT INTO sanhk_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","te ca taM hantumAjJApya tiraskRtya vetreNa praharttuM kruze dhAtayituJcAnyadezIyAnAM kareSu samarpayiSyanti, kintu sa tRtIyadivase zmazAnAd utthApiSyate| ");
INSERT INTO sanhk_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","tadAnIM sivadIyasya nArI svaputrAvAdAya yIzoH samIpam etya praNamya kaJcanAnugrahaM taM yayAce| ");
INSERT INTO sanhk_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","tadA yIzustAM proktavAn, tvaM kiM yAcase? tataH sA babhASe, bhavato rAjatve mamAnayoH sutayorekaM bhavaddakSiNapArzve dvitIyaM vAmapArzva upaveSTum AjJApayatu| ");
INSERT INTO sanhk_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","yIzuH pratyuvAca, yuvAbhyAM yad yAcyate, tanna budhyate, ahaM yena kaMsena pAsyAmi yuvAbhyAM kiM tena pAtuM zakyate? ahaJca yena majjenena majjiSye, yuvAbhyAM kiM tena majjayituM zakyate? te jagaduH zakyate| ");
INSERT INTO sanhk_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","tadA sa uktavAn, yuvAM mama kaMsenAvazyaM pAsyathaH, mama majjanena ca yuvAmapi majjiSyethe, kintu yeSAM kRte mattAtena nirUpitam idaM tAn vihAyAnyaM kamapi maddakSiNapArzve vAmapArzve ca samupavezayituM mamAdhikAro nAsti| ");
INSERT INTO sanhk_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","etAM kathAM zrutvAnye dazaziSyAstau bhrAtarau prati cukupuH| ");
INSERT INTO sanhk_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","kintu yIzuH svasamIpaM tAnAhUya jagAda, anyadezIyalokAnAM narapatayastAn adhikurvvanti, ye tu mahAntaste tAn zAsati, iti yUyaM jAnItha| ");
INSERT INTO sanhk_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","kintu yuSmAkaM madhye na tathA bhavet, yuSmAkaM yaH kazcit mahAn bubhUSati, sa yuSmAn seveta; ");
INSERT INTO sanhk_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","yazca yuSmAkaM madhye mukhyo bubhUSati, sa yuSmAkaM dAso bhavet| ");
INSERT INTO sanhk_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","itthaM manujaputraH sevyo bhavituM nahi, kintu sevituM bahUnAM paritrANamUlyArthaM svaprANAn dAtuJcAgataH| ");
INSERT INTO sanhk_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","anantaraM yirIhonagarAt teSAM bahirgamanasamaye tasya pazcAd bahavo lokA vavrajuH| ");
INSERT INTO sanhk_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","aparaM vartmapArzva upavizantau dvAvandhau tena mArgeNa yIzo rgamanaM nizamya proccaiH kathayAmAsatuH, he prabho dAyUdaH santAna, Avayo rdayAM vidhehi| ");
INSERT INTO sanhk_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","tato lokAH sarvve tuSNImbhavatamityuktvA tau tarjayAmAsuH; tathApi tau punaruccaiH kathayAmAsatuH he prabho dAyUdaH santAna, AvAM dayasva| ");
INSERT INTO sanhk_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","tadAnIM yIzuH sthagitaH san tAvAhUya bhASitavAn, yuvayoH kRte mayA kiM karttarvyaM? yuvAM kiM kAmayethe? ");
INSERT INTO sanhk_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","tadA tAvuktavantau, prabho netrANi nau prasannAni bhaveyuH| ");
INSERT INTO sanhk_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","tadAnIM yIzustau prati pramannaH san tayo rnetrANi pasparza, tenaiva tau suvIkSAJcakrAte tatpazcAt jagmutuzca| ");
INSERT INTO sanhk_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","anantaraM teSu yirUzAlamnagarasya samIpaverttino jaitunanAmakadharAdharasya samIpasthtiM baitphagigrAmam AgateSu, yIzuH ziSyadvayaM preSayan jagAda, ");
INSERT INTO sanhk_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","yuvAM sammukhasthagrAmaM gatvA baddhAM yAM savatsAM garddabhIM haThAt prApsyathaH, tAM mocayitvA madantikam AnayataM| ");
INSERT INTO sanhk_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","tatra yadi kazcit kiJcid vakSyati, tarhi vadiSyathaH, etasyAM prabhoH prayojanamAste, tena sa tatkSaNAt praheSyati| ");
INSERT INTO sanhk_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","sIyonaH kanyakAM yUyaM bhASadhvamiti bhAratIM| pazya te namrazIlaH san nRpa Aruhya gardabhIM| arthAdAruhya tadvatsamAyAsyati tvadantikaM| ");
INSERT INTO sanhk_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","bhaviSyadvAdinoktaM vacanamidaM tadA saphalamabhUt| ");
INSERT INTO sanhk_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","anantaraM tau zSyiौ yIzo ryathAnidezaM taM grAmaM gatvA ");
INSERT INTO sanhk_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","gardabhIM tadvatsaJca samAnItavantau, pazcAt tadupari svIyavasanAnI pAtayitvA tamArohayAmAsatuH| ");
INSERT INTO sanhk_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","tato bahavo lokA nijavasanAni pathi prasArayitumArebhire, katipayA janAzca pAdapaparNAdikaM chitvA pathi vistArayAmAsuH| ");
INSERT INTO sanhk_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","agragAminaH pazcAdgAminazca manujA uccairjaya jaya dAyUdaH santAneti jagaduH paramezvarasya nAmnA ya AyAti sa dhanyaH, sarvvoparisthasvargepi jayati| ");
INSERT INTO sanhk_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","itthaM tasmin yirUzAlamaM praviSTe ko'yamiti kathanAt kRtsnaM nagaraM caJcalamabhavat| ");
INSERT INTO sanhk_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","tatra lokoH kathayAmAsuH, eSa gAlIlpradezIya-nAsaratIya-bhaviSyadvAdI yIzuH| ");
INSERT INTO sanhk_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","anantaraM yIzurIzvarasya mandiraM pravizya tanmadhyAt krayavikrayiNo vahizcakAra; vaNijAM mudrAsanAnI kapotavikrayiNAJcasanAnI ca nyuvjayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","aparaM tAnuvAca, eSA lipirAste, \"mama gRhaM prArthanAgRhamiti vikhyAsyati\", kintu yUyaM tad dasyUnAM gahvaraM kRtavantaH| ");
INSERT INTO sanhk_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","tadanantaram andhakhaJcalokAstasya samIpamAgatAH, sa tAn nirAmayAn kRtavAn| ");
INSERT INTO sanhk_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","yadA pradhAnayAjakA adhyApakAzca tena kRtAnyetAni citrakarmmANi dadRzuH, jaya jaya dAyUdaH santAna, mandire bAlakAnAm etAdRzam uccadhvaniM zuzruvuzca, tadA mahAkruddhA babhUvaH, ");
INSERT INTO sanhk_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","taM papracchuzca, ime yad vadanti, tat kiM tvaM zRNoSi? tato yIzustAn avocat, satyam; stanyapAyizizUnAJca bAlakAnAJca vaktrataH| svakIyaM mahimAnaM tvaM saMprakAzayasi svayaM| etadvAkyaM yUyaM kiM nApaThata? ");
INSERT INTO sanhk_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","tatastAn vihAya sa nagarAd baithaniyAgrAmaM gatvA tatra rajanIM yApayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","anantaraM prabhAte sati yIzuH punarapi nagaramAgacchan kSudhArtto babhUva| ");
INSERT INTO sanhk_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","tato mArgapArzva uDumbaravRkSamekaM vilokya tatsamIpaM gatvA patrANi vinA kimapi na prApya taM pAdapaM provAca, adyArabhya kadApi tvayi phalaM na bhavatu; tena tatkSaNAt sa uDumbaramAhIruhaH zuSkatAM gataH| ");
INSERT INTO sanhk_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","tad dRSTvA ziSyA AzcaryyaM vijJAya kathayAmAsuH, AH, uDumvarapAdapo'titUrNaM zuSko'bhavat| ");
INSERT INTO sanhk_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","tato yIzustAnuvAca, yuSmAnahaM satyaM vadAmi, yadi yUyamasandigdhAH pratItha, tarhi yUyamapi kevaloDumvarapAdapaM pratItthaM karttuM zakSyatha, tanna, tvaM calitvA sAgare pateti vAkyaM yuSmAbhirasmina zaile proktepi tadaiva tad ghaTiSyate| ");
INSERT INTO sanhk_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","tathA vizvasya prArthya yuSmAbhi ryad yAciSyate, tadeva prApsyate| ");
INSERT INTO sanhk_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","anantaraM mandiraM pravizyopadezanasamaye tatsamIpaM pradhAnayAjakAH prAcInalokAzcAgatya papracchuH, tvayA kena sAmarthyanaitAni karmmANi kriyante? kena vA tubhyametAni sAmarthyAni dattAni? ");
INSERT INTO sanhk_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","tato yIzuH pratyavadat, ahamapi yuSmAn vAcamekAM pRcchAmi, yadi yUyaM taduttaraM dAtuM zakSyatha, tadA kena sAmarthyena karmmANyetAni karomi, tadahaM yuSmAn vakSyAmi| ");
INSERT INTO sanhk_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","yohano majjanaM kasyAjJayAbhavat? kimIzvarasya manuSyasya vA? tataste parasparaM vivicya kathayAmAsuH, yadIzvarasyeti vadAmastarhi yUyaM taM kuto na pratyaita? vAcametAM vakSyati| ");
INSERT INTO sanhk_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","manuSyasyeti vaktumapi lokebhyo bibhImaH, yataH sarvvairapi yohan bhaviSyadvAdIti jJAyate| ");
INSERT INTO sanhk_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","tasmAt te yIzuM pratyavadan, tad vayaM na vidmaH| tadA sa tAnuktavAn, tarhi kena sAmarathyena karmmANyetAnyahaM karomi, tadapyahaM yuSmAn na vakSyAmi| ");
INSERT INTO sanhk_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","kasyacijjanasya dvau sutAvAstAM sa ekasya sutasya samIpaM gatvA jagAda, he suta, tvamadya mama drAkSAkSetre karmma kartuM vraja| ");
INSERT INTO sanhk_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","tataH sa uktavAn, na yAsyAmi, kintu zeSe'nutapya jagAma| ");
INSERT INTO sanhk_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","anantaraM sonyasutasya samIpaM gatvA tathaiva kathtivAn; tataH sa pratyuvAca, maheccha yAmi, kintu na gataH| ");
INSERT INTO sanhk_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","etayoH putrayo rmadhye piturabhimataM kena pAlitaM? yuSmAbhiH kiM budhyate? tataste pratyUcuH, prathamena puुtreNa| tadAnIM yIzustAnuvAca, ahaM yuSmAn tathyaM vadAmi, caNDAlA gaNikAzca yuSmAkamagrata Izvarasya rAjyaM pravizanti| ");
INSERT INTO sanhk_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","yato yuSmAkaM samIpaM yohani dharmmapathenAgate yUyaM taM na pratItha, kintu caNDAlA gaNikAzca taM pratyAyan, tad vilokyApi yUyaM pratyetuM nAkhidyadhvaM| ");
INSERT INTO sanhk_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","aparamekaM dRSTAntaM zRNuta, kazcid gRhasthaH kSetre drAkSAlatA ropayitvA taccaturdikSu vAraNIM vidhAya tanmadhye drAkSAyantraM sthApitavAn, mAJcaJca nirmmitavAn, tataH kRSakeSu tat kSetraM samarpya svayaM dUradezaM jagAma| ");
INSERT INTO sanhk_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","tadanantaraM phalasamaya upasthite sa phalAni prAptuM kRSIvalAnAM samIpaM nijadAsAn preSayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","kintu kRSIvalAstasya tAn dAseyAn dhRtvA kaJcana prahRtavantaH, kaJcana pASANairAhatavantaH, kaJcana ca hatavantaH| ");
INSERT INTO sanhk_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","punarapi sa prabhuH prathamato'dhikadAseyAn preSayAmAsa, kintu te tAn pratyapi tathaiva cakruH| ");
INSERT INTO sanhk_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","anantaraM mama sute gate taM samAdariSyante, ityuktvA zeSe sa nijasutaM teSAM sannidhiM preSayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","kintu te kRSIvalAH sutaM vIkSya parasparam iti mantrayitum Arebhire, ayamuttarAdhikArI vayamenaM nihatyAsyAdhikAraM svavazIkariSyAmaH| ");
INSERT INTO sanhk_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","pazcAt te taM dhRtvA drAkSAkSetrAd bahiH pAtayitvAbadhiSuH| ");
INSERT INTO sanhk_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","yadA sa drAkSAkSetrapatirAgamiSyati, tadA tAn kRSIvalAn kiM kariSyati? ");
INSERT INTO sanhk_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","tataste pratyavadan, tAn kaluSiNo dAruNayAtanAbhirAhaniSyati, ye ca samayAnukramAt phalAni dAsyanti, tAdRzeSu kRSIvaleSu kSetraM samarpayiSyati| ");
INSERT INTO sanhk_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","tadA yIzunA te gaditAH, grahaNaM na kRtaM yasya pASANasya nicAyakaiH| pradhAnaprastaraH koNe saeva saMbhaviSyati| etat parezituH karmmAsmadRSTAvadbhutaM bhavet| dharmmagranthe likhitametadvacanaM yuSmAbhiH kiM nApAThi? ");
INSERT INTO sanhk_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","tasmAdahaM yuSmAn vadAmi, yuSmatta IzvarIyarAjyamapanIya phalotpAdayitranyajAtaye dAyiSyate| ");
INSERT INTO sanhk_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","yo jana etatpASANopari patiSyati, taM sa bhaMkSyate, kintvayaM pASANo yasyopari patiSyati, taM sa dhUlivat cUrNIkariSyati| ");
INSERT INTO sanhk_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","tadAnIM prAdhanayAjakAH phirUzinazca tasyemAM dRSTAntakathAM zrutvA so'smAnuddizya kathitavAn, iti vijJAya taM dharttuM ceSTitavantaH; ");
INSERT INTO sanhk_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","kintu lokebhyo bibhyuH, yato lokaiH sa bhaviSyadvAdItyajJAyi| ");
INSERT INTO sanhk_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","anantaraM yIzuH punarapi dRSTAntena tAn avAdIt, ");
INSERT INTO sanhk_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","svargIyarAjyam etAdRzasya nRpateH samaM, yo nija putraM vivAhayan sarvvAn nimantritAn AnetuM dAseyAn prahitavAn, ");
INSERT INTO sanhk_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","kintu te samAgantuM neSTavantaH| ");
INSERT INTO sanhk_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","tato rAjA punarapi dAsAnanyAn ityuktvA preSayAmAsa, nimantritAn vadata, pazyata, mama bhejyamAsAditamAste, nijavTaSAdipuSTajantUn mArayitvA sarvvaM khAdyadravyamAsAditavAn, yUyaM vivAhamAgacchata| ");
INSERT INTO sanhk_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","tathapi te tucchIkRtya kecit nijakSetraM kecid vANijyaM prati svasvamArgeNa calitavantaH| ");
INSERT INTO sanhk_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","anye lokAstasya dAseyAn dhRtvA daurAtmyaM vyavahRtya tAnavadhiSuH| ");
INSERT INTO sanhk_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","anantaraM sa nRpatistAM vArttAM zrutvA krudhyan sainyAni prahitya tAn ghAtakAn hatvA teSAM nagaraM dAhayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","tataH sa nijadAseyAn babhASe, vivAhIyaM bhojyamAsAditamAste, kintu nimantritA janA ayogyAH| ");
INSERT INTO sanhk_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","tasmAd yUyaM rAjamArgaM gatvA yAvato manujAn pazyata, tAvataeva vivAhIyabhojyAya nimantrayata| ");
INSERT INTO sanhk_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","tadA te dAseyA rAjamArgaM gatvA bhadrAn abhadrAn vA yAvato janAn dadRzuH, tAvataeva saMgRhyAnayan; tato'bhyAgatamanujai rvivAhagRham apUryyata| ");
INSERT INTO sanhk_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","tadAnIM sa rAjA sarvvAnabhyAgatAn draSTum abhyantaramAgatavAn; tadA tatra vivAhIyavasanahInamekaM janaM vIkSya taM jagAd, ");
INSERT INTO sanhk_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","he mitra,tvaM vivAhIyavasanaM vinA kathamatra praviSTavAn? tena sa niruttaro babhUva| ");
INSERT INTO sanhk_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","tadA rAjA nijAnucarAn avadat, etasya karacaraNAn baddhA yatra rodanaM dantairdantagharSaNaJca bhavati, tatra vahirbhUtatamisre taM nikSipata| ");
INSERT INTO sanhk_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","itthaM bahava AhUtA alpe manobhimatAH| ");
INSERT INTO sanhk_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","anantaraM phirUzinaH pragatya yathA saMlApena tam unmAthe pAtayeyustathA mantrayitvA ");
INSERT INTO sanhk_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","herodIyamanujaiH sAkaM nijaziSyagaNena taM prati kathayAmAsuH, he guro, bhavAn satyaH satyamIzvarIyamArgamupadizati, kamapi mAnuSaM nAnurudhyate, kamapi nApekSate ca, tad vayaM jAnImaH| ");
INSERT INTO sanhk_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","ataH kaisarabhUpAya karo'smAkaM dAtavyo na vA? atra bhavatA kiM budhyate? tad asmAn vadatu| ");
INSERT INTO sanhk_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","tato yIzusteSAM khalatAM vijJAya kathitavAn, re kapaTinaH yuyaM kuto mAM parikSadhve? ");
INSERT INTO sanhk_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","tatkaradAnasya mudrAM mAM darzayata| tadAnIM taistasya samIpaM mudrAcaturthabhAga AnIte ");
INSERT INTO sanhk_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","sa tAn papraccha, atra kasyeyaM mUrtti rnAma cAste? te jagaduH, kaisarabhUpasya| ");
INSERT INTO sanhk_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","tataH sa uktavAna, kaisarasya yat tat kaisarAya datta, Izvarasya yat tad IzvarAya datta| ");
INSERT INTO sanhk_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","iti vAkyaM nizamya te vismayaM vijJAya taM vihAya calitavantaH| ");
INSERT INTO sanhk_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","tasminnahani sidUkino'rthAt zmazAnAt notthAsyantIti vAkyaM ye vadanti, te yIzeाrantikam Agatya papracchuH, ");
INSERT INTO sanhk_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","he guro, kazcinmanujazcet niHsantAnaH san prANAn tyajati, tarhi tasya bhrAtA tasya jAyAM vyuhya bhrAtuH santAnam utpAdayiSyatIti mUsA AdiSTavAn| ");
INSERT INTO sanhk_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","kintvasmAkamatra ke'pi janAH saptasahodarA Asan, teSAM jyeSTha ekAM kanyAM vyavahAt, aparaM prANatyAgakAle svayaM niHsantAnaH san tAM striyaM svabhrAtari samarpitavAn, ");
INSERT INTO sanhk_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","tato dvitIyAdisaptamAntAzca tathaiva cakruH| ");
INSERT INTO sanhk_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","zeSe sApI nArI mamAra| ");
INSERT INTO sanhk_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","mRtAnAm utthAnasamaye teSAM saptAnAM madhye sA nArI kasya bhAryyA bhaviSyati? yasmAt sarvvaeva tAM vyavahan| ");
INSERT INTO sanhk_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","tato yIzuH pratyavAdIt, yUyaM dharmmapustakam IzvarIyAM zaktiJca na vijJAya bhrAntimantaH| ");
INSERT INTO sanhk_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","utthAnaprAptA lokA na vivahanti, na ca vAcA dIyante, kintvIzvarasya svargasthadUtAnAM sadRzA bhavanti| ");
INSERT INTO sanhk_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","aparaM mRtAnAmutthAnamadhi yuSmAn pratIyamIzvaroktiH, ");
INSERT INTO sanhk_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","\"ahamibrAhIma Izvara ishAka Izvaro yAkUba Izvara\" iti kiM yuSmAbhi rnApAThi? kintvIzvaro jIvatAm Izvara:, sa mRtAnAmIzvaro nahi| ");
INSERT INTO sanhk_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","iti zrutvA sarvve lokAstasyopadezAd vismayaM gatAH| ");
INSERT INTO sanhk_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","anantaraM sidUkinAm niruttaratvavArtAM nizamya phirUzina ekatra militavantaH, ");
INSERT INTO sanhk_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","teSAmeko vyavasthApako yIzuM parIkSituM papaccha, ");
INSERT INTO sanhk_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","he guro vyavasthAzAstramadhye kAjJA zreSThA? ");
INSERT INTO sanhk_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","tato yIzuruvAca, tvaM sarvvAntaHkaraNaiH sarvvaprANaiH sarvvacittaizca sAkaM prabhau paramezvare prIyasva, ");
INSERT INTO sanhk_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","eSA prathamamahAjJA| tasyAH sadRzI dvitIyAjJaiSA, ");
INSERT INTO sanhk_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","tava samIpavAsini svAtmanIva prema kuru| ");
INSERT INTO sanhk_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","anayo rdvayorAjJayoH kRtsnavyavasthAyA bhaviSyadvaktRgranthasya ca bhArastiSThati| ");
INSERT INTO sanhk_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","anantaraM phirUzinAm ekatra sthitikAle yIzustAn papraccha, ");
INSERT INTO sanhk_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","khrISTamadhi yuSmAkaM kIdRgbodho jAyate? sa kasya santAnaH? tataste pratyavadan, dAyUdaH santAnaH| ");
INSERT INTO sanhk_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","tadA sa uktavAn, tarhi dAyUd katham AtmAdhiSThAnena taM prabhuM vadati ? ");
INSERT INTO sanhk_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","yathA mama prabhumidaM vAkyamavadat paramezvaraH| tavArIn pAdapIThaM te yAvannahi karomyahaM| tAvat kAlaM madIye tvaM dakSapArzva upAviza| ato yadi dAyUd taM prabhuM vadati, rtiha sa kathaM tasya santAno bhavati? ");
INSERT INTO sanhk_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","tadAnIM teSAM kopi tadvAkyasya kimapyuttaraM dAtuM nAzaknot; ");
INSERT INTO sanhk_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","taddinamArabhya taM kimapi vAkyaM praSTuM kasyApi sAhaso nAbhavat| ");
INSERT INTO sanhk_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","anantaraM yIzu rjananivahaM ziSyAMzcAvadat, ");
INSERT INTO sanhk_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","adhyApakAH phirUzinazca mUsAsane upavizanti, ");
INSERT INTO sanhk_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ataste yuSmAn yadyat mantum AjJApayanti, tat manyadhvaM pAlayadhvaJca, kintu teSAM karmmAnurUpaM karmma na kurudhvaM; yatasteSAM vAkyamAtraM sAraM kAryye kimapi nAsti| ");
INSERT INTO sanhk_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","te durvvahAn gurutarAn bhArAn badvvA manuSyANAM skandhepari samarpayanti, kintu svayamaGgulyaikayApi na cAlayanti| ");
INSERT INTO sanhk_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","kevalaM lokadarzanAya sarvvakarmmANi kurvvanti; phalataH paTTabandhAn prasAryya dhArayanti, svavastreSu ca dIrghagranthIn dhArayanti; ");
INSERT INTO sanhk_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","bhojanabhavana uccasthAnaM, bhajanabhavane pradhAnamAsanaM, ");
INSERT INTO sanhk_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","haTThe namaskAraM gururiti sambodhanaJcaitAni sarvvANi vAJchanti| ");
INSERT INTO sanhk_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","kintu yUyaM gurava iti sambodhanIyA mA bhavata, yato yuSmAkam ekaH khrISTaeva guru ");
INSERT INTO sanhk_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ryUyaM sarvve mitho bhrAtarazca| punaH pRthivyAM kamapi piteti mA sambudhyadhvaM, yato yuSmAkamekaH svargasthaeva pitA| ");
INSERT INTO sanhk_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","yUyaM nAyaketi sambhASitA mA bhavata, yato yuSmAkamekaH khrISTaeva nAyakaH| ");
INSERT INTO sanhk_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","aparaM yuSmAkaM madhye yaH pumAn zreSThaH sa yuSmAn seviSyate| ");
INSERT INTO sanhk_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","yato yaH svamunnamati, sa nataH kariSyate; kintu yaH kazcit svamavanataM karoti, sa unnataH kariSyate| ");
INSERT INTO sanhk_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","hanta kapaTina upAdhyAyAH phirUzinazca, yUyaM manujAnAM samakSaM svargadvAraM rundha, yUyaM svayaM tena na pravizatha, pravivikSUnapi vArayatha| vata kapaTina upAdhyAyAH phirUzinazca yUyaM chalAd dIrghaM prArthya vidhavAnAM sarvvasvaM grasatha, yuSmAkaM ghorataradaNDo bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","hanta kapaTina upAdhyAyAH phirUzinazca, yUyamekaM svadharmmAvalambinaM karttuM sAgaraM bhUmaNDalaJca pradakSiNIkurutha, ");
INSERT INTO sanhk_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","kaJcana prApya svato dviguNanarakabhAjanaM taM kurutha| ");
INSERT INTO sanhk_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","vata andhapathadarzakAH sarvve, yUyaM vadatha, mandirasya zapathakaraNAt kimapi na deyaM; kintu mandirasthasuvarNasya zapathakaraNAd deyaM| ");
INSERT INTO sanhk_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","he mUDhA he andhAH suvarNaM tatsuvarNapAvakamandiram etayorubhayo rmadhye kiM zreyaH? ");
INSERT INTO sanhk_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","anyacca vadatha, yajJavedyAH zapathakaraNAt kimapi na deyaM, kintu taduparisthitasya naivedyasya zapathakaraNAd deyaM| ");
INSERT INTO sanhk_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","he mUDhA he andhAH, naivedyaM tannaivedyapAvakavediretayorubhayo rmadhye kiM zreyaH? ");
INSERT INTO sanhk_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ataH kenacid yajJavedyAH zapathe kRte taduparisthasya sarvvasya zapathaH kriyate| ");
INSERT INTO sanhk_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","kenacit mandirasya zapathe kRte mandiratannivAsinoH zapathaH kriyate| ");
INSERT INTO sanhk_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","kenacit svargasya zapathe kRte IzvarIyasiMhAsanataduparyyupaviSTayoH zapathaH kriyate| ");
INSERT INTO sanhk_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","hanta kapaTina upAdhyAyAH phirUzinazca, yUyaM podinAyAH sitacchatrAyA jIrakasya ca dazamAMzAn dattha, kintu vyavasthAyA gurutarAn nyAyadayAvizvAsAn parityajatha; ime yuSmAbhirAcaraNIyA amI ca na laMghanIyAH| ");
INSERT INTO sanhk_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","he andhapathadarzakA yUyaM mazakAn apasArayatha, kintu mahAGgAn grasatha| ");
INSERT INTO sanhk_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","hanta kapaTina upAdhyAyAH phirUzinazca, yUyaM pAnapAtrANAM bhojanapAtrANAJca bahiH pariSkurutha; kintu tadabhyantaraM durAtmatayA kaluSeNa ca paripUrNamAste| ");
INSERT INTO sanhk_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","he andhAH phirUzilokA Adau pAnapAtrANAM bhojanapAtrANAJcAbhyantaraM pariSkuruta, tena teSAM bahirapi pariSkAriSyate| ");
INSERT INTO sanhk_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","hanta kapaTina upAdhyAyAH phirUzinazca, yUyaM zuklIkRtazmazAnasvarUpA bhavatha, yathA zmazAnabhavanasya bahizcAru, kintvabhyantaraM mRtalokAnAM kIkazaiH sarvvaprakAramalena ca paripUrNam; ");
INSERT INTO sanhk_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","tathaiva yUyamapi lokAnAM samakSaM bahirdhArmmikAH kintvantaHkaraNeSu kevalakApaTyAdharmmAbhyAM paripUrNAH| ");
INSERT INTO sanhk_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","hA hA kapaTina upAdhyAyAH phirUzinazca, yUyaM bhaviSyadvAdinAM zmazAnagehaM nirmmAtha, sAdhUnAM zmazAnaniketanaM zobhayatha ");
INSERT INTO sanhk_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","vadatha ca yadi vayaM sveSAM pUrvvapuruSANAM kAla asthAsyAma, tarhi bhaviSyadvAdinAM zoNitapAtane teSAM sahabhAgino nAbhaviSyAma| ");
INSERT INTO sanhk_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ato yUyaM bhaviSyadvAdighAtakAnAM santAnA iti svayameva sveSAM sAkSyaM dattha| ");
INSERT INTO sanhk_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","ato yUyaM nijapUrvvapuruSANAM parimANapAtraM paripUrayata| ");
INSERT INTO sanhk_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","re bhujagAH kRSNabhujagavaMzAH, yUyaM kathaM narakadaNDAd rakSiSyadhve| ");
INSERT INTO sanhk_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","pazyata, yuSmAkamantikam ahaM bhaviSyadvAdino buddhimata upAdhyAyAMzca preSayiSyAmi, kintu teSAM katipayA yuSmAbhi rghAniSyante, kruze ca ghAniSyante, kecid bhajanabhavane kaSAbhirAghAniSyante, nagare nagare tADiSyante ca; ");
INSERT INTO sanhk_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","tena satpuruSasya hAbilo raktapAtamArabhya berikhiyaH putraM yaM sikhariyaM yUyaM mandirayajJavedyo rmadhye hatavantaH, tadIyazoNitapAtaM yAvad asmin deze yAvatAM sAdhupuruSANAM zoNitapAto 'bhavat tat sarvveSAmAgasAM daNDA yuSmAsu varttiSyante| ");
INSERT INTO sanhk_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ahaM yuSmAnta tathyaM vadAmi, vidyamAne'smin puruSe sarvve varttiSyante| ");
INSERT INTO sanhk_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","he yirUzAlam he yirUzAlam nagari tvaM bhaviSyadvAdino hatavatI, tava samIpaM preritAMzca pASANairAhatavatI, yathA kukkuTI zAvakAn pakSAdhaH saMgRhlAti, tathA tava santAnAn saMgrahItuM ahaM bahuvAram aicchaM; kintu tvaM na samamanyathAH| ");
INSERT INTO sanhk_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","pazyata yaSmAkaM vAsasthAnam ucchinnaM tyakSyate| ");
INSERT INTO sanhk_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ahaM yuSmAn tathyaM vadAmi, yaH paramezvarasya nAmnAgacchati, sa dhanya iti vANIM yAvanna vadiSyatha, tAvat mAM puna rna drakSyatha| ");
INSERT INTO sanhk_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","anantaraM yIzu ryadA mandirAd bahi rgacchati, tadAnIM ziSyAstaM mandiranirmmANaM darzayitumAgatAH| ");
INSERT INTO sanhk_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","tato yIzustAnuvAca, yUyaM kimetAni na pazyatha? yuSmAnahaM satyaM vadAmi, etannicayanasya pASANaikamapyanyapASANeाpari na sthAsyati sarvvANi bhUmisAt kAriSyante| ");
INSERT INTO sanhk_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","anantaraM tasmin jaitunaparvvatopari samupaviSTe ziSyAstasya samIpamAgatya guptaM papracchuH, etA ghaTanAH kadA bhaviSyanti? bhavata Agamanasya yugAntasya ca kiM lakSma? tadasmAn vadatu| ");
INSERT INTO sanhk_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","tadAnIM yIzustAnavocat, avadhadvvaM, kopi yuSmAn na bhramayet| ");
INSERT INTO sanhk_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","bahavo mama nAma gRhlanta AgamiSyanti, khrISTo'hameveti vAcaM vadanto bahUn bhramayiSyanti| ");
INSERT INTO sanhk_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","yUyaJca saMgrAmasya raNasya cADambaraM zroSyatha, avadhadvvaM tena caJcalA mA bhavata, etAnyavazyaM ghaTiSyante, kintu tadA yugAnto nahi| ");
INSERT INTO sanhk_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","aparaM dezasya vipakSo dezo rAjyasya vipakSo rAjyaM bhaviSyati, sthAne sthAne ca durbhikSaM mahAmArI bhUkampazca bhaviSyanti, ");
INSERT INTO sanhk_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","etAni duHkhopakramAH| ");
INSERT INTO sanhk_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","tadAnIM lokA duHkhaM bhojayituM yuSmAn parakareSu samarpayiSyanti haniSyanti ca, tathA mama nAmakAraNAd yUyaM sarvvadezIyamanujAnAM samIpe ghRNArhA bhaviSyatha| ");
INSERT INTO sanhk_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","bahuSu vighnaM prAptavatsu parasparam RृtIyAM kRtavatsu ca eko'paraM parakareSu samarpayiSyati| ");
INSERT INTO sanhk_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","tathA bahavo mRSAbhaviSyadvAdina upasthAya bahUn bhramayiSyanti| ");
INSERT INTO sanhk_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","duSkarmmaNAM bAhulyAJca bahUnAM prema zItalaM bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","kintu yaH kazcit zeSaM yAvad dhairyyamAzrayate, saeva paritrAyiSyate| ");
INSERT INTO sanhk_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","aparaM sarvvadezIyalokAn pratimAkSI bhavituM rAjasya zubhasamAcAraH sarvvajagati pracAriSyate, etAdRzi sati yugAnta upasthAsyati| ");
INSERT INTO sanhk_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","ato yat sarvvanAzakRdghRNArhaM vastu dAniyelbhaviSyadvadinA proktaM tad yadA puNyasthAne sthApitaM drakSyatha, (yaH paThati, sa budhyatAM) ");
INSERT INTO sanhk_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","tadAnIM ye yihUdIyadeze tiSThanti, te parvvateSu palAyantAM| ");
INSERT INTO sanhk_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","yaH kazcid gRhapRSThe tiSThati, sa gRhAt kimapi vastvAnetum adheा nAvarohet| ");
INSERT INTO sanhk_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","yazca kSetre tiSThati, sopi vastramAnetuM parAvRtya na yAyAt| ");
INSERT INTO sanhk_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","tadAnIM garbhiNIstanyapAyayitrINAM durgati rbhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ato yaSmAkaM palAyanaM zItakAle vizrAmavAre vA yanna bhavet, tadarthaM prArthayadhvam| ");
INSERT INTO sanhk_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","A jagadArambhAd etatkAlaparyyanantaM yAdRzaH kadApi nAbhavat na ca bhaviSyati tAdRzo mahAklezastadAnIm upasthAsyati| ");
INSERT INTO sanhk_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","tasya klezasya samayo yadi hsvo na kriyeta, tarhi kasyApi prANino rakSaNaM bhavituM na zaknuyAt, kintu manonItamanujAnAM kRte sa kAlo hsvIkariSyate| ");
INSERT INTO sanhk_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","aparaJca pazyata, khrISTo'tra vidyate, vA tatra vidyate, tadAnIM yadI kazcid yuSmAna iti vAkyaM vadati, tathApi tat na pratIt| ");
INSERT INTO sanhk_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","yato bhAktakhrISTA bhAktabhaviSyadvAdinazca upasthAya yAni mahanti lakSmANi citrakarmmANi ca prakAzayiSyanti, tai ryadi sambhavet tarhi manonItamAnavA api bhrAmiSyante| ");
INSERT INTO sanhk_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","pazyata, ghaTanAtaH pUrvvaM yuSmAn vArttAm avAdiSam| ");
INSERT INTO sanhk_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","ataH pazyata, sa prAntare vidyata iti vAkye kenacit kathitepi bahi rmA gacchata, vA pazyata, sontaHpure vidyate, etadvAkya uktepi mA pratIta| ");
INSERT INTO sanhk_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","yato yathA vidyut pUrvvadizo nirgatya pazcimadizaM yAvat prakAzate, tathA mAnuSaputrasyApyAgamanaM bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","yatra zavastiSThati, tatreva gRdhrA milanti| ");
INSERT INTO sanhk_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","aparaM tasya klezasamayasyAvyavahitaparatra sUryyasya tejo lopsyate, candramA jyosnAM na kariSyati, nabhaso nakSatrANi patiSyanti, gagaNIyA grahAzca vicaliSyanti| ");
INSERT INTO sanhk_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","tadAnIm AkAzamadhye manujasutasya lakSma darziSyate, tato nijaparAkrameNa mahAtejasA ca meghArUDhaM manujasutaM nabhasAgacchantaM vilokya pRthivyAH sarvvavaMzIyA vilapiSyanti| ");
INSERT INTO sanhk_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","tadAnIM sa mahAzabdAyamAnatUryyA vAdakAn nijadUtAn praheSyati, te vyomna ekasImAto'parasImAM yAvat caturdizastasya manonItajanAn AnIya melayiSyanti| ");
INSERT INTO sanhk_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","uDumbarapAdapasya dRSTAntaM zikSadhvaM; yadA tasya navInAH zAkhA jAyante, pallavAdizca nirgacchati, tadA nidAghakAlaH savidho bhavatIti yUyaM jAnItha; ");
INSERT INTO sanhk_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","tadvad etA ghaTanA dRSTvA sa samayo dvAra upAsthAd iti jAnIta| ");
INSERT INTO sanhk_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","yuSmAnahaM tathyaM vadAmi, idAnIntanajanAnAM gamanAt pUrvvameva tAni sarvvANi ghaTiSyante| ");
INSERT INTO sanhk_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","nabhomedinyo rluptayorapi mama vAk kadApi na lopsyate| ");
INSERT INTO sanhk_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","aparaM mama tAtaM vinA mAnuSaH svargastho dUto vA kopi taddinaM taddaNDaJca na jJApayati| ");
INSERT INTO sanhk_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","aparaM nohe vidyamAne yAdRzamabhavat tAdRzaM manujasutasyAgamanakAlepi bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","phalato jalAplAvanAt pUrvvaM yaddinaM yAvat nohaH potaM nArohat, tAvatkAlaM yathA manuSyA bhojane pAne vivahane vivAhane ca pravRttA Asan; ");
INSERT INTO sanhk_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","aparam AplAvitoyamAgatya yAvat sakalamanujAn plAvayitvA nAnayat, tAvat te yathA na vidAmAsuH, tathA manujasutAgamanepi bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","tadA kSetrasthitayordvayoreko dhAriSyate, aparastyAjiSyate| ");
INSERT INTO sanhk_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","tathA peSaNyA piMSatyorubhayo ryoSitorekA dhAriSyate'parA tyAjiSyate| ");
INSERT INTO sanhk_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","yuSmAkaM prabhuH kasmin daNDa AgamiSyati, tad yuSmAbhi rnAvagamyate, tasmAt jAgrataH santastiSThata| ");
INSERT INTO sanhk_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","kutra yAme stena AgamiSyatIti ced gRhastho jJAtum azakSyat, tarhi jAgaritvA taM sandhiM karttitum avArayiSyat tad jAnIta| ");
INSERT INTO sanhk_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","yuSmAbhiravadhIyatAM, yato yuSmAbhi ryatra na budhyate, tatraiva daNDe manujasuta AyAsyati| ");
INSERT INTO sanhk_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","prabhu rnijaparivArAn yathAkAlaM bhojayituM yaM dAsam adhyakSIkRtya sthApayati, tAdRzo vizvAsyo dhImAn dAsaH kaH? ");
INSERT INTO sanhk_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","prabhurAgatya yaM dAsaM tathAcarantaM vIkSate, saeva dhanyaH| ");
INSERT INTO sanhk_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","yuSmAnahaM satyaM vadAmi, sa taM nijasarvvasvasyAdhipaM kariSyati| ");
INSERT INTO sanhk_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","kintu prabhurAgantuM vilambata iti manasi cintayitvA yo duSTo dAso ");
INSERT INTO sanhk_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","'paradAsAn praharttuM mattAnAM saGge bhoktuM pAtuJca pravarttate, ");
INSERT INTO sanhk_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","sa dAso yadA nApekSate, yaJca daNDaM na jAnAti, tatkAlaeva tatprabhurupasthAsyati| ");
INSERT INTO sanhk_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","tadA taM daNDayitvA yatra sthAne rodanaM dantagharSaNaJcAsAte, tatra kapaTibhiH sAkaM taddazAM nirUpayiSyati| ");
INSERT INTO sanhk_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","yA daza kanyAH pradIpAn gRhlatyo varaM sAkSAt karttuM bahiritAH, tAbhistadA svargIyarAjyasya sAdRzyaM bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","tAsAM kanyAnAM madhye paJca sudhiyaH paJca durdhiya Asan| ");
INSERT INTO sanhk_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","yA durdhiyastAH pradIpAn saGge gRhItvA tailaM na jagRhuH, ");
INSERT INTO sanhk_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","kintu sudhiyaH pradIpAn pAtreNa tailaJca jagRhuH| ");
INSERT INTO sanhk_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","anantaraM vare vilambite tAH sarvvA nidrAviSTA nidrAM jagmuH| ");
INSERT INTO sanhk_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","anantaram arddharAtre pazyata vara Agacchati, taM sAkSAt karttuM bahiryAteti janaravAt ");
INSERT INTO sanhk_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","tAH sarvvAH kanyA utthAya pradIpAn AsAdayituM Arabhanta| ");
INSERT INTO sanhk_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","tato durdhiyaH sudhiya UcuH, kiJcit tailaM datta, pradIpA asmAkaM nirvvANAH| ");
INSERT INTO sanhk_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","kintu sudhiyaH pratyavadan, datte yuSmAnasmAMzca prati tailaM nyUnIbhavet, tasmAd vikretRNAM samIpaM gatvA svArthaM tailaM krINIta| ");
INSERT INTO sanhk_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","tadA tAsu kretuM gatAsu vara AjagAma, tato yAH sajjitA Asan, tAstena sAkaM vivAhIyaM vezma pravivizuH| ");
INSERT INTO sanhk_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","anantaraM dvAre ruddhe aparAH kanyA Agatya jagaduH, he prabho, he prabho, asmAn prati dvAraM mocaya| ");
INSERT INTO sanhk_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","kintu sa uktavAn, tathyaM vadAmi, yuSmAnahaM na vedmi| ");
INSERT INTO sanhk_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","ato jAgrataH santastiSThata, manujasutaH kasmin dine kasmin daNDe vAgamiSyati, tad yuSmAbhi rna jJAyate| ");
INSERT INTO sanhk_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","aparaM sa etAdRzaH kasyacit puMsastulyaH, yo dUradezaM prati yAtrAkAle nijadAsAn AhUya teSAM svasvasAmarthyAnurUpam ");
INSERT INTO sanhk_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ekasmin mudrANAM paJca poTalikAH anyasmiMzca dve poTalike aparasmiMzca poTalikaikAm itthaM pratijanaM samarpya svayaM pravAsaM gatavAn| ");
INSERT INTO sanhk_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","anantaraM yo dAsaH paJca poTalikAH labdhavAn, sa gatvA vANijyaM vidhAya tA dviguNIcakAra| ");
INSERT INTO sanhk_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","yazca dAso dve poTalike alabhata, sopi tA mudrA dviguNIcakAra| ");
INSERT INTO sanhk_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","kintu yo dAsa ekAM poTalikAM labdhavAn, sa gatvA bhUmiM khanitvA tanmadhye nijaprabhostA mudrA gopayAJcakAra| ");
INSERT INTO sanhk_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","tadanantaraM bahutithe kAle gate teSAM dAsAnAM prabhurAgatya tairdAsaiH samaM gaNayAJcakAra| ");
INSERT INTO sanhk_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","tadAnIM yaH paJca poTalikAH prAptavAn sa tA dviguNIkRtamudrA AnIya jagAda; he prabho, bhavatA mayi paJca poTalikAH samarpitAH, pazyatu, tA mayA dviguNIkRtAH| ");
INSERT INTO sanhk_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","tadAnIM tasya prabhustamuvAca, he uttama vizvAsya dAsa, tvaM dhanyosi, stokena vizvAsyo jAtaH, tasmAt tvAM bahuvittAdhipaM karomi, tvaM svaprabhoH sukhasya bhAgI bhava| ");
INSERT INTO sanhk_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","tato yena dve poTalike labdhe sopyAgatya jagAda, he prabho, bhavatA mayi dve poTalike samarpite, pazyatu te mayA dviguNIkRte| ");
INSERT INTO sanhk_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","tena tasya prabhustamavocat, he uttama vizvAsya dAsa, tvaM dhanyosi, stokena vizvAsyo jAtaH, tasmAt tvAM bahudraviNAdhipaM karomi, tvaM nijaprabhoH sukhasya bhAgI bhava| ");
INSERT INTO sanhk_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","anantaraM ya ekAM poTalikAM labdhavAn, sa etya kathitavAn, he prabho, tvAM kaThinanaraM jJAtavAn, tvayA yatra noptaM, tatraiva kRtyate, yatra ca na kIrNaM, tatraiva saMgRhyate| ");
INSERT INTO sanhk_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","atohaM sazaGkaH san gatvA tava mudrA bhUmadhye saMgopya sthApitavAn, pazya, tava yat tadeva gRhANa| ");
INSERT INTO sanhk_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","tadA tasya prabhuH pratyavadat re duSTAlasa dAsa, yatrAhaM na vapAmi, tatra chinadmi, yatra ca na kirAmi, tatreva saMgRhlAmIti cedajAnAstarhi ");
INSERT INTO sanhk_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","vaNikSu mama vittArpaNaM tavocitamAsIt, yenAhamAgatya vRdvyA sAkaM mUlamudrAH prApsyam| ");
INSERT INTO sanhk_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","atosmAt tAM poTalikAm AdAya yasya daza poTalikAH santi tasminnarpayata| ");
INSERT INTO sanhk_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","yena vardvyate tasminnaivArpiSyate, tasyaiva ca bAhulyaM bhaviSyati, kintu yena na vardvyate, tasyAntike yat kiJcana tiSThati, tadapi punarneSyate| ");
INSERT INTO sanhk_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","aparaM yUyaM tamakarmmaNyaM dAsaM nItvA yatra sthAne krandanaM dantagharSaNaJca vidyete, tasmin bahirbhUtatamasi nikSipata| ");
INSERT INTO sanhk_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","yadA manujasutaH pavitradUtAn saGginaH kRtvA nijaprabhAvenAgatya nijatejomaye siMhAsane nivekSyati, ");
INSERT INTO sanhk_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","tadA tatsammukhe sarvvajAtIyA janA saMmeliSyanti| tato meSapAlako yathA chAgebhyo'vIn pRthak karoti tathA sopyekasmAdanyam itthaM tAn pRthaka kRtvAvIn ");
INSERT INTO sanhk_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","dakSiNe chAgAMzca vAme sthApayiSyati| ");
INSERT INTO sanhk_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","tataH paraM rAjA dakSiNasthitAn mAnavAn vadiSyati, Agacchata mattAtasyAnugrahabhAjanAni, yuSmatkRta A jagadArambhat yad rAjyam AsAditaM tadadhikuruta| ");
INSERT INTO sanhk_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","yato bubhukSitAya mahyaM bhojyam adatta, pipAsitAya peyamadatta, videzinaM mAM svasthAnamanayata, ");
INSERT INTO sanhk_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","vastrahInaM mAM vasanaM paryyadhApayata, pIDItaM mAM draSTumAgacchata, kArAsthaJca mAM vIkSituma Agacchata| ");
INSERT INTO sanhk_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","tadA dhArmmikAH prativadiSyanti, he prabho, kadA tvAM kSudhitaM vIkSya vayamabhojayAma? vA pipAsitaM vIkSya apAyayAma? ");
INSERT INTO sanhk_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","kadA vA tvAM videzinaM vilokya svasthAnamanayAma? kadA vA tvAM nagnaM vIkSya vasanaM paryyadhApayAma? ");
INSERT INTO sanhk_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","kadA vA tvAM pIDitaM kArAsthaJca vIkSya tvadantikamagacchAma? ");
INSERT INTO sanhk_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","tadAnIM rAjA tAn prativadiSyati, yuSmAnahaM satyaM vadAmi, mamaiteSAM bhrAtRNAM madhye kaJcanaikaM kSudratamaM prati yad akuruta, tanmAM pratyakuruta| ");
INSERT INTO sanhk_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","pazcAt sa vAmasthitAn janAn vadiSyati, re zApagrastAH sarvve, zaitAne tasya dUtebhyazca yo'nantavahnirAsAdita Aste, yUyaM madantikAt tamagniM gacchata| ");
INSERT INTO sanhk_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","yato kSudhitAya mahyamAhAraM nAdatta, pipAsitAya mahyaM peyaM nAdatta, ");
INSERT INTO sanhk_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","videzinaM mAM svasthAnaM nAnayata, vasanahInaM mAM vasanaM na paryyadhApayata, pIDitaM kArAsthaJca mAM vIkSituM nAgacchata| ");
INSERT INTO sanhk_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","tadA te prativadiSyanti, he prabho, kadA tvAM kSudhitaM vA pipAsitaM vA videzinaM vA nagnaM vA pIDitaM vA kArAsthaM vIkSya tvAM nAsevAmahi? ");
INSERT INTO sanhk_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","tadA sa tAn vadiSyati, tathyamahaM yuSmAn bravImi, yuSmAbhireSAM kaJcana kSodiSThaM prati yannAkAri, tanmAM pratyeva nAkAri| ");
INSERT INTO sanhk_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","pazcAdamyanantazAstiM kintu dhArmmikA anantAyuSaM bhoktuM yAsyanti| ");
INSERT INTO sanhk_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","yIzuretAn prastAvAn samApya ziSyAnUce, ");
INSERT INTO sanhk_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","yuSmAbhi rjJAtaM dinadvayAt paraM nistAramaha upasthAsyati, tatra manujasutaH kruzena hantuM parakareSu samarpiSyate| ");
INSERT INTO sanhk_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","tataH paraM pradhAnayAjakAdhyApakaprAJcaH kiyaphAnAmno mahAyAjakasyATTAlikAyAM militvA ");
INSERT INTO sanhk_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","kenopAyena yIzuM dhRtvA hantuM zaknuyuriti mantrayAJcakruH| ");
INSERT INTO sanhk_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","kintu tairuktaM mahakAle na dharttavyaH, dhRte prajAnAM kalahena bhavituM zakyate| ");
INSERT INTO sanhk_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","tato baithaniyApure zimonAkhyasya kuSThino vezmani yIzau tiSThati ");
INSERT INTO sanhk_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","kAcana yoSA zvetopalabhAjanena mahArghyaM sugandhi tailamAnIya bhojanAyopavizatastasya zirobhyaSecat| ");
INSERT INTO sanhk_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","kintu tadAlokya tacchiSyaiH kupitairuktaM, kuta itthamapavyayate? ");
INSERT INTO sanhk_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","cedidaM vyakreSyata, tarhi bhUrimUlyaM prApya daridrebhyo vyatAriSyata| ");
INSERT INTO sanhk_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","yIzunA tadavagatya te samuditAH, yoSAmenAM kuto duHkhinIM kurutha, sA mAM prati sAdhu karmmAkArSIt| ");
INSERT INTO sanhk_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","yuSmAkamaM samIpe daridrAH satatamevAsate, kintu yuSmAkamantikehaM nAse satataM| ");
INSERT INTO sanhk_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","sA mama kAyopari sugandhitailaM siktvA mama zmazAnadAnakarmmAkArSIt| ");
INSERT INTO sanhk_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","atohaM yuSmAn tathyaM vadAmi sarvvasmin jagati yatra yatraiSa susamAcAraH pracAriSyate, tatra tatraitasyA nAryyAH smaraNArtham karmmedaM pracAriSyate| ");
INSERT INTO sanhk_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","tato dvAdazaziSyANAm ISkariyotIyayihUdAnAmaka ekaH ziSyaH pradhAnayAjakAnAmantikaM gatvA kathitavAn, ");
INSERT INTO sanhk_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","yadi yuSmAkaM kareSu yIzuM samarpayAmi, tarhi kiM dAsyatha? tadAnIM te tasmai triMzanmudrA dAtuM sthirIkRtavantaH| ");
INSERT INTO sanhk_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","sa tadArabhya taM parakareSu samarpayituM suyogaM ceSTitavAn| ");
INSERT INTO sanhk_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","anantaraM kiNvazUnyapUpaparvvaNaH prathamehni ziSyA yIzum upagatya papracchuH bhavatkRte kutra vayaM nistAramahabhojyam AyojayiSyAmaH? bhavataH kecchA? ");
INSERT INTO sanhk_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","tadA sa gaditavAn, madhyenagaramamukapuMsaH samIpaM vrajitvA vadata, guru rgaditavAn, matkAlaH savidhaH, saha ziSyaistvadAlaye nistAramahabhojyaM bhokSye| ");
INSERT INTO sanhk_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","tadA ziSyA yIzostAdRzanidezAnurUpakarmma vidhAya tatra nistAramahabhojyamAsAdayAmAsuH| ");
INSERT INTO sanhk_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","tataH sandhyAyAM satyAM dvAdazabhiH ziSyaiH sAkaM sa nyavizat| ");
INSERT INTO sanhk_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","aparaM bhuJjAna uktavAn yuSmAn tathyaM vadAmi, yuSmAkameko mAM parakareSu samarpayiSyati| ");
INSERT INTO sanhk_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","tadA te'tIva duHkhitA ekaikazo vaktumArebhire, he prabho, sa kimahaM? ");
INSERT INTO sanhk_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","tataH sa jagAda, mayA sAkaM yo jano bhojanapAtre karaM saMkSipati, sa eva mAM parakareSu samarpayiSyati| ");
INSERT INTO sanhk_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","manujasutamadhi yAdRzaM likhitamAste, tadanurUpA tadgati rbhaviSyati; kintu yena puMsA sa parakareSu samarpayiSyate, hA hA cet sa nAjaniSyata, tadA tasya kSemamabhaviSyat| ");
INSERT INTO sanhk_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","tadA yihUdAnAmA yo janastaM parakareSu samarpayiSyati, sa uktavAn, he guro, sa kimahaM? tataH sa pratyuktavAn, tvayA satyaM gaditam| ");
INSERT INTO sanhk_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","anantaraM teSAmazanakAle yIzuH pUpamAdAyezvarIyaguNAnanUdya bhaMktvA ziSyebhyaH pradAya jagAda, madvapuHsvarUpamimaM gRhItvA khAdata| ");
INSERT INTO sanhk_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","pazcAt sa kaMsaM gRhlan IzvarIyaguNAnanUdya tebhyaH pradAya kathitavAn, sarvvai ryuSmAbhiranena pAtavyaM, ");
INSERT INTO sanhk_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","yasmAdanekeSAM pApamarSaNAya pAtitaM yanmannUtnaniyamarUpazoNitaM tadetat| ");
INSERT INTO sanhk_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","aparamahaM nUtnagostanIrasaM na pAsyAmi, tAvat gostanIphalarasaM punaH kadApi na pAsyAmi| ");
INSERT INTO sanhk_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","pazcAt te gItamekaM saMgIya jaitunAkhyagiriM gatavantaH| ");
INSERT INTO sanhk_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","tadAnIM yIzustAnavocat, asyAM rajanyAmahaM yuSmAkaM sarvveSAM vighnarUpo bhaviSyAmi, yato likhitamAste, \"meSANAM rakSako yastaM prahariSyAmyahaM tataH| meSANAM nivaho nUnaM pravikIrNo bhaviSyati\"|| ");
INSERT INTO sanhk_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","kintu zmazAnAt samutthAya yuSmAkamagre'haM gAlIlaM gamiSyAmi| ");
INSERT INTO sanhk_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","pitarastaM provAca, bhavAMzcet sarvveSAM vighnarUpo bhavati, tathApi mama na bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","tato yIzunA sa uktaH, tubhyamahaM tathyaM kathayAmi, yAminyAmasyAM caraNAyudhasya ravAt pUrvvaM tvaM mAM tri rnAGgIkariSyasi| ");
INSERT INTO sanhk_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","tataH pitara uditavAn, yadyapi tvayA samaM marttavyaM, tathApi kadApi tvAM na nAGgIkariSyAmi; tathaiva sarvve ziSyAzcocuH| ");
INSERT INTO sanhk_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","anantaraM yIzuH ziSyaiH sAkaM getzimAnInAmakaM sthAnaM prasthAya tebhyaH kathitavAn, adaH sthAnaM gatvA yAvadahaM prArthayiSye tAvad yUyamatropavizata| ");
INSERT INTO sanhk_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","pazcAt sa pitaraM sivadiyasutau ca saGginaH kRtvA gatavAn, zokAkulo'tIva vyathitazca babhUva| ");
INSERT INTO sanhk_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","tAnavAdIcca mRtiyAtaneva matprANAnAM yAtanA jAyate, yUyamatra mayA sArddhaM jAgRta| ");
INSERT INTO sanhk_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","tataH sa kiJciddUraM gatvAdhomukhaH patan prArthayAJcakre, he matpitaryadi bhavituM zaknoti, tarhi kaMso'yaM matto dUraM yAtu; kintu madicchAvat na bhavatu, tvadicchAvad bhavatu| ");
INSERT INTO sanhk_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","tataH sa ziSyAnupetya tAn nidrato nirIkSya pitarAya kathayAmAsa, yUyaM mayA sAkaM daNDamekamapi jAgarituM nAzankuta? ");
INSERT INTO sanhk_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","parIkSAyAM na patituM jAgRta prArthayadhvaJca; AtmA samudyatosti, kintu vapu rdurbbalaM| ");
INSERT INTO sanhk_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","sa dvitIyavAraM prArthayAJcakre, he mattAta, na pIte yadi kaMsamidaM matto dUraM yAtuM na zaknoti, tarhi tvadicchAvad bhavatu| ");
INSERT INTO sanhk_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","sa punaretya tAn nidrato dadarza, yatasteSAM netrANi nidrayA pUrNAnyAsan| ");
INSERT INTO sanhk_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","pazcAt sa tAn vihAya vrajitvA tRtIyavAraM pUrvvavat kathayan prArthitavAn| ");
INSERT INTO sanhk_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","tataH ziSyAnupAgatya gaditavAn, sAmprataM zayAnAH kiM vizrAmyatha? pazyata, samaya upAsthAt, manujasutaH pApinAM kareSu samarpyate| ");
INSERT INTO sanhk_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","uttiSThata, vayaM yAmaH, yo mAM parakareSu masarpayiSyati, pazyata, sa samIpamAyAti| ");
INSERT INTO sanhk_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","etatkathAkathanakAle dvAdazaziSyANAmeko yihUdAnAmako mukhyayAjakalokaprAcInaiH prahitAn asidhAriyaSTidhAriNo manujAn gRhItvA tatsamIpamupatasthau| ");
INSERT INTO sanhk_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","asau parakareSvarpayitA pUrvvaM tAn itthaM saGketayAmAsa, yamahaM cumbiSye, so'sau manujaH,saeva yuSmAbhi rdhAryyatAM| ");
INSERT INTO sanhk_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","tadA sa sapadi yIzumupAgatya he guro, praNamAmItyuktvA taM cucumbe| ");
INSERT INTO sanhk_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","tadA yIzustamuvAca, he mitraM kimarthamAgatosi? tadA tairAgatya yIzurAkramya daghre| ");
INSERT INTO sanhk_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","tato yIzoH saGginAmekaH karaM prasAryya koSAdasiM bahiSkRtya mahAyAjakasya dAsamekamAhatya tasya karNaM ciccheda| ");
INSERT INTO sanhk_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","tato yIzustaM jagAda, khaDgaM svasthAneे nidhehi yato ye ye janA asiM dhArayanti, taevAsinA vinazyanti| ");
INSERT INTO sanhk_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","aparaM pitA yathA madantikaM svargIyadUtAnAM dvAdazavAhinIto'dhikaM prahiNuyAt mayA tamuddizyedAnImeva tathA prArthayituM na zakyate, tvayA kimitthaM jJAyate? ");
INSERT INTO sanhk_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","tathA satItthaM ghaTiSyate dharmmapustakasya yadidaM vAkyaM tat kathaM sidhyet? ");
INSERT INTO sanhk_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","tadAnIM yIzu rjananivahaM jagAda, yUyaM khaDgayaSTIn AdAya mAM kiM cauraM dharttumAyAtAH? ahaM pratyahaM yuSmAbhiH sAkamupavizya samupAdizaM, tadA mAM nAdharata; ");
INSERT INTO sanhk_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","kintu bhaviSyadvAdinAM vAkyAnAM saMsiddhaye sarvvametadabhUt|tadA sarvve ziSyAstaM vihAya palAyanta| ");
INSERT INTO sanhk_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","anantaraM te manujA yIzuM dhRtvA yatrAdhyApakaprAJcaH pariSadaM kurvvanta upAvizan tatra kiyaphAnAाmakamahAyAjakasyAntikaM ninyuH| ");
INSERT INTO sanhk_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","kintu zeSe kiM bhaviSyatIti vettuM pitaro dUre tatpazcAd vrajitvA mahAyAjakasyATTAlikAM pravizya dAsaiH sahita upAvizat| ");
INSERT INTO sanhk_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","tadAnIM pradhAnayAjakaprAcInamantriNaH sarvve yIzuM hantuM mRSAsAkSyam alipsanta, ");
INSERT INTO sanhk_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","kintu na lebhire| anekeSu mRSAsAkSiSvAgateSvapi tanna prApuH| ");
INSERT INTO sanhk_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","zeSe dvau mRSAsAkSiNAvAgatya jagadatuH, pumAnayamakathayat, ahamIzvaramandiraM bhaMktvA dinatrayamadhye tannirmmAtuM zaknomi| ");
INSERT INTO sanhk_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","tadA mahAyAjaka utthAya yIzum avAdIt| tvaM kimapi na prativadasi? tvAmadhi kimete sAkSyaM vadanti? ");
INSERT INTO sanhk_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","kintu yIzu rmaunIbhUya tasyau| tato mahAyAjaka uktavAn, tvAm amarezvaranAmnA zapayAmi, tvamIzvarasya putro'bhiSikto bhavasi naveti vada| ");
INSERT INTO sanhk_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","yIzuH pratyavadat, tvaM satyamuktavAn; ahaM yuSmAn tathyaM vadAmi, itaHparaM manujasutaM sarvvazaktimato dakSiNapArzve sthAtuM gagaNasthaM jaladharAnAruhyAyAntaM vIkSadhve| ");
INSERT INTO sanhk_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","tadA mahAyAjako nijavasanaM chittvA jagAda, eSa IzvaraM ninditavAn, asmAkamaparasAkSyeNa kiM prayojanaM? pazyata, yUyamevAsyAsyAd IzvaranindAM zrutavantaH, ");
INSERT INTO sanhk_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","yuSmAbhiH kiM vivicyate? te pratyUcuH, vadhArho'yaM| ");
INSERT INTO sanhk_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","tato lokaistadAsye niSThIvitaM kecit pratalamAhatya kecicca capeTamAhatya babhASire, ");
INSERT INTO sanhk_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","he khrISTa tvAM kazcapeTamAhatavAn? iti gaNayitvA vadAsmAn| ");
INSERT INTO sanhk_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","pitaro bahiraGgana upavizati, tadAnImekA dAsI tamupAgatya babhASe, tvaM gAlIlIyayIzoH sahacaraekaH| ");
INSERT INTO sanhk_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","kintu sa sarvveSAM samakSam anaGgIkRtyAvAdIt, tvayA yaducyate, tadarthamahaM na vedmi| ");
INSERT INTO sanhk_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","tadA tasmin bahirdvAraM gate 'nyA dAsI taM nirIkSya tatratyajanAnavadat, ayamapi nAsaratIyayIzunA sArddham AsIt| ");
INSERT INTO sanhk_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","tataH sa zapathena punaranaGgIkRtya kathitavAn, taM naraM na paricinomi| ");
INSERT INTO sanhk_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","kSaNAt paraM tiSThanto janA etya pitaram avadan, tvamavazyaM teSAmeka iti tvaduccAraNameva dyotayati| ");
INSERT INTO sanhk_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","kintu so'bhizapya kathitavAn, taM janaM nAhaM paricinomi, tadA sapadi kukkuTo rurAva| ");
INSERT INTO sanhk_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","kukkuTaravAt prAk tvaM mAM trirapAhnoSyase, yaiSA vAg yIzunAvAdi tAM pitaraH saMsmRtya bahiritvA khedAd bhRzaM cakranda| ");
INSERT INTO sanhk_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","prabhAte jAte pradhAnayAjakalokaprAcInA yIzuM hantuM tatpratikUlaM mantrayitvA ");
INSERT INTO sanhk_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","taM badvvA nItvA pantIyapIlAtAkhyAdhipe samarpayAmAsuH| ");
INSERT INTO sanhk_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","tato yIzoH parakarevvarpayitA yihUdAstatprANAdaNDAjJAM viditvA santaptamanAH pradhAnayAjakalokaprAcInAnAM samakSaM tAstrIMzanmudrAH pratidAyAvAdIt, ");
INSERT INTO sanhk_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","etannirAgonaraprANaparakarArpaNAt kaluSaM kRtavAnahaM| tadA ta uditavantaH, tenAsmAkaM kiM? tvayA tad budhyatAm| ");
INSERT INTO sanhk_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","tato yihUdA mandiramadhye tA mudrA nikSipya prasthitavAn itvA ca svayamAtmAnamudbabandha| ");
INSERT INTO sanhk_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","pazcAt pradhAnayAjakAstA mudrA AdAya kathitavantaH, etA mudrAH zoNitamUlyaM tasmAd bhANDAgAre na nidhAtavyAH| ");
INSERT INTO sanhk_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","anantaraM te mantrayitvA videzinAM zmazAnasthAnAya tAbhiH kulAlasya kSetramakrINan| ");
INSERT INTO sanhk_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ato'dyApi tatsthAnaM raktakSetraM vadanti| ");
INSERT INTO sanhk_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","itthaM sati isrAyelIyasantAnai ryasya mUlyaM nirupitaM, tasya triMzanmudrAmAnaM mUlyaM ");
INSERT INTO sanhk_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","mAM prati paramezvarasyAdezAt tebhya AdIyata, tena ca kulAlasya kSetraM krItamiti yadvacanaM yirimiyabhaviSyadvAdinA proktaM tat tadAsidhyat| ");
INSERT INTO sanhk_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","anantaraM yIzau tadadhipateH sammukha upatiSThati sa taM papraccha, tvaM kiM yihUdIyAnAM rAjA? tadA yIzustamavadat, tvaM satyamuktavAn| ");
INSERT INTO sanhk_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","kintu pradhAnayAjakaprAcInairabhiyuktena tena kimapi na pratyavAdi| ");
INSERT INTO sanhk_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","tataH pIlAtena sa uditaH, ime tvatpratikUlataH kati kati sAkSyaM dadati, tat tvaM na zRNoSi? ");
INSERT INTO sanhk_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","tathApi sa teSAmekasyApi vacasa uttaraM noditavAn; tena so'dhipati rmahAcitraM vidAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","anyacca tanmahakAle'dhipateretAdRzI rAtirAsIt, prajA yaM kaJcana bandhinaM yAcante, tameva sa mocayatIti| ");
INSERT INTO sanhk_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","tadAnIM barabbAnAmA kazcit khyAtabandhyAsIt| ");
INSERT INTO sanhk_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","tataH pIlAtastatra militAn lokAn apRcchat, eSa barabbA bandhI khrISTavikhyAto yIzuzcaitayoH kaM mocayiSyAmi? yuSmAkaM kimIpsitaM? ");
INSERT INTO sanhk_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","tairIrSyayA sa samarpita iti sa jJAtavAn| ");
INSERT INTO sanhk_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","aparaM vicArAsanopavezanakAle pIlAtasya patnI bhRtyaM prahitya tasmai kathayAmAsa, taM dhArmmikamanujaM prati tvayA kimapi na karttavyaM; yasmAt tatkRte'dyAhaM svapne prabhUtakaSTamalabhe| ");
INSERT INTO sanhk_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","anantaraM pradhAnayAjakaprAcInA barabbAM yAcitvAdAtuM yIzuJca hantuM sakalalokAn prAvarttayan| ");
INSERT INTO sanhk_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","tato'dhipatistAn pRSTavAn, etayoH kamahaM mocayiSyAmi? yuSmAkaM kecchA? te procu rbarabbAM| ");
INSERT INTO sanhk_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","tadA pIlAtaH papraccha, tarhi yaM khrISTaM vadanti, taM yIzuM kiM kariSyAmi? sarvve kathayAmAsuH, sa kruzena vidhyatAM| ");
INSERT INTO sanhk_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","tato'dhipatiravAdIt, kutaH? kiM tenAparAddhaM? kintu te punarucai rjagaduH, sa kruzena vidhyatAM| ");
INSERT INTO sanhk_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","tadA nijavAkyamagrAhyamabhUt, kalahazcApyabhUt, pIlAta iti vilokya lokAnAM samakSaM toyamAdAya karau prakSAlyAvocat, etasya dhArmmikamanuSyasya zoNitapAte nirdoSo'haM, yuSmAbhireva tad budhyatAM| ");
INSERT INTO sanhk_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","tadA sarvvAH prajAH pratyavocan, tasya zoNitapAtAparAdho'smAkam asmatsantAnAnAJcopari bhavatu| ");
INSERT INTO sanhk_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","tataH sa teSAM samIpe barabbAM mocayAmAsa yIzuntu kaSAbhirAhatya kruzena vedhituM samarpayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","anantaram adhipateH senA adhipate rgRhaM yIzumAnIya tasya samIpe senAsamUhaM saMjagRhuH| ");
INSERT INTO sanhk_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","tataste tasya vasanaM mocayitvA kRSNalohitavarNavasanaM paridhApayAmAsuH ");
INSERT INTO sanhk_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","kaNTakAnAM mukuTaM nirmmAya tacchirasi daduH, tasya dakSiNakare vetramekaM dattvA tasya sammukhe jAnUni pAtayitvA, he yihUdIyAnAM rAjan, tubhyaM nama ityuktvA taM tirazcakruH, ");
INSERT INTO sanhk_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","tatastasya gAtre niSThIvaM datvA tena vetreNa zira AjaghnuH| ");
INSERT INTO sanhk_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","itthaM taM tiraskRtya tad vasanaM mocayitvA punarnijavasanaM paridhApayAJcakruH, taM kruzena vedhituM nItavantaH| ");
INSERT INTO sanhk_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","pazcAtte bahirbhUya kurINIyaM zimonnAmakamekaM vilokya kruzaM voDhuM tamAdadire| ");
INSERT INTO sanhk_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","anantaraM gulgaltAm arthAt ziraskapAlanAmakasthAnamu pasthAya te yIzave pittamizritAmlarasaM pAtuM daduH, ");
INSERT INTO sanhk_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","kintu sa tamAsvAdya na papau| ");
INSERT INTO sanhk_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","tadAnIM te taM kruzena saMvidhya tasya vasanAni guTikApAtena vibhajya jagRhuH, tasmAt, vibhajante'dharIyaM me te manuSyAH parasparaM| maduttarIyavastrArthaM guTikAM pAtayanti ca||yadetadvacanaM bhaviSyadvAdibhiruktamAsIt, tadA tad asidhyat, ");
INSERT INTO sanhk_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","pazcAt te tatropavizya tadrakSaNakarvvaNi niyuktAstasthuH| ");
INSERT INTO sanhk_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","aparam eSa yihUdIyAnAM rAjA yIzurityapavAdalipipatraM tacchirasa Urdvve yojayAmAsuH| ");
INSERT INTO sanhk_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","tatastasya vAme dakSiNe ca dvau cairau tena sAkaM kruzena vividhuH| ");
INSERT INTO sanhk_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","tadA pAnthA nijaziro lADayitvA taM nindanto jagaduH, ");
INSERT INTO sanhk_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","he IzvaramandirabhaJjaka dinatraye tannirmmAtaH svaM rakSa, cettvamIzvarasutastarhi kruzAdavaroha| ");
INSERT INTO sanhk_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","pradhAnayAjakAdhyApakaprAcInAzca tathA tiraskRtya jagaduH, ");
INSERT INTO sanhk_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","so'nyajanAnAvat, kintu svamavituM na zaknoti| yadIsrAyelo rAjA bhavet, tarhIdAnImeva kruzAdavarohatu, tena taM vayaM pratyeSyAmaH| ");
INSERT INTO sanhk_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","sa Izvare pratyAzAmakarot, yadIzvarastasmin santuSTastarhIdAnImeva tamavet, yataH sa uktavAn ahamIzvarasutaH| ");
INSERT INTO sanhk_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","yau stenau sAkaM tena kruzena viddhau tau tadvadeva taM ninindatuH| ");
INSERT INTO sanhk_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","tadA dvitIyayAmAt tRtIyayAmaM yAvat sarvvadeze tamiraM babhUva, ");
INSERT INTO sanhk_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","tRtIyayAme \"elI elI lAmA zivaktanI\", arthAt madIzvara madIzvara kuto mAmatyAkSIH? yIzuruccairiti jagAda| ");
INSERT INTO sanhk_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","tadA tatra sthitAH kecit tat zrutvA babhASire, ayam eliyamAhUyati| ");
INSERT INTO sanhk_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","teSAM madhyAd ekaH zIghraM gatvA spaJjaM gRhItvA tatrAmlarasaM dattvA nalena pAtuM tasmai dadau| ");
INSERT INTO sanhk_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","itare'kathayan tiSThata, taM rakSitum eliya AyAti naveti pazyAmaH| ");
INSERT INTO sanhk_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","yIzuH punarucairAhUya prANAn jahau| ");
INSERT INTO sanhk_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","tato mandirasya vicchedavasanam UrdvvAdadho yAvat chidyamAnaM dvidhAbhavat, ");
INSERT INTO sanhk_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","bhUmizcakampe bhUdharovyadIryyata ca| zmazAne mukte bhUripuNyavatAM suptadehA udatiSThan, ");
INSERT INTO sanhk_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","zmazAnAd vahirbhUya tadutthAnAt paraM puNyapuraM gatvA bahujanAn darzayAmAsuH| ");
INSERT INTO sanhk_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","yIzurakSaNAya niyuktaH zatasenApatistatsaGginazca tAdRzIM bhUkampAdighaTanAM dRSTvA bhItA avadan, eSa Izvaraputro bhavati| ");
INSERT INTO sanhk_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","yA bahuyoSito yIzuM sevamAnA gAlIlastatpazcAdAgatAstAsAM madhye ");
INSERT INTO sanhk_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","magdalInI mariyam yAkUbyozyo rmAtA yA mariyam sibadiyaputrayo rmAtA ca yoSita etA dUre tiSThantyo dadRzuH| ");
INSERT INTO sanhk_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","sandhyAyAM satyam arimathiyAnagarasya yUSaphnAmA dhanI manujo yIzoH ziSyatvAt ");
INSERT INTO sanhk_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","pIlAtasya samIpaM gatvA yIzoH kAyaM yayAce, tena pIlAtaH kAyaM dAtum Adideza| ");
INSERT INTO sanhk_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","yUSaph tatkAyaM nItvA zucivastreNAcchAdya ");
INSERT INTO sanhk_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","svArthaM zaile yat zmazAnaM cakhAna, tanmadhye tatkAyaM nidhAya tasya dvAri vRhatpASANaM dadau| ");
INSERT INTO sanhk_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","kintu magdalInI mariyam anyamariyam ete striyau tatra zmazAnasammukha upavivizatuH| ");
INSERT INTO sanhk_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","tadanantaraM nistArotsavasyAyojanadinAt pare'hani pradhAnayAjakAH phirUzinazca militvA pIlAtamupAgatyAkathayan, ");
INSERT INTO sanhk_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","he maheccha sa pratArako jIvana akathayat, dinatrayAt paraM zmazAnAdutthAsyAmi tadvAkyaM smarAmo vayaM; ");
INSERT INTO sanhk_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","tasmAt tRtIyadinaM yAvat tat zmazAnaM rakSitumAdizatu, nocet tacchiSyA yAminyAmAgatya taM hRtvA lokAn vadiSyanti, sa zmazAnAdudatiSThat, tathA sati prathamabhrAnteH zeSIyabhrAnti rmahatI bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","tadA pIlAta avAdIt, yuSmAkaM samIpe rakSigaNa Aste, yUyaM gatvA yathA sAdhyaM rakSayata| ");
INSERT INTO sanhk_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","tataste gatvA taddUाrapASANaM mudrAGkitaM kRtvA rakSigaNaM niyojya zmazAnaM rakSayAmAsuH| ");
INSERT INTO sanhk_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","tataH paraM vizrAmavArasya zeSe saptAhaprathamadinasya prabhote jAte magdalInI mariyam anyamariyam ca zmazAnaM draSTumAgatA| ");
INSERT INTO sanhk_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","tadA mahAn bhUkampo'bhavat; paramezvarIyadUtaH svargAdavaruhya zmazAnadvArAt pASANamapasAryya taduparyyupaviveza| ");
INSERT INTO sanhk_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","tadvadanaM vidyudvat tejomayaM vasanaM himazubhraJca| ");
INSERT INTO sanhk_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","tadAnIM rakSiNastadbhayAt kampitA mRtavad babhUvaH| ");
INSERT INTO sanhk_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","sa dUto yoSito jagAda, yUyaM mA bhaiSTa, kruzahatayIzuM mRgayadhve tadahaM vedmi| ");
INSERT INTO sanhk_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","so'tra nAsti, yathAvadat tathotthitavAn; etat prabhoH zayanasthAnaM pazyata| ");
INSERT INTO sanhk_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","tUrNaM gatvA tacchiSyAn iti vadata, sa zmazAnAd udatiSThat, yuSmAkamagre gAlIlaM yAsyati yUyaM tatra taM vIkSiSyadhve, pazyatAhaM vArttAmimAM yuSmAnavAdiSaM| ");
INSERT INTO sanhk_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","tatastA bhayAt mahAnandAJca zmazAnAt tUrNaM bahirbhUya tacchiSyAn vArttAM vaktuM dhAvitavatyaH| kintu ziSyAn vArttAM vaktuM yAnti, tadA yIzu rdarzanaM dattvA tA jagAda, ");
INSERT INTO sanhk_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","yuSmAkaM kalyANaM bhUyAt, tatastA Agatya tatpAdayoH patitvA praNemuH| ");
INSERT INTO sanhk_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","yIzustA avAdIt, mA bibhIta, yUyaM gatvA mama bhrAtRn gAlIlaM yAtuM vadata, tatra te mAM drakSyanti| ");
INSERT INTO sanhk_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","striyo gacchanti, tadA rakSiNAM kecit puraM gatvA yadyad ghaTitaM tatsarvvaM pradhAnayAjakAn jJApitavantaH| ");
INSERT INTO sanhk_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","te prAcInaiH samaM saMsadaM kRtvA mantrayanto bahumudrAH senAbhyo dattvAvadan, ");
INSERT INTO sanhk_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","asmAsu nidriteSu tacchiSyA yAminyAmAgatya taM hRtvAnayan, iti yUyaM pracArayata| ");
INSERT INTO sanhk_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","yadyetadadhipateH zrotragocarIbhavet, tarhi taM bodhayitvA yuSmAnaviSyAmaH| ");
INSERT INTO sanhk_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","tataste mudrA gRhItvA zikSAnurUpaM karmma cakruH, yihUdIyAnAM madhye tasyAdyApi kiMvadantI vidyate| ");
INSERT INTO sanhk_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ekAdaza ziSyA yIzunirUpitAgAlIlasyAdriM gatvA ");
INSERT INTO sanhk_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","tatra taM saMvIkSya praNemuH, kintu kecit sandigdhavantaH| ");
INSERT INTO sanhk_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","yIzusteSAM samIpamAgatya vyAhRtavAn, svargamedinyoH sarvvAdhipatitvabhAro mayyarpita Aste| ");
INSERT INTO sanhk_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ato yUyaM prayAya sarvvadezIyAn ziSyAn kRtvA pituH putrasya pavitrasyAtmanazca nAmnA tAnavagAhayata; ahaM yuSmAn yadyadAdizaM tadapi pAlayituM tAnupAdizata| ");
INSERT INTO sanhk_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","pazyata, jagadantaM yAvat sadAhaM yuSmAbhiH sAkaM tiSThAmi| iti|");
INSERT INTO sanhk_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Izvaraputrasya yIzukhrISTasya susaMvAdArambhaH| ");
INSERT INTO sanhk_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","bhaviSyadvAdinAM grantheSu lipiritthamAste, pazya svakIyadUtantu tavAgre preSayAmyaham| gatvA tvadIyapanthAnaM sa hi pariSkariSyati| ");
INSERT INTO sanhk_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","\"paramezasya panthAnaM pariSkuruta sarvvataH| tasya rAjapathaJcaiva samAnaM kurutAdhunA|\" ityetat prAntare vAkyaM vadataH kasyacidravaH|| ");
INSERT INTO sanhk_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","saeva yohan prAntare majjitavAn tathA pApamArjananimittaM manovyAvarttakamajjanasya kathAJca pracAritavAn| ");
INSERT INTO sanhk_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","tato yihUdAdezayirUzAlamnagaranivAsinaH sarvve lokA bahi rbhUtvA tasya samIpamAgatya svAni svAni pApAnyaGgIkRtya yarddananadyAM tena majjitA babhUvuH| ");
INSERT INTO sanhk_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","asya yohanaH paridheyAni kramelakalomajAni, tasya kaTibandhanaM carmmajAtam, tasya bhakSyANi ca zUkakITA vanyamadhUni cAsan| ");
INSERT INTO sanhk_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","sa pracArayan kathayAJcakre, ahaM namrIbhUya yasya pAdukAbandhanaM mocayitumapi na yogyosmi, tAdRzo matto gurutara ekaH puruSo matpazcAdAgacchati| ");
INSERT INTO sanhk_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ahaM yuSmAn jale majjitavAn kintu sa pavitra AtmAni saMmajjayiSyati| ");
INSERT INTO sanhk_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","aparaJca tasminneva kAle gAlIlpradezasya nAsaradgrAmAd yIzurAgatya yohanA yarddananadyAM majjito'bhUt| ");
INSERT INTO sanhk_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","sa jalAdutthitamAtro meghadvAraM muktaM kapotavat svasyopari avarohantamAtmAnaJca dRSTavAn| ");
INSERT INTO sanhk_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","tvaM mama priyaH putrastvayyeva mamamahAsantoSa iyamAkAzIyA vANI babhUva| ");
INSERT INTO sanhk_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","tasmin kAle AtmA taM prAntaramadhyaM ninAya| ");
INSERT INTO sanhk_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","atha sa catvAriMzaddinAni tasmin sthAne vanyapazubhiH saha tiSThan zaitAnA parIkSitaH; pazcAt svargIyadUtAstaM siSevire| ");
INSERT INTO sanhk_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","anantaraM yohani bandhanAlaye baddhe sati yIzu rgAlIlpradezamAgatya IzvararAjyasya susaMvAdaM pracArayan kathayAmAsa, ");
INSERT INTO sanhk_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","kAlaH sampUrNa IzvararAjyaJca samIpamAgataM; atoheto ryUyaM manAMsi vyAvarttayadhvaM susaMvAde ca vizvAsita| ");
INSERT INTO sanhk_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","tadanantaraM sa gAlIlIyasamudrasya tIre gacchan zimon tasya bhrAtA andriyanAmA ca imau dvau janau matsyadhAriNau sAgaramadhye jAlaM prakSipantau dRSTvA tAvavadat, ");
INSERT INTO sanhk_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","yuvAM mama pazcAdAgacchataM, yuvAmahaM manuSyadhAriNau kariSyAmi| ");
INSERT INTO sanhk_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","tatastau tatkSaNameva jAlAni parityajya tasya pazcAt jagmatuH| ");
INSERT INTO sanhk_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","tataH paraM tatsthAnAt kiJcid dUraM gatvA sa sivadIputrayAkUb tadbhrAtRyohan ca imau naukAyAM jAlAnAM jIrNamuddhArayantau dRSTvA tAvAhUyat| ");
INSERT INTO sanhk_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","tatastau naukAyAM vetanabhugbhiH sahitaM svapitaraM vihAya tatpazcAdIyatuH| ");
INSERT INTO sanhk_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","tataH paraM kapharnAhUmnAmakaM nagaramupasthAya sa vizrAmadivase bhajanagrahaM pravizya samupadideza| ");
INSERT INTO sanhk_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","tasyopadezAllokA AzcaryyaM menire yataH sodhyApakAiva nopadizan prabhAvavAniva propadideza| ");
INSERT INTO sanhk_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","aparaJca tasmin bhajanagRhe apavitrabhUtena grasta eko mAnuSa AsIt| sa cItzabdaM kRtvA kathayAJcake ");
INSERT INTO sanhk_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","bho nAsaratIya yIzo tvamasmAn tyaja, tvayA sahAsmAkaM kaH sambandhaH? tvaM kimasmAn nAzayituM samAgataH? tvamIzvarasya pavitraloka ityahaM jAnAmi| ");
INSERT INTO sanhk_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","tadA yIzustaM tarjayitvA jagAda tUSNIM bhava ito bahirbhava ca| ");
INSERT INTO sanhk_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","tataH so'pavitrabhUtastaM sampIDya atyucaizcItkRtya nirjagAma| ");
INSERT INTO sanhk_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","tenaiva sarvve camatkRtya parasparaM kathayAJcakrire, aho kimidaM? kIdRzo'yaM navya upadezaH? anena prabhAvenApavitrabhUteSvAjJApiteSu te tadAjJAnuvarttino bhavanti| ");
INSERT INTO sanhk_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","tadA tasya yazo gAlIlazcaturdiksthasarvvadezAn vyApnot| ");
INSERT INTO sanhk_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","aparaJca te bhajanagRhAd bahi rbhUtvA yAkUbyohanbhyAM saha zimona Andriyasya ca nivezanaM pravivizuH| ");
INSERT INTO sanhk_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","tadA pitarasya zvazrUrjvarapIDitA zayyAyAmAsta iti te taM jhaTiti vijJApayAJcakruH| ");
INSERT INTO sanhk_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","tataH sa Agatya tasyA hastaM dhRtvA tAmudasthApayat; tadaiva tAM jvaro'tyAkSIt tataH paraM sA tAn siSeve| ");
INSERT INTO sanhk_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","athAstaM gate ravau sandhyAkAle sati lokAstatsamIpaM sarvvAn rogiNo bhUtadhRtAMzca samAninyuH| ");
INSERT INTO sanhk_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","sarvve nAgarikA lokA dvAri saMmilitAzca| ");
INSERT INTO sanhk_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","tataH sa nAnAvidharogiNo bahUn manujAnarogiNazcakAra tathA bahUn bhUtAn tyAjayAJcakAra tAn bhUtAn kimapi vAkyaM vaktuM niSiSedha ca yatohetoste tamajAnan| ");
INSERT INTO sanhk_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","aparaJca so'tipratyUSe vastutastu rAtrizeSe samutthAya bahirbhUya nirjanaM sthAnaM gatvA tatra prArthayAJcakre| ");
INSERT INTO sanhk_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","anantaraM zimon tatsaGginazca tasya pazcAd gatavantaH| ");
INSERT INTO sanhk_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","taduddezaM prApya tamavadan sarvve lokAstvAM mRgayante| ");
INSERT INTO sanhk_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","tadA so'kathayat Agacchata vayaM samIpasthAni nagarANi yAmaH, yato'haM tatra kathAM pracArayituM bahirAgamam| ");
INSERT INTO sanhk_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","atha sa teSAM gAlIlpradezasya sarvveSu bhajanagRheSu kathAH pracArayAJcakre bhUtAnatyAjayaJca| ");
INSERT INTO sanhk_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","anantaramekaH kuSThI samAgatya tatsammukhe jAnupAtaM vinayaJca kRtvA kathitavAn yadi bhavAn icchati tarhi mAM pariSkarttuM zaknoti| ");
INSERT INTO sanhk_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","tataH kRpAlu ryIzuH karau prasAryya taM spaSTvA kathayAmAsa ");
INSERT INTO sanhk_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","mamecchA vidyate tvaM pariSkRto bhava| etatkathAyAH kathanamAtrAt sa kuSThI rogAnmuktaH pariSkRto'bhavat| ");
INSERT INTO sanhk_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","tadA sa taM visRjan gADhamAdizya jagAda ");
INSERT INTO sanhk_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","sAvadhAno bhava kathAmimAM kamapi mA vada; svAtmAnaM yAjakaM darzaya, lokebhyaH svapariSkRteH pramANadAnAya mUsAnirNItaM yaddAnaM tadutsRjasva ca| ");
INSERT INTO sanhk_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","kintu sa gatvA tat karmma itthaM vistAryya pracArayituM prArebhe tenaiva yIzuH punaH saprakAzaM nagaraM praveSTuM nAzaknot tatohetorbahiH kAnanasthAne tasyau; tathApi caturddigbhyo lokAstasya samIpamAyayuH| ");
INSERT INTO sanhk_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","tadanantaraM yIzai katipayadinAni vilambya punaH kapharnAhUmnagaraM praviSTe sa gRha Asta iti kiMvadantyA tatkSaNaM tatsamIpaM bahavo lokA Agatya samupatasthuH, ");
INSERT INTO sanhk_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","tasmAd gRhamadhye sarvveSAM kRte sthAnaM nAbhavad dvArasya caturdikSvapi nAbhavat, tatkAle sa tAn prati kathAM pracArayAJcakre| ");
INSERT INTO sanhk_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","tataH paraM lokAzcaturbhi rmAnavairekaM pakSAghAtinaM vAhayitvA tatsamIpam AninyuH| ");
INSERT INTO sanhk_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","kintu janAnAM bahutvAt taM yIzoH sammukhamAnetuM na zaknuvanto yasmin sthAne sa Aste taduparigRhapRSThaM khanitvA chidraM kRtvA tena mArgeNa sazayyaM pakSAghAtinam avarohayAmAsuH| ");
INSERT INTO sanhk_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","tato yIzusteSAM vizvAsaM dRSTvA taM pakSAghAtinaM babhASe he vatsa tava pApAnAM mArjanaM bhavatu| ");
INSERT INTO sanhk_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","tadA kiyanto'dhyApakAstatropavizanto manobhi rvitarkayAJcakruH, eSa manuSya etAdRzImIzvaranindAM kathAM kutaH kathayati? ");
INSERT INTO sanhk_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","IzvaraM vinA pApAni mArSTuM kasya sAmarthyam Aste? ");
INSERT INTO sanhk_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","itthaM te vitarkayanti yIzustatkSaNaM manasA tad budvvA tAnavadad yUyamantaHkaraNaiH kuta etAni vitarkayatha? ");
INSERT INTO sanhk_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","tadanantaraM yIzustatsthAnAt punaH samudrataTaM yayau; lokanivahe tatsamIpamAgate sa tAn samupadideza| ");
INSERT INTO sanhk_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","kintu pRthivyAM pApAni mArSTuM manuSyaputrasya sAmarthyamasti, etad yuSmAn jJApayituM (sa tasmai pakSAghAtine kathayAmAsa) ");
INSERT INTO sanhk_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","uttiSTha tava zayyAM gRhItvA svagRhaM yAhi, ahaM tvAmidam AjJApayAmi| ");
INSERT INTO sanhk_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","tataH sa tatkSaNam utthAya zayyAM gRhItvA sarvveSAM sAkSAt jagAma; sarvve vismitA etAdRzaM karmma vayam kadApi nApazyAma, imAM kathAM kathayitvezvaraM dhanyamabruvan| ");
INSERT INTO sanhk_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","tadanantaraM yIzustatsthAnAt punaH samudrataTaM yayau; lokanivahe tatsamIpamAgate sa tAn samupadideza| ");
INSERT INTO sanhk_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","atha gacchan karasaJcayagRha upaviSTam AlphIyaputraM leviM dRSTvA tamAhUya kathitavAn matpazcAt tvAmAmaccha tataH sa utthAya tatpazcAd yayau| ");
INSERT INTO sanhk_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","anantaraM yIzau tasya gRhe bhoktum upaviSTe bahavaH karamaJcAyinaH pApinazca tena tacchiSyaizca sahopavivizuH, yato bahavastatpazcAdAjagmuH| ");
INSERT INTO sanhk_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","tadA sa karamaJcAyibhiH pApibhizca saha khAdati, tad dRSTvAdhyApakAH phirUzinazca tasya ziSyAnUcuH karamaJcAyibhiH pApibhizca sahAyaM kuto bhuMkte pivati ca? ");
INSERT INTO sanhk_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","tadvAkyaM zrutvA yIzuH pratyuvAca,arogilokAnAM cikitsakena prayojanaM nAsti, kintu rogiNAmeva; ahaM dhArmmikAnAhvAtuM nAgataH kintu mano vyAvarttayituM pApina eva| ");
INSERT INTO sanhk_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","tataH paraM yohanaH phirUzinAJcopavAsAcAriziSyA yIzoH samIpam Agatya kathayAmAsuH, yohanaH phirUzinAJca ziSyA upavasanti kintu bhavataH ziSyA nopavasanti kiM kAraNamasya? ");
INSERT INTO sanhk_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","tadA yIzustAn babhASe yAvat kAlaM sakhibhiH saha kanyAyA varastiSThati tAvatkAlaM te kimupavastuM zaknuvanti? yAvatkAlaM varastaiH saha tiSThati tAvatkAlaM ta upavastuM na zaknuvanti| ");
INSERT INTO sanhk_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","yasmin kAle tebhyaH sakAzAd varo neSyate sa kAla Agacchati, tasmin kAle te janA upavatsyanti| ");
INSERT INTO sanhk_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","kopi janaH purAtanavastre nUtanavastraM na sIvyati, yato nUtanavastreNa saha sevane kRte jIrNaM vastraM chidyate tasmAt puna rmahat chidraM jAyate| ");
INSERT INTO sanhk_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","kopi janaH purAtanakutUSu nUtanaM drAkSArasaM na sthApayati, yato nUtanadrAkSArasasya tejasA tAH kutvo vidIryyante tato drAkSArasazca patati kutvazca nazyanti, ataeva nUtanadrAkSAraso nUtanakutUSu sthApanIyaH| ");
INSERT INTO sanhk_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","tadanantaraM yIzu ryadA vizrAmavAre zasyakSetreNa gacchati tadA tasya ziSyA gacchantaH zasyamaJjarIzchettuM pravRttAH| ");
INSERT INTO sanhk_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ataH phirUzino yIzave kathayAmAsuH pazyatu vizrAmavAsare yat karmma na karttavyaM tad ime kutaH kurvvanti? ");
INSERT INTO sanhk_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","tadA sa tebhyo'kathayat dAyUd tatsaMGginazca bhakSyAbhAvAt kSudhitAH santo yat karmma kRtavantastat kiM yuSmAbhi rna paThitam? ");
INSERT INTO sanhk_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","abiyAtharnAmake mahAyAjakatAM kurvvati sa kathamIzvarasyAvAsaM pravizya ye darzanIyapUpA yAjakAn vinAnyasya kasyApi na bhakSyAstAneva bubhuje saGgilokebhyo'pi dadau| ");
INSERT INTO sanhk_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","so'paramapi jagAda, vizrAmavAro manuSyArthameva nirUpito'sti kintu manuSyo vizrAmavArArthaM naiva| ");
INSERT INTO sanhk_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","manuSyaputro vizrAmavArasyApi prabhurAste| ");
INSERT INTO sanhk_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","anantaraM yIzuH puna rbhajanagRhaM praviSTastasmin sthAne zuSkahasta eko mAnava AsIt| ");
INSERT INTO sanhk_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","sa vizrAmavAre tamarogiNaM kariSyati navetyatra bahavastam apavadituM chidramapekSitavantaH| ");
INSERT INTO sanhk_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","tadA sa taM zuSkahastaM manuSyaM jagAda madhyasthAne tvamuttiSTha| ");
INSERT INTO sanhk_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","tataH paraM sa tAn papraccha vizrAmavAre hitamahitaM tathA hi prANarakSA vA prANanAza eSAM madhye kiM karaNIyaM ? kintu te niHzabdAstasthuH| ");
INSERT INTO sanhk_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","tadA sa teSAmantaHkaraNAnAM kAThinyAddheto rduHkhitaH krodhAt cartuिdazo dRSTavAn taM mAnuSaM gaditavAn taM hastaM vistAraya, tatastena haste vistRte taddhasto'nyahastavad arogo jAtaH| ");
INSERT INTO sanhk_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","atha phirUzinaH prasthAya taM nAzayituM herodIyaiH saha mantrayitumArebhire| ");
INSERT INTO sanhk_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ataeva yIzustatsthAnaM parityajya ziSyaiH saha punaH sAgarasamIpaM gataH; ");
INSERT INTO sanhk_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","tato gAlIlyihUdA-yirUzAlam-idom-yardannadIpArasthAnebhyo lokasamUhastasya pazcAd gataH; tadanyaH sorasIdanoH samIpavAsilokasamUhazca tasya mahAkarmmaNAM vArttaM zrutvA tasya sannidhimAgataH| ");
INSERT INTO sanhk_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","tadA lokasamUhazcet tasyopari patati ityAzaGkya sa nAvamekAM nikaTe sthApayituM ziSyAnAdiSTavAn| ");
INSERT INTO sanhk_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","yato'nekamanuSyANAmArogyakaraNAd vyAdhigrastAH sarvve taM spraSTuM parasparaM balena yatnavantaH| ");
INSERT INTO sanhk_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","aparaJca apavitrabhUtAstaM dRSTvA taccaraNayoH patitvA procaiH procuH, tvamIzvarasya putraH| ");
INSERT INTO sanhk_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","kintu sa tAn dRDham AjJApya svaM paricAyituM niSiddhavAn| ");
INSERT INTO sanhk_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","anantaraM sa parvvatamAruhya yaM yaM praticchA taM tamAhUtavAn tataste tatsamIpamAgatAH| ");
INSERT INTO sanhk_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","tadA sa dvAdazajanAn svena saha sthAtuM susaMvAdapracArAya preritA bhavituM ");
INSERT INTO sanhk_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","sarvvaprakAravyAdhInAM zamanakaraNAya prabhAvaM prAptuM bhUtAn tyAjayituJca niyuktavAn| ");
INSERT INTO sanhk_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","teSAM nAmAnImAni, zimon sivadiputro ");
INSERT INTO sanhk_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","yAkUb tasya bhrAtA yohan ca AndriyaH philipo barthalamayaH, ");
INSERT INTO sanhk_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","mathI thomA ca AlphIyaputro yAkUb thaddIyaH kinAnIyaH zimon yastaM parahasteSvarpayiSyati sa ISkariyotIyayihUdAzca| ");
INSERT INTO sanhk_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","sa zimone pitara ityupanAma dadau yAkUbyohanbhyAM ca binerigiz arthato meghanAdaputrAvityupanAma dadau| ");
INSERT INTO sanhk_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","anantaraM te nivezanaM gatAH, kintu tatrApi punarmahAn janasamAgamo 'bhavat tasmAtte bhoktumapyavakAzaM na prAptAH| ");
INSERT INTO sanhk_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","tatastasya suhRllokA imAM vArttAM prApya sa hatajJAnobhUd iti kathAM kathayitvA taM dhRtvAnetuM gatAH| ");
INSERT INTO sanhk_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","aparaJca yirUzAlama AgatA ye ye'dhyApakAste jagadurayaM puruSo bhUtapatyAbiSTastena bhUtapatinA bhUtAn tyAjayati| ");
INSERT INTO sanhk_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","tatastAnAhUya yIzu rdRSTAntaiH kathAM kathitavAn zaitAn kathaM zaitAnaM tyAjayituM zaknoti? ");
INSERT INTO sanhk_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","kiJcana rAjyaM yadi svavirodhena pRthag bhavati tarhi tad rAjyaM sthiraM sthAtuM na zaknoti| ");
INSERT INTO sanhk_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","tathA kasyApi parivAro yadi parasparaM virodhI bhavati tarhi sopi parivAraH sthiraM sthAtuM na zaknoti| ");
INSERT INTO sanhk_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","tadvat zaitAn yadi svavipakSatayA uttiSThan bhinno bhavati tarhi sopi sthiraM sthAtuM na zaknoti kintUcchinno bhavati| ");
INSERT INTO sanhk_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","aparaJca prabalaM janaM prathamaM na baddhA kopi tasya gRhaM pravizya dravyANi luNThayituM na zaknoti, taM badvvaiva tasya gRhasya dravyANi luNThayituM zaknoti| ");
INSERT INTO sanhk_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","atoheto ryuSmabhyamahaM satyaM kathayAmi manuSyANAM santAnA yAni yAni pApAnIzvaranindAJca kurvvanti teSAM tatsarvveSAmaparAdhAnAM kSamA bhavituM zaknoti, ");
INSERT INTO sanhk_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","kintu yaH kazcit pavitramAtmAnaM nindati tasyAparAdhasya kSamA kadApi na bhaviSyati sonantadaNDasyArho bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","tasyApavitrabhUto'sti teSAmetatkathAhetoH sa itthaM kathitavAn| ");
INSERT INTO sanhk_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","atha tasya mAtA bhrAtRgaNazcAgatya bahistiSThanato lokAn preSya tamAhUtavantaH| ");
INSERT INTO sanhk_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","tatastatsannidhau samupaviSTA lokAstaM babhASire pazya bahistava mAtA bhrAtarazca tvAm anvicchanti| ");
INSERT INTO sanhk_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","tadA sa tAn pratyuvAca mama mAtA kA bhrAtaro vA ke? tataH paraM sa svamIpopaviSTAn ziSyAn prati avalokanaM kRtvA kathayAmAsa ");
INSERT INTO sanhk_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","pazyataite mama mAtA bhrAtarazca| ");
INSERT INTO sanhk_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","yaH kazcid IzvarasyeSTAM kriyAM karoti sa eva mama bhrAtA bhaginI mAtA ca| ");
INSERT INTO sanhk_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","anantaraM sa samudrataTe punarupadeSTuM prArebhe, tatastatra bahujanAnAM samAgamAt sa sAgaropari naukAmAruhya samupaviSTaH; sarvve lokAH samudrakUle tasthuH| ");
INSERT INTO sanhk_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","tadA sa dRSTAntakathAbhi rbahUpadiSTavAn upadizaMzca kathitavAn, ");
INSERT INTO sanhk_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","avadhAnaM kuruta, eko bIjavaptA bIjAni vaptuM gataH; ");
INSERT INTO sanhk_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","vapanakAle kiyanti bIjAni mArgapAzve patitAni, tata AkAzIyapakSiNa etya tAni cakhAduH| ");
INSERT INTO sanhk_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","kiyanti bIjAni svalpamRttikAvatpASANabhUmau patitAni tAni mRdolpatvAt zIghramaGkuritAni; ");
INSERT INTO sanhk_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","kintUdite sUryye dagdhAni tathA mUlAno nAdhogatatvAt zuSkANi ca| ");
INSERT INTO sanhk_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","kiyanti bIjAni kaNTakivanamadhye patitAni tataH kaNTakAni saMvRdvya tAni jagrasustAni na ca phalitAni| ");
INSERT INTO sanhk_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","tathA kiyanti bIjAnyuttamabhUmau patitAni tAni saMvRdvya phalAnyutpAditAni kiyanti bIjAni triMzadguNAni kiyanti SaSTiguNAni kiyanti zataguNAni phalAni phalitavanti| ");
INSERT INTO sanhk_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","atha sa tAnavadat yasya zrotuM karNau staH sa zRNotu| ");
INSERT INTO sanhk_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","tadanantaraM nirjanasamaye tatsaGgino dvAdazaziSyAzca taM taddRSTAntavAkyasyArthaM papracchuH| ");
INSERT INTO sanhk_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","tadA sa tAnuditavAn IzvararAjyasya nigUDhavAkyaM boddhuM yuSmAkamadhikAro'sti; ");
INSERT INTO sanhk_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","kintu ye vahirbhUtAH \"te pazyantaH pazyanti kintu na jAnanti, zRNvantaH zRNvanti kintu na budhyante, cettai rmanaHsu kadApi parivarttiteSu teSAM pApAnyamocayiSyanta,\" atohetostAn prati dRSTAntaireva tAni mayA kathitAni| ");
INSERT INTO sanhk_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","atha sa kathitavAn yUyaM kimetad dRSTAntavAkyaM na budhyadhve? tarhi kathaM sarvvAn dRSTAntAna bhotsyadhve? ");
INSERT INTO sanhk_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","bIjavaptA vAkyarUpANi bIjAni vapati; ");
INSERT INTO sanhk_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","tatra ye ye lokA vAkyaM zRNvanti, kintu zrutamAtrAt zaitAn zIghramAgatya teSAM manaHsUptAni tAni vAkyarUpANi bIjAnyapanayati taeva uptabIjamArgapArzvesvarUpAH| ");
INSERT INTO sanhk_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ye janA vAkyaM zrutvA sahasA paramAnandena gRhlanti, kintu hRdi sthairyyAbhAvAt kiJcit kAlamAtraM tiSThanti tatpazcAt tadvAkyahetoH ");
INSERT INTO sanhk_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","kutracit kleze upadrave vA samupasthite tadaiva vighnaM prApnuvanti taeva uptabIjapASANabhUmisvarUpAH| ");
INSERT INTO sanhk_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","ye janAH kathAM zRNvanti kintu sAMsArikI cintA dhanabhrAnti rviSayalobhazca ete sarvve upasthAya tAM kathAM grasanti tataH mA viphalA bhavati ");
INSERT INTO sanhk_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","taeva uptabIjasakaNTakabhUmisvarUpAH| ");
INSERT INTO sanhk_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ye janA vAkyaM zrutvA gRhlanti teSAM kasya vA triMzadguNAni kasya vA SaSTiguNAni kasya vA zataguNAni phalAni bhavanti taeva uptabIjorvvarabhUmisvarUpAH| ");
INSERT INTO sanhk_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","tadA so'paramapi kathitavAn kopi jano dIpAdhAraM parityajya droNasyAdhaH khaTvAyA adhe vA sthApayituM dIpamAnayati kiM? ");
INSERT INTO sanhk_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","atoheto ryanna prakAzayiSyate tAdRg lukkAyitaM kimapi vastu nAsti; yad vyaktaM na bhaviSyati tAdRzaM guptaM kimapi vastu nAsti| ");
INSERT INTO sanhk_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","yasya zrotuM karNau staH sa zRNotu| ");
INSERT INTO sanhk_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","aparamapi kathitavAn yUyaM yad yad vAkyaM zRNutha tatra sAvadhAnA bhavata, yato yUyaM yena parimANena parimAtha tenaiva parimANena yuSmadarthamapi parimAsyate; zrotAro yUyaM yuSmabhyamadhikaM dAsyate| ");
INSERT INTO sanhk_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","yasyAzraye varddhate tasmai aparamapi dAsyate, kintu yasyAzraye na varddhate tasya yat kiJcidasti tadapi tasmAn neSyate| ");
INSERT INTO sanhk_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","anantaraM sa kathitavAn eko lokaH kSetre bIjAnyuptvA ");
INSERT INTO sanhk_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","jAgaraNanidrAbhyAM divAnizaM gamayati, parantu tadvIjaM tasyAjJAtarUpeNAGkurayati varddhate ca; ");
INSERT INTO sanhk_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","yatohetoH prathamataH patrANi tataH paraM kaNizAni tatpazcAt kaNizapUrNAni zasyAni bhUmiH svayamutpAdayati; ");
INSERT INTO sanhk_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","kintu phaleSu pakkeSu zasyacchedanakAlaM jJAtvA sa tatkSaNaM zasyAni chinatti, anena tulyamIzvararAjyaM| ");
INSERT INTO sanhk_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","punaH so'kathayad IzvararAjyaM kena samaM? kena vastunA saha vA tadupamAsyAmi? ");
INSERT INTO sanhk_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","tat sarSapaikena tulyaM yato mRdi vapanakAle sarSapabIjaM sarvvapRthivIsthabIjAt kSudraM ");
INSERT INTO sanhk_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","kintu vapanAt param aGkurayitvA sarvvazAkAd bRhad bhavati, tasya bRhatyaH zAkhAzca jAyante tatastacchAyAM pakSiNa Azrayante| ");
INSERT INTO sanhk_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","itthaM teSAM bodhAnurUpaM so'nekadRSTAntaistAnupadiSTavAn, ");
INSERT INTO sanhk_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","dRSTAntaM vinA kAmapi kathAM tebhyo na kathitavAn pazcAn nirjane sa ziSyAn sarvvadRSTAntArthaM bodhitavAn| ");
INSERT INTO sanhk_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","taddinasya sandhyAyAM sa tebhyo'kathayad Agacchata vayaM pAraM yAma| ");
INSERT INTO sanhk_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","tadA te lokAn visRjya tamavilambaM gRhItvA naukayA pratasthire; aparA api nAvastayA saha sthitAH| ");
INSERT INTO sanhk_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","tataH paraM mahAjhaJbhzagamAt nau rdolAyamAnA taraGgeNa jalaiH pUrNAbhavacca| ");
INSERT INTO sanhk_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","tadA sa naukAcazcAdbhAge upadhAne ziro nidhAya nidrita AsIt tataste taM jAgarayitvA jagaduH, he prabho, asmAkaM prANA yAnti kimatra bhavatazcintA nAsti? ");
INSERT INTO sanhk_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","tadA sa utthAya vAyuM tarjitavAn samudraJcoktavAn zAntaH susthirazca bhava; tato vAyau nivRtte'bdhirnistaraGgobhUt| ");
INSERT INTO sanhk_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","tadA sa tAnuvAca yUyaM kuta etAdRkzaGkAkulA bhavata? kiM vo vizvAso nAsti? ");
INSERT INTO sanhk_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","tasmAtte'tIvabhItAH parasparaM vaktumArebhire, aho vAyuH sindhuzcAsya nidezagrAhiNau kIdRgayaM manujaH| ");
INSERT INTO sanhk_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","atha tU sindhupAraM gatvA giderIyapradeza upatasthuH| ");
INSERT INTO sanhk_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","naukAto nirgatamAtrAd apavitrabhUtagrasta ekaH zmazAnAdetya taM sAkSAc cakAra| ");
INSERT INTO sanhk_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","sa zmazAne'vAtsIt kopi taM zRGkhalena badvvA sthApayituM nAzaknot| ");
INSERT INTO sanhk_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","janairvAraM nigaDaiH zRGkhalaizca sa baddhopi zRGkhalAnyAkRSya mocitavAn nigaDAni ca bhaMktvA khaNDaM khaNDaM kRtavAn kopi taM vazIkarttuM na zazaka| ");
INSERT INTO sanhk_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","divAnizaM sadA parvvataM zmazAnaJca bhramitvA cItzabdaM kRtavAn grAvabhizca svayaM svaM kRtavAn| ");
INSERT INTO sanhk_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","sa yIzuM dUrAt pazyanneva dhAvan taM praNanAma ucairuvaMzcovAca, ");
INSERT INTO sanhk_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","he sarvvoparisthezvaraputra yIzo bhavatA saha me kaH sambandhaH? ahaM tvAmIzvareNa zApaye mAM mA yAtaya| ");
INSERT INTO sanhk_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","yato yIzustaM kathitavAn re apavitrabhUta, asmAnnarAd bahirnirgaccha| ");
INSERT INTO sanhk_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","atha sa taM pRSTavAn kinte nAma? tena pratyuktaM vayamaneke 'smastato'smannAma bAhinI| ");
INSERT INTO sanhk_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","tatosmAn dezAnna preSayeti te taM prArthayanta| ");
INSERT INTO sanhk_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","tadAnIM parvvataM nikaSA bRhan varAhavrajazcarannAsIt| ");
INSERT INTO sanhk_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","tasmAd bhUtA vinayena jagaduH, amuM varAhavrajam Azrayitum asmAn prahiNu| ");
INSERT INTO sanhk_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","yIzunAnujJAtAste'pavitrabhUtA bahirniryAya varAhavrajaM prAvizan tataH sarvve varAhA vastutastu prAyodvisahasrasaMGkhyakAH kaTakena mahAjavAd dhAvantaH sindhau prANAn jahuH| ");
INSERT INTO sanhk_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","tasmAd varAhapAlakAH palAyamAnAH pure grAme ca tadvArttaM kathayAJcakruH| tadA lokA ghaTitaM tatkAryyaM draSTuM bahirjagmuH ");
INSERT INTO sanhk_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","yIzoH sannidhiM gatvA taM bhUtagrastam arthAd bAhinIbhUtagrastaM naraM savastraM sacetanaM samupaviSTaJca dRृSTvA bibhyuH| ");
INSERT INTO sanhk_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","tato dRSTatatkAryyalokAstasya bhUtagrastanarasya varAhavrajasyApi tAM dhaTanAM varNayAmAsuH| ");
INSERT INTO sanhk_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","tataste svasImAto bahirgantuM yIzuM vinetumArebhire| ");
INSERT INTO sanhk_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","atha tasya naukArohaNakAle sa bhUtamukto nA yIzunA saha sthAtuM prArthayate; ");
INSERT INTO sanhk_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","kintu sa tamananumatya kathitavAn tvaM nijAtmIyAnAM samIpaM gRhaJca gaccha prabhustvayi kRpAM kRtvA yAni karmmANi kRtavAn tAni tAn jJApaya| ");
INSERT INTO sanhk_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ataH sa prasthAya yIzunA kRtaM tatsarvvAzcaryyaM karmma dikApalideze pracArayituM prArabdhavAn tataH sarvve lokA AzcaryyaM menire| ");
INSERT INTO sanhk_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","anantaraM yIzau nAvA punaranyapAra uttIrNe sindhutaTe ca tiSThati sati tatsamIpe bahulokAnAM samAgamo'bhUt| ");
INSERT INTO sanhk_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","aparaM yAyIr nAmnA kazcid bhajanagRhasyAdhipa Agatya taM dRSTvaiva caraNayoH patitvA bahu nivedya kathitavAn; ");
INSERT INTO sanhk_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","mama kanyA mRtaprAyAbhUd ato bhavAnetya tadArogyAya tasyA gAtre hastam arpayatu tenaiva sA jIviSyati| ");
INSERT INTO sanhk_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","tadA yIzustena saha calitaH kintu tatpazcAd bahulokAzcalitvA tAdgAtre patitAH| ");
INSERT INTO sanhk_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","atha dvAdazavarSANi pradararogeNa ");
INSERT INTO sanhk_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","zIrNA cikitsakAnAM nAnAcikitsAbhizca duHkhaM bhuktavatI ca sarvvasvaM vyayitvApi nArogyaM prAptA ca punarapi pIDitAsIcca ");
INSERT INTO sanhk_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","yA strI sA yIzo rvArttAM prApya manasAkathayat yadyahaM tasya vastramAtra spraSTuM labheyaM tadA rogahInA bhaviSyAmi| ");
INSERT INTO sanhk_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","atohetoH sA lokAraNyamadhye tatpazcAdAgatya tasya vastraM pasparza| ");
INSERT INTO sanhk_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","tenaiva tatkSaNaM tasyA raktasrotaH zuSkaM svayaM tasmAd rogAnmuktA ityapi dehe'nubhUtA| ");
INSERT INTO sanhk_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","atha svasmAt zakti rnirgatA yIzuretanmanasA jJAtvA lokanivahaM prati mukhaM vyAvRtya pRSTavAn kena madvastraM spRSTaM? ");
INSERT INTO sanhk_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","tatastasya ziSyA UcuH bhavato vapuSi lokAH saMgharSanti tad dRSTvA kena madvastraM spRSTamiti kutaH kathayati? ");
INSERT INTO sanhk_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","kintu kena tat karmma kRtaM tad draSTuM yIzuzcaturdizo dRSTavAn| ");
INSERT INTO sanhk_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","tataH sA strI bhItA kampitA ca satI svasyA rukpratikriyA jAteti jJAtvAgatya tatsammukhe patitvA sarvvavRttAntaM satyaM tasmai kathayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","tadAnIM yIzustAM gaditavAn, he kanye tava pratItistvAm arogAmakarot tvaM kSemeNa vraja svarogAnmuktA ca tiSTha| ");
INSERT INTO sanhk_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","itivAkyavadanakAle bhajanagRhAdhipasya nivezanAl lokA etyAdhipaM babhASire tava kanyA mRtA tasmAd guruM punaH kutaH kliznAsi? ");
INSERT INTO sanhk_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","kintu yIzustad vAkyaM zrutvaiva bhajanagRhAdhipaM gaditavAn mA bhaiSIH kevalaM vizvAsihi| ");
INSERT INTO sanhk_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","atha pitaro yAkUb tadbhrAtA yohan ca etAn vinA kamapi svapazcAd yAtuM nAnvamanyata| ");
INSERT INTO sanhk_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","tasya bhajanagRhAdhipasya nivezanasamIpam Agatya kalahaM bahurodanaM vilApaJca kurvvato lokAn dadarza| ");
INSERT INTO sanhk_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","tasmAn nivezanaM pravizya proktavAn yUyaM kuta itthaM kalahaM rodanaJca kurutha? kanyA na mRtA nidrAti| ");
INSERT INTO sanhk_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","tasmAtte tamupajahasuH kintu yIzuH sarvvAna bahiSkRtya kanyAyAH pitarau svasaGginazca gRhItvA yatra kanyAsIt tat sthAnaM praviSTavAn| ");
INSERT INTO sanhk_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","atha sa tasyAH kanyAyA hastau dhRtvA tAM babhASe TAlIthA kUmI, arthato he kanye tvamuttiSTha ityAjJApayAmi| ");
INSERT INTO sanhk_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","tunaiva tatkSaNaM sA dvAdazavarSavayaskA kanyA potthAya calitumArebhe, itaH sarvve mahAvismayaM gatAH| ");
INSERT INTO sanhk_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","tata etasyai kiJcit khAdyaM datteti kathayitvA etatkarmma kamapi na jJApayateti dRDhamAdiSTavAn| ");
INSERT INTO sanhk_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","anantaraM sa tatsthAnAt prasthAya svapradezamAgataH ziSyAzca tatpazcAd gatAH| ");
INSERT INTO sanhk_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","atha vizrAmavAre sati sa bhajanagRhe upadeSTumArabdhavAn tato'neke lokAstatkathAM zrutvA vismitya jagaduH, asya manujasya IdRzI AzcaryyakriyA kasmAj jAtA? tathA svakarAbhyAm itthamadbhutaM karmma karttAुm etasmai kathaM jJAnaM dattam? ");
INSERT INTO sanhk_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","kimayaM mariyamaH putrastajJA no? kimayaM yAkUb-yosi-yihudA-zimonAM bhrAtA no? asya bhaginyaH kimihAsmAbhiH saha no? itthaM te tadarthe pratyUhaM gatAH| ");
INSERT INTO sanhk_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","tadA yIzustebhyo'kathayat svadezaM svakuTumbAn svaparijanAMzca vinA kutrApi bhaviSyadvAdI asatkRto na bhavati| ");
INSERT INTO sanhk_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","aparaJca teSAmapratyayAt sa vismitaH kiyatAM rogiNAM vapuHSu hastam arpayitvA kevalaM teSAmArogyakaraNAd anyat kimapi citrakAryyaM karttAM na zaktaH| ");
INSERT INTO sanhk_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","atha sa caturdikstha grAmAn bhramitvA upadiSTavAn ");
INSERT INTO sanhk_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","dvAdazaziSyAn AhUya amedhyabhUtAn vazIkarttAM zaktiM dattvA teSAM dvau dvau jano preSitavAn| ");
INSERT INTO sanhk_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","punarityAdizad yUyam ekaikAM yaSTiM vinA vastrasaMpuTaH pUpaH kaTibandhe tAmrakhaNDaJca eSAM kimapi mA grahlIta, ");
INSERT INTO sanhk_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","mArgayAtrAyai pAdeSUpAnahau dattvA dve uttarIye mA paridhadvvaM| ");
INSERT INTO sanhk_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","aparamapyuktaM tena yUyaM yasyAM puryyAM yasya nivezanaM pravekSyatha tAM purIM yAvanna tyakSyatha tAvat tannivezane sthAsyatha| ");
INSERT INTO sanhk_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","tatra yadi kepi yuSmAkamAtithyaM na vidadhati yuSmAkaM kathAzca na zRNvanti tarhi tatsthAnAt prasthAnasamaye teSAM viruddhaM sAkSyaM dAtuM svapAdAnAsphAlya rajaH sampAtayata; ahaM yuSmAn yathArthaM vacmi vicAradine tannagarasyAvasthAtaH sidomAmorayo rnagarayoravasthA sahyatarA bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","atha te gatvA lokAnAM manaHparAvarttanIH kathA pracAritavantaH| ");
INSERT INTO sanhk_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","evamanekAn bhUtAMzca tyAjitavantastathA tailena marddayitvA bahUn janAnarogAnakArSuH| ");
INSERT INTO sanhk_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","itthaM tasya sukhyAtizcaturdizo vyAptA tadA herod rAjA tannizamya kathitavAn, yohan majjakaH zmazAnAd utthita atohetostena sarvvA etA adbhutakriyAH prakAzante| ");
INSERT INTO sanhk_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","anye'kathayan ayam eliyaH, kepi kathitavanta eSa bhaviSyadvAdI yadvA bhaviSyadvAdinAM sadRza ekoyam| ");
INSERT INTO sanhk_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","kintu herod ityAkarNya bhASitavAn yasyAhaM zirazchinnavAn sa eva yohanayaM sa zmazAnAdudatiSThat| ");
INSERT INTO sanhk_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","pUrvvaM svabhrAtuH philipasya patnyA udvAhaM kRtavantaM herodaM yohanavAdIt svabhAtRvadhU rna vivAhyA| ");
INSERT INTO sanhk_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ataH kAraNAt herod lokaM prahitya yohanaM dhRtvA bandhanAlaye baddhavAn| ");
INSERT INTO sanhk_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","herodiyA tasmai yohane prakupya taM hantum aicchat kintu na zaktA, ");
INSERT INTO sanhk_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","yasmAd herod taM dhArmmikaM satpuruSaJca jJAtvA sammanya rakSitavAn; tatkathAM zrutvA tadanusAreNa bahUni karmmANi kRtavAn hRSTamanAstadupadezaM zrutavAMzca| ");
INSERT INTO sanhk_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","kintu herod yadA svajanmadine pradhAnalokebhyaH senAnIbhyazca gAlIlpradezIyazreSThalokebhyazca rAtrau bhojyamekaM kRtavAn ");
INSERT INTO sanhk_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","tasmin zubhadine herodiyAyAH kanyA sametya teSAM samakSaM saMnRtya herodastena sahopaviSTAnAJca toSamajIjanat tatA nRpaH kanyAmAha sma matto yad yAcase tadeva tubhyaM dAsye| ");
INSERT INTO sanhk_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","zapathaM kRtvAkathayat ced rAjyArddhamapi yAcase tadapi tubhyaM dAsye| ");
INSERT INTO sanhk_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","tataH sA bahi rgatvA svamAtaraM papraccha kimahaM yAciSye? tadA sAkathayat yohano majjakasya ziraH| ");
INSERT INTO sanhk_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","atha tUrNaM bhUpasamIpam etya yAcamAnAvadat kSaNesmin yohano majjakasya ziraH pAtre nidhAya dehi, etad yAce'haM| ");
INSERT INTO sanhk_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","tasmAt bhUpo'tiduHkhitaH, tathApi svazapathasya sahabhojinAJcAnurodhAt tadanaGgIkarttuM na zaktaH| ");
INSERT INTO sanhk_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","tatkSaNaM rAjA ghAtakaM preSya tasya zira AnetumAdiSTavAn| ");
INSERT INTO sanhk_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","tataH sa kArAgAraM gatvA tacchirazchitvA pAtre nidhAyAnIya tasyai kanyAyai dattavAn kanyA ca svamAtre dadau| ");
INSERT INTO sanhk_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ananataraM yohanaH ziSyAstadvArttAM prApyAgatya tasya kuNapaM zmazAne'sthApayan| ");
INSERT INTO sanhk_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","atha preSitA yIzoH sannidhau militA yad yac cakruH zikSayAmAsuzca tatsarvvavArttAstasmai kathitavantaH| ");
INSERT INTO sanhk_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","sa tAnuvAca yUyaM vijanasthAnaM gatvA vizrAmyata yatastatsannidhau bahulokAnAM samAgamAt te bhoktuM nAvakAzaM prAptAH| ");
INSERT INTO sanhk_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","tataste nAvA vijanasthAnaM guptaM gagmuH| ");
INSERT INTO sanhk_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","tato lokanivahasteSAM sthAnAntarayAnaM dadarza, aneke taM paricitya nAnApurebhyaH padairvrajitvA javena taiSAmagre yIzoH samIpa upatasthuH| ");
INSERT INTO sanhk_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","tadA yIzu rnAvo bahirgatya lokAraNyAnIM dRSTvA teSu karuNAM kRtavAn yataste'rakSakameSA ivAsan tadA sa tAna nAnAprasaGgAn upadiSTavAn| ");
INSERT INTO sanhk_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","atha divAnte sati ziSyA etya yIzumUcire, idaM vijanasthAnaM dinaJcAvasannaM| ");
INSERT INTO sanhk_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","lokAnAM kimapi khAdyaM nAsti, atazcaturdikSu grAmAn gantuM bhojyadravyANi kretuJca bhavAn tAn visRjatu| ");
INSERT INTO sanhk_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","tadA sa tAnuvAca yUyameva tAn bhojayata; tataste jagadu rvayaM gatvA dvizatasaMkhyakai rmudrApAdaiH pUpAn krItvA kiM tAn bhojayiSyAmaH? ");
INSERT INTO sanhk_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","tadA sa tAn pRSThavAn yuSmAkaM sannidhau kati pUpA Asate? gatvA pazyata; tataste dRSTvA tamavadan paJca pUpA dvau matsyau ca santi| ");
INSERT INTO sanhk_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","tadA sa lokAn zaspopari paMktibhirupavezayitum AdiSTavAn, ");
INSERT INTO sanhk_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","tataste zataM zataM janAH paJcAzat paJcAzajjanAzca paMktibhi rbhuvi samupavivizuH| ");
INSERT INTO sanhk_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","atha sa tAn paJcapUpAn matsyadvayaJca dhRtvA svargaM pazyan IzvaraguNAn anvakIrttayat tAn pUpAn bhaMktvA lokebhyaH pariveSayituM ziSyebhyo dattavAn dvA matsyau ca vibhajya sarvvebhyo dattavAn| ");
INSERT INTO sanhk_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","tataH sarvve bhuktvAtRpyan| ");
INSERT INTO sanhk_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","anantaraM ziSyA avaziSTaiH pUpai rmatsyaizca pUrNAn dvadaza DallakAn jagRhuH| ");
INSERT INTO sanhk_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","te bhoktAraH prAyaH paJca sahasrANi puruSA Asan| ");
INSERT INTO sanhk_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","atha sa lokAn visRjanneva nAvamAroDhuM svasmAdagre pAre baitsaidApuraM yAtuJca zSyiाn vADhamAdiSTavAn| ");
INSERT INTO sanhk_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","tadA sa sarvvAn visRjya prArthayituM parvvataM gataH| ");
INSERT INTO sanhk_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","tataH sandhyAyAM satyAM nauH sindhumadhya upasthitA kintu sa ekAkI sthale sthitaH| ");
INSERT INTO sanhk_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","atha sammukhavAtavahanAt ziSyA nAvaM vAhayitvA parizrAntA iti jJAtvA sa nizAcaturthayAme sindhUpari padbhyAM vrajan teSAM samIpametya teSAmagre yAtum udyataH| ");
INSERT INTO sanhk_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","kintu ziSyAH sindhUpari taM vrajantaM dRSTvA bhUtamanumAya ruruvuH, ");
INSERT INTO sanhk_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","yataH sarvve taM dRSTvA vyAkulitAH| ataeva yIzustatkSaNaM taiH sahAlapya kathitavAn, susthirA bhUta, ayamahaM mA bhaiSTa| ");
INSERT INTO sanhk_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","atha naukAmAruhya tasmin teSAM sannidhiM gate vAto nivRttaH; tasmAtte manaHsu vismitA AzcaryyaM menire| ");
INSERT INTO sanhk_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","yataste manasAM kAThinyAt tat pUpIyam AzcaryyaM karmma na viviktavantaH| ");
INSERT INTO sanhk_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","atha te pAraM gatvA gineSaratpradezametya taTa upasthitAH| ");
INSERT INTO sanhk_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","teSu naukAto bahirgateSu tatpradezIyA lokAstaM paricitya ");
INSERT INTO sanhk_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","caturdikSu dhAvanto yatra yatra rogiNo narA Asan tAn sarvvAna khaTvopari nidhAya yatra kutracit tadvArttAM prApuH tat sthAnam Anetum Arebhire| ");
INSERT INTO sanhk_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","tathA yatra yatra grAme yatra yatra pure yatra yatra pallyAJca tena pravezaH kRtastadvartmamadhye lokAH pIDitAn sthApayitvA tasya celagranthimAtraM spraSTum teSAmarthe tadanujJAM prArthayantaH yAvanto lokAH paspRzustAvanta eva gadAnmuktAH| ");
INSERT INTO sanhk_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","anantaraM yirUzAlama AgatAH phirUzino'dhyApakAzca yIzoH samIpam AgatAH| ");
INSERT INTO sanhk_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","te tasya kiyataH ziSyAn azucikarairarthAda aprakSAlitahastai rbhuJjato dRSTvA tAnadUSayan| ");
INSERT INTO sanhk_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","yataH phirUzinaH sarvvayihUdIyAzca prAcAM paramparAgatavAkyaM sammanya pratalena hastAn aprakSAlya na bhuJjate| ");
INSERT INTO sanhk_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ApanAdAgatya majjanaM vinA na khAdanti; tathA pAnapAtrANAM jalapAtrANAM pittalapAtrANAm AsanAnAJca jale majjanam ityAdayonyepi bahavasteSAmAcArAH santi| ");
INSERT INTO sanhk_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","te phirUzino'dhyApakAzca yIzuM papracchuH, tava ziSyAH prAcAM paramparAgatavAkyAnusAreNa nAcaranto'prakSAlitakaraiH kuto bhujaMte? ");
INSERT INTO sanhk_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","tataH sa pratyuvAca kapaTino yuSmAn uddizya yizayiyabhaviSyadvAdI yuktamavAdIt| yathA svakIyairadharairete sammanyanate sadaiva mAM| kintu matto viprakarSe santi teSAM manAMsi ca| ");
INSERT INTO sanhk_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","zikSayanto bidhIn nnAjJA bhajante mAM mudhaiva te| ");
INSERT INTO sanhk_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","yUyaM jalapAtrapAnapAtrAdIni majjayanto manujaparamparAgatavAkyaM rakSatha kintu IzvarAjJAM laMghadhve; aparA IdRzyonekAH kriyA api kurudhve| ");
INSERT INTO sanhk_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","anyaJcAkathayat yUyaM svaparamparAgatavAkyasya rakSArthaM spaSTarUpeNa IzvarAjJAM lopayatha| ");
INSERT INTO sanhk_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","yato mUsAdvArA proktamasti svapitarau sammanyadhvaM yastu mAtaraM pitaraM vA durvvAkyaM vakti sa nitAntaM hanyatAM| ");
INSERT INTO sanhk_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","kintu madIyena yena dravyeNa tavopakArobhavat tat karbbANamarthAd IzvarAya niveditam idaM vAkyaM yadi kopi pitaraM mAtaraM vA vakti ");
INSERT INTO sanhk_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","tarhi yUyaM mAtuH pitu rvopakAraM karttAM taM vArayatha| ");
INSERT INTO sanhk_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","itthaM svapracAritaparamparAgatavAkyena yUyam IzvarAjJAM mudhA vidhadvve, IdRzAnyanyAnyanekAni karmmANi kurudhve| ");
INSERT INTO sanhk_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","atha sa lokAnAhUya babhASe yUyaM sarvve madvAkyaM zRNuta budhyadhvaJca| ");
INSERT INTO sanhk_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","bAhyAdantaraM pravizya naramamedhyaM karttAM zaknoti IdRzaM kimapi vastu nAsti, varam antarAd bahirgataM yadvastu tanmanujam amedhyaM karoti| ");
INSERT INTO sanhk_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","yasya zrotuM zrotre staH sa zRNotu| ");
INSERT INTO sanhk_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","tataH sa lokAn hitvA gRhamadhyaM praviSTastadA ziSyAstadRSTAntavAkyArthaM papracchuH| ");
INSERT INTO sanhk_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","tasmAt sa tAn jagAda yUyamapi kimetAdRgabodhAH? kimapi dravyaM bAhyAdantaraM pravizya naramamedhyaM karttAM na zaknoti kathAmimAM kiM na budhyadhve? ");
INSERT INTO sanhk_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","tat tadantarna pravizati kintu kukSimadhyaM pravizati zeSe sarvvabhuktavastugrAhiNi bahirdeze niryAti| ");
INSERT INTO sanhk_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","aparamapyavAdId yannarAnnireti tadeva naramamedhyaM karoti| ");
INSERT INTO sanhk_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","yato'ntarAd arthAn mAnavAnAM manobhyaH kucintA parastrIvezyAgamanaM ");
INSERT INTO sanhk_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","naravadhazcauryyaM lobho duSTatA pravaJcanA kAmukatA kudRSTirIzvaranindA garvvastama ityAdIni nirgacchanti| ");
INSERT INTO sanhk_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","etAni sarvvANi duritAnyantarAdetya naramamedhyaM kurvvanti| ");
INSERT INTO sanhk_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","atha sa utthAya tatsthAnAt sorasIdonpurapradezaM jagAma tatra kimapi nivezanaM pravizya sarvvairajJAtaH sthAtuM matiJcakre kintu guptaH sthAtuM na zazAka| ");
INSERT INTO sanhk_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","yataH suraphainikIdezIyayUnAnIvaMzodbhavastriyAH kanyA bhUtagrastAsIt| sA strI tadvArttAM prApya tatsamIpamAgatya taccaraNayoH patitvA ");
INSERT INTO sanhk_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","svakanyAto bhUtaM nirAkarttAM tasmin vinayaM kRtavatI| ");
INSERT INTO sanhk_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","kintu yIzustAmavadat prathamaM bAlakAstRpyantu yato bAlakAnAM khAdyaM gRhItvA kukkurebhyo nikSepo'nucitaH| ");
INSERT INTO sanhk_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","tadA sA strI tamavAdIt bhoH prabho tat satyaM tathApi maJcAdhaHsthAH kukkurA bAlAnAM karapatitAni khAdyakhaNDAni khAdanti| ");
INSERT INTO sanhk_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","tataH so'kathayad etatkathAhetoH sakuzalA yAhi tava kanyAM tyaktvA bhUto gataH| ");
INSERT INTO sanhk_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","atha sA strI gRhaM gatvA kanyAM bhUtatyaktAM zayyAsthitAM dadarza| ");
INSERT INTO sanhk_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","punazca sa sorasIdonpurapradezAt prasthAya dikApalidezasya prAntarabhAgena gAlIljaladheH samIpaM gatavAn| ");
INSERT INTO sanhk_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","tadA lokairekaM badhiraM kadvadaJca naraM tannikaTamAnIya tasya gAtre hastamarpayituM vinayaH kRtaH| ");
INSERT INTO sanhk_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","tato yIzu rlokAraNyAt taM nirjanamAnIya tasya karNayoGgulI rdadau niSThIvaM dattvA ca tajjihvAM pasparza| ");
INSERT INTO sanhk_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","anantaraM svargaM nirIkSya dIrghaM nizvasya tamavadat itaphataH arthAn mukto bhUyAt| ");
INSERT INTO sanhk_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","tatastatkSaNaM tasya karNau muktau jihvAyAzca jADyApagamAt sa suspaSTavAkyamakathayat| ");
INSERT INTO sanhk_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","atha sa tAn vADhamityAdideza yUyamimAM kathAM kasmaicidapi mA kathayata, kintu sa yati nyaSedhat te tati bAhulyena prAcArayan; ");
INSERT INTO sanhk_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","te'ticamatkRtya parasparaM kathayAmAsuH sa badhirAya zravaNazaktiM mUkAya ca kathanazaktiM dattvA sarvvaM karmmottamarUpeNa cakAra| ");
INSERT INTO sanhk_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","tadA tatsamIpaM bahavo lokA AyAtA atasteSAM bhojyadravyAbhAvAd yIzuH ziSyAnAhUya jagAda,| ");
INSERT INTO sanhk_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","lokanivahe mama kRpA jAyate te dinatrayaM mayA sArddhaM santi teSAM bhojyaM kimapi nAsti| ");
INSERT INTO sanhk_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","teSAM madhye'neke dUrAd AgatAH, abhukteSu teSu mayA svagRhamabhiprahiteSu te pathi klamiSyanti| ");
INSERT INTO sanhk_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ziSyA avAdiSuH, etAvato lokAn tarpayitum atra prantare pUpAn prAptuM kena zakyate? ");
INSERT INTO sanhk_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","tataH sa tAn papraccha yuSmAkaM kati pUpAH santi? te'kathayan sapta| ");
INSERT INTO sanhk_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","tataH sa tAllokAn bhuvi samupaveSTum Adizya tAn sapta pUpAn dhRtvA IzvaraguNAn anukIrttayAmAsa, bhaMktvA pariveSayituM ziSyAn prati dadau, tataste lokebhyaH pariveSayAmAsuH| ");
INSERT INTO sanhk_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","tathA teSAM samIpe ye kSudramatsyA Asan tAnapyAdAya IzvaraguNAn saMkIrtya pariveSayitum AdiSTavAn| ");
INSERT INTO sanhk_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","tato lokA bhuktvA tRptiM gatA avaziSTakhAdyaiH pUrNAH saptaDallakA gRhItAzca| ");
INSERT INTO sanhk_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ete bhoktAraH prAyazcatuH sahasrapuruSA Asan tataH sa tAn visasarja| ");
INSERT INTO sanhk_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","atha sa ziSyaH saha nAvamAruhya dalmAnUthAsImAmAgataH| ");
INSERT INTO sanhk_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","tataH paraM phirUzina Agatya tena saha vivadamAnAstasya parIkSArtham AkAzIyacihnaM draSTuM yAcitavantaH| ");
INSERT INTO sanhk_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","tadA so'ntardIrghaM nizvasyAkathayat, ete vidyamAnanarAH kutazcinhaM mRgayante? yuSmAnahaM yathArthaM bravImi lokAnetAn kimapi cihnaM na darzayiSyate| ");
INSERT INTO sanhk_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","atha tAn hitvA puna rnAvam Aruhya pAramagAt| ");
INSERT INTO sanhk_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","etarhi ziSyaiH pUpeSu vismRteSu nAvi teSAM sannidhau pUpa ekaeva sthitaH| ");
INSERT INTO sanhk_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","tadAnIM yIzustAn AdiSTavAn phirUzinAM herodazca kiNvaM prati satarkAH sAvadhAnAzca bhavata| ");
INSERT INTO sanhk_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","tataste'nyonyaM vivecanaM kartum Arebhire, asmAkaM sannidhau pUpo nAstIti hetoridaM kathayati| ");
INSERT INTO sanhk_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","tad budvvA yIzustebhyo'kathayat yuSmAkaM sthAne pUpAbhAvAt kuta itthaM vitarkayatha? yUyaM kimadyApi kimapi na jAnItha? boddhuJca na zaknutha? yAvadadya kiM yuSmAkaM manAMsi kaThinAni santi? ");
INSERT INTO sanhk_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","satsu netreSu kiM na pazyatha? satsu karNeSu kiM na zRNutha? na smaratha ca? ");
INSERT INTO sanhk_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","yadAhaM paJcapUpAn paJcasahasrANAM puruSANAM madhye bhaMktvA dattavAn tadAnIM yUyam avaziSTapUpaiH pUrNAn kati DallakAn gRhItavantaH? te'kathayan dvAdazaDallakAn| ");
INSERT INTO sanhk_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","aparaJca yadA catuHsahasrANAM puruSANAM madhye pUpAn bhaMktvAdadAM tadA yUyam atiriktapUpAnAM kati DallakAn gRhItavantaH? te kathayAmAsuH saptaDallakAn| ");
INSERT INTO sanhk_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","tadA sa kathitavAn tarhi yUyam adhunApi kuto bodvvuM na zaknutha? ");
INSERT INTO sanhk_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","anantaraM tasmin baitsaidAnagare prApte lokA andhamekaM naraM tatsamIpamAnIya taM spraSTuM taM prArthayAJcakrire| ");
INSERT INTO sanhk_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","tadA tasyAndhasya karau gRhItvA nagarAd bahirdezaM taM nItavAn; tannetre niSThIvaM dattvA tadgAtre hastAvarpayitvA taM papraccha, kimapi pazyasi? ");
INSERT INTO sanhk_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","sa netre unmIlya jagAda, vRkSavat manujAn gacchato nirIkSe| ");
INSERT INTO sanhk_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","tato yIzuH punastasya nayanayo rhastAvarpayitvA tasya netre unmIlayAmAsa; tasmAt sa svastho bhUtvA spaSTarUpaM sarvvalokAn dadarza| ");
INSERT INTO sanhk_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","tataH paraM tvaM grAmaM mA gaccha grAmasthaM kamapi ca kimapyanuktvA nijagRhaM yAhItyAdizya yIzustaM nijagRhaM prahitavAn| ");
INSERT INTO sanhk_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","anantaraM ziSyaiH sahito yIzuH kaisarIyAphilipipuraM jagAma, pathi gacchan tAnapRcchat ko'ham atra lokAH kiM vadanti? ");
INSERT INTO sanhk_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","te pratyUcuH tvAM yohanaM majjakaM vadanti kintu kepi kepi eliyaM vadanti; apare kepi kepi bhaviSyadvAdinAm eko jana iti vadanti| ");
INSERT INTO sanhk_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","atha sa tAnapRcchat kintu koham? ityatra yUyaM kiM vadatha? tadA pitaraH pratyavadat bhavAn abhiSiktastrAtA| ");
INSERT INTO sanhk_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","tataH sa tAn gADhamAdizad yUyaM mama kathA kasmaicidapi mA kathayata| ");
INSERT INTO sanhk_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","manuSyaputreNAvazyaM bahavo yAtanA bhoktavyAH prAcInalokaiH pradhAnayAjakairadhyApakaizca sa ninditaH san ghAtayiSyate tRtIyadine utthAsyati ca, yIzuH ziSyAnupadeSTumArabhya kathAmimAM spaSTamAcaSTa| ");
INSERT INTO sanhk_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","tasmAt pitarastasya hastau dhRtvA taM tarjjitavAn| ");
INSERT INTO sanhk_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","kintu sa mukhaM parAvartya ziSyagaNaM nirIkSya pitaraM tarjayitvAvAdId dUrIbhava vighnakArin IzvarIyakAryyAdapi manuSyakAryyaM tubhyaM rocatatarAM| ");
INSERT INTO sanhk_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","atha sa lokAn ziSyAMzcAhUya jagAda yaH kazcin mAmanugantum icchati sa AtmAnaM dAmyatu, svakruzaM gRhItvA matpazcAd AyAtu| ");
INSERT INTO sanhk_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","yato yaH kazcit svaprANaM rakSitumicchati sa taM hArayiSyati, kintu yaH kazcin madarthaM susaMvAdArthaJca prANaM hArayati sa taM rakSiSyati| ");
INSERT INTO sanhk_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","aparaJca manujaH sarvvaM jagat prApya yadi svaprANaM hArayati tarhi tasya ko lAbhaH? ");
INSERT INTO sanhk_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","naraH svaprANavinimayena kiM dAtuM zaknoti? ");
INSERT INTO sanhk_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","eteSAM vyabhicAriNAM pApinAJca lokAnAM sAkSAd yadi kopi mAM matkathAJca lajjAspadaM jAnAti tarhi manujaputro yadA dharmmadUtaiH saha pituH prabhAveNAgamiSyati tadA sopi taM lajjAspadaM jJAsyati| ");
INSERT INTO sanhk_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","atha sa tAnavAdIt yuSmabhyamahaM yathArthaM kathayAmi, IzvararAjyaM parAkrameNopasthitaM na dRSTvA mRtyuM nAsvAdiSyante, atra daNDAyamAnAnAM madhyepi tAdRzA lokAH santi| ");
INSERT INTO sanhk_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","atha SaDdinebhyaH paraM yIzuH pitaraM yAkUbaM yohanaJca gRhItvA gireruccasya nirjanasthAnaM gatvA teSAM pratyakSe mUrtyantaraM dadhAra| ");
INSERT INTO sanhk_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","tatastasya paridheyam IdRzam ujjvalahimapANaDaraM jAtaM yad jagati kopi rajako na tAdRk pANaDaraM karttAM zaknoti| ");
INSERT INTO sanhk_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","aparaJca eliyo mUsAzca tebhyo darzanaM dattvA yIzunA saha kathanaM karttumArebhAte| ");
INSERT INTO sanhk_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","tadA pitaro yIzumavAdIt he guro'smAkamatra sthitiruttamA, tataeva vayaM tvatkRte ekAM mUsAkRte ekAm eliyakRte caikAM, etAstisraH kuTI rnirmmAma| ");
INSERT INTO sanhk_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","kintu sa yaduktavAn tat svayaM na bubudhe tataH sarvve bibhayAJcakruH| ");
INSERT INTO sanhk_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","etarhi payodastAn chAdayAmAsa, mamayAM priyaH putraH kathAsu tasya manAMsi nivezayateti nabhovANI tanmedyAnniryayau| ");
INSERT INTO sanhk_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","atha haThAtte caturdizo dRSTvA yIzuM vinA svaiH sahitaM kamapi na dadRzuH| ");
INSERT INTO sanhk_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","tataH paraM gireravarohaNakAle sa tAn gADham dUtyAdideza yAvannarasUnoH zmazAnAdutthAnaM na bhavati, tAvat darzanasyAsya vArttA yuSmAbhiH kasmaicidapi na vaktavyA| ");
INSERT INTO sanhk_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","tadA zmazAnAdutthAnasya kobhiprAya iti vicAryya te tadvAkyaM sveSu gopAyAJcakrire| ");
INSERT INTO sanhk_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","atha te yIzuM papracchuH prathamata eliyenAgantavyam iti vAkyaM kuta upAdhyAyA AhuH? ");
INSERT INTO sanhk_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","tadA sa pratyuvAca , eliyaH prathamametya sarvvakAryyANi sAdhayiSyati; naraputre ca lipi ryathAste tathaiva sopi bahuduHkhaM prApyAvajJAsyate| ");
INSERT INTO sanhk_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","kintvahaM yuSmAn vadAmi , eliyArthe lipi ryathAste tathaiva sa etya yayau, lokA: svecchAnurUpaM tamabhivyavaharanti sma| ");
INSERT INTO sanhk_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","anantaraM sa ziSyasamIpametya teSAM catuHpArzve taiH saha bahujanAn vivadamAnAn adhyApakAMzca dRSTavAn; ");
INSERT INTO sanhk_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","kintu sarvvalokAstaM dRSTvaiva camatkRtya tadAsannaM dhAvantastaM praNemuH| ");
INSERT INTO sanhk_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","tadA yIzuradhyApakAnaprAkSId etaiH saha yUyaM kiM vivadadhve? ");
INSERT INTO sanhk_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","tato lokAnAM kazcidekaH pratyavAdIt he guro mama sUnuM mUkaM bhUtadhRtaJca bhavadAsannam AnayaM| ");
INSERT INTO sanhk_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","yadAsau bhUtastamAkramate tadaiva pAtasati tathA sa pheNAyate, dantairdantAn gharSati kSINo bhavati ca; tato hetostaM bhUtaM tyAjayituM bhavacchiSyAn niveditavAn kintu te na zekuH| ");
INSERT INTO sanhk_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","tadA sa tamavAdIt, re avizvAsinaH santAnA yuSmAbhiH saha kati kAlAnahaM sthAsyAmi? aparAn kati kAlAn vA va AcArAn sahiSye? taM madAsannamAnayata| ");
INSERT INTO sanhk_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","tatastatsannidhiM sa AnIyata kintu taM dRSTvaiva bhUto bAlakaM dhRtavAn; sa ca bhUmau patitvA pheNAyamAno luloTha| ");
INSERT INTO sanhk_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","tadA sa tatpitaraM papraccha, asyedRzI dazA kati dinAni bhUtA? tataH sovAdIt bAlyakAlAt| ");
INSERT INTO sanhk_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","bhUtoyaM taM nAzayituM bahuvArAn vahnau jale ca nyakSipat kintu yadi bhavAna kimapi karttAM zaknoti tarhi dayAM kRtvAsmAn upakarotu| ");
INSERT INTO sanhk_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","tadA yIzustamavadat yadi pratyetuM zaknoSi tarhi pratyayine janAya sarvvaM sAdhyam| ");
INSERT INTO sanhk_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","tatastatkSaNaM tadbAlakasya pitA proccai rUvan sAzrunetraH provAca, prabho pratyemi mamApratyayaM pratikuru| ");
INSERT INTO sanhk_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","atha yIzu rlokasaGghaM dhAvitvAyAntaM dRSTvA tamapUtabhUtaM tarjayitvA jagAda, re badhira mUka bhUta tvametasmAd bahirbhava punaH kadApi mAzrayainaM tvAmaham ityAdizAmi| ");
INSERT INTO sanhk_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","tadA sa bhUtazcItzabdaM kRtvA tamApIDya bahirjajAma, tato bAlako mRtakalpo babhUva tasmAdayaM mRta_ityaneke kathayAmAsuH| ");
INSERT INTO sanhk_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","kintu karaM dhRtvA yIzunotthApitaH sa uttasthau| ");
INSERT INTO sanhk_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","atha yIzau gRhaM praviSTe ziSyA guptaM taM papracchuH, vayamenaM bhUtaM tyAjayituM kuto na zaktAH? ");
INSERT INTO sanhk_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","sa uvAca, prArthanopavAsau vinA kenApyanyena karmmaNA bhUtamIdRzaM tyAjayituM na zakyaM| ");
INSERT INTO sanhk_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","anantaraM sa tatsthAnAditvA gAlIlmadhyena yayau, kintu tat kopi jAnIyAditi sa naicchat| ");
INSERT INTO sanhk_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","aparaJca sa ziSyAnupadizan babhASe, naraputro narahasteSu samarpayiSyate te ca taM haniSyanti taistasmin hate tRtIyadine sa utthAsyatIti| ");
INSERT INTO sanhk_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","kintu tatkathAM te nAbudhyanta praSTuJca bibhyaH| ");
INSERT INTO sanhk_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","atha yIzuH kapharnAhUmpuramAgatya madhyegRhaJcetya tAnapRcchad vartmamadhye yUyamanyonyaM kiM vivadadhve sma? ");
INSERT INTO sanhk_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","kintu te niruttarAstasthu ryasmAtteSAM ko mukhya iti vartmAni te'nyonyaM vyavadanta| ");
INSERT INTO sanhk_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","tataH sa upavizya dvAdazaziSyAn AhUya babhASe yaH kazcit mukhyo bhavitumicchati sa sarvvebhyo gauNaH sarvveSAM sevakazca bhavatu| ");
INSERT INTO sanhk_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","tadA sa bAlakamekaM gRhItvA madhye samupAvezayat tatastaM kroDe kRtvA tAnavAdAt ");
INSERT INTO sanhk_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","yaH kazcidIdRzasya kasyApi bAlasyAtithyaM karoti sa mamAtithyaM karoti; yaH kazcinmamAtithyaM karoti sa kevalam mamAtithyaM karoti tanna matprerakasyApyAtithyaM karoti| ");
INSERT INTO sanhk_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","atha yohan tamabravIt he guro, asmAkamananugAminam ekaM tvAnnAmnA bhUtAn tyAjayantaM vayaM dRSTavantaH, asmAkamapazcAdgAmitvAcca taM nyaSedhAma| ");
INSERT INTO sanhk_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","kintu yIzuravadat taM mA niSedhat, yato yaH kazcin mannAmnA citraM karmma karoti sa sahasA mAM nindituM na zaknoti| ");
INSERT INTO sanhk_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","tathA yaH kazcid yuSmAkaM vipakSatAM na karoti sa yuSmAkameva sapakSaH| ");
INSERT INTO sanhk_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","yaH kazcid yuSmAn khrISTaziSyAn jJAtvA mannAmnA kaMsaikena pAnIyaM pAtuM dadAti, yuSmAnahaM yathArthaM vacmi, sa phalena vaJcito na bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","kintu yadi kazcin mayi vizvAsinAmeSAM kSudraprANinAm ekasyApi vighnaM janayati, tarhi tasyaitatkarmma karaNAt kaNThabaddhapeSaNIkasya tasya sAgarAgAdhajala majjanaM bhadraM| ");
INSERT INTO sanhk_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","ataH svakaro yadi tvAM bAdhate tarhi taM chindhi; ");
INSERT INTO sanhk_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","yasmAt yatra kITA na mriyante vahnizca na nirvvAti, tasmin anirvvANAnalanarake karadvayavastava gamanAt karahInasya svargapravezastava kSemaM| ");
INSERT INTO sanhk_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","yadi tava pAdo vighnaM janayati tarhi taM chindhi, ");
INSERT INTO sanhk_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","yato yatra kITA na mriyante vahnizca na nirvvAti, tasmin 'nirvvANavahnau narake dvipAdavatastava nikSepAt pAdahInasya svargapravezastava kSemaM| ");
INSERT INTO sanhk_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","svanetraM yadi tvAM bAdhate tarhi tadapyutpATaya, yato yatra kITA na mriyante vahnizca na nirvvAti, ");
INSERT INTO sanhk_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","tasmina 'nirvvANavahnau narake dvinetrasya tava nikSepAd ekanetravata IzvararAjye pravezastava kSemaM| ");
INSERT INTO sanhk_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","yathA sarvvo bali rlavaNAktaH kriyate tathA sarvvo jano vahnirUpeNa lavaNAktaH kAriSyate| ");
INSERT INTO sanhk_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","lavaNaM bhadraM kintu yadi lavaNe svAdutA na tiSThati, tarhi katham AsvAdyuktaM kariSyatha? yUyaM lavaNayuktA bhavata parasparaM prema kuruta| ");
INSERT INTO sanhk_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","anantaraM sa tatsthAnAt prasthAya yarddananadyAH pAre yihUdApradeza upasthitavAn, tatra tadantike lokAnAM samAgame jAte sa nijarItyanusAreNa punastAn upadideza| ");
INSERT INTO sanhk_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","tadA phirUzinastatsamIpam etya taM parIkSituM papracchaH svajAyA manujAnAM tyajyA na veti? ");
INSERT INTO sanhk_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","tataH sa pratyavAdIt, atra kAryye mUsA yuSmAn prati kimAjJApayat? ");
INSERT INTO sanhk_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ta UcuH tyAgapatraM lekhituM svapatnIM tyaktuJca mUsA'numanyate| ");
INSERT INTO sanhk_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","tadA yIzuH pratyuvAca, yuSmAkaM manasAM kAThinyAddheto rmUsA nidezamimam alikhat| ");
INSERT INTO sanhk_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","kintu sRSTerAdau Izvaro narAn puMrUpeNa strIrUpeNa ca sasarja| ");
INSERT INTO sanhk_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","\"tataH kAraNAt pumAn pitaraM mAtaraJca tyaktvA svajAyAyAm Asakto bhaviSyati, ");
INSERT INTO sanhk_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","tau dvAv ekAGgau bhaviSyataH|\" tasmAt tatkAlamArabhya tau na dvAv ekAGgau| ");
INSERT INTO sanhk_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ataH kAraNAd Izvaro yadayojayat kopi narastanna viyejayet| ");
INSERT INTO sanhk_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","atha yIzu rgRhaM praviSTastadA ziSyAH punastatkathAM taM papracchuH| ");
INSERT INTO sanhk_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","tataH sovadat kazcid yadi svabhAryyAM tyaktavAnyAm udvahati tarhi sa svabhAryyAyAH prAtikUlyena vyabhicArI bhavati| ");
INSERT INTO sanhk_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","kAcinnArI yadi svapatiM hitvAnyapuMsA vivAhitA bhavati tarhi sApi vyabhicAriNI bhavati| ");
INSERT INTO sanhk_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","atha sa yathA zizUn spRzet, tadarthaM lokaistadantikaM zizava AnIyanta, kintu ziSyAstAnAnItavatastarjayAmAsuH| ");
INSERT INTO sanhk_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","yIzustad dRSTvA krudhyan jagAda, mannikaTam AgantuM zizUn mA vArayata, yata etAdRzA IzvararAjyAdhikAriNaH| ");
INSERT INTO sanhk_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","yuSmAnahaM yathArthaM vacmi, yaH kazcit zizuvad bhUtvA rAjyamIzvarasya na gRhlIyAt sa kadApi tadrAjyaM praveSTuM na zaknoti| ");
INSERT INTO sanhk_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ananataraM sa zizUnaGke nidhAya teSAM gAtreSu hastau dattvAziSaM babhASe| ");
INSERT INTO sanhk_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","atha sa vartmanA yAti, etarhi jana eko dhAvan Agatya tatsammukhe jAnunI pAtayitvA pRSTavAn, bhoH paramaguro, anantAyuH prAptaye mayA kiM karttavyaM? ");
INSERT INTO sanhk_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","tadA yIzuruvAca, mAM paramaM kuto vadasi? vinezvaraM kopi paramo na bhavati| ");
INSERT INTO sanhk_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","parastrIM nAbhigaccha; naraM mA ghAtaya; steyaM mA kuru; mRSAsAkSyaM mA dehi; hiMsAJca mA kuru; pitarau sammanyasva; nidezA ete tvayA jJAtAH| ");
INSERT INTO sanhk_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","tatastana pratyuktaM, he guro bAlyakAlAdahaM sarvvAnetAn AcarAmi| ");
INSERT INTO sanhk_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","tadA yIzustaM vilokya snehena babhASe, tavaikasyAbhAva Aste; tvaM gatvA sarvvasvaM vikrIya daridrebhyo vizrANaya, tataH svarge dhanaM prApsyasi; tataH param etya kruzaM vahan madanuvarttI bhava| ");
INSERT INTO sanhk_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","kintu tasya bahusampadvidyamAnatvAt sa imAM kathAmAkarNya viSaNo duHkhitazca san jagAma| ");
INSERT INTO sanhk_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","atha yIzuzcaturdizo nirIkSya ziSyAn avAdIt, dhanilokAnAm IzvararAjyapravezaH kIdRg duSkaraH| ");
INSERT INTO sanhk_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","tasya kathAtaH ziSyAzcamaccakruH, kintu sa punaravadat, he bAlakA ye dhane vizvasanti teSAm IzvararAjyapravezaH kIdRg duSkaraH| ");
INSERT INTO sanhk_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","IzvararAjye dhaninAM pravezAt sUcirandhreNa mahAGgasya gamanAgamanaM sukaraM| ");
INSERT INTO sanhk_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","tadA ziSyA atIva vismitAH parasparaM procuH, tarhi kaH paritrANaM prAptuM zaknoti? ");
INSERT INTO sanhk_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","tato yIzustAn vilokya babhASe, tan narasyAsAdhyaM kintu nezvarasya, yato hetorIzvarasya sarvvaM sAdhyam| ");
INSERT INTO sanhk_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","tadA pitara uvAca, pazya vayaM sarvvaM parityajya bhavatonugAmino jAtAH| ");
INSERT INTO sanhk_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","tato yIzuH pratyavadat, yuSmAnahaM yathArthaM vadAmi, madarthaM susaMvAdArthaM vA yo janaH sadanaM bhrAtaraM bhaginIM pitaraM mAtaraM jAyAM santAnAn bhUmi vA tyaktvA ");
INSERT INTO sanhk_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","gRhabhrAtRbhaginIpitRmAtRpatnIsantAnabhUmInAmiha zataguNAn pretyAnantAyuzca na prApnoti tAdRzaH kopi nAsti| ");
INSERT INTO sanhk_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","kintvagrIyA aneke lokAH zeSAH, zeSIyA aneke lokAzcAgrA bhaviSyanti| ");
INSERT INTO sanhk_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","atha yirUzAlamyAnakAle yIzusteSAm agragAmI babhUva, tasmAtte citraM jJAtvA pazcAdgAmino bhUtvA bibhyuH| tadA sa puna rdvAdazaziSyAn gRhItvA svIyaM yadyad ghaTiSyate tattat tebhyaH kathayituM prArebhe; ");
INSERT INTO sanhk_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","pazyata vayaM yirUzAlampuraM yAmaH, tatra manuSyaputraH pradhAnayAjakAnAm upAdhyAyAnAJca kareSu samarpayiSyate; te ca vadhadaNDAjJAM dApayitvA paradezIyAnAM kareSu taM samarpayiSyanti| ");
INSERT INTO sanhk_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","te tamupahasya kazayA prahRtya tadvapuSi niSThIvaM nikSipya taM haniSyanti, tataH sa tRtIyadine protthAsyati| ");
INSERT INTO sanhk_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","tataH sivadeH putrau yAkUbyohanau tadantikam etya procatuH, he guro yad AvAbhyAM yAciSyate tadasmadarthaM bhavAn karotu nivedanamidamAvayoH| ");
INSERT INTO sanhk_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","tataH sa kathitavAn, yuvAM kimicchathaH? kiM mayA yuSmadarthaM karaNIyaM? ");
INSERT INTO sanhk_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","tadA tau procatuH, AvayorekaM dakSiNapArzve vAmapArzve caikaM tavaizvaryyapade samupaveSTum AjJApaya| ");
INSERT INTO sanhk_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","kintu yIzuH pratyuvAca yuvAmajJAtvedaM prArthayethe, yena kaMsenAhaM pAsyAmi tena yuvAbhyAM kiM pAtuM zakSyate? yasmin majjanenAhaM majjiSye tanmajjane majjayituM kiM yuvAbhyAM zakSyate? tau pratyUcatuH zakSyate| ");
INSERT INTO sanhk_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","tadA yIzuravadat yena kaMsenAhaM pAsyAmi tenAvazyaM yuvAmapi pAsyathaH, yena majjanena cAhaM majjiyye tatra yuvAmapi majjiSyethe| ");
INSERT INTO sanhk_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","kintu yeSAmartham idaM nirUpitaM, tAn vihAyAnyaM kamapi mama dakSiNapArzve vAmapArzve vA samupavezayituM mamAdhikAro nAsti| ");
INSERT INTO sanhk_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","athAnyadazaziSyA imAM kathAM zrutvA yAkUbyohanbhyAM cukupuH| ");
INSERT INTO sanhk_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","kintu yIzustAn samAhUya babhASe, anyadezIyAnAM rAjatvaM ye kurvvanti te teSAmeva prabhutvaM kurvvanti, tathA ye mahAlokAste teSAm adhipatitvaM kurvvantIti yUyaM jAnItha| ");
INSERT INTO sanhk_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","kintu yuSmAkaM madhye na tathA bhaviSyati, yuSmAkaM madhye yaH prAdhAnyaM vAJchati sa yuSmAkaM sevako bhaviSyati, ");
INSERT INTO sanhk_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","yuSmAkaM yo mahAn bhavitumicchati sa sarvveSAM kiGkaro bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","yato manuSyaputraH sevyo bhavituM nAgataH sevAM karttAM tathAnekeSAM paritrANasya mUlyarUpasvaprANaM dAtuJcAgataH| ");
INSERT INTO sanhk_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","atha te yirIhonagaraM prAptAstasmAt ziSyai rlokaizca saha yIzo rgamanakAle TImayasya putro barTImayanAmA andhastanmArgapArzve bhikSArtham upaviSTaH| ");
INSERT INTO sanhk_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","sa nAsaratIyasya yIzorAgamanavArttAM prApya procai rvaktumArebhe, he yIzo dAyUdaH santAna mAM dayasva| ");
INSERT INTO sanhk_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","tatoneke lokA maunIbhaveti taM tarjayAmAsuH, kintu sa punaradhikamuccai rjagAda, he yIzo dAyUdaH santAna mAM dayasva| ");
INSERT INTO sanhk_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","tadA yIzuH sthitvA tamAhvAtuM samAdideza, tato lokAstamandhamAhUya babhASire, he nara, sthiro bhava, uttiSTha, sa tvAmAhvayati| ");
INSERT INTO sanhk_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","tadA sa uttarIyavastraM nikSipya protthAya yIzoH samIpaM gataH| ");
INSERT INTO sanhk_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","tato yIzustamavadat tvayA kiM prArthyate? tubhyamahaM kiM kariSyAmI? tadA sondhastamuvAca, he guro madIyA dRSTirbhavet| ");
INSERT INTO sanhk_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","tato yIzustamuvAca yAhi tava vizvAsastvAM svasthamakArSIt, tasmAt tatkSaNaM sa dRSTiM prApya pathA yIzoH pazcAd yayau| ");
INSERT INTO sanhk_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","anantaraM teSu yirUzAlamaH samIpasthayo rbaitphagIbaithanIyapurayorantikasthaM jaitunanAmAdrimAgateSu yIzuH preSaNakAle dvau ziSyAvidaM vAkyaM jagAda, ");
INSERT INTO sanhk_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","yuvAmamuM sammukhasthaM grAmaM yAtaM, tatra pravizya yo naraM nAvahat taM garddabhazAvakaM drakSyathastaM mocayitvAnayataM| ");
INSERT INTO sanhk_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","kintu yuvAM karmmedaM kutaH kuruthaH? kathAmimAM yadi kopi pRcchati tarhi prabhoratra prayojanamastIti kathite sa zIghraM tamatra preSayiSyati| ");
INSERT INTO sanhk_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","tatastau gatvA dvimArgamelane kasyacid dvArasya pArzve taM garddabhazAvakaM prApya mocayataH, ");
INSERT INTO sanhk_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","etarhi tatropasthitalokAnAM kazcid apRcchat, garddabhazizuM kuto mocayathaH? ");
INSERT INTO sanhk_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","tadA yIzorAjJAnusAreNa tebhyaH pratyudite tatkSaNaM tamAdAtuM te'nujajJuH| ");
INSERT INTO sanhk_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","atha tau yIzoH sannidhiM garddabhazizum AnIya tadupari svavastrANi pAtayAmAsatuH; tataH sa tadupari samupaviSTaH| ");
INSERT INTO sanhk_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","tadAneke pathi svavAsAMsi pAtayAmAsuH, paraizca taruzAkhAzchitavA mArge vikIrNAH| ");
INSERT INTO sanhk_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","aparaJca pazcAdgAmino'gragAminazca sarvve janA ucaiHsvareNa vaktumArebhire, jaya jaya yaH paramezvarasya nAmnAgacchati sa dhanya iti| ");
INSERT INTO sanhk_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","tathAsmAkamaM pUrvvapuruSasya dAyUdo yadrAjyaM paramezvaranAmnAyAti tadapi dhanyaM, sarvvasmAducchrAye svarge Izvarasya jayo bhavet| ");
INSERT INTO sanhk_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","itthaM yIzu ryirUzAlami mandiraM pravizya caturdiksthAni sarvvANi vastUni dRSTavAn; atha sAyaMkAla upasthite dvAdazaziSyasahito baithaniyaM jagAma| ");
INSERT INTO sanhk_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","aparehani baithaniyAd Agamanasamaye kSudhArtto babhUva| ");
INSERT INTO sanhk_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","tato dUre sapatramuDumbarapAdapaM vilokya tatra kiJcit phalaM prAptuM tasya sannikRSTaM yayau, tadAnIM phalapAtanasya samayo nAgacchati| tatastatropasthitaH patrANi vinA kimapyaparaM na prApya sa kathitavAn, ");
INSERT INTO sanhk_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","adyArabhya kopi mAnavastvattaH phalaM na bhuJjIta; imAM kathAM tasya ziSyAH zuzruvuH| ");
INSERT INTO sanhk_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","tadanantaraM teSu yirUzAlamamAyAteSu yIzu rmandiraM gatvA tatrasthAnAM baNijAM mudrAsanAni pArAvatavikretRNAm AsanAni ca nyubjayAJcakAra sarvvAn kretRn vikretRMzca bahizcakAra| ");
INSERT INTO sanhk_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","aparaM mandiramadhyena kimapi pAtraM voDhuM sarvvajanaM nivArayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","lokAnupadizan jagAda, mama gRhaM sarvvajAtIyAnAM prArthanAgRham iti nAmnA prathitaM bhaviSyati etat kiM zAstre likhitaM nAsti? kintu yUyaM tadeva corANAM gahvaraM kurutha| ");
INSERT INTO sanhk_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","imAM vANIM zrutvAdhyApakAH pradhAnayAjakAzca taM yathA nAzayituM zaknuvanti tathoेpAyaM mRgayAmAsuH, kintu tasyopadezAt sarvve lokA vismayaM gatA ataste tasmAd bibhyuH| ");
INSERT INTO sanhk_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","atha sAyaMsamaya upasthite yIzurnagarAd bahirvavrAja| ");
INSERT INTO sanhk_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","anantaraM prAtaHkAle te tena mArgeNa gacchantastamuDumbaramahIruhaM samUlaM zuSkaM dadRzuH| ");
INSERT INTO sanhk_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","tataH pitaraH pUrvvavAkyaM smaran yIzuM babhASaM, he guro pazyatu ya uDumbaraviTapI bhavatA zaptaH sa zuSko babhUva| ");
INSERT INTO sanhk_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","tato yIzuH pratyavAdIt, yUyamIzvare vizvasita| ");
INSERT INTO sanhk_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","yuSmAnahaM yathArthaM vadAmi kopi yadyetadgiriM vadati, tvamutthAya gatvA jaladhau pata, proktamidaM vAkyamavazyaM ghaTiSyate, manasA kimapi na sandihya cedidaM vizvaset tarhi tasya vAkyAnusAreNa tad ghaTiSyate| ");
INSERT INTO sanhk_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ato hetorahaM yuSmAn vacmi, prArthanAkAle yadyadAkAMkSiSyadhve tattadavazyaM prApsyatha, itthaM vizvasita, tataH prApsyatha| ");
INSERT INTO sanhk_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","aparaJca yuSmAsu prArthayituM samutthiteSu yadi kopi yuSmAkam aparAdhI tiSThati, tarhi taM kSamadhvaM, tathA kRte yuSmAkaM svargasthaH pitApi yuSmAkamAgAMmi kSamiSyate| ");
INSERT INTO sanhk_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","kintu yadi na kSamadhve tarhi vaH svargasthaH pitApi yuSmAkamAgAMsi na kSamiSyate| ");
INSERT INTO sanhk_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","anantaraM te puna ryirUzAlamaM pravivizuH, yIzu ryadA madhyemandiram itastato gacchati, tadAnIM pradhAnayAjakA upAdhyAyAH prAJcazca tadantikametya kathAmimAM papracchuH, ");
INSERT INTO sanhk_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","tvaM kenAdezena karmmANyetAni karoSi? tathaitAni karmmANi karttAM kenAdiSTosi? ");
INSERT INTO sanhk_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","tato yIzuH pratigaditavAn ahamapi yuSmAn ekakathAM pRcchAmi, yadi yUyaM tasyA uttaraM kurutha, tarhi kayAjJayAhaM karmmANyetAni karomi tad yuSmabhyaM kathayiSyAmi| ");
INSERT INTO sanhk_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","yohano majjanam IzvarAt jAtaM kiM mAnavAt? tanmahyaM kathayata| ");
INSERT INTO sanhk_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","te parasparaM vivektuM prArebhire, tad IzvarAd babhUveti ced vadAmastarhi kutastaM na pratyaita? kathametAM kathayiSyati| ");
INSERT INTO sanhk_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","mAnavAd abhavaditi ced vadAmastarhi lokebhyo bhayamasti yato hetoH sarvve yohanaM satyaM bhaviSyadvAdinaM manyante| ");
INSERT INTO sanhk_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ataeva te yIzuM pratyavAdiSu rvayaM tad vaktuM na zaknumaH| yIzuruvAca, tarhi yenAdezena karmmANyetAni karomi, ahamapi yuSmabhyaM tanna kathayiSyAmi| ");
INSERT INTO sanhk_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","anantaraM yIzu rdRSTAntena tebhyaH kathayitumArebhe, kazcideko drAkSAkSetraM vidhAya taccaturdikSu vAraNIM kRtvA tanmadhye drAkSApeSaNakuNDam akhanat, tathA tasya gaDamapi nirmmitavAn tatastatkSetraM kRSIvaleSu samarpya dUradezaM jagAma| ");
INSERT INTO sanhk_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","tadanantaraM phalakAle kRSIvalebhyo drAkSAkSetraphalAni prAptuM teSAM savidhe bhRtyam ekaM prAhiNot| ");
INSERT INTO sanhk_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","kintu kRSIvalAstaM dhRtvA prahRtya riktahastaM visasRjuH| ");
INSERT INTO sanhk_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","tataH sa punaranyamekaM bhRtyaM praSayAmAsa, kintu te kRSIvalAH pASANAghAtaistasya ziro bhaGktvA sApamAnaM taM vyasarjan| ");
INSERT INTO sanhk_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","tataH paraM soparaM dAsaM prAhiNot tadA te taM jaghnuH, evam anekeSAM kasyacit prahAraH kasyacid vadhazca taiH kRtaH| ");
INSERT INTO sanhk_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","tataH paraM mayA svaputre prahite te tamavazyaM sammaMsyante, ityuktvAvazeSe teSAM sannidhau nijapriyam advitIyaM putraM preSayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","kintu kRSIvalAH parasparaM jagaduH, eSa uttarAdhikArI, Agacchata vayamenaM hanmastathA kRte 'dhikAroyam asmAkaM bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","tatastaM dhRtvA hatvA drAkSAkSetrAd bahiH prAkSipan| ");
INSERT INTO sanhk_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","anenAsau drAkSAkSetrapatiH kiM kariSyati? sa etya tAn kRSIvalAn saMhatya tatkSetram anyeSu kRSIvaleSu samarpayiSyati| ");
INSERT INTO sanhk_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","aparaJca, \"sthapatayaH kariSyanti grAvANaM yantu tucchakaM| prAdhAnaprastaraH koNe sa eva saMbhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","etat karmma parezasyAMdbhutaM no dRSTito bhavet||\" imAM zAstrIyAM lipiM yUyaM kiM nApAThiSTa? ");
INSERT INTO sanhk_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","tadAnIM sa tAnuddizya tAM dRSTAntakathAM kathitavAn, ta itthaM budvvA taM dharttAmudyatAH, kintu lokebhyo bibhyuH, tadanantaraM te taM vihAya vavrajuH| ");
INSERT INTO sanhk_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","aparaJca te tasya vAkyadoSaM dharttAM katipayAn phirUzino herodIyAMzca lokAn tadantikaM preSayAmAsuH| ");
INSERT INTO sanhk_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ta Agatya tamavadan, he guro bhavAn tathyabhASI kasyApyanurodhaM na manyate, pakSapAtaJca na karoti, yathArthata IzvarIyaM mArgaM darzayati vayametat prajAnImaH, kaisarAya karo deyo na vAM? vayaM dAsyAmo na vA? ");
INSERT INTO sanhk_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","kintu sa teSAM kapaTaM jJAtvA jagAda, kuto mAM parIkSadhve? ekaM mudrApAdaM samAnIya mAM darzayata| ");
INSERT INTO sanhk_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","tadA tairekasmin mudrApAde samAnIte sa tAn papraccha, atra likhitaM nAma mUrtti rvA kasya? te pratyUcuH, kaisarasya| ");
INSERT INTO sanhk_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","tadA yIzuravadat tarhi kaisarasya dravyANi kaisarAya datta, Izvarasya dravyANi tu IzvarAya datta; tataste vismayaM menire| ");
INSERT INTO sanhk_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","atha mRtAnAmutthAnaM ye na manyante te sidUkino yIzoH samIpamAgatya taM papracchuH; ");
INSERT INTO sanhk_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","he guro kazcijjano yadi niHsantatiH san bhAryyAyAM satyAM mriyate tarhi tasya bhrAtA tasya bhAryyAM gRhItvA bhrAtu rvaMzotpattiM kariSyati, vyavasthAmimAM mUsA asmAn prati vyalikhat| ");
INSERT INTO sanhk_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","kintu kecit sapta bhrAtara Asan, tatasteSAM jyeSThabhrAtA vivahya niHsantatiH san amriyata| ");
INSERT INTO sanhk_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","tato dvitIyo bhrAtA tAM striyamagRhaNat kintu sopi niHsantatiH san amriyata; atha tRtIyopi bhrAtA tAdRzobhavat| ");
INSERT INTO sanhk_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","itthaM saptaiva bhrAtarastAM striyaM gRhItvA niHsantAnAH santo'mriyanta, sarvvazeSe sApi strI mriyate sma| ");
INSERT INTO sanhk_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","atha mRtAnAmutthAnakAle yadA ta utthAsyanti tadA teSAM kasya bhAryyA sA bhaviSyati? yataste saptaiva tAM vyavahan| ");
INSERT INTO sanhk_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","tato yIzuH pratyuvAca zAstram IzvarazaktiJca yUyamajJAtvA kimabhrAmyata na? ");
INSERT INTO sanhk_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","mRtalokAnAmutthAnaM sati te na vivahanti vAgdattA api na bhavanti, kintu svargIyadUtAnAM sadRzA bhavanti| ");
INSERT INTO sanhk_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","punazca \"aham ibrAhIma Izvara ishAka Izvaro yAkUbazcezvaraH\" yAmimAM kathAM stambamadhye tiSThan Izvaro mUsAmavAdIt mRtAnAmutthAnArthe sA kathA mUsAlikhite pustake kiM yuSmAbhi rnApAThi? ");
INSERT INTO sanhk_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Izvaro jIvatAM prabhuH kintu mRtAnAM prabhu rna bhavati, tasmAddheto ryUyaM mahAbhrameNa tiSThatha| ");
INSERT INTO sanhk_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","etarhi ekodhyApaka etya teSAmitthaM vicAraM zuzrAva; yIzusteSAM vAkyasya saduttaraM dattavAn iti budvvA taM pRSTavAn sarvvAsAm AjJAnAM kA zreSThA? tato yIzuH pratyuvAca, ");
INSERT INTO sanhk_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","\"he isrAyellokA avadhatta, asmAkaM prabhuH paramezvara eka eva, ");
INSERT INTO sanhk_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","yUyaM sarvvantaHkaraNaiH sarvvaprANaiH sarvvacittaiH sarvvazaktibhizca tasmin prabhau paramezvare prIyadhvaM,\" ityAjJA zreSThA| ");
INSERT INTO sanhk_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","tathA \"svaprativAsini svavat prema kurudhvaM,\" eSA yA dvitIyAjJA sA tAdRzI; etAbhyAM dvAbhyAm AjJAbhyAm anyA kApyAjJA zreSThA nAsti| ");
INSERT INTO sanhk_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","tadA sodhyApakastamavadat, he guro satyaM bhavAn yathArthaM proktavAn yata ekasmAd IzvarAd anyo dvitIya Izvaro nAsti; ");
INSERT INTO sanhk_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","aparaM sarvvAntaHkaraNaiH sarvvaprANaiH sarvvacittaiH sarvvazaktibhizca Izvare premakaraNaM tathA svamIpavAsini svavat premakaraNaJca sarvvebhyo homabalidAnAdibhyaH zraSThaM bhavati| ");
INSERT INTO sanhk_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","tato yIzuH subuddheriva tasyedam uttaraM zrutvA taM bhASitavAn tvamIzvarasya rAjyAnna dUrosi|itaH paraM tena saha kasyApi vAkyasya vicAraM karttAM kasyApi pragalbhatA na jAtA| ");
INSERT INTO sanhk_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","anantaraM madhyemandiram upadizan yIzurimaM praznaM cakAra, adhyApakA abhiSiktaM (tArakaM) kuto dAyUdaH santAnaM vadanti? ");
INSERT INTO sanhk_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","svayaM dAyUd pavitrasyAtmana AvezenedaM kathayAmAsa| yathA| \"mama prabhumidaM vAkyavadat paramezvaraH| tava zatrUnahaM yAvat pAdapIThaM karomi na| tAvat kAlaM madIye tvaM dakSapArzv upAviza|\" ");
INSERT INTO sanhk_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","yadi dAyUd taM prabhUM vadati tarhi kathaM sa tasya santAno bhavitumarhati? itare lokAstatkathAM zrutvAnananduH| ");
INSERT INTO sanhk_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","tadAnIM sa tAnupadizya kathitavAn ye narA dIrghaparidheyAni haTTe vipanau ca ");
INSERT INTO sanhk_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","lokakRtanamaskArAn bhajanagRhe pradhAnAsanAni bhojanakAle pradhAnasthAnAni ca kAGkSante; ");
INSERT INTO sanhk_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","vidhavAnAM sarvvasvaM grasitvA chalAd dIrghakAlaM prArthayante tebhya upAdhyAyebhyaH sAvadhAnA bhavata; te'dhikatarAn daNDAn prApsyanti| ");
INSERT INTO sanhk_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","tadanantaraM lokA bhANDAgAre mudrA yathA nikSipanti bhANDAgArasya sammukhe samupavizya yIzustadavaluloka; tadAnIM bahavo dhaninastasya madhye bahUni dhanAni nirakSipan| ");
INSERT INTO sanhk_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","pazcAd ekA daridrA vidhavA samAgatya dvipaNamUlyAM mudraikAM tatra nirakSipat| ");
INSERT INTO sanhk_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","tadA yIzuH ziSyAn AhUya kathitavAn yuSmAnahaM yathArthaM vadAmi ye ye bhANDAgAre'smina dhanAni niHkSipanti sma tebhyaH sarvvebhya iyaM vidhavA daridrAdhikam niHkSipati sma| ");
INSERT INTO sanhk_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","yataste prabhUtadhanasya kiJcit nirakSipan kintu dIneyaM svadinayApanayogyaM kiJcidapi na sthApayitvA sarvvasvaM nirakSipat| ");
INSERT INTO sanhk_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","anantaraM mandirAd bahirgamanakAle tasya ziSyANAmekastaM vyAhRtavAn he guro pazyatu kIdRzAH pASANAH kIdRk ca nicayanaM| ");
INSERT INTO sanhk_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","tadA yIzustam avadat tvaM kimetad bRhannicayanaM pazyasi? asyaikapASANopi dvitIyapASANopari na sthAsyati sarvve 'dhaHkSepsyante| ");
INSERT INTO sanhk_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","atha yasmin kAle jaitungirau mandirasya sammukhe sa samupaviSTastasmin kAle pitaro yAkUb yohan Andriyazcaite taM rahasi papracchuH, ");
INSERT INTO sanhk_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","etA ghaTanAH kadA bhaviSyanti? tathaitatsarvvAsAM siddhyupakramasya vA kiM cihnaM? tadasmabhyaM kathayatu bhavAn| ");
INSERT INTO sanhk_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","tato yAzustAn vaktumArebhe, kopi yathA yuSmAn na bhrAmayati tathAtra yUyaM sAvadhAnA bhavata| ");
INSERT INTO sanhk_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","yataH khrISTohamiti kathayitvA mama nAmnAneke samAgatya lokAnAM bhramaM janayiSyanti; ");
INSERT INTO sanhk_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","kintu yUyaM raNasya vArttAM raNADambaraJca zrutvA mA vyAkulA bhavata, ghaTanA etA avazyammAvinyaH; kintvApAtato na yugAnto bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","dezasya vipakSatayA dezo rAjyasya vipakSatayA ca rAjyamutthAsyati, tathA sthAne sthAne bhUmikampo durbhikSaM mahAklezAzca samupasthAsyanti, sarvva ete duHkhasyArambhAH| ");
INSERT INTO sanhk_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","kintu yUyam AtmArthe sAvadhAnAstiSThata, yato lokA rAjasabhAyAM yuSmAn samarpayiSyanti, tathA bhajanagRhe prahariSyanti; yUyaM madarthe dezAdhipAn bhUpAMzca prati sAkSyadAnAya teSAM sammukhe upasthApayiSyadhve| ");
INSERT INTO sanhk_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","zeSIbhavanAt pUrvvaM sarvvAn dezIyAn prati susaMvAdaH pracArayiSyate| ");
INSERT INTO sanhk_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","kintu yadA te yuSmAn dhRtvA samarpayiSyanti tadA yUyaM yadyad uttaraM dAsyatha, tadagra tasya vivecanaM mA kuruta tadarthaM kiJcidapi mA cintayata ca, tadAnIM yuSmAkaM manaHsu yadyad vAkyam upasthApayiSyate tadeva vadiSyatha, yato yUyaM na tadvaktAraH kintu pavitra AtmA tasya vaktA| ");
INSERT INTO sanhk_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","tadA bhrAtA bhrAtaraM pitA putraM ghAtanArthaM parahasteSu samarpayiSyate, tathA patyAni mAtApitro rvipakSatayA tau ghAtayiSyanti| ");
INSERT INTO sanhk_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","mama nAmahetoH sarvveSAM savidhe yUyaM jugupsitA bhaviSyatha, kintu yaH kazcit zeSaparyyantaM dhairyyam AlambiSyate saeva paritrAsyate| ");
INSERT INTO sanhk_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","dAniyelbhaviSyadvAdinA proktaM sarvvanAzi jugupsitaJca vastu yadA tvayogyasthAne vidyamAnaM drakSatha (yo janaH paThati sa budhyatAM) tadA ye yihUdIyadeze tiSThanti te mahIdhraM prati palAyantAM; ");
INSERT INTO sanhk_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","tathA yo naro gRhopari tiSThati sa gRhamadhyaM nAvarohatu, tathA kimapi vastu grahItuM madhyegRhaM na pravizatu; ");
INSERT INTO sanhk_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","tathA ca yo naraH kSetre tiSThati sopi svavastraM grahItuM parAvRtya na vrajatu| ");
INSERT INTO sanhk_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","tadAnIM garbbhavatInAM stanyadAtrINAJca yoSitAM durgati rbhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","yuSmAkaM palAyanaM zItakAle yathA na bhavati tadarthaM prArthayadhvaM| ");
INSERT INTO sanhk_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","yatastadA yAdRzI durghaTanA ghaTiSyate tAdRzI durghaTanA IzvarasRSTeH prathamamArabhyAdya yAvat kadApi na jAtA na janiSyate ca| ");
INSERT INTO sanhk_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","aparaJca paramezvaro yadi tasya samayasya saMkSepaM na karoti tarhi kasyApi prANabhRto rakSA bhavituM na zakSyati, kintu yAn janAn manonItAn akarot teSAM svamanonItAnAM hetoH sa tadanehasaM saMkSepsyati| ");
INSERT INTO sanhk_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","anyacca pazyata khrISTotra sthAne vA tatra sthAne vidyate, tasminkAle yadi kazcid yuSmAn etAdRzaM vAkyaM vyAharati, tarhi tasmin vAkye bhaiva vizvasita| ");
INSERT INTO sanhk_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","yatoneke mithyAkhrISTA mithyAbhaviSyadvAdinazca samupasthAya bahUni cihnAnyadbhutAni karmmANi ca darzayiSyanti; tathA yadi sambhavati tarhi manonItalokAnAmapi mithyAmatiM janayiSyanti| ");
INSERT INTO sanhk_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","pazyata ghaTanAtaH pUrvvaM sarvvakAryyasya vArttAM yuSmabhyamadAm, yUyaM sAvadhAnAstiSThata| ");
INSERT INTO sanhk_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","aparaJca tasya klezakAlasyAvyavahite parakAle bhAskaraH sAndhakAro bhaviSyati tathaiva candrazcandrikAM na dAsyati| ");
INSERT INTO sanhk_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","nabhaHsthAni nakSatrANi patiSyanti, vyomamaNDalasthA grahAzca vicaliSyanti| ");
INSERT INTO sanhk_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","tadAnIM mahAparAkrameNa mahaizvaryyeNa ca meghamAruhya samAyAntaM mAnavasutaM mAnavAH samIkSiSyante| ");
INSERT INTO sanhk_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","anyacca sa nijadUtAn prahitya nabhobhUmyoH sImAM yAvad jagatazcaturdigbhyaH svamanonItalokAn saMgrahISyati| ");
INSERT INTO sanhk_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","uDumbarataro rdRSTAntaM zikSadhvaM yadoDumbarasya taro rnavInAH zAkhA jAyante pallavAdIni ca rnigacchanti, tadA nidAghakAlaH savidho bhavatIti yUyaM jJAtuM zaknutha| ");
INSERT INTO sanhk_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","tadvad etA ghaTanA dRSTvA sa kAlo dvAryyupasthita iti jAnIta| ");
INSERT INTO sanhk_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","yuSmAnahaM yathArthaM vadAmi, AdhunikalokAnAM gamanAt pUrvvaM tAni sarvvANi ghaTiSyante| ");
INSERT INTO sanhk_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","dyAvApRthivyo rvicalitayoH satyo rmadIyA vANI na vicaliSyati| ");
INSERT INTO sanhk_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","aparaJca svargasthadUtagaNo vA putro vA tAtAdanyaH kopi taM divasaM taM daNDaM vA na jJApayati| ");
INSERT INTO sanhk_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ataH sa samayaH kadA bhaviSyati, etajjJAnAbhAvAd yUyaM sAvadhAnAstiSThata, satarkAzca bhUtvA prArthayadhvaM; ");
INSERT INTO sanhk_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","yadvat kazcit pumAn svanivezanAd dUradezaM prati yAtrAkaraNakAle dAseSu svakAryyasya bhAramarpayitvA sarvvAn sve sve karmmaNi niyojayati; aparaM dauvArikaM jAgarituM samAdizya yAti, tadvan naraputraH| ");
INSERT INTO sanhk_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","gRhapatiH sAyaMkAle nizIthe vA tRtIyayAme vA prAtaHkAle vA kadAgamiSyati tad yUyaM na jAnItha; ");
INSERT INTO sanhk_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","sa haThAdAgatya yathA yuSmAn nidritAn na pazyati, tadarthaM jAgaritAstiSThata| ");
INSERT INTO sanhk_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","yuSmAnahaM yad vadAmi tadeva sarvvAn vadAmi, jAgaritAstiSThateti| ");
INSERT INTO sanhk_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","tadA nistArotsavakiNvahInapUpotsavayorArambhasya dinadvaye 'vaziSTe pradhAnayAjakA adhyApakAzca kenApi chalena yIzuM dharttAM hantuJca mRgayAJcakrire; ");
INSERT INTO sanhk_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","kintu lokAnAM kalahabhayAdUcire, nacotsavakAla ucitametaditi| ");
INSERT INTO sanhk_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","anantaraM baithaniyApuुre zimonakuSThino gRhe yozau bhotkumupaviSTe sati kAcid yoSit pANDarapASANasya sampuTakena mahArghyottamatailam AnIya sampuTakaM bhaMktvA tasyottamAGge tailadhArAM pAtayAJcakre| ");
INSERT INTO sanhk_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","tasmAt kecit svAnte kupyantaH kathitavaMntaH kutoyaM tailApavyayaH? ");
INSERT INTO sanhk_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","yadyetat taila vyakreSyata tarhi mudrApAdazatatrayAdapyadhikaM tasya prAptamUlyaM daridralokebhyo dAtumazakSyata, kathAmetAM kathayitvA tayA yoSitA sAkaM vAcAyuhyan| ");
INSERT INTO sanhk_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","kintu yIzuruvAca, kuta etasyai kRcchraM dadAsi? mahyamiyaM karmmottamaM kRtavatI| ");
INSERT INTO sanhk_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","daridrAH sarvvadA yuSmAbhiH saha tiSThanti, tasmAd yUyaM yadecchatha tadaiva tAnupakarttAM zaknutha, kintvahaM yubhAbhiH saha nirantaraM na tiSThAmi| ");
INSERT INTO sanhk_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","asyA yathAsAdhyaM tathaivAkarodiyaM, zmazAnayApanAt pUrvvaM sametya madvapuSi tailam amarddayat| ");
INSERT INTO sanhk_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","ahaM yuSmabhyaM yathArthaM kathayAmi, jagatAM madhye yatra yatra susaMvAdoyaM pracArayiSyate tatra tatra yoSita etasyAH smaraNArthaM tatkRtakarmmaitat pracArayiSyate| ");
INSERT INTO sanhk_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","tataH paraM dvAdazAnAM ziSyANAmeka ISkariyotIyayihUdAkhyo yIzuM parakareSu samarpayituM pradhAnayAjakAnAM samIpamiyAya| ");
INSERT INTO sanhk_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","te tasya vAkyaM samAkarNya santuSTAH santastasmai mudrA dAtuM pratyajAnata; tasmAt sa taM teSAM kareSu samarpaNAyopAyaM mRgayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","anantaraM kiNvazUnyapUpotsavasya prathame'hani nistArotmavArthaM meSamAraNAsamaye ziSyAstaM papracchaH kutra gatvA vayaM nistArotsavasya bhojyamAsAdayiSyAmaH? kimicchati bhavAn? ");
INSERT INTO sanhk_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","tadAnIM sa teSAM dvayaM prerayan babhASe yuvayoH puramadhyaM gatayoH sato ryo janaH sajalakumbhaM vahan yuvAM sAkSAt kariSyati tasyaiva pazcAd yAtaM; ");
INSERT INTO sanhk_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","sa yat sadanaM pravekSyati tadbhavanapatiM vadataM, gururAha yatra saziSyohaM nistArotsavIyaM bhojanaM kariSyAmi, sA bhojanazAlA kutrAsti? ");
INSERT INTO sanhk_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","tataH sa pariSkRtAM susajjitAM bRhatIcaJca yAM zAlAM darzayiSyati tasyAmasmadarthaM bhojyadravyANyAsAdayataM| ");
INSERT INTO sanhk_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","tataH ziSyau prasthAya puraM pravizya sa yathoktavAn tathaiva prApya nistArotsavasya bhojyadravyANi samAsAdayetAm| ");
INSERT INTO sanhk_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","anantaraM yIzuH sAyaMkAle dvAdazabhiH ziSyaiH sArddhaM jagAma; ");
INSERT INTO sanhk_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","sarvveSu bhojanAya propaviSTeSu sa tAnuditavAn yuSmAnahaM yathArthaM vyAharAmi, atra yuSmAkameko jano yo mayA saha bhuMkte mAM parakereSu samarpayiSyate| ");
INSERT INTO sanhk_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","tadAnIM te duHkhitAH santa ekaikazastaM praSTumArabdhavantaH sa kimahaM? pazcAd anya ekobhidadhe sa kimahaM? ");
INSERT INTO sanhk_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","tataH sa pratyavadad eteSAM dvAdazAnAM yo jano mayA samaM bhojanApAtre pANiM majjayiSyati sa eva| ");
INSERT INTO sanhk_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","manujatanayamadhi yAdRzaM likhitamAste tadanurUpA gatistasya bhaviSyati, kintu yo jano mAnavasutaM samarpayiSyate hanta tasya janmAbhAve sati bhadramabhaviSyat| ");
INSERT INTO sanhk_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","aparaJca teSAM bhojanasamaye yIzuH pUpaM gRhItvezvaraguNAn anukIrtya bhaGktvA tebhyo dattvA babhASe, etad gRhItvA bhuJjIdhvam etanmama vigraharUpaM| ");
INSERT INTO sanhk_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","anantaraM sa kaMsaM gRhItvezvarasya guNAn kIrttayitvA tebhyo dadau, tataste sarvve papuH| ");
INSERT INTO sanhk_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","aparaM sa tAnavAdId bahUnAM nimittaM pAtitaM mama navInaniyamarUpaM zoNitametat| ");
INSERT INTO sanhk_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","yuSmAnahaM yathArthaM vadAmi, Izvarasya rAjye yAvat sadyojAtaM drAkSArasaM na pAsyAmi,tAvadahaM drAkSAphalarasaM puna rna pAsyAmi| ");
INSERT INTO sanhk_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","tadanantaraM te gItamekaM saMgIya bahi rjaitunaM zikhariNaM yayuH ");
INSERT INTO sanhk_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","atha yIzustAnuvAca nizAyAmasyAM mayi yuSmAkaM sarvveSAM pratyUho bhaviSyati yato likhitamAste yathA, meSANAM rakSakaJcAhaM prahariSyAmi vai tataH| meSANAM nivaho nUnaM pravikIrNo bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","kantu madutthAne jAte yuSmAkamagre'haM gAlIlaM vrajiSyAmi| ");
INSERT INTO sanhk_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","tadA pitaraH pratibabhASe, yadyapi sarvveSAM pratyUho bhavati tathApi mama naiva bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","tato yIzuruktAvAn ahaM tubhyaM tathyaM kathayAmi, kSaNAdAyAmadya kukkuTasya dvitIyavAraravaNAt pUrvvaM tvaM vAratrayaM mAmapahnoSyase| ");
INSERT INTO sanhk_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","kintu sa gADhaM vyAharad yadyapi tvayA sArddhaM mama prANo yAti tathApi kathamapi tvAM nApahnoSye; sarvve'pItare tathaiva babhASire| ");
INSERT INTO sanhk_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","aparaJca teSu getzimAnInAmakaM sthAna gateSu sa ziSyAn jagAda, yAvadahaM prArthaye tAvadatra sthAne yUyaM samupavizata| ");
INSERT INTO sanhk_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","atha sa pitaraM yAkUbaM yohanaJca gRhItvA vavrAja; atyantaM trAsito vyAkulitazca tebhyaH kathayAmAsa, ");
INSERT INTO sanhk_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","nidhanakAlavat prANo me'tIva daHkhameti, yUyaM jAgratotra sthAne tiSThata| ");
INSERT INTO sanhk_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","tataH sa kiJciddUraM gatvA bhUmAvadhomukhaH patitvA prArthitavAnetat, yadi bhavituM zakyaM tarhi duHkhasamayoyaM matto dUrIbhavatu| ");
INSERT INTO sanhk_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","aparamuditavAn he pita rhe pitaH sarvveM tvayA sAdhyaM, tato hetorimaM kaMsaM matto dUrIkuru, kintu tan mamecchAto na tavecchAto bhavatu| ");
INSERT INTO sanhk_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","tataH paraM sa etya tAn nidritAn nirIkSya pitaraM provAca, zimon tvaM kiM nidrAsi? ghaTikAmekAm api jAgarituM na zaknoSi? ");
INSERT INTO sanhk_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","parIkSAyAM yathA na patatha tadarthaM sacetanAH santaH prArthayadhvaM; mana udyuktamiti satyaM kintu vapurazaktikaM| ");
INSERT INTO sanhk_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","atha sa punarvrajitvA pUrvvavat prArthayAJcakre| ");
INSERT INTO sanhk_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","parAvRtyAgatya punarapi tAn nidritAn dadarza tadA teSAM locanAni nidrayA pUrNAni, tasmAttasmai kA kathA kathayitavyA ta etad boddhuM na zekuH| ");
INSERT INTO sanhk_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","tataHparaM tRtIyavAraM Agatya tebhyo 'kathayad idAnImapi zayitvA vizrAmyatha? yatheSTaM jAtaM, samayazcopasthitaH pazyata mAnavatanayaH pApilokAnAM pANiSu samarpyate| ");
INSERT INTO sanhk_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","uttiSThata, vayaM vrajAmo yo jano mAM parapANiSu samarpayiSyate pazyata sa samIpamAyAtaH| ");
INSERT INTO sanhk_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","imAM kathAM kathayati sa, etarhidvAdazAnAmeko yihUdA nAmA ziSyaH pradhAnayAjakAnAm upAdhyAyAnAM prAcInalokAnAJca sannidheH khaGgalaguDadhAriNo bahulokAn gRhItvA tasya samIpa upasthitavAn| ");
INSERT INTO sanhk_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","aparaJcAsau parapANiSu samarpayitA pUrvvamiti saGketaM kRtavAn yamahaM cumbiSyAmi sa evAsau tameva dhRtvA sAvadhAnaM nayata| ");
INSERT INTO sanhk_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ato hetoH sa Agatyaiva yozoH savidhaM gatvA he guro he guro, ityuktvA taM cucumba| ");
INSERT INTO sanhk_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","tadA te tadupari pANInarpayitvA taM dadhnuH| ");
INSERT INTO sanhk_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","tatastasya pArzvasthAnAM lokAnAmekaH khaGgaM niSkoSayan mahAyAjakasya dAsamekaM prahRtya tasya karNaM ciccheda| ");
INSERT INTO sanhk_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","pazcAd yIzustAn vyAjahAra khaGgAn laguDAMzca gRhItvA mAM kiM cauraM dharttAM samAyAtAH? ");
INSERT INTO sanhk_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","madhyemandiraM samupadizan pratyahaM yuSmAbhiH saha sthitavAnatahaM, tasmin kAle yUyaM mAM nAdIdharata, kintvanena zAstrIyaM vacanaM sedhanIyaM| ");
INSERT INTO sanhk_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","tadA sarvve ziSyAstaM parityajya palAyAJcakrire| ");
INSERT INTO sanhk_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","athaiko yuvA mAnavo nagnakAye vastramekaM nidhAya tasya pazcAd vrajan yuvalokai rdhRto ");
INSERT INTO sanhk_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","vastraM vihAya nagnaH palAyAJcakre| ");
INSERT INTO sanhk_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","aparaJca yasmin sthAne pradhAnayAjakA upAdhyAyAH prAcInalokAzca mahAyAjakena saha sadasi sthitAstasmin sthAne mahAyAjakasya samIpaM yIzuM ninyuH| ");
INSERT INTO sanhk_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","pitaro dUre tatpazcAd itvA mahAyAjakasyATTAlikAM pravizya kiGkaraiH sahopavizya vahnitApaM jagrAha| ");
INSERT INTO sanhk_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","tadAnIM pradhAnayAjakA mantriNazca yIzuM ghAtayituM tatprAtikUlyena sAkSiNo mRgayAJcakrire, kintu na prAptAH| ");
INSERT INTO sanhk_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","anekaistadviruddhaM mRSAsAkSye dattepi teSAM vAkyAni na samagacchanta| ");
INSERT INTO sanhk_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","sarvvazeSe kiyanta utthAya tasya prAtikUlyena mRSAsAkSyaM dattvA kathayAmAsuH, ");
INSERT INTO sanhk_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","idaM karakRtamandiraM vinAzya dinatrayamadhye punaraparam akarakRtaM mandiraM nirmmAsyAmi, iti vAkyam asya mukhAt zrutamasmAbhiriti| ");
INSERT INTO sanhk_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","kintu tatrApi teSAM sAkSyakathA na saGgAtAH| ");
INSERT INTO sanhk_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","atha mahAyAjako madhyesabham utthAya yIzuM vyAjahAra, ete janAstvayi yat sAkSyamaduH tvametasya kimapyuttaraM kiM na dAsyasi? ");
INSERT INTO sanhk_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","kintu sa kimapyuttaraM na datvA maunIbhUya tasyau; tato mahAyAjakaH punarapi taM pRSTAvAn tvaM saccidAnandasya tanayo 'bhiSiktastratA? ");
INSERT INTO sanhk_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","tadA yIzustaM provAca bhavAmyaham yUyaJca sarvvazaktimato dakSINapArzve samupavizantaM megha mAruhya samAyAntaJca manuSyaputraM sandrakSyatha| ");
INSERT INTO sanhk_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","tadA mahAyAjakaH svaM vamanaM chitvA vyAvaharat ");
INSERT INTO sanhk_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","kimasmAkaM sAkSibhiH prayojanam? IzvaranindAvAkyaM yuSmAbhirazrAvi kiM vicArayatha? tadAnIM sarvve jagadurayaM nidhanadaNDamarhati| ");
INSERT INTO sanhk_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","tataH kazcit kazcit tadvapuSi niSThIvaM nicikSepa tathA tanmukhamAcchAdya capeTena hatvA gaditavAn gaNayitvA vada, anucarAzca capeTaistamAjaghnuH ");
INSERT INTO sanhk_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","tataH paraM pitare'TTAlikAdhaHkoSThe tiSThati mahAyAjakasyaikA dAsI sametya ");
INSERT INTO sanhk_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","taM vihnitApaM gRhlantaM vilokya taM sunirIkSya babhASe tvamapi nAsaratIyayIzoH saGginAm eko jana AsIH| ");
INSERT INTO sanhk_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","kintu sopahnutya jagAda tamahaM na vadmi tvaM yat kathayami tadapyahaM na buddhye| tadAnIM pitare catvaraM gatavati kuेkkuTo rurAva| ");
INSERT INTO sanhk_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","athAnyA dAsI pitaraM dRSTvA samIpasthAn janAn jagAda ayaM teSAmeko janaH| ");
INSERT INTO sanhk_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","tataH sa dvitIyavAram apahnutavAn pazcAt tatrasthA lokAH pitaraM procustvamavazyaM teSAmeko janaH yatastvaM gAlIlIyo nara iti tavoccAraNaM prakAzayati| ");
INSERT INTO sanhk_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","tadA sa zapathAbhizApau kRtvA provAca yUyaM kathAM kathayatha taM naraM na jAne'haM| ");
INSERT INTO sanhk_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","tadAnIM dvitIyavAraM kukkuTo 'rAvIt| kukkuTasya dvitIyaravAt pUrvvaM tvaM mAM vAratrayam apahnoSyasi, iti yadvAkyaM yIzunA samuditaM tat tadA saMsmRtya pitaro roditum Arabhata| ");
INSERT INTO sanhk_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","atha prabhAte sati pradhAnayAjakAH prAJca upAdhyAyAH sarvve mantriNazca sabhAM kRtvA yIzuृM bandhayitva pIlAtAkhyasya dezAdhipateH savidhaM nItvA samarpayAmAsuH| ");
INSERT INTO sanhk_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","tadA pIlAtastaM pRSTavAn tvaM kiM yihUdIyalokAnAM rAjA? tataH sa pratyuktavAn satyaM vadasi| ");
INSERT INTO sanhk_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","aparaM pradhAnayAjakAstasya bahuSu vAkyeSu doSamAropayAJcakruH kintu sa kimapi na pratyuvAca| ");
INSERT INTO sanhk_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","tadAnIM pIlAtastaM punaH papraccha tvaM kiM nottarayasi? pazyaite tvadviruddhaM katiSu sAdhyeSu sAkSaM dadati| ");
INSERT INTO sanhk_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","kantu yIzustadApi nottaraM dadau tataH pIlAta AzcaryyaM jagAma| ");
INSERT INTO sanhk_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","aparaJca kArAbaddhe kastiMzcit jane tanmahotsavakAle lokai ryAcite dezAdhipatistaM mocayati| ");
INSERT INTO sanhk_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ye ca pUrvvamupaplavamakArSurupaplave vadhamapi kRtavantasteSAM madhye tadAnoM barabbAnAmaka eko baddha AsIt| ");
INSERT INTO sanhk_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ato hetoH pUrvvAparIyAM rItikathAM kathayitvA lokA uccairuvantaH pIlAtasya samakSaM nivedayAmAsuH| ");
INSERT INTO sanhk_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","tadA pIlAtastAnAcakhyau tarhi kiM yihUdIyAnAM rAjAnaM mocayiSyAmi? yuSmAbhiH kimiSyate? ");
INSERT INTO sanhk_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","yataH pradhAnayAjakA IrSyAta eva yIzuM samArpayanniti sa viveda| ");
INSERT INTO sanhk_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","kintu yathA barabbAM mocayati tathA prArthayituM pradhAnayAjakA lokAn pravarttayAmAsuH| ");
INSERT INTO sanhk_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","atha pIlAtaH punaH pRSTavAn tarhi yaM yihUdIyAnAM rAjeti vadatha tasya kiM kariSyAmi yuSmAbhiH kimiSyate? ");
INSERT INTO sanhk_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","tadA te punarapi proccaiH procustaM kruze vedhaya| ");
INSERT INTO sanhk_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","tasmAt pIlAtaH kathitavAn kutaH? sa kiM kukarmma kRtavAn? kintu te punazca ruvanto vyAjahrustaM kruze vedhaya| ");
INSERT INTO sanhk_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","tadA pIlAtaH sarvvAllokAn toSayitumicchan barabbAM mocayitvA yIzuM kazAbhiH prahRtya kruze veddhuM taM samarpayAmbabhUva| ");
INSERT INTO sanhk_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","anantaraM sainyagaNo'TTAlikAm arthAd adhipate rgRhaM yIzuM nItvA senAnivahaM samAhuyat| ");
INSERT INTO sanhk_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","pazcAt te taM dhUmalavarNavastraM paridhApya kaNTakamukuTaM racayitvA zirasi samAropya ");
INSERT INTO sanhk_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","he yihUdIyAnAM rAjan namaskAra ityuktvA taM namaskarttAmArebhire| ");
INSERT INTO sanhk_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","tasyottamAGge vetrAghAtaM cakrustadgAtre niSThIvaJca nicikSipuH, tathA tasya sammukhe jAnupAtaM praNomuH ");
INSERT INTO sanhk_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","itthamupahasya dhUmravarNavastram uttAryya tasya vastraM taM paryyadhApayan kruze veddhuM bahirninyuzca| ");
INSERT INTO sanhk_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","tataH paraM sekandarasya ruphasya ca pitA zimonnAmA kurINIyaloka ekaH kutazcid grAmAdetya pathi yAti taM te yIzoH kruzaM voDhuM balAd dadhnuH| ");
INSERT INTO sanhk_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","atha gulgaltA arthAt ziraHkapAlanAmakaM sthAnaM yIzumAnIya ");
INSERT INTO sanhk_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","te gandharasamizritaM drAkSArasaM pAtuM tasmai daduH kintu sa na jagrAha| ");
INSERT INTO sanhk_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","tasmin kruze viddhe sati teSAmekaikazaH kiM prApsyatIti nirNayAya ");
INSERT INTO sanhk_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","tasya paridheyAnAM vibhAgArthaM guTikApAtaM cakruH| ");
INSERT INTO sanhk_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","aparam eSa yihUdIyAnAM rAjeti likhitaM doSapatraM tasya ziraUrdvvam AropayAJcakruH| ");
INSERT INTO sanhk_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","tasya vAmadakSiNayo rdvau caurau kruzayo rvividhAte| ");
INSERT INTO sanhk_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","tenaiva \"aparAdhijanaiH sArddhaM sa gaNito bhaviSyati,\" iti zAstroktaM vacanaM siddhamabhUta| ");
INSERT INTO sanhk_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","anantaraM mArge ye ye lokA gamanAgamane cakruste sarvva eva zirAMsyAndolya nindanto jagaduH, re mandiranAzaka re dinatrayamadhye tannirmmAyaka, ");
INSERT INTO sanhk_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","adhunAtmAnam avitvA kruzAdavaroha| ");
INSERT INTO sanhk_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","kiJca pradhAnayAjakA adhyApakAzca tadvat tiraskRtya parasparaM cacakSire eSa parAnAvat kintu svamavituM na zaknoti| ");
INSERT INTO sanhk_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","yadIsrAyelo rAjAbhiSiktastrAtA bhavati tarhyadhunaina kruzAdavarohatu vayaM tad dRSTvA vizvasiSyAmaH; kiJca yau lokau tena sArddhaM kruze 'vidhyetAM tAvapi taM nirbhartsayAmAsatuH| ");
INSERT INTO sanhk_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","atha dvitIyayAmAt tRtIyayAmaM yAvat sarvvo dezaH sAndhakArobhUt| ");
INSERT INTO sanhk_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","tatastRtIyaprahare yIzuruccairavadat elI elI lAmA zivaktanI arthAd \"he madIza madIza tvaM paryyatyAkSIH kuto hi mAM?\" ");
INSERT INTO sanhk_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","tadA samIpasthalokAnAM kecit tadvAkyaM nizamyAcakhyuH pazyaiSa eliyam AhUyati| ");
INSERT INTO sanhk_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","tata eko jano dhAvitvAgatya spaJje 'mlarasaM pUrayitvA taM naDAgre nidhAya pAtuM tasmai dattvAvadat tiSTha eliya enamavarohayitum eti na veti pazyAmi| ");
INSERT INTO sanhk_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","atha yIzuruccaiH samAhUya prANAn jahau| ");
INSERT INTO sanhk_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","tadA mandirasya javanikordvvAdadhaHryyantA vidIrNA dvikhaNDAbhUt| ");
INSERT INTO sanhk_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","kiJca itthamuccairAhUya prANAn tyajantaM taM dRSdvA tadrakSaNAya niyukto yaH senApatirAsIt sovadat naroyam Izvaraputra iti satyam| ");
INSERT INTO sanhk_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","tadAnIM magdalInI marisam kaniSThayAkUbo yosezca mAtAnyamariyam zAlomI ca yAH striyo ");
INSERT INTO sanhk_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","gAlIlpradeze yIzuM sevitvA tadanugAminyo jAtA imAstadanyAzca yA anekA nAryo yIzunA sArddhaM yirUzAlamamAyAtAstAzca dUrAt tAni dadRzuH| ");
INSERT INTO sanhk_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","athAsAdanadinasyArthAd vizrAmavArAt pUrvvadinasya sAyaMkAla Agata ");
INSERT INTO sanhk_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","IzvararAjyApekSyarimathIyayUSaphanAmA mAnyamantrI sametya pIlAtasavidhaM nirbhayo gatvA yIzordehaM yayAce| ");
INSERT INTO sanhk_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","kintu sa idAnIM mRtaH pIlAta ityasambhavaM matvA zatasenApatimAhUya sa kadA mRta iti papraccha| ");
INSERT INTO sanhk_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","zatasemanApatimukhAt tajjJAtvA yUSaphe yIzordehaM dadau| ");
INSERT INTO sanhk_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","pazcAt sa sUkSmaM vAsaH krItvA yIzoH kAyamavarohya tena vAsasA veSTAyitvA girau khAtazmazAne sthApitavAn pASANaM loThayitvA dvAri nidadhe| ");
INSERT INTO sanhk_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","kintu yatra sosthApyata tata magdalInI mariyam yosimAtRmariyam ca dadRzatRH| ");
INSERT INTO sanhk_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","atha vizrAmavAre gate magdalInI mariyam yAkUbamAtA mariyam zAlomI cemAstaM marddayituM sugandhidravyANi krItvA ");
INSERT INTO sanhk_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","saptAhaprathamadine'tipratyUSe sUryyodayakAle zmazAnamupagatAH| ");
INSERT INTO sanhk_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","kintu zmazAnadvArapASANo'tibRhan taM ko'pasArayiSyatIti tAH parasparaM gadanti! ");
INSERT INTO sanhk_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","etarhi nirIkSya pASANo dvAro 'pasArita iti dadRzuH| ");
INSERT INTO sanhk_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","pazcAttAH zmazAnaM pravizya zuklavarNadIrghaparicchadAvRtamekaM yuvAnaM zmazAnadakSiNapArzva upaviSTaM dRSTvA camaccakruH| ");
INSERT INTO sanhk_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","so'vadat, mAbhaiSTa yUyaM kruze hataM nAsaratIyayIzuM gaveSayatha sotra nAsti zmazAnAdudasthAt; tai ryatra sa sthApitaH sthAnaM tadidaM pazyata| ");
INSERT INTO sanhk_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","kintu tena yathoktaM tathA yuSmAkamagre gAlIlaM yAsyate tatra sa yuSmAn sAkSAt kariSyate yUyaM gatvA tasya ziSyebhyaH pitarAya ca vArttAmimAM kathayata| ");
INSERT INTO sanhk_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","tAH kampitA vistitAzca tUrNaM zmazAnAd bahirgatvA palAyanta bhayAt kamapi kimapi nAvadaMzca| ");
INSERT INTO sanhk_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","aparaM yIzuH saptAhaprathamadine pratyUSe zmazAnAdutthAya yasyAH saptabhUtAstyAjitAstasyai magdalInImariyame prathamaM darzanaM dadau| ");
INSERT INTO sanhk_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","tataH sA gatvA zokarodanakRdbhyo'nugatalokebhyastAM vArttAM kathayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","kintu yIzuH punarjIvan tasyai darzanaM dattavAniti zrutvA te na pratyayan| ");
INSERT INTO sanhk_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","pazcAt teSAM dvAyo rgrAmayAnakAle yIzuranyavezaM dhRtvA tAbhyAM darzana dadau! ");
INSERT INTO sanhk_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","tAvapi gatvAnyaziSyebhyastAM kathAM kathayAJcakratuH kintu tayoH kathAmapi te na pratyayan| ");
INSERT INTO sanhk_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","zeSata ekAdazaziSyeSu bhojanopaviSTeSu yIzustebhyo darzanaM dadau tathotthAnAt paraM taddarzanaprAptalokAnAM kathAyAmavizvAsakaraNAt teSAmavizvAsamanaHkAThinyAbhyAM hetubhyAM sa tAMstarjitavAn| ");
INSERT INTO sanhk_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","atha tAnAcakhyau yUyaM sarvvajagad gatvA sarvvajanAn prati susaMvAdaM pracArayata| ");
INSERT INTO sanhk_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","tatra yaH kazcid vizvasya majjito bhavet sa paritrAsyate kintu yo na vizvasiSyati sa daNDayiSyate| ");
INSERT INTO sanhk_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","kiJca ye pratyeSyanti tairIdRg AzcaryyaM karmma prakAzayiSyate te mannAmnA bhUtAn tyAjayiSyanti bhASA anyAzca vadiSyanti| ");
INSERT INTO sanhk_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","aparaM taiH sarpeSu dhRteSu prANanAzakavastuni pIte ca teSAM kApi kSati rna bhaviSyati; rogiNAM gAtreSu karArpite te'rogA bhaviSyanti ca| ");
INSERT INTO sanhk_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","atha prabhustAnityAdizya svargaM nItaH san paramezvarasya dakSiNa upaviveza| ");
INSERT INTO sanhk_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","tataste prasthAya sarvvatra susaMvAdIyakathAM pracArayitumArebhire prabhustu teSAM sahAyaH san prakAzitAzcaryyakriyAbhistAM kathAM pramANavatIM cakAra| iti|");
INSERT INTO sanhk_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","prathamato ye sAkSiNo vAkyapracArakAzcAsan te'smAkaM madhye yadyat sapramANaM vAkyamarpayanti sma ");
INSERT INTO sanhk_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","tadanusArato'nyepi bahavastadvRttAntaM racayituM pravRttAH| ");
INSERT INTO sanhk_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ataeva he mahAmahimathiyaphil tvaM yA yAH kathA azikSyathAstAsAM dRDhapramANAni yathA prApnoSi ");
INSERT INTO sanhk_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","tadarthaM prathamamArabhya tAni sarvvANi jJAtvAhamapi anukramAt sarvvavRttAntAn tubhyaM lekhituM matimakArSam| ");
INSERT INTO sanhk_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","yihUdAdezIyaherodnAmake rAjatvaM kurvvati abIyayAjakasya paryyAyAdhikArI sikhariyanAmaka eko yAjako hAroNavaMzodbhavA ilIzevAkhyA ");
INSERT INTO sanhk_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","tasya jAyA dvAvimau nirdoSau prabhoH sarvvAjJA vyavasthAzca saMmanya IzvaradRSTau dhArmmikAvAstAm| ");
INSERT INTO sanhk_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","tayoH santAna ekopi nAsIt, yata ilIzevA bandhyA tau dvAveva vRddhAvabhavatAm| ");
INSERT INTO sanhk_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","yadA svaparyyAnukrameNa sikhariya IzvAsya samakSaM yAjakIyaM karmma karoti ");
INSERT INTO sanhk_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","tadA yajJasya dinaparipAyyA paramezvarasya mandire pravezakAle dhUpajvAlanaM karmma tasya karaNIyamAsIt| ");
INSERT INTO sanhk_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","taddhUpajvAlanakAle lokanivahe prArthanAM kartuM bahistiSThati ");
INSERT INTO sanhk_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","sati sikhariyo yasyAM vedyAM dhUpaM jvAlayati taddakSiNapArzve paramezvarasya dUta eka upasthito darzanaM dadau| ");
INSERT INTO sanhk_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","taM dRSTvA sikhariya udvivije zazaGke ca| ");
INSERT INTO sanhk_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","tadA sa dUtastaM babhASe he sikhariya mA bhaistava prArthanA grAhyA jAtA tava bhAryyA ilIzevA putraM prasoSyate tasya nAma yoेhan iti kariSyasi| ");
INSERT INTO sanhk_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","kiJca tvaM sAnandaH saharSazca bhaviSyasi tasya janmani bahava AnandiSyanti ca| ");
INSERT INTO sanhk_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","yato hetoH sa paramezvarasya gocare mahAn bhaviSyati tathA drAkSArasaM surAM vA kimapi na pAsyati, aparaM janmArabhya pavitreNAtmanA paripUrNaH ");
INSERT INTO sanhk_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","san isrAyelvaMzIyAn anekAn prabhoH paramezvarasya mArgamAneSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","santAnAn prati pitRNAM manAMsi dharmmajJAnaM pratyanAjJAgrAhiNazca parAvarttayituM, prabhoH paramezvarasya sevArtham ekAM sajjitajAtiM vidhAtuJca sa eliyarUpAtmazaktiprAptastasyAgre gamiSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","tadA sikhariyo dUtamavAdIt kathametad vetsyAmi? yatohaM vRddho mama bhAryyA ca vRddhA| ");
INSERT INTO sanhk_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","tato dUtaH pratyuvAca pazyezvarasya sAkSAdvarttI jibrAyelnAmA dUtohaM tvayA saha kathAM gadituM tubhyamimAM zubhavArttAM dAtuJca preSitaH| ");
INSERT INTO sanhk_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","kintu madIyaM vAkyaM kAle phaliSyati tat tvayA na pratItam ataH kAraNAd yAvadeva tAni na setsyanti tAvat tvaM vaktuMmazakto mUko bhava| ");
INSERT INTO sanhk_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","tadAnIM ye ye lokAH sikhariyamapaikSanta te madhyemandiraM tasya bahuvilambAd AzcaryyaM menire| ");
INSERT INTO sanhk_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","sa bahirAgato yadA kimapi vAkyaM vaktumazaktaH saGketaM kRtvA niHzabdastasyau tadA madhyemandiraM kasyacid darzanaM tena prAptam iti sarvve bubudhire| ");
INSERT INTO sanhk_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","anantaraM tasya sevanaparyyAye sampUrNe sati sa nijagehaM jagAma| ");
INSERT INTO sanhk_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","katipayadineSu gateSu tasya bhAryyA ilIzevA garbbhavatI babhUva ");
INSERT INTO sanhk_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","pazcAt sA paJcamAsAn saMgopyAkathayat lokAnAM samakSaM mamApamAnaM khaNDayituM paramezvaro mayi dRSTiM pAtayitvA karmmedRzaM kRtavAn| ");
INSERT INTO sanhk_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","aparaJca tasyA garbbhasya SaSThe mAse jAte gAlIlpradezIyanAsaratpure ");
INSERT INTO sanhk_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","dAyUdo vaMzIyAya yUSaphnAmne puruSAya yA mariyamnAmakumArI vAgdattAsIt tasyAH samIpaM jibrAyel dUta IzvareNa prahitaH| ");
INSERT INTO sanhk_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","sa gatvA jagAda he IzvarAnugRhItakanye tava zubhaM bhUyAt prabhuH paramezvarastava sahAyosti nArINAM madhye tvameva dhanyA| ");
INSERT INTO sanhk_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","tadAnIM sA taM dRSTvA tasya vAkyata udvijya kIdRzaM bhASaNamidam iti manasA cintayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","tato dUto'vadat he mariyam bhayaM mAkArSIH, tvayi paramezvarasyAnugrahosti| ");
INSERT INTO sanhk_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","pazya tvaM garbbhaM dhRtvA putraM prasoSyase tasya nAma yIzuriti kariSyasi| ");
INSERT INTO sanhk_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","sa mahAn bhaviSyati tathA sarvvebhyaH zreSThasya putra iti khyAsyati; aparaM prabhuH paramezvarastasya piturdAyUdaH siMhAsanaM tasmai dAsyati; ");
INSERT INTO sanhk_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","tathA sa yAkUbo vaMzopari sarvvadA rAjatvaM kariSyati, tasya rAjatvasyAnto na bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","tadA mariyam taM dUtaM babhASe nAhaM puruSasaGgaM karomi tarhi kathametat sambhaviSyati? ");
INSERT INTO sanhk_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","tato dUto'kathayat pavitra AtmA tvAmAzrAyiSyati tathA sarvvazreSThasya zaktistavopari chAyAM kariSyati tato hetostava garbbhAd yaH pavitrabAlako janiSyate sa Izvaraputra iti khyAtiM prApsyati| ");
INSERT INTO sanhk_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","aparaJca pazya tava jJAtirilIzevA yAM sarvve bandhyAmavadan idAnIM sA vArddhakye santAnamekaM garbbhe'dhArayat tasya SaSThamAsobhUt| ");
INSERT INTO sanhk_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","kimapi karmma nAsAdhyam Izvarasya| ");
INSERT INTO sanhk_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","tadA mariyam jagAda, pazya prabherahaM dAsI mahyaM tava vAkyAnusAreNa sarvvametad ghaTatAm; ananataraM dUtastasyAH samIpAt pratasthe| ");
INSERT INTO sanhk_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","atha katipayadinAt paraM mariyam tasmAt parvvatamayapradezIyayihUdAyA nagaramekaM zIghraM gatvA ");
INSERT INTO sanhk_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","sikhariyayAjakasya gRhaM pravizya tasya jAyAm ilIzevAM sambodhyAvadat| ");
INSERT INTO sanhk_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","tato mariyamaH sambodhanavAkye ilIzevAyAH karNayoH praviSTamAtre sati tasyA garbbhasthabAlako nanartta| tata ilIzevA pavitreNAtmanA paripUrNA satI ");
INSERT INTO sanhk_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","proccairgaditumArebhe, yoSitAM madhye tvameva dhanyA, tava garbbhasthaH zizuzca dhanyaH| ");
INSERT INTO sanhk_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","tvaM prabhormAtA, mama nivezane tvayA caraNAvarpitau, mamAdya saubhAgyametat| ");
INSERT INTO sanhk_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","pazya tava vAkye mama karNayoH praviSTamAtre sati mamodarasthaH zizurAnandAn nanartta| ");
INSERT INTO sanhk_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","yA strI vyazvasIt sA dhanyA, yato hetostAM prati paramezvaroktaM vAkyaM sarvvaM siddhaM bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","tadAnIM mariyam jagAda| dhanyavAdaM parezasya karoti mAmakaM manaH| ");
INSERT INTO sanhk_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","mamAtmA tArakeze ca samullAsaM pragacchati| ");
INSERT INTO sanhk_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","akarot sa prabhu rduSTiM svadAsyA durgatiM prati| pazyAdyArabhya mAM dhanyAM vakSyanti puruSAH sadA| ");
INSERT INTO sanhk_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","yaH sarvvazaktimAn yasya nAmApi ca pavitrakaM| sa eva sumahatkarmma kRtavAn mannimittakaM| ");
INSERT INTO sanhk_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ye bibhyati janAstasmAt teSAM santAnapaMktiSu| anukampA tadIyA ca sarvvadaiva sutiSThati| ");
INSERT INTO sanhk_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","svabAhubalatastena prAkAzyata parAkramaH| manaHkumantraNAsArddhaM vikIryyante'bhimAninaH| ");
INSERT INTO sanhk_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","siMhAsanagatAllokAn balinazcAvarohya saH| padeSUcceSu lokAMstu kSudrAn saMsthApayatyapi| ");
INSERT INTO sanhk_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","kSudhitAn mAnavAn dravyairuttamaiH paritarpya saH| sakalAn dhanino lokAn visRjed riktahastakAn| ");
INSERT INTO sanhk_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ibrAhImi ca tadvaMze yA dayAsti sadaiva tAM| smRtvA purA pitRNAM no yathA sAkSAt pratizrutaM| ");
INSERT INTO sanhk_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","isrAyelsevakastena tathopakriyate svayaM|| ");
INSERT INTO sanhk_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","anantaraM mariyam prAyeNa mAsatrayam ilIzevayA sahoSitvA vyAghuyya nijanivezanaM yayau| ");
INSERT INTO sanhk_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","tadanantaram ilIzevAyAH prasavakAla upasthite sati sA putraM prAsoSTa| ");
INSERT INTO sanhk_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","tataH paramezvarastasyAM mahAnugrahaM kRtavAn etat zrutvA samIpavAsinaH kuTumbAzcAgatya tayA saha mumudire| ");
INSERT INTO sanhk_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","tathASTame dine te bAlakasya tvacaM chettum etya tasya pitRnAmAnurUpaM tannAma sikhariya iti karttumISuH| ");
INSERT INTO sanhk_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","kintu tasya mAtAkathayat tanna, nAmAsya yohan iti karttavyam| ");
INSERT INTO sanhk_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","tadA te vyAharan tava vaMzamadhye nAmedRzaM kasyApi nAsti| ");
INSERT INTO sanhk_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","tataH paraM tasya pitaraM sikhariyaM prati saGketya papracchuH zizoH kiM nAma kAriSyate? ");
INSERT INTO sanhk_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","tataH sa phalakamekaM yAcitvA lilekha tasya nAma yohan bhaviSyati| tasmAt sarvve AzcaryyaM menire| ");
INSERT INTO sanhk_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","tatkSaNaM sikhariyasya jihvAjADye'pagate sa mukhaM vyAdAya spaSTavarNamuccAryya Izvarasya guNAnuvAdaM cakAra| ");
INSERT INTO sanhk_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","tasmAccaturdiksthAH samIpavAsilokA bhItA evametAH sarvvAH kathA yihUdAyAH parvvatamayapradezasya sarvvatra pracAritAH| ");
INSERT INTO sanhk_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","tasmAt zrotAro manaHsu sthApayitvA kathayAmbabhUvuH kIdRzoyaM bAlo bhaviSyati? atha paramezvarastasya sahAyobhUt| ");
INSERT INTO sanhk_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","tadA yohanaH pitA sikhariyaH pavitreNAtmanA paripUrNaH san etAdRzaM bhaviSyadvAkyaM kathayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","isrAyelaH prabhu ryastu sa dhanyaH paramezvaraH| anugRhya nijAllokAn sa eva parimocayet| ");
INSERT INTO sanhk_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","vipakSajanahastebhyo yathA mocyAmahe vayaM| yAvajjIvaJca dharmmeNa sAralyena ca nirbhayAH| ");
INSERT INTO sanhk_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","sevAmahai tamevaikam etatkAraNameva ca| svakIyaM supavitraJca saMsmRtya niyamaM sadA| ");
INSERT INTO sanhk_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","kRpayA puruSAn pUrvvAn nikaSArthAttu naH pituH| ibrAhImaH samIpe yaM zapathaM kRtavAn purA| ");
INSERT INTO sanhk_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","tameva saphalaM karttaM tathA zatrugaNasya ca| RृtIyAkAriNazcaiva karebhyo rakSaNAya naH| ");
INSERT INTO sanhk_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","sRSTeH prathamataH svIyaiH pavitrai rbhAvivAdibhiH| ");
INSERT INTO sanhk_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","yathoktavAn tathA svasya dAyUdaH sevakasya tu| ");
INSERT INTO sanhk_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","vaMze trAtAramekaM sa samutpAditavAn svayam| ");
INSERT INTO sanhk_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ato he bAlaka tvantu sarvvebhyaH zreSTha eva yaH| tasyaiva bhAvivAdIti pravikhyAto bhaviSyasi| asmAkaM caraNAn kSeme mArge cAlayituM sadA| evaM dhvAnte'rthato mRtyozchAyAyAM ye tu mAnavAH| ");
INSERT INTO sanhk_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","upaviSTAstu tAneva prakAzayitumeva hi| kRtvA mahAnukampAM hi yAmeva paramezvaraH| ");
INSERT INTO sanhk_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","UrdvvAt sUryyamudAyyaivAsmabhyaM prAdAttu darzanaM| tayAnukampayA svasya lokAnAM pApamocane| ");
INSERT INTO sanhk_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","paritrANasya tebhyo hi jJAnavizrANanAya ca| prabho rmArgaM pariSkarttuM tasyAgrAyI bhaviSyasi|| ");
INSERT INTO sanhk_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","atha bAlakaH zarIreNa buddhyA ca varddhitumArebhe; aparaJca sa isrAyelo vaMzIyalokAnAM samIpe yAvanna prakaTIbhUtastAstAvat prAntare nyavasat| ");
INSERT INTO sanhk_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","aparaJca tasmin kAle rAjyasya sarvveSAM lokAnAM nAmAni lekhayitum agastakaisara AjJApayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","tadanusAreNa kurINiyanAmani suriyAdezasya zAsake sati nAmalekhanaM prArebhe| ");
INSERT INTO sanhk_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","ato heto rnAma lekhituM sarvve janAH svIyaM svIyaM nagaraM jagmuH| ");
INSERT INTO sanhk_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","tadAnIM yUSaph nAma lekhituM vAgdattayA svabhAryyayA garbbhavatyA mariyamA saha svayaM dAyUdaH sajAtivaMza iti kAraNAd gAlIlpradezasya nAsaratnagarAd ");
INSERT INTO sanhk_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","yihUdApradezasya baitlehamAkhyaM dAyUdnagaraM jagAma| ");
INSERT INTO sanhk_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","anyacca tatra sthAne tayostiSThatoH sato rmariyamaH prasUtikAla upasthite ");
INSERT INTO sanhk_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","sA taM prathamasutaM prAsoSTa kintu tasmin vAsagRhe sthAnAbhAvAd bAlakaM vastreNa veSTayitvA gozAlAyAM sthApayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","anantaraM ye kiyanto meSapAlakAH svameSavrajarakSAyai tatpradeze sthitvA rajanyAM prAntare prahariNaH karmma kurvvanti, ");
INSERT INTO sanhk_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","teSAM samIpaM paramezvarasya dUta Agatyopatasthau; tadA catuSpArzve paramezvarasya tejasaH prakAzitatvAt te'tizazaGkire| ");
INSERT INTO sanhk_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","tadA sa dUta uvAca mA bhaiSTa pazyatAdya dAyUdaH pure yuSmannimittaM trAtA prabhuH khrISTo'janiSTa, ");
INSERT INTO sanhk_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","sarvveSAM lokAnAM mahAnandajanakam imaM maGgalavRttAntaM yuSmAn jJApayAmi| ");
INSERT INTO sanhk_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","yUyaM (tatsthAnaM gatvA) vastraveSTitaM taM bAlakaM gozAlAyAM zayanaM drakSyatha yuSmAn pratIdaM cihnaM bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","dUta imAM kathAM kathitavati tatrAkasmAt svargIyAH pRtanA Agatya kathAm imAM kathayitvezvarasya guNAnanvavAdiSuH, yathA, ");
INSERT INTO sanhk_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","sarvvordvvasthairIzvarasya mahimA samprakAzyatAM| zAntirbhUyAt pRthivyAstu santoSazca narAn prati|| ");
INSERT INTO sanhk_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","tataH paraM teSAM sannidhe rdUtagaNe svargaM gate meSapAlakAH parasparam avecan Agacchata prabhuH paramezvaro yAM ghaTanAM jJApitavAn tasyA yAtharyaM jJAtuM vayamadhunA baitlehampuraM yAmaH| ");
INSERT INTO sanhk_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","pazcAt te tUrNaM vrajitvA mariyamaM yUSaphaM gozAlAyAM zayanaM bAlakaJca dadRzuH| ");
INSERT INTO sanhk_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","itthaM dRSTvA bAlakasyArthe proktAM sarvvakathAM te prAcArayAJcakruH| ");
INSERT INTO sanhk_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","tato ye lokA meSarakSakANAM vadanebhyastAM vArttAM zuzruvuste mahAzcaryyaM menire| ");
INSERT INTO sanhk_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","kintu mariyam etatsarvvaghaTanAnAM tAtparyyaM vivicya manasi sthApayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","tatpazcAd dUtavijJaptAnurUpaM zrutvA dRSTvA ca meSapAlakA Izvarasya guNAnuvAdaM dhanyavAdaJca kurvvANAH parAvRtya yayuH| ");
INSERT INTO sanhk_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","atha bAlakasya tvakchedanakAle'STamadivase samupasthite tasya garbbhasthiteH purvvaM svargIyadUto yathAjJApayat tadanurUpaM te tannAmadheyaM yIzuriti cakrire| ");
INSERT INTO sanhk_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","tataH paraM mUsAlikhitavyavasthAyA anusAreNa mariyamaH zucitvakAla upasthite, ");
INSERT INTO sanhk_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","\"prathamajaH sarvvaH puruSasantAnaH paramezvare samarpyatAM,\" iti paramezvarasya vyavasthayA ");
INSERT INTO sanhk_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","yIzuM paramezvare samarpayitum zAstrIyavidhyuktaM kapotadvayaM pArAvatazAvakadvayaM vA baliM dAtuM te taM gRhItvA yirUzAlamam AyayuH| ");
INSERT INTO sanhk_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","yirUzAlampuranivAsI zimiyonnAmA dhArmmika eka AsIt sa isrAyelaH sAntvanAmapekSya tasthau kiJca pavitra AtmA tasminnAvirbhUtaH| ");
INSERT INTO sanhk_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","aparaM prabhuNA paramezvareNAbhiSikte trAtari tvayA na dRSTe tvaM na mariSyasIti vAkyaM pavitreNa AtmanA tasma prAkathyata| ");
INSERT INTO sanhk_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","aparaJca yadA yIzoH pitA mAtA ca tadarthaM vyavasthAnurUpaM karmma karttuM taM mandiram AninyatustadA ");
INSERT INTO sanhk_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","zimiyon Atmana AkarSaNena mandiramAgatya taM kroDe nidhAya Izvarasya dhanyavAdaM kRtvA kathayAmAsa, yathA, ");
INSERT INTO sanhk_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","he prabho tava dAsoyaM nijavAkyAnusArataH| idAnIntu sakalyANo bhavatA saMvisRjyatAm| ");
INSERT INTO sanhk_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","yataH sakaladezasya dIptaye dIptirUpakaM| ");
INSERT INTO sanhk_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","isrAyelIyalokasya mahAgauravarUpakaM| ");
INSERT INTO sanhk_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","yaM trAyakaM janAnAntu sammukhe tvamajIjanaH| saeva vidyate'smAkaM dhravaM nayananagocare|| ");
INSERT INTO sanhk_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","tadAnIM tenoktA etAH sakalAH kathAH zrutvA tasya mAtA yUSaph ca vismayaM menAte| ");
INSERT INTO sanhk_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","tataH paraM zimiyon tebhya AziSaM dattvA tanmAtaraM mariyamam uvAca, pazya isrAyelo vaMzamadhye bahUnAM pAtanAyotthApanAya ca tathA virodhapAtraM bhavituM, bahUnAM guptamanogatAnAM prakaTIkaraNAya bAlakoyaM niyuktosti| ");
INSERT INTO sanhk_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","tasmAt tavApi prANAH zUlena vyatsyante| ");
INSERT INTO sanhk_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","aparaJca Azerasya vaMzIyaphinUyelo duhitA hannAkhyA atijaratI bhaviSyadvAdinyekA yA vivAhAt paraM sapta vatsarAn patyA saha nyavasat tato vidhavA bhUtvA caturazItivarSavayaHparyyanataM ");
INSERT INTO sanhk_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","mandire sthitvA prArthanopavAsairdivAnizam Izvaram asevata sApi strI tasmin samaye mandiramAgatya ");
INSERT INTO sanhk_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","paramezvarasya dhanyavAdaM cakAra, yirUzAlampuravAsino yAvanto lokA muktimapekSya sthitAstAn yIzorvRttAntaM jJApayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","itthaM paramezvarasya vyavasthAnusAreNa sarvveSu karmmasu kRteSu tau punazca gAlIlo nAsaratnAmakaM nijanagaraM pratasthAte| ");
INSERT INTO sanhk_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","tatpazcAd bAlakaH zarIreNa vRddhimetya jJAnena paripUrNa AtmanA zaktimAMzca bhavitumArebhe tathA tasmin IzvarAnugraho babhUva| ");
INSERT INTO sanhk_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","tasya pitA mAtA ca prativarSaM nistArotsavasamaye yirUzAlamam agacchatAm| ");
INSERT INTO sanhk_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","aparaJca yIzau dvAdazavarSavayaske sati tau parvvasamayasya rItyanusAreNa yirUzAlamaM gatvA ");
INSERT INTO sanhk_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","pArvvaNaM sampAdya punarapi vyAghuyya yAtaH kintu yIzurbAlako yirUzAlami tiSThati| yUSaph tanmAtA ca tad aviditvA ");
INSERT INTO sanhk_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","sa saGgibhiH saha vidyata etacca budvvA dinaikagamyamArgaM jagmatuH| kintu zeSe jJAtibandhUnAM samIpe mRgayitvA taduddeेzamaprApya ");
INSERT INTO sanhk_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","tau punarapi yirUzAlamam parAvRtyAgatya taM mRgayAJcakratuH| ");
INSERT INTO sanhk_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","atha dinatrayAt paraM paNDitAnAM madhye teSAM kathAH zRNvan tattvaM pRcchaMzca mandire samupaviSTaH sa tAbhyAM dRSTaH| ");
INSERT INTO sanhk_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","tadA tasya buddhyA pratyuttaraizca sarvve zrotAro vismayamApadyante| ");
INSERT INTO sanhk_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","tAdRzaM dRSTvA tasya janako jananI ca camaccakratuH kiJca tasya mAtA tamavadat, he putra, kathamAvAM pratItthaM samAcarastvam? pazya tava pitAhaJca zokAkulau santau tvAmanvicchAvaH sma| ");
INSERT INTO sanhk_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","tataH sovadat kuto mAm anvaicchataM? piturgRhe mayA sthAtavyam etat kiM yuvAbhyAM na jJAyate? ");
INSERT INTO sanhk_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","kintu tau tasyaitadvAkyasya tAtparyyaM boddhuM nAzaknutAM| ");
INSERT INTO sanhk_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","tataH paraM sa tAbhyAM saha nAsarataM gatvA tayorvazIbhUtastasthau kintu sarvvA etAH kathAstasya mAtA manasi sthApayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","atha yIzo rbuddhiH zarIraJca tathA tasmin Izvarasya mAnavAnAJcAnugraho varddhitum Arebhe| ");
INSERT INTO sanhk_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","anantaraM tibiriyakaisarasya rAjatvasya paJcadaze vatsare sati yadA pantIyapIlAto yihUdAdezAdhipati rherod tu gAlIlpradezasya rAjA philipanAmA tasya bhrAtA tu yitUriyAyAstrAkhonItiyApradezasya ca rAjAsIt luSAnIyanAmA avilInIdezasya rAjAsIt ");
INSERT INTO sanhk_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","hAnan kiyaphAzcemau pradhAnayAjAkAvAstAM tadAnIM sikhariyasya putrAya yohane madhyeprAntaram Izvarasya vAkye prakAzite sati ");
INSERT INTO sanhk_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","sa yarddana ubhayataTapradezAn sametya pApamocanArthaM manaHparAvarttanasya cihnarUpaM yanmajjanaM tadIyAH kathAH sarvvatra pracArayitumArebhe| ");
INSERT INTO sanhk_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","yizayiyabhaviSyadvaktRgranthe yAdRzI lipirAste yathA, paramezasya panthAnaM pariSkuruta sarvvataH| tasya rAjapathaJcaiva samAnaM kurutAdhunA| ");
INSERT INTO sanhk_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","kAriSyante samucchrAyAH sakalA nimnabhUmayaH| kAriSyante natAH sarvve parvvatAzcopaparvvatAH| kAriSyante ca yA vakrAstAH sarvvAH saralA bhuvaH| kAriSyante samAnAstA yA uccanIcabhUmayaH| ");
INSERT INTO sanhk_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","IzvareNa kRtaM trANaM drakSyanti sarvvamAnavAH| ityetat prAntare vAkyaM vadataH kasyacid ravaH|| ");
INSERT INTO sanhk_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ye ye lokA majjanArthaM bahirAyayustAn sovadat re re sarpavaMzA AgAminaH kopAt palAyituM yuSmAn kazcetayAmAsa? ");
INSERT INTO sanhk_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","tasmAd ibrAhIm asmAkaM pitA kathAmIdRzIM manobhi rna kathayitvA yUyaM manaHparivarttanayogyaM phalaM phalata; yuSmAnahaM yathArthaM vadAmi pASANebhya etebhya Izvara ibrAhImaH santAnotpAdane samarthaH| ");
INSERT INTO sanhk_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","aparaJca tarumUle'dhunApi parazuH saMlagnosti yastaruruttamaM phalaM na phalati sa chidyate'gnau nikSipyate ca| ");
INSERT INTO sanhk_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","tadAnIM lokAstaM papracchustarhi kiM karttavyamasmAbhiH? ");
INSERT INTO sanhk_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","tataH sovAdIt yasya dve vasane vidyete sa vastrahInAyaikaM vitaratu kiMJca yasya khAdyadravyaM vidyate sopi tathaiva karotu| ");
INSERT INTO sanhk_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","tataH paraM karasaJcAyino majjanArtham Agatya papracchuH he guro kiM karttavyamasmAbhiH? ");
INSERT INTO sanhk_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","tataH sokathayat nirUpitAdadhikaM na gRhlita| ");
INSERT INTO sanhk_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","anantaraM senAgaNa etya papraccha kimasmAbhi rvA karttavyam? tataH sobhidadhe kasya kAmapi hAniM mA kArSTa tathA mRSApavAdaM mA kuruta nijavetanena ca santuSya tiSThata| ");
INSERT INTO sanhk_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","aparaJca lokA apekSayA sthitvA sarvvepIti manobhi rvitarkayAJcakruH, yohanayam abhiSiktastrAtA na veti? ");
INSERT INTO sanhk_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","tadA yohan sarvvAn vyAjahAra, jale'haM yuSmAn majjayAmi satyaM kintu yasya pAdukAbandhanaM mocayitumapi na yogyosmi tAdRza eko matto gurutaraH pumAn eti, sa yuSmAn vahnirUpe pavitra Atmani majjayiSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","aparaJca tasya haste zUrpa Aste sa svazasyAni zuddharUpaM prasphoTya godhUmAn sarvvAn bhANDAgAre saMgrahISyati kintu bUSANi sarvvANyanirvvANavahninA dAhayiSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","yohan upadezenetthaM nAnAkathA lokAnAM samakSaM pracArayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","aparaJca herod rAjA philipnAmnaH sahodarasya bhAryyAM herodiyAmadhi tathAnyAni yAni yAni kukarmmANi kRtavAn tadadhi ca ");
INSERT INTO sanhk_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","yohanA tiraskRto bhUtvA kArAgAre tasya bandhanAd aparamapi kukarmma cakAra| ");
INSERT INTO sanhk_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","itaH pUrvvaM yasmin samaye sarvve yohanA majjitAstadAnIM yIzurapyAgatya majjitaH| ");
INSERT INTO sanhk_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","tadanantaraM tena prArthite meghadvAraM muktaM tasmAcca pavitra AtmA mUrttimAn bhUtvA kapotavat taduparyyavaruroha; tadA tvaM mama priyaH putrastvayi mama paramaH santoSa ityAkAzavANI babhUva| ");
INSERT INTO sanhk_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","tadAnIM yIzuH prAyeNa triMzadvarSavayaska AsIt| laukikajJAne tu sa yUSaphaH putraH, ");
INSERT INTO sanhk_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","yUSaph eleH putraH, elirmattataH putraH, mattat leveH putraH, levi rmalkeH putraH, malkiryAnnasya putraH; yAnno yUSaphaH putraH| ");
INSERT INTO sanhk_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","yUSaph mattathiyasya putraH, mattathiya AmosaH putraH, Amos nahUmaH putraH, nahUm iSleH putraH iSlirnageH putraH| ");
INSERT INTO sanhk_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","nagirmATaH putraH, mAT mattathiyasya putraH, mattathiyaH zimiyeH putraH, zimiyiryUSaphaH putraH, yUSaph yihUdAH putraH| ");
INSERT INTO sanhk_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","yihUdA yohAnAH putraH, yohAnA rISAH putraH, rISAH sirubbAbilaH putraH, sirubbAbil zaltIyelaH putraH, zaltIyel nereH putraH| ");
INSERT INTO sanhk_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","nerirmalkeH putraH, malkiH adyaH putraH, addI koSamaH putraH, koSam ilmodadaH putraH, ilmodad eraH putraH| ");
INSERT INTO sanhk_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","er yozeH putraH, yoziH ilIyeSaraH putraH, ilIyeSar yorImaH putraH, yorIm mattataH putraH, mattata leveH putraH| ");
INSERT INTO sanhk_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","leviH zimiyonaH putraH, zimiyon yihUdAH putraH, yihUdA yUSuphaH putraH, yUSuph yonanaH putraH, yAnan ilIyAkImaH putraH| ");
INSERT INTO sanhk_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","iliyAkImH mileyAH putraH, mileyA mainanaH putraH, mainan mattattasya putraH, mattatto nAthanaH putraH, nAthan dAyUdaH putraH| ");
INSERT INTO sanhk_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","dAyUd yizayaH putraH, yizaya obedaH putra, obed boyasaH putraH, boyas salmonaH putraH, salmon nahazonaH putraH| ");
INSERT INTO sanhk_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","nahazon ammInAdabaH putraH, ammInAdab arAmaH putraH, arAm hiSroNaH putraH, hiSroN perasaH putraH, peras yihUdAH putraH| ");
INSERT INTO sanhk_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","yihUdA yAkUbaH putraH, yAkUb ishAkaH putraH, ishAk ibrAhImaH putraH, ibrAhIm terahaH putraH, terah nAhoraH putraH| ");
INSERT INTO sanhk_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","nAhor sirugaH putraH, sirug riyvaH putraH, riyUH pelagaH putraH, pelag evaraH putraH, evar zelahaH putraH| ");
INSERT INTO sanhk_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","zelah kainanaH putraH, kainan arphakSadaH putraH, arphakSad zAmaH putraH, zAm nohaH putraH, noho lemakaH putraH| ");
INSERT INTO sanhk_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","lemak mithUzelahaH putraH, mithUzelah hanokaH putraH, hanok yeradaH putraH, yerad mahalalelaH putraH, mahalalel kainanaH putraH| ");
INSERT INTO sanhk_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","kainan inozaH putraH, inoz zetaH putraH, zet AdamaH putra, Adam Izvarasya putraH| ");
INSERT INTO sanhk_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","tataH paraM yIzuH pavitreNAtmanA pUrNaH san yarddananadyAH parAvRtyAtmanA prAntaraM nItaH san catvAriMzaddinAni yAvat zaitAnA parIkSito'bhUt, ");
INSERT INTO sanhk_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","kiJca tAni sarvvadinAni bhojanaM vinA sthitatvAt kAle pUrNe sa kSudhitavAn| ");
INSERT INTO sanhk_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","tataH zaitAnAgatya tamavadat tvaM cedIzvarasya putrastarhi prastarAnetAn AjJayA pUpAn kuru| ");
INSERT INTO sanhk_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","tadA yIzuruvAca, lipirIdRzI vidyate manujaH kevalena pUpena na jIvati kintvIzvarasya sarvvAbhirAjJAbhi rjIvati| ");
INSERT INTO sanhk_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","tadA zaitAn tamuccaM parvvataM nItvA nimiSaikamadhye jagataH sarvvarAjyAni darzitavAn| ");
INSERT INTO sanhk_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","pazcAt tamavAdIt sarvvam etad vibhavaM pratApaJca tubhyaM dAsyAmi tan mayi samarpitamAste yaM prati mamecchA jAyate tasmai dAtuM zaknomi, ");
INSERT INTO sanhk_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","tvaM cenmAM bhajase tarhi sarvvametat tavaiva bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","tadA yIzustaM pratyuktavAn dUrI bhava zaitAn lipirAste, nijaM prabhuM paramezvaraM bhajasva kevalaM tameva sevasva ca| ");
INSERT INTO sanhk_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","atha zaitAn taM yirUzAlamaM nItvA mandirasya cUDAyA upari samupavezya jagAda tvaM cedIzvarasya putrastarhi sthAnAdito lamphitvAdhaH ");
INSERT INTO sanhk_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","pata yato lipirAste, AjJApayiSyati svIyAn dUtAn sa paramezvaraH| ");
INSERT INTO sanhk_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","rakSituM sarvvamArge tvAM tena tvaccaraNe yathA| na laget prastarAghAtastvAM dhariSyanti te tathA| ");
INSERT INTO sanhk_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","tadA yIzunA pratyuktam idamapyuktamasti tvaM svaprabhuM parezaM mA parIkSasva| ");
INSERT INTO sanhk_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","pazcAt zaitAn sarvvaparIkSAM samApya kSaNAttaM tyaktvA yayau| ");
INSERT INTO sanhk_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","tadA yIzurAtmaprabhAvAt punargAlIlpradezaM gatastadA tatsukhyAtizcaturdizaM vyAnaze| ");
INSERT INTO sanhk_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","sa teSAM bhajanagRheSu upadizya sarvvaiH prazaMsito babhUva| ");
INSERT INTO sanhk_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","atha sa svapAlanasthAnaM nAsaratpurametya vizrAmavAre svAcArAd bhajanagehaM pravizya paThitumuttasthau| ");
INSERT INTO sanhk_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","tato yizayiyabhaviSyadvAdinaH pustake tasya karadatte sati sa tat pustakaM vistAryya yatra vakSyamANAni vacanAni santi tat sthAnaM prApya papATha| ");
INSERT INTO sanhk_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","AtmA tu paramezasya madIyopari vidyate| daridreSu susaMvAdaM vaktuM mAM sobhiSiktavAn| bhagnAntaH karaNAllokAn susvasthAn karttumeva ca| bandIkRteSu lokeSu mukte rghoSayituM vacaH| netrANi dAtumandhebhyastrAtuM baddhajanAnapi| ");
INSERT INTO sanhk_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","parezAnugrahe kAlaM pracArayitumeva ca| sarvvaitatkaraNArthAya mAmeva prahiNoti saH|| ");
INSERT INTO sanhk_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","tataH pustakaM badvvA paricArakasya haste samarpya cAsane samupaviSTaH, tato bhajanagRhe yAvanto lokA Asan te sarvve'nanyadRSTyA taM vilulokire| ");
INSERT INTO sanhk_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","anantaram adyaitAni sarvvANi likhitavacanAni yuSmAkaM madhye siddhAni sa imAM kathAM tebhyaH kathayitumArebhe| ");
INSERT INTO sanhk_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","tataH sarvve tasmin anvarajyanta, kiJca tasya mukhAnnirgatAbhiranugrahasya kathAbhizcamatkRtya kathayAmAsuH kimayaM yUSaphaH putro na? ");
INSERT INTO sanhk_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","tadA so'vAdId he cikitsaka svameva svasthaM kuru kapharnAhUmi yadyat kRtavAn tadazrauSma tAH sarvAH kriyA atra svadeze kuru kathAmetAM yUyamevAvazyaM mAM vadiSyatha| ");
INSERT INTO sanhk_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","punaH sovAdId yuSmAnahaM yathArthaM vadAmi, kopi bhaviSyadvAdI svadeze satkAraM na prApnoti| ");
INSERT INTO sanhk_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","aparaJca yathArthaM vacmi, eliyasya jIvanakAle yadA sArddhatritayavarSANi yAvat jaladapratibandhAt sarvvasmin deze mahAdurbhikSam ajaniSTa tadAnIm isrAyelo dezasya madhye bahvyo vidhavA Asan, ");
INSERT INTO sanhk_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","kintu sIdonpradezIyasAriphatpuranivAsinIm ekAM vidhavAM vinA kasyAzcidapi samIpe eliyaH prerito nAbhUt| ");
INSERT INTO sanhk_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","aparaJca ilIzAyabhaviSyadvAdividyamAnatAkAle isrAyeldeze bahavaH kuSThina Asan kintu surIyadezIyaM nAmAnkuSThinaM vinA kopyanyaH pariSkRto nAbhUt| ");
INSERT INTO sanhk_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","imAM kathAM zrutvA bhajanagehasthitA lokAH sakrodham utthAya ");
INSERT INTO sanhk_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","nagarAttaM bahiSkRtya yasya zikhariNa upari teSAM nagaraM sthApitamAste tasmAnnikSeptuM tasya zikharaM taM ninyuH ");
INSERT INTO sanhk_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","kintu sa teSAM madhyAdapasRtya sthAnAntaraM jagAma| ");
INSERT INTO sanhk_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","tataH paraM yIzurgAlIlpradezIyakapharnAhUmnagara upasthAya vizrAmavAre lokAnupadeSTum ArabdhavAn| ");
INSERT INTO sanhk_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","tadupadezAt sarvve camaccakru ryatastasya kathA gurutarA Asan| ");
INSERT INTO sanhk_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","tadAnIM tadbhajanagehasthito'medhyabhUtagrasta eko jana uccaiH kathayAmAsa, ");
INSERT INTO sanhk_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","he nAsaratIyayIzo'smAn tyaja, tvayA sahAsmAkaM kaH sambandhaH? kimasmAn vinAzayitumAyAsi? tvamIzvarasya pavitro jana etadahaM jAnAmi| ");
INSERT INTO sanhk_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","tadA yIzustaM tarjayitvAvadat maunI bhava ito bahirbhava; tataH somedhyabhUtastaM madhyasthAne pAtayitvA kiJcidapyahiMsitvA tasmAd bahirgatavAn| ");
INSERT INTO sanhk_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","tataH sarvve lokAzcamatkRtya parasparaM vaktumArebhire koyaM camatkAraH| eSa prabhAveNa parAkrameNa cAmedhyabhUtAn AjJApayati tenaiva te bahirgacchanti| ");
INSERT INTO sanhk_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","anantaraM caturdiksthadezAn tasya sukhyAtirvyApnot| ");
INSERT INTO sanhk_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","tadanantaraM sa bhajanagehAd bahirAgatya zimono nivezanaM praviveza tadA tasya zvazrUrjvareNAtyantaM pIDitAsIt ziSyAstadarthaM tasmin vinayaM cakruH| ");
INSERT INTO sanhk_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","tataH sa tasyAH samIpe sthitvA jvaraM tarjayAmAsa tenaiva tAM jvaro'tyAkSIt tataH sA tatkSaNam utthAya tAn siSeve| ");
INSERT INTO sanhk_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","atha sUryyAstakAle sveSAM ye ye janA nAnArogaiH pIDitA Asan lokAstAn yIzoH samIpam AninyuH, tadA sa ekaikasya gAtre karamarpayitvA tAnarogAn cakAra| ");
INSERT INTO sanhk_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","tato bhUtA bahubhyo nirgatya cItzabdaM kRtvA ca babhASire tvamIzvarasya putro'bhiSiktatrAtA; kintu sobhiSiktatrAteti te vividuretasmAt kAraNAt tAn tarjayitvA tadvaktuM niSiSedha| ");
INSERT INTO sanhk_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","aparaJca prabhAte sati sa vijanasthAnaM pratasthe pazcAt janAstamanvicchantastannikaTaM gatvA sthAnAntaragamanArthaM tamanvarundhan| ");
INSERT INTO sanhk_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","kintu sa tAn jagAda, IzvarIyarAjyasya susaMvAdaM pracArayitum anyAni purANyapi mayA yAtavyAni yatastadarthameva preritohaM| ");
INSERT INTO sanhk_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","atha gAlIlo bhajanageheSu sa upadideza| ");
INSERT INTO sanhk_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","anantaraM yIzurekadA gineSarathdasya tIra uttiSThati, tadA lokA IzvarIyakathAM zrotuM tadupari prapatitAH| ");
INSERT INTO sanhk_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","tadAnIM sa hdasya tIrasamIpe naudvayaM dadarza kiJca matsyopajIvino nAvaM vihAya jAlaM prakSAlayanti| ");
INSERT INTO sanhk_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","tatastayordvayo rmadhye zimono nAvamAruhya tIrAt kiJciddUraM yAtuM tasmin vinayaM kRtvA naukAyAmupavizya lokAn propadiSTavAn| ");
INSERT INTO sanhk_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","pazcAt taM prastAvaM samApya sa zimonaM vyAjahAra, gabhIraM jalaM gatvA matsyAn dharttuM jAlaM nikSipa| ");
INSERT INTO sanhk_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","tataH zimona babhASe, he guro yadyapi vayaM kRtsnAM yAminIM parizramya matsyaikamapi na prAptAstathApi bhavato nidezato jAlaM kSipAmaH| ");
INSERT INTO sanhk_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","atha jAle kSipte bahumatsyapatanAd AnAyaH pracchinnaH| ");
INSERT INTO sanhk_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","tasmAd upakarttum anyanausthAn saGgina AyAtum iGgitena samAhvayan tatasta Agatya matsyai rnaudvayaM prapUrayAmAsu ryai rnaudvayaM pramagnam| ");
INSERT INTO sanhk_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","tadA zimonpitarastad vilokya yIzozcaraNayoH patitvA, he prabhohaM pApI naro mama nikaTAd bhavAn yAtu, iti kathitavAn| ");
INSERT INTO sanhk_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","yato jAle patitAnAM matsyAnAM yUthAt zimon tatsaGginazca camatkRtavantaH; zimonaH sahakAriNau sivadeH putrau yAkUb yohan cemau tAdRzau babhUvatuH| ");
INSERT INTO sanhk_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","tadA yIzuH zimonaM jagAda mA bhaiSIradyArabhya tvaM manuSyadharo bhaviSyasi| ");
INSERT INTO sanhk_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","anantaraM sarvvAsu nausu tIram AnItAsu te sarvvAn parityajya tasya pazcAdgAmino babhUvuH| ");
INSERT INTO sanhk_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","tataH paraM yIzau kasmiMzcit pure tiSThati jana ekaH sarvvAGgakuSThastaM vilokya tasya samIpe nyubjaH patitvA savinayaM vaktumArebhe, he prabho yadi bhavAnicchati tarhi mAM pariSkarttuM zaknoti| ");
INSERT INTO sanhk_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","tadAnIM sa pANiM prasAryya tadaGgaM spRzan babhASe tvaM pariSkriyasveti mamecchAsti tatastatkSaNaM sa kuSThAt muktaH| ");
INSERT INTO sanhk_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","pazcAt sa tamAjJApayAmAsa kathAmimAM kasmaicid akathayitvA yAjakasya samIpaJca gatvA svaM darzaya, lokebhyo nijapariSkRtatvasya pramANadAnAya mUsAjJAnusAreNa dravyamutmRjasva ca| ");
INSERT INTO sanhk_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","tathApi yIzoH sukhyAti rbahu vyAptumArebhe kiJca tasya kathAM zrotuM svIyarogebhyo moktuJca lokA AjagmuH| ");
INSERT INTO sanhk_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","atha sa prAntaraM gatvA prArthayAJcakre| ");
INSERT INTO sanhk_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","aparaJca ekadA yIzurupadizati, etarhi gAlIlyihUdApradezayoH sarvvanagarebhyo yirUzAlamazca kiyantaH phirUzilokA vyavasthApakAzca samAgatya tadantike samupavivizuH, tasmin kAle lokAnAmArogyakAraNAt prabhoH prabhAvaH pracakAze| ");
INSERT INTO sanhk_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","pazcAt kiyanto lokA ekaM pakSAghAtinaM khaTvAyAM nidhAya yIzoH samIpamAnetuM sammukhe sthApayituJca vyApriyanta| ");
INSERT INTO sanhk_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","kintu bahujananivahasamvAdhAt na zaknuvanto gRhopari gatvA gRhapRSThaM khanitvA taM pakSAghAtinaM sakhaTvaM gRhamadhye yIzoH sammukhe 'varohayAmAsuH| ");
INSERT INTO sanhk_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","tadA yIzusteSAm IdRzaM vizvAsaM vilokya taM pakSAghAtinaM vyAjahAra, he mAnava tava pApamakSamyata| ");
INSERT INTO sanhk_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","tasmAd adhyApakAH phirUzinazca cittairitthaM pracintitavantaH, eSa jana IzvaraM nindati koyaM? kevalamIzvaraM vinA pApaM kSantuM kaH zaknoti? ");
INSERT INTO sanhk_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","tadA yIzusteSAm itthaM cintanaM viditvA tebhyokathayad yUyaM manobhiH kuto vitarkayatha? ");
INSERT INTO sanhk_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","tava pApakSamA jAtA yadvA tvamutthAya vraja etayo rmadhye kA kathA sukathyA? ");
INSERT INTO sanhk_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","kintu pRthivyAM pApaM kSantuM mAnavasutasya sAmarthyamastIti yathA yUyaM jJAtuM zaknutha tadarthaM (sa taM pakSAghAtinaM jagAda) uttiSTha svazayyAM gRhItvA gRhaM yAhIti tvAmAdizAmi| ");
INSERT INTO sanhk_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","tasmAt sa tatkSaNam utthAya sarvveSAM sAkSAt nijazayanIyaM gRhItvA IzvaraM dhanyaM vadan nijanivezanaM yayau| ");
INSERT INTO sanhk_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","tasmAt sarvve vismaya prAptA manaHsu bhItAzca vayamadyAsambhavakAryyANyadarzAma ityuktvA paramezvaraM dhanyaM proditAH| ");
INSERT INTO sanhk_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","tataH paraM bahirgacchan karasaJcayasthAne levinAmAnaM karasaJcAyakaM dRSTvA yIzustamabhidadhe mama pazcAdehi| ");
INSERT INTO sanhk_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","tasmAt sa tatkSaNAt sarvvaM parityajya tasya pazcAdiyAya| ");
INSERT INTO sanhk_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","anantaraM levi rnijagRhe tadarthaM mahAbhojyaM cakAra, tadA taiH sahAneke karasaJcAyinastadanyalokAzca bhoktumupavivizuH| ");
INSERT INTO sanhk_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","tasmAt kAraNAt caNDAlAnAM pApilokAnAJca saGge yUyaM kuto bhaMgdhve pivatha ceti kathAM kathayitvA phirUzino'dhyApakAzca tasya ziSyaiH saha vAgyuddhaM karttumArebhire| ");
INSERT INTO sanhk_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","tasmAd yIzustAn pratyavocad arogalokAnAM cikitsakena prayojanaM nAsti kintu sarogANAmeva| ");
INSERT INTO sanhk_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ahaM dhArmmikAn AhvAtuM nAgatosmi kintu manaH parAvarttayituM pApina eva| ");
INSERT INTO sanhk_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","tataste procuH, yohanaH phirUzinAJca ziSyA vAraMvAram upavasanti prArthayante ca kintu tava ziSyAH kuto bhuJjate pivanti ca? ");
INSERT INTO sanhk_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","tadA sa tAnAcakhyau vare saGge tiSThati varasya sakhigaNaM kimupavAsayituM zaknutha? ");
INSERT INTO sanhk_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","kintu yadA teSAM nikaTAd varo neSyate tadA te samupavatsyanti| ");
INSERT INTO sanhk_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","soparamapi dRSTAntaM kathayAmbabhUva purAtanavastre kopi nutanavastraM na sIvyati yatastena sevanena jIrNavastraM chidyate, nUtanapurAtanavastrayo rmelaJca na bhavati| ");
INSERT INTO sanhk_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","purAtanyAM kutvAM kopi nutanaM drAkSArasaM na nidadhAti, yato navInadrAkSArasasya tejasA purAtanI kutU rvidIryyate tato drAkSArasaH patati kutUzca nazyati| ");
INSERT INTO sanhk_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","tato heto rnUtanyAM kutvAM navInadrAkSArasaH nidhAtavyastenobhayasya rakSA bhavati| ");
INSERT INTO sanhk_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","aparaJca purAtanaM drAkSArasaM pItvA kopi nUtanaM na vAJchati, yataH sa vakti nUtanAt purAtanam prazastam| ");
INSERT INTO sanhk_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","acaraJca parvvaNo dvitIyadinAt paraM prathamavizrAmavAre zasyakSetreNa yIzorgamanakAle tasya ziSyAH kaNizaM chittvA kareSu marddayitvA khAditumArebhire| ");
INSERT INTO sanhk_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","tasmAt kiyantaH phirUzinastAnavadan vizrAmavAre yat karmma na karttavyaM tat kutaH kurutha? ");
INSERT INTO sanhk_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","yIzuH pratyuvAca dAyUd tasya saGginazca kSudhArttAH kiM cakruH sa katham Izvarasya mandiraM pravizya ");
INSERT INTO sanhk_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ye darzanIyAH pUpA yAjakAn vinAnyasya kasyApyabhojanIyAstAnAnIya svayaM bubhaje saGgibhyopi dadau tat kiM yuSmAbhiH kadApi nApAThi? ");
INSERT INTO sanhk_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","pazcAt sa tAnavadat manujasuto vizrAmavArasyApi prabhu rbhavati| ");
INSERT INTO sanhk_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","anantaram anyavizrAmavAre sa bhajanagehaM pravizya samupadizati| tadA tatsthAne zuSkadakSiNakara ekaH pumAn upatasthivAn| ");
INSERT INTO sanhk_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","tasmAd adhyApakAH phirUzinazca tasmin doSamAropayituM sa vizrAmavAre tasya svAsthyaM karoti naveti pratIkSitumArebhire| ");
INSERT INTO sanhk_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","tadA yIzusteSAM cintAM viditvA taM zuSkakaraM pumAMsaM provAca, tvamutthAya madhyasthAne tiSTha| ");
INSERT INTO sanhk_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","tasmAt tasmin utthitavati yIzustAn vyAjahAra, yuSmAn imAM kathAM pRcchAmi, vizrAmavAre hitam ahitaM vA, prANarakSaNaM prANanAzanaM vA, eteSAM kiM karmmakaraNIyam? ");
INSERT INTO sanhk_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","pazcAt caturdikSu sarvvAn vilokya taM mAnavaM babhASe, nijakaraM prasAraya; tatastena tathA kRta itarakaravat tasya hastaH svasthobhavat| ");
INSERT INTO sanhk_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","tasmAt te pracaNDakopAnvitA yIzuM kiM kariSyantIti parasparaM pramantritAH| ");
INSERT INTO sanhk_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","tataH paraM sa parvvatamAruhyezvaramuddizya prArthayamAnaH kRtsnAM rAtriM yApitavAn| ");
INSERT INTO sanhk_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","atha dine sati sa sarvvAn ziSyAn AhUtavAn teSAM madhye ");
INSERT INTO sanhk_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","pitaranAmnA khyAtaH zimon tasya bhrAtA Andriyazca yAkUb yohan ca philip barthalamayazca ");
INSERT INTO sanhk_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","mathiH thomA AlphIyasya putro yAkUb jvalantanAmnA khyAtaH zimon ");
INSERT INTO sanhk_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ca yAkUbo bhrAtA yihUdAzca taM yaH parakareSu samarpayiSyati sa ISkarIyotIyayihUdAzcaitAn dvAdaza janAn manonItAn kRtvA sa jagrAha tathA prerita iti teSAM nAma cakAra| ");
INSERT INTO sanhk_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","tataH paraM sa taiH saha parvvatAdavaruhya upatyakAyAM tasthau tatastasya ziSyasaGgho yihUdAdezAd yirUzAlamazca soraH sIdonazca jaladhe rodhaso jananihAzca etya tasya kathAzravaNArthaM rogamuktyarthaJca tasya samIpe tasthuH| ");
INSERT INTO sanhk_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","amedhyabhUtagrastAzca tannikaTamAgatya svAsthyaM prApuH| ");
INSERT INTO sanhk_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","sarvveSAM svAsthyakaraNaprabhAvasya prakAzitatvAt sarvve lokA etya taM spraSTuM yetire| ");
INSERT INTO sanhk_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","pazcAt sa ziSyAn prati dRSTiM kutvA jagAda, he daridrA yUyaM dhanyA yata IzvarIye rAjye vo'dhikArosti| ");
INSERT INTO sanhk_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","he adhunA kSudhitalokA yUyaM dhanyA yato yUyaM tarpsyatha; he iha rodino janA yUyaM dhanyA yato yUyaM hasiSyatha| ");
INSERT INTO sanhk_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","yadA lokA manuSyasUno rnAmaheto ryuSmAn RृtIyiSyante pRthak kRtvA nindiSyanti, adhamAniva yuSmAn svasamIpAd dUrIkariSyanti ca tadA yUyaM dhanyAH| ");
INSERT INTO sanhk_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","svarge yuSmAkaM yatheSTaM phalaM bhaviSyati, etadarthaM tasmin dine prollasata Anandena nRtyata ca, teSAM pUrvvapuruSAzca bhaviSyadvAdinaH prati tathaiva vyavAharan| ");
INSERT INTO sanhk_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","kintu hA hA dhanavanto yUyaM sukhaM prApnuta| hanta paritRptA yUyaM kSudhitA bhaviSyatha; ");
INSERT INTO sanhk_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","iha hasanto yUyaM vata yuSmAbhiH zocitavyaM roditavyaJca| ");
INSERT INTO sanhk_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","sarvvailAkai ryuSmAkaM sukhyAtau kRtAyAM yuSmAkaM durgati rbhaviSyati yuSmAkaM pUrvvapuruSA mRSAbhaviSyadvAdinaH prati tadvat kRtavantaH| ");
INSERT INTO sanhk_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","he zrotAro yuSmabhyamahaM kathayAmi, yUyaM zatruSu prIyadhvaM ye ca yuSmAn dviSanti teSAmapi hitaM kuruta| ");
INSERT INTO sanhk_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ye ca yuSmAn zapanti tebhya AziSaM datta ye ca yuSmAn avamanyante teSAM maGgalaM prArthayadhvaM| ");
INSERT INTO sanhk_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","yadi kazcit tava kapole capeTAghAtaM karoti tarhi taM prati kapolam anyaM parAvarttya sammukhIkuru punazca yadi kazcit tava gAtrIyavastraM harati tarhi taM paridheyavastram api grahItuM mA vAraya| ");
INSERT INTO sanhk_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","yastvAM yAcate tasmai dehi, yazca tava sampattiM harati taM mA yAcasva| ");
INSERT INTO sanhk_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","parebhyaH svAn prati yathAcaraNam apekSadhve parAn prati yUyamapi tathAcarata| ");
INSERT INTO sanhk_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","ye janA yuSmAsu prIyante kevalaM teSu prIyamANeSu yuSmAkaM kiM phalaM? pApilokA api sveSu prIyamANeSu prIyante| ");
INSERT INTO sanhk_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","yadi hitakAriNa eva hitaM kurutha tarhi yuSmAkaM kiM phalaM? pApilokA api tathA kurvvanti| ");
INSERT INTO sanhk_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","yebhya RNaparizodhasya prAptipratyAzAste kevalaM teSu RNe samarpite yuSmAkaM kiM phalaM? punaH prAptyAzayA pApIlokA api pApijaneSu RNam arpayanti| ");
INSERT INTO sanhk_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","ato yUyaM ripuSvapi prIyadhvaM, parahitaM kuruta ca; punaH prAptyAzAM tyaktvA RNamarpayata, tathA kRte yuSmAkaM mahAphalaM bhaviSyati, yUyaJca sarvvapradhAnasya santAnA iti khyAtiM prApsyatha, yato yuSmAkaM pitA kRtaghnAnAM durvTattAnAJca hitamAcarati| ");
INSERT INTO sanhk_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ata eva sa yathA dayAlu ryUyamapi tAdRzA dayAlavo bhavata| ");
INSERT INTO sanhk_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","aparaJca parAn doSiNo mA kuruta tasmAd yUyaM doSIkRtA na bhaviSyatha; adaNDyAn mA daNDayata tasmAd yUyamapi daNDaM na prApsyatha; pareSAM doSAn kSamadhvaM tasmAd yuSmAkamapi doSAH kSamiSyante| ");
INSERT INTO sanhk_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","dAnAnidatta tasmAd yUyaM dAnAni prApsyatha, varaJca lokAH parimANapAtraM pradalayya saJcAlya proJcAlya paripUryya yuSmAkaM kroDeSu samarpayiSyanti; yUyaM yena parimANena parimAtha tenaiva parimANena yuSmatkRte parimAsyate| ");
INSERT INTO sanhk_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","atha sa tebhyo dRSTAntakathAmakathayat, andho janaH kimandhaM panthAnaM darzayituM zaknoti? tasmAd ubhAvapi kiM gartte na patiSyataH? ");
INSERT INTO sanhk_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","guroH ziSyo na zreSThaH kintu ziSye siddhe sati sa gurutulyo bhavituM zaknoti| ");
INSERT INTO sanhk_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","aparaJca tvaM svacakSuुSi nAsAm adRSTvA tava bhrAtuzcakSuSi yattRNamasti tadeva kutaH pazyami? ");
INSERT INTO sanhk_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","svacakSuSi yA nAsA vidyate tAm ajJAtvA, bhrAtastava netrAt tRNaM bahiH karomIti vAkyaM bhrAtaraM kathaM vaktuM zaknoSi? he kapaTin pUrvvaM svanayanAt nAsAM bahiH kuru tato bhrAtuzcakSuSastRNaM bahiH karttuM sudRSTiM prApsyasi| ");
INSERT INTO sanhk_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","anyaJca uttamastaruH kadApi phalamanuttamaM na phalati, anuttamataruzca phalamuttamaM na phalati kAraNAdataH phalaistaravo jJAyante| ");
INSERT INTO sanhk_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","kaNTakipAdapAt kopi uDumbaraphalAni na pAtayati tathA zRgAlakolivRkSAdapi kopi drAkSAphalaM na pAtayati| ");
INSERT INTO sanhk_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","tadvat sAdhuloko'ntaHkaraNarUpAt subhANDAgArAd uttamAni dravyANi bahiH karoti, duSTo lokazcAntaHkaraNarUpAt kubhANDAgArAt kutsitAni dravyANi nirgamayati yato'ntaHkaraNAnAM pUrNabhAvAnurUpANi vacAMsi mukhAnnirgacchanti| ");
INSERT INTO sanhk_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","aparaJca mamAjJAnurUpaM nAcaritvA kuto mAM prabho prabho iti vadatha? ");
INSERT INTO sanhk_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","yaH kazcin mama nikaTam Agatya mama kathA nizamya tadanurUpaM karmma karoti sa kasya sadRzo bhavati tadahaM yuSmAn jJAाpayAmi| ");
INSERT INTO sanhk_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","yo jano gabhIraM khanitvA pASANasthale bhittiM nirmmAya svagRhaM racayati tena saha tasyopamA bhavati; yata AplAvijalametya tasya mUle vegena vahadapi tadgehaM lADayituM na zaknoti yatastasya bhittiH pASANopari tiSThati| ");
INSERT INTO sanhk_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","kintu yaH kazcin mama kathAH zrutvA tadanurUpaM nAcarati sa bhittiM vinA mRृdupari gRhanirmmAtrA samAno bhavati; yata AplAvijalamAgatya vegena yadA vahati tadA tadgRhaM patati tasya mahat patanaM jAyate| ");
INSERT INTO sanhk_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","tataH paraM sa lokAnAM karNagocare tAn sarvvAn upadezAn samApya yadA kapharnAhUmpuraM pravizati ");
INSERT INTO sanhk_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","tadA zatasenApateH priyadAsa eko mRtakalpaH pIDita AsIt| ");
INSERT INTO sanhk_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ataH senApati ryIzo rvArttAM nizamya dAsasyArogyakaraNAya tasyAgamanArthaM vinayakaraNAya yihUdIyAn kiyataH prAcaH preSayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","te yIzorantikaM gatvA vinayAtizayaM vaktumArebhire, sa senApati rbhavatonugrahaM prAptum arhati| ");
INSERT INTO sanhk_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","yataH sosmajjAtIyeSu lokeSu prIyate tathAsmatkRte bhajanagehaM nirmmitavAn| ");
INSERT INTO sanhk_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","tasmAd yIzustaiH saha gatvA nivezanasya samIpaM prApa, tadA sa zatasenApati rvakSyamANavAkyaM taM vaktuM bandhUn prAhiNot| he prabho svayaM zramo na karttavyo yad bhavatA madgehamadhye pAdArpaNaM kriyeta tadapyahaM nArhAmi, ");
INSERT INTO sanhk_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","kiJcAhaM bhavatsamIpaM yAtumapi nAtmAnaM yogyaM buddhavAn, tato bhavAn vAkyamAtraM vadatu tenaiva mama dAsaH svastho bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","yasmAd ahaM parAdhInopi mamAdhInA yAH senAH santi tAsAm ekajanaM prati yAhIti mayA prokte sa yAti; tadanyaM prati AyAhIti prokte sa AyAti; tathA nijadAsaM prati etat kurvviti prokte sa tadeva karoti| ");
INSERT INTO sanhk_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","yIzuridaM vAkyaM zrutvA vismayaM yayau, mukhaM parAvartya pazcAdvarttino lokAn babhASe ca, yuSmAnahaM vadAmi isrAyelo vaMzamadhyepi vizvAsamIdRzaM na prApnavaM| ");
INSERT INTO sanhk_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","tataste preSitA gRhaM gatvA taM pIDitaM dAsaM svasthaM dadRzuH| ");
INSERT INTO sanhk_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","pare'hani sa nAyInAkhyaM nagaraM jagAma tasyAneke ziSyA anye ca lokAstena sArddhaM yayuH| ");
INSERT INTO sanhk_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","teSu tannagarasya dvArasannidhiM prApteSu kiyanto lokA ekaM mRtamanujaM vahanto nagarasya bahiryAnti, sa tanmAturekaputrastanmAtA ca vidhavA; tayA sArddhaM tannagarIyA bahavo lokA Asan| ");
INSERT INTO sanhk_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","prabhustAM vilokya sAnukampaH kathayAmAsa, mA rodIH| sa samIpamitvA khaTvAM pasparza tasmAd vAhakAH sthagitAstamyuH; ");
INSERT INTO sanhk_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","tadA sa uvAca he yuvamanuSya tvamuttiSTha, tvAmaham AjJApayAmi| ");
INSERT INTO sanhk_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","tasmAt sa mRto janastatkSaNamutthAya kathAM prakathitaH; tato yIzustasya mAtari taM samarpayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","tasmAt sarvve lokAH zazaGkire; eko mahAbhaviSyadvAdI madhye'smAkam samudait, Izvarazca svalokAnanvagRhlAt kathAmimAM kathayitvA IzvaraM dhanyaM jagaduH| ");
INSERT INTO sanhk_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","tataH paraM samastaM yihUdAdezaM tasya caturdiksthadezaJca tasyaitatkIrtti rvyAnaze| ");
INSERT INTO sanhk_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","tataH paraM yohanaH ziSyeSu taM tadvRttAntaM jJApitavatsu ");
INSERT INTO sanhk_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","sa svaziSyANAM dvau janAvAhUya yIzuM prati vakSyamANaM vAkyaM vaktuM preSayAmAsa, yasyAgamanam apekSya tiSThAmo vayaM kiM sa eva janastvaM? kiM vayamanyamapekSya sthAsyAmaH? ");
INSERT INTO sanhk_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","pazcAttau mAnavau gatvA kathayAmAsatuH, yasyAgamanam apekSya tiSThAmo vayaM, kiM saeva janastvaM? kiM vayamanyamapekSya sthAsyAmaH? kathAmimAM tubhyaM kathayituM yohan majjaka AvAM preSitavAn| ");
INSERT INTO sanhk_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","tasmin daNDe yIzUrogiNo mahAvyAdhimato duSTabhUtagrastAMzca bahUn svasthAn kRtvA, anekAndhebhyazcakSuMSi dattvA pratyuvAca, ");
INSERT INTO sanhk_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","yuvAM vrajatam andhA netrANi khaJjAzcaraNAni ca prApnuvanti, kuSThinaH pariSkriyante, badhirAH zravaNAni mRtAzca jIvanAni prApnuvanti, daridrANAM samIpeSu susaMvAdaH pracAryyate, yaM prati vighnasvarUpohaM na bhavAmi sa dhanyaH, ");
INSERT INTO sanhk_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","etAni yAni pazyathaH zRNuthazca tAni yohanaM jJApayatam| ");
INSERT INTO sanhk_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","tayo rdUtayo rgatayoH sato ryohani sa lokAn vaktumupacakrame, yUyaM madhyeprAntaraM kiM draSTuM niragamata? kiM vAyunA kampitaM naDaM? ");
INSERT INTO sanhk_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","yUyaM kiM draSTuM niragamata? kiM sUkSmavastraparidhAyinaM kamapi naraM? kintu ye sUkSmamRduvastrANi paridadhati sUttamAni dravyANi bhuJjate ca te rAjadhAnISu tiSThanti| ");
INSERT INTO sanhk_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","tarhi yUyaM kiM draSTuM niragamata? kimekaM bhaviSyadvAdinaM? tadeva satyaM kintu sa pumAn bhaviSyadvAdinopi zreSTha ityahaM yuSmAn vadAmi; ");
INSERT INTO sanhk_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","pazya svakIyadUtantu tavAgra preSayAmyahaM| gatvA tvadIyamArgantu sa hi pariSkariSyati| yadarthe lipiriyam Aste sa eva yohan| ");
INSERT INTO sanhk_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","ato yuSmAnahaM vadAmi striyA garbbhajAtAnAM bhaviSyadvAdinAM madhye yohano majjakAt zreSThaH kopi nAsti, tatrApi Izvarasya rAjye yaH sarvvasmAt kSudraH sa yohanopi zreSThaH| ");
INSERT INTO sanhk_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","aparaJca sarvve lokAH karamaJcAyinazca tasya vAkyAni zrutvA yohanA majjanena majjitAH paramezvaraM nirdoSaM menire| ");
INSERT INTO sanhk_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","kintu phirUzino vyavasthApakAzca tena na majjitAH svAn pratIzvarasyopadezaM niSphalam akurvvan| ");
INSERT INTO sanhk_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","atha prabhuH kathayAmAsa, idAnIntanajanAn kenopamAmi? te kasya sadRzAH? ");
INSERT INTO sanhk_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ye bAlakA vipaNyAm upavizya parasparam AhUya vAkyamidaM vadanti, vayaM yuSmAkaM nikaTe vaMzIravAdiSma, kintu yUyaM nAnarttiSTa, vayaM yuSmAkaM nikaTa arodiSma, kintu yuyaM na vyalapiSTa, bAlakairetAdRzaisteSAm upamA bhavati| ");
INSERT INTO sanhk_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","yato yohan majjaka Agatya pUpaM nAkhAdat drAkSArasaJca nApivat tasmAd yUyaM vadatha, bhUtagrastoyam| ");
INSERT INTO sanhk_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","tataH paraM mAnavasuta AgatyAkhAdadapivaJca tasmAd yUyaM vadatha, khAdakaH surApazcANDAlapApinAM bandhureko jano dRzyatAm| ");
INSERT INTO sanhk_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","kintu jJAnino jJAnaM nirdoSaM viduH| ");
INSERT INTO sanhk_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","pazcAdekaH phirUzI yIzuM bhojanAya nyamantrayat tataH sa tasya gRhaM gatvA bhoktumupaviSTaH| ");
INSERT INTO sanhk_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","etarhi tatphirUzino gRhe yIzu rbhektum upAvekSIt tacchrutvA tannagaravAsinI kApi duSTA nArI pANDaraprastarasya sampuTake sugandhitailam AnIya ");
INSERT INTO sanhk_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","tasya pazcAt pAdayoH sannidhau tasyau rudatI ca netrAmbubhistasya caraNau prakSAlya nijakacairamArkSIt, tatastasya caraNau cumbitvA tena sugandhitailena mamarda| ");
INSERT INTO sanhk_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","tasmAt sa nimantrayitA phirUzI manasA cintayAmAsa, yadyayaM bhaviSyadvAdI bhavet tarhi enaM spRzati yA strI sA kA kIdRzI ceti jJAtuM zaknuyAt yataH sA duSTA| ");
INSERT INTO sanhk_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","tadA yAzustaM jagAda, he zimon tvAM prati mama kiJcid vaktavyamasti; tasmAt sa babhASe, he guro tad vadatu| ");
INSERT INTO sanhk_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ekottamarNasya dvAvadhamarNAvAstAM, tayorekaH paJcazatAni mudrApAdAn aparazca paJcAzat mudrApAdAn dhArayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","tadanantaraM tayoH zodhyAbhAvAt sa uttamarNastayo rRNe cakSame; tasmAt tayordvayoH kastasmin preSyate bahu? tad brUhi| ");
INSERT INTO sanhk_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","zimon pratyuvAca, mayA budhyate yasyAdhikam RNaM cakSame sa iti; tato yIzustaM vyAjahAra, tvaM yathArthaM vyacArayaH| ");
INSERT INTO sanhk_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","atha tAM nArIM prati vyAghuThya zimonamavocat, strImimAM pazyasi? tava gRhe mayyAgate tvaM pAdaprakSAlanArthaM jalaM nAdAH kintu yoSideSA nayanajalai rmama pAdau prakSAlya kezairamArkSIt| ");
INSERT INTO sanhk_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","tvaM mAM nAcumbIH kintu yoSideSA svIyAgamanAdArabhya madIyapAdau cumbituM na vyaraMsta| ");
INSERT INTO sanhk_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","tvaJca madIyottamAGge kiJcidapi tailaM nAmardIH kintu yoSideSA mama caraNau sugandhitailenAmarddIt| ");
INSERT INTO sanhk_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","atastvAM vyAharAmi, etasyA bahu pApamakSamyata tato bahu prIyate kintu yasyAlpapApaM kSamyate solpaM prIyate| ");
INSERT INTO sanhk_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","tataH paraM sa tAM babhASe, tvadIyaM pApamakSamyata| ");
INSERT INTO sanhk_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","tadA tena sArddhaM ye bhoktum upavivizuste parasparaM vaktumArebhire, ayaM pApaM kSamate ka eSaH? ");
INSERT INTO sanhk_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","kintu sa tAM nArIM jagAda, tava vizvAsastvAM paryyatrAsta tvaM kSemeNa vraja| ");
INSERT INTO sanhk_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","aparaJca yIzu rdvAdazabhiH ziSyaiH sArddhaM nAnAnagareSu nAnAgrAmeSu ca gacchan izvarIyarAjatvasya susaMvAdaM pracArayituM prArebhe| ");
INSERT INTO sanhk_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","tadA yasyAH sapta bhUtA niragacchan sA magdalInIti vikhyAtA mariyam herodrAjasya gRhAdhipateH hoSe rbhAryyA yohanA zUzAnA ");
INSERT INTO sanhk_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","prabhRtayo yA bahvyaH striyaH duSTabhUtebhyo rogebhyazca muktAH satyo nijavibhUtI rvyayitvA tamasevanta, tAH sarvvAstena sArddham Asan| ");
INSERT INTO sanhk_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","anantaraM nAnAnagarebhyo bahavo lokA Agatya tasya samIpe'milan, tadA sa tebhya ekAM dRSTAntakathAM kathayAmAsa| ekaH kRSIbalo bIjAni vaptuM bahirjagAma, ");
INSERT INTO sanhk_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","tato vapanakAle katipayAni bIjAni mArgapArzve petuH, tatastAni padatalai rdalitAni pakSibhi rbhakSitAni ca| ");
INSERT INTO sanhk_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","katipayAni bIjAni pASANasthale patitAni yadyapi tAnyaGkuritAni tathApi rasAbhAvAt zuzuSuH| ");
INSERT INTO sanhk_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","katipayAni bIjAni kaNTakivanamadhye patitAni tataH kaNTakivanAni saMvRddhya tAni jagrasuH| ");
INSERT INTO sanhk_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","tadanyAni katipayabIjAni ca bhUmyAmuttamAyAM petustatastAnyaGkurayitvA zataguNAni phalAni pheluH| sa imA kathAM kathayitvA proccaiH provAca, yasya zrotuM zrotre staH sa zRNotu| ");
INSERT INTO sanhk_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","tataH paraM ziSyAstaM papracchurasya dRSTAntasya kiM tAtparyyaM? ");
INSERT INTO sanhk_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","tataH sa vyAjahAra, IzvarIyarAjyasya guhyAni jJAtuM yuSmabhyamadhikAro dIyate kintvanye yathA dRSTvApi na pazyanti zrutvApi ma budhyante ca tadarthaM teSAM purastAt tAH sarvvAH kathA dRSTAntena kathyante| ");
INSERT INTO sanhk_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","dRSTAntasyAsyAbhiprAyaH, IzvarIyakathA bIjasvarUpA| ");
INSERT INTO sanhk_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ye kathAmAtraM zRNvanti kintu pazcAd vizvasya yathA paritrANaM na prApnuvanti tadAzayena zaitAnetya hRdayAtR tAM kathAm apaharati ta eva mArgapArzvasthabhUmisvarUpAH| ");
INSERT INTO sanhk_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ye kathaM zrutvA sAnandaM gRhlanti kintvabaddhamUlatvAt svalpakAlamAtraM pratItya parIkSAkAle bhrazyanti taeva pASANabhUmisvarUpAH| ");
INSERT INTO sanhk_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ye kathAM zrutvA yAnti viSayacintAyAM dhanalobhena eेhikasukhe ca majjanta upayuktaphalAni na phalanti ta evoptabIjakaNTakibhUsvarUpAH| ");
INSERT INTO sanhk_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","kintu ye zrutvA saralaiH zuddhaizcAntaHkaraNaiH kathAM gRhlanti dhairyyam avalambya phalAnyutpAdayanti ca ta evottamamRtsvarUpAH| ");
INSERT INTO sanhk_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","aparaJca pradIpaM prajvAlya kopi pAtreNa nAcchAdayati tathA khaTvAdhopi na sthApayati, kintu dIpAdhAroparyyeva sthApayati, tasmAt pravezakA dIptiM pazyanti| ");
INSERT INTO sanhk_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","yanna prakAzayiSyate tAdRg aprakAzitaM vastu kimapi nAsti yacca na suvyaktaM pracArayiSyate tAdRg gRptaM vastu kimapi nAsti| ");
INSERT INTO sanhk_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","ato yUyaM kena prakAreNa zRNutha tatra sAvadhAnA bhavata, yasya samIpe barddhate tasmai punardAsyate kintu yasyAzraye na barddhate tasya yadyadasti tadapi tasmAt neSyate| ");
INSERT INTO sanhk_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","aparaJca yIzo rmAtA bhrAtarazca tasya samIpaM jigamiSavaH ");
INSERT INTO sanhk_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","kintu janatAsambAdhAt tatsannidhiM prAptuM na zekuH| tatpazcAt tava mAtA bhrAtarazca tvAM sAkSAt cikIrSanto bahistiSThanatIti vArttAyAM tasmai kathitAyAM ");
INSERT INTO sanhk_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","sa pratyuvAca; ye janA Izvarasya kathAM zrutvA tadanurUpamAcaranti taeva mama mAtA bhrAtarazca| ");
INSERT INTO sanhk_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","anantaraM ekadA yIzuH ziSyaiH sArddhaM nAvamAruhya jagAda, AyAta vayaM hradasya pAraM yAmaH, tataste jagmuH| ");
INSERT INTO sanhk_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","teSu naukAM vAhayatsu sa nidadrau; ");
INSERT INTO sanhk_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","athAkasmAt prabalajhaJbhzagamAd hrade naukAyAM taraGgairAcchannAyAM vipat tAn jagrAsa|tasmAd yIzorantikaM gatvA he guro he guro prANA no yAntIti gaditvA taM jAgarayAmbabhUvuH|tadA sa utthAya vAyuM taraGgAMzca tarjayAmAsa tasmAdubhau nivRtya sthirau babhUvatuH| ");
INSERT INTO sanhk_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","sa tAn babhASe yuSmAkaM vizvAsaH ka? tasmAtte bhItA vismitAzca parasparaM jagaduH, aho kIdRgayaM manujaH pavanaM pAnIyaJcAdizati tadubhayaM tadAdezaM vahati| ");
INSERT INTO sanhk_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","tataH paraM gAlIlpradezasya sammukhasthagiderIyapradeze naukAyAM lagantyAM taTe'varohamAvAd ");
INSERT INTO sanhk_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","bahutithakAlaM bhUtagrasta eko mAnuSaH purAdAgatya taM sAkSAccakAra| sa manuSo vAso na paridadhat gRhe ca na vasan kevalaM zmazAnam adhyuvAsa| ");
INSERT INTO sanhk_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","sa yIzuM dRSTvaiva cIcchabdaM cakAra tasya sammukhe patitvA proccairjagAda ca, he sarvvapradhAnezvarasya putra, mayA saha tava kaH sambandhaH? tvayi vinayaM karomi mAM mA yAtaya| ");
INSERT INTO sanhk_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","yataH sa taM mAnuSaM tyaktvA yAtum amedhyabhUtam Adideza; sa bhUtastaM mAnuSam asakRd dadhAra tasmAllokAH zRGkhalena nigaDena ca babandhuH; sa tad bhaMktvA bhUtavazatvAt madhyeprAntaraM yayau| ");
INSERT INTO sanhk_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","anantaraM yIzustaM papraccha tava kinnAma? sa uvAca, mama nAma bAhino yato bahavo bhUtAstamAzizriyuH| ");
INSERT INTO sanhk_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","atha bhUtA vinayena jagaduH, gabhIraM garttaM gantuM mAjJApayAsmAn| ");
INSERT INTO sanhk_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","tadA parvvatopari varAhavrajazcarati tasmAd bhUtA vinayena procuH, amuM varAhavrajam Azrayitum asmAn anujAnIhi; tataH sonujajJau| ");
INSERT INTO sanhk_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","tataH paraM bhUtAstaM mAnuSaM vihAya varAhavrajam AzizriyuH varAhavrajAzca tatkSaNAt kaTakena dhAvanto hrade prANAn vijRhuH| ");
INSERT INTO sanhk_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","tad dRSTvA zUkararakSakAH palAyamAnA nagaraM grAmaJca gatvA tatsarvvavRttAntaM kathayAmAsuH| ");
INSERT INTO sanhk_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","tataH kiM vRttam etaddarzanArthaM lokA nirgatya yIzoH samIpaM yayuH, taM mAnuSaM tyaktabhUtaM parihitavastraM svasthamAnuSavad yIzozcaraNasannidhau sUpavizantaM vilokya bibhyuH| ");
INSERT INTO sanhk_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ye lokAstasya bhUtagrastasya svAsthyakaraNaM dadRzuste tebhyaH sarvvavRttAntaM kathayAmAsuH| ");
INSERT INTO sanhk_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","tadanantaraM tasya giderIyapradezasya caturdiksthA bahavo janA atitrastA vinayena taM jagaduH, bhavAn asmAkaM nikaTAd vrajatu tasmAt sa nAvamAruhya tato vyAghuTya jagAma| ");
INSERT INTO sanhk_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","tadAnIM tyaktabhUtamanujastena saha sthAtuM prArthayAJcakre ");
INSERT INTO sanhk_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","kintu tadartham IzvaraH kIdRGmahAkarmma kRtavAn iti nivezanaM gatvA vijJApaya, yIzuH kathAmetAM kathayitvA taM visasarja| tataH sa vrajitvA yIzustadarthaM yanmahAkarmma cakAra tat purasya sarvvatra prakAzayituM prArebhe| ");
INSERT INTO sanhk_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","atha yIzau parAvRtyAgate lokAstaM AdareNa jagRhu ryasmAtte sarvve tamapekSAJcakrire| ");
INSERT INTO sanhk_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","tadanantaraM yAyIrnAmno bhajanagehasyaikodhipa Agatya yIzozcaraNayoH patitvA svanivezanAgamanArthaM tasmin vinayaM cakAra, ");
INSERT INTO sanhk_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","yatastasya dvAdazavarSavayaskA kanyaikAsIt sA mRtakalpAbhavat| tatastasya gamanakAle mArge lokAnAM mahAn samAgamo babhUva| ");
INSERT INTO sanhk_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","dvAdazavarSANi pradararogagrastA nAnA vaidyaizcikitsitA sarvvasvaM vyayitvApi svAsthyaM na prAptA yA yoSit sA yIzoH pazcAdAgatya tasya vastragranthiM pasparza| ");
INSERT INTO sanhk_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","tasmAt tatkSaNAt tasyA raktasrAvo ruddhaH| ");
INSERT INTO sanhk_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","tadAnIM yIzuravadat kenAhaM spRSTaH? tato'nekairanaGgIkRte pitarastasya saGginazcAvadan, he guro lokA nikaTasthAH santastava dehe gharSayanti, tathApi kenAhaM spRSTa_iti bhavAn kutaH pRcchati? ");
INSERT INTO sanhk_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","yIzuH kathayAmAsa, kenApyahaM spRSTo, yato mattaH zakti rnirgateti mayA nizcitamajJAyi| ");
INSERT INTO sanhk_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","tadA sA nArI svayaM na gupteti viditvA kampamAnA satI tasya sammukhe papAta; yena nimittena taM pasparza sparzamAtrAcca yena prakAreNa svasthAbhavat tat sarvvaM tasya sAkSAdAcakhyau| ");
INSERT INTO sanhk_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","tataH sa tAM jagAda he kanye susthirA bhava, tava vizvAsastvAM svasthAm akArSIt tvaM kSemeNa yAhi| ");
INSERT INTO sanhk_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","yIzoretadvAkyavadanakAle tasyAdhipate rnivezanAt kazcilloka Agatya taM babhASe, tava kanyA mRtA guruM mA klizAna| ");
INSERT INTO sanhk_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","kintu yIzustadAkarNyAdhipatiM vyAjahAra, mA bhaiSIH kevalaM vizvasihi tasmAt sA jIviSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","atha tasya nivezane prApte sa pitaraM yohanaM yAkUbaJca kanyAyA mAtaraM pitaraJca vinA, anyaM kaJcana praveSTuM vArayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","aparaJca ye rudanti vilapanti ca tAn sarvvAn janAn uvAca, yUyaM mA rodiSTa kanyA na mRtA nidrAti| ");
INSERT INTO sanhk_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","kintu sA nizcitaM mRteti jJAtvA te tamupajahasuH| ");
INSERT INTO sanhk_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","pazcAt sa sarvvAn bahiH kRtvA kanyAyAH karau dhRtvAjuhuve, he kanye tvamuttiSTha, ");
INSERT INTO sanhk_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","tasmAt tasyAH prANeSu punarAgateSu sA tatkSaNAd uttasyau| tadAnIM tasyai kiJcid bhakSyaM dAtum Adideza| ");
INSERT INTO sanhk_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","tatastasyAH pitarau vismayaM gatau kintu sa tAvAdideza ghaTanAyA etasyAH kathAM kasmaicidapi mA kathayataM| ");
INSERT INTO sanhk_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","tataH paraM sa dvAdazaziSyAnAhUya bhUtAn tyAjayituM rogAn pratikarttuJca tebhyaH zaktimAdhipatyaJca dadau| ");
INSERT INTO sanhk_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","aparaJca IzvarIyarAjyasya susaMvAdaM prakAzayitum rogiNAmArogyaM karttuJca preraNakAle tAn jagAda| ");
INSERT INTO sanhk_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","yAtrArthaM yaSTi rvastrapuTakaM bhakSyaM mudrA dvitIyavastram, eSAM kimapi mA gRhlIta| ");
INSERT INTO sanhk_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","yUyaJca yannivezanaM pravizatha nagaratyAgaparyyanataM tannivezane tiSThata| ");
INSERT INTO sanhk_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","tatra yadi kasyacit purasya lokA yuSmAkamAtithyaM na kurvvanti tarhi tasmAnnagarAd gamanakAle teSAM viruddhaM sAkSyArthaM yuSmAkaM padadhUlIH sampAtayata| ");
INSERT INTO sanhk_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","atha te prasthAya sarvvatra susaMvAdaM pracArayituM pIDitAn svasthAn karttuJca grAmeSu bhramituM prArebhire| ");
INSERT INTO sanhk_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","etarhi herod rAjA yIzoH sarvvakarmmaNAM vArttAM zrutvA bhRzamudvivije ");
INSERT INTO sanhk_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","yataH kecidUcuryohan zmazAnAdudatiSThat| kecidUcuH, eliyo darzanaM dattavAn; evamanyalokA UcuH pUrvvIyaH kazcid bhaviSyadvAdI samutthitaH| ");
INSERT INTO sanhk_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","kintu heroduvAca yohanaH ziro'hamachinadam idAnIM yasyedRkkarmmaNAM vArttAM prApnomi sa kaH? atha sa taM draSTum aicchat| ");
INSERT INTO sanhk_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","anantaraM preritAH pratyAgatya yAni yAni karmmANi cakrustAni yIzave kathayAmAsuH tataH sa tAn baitsaidAnAmakanagarasya vijanaM sthAnaM nItvA guptaM jagAma| ");
INSERT INTO sanhk_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","pazcAl lokAstad viditvA tasya pazcAd yayuH; tataH sa tAn nayan IzvarIyarAjyasya prasaGgamuktavAn, yeSAM cikitsayA prayojanam AsIt tAn svasthAn cakAra ca| ");
INSERT INTO sanhk_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","aparaJca divAvasanne sati dvAdazaziSyA yIzorantikam etya kathayAmAsuH, vayamatra prAntarasthAne tiSThAmaH, tato nagarANi grAmANi gatvA vAsasthAnAni prApya bhakSyadravyANi kretuM jananivahaM bhavAn visRjatu| ");
INSERT INTO sanhk_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","tadA sa uvAca, yUyameva tAn bhejayadhvaM; tataste procurasmAkaM nikaTe kevalaM paJca pUpA dvau matsyau ca vidyante, ataeva sthAnAntaram itvA nimittameteSAM bhakSyadravyeSu na krIteSu na bhavati| ");
INSERT INTO sanhk_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","tatra prAyeNa paJcasahasrANi puruSA Asan| ");
INSERT INTO sanhk_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","tadA sa ziSyAn jagAda paJcAzat paJcAzajjanaiH paMktIkRtya tAnupavezayata, tasmAt te tadanusAreNa sarvvalokAnupavezayApAsuH| ");
INSERT INTO sanhk_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","tataH sa tAn paJca pUpAn mInadvayaJca gRhItvA svargaM vilokyezvaraguNAn kIrttayAJcakre bhaGktA ca lokebhyaH pariveSaNArthaM ziSyeSu samarpayAmbabhUva| ");
INSERT INTO sanhk_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","tataH sarvve bhuktvA tRptiM gatA avaziSTAnAJca dvAdaza DallakAn saMjagRhuH| ");
INSERT INTO sanhk_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","athaikadA nirjane ziSyaiH saha prArthanAkAle tAn papraccha, lokA mAM kaM vadanti? ");
INSERT INTO sanhk_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","tataste prAcuH, tvAM yohanmajjakaM vadanti; kecit tvAm eliyaM vadanti, pUrvvakAlikaH kazcid bhaviSyadvAdI zmazAnAd udatiSThad ityapi kecid vadanti| ");
INSERT INTO sanhk_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","tadA sa uvAca, yUyaM mAM kaM vadatha? tataH pitara uktavAn tvam IzvarAbhiSiktaH puruSaH| ");
INSERT INTO sanhk_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","tadA sa tAn dRDhamAdideza, kathAmetAM kasmaicidapi mA kathayata| ");
INSERT INTO sanhk_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","sa punaruvAca, manuSyaputreNa vahuyAtanA bhoktavyAH prAcInalokaiH pradhAnayAjakairadhyApakaizca sovajJAya hantavyaH kintu tRtIyadivase zmazAnAt tenotthAtavyam| ");
INSERT INTO sanhk_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","aparaM sa sarvvAnuvAca, kazcid yadi mama pazcAd gantuM vAJchati tarhi sa svaM dAmyatu, dine dine kruzaM gRhItvA ca mama pazcAdAgacchatu| ");
INSERT INTO sanhk_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","yato yaH kazcit svaprANAn rirakSiSati sa tAn hArayiSyati, yaH kazcin madarthaM prANAn hArayiSyati sa tAn rakSiSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","kazcid yadi sarvvaM jagat prApnoti kintu svaprANAn hArayati svayaM vinazyati ca tarhi tasya ko lAbhaH? ");
INSERT INTO sanhk_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","puna ryaH kazcin mAM mama vAkyaM vA lajjAspadaM jAnAti manuSyaputro yadA svasya pituzca pavitrANAM dUtAnAJca tejobhiH pariveSTita AgamiSyati tadA sopi taM lajjAspadaM jJAsyati| ");
INSERT INTO sanhk_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","kintu yuSmAnahaM yathArthaM vadAmi, IzvarIyarAjatvaM na dRSTavA mRtyuM nAsvAdiSyante, etAdRzAH kiyanto lokA atra sthane'pi daNDAyamAnAH santi| ");
INSERT INTO sanhk_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","etadAkhyAnakathanAt paraM prAyeNASTasu dineSu gateSu sa pitaraM yohanaM yAkUbaJca gRhItvA prArthayituM parvvatamekaM samAruroha| ");
INSERT INTO sanhk_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","atha tasya prArthanakAle tasya mukhAkRtiranyarUpA jAtA, tadIyaM vastramujjvalazuklaM jAtaM| ");
INSERT INTO sanhk_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","aparaJca mUsA eliyazcobhau tejasvinau dRSTau ");
INSERT INTO sanhk_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","tau tena yirUzAlampure yo mRtyuH sAdhiSyate tadIyAM kathAM tena sArddhaM kathayitum ArebhAte| ");
INSERT INTO sanhk_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","tadA pitarAdayaH svasya saGgino nidrayAkRSTA Asan kintu jAgaritvA tasya tejastena sArddham uttiSThantau janau ca dadRzuH| ");
INSERT INTO sanhk_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","atha tayorubhayo rgamanakAle pitaro yIzuM babhASe, he guro'smAkaM sthAne'smin sthitiH zubhA, tata ekA tvadarthA, ekA mUsArthA, ekA eliyArthA, iti tisraH kuTyosmAbhi rnirmmIyantAM, imAM kathAM sa na vivicya kathayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","aparaJca tadvAkyavadanakAle payoda eka Agatya teSAmupari chAyAM cakAra, tatastanmadhye tayoH pravezAt te zazaGkire| ");
INSERT INTO sanhk_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","tadA tasmAt payodAd iyamAkAzIyA vANI nirjagAma, mamAyaM priyaH putra etasya kathAyAM mano nidhatta| ");
INSERT INTO sanhk_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","iti zabde jAte te yIzumekAkinaM dadRzuH kintu te tadAnIM tasya darzanasya vAcamekAmapi noktvA manaHsu sthApayAmAsuH| ");
INSERT INTO sanhk_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","pare'hani teSu tasmAcchailAd avarUDheSu taM sAkSAt karttuM bahavo lokA AjagmuH| ");
INSERT INTO sanhk_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","teSAM madhyAd eko jana uccairuvAca, he guro ahaM vinayaM karomi mama putraM prati kRpAdRSTiM karotu, mama sa evaikaH putraH| ");
INSERT INTO sanhk_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","bhUtena dhRtaH san saM prasabhaM cIcchabdaM karoti tanmukhAt pheNA nirgacchanti ca, bhUta itthaM vidAryya kliSTvA prAyazastaM na tyajati| ");
INSERT INTO sanhk_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","tasmAt taM bhUtaM tyAjayituM tava ziSyasamIpe nyavedayaM kintu te na zekuH| ");
INSERT INTO sanhk_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","tadA yIzuravAdIt, re AvizvAsin vipathagAmin vaMza katikAlAn yuSmAbhiH saha sthAsyAmyahaM yuSmAkam AcaraNAni ca sahiSye? tava putramihAnaya| ");
INSERT INTO sanhk_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","tatastasminnAgatamAtre bhUtastaM bhUmau pAtayitvA vidadAra; tadA yIzustamamedhyaM bhUtaM tarjayitvA bAlakaM svasthaM kRtvA tasya pitari samarpayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Izvarasya mahAzaktim imAM vilokya sarvve camaccakruH; itthaM yIzoH sarvvAbhiH kriyAbhiH sarvvairlokairAzcaryye manyamAne sati sa ziSyAn babhASe, ");
INSERT INTO sanhk_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","katheyaM yuSmAkaM karNeSu pravizatu, manuSyaputro manuSyANAM kareSu samarpayiSyate| ");
INSERT INTO sanhk_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","kintu te tAM kathAM na bubudhire, spaSTatvAbhAvAt tasyA abhiprAyasteSAM bodhagamyo na babhUva; tasyA AzayaH ka ityapi te bhayAt praSTuM na zekuH| ");
INSERT INTO sanhk_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","tadanantaraM teSAM madhye kaH zreSThaH kathAmetAM gRhItvA te mitho vivAdaM cakruH| ");
INSERT INTO sanhk_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","tato yIzusteSAM manobhiprAyaM viditvA bAlakamekaM gRhItvA svasya nikaTe sthApayitvA tAn jagAda, ");
INSERT INTO sanhk_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","yo jano mama nAmnAsya bAlAsyAtithyaM vidadhAti sa mamAtithyaM vidadhAti, yazca mamAtithyaM vidadhAti sa mama prerakasyAtithyaM vidadhAti, yuSmAkaM madhyeyaH svaM sarvvasmAt kSudraM jAnIte sa eva zreSTho bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","aparaJca yohan vyAjahAra he prabheा tava nAmnA bhUtAn tyAjayantaM mAnuSam ekaM dRSTavanto vayaM, kintvasmAkam apazcAd gAmitvAt taM nyaSedhAm| tadAnIM yIzuruvAca, ");
INSERT INTO sanhk_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","taM mA niSedhata, yato yo janosmAkaM na vipakSaH sa evAsmAkaM sapakSo bhavati| ");
INSERT INTO sanhk_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","anantaraM tasyArohaNasamaya upasthite sa sthiracetA yirUzAlamaM prati yAtrAM karttuM nizcityAgre dUtAn preSayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","tasmAt te gatvA tasya prayojanIyadravyANi saMgrahItuM zomiroNIyAnAM grAmaM pravivizuH| ");
INSERT INTO sanhk_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","kintu sa yirUzAlamaM nagaraM yAti tato heto rlokAstasyAtithyaM na cakruH| ");
INSERT INTO sanhk_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ataeva yAkUbyohanau tasya ziSyau tad dRSTvA jagadatuH, he prabho eliyo yathA cakAra tathA vayamapi kiM gagaNAd Agantum etAn bhasmIkarttuJca vahnimAjJApayAmaH? bhavAn kimicchati? ");
INSERT INTO sanhk_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","kintu sa mukhaM parAvartya tAn tarjayitvA gaditavAn yuSmAkaM manobhAvaH kaH, iti yUyaM na jAnItha| ");
INSERT INTO sanhk_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","manujasuto manujAnAM prANAn nAzayituM nAgacchat, kintu rakSitum Agacchat| pazcAd itaragrAmaM te yayuH| ");
INSERT INTO sanhk_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","tadanantaraM pathi gamanakAle jana ekastaM babhASe, he prabho bhavAn yatra yAti bhavatA sahAhamapi tatra yAsyAmi| ");
INSERT INTO sanhk_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","tadAnIM yIzustamuvAca, gomAyUnAM garttA Asate, vihAyasIyavihagAाnAM nIDAni ca santi, kintu mAnavatanayasya ziraH sthApayituM sthAnaM nAsti| ");
INSERT INTO sanhk_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","tataH paraM sa itarajanaM jagAda, tvaM mama pazcAd ehi; tataH sa uvAca, he prabho pUrvvaM pitaraM zmazAne sthApayituM mAmAdizatu| ");
INSERT INTO sanhk_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","tadA yIzuruvAca, mRtA mRtAn zmazAne sthApayantu kintu tvaM gatvezvarIyarAjyasya kathAM pracAraya| ");
INSERT INTO sanhk_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","tatonyaH kathayAmAsa, he prabho mayApi bhavataH pazcAd gaMsyate, kintu pUrvvaM mama nivezanasya parijanAnAm anumatiM grahItum ahamAdizyai bhavatA| ");
INSERT INTO sanhk_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","tadAnIM yIzustaM proktavAn, yo jano lAGgale karamarpayitvA pazcAt pazyati sa IzvarIyarAjyaM nArhati| ");
INSERT INTO sanhk_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","tataH paraM prabhuraparAn saptatiziSyAn niyujya svayaM yAni nagarANi yAni sthAnAni ca gamiSyati tAni nagarANi tAni sthAnAni ca prati dvau dvau janau prahitavAn| ");
INSERT INTO sanhk_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","tebhyaH kathayAmAsa ca zasyAni bahUnIti satyaM kintu chedakA alpe; tasmAddhetoH zasyakSetre chedakAn aparAnapi preSayituM kSetrasvAminaM prArthayadhvaM| ");
INSERT INTO sanhk_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","yUyaM yAta, pazyata, vRkANAM madhye meSazAvakAniva yuSmAn prahiNomi| ");
INSERT INTO sanhk_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","yUyaM kSudraM mahad vA vasanasampuTakaM pAdukAzca mA gRhlIta, mArgamadhye kamapi mA namata ca| ");
INSERT INTO sanhk_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","aparaJca yUyaM yad yat nivezanaM pravizatha tatra nivezanasyAsya maGgalaM bhUyAditi vAkyaM prathamaM vadata| ");
INSERT INTO sanhk_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","tasmAt tasmin nivezane yadi maGgalapAtraM sthAsyati tarhi tanmaGgalaM tasya bhaviSyati, nocet yuSmAn prati parAvarttiSyate| ");
INSERT INTO sanhk_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","aparaJca te yatkiJcid dAsyanti tadeva bhuktvA pItvA tasminnivezane sthAsyatha; yataH karmmakArI jano bhRtim arhati; gRhAd gRhaM mA yAsyatha| ");
INSERT INTO sanhk_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","anyacca yuSmAsu kimapi nagaraM praviSTeSu lokA yadi yuSmAkam AtithyaM kariSyanti, tarhi yat khAdyam upasthAsyanti tadeva khAdiSyatha| ");
INSERT INTO sanhk_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","tannagarasthAn rogiNaH svasthAn kariSyatha, IzvarIyaM rAjyaM yuSmAkam antikam Agamat kathAmetAJca pracArayiSyatha| ");
INSERT INTO sanhk_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","kintu kimapi puraM yuSmAsu praviSTeSu lokA yadi yuSmAkam AtithyaM na kariSyanti, tarhi tasya nagarasya panthAnaM gatvA kathAmetAM vadiSyatha, ");
INSERT INTO sanhk_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","yuSmAkaM nagarIyA yA dhUlyo'smAsu samalagan tA api yuSmAkaM prAtikUlyena sAkSyArthaM sampAtayAmaH; tathApIzvararAjyaM yuSmAkaM samIpam Agatam iti nizcitaM jAnIta| ");
INSERT INTO sanhk_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","ahaM yuSmabhyaM yathArthaM kathayAmi, vicAradine tasya nagarasya dazAtaH sidomo dazA sahyA bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","hA hA korAsIn nagara, hA hA baitsaidAnagara yuvayormadhye yAdRzAni AzcaryyANi karmmANyakriyanta, tAni karmmANi yadi sorasIdono rnagarayorakAriSyanta, tadA ito bahudinapUrvvaM tannivAsinaH zaNavastrANi paridhAya gAtreSu bhasma vilipya samupavizya samakhetsyanta| ");
INSERT INTO sanhk_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","ato vicAradivase yuSmAkaM dazAtaH sorasIdonnivAsinAM dazA sahyA bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","he kapharnAhUm, tvaM svargaM yAvad unnatA kintu narakaM yAvat nyagbhaviSyasi| ");
INSERT INTO sanhk_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","yo jano yuSmAkaM vAkyaM gRhlAti sa mamaiva vAkyaM gRhlAti; kiJca yo jano yuSmAkam avajJAM karoti sa mamaivAvajJAM karoti; yo jano mamAvajJAM karoti ca sa matprerakasyaivAvajJAM karoti| ");
INSERT INTO sanhk_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","atha te saptatiziSyA Anandena pratyAgatya kathayAmAsuH, he prabho bhavato nAmnA bhUtA apyasmAkaM vazIbhavanti| ");
INSERT INTO sanhk_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","tadAnIM sa tAn jagAda, vidyutamiva svargAt patantaM zaitAnam adarzam| ");
INSERT INTO sanhk_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","pazyata sarpAn vRzcikAn ripoH sarvvaparAkramAMzca padatalai rdalayituM yuSmabhyaM zaktiM dadAmi tasmAd yuSmAkaM kApi hAni rna bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","bhUtA yuSmAkaM vazIbhavanti, etannimittat mA samullasata, svarge yuSmAkaM nAmAni likhitAni santIti nimittaM samullasata| ");
INSERT INTO sanhk_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","tadghaTikAyAM yIzu rmanasi jAtAhlAdaH kathayAmAsa he svargapRthivyorekAdhipate pitastvaM jJAnavatAM viduSAJca lokAnAM purastAt sarvvametad aprakAzya bAlakAnAM purastAt prAkAzaya etasmAddhetostvAM dhanyaM vadAmi, he pitaritthaM bhavatu yad etadeva tava gocara uttamam| ");
INSERT INTO sanhk_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","pitrA sarvvANi mayi samarpitAni pitaraM vinA kopi putraM na jAnAti kiJca putraM vinA yasmai janAya putrastaM prakAzitavAn taJca vinA kopi pitaraM na jAnAti| ");
INSERT INTO sanhk_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","tapaH paraM sa ziSyAn prati parAvRtya guptaM jagAda, yUyametAni sarvvANi pazyatha tato yuSmAkaM cakSUMSi dhanyAni| ");
INSERT INTO sanhk_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","yuSmAnahaM vadAmi, yUyaM yAni sarvvANi pazyatha tAni bahavo bhaviSyadvAdino bhUpatayazca draSTumicchantopi draSTuM na prApnuvan, yuSmAbhi ryA yAH kathAzca zrUyante tAH zrotumicchantopi zrotuM nAlabhanta| ");
INSERT INTO sanhk_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","anantaram eko vyavasthApaka utthAya taM parIkSituM papraccha, he upadezaka anantAyuSaH prAptaye mayA kiM karaNIyaM? ");
INSERT INTO sanhk_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","yIzuH pratyuvAca, atrArthe vyavasthAyAM kiM likhitamasti? tvaM kIdRk paThasi? ");
INSERT INTO sanhk_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","tataH sovadat, tvaM sarvvAntaHkaraNaiH sarvvaprANaiH sarvvazaktibhiH sarvvacittaizca prabhau paramezvare prema kuru, samIpavAsini svavat prema kuru ca| ");
INSERT INTO sanhk_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","tadA sa kathayAmAsa, tvaM yathArthaM pratyavocaH, ittham Acara tenaiva jIviSyasi| ");
INSERT INTO sanhk_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","kintu sa janaH svaM nirddoSaM jJApayituM yIzuM papraccha, mama samIpavAsI kaH? tato yIzuH pratyuvAca, ");
INSERT INTO sanhk_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","eko jano yirUzAlampurAd yirIhopuraM yAti, etarhi dasyUnAM kareSu patite te tasya vastrAdikaM hRtavantaH tamAhatya mRtaprAyaM kRtvA tyaktvA yayuH| ");
INSERT INTO sanhk_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","akasmAd eko yAjakastena mArgeNa gacchan taM dRSTvA mArgAnyapArzvena jagAma| ");
INSERT INTO sanhk_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ittham eko levIyastatsthAnaM prApya tasyAntikaM gatvA taM vilokyAnyena pArzvena jagAma| ");
INSERT INTO sanhk_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","kintvekaH zomiroNIyo gacchan tatsthAnaM prApya taM dRSTvAdayata| ");
INSERT INTO sanhk_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","tasyAntikaM gatvA tasya kSateSu tailaM drAkSArasaJca prakSipya kSatAni baddhvA nijavAhanopari tamupavezya pravAsIyagRham AnIya taM siSeve| ");
INSERT INTO sanhk_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","parasmin divase nijagamanakAle dvau mudrApAdau tadgRhasvAmine dattvAvadat janamenaM sevasva tatra yo'dhiko vyayo bhaviSyati tamahaM punarAgamanakAle parizotsyAmi| ");
INSERT INTO sanhk_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","eSAM trayANAM madhye tasya dasyuhastapatitasya janasya samIpavAsI kaH? tvayA kiM budhyate? ");
INSERT INTO sanhk_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","tataH sa vyavasthApakaH kathayAmAsa yastasmin dayAM cakAra| tadA yIzuH kathayAmAsa tvamapi gatvA tathAcara| ");
INSERT INTO sanhk_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","tataH paraM te gacchanta ekaM grAmaM pravivizuH; tadA marthAnAmA strI svagRhe tasyAtithyaM cakAra| ");
INSERT INTO sanhk_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","tasmAt mariyam nAmadheyA tasyA bhaginI yIzoH padasamIpa uvavizya tasyopadezakathAM zrotumArebhe| ");
INSERT INTO sanhk_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","kintu marthA nAnAparicaryyAyAM vyagrA babhUva tasmAddhetostasya samIpamAgatya babhASe; he prabho mama bhaginI kevalaM mamopari sarvvakarmmaNAM bhAram arpitavatI tatra bhavatA kiJcidapi na mano nidhIyate kim? mama sAhAyyaM karttuM bhavAn tAmAdizatu| ");
INSERT INTO sanhk_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","tato yIzuH pratyuvAca he marthe he marthe, tvaM nAnAkAryyeSu cintitavatI vyagrA cAsi, ");
INSERT INTO sanhk_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","kintu prayojanIyam ekamAtram Aste| aparaJca yamuttamaM bhAgaM kopi harttuM na zaknoti saeva mariyamA vRtaH| ");
INSERT INTO sanhk_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","anantaraM sa kasmiMzcit sthAne prArthayata tatsamAptau satyAM tasyaikaH ziSyastaM jagAda he prabho yohan yathA svaziSyAn prArthayitum upadiSTavAn tathA bhavAnapyasmAn upadizatu| ");
INSERT INTO sanhk_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","tasmAt sa kathayAmAsa, prArthanakAle yUyam itthaM kathayadhvaM, he asmAkaM svargasthapitastava nAma pUjyaM bhavatu; tava rAjatvaM bhavatu; svarge yathA tathA pRthivyAmapi tavecchayA sarvvaM bhavatu| ");
INSERT INTO sanhk_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","pratyaham asmAkaM prayojanIyaM bhojyaM dehi| ");
INSERT INTO sanhk_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","yathA vayaM sarvvAn aparAdhinaH kSamAmahe tathA tvamapi pApAnyasmAkaM kSamasva| asmAn parIkSAM mAnaya kintu pApAtmano rakSa| ");
INSERT INTO sanhk_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","pazcAt soparamapi kathitavAn yadi yuSmAkaM kasyacid bandhustiSThati nizIthe ca tasya samIpaM sa gatvA vadati, ");
INSERT INTO sanhk_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","he bandho pathika eko bandhu rmama nivezanam AyAtaH kintu tasyAtithyaM karttuM mamAntike kimapi nAsti, ataeva pUpatrayaM mahyam RNaM dehi; ");
INSERT INTO sanhk_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","tadA sa yadi gRhamadhyAt prativadati mAM mA klizAna, idAnIM dvAraM ruddhaM zayane mayA saha bAlakAzca tiSThanti tubhyaM dAtum utthAtuM na zaknomi, ");
INSERT INTO sanhk_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","tarhi yuSmAnahaM vadAmi, sa yadi mitratayA tasmai kimapi dAtuM nottiSThati tathApi vAraM vAraM prArthanAta utthApitaH san yasmin tasya prayojanaM tadeva dAsyati| ");
INSERT INTO sanhk_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","ataH kAraNAt kathayAmi, yAcadhvaM tato yuSmabhyaM dAsyate, mRgayadhvaM tata uddezaM prApsyatha, dvAram Ahata tato yuSmabhyaM dvAraM mokSyate| ");
INSERT INTO sanhk_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","yo yAcate sa prApnoti, yo mRgayate sa evoddezaM prApnoti, yo dvAram Ahanti tadarthaM dvAraM mocyate| ");
INSERT INTO sanhk_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","putreNa pUpe yAcite tasmai pASANaM dadAti vA matsye yAcite tasmai sarpaM dadAti ");
INSERT INTO sanhk_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","vA aNDe yAcite tasmai vRzcikaM dadAti yuSmAkaM madhye ka etAdRzaH pitAste? ");
INSERT INTO sanhk_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","tasmAdeva yUyamabhadrA api yadi svasvabAlakebhya uttamAni dravyANi dAtuM jAnItha tarhyasmAkaM svargasthaH pitA nijayAcakebhyaH kiM pavitram AtmAnaM na dAsyati? ");
INSERT INTO sanhk_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","anantaraM yIzunA kasmAccid ekasmin mUkabhUte tyAjite sati sa bhUtatyakto mAnuSo vAkyaM vaktum Arebhe; tato lokAH sakalA AzcaryyaM menire| ");
INSERT INTO sanhk_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","kintu teSAM kecidUcu rjanoyaM bAlasibUbA arthAd bhUtarAjena bhUtAn tyAjayati| ");
INSERT INTO sanhk_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","taM parIkSituM kecid AkAzIyam ekaM cihnaM darzayituM taM prArthayAJcakrire| ");
INSERT INTO sanhk_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","tadA sa teSAM manaHkalpanAM jJAtvA kathayAmAsa, kasyacid rAjyasya lokA yadi parasparaM virundhanti tarhi tad rAjyam nazyati; kecid gRhasthA yadi parasparaM virundhanti tarhi tepi nazyanti| ");
INSERT INTO sanhk_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","tathaiva zaitAnapi svalokAn yadi viruNaddhi tadA tasya rAjyaM kathaM sthAsyati? bAlasibUbAhaM bhUtAn tyAjayAmi yUyamiti vadatha| ");
INSERT INTO sanhk_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","yadyahaM bAlasibUbA bhUtAn tyAjayAmi tarhi yuSmAkaM santAnAH kena tyAjayanti? tasmAt taeva kathAyA etasyA vicArayitAro bhaviSyanti| ");
INSERT INTO sanhk_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","kintu yadyaham Izvarasya parAkrameNa bhUtAn tyAjayAmi tarhi yuSmAkaM nikaTam Izvarasya rAjyamavazyam upatiSThati| ");
INSERT INTO sanhk_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","balavAn pumAn susajjamAno yatikAlaM nijATTAlikAM rakSati tatikAlaM tasya dravyaM nirupadravaM tiSThati| ");
INSERT INTO sanhk_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","kintu tasmAd adhikabalaH kazcidAgatya yadi taM jayati tarhi yeSu zastrAstreSu tasya vizvAsa AsIt tAni sarvvANi hRtvA tasya dravyANi gRhlAti| ");
INSERT INTO sanhk_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","ataH kAraNAd yo mama sapakSo na sa vipakSaH, yo mayA saha na saMgRhlAti sa vikirati| ");
INSERT INTO sanhk_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","aparaJca amedhyabhUto mAnuSasyAntarnirgatya zuSkasthAne bhrAntvA vizrAmaM mRgayate kintu na prApya vadati mama yasmAd gRhAd AgatohaM punastad gRhaM parAvRtya yAmi| ");
INSERT INTO sanhk_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","tato gatvA tad gRhaM mArjitaM zobhitaJca dRSTvA ");
INSERT INTO sanhk_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","tatkSaNam apagatya svasmAdapi durmmatIn aparAn saptabhUtAn sahAnayati te ca tadgRhaM pavizya nivasanti| tasmAt tasya manuSyasya prathamadazAtaH zeSadazA duHkhatarA bhavati| ");
INSERT INTO sanhk_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","asyAH kathAyAH kathanakAle janatAmadhyasthA kAcinnArI tamuccaiHsvaraM provAca, yA yoSit tvAM garbbhe'dhArayat stanyamapAyayacca saiva dhanyA| ");
INSERT INTO sanhk_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","kintu sokathayat ye paramezvarasya kathAM zrutvA tadanurUpam Acaranti taeva dhanyAH| ");
INSERT INTO sanhk_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","tataH paraM tasyAntike bahulokAnAM samAgame jAte sa vaktumArebhe, AdhunikA duSTalokAzcihnaM draSTumicchanti kintu yUnasbhaviSyadvAdinazcihnaM vinAnyat kiJciccihnaM tAn na darzayiSyate| ");
INSERT INTO sanhk_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","yUnas tu yathA nInivIyalokAnAM samIpe cihnarUpobhavat tathA vidyamAnalokAnAm eSAM samIpe manuSyaputropi cihnarUpo bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","vicArasamaye idAnIntanalokAnAM prAtikUlyena dakSiNadezIyA rAjJI protthAya tAn doSiNaH kariSyati, yataH sA rAjJI sulemAna upadezakathAM zrotuM pRthivyAH sImAta Agacchat kintu pazyata sulemAnopi gurutara eko jano'smin sthAne vidyate| ");
INSERT INTO sanhk_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","aparaJca vicArasamaye nInivIyalokA api varttamAnakAlikAnAM lokAnAM vaiparItyena protthAya tAn doSiNaH kariSyanti, yato hetoste yUnaso vAkyAt cittAni parivarttayAmAsuH kintu pazyata yUnasotigurutara eko jano'smin sthAne vidyate| ");
INSERT INTO sanhk_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","pradIpaM prajvAlya droNasyAdhaH kutrApi guptasthAne vA kopi na sthApayati kintu gRhapravezibhyo dIptiM dAtaM dIpAdhAroparyyeva sthApayati| ");
INSERT INTO sanhk_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","dehasya pradIpazcakSustasmAdeva cakSu ryadi prasannaM bhavati tarhi tava sarvvazarIraM dIptimad bhaviSyati kintu cakSu ryadi malImasaM tiSThati tarhi sarvvazarIraM sAndhakAraM sthAsyati| ");
INSERT INTO sanhk_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","asmAt kAraNAt tavAntaHsthaM jyoti ryathAndhakAramayaM na bhavati tadarthe sAvadhAno bhava| ");
INSERT INTO sanhk_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","yataH zarIrasya kutrApyaMze sAndhakAre na jAte sarvvaM yadi dIptimat tiSThati tarhi tubhyaM dIptidAyiprojjvalan pradIpa iva tava savarvazarIraM dIptimad bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","etatkathAyAH kathanakAle phiruzyeko bhejanAya taM nimantrayAmAsa, tataH sa gatvA bhoktum upaviveza| ");
INSERT INTO sanhk_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","kintu bhojanAt pUrvvaM nAmAGkSIt etad dRSTvA sa phiruzyAzcaryyaM mene| ");
INSERT INTO sanhk_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","tadA prabhustaM provAca yUyaM phirUzilokAH pAnapAtrANAM bhojanapAtrANAJca bahiH pariSkurutha kintu yuSmAkamanta rdaurAtmyai rduSkriyAbhizca paripUrNaM tiSThati| ");
INSERT INTO sanhk_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","he sarvve nirbodhA yo bahiH sasarja sa eva kimanta rna sasarja? ");
INSERT INTO sanhk_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","tata eva yuSmAbhirantaHkaraNaM (IzvarAya) nivedyatAM tasmin kRte yuSmAkaM sarvvANi zucitAM yAsyanti| ");
INSERT INTO sanhk_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","kintu hanta phirUzigaNA yUyaM nyAyam Izvare prema ca parityajya podinAyA arudAdInAM sarvveSAM zAkAnAJca dazamAMzAn dattha kintu prathamaM pAlayitvA zeSasyAlaGghanaM yuSmAkam ucitamAsIt| ");
INSERT INTO sanhk_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","hA hA phirUzino yUyaM bhajanagehe proccAsane ApaNeSu ca namaskAreSu prIyadhve| ");
INSERT INTO sanhk_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","vata kapaTino'dhyApakAH phirUzinazca lokAyat zmazAnam anupalabhya tadupari gacchanti yUyam tAdRgaprakAzitazmazAnavAd bhavatha| ");
INSERT INTO sanhk_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","tadAnIM vyavasthApakAnAm ekA yIzumavadat, he upadezaka vAkyenedRzenAsmAsvapi doSam Aropayasi| ");
INSERT INTO sanhk_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","tataH sa uvAca, hA hA vyavasthApakA yUyam mAnuSANAm upari duHsahyAn bhArAn nyasyatha kintu svayam ekAGguुlyApi tAn bhArAn na spRzatha| ");
INSERT INTO sanhk_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","hanta yuSmAkaM pUrvvapuruSA yAn bhaviSyadvAdino'vadhiSusteSAM zmazAnAni yUyaM nirmmAtha| ");
INSERT INTO sanhk_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","tenaiva yUyaM svapUrvvapuruSANAM karmmANi saMmanyadhve tadeva sapramANaM kurutha ca, yataste tAnavadhiSuH yUyaM teSAM zmazAnAni nirmmAtha| ");
INSERT INTO sanhk_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ataeva Izvarasya zAstre proktamasti teSAmantike bhaviSyadvAdinaH preritAMzca preSayiSyAmi tataste teSAM kAMzcana haniSyanti kAMzcana tADazSyinti| ");
INSERT INTO sanhk_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","etasmAt kAraNAt hAbilaH zoNitapAtamArabhya mandirayajJavedyo rmadhye hatasya sikhariyasya raktapAtaparyyantaM ");
INSERT INTO sanhk_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","jagataH sRSTimArabhya pRthivyAM bhaviSyadvAdinAM yatiraktapAtA jAtAstatInAm aparAdhadaNDA eSAM varttamAnalokAnAM bhaviSyanti, yuSmAnahaM nizcitaM vadAmi sarvve daNDA vaMzasyAsya bhaviSyanti| ");
INSERT INTO sanhk_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","hA hA vyavasthapakA yUyaM jJAnasya kuJcikAM hRtvA svayaM na praviSTA ye praveSTuJca prayAsinastAnapi praveSTuM vAritavantaH| ");
INSERT INTO sanhk_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","itthaM kathAkathanAd adhyApakAH phirUzinazca satarkAH ");
INSERT INTO sanhk_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","santastamapavadituM tasya kathAyA doSaM dharttamicchanto nAnAkhyAnakathanAya taM pravarttayituM kopayituJca prArebhire| ");
INSERT INTO sanhk_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","tadAnIM lokAH sahasraM sahasram Agatya samupasthitAstata ekaiko 'nyeSAmupari patitum upacakrame; tadA yIzuH ziSyAn babhASe, yUyaM phirUzinAM kiNvarUpakApaTye vizeSeNa sAvadhAnAstiSThata| ");
INSERT INTO sanhk_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","yato yanna prakAzayiSyate tadAcchannaM vastu kimapi nAsti; tathA yanna jJAsyate tad guptaM vastu kimapi nAsti| ");
INSERT INTO sanhk_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","andhakAre tiSThanato yAH kathA akathayata tAH sarvvAH kathA dIptau zroSyante nirjane karNe ca yadakathayata gRhapRSThAt tat pracArayiSyate| ");
INSERT INTO sanhk_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","he bandhavo yuSmAnahaM vadAmi, ye zarIrasya nAzaM vinA kimapyaparaM karttuM na zakruvanti tebhyo mA bhaiSTa| ");
INSERT INTO sanhk_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","tarhi kasmAd bhetavyam ityahaM vadAmi, yaH zarIraM nAzayitvA narakaM nikSeptuM zaknoti tasmAdeva bhayaM kuruta, punarapi vadAmi tasmAdeva bhayaM kuruta| ");
INSERT INTO sanhk_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","paJca caTakapakSiNaH kiM dvAbhyAM tAmrakhaNDAbhyAM na vikrIyante? tathApIzvarasteSAm ekamapi na vismarati| ");
INSERT INTO sanhk_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","yuSmAkaM ziraHkezA api gaNitAH santi tasmAt mA vibhIta bahucaTakapakSibhyopi yUyaM bahumUlyAH| ");
INSERT INTO sanhk_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","aparaM yuSmabhyaM kathayAmi yaH kazcin mAnuSANAM sAkSAn mAM svIkaroti manuSyaputra IzvaradUtAnAM sAkSAt taM svIkariSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","kintu yaH kazcinmAnuSANAM sAkSAnmAm asvIkaroti tam Izvarasya dUtAnAM sAkSAd aham asvIkariSyAmi| ");
INSERT INTO sanhk_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","anyacca yaH kazcin manujasutasya nindAbhAvena kAJcit kathAM kathayati tasya tatpApasya mocanaM bhaviSyati kintu yadi kazcit pavitram AtmAnaM nindati tarhi tasya tatpApasya mocanaM na bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","yadA lokA yuSmAn bhajanagehaM vicArakartRrAjyakartRNAM sammukhaJca neSyanti tadA kena prakAreNa kimuttaraM vadiSyatha kiM kathayiSyatha cetyatra mA cintayata; ");
INSERT INTO sanhk_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","yato yuSmAbhiryad yad vaktavyaM tat tasmin samayaeva pavitra AtmA yuSmAn zikSayiSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","tataH paraM janatAmadhyasthaH kazcijjanastaM jagAda he guro mayA saha paitRkaM dhanaM vibhaktuM mama bhrAtaramAjJApayatu bhavAn| ");
INSERT INTO sanhk_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","kintu sa tamavadat he manuSya yuvayo rvicAraM vibhAgaJca karttuM mAM ko niyuktavAn? ");
INSERT INTO sanhk_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","anantaraM sa lokAnavadat lobhe sAvadhAnAH satarkAzca tiSThata, yato bahusampattiprAptyA manuSyasyAyu rna bhavati| ");
INSERT INTO sanhk_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","pazcAd dRSTAntakathAmutthApya kathayAmAsa, ekasya dhanino bhUmau bahUni zasyAni jAtAni| ");
INSERT INTO sanhk_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","tataH sa manasA cintayitvA kathayAmbabhUva mamaitAni samutpannAni dravyANi sthApayituM sthAnaM nAsti kiM kariSyAmi? ");
INSERT INTO sanhk_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","tatovadad itthaM kariSyAmi, mama sarvvabhANDAgArANi bhaGktvA bRhadbhANDAgArANi nirmmAya tanmadhye sarvvaphalAni dravyANi ca sthApayiSyAmi| ");
INSERT INTO sanhk_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","aparaM nijamano vadiSyAmi, he mano bahuvatsarArthaM nAnAdravyANi saJcitAni santi vizrAmaM kuru bhuktvA pItvA kautukaJca kuru| kintvIzvarastam avadat, ");
INSERT INTO sanhk_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","re nirbodha adya rAtrau tava prANAstvatto neSyante tata etAni yAni dravyANi tvayAsAditAni tAni kasya bhaviSyanti? ");
INSERT INTO sanhk_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","ataeva yaH kazcid Izvarasya samIpe dhanasaJcayamakRtvA kevalaM svanikaTe saJcayaM karoti sopi tAdRzaH| ");
INSERT INTO sanhk_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","atha sa ziSyebhyaH kathayAmAsa, yuSmAnahaM vadAmi, kiM khAdiSyAmaH? kiM paridhAsyAmaH? ityuktvA jIvanasya zarIrasya cArthaM cintAM mA kArSTa| ");
INSERT INTO sanhk_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","bhakSyAjjIvanaM bhUSaNAccharIraJca zreSThaM bhavati| ");
INSERT INTO sanhk_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","kAkapakSiNAM kAryyaM vicArayata, te na vapanti zasyAni ca na chindanti, teSAM bhANDAgArANi na santi koSAzca na santi, tathApIzvarastebhyo bhakSyANi dadAti, yUyaM pakSibhyaH zreSThatarA na kiM? ");
INSERT INTO sanhk_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","aparaJca bhAvayitvA nijAyuSaH kSaNamAtraM varddhayituM zaknoti, etAdRzo lAko yuSmAkaM madhye kosti? ");
INSERT INTO sanhk_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","ataeva kSudraM kAryyaM sAdhayitum asamarthA yUyam anyasmin kAryye kuto bhAvayatha? ");
INSERT INTO sanhk_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","anyacca kAmpilapuSpaM kathaM varddhate tadApi vicArayata, tat kaJcana zramaM na karoti tantUMzca na janayati kintu yuSmabhyaM yathArthaM kathayAmi sulemAn bahvaizvaryyAnvitopi puSpasyAsya sadRzo vibhUSito nAsIt| ");
INSERT INTO sanhk_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","adya kSetre varttamAnaM zvazcUllyAM kSepsyamAnaM yat tRNaM, tasmai yadIzvara itthaM bhUSayati tarhi he alpapratyayino yuSmAna kiM na paridhApayiSyati? ");
INSERT INTO sanhk_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","ataeva kiM khAdiSyAmaH? kiM paridhAsyAmaH? etadarthaM mA ceSTadhvaM mA saMdigdhvaJca| ");
INSERT INTO sanhk_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","jagato devArccakA etAni sarvvANi ceSTanate; eSu vastuSu yuSmAkaM prayojanamAste iti yuSmAkaM pitA jAnAti| ");
INSERT INTO sanhk_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","ataevezvarasya rAjyArthaM saceSTA bhavata tathA kRte sarvvANyetAni dravyANi yuSmabhyaM pradAyiSyante| ");
INSERT INTO sanhk_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","he kSudrameSavraja yUyaM mA bhaiSTa yuSmabhyaM rAjyaM dAtuM yuSmAkaM pituH sammatirasti| ");
INSERT INTO sanhk_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ataeva yuSmAkaM yA yA sampattirasti tAM tAM vikrIya vitarata, yat sthAnaM caurA nAgacchanti, kITAzca na kSAyayanti tAdRze svarge nijArtham ajare sampuTake 'kSayaM dhanaM saJcinuta ca; ");
INSERT INTO sanhk_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","yato yatra yuSmAkaM dhanaM varttate tatreva yuSmAkaM manaH| ");
INSERT INTO sanhk_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","aparaJca yUyaM pradIpaM jvAlayitvA baddhakaTayastiSThata; ");
INSERT INTO sanhk_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","prabhu rvivAhAdAgatya yadaiva dvAramAhanti tadaiva dvAraM mocayituM yathA bhRtyA apekSya tiSThanti tathA yUyamapi tiSThata| ");
INSERT INTO sanhk_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","yataH prabhurAgatya yAn dAsAn sacetanAn tiSThato drakSyati taeva dhanyAH; ahaM yuSmAn yathArthaM vadAmi prabhustAn bhojanArtham upavezya svayaM baddhakaTiH samIpametya pariveSayiSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","yadi dvitIye tRtIye vA prahare samAgatya tathaiva pazyati, tarhi taeva dAsA dhanyAH| ");
INSERT INTO sanhk_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","aparaJca kasmin kSaNe caurA AgamiSyanti iti yadi gRhapati rjJAtuM zaknoti tadAvazyaM jAgran nijagRhe sandhiM karttayituM vArayati yUyametad vitta| ");
INSERT INTO sanhk_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","ataeva yUyamapi sajjamAnAstiSThata yato yasmin kSaNe taM nAprekSadhve tasminneva kSaNe manuSyaputra AgamiSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","tadA pitaraH papraccha, he prabho bhavAn kimasmAn uddizya kiM sarvvAn uddizya dRSTAntakathAmimAM vadati? ");
INSERT INTO sanhk_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","tataH prabhuH provAca, prabhuH samucitakAle nijaparivArArthaM bhojyapariveSaNAya yaM tatpade niyokSyati tAdRzo vizvAsyo boddhA karmmAdhIzaH kosti? ");
INSERT INTO sanhk_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","prabhurAgatya yam etAdRze karmmaNi pravRttaM drakSyati saeva dAso dhanyaH| ");
INSERT INTO sanhk_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ahaM yuSmAn yathArthaM vadAmi sa taM nijasarvvasvasyAdhipatiM kariSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","kintu prabhurvilambenAgamiSyati, iti vicintya sa dAso yadi tadanyadAsIdAsAn praharttum bhoktuM pAtuM madituJca prArabhate, ");
INSERT INTO sanhk_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","tarhi yadA prabhuM nApekSiSyate yasmin kSaNe so'cetanazca sthAsyati tasminneva kSaNe tasya prabhurAgatya taM padabhraSTaM kRtvA vizvAsahInaiH saha tasya aMzaM nirUpayiSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","yo dAsaH prabheाrAjJAM jJAtvApi sajjito na tiSThati tadAjJAnusAreNa ca kAryyaM na karoti sonekAn prahArAn prApsyati; ");
INSERT INTO sanhk_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","kintu yo jano'jJAtvA prahArArhaM karmma karoti solpaprahArAn prApsyati| yato yasmai bAhulyena dattaM tasmAdeva bAhulyena grahISyate, mAnuSA yasya nikaTe bahu samarpayanti tasmAd bahu yAcante| ");
INSERT INTO sanhk_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","ahaM pRthivyAm anaikyarUpaM vahni nikSeptum Agatosmi, sa ced idAnImeva prajvalati tatra mama kA cintA? ");
INSERT INTO sanhk_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","kintu yena majjanenAhaM magno bhaviSyAmi yAvatkAlaM tasya siddhi rna bhaviSyati tAvadahaM katikaSTaM prApsyAmi| ");
INSERT INTO sanhk_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","melanaM karttuM jagad Agatosmi yUyaM kimitthaM bodhadhve? yuSmAn vadAmi na tathA, kintvahaM melanAbhAvaM karttuMm Agatosmi| ");
INSERT INTO sanhk_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","yasmAdetatkAlamArabhya ekatrasthaparijanAnAM madhye paJcajanAH pRthag bhUtvA trayo janA dvayorjanayoH pratikUlA dvau janau ca trayANAM janAnAM pratikUlau bhaviSyanti| ");
INSERT INTO sanhk_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","pitA putrasya vipakSaH putrazca pitu rvipakSo bhaviSyati mAtA kanyAyA vipakSA kanyA ca mAtu rvipakSA bhaviSyati, tathA zvazrUrbadhvA vipakSA badhUzca zvazrvA vipakSA bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","sa lokebhyoparamapi kathayAmAsa, pazcimadizi meghodgamaM dRSTvA yUyaM haThAd vadatha vRSTi rbhaviSyati tatastathaiva jAyate| ");
INSERT INTO sanhk_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","aparaM dakSiNato vAyau vAti sati vadatha nidAgho bhaviSyati tataH sopi jAyate| ");
INSERT INTO sanhk_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","re re kapaTina AkAzasya bhUmyAzca lakSaNaM boddhuM zaknutha, ");
INSERT INTO sanhk_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","kintu kAlasyAsya lakSaNaM kuto boddhuM na zaknutha? yUyaJca svayaM kuto na nyASyaM vicArayatha? ");
INSERT INTO sanhk_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","aparaJca vivAdinA sArddhaM vicArayituH samIpaM gacchan pathi tasmAduddhAraM prAptuM yatasva nocet sa tvAM dhRtvA vicArayituH samIpaM nayati| vicArayitA yadi tvAM praharttuH samIpaM samarpayati praharttA tvAM kArAyAM badhnAti ");
INSERT INTO sanhk_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","tarhi tvAmahaM vadAmi tvayA niHzeSaM kapardakeSu na parizodhiteSu tvaM tato muktiM prAptuM na zakSyasi| ");
INSERT INTO sanhk_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","aparaJca pIlAto yeSAM gAlIlIyAnAM raktAni balInAM raktaiH sahAmizrayat teSAM gAlIlIyAnAM vRttAntaM katipayajanA upasthApya yIzave kathayAmAsuH| ");
INSERT INTO sanhk_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","tataH sa pratyuvAca teSAM lokAnAm etAdRzI durgati rghaTitA tatkAraNAd yUyaM kimanyebhyo gAlIlIyebhyopyadhikapApinastAn bodhadhve? ");
INSERT INTO sanhk_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","yuSmAnahaM vadAmi tathA na kintu manaHsu na parAvarttiteSu yUyamapi tathA naMkSyatha| ");
INSERT INTO sanhk_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","aparaJca zIlohanAmna uccagRhasya patanAd ye'STAdazajanA mRtAste yirUzAlami nivAsisarvvalokebhyo'dhikAparAdhinaH kiM yUyamityaM bodhadhve? ");
INSERT INTO sanhk_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","yuSmAnahaM vadAmi tathA na kintu manaHsu na parivarttiteSu yUyamapi tathA naMkSyatha| ");
INSERT INTO sanhk_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","anantaraM sa imAM dRSTAntakathAmakathayad eko jano drAkSAkSetramadhya ekamuDumbaravRkSaM ropitavAn| pazcAt sa Agatya tasmin phalAni gaveSayAmAsa, ");
INSERT INTO sanhk_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","kintu phalAprApteH kAraNAd udyAnakAraM bhRtyaM jagAda, pazya vatsaratrayaM yAvadAgatya etasminnuDumbaratarau kSalAnyanvicchAmi, kintu naikamapi prapnomi tarurayaM kuto vRthA sthAnaM vyApya tiSThati? enaM chindhi| ");
INSERT INTO sanhk_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","tato bhRtyaH pratyuvAca, he prabho punarvarSamekaM sthAtum Adiza; etasya mUlasya caturdikSu khanitvAham AlavAlaM sthApayAmi| ");
INSERT INTO sanhk_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","tataH phalituM zaknoti yadi na phalati tarhi pazcAt chetsyasi| ");
INSERT INTO sanhk_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","atha vizrAmavAre bhajanagehe yIzurupadizati ");
INSERT INTO sanhk_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","tasmit samaye bhUtagrastatvAt kubjIbhUyASTAdazavarSANi yAvat kenApyupAyena Rju rbhavituM na zaknoti yA durbbalA strI, ");
INSERT INTO sanhk_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","tAM tatropasthitAM vilokya yIzustAmAhUya kathitavAn he nAri tava daurbbalyAt tvaM muktA bhava| ");
INSERT INTO sanhk_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","tataH paraM tasyA gAtre hastArpaNamAtrAt sA RjurbhUtvezvarasya dhanyavAdaM karttumArebhe| ");
INSERT INTO sanhk_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","kintu vizrAmavAre yIzunA tasyAH svAsthyakaraNAd bhajanagehasyAdhipatiH prakupya lokAn uvAca, SaTsu dineSu lokaiH karmma karttavyaM tasmAddhetoH svAsthyArthaM teSu dineSu Agacchata, vizrAmavAre mAgacchata| ");
INSERT INTO sanhk_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","tadA pabhuH pratyuvAca re kapaTino yuSmAkam ekaiko jano vizrAmavAre svIyaM svIyaM vRSabhaM gardabhaM vA bandhanAnmocayitvA jalaM pAyayituM kiM na nayati? ");
INSERT INTO sanhk_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","tarhyASTAdazavatsarAn yAvat zaitAnA baddhA ibrAhImaH santatiriyaM nArI kiM vizrAmavAre na mocayitavyA? ");
INSERT INTO sanhk_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","eSu vAkyeSu kathiteSu tasya vipakSAH salajjA jAtAH kintu tena kRtasarvvamahAkarmmakAraNAt lokanivahaH sAnando'bhavat| ");
INSERT INTO sanhk_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","anantaraM sovadad Izvarasya rAjyaM kasya sadRzaM? kena tadupamAsyAmi? ");
INSERT INTO sanhk_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","yat sarSapabIjaM gRhItvA kazcijjana udyAna uptavAn tad bIjamaGkuritaM sat mahAvRkSo'jAyata, tatastasya zAkhAsu vihAyasIyavihagA Agatya nyUSuH, tadrAjyaM tAdRzena sarSapabIjena tulyaM| ");
INSERT INTO sanhk_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","punaH kathayAmAsa, Izvarasya rAjyaM kasya sadRzaM vadiSyAmi? yat kiNvaM kAcit strI gRhItvA droNatrayaparimitagodhUmacUrNeSu sthApayAmAsa, ");
INSERT INTO sanhk_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","tataH krameNa tat sarvvagodhUmacUrNaM vyApnoti, tasya kiNvasya tulyam Izvarasya rAjyaM| ");
INSERT INTO sanhk_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","tataH sa yirUzAlamnagaraM prati yAtrAM kRtvA nagare nagare grAme grAme samupadizan jagAma| ");
INSERT INTO sanhk_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","tadA kazcijjanastaM papraccha, he prabho kiM kevalam alpe lokAH paritrAsyante? ");
INSERT INTO sanhk_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","tataH sa lokAn uvAca, saMkIrNadvAreNa praveSTuM yataghvaM, yatohaM yuSmAn vadAmi, bahavaH praveSTuM ceSTiSyante kintu na zakSyanti| ");
INSERT INTO sanhk_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","gRhapatinotthAya dvAre ruddhe sati yadi yUyaM bahiH sthitvA dvAramAhatya vadatha, he prabho he prabho asmatkAraNAd dvAraM mocayatu, tataH sa iti prativakSyati, yUyaM kutratyA lokA ityahaM na jAnAmi| ");
INSERT INTO sanhk_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","tadA yUyaM vadiSyatha, tava sAkSAd vayaM bheाjanaM pAnaJca kRtavantaH, tvaJcAsmAkaM nagarasya pathi samupadiSTavAn| ");
INSERT INTO sanhk_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","kintu sa vakSyati, yuSmAnahaM vadAmi, yUyaM kutratyA lokA ityahaM na jAnAmi; he durAcAriNo yUyaM matto dUrIbhavata| ");
INSERT INTO sanhk_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","tadA ibrAhImaM ishAkaM yAkUbaJca sarvvabhaviSyadvAdinazca Izvarasya rAjyaM prAptAn svAMzca bahiSkRtAn dRSTvA yUyaM rodanaM dantairdantagharSaNaJca kariSyatha| ");
INSERT INTO sanhk_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","aparaJca pUrvvapazcimadakSiNottaradigbhyo lokA Agatya Izvarasya rAjye nivatsyanti| ");
INSERT INTO sanhk_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","pazyatetthaM zeSIyA lokA agrA bhaviSyanti, agrIyA lokAzca zeSA bhaviSyanti| ");
INSERT INTO sanhk_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","aparaJca tasmin dine kiyantaH phirUzina Agatya yIzuM procuH, bahirgaccha, sthAnAdasmAt prasthAnaM kuru, herod tvAM jighAMsati| ");
INSERT INTO sanhk_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","tataH sa pratyavocat pazyatAdya zvazca bhUtAn vihApya rogiNo'rogiNaH kRtvA tRtIyehni setsyAmi, kathAmetAM yUyamitvA taM bhUrimAyaM vadata| ");
INSERT INTO sanhk_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","tatrApyadya zvaH parazvazca mayA gamanAgamane karttavye, yato heto ryirUzAlamo bahiH kutrApi kopi bhaviSyadvAdI na ghAniSyate| ");
INSERT INTO sanhk_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","he yirUzAlam he yirUzAlam tvaM bhaviSyadvAdino haMsi tavAntike preritAn prastarairmArayasi ca, yathA kukkuTI nijapakSAdhaH svazAvakAn saMgRhlAti, tathAhamapi tava zizUn saMgrahItuM kativArAn aicchaM kintu tvaM naicchaH| ");
INSERT INTO sanhk_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","pazyata yuSmAkaM vAsasthAnAni procchidyamAnAni parityaktAni ca bhaviSyanti; yuSmAnahaM yathArthaM vadAmi, yaH prabho rnAmnAgacchati sa dhanya iti vAcaM yAvatkAlaM na vadiSyatha, tAvatkAlaM yUyaM mAM na drakSyatha| ");
INSERT INTO sanhk_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","anantaraM vizrAmavAre yIzau pradhAnasya phirUzino gRhe bhoktuM gatavati te taM vIkSitum Arebhire| ");
INSERT INTO sanhk_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","tadA jalodarI tasya sammukhe sthitaH| ");
INSERT INTO sanhk_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","tataH sa vyavasthApakAn phirUzinazca papraccha, vizrAmavAre svAsthyaM karttavyaM na vA? tataste kimapi na pratyUcuH| ");
INSERT INTO sanhk_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","tadA sa taM rogiNaM svasthaM kRtvA visasarja; ");
INSERT INTO sanhk_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","tAnuvAca ca yuSmAkaM kasyacid garddabho vRSabho vA ced gartte patati tarhi vizrAmavAre tatkSaNaM sa kiM taM notthApayiSyati? ");
INSERT INTO sanhk_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","tataste kathAyA etasyAH kimapi prativaktuM na zekuH| ");
INSERT INTO sanhk_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","aparaJca pradhAnasthAnamanonItatvakaraNaM vilokya sa nimantritAn etadupadezakathAM jagAda, ");
INSERT INTO sanhk_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","tvaM vivAhAdibhojyeSu nimantritaH san pradhAnasthAne mopAvekSIH| tvatto gauravAnvitanimantritajana AyAte ");
INSERT INTO sanhk_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","nimantrayitAgatya manuSyAyaitasmai sthAnaM dehIti vAkyaM ced vakSyati tarhi tvaM saGkucito bhUtvA sthAna itarasmin upaveSTum udyaMsyasi| ");
INSERT INTO sanhk_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","asmAt kAraNAdeva tvaM nimantrito gatvA'pradhAnasthAna upaviza, tato nimantrayitAgatya vadiSyati, he bandho proccasthAnaM gatvopaviza, tathA sati bhojanopaviSTAnAM sakalAnAM sAkSAt tvaM mAnyo bhaviSyasi| ");
INSERT INTO sanhk_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","yaH kazcit svamunnamayati sa namayiSyate, kintu yaH kazcit svaM namayati sa unnamayiSyate| ");
INSERT INTO sanhk_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","tadA sa nimantrayitAraM janamapi jagAda, madhyAhne rAtrau vA bhojye kRte nijabandhugaNo vA bhrAtRृgaNo vA jJAtigaNo vA dhanigaNo vA samIpavAsigaNo vA etAn na nimantraya, tathA kRte cet te tvAM nimantrayiSyanti, tarhi parizodho bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","kintu yadA bhejyaM karoSi tadA daridrazuSkakarakhaJjAndhAn nimantraya, ");
INSERT INTO sanhk_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","tata AziSaM lapsyase, teSu parizodhaM karttumazaknuvatsu zmazAnAddhArmmikAnAmutthAnakAle tvaM phalAM lapsyase| ");
INSERT INTO sanhk_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","anantaraM tAM kathAM nizamya bhojanopaviSTaH kazcit kathayAmAsa, yo jana Izvarasya rAjye bhoktuM lapsyate saeva dhanyaH| ");
INSERT INTO sanhk_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","tataH sa uvAca, kazcit jano rAtrau bheाjyaM kRtvA bahUn nimantrayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","tato bhojanasamaye nimantritalokAn AhvAtuM dAsadvArA kathayAmAsa, khadyadravyANi sarvvANi samAsAditAni santi, yUyamAgacchata| ");
INSERT INTO sanhk_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","kintu te sarvva ekaikaM chalaM kRtvA kSamAM prArthayAJcakrire| prathamo janaH kathayAmAsa, kSetramekaM krItavAnahaM tadeva draSTuM mayA gantavyam, ataeva mAM kSantuM taM nivedaya| ");
INSERT INTO sanhk_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","anyo janaH kathayAmAsa, dazavRSAnahaM krItavAn tAn parIkSituM yAmi tasmAdeva mAM kSantuM taM nivedaya| ");
INSERT INTO sanhk_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","aparaH kathayAmAsa, vyUDhavAnahaM tasmAt kAraNAd yAtuM na zaknomi| ");
INSERT INTO sanhk_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","pazcAt sa dAso gatvA nijaprabhoH sAkSAt sarvvavRttAntaM nivedayAmAsa, tatosau gRhapatiH kupitvA svadAsaM vyAjahAra, tvaM satvaraM nagarasya sannivezAn mArgAMzca gatvA daridrazuSkakarakhaJjAndhAn atrAnaya| ");
INSERT INTO sanhk_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","tato dAso'vadat, he prabho bhavata AjJAnusAreNAkriyata tathApi sthAnamasti| ");
INSERT INTO sanhk_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","tadA prabhuH puna rdAsAyAkathayat, rAjapathAn vRkSamUlAni ca yAtvA madIyagRhapUraNArthaM lokAnAgantuM pravarttaya| ");
INSERT INTO sanhk_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ahaM yuSmabhyaM kathayAmi, pUrvvanimantritAnamekopi mamAsya rAtribhojyasyAsvAdaM na prApsyati| ");
INSERT INTO sanhk_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","anantaraM bahuSu lokeSu yIzoH pazcAd vrajiteSu satsu sa vyAghuTya tebhyaH kathayAmAsa, ");
INSERT INTO sanhk_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","yaH kazcin mama samIpam Agatya svasya mAtA pitA patnI santAnA bhrAtaro bhagimyo nijaprANAzca, etebhyaH sarvvebhyo mayyadhikaM prema na karoti, sa mama ziSyo bhavituM na zakSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","yaH kazcit svIyaM kruzaM vahan mama pazcAnna gacchati, sopi mama ziSyo bhavituM na zakSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","durganirmmANe kativyayo bhaviSyati, tathA tasya samAptikaraNArthaM sampattirasti na vA, prathamamupavizya etanna gaNayati, yuSmAkaM madhya etAdRzaH kosti? ");
INSERT INTO sanhk_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","noced bhittiM kRtvA zeSe yadi samApayituM na zakSyati, ");
INSERT INTO sanhk_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","tarhi mAnuSoyaM nicetum Arabhata samApayituM nAzaknot, iti vyAhRtya sarvve tamupahasiSyanti| ");
INSERT INTO sanhk_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","aparaJca bhinnabhUpatinA saha yuddhaM karttum udyamya dazasahasrANi sainyAni gRhItvA viMzatisahasreH sainyaiH sahitasya samIpavAsinaH sammukhaM yAtuM zakSyAmi na veti prathamaM upavizya na vicArayati etAdRzo bhUmipatiH kaH? ");
INSERT INTO sanhk_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","yadi na zaknoti tarhi ripAvatidUre tiSThati sati nijadUtaM preSya sandhiM karttuM prArthayeta| ");
INSERT INTO sanhk_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","tadvad yuSmAkaM madhye yaH kazcin madarthaM sarvvasvaM hAtuM na zaknoti sa mama ziSyo bhavituM na zakSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","lavaNam uttamam iti satyaM, kintu yadi lavaNasya lavaNatvam apagacchati tarhi tat kathaM svAduyuktaM bhaviSyati? ");
INSERT INTO sanhk_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","tada bhUmyartham AlavAlarAzyarthamapi bhadraM na bhavati; lokAstad bahiH kSipanti|yasya zrotuM zrotre staH sa zRNotu| ");
INSERT INTO sanhk_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","tadA karasaJcAyinaH pApinazca lokA upadezkathAM zrotuM yIzoH samIpam Agacchan| ");
INSERT INTO sanhk_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","tataH phirUzina upAdhyAyAzca vivadamAnAH kathayAmAsuH eSa mAnuSaH pApibhiH saha praNayaM kRtvA taiH sArddhaM bhuMkte| ");
INSERT INTO sanhk_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","tadA sa tebhya imAM dRSTAntakathAM kathitavAn, ");
INSERT INTO sanhk_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","kasyacit zatameSeSu tiSThatmu teSAmekaM sa yadi hArayati tarhi madhyeprAntaram ekonazatameSAn vihAya hAritameSasya uddezaprAptiparyyanataM na gaveSayati, etAdRzo loko yuSmAkaM madhye ka Aste? ");
INSERT INTO sanhk_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","tasyoddezaM prApya hRSTamanAstaM skandhe nidhAya svasthAnam AnIya bandhubAndhavasamIpavAsina AhUya vakti, ");
INSERT INTO sanhk_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","hAritaM meSaM prAptoham ato heto rmayA sArddham Anandata| ");
INSERT INTO sanhk_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","tadvadahaM yuSmAn vadAmi, yeSAM manaHparAvarttanasya prayojanaM nAsti, tAdRzaikonazatadhArmmikakAraNAd ya AnandastasmAd ekasya manaHparivarttinaH pApinaH kAraNAt svarge 'dhikAnando jAyate| ");
INSERT INTO sanhk_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","aparaJca dazAnAM rUpyakhaNDAnAm ekakhaNDe hArite pradIpaM prajvAlya gRhaM sammArjya tasya prAptiM yAvad yatnena na gaveSayati, etAdRzI yoSit kAste? ");
INSERT INTO sanhk_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","prApte sati bandhubAndhavasamIpavAsinIrAhUya kathayati, hAritaM rUpyakhaNDaM prAptAhaM tasmAdeva mayA sArddham Anandata| ");
INSERT INTO sanhk_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","tadvadahaM yuSmAn vyAharAmi, ekena pApinA manasi parivarttite, Izvarasya dUtAnAM madhyepyAnando jAyate| ");
INSERT INTO sanhk_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","aparaJca sa kathayAmAsa, kasyacid dvau putrAvAstAM, ");
INSERT INTO sanhk_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","tayoH kaniSThaH putraH pitre kathayAmAsa, he pitastava sampattyA yamaMzaM prApsyAmyahaM vibhajya taM dehi, tataH pitA nijAM sampattiM vibhajya tAbhyAM dadau| ");
INSERT INTO sanhk_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","katipayAt kAlAt paraM sa kaniSThaputraH samastaM dhanaM saMgRhya dUradezaM gatvA duSTAcaraNena sarvvAM sampattiM nAzayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","tasya sarvvadhane vyayaM gate taddeze mahAdurbhikSaM babhUva, tatastasya dainyadazA bhavitum Arebhe| ");
INSERT INTO sanhk_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","tataH paraM sa gatvA taddezIyaM gRhasthamekam Azrayata; tataH sataM zUkaravrajaM cArayituM prAntaraM preSayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","kenApi tasmai bhakSyAdAnAt sa zUkaraphalavalkalena piciNDapUraNAM vavAJcha| ");
INSERT INTO sanhk_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","zeSe sa manasi cetanAM prApya kathayAmAsa, hA mama pituH samIpe kati kati vetanabhujo dAsA yatheSTaM tatodhikaJca bhakSyaM prApnuvanti kintvahaM kSudhA mumUrSuH| ");
INSERT INTO sanhk_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ahamutthAya pituH samIpaM gatvA kathAmetAM vadiSyAmi, he pitar Izvarasya tava ca viruddhaM pApamakaravam ");
INSERT INTO sanhk_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","tava putra_iti vikhyAto bhavituM na yogyosmi ca, mAM tava vaitanikaM dAsaM kRtvA sthApaya| ");
INSERT INTO sanhk_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","pazcAt sa utthAya pituH samIpaM jagAma; tatastasya pitAtidUre taM nirIkSya dayAJcakre, dhAvitvA tasya kaNThaM gRhItvA taM cucumba ca| ");
INSERT INTO sanhk_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","tadA putra uvAca, he pitar Izvarasya tava ca viruddhaM pApamakaravaM, tava putra_iti vikhyAto bhavituM na yogyosmi ca| ");
INSERT INTO sanhk_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","kintu tasya pitA nijadAsAn Adideza, sarvvottamavastrANyAnIya paridhApayatainaM haste cAGgurIyakam arpayata pAdayozcopAnahau samarpayata; ");
INSERT INTO sanhk_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","puSTaM govatsam AnIya mArayata ca taM bhuktvA vayam AnandAma| ");
INSERT INTO sanhk_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","yato mama putroyam amriyata punarajIvId hAritazca labdhobhUt tatasta Ananditum Arebhire| ");
INSERT INTO sanhk_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","tatkAle tasya jyeSThaH putraH kSetra AsIt| atha sa nivezanasya nikaTaM Agacchan nRtyAnAM vAdyAnAJca zabdaM zrutvA ");
INSERT INTO sanhk_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","dAsAnAm ekam AhUya papraccha, kiM kAraNamasya? ");
INSERT INTO sanhk_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","tataH sovAdIt, tava bhrAtAgamat, tava tAtazca taM suzarIraM prApya puSTaM govatsaM mAritavAn| ");
INSERT INTO sanhk_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","tataH sa prakupya nivezanAntaH praveSTuM na sammene; tatastasya pitA bahirAgatya taM sAdhayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","tataH sa pitaraM pratyuvAca, pazya tava kAJcidapyAjJAM na vilaMghya bahUn vatsarAn ahaM tvAM seve tathApi mitraiH sArddham utsavaM karttuM kadApi chAgamekamapi mahyaM nAdadAH; ");
INSERT INTO sanhk_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","kintu tava yaH putro vezyAgamanAdibhistava sampattim apavyayitavAn tasminnAgatamAtre tasyaiva nimittaM puSTaM govatsaM mAritavAn| ");
INSERT INTO sanhk_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","tadA tasya pitAvocat, he putra tvaM sarvvadA mayA sahAsi tasmAn mama yadyadAste tatsarvvaM tava| ");
INSERT INTO sanhk_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","kintu tavAyaM bhrAtA mRtaH punarajIvId hAritazca bhUtvA prAptobhUt, etasmAt kAraNAd utsavAnandau karttum ucitamasmAkam| ");
INSERT INTO sanhk_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","aparaJca yIzuH ziSyebhyonyAmekAM kathAM kathayAmAsa kasyacid dhanavato manuSyasya gRhakAryyAdhIze sampatterapavyaye'pavAdite sati ");
INSERT INTO sanhk_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","tasya prabhustam AhUya jagAda, tvayi yAmimAM kathAM zRNomi sA kIdRzI? tvaM gRhakAryyAdhIzakarmmaNo gaNanAM darzaya gRhakAryyAdhIzapade tvaM na sthAsyasi| ");
INSERT INTO sanhk_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","tadA sa gRhakAryyAdhIzo manasA cintayAmAsa, prabhu ryadi mAM gRhakAryyAdhIzapadAd bhraMzayati tarhi kiM kariSye'haM? mRdaM khanituM mama zakti rnAsti bhikSituJca lajjiSye'haM| ");
INSERT INTO sanhk_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ataeva mayi gRhakAryyAdhIzapadAt cyute sati yathA lokA mahyam AzrayaM dAsyanti tadarthaM yatkarmma mayA karaNIyaM tan nirNIyate| ");
INSERT INTO sanhk_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","pazcAt sa svaprabhorekaikam adhamarNam AhUya prathamaM papraccha, tvatto me prabhuNA kati prApyam? ");
INSERT INTO sanhk_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","tataH sa uvAca, ekazatADhakatailAni; tadA gRhakAryyAdhIzaH provAca, tava patramAnIya zIghramupavizya tatra paJcAzataM likha| ");
INSERT INTO sanhk_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","pazcAdanyamekaM papraccha, tvatto me prabhuNA kati prApyam? tataH sovAdId ekazatADhakagodhUmAH; tadA sa kathayAmAsa, tava patramAnIya azItiM likha| ");
INSERT INTO sanhk_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","tenaiva prabhustamayathArthakRtam adhIzaM tadbuddhinaipuNyAt prazazaMsa; itthaM dIptirUpasantAnebhya etatsaMsArasya santAnA varttamAnakAle'dhikabuddhimanto bhavanti| ");
INSERT INTO sanhk_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","ato vadAmi yUyamapyayathArthena dhanena mitrANi labhadhvaM tato yuSmAsu padabhraSTeSvapi tAni cirakAlam AzrayaM dAsyanti| ");
INSERT INTO sanhk_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","yaH kazcit kSudre kAryye vizvAsyo bhavati sa mahati kAryyepi vizvAsyo bhavati, kintu yaH kazcit kSudre kAryye'vizvAsyo bhavati sa mahati kAryyepyavizvAsyo bhavati| ");
INSERT INTO sanhk_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ataeva ayathArthena dhanena yadi yUyamavizvAsyA jAtAstarhi satyaM dhanaM yuSmAkaM kareSu kaH samarpayiSyati? ");
INSERT INTO sanhk_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","yadi ca paradhanena yUyam avizvAsyA bhavatha tarhi yuSmAkaM svakIyadhanaM yuSmabhyaM ko dAsyati? ");
INSERT INTO sanhk_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","kopi dAsa ubhau prabhU sevituM na zaknoti, yata ekasmin prIyamANo'nyasminnaprIyate yadvA ekaM janaM samAdRtya tadanyaM tucchIkaroti tadvad yUyamapi dhanezvarau sevituM na zaknutha| ");
INSERT INTO sanhk_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","tadaitAH sarvvAH kathAH zrutvA lobhiphirUzinastamupajahasuH| ");
INSERT INTO sanhk_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","tataH sa uvAca, yUyaM manuSyANAM nikaTe svAn nirdoSAn darzayatha kintu yuSmAkam antaHkaraNAnIzvaro jAnAti, yat manuSyANAm ati prazaMsyaM tad Izvarasya ghRNyaM| ");
INSERT INTO sanhk_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","yohana AgamanaparyyanataM yuSmAkaM samIpe vyavasthAbhaviSyadvAdinAM lekhanAni cAsan tataH prabhRti IzvararAjyasya susaMvAdaH pracarati, ekaiko lokastanmadhyaM yatnena pravizati ca| ");
INSERT INTO sanhk_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","varaM nabhasaH pRthivyAzca lopo bhaviSyati tathApi vyavasthAyA ekabindorapi lopo na bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","yaH kazcit svIyAM bhAryyAM vihAya striyamanyAM vivahati sa paradArAn gacchati, yazca tA tyaktAM nArIM vivahati sopi paradArAna gacchati| ");
INSERT INTO sanhk_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","eko dhanI manuSyaH zuklAni sUkSmANi vastrANi paryyadadhAt pratidinaM paritoSarUpeNAbhuMktApivacca| ");
INSERT INTO sanhk_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","sarvvAGge kSatayukta iliyAsaranAmA kazcid daridrastasya dhanavato bhojanapAtrAt patitam ucchiSTaM bhoktuM vAJchan tasya dvAre patitvAtiSThat; ");
INSERT INTO sanhk_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","atha zvAna Agatya tasya kSatAnyalihan| ");
INSERT INTO sanhk_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","kiyatkAlAtparaM sa daridraH prANAn jahau; tataH svargIyadUtAstaM nItvA ibrAhImaH kroDa upavezayAmAsuH| ");
INSERT INTO sanhk_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","pazcAt sa dhanavAnapi mamAra, taM zmazAne sthApayAmAsuzca; kintu paraloke sa vedanAkulaH san UrddhvAM nirIkSya bahudUrAd ibrAhImaM tatkroDa iliyAsaraJca vilokya ruvannuvAca; ");
INSERT INTO sanhk_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","he pitar ibrAhIm anugRhya aGgulyagrabhAgaM jale majjayitvA mama jihvAM zItalAM karttum iliyAsaraM preraya, yato vahnizikhAtohaM vyathitosmi| ");
INSERT INTO sanhk_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","tadA ibrAhIm babhASe, he putra tvaM jIvan sampadaM prAptavAn iliyAsarastu vipadaM prAptavAn etat smara, kintu samprati tasya sukhaM tava ca duHkhaM bhavati| ");
INSERT INTO sanhk_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","aparamapi yuSmAkam asmAkaJca sthAnayo rmadhye mahadvicchedo'sti tata etatsthAnasya lokAstat sthAnaM yAtuM yadvA tatsthAnasya lokA etat sthAnamAyAtuM na zaknuvanti| ");
INSERT INTO sanhk_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","tadA sa uktavAn, he pitastarhi tvAM nivedayAmi mama pitu rgehe ye mama paJca bhrAtaraH santi ");
INSERT INTO sanhk_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","te yathaitad yAtanAsthAnaM nAyAsyanti tathA mantraNAM dAtuM teSAM samIpam iliyAsaraM preraya| ");
INSERT INTO sanhk_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","tata ibrAhIm uvAca, mUsAbhaviSyadvAdinAJca pustakAni teSAM nikaTe santi te tadvacanAni manyantAM| ");
INSERT INTO sanhk_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","tadA sa nivedayAmAsa, he pitar ibrAhIm na tathA, kintu yadi mRtalokAnAM kazcit teSAM samIpaM yAti tarhi te manAMsi vyAghoTayiSyanti| ");
INSERT INTO sanhk_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","tata ibrAhIm jagAda, te yadi mUsAbhaviSyadvAdinAJca vacanAni na manyante tarhi mRtalokAnAM kasmiMzcid utthitepi te tasya mantraNAM na maMsyante| ");
INSERT INTO sanhk_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","itaH paraM yIzuH ziSyAn uvAca, vighnairavazyam AgantavyaM kintu vighnA yena ghaTiSyante tasya durgati rbhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","eteSAM kSudraprANinAm ekasyApi vighnajananAt kaNThabaddhapeSaNIkasya tasya sAgarAgAdhajale majjanaM bhadraM| ");
INSERT INTO sanhk_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","yUyaM sveSu sAvadhAnAstiSThata; tava bhrAtA yadi tava kiJcid aparAdhyati tarhi taM tarjaya, tena yadi manaH parivarttayati tarhi taM kSamasva| ");
INSERT INTO sanhk_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","punarekadinamadhye yadi sa tava saptakRtvo'parAdhyati kintu saptakRtva Agatya manaH parivartya mayAparAddham iti vadati tarhi taM kSamasva| ");
INSERT INTO sanhk_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","tadA preritAH prabhum avadan asmAkaM vizvAsaM varddhaya| ");
INSERT INTO sanhk_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","prabhuruvAca, yadi yuSmAkaM sarSapaikapramANo vizvAsosti tarhi tvaM samUlamutpATito bhUtvA samudre ropito bhava kathAyAm etasyAm etaduDumbarAya kathitAyAM sa yuSmAkamAjJAvaho bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","aparaM svadAse halaM vAhayitvA vA pazUn cArayitvA kSetrAd Agate sati taM vadati, ehi bhoktumupaviza, yuSmAkam etAdRzaH kosti? ");
INSERT INTO sanhk_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","varaJca pUrvvaM mama khAdyamAsAdya yAvad bhuJje pivAmi ca tAvad baddhakaTiH paricara pazcAt tvamapi bhokSyase pAsyasi ca kathAmIdRzIM kiM na vakSyati? ");
INSERT INTO sanhk_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","tena dAsena prabhorAjJAnurUpe karmmaNi kRte prabhuH kiM tasmin bAdhito jAtaH? netthaM budhyate mayA| ");
INSERT INTO sanhk_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","itthaM nirUpiteSu sarvvakarmmasu kRteSu satmu yUyamapIdaM vAkyaM vadatha, vayam anupakAriNo dAsA asmAbhiryadyatkarttavyaM tanmAtrameva kRtaM| ");
INSERT INTO sanhk_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","sa yirUzAlami yAtrAM kurvvan zomiroNgAlIlpradezamadhyena gacchati, ");
INSERT INTO sanhk_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","etarhi kutracid grAme pravezamAtre dazakuSThinastaM sAkSAt kRtvA ");
INSERT INTO sanhk_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","dUre tiSThanata uccai rvaktumArebhire, he prabho yIzo dayasvAsmAn| ");
INSERT INTO sanhk_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","tataH sa tAn dRSTvA jagAda, yUyaM yAjakAnAM samIpe svAn darzayata, tataste gacchanto rogAt pariSkRtAH| ");
INSERT INTO sanhk_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","tadA teSAmekaH svaM svasthaM dRSTvA proccairIzvaraM dhanyaM vadan vyAghuTyAyAto yIzo rguNAnanuvadan taccaraNAdhobhUmau papAta; ");
INSERT INTO sanhk_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","sa cAsIt zomiroNI| ");
INSERT INTO sanhk_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","tadA yIzuravadat, dazajanAH kiM na pariSkRtAH? tahyanye navajanAH kutra? ");
INSERT INTO sanhk_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","IzvaraM dhanyaM vadantam enaM videzinaM vinA kopyanyo na prApyata| ");
INSERT INTO sanhk_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","tadA sa tamuvAca, tvamutthAya yAhi vizvAsaste tvAM svasthaM kRtavAn| ");
INSERT INTO sanhk_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","atha kadezvarasya rAjatvaM bhaviSyatIti phirUzibhiH pRSTe sa pratyuvAca, Izvarasya rAjatvam aizvaryyadarzanena na bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ata etasmin pazya tasmin vA pazya, iti vAkyaM lokA vaktuM na zakSyanti, Izvarasya rAjatvaM yuSmAkam antarevAste| ");
INSERT INTO sanhk_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","tataH sa ziSyAn jagAda, yadA yuSmAbhi rmanujasutasya dinamekaM draSTum vAJchiSyate kintu na darziSyate, IdRkkAla AyAti| ");
INSERT INTO sanhk_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","tadAtra pazya vA tatra pazyeti vAkyaM lokA vakSyanti, kintu teSAM pazcAt mA yAta, mAnugacchata ca| ");
INSERT INTO sanhk_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","yatastaDid yathAkAzaikadizyudiya tadanyAmapi dizaM vyApya prakAzate tadvat nijadine manujasUnuH prakAziSyate| ");
INSERT INTO sanhk_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","kintu tatpUrvvaM tenAnekAni duHkhAni bhoktavyAnyetadvarttamAnalokaizca so'vajJAtavyaH| ");
INSERT INTO sanhk_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","nohasya vidyamAnakAle yathAbhavat manuSyasUnoH kAlepi tathA bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","yAvatkAlaM noho mahApotaM nArohad AplAvivAryyetya sarvvaM nAnAzayacca tAvatkAlaM yathA lokA abhuJjatApivan vyavahan vyavAhayaMzca; ");
INSERT INTO sanhk_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","itthaM loTo varttamAnakAlepi yathA lokA bhojanapAnakrayavikrayaropaNagRhanirmmANakarmmasu prAvarttanta, ");
INSERT INTO sanhk_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","kintu yadA loT sidomo nirjagAma tadA nabhasaH sagandhakAgnivRSTi rbhUtvA sarvvaM vyanAzayat ");
INSERT INTO sanhk_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","tadvan mAnavaputraprakAzadinepi bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","tadA yadi kazcid gRhopari tiSThati tarhi sa gRhamadhyAt kimapi dravyamAnetum avaruhya naitu; yazca kSetre tiSThati sopi vyAghuTya nAyAtu| ");
INSERT INTO sanhk_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","loTaH patnIM smarata| ");
INSERT INTO sanhk_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","yaH prANAn rakSituM ceSTiSyate sa prANAn hArayiSyati yastu prANAn hArayiSyati saeva prANAn rakSiSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","yuSmAnahaM vacmi tasyAM rAtrau zayyaikagatayo rlokayoreko dhAriSyate parastyakSyate| ");
INSERT INTO sanhk_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","striyau yugapat peSaNIM vyAvarttayiSyatastayorekA dhAriSyate parAtyakSyate| ");
INSERT INTO sanhk_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","puruSau kSetre sthAsyatastayoreko dhAriSyate parastyakSyate| ");
INSERT INTO sanhk_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","tadA te papracchuH, he prabho kutretthaM bhaviSyati? tataH sa uvAca, yatra zavastiSThati tatra gRdhrA milanti| ");
INSERT INTO sanhk_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","aparaJca lokairaklAntai rnirantaraM prArthayitavyam ityAzayena yIzunA dRSTAnta ekaH kathitaH| ");
INSERT INTO sanhk_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","kutracinnagare kazcit prADvivAka AsIt sa IzvarAnnAbibhet mAnuSAMzca nAmanyata| ");
INSERT INTO sanhk_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","atha tatpuravAsinI kAcidvidhavA tatsamIpametya vivAdinA saha mama vivAdaM pariSkurvviti nivedayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","tataH sa prADvivAkaH kiyaddinAni na tadaGgIkRtavAn pazcAccitte cintayAmAsa, yadyapIzvarAnna bibhemi manuSyAnapi na manye ");
INSERT INTO sanhk_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","tathApyeSA vidhavA mAM kliznAti tasmAdasyA vivAdaM pariSkariSyAmi nocet sA sadAgatya mAM vyagraM kariSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","pazcAt prabhuravadad asAvanyAyaprADvivAko yadAha tatra mano nidhadhvaM| ");
INSERT INTO sanhk_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Izvarasya ye 'bhirucitalokA divAnizaM prArthayante sa bahudinAni vilambyApi teSAM vivAdAn kiM na pariSkariSyati? ");
INSERT INTO sanhk_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","yuSmAnahaM vadAmi tvarayA pariSkariSyati, kintu yadA manuSyaputra AgamiSyati tadA pRthivyAM kimIdRzaM vizvAsaM prApsyati? ");
INSERT INTO sanhk_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ye svAn dhArmmikAn jJAtvA parAn tucchIkurvvanti etAdRgbhyaH, kiyadbhya imaM dRSTAntaM kathayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","ekaH phirUzyaparaH karasaJcAyI dvAvimau prArthayituM mandiraM gatau| ");
INSERT INTO sanhk_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","tato'sau phirUzyekapArzve tiSThan he Izvara ahamanyalokavat loThayitAnyAyI pAradArikazca na bhavAmi asya karasaJcAyinastulyazca na, tasmAttvAM dhanyaM vadAmi| ");
INSERT INTO sanhk_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","saptasu dineSu dinadvayamupavasAmi sarvvasampatte rdazamAMzaM dadAmi ca, etatkathAM kathayan prArthayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","kintu sa karasaJcAyi dUre tiSThan svargaM draSTuM necchan vakSasi karAghAtaM kurvvan he Izvara pApiSThaM mAM dayasva, itthaM prArthayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","yuSmAnahaM vadAmi, tayordvayo rmadhye kevalaH karasaJcAyI puNyavattvena gaNito nijagRhaM jagAma, yato yaH kazcit svamunnamayati sa nAmayiSyate kintu yaH kazcit svaM namayati sa unnamayiSyate| ");
INSERT INTO sanhk_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","atha zizUnAM gAtrasparzArthaM lokAstAn tasya samIpamAninyuH ziSyAstad dRSTvAnetRn tarjayAmAsuH, ");
INSERT INTO sanhk_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","kintu yIzustAnAhUya jagAda, mannikaTam AgantuM zizUn anujAnIdhvaM tAMzca mA vArayata; yata IzvararAjyAdhikAriNa eSAM sadRzAH| ");
INSERT INTO sanhk_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ahaM yuSmAn yathArthaM vadAmi, yo janaH zizoH sadRzo bhUtvA IzvararAjyaM na gRhlAti sa kenApi prakAreNa tat praveSTuM na zaknoti| ");
INSERT INTO sanhk_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","aparam ekodhipatistaM papraccha, he paramaguro, anantAyuSaH prAptaye mayA kiM karttavyaM? ");
INSERT INTO sanhk_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","yIzuruvAca, mAM kutaH paramaM vadasi? IzvaraM vinA kopi paramo na bhavati| ");
INSERT INTO sanhk_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","paradArAn mA gaccha, naraM mA jahi, mA coraya, mithyAsAkSyaM mA dehi, mAtaraM pitaraJca saMmanyasva, etA yA AjJAH santi tAstvaM jAnAsi| ");
INSERT INTO sanhk_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","tadA sa uvAca, bAlyakAlAt sarvvA etA AcarAmi| ");
INSERT INTO sanhk_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","iti kathAM zrutvA yIzustamavadat, tathApi tavaikaM karmma nyUnamAste, nijaM sarvvasvaM vikrIya daridrebhyo vitara, tasmAt svarge dhanaM prApsyasi; tata Agatya mamAnugAmI bhava| ");
INSERT INTO sanhk_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","kintvetAM kathAM zrutvA sodhipatiH zuzoca, yatastasya bahudhanamAsIt| ");
INSERT INTO sanhk_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","tadA yIzustamatizokAnvitaM dRSTvA jagAda, dhanavatAm IzvararAjyapravezaH kIdRg duSkaraH| ");
INSERT INTO sanhk_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","IzvararAjye dhaninaH pravezAt sUcezchidreNa mahAGgasya gamanAgamane sukare| ");
INSERT INTO sanhk_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","zrotAraH papracchustarhi kena paritrANaM prApsyate? ");
INSERT INTO sanhk_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","sa uktavAn, yan mAnuSeNAzakyaM tad IzvareNa zakyaM| ");
INSERT INTO sanhk_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","tadA pitara uvAca, pazya vayaM sarvvasvaM parityajya tava pazcAdgAmino'bhavAma| ");
INSERT INTO sanhk_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","tataH sa uvAca, yuSmAnahaM yathArthaM vadAmi, IzvararAjyArthaM gRhaM pitarau bhrAtRgaNaM jAyAM santAnAMzca tyaktavA ");
INSERT INTO sanhk_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","iha kAle tato'dhikaM parakAle 'nantAyuzca na prApsyati loka IdRzaH kopi nAsti| ");
INSERT INTO sanhk_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","anantaraM sa dvAdazaziSyAnAhUya babhASe, pazyata vayaM yirUzAlamnagaraM yAmaH, tasmAt manuSyaputre bhaviSyadvAdibhiruktaM yadasti tadanurUpaM taM prati ghaTiSyate; ");
INSERT INTO sanhk_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","vastutastu so'nyadezIyAnAM hasteSu samarpayiSyate, te tamupahasiSyanti, anyAyamAcariSyanti tadvapuSi niSThIvaM nikSepsyanti, kazAbhiH prahRtya taM haniSyanti ca, ");
INSERT INTO sanhk_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","kintu tRtIyadine sa zmazAnAd utthAsyati| ");
INSERT INTO sanhk_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","etasyAH kathAyA abhiprAyaM kiJcidapi te boddhuM na zekuH teSAM nikaTe'spaSTatavAt tasyaitAsAM kathAnAm AzayaM te jJAtuM na zekuzca| ");
INSERT INTO sanhk_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","atha tasmin yirIhoH purasyAntikaM prApte kazcidandhaH pathaH pArzva upavizya bhikSAm akarot ");
INSERT INTO sanhk_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","sa lokasamUhasya gamanazabdaM zrutvA tatkAraNaM pRSTavAn| ");
INSERT INTO sanhk_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","nAsaratIyayIzuryAtIti lokairukte sa uccairvaktumArebhe, ");
INSERT INTO sanhk_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","he dAyUdaH santAna yIzo mAM dayasva| ");
INSERT INTO sanhk_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","tatogragAminastaM maunI tiSTheti tarjayAmAsuH kintu sa punAruvan uvAca, he dAyUdaH santAna mAM dayasva| ");
INSERT INTO sanhk_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","tadA yIzuH sthagito bhUtvA svAntike tamAnetum Adideza| ");
INSERT INTO sanhk_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","tataH sa tasyAntikam Agamat, tadA sa taM papraccha, tvaM kimicchasi? tvadarthamahaM kiM kariSyAmi? sa uktavAn, he prabho'haM draSTuM labhai| ");
INSERT INTO sanhk_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","tadA yIzuruvAca, dRSTizaktiM gRhANa tava pratyayastvAM svasthaM kRtavAn| ");
INSERT INTO sanhk_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","tatastatkSaNAt tasya cakSuSI prasanne; tasmAt sa IzvaraM dhanyaM vadan tatpazcAd yayau, tadAlokya sarvve lokA IzvaraM prazaMsitum Arebhire| ");
INSERT INTO sanhk_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","yadA yIzu ryirIhopuraM pravizya tanmadhyena gacchaMstadA ");
INSERT INTO sanhk_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","sakkeyanAmA karasaJcAyinAM pradhAno dhanavAneko ");
INSERT INTO sanhk_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","yIzuH kIdRgiti draSTuM ceSTitavAn kintu kharvvatvAllokasaMghamadhye taddarzanamaprApya ");
INSERT INTO sanhk_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","yena pathA sa yAsyati tatpathe'gre dhAvitvA taM draSTum uDumbaratarumAruroha| ");
INSERT INTO sanhk_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","pazcAd yIzustatsthAnam itvA UrddhvaM vilokya taM dRSTvAvAdIt, he sakkeya tvaM zIghramavaroha mayAdya tvadgehe vastavyaM| ");
INSERT INTO sanhk_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","tataH sa zIghramavaruhya sAhlAdaM taM jagrAha| ");
INSERT INTO sanhk_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","tad dRSTvA sarvve vivadamAnA vaktumArebhire, sotithitvena duSTalokagRhaM gacchati| ");
INSERT INTO sanhk_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","kintu sakkeyo daNDAyamAno vaktumArebhe, he prabho pazya mama yA sampattirasti tadarddhaM daridrebhyo dade, aparam anyAyaM kRtvA kasmAdapi yadi kadApi kiJcit mayA gRhItaM tarhi taccaturguNaM dadAmi| ");
INSERT INTO sanhk_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","tadA yIzustamuktavAn ayamapi ibrAhImaH santAno'taH kAraNAd adyAsya gRhe trANamupasthitaM| ");
INSERT INTO sanhk_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","yad hAritaM tat mRgayituM rakSituJca manuSyaputra AgatavAn| ");
INSERT INTO sanhk_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","atha sa yirUzAlamaH samIpa upAtiSThad IzvararAjatvasyAnuSThAnaM tadaiva bhaviSyatIti lokairanvabhUyata, tasmAt sa zrotRbhyaH punardRSTAntakathAm utthApya kathayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","kopi mahAlloko nijArthaM rAjatvapadaM gRhItvA punarAgantuM dUradezaM jagAma| ");
INSERT INTO sanhk_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","yAtrAkAle nijAn dazadAsAn AhUya dazasvarNamudrA dattvA mamAgamanaparyyantaM vANijyaM kurutetyAdideza| ");
INSERT INTO sanhk_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","kintu tasya prajAstamavajJAya manuSyamenam asmAkamupari rAjatvaM na kArayivyAma imAM vArttAM tannikaTe prerayAmAsuH| ");
INSERT INTO sanhk_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","atha sa rAjatvapadaM prApyAgatavAn ekaiko jano bANijyena kiM labdhavAn iti jJAtuM yeSu dAseSu mudrA arpayat tAn AhUyAnetum Adideza| ");
INSERT INTO sanhk_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","tadA prathama Agatya kathitavAn, he prabho tava tayaikayA mudrayA dazamudrA labdhAH| ");
INSERT INTO sanhk_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","tataH sa uvAca tvamuttamo dAsaH svalpena vizvAsyo jAta itaH kAraNAt tvaM dazanagarANAm adhipo bhava| ");
INSERT INTO sanhk_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","dvitIya Agatya kathitavAn, he prabho tavaikayA mudrayA paJcamudrA labdhAH| ");
INSERT INTO sanhk_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","tataH sa uvAca, tvaM paJcAnAM nagarANAmadhipati rbhava| ");
INSERT INTO sanhk_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","tatonya Agatya kathayAmAsa, he prabho pazya tava yA mudrA ahaM vastre baddhvAsthApayaM seyaM| ");
INSERT INTO sanhk_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","tvaM kRpaNo yannAsthApayastadapi gRhlAsi, yannAvapastadeva ca chinatsi tatohaM tvatto bhItaH| ");
INSERT INTO sanhk_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","tadA sa jagAda, re duSTadAsa tava vAkyena tvAM doSiNaM kariSyAmi, yadahaM nAsthApayaM tadeva gRhlAmi, yadahaM nAvapaJca tadeva chinadmi, etAdRzaH kRpaNohamiti yadi tvaM jAnAsi, ");
INSERT INTO sanhk_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","tarhi mama mudrA baNijAM nikaTe kuto nAsthApayaH? tayA kRte'ham Agatya kusIdena sArddhaM nijamudrA aprApsyam| ");
INSERT INTO sanhk_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","pazcAt sa samIpasthAn janAn AjJApayat asmAt mudrA AnIya yasya dazamudrAH santi tasmai datta| ");
INSERT INTO sanhk_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","te procuH prabho'sya dazamudrAH santi| ");
INSERT INTO sanhk_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","yuSmAnahaM vadAmi yasyAzraye vaddhate 'dhikaM tasmai dAyiSyate, kintu yasyAzraye na varddhate tasya yadyadasti tadapi tasmAn nAyiSyate| ");
INSERT INTO sanhk_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","kintu mamAdhipatitvasya vazatve sthAtum asammanyamAnA ye mama ripavastAnAnIya mama samakSaM saMharata| ");
INSERT INTO sanhk_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ityupadezakathAM kathayitvA sogragaH san yirUzAlamapuraM yayau| ");
INSERT INTO sanhk_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","tato baitphagIbaithanIyAgrAmayoH samIpe jaitunAdrerantikam itvA ziSyadvayam ityuktvA preSayAmAsa, ");
INSERT INTO sanhk_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","yuvAmamuM sammukhasthagrAmaM pravizyaiva yaM kopi mAnuSaH kadApi nArohat taM garddabhazAvakaM baddhaM drakSyathastaM mocayitvAnayataM| ");
INSERT INTO sanhk_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","tatra kuto mocayathaH? iti cet kopi vakSyati tarhi vakSyathaH prabheाratra prayojanam Aste| ");
INSERT INTO sanhk_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","tadA tau praritau gatvA tatkathAाnusAreNa sarvvaM prAptau| ");
INSERT INTO sanhk_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","gardabhazAvakamocanakAle tatvAmina UcuH, gardabhazAvakaM kuto mocayathaH? ");
INSERT INTO sanhk_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","tAvUcatuH prabhoratra prayojanam Aste| ");
INSERT INTO sanhk_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","pazcAt tau taM gardabhazAvakaM yIzorantikamAnIya tatpRSThe nijavasanAni pAtayitvA tadupari yIzumArohayAmAsatuH| ");
INSERT INTO sanhk_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","atha yAtrAkAle lokAH pathi svavastrANi pAtayitum Arebhire| ");
INSERT INTO sanhk_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","aparaM jaitunAdrerupatyakAm itvA ziSyasaMghaH pUrvvadRSTAni mahAkarmmANi smRtvA, ");
INSERT INTO sanhk_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","yo rAjA prabho rnAmnAyAti sa dhanyaH svarge kuzalaM sarvvocce jayadhvani rbhavatu, kathAmetAM kathayitvA sAnandam ucairIzvaraM dhanyaM vaktumArebhe| ");
INSERT INTO sanhk_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","tadA lokAraNyamadhyasthAH kiyantaH phirUzinastat zrutvA yIzuM procuH, he upadezaka svaziSyAn tarjaya| ");
INSERT INTO sanhk_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","sa uvAca, yuSmAnahaM vadAmi yadyamI nIravAstiSThanti tarhi pASANA ucaiH kathAH kathayiSyanti| ");
INSERT INTO sanhk_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","pazcAt tatpurAntikametya tadavalokya sAzrupAtaM jagAda, ");
INSERT INTO sanhk_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","hA hA cet tvamagre'jJAsyathAH, tavAsminneva dine vA yadi svamaGgalam upAlapsyathAH, tarhyuttamam abhaviSyat, kintu kSaNesmin tattava dRSTeragocaram bhavati| ");
INSERT INTO sanhk_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","tvaM svatrANakAle na mano nyadhatthA iti heto ryatkAle tava ripavastvAM caturdikSu prAcIreNa veSTayitvA rotsyanti ");
INSERT INTO sanhk_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","bAlakaiH sArddhaM bhUmisAt kariSyanti ca tvanmadhye pASANaikopi pASANopari na sthAsyati ca, kAla IdRza upasthAsyati| ");
INSERT INTO sanhk_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","atha madhyemandiraM pravizya tatratyAn krayivikrayiNo bahiSkurvvan ");
INSERT INTO sanhk_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","avadat madgRhaM prArthanAgRhamiti lipirAste kintu yUyaM tadeva cairANAM gahvaraM kurutha| ");
INSERT INTO sanhk_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","pazcAt sa pratyahaM madhyemandiram upadideza; tataH pradhAnayAjakA adhyApakAH prAcInAzca taM nAzayituM ciceSTire; ");
INSERT INTO sanhk_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","kintu tadupadeze sarvve lokA niviSTacittAH sthitAstasmAt te tatkarttuM nAvakAzaM prApuH| ");
INSERT INTO sanhk_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","athaikadA yIzu rmanidare susaMvAdaM pracArayan lokAnupadizati, etarhi pradhAnayAjakA adhyApakAH prAJcazca tannikaTamAgatya papracchuH ");
INSERT INTO sanhk_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","kayAjJayA tvaM karmmANyetAni karoSi? ko vA tvAmAjJApayat? tadasmAn vada| ");
INSERT INTO sanhk_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","sa pratyuvAca, tarhi yuSmAnapi kathAmekAM pRcchAmi tasyottaraM vadata| ");
INSERT INTO sanhk_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","yohano majjanam Izvarasya mAnuSANAM vAjJAto jAtaM? ");
INSERT INTO sanhk_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","tataste mitho vivicya jagaduH, yadIzvarasya vadAmastarhi taM kuto na pratyaita sa iti vakSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","yadi manuSyasyeti vadAmastarhi sarvve lokA asmAn pASANai rhaniSyanti yato yohan bhaviSyadvAdIti sarvve dRDhaM jAnanti| ");
INSERT INTO sanhk_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ataeva te pratyUcuH kasyAjJayA jAtam iti vaktuM na zaknumaH| ");
INSERT INTO sanhk_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","tadA yIzuravadat tarhi kayAjJayA karmmANyetAti karomIti ca yuSmAn na vakSyAmi| ");
INSERT INTO sanhk_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","atha lokAnAM sAkSAt sa imAM dRSTAntakathAM vaktumArebhe, kazcid drAkSAkSetraM kRtvA tat kSetraM kRSIvalAnAM hasteSu samarpya bahukAlArthaM dUradezaM jagAma| ");
INSERT INTO sanhk_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","atha phalakAle phalAni grahItu kRSIvalAnAM samIpe dAsaM prAhiNot kintu kRSIvalAstaM prahRtya riktahastaM visasarjuH| ");
INSERT INTO sanhk_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","tataH sodhipatiH punaranyaM dAsaM preSayAmAsa, te tamapi prahRtya kuvyavahRtya riktahastaM visasRjuH| ");
INSERT INTO sanhk_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","tataH sa tRtIyavAram anyaM prAhiNot te tamapi kSatAGgaM kRtvA bahi rnicikSipuH| ");
INSERT INTO sanhk_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","tadA kSetrapati rvicArayAmAsa, mamedAnIM kiM karttavyaM? mama priye putre prahite te tamavazyaM dRSTvA samAdariSyante| ");
INSERT INTO sanhk_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","kintu kRSIvalAstaM nirIkSya parasparaM vivicya procuH, ayamuttarAdhikArI AgacchatainaM hanmastatodhikArosmAkaM bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","tataste taM kSetrAd bahi rnipAtya jaghnustasmAt sa kSetrapatistAn prati kiM kariSyati? ");
INSERT INTO sanhk_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","sa Agatya tAn kRSIvalAn hatvA pareSAM hasteSu tatkSetraM samarpayiSyati; iti kathAM zrutvA te 'vadan etAdRzI ghaTanA na bhavatu| ");
INSERT INTO sanhk_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","kintu yIzustAnavalokya jagAda, tarhi, sthapatayaH kariSyanti grAvANaM yantu tucchakaM| pradhAnaprastaraH koNe sa eva hi bhaviSyati| etasya zAstrIyavacanasya kiM tAtparyyaM? ");
INSERT INTO sanhk_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","aparaM tatpASANopari yaH patiSyati sa bhaMkSyate kintu yasyopari sa pASANaH patiSyati sa tena dhUlivac cUrNIbhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","sosmAkaM viruddhaM dRSTAntamimaM kathitavAn iti jJAtvA pradhAnayAjakA adhyApakAzca tadaiva taM dhartuM vavAJchuH kintu lokebhyo bibhyuH| ");
INSERT INTO sanhk_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ataeva taM prati satarkAH santaH kathaM tadvAkyadoSaM dhRtvA taM dezAdhipasya sAdhuvezadhAriNazcarAn tasya samIpe preSayAmAsuH| ");
INSERT INTO sanhk_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","tadA te taM papracchuH, he upadezaka bhavAn yathArthaM kathayan upadizati, kamapyanapekSya satyatvenaizvaraM mArgamupadizati, vayametajjAnImaH| ");
INSERT INTO sanhk_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","kaisararAjAya karosmAbhi rdeyo na vA? ");
INSERT INTO sanhk_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","sa teSAM vaJcanaM jJAtvAvadat kuto mAM parIkSadhve? mAM mudrAmekaM darzayata| ");
INSERT INTO sanhk_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","iha likhitA mUrtiriyaM nAma ca kasya? te'vadan kaisarasya| ");
INSERT INTO sanhk_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","tadA sa uvAca, tarhi kaisarasya dravyaM kaisarAya datta; Izvarasya tu dravyamIzvarAya datta| ");
INSERT INTO sanhk_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","tasmAllokAnAM sAkSAt tatkathAyAH kamapi doSaM dhartumaprApya te tasyottarAd AzcaryyaM manyamAnA mauninastasthuH| ");
INSERT INTO sanhk_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","aparaJca zmazAnAdutthAnAnaGgIkAriNAM sidUkinAM kiyanto janA Agatya taM papracchuH, ");
INSERT INTO sanhk_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","he upadezaka zAstre mUsA asmAn pratIti lilekha yasya bhrAtA bhAryyAyAM satyAM niHsantAno mriyate sa tajjAyAM vivahya tadvaMzam utpAdayiSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","tathAca kecit sapta bhrAtara Asan teSAM jyeSTho bhrAtA vivahya nirapatyaH prANAn jahau| ");
INSERT INTO sanhk_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","atha dvitIyastasya jAyAM vivahya nirapatyaH san mamAra| tRtIyazca tAmeva vyuvAha; ");
INSERT INTO sanhk_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","itthaM sapta bhrAtarastAmeva vivahya nirapatyAH santo mamruH| ");
INSERT INTO sanhk_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","zeSe sA strI ca mamAra| ");
INSERT INTO sanhk_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ataeva zmazAnAdutthAnakAle teSAM saptajanAnAM kasya sA bhAryyA bhaviSyati? yataH sA teSAM saptAnAmeva bhAryyAsIt| ");
INSERT INTO sanhk_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","tadA yIzuH pratyuvAca, etasya jagato lokA vivahanti vAgdattAzca bhavanti ");
INSERT INTO sanhk_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","kintu ye tajjagatprAptiyogyatvena gaNitAM bhaviSyanti zmazAnAccotthAsyanti te na vivahanti vAgdattAzca na bhavanti, ");
INSERT INTO sanhk_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","te puna rna mriyante kintu zmazAnAdutthApitAH santa Izvarasya santAnAH svargIyadUtAnAM sadRzAzca bhavanti| ");
INSERT INTO sanhk_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","adhikantu mUsAH stambopAkhyAne paramezvara IbrAhIma Izvara ishAka Izvaro yAkUbazcezvara ityuktvA mRtAnAM zmazAnAd utthAnasya pramANaM lilekha| ");
INSERT INTO sanhk_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ataeva ya IzvaraH sa mRtAnAM prabhu rna kintu jIvatAmeva prabhuH, tannikaTe sarvve jIvantaH santi| ");
INSERT INTO sanhk_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","iti zrutvA kiyantodhyApakA UcuH, he upadezaka bhavAn bhadraM pratyuktavAn| ");
INSERT INTO sanhk_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","itaH paraM taM kimapi praSTaM teSAM pragalbhatA nAbhUt| ");
INSERT INTO sanhk_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","pazcAt sa tAn uvAca, yaH khrISTaH sa dAyUdaH santAna etAM kathAM lokAH kathaM kathayanti? ");
INSERT INTO sanhk_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","yataH mama prabhumidaM vAkyamavadat paramezvaraH| tava zatrUnahaM yAvat pAdapIThaM karomi na| tAvat kAlaM madIye tvaM dakSapArzva upAviza| ");
INSERT INTO sanhk_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","iti kathAM dAyUd svayaM gItagranthe'vadat| ");
INSERT INTO sanhk_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","ataeva yadi dAyUd taM prabhuM vadati, tarhi sa kathaM tasya santAno bhavati? ");
INSERT INTO sanhk_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","pazcAd yIzuH sarvvajanAnAM karNagocare ziSyAnuvAca, ");
INSERT INTO sanhk_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","ye'dhyApakA dIrghaparicchadaM paridhAya bhramanti, haTTApaNayo rnamaskAre bhajanagehasya proccAsane bhojanagRhasya pradhAnasthAne ca prIyante ");
INSERT INTO sanhk_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","vidhavAnAM sarvvasvaM grasitvA chalena dIrghakAlaM prArthayante ca teSu sAvadhAnA bhavata, teSAmugradaNDo bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","atha dhanilokA bhANDAgAre dhanaM nikSipanti sa tadeva pazyati, ");
INSERT INTO sanhk_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","etarhi kAciddInA vidhavA paNadvayaM nikSipati tad dadarza| ");
INSERT INTO sanhk_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","tato yIzuruvAca yuSmAnahaM yathArthaM vadAmi, daridreyaM vidhavA sarvvebhyodhikaM nyakSepsIt, ");
INSERT INTO sanhk_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","yatonye svaprAjyadhanebhya IzvarAya kiJcit nyakSepsuH, kintu daridreyaM vidhavA dinayApanArthaM svasya yat kiJcit sthitaM tat sarvvaM nyakSepsIt| ");
INSERT INTO sanhk_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","aparaJca uttamaprastarairutsRSTavyaizca mandiraM suzobhatetarAM kaizcidityukte sa pratyuvAca ");
INSERT INTO sanhk_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","yUyaM yadidaM nicayanaM pazyatha, asya pASANaikopyanyapASANopari na sthAsyati, sarvve bhUsAdbhaviSyanti kAloyamAyAti| ");
INSERT INTO sanhk_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","tadA te papracchuH, he guro ghaTanedRzI kadA bhaviSyati? ghaTanAyA etasyasazcihnaM vA kiM bhaviSyati? ");
INSERT INTO sanhk_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","tadA sa jagAda, sAvadhAnA bhavata yathA yuSmAkaM bhramaM kopi na janayati, khISTohamityuktvA mama nAmrA bahava upasthAsyanti sa kAlaH prAyeNopasthitaH, teSAM pazcAnmA gacchata| ");
INSERT INTO sanhk_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","yuddhasyopaplavasya ca vArttAM zrutvA mA zaGkadhvaM, yataH prathamam etA ghaTanA avazyaM bhaviSyanti kintu nApAte yugAnto bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","aparaJca kathayAmAsa, tadA dezasya vipakSatvena dezo rAjyasya vipakSatvena rAjyam utthAsyati, ");
INSERT INTO sanhk_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","nAnAsthAneSu mahAbhUkampo durbhikSaM mArI ca bhaviSyanti, tathA vyomamaNDalasya bhayaGkaradarzanAnyazcaryyalakSaNAni ca prakAzayiSyante| ");
INSERT INTO sanhk_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","kintu sarvvAsAmetAsAM ghaTanAnAM pUrvvaM lokA yuSmAn dhRtvA tADayiSyanti, bhajanAlaye kArAyAJca samarpayiSyanti mama nAmakAraNAd yuSmAn bhUpAnAM zAsakAnAJca sammukhaM neSyanti ca| ");
INSERT INTO sanhk_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","sAkSyArtham etAni yuSmAn prati ghaTiSyante| ");
INSERT INTO sanhk_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","tadA kimuttaraM vaktavyam etat na cintayiSyAma iti manaHsu nizcitanuta| ");
INSERT INTO sanhk_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","vipakSA yasmAt kimapyuttaram ApattiJca karttuM na zakSyanti tAdRzaM vAkpaTutvaM jJAnaJca yuSmabhyaM dAsyAmi| ");
INSERT INTO sanhk_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","kiJca yUyaM pitrA mAtrA bhrAtrA bandhunA jJAtyA kuTumbena ca parakareSu samarpayiSyadhve; tataste yuSmAkaM kaJcana kaJcana ghAtayiSyanti| ");
INSERT INTO sanhk_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","mama nAmnaH kAraNAt sarvvai rmanuSyai ryUyam RtIyiSyadhve| ");
INSERT INTO sanhk_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","kintu yuSmAkaM ziraHkezaikopi na vinaMkSyati, ");
INSERT INTO sanhk_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","tasmAdeva dhairyyamavalambya svasvaprANAn rakSata| ");
INSERT INTO sanhk_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","aparaJca yirUzAlampuraM sainyaveSTitaM vilokya tasyocchinnatAyAH samayaH samIpa ityavagamiSyatha| ");
INSERT INTO sanhk_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","tadA yihUdAdezasthA lokAH parvvataM palAyantAM, ye ca nagare tiSThanti te dezAntaraM palAyantA, ye ca grAme tiSThanti te nagaraM na pravizantu, ");
INSERT INTO sanhk_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","yatastadA samucitadaNDanAya dharmmapustake yAni sarvvANi likhitAni tAni saphalAni bhaviSyanti| ");
INSERT INTO sanhk_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","kintu yA yAstadA garbhavatyaH stanyadAvyazca tAmAM durgati rbhaviSyati, yata etAllokAn prati kopo deze ca viSamadurgati rghaTiSyate| ");
INSERT INTO sanhk_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","vastutastu te khaGgadhAraparivvaGgaM lapsyante baddhAH santaH sarvvadezeSu nAyiSyante ca kiJcAnyadezIyAnAM samayopasthitiparyyantaM yirUzAlampuraM taiH padatalai rdalayiSyate| ");
INSERT INTO sanhk_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","sUryyacandranakSatreSu lakSaNAdi bhaviSyanti, bhuvi sarvvadezIyAnAM duHkhaM cintA ca sindhau vIcInAM tarjanaM garjanaJca bhaviSyanti| ");
INSERT INTO sanhk_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","bhUbhau bhAvighaTanAM cintayitvA manujA bhiyAmRtakalpA bhaviSyanti, yato vyomamaNDale tejasvino dolAyamAnA bhaviSyanti| ");
INSERT INTO sanhk_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","tadA parAkrameNA mahAtejasA ca meghArUDhaM manuSyaputram AyAntaM drakSyanti| ");
INSERT INTO sanhk_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","kintvetAsAM ghaTanAnAmArambhe sati yUyaM mastakAnyuttolya UrdadhvaM drakSyatha, yato yuSmAkaM mukteH kAlaH savidho bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","tatastenaitadRSTAntakathA kathitA, pazyata uDumbarAdivRkSANAM ");
INSERT INTO sanhk_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","navInapatrANi jAtAnIti dRSTvA nidAvakAla upasthita iti yathA yUyaM jJAtuM zaknutha, ");
INSERT INTO sanhk_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","tathA sarvvAsAmAsAM ghaTanAnAm Arambhe dRSTe satIzvarasya rAjatvaM nikaTam ityapi jJAsyatha| ");
INSERT INTO sanhk_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","yuSmAnahaM yathArthaM vadAmi, vidyamAnalokAnAmeSAM gamanAt pUrvvam etAni ghaTiSyante| ");
INSERT INTO sanhk_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","nabhobhuvorlopo bhaviSyati mama vAk tu kadApi luptA na bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","ataeva viSamAzanena pAnena ca sAMmArikacintAbhizca yuSmAkaM citteSu matteSu taddinam akasmAd yuSmAn prati yathA nopatiSThati tadarthaM sveSu sAvadhAnAstiSThata| ");
INSERT INTO sanhk_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","pRthivIsthasarvvalokAn prati taddinam unmAtha iva upasthAsyati| ");
INSERT INTO sanhk_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","yathA yUyam etadbhAvighaTanA uttarttuM manujasutasya sammukhe saMsthAtuJca yogyA bhavatha kAraNAdasmAt sAvadhAnAH santo nirantaraM prArthayadhvaM| ");
INSERT INTO sanhk_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","aparaJca sa divA mandira upadizya rAcai jaitunAdriM gatvAtiSThat| ");
INSERT INTO sanhk_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","tataH pratyUSe lAkAstatkathAM zrotuM mandire tadantikam Agacchan| ");
INSERT INTO sanhk_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","aparaJca kiNvazUnyapUpotsavasya kAla upasthite ");
INSERT INTO sanhk_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","pradhAnayAjakA adhyAyakAzca yathA taM hantuM zaknuvanti tathopAyAm aceSTanta kintu lokebhyo bibhyuH| ");
INSERT INTO sanhk_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","etastin samaye dvAdazaziSyeSu gaNita ISkariyotIyarUDhimAn yo yihUdAstasyAntaHkaraNaM zaitAnAzritatvAt ");
INSERT INTO sanhk_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","sa gatvA yathA yIzuM teSAM kareSu samarpayituM zaknoti tathA mantraNAM pradhAnayAjakaiH senApatibhizca saha cakAra| ");
INSERT INTO sanhk_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","tena te tuSTAstasmai mudrAM dAtuM paNaM cakruH| ");
INSERT INTO sanhk_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","tataH soGgIkRtya yathA lokAnAmagocare taM parakareSu samarpayituM zaknoti tathAvakAzaM ceSTitumArebhe| ");
INSERT INTO sanhk_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","atha kiNvazUnyapUpotmavadine, arthAt yasmin dine nistArotsavasya meSo hantavyastasmin dine ");
INSERT INTO sanhk_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","yIzuH pitaraM yohanaJcAhUya jagAda, yuvAM gatvAsmAkaM bhojanArthaM nistArotsavasya dravyANyAsAdayataM| ");
INSERT INTO sanhk_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","tadA tau papracchatuH kucAsAdayAvo bhavataH kecchA? ");
INSERT INTO sanhk_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","tadA sovAdIt, nagare praviSTe kazcijjalakumbhamAdAya yuvAM sAkSAt kariSyati sa yannivezanaM pravizati yuvAmapi tannivezanaM tatpazcAditvA nivezanapatim iti vAkyaM vadataM, ");
INSERT INTO sanhk_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","yatrAhaM nistArotsavasya bhojyaM ziSyaiH sArddhaM bhoktuM zaknomi sAtithizAlAा kutra? kathAmimAM prabhustvAM pRcchati| ");
INSERT INTO sanhk_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","tataH sa jano dvitIyaprakoSThIyam ekaM zastaM koSThaM darzayiSyati tatra bhojyamAsAdayataM| ");
INSERT INTO sanhk_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","tatastau gatvA tadvAkyAnusAreNa sarvvaM dRSdvA tatra nistArotsavIyaM bhojyamAsAdayAmAsatuH| ");
INSERT INTO sanhk_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","atha kAla upasthite yIzu rdvAdazabhiH preritaiH saha bhoktumupavizya kathitavAn ");
INSERT INTO sanhk_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","mama duHkhabhogAt pUrvvaM yubhAbhiH saha nistArotsavasyaitasya bhojyaM bhoktuM mayAtivAJchA kRtA| ");
INSERT INTO sanhk_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","yuSmAn vadAmi, yAvatkAlam IzvararAjye bhojanaM na kariSye tAvatkAlam idaM na bhokSye| ");
INSERT INTO sanhk_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","tadA sa pAnapAtramAdAya Izvarasya guNAn kIrttayitvA tebhyo datvAvadat, idaM gRhlIta yUyaM vibhajya pivata| ");
INSERT INTO sanhk_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","yuSmAn vadAmi yAvatkAlam IzvararAjatvasya saMsthApanaM na bhavati tAvad drAkSAphalarasaM na pAsyAmi| ");
INSERT INTO sanhk_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","tataH pUpaM gRhItvA IzvaraguNAn kIrttayitvA bhaGktA tebhyo datvAvadat, yuSmadarthaM samarpitaM yanmama vapustadidaM, etat karmma mama smaraNArthaM kurudhvaM| ");
INSERT INTO sanhk_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","atha bhojanAnte tAdRzaM pAtraM gRhItvAvadat, yuSmatkRte pAtitaM yanmama raktaM tena nirNItanavaniyamarUpaM pAnapAtramidaM| ");
INSERT INTO sanhk_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","pazyata yo mAM parakareSu samarpayiSyati sa mayA saha bhojanAsana upavizati| ");
INSERT INTO sanhk_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","yathA nirUpitamAste tadanusAreNA manuSyapuुtrasya gati rbhaviSyati kintu yastaM parakareSu samarpayiSyati tasya santApo bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","tadA teSAM ko jana etat karmma kariSyati tat te parasparaM praSTumArebhire| ");
INSERT INTO sanhk_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","aparaM teSAM ko janaH zreSThatvena gaNayiSyate, atrArthe teSAM vivAdobhavat| ");
INSERT INTO sanhk_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","asmAt kAraNAt sovadat, anyadezIyAnAM rAjAnaH prajAnAmupari prabhutvaM kurvvanti dAruNazAsanaM kRtvApi te bhUpatitvena vikhyAtA bhavanti ca| ");
INSERT INTO sanhk_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","kintu yuSmAkaM tathA na bhaviSyati, yo yuSmAkaM zreSTho bhaviSyati sa kaniSThavad bhavatu, yazca mukhyo bhaviSyati sa sevakavadbhavatu| ");
INSERT INTO sanhk_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","bhojanopaviSTaparicArakayoH kaH zreSThaH? yo bhojanAyopavizati sa kiM zreSTho na bhavati? kintu yuSmAkaM madhye'haM paricAraka_ivAsmi| ");
INSERT INTO sanhk_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","aparaJca yuyaM mama parIkSAkAle prathamamArabhya mayA saha sthitA ");
INSERT INTO sanhk_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","etatkAraNAt pitrA yathA madarthaM rAjyamekaM nirUpitaM tathAhamapi yuSmadarthaM rAjyaM nirUpayAmi| ");
INSERT INTO sanhk_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","tasmAn mama rAjye bhojanAsane ca bhojanapAne kariSyadhve siMhAsaneSUpavizya cesrAyelIyAnAM dvAdazavaMzAnAM vicAraM kariSyadhve| ");
INSERT INTO sanhk_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","aparaM prabhuruvAca, he zimon pazya tita_unA dhAnyAnIva yuSmAn zaitAn cAlayitum aicchat, ");
INSERT INTO sanhk_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","kintu tava vizvAsasya lopo yathA na bhavati etat tvadarthaM prArthitaM mayA, tvanmanasi parivarttite ca bhrAtRNAM manAMsi sthirIkuru| ");
INSERT INTO sanhk_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","tadA sovadat, he prabhohaM tvayA sArddhaM kArAM mRtiJca yAtuM majjitosmi| ");
INSERT INTO sanhk_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","tataH sa uvAca, he pitara tvAM vadAmi, adya kukkuTaravAt pUrvvaM tvaM matparicayaM vAratrayam apahvoSyase| ");
INSERT INTO sanhk_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","aparaM sa papraccha, yadA mudrAsampuTaM khAdyapAtraM pAdukAJca vinA yuSmAn prAhiNavaM tadA yuSmAkaM kasyApi nyUnatAsIt? te procuH kasyApi na| ");
INSERT INTO sanhk_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","tadA sovadat kintvidAnIM mudrAsampuTaM khAdyapAtraM vA yasyAsti tena tadgrahItavyaM, yasya ca kRpANoे nAsti tena svavastraM vikrIya sa kretavyaH| ");
INSERT INTO sanhk_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","yato yuSmAnahaM vadAmi, aparAdhijanaiH sArddhaM gaNitaH sa bhaviSyati| idaM yacchAstrIyaM vacanaM likhitamasti tanmayi phaliSyati yato mama sambandhIyaM sarvvaM setsyati| ");
INSERT INTO sanhk_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","tadA te procuH prabho pazya imau kRpANau| tataH sovadad etau yatheSTau| ");
INSERT INTO sanhk_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","atha sa tasmAdvahi rgatvA svAcArAnusAreNa jaitunanAmAdriM jagAma ziSyAzca tatpazcAd yayuH| ");
INSERT INTO sanhk_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","tatropasthAya sa tAnuvAca, yathA parIkSAyAM na patatha tadarthaM prArthayadhvaM| ");
INSERT INTO sanhk_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","pazcAt sa tasmAd ekazarakSepAd bahi rgatvA jAnunI pAtayitvA etat prArthayAJcakre, ");
INSERT INTO sanhk_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","he pita ryadi bhavAn sammanyate tarhi kaMsamenaM mamAntikAd dUraya kintu madicchAnurUpaM na tvadicchAnurUpaM bhavatu| ");
INSERT INTO sanhk_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","tadA tasmai zaktiM dAtuM svargIyadUto darzanaM dadau| ");
INSERT INTO sanhk_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","pazcAt sotyantaM yAtanayA vyAkulo bhUtvA punardRDhaM prArthayAJcakre, tasmAd bRhacchoNitabindava iva tasya svedabindavaH pRthivyAM patitumArebhire| ");
INSERT INTO sanhk_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","atha prArthanAta utthAya ziSyANAM samIpametya tAn manoduHkhino nidritAn dRSTvAvadat ");
INSERT INTO sanhk_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","kuto nidrAtha? parIkSAyAm apatanArthaM prarthayadhvaM| ");
INSERT INTO sanhk_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","etatkathAyAH kathanakAle dvAdazaziSyANAM madhye gaNito yihUdAnAmA janatAsahitasteSAm agre calitvA yIzozcumbanArthaM tadantikam Ayayau| ");
INSERT INTO sanhk_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","tadA yIzuruvAca, he yihUdA kiM cumbanena manuSyaputraM parakareSu samarpayasi? ");
INSERT INTO sanhk_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","tadA yadyad ghaTiSyate tadanumAya saGgibhiruktaM, he prabho vayaM ki khaGgena ghAtayiSyAmaH? ");
INSERT INTO sanhk_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","tata ekaH karavAlenAhatya pradhAnayAjakasya dAsasya dakSiNaM karNaM ciccheda| ");
INSERT INTO sanhk_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","adhUnA nivarttasva ityuktvA yIzustasya zrutiM spRSTvA svasyaM cakAra| ");
INSERT INTO sanhk_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","pazcAd yIzuH samIpasthAn pradhAnayAjakAn mandirasya senApatIn prAcInAMzca jagAda, yUyaM kRpANAn yaSTIMzca gRhItvA mAM kiM coraM dharttumAyAtAH? ");
INSERT INTO sanhk_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","yadAhaM yuSmAbhiH saha pratidinaM mandire'tiSThaM tadA mAM dharttaM na pravRttAH, kintvidAnIM yuSmAkaM samayondhakArasya cAdhipatyamasti| ");
INSERT INTO sanhk_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","atha te taM dhRtvA mahAyAjakasya nivezanaM ninyuH| tataH pitaro dUre dUre pazcAditvA ");
INSERT INTO sanhk_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","bRhatkoSThasya madhye yatrAgniM jvAlayitvA lokAH sametyopaviSTAstatra taiH sArddham upaviveza| ");
INSERT INTO sanhk_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","atha vahnisannidhau samupavezakAle kAciddAsI mano nivizya taM nirIkSyAvadat pumAnayaM tasya saGge'sthAt| ");
INSERT INTO sanhk_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","kintu sa tad apahnutyAvAdIt he nAri tamahaM na paricinomi| ");
INSERT INTO sanhk_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","kSaNAntare'nyajanastaM dRSTvAbravIt tvamapi teSAM nikarasyaikajanosi| pitaraH pratyuvAca he nara nAhamasmi| ");
INSERT INTO sanhk_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","tataH sArddhadaNDadvayAt paraM punaranyo jano nizcitya babhASe, eSa tasya saGgIti satyaM yatoyaM gAlIlIyo lokaH| ");
INSERT INTO sanhk_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","tadA pitara uvAca he nara tvaM yad vadami tadahaM boddhuM na zaknomi, iti vAkye kathitamAtre kukkuTo rurAva| ");
INSERT INTO sanhk_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","tadA prabhuNA vyAdhuTya pitare nirIkSite kRkavAkuravAt pUrvvaM mAM trirapahnoSyase iti pUrvvoktaM tasya vAkyaM pitaraH smRtvA ");
INSERT INTO sanhk_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","bahirgatvA mahAkhedena cakranda| ");
INSERT INTO sanhk_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","tadA yai ryIzurdhRtaste tamupahasya praharttumArebhire| ");
INSERT INTO sanhk_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","vastreNa tasya dRzau baddhvA kapole capeTAghAtaM kRtvA papracchuH, kaste kapole capeTAghAtaM kRtavAna? gaNayitvA tad vada| ");
INSERT INTO sanhk_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","tadanyat tadviruddhaM bahunindAvAkyaM vaktumArebhire| ");
INSERT INTO sanhk_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","atha prabhAte sati lokaprAJcaH pradhAnayAjakA adhyApakAzca sabhAM kRtvA madhyesabhaM yIzumAnIya papracchuH, tvam abhiSikatosi na vAsmAn vada| ");
INSERT INTO sanhk_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","sa pratyuvAca, mayA tasminnukte'pi yUyaM na vizvasiSyatha| ");
INSERT INTO sanhk_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","kasmiMzcidvAkye yuSmAn pRSTe'pi mAM na taduttaraM vakSyatha na mAM tyakSyatha ca| ");
INSERT INTO sanhk_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","kintvitaH paraM manujasutaH sarvvazaktimata Izvarasya dakSiNe pArzve samupavekSyati| ");
INSERT INTO sanhk_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","tataste papracchuH, rtiha tvamIzvarasya putraH? sa kathayAmAsa, yUyaM yathArthaM vadatha sa evAhaM| ");
INSERT INTO sanhk_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","tadA te sarvve kathayAmAsuH, rtiha sAkSye'nsasmin asmAkaM kiM prayojanaM? asya svamukhAdeva sAkSyaM prAptam| ");
INSERT INTO sanhk_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","tataH sabhAsthAH sarvvalokA utthAya taM pIlAtasammukhaM nItvAprodya vaktumArebhire, ");
INSERT INTO sanhk_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","svamabhiSiktaM rAjAnaM vadantaM kaimararAjAya karadAnaM niSedhantaM rAjyaviparyyayaM kurttuM pravarttamAnam ena prAptA vayaM| ");
INSERT INTO sanhk_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","tadA pIlAtastaM pRSTavAn tvaM kiM yihUdIyAnAM rAjA? sa pratyuvAca tvaM satyamuktavAn| ");
INSERT INTO sanhk_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","tadA pIlAtaH pradhAnayAjakAdilokAn jagAd, ahametasya kamapyaparAdhaM nAptavAn| ");
INSERT INTO sanhk_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","tataste punaH sAhamino bhUtvAvadan, eSa gAlIla etatsthAnaparyyante sarvvasmin yihUdAdeze sarvvAllokAnupadizya kupravRttiM grAhItavAn| ");
INSERT INTO sanhk_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","tadA pIlAto gAlIlapradezasya nAma zrutvA papraccha, kimayaM gAlIlIyo lokaH? ");
INSERT INTO sanhk_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","tataH sa gAlIlpradezIyaherodrAjasya tadA sthitestasya samIpe yIzuM preSayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","tadA herod yIzuM vilokya santutoSa, yataH sa tasya bahuvRttAntazravaNAt tasya kiJi्cadAzcaryyakarmma pazyati ityAzAM kRtvA bahukAlamArabhya taM draSTuM prayAsaM kRtavAn| ");
INSERT INTO sanhk_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","tasmAt taM bahukathAH papraccha kintu sa tasya kasyApi vAkyasya pratyuttaraM novAca| ");
INSERT INTO sanhk_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","atha pradhAnayAjakA adhyApakAzca prottiSThantaH sAhasena tamapavadituM prArebhire| ");
INSERT INTO sanhk_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","herod tasya senAgaNazca tamavajJAya upahAsatvena rAjavastraM paridhApya punaH pIlAtaM prati taM prAhiNot| ");
INSERT INTO sanhk_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","pUrvvaM herodpIlAtayoH parasparaM vairabhAva AsIt kintu taddine dvayo rmelanaM jAtam| ");
INSERT INTO sanhk_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","pazcAt pIlAtaH pradhAnayAjakAn zAsakAn lokAMzca yugapadAhUya babhASe, ");
INSERT INTO sanhk_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","rAjyaviparyyayakArakoyam ityuktvA manuSyamenaM mama nikaTamAnaiSTa kintu pazyata yuSmAkaM samakSam asya vicAraM kRtvApi proktApavAdAnurUpeNAsya kopyaparAdhaH sapramANo na jAtaH, ");
INSERT INTO sanhk_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","yUyaJca herodaH sannidhau preSitA mayA tatrAsya kopyaparAdhastenApi na prAptaH|pazyatAnena vadhaheेtukaM kimapi nAparAddhaM| ");
INSERT INTO sanhk_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","tasmAdenaM tADayitvA vihAsyAmi| ");
INSERT INTO sanhk_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","tatrotsave teSAmeko mocayitavyaH| ");
INSERT INTO sanhk_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","iti hetoste proccairekadA procuH, enaM dUrIkRtya barabbAnAmAnaM mocaya| ");
INSERT INTO sanhk_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","sa barabbA nagara upaplavavadhAparAdhAbhyAM kArAyAM baddha AsIt| ");
INSERT INTO sanhk_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","kintu pIlAto yIzuM mocayituM vAJchan punastAnuvAca| ");
INSERT INTO sanhk_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","tathApyenaM kruze vyadha kruze vyadheti vadantaste ruruvuH| ");
INSERT INTO sanhk_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","tataH sa tRtIyavAraM jagAda kutaH? sa kiM karmma kRtavAn? nAhamasya kamapi vadhAparAdhaM prAptaH kevalaM tADayitvAmuM tyajAmi| ");
INSERT INTO sanhk_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","tathApi te punarenaM kruze vyadha ityuktvA proccairdRDhaM prArthayAJcakrire; ");
INSERT INTO sanhk_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","tataH pradhAnayAjakAdInAM kalarave prabale sati teSAM prArthanArUpaM karttuM pIlAta Adideza| ");
INSERT INTO sanhk_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","rAjadrohavadhayoraparAdhena kArAsthaM yaM janaM te yayAcire taM mocayitvA yIzuM teSAmicchAyAM samArpayat| ");
INSERT INTO sanhk_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","atha te yIzuM gRhItvA yAnti, etarhi grAmAdAgataM zimonanAmAnaM kurINIyaM janaM dhRtvA yIzoH pazcAnnetuM tasya skandhe kruzamarpayAmAsuH| ");
INSERT INTO sanhk_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","tato loाkAraNyamadhye bahustriyo rudatyo vilapantyazca yIzoH pazcAd yayuH| ");
INSERT INTO sanhk_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","kintu sa vyAghuTya tA uvAca, he yirUzAlamo nAryyo yuyaM madarthaM na ruditvA svArthaM svApatyArthaJca ruditi; ");
INSERT INTO sanhk_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","pazyata yaH kadApi garbhavatyo nAbhavan stanyaJca nApAyayan tAdRzI rvandhyA yadA dhanyA vakSyanti sa kAla AyAti| ");
INSERT INTO sanhk_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","tadA he zailA asmAkamupari patata, he upazailA asmAnAcchAdayata kathAmIdRzIM lokA vakSyanti| ");
INSERT INTO sanhk_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","yataH satejasi zAkhini cedetad ghaTate tarhi zuSkazAkhini kiM na ghaTiSyate? ");
INSERT INTO sanhk_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","tadA te hantuM dvAvaparAdhinau tena sArddhaM ninyuH| ");
INSERT INTO sanhk_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","aparaM ziraHkapAlanAmakasthAnaM prApya taM kruze vividhuH; taddvayoraparAdhinorekaM tasya dakSiNo tadanyaM vAme kruze vividhuH| ");
INSERT INTO sanhk_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","tadA yIzurakathayat, he pitaretAn kSamasva yata ete yat karmma kurvvanti tan na viduH; pazcAtte guTikApAtaM kRtvA tasya vastrANi vibhajya jagRhuH| ");
INSERT INTO sanhk_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","tatra lokasaMghastiSThan dadarza; te teSAM zAsakAzca tamupahasya jagaduH, eSa itarAn rakSitavAn yadIzvareNAbhirucito 'bhiSiktastrAtA bhavati tarhi svamadhunA rakSatu| ");
INSERT INTO sanhk_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","tadanyaH senAgaNA etya tasmai amlarasaM datvA parihasya provAca, ");
INSERT INTO sanhk_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","cettvaM yihUdIyAnAM rAjAsi tarhi svaM rakSa| ");
INSERT INTO sanhk_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","yihUdIyAnAM rAjeti vAkyaM yUnAnIyaromIyebrIyAkSarai rlikhitaM tacchirasa Urddhve'sthApyata| ");
INSERT INTO sanhk_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","tadobhayapArzvayo rviddhau yAvaparAdhinau tayorekastaM vinindya babhASe, cettvam abhiSiktosi tarhi svamAvAJca rakSa| ");
INSERT INTO sanhk_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","kintvanyastaM tarjayitvAvadat, IzvarAttava kiJcidapi bhayaM nAsti kiM? tvamapi samAnadaNDosi, ");
INSERT INTO sanhk_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","yogyapAtre AvAM svasvakarmmaNAM samucitaphalaM prApnuvaH kintvanena kimapi nAparAddhaM| ");
INSERT INTO sanhk_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","atha sa yIzuM jagAda he prabhe bhavAn svarAjyapravezakAle mAM smaratu| ");
INSERT INTO sanhk_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","tadA yIzuH kathitavAn tvAM yathArthaM vadAmi tvamadyaiva mayA sArddhaM paralokasya sukhasthAnaM prApsyasi| ");
INSERT INTO sanhk_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","aparaJca dvitIyayAmAt tRtIyayAmaparyyantaM ravestejasontarhitatvAt sarvvadezo'ndhakAreNAvRto ");
INSERT INTO sanhk_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","mandirasya yavanikA ca chidyamAnA dvidhA babhUva| ");
INSERT INTO sanhk_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","tato yIzuruccairuvAca, he pita rmamAtmAnaM tava kare samarpaye, ityuktvA sa prANAn jahau| ");
INSERT INTO sanhk_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","tadaitA ghaTanA dRSTvA zatasenApatirIzvaraM dhanyamuktvA kathitavAn ayaM nitAntaM sAdhumanuSya AsIt| ");
INSERT INTO sanhk_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","atha yAvanto lokA draSTum AgatAste tA ghaTanA dRSTvA vakSaHsu karAghAtaM kRtvA vyAcuTya gatAH| ");
INSERT INTO sanhk_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","yIzo rjJAtayo yA yA yoSitazca gAlIlastena sArddhamAyAtAstA api dUre sthitvA tat sarvvaM dadRzuH| ");
INSERT INTO sanhk_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","tadA yihUdIyAnAM mantraNAM kriyAJcAsammanyamAna Izvarasya rAjatvam apekSamANo ");
INSERT INTO sanhk_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","yihUdidezIyo 'rimathIyanagarIyo yUSaphnAmA mantrI bhadro dhArmmikazca pumAn ");
INSERT INTO sanhk_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","pIlAtAntikaM gatvA yIzo rdehaM yayAce| ");
INSERT INTO sanhk_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","pazcAd vapuravarohya vAsasA saMveSTya yatra kopi mAnuSo nAsthApyata tasmin zaile svAte zmazAne tadasthApayat| ");
INSERT INTO sanhk_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","taddinamAyojanIyaM dinaM vizrAmavArazca samIpaH| ");
INSERT INTO sanhk_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","aparaM yIzunA sArddhaM gAlIla AgatA yoSitaH pazcAditvA zmazAne tatra yathA vapuH sthApitaM tacca dRSTvA ");
INSERT INTO sanhk_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","vyAghuTya sugandhidravyatailAni kRtvA vidhivad vizrAmavAre vizrAmaM cakruH| ");
INSERT INTO sanhk_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","atha saptAhaprathamadine'tipratyUSe tA yoSitaH sampAditaM sugandhidravyaM gRhItvA tadanyAbhiH kiyatIbhiH strIbhiH saha zmazAnaM yayuH| ");
INSERT INTO sanhk_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","kintu zmazAnadvArAt pASANamapasAritaM dRSTvA ");
INSERT INTO sanhk_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","tAH pravizya prabho rdehamaprApya ");
INSERT INTO sanhk_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","vyAkulA bhavanti etarhi tejomayavastrAnvitau dvau puruSau tAsAM samIpe samupasthitau ");
INSERT INTO sanhk_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","tasmAttAH zaGkAyuktA bhUmAvadhomukhyasyasthuH| tadA tau tA Ucatu rmRtAnAM madhye jIvantaM kuto mRgayatha? ");
INSERT INTO sanhk_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","sotra nAsti sa udasthAt| ");
INSERT INTO sanhk_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","pApinAM kareSu samarpitena kruze hatena ca manuSyaputreNa tRtIyadivase zmazAnAdutthAtavyam iti kathAM sa galIli tiSThan yuSmabhyaM kathitavAn tAM smarata| ");
INSERT INTO sanhk_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","tadA tasya sA kathA tAsAM manaHsu jAtA| ");
INSERT INTO sanhk_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","anantaraM zmazAnAd gatvA tA ekAdazaziSyAdibhyaH sarvvebhyastAM vArttAM kathayAmAsuH| ");
INSERT INTO sanhk_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","magdalInImariyam, yohanA, yAkUbo mAtA mariyam tadanyAH saGginyo yoSitazca preritebhya etAH sarvvA vArttAH kathayAmAsuH ");
INSERT INTO sanhk_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","kintu tAsAM kathAm anarthakAkhyAnamAtraM buddhvA kopi na pratyait| ");
INSERT INTO sanhk_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","tadA pitara utthAya zmazAnAntikaM dadhAva, tatra ca prahvo bhUtvA pArzvaikasthApitaM kevalaM vastraM dadarza; tasmAdAzcaryyaM manyamAno yadaghaTata tanmanasi vicArayan pratasthe| ");
INSERT INTO sanhk_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","tasminneva dine dvau ziyyau yirUzAlamazcatuSkrozAntaritam immAyugrAmaM gacchantau ");
INSERT INTO sanhk_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","tAsAM ghaTanAnAM kathAmakathayatAM ");
INSERT INTO sanhk_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","tayorAlApavicArayoH kAle yIzurAgatya tAbhyAM saha jagAma ");
INSERT INTO sanhk_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","kintu yathA tau taM na paricinutastadarthaM tayo rdRSTiH saMruddhA| ");
INSERT INTO sanhk_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","sa tau pRSTavAn yuvAM viSaNNau kiM vicArayantau gacchathaH? ");
INSERT INTO sanhk_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","tatastayoH kliyapAnAmA pratyuvAca yirUzAlamapure'dhunA yAnyaghaTanta tvaM kevalavidezI kiM tadvRttAntaM na jAnAsi? ");
INSERT INTO sanhk_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","sa papraccha kA ghaTanAH? tadA tau vaktumArebhAte yIzunAmA yo nAsaratIyo bhaviSyadvAdI Izvarasya mAnuSANAJca sAkSAt vAkye karmmaNi ca zaktimAnAsIt ");
INSERT INTO sanhk_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","tam asmAkaM pradhAnayAjakA vicArakAzca kenApi prakAreNa kruze viddhvA tasya prANAnanAzayan tadIyA ghaTanAH; ");
INSERT INTO sanhk_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","kintu ya isrAyelIyalokAn uddhArayiSyati sa evAyam ityAzAsmAbhiH kRtA|tadyathA tathAstu tasyA ghaTanAyA adya dinatrayaM gataM| ");
INSERT INTO sanhk_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","adhikantvasmAkaM saGginInAM kiyatstrINAM mukhebhyo'sambhavavAkyamidaM zrutaM; ");
INSERT INTO sanhk_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","tAH pratyUSe zmazAnaM gatvA tatra tasya deham aprApya vyAghuTyetvA proktavatyaH svargIsadUtau dRSTAvasmAbhistau cAvAdiSTAM sa jIvitavAn| ");
INSERT INTO sanhk_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","tatosmAkaM kaizcit zmazAnamagamyata te'pi strINAM vAkyAnurUpaM dRSTavantaH kintu taM nApazyan| ");
INSERT INTO sanhk_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","tadA sa tAvuvAca, he abodhau he bhaviSyadvAdibhiruktavAkyaM pratyetuM vilambamAnau; ");
INSERT INTO sanhk_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","etatsarvvaduHkhaM bhuktvA svabhUtiprAptiH kiM khrISTasya na nyAyyA? ");
INSERT INTO sanhk_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","tataH sa mUsAgranthamArabhya sarvvabhaviSyadvAdinAM sarvvazAstre svasmin likhitAkhyAnAbhiprAyaM bodhayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","atha gamyagrAmAbhyarNaM prApya tenAgre gamanalakSaNe darzite ");
INSERT INTO sanhk_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","tau sAdhayitvAvadatAM sahAvAbhyAM tiSTha dine gate sati rAtrirabhUt; tataH sa tAbhyAM sArddhaM sthAtuM gRhaM yayau| ");
INSERT INTO sanhk_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","pazcAdbhojanopavezakAle sa pUpaM gRhItvA IzvaraguNAn jagAda taJca bhaMktvA tAbhyAM dadau| ");
INSERT INTO sanhk_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","tadA tayo rdRSTau prasannAyAM taM pratyabhijJatuH kintu sa tayoH sAkSAdantardadhe| ");
INSERT INTO sanhk_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","tatastau mithobhidhAtum Arabdhavantau gamanakAle yadA kathAmakathayat zAstrArthaJcabodhayat tadAvayo rbuddhiH kiM na prAjvalat? ");
INSERT INTO sanhk_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","tau tatkSaNAdutthAya yirUzAlamapuraM pratyAyayatuH, tatsthAne ziSyANAm ekAdazAnAM saGginAJca darzanaM jAtaM| ");
INSERT INTO sanhk_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","te procuH prabhurudatiSThad iti satyaM zimone darzanamadAcca| ");
INSERT INTO sanhk_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","tataH pathaH sarvvaghaTanAyAH pUpabhaJjanena tatparicayasya ca sarvvavRttAntaM tau vaktumArebhAte| ");
INSERT INTO sanhk_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","itthaM te parasparaM vadanti tatkAle yIzuH svayaM teSAM madhya protthaya yuSmAkaM kalyANaM bhUyAd ityuvAca, ");
INSERT INTO sanhk_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","kintu bhUtaM pazyAma ityanumAya te samudvivijire treSuzca| ");
INSERT INTO sanhk_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","sa uvAca, kuto duHkhitA bhavatha? yuSmAkaM manaHsu sandeha udeti ca kutaH? ");
INSERT INTO sanhk_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","eSohaM, mama karau pazyata varaM spRSTvA pazyata, mama yAdRzAni pazyatha tAdRzAni bhUtasya mAMsAsthIni na santi| ");
INSERT INTO sanhk_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ityuktvA sa hastapAdAn darzayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","te'sambhavaM jJAtvA sAnandA na pratyayan| tataH sa tAn papraccha, atra yuSmAkaM samIpe khAdyaM kiJcidasti? ");
INSERT INTO sanhk_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","tataste kiyaddagdhamatsyaM madhu ca daduH ");
INSERT INTO sanhk_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","sa tadAdAya teSAM sAkSAd bubhuje ");
INSERT INTO sanhk_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","kathayAmAsa ca mUsAvyavasthAyAM bhaviSyadvAdinAM grantheSu gItapustake ca mayi yAni sarvvANi vacanAni likhitAni tadanurUpANi ghaTiSyante yuSmAbhiH sArddhaM sthitvAhaM yadetadvAkyam avadaM tadidAnIM pratyakSamabhUt| ");
INSERT INTO sanhk_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","atha tebhyaH zAstrabodhAdhikAraM datvAvadat, ");
INSERT INTO sanhk_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","khrISTenetthaM mRtiyAtanA bhoktavyA tRtIyadine ca zmazAnAdutthAtavyaJceti lipirasti; ");
INSERT INTO sanhk_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","tannAmnA yirUzAlamamArabhya sarvvadeze manaHparAvarttanasya pApamocanasya ca susaMvAdaH pracArayitavyaH, ");
INSERT INTO sanhk_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","eSu sarvveSu yUyaM sAkSiNaH| ");
INSERT INTO sanhk_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","aparaJca pazyata pitrA yat pratijJAtaM tat preSayiSyAmi, ataeva yAvatkAlaM yUyaM svargIyAM zaktiM na prApsyatha tAvatkAlaM yirUzAlamnagare tiSThata| ");
INSERT INTO sanhk_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","atha sa tAn baithanIyAparyyantaM nItvA hastAvuttolya AziSa vaktumArebhe ");
INSERT INTO sanhk_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","AziSaM vadanneva ca tebhyaH pRthag bhUtvA svargAya nIto'bhavat| ");
INSERT INTO sanhk_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","tadA te taM bhajamAnA mahAnandena yirUzAlamaM pratyAjagmuH| ");
INSERT INTO sanhk_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","tato nirantaraM mandire tiSThanta Izvarasya prazaMsAM dhanyavAdaJca karttam Arebhire| iti||");
INSERT INTO sanhk_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Adau vAda AsIt sa ca vAda IzvareNa sArdhamAsIt sa vAdaH svayamIzvara eva| ");
INSERT INTO sanhk_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","sa AdAvIzvareNa sahAsIt| ");
INSERT INTO sanhk_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","tena sarvvaM vastu sasRje sarvveSu sRSTavastuSu kimapi vastu tenAsRSTaM nAsti| ");
INSERT INTO sanhk_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","sa jIvanasyAkAraH, tacca jIvanaM manuSyANAM jyotiH ");
INSERT INTO sanhk_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","tajjyotirandhakAre pracakAze kintvandhakArastanna jagrAha| ");
INSERT INTO sanhk_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","yohan nAmaka eko manuja IzvareNa preSayAJcakre| ");
INSERT INTO sanhk_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","tadvArA yathA sarvve vizvasanti tadarthaM sa tajjyotiSi pramANaM dAtuM sAkSisvarUpo bhUtvAgamat, ");
INSERT INTO sanhk_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","sa svayaM tajjyoti rna kintu tajjyotiSi pramANaM dAtumAgamat| ");
INSERT INTO sanhk_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","jagatyAgatya yaH sarvvamanujebhyo dIptiM dadAti tadeva satyajyotiH| ");
INSERT INTO sanhk_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","sa yajjagadasRjat tanmadya eva sa AsIt kintu jagato lokAstaM nAjAnan| ");
INSERT INTO sanhk_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","nijAdhikAraM sa Agacchat kintu prajAstaM nAgRhlan| ");
INSERT INTO sanhk_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","tathApi ye ye tamagRhlan arthAt tasya nAmni vyazvasan tebhya Izvarasya putrA bhavitum adhikAram adadAt| ");
INSERT INTO sanhk_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","teSAM janiH zoNitAnna zArIrikAbhilASAnna mAnavAnAmicchAto na kintvIzvarAdabhavat| ");
INSERT INTO sanhk_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","sa vAdo manuSyarUpeNAvatIryya satyatAnugrahAbhyAM paripUrNaH san sArdham asmAbhi rnyavasat tataH pituradvitIyaputrasya yogyo yo mahimA taM mahimAnaM tasyApazyAma| ");
INSERT INTO sanhk_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","tato yohanapi pracAryya sAkSyamidaM dattavAn yo mama pazcAd AgamiSyati sa matto gurutaraH; yato matpUrvvaM sa vidyamAna AsIt; yadartham ahaM sAkSyamidam adAM sa eSaH| ");
INSERT INTO sanhk_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","aparaJca tasya pUrNatAyA vayaM sarvve kramazaH kramazonugrahaM prAptAH| ");
INSERT INTO sanhk_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","mUsAdvArA vyavasthA dattA kintvanugrahaH satyatvaJca yIzukhrISTadvArA samupAtiSThatAM| ");
INSERT INTO sanhk_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","kopi manuja IzvaraM kadApi nApazyat kintu pituH kroDastho'dvitIyaH putrastaM prakAzayat| ");
INSERT INTO sanhk_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","tvaM kaH? iti vAkyaM preSTuM yadA yihUdIyalokA yAjakAn levilokAMzca yirUzAlamo yohanaH samIpe preSayAmAsuH, ");
INSERT INTO sanhk_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","tadA sa svIkRtavAn nApahnUtavAn nAham abhiSikta ityaGgIkRtavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","tadA te'pRcchan tarhi ko bhavAn? kiM eliyaH? sovadat na; tataste'pRcchan tarhi bhavAn sa bhaviSyadvAdI? sovadat nAhaM saH| ");
INSERT INTO sanhk_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","tadA te'pRcchan tarhi bhavAn kaH? vayaM gatvA prerakAn tvayi kiM vakSyAmaH? svasmin kiM vadasi? ");
INSERT INTO sanhk_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","tadA sovadat| paramezasya panthAnaM pariSkuruta sarvvataH| itIdaM prAntare vAkyaM vadataH kasyacidravaH| kathAmimAM yasmin yizayiyo bhaviSyadvAdI likhitavAn soham| ");
INSERT INTO sanhk_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ye preSitAste phirUzilokAH| ");
INSERT INTO sanhk_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","tadA te'pRcchan yadi nAbhiSiktosi eliyosi na sa bhaviSyadvAdyapi nAsi ca, tarhi lokAn majjayasi kutaH? ");
INSERT INTO sanhk_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","tato yohan pratyavocat, toye'haM majjayAmIti satyaM kintu yaM yUyaM na jAnItha tAdRza eko jano yuSmAkaM madhya upatiSThati| ");
INSERT INTO sanhk_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","sa matpazcAd Agatopi matpUrvvaM varttamAna AsIt tasya pAdukAbandhanaM mocayitumapi nAhaM yogyosmi| ");
INSERT INTO sanhk_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","yarddananadyAH pArasthabaithabArAyAM yasminsthAne yohanamajjayat tasmina sthAne sarvvametad aghaTata| ");
INSERT INTO sanhk_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","pare'hani yohan svanikaTamAgacchantaM yizuM vilokya prAvocat jagataH pApamocakam Izvarasya meSazAvakaM pazyata| ");
INSERT INTO sanhk_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","yo mama pazcAdAgamiSyati sa matto gurutaraH, yato hetormatpUrvvaM so'varttata yasminnahaM kathAmimAM kathitavAn sa evAyaM| ");
INSERT INTO sanhk_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","aparaM nAhamenaM pratyabhijJAtavAn kintu isrAyellokA enaM yathA paricinvanti tadabhiprAyeNAhaM jale majjayitumAgaccham| ");
INSERT INTO sanhk_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","punazca yohanaparamekaM pramANaM datvA kathitavAn vihAyasaH kapotavad avatarantamAtmAnam asyoparyyavatiSThantaM ca dRSTavAnaham| ");
INSERT INTO sanhk_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","nAhamenaM pratyabhijJAtavAn iti satyaM kintu yo jale majjayituM mAM prairayat sa evemAM kathAmakathayat yasyoparyyAtmAnam avatarantam avatiSThantaJca drakSayasi saeva pavitre Atmani majjayiSyati| ");
INSERT INTO sanhk_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","avastannirIkSyAyam Izvarasya tanaya iti pramANaM dadAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","pare'hani yohan dvAbhyAM ziSyAbhyAM sArddheM tiSThan ");
INSERT INTO sanhk_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","yizuM gacchantaM vilokya gaditavAn, Izvarasya meSazAvakaM pazyataM| ");
INSERT INTO sanhk_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","imAM kathAM zrutvA dvau ziSyau yIzoH pazcAd IyatuH| ");
INSERT INTO sanhk_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","tato yIzuH parAvRtya tau pazcAd Agacchantau dRSTvA pRSTavAn yuvAM kiM gavezayathaH? tAvapRcchatAM he rabbi arthAt he guro bhavAn kutra tiSThati? ");
INSERT INTO sanhk_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","tataH sovAdit etya pazyataM| tato divasasya tRtIyapraharasya gatatvAt tau taddinaM tasya saGge'sthAtAM| ");
INSERT INTO sanhk_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","yau dvau yohano vAkyaM zrutvA yizoH pazcAd AgamatAM tayoH zimonpitarasya bhrAtA AndriyaH ");
INSERT INTO sanhk_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","sa itvA prathamaM nijasodaraM zimonaM sAkSAtprApya kathitavAn vayaM khrISTam arthAt abhiSiktapuruSaM sAkSAtkRtavantaH| ");
INSERT INTO sanhk_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","pazcAt sa taM yizoH samIpam Anayat| tadA yIzustaM dRSTvAvadat tvaM yUnasaH putraH zimon kintu tvannAmadheyaM kaiphAH vA pitaraH arthAt prastaro bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","pare'hani yIzau gAlIlaM gantuM nizcitacetasi sati philipanAmAnaM janaM sAkSAtprApyAvocat mama pazcAd Agaccha| ");
INSERT INTO sanhk_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","baitsaidAnAmni yasmin grAme pitarAndriyayorvAsa AsIt tasmin grAme tasya philipasya vasatirAsIt| ");
INSERT INTO sanhk_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","pazcAt philipo nithanelaM sAkSAtprApyAvadat mUsA vyavasthA granthe bhaviSyadvAdinAM grantheSu ca yasyAkhyAnaM likhitamAste taM yUSaphaH putraM nAsaratIyaM yIzuM sAkSAd akArSma vayaM| ");
INSERT INTO sanhk_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","tadA nithanel kathitavAn nAsarannagarAta kiM kazciduttama utpantuM zaknoti? tataH philipo 'vocat etya pazya| ");
INSERT INTO sanhk_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","aparaJca yIzuH svasya samIpaM tam AgacchantaM dRSTvA vyAhRtavAn, pazyAyaM niSkapaTaH satya isrAyellokaH| ");
INSERT INTO sanhk_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","tataH sovadad, bhavAn mAM kathaM pratyabhijAnAti? yIzuravAdIt philipasya AhvAnAt pUrvvaM yadA tvamuDumbarasya tarormUle'sthAstadA tvAmadarzam| ");
INSERT INTO sanhk_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","nithanel acakathat, he guro bhavAn nitAntam Izvarasya putrosi, bhavAn isrAyelvaMzasya rAjA| ");
INSERT INTO sanhk_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","tato yIzu rvyAharat, tvAmuDumbarasya pAdapasya mUle dRSTavAnAhaM mamaitasmAdvAkyAt kiM tvaM vyazvasIH? etasmAdapyAzcaryyANi kAryyANi drakSyasi| ");
INSERT INTO sanhk_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","anyaccAvAdId yuSmAnahaM yathArthaM vadAmi, itaH paraM mocite meghadvAre tasmAnmanujasUnunA Izvarasya dUtagaNam avarohantamArohantaJca drakSyatha| ");
INSERT INTO sanhk_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","anantaraM trutIyadivase gAlIl pradeziye kAnnAnAmni nagare vivAha AsIt tatra ca yIzormAtA tiSThat| ");
INSERT INTO sanhk_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","tasmai vivAhAya yIzustasya ziSyAzca nimantritA Asan| ");
INSERT INTO sanhk_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","tadanantaraM drAkSArasasya nyUnatvAd yIzormAtA tamavadat eteSAM drAkSAraso nAsti| ");
INSERT INTO sanhk_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","tadA sa tAmavocat he nAri mayA saha tava kiM kAryyaM? mama samaya idAnIM nopatiSThati| ");
INSERT INTO sanhk_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","tatastasya mAtA dAsAnavocad ayaM yad vadati tadeva kuruta| ");
INSERT INTO sanhk_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","tasmin sthAne yihUdIyAnAM zucitvakaraNavyavahArAnusAreNADhakaikajaladharANi pASANamayAni SaDvRhatpAtrANiAsan| ");
INSERT INTO sanhk_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","tadA yIzustAn sarvvakalazAn jalaiH pUrayituM tAnAjJApayat, tataste sarvvAn kumbhAnAkarNaM jalaiH paryyapUrayan| ");
INSERT INTO sanhk_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","atha tebhyaH kiJciduttAryya bhojyAdhipAteHsamIpaM netuM sa tAnAdizat, te tadanayan| ");
INSERT INTO sanhk_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","aparaJca tajjalaM kathaM drAkSAraso'bhavat tajjalavAhakAdAsA jJAtuM zaktAH kintu tadbhojyAdhipo jJAtuM nAzaknot tadavalihya varaM saMmbodyAvadata, ");
INSERT INTO sanhk_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","lokAH prathamaM uttamadrAkSArasaM dadati taSu yatheSTaM pitavatsu tasmA kiJcidanuttamaJca dadati kintu tvamidAnIM yAvat uttamadrAkSArasaM sthApayasi| ");
INSERT INTO sanhk_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","itthaM yIzurgAlIlapradeze AzcaryyakArmma prArambha nijamahimAnaM prAkAzayat tataH ziSyAstasmin vyazvasan| ");
INSERT INTO sanhk_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","tataH param sa nijamAtrubhrAtrusziSyaiH sArddhM kapharnAhUmam Agamat kintu tatra bahUdinAni AtiSThat| ");
INSERT INTO sanhk_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","tadanantaraM yihUdiyAnAM nistArotsave nikaTamAgate yIzu ryirUzAlam nagaram Agacchat| ");
INSERT INTO sanhk_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","tato mandirasya madhye gomeSapArAvatavikrayiNo vANijakScopaviSTAn vilokya ");
INSERT INTO sanhk_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","rajjubhiH kazAM nirmmAya sarvvagomeSAdibhiH sArddhaM tAn mandirAd dUrIkRtavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","vaNijAM mudrAdi vikIryya AsanAni nyUbjIkRtya pArAvatavikrayibhyo'kathayad asmAt sthAnAt sarvANyetAni nayata, mama pitugRhaM vANijyagRhaM mA kArSTa| ");
INSERT INTO sanhk_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","tasmAt tanmandirArtha udyogo yastu sa grasatIva mAm| imAM zAstrIyalipiM ziSyAHsamasmaran| ");
INSERT INTO sanhk_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","tataH param yihUdIyalokA yISimavadan tavamidRzakarmmakaraNAt kiM cihnamasmAn darzayasi? ");
INSERT INTO sanhk_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","tato yIzustAnavocad yuSmAbhire tasmin mandire nAzite dinatrayamadhye'haM tad utthApayiSyAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","tadA yihUdiyA vyAhArSuH, etasya mandirasa nirmmANena SaTcatvAriMzad vatsarA gatAH, tvaM kiM dinatrayamadhye tad utthApayiSyasi? ");
INSERT INTO sanhk_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","kintu sa nijadeharUpamandire kathAmimAM kathitavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","sa yadetAdRzaM gaditavAn tacchiSyAH zmazAnAt tadIyotthAne sati smRtvA dharmmagranthe yIzunoktakathAyAM ca vyazvasiSuH| ");
INSERT INTO sanhk_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","anantaraM nistArotsavasya bhojyasamaye yirUzAlam nagare tatkrutAzcaryyakarmmANi vilokya bahubhistasya nAmani vizvasitaM| ");
INSERT INTO sanhk_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","kintu sa teSAM kareSu svaM na samarpayat, yataH sa sarvvAnavait| ");
INSERT INTO sanhk_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","sa mAnaveSu kasyacit pramANaM nApekSata yato manujAnAM madhye yadyadasti tattat sojAnAt| ");
INSERT INTO sanhk_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","nikadimanAmA yihUdIyAnAm adhipatiH phirUzI kSaNadAyAM ");
INSERT INTO sanhk_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","yIzaurabhyarNam Avrajya vyAhArSIt, he guro bhavAn IzvarAd Agat eka upadeSTA, etad asmAbhirjJAyate; yato bhavatA yAnyAzcaryyakarmmANi kriyante paramezvarasya sAhAyyaM vinA kenApi tattatkarmmANi karttuM na zakyante| ");
INSERT INTO sanhk_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","tadA yIzuruttaraM dattavAn tavAhaM yathArthataraM vyAharAmi punarjanmani na sati kopi mAnava Izvarasya rAjyaM draSTuM na zaknoti| ");
INSERT INTO sanhk_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","tato nikadImaH pratyavocat manujo vRddho bhUtvA kathaM janiSyate? sa kiM puna rmAtRrjaTharaM pravizya janituM zaknoti? ");
INSERT INTO sanhk_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","yIzuravAdId yathArthataram ahaM kathayAmi manuje toyAtmabhyAM puna rna jAte sa Izvarasya rAjyaM praveSTuM na zaknoti| ");
INSERT INTO sanhk_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","mAMsAd yat jAyate tan mAMsameva tathAtmano yo jAyate sa Atmaiva| ");
INSERT INTO sanhk_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","yuSmAbhiH puna rjanitavyaM mamaitasyAM kathAyAm AzcaryaM mA maMsthAH| ");
INSERT INTO sanhk_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","sadAgatiryAM dizamicchati tasyAmeva dizi vAti, tvaM tasya svanaM zuNoSi kintu sa kuta AyAti kutra yAti vA kimapi na jAnAsi tadvAd AtmanaH sakAzAt sarvveSAM manujAnAM janma bhavati| ");
INSERT INTO sanhk_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","tadA nikadImaH pRSTavAn etat kathaM bhavituM zaknoti? ");
INSERT INTO sanhk_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","yIzuH pratyaktavAn tvamisrAyelo gururbhUtvApi kimetAM kathAM na vetsi? ");
INSERT INTO sanhk_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","tubhyaM yathArthaM kathayAmi, vayaM yad vidmastad vacmaH yaMcca pazyAmastasyaiva sAkSyaM dadmaH kintu yuSmAbhirasmAkaM sAkSitvaM na gRhyate| ");
INSERT INTO sanhk_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","etasya saMsArasya kathAyAM kathitAyAM yadi yUyaM na vizvasitha tarhi svargIyAyAM kathAyAM kathaM vizvasiSyatha? ");
INSERT INTO sanhk_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","yaH svarge'sti yaM ca svargAd avArohat taM mAnavatanayaM vinA kopi svargaM nArohat| ");
INSERT INTO sanhk_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","aparaJca mUsA yathA prAntare sarpaM protthApitavAn manuSyaputro'pi tathaivotthApitavyaH; ");
INSERT INTO sanhk_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","tasmAd yaH kazcit tasmin vizvasiSyati so'vinAzyaH san anantAyuH prApsyati| ");
INSERT INTO sanhk_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Izvara itthaM jagadadayata yat svamadvitIyaM tanayaM prAdadAt tato yaH kazcit tasmin vizvasiSyati so'vinAzyaH san anantAyuH prApsyati| ");
INSERT INTO sanhk_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Izvaro jagato lokAn daNDayituM svaputraM na preSya tAn paritrAtuM preSitavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ataeva yaH kazcit tasmin vizvasiti sa daNDArho na bhavati kintu yaH kazcit tasmin na vizvasiti sa idAnImeva daNDArho bhavati,yataH sa IzvarasyAdvitIyaputrasya nAmani pratyayaM na karoti| ");
INSERT INTO sanhk_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","jagato madhye jyotiH prAkAzata kintu manuSyANAM karmmaNAM dRSTatvAt te jyotiSopi timire prIyante etadeva daNDasya kAraNAM bhavati| ");
INSERT INTO sanhk_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","yaH kukarmma karoti tasyAcArasya dRSTatvAt sa jyotirRRtIyitvA tannikaTaM nAyAti; ");
INSERT INTO sanhk_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","kintu yaH satkarmma karoti tasya sarvvANi karmmANIzvareNa kRtAnIti sathA prakAzate tadabhiprAyeNa sa jyotiSaH sannidhim AyAti| ");
INSERT INTO sanhk_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","tataH param yIzuH ziSyaiH sArddhaM yihUdIyadezaM gatvA tatra sthitvA majjayitum Arabhata| ");
INSERT INTO sanhk_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","tadA zAlam nagarasya samIpasthAyini ainan grAme bahutaratoyasthitestatra yohan amajjayat tathA ca lokA Agatya tena majjitA abhavan| ");
INSERT INTO sanhk_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","tadA yohan kArAyAM na baddhaH| ");
INSERT INTO sanhk_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","aparaJca zAcakarmmaNi yohAnaH ziSyaiH saha yihUdIyalokAnAM vivAde jAte, te yohanaH saMnnidhiM gatvAkathayan, ");
INSERT INTO sanhk_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","he guro yarddananadyAH pAre bhavatA sArddhaM ya AsIt yasmiMzca bhavAn sAkSyaM pradadAt pazyatu sopi majjayati sarvve tasya samIpaM yAnti ca| ");
INSERT INTO sanhk_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","tadA yohan pratyavocad IzvareNa na datte kopi manujaH kimapi prAptuM na zaknoti| ");
INSERT INTO sanhk_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","ahaM abhiSikto na bhavAmi kintu tadagre preSitosmi yAmimAM kathAM kathitavAnAhaM tatra yUyaM sarvve sAkSiNaH stha| ");
INSERT INTO sanhk_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","yo janaH kanyAM labhate sa eva varaH kintu varasya sannidhau daNDAyamAnaM tasya yanmitraM tena varasya zabde zrute'tIvAhlAdyate mamApi tadvad AnandasiddhirjAtA| ");
INSERT INTO sanhk_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","tena kramazo varddhitavyaM kintu mayA hsitavyaM| ");
INSERT INTO sanhk_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ya UrdhvAdAgacchat sa sarvveSAM mukhyo yazca saMsArAd udapadyata sa sAMsArikaH saMsArIyAM kathAJca kathayati yastu svargAdAgacchat sa sarvveSAM mukhyaH| ");
INSERT INTO sanhk_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","sa yadapazyadazRNocca tasminneva sAkSyaM dadAti tathApi prAyazaH kazcit tasya sAkSyaM na gRhlAti; ");
INSERT INTO sanhk_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","kintu yo gRhlAti sa Izvarasya satyavAditvaM mudrAGgitaM karoti| ");
INSERT INTO sanhk_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","IzvareNa yaH preritaH saeva IzvarIyakathAM kathayati yata Izvara AtmAnaM tasmai aparimitam adadAt| ");
INSERT INTO sanhk_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","pitA putre snehaM kRtvA tasya haste sarvvANi samarpitavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","yaH kazcit putre vizvasiti sa evAnantam paramAyuH prApnoti kintu yaH kazcit putre na vizvasiti sa paramAyuSo darzanaM na prApnoti kintvIzvarasya kopabhAjanaM bhUtvA tiSThati| ");
INSERT INTO sanhk_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","yIzuH svayaM nAmajjayat kevalaM tasya ziSyA amajjayat kintu yohano'dhikaziSyAn sa karoti majjayati ca, ");
INSERT INTO sanhk_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","phirUzina imAM vArttAmazRNvan iti prabhuravagatya ");
INSERT INTO sanhk_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","yihUdIyadezaM vihAya puna rgAlIlam Agat| ");
INSERT INTO sanhk_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","tataH zomiroNapradezasya madyena tena gantavye sati ");
INSERT INTO sanhk_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","yAkUb nijaputrAya yUSaphe yAM bhUmim adadAt tatsamIpasthAyi zomiroNapradezasya sukhAr nAmnA vikhyAtasya nagarasya sannidhAvupAsthAt| ");
INSERT INTO sanhk_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","tatra yAkUbaH prahirAsIt; tadA dvitIyayAmavelAyAM jAtAyAM sa mArge zramApannastasya praheH pArzve upAvizat| ");
INSERT INTO sanhk_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","etarhi kAcit zomiroNIyA yoSit toyottolanArtham tatrAgamat ");
INSERT INTO sanhk_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","tadA ziSyAH khAdyadravyANi kretuM nagaram agacchan| ");
INSERT INTO sanhk_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","yIzuH zomiroNIyAM tAM yoSitam vyAhArSIt mahyaM kiJcit pAnIyaM pAtuM dehi| kintu zomiroNIyaiH sAkaM yihUdIyalokA na vyavAharan tasmAddhetoH sAkathayat zomiroNIyA yoSitadahaM tvaM yihUdIyosi kathaM mattaH pAnIyaM pAtum icchasi? ");
INSERT INTO sanhk_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","tato yIzuravadad Izvarasya yaddAnaM tatkIdRk pAnIyaM pAtuM mahyaM dehi ya itthaM tvAM yAcate sa vA ka iti cedajJAsyathAstarhi tamayAciSyathAH sa ca tubhyamamRtaM toyamadAsyat| ");
INSERT INTO sanhk_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","tadA sA sImantinI bhASitavati, he maheccha prahirgambhIro bhavato nIrottolanapAtraM nAstI ca tasmAt tadamRtaM kIlAlaM kutaH prApsyasi? ");
INSERT INTO sanhk_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","yosmabhyam imamandhUM dadau, yasya ca parijanA gomeSAdayazca sarvve'sya praheH pAnIyaM papuretAdRzo yosmAkaM pUrvvapuruSo yAkUb tasmAdapi bhavAn mahAn kiM? ");
INSERT INTO sanhk_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","tato yIzurakathayad idaM pAnIyaM saH pivati sa punastRSArtto bhaviSyati, ");
INSERT INTO sanhk_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","kintu mayA dattaM pAnIyaM yaH pivati sa punaH kadApi tRSArtto na bhaviSyati| mayA dattam idaM toyaM tasyAntaH prasravaNarUpaM bhUtvA anantAyuryAvat sroSyati| ");
INSERT INTO sanhk_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","tadA sA vanitAkathayat he maheccha tarhi mama punaH pIpAsA yathA na jAyate toyottolanAya yathAtrAgamanaM na bhavati ca tadarthaM mahyaM tattoyaM dehI| ");
INSERT INTO sanhk_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","tato yIzUravadadyAhi tava patimAhUya sthAne'trAgaccha| ");
INSERT INTO sanhk_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","sA vAmAvadat mama patirnAsti| yIzuravadat mama patirnAstIti vAkyaM bhadramavocaH| ");
INSERT INTO sanhk_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","yatastava paJca patayobhavan adhunA tu tvayA sArddhaM yastiSThati sa tava bharttA na vAkyamidaM satyamavAdiH| ");
INSERT INTO sanhk_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","tadA sA mahilA gaditavati he maheccha bhavAn eko bhaviSyadvAdIti buddhaM mayA| ");
INSERT INTO sanhk_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","asmAkaM pitRlokA etasmin ziloccaye'bhajanta, kintu bhavadbhirucyate yirUzAlam nagare bhajanayogyaM sthAnamAste| ");
INSERT INTO sanhk_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","yIzuravocat he yoSit mama vAkye vizvasihi yadA yUyaM kevalazaile'smin vA yirUzAlam nagare piturbhajanaM na kariSyadhve kAla etAdRza AyAti| ");
INSERT INTO sanhk_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","yUyaM yaM bhajadhve taM na jAnItha, kintu vayaM yaM bhajAmahe taM jAnImahe, yato yihUdIyalokAnAM madhyAt paritrANaM jAyate| ");
INSERT INTO sanhk_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","kintu yadA satyabhaktA AtmanA satyarUpeNa ca piturbhajanaM kariSyante samaya etAdRza AyAti, varam idAnImapi vidyate ; yata etAdRzo bhatkAn pitA ceSTate| ");
INSERT INTO sanhk_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Izvara AtmA; tatastasya ye bhaktAstaiH sa AtmanA satyarUpeNa ca bhajanIyaH| ");
INSERT INTO sanhk_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","tadA sA mahilAvAdIt khrISTanAmnA vikhyAto'bhiSiktaH puruSa AgamiSyatIti jAnAmi sa ca sarvvAH kathA asmAn jJApayiSyati| ");
INSERT INTO sanhk_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","tato yIzuravadat tvayA sArddhaM kathanaM karomi yo'ham ahameva sa puruSaH| ");
INSERT INTO sanhk_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","etasmin samaye ziSyA Agatya tathA striyA sArddhaM tasya kathopakathane mahAzcaryyam amanyanta tathApi bhavAn kimicchati? yadvA kimartham etayA sArddhaM kathAM kathayati? iti kopi nApRcchat| ");
INSERT INTO sanhk_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","tataH paraM sA nArI kalazaM sthApayitvA nagaramadhyaM gatvA lokebhyokathAyad ");
INSERT INTO sanhk_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","ahaM yadyat karmmAkaravaM tatsarvvaM mahyamakathayad etAdRzaM mAnavamekam Agatya pazyata ru kim abhiSikto na bhavati ? ");
INSERT INTO sanhk_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","tataste nagarAd bahirAgatya tAtasya samIpam Ayan| ");
INSERT INTO sanhk_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","etarhi ziSyAH sAdhayitvA taM vyAhArSuH he guro bhavAn kiJcid bhUktAM| ");
INSERT INTO sanhk_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","tataH sovadad yuSmAbhiryanna jJAyate tAdRzaM bhakSyaM mamAste| ");
INSERT INTO sanhk_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","tadA ziSyAH parasparaM praSTum Arambhanta, kimasmai kopi kimapi bhakSyamAnIya dattavAn? ");
INSERT INTO sanhk_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","yIzuravocat matprerakasyAbhimatAnurUpakaraNaM tasyaiva karmmasiddhikAraNaJca mama bhakSyaM| ");
INSERT INTO sanhk_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","mAsacatuSTaye jAte zasyakarttanasamayo bhaviSyatIti vAkyaM yuSmAbhiH kiM nodyate? kintvahaM vadAmi, zira uttolya kSetrANi prati nirIkSya pazyata, idAnIM karttanayogyAni zuklavarNAnyabhavan| ");
INSERT INTO sanhk_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","yazchinatti sa vetanaM labhate anantAyuHsvarUpaM zasyaM sa gRhlAti ca, tenaiva vaptA chettA ca yugapad AnandataH| ");
INSERT INTO sanhk_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","itthaM sati vapatyekazchinatyanya iti vacanaM siddhyati| ");
INSERT INTO sanhk_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","yatra yUyaM na paryyazrAmyata tAdRzaM zasyaM chettuM yuSmAn prairayam anye janAHparyyazrAmyan yUyaM teSAM zragasya phalam alabhadhvam| ");
INSERT INTO sanhk_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","yasmin kAle yadyat karmmAkArSaM tatsarvvaM sa mahyam akathayat tasyA vanitAyA idaM sAkSyavAkyaM zrutvA tannagaranivAsino bahavaH zomiroNIyalokA vyazvasan| ");
INSERT INTO sanhk_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","tathA ca tasyAntike samupasthAya sveSAM sannidhau katicid dinAni sthAtuM tasmin vinayam akurvvAna tasmAt sa dinadvayaM tatsthAne nyavaSTat ");
INSERT INTO sanhk_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","tatastasyopadezena bahavo'pare vizvasya ");
INSERT INTO sanhk_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","tAM yoSAmavadan kevalaM tava vAkyena pratIma iti na, kintu sa jagato'bhiSiktastrAteti tasya kathAM zrutvA vayaM svayamevAjJAsamahi| ");
INSERT INTO sanhk_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","svadeze bhaviSyadvaktuH satkAro nAstIti yadyapi yIzuH pramANaM datvAkathayat ");
INSERT INTO sanhk_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","tathApi divasadvayAt paraM sa tasmAt sthAnAd gAlIlaM gatavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","anantaraM ye gAlIlI liyalokA utsave gatA utsavasamaye yirUzalam nagare tasya sarvvAH kriyA apazyan te gAlIlam AgataM tam AgRhlan| ");
INSERT INTO sanhk_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","tataH param yIzu ryasmin kAnnAnagare jalaM drAkSArasam Akarot tat sthAnaM punaragAt| tasminneva samaye kasyacid rAjasabhAstArasya putraH kapharnAhUmapurI rogagrasta AsIt| ");
INSERT INTO sanhk_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","sa yehUdIyadezAd yIzo rgAlIlAgamanavArttAM nizamya tasya samIpaM gatvA prArthya vyAhRtavAn mama putrasya prAyeNa kAla AsannaH bhavAn Agatya taM svasthaM karotu| ");
INSERT INTO sanhk_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","tadA yIzurakathayad AzcaryyaM karmma citraM cihnaM ca na dRSTA yUyaM na pratyeSyatha| ");
INSERT INTO sanhk_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","tataH sa sabhAsadavadat he maheccha mama putre na mRte bhavAnAgacchatu| ");
INSERT INTO sanhk_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","yIzustamavadad gaccha tava putro'jIvIt tadA yIzunoktavAkye sa vizvasya gatavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","gamanakAle mArgamadhye dAsAstaM sAkSAtprApyAvadan bhavataH putro'jIvIt| ");
INSERT INTO sanhk_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","tataH kaM kAlamArabhya rogapratIkArArambho jAtA iti pRSTe tairuktaM hyaH sArddhadaNDadvayAdhikadvitIyayAme tasya jvaratyAgo'bhavat| ");
INSERT INTO sanhk_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","tadA yIzustasmin kSaNe proktavAn tava putro'jIvIt pitA tadbuddhvA saparivAro vyazvasIt| ");
INSERT INTO sanhk_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","yihUdIyadezAd Agatya gAlIli yIzuretad dvitIyam AzcaryyakarmmAkarot| ");
INSERT INTO sanhk_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","tataH paraM yihUdIyAnAm utsava upasthite yIzu ryirUzAlamaM gatavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","tasminnagare meSanAmno dvArasya samIpe ibrIyabhASayA baithesdA nAmnA piSkariNI paJcaghaTTayuktAsIt| ");
INSERT INTO sanhk_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","tasyAsteSu ghaTTeSu kilAlakampanam apekSya andhakhaJcazuSkAGgAdayo bahavo rogiNaH patantastiSThanti sma| ");
INSERT INTO sanhk_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","yato vizeSakAle tasya saraso vAri svargIyadUta etyAkampayat tatkIlAlakampanAt paraM yaH kazcid rogI prathamaM pAnIyamavArohat sa eva tatkSaNAd rogamukto'bhavat| ");
INSERT INTO sanhk_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","tadASTAtriMzadvarSANi yAvad rogagrasta ekajanastasmin sthAne sthitavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","yIzustaM zayitaM dRSTvA bahukAlikarogIti jJAtvA vyAhRtavAn tvaM kiM svastho bubhUSasi? ");
INSERT INTO sanhk_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","tato rogI kathitavAn he maheccha yadA kIlAlaM kampate tadA mAM puSkariNIm avarohayituM mama kopi nAsti, tasmAn mama gamanakAle kazcidanyo'gro gatvA avarohati| ");
INSERT INTO sanhk_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","tadA yIzurakathayad uttiSTha, tava zayyAmuttolya gRhItvA yAhi| ");
INSERT INTO sanhk_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","sa tatkSaNAt svastho bhUtvA zayyAmuttolyAdAya gatavAn kintu taddinaM vizrAmavAraH| ");
INSERT INTO sanhk_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","tasmAd yihUdIyAH svasthaM naraM vyAharan adya vizrAmavAre zayanIyamAdAya na yAtavyam| ");
INSERT INTO sanhk_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","tataH sa pratyavocad yo mAM svastham akArSIt zayanIyam uttolyAdAya yAtuM mAM sa evAdizat| ");
INSERT INTO sanhk_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","tadA te'pRcchan zayanIyam uttolyAdAya yAtuM ya AjJApayat sa kaH? ");
INSERT INTO sanhk_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","kintu sa ka iti svasthIbhUto nAjAnAd yatastasmin sthAne janatAsattvAd yIzuH sthAnAntaram Agamat| ");
INSERT INTO sanhk_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","tataH paraM yezu rmandire taM naraM sAkSAtprApyAkathayat pazyedAnIm anAmayo jAtosi yathAdhikA durdazA na ghaTate taddhetoH pApaM karmma punarmAkArSIH| ");
INSERT INTO sanhk_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","tataH sa gatvA yihUdIyAn avadad yIzu rmAm arogiNam akArSIt| ");
INSERT INTO sanhk_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","tato yIzu rvizrAmavAre karmmedRzaM kRtavAn iti heto ryihUdIyAstaM tADayitvA hantum aceSTanta| ");
INSERT INTO sanhk_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","yIzustAnAkhyat mama pitA yat kAryyaM karoti tadanurUpam ahamapi karoti| ");
INSERT INTO sanhk_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","tato yihUdIyAstaM hantuM punarayatanta yato vizrAmavAraM nAmanyata tadeva kevalaM na adhikantu IzvaraM svapitaraM procya svamapIzvaratulyaM kRtavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","pazcAd yIzuravadad yuSmAnahaM yathArthataraM vadAmi putraH pitaraM yadyat karmma kurvvantaM pazyati tadatiriktaM svecchAtaH kimapi karmma karttuM na zaknoti| pitA yat karoti putropi tadeva karoti| ");
INSERT INTO sanhk_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","pitA putre snehaM karoti tasmAt svayaM yadyat karmma karoti tatsarvvaM putraM darzayati ; yathA ca yuSmAkaM AzcaryyajJAnaM janiSyate tadartham itopi mahAkarmma taM darzayiSyati| ");
INSERT INTO sanhk_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","vastutastu pitA yathA pramitAn utthApya sajivAn karoti tadvat putropi yaM yaM icchati taM taM sajIvaM karoti| ");
INSERT INTO sanhk_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","sarvve pitaraM yathA satkurvvanti tathA putramapi satkArayituM pitA svayaM kasyApi vicAramakRtvA sarvvavicArANAM bhAraM putre samarpitavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","yaH putraM sat karoti sa tasya prerakamapi sat karoti| ");
INSERT INTO sanhk_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","yuSmAnAhaM yathArthataraM vadAmi yo jano mama vAkyaM zrutvA matprerake vizvasiti sonantAyuH prApnoti kadApi daNDabAjanaM na bhavati nidhanAdutthAya paramAyuH prApnoti| ");
INSERT INTO sanhk_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","ahaM yuSmAnatiyathArthaM vadAmi yadA mRtA Izvaraputrasya ninAdaM zroSyanti ye ca zroSyanti te sajIvA bhaviSyanti samaya etAdRza AyAti varam idAnImapyupatiSThati| ");
INSERT INTO sanhk_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","pitA yathA svayaJjIvI tathA putrAya svayaJjIvitvAdhikAraM dattavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","sa manuSyaputraH etasmAt kAraNAt pitA daNDakaraNAdhikAramapi tasmin samarpitavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","etadarthe yUyam AzcaryyaM na manyadhvaM yato yasmin samaye tasya ninAdaM zrutvA zmazAnasthAH sarvve bahirAgamiSyanti samaya etAdRza upasthAsyati| ");
INSERT INTO sanhk_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","tasmAd ye satkarmmANi kRtavantasta utthAya AyuH prApsyanti ye ca kukarmANi kRtavantasta utthAya daNDaM prApsyanti| ");
INSERT INTO sanhk_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","ahaM svayaM kimapi karttuM na zaknomi yathA zuNomi tathA vicArayAmi mama vicAraJca nyAyyaH yatohaM svIyAbhISTaM nehitvA matprerayituH pituriSTam Ihe| ");
INSERT INTO sanhk_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","yadi svasmin svayaM sAkSyaM dadAmi tarhi tatsAkSyam AgrAhyaM bhavati ; ");
INSERT INTO sanhk_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","kintu madarthe'paro janaH sAkSyaM dadAti madarthe tasya yat sAkSyaM tat satyam etadapyahaM jAnAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","yuSmAbhi ryohanaM prati lokeSu preriteSu sa satyakathAyAM sAkSyamadadAt| ");
INSERT INTO sanhk_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","mAnuSAdahaM sAkSyaM nopekSe tathApi yUyaM yathA paritrayadhve tadartham idaM vAkyaM vadAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","yohan dedIpyamAno dIpa iva tejasvI sthitavAn yUyam alpakAlaM tasya dIptyAnandituM samamanyadhvaM| ");
INSERT INTO sanhk_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","kintu tatpramANAdapi mama gurutaraM pramANaM vidyate pitA mAM preSya yadyat karmma samApayituM zakttimadadAt mayA kRtaM tattat karmma madarthe pramANaM dadAti| ");
INSERT INTO sanhk_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","yaH pitA mAM preritavAn mopi madarthe pramANaM dadAti| tasya vAkyaM yuSmAbhiH kadApi na zrutaM tasya rUpaJca na dRSTaM ");
INSERT INTO sanhk_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","tasya vAkyaJca yuSmAkam antaH kadApi sthAnaM nApnoti yataH sa yaM preSitavAn yUyaM tasmin na vizvasitha| ");
INSERT INTO sanhk_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","dharmmapustakAni yUyam AlocayadhvaM tai rvAkyairanantAyuH prApsyAma iti yUyaM budhyadhve taddharmmapustakAni madarthe pramANaM dadati| ");
INSERT INTO sanhk_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","tathApi yUyaM paramAyuHprAptaye mama saMnidhim na jigamiSatha| ");
INSERT INTO sanhk_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","ahaM mAnuSebhyaH satkAraM na gRhlAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ahaM yuSmAn jAnAmi; yuSmAkamantara Izvaraprema nAsti| ");
INSERT INTO sanhk_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ahaM nijapitu rnAmnAgatosmi tathApi mAM na gRhlItha kintu kazcid yadi svanAmnA samAgamiSyati tarhi taM grahISyatha| ");
INSERT INTO sanhk_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","yUyam IzvarAt satkAraM na ciSTatvA kevalaM parasparaM satkAram ced Adadhvve tarhi kathaM vizvasituM zaknutha? ");
INSERT INTO sanhk_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","putuH samIpe'haM yuSmAn apavadiSyAmIti mA cintayata yasmin , yasmin yuSmAkaM vizvasaH saeva mUsA yuSmAn apavadati| ");
INSERT INTO sanhk_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","yadi yUyaM tasmin vyazvasiSyata tarhi mayyapi vyazvasiSyata, yat sa mayi likhitavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","tato yadi tena likhitavAni na pratitha tarhi mama vAkyAni kathaM pratyeSyatha? ");
INSERT INTO sanhk_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","tataH paraM yIzu rgAlIl pradezIyasya tiviriyAnAmnaH sindhoH pAraM gatavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","tato vyAdhimallokasvAsthyakaraNarUpANi tasyAzcaryyANi karmmANi dRSTvA bahavo janAstatpazcAd agacchan| ");
INSERT INTO sanhk_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","tato yIzuH parvvatamAruhya tatra ziSyaiH sAkam| ");
INSERT INTO sanhk_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","tasmin samaya nistArotsavanAmni yihUdIyAnAma utsava upasthite ");
INSERT INTO sanhk_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","yIzu rnetre uttolya bahulokAn svasamIpAgatAn vilokya philipaM pRSTavAn eteSAM bhojanAya bhojadravyANi vayaM kutra kretuM zakrumaH? ");
INSERT INTO sanhk_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","vAkyamidaM tasya parIkSArtham avAdIt kintu yat kariSyati tat svayam ajAnAt| ");
INSERT INTO sanhk_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","philipaH pratyavocat eteSAm ekaiko yadyalpam alpaM prApnoti tarhi mudrApAdadvizatena krItapUpA api nyUnA bhaviSyanti| ");
INSERT INTO sanhk_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","zimon pitarasya bhrAtA AndriyAkhyaH ziSyANAmeko vyAhRtavAn ");
INSERT INTO sanhk_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","atra kasyacid bAlakasya samIpe paJca yAvapUpAH kSudramatsyadvayaJca santi kintu lokAnAM etAvAtAM madhye taiH kiM bhaviSyati? ");
INSERT INTO sanhk_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","pazcAd yIzuravadat lokAnupavezayata tatra bahuyavasasattvAt paJcasahastrebhyo nyUnA adhikA vA puruSA bhUmyAm upAvizan| ");
INSERT INTO sanhk_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","tato yIzustAn pUpAnAdAya Izvarasya guNAn kIrttayitvA ziSyeSu samArpayat tataste tebhya upaviSTalokebhyaH pUpAn yatheSTamatsyaJca prAduH| ");
INSERT INTO sanhk_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","teSu tRpteSu sa tAnavocad eteSAM kiJcidapi yathA nApacIyate tathA sarvvANyavaziSTAni saMgRhlIta| ");
INSERT INTO sanhk_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","tataH sarvveSAM bhojanAt paraM te teSAM paJcAnAM yAvapUpAnAM avaziSTAnyakhilAni saMgRhya dvAdazaDallakAn apUrayan| ");
INSERT INTO sanhk_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","aparaM yIzoretAdRzIm AzcaryyakriyAM dRSTvA lokA mitho vaktumArebhire jagati yasyAgamanaM bhaviSyati sa evAyam avazyaM bhaviSyadvakttA| ");
INSERT INTO sanhk_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ataeva lokA Agatya tamAkramya rAjAnaM kariSyanti yIzusteSAm IdRzaM mAnasaM vijJAya punazca parvvatam ekAkI gatavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","sAyaMkAla upasthite ziSyA jaladhitaTaM vrajitvA nAvamAruhya nagaradizi sindhau vAhayitvAgaman| ");
INSERT INTO sanhk_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","tasmin samaye timira upAtiSThat kintu yISusteSAM samIpaM nAgacchat| ");
INSERT INTO sanhk_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","tadA prabalapavanavahanAt sAgare mahAtaraGgo bhavitum Arebhe| ");
INSERT INTO sanhk_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","tataste vAhayitvA dvitrAn krozAn gatAH pazcAd yIzuM jaladherupari padbhyAM vrajantaM naukAntikam AgacchantaM vilokya trAsayuktA abhavan ");
INSERT INTO sanhk_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","kintu sa tAnukttavAn ayamahaM mA bhaiSTa| ");
INSERT INTO sanhk_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","tadA te taM svairaM nAvi gRhItavantaH tadA tatkSaNAd uddiSTasthAne naurupAsthAt| ");
INSERT INTO sanhk_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","yayA nAvA ziSyA agacchan tadanyA kApi naukA tasmin sthAne nAsIt tato yIzuH ziSyaiH sAkaM nAgamat kevalAH ziSyA agaman etat pArasthA lokA jJAtavantaH| ");
INSERT INTO sanhk_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","kintu tataH paraM prabhu ryatra Izvarasya guNAn anukIrttya lokAn pUpAn abhojayat tatsthAnasya samIpasthativiriyAyA aparAstaraNaya Agaman| ");
INSERT INTO sanhk_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","yIzustatra nAsti ziSyA api tatra nA santi lokA iti vijJAya yIzuM gaveSayituM taraNibhiH kapharnAhUm puraM gatAH| ");
INSERT INTO sanhk_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","tataste saritpateH pAre taM sAkSAt prApya prAvocan he guro bhavAn atra sthAne kadAgamat? ");
INSERT INTO sanhk_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","tadA yIzustAn pratyavAdId yuSmAnahaM yathArthataraM vadAmi AzcaryyakarmmadarzanAddheto rna kintu pUpabhojanAt tena tRptatvAJca mAM gaveSayatha| ");
INSERT INTO sanhk_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","kSayaNIyabhakSyArthaM mA zrAmiSTa kintvantAyurbhakSyArthaM zrAmyata, tasmAt tAdRzaM bhakSyaM manujaputro yuSmAbhyaM dAsyati; tasmin tAta IzvaraH pramANaM prAdAt| ");
INSERT INTO sanhk_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","tadA te'pRcchan IzvarAbhimataM karmma karttum asmAbhiH kiM karttavyaM? ");
INSERT INTO sanhk_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","tato yIzuravadad Izvaro yaM prairayat tasmin vizvasanam IzvarAbhimataM karmma| ");
INSERT INTO sanhk_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","tadA te vyAharan bhavatA kiM lakSaNaM darzitaM yaddRSTvA bhavati vizvasiSyAmaH? tvayA kiM karmma kRtaM? ");
INSERT INTO sanhk_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","asmAkaM pUrvvapuruSA mahAprAntare mAnnAM bhokttuM prApuH yathA lipirAste| svargIyANi tu bhakSyANi pradadau paramezvaraH| ");
INSERT INTO sanhk_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","tadA yIzuravadad ahaM yuSmAnatiyathArthaM vadAmi mUsA yuSmAbhyaM svargIyaM bhakSyaM nAdAt kintu mama pitA yuSmAbhyaM svargIyaM paramaM bhakSyaM dadAti| ");
INSERT INTO sanhk_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","yaH svargAdavaruhya jagate jIvanaM dadAti sa IzvaradattabhakSyarUpaH| ");
INSERT INTO sanhk_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","tadA te prAvocan he prabho bhakSyamidaM nityamasmabhyaM dadAtu| ");
INSERT INTO sanhk_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","yIzuravadad ahameva jIvanarUpaM bhakSyaM yo jano mama sannidhim Agacchati sa jAtu kSudhArtto na bhaviSyati, tathA yo jano mAM pratyeti sa jAtu tRSArtto na bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","mAM dRSTvApi yUyaM na vizvasitha yuSmAnaham ityavocaM| ");
INSERT INTO sanhk_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","pitA mahyaM yAvato lokAnadadAt te sarvva eva mamAntikam AgamiSyanti yaH kazcicca mama sannidhim AyAsyati taM kenApi prakAreNa na dUrIkariSyAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","nijAbhimataM sAdhayituM na hi kintu prerayiturabhimataM sAdhayituM svargAd Agatosmi| ");
INSERT INTO sanhk_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","sa yAn yAn lokAn mahyamadadAt teSAmekamapi na hArayitvA zeSadine sarvvAnaham utthApayAmi idaM matprerayituH piturabhimataM| ");
INSERT INTO sanhk_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","yaH kazcin mAnavasutaM vilokya vizvasiti sa zeSadine mayotthApitaH san anantAyuH prApsyati iti matprerakasyAbhimataM| ");
INSERT INTO sanhk_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","tadA svargAd yad bhakSyam avArohat tad bhakSyam ahameva yihUdIyalokAstasyaitad vAkye vivadamAnA vakttumArebhire ");
INSERT INTO sanhk_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","yUSaphaH putro yIzu ryasya mAtApitarau vayaM jAnIma eSa kiM saeva na? tarhi svargAd avAroham iti vAkyaM kathaM vaktti? ");
INSERT INTO sanhk_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","tadA yIzustAn pratyavadat parasparaM mA vivadadhvaM ");
INSERT INTO sanhk_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","matprerakeNa pitrA nAkRSTaH kopi jano mamAntikam AyAtuM na zaknoti kintvAgataM janaM carame'hni protthApayiSyAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","te sarvva IzvareNa zikSitA bhaviSyanti bhaviSyadvAdinAM grantheSu lipiritthamAste ato yaH kazcit pituH sakAzAt zrutvA zikSate sa eva mama samIpam AgamiSyati| ");
INSERT INTO sanhk_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ya IzvarAd ajAyata taM vinA kopi manuSyo janakaM nAdarzat kevalaH saeva tAtam adrAkSIt| ");
INSERT INTO sanhk_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","ahaM yuSmAn yathArthataraM vadAmi yo jano mayi vizvAsaM karoti sonantAyuH prApnoti| ");
INSERT INTO sanhk_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ahameva tajjIvanabhakSyaM| ");
INSERT INTO sanhk_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","yuSmAkaM pUrvvapuruSA mahAprAntare mannAbhakSyaM bhUkttApi mRtAH ");
INSERT INTO sanhk_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","kintu yadbhakSyaM svargAdAgacchat tad yadi kazcid bhuGktte tarhi sa na mriyate| ");
INSERT INTO sanhk_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","yajjIvanabhakSyaM svargAdAgacchat sohameva idaM bhakSyaM yo jano bhuGktte sa nityajIvI bhaviSyati| punazca jagato jIvanArthamahaM yat svakIyapizitaM dAsyAmi tadeva mayA vitaritaM bhakSyam| ");
INSERT INTO sanhk_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","tasmAd yihUdIyAH parasparaM vivadamAnA vakttumArebhire eSa bhojanArthaM svIyaM palalaM katham asmabhyaM dAsyati? ");
INSERT INTO sanhk_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","tadA yIzustAn Avocad yuSmAnahaM yathArthataraM vadAmi manuSyaputrasyAmiSe yuSmAbhi rna bhuktte tasya rudhire ca na pIte jIvanena sArddhaM yuSmAkaM sambandho nAsti| ");
INSERT INTO sanhk_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","yo mamAmiSaM svAdati mama sudhiraJca pivati sonantAyuH prApnoti tataH zeSe'hni tamaham utthApayiSyAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","yato madIyamAmiSaM paramaM bhakSyaM tathA madIyaM zoNitaM paramaM peyaM| ");
INSERT INTO sanhk_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","yo jano madIyaM palalaM svAdati madIyaM rudhiraJca pivati sa mayi vasati tasminnahaJca vasAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","matprerayitrA jIvatA tAtena yathAhaM jIvAmi tadvad yaH kazcin mAmatti sopi mayA jIviSyati| ");
INSERT INTO sanhk_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","yadbhakSyaM svargAdAgacchat tadidaM yanmAnnAM svAditvA yuSmAkaM pitaro'mriyanta tAdRzam idaM bhakSyaM na bhavati idaM bhakSyaM yo bhakSati sa nityaM jIviSyati| ");
INSERT INTO sanhk_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","yadA kapharnAhUm puryyAM bhajanagehe upAdizat tadA kathA etA akathayat| ");
INSERT INTO sanhk_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","tadetthaM zrutvA tasya ziSyANAm aneke parasparam akathayan idaM gADhaM vAkyaM vAkyamIdRzaM kaH zrotuM zakruyAt? ");
INSERT INTO sanhk_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","kintu yIzuH ziSyANAm itthaM vivAdaM svacitte vijJAya kathitavAn idaM vAkyaM kiM yuSmAkaM vighnaM janayati? ");
INSERT INTO sanhk_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","yadi manujasutaM pUrvvavAsasthAnam UrdvvaM gacchantaM pazyatha tarhi kiM bhaviSyati? ");
INSERT INTO sanhk_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Atmaiva jIvanadAyakaH vapu rniSphalaM yuSmabhyamahaM yAni vacAMsi kathayAmi tAnyAtmA jIvanaJca| ");
INSERT INTO sanhk_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","kintu yuSmAkaM madhye kecana avizvAsinaH santi ke ke na vizvasanti ko vA taM parakareSu samarpayiSyati tAn yIzurAprathamAd vetti| ");
INSERT INTO sanhk_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","aparamapi kathitavAn asmAt kAraNAd akathayaM pituH sakAzAt zakttimaprApya kopi mamAntikam AgantuM na zaknoti| ");
INSERT INTO sanhk_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","tatkAle'neke ziSyA vyAghuTya tena sArddhaM puna rnAgacchan| ");
INSERT INTO sanhk_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","tadA yIzu rdvAdazaziSyAn ukttavAn yUyamapi kiM yAsyatha? ");
INSERT INTO sanhk_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","tataH zimon pitaraH pratyavocat he prabho kasyAbhyarNaM gamiSyAmaH? ");
INSERT INTO sanhk_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","anantajIvanadAyinyo yAH kathAstAstavaiva| bhavAn amarezvarasyAbhiSikttaputra iti vizvasya nizcitaM jAnImaH| ");
INSERT INTO sanhk_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","tadA yIzuravadat kimahaM yuSmAkaM dvAdazajanAn manonItAn na kRtavAn? kintu yuSmAkaM madhyepi kazcideko vighnakArI vidyate| ");
INSERT INTO sanhk_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","imAM kathaM sa zimonaH putram ISkarIyotIyaM yihUdAm uddizya kathitavAn yato dvAdazAnAM madhye gaNitaH sa taM parakareSu samarpayiSyati| ");
INSERT INTO sanhk_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","tataH paraM yihUdIyalokAstaM hantuM samaihanta tasmAd yIzu ryihUdApradeze paryyaTituM necchan gAlIl pradeze paryyaTituM prArabhata| ");
INSERT INTO sanhk_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","kintu tasmin samaye yihUdIyAnAM dUSyavAsanAmotsava upasthite ");
INSERT INTO sanhk_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","tasya bhrAtarastam avadan yAni karmmANi tvayA kriyante tAni yathA tava ziSyAH pazyanti tadarthaM tvamitaH sthAnAd yihUdIyadezaM vraja| ");
INSERT INTO sanhk_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","yaH kazcit svayaM pracikAziSati sa kadApi guptaM karmma na karoti yadIdRzaM karmma karoSi tarhi jagati nijaM paricAyaya| ");
INSERT INTO sanhk_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","yatastasya bhrAtaropi taM na vizvasanti| ");
INSERT INTO sanhk_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","tadA yIzustAn avocat mama samaya idAnIM nopatiSThati kintu yuSmAkaM samayaH satatam upatiSThati| ");
INSERT INTO sanhk_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","jagato lokA yuSmAn RtIyituM na zakruvanti kintu mAmeva RtIyante yatasteSAM karmANi duSTAni tatra sAkSyamidam ahaM dadAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","ataeva yUyam utsave'smin yAta nAham idAnIm asminnutsave yAmi yato mama samaya idAnIM na sampUrNaH| ");
INSERT INTO sanhk_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","iti vAkyam ukttvA sa gAlIli sthitavAn ");
INSERT INTO sanhk_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","kintu tasya bhrAtRSu tatra prasthiteSu satsu so'prakaTa utsavam agacchat| ");
INSERT INTO sanhk_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","anantaram utsavam upasthitA yihUdIyAstaM mRgayitvApRcchan sa kutra? ");
INSERT INTO sanhk_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","tato lokAnAM madhye tasmin nAnAvidhA vivAdA bhavitum ArabdhavantaH| kecid avocan sa uttamaH puruSaH kecid avocan na tathA varaM lokAnAM bhramaM janayati| ");
INSERT INTO sanhk_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","kintu yihUdIyAnAM bhayAt kopi tasya pakSe spaSTaM nAkathayat| ");
INSERT INTO sanhk_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","tataH param utsavasya madhyasamaye yIzu rmandiraM gatvA samupadizati sma| ");
INSERT INTO sanhk_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","tato yihUdIyA lokA AzcaryyaM jJAtvAkathayan eSA mAnuSo nAdhItyA katham etAdRzo vidvAnabhUt? ");
INSERT INTO sanhk_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","tadA yIzuH pratyavocad upadezoyaM na mama kintu yo mAM preSitavAn tasya| ");
INSERT INTO sanhk_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","yo jano nidezaM tasya grahISyati mamopadezo matto bhavati kim IzvarAd bhavati sa ganastajjJAtuM zakSyati| ");
INSERT INTO sanhk_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","yo janaH svataH kathayati sa svIyaM gauravam Ihate kintu yaH prerayitu rgauravam Ihate sa satyavAdI tasmin kopyadharmmo nAsti| ");
INSERT INTO sanhk_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","mUsA yuSmabhyaM vyavasthAgranthaM kiM nAdadAt? kintu yuSmAkaM kopi tAM vyavasthAM na samAcarati| mAM hantuM kuto yatadhve? ");
INSERT INTO sanhk_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","tadA lokA avadan tvaM bhUtagrastastvAM hantuM ko yatate? ");
INSERT INTO sanhk_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","tato yIzuravocad ekaM karmma mayAkAri tasmAd yUyaM sarvva mahAzcaryyaM manyadhve| ");
INSERT INTO sanhk_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","mUsA yuSmabhyaM tvakchedavidhiM pradadau sa mUsAto na jAtaH kintu pitRpuruSebhyo jAtaH tena vizrAmavAre'pi mAnuSANAM tvakchedaM kurutha| ");
INSERT INTO sanhk_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ataeva vizrAmavAre manuSyANAM tvakchede kRte yadi mUsAvyavasthAmaGganaM na bhavati tarhi mayA vizrAmavAre mAnuSaH sampUrNarUpeNa svastho'kAri tatkAraNAd yUyaM kiM mahyaM kupyatha? ");
INSERT INTO sanhk_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","sapakSapAtaM vicAramakRtvA nyAyyaM vicAraM kuruta| ");
INSERT INTO sanhk_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","tadA yirUzAlam nivAsinaH katipayajanA akathayan ime yaM hantuM ceSTante sa evAyaM kiM na? ");
INSERT INTO sanhk_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","kintu pazyata nirbhayaH san kathAM kathayati tathApi kimapi a vadantyete ayamevAbhiSiktto bhavatIti nizcitaM kimadhipatayo jAnanti? ");
INSERT INTO sanhk_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","manujoyaM kasmAdAgamad iti vayaM jAnomaH kintvabhiSiktta Agate sa kasmAdAgatavAn iti kopi jJAtuM na zakSyati| ");
INSERT INTO sanhk_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","tadA yIzu rmadhyemandiram upadizan uccaiHkAram ukttavAn yUyaM kiM mAM jAnItha? kasmAccAgatosmi tadapi kiM jAnItha? nAhaM svata Agatosmi kintu yaH satyavAdI saeva mAM preSitavAn yUyaM taM na jAnItha| ");
INSERT INTO sanhk_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","tamahaM jAne tenAhaM prerita agatosmi| ");
INSERT INTO sanhk_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","tasmAd yihUdIyAstaM dharttum udyatAstathApi kopi tasya gAtre hastaM nArpayad yato hetostadA tasya samayo nopatiSThati| ");
INSERT INTO sanhk_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","kintu bahavo lokAstasmin vizvasya kathitavAnto'bhiSikttapuruSa Agatya mAnuSasyAsya kriyAbhyaH kim adhikA AzcaryyAH kriyAH kariSyati? ");
INSERT INTO sanhk_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","tataH paraM lokAstasmin itthaM vivadante phirUzinaH pradhAnayAjakAJceti zrutavantastaM dhRtvA netuM padAtigaNaM preSayAmAsuH| ");
INSERT INTO sanhk_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","tato yIzuravadad aham alpadinAni yuSmAbhiH sArddhaM sthitvA matprerayituH samIpaM yAsyAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","mAM mRgayiSyadhve kintUddezaM na lapsyadhve ratra sthAsyAmi tatra yUyaM gantuM na zakSyatha| ");
INSERT INTO sanhk_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","tadA yihUdIyAH parasparaM vakttumArebhire asyoddezaM na prApsyAma etAdRzaM kiM sthAnaM yAsyati? bhinnadeze vikIrNAnAM yihUdIyAnAM sannidhim eSa gatvA tAn upadekSyati kiM? ");
INSERT INTO sanhk_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","no cet mAM gaveSayiSyatha kintUddezaM na prApsyatha eSa kodRzaM vAkyamidaM vadati? ");
INSERT INTO sanhk_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","anantaram utsavasya carame'hani arthAt pradhAnadine yIzuruttiSThan uccaiHkAram Ahvayan uditavAn yadi kazcit tRSArtto bhavati tarhi mamAntikam Agatya pivatu| ");
INSERT INTO sanhk_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","yaH kazcinmayi vizvasiti dharmmagranthasya vacanAnusAreNa tasyAbhyantarato'mRtatoyasya srotAMsi nirgamiSyanti| ");
INSERT INTO sanhk_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ye tasmin vizvasanti ta AtmAnaM prApsyantItyarthe sa idaM vAkyaM vyAhRtavAn etatkAlaM yAvad yIzu rvibhavaM na prAptastasmAt pavitra AtmA nAdIyata| ");
INSERT INTO sanhk_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","etAM vANIM zrutvA bahavo lokA avadan ayameva nizcitaM sa bhaviSyadvAdI| ");
INSERT INTO sanhk_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","kecid akathayan eSaeva sobhiSikttaH kintu kecid avadan sobhiSikttaH kiM gAlIl pradeze janiSyate? ");
INSERT INTO sanhk_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","sobhiSiktto dAyUdo vaMze dAyUdo janmasthAne baitlehami pattane janiSyate dharmmagranthe kimitthaM likhitaM nAsti? ");
INSERT INTO sanhk_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","itthaM tasmin lokAnAM bhinnavAkyatA jAtA| ");
INSERT INTO sanhk_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","katipayalokAstaM dharttum aicchan tathApi tadvapuSi kopi hastaM nArpayat| ");
INSERT INTO sanhk_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","anantaraM pAdAtigaNe pradhAnayAjakAnAM phirUzinAJca samIpamAgatavati te tAn apRcchan kuto hetostaM nAnayata? ");
INSERT INTO sanhk_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","tadA padAtayaH pratyavadan sa mAnava iva kopi kadApi nopAdizat| ");
INSERT INTO sanhk_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","tataH phirUzinaH prAvocan yUyamapi kimabhrAmiSTa? ");
INSERT INTO sanhk_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","adhipatInAM phirUzinAJca kopi kiM tasmin vyazvasIt? ");
INSERT INTO sanhk_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ye zAstraM na jAnanti ta ime'dhamalokAeva zApagrastAH| ");
INSERT INTO sanhk_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","tadA nikadImanAmA teSAmeko yaH kSaNadAyAM yIzoH sannidhim agAt sa ukttavAn ");
INSERT INTO sanhk_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","tasya vAkye na zrute karmmaNi ca na vidite 'smAkaM vyavasthA kiM kaJcana manujaM doSIkaroti? ");
INSERT INTO sanhk_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","tataste vyAharan tvamapi kiM gAlIlIyalokaH? vivicya pazya galIli kopi bhaviSyadvAdI notpadyate| ");
INSERT INTO sanhk_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","tataH paraM sarvve svaM svaM gRhaM gatAH kintu yIzu rjaitunanAmAnaM ziloccayaM gatavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","pratyUSe yIzuH panarmandiram Agacchat ");
INSERT INTO sanhk_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","tataH sarvveSu lokeSu tasya samIpa AgateSu sa upavizya tAn upadeSTum Arabhata| ");
INSERT INTO sanhk_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","tadA adhyApakAH phirUzinaJca vyabhicArakarmmaNi dhRtaM striyamekAm Aniya sarvveSAM madhye sthApayitvA vyAharan ");
INSERT INTO sanhk_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","he guro yoSitam imAM vyabhicArakarmma kurvvANAM lokA dhRtavantaH| ");
INSERT INTO sanhk_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","etAdRzalokAH pASANAghAtena hantavyA iti vidhirmUsAvyavasthAgranthe likhitosti kintu bhavAn kimAdizati? ");
INSERT INTO sanhk_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","te tamapavadituM parIkSAbhiprAyeNa vAkyamidam apRcchan kintu sa prahvIbhUya bhUmAvaGgalyA lekhitum Arabhata| ");
INSERT INTO sanhk_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","tatastaiH punaH punaH pRSTa utthAya kathitavAn yuSmAkaM madhye yo jano niraparAdhI saeva prathamam enAM pASANenAhantu| ");
INSERT INTO sanhk_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","pazcAt sa punazca prahvIbhUya bhUmau lekhitum Arabhata| ");
INSERT INTO sanhk_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","tAM kathaM zrutvA te svasvamanasi prabodhaM prApya jyeSThAnukramaM ekaikazaH sarvve bahiragacchan tato yIzurekAkI tayakttobhavat madhyasthAne daNDAyamAnA sA yoSA ca sthitA| ");
INSERT INTO sanhk_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","tatpazcAd yIzurutthAya tAM vanitAM vinA kamapyaparaM na vilokya pRSTavAn he vAme tavApavAdakAH kutra? kopi tvAM kiM na daNDayati? ");
INSERT INTO sanhk_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","sAvadat he maheccha kopi na tadA yIzuravocat nAhamapi daNDayAmi yAhi punaH pApaM mAkArSIH| ");
INSERT INTO sanhk_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","tato yIzuH punarapi lokebhya itthaM kathayitum Arabhata jagatohaM jyotiHsvarUpo yaH kazcin matpazcAda gacchati sa timire na bhramitvA jIvanarUpAM dIptiM prApsyati| ");
INSERT INTO sanhk_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","tataH phirUzino'vAdiSustvaM svArthe svayaM sAkSyaM dadAsi tasmAt tava sAkSyaM grAhyaM na bhavati| ");
INSERT INTO sanhk_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","tadA yIzuH pratyuditavAn yadyapi svArthe'haM svayaM sAkSyaM dadAmi tathApi mat sAkSyaM grAhyaM yasmAd ahaM kuta Agatosmi kva yAmi ca tadahaM jAnAmi kintu kuta Agatosmi kutra gacchAmi ca tad yUyaM na jAnItha| ");
INSERT INTO sanhk_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","yUyaM laukikaM vicArayatha nAhaM kimapi vicArayAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","kintu yadi vicArayAmi tarhi mama vicAro grahItavyo yatoham ekAkI nAsmi prerayitA pitA mayA saha vidyate| ");
INSERT INTO sanhk_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","dvayo rjanayoH sAkSyaM grahaNIyaM bhavatIti yuSmAkaM vyavasthAgranthe likhitamasti| ");
INSERT INTO sanhk_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ahaM svArthe svayaM sAkSitvaM dadAmi yazca mama tAto mAM preritavAn sopi madarthe sAkSyaM dadAti| ");
INSERT INTO sanhk_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","tadA te'pRcchan tava tAtaH kutra? tato yIzuH pratyavAdId yUyaM mAM na jAnItha matpitaraJca na jAnItha yadi mAm akSAsyata tarhi mama tAtamapyakSAsyata| ");
INSERT INTO sanhk_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","yIzu rmandira upadizya bhaNDAgAre kathA etA akathayat tathApi taM prati kopi karaM nodatolayat| ");
INSERT INTO sanhk_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","tataH paraM yIzuH punaruditavAn adhunAhaM gacchAmi yUyaM mAM gaveSayiSyatha kintu nijaiH pApai rmariSyatha yat sthAnam ahaM yAsyAmi tat sthAnam yUyaM yAtuM na zakSyatha| ");
INSERT INTO sanhk_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","tadA yihUdIyAH prAvocan kimayam AtmaghAtaM kariSyati? yato yat sthAnam ahaM yAsyAmi tat sthAnam yUyaM yAtuM na zakSyatha iti vAkyaM bravIti| ");
INSERT INTO sanhk_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","tato yIzustebhyaH kathitavAn yUyam adhaHsthAnIyA lokA aham UrdvvasthAnIyaH yUyam etajjagatsambandhIyA aham etajjagatsambandhIyo na| ");
INSERT INTO sanhk_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","tasmAt kathitavAn yUyaM nijaiH pApai rmariSyatha yatohaM sa pumAn iti yadi na vizvasitha tarhi nijaiH pApai rmariSyatha| ");
INSERT INTO sanhk_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","tadA te 'pRcchan kastvaM? tato yIzuH kathitavAn yuSmAkaM sannidhau yasya prastAvam A prathamAt karomi saeva puruSohaM| ");
INSERT INTO sanhk_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","yuSmAsu mayA bahuvAkyaM vakttavyaM vicArayitavyaJca kintu matprerayitA satyavAdI tasya samIpe yadahaM zrutavAn tadeva jagate kathayAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","kintu sa janake vAkyamidaM prokttavAn iti te nAbudhyanta| ");
INSERT INTO sanhk_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","tato yIzurakathayad yadA manuSyaputram Urdvva utthApayiSyatha tadAhaM sa pumAn kevalaH svayaM kimapi karmma na karomi kintu tAto yathA zikSayati tadanusAreNa vAkyamidaM vadAmIti ca yUyaM jJAtuM zakSyatha| ");
INSERT INTO sanhk_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","matprerayitA pitA mAm ekAkinaM na tyajati sa mayA sArddhaM tiSThati yatohaM tadabhimataM karmma sadA karomi| ");
INSERT INTO sanhk_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","tadA tasyaitAni vAkyAni zrutvA bahuvastAsmin vyazvasan| ");
INSERT INTO sanhk_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","ye yihUdIyA vyazvasan yIzustebhyo'kathayat ");
INSERT INTO sanhk_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","mama vAkye yadi yUyam AsthAM kurutha tarhi mama ziSyA bhUtvA satyatvaM jJAsyatha tataH satyatayA yuSmAkaM mokSo bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","tadA te pratyavAdiSuH vayam ibrAhImo vaMzaH kadApi kasyApi dAsA na jAtAstarhi yuSmAkaM muktti rbhaviSyatIti vAkyaM kathaM bravISi? ");
INSERT INTO sanhk_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","tadA yIzuH pratyavadad yuSmAnahaM yathArthataraM vadAmi yaH pApaM karoti sa pApasya dAsaH| ");
INSERT INTO sanhk_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","dAsazca nirantaraM nivezane na tiSThati kintu putro nirantaraM tiSThati| ");
INSERT INTO sanhk_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","ataH putro yadi yuSmAn mocayati tarhi nitAntameva mukttA bhaviSyatha| ");
INSERT INTO sanhk_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","yuyam ibrAhImo vaMza ityahaM jAnAmi kintu mama kathA yuSmAkam antaHkaraNeSu sthAnaM na prApnuvanti tasmAddheto rmAM hantum Ihadhve| ");
INSERT INTO sanhk_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ahaM svapituH samIpe yadapazyaM tadeva kathayAmi tathA yUyamapi svapituH samIpe yadapazyata tadeva kurudhve| ");
INSERT INTO sanhk_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","tadA te pratyavocan ibrAhIm asmAkaM pitA tato yIzurakathayad yadi yUyam ibrAhImaH santAnA abhaviSyata tarhi ibrAhIma AcAraNavad AcariSyata| ");
INSERT INTO sanhk_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Izvarasya mukhAt satyaM vAkyaM zrutvA yuSmAn jJApayAmi yohaM taM mAM hantuM ceSTadhve ibrAhIm etAdRzaM karmma na cakAra| ");
INSERT INTO sanhk_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","yUyaM svasvapituH karmmANi kurutha tadA tairukttaM na vayaM jArajAtA asmAkam ekaeva pitAsti sa evezvaraH ");
INSERT INTO sanhk_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","tato yIzunA kathitam Izvaro yadi yuSmAkaM tAtobhaviSyat tarhi yUyaM mayi premAkariSyata yatoham IzvarAnnirgatyAgatosmi svato nAgatohaM sa mAM prAhiNot| ");
INSERT INTO sanhk_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","yUyaM mama vAkyamidaM na budhyadhve kutaH? yato yUyaM mamopadezaM soDhuM na zaknutha| ");
INSERT INTO sanhk_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","yUyaM zaitAn pituH santAnA etasmAd yuSmAkaM piturabhilASaM pUrayatha sa A prathamAt naraghAtI tadantaH satyatvasya lezopi nAsti kAraNAdataH sa satyatAyAM nAtiSThat sa yadA mRSA kathayati tadA nijasvabhAvAnusAreNaiva kathayati yato sa mRSAbhASI mRSotpAdakazca| ");
INSERT INTO sanhk_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","ahaM tathyavAkyaM vadAmi kAraNAdasmAd yUyaM mAM na pratItha| ");
INSERT INTO sanhk_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","mayi pApamastIti pramANaM yuSmAkaM ko dAtuM zaknoti? yadyahaM tathyavAkyaM vadAmi tarhi kuto mAM na pratitha? ");
INSERT INTO sanhk_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","yaH kazcana IzvarIyo lokaH sa IzvarIyakathAyAM mano nidhatte yUyam IzvarIyalokA na bhavatha tannidAnAt tatra na manAMsi nidhadve| ");
INSERT INTO sanhk_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","tadA yihUdIyAH pratyavAdiSuH tvamekaH zomiroNIyo bhUtagrastazca vayaM kimidaM bhadraM nAvAdiSma? ");
INSERT INTO sanhk_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","tato yIzuH pratyavAdIt nAhaM bhUtagrastaH kintu nijatAtaM sammanye tasmAd yUyaM mAm apamanyadhve| ");
INSERT INTO sanhk_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","ahaM svasukhyAtiM na ceSTe kintu ceSTitA vicArayitA cApara eka Aste| ");
INSERT INTO sanhk_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ahaM yuSmabhyam atIva yathArthaM kathayAmi yo naro madIyaM vAcaM manyate sa kadAcana nidhanaM na drakSyati| ");
INSERT INTO sanhk_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","yihUdIyAstamavadan tvaM bhUtagrasta itIdAnIm avaiSma| ibrAhIm bhaviSyadvAdinaJca sarvve mRtAH kintu tvaM bhASase yo naro mama bhAratIM gRhlAti sa jAtu nidhAnAsvAdaM na lapsyate| ");
INSERT INTO sanhk_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","tarhi tvaM kim asmAkaM pUrvvapuruSAd ibrAhImopi mahAn? yasmAt sopi mRtaH bhaviSyadvAdinopi mRtAH tvaM svaM kaM pumAMsaM manuSe? ");
INSERT INTO sanhk_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","yIzuH pratyavocad yadyahaM svaM svayaM sammanye tarhi mama tat sammananaM kimapi na kintu mama tAto yaM yUyaM svIyam IzvaraM bhASadhve saeva mAM sammanute| ");
INSERT INTO sanhk_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","yUyaM taM nAvagacchatha kintvahaM tamavagacchAmi taM nAvagacchAmIti vAkyaM yadi vadAmi tarhi yUyamiva mRSAbhASI bhavAmi kintvahaM tamavagacchAmi tadAkSAmapi gRhlAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","yuSmAkaM pUrvvapuruSa ibrAhIm mama samayaM draSTum atIvAvAJchat tannirIkSyAnandacca| ");
INSERT INTO sanhk_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","tadA yihUdIyA apRcchan tava vayaH paJcAzadvatsarA na tvaM kim ibrAhImam adrAkSIH? ");
INSERT INTO sanhk_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","yIzuH pratyavAdId yuSmAnahaM yathArthataraM vadAmi ibrAhImo janmanaH pUrvvakAlamArabhyAhaM vidye| ");
INSERT INTO sanhk_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","tadA te pASANAn uttolya tamAhantum udayacchan kintu yIzu rgupto mantirAd bahirgatya teSAM madhyena prasthitavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","tataH paraM yIzurgacchan mArgamadhye janmAndhaM naram apazyat| ");
INSERT INTO sanhk_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","tataH ziSyAstam apRcchan he guro naroyaM svapApena vA svapitrAH pApenAndho'jAyata? ");
INSERT INTO sanhk_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","tataH sa pratyuditavAn etasya vAsya pitroH pApAd etAdRzobhUda iti nahi kintvanena yathezvarasya karmma prakAzyate taddhetoreva| ");
INSERT INTO sanhk_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","dine tiSThati matprerayituH karmma mayA karttavyaM yadA kimapi karmma na kriyate tAdRzI nizAgacchati| ");
INSERT INTO sanhk_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ahaM yAvatkAlaM jagati tiSThAmi tAvatkAlaM jagato jyotiHsvarUposmi| ");
INSERT INTO sanhk_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ityukttA bhUmau niSThIvaM nikSipya tena paGkaM kRtavAn ");
INSERT INTO sanhk_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","pazcAt tatpaGkena tasyAndhasya netre pralipya tamityAdizat gatvA zilohe 'rthAt preritanAmni sarasi snAhi| tatondho gatvA tatrAsnAt tataH prannacakSu rbhUtvA vyAghuTyAgAt| ");
INSERT INTO sanhk_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","aparaJca samIpavAsino lokA ye ca taM pUrvvamandham apazyan te bakttum Arabhanta yondhaloko vartmanyupavizyAbhikSata sa evAyaM janaH kiM na bhavati? ");
INSERT INTO sanhk_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","kecidavadan sa eva kecidavocan tAdRzo bhavati kintu sa svayamabravIt sa evAhaM bhavAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ataeva te 'pRcchan tvaM kathaM dRSTiM pAptavAn? ");
INSERT INTO sanhk_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","tataH sovadad yIzanAmaka eko jano mama nayane paGkena pralipya ityAjJApayat zilohakAsAraM gatvA tatra snAhi| tatastatra gatvA mayi snAte dRSTimahaM labdhavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","tadA te 'vadan sa pumAn kutra? tenokttaM nAhaM jAnAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","aparaM tasmin pUrvvAndhe jane phirUzinAM nikaTam AnIte sati phirUzinopi tamapRcchan kathaM dRSTiM prAptosi? ");
INSERT INTO sanhk_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","tataH sa kathitavAn sa paGkena mama netre 'limpat pazcAd snAtvA dRSTimalabhe| ");
INSERT INTO sanhk_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","kintu yIzu rvizrAmavAre karddamaM kRtvA tasya nayane prasanne'karod itikAraNAt katipayaphirUzino'vadan ");
INSERT INTO sanhk_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","sa pumAn IzvarAnna yataH sa vizrAmavAraM na manyate| tatonye kecit pratyavadan pApI pumAn kim etAdRzam AzcaryyaM karmma karttuM zaknoti? ");
INSERT INTO sanhk_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","itthaM teSAM parasparaM bhinnavAkyatvam abhavat| pazcAt te punarapi taM pUrvvAndhaM mAnuSam aprAkSuH yo janastava cakSuSI prasanne kRtavAn tasmin tvaM kiM vadasi? sa ukttavAn sa bhavizadvAdI| ");
INSERT INTO sanhk_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","sa dRSTim AptavAn iti yihUdIyAstasya dRSTiM prAptasya janasya pitro rmukhAd azrutvA na pratyayan| ");
INSERT INTO sanhk_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ataeva te tAvapRcchan yuvayo ryaM putraM janmAndhaM vadathaH sa kimayaM? tarhIdAnIM kathaM draSTuM zaknoti? ");
INSERT INTO sanhk_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","tatastasya pitarau pratyavocatAm ayam AvayoH putra A janerandhazca tadapyAvAM jAnIvaH ");
INSERT INTO sanhk_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","kintvadhunA kathaM dRSTiM prAptavAn tadAvAM n jAnIvaH kosya cakSuSI prasanne kRtavAn tadapi na jAnIva eSa vayaHprApta enaM pRcchata svakathAM svayaM vakSyati| ");
INSERT INTO sanhk_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","yihUdIyAnAM bhayAt tasya pitarau vAkyamidam avadatAM yataH kopi manuSyo yadi yIzum abhiSiktaM vadati tarhi sa bhajanagRhAd dUrIkAriSyate yihUdIyA iti mantraNAm akurvvan ");
INSERT INTO sanhk_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","atastasya pitarau vyAharatAm eSa vayaHprApta enaM pRcchata| ");
INSERT INTO sanhk_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","tadA te punazca taM pUrvvAndham AhUya vyAharan Izvarasya guNAn vada eSa manuSyaH pApIti vayaM jAnImaH| ");
INSERT INTO sanhk_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","tadA sa ukttavAn sa pApI na veti nAhaM jAne pUrvAmandha Asamaham adhunA pazyAmIti mAtraM jAnAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","te punarapRcchan sa tvAM prati kimakarot? kathaM netre prasanne 'karot? ");
INSERT INTO sanhk_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","tataH sovAdId ekakRtvokathayaM yUyaM na zRNutha tarhi kutaH punaH zrotum icchatha? yUyamapi kiM tasya ziSyA bhavitum icchatha? ");
INSERT INTO sanhk_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","tadA te taM tiraskRtya vyAharan tvaM tasya ziSyo vayaM mUsAH ziSyAH| ");
INSERT INTO sanhk_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","mUsAvaktreNezvaro jagAda tajjAnImaH kintveSa kutratyaloka iti na jAnImaH| ");
INSERT INTO sanhk_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","sovadad eSa mama locane prasanne 'karot tathApi kutratyaloka iti yUyaM na jAnItha etad AzcaryyaM bhavati| ");
INSERT INTO sanhk_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","IzvaraH pApinAM kathAM na zRNoti kintu yo janastasmin bhaktiM kRtvA tadiSTakriyAM karoti tasyaiva kathAM zRNoti etad vayaM jAnImaH| ");
INSERT INTO sanhk_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","kopi manuSyo janmAndhAya cakSuSI adadAt jagadArambhAd etAdRzIM kathAM kopi kadApi nAzRNot| ");
INSERT INTO sanhk_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","asmAd eSa manuSyo yadIzvarAnnAjAyata tarhi kiJcidapIdRzaM karmma karttuM nAzaknot| ");
INSERT INTO sanhk_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","te vyAharan tvaM pApAd ajAyathAH kimasmAn tvaM zikSayasi? pazcAtte taM bahirakurvvan| ");
INSERT INTO sanhk_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","tadanantaraM yihUdIyaiH sa bahirakriyata yIzuriti vArttAM zrutvA taM sAkSAt prApya pRSTavAn Izvarasya putre tvaM vizvasiSi? ");
INSERT INTO sanhk_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","tadA sa pratyavocat he prabho sa ko yat tasminnahaM vizvasimi? ");
INSERT INTO sanhk_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","tato yIzuH kathitavAn tvaM taM dRSTavAn tvayA sAkaM yaH kathaM kathayati saeva saH| ");
INSERT INTO sanhk_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","tadA he prabho vizvasimItyuktvA sa taM praNAmat| ");
INSERT INTO sanhk_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","pazcAd yIzuH kathitavAn nayanahInA nayanAni prApnuvanti nayanavantazcAndhA bhavantItyabhiprAyeNa jagadAham Agaccham| ");
INSERT INTO sanhk_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","etat zrutvA nikaTasthAH katipayAH phirUzino vyAharan vayamapi kimandhAH? ");
INSERT INTO sanhk_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","tadA yIzuravAdId yadyandhA abhavata tarhi pApAni nAtiSThan kintu pazyAmIti vAkyavadanAd yuSmAkaM pApAni tiSThanti| ");
INSERT INTO sanhk_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ahaM yuSmAnatiyathArthaM vadAmi, yo jano dvAreNa na pravizya kenApyanyena meSagRhaM pravizati sa eva steno dasyuzca| ");
INSERT INTO sanhk_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","yo dvAreNa pravizati sa eva meSapAlakaH| ");
INSERT INTO sanhk_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","dauvArikastasmai dvAraM mocayati meSagaNazca tasya vAkyaM zRNoti sa nijAn meSAn svasvanAmnAhUya bahiH kRtvA nayati| ");
INSERT INTO sanhk_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","tathA nijAn meSAn bahiH kRtvA svayaM teSAm agre gacchati, tato meSAstasya zabdaM budhyante, tasmAt tasya pazcAd vrajanti| ");
INSERT INTO sanhk_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","kintu parasya zabdaM na budhyante tasmAt tasya pazcAd vrajiSyanti varaM tasya samIpAt palAyiSyante| ");
INSERT INTO sanhk_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","yIzustebhya imAM dRSTAntakathAm akathayat kintu tena kathitakathAyAstAtparyyaM te nAbudhyanta| ");
INSERT INTO sanhk_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","ato yIzuH punarakathayat, yuSmAnAhaM yathArthataraM vyAharAmi, meSagRhasya dvAram ahameva| ");
INSERT INTO sanhk_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","mayA na pravizya ya Agacchan te stenA dasyavazca kintu meSAsteSAM kathA nAzRNvan| ");
INSERT INTO sanhk_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","ahameva dvArasvarUpaH, mayA yaH kazcita pravizati sa rakSAM prApsyati tathA bahirantazca gamanAgamane kRtvA caraNasthAnaM prApsyati| ");
INSERT INTO sanhk_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","yo janastenaH sa kevalaM stainyabadhavinAzAn karttumeva samAyAti kintvaham Ayu rdAtum arthAt bAhUlyena tadeva dAtum Agaccham| ");
INSERT INTO sanhk_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","ahameva satyameSapAlako yastu satyo meSapAlakaH sa meSArthaM prANatyAgaM karoti; ");
INSERT INTO sanhk_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","kintu yo jano meSapAlako na, arthAd yasya meSA nijA na bhavanti, ya etAdRzo vaitanikaH sa vRkam AgacchantaM dRSTvA mejavrajaM vihAya palAyate, tasmAd vRkastaM vrajaM dhRtvA vikirati| ");
INSERT INTO sanhk_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","vaitanikaH palAyate yataH sa vetanArthI meSArthaM na cintayati| ");
INSERT INTO sanhk_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","ahameva satyo meSapAlakaH, pitA mAM yathA jAnAti, ahaJca yathA pitaraM jAnAmi, ");
INSERT INTO sanhk_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","tathA nijAn meSAnapi jAnAmi, meSAzca mAM jAnAnti, ahaJca meSArthaM prANatyAgaM karomi| ");
INSERT INTO sanhk_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","aparaJca etad gRhIya meSebhyo bhinnA api meSA mama santi te sakalA AnayitavyAH; te mama zabdaM zroSyanti tata eko vraja eko rakSako bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","prANAnahaM tyaktvA punaH prANAn grahISyAmi, tasmAt pitA mayi snehaM karoti| ");
INSERT INTO sanhk_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","kazcijjano mama prANAn hantuM na zaknoti kintu svayaM tAn samarpayAmi tAn samarpayituM punargrahItuJca mama zaktirAste bhAramimaM svapituH sakAzAt prAptoham| ");
INSERT INTO sanhk_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","asmAdupadezAt punazca yihUdIyAnAM madhye bhinnavAkyatA jAtA| ");
INSERT INTO sanhk_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","tato bahavo vyAharan eSa bhUtagrasta unmattazca, kuta etasya kathAM zRNutha? ");
INSERT INTO sanhk_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","kecid avadan etasya kathA bhUtagrastasya kathAvanna bhavanti, bhUtaH kim andhAya cakSuSI dAtuM zaknoti? ");
INSERT INTO sanhk_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","zItakAle yirUzAlami mandirotsargaparvvaNyupasthite ");
INSERT INTO sanhk_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","yIzuH sulemAno niHsAreNa gamanAgamane karoti, ");
INSERT INTO sanhk_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","etasmin samaye yihUdIyAstaM veSTayitvA vyAharan kati kAlAn asmAkaM vicikitsAM sthApayiSyAmi? yadyabhiSikto bhavati tarhi tat spaSTaM vada| ");
INSERT INTO sanhk_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","tadA yIzuH pratyavadad aham acakathaM kintu yUyaM na pratItha, nijapitu rnAmnA yAM yAM kriyAM karomi sA kriyaiva mama sAkSisvarUpA| ");
INSERT INTO sanhk_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","kintvahaM pUrvvamakathayaM yUyaM mama meSA na bhavatha, kAraNAdasmAn na vizvasitha| ");
INSERT INTO sanhk_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","mama meSA mama zabdaM zRNvanti tAnahaM jAnAmi te ca mama pazcAd gacchanti| ");
INSERT INTO sanhk_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ahaM tebhyo'nantAyu rdadAmi, te kadApi na naMkSyanti kopi mama karAt tAn harttuM na zakSyati| ");
INSERT INTO sanhk_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","yo mama pitA tAn mahyaM dattavAn sa sarvvasmAt mahAn, kopi mama pituH karAt tAn harttuM na zakSyati| ");
INSERT INTO sanhk_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ahaM pitA ca dvayorekatvam| ");
INSERT INTO sanhk_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","tato yihUdIyAH punarapi taM hantuM pASANAn udatolayan| ");
INSERT INTO sanhk_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","yIzuH kathitavAn pituH sakAzAd bahUnyuttamakarmmANi yuSmAkaM prAkAzayaM teSAM kasya karmmaNaH kAraNAn mAM pASANairAhantum udyatAH stha? ");
INSERT INTO sanhk_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","yihUdIyAH pratyavadan prazastakarmmaheto rna kintu tvaM mAnuSaH svamIzvaram uktvezvaraM nindasi kAraNAdasmAt tvAM pASANairhanmaH| ");
INSERT INTO sanhk_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","tadA yIzuH pratyuktavAn mayA kathitaM yUyam IzvarA etadvacanaM yuSmAkaM zAstre likhitaM nAsti kiM? ");
INSERT INTO sanhk_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","tasmAd yeSAm uddeze Izvarasya kathA kathitA te yadIzvaragaNA ucyante dharmmagranthasyApyanyathA bhavituM na zakyaM, ");
INSERT INTO sanhk_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","tarhyAham Izvarasya putra iti vAkyasya kathanAt yUyaM pitrAbhiSiktaM jagati preritaJca pumAMsaM katham IzvaranindakaM vAdaya? ");
INSERT INTO sanhk_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","yadyahaM pituH karmma na karomi tarhi mAM na pratIta; ");
INSERT INTO sanhk_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","kintu yadi karomi tarhi mayi yuSmAbhiH pratyaye na kRte'pi kAryye pratyayaH kriyatAM, tato mayi pitAstIti pitaryyaham asmIti ca kSAtvA vizvasiSyatha| ");
INSERT INTO sanhk_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","tadA te punarapi taM dharttum aceSTanta kintu sa teSAM karebhyo nistIryya ");
INSERT INTO sanhk_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","puna ryarddan adyAstaTe yatra purvvaM yohan amajjayat tatrAgatya nyavasat| ");
INSERT INTO sanhk_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","tato bahavo lokAstatsamIpam Agatya vyAharan yohan kimapyAzcaryyaM karmma nAkarot kintvasmin manuSye yA yaH kathA akathayat tAH sarvvAH satyAH; ");
INSERT INTO sanhk_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","tatra ca bahavo lokAstasmin vyazvasan| ");
INSERT INTO sanhk_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","anantaraM mariyam tasyA bhaginI marthA ca yasmin vaithanIyAgrAme vasatastasmin grAme iliyAsar nAmA pIDita eka AsIt| ");
INSERT INTO sanhk_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","yA mariyam prabhuM sugandhitelaina marddayitvA svakezaistasya caraNau samamArjat tasyA bhrAtA sa iliyAsar rogI| ");
INSERT INTO sanhk_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","aparaJca he prabho bhavAn yasmin prIyate sa eva pIDitostIti kathAM kathayitvA tasya bhaginyau preSitavatyau| ");
INSERT INTO sanhk_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","tadA yIzurimAM vArttAM zrutvAkathayata pIDeyaM maraNArthaM na kintvIzvarasya mahimArtham Izvaraputrasya mahimaprakAzArthaJca jAtA| ");
INSERT INTO sanhk_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","yIzu ryadyapimarthAyAM tadbhaginyAm iliyAsari cAprIyata, ");
INSERT INTO sanhk_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","tathApi iliyAsaraH pIDAyAH kathaM zrutvA yatra AsIt tatraiva dinadvayamatiSThat| ");
INSERT INTO sanhk_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","tataH param sa ziSyAnakathayad vayaM puna ryihUdIyapradezaM yAmaH| ");
INSERT INTO sanhk_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","tataste pratyavadan, he guro svalpadinAni gatAni yihUdIyAstvAM pASANai rhantum udyatAstathApi kiM punastatra yAsyasi? ");
INSERT INTO sanhk_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","yIzuH pratyavadat, ekasmin dine kiM dvAdazaghaTikA na bhavanti? kopi divA gacchan na skhalati yataH sa etajjagato dIptiM prApnoti| ");
INSERT INTO sanhk_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","kintu rAtrau gacchan skhalati yato hetostatra dIpti rnAsti| ");
INSERT INTO sanhk_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","imAM kathAM kathayitvA sa tAnavadad, asmAkaM bandhuH iliyAsar nidritobhUd idAnIM taM nidrAto jAgarayituM gacchAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","yIzu rmRtau kathAmimAM kathitavAn kintu vizrAmArthaM nidrAyAM kathitavAn iti jJAtvA ziSyA akathayan, ");
INSERT INTO sanhk_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","he guro sa yadi nidrAti tarhi bhadrameva| ");
INSERT INTO sanhk_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","tadA yIzuH spaSTaM tAn vyAharat, iliyAsar amriyata; ");
INSERT INTO sanhk_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","kintu yUyaM yathA pratItha tadarthamahaM tatra na sthitavAn ityasmAd yuSmannimittam AhlAditohaM, tathApi tasya samIpe yAma| ");
INSERT INTO sanhk_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","tadA thomA yaM didumaM vadanti sa saGginaH ziSyAn avadad vayamapi gatvA tena sArddhaM mriyAmahai| ");
INSERT INTO sanhk_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","yIzustatropasthAya iliyAsaraH zmazAne sthApanAt catvAri dinAni gatAnIti vArttAM zrutavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","vaithanIyA yirUzAlamaH samIpasthA krozaikamAtrAntaritA; ");
INSERT INTO sanhk_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","tasmAd bahavo yihUdIyA marthAM mariyamaJca bhyAtRzokApannAM sAntvayituM tayoH samIpam Agacchan| ");
INSERT INTO sanhk_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","marthA yIzorAgamanavArtAM zrutvaiva taM sAkSAd akarot kintu mariyam geha upavizya sthitA| ");
INSERT INTO sanhk_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","tadA marthA yIzumavAdat, he prabho yadi bhavAn atrAsthAsyat tarhi mama bhrAtA nAmariSyat| ");
INSERT INTO sanhk_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","kintvidAnImapi yad Izvare prArthayiSyate Izvarastad dAsyatIti jAne'haM| ");
INSERT INTO sanhk_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","yIzuravAdIt tava bhrAtA samutthAsyati| ");
INSERT INTO sanhk_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","marthA vyAharat zeSadivase sa utthAnasamaye protthAsyatIti jAne'haM| ");
INSERT INTO sanhk_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","tadA yIzuH kathitavAn ahameva utthApayitA jIvayitA ca yaH kazcana mayi vizvasiti sa mRtvApi jIviSyati; ");
INSERT INTO sanhk_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","yaH kazcana ca jIvan mayi vizvasiti sa kadApi na mariSyati, asyAM kathAyAM kiM vizvasiSi? ");
INSERT INTO sanhk_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","sAvadat prabho yasyAvataraNApekSAsti bhavAn saevAbhiSiktta Izvaraputra iti vizvasimi| ");
INSERT INTO sanhk_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","iti kathAM kathayitvA sA gatvA svAM bhaginIM mariyamaM guptamAhUya vyAharat gururupatiSThati tvAmAhUyati ca| ");
INSERT INTO sanhk_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","kathAmimAM zrutvA sA tUrNam utthAya tasya samIpam agacchat| ");
INSERT INTO sanhk_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","yIzu rgrAmamadhyaM na pravizya yatra marthA taM sAkSAd akarot tatra sthitavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","ye yihUdIyA mariyamA sAkaM gRhe tiSThantastAm asAntvayana te tAM kSipram utthAya gacchantiM vilokya vyAharan, sa zmazAne rodituM yAti, ityuktvA te tasyAH pazcAd agacchan| ");
INSERT INTO sanhk_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","yatra yIzuratiSThat tatra mariyam upasthAya taM dRSTvA tasya caraNayoH patitvA vyAharat he prabho yadi bhavAn atrAsthAsyat tarhi mama bhrAtA nAmariSyat| ");
INSERT INTO sanhk_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","yIzustAM tasyAH saGgino yihUdIyAMzca rudato vilokya zokArttaH san dIrghaM nizvasya kathitavAn taM kutrAsthApayata? ");
INSERT INTO sanhk_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","te vyAharan, he prabho bhavAn Agatya pazyatu| ");
INSERT INTO sanhk_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","yIzunA kranditaM| ");
INSERT INTO sanhk_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ataeva yihUdIyA avadan, pazyatAyaM tasmin kidRg apriyata| ");
INSERT INTO sanhk_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","teSAM kecid avadan yondhAya cakSuSI dattavAn sa kim asya mRtyuM nivArayituM nAzaknot? ");
INSERT INTO sanhk_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","tato yIzuH punarantardIrghaM nizvasya zmazAnAntikam agacchat| tat zmazAnam ekaM gahvaraM tanmukhe pASANa eka AsIt| ");
INSERT INTO sanhk_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","tadA yIzuravadad enaM pASANam apasArayata, tataH pramItasya bhaginI marthAvadat prabho, adhunA tatra durgandho jAtaH, yatodya catvAri dinAni zmazAne sa tiSThati| ");
INSERT INTO sanhk_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","tadA yIzuravAdIt, yadi vizvasiSi tarhIzvarasya mahimaprakAzaM drakSyasi kathAmimAM kiM tubhyaM nAkathayaM? ");
INSERT INTO sanhk_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","tadA mRtasya zmazAnAt pASANo'pasArite yIzurUrdvvaM pazyan akathayat, he pita rmama nevesanam azRNoH kAraNAdasmAt tvAM dhanyaM vadAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","tvaM satataM zRNoSi tadapyahaM jAnAmi, kintu tvaM mAM yat prairayastad yathAsmin sthAne sthitA lokA vizvasanti tadartham idaM vAkyaM vadAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","imAM kathAM kathayitvA sa proccairAhvayat, he iliyAsar bahirAgaccha| ");
INSERT INTO sanhk_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","tataH sa pramItaH zmazAnavastrai rbaddhahastapAdo gAtramArjanavAsasA baddhamukhazca bahirAgacchat| yIzuruditavAn bandhanAni mocayitvA tyajatainaM| ");
INSERT INTO sanhk_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","mariyamaH samIpam AgatA ye yihUdIyalokAstadA yIzoretat karmmApazyan teSAM bahavo vyazvasan, ");
INSERT INTO sanhk_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","kintu kecidanye phirUzinAM samIpaM gatvA yIzoretasya karmmaNo vArttAm avadan| ");
INSERT INTO sanhk_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","tataH paraM pradhAnayAjakAH phirUzinAzca sabhAM kRtvA vyAharan vayaM kiM kurmmaH? eSa mAnavo bahUnyAzcaryyakarmmANi karoti| ");
INSERT INTO sanhk_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","yadIdRzaM karmma karttuM na vArayAmastarhi sarvve lokAstasmin vizvasiSyanti romilokAzcAgatyAsmAkam anayA rAjadhAnyA sArddhaM rAjyam Achetsyanti| ");
INSERT INTO sanhk_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","tadA teSAM kiyaphAnAmA yastasmin vatsare mahAyAjakapade nyayujyata sa pratyavadad yUyaM kimapi na jAnItha; ");
INSERT INTO sanhk_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","samagradezasya vinAzatopi sarvvalokArtham ekasya janasya maraNam asmAkaM maGgalahetukam etasya vivecanAmapi na kurutha| ");
INSERT INTO sanhk_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","etAM kathAM sa nijabuddhyA vyAharad iti na, ");
INSERT INTO sanhk_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","kintu yIzUstaddezIyAnAM kAraNAt prANAn tyakSyati, dizi dizi vikIrNAn Izvarasya santAnAn saMgRhyaikajAtiM kariSyati ca, tasmin vatsare kiyaphA mahAyAjakatvapade niyuktaH san idaM bhaviSyadvAkyaM kathitavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","taddinamArabhya te kathaM taM hantuM zaknuvantIti mantraNAM karttuM prArebhire| ");
INSERT INTO sanhk_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ataeva yihUdIyAnAM madhye yIzuH saprakAzaM gamanAgamane akRtvA tasmAd gatvA prAntarasya samIpasthAyipradezasyephrAyim nAmni nagare ziSyaiH sAkaM kAlaM yApayituM prArebhe| ");
INSERT INTO sanhk_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","anantaraM yihUdIyAnAM nistArotsave nikaTavarttini sati tadutsavAt pUrvvaM svAn zucIn karttuM bahavo janA grAmebhyo yirUzAlam nagaram Agacchan, ");
INSERT INTO sanhk_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","yIzoranveSaNaM kRtvA mandire daNDAyamAnAH santaH parasparaM vyAharan, yuSmAkaM kIdRzo bodho jAyate? sa kim utsave'smin atrAgamiSyati? ");
INSERT INTO sanhk_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","sa ca kutrAsti yadyetat kazcid vetti tarhi darzayatu pradhAnayAjakAH phirUzinazca taM dharttuM pUrvvam imAm AjJAM prAcArayan| ");
INSERT INTO sanhk_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","nistArotsavAt pUrvvaM dinaSaTke sthite yIzu ryaM pramItam iliyAsaraM zmazAnAd udasthAparat tasya nivAsasthAnaM baithaniyAgrAmam Agacchat| ");
INSERT INTO sanhk_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","tatra tadarthaM rajanyAM bhojye kRte marthA paryyaveSayad iliyAsar ca tasya saGgibhiH sArddhaM bhojanAsana upAvizat| ");
INSERT INTO sanhk_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","tadA mariyam arddhaseTakaM bahumUlyaM jaTAmAMsIyaM tailam AnIya yIzozcaraNayo rmarddayitvA nijakeza rmArSTum Arabhata; tadA tailasya parimalena gRham Amoditam abhavat| ");
INSERT INTO sanhk_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","yaH zimonaH putra riSkariyotIyo yihUdAnAmA yIzuM parakareSu samarpayiSyati sa ziSyastadA kathitavAn, ");
INSERT INTO sanhk_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","etattailaM tribhiH zatai rmudrApadai rvikrItaM sad daridrebhyaH kuto nAdIyata? ");
INSERT INTO sanhk_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","sa daridralokArtham acintayad iti na, kintu sa caura evaM tannikaTe mudrAsampuTakasthityA tanmadhye yadatiSThat tadapAharat tasmAt kAraNAd imAM kathAmakathayat| ");
INSERT INTO sanhk_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","tadA yIzurakathayad enAM mA vAraya sA mama zmazAnasthApanadinArthaM tadarakSayat| ");
INSERT INTO sanhk_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","daridrA yuSmAkaM sannidhau sarvvadA tiSThanti kintvahaM sarvvadA yuSmAkaM sannidhau na tiSThAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","tataH paraM yIzustatrAstIti vArttAM zrutvA bahavo yihUdIyAstaM zmazAnAdutthApitam iliyAsaraJca draSTuM tat sthAnam Agacchana| ");
INSERT INTO sanhk_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","tadA pradhAnayAjakAstam iliyAsaramapi saMharttum amantrayan ; ");
INSERT INTO sanhk_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","yatastena bahavo yihUdIyA gatvA yIzau vyazvasan| ");
INSERT INTO sanhk_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","anantaraM yIzu ryirUzAlam nagaram AgacchatIti vArttAM zrutvA pare'hani utsavAgatA bahavo lokAH ");
INSERT INTO sanhk_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","kharjjUrapatrAdyAnIya taM sAkSAt karttuM bahirAgatya jaya jayeti vAcaM proccai rvaktum Arabhanta, isrAyelo yo rAjA paramezvarasya nAmnAgacchati sa dhanyaH| ");
INSERT INTO sanhk_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","tadA \"he siyonaH kanye mA bhaiSIH pazyAyaM tava rAjA garddabhazAvakam AruhyAgacchati\" ");
INSERT INTO sanhk_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","iti zAstrIyavacanAnusAreNa yIzurekaM yuvagarddabhaM prApya taduparyyArohat| ");
INSERT INTO sanhk_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","asyAH ghaTanAyAstAtparyyaM ziSyAH prathamaM nAbudhyanta, kintu yIzau mahimAnaM prApte sati vAkyamidaM tasmina akathyata lokAzca tampratIttham akurvvan iti te smRtavantaH| ");
INSERT INTO sanhk_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","sa iliyAsaraM zmazAnAd Agantum AhvatavAn zmazAnAJca udasthApayad ye ye lokAstatkarmya sAkSAd apazyan te pramANaM dAtum Arabhanta| ");
INSERT INTO sanhk_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","sa etAdRzam adbhutaM karmmakarot tasya janazrute rlokAstaM sAkSAt karttum Agacchan| ");
INSERT INTO sanhk_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","tataH phirUzinaH parasparaM vaktum Arabhanta yuSmAkaM sarvvAzceSTA vRthA jAtAH, iti kiM yUyaM na budhyadhve? pazyata sarvve lokAstasya pazcAdvarttinobhavan| ");
INSERT INTO sanhk_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","bhajanaM karttum utsavAgatAnAM lokAnAM katipayA janA anyadezIyA Asan , ");
INSERT INTO sanhk_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","te gAlIlIyabaitsaidAnivAsinaH philipasya samIpam Agatya vyAharan he maheccha vayaM yIzuM draSTum icchAmaH| ");
INSERT INTO sanhk_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","tataH philipo gatvA Andriyam avadat pazcAd Andriyaphilipau yIzave vArttAm akathayatAM| ");
INSERT INTO sanhk_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","tadA yIzuH pratyuditavAn mAnavasutasya mahimaprAptisamaya upasthitaH| ");
INSERT INTO sanhk_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ahaM yuSmAnatiyathArthaM vadAmi, dhAnyabIjaM mRttikAyAM patitvA yadi na mRyate tarhyekAkI tiSThati kintu yadi mRyate tarhi bahuguNaM phalaM phalati| ");
INSERT INTO sanhk_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","yo janeा nijaprANAn priyAn jAnAti sa tAn hArayiSyati kintu yeा jana ihaloke nijaprANAn apriyAn jAnAti seाnantAyuH prAptuM tAn rakSiSyati| ");
INSERT INTO sanhk_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","kazcid yadi mama sevako bhavituM vAJchati tarhi sa mama pazcAdgAmI bhavatu, tasmAd ahaM yatra tiSThAmi mama sevakeाpi tatra sthAsyati; yo jano mAM sevate mama pitApi taM sammaMsyate| ");
INSERT INTO sanhk_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","sAmprataM mama prANA vyAkulA bhavanti, tasmAd he pitara etasmAt samayAn mAM rakSa, ityahaM kiM prArthayiSye? kintvaham etatsamayArtham avatIrNavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","he pita: svanAmno mahimAnaM prakAzaya; tanaiva svanAmno mahimAnam ahaM prAkAzayaM punarapi prakAzayiSyAmi, eSA gagaNIyA vANI tasmin samaye'jAyata| ");
INSERT INTO sanhk_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","taczrutvA samIpasthalokAnAM kecid avadan megho'garjIt, kecid avadan svargIyadUto'nena saha kathAmacakathat| ");
INSERT INTO sanhk_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","tadA yIzuH pratyavAdIt, madarthaM zabdoyaM nAbhUt yuSmadarthamevAbhUt| ");
INSERT INTO sanhk_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","adhunA jagatosya vicAra: sampatsyate, adhunAsya jagata: patI rAjyAt cyoSyati| ");
INSERT INTO sanhk_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","yadyaI pRthivyA Urdvve protthApitosmi tarhi sarvvAn mAnavAn svasamIpam AkarSiSyAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","kathaM tasya mRti rbhaviSyati, etad bodhayituM sa imAM kathAm akathayat| ");
INSERT INTO sanhk_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","tadA lokA akathayan sobhiSiktaH sarvvadA tiSThatIti vyavasthAgranthe zrutam asmAbhiH, tarhi manuSyaputraH protthApito bhaviSyatIti vAkyaM kathaM vadasi? manuSyaputroyaM kaH? ");
INSERT INTO sanhk_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","tadA yIzurakathAyad yuSmAbhiH sArddham alpadinAni jyotirAste, yathA yuSmAn andhakAro nAcchAdayati tadarthaM yAvatkAlaM yuSmAbhiH sArddhaM jyotistiSThati tAvatkAlaM gacchata; yo jano'ndhakAre gacchati sa kutra yAtIti na jAnAti| ");
INSERT INTO sanhk_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ataeva yAvatkAlaM yuSmAkaM nikaTe jyotirAste tAvatkAlaM jyotIrUpasantAnA bhavituM jyotiSi vizvasita; imAM kathAM kathayitvA yIzuH prasthAya tebhyaH svaM guptavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","yadyapi yIzusteSAM samakSam etAvadAzcaryyakarmmANi kRtavAn tathApi te tasmin na vyazvasan| ");
INSERT INTO sanhk_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ataeva kaH pratyeti susaMvAdaM parezAsmat pracAritaM? prakAzate parezasya hastaH kasya ca sannidhau? yizayiyabhaviSyadvAdinA yadetad vAkyamuktaM tat saphalam abhavat| ");
INSERT INTO sanhk_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","te pratyetuM nAzankuvan tasmin yizayiyabhaviSyadvAdi punaravAdId, ");
INSERT INTO sanhk_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","yadA, \"te nayanai rna pazyanti buddhibhizca na budhyante tai rmanaHsu parivarttiteSu ca tAnahaM yathA svasthAn na karomi tathA sa teSAM locanAnyandhAni kRtvA teSAmantaHkaraNAni gADhAni kariSyati|\" ");
INSERT INTO sanhk_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","yizayiyo yadA yIzo rmahimAnaM vilokya tasmin kathAmakathayat tadA bhaviSyadvAkyam IdRzaM prakAzayat| ");
INSERT INTO sanhk_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","tathApyadhipatinAM bahavastasmin pratyAyan| kintu phirUzinastAn bhajanagRhAd dUrIkurvvantIti bhayAt te taM na svIkRtavantaH| ");
INSERT INTO sanhk_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","yata Izvarasya prazaMsAto mAnavAnAM prazaMsAyAM te'priyanta| ");
INSERT INTO sanhk_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","tadA yIzuruccaiHkAram akathayad yo jano mayi vizvasiti sa kevale mayi vizvasitIti na, sa matprerake'pi vizvasiti| ");
INSERT INTO sanhk_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","yo jano mAM pazyati sa matprerakamapi pazyati| ");
INSERT INTO sanhk_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","yo jano mAM pratyeti sa yathAndhakAre na tiSThati tadartham ahaM jyotiHsvarUpo bhUtvA jagatyasmin avatIrNavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","mama kathAM zrutvA yadi kazcin na vizvasiti tarhi tamahaM doSiNaM na karomi, yato heto rjagato janAnAM doSAn nizcitAn karttuM nAgatya tAn paricAtum Agatosmi| ");
INSERT INTO sanhk_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","yaH kazcin mAM na zraddhAya mama kathaM na gRhlAti, anyastaM doSiNaM kariSyati vastutastu yAM kathAmaham acakathaM sA kathA carame'nhi taM doSiNaM kariSyati| ");
INSERT INTO sanhk_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","yato hetorahaM svataH kimapi na kathayAmi, kiM kiM mayA kathayitavyaM kiM samupadeSTavyaJca iti matprerayitA pitA mAmAjJApayat| ");
INSERT INTO sanhk_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","tasya sAjJA anantAyurityahaM jAnAmi, ataevAhaM yat kathayAmi tat pitA yathAjJApayat tathaiva kathayAmyaham| ");
INSERT INTO sanhk_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","nistArotsavasya kiJcitkAlAt pUrvvaM pRthivyAH pituH samIpagamanasya samayaH sannikarSobhUd iti jJAtvA yIzurAprathamAd yeSu jagatpravAsiSvAtmIyalokeSa prema karoti sma teSu zeSaM yAvat prema kRtavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","pitA tasya haste sarvvaM samarpitavAn svayam Izvarasya samIpAd Agacchad Izvarasya samIpaM yAsyati ca, sarvvANyetAni jJAtvA rajanyAM bhojane sampUrNe sati, ");
INSERT INTO sanhk_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","yadA zaitAn taM parahasteSu samarpayituM zimonaH putrasya ISkAriyotiyasya yihUdA antaHkaraNe kupravRttiM samArpayat, ");
INSERT INTO sanhk_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","tadA yIzu rbhojanAsanAd utthAya gAtravastraM mocayitvA gAtramArjanavastraM gRhItvA tena svakaTim abadhnAt, ");
INSERT INTO sanhk_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","pazcAd ekapAtre jalam abhiSicya ziSyANAM pAdAn prakSAlya tena kaTibaddhagAtramArjanavAsasA mArSTuM prArabhata| ");
INSERT INTO sanhk_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","tataH zimonpitarasya samIpamAgate sa uktavAn he prabho bhavAn kiM mama pAdau prakSAlayiSyati? ");
INSERT INTO sanhk_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","yIzuruditavAn ahaM yat karomi tat samprati na jAnAsi kintu pazcAj jJAsyasi| ");
INSERT INTO sanhk_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","tataH pitaraH kathitavAn bhavAn kadApi mama pAdau na prakSAlayiSyati| yIzurakathayad yadi tvAM na prakSAlaye tarhi mayi tava kopyaMzo nAsti| ");
INSERT INTO sanhk_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","tadA zimonpitaraH kathitavAn he prabho tarhi kevalapAdau na, mama hastau zirazca prakSAlayatu| ");
INSERT INTO sanhk_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","tato yIzuravadad yo jano dhautastasya sarvvAGgapariSkRtatvAt pAdau vinAnyAGgasya prakSAlanApekSA nAsti| yUyaM pariSkRtA iti satyaM kintu na sarvve, ");
INSERT INTO sanhk_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","yato yo janastaM parakareSu samarpayiSyati taM sa jJAtavAna; ataeva yUyaM sarvve na pariSkRtA imAM kathAM kathitavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","itthaM yIzusteSAM pAdAn prakSAlya vastraM paridhAyAsane samupavizya kathitavAn ahaM yuSmAn prati kiM karmmAkArSaM jAnItha? ");
INSERT INTO sanhk_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","yUyaM mAM guruM prabhuJca vadatha tat satyameva vadatha yatohaM saeva bhavAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","yadyahaM prabhu rguruzca san yuSmAkaM pAdAn prakSAlitavAn tarhi yuSmAkamapi parasparaM pAdaprakSAlanam ucitam| ");
INSERT INTO sanhk_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","ahaM yuSmAn prati yathA vyavAharaM yuSmAn tathA vyavaharttum ekaM panthAnaM darzitavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","ahaM yuSmAnatiyathArthaM vadAmi, prabho rdAso na mahAn prerakAcca prerito na mahAn| ");
INSERT INTO sanhk_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","imAM kathAM viditvA yadi tadanusArataH karmmANi kurutha tarhi yUyaM dhanyA bhaviSyatha| ");
INSERT INTO sanhk_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","sarvveSu yuSmAsu kathAmimAM kathayAmi iti na, ye mama manonItAstAnahaM jAnAmi, kintu mama bhakSyANi yo bhuGkte matprANaprAtikUlyataH| utthApayati pAdasya mUlaM sa eSa mAnavaH|yadetad dharmmapustakasya vacanaM tadanusAreNAvazyaM ghaTiSyate| ");
INSERT INTO sanhk_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","ahaM sa jana ityatra yathA yuSmAkaM vizvAso jAyate tadarthaM etAdRzaghaTanAt pUrvvam ahamidAnIM yuSmabhyamakathayam| ");
INSERT INTO sanhk_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","ahaM yuSmAnatIva yathArthaM vadAmi, mayA preritaM janaM yo gRhlAti sa mAmeva gRhlAti yazca mAM gRhlAti sa matprerakaM gRhlAti| ");
INSERT INTO sanhk_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","etAM kathAM kathayitvA yIzu rduHkhI san pramANaM dattvA kathitavAn ahaM yuSmAnatiyathArthaM vadAmi yuSmAkam eko jano mAM parakareSu samarpayiSyati| ");
INSERT INTO sanhk_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","tataH sa kamuddizya kathAmetAM kathitavAn ityatra sandigdhAH ziSyAH parasparaM mukhamAlokayituM prArabhanta| ");
INSERT INTO sanhk_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","tasmin samaye yIzu ryasmin aprIyata sa ziSyastasya vakSaHsthalam avAlambata| ");
INSERT INTO sanhk_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","zimonpitarastaM saGketenAvadat, ayaM kamuddizya kathAmetAm kathayatIti pRccha| ");
INSERT INTO sanhk_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","tadA sa yIzo rvakSaHsthalam avalambya pRSThavAn, he prabho sa janaH kaH? ");
INSERT INTO sanhk_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","tato yIzuH pratyavadad ekakhaNDaM pUpaM majjayitvA yasmai dAsyAmi saeva saH; pazcAt pUpakhaNDamekaM majjayitvA zimonaH putrAya ISkariyotIyAya yihUdai dattavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","tasmin datte sati zaitAn tamAzrayat; tadA yIzustam avadat tvaM yat kariSyasi tat kSipraM kuru| ");
INSERT INTO sanhk_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","kintu sa yenAzayena tAM kathAmakathAyat tam upaviSTalokAnAM kopi nAbudhyata; ");
INSERT INTO sanhk_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","kintu yihUdAH samIpe mudrAsampuTakasthiteH kecid ittham abudhyanta pArvvaNAsAdanArthaM kimapi dravyaM kretuM vA daridrebhyaH kiJcid vitarituM kathitavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","tadA pUpakhaNDagrahaNAt paraM sa tUrNaM bahiragacchat; rAtrizca samupasyitA| ");
INSERT INTO sanhk_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","yihUde bahirgate yIzurakathayad idAnIM mAnavasutasya mahimA prakAzate tenezvarasyApi mahimA prakAzate| ");
INSERT INTO sanhk_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","yadi tenezvarasya mahimA prakAzate tarhIzvaropi svena tasya mahimAnaM prakAzayiSyati tUrNameva prakAzayiSyati| ");
INSERT INTO sanhk_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","he vatsA ahaM yuSmAbhiH sArddhaM kiJcitkAlamAtram Ase, tataH paraM mAM mRgayiSyadhve kintvahaM yatsthAnaM yAmi tatsthAnaM yUyaM gantuM na zakSyatha, yAmimAM kathAM yihUdIyebhyaH kathitavAn tathAdhunA yuSmabhyamapi kathayAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","yUyaM parasparaM prIyadhvam ahaM yuSmAsu yathA prIye yUyamapi parasparam tathaiva prIyadhvaM, yuSmAn imAM navInAm AjJAm AdizAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","tenaiva yadi parasparaM prIyadhve tarhi lakSaNenAnena yUyaM mama ziSyA iti sarvve jJAtuM zakSyanti| ");
INSERT INTO sanhk_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","zimonapitaraH pRSThavAn he prabho bhavAn kutra yAsyati? tato yIzuH pratyavadat, ahaM yatsthAnaM yAmi tatsthAnaM sAmprataM mama pazcAd gantuM na zaknoSi kintu pazcAd gamiSyasi| ");
INSERT INTO sanhk_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","tadA pitaraH pratyuditavAn, he prabho sAmprataM kuto hetostava pazcAd gantuM na zaknomi? tvadarthaM prANAn dAtuM zaknomi| ");
INSERT INTO sanhk_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","tato yIzuH pratyuktavAn mannimittaM kiM prANAn dAtuM zaknoSi? tvAmahaM yathArthaM vadAmi, kukkuTaravaNAt pUrvvaM tvaM tri rmAm apahnoSyase| ");
INSERT INTO sanhk_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","manoduHkhino mA bhUta; Izvare vizvasita mayi ca vizvasita| ");
INSERT INTO sanhk_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","mama pitu gRhe bahUni vAsasthAni santi no cet pUrvvaM yuSmAn ajJApayiSyaM yuSmadarthaM sthAnaM sajjayituM gacchAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","yadi gatvAhaM yuSmannimittaM sthAnaM sajjayAmi tarhi panarAgatya yuSmAn svasamIpaM neSyAmi, tato yatrAhaM tiSThAmi tatra yUyamapi sthAsyatha| ");
INSERT INTO sanhk_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ahaM yatsthAnaM brajAmi tatsthAnaM yUyaM jAnItha tasya panthAnamapi jAnItha| ");
INSERT INTO sanhk_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","tadA thomA avadat, he prabho bhavAn kutra yAti tadvayaM na jAnImaH, tarhi kathaM panthAnaM jJAtuM zaknumaH? ");
INSERT INTO sanhk_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","yIzurakathayad ahameva satyajIvanarUpapatho mayA na gantA kopi pituH samIpaM gantuM na zaknoti| ");
INSERT INTO sanhk_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","yadi mAm ajJAsyata tarhi mama pitaramapyajJAsyata kintvadhunAtastaM jAnItha pazyatha ca| ");
INSERT INTO sanhk_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","tadA philipaH kathitavAn, he prabho pitaraM darzaya tasmAdasmAkaM yatheSTaM bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","tato yIzuH pratyAvAdIt, he philipa yuSmAbhiH sArddham etAvaddinAni sthitamapi mAM kiM na pratyabhijAnAsi? yo jano mAm apazyat sa pitaramapyapazyat tarhi pitaram asmAn darzayeti kathAM kathaM kathayasi? ");
INSERT INTO sanhk_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ahaM pitari tiSThAmi pitA mayi tiSThatIti kiM tvaM na pratyaSi? ahaM yadvAkyaM vadAmi tat svato na vadAmi kintu yaH pitA mayi virAjate sa eva sarvvakarmmANi karAti| ");
INSERT INTO sanhk_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ataeva pitaryyahaM tiSThAmi pitA ca mayi tiSThati mamAsyAM kathAyAM pratyayaM kuruta, no cet karmmahetoH pratyayaM kuruta| ");
INSERT INTO sanhk_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","ahaM yuSmAnatiyathArthaM vadAmi, yo jano mayi vizvasiti sohamiva karmmANi kariSyati varaM tatopi mahAkarmmANi kariSyati yato hetorahaM pituH samIpaM gacchAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","yathA putreNa pitu rmahimA prakAzate tadarthaM mama nAma procya yat prArthayiSyadhve tat saphalaM kariSyAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","yadi mama nAmnA yat kiJcid yAcadhve tarhi tadahaM sAdhayiSyAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","yadi mayi prIyadhve tarhi mamAjJAH samAcarata| ");
INSERT INTO sanhk_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","tato mayA pituH samIpe prArthite pitA nirantaraM yuSmAbhiH sArddhaM sthAtum itaramekaM sahAyam arthAt satyamayam AtmAnaM yuSmAkaM nikaTaM preSayiSyati| ");
INSERT INTO sanhk_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","etajjagato lokAstaM grahItuM na zaknuvanti yataste taM nApazyan nAjanaMzca kintu yUyaM jAnItha yato hetoH sa yuSmAkamanta rnivasati yuSmAkaM madhye sthAsyati ca| ");
INSERT INTO sanhk_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","ahaM yuSmAn anAthAn kRtvA na yAsyAmi punarapi yuSmAkaM samIpam AgamiSyAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","kiyatkAlarat param asya jagato lokA mAM puna rna drakSyanti kintu yUyaM drakSyatha;ahaM jIviSyAmi tasmAt kAraNAd yUyamapi jIviSyatha| ");
INSERT INTO sanhk_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","pitaryyahamasmi mayi ca yUyaM stha, tathAhaM yuSmAsvasmi tadapi tadA jJAsyatha| ");
INSERT INTO sanhk_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","yo jano mamAjJA gRhItvA tA Acarati saeva mayi prIyate; yo janazca mayi prIyate saeva mama pituH priyapAtraM bhaviSyati, tathAhamapi tasmin prItvA tasmai svaM prakAzayiSyAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","tadA ISkariyotIyAd anyo yihUdAstamavadat, he prabho bhavAn jagato lokAnAM sannidhau prakAzito na bhUtvAsmAkaM sannidhau kutaH prakAzito bhaviSyati? ");
INSERT INTO sanhk_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","tato yIzuH pratyuditavAn, yo jano mayi prIyate sa mamAjJA api gRhlAti, tena mama pitApi tasmin preSyate, AvAJca tannikaTamAgatya tena saha nivatsyAvaH| ");
INSERT INTO sanhk_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","yo jano mayi na prIyate sa mama kathA api na gRhlAti punazca yAmimAM kathAM yUyaM zRNutha sA kathA kevalasya mama na kintu mama prerako yaH pitA tasyApi kathA| ");
INSERT INTO sanhk_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","idAnIM yuSmAkaM nikaTe vidyamAnoham etAH sakalAH kathAH kathayAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","kintvitaH paraM pitrA yaH sahAyo'rthAt pavitra AtmA mama nAmni prerayiSyati sa sarvvaM zikSayitvA mayoktAH samastAH kathA yuSmAn smArayiSyati| ");
INSERT INTO sanhk_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","ahaM yuSmAkaM nikaTe zAntiM sthApayitvA yAmi, nijAM zAntiM yuSmabhyaM dadAmi, jagato lokA yathA dadAti tathAhaM na dadAmi; yuSmAkam antaHkaraNAni duHkhitAni bhItAni ca na bhavantu| ");
INSERT INTO sanhk_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","ahaM gatvA punarapi yuSmAkaM samIpam AgamiSyAmi mayoktaM vAkyamidaM yUyam azrauSTa; yadi mayyapreSyadhvaM tarhyahaM pituH samIpaM gacchAmi mamAsyAM kathAyAM yUyam ahlAdiSyadhvaM yato mama pitA mattopi mahAn| ");
INSERT INTO sanhk_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","tasyA ghaTanAyAH samaye yathA yuSmAkaM zraddhA jAyate tadartham ahaM tasyA ghaTanAyAH pUrvvam idAnIM yuSmAn etAM vArttAM vadAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","itaH paraM yuSmAbhiH saha mama bahava AlApA na bhaviSyanti yataH kAraNAd etasya jagataH patirAgacchati kintu mayA saha tasya kopi sambandho nAsti| ");
INSERT INTO sanhk_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ahaM pitari prema karomi tathA pitu rvidhivat karmmANi karomIti yena jagato lokA jAnanti tadartham uttiSThata vayaM sthAnAdasmAd gacchAma| ");
INSERT INTO sanhk_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","ahaM satyadrAkSAlatAsvarUpo mama pitA tUdyAnaparicArakasvarUpaJca| ");
INSERT INTO sanhk_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","mama yAsu zAkhAsu phalAni na bhavanti tAH sa chinatti tathA phalavatyaH zAkhA yathAdhikaphalAni phalanti tadarthaM tAH pariSkaroti| ");
INSERT INTO sanhk_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","idAnIM mayoktopadezena yUyaM pariSkRtAH| ");
INSERT INTO sanhk_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ataH kAraNAt mayi tiSThata tenAhamapi yuSmAsu tiSThAmi, yato heto rdrAkSAlatAyAm asaMlagnA zAkhA yathA phalavatI bhavituM na zaknoti tathA yUyamapi mayyatiSThantaH phalavanto bhavituM na zaknutha| ");
INSERT INTO sanhk_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","ahaM drAkSAlatAsvarUpo yUyaJca zAkhAsvarUpoH; yo jano mayi tiSThati yatra cAhaM tiSThAmi, sa pracUraphalaiH phalavAn bhavati, kintu mAM vinA yUyaM kimapi karttuM na zaknutha| ");
INSERT INTO sanhk_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","yaH kazcin mayi na tiSThati sa zuSkazAkheva bahi rnikSipyate lokAzca tA AhRtya vahnau nikSipya dAhayanti| ");
INSERT INTO sanhk_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","yadi yUyaM mayi tiSThatha mama kathA ca yuSmAsu tiSThati tarhi yad vAJchitvA yAciSyadhve yuSmAkaM tadeva saphalaM bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","yadi yUyaM pracUraphalavanto bhavatha tarhi tadvArA mama pitu rmahimA prakAziSyate tathA yUyaM mama ziSyA iti parikSAyiSyadhve| ");
INSERT INTO sanhk_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","pitA yathA mayi prItavAn ahamapi yuSmAsu tathA prItavAn ato heto ryUyaM nirantaraM mama premapAtrANi bhUtvA tiSThata| ");
INSERT INTO sanhk_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ahaM yathA piturAjJA gRhItvA tasya premabhAjanaM tiSThAmi tathaiva yUyamapi yadi mamAjJA guhlItha tarhi mama premabhAjanAni sthAsyatha| ");
INSERT INTO sanhk_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","yuSmannimittaM mama ya AhlAdaH sa yathA ciraM tiSThati yuSmAkam Anandazca yathA pUryyate tadarthaM yuSmabhyam etAH kathA atrakatham| ");
INSERT INTO sanhk_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","ahaM yuSmAsu yathA prIye yUyamapi parasparaM tathA prIyadhvam eSA mamAjJA| ");
INSERT INTO sanhk_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","mitrANAM kAraNAt svaprANadAnaparyyantaM yat prema tasmAn mahAprema kasyApi nAsti| ");
INSERT INTO sanhk_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","ahaM yadyad AdizAmi tattadeva yadi yUyam Acarata tarhi yUyameva mama mitrANi| ");
INSERT INTO sanhk_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","adyArabhya yuSmAn dAsAn na vadiSyAmi yat prabhu ryat karoti dAsastad na jAnAti; kintu pituH samIpe yadyad azRNavaM tat sarvvaM yUSmAn ajJApayam tatkAraNAd yuSmAn mitrANi proktavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","yUyaM mAM rocitavanta iti na, kintvahameva yuSmAn rocitavAn yUyaM gatvA yathA phalAnyutpAdayatha tAni phalAni cAkSayANi bhavanti, tadarthaM yuSmAn nyajunajaM tasmAn mama nAma procya pitaraM yat kiJcid yAciSyadhve tadeva sa yuSmabhyaM dAsyati| ");
INSERT INTO sanhk_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","yUyaM parasparaM prIyadhvam aham ityAjJApayAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","jagato lokai ryuSmAsu RtIyiteSu te pUrvvaM mAmevArttIyanta iti yUyaM jAnItha| ");
INSERT INTO sanhk_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","yadi yUyaM jagato lokA abhaviSyata tarhi jagato lokA yuSmAn AtmIyAn buddhvApreSyanta; kintu yUyaM jagato lokA na bhavatha, ahaM yuSmAn asmAjjagato'rocayam etasmAt kAraNAjjagato lokA yuSmAn RtIyante| ");
INSERT INTO sanhk_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","dAsaH prabho rmahAn na bhavati mamaitat pUrvvIyaM vAkyaM smarata; te yadi mAmevAtADayan tarhi yuSmAnapi tADayiSyanti, yadi mama vAkyaM gRhlanti tarhi yuSmAkamapi vAkyaM grahISyanti| ");
INSERT INTO sanhk_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","kintu te mama nAmakAraNAd yuSmAn prati tAdRzaM vyavahariSyanti yato yo mAM preritavAn taM te na jAnanti| ");
INSERT INTO sanhk_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","teSAM sannidhim Agatya yadyahaM nAkathayiSyaM tarhi teSAM pApaM nAbhaviSyat kintvadhunA teSAM pApamAcchAdayitum upAyo nAsti| ");
INSERT INTO sanhk_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","yo jano mAm RtIyate sa mama pitaramapi RtIyate| ");
INSERT INTO sanhk_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","yAdRzAni karmmANi kenApi kadApi nAkriyanta tAdRzAni karmmANi yadi teSAM sAkSAd ahaM nAkariSyaM tarhi teSAM pApaM nAbhaviSyat kintvadhunA te dRSTvApi mAM mama pitaraJcArttIyanta| ");
INSERT INTO sanhk_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","tasmAt te'kAraNaM mAm RtIyante yadetad vacanaM teSAM zAstre likhitamAste tat saphalam abhavat| ");
INSERT INTO sanhk_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","kintu pitu rnirgataM yaM sahAyamarthAt satyamayam AtmAnaM pituH samIpAd yuSmAkaM samIpe preSayiSyAmi sa Agatya mayi pramANaM dAsyati| ");
INSERT INTO sanhk_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","yUyaM prathamamArabhya mayA sArddhaM tiSThatha tasmAddheto ryUyamapi pramANaM dAsyatha| ");
INSERT INTO sanhk_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","yuSmAkaM yathA vAdhA na jAyate tadarthaM yuSmAn etAni sarvvavAkyAni vyAharaM| ");
INSERT INTO sanhk_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","lokA yuSmAn bhajanagRhebhyo dUrIkariSyanti tathA yasmin samaye yuSmAn hatvA Izvarasya tuSTi janakaM karmmAkurmma iti maMsyante sa samaya Agacchanti| ");
INSERT INTO sanhk_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","te pitaraM mAJca na jAnanti, tasmAd yuSmAn pratIdRzam AcariSyanti| ");
INSERT INTO sanhk_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","ato hetAH samaye samupasthite yathA mama kathA yuSmAkaM manaHsuH samupatiSThati tadarthaM yuSmAbhyam etAM kathAM kathayAmi yuSmAbhiH sArddham ahaM tiSThan prathamaM tAM yuSmabhyaM nAkathayaM| ");
INSERT INTO sanhk_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","sAmprataM svasya prerayituH samIpaM gacchAmi tathApi tvaM kka gacchasi kathAmetAM yuSmAkaM kopi mAM na pRcchati| ");
INSERT INTO sanhk_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","kintu mayoktAbhirAbhiH kathAbhi ryUSmAkam antaHkaraNAni duHkhena pUrNAnyabhavan| ");
INSERT INTO sanhk_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","tathApyahaM yathArthaM kathayAmi mama gamanaM yuSmAkaM hitArthameva, yato heto rgamane na kRte sahAyo yuSmAkaM samIpaM nAgamiSyati kintu yadi gacchAmi tarhi yuSmAkaM samIpe taM preSayiSyAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","tataH sa Agatya pApapuNyadaNDeSu jagato lokAnAM prabodhaM janayiSyati| ");
INSERT INTO sanhk_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","te mayi na vizvasanti tasmAddhetoH pApaprabodhaM janayiSyati| ");
INSERT INTO sanhk_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","yuSmAkam adRzyaH sannahaM pituH samIpaM gacchAmi tasmAd puNye prabodhaM janayiSyati| ");
INSERT INTO sanhk_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","etajjagato'dhipati rdaNDAjJAM prApnoti tasmAd daNDe prabodhaM janayiSyati| ");
INSERT INTO sanhk_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","yuSmabhyaM kathayituM mamAnekAH kathA Asate, tAH kathA idAnIM yUyaM soDhuM na zaknutha; ");
INSERT INTO sanhk_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","kintu satyamaya AtmA yadA samAgamiSyati tadA sarvvaM satyaM yuSmAn neSyati, sa svataH kimapi na vadiSyati kintu yacchroSyati tadeva kathayitvA bhAvikAryyaM yuSmAn jJApayiSyati| ");
INSERT INTO sanhk_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","mama mahimAnaM prakAzayiSyati yato madIyAM kathAM gRhItvA yuSmAn bodhayiSyati| ");
INSERT INTO sanhk_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","pitu ryadyad Aste tat sarvvaM mama tasmAd kAraNAd avAdiSaM sa madIyAM kathAM gRhItvA yuSmAn bodhayiSyati| ");
INSERT INTO sanhk_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","kiyatkAlAt paraM yUyaM mAM draSTuM na lapsyadhve kintu kiyatkAlAt paraM puna rdraSTuM lapsyadhve yatohaM pituH samIpaM gacchAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","tataH ziSyANAM kiyanto janAH parasparaM vaditum Arabhanta, kiyatkAlAt paraM mAM draSTuM na lapsyadhve kintu kiyatkAlAt paraM puna rdraSTuM lapsyadhve yatohaM pituH samIpaM gacchAmi, iti yad vAkyam ayaM vadati tat kiM? ");
INSERT INTO sanhk_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","tataH kiyatkAlAt param iti tasya vAkyaM kiM? tasya vAkyasyAbhiprAyaM vayaM boddhuM na zaknumastairiti ");
INSERT INTO sanhk_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","nigadite yIzusteSAM praznecchAM jJAtvA tebhyo'kathayat kiyatkAlAt paraM mAM draSTuM na lapsyadhve, kintu kiyatkAlAt paraM pUna rdraSTuM lapsyadhve, yAmimAM kathAmakathayaM tasyA abhiprAyaM kiM yUyaM parasparaM mRgayadhve? ");
INSERT INTO sanhk_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","yuSmAnaham atiyathArthaM vadAmi yUyaM krandiSyatha vilapiSyatha ca, kintu jagato lokA AnandiSyanti; yUyaM zokAkulA bhaviSyatha kintu zokAt paraM AnandayuktA bhaviSyatha| ");
INSERT INTO sanhk_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","prasavakAla upasthite nArI yathA prasavavedanayA vyAkulA bhavati kintu putre bhUmiSThe sati manuSyaiko janmanA naraloke praviSTa ityAnandAt tasyAstatsarvvaM duHkhaM manasi na tiSThati, ");
INSERT INTO sanhk_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","tathA yUyamapi sAmprataM zokAkulA bhavatha kintu punarapi yuSmabhyaM darzanaM dAsyAmi tena yuSmAkam antaHkaraNAni sAnandAni bhaviSyanti, yuSmAkaM tam AnandaJca kopi harttuM na zakSyati| ");
INSERT INTO sanhk_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","tasmin divase kAmapi kathAM mAM na prakSyatha| yuSmAnaham atiyathArthaM vadAmi, mama nAmnA yat kiJcid pitaraM yAciSyadhve tadeva sa dAsyati| ");
INSERT INTO sanhk_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","pUrvve mama nAmnA kimapi nAyAcadhvaM, yAcadhvaM tataH prApsyatha tasmAd yuSmAkaM sampUrNAnando janiSyate| ");
INSERT INTO sanhk_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","upamAkathAbhiH sarvvANyetAni yuSmAn jJApitavAn kintu yasmin samaye upamayA noktvA pituH kathAM spaSTaM jJApayiSyAmi samaya etAdRza Agacchati| ");
INSERT INTO sanhk_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","tadA mama nAmnA prArthayiSyadhve 'haM yuSmannimittaM pitaraM vineSye kathAmimAM na vadAmi; ");
INSERT INTO sanhk_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","yato yUyaM mayi prema kurutha, tathAham Izvarasya samIpAd AgatavAn ityapi pratItha, tasmAd kAraNAt kAraNAt pitA svayaM yuSmAsu prIyate| ");
INSERT INTO sanhk_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","pituH samIpAjjajad Agatosmi jagat parityajya ca punarapi pituH samIpaM gacchAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","tadA ziSyA avadan, he prabho bhavAn upamayA noktvAdhunA spaSTaM vadati| ");
INSERT INTO sanhk_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","bhavAn sarvvajJaH kenacit pRSTo bhavitumapi bhavataH prayojanaM nAstItyadhunAsmAkaM sthirajJAnaM jAtaM tasmAd bhavAn Izvarasya samIpAd AgatavAn ityatra vayaM vizvasimaH| ");
INSERT INTO sanhk_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","tato yIzuH pratyavAdId idAnIM kiM yUyaM vizvasitha? ");
INSERT INTO sanhk_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","pazyata sarvve yUyaM vikIrNAH santo mAm ekAkinaM pIratyajya svaM svaM sthAnaM gamiSyatha, etAdRzaH samaya Agacchati varaM prAyeNopasthitavAn; tathApyahaM naikAkI bhavAmi yataH pitA mayA sArddham Aste| ");
INSERT INTO sanhk_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","yathA mayA yuSmAkaM zAnti rjAyate tadartham etAH kathA yuSmabhyam acakathaM; asmin jagati yuSmAkaM klezo ghaTiSyate kintvakSobhA bhavata yato mayA jagajjitaM| ");
INSERT INTO sanhk_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","tataH paraM yIzuretAH kathAH kathayitvA svargaM vilokyaitat prArthayat, he pitaH samaya upasthitavAn; yathA tava putrastava mahimAnaM prakAzayati tadarthaM tvaM nijaputrasya mahimAnaM prakAzaya| ");
INSERT INTO sanhk_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","tvaM yollokAn tasya haste samarpitavAn sa yathA tebhyo'nantAyu rdadAti tadarthaM tvaM prANimAtrANAm adhipatitvabhAraM tasmai dattavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","yastvam advitIyaH satya IzvarastvayA preritazca yIzuH khrISTa etayorubhayoH paricaye prApte'nantAyu rbhavati| ");
INSERT INTO sanhk_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","tvaM yasya karmmaNo bhAraM mahyaM dattavAn, tat sampannaM kRtvA jagatyasmin tava mahimAnaM prAkAzayaM| ");
INSERT INTO sanhk_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ataeva he pita rjagatyavidyamAne tvayA saha tiSThato mama yo mahimAsIt samprati tava samIpe mAM taM mahimAnaM prApaya| ");
INSERT INTO sanhk_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","anyacca tvam etajjagato yAllokAn mahyam adadA ahaM tebhyastava nAmnastattvajJAnam adadAM, te tavaivAsan, tvaM tAn mahyamadadAH, tasmAtte tavopadezam agRhlan| ");
INSERT INTO sanhk_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","tvaM mahyaM yat kiJcid adadAstatsarvvaM tvatto jAyate ityadhunAjAnan| ");
INSERT INTO sanhk_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","mahyaM yamupadezam adadA ahamapi tebhyastamupadezam adadAM tepi tamagRhlan tvattohaM nirgatya tvayA preritobhavam atra ca vyazvasan| ");
INSERT INTO sanhk_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","teSAmeva nimittaM prArthaye'haM jagato lokanimittaM na prArthaye kintu yAllokAn mahyam adadAsteSAmeva nimittaM prArthaye'haM yataste tavaivAsate| ");
INSERT INTO sanhk_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ye mama te tava ye ca tava te mama tathA tai rmama mahimA prakAzyate| ");
INSERT INTO sanhk_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","sAmpratam asmin jagati mamAvasthiteH zeSam abhavat ahaM tava samIpaM gacchAmi kintu te jagati sthAsyanti; he pavitra pitarAvayo ryathaikatvamAste tathA teSAmapyekatvaM bhavati tadarthaM yAllokAn mahyam adadAstAn svanAmnA rakSa| ");
INSERT INTO sanhk_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","yAvanti dinAni jagatyasmin taiH sahAhamAsaM tAvanti dinAni tAn tava nAmnAhaM rakSitavAn; yAllokAn mahyam adadAstAn sarvvAn ahamarakSaM, teSAM madhye kevalaM vinAzapAtraM hAritaM tena dharmmapustakasya vacanaM pratyakSaM bhavati| ");
INSERT INTO sanhk_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","kintvadhunA tava sannidhiM gacchAmi mayA yathA teSAM sampUrNAnando bhavati tadarthamahaM jagati tiSThan etAH kathA akathayam| ");
INSERT INTO sanhk_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","tavopadezaM tebhyo'dadAM jagatA saha yathA mama sambandho nAsti tathA jajatA saha teSAmapi sambandhAbhAvAj jagato lokAstAn RtIyante| ");
INSERT INTO sanhk_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","tvaM jagatastAn gRhANeti na prArthaye kintvazubhAd rakSeti prArthayeham| ");
INSERT INTO sanhk_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ahaM yathA jagatsambandhIyo na bhavAmi tathA tepi jagatsambandhIyA na bhavanti| ");
INSERT INTO sanhk_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","tava satyakathayA tAn pavitrIkuru tava vAkyameva satyaM| ");
INSERT INTO sanhk_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","tvaM yathA mAM jagati prairayastathAhamapi tAn jagati prairayaM| ");
INSERT INTO sanhk_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","teSAM hitArthaM yathAhaM svaM pavitrIkaromi tathA satyakathayA tepi pavitrIbhavantu| ");
INSERT INTO sanhk_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","kevalaM eteSAmarthe prArthaye'ham iti na kintveteSAmupadezena ye janA mayi vizvasiSyanti teSAmapyarthe prArtheye'ham| ");
INSERT INTO sanhk_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","he pitasteSAM sarvveSAm ekatvaM bhavatu tava yathA mayi mama ca yathA tvayyekatvaM tathA teSAmapyAvayorekatvaM bhavatu tena tvaM mAM preritavAn iti jagato lokAH pratiyantu| ");
INSERT INTO sanhk_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","yathAvayorekatvaM tathA teSAmapyekatvaM bhavatu teSvahaM mayi ca tvam itthaM teSAM sampUrNamekatvaM bhavatu, tvaM preritavAn tvaM mayi yathA prIyase ca tathA teSvapi prItavAn etadyathA jagato lokA jAnanti ");
INSERT INTO sanhk_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","tadarthaM tvaM yaM mahimAnaM mahyam adadAstaM mahimAnam ahamapi tebhyo dattavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","he pita rjagato nirmmANAt pUrvvaM mayi snehaM kRtvA yaM mahimAnaM dattavAn mama taM mahimAnaM yathA te pazyanti tadarthaM yAllokAn mahyaM dattavAn ahaM yatra tiSThAmi tepi yathA tatra tiSThanti mamaiSA vAJchA| ");
INSERT INTO sanhk_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","he yathArthika pita rjagato lokaistvayyajJAtepi tvAmahaM jAne tvaM mAM preritavAn itIme ziSyA jAnanti| ");
INSERT INTO sanhk_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","yathAhaM teSu tiSThAmi tathA mayi yena premnA premAkarostat teSu tiSThati tadarthaM tava nAmAhaM tAn jJApitavAn punarapi jJApayiSyAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","tAH kathAH kathayitvA yIzuH ziSyAnAdAya kidronnAmakaM srota uttIryya ziSyaiH saha tatratyodyAnaM prAvizat| ");
INSERT INTO sanhk_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","kintu vizvAsaghAtiyihUdAstat sthAnaM paricIyate yato yIzuH ziSyaiH sArddhaM kadAcit tat sthAnam agacchat| ");
INSERT INTO sanhk_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","tadA sa yihUdAH sainyagaNaM pradhAnayAjakAnAM phirUzinAJca padAtigaNaJca gRhItvA pradIpAn ulkAn astrANi cAdAya tasmin sthAna upasthitavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","svaM prati yad ghaTiSyate taj jJAtvA yIzuragresaraH san tAnapRcchat kaM gaveSayatha? ");
INSERT INTO sanhk_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","te pratyavadan, nAsaratIyaM yIzuM; tato yIzuravAdId ahameva saH; taiH saha vizvAsaghAtI yihUdAzcAtiSThat| ");
INSERT INTO sanhk_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","tadAhameva sa tasyaitAM kathAM zrutvaiva te pazcAdetya bhUmau patitAH| ");
INSERT INTO sanhk_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","tato yIzuH punarapi pRSThavAn kaM gaveSayatha? tataste pratyavadan nAsaratIyaM yIzuM| ");
INSERT INTO sanhk_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","tadA yIzuH pratyuditavAn ahameva sa imAM kathAmacakatham; yadi mAmanvicchatha tarhImAn gantuM mA vArayata| ");
INSERT INTO sanhk_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","itthaM bhUte mahyaM yAllokAn adadAsteSAm ekamapi nAhArayam imAM yAM kathAM sa svayamakathayat sA kathA saphalA jAtA| ");
INSERT INTO sanhk_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","tadA zimonpitarasya nikaTe khaGgalsthiteH sa taM niSkoSaM kRtvA mahAyAjakasya mAlkhanAmAnaM dAsam Ahatya tasya dakSiNakarNaM chinnavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","tato yIzuH pitaram avadat, khaGgaM koSe sthApaya mama pitA mahyaM pAtuM yaM kaMsam adadAt tenAhaM kiM na pAsyAmi? ");
INSERT INTO sanhk_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","tadA sainyagaNaH senApati ryihUdIyAnAM padAtayazca yIzuM ghRtvA baddhvA hAnannAmnaH kiyaphAH zvazurasya samIpaM prathamam anayan| ");
INSERT INTO sanhk_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","sa kiyaphAstasmin vatsare mahAyAjatvapade niyuktaH ");
INSERT INTO sanhk_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","san sAdhAraNalokAnAM maGgalArtham ekajanasya maraNamucitam iti yihUdIyaiH sArddham amantrayat| ");
INSERT INTO sanhk_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","tadA zimonpitaro'nyaikaziSyazca yIzoH pazcAd agacchatAM tasyAnyaziSyasya mahAyAjakena paricitatvAt sa yIzunA saha mahAyAjakasyATTAlikAM prAvizat| ");
INSERT INTO sanhk_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","kintu pitaro bahirdvArasya samIpe'tiSThad ataeva mahAyAjakena paricitaH sa ziSyaH punarbahirgatvA dauvAyikAyai kathayitvA pitaram abhyantaram Anayat| ");
INSERT INTO sanhk_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","tadA sa dvArarakSikA pitaram avadat tvaM kiM na tasya mAnavasya ziSyaH? tataH sovadad ahaM na bhavAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","tataH paraM yatsthAne dAsAH padAtayazca zItahetoraGgArai rvahniM prajvAlya tApaM sevitavantastatsthAne pitarastiSThan taiH saha vahnitApaM sevitum Arabhata| ");
INSERT INTO sanhk_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","tadA ziSyeSUpadeze ca mahAyAjakena yIzuH pRSTaH ");
INSERT INTO sanhk_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","san pratyuktavAn sarvvalokAnAM samakSaM kathAmakathayaM guptaM kAmapi kathAM na kathayitvA yat sthAnaM yihUdIyAH satataM gacchanti tatra bhajanagehe mandire cAzikSayaM| ");
INSERT INTO sanhk_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","mattaH kutaH pRcchasi? ye janA madupadezam azRNvan tAneva pRccha yadyad avadaM te tat jAninta| ");
INSERT INTO sanhk_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","tadetthaM pratyuditatvAt nikaTasthapadAti ryIzuM capeTenAhatya vyAharat mahAyAjakam evaM prativadasi? ");
INSERT INTO sanhk_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","tato yIzuH pratigaditavAn yadyayathArtham acakathaM tarhi tasyAyathArthasya pramANaM dehi, kintu yadi yathArthaM tarhi kuto heto rmAm atADayaH? ");
INSERT INTO sanhk_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","pUrvvaM hAnan sabandhanaM taM kiyaphAmahAyAjakasya samIpaM praiSayat| ");
INSERT INTO sanhk_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","zimonpitarastiSThan vahnitApaM sevate, etasmin samaye kiyantastam apRcchan tvaM kim etasya janasya ziSyo na? tataH sopahnutyAbravId ahaM na bhavAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","tadA mahAyAjakasya yasya dAsasya pitaraH karNamacchinat tasya kuTumbaH pratyuditavAn udyAne tena saha tiSThantaM tvAM kiM nApazyaM? ");
INSERT INTO sanhk_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","kintu pitaraH punarapahnutya kathitavAn; tadAnIM kukkuTo'raut| ");
INSERT INTO sanhk_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","tadanantaraM pratyUSe te kiyaphAgRhAd adhipate rgRhaM yIzum anayan kintu yasmin azucitve jAte tai rnistArotsave na bhoktavyaM, tasya bhayAd yihUdIyAstadgRhaM nAvizan| ");
INSERT INTO sanhk_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","aparaM pIlAto bahirAgatya tAn pRSThavAn etasya manuSyasya kaM doSaM vadatha? ");
INSERT INTO sanhk_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","tadA te petyavadan duSkarmmakAriNi na sati bhavataH samIpe nainaM samArpayiSyAmaH| ");
INSERT INTO sanhk_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","tataH pIlAto'vadad yUyamenaM gRhItvA sveSAM vyavasthayA vicArayata| tadA yihUdIyAH pratyavadan kasyApi manuSyasya prANadaNDaM karttuM nAsmAkam adhikAro'sti| ");
INSERT INTO sanhk_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","evaM sati yIzuH svasya mRtyau yAM kathAM kathitavAn sA saphalAbhavat| ");
INSERT INTO sanhk_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","tadanantaraM pIlAtaH punarapi tad rAjagRhaM gatvA yIzumAhUya pRSTavAn tvaM kiM yihUdIyAnAM rAjA? ");
INSERT INTO sanhk_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","yIzuH pratyavadat tvam etAM kathAM svataH kathayasi kimanyaH kazcin mayi kathitavAn? ");
INSERT INTO sanhk_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","pIlAto'vadad ahaM kiM yihUdIyaH? tava svadezIyA vizeSataH pradhAnayAjakA mama nikaTe tvAM samArpayana, tvaM kiM kRtavAn? ");
INSERT INTO sanhk_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","yIzuH pratyavadat mama rAjyam etajjagatsambandhIyaM na bhavati yadi mama rAjyaM jagatsambandhIyam abhaviSyat tarhi yihUdIyAnAM hasteSu yathA samarpito nAbhavaM tadarthaM mama sevakA ayotsyan kintu mama rAjyam aihikaM na| ");
INSERT INTO sanhk_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","tadA pIlAtaH kathitavAn, tarhi tvaM rAjA bhavasi? yIzuH pratyuktavAn tvaM satyaM kathayasi, rAjAhaM bhavAmi; satyatAyAM sAkSyaM dAtuM janiM gRhItvA jagatyasmin avatIrNavAn, tasmAt satyadharmmapakSapAtino mama kathAM zRNvanti| ");
INSERT INTO sanhk_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","tadA satyaM kiM? etAM kathAM paSTvA pIlAtaH punarapi bahirgatvA yihUdIyAn abhASata, ahaM tasya kamapyaparAdhaM na prApnomi| ");
INSERT INTO sanhk_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","nistArotsavasamaye yuSmAbhirabhirucita eko jano mayA mocayitavya eSA yuSmAkaM rItirasti, ataeva yuSmAkaM nikaTe yihUdIyAnAM rAjAnaM kiM mocayAmi, yuSmAkam icchA kA? ");
INSERT INTO sanhk_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","tadA te sarvve ruvanto vyAharan enaM mAnuSaM nahi barabbAM mocaya| kintu sa barabbA dasyurAsIt| ");
INSERT INTO sanhk_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","pIlAto yIzum AnIya kazayA prAhArayat| ");
INSERT INTO sanhk_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","pazcAt senAgaNaH kaNTakanirmmitaM mukuTaM tasya mastake samarpya vArttAkIvarNaM rAjaparicchadaM paridhApya, ");
INSERT INTO sanhk_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","he yihUdIyAnAM rAjan namaskAra ityuktvA taM capeTenAhantum Arabhata| ");
INSERT INTO sanhk_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","tadA pIlAtaH punarapi bahirgatvA lokAn avadat, asya kamapyaparAdhaM na labhe'haM, pazyata tad yuSmAn jJApayituM yuSmAkaM sannidhau bahirenam AnayAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","tataH paraM yIzuH kaNTakamukuTavAn vArttAkIvarNavasanavAMzca bahirAgacchat| tataH pIlAta uktavAn enaM manuSyaM pazyata| ");
INSERT INTO sanhk_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","tadA pradhAnayAjakAH padAtayazca taM dRSTvA, enaM kruze vidha, enaM kruze vidha, ityuktvA ravituM Arabhanta| tataH pIlAtaH kathitavAn yUyaM svayam enaM nItvA kruze vidhata, aham etasya kamapyaparAdhaM na prAptavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","yihUdIyAH pratyavadan asmAkaM yA vyavasthAste tadanusAreNAsya prANahananam ucitaM yatoyaM svam Izvarasya putramavadat| ");
INSERT INTO sanhk_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","pIlAta imAM kathAM zrutvA mahAtrAsayuktaH ");
INSERT INTO sanhk_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","san punarapi rAjagRha Agatya yIzuM pRSTavAn tvaM kutratyo lokaH? kintu yIzastasya kimapi pratyuttaraM nAvadat| ");
INSERT INTO sanhk_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","1# tataH pIlAt kathitavAna tvaM kiM mayA sArddhaM na saMlapiSyasi ? tvAM kruze vedhituM vA mocayituM zakti rmamAste iti kiM tvaM na jAnAsi ? tadA yIzuH pratyavadad IzvareNAdaŸाM mamopari tava kimapyadhipatitvaM na vidyate, tathApi yo jano mAM tava haste samArpayat tasya mahApAtakaM jAtam| ");
INSERT INTO sanhk_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","tadA yIzuH pratyavadad IzvareNAdattaM mamopari tava kimapyadhipatitvaM na vidyate, tathApi yo jano mAM tava haste samArpayat tasya mahApAtakaM jAtam| ");
INSERT INTO sanhk_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","tadArabhya pIlAtastaM mocayituM ceSTitavAn kintu yihUdIyA ruvanto vyAharan yadImaM mAnavaM tyajasi tarhi tvaM kaisarasya mitraM na bhavasi, yo janaH svaM rAjAnaM vakti saeva kaimarasya viruddhAM kathAM kathayati| ");
INSERT INTO sanhk_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","etAM kathAM zrutvA pIlAto yIzuM bahirAnIya nistArotsavasya AsAdanadinasya dvitIyapraharAt pUrvvaM prastarabandhananAmni sthAne 'rthAt ibrIyabhASayA yad gabbithA kathyate tasmin sthAne vicArAsana upAvizat| ");
INSERT INTO sanhk_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","anantaraM pIlAto yihUdIyAn avadat, yuSmAkaM rAjAnaM pazyata| ");
INSERT INTO sanhk_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","kintu enaM dUrIkuru, enaM dUrIkuru, enaM kruze vidha, iti kathAM kathayitvA te ravitum Arabhanta; tadA pIlAtaH kathitavAn yuSmAkaM rAjAnaM kiM kruze vedhiSyAmi? pradhAnayAjakA uttaram avadan kaisaraM vinA kopi rAjAsmAkaM nAsti| ");
INSERT INTO sanhk_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","tataH pIlAto yIzuM kruze vedhituM teSAM hasteSu samArpayat, tataste taM dhRtvA nItavantaH| ");
INSERT INTO sanhk_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","tataH paraM yIzuH kruzaM vahan ziraHkapAlam arthAd yad ibrIyabhASayA gulgaltAM vadanti tasmin sthAna upasthitaH| ");
INSERT INTO sanhk_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","tataste madhyasthAne taM tasyobhayapArzve dvAvaparau kruze'vidhan| ");
INSERT INTO sanhk_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","aparam eSa yihUdIyAnAM rAjA nAsaratIyayIzuH, iti vijJApanaM likhitvA pIlAtastasya kruzopari samayojayat| ");
INSERT INTO sanhk_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","sA lipiH ibrIyayUnAnIyaromIyabhASAbhi rlikhitA; yIzoH kruzavedhanasthAnaM nagarasya samIpaM, tasmAd bahavo yihUdIyAstAM paThitum Arabhanta| ");
INSERT INTO sanhk_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","yihUdIyAnAM pradhAnayAjakAH pIlAtamiti nyavedayan yihUdIyAnAM rAjeti vAkyaM na kintu eSa svaM yihUdIyAnAM rAjAnam avadad itthaM likhatu| ");
INSERT INTO sanhk_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","tataH pIlAta uttaraM dattavAn yallekhanIyaM tallikhitavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","itthaM senAgaNo yIzuM kruze vidhitvA tasya paridheyavastraM caturo bhAgAn kRtvA ekaikasenA ekaikabhAgam agRhlat tasyottarIyavastraJcAgRhlat| kintUttarIyavastraM sUcisevanaM vinA sarvvam UtaM| ");
INSERT INTO sanhk_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","tasmAtte vyAharan etat kaH prApsyati? tanna khaNDayitvA tatra guTikApAtaM karavAma| vibhajante'dharIyaM me vasanaM te parasparaM| mamottarIyavastrArthaM guTikAM pAtayanti ca| iti yadvAkyaM dharmmapustake likhitamAste tat senAgaNenetthaM vyavaharaNAt siddhamabhavat| ");
INSERT INTO sanhk_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","tadAnIM yIzo rmAtA mAtu rbhaginI ca yA kliyapA bhAryyA mariyam magdalInI mariyam ca etAstasya kruzasya sannidhau samatiSThan| ");
INSERT INTO sanhk_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","tato yIzuH svamAtaraM priyatamaziSyaJca samIpe daNDAyamAnau vilokya mAtaram avadat, he yoSid enaM tava putraM pazya, ");
INSERT INTO sanhk_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ziSyantvavadat, enAM tava mAtaraM pazya| tataH sa ziSyastadghaTikAyAM tAM nijagRhaM nItavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","anantaraM sarvvaM karmmAdhunA sampannamabhUt yIzuriti jJAtvA dharmmapustakasya vacanaM yathA siddhaM bhavati tadartham akathayat mama pipAsA jAtA| ");
INSERT INTO sanhk_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","tatastasmin sthAne amlarasena pUrNapAtrasthityA te spaJjamekaM tadamlarasenArdrIkRtya esobnale tad yojayitvA tasya mukhasya sannidhAvasthApayan| ");
INSERT INTO sanhk_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","tadA yIzuramlarasaM gRhItvA sarvvaM siddham iti kathAM kathayitvA mastakaM namayan prANAn paryyatyajat| ");
INSERT INTO sanhk_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","tadvinam AsAdanadinaM tasmAt pare'hani vizrAmavAre dehA yathA kruzopari na tiSThanti, yataH sa vizrAmavAro mahAdinamAsIt, tasmAd yihUdIyAH pIlAtanikaTaM gatvA teSAM pAdabhaJjanasya sthAnAntaranayanasya cAnumatiM prArthayanta| ");
INSERT INTO sanhk_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ataH senA Agatya yIzunA saha kruze hatayoH prathamadvitIyacorayoH pAdAn abhaJjan; ");
INSERT INTO sanhk_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","kintu yIzoH sannidhiM gatvA sa mRta iti dRSTvA tasya pAdau nAbhaJjan| ");
INSERT INTO sanhk_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","pazcAd eko yoddhA zUlAghAtena tasya kukSim avidhat tatkSaNAt tasmAd raktaM jalaJca niragacchat| ");
INSERT INTO sanhk_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","yo jano'sya sAkSyaM dadAti sa svayaM dRSTavAn tasyedaM sAkSyaM satyaM tasya kathA yuSmAkaM vizvAsaM janayituM yogyA tat sa jAnAti| ");
INSERT INTO sanhk_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","tasyaikam asdhyapi na bhaMkSyate, ");
INSERT INTO sanhk_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","tadvad anyazAstrepi likhyate, yathA, \"dRSTipAtaM kariSyanti te'vidhan yantu tamprati|\" ");
INSERT INTO sanhk_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","arimathIyanagarasya yUSaphnAmA ziSya eka AsIt kintu yihUdIyebhyo bhayAt prakAzito na bhavati; sa yIzo rdehaM netuM pIlAtasyAnumatiM prArthayata, tataH pIlAtenAnumate sati sa gatvA yIzo rdeham anayat| ");
INSERT INTO sanhk_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","aparaM yo nikadImo rAtrau yIzoH samIpam agacchat sopi gandharasena mizritaM prAyeNa paJcAzatseTakamaguruM gRhItvAgacchat| ");
INSERT INTO sanhk_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","tataste yihUdIyAnAM zmazAne sthApanarItyanusAreNa tatsugandhidravyeNa sahitaM tasya dehaM vastreNAveSTayan| ");
INSERT INTO sanhk_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","aparaJca yatra sthAne taM kruze'vidhan tasya nikaTasthodyAne yatra kimapi mRtadehaM kadApi nAsthApyata tAdRzam ekaM nUtanaM zmazAnam AsIt| ");
INSERT INTO sanhk_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","yihUdIyAnAm AsAdanadinAgamanAt te tasmin samIpasthazmazAne yIzum azAyayan| ");
INSERT INTO sanhk_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","anantaraM saptAhasya prathamadine 'tipratyUSe 'ndhakAre tiSThati magdalInI mariyam tasya zmazAnasya nikaTaM gatvA zmazAnasya mukhAt prastaramapasAritam apazyat| ");
INSERT INTO sanhk_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","pazcAd dhAvitvA zimonpitarAya yIzoH priyatamaziSyAya cedam akathayat, lokAH zmazAnAt prabhuM nItvA kutrAsthApayan tad vaktuM na zaknomi| ");
INSERT INTO sanhk_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","ataH pitaraH sonyaziSyazca barhi rbhutvA zmazAnasthAnaM gantum ArabhetAM| ");
INSERT INTO sanhk_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ubhayordhAvatoH sonyaziSyaH pitaraM pazcAt tyaktvA pUrvvaM zmazAnasthAna upasthitavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","tadA prahvIbhUya sthApitavastrANi dRSTavAn kintu na prAvizat| ");
INSERT INTO sanhk_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","aparaM zimonpitara Agatya zmazAnasthAnaM pravizya ");
INSERT INTO sanhk_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","sthApitavastrANi mastakasya vastraJca pRthak sthAnAntare sthApitaM dRSTavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","tataH zmazAnasthAnaM pUrvvam Agato yonyaziSyaH sopi pravizya tAdRzaM dRSTA vyazvasIt| ");
INSERT INTO sanhk_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","yataH zmazAnAt sa utthApayitavya etasya dharmmapustakavacanasya bhAvaM te tadA voddhuM nAzankuvan| ");
INSERT INTO sanhk_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","anantaraM tau dvau ziSyau svaM svaM gRhaM parAvRtyAgacchatAm| ");
INSERT INTO sanhk_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","tataH paraM mariyam zmazAnadvArasya bahiH sthitvA roditum Arabhata tato rudatI prahvIbhUya zmazAnaM vilokya ");
INSERT INTO sanhk_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","yIzoH zayanasthAnasya ziraHsthAne padatale ca dvayo rdizo dvau svargIyadUtAvupaviSTau samapazyat| ");
INSERT INTO sanhk_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","tau pRSTavantau he nAri kuto rodiSi? sAvadat lokA mama prabhuM nItvA kutrAsthApayan iti na jAnAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ityuktvA mukhaM parAvRtya yIzuM daNDAyamAnam apazyat kintu sa yIzuriti sA jJAtuM nAzaknot| ");
INSERT INTO sanhk_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","tadA yIzustAm apRcchat he nAri kuto rodiSi? kaM vA mRgayase? tataH sA tam udyAnasevakaM jJAtvA vyAharat, he maheccha tvaM yadItaH sthAnAt taM nItavAn tarhi kutrAsthApayastad vada tatsthAnAt tam AnayAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","tadA yIzustAm avadat he mariyam| tataH sA parAvRtya pratyavadat he rabbUnI arthAt he guro| ");
INSERT INTO sanhk_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","tadA yIzuravadat mAM mA dhara, idAnIM pituH samIpe UrddhvagamanaM na karomi kintu yo mama yuSmAkaJca pitA mama yuSmAkaJcezvarastasya nikaTa UrddhvagamanaM karttum udyatosmi, imAM kathAM tvaM gatvA mama bhrAtRgaNaM jJApaya| ");
INSERT INTO sanhk_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","tato magdalInImariyam tatkSaNAd gatvA prabhustasyai darzanaM dattvA kathA etA akathayad iti vArttAM ziSyebhyo'kathayat| ");
INSERT INTO sanhk_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","tataH paraM saptAhasya prathamadinasya sandhyAsamaye ziSyA ekatra militvA yihUdIyebhyo bhiyA dvAraruddham akurvvan, etasmin kAle yIzusteSAM madhyasthAne tiSThan akathayad yuSmAkaM kalyANaM bhUyAt| ");
INSERT INTO sanhk_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ityuktvA nijahastaM kukSiJca darzitavAn, tataH ziSyAH prabhuM dRSTvA hRSTA abhavan| ");
INSERT INTO sanhk_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","yIzuH punaravadad yuSmAkaM kalyANaM bhUyAt pitA yathA mAM praiSayat tathAhamapi yuSmAn preSayAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ityuktvA sa teSAmupari dIrghaprazvAsaM dattvA kathitavAn pavitram AtmAnaM gRhlIta| ");
INSERT INTO sanhk_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","yUyaM yeSAM pApAni mocayiSyatha te mocayiSyante yeSAJca pApAti na mocayiSyatha te na mocayiSyante| ");
INSERT INTO sanhk_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","dvAdazamadhye gaNito yamajo thomAnAmA ziSyo yIzorAgamanakAlai taiH sArddhaM nAsIt| ");
INSERT INTO sanhk_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","ato vayaM prabhUm apazyAmeti vAkye'nyaziSyairukte sovadat, tasya hastayo rlauhakIlakAnAM cihnaM na vilokya taccihnam aGgulyA na spRSTvA tasya kukSau hastaM nAropya cAhaM na vizvasiSyAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","aparam aSTame'hni gate sati thomAsahitaH ziSyagaNa ekatra militvA dvAraM ruddhvAbhyantara AsIt, etarhi yIzusteSAM madhyasthAne tiSThan akathayat, yuSmAkaM kuzalaM bhUyAt| ");
INSERT INTO sanhk_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","pazcAt thAmai kathitavAn tvam aGgulIm atrArpayitvA mama karau pazya karaM prasAryya mama kukSAvarpaya nAvizvasya| ");
INSERT INTO sanhk_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","tadA thomA avadat, he mama prabho he madIzvara| ");
INSERT INTO sanhk_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","yIzurakathayat, he thomA mAM nirIkSya vizvasiSi ye na dRSTvA vizvasanti taeva dhanyAH| ");
INSERT INTO sanhk_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","etadanyAni pustake'smin alikhitAni bahUnyAzcaryyakarmmANi yIzuH ziSyANAM purastAd akarot| ");
INSERT INTO sanhk_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","kintu yIzurIzvarasyAbhiSiktaH suta eveti yathA yUyaM vizvasitha vizvasya ca tasya nAmnA paramAyuH prApnutha tadartham etAni sarvvANyalikhyanta| ");
INSERT INTO sanhk_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","tataH paraM tibiriyAjaladhestaTe yIzuH punarapi ziSyebhyo darzanaM dattavAn darzanasyAkhyAnamidam| ");
INSERT INTO sanhk_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","zimonpitaraH yamajathomA gAlIlIyakAnnAnagaranivAsI nithanel sivadeH putrAvanyau dvau ziSyau caiteSvekatra militeSu zimonpitaro'kathayat matsyAn dhartuM yAmi| ");
INSERT INTO sanhk_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","tataste vyAharan tarhi vayamapi tvayA sArddhaM yAmaH tadA te bahirgatAH santaH kSipraM nAvam Arohan kintu tasyAM rajanyAm ekamapi na prApnuvan| ");
INSERT INTO sanhk_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","prabhAte sati yIzustaTe sthitavAn kintu sa yIzuriti ziSyA jJAtuM nAzaknuvan| ");
INSERT INTO sanhk_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","tadA yIzurapRcchat, he vatsA sannidhau kiJcit khAdyadravyam Aste? te'vadan kimapi nAsti| ");
INSERT INTO sanhk_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","tadA so'vadat naukAyA dakSiNapArzve jAlaM nikSipata tato lapsyadhve, tasmAt tai rnikSipte jAle matsyA etAvanto'patan yena te jAlamAkRSya nottolayituM zaktAH| ");
INSERT INTO sanhk_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","tasmAd yIzoH priyatamaziSyaH pitarAyAkathayat eSa prabhu rbhavet, eSa prabhuriti vAcaM zrutvaiva zimon nagnatAheto rmatsyadhAriNa uttarIyavastraM paridhAya hradaM pratyudalamphayat| ");
INSERT INTO sanhk_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","apare ziSyA matsyaiH sArddhaM jAlam AkarSantaH kSudranaukAM vAhayitvA kUlamAnayan te kUlAd atidUre nAsan dvizatahastebhyo dUra Asan ityanumIyate| ");
INSERT INTO sanhk_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","tIraM prAptaistaistatra prajvalitAgnistadupari matsyAH pUpAzca dRSTAH| ");
INSERT INTO sanhk_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","tato yIzurakathayad yAn matsyAn adharata teSAM katipayAn Anayata| ");
INSERT INTO sanhk_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ataH zimonpitaraH parAvRtya gatvA bRhadbhistripaJcAzadadhikazatamatsyaiH paripUrNaM tajjAlam AkRSyodatolayat kintvetAvadbhi rmatsyairapi jAlaM nAchidyata| ");
INSERT INTO sanhk_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","anantaraM yIzustAn avAdIt yUyamAgatya bhuMgdhvaM; tadA saeva prabhuriti jJAtatvAt tvaM kaH? iti praSTuM ziSyANAM kasyApi pragalbhatA nAbhavat| ");
INSERT INTO sanhk_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","tato yIzurAgatya pUpAn matsyAMzca gRhItvA tebhyaH paryyaveSayat| ");
INSERT INTO sanhk_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","itthaM zmazAnAdutthAnAt paraM yIzuH ziSyebhyastRtIyavAraM darzanaM dattavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","bhojane samApte sati yIzuH zimonpitaraM pRSTavAn, he yUnasaH putra zimon tvaM kim etebhyodhikaM mayi prIyase? tataH sa uditavAn satyaM prabho tvayi prIye'haM tad bhavAn jAnAti; tadA yIzurakathayat tarhi mama meSazAvakagaNaM pAlaya| ");
INSERT INTO sanhk_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","tataH sa dvitIyavAraM pRSTavAn he yUnasaH putra zimon tvaM kiM mayi prIyase? tataH sa uktavAn satyaM prabho tvayi prIye'haM tad bhavAn jAnAti; tadA yIzurakathayata tarhi mama meSagaNaM pAlaya| ");
INSERT INTO sanhk_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","pazcAt sa tRtIyavAraM pRSTavAn, he yUnasaH putra zimon tvaM kiM mayi prIyase? etadvAkyaM tRtIyavAraM pRSTavAn tasmAt pitaro duHkhito bhUtvA'kathayat he prabho bhavataH kimapyagocaraM nAsti tvayyahaM prIye tad bhavAn jAnAti; tato yIzuravadat tarhi mama meSagaNaM pAlaya| ");
INSERT INTO sanhk_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","ahaM tubhyaM yathArthaM kathayAmi yauvanakAle svayaM baddhakaTi ryatrecchA tatra yAtavAn kintvitaH paraM vRddhe vayasi hastaM vistArayiSyasi, anyajanastvAM baddhvA yatra gantuM tavecchA na bhavati tvAM dhRtvA tatra neSyati| ");
INSERT INTO sanhk_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","phalataH kIdRzena maraNena sa Izvarasya mahimAnaM prakAzayiSyati tad bodhayituM sa iti vAkyaM proktavAn| ityukte sati sa tamavocat mama pazcAd Agaccha| ");
INSERT INTO sanhk_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","yo jano rAtrikAle yIzo rvakSo'valambya, he prabho ko bhavantaM parakareSu samarpayiSyatIti vAkyaM pRSTavAn, taM yIzoH priyatamaziSyaM pazcAd AgacchantaM ");
INSERT INTO sanhk_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","pitaro mukhaM parAvarttya vilokya yIzuM pRSTavAn, he prabho etasya mAnavasya kIdRzI gati rbhaviSyati? ");
INSERT INTO sanhk_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","sa pratyavadat, mama punarAgamanaparyyantaM yadi taM sthApayitum icchAmi tatra tava kiM? tvaM mama pazcAd Agaccha| ");
INSERT INTO sanhk_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","tasmAt sa ziSyo na mariSyatIti bhrAtRgaNamadhye kiMvadantI jAtA kintu sa na mariSyatIti vAkyaM yIzu rnAvadat kevalaM mama punarAgamanaparyyantaM yadi taM sthApayitum icchAmi tatra tava kiM? iti vAkyam uktavAn| ");
INSERT INTO sanhk_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","yo jana etAni sarvvANi likhitavAn atra sAkSyaJca dattavAn saeva sa ziSyaH, tasya sAkSyaM pramANamiti vayaM jAnImaH| ");
INSERT INTO sanhk_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","yIzuretebhyo'parANyapi bahUni karmmANi kRtavAn tAni sarvvANi yadyekaikaM kRtvA likhyante tarhi granthA etAvanto bhavanti teSAM dhAraNe pRthivyAM sthAnaM na bhavati| iti||");
INSERT INTO sanhk_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","he thiyaphila, yIzuH svamanonItAn preritAn pavitreNAtmanA samAdizya yasmin dine svargamArohat yAM yAM kriyAmakarot yadyad upAdizacca tAni sarvvANi pUrvvaM mayA likhitAni| ");
INSERT INTO sanhk_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","sa svanidhanaduHkhabhogAt param anekapratyayakSapramANauH svaM sajIvaM darzayitvA ");
INSERT INTO sanhk_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","catvAriMzaddinAni yAvat tebhyaH preritebhyo darzanaM dattvezvarIyarAjyasya varNanama akarot| ");
INSERT INTO sanhk_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","anantaraM teSAM sabhAM kRtvA ityAjJApayat, yUyaM yirUzAlamo'nyatra gamanamakRtvA yastin pitrAGgIkRte mama vadanAt kathA azRNuta tatprAptim apekSya tiSThata| ");
INSERT INTO sanhk_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","yohan jale majjitAvAn kintvalpadinamadhye yUyaM pavitra Atmani majjitA bhaviSyatha| ");
INSERT INTO sanhk_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","pazcAt te sarvve militvA tam apRcchan he prabho bhavAn kimidAnIM punarapi rAjyam isrAyelIyalokAnAM kareSu samarpayiSyati? ");
INSERT INTO sanhk_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","tataH sovadat yAn sarvvAn kAlAn samayAMzca pitA svavaze'sthApayat tAn jJAtRM yuSmAkam adhikAro na jAyate| ");
INSERT INTO sanhk_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","kintu yuSmAsu pavitrasyAtmana AvirbhAve sati yUyaM zaktiM prApya yirUzAlami samastayihUdAzomiroNadezayoH pRthivyAH sImAM yAvad yAvanto dezAsteSu yarvveSu ca mayi sAkSyaM dAsyatha| ");
INSERT INTO sanhk_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","iti vAkyamuktvA sa teSAM samakSaM svargaM nIto'bhavat, tato meghamAruhya teSAM dRSTeragocaro'bhavat| ");
INSERT INTO sanhk_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","yasmin samaye te vihAyasaM pratyananyadRSTyA tasya tAdRzam Urdvvagamanam apazyan tasminneva samaye zuklavastrau dvau janau teSAM sannidhau daNDAyamAnau kathitavantau, ");
INSERT INTO sanhk_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","he gAlIlIyalokA yUyaM kimarthaM gagaNaM prati nirIkSya daNDAyamAnAstiSThatha? yuSmAkaM samIpAt svargaM nIto yo yIzustaM yUyaM yathA svargam Arohantam adarzam tathA sa punazcAgamiSyati| ");
INSERT INTO sanhk_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","tataH paraM te jaitunanAmnaH parvvatAd vizrAmavArasya pathaH parimANam arthAt prAyeNArddhakrozaM durasthaM yirUzAlamnagaraM parAvRtyAgacchan| ");
INSERT INTO sanhk_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","nagaraM pravizya pitaro yAkUb yohan AndriyaH philipaH thomA barthajamayo mathirAlphIyaputro yAkUb udyogAी zimon yAkUbo bhrAtA yihUdA ete sarvve yatra sthAne pravasanti tasmin uparitanaprakoSThe prAvizan| ");
INSERT INTO sanhk_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","pazcAd ime kiyatyaH striyazca yIzo rmAtA mariyam tasya bhrAtarazcaite sarvva ekacittIbhUta satataM vinayena vinayena prArthayanta| ");
INSERT INTO sanhk_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","tasmin samaye tatra sthAne sAkalyena viMzatyadhikazataM ziSyA Asan| tataH pitarasteSAM madhye tiSThan uktavAn ");
INSERT INTO sanhk_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","he bhrAtRgaNa yIzudhAriNAM lokAnAM pathadarzako yo yihUdAstasmin dAyUdA pavitra AtmA yAM kathAM kathayAmAsa tasyAH pratyakSIbhavanasyAvazyakatvam AsIt| ");
INSERT INTO sanhk_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","sa jano'smAkaM madhyavarttI san asyAH sevAyA aMzam alabhata| ");
INSERT INTO sanhk_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","tadanantaraM kukarmmaNA labdhaM yanmUlyaM tena kSetramekaM krItam aparaM tasmin adhomukhe bhRmau patite sati tasyodarasya vidIrNatvAt sarvvA nADyo niragacchan| ");
INSERT INTO sanhk_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","etAM kathAM yirUzAlamnivAsinaH sarvve lokA vidAnti; teSAM nijabhASayA tatkSetraJca hakaldAmA, arthAt raktakSetramiti vikhyAtamAste| ");
INSERT INTO sanhk_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","anyacca, niketanaM tadIyantu zunyameva bhaviSyati| tasya dUSye nivAsArthaM kopi sthAsyati naiva hi| anya eva janastasya padaM saMprApsyati dhruvaM| itthaM gItapustake likhitamAste| ");
INSERT INTO sanhk_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","ato yohano majjanam ArabhyAsmAkaM samIpAt prabho ryIzoH svargArohaNadinaM yAvat sosmAkaM madhye yAvanti dinAni yApitavAn ");
INSERT INTO sanhk_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","tAvanti dinAni ye mAnavA asmAbhiH sArddhaM tiSThanti teSAm ekena janenAsmAbhiH sArddhaM yIzorutthAne sAkSiNA bhavitavyaM| ");
INSERT INTO sanhk_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","ato yasya rUDhi ryuSTo yaM barzabbetyuktvAhUyanti sa yUSaph matathizca dvAvetau pRthak kRtvA ta Izvarasya sannidhau prAryya kathitavantaH, ");
INSERT INTO sanhk_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","he sarvvAntaryyAmin paramezvara, yihUdAH sevanapreritatvapadacyutaH ");
INSERT INTO sanhk_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","san nijasthAnam agacchat, tatpadaM labdhum enayo rjanayo rmadhye bhavatA ko'bhirucitastadasmAn darzyatAM| ");
INSERT INTO sanhk_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","tato guTikApATe kRte matathirniracIyata tasmAt sonyeSAm ekAdazAnAM praritAnAM madhye gaNitobhavat| ");
INSERT INTO sanhk_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","aparaJca nistArotsavAt paraM paJcAzattame dine samupasthite sati te sarvve ekAcittIbhUya sthAna ekasmin militA Asan| ");
INSERT INTO sanhk_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","etasminneva samaye'kasmAd AkAzAt pracaNDAtyugravAyoH zabdavad ekaH zabda Agatya yasmin gRhe ta upAvizan tad gRhaM samastaM vyApnot| ");
INSERT INTO sanhk_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","tataH paraM vahnizikhAsvarUpA jihvAH pratyakSIbhUya vibhaktAH satyaH pratijanorddhve sthagitA abhUvan| ");
INSERT INTO sanhk_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","tasmAt sarvve pavitreNAtmanA paripUrNAH santa AtmA yathA vAcitavAn tadanusAreNAnyadezIyAnAM bhASA uktavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","tasmin samaye pRthivIsthasarvvadezebhyo yihUdIyamatAvalambino bhaktalokA yirUzAlami prAvasan; ");
INSERT INTO sanhk_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","tasyAH kathAyAH kiMvadantyA jAtatvAt sarvve lokA militvA nijanijabhASayA ziSyANAM kathAkathanaM zrutvA samudvignA abhavan| ");
INSERT INTO sanhk_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","sarvvaeva vismayApannA AzcaryyAnvitAzca santaH parasparaM uktavantaH pazyata ye kathAM kathayanti te sarvve gAlIlIyalokAH kiM na bhavanti? ");
INSERT INTO sanhk_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","tarhi vayaM pratyekazaH svasvajanmadezIyabhASAbhiH kathA eteSAM zRNumaH kimidaM? ");
INSERT INTO sanhk_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","pArthI-mAdI-arAmnaharayimdezanivAsimano yihUdA-kappadakiyA-panta-AziyA- ");
INSERT INTO sanhk_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","phrugiyA-pamphuliyA-misaranivAsinaH kurINInikaTavarttilUbIyapradezanivAsino romanagarAd AgatA yihUdIyalokA yihUdIyamatagrAhiNaH krItIyA arAbIyAdayo lokAzca ye vayam ");
INSERT INTO sanhk_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","asmAkaM nijanijabhASAbhireteSAm IzvarIyamahAkarmmavyAkhyAnaM zRNumaH| ");
INSERT INTO sanhk_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","itthaM te sarvvaeva vismayApannAH sandigdhacittAH santaH parasparamUcuH, asya ko bhAvaH? ");
INSERT INTO sanhk_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","apare kecit parihasya kathitavanta ete navInadrAkSArasena mattA abhavan| ");
INSERT INTO sanhk_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","tadA pitara ekAdazabhi rjanaiH sAkaM tiSThan tAllokAn uccaiHkAram avadat, he yihUdIyA he yirUzAlamnivAsinaH sarvve, avadhAnaM kRtvA madIyavAkyaM budhyadhvaM| ");
INSERT INTO sanhk_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","idAnIm ekayAmAd adhikA velA nAsti tasmAd yUyaM yad anumAtha mAnavA ime madyapAnena mattAstanna| ");
INSERT INTO sanhk_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","kintu yoyelbhaviSyadvaktraitadvAkyamuktaM yathA, ");
INSERT INTO sanhk_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","IzvaraH kathayAmAsa yugAntasamaye tvaham| varSiSyAmi svamAtmAnaM sarvvaprANyupari dhruvam| bhAvivAkyaM vadiSyanti kanyAH putrAzca vastutaH|pratyAdezaJca prApsyanti yuSmAkaM yuvamAnavAH| tathA prAcInalokAstu svapnAn drakSyanti nizcitaM| ");
INSERT INTO sanhk_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","varSiSyAmi tadAtmAnaM dAsadAsIjanopiri| tenaiva bhAvivAkyaM te vadiSyanti hi sarvvazaH| ");
INSERT INTO sanhk_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Urddhvasthe gagaNe caiva nIcasthe pRthivItale| zoNitAni bRhadbhAnUn ghanadhUmAdikAni ca| cihnAni darzayiSyAmi mahAzcaryyakriyAstathA| ");
INSERT INTO sanhk_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","mahAbhayAnakasyaiva taddinasya parezituH| purAgamAd raviH kRSNo raktazcandro bhaviSyataH| ");
INSERT INTO sanhk_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","kintu yaH paramezasya nAmni samprArthayiSyate| saeva manujo nUnaM paritrAto bhaviSyati|| ");
INSERT INTO sanhk_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","ato he isrAyelvaMzIyalokAH sarvve kathAyAmetasyAm mano nidhaddhvaM nAsaratIyo yIzurIzvarasya manonItaH pumAn etad IzvarastatkRtairAzcaryyAdbhutakarmmabhi rlakSaNaizca yuSmAkaM sAkSAdeva pratipAditavAn iti yUyaM jAnItha| ");
INSERT INTO sanhk_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","tasmin yIzau Izvarasya pUrvvanizcitamantraNAnirUpaNAnusAreNa mRtyau samarpite sati yUyaM taM dhRtvA duSTalokAnAM hastaiH kruze vidhitvAhata| ");
INSERT INTO sanhk_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","kintvIzvarastaM nidhanasya bandhanAnmocayitvA udasthApayat yataH sa mRtyunA baddhastiSThatIti na sambhavati| ");
INSERT INTO sanhk_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","etastin dAyUdapi kathitavAn yathA, sarvvadA mama sAkSAttaM sthApaya paramezvaraM| sthite maddakSiNe tasmin skhaliSyAmi tvahaM nahi| ");
INSERT INTO sanhk_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","AnandiSyati taddheto rmAmakInaM manastu vai| AhlAdiSyati jihvApi madIyA tu tathaiva ca| pratyAzayA zarIrantu madIyaM vaizayiSyate| ");
INSERT INTO sanhk_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","paraloke yato hetostvaM mAM naiva hi tyakSyasi| svakIyaM puNyavantaM tvaM kSayituM naiva dAsyasi| evaM jIvanamArgaM tvaM mAmeva darzayiSyasi| ");
INSERT INTO sanhk_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","svasammukhe ya Anando dakSiNe svasya yat sukhaM| anantaM tena mAM pUrNaM kariSyasi na saMzayaH|| ");
INSERT INTO sanhk_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","he bhrAtaro'smAkaM tasya pUrvvapuruSasya dAyUdaH kathAM spaSTaM kathayituM mAm anumanyadhvaM, sa prANAn tyaktvA zmazAne sthApitobhavad adyApi tat zmazAnam asmAkaM sannidhau vidyate| ");
INSERT INTO sanhk_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","phalato laukikabhAvena dAyUdo vaMze khrISTaM janma grAhayitvA tasyaiva siMhAsane samuveSTuM tamutthApayiSyati paramezvaraH zapathaM kutvA dAyUdaH samIpa imam aGgIkAraM kRtavAn, ");
INSERT INTO sanhk_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","iti jJAtvA dAyUd bhaviSyadvAdI san bhaviSyatkAlIyajJAnena khrISTotthAne kathAmimAM kathayAmAsa yathA tasyAtmA paraloke na tyakSyate tasya zarIraJca na kSeSyati; ");
INSERT INTO sanhk_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","ataH paramezvara enaM yIzuM zmazAnAd udasthApayat tatra vayaM sarvve sAkSiNa Asmahe| ");
INSERT INTO sanhk_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","sa Izvarasya dakSiNakareNonnatiM prApya pavitra Atmina pitA yamaGgIkAraM kRtavAn tasya phalaM prApya yat pazyatha zRNutha ca tadavarSat| ");
INSERT INTO sanhk_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","yato dAyUd svargaM nAruroha kintu svayam imAM kathAm akathayad yathA, mama prabhumidaM vAkyamavadat paramezvaraH| ");
INSERT INTO sanhk_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","tava zatrUnahaM yAvat pAdapIThaM karomi na| tAvat kAlaM madIye tvaM dakSavArzva upAviza| ");
INSERT INTO sanhk_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","ato yaM yIzuM yUyaM kruze'hata paramezvarastaM prabhutvAbhiSiktatvapade nyayuMkteti isrAyelIyA lokA nizcitaM jAnantu| ");
INSERT INTO sanhk_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","etAdRzIM kathAM zrutvA teSAM hRdayAnAM vidIrNatvAt te pitarAya tadanyapreritebhyazca kathitavantaH, he bhrAtRgaNa vayaM kiM kariSyAmaH? ");
INSERT INTO sanhk_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","tataH pitaraH pratyavadad yUyaM sarvve svaM svaM manaH parivarttayadhvaM tathA pApamocanArthaM yIzukhrISTasya nAmnA majjitAzca bhavata, tasmAd dAnarUpaM paritram AtmAnaM lapsyatha| ");
INSERT INTO sanhk_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","yato yuSmAkaM yuSmatsantAnAnAJca dUrasthasarvvalokAnAJca nimittam arthAd asmAkaM prabhuH paramezvaro yAvato lAkAn AhvAsyati teSAM sarvveSAM nimittam ayamaGgIkAra Aste| ");
INSERT INTO sanhk_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","etadanyAbhi rbahukathAbhiH pramANaM datvAkathayat etebhyo vipathagAmibhyo varttamAnalokebhyaH svAn rakSata| ");
INSERT INTO sanhk_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","tataH paraM ye sAnandAstAM kathAm agRhlan te majjitA abhavan| tasmin divase prAyeNa trINi sahasrANi lokAsteSAM sapakSAH santaH ");
INSERT INTO sanhk_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","preritAnAm upadeze saGgatau pUpabhaJjane prArthanAsu ca manaHsaMyogaM kRtvAtiSThan| ");
INSERT INTO sanhk_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","preritai rnAnAprakAralakSaNeSu mahAzcaryyakarmamasu ca darziteSu sarvvalokAnAM bhayamupasthitaM| ");
INSERT INTO sanhk_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","vizvAsakAriNaH sarvva ca saha tiSThanataH| sveSAM sarvvAH sampattIH sAdhAraNyena sthApayitvAbhuJjata| ");
INSERT INTO sanhk_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","phalato gRhANi dravyANi ca sarvvANi vikrIya sarvveSAM svasvaprayojanAnusAreNa vibhajya sarvvebhyo'dadan| ");
INSERT INTO sanhk_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","sarvva ekacittIbhUya dine dine mandire santiSThamAnA gRhe gRhe ca pUpAnabhaJjanta Izvarasya dhanyavAdaM kurvvanto lokaiH samAdRtAH paramAnandena saralAntaHkaraNena bhojanaM pAnaJcakurvvan| ");
INSERT INTO sanhk_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","paramezvaro dine dine paritrANabhAjanai rmaNDalIm avarddhayat| ");
INSERT INTO sanhk_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","tRtIyayAmavelAyAM satyAM prArthanAyAH samaye pitarayohanau sambhUya mandiraM gacchataH| ");
INSERT INTO sanhk_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","tasminneva samaye mandirapravezakAnAM samIpe bhikSAraNArthaM yaM janmakhaJjamAnuSaM lokA mandirasya sundaranAmni dvAre pratidinam asthApayan taM vahantastadvAraM Anayan| ");
INSERT INTO sanhk_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","tadA pitarayohanau mantiraM praveSTum udyatau vilokya sa khaJjastau kiJcid bhikSitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","tasmAd yohanA sahitaH pitarastam ananyadRSTyA nirIkSya proktavAn AvAM prati dRSTiM kuru| ");
INSERT INTO sanhk_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","tataH sa kiJcit prAptyAzayA tau prati dRSTiM kRtavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","tadA pitaro gaditavAn mama nikaTe svarNarUpyAdi kimapi nAsti kintu yadAste tad dadAmi nAsaratIyasya yIzukhrISTasya nAmnA tvamutthAya gamanAgamane kuru| ");
INSERT INTO sanhk_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","tataH paraM sa tasya dakSiNakaraM dhRtvA tam udatolayat; tena tatkSaNAt tasya janasya pAdagulphayoH sabalatvAt sa ullamphya protthAya gamanAgamane 'karot| ");
INSERT INTO sanhk_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","tato gamanAgamane kurvvan ullamphan IzvaraM dhanyaM vadan tAbhyAM sArddhaM mandiraM prAvizat| ");
INSERT INTO sanhk_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","tataH sarvve lokAstaM gamanAgamane kurvvantam IzvaraM dhanyaM vadantaJca vilokya ");
INSERT INTO sanhk_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","mandirasya sundare dvAre ya upavizya bhikSitavAn saevAyam iti jJAtvA taM prati tayA ghaTanayA camatkRtA vismayApannAzcAbhavan| ");
INSERT INTO sanhk_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","yaH khaJjaH svasthobhavat tena pitarayohanoH karayordhTatayoH satoH sarvve lokA sannidhim Agacchan| ");
INSERT INTO sanhk_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","tad dRSTvA pitarastebhyo'kathayat, he isrAyelIyalokA yUyaM kuto 'nenAzcaryyaM manyadhve? AvAM nijazaktyA yadvA nijapuNyena khaJjamanuSyamenaM gamitavantAviti cintayitvA AvAM prati kuto'nanyadRSTiM kurutha? ");
INSERT INTO sanhk_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","yaM yIzuM yUyaM parakareSu samArpayata tato yaM pIlAto mocayitum eैcchat tathApi yUyaM tasya sAkSAn nAGgIkRtavanta ibrAhIma ishAko yAkUbazcezvaro'rthAd asmAkaM pUrvvapuruSANAm IzvaraH svaputrasya tasya yIzo rmahimAnaM prAkAzayat| ");
INSERT INTO sanhk_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","kintu yUyaM taM pavitraM dhArmmikaM pumAMsaM nAGgIkRtya hatyAkAriNamekaM svebhyo dAtum ayAcadhvaM| ");
INSERT INTO sanhk_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","pazcAt taM jIvanasyAdhipatim ahata kintvIzvaraH zmazAnAt tam udasthApayata tatra vayaM sAkSiNa Asmahe| ");
INSERT INTO sanhk_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","imaM yaM mAnuSaM yUyaM pazyatha paricinutha ca sa tasya nAmni vizvAsakaraNAt calanazaktiM labdhavAn tasmin tasya yo vizvAsaH sa taM yuSmAkaM sarvveSAM sAkSAt sampUrNarUpeNa svastham akArSIt| ");
INSERT INTO sanhk_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","he bhrAtaro yUyaM yuSmAkam adhipatayazca ajJAtvA karmmANyetAni kRtavanta idAnIM mamaiSa bodho jAyate| ");
INSERT INTO sanhk_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","kintvIzvaraH khrISTasya duHkhabhoge bhaviSyadvAdinAM mukhebhyo yAM yAM kathAM pUrvvamakathayat tAH kathA itthaM siddhA akarot| ");
INSERT INTO sanhk_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","ataH sveSAM pApamocanArthaM khedaM kRtvA manAMsi parivarttayadhvaM, tasmAd IzvarAt sAntvanAprApteH samaya upasthAsyati; ");
INSERT INTO sanhk_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","punazca pUrvvakAlam Arabhya pracArito yo yIzukhrISTastam Izvaro yuSmAn prati preSayiSyati| ");
INSERT INTO sanhk_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","kintu jagataH sRSTimArabhya Izvaro nijapavitrabhaviSyadvAdigaNona yathA kathitavAn tadanusAreNa sarvveSAM kAryyANAM siddhiparyyantaM tena svarge vAsaH karttavyaH| ");
INSERT INTO sanhk_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","yuSmAkaM prabhuH paramezvaro yuSmAkaM bhrAtRgaNamadhyAt matsadRzaM bhaviSyadvaktAram utpAdayiSyati, tataH sa yat kiJcit kathayiSyati tatra yUyaM manAMsi nidhaddhvaM| ");
INSERT INTO sanhk_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","kintu yaH kazcit prANI tasya bhaviSyadvAdinaH kathAM na grahISyati sa nijalokAnAM madhyAd ucchetsyate,\" imAM kathAm asmAkaM pUrvvapuruSebhyaH kevalo mUsAH kathayAmAsa iti nahi, ");
INSERT INTO sanhk_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","zimUyelbhaviSyadvAdinam Arabhya yAvanto bhaviSyadvAkyam akathayan te sarvvaeva samayasyaitasya kathAm akathayan| ");
INSERT INTO sanhk_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","yUyamapi teSAM bhaviSyadvAdinAM santAnAH, \"tava vaMzodbhavapuMsA sarvvadezIyA lokA AziSaM prAptA bhaviSyanti\", ibrAhIme kathAmetAM kathayitvA IzvarosmAkaM pUrvvapuruSaiH sArddhaM yaM niyamaM sthirIkRtavAn tasya niyamasyAdhikAriNopi yUyaM bhavatha| ");
INSERT INTO sanhk_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ata Izvaro nijaputraM yIzum utthApya yuSmAkaM sarvveSAM svasvapApAt parAvarttya yuSmabhyam AziSaM dAtuM prathamatastaM yuSmAkaM nikaTaM preSitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","yasmin samaye pitarayohanau lokAn upadizatastasmin samaye yAjakA mandirasya senApatayaH sidUkIgaNazca ");
INSERT INTO sanhk_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","tayor upadezakaraNe khrISTasyotthAnam upalakSya sarvveSAM mRtAnAm utthAnaprastAve ca vyagrAH santastAvupAgaman| ");
INSERT INTO sanhk_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","tau dhRtvA dinAvasAnakAraNAt paradinaparyyanantaM ruddhvA sthApitavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","tathApi ye lokAstayorupadezam azRNvan teSAM prAyeNa paJcasahasrANi janA vyazvasan| ");
INSERT INTO sanhk_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","pare'hani adhipatayaH prAcInA adhyApakAzca hAnananAmA mahAyAjakaH ");
INSERT INTO sanhk_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","kiyaphA yohan sikandara ityAdayo mahAyAjakasya jJAtayaH sarvve yirUzAlamnagare militAH| ");
INSERT INTO sanhk_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","anantaraM preritau madhye sthApayitvApRcchan yuvAM kayA zaktayA vA kena nAmnA karmmANyetAni kuruthaH? ");
INSERT INTO sanhk_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","tadA pitaraH pavitreNAtmanA paripUrNaH san pratyavAdIt, he lokAnAm adhipatigaNa he isrAyelIyaprAcInAH, ");
INSERT INTO sanhk_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","etasya durbbalamAnuSasya hitaM yat karmmAkriyata, arthAt, sa yena prakAreNa svasthobhavat tacced adyAvAM pRcchatha, ");
INSERT INTO sanhk_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","tarhi sarvva isrAyeेlIyalokA yUyaM jAnIta nAsaratIyo yo yIzukhrISTaH kruze yuSmAbhiravidhyata yazcezvareNa zmazAnAd utthApitaH, tasya nAmnA janoyaM svasthaH san yuSmAkaM sammukhe prottiSThati| ");
INSERT INTO sanhk_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","nicetRbhi ryuSmAbhirayaM yaH prastaro'vajJAto'bhavat sa pradhAnakoNasya prastaro'bhavat| ");
INSERT INTO sanhk_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","tadbhinnAdaparAt kasmAdapi paritrANaM bhavituM na zaknoti, yena trANaM prApyeta bhUmaNDalasyalokAnAM madhye tAdRzaM kimapi nAma nAsti| ");
INSERT INTO sanhk_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","tadA pitarayohanoretAdRzIm akSebhatAM dRSTvA tAvavidvAMsau nIcalokAviti buddhvA Azcaryyam amanyanta tau ca yIzoH saGginau jAtAviti jJAtum azaknuvan| ");
INSERT INTO sanhk_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","kintu tAbhyAM sArddhaM taM svasthamAnuSaM tiSThantaM dRSTvA te kAmapyaparAm ApattiM karttaM nAzaknun| ");
INSERT INTO sanhk_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","tadA te sabhAtaH sthAnAntaraM gantuM tAn AjJApya svayaM parasparam iti mantraNAmakurvvan ");
INSERT INTO sanhk_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","tau mAnavau prati kiM karttavyaM? tAvekaM prasiddham AzcaryyaM karmma kRtavantau tad yirUzAlamnivAsinAM sarvveSAM lokAnAM samIpe prAkAzata tacca vayamapahnotuM na zaknumaH| ");
INSERT INTO sanhk_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","kintu lokAnAM madhyam etad yathA na vyApnoti tadarthaM tau bhayaM pradarzya tena nAmnA kamapi manuSyaM nopadizatam iti dRDhaM niSedhAmaH| ");
INSERT INTO sanhk_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","tataste preritAvAhUya etadAjJApayan itaH paraM yIzo rnAmnA kadApi kAmapi kathAM mA kathayataM kimapi nopadizaJca| ");
INSERT INTO sanhk_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","tataH pitarayohanau pratyavadatAm IzvarasyAjJAgrahaNaM vA yuSmAkam AjJAgrahaNam etayo rmadhye Izvarasya gocare kiM vihitaM? yUyaM tasya vivecanAM kuruta| ");
INSERT INTO sanhk_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","vayaM yad apazyAma yadazRNuma ca tanna pracArayiSyAma etat kadApi bhavituM na zaknoti| ");
INSERT INTO sanhk_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","yadaghaTata tad dRSTA sarvve lokA Izvarasya guNAn anvavadan tasmAt lokabhayAt tau daNDayituM kamapyupAyaM na prApya te punarapi tarjayitvA tAvatyajan| ");
INSERT INTO sanhk_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","yasya mAnuSasyaitat svAsthyakaraNam AzcaryyaM karmmAkriyata tasya vayazcatvAriMzadvatsarA vyatItAH| ");
INSERT INTO sanhk_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","tataH paraM tau visRSTau santau svasaGginAM sannidhiM gatvA pradhAnayAjakaiH prAcInalokaizca proktAH sarvvAH kathA jJApitavantau| ");
INSERT INTO sanhk_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","tacchrutvA sarvva ekacittIbhUya Izvaramuddizya proccairetat prArthayanta, he prabho gagaNapRthivIpayodhInAM teSu ca yadyad Aste teSAM sraSTezvarastvaM| ");
INSERT INTO sanhk_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","tvaM nijasevakena dAyUdA vAkyamidam uvacitha, manuSyA anyadezIyAH kurvvanti kalahaM kutaH| lokAH sarvve kimarthaM vA cintAM kurvvanti niSphalAM| ");
INSERT INTO sanhk_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","paramezasya tenaivAbhiSiktasya janasya ca| viruddhamabhitiSThanti pRthivyAH patayaH kutaH|| ");
INSERT INTO sanhk_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","phalatastava hastena mantraNayA ca pUrvva yadyat sthirIkRtaM tad yathA siddhaM bhavati tadarthaM tvaM yam athiSiktavAn sa eva pavitro yIzustasya prAtikUlyena herod pantIyapIlAto ");
INSERT INTO sanhk_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","'nyadezIyalokA isrAyellokAzca sarvva ete sabhAyAm atiSThan| ");
INSERT INTO sanhk_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","he paramezvara adhunA teSAM tarjanaM garjanaJca zRNu; ");
INSERT INTO sanhk_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","tathA svAsthyakaraNakarmmaNA tava bAhubalaprakAzapUrvvakaM tava sevakAn nirbhayena tava vAkyaM pracArayituM tava pavitraputrasya yIzo rnAmnA AzcaryyANyasambhavAni ca karmmANi karttuJcAjJApaya| ");
INSERT INTO sanhk_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","itthaM prArthanayA yatra sthAne te sabhAyAm Asan tat sthAnaM prAkampata; tataH sarvve pavitreNAtmanA paripUrNAH santa Izvarasya kathAm akSobheNa prAcArayan| ");
INSERT INTO sanhk_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","aparaJca pratyayakArilokasamUhA ekamanasa ekacittIbhUya sthitAH| teSAM kepi nijasampattiM svIyAM nAjAnan kintu teSAM sarvvAH sampattyaH sAdhAraNyena sthitAH| ");
INSERT INTO sanhk_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","anyacca preritA mahAzaktiprakAzapUrvvakaM prabho ryIzorutthAne sAkSyam adaduH, teSu sarvveSu mahAnugraho'bhavacca| ");
INSERT INTO sanhk_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","teSAM madhye kasyApi dravyanyUnatA nAbhavad yatasteSAM gRhabhUmyAdyA yAH sampattaya Asan tA vikrIya ");
INSERT INTO sanhk_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","tanmUlyamAnIya preritAnAM caraNeSu taiH sthApitaM; tataH pratyekazaH prayojanAnusAreNa dattamabhavat| ");
INSERT INTO sanhk_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","vizeSataH kupropadvIpIyo yosinAmako levivaMzajAta eko jano bhUmyadhikArI, yaM preritA barNabbA arthAt sAntvanAdAyaka ityuktvA samAhUyan, ");
INSERT INTO sanhk_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","sa jano nijabhUmiM vikrIya tanmUlyamAnIya preritAnAM caraNeSu sthApitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","tadA anAniyanAmaka eko jano yasya bhAryyAyA nAma saphIrA sa svAdhikAraM vikrIya ");
INSERT INTO sanhk_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","svabhAryyAM jJApayitvA tanmUlyasyaikAMzaM saGgopya sthApayitvA tadanyAMzamAtramAnIya preritAnAM caraNeSu samarpitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","tasmAt pitarokathayat he anAniya bhUme rmUlyaM kiJcit saGgopya sthApayituM pavitrasyAtmanaH sannidhau mRSAvAkyaM kathayituJca zaitAn kutastavAntaHkaraNe pravRttimajanayat? ");
INSERT INTO sanhk_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","sA bhUmi ryadA tava hastagatA tadA kiM tava svIyA nAsIt? tarhi svAntaHkaraNe kuta etAdRzI kukalpanA tvayA kRtA? tvaM kevalamanuSyasya nikaTe mRSAvAkyaM nAvAdIH kintvIzvarasya nikaTe'pi| ");
INSERT INTO sanhk_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","etAM kathAM zrutvaiva so'nAniyo bhUmau patan prANAn atyajat, tadvRttAntaM yAvanto lokA azRNvan teSAM sarvveSAM mahAbhayam ajAyat| ");
INSERT INTO sanhk_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","tadA yuvalokAstaM vastreNAcchAdya bahi rnItvA zmazAne'sthApayan| ");
INSERT INTO sanhk_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","tataH praharaikAnantaraM kiM vRttaM tannAvagatya tasya bhAryyApi tatra samupasthitA| ");
INSERT INTO sanhk_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","tataH pitarastAm apRcchat, yuvAbhyAm etAvanmudrAbhyo bhUmi rvikrItA na vA? etatvaM vada; tadA sA pratyavAdIt satyam etAvadbhyo mudrAbhya eva| ");
INSERT INTO sanhk_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","tataH pitarokathayat yuvAM kathaM paramezvarasyAtmAnaM parIkSitum ekamantraNAvabhavatAM? pazya ye tava patiM zmazAne sthApitavantaste dvArasya samIpe samupatiSThanti tvAmapi bahirneSyanti| ");
INSERT INTO sanhk_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","tataH sApi tasya caraNasannidhau patitvA prANAn atyAkSIt| pazcAt te yuvAno'bhyantaram Agatya tAmapi mRtAM dRSTvA bahi rnItvA tasyAH patyuH pArzve zmazAne sthApitavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","tasmAt maNDalyAH sarvve lokA anyalokAzca tAM vArttAM zrutvA sAdhvasaM gatAH| ");
INSERT INTO sanhk_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","tataH paraM preritAnAM hastai rlokAnAM madhye bahvAzcaryyANyadbhutAni karmmANyakriyanta; tadA ziSyAH sarvva ekacittIbhUya sulemAno 'linde sambhUyAsan| ");
INSERT INTO sanhk_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","teSAM saGghAntargo bhavituM kopi pragalbhatAM nAgamat kintu lokAstAn samAdriyanta| ");
INSERT INTO sanhk_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","striyaH puruSAzca bahavo lokA vizvAsya prabhuM zaraNamApannAH| ");
INSERT INTO sanhk_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","pitarasya gamanAgamanAbhyAM kenApi prakAreNa tasya chAyA kasmiMzcijjane lagiSyatItyAzayA lokA rogiNaH zivikayA khaTvayA cAnIya pathi pathi sthApitavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","caturdiksthanagarebhyo bahavo lokAH sambhUya rogiNo'pavitrabhutagrastAMzca yirUzAlamam Anayan tataH sarvve svasthA akriyanta| ");
INSERT INTO sanhk_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","anantaraM mahAyAjakaH sidUkinAM matagrAhiNasteSAM sahacarAzca ");
INSERT INTO sanhk_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","mahAkrodhAntvitAH santaH preritAn dhRtvA nIcalokAnAM kArAyAM baddhvA sthApitavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","kintu rAtrau paramezvarasya dUtaH kArAyA dvAraM mocayitvA tAn bahirAnIyAkathayat, ");
INSERT INTO sanhk_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","yUyaM gatvA mandire daNDAyamAnAH santo lokAn pratImAM jIvanadAyikAM sarvvAM kathAM pracArayata| ");
INSERT INTO sanhk_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","iti zrutvA te pratyUSe mandira upasthAya upadiSTavantaH| tadA sahacaragaNena sahito mahAyAjaka Agatya mantrigaNam isrAyelvaMzasya sarvvAn rAjasabhAsadaH sabhAsthAn kRtvA kArAyAstAn ApayituM padAtigaNaM preritavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","tataste gatvA kArAyAM tAn aprApya pratyAgatya iti vArttAm avAdiSuH, ");
INSERT INTO sanhk_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","vayaM tatra gatvA nirvvighnaM kArAyA dvAraM ruddhaM rakSakAMzca dvArasya bahirdaNDAyamAnAn adarzAma eva kintu dvAraM mocayitvA tanmadhye kamapi draSTuM na prAptAH| ");
INSERT INTO sanhk_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","etAM kathAM zrutvA mahAyAjako mandirasya senApatiH pradhAnayAjakAzca, ita paraM kimaparaM bhaviSyatIti cintayitvA sandigdhacittA abhavan| ");
INSERT INTO sanhk_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","etasminneva samaye kazcit jana Agatya vArttAmetAm avadat pazyata yUyaM yAn mAnavAn kArAyAm asthApayata te mandire tiSThanto lokAn upadizanti| ");
INSERT INTO sanhk_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","tadA mandirasya senApatiH padAtayazca tatra gatvA cellokAH pASANAn nikSipyAsmAn mArayantIti bhiyA vinatyAcAraM tAn Anayan| ");
INSERT INTO sanhk_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","te mahAsabhAyA madhye tAn asthApayan tataH paraM mahAyAjakastAn apRcchat, ");
INSERT INTO sanhk_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","anena nAmnA samupadeSTuM vayaM kiM dRDhaM na nyaSedhAma? tathApi pazyata yUyaM sveSAM tenopadezene yirUzAlamaM paripUrNaM kRtvA tasya janasya raktapAtajanitAparAdham asmAn pratyAnetuM ceSTadhve| ");
INSERT INTO sanhk_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","tataH pitaronyapreritAzca pratyavadan mAnuSasyAjJAgrahaNAd IzvarasyAjJAgrahaNam asmAkamucitam| ");
INSERT INTO sanhk_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","yaM yIzuM yUyaM kruze vedhitvAhata tam asmAkaM paitRka Izvara utthApya ");
INSERT INTO sanhk_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","isrAyelvaMzAnAM manaHparivarttanaM pApakSamAJca karttuM rAjAnaM paritrAtAraJca kRtvA svadakSiNapArzve tasyAnnatim akarot| ");
INSERT INTO sanhk_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","etasmin vayamapi sAkSiNa Asmahe, tat kevalaM nahi, Izvara AjJAgrAhibhyo yaM pavitram AtmanaM dattavAn sopi sAkSyasti| ");
INSERT INTO sanhk_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","etadvAkye zrute teSAM hRdayAni viddhAnyabhavan tataste tAn hantuM mantritavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","etasminneva samaye tatsabhAsthAnAM sarvvalokAnAM madhye sukhyAto gamilIyelnAmaka eko jano vyavasthApakaH phirUziloka utthAya preritAn kSaNArthaM sthAnAntaraM gantum Adizya kathitavAn, ");
INSERT INTO sanhk_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","he isrAyelvaMzIyAH sarvve yUyam etAn mAnuSAn prati yat karttum udyatAstasmin sAvadhAnA bhavata| ");
INSERT INTO sanhk_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","itaH pUrvvaM thUdAnAmaiko jana upasthAya svaM kamapi mahApuruSam avadat, tataH prAyeNa catuHzatalokAstasya matagrAhiNobhavan pazcAt sa hatobhavat tasyAjJAgrAhiNo yAvanto lokAste sarvve virkIrNAH santo 'kRtakAryyA abhavan| ");
INSERT INTO sanhk_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","tasmAjjanAt paraM nAmalekhanasamaye gAlIlIyayihUdAnAmaiko jana upasthAya bahUllokAn svamataM grAhItavAn tataH sopi vyanazyat tasyAjJAgrAhiNo yAvanto lokA Asan te sarvve vikIrNA abhavan| ");
INSERT INTO sanhk_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","adhunA vadAmi, yUyam etAn manuSyAn prati kimapi na kRtvA kSAntA bhavata, yata eSa saGkalpa etat karmma ca yadi manuSyAdabhavat tarhi viphalaM bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","yadIzvarAdabhavat tarhi yUyaM tasyAnyathA karttuM na zakSyatha, varam IzvararodhakA bhaviSyatha| ");
INSERT INTO sanhk_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","tadA tasya mantraNAM svIkRtya te preritAn AhUya prahRtya yIzo rnAmnA kAmapi kathAM kathayituM niSidhya vyasarjan| ");
INSERT INTO sanhk_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","kintu tasya nAmArthaM vayaM lajjAbhogasya yogyatvena gaNitA ityatra te sAnandAH santaH sabhAsthAnAM sAkSAd agacchan| ");
INSERT INTO sanhk_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","tataH paraM pratidinaM mandire gRhe gRhe cAvizrAmam upadizya yIzukhrISTasya susaMvAdaM pracAritavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","tasmin samaye ziSyANAM bAhulyAt prAtyahikadAnasya vizrANanai rbhinnadezIyAnAM vidhavAstrIgaNa upekSite sati ibrIyalokaiH sahAnyadezIyAnAM vivAda upAtiSThat| ");
INSERT INTO sanhk_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","tadA dvAdazapreritAH sarvvAn ziSyAn saMgRhyAkathayan Izvarasya kathApracAraM parityajya bhojanagaveSaNam asmAkam ucitaM nahi| ");
INSERT INTO sanhk_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ato he bhrAtRgaNa vayam etatkarmmaNo bhAraM yebhyo dAtuM zaknuma etAdRzAn sukhyAtyApannAn pavitreNAtmanA jJAnena ca pUrNAn sapprajanAn yUyaM sveSAM madhye manonItAn kuruta, ");
INSERT INTO sanhk_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","kintu vayaM prArthanAyAM kathApracArakarmmaNi ca nityapravRttAH sthAsyAmaH| ");
INSERT INTO sanhk_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","etasyAM kathAyAM sarvve lokAH santuSTAH santaH sveSAM madhyAt stiphAnaH philipaH prakharo nikAnor tIman parmmiNA yihUdimatagrAhI-AntiyakhiyAnagarIyo nikalA etAn paramabhaktAn pavitreNAtmanA paripUrNAn sapta janAn ");
INSERT INTO sanhk_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","preritAnAM samakSam Anayan, tataste prArthanAM kRtvA teSAM ziraHsu hastAn Arpayan| ");
INSERT INTO sanhk_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","aparaJca Izvarasya kathA dezaM vyApnot vizeSato yirUzAlami nagare ziSyANAM saMkhyA prabhUtarUpeNAvarddhata yAjakAnAM madhyepi bahavaH khrISTamatagrAhiNo'bhavan| ");
INSERT INTO sanhk_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","stiphAnoे vizvAsena parAkrameNa ca paripUrNaH san lokAnAM madhye bahuvidham adbhutam AzcaryyaM karmmAkarot| ");
INSERT INTO sanhk_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","tena libarttinIyanAmnA vikhyAtasaGghasya katipayajanAH kurINIyasikandarIya-kilikIyAzIyAdezIyAH kiyanto janAzcotthAya stiphAnena sArddhaM vyavadanta| ");
INSERT INTO sanhk_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","kintu stiphAno jJAnena pavitreNAtmanA ca IdRzIM kathAM kathitavAn yasyAste ApattiM karttuM nAzaknuvan| ");
INSERT INTO sanhk_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","pazcAt tai rlobhitAH katipayajanAH kathAmenAm akathayan, vayaM tasya mukhato mUsA Izvarasya ca nindAvAkyam azrauSma| ");
INSERT INTO sanhk_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","te lokAnAM lokaprAcInAnAm adhyApakAnAJca pravRttiM janayitvA stiphAnasya sannidhim Agatya taM dhRtvA mahAsabhAmadhyam Anayan| ");
INSERT INTO sanhk_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","tadanantaraM katipayajaneSu mithyAsAkSiSu samAnIteSu te'kathayan eSa jana etatpuNyasthAnavyavasthayo rnindAtaH kadApi na nivarttate| ");
INSERT INTO sanhk_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","phalato nAsaratIyayIzuH sthAnametad ucchinnaM kariSyati mUsAsamarpitam asmAkaM vyavaharaNam anyarUpaM kariSyati tasyaitAdRzIM kathAM vayam azRNuma| ");
INSERT INTO sanhk_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","tadA mahAsabhAsthAH sarvve taM prati sthirAM dRSTiM kRtvA svargadUtamukhasadRzaM tasya mukham apazyan| ");
INSERT INTO sanhk_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","tataH paraM mahAyAjakaH pRSTavAn, eSA kathAM kiM satyA? ");
INSERT INTO sanhk_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","tataH sa pratyavadat, he pitaro he bhrAtaraH sarvve lAkA manAMsi nidhaddhvaM|asmAkaM pUrvvapuruSa ibrAhIm hAraNnagare vAsakaraNAt pUrvvaM yadA arAm-naharayimadeze AsIt tadA tejomaya Izvaro darzanaM datvA ");
INSERT INTO sanhk_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","tamavadat tvaM svadezajJAtimitrANi parityajya yaM dezamahaM darzayiSyAmi taM dezaM vraja| ");
INSERT INTO sanhk_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","ataH sa kasdIyadezaM vihAya hAraNnagare nyavasat, tadanantaraM tasya pitari mRte yatra deze yUyaM nivasatha sa enaM dezamAgacchat| ");
INSERT INTO sanhk_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","kintvIzvarastasmai kamapyadhikAram arthAd ekapadaparimitAM bhUmimapi nAdadAt; tadA tasya kopi santAno nAsIt tathApi santAnaiH sArddham etasya dezasyAdhikArI tvaM bhaviSyasIti tampratyaGgIkRtavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Izvara ittham aparamapi kathitavAn tava santAnAH paradeze nivatsyanti tatastaddezIyalokAzcatuHzatavatsarAn yAvat tAn dAsatve sthApayitvA tAn prati kuvyavahAraM kariSyanti| ");
INSERT INTO sanhk_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","aparam Izvara enAM kathAmapi kathitavAn, ye lokAstAn dAsatve sthApayiSyanti tAllokAn ahaM daNDayiSyAmi, tataH paraM te bahirgatAH santo mAm atra sthAne seviSyante| ");
INSERT INTO sanhk_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","pazcAt sa tasmai tvakchedasya niyamaM dattavAn, ata ishAkanAmni ibrAhIma ekaputre jAte, aSTamadine tasya tvakchedam akarot| tasya ishAkaH putro yAkUb, tatastasya yAkUbo'smAkaM dvAdaza pUrvvapuruSA ajAyanta| ");
INSERT INTO sanhk_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","te pUrvvapuruSA IrSyayA paripUrNA misaradezaM preSayituM yUSaphaM vyakrINan| ");
INSERT INTO sanhk_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","kintvIzvarastasya sahAyo bhUtvA sarvvasyA durgate rakSitvA tasmai buddhiM dattvA misaradezasya rAjJaH phirauNaH priyapAtraM kRtavAn tato rAjA misaradezasya svIyasarvvaparivArasya ca zAsanapadaM tasmai dattavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","tasmin samaye misara-kinAnadezayo rdurbhikSahetoratikliSTatvAt naH pUrvvapuruSA bhakSyadravyaM nAlabhanta| ");
INSERT INTO sanhk_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","kintu misaradeze zasyAni santi, yAkUb imAM vArttAM zrutvA prathamam asmAkaM pUrvvapuruSAn misaraM preSitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","tato dvitIyavAragamane yUSaph svabhrAtRbhiH paricito'bhavat; yUSapho bhrAtaraH phirauN rAjena paricitA abhavan| ");
INSERT INTO sanhk_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","anantaraM yUSaph bhrAtRgaNaM preSya nijapitaraM yAkUbaM nijAn paJcAdhikasaptatisaMkhyakAn jJAtijanAMzca samAhUtavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","tasmAd yAkUb misaradezaM gatvA svayam asmAkaM pUrvvapuruSAzca tasmin sthAne'mriyanta| ");
INSERT INTO sanhk_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","tataste zikhimaM nItA yat zmazAnam ibrAhIm mudrAdatvA zikhimaH pitu rhamoraH putrebhyaH krItavAn tatzmazAne sthApayAJcakrire| ");
INSERT INTO sanhk_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","tataH param Izvara ibrAhImaH sannidhau zapathaM kRtvA yAM pratijJAM kRtavAn tasyAH pratijJAyAH phalanasamaye nikaTe sati isrAyellokA simaradeze varddhamAnA bahusaMkhyA abhavan| ");
INSERT INTO sanhk_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","zeSe yUSaphaM yo na paricinoti tAdRza eko narapatirupasthAya ");
INSERT INTO sanhk_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","asmAkaM jJAtibhiH sArddhaM dhUrttatAM vidhAya pUrvvapuruSAn prati kuvyavaharaNapUrvvakaM teSAM vaMzanAzanAya teSAM navajAtAn zizUn bahi rnirakSepayat| ");
INSERT INTO sanhk_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","etasmin samaye mUsA jajJe, sa tu paramasundaro'bhavat tathA pitRgRhe mAsatrayaparyyantaM pAlito'bhavat| ");
INSERT INTO sanhk_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","kintu tasmin bahirnikSipte sati phirauNarAjasya kanyA tam uttolya nItvA dattakaputraM kRtvA pAlitavatI| ");
INSERT INTO sanhk_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","tasmAt sa mUsA misaradezIyAyAH sarvvavidyAyAH pAradRSvA san vAkye kriyAyAJca zaktimAn abhavat| ");
INSERT INTO sanhk_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","sa sampUrNacatvAriMzadvatsaravayasko bhUtvA isrAyelIyavaMzanijabhrAtRn sAkSAt kartuM matiM cakre| ");
INSERT INTO sanhk_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","teSAM janamekaM hiMsitaM dRSTvA tasya sapakSaH san hiMsitajanam upakRtya misarIyajanaM jaghAna| ");
INSERT INTO sanhk_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","tasya hastenezvarastAn uddhariSyati tasya bhrAtRgaNa iti jJAsyati sa ityanumAnaM cakAra, kintu te na bubudhire| ");
INSERT INTO sanhk_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","tatpare 'hani teSAm ubhayo rjanayo rvAkkalaha upasthite sati mUsAH samIpaM gatvA tayo rmelanaM karttuM matiM kRtvA kathayAmAsa, he mahAzayau yuvAM bhrAtarau parasparam anyAyaM kutaH kuruthaH? ");
INSERT INTO sanhk_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","tataH samIpavAsinaM prati yo jano'nyAyaM cakAra sa taM dUrIkRtya kathayAmAsa, asmAkamupari zAstRtvavicArayitRtvapadayoH kastvAM niyuktavAn? ");
INSERT INTO sanhk_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","hyo yathA misarIyaM hatavAn tathA kiM mAmapi haniSyasi? ");
INSERT INTO sanhk_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","tadA mUsA etAdRzIM kathAM zrutvA palAyanaM cakre, tato midiyanadezaM gatvA pravAsI san tasthau, tatastatra dvau putrau jajJAte| ");
INSERT INTO sanhk_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","anantaraM catvAriMzadvatsareSu gateSu sInayaparvvatasya prAntare prajvalitastambasya vahnizikhAyAM paramezvaradUtastasmai darzanaM dadau| ");
INSERT INTO sanhk_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","mUsAstasmin darzane vismayaM matvA vizeSaM jJAtuM nikaTaM gacchati, ");
INSERT INTO sanhk_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","etasmin samaye, ahaM tava pUrvvapuruSANAm Izvaro'rthAd ibrAhIma Izvara ishAka Izvaro yAkUba Izvarazca, mUsAmuddizya paramezvarasyaitAdRzI vihAyasIyA vANI babhUva, tataH sa kampAnvitaH san puna rnirIkSituM pragalbho na babhUva| ");
INSERT INTO sanhk_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","paramezvarastaM jagAda, tava pAdayoH pAduke mocaya yatra tiSThasi sA pavitrabhUmiH| ");
INSERT INTO sanhk_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ahaM misaradezasthAnAM nijalokAnAM durddazAM nitAntam apazyaM, teSAM kAtaryyoktiJca zrutavAn tasmAt tAn uddharttum avaruhyAgamam; idAnIm Agaccha misaradezaM tvAM preSayAmi| ");
INSERT INTO sanhk_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","kastvAM zAstRtvavicArayitRtvapadayo rniyuktavAn, iti vAkyamuktvA tai ryo mUsA avajJAtastameva IzvaraH stambamadhye darzanadAtrA tena dUtena zAstAraM muktidAtAraJca kRtvA preSayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","sa ca misaradeze sUphnAmni samudre ca pazcAt catvAriMzadvatsarAn yAvat mahAprAntare nAnAprakArANyadbhutAni karmmANi lakSaNAni ca darzayitvA tAn bahiH kRtvA samAninAya| ");
INSERT INTO sanhk_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","prabhuH paramezvaro yuSmAkaM bhrAtRgaNasya madhye mAdRzam ekaM bhaviSyadvaktAram utpAdayiSyati tasya kathAyAM yUyaM mano nidhAsyatha, yo jana isrAyelaH santAnebhya enAM kathAM kathayAmAsa sa eSa mUsAH| ");
INSERT INTO sanhk_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","mahAprAntarasthamaNDalImadhye'pi sa eva sInayaparvvatopari tena sArddhaM saMlApino dUtasya cAsmatpitRgaNasya madhyasthaH san asmabhyaM dAtavyani jIvanadAyakAni vAkyAni lebhe| ");
INSERT INTO sanhk_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","asmAkaM pUrvvapuruSAstam amAnyaM katvA svebhyo dUrIkRtya misaradezaM parAvRtya gantuM manobhirabhilaSya hAroNaM jagaduH, ");
INSERT INTO sanhk_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","asmAkam agre'gre gantuुm asmadarthaM devagaNaM nirmmAhi yato yo mUsA asmAn misaradezAd bahiH kRtvAnItavAn tasya kiM jAtaM tadasmAbhi rna jJAyate| ");
INSERT INTO sanhk_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","tasmin samaye te govatsAkRtiM pratimAM nirmmAya tAmuddizya naivedyamutmRjya svahastakRtavastunA AnanditavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","tasmAd IzvarasteSAM prati vimukhaH san AkAzasthaM jyotirgaNaM pUjayituM tebhyo'numatiM dadau, yAdRzaM bhaviSyadvAdinAM grantheSu likhitamAste, yathA, isrAyelIyavaMzA re catvAriMzatsamAn purA| mahati prAntare saMsthA yUyantu yAni ca| balihomAdikarmmANi kRtavantastu tAni kiM| mAM samuddizya yuSmAbhiH prakRtAnIti naiva ca| ");
INSERT INTO sanhk_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","kintu vo molakAkhyasya devasya dUSyameva ca| yuSmAkaM rimphanAkhyAyA devatAyAzca tArakA| etayorubhayo rmUrtI yuSmAbhiH paripUjite| ato yuSmAMstu bAbelaH pAraM neSyAmi nizcitaM| ");
INSERT INTO sanhk_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","aparaJca yannidarzanam apazyastadanusAreNa dUSyaM nirmmAhi yasmin Izvaro mUsAm etadvAkyaM babhASe tat tasya nirUpitaM sAkSyasvarUpaM dUSyam asmAkaM pUrvvapuruSaiH saha prAntare tasthau| ");
INSERT INTO sanhk_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","pazcAt yihozUyena sahitaisteSAM vaMzajAtairasmatpUrvvapuruSaiH sveSAM sammukhAd IzvareNa dUrIkRtAnAm anyadezIyAnAM dezAdhikRtikAle samAnItaM tad dUSyaM dAyUdodhikAraM yAvat tatra sthAna AsIt| ");
INSERT INTO sanhk_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","sa dAyUd paramezvarasyAnugrahaM prApya yAkUb IzvarArtham ekaM dUSyaM nirmmAtuM vavAJcha; ");
INSERT INTO sanhk_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","kintu sulemAn tadarthaM mandiram ekaM nirmmitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","tathApi yaH sarvvoparisthaH sa kasmiMzcid hastakRte mandire nivasatIti nahi, bhaviSyadvAdI kathAmetAM kathayati, yathA, ");
INSERT INTO sanhk_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","parezo vadati svargo rAjasiMhAsanaM mama| madIyaM pAdapIThaJca pRthivI bhavati dhruvaM| tarhi yUyaM kRte me kiM pranirmmAsyatha mandiraM| vizrAmAya madIyaM vA sthAnaM kiM vidyate tviha| ");
INSERT INTO sanhk_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","sarvvANyetAni vastUni kiM me hastakRtAni na|| ");
INSERT INTO sanhk_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","he anAjJAgrAhakA antaHkaraNe zravaNe cApavitralokAH yUyam anavarataM pavitrasyAtmanaH prAtikUlyam Acaratha, yuSmAkaM pUrvvapuruSA yAdRzA yUyamapi tAdRzAH| ");
INSERT INTO sanhk_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","yuSmAkaM pUrvvapuruSAH kaM bhaviSyadvAdinaM nAtADayan? ye tasya dhArmmikasya janasyAgamanakathAM kathitavantastAn aghnan yUyam adhUnA vizvAsaghAtino bhUtvA taM dhArmmikaM janam ahata| ");
INSERT INTO sanhk_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","yUyaM svargIyadUtagaNena vyavasthAM prApyApi tAM nAcaratha| ");
INSERT INTO sanhk_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","imAM kathAM zrutvA te manaHsu biddhAH santastaM prati dantagharSaNam akurvvan| ");
INSERT INTO sanhk_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","kintu stiphAnaH pavitreNAtmanA pUrNo bhUtvA gagaNaM prati sthiradRSTiM kRtvA Izvarasya dakSiNe daNDAyamAnaM yIzuJca vilokya kathitavAn; ");
INSERT INTO sanhk_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","pazya,meghadvAraM muktam Izvarasya dakSiNe sthitaM mAnavasutaJca pazyAmi| ");
INSERT INTO sanhk_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","tadA te proccaiH zabdaM kRtvA karNeSvaGgulI rnidhAya ekacittIbhUya tam Akraman| ");
INSERT INTO sanhk_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","pazcAt taM nagarAd bahiH kRtvA prastarairAghnan sAkSiNo lAkAH zaulanAmno yUnazcaraNasannidhau nijavastrANi sthApitavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","anantaraM he prabho yIze madIyamAtmAnaM gRhANa stiphAnasyeti prArthanavAkyavadanasamaye te taM prastarairAghnan| ");
INSERT INTO sanhk_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","tasmAt sa jAnunI pAtayitvA proccaiH zabdaM kRtvA, he prabhe pApametad eteSu mA sthApaya, ityuktvA mahAnidrAM prApnot| ");
INSERT INTO sanhk_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","tasya hatyAkaraNaM zaulopi samamanyata| tasmin samaye yirUzAlamnagarasthAM maNDalIM prati mahAtADanAyAM jAtAyAM preritalokAn hitvA sarvve'pare yihUdAzomiroNadezayo rnAnAsthAne vikIrNAH santo gatAH| ");
INSERT INTO sanhk_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","anyacca bhaktalokAstaM stiphAnaM zmazAne sthApayitvA bahu vyalapan| ");
INSERT INTO sanhk_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","kintu zaulo gRhe gRhe bhramitvA striyaH puruSAMzca dhRtvA kArAyAM baddhvA maNDalyA mahotpAtaM kRtavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","anyacca ye vikIrNA abhavan te sarvvatra bhramitvA susaMvAdaM prAcArayan| ");
INSERT INTO sanhk_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","tadA philipaH zomiroNnagaraM gatvA khrISTAkhyAnaM prAcArayat; ");
INSERT INTO sanhk_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","tato'zuci-bhRtagrastalokebhyo bhUtAzcItkRtyAgacchan tathA bahavaH pakSAghAtinaH khaJjA lokAzca svasthA abhavan| ");
INSERT INTO sanhk_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","tasmAt lAkA IdRzaM tasyAzcaryyaM karmma vilokya nizamya ca sarvva ekacittIbhUya tenoktAkhyAne manAMsi nyadadhuH| ");
INSERT INTO sanhk_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","tasminnagare mahAnandazcAbhavat| ");
INSERT INTO sanhk_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","tataH pUrvvaM tasminnagare zimonnAmA kazcijjano bahvI rmAyAkriyAH kRtvA svaM kaJcana mahApuruSaM procya zomiroNIyAnAM mohaM janayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","tasmAt sa mAnuSa Izvarasya mahAzaktisvarUpa ityuktvA bAlavRddhavanitAH sarvve lAkAstasmin manAMsi nyadadhuH| ");
INSERT INTO sanhk_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","sa bahukAlAn mAyAvikriyayA sarvvAn atIva mohayAJcakAra, tasmAt te taM menire| ");
INSERT INTO sanhk_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","kintvIzvarasya rAjyasya yIzukhrISTasya nAmnazcAkhyAnapracAriNaH philipasya kathAyAM vizvasya teSAM strIpuruSobhayalokA majjitA abhavan| ");
INSERT INTO sanhk_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","zeSe sa zimonapi svayaM pratyait tato majjitaH san philipena kRtAm AzcaryyakriyAM lakSaNaJca vilokyAsambhavaM manyamAnastena saha sthitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","itthaM zomiroNdezIyalokA Izvarasya kathAm agRhlan iti vArttAM yirUzAlamnagarasthapreritAH prApya pitaraM yohanaJca teSAM nikaTe preSitavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","tatastau tat sthAnam upasthAya lokA yathA pavitram AtmAnaM prApnuvanti tadarthaM prArthayetAM| ");
INSERT INTO sanhk_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","yataste purA kevalaprabhuyIzo rnAmnA majjitamAtrA abhavan, na tu teSAM madhye kamapi prati pavitrasyAtmana AvirbhAvo jAtaH| ");
INSERT INTO sanhk_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","kintu preritAbhyAM teSAM gAtreSu kareSvarpiteSu satsu te pavitram AtmAnam prApnuvan| ");
INSERT INTO sanhk_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","itthaM lokAnAM gAtreSu preritayoH karArpaNena tAn pavitram AtmAnaM prAptAn dRSTvA sa zimon tayoH samIpe mudrA AnIya kathitavAn; ");
INSERT INTO sanhk_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ahaM yasya gAtre hastam arpayiSyAmi tasyApi yathetthaM pavitrAtmaprApti rbhavati tAdRzIM zaktiM mahyaM dattaM| ");
INSERT INTO sanhk_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","kintu pitarastaM pratyavadat tava mudrAstvayA vinazyantu yata Izvarasya dAnaM mudrAbhiH krIyate tvamitthaM buddhavAn; ");
INSERT INTO sanhk_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","IzvarAya tAvantaHkaraNaM saralaM nahi, tasmAd atra tavAMzo'dhikArazca kopi nAsti| ");
INSERT INTO sanhk_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ata etatpApahetoH khedAnvitaH san kenApi prakAreNa tava manasa etasyAH kukalpanAyAH kSamA bhavati, etadartham Izvare prArthanAM kuru; ");
INSERT INTO sanhk_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","yatastvaM tiktapitte pApasya bandhane ca yadasi tanmayA buddham| ");
INSERT INTO sanhk_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","tadA zimon akathayat tarhi yuvAbhyAmuditA kathA mayi yathA na phalati tadarthaM yuvAM mannimittaM prabhau prArthanAM kurutaM| ");
INSERT INTO sanhk_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","anena prakAreNa tau sAkSyaM dattvA prabhoH kathAM pracArayantau zomiroNIyAnAm anekagrAmeSu susaMvAdaJca pracArayantau yirUzAlamnagaraM parAvRtya gatau| ");
INSERT INTO sanhk_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","tataH param Izvarasya dUtaH philipam ityAdizat, tvamutthAya dakSiNasyAM dizi yo mArgo prAntarasya madhyena yirUzAlamo 'sAnagaraM yAti taM mArgaM gaccha| ");
INSERT INTO sanhk_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","tataH sa utthAya gatavAn; tadA kandAkInAmnaH kUzlokAnAM rAjJyAH sarvvasampatteradhIzaH kUzadezIya ekaH SaNDo bhajanArthaM yirUzAlamnagaram Agatya ");
INSERT INTO sanhk_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","punarapi rathamAruhya yizayiyanAmno bhaviSyadvAdino granthaM paThan pratyAgacchati| ");
INSERT INTO sanhk_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","etasmin samaye AtmA philipam avadat, tvam rathasya samIpaM gatvA tena sArddhaM mila| ");
INSERT INTO sanhk_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","tasmAt sa dhAvan tasya sannidhAvupasthAya tena paThyamAnaM yizayiyathaviSyadvAdino vAkyaM zrutvA pRSTavAn yat paThasi tat kiM budhyase? ");
INSERT INTO sanhk_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","tataH sa kathitavAn kenacinna bodhitohaM kathaM budhyeya? tataH sa philipaM rathamAroDhuM svena sArddham upaveSTuJca nyavedayat| ");
INSERT INTO sanhk_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","sa zAstrasyetadvAkyaM paThitavAn yathA, samAnIyata ghAtAya sa yathA meSazAvakaH| lomacchedakasAkSAcca meSazca nIravo yathA| Abadhya vadanaM svIyaM tathA sa samatiSThata| ");
INSERT INTO sanhk_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","anyAyena vicAreNa sa ucchinno 'bhavat tadA| tatkAlInamanuSyAn ko jano varNayituM kSamaH| yato jIvannRNAM dezAt sa ucchinno 'bhavat dhruvaM| ");
INSERT INTO sanhk_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","anantaraM sa philipam avadat nivedayAmi, bhaviSyadvAdI yAmimAM kathAM kathayAmAsa sa kiM svasmin vA kasmiMzcid anyasmin? ");
INSERT INTO sanhk_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","tataH philipastatprakaraNam Arabhya yIzorupAkhyAnaM tasyAgre prAstaut| ");
INSERT INTO sanhk_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","itthaM mArgeNa gacchantau jalAzayasya samIpa upasthitau; tadA klIbo'vAdIt pazyAtra sthAne jalamAste mama majjane kA bAdhA? ");
INSERT INTO sanhk_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","tataH philipa uttaraM vyAharat svAntaHkaraNena sAkaM yadi pratyeSi tarhi bAdhA nAsti| tataH sa kathitavAn yIzukhrISTa Izvarasya putra ityahaM pratyemi| ");
INSERT INTO sanhk_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","tadA rathaM sthagitaM karttum AdiSTe philipaklIbau dvau jalam avAruhatAM; tadA philipastam majjayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","tatpazcAt jalamadhyAd utthitayoH satoH paramezvarasyAtmA philipaM hRtvA nItavAn, tasmAt klIbaH punastaM na dRSTavAn tathApi hRSTacittaH san svamArgeNa gatavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","philipazcAsdodnagaram upasthAya tasmAt kaisariyAnagara upasthitikAlaparyyanataM sarvvasminnagare susaMvAdaM pracArayan gatavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","tatkAlaparyyanataM zaulaH prabhoH ziSyANAM prAtikUlyena tADanAbadhayoH kathAM niHsArayan mahAyAjakasya sannidhiM gatvA ");
INSERT INTO sanhk_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","striyaM puruSaJca tanmatagrAhiNaM yaM kaJcit pazyati tAn dhRtvA baddhvA yirUzAlamam AnayatItyAzayena dammeSaknagarIyaM dharmmasamAjAn prati patraM yAcitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","gacchan tu dammeSaknagaranikaTa upasthitavAn; tato'kasmAd AkAzAt tasya caturdikSu tejasaH prakAzanAt sa bhUmAvapatat| ");
INSERT INTO sanhk_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","pazcAt he zaula he zaula kuto mAM tADayasi? svaM prati proktam etaM zabdaM zrutvA ");
INSERT INTO sanhk_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","sa pRSTavAn, he prabho bhavAn kaH? tadA prabhurakathayat yaM yIzuM tvaM tADayasi sa evAhaM; kaNTakasya mukhe padAghAtakaraNaM tava kaSTam| ");
INSERT INTO sanhk_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","tadA kampamAno vismayApannazca sovadat he prabho mayA kiM karttavyaM? bhavata icchA kA? tataH prabhurAjJApayad utthAya nagaraM gaccha tatra tvayA yat karttavyaM tad vadiSyate| ");
INSERT INTO sanhk_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","tasya saGgino lokA api taM zabdaM zrutavantaH kintu kamapi na dRSTvA stabdhAH santaH sthitavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","anantaraM zaulo bhUmita utthAya cakSuSI unmIlya kamapi na dRSTavAn| tadA lokAstasya hastau dhRtvA dammeSaknagaram Anayan| ");
INSERT INTO sanhk_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","tataH sa dinatrayaM yAvad andho bhUtvA na bhuktavAn pItavAMzca| ");
INSERT INTO sanhk_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","tadanantaraM prabhustaddammeSaknagaravAsina ekasmai ziSyAya darzanaM datvA AhUtavAn he ananiya| tataH sa pratyavAdIt, he prabho pazya zRNomi| ");
INSERT INTO sanhk_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","tadA prabhustamAjJApayat tvamutthAya saralanAmAnaM mArgaM gatvA yihUdAnivezane tArSanagarIyaM zaulanAmAnaM janaM gaveSayan pRccha; ");
INSERT INTO sanhk_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","pazya sa prArthayate, tathA ananiyanAmaka eko janastasya samIpam Agatya tasya gAtre hastArpaNaM kRtvA dRSTiM dadAtItthaM svapne dRSTavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","tasmAd ananiyaH pratyavadat he prabho yirUzAlami pavitralokAn prati so'nekahiMsAM kRtavAn; ");
INSERT INTO sanhk_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","atra sthAne ca ye lokAstava nAmni prArthayanti tAnapi baddhuM sa pradhAnayAjakebhyaH zaktiM prAptavAn, imAM kathAm aham anekeSAM mukhebhyaH zrutavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","kintu prabhurakathayat, yAhi bhinnadezIyalokAnAM bhUpatInAm isrAyellokAnAJca nikaTe mama nAma pracArayituM sa jano mama manonItapAtramAste| ");
INSERT INTO sanhk_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","mama nAmanimittaJca tena kiyAn mahAn klezo bhoktavya etat taM darzayiSyAmi| ");
INSERT INTO sanhk_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","tato 'naniyo gatvA gRhaM pravizya tasya gAtre hastArpraNaM kRtvA kathitavAn, he bhrAtaH zaula tvaM yathA dRSTiM prApnoSi pavitreNAtmanA paripUrNo bhavasi ca, tadarthaM tavAgamanakAle yaH prabhuyIzustubhyaM darzanam adadAt sa mAM preSitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ityuktamAtre tasya cakSurbhyAm mInazalkavad vastuni nirgate tatkSaNAt sa prasannacakSu rbhUtvA protthAya majjito'bhavat bhuktvA pItvA sabalobhavacca| ");
INSERT INTO sanhk_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","tataH paraM zaulaH ziSyaiH saha katipayadivasAn tasmin dammeSakanagare sthitvA'vilambaM ");
INSERT INTO sanhk_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","sarvvabhajanabhavanAni gatvA yIzurIzvarasya putra imAM kathAM prAcArayat| ");
INSERT INTO sanhk_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","tasmAt sarvve zrotArazcamatkRtya kathitavanto yo yirUzAlamnagara etannAmnA prArthayitRlokAn vinAzitavAn evam etAdRzalokAn baddhvA pradhAnayAjakanikaTaM nayatItyAzayA etatsthAnamapyAgacchat saeva kimayaM na bhavati? ");
INSERT INTO sanhk_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","kintu zaulaH kramaza utsAhavAn bhUtvA yIzurIzvareNAbhiSikto jana etasmin pramANaM datvA dammeSak-nivAsiyihUdIyalokAn niruttarAn akarot| ");
INSERT INTO sanhk_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","itthaM bahutithe kAle gate yihUdIyalokAstaM hantuM mantrayAmAsuH ");
INSERT INTO sanhk_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","kintu zaulasteSAmetasyA mantraNAyA vArttAM prAptavAn| te taM hantuM tu divAnizaM guptAH santo nagarasya dvAre'tiSThan; ");
INSERT INTO sanhk_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","tasmAt ziSyAstaM nItvA rAtrau piTake nidhAya prAcIreNAvArohayan| ");
INSERT INTO sanhk_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","tataH paraM zaulo yirUzAlamaM gatvA ziSyagaNena sArddhaM sthAtum aihat, kintu sarvve tasmAdabibhayuH sa ziSya iti ca na pratyayan| ");
INSERT INTO sanhk_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","etasmAd barNabbAstaM gRhItvA preritAnAM samIpamAnIya mArgamadhye prabhuH kathaM tasmai darzanaM dattavAn yAH kathAzca kathitavAn sa ca yathAkSobhaH san dammeSaknagare yIzo rnAma prAcArayat etAn sarvvavRttAntAn tAn jJApitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","tataH zaulastaiH saha yirUzAlami kAlaM yApayan nirbhayaM prabho ryIzo rnAma prAcArayat| ");
INSERT INTO sanhk_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","tasmAd anyadezIyalokaiH sArddhaM vivAdasyopasthitatvAt te taM hantum aceSTanta| ");
INSERT INTO sanhk_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","kintu bhrAtRgaNastajjJAtvA taM kaisariyAnagaraM nItvA tArSanagaraM preSitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","itthaM sati yihUdiyAgAlIlzomiroNadezIyAH sarvvA maNDalyo vizrAmaM prAptAstatastAsAM niSThAbhavat prabho rbhiyA pavitrasyAtmanaH sAntvanayA ca kAlaM kSepayitvA bahusaMkhyA abhavan| ");
INSERT INTO sanhk_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","tataH paraM pitaraH sthAne sthAne bhramitvA zeSe lodnagaranivAsipavitralokAnAM samIpe sthitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","tadA tatra pakSAghAtavyAdhinASTau vatsarAn zayyAgatam aineyanAmAnaM manuSyaM sAkSat prApya tamavadat, ");
INSERT INTO sanhk_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","he aineya yIzukhrISTastvAM svastham akArSIt, tvamutthAya svazayyAM nikSipa, ityuktamAtre sa udatiSThat| ");
INSERT INTO sanhk_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","etAdRzaM dRSTvA lodzAroNanivAsino lokAH prabhuM prati parAvarttanta| ");
INSERT INTO sanhk_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","aparaJca bhikSAdAnAdiSu nAnakriyAsu nityaM pravRttA yA yAphonagaranivAsinI TAbithAnAmA ziSyA yAM darkkAM arthAd hariNImayuktvA Ahvayan sA nArI ");
INSERT INTO sanhk_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","tasmin samaye rugnA satI prANAn atyajat, tato lokAstAM prakSAlyoparisthaprakoSThe zAyayitvAsthApayan| ");
INSERT INTO sanhk_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","lodnagaraM yAphonagarasya samIpasthaM tasmAttatra pitara Aste, iti vArttAM zrutvA tUrNaM tasyAgamanArthaM tasmin vinayamuktvA ziSyagaNo dvau manujau preSitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","tasmAt pitara utthAya tAbhyAM sArddham Agacchat, tatra tasmin upasthita uparisthaprakoSThaM samAnIte ca vidhavAH svAbhiH saha sthitikAle darkkayA kRtAni yAnyuttarIyANi paridheyAni ca tAni sarvvANi taM darzayitvA rudatyazcatasRSu dikSvatiSThan| ");
INSERT INTO sanhk_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","kintu pitarastAH sarvvA bahiH kRtvA jAnunI pAtayitvA prArthitavAn; pazcAt zavaM prati dRSTiM kRtvA kathitavAn, he TAbIthe tvamuttiSTha, iti vAkya ukte sA strI cakSuSI pronmIlya pitaram avalokyotthAyopAvizat| ");
INSERT INTO sanhk_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","tataH pitarastasyAH karau dhRtvA uttolya pavitralokAn vidhavAzcAhUya teSAM nikaTe sajIvAM tAM samArpayat| ");
INSERT INTO sanhk_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","eSA kathA samastayAphonagaraM vyAptA tasmAd aneke lokAH prabhau vyazvasan| ");
INSERT INTO sanhk_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","aparaJca pitarastadyAphonagarIyasya kasyacit zimonnAmnazcarmmakArasya gRhe bahudinAni nyavasat| ");
INSERT INTO sanhk_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","kaisariyAnagara itAliyAkhyasainyAntargataH karNIliyanAmA senApatirAsIt ");
INSERT INTO sanhk_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","sa saparivAro bhakta IzvaraparAyaNazcAsIt; lokebhyo bahUni dAnAdIni datvA nirantaram Izvare prArthayAJcakre| ");
INSERT INTO sanhk_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ekadA tRtIyapraharavelAyAM sa dRSTavAn Izvarasyaiko dUtaH saprakAzaM tatsamIpam Agatya kathitavAn, he karNIliya| ");
INSERT INTO sanhk_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","kintu sa taM dRSTvA bhIto'kathayat, he prabho kiM? tadA tamavadat tava prArthanA dAnAdi ca sAkSisvarUpaM bhUtvezvarasya gocaramabhavat| ");
INSERT INTO sanhk_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","idAnIM yAphonagaraM prati lokAn preSya samudratIre zimonnAmnazcarmmakArasya gRhe pravAsakArI pitaranAmnA vikhyAto yaH zimon tam AhvAyaya; ");
INSERT INTO sanhk_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","tasmAt tvayA yadyat karttavyaM tattat sa vadiSyati| ");
INSERT INTO sanhk_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ityupadizya dUte prasthite sati karNIliyaH svagRhasthAnAM dAsAnAM dvau janau nityaM svasaGginAM sainyAnAm ekAM bhaktasenAJcAhUya ");
INSERT INTO sanhk_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","sakalametaM vRttAntaM vijJApya yAphonagaraM tAn prAhiNot| ");
INSERT INTO sanhk_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","parasmin dine te yAtrAM kRtvA yadA nagarasya samIpa upAtiSThan, tadA pitaro dvitIyapraharavelAyAM prArthayituM gRhapRSTham Arohat| ");
INSERT INTO sanhk_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","etasmin samaye kSudhArttaH san kiJcid bhoktum aicchat kintu teSAm annAsAdanasamaye sa mUrcchitaH sannapatat| ");
INSERT INTO sanhk_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","tato meghadvAraM muktaM caturbhiH koNai rlambitaM bRhadvastramiva kiJcana bhAjanam AkAzAt pRthivIm avArohatIti dRSTavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","tanmadhye nAnaprakArA grAmyavanyapazavaH khecarorogAmiprabhRtayo jantavazcAsan| ");
INSERT INTO sanhk_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","anantaraM he pitara utthAya hatvA bhuMkSva tampratIyaM gagaNIyA vANI jAtA| ");
INSERT INTO sanhk_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","tadA pitaraH pratyavadat, he prabho IdRzaM mA bhavatu, aham etat kAlaM yAvat niSiddham azuci vA dravyaM kiJcidapi na bhuktavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","tataH punarapi tAdRzI vihayasIyA vANI jAtA yad IzvaraH zuci kRtavAn tat tvaM niSiddhaM na jAnIhi| ");
INSERT INTO sanhk_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","itthaM triH sati tat pAtraM punarAkRSTaM AkAzam agacchat| ");
INSERT INTO sanhk_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","tataH paraM yad darzanaM prAptavAn tasya ko bhAva ityatra pitaro manasA sandegdhi, etasmin samaye karNIliyasya te preSitA manuSyA dvArasya sannidhAvupasthAya, ");
INSERT INTO sanhk_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","zimono gRhamanvicchantaH sampRchyAhUya kathitavantaH pitaranAmnA vikhyAto yaH zimon sa kimatra pravasati? ");
INSERT INTO sanhk_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","yadA pitarastaddarzanasya bhAvaM manasAndolayati tadAtmA tamavadat, pazya trayo janAstvAM mRgayante| ");
INSERT INTO sanhk_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","tvam utthAyAvaruhya niHsandehaM taiH saha gaccha mayaiva te preSitAH| ");
INSERT INTO sanhk_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","tasmAt pitaro'varuhya karNIliyapreritalokAnAM nikaTamAgatya kathitavAn pazyata yUyaM yaM mRgayadhve sa janohaM, yUyaM kinnimittam AgatAH? ");
INSERT INTO sanhk_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","tataste pratyavadan karNIliyanAmA zuddhasattva IzvaraparAyaNo yihUdIyadezasthAnAM sarvveSAM sannidhau sukhyAtyApanna ekaH senApati rnijagRhaM tvAmAhUya netuM tvattaH kathA zrotuJca pavitradUtena samAdiSTaH| ");
INSERT INTO sanhk_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","tadA pitarastAnabhyantaraM nItvA teSAmAtithyaM kRtavAn, pare'hani taiH sArddhaM yAtrAmakarot, yAphonivAsinAM bhrAtRNAM kiyanto janAzca tena saha gatAH| ");
INSERT INTO sanhk_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","parasmin divase kaisariyAnagaramadhyapravezasamaye karNIliyo jJAtibandhUn AhUyAnIya tAn apekSya sthitaH| ");
INSERT INTO sanhk_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","pitare gRha upasthite karNIliyastaM sAkSAtkRtya caraNayoH patitvA prANamat| ");
INSERT INTO sanhk_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","pitarastamutthApya kathitavAn, uttiSThAhamapi mAnuSaH| ");
INSERT INTO sanhk_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","tadA karNIliyena sAkam Alapan gRhaM prAvizat tanmadhye ca bahulokAnAM samAgamaM dRSTvA tAn avadat, ");
INSERT INTO sanhk_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","anyajAtIyalokaiH mahAlapanaM vA teSAM gRhamadhye pravezanaM yihUdIyAnAM niSiddham astIti yUyam avagacchatha; kintu kamapi mAnuSam avyavahAryyam azuciM vA jJAtuM mama nocitam iti paramezvaro mAM jJApitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","iti hetorAhvAnazravaNamAtrAt kAJcanApattim akRtvA yuSmAkaM samIpam Agatosmi; pRcchAmi yUyaM kinnimittaM mAm AhUyata? ");
INSERT INTO sanhk_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","tadA karNIliyaH kathitavAn, adya catvAri dinAni jAtAni etAvadvelAM yAvad aham anAhAra Asan tatastRtIyaprahare sati gRhe prArthanasamaye tejomayavastrabhRd eko jano mama samakSaM tiSThan etAM kathAm akathayat, ");
INSERT INTO sanhk_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","he karNIliya tvadIyA prArthanA Izvarasya karNagocarIbhUtA tava dAnAdi ca sAkSisvarUpaM bhUtvA tasya dRSTigocaramabhavat| ");
INSERT INTO sanhk_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ato yAphonagaraM prati lokAn prahitya tatra samudratIre zimonnAmnaH kasyaciccarmmakArasya gRhe pravAsakArI pitaranAmnA vikhyAto yaH zimon tamAhUाyaya; tataH sa Agatya tvAm upadekSyati| ");
INSERT INTO sanhk_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","iti kAraNAt tatkSaNAt tava nikaTe lokAn preSitavAn, tvamAgatavAn iti bhadraM kRtavAn| Izvaro yAnyAkhyAnAni kathayitum Adizat tAni zrotuM vayaM sarvve sAmpratam Izvarasya sAkSAd upasthitAH smaH| ");
INSERT INTO sanhk_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","tadA pitara imAM kathAM kathayitum ArabdhavAn, Izvaro manuSyANAm apakSapAtI san ");
INSERT INTO sanhk_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","yasya kasyacid dezasya yo lokAstasmAdbhItvA satkarmma karoti sa tasya grAhyo bhavati, etasya nizcayam upalabdhavAnaham| ");
INSERT INTO sanhk_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","sarvveSAM prabhu ryo yIzukhrISTastena Izvara isrAyelvaMzAnAM nikaTe susaMvAdaM preSya sammelanasya yaM saMvAdaM prAcArayat taM saMvAdaM yUyaM zrutavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","yato yohanA majjane pracArite sati sa gAlIladezamArabhya samastayihUdIyadezaM vyApnot; ");
INSERT INTO sanhk_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","phalata IzvareNa pavitreNAtmanA zaktyA cAbhiSikto nAsaratIyayIzuH sthAne sthAne bhraman sukriyAM kurvvan zaitAnA kliSTAn sarvvalokAn svasthAn akarot, yata Izvarastasya sahAya AsIt; ");
INSERT INTO sanhk_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","vayaJca yihUdIyadeze yirUzAlamnagare ca tena kRtAnAM sarvveSAM karmmaNAM sAkSiNo bhavAmaH| lokAstaM kruze viddhvA hatavantaH, ");
INSERT INTO sanhk_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","kintu tRtIyadivase IzvarastamutthApya saprakAzam adarzayat| ");
INSERT INTO sanhk_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","sarvvalokAnAM nikaTa iti na hi, kintu tasmin zmazAnAdutthite sati tena sArddhaM bhojanaM pAnaJca kRtavanta etAdRzA Izvarasya manonItAH sAkSiNo ye vayam asmAkaM nikaTe tamadarzayat| ");
INSERT INTO sanhk_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","jIvitamRtobhayalokAnAM vicAraM karttum Izvaro yaM niyuktavAn sa eva sa janaH, imAM kathAM pracArayituM tasmin pramANaM dAtuJca so'smAn AjJApayat| ");
INSERT INTO sanhk_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","yastasmin vizvasiti sa tasya nAmnA pApAnmukto bhaviSyati tasmin sarvve bhaviSyadvAdinopi etAdRzaM sAkSyaM dadati| ");
INSERT INTO sanhk_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","pitarasyaitatkathAkathanakAle sarvveSAM zrotRNAmupari pavitra AtmAvArohat| ");
INSERT INTO sanhk_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","tataH pitareNa sArddham AgatAstvakchedino vizvAsino lokA anyadezIyebhyaH pavitra Atmani datte sati ");
INSERT INTO sanhk_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","te nAnAjAtIyabhASAbhiH kathAM kathayanta IzvaraM prazaMsanti, iti dRSTvA zrutvA ca vismayam Apadyanta| ");
INSERT INTO sanhk_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","tadA pitaraH kathitavAn, vayamiva ye pavitram AtmAnaM prAptAsteSAM jalamajjanaM kiM kopi niSeddhuM zaknoti? ");
INSERT INTO sanhk_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","tataH prabho rnAmnA majjitA bhavateti tAnAjJApayat| anantaraM te svaiH sArddhaM katipayadinAni sthAtuM prArthayanta| ");
INSERT INTO sanhk_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","itthaM bhinnadezIyalokA apIzvarasya vAkyam agRhlan imAM vArttAM yihUdIyadezasthapreritA bhrAtRgaNazca zrutavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","tataH pitare yirUzAlamnagaraM gatavati tvakchedino lokAstena saha vivadamAnA avadan, ");
INSERT INTO sanhk_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","tvam atvakchedilokAnAM gRhaM gatvA taiH sArddhaM bhuktavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","tataH pitara AditaH kramazastatkAryyasya sarvvavRttAntamAkhyAtum ArabdhavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","yAphonagara ekadAhaM prArthayamAno mUrcchitaH san darzanena caturSu koNeSu lambanamAnaM vRhadvastramiva pAtramekam AkAzadavaruhya mannikaTam Agacchad apazyam| ");
INSERT INTO sanhk_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","pazcAt tad ananyadRSTyA dRSTvA vivicya tasya madhye nAnAprakArAn grAmyavanyapazUn urogAmikhecarAMzca dRSTavAn; ");
INSERT INTO sanhk_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","he pitara tvamutthAya gatvA bhuMkSva mAM sambodhya kathayantaM zabdamekaM zrutavAMzca| ");
INSERT INTO sanhk_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","tatohaM pratyavadaM, he prabho netthaM bhavatu, yataH kiJcana niSiddham azuci dravyaM vA mama mukhamadhyaM kadApi na prAvizat| ");
INSERT INTO sanhk_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","aparam Izvaro yat zuci kRtavAn tanniSiddhaM na jAnIhi dvi rmAmpratIdRzI vihAyasIyA vANI jAtA| ");
INSERT INTO sanhk_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","triritthaM sati tat sarvvaM punarAkAzam AkRSTaM| ");
INSERT INTO sanhk_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","pazcAt kaisariyAnagarAt trayo janA mannikaTaM preSitA yatra nivezane sthitohaM tasmin samaye tatropAtiSThan| ");
INSERT INTO sanhk_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","tadA niHsandehaM taiH sArddhaM yAtum AtmA mAmAdiSTavAn; tataH paraM mayA sahaiteSu SaDbhrAtRSu gateSu vayaM tasya manujasya gRhaM prAvizAma| ");
INSERT INTO sanhk_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","sosmAkaM nikaTe kathAmetAm akathayat ekadA dUta ekaH pratyakSIbhUya mama gRhamadhye tiSTan mAmityAjJApitavAn, yAphonagaraM prati lokAn prahitya pitaranAmnA vikhyAtaM zimonam AhUyaya; ");
INSERT INTO sanhk_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","tatastava tvadIyaparivArANAJca yena paritrANaM bhaviSyati tat sa upadekSyati| ");
INSERT INTO sanhk_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","ahaM tAM kathAmutthApya kathitavAn tena prathamam asmAkam upari yathA pavitra AtmAvarUDhavAn tathA teSAmapyupari samavarUDhavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","tena yohan jale majjitavAn iti satyaM kintu yUyaM pavitra Atmani majjitA bhaviSyatha, iti yadvAkyaM prabhuruditavAn tat tadA mayA smRtam| ");
INSERT INTO sanhk_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","ataH prabhA yIzukhrISTe pratyayakAriNo ye vayam asmabhyam Izvaro yad dattavAn tat tebhyo lokebhyopi dattavAn tataH kohaM? kimaham IzvaraM vArayituM zaknomi? ");
INSERT INTO sanhk_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","kathAmetAM zruvA te kSAntA Izvarasya guNAn anukIrttya kathitavantaH, tarhi paramAyuHprAptinimittam IzvaronyadezIyalokebhyopi manaHparivarttanarUpaM dAnam adAt| ");
INSERT INTO sanhk_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","stiphAnaM prati upadrave ghaTite ye vikIrNA abhavan tai phainIkIkuprAntiyakhiyAsu bhramitvA kevalayihUdIyalokAn vinA kasyApyanyasya samIpa Izvarasya kathAM na prAcArayan| ");
INSERT INTO sanhk_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","aparaM teSAM kuprIyAH kurInIyAzca kiyanto janA AntiyakhiyAnagaraM gatvA yUnAnIyalokAnAM samIpepi prabhoryIzoH kathAM prAcArayan| ");
INSERT INTO sanhk_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","prabhoH karasteSAM sahAya AsIt tasmAd aneke lokA vizvasya prabhuM prati parAvarttanta| ");
INSERT INTO sanhk_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","iti vArttAyAM yirUzAlamasthamaNDalIyalokAnAM karNagocarIbhUtAyAm AntiyakhiyAnagaraM gantu te barNabbAM prairayan| ");
INSERT INTO sanhk_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","tato barNabbAstatra upasthitaH san IzvarasyAnugrahasya phalaM dRSTvA sAnando jAtaH, ");
INSERT INTO sanhk_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","sa svayaM sAdhu rvizvAsena pavitreNAtmanA ca paripUrNaH san ganoniSTayA prabhAvAsthAM karttuM sarvvAn upadiSTavAn tena prabhoH ziSyA aneke babhUvuH| ");
INSERT INTO sanhk_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","zeSe zaulaM mRgayituM barNabbAstArSanagaraM prasthitavAn| tatra tasyoddezaM prApya tam AntiyakhiyAnagaram Anayat; ");
INSERT INTO sanhk_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","tatastau maNDalIsthalokaiH sabhAM kRtvA saMvatsaramekaM yAvad bahulokAn upAdizatAM; tasmin AntiyakhiyAnagare ziSyAH prathamaM khrISTIyanAmnA vikhyAtA abhavan| ");
INSERT INTO sanhk_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","tataH paraM bhaviSyadvAdigaNe yirUzAlama AntiyakhiyAnagaram Agate sati ");
INSERT INTO sanhk_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","AgAbanAmA teSAmeka utthAya AtmanaH zikSayA sarvvadeze durbhikSaM bhaviSyatIti jJApitavAn; tataH klaudiyakaisarasyAdhikAre sati tat pratyakSam abhavat| ");
INSERT INTO sanhk_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","tasmAt ziSyA ekaikazaH svasvazaktyanusArato yihUdIyadezanivAsinAM bhratRNAM dinayApanArthaM dhanaM preSayituM nizcitya ");
INSERT INTO sanhk_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","barNabbAzaulayo rdvArA prAcInalokAnAM samIpaM tat preSitavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","tasmin samaye herod‌rAjo maNDalyAH kiyajjanebhyo duHkhaM dAtuM prArabhat| ");
INSERT INTO sanhk_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","vizeSato yohanaH sodaraM yAkUbaM karavAlAghAten hatavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","tasmAd yihUdIyAH santuSTA abhavan iti vijJAya sa pitaramapi dharttuM gatavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","tadA kiNvazUnyapUpotsavasamaya upAtiSTat; ata utsave gate sati lokAnAM samakSaM taM bahirAneyyAmIti manasi sthirIkRtya sa taM dhArayitvA rakSNArtham yeSAm ekaikasaMghe catvAro janAH santi teSAM caturNAM rakSakasaMghAnAM samIpe taM samarpya kArAyAM sthApitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","kintuM pitarasya kArAsthitikAraNAt maNDalyA lokA avizrAmam Izvarasya samIpe prArthayanta| ");
INSERT INTO sanhk_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","anantaraM herodi taM bahirAnAyituM udyate sati tasyAM rAtrau pitaro rakSakadvayamadhyasthAne zRGkhaladvayena baddhvaH san nidrita AsIt, dauvArikAzca kArAyAH sammukhe tiSThanato dvAram arakSiSuH| ");
INSERT INTO sanhk_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","etasmin samaye paramezvarasya dUte samupasthite kArA dIptimatI jAtA; tataH sa dUtaH pitarasya kukSAvAvAtaM kRtvA taM jAgarayitvA bhASitavAn tUrNamuttiSTha; tatastasya hastasthazRGkhaladvayaM galat patitaM| ");
INSERT INTO sanhk_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","sa dUtastamavadat, baddhakaTiH san pAdayoH pAduke arpaya; tena tathA kRte sati dUtastam uktavAn gAtrIyavastraM gAtre nidhAya mama pazcAd ehi| ");
INSERT INTO sanhk_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","tataH pitarastasya pazcAd vrajana bahiragacchat, kintu dUtena karmmaitat kRtamiti satyamajJAtvA svapnadarzanaM jJAtavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","itthaM tau prathamAM dvitIyAJca kArAM laGghitvA yena lauhanirmmitadvAreNa nagaraM gamyate tatsamIpaM prApnutAM; tatastasya kavATaM svayaM muktamabhavat tatastau tatsthAnAd bahi rbhUtvA mArgaikasya sImAM yAvad gatau; tato'kasmAt sa dUtaH pitaraM tyaktavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","tadA sa cetanAM prApya kathitavAn nijadUtaM prahitya paramezvaro herodo hastAd yihUdIyalokAnAM sarvvAzAyAzca mAM samuddhRtavAn ityahaM nizcayaM jJAtavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","sa vivicya mArkanAmrA vikhyAtasya yohano mAtu rmariyamo yasmin gRhe bahavaH sambhUya prArthayanta tannivezanaM gataH| ");
INSERT INTO sanhk_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","pitareNa bahirdvAra Ahate sati rodAnAmA bAlikA draSTuM gatA| ");
INSERT INTO sanhk_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","tataH pitarasya svaraM zruvA sA harSayuktA satI dvAraM na mocayitvA pitaro dvAre tiSThatIti vArttAM vaktum abhyantaraM dhAvitvA gatavatI| ");
INSERT INTO sanhk_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","te prAvocan tvamunmattA jAtAsi kintu sA muhurmuhuruktavatI satyamevaitat| ");
INSERT INTO sanhk_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","tadA te kathitavantastarhi tasya dUto bhavet| ");
INSERT INTO sanhk_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","pitaro dvAramAhatavAn etasminnantare dvAraM mocayitvA pitaraM dRSTvA vismayaM prAptAH| ");
INSERT INTO sanhk_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","tataH pitaro niHzabdaM sthAtuM tAn prati hastena saGketaM kRtvA paramezvaro yena prakAreNa taM kArAyA uddhRtyAnItavAn tasya vRttAntaM tAnajJApayat, yUyaM gatvA yAkubaM bhrAtRgaNaJca vArttAmetAM vadatetyuktA sthAnAntaraM prasthitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","prabhAte sati pitaraH kva gata ityatra rakSakANAM madhye mahAn kalaho jAtaH| ");
INSERT INTO sanhk_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","herod bahu mRgayitvA tasyoddeze na prApte sati rakSakAn saMpRcchya teSAM prANAn hantum AdiSTavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","pazcAt sa yihUdIyapradezAt kaisariyAnagaraM gatvA tatrAvAtiSThat| ");
INSERT INTO sanhk_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","sorasIdonadezayo rlokebhyo herodi yuyutsau sati te sarvva ekamantraNAH santastasya samIpa upasthAya lvAstanAmAnaM tasya vastragRhAdhIzaM sahAyaM kRtvA herodA sArddhaM sandhiM prArthayanta yatastasya rAjJo dezena teSAM dezIyAnAM bharaNam abhavatM ");
INSERT INTO sanhk_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","ataH kutracin nirupitadine herod rAjakIyaM paricchadaM paridhAya siMhAsane samupavizya tAn prati kathAm uktavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","tato lokA uccaiHkAraM pratyavadan, eSa manujaravo na hi, IzvarIyaravaH| ");
INSERT INTO sanhk_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","tadA herod Izvarasya sammAnaM nAkarot; tasmAddhetoH paramezvarasya dUto haThAt taM prAharat tenaiva sa kITaiH kSINaH san prANAn ajahAt| kintvIzvarasya kathA dezaM vyApya prabalAbhavat| tataH paraM barNabbAzaulau yasya karmmaNo bhAraM prApnutAM tAbhyAM tasmin sampAdite sati mArkanAmnA vikhyAto yo yohan taM saGginaM kRtvA yirUzAlamnagarAt pratyAgatau| ");
INSERT INTO sanhk_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","aparaJca barNabbAH, zimon yaM nigraM vadanti, kurInIyalUkiyo herodA rAjJA saha kRtavidyAाbhyAso minahem, zaulazcaite ye kiyanto janA bhaviSyadvAdina upadeSTArazcAntiyakhiyAnagarasthamaNDalyAm Asan, ");
INSERT INTO sanhk_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","te yadopavAsaM kRtvezvaram asevanta tasmin samaye pavitra AtmA kathitavAn ahaM yasmin karmmaNi barNabbAzailau niyuktavAn tatkarmma karttuM tau pRthak kuruta| ");
INSERT INTO sanhk_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","tatastairupavAsaprArthanayoH kRtayoH satoste tayo rgAtrayo rhastArpaNaM kRtvA tau vyasRjan| ");
INSERT INTO sanhk_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","tataH paraM tau pavitreNAtmanA preritau santau silUkiyAnagaram upasthAya samudrapathena kupropadvIpam agacchatAM| ");
INSERT INTO sanhk_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","tataH sAlAmInagaram upasthAya tatra yihUdIyAnAM bhajanabhavanAni gatvezvarasya kathAM prAcArayatAM; yohanapi tatsahacaro'bhavat| ");
INSERT INTO sanhk_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","itthaM te tasyopadvIpasya sarvvatra bhramantaH pAphanagaram upasthitAH; tatra suvivecakena sarjiyapaulanAmnA taddezAdhipatinA saha bhaviSyadvAdino vezadhArI baryIzunAmA yo mAyAvI yihUdI AsIt taM sAkSAt prAptavataH| ");
INSERT INTO sanhk_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","taddezAdhipa Izvarasya kathAM zrotuM vAJchan paulabarNabbau nyamantrayat| ");
INSERT INTO sanhk_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","kintvilumA yaM mAyAvinaM vadanti sa dezAdhipatiM dharmmamArgAd bahirbhUtaM karttum ayatata| ");
INSERT INTO sanhk_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","tasmAt zolo'rthAt paulaH pavitreNAtmanA paripUrNaH san taM mAyAvinaM pratyananyadRSTiM kRtvAkathayat, ");
INSERT INTO sanhk_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","he narakin dharmmadveSin kauTilyaduSkarmmaparipUrNa, tvaM kiM prabhoH satyapathasya viparyyayakaraNAt kadApi na nivarttiSyase? ");
INSERT INTO sanhk_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","adhunA paramezvarastava samucitaM kariSyati tena katipayadinAni tvam andhaH san sUryyamapi na drakSyasi| tatkSaNAd rAtrivad andhakArastasya dRSTim AcchAditavAn; tasmAt tasya hastaM dharttuM sa lokamanvicchan itastato bhramaNaM kRtavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","enAM ghaTanAM dRSTvA sa dezAdhipatiH prabhUpadezAd vismitya vizvAsaM kRtavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","tadanantaraM paulastatsaGginau ca pAphanagarAt protaM cAlayitvA pamphuliyAdezasya pargInagaram agacchan kintu yohan tayoH samIpAd etya yirUzAlamaM pratyAgacchat| ");
INSERT INTO sanhk_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","pazcAt tau pargIto yAtrAM kRtvA pisidiyAdezasya AntiyakhiyAnagaram upasthAya vizrAmavAre bhajanabhavanaM pravizya samupAvizatAM| ");
INSERT INTO sanhk_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","vyavasthAbhaviSyadvAkyayoH paThitayoH sato rhe bhrAtarau lokAn prati yuvayoH kAcid upadezakathA yadyasti tarhi tAM vadataM tau prati tasya bhajanabhavanasyAdhipatayaH kathAm etAM kathayitvA praiSayan| ");
INSERT INTO sanhk_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ataH paula uttiSThan hastena saGketaM kurvvan kathitavAn he isrAyelIyamanuSyA IzvaraparAyaNAH sarvve lokA yUyam avadhaddhaM| ");
INSERT INTO sanhk_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","eteSAmisrAyellokAnAm Izvaro'smAkaM pUrvvaparuSAn manonItAn katvA gRhItavAn tato misari deze pravasanakAle teSAmunnatiM kRtvA tasmAt svIyabAhubalena tAn bahiH kRtvA samAnayat| ");
INSERT INTO sanhk_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","catvAriMzadvatsarAn yAvacca mahAprAntare teSAM bharaNaM kRtvA ");
INSERT INTO sanhk_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","kinAndezAntarvvarttINi saptarAjyAni nAzayitvA guTikApAtena teSu sarvvadezeSu tebhyo'dhikAraM dattavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","paJcAzadadhikacatuHzateSu vatsareSu gateSu ca zimUyelbhaviSyadvAdiparyyantaM teSAmupari vicArayitRn niyuktavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","taizca rAjJi prArthite, Izvaro binyAmIno vaMzajAtasya kIzaH putraM zaulaM catvAriMzadvarSaparyyantaM teSAmupari rAjAnaM kRtavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","pazcAt taM padacyutaM kRtvA yo madiSTakriyAH sarvvAH kariSyati tAdRzaM mama manobhimatam ekaM janaM yizayaH putraM dAyUdaM prAptavAn idaM pramANaM yasmin dAyUdi sa dattavAn taM dAyUdaM teSAmupari rAjatvaM karttum utpAditavAna| ");
INSERT INTO sanhk_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","tasya svapratizrutasya vAkyasyAnusAreNa isrAyellokAnAM nimittaM teSAM manuSyANAM vaMzAd Izvara ekaM yIzuM (trAtAram) udapAdayat| ");
INSERT INTO sanhk_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","tasya prakAzanAt pUrvvaM yohan isrAyellokAnAM sannidhau manaHparAvarttanarUpaM majjanaM prAcArayat| ");
INSERT INTO sanhk_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","yasya ca karmmaNoे bhAraM praptavAn yohan tan niSpAdayan etAM kathAM kathitavAn, yUyaM mAM kaM janaM jAnItha? aham abhiSiktatrAtA nahi, kintu pazyata yasya pAdayoH pAdukayo rbandhane mocayitumapi yogyo na bhavAmi tAdRza eko jano mama pazcAd upatiSThati| ");
INSERT INTO sanhk_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","he ibrAhImo vaMzajAtA bhrAtaro he IzvarabhItAH sarvvalokA yuSmAn prati paritrANasya kathaiSA preritA| ");
INSERT INTO sanhk_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","yirUzAlamnivAsinasteSAm adhipatayazca tasya yIzoH paricayaM na prApya prativizrAmavAraM paThyamAnAnAM bhaviSyadvAdikathAnAm abhiprAyam abuddhvA ca tasya vadhena tAH kathAH saphalA akurvvan| ");
INSERT INTO sanhk_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","prANahananasya kamapi hetum aprApyApi pIlAtasya nikaTe tasya vadhaM prArthayanta| ");
INSERT INTO sanhk_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","tasmin yAH kathA likhitAH santi tadanusAreNa karmma sampAdya taM kruzAd avatAryya zmazAne zAyitavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","kintvIzvaraH zmazAnAt tamudasthApayat, ");
INSERT INTO sanhk_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","punazca gAlIlapradezAd yirUzAlamanagaraM tena sArddhaM ye lokA Agacchan sa bahudinAni tebhyo darzanaM dattavAn, atasta idAnIM lokAn prati tasya sAkSiNaH santi| ");
INSERT INTO sanhk_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","asmAkaM pUrvvapuruSANAM samakSam Izvaro yasmin pratijJAtavAn yathA, tvaM me putrosi cAdya tvAM samutthApitavAnaham| ");
INSERT INTO sanhk_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","idaM yadvacanaM dvitIyagIte likhitamAste tad yIzorutthAnena teSAM santAnA ye vayam asmAkaM sannidhau tena pratyakSI kRtaM, yuSmAn imaM susaMvAdaM jJApayAmi| ");
INSERT INTO sanhk_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","paramezvareNa zmazAnAd utthApitaM tadIyaM zarIraM kadApi na kSeSyate, etasmin sa svayaM kathitavAn yathA dAyUdaM prati pratijJAto yo varastamahaM tubhyaM dAsyAmi| ");
INSERT INTO sanhk_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","etadanyasmin gIte'pi kathitavAn| svakIyaM puNyavantaM tvaM kSayituM na ca dAsyasi| ");
INSERT INTO sanhk_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","dAyUdA IzvarAbhimatasevAyai nijAyuSi vyayite sati sa mahAnidrAM prApya nijaiH pUrvvapuruSaiH saha militaH san akSIyata; ");
INSERT INTO sanhk_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","kintu yamIzvaraH zmazAnAd udasthApayat sa nAkSIyata| ");
INSERT INTO sanhk_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","ato he bhrAtaraH, anena janena pApamocanaM bhavatIti yuSmAn prati pracAritam Aste| ");
INSERT INTO sanhk_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","phalato mUsAvyavasthayA yUyaM yebhyo doSebhyo muktA bhavituM na zakSyatha tebhyaH sarvvadoSebhya etasmin jane vizvAsinaH sarvve muktA bhaviSyantIti yuSmAbhi rjJAyatAM| ");
INSERT INTO sanhk_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","aparaJca| avajJAkAriNo lokAzcakSurunmIlya pazyata| tathaivAsambhavaM jJAtvA syAta yUyaM vilajjitAH| yato yuSmAsu tiSThatsu kariSye karmma tAdRzaM| yenaiva tasya vRttAnte yuSmabhyaM kathite'pi hi| yUyaM na tantu vRttAntaM pratyeSyatha kadAcana|| ");
INSERT INTO sanhk_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","yeyaM kathA bhaviSyadvAdinAM grantheSu likhitAste sAvadhAnA bhavata sa kathA yathA yuSmAn prati na ghaTate| ");
INSERT INTO sanhk_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","yihUdIyabhajanabhavanAn nirgatayostayo rbhinnadezIyai rvakSyamANA prArthanA kRtA, AgAmini vizrAmavAre'pi katheyam asmAn prati pracAritA bhavatviti| ");
INSERT INTO sanhk_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","sabhAyA bhaGge sati bahavo yihUdIyalokA yihUdIyamatagrAhiNo bhaktalokAzca barNabbApaulayoH pazcAd Agacchan, tena tau taiH saha nAnAkathAH kathayitvezvarAnugrahAzraye sthAtuM tAn prAvarttayatAM| ");
INSERT INTO sanhk_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","paravizrAmavAre nagarasya prAyeNa sarvve lAkA IzvarIyAM kathAM zrotuM militAH, ");
INSERT INTO sanhk_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","kintu yihUdIyalokA jananivahaM vilokya IrSyayA paripUrNAH santo viparItakathAkathanenezvaranindayA ca paulenoktAM kathAM khaNDayituM ceSTitavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","tataH pauैlabarNabbAvakSobhau kathitavantau prathamaM yuSmAkaM sannidhAvIzvarIyakathAyAH pracAraNam ucitamAsIt kintuM tadagrAhyatvakaraNena yUyaM svAn anantAyuSo'yogyAn darzayatha, etatkAraNAd vayam anyadezIyalokAnAM samIpaM gacchAmaH| ");
INSERT INTO sanhk_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","prabhurasmAn ittham AdiSTavAn yathA, yAvacca jagataH sImAM lokAnAM trANakAraNAt| mayAnyadezamadhye tvaM sthApito bhUH pradIpavat|| ");
INSERT INTO sanhk_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","tadA kathAmIdRzIM zrutvA bhinnadezIyA AhlAditAH santaH prabhoH kathAM dhanyAM dhanyAm avadan, yAvanto lokAzca paramAyuH prAptinimittaM nirUpitA Asan teे vyazvasan| ");
INSERT INTO sanhk_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","itthaM prabhoH kathA sarvvedezaM vyApnot| ");
INSERT INTO sanhk_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","kintu yihUdIyA nagarasya pradhAnapuruSAn sammAnyAH kathipayA bhaktA yoSitazca kupravRttiM grAhayitvA paulabarNabbau tADayitvA tasmAt pradezAd dUrIkRtavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","ataH kAraNAt tau nijapadadhUlIsteSAM prAtikUlyena pAtayitveेkaniyaM nagaraM gatau| ");
INSERT INTO sanhk_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","tataH ziSyagaNa Anandena pavitreNAtmanA ca paripUrNobhavat| ");
INSERT INTO sanhk_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","tau dvau janau yugapad ikaniyanagarasthayihUdIyAnAM bhajanabhavanaM gatvA yathA bahavo yihUdIyA anyadeेzIyalokAzca vyazvasan tAdRzIM kathAM kathitavantau| ");
INSERT INTO sanhk_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","kintu vizvAsahInA yihUdIyA anyadezIyalokAn kupravRttiM grAhayitvA bhrAtRgaNaM prati teSAM vairaM janitavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ataH svAnugrahakathAyAH pramANaM datvA tayo rhastai rbahulakSaNam adbhutakarmma ca prAkAzayad yaH prabhustasya kathA akSobhena pracAryya tau tatra bahudinAni samavAtiSThetAM| ");
INSERT INTO sanhk_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","kintu kiyanto lokA yihUdIyAnAM sapakSAH kiyanto lokAH preritAnAM sapakSA jAtAH, ato nAgarikajananivahamadhye bhinnavAkyatvam abhavat| ");
INSERT INTO sanhk_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","anyadezIyA yihUdIyAsteSAm adhipatayazca daurAtmyaM kutvA tau prastarairAhantum udyatAH| ");
INSERT INTO sanhk_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","tau tadvArttAM prApya palAyitvA lukAyaniyAdezasyAntarvvarttilustrAdarbbo ");
INSERT INTO sanhk_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","tatsamIpasthadezaJca gatvA tatra susaMvAdaM pracArayatAM| ");
INSERT INTO sanhk_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","tatrobhayapAdayozcalanazaktihIno janmArabhya khaJjaH kadApi gamanaM nAkarot etAdRza eko mAnuSo lustrAnagara upavizya paulasya kathAM zrutavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","etasmin samaye paulastamprati dRSTiM kRtvA tasya svAsthye vizvAsaM viditvA proccaiH kathitavAn ");
INSERT INTO sanhk_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","padbhyAmuttiSThan Rju rbhava|tataH sa ullamphaM kRtvA gamanAgamane kutavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","tadA lokAH paulasya tat kAryyaM vilokya lukAyanIyabhASayA proccaiH kathAmetAM kathitavantaH, devA manuSyarUpaM dhRtvAsmAkaM samIpam avArohan| ");
INSERT INTO sanhk_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","te barNabbAM yUpitaram avadan paulazca mukhyo vaktA tasmAt taM markuriyam avadan| ");
INSERT INTO sanhk_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","tasya nagarasya sammukhe sthApitasya yUpitaravigrahasya yAjako vRSAn puSpamAlAzca dvArasamIpam AnIya lokaiH sarddhaM tAvuddizya samutsRjya dAtum udyataH| ");
INSERT INTO sanhk_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","tadvArttAM zrutvA barNabbApaulau svIyavastrANi chitvA lokAnAM madhyaM vegena pravizya proccaiH kathitavantau, ");
INSERT INTO sanhk_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","he mahecchAH kuta etAdRzaM karmma kurutha? AvAmapi yuSmAdRzau sukhaduHkhabhoginau manuSyau, yuyam etAH sarvvA vRthAkalpanAH parityajya yathA gagaNavasundharAjalanidhInAM tanmadhyasthAnAM sarvveSAJca sraSTAramamaram IzvaraM prati parAvarttadhve tadartham AvAM yuSmAkaM sannidhau susaMvAdaM pracArayAvaH| ");
INSERT INTO sanhk_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","sa IzvaraH pUrvvakAle sarvvadezIyalokAn svasvamArge calitumanumatiM dattavAn, ");
INSERT INTO sanhk_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","tathApi AkAzAt toyavarSaNena nAnAprakArazasyotpatyA ca yuSmAkaM hitaiSI san bhakSyairAnanadena ca yuSmAkam antaHkaraNAni tarpayan tAni dAnAni nijasAkSisvarUpANi sthapitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","kintu tAdRzAyAM kathAyAM kathitAyAmapi tayoH samIpa utsarjanAt lokanivahaM prAyeNa nivarttayituM nAzaknutAm| ");
INSERT INTO sanhk_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","AntiyakhiyA-ikaniyanagarAbhyAM katipayayihUdIyalokA Agatya lokAn prAvarttayanta tasmAt tai paulaM prastarairAghnan tena sa mRta iti vijJAya nagarasya bahistam AkRSya nItavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","kintu ziSyagaNe tasya caturdizi tiSThati sati sa svayam utthAya punarapi nagaramadhyaM prAvizat tatpare'hani barNabbAsahito darbbInagaraM gatavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","tatra susaMvAdaM pracAryya bahulokAn ziSyAn kRtvA tau lustrAm ikaniyam AntiyakhiyAJca parAvRtya gatau| ");
INSERT INTO sanhk_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","bahuduHkhAni bhuktvApIzvararAjyaM praveSTavyam iti kAraNAd dharmmamArge sthAtuM vinayaM kRtvA ziSyagaNasya manaHsthairyyam akurutAM| ");
INSERT INTO sanhk_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","maNDalInAM prAcInavargAn niyujya prArthanopavAsau kRtvA yatprabhau te vyazvasan tasya haste tAn samarpya ");
INSERT INTO sanhk_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","pisidiyAmadhyena pAmphuliyAdezaM gatavantau| ");
INSERT INTO sanhk_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","pazcAt pargAnagaraM gatvA susaMvAdaM pracAryya attAliyAnagaraM prasthitavantau| ");
INSERT INTO sanhk_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","tasmAt samudrapathena gatvA tAbhyAM yat karmma sampannaM tatkarmma sAdhayituM yannagare dayAlorIzvarasya haste samarpitau jAtau tad AntiyakhiyAnagaraM gatavantA| ");
INSERT INTO sanhk_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","tatropasthAya tannagarasthamaNDalIM saMgRhya svAbhyAma Izvaro yadyat karmmakarot tathA yena prakAreNa bhinnadezIyalokAn prati vizvAsarUpadvAram amocayad etAn sarvvavRttAntAn tAn jJApitavantau| ");
INSERT INTO sanhk_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","tatastau ziryyaiH sArddhaM tatra bahudinAni nyavasatAm| ");
INSERT INTO sanhk_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","yihUdAdezAt kiyanto janA Agatya bhrAtRgaNamitthaM zikSitavanto mUsAvyavasthayA yadi yuSmAkaM tvakchedo na bhavati tarhi yUyaM paritrANaM prAptuM na zakSyatha| ");
INSERT INTO sanhk_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","paulabarNabbau taiH saha bahUn vicArAn vivAdAMzca kRtavantau, tato maNDalIyanokA etasyAH kathAyAstattvaM jJAtuM yirUzAlamnagarasthAn preritAn prAcInAMzca prati paulabarNabbAprabhRtIn katipayajanAn preSayituM nizcayaM kRtavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","te maNDalyA preritAH santaH phaiNIkIzomirondezAbhyAM gatvA bhinnadezIyAnAM manaHparivarttanasya vArttayA bhrAtRNAM paramAhlAdam ajanayan| ");
INSERT INTO sanhk_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","yirUzAlamyupasthAya preritagaNena lokaprAcInagaNena samAjena ca samupagRhItAH santaH svairIzvaro yAni karmmANi kRtavAn teSAM sarvvavRttAntAn teSAM samakSam akathayan| ");
INSERT INTO sanhk_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","kintu vizvAsinaH kiyantaH phirUzimatagrAhiNo lokA utthAya kathAmetAM kathitavanto bhinnadezIyAnAM tvakchedaM karttuM mUsAvyavasthAM pAlayituJca samAdeSTavyam| ");
INSERT INTO sanhk_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","tataH preritA lokaprAcInAzca tasya vivecanAM karttuM sabhAyAM sthitavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","bahuvicAreSu jAtaSu pitara utthAya kathitavAn, he bhrAtaro yathA bhinnadezIyalokA mama mukhAt susaMvAdaM zrutvA vizvasanti tadarthaM bahudinAt pUrvvam IzvarosmAkaM madhye mAM vRtvA niyuktavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","antaryyAmIzvaro yathAsmabhyaM tathA bhinnadezIyebhyaH pavitramAtmAnaM pradAya vizvAsena teSAm antaHkaraNAni pavitrANi kRtvA ");
INSERT INTO sanhk_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","teSAm asmAkaJca madhye kimapi vizeSaM na sthApayitvA tAnadhi svayaM pramANaM dattavAn iti yUyaM jAnItha| ");
INSERT INTO sanhk_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","ataevAsmAkaM pUrvvapuruSA vayaJca svayaM yadyugasya bhAraM soDhuM na zaktAH samprati taM ziSyagaNasya skandheSu nyasituM kuta Izvarasya parIkSAM kariSyatha? ");
INSERT INTO sanhk_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","prabho ryIzukhrISTasyAnugraheNa te yathA vayamapi tathA paritrANaM prAptum AzAM kurmmaH| ");
INSERT INTO sanhk_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","anantaraM barNabbApaulAbhyAm Izvaro bhinnadezIyAnAM madhye yadyad Azcaryyam adbhutaJca karmma kRtavAn tadvRttAntaM tau svamukhAbhyAm avarNayatAM sabhAsthAH sarvve nIravAH santaH zrutavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","tayoH kathAyAM samAptAyAM satyAM yAkUb kathayitum ArabdhavAn ");
INSERT INTO sanhk_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","he bhrAtaro mama kathAyAm mano nidhatta| IzvaraH svanAmArthaM bhinnadezIyalokAnAm madhyAd ekaM lokasaMghaM grahItuM matiM kRtvA yena prakAreNa prathamaM tAn prati kRpAvalekanaM kRtavAn taM zimon varNitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","bhaviSyadvAdibhiruktAni yAni vAkyAni taiH sArddham etasyaikyaM bhavati yathA likhitamAste| ");
INSERT INTO sanhk_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","sarvveSAM karmmaNAM yastu sAdhakaH paramezvaraH| sa evedaM vadedvAkyaM zeSAH sakalamAnavAH| bhinnadezIyalokAzca yAvanto mama nAmataH| bhavanti hi suvikhyAtAste yathA paramezituH| ");
INSERT INTO sanhk_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","tatvaM samyak samIhante tannimittamahaM kila| parAvRtya samAgatya dAyUdaH patitaM punaH| dUSyamutthApayiSyAmi tadIyaM sarvvavastu ca| patitaM punaruthApya sajjayiSyAmi sarvvathA|| ");
INSERT INTO sanhk_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","A prathamAd IzvaraH svIyAni sarvvakarmmANi jAnAti| ");
INSERT INTO sanhk_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","ataeva mama nivedanamidaM bhinnadezIyalokAnAM madhye ye janA IzvaraM prati parAvarttanta teSAmupari anyaM kamapi bhAraM na nyasya ");
INSERT INTO sanhk_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","devatAprasAdAzucibhakSyaM vyabhicArakarmma kaNThasampIDanamAritaprANibhakSyaM raktabhakSyaJca etAni parityaktuM likhAmaH| ");
INSERT INTO sanhk_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","yataH pUrvvakAlato mUsAvyavasthApracAriNo lokA nagare nagare santi prativizrAmavAraJca bhajanabhavane tasyAH pATho bhavati| ");
INSERT INTO sanhk_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","tataH paraM preritagaNo lokaprAcInagaNaH sarvvA maNDalI ca sveSAM madhye barzabbA nAmnA vikhyAto manonItau kRtvA paulabarNabbAbhyAM sArddham AntiyakhiyAnagaraM prati preSaNam ucitaM buddhvA tAbhyAM patraM praiSayan| ");
INSERT INTO sanhk_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","tasmin patre likhitamiMda, AntiyakhiyA-suriyA-kilikiyAdezasthabhinnadezIyabhrAtRgaNAya preritagaNasya lokaprAcInagaNasya bhrAtRgaNasya ca namaskAraH| ");
INSERT INTO sanhk_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","vizeSato'smAkam AjJAm aprApyApi kiyanto janA asmAkaM madhyAd gatvA tvakchedo mUsAvyavasthA ca pAlayitavyAviti yuSmAn zikSayitvA yuSmAkaM manasAmasthairyyaM kRtvA yuSmAn sasandehAn akurvvan etAM kathAM vayam azRnma| ");
INSERT INTO sanhk_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","tatkAraNAd vayam ekamantraNAH santaH sabhAyAM sthitvA prabho ryIzukhrISTasya nAmanimittaM mRtyumukhagatAbhyAmasmAkaM ");
INSERT INTO sanhk_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","priyabarNabbApaulAbhyAM sArddhaM manonItalokAnAM keSAJcid yuSmAkaM sannidhau preSaNam ucitaM buddhavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","ato yihUdAsIlau yuSmAn prati preSitavantaH, etayo rmukhAbhyAM sarvvAM kathAM jJAsyatha| ");
INSERT INTO sanhk_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","devatAprasAdabhakSyaM raktabhakSyaM galapIDanamAritaprANibhakSyaM vyabhicArakarmma cemAni sarvvANi yuSmAbhistyAjyAni; etatprayojanIyAjJAvyatirekena yuSmAkam upari bhAramanyaM na nyasituM pavitrasyAtmano'smAkaJca ucitajJAnam abhavat| ");
INSERT INTO sanhk_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ataeva tebhyaH sarvvebhyaH sveSu rakSiteSu yUyaM bhadraM karmma kariSyatha| yuSmAkaM maGgalaM bhUyAt| ");
INSERT INTO sanhk_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","teे visRSTAH santa AntiyakhiyAnagara upasthAya lokanivahaM saMgRhya patram adadan| ");
INSERT INTO sanhk_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","tataste tatpatraM paThitvA sAntvanAM prApya sAnandA abhavan| ");
INSERT INTO sanhk_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","yihUdAsIlau ca svayaM pracArakau bhUtvA bhrAtRgaNaM nAnopadizya tAn susthirAn akurutAm| ");
INSERT INTO sanhk_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","itthaM tau tatra taiH sAkaM katipayadinAni yApayitvA pazcAt preritAnAM samIpe pratyAgamanArthaM teSAM sannidheH kalyANena visRSTAvabhavatAM| ");
INSERT INTO sanhk_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","kintu sIlastatra sthAtuM vAJchitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","aparaM paulabarNabbau bahavaH ziSyAzca lokAn upadizya prabhoH susaMvAdaM pracArayanta AntiyakhiyAyAM kAlaM yApitavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","katipayadineSu gateSu paulo barNabbAm avadat AgacchAvAM yeSu nagareSvIzvarasya susaMvAdaM pracAritavantau tAni sarvvanagarANi punargatvA bhrAtaraH kIdRzAH santIti draSTuM tAn sAkSAt kurvvaH| ");
INSERT INTO sanhk_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","tena mArkanAmnA vikhyAtaM yohanaM saGginaM karttuM barNabbA matimakarot, ");
INSERT INTO sanhk_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","kintu sa pUrvvaM tAbhyAM saha kAryyArthaM na gatvA pAmphUliyAdeze tau tyaktavAn tatkAraNAt paulastaM saGginaM karttum anucitaM jJAtavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","itthaM tayoratizayavirodhasyopasthitatvAt tau parasparaM pRthagabhavatAM tato barNabbA mArkaM gRhItvA potena kupropadvIpaM gatavAn; ");
INSERT INTO sanhk_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","kintu paulaH sIlaM manonItaM kRtvA bhrAtRbhirIzvarAnugrahe samarpitaH san prasthAya ");
INSERT INTO sanhk_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","suriyAkilikiyAdezAbhyAM maNDalIH sthirIkurvvan agacchat| ");
INSERT INTO sanhk_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","paulo darbbIlustrAnagarayorupasthitobhavat tatra tImathiyanAmA ziSya eka AsIt; sa vizvAsinyA yihUdIyAyA yoSito garbbhajAtaH kintu tasya pitAnyadezIyalokaH| ");
INSERT INTO sanhk_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","sa jano lustrA-ikaniyanagarasthAnAM bhrAtRNAM samIpepi sukhyAtimAn AsIt| ");
INSERT INTO sanhk_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","paulastaM svasaGginaM karttuM matiM kRtvA taM gRhItvA taddezanivAsinAM yihUdIyAnAm anurodhAt tasya tvakchedaM kRtavAn yatastasya pitA bhinnadezIyaloka iti sarvvairajJAyata| ");
INSERT INTO sanhk_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","tataH paraM te nagare nagare bhramitvA yirUzAlamasthaiH preritai rlokaprAcInaizca nirUpitaM yad vyavasthApatraM tadanusAreNAcarituM lokebhyastad dattavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","tenaiva sarvve dharmmasamAjAH khrISTadharmme susthirAH santaH pratidinaM varddhitA abhavan| ");
INSERT INTO sanhk_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","teSu phrugiyAgAlAtiyAdezamadhyena gateSu satsu pavitra AtmA tAn AziyAdeze kathAM prakAzayituM pratiSiddhavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","tathA musiyAdeza upasthAya bithuniyAM gantuM tairudyoge kRte AtmA tAn nAnvamanyata| ");
INSERT INTO sanhk_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","tasmAt te musiyAdezaM parityajya troyAnagaraM gatvA samupasthitAH| ");
INSERT INTO sanhk_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","rAtrau paulaH svapne dRSTavAn eko mAkidaniyalokastiSThan vinayaM kRtvA tasmai kathayati, mAkidaniyAdezam AgatyAsmAn upakurvviti| ");
INSERT INTO sanhk_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","tasyetthaM svapnadarzanAt prabhustaddezIyalokAn prati susaMvAdaM pracArayitum asmAn AhUyatIti nizcitaM buddhvA vayaM tUrNaM mAkidaniyAdezaM gantum udyogam akurmma| ");
INSERT INTO sanhk_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","tataH paraM vayaM troyAnagarAd prasthAya RjumArgeNa sAmathrAkiyopadvIpena gatvA pare'hani niyApalinagara upasthitAH| ");
INSERT INTO sanhk_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","tasmAd gatvA mAkidaniyAntarvvartti romIyavasatisthAnaM yat philipInAmapradhAnanagaraM tatropasthAya katipayadinAni tatra sthitavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","vizrAmavAre nagarAd bahi rgatvA nadItaTe yatra prArthanAcAra AsIt tatropavizya samAgatA nArIH prati kathAM prAcArayAma| ");
INSERT INTO sanhk_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","tataH thuyAtIrAnagarIyA dhUSarAmbaravikrAyiNI ludiyAnAmikA yA IzvarasevikA yoSit zrotrINAM madhya AsIt tayA pauloktavAkyAni yad gRhyante tadarthaM prabhustasyA manodvAraM muktavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ataH sA yoSit saparivArA majjitA satI vinayaM kRtvA kathitavatI, yuSmAkaM vicArAd yadi prabhau vizvAsinI jAtAhaM tarhi mama gRham Agatya tiSThata| itthaM sA yatnenAsmAn asthApayat| ");
INSERT INTO sanhk_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","yasyA gaNanayA tadadhipatInAM bahudhanopArjanaM jAtaM tAdRzI gaNakabhUtagrastA kAcana dAsI prArthanAsthAnagamanakAla AgatyAsmAn sAkSAt kRtavatI| ");
INSERT INTO sanhk_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","sAsmAkaM paulasya ca pazcAd etya proccaiH kathAmimAM kathitavatI, manuSyA ete sarvvoparisthasyezvarasya sevakAH santo'smAn prati paritrANasya mArgaM prakAzayanti| ");
INSERT INTO sanhk_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","sA kanyA bahudinAni tAdRzam akarot tasmAt paulo duHkhitaH san mukhaM parAvartya taM bhUtamavadad, ahaM yIzukhrISTasya nAmnA tvAmAjJApayAmi tvamasyA bahirgaccha; tenaiva tatkSaNAt sa bhUtastasyA bahirgataH| ");
INSERT INTO sanhk_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","tataH sveSAM lAbhasya pratyAzA viphalA jAteti vilokya tasyAH prabhavaH paulaM sIlaJca dhRtvAkRSya vicArasthAne'dhipatInAM samIpam Anayan| ");
INSERT INTO sanhk_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","tataH zAsakAnAM nikaTaM nItvA romilokA vayam asmAkaM yad vyavaharaNaM grahItum AcarituJca niSiddhaM, ");
INSERT INTO sanhk_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ime yihUdIyalokAH santopi tadeva zikSayitvA nagare'smAkam atIva kalahaM kurvvanti, ");
INSERT INTO sanhk_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","iti kathite sati lokanivahastayoH prAtikUlyenodatiSThat tathA zAsakAstayo rvastrANi chitvA vetrAghAtaM karttum AjJApayan| ");
INSERT INTO sanhk_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","aparaM te tau bahu prahAryya tvametau kArAM nItvA sAvadhAnaM rakSayeti kArArakSakam Adizan| ");
INSERT INTO sanhk_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ittham AjJAM prApya sa tAvabhyantarasthakArAM nItvA pAdeSu pAdapAzIbhi rbaddhvA sthApitAvAn| ");
INSERT INTO sanhk_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","atha nizIthasamaye paulasIlAvIzvaramuddizya prAthanAM gAnaJca kRtavantau, kArAsthitA lokAzca tadazRNvan ");
INSERT INTO sanhk_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","tadAkasmAt mahAn bhUmikampo'bhavat tena bhittimUlena saha kArA kampitAbhUt tatkSaNAt sarvvANi dvArANi muktAni jAtAni sarvveSAM bandhanAni ca muktAni| ");
INSERT INTO sanhk_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","ataeva kArArakSako nidrAto jAgaritvA kArAyA dvArANi muktAni dRSTvA bandilokAH palAyitA ityanumAya koSAt khaGgaM bahiH kRtvAtmaghAtaM karttum udyataH| ");
INSERT INTO sanhk_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","kintu paulaH proccaistamAhUya kathitavAn pazya vayaM sarvve'trAsmahe, tvaM nijaprANahiMsAM mAkArSIH| ");
INSERT INTO sanhk_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","tadA pradIpam Anetum uktvA sa kampamAnaH san ullampyAbhyantaram Agatya paulasIlayoH pAdeSu patitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","pazcAt sa tau bahirAnIya pRSTavAn he mahecchau paritrANaM prAptuM mayA kiM karttavyaM? ");
INSERT INTO sanhk_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","pazcAt tau svagRhamAnIya tayoH sammukhe khAdyadravyANi sthApitavAn tathA sa svayaM tadIyAH sarvve parivArAzcezvare vizvasantaH sAnanditA abhavan| ");
INSERT INTO sanhk_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","tasmai tasya gRhasthitasarvvalokebhyazca prabhoH kathAM kathitavantau| ");
INSERT INTO sanhk_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","tathA rAtrestasminneva daNDe sa tau gRhItvA tayoH prahArANAM kSatAni prakSAlitavAn tataH sa svayaM tasya sarvve parijanAzca majjitA abhavan| ");
INSERT INTO sanhk_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","pazcAt tau svagRhamAnIya tayoH sammukhe khAdyadravyANi sthApitavAn tathA sa svayaM tadIyAH sarvve parivArAzcezvare vizvasantaH sAnanditA abhavan| ");
INSERT INTO sanhk_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","dina upasthite tau lokau mocayeti kathAM kathayituM zAsakAH padAtigaNaM preSitavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","tataH kArArakSakaH paulAya tAM vArttAM kathitavAn yuvAM tyAjayituM zAsakA lokAna preSitavanta idAnIM yuvAM bahi rbhUtvA kuzalena pratiSThetAM| ");
INSERT INTO sanhk_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","kintu paulastAn avadat romilokayorAvayoH kamapi doSam na nizcitya sarvveSAM samakSam AvAM kazayA tADayitvA kArAyAM baddhavanta idAnIM kimAvAM guptaM vistrakSyanti? tanna bhaviSyati, svayamAgatyAvAM bahiH kRtvA nayantu| ");
INSERT INTO sanhk_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","tadA padAtibhiH zAsakebhya etadvArttAyAM kathitAyAM tau romilokAviti kathAM zrutvA te bhItAH ");
INSERT INTO sanhk_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","santastayoH sannidhimAgatya vinayam akurvvan aparaM bahiH kRtvA nagarAt prasthAtuM prArthitavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","tatastau kArAyA nirgatya ludiyAyA gRhaM gatavantau tatra bhrAtRgaNaM sAkSAtkRtya tAn sAntvayitvA tasmAt sthAnAt prasthitau| ");
INSERT INTO sanhk_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","paulasIlau AmphipalyApalloniyAnagarAbhyAM gatvA yatra yihUdIyAnAM bhajanabhavanamekam Aste tatra thiSalanIkInagara upasthitau| ");
INSERT INTO sanhk_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","tadA paulaH svAcArAnusAreNa teSAM samIpaM gatvA vizrAmavAratraye taiH sArddhaM dharmmapustakIyakathAyA vicAraM kRtavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","phalataH khrISTena duHkhabhogaH karttavyaH zmazAnadutthAnaJca karttavyaM yuSmAkaM sannidhau yasya yIzoH prastAvaM karomi sa IzvareNAbhiSiktaH sa etAH kathAH prakAzya pramANaM datvA sthirIkRtavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","tasmAt teSAM katipayajanA anyadezIyA bahavo bhaktalokA bahyaH pradhAnanAryyazca vizvasya paulasIlayoH pazcAdgAmino jAtAH| ");
INSERT INTO sanhk_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","kintu vizvAsahInA yihUdIyalokA IrSyayA paripUrNAH santo haTaTsya katinayalampaTalokAn saGginaH kRtvA janatayA nagaramadhye mahAkalahaM kRtvA yAsono gRham Akramya preritAn dhRtvA lokanivahasya samIpam AnetuM ceSTitavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","teSAmuddezam aprApya ca yAsonaM katipayAn bhrAtRMzca dhRtvA nagarAdhipatInAM nikaTamAnIya proccaiH kathitavanto ye manuSyA jagadudvATitavantaste 'trApyupasthitAH santi, ");
INSERT INTO sanhk_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","eSa yAson AtithyaM kRtvA tAn gRhItavAn| yIzunAmaka eko rAjastIti kathayantaste kaisarasyAjJAviruddhaM karmma kurvvati| ");
INSERT INTO sanhk_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","teSAM kathAmimAM zrutvA lokanivaho nagarAdhipatayazca samudvignA abhavan| ");
INSERT INTO sanhk_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","tadA yAsonastadanyeSAJca dhanadaNDaM gRhItvA tAn parityaktavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","tataH paraM bhrAtRgaNo rajanyAM paulasIlau zIghraM birayAnagaraM preSitavAn tau tatropasthAya yihUdIyAnAM bhajanabhavanaM gatavantau| ");
INSERT INTO sanhk_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","tatrasthA lokAH thiSalanIkIsthalokebhyo mahAtmAna Asan yata itthaM bhavati na veti jJAtuM dine dine dharmmagranthasyAlocanAM kRtvA svairaM kathAm agRhlan| ");
INSERT INTO sanhk_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","tasmAd aneke yihUdIyA anyadezIyAnAM mAnyA striyaH puruSAzcAneke vyazvasan| ");
INSERT INTO sanhk_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","kintu birayAnagare paulenezvarIyA kathA pracAryyata iti thiSalanIkIsthA yihUdIyA jJAtvA tatsthAnamapyAgatya lokAnAM kupravRttim ajanayan| ");
INSERT INTO sanhk_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","ataeva tasmAt sthAnAt samudreNa yAntIti darzayitvA bhrAtaraH kSipraM paulaM prAhiNvan kintu sIlatImathiyau tatra sthitavantau| ");
INSERT INTO sanhk_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","tataH paraM paulasya mArgadarzakAstam AthInInagara upasthApayan pazcAd yuvAM tUrNam etat sthAnaM AgamiSyathaH sIlatImathiyau pratImAm AjJAM prApya te pratyAgatAH| ");
INSERT INTO sanhk_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","paula AthInInagare tAvapekSya tiSThan tannagaraM pratimAbhiH paripUrNaM dRSTvA santaptahRdayo 'bhavat| ");
INSERT INTO sanhk_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","tataH sa bhajanabhavane yAn yihUdIyAn bhaktalokAMzca haTTe ca yAn apazyat taiH saha pratidinaM vicAritavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","kintvipikUrIyamatagrahiNaH stoyikIyamatagrAhiNazca kiyanto janAstena sArddhaM vyavadanta| tatra kecid akathayan eSa vAcAlaH kiM vaktum icchati? apare kecid eSa janaH keSAJcid videzIyadevAnAM pracAraka ityanumIyate yataH sa yIzum utthitiJca pracArayat| ");
INSERT INTO sanhk_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","te tam areyapAganAma vicArasthAnam AnIya prAvocan idaM yannavInaM mataM tvaM prAcIkaza idaM kIdRzaM etad asmAn zrAvaya; ");
INSERT INTO sanhk_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","yAmimAm asambhavakathAm asmAkaM karNagocarIkRtavAn asyA bhAvArthaH ka iti vayaM jJAtum icchAmaH| ");
INSERT INTO sanhk_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","tadAthInInivAsinastannagarapravAsinazca kevalaM kasyAzcana navInakathAyAH zravaNena pracAraNena ca kAlam ayApayan| ");
INSERT INTO sanhk_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","paulo'reyapAgasya madhye tiSThan etAM kathAM pracAritavAn, he AthInIyalokA yUyaM sarvvathA devapUjAyAm AsaktA ityaha pratyakSaM pazyAmi| ");
INSERT INTO sanhk_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","yataH paryyaTanakAle yuSmAkaM pUjanIyAni pazyan ‘avijJAtezvarAya` etallipiyuktAM yajJavedImekAM dRSTavAn; ato na viditvA yaM pUjayadhve tasyaiva tatvaM yuSmAn prati pracArayAmi| ");
INSERT INTO sanhk_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","jagato jagatsthAnAM sarvvavastUnAJca sraSTA ya IzvaraH sa svargapRthivyorekAdhipatiH san karanirmmitamandireSu na nivasati; ");
INSERT INTO sanhk_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","sa eva sarvvebhyo jIvanaM prANAn sarvvasAmagrIzca pradadAti; ataeva sa kasyAzcit sAmagyrA abhAvaheto rmanuSyANAM hastaiH sevito bhavatIti na| ");
INSERT INTO sanhk_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","sa bhUmaNDale nivAsArtham ekasmAt zoNitAt sarvvAn manuSyAn sRSTvA teSAM pUrvvanirUpitasamayaM vasatisImAJca niracinot; ");
INSERT INTO sanhk_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","tasmAt lokaiH kenApi prakAreNa mRgayitvA paramezvarasya tatvaM prAptuM tasya gaveSaNaM karaNIyam| ");
INSERT INTO sanhk_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","kintu so'smAkaM kasmAccidapi dUre tiSThatIti nahi, vayaM tena nizvasanaprazvasanagamanAgamanaprANadhAraNAni kurmmaH, puुnazca yuSmAkameva katipayAH kavayaH kathayanti ‘tasya vaMzA vayaM smo hi` iti| ");
INSERT INTO sanhk_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","ataeva yadi vayam Izvarasya vaMzA bhavAmastarhi manuSyai rvidyayA kauzalena ca takSitaM svarNaM rUpyaM dRSad vaiteSAmIzvaratvam asmAbhi rna jJAtavyaM| ");
INSERT INTO sanhk_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","teSAM pUrvvIyalokAnAm ajJAnatAM pratIzvaro yadyapi nAvAdhatta tathApIdAnIM sarvvatra sarvvAn manaH parivarttayitum AjJApayati, ");
INSERT INTO sanhk_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","yataH svaniyuktena puruSeNa yadA sa pRthivIsthAnAM sarvvalokAnAM vicAraM kariSyati taddinaM nyarUpayat; tasya zmazAnotthApanena tasmin sarvvebhyaH pramANaM prAdAt| ");
INSERT INTO sanhk_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","tadA zmazAnAd utthAnasya kathAM zrutvA kecid upAhaman, kecidavadan enAM kathAM punarapi tvattaH zroSyAmaH| ");
INSERT INTO sanhk_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","tataH paulasteSAM samIpAt prasthiाtavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","tathApi kecillokAstena sArddhaM militvA vyazvasan teSAM madhye 'reyapAgIyadiyanusiyo dAmArInAmA kAcinnArI kiyanto narAzcAsan| ");
INSERT INTO sanhk_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","tadghaTanAtaH paraM paula AthInInagarAd yAtrAM kRtvA karinthanagaram Agacchat| ");
INSERT INTO sanhk_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","tasmin samaye klaudiyaH sarvvAn yihUdIyAn romAnagaraM vihAya gantum AjJApayat, tasmAt priskillAnAmnA jAyayA sArddham itAliyAdezAt kiJcitpUrvvam Agamat yaH pantadeze jAta AkkilanAmA yihUdIyalokaH paulastaM sAkSAt prApya tayoH samIpamitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","tau dUSyanirmmANajIvinau, tasmAt parasparam ekavRttikatvAt sa tAbhyAM saha uSitvA tat karmmAkarot| ");
INSERT INTO sanhk_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","paulaH prativizrAmavAraM bhajanabhavanaM gatvA vicAraM kRtvA yihUdIyAn anyadezIyAMzca pravRttiM grAhitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","sIlatImathiyayo rmAkidaniyAdezAt sametayoH satoH paula uttaptamanA bhUtvA yIzurIzvareNAbhiSikto bhavatIti pramANaM yihUdIyAnAM samIpe prAdAt| ");
INSERT INTO sanhk_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","kintu te 'tIva virodhaM vidhAya pASaNDIyakathAM kathitavantastataH paulo vastraM dhunvan etAM kathAM kathitavAn, yuSmAkaM zoNitapAtAparAdho yuSmAn pratyeva bhavatu, tenAhaM niraparAdho 'dyArabhya bhinnadezIyAnAM samIpaM yAmi| ");
INSERT INTO sanhk_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","sa tasmAt prasthAya bhajanabhavanasamIpasthasya yustanAmna Izvarabhaktasya bhinnadezIyasya nivezanaM prAvizat| ");
INSERT INTO sanhk_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","tataH krISpanAmA bhajanabhavanAdhipatiH saparivAraH prabhau vyazvasIt, karinthanagarIyA bahavo lokAzca samAkarNya vizvasya majjitA abhavan| ");
INSERT INTO sanhk_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","kSaNadAyAM prabhuH paulaM darzanaM datvA bhASitavAn, mA bhaiSIH, mA nirasIH kathAM pracAraya| ");
INSERT INTO sanhk_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ahaM tvayA sArddham Asa hiMsArthaM kopi tvAM spraSTuM na zakSyati nagare'smin madIyA lokA bahava Asate| ");
INSERT INTO sanhk_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","tasmAt paulastannagare prAyeNa sArddhavatsaraparyyantaM saMsthAyezvarasya kathAm upAdizat| ");
INSERT INTO sanhk_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","gAlliyanAmA kazcid AkhAyAdezasya prADvivAkaH samabhavat, tato yihUdIyA ekavAkyAH santaH paulam Akramya vicArasthAnaM nItvA ");
INSERT INTO sanhk_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","mAnuSa eSa vyavasthAya viruddham IzvarabhajanaM karttuM lokAn kupravRttiM grAhayatIti niveditavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","tataH paule pratyuttaraM dAtum udyate sati gAlliyA yihUdIyAn vyAharat, yadi kasyacid anyAyasya vAtizayaduSTatAcaraNasya vicAro'bhaviSyat tarhi yuSmAkaM kathA mayA sahanIyAbhaviSyat| ");
INSERT INTO sanhk_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","kintu yadi kevalaM kathAyA vA nAmno vA yuSmAkaM vyavasthAyA vivAdo bhavati tarhi tasya vicAramahaM na kariSyAmi, yUyaM tasya mImAMsAM kuruta| ");
INSERT INTO sanhk_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","tataH sa tAn vicArasthAnAd dUrIkRtavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","tadA bhinnadezIyAH sosthininAmAnaM bhajanabhavanasya pradhAnAdhipatiM dhRtvA vicArasthAnasya sammukhe prAharan tathApi gAlliyA teSu sarvvakarmmasu na mano nyadadhAt| ");
INSERT INTO sanhk_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","paulastatra punarbahudinAni nyavasat, tato bhrAtRgaNAd visarjanaM prApya kiJcanavratanimittaM kiMkriyAnagare ziro muNDayitvA priskillAkkilAbhyAM sahito jalapathena suriyAdezaM gatavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","tata iphiSanagara upasthAya tatra tau visRjya svayaM bhajanabhvanaM pravizya yihUdIyaiH saha vicAritavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","te svaiH sArddhaM punaH katipayadinAni sthAtuM taM vyanayan, sa tadanurarIkRtya kathAmetAM kathitavAn, ");
INSERT INTO sanhk_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","yirUzAlami AgAmyutsavapAlanArthaM mayA gamanIyaM; pazcAd IzvarecchAyAM jAtAyAM yuSmAkaM samIpaM pratyAgamiSyAmi| tataH paraM sa tai rvisRSTaH san jalapathena iphiSanagarAt prasthitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","tataH kaisariyAm upasthitaH san nagaraM gatvA samAjaM namaskRtya tasmAd AntiyakhiyAnagaraM prasthitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","tatra kiyatkAlaM yApayitvA tasmAt prasthAya sarvveSAM ziSyANAM manAMsi susthirANi kRtvA kramazo galAtiyAphrugiyAdezayo rbhramitvA gatavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","tasminneva samaye sikandariyAnagare jAta ApallonAmA zAstravit suvaktA yihUdIya eko jana iphiSanagaram AgatavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","sa zikSitaprabhumArgo manasodyogI ca san yohano majjanamAtraM jJAtvA yathArthatayA prabhoH kathAM kathayan samupAdizat| ");
INSERT INTO sanhk_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","eSa jano nirbhayatvena bhajanabhavane kathayitum ArabdhavAn, tataH priskillAkkilau tasyopadezakathAM nizamya taM svayoH samIpam AnIya zuddharUpeNezvarasya kathAm abodhayatAm| ");
INSERT INTO sanhk_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","pazcAt sa AkhAyAdezaM gantuM matiM kRtavAn, tadA tatratyaH ziSyagaNo yathA taM gRhlAti tadarthaM bhrAtRgaNena samAzvasya patre likhite sati, ApallAstatropasthitaH san anugraheNa pratyayinAM bahUpakArAn akarot, ");
INSERT INTO sanhk_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","phalato yIzurabhiSiktastrAteti zAstrapramANaM datvA prakAzarUpeNa pratipannaM kRtvA yihUdIyAn niruttarAn kRtavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","karinthanagara ApallasaH sthitikAle paula uttarapradezairAgacchan iphiSanagaram upasthitavAn| tatra katipayaziSyAn sAkSat prApya tAn apRcchat, ");
INSERT INTO sanhk_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","yUyaM vizvasya pavitramAtmAnaM prAptA na vA? tataste pratyavadan pavitra AtmA dIyate ityasmAbhiH zrutamapi nahi| ");
INSERT INTO sanhk_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","tadA sA'vadat tarhi yUyaM kena majjitA abhavata? te'kathayan yohano majjanena| ");
INSERT INTO sanhk_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","tadA paula uktavAn itaH paraM ya upasthAsyati tasmin arthata yIzukhrISTe vizvasitavyamityuktvA yohan manaHparivarttanasUcakena majjanena jale lokAn amajjayat| ");
INSERT INTO sanhk_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","tAdRzIM kathAM zrutvA te prabho ryIzukhrISTasya nAmnA majjitA abhavan| ");
INSERT INTO sanhk_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","tataH paulena teSAM gAtreSu kare'rpite teSAmupari pavitra AtmAvarUDhavAn, tasmAt te nAnAdezIyA bhASA bhaviSyatkathAzca kathitavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","te prAyeNa dvAdazajanA Asan| ");
INSERT INTO sanhk_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","paulo bhajanabhavanaM gatvA prAyeNa mAsatrayam Izvarasya rAjyasya vicAraM kRtvA lokAn pravartya sAhasena kathAmakathayat| ");
INSERT INTO sanhk_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","kintu kaThinAntaHkaraNatvAt kiyanto janA na vizvasya sarvveSAM samakSam etatpathasya nindAM karttuM pravRttAH, ataH paulasteSAM samIpAt prasthAya ziSyagaNaM pRthakkRtvA pratyahaM turAnnanAmnaH kasyacit janasya pAThazAlAyAM vicAraM kRtavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","itthaM vatsaradvayaM gataM tasmAd AziyAdezanivAsinaH sarvve yihUdIyA anyadezIyalokAzca prabho ryIzoH kathAm azrauSan| ");
INSERT INTO sanhk_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","paulena ca Izvara etAdRzAnyadbhutAni karmmANi kRtavAn ");
INSERT INTO sanhk_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","yat paridheye gAtramArjanavastre vA tasya dehAt pIDitalokAnAm samIpam AnIte te nirAmayA jAtA apavitrA bhUtAzca tebhyo bahirgatavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","tadA dezATanakAriNaH kiyanto yihUdIyA bhUtApasAriNo bhUtagrastanokAnAM sannidhau prabhe ryIzo rnAma japtvA vAkyamidam avadan, yasya kathAM paulaH pracArayati tasya yIzo rnAmnA yuSmAn AjJApayAmaH| ");
INSERT INTO sanhk_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","skivanAmno yihUdIyAnAM pradhAnayAjakasya saptabhiH puttaistathA kRte sati ");
INSERT INTO sanhk_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","kazcid apavitro bhUtaH pratyuditavAn, yIzuM jAnAmi paulaJca paricinomi kintu ke yUyaM? ");
INSERT INTO sanhk_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ityuktvA sopavitrabhUtagrasto manuSyo lamphaM kRtvA teSAmupari patitvA balena tAn jitavAn, tasmAtte nagnAH kSatAGgAzca santastasmAd gehAt palAyanta| ");
INSERT INTO sanhk_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","sA vAg iphiSanagaranivAsinasaM sarvveSAM yihUdIyAnAM bhinnadezIyAnAM lokAnAJca zravogocarIbhUtA; tataH sarvve bhayaM gatAH prabho ryIzo rnAmno yazo 'varddhata| ");
INSERT INTO sanhk_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","yeSAmanekeSAM lokAnAM pratItirajAyata ta Agatya svaiH kRtAH kriyAH prakAzarUpeNAGgIkRtavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","bahavo mAyAkarmmakAriNaH svasvagranthAn AnIya rAzIkRtya sarvveSAM samakSam adAhayan, tato gaNanAM kRtvAbudhyanta paJcAyutarUpyamudrAmUlyapustakAni dagdhAni| ");
INSERT INTO sanhk_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","itthaM prabhoH kathA sarvvadezaM vyApya prabalA jAtA| ");
INSERT INTO sanhk_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","sarvveSveteSu karmmasu sampanneSu satsu paulo mAkidaniyAkhAyAdezAbhyAM yirUzAlamaM gantuM matiM kRtvA kathitavAn tatsthAnaM yAtrAyAM kRtAyAM satyAM mayA romAnagaraM draSTavyaM| ");
INSERT INTO sanhk_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","svAnugatalokAnAM tImathiyerAstau dvau janau mAkidaniyAdezaM prati prahitya svayam AziyAdeze katipayadinAni sthitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","kintu tasmin samaye mate'smin kalaho jAtaH| ");
INSERT INTO sanhk_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","tatkAraNamidaM, arttimIdevyA rUpyamandiranirmmANena sarvveSAM zilpinAM yatheSTalAbham ajanayat yo dImItriyanAmA nADIndhamaH ");
INSERT INTO sanhk_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","sa tAn tatkarmmajIvinaH sarvvalokAMzca samAhUya bhASitavAn he mahecchA etena mandiranirmmANenAsmAkaM jIvikA bhavati, etad yUyaM vittha; ");
INSERT INTO sanhk_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","kintu hastanirmmitezvarA IzvarA nahi paulanAmnA kenacijjanena kathAmimAM vyAhRtya kevalephiSanagare nahi prAyeNa sarvvasmin AziyAdeze pravRttiM grAhayitvA bahulokAnAM zemuSI parAvarttitA, etad yuSmAbhi rdRzyate zrUyate ca| ");
INSERT INTO sanhk_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","tenAsmAkaM vANijyasya sarvvathA hAneH sambhavanaM kevalamiti nahi, AziyAdezasthai rvA sarvvajagatsthai rlokaiH pUjyA yArtimI mahAdevI tasyA mandirasyAvajJAnasya tasyA aizvaryyasya nAzasya ca sambhAvanA vidyateे| ");
INSERT INTO sanhk_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","etAdRzIM kathAM zrutvA te mahAkrodhAnvitAH santa uccaiHkAraM kathitavanta iphiSIyAnAm arttimI devI mahatI bhavati| ");
INSERT INTO sanhk_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","tataH sarvvanagaraM kalahena paripUrNamabhavat, tataH paraM te mAkidanIyagAyAristArkhanAmAnau paulasya dvau sahacarau dhRtvaikacittA raGgabhUmiM javena dhAvitavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","tataH paulo lokAnAM sannidhiM yAtum udyatavAn kintu ziSyagaNastaM vAritavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","paulasyatmIyA AziyAdezasthAH katipayAH pradhAnalokAstasya samIpaM naramekaM preSya tvaM raGgabhUmiM mAgA iti nyavedayan| ");
INSERT INTO sanhk_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","tato nAnAlokAnAM nAnAkathAkathanAt sabhA vyAkulA jAtA kiM kAraNAd etAvatI janatAbhavat etad adhikai rlokai rnAjJAyi| ");
INSERT INTO sanhk_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","tataH paraM janatAmadhyAd yihUdIyairbahiSkRtaH sikandaro hastena saGketaM kRtvA lokebhya uttaraM dAtumudyatavAn, ");
INSERT INTO sanhk_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","kintu sa yihUdIyaloka iti nizcite sati iphiSIyAnAm arttimI devI mahatIti vAkyaM prAyeNa paJca daNDAn yAvad ekasvareNa lokanivahaiH proktaM| ");
INSERT INTO sanhk_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","tato nagarAdhipatistAn sthirAn kRtvA kathitavAn he iphiSAyAH sarvve lokA AkarNayata, artimImahAdevyA mahAdevAt patitAyAstatpratimAyAzca pUjanama iphiSanagarasthAH sarvve lokAH kurvvanti, etat ke na jAnanti? ");
INSERT INTO sanhk_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","tasmAd etatpratikUlaM kepi kathayituM na zaknuvanti, iti jJAtvA yuSmAbhiH susthiratvena sthAtavyam avivicya kimapi karmma na karttavyaJca| ");
INSERT INTO sanhk_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","yAn etAn manuSyAn yUyamatra samAnayata te mandiradravyApahArakA yuSmAkaM devyA nindakAzca na bhavanti| ");
INSERT INTO sanhk_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","yadi kaJcana prati dImItriyasya tasya sahAyAnAJca kAcid Apatti rvidyate tarhi pratinidhilokA vicArasthAnaJca santi, te tat sthAnaM gatvA uttarapratyuttare kurvvantu| ");
INSERT INTO sanhk_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","kintu yuSmAkaM kAcidaparA kathA yadi tiSThati tarhi niyamitAyAM sabhAyAM tasyA niSpatti rbhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","kintvetasya virodhasyottaraM yena dAtuM zaknum etAdRzasya kasyacit kAraNasyAbhAvAd adyatanaghaTanAheto rAjadrohiNAmivAsmAkam abhiyogo bhaviSyatIti zaGkA vidyate| ");
INSERT INTO sanhk_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","iti kathayitvA sa sabhAsthalokAn visRSTavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","itthaM kalahe nivRtte sati paulaH ziSyagaNam AhUya visarjanaM prApya mAkidaniyAdezaM prasthitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","tena sthAnena gacchan taddezIyAn ziSyAn bahUpadizya yUnAnIyadezam upasthitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","tatra mAsatrayaM sthitvA tasmAt suriyAdezaM yAtum udyataH, kintu yihUdIyAstaM hantuM guptA atiSThan tasmAt sa punarapi mAkidaniyAmArgeNa pratyAgantuM matiM kRtavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","birayAnagarIyasopAtraH thiSalanIkIyAristArkhasikundau darbbonagarIyagAyatImathiyau AziyAdezIyatukhikatraphimau ca tena sArddhaM AziyAdezaM yAvad gatavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ete sarvve 'grasarAH santo 'smAn apekSya troyAnagare sthitavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","kiNvazUnyapUpotsavadine ca gate sati vayaM philipInagarAt toyapathena gatvA paJcabhi rdinaistroyAnagaram upasthAya tatra saptadinAnyavAtiSThAma| ");
INSERT INTO sanhk_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","saptAhasya prathamadine pUpAn bhaMktu ziSyeSu militeSu paulaH paradine tasmAt prasthAtum udyataH san tadahni prAyeNa kSapAyA yAmadvayaM yAvat ziSyebhyo dharmmakathAm akathayat| ");
INSERT INTO sanhk_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","uparisthe yasmin prakoSThe sabhAM kRtvAsan tatra bahavaH pradIpAH prAjvalan| ");
INSERT INTO sanhk_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","utukhanAmA kazcana yuvA ca vAtAyana upavizan ghorataranidrAgrasto 'bhUt tadA paulena bahukSaNaM kathAyAM pracAritAyAM nidrAmagnaH sa tasmAd uparisthatRtIyaprakoSThAd apatat, tato lokAstaM mRtakalpaM dhRtvodatolayan| ");
INSERT INTO sanhk_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","tataH paulo'varuhya tasya gAtre patitvA taM kroDe nidhAya kathitavAn, yUyaM vyAkulA mA bhUta nAyaM prANai rviyuktaH| ");
INSERT INTO sanhk_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","pazcAt sa punazcopari gatvA pUpAn bhaMktvA prabhAtaM yAvat kathopakathane kRtvA prasthitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","te ca taM jIvantaM yuvAnaM gRhItvA gatvA paramApyAyitA jAtAH| ");
INSERT INTO sanhk_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","anantaraM vayaM potenAgrasarA bhUtvAsmanagaram uttIryya paulaM grahItuM matim akurmma yataH sa tatra padbhyAM vrajituM matiM kRtveti nirUpitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","tasmAt tatrAsmAbhiH sArddhaM tasmin milite sati vayaM taM nItvA mitulInyupadvIpaM prAptavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","tasmAt potaM mocayitvA pare'hani khIyopadvIpasya sammukhaM labdhavantastasmAd ekenAhnA sAmopadvIpaM gatvA potaM lAgayitvA trogulliye sthitvA parasmin divaseे milItanagaram upAtiSThAma| ");
INSERT INTO sanhk_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","yataH paula AziyAdeze kAlaM yApayitum nAbhilaSan iphiSanagaraM tyaktvA yAtuM mantraNAM sthirIkRtavAn; yasmAd yadi sAdhyaM bhavati tarhi nistArotsavasya paJcAzattamadine sa yirUzAlamyupasthAtuM matiM kRtavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","paulo milItAd iphiSaM prati lokaM prahitya samAjasya prAcInAn AhUyAnItavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","teSu tasya samIpam upasthiteSu sa tebhya imAM kathAM kathitavAn, aham AziyAdeze prathamAgamanam ArabhyAdya yAvad yuSmAkaM sannidhau sthitvA sarvvasamaye yathAcaritavAn tad yUyaM jAnItha; ");
INSERT INTO sanhk_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","phalataH sarvvathA namramanAH san bahuzrupAtena yihudIyAnAm kumantraNAjAtanAnAparIkSAbhiH prabhoH sevAmakaravaM| ");
INSERT INTO sanhk_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","kAmapi hitakathAाM na gopAyitavAn tAM pracAryya saprakAzaM gRhe gRhe samupadizyezvaraM prati manaH parAvarttanIyaM prabhau yIzukhrISTe vizvasanIyaM ");
INSERT INTO sanhk_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","yihUdIyAnAm anyadezIyalokAnAJca samIpa etAdRzaM sAkSyaM dadAmi| ");
INSERT INTO sanhk_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","pazyata sAmpratam AtmanAkRSTaH san yirUzAlamnagare yAtrAM karomi, tatra mAmprati yadyad ghaTiSyate tAnyahaM na jAnAmi; ");
INSERT INTO sanhk_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","kintu mayA bandhanaM klezazca bhoktavya iti pavitra AtmA nagare nagare pramANaM dadAti| ");
INSERT INTO sanhk_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","tathApi taM klezamahaM tRNAya na manye; IzvarasyAnugrahaviSayakasya susaMvAdasya pramANaM dAtuM, prabho ryIzoH sakAzAda yasyAH sevAyAH bhAraM prApnavaM tAM sevAM sAdhayituM sAnandaM svamArgaM samApayituुJca nijaprANAnapi priyAn na manye| ");
INSERT INTO sanhk_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","adhunA pazyata yeSAM samIpe'ham IzvarIyarAjyasya susaMvAdaM pracAryya bhramaNaM kRtavAn etAdRzA yUyaM mama vadanaM puna rdraSTuM na prApsyatha etadapyahaM jAnAmi| ");
INSERT INTO sanhk_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","yuSmabhyam aham Izvarasya sarvvAn AdezAn prakAzayituM na nyavartte| ");
INSERT INTO sanhk_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","ahaM sarvveSAM lokAnAM raktapAtadoSAd yannirdoSa Ase tasyAdya yuSmAn sAkSiNaH karomi| ");
INSERT INTO sanhk_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","yUyaM sveSu tathA yasya vrajasyAdhyakSan AtmA yuSmAn vidhAya nyayuGkta tatsarvvasmin sAvadhAnA bhavata, ya samAjaJca prabhu rnijaraktamUlyena krItavAna tam avata, ");
INSERT INTO sanhk_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","yato mayA gamane kRtaeva durjayA vRkA yuSmAkaM madhyaM pravizya vrajaM prati nirdayatAm AcariSyanti, ");
INSERT INTO sanhk_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","yuSmAkameva madhyAdapi lokA utthAya ziSyagaNam apahantuM viparItam upadekSyantItyahaM jAnAmi| ");
INSERT INTO sanhk_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","iti heto ryUyaM sacaitanyAH santastiSTata, ahaJca sAzrupAtaH san vatsaratrayaM yAvad divAnizaM pratijanaM bodhayituM na nyavartte tadapi smarata| ");
INSERT INTO sanhk_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","idAnIM he bhrAtaro yuSmAkaM niSThAM janayituM pavitrIkRtalokAnAM madhye'dhikAraJca dAtuM samartho ya IzvarastasyAnugrahasya yo vAdazca tayorubhayo ryuSmAn samArpayam| ");
INSERT INTO sanhk_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","kasyApi svarNaM rUpyaM vastraM vA prati mayA lobho na kRtaH| ");
INSERT INTO sanhk_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","kintu mama matsahacaralokAnAJcAvazyakavyayAya madIyamidaM karadvayam azrAmyad etad yUyaM jAnItha| ");
INSERT INTO sanhk_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","anena prakAreNa grahaNad dAnaM bhadramiti yadvAkyaM prabhu ryIzuH kathitavAn tat smarttuM daridralokAnAmupakArArthaM zramaM karttuJca yuSmAkam ucitam etatsarvvaM yuSmAnaham upadiSTavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","etAM kathAM kathayitvA sa jAnunI pAtayitvA sarvaiH saha prArthayata| ");
INSERT INTO sanhk_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","tena te krandrantaH ");
INSERT INTO sanhk_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","puna rmama mukhaM na drakSyatha vizeSata eSA yA kathA tenAkathi tatkAraNAt zokaM vilApaJca kRtvA kaNThaM dhRtvA cumbitavantaH| pazcAt te taM potaM nItavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","tai rvisRSTAH santo vayaM potaM bAhayitvA RjumArgeNa koSam upadvIpam Agatya pare'hani rodiyopadvIpam AgacchAma tatastasmAt pAtArAyAm upAtiSThAma| ");
INSERT INTO sanhk_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","tatra phainIkiyAdezagAminam potamekaM prApya tamAruhya gatavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","kupropadvIpaM dRSTvA taM savyadizi sthApayitvA suriyAdezaM gatvA potasthadravyANyavarohayituM soranagare lAgitavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","tatra ziSyagaNasya sAkSAtkaraNAya vayaM tatra saptadinAni sthitavantaH pazcAtte pavitreNAtmanA paulaM vyAharan tvaM yirUzAlamnagaraM mA gamaH| ");
INSERT INTO sanhk_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","tatasteSu saptasu dineSu yApiteSu satsu vayaM tasmAt sthAnAt nijavartmanA gatavantaH, tasmAt te sabAlavRddhavanitA asmAbhiH saha nagarasya parisaraparyyantam AgatAH pazcAdvayaM jaladhitaTe jAnupAtaM prArthayAmahi| ");
INSERT INTO sanhk_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","tataH parasparaM visRSTAH santo vayaM potaM gatAste tu svasvagRhaM pratyAgatavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","vayaM soranagarAt nAvA prasthAya talimAyinagaram upAtiSThAma tatrAsmAkaM samudrIyamArgasyAnto'bhavat tatra bhrAtRgaNaM namaskRtya dinamekaM taiH sArddham uSatavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","pare 'hani paulastasya saGgino vayaJca pratiSThamAnAH kaisariyAnagaram Agatya susaMvAdapracArakAnAM saptajanAnAM philipanAmna ekasya gRhaM pravizyAvatiSThAma| ");
INSERT INTO sanhk_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","tasya catasro duhitaro'nUDhA bhaviSyadvAdinya Asan| ");
INSERT INTO sanhk_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","tatrAsmAsu bahudinAni proSiteSu yihUdIyadezAd AgatyAgAbanAmA bhaviSyadvAdI samupasthitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","sosmAkaM samIpametya paulasya kaTibandhanaM gRhItvA nijahastApAdAn baddhvA bhASitavAn yasyedaM kaTibandhanaM taM yihUdIyalokA yirUzAlamanagara itthaM baddhvA bhinnadezIyAnAM kareSu samarpayiSyantIti vAkyaM pavitra AtmA kathayati| ");
INSERT INTO sanhk_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","etAdRzIM kathAM zrutvA vayaM tannagaravAsino bhrAtarazca yirUzAlamaM na yAtuM paulaM vyanayAmahi; ");
INSERT INTO sanhk_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","kintu sa pratyAvAdIt, yUyaM kiM kurutha? kiM krandanena mamAntaHkaraNaM vidIrNaM kariSyatha? prabho ryIzo rnAmno nimittaM yirUzAlami baddho bhavituM kevala tanna prANAn dAtumapi sasajjosmi| ");
INSERT INTO sanhk_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","tenAsmAkaM kathAyAm agRhItAyAm Izvarasya yathecchA tathaiva bhavatvityuktvA vayaM nirasyAma| ");
INSERT INTO sanhk_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","pare'hani pAtheyadravyANi gRhItvA yirUzAlamaM prati yAtrAm akurmma| ");
INSERT INTO sanhk_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","tataH kaisariyAnagaranivAsinaH katipayAH ziSyA asmAbhiH sArddham itvA kRprIyena mnAsannAmnA yena prAcInaziSyena sArddham asmAbhi rvastavyaM tasya samIpam asmAn nItavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","asmAsu yirUzAlamyupasthiteSu tatrasthabhrAtRgaNo'smAn AhlAdena gRhItavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","parasmin divase paule'smAbhiH saha yAkUbo gRhaM praviSTe lokaprAcInAH sarvve tatra pariSadi saMsthitAH| ");
INSERT INTO sanhk_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","anantaraM sa tAn natvA svIyapracAraNena bhinnadezIyAn pratIzvaro yAni karmmANi sAdhitavAn tadIyAM kathAm anukramAt kathitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","iti zrutvA te prabhuM dhanyaM procya vAkyamidam abhASanta, he bhrAta ryihUdIyAnAM madhye bahusahasrANi lokA vizvAsina Asate kintu te sarvve vyavasthAmatAcAriNa etat pratyakSaM pazyasi| ");
INSERT INTO sanhk_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","zizUnAM tvakchedanAdyAcaraNaM pratiSidhya tvaM bhinnadezanivAsino yihUdIyalokAn mUsAvAkyam azraddhAtum upadizasIti taiH zrutamasti| ");
INSERT INTO sanhk_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","tvamatrAgatosIti vArttAM samAkarNya jananivaho militvAvazyamevAgamiSyati; ataeva kiM karaNIyam? atra vayaM mantrayitvA samupAyaM tvAM vadAmastaM tvamAcara| ");
INSERT INTO sanhk_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","vrataM karttuM kRtasaGkalpA ye'smAMka catvAro mAnavAH santi ");
INSERT INTO sanhk_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","tAn gRhItvA taiH sahitaH svaM zuciM kuru tathA teSAM ziromuNDane yo vyayo bhavati taM tvaM dehi| tathA kRte tvadIyAcAre yA janazruti rjAyate sAlIkA kintu tvaM vidhiM pAlayan vyavasthAnusAreNevAcarasIti te bhotsante| ");
INSERT INTO sanhk_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","bhinnadezIyAnAM vizvAsilokAnAM nikaTe vayaM patraM likhitvetthaM sthirIkRtavantaH, devaprasAdabhojanaM raktaM galapIDanamAritaprANibhojanaM vyabhicArazcaitebhyaH svarakSaNavyatirekeNa teSAmanyavidhipAlanaM karaNIyaM na| ");
INSERT INTO sanhk_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","tataH paulastAn mAnuSAnAdAya parasmin divase taiH saha zuci rbhUtvA mandiraM gatvA zaucakarmmaNo dineSu sampUrNeSu teSAm ekaikArthaM naivedyAdyutsargo bhaviSyatIti jJApitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","teSu saptasu dineSu samAptakalpeSu AziyAdezanivAsino yihUdIyAstaM madhyemandiraM vilokya jananivahasya manaHsu kupravRttiM janayitvA taM dhRtvA ");
INSERT INTO sanhk_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","proccaiH prAvocan, he isrAyellokAH sarvve sAhAyyaM kuruta| yo manuja eteSAM lokAnAM mUsAvyavasthAyA etasya sthAnasyApi viparItaM sarvvatra sarvvAn zikSayati sa eSaH; vizeSataH sa bhinnadezIyalokAn mandiram AnIya pavitrasthAnametad apavitramakarot| ");
INSERT INTO sanhk_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","pUrvvaM te madhyenagaram iphiSanagarIyaM traphimaM paulena sahitaM dRSTavanta etasmAt paulastaM mandiramadhyam Anayad ityanvamimata| ");
INSERT INTO sanhk_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","ataeva sarvvasmin nagare kalahotpannatvAt dhAvanto lokA Agatya paulaM dhRtvA mandirasya bahirAkRSyAnayan tatkSaNAd dvArANi sarvvANi ca ruddhAni| ");
INSERT INTO sanhk_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","teSu taM hantumudyateेSu yirUzAlamnagare mahAnupadravo jAta iti vArttAyAM sahasrasenApateH karNagocarIbhUtAyAM satyAM sa tatkSaNAt sainyAni senApatigaNaJca gRhItvA javenAgatavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","tato lokAH senAgaNena saha sahasrasenApatim AgacchantaM dRSTvA paulatADanAto nyavarttanta| ");
INSERT INTO sanhk_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","sa sahasrasenApatiH sannidhAvAgamya paulaM dhRtvA zRGkhaladvayena baddham Adizya tAn pRSTavAn eSa kaH? kiM karmma cAyaM kRtavAn? ");
INSERT INTO sanhk_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","tato janasamUhasya kazcid ekaprakAraM kazcid anyaprakAraM vAkyam araut sa tatra satyaM jJAtum kalahakAraNAd azaktaH san taM durgaM netum AjJApayat| ");
INSERT INTO sanhk_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","teSu sopAnasyopari prApteSu lokAnAM sAhasakAraNAt senAgaNaH paulamuttolya nItavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","tataH sarvve lokAH pazcAdgAminaH santa enaM durIkuruteti vAkyam uccairavadan| ");
INSERT INTO sanhk_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","paulasya durgAnayanasamaye sa tasmai sahasrasenApataye kathitavAn, bhavataH purastAt kathAM kathayituM kim anumanyate? sa tamapRcchat tvaM kiM yUnAnIyAM bhASAM jAnAsi? ");
INSERT INTO sanhk_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","yo misarIyo janaH pUrvvaM virodhaM kRtvA catvAri sahasrANi ghAtakAn saGginaH kRtvA vipinaM gatavAn tvaM kiM saeva na bhavasi? ");
INSERT INTO sanhk_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","tadA paulo'kathayat ahaM kilikiyAdezasya tArSanagarIyo yihUdIyo, nAhaM sAmAnyanagarIyo mAnavaH; ataeva vinaye'haM lAkAnAM samakSaM kathAM kathayituM mAmanujAnISva| ");
INSERT INTO sanhk_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","tenAnujJAtaH paulaH sopAnopari tiSThan hasteneGgitaM kRtavAn, tasmAt sarvve susthirA abhavan| tadA paula ibrIyabhASayA kathayitum Arabhata, ");
INSERT INTO sanhk_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","he pitRgaNA he bhrAtRgaNAH, idAnIM mama nivedane samavadhatta| ");
INSERT INTO sanhk_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","tadA sa ibrIyabhASayA kathAM kathayatIti zrutvA sarvve lokA atIva niHzabdA santo'tiSThan| ");
INSERT INTO sanhk_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","pazcAt so'kathayad ahaM yihUdIya iti nizcayaH kilikiyAdezasya tArSanagaraM mama janmabhUmiH,etannagarIyasya gamilIyelanAmno'dhyApakasya ziSyo bhUtvA pUrvvapuruSANAM vidhivyavasthAnusAreNa sampUrNarUpeNa zikSito'bhavam idAnIntanA yUyaM yAdRzA bhavatha tAdRzo'hamapIzvarasevAyAm udyogI jAtaH| ");
INSERT INTO sanhk_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","matametad dviSTvA tadgrAhinArIpuruSAn kArAyAM baddhvA teSAM prANanAzaparyyantAM vipakSatAm akaravam| ");
INSERT INTO sanhk_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","mahAyAjakaH sabhAsadaH prAcInalokAzca mamaitasyAH kathAyAH pramANaM dAtuM zaknuvanti, yasmAt teSAM samIpAd dammeSakanagaranivAsibhrAtRgaNArtham AjJApatrANi gRhItvA ye tatra sthitAstAn daNDayituM yirUzAlamam AnayanArthaM dammeSakanagaraM gatosmi| ");
INSERT INTO sanhk_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","kintu gacchan tannagarasya samIpaM prAptavAn tadA dvitIyapraharavelAyAM satyAm akasmAd gagaNAnnirgatya mahatI dIpti rmama caturdizi prakAzitavatI| ");
INSERT INTO sanhk_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","tato mayi bhUmauै patite sati, he zaula he zaula kuto mAM tADayasi? mAmprati bhASita etAdRza eko ravopi mayA zrutaH| ");
INSERT INTO sanhk_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","tadAhaM pratyavadaM, he prabhe ko bhavAn? tataH so'vAdIt yaM tvaM tADayasi sa nAsaratIyo yIzurahaM| ");
INSERT INTO sanhk_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","mama saGgino lokAstAM dIptiM dRSTvA bhiyaM prAptAH, kintu mAmpratyuditaM tadvAkyaM teे nAbudhyanta| ");
INSERT INTO sanhk_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","tataH paraM pRSTavAnahaM, he prabho mayA kiM karttavyaM? tataH prabhurakathayat, utthAya dammeSakanagaraM yAhi tvayA yadyat karttavyaM nirUpitamAste tat tatra tvaM jJApayiSyase| ");
INSERT INTO sanhk_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","anantaraM tasyAH kharataradIpteH kAraNAt kimapi na dRSTvA saGgigaNena dhRtahastaH san dammeSakanagaraM vrajitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","tannagaranivAsinAM sarvveSAM yihUdIyAnAM mAnyo vyavasthAnusAreNa bhaktazca hanAnIyanAmA mAnava eko ");
INSERT INTO sanhk_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","mama sannidhim etya tiSThan akathayat, he bhrAtaH zaula sudRSTi rbhava tasmin daNDe'haM samyak taM dRSTavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","tataH sa mahyaM kathitavAn yathA tvam IzvarasyAbhiprAyaM vetsi tasya zuddhasattvajanasya darzanaM prApya tasya zrImukhasya vAkyaM zRNoSi tannimittam asmAkaM pUrvvapuruSANAm IzvarastvAM manonItaM kRtavAnaM| ");
INSERT INTO sanhk_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","yato yadyad adrAkSIrazrauSIzca sarvveSAM mAnavAnAM samIpe tvaM teSAM sAkSI bhaviSyasi| ");
INSERT INTO sanhk_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","ataeva kuto vilambase? prabho rnAmnA prArthya nijapApaprakSAlanArthaM majjanAya samuttiSTha| ");
INSERT INTO sanhk_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","tataH paraM yirUzAlamnagaraM pratyAgatya mandire'ham ekadA prArthaye, tasmin samaye'ham abhibhUtaH san prabhUM sAkSAt pazyan, ");
INSERT INTO sanhk_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","tvaM tvarayA yirUzAlamaH pratiSThasva yato lokAmayi tava sAkSyaM na grahISyanti, mAmpratyuditaM tasyedaM vAkyam azrauSam| ");
INSERT INTO sanhk_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","tatohaM pratyavAdiSam he prabho pratibhajanabhavanaM tvayi vizvAsino lokAn baddhvA prahRtavAn, ");
INSERT INTO sanhk_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","tathA tava sAkSiNaH stiphAnasya raktapAtanasamaye tasya vinAzaM sammanya sannidhau tiSThan hantRlokAnAM vAsAMsi rakSitavAn, etat te viduH| ");
INSERT INTO sanhk_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","tataH so'kathayat pratiSThasva tvAM dUrasthabhinnadezIyAnAM samIpaM preSayiSye| ");
INSERT INTO sanhk_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","tadA lokA etAvatparyyantAM tadIyAM kathAM zrutvA proccairakathayan, enaM bhUmaNDalAd dUrIkuruta, etAdRzajanasya jIvanaM nocitam| ");
INSERT INTO sanhk_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ityuccaiH kathayitvA vasanAni parityajya gagaNaM prati dhUlIrakSipan ");
INSERT INTO sanhk_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","tataH sahasrasenApatiH paulaM durgAbhyantara netuM samAdizat| etasya pratikUlAH santo lokAH kinnimittam etAvaduccaiHsvaram akurvvan, etad vettuM taM kazayA prahRtya tasya parIkSAM karttumAdizat| ");
INSERT INTO sanhk_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","padAtayazcarmmanirmmitarajjubhistasya bandhanaM karttumudyatAstAstadAnIM paulaH sammukhasthitaM zatasenApatim uktavAn daNDAjJAyAm aprAptAyAM kiM romilokaM praharttuM yuSmAkam adhikArosti? ");
INSERT INTO sanhk_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","enAM kathAM zrutvA sa sahasrasenApateH sannidhiM gatvA tAM vArttAmavadat sa romiloka etasmAt sAvadhAnaH san karmma kuru| ");
INSERT INTO sanhk_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","tasmAt sahasrasenApati rgatvA tamaprAkSIt tvaM kiM romilokaH? iti mAM brUhi| so'kathayat satyam| ");
INSERT INTO sanhk_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","tataH sahasrasenApatiH kathitavAn bahudraviNaM dattvAhaM tat paurasakhyaM prAptavAn; kintu paulaH kathitavAn ahaM janunA tat prApto'smi| ");
INSERT INTO sanhk_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","itthaM sati ye prahAreNa taM parIkSituM samudyatA Asan te tasya samIpAt prAtiSThanta; sahasrasenApatistaM romilokaM vijJAya svayaM yat tasya bandhanam akArSIt tatkAraNAd abibhet| ");
INSERT INTO sanhk_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","yihUdIyalokAH paulaM kuto'pavadante tasya vRttAntaM jJAtuM vAJchan sahasrasenApatiH pare'hani paulaM bandhanAt mocayitvA pradhAnayAjakAn mahAsabhAyAH sarvvalokAzca samupasthAtum Adizya teSAM sannidhau paulam avarohya sthApitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","sabhAsadlokAn prati paulo'nanyadRSTyA pazyan akathayat, he bhrAtRgaNA adya yAvat saralena sarvvAntaHkaraNenezvarasya sAkSAd AcarAmi| ");
INSERT INTO sanhk_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","anena hanAnIyanAmA mahAyAjakastaM kapole capeTenAhantuM samIpasthalokAn AdiSTavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","tadA paulastamavadat, he bahiSpariSkRta, IzvarastvAM praharttum udyatosti, yato vyavasthAnusAreNa vicArayitum upavizya vyavasthAM laGghitvA mAM praharttum AjJApayasi| ");
INSERT INTO sanhk_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","tato nikaTasthA lokA akathayan, tvaM kim Izvarasya mahAyAjakaM nindasi? ");
INSERT INTO sanhk_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","tataH paulaH pratibhASitavAn he bhrAtRgaNa mahAyAjaka eSa iti na buddhaM mayA tadanyacca svalokAnAm adhipatiM prati durvvAkyaM mA kathaya, etAdRzI lipirasti| ");
INSERT INTO sanhk_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","anantaraM paulasteSAm arddhaM sidUkilokA arddhaM phirUzilokA iti dRSTvA proccaiH sabhAsthalokAn avadat he bhrAtRgaNa ahaM phirUzimatAvalambI phirUzinaH satnAnazca, mRtalokAnAm utthAne pratyAzAkaraNAd ahamapavAditosmi| ");
INSERT INTO sanhk_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","iti kathAyAM kathitAyAM phirUzisidUkinoH parasparaM bhinnavAkyatvAt sabhAyA madhye dvau saMghau jAtau| ");
INSERT INTO sanhk_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","yataH sidUkilokA utthAnaM svargIyadUtA AtmAnazca sarvveSAm eteSAM kamapi na manyante, kintu phirUzinaH sarvvam aGgIkurvvanti| ");
INSERT INTO sanhk_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","tataH parasparam atizayakolAhale samupasthite phirUzinAM pakSIyAH sabhAsthA adhyApakAH pratipakSA uttiSThanto 'kathayan, etasya mAnavasya kamapi doSaM na pazyAmaH; yadi kazcid AtmA vA kazcid dUta enaM pratyAdizat tarhi vayam Izvarasya prAtikUlyena na yotsyAmaH| ");
INSERT INTO sanhk_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","tasmAd atIva bhinnavAkyatve sati te paulaM khaNDaM khaNDaM kariSyantItyAzaGkayA sahasrasenApatiH senAgaNaM tatsthAnaM yAtuM sabhAto balAt paulaM dhRtvA durgaM netaJcAjJApayat| ");
INSERT INTO sanhk_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","rAtro prabhustasya samIpe tiSThan kathitavAn he paula nirbhayo bhava yathA yirUzAlamnagare mayi sAkSyaM dattavAn tathA romAnagarepi tvayA dAtavyam| ");
INSERT INTO sanhk_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","dine samupasthite sati kiyanto yihUdIyalokA ekamantraNAH santaH paulaM na hatvA bhojanapAne kariSyAma iti zapathena svAn abadhnan| ");
INSERT INTO sanhk_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","catvAriMzajjanebhyo'dhikA lokA iti paNam akurvvan| ");
INSERT INTO sanhk_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","te mahAyAjakAnAM prAcInalokAnAJca samIpaM gatvA kathayan, vayaM paulaM na hatvA kimapi na bhokSyAmahe dRDhenAnena zapathena baddhvA abhavAma| ");
INSERT INTO sanhk_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","ataeva sAmprataM sabhAsadlokaiH saha vayaM tasmin kaJcid vizeSavicAraM kariSyAmastadarthaM bhavAn zvo 'smAkaM samIpaM tam Anayatviti sahasrasenApataye nivedanaM kuruta tena yuSmAkaM samIpaM upasthiteH pUrvvaM vayaM taM hantu sajjiSyAma| ");
INSERT INTO sanhk_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","tadA paulasya bhAgineyasteSAmiti mantraNAM vijJAya durgaM gatvA tAM vArttAM paulam uktavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","tasmAt paula ekaM zatasenApatim AhUya vAkyamidam bhASitavAn sahasrasenApateH samIpe'sya yuvamanuSyasya kiJcinnivedanam Aste, tasmAt tatsavidham enaM naya| ");
INSERT INTO sanhk_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","tataH sa tamAdAya sahasrasenApateH samIpam upasthAya kathitavAn, bhavataH samIpe'sya kimapi nivedanamAste tasmAt bandiH paulo mAmAhUya bhavataH samIpam enam AnetuM prArthitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","tadA sahasrasenApatistasya hastaM dhRtvA nirjanasthAnaM nItvA pRSThavAn tava kiM nivedanaM? tat kathaya| ");
INSERT INTO sanhk_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","tataH sokathayat, yihUdIyalAkAH paule kamapi vizeSavicAraM chalaM kRtvA taM sabhAM netuM bhavataH samIpe nivedayituM amantrayan| ");
INSERT INTO sanhk_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","kintu mavatA tanna svIkarttavyaM yatasteSAM madhyevarttinazcatvAriMzajjanebhyo 'dhikalokA ekamantraNA bhUtvA paulaM na hatvA bhojanaM pAnaJca na kariSyAma iti zapathena baddhAH santo ghAtakA iva sajjitA idAnIM kevalaM bhavato 'numatim apekSante| ");
INSERT INTO sanhk_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","yAmimAM kathAM tvaM niveditavAn tAM kasmaicidapi mA kathayetyuktvA sahasrasenApatistaM yuvAnaM visRSTavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","anantaraM sahasrasenApati rdvau zatasenApatI AhUyedam Adizat, yuvAM rAtrau praharaikAvaziSTAyAM satyAM kaisariyAnagaraM yAtuM padAtisainyAnAM dve zate ghoTakArohisainyAnAM saptatiM zaktidhArisainyAnAM dve zate ca janAn sajjitAn kurutaM| ");
INSERT INTO sanhk_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","paulam ArohayituM phIlikSAdhipateH samIpaM nirvvighnaM netuJca vAhanAni samupasthApayataM| ");
INSERT INTO sanhk_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","aparaM sa patraM likhitvA dattavAn tallikhitametat, ");
INSERT INTO sanhk_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","mahAmahimazrIyuktaphIlikSAdhipataye klaudiyaluSiyasya namaskAraH| ");
INSERT INTO sanhk_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","yihUdIyalokAH pUrvvam enaM mAnavaM dhRtvA svahastai rhantum udyatA etasminnantare sasainyohaM tatropasthAya eSa jano romIya iti vijJAya taM rakSitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","kinnimittaM te tamapavadante tajjJAtuM teSA sabhAM tamAnAyitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","tatasteSAM vyavasthAyA viruddhayA kayAcana kathayA so'pavAdito'bhavat, kintu sa zRGkhalabandhanArho vA prANanAzArho bhavatIdRzaH kopyaparAdho mayAsya na dRSTaH| ");
INSERT INTO sanhk_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","tathApi manuSyasyAsya vadhArthaM yihUdIyA ghAtakAiva sajjitA etAM vArttAM zrutvA tatkSaNAt tava samIpamenaM preSitavAn asyApavAdakAMzca tava samIpaM gatvApavaditum AjJApayam| bhavataH kuzalaM bhUyAt| ");
INSERT INTO sanhk_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","sainyagaNa AjJAnusAreNa paulaM gRhItvA tasyAM rajanyAm AntipAtrinagaram Anayat| ");
INSERT INTO sanhk_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","pare'hani tena saha yAtuM ghoTakArUDhasainyagaNaM sthApayitvA parAvRtya durgaM gatavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","tataH pare ghoTakArohisainyagaNaH kaisariyAnagaram upasthAya tatpatram adhipateH kare samarpya tasya samIpe paulam upasthApitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","tadAdhipatistatpatraM paThitvA pRSThavAn eSa kimpradezIyo janaH? sa kilikiyApradezIya eko jana iti jJAtvA kathitavAn, ");
INSERT INTO sanhk_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","tavApavAdakagaNa Agate tava kathAM zroSyAmi| herodrAjagRhe taM sthApayitum AdiSTavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","paJcabhyo dinebhyaH paraM hanAnIyanAmA mahAyAjako'dhipateH samakSaM paulasya prAtikUlyena nivedayituM tartullanAmAnaM kaJcana vaktAraM prAcInajanAMzca saGginaH kRtvA kaisariyAnagaram Agacchat| ");
INSERT INTO sanhk_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","tataH paule samAnIte sati tartullastasyApavAdakathAM kathayitum Arabhata he mahAmahimaphIlikSa bhavato vayam atinirvvighnaM kAlaM yApayAmo bhavataH pariNAmadarzitayA etaddezIyAnAM bahUni maGgalAni ghaTitAni, ");
INSERT INTO sanhk_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","iti heto rvayamatikRtajJAH santaH sarvvatra sarvvadA bhavato guNAn gAyamaH| ");
INSERT INTO sanhk_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","kintu bahubhiH kathAbhi rbhavantaM yena na viraJjayAmi tasmAd vinaye bhavAn banukampya madalpakathAM zRNotu| ");
INSERT INTO sanhk_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","eSa mahAmArIsvarUpo nAsaratIyamatagrAhisaMghAtasya mukhyo bhUtvA sarvvadezeSu sarvveSAM yihUdIyAnAM rAjadrohAcaraNapravRttiM janayatItyasmAbhi rnizcitaM| ");
INSERT INTO sanhk_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","sa mandiramapi azuci karttuM ceSTitavAn; iti kAraNAd vayam enaM dhRtvA svavyavasthAnusAreNa vicArayituM prAvarttAmahi; ");
INSERT INTO sanhk_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","kintu luSiyaH sahasrasenApatirAgatya balAd asmAkaM karebhya enaM gRhItvA ");
INSERT INTO sanhk_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","etasyApavAdakAn bhavataH samIpam Agantum AjJApayat| vayaM yasmin tamapavAdAmo bhavatA padapavAdakathAyAM vicAritAyAM satyAM sarvvaM vRttAntaM vedituM zakSyate| ");
INSERT INTO sanhk_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","tato yihUdIyA api svIkRtya kathitavanta eSA kathA pramANam| ");
INSERT INTO sanhk_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","adhipatau kathAM kathayituM paulaM pratIGgitaM kRtavati sa kathitavAn bhavAn bahUn vatsarAn yAvad etaddezasya zAsanaM karotIti vijJAya pratyuttaraM dAtum akSobho'bhavam| ");
INSERT INTO sanhk_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","adya kevalaM dvAdaza dinAni yAtAni, aham ArAdhanAM karttuM yirUzAlamanagaraM gatavAn eSA kathA bhavatA jJAtuM zakyate; ");
INSERT INTO sanhk_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","kintvibhe mAM madhyemandiraM kenApi saha vitaNDAM kurvvantaM kutrApi bhajanabhavane nagare vA lokAn kupravRttiM janayantuM na dRSTavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","idAnIM yasmin yasmin mAm apavadante tasya kimapi pramANaM dAtuM na zaknuvanti| ");
INSERT INTO sanhk_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","kintu bhaviSyadvAkyagranthe vyavasthAgranthe ca yA yA kathA likhitAste tAsu sarvvAsu vizvasya yanmatam ime vidharmmaM jAnanti tanmatAnusAreNAhaM nijapitRpuruSANAm Izvaram ArAdhayAmItyahaM bhavataH samakSam aGgIkaromi| ");
INSERT INTO sanhk_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","dhArmmikANAm adhArmmikANAJca pramItalokAnAmevotthAnaM bhaviSyatIti kathAmime svIkurvvanti tathAhamapi tasmin Izvare pratyAzAM karomi; ");
INSERT INTO sanhk_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Izvarasya mAnavAnAJca samIpe yathA nirdoSo bhavAmi tadarthaM satataM yatnavAn asmi| ");
INSERT INTO sanhk_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","bahuSu vatsareSu gateSu svadezIyalokAnAM nimittaM dAnIyadravyANi naivedyAni ca samAdAya punarAgamanaM kRtavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","tatohaM zuci rbhUtvA lokAnAM samAgamaM kalahaM vA na kAritavAn tathApyAziyAdezIyAH kiyanto yihudIyalokA madhyemandiraM mAM dhRtavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","mamopari yadi kAcidapavAdakathAsti tarhi bhavataH samIpam upasthAya teSAmeva sAkSyadAnam ucitam| ");
INSERT INTO sanhk_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","nocet pUrvve mahAsabhAsthAnAM lokAnAM sannidhau mama daNDAyamAnatvasamaye, ahamadya mRtAnAmutthAne yuSmAbhi rvicAritosmi, ");
INSERT INTO sanhk_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","teSAM madhye tiSThannahaM yAmimAM kathAmuccaiH svareNa kathitavAn tadanyo mama kopi doSo'labhyata na veti varam ete samupasthitalokA vadantu| ");
INSERT INTO sanhk_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","tadA phIlikSa etAM kathAM zrutvA tanmatasya vizeSavRttAntaM vijJAtuM vicAraM sthagitaM kRtvA kathitavAn luSiye sahasrasenApatau samAyAte sati yuSmAkaM vicAram ahaM niSpAdayiSyAmi| ");
INSERT INTO sanhk_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","anantaraM bandhanaM vinA paulaM rakSituM tasya sevanAya sAkSAtkaraNAya vA tadIyAtmIyabandhujanAn na vArayituJca zamasenApatim AdiSTavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","alpadinAt paraM phIlikSo'dhipati rdruSillAnAmnA yihUdIyayA svabhAryyayA sahAgatya paulamAhUya tasya mukhAt khrISTadharmmasya vRttAntam azrauSIt| ");
INSERT INTO sanhk_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","paulena nyAyasya parimitabhogasya caramavicArasya ca kathAyAM kathitAyAM satyAM phIlikSaH kampamAnaH san vyAharad idAnIM yAhi, aham avakAzaM prApya tvAm AhUsyAmi| ");
INSERT INTO sanhk_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","muktipraptyarthaM paulena mahyaM mudrAdAsyante iti patyAzAM kRtvA sa punaH punastamAhUya tena sAkaM kathopakathanaM kRtavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","kintu vatsaradvayAt paraM parkiyaphISTa phAlikSasya padaM prApte sati phIlikSo yihUdIyAn santuSTAn cikIrSan paulaM baddhaM saMsthApya gatavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","anantaraM phISTo nijarAjyam Agatya dinatrayAt paraM kaisariyAto yirUzAlamnagaram Agamat| ");
INSERT INTO sanhk_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","tadA mahAyAjako yihUdIyAnAM pradhAnalokAzca tasya samakSaM paulam apAvadanta| ");
INSERT INTO sanhk_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","bhavAn taM yirUzAlamam Anetum AjJApayatviti vinIya te tasmAd anugrahaM vAJchitavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","yataH pathimadhye gopanena paulaM hantuM tai rghAtakA niyuktAH| phISTa uttaraM dattavAn paulaH kaisariyAyAM sthAsyati punaralpadinAt param ahaM tatra yAsyAmi| ");
INSERT INTO sanhk_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","tatastasya mAnuSasya yadi kazcid aparAdhastiSThati tarhi yuSmAkaM ye zaknuvanti te mayA saha tatra gatvA tamapavadantu sa etAM kathAM kathitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","dazadivasebhyo'dhikaM vilambya phISTastasmAt kaisariyAnagaraM gatvA parasmin divase vicArAsana upadizya paulam Anetum AjJApayat| ");
INSERT INTO sanhk_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","paule samupasthite sati yirUzAlamnagarAd AgatA yihUdIyalokAstaM caturdizi saMveSTya tasya viruddhaM bahUn mahAdoSAn utthApitavantaH kintu teSAM kimapi pramANaM dAtuM na zaknuvantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","tataH paulaH svasmin uttaramidam uditavAn, yihUdIyAnAM vyavasthAyA mandirasya kaisarasya vA pratikUlaM kimapi karmma nAhaM kRtavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","kintu phISTo yihUdIyAn santuSTAn karttum abhilaSan paulam abhASata tvaM kiM yirUzAlamaM gatvAsmin abhiyoge mama sAkSAd vicArito bhaviSyasi? ");
INSERT INTO sanhk_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","tataH paula uttaraM proktavAn, yatra mama vicAro bhavituM yogyaH kaisarasya tatra vicArAsana eva samupasthitosmi; ahaM yihUdIyAnAM kAmapi hAniM nAkArSam iti bhavAn yathArthato vijAnAti| ");
INSERT INTO sanhk_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","kaJcidaparAdhaM kiJcana vadhArhaM karmma vA yadyaham akariSyaM tarhi prANahananadaNDamapi bhoktum udyato'bhaviSyaM, kintu te mama samapavAdaM kurvvanti sa yadi kalpitamAtro bhavati tarhi teSAM kareSu mAM samarpayituM kasyApyadhikAro nAsti, kaisarasya nikaTe mama vicAro bhavatu| ");
INSERT INTO sanhk_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","tadA phISTo mantribhiH sArddhaM saMmantrya paulAya kathitavAn, kaisarasya nikaTe kiM tava vicAro bhaviSyati? kaisarasya samIpaM gamiSyasi| ");
INSERT INTO sanhk_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","kiyaddinebhyaH param AgripparAjA barNIkI ca phISTaM sAkSAt karttuM kaisariyAnagaram Agatavantau| ");
INSERT INTO sanhk_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","tadA tau bahudinAni tatra sthitau tataH phISTastaM rAjAnaM paulasya kathAM vijJApya kathayitum Arabhata paulanAmAnam ekaM bandi phIlikSo baddhaM saMsthApya gatavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","yirUzAlami mama sthitikAle mahAyAjako yihUdIyAnAM prAcInalokAzca tam apodya tamprati daNDAjJAM prArthayanta| ");
INSERT INTO sanhk_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","tatoham ityuttaram avadaM yAvad apodito janaH svApavAdakAn sAkSAt kRtvA svasmin yo'parAdha Aropitastasya pratyuttaraM dAtuM suyogaM na prApnoti, tAvatkAlaM kasyApi mAnuSasya prANanAzAjJApanaM romilokAnAM rIti rnahi| ");
INSERT INTO sanhk_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","tatasteSvatrAgateSu parasmin divase'ham avilambaM vicArAsana upavizya taM mAnuSam Anetum AjJApayam| ");
INSERT INTO sanhk_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","tadanantaraM tasyApavAdakA upasthAya yAdRzam ahaM cintitavAn tAdRzaM kaJcana mahApavAdaM notthApya ");
INSERT INTO sanhk_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","sveSAM mate tathA paulo yaM sajIvaM vadati tasmin yIzunAmani mRtajane ca tasya viruddhaM kathitavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","tatohaM tAdRgvicAre saMzayAnaH san kathitavAn tvaM yirUzAlamaM gatvA kiM tatra vicArito bhavitum icchasi? ");
INSERT INTO sanhk_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","tadA paulo mahArAjasya nikaTe vicArito bhavituM prArthayata, tasmAd yAvatkAlaM taM kaisarasya samIpaM preSayituM na zaknomi tAvatkAlaM tamatra sthApayitum AdiSTavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","tata AgrippaH phISTam uktavAn, ahamapi tasya mAnuSasya kathAM zrotum abhilaSAmi| tadA phISTo vyAharat zvastadIyAM kathAM tvaM zroSyasi| ");
INSERT INTO sanhk_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","parasmin divase Agrippo barNIkI ca mahAsamAgamaM kRtvA pradhAnavAhinIpatibhi rnagarasthapradhAnalokaizca saha militvA rAjagRhamAgatya samupasthitau tadA phISTasyAjJayA paula AnIto'bhavat| ");
INSERT INTO sanhk_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","tadA phISTaH kathitavAn he rAjan Agrippa he upasthitAH sarvve lokA yirUzAlamnagare yihUdIyalokasamUho yasmin mAnuSe mama samIpe nivedanaM kRtvA proccaiH kathAmimAM kathitavAn punaralpakAlamapi tasya jIvanaM nocitaM tametaM mAnuSaM pazyata| ");
INSERT INTO sanhk_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","kintveSa janaH prANanAzarhaM kimapi karmma na kRtavAn ityajAnAM tathApi sa mahArAjasya sannidhau vicArito bhavituM prArthayata tasmAt tasya samIpaM taM preSayituM matimakaravam| ");
INSERT INTO sanhk_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","kintu zrIyuktasya samIpam etasmin kiM lekhanIyam ityasya kasyacin nirNayasya na jAtatvAd etasya vicAre sati yathAhaM lekhituM kiJcana nizcitaM prApnomi tadarthaM yuSmAkaM samakSaM vizeSato he AgripparAja bhavataH samakSam etam Anaye| ");
INSERT INTO sanhk_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","yato bandipreSaNasamaye tasyAbhiyogasya kiJcidalekhanam aham ayuktaM jAnAmi| ");
INSERT INTO sanhk_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","tata AgrippaH paulam avAdIt, nijAM kathAM kathayituM tubhyam anumati rdIyate| tasmAt paulaH karaM prasAryya svasmin uttaram avAdIt| ");
INSERT INTO sanhk_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","he AgripparAja yatkAraNAdahaM yihUdIyairapavAdito 'bhavaM tasya vRttAntam adya bhavataH sAkSAn nivedayitumanumatoham idaM svIyaM paramaM bhAgyaM manye; ");
INSERT INTO sanhk_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","yato yihUdIyalokAnAM madhye yA yA rItiH sUkSmavicArAzca santi teSu bhavAn vijJatamaH; ataeva prArthaye dhairyyamavalambya mama nivedanaM zRNotu| ");
INSERT INTO sanhk_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","ahaM yirUzAlamnagare svadezIyalokAnAM madhye tiSThan A yauvanakAlAd yadrUpam AcaritavAn tad yihUdIyalokAH sarvve vidanti| ");
INSERT INTO sanhk_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","asmAkaM sarvvebhyaH zuddhatamaM yat phirUzIyamataM tadavalambI bhUtvAhaM kAlaM yApitavAn ye janA A bAlyakAlAn mAM jAnAnti te etAdRzaM sAkSyaM yadi dadAti tarhi dAtuM zaknuvanti| ");
INSERT INTO sanhk_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","kintu he AgripparAja Izvaro'smAkaM pUrvvapuruSANAM nikaTe yad aGgIkRtavAn tasya pratyAzAhetoraham idAnIM vicArasthAne daNDAyamAnosmi| ");
INSERT INTO sanhk_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","tasyAGgIkArasya phalaM prAptum asmAkaM dvAdazavaMzA divAnizaM mahAyatnAd IzvarasevanaM kRtvA yAM pratyAzAM kurvvanti tasyAH pratyAzAyA hetorahaM yihUdIyairapavAdito'bhavam| ");
INSERT INTO sanhk_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Izvaro mRtAn utthApayiSyatIti vAkyaM yuSmAkaM nikaTe'sambhavaM kuto bhavet? ");
INSERT INTO sanhk_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","nAsaratIyayIzo rnAmno viruddhaM nAnAprakArapratikUlAcaraNam ucitam ityahaM manasi yathArthaM vijJAya ");
INSERT INTO sanhk_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","yirUzAlamanagare tadakaravaM phalataH pradhAnayAjakasya nikaTAt kSamatAM prApya bahUn pavitralokAn kArAyAM baddhavAn vizeSatasteSAM hananasamaye teSAM viruddhAM nijAM sammatiM prakAzitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","vAraM vAraM bhajanabhavaneSu tebhyo daNDaM pradattavAn balAt taM dharmmaM nindayitavAMzca punazca tAn prati mahAkrodhAd unmattaH san videzIyanagarANi yAvat tAn tADitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","itthaM pradhAnayAjakasya samIpAt zaktim AjJApatraJca labdhvA dammeSaknagaraM gatavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","tadAhaM he rAjan mArgamadhye madhyAhnakAle mama madIyasaGginAM lokAnAJca catasRSu dikSu gagaNAt prakAzamAnAM bhAskaratopi tejasvatIM dIptiM dRSTavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","tasmAd asmAsu sarvveSu bhUmau patiteSu satsu he zaula hai zaula kuto mAM tADayasi? kaNTakAnAM mukhe pAdAhananaM tava duHsAdhyam ibrIyabhASayA gadita etAdRza ekaH zabdo mayA zrutaH| ");
INSERT INTO sanhk_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","tadAhaM pRSTavAn he prabho ko bhavAn? tataH sa kathitavAn yaM yIzuM tvaM tADayasi sohaM, ");
INSERT INTO sanhk_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","kintu samuttiSTha tvaM yad dRSTavAn itaH punaJca yadyat tvAM darzayiSyAmi teSAM sarvveSAM kAryyANAM tvAM sAkSiNaM mama sevakaJca karttum darzanam adAm| ");
INSERT INTO sanhk_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","vizeSato yihUdIyalokebhyo bhinnajAtIyebhyazca tvAM manonItaM kRtvA teSAM yathA pApamocanaM bhavati ");
INSERT INTO sanhk_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","yathA te mayi vizvasya pavitrIkRtAnAM madhye bhAgaM prApnuvanti tadabhiprAyeNa teSAM jJAnacakSUMSi prasannAni karttuM tathAndhakArAd dIptiM prati zaitAnAdhikArAcca IzvaraM prati matIH parAvarttayituM teSAM samIpaM tvAM preSyAmi| ");
INSERT INTO sanhk_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","he AgripparAja etAdRzaM svargIyapratyAdezaM agrAhyam akRtvAhaM ");
INSERT INTO sanhk_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","prathamato dammeSaknagare tato yirUzAlami sarvvasmin yihUdIyadeze anyeSu dezeSu ca yeेna lokA matiM parAvarttya IzvaraM prati parAvarttayante, manaHparAvarttanayogyAni karmmANi ca kurvvanti tAdRzam upadezaM pracAritavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","etatkAraNAd yihUdIyA madhyemandiraM mAM dhRtvA hantum udyatAH| ");
INSERT INTO sanhk_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","tathApi khrISTo duHkhaM bhuktvA sarvveSAM pUrvvaM zmazAnAd utthAya nijadezIyAnAM bhinnadezIyAnAJca samIpe dIptiM prakAzayiSyati ");
INSERT INTO sanhk_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","bhaviSyadvAdigaNo mUsAzca bhAvikAryyasya yadidaM pramANam adaduretad vinAnyAM kathAM na kathayitvA IzvarAd anugrahaM labdhvA mahatAM kSudrANAJca sarvveSAM samIpe pramANaM dattvAdya yAvat tiSThAmi| ");
INSERT INTO sanhk_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","tasyamAM kathAM nizamya phISTa uccaiH svareNa kathitavAn he paula tvam unmattosi bahuvidyAbhyAsena tvaM hatajJAno jAtaH| ");
INSERT INTO sanhk_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","sa uktavAn he mahAmahima phISTa nAham unmattaH kintu satyaM vivecanIyaJca vAkyaM prastaumi| ");
INSERT INTO sanhk_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","yasya sAkSAd akSobhaH san kathAM kathayAmi sa rAjA tadvRttAntaM jAnAti tasya samIpe kimapi guptaM neti mayA nizcitaM budhyate yatastad vijane na kRtaM| ");
INSERT INTO sanhk_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","he AgripparAja bhavAn kiM bhaviSyadvAdigaNoktAni vAkyAni pratyeti? bhavAn pratyeti tadahaM jAnAmi| ");
INSERT INTO sanhk_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","tata AgrippaH paulam abhihitavAn tvaM pravRttiM janayitvA prAyeNa mAmapi khrISTIyaM karoSi| ");
INSERT INTO sanhk_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","tataH so'vAdIt bhavAn ye ye lokAzca mama kathAm adya zRNvanti prAyeNa iti nahi kintvetat zRGkhalabandhanaM vinA sarvvathA te sarvve mAdRzA bhavantvitIzvasya samIpe prArthaye'ham| ");
INSERT INTO sanhk_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","etasyAM kathAyAM kathitAyAM sa rAjA so'dhipati rbarNIkI sabhAsthA lokAzca tasmAd utthAya ");
INSERT INTO sanhk_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","gopane parasparaM vivicya kathitavanta eSa jano bandhanArhaM prANahananArhaM vA kimapi karmma nAkarot| ");
INSERT INTO sanhk_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","tata AgrippaH phISTam avadat, yadyeSa mAnuSaH kaisarasya nikaTe vicArito bhavituM na prArthayiSyat tarhi mukto bhavitum azakSyat| ");
INSERT INTO sanhk_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","jalapathenAsmAkam itoliyAdezaM prati yAtrAyAM nizcitAyAM satyAM te yUliyanAmno mahArAjasya saMghAtAntargatasya senApateH samIpe paulaM tadanyAn katinayajanAMzca samArpayan| ");
INSERT INTO sanhk_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","vayam AdrAmuttIyaM potamekam Aruhya AziyAdezasya taTasamIpena yAtuM matiM kRtvA laGgaram utthApya potam amocayAma; mAkidaniyAdezasthathiSalanIkInivAsyAristArkhanAmA kazcid jano'smAbhiH sArddham AsIt| ");
INSERT INTO sanhk_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","parasmin divase 'smAbhiH sIdonnagare pote lAgite tatra yUliyaH senApatiH paulaM prati saujanyaM pradarthya sAntvanArthaM bandhubAndhavAn upayAtum anujajJau| ");
INSERT INTO sanhk_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","tasmAt pote mocite sati sammukhavAyoH sambhavAd vayaM kupropadvIpasya tIrasamIpena gatavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","kilikiyAyAH pAmphUliyAyAzca samudrasya pAraM gatvA lUkiyAdezAntargataM murAnagaram upAtiSThAma| ");
INSERT INTO sanhk_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","tatsthAnAd itAliyAdezaM gacchati yaH sikandariyAnagarasya potastaM tatra prApya zatasenApatistaM potam asmAn Arohayat| ");
INSERT INTO sanhk_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","tataH paraM bahUni dinAni zanaiH zanaiH rgatvA knIdapArzvopasthtiेH pUrvvaM pratikUlena pavanena vayaM salmonyAH sammukham upasthAya krItyupadvIpasya tIrasamIpena gatavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","kaSTena tamuttIryya lAseyAnagarasyAdhaH sundaranAmakaM khAtam upAtiSThAma| ");
INSERT INTO sanhk_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","itthaM bahutithaH kAlo yApita upavAsadinaJcAtItaM, tatkAraNAt nauvartmani bhayaGkare sati paulo vinayena kathitavAn, ");
INSERT INTO sanhk_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","he mahecchA ahaM nizcayaM jAnAmi yAtrAyAmasyAm asmAkaM klezA bahUnAmapacayAzca bhaviSyanti, te kevalaM potasAmagryoriti nahi, kintvasmAkaM prANAnAmapi| ");
INSERT INTO sanhk_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","tadA zatasenApatiH pauैेloktavAkyatopi karNadhArasya potavaNijazca vAkyaM bahumaMsta| ");
INSERT INTO sanhk_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","tat khAtaM zItakAle vAsArhasthAnaM na tasmAd avAcIpratIcordizoH krItyAH phainIkiyakhAtaM yAtuM yadi zaknuvantastarhi tatra zItakAlaM yApayituM prAyeNa sarvve mantrayAmAsuH| ");
INSERT INTO sanhk_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","tataH paraM dakSiNavAyu rmandaM vahatIti vilokya nijAbhiprAyasya siddheH suyogo bhavatIti buddhvA potaM mocayitvA krItyupadvIpasya tIrasamIpena calitavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","kintvalpakSaNAt parameva urakludonnAmA pratikUlaH pracaNDo vAyu rvahan pote'lagIt ");
INSERT INTO sanhk_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","tasyAbhimukhaM gantum potasyAzaktatvAd vayaM vAyunA svayaM nItAH| ");
INSERT INTO sanhk_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","anantaraM klaudInAmna upadvIpasya kUlasamIpena potaM gamayitvA bahunA kaSTena kSudranAvam arakSAma| ");
INSERT INTO sanhk_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","te tAmAruhya rajjcA potasyAdhobhAgam abadhnan tadanantaraM cet poto saikate lagatIti bhayAd vAtavasanAnyamocayan tataH poto vAyunA cAlitaH| ");
INSERT INTO sanhk_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","kintu kramazo vAyoH prabalatvAt poto dolAyamAno'bhavat parasmin divase potasthAni katipayAni dravyANi toye nikSiptAni| ");
INSERT INTO sanhk_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","tRtIyadivase vayaM svahastaiH potasajjanadravyANi nikSiptavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","tato bahudinAni yAvat sUryyanakSatrAdIni samAcchannAni tato 'tIva vAtyAgamAd asmAkaM prANarakSAyAH kApi pratyAzA nAtiSThat| ");
INSERT INTO sanhk_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","bahudineSu lokairanAhAreNa yApiteSu sarvveSAM sAkSat paulastiSThan akathayat, he mahecchAH krItyupadvIpAt potaM na mocayitum ahaM pUrvvaM yad avadaM tadgrahaNaM yuSmAkam ucitam AsIt tathA kRte yuSmAkam eSA vipad eSo'pacayazca nAghaTiSyetAm| ");
INSERT INTO sanhk_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","kintu sAmprataM yuSmAn vinIya bravImyahaM, yUyaM na kSubhyata yuSmAkam ekasyApi prANino hAni rna bhaviSyati, kevalasya potasya hAni rbhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","yato yasyezvarasya loko'haM yaJcAhaM paricarAmi tadIya eko dUto hyo rAtrau mamAntike tiSThan kathitavAn, ");
INSERT INTO sanhk_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","he paula mA bhaiSIH kaisarasya sammukhe tvayopasthAtavyaM; tavaitAn saGgino lokAn IzvarastubhyaM dattavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","ataeva he mahecchA yUyaM sthiramanaso bhavata mahyaM yA kathAkathi sAvazyaM ghaTiSyate mamaitAdRzI vizvAsa Izvare vidyate, ");
INSERT INTO sanhk_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","kintu kasyacid upadvIpasyopari patitavyam asmAbhiH| ");
INSERT INTO sanhk_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","tataH param AdriyAsamudre potastathaiva dolAyamAnaH san itastato gacchan caturdazadivasasya rAtre rdvitIyapraharasamaye kasyacit sthalasya samIpamupatiSThatIti potIyalokA anvamanyanta| ");
INSERT INTO sanhk_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","tataste jalaM parimAya tatra viMzati rvyAmA jalAnIti jJAtavantaH| kiJciddUraM gatvA punarapi jalaM parimitavantaH| tatra paJcadaza vyAmA jalAni dRSTvA ");
INSERT INTO sanhk_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","cet pASANe lagatIti bhayAt potasya pazcAdbhAgatazcaturo laGgarAn nikSipya divAkaram apekSya sarvve sthitavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","kintu potIyalokAH potAgrabhAge laGgaranikSepaM chalaM kRtvA jaladhau kSudranAvam avarohya palAyitum aceSTanta| ");
INSERT INTO sanhk_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","tataH paulaH senApataye sainyagaNAya ca kathitavAn, ete yadi potamadhye na tiSThanti tarhi yuSmAkaM rakSaNaM na zakyaM| ");
INSERT INTO sanhk_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","tadA senAgaNo rajjUn chitvA nAvaM jale patitum adadAt| ");
INSERT INTO sanhk_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","prabhAtasamaye paulaH sarvvAn janAn bhojanArthaM prArthya vyAharat, adya caturdazadinAni yAvad yUyam apekSamAnA anAhArAH kAlam ayApayata kimapi nAbhuMgdhaM| ");
INSERT INTO sanhk_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","ato vinayeे'haM bhakSyaM bhujyatAM tato yuSmAkaM maGgalaM bhaviSyati, yuSmAkaM kasyacijjanasya zirasaH kezaikopi na naMkSyati| ");
INSERT INTO sanhk_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","iti vyAhRtya paulaM pUpaM gRhItvezvaraM dhanyaM bhASamANastaM bhaMktvA bhoktum ArabdhavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","anantaraM sarvve ca susthirAH santaH khAdyAni parpyagRhlan| ");
INSERT INTO sanhk_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","asmAkaM pote SaTsaptatyadhikazatadvayalokA Asan| ");
INSERT INTO sanhk_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","sarvveSu lokeSu yatheSTaM bhuktavatsu potasthan godhUmAn jaladhau nikSipya taiH potasya bhAro laghUkRtaH| ");
INSERT INTO sanhk_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","dine jAte'pi sa ko deza iti tadA na paryyacIyata; kintu tatra samataTam ekaM khAtaM dRSTvA yadi zaknumastarhi vayaM tasyAbhyantaraM potaM gamayAma iti matiM kRtvA te laGgarAn chittvA jaladhau tyaktavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","tathA karNabandhanaM mocayitvA pradhAnaM vAtavasanam uttolya tIrasamIpaM gatavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","kintu dvayoH samudrayoH saGgamasthAne saikatopari pote nikSipte 'grabhAge bAdhite pazcAdbhAge prabalataraGgo'lagat tena poto bhagnaH| ");
INSERT INTO sanhk_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","tasmAd bandayazced bAhubhistarantaH palAyante ityAzaGkayA senAgaNastAn hantum amantrayat; ");
INSERT INTO sanhk_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","kintu zatasenApatiH paulaM rakSituM prayatnaM kRtvA tAn tacceSTAyA nivartya ityAdiSTavAn, ye bAhutaraNaM jAnanti te'gre prollampya samudre patitvA bAhubhistIrttvA kUlaM yAntu| ");
INSERT INTO sanhk_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","aparam avaziSTA janAH kASThaM potIyaM dravyaM vA yena yat prApyate tadavalambya yAntu; itthaM sarvve bhUmiM prApya prANai rjIvitAH| ");
INSERT INTO sanhk_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","itthaM sarvveSu rakSAM prApteSu tatratyopadvIpasya nAma milIteti te jJAtavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","asabhyalokA yatheSTam anukampAM kRtvA varttamAnavRSTeH zItAcca vahniM prajjvAlyAsmAkam Atithyam akurvvan| ");
INSERT INTO sanhk_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","kintu paula indhanAni saMgRhya yadA tasmin agrau nirakSipat, tadA vahneH pratApAt ekaH kRSNasarpo nirgatya tasya haste draSTavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","te'sabhyalokAstasya haste sarpam avalambamAnaM dRSTvA parasparam uktavanta eSa jano'vazyaM narahA bhaviSyati, yato yadyapi jaladhe rakSAM prAptavAn tathApi pratiphaladAyaka enaM jIvituM na dadAti| ");
INSERT INTO sanhk_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","kintu sa hastaM vidhunvan taM sarpam agnimadhye nikSipya kAmapi pIDAM nAptavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","tato viSajvAlayA etasya zarIraM sphItaM bhaviSyati yadvA haThAdayaM prANAn tyakSyatIti nizcitya lokA bahukSaNAni yAvat tad draSTuM sthitavantaH kintu tasya kasyAzcid vipado'ghaTanAt te tadviparItaM vijJAya bhASitavanta eSa kazcid devo bhavet| ");
INSERT INTO sanhk_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","publiyanAmA jana ekastasyopadvIpasyAdhipatirAsIt tatra tasya bhUmyAdi ca sthitaM| sa jano'smAn nijagRhaM nItvA saujanyaM prakAzya dinatrayaM yAvad asmAkaM Atithyam akarot| ");
INSERT INTO sanhk_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","tadA tasya publiyasya pitA jvarAtisAreNa pIDyamAnaH san zayyAyAm AsIt; tataH paulastasya samIpaM gatvA prArthanAM kRtvA tasya gAtre hastaM samarpya taM svasthaM kRtavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","itthaM bhUte tadvIpanivAsina itarepi rogilokA Agatya nirAmayA abhavan| ");
INSERT INTO sanhk_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","tasmAtte'smAkam atIva satkAraM kRtavantaH, vizeSataH prasthAnasamaye prayojanIyAni nAnadravyANi dattavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","itthaM tatra triSu mAseSu gateSu yasya cihnaM diyaskUrI tAdRza ekaH sikandarIyanagarasya potaH zItakAlaM yApayan tasmin upadvIpe 'tiSThat tameva potaM vayam Aruhya yAtrAm akurmma| ");
INSERT INTO sanhk_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","tataH prathamataH surAkUsanagaram upasthAya tatra trINi dinAni sthitavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","tasmAd AvRtya rIgiyanagaram upasthitAH dinaikasmAt paraM dakSiNavayau sAnukUlye sati parasmin divase patiyalInagaram upAtiSThAma| ");
INSERT INTO sanhk_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","tato'smAsu tatratyaM bhrAtRgaNaM prApteSu te svaiH sArddham asmAn sapta dinAni sthApayitum ayatanta, itthaM vayaM romAnagaram pratyagacchAma| ");
INSERT INTO sanhk_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","tasmAt tatratyAH bhrAtaro'smAkam AgamanavArttAM zrutvA AppiyapharaM triSTAvarNIJca yAvad agresarAH santosmAn sAkSAt karttum Agaman; teSAM darzanAt paula IzvaraM dhanyaM vadan AzvAsam AptavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","asmAsu romAnagaraM gateSu zatasenApatiH sarvvAn bandIn pradhAnasenApateH samIpe samArpayat kintu paulAya svarakSakapadAtinA saha pRthag vastum anumatiM dattavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","dinatrayAt paraM paulastaddezasthAn pradhAnayihUdina AhUtavAn tatasteSu samupasthiteSu sa kathitavAn, he bhrAtRgaNa nijalokAnAM pUrvvapuruSANAM vA rIte rviparItaM kiJcana karmmAhaM nAkaravaM tathApi yirUzAlamanivAsino lokA mAM bandiM kRtvA romilokAnAM hasteSu samarpitavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","romilokA vicAryya mama prANahananArhaM kimapi kAraNaM na prApya mAM mocayitum aicchan; ");
INSERT INTO sanhk_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","kintu yihUdilokAnAm ApattyA mayA kaisararAjasya samIpe vicArasya prArthanA karttavyA jAtA nocet nijadezIyalokAn prati mama kopyabhiyogo nAsti| ");
INSERT INTO sanhk_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","etatkAraNAd ahaM yuSmAn draSTuM saMlapituJcAhUyam isrAyelvazIyAnAM pratyAzAhetoham etena zuGkhalena baddho'bhavam| ");
INSERT INTO sanhk_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","tadA te tam avAdiSuH, yihUdIyadezAd vayaM tvAmadhi kimapi patraM na prAptA ye bhrAtaraH samAyAtAsteSAM kopi tava kAmapi vArttAM nAvadat abhadramapi nAkathayacca| ");
INSERT INTO sanhk_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","tava mataM kimiti vayaM tvattaH zrotumicchAmaH| yad idaM navInaM matamutthitaM tat sarvvatra sarvveSAM nikaTe ninditaM jAtama iti vayaM jAnImaH| ");
INSERT INTO sanhk_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","taistadartham ekasmin dine nirUpite tasmin dine bahava ekatra militvA paulasya vAsagRham Agacchan tasmAt paula A prAtaHkAlAt sandhyAkAlaM yAvan mUsAvyavasthAgranthAd bhaviSyadvAdinAM granthebhyazca yIzoH kathAm utthApya Izvarasya rAjye pramANaM datvA teSAM pravRttiM janayituM ceSTitavAn| ");
INSERT INTO sanhk_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","kecittu tasya kathAM pratyAyan kecittu na pratyAyan; ");
INSERT INTO sanhk_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","etatkAraNAt teSAM parasparam anaikyAt sarvve calitavantaH; tathApi paula etAM kathAmekAM kathitavAn pavitra AtmA yizayiyasya bhaviSyadvaktu rvadanAd asmAkaM pitRpuruSebhya etAM kathAM bhadraM kathayAmAsa, yathA, ");
INSERT INTO sanhk_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","\"upagatya janAnetAn tvaM bhASasva vacastvidaM| karNaiH zroSyatha yUyaM hi kintu yUyaM na bhotsyatha| netrai rdrakSyatha yUyaJca jJAtuM yUyaM na zakSyatha| ");
INSERT INTO sanhk_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","te mAnuSA yathA netraiH paripazyanti naiva hi| karNaiH ryathA na zRNvanti budhyante na ca mAnasaiH| vyAvarttayatsu cittAni kAle kutrApi teSu vai| mattaste manujAH svasthA yathA naiva bhavanti ca| tathA teSAM manuSyANAM santi sthUlA hi buddhayaH| badhirIbhUtakarNAzca jAtAzca mudritA dRzaH|| ");
INSERT INTO sanhk_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","ata IzvarAd yat paritrANaM tasya vArttA bhinnadezIyAnAM samIpaM preSitA taeva tAM grahISyantIti yUyaM jAnIta| ");
INSERT INTO sanhk_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","etAdRzyAM kathAyAM kathitAyAM satyAM yihUdinaH parasparaM bahuvicAraM kurvvanto gatavantaH| ");
INSERT INTO sanhk_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","itthaM paulaH sampUrNaM vatsaradvayaM yAvad bhATakIye vAsagRhe vasan ye lokAstasya sannidhim Agacchanti tAn sarvvAneva parigRhlan, ");
INSERT INTO sanhk_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","nirvighnam atizayaniHkSobham IzvarIyarAjatvasya kathAM pracArayan prabhau yIzau khrISTe kathAH samupAdizat| iti||");
INSERT INTO sanhk_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Izvaro nijaputramadhi yaM susaMvAdaM bhaviSyadvAdibhi rdharmmagranthe pratizrutavAn taM susaMvAdaM pracArayituM pRthakkRta AhUtaH preritazca prabho ryIzukhrISTasya sevako yaH paulaH ");
INSERT INTO sanhk_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","sa romAnagarasthAn IzvarapriyAn AhUtAMzca pavitralokAn prati patraM likhati| ");
INSERT INTO sanhk_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","asmAkaM sa prabhu ryIzuH khrISTaH zArIrikasambandhena dAyUdo vaMzodbhavaH ");
INSERT INTO sanhk_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","pavitrasyAtmanaH sambandhena cezvarasya prabhAvavAn putra iti zmazAnAt tasyotthAnena pratipannaM| ");
INSERT INTO sanhk_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","aparaM yeSAM madhye yIzunA khrISTena yUyamapyAhUtAste 'nyadezIyalokAstasya nAmni vizvasya nidezagrAhiNo yathA bhavanti ");
INSERT INTO sanhk_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","tadabhiprAyeNa vayaM tasmAd anugrahaM preritatvapadaJca prAptAH| ");
INSERT INTO sanhk_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","tAtenAsmAkam IzvareNa prabhuNA yIzukhrISTena ca yuSmabhyam anugrahaH zAntizca pradIyetAM| ");
INSERT INTO sanhk_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","prathamataH sarvvasmin jagati yuSmAkaM vizvAsasya prakAzitatvAd ahaM yuSmAkaM sarvveSAM nimittaM yIzukhrISTasya nAma gRhlan Izvarasya dhanyavAdaM karomi| ");
INSERT INTO sanhk_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","aparam Izvarasya prasAdAd bahukAlAt paraM sAmprataM yuSmAkaM samIpaM yAtuM kathamapi yat suyogaM prApnomi, etadarthaM nirantaraM nAmAnyuccArayan nijAsu sarvvaprArthanAsu sarvvadA nivedayAmi, ");
INSERT INTO sanhk_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","etasmin yamahaM tatputrIyasusaMvAdapracAraNena manasA paricarAmi sa Izvaro mama sAkSI vidyate| ");
INSERT INTO sanhk_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","yato yuSmAkaM mama ca vizvAsena vayam ubhaye yathA zAntiyuktA bhavAma iti kAraNAd ");
INSERT INTO sanhk_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","yuSmAkaM sthairyyakaraNArthaM yuSmabhyaM kiJcitparamArthadAnadAnAya yuSmAn sAkSAt karttuM madIyA vAJchA| ");
INSERT INTO sanhk_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","he bhrAtRgaNa bhinnadezIyalokAnAM madhye yadvat tadvad yuSmAkaM madhyepi yathA phalaM bhuJje tadabhiprAyeNa muhurmuhu ryuSmAkaM samIpaM gantum udyato'haM kintu yAvad adya tasmin gamane mama vighno jAta iti yUyaM yad ajJAtAstiSThatha tadaham ucitaM na budhye| ");
INSERT INTO sanhk_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","ahaM sabhyAsabhyAnAM vidvadavidvatAJca sarvveSAm RNI vidye| ");
INSERT INTO sanhk_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","ataeva romAnivAsinAM yuSmAkaM samIpe'pi yathAzakti susaMvAdaM pracArayitum aham udyatosmi| ");
INSERT INTO sanhk_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","yataH khrISTasya susaMvAdo mama lajjAspadaM nahi sa Izvarasya zaktisvarUpaH san A yihUdIyebhyo 'nyajAtIyAn yAvat sarvvajAtIyAnAM madhye yaH kazcid tatra vizvasiti tasyaiva trANaM janayati| ");
INSERT INTO sanhk_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","yataH pratyayasya samaparimANam IzvaradattaM puNyaM tatsusaMvAde prakAzate| tadadhi dharmmapustakepi likhitamidaM \"puNyavAn jano vizvAsena jIviSyati\"| ");
INSERT INTO sanhk_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","ataeva ye mAnavAH pApakarmmaNA satyatAM rundhanti teSAM sarvvasya durAcaraNasyAdharmmasya ca viruddhaM svargAd Izvarasya kopaH prakAzate| ");
INSERT INTO sanhk_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","yata Izvaramadhi yadyad jJeyaM tad IzvaraH svayaM tAn prati prakAzitavAn tasmAt teSAm agocaraM nahi| ");
INSERT INTO sanhk_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","phalatastasyAnantazaktIzvaratvAdInyadRzyAnyapi sRSTikAlam Arabhya karmmasu prakAzamAnAni dRzyante tasmAt teSAM doSaprakSAlanasya panthA nAsti| ");
INSERT INTO sanhk_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","aparam IzvaraM jJAtvApi te tam IzvarajJAnena nAdriyanta kRtajJA vA na jAtAH; tasmAt teSAM sarvve tarkA viphalIbhUtAH, aparaJca teSAM vivekazUnyAni manAMsi timire magnAni| ");
INSERT INTO sanhk_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","te svAn jJAnino jJAtvA jJAnahInA abhavan ");
INSERT INTO sanhk_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","anazvarasyezvarasya gauravaM vihAya nazvaramanuSyapazupakSyurogAmiprabhRterAkRtiviziSTapratimAstairAzritAH| ");
INSERT INTO sanhk_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","itthaM ta Izvarasya satyatAM vihAya mRSAmatam AzritavantaH saccidAnandaM sRSTikarttAraM tyaktvA sRSTavastunaH pUjAM sevAJca kRtavantaH; ");
INSERT INTO sanhk_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","iti hetorIzvarastAn kukriyAyAM samarpya nijanijakucintAbhilASAbhyAM svaM svaM zarIraM parasparam apamAnitaM karttum adadAt| ");
INSERT INTO sanhk_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","IzvareNa teSu kvabhilASe samarpiteSu teSAM yoSitaH svAbhAvikAcaraNam apahAya viparItakRtye prAvarttanta; ");
INSERT INTO sanhk_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","tathA puruSA api svAbhAvikayoSitsaGgamaM vihAya parasparaM kAmakRzAnunA dagdhAH santaH pumAMsaH puMbhiH sAkaM kukRtye samAsajya nijanijabhrAnteH samucitaM phalam alabhanta| ");
INSERT INTO sanhk_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","te sveSAM manaHsvIzvarAya sthAnaM dAtum anicchukAstato hetorIzvarastAn prati duSTamanaskatvam avihitakriyatvaJca dattavAn| ");
INSERT INTO sanhk_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","ataeva te sarvve 'nyAyo vyabhicAro duSTatvaM lobho jighAMsA IrSyA vadho vivAdazcAturI kumatirityAdibhi rduSkarmmabhiH paripUrNAH santaH ");
INSERT INTO sanhk_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","karNejapA apavAdina IzvaradveSakA hiMsakA ahaGkAriNa AtmazlAghinaH kukarmmotpAdakAH pitrorAjJAlaGghakA ");
INSERT INTO sanhk_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","avicArakA niyamalaGghinaH sneharahitA atidveSiNo nirdayAzca jAtAH| ");
INSERT INTO sanhk_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","ye janA etAdRzaM karmma kurvvanti taeva mRtiyogyA Izvarasya vicAramIdRzaM jJAtvApi ta etAdRzaM karmma svayaM kurvvanti kevalamiti nahi kintu tAdRzakarmmakAriSu lokeSvapi prIyante| ");
INSERT INTO sanhk_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","he paradUSaka manuSya yaH kazcana tvaM bhavasi tavottaradAnAya panthA nAsti yato yasmAt karmmaNaH parastvayA dUSyate tasmAt tvamapi dUSyase, yatastaM dUSayannapi tvaM tadvad Acarasi| ");
INSERT INTO sanhk_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","kintvetAdRgAcAribhyo yaM daNDam Izvaro nizcinoti sa yathArtha iti vayaM jAnImaH| ");
INSERT INTO sanhk_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","ataeva he mAnuSa tvaM yAdRgAcAriNo dUSayasi svayaM yadi tAdRgAcarasi tarhi tvam IzvaradaNDAt palAyituM zakSyasIti kiM budhyase? ");
INSERT INTO sanhk_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","aparaM tava manasaH parivarttanaM karttum izvarasyAnugraho bhavati tanna buddhvA tvaM kiM tadIyAnugrahakSamAcirasahiSNutvanidhiM tucchIkaroSi? ");
INSERT INTO sanhk_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","tathA svAntaHkaraNasya kaThoratvAt khedarAhityAccezvarasya nyAyyavicAraprakAzanasya krodhasya ca dinaM yAvat kiM svArthaM kopaM saJcinoSi? ");
INSERT INTO sanhk_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","kintu sa ekaikamanujAya tatkarmmAnusAreNa pratiphalaM dAsyati; ");
INSERT INTO sanhk_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","vastutastu ye janA dhairyyaM dhRtvA satkarmma kurvvanto mahimA satkAro'maratvaJcaitAni mRgayante tebhyo'nantAyu rdAsyati| ");
INSERT INTO sanhk_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","aparaM ye janAH satyadharmmam agRhItvA viparItadharmmam gRhlanti tAdRzA virodhijanAH kopaM krodhaJca bhokSyante| ");
INSERT INTO sanhk_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","A yihUdino'nyadezinaH paryyantaM yAvantaH kukarmmakAriNaH prANinaH santi te sarvve duHkhaM yAtanAJca gamiSyanti; ");
INSERT INTO sanhk_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","kintu A yihUdino bhinnadeziparyyantA yAvantaH satkarmmakAriNo lokAH santi tAn prati mahimA satkAraH zAntizca bhaviSyanti| ");
INSERT INTO sanhk_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Izvarasya vicAre pakSapAto nAsti| ");
INSERT INTO sanhk_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","alabdhavyavasthAzAstrai ryaiH pApAni kRtAni vyavasthAzAstrAlabdhatvAnurUpasteSAM vinAzo bhaviSyati; kintu labdhavyavasthAzAstrA ye pApAnyakurvvan vyavasthAnusArAdeva teSAM vicAro bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","vyavasthAzrotAra Izvarasya samIpe niSpApA bhaviSyantIti nahi kintu vyavasthAcAriNa eva sapuNyA bhaviSyanti| ");
INSERT INTO sanhk_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","yato 'labdhavyavasthAzAstrA bhinnadezIyalokA yadi svabhAvato vyavasthAnurUpAn AcArAn kurvvanti tarhyalabdhazAstrAH santo'pi te sveSAM vyavasthAzAstramiva svayameva bhavanti| ");
INSERT INTO sanhk_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","teSAM manasi sAkSisvarUpe sati teSAM vitarkeSu ca kadA tAn doSiNaH kadA vA nirdoSAn kRtavatsu te svAntarlikhitasya vyavasthAzAstrasya pramANaM svayameva dadati| ");
INSERT INTO sanhk_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","yasmin dine mayA prakAzitasya susaMvAdasyAnusArAd Izvaro yIzukhrISTena mAnuSANAm antaHkaraNAnAM gUDhAbhiprAyAn dhRtvA vicArayiSyati tasmin vicAradine tat prakAziSyate| ");
INSERT INTO sanhk_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","pazya tvaM svayaM yihUdIti vikhyAto vyavasthopari vizvAsaM karoSi, ");
INSERT INTO sanhk_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Izvaramuddizya svaM zlAghase, tathA vyavasthayA zikSito bhUtvA tasyAbhimataM jAnAsi, sarvvAsAM kathAnAM sAraM viviMkSe, ");
INSERT INTO sanhk_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","aparaM jJAnasya satyatAyAzcAkarasvarUpaM zAstraM mama samIpe vidyata ato 'ndhalokAnAM mArgadarzayitA ");
INSERT INTO sanhk_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","timirasthitalokAnAM madhye dIptisvarUpo'jJAnalokebhyo jJAnadAtA zizUnAM zikSayitAhameveti manyase| ");
INSERT INTO sanhk_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","parAn zikSayan svayaM svaM kiM na zikSayasi? vastutazcauryyaniSedhavyavasthAM pracArayan tvaM kiM svayameva corayasi? ");
INSERT INTO sanhk_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","tathA paradAragamanaM pratiSedhan svayaM kiM paradArAn gacchasi? tathA tvaM svayaM pratimAdveSI san kiM mandirasya dravyANi harasi? ");
INSERT INTO sanhk_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","yastvaM vyavasthAM zlAghase sa tvaM kiM vyavasthAm avamatya nezvaraM sammanyase? ");
INSERT INTO sanhk_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","zAstre yathA likhati \"bhinnadezinAM samIpe yuSmAkaM doSAd Izvarasya nAmno nindA bhavati|\" ");
INSERT INTO sanhk_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","yadi vyavasthAM pAlayasi tarhi tava tvakchedakriyA saphalA bhavati; yati vyavasthAM laGghase tarhi tava tvakchedo'tvakchedo bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","yato vyavasthAzAstrAdiSTadharmmakarmmAcArI pumAn atvakchedI sannapi kiM tvakchedinAM madhye na gaNayiSyate? ");
INSERT INTO sanhk_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","kintu labdhazAstrazchinnatvak ca tvaM yadi vyavasthAlaGghanaM karoSi tarhi vyavasthApAlakAH svAbhAvikAcchinnatvaco lokAstvAM kiM na dUSayiSyanti? ");
INSERT INTO sanhk_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","tasmAd yo bAhye yihUdI sa yihUdI nahi tathAGgasya yastvakchedaH sa tvakchedo nahi; ");
INSERT INTO sanhk_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","kintu yo jana Antariko yihUdI sa eva yihUdI aparaJca kevalalikhitayA vyavasthayA na kintu mAnasiko yastvakchedo yasya ca prazaMsA manuSyebhyo na bhUtvA IzvarAd bhavati sa eva tvakchedaH| ");
INSERT INTO sanhk_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","aparaJca yihUdinaH kiM zreSThatvaM? tathA tvakchedasya vA kiM phalaM? ");
INSERT INTO sanhk_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","sarvvathA bahUni phalAni santi, vizeSata Izvarasya zAstraM tebhyo'dIyata| ");
INSERT INTO sanhk_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","kaizcid avizvasane kRte teSAm avizvasanAt kim Izvarasya vizvAsyatAyA hAnirutpatsyate? ");
INSERT INTO sanhk_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","kenApi prakAreNa nahi| yadyapi sarvve manuSyA mithyAvAdinastathApIzvaraH satyavAdI| zAstre yathA likhitamAste, atastvantu svavAkyena nirddoSo hi bhaviSyasi| vicAre caiva niSpApo bhaviSyasi na saMzayaH| ");
INSERT INTO sanhk_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","asmAkam anyAyena yadIzvarasya nyAyaH prakAzate tarhi kiM vadiSyAmaH? ahaM mAnuSANAM kathAmiva kathAM kathayAmi, IzvaraH samucitaM daNDaM dattvA kim anyAyI bhaviSyati? ");
INSERT INTO sanhk_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","itthaM na bhavatu, tathA satIzvaraH kathaM jagato vicArayitA bhaviSyati? ");
INSERT INTO sanhk_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","mama mithyAvAkyavadanAd yadIzvarasya satyatvena tasya mahimA varddhate tarhi kasmAdahaM vicAre'parAdhitvena gaNyo bhavAmi? ");
INSERT INTO sanhk_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","maGgalArthaM pApamapi karaNIyamiti vAkyaM tvayA kuto nocyate? kintu yairucyate te nitAntaM daNDasya pAtrANi bhavanti; tathApi tadvAkyam asmAbhirapyucyata ityasmAkaM glAniM kurvvantaH kiyanto lokA vadanti| ");
INSERT INTO sanhk_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","anyalokebhyo vayaM kiM zreSThAH? kadAcana nahi yato yihUdino 'nyadezinazca sarvvaeva pApasyAyattA ityasya pramANaM vayaM pUrvvam adadAma| ");
INSERT INTO sanhk_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","lipi ryathAste, naikopi dhArmmiko janaH| ");
INSERT INTO sanhk_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","tathA jJAnIzvarajJAnI mAnavaH kopi nAsti hi| ");
INSERT INTO sanhk_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","vimArgagAminaH sarvve sarvve duSkarmmakAriNaH| eko janopi no teSAM sAdhukarmma karoti ca| ");
INSERT INTO sanhk_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","tathA teSAntu vai kaNThA anAvRtazmazAnavat| stutivAdaM prakurvvanti jihvAbhiste tu kevalaM| teSAmoSThasya nimne tu viSaM tiSThati sarppavat| ");
INSERT INTO sanhk_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","mukhaM teSAM hi zApena kapaTena ca pUryyate| ");
INSERT INTO sanhk_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","raktapAtAya teSAM tu padAni kSipragAni ca| ");
INSERT INTO sanhk_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","pathi teSAM manuSyANAM nAzaH klezazca kevalaH| ");
INSERT INTO sanhk_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","te janA nahi jAnanti panthAnaM sukhadAyinaM| ");
INSERT INTO sanhk_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","paramezAd bhayaM yattat taccakSuSoragocaraM| ");
INSERT INTO sanhk_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","vyavasthAyAM yadyallikhati tad vyavasthAdhInAn lokAn uddizya likhatIti vayaM jAnImaH| tato manuSyamAtro niruttaraH san Izvarasya sAkSAd aparAdhI bhavati| ");
INSERT INTO sanhk_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","ataeva vyavasthAnurUpaiH karmmabhiH kazcidapi prANIzvarasya sAkSAt sapuNyIkRto bhavituM na zakSyati yato vyavasthayA pApajJAnamAtraM jAyate| ");
INSERT INTO sanhk_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","kintu vyavasthAyAH pRthag IzvareNa deyaM yat puNyaM tad vyavasthAyA bhaviSyadvAdigaNasya ca vacanaiH pramANIkRtaM sad idAnIM prakAzate| ");
INSERT INTO sanhk_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","yIzukhrISTe vizvAsakaraNAd IzvareNa dattaM tat puNyaM sakaleSu prakAzitaM sat sarvvAn vizvAsinaH prati varttate| ");
INSERT INTO sanhk_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","teSAM kopi prabhedo nAsti, yataH sarvvaeva pApina IzvarIyatejohInAzca jAtAH| ");
INSERT INTO sanhk_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","ta IzvarasyAnugrahAd mUlyaM vinA khrISTakRtena paritrANena sapuNyIkRtA bhavanti| ");
INSERT INTO sanhk_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","yasmAt svazoNitena vizvAsAt pApanAzako balI bhavituM sa eva pUrvvam IzvareNa nizcitaH, ittham IzvarIyasahiSNutvAt purAkRtapApAnAM mArjjanakaraNe svIyayAthArthyaM tena prakAzyate, ");
INSERT INTO sanhk_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","varttamAnakAlIyamapi svayAthArthyaM tena prakAzyate, aparaM yIzau vizvAsinaM sapuNyIkurvvannapi sa yAthArthikastiSThati| ");
INSERT INTO sanhk_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","tarhi kutrAtmazlAghA? sA dUrIkRtA; kayA vyavasthayA? kiM kriyArUpavyavasthayA? itthaM nahi kintu tat kevalavizvAsarUpayA vyavasthayaiva bhavati| ");
INSERT INTO sanhk_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","ataeva vyavasthAnurUpAH kriyA vinA kevalena vizvAsena mAnavaH sapuNyIkRto bhavituM zaknotItyasya rAddhAntaM darzayAmaH| ");
INSERT INTO sanhk_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","sa kiM kevalayihUdinAm Izvaro bhavati? bhinnadezinAm Izvaro na bhavati? bhinnadezinAmapi bhavati; ");
INSERT INTO sanhk_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","yasmAd eka Izvaro vizvAsAt tvakchedino vizvAsenAtvakchedinazca sapuNyIkariSyati| ");
INSERT INTO sanhk_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","tarhi vizvAsena vayaM kiM vyavasthAM lumpAma? itthaM na bhavatu vayaM vyavasthAM saMsthApayAma eva| ");
INSERT INTO sanhk_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","asmAkaM pUrvvapuruSa ibrAhIm kAyikakriyayA kiM labdhavAn etadadhi kiM vadiSyAmaH? ");
INSERT INTO sanhk_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","sa yadi nijakriyAbhyaH sapuNyo bhavet tarhi tasyAtmazlAghAM karttuM panthA bhavediti satyaM, kintvIzvarasya samIpe nahi| ");
INSERT INTO sanhk_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","zAstre kiM likhati? ibrAhIm Izvare vizvasanAt sa vizvAsastasmai puNyArthaM gaNito babhUva| ");
INSERT INTO sanhk_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","karmmakAriNo yad vetanaM tad anugrahasya phalaM nahi kintu tenopArjitaM mantavyam| ");
INSERT INTO sanhk_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","kintu yaH pApinaM sapuNyIkaroti tasmin vizvAsinaH karmmahInasya janasya yo vizvAsaH sa puNyArthaM gaNyo bhavati| ");
INSERT INTO sanhk_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","aparaM yaM kriyAhInam IzvaraH sapuNyIkaroti tasya dhanyavAdaM dAyUd varNayAmAsa, yathA, ");
INSERT INTO sanhk_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","sa dhanyo'ghAni mRSTAni yasyAgAMsyAvRtAni ca| ");
INSERT INTO sanhk_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","sa ca dhanyaH parezena pApaM yasya na gaNyate| ");
INSERT INTO sanhk_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","eSa dhanyavAdastvakchedinam atvakchedinaM vA kaM prati bhavati? ibrAhImo vizvAsaH puNyArthaM gaNita iti vayaM vadAmaH| ");
INSERT INTO sanhk_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","sa vizvAsastasya tvakcheditvAvasthAyAM kim atvakcheditvAvasthAyAM kasmin samaye puNyamiva gaNitaH? tvakcheditvAvasthAyAM nahi kintvatvakcheditvAvasthAyAM| ");
INSERT INTO sanhk_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","aparaJca sa yat sarvveSAm atvakchedinAM vizvAsinAm AdipuruSo bhavet, te ca puNyavattvena gaNyeran; ");
INSERT INTO sanhk_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","ye ca lokAH kevalaM chinnatvaco na santo 'smatpUrvvapuruSa ibrAhIm achinnatvak san yena vizvAsamArgeNa gatavAn tenaiva tasya pAdacihnena gacchanti teSAM tvakchedinAmapyAdipuruSo bhavet tadartham atvakchedino mAnavasya vizvAsAt puNyam utpadyata iti pramANasvarUpaM tvakchedacihnaM sa prApnot| ");
INSERT INTO sanhk_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","ibrAhIm jagato'dhikArI bhaviSyati yaiSA pratijJA taM tasya vaMzaJca prati pUrvvam akriyata sA vyavasthAmUlikA nahi kintu vizvAsajanyapuNyamUlikA| ");
INSERT INTO sanhk_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","yato vyavasthAvalambino yadyadhikAriNo bhavanti tarhi vizvAso viphalo jAyate sA pratijJApi luptaiva| ");
INSERT INTO sanhk_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","adhikantu vyavasthA kopaM janayati yato 'vidyamAnAyAM vyavasthAyAm AjJAlaGghanaM na sambhavati| ");
INSERT INTO sanhk_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","ataeva sA pratijJA yad anugrahasya phalaM bhavet tadarthaM vizvAsamUlikA yatastathAtve tadvaMzasamudAyaM prati arthato ye vyavasthayA tadvaMzasambhavAH kevalaM tAn prati nahi kintu ya ibrAhImIyavizvAsena tatsambhavAstAnapi prati sA pratijJA sthAsnurbhavati| ");
INSERT INTO sanhk_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","yo nirjIvAn sajIvAn avidyamAnAni vastUni ca vidyamAnAni karoti ibrAhImo vizvAsabhUmestasyezvarasya sAkSAt so'smAkaM sarvveSAm AdipuruSa Aste, yathA likhitaM vidyate, ahaM tvAM bahujAtInAm AdipuruSaM kRtvA niyuktavAn| ");
INSERT INTO sanhk_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","tvadIyastAdRzo vaMzo janiSyate yadidaM vAkyaM pratizrutaM tadanusArAd ibrAhIm bahudezIyalokAnAm AdipuruSo yad bhavati tadarthaM so'napekSitavyamapyapekSamANo vizvAsaM kRtavAn| ");
INSERT INTO sanhk_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","aparaJca kSINavizvAso na bhUtvA zatavatsaravayaskatvAt svazarIrasya jarAM sArAnAmnaH svabhAryyAyA rajonivRttiJca tRNAya na mene| ");
INSERT INTO sanhk_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","aparam avizvAsAd Izvarasya pratijJAvacane kamapi saMzayaM na cakAra; ");
INSERT INTO sanhk_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","kintvIzvareNa yat pratizrutaM tat sAdhayituM zakyata iti nizcitaM vijJAya dRDhavizvAsaH san Izvarasya mahimAnaM prakAzayAJcakAra| ");
INSERT INTO sanhk_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","iti hetostasya sa vizvAsastadIyapuNyamiva gaNayAJcakre| ");
INSERT INTO sanhk_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","puNyamivAgaNyata tat kevalasya tasya nimittaM likhitaM nahi, asmAkaM nimittamapi, ");
INSERT INTO sanhk_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","yato'smAkaM pApanAzArthaM samarpito'smAkaM puNyaprAptyarthaJcotthApito'bhavat yo'smAkaM prabhu ryIzustasyotthApayitarIzvare ");
INSERT INTO sanhk_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","yadi vayaM vizvasAmastarhyasmAkamapi saeva vizvAsaH puNyamiva gaNayiSyate| ");
INSERT INTO sanhk_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","vizvAsena sapuNyIkRtA vayam IzvareNa sArddhaM prabhuNAsmAkaM yIzukhrISTena melanaM prAptAH| ");
INSERT INTO sanhk_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","aparaM vayaM yasmin anugrahAzraye tiSThAmastanmadhyaM vizvAsamArgeNa tenaivAnItA vayam IzvarIyavibhavaprAptipratyAzayA samAnandAmaH| ");
INSERT INTO sanhk_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","tat kevalaM nahi kintu klezabhoge'pyAnandAmo yataH klezAाd dhairyyaM jAyata iti vayaM jAnImaH, ");
INSERT INTO sanhk_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","dhairyyAcca parIkSitatvaM jAyate, parIkSitatvAt pratyAzA jAyate, ");
INSERT INTO sanhk_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","pratyAzAto vrIDitatvaM na jAyate, yasmAd asmabhyaM dattena pavitreNAtmanAsmAkam antaHkaraNAnIzvarasya premavAriNA siktAni| ");
INSERT INTO sanhk_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","asmAsu nirupAyeSu satsu khrISTa upayukte samaye pApinAM nimittaM svIyAn praNAn atyajat| ");
INSERT INTO sanhk_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","hitakAriNo janasya kRte kopi praNAn tyaktuM sAhasaM karttuM zaknoti, kintu dhArmmikasya kRte prAyeNa kopi prANAn na tyajati| ");
INSERT INTO sanhk_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","kintvasmAsu pApiSu satsvapi nimittamasmAkaM khrISTaH svaprANAn tyaktavAn, tata IzvarosmAn prati nijaM paramapremANaM darzitavAn| ");
INSERT INTO sanhk_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","ataeva tasya raktapAtena sapuNyIkRtA vayaM nitAntaM tena kopAd uddhAriSyAmahe| ");
INSERT INTO sanhk_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","phalato vayaM yadA ripava Asma tadezvarasya putrasya maraNena tena sArddhaM yadyasmAkaM melanaM jAtaM tarhi melanaprAptAH santo'vazyaM tasya jIvanena rakSAM lapsyAmahe| ");
INSERT INTO sanhk_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","tat kevalaM nahi kintu yena melanam alabhAmahi tenAsmAkaM prabhuNA yIzukhrISTena sAmpratam Izvare samAnandAmazca| ");
INSERT INTO sanhk_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","tathA sati, ekena mAnuSeNa pApaM pApena ca maraNaM jagatIM prAvizat aparaM sarvveSAM pApitvAt sarvve mAnuSA mRte rnighnA abhavat| ");
INSERT INTO sanhk_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","yato vyavasthAdAnasamayaM yAvat jagati pApam AsIt kintu yatra vyavasthA na vidyate tatra pApasyApi gaNanA na vidyate| ");
INSERT INTO sanhk_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","tathApyAdamA yAdRzaM pApaM kRtaM tAdRzaM pApaM yai rnAkAri Adamam Arabhya mUsAM yAvat teSAmapyupari mRtyU rAjatvam akarot sa Adam bhAvyAdamo nidarzanamevAste| ");
INSERT INTO sanhk_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","kintu pApakarmmaNo yAdRzo bhAvastAdRg dAnakarmmaNo bhAvo na bhavati yata ekasya janasyAparAdhena yadi bahUnAM maraNam aghaTata tathApIzvarAnugrahastadanugrahamUlakaM dAnaJcaikena janenArthAd yIzunA khrISTena bahuSu bAhulyAtibAhulyena phalati| ");
INSERT INTO sanhk_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","aparam ekasya janasya pApakarmma yAdRk phalayuktaM dAnakarmma tAdRk na bhavati yato vicArakarmmaikaM pApam Arabhya daNDajanakaM babhUva, kintu dAnakarmma bahupApAnyArabhya puNyajanakaM babhUva| ");
INSERT INTO sanhk_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","yata ekasya janasya pApakarmmatastenaikena yadi maraNasya rAjatvaM jAtaM tarhi ye janA anugrahasya bAhulyaM puNyadAnaJca prApnuvanti ta ekena janena, arthAt yIzukhrISTena, jIvane rAjatvam avazyaM kariSyanti| ");
INSERT INTO sanhk_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","eko'parAdho yadvat sarvvamAnavAnAM daNDagAmI mArgo 'bhavat tadvad ekaM puNyadAnaM sarvvamAnavAnAM jIvanayuktapuNyagAmI mArga eva| ");
INSERT INTO sanhk_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","aparam ekasya janasyAjJAlaGghanAd yathA bahavo 'parAdhino jAtAstadvad ekasyAjJAcaraNAd bahavaH sapuNyIkRtA bhavanti| ");
INSERT INTO sanhk_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","adhikantu vyavasthAgamanAd aparAdhasya bAhulyaM jAtaM kintu yatra pApasya bAhulyaM tatraiva tasmAd anugrahasya bAhulyam abhavat| ");
INSERT INTO sanhk_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","tena mRtyunA yadvat pApasya rAjatvam abhavat tadvad asmAkaM prabhuyIzukhrISTadvArAnantajIvanadAyipuNyenAnugrahasya rAjatvaM bhavati| ");
INSERT INTO sanhk_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","prabhUtarUpeNa yad anugrahaH prakAzate tadarthaM pApe tiSThAma iti vAkyaM kiM vayaM vadiSyAmaH? tanna bhavatu| ");
INSERT INTO sanhk_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","pApaM prati mRtA vayaM punastasmin katham jIviSyAmaH? ");
INSERT INTO sanhk_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","vayaM yAvanto lokA yIzukhrISTe majjitA abhavAma tAvanta eva tasya maraNe majjitA iti kiM yUyaM na jAnItha? ");
INSERT INTO sanhk_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","tato yathA pituH parAkrameNa zmazAnAt khrISTa utthApitastathA vayamapi yat nUtanajIvina ivAcarAmastadarthaM majjanena tena sArddhaM mRtyurUpe zmazAne saMsthApitAH| ");
INSERT INTO sanhk_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","aparaM vayaM yadi tena saMyuktAH santaH sa iva maraNabhAgino jAtAstarhi sa ivotthAnabhAgino'pi bhaviSyAmaH| ");
INSERT INTO sanhk_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","vayaM yat pApasya dAsAH puna rna bhavAmastadartham asmAkaM pAparUpazarIrasya vinAzArtham asmAkaM purAtanapuruSastena sAkaM kruze'hanyateti vayaM jAnImaH| ");
INSERT INTO sanhk_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","yo hataH sa pApAt mukta eva| ");
INSERT INTO sanhk_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","ataeva yadi vayaM khrISTena sArddham ahanyAmahi tarhi punarapi tena sahitA jIviSyAma ityatrAsmAkaM vizvAso vidyate| ");
INSERT INTO sanhk_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","yataH zmazAnAd utthApitaH khrISTo puna rna mriyata iti vayaM jAnImaH| tasmin kopyadhikAro mRtyo rnAsti| ");
INSERT INTO sanhk_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","aparaJca sa yad amriyata tenaikadA pApam uddizyAmriyata, yacca jIvati tenezvaram uddizya jIvati; ");
INSERT INTO sanhk_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","tadvad yUyamapi svAn pApam uddizya mRtAn asmAkaM prabhuNA yIzukhrISTenezvaram uddizya jIvanto jAnIta| ");
INSERT INTO sanhk_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","aparaJca kutsitAbhilASAाn pUrayituM yuSmAkaM martyadeheSu pApam AdhipatyaM na karotu| ");
INSERT INTO sanhk_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","aparaM svaM svam aGgam adharmmasyAstraM kRtvA pApasevAyAM na samarpayata, kintu zmazAnAd utthitAniva svAn Izvare samarpayata svAnyaGgAni ca dharmmAstrasvarUpANIzvaram uddizya samarpayata| ");
INSERT INTO sanhk_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","yuSmAkam upari pApasyAdhipatyaM puna rna bhaviSyati, yasmAd yUyaM vyavasthAyA anAyattA anugrahasya cAyattA abhavata| ");
INSERT INTO sanhk_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","kintu vayaM vyavasthAyA anAyattA anugrahasya cAyattA abhavAma, iti kAraNAt kiM pApaM kariSyAmaH? tanna bhavatu| ");
INSERT INTO sanhk_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","yato mRtijanakaM pApaM puNyajanakaM nidezAcaraNaJcaitayordvayo ryasmin AjJApAlanArthaM bhRtyAniva svAn samarpayatha, tasyaiva bhRtyA bhavatha, etat kiM yUyaM na jAnItha? ");
INSERT INTO sanhk_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","aparaJca pUrvvaM yUyaM pApasya bhRtyA Asteti satyaM kintu yasyAM zikSArUpAyAM mUSAyAM nikSiptA abhavata tasyA AkRtiM manobhi rlabdhavanta iti kAraNAd Izvarasya dhanyavAdo bhavatu| ");
INSERT INTO sanhk_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","itthaM yUyaM pApasevAto muktAH santo dharmmasya bhRtyA jAtAH| ");
INSERT INTO sanhk_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","yuSmAkaM zArIrikyA durbbalatAyA heto rmAnavavad aham etad bravImi; punaH punaradharmmakaraNArthaM yadvat pUrvvaM pApAmedhyayo rbhRtyatve nijAGgAni samArpayata tadvad idAnIM sAdhukarmmakaraNArthaM dharmmasya bhRtyatve nijAGgAni samarpayata| ");
INSERT INTO sanhk_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","yadA yUyaM pApasya bhRtyA Asta tadA dharmmasya nAyattA Asta| ");
INSERT INTO sanhk_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","tarhi yAni karmmANi yUyam idAnIM lajjAjanakAni budhyadhve pUrvvaM tai ryuSmAkaM ko lAbha AsIt? teSAM karmmaNAM phalaM maraNameva| ");
INSERT INTO sanhk_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","kintu sAmprataM yUyaM pApasevAto muktAH santa Izvarasya bhRtyA'bhavata tasmAd yuSmAkaM pavitratvarUpaM labhyam anantajIvanarUpaJca phalam Aste| ");
INSERT INTO sanhk_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","yataH pApasya vetanaM maraNaM kintvasmAkaM prabhuNA yIzukhrISTenAnantajIvanam IzvaradattaM pAritoSikam Aste| ");
INSERT INTO sanhk_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","he bhrAtRgaNa vyavasthAvidaH prati mamedaM nivedanaM| vidhiH kevalaM yAvajjIvaM mAnavoparyyadhipatitvaM karotIti yUyaM kiM na jAnItha? ");
INSERT INTO sanhk_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","yAvatkAlaM pati rjIvati tAvatkAlam UDhA bhAryyA vyavasthayA tasmin baddhA tiSThati kintu yadi pati rmriyate tarhi sA nArI patyu rvyavasthAto mucyate| ");
INSERT INTO sanhk_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","etatkAraNAt patyurjIvanakAle nArI yadyanyaM puruSaM vivahati tarhi sA vyabhicAriNI bhavati kintu yadi sa pati rmriyate tarhi sA tasyA vyavasthAyA muktA satI puruSAntareNa vyUDhApi vyabhicAriNI na bhavati| ");
INSERT INTO sanhk_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","he mama bhrAtRgaNa, IzvaranimittaM yadasmAkaM phalaM jAyate tadarthaM zmazAnAd utthApitena puruSeNa saha yuSmAkaM vivAho yad bhavet tadarthaM khrISTasya zarIreNa yUyaM vyavasthAM prati mRtavantaH| ");
INSERT INTO sanhk_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","yato'smAkaM zArIrikAcaraNasamaye maraNanimittaM phalam utpAdayituM vyavasthayA dUSitaH pApAbhilASo'smAkam aGgeSu jIvan AsIt| ");
INSERT INTO sanhk_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","kintu tadA yasyA vyavasthAyA vaze Asmahi sAmprataM tAM prati mRtatvAd vayaM tasyA adhInatvAt muktA iti hetorIzvaro'smAbhiH purAtanalikhitAnusArAt na sevitavyaH kintu navInasvabhAvenaiva sevitavyaH ");
INSERT INTO sanhk_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","tarhi vayaM kiM brUmaH? vyavasthA kiM pApajanikA bhavati? netthaM bhavatu| vyavasthAm avidyamAnAyAM pApaM kim ityahaM nAvedaM; kiJca lobhaM mA kArSIriti ced vyavasthAgranthe likhitaM nAbhaviSyat tarhi lobhaH kimbhUtastadahaM nAjJAsyaM| ");
INSERT INTO sanhk_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","kintu vyavasthayA pApaM chidraM prApyAsmAkam antaH sarvvavidhaM kutsitAbhilASam ajanayat; yato vyavasthAyAm avidyamAnAyAM pApaM mRtaM| ");
INSERT INTO sanhk_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","aparaM pUrvvaM vyavasthAyAm avidyamAnAyAm aham ajIvaM tataH param AjJAyAm upasthitAyAm pApam ajIvat tadAham amriye| ");
INSERT INTO sanhk_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","itthaM sati jIvananimittA yAjJA sA mama mRtyujanikAbhavat| ");
INSERT INTO sanhk_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","yataH pApaM chidraM prApya vyavasthitAdezena mAM vaJcayitvA tena mAm ahan| ");
INSERT INTO sanhk_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","ataeva vyavasthA pavitrA, Adezazca pavitro nyAyyo hitakArI ca bhavati| ");
INSERT INTO sanhk_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","tarhi yat svayaM hitakRt tat kiM mama mRtyujanakam abhavat? netthaM bhavatu; kintu pApaM yat pAtakamiva prakAzate tathA nidezena pApaM yadatIva pAtakamiva prakAzate tadarthaM hitopAyena mama maraNam ajanayat| ");
INSERT INTO sanhk_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","vyavasthAtmabodhiketi vayaM jAnImaH kintvahaM zArIratAcArI pApasya krItakiGkaro vidye| ");
INSERT INTO sanhk_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","yato yat karmma karomi tat mama mano'bhimataM nahi; aparaM yan mama mano'bhimataM tanna karomi kintu yad RtIye tat karomi| ");
INSERT INTO sanhk_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","tathAtve yan mamAnabhimataM tad yadi karomi tarhi vyavasthA sUttameti svIkaromi| ");
INSERT INTO sanhk_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","ataeva samprati tat karmma mayA kriyata iti nahi kintu mama zarIrasthena pApenaiva kriyate| ");
INSERT INTO sanhk_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","yato mayi, arthato mama zarIre, kimapyuttamaM na vasati, etad ahaM jAnAmi; mamecchukatAyAM tiSThantyAmapyaham uttamakarmmasAdhane samartho na bhavAmi| ");
INSERT INTO sanhk_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","yato yAmuttamAM kriyAM karttumahaM vAJchAmi tAM na karomi kintu yat kutsitaM karmma karttum anicchuko'smi tadeva karomi| ");
INSERT INTO sanhk_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","ataeva yadyat karmma karttuM mamecchA na bhavati tad yadi karomi tarhi tat mayA na kriyate, mamAntarvarttinA pApenaiva kriyate| ");
INSERT INTO sanhk_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","bhadraM karttum icchukaM mAM yo 'bhadraM karttuM pravarttayati tAdRzaM svabhAvamekaM mayi pazyAmi| ");
INSERT INTO sanhk_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","aham AntarikapuruSeNezvaravyavasthAyAM santuSTa Ase; ");
INSERT INTO sanhk_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","kintu tadviparItaM yudhyantaM tadanyamekaM svabhAvaM madIyAGgasthitaM prapazyAmi, sa madIyAGgasthitapApasvabhAvasyAyattaM mAM karttuM ceSTate| ");
INSERT INTO sanhk_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","hA hA yo'haM durbhAgyo manujastaM mAm etasmAn mRtAccharIrAt ko nistArayiSyati? ");
INSERT INTO sanhk_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","asmAkaM prabhuNA yIzukhrISTena nistArayitAram IzvaraM dhanyaM vadAmi| ataeva zarIreNa pApavyavasthAyA manasA tu IzvaravyavasthAyAH sevanaM karomi| ");
INSERT INTO sanhk_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","ye janAH khrISTaM yIzum Azritya zArIrikaM nAcaranta AtmikamAcaranti te'dhunA daNDArhA na bhavanti| ");
INSERT INTO sanhk_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","jIvanadAyakasyAtmano vyavasthA khrISTayIzunA pApamaraNayo rvyavasthAto mAmamocayat| ");
INSERT INTO sanhk_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","yasmAcchArIrasya durbbalatvAd vyavasthayA yat karmmAsAdhyam Izvaro nijaputraM pApizarIrarUpaM pApanAzakabalirUpaJca preSya tasya zarIre pApasya daNDaM kurvvan tatkarmma sAdhitavAn| ");
INSERT INTO sanhk_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","tataH zArIrikaM nAcaritvAsmAbhirAtmikam AcaradbhirvyavasthAgranthe nirddiSTAni puNyakarmmANi sarvvANi sAdhyante| ");
INSERT INTO sanhk_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","ye zArIrikAcAriNaste zArIrikAn viSayAn bhAvayanti ye cAtmikAcAriNaste Atmano viSayAn bhAvayanti| ");
INSERT INTO sanhk_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","zArIrikabhAvasya phalaM mRtyuH kiJcAtmikabhAvasya phale jIvanaM zAntizca| ");
INSERT INTO sanhk_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","yataH zArIrikabhAva Izvarasya viruddhaH zatrutAbhAva eva sa Izvarasya vyavasthAyA adhIno na bhavati bhavituJca na zaknoti| ");
INSERT INTO sanhk_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","etasmAt zArIrikAcAriSu toSTum IzvareNa na zakyaM| ");
INSERT INTO sanhk_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","kintvIzvarasyAtmA yadi yuSmAkaM madhye vasati tarhi yUyaM zArIrikAcAriNo na santa AtmikAcAriNo bhavathaH| yasmin tu khrISTasyAtmA na vidyate sa tatsambhavo nahi| ");
INSERT INTO sanhk_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","yadi khrISTo yuSmAn adhitiSThati tarhi pApam uddizya zarIraM mRtaM kintu puNyamuddizyAtmA jIvati| ");
INSERT INTO sanhk_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","mRtagaNAd yIzu ryenotthApitastasyAtmA yadi yuSmanmadhye vasati tarhi mRtagaNAt khrISTasya sa utthApayitA yuSmanmadhyavAsinA svakIyAtmanA yuSmAkaM mRtadehAnapi puna rjIvayiSyati| ");
INSERT INTO sanhk_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","he bhrAtRgaNa zarIrasya vayamadhamarNA na bhavAmo'taH zArIrikAcAro'smAbhi rna karttavyaH| ");
INSERT INTO sanhk_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","yadi yUyaM zarIrikAcAriNo bhaveta tarhi yuSmAbhi rmarttavyameva kintvAtmanA yadi zarIrakarmmANi ghAtayeta tarhi jIviSyatha| ");
INSERT INTO sanhk_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","yato yAvanto lokA IzvarasyAtmanAkRSyante te sarvva Izvarasya santAnA bhavanti| ");
INSERT INTO sanhk_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","yUyaM punarapi bhayajanakaM dAsyabhAvaM na prAptAH kintu yena bhAvenezvaraM pitaH pitariti procya sambodhayatha tAdRzaM dattakaputratvabhAvam prApnuta| ");
INSERT INTO sanhk_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","aparaJca vayam Izvarasya santAnA etasmin pavitra AtmA svayam asmAkam AtmAbhiH sArddhaM pramANaM dadAti| ");
INSERT INTO sanhk_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","ataeva vayaM yadi santAnAstarhyadhikAriNaH, arthAd Izvarasya svattvAdhikAriNaH khrISTena sahAdhikAriNazca bhavAmaH; aparaM tena sArddhaM yadi duHkhabhAgino bhavAmastarhi tasya vibhavasyApi bhAgino bhaviSyAmaH| ");
INSERT INTO sanhk_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","kintvasmAsu yo bhAvIvibhavaH prakAziSyate tasya samIpe varttamAnakAlInaM duHkhamahaM tRNAya manye| ");
INSERT INTO sanhk_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","yataH prANigaNa Izvarasya santAnAnAM vibhavaprAptim AkAGkSan nitAntam apekSate| ");
INSERT INTO sanhk_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","aparaJca prANigaNaH svairam alIkatAyA vazIkRto nAbhavat ");
INSERT INTO sanhk_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","kintu prANigaNo'pi nazvaratAdhInatvAt muktaH san Izvarasya santAnAnAM paramamuktiM prApsyatItyabhiprAyeNa vazIkartrA vazIcakre| ");
INSERT INTO sanhk_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","aparaJca prasUyamAnAvad vyathitaH san idAnIM yAvat kRtsnaH prANigaNa ArttasvaraM karotIti vayaM jAnImaH| ");
INSERT INTO sanhk_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","kevalaH sa iti nahi kintu prathamajAtaphalasvarUpam AtmAnaM prAptA vayamapi dattakaputratvapadaprAptim arthAt zarIrasya muktiM pratIkSamANAstadvad antarArttarAvaM kurmmaH| ");
INSERT INTO sanhk_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","vayaM pratyAzayA trANam alabhAmahi kintu pratyakSavastuno yA pratyAzA sA pratyAzA nahi, yato manuSyo yat samIkSate tasya pratyAzAM kutaH kariSyati? ");
INSERT INTO sanhk_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","yad apratyakSaM tasya pratyAzAM yadi vayaM kurvvImahi tarhi dhairyyam avalambya pratIkSAmahe| ");
INSERT INTO sanhk_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","tata AtmApi svayam asmAkaM durbbalatAyAH sahAyatvaM karoti; yataH kiM prArthitavyaM tad boddhuM vayaM na zaknumaH, kintvaspaSTairArttarAvairAtmA svayam asmannimittaM nivedayati| ");
INSERT INTO sanhk_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","aparam IzvarAbhimatarUpeNa pavitralokAnAM kRte nivedayati ya AtmA tasyAbhiprAyo'ntaryyAminA jJAyate| ");
INSERT INTO sanhk_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","aparam IzvarIyanirUpaNAnusAreNAhUtAH santo ye tasmin prIyante sarvvANi militvA teSAM maGgalaM sAdhayanti, etad vayaM jAnImaH| ");
INSERT INTO sanhk_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","yata Izvaro bahubhrAtRNAM madhye svaputraM jyeSThaM karttum icchan yAn pUrvvaM lakSyIkRtavAn tAn tasya pratimUrtyAH sAdRzyaprAptyarthaM nyayuMkta| ");
INSERT INTO sanhk_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","aparaJca tena ye niyuktAsta AhUtA api ye ca tenAhUtAste sapuNyIkRtAH, ye ca tena sapuNyIkRtAste vibhavayuktAH| ");
INSERT INTO sanhk_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","ityatra vayaM kiM brUmaH? Izvaro yadyasmAkaM sapakSo bhavati tarhi ko vipakSo'smAkaM? ");
INSERT INTO sanhk_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","AtmaputraM na rakSitvA yo'smAkaM sarvveSAM kRte taM pradattavAn sa kiM tena sahAsmabhyam anyAni sarvvANi na dAsyati? ");
INSERT INTO sanhk_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","IzvarasyAbhiruciteSu kena doSa AropayiSyate? ya IzvarastAn puNyavata iva gaNayati kiM tena? ");
INSERT INTO sanhk_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","aparaM tebhyo daNDadAnAjJA vA kena kariSyate? yo'smannimittaM prANAn tyaktavAn kevalaM tanna kintu mRtagaNamadhyAd utthitavAn, api cezvarasya dakSiNe pArzve tiSThan adyApyasmAkaM nimittaM prArthata evambhUto yaH khrISTaH kiM tena? ");
INSERT INTO sanhk_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","asmAbhiH saha khrISTasya premavicchedaM janayituM kaH zaknoti? klezo vyasanaM vA tADanA vA durbhikSaM vA vastrahInatvaM vA prANasaMzayo vA khaGgo vA kimetAni zaknuvanti? ");
INSERT INTO sanhk_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","kintu likhitam Aste, yathA, vayaM tava nimittaM smo mRtyuvaktre'khilaM dinaM| balirdeyo yathA meSo vayaM gaNyAmahe tathA| ");
INSERT INTO sanhk_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","aparaM yo'smAsu prIyate tenaitAsu vipatsu vayaM samyag vijayAmahe| ");
INSERT INTO sanhk_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","yato'smAkaM prabhunA yIzukhrISTenezvarasya yat prema tasmAd asmAkaM vicchedaM janayituM mRtyu rjIvanaM vA divyadUtA vA balavanto mukhyadUtA vA varttamAno vA bhaviSyan kAlo vA uccapadaM vA nIcapadaM vAparaM kimapi sRSTavastu ");
INSERT INTO sanhk_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","vaiteSAM kenApi na zakyamityasmin dRDhavizvAso mamAste| ");
INSERT INTO sanhk_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","ahaM kAJcid kalpitAM kathAM na kathayAmi, khrISTasya sAkSAt satyameva bravImi pavitrasyAtmanaH sAkSAn madIyaM mana etat sAkSyaM dadAti| ");
INSERT INTO sanhk_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","mamAntaratizayaduHkhaM nirantaraM khedazca ");
INSERT INTO sanhk_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","tasmAd ahaM svajAtIyabhrAtRNAM nimittAt svayaM khrISTAcchApAkrAnto bhavitum aiccham| ");
INSERT INTO sanhk_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","yatasta isrAyelasya vaMzA api ca dattakaputratvaM tejo niyamo vyavasthAdAnaM mandire bhajanaM pratijJAH pitRpuruSagaNazcaiteSu sarvveSu teSAm adhikAro'sti| ");
INSERT INTO sanhk_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","tat kevalaM nahi kintu sarvvAdhyakSaH sarvvadA saccidAnanda Izvaro yaH khrISTaH so'pi zArIrikasambandhena teSAM vaMzasambhavaH| ");
INSERT INTO sanhk_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Izvarasya vAkyaM viphalaM jAtam iti nahi yatkAraNAd isrAyelo vaMze ye jAtAste sarvve vastuta isrAyelIyA na bhavanti| ");
INSERT INTO sanhk_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","aparam ibrAhImo vaMze jAtA api sarvve tasyaiva santAnA na bhavanti kintu ishAko nAmnA tava vaMzo vikhyAto bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","arthAt zArIrikasaMsargAt jAtAH santAnA yAvantastAvanta evezvarasya santAnA na bhavanti kintu pratizravaNAd ye jAyante taevezvaravaMzo gaNyate| ");
INSERT INTO sanhk_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","yatastatpratizrute rvAkyametat, etAdRze samaye 'haM punarAgamiSyAmi tatpUrvvaM sArAyAH putra eko janiSyate| ");
INSERT INTO sanhk_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","aparamapi vadAmi svamano'bhilASata IzvareNa yannirUpitaM tat karmmato nahi kintvAhvayitu rjAtametad yathA siddhyati ");
INSERT INTO sanhk_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","tadarthaM ribkAnAmikayA yoSitA janaikasmAd arthAd asmAkam ishAkaH pUrvvapuruSAd garbhe dhRte tasyAH santAnayoH prasavAt pUrvvaM kiJca tayoH zubhAzubhakarmmaNaH karaNAt pUrvvaM ");
INSERT INTO sanhk_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","tAM pratIdaM vAkyam uktaM, jyeSThaH kaniSThaM seviSyate, ");
INSERT INTO sanhk_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","yathA likhitam Aste, tathApyeSAvi na prItvA yAkUbi prItavAn ahaM| ");
INSERT INTO sanhk_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","tarhi vayaM kiM brUmaH? IzvaraH kim anyAyakArI? tathA na bhavatu| ");
INSERT INTO sanhk_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","yataH sa svayaM mUsAm avadat; ahaM yasmin anugrahaM cikIrSAmi tamevAnugRhlAmi, yaJca dayitum icchAmi tameva daye| ");
INSERT INTO sanhk_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","ataevecchatA yatamAnena vA mAnavena tanna sAdhyate dayAkAriNezvareNaiva sAdhyate| ");
INSERT INTO sanhk_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","phirauNi zAstre likhati, ahaM tvaddvArA matparAkramaM darzayituM sarvvapRthivyAM nijanAma prakAzayituJca tvAM sthApitavAn| ");
INSERT INTO sanhk_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","ataH sa yam anugrahItum icchati tamevAnugRhlAti, yaJca nigrahItum icchati taM nigRhlAti| ");
INSERT INTO sanhk_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","yadi vadasi tarhi sa doSaM kuto gRhlAti? tadIyecchAyAH pratibandhakatvaM karttaM kasya sAmarthyaM vidyate? ");
INSERT INTO sanhk_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","he Izvarasya pratipakSa martya tvaM kaH? etAdRzaM mAM kutaH sRSTavAn? iti kathAM sRSTavastu sraSTre kiM kathayiSyati? ");
INSERT INTO sanhk_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","ekasmAn mRtpiNDAd utkRSTApakRSTau dvividhau kalazau karttuM kiM kulAlasya sAmarthyaM nAsti? ");
INSERT INTO sanhk_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","IzvaraH kopaM prakAzayituM nijazaktiM jJApayituJcecchan yadi vinAzasya yogyAni krodhabhAjanAni prati bahukAlaM dIrghasahiSNutAm Azrayati; ");
INSERT INTO sanhk_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","aparaJca vibhavaprAptyarthaM pUrvvaM niyuktAnyanugrahapAtrANi prati nijavibhavasya bAhulyaM prakAzayituM kevalayihUdinAM nahi bhinnadezinAmapi madhyAd ");
INSERT INTO sanhk_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","asmAniva tAnyAhvayati tatra tava kiM? ");
INSERT INTO sanhk_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","hozeyagranthe yathA likhitam Aste, yo loko mama nAsIt taM vadiSyAmi madIyakaM| yA jAti rme'priyA cAsIt tAM vadiSyAmyahaM priyAM| ");
INSERT INTO sanhk_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","yUyaM madIyalokA na yatreti vAkyamaucyata| amarezasya santAnA iti khyAsyanti tatra te| ");
INSERT INTO sanhk_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","isrAyelIyalokeSu yizAyiyo'pi vAcametAM prAcArayat, isrAyelIyavaMzAnAM yA saMkhyA sA tu nizcitaM| samudrasikatAsaMkhyAsamAnA yadi jAyate| tathApi kevalaM lokairalpaistrANaM vrajiSyate| ");
INSERT INTO sanhk_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","yato nyAyena svaM karmma parezaH sAdhayiSyati| deze saeva saMkSepAnnijaM karmma kariSyati| ");
INSERT INTO sanhk_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","yizAyiyo'paramapi kathayAmAsa, sainyAdhyakSaparezena cet kiJcinnodaziSyata| tadA vayaM sidomevAbhaviSyAma vinizcitaM| yadvA vayam amorAyA agamiSyAma tulyatAM| ");
INSERT INTO sanhk_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","tarhi vayaM kiM vakSyAmaH? itaradezIyA lokA api puNyArtham ayatamAnA vizvAsena puNyam alabhanta; ");
INSERT INTO sanhk_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","kintvisrAyellokA vyavasthApAlanena puNyArthaM yatamAnAstan nAlabhanta| ");
INSERT INTO sanhk_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","tasya kiM kAraNaM? te vizvAsena nahi kintu vyavasthAyAH kriyayA ceSTitvA tasmin skhalanajanake pASANe pAdaskhalanaM prAptAH| ");
INSERT INTO sanhk_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","likhitaM yAdRzam Aste, pazya pAdaskhalArthaM hi sIyoni prastarantathA| bAdhAkAraJca pASANaM paristhApitavAnaham| vizvasiSyati yastatra sa jano na trapiSyate| ");
INSERT INTO sanhk_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","he bhrAtara isrAyelIyalokA yat paritrANaM prApnuvanti tadahaM manasAbhilaSan Izvarasya samIpe prArthaye| ");
INSERT INTO sanhk_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","yata Izvare teSAM ceSTA vidyata ityatrAhaM sAkSyasmi; kintu teSAM sA ceSTA sajJAnA nahi, ");
INSERT INTO sanhk_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","yatasta IzvaradattaM puNyam avijJAya svakRtapuNyaM sthApayitum ceSTamAnA Izvaradattasya puNyasya nighnatvaM na svIkurvvanti| ");
INSERT INTO sanhk_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","khrISTa ekaikavizvAsijanAya puNyaM dAtuM vyavasthAyAH phalasvarUpo bhavati| ");
INSERT INTO sanhk_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","vyavasthApAlanena yat puNyaM tat mUsA varNayAmAsa, yathA, yo janastAM pAlayiSyati sa taddvArA jIviSyati| ");
INSERT INTO sanhk_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","kintu pratyayena yat puNyaM tad etAdRzaM vAkyaM vadati, kaH svargam Aruhya khrISTam avarohayiSyati? ");
INSERT INTO sanhk_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","ko vA pretalokam avaruhya khrISTaM mRtagaNamadhyAd AneSyatIti vAk manasi tvayA na gaditavyA| ");
INSERT INTO sanhk_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","tarhi kiM bravIti? tad vAkyaM tava samIpastham arthAt tava vadane manasi cAste, tacca vAkyam asmAbhiH pracAryyamANaM vizvAsasya vAkyameva| ");
INSERT INTO sanhk_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","vastutaH prabhuM yIzuM yadi vadanena svIkaroSi, tathezvarastaM zmazAnAd udasthApayad iti yadyantaHkaraNena vizvasiSi tarhi paritrANaM lapsyase| ");
INSERT INTO sanhk_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","yasmAt puNyaprAptyartham antaHkaraNena vizvasitavyaM paritrANArthaJca vadanena svIkarttavyaM| ");
INSERT INTO sanhk_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","zAstre yAdRzaM likhati vizvasiSyati yastatra sa jano na trapiSyate| ");
INSERT INTO sanhk_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","ityatra yihUdini tadanyaloke ca kopi vizeSo nAsti yasmAd yaH sarvveSAm advitIyaH prabhuH sa nijayAcakAna sarvvAn prati vadAnyo bhavati| ");
INSERT INTO sanhk_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","yataH, yaH kazcit paramezasya nAmnA hi prArthayiSyate| sa eva manujo nUnaM paritrAto bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","yaM ye janA na pratyAyan te tamuddizya kathaM prArthayiSyante? ye vA yasyAkhyAnaM kadApi na zrutavantaste taM kathaM pratyeSyanti? aparaM yadi pracArayitAro na tiSThanti tadA kathaM te zroSyanti? ");
INSERT INTO sanhk_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","yadi vA preritA na bhavanti tadA kathaM pracArayiSyanti? yAdRzaM likhitam Aste, yathA, mAGgalikaM susaMvAdaM dadatyAnIya ye narAH| pracArayanti zAntezca susaMvAdaM janAstu ye| teSAM caraNapadmAni kIdRk zobhAnvitAni hi| ");
INSERT INTO sanhk_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","kintu te sarvve taM susaMvAdaM na gRhItavantaH| yizAyiyo yathA likhitavAn| asmatpracArite vAkye vizvAsamakaroddhi kaH| ");
INSERT INTO sanhk_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","ataeva zravaNAd vizvAsa aizvaravAkyapracArAt zravaNaJca bhavati| ");
INSERT INTO sanhk_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","tarhyahaM bravImi taiH kiM nAzrAvi? avazyam azrAvi, yasmAt teSAM zabdo mahIM vyApnod vAkyaJca nikhilaM jagat| ");
INSERT INTO sanhk_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","aparamapi vadAmi, isrAyelIyalokAH kim etAM kathAM na budhyante? prathamato mUsA idaM vAkyaM provAca, ahamuttApayiSye tAn agaNyamAnavairapi| klekSyAmi jAtim etAJca pronmattabhinnajAtibhiH| ");
INSERT INTO sanhk_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","aparaJca yizAyiyo'tizayAkSobheNa kathayAmAsa, yathA, adhi mAM yaistu nAceSTi samprAptastai rjanairahaM| adhi mAM yai rna sampRSTaM vijJAtastai rjanairahaM|| ");
INSERT INTO sanhk_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","kintvisrAyelIyalokAn adhi kathayAJcakAra, yairAjJAlaGghibhi rlokai rviruddhaM vAkyamucyate| tAn pratyeva dinaM kRtsnaM hastau vistArayAmyahaM|| ");
INSERT INTO sanhk_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","IzvareNa svIkIyalokA apasAritA ahaM kim IdRzaM vAkyaM bravImi? tanna bhavatu yato'hamapi binyAmInagotrIya ibrAhImavaMzIya isrAyelIyaloko'smi| ");
INSERT INTO sanhk_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","IzvareNa pUrvvaM ye pradRSTAste svakIyalokA apasAritA iti nahi| aparam eliyopAkhyAne zAstre yallikhitam Aste tad yUyaM kiM na jAnItha? ");
INSERT INTO sanhk_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","he paramezvara lokAstvadIyAH sarvvA yajJavedIrabhaJjan tathA tava bhaviSyadvAdinaH sarvvAn aghnan kevala eko'ham avaziSTa Ase te mamApi prANAn nAzayituM ceSTanate, etAM kathAm isrAyelIyalokAnAM viruddham eliya IzvarAya nivedayAmAsa| ");
INSERT INTO sanhk_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","tatastaM pratIzvarasyottaraM kiM jAtaM? bAlnAmno devasya sAkSAt yai rjAnUni na pAtitAni tAdRzAH sapta sahasrANi lokA avazeSitA mayA| ");
INSERT INTO sanhk_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","tadvad etasmin varttamAnakAle'pi anugraheNAbhirucitAsteSAm avaziSTAH katipayA lokAH santi| ");
INSERT INTO sanhk_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","ataeva tad yadyanugraheNa bhavati tarhi kriyayA na bhavati no ced anugraho'nanugraha eva, yadi vA kriyayA bhavati tarhyanugraheNa na bhavati no cet kriyA kriyaiva na bhavati| ");
INSERT INTO sanhk_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","tarhi kiM? isrAyelIyalokA yad amRgayanta tanna prApuH| kintvabhirucitalokAstat prApustadanye sarvva andhIbhUtAH| ");
INSERT INTO sanhk_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","yathA likhitam Aste, ghoranidrAlutAbhAvaM dRSTihIne ca locane| karNau zrutivihInau ca pradadau tebhya IzvaraH|| ");
INSERT INTO sanhk_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","etesmin dAyUdapi likhitavAn yathA, ato bhuktyAsanaM teSAm unmAthavad bhaviSyati| vA vaMzayantravad bAdhA daNDavad vA bhaviSyati|| ");
INSERT INTO sanhk_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","bhaviSyanti tathAndhAste netraiH pazyanti no yathA| vepathuH kaTidezasya teSAM nityaM bhaviSyati|| ");
INSERT INTO sanhk_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","patanArthaM te skhalitavanta iti vAcaM kimahaM vadAmi? tanna bhavatu kintu tAn udyoginaH karttuM teSAM patanAd itaradezIyalokaiH paritrANaM prAptaM| ");
INSERT INTO sanhk_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","teSAM patanaM yadi jagato lokAnAM lAbhajanakam abhavat teSAM hrAso'pi yadi bhinnadezinAM lAbhajanako'bhavat tarhi teSAM vRddhiH kati lAbhajanikA bhaviSyati? ");
INSERT INTO sanhk_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","ato he anyadezino yuSmAn sambodhya kathayAmi nijAnAM jJAtibandhUnAM manaHsUdyogaM janayan teSAM madhye kiyatAM lokAnAM yathA paritrANaM sAdhayAmi ");
INSERT INTO sanhk_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","tannimittam anyadezinAM nikaTe preritaH san ahaM svapadasya mahimAnaM prakAzayAmi| ");
INSERT INTO sanhk_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","teSAM nigraheNa yadIzvareNa saha jagato janAnAM melanaM jAtaM tarhi teSAm anugRhItatvaM mRtadehe yathA jIvanalAbhastadvat kiM na bhaviSyati? ");
INSERT INTO sanhk_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","aparaM prathamajAtaM phalaM yadi pavitraM bhavati tarhi sarvvameva phalaM pavitraM bhaviSyati; tathA mUlaM yadi pavitraM bhavati tarhi zAkhA api tathaiva bhaviSyanti| ");
INSERT INTO sanhk_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","kiyatInAM zAkhAnAM chedane kRte tvaM vanyajitavRkSasya zAkhA bhUtvA yadi tacchAkhAnAM sthAne ropitA sati jitavRkSIyamUlasya rasaM bhuMkSe, ");
INSERT INTO sanhk_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","tarhi tAsAM bhinnazAkhAnAM viruddhaM mAM garvvIH; yadi garvvasi tarhi tvaM mUlaM yanna dhArayasi kintu mUlaM tvAM dhArayatIti saMsmara| ");
INSERT INTO sanhk_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","aparaJca yadi vadasi mAM ropayituM tAH zAkhA vibhannA abhavan; ");
INSERT INTO sanhk_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","bhadram, apratyayakAraNAt te vibhinnA jAtAstathA vizvAsakAraNAt tvaM ropito jAtastasmAd ahaGkAram akRtvA sasAdhvaso bhava| ");
INSERT INTO sanhk_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","yata Izvaro yadi svAbhAvikIH zAkhA na rakSati tarhi sAvadhAno bhava cet tvAmapi na sthApayati| ");
INSERT INTO sanhk_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","ityatrezvarasya yAdRzI kRpA tAdRzaM bhayAnakatvamapi tvayA dRzyatAM; ye patitAstAn prati tasya bhayAnakatvaM dRzyatAM, tvaJca yadi tatkRpAzritastiSThasi tarhi tvAM prati kRpA drakSyate; no cet tvamapi tadvat chinno bhaviSyasi| ");
INSERT INTO sanhk_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","aparaJca te yadyapratyaye na tiSThanti tarhi punarapi ropayiSyante yasmAt tAn punarapi ropayitum izvarasya zaktirAste| ");
INSERT INTO sanhk_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","vanyajitavRkSasya zAkhA san tvaM yadi tatazchinno rItivyatyayenottamajitavRkSe roेेpito'bhavastarhi tasya vRkSasya svIyA yAH zAkhAstAH kiM punaH svavRkSe saMlagituM na zaknuvanti? ");
INSERT INTO sanhk_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","he bhrAtaro yuSmAkam AtmAbhimAno yanna jAyate tadarthaM mamedRzI vAJchA bhavati yUyaM etannigUDhatattvam ajAnanto yanna tiSThatha; vastuto yAvatkAlaM sampUrNarUpeNa bhinnadezinAM saMgraho na bhaviSyati tAvatkAlam aMzatvena isrAyelIyalokAnAm andhatA sthAsyati; ");
INSERT INTO sanhk_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","pazcAt te sarvve paritrAsyante; etAdRzaM likhitamapyAste, AgamiSyati sIyonAd eko yastrANadAyakaH| adharmmaM yAkubo vaMzAt sa tu dUrIkariSyati| ");
INSERT INTO sanhk_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","tathA dUrIkariSyAmi teSAM pApAnyahaM yadA| tadA taireva sArddhaM me niyamo'yaM bhaviSyati| ");
INSERT INTO sanhk_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","susaMvAdAt te yuSmAkaM vipakSA abhavan kintvabhirucitatvAt te pitRlokAnAM kRte priyapAtrANi bhavanti| ");
INSERT INTO sanhk_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","yata Izvarasya dAnAd AhvAnAJca pazcAttApo na bhavati| ");
INSERT INTO sanhk_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","ataeva pUrvvam Izvare'vizvAsinaH santo'pi yUyaM yadvat samprati teSAm avizvAsakAraNAd Izvarasya kRpApAtrANi jAtAstadvad ");
INSERT INTO sanhk_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","idAnIM te'vizvAsinaH santi kintu yuSmAbhi rlabdhakRpAkAraNAt tairapi kRpA lapsyate| ");
INSERT INTO sanhk_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","IzvaraH sarvvAn prati kRpAM prakAzayituM sarvvAn avizvAsitvena gaNayati| ");
INSERT INTO sanhk_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","aho Izvarasya jJAnabuddhirUpayo rdhanayoH kIdRk prAcuryyaM| tasya rAjazAsanasya tattvaM kIdRg aprApyaM| tasya mArgAzca kIdRg anupalakSyAH| ");
INSERT INTO sanhk_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","paramezvarasya saGkalpaM ko jJAtavAn? tasya mantrI vA ko'bhavat? ");
INSERT INTO sanhk_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","ko vA tasyopakArI bhRtvA tatkRte tena pratyupakarttavyaH? ");
INSERT INTO sanhk_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","yato vastumAtrameva tasmAt tena tasmai cAbhavat tadIyo mahimA sarvvadA prakAzito bhavatu| iti| ");
INSERT INTO sanhk_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","he bhrAtara Izvarasya kRpayAhaM yuSmAn vinaye yUyaM svaM svaM zarIraM sajIvaM pavitraM grAhyaM balim Izvaramuddizya samutsRjata, eSA sevA yuSmAkaM yogyA| ");
INSERT INTO sanhk_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","aparaM yUyaM sAMsArikA iva mAcarata, kintu svaM svaM svabhAvaM parAvartya nUtanAcAriNo bhavata, tata Izvarasya nidezaH kIdRg uttamo grahaNIyaH sampUrNazceti yuSmAbhiranubhAviSyate| ");
INSERT INTO sanhk_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","kazcidapi jano yogyatvAdadhikaM svaM na manyatAM kintu Izvaro yasmai pratyayasya yatparimANam adadAt sa tadanusArato yogyarUpaM svaM manutAm, IzvarAd anugrahaM prAptaH san yuSmAkam ekaikaM janam ityAjJApayAmi| ");
INSERT INTO sanhk_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","yato yadvadasmAkam ekasmin zarIre bahUnyaGgAni santi kintu sarvveSAmaGgAnAM kAryyaM samAnaM nahi; ");
INSERT INTO sanhk_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","tadvadasmAkaM bahutve'pi sarvve vayaM khrISTe ekazarIrAH parasparam aGgapratyaGgatvena bhavAmaH| ");
INSERT INTO sanhk_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","asmAd IzvarAnugraheNa vizeSaM vizeSaM dAnam asmAsu prApteSu satsu kopi yadi bhaviSyadvAkyaM vadati tarhi pratyayasya parimANAnusArataH sa tad vadatu; ");
INSERT INTO sanhk_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","yadvA yadi kazcit sevanakArI bhavati tarhi sa tatsevanaM karotu; athavA yadi kazcid adhyApayitA bhavati tarhi so'dhyApayatu; ");
INSERT INTO sanhk_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","tathA ya upadeSTA bhavati sa upadizatu yazca dAtA sa saralatayA dadAtu yastvadhipatiH sa yatnenAdhipatitvaM karotu yazca dayAluH sa hRSTamanasA dayatAm| ");
INSERT INTO sanhk_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","aparaJca yuSmAkaM prema kApaTyavarjitaM bhavatu yad abhadraM tad RtIyadhvaM yacca bhadraM tasmin anurajyadhvam| ");
INSERT INTO sanhk_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","aparaM bhrAtRtvapremnA parasparaM prIyadhvaM samAdarAd eko'parajanaM zreSThaM jAnIdhvam| ");
INSERT INTO sanhk_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","tathA kAryye nirAlasyA manasi ca sodyogAH santaH prabhuM sevadhvam| ");
INSERT INTO sanhk_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","aparaM pratyAzAyAm AnanditA duHkhasamaye ca dhairyyayuktA bhavata; prArthanAyAM satataM pravarttadhvaM| ");
INSERT INTO sanhk_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","pavitrANAM dInatAM dUrIkurudhvam atithisevAyAm anurajyadhvam| ");
INSERT INTO sanhk_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","ye janA yuSmAn tADayanti tAn AziSaM vadata zApam adattvA daddhvamAziSam| ");
INSERT INTO sanhk_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","ye janA Anandanti taiH sArddham Anandata ye ca rudanti taiH saha rudita| ");
INSERT INTO sanhk_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","aparaJca yuSmAkaM manasAM parasparam ekobhAvo bhavatu; aparam uccapadam anAkAGkSya nIcalokaiH sahApi mArdavam Acarata; svAn jJAnino na manyadhvaM| ");
INSERT INTO sanhk_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","parasmAd apakAraM prApyApi paraM nApakuruta| sarvveSAM dRSTito yat karmmottamaM tadeva kuruta| ");
INSERT INTO sanhk_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","yadi bhavituM zakyate tarhi yathAzakti sarvvalokaiH saha nirvvirodhena kAlaM yApayata| ");
INSERT INTO sanhk_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","he priyabandhavaH, kasmaicid apakArasya samucitaM daNDaM svayaM na daddhvaM, kintvIzvarIyakrodhAya sthAnaM datta yato likhitamAste paramezvaraH kathayati, dAnaM phalasya matkarmma sUcitaM pradadAmyahaM| ");
INSERT INTO sanhk_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","itikAraNAd ripu ryadi kSudhArttaste tarhi taM tvaM prabhojaya| tathA yadi tRSArttaH syAt tarhi taM paripAyaya| tena tvaM mastake tasya jvaladagniM nidhAsyasi| ");
INSERT INTO sanhk_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","kukriyayA parAjitA na santa uttamakriyayA kukriyAM parAjayata| ");
INSERT INTO sanhk_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","yuSmAkam ekaikajanaH zAsanapadasya nighno bhavatu yato yAni zAsanapadAni santi tAni sarvvANIzvareNa sthApitAni; IzvaraM vinA padasthApanaM na bhavati| ");
INSERT INTO sanhk_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","iti hetoH zAsanapadasya yat prAtikUlyaM tad IzvarIyanirUpaNasya prAtikUlyameva; aparaM ye prAtikUlyam Acaranti te sveSAM samucitaM daNDaM svayameva ghaTayante| ");
INSERT INTO sanhk_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","zAstA sadAcAriNAM bhayaprado nahi durAcAriNAmeva bhayaprado bhavati; tvaM kiM tasmAn nirbhayo bhavitum icchasi? tarhi satkarmmAcara, tasmAd yazo lapsyase, ");
INSERT INTO sanhk_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","yatastava sadAcaraNAya sa Izvarasya bhRtyo'sti| kintu yadi kukarmmAcarasi tarhi tvaM zaGkasva yataH sa nirarthakaM khaGgaM na dhArayati; kukarmmAcAriNaM samucitaM daNDayitum sa Izvarasya daNDadabhRtya eva| ");
INSERT INTO sanhk_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","ataeva kevaladaNDabhayAnnahi kintu sadasadbodhAdapi tasya vazyena bhavitavyaM| ");
INSERT INTO sanhk_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","etasmAd yuSmAkaM rAjakaradAnamapyucitaM yasmAd ye karaM gRhlanti ta Izvarasya kiGkarA bhUtvA satatam etasmin karmmaNi niviSTAstiSThanti| ");
INSERT INTO sanhk_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","asmAt karagrAhiNe karaM datta, tathA zulkagrAhiNe zulkaM datta, aparaM yasmAd bhetavyaM tasmAd bibhIta, yazca samAdaraNIyastaM samAdriyadhvam; itthaM yasya yat prApyaM tat tasmai datta| ");
INSERT INTO sanhk_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","yuSmAkaM parasparaM prema vinA 'nyat kimapi deyam RNaM na bhavatu, yato yaH parasmin prema karoti tena vyavasthA sidhyati| ");
INSERT INTO sanhk_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","vastutaH paradArAn mA gaccha, narahatyAM mA kArSIH, cairyyaM mA kArSIH, mithyAsAkSyaM mA dehi, lobhaM mA kArSIH, etAH sarvvA AjJA etAbhyo bhinnA yA kAcid AjJAsti sApi svasamIpavAsini svavat prema kurvvityanena vacanena veditA| ");
INSERT INTO sanhk_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","yataH prema samIpavAsino'zubhaM na janayati tasmAt premnA sarvvA vyavasthA pAlyate| ");
INSERT INTO sanhk_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","pratyayIbhavanakAle'smAkaM paritrANasya sAmIpyAd idAnIM tasya sAmIpyam avyavahitaM; ataH samayaM vivicyAsmAbhiH sAmpratam avazyameva nidrAto jAgarttavyaM| ");
INSERT INTO sanhk_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","bahutarA yAminI gatA prabhAtaM sannidhiM prAptaM tasmAt tAmasIyAH kriyAH parityajyAsmAbhi rvAsarIyA sajjA paridhAtavyA| ");
INSERT INTO sanhk_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","ato heto rvayaM divA vihitaM sadAcaraNam AcariSyAmaH| raGgaraso mattatvaM lampaTatvaM kAmukatvaM vivAda IrSyA caitAni parityakSyAmaH| ");
INSERT INTO sanhk_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","yUyaM prabhuyIzukhrISTarUpaM paricchadaM paridhaddhvaM sukhAbhilASapUraNAya zArIrikAcaraNaM mAcarata| ");
INSERT INTO sanhk_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","yo jano'dRDhavizvAsastaM yuSmAkaM saGginaM kuruta kintu sandehavicArArthaM nahi| ");
INSERT INTO sanhk_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","yato niSiddhaM kimapi khAdyadravyaM nAsti, kasyacijjanasya pratyaya etAdRzo vidyate kintvadRDhavizvAsaH kazcidaparo janaH kevalaM zAkaM bhuGktaM| ");
INSERT INTO sanhk_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","tarhi yo janaH sAdhAraNaM dravyaM bhuGkte sa vizeSadravyabhoktAraM nAvajAnIyAt tathA vizeSadravyabhoktApi sAdhAraNadravyabhoktAraM doSiNaM na kuryyAt, yasmAd Izvarastam agRhlAt| ");
INSERT INTO sanhk_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","he paradAsasya dUSayitastvaM kaH? nijaprabhoH samIpe tena padasthena padacyutena vA bhavitavyaM sa ca padastha eva bhaviSyati yata IzvarastaM padasthaM karttuM zaknoti| ");
INSERT INTO sanhk_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","aparaJca kazcijjano dinAd dinaM vizeSaM manyate kazcittuु sarvvANi dinAni samAnAni manyate, ekaiko janaH svIyamanasi vivicya nizcinotu| ");
INSERT INTO sanhk_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","yo janaH kiJcana dinaM vizeSaM manyate sa prabhubhaktyA tan manyate, yazca janaH kimapi dinaM vizeSaM na manyate so'pi prabhubhaktyA tanna manyate; aparaJca yaH sarvvANi bhakSyadravyANi bhuGkte sa prabhubhaktayA tAni bhuGkte yataH sa IzvaraM dhanyaM vakti, yazca na bhuGkte so'pi prabhubhaktyaiva na bhuJjAna IzvaraM dhanyaM brUte| ");
INSERT INTO sanhk_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","aparam asmAkaM kazcit nijanimittaM prANAn dhArayati nijanimittaM mriyate vA tanna; ");
INSERT INTO sanhk_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","kintu yadi vayaM prANAn dhArayAmastarhi prabhunimittaM dhArayAmaH, yadi ca prANAn tyajAmastarhyapi prabhunimittaM tyajAmaH, ataeva jIvane maraNe vA vayaM prabhorevAsmahe| ");
INSERT INTO sanhk_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","yato jIvanto mRtAzcetyubhayeSAM lokAnAM prabhutvaprAptyarthaM khrISTo mRta utthitaH punarjIvitazca| ");
INSERT INTO sanhk_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","kintu tvaM nijaM bhrAtaraM kuto dUSayasi? tathA tvaM nijaM bhrAtaraM kutastucchaM jAnAsi? khrISTasya vicArasiMhAsanasya sammukhe sarvvairasmAbhirupasthAtavyaM; ");
INSERT INTO sanhk_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","yAdRzaM likhitam Aste, parezaH zapathaM kurvvan vAkyametat purAvadat| sarvvo janaH samIpe me jAnupAtaM kariSyati| jihvaikaikA tathezasya nighnatvaM svIkariSyati| ");
INSERT INTO sanhk_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","ataeva IzvarasamIpe'smAkam ekaikajanena nijA kathA kathayitavyA| ");
INSERT INTO sanhk_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","itthaM sati vayam adyArabhya parasparaM na dUSayantaH svabhrAtu rvighno vyAghAto vA yanna jAyeta tAdRzImIhAM kurmmahe| ");
INSERT INTO sanhk_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","kimapi vastu svabhAvato nAzuci bhavatItyahaM jAne tathA prabhunA yIzukhrISTenApi nizcitaM jAne, kintu yo jano yad dravyam apavitraM jAnIte tasya kRte tad apavitram Aste| ");
INSERT INTO sanhk_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","ataeva tava bhakSyadravyeNa tava bhrAtA zokAnvito bhavati tarhi tvaM bhrAtaraM prati premnA nAcarasi| khrISTo yasya kRte svaprANAn vyayitavAn tvaM nijena bhakSyadravyeNa taM na nAzaya| ");
INSERT INTO sanhk_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","aparaM yuSmAkam uttamaM karmma ninditaM na bhavatu| ");
INSERT INTO sanhk_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","bhakSyaM peyaJcezvararAjyasya sAro nahi, kintu puNyaM zAntizca pavitreNAtmanA jAta Anandazca| ");
INSERT INTO sanhk_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","etai ryo janaH khrISTaM sevate, sa evezvarasya tuSTikaro manuSyaizca sukhyAtaH| ");
INSERT INTO sanhk_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","ataeva yenAsmAkaM sarvveSAM parasparam aikyaM niSThA ca jAyate tadevAsmAbhi ryatitavyaM| ");
INSERT INTO sanhk_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","bhakSyArtham Izvarasya karmmaNo hAniM mA janayata; sarvvaM vastu pavitramiti satyaM tathApi yo jano yad bhuktvA vighnaM labhate tadarthaM tad bhadraM nahi| ");
INSERT INTO sanhk_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","tava mAMsabhakSaNasurApAnAdibhiH kriyAbhi ryadi tava bhrAtuH pAdaskhalanaM vighno vA cAJcalyaM vA jAyate tarhi tadbhojanapAnayostyAgo bhadraH| ");
INSERT INTO sanhk_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","yadi tava pratyayastiSThati tarhIzvarasya gocare svAntare taM gopaya; yo janaH svamatena svaM doSiNaM na karoti sa eva dhanyaH| ");
INSERT INTO sanhk_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","kintu yaH kazcit saMzayya bhuGkte'rthAt na pratItya bhuGkte, sa evAvazyaM daNDArho bhaviSyati, yato yat pratyayajaM nahi tadeva pApamayaM bhavati| ");
INSERT INTO sanhk_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","balavadbhirasmAbhi rdurbbalAnAM daurbbalyaM soDhavyaM na ca sveSAm iSTAcAra AcaritavyaH| ");
INSERT INTO sanhk_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","asmAkam ekaiko janaH svasamIpavAsino hitArthaM niSThArthaJca tasyaiveSTAcAram Acaratu| ");
INSERT INTO sanhk_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","yataH khrISTo'pi nijeSTAcAraM nAcaritavAn, yathA likhitam Aste, tvannindakagaNasyaiva nindAbhi rnindito'smyahaM| ");
INSERT INTO sanhk_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","aparaJca vayaM yat sahiSNutAsAntvanayo rjanakena zAstreNa pratyAzAM labhemahi tannimittaM pUrvvakAle likhitAni sarvvavacanAnyasmAkam upadezArthameva lilikhire| ");
INSERT INTO sanhk_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","sahiSNutAsAntvanayorAkaro ya IzvaraH sa evaM karotu yat prabhu ryIzukhrISTa iva yuSmAkam ekajano'nyajanena sArddhaM manasa aikyam Acaret; ");
INSERT INTO sanhk_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","yUyaJca sarvva ekacittA bhUtvA mukhaikenevAsmatprabhuyIzukhrISTasya piturIzvarasya guNAn kIrttayeta| ");
INSERT INTO sanhk_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","aparam Izvarasya mahimnaH prakAzArthaM khrISTo yathA yuSmAn pratyagRhlAt tathA yuSmAkamapyeko jano'nyajanaM pratigRhlAtu| ");
INSERT INTO sanhk_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","yathA likhitam Aste, ato'haM sammukhe tiSThan bhinnadezanivAsinAM| stuvaMstvAM parigAsyAmi tava nAmni parezvara|| ");
INSERT INTO sanhk_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","tasya dayAlutvAcca bhinnajAtIyA yad Izvarasya guNAn kIrttayeyustadarthaM yIzuH khrISTastvakchedaniyamasya nighno'bhavad ityahaM vadAmi| yathA likhitam Aste, ato'haM sammukhe tiSThan bhinnadezanivAsinAM| stuvaMstvAM parigAsyAmi tava nAmni parezvara|| ");
INSERT INTO sanhk_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","aparamapi likhitam Aste, he anyajAtayo yUyaM samaM nandata tajjanaiH| ");
INSERT INTO sanhk_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","punazca likhitam Aste, he sarvvadezino yUyaM dhanyaM brUta parezvaraM| he tadIyanarA yUyaM kurudhvaM tatprazaMsanaM|| ");
INSERT INTO sanhk_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","apara yIzAyiyo'pi lilekha, yIzayasya tu yat mUlaM tat prakAziSyate tadA| sarvvajAtIyanRNAJca zAsakaH samudeSyati| tatrAnyadezilokaizca pratyAzA prakariSyate|| ");
INSERT INTO sanhk_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","ataeva yUyaM pavitrasyAtmanaH prabhAvAd yat sampUrNAM pratyAzAM lapsyadhve tadarthaM tatpratyAzAjanaka IzvaraH pratyayena yuSmAn zAntyAnandAbhyAM sampUrNAn karotu| ");
INSERT INTO sanhk_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","he bhrAtaro yUyaM sadbhAvayuktAH sarvvaprakAreNa jJAnena ca sampUrNAH parasparopadeze ca tatparA ityahaM nizcitaM jAnAmi, ");
INSERT INTO sanhk_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","tathApyahaM yat pragalbhataro bhavan yuSmAn prabodhayAmi tasyaikaM kAraNamidaM| ");
INSERT INTO sanhk_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","bhinnajAtIyAH pavitreNAtmanA pAvitanaivedyarUpA bhUtvA yad grAhyA bhaveyustannimittamaham Izvarasya susaMvAdaM pracArayituM bhinnajAtIyAnAM madhye yIzukhrISTasya sevakatvaM dAnaM IzvarAt labdhavAnasmi| ");
INSERT INTO sanhk_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","IzvaraM prati yIzukhrISTena mama zlAghAkaraNasya kAraNam Aste| ");
INSERT INTO sanhk_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","bhinnadezina AjJAgrAhiNaH karttuM khrISTo vAkyena kriyayA ca, AzcaryyalakSaNaizcitrakriyAbhiH pavitrasyAtmanaH prabhAvena ca yAni karmmANi mayA sAdhitavAn, ");
INSERT INTO sanhk_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","kevalaM tAnyeva vinAnyasya kasyacit karmmaNo varNanAM karttuM pragalbho na bhavAmi| tasmAt A yirUzAlama illUrikaM yAvat sarvvatra khrISTasya susaMvAdaM prAcArayaM| ");
INSERT INTO sanhk_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","anyena nicitAyAM bhittAvahaM yanna nicinomi tannimittaM yatra yatra sthAne khrISTasya nAma kadApi kenApi na jJApitaM tatra tatra susaMvAdaM pracArayitum ahaM yate| ");
INSERT INTO sanhk_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","yAdRzaM likhitam Aste, yai rvArttA tasya na prAptA darzanaM taistu lapsyate| yaizca naiva zrutaM kiJcit boddhuM zakSyanti te janAH|| ");
INSERT INTO sanhk_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","tasmAd yuSmatsamIpagamanAd ahaM muhurmuhu rnivArito'bhavaM| ");
INSERT INTO sanhk_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","kintvidAnIm atra pradezeSu mayA na gataM sthAnaM kimapi nAvaziSyate yuSmatsamIpaM gantuM bahuvatsarAnArabhya mAmakInAkAGkSA ca vidyata iti hetoH ");
INSERT INTO sanhk_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","spAniyAdezagamanakAle'haM yuSmanmadhyena gacchan yuSmAn AlokiSye, tataH paraM yuSmatsambhASaNena tRptiM parilabhya taddezagamanArthaM yuSmAbhi rvisarjayiSye, IdRzI madIyA pratyAzA vidyate| ");
INSERT INTO sanhk_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","kintu sAmprataM pavitralokAnAM sevanAya yirUzAlamnagaraM vrajAmi| ");
INSERT INTO sanhk_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","yato yirUzAlamasthapavitralokAnAM madhye ye daridrA arthavizrANanena tAnupakarttuM mAkidaniyAdezIyA AkhAyAdezIyAzca lokA aicchan| ");
INSERT INTO sanhk_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","eSA teSAM sadicchA yataste teSAm RNinaH santi yato heto rbhinnajAtIyA yeSAM paramArthasyAMzino jAtA aihikaviSaye teSAmupakArastaiH karttavyaH| ");
INSERT INTO sanhk_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","ato mayA tat karmma sAdhayitvA tasmin phale tebhyaH samarpite yuSmanmadhyena spAniyAdezo gamiSyate| ");
INSERT INTO sanhk_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","yuSmatsamIpe mamAgamanasamaye khrISTasya susaMvAdasya pUrNavareNa sambalitaH san aham AgamiSyAmi iti mayA jJAyate| ");
INSERT INTO sanhk_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","he bhrAtRgaNa prabho ryIzukhrISTasya nAmnA pavitrasyAtmAnaH premnA ca vinaye'haM ");
INSERT INTO sanhk_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","yihUdAdezasthAnAm avizvAsilokAnAM karebhyo yadahaM rakSAM labheya madIyaitena sevanakarmmaNA ca yad yirUzAlamasthAH pavitralokAstuSyeyuH, ");
INSERT INTO sanhk_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","tadarthaM yUyaM matkRta IzvarAya prArthayamANA yatadhvaM tenAham IzvarecchayA sAnandaM yuSmatsamIpaM gatvA yuSmAbhiH sahitaH prANAn ApyAyituM pArayiSyAmi| ");
INSERT INTO sanhk_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","zAntidAyaka Izvaro yuSmAkaM sarvveSAM saGgI bhUyAt| iti| ");
INSERT INTO sanhk_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","kiMkrIyAnagarIyadharmmasamAjasya paricArikA yA phaibInAmikAsmAkaM dharmmabhaginI tasyAH kRte'haM yuSmAn nivedayAmi, ");
INSERT INTO sanhk_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","yUyaM tAM prabhumAzritAM vijJAya tasyA AtithyaM pavitralokArhaM kurudhvaM, yuSmattastasyA ya upakAro bhavituM zaknoti taM kurudhvaM, yasmAt tayA bahUnAM mama copakAraH kRtaH| ");
INSERT INTO sanhk_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","aparaJca khrISTasya yIzoH karmmaNi mama sahakAriNau mama prANarakSArthaJca svaprANAn paNIkRtavantau yau priSkillAkkilau tau mama namaskAraM jJApayadhvaM| ");
INSERT INTO sanhk_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","tAbhyAm upakArAptiH kevalaM mayA svIkarttavyeti nahi bhinnadezIyaiH sarvvadharmmasamAjairapi| ");
INSERT INTO sanhk_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","aparaJca tayo rgRhe sthitAn dharmmasamAjalokAn mama namaskAraM jJApayadhvaM| tadvat AziyAdeze khrISTasya pakSe prathamajAtaphalasvarUpo ya ipenitanAmA mama priyabandhustamapi mama namaskAraM jJApayadhvaM| ");
INSERT INTO sanhk_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","aparaM bahuzrameNAsmAn asevata yA mariyam tAmapi namaskAraM jJApayadhvaM| ");
INSERT INTO sanhk_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","aparaJca preriteSu khyAtakIrttI madagre khrISTAzritau mama svajAtIyau sahabandinau ca yAvAndranIkayUniyau tau mama namaskAraM jJApayadhvaM| ");
INSERT INTO sanhk_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","tathA prabhau matpriyatamam Ampliyamapi mama namaskAraM jJApayadhvaM| ");
INSERT INTO sanhk_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","aparaM khrISTasevAyAM mama sahakAriNam UrbbANaM mama priyatamaM stAkhuJca mama namaskAraM jJApayadhvaM| ");
INSERT INTO sanhk_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","aparaM khrISTena parIkSitam ApilliM mama namaskAraM vadata, AriSTabUlasya parijanAMzca mama namaskAraM jJApayadhvaM| ");
INSERT INTO sanhk_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","aparaM mama jJAtiM herodiyonaM mama namaskAraM vadata, tathA nArkisasya parivArANAM madhye ye prabhumAzritAstAn mama namaskAraM vadata| ");
INSERT INTO sanhk_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","aparaM prabhoH sevAyAM parizramakAriNyau truphenAtruphoSe mama namaskAraM vadata, tathA prabhoH sevAyAm atyantaM parizramakAriNI yA priyA parSistAM namaskAraM jJApayadhvaM| ");
INSERT INTO sanhk_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","aparaM prabhorabhirucitaM rUphaM mama dharmmamAtA yA tasya mAtA tAmapi namaskAraM vadata| ");
INSERT INTO sanhk_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","aparam asuMkRtaM phligonaM harmmaM pAtrabaM harmmim eteSAM saGgibhrAtRgaNaJca namaskAraM jJApayadhvaM| ");
INSERT INTO sanhk_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","aparaM philalago yUliyA nIriyastasya bhaginyalumpA caitAn etaiH sArddhaM yAvantaH pavitralokA Asate tAnapi namaskAraM jJApayadhvaM| ");
INSERT INTO sanhk_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","yUyaM parasparaM pavitracumbanena namaskurudhvaM| khrISTasya dharmmasamAjagaNo yuSmAn namaskurute| ");
INSERT INTO sanhk_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","he bhrAtaro yuSmAn vinaye'haM yuSmAbhi ryA zikSA labdhA tAm atikramya ye vicchedAn vighnAMzca kurvvanti tAn nizcinuta teSAM saGgaM varjayata ca| ");
INSERT INTO sanhk_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","yatastAdRzA lokA asmAkaM prabho ryIzukhrISTasya dAsA iti nahi kintu svodarasyaiva dAsAH; aparaM praNayavacanai rmadhuravAkyaizca saralalokAnAM manAMsi mohayanti| ");
INSERT INTO sanhk_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","yuSmAkam AjJAgrAhitvaM sarvvatra sarvvai rjJAtaM tato'haM yuSmAsu sAnando'bhavaM tathApi yUyaM yat satjJAnena jJAninaH kujJAneे cAtatparA bhaveteti mamAbhilASaH| ");
INSERT INTO sanhk_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","adhikantu zAntidAyaka IzvaraH zaitAnam avilambaM yuSmAkaM padAnAm adho marddiSyati| asmAkaM prabhu ryIzukhrISTo yuSmAsu prasAdaM kriyAt| iti| ");
INSERT INTO sanhk_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","mama sahakArI tImathiyo mama jJAtayo lUkiyo yAson sosipAtrazceme yuSmAn namaskurvvante| ");
INSERT INTO sanhk_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","aparam etatpatralekhakastarttiyanAmAhamapi prabho rnAmnA yuSmAn namaskaromi| ");
INSERT INTO sanhk_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","tathA kRtsnadharmmasamAjasya mama cAtithyakArI gAyo yuSmAn namaskaroti| aparam etannagarasya dhanarakSaka irAstaH kkArttanAmakazcaiko bhrAtA tAvapi yuSmAn namaskurutaH| ");
INSERT INTO sanhk_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","asmAkaM prabhu ryIzukhrISTA yuSmAsu sarvveSu prasAdaM kriyAt| iti| ");
INSERT INTO sanhk_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","pUrvvakAlikayugeSu pracchannA yA mantraNAdhunA prakAzitA bhUtvA bhaviSyadvAdilikhitagranthagaNasya pramANAd vizvAsena grahaNArthaM sadAtanasyezvarasyAjJayA sarvvadezIyalokAn jJApyate, ");
INSERT INTO sanhk_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","tasyA mantraNAyA jJAnaM labdhvA mayA yaH susaMvAdo yIzukhrISTamadhi pracAryyate, tadanusArAd yuSmAn dharmme susthirAn karttuM samartho yo'dvitIyaH ");
INSERT INTO sanhk_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","sarvvajJa Izvarastasya dhanyavAdo yIzukhrISTena santataM bhUyAt| iti|");
INSERT INTO sanhk_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","yAvantaH pavitrA lokAH sveSAm asmAkaJca vasatisthAneSvasmAkaM prabho ryIzoH khrISTasya nAmnA prArthayante taiH sahAhUtAnAM khrISTena yIzunA pavitrIkRtAnAM lokAnAM ya IzvarIyadharmmasamAjaH karinthanagare vidyate ");
INSERT INTO sanhk_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","taM pratIzvarasyecchayAhUto yIzukhrISTasya preritaH paulaH sosthininAmA bhrAtA ca patraM likhati| ");
INSERT INTO sanhk_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","asmAkaM pitrezvareNa prabhunA yIzukhrISTena ca prasAdaH zAntizca yuSmabhyaM dIyatAM| ");
INSERT INTO sanhk_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Izvaro yIzukhrISTena yuSmAn prati prasAdaM prakAzitavAn, tasmAdahaM yuSmannimittaM sarvvadA madIyezvaraM dhanyaM vadAmi| ");
INSERT INTO sanhk_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","khrISTasambandhIyaM sAkSyaM yuSmAkaM madhye yena prakAreNa sapramANam abhavat ");
INSERT INTO sanhk_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","tena yUyaM khrISTAt sarvvavidhavaktRtAjJAnAdIni sarvvadhanAni labdhavantaH| ");
INSERT INTO sanhk_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","tato'smatprabho ryIzukhrISTasya punarAgamanaM pratIkSamANAnAM yuSmAkaM kasyApi varasyAbhAvo na bhavati| ");
INSERT INTO sanhk_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","aparam asmAkaM prabho ryIzukhrISTasya divase yUyaM yannirddoSA bhaveta tadarthaM saeva yAvadantaM yuSmAn susthirAn kariSyati| ");
INSERT INTO sanhk_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","ya IzvaraH svaputrasyAsmatprabho ryIzukhrISTasyAMzinaH karttuM yuSmAn AhUtavAn sa vizvasanIyaH| ");
INSERT INTO sanhk_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","he bhrAtaraH, asmAkaM prabhuyIzukhrISTasya nAmnA yuSmAn vinaye'haM sarvvai ryuSmAbhirekarUpANi vAkyAni kathyantAM yuSmanmadhye bhinnasaGghAtA na bhavantu manovicArayoraikyena yuSmAkaM siddhatvaM bhavatu| ");
INSERT INTO sanhk_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","he mama bhrAtaro yuSmanmadhye vivAdA jAtA iti vArttAmahaM kloyyAH parijanai rjJApitaH| ");
INSERT INTO sanhk_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","mamAbhipretamidaM yuSmAkaM kazcit kazcid vadati paulasya ziSyo'ham ApalloH ziSyo'haM kaiphAH ziSyo'haM khrISTasya ziSyo'hamiti ca| ");
INSERT INTO sanhk_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","khrISTasya kiM vibhedaH kRtaH? paulaH kiM yuSmatkRte kruze hataH? paulasya nAmnA vA yUyaM kiM majjitAH? ");
INSERT INTO sanhk_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","kriSpagAyau vinA yuSmAkaM madhye'nyaH ko'pi mayA na majjita iti hetoraham IzvaraM dhanyaM vadAmi| ");
INSERT INTO sanhk_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","etena mama nAmnA mAnavA mayA majjitA iti vaktuM kenApi na zakyate| ");
INSERT INTO sanhk_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","aparaM stiphAnasya parijanA mayA majjitAstadanyaH kazcid yanmayA majjitastadahaM na vedmi| ");
INSERT INTO sanhk_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","khrISTenAhaM majjanArthaM na preritaH kintu susaMvAdasya pracArArthameva; so'pi vAkpaTutayA mayA na pracAritavyaH, yatastathA pracArite khrISTasya kruze mRtyuH phalahIno bhaviSyati| ");
INSERT INTO sanhk_